﻿USE sofia;
DROP TABLE IF EXISTS sofia.ignNT_vpl;
CREATE TABLE ignNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ignNT_vpl WRITE;
INSERT INTO ignNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nuvaraha numeta­caheya mayehe ema Jesucristo. Éma, vijaneanahi israelítahi, taicha eta mámarié­que­nérahi ema viáchucaini Abraham. Éneri­chuvare, ema Jesús rey-yarehi taicha eta mámarié­que­nérahi ema víyarahaini rey David. Eta juca eta nalista ena máchucae­que­neanaini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ema víyarahaini Abraham, macachichapa ema Isaac. Ema Isaac macachichapa ema Jacob. Ema Jacob macachichapa ema Judá énapa ena apamuriana mapara­pe­naveana. ");
INSERT INTO ignNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ema Judá macachichapa ema Fares émapa ema Zara. (Esu naena ticaijaru Tamar.) Ema Fares macachichapa ema Esrom. Ema Esrom macachichapa ema Aram. ");
INSERT INTO ignNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ema Aram macachichapa ema Aminadab. Ema Aminadab macachichapa ema Naasón. Ema Naasón macachichapa ema Salmón. ");
INSERT INTO ignNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ema Salmón macachichapa ema Booz. (Esu maena ticaijaru Rahab.) Ema Booz macachichapa ema Obed. (Esu maena ticaijaru Rut.) Ema Obed macachichapa ema Isaí. ");
INSERT INTO ignNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ema Isaí macachichapa ema rey David. Ema rey David macachichapa ema Salomón. (Esu máenaini ticaijaru Betseba, esu mayenainihi ema Urías.) ");
INSERT INTO ignNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ema Salomón macachichapa ema Roboam. Ema Roboam macachichapa ema Abías. Ema Abías macachichapa ema Asa. ");
INSERT INTO ignNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ema Asa macachichapa ema Josafat. Ema Josafat macachichapa ema Joram. Ema Joram macachichapa ema Uzías. ");
INSERT INTO ignNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ema Uzías macachichapa ema Jotam. Ema Jotam macachichapa ema Acaz. Ema Acaz macachichapa ema Ezequías. ");
INSERT INTO ignNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ema Ezequías macachichapa ema Manasés. Ema Manasés macachichapa ema Amón. Ema Amón macachichapa ema Josías. ");
INSERT INTO ignNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ema Josías macachichapa ema Jeconías énapa ena mapara­pe­naveana, ena nacara­ta­ruanahi námaque­neanahi ena apavasana ticava­sanahi te Babilonia. ");
INSERT INTO ignNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te táequenepa eta juca, ema Jeconías macachichapa ema Salatiel. Ema Salatiel macachichapa ema Zorobabel. ");
INSERT INTO ignNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ema Zorobabel macachichapa ema Abiud. Ema Abiud macachichapa ema Eliaquim. Ema Eliaquim macachichapa ema Azor. ");
INSERT INTO ignNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ema Azor macachichapa ema Sadoc. Ema Sadoc macachichapa ema Aquim. Ema Aquim macachichapa ema Eliud. ");
INSERT INTO ignNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ema Eliud macachichapa ema Eleazar. Ema Eleazar macachichapa ema Matán. Ema Matán macachichapa ema Jacob. ");
INSERT INTO ignNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ema Jacob macachichapa ema José, ema suímahi esu María, máenahi ema Jesús, ema ticaijare Cristo, ema vicucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tacahe, catorce­muriana ena mámarié­qé­que­nea­nainihi ema Abraham. Ema rey David, émapa náichecuinehi eta natupa. Tacahe, ema rey David, catorce­mu­ria­navare ena mámarie­que­nea­nainihi. Ena nacara­ta­ruanahi námaque­neanahi ena apava­sanana te Babilonia, énapa náichecuinehi eta natupa. Ema Jeconías, catorce­muriana ena mámarié­que­nea­nainihi. Ema Jesucristo, émapa náichecuinehi eta natupa. ");
INSERT INTO ignNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ani tacahehi eta máuchusirahi ema Jesucristo. Esu maena María, tráturipahi eta suítauchi­ra­yarehi ema José. Vuíchahasera nacacha­ne­ca­cahini. Ticaja­ri­pa­hisera ésu, mávajue­chirahi ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ema José, tétavi­cavahi eta máuriva. Eta tacahe, vahi tisemaimahi. Váhivare mavara­hahini máimica­tsi­ria­cahini esu María. Mavara­ha­hisera macaepaha eta matratune suyehe ésu. Váhisera mávara­hahini náechahini ena achaneana eta tacaye­ma­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ema Viya máimara­racahi eta mapane­reruhi. Eta tacahe, tiúcupaicapa ema ángele mameta­panahi te mavapure ema José. Ánipa máicha: —Tata José, tímite­canuhi numeta­panavi eta juca: Vahi picueñamava eta pítauchi­rayare esu María. Tájina píchavaimahi. Taicha ticaja­ripahi ésu, mávajue­chirahi ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tacahe, te máuchucapa ema suchichayare, enacayare eta máijareyare JESÚS. Éma ticatiu­chayare ena achaneana tayehe eta naviure­va­na­ya­rehini taicha eta napeca­turana —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(Títaucha­vapahi tamutu eta juca máechaji­ri­ru­vanahi ema Viya mayehe ema víyarahaini profeta Isaías. ");
INSERT INTO ignNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ani tacahehi: “Sutiari­hiyare esu amaperu esena témuna­hi­ri­cavaya ticajari. Ema suchichayare, yátupi­que­neyare eta émaira Viya, tiúcupau­cha­ha­viyare ticatiu­cha­ha­vi­pa­nayare” tacahepa.) ");
INSERT INTO ignNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tacahe, te téjamiu­chavapa ema José eta macava­pu­reirahi, ichape­rinehi eta masuapirahi eta máechaji­ri­ru­vanahi ema ángele mavaneruhi ema Viya, eta máitauchi­ra­yarehi esu María. ");
INSERT INTO ignNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Váhisera náneca­cahini te jena cájeanahi eta sucaja­rirahi. Tacahe, suínacapa ema suárachichahi. Nanacapa eta máijarehi JESÚS. ");
INSERT INTO ignNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Eta máuchusinehi ema Jesús te avasare ticaijare Belén tayehe eta departamento Judea. Te jena año, ema Aluresi ema tayehehi rey eta Judea. Tásiha, títeca­panapa te Jerusalén ena reye mágoana tiásihanahi te tayere­hiquene avasare tinapaica te táuchusine eta sache. ");
INSERT INTO ignNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nacaya­se­se­re­ru­paipahi, ánipa nacahe: —Víti, tímite­cahavi eta vitanu­sirahi ema amuya máuchurehi rey-yarehi eyehe eti israelítana. Taicha vímahahi eta arairu jarairiqui, vémetearuhi máicutiarahi ema Viya eta máuchusinehi ema amuya rey-yare. Titupihapa eta te juca eyehe. Puiti vivarahahi véjira­pa­nayare éma. ¿Távihapuca mávihahi ema amuya? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te masamai­ri­ricapa ema Aluresi, ichape­rinehi eta mapane­ré­que­ne­háirahi. Vaipa máurisa­mu­rehíni. Ena achaneana te tajuhe eta avasare, éneri­chuvare napane­ré­que­nehahi éna apanavare eta juca téchacarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tacahe, ema Aluresi máimichu­ha­vacapa namutu ena tuparai­ru­cana énapa ena títurue­que­nehana eta Sagrada Escritura. Mayase­re­ca­vacapa: —¿Távihapuca máuchusi­ha­yarehi ema vicucha­pa­quenehi ticaija­reyare Cristo? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Éna najicapapa: —Te Belén te tachacaya eta juca viávasa Jerusalén. Taicha tacahehi eta májurehi ema víyarahaini profetaini Isaías. Máechajicahi éma eta avasare tímícu­ti­ji­ri­cavahi eta achané­nahini. Ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Piti avasare Belén, tachichavihi eta Judea, picuna­cha­ca­re­pá­nayare píti. Taicha eta máuchusi­ha­yarehi piyehe ema ichape­que­ne­yarehi eta maháque­nu­cá­vayare. Éma, téchapa­ji­ri­mu­ri­hayare namutu ena vijaneanana israelítana”. ");
INSERT INTO ignNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tacahe, te masamapa ema Aluresi, máichuha­vacapa ena mágoana. Mañaji­cha­muripa, taicha mavaraha máechaya tájamu­hupuca te tépana­vainapa náimahapa eta jarairiqui. ");
INSERT INTO ignNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te máechapa, mavane­ca­vacapa éna te Belén. Máichapa: —Eyana etanuca ema amuya te Belén. Te étupia­capuca, echava emeta­ca­nuyare, apaesa nuyana núti apanavare néjira­pa­nayare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tacahe, ena mágoana, eta nasamirahi, tiyana­na­varepa. Tásiha, náimaha­varepa eta jarairiqui náehirupahi. Tiyanapa te namirahu. Étapa te Belén eta tatupi­haiyahi, te táinahu eta mávihahi ema amuya. ");
INSERT INTO ignNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tétavicava eta náurisa­mu­revahi ena mágoana eta náimairahi eta tatupi­hai­raripa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Títeca­pá­na­vanepa eta te peti mávihahi ema amuya. Náimahapa éma, ésupa esu maena María. Tásiha, tépuyu­canapa natsiucapa ema amuya. Navecuhapa eta námava­hua­napahi. Náijara­ca­sichapa eta oro, eta incienso étapa eta táijiyequene perfume. ");
INSERT INTO ignNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te táequenepa eta náejirairahi ema amuya, tichava­na­yarepa te návasa. Apana­pasera eta achene eta nayani­hapahi, taicha ticame­ta­ca­sianapa te navapure vaipa nacueta­vajica te mávihahi ema Aluresi. ");
INSERT INTO ignNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tacahe, te táequenepa eta nayanirahi ena mágoana, tiúcupaicapa ema émana ángele mavaneruhi ema Viya, mameta­pa­na­yarehi ema José te mavapure. Ánipa máicha: —Péchepuca, José. Piyana piáma ema amuya ésupa esu María tayehe eta Egipto. Pinasiyare ánaqui. Tiámainucava te numeta­ca­vivare eta pichavi­rainapa, taicha ema Aluresi títecayare matanu­cayare ema amuya, mavarairahi macapa­cayare —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tacahesera ema José téchepucapa. Tétupi­rí­ca­va­na­vanepa te jena yati. Tiyananapa námapa ema amuya tayehe eta Egipto. ");
INSERT INTO ignNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nanasipa ánaqui. Tiámainucava te tépenapa ema Aluresi, ticava­na­hia­na­varepa mayehe ema ángele eta nachavi­rayare. Tamutu eta juca títauchavahi eta juca mametarapi ema Viya eta te Sagrada Escritura, ani macahehi: “Te Egipto nímiju­naiyahi ema nuchicha. Te táequenepa, níchuha­yarepa éma”. ");
INSERT INTO ignNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tacahe, ema Aluresi te masamai­ri­ricapa eta nánucui­raripa ena mágoana, tisema­rinehi eta navayua­sirahi. Máimiva­ne­recapa nacapa­pa­ji­capana namutu ena amuyana ajairana tiávihanahi te Belén énapa ena tiávihanahi te tachaca­ya­rahana, ena ticaye­hea­naripa apina año énapa ena náuchusi­rávana. Máepanae­que­nehapa eta táuchusihahi eta jarairiqui náimaha­quenehi ena mágoana. ");
INSERT INTO ignNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tacahe, te Belén eta táitauchi­ravahi eta májucha­quenehi ema víyarahaini profetaini Jeremías. Ani tacahehi: ");
INSERT INTO ignNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tétavi­cavahi eta najapa­nui­ravahi ena esenana. Ichape eta náiyairahi taicha ena suntaruana nacapa­pa­ji­sirahi ena nachicha­naveana. Nájina narata­hahini nacama­ti­na­cahini taicha eta najapa­nui­ravahi ichape” tacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tacahe, te jácani año te táequenepa eta máepenirahi ema Aluresi, tiápecha­va­varepa ema ángele máechajicahi ema José te mavapure ánaqui te Egipto. Ánipa maicha: ");
INSERT INTO ignNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Péchepuca, José. Piveha ema amuya ésupa esu maena. Piyana pichava te piávasa Israel taicha vaipa táeñama­vacare. Tépenaipahi ema tipane­reu­chainihi ticapa­ca­ya­rehini ema amuya —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jéhesare, ema José téchepucapa. Tétupi­ri­cavapa, ésupa esu maena ema amuya. Tiyananapa tichavanahi tayehe eta návasa. ");
INSERT INTO ignNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tacahe, eta napaisi­rapahi eta nachavirapa tayehe eta návasa, masamai­ri­ricapa ema José eta mavira­vaipahi aquenuca ema Arquelao, machicha ema Aluresini. Tipicapa ema José machavahini tayehe eta Belén. Tásiha, ema ángele mápecha­varepa máechajicahi te mavapure eta matupi­rui­ra­yarepa te Nazaret te tinapaica Galilea. ");
INSERT INTO ignNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te títeca­panapa, ánaqui étapa náejasihahi. Tacahehi eta táitauchi­ravahi eta táechaji­ri­ru­vanahi eta Sagrada Escritura nájureanahi ena profetanaini eta macaija­re­ra­yarehi Nazareno ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tacahe, te jácani treinta áñohi, matiari­hi­hivare ema achane ticaijare Juan. Éma, máichuha­quenehi ema Viya eta macame­ta­rai­rui­rayare, máetupi­ri­ca­va­cayare ena achaneana. Tacahe, masuapahi eta matupa­rahahi. Tiyanapa vámahi­cu­ruhapa. Váipa avasa­re­cu­ru­hai­nahini. Ticame­ta­rai­rupaipa nayehe ena macuti­que­neanahi vámahi­cu­ruhana, ticava­sanahi te tachausi eta Jordán te tinapaicahi eta Judea. ");
INSERT INTO ignNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ánipa macahehi eta máimitu­re­sirahi: —Ítsivacha eta epane­reruana. Éneuchava mayehe ema Viya, taicha máraja­painapa ema aquenu­cayare mavaneruhi ema Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ánaquia­pa­ripahi eta áñoana acane, ema Viya mametacapa ema víyarahaini profeta Isaías eta mapane­reruhi, eta mavane­si­rayare ema Machicha te juca apaquehe, ticatiu­ra­hi­yarehi eta tímite­ca­yarehi. Éneri­chuvare matiari­hi­yareva ema apana achane máichuha­que­ne­yarehi ema Viya. Macame­ta­rai­ru­yarehi, máetupi­ri­ca­va­cayare ena achaneana, náinaji­si­ra­yarehi eta napane­reruana tamauri­queneana, apaesa táuri eta najaca­pi­rayare ema Machicha ema Viya. Émaripa ema Juan, ema máechaji­si­ha­quenehi ema Viya, máetupi­ri­ca­va­cayare ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ema Juan, vanairucahi me Viya, profetahi éma. Eta mamuirihahi eta náitsameru tajiyaha eta náitátiquene ticaijare camello. Eta máitijuhe, vácapi jayumepi. Eta maniriji manicasare eta tsacara. Eta matítivera eta mápama. ");
INSERT INTO ignNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tiyana­navare nacapayaca ena achaneana ticavasana te Jerusalén, navarairahi nasama­raraca eta máechaji­si­haquene; énapa ena ticavasana te Judea, énapa ena tiávihanahi tayehe eta cajacure Jordán. ");
INSERT INTO ignNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tacahe, eta nametau­re­si­ravaipa, navarai­ra­hivare náinajica eta napeca­turana, ema Juan máicacha­si­ca­va­capaipa te cajacure Jordán. ");
INSERT INTO ignNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Énaripa ena fariséoana énapa ena saducéoana nayanau­cha­hivare ema Juan. Vahi náeneucha­vahini, navara­ha­hisera ticaica­chasiana. Tacahe, ema Juan máichavacapa: —¿Tájaha tacayema eta epauchi­ranuhi, eti tachicha­na­vea­na­tataji eta quichare? Esamai­ri­ri­ca­hipuca eta járaja­pai­ra­yarepa eta táiñehi­que­neyare ecuñaraqui. Evara­ha­hipuca iúchucu­hayare. ");
INSERT INTO ignNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tiuri puiti, te evara­hapuca eta iúchucuha, yátupina tátupiruva eta epane­reruana. Ímerecava eta ínaji­siraya eta epeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Váhivare ecuca­ja­murava eta mámarié­que­ne­hái­rahehi ema viáchucaini Abraham. Taicha tayanapane mámari­hepuca éma, váhisera iúchucu­haimahi te vahi ecuitsivacha eta epane­reruana. Ema Viya, tájina máemaitu­caimahi éma. Te mávara­hapuca, vahi máejeca­ra­chaimahi máepiyaca achaneanaina eta juca mari, mavarai­rainahi yátupina ena mámarie­que­neanaina ema Abraham. ");
INSERT INTO ignNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ecauneuchava, taicha tiánehipa eta táiteca­pau­chi­ra­ha­viyare eta ecuñaraqui nayehe ena achaneana máituca­ra­hanahi téneuchavana, váhivare náitsiva­chahini eta napane­reruana. Tímicu­ti­ji­rí­cavaipa te máechuca­yarepa ema achane eta yucuqui máhireana. Ticaechu­yarehi tamutu eta tapareana. Tíjuyarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yátupi núti nícacha­si­cahehi te une, te éneuchava mayehe ema Viya. Ávane­pai­pa­hisera mácani ema yátupiquene Cristo. Te yátupina ecasiñava mayehe, tícacha­si­ca­he­yareva; tíjara­ca­he­yareva ema Espíritu Santo. Téhesera vahi ecuca­si­ña­vapuca mayehe, tícuña­ca­heyare tayehe eta táijurequene yucu. Éma, ichape­quenehi nuyehe núti. Váiparinehi nácuti­na­simahi eta máitupa­ji­jia­si­ravahi. Váipari­ne­hivare nácaemu­ña­vaimahi macamu­su­ra­nuhini núti páuresami. ");
INSERT INTO ignNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Puiti éma máraja­painapa tinere­ji­ri­cainapa nácani yátupi­queneana téhicana. Máunacainapa éna. Ticutinapa mácani achane te tiácata­ya­jirica eta arusu. Máunacainapa. Tásiha, máquijicapa eta tapiraquiji. Máijucha­yarepa te yucu. Eta nacaheyare ena máurira­hanahi, tíjuanáinapa te yucu, máitava­ca­ca­yarehi eta namuruira —máichavacapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tacahe, títeca­pa­varepa ema Jesús te cajacure Jordán te mávihahi ema Juan. Éma, másihapahi te tinapaica eta Galilea. Mavarahahi ticaica­cha­siyare mayehe ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Émasera ema Juan, vahi mávara­hahini máicacha­si­cahini. Ánipa macahe: —Tata Jesús, nútira táuricahi nútivaina pícacha­sicanu. Nusapihapa núti picaiju­henuhi eta nícacha­si­caviya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Émasera ema Jesús majicapapa: —Tájinachucha táichava. Ticamu­nu­carehi nítauchayare eta mavara­ha­quenehi ema Nucaiyaquene —máichapa. Tásiha, ema Juan tísapavapa. ");
INSERT INTO ignNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te tamutupa eta macaica­cha­sirahi ema Jesús, tiúcupaicapa tayehe eta une. Tásiha, tíjahú­chavapa téjiaca eta anuma. Máimahapa ema Espíritu Santo tiúcupai­ca­paipahi, mavasi­ma­hipaipa eta paloma. Tavene­sicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tacahe, tiárami­carepa eta mahu ema Viya tásiha­quenehi te anuma, ánipa macahe: —Ema maca ema yátupi­quenehi nuchicha némuna­ru­quenehi. Tétavi­cavahi eta núrisa­mu­revahi máicha —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tacahe, ema Espíritu Santo enurujipa máimitu­caipahi ema Jesús eta mayaniraya te mávapahi apaquehe. Ánaqui macucha­pa­yarehi eta máitsama­ra­jiyare ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tájina manicahini ema Jesús te jena cuarenta­quenehi sache, cuarentavare yati eta mayerevahi. Ichapepa eta máecuavahi. ");
INSERT INTO ignNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tásiha, ema Váinaraji témeña­havapa mayehe. Mavarahapa macaete­ma­yarehi. Ánipa máicha: —¿Pécuhapa píti? Tacahe, pivaneca eta juca mari táepiyacava pan, taicha píti machichavihi ema Viya, ¿masi? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ema Jesús majicapapa: —Váhipuca pecha eta táechaji­ri­ruvahi eta Sagrada Escritura, ani tacahehi: “Vahi tacari­chuimahi eta tinicacare ticaita­re­cayare ena achaneana. Tacacha­ne­yarehi eta máechaji­ri­ruvana ema Viya. Jéhevare, éta ticaita­re­ca­ra­hiyare” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tásiha, ema Váinaraji mámavarepa tayehe eta tacapi­ca­huquene avasare Jerusalén. Máimiapanapa te táinahu eta Templo. ");
INSERT INTO ignNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tásiha, máichapa: —Te yátupina machichavina ema Viya, písapa­vayare pémirica te apaquehe. Tájina píchavaimahi eta pémiri­si­rayare. Pécharichuhi eta táechaji­riruva eta Sagrada Escritura, ani tacahe: “Ema Viya mavanecapa ena mayeheana ángeleana téchapa­ji­ri­caviana. Tiámavia­nayare te navahuana, apaesa vahi picuca­yutetu eta máriana eta te pipaisi­rayare” tacahepa. Tásiha, németeaca tijanea­ca­via­nayare puiti, vahi náisapaimahi picajara te pémirica —máichapa ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tacahe, ema Jesús majica­pa­varepa: —Éneri­chuvare ani tacahe eta Sagrada Escritura: “Vahi picaitsa­ma­ra­jimahi ema Viya, taicha Piáquenuhi éma” —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tacahe, ema Váinaraji mámavarepa te táinahu eta anuquehe mari cerro. Máimechapa tamutu eta ichape­queneana avasareana te juca apaquehe ticuti­rinehi tacacha­ca­ya­ji­ri­ca­cahini taicha eta máitupa­ji­jia­si­ra­va­hicacha ema Váinaraji. Máimecha­varepa eta ichape­queneana náimaha­queneana ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tacahe, máichapa: —Núti níjara­ca­viyare tamutu eta juca avasareana. Pítina náquenuvina ena távacuanahi eta avasareana. Pépuyu­ca­nu­masera te numirahu. Pitsiucanu apaesa níjara­ca­vi­sarepa tamutu —máichapa ema Vainaraji. ");
INSERT INTO ignNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Émasera ema Jesús majicapapa: —Pévuisi­ha­tataji piti Satanás te juca numirahu. Váhipuca pecha eta táechaji­ri­ruvahi eta Sagrada Escritura. Ani tacahehi: “Macarichu ema Viya vépuyu­mi­rau­chayare. Macari­chuvare vicaema­ta­nea­cayare” tacahepa. Váhiquene táurica nucaema­ta­nea­ca­vihini —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tacahe, ema Váinaraji téraji­cavapa. Majuni­jicapa ema Jesús. Tásiha, tiúcupai­canapa ena ángeleana, náechapa­ji­ricapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tacahe, te jena sácheana, nacara­tacapa ema Juan. Námapa te jácani tayere­hiquene. Tacahe, ema Jesús, eta masamai­ri­ri­sirapa eta macaera­tairahi te cárcel ema macheji Juan, tiyanapa tichava te mávasa Nazaret te Galilea. ");
INSERT INTO ignNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","17","Váipasera mánasihini te majuru­sinehi. Tiyanapa tayehe eta avasare Caperaum. Étapa máejasihahi. Eta juca avasare távihahi te tachausi eta cáquiure Galilea. Eta macame­ta­rai­ruirahi, tamutuhi mapaica eta tinapaica eta provincia Galilea —Éneuchava mayehe ema Viya. Ítsivacha eta epane­reruana, taicha tiánehi eta sácheyare tímere­cavaya eyehe ema ticatiu­cha­heyare. Aquenu­cayare mavaneruhi ema Viya, téchaheyare éma —máichavacapa. Eta juca títauchavahi eta májureanahi ema víyarahaini profeta Isaías, ani tacahehi: “Tiúrica­ca­rea­nainapa ena achaneana cávasanahi te tachausi eta cáquiure Galilea tayehe eta provincia Zabalón étapa eta Neftalí, namutu támairiaca ena ticavasana te apachara eta Jordán. Éna, tiyerehi eta nacata­ji­vai­ranahi, tacuti eta tavayureva eta tamapicuva. Puítisera máiteca­pau­cha­va­ca­ripahi ema timícau­cha­murihi. Ticatiu­cha­va­ca­yarehi tayehe eta nacata­ji­vairahi. Éma, tétume­cha­va­ca­hivare eta mamícau­chi­ra­vacahi” tacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tacahe, eta mapaisi­rapahi ema Jesús te tachausi eta cáquiure Galilea, máimaha­vacapa ena apinana ajairana, ema ticaijarehi Simón Pedro émapa ema maparape Andrés. Eta náemata­nerepi ena nani, ténica­ra­hianahi. Náquijie­recahi eta nayehe tarrafa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tacahe, ema Jesús máichuha­vacapa: —Yare, éhicanu. Núti níjara­ca­heyare eta apana émata­ne­re­piyare. Éti ítuca­va­pa­racahi eta jímana; tacaheyare eta ítusi­ra­va­yareva ena achaneana, machane­ra­nayare ema Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Enevanepa náinajicapa éna eta náenisirahi. Tiyananapa náehicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ánaqui­pa­na­varepa máimaha­varepa ema Jesús ena apinana ticapa­ra­pe­cá­ca­navare: ema Jacobo émapa ema Juan. Téjacanahi te napacure. Matiari­hi­hivare ema naiya Zebedeo. Náititi­ji­ricahi eta nayehe tarrafa. Ema Jesús máichuha­varepa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Enurujipa náehicavare. Nanaqui­ca­varepa eta napacure, émapa ema naiya. Najuni­ji­ca­varepa. ");
INSERT INTO ignNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Eta mapaisirahi ema Jesús tayehe eta avasareana te Galilea, máimitu­ca­va­capahi ena achaneana te sávaru­muhuana tayehe eta náuruji­si­ra­revana. Mavanecapa eta náeneuchi­ravaina taicha tiánehipa eta sácheyare tímere­ca­vayare ema ticatiu­chayare, ema aquenu­cayare mavaneruhi ema Viya. Éneri­chuvare ema Jesús macana­ra­ca­pa­hivare tamutu eta apana­pa­ne­que­neanahi jumareana eta najuma­napahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tacahe, nasamai­ri­ricapa ena achaneana ticava­sanahi eta tasimu­tu­queneana avasareana te tinapaica eta Siria. Tásiha, námava­capaipa ena nacaju­ma­queneana, apana­pa­ne­ne­ji­quenehi eta najumana, nacati­ru­ha­vanahi. Énaripa ena návahá­ruanahi ena éreanana, ena tirapa­pasiana, énapa ena muraca­quihana. Namutu ena nani, macana­ra­ca­va­capahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tacahe, camuriana ena achaneana téhicanahi éma. Éna, tiásihana te Galilea, te Judea, te Jerusalén, te avasareana tinapaica eta Decápolis, étapa te apachara eta Jordán. ");
INSERT INTO ignNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tacahe, eta máimaira­vacahi ema Jesús ena camuri­queneana achaneana, tiápanapa tayehe eta anuque­hepahi apaquehe taicha tiúripanahi eta nasama­ra­ra­si­ra­yarehi ena achaneana. Téjacaripa éma, énapa ena máimitureana nachaya­caipahi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ani tacahehi eta máimitu­ra­pianahi: ");
INSERT INTO ignNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ena náimatihi eta tacamu­nu­que­neanahi eta náchanevana, tétavi­cavahi eta náurica­ca­revaya taicha máejerare eta najaca­pi­rayare eta máechaji­riruva ema Viya, machane­ra­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ena nani tijapa­nu­ji­ri­ca­vanahi, tétavi­cavahi eta náurica­careva taicha émaripa ema Viya macuri­sa­mu­re­cha­va­cayare. ");
INSERT INTO ignNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ena nani tisuapa­ji­ra­hianahi me Viya, mánsuanahi mayehe, tétavi­cavahi eta náurica­careva taicha máijara­rua­nayare eta arairu apaquehe náicuchihi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ena nani, ichape eta najamu­ra­chirahi eta náitare­sirahi eta matapi­ra­vacare te mamirahu ema Viya, tétavi­cavahi eta náurica­ca­revaya taicha máijara­cayare éma eta navara­ha­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ena nani tijapa­nu­ra­hianahi nayehe ena apamuriana achaneana, tétavicava eta náurica­ca­revaya; taicha ema Viya, éma apanava majapa­nu­va­cayare éna. ");
INSERT INTO ignNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ena nani vahi náisapa­ji­rí­ca­vahíni tahapa­pi­cahini eta náehisirahi ema Viya, tétavi­cavahi eta náurica­ca­revaya; taicha éna, títeca­pa­nainapa te mamirahu ema Viya, náimara­ra­cainapa éma. ");
INSERT INTO ignNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ena nani ticonse­ja­ra­hianahi nayeheana ena achaneana, nacaepa­hairahi eta semanereana, tétavicava eta náurica­ca­revaya éna; taicha máimereu­chainapa ema Viya eta machichai­ra­vacahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ena nani ticata­ji­vanahi eta nacatia­na­ca­sivahi nayehe ena achaneana te juca apaquehe táichavenehi eta táurivahi eta náitare­sirahi, tétavi­cavahi eta náurica­ca­revaya; taicha éna aquenu­ca­ra­hanaya majupa­ha­nayare ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Eti nuchane­ranahi, járaja­painapa eta sache eta nacatia­na­si­raheya ena achaneana táichavenehi eta éhisi­ranuhi. Tipana­ra­ra­cha­hea­nainapa, tépiyae­que­ne­ha­hea­nai­na­varepa. Váhisera ecuarami eta juca. Ene nacahehi eta nacata­ji­vairahi ena profetanaini, ena náinapu­reanahi machane­ranahi ema Viya. Eta tacahe, te nacatia­na­ca­hepuca, ¡ecuri­sa­mu­re­cha­vachucha, evapi­na­vachucha! ¡Tétavi­cavahi eta iúrica­careva taicha ejaca­payare eta ícuchiyare te anuma, taicha ichape eta macuna­chi­rahehi ema Viya! ");
INSERT INTO ignNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Eti ímiya­na­vayare eta ecamu­nu­ca­re­ravahi nayehe ena achaneana, tacutihi eta tacamu­nu­ca­revahi eta icheve. Vahi tacuepaha eta ecamu­nu­careva. Vahi ecucuti eta tajachira eta icheve, taicha tájina eta táicheve­vai­nahíni. Tásiha, nájinapa ticamu­nuimahi. Náepuruinapa namutu. ");
INSERT INTO ignNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tacutiquene éti ecutihi eta tijarahi. Éti, namica­hu­yarehi namutu ena achaneana eta ímitu­si­ra­vacaya, apaesa náinajica eta náehisirahi eta tamauri­queneana. Ímereu­cha­ya­re­hivare eta iúriva, ecutiya eta avasare tiávihahi te tajirumane eta anuquehe mari. ");
INSERT INTO ignNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tacutiquene, vahi ecucuti nácani súnsuana tiyusta­canahi jácani lámpara, tásiha nanaca­pa­pucaini te tajuhe eta cajune, nayumu­ru­si­hahini. Nanaca­ya­re­hisera te anuquehe apaesa náimairi­ri­ca­sarepa namutu ena tiávihanahi te peti, tamicau­rea­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ene ecaheyare éti, ímere­cayare eta ejarai­vayare nayehe ena achaneana apaesa eta náimairainahi eta táuriqueneana íchaque­nea­nayare; tásiha nacuna­chainapa ema Tata Vicaiyaquene tiávihahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Vahi étaina tímite­canuhi núti nucaepa­hahini eta mavanai­ripiana ema víyarahaini Moisés, étaripa eta náimitu­ra­pianaini ena profetanaini. Eta tímite­canuhi núti, nímine­ca­pae­que­ne­ha­heyare eta nájureanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nutupiruva numetacahe: Títauchavaya tamutu eta máechaji­ri­ruvana ema Tata. Tímiyanava eta tasuapa­ca­reirahi nayehe ena achaneana tamutu eta Sagrada Escritura. Tájina ticaepa­haimahi, tayanapane táitavapuca eta anuma étapuca eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eta tacahe, nácani tépurua­nayare eta tavanai­ri­pianahi eta Sagrada Escritura, jácani ánichi­cha­quenehi, vahi tisiapa­naimahi te anuma. Tavetijipa te náimitu­capuca ena apamuriana eta náepuruiraya. Nácanisera tisuapa­na­yarehi, tímitu­re­ca­na­hivare eta juca nayehe ena apamuriana achaneana eta náehisiraina; éna, ichapeyare eta nacuna­cha­ca­re­vayare eta nasiapiraipa te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Táicha te evaraha ítujicava esiapa te anuma, tacamunuhi tiápaju­cavaya eta táurivahi eta eyehe­repiana éti, ecachu­ri­cayare eta nayehe­re­pianahi ena escribá­noana, énapa ena fariséoana. ");
INSERT INTO ignNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Eti écharichucha eta nayehe­repiana ena iáchuca­na­veanaini ani tacahe: “Vahi ecucapaca mácani piparaepiya; taicha mácani ticapa­recahi, ticaicu­ña­yarehi”. ");
INSERT INTO ignNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nútisera numetacahe eta apana: Mácani tisemahi mayehe ema maparape, éneri­chuvare ticaicu­ñayare. Mácani tiúmehahi ema maparape, ticaya­se­re­hiyare te namirahu nácani tuparai­ru­canahi tayehe eta avasare. Tacutiquene mácani ticaecahihi ema maparape, mávacu­haipahi eta ecuñaraqui tayehe eta infierno. ");
INSERT INTO ignNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eta tacahe, te piámapahi eta piámavahu te mamirahu ema Viya, tásiha, péchapa­nai­na­papuca eta pitapi­ravahi mayehe ema piparape. ");
INSERT INTO ignNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Vuíchaha picuiya­racuha eta piámavahu. Tativa­nu­mayare piyasea­panaya eta perdón ema piparape. Pétupi­ri­ca­nu­mayare tativa eta píchava­que­nevahi mayehe éma. Táurica­sarepa pichava píyara­cu­ha­pa­nainapa eta piámavahu te mamirahu ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tacutiquene te matiari­hi­ya­repuca mavaraha mametauchavi te namirahu ena tuparai­rucana, vahi picucuchapa mametauchavi. Tativayare pétupirica eta píchava­que­nevahi mayehe, mapurare vuíchaha picaera­tahini mayehe ema juez tayehe eta cárcel. ");
INSERT INTO ignNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Taicha te náimisia­pavipa tayehe eta cárcel, ticaje­rae­que­nénapa eta piúchusiraya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Éneri­chuvare écharichuhi éti eta náimitu­rapihi ena iáchuca­na­veanaini: “Vahi ecuveha esu apana esena”. ");
INSERT INTO ignNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Puítisera núti numetacahe eta apana: Mácani majamu­rachahi esu apana esena, ticape­ca­tu­raipahi te masamure taicha eta majamu­ra­chirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eta tacahe, eta iúquiha váure, te tavara­hapuca tímiaqui­paicahe tayehe eta pecatu, tavarairahi táimahayare eta tamauri­queneana tájipa­racana, tiúripana evecu­hau­quichava iáquijicaya. Taicha tiúripanahi táejiacava ánichichaina te iáquehe, váhisera tacuimi­cu­ñacahe eta te yucu infierno, tamutupahi eta iáquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Étaripa eta evahu váure, te tavara­hapuca tímiaqui­pai­ca­heyare tayehe eta pecatu, tapami­si­ra­hé­na­papuca íchayare eta tamauri­queneana, tiúripana eyuchatica iáquijica. Taicha tiúripanahi táejiacava eta evahu, váhisera tacuimi­ca­siapahe támutu eta iáquehe tayehe eta yucu infierno. ");
INSERT INTO ignNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Éneri­chuvare ena viáchuca­na­veanaini náisapahi eta máejerare eta máinajisira mácani achane esu mayena. Ani nacahehi: “Mácani tínajicahi esu mayena, máemepi­ya­recahi eta ajumeruca táechaji­si­ha­yarehi eta máinaji­siraya esu mayena”. ");
INSERT INTO ignNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nútisera numetacahe eta apana: Mácani achane, te máinaji­capuca esu mayena, ticape­ca­tu­raipahi me Viya. (Váhiné­nipuca sucaeca­hihini mayehe ema apana achane.) Éneri­chuvare te tiápecha­va­hipuca ticaima ésu, tamuriacahi ésu eta maviurevahi ema suima. Tásiha, mácani arairuhi suima, émapa tamuriacahi eta máejeca­pi­ravahi taicha eta mavirahi esu esena sucaima­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Éneri­chuvare esamai­ri­ri­cavare eta náimitu­ca­sivahi ena iáchuca­na­veanaini: “Machu vahi ecuitaucha jácani ejura­chi­ra­hipuca. Yátupi­nasera eta ítauchiraina tamutu eta íjara­si­ravahi me Viáquenu” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nútisera numetacahe éti: Vahi táuricahini íchahini eta juramento. Vaipa échaji­si­hahini eta anuma taicha éta, mávacurehi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Váipavare échaji­si­hahini eta apaquehe taicha éta, macaema­ta­néyahi éma. Váipavare échaji­si­hahini eta Jerusalén, taicha éta, mávacu­re­yarehi ema yátupi­quenehi Rey, mavane­ruyare ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Váipavare échaji­si­hahini eta ejura­chirahi te echuti, taicha vahi árata­haimahi ehapa­mai­chahini, ítsiva­chi­rahini eta táimahi, tijapupuca, tiquisapuca. ");
INSERT INTO ignNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Numetacahe: Te tatiari­hipuca eta íjara­si­ra­vayare, átupiruva ácahe: “Tiuri”. Te váhipuca evarahahi, átupiruva: “Vahi” ácahe. Te émuna­ha­ca­vapuca ejuracha, ema Váinaraji títuru­ca­heripa. ");
INSERT INTO ignNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Éneri­chuvare esamai­ri­ricahi eta acane: “Mácani achane téhara­recahi mapuchu­quichahi ema apana achane, éneri­chuvare éma napuchu­qui­cha­yareva ena tuparai­rucana. Te macave­tu­quia­he­cha­hipuca, éneri­chuvare nacave­tu­quia­he­cha­yareva ena tuparai­rucana”. ");
INSERT INTO ignNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nútisera numetacahe: Vahi ecujicapa te masema mácani achane váinarajihi. Tiúripana, te náehahepuca nácani te emira, íjara­cayare eta apachacaya eta emira. ");
INSERT INTO ignNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tacutiquene, te natiari­hipuca ena timetau­chaheana, navaraha navere­jicahe eta ecamisa, vahi ecusema. Váhivare ecuji­ca­pairihi. Íjara­cavare eta apana eta epacuha. ");
INSERT INTO ignNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ísapayare te nácani navane­ca­hepuca eta enara­cureca eta tijitacare. Te navaraha iámina étanaina kilómetro, evapinava eta eservi­chi­ra­vacaina. Vahi ecobra­cha­va­caimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mácaniripa tájahapuca mayaseacahe, íjara­cayare. Vahi ecueñamiha mácani ticapucahe eta ecaye­he­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Éneri­chuvare esamai­ri­ricahi eta acane eta náimitu­ca­sivahi ena iáchuca­na­veanaini: “Émuna­sirahi nácani témuna­caheanahi. Tásiha, ecati­cha­yarepa nácani ticatia­na­ca­heanahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nútisera numetacahe: Émuna­ca­yareva nácani ticatia­na­ca­heanahi. Eyaseaca ema Viya eta nayuja­rahuina nácani téchaji­canahi eyehe. Ímereca eta iúriva nayehe nácani ticati­cha­heanahi. Eyujaraucha nácani tiúmeha­heanahi ticaete­ma­ji­ri­ca­heanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te ítaucha eta juca, éta tímereu­cha­heyare eta machicha­héirahi ema Vicaiyaquene te anuma. Taicha éma nájina manere­jiruina, namutu máemuna­cavaca: ena achaneana váinarajiana, énapa ena tiúriana. Éma, tíjara­cahavi vimutu eta sache vimícahuhi, étapa eta tiquiva. ");
INSERT INTO ignNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Éti, tájina ecuna­cha­ca­revaina eta me Viya, te nacarichuhi émunaca nácani témuna­ca­heanahi éti. Apanasica ena tisipe­ca­tu­ra­ra­hiana náichahi eta juca. ");
INSERT INTO ignNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tacutiquene, tájinavare ecuna­cha­ca­revaina eta me Viya, te iúriyare nacarichuhi ena epara­pe­na­veanahi. Apanasica ena máimati­ra­hanahi ema Viya tiúrianahi eta nayehe ena napara­pe­naveana. Étisera tatupa­racahe ecachu­ri­cayare eta iúriva. ");
INSERT INTO ignNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tétavi­ca­va­sareya eta iúriva nayehe namutu. Vahi enere­ji­caimahi ena achaneana. Váhivare eyava­naimahi eta iúriva. Ecutiyare ema Vicaiyaquene te anuma eta máurivahi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Eta ecaji­rayare ena páureana, échapa­vayare. Ema Tata Vicaiyaquene, tájina ticuna­cha­hemahi te evara­hapuca náimaha ena achaneana eta ecajirahi, evarairahi ticuna­cha­hea­nayare. Tájinavare máitsiri­ji­ca­vahini éma eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eta tacahe, te ímica­ta­ca­ya­repuca nácani ticamu­nu­vanahi, vahi ecume­ta­jirica. Vahi ecucuti ena apimirana timeta­ji­ri­canapa te viúruji­si­ra­revana, téhepa te aneca­pahiana. Eta juca náichahi, navarairahi ticuna­cha­ca­rea­na­yarehi nayehe ena achaneana. Nútisera numetacahe: Ena nani ticaheanahi, tájina nacuna­cha­ca­re­vaimahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Te jácani píjaraca nácani ticamu­nu­vanahi piyehe, vahi picume­ta­jirica. Váhivare picumetaca nácani pémuna­ca­sareana. ");
INSERT INTO ignNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Piñaji­chayare eta píjara­si­rayare nácani píjara­ca­si­ruyare. Tacahe, ema Tata Vicaiyaquene te anuma máimara­racahi tamutu. Jácani píchaqueneana tayumu­ru­revana, éma títsiri­jie­que­ne­hayare, tíjara­ca­viyare eta pícuchihi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Te eyuja­racahi, vahi ecucuti ena apimirana tiyuja­racana te viúruji­si­ra­revana, téhepuca te aneca­pahiana. Titupi­hanahi éna eta nayuja­ra­sirahi, navarairahi náimara­ra­ca­yarehi ena achaneana. Nútisera numetacahe: Tájinachucha nacuna­cha­ca­re­vaimahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Étisera ani tacaheyare te eyujaraca. Esiapayare te eyehe cuarto, érata­cayare eta tapaja. Eñaji­cha­vayare eta échaji­si­rayare ema Tata Vicaiyaquene. Éma, tímara­ra­ca­havihi; masama­yarehi eta piyuja­racasa. ");
INSERT INTO ignNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tacutiquene, váhivare ecuape­pirica eta ecaye­ma­que­nea­nayare. Vaipa tácame­sahini eápepi­ri­cahini eta eyuja­ra­sirahi. Vahi ecucuti ena máimati­ra­hanahi ema Viya. Tiúpiemanapa eta nayuja­ra­sirahi, náimijachaipa tisama­ca­reanahi mayehe ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Vahi ecucuti éna, taicha ema Viya máimati­ripahi éma jácani vivara­ha­quenehi viyaseaca. ");
INSERT INTO ignNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Éti, ani tacaheya eta eyuja­rau­chi­ravaina: Tata Vicaiyaquene, piti piáviha te anuma, vipicauchahi yátupi eta píjare. ");
INSERT INTO ignNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Vivaraha ichapeina eta tasuapa­ca­revaina eta pivanai­ripiana nayehe namutu ena achaneana ani te apaquehe, tacuti eta nasuapi­ravihi ena ángeleana te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pájapa­nuhavi píjara­cahavi puiti jena sache eta vicamu­nuirava eta vinica­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pájapa­nuhavi piperdo­na­chahavi eta viviurevana piyehe, tacuti eta viperdo­nachira víti ena ticaviu­revana viyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Vahi picuisa­pahavi eta vicha eta tamauriquene. Picatiu­cha­ha­vivare mayehe ema Váinaraji. Taicha píti yátupi­que­nevihi Viáquenuvihi. Nájina pácuti eta pítupa­ji­jia­si­ravahi. Máichecua­raquire eta pijaraivahi. Amén. ");
INSERT INTO ignNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Taicha te yátupihi eta eperdo­na­chirahi nácani ticaviu­re­vanahi eyehe, ema Tata Vicaiyaquene te anuma tiperdo­na­cha­heyare éti apanava. ");
INSERT INTO ignNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Téhesera te vahi eperdo­nachahi ena ticaviu­re­vanahi eyehe, ema Tata Vicaiyaquene váhivare tiperdo­na­cha­hémahi eta éjeca­pi­ra­vanahi éti. ");
INSERT INTO ignNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tacutiquene, te ayuna­hepuca, vahi ecaja­pa­nu­ra­mi­raimahi te namirahu ena achaneana. Vahi ecucuti ena apimirana ena tímicae­che­ra­cha­vanahi eta ayunai­ranahi. Núti numetacahe: Tájinachucha nacuna­cha­ca­re­vaimahi me Viya. Éma, váhivare títsiri­ji­ca­vaimahi eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Étisera, te ayuna­hepuca, ímiyanava eta esipau­qui­chi­ravaya, etata­si­ca­vavare, apaesa nacuija nacuima­tiacahe eta ayunai­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ema Tata Vicaiyaquene tímara­ra­cahehi tamutu eta esamureana. Tisama­ca­re­yarehi eta eyasearuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Váhivare tacuava­sa­mu­re­recahe eta ímaha­queneana te juca apaquehe. Eta juca ticami­tie­que­ne­ha­careana taicha eta tajara­resira eta cachusiri, étapa eta táichasi­vayare. Natiari­hivare ena tiámeye­cha­hea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Epane­re­chasera eta ecaima­ha­que­neraya te anuma. Ánaqui jararihi eta táitsivayare eta íchirahi eta táuriqueneana te juca apaquehe. Ánaqui, tájina cachusirina, nájinavare tiámerahina tayehe. Tájina témitia­caimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Éti, te ecasa­mu­repuca eta ímaha­que­neanahi te juca apaquehe, evarahahi enasiyare te juca. Vahi ávara­hahini ejuni­ji­cahini eta ímaha­queneana. Téhesera te ecasa­mu­re­hi­chapuca eta ícuchiana te anuma, ánaqui evara­hayare eyana­va­neyare. ");
INSERT INTO ignNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Tacutiquene, ecuneuchava, machu tacueta­viuchava eta ejamu­rachira eta ímaha­queneana. Ecara­tacava, vahi ecuisapa tahapa­sa­mu­rechahe eta ecaima­ha­que­nerahi. Taicha te tahapa­sa­mu­re­ru­he­papuca eta ímahaquene, tétavi­cavahi eta tamapi­cuvahi eta te iáchanevana. Téhesera esuapa eta nímitu­rapiana, tétavi­cavahi eta tamicau­chiraya eta iáchanevana, tímiju­ni­ji­cayare eta emaurivahi, étapa eta ejamu­ra­chi­ravahi eta ímaha­queneana. Eta tacahe, machu ísapava tayanariana eta timapicu eta te iáchane­va­nasami. ¡Páurehesami éti te ísapa­vapuca tanasipa! ");
INSERT INTO ignNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tacutiquene éti, eta ítare­sirahi, vahi táuricahini apina­nai­nahini ena iáquenuana. Taicha émuna­ca­pa­na­yarehi ema émana, tisuapa­ca­re­pa­na­ya­re­hivare; tásiha ema apana, apaesa­rineya eta émuna­siraya, váipainapa tisuapa­ca­remahi éma. Ene tacahehi eta juca ímaha­queneana, vahi ecuisapa tahapa­sa­mu­rechahe eta plata, machu tahapa­pirica eta émuna­sirahi ema Viya, étapa eta ecaema­ta­nea­sirahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","26","Étasera nuvaraha yátupina eta ecasi­ña­vairaina mayehe ema Tata Vicaiyaquene. Vahi ecucae­ña­ma­ra­cavaicha tayehe eta enica­que­nerepi étapa eta emuiri­harapi puiti juca ítare­si­raichaha. Eta enica­que­nerepi, étapa eta emuiri­harapi, tájina táeñama­va­ca­re­vahini. Ímara­ra­ca­richuhi eta cáyureana. Vahi táevacahini, váhivare táechati­ji­ri­cahini, táunaca­hi­pucaini eta tanica­que­neyare. Émasera ema Tata Vicaiyaquene máechapa­ji­ricahi, máijara­sirahi tamutu eta tanica­que­ne­repiana. Evetijipa éti, iápaju­pa­navahi eta éñama­ca­révahi me Viya tayehe eta cáyureana. ");
INSERT INTO ignNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tájina táuricahíni eta éñami­ravahi eta júcana. Éti, nájina tirata­haimahi étiji­vai­nahini ecaju­ru­ca­vahini, tayanapane tahapa­sa­mu­re­cha­he­hipuca. ");
INSERT INTO ignNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tacahe, ¿tájaha tacayema tihapa­sa­mu­re­re­cahehi eta emuiri­harapi? Ímara­ra­ca­richuhi eta tajuru­sirahi eta flúreana, vahi tacaeña­ma­ra­ca­vahini tacaema­ta­nehini, táijuru­re­ca­hi­pucaini. ");
INSERT INTO ignNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Táitsiva­hisera, te tépunehapa, tétavi­cavahi táurinavahi eta taflurene. Nájina tácuti eta nacamui­rihaira eta táurinava, émaripa ema víyarahaini rey Salomón eta tajanu­nusira eta macamui­ri­hairahi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Apana­sicahi, ema Viya máijaracahi eta táurinavahi, ánipi­ri­chu­hinéni eta táitare­sirahi. Evetijipa éti eta máechapa­ji­ri­si­rahehi, máijara­si­ra­he­yarehi eta emuiri­harapi eti achaneana. ¿Tájaha tacayema vahi ácasi­ña­vahíni eta mayehe? ");
INSERT INTO ignNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eta tacahe, vahi ecucae­ña­ma­ra­cavaicha tayehe eta enica­que­ne­repiana étaripa te echuri­ria­capuca eta une érayare, váhivare eta emuiri­harapi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ena achaneana vahi náimatihini ema Viya, ichape­murihi eta tacaeña­ma­ra­si­ra­vacahi eta júcana. Vahi nácasi­ña­vahini mayehe ema Viya, nacucha­pa­hi­pu­cahini eta máijara­ru­yarehi éma. Étisera, écharine eta marari­hirahi ema Ecaiyaquene te anuma. Máimatihi éma tamutu eta ecamu­nu­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tásihasera éti, tativayare íjaracava ecaema­ta­neacaya ema Viya, ecasa­mu­reirahi eta ítauchi­rayare tamutu eta mavara­ha­que­neanahi. Tihapa­sa­mu­re­cha­he­ya­re­hivare eta tátupi­ru­vairaya eta ítaresira, ecuri­sa­mu­re­chi­rayare éma. Máimaha­rinepa éma. Tíjara­ca­heyare tamutu eta juca ecamu­nu­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eta tacahe, ácasiñava mayehe éma. Vahi tacuimi­pa­ne­rechahe eta íchara­ra­ca­vayare achichu. Puiti ecuchapaipa eta máimica­ta­si­ra­heyare. Ímiyanava eta ecucha­pi­rayare eta máimica­ta­si­raheya. ");
INSERT INTO ignNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Vahi ecunemahi eta náejeca­pi­ravana ena apamuriana achaneana, váhivare ecucae­ca­hivaca, machu étaina táimicu­ñacahe me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Te ecune­ra­hipuca nayehe ena apamuriana achaneana, ecaheyare éti eta macune­ra­hénapa ema Viya tayehe tamutu eta éjeca­pi­rá­vanahi éti. ");
INSERT INTO ignNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Piti ajaira, pítipa piti esena, vahi táurica eta picunerahi eta ánichi­cha­queneana náejeca­pi­ra­vanahi éna. Titupa­racavi pítijivaina picuneuchava eta táichapeva eta péjeca­pirava. ");
INSERT INTO ignNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Vahi tatupa­ra­ca­vimahi pétupirica eta jácani náejeca­pi­ravahi ichipichuana ena piparae­piyana. Tájina piviyahini eta piconse­ja­chi­haimahi. Ichapesera eta tatupa­ra­si­ravihi pétupirica eta péjeca­pi­ra­vanahi píti. Tapaenumava pétupirica eta píchava­que­né­vanahi, táuricapaini piconsejacha ema piparaepiya tayehe eta máichava­que­névahi. ");
INSERT INTO ignNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Vahi ecuimituca eta máechaji­ri­ruvana ema Viya nácani achaneana ticaeca­hi­rahiana, taicha váiparinehi náuricaimahi. Machu étaina táemehahe. Váhivare ecuijaraca jácani téñama­careana, machu nácata­ya­yajica. ");
INSERT INTO ignNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Ánivare tacahe eta máechaji­riruva ema Jesús: —Numetacahe: Échajica ema Tata Vicaiyaquene. Eyasea­cayare eta ecamu­nu­queneana. Éma, tijapa­nurahi. Tisama­heyare, tíjara­ca­he­yareva. Vahi ecuyacuji eta eyasea­siraina. Éneri­chuvare, te tatiari­hi­na­papuca eta jácani íchiraya ichapehi eta tacaje­ra­va­yarehi, eyasea­cayare máijara­ca­hehini eta ítupa­ji­jia­si­ravaya. Éma, tíjara­ca­heyare. Te jarari­hipuca eta táicheji­mi­ráuchahe, éma macaevui­si­na­he­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Eta juca tímicu­ti­ji­ri­cavahi te natiari­hipuca ena echicha­na­veanahi éti, te tiyasea­ca­hea­napuca eta pan nanicayare, váiparinehi táuricaimahi íjara­cahini éti eta márijahi. Tímicu­ti­ji­ricava evija­rui­nahini ena echicha­naveana. ");
INSERT INTO ignNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Étaripa te tiyasea­ca­hea­napuca eta jima, váhivare táuricaimahi íjara­caimahi eta quichare. ");
INSERT INTO ignNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Etiarihi éti vahi ecaji­ra­hihini nayehe ena achaneana. Iúrihisera nayehe ena echicha­naveana. Mavetijicha ema Tata Ecaiyaquene tiávihahi te anuma. Éma, vahi ticavi­ja­ru­hemahi eta eyase­serepi. Tíjara­ca­he­yarehi tamutu eta táuriqueneana eyasea­rua­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Evaraha eta náurivaina ena achaneana eta eyehe, ¿masi? Tásiha, táuricahi eta íchiraya eta iúriva nayehe. Taicha eta tacahehi eta táimiturapi eta Sagrada Escritura eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Esama­nuchaha. Jararihi eta apina achene. Eta ichape achene, vahi tácajéra eta náehisira ena achaneana. Camuria­napana ena téhicana eta ticaijuhe tayehe eta ecuñaraqui. Étasera eta achene ánicu­chi­charichu, ticaijuhe tayehe eta vítare­si­rayare, tájina ecuña­raquina. Váhisera camurianaina ena téhicana éta. Éti epamicava esiapa tayehe eta achene ánicu­chi­charichu. ");
INSERT INTO ignNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Échapa­vayare tayehe eta náimitu­rapiana ena tépiya­hi­rahiana tímija­chavana machanerana ema Viya. Tépiya­ca­vá­napahi tiúriana tacutihi eta tamansuva eta uvesa. Téhesera te nasamureana, tétavi­cavahi eta navaina­rajiva, nacutihi eta ichini. ");
INSERT INTO ignNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ímatia­ca­va­ca­hisera éna táichavene eta náichaqueneana. Nacutihi eta yucuquiana. Eta yucuqui, tímati­carehi eta táhi. Étaripa eta sitavere, váiparinehi tiúchucaimahi eta tacahihini narasa­hi­na­hi­pucaini. Tásiha, eta ijicaqui váipari­ne­hivare tacahimahi eta táhi cachiche­ru­hi­na­hi­pucaini. ");
INSERT INTO ignNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tacutiquene, tímati­carehi eta táhi eta yucuqui tiúrinisi. Tímati­ca­revare eta táhi eta máurini­si­ráhana. ");
INSERT INTO ignNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Eta yucuqui tiúrinisihi eta táhi, vahi témuna­hi­ri­ca­vaimahi vahi tacuri­ni­sihini eta táhi. Étaripa eta máurini­si­ráhana, váhivare témuna­hi­ri­ca­vaimahi táurini­sihini eta táhi. ");
INSERT INTO ignNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tamutu eta yucuquiana máurini­si­ráhana ticaechu­yarehi, tíjuyarepa te yucu. ");
INSERT INTO ignNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eta tacahe, ímati­va­cayare ena tépiya­hi­rahiana táichavene eta náichaqueneana tamauri­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Narari­hinapa ena achaneana tépiya­cavana nuchanerana. Váhisera títuji­ca­va­naimahi tisiapana tayehe eta mávasa ema Viya. Tayanapane náichanui­na­papuca “Tata Viáquenu”, vahi tisiapa­naimahi. Taicha vahi yátupi­nahini eta nacaema­ta­nea­sirahi ema Tata Nucaiyaquene te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te táitecapapa eta juicio, camuria­nayare ena tíchanua­nayare: “Tata Viáquenu, víti véchaji­si­ha­pa­racahi eta píjare. Vipiara­cavihi te píjare eta viáquiji­sirahi ena váinarajiana, téhevare te píjare vímerecahi eta tiárami­careana” náichanui­na­papuca. ");
INSERT INTO ignNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nútisera nujica­painapa: “Éti vahi nuchane­rahéna. Nímatisera núti eta íchaque­neanahi tamauri­queneana. Évuisiha te numirahu” níchainapa éna. ");
INSERT INTO ignNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nácani tisuapa­nuanahi náitaucha­hivare eta juca nuvanai­ri­pianahi, téchema­ra­hianahi táicha. Nacuti­yarehi mácani títucahi tépiyareca peti, manaca­yarehi eta túmeana yucuqui emuruquiana. ");
INSERT INTO ignNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jéhesare, te járajapapa eta muraca técaticava, tiámaquiha tiquiva, tisiamapa eta une, váipasera tacaya­ya­cahini eta peti, taicha tiúsiapi­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Narari­hivare ena tépiya­ca­vanahi tisuapanuana, váhisera náitauchahini eta juca nuvanai­ripiana. Éna nacutihi ema máitucaraha tépiyareca peti. Vahi manacaimahi eta túmeana yucuqui, váhivare táusiapi­ra­va­cahini máicha. ");
INSERT INTO ignNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te járajapapa eta muraca técaticava, tiámaquiha tiquiva, tisiamapa eta une, tacaji­mu­ya­paicapa eta apaquehe. Tiáquipai­cavapa eta peti, tamutu­samipa témitie­queneha —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te títapi­ricapa ema Jesús eta máimitu­si­ra­vacahi ena achaneana, ichape­rinehi eta náramirahi eta máimitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vahi nasama­sa­ré­nahini. Tétavi­cavahi eta máitusirahi mayuna­paicahi tamutu. Tétavi­ca­va­hivare eta tasuapa­ca­revahi eta máimitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te tiúcupaicapa ema Jesús tayehe eta cerro te mávinehi, camuriana éna achaneana téhica­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tacahe, macahepaipa ema émana achane leproso. Témeña­havapa mayehe ema Jesús. Tépuyucapa te mamirahu. Tásiha, máichapa: —Tata, nucasi­ñavahi eta piyehe, picana­ra­ca­nupaini. ");
INSERT INTO ignNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tacahe, ema Jesús majicapapa: —Nuvaraha nucana­racavi. Tájinapa píchiravaina puiti —máichapa. Máemama­hacapa. Tásiha, enevanepa tinaracahi ema macaju­ma­que­nénihi eta máechaji­sirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tásiha, ema Jesús máichapa: —Pímaha, nacuija picumetaca eta nútirahi nucana­ra­cavihi. Piyana­va­nesera pímerecava nayehe ena tuparai­rucana, apaesa náimamacavi. Énainapa timeta­ji­ri­ca­nainapa eta yátupirahi pinaraca, pipachi­hairapa. Piyana­yareva me Viya. Picama­va­hu­ya­repahi eta pihasu­lu­pa­ya­chi­rayare taicha eta macana­ra­si­ravihi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tacahe, ema Jesús títecapapa tayehe eta Capernaúm. Matiarihihi ema achane apavasana. Comandantehi éma nayehe ena suntaruana romanoana. Capitán eta mávacure. Tiyanapa mapauchapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Mayase­recapa, ánipa máicha: —Tata, mararihi puiti te nupena ema amaperu numusura ticajumahi eta áire. Tétavi­cavahi tacativa masama. Pájapa­nupaini, picana­ra­si­na­nu­panaini éma —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ema Jesús, majicapapa: —Tiuri, nuyanayare nucana­ra­pa­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tásiha, ema capitán majicapapa: —Tata, vahi picucae­ña­macava eta pítesiraina eta nuyehe, taicha vahi táuricahini pisiapahini te nupenasami. Németeaca taratarichu picava­nairipi eta picana­ra­siraya ema numusura. ");
INSERT INTO ignNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taicha núti nusuapahi te tivane­canuana ena anuque­he­pa­nanahi eta nuyehe. Nútiripa nusuapa­ca­re­hivare nayehe ena nusunta­ru­ranahi. Te nuvane­cavaca, téhevare níchuha­va­capuca, tisuapa­nuanahi. Te nuvane­capuca ema nuvaneru, enurujipa tisuapa­nuvane —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te masamapa ema Jesús eta juca, ichape­rinehi márami eta yátupirahi macasi­ña­vairahi eta mayehe. Máichavacapa ena téhica­napahi: —Nutupiruva numetacahe: Nájina nímaha émanaina vijaneana israelíta mácutihini ema maca achane apavasana eta macasi­ña­vairahi eta nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Numetacahe puiti: Járaja­painapa eta sache, náiteca­piraya ena camuri­queneana achaneana apava­sanana tiásiha­nayare te tamutu avasareana te juca apaquehe. Tisiapa­nayare eta mávasa ema Tata, te mávihahi ema viáchucaini Abraham, ema Isaac, émapa ema Jacob. Tétavi­ca­vainapa eta náurisa­mu­revaya. ");
INSERT INTO ignNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tacahe, tamapuruji eta náimatie­que­ne­hairahi ena vijaneanana israelítana eta máechaji­riruva ema Tata, váhisera nácasi­ña­vahini eta nuyehe. Eta tiviucha­va­ca­yarehi tayehe eta nacaicu­ñaiyaya eta te tamapi­cuquene te távihahi eta táijure­quenehi yucu. Ticapi­ti­quia­he­cha­va­nainapa eta tacati­vayare nasama. Tíyaha­nainapa —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tásiha, ema Jesús máichapa ema capitán: —Piyana pichava te pipena. Tinara­caripa ema pimusura, taicha eta picasi­ña­vairahi eta nuyehe —máichapa. Tacahe, ema amaperu ticajumahi tinara­ca­ripahi te jena hora eta náechaji­ri­si­ravahi éna. ");
INSERT INTO ignNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ema Jesús tiyana­varepa te mapena ema Pedro. Máimahapa esu máimase ema Pedro, ticajumahi eta muraca fiebre. Mapauchapa tayehe eta suívesihahi. ");
INSERT INTO ignNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Máemama­hacapa, enevanepa táetaviacahi eta fiebre. Tinaracapa. Enurujipa téchepuca. Tásiha, tépanavapa ésu eta suítátirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te yátipa, títeca­pa­rá­ca­na­paichucha ena achaneana. Námava­capaipa ena nacaju­ma­queneana, énapa ena návaháruana ena éreanana. Tacarichu te máechaji­ri­ru­vachucha ema Jesús, macuchu­chu­ji­ca­va­capaipa ena éreanana tiávahá­canahi ena nacaju­ma­que­neanahi. Macana­ra­ca­vacapa ena apamuriana tisamanahi eta apana jumareana. ");
INSERT INTO ignNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eta juca títaucha­vapahi eta táechaji­si­hairahi eta májurehi ema víyarahaini profeta Isaías, ani tacahehi: “Masami­na­ha­vi­hivare eta vijumana eta macana­ra­si­ra­havihi”. ");
INSERT INTO ignNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te máimahapa ema Jesús ena camuri­queneana achaneana nachayacahi, macava­nai­ripipa ena máimitureana natsecava eta nánuesi­ra­yarehi te apachara cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tacahe, ema émana escribáno témeña­havapa mayehe ema Jesús. Máichapa: —Tata máestro, núti apana nuvaraha néhicavi te jácani pivara­ha­que­neyare piámianu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ema Jesús, ánipa tacahehi eta majica­pirahi: —Tamutu eta sárareana ticape­navaca. Éneri­chuvare eta cáyureana tamaca­ji­pa­chuvare. Nútisera nuti Manere­ji­ru­nuhi ema Viya, tájina nuviya nusiapi­hahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te apana­varepa sache, ema émana máimiture máichavarepa: —Tata, nuyaseacavi písapa­nuhini nuchava te nupena. Nucucha­pa­nu­ma­ya­rehini eta máepeniraya ema ticachichanu, nécara­numaya. Tásiha, nucapa­ya­cavipa néhicaviya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ema Jesús majicapapa: —Péhica­nuchucha. Pésamirica náecara­ca­caichaha ena máecharaireana. Tájina táijara­ca­vimahi eta juca tihapa­sa­mu­re­re­cavihi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Te títapi­ricapa ema Jesús, tiávacuhapa te pacure. Énapa ena máimitureana, náehicapaipa éma. ");
INSERT INTO ignNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te itupie­re­canapa, járajapapa eta muraca técaticava. Ichapevaca eta táepacu­ruhana. Tisiapa­paipahi eta une tayehe eta pacure. Ema Jesús, tímaca­paichucha éma. ");
INSERT INTO ignNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tacahe, ena máimitureana tipiara­re­canapa eta napisirahi. Nacaja­micapa éma. Ánipa náicha: —Tata maestro, picatiu­chahavi. Véricainapa —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ema majica­pa­vacapa: —¿Tájaha tacayema epica? ¿Vahi ácasi­ña­va­pahini eta nutiari­hi­rapahi eta eyehe? —macahepa. Tásiha, téchepucapa. Macama­ti­nacapa eta técaticava étapa eta une. Enevanepa tésami­ri­cavahi eta táepacu­sirahi. Tájinapa táichira­vai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ena máimitureana ichape­rinehi nárami. Ánipa nacahe: —¡Tétavi­cavahi eta máitupa­ji­jia­si­ravahi! ¡Jéhesare, yátupiquene eta émairahi machichahi ema Viya! ¡Taicha tamutu tasuapahi, macama­ti­nacahi eta técaticava étapa eta une eta táepacu­sirahi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te títecapapa ema Jesús te apachara eta cáquiure te apaquehe Gadara, tiúchuji­canapa te ecari ena apinana ajairana, návahá­ruanahi ena éreanana. Tétavicava eta náiñehi­va­vacahi. Náehayarehi nácani tiánucu­ha­napahi. Tacahe, napauchapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tipiara­re­canapa, ánipa nacahe: —¿Tájaha picha píteca pipauchahavi piti Jesús, Machicha­que­nevihi ema Viya? ¿Pivarahapa picaete­ma­ji­ri­ca­ha­viyare víti? ¡Pájapa­nuhavi, vuíchaha picuva­ne­cahavi tayehe eta vicaicu­ñai­yayare! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tásiha, tatiari­hi­hivare nacacha­cayahi eta camuri­queneana cúchiana tinihi­canahi. ");
INSERT INTO ignNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ena éreanana nayaseacapa ema Jesús. Ánipa náicha: —Te piáquiji­ca­ha­vi­ya­repuca, picata­ji­cahavi. Písapahavi visiapa­ha­cavaca eta jena cúchiana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tacahe, ema Jesús máisapapa: —Tiuri, eyana esiapa­ha­cavaca —máichapa. Tacahe, tiúchucanapa ena éreanana nayehe ena návahá­ruanainihi. Tiárame­mu­ri­ha­nainehi eta cúchiana. Tijuna­pa­ra­canapa témiri­ri­ji­canapa te tachausi eta cáquiure. Tériri­ji­canapa. ");
INSERT INTO ignNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ena tijanea­re­ca­nainihi eta cúchiana tiyananapa tijunana tayehe eta avasare. Timeta­ji­ri­canapa eta náimairahi, étapa eta nanara­sirahi ena návahá­ruanahi ena éreanana. ");
INSERT INTO ignNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tacahe, tiyananapa ena achaneana te mávihahi ema Jesús, náimaha­panahi. Te náimahapa éma, nayaseacapa vahi macuite­ca­pahini te návasa, machavahini te másinehi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tacahe, ema Jesús tichavapa tiávacu­ha­varepa te pacure. Tichavapa tayehe te mávasahi Capernaum. ");
INSERT INTO ignNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ánaqui náimipau­cha­varepa ema achane macaju­maquene eta muracaquiha. Ema tívecahi te mayehe camilla. Te máimahapa ema Jesús eta nacasi­ña­vairahi eta mayehe, máechajicapa ema macaju­maquene. Ánipa máicha: —¡Pétumechava, nuchicha! Nucaepa­hai­navipa eta pipeca­tu­ranaini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Natiarihi ena escribá­noana. Eta nasamirahi ema Jesús, ánipa nacahe te nasamure: “Ema maca tépiyacava tímija­chavahi Viya eta macaepa­hai­rahiji eta pecatuana. ¡Tétavicava eta matapirava!” ");
INSERT INTO ignNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Émasera ema Jesús máimatihi eta napane­re­ruanahi. Máichavacapa: —¿Tájaha tacayema eta éjeca­pirava nuyehe te epane­re­ruanahi? Núti tájina nutapi­ravaina eta níchirahi eta juca. ");
INSERT INTO ignNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Núti, eta nucaepa­hairahi eta mapeca­turana ema maca, tacutihi eta máejera­rerahi eta nucana­ra­sirahi eta máquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tiúrisera puiti, nuti Manere­ji­runuhi ema Viya, nímereu­cha­vainapa eta nurata­hairahi nucaepaha eta pecatuana te juca apaquehe. Ímara­racanu —tacahe, máichapa ema macaju­maquene—. Puiti, nuchicha, nuvanecavi péchepuca. Piveha eta jara piyereruva. Piyana te pipena —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eneva­ne­rinehi téchepuca ema macaju­ma­quenéni. Tiyanapa te mapena. ");
INSERT INTO ignNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ichape­rinehi eta náramirahi namutu ena achaneana natiari­hi­que­neanahi. Tétavi­ca­va­rinehi eta nacuna­chirahi ema Viya taicha eta máitupa­ji­jia­sirava ema Jesús eta máijara­sirahi ema Maiya. ");
INSERT INTO ignNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Te apanapa sache, nuti Mateo néjacahi eta te nucobra­re­sirare eta impuesto. Tacahe, tiánucu­hapaipa ema Jesús. Te tímahanupa, tíchuhanupa. —Yare, péhicanu —máichanupa. Enevanepa, néchepucahi. Néhicapa éma. ");
INSERT INTO ignNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tacahe, námapa éma te nupena, énapa ena máimitureana. Níchuha­vacapa ena nuchamuriana ticobra­re­ca­ra­hianahi eta impuesto énapa ena apamuriana tisipe­ca­turana. Nénica­va­ca­yarehi éna. Macacha­ne­mu­ri­hivare ema Jesús eta vinisirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Títeca­pa­na­varepa ena fariséoana. Eta náimairahi namutu ena némuna­ru­queneana, eta vicacha­nerahi ema Jesús, ticaeca­hi­re­canapa. Ánipa nacahe nayehe ena máimitureana ema Jesús: —¿Tájaha tacayema tísapava ema eyehe maestro macacha­nevaca eta manisirahi ena nánita­tajiana ticobra­re­ca­rahiana eta impuesto? ¡Ticape­ca­tu­ra­rahiana éna! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Te masamai­ri­ricapa ema Jesús eta náechaji­ri­ruvana, máichavacapa: —Ena majuma­reanahi vahi nácamu­nuimahi ema médico. Nacarichu ena ticaju­manahi nacamu­nu­yarehi ema médico. ");
INSERT INTO ignNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nútiripa vahi étaina tímite­canuhi nutanu­ca­yarehi nácani matapi­ra­va­reanahi. Nutanu­capahi núti ena tisipe­ca­turana, apaesa náeneuchava, náinajica eta napeca­turana. Tásiha éti, eyana ecaravahu eta máechaji­ri­ru­vanahi ema Viya. Ánipa macahe: “Núti nuvaraha yátupinaini eta ejapa­nu­rai­vai­nahini. Taicha te vahi, tamapu­ru­jiyare eta ecama­va­huirahi eta nuyehe” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Títeca­panapa ena máimitureana ema Juan Tícacha­si­ri­carahi, nayase­recapa ema Jesús tayehe eta ayuna. Ánipa naicha: —¿Tájaha tacayema vahi nahayunacha ena pímitureana, vahi nácuti­ha­vihini viti máimitureana ema Juan, énapa ena fariséoana? ");
INSERT INTO ignNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ema Jesús majica­pa­vacapa: —Nímicu­ti­chinahe puiti. Vahi táuricaimahi ticati­sa­mu­revana nácani ticaichu­ha­ca­sianahi tinicanahi nayehe ena araimana. Tiúrisa­mu­rea­na­yarehi taicha matiarihihi ema arayena. Téhesera te tépenapuca éma, jéhesare ticati­sa­mu­re­va­na­yarehi. Tacutiquene, vuíchaha táuricaimahi eta ayuna­nai­nahini ena nímitureana. Járaja­pai­na­pasera eta sácheyare, ticave­re­ji­ca­sia­nayare taicha ticara­ta­ca­nua­nainapa ena ticapa­ca­nuanaya núti. ");
INSERT INTO ignNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","17","Esama­nuchaha. Eta juca eta nímitu­rapiana, amairiha arairu. Mavaraha ema Viya arairuyare eta eyehe­re­pia­nayare eti achaneana. Vahi ticuti­ca­caimahi eta nayehe­repiana ena achaneana. Eta ítusira éti eta nímitu­rapiana, tavaraha ínajica eta ichasi eyehe­repiana tamauri­que­neanahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Téchaji­ri­ca­vai­chahahi ema Jesús nayehe ena achaneana, títeca­pa­ne­chavare ema émana achane ticaijare Jairo. Tuparai­rucahi éma. Matupirupa tépuyucapa te mamirahu ema Jesús. Ánipa macahe: —Tátachicha, surarihi esu nuchicha. Puítirichaha tépenahi. Téhesera te piyana, pinacaini eta pivahu, suchavahini suítare­cahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tásiha masuapapa ema Jesús. Tiyanapa te mapena ema Jairo, vimutupaichu viti máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tásiha, sutiari­hi­hivare esu ésuna esena sucaju­maquene. Doce áñoripahi eta sucata­ji­vairahi, táichirahi eta suítine. Témeña­havapa te maquecu ema Jesús. Suémamacapa eta tacheyarapi tamatsianahi eta mamuiriha. ");
INSERT INTO ignNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Taicha te supanereru ésu, sucahehi: “Taratarichu jácani te némamaca eta ñimuiriha, éta ticana­ra­ca­nuyare” sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Émasera ema Jesús masama­richucha eta suémama­jia­sirahi, macaicu­tiarahi eta macana­ra­re­sirahi. Téqueru­cavapa. Máimahapa eta supisirahi esu esena. Tásiha, máichapa: —Vaipa picupica, nuchicha. Pinaracapa puiti táichavenehi eta picasi­ñai­ranuhi —máichapa. Tacahe, tinaracapa esu esena. Vaipa tápechahini eta sujumainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tiyana­varepa ema Jesús. Títecapapa tayehe eta mapena ema Jairo. Máimahainehi ena músicoana. Tiúrianaipahi eta námira­yarehi te ecari esu suépenaquene. Énapa ena achaneana, tijaja­mu­ria­na­ripahi eta náiyairahi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tásiha, ema Jesús máichavacapa: —Iúchucachaha te aneca. Váhinéni suépenahini esu suca amaperu. Tímaca­richucha ésu —máichavacapa. Énasera nacaeca­hi­richucha éma, técavanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te tiúchucanapa ena achaneana, tisiapapa ema Jesús te suávihahi esu suépenaquene. Macara­ta­vauchapa ésu. Macaeche­pucapa. Tichavapa títarecahi ésu. ");
INSERT INTO ignNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te nasamai­ri­ricapa ena ticava­sanahi eta te Capernaum, náraminehi namutu. Nacatsa­tsaicapa timeta­ji­ri­canapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tiuri, tichava­yarepa ema Jesús te mapena. Eta mapaisirahi te calle, náehicapaipa ena apinana púchuquiana. Tipiara­ca­na­paipahi te máequene. —¡Tátachicha Jesús, pájapa­nuhavi picana­ra­cahavi. Vicasiñavi piti yátupi­que­névihi Cristo! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Váhisera masuapa­va­nehini éma. Te tisiapapa ema Jesús te mapena, ena púchuquiana tisiapa­na­varepa. Témeña­ha­vanapa eta mayehe. Tásiha, éma mayase­re­ca­vacapa. Ánipa máichavaca: —¿Yátupipuca ecasi­ñanuhi eta nucana­ra­si­ra­heyare? —macahepa. Ena najicapapa: —Yátupi, tata. ");
INSERT INTO ignNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tacahe, ema Jesús máemamacapa eta náuquihana. Tásiha, máichavacapa: —Tiúri, eta ecasi­ñai­ranuhi, enara­cayare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jéhesare, enevanepa tinara­canahi. Tímairi­ri­canapa. Tásiha, muracapa eta matupa­rasira vahi nacume­ta­jirica eta macana­ra­si­ra­vacahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Váhisera nácahehini éna. Étarichuhi te tiúchucanapa, timeta­ji­ri­canapa eta macana­ra­si­ra­vacahi. Tásiha, náechapa namutu te tachaca­ya­ra­hanahi eta avasare eta juca máichaquenehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te viúchuca­varepa, nacahe­pai­pavare ena achaneana. Námapahi ema achane. Úpahi éma, taicha mávaháruhi ema éreana. ");
INSERT INTO ignNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tacahe, ema Jesús máquijicapa ema éreana, ema tiávahá­cainihi. Tásiha, ema achane tinaracapa. Téchajicapa. Ichape­ri­ne­hivare eta náramirahi ena achaneana eta náimairahi. Ánipa nacahe: —¡Tétavicava eta máitupa­ji­jia­sirava ema Jesús! Te viávasa Israel, nájina tiratahaina tíchaina tácutihini eta juca vímaha­quenehi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Narari­hivare ena fariséoana. Ánipa nacahehi: —Ema maca Jesús, vémeteaca majupahahi ema Satanás, ema náquenu­murihi ena éreanana. Máijararuhi jácani eta máitupa­ji­jia­si­ravahi eta macuchu­si­ra­vacahi éna —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ema Jesús tamutuhi mapaica eta avasareana étapa eta ánichi­cha­queneana avasa­re­chichana. Tímitu­re­capahi tayehe te jácani máiteca­pi­hapahi te náuruji­si­ra­revana. Ticame­ta­rai­rupahi eta máechaji­riruva ema Viya eta náuchucui­rayare ena ticasi­ñanahi éma, machane­ra­na­yarehi éna. Ticana­ra­re­ca­pa­hivare ena ticata­ji­vanahi ticaca­ti­ru­hanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Camuriana ena achaneana tínana­ji­rí­ca­vanahi. Taicha ticata­ji­vanahi éna, nájina nácasi­ñahini. Nacutihi eta uvesa te nájina tijaneacaina. Eta máimaira­vacahi ema Jesús, ichape eta majapa­nui­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tacahe, ema Jesús máichahavipa viti máimitureana: —Tétavi­cavapa eta vicamu­nuirava ena tímica­ta­ca­ha­vianaya tayehe eta juca vémata­ne­repihi. ");
INSERT INTO ignNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eyasea­ca­ya­resera ema Tata Vicaiyaquene, máijara­cahavi ena tímica­ta­ca­ha­via­nayare. Eta juca tímicu­ti­ji­ri­cavahi mácani achane eta macamu­nui­ravahi ena tímica­ta­ca­canaya te máechati­jicaya eta maharusura —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tacahe, ema Jesús tíchuha­havipa viti dócequeneana, mayehea­nayare apóstole. Tíjara­ca­havipa eta vítupa­ji­jia­si­ra­vayare virata­hai­ra­yarehi vicuchu­cavaca ena éreanana, vicana­ra­si­ra­yareva ena nacaju­ma­queneana étapa eta nacati­ru­havana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Eta juca víjareana viti apóstoleana: Ema tínapuca ema Simón Pedro, émapa ema maparapeichu Andrés, ema Jacobo ema maparapeichu Juan, ema Felipe, ema Bartolomé, ema Tomás, nútipa Mateo, ema apana Jacobo, ema Lebeo, ema apana Simón, émapa ema Júlasi Iscariote (ema tíjara­recahi ema Jesús). ");
INSERT INTO ignNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tacahe, ema Jesús tévata­ca­havipa viti dócequeneana apóstoleana vicame­ta­rai­ru­yarehi. Ánipa máichahavi: —Vahi ecuyana tayehe eta návasana ena apava­sa­juecuana. Váhivare ecuyana nayehe ena samari­tá­noana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Eyana­ya­resera tayehe eta avasareana návasanahi ena vijaneanana israelítana. Taicha éna nacutihi eta uvesana máquenureana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Eyana ecame­ta­rai­ruyare nayehe. Emeta­cayare eta nútija­pai­rainapa nuti Náquenuyare, nuti nucuchu­cu­ha­va­cayare éna, taicha mavane­runuhi núti ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ecana­ra­ca­va­ca­ya­repahi ena leprósoana énapa nácani ticata­ji­vanahi taicha eta apana jumare. Ecaeche­pu­ca­yareva ena náepena­queneana. Ecuchu­ca­yareva ena éreanana. Éti, vahi evacha­re­ruinahi eta juca ítupa­ji­jia­si­ravahi, váhivare ecobra­chaimahi nácani ecana­ra­rua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Váhivare iámaimahi eta oro, eta plata, eta reale. Tacuija iama eta eniru­rucuha te alforja. ");
INSERT INTO ignNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Étana­ri­chuvare emuiriha, éta iámayare. Étapa eta éparupeva, étaripa eta eyupai­riquiana. Ema ticaema­ta­nerahi, tatupa­racahi náenica­ya­repahi te jácani macaema­ta­nei­yapahi. Ene ecaheya éti, títáti­hea­nayare ena tijaca­panaya eta ecame­ta­rai­rui­ra­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Te ítecapaucha jácani avasare, etanu­cayare ema achane tiuri, témunarahi. Enasiyare mayehe. Tiámainucava te táitecapa eta iúchusi­ra­yareva tayehe eta avasare, epaenu­mavaya ejunijica eta íteca­pihahi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te esiapa­yarepa tayehe eta peti, eyasea­cayare ema Viya eta náurica­ca­revaina ena achaneana ticapenana eta peti. ");
INSERT INTO ignNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te tiúrianahi ena achaneana ticape­nanahi eta peti, ímiyanava eyaseu­chayare eta náurica­ca­revaina. Téhesera te vahi nacuri, váhi eyaseu­chaimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Étaripa te váhipuca nacuja­capahe te jácani avasare, étapa te jácani peti íteca­pi­hayare, váhivare nacuvaraha nacusamahe, iúchuca­va­ne­yareva. Étata­pe­va­cha­va­nú­ma­ya­reséra eta máteji te ívapeana. Táicutia­rayare eta máicuña­si­rayare ema Viya taicha eta namava­rairahi najaca­pa­hehini. ");
INSERT INTO ignNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nutupiruva numetacahe, te táitecapa eta juicio, tiápaju­ca­vainapa eta náicuñayare. Tacachu­ri­cayare eta nacaicu­ñai­rayare ena achaneana váinara­ji­queneana ticava­sanaini te Sodoma étapa eta Gomorra. ");
INSERT INTO ignNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Esama­nuchaha. Núti nuvane­cahehi éti eyana epaica. Narari­hisera ena achaneana váinara­ji­que­neanahi étupia­rua­nayare. Éna nacutihi eta sárare táiñehi­que­neánahi. Étisera ecutiyare eta uvesa eta tamansuvahi. Ítucayare eta ecaiche­pai­si­rayare eta navaina­ra­jivana. Váhisera ecuji­ca­pauchava te návara­hapuca náehahe. ");
INSERT INTO ignNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Échapava, taicha narari­hiyare ena achaneana ticatia­na­ca­hea­nayare táichavenehi eta éhisi­ranuhi. Ticara­ta­ca­hea­nainapa, écaya­se­re­hinapa nayehe ena juéseana. Téstaca­hea­nai­na­varepa eta te náuruji­si­ra­revana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tásiha, etiari­hiyare éti tiámaheanaya te namirahu ena aquenucana, téhevare te namirahu ena Presidenteana gobiernoanahi, ecaviu­re­vayare táichavenehi eta éhisi­ranuhi. Esapi­hasera éti, ecama­pu­ra­vainapa échaji­sia­nuyare te namirahu éna, apaesa náimatiyare namutu ena achaneana te avasareana eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tacahe, te jácani námahe­papuca te namirahu ena aquenucana, vahi ecueñamava tayehe eta jácani échajiu­chi­ra­vayare, ecatiu­chi­ra­vayare. Échaji­cayare eta échaji­ri­ruvana máijara­ru­heyare ema Espíritu Santo te jena sache. ");
INSERT INTO ignNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taicha máimaha­heinepa, tímitu­ca­heyare eta échaji­siraya. Vahi étiji­vaimahi eta échaji­siraya. ");
INSERT INTO ignNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Natiari­hi­yareva nácani achaneana tíjara­re­canaya ena napara­pe­queneana, navarairahi náimicapaca táichave­nénahi eta náehisi­ranuhi núti. Natiari­hi­yareva ena nácani náiyana, navara­ha­yareva náijarareca ena nachicha­naveana táichavenehi eta náehisi­ranuhi núti. Natiari­hi­yareva nácani nachicha­naveana nacana­rainapa ena náiyana, náimica­pa­cainapa táichavenehi eta náehisi­ranuhi núti. ");
INSERT INTO ignNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namutu­yaréni ena achaneana ticatia­na­ca­hea­nayare táichave­nénahi eta éhisi­ranuhi núti. Téhesera ecamichahi tamutu, ímiya­navahi eta éhisi­ranuhi te táitavapa tamutu, nucuchu­cu­ha­heyare núti. ");
INSERT INTO ignNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te napana­ji­ca­hepuca te jácani avasare iávihahi, táichavenehi eta ecame­ta­rai­ruirahi, ejunayare tayehe eta apana avasare. Jéhesare, nuti Manere­ji­ru­nuhi ema Viya, nútija­pa­va­nénapa. Vuíchaha ecuitahi epaica eta avasareana ne vijaneanana israelítana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Éti nímitureana, ticatia­na­ca­heanaya ena achaneana. Vahi epicau­cha­ca­réimahi nayehe, táichavenehi éhisi­ranuhi núti. Ticatia­na­ca­he­ya­resera tacuti eta nacatia­na­si­ranuhi núti. ");
INSERT INTO ignNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tíjare­cha­hea­nayare váinarajihe, máurishi­hepuca, tacuti eta náumehai­ranuhi núti. Étisera, evapi­navaya eta ecuti­ra­nuyare eta nacatia­na­si­ranuhi nuti iáquenu, núti eyehenuhi maestro. ");
INSERT INTO ignNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Váhisera ecupi­cavaca ena ticatia­na­caheana. Ema Viya tímara­ra­caheya. Ticuna­chaheya eta ecami­chirahi, evehainapa eta ícuchihi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tásiha, étumechava eta ecame­ta­rai­ruiraya tamutu eta nímitu­rapiana te tamutu avasareana. Jácani néchaji­ri­ru­vanahi te timapicu, éti ecuchu­ji­ca­yarehi te tijarahi, emicau­chi­ra­vacaya ena achaneana. Étaripa eta nujajai­ruhehi te vicarichuhi, epiara­cainapa te calle. ");
INSERT INTO ignNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Vahi ecupica nácani nacapa­capuca eta iáquehe, tacari­chuchucha náiturue­que­ne­hayare. Váhisera narata­haimahi nacami­tie­queneha eta iáchaneva. Macarichu ema Viya epicayare, taicha éma máiturue­que­nehahi tamutu. Maratahahi macami­tie­queneha eta iáchanevana tayehe eta táiñehiquene infierno, te ecaina­jiruva táichavenehi eta episi­rapuca eta nacapa­si­ra­heyare. ");
INSERT INTO ignNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nímicu­ti­chinahe eta cáyurechicha. Éti ímija­cha­papuca vahi tasiva­chahini éta. Téñama­ca­rea­na­hisera me Viya. Éma, téchavacahi eta táitare­sirahi, étapa eta táepenirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Evetijipa éti, éñama­ca­re­panahi me Viya. Éma, tímatipa eta tatupa eta echuti­macana. Téchahe­hivare éma tamutu eta ítare­sirana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eta tacahe, vahi ecueña­mavahi éti tayehe eta ítare­sirana, taicha tétavi­cavahi eta emunavahi mayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tímiyanava ema Jesús tímitu­cahavi. Ánivare macahe: —Namutu ena tímereu­cha­vanahi eta náehisi­ranuhi te namirahu ena achaneana, núti apanavare nímereu­chavaya eta nuchane­rai­ra­vacahi éna mayehe ema Tata Nucaiyaquene, ema tiávihahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nácanisera vahi návara­hahini tímereu­cha­vanahi eta náehisi­ranuhi, núti apanava nímereuchaya eta vahi nuchane­ra­nai­nahini éna, te mamirahu ema Tata Nucaiyaquene. ");
INSERT INTO ignNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Éti ímija­chai­papuca eta nítesirahi te juca apaquehe, tájina tácaye­ma­ca­rémahi, tiúrica­ca­re­yarehi nícha. Váhisera ene tacahe. Níchaveneya núti, ena achaneana tépuru­heanaya téraji­ca­vanaya eyehe. Eta tacahe, nuvaraha échapirica yátupina eta juca éhisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taicha puiti juca vicaiju­heyare, mácani achane, te natiarihi ena machicha­naveana, nacati­cha­yarehi ema naiya táichave­ne­yarehi eta máehisi­ranuhi éma. Ésuripa esu naena, nacatia­na­ca­yareva. Ésupa esu chinenaca, sucatia­na­ca­yareva esu suímase taicha eta suéhisi­ra­nu­hivare esu apana. ");
INSERT INTO ignNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ene nacaheya, narari­hiyare ena tachicha­naveana eta peti ticatia­nacana ena náiyana te peti níchavenehi núti. ");
INSERT INTO ignNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nácanisera tínaji­cavana eta náehisi­ranuhi táichavenehi eta nacatia­nasira ena nachicha­naveana, váipa tatupa­ra­cahini nuchane­ra­nai­nahini. Énaripa nácani tínaji­cavana eta náehisi­ranuhi táichavenehi eta nacatia­nasira ena náiyana, éneri­chuvare vaipa tatupa­ra­cahini nuchane­ra­nai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Éne­richuvare nácani apaesarichu eta navarairahi téhica­nuanahi, váhivare náijara­ca­vahini táimica­pa­cahini eta náehisi­ranuhi, vaipa tátupa­ra­cahini nuchane­ra­nai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Taicha nácani téñama­vanahi eta náitaresira, tiávami­rahuana eta náehisi­ranuhi, énaji­vayare ticami­tie­que­ne­ha­vanaya. Énasera nácani yátupi tíjara­re­ca­vanahi téhicanuana, táimica­pa­rua­na­ya­repuca eta náehisi­ranuhi, éna tiúchucu­ha­nayare eta náitare­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ema Viya máitsiva­chayare nácani tiúriana ena najaca­pi­ra­heyare nasamahe éti. Taicha eta najaca­pi­rahehi, ticaeche­ranahi eta najaca­pi­ra­nu­hivare núti; éneri­chuvare najaca­pa­hivare ema Tata Nucaiyaquene. ");
INSERT INTO ignNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Éneri­chuvare nácani tijaca­panahi ema profeta nuvaneruhi, énapa ena achaneana tiuri eta náehisi­ranuhi, máitsiva­chayare ema Tata, máijara­si­ra­va­cayare eta náicuchi. ");
INSERT INTO ignNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Énaripa ena témuna­ra­hianahi nayehe ena nani ánichi­cha­queneana téhica­nuanahi, nacumpiracha eta une táichavene eta náehisi­ranuhi; éneri­chuvare jararihi eta náicuchiquene —máichahavipa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te tamutupa eta máimitu­si­ra­havihi ema Jesús viti dócequeneana mayeheana apóstole, tiyana­varepa eta te avasareana tayehe eta Galilea. Taicha mavarahahi máimitu­cayare ena achaneana eta máechaji­ri­ruvana ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tiuri puiti, ema Juan Tícacha­si­ri­carahi, mávinehi te cárcel. Ánaqui masamai­ri­ricapa eta máichaque­neanahi ema Jesús. Tacahe, máevatacapa ena apinana máimitureana, nayase­re­pa­na­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Te náiteca­pauchapa, náichapa: —Ema viáquenu Juan tivane­ca­havihi viyase­re­pa­na­viyare te yátupi­hipuca pítiri­pa­hipuca Cristo ema vicucha­pa­quenehi, ¿téhese­rapuca vímiya­na­va­ya­repuca vicuchapa? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Ema Jesús majica­pa­vacapa: —Nuvaraha ímara­racaya eta níchaqueneana puiti. Nucaimai­ri­ri­ca­vacaipa ena púchuquiana. Nímipai­siraipa ena masariana. Nucana­ra­ca­vacaipa ena leprósoana, énapa ena túhuquiñana. Nucaeche­pu­si­ra­va­cai­pavare ena náepena­quea­neanaini. Éneri­chuvare níchuhahi ena páureana náeneuchavaya apaesa náuchucuha. Tásiha, eyana emetaca ema Juan tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vaipa macueñamava ema Juan eta nuyehe. Tétavi­cavahi eta máurica­ca­revahi éma, te ticasi­ñavahi eta nuyehe —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tacahe, tichavanapa ena vanairu­canahi me Juan. Tásiha, tépana­va­varepa téchajica ema Jesús, máechaji­sihapa ema Juan. Ánipa macahe eta mameta­si­ra­vacahi ena achaneana: —Nuvaraha epane­reu­chayare ema Juan. Te jácani vuíchaha nacara­ta­cahini éma, te eyanapa te mávapahi apaquehe te mávihahi, ¿tájaha eta epane­reruana tayehe eta macame­ta­rai­ruirahi? Éti ímija­chai­papuca mamapa­chi­chi­ji­ri­ru­vaichucha eta máechaji­sirahi tacutihi te vímararaca ta taflurena eta acutena te tacaya­mu­ri­rijica eta técaticava. ");
INSERT INTO ignNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ímija­chai­pa­va­repuca tavayuaruhi éma tiúrina­ná­ca­va­yarehi eta macamui­ri­hairahi. Écharichuhi éti mácani tiúrina­na­cavahi, píncanillahi eta máitaresira, váiparinehi tiúchucaimahi te sache, váhivare tiyanaimahi te mávapahiana apaquehe. Manasi­que­ne­yarehi te jácani tiúrina peti. ");
INSERT INTO ignNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nuyase­recahe: ¿Tájaha eta ímija­chirahi eta mayehe? ¿Ímati­hipuca eta profetairahi éma? Núti numetacahe: Matupi­ruvahi eta macame­ta­rai­ruirahi ema Juan. Mavaneruhi ema Viya eta yátupi­quenehi profetahi éma. Nájina mácutihini ena apamuriana profetana. ");
INSERT INTO ignNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ema maca Juan émara máechaji­si­ha­quenehi ema Viya eta te Sagrada Escritura, ánipa macahehi: “Nuvane­cayare ema tínapu­mi­rau­cha­vi­ya­repahi ema ticame­ta­rai­ru­ya­repahi, apaesa natseca­vapaipa ena achaneana eta najaca­pi­ra­viyare” tacahepa eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Núti nutupiruva numetacahe: Ema maca Juan, nájina mácuti nayehe ena achaneana. Tétavi­cavahi eta macuna­cha­ca­revahi. Tiápaju­pa­na­va­hisera eta nacuna­cha­ca­revahi nácani nuchane­ranaya, apaesa­chi­cha­pucaini eta nacaicu­tia­rairahi eta mapane­reruana ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ema Juan tépanavapa eta máimitu­sirahi ena achaneana tacamu­nuirahi eta náeneuchirava me Viya. Narari­hisera ena vahi náuricahini nasama­ra­ra­cahini. Étapa tímica­tichahi témeca­ta­jí­vachahi éma. Puíticha tanasihi ticati­chanuana núti apanava, témeca­ta­ji­va­cha­nua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ema víyarahaini Moisés téchaji­si­hanuhi eta te májurehi. Énaripa ena víyara­hanaini profetana náechaji­sihahi eta nítesi­ra­yarehi nuti Manere­ji­runuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Puiti numetacahe: Ema Juan émaripahi ema profeta máiteru­yarehi mavasi­yarehi ema víyarahaini Elías, eta máinapu­mi­rau­chi­ra­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya. ");
INSERT INTO ignNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Etiari­hi­hisera eti achaneana puiti juca sácheana, eta emasua­pa­ji­raivahi, nímicu­ti­chahesa ena amaperuana tiútseruanahi. Apapi­pi­jichucha eta nacaye­ma­que­nea­napahi. Ema apana macahe­papuca: “Vépiyacaya eta piéstachicha”. Énasera ena apamuriana vahi náisapa­vahini. Tásiha, ema apana macahepuca: “Vépiyacaya eta ecari”. Váhiva­resera náisapa­vahini. ");
INSERT INTO ignNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ema Juan, te tímere­cavapa, muraca eta máimitu­ra­pianahi. Eta manica­sareana, vahi tácutihini eta nanica­sareana ena achaneana. Narari­hisera te emuri ena tépiyae­que­ne­hanahi éma. Náimijachahi mávaháruhi ema éreana. ");
INSERT INTO ignNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nuti Manere­ji­ru­nuhi ema Viya, eta níteca­pau­chi­rahepa, nucacha­ne­hepaipa eti achaneana eta enisirahi. Etiari­hi­hivare eti épiyae­que­ne­hanuhi: “Ímaha ema maca, cánisiu­qui­tataji, cávahárasi. Macacha­ne­va­capaipa ena achaneana tisipe­ca­tu­ra­ra­hia­nahi” ecahehi. Eti épiya­cavapa épururahi, ticuti­rinehi yátupi­nahini échema­ra­hihini. Tétavi­ca­va­hisera eta éjeca­pi­ravahi taicha eta emasua­pa­ji­raivahi. Te yátupi­hihini échemarahi, ímati­nuhini eta nucava­na­hirahi eta me Tata —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ema Jesús tépanavapa máechajisiha eta táicuña­yarehi eta avasareana máichinehi eta tiárami­careana. Ticaicu­ña­na­yarehi ena tachicha­na­veanahi táichavenehi eta namasua­pa­ji­raivahi. Váhivare náeneucha­vahini, náinaji­ca­hi­pucaini eta napeca­turana. Máechajicapa ena achaneana tímicu­ti­ji­ri­cavahi natiari­hi­nahini te mamirahu. Ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Páurehesami eti nujaneanana ecava­sanahi te avasare Corazín! ¡Páurehe­sa­mi­hivare eti apamuriana nujaneanana ecava­sa­na­hivare te avasare Betsaida! Ichape eta ícuñayare taicha éti ímaharipa tamutu eta tiárami­careana níchaque­neanahi te emirahu, váhisera ávara­hahini éneucha­vahíni. Ena nani achaneana ticava­sanahi te Siria, apava­sa­na­na­hinéni, tétavi­ca­va­hinéni eta namaurivahi, németea­casera núti nasapi­ha­hi­pucaini téneuchavana te náimahahini eta níchaque­nea­napahi. Enéva­ne­nahíni náimere­ca­vahini yátupi eta náeneuchi­ra­vai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Numeta­ca­he­va­nesera: Te jena sácheyare, muraca­pa­nayare eta ícuñayare éti, taicha eta emava­rairahi éneucha­vahini. Tacachu­ri­cayare eta nacaicu­ñairaya ena achaneana apava­sanana ticava­sanahi te Siria. ");
INSERT INTO ignNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Étiripa eti ecava­sanahi te avasare Capernaum, tamapu­rujihi eta nímitu­si­rahehi étapa eta ímairahi eta tiárami­careana níchaqueneana. Eti ecasi­ña­va­vaicahi, ímija­chai­papuca eta ticaya­pa­heyare te anuma. Ichapesera eta etsiri­ha­ca­re­vayare, taicha épuju­qui­cha­vayare eta te yucu taicha vahi éneucha­vaimahi éti. Taicha te nímere­cahini eta tiárami­careana tayehe eta avasaréni váinara­ji­quenehi Sodoma, tácutihini eta ímairahi éti, ichape­hi­pucaini eta náeneuchi­ra­vai­nahini, váipapuca macuicu­ña­cahini ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Numeta­ca­he­va­nesera: Ichape eta ícuñayare te táitecapapa eta juícioyare. Tacachu­ri­cayare eta náicuñayare ena ticava­sanaini te avasare Sodoma —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Étarichuhi te jena hórahi, ema Jesús ánipa macahe: —Tata Nucaiyaquene, tétavicava eta nucuna­chiravi. Jéhevare píti táquenuvihi eta anuma étapa te juca apaquehe. Títauchavaipa eta pipane­reruhi. Vahi písapahini náitucahini eta júcana ena tímija­cha­vanahi téchema­rahiana. Énapasera píjaracahi ena nani téhica­nuanahi, tájina­hinéni náechema­rai­vai­nahini. Puiti nasapi­ha­ripahi nacachu­ricahi ena títupa­ji­jia­ca­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tétavi­cavahi eta táurivahi eta pipane­reruhi píti, Tata Nucaiyaquene. ");
INSERT INTO ignNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tacahe, ema Jesús máichavacapa ena achaneana: —Ema Tata Nucaiyaquene, ema tíjara­canuhi eta nútiraya néchaya tamutu. Nájina énaji­vai­nahini náimatihini ema Tata. Nucarichu núti néchinavahi ena nímima­ti­rua­nayare éma. Taicha núti yátupihi eta nímatirahi ema Tata Nucaiyaquene; tacuti­quenehi eta yátupi­ra­hivare eta máimati­ranuhi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yare, ecasiñanu emutu eti evita­ji­ruanahi te iáchanevana eti éyare­ca­rahiana eta éjeca­pi­ravana. Núti nucana­ra­ca­heyare. ");
INSERT INTO ignNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ísapava nunaca­sicahe eta nuyehe yugo. Nucachanehe apaesa ecaravahu nuyehe, taicha núti mánsunu, tétavicava eta núriva eta nusamure. Éti tétavi­cavaya eta iúrica­ca­revaya te iáchanevana te ejacapa eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Taicha eta nuyehe yugo vahi tácajera. Tipeve­jiyare esama —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eta jena sávaru, ema Jesús tiyanapa tipaica. Tiámahavipa viti máimitureana. Témehi­ca­vanapa ena fariséoana. Vétavi­vi­ji­ca­paipahi eta isanitiana. Tacahe, eta vipaisi­rapahi, vécuha­paipa viti máimitureana. Tásiha, vivechu­qui­ha­paipahi étaja­vapahi eta trigo. Vivepi­ra­qui­hapaipa, vépura­ja­ca­cha­va­paipahi. Vinicapaipa, taicha tísapa­ca­reichucha. ");
INSERT INTO ignNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Énasera ena fariséoana eta náimara­ra­si­rapahi, tisema­ma­ju­heanapa. Ánipa naicha ema Jesús: —Pímaha ena pímitureana. Ticaema­ta­nea­na­paichucha eta navepi­ra­qui­hapahi eta trigo puiti juca sache tétavi­cavahi eta tacapi­ca­huirahi. Vahi tísapa­ca­remahi eta juca nacaema­ta­nérahi puiti —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tásiha, majica­pa­vacapa ema Jesús: —Németeaca éti vahi ecaicutiara eta tacaye­maquene eta Sagrada Escritura, eta máichava­que­nevahi ema víyarahaini David eta mapaisi­rapahi técuhapaipa, énerichuva ena téhica­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Écharichuhi éti te masiapapa eta mapena ema Viya, tiyase­se­recapa eta manica­yarehi. Náijaracapa eta pan tacapi­ca­hu­quenehi nanaca­sarehi te mamirahu ema Viya. Nanica­sarehi ena tiyuja­ra­ca­rahiana, émasera ema David vahi tátupa­ra­cahini manicahini. Étasera eta máecuavahi, manicapa eta pan, énapa ena macacha­ne­que­nea­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Váhipuca échajicuha éti eta te Sagrada Escritura eta mavanairipi ema víyarahaini Moisés eta nayehe ena tiyuja­ra­ca­rahiana téchapa­ji­ri­canahi eta Templo. Éna, tájina natapi­ra­vai­nahini eta nacaema­ta­nerahi te sávaru­muhuana. ");
INSERT INTO ignNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Taveti­ji­chapuca puiti nutiari­hipahi núti. Ichápe­que­né­nu­pánahi tayehe eta Templo. ");
INSERT INTO ignNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Éti váhivare ecaicutiara eta juca máechaji­ri­ruvana ema Viya: “Núti nuvaraha yátupinaini eta ejapa­nu­rai­vainaini. Taicha te vahi, tamapu­ru­jiyare eta ecama­va­huirahi eta nuyehe” macahepa. Te ecaicu­tia­rahini, váhiya­rehini ecaeca­hivaca ena nímitureana, taicha éna tájina natapi­ra­vai­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tiuri puiti, numeta­ca­heyare: Núti Manere­ji­ru­nuhi ema Viya, nútirichu néchahi eta sache nanara­siraya ena achaneana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Te apana­varepa sávaru, tiyanavare ema Jesús tisiapahi tayehe eta náuruji­si­rareva. ");
INSERT INTO ignNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ánaqui matiarihi ema achane vaipa tayamu­ri­cahini eta mavahu, tépena­vahuipa. Natiari­hi­hivare ena fariséoana, natanu­ji­ricahi eta ticaviu­re­va­yarehi ema Jesús. Nayase­recapa éma: —¿Táuricapuca vicana­ra­cavaca ena nacaju­ma­queneana te sávaru­muhuana tacapi­ca­hu­quenehi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ema Jesús majica­pa­vacapa: —Nímicu­ti­chinahe puiti. Németeaca májina émanaina achane vahi macuja­pa­nuhini eta máitatiquene uvesa, te téchipai­ca­vapuca te pusu te jena sache tacapi­ca­hu­quenehi. Eta máeñamirahi, tipatsicava mavecuha eta paure sárare. ");
INSERT INTO ignNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Núti numetacahe: Ema maca achane tiápaju­cavahi eta téñamacare tayehe eta uvesa. Tacahe, tísapa­ca­réchucha víchayare eta táuriqueneana te sávaru­muhuana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tásiha, ema Jesús máichuhapa ema achane ticaju­ma­vahuhi: —Nímaha. Picaja­ru­vauchava, pímereca eta pivahu —máichapa. Tacahe, ema achane eta macaja­ru­vau­chi­ravahi, eneva­ne­rinehi tinaraca eta mavahu. Tiúrivarepa tichava, tacutipa eta mavahu sapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tisema­na­rinehi ena fariséoana eta náimairahi eta máichaquenehi ema Jesús. Tiyananapa. Tinacu­cha­vanapa eta napane­re­chirahi eta nacapa­si­ra­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tacahe, ema Jesús, te máechapa eta napane­reruhi ena fariséoana, navarairahi nacapaca, tiyana­varepa tipaicahi. Náehicapa ena camuri­queneana achaneana. Éneri­chuvare, náiteca­pau­chapaipa ena nacaju­ma­queneana. Macana­ra­ca­va­capaipa namutu. ");
INSERT INTO ignNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mavane­ca­pai­pasera ena macana­ra­rua­napahi vahi nacume­ta­jirica eta émairahi ticanaraca. ");
INSERT INTO ignNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eta juca títaucha­vapahi eta máechaji­ri­ruvahi ema Viya tayehe eta májurehi ema víyarahaini profetaini Isaías. ");
INSERT INTO ignNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ánipa tacahehi: “Nuvaraha ímatiya ema vanairucahi nuyehe, nunere­jiruhi núti. Tétavi­cavahi eta némuna­sirahi, núrisa­mu­re­hivare máicha. Ímatiyare éma taicha mávaháruhi ema Espíritu Santo máijararuhi éma. Ema nuvanara, tímitu­ca­va­cayare ena achaneana te tamutu avasareana eta nuvanai­ri­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Éma, tájina máitucaimahi téhacaca. Váhivare tipiara­re­caimahi, macuna­chi­ravahi te cálleana tayehe eta máichaque­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mánsuhi éma taicha ticayehehi paciencia. Macami­cha­vacahi namutu. Váhivare macaja­chaimahi nácani vahi túmeanaina. Tiámainucava te máejacapa tayehe eta mávacu­reyare, muracainapa eta mávacu­reyare. ");
INSERT INTO ignNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tásihasera, namutu ena achaneana te avasareana ticune­va­nayare eta mayehe, navarai­rayare máurichayare éma” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tacahe, ena achaneana námapaipa ema achane púchuqui, úpavare, taicha mávaháruhi ema éreana. Navarahahi macanaraca ema Jesús. Jéhesa­re­hisera ema Jesús macana­racahi. Tiúripa téchejica, tímairi­ri­ca­varepa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ichape­rinehi nárami ena achaneana. Tásiha, ánipa nacahe: —Ema maca Jesús, émapa­chupuca ema Cristo, ema vicucha­pa­quenehi mámariequene ema víyarahaini David —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Énasera ena fariséoana napane­rechahi náepiyae­que­ne­ha­yarehi. Ánipa nacahe: —Ema maca Jesús, eta macuchu­si­ra­vacahi ena éreanana, vémeteaca máijararuhi eta máitupa­ji­jia­si­ravahi mayehe ema Satanás, ema náquenu­murihi ena éreanana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ema Jesús máimatihi eta napane­reruhi éna. Tacahe, máichavacapa: —Nímicu­ti­chinahe puiti ena machanerana ema gobierno. Éna vahi típutsi­mu­ri­ha­ca­ca­naimahi apinai­na­hi­pucaini partido. Te típutsi­mu­ria­ca­canapa, énaji­ca­cai­pa­pucaini tiáquipai­cacana. Énaripa ena achaneana te avasare, vahi táurica náiputsi­mu­ria­vahini. Émaripa mácani achane, te camurianahi ena machicha­naveana, váipari­ne­hivare típutsi­mu­ria­va­naimahi náehaji­ri­ca­cahini, énaji­ri­ca­cahini náquipai­ri­ca­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ene macahehi ema Váinaraji Satanás, váiparinehi máisapahini típutsi­cacana ena machamuriana, taicha mavarahahi tisimu­tua­na­yarehi éna, tímiya­na­va­na­yarehi eta nacaete­ma­ji­ri­si­ra­ha­vi­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Éti ímijachaipa nútirichu machamuri ema Satanás, táichavenehi eta nurata­hairahi nucuchu­cavaca ena éreanana. Tájina vahi étupi­ca­vahini éti eta juca epane­reruana. Te émahipuca tímica­ta­canuhi ema Satanás, éneri­chu­hivare éti máimica­ta­rua­na­hivare jácani éma, eta ecuchu­si­ravaca ena éreanana. Epane­re­chi­ná­vanuma. ");
INSERT INTO ignNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Émaque­ne­hisera ema Espíritu Santo, tíjara­canuhi eta juca nurata­hairahi nucuchu­cavaca ena éreanana. Eta juca étara ícutiaraya éti eta matupa­ra­si­ranuhi ema Viya eta nútirayare nécha tamutu. Nútiripara nuti ecucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nájina tisiapaimahi eta námere­cahini te jácani peti matiarihihi ema túmequenehi. Tacamunuhi nacara­ta­ca­nu­mayare, náitiaca­nu­ma­yarehi éma. Jéhesare, náituru­ye­cha­sa­re­yarepa eta máimaha­queneana. Ene nucahehi núti, túmepa­nanuhi mayehe ema maca Satanás. ");
INSERT INTO ignNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Te vahi éhicanu, ecaema­ta­nea­si­ranuya, machamu­rihehi éti ema ticatia­na­canuhi. Masapiha ímica­tacahi éma eta macaete­ma­ji­ri­si­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Nutupiruva numetacahe: Eperdo­na­cha­careana eti achaneana eta epeca­turana, tamutu jácani échaji­sihaira eta táiñema­hi­queneana. Jácani te ecaeca­hi­nu­hipuca nuti Manere­ji­ru­nuhi ema Viya. Jarari­hisera eta epecatura vahi tiperdo­na­cha­ca­remahi. Éti ímijachahi ema Satanás ema tiávahá­canuhi. Ichape eta éjeca­pi­ravahi, taicha ema tiávahá­canuhi núti, émaquenehi ema Espíritu Santo. Éti epana­ra­ra­caripa éma. Tásiha, tájina eperdo­na­cha­ca­reimahi puiti juca ítare­si­raichaha, evetijipa te apana ítaresira —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tímaticare eta yucuqui te tiúrinisihi eta tacahira. Tímati­ca­re­hivare eta apana yucuqui, máuriraha eta tacahira. ¡Epanerecha! Núti níchahi eta táuriqueneana nayehe ena achaneana ticata­ji­vanahi. Éta tímereu­chanuhi eta mávahá­si­ranuhi ema Espíritu Santo. Téhesera nucaete­ma­re­cahini, níchahini eta máemata­ne­repiana ema Váinaraji, jéheva­re­se­ra­pucaini eta tímereu­cha­nuhini eta mávahá­si­ra­nui­nahini éma. ");
INSERT INTO ignNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Étisera machicha­na­vea­na­tataji ema Váinaraji! Váiparinehi ítucaimahi échajisiha eta táurina­queneana, taicha éti tamave­ra­siavahi eta evaina­ra­jivana. Eta échaji­ri­ru­vanahi ticaecherahi eta evaina­rajiva te esamureana. ");
INSERT INTO ignNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nácani tiúriana achaneana, tatupi­ruvahi eta náechaji­ri­sirava taicha tiúrihi eta nasamure. Nácanisera achaneana váinarajiana, vahi tiúrimahi eta náechaji­ri­sirava. Tíñema­hi­pi­vacahi taicha tavayuchahi eta tavaina­rajiva eta nasamure. ");
INSERT INTO ignNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nutupiruva numetacahe: Te táitecapapa eta sache táiteca­pi­rayare eta juício, emutu ecaya­se­re­hiyare eta échaji­si­hairana eta tamaepe­ra­ji­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Étaripa eta tiviucha­heyare. Téhesera tiúrihipuca eta échaji­si­hairahi, vahi ecaicu­ñaimahi. Tájina tiviucha­hémahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tacahe, nayaseacapa ema Jesús ena fariséoana énapa ena escribá­noana. Ánipa náicha: —Tata maestro, vivaraha picuchucaini eta tiáramicare, te yátupipuca mavane­ruvihi ema Viya —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ema Jesús majica­pa­vacapa: —¡Eti achaneana váinara­ji­queneana! Núti nímatihe. Vahi esuapa­nuimahi, te nímere­ca­pucaini eta tiáramicare. Tásiha, váhinéni étina tatuparaca ímahahini eta tiárami­careana. Ímaha­ya­resera eta tiáramicare tacutiyare eta máichava­que­nevahi ema víyarahaini profetaini Jonás. ");
INSERT INTO ignNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Taicha ema Jonás masiapa­juechahi eta ichapequene jima, mapana sache eta mayerevahi, mapanavare yati. Ene nucaheyare, núti Manere­ji­ru­nuhi ema Viya, mapanayare sache, mapanavare yati, eta nucaheyare eta nucaeca­ra­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Eta jena sácheyare téchepu­ca­nayare namutu, tiúchucu­ha­nayare ena achaneana ticava­sa­náinihi acane te Nínive. Tisipe­ca­tu­ra­ra­hia­na­hinéni éna. Natupi­ru­va­hisera nasuapa eta mametarairu ema Jonás. Téneucha­va­na­vanehi. Tásiha, te jena sácheyare, nacahenapa eyehe éti: “Táuricapa nacaicuñaini ena nani mapara­juruana ema Cristo, táichavenehi eta namasua­pirahi éma. Taicha éma, máurique­ne­panahi mayehe ema Jonás” nacahénapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tacutiquene esu reina Seba eta acane, te susamai­ri­ricapa eta máitupa­ji­jia­si­ravahi yátupi ema Salomón. Ésu, tayére­hi­que­ne­hinéni eta suávasa, tiyana­hisera sucapayaca ema Salomón taicha suvarahahi susama­yarehi éma. Tacahe te téchepu­canapa namutu, ésu suyasea­cainapa eta ecaicuña éti máetupi­cu­shianahi puiti. Sucahe­na­papuca: “Táuricapa nacaicu­ñahini ena nani máetupi­cushiana, tájina náetseraruina nasamaripa ema Cristo, ema títupa­ji­jiá­pa­navahi mayehe ema Salomón, tásiha vuíchaha­caruva nasuapa” sucahé­na­papuca jácani. ");
INSERT INTO ignNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tímiyanava eta máechaji­si­ravahi ema Jesús, ánipa macahe: —Éneri­chuvare éti ecuti mácani achane máinajiruhi ema émana éreana. Ema éreana tiyana matanu­cainapa eta jácani masiapi­ha­yarehi. Eta mamaichi­mavira eta mavara­haquene, mapane­re­cha­yarehi tichava. ");
INSERT INTO ignNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Macahé­na­papuca: “Nuyanayare nuchava, nusiapa­yareva mayehe ema návahá­ruinihi”. Te títecapapa ema éreana mayehe ema achane mávahá­ruinihi, máimahapa ema achane máinaji­caripa eta mapeca­turana, vuíchahasera máehicahini ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tásiha, tiúrisa­murepa ema éreana. Tásiha, tíchuarecapa ena siétequeneana machamuriana. Váinara­ji­panana éna. Nasiapa­ha­cai­na­varepa namutu éna. Jéhesare, tiápaju­cavapa eta mavaina­rajiva ema paure achane. Ene ecaheyare éti, taicha eta emasua­pi­ranuhi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tímitu­re­ca­richaha ema Jesús nayehe ena achaneana, títeca­panecha esu maena énapa ena mapara­pe­naveana. Nanasi­hisera te aneca. Navarahahi náechaji­ca­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Natiarihihi ena timeta­pa­nanahi ema Jesús. Ánipa nacahe: —Esu pémuna­ru­quenehi pena énapa ena pipara­pe­naveana, nararihi ani te aneca. Navarahahi téchaji­caviana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Émasera majicapapa: —Yátupi némuna­ca­vacahi esu meme, énapa ena nupara­pe­naveana. Narari­hisera ani te juca nuchacaya ena némuna­rua­na­hivare, nupara­pe­na­veanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tásiha, tisuve­cha­havipa viti mayeheana apóstoleana. Tásiha, macahepa: —Numetacahe, ena nani ena némuna­rua­na­hivare. ");
INSERT INTO ignNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taicha namutu nácani ticaema­ta­nea­canahi me Tata tiávihahi te anuma, énahi ena némuna­rua­na­hivare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te jena sache, tiyana­varepa ema Jesús, macaijuhe te tachausi eta cáquiure. Téjaca­varepa eta ánaqui eta máimitu­re­si­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tásiha, camuria­na­pa­hivare ena achaneana títeca­pau­chanahi éma. Eta navayu­chi­raripa ena achaneana, tiyanapa ema Jesús tiávacuhapa tayehe eta pacure. Ena achaneana nanasipa te tachausi tiájipahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tásiha, camurihi eta máimicu­ti­cha­que­neanahi eta máimitu­si­ra­vacahi. Ánipa macahe: —Matiarihi ema émana achane. Tévapanahi te máesane. ");
INSERT INTO ignNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Eta mapaisi­rapahi, témiri­capaipa eta evaraqui te achene. Táimahapa eta cáyure, tanicapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eta mayeherepi éma eta máevasira, máevaja­japaica eta apaquehe. Tásiha, eta apamuri evaraqui témiricapa te váhirichu tamitu­tuhini eta máteji taicha máripahi eta apaquehe. Tímaru­ca­va­ne­paneni táicha. ");
INSERT INTO ignNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Téhesera te tíjurepa eta sache, tacapa­jicapa; taicha váhirichu táupare­va­cahíni. ");
INSERT INTO ignNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tacahe, eta apana evaraqui témiri­capaipa te tataracu eta itapepaire. Tiúrina­hinéni eta táimaru­sirahi, étasera eta itape tacachu­ricapa eta tajuru­sirahi. Táemuriachapa eta sucureca. ");
INSERT INTO ignNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tacahe, eta apamuri evaraqui témiri­capaipa te tiúrina máteji. Tiúrina­panahi eta tajurusira. Eta étana, ticahipa tétupi­ca­va­panapa. Eta apanavare, ticahipa ánimuríchu. Eta apanavare, ticahivare apaesa­sa­jiruichu. ");
INSERT INTO ignNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Esama­ra­racanu emutu éti. Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­na­vayare. ");
INSERT INTO ignNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tacahe, viti mayeheana apostóleana vémeña­havapa eta mayehe ema Jesús. Viyase­recapa tájahapuca tacayemahi eta máimicu­tia­ra­chi­ra­va­caichucha eta máimitu­si­ra­vacahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tásiha, ema Jesús tijica­pa­havipa: —Ema Tata titupa­ra­canuhi nítame­ta­ca­heyare éti eta juca táequene­reruana mapane­reruana. Mavaraha ímatie­que­nehaya éti. Énasera ena apamuriana achaneana vahi nítame­ta­ca­va­caimahi, náimaina­vainepa éna. ");
INSERT INTO ignNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Éti, te esuapa yátupihi eta nímitu­rapiana, ema Espíritu Santo tímitu­caheya tamutu eta tacaye­ma­que­neanahi. Énasera nácani vahi návara­hahini nasuapa, énaji­vayare tíchavana ticave­re­ji­ca­sianaya eta nasama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eta tacahehi eta nímitu­si­ra­vacahi, nímicu­tia­ra­chi­na­va­caichucha. Te apaesarichu eta navarairahi náituca, vahi nacaicu­tia­rahini eta juca nímecha­que­neanahi. Nasamahi eta néchaji­ri­ruvana, váhisera nacaicu­tia­rahini eta nímitu­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Puiti ena nani achaneana nacuti ena achaneana acane, vahi nasuapahini ema víyarahaini profeta Isaías. Ánipa macahe: “Nímatihe éti. Esama­ya­re­né­nipuca, váhisera ecaicu­tia­raimahi. Ímaha­ya­re­hi­né­nipuca, váhiva­resera ímatie­que­ne­haimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Taicha eta esamureana eti achaneana, tétavi­cavahi eta tamuracava. Vahi evaraha esama. Épiya­ca­va­hivare púchuquihe, emava­rairahi esuapahini te esamureana. Tájinapa táichahíni vicucha­pahini eta éneuchi­ra­vai­nahíni, evarai­ra­pucaini ecasi­ña­vahini me Viya, apaesa macana­ra­ca­hehini” macahepa ema víyarahaini Isaías. ");
INSERT INTO ignNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Étisera eti nímitureana, tétavi­cavahi eta iúrica­ca­revahi, taicha esuapahi eta juca ímaha­que­neanahi étapa eta esama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nutupiruva numetacahe: Acane ichape­muriana ena achaneana tiúriana énapa ena víyara­hanaini profetana, tétavi­cavahi eta navarairahi tímatinuana, náimahavare eta juca níchaque­neanahi ímaha­que­neanahi. Navara­ha­varepa nasama eta nímitu­re­sirahi. Váipasera nacapa­ya­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ácaicu­tiaraicha eta juca nímicu­tia­ra­cha­quenehi mayehe ema tévacarahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Núti níchuhavaca ena achaneana, machane­ra­nayare ema Viya ena téhica­nua­nayare. Tásiha, natiarihi ena achaneana nasama­ri­pa­hinéni eta nímitu­ra­pianahi, émasera ema Váinaraji vahi máisapahini tánasihini te nasamureana. Enevanehi macami­ti­si­cavaca eta náimitu­ca­si­va­nainihi. Éna nacutihi eta máteji muraca­pa­hi­quenehi te achene. ");
INSERT INTO ignNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Natiari­hivare ena apamuriana achaneana, nacutihi eta máteji máripahi. Te nasama­raraca eta nímitu­rapiana, natupi­ru­vanehi nasuapa, tiúrisa­mu­rea­nainehi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Váhisera nárata­hahini nacara­va­huhini yátupi­nahíni. Vahi nácutihíni eta evaraqui tiúparehi. Ánipirichu eta náehisirahi, taicha vahi nacami­chahini jácani nacata­ji­vai­ranahi. Váhivare túmesa­mu­rea­nai­nahíni te tatiarihipa eta jácani nacatichaira ena achaneana táichavenehi eta náehisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Natiari­hivare ena apamuriana achaneana nacuti eta máteji te távihahi eta itape­quijiana. Éneri­chuvare nasama­ra­ra­ca­hinéni eta nímitu­rapiana. Napane­ré­que­ne­ha­hinéni, tahapa­pi­ri­ca­va­ca­hisera eta jácani táichara­ra­ca­va­yarehi eta náitaresira. Tavayua­ca­va­cavare eta tájipa­racana, étapa eta navarairahi tirrico­chavana. Tamutu eta juca táemeta­vícahi eta navarairahi téhicanuana. Tamapu­ru­ji­yarehi eta najaca­pirahi eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Natiari­hisera ena apamuriana achaneana nacutihi eta tiúrina máteji. Éna, tisama­nuanahi. Náunacahi yátupi eta nímitu­rapiana, náimatie­que­ne­hairahi. Tájinavare náichira­vai­nahíni eta náehisi­ranuhi. Ichape eta nacaema­ta­nea­sirahi ema Viya. Nararihi ena apaesarichu eta nacaema­ta­nea­sirahi. Narari­hivare ena apamuriana, nativa­re­re­ha­panapa eta nacaema­ta­nea­sirahi. Tásiha, ena apamuriana, ichape­mu­ri­panapa eta nacaema­ta­nea­sirahi ema Viya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ema Jesús máimicu­tia­ra­chavare ena achaneana eta máimitu­si­ra­vacahi: —Puiti nuvaraha nímitucahe tatiari­hiyare eta sácheyare te táitecapapa eta nacaye­se­re­hiraya me Viya ena achaneana. Tacutihi eta máichava­queneva mácani achane tévacarahi eta tiúrina evaraqui tayehe eta tiúrina máteji. ");
INSERT INTO ignNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Étasera te tímacapa ema ticayehe eta sucureca, macahepaipa ema macatianaru. Máimisi­ri­qui­chinapa eta táiñema­hi­queneana ejare. Tásiha, tiyanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tacahe, te tímaru­cainipa eta evaraqui trigo, tiúchuca­varepa eta ejare, tacacha­nepaipa eta evaraqui. ");
INSERT INTO ignNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Náraminehi ena machane­ranahi ema achane tévacarahi. Tiyananapa nametapana ema náejaháruhi. Ánipa náicha: “Tata, eta jena pévaraquihi, tájina tacasi­ri­quihini eta táiñema­hi­queneana ejare. Puítisera tiúchucapa tacacha­ne­paipahi eta pévaraquihi” náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ema náejaháruhi majicapapa: “Matiarihi mácani ticatia­na­canuhi. Éma tíchahi eta juca, tímisi­ri­qui­chi­nanuhi”. Tásiha, ema machanerana náichapa: “¿Pivara­hapuca, tata, viyana víti vivepuriha eta jena ejareana?” ");
INSERT INTO ignNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Éma majicapapa: “Vahi tiúririne, taicha machu táimive­purica eta névaraqui trigo. ");
INSERT INTO ignNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tácuti­ca­ca­richaha eta tajuru­si­rayare. Tiámainucava te tacaecha­tijipa, nuvane­ca­hénapa éti nuchanerana tativayare evepurica eta ejarejiana, ítiji­cainapa eta tacaijui­rayare. Tásiha, evehai­na­sarepa eta trigo, ticaunainapa te tacaunairare”. ");
INSERT INTO ignNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ema Jesús máimicu­tia­ra­chavare eta taqui eta mostaza eta máimitu­re­sirahi. Ánipa macahe: —Puiti nuvaraha nímitu­caheya eta apana tayehe eta evaraqui ánichi­chaquene, étasera te tijurucapa, tíñeji­yarehi. Tacaheyare eta tajuru­si­rayare eta nímitu­rapiana nayehe nácani tijaca­pa­nayare. Ímatichuhi éti eta taqui eta mostaza, eta ánichi­cha­panahi tayehe eta apamuriana evaraquiana. Tásihasera te tímarucapa, tiúnayarehi eta táenaqui, tacuti­yarehi eta yucuqui eta táichapeva. Tacachu­ri­ca­yarehi eta apamuriana evaraquiana. Járaja­painapa eta cáyureana. Táepiya­cainapa eta tamacajiana te tatava­vajiana. Ene tacaheyare eta tajuru­si­rayare eta nímitu­rapiana núti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Éneri­chuvare máimicu­tichina eta juca apana máimitu­re­sirahi. Ánipa macahe: —Tacutiquene, eta juca nímitu­rapiana tímicu­ti­ji­ri­cavahi eta levadura. Esu súcani esena tiúrihi eta tasisi­jisira eta suyehe levadura te tamutu eta suépiyaruhi masa, tayanapane apina­pucaini arroba eta suyehe jarina, tasiha­ji­ca­hisera. Jéhesare, tiápuca­yarehi tiuri. ");
INSERT INTO ignNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ema Jesús tamutu máimicu­tia­ra­chi­napahi eta máimitu­re­sirahi. Tájina étahena te tímitureca, vahi macuna­cahini eta máimicu­ti­chi­na­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Títauchavahi eta juca máechaji­ri­ru­vanahi ema émana profeta. Ani macahehi: “Tamutu eta nímitu­ra­pia­nayare nímicu­ti­chi­na­ya­repahi. Nímicae­che­ra­chainapa eta táeñaure­va­quenehi te tépana­vainapa máepiya­cainapa ema Viya eta apaquehe” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tacahe, ema Jesús mavane­ca­vacapa ena achaneana nayanapa te napenana. Éma apanava tiyana­varepa tichava te mapena, vítipa viti mayeheanahi apóstoleana. Tacahe, te véjacapa vimutu, viyase­recapa máimicae­che­ra­chahini eta máimitu­rapihi máimicu­ti­cha­quenehi eta ejare tacacha­ne­quenehi eta trigo. ");
INSERT INTO ignNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tacahe, ema Jesús máichahavipa: —Nuti Manere­ji­ru­nuhi ema Viya nucutihi ema achane tévacahi eta tiúrina evaraqui. ");
INSERT INTO ignNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eta apaquehe tacaevaiyahi eta trigo, énahi ena achaneana te juca apaquehe. Eta tiúrina evaraqui, étihi eti nuchane­ranahi núti. Tásiha, eta ejare énahi ena machane­ranahi ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Taicha ema ticatia­na­canuhi, manacahi eta ejare, mavarairahi máepacu­cha­yarehi eta névaruhi núti. Eta tacaecha­ti­jirapa eta trigo, étahi eta táitavi­rayare eta apaquehe. Náraja­pa­yarepa ena ángeleana, ticuru­ji­ri­ca­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Tásiha, te jena sácheyare, nuti Manere­ji­ru­nuhi ema Viya nuvane­cainapa ena nuyeheana ángeleana nacavehasi ena tíchanahi eta máepera­ji­queneana énapa ena tímiaqui­paicana ena apamuriana achaneana. Tásiha, náquiji­ca­va­cainapa eta te táijure­quenehi yucu. Ticapi­ti­quia­he­cha­va­nainapa eta tacati­vayare nasama. Tíyaha­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tásiha, nácani títauchanahi eta mavanai­ri­pianahi ema Viya, tétavi­ca­vayare eta najarai­vayare tacutiyare eta tajaraiva eta sache. Téjaca­nainapa tayehe eta macatu­pa­ra­haiyahi ema Vicaiyaquene. Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya. ");
INSERT INTO ignNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Eta nímitu­rapiana nuti násiha­quenehi te anuma tacuti eta tayumu­ru­re­va­quenehi entierro. Te máichimavahi mácani achane eta entierro, tiúrisa­mu­re­yarehi. Tásiha, máimicha­va­yarehi mayumuruca tayehe eta apaquehe távihahi. Mavacha­re­ca­yarepa eta apaquehe, mavarai­ra­yarehi eta entierro. Tayanapane táimija­ra­re­ca­yarepa tamutu eta macaye­he­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Éneri­chuvare eta najaca­pirahi ena achaneana eta nímitu­rapiana nuti násiha­quenehi te anuma tacuti eta macaema­ta­nerahi mácani achane comercia­ntepahi. Matanu­capahi eta tasiva­cha­que­neanahi perla. ");
INSERT INTO ignNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te máichimavapa eta perla matanu­repahi, tétavi­cavahi eta tasiva­chavahi. Mavara­hasera mavachareca eta perla, tayanapane táimija­ra­re­ca­yarehi tamutu eta macaye­he­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Éneri­chuvare nuvaraha nímitucahe tayehe eta sácheyare eta táiteca­pi­ra­yarehi eta ecuñaraqui. Tacutihi eta ichape nayutahe. Te náechipaecapa te cáquiure, tamutu taveha­yarehi eta tasimu­tu­queneana jímana. ");
INSERT INTO ignNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te náimahapa tínica eta nayutahe, naveha­yarepa nachuru­paicapa te tiájipahi tachausi. Nanere­ji­ca­yarepa eta jímana tiúrinana. Nanaca­cu­ha­yarepa te ichape maha. Tásiha, náquiji­ca­yarepa eta apamuri máurira­hanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ene tacaheyare eta táitavi­rayare eta apaquehe. Náraja­payare ena ángeleana, nanere­ji­cainapa ena achaneana tíchanahi eta tamauri­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Náijuchainapa te yucu, táetaviuchahi eta táijureva. Ticapi­ti­quia­he­cha­va­nainapa eta tacati­vayare nasama. Tíyaha­nainapa —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tacahe, ema Jesús tiyase­re­ca­havipa. Ánipa macahe: —¿Ecaicu­tia­rapuca éti tamutu eta juca nímitu­ra­pianahi? —máichahavipa. Tásiha, víti vijicapapa: —Vicaicutiara, tata —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tácahe, máichahavipa: —Eta yátupirapa eta ímatie­que­ne­hairapa eta nímitu­rapiana, éti apanavare máestrohénapa. Puiti nutupa­racahe ímitu­ca­vacaya ena achaneana. Tétavi­cavaya eta ítamu­tu­ru­si­rayare eta ímitu­re­si­rayare eta mapane­reruana ema Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te tamutupa eta máimicu­ti­chirahi ema Jesús eta juca máimitu­rapiana, viyanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","57","Vichavapa tayehe eta mávasa. Te sávaru­mu­hu­quenepa, viyana­varepa tayehe eta náuruji­si­rareva eta nayuja­rau­chirahi ena achaneana. Tímitu­recapa ema Jesús. Ichape eta tahapa­sa­mu­re­chi­ra­vacahi ena achaneana. Váhisera návara­hahini nasuapahini. Náepuru­richucha éma. Ánipa nacahe: —Témuna­hi­ricava eta máitupa­ji­jia­si­ra­vapahi ema maca. ¿Távihasica macara­va­huinehi eta máichirayare eta tiárami­careana? Vivaraha vímaha víti apanava eta jácani máichaque­nea­nahiji visamai­ri­ri­ruanahi. Taicha vímatihi ema maca. Carpintérohi éma. Vímativare ema máiyaini, ésupa esu maena María, énapa ena mapara­pe­naveana ema Jacobo, ema José, ema Simón, émapa ema Judas. Vímativare ena esenana mapara­pe­na­vea­na­hivare, ticava­sanahi eta ani. ¿Távihasica máitusiavahi eta juca máituca­que­nea­na­hicacha? —nacahepa. Émasera máichavacapa: —Tatuparaca epicau­cha­haviya vimutu viti mavaneruana ema Viya. Étisera éti nujanea­nanahi ecava­sanahi eta te juca viávasa, étipa eti nupara­pe­naveana, vahi epicau­cha­nuimahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tásiha, tájina máimere­ca­hichaini eta tiárami­careana táichavenehi eta namasua­pa­ji­rai­vanahi, váhivare nacasi­ña­vahini eta mayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tacahe, ema Herodes ema aquenucahi tayehe eta Galilea masamai­ri­ri­ca­varepa eta máichaque­neanahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tacahe, ema Herodes máimijachahi ema tichavahi téchepuca ema Juan. Tásiha, máichavacapa ena máevana­chanahi: —Ema mácara, émaripa ema Juan Tícacha­si­ri­carahi, ema nímica­paruhi. Tichavaripa téchepuca te máecari. Táitusiava máiturucahi macuchuca eta tiárami­careana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Taicha ema Herodes mavehahi esu Herodías, esu machinenahi, mayenahi ema maparape Felipe. Máimina­jicapa ema suima. Tacahe, ema Juan macaja­cha­va­caripa éna eta navira­ca­cairahi. Étapa tímica­tichahi ema Juan, sucatichapa esu Herodías. Tásiha, ema Herodes máeratacapa te cárcel ema Juan, macava­na­ripipa náitiaca te cadena. ");
INSERT INTO ignNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Taicha supamicahi ésu eta máimica­pa­si­ra­yarehi. Tipica­hisera éma nasemahini ena achaneana. Taicha ema Juan, tétavi­cavahi eta náemuna­sirahi ena achaneana. Náimatihi éma, eta vanairu­cairahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tásihasera, títecapapa eta sache máijaremuhu ema Herodes, sutiarihihi esu amaperu, suchicha esu Herodías. Tiúchucapa tírimaica te mamirahu ema Herodes, énapa ena machima­ranahi. Ema Herodes máuricainehi ichape. ");
INSERT INTO ignNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tacahe, máichapa ésu: —Nujuracha te pimirahu, eta níjara­si­raviya jácani piyasea­ru­nuyare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tásiha, esu amaperu suyase­recapa esu suena tájaha­hipuca eta suyasea­ru­yarehi. Esu suena suímitucapa: Piyasea­cayare ani píchaya: “Píjaracanu eta ñichuti eñi Juan te curuja” píchayare. ");
INSERT INTO ignNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tásiha, eta masamirahi eta juca suyasearuhi, ema rey Herodes ichape­rinehi eta mapane­re­re­sirahi. Tájina­pasera máichara­ca­vahini taicha máechaji­ri­ru­vaipahi majura­chaipahi te namirahu ena machima­ranahi eta máijara­si­rayare eta suyasea­ru­yarehi ésu. ");
INSERT INTO ignNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tacahe, macava­nai­ripipa nayucha­ti­pi­que­nu­hapana ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tacahe, námapaipa te curuja eta machutini, náijaracapa esu amaperu. Tásiha, ésu sujacapapa, suíjaracapa esu suena. ");
INSERT INTO ignNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Títeca­pa­nanecha ena máimitu­reanahi ema Juan. Navehapa eta máquehe, náecara­panapa. Tásiha, tiyananapa nameta­panahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te masamai­ri­ricapa ema Jesús eta nacapa­sirahi ema Juan, viyanapa viávacuhapa tayehe eta pacure. Vicaijuhepa tayehe eta apaquehe mávapahi. Énasera ena achaneana náecharichucha eta viyanirahi. Tiyananapa náehicahi tipaica­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te tiúcupaicapa ema Jesús tayehe eta pacure, máimahapa ena camuri­queneana achaneana. Majapa­nu­va­ca­rinehi eta máimaira­vacahi. Macana­ra­ca­vacapa ena nacaju­ma­que­neanahi námaque­nea­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tacahe, viti mayeheana apóstoleana vímahapa eta cápere­hí­chi­cha­rínehi. Vimetacapa éma máevata­mu­rí­hahini ena achaneana natiari­hi­que­neanahi. Víchapa éma: —Cáperehipa jena sache. Tiyere­hi­vacahi eta pétiana. Táuricapa pivane­cavaca ena achaneana nayanapa, navachareca eta nanica; taicha ani tájina naviya­vaimahi eta te juca —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ema Jesús tijica­pa­havipa: —Vahi nuvaraha nuvaneca nayana. Tájina naviyava eta nácaiju­hehini. Íjaraca étina eta nanica. ");
INSERT INTO ignNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tásiha, viti víchapa: —Tájina vácayehe eta tinicacare. Jucari­hisera cíncochichahi eta pan, apina eta jima. ");
INSERT INTO ignNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ema Jesús máichahavipa: —Iáma ani. ");
INSERT INTO ignNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tacahe, macava­nai­ripipa náejaha­hapaica ena achaneana te táinahu eta muíjipahi. Mavehapa eta cíncoquene pan étapa eta apina jima. Máesenicapa eta anuma. Mahasu­lu­pa­yachapa ema Viya. Mayuve­tu­ca­vacapa eta pan, tásiha, tíjara­ca­havipa víti. Víti víjara­ca­vacapa ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vinicapa vimutu, visatu­he­vacapa. Tásiha, vicaema­cha­ri­cha­havare doce saye ichapehiana táinica­chai­chahava eta vémacha­rajiana. ");
INSERT INTO ignNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ena tinicanahi eta juca, cinco mil ena ajairana eta náichape­mu­rívahi, éneri­chuvare ena esenana énapa ena amaperuana. ");
INSERT INTO ignNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tiuri, ema Jesús tivane­ca­havipa viti mayeheana apóstoleana viávacu­hayare eta te pacure. Vínapu­ca­yarehi viánueca te apachara eta cáquiure. Émasera manasi­yarehi máevata­mu­rí­ha­nu­ma­yarehi ena achaneana nachava te napenana. ");
INSERT INTO ignNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te tamutupa eta macame­ta­vairahi ema Jesús nayehe ena achaneana, tiyanapa tiápanahi tayehe eta cerro. Tiyuja­ra­ca­yarehi tayehe. Étapa tavinehi eta yati, manasipa macarichuhi eta te cerro. ");
INSERT INTO ignNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tacahe, víti te túpiere­ca­ha­vi­ripahi, tichima­ra­ca­havipa eta muraca técaticava, viácapa­qui­ha­paipahi. ");
INSERT INTO ignNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Te tijara­ra­hi­chichapa, vímahapa ema Jesús mapaicae­capahi eta une eta macapa­ya­si­ra­haviya. ");
INSERT INTO ignNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eta vímairahi éma, vipica­rinehi. Vímijachapa cunare. Vipiara­recapa eta vipisirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Émasera ema Jesús téchaji­ca­havipa: —Vahi ecupica. Nútichucha. Étumechava —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tásiha, ema Pedro majicapapa: —Te yátupipuca pítiquenehi, piti Tata, pivanecanu núti apanavare nupaicaeca eta une. Nuvaraha nupauchavi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ema Jesús majicapapa: —Yare, pipauchanu. Enevanepa tiúcupaicahi te pacure ema Pedro. Tiyanapa mapaicaecapa eta une, macapa­ya­ca­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Étasera eta márame­sirahi taicha eta muraca técaticava, timutse­ra­ha­vapaipa téricapaipa. Tásiha, tipiara­recapa: —¡Picata­jicanu, Tata! ¡Néricainapa! ");
INSERT INTO ignNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eneva­ne­pasera macara­ta­vauchapa ema Jesús eta macuchu­cui­ra­yarehi. Tásiha, máichapa: —¿Ticami­ti­si­ca­vi­papuca eta pipisirahi eta picasi­ña­nuirahi? ");
INSERT INTO ignNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te tiávacuhapa ema Jesús émapa ema Pedro tayehe eta pacure, enevanepa tésami­ri­cavahi eta técaticava. Tíchecapa eta táepacu­cairahi. ");
INSERT INTO ignNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tacahe, viti apamuriana vicuna­chainehi ema Jesús eta vímairahi. Vépuyu­mu­rihapa te mamirahu. Tásiha, víchapa: —¡Jéhevare piti Tata, Machicha­que­névihi ema Viya! —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tacahe, te apanapa sache, viápecha­va­varepa viánueca eta cáquiure. Vítecapapa eta te apaquehe ticaijare Genesaret. ");
INSERT INTO ignNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tásiha, ena achaneana ticava­sanahi tayehe náimati­vanehi eta émairahi ema Jesús. Timeta­ji­ri­ca­canapa náechapa namutu ena achaneana ticava­sanahi te avasareana. Tiyananapa mayehe ema Jesús, námava­ca­paipahi namutu ena nacaju­ma­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nayaseacapa éma eta máisapi­rai­nahíni náemamajiaca eta tacheyarapi eta mamuiriha. Tacahe, nácani témama­jia­ca­napahi, eneva­nepaipa tinara­ca­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tacahe, títeca­panapa ena apamuriana fariséoana tiásihanahi tayehe eta Jerusalén, énapa ena escribá­noana. Témeña­ha­vanapa eta mayehe ema Jesús. Ánipa naicha: ");
INSERT INTO ignNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Pímaha, ena pímitureana vahi náitauchahini eta viyehe­repiana. Namaepe­ra­jicapa eta náchanevana eta nanisirahi taicha vahi nacasi­pa­va­hu­nu­mahini. ¿Tájaha tacayema vahi napicau­chahini eta viyeherepi nanaquiruhi ena viáchuca­na­veanaini? ¿Étase­rapuca tacahehi eta pímitu­si­ra­vacahi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tásiha, ema Jesús majica­pa­vacapa: —¿Tájaha tacayema éti apanavare, vahi ítauchahini eta mavanai­ripiana ema Viya, tasapihapa epicauchahi eta eyehe­repiana nanaquiruhi ena iáchuca­na­veanaini? ");
INSERT INTO ignNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ema Viya ani macahehi eta macava­nai­ri­pirahi eta viyehe: “Pipicauchaya pémuna­ca­yareva ema piya ésupa esu pena”. Jucarihi eta apana vanairipi: “Ecapa­ca­yarehi mácani tíñemahi eta nacaye­maquene mayehe ema máiya, ésupa esu maena”. ");
INSERT INTO ignNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Étisera vahi epicau­chahini eta júcana mavanai­ripiana ema Viya. Taicha te mararihi mácani achane ticama­va­hupuca me Viya eta máimaha­que­neanahi, eta ímitu­ca­sivahi éti: “Vaipa tatuparaca ema achane eta máimica­ta­siraya ema maiya ésupa esu maena”. Tasapihapa, ichape ticapi­cahuhi eyehe eta eyehe­repiana. Étasera eta mavanairipi ema Viya, vaipa epicau­chahini. ");
INSERT INTO ignNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Éti ecaijarehi apimirana! Tatupi­ruvahi eta máechaji­ri­ruvahi ema Viya, téchaji­siahehi éti eta te Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","Ánipa macahe: “Ena nani achaneana, tétsera­ji­ca­nuanahi te najaca; váhisera táetupi­ca­vahíni te nasamureana. Téneucha­vanahi eta nuyehe, tamapu­ru­ji­hisera eta náeneuchi­ravahi. Nacaera­ji­ca­hivare eta nuvanai­ripiana; tasapihapa náimica­pi­cauchahi eta nayehe­repiana táuchurechucha te napane­reruana ena náchuca­na­veánaini” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tásiha, máichuha­vacapa ema Jesús ena achaneana. Ánipa máicha: —Nuvaraha esamanu yátupina, apaesa ácaicutiara. ");
INSERT INTO ignNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tájina máeperajina eta viáchanevana te vinicapuca eta vimaca­si­pa­va­hui­ra­nu­mahini. Jácani tasiapa­quenehi te vijaca, tájina tamaepe­ra­ji­ca­ha­vihini. Vahi étapa­racaina. Étasera eta evaina­ra­jivana táuchurea­napuca te ejaca, étapa eta evaina­ra­ji­pa­ne­re­ruanahi, jéhevare éta timaepe­ra­ji­cahehi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tacahe, viti mayeheana apóstoleana vémeña­havapa eta mayehe. Vimetacapa: —Ena nani fariséoana tisemanahi taicha eta juca píchira­vacahi —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Émasera máichahavipa: —Ena nani nacutihi eta ejare, vaipa émaimahi máechahini ema Tata Nucaiyaquene. Ticave­pu­ri­ca­sia­na­ya­resera éna. ");
INSERT INTO ignNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ésami­ri­cachucha. Vahi ecuimi­siapava nayehe, taicha éna, púchuquianahi tayehe eta juca nímitu­rapiana. Ena púchuquiana, te tichuru­ca­ca­napuca, tiáquipai­ca­ca­na­yarehi táicha vahi náimahahini eta nayani­ha­yarehi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tásiha, ema Pedro mayase­recapa: —Picata­ji­cahavi pímitu­cahavi apaesa vímatie­queneha eta juca pímicu­tia­ra­chirahi eta táuchureanahi te vijaca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ema Jesús máichaha­vi­varepa: —¿Éneri­chuvare éti mapane­re­ru­rehehi? ");
INSERT INTO ignNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Váhipuca ácaicu­tia­rahíni eta juca? Tamutu eta juca tasiapa­que­neanahi te vijaca vinica­sa­reanahi, tatupiru te viami. Tásiha, te tiúchucapa, apanapa eta táuchusihahi. Vahi timaepe­ra­ji­ca­ha­vimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Étasera jácani táuchurehi te vijaca tásiha­quenehi te amahe eta visamure. Eta tamaurivahi eta náechaji­sirana ena achaneana, étara timaepe­ra­ji­ca­vacahi éna. ");
INSERT INTO ignNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Táicha jácani táiñema­hi­que­neanahi panere­rucana, eta tásiha­que­neanahi te nasamureana. Ema achane mapane­rechahi maveha esu apana esena mayena ema apana achane. Esu esena supane­rechahi suveha ema apana achane suima esu apana esena. Ena amaperuana napane­rechahi eta natuhu­sivaya. Nácanivare, tipane­re­chanahi eta ticapa­recana, tiámerecana, tivayua­recana, téchajihiana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tamutu eta juca panere­rucana tamauri­queneana, te náichahi ena achaneana, éta timaepe­ra­jicahi éna. Étasera jácani nanica­queneana, tayana­pa­nepuca vahi náichahi eta nayeherepi eta nasipa­vau­chirava, vahi tamaepe­ra­ji­caimahi —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tacahe, tiámaha­vi­varepa ema Jesús te apana avasareana táunavahi eta departamento Siria, návasa ena apaecha­ji­ri­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ánaqui, ticapa­ya­ca­havipa esu esena. Supiara­capaipa eta supauchirahi ema Jesús. Ánipa sucahe: —Pájapanunu, tata. Píti yátupi­que­nevihi Cristo, ñivane­ruvihi eñi Viya, vicucha­pa­que­nevihi. Esu nuchicha ñávahácahi eñi éreana, tétávi­cavahi eta sucata­ji­vairahi. Picata­jicanu, tata, eta picana­ra­si­nanuini ésu nuchicha —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Émasera ema Jesús vahi majica­pahini. Tipaica­paichucha. Vipauchapa viti mayeheana apóstoleana, vimetacapa éma: —Tata, pévataca suyana esu suna esena apavasana tipiara­re­capahi te véquene —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tásiha, ema Jesús máichahavipa: —Jéhevare eta epane­reruhi. Ema Tata tivane­canuhi nacarichu néchapa­ji­ri­cayare ena vijaneanana israelítana. Nacutihi éna eta uvesana máquenureana, taicha ticamu­nu­nuanahi eta nujanea­siraya —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ésusera esu esena tépuyucapa te mamirahu. Suíchapa: —¡Tátachicha, picata­ji­ca­nupaini, pímica­tacanu! ¡Picana­ra­si­nanuini esu nuchichasami! —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ema Jesús majicapapa: —Nativa néchapa­ji­ri­ca­vacaya ena nujaneanana. Taicha vahi táuricahini ásapi­hahíni néchapa­ji­ri­ca­hehíni éti apava­sanana émeta­vi­cahíni ena nujaneanana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Esu esena sujicapapa: —Énehinehi tacahehi, tátachicha. Yátupihi vahi pijanea­na­nui­nahini. Pájapa­nu­nusera, picata­ji­ca­nu­chuchaini. Víti apanava vácasi­ñavahi eta piyehe eta vítáti­ji­vairaina —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ema Jesús majica­pa­varepa: —Páurevi piti nuchicha, ichape eta picasi­ña­vairahi eta nuyehe. Puiti títaucha­vayare eta piyasea­rapihi nuyehe. Nucana­ra­si­na­viyare esu pichicha —máichapa. Jéhesare enevanepa tinaracahi esu amaperu. ");
INSERT INTO ignNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tacahe, tiyana­varepa ema Jesús. Véhica­varepa víti apanava. Vichava­varepa te Galilea. Tásiha, vijuche­chau­si­cha­paipahi eta cáquiure, vicaijuheya eta te mávapahi apaquehe anuquerehi, te távihahi eta cérroana. Vinasi­panapa eta jena sácheana eta ánaqui. ");
INSERT INTO ignNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tacahe, nacahe­pai­pavare ena camuri­queneana achaneana te viávihahi víti. Námaque­ne­pa­nepahi ena nacaju­ma­queneana: ena masariana, énapa ena púchuquiana, énapa ena úpana, énapa ena túpupáiqueana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Namutu ena nani nacaju­ma­queneana macana­ra­ca­va­ca­paipahi éma. Ichape­rinehi eta náramirahi ena achaneana eta náechaji­siraipa ena úpana, énapa ena túpupáiqueana tinara­ca­napaipa, tiúripaipa eta napaisira ena masariana. Tímairi­ri­ca­napaipa ena púchuquiana. Eta náurisa­mu­re­vapahi, nacuna­chapaipa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tásiha, ema Jesús tíchuhavipa viti mayeheana apóstoleana. Máichahavipa: —Nujapa­nuvaca ena nani achaneana natiari­hi­que­neanahi ani, taicha mapana­ripahi sache puiti eta nacahehi eta viyehe. Tájina­hivare naviyahini nanica. Nujapa­nu­vacaicha névata­ca­va­cahini, machu náquipaicava te achene taicha eta náecuavana. Vájapanu eta náecuava, vénicavaca —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tásiha, víti vijicapapa: —¿Táviha­pucaini vítusia­vahini eta tinicacare eta te juca mávapahi vámahi? ¡Váhivare vítapa­ra­haimahi vénicavaca ena nani camuri­queneana achaneana! —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tacahe, ema Jesús tiyase­re­ca­havipa: —¿Áyanachaha eta pan eta iámaque­nea­napahi? Víti vijicapapa: —Jucarihi siéterine. Ánimu­ri­chi­cha­ri­ne­hivare eta jímachicha —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tásiha, macava­nai­ripipa eta náejaha­pai­mu­ri­hahíni namutu te apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mavehapa eta siétequene pan, étapa eta jímana. Mahasu­lu­pa­yachapa ema Viya. Tásiha, mayuve­tu­ca­vacapa, tíjara­ca­havipa víti. Tásiha, víti víjara­ca­vacapa ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tacahe, vimutu vinicahi, visatu­he­vacapa. Vicaema­cha­ri­cha­havare. Siétehi eta sáyeana táinicaruhi eta vémacha­rajiana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eta nasimu­tuvahi ena achaneana, cuatro mílqueneana ena ajairana. Natiari­hi­hivare ena esenana énapa ena amaperuana. ");
INSERT INTO ignNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Te tamutupa eta juca, mavane­ca­vacapa ema Jesús ena achaneana nayanapa nachava te napenana. Tásiha, éma tiávacu­ha­varepa te pacure. Viyana­varepa. Vicaijuhe eta te avasare Magdalena. ");
INSERT INTO ignNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tacahe, ena apamuriana fariséoana énapa ena saducéoana napauchapa ema Jesús. Eta navarairahi náemeje­ca­pavacha éma, nayaseacapa máimere­cahini eta tiárami­careana, máimere­ca­vahini te yátupi­hipuca vanairucahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Émasera majicapapa: —Te cápere­hichicha, te ímahahi eta táitsirahi eta úcaji, éti ímijacha tímiya­na­vayare eta tiúriyare eta sácheana. ");
INSERT INTO ignNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te yáticarahi, te ímaha eta timapi­curume, títsitsimehi, ímijachahi tiquivayare. Éti, ímija­chavahi ímatie­queneha eta tapaisira eta anuma. ¡Tétavi­ca­va­hisera eta emasua­pa­ji­raivahi! Taicha éti ímija­chavahi religiósohe, ímija­cha­vavare ímatie­queneha eta mavara­ha­que­neanahi ema Viya, váhisera ávara­hahini ímatie­queneha eta máimeruhehi ema Viya, te juca sácheana nucacha­ne­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Eti achaneana váinara­ji­queneana! Núti nímatihe. Vahi esuapa­nuimahi, te nímere­ca­pucaini eta tiáramicare. Tásiha, váhira étina tatuparaca ímahahini eta tiárami­careana. Ímaha­ya­resera eta tiáramicare tacutiyare eta máichava­que­nevahi ema víyarahaini profetaini Jonás —máichavacapa. Tásiha, majuni­ji­ca­vacapa, tiyanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tacahe, eta viánuesi­ra­varepa eta cáquiure, vipane­re­cha­paipahi eta vémiti­si­sirapa eta pan. ");
INSERT INTO ignNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ema Jesús máichahavipa: —Tímati­carehi eyehe eta levadura eta taparea­sirahi eta masa. Tacutirichu eta taparea­sirahi eta apimi­rai­ra­vacahi ena fariséoana énapa ena saducéoana. Échapavaicha tayehe, vahi ecuehica éna —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Vítisera viti apóstoleana, eta véñama­vairahi, víchacacapa: —Tímica­ja­cha­havihi eta vémiti­si­sirahi eta pan. Eta tacahe, macahehi tayehe eta levadura —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Éma tímatia­ca­havihi. Tásiha, máichahavipa: —¿Tájaha tacayema ecahe­cha­ji­ri­ruvahi eta vahi iámapahini eta pan? ¿Váhipuca ácasi­ñavahi eta nuyehe? ");
INSERT INTO ignNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Vuíchahacaru ácaicu­tiaraini? ¿Vuíchaha­hipuca ímatinu? ¿Váhivare échaini eta nucaeja­pa­sirahi eta cíncoquene pan nanica­quenehi ena cinco mílqueneana achaneana étapa eta náemacha­rajiana? ");
INSERT INTO ignNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Váhiva­repuca écha eta siétequene pan naniruhi ena cuatro mílqueneana achaneana étapa eta náemacha­rajiana? ");
INSERT INTO ignNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nímijachapa ecaicu­tia­ra­yarehi eta níchirahehi eta échapi­ra­vai­nahini eta nayehe levadura ena fariséoana énapa ena saducéoana. Váhira étainahini néchaji­si­hahíni eta levadura tayehe eta pan —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Vipaenu­mavahi véchahi eta máichira­havihi éma eta véchapi­ra­vai­nahini vahi vicucuti ena fariséoana énapa ena saducéoana eta apimi­rai­ranahi. ");
INSERT INTO ignNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tacahe, te apanapa sache, viyana­varepa vipaica. Vicaijuhe eta te Cesarea máepiyaruhi ema rey Felipe. Te viánehipa, ema Jesús tiyase­re­ca­havipa: —¿Tájaha nacayema ena achaneana eta nuyehe nuti Manere­ji­runuhi ema Viya? ¿Nájahapuca náimija­chanuhi éna? —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vijicapapa víti: —Ena apamuriana náimija­chavihi ema Juan, tichavahi téchepucahi. Ena apamuriana tímija­cha­vianahi ema víyarahaini profeta Elías, téchepucahi éma. Ena apamuriana tímija­cha­via­na­hivare ema víyarahaini profeta Jeremías; émapuca ema apana profetaini antívuini, téchepucahi —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ema Jesús tiápecha­ha­vivare tiyase­re­cahavi: —Étiyapa ¿nájaha ímija­chanuhi núti? ");
INSERT INTO ignNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ema Pedro majicapapa: —Pítira yátupi­que­nevihi Cristo, machicha­que­nevihi ema yátupi­quenehi Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ema Jesús majicapapa: —Piti Pedro, tétavi­cavahi eta pétupi­si­ravahi taicha manaca­sa­mu­re­ruvihi ema Tata Nucaiyaquene tiávihahi te anuma. Vahi étáinahini eta máimitu­ra­pi­nahíni piyehe mácani achane. ");
INSERT INTO ignNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Núti apanavare nutupiruva numetacavi. Píti picaijarehi Pedro. Píti picutiyare eta mari, tétavi­ca­vayare eta pitumevaya. Namutu ena picuti­queneana eta pisuapi­ranuhi nútirahi yátupi­quenehi Cristo, énara nuchane­ra­nayare. Éna apanavare nacuti­yareva eta mari eta natume­vayare eta náehisi­ranuhi. Tájina vahi márata­haimahi macaete­mavaca ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Píti picatu­pa­ra­hayare eta llave tayehe eta anuma, apaesa nasiapa nácani pijaca­pa­que­nea­nayare píti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tacahe, titupa­ra­ca­havipa muraca ema Jesús nacuija vicumetaca eta émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tacahe, ema Jesús tépanavapa timeta­ca­havihi eta táichara­ca­vayare eta máepeni­rayare. Máichahavipa: —Nuti nucatu­pa­rahahi eta nuyani­ra­yarehi te Jerusalén. Ánaqui nucata­ji­va­yarehi ichape naicha ena tuparai­ru­cana, énapa ena aquenu­ca­ra­hana, énapa ena escribá­noana. Éna, tímica­pa­ca­nua­na­yareva. Mapana­ya­rei­chu­hisera sache nucaheyare eta népeni­rayare. Tásiha, nuchava­yarehi néchepuca —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tásiha, máiputsicapa mámahi ema Pedro ema Jesús. Ánaqui macajachapa, máijara­si­ravahi eta mapane­reruhi: —Núti vahi návara­hahini táitaucha­vahini nacapa­ca­vihini. ");
INSERT INTO ignNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tacahe, ema Jesús máichapa ema Pedro: —Piti téjeca­pavahi eta pipane­reruhi. Pínajica eta juca tamauri­que­neanahi. Pivara­hapuca pihapa­pi­cayare eta mapane­reruhi ema Viya. Eta juca pipane­reruhi tacuti eta mapane­re­ruanahi ema Satanás, énapa ena machanerana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tásiha, máichaha­vi­varepa víti: —Nácani navaraha náehicanu, tacamunu náinajicava tamutu eta tihapa­pi­ri­cavaca eta náehisi­ranuhi. Nacara­va­hu­yareva eta nímitu­rapiana. Náijara­ca­vavare eta táimica­pa­siraina eta náehisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nácanisera téñamanahi eta náitaresira, tiávami­ra­huanaya eta náehisiranu, énaji­vayare ticami­tie­que­ne­ha­vanaya eta náitaresira. Énasera nácani yátupi­quenehi tíjara­cavana téhicanuana, tayanapane táimica­pa­cai­nepuca eta náehisi­ranuhi, éna títuji­ca­va­nayare tiúchucu­ha­nayare eta náitare­si­ranaya. ");
INSERT INTO ignNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Éneri­chuvare nácani tacaña­ma­ra­ruanahi eta nacaima­ha­que­néiraya te juca apaquehe, tájina náimaeque­ne­haimahi, taicha eta tacaeña­ma­ra­si­ra­vacahi tahapa­pi­ri­ca­vacahi tayehe eta náuchucui­ra­ya­rehini. Taicha vahi márata­haimahi mácani achane mavacha­chahini eta máurica­ca­revaya te apana vítaresira. ");
INSERT INTO ignNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Taicha nuti Manere­ji­ru­nuhi ema Viya nuchava­yarehi. Námainapaipa eta majaraiva ema Tata, nucacha­né­na­pai­pavare ena ángeleana. Te jena sácheyare, níjara­ca­va­cainapa eta náicuchianahi ena nuchanerana te tiúrihi eta nacaema­ta­nea­si­ranuhi, te jácani náemata­nea­na­pachuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nutupiruva numetacahe: Puítiripa éti, etiarihi enere­ji­ca­vayare vahi épena­va­némahi, ímaha­numaya eta nucatu­pa­ra­hairaya aquenu­ca­nui­rayare nuti Manere­ji­runuhi ema Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tiuri, sáisipa sache eta vinasirahi ánaqui. Tacahe, tinaqui­ca­havipa ema Jesús. Nacarinehi máma ema Pedro, ema Jacobo émapa ema Juan. Tiyananapa eta te étana cerro anuque­hepana. ");
INSERT INTO ignNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Eta ánaqui, náimahapa tihapa­mai­chavahi eta máimahi ema Jesús te namirahu éna. Eta mamira, tétavicava eta tajara­rasira tacuti eta sache. Eta mamuiriha, tétavicava eta tajanu­nu­me­sirahi, étapa eta tajapuvahi. ");
INSERT INTO ignNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tásiha, tiárami­ca­rea­na­varepa tímere­cavana ena apinana ajairana: ema víyarahaini Moisés émapa ema víyarahaini profetaini Elías. Téchaji­ri­ca­va­na­ripahi mayehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tásiha, ema Pedro tímisia­pavapa téchajicapa. Ánipa macahe: —Tata Náquenu, tétavi­cavapa eta viúrica­careva eta viávihairahi eta áni. Tiúrihi­pucaini vépiya­re­cahini eta epena­hui­na­pa­chuhini. Pipena­hui­na­ri­chuhini píti, mapenainari­chu­hi­varéni ema Moisés, émapaini ema Elías —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tacahe, técheji­caichaha ema Pedro, tiárami­carepa eta úcaji táepacu­mu­rihahi éna. Tétavi­ca­va­hisera eta tajanu­nu­sirahi eta úcaji. Nasama­varepa eta mahu ema Viya tayehe eta úcaji. Ánipa macahe: —Ema maca, éma yátupi­quenehi nuchicha némuna­ru­quenehi. Tétavi­cavahi eta núrisa­mu­revahi máicha. Éma esuapayti, mapenainari­chu­hi­varare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eta nasamirahi ena vichamuriana, tipica­na­rinehi. Tépuyu­canapa titsiuca­pai­ri­canapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tásiha, ema Jesús témeña­havapa eta nayehe. Máemama­si­ca­vacapa. Máichavacapa: —Échepuca, nuchicha­naveana. Vahi ecupica —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tacahe, te téchepu­canapa éna, nájina­ripahi éna apinana náimaha­que­neanahi. Macarinehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Te tichavanapa tayehe eta cerro, ema Jesús mameta­ca­vacapa vahi nacume­ta­ji­ri­cahini eta juca náimaha­quenehi. Tiámainucava te máechepu­capaini te máecari éma. ");
INSERT INTO ignNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tacahe, nayase­recapa ema Jesús: —Ena escribá­noana eta náimitu­rapihi, náechaji­sihahi eta machavi­rayare títareca ema víyarahaini Elías, tínapu­ca­yarehi eta máimere­si­ra­vayare piyehe piti Cristo. ¿Énapuca téjeca­pa­vanahi ena escribánoana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ema Jesús majica­pa­vacapa: —Yátupi ema víyarahaini Elías títeca­pa­yarehi, máetupi­ri­pa­na­yarehi tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nútisera nutupiruva numetacahe: Títeca­ripahi ema Elías, váhisera náimatihini ena escribánoana. Váhivare najaca­pahini éma ena tuparai­ru­cana. Nacatia­nacahi nacapacahi éma. Ene nucaheyare nuti Manere­ji­ru­nuhi ema Viya, ticatia­na­ca­nua­na­ya­rehiva, éneya­réi­chuvare ticapa­ca­nua­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tásiha, ena vichamuriana náechapa eta máechaji­si­hairahi ema Jesús ema Juan Tícacha­si­ri­ca­rahihi. ");
INSERT INTO ignNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tacahe, te tichavanapa éna tayehe eta viávihahi víti énapa ena achaneana, témeña­havapa ema émana achane mayehe ema Jesús. Tépuyucapa te mamirahu. Máichapa: ");
INSERT INTO ignNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Picata­jicanu, tata, pímica­tacanu. Picana­ra­si­nanuini ema maca nuchicha. Tétavi­cavahi eta macata­ji­vairahi. Tacaecha­ri­pairica te tanahaca eta majuma. Tatiarihi te táquipaica te une, téhepuca yucu. ");
INSERT INTO ignNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Námari­pa­hinéni nayehe ena pímitureana, váhisera nárata­hahini nacana­ra­cahini éna —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ema Jesús máichahavipa: —¡Tétavicava emasua­pa­ji­rai­vavaca eti achaneana! ¡Cúvera­re­ca­cha­sicáini eta nucami­chi­ra­he­nahini! Iáma ani ema amaperu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tacahe, ema Jesús, muraca eta máevata­sirahi ema éreana, máinajiacapa ema amaperu. Enevanepa tinara­ca­vanehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tásiha, te táequenepa, víti víputsia­cavapa ema Jesús, viyase­recapa: —¿Tájahapuca tacayemahi eta vahi várata­hahini vicuchuca ema éreana mayehe ema amaperu? —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ema Jesús tijica­pa­havipa: —Eta tíchahi éti vuíchaha yátupi­nahini ácasi­ña­vahini me Viya. Nutupiruva numetacahe: Te yátupi­que­ne­nahini ácasi­ña­vahini mayehe éma, erata­ha­ya­rehini. Váhinéni tácame­sahini ichape­nahini eta ecasi­ña­vairahi. Tayana­pa­nepuca ánichi­chainaichu eta ecasi­ñai­ravahi, tacuti­hi­pucaini eta táquichicha eta mostaza, tamutu­rihini erataha. Étaripa eta jácani cerro ávara­hahini ecayejeca, erata­ha­yarehi. Te íchapuca: “Piyejecava eta te juca. Piyana ánaquipana”. Tásiha, tiyeje­ca­vahini éta. Jéhesare, tájina tacuca­je­ra­ra­jihini eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Étasera eta juca, muraca­panahi ema éreana ema tiávahácahi ema maca amaperu. Eta vicuchusira, tavaraha víchanu­mayare eta ayuna étapa eta viyujaraca —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tacahe, eta vipaisi­rapahi tayehe eta avasareana eta te táunavahi eta Galilea, tiápecha­ha­vi­varepa timeta­cahavi ema Jesús eta máepeni­ra­yarehi. Ánipa macahe: —Nuti Manere­ji­ru­nuhi ema Viya, járaja­painapa eta sácheyare tíjara­re­ca­nuyare mácani achane nayehe ena ticatia­na­ca­nuanahi. Ticara­ta­ca­nua­nayare éna. ");
INSERT INTO ignNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ticapa­ca­nua­na­yareva. Néchepu­ca­ya­resera te mapana­que­nenapa sache —máichahavipa. Tacahe, eta visamirahi, ichape­rinehi eta véñami­ravahi víti. ");
INSERT INTO ignNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tacahe, te vítecapapa tayehe eta viávasa Capernaúm, natiarihihi ena ticobra­re­ca­rahiana eta impuesto tayehe eta Templo. Nárajapapa náechaji­panahi ema Pedro. Nayase­recapa: —¿Mavacha­chapuca ema eyehe máestro éti eta impuesto tayehe eta Templo? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ema Pedro majicapapa: —Mavachacha —macahepa. Te visiapa­yarepa te peti, ema Jesús máechaji­ca­numapa ema Pedro. Ánipa macahe: —¿Tájaha picayema, piti Pedro, nájahasica tatupa­racahi navacha­chayare eta impuesto mavara­haquene ema mácani rey? ¿Énapuca ena machicha­queneana, énapuca ena machanerana? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ema Pedro majicapapa: —Ena machanerana. Tásiha, ema Jesús macahepa: —Tiuri, viti machicha­havihi ema Viya. Vahi tatupa­ra­cahini vivacha­chahini víti eta juca impuesto. ");
INSERT INTO ignNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Vinaqui­casera eta impuesto apaesa tacuija tacuca­ye­macare nayehe ena achaneana. Piyanayare pénica eta jima te cáquiure. Te piáquijiecapa eta pénirave, eta tínapuca jima tacara­tacaya eta pénirave, tatiari­hiyare eta plata te tajaca. Pivehainapa eta reale, tásiha tarata­hayare tavachacha eta nuyehe parte núti, étapa eta piyehe píti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tacahe, te jena sácheanahi, viyase­recapa ema Jesús: —¿Nájahapuca ema ticapi­ca­hu­panaya viyehe víti te táitecapapa eta sache aquenu­ca­viraya? —vicanaqui­casera eta impuesto apaehepa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tacahe, máichuhapa ema Jesús ema émana amape­ruchicha, macatu­pihapa te vimirahu. ");
INSERT INTO ignNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Máichahavipa: —Nutupiruva numetacahe: Ínaji­cayare eta ecasi­ña­va­vaisira. Echávayare ecutiyare ema maca amaperu, apaesa ítujicava esiapa ecachanenu tayehe eta néjasi­hayare. ");
INSERT INTO ignNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nácani navarahahi ticapi­ca­hu­pa­na­nayare te jena néjasi­hayare núti, tacamunu mánsuanayare. Vahi máitucaimahi tiácapauchava. ");
INSERT INTO ignNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tacutiquene nácani tijaca­pa­nayare ena amaperuana níchave­nénahi núti, ena nani yátupihi náimereca eta náemuna­si­ranuhi núti, taicha tímicu­ti­ji­ri­cavahi nútinahini najacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tacutiquene mácani tiáquipaicaya ema émana amaperu téhicanuhi, tiúripa­na­hi­pucaini máepenahini mativai­nahini éma. Váhiri­chu­pucaini macucai­cu­ñahini, taicha vahi macuaqui­pai­cahini ema amaperu tayehe eta pecatu. ");
INSERT INTO ignNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Taicha muracayare eta náicuñayare nácani tímiaqui­pai­ca­nayare ena achaneana. Yátupi vahi téjiaca­vaimahi eta tímiaqui­paicaya ena achaneana tayehe eta pecatu. Ichapesera eta náicuñayare nácani ticata­pi­ra­vanahi eta náimiaqui­pai­sirahi ena achaneana tayehe eta pecatu. ");
INSERT INTO ignNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Eta tacahe, te táimipe­ca­tu­ra­cha­hepuca eta evahu, étapuca eta ívapeana, tiúripana eyuchatica, iáquijica; apaesa vahi tacuimia­qui­paicahe tayehe eta pecatu. Tiúripana táejiacava eta iáquehe eta esiapi­rayare te anuma, váhisera tacumutuhi tasiapa te yucu eta iáquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Étari­pavare eta iúquiha, te táimiaqui­pai­ca­hepuca tayehe eta pecatu, tavarairahi táimahayare eta tamauri­queneana tájipa­racana, tiúripana evecu­hau­quichava iáquijicaya. Taicha tiúripana eta ejaca­pa­carehi éti eta esiapiraya te anuma tayanapane táejiaca­vapuca eta iúquiha. Páurehe­sa­misera éti, te náepuju­qui­cha­hepuca te yucu infierno, tamutuyare eta iáquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Vahi ecuepuru ena amaperuana. Numeta­ca­hevane: Nararihi ena ángeleana tijanea­ca­vacahi éna. Títupa­ji­jia­ca­vanahi eta nacatiu­chi­ra­vacahi ena amaperuana, máicha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nuti Manere­ji­ru­nuhi ema Viya, eta tímite­canuhi nucuchu­cu­hayare nácani tiávacu­hanahi táiñehiquene eta náitaresira. ");
INSERT INTO ignNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Esama­nuchaha. Nímicu­ti­chi­na­heyare puiti. Matiarihi ema émana achane. Ticayehe eta cien uvesana. Te témiti­ye­chapuca eta étana, ema achane tiyana­yarehi matanuca eta táemitiaruhi. Eta máeñami­ravahi, manaqui­ca­yarepa eta apamuriana noventa y nueve te majanea­re­sihahi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te máichimavapa, tichavapa. Tétavicava eta máurisa­mu­re­va­paipahi eta mámira­paipahi eta táejiaruvahi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ene macahe ema Tata Ecaiyaquene éti, ema tiávihahi te anuma. Vahi mávara­hahini náemitia­cahini ena nani amaperuana. ");
INSERT INTO ignNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Te tatiari­hipuca eta máejeca­pi­ravahi ema piparape eta piyehe, titupa­racavi piperdo­na­chayare. Tásiha, piconse­ja­chayare éma, píputsia­cayare éma eta pimetasira eta máejeca­pi­ravahi. Te tisuapavihi éma, tájinapa íchira­vaimahi. Tiúrinapa eta ítare­sirana. ");
INSERT INTO ignNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Téhesera te vahi macusuapavi, pitanu­cayare apinanaina ena piyehea­nayare testigo apaesa tasuapa­carepa eta piconse­ja­ra­piyare. ");
INSERT INTO ignNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te vuíchaha macusuapavi, pimetacapa namutu ena pichamu­rianahi picatu­pihapa te namirahu. Téhesera te váhique­ne­chapuca macusuapahe, tímati­ca­réinapa éma eta mamasua­pa­ji­raivahi me Viya. Vaipa ecuimi­siapava mayehe, taicha eta mamasua­pa­ji­raivahi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nutupiruva numetacahe: Te ecuru­ji­cacahi, te ímahahi eta mamasua­pa­ji­raivahi, emeta­cayare éma vahi táepahahini eta mapecatura. Tanasi­richuhi. Émaripa ema Viya, máimara­racahi eta evarairahi etupirica éma. Téhesera te máeneucha­vapuca, emeta­cayare éma eta táepahai­raripa eta mapecatura. Ema Viya, tiúriripa eta máimaira. ");
INSERT INTO ignNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Éneri­chuvare te etiari­hipuca éti te juca apaquehe apinahehi, mapana­he­hipuca ecuru­ji­cacahi te níjare núti, nutiari­hi­ya­re­chu­hivare núti te emuri. Tásiha, te étanaichuhi eta epane­reruhi, ticuti­cacahi eta eyase­serepi te mayehe ema Tata, éma tíjara­ca­heyare —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tásiha, ema Pedro mapauchapa, mayase­re­ca­yarehi ema Jesús. Ánipa macahe: —Tata, ¿áyahepuca tatuparaca nuperdo­nachaya ema nuparape, te máejecapava eta nuyehe? ¿Táuricapuca siéteheyare eta nuperdo­na­chi­rayare? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ema Jesús majicapapa: —Vahi tácari­chuimahi siétehéi­na­ri­chuyare eta piperdo­na­chi­rayare. Tímiya­na­va­ya­rechucha eta piperdo­na­chi­ra­nayare. Vahi pitupa­chaimahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nuti Manere­ji­ru­nuhi ema Viya nucuti mácani rey rícoquenehi te mavarahahi máechayare eta nanteveana ena mamusurana. ");
INSERT INTO ignNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tásiha, námapaipahi ema tétavi­cavahi eta manteve. Tisinte­ve­panahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tásiha, ema achane musu, tájina maviyahini mavacha­chi­hahini ema máquenuhi. Tacahe, ema rey macava­nai­ripipa macaija­ra­recasi, namutu esu mayena énapa ena machicha­naveana, étapa eta macaye­he­que­neanaini te mapena, apaesa mavacha­chahini apaesa­chi­chai­na­ri­nehini eta mantevehi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tásiha, ema achane musu tépuyucapa te mamirahu ema máquenu. Ánipa máicha: “Tátachicha, picata­ji­ca­nuhini. Picucha­panuini. Te nítuca­vapaini, nuvacha­chapaini tamutu eta nunteve piyehe” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jéhesare, ema máquenu majapanupa. Maperdo­nachapa tamutu eta mantevenihi. Macaiticapa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Vuíchahasera táyerehini eta máuchusirahi, mácapa­jicapa ema apana achane ticantevehi eta mayehe. Macompa­ñe­roi­ni­hivare. Váhinéni camuri­nahini eta mantevehi. Macara­ta­cahisera, macobrachapa. Masema­racapa macapi­ti­nucapa. “Pivachachanu puítirichu” máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ema achane ticantevehi tépuyucapa te mamirahu. Mayaseacapa: “Picata­jicanu, picucha­pa­nuchaha. Te nítucavapa, nuvacha­chavipa”. ");
INSERT INTO ignNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Váhique­nesera maperdo­na­chahini. Máimica­siapapa te cárcel, mavarairahi mavacha­cha­va­ne­ya­rehini eta mantevehi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tacahe, te náimahapa ena apamuriana machamu­rianahi, ticati­rinehi te nasamure eta náimairahi ema nachamuri présuiraipahi. Tiyananapa nametacahi ema náquenu tamutu eta máichava­que­névahi ema nachamuri. ");
INSERT INTO ignNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","34","Tacahe, ema máquenuhi máimichuhapa ema tipresu­re­cainihi. Ichape eta masema­nevahi. Ánipa maicha: “¡Piti máepera­ji­tataji musu! Váiparinehi péchavahini eta nuperdo­na­chi­ravihi eta pinteve ichape­quenehi. Taicha eta piyasea­si­ranuhi, nuperdo­na­chavihi. Piúriháinehi pájapa­nuhini píti apanavare ema pichamu­suvahi, tácutihini eta nuperdo­na­chi­ravihi núti” máichapa ema rey. Tásiha, macava­nai­ripipa náicuñaca, étapa mavacha­cha­yarehi tamutu eta mantevehi. ");
INSERT INTO ignNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tacahe, ema Jesús te títapi­ricapa eta juca máimitu­rapiana, ánipa macahe: —Ene máichaheyare ema Tata Nucaiyaquene éti apanavare, te vahi ecuituca eperdonacha nácani epara­pe­naveana náejeca­pa­ru­vanahi eta eyehe —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te tamutupa eta juca máimitu­ra­pianahi ema Jesús, viúchucapa te Galilea. Viyanapa tayehe eta Judea. Viánuecapa eta cajacure Jordán te tinapaicahi te táuchusine eta sache. ");
INSERT INTO ignNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Camuriana ena achaneana tiúruji­ca­vanahi. Ánaqui macana­ra­ca­pai­pavare ema Jesús ena nacaju­ma­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tásiha, títeca­panapa ena apamuriana fariséoana. Napauchapa ema Jesús. Natanucahi eta tiviucha­yarehi éma. Ánipa naicha: —Vivaraha pimeta­cahavi ¿te táuricapuca máinajica ema achane esu mayena taicha jácani tájipa­racana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ema Jesús majica­pa­vacapa: —Németeaca vahi ácaicu­tiarahi eta échajicuira eta Sagrada Escritura. Te tépana­vainapa acane, ema Viya máijaracahi ema achane ésuna­ya­reichuhi esu mayenayare. Esu esena émana­ya­rei­chuvare ema suímayare. ");
INSERT INTO ignNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ani tacahe eta mavanairipi ema Viya: “Mácani amaperu achane ésupa esu mayenayare, te ticaimanapa, tatupa­ra­ca­vacahi típutsi­ca­va­na­yarehi eta napenana ena ticachichana. Énaji­vainapa títáti­ca­ca­nayare. Eta naveha­ca­cairahi, tímicu­ti­ji­ri­cavaipa étana­rinehi eta náqueheana” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tacahe, tímicu­ti­ji­ri­ca­vainapa émanai­na­ri­chuhini te peti. Étanarichu eta napane­reruana. Vaipa táisapa­ca­rehini náinaji­ca­cahini. Eta tacahe, mácani máinajicahi esu mayena, éma máepuruhi eta juca mavanairipi ema Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tásiha, ánivare nacahe: —¿Tájahasica tacayema eta mavanai­ripihi ema víyarahaini Moisés ticaepi­ya­yarehi eta ajureca suyehe esu esena eta máinaji­si­ra­yarehi ema suima? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ema Jesús majica­pa­varepa: —Ena iáchuca­na­veanaini, te jácani eta nasemirahi, náinajicapa ena nayenana. Ema víyarahaini Moisés máisapahi tínaji­cacana táichavenehi eta tájinairahi eta náimitu­ca­ca­re­vai­nahini, táetaviu­chirahi eta namura­ca­sa­mureva. Váhisera máuricahini ema Viya eta náinaji­ca­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Puiti nuvaraha numetacahe: Te máinaji­capuca esu mayena mácani achane, te tájinapuca suíchira­vai­nahini; tásiha, mavehapa esu apana esena, ticape­ca­tu­raipahi me Viya. Tacutiquene, mácani maveha­hipuca súcani esena máinajiruhi ema suima, ticape­ca­tu­rai­pavare éma, taicha ésu, matiari­hi­chahahi ema suímaquenehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tacahe, te víputsia­ca­va­varepa, viti mayeheana apóstole viyase­recapa ema Jesús: —Te énehipuca tacahehi eta juca, eta vivira viti ajairana esu esena, tiúripa­nai­chu­hipuca vahi vicutanuca esu esena —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ema Jesús máichaha­vi­varepa: —Vahi ámutu árataha ímatie­queneha eta juca. Narari­hisera tinere­ji­ca­va­na­yarehi náimatie­que­ne­hayare máicha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nararihi ena ajairana vahi natanu­caimahi esu esena nayenai­nahini, taicha eta náquehe vahi táichuhahini esu esena. Narari­hivare ena ticave­cu­hianahi, navetijipa éna vaipa náeseni­caimahi esu esena. Narari­hivare ena apamuriana tinere­ji­ca­vanahi vahi natanu­cahini esu nayenai­nahini, navarairahi tacuija jácani tahapa­pi­cahini eta nacaema­ta­nea­siraya ema Viya. Ticuna­cha­ca­re­pa­nayare ena tirata­ha­nayare eta juca náijara­sirava yátupiquene nacaema­ta­neacaya ema Viya —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tacahe, ena achaneana námava­capaipa ena amuyana eta mayehe ema Jesús. Navarahahi máemama­ha­ca­va­ca­yarehi éna, mayuja­rau­cha­hi­varéni. Vítisera viti mayeheana apóstoleana vahi vísapahini. Vicaiche­paicapa ena tiámanapahi ena amuyana. ");
INSERT INTO ignNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ema Jesús máichahavipa: —Ésami­ri­cachucha ena amuyana, náitecaichaha eta nuyehe. Vahi ecucai­chepaica éna. Taicha ena nuchanerana nuti Cristo nacuti­yarehi ena nani amuyana eta nasuapa­jiraiva éna —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tásiha, máemama­ha­ca­vacapa ena amuyana, mayuja­rau­cha­vacapa. Te tamutupa, viyana­varepa te apana avasare. ");
INSERT INTO ignNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Matiarihi ema achane amaperu rico. Mapauchapa ema Jesús. Mayase­recapa: —Tata maestro, piti piúriquene. ¿Tájaha­pucaini eta níchara­ca­vahíni eta nítuji­si­ravaina me Viya máichecua­ra­qui­ré­nahini eta nítaresira? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ema Jesús majicapapa: —¿Tájaha tacayema pímija­rechanu “Piti piúriquene”? Mararihi ema Viya. Jéhevare éma, tétavi­cavahi eta máurivahi. Téhesera te pivara­hapuca pécha te apana vítaresira, pisuapayare eta vanairipiana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mayase­re­ca­varepa ema achane: —¿Tájahasica eta vanairi­pianahi eta nusuapa­queneya? Majica­pavare ema Jesús: —Eta juca eta mavanai­ripiana ema Viya: Vahi picuca­pareca. Vahi picuveha esu esena apayena. Vahi picuamereca. Nacuija pépiyé­que­neruina. ");
INSERT INTO ignNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pipicau­chayare ena ticachi­chaviana. Pémuna­ca­yareva ema piparae­piyahi, tácuti eta pémuna­si­ravahi píti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tacahe, ema achane majicapapa: —Tamutu eta juca nusuapahi nítauchahi. ¿Tájaha­se­rapuca eta jácani néjeque­rui­chahahi? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ema Jesús majica­pavare: —Te pivaraha pítaucha tamutu, piyana píjara­recaya tamutu eta pímaha­queneana. Tásiha, píjara­ca­vacapa ena páureana. Jéhevare éta, pijaca­payare eta pímaha­que­neyare te anuma táitsivayare. Te tamutupa eta juca, píteca­vanepa péhicanu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te masamapa ema achane eta juca macaye­ma­quenehi ema Jesús, ichape­rinehi eta mapane­re­re­sirahi, taicha mavayuchahi eta macaima­ha­que­nerahi. Macatie­que­ne­ha­rinehi tamutu. Tiyanapa tipane­re­re­capaipa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tacahe, ema Jesús máichahavipa viti mayeheana apóstole: —Nutupiruva numetacahe: Yátupi­quenehi máitujihi eta náijara­si­ra­vai­nahini eta náehisi­ra­nui­nahini ena rícoana eta nasiapi­rai­nahini te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Esama­nuchaha. Eta juca tímicu­ti­ji­ri­cavahi eta vipera camello, máitujihi tánucu­hahini te támicuejehe eta parirapa. Ene nacahehi ena rícoana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eta visamirahi viti, viáraminehi. Víchacacapa: —¡Tétavi­cavahi eta tamáitu­ji­ca­ca­revahi! ¡Nájina títuji­ca­vaimahi náuchucu­hahini! ");
INSERT INTO ignNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ema Jesús tímara­ra­ca­havipa. Tásiha, máichahavipa: —Nájina émanaina achane émaji­vai­nahíni ticuchu­cuhava. Émasera ema Viya, macarichu marataha ticuchu­cureca. Taicha tájina máemeje­ra­cha­que­né­nahini ema Viya. Tamutu marataha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ema Pedro máichavarepa: —Vítisera, Tata, vinaquicahi tamutu eta vicaye­he­que­neanahi, vivarairahi véhicavi. ¿Tájahasica eta vímaha­quenéya? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ema Jesús majica­pa­varepa: —Nutupiruva numetacahe: Járaja­payare eta sáchevayare, tacaitsi­vai­rayare tamutu arairuya. Tásiha, nuti Manere­ji­ru­nuhi ema Tata néjacainapa te tajara­hi­quenehi trono. Tásiha, eti éhica­nuanahi éjacai­na­varepa tayehe eta dócequene trono. Ecava­nai­ri­pinapa nayehe ena dócemu­ri­queneana vijaneanana israelítana. ");
INSERT INTO ignNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tásiha, emutu eti enaqui­canahi eta epenana, ejuni­ji­ca­hivare ena ticachi­cha­heana, ena epara­pe­naveana, ena echicha­naveana, eta eyehe apaquehe, táichavenehi eta éhisi­ranuhi puiti, tiápaju­ca­vainapa camuri­pa­nayare ena ejanea­na­nayare étapa eta ímaha­que­neanaya. Éneri­chuvare táurivayare eta ítaresira máichecua­ra­qui­renapa. ");
INSERT INTO ignNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mavera­hesera eti etiari­hi­que­neanahi puiti, váhirichuhi ecapi­ca­huhini. Te jena sácheyare, ichape­pa­nainapa eta ecapi­ca­huiraya. Ena puiti ticapi­ca­huanahi, te táitauchavapa te jena sácheyare, énapa­vainapa téquene­ha­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Te jena sácheyare te níjara­ca­hénapa eta ícuchiyare eti nuchanerana, tacuti eta mavacha­chirahi ema émana achane ticayehe eta ichape quinta úvaquiji nayehe ena ticaema­ta­nea­rahiana. Ema maca mayatiruhi tipaica matanuca ena achaneana ticaema­ta­nea­na­yarehi mayehe. Tírere­ca­na­yarehi eta uva. ");
INSERT INTO ignNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te títucavapa ena ajairana, mameta­ca­vacapa eta mavacha­chi­ra­yarehi étana reale te sache. Tiúrihi eta mavacha­chi­ra­vacahi. Mavane­ca­vacapa tiyanana tayehe eta náirere­si­ha­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tásiha, macamu­nui­chahava ena apamuriana achane. Te las nuévepa sache, tiyana­varepa te plaza. Máimahai­nevare ena apamuriana ajairana máemata­ne­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Máechajia­ca­varepa eta náirere­si­ra­yarehi. Mameta­ca­va­ca­varepa eta táuriva­yarehi eta mavacha­chi­ra­yarehi. Tiyana­na­varepa éna, tírere­canahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te las dócepa sache, tiyana­varepa matanuca ena apamuriana. Títuca­vavare, máevata­mu­ri­havare tírere­ca­nayare. Te las trespa sache, tiápecha­vavare tiyana títuca­vavare ena apamuriana, éneri­chuvare tírere­ca­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te las cíncopa sache, tiyanavare tiúchucahi tayehe eta plaza. Títuca­vavare ena apamuriana ajairana máemata­ne­reanahi. Tásiha, máichavacapa: “¿Tájaha tacayema tájina émata­ne­nahini puiti jena sache?” ");
INSERT INTO ignNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Éna najicapapa: “Nájina náechejia­ca­ha­vihini”. Tásiha, ema máichavacapa: “Eyana éti apanava írereca ánaqui te nuyehe quinta úvaquiji”. Mameta­ca­varepa eta táuriva­yarehi eta mavacha­chiraya. ");
INSERT INTO ignNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tacahe, te yátipa, mametacapa ema mayehe empleado máichuha­vacapa namutu, mavacha­cha­va­ca­yarepa. Mavarahahi náinapuca nacavacha ena náequene­re­ruanahi ticaema­taneana. Nasapihapa téquene­hanahi ticavachana ena náinapu­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tásiha, ena nasiapa­que­neanahi te las cíncopa sache, mavacha­cha­vacapa ema achane eta étape­vacahi eta reale, tacuti­richuhi eta navachahi ena ticaema­ta­neanahi tamutu sache. Énapa ena nasiapa­que­neanahi te las trespa sache, éneri­chuvare eta étapevaca reale eta navachahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tacahe, te ticava­chanapa ena náinapu­reanahi tisiapana, náimahapa éna tacuti­richuhi eta navachanahi ena náequene­re­ru­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tásiha, tisemanapa mayehe ema náquenuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ánipa nacahe: “Ena nani náequene­re­ruanahi títecapana, vicuti­va­cha­va­caichuhi eta navachahi, étanai­ne­hinéni hora eta nacaema­ta­nerahi. Tacuti­ri­chu­hisera eta vivachahi viti vínapu­reanahi. Váhiquene táuricaimahi eta juca, taicha ichape­murihi eta vicami­chirahi víti eta táijureva muracaquene eta sache. Táurica vicachu­ri­ca­va­ca­ya­rehini éna eta navachahi” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Émasera ema náquenu majica­pa­vacapa: “Váhira nucaete­ma­hémahi éti. Énaripa ena náequene­re­ruanahi, váhivare nucaete­ma­va­caimahi. Tínunahi eta nuvacha­chi­rahehi étape­vacahi eta reale níjaracahe. Vahi ecusema. ");
INSERT INTO ignNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ésami­ri­ca­vachucha. Evehachucha eta juca evachahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Núti néchinava taicha nuyehe­richuhi eta plata. Nuvaraha ácuti­ca­cahini eta evachana emutu. ¿Éti ecapi­na­ru­nu­papuca eta núrivahi nayehe ena nani?” máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ema Jesús macahe­varepa: —Ene nacaheyare te jena sácheyare, nácani náequene­re­ruanahi téhicanuana, éna nasapi­hayare tínapucana. Tásiha, nácani náinapu­reanahi, nasapi­hayare téquene­ha­na­yare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tacahe, eta vipaisi­rapahi te achene te vicaijuhepa eta Jerusalén, típutsia­ca­havipa ema Jesús viti dócequeneana apóstoleana. Máichahavipa: ");
INSERT INTO ignNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ímaha puiti, viyanai­napaipa vicaiju­heyare eta Jerusalén. Ánaqui nucaija­ra­re­ca­siyare nuti Manere­ji­ru­nuhi ema Viya. Ticara­ta­ca­nua­nainapa ena tuparai­ru­cana. ");
INSERT INTO ignNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tímica­pa­ca­nua­nayare taicha tíjara­re­ca­nua­nainapa nayehe ena suntaruana romanoana. Éna, nájina najapa­nu­quenéna. Ticaeca­hi­nua­nainapa. Téstaca­nua­na­yareva. Tétata­ca­nua­na­yareva te crusu. Tásihasera, te mapana­que­nenapa sache, néchepu­cainapa te nécari —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tásiha, témeña­havapa esu naena ena vichamuriana ema Jacobo émapa ema Juan, suámava­ca­paipahi éna. Tépuyucapa ésu te mamirahu ema Jesús, suyasea­ca­yarehi énainahini majupa­ha­nai­nahini ena suchicha­na­veanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Éma mayase­recapa: —¿Tájahasica ecamunu, nuchicha? Ésu suíchapa: —Nuvaraha pácachanéni ena nuchicha­naveana tayehe eta péjasi­hayare picava­cu­reraya. Náejacahini te pichacaya, eñi éñina te pivaure, eñi apana te sapa —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ema Jesús majica­pa­vacapa éna: —Éti, vahi ímati tájahapuca eta nátaji­vayare nácani nujupa­ha­nayare. ¿Erata­ha­ya­repuca ecamicha eta íchava­que­né­vayare ecata­ji­vai­rayare, ecuti­nu­ya­repuca eta nucami­chi­rayare núti? —máichapa. Éna najicapapa: —Virataha vicamicha —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tásiha, máichapa: —Yátupi ichape eta ecata­ji­vairaya, vicuti­cacaya eta nacapa­si­ra­ha­viyare. Étapasera eta éjasi­rayare eta te nuchacaya, vaipa nútina necha nucaeja­ca­hehini. Ema Tata Nucaiyaquene, émahi tinere­ji­ca­yarehi ena nujupa­ha­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tacahe, eta visamirahi viti diésqueneana mayeheana apóstole, visemapa nayehe ena apinana. ");
INSERT INTO ignNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Émasera ema Jesús máichahavipa. Ánipa macahe: —Écharichuhi éti ena aquenucana tayehe eta avasare, muraca eta nacava­nai­ripira. Énaripa ena tuparai­rucana, tétavi­cavahi tisuapa­ca­reanahi eta nacava­cu­rerahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Váhisera ecucahehi éti nayehe ena echamuriana. Mácani tímere­cavahi ticapi­ca­hupana, tacamunuhi máitati­va­cayare ena apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te etiari­hi­va­repuca eti evarahahi ínapuca, tacamunuhi ímere­cavaya navana­ra­he­yarehi ena echamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ecuti­nuyare nuti Manere­ji­ru­nuhi ema Viya. Vahi étaina tímitecanu nucaita­ti­ca­sihini. Nútiyarehi nítatihe. Éneri­chuvare níjara­ca­va­yarehi nímica­pacava íchave­ne­que­nea­nainahi éti camuri­que­neanaya nucuchu­cu­reanaya —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tacahe, te vijuni­ji­ca­varepa eta avasare Jericó, camuria­na­hivare ena achaneana ticava­sanahi tayehe, téhica­ha­vianahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Natiarihi ena apinana ajairana púchuquiana. Téjacanahi te achene­chacaya. Te nasamapa ema Jesús eta mánucui­rapahi, tipiara­re­canapa. Ánipa nacahe: —¡Tátachicha! ¡Pítique­neripa yátupi­que­névihi Cristo! ¡Picata­ji­ca­ha­vipaini pájapa­nuhavi! ");
INSERT INTO ignNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Natiari­hisera ena achaneana vahi náuricahini eta napiara­sirahi ena púchuquiana. Navarahapa nacama­tinaca. Énasera napiara­caichucha: —¡Tátachicha! ¡Pítique­neripa yátupi­quenévi Cristo! ¡Picata­ji­ca­ha­vipaini pájapa­nuhavi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tacahe, ema Jesús eta masami­ra­vacahi, titupihapa. Máichuha­vacapa ena púchuquiana. Mayase­recapa tájaha­hipuca navarahahi. ");
INSERT INTO ignNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Éna najicapapa: —Tátachicha, vivaraha pípuhau­qui­cha­havini apaesa vímairi­ri­capaini —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tacahe, ema Jesús majapa­nu­va­cainehi. Máemama­hau­qui­cha­vacapa. Eneva­ne­rinehi tímairi­ricana. Tásiha, téhica­ha­vianapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tacahe, te apanapa semana, viyanapa vicaijuhe te Jerusalén. Vétava­jicapa tayehe eta avasa­rechicha Betfagé te tachacaya eta cerro ticaijarehi Olivoquiji. Ánaqui ema Jesús mavanecapa ena apinana vichamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ánipa maicha: —Eyanayare tayehe eta te jena avasa­rechicha Betfagé. Ánaqui ímahayare ticaitihahi eta esena burrico, étapa eta tachicha te tachacaya. Eveja­pua­cayare iámina­nuyare eta áni. ");
INSERT INTO ignNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te natiari­hi­napuca náeñama, emeta­cayare eta nucamu­nuirahi núti. Vahi táyeréimahi vímicha­va­va­neyare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eta juca tamutuhi títaucha­vapahi eta májucha­quenehi ema mácani víyarahaini profeta. ");
INSERT INTO ignNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ani tacahehi: “Emétaca ena achaneana ticava­sanahi te Jerusalén, apaesa natsecava eta najaca­pi­rayare ema nayeheyare Rey. Eméta­cayare vahi nacupica, taicha tétavi­ca­vapahi eta mamansu­vapahi, étapa eta máurivahi. Mámapahi eta iúrita­re­si­rayare. Tímati­ca­re­ya­repahi ema, taicha ticape­rayare eta burricuchicha” tacahehi eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tacahe, ena vanairu­canahi náitauchahi eta navanahi mayehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Námapaipahi eta burricochicha étapa eta tachicha. Nanaca­mae­quechapa eta náepacuhana. Tásiha, ticaperapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Camuriana ena achaneana tiácapanahi náepaca­pai­capaipa eta namuirihana. Ena apamuriana navehapa eta tapacaji eta cáchipaca. Nanacavare te mayani­ha­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ena apamuriana tínapu­mi­rau­cha­napahi énapa ena téquene­ha­napahi tipiara­ca­napaipa: —Yare, Tata. Píti yátupi­que­nevihi Cristo réyvihi viyehe viti israelítana. Ichape eta vicuna­chi­ravihi píti. ¡Vanairu­ca­que­nevihi me Viya! ¡Asulupaya me Viya te anuma! ¡Viva ema Viáquenu! ¡Viva! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tiúchuchu­ji­canapa ena achaneana te Jerusalén. Ichape eta náramirahi ema Jesús eta máiteca­pirahi. Tiyase­re­ji­ri­ca­ca­napaipa: —¿Nájaha ema maca achane? ");
INSERT INTO ignNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ena apamuriana najicapapa: —Émara ema profeta ticaijare Jesús, ticavasa te Nazaret te tinapaica te Galilea —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Tacahe, te apanapa sache, tiyanapa tisiapa ema Jesús tayehe eta te Templo. Máimaha­rinehi ena achaneana tíjara­re­canahi eta sárareana, cáyureana. Ena apamuriana ena tivacha­re­canahi. Natiari­hivare ena títsiri­pe­re­ca­rahiana eta naplataneana ena apava­sanana. Máichavacapa: —Ema Tata Nucaiyaquene, ani macahehi eta máechaji­ri­ruvahi te Sagrada Escritura: “Eta nupena tacarichu táicuchihi eta nayuja­ra­si­rareya ena achaneana” macahepa. Étisera eti tiámerahiana, ecasia­pavapa eta te juca. Emaepe­ra­jicapa eta tacapi­ca­huirahi. ¡Eyana iúchuca­tataji! —máichavacapa. Tásiha, macuchu­chu­ji­ca­vacapa namutu. Máequehe­pui­chi­na­vacapa eta namesarana étapa eta nasiyana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eta mávihairahi te Templo ema Jesús, napauchapa ena púchuquiana énapa ena masariana. Tásiha, éma macana­ra­ca­va­ca­paipahi. ");
INSERT INTO ignNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tacahe, ena amaperuana tipiara­re­canahi eta nacuna­chirahi éma, ánipa nacahe: “Pítiquenehi yátupi­que­nevihi Cristo manere­ji­ruvihi ema Viya” nacahepa. Énasera ena tuparai­rucana énapa ena escribánoana vaipa náuricahini eta náimairahi tamutu eta juca. Tisemanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Náurujiacapa. Navarahapa nacaichepaica eta máichaque­neanahi. Tásiha, náichapa éma: —¿Tájaha tacayema písapa tipiara­recana ena nani amaperuana? ¿Váhiyapa picama­ti­na­ca­va­capaini? —náichapa. Ema Jesús majica­pa­vacapa: —¿Tájahasica táichavahi eta juca najirairahi? ¿Váhipuca échajicuha eta Sagrada Escritura eta táechaji­si­hairahi eta juca najirasahi ena nani amaperuana? Ani tacahehi: “Piti, Tata, pinaca­sa­mu­re­cha­vacahi ena amaperuana eta máejera­re­ra­yarehi naicha eta najirai­rayare eta táurinaquene alabanza” —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te títapi­ricapa eta majica­pi­ra­vacahi, majuni­ji­ca­vacapa. Tiyanapa eta te avasa­rechicha Betania, étapa máimasinehi. Véhica­pai­chu­hisera víti. ");
INSERT INTO ignNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te apanapa sache, te yática­ra­hichicha, tiyana­varepa ema Jesús tayehe eta Jerusalén. Véhica­pai­chu­hivare víti apanava. Eta vipaisi­rapahi, técuha­sa­murepa éma. ");
INSERT INTO ignNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Máimahapa eta yucuqui ticaijare higo te achene­chacaya. Tiyanapa mapauchahi. Tájinasera táhinahini. Tapaca­jia­nachucha. Tásiha, máichapa ema Jesús eta higo: —¡Pépiyainapa píti eta máhiri­que­re­viyare! —máichapa. Eta macaherahi, enevanepa tijiyujipa eta tapacajiana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eta vímairahi víti, viáraminehi ichape. Viyase­recapa ema Jesús: —¿Tájaha táichara­ra­cavahi eta táijahú­chi­ravahi tiájiqui eta higo? —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ema Jesús tijica­pa­havipa: —Jéhesare nusama­carehi me Tata. Éti apana esama­ca­re­yareva, te yátupina eta ecasi­ña­vairahi me Viya. Tájina émaitu­caimahi. Erata­hayare ícha, ecutinuya eta níchaquenehi. Erata­ha­yareva ecayejeca eta cerro te apachacaya. ");
INSERT INTO ignNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamutu jácani eyase­se­re­piyare eta mayehe ema Viya te eyuja­ra­sirana, ecaija­ra­ca­siyare te yátupina eta ecasi­ña­vairahi me Viya —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tacahe, visiapa­varepa tayehe eta te Templo. Ema Jesús, tímitu­re­ca­varepa nayehe ena achaneana. Tacahe, napauchapa ena tuparai­ru­ca­nahi. Natiari­hi­hivare ena tinere­ji­ca­vanahi ena aquenu­ca­ra­hana. Ánipa nacahe: —Píti, vahi vitupa­ra­ru­vi­nahini víti eta píchira eta júcana. ¿Nájahasica tímitu­cavihi? ¿Nájaha titupa­ra­cavihi eta juca píchaqueneana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ema Jesús majica­pa­vacapa: —Núti apanavare nuvaraha nuyase­recahe. Ejica­pa­nu­ya­resera apaesa numetacahe eta nucatu­pa­ra­hairahi eta níchirahi eta júcana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nájahapuca tivanecahi ema Juan eta máitesirahi máicacha­si­ri­sirahi? ¿Émapuca ema Viya tivanecahi, émaji­vapuca eta máitesirahi? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Váhisera náiturue­que­ne­hahini eta najica­pi­ra­yarehi. Tiácapae­ma­ji­ri­ca­canapa. Ánipa nacahe: —¿Tájahasica vicaye­mayare eta vijica­pi­rayare ema maca? Te vémuna­hacava vícha: “Mavaneruhi ema Viya”, éma macahé­na­papuca: “Tásiha, ¿váhiyapa esuapahini éma?” Téhesera vácahepuca: “Émaji­vaichucha eta máitesirahi”, ticauya­ya­ca­reripa titupi­si­ca­haviana eta te márijahiana ena achaneana, taicha namutuhi náimijachahi ema Juan profeta­quenehi yátupiquene, mavaneruhi ema Viya —téchaji­ri­ca­canapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tásiha, náichapa ema Jesús: —Vahi vecha víti —nacahepa. Tacahe, máichavacapa éma: —Éneri­chuvare núti, vahi numeta­ca­hémahi nájahapuca ema titupa­ra­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nuvara­hasera nímicu­tia­ra­chi­na­heyare. Nararihi ena apinana ticapa­ra­pe­cacana. Ticava­nahipa ema émana mayehe ema naiya. Ánipa máicha: “Nuchicha, piyana picaematane puiti jena sache. Pírerecaya eta uva” máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ema machicha majicapapa: “Vahi nuvaraha nucaematane puiti juca sache”. Te tiyerepa, tiyana­panéni ticaema­tanehi. ");
INSERT INTO ignNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tásiha, ema naiya mavane­ca­varepa ema émana machicha, mayanahini macaema­ta­nehini éma apanavare. Tásiha, ema amaperu majicapapa: “Tiuri, nuyanayare” macahepa. Váhinéni mayanahini. ");
INSERT INTO ignNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Puiti nuyase­re­ca­heyare: ¿Nájaha ema tisuapa­ji­rahihi mayehe ema maiya? —máichavacapa ema Jesús. Éna najicapapa: —Ema tínapuca, éma tisuapa­ji­rahihi. Tásiha, ema Jesús máichavacapa: —Nutupiruva numetacahe puiti. Nasapi­hayare ticachu­ri­ca­hea­nayare tisiapana te anuma ena túhusia­nainihi énapa ena tisipe­ca­tu­ra­ra­hia­nai­nihi. Éti vahi esiapaimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Taicha vahi esuapahini eta máimitu­rapiana ema Juan Tícacha­si­ri­ca­rahini, váhivare ávara­hahini étupi­ri­ca­vahini eta ítare­sirana. Narari­hisera ena tisipe­ca­tu­ra­ra­hiana, ichape eta nasuapirahi. Étisera, tétavicava eta emasua­pa­jiraiva, tayanapane ímahahi masuapa­ca­revahi éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ema Jesús máichavarepa: —Esamanu eta juca apana nímitu­rapiya. Nímicu­ti­chi­na­heyare. Matiarihi ema achane. Ticaevaruhi camuri eta uva te máesane. Manaruchapa eta masucure. Máepiya­ca­varepa eta nacati­ca­re­si­hayare eta tachi eta uva. Máepiya­cavare eta torre, nápani­hayare eta najanea­si­rayare eta máevaru. Tásiha, máijaracapa ena achaneana, pártirá­rioa­na­yarehi. Tásiha, tiyanapa ema achane te apana avasare. ");
INSERT INTO ignNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tacahe, te títecapapa eta caje tayairahi eta uva, máimiva­ne­recapa ena mamusurana nayasea­pa­na­va­ca­yarehi ena pártirá­rioanahi eta tatuca­cha­que­ne­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Énasera ena pártirá­rioanahi tisemau­cha­va­na­richucha. Nacara­ta­ca­vacapa, náehapa ena vanairucana. Nacapacapa ema émana. Ema apana nayuca­racapa te márijahiana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tásiha, ema achane máimiva­ne­re­ca­varepa ena apamuriana. Camuri­pa­nanapa. Váhique­nesera náijara­cahini, náehava­ca­varepa. Nacapa­ca­vacapa ena apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tacahe, émaja­ca­ruvapa máevataca ema machicha. Máimija­chaipahi émapa­pucaini napicau­chahini. ");
INSERT INTO ignNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Te náimahapa ema machicha ema ticayehe eta úvaquiji, ánipa nacahe: “Émaina­papuca ticaye­heyare ema maca. Yare, vicapaca apaesa tánasipa viyehe tamutu. Tájina máichara­ca­ha­vimahi ema achané­navaji”. ");
INSERT INTO ignNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tacahe, nacara­tacapa ema machicha, nacuchucapa eta tayehe eta isaniti, nacapacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Puiti, nuyase­re­ca­heyare: ¿Tájahapuca máichara­ca­vayare ema ticayehe eta úvaquiji ena pártirá­rioanahi máurirahana? —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Éna najicapapa: —Éma tisemainapa. Vaipa májapa­nu­va­caimahi. Macapa­pa­na­va­ca­yarepa ena pártirá­rioa­nainihi. Máijara­cainapa ena apamuriana pártirá­rioa­na­yareva, nácani tipicau­ra­hianahi, náijara­cahini eta mayehe parte —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tásiha, ema Jesús máichavacapa: —Jehe tiúrihi eta ejica­pi­ranuhi. Nuvara­hasera epane­re­chi­na­vapaini eta tacayemahi eta Sagrada Escritura, apaesa ácaicutiara éti. Ani tacahehi: “Ena tépiya­re­ca­rahiana eta Templo, tasapiha náepuruhi eta mari táicuchihi tatumea­rayare eta peti, taicha vahi náimatihini. Émasera ema Viya macaite­capahi eta te táicuchihi eta tatupa­rahahi. Tacapi­ca­hu­quenehi puiti. Táitusiava, tétavi­cavahi eta vicuna­chirahi víti ema Viya” tacahehi eta Sagrada Escritura. Nuvaraha ecaicu­tiaraya. ");
INSERT INTO ignNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Puiti numetacahe: Táichavenehi eta emasua­pa­ji­raivahi, vaipa étipa­ra­caimahi tayehe eta mavanairipi ema Viya. Ena tisuapa­ji­ra­hianahi, éna ticava­cu­rea­nayare te jena sácheyare. Énainapa téchanayare eta vanairipiana. ");
INSERT INTO ignNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Puiti, núti nucutihi eta ichape mari náepuru­quenehi. Eti épuru­nuanahi, iáquipai­ca­vayare évetu­tu­ji­cayare. Tichima­ra­ca­henapa eta muraca ecuñaraqui taicha eta emava­ra­hairahi éhicanu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Étasera eta nasamirahi ena tuparai­rucana énapa ena fariséoana, tisema­na­rinehi taicha tímatia­ca­vanapa eta énairahi tayuna­cavaca eta máimicu­ti­chi­ra­vacahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Navarahapa nacara­ta­ca­ya­rehíni. Tipica­ca­va­na­chu­chasera nayehe ena achaneana taicha namutu nacunachahi ema Jesús eta émairahi vanairuca me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ema Jesús máimitu­cavare ena achaneana eta apana máimicu­ti­chaquene. Ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ema Viya, macutihi mácani rey te máimiye­na­chayare ema machicha, máichayarehi eta ichape piesta. ");
INSERT INTO ignNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mavanecapa ena mavanarana náichuha­pa­navaca ena machima­ranaya. Váhisera návara­hahini nayanahini éna. ");
INSERT INTO ignNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tásiha, ema rey máevata­cavare ena apamuriana mavanarana. Ánipa máichavaca: “Eyanavare étipava ímita­ta­ji­ri­cavaca ena níchuha­que­neanahi, náiteca­vanepa. Nucapa­re­ca­ripahi eta vaca nirureyare nésina­ruanahi. Tiúrinapa tamutu eta juca tinicacare. Énanecha nucuchapahi náiteca­vanepa” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Énasera ena máichuha­que­neanahi vahi nasuapahini. Nájina nayanahini. Ema émana tiyanapa te máesane. Ema apana máimahapana eta mayehe tienda. ");
INSERT INTO ignNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ena apamuriana nacara­tacapa ena vanairu­ca­nainihi, náehavacapa, nacapa­ca­vacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tacahe, te máechapa ema rey, tisemapa. Mavanecapa ena masuntaruana nacapa­pa­navaca ena ticapa­hianahi. Náijuchavare eta tamutu eta napenanaini. ");
INSERT INTO ignNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tásiha, máichava­ca­varepa ena apamuriana mavana­ranahi: “Tiúripa tamutu eta juca tinica­careana. Váipasera nuvaraha náiteca ena náinapu­reanahi níchuha­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eyana te tamutu cálleana. Íchuha­va­cayare namutu nácani ecainu­na­que­nea­nayare” máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tacahe, ena mavana­ranahi tiyananapa, náchehu­pa­ne­vacapa. Nacuru­ji­ca­vacapa namutu nácani nacainu­na­que­nea­napahi: nácani achaneana tiúriana énapa ena súnsusu­rujiana. Camurianahi. Tínica­na­rinehi eta te táviha­yarehi eta piesta. ");
INSERT INTO ignNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tacahe, ema rey tisiapapa, máimaha­yarehi ena machima­ranahi. Máimahapa ema émana achane ema matiari­hi­quenehi vahi manacahini eta namuirihasa te ticaichu­hasiana. ");
INSERT INTO ignNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tacahe, máichapa: “Ajaira, ¿tájaha tacayema vahi pinacahini eta múiriare níjara­ru­heanahi tayehe­yarehi puiti juca piéstayarehi?” Émasera ema achane vahi majica­pahini. ");
INSERT INTO ignNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tacahe, ema rey mavane­ca­vacapa ena mavanarana: “Eveha ema maca. Ítijivaucha, ítiápe­chavare. Íyara­cu­hapana te timapicu tayehe eta máiyauchia­vayare macapi­ti­quia­he­chia­vayare” macahepa ema rey. ");
INSERT INTO ignNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ema Jesús máichavarepa: —Numetacahe puiti: Camurianahi ena níchuha­que­nea­na­paipahi. Ánimu­ria­na­ri­chusera ena títaura­hia­nayare —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tacahe, eta nasamirahi ena fariséoana, tisema­na­rinehi. Tiyananapa ticuru­ji­ca­canapa, navarahaipa náemeje­ca­pa­va­cha­yarehi apaesa étaina­hi­pucaini taviuchahini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tacahe, navanecapa ena nachamuriana énapa ena políti­coana. Nayase­re­panahi ema Jesús. Te náiteca­pauchapa, ánipa nacahe: —Tata maestro, vímatihi eta tatupi­ru­vairahi táurivahi eta juca pímitu­ra­pianahi. Yátupihi eta pímitu­si­ra­vacahi eta táurinaquene achene ticaijuhe me Viya. Váhivare pipica­ca­ra­ca­vahini eta péchaji­si­hairahi eta náichava­que­né­vanahi nácani achaneana, tayana­panehi aquenucahi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vivara­ha­hisera viyase­re­ca­viyare eta pipane­reruhi: ¿Táurica­hipuca vivachacha eta viyasehana impuesto mayehe ema Presidente Emperador romano? Taicha víti, machane­ra­havihi ema Viya, ¿masi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Émasera ema Jesús máimatia­ca­vacapa eta tamauri­vapahi eta napane­reruana. Tacahe, máichavacapa: —¡Apimi­ra­he­tataji! ¿Tájaha tacayema evaraha ímiaqui­paicanu? ");
INSERT INTO ignNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nímahaseji, iáminanu étapena eta reale —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eta náijara­sirapa, éma máichavacapa: —¿Nájaha ticaijare eta juca? ¿Nájahavare ticava­simahi eta juca mirare eta te juca reale? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Éna najicapapa: —Mayehe ema Presidente Emperador —náichapa. Tacahe, éma máichavacapa: —Tiuri, táuricahi íjaraca ema Presidente Emperador eta juca mayehe­richuhi éma. Tásiha, íjara­cavare ema Viya eta mayehe­ri­chu­hivare éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te nasamapa ema Jesús eta majica­pi­ra­vacahi, ichape­rinehi titsiri­ha­ca­vanahi. Náramipa eta máitupa­ji­jia­si­ravahi. Tiyananapa tichavanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Étarichu te jena sache, nacahe­paipahi ena saducéoana. Ena nani saducéoana, apana­hivare eta náimitu­rapiana. Éna, vahi nasuapa eta náechepu­si­rayare ena náepena­queneana. Tiyananapa náimaha­panahi ema Jesús. Natanucahi eta táetsera­ru­va­yarehi náicha. Ánipa nacahe: ");
INSERT INTO ignNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tata maestro, ema víyarahaini Moisés, manaquicahi eta máechaji­ri­ruvahi eta viyehe: “Te máepenae­que­ne­ha­hipuca ema achane esu mayena, tásiha nájina­hipuca manaquie­que­ne­ru­vai­nahini machichai­nahini; te matiari­hi­hipuca mácani maparapehi, mavehayare esu machine­nae­quenéni, apaesa émainapuca macachicha eta suyehe, máitsivainahi ema maparapéni”. ");
INSERT INTO ignNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tacutiquene te juca vitaracu, natiari­hinihi ena siétequeneana ticapa­ra­pe­ji­ri­cacana. Tacahe, ema náechavimuri títauchavapa. Máepenáe­que­ne­ha­pasera esu mayena. Nájinahi machichai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tacahe, ema maparape máitauchavare esu machinenaini. Éneri­chu­va­resera máepenae­que­ne­havare, nájinavare máchichai­nahini. Ema émana maparape máitauchavare ésu. Éneri­chuvare máepenae­que­ne­havare. Namutupa ena siétequeneana navehahi ésu, tásihasera náepenae­que­ne­hapaipa, nájina émanai­nahini macachi­chahini eta suyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te táequenepa, tépenapa esu esenaini. ");
INSERT INTO ignNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tacahe puiti, te apana­papuca eta náitare­si­rayare ena nani, ¿nájahapuca ena siétequeneana ema yátupi­quenehi suímaquenehi esu esena, taicha ena siétequeneana namutuhi suímanarihi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tásiha, ema Jesús majica­pa­vacapa: —Éjecapava éti. ¿Tájaha tacayema vahi ácaicu­tia­rahini eta táimiturapi eta Sagrada Escritura? ¡Váhivare evara­hahini esuapahini eta tamutuirahi marataha ema Viya! ");
INSERT INTO ignNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ánaqui te apana náitare­siraya, vaipa nácamu­nuimahi esu esena. Énaripa ena esenana, váipavare nácamu­nuimahi ema ajaira. Nacutinapa ena ángeleana tiávihanahi te anuma eta namaepe­na­ca­cairahi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Éti váhiva­repuca ácaicutiara eta yátupirahi eta vahi táepenahini eta náchanevana ena náepena­queneana. Váhipuca ácaicutiara eta máechaji­riruva ema Viya. Ani macahehi éma: ");
INSERT INTO ignNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nútira yátupi­que­nenuhi Viya, macasi­ña­quenehi ema Abraham, ema Isaac émapa ema Jacobo” macahepa ema Viya. Nutupi­ruvahi numetacahe: Ema Viya, éma téchahi eta náitare­sirana ena téhicanahi, tayanapane tépena­naripa. Eta náchanevana, tímiya­na­va­richucha títareca te mamirahu. Éti, ichape eta éjeca­pi­ravahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tacahe, eta nasamirahi ema Jesús, ichape­rinehi eta náramirahi ena achaneana eta máimitu­rapihi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tacahe, ena fariséoana eta náimairahi macama­ti­na­si­ra­vacahi ema Jesús ena saducéoana, ticuru­ji­ca­canapa éna. ");
INSERT INTO ignNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tásiha, tiyananapa náemeje­ca­pa­va­cha­yarehi ema Jesús. Ema émana ticaina­pu­cavapa, máestrohi éma tayehe eta nayehe­repiana. Mayase­recapa éma: ");
INSERT INTO ignNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tata maestro, nuvaraha pimeta­canuini ¿tájahapuca eta vanairipi tisuapa­ca­re­panahi tayehe eta mavanai­ripiana ema Viya? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Ema Jesús majicapapa: —Eta máechaji­riruva ema Viya te Sagrada Escritura, ani tacahehi: “Yátupina eta émuna­si­ranuina nuti Iáquenu. Iúnaca te esamureana. Yátupina eta ecacha­ne­vai­ranuina núti. Epanerecha eta nímitu­rapiana tamutu sácheana, yátiana”. Étara eta juca eta vanairipi tisuapa­ca­re­panahi. Éta tativayare ítauchayare, tínapuca tayehe eta apamuri vanairipiana. ");
INSERT INTO ignNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eta apana táehiruhi eta juca, ánivare tacahe: “Pémuna­cayare ema piparae­piyahi, tácuti eta pémuna­si­ravahi píti”. ");
INSERT INTO ignNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eta juca apinaquene vanairipi, éta máehicahi ema víyarahaini Moisés tayehe eta apamuriana mavanai­ri­pianahi éma. Énaripa ena apamuriana profetana, étari­chuvare náehica­hivare éna tayehe eta náimitu­ra­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tacahe, eta náurujia­si­raichaha ena fariséoana te machacaya ema Jesús, ");
INSERT INTO ignNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","máichavacapa: —Puiti, nuvaraha nuyase­recahe eti: ¿Tájaha tacayema eta epane­reruana éti mayehe ema Cristo ema ecucha­pa­quenehi? ¿Tájaha eta ícutia­rayare eta ímati­ra­yarehi éma te máimere­cavapa? —máichavacapa. Éna najicapapa: —Vímatinapa éma taicha tiúchucayare mámarie­que­neyare ema víyaraháini rey David —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Majica­pa­varepa: —Yátupihi ema Cristo achane­quenehi eta máimahi taicha mámarie­que­ne­yarehi ema víyaraháini David. Nuvara­hasera epane­rechaya eta juca máechaji­ri­ruvahi ema David te májurehi Salmo, ani macahehi: ");
INSERT INTO ignNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ema Viya máichapa ema Tata Náquenu Cristo: Yare, péjaca te nuvaure, eta picucha­pi­hayare eta nucaepu­yu­siraya te pimirahu ena ticatia­na­ca­vianahi” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ema David, eta máimija­re­chirahi ema Cristo “Tata Náquenu”, ¿tájahapuca eta macaye­ma­quenehi? Núti németeaca Víyahivare ema Cristo. ¿Tájaha íchahi éti? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eta nasamirahi eta juca, nájina náijara­ca­vahini najica­pahini. Eta tacahe, nájinapa napatsi­ca­vahini nápechahini nayase­re­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tacahe, ema Jesús máichavacapa ena achaneana vítipa viti máimitureana. Ánipa máichahavi: ");
INSERT INTO ignNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ena escribá­noana énapa ena fariséoana tímija­chavana catupa­rahana eta navepai­si­ra­yarehi eta mavanai­ripiana ema Moisés. ");
INSERT INTO ignNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tacahe, éna esuapayare. Ítauchayare eta navanai­ripiana. Váhisera ecuehica eta nayehe­repiana taicha ena apapi­pi­jichucha eta napane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tacutiquene tipami­caheana ítauchaya eta camuri­queneana nayehe­repiana. Éti, tájina eta ejapa­nu­ca­rehíni nayehe. Nájinapa tirata­haimahi títaucha. Apanasica éna, vahi nárata­hahini náitauchahini tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tímija­cha­vanahi tamutu náitaucha, navarairahi ticuna­cha­ca­rea­na­yarehi nayehe ena achaneana. Tisiña­va­vai­canahi eta nápaju­si­ravahi religiósoana. Nanacahi te nanahuana eta ajureca navejurehi eta te Sagrada Escritura. Tacutiquene eta nacamui­rihaira tísape­pea­ca­vanahi píncani­llanahi. Ticama­tsi­vacahi eta nacamui­rihaira. ");
INSERT INTO ignNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ena nani, te ticaichu­hasiana eta nanisiraya, éna tinere­ji­si­na­vanahi eta tiúrina­panána eta náejasihaya. Navara­ha­hivare ichape eta napicau­chiraya ena achaneana te náuruji­si­ra­re­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tétavi­cavahi eta navarairahi ticapi­cahuana. Navara­ha­hivare ticaca­ja­mi­ca­sia­na­yarehi te jácani nácapa­jisiha ena náimitureana téhepahi calle. ");
INSERT INTO ignNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Étisera vahi ecuja­muracha eta nacaja­mi­si­ra­he­nahini ena achaneana, étaina­pa­pucaini nacuna­chi­ra­he­nahini. Taicha éti epara­pe­ji­ri­cacahi, ecuti­cacahi te mamirahu ema Viya. Nucarichu núti yátupi­que­nénuhi eyehenuhi Maestro, nuti Cristo. ");
INSERT INTO ignNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Váhivare “Tata Nucaiyaquene” ecuquicha nácani achaneana te juca apaquehe. Taicha mararihi ema yátupiquene Ecaiyaquene, ema tiávihahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Váhivare tísapa­ca­rémahi eta náimija­rechahe, “Tata nuyehe jefe”, taicha nucarichuhi núti yátupi­que­nénuhi jéfenuhi eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nuvara­hasera ítáti­ji­ri­ca­cayare. Nácani títáti­rahiana, éna ticuna­cha­ca­re­pa­na­na­yarehi eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Éneri­chuvare nácani mánsuanahi, éna ticuna­cha­ca­re­pa­na­nayare me Viya. Nácanisera ticasi­ña­va­vai­canahi ticuna­cha­va­napuca, tímitsi­riá­va­nayare me Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tacahe, títeca­panapa ena escribá­noana énapa ena fariséoana. Tásiha, ema Jesús máechaji­ca­vacapa éna, mayuna­ca­vacahi. Ánipa macahe: —¡Éti escribánoana étipa eti fariséoana! ¡Muracayare eta ícuñayare taicha eta apimi­rai­rahehi! ¿Tájaha tacayema ímija­chavahi éti echa eta tapaja eta anuma? Vahi ísapa nasiapahini ena achaneana, nácani tivarahana tisiapana. ¡Étiripa vahi ítuji­ca­vaimahi esiapa! ");
INSERT INTO ignNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jucarihi eta apana tiviuchahehi. Tatupa­racahi ejapa­nuyare ena tépenaimana te váhipuca narataha navacha­chahini eta nantéve. Étisera evere­ji­ca­vacahi tamutu eta nacaye­he­queneana. ¡Apimi­rahehi! Épiya­cavahi religió­sohehi, íchahi iúpiemahi eta eyuja­rasira te namirahu ena achaneana, evarairahi vahi tacuimi­cae­che­rachava eta emauri­vanahi. Ichapeyare eta ícuñayare táicha. ");
INSERT INTO ignNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Jucari­hivare eta apana tiviuchahehi, éti escribánoana étipa eti fariséoana! ¡Muracayare eta ícuñayare taicha eta apimi­rai­rahehi! Éti, tétavi­cavahi eta éñama­vairahi eta íturuca ena téhicana eta ímitu­rapiana, eyanirahi te avasareana tiyerehiana. Tasapihahi ímitu­ca­vacahi eta nacuti­heraya eta evaina­ra­jivahi. Tiápajucava eta namaurivahi ícha. Eta tacahe, ecacha­ne­va­cayare éna te yucu infierno. ");
INSERT INTO ignNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jéhevare éti ecaijare páurehe. Ichape eta ícuñayare taicha eta ímiaqui­pai­si­ra­vacahi ena ecuti­queneana púchuquiana. Éjeca­pavahi tayehe eta juca ímitu­rapihi. Ímituca eta tájinahi eta taviuchaimahi nácani najurachahi eta Templo. Étasera te najuracha tayehe eta oro eta tiávihahi eta te Templo, ticaviu­re­va­nainapa ícha éti. ");
INSERT INTO ignNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tétavi­cavahi eta emaecha­raireva eti púchuquiana! Eta Templo, étara tipicau­cha­ca­re­panahi tayehe eta oro tiávihahi tayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iápecha­vavare eta éjeca­pi­ravahi tayehe eta apana ímiturapi. Éti íchavare: “Te náichapuca nácani eta promesa, najura­chapuca tayehe eta náijuchirare eta sárareana, tájinai­pavare ticaviu­rémahi. Téhesera najurachahi tayehe eta nanaqui­ruvahi te táinahu eta náijuchi­rarehi, étasera ticaviu­re­va­naripa” íchahi éti. ");
INSERT INTO ignNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tétavi­cavahi eta emaecha­raireva eti púchuquiana! Eta náijuchi­rarehi eta sárareana, étara tipicau­cha­ca­re­panahi tayehe eta enaqui­ru­vanahi. Éta tímipi­cauchahi eta enaqui­ru­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taicha nácani tijura­chanahi tayehe eta náijuchi­rarehi, vahi tácari­chuhini napicau­chayare éta, napicau­cha­ya­rehiva tamutu eta námavahuana tiávihanahi te náijuchi­rarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tacutiquene nácani tijura­chanahi tayehe eta Templo, vahi tácari­chuhini náichahini eta juramento tayehe eta Templo. Najura­cha­hivare mayehe ema Viya tiávihahi tayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Énaripa ena tijura­chanahi tayehe eta anuma, najura­cha­hivare mayehe ema Viya, taicha eta anuma étahi eta mávasa, étaipa eta máejasihahi ema téchahi tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","24","¡Jucari­hivare eta apana tiviuchahehi eta tamura­cavaya eta ícuñayare, éti apimirana! Éti ímija­chavahi ímine­ca­pae­queneha ena ecuti­queneana púchuquiana tayehe eta títuca­careana. Ímija­chavahi yátupi­quenehi eta religió­so­héirahi eta epami­si­ravahi eta ítauchira eta vanairipi eta ecama­vahuira me Viya eta diésmuri tayehe eta sucurecana. Ecuna­cha­carehi taicha éta. Váhisera epami­ca­vahini eta táuriqueneana ticuna­cha­ca­re­panahi me Viya. Tatupa­racahe emutu ájapa­nurahi; ecatiu­cha­va­ca­yarehi ena macatiu­cha­va­ra­hanahi; yátupina eta ítauchiraya tamutu eta íjara­si­ravahi; yátupina eta ecasi­ña­vairaina me Viya. Tatupa­ra­ca­he­hivare ecamavahu eta me Viya eta diésmuri. Éti éñamavahi eta ítauchirahi eta ánichichana, étasera eta tisuapa­ca­re­pa­na­que­neanahi táuriqueneana, tasapihahi vahi esuapa­hini­. ");
INSERT INTO ignNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Tétavi­cavahi eta apimi­rai­rahehi! Éti ímija­chavahi yátupi­quenehi religió­sohehi, ecaeña­ma­ra­cavahi eta ímiya­ni­ravaya ítaucha eta eyehe­repiana. Étasera eta esamureana, tétavi­cavahi eta tachipe­ji­va­vacahi taicha eta ecaete­ma­raivana étapa eta íjara­si­ravahi icha tamutu eta ejamu­ra­raivana. ");
INSERT INTO ignNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Tétavi­cavahi eta epuchuquiva eti fariséoana! Tamapu­rujihi eta religió­so­héirahi. Tacamunuhi tativa esipaca eta esamureana, apaesa yátupi­na­sarepa eta iúrivayare, tipachi­nainapa eta ítare­siraya. ");
INSERT INTO ignNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Tétavi­cavahi eta ecata­ji­vairaya, táichavenehi eta apimi­rai­rahehi, eti escribánoana étipa eti fariséoana! Éti ecuti eta covacha. Tiúrinahi te táinahu, téhesera te amahe távihahi eta máepere­ji­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tacahehi eta ítare­sirahi éti. Ticuti­ma­hinehi iúrihi te namirahu ena achaneana. Étasera te esamureana táuruji­siavahi eta evaina­ra­jivana, tacutiquene eta apimi­rai­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Páurehe­sa­mi­cha­pucaini eti escribánoana étipa eti fariséoana! ¡Ichape­mu­riquene eta eviure­vanahi! Eti, ímija­cha­vaipahi puiti ecuna­cha­carehi eta evarairahi échapa­jirica eyehe­heacahi eta náecariana ena profetanaini matapi­ra­va­re­que­neanahi, nacapa­ruanahi ena iáchuca­na­veanaini éti. Épiya­cavahi yátupi­que­né­nahini eta iúrivahi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tásiha, ánivare ecahe: “Te vitiari­hi­na­ri­pahini víti eta acane te ticapa­re­canapa ena viáchuca­na­veanaini, vahi vicuimi­ca­sia­pa­vahini tayehe éta” ecahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","Étijivapa ímereu­chavahi eta apimi­rai­rahehi, taicha puiti éti epane­rechahi ecapa­canuya, tacutihi eta napane­re­ruanahi ena iáchuca­na­veanaini. Tásiha, ecuti­ca­cayare eta naviurevahi ena iáchuca­na­veanaini. ");
INSERT INTO ignNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Éti tachicha­na­vea­na­tataji eta quichare, tétavi­cavahi eta evaina­ra­jivahi! ¡Váhiquene ticaiti­ca­hémahi eta ícuñaya te infierno! ");
INSERT INTO ignNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nímicae­che­ra­chayare eta evaina­ra­jivahi. Nuvane­cayare napauchahe ena nuchanerana. Éna, timeta­ca­hea­nayare eta mapane­reruana ema Tata. Tímitu­ca­hea­na­yareva tamutu eta nímitu­rapiana. Nasapi­hayare vahi esuapaimahi éna. Éna, yátupihi náituca. Émepu­ru­re­ca­ya­resera éti eta náitupa­ji­jia­si­ravahi éna. Esapi­hainapa, éti ecapa­ca­va­cainapa éna; ena apamuriana éméta­ta­cayare te crusu. Tásiha, ena apamuriana éstaca­va­cainapa te iúruji­si­ra­revana. Éhica­rai­ri­ca­va­cainapa te jácani avasareana najunai­ya­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tásiha, eta ecapa­si­ra­va­cainapa ena nuvane­ruanahi, étinapa tamuria­cayare eta naviure­vanahi namutu ena ticapa­canahi ena achaneana matapi­ra­va­re­que­neanahi. Ema Abel máinapuiruhi nacaparuhi, máetaviu­chainihi eta máuriva. Émapa ema máequene­reruhi Zacarías (machichainihi ema Berequías), ema nacaparuhi te tamirahu eta Templo. Camuria­na­hisera ena apamuriana náumuri­va­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nutupiruva numetacahe puiti: Étinapa tamuria­cayare tamutu eta náepeni­ranahi. Títeca­painapa eta ícuñayare eti achaneana ítare­ruanahi puiti —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tacahe, ema Jesús tiápechavava máechaji­ca­vacapa ena achaneana. Ánipa macahe, taicha eta macati­sa­mu­re­ravahi: —¡Tétavi­cavahi nucati­sa­mu­re­ravahi ícha étisami eti tachicha­na­veanahi te juca viávasa Jerusalén! Ena iáchuca­na­veanaini, éna ticapa­pa­ji­canahi ena profetana mavane­ruanahi ema Tata. Puiti étipavapa evaraha ecutiya ena iáchuca­na­veanaini. Ichape­mu­ri­hinéhi eta níchuirahehi éti, iúrujia­ca­nuhini, tácutihini eta varayu te tacuru­ji­muriha eta tachicha­naveana eta te tapava. Váhisera ávara­hahíni. ");
INSERT INTO ignNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ímahai­na­pasera puiti eta íchara­ra­ca­vayare. Ticaqui­pai­ca­siyare tamutu eta epenana, étiripa ticuchu­ca­hea­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Numeta­ca­hevane puiti vaipa iápecha­vaimahi ímahanu, tiámainu­ca­vainapa te ítsivachapa eta epane­reruana, evarai­rayare ejacapanu. Ecahénapa: “Ichape eta vicuna­chi­ravihi píti vanairu­ca­que­névihi me Viya” ecahénapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tacahe, ema Jesús tiúchucapa tayehe eta Templo, tiyana­ya­repaini. Vítisera viti máimitureana vémeña­havapa eta mayehe. Eta viáramirahi, vímechapa eta táurina­queneana mari tayehe eta anuquehe peti te Témplosami. ");
INSERT INTO ignNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Émasera ema Jesús tijica­pa­havipa: —Tamapu­ru­jiyare eta juca táurinava eta pétisami ímaha­quenehi puiti. Nutupiruva numetacahe: Járaja­payare eta sácheyare ticaqui­pai­ca­siyare tamutu eta juca Templo. Téjane­re­pai­cainapa tamutu eta juca táurina­que­neanahi ímaha­que­neanahi puíti —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tásiha, viyanapa tayehe eta cerro Olivoquiji, víputsi­cavapa. Te vítecapapa, téjacapa ema Jesús. Tásiha, víti máimitureana viyase­recapa: —Vivaraha pimeta­cahavi. ¿Tájamu­hupuca eta náimiaqui­pai­si­rayare eta Témplosami? ¿Jarari­hi­ya­repuca eta ecutia­ra­reyare eta piápechi­ra­vayare píteca, étapa eta táitauchi­rayare eta táequene­reruhi mapanereru ema Viya? —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tásiha, ema Jesús máichahavipa: —Ecuneu­chavaicha yátupina, machu navayuacahe, taicha náraja­payare ena tépiya­ca­va­na­ya­repahi tímiva­si­cha­va­nayare nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nacahe­ya­repahi éna: “Nútiripa Cristo”. Nasapiha navayua­cayare ena camuriana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","7","Éneri­chuvare esamai­ri­ri­cayare eta táehaca­cai­rayare eta ichape­queneana avasareana. Ticana­ra­ji­ri­ca­ca­nainapa eta te avasareana tayere­hi­queneana, éneri­chuvare ticauya­ya­ca­renapa guierraina eyehe éti. Váhisera ecuarameca eta esamai­ri­ri­siraya, taicha ene tacaheyare eta táepani­ra­vayare eta ecutia­ra­rea­nayare. Vuíchahasera étaimahi eta táichecui­rayare. Éneri­chuvare tatiari­hi­yareva eta ichape ecuha­mu­hu­yareva te avasareana. Tatiari­hi­yareva eta ichape tayamu­ri­si­ranaya eta apaquehe te jácani táviha­napahi táetupia­ruyare. ");
INSERT INTO ignNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tamutu eta juca ecutia­ra­rea­nayare eta táepani­ra­vayare eta nátaji­va­nayare ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tásiha, eti nuchane­ranahi, ticatia­na­ca­hea­nainapa ena achaneana, táichave­neyare eta éhisi­ranuhi. Tipana­ji­ri­ca­hea­nainapa te tamutu avasareana. Ticara­ta­ca­hea­na­yareva. Ticapa­ca­hea­na­yareva. ");
INSERT INTO ignNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tásiha, narari­hinapa camurianaya ena tínaji­ca­va­nayare eta náehisi­ranuhi. Tásiha, ticatia­na­ca­hea­nainapa éti yátupiquene eta éhisi­ranuya. Tíjara­re­ca­hea­nainapa éti. ");
INSERT INTO ignNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Natiari­hi­na­varepa nácani tépiya­ca­va­nayare mavaneruana ema Tata. Tamutusera eta náimitu­rapiana náepiya­hi­rai­va­ya­rechucha, camuria­nayare ena navayua­rua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Énaripa ena arajuruana, tétavi­ca­vainapa eta namasua­pa­ji­raivaya, vaipa napicau­chaimahi ema Viya. Camuria­nayare éna vaipa témuna­ra­hia­náimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Étisera nuchane­ranahi, te ecamichahi tamutu, ímiya­na­va­hivare eta éhisi­ranuhi te táitavapa tamutu, nucuchu­cu­ha­heyare núti. ");
INSERT INTO ignNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Éneri­chuvare, eti nuchanerana ecame­ta­rai­ruyare te tamutu avasareana, taicha nuvaraha náecha namutu ena achaneana. Ímitu­ca­va­ca­yarehi eta najaca­pa­ca­revahi me Tata namutu ena téneucha­vanahi, étapa eta apamuriana nímitu­rapiana. Te ítecapapa te tamutu eta avasareana, nápecha­vayare nuchava. ");
INSERT INTO ignNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Numeta­ca­he­va­nevare eta apana. Járaja­payare eta sache táiñehi­que­neyare. Tímere­cavaya ema achane váinara­jiquene, máechaji­si­ha­quenehi ema víyarahaini profeta Daniel. Mavane­cayare ena machanerana náechipe­ji­si­rayare eta tacapi­ca­hu­quenehi Templo, nacuchu­ca­va­cayare ena téhicanahi ema Viya. (Nácani navaraha nacaicutiara eta juca, tacamunuhi ticara­va­hua­nayare eta májurehi ema víyarahaini Daniel.) ");
INSERT INTO ignNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tásiha, te ímahapa eta juca, esamai­ri­ri­ca­papuca, táuricapa etatajipa ejunavane, éti etiari­hi­que­neanahi te Judea. Ecaiju­heyare eta te cérroana, étaina eyumu­ru­siavaina. ");
INSERT INTO ignNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nácani tiávihanahi te nayehe canchón te nasamai­ri­ricapa eta juca téchacarehi, táuricapa najuna­vanepa. Vaipa táuricahini nasiapa­nu­mahini te napenana, navehahini jácani náeñama­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nácani tachima­ra­rua­nayare te vámahi eta téchacarehi, táuricapa vaipa nacuchava tayehe eta avasare, tayanapane náeñamahi eta nayere­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Páureanasami nácani esenana tachima­ra­rua­nayare, nácani ticaja­ria­na­hipuca, nácani esenana ticachi­chanahi eta amuya tiájicachaha! ");
INSERT INTO ignNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eta tacahe, eyasea­cayare ema Viya tacuija táicheji­cahe; váhivare tacuchi­ma­racahe eta ichape tiquiva te achene te eyana­papuca ejuna. ");
INSERT INTO ignNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Te jena sácheanayare, tétavi­ca­vayare eta nacata­ji­vai­ra­yarehi ena achaneana. Tájina tácutimahi eta táiñehi­vayare eta nacata­ji­vai­rayare, te táepani­ravahi eta náitare­sirahi ena achaneana te juca apaquehe. Te táequenénapa eta tíñehi, tájinainapa tácutimahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nájina tacaiti­ruimahi eta nacata­ji­vai­ra­yarehi ichape. Macaiche­ca­va­ne­ya­resera ema Viya eta masemavahi ema maca achane váinara­jiquene, mavarairahi ema Viya macuchu­cu­havaca ena machanerana manere­jiruana, majapa­nu­que­nea­na­hivare. Taicha te vahi macucaicheca ema Viya, máitamu­ri­ha­hi­pucaini macapa­pa­ji­cavaca namutu ena achaneana ema maca achane. ");
INSERT INTO ignNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Éneri­chuvare te tánehipaicha eta juca, natiari­hinapa ena tivayua­rahiana tépiya­ca­va­nayare Cristo tímiva­si­cha­va­nainapa núti. Natiari­hivare ena tímicu­ti­ji­ri­ca­va­nayare profetana mavane­rui­nahini ema Viya. Áninapa nacaheyare: “Yare, éhicayare ema Cristo. Matiari­hipahi te juca vitaracu”. Ena apamuriana ánivare nacaheya: “Náepiya­hi­raivahi éna. Ema Cristo mávihahi te viávasa víti”. Étisera vahi ecusua­pavaca. Eta navarairahi tivayua­ca­heanaya eti machanerana ema Tata, náiturue­que­ne­hayare naicha eta ichape­queneana tiárami­careana ecutia­ra­rea­nayare. Camuria­na­sa­miyare ena navayua­rua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Étisera vahi tivayua­ca­hea­naimahi taicha numeta­ca­he­vanehi puiti. ");
INSERT INTO ignNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Te náichahepuca: “Ímaha máenahi ema Cristo ánaqui te mávapahi apaquehe”, vahi ecuyana. Étaripa te náichahepuca: “Mararihipa jácani tayumu­ru­re­va­quenehi cuarto. Vicarichu viti vímatihi eta mávihahi”, váhique­nevare ecusua­pavaca. ");
INSERT INTO ignNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Taicha te yátupinapa eta nítesi­rayare núti, nucutiyare eta táijahú­chirava títecapa eta térameca. Namutuyare ena achaneana te juca apaquehe tineca­pa­nua­nayare. Tacaheyare eta nuchavi­rayare nuti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vahi ecueñamava távihapuca níteca­pihaya. Núti níteca­pau­chaheya te jácani iávihahi éti. ");
INSERT INTO ignNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tacahe, te táitavapa eta juca nacata­ji­vairaya ena achaneana, enéva­nénapa témahainapa eta sache. Étaripa eta caje, témahai­na­varepa. Témiri­ca­nainapa eta jarairiquiana. Étaripa eta tiávihanahi te anuma vímaima­ha­que­neanahi éneri­chuvare tiyamu­ri­ca­nainapa, tiyeje­je­ca­va­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tásiha, náimahainapa te anuma eta nícutiara núti Manere­ji­ru­nuhi ema Viya. Tíyaha­nainapa eta napisira namutu ena achaneana távacuanahi eta avasareana te apaquehe. Tásiha, tímaha­nua­nainapa núti. Tiámanui­napaipa eta úcaji eta núcupai­si­rayare. Tétavi­ca­vayare eta nujarai­va­ya­repahi, níñehi­napaipa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nuvanecaya ema Arcángele, muracayare eta macachu­jai­ra­yapahi, apaesa ena ángeleana nacuru­ji­cainapa namutu ena nuchanerana nunere­ji­ruanahi, tiásiha­nayare te tamutu eta juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tiuri puiti, nuvaraha nímicu­ti­chinahe eta jácani yucuqui. Eta táitsiva­chi­ra­va­vacapa eta tapacajiana, te ímahapa eta tajimu­yairapa eta tatavaqui, tiúchuca­yarepa eta tapaca­jianaya arairu, tímati­carehi tiánehiripa eta únemu­hui­ra­yarépa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ene tacahehi, te ímaha­yarepa tacaecherapa eta júcana ecutia­rareana, ímatia­cainapa eta tánehi­rainapa eta nuchavira. ");
INSERT INTO ignNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Numeta­ca­he­vanecha: Vuíchaha títava­naimahi ena achaneana náitare­rua­naichaha te táitecapapa eta júcana ecutia­ra­rea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Títavainapa eta anuma étapa eta apaquehe. Tativa­ya­resera títauchava tamutu eta numeta­ru­heanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Eta juca tiárami­ca­re­ya­rechucha. Nájina téchaimahi tájamu­hu­ya­repuca eta táitauchi­ra­vayare, énaripa ena ángeleana vahi náechahini. Nútiva­ne­ré­ca­hi­pucáini néchahini. Macarichu ema Tata, ema téchahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Tacutiyare eta acane eta náijahú­chi­ravahi tépenana ena achaneana machamu­rianaini ema Noé. Ena nani tinicai­ri­hia­na­rinecha, náemata­ne­rinecha térana, tímare­re­canahi ena nachicha­naveana. Vahi téñama­va­naimahi eta náimairahi ema Noé eta masiapirahi tayehe eta ichapequene pacure. ");
INSERT INTO ignNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tájina vahi natseca­vahini eta táiteca­pau­chi­ra­yarehi eta ichape une. Tacahe, eta táemiri­sirapa eta ichapequene tiquiva, tacapa­pa­ji­ca­vacahi namutu éna. Ene nacaheyare ena achaneana te jena sácheyare. Vahi natseca­vahini tayehe eta nuchaviraya. ");
INSERT INTO ignNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Te jena sácheanayare, natiari­hiyare ena apinana ajairana ticaema­ta­neanahi te isaniti, ema émana tiárami­ca­reyare tiára. Ema apana manasinapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tacutiquene, apina­na­hipuca ena esenana cáemata­neanahi tiyuva­re­ca­na­hipuca. Éneri­chuvare esu ésuna tiárami­careya tiára. Esu apana sunasinapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eta tacahe, etsecavahi ecauneuchava éti machu vahi ecune­ca­pauchava eta nítesi­ra­yarehi nuti Iáquenu. ");
INSERT INTO ignNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nuvaraha ácaicu­tia­ra­quenéna. Machu ácutiriana mácani achane námeyeruhi ena tiámerahiana. Tájina máechapia­vahini tájahapuca hórava­yarehi eta náiteca­pau­chiraya te mapena. Te máechapucaini, ticauneu­cha­vai­pahini éma, váipasare nacuame­ye­chahini. ");
INSERT INTO ignNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eta tacahe, éti ecuneu­cha­vayare tamutu sácheana, taicha vahi échahini tájamu­hu­ya­repuca eta nuchavi­rayare nuti Manere­ji­ru­nuhi ema Viya, machu iárame­cariana. ");
INSERT INTO ignNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tiuri, nuvaraha nímicu­ti­chi­na­heyare eta apana. Macañá­ri­hipuca ema empleado máetaviuchahi eta máitupa­ji­jia­si­ravahi. Tisuapa­ji­ra­hivare éma. Ema máquenu tiyana­yarehi te apana avasare. Táitusiava ema máquenu matupa­racahi ema empleado eta máijara­siraya eta tinica­careana ena apamuriana machamu­su­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tétavicava eta máurica­ca­revaya ema maca ticatu­pa­rahahi, te tamutuhi máitauchahi jácani machima­pirana ema máquenu. ");
INSERT INTO ignNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Németeaca, eta tamutuirahi tiuri eta machima­pirahi, matupa­ra­cainapa éma téchayarehi tamutu eta máimaha­queneana. Eta tacahe, nuvaraha ácutipaini ema maca empleado tiúrihi eta máitauraivahi. ");
INSERT INTO ignNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Téhesera váhipuca tiuri eta mapane­reruana ema mácani empleado, máimija­chaichucha tiyere­yarehi eta máiteca­pi­ra­yarehi ema máquenu. ");
INSERT INTO ignNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tásiha, macaete­ma­ji­ri­ca­va­ca­papuca ena machamu­su­vanahi. Máichapapuca eta piesta, tinaha­cavapa téra macacha­ne­vacahi ena macuti­queneana térarahiana, téniricapa. ");
INSERT INTO ignNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tásiha, vaipa maneca­pau­cha­vahini te títecapapa ema máquenu. Machima­racapa ema empleado eta mamapa­chi­chi­ji­siraipa eta máimaha­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eta tacahe, ema máquenu macava­nai­ri­pinapa náestacayare muraca. Tájina najapa­nuhini, tayanapane máiyahai­nepuca, macapi­ti­quia­he­cha­vai­nepuca éma. Tásiha, machu ácutihini ema maca empleado máurirahahi, machu ecaqui­pai­ca­sisami eta te yucu infierno. ");
INSERT INTO ignNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Puiti nuvaraha nímicu­ti­chi­na­heyare nayehe ena tiúchucu­hanaya ticacha­ne­nua­nayare eta néjasihaya eta návacureya, énapa ena vahi ticacha­ne­nua­naimahi. Ena nani nacutihi ena diésqueneana esena­chichana amaperuana. Ticucha­panahi ena araima­nayare, nácapi­rayare te nasamapa eta náiteca­piraya. Tiámaucha­va­va­capaipa eta namicahuana lámparinana. ");
INSERT INTO ignNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ena cíncoqueneana, téchema­ra­hianahi. Tiámaucha­va­va­capahi eta nabotellana eta aceite natseru­vapahi. Ena apamuriana cíncoque­nea­na­hivare máechema­rai­rahana mapane­re­rureana. Vahi námaucha­va­pahina eta nahacei­te­yarehi. Tásiha, tájinapa naviyahini. ");
INSERT INTO ignNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tacahe, vahi náiteca­pa­va­nehini ena araimana. Navara­haipahi tímacana éna. Tavehapa eta ichapu, tímacanapa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tacahe, te enumuhupa yati nasamapa ema tipiaracahi. Ánipa macahe: “¡Nárajapa ena araima­nayare! ¡Yare iácapa!” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Téchepu­canapa namutu ena esena­chichana. Náetupi­ricapa eta namicahuana. ");
INSERT INTO ignNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tásiha, ena cíncoanavare tiájicu­va­caipahi eta namicahuana. Tiyase­se­re­canapa eta aceite. Ánipa nacahe: “Ecata­ji­cahavi ecajihavi eta eyehe aceite, taicha tiájicu­va­caipahi eta juca vimícahuana, vémahae­que­ne­haipa” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Énasera ena cíncoqueneana najicapapa: “Vahi víjara­ca­hémahi machu véchuriaca víti apanava. Vahi várataimahi. Tiúripana eyana evachareca eta ehacei­tena” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tásiha, tiyananapa tivacha­re­pa­na­na­yarehi eta aceite. Eta nayere­vapahi, títeca­pa­nanecha ena araima­nayare. Tisiapanapa te tajuhe te táviha­yarehi eta piesta. Náehicapa ena cíncoana natseru­vanahi te táviha­yarehi eta piesta. Tacahe, ticaeratapa eta tapaja. ");
INSERT INTO ignNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te tiyerepa, títeca­panapa ena apamuriana esena­chichana. Náehaha­mecapa eta tapaja. Ánipa nacahe: “Tata, tata, pivejie­que­ne­hahavi. Vivaraha visiapa” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Émasera ema araye­nayare majicapapa: “Eti, ¿nájaha­he­hipuca? Vahi nímatihe. Németeaca vahi étina tavana­ranaina eta peti” máichavacapa ema araye­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tacahe, ema Jesús máichahavipa: —Éti, vahi ecucuti ena máechema­rai­rahana. Ecuti­ya­resera ena téchema­rahiana. Ecuneu­chavaicha éti, machu vahi ecune­ca­pauchava eta jácani sácheyare eta nuchavi­rayare núti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Puiti nuvaraha nímicu­ti­chinahe tayehe eta níjara­si­raheya eti nuchanerana eta evacu­recana taicha eta táurirahi eta ecaema­ta­nea­si­ranuhi. Matiarihi ema achane rico. Tiyana­yarehi te apana avasare. Máichuha­vacapa ena mapanana mamusurana. Máijaracapa eta maplatane. ");
INSERT INTO ignNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ema achane máimati­vacahi eta náechema­raivahi ena mamusurana. Ema émana máijaracapa cinco millone. Ema apana máijaracapa apina millone. Ema apana máijaracapa étana millone. Nacaeja­pa­cayare eta plata. Tásiha, ema rico tiyanapa te macaiju­he­yarehi te apana avasare. ");
INSERT INTO ignNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tacahe, ema tijacapahi eta cinco millone, macaema­ta­neacapa eta plata. Macaeja­pacapa eta plata. Diez millonepa maicha eta maplatane eta macaeja­pa­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ema apana, ema tijacapahi eta apina millone, éneri­chu­varepa macaeja­pacapa eta plata. Títuca­vavare éma eta cuatro millone eta plata. ");
INSERT INTO ignNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Émasera ema tijacapahi eta étanaichu millone, vaipa macaeja­pa­cahini eta plata. Máecarapa eta plata, mapisirahi eta macaete­hahini. ");
INSERT INTO ignNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tiyere eta mapairi­ri­sirahi ema náejaharu. Téhesera te tichavapa, mayase­re­ca­vacapa eta plata máijara­ruanahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tacahe, tínapucapa ema tijacapahi eta cinco millone. Máijaracapa ema máquenu eta máiturevahi. Ánipa macahe: “Tata, píti píjara­canuhi cinco millone eta plata. Júcahisera cinco millonevare eta táejapa­si­rahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ema máejaharu majicapapa: “Tiuri, nuchicha. Tájina táichava. Tétavicava eta piúriva. Pítauchahi eta picaema­ta­nea­sirahi eta nuplatane. Puiti vahi támapu­ru­jimahi eta piúrivahi tayehe eta juca ánimu­ri­chichahi níjara­ruvihi. Nutupa­ra­ca­vinapa eta camuriquene. Puiti pisiapainapa eta nuyehe. Piúrisa­mu­re­rea­ca­vái­napa”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tásiha, títeca­pa­varepa ema apana ema tijacapahi eta apina millone eta plata. Máichavarepa: “Tata, júcahi eta apina millone eta plata píjara­runuhi. Júcahivare eta apinavare millone eta táejapa­si­rahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ema máejaharu majica­pa­varepa: “Tiuri, nuchicha. Tétavicava eta piúriva píti apana. Puiti, váhivare támapu­ru­jimahi eta piúrivahi tayehe eta juca ánimu­ri­chichahi níjara­ruvihi. Nutupa­ra­ca­vinapa eta camuri­pa­naquene. Puiti pisiapainapa eta nuyehe. Piúrisa­mu­re­rea­ca­vái­napa”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tásiha, títeca­pa­varepa ema tijacapahi eta étana millone. Máichapa ema máejaharu: “Tata, núti nímativihi eta pimaja­pa­nu­raivahi. Pivere­ji­ca­nu­yarehi eta táejapa­si­ra­yarehi eta piplatane. Pítaha­ca­nu­ya­rehiva eta némata­ne­vachahi. ");
INSERT INTO ignNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eta nupisirahi nácaete­hahini eta piplatane, nécarapa. Puiti, júcahi nímichava tamutu eta piplatane”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ema máejaharu majicapapa: “Tétavicava eta pisunsuva, piti plújutataji. Te pímati­nu­hipuca eta numaja­pa­nu­raivahi, nítaharahi eta apaema­ta­nevacha, téhevare pímijachahi nuvere­ji­ca­viyare eta táejapa­si­ra­yarehi eta níjara­ruvihi nuplatane; ");
INSERT INTO ignNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","váhiyapa pinacapaini te banco eta nuplatane. Puiti váequenei­pahini puiti eta táejaha­ca­ri­pahini eta nuchavi­rai­pahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tásiha, máichavacapa ena apamuriana mamusurana natiari­hi­que­neanahi: “Everejica ema mácatataji eta plata. Íjaraca ema ticayehehi eta diez millone. ");
INSERT INTO ignNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Taicha, mácani máiturue­que­nehahi eta macaema­tanea­sirava, tatupa­racahi eta nímica­ta­siraya. Ticaye­heyare camuripana. Énasera nácani vahi náiture­que­ne­hahini eta nacaema­ta­nea­sirava, ticave­re­ji­ca­sia­na­yarehi eta náijara­ca­sianahi. ");
INSERT INTO ignNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Émechareca muraca ema maca musu máurira­ha­tataji. Vahi ecujapanu, tayanapane máiyahai­nepuca, macapi­ti­quia­he­cha­vai­nepuca. Tásiha, iáquijica eta te cuarto tamapi­cu­ju­he­que­ne­pa­nahi” macahepa ema achane rico. ");
INSERT INTO ignNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","33","Te nuchava nuti Manere­ji­ru­nuhi ema Viya, néjacainapa eta te nuyehe trono tacapi­ca­huquene, Réynuinapa. Tásiha, névatacaya ena nuyeheana ángeleana nacuru­ji­ca­vacaya te numirahu namutu ena achaneana te avasareana. Tásiha, núti nunere­ji­ca­va­cainapa ena yátupi­que­neanahi nuchanerana. Nunacainapa te nuvaure. Tásiha, ena vahi nuchane­ra­nai­nahini nunacainapa te sapa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tásiha, nuti Rey ánipa níchayare ena nuchanerana tiáviha­na­yarehi te nuvaure: “Yare, eti iúrica­ca­reanahi manere­ji­ruanahi ema Tata. Níjara­ca­hénapa eta etupa­ra­hayare, ícuchihi mayehe ema Tata acane te tépana­vainapa eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Taicha te ímahanuhi eta nécuavahi, éti énicanuhi. Numaunepahi, éti íjara­canuhi néra eta une. Tájina níteca­pi­hahini te nupaisi­hapahi, éti íjara­canuhi eta níteca­pi­hayare. ");
INSERT INTO ignNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tájina numuiri­hai­na­pahini, éti emuria­chanuhi. Nucajumahi, éti ípucha­pa­nanuhi. Nucaeratahi te cárcel, éti ejira­pa­na­nu­hi­vare”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tásiha, ena níchuha­que­neanahi tijica­pa­nua­nainapa: “Tata, ¿tájamuhu vímahavihi pécuhapahi, tásiha vénicavipa? ¿Tájamu­huvare vímahavihi pimaunepahi, tásiha víti vésichavipa eta une? ");
INSERT INTO ignNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tájamu­huvare vímahavihi te pipaisirana tájina píteca­pi­hahini, tásiha, víti víjara­cavipa eta píteca­pihahi? Váhivare vímaha­vihini mamuria­re­vi­nahini, tásiha víti vimuria­chavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tájamu­hu­va­re­hipuca picajumahi, tásiha víti vípucha­pa­navipa? ¿Tájamu­hu­va­re­hipuca picaeratahi, tásiha víti véjira­pa­navipa?” náichanupa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tásiha, nuti Rey nujica­pai­na­varepa: “Nutupiruva numetacahe: Nútira íjara­canuhi tamutu eta ejapa­nu­raivahi, ímica­ta­si­ra­vacahi ena echamuriana nuchane­ra­na­hivare, ena nani namaesa­cha­que­neanahi najaca­pahini ena apamuriana ena achaneana” níchavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tásiha, ena tiávihanahi te sapa, níchava­cainapa: “Étisera évuisiha te numirahu, eti masuapa­ji­rai­rahana ecaviu­re­vanahi. Eyana tayehe eta yucu, acane­va­cahéna eta ecaicuñaira eta emuruiraya, máicuchihi ema iáquenuhi ema Váinaraji énapa ena majupahana ángeleanainihi. ");
INSERT INTO ignNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Taicha te nécuhapahi, éti vahi íjara­ca­nuhini eta nunica. Numaunepahi, váhivare ésicha­nuhini une. ");
INSERT INTO ignNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Étaripa te nupaisi­ra­napahi, váhivare íjara­ca­nuhini eta níteca­pi­hahini. Néchuri­havare eta numuiriha, váhivare íjara­ca­nuhini numuiri­hai­nahini. Nucaju­ma­hivare, nucaera­tavare, váhivare éjira­pa­na­nu­hini” níchava­cainapa éna. ");
INSERT INTO ignNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tacahe, éna náichanupa: “Tátachicha, ¿tájamuhu vímahavihi pécuhapahi, pimaunepahi, pipairi­ri­capahi, mamuria­revihi, picaju­mapahi, picaeratahi, eta jácani vimáimi­ca­ta­si­rá­vi­hipuca?” ");
INSERT INTO ignNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nuti Rey nujica­pai­na­varepa: “Nutupiruva numetacahe: Éti, vahi ejapa­nu­nuhini, taicha vahi ájapa­nu­va­cahini apaesai­nahini ena nani nuchanerana emaesacha­que­nea­nahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Emutu éti eyanayare tayehe eta ecaicu­ñai­yayare máitava­cayare. Énasera ena nunere­jiruana, matapi­ra­va­reanahi. Námava­cainapa tayehe eta táurivayare eta náitaresira, máitava­ca­ca­yareva. ");
INSERT INTO ignNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te títapi­ricapa eta juca máimitu­ra­pianahi, máichahavipa viti máimitureana: ");
INSERT INTO ignNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Écharichuhi éti eta apinarine sache eta Pascuáiraya. Tásiha, núti Manere­ji­ru­nuhi ema Viya, ticara­ta­ca­nua­nainapa témeta­ta­re­ca­nua­nainapa —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tiuri, ena tuparai­ru­cana énapa ena aquenu­ca­ra­hana, énapa ena escribá­noana ticuru­ji­ca­ca­na­ripahi te tajuhe eta mayehe palacio ema Caifás, ema corregidor. ");
INSERT INTO ignNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tacahe, náechaji­si­haipahi eta nacara­ta­si­rayare ema Jesús. Navaraha éna navayua­ca­yarehi eta nacara­ta­si­rayare, nacapa­si­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tipica­ca­va­na­ri­chu­chasera. Ánipa nacahehi eta náechaji­ri­ruvahi: —Vuíchaha vicuca­rataca éma achichu juca piéstairaya. Taicha camuria­na­yarehi ena achaneana, machu tájahapuca náichara­cahavi taicha navara­ha­yarehi nacatiucha éma. Vicucha­pasera nayana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tacahe, ema Jesús, tiyanapa tichava eta te avasa­rechicha Betania. Náichuha­sivahi eta manisiraya te mapena ema achane ticaijare Simón ema leprosoinihi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tacahe, eta manisirahi, sucahe­paipahi esu ésuna esena. Suámapahi eta perfume te bótechicha. Táetaviuchahi eta tasiva­chavahi. Supauchapa éma. Sujucu­sicapa te machuti eta táetaviurehi eta táijiyeva. ");
INSERT INTO ignNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eta náimairahi ena nuchamuriana máimitureana ema Jesús, váiparinehi náuricahini eta suémepu­ru­re­sirahi eta tasiva­chaquene perfume sujucu­si­sirahi ema Jesús. Ánipa nacahehi: —¿Tájaha tacayema suémepu­rureca eta juca tasiva­cha­quenehi perfume? ");
INSERT INTO ignNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tiúripa­na­hi­pucani víjara­re­cahini eta juca táijiyea­ma­quenehi. Vivehahini eta camuriquene plata; tásiha, vímica­ta­si­hahini ena páureana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Émasera ema Jesús máimatihi eta napane­reruana. Tacahe, máichahavipa: Ésamirica esu suca esena. Tétavi­cavahi eta táuriva eta suíchiranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ena páureanasami, tamutuchucha sácheana eta ecacha­ne­ra­va­cayare éna. Ímica­ta­ca­yarehi te jácani ecaima­ha­que­nérana. Nútisera vahi nánasi­que­némahi eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Eta juca sujucu­si­si­ranuhi eta perfume, sucaina­pucahi ésu eta suíjiye­chirahi eta náquehe tayehe­yarehi eta nucaeca­ra­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nutupiruva numetacahe: Nácani ticame­ta­rai­rua­nayare eta tiúrina echaji­ri­rucava, náechaji­si­ha­ya­revare eta juca suíchaquenehi esu suca esena. Témecha­nayare suyehe te tamutu avasareana te juca apaquehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ema Júlasi, émarichu vichamu­rinihi éma vidoce­nénihi apóstole mayehe ema Jesús. Tiyanapa téchaji­ri­pa­navahi nayehe ena tuparai­ru­cana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ánipa máichavacahi: —Te yátupi­hipuca evarahahi ecarataca ema Jesús, núti nímecha­heyare. Nucamu­nu­hisera néchayare ¿áyana­ya­repuca eta evacha­cha­nuyare eta nímechi­ra­heyare eta mávirare? —máichavacapa. Tacahe, éna náijaracapa eta treinta reale. ");
INSERT INTO ignNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jéheva­re­pasera ema Júlasi matanucaipa eta máichara­ca­yarehi eta máijara­re­si­ra­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tacahe, títecapapa eta piesta Pascua, étaripa eta tínapuca sache eta semana vinicahi eta pan mayehere levadura. Viti máimitureana viyaserecapa ema Jesús: —¿Távihapuca pivarahahi vácaijuhe eta vétupi­ri­sia­vahini eta vinisi­rayare eta uvesachicha eta viyeherepi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Éma tivane­ca­havipa: —Eyana tayehe eta Jerusalén, te mapena ema nímati­casare. Ani íchayare: “Ema maestro tivane­ca­havihi eta piyehe. Ani macahehi: Tiánehipa eta nítavi­rayare eta nématanehi. Te pipena eta nunisi­hayare eta uvesachicha eta viyeherepi, nénisi­hayare ena nímitu­reana” íchayare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tacahe, tiyananapa ena máimitureana. Étapaichuhi náichahi eta máimitu­ra­pianahi. Tinaha­ca­vanapa náetupi­ricahi eta naniruyare tayehe eta Pascua. ");
INSERT INTO ignNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tacahe, te jena yátiquenehi ema Jesús, ténica­havipa viti dócequeneana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te vinica­ripahi, máichahavipa éma: —Jéhesa­reinehi, te etaracu éti, mararihi ema émana tíjara­re­ca­nuyare —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tacahe, víti ichape­rinehi eta máimipa­ne­re­re­si­ra­havihi eta juca máichira­havihi. Vimutu viyase­recapa éma: —¿Nútichupuca, Tata, jácani? —víchava­capahi víti éma. ");
INSERT INTO ignNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tásiha, éma máichahavipa: —Mácani néniruyare eta pan néchipae­jiruhi te juca nuplatura, émara ema tíjara­re­ca­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tacahe, núti Manere­ji­ru­nuhi ema Viya, étapaichuhi eta nacapa­si­ra­nu­yarehi, táitauchi­ra­va­yarehi eta nuyehe eta táechaji­ri­ruvahi eta Sagrada Escritura. ¡Páuresa­misera ema tíjara­re­ca­nuyare! Tiúripa­nai­chu­hi­pucani vahi macuchu­cahini te sujuhe esu maena —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tacahe, téchajicapa ema Júlasi: —Maestro, ¿nútipuca jácani níjara­re­ca­viyare? Tásiha, ema Jesús majicapapa: —Pítisami —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tásiha, eta vinisirahi, mavehapa eta pan ema Jesús. Mahasu­lu­pa­yachapa ema Viya. Mayuve­tucapa, tíjara­ca­ha­vi­vacapa viti máimitureana. Tásiha, máichahavipa: —Eta juca neche. Enica —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tacahe, maveha­varepa eta vasu vérirare, mahasu­lu­pa­ya­cha­varepa ema Viya. Tásiha, tíjara­ca­ha­vivare. Máichahavipa: —Era eta juca ámutu éti. ");
INSERT INTO ignNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Taicha eta juca eta nítine, táepusi­ru­vayare eta nucaepa­hai­rayare eta epeca­turana emutu eti achaneana, esimu­tu­que­ne­yarehi. Étari­chuvare táicutia­rayare eta nufirma­chi­rayare eta arairu matratune ema Vicaiyaquene, nucaeja­si­rayava eta matratune apaesa ámutu ejaca­pacare mayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nutupiruva numetacahe: Vaipa nápecha­vaimahi nérahi­varéni eta juca tachi eta uva. Tiámainucava te táitauchavapa eta nusiapiraya eta nucava­cu­réraya, nucaju­pa­hairaya ema Tata Nucaiyaquene. Te jena sache, níjara­caheya vérainapa eta aramaruama. Vicaju­pa­hainapa ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tásiha, eta vítane­sirapa, vijirapa eta jirasare eta vihasu­lu­pa­ya­chirahi ema Viya. Te vítapi­ricapa, viyanapa vicaijuhe eta te huerta Getsemaní távihahi eta táemiri­pai­sinehi eta cerro ticaijare Olivoquiji. ");
INSERT INTO ignNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Eta vipaisi­rapahi, ema Jesús máichahavipa: —Puiti juca yati ejuni­ji­ca­nuyare emutu éti. Ejuna­ra­cayare. Tásiha, títaucha­va­yarehi eta máechaji­ri­ruvahi ema Tata eta te Sagrada Escritura: “Nísapayare nacarataca ema Pastor, nacapa­si­ra­sa­miyare. Tásiha, tijuna­ra­ca­nainapa eta uvesana macuru­ji­rua­nai­nihi” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Téhesera te néchepucapa te nécari, nínapu­cainapa te Galilea. Ánaqui nucucha­pia­heyare éti —máichahavipa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tásiha, ema Pedro majicapapa: —Tayana­pa­nepuca, Tata, najuna­ra­capuca ena apamuriana, nútisera vahi nujunaimahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ema Jesús máichavarepa: —Nutupiruva numetacavi piti Pedrosami: Puiti juca yati, te tamira­hui­na­paichaha eta táechaji­si­rayare eta varayu, mapahe eta pépiya­si­ra­vayare vahi pímatinu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ema Pedro macahe­varepa: —Tayana­pa­nepuca pímica­pacanu, váhique­nesera népiya­ca­vaimahi vahi nucuima­ti­vihini, váhivare nínajia­ca­vimahi —máichapa. Viti apamuriana étari­chuvare tacahehi eta véchaji­ri­ruvahi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Te vítecapapa víti tayehe eta huerta Getsemaní, máichahavipa ema Jesús: —Éjacachaha eta ani te juca. Ecucha­pa­nuchaha. Núti nuyanayare ánaquipana, nuyuja­ra­cayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mapananaichu ena mámaque­neanahi: ema Pedro, ema Juan émapa ema Jacobo. Ema Jesús, ichape eta máeñami­ravahi te masamure, ticati­sa­mu­revapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tásiha, máichavacapa: —Tétavicava eta táeñamirava muraca eta nusamure. Tavaraha ticapacanu. Ácahéchaha ani te juca. Váhisera ecuimaca. Ecauneu­chanuhi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tásiha, tipaipanapa ánaqui­pa­na­chíchahi. Tiáquipai­cavapa máetipai­sinapa, macaitecapa eta mamira te apaquehe. Eta mayuja­ra­sirahi, ánipa macahe: —Tátachicha Nucaiyaquene, picata­ji­ca­nupaini. Váhini tacuitau­chavaini eta níchava­que­ne­vayare. Váhini picuisapaini eta nucata­ji­vairaya. Níjara­ca­vasera núti eta nítauchiraya eta pivara­ha­quenehi píti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tásiha, téchepucapa. Tichavapa eta te návihahi ena mapana­queneana máimitureana. Máimaha­rinehi éna, tímaca­naripa. Macaja­micapa ema Pedro. Tásiha, máichapa: —Váiparinehi ímica­ta­ca­nuhini ejanea­ca­vahini étanai­na­hi­pucaini hora ácahehini. ");
INSERT INTO ignNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Éjamiuchava. Eyuja­rauchava apaesaina. Eyaseaca ema Viya eta étumevaina apaesa vahi macuitu­rucahe ema Satanás. Yátupi­hinéni eta iáchanevana taratahahi ticara­tacava. Étasera eta éche máteji, vahi tarata­haimahi ticara­tacava —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tásiha, tiápecha­va­varepa tiyana­varepa ema Jesús. Apihepa eta mayuja­ra­sirahi. Ánipa macahe: —Tátachicha Nucaiyaquene, váhini tacuitau­chavaini eta níchava­que­ne­vayare. Tásihasera, níjaracava núti eta nítauchiraya eta pivara­ha­quenehi puiti. Nísapava nacapacanu —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tásiha, tichavavare eta viyehe viti máimitu­reana. Tíma­ha­havipa víti vímamu­rihaipa taicha taveharipa eta ichapu eta viúquihana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tacahe, mapahe­quenepa tichavapa tiyuja­rapana. Étarichuhi eta máechaji­ri­ru­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Te tichavapa, téchaji­ca­havipa: —¿Iápechavapa ímaca? ¿Vuíchahapuca enara­cahini? Jéhesare, puiti títecapapa eta nutupa­rahahi nacara­ta­si­ra­nuyare ena ticatia­na­ca­nuanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ávane ema tíjara­re­ca­nuyare. Échepuca. Viyana viácapavaca —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Téchaji­ri­ca­vaichaha ema Jesús, macahe­painecha ema Júlasi, ema vichamu­rinihi. Mámamu­ri­ha­paipahi ena camuri­queneana achaneana suntaruana. Ticaepu­chi­ri­quia­na­paipahi, étapa eta nayeheana espada. Éna, vanairu­canahi nayehe ena aquenu­ca­ra­hana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ema Júlasi, tatiarihihi eta máicutia­ra­yarehi eta náimati­ra­yarehi ena suntaruana ema Jesús. Ani macahehi eta máechaji­ri­ruvahi ema Júlasi: —Ecune­nuyare. Ema nétsera­re­ruyare, éma ecara­tacaya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tacahe, ema Júlasi témeña­havapa mayehe ema Jesús. Máichapa: —Yátiheipa, tata Maestro —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tásiha, máetsera­recapa. Ema Jesús majicapapa: —Piti nímitu­revihi, ¿tájaha tímitecavi? —máichapa. Tásiha, ena suntaruana enevanepa nacara­tacahi, napresuchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ema émana vichamuri mavehapa eta mayehe espada. Mayucha­ti­pai­sinapa eta machaca ema mamusura ema aquenuca Caifás. ");
INSERT INTO ignNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tásihasera ema Jesús macatiu­chaichucha. Ánipa maicha: —Pinaca te tatuma­ramuhi eta piyehe espada. Taicha namutu nácani ticapa­re­canahi tayehe eta espada, éneri­chuvare nacaheyare, espada eta ticapa­cayare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Váhipuca pecha te návara­hahini núti nuyasea­cahini ema Tata, puítinai­chuhini macucu­pai­cahini ena 80,000queneana ángeleana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Váhisera nuvaraha nuyaseaca. Tatupa­racahi títaucha­va­yarehi eta táechaji­ri­ru­vanahi eta Sagrada Escritura eta níchava­que­ne­va­yarehi —tásiha, máichavacapa ena suntaruana—. ");
INSERT INTO ignNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","¿Tájaha tacayema ecasiña eta espada, ecaepu­chi­ri­qui­pai­pa­hivare eta ecara­ta­si­ra­nuyare, tímicu­ti­ji­ri­cavapa námera­hihini? Étaya­pasica cape juca tamutuhi sácheana nucacha­nehehi nímitu­cahehi tayehe eta Templo. Váhivare epatsi­ca­vahini ecara­ta­ca­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Títaucha­va­hisera tamutu eta juca taicha tacahehi eta náechaji­ri­ruvahi ena profetanaini, tayehe eta Escritura táechaji­si­hai­ranuhi —macahepa. Tacahe, viti máimitureana vimutu vijuna­racapa, vinaquicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ena ticara­ta­canahi ema Jesús námapa te mamirahu ema Caifás, ema corregi­dorhi te jena áñohi. Natiari­hivare ena escribá­noana énapa ena aquenu­ca­ra­hana. ");
INSERT INTO ignNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ema Pedro, máehieque­ne­hapahi, mayere­hi­pa­hisera. Te náimisiapapa, tisiapa­varepa éma te tajuhe eta canchón mayehe ema Caifás. Téjacaipahi macacha­ne­va­caipahi ena suntaruana, mavarairahi máimaha­yarehi tájahapuca eta náichara­ca­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tacahe, ena tuparai­ru­cana énapa ena aquenu­ca­ra­hana natanu­caipahi ena tépiyae­que­ne­ha­na­yarehi ema Jesús, navarairahi tatiari­hi­yarehi eta tiviucha­yarehi eta máepeni­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Váhisera náichima­vahini, camuria­na­hinéni ena tépiyae­que­ne­hanahi. Tisiapa­na­ne­chasera ena apinana tépiyae­que­ne­ha­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ánipa nacahe: —Ema maca achane visamahi víti eta mavarairahi máquipaica eta Templo mayehe ema Viya tacapi­ca­hu­quenehi. Tásiha, máimicha­va­ya­rehiji macaechepuca te mapana­que­nenaji sache —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tacahe, ema corregidor téchepu­ru­cainehi. Mayase­recapa ema Jesús. Ánipa maicha: —¿Tájaha tacayema vahi pijica­pavaca ena nani eta pépiyae­quenehi? ¿Yátupipuca eta nacaye­ma­quenehi? Taicha vímahavi vahi picatiu­cha­vahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Émasera ema Jesús vahi majica­pa­va­cahini. Tásiha, mápechavare mayasereca ema corregidor: —Pímaha puiti, nuyase­re­ca­viyare. Vahi nuvaraha pépiya­hirahi. Némechavi máimahavihi ema Viya. Pátupiruva pimeta­cahavi te yátupi­hipuca pítiquenehi Cristo, Machicha­que­nevihi ema Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tacahe ema Jesús majicapapa: —Yátupi núti Cristonuhi. Nuti Manere­ji­ru­nuhi ema Viya. Tásiha, numeta­ca­heyare eta apana. Járajapaya eta sácheyare ímaha­nuyare eta néjasi­rayare te mavaure ema Viya máitupa­ji­jiá­ru­va­quenehi. Ímaha­nu­yareva núti eta núcupai­si­ra­yareva násihai­rayare te anuma, támira­nu­ya­repahi eta úcaji —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tacahe, ema corregidor eta masamirahi, tisema­rinehi ichape. Tivetsa­yu­jia­cavapa eta mamuiriha eta masema­nevahi. Tásiha, macahepa: —¡Tétavi­cavaipa eta maviurevahi ema maca taicha macaecahihi ema Viya! ¡Puiti émaquenepa visama éma tépiya­cavahi Machicha ema Viya! ¡Váipa tácamesa vitanu­cahini ena testígoa­nai­nahini! ¡Puiti esamaripa éti eta juca macaye­ma­quenehi! ");
INSERT INTO ignNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tájaha víchara­cayare puiti ema maca? —macahepa. Tásiha, najicapapa éna: —¡Ticaviu­revapa! ¡Étaina táimicapaca! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tacahe, náehavacapa ema Jesús. Nátutu­quichapa. Náehami­ra­havare. ");
INSERT INTO ignNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tásiha, náichapa: —Vímaha­se­jicacha, te yátupi­hipuca pítihi Cristo. Te pijarau­quipuca, pímati­ha­viyare nájaha­hipuca ema téhami­ra­havíhi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tiuri, ema Pedro, matiari­hi­chahahi eta te canchón. Téjacaipahi tiásacavahi. Tacahe, sucahe­paipahi esu mavanara ema corregidor. Suímahapa éma. Tásiha, suíchapa: —Németeaca pítirichu ñímiture eñi Jesús eñi ticavasahi te Galilea —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Émasera majicapapa: —Vahi nímati ema péchaji­si­ha­quenehi. ¿Távihapuca pímati­nenuhi píti? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tásiha, mavarahapa tiúchuca­va­ne­ya­rehini. Suímahavare esu apana vanaraca. Suíchavacapa ena natiari­hi­que­neanahi: —Eñi ñica achane éñirichu ñichamuri eñi Jesús Nazareno. Nímahahi ñicacha­nepahi —suíchavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tiápecha­va­varepa ema Pedro téchajica, ánipa macahe: —Nujuracha te emirahu. Váhiquene nímati ema píchaquenehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te tiyere­re­ha­chi­cha­varepa, náimaha­varepa ena apamuriana. Náichavarepa: —Yátupiquene pítirichu machamuri ema maena Jesús, taicha eta péchajisira éta tímereu­chavihi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tásiha, macahe­varepa: —Máicuña­canuine ema Viya te vahi nucucahe yátupina. Váhique­nesera nímati ema achane échaji­si­ha­quenehi —macahepa. Tásiha, enurujipa téchaji­canecha eta varayu. ");
INSERT INTO ignNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te masamapa eta varayu, enevanepa máechahi ema Pedro eta máichirahi ema Jesús: “Te tamira­hui­na­paichaha eta táechaji­si­rayare eta varayu, píti mapaheyare eta pépiya­ca­vayare vahi pímatinu”. Tásiha, tiúchuca­vanepa ema Pedro. Tíyaha­vanepa taicha máimati­vanepa eta táichapevahi eta máejeca­pi­ravahi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Te tijara­rahipa, tiúruji­ca­vanapa namutu­yaréni ena tuparai­ru­cana énapa ena aquenu­ca­ra­hana. Ticaecha­casipa eta náimica­pa­si­ra­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nacuchucapa ticaiti­hapaipa eta námirapahi te mamirahu ema Poncio Pilato, ema aquenucahi prefecto­hiquene. ");
INSERT INTO ignNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tacahe, ema Júlasi eta máimairahi eta táichapevahi eta macata­ji­vairahi ema Jesús étapa eta nacapa­si­ra­yarehi, ichape­rinehi ticati­sa­mu­revahi taicha eta máejeca­pi­ra­varihi. Tiyanapa máimicha­va­panahi eta treinta reale eta plata mavachahi nayehe éna. ");
INSERT INTO ignNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tásiha, máichavacapa: —Néjeca­pavahi ichape eta níjara­re­sirahi ema maca achane matapi­ra­va­requene. Nuvaraha nímichavaya eta nuvachainihi —máichavacapa éna. Énasera najicapapa: —Jéhepuca, vahi vecha víti. Péchaque­ne­vaichuhi píti —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Émasera ema Júlasi máquiji­mi­rau­cha­vacapa eta te tajuhe eta Templo návihahi éna. Tásiha, tiúchucapa. Tiyanapa. Táichavenehi eta macati­sa­mu­re­vairahi, tichumu­cavapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ena tuparai­rucana navehapa eta plata. Tásiha, nacahepa: —Vahi táuricahini víyara­cu­hahini eta juca plata tayehe eta caja vinaqui­si­rareva taicha mavachae­queneya eta máepeni­ra­yarehi ema maca achane —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tásiha, eta plata máimicha­va­quenehi ema Júlasi, napane­rechaipa eta navacha­re­si­ra­yarehi eta apaquehe nacaeca­ra­si­ra­reyare ena apava­sanana. Eta juca apaquehe nasere­si­rarehi ena típuare­ca­rahiana eta yupi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Puiti éta ticaijarehi “Apaquehe máitinevacha ema Jesús”. ");
INSERT INTO ignNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Tacahehi eta táitauchi­ravahi eta májurehi ema víyaraha profetaini Jeremías. Ani tacahehi: “Navehapa eta treinta reale eta plata. Ena tuparai­rucana navacha­recapa eta apaquehe nayehe ena típuare­ca­rahiana. Tacahe eta juca mameta­si­ranuhi ema Viya eta náichira­yarehi eta juca” macahepa ema víyarahaini Jeremías. ");
INSERT INTO ignNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ema Jesús ticaya­se­rehipa te mamirahu ema aquenucahi Pilato. Ánipa macahe eta mayase­re­sirahi: —¿Jéhesareji réyvihi píti nayehe ena pijaneanana israelítana? —máichapa. Ema Jesús majicapapa: —Pitupi­ruvahi eta juca piyase­re­si­ranuhi. Yátupihi eta nurreyvahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tásihasera, te nametauchaipa ena tuparai­rucana, vahi majica­pa­va­cahini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tacahe, ema Pilato máichapa: —¿Vahi péchajiuchava eta juca nametau­chi­ravihi? Camurihi eta piviurevana eta nayehe —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Émasera ema Jesús váhiquene majica­pahini. Tásiha, ema Pilato máramipa eta mamaji­ca­pirahi. Váipa máituca­ca­rehini. ");
INSERT INTO ignNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tiuri puiti, tatiarihi eta mayeherepi ema Pilato, te Páscuamu­huana, macaiti­ca­yarehi ema émana preso, mácani nayasea­ru­yarehi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tiuri, matiarihi ema achane ticaijare Barrabás, ichape eta maviurevahi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eta náuruji­si­ravahi ena achaneana, mayase­re­ca­vacapa ema Pilato: —¿Nájahapuca ema eyase­se­re­ruyare ema nucaitiruya? ¿Émapuca ema Barrabás, téhesera émapuca evaraha nucaitica ema Jesús, ema ticaijare Cristo —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Taicha máimatia­ca­ripahi eta nametauchahi ema Jesús ena tuparai­rucana taicha nacapi­naruhi éma.) ");
INSERT INTO ignNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eta máejasirahi ema Pilato tayehe eta mávacure, suímime­ta­recapa esu mayena: “Vahi picuimi­siapava ñiyehe eñi ñira achane matapi­ravare taicha yati tameta­si­ranuhi eta nuvapure eta ñíchara­ra­ca­vayare éñi” sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Énasera ena tuparai­rucana énapa ena aquenu­ca­rahana náimitu­mu­rihapa ena achaneana nayase­se­recahi ema Barrabás, émainahini máuchucuha. Tásiha, nayase­se­recapa máepenahini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Máechaji­mu­ri­ha­varepa ema Pilato, mayase­re­ca­vacapa: —¿Nájahasica ema evara­ha­quenehi nucaitica? —macahepa. Éna najicapapa: —¡Émaina máuchucuha ema Barrabás! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ema Pilato mayase­re­ca­varepa: —¿Tájahasica nícharacaini ema Jesús ticaijare Cristo? Éna najicapapa: —¡Pémeta­tareca te crusu! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ema Pilato máichava­ca­varepa: —¿Tájaha tacayemahi eyaseacahi eta németa­ta­siraya ema maca? ¿Tájahasica eta maviurevahi? —máichavacapa. Énasera tipiara­re­mu­ri­ha­navare muracapana: —¡Pémeta­tareca te crusu! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tacahe, máimahapa ema Pilato eta vahi máituru­cahini macatiu­chahini, taicha ena achaneana tivayu­cha­va­paichucha eta nasema­ne­vanahi. Tacahe, máemepanapa eta une, ticasi­pa­vahupa te namirahu ena achaneana. Tásiha, máichavacapa: —Nuvaraha nímerecava te emirahu vahi nútipa­racaina eta máepeniraya ema maca achane matapi­ra­varehi. Éti échina­va­yarehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tásiha, najicapapa namutu ena achaneana: —Vítinarine vicata­pirava, énapa ena vichicha­naveana. Vítinarine taeha eta máepeniraya ema maca achane —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tacahe, ema Pilato macava­nai­ripipa nacaitica ema Barrabás. Tásiha, macava­nai­ripipa náestaca ema Jesús; tásiha náetata­ca­ya­revare te crusu. ");
INSERT INTO ignNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tásiha, ena suntaruana námapa ema Jesús tayehe eta náestasi­ha­yarehi te távirarehi eta guardia. Nachayacapa ena camuri­queneana suntaruana náumurivana. ");
INSERT INTO ignNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naveja­mu­hiacapa eta mamuiriha. Namuriachapa eta muíriare títsime. ");
INSERT INTO ignNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Náitsame­macapa eta itapepi eta majara­pi­yarehi náicha. Nanaca­varepa te machuti. Náimica­ra­ta­ca­varepa eta curina te mavahu vaure, matsucu­rú­pa­ya­rehiji. Eta nacava­yue­ma­ra­jirahi, náepuyu­mi­rau­cha­pa­jicacha. Ánipa nacahe: —Tata, ¡pítitataji nayehe­vihíji Rey ena israelítana! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tásiha, nátutu­quichapa. Náetetu­vauchapa eta matsucu­rupahi, náepuchi­sicapa tayehe. ");
INSERT INTO ignNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te tamutupa eta nacaeca­hi­ji­ri­sirahi, naveja­mu­hia­ca­varepa eta mamuiriha títsime. Namuiriachapa eta mamuirihaichu. Tásiha, námapa tayehe eta macaeta­tai­ya­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eta napaisi­rapahi te calle, nácapa­jicapa ema achane ticaijare Simón ticavasahi te Cirene. Napamicapa éma manaracuha eta macurusura ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tacahe, nacaite­capapa tayehe eta masihi nacaeta­tairare ticaijare Gólgota. ");
INSERT INTO ignNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ánaquipa náesichinehi ema Jesús eta vino tisucareama ticasi­riquiama eta ipuruji. Te masamaecapa ema Jesús, vaipa mávara­hahini máerahini. ");
INSERT INTO ignNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te náitauchapa eta náetata­sirahi ema Jesús, ena suntaruana nasuerte­hachapa eta mamuiriha eta náijara­ji­ri­si­ra­cacahi. Tacahehi eta táitauchi­ravahi eta májurehi ema víyarahaini profetaini David. Ánipa tacahe: “Tíjara­ji­ri­ca­canapa eta numuirihaini. Nasuerte­hachapa eta náijara­si­ri­ca­cai­rahi”. ");
INSERT INTO ignNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tásiha, najaneacapa ema Jesús ena suntaruana. ");
INSERT INTO ignNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te tápusi eta macurusura, tatiarihihi eta ajureca táechaji­sihahi eta tiviuchahi. Ani tacahehi eta ajureca: “Ema Jesús, Rey nayehe ena israelí­tana”. ");
INSERT INTO ignNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Natiari­hi­hivare ena apinana tiámerahiana. Ticaeta­ta­na­hivare te machacaya, ema émana te mavaure, ema apana te masapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tásiha, ena tiánucu­mi­rau­cha­napahi, tépiupiu­si­ca­va­napaipa eta nacaeca­hi­ra­paipahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ánipa nacahe: —¡Pítitataji! Picahe­cha­ji­ri­ruvahi eta piáquipai­si­ra­ya­rehíji eta Templo, piráta­ha­hi­varéji pímichava picatupiha eta arairu Templo te mapana­ya­re­ri­chuhíji sache. Puiti vivaraha vímaha eta pítupa­ji­jia­si­ravahi, te yátupipuca Machichavi ema Viya. Piúcupaica te jara crusu. ¡Picatiuchava pítijivaina! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Éneri­chuvare ena tuparai­rucana nacaeca­hi­ji­ri­cavare, énapa ena escribánoana énapa ena fariséoana, énapa ena apamuriana aquenu­ca­rahana. Náichaji­ri­cacapa: ");
INSERT INTO ignNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ema mácacacha, macahehi eta máechaji­ri­ruvahi eta maráta­hai­rahíji macatiu­chavaca ena apamuriana achaneana. Tásiha, puiti váhivare maráta­hahini émaji­vai­nahíni macatiu­cha­vahini eta te jara mávihahi. Te yátupi­nahíni Réyinaíni viyehe viti israelítana, macatiu­cha­vai­pahini, ¿masi? Máucupai­ca­ri­pahini te jara crusu, ¿masi? Visuapa­sa­repaini eta vímairai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Téhevare te yátupi­hipuca ticasi­ñavahi me Viya, vivaraha vímaha macuchucuha éma puítinaríchu, te yátupi­hipuca máemunacahi éma. Taicha macahehi eta máechaji­ri­ruvahi eta machichairahi ema Viya —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ena tiámerahiana ticaeta­ta­na­hivare te machacaya, éneri­chuvare nacaeca­hivare éna apanavare. ");
INSERT INTO ignNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tacahe, te las dócequenepa, témahapa eta sache. Timapicupa tamutu eta apaquehe. Mapana hora eta tamapi­cuirahi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tásiha, te las trespa sache, tipiaracapa muraca ema Jesús, ánipa macahe: —Elí, Elí, ¡lama sabactani! —te véchaji­riruva, ani tacahe: “¡Tata Nucaiyaquene! ¡Tata Nucaiyaquene! ¡Vahi picuju­ni­jicanu!” ");
INSERT INTO ignNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tacahe, ena natiari­hi­que­neanahi ena tisamanahi, ánivarepa nacahe: —Esama ema maca achane mapiaracahi ema víyarahaini profeta Elías —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ema apana tiyanapa tijunapahi máepanapa eta machuchu­ji­ru­yarehi eta tisisica vino. Máitiacapa te tiúqui curinaqui. Máimica­pa­yacapa eta majaca ema Jesús, machuchu­ji­ca­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Énasera ena apamuriana, ánivarepa nacahe: —Ésami­ri­cachucha. Vímahayare te títeca­pa­ya­repuca macatiu­chapana ema Elías —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tásiha, tiápecha­va­varepa tipiaraca muraca ema Jesús. Tásiha, tépenapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tásiha, tíjahú­chavapa tétsayu­mecapa eta cortina tayehe eta Templo. Tépanava te anuquehe, tíchecuha te apaquehe. Tiyaya­carepa eta apaquehe. Étaripa eta ichape­pu­hi­queneana mari téjepui­cha­va­cavare. ");
INSERT INTO ignNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Étaripa eta ecariana téjiaca­vacapa. Téchepu­ca­na­varepa ena náepena­queneana ena tisuapa­ji­ra­hianahi mayehe ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tásiha, te mapana­quenepa sache, téhevare te táequenepa eta máechepu­sirahi ema Jesús te máecari, éna apanavare tiúchucanapa tayehe eta náecariana. Tásiha, tisiapanapa tayehe eta avasare Jerusalén. Tichavanapa te napenana. Ichape­mu­rianahi ena achaneana tímahanahi éna. ");
INSERT INTO ignNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tacahe, ena tijanea­re­canahi, émapa ema nacapitara, te náimahapa eta tayaya­ca­revahi eta apaquehe, étapa eta apamuriana tiárami­ca­reanahi, ichape­rinehi eta napisirahi. Tásiha, nacahepa: —Yátupi­que­ne­ri­chuyapa Machicha ema Viya ema maca —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Natiari­hi­hivare ena camuriana esenana. Tímara­ra­canahi te tiyerehi. Ena nani esenana, éna téhicanahi ema Jesús. Téchapa­ji­ri­ca­napahi ema Jesús eta mapaisi­rapahi te másihapa te Galilea. ");
INSERT INTO ignNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nacari­chusera ticajuanahi eta náijaruana esu María Magdalena, ésupa esu apana María, maena ema José émapa ema Jacobo. Sutiari­hivare esu mayena ema Zebedeo, náena ena nuchamu­rianahi ema Juan émapa ema Jacobo, apóstoleanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Matiari­hivare ema achane rico ticaijare José. Ticavasahi te avasare Arimatea. Émarichuhi téhicahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Te capere­rehipa, eta máimairahi máepeni­raipahi ema Jesús, tiyanapa mayehe ema Pilato. Mayasea­panahi eta máquehe ema Jesús, mavarairahi máecarayare. Tacahe, ema Pilato macava­nai­ripipa náisapahini eta náecarairaya. ");
INSERT INTO ignNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nacucu­pai­ca­sarepa eta máquehe ema Jesús tayehe eta crusu. Náyuruacapa tayehe eta tijapuquene sávana. ");
INSERT INTO ignNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nanacapa tayehe eta máecari máemepi­ya­reruhi máecari­yahini ema José. Eta juca ecari, naseca­jueruhi eta mari. Najihachapa tayehe eta tajita­ca­requene márime. Te náitauchapa, tiyananapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Esu María Magdalena, ésupa esu apana María, téjacanahi éna, náimara­ra­ra­caipahi eta ecari. ");
INSERT INTO ignNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tásiha, te apanapa sache tiyana­na­varepa ena tuparai­ru­cana mayehe ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Náechajicapa ema Pilato. Ánipa nacahe: —Tímite­ca­havihi, tata, vimeta­panavi eta máechaji­ri­ruvahi ema Jesús te achane­richaha eta máechepu­si­ra­ya­rehiji te máecari te mapana­que­né­napaji sache. ");
INSERT INTO ignNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Puiti, vivarahahi picava­nai­ri­pihini náeratahini muraca eta tapaja eta máecari, mapanai­navare sache eta najanea­si­rayare ena suntaruana. Machu nayana te yati námechapana eta máquehe ena máimitureana. Machu nácaheriana “Téchepu­caripa te máecari”. Tásiha, ena achaneana nasuapai­na­papuca, náimija­chainapa yátupi. Tisuapa­ca­re­pa­nai­na­papuca tayehe eta máichaque­neanahi te achane­richaha —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ema Pilato máichavacapa: —Tiuri, níjaracahe ena nusunta­rurana. Eyana iama. Evaneca najanea­ca­quenéna. Nachuji­cha­quenéna muraca eta máecari —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tacahe, tiyananapa nachujichapa muraca eta ecari. Nanacapa eta táicutia­ra­na­­yarehi. Tásiha, najaneacahi ena suntaruana. ");
INSERT INTO ignNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te apanapa sache te tijara­ra­hi­chichapa eta lumíncu­quenehi, tiyanapa esu María Magdalena, sucachanehi esu apana María, náimaha­pa­na­yarehi eta ecari. ");
INSERT INTO ignNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tíjahú­chavapa tiyaya­carehi eta apaquehe. Émahi ema ángele eta máucaupai­s­irahi te anuma. Te máiteca­pauchapa eta ecari, máequehe­puichapa eta mari tajihainihi eta máecari. Máejaha­mecapa eta mari. ");
INSERT INTO ignNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tétavicava eta majaraivahi, tivayu­hau­quirahi. Eta mamuiriha, tétavi­ca­vavare eta tajapuva. ");
INSERT INTO ignNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Eta náimairahi ena suntaruana, tiáquipa­pai­ca­vanapa, tiyaya­ca­reanapa eta napisirahi. Tiánehini tépena­racana. ");
INSERT INTO ignNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tásiha, ema ángele máechaji­ca­vacapa ena esenana. Ánipa macahe: —Vahi ecupicanu. Núti néchahi eta etanu­si­rapahi ema Jesús ema macaeta­ta­que­nénihi. ");
INSERT INTO ignNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Májinaipahi eta te tajuhe eta máecari. Téchepu­ca­ripahi taicha tacahehi eta máechaji­ri­ruvahi. Yare, ímaha eta juca mávinénihi. ");
INSERT INTO ignNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eyana púitinarichu, emeta­pa­navaca ena echamu­rianahi máimitureana eta máechepu­si­raipahi tayehe eta máecari. Éneri­chuvare emeta­cavaca tiyanayare ema Jesús eta te Galilea. Ánaqui macucha­pia­heyare emutu éti. Eta tímite­canuhi núti numeta­pa­na­he­yarehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tacahe, ena esenana tiyananapa tichavanahi tijuna­pa­raca­napaipa eta nameta­si­ra­yarehi ena nachamuriana. Tipica­napaipa, tásihasera tacacha­nepahi eta náurisa­mu­re­vapahi ichape. ");
INSERT INTO ignNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eta najuna­pi­rapahi, tíjahú­chavapa tímerecava ema Jesús eta nayehe. Máechaji­ca­vacapa. Témeña­ha­vanapa éna eta mayehe. Tépuyu­canapa natsiuca­pe­vachapa. ");
INSERT INTO ignNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Éma máichavacapa: —Vahi ecupicanu. Eyana emeta­pa­navaca ena apamuriana echamuriana nímitu­reanahi. Eyanayare emutu te Galilea. Ánaqui nucucha­pia­heyare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Eta najuna­pi­rapahi ena esenana, ena suntaruana tijanea­re­ca­nainihi tiyananapa éna, nameta­pa­na­va­ca­yarehi ena tuparai­ru­cana tamutu eta náimaha­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tacahe, ema corregidor ticuru­ji­ricapa namutu ena apamuriana aquenu­ca­ra­hana, mavarairahi téchaji­ri­cavana napane­re­chayare eta náichara­ca­va­yarehi. Jéhesare, navacha­cha­vacapa eta camuriquene plata ena suntaruana. ");
INSERT INTO ignNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tásiha, náimitu­ca­vacapa, ánipa náicha: —Te natiari­hi­napuca nayase­recahe, ecaheyare: “Tiyananahi ena máimitureana ema Jesús te yátimuhu; námecha­panahi eta máquehe. Ticama­pu­ra­vanahi eta vímasirahi víti” ecaheyare. ");
INSERT INTO ignNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Émaripa ema aquenuca te máechapuca, vímaha­rinepa víti. Vitanu­cayare eta vivayua­ra­si­rayare, apaesa tacuija eviurevaina éti —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tacahe, ena suntaruana najacapapa eta plata navachahi. Tiyananapa. Jéhesare, étapaichuhi náechaji­si­hapahi eta náimitu­ca­sivahi. Puíticha, ena israelítana, tanasi­richuhi tacahehi eta nametarapi, te natiarihi ena tiyase­recana. ");
INSERT INTO ignNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ene tacahehi eta viyanirahi viti óncequeneana apóstoleana tayehe eta Galilea te cerro taicha tacahehi eta mameta­rapihi éma Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tacahe, te vímahapa ema Jesús, vépuyu­mu­ri­ha­vanepa. Vimutu vitsiucapa. Natiari­hisera ena vuíchaha nasuapa­pa­ji­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tásiha, ema Jesús témeña­havapa eta viyehe. Máichahavipa: —Ema Tata te anuma titupa­ra­canuhi núti néchayare tamutu te anuma étapa te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eta tacahe, eyanayare puiti epaicayare tamutu eta avasareana. Ímitu­cayare ena achaneana, nuchane­ranaina éna apanavare. Ícacha­si­ca­va­ca­ya­repahi te máijare ema Tata, nútipa nuti Machicha émapa ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ímitu­ca­yareva eta nasuapiraina éna apanavare tamutu eta nímitu­ra­pianahi eta eyehe. Núti, tayanapane nuyerehehi, nímica­ta­ca­he­ya­resera. Níjara­ca­hé­napaipa eta nítupa­ji­jia­sirava. Tamutu sácheana nucacha­ne­he­va­ca­yarehi. Váhiquene nujuni­jia­ca­héimahi —máichahavipa. Tamutupa eta juca nájucha­quenehi eta nímaha­quenehi nuti Mateo.");
INSERT INTO ignNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","3","Nupara­pe­naveana, puiti nuvaraha numetacahe eta máitare­sirahi ema Jesucristo, Machicha ema Viya, te títeca­pau­cha­havipa te vitaracu. Ichape­rinehi eta viúrica­ca­revahi puiti taicha eta mameta­si­ra­havihi eta táurina­quenehi máechaji­ri­ruvana ema Viya. Ánaquia­pa­ripahi eta áñoana acane, ema Viya mametacapa ema víyarahaini profeta Isaías eta mapane­reruhi, eta mavane­si­rayare ema Machicha te juca apaquehe. Éma, tímitecahi ticatiu­ra­hi­yarehi. Éneri­chuvare matiari­hi­yareva ema apana achane máichuha­que­ne­yarehi ema Viya. Macame­ta­rai­ru­yarehi, máetupi­ri­ca­va­cayare ena achaneana, náinaji­si­ra­yarehi eta tamauri­queneana napane­reruana apaesa táuri eta najaca­pi­rayare ema Machicha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tiuri, te táequenepa eta juca, camuri­quenehi áñoana, tiúchucapa ema achane ticaijare Juan. Éma, máichuha­quenehi ema Viya eta macame­ta­rai­rui­rayare, máetupi­ri­ca­va­cayare ena achaneana. Tacahe, masuapahi eta matupa­rahahi. Tiyanapa vámahi­cu­ruhapa. Vaipa avasa­re­cu­ru­hainaini. Ticame­ta­rai­rupaipa nayehe ena macuti­queneana vámahi­cu­ruhana. Ánipa macahehi eta máimitu­re­sirahi: —Ítsivacha eta epane­reruana. Éneuchava mayehe ema Viya, apaesa maperdo­nachahe eta epeca­turana. Te éneuchavapa, núti nícacha­si­ca­hénapa, apaesa etsecavaipa eta ejaca­pi­rayare ema Cristo —máichavacapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tacahe, nárajapapa napaucha ena achaneana ticavasana eta te ichape avasare Jerusalén étapa eta apamuriana avasareana te táunavahi eta provincia Judea. Eta nametau­re­si­ravaipa ena achaneana, navarairaipa náinajica eta napeca­turana, ema Juan máicacha­si­ca­va­capaipa tayehe eta cajacure Jordán. ");
INSERT INTO ignNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ema Juan, vanairucahi me Viya, profetahi éma. Eta macamui­ri­hairahi eta náitsameru tajiyaha eta náitatiquene ticaijare camello. Eta máitijuhe, vácapi jayumepi. Eta manica­sa­reanahi eta tsacara. Eta máitiverahi eta mápama. ");
INSERT INTO ignNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ánivare macahe eta macame­ta­rai­ruirahi: —Ávane­pai­pa­hisera mácani yátupiquene Cristo. Éma, tiápaju­pa­navahi nuyehe núti eta mapicau­cha­ca­révahi. Váiparinehi nácuti­sa­mimahi eta máitupa­ji­jia­si­ravahi. Váipari­ne­hivare nácaemu­ña­vaimahi macamu­su­ra­nuhini núti páuresami. ");
INSERT INTO ignNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yátupi núti nícacha­si­cahehi te une, te éneuchavapa mayehe ema Viya. Émainapa, tícacha­si­ca­hé­na­varepa eti ecasi­ña­vanahi mayehe éma, tíjara­ca­hé­na­sarepa ema Espíritu Santo —macahepa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te jena sácheana eta mávihai­ra­richaha ema Juan te cajacure Jordán, títecapapa ema Jesús. Másihapahi te avasare Nazaret te tinapaica eta Galilea. Tásiha, ema Juan máicacha­sicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te tamutupa, te tiúcupaicapa eta te une ema Jesús, tíjahú­chavapa máimaha téjiacahi eta anuma. Máimaha­varepa ema Espíritu Santo ticutipahi eta paluma. Máucupauchapa ema Jesús, mávahácapa éma. ");
INSERT INTO ignNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tacahe, nasamapa eta mahu ema Viya tásiha­quenehi te anuma. Ani macahehi eta nasamirahi: —Pítira nuchicha némuna­ruquene. Núrisa­murecha piyehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tacahe, ema Espíritu Santo eta mávahá­sa­mu­re­chirahi, enurujipa máimitu­caipahi ema Jesús eta mayaniraya te mávapahi apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eta mayerevahi ema Jesús cuarenta sácheana. Tásiha, ema Satanás macaitsa­ma­rajipa, mavaraha macaetema ema Jesús. Váhisera márata­hahini. Tatiari­hivare eta sárareana eta te mávihahi ema Jesús. Te tamutupa, ena ángeleana náechapa­ji­ricahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tacahe, te jena sácheana, nacara­tacapa ema Juan. Námapa te tiyerehi. Tacahe, tiyanapa tichavahi ema Jesús eta te provincia Galilea. Tépanavapa ticame­tarairu. Máichuha­vacapa ena achaneana náehica­yarhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ánipa tacahehi eta mametarapi: —Éneuchava mayehe ema Viya. Ítsivacha eta epane­reruana. Taicha puiti tíchuha­hénapa ema Viya. Tiánehipa eta sácheyare títeca­pau­cha­hénapa eyehe ema ticatiu­cha­heyare. Aquenu­cayare mavaneruhi ema Viya, éma téchaheyare. Ichape eta iúrica­ca­revaya te esuapa eta nímitu­rapiana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tacahe, eta mapaisi­rapahi ema Jesús te tachausi eta cáquiure Galilea, máimaha­vacapa ena apinana ajairana, ema émana ticaijarehi Simón Pedro émapa ema maparape Andrés. Eta náemata­nerepi ena nani, ténica­ra­hianahi. Náquijie­recahi eta nayutahe. ");
INSERT INTO ignNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tacahe, ema Jesús máichavacapa éna: —Yare, éhicanu. Núti níjara­caheya eta apana émata­ne­re­piyare. Éti ítuca­va­pa­racahi eta jímana; tacaheyare eta ítusi­ra­va­yareva ena achaneana, machane­ra­nayare ema Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Enevanepa náinajicahi éna eta náenisirahi. Tiyananapa náehicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ánaqui­pa­na­varepa máimaha­varepa ena apinana ticapa­ra­pe­ca­ca­navare ema Jacobo émapa ema Juan. Téjacanahi te napacure. Matiari­hi­hivare ema naiya Zebedeo. Náititi­ji­ricahi eta nayutaheana. ");
INSERT INTO ignNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ema Jesús máichuha­varepa ena apinana. Tásiha, náehica­varepa. Najuni­jicapa ema naiya Zebedeo. Manasipa éma te pacure, macachanehi ena mamusurana. ");
INSERT INTO ignNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tacahe, títeca­panapa tayehe eta avasare ticaijare Capernaum. Eta juca sache sávaru­muhuhi, tiyanapa ema Jesús eta te naúruji­si­rareva ticaijarehi sinagoga. Máimitu­ca­vacapa ena tiúruji­ca­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ichape náramihi ena achaneana eta máimitu­ra­pianahi táicha vahi nasama­sa­ré­nahini. Tétavi­cavahi eta máitusirahi mayuna­paicahi tamutu. Tétavi­cavahi eta tasuapa­ca­revahi eta máimitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te nataracu ena náuruji­ru­vanahi, matiarihihi ema émana achane mávaháruhi ema éreana. Tipiara­recapa, ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Núti nímativi. Pítira Sántoque­nevihi. Machicha­que­nevihi ema Viya. Pésami­ri­ca­ha­vipaini, piti Jesús Nazareno. Váhini picuesi­ru­ji­ca­havini. Pivara­hai­na­papuca pijara­re­ca­ha­viyare —macahepa ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tacahe, ema Jesús macajachapa ema éreana. Ánipa maicha: —¡Pámatina! Piyana pijunijica ema maca achane —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tacahe, ema achane tíjahú­chavapa tiáquipaicava, tiyaya­carepa. Tipiara­recapa muraca maicha ema éreana eta majuni­ji­si­ra­yarehi ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tásiha, náraminehi ichape ena natiari­hi­que­neanahi. Tiyase­re­ji­ri­ca­canapa, ánipa nacahe: —¿Tájahasica tacayema eta juca? Ema maca Jesús, tétavicava eta máitupa­ji­jiá­si­ravahi, maratahahi máquijica ena éreanana. Tásiha, ichape eta napisirahi ema. Vahi nácapae­ma­chahini. Tamutupa arairu eta máimitu­ra­pianahi ema maca —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tacahe, nasamai­ri­ricapa namutu ena achaneana eta juca máichaque­neanahi ema Jesús. Énaripa ena ticava­sanahi te avasareana eta te táunavahi eta Galilea. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tacahe, te tiúchucanapa tayehe eta náuruji­si­rareva, tiyanapa ema Jesús te napena ema Pedro ema Andrés. Náehica­varepa ena apinana ema Jacobo émapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sutiarihihi esu máimase ema Pedro. Sunasi­que­neipahi tívecahi, ticajumahi ésu eta muraca fiebre. Nametacapa ema Jesús eta sucaju­mairahi esu esena. ");
INSERT INTO ignNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tásiha, mapauchapa. Macara­ta­vauchapa, macaeche­pucapa ésu. Táetavia­ca­va­neinehi eta fiebre. Tacahe, suéchapa­ji­ricapa ema Jesús, énapa ena máimitureana. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te jena cápere­hi­quénehi, te téricapa eta sache, ena achaneana námava­capaipa eta mayehe ema Jesús namutu ena nacaju­ma­queneana énapa ena návahá­ruanahi ena éreanana. ");
INSERT INTO ignNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jéhesa­réinehi, namutu ena achaneana ticava­sanahi tayehe eta avasare tiúruji­ca­vanapa te tapaja eta peti. ");
INSERT INTO ignNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Camuriana ena macana­raruana tayehe eta apanapane jumareana. Mavera­navare ena váinarajiana máquiji­rua­napahi te náqueheana ena achaneana. Váhisera máisapahini náechaji­cahini ena éreanana, taicha náimatihi éna eta émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tacahe, te tijara­rahipa, téchepu­ca­vanepa ena Jesús. Tiyanapa eta te mayuja­ra­sirare. ");
INSERT INTO ignNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te téjamicapa ema Pedro, májinaripa ema Jesús. Tásiha, tiyananapa nacapa­yacapa éma eta te mayuja­ra­sirare eta te mávapahi apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te náiteca­pauchapa, náichapa: —Namutu ena achaneana titanu­ca­vianahi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tásiha, máichavacapa ema Jesús: —¡Páureanasami! Nuvara­ha­pasera viyanayare tayehe eta apana avasareana apaesa nucame­tarairu taicha nutupa­ra­ca­si­vaichuhi níchuha­vacaya namutu ena achaneana náehica ema Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tacahe, ema Jesús tiyanapa tipaica tayehe eta avasareana te Galilea. Ticame­ta­rai­rupaipa eta te náuruji­si­ra­revana. Éneri­chuvare nayanau­chapaipa ena achaneana návahá­ruanahi ena éreanana, máquiji­ca­va­capaipa ena éreanana. ");
INSERT INTO ignNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tacahe, te apanapa sache, títecapapa ema émana achane macaju­maquene eta lepra. Mapauchapa te mamirahu ema Jesús, máepuyu­mi­rauchapa. Tásiha, máichapa: —Tata, nucasi­ñavahi eta piyehe, picana­ra­ca­nupaini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tacahe, ema Jesús tijimu­yainehi majapa­nuinehi. Manacapa eta mavahu. Máichapa: —Nuvaraha nucana­racavi. Tájinapa píchiravaina puiti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Enevanepa tinaraca. Vaipa leprósoi­nahíni. ");
INSERT INTO ignNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tacahe, ema Jesús máevatacapa ema achane. Matupa­racapa ichape vahi macume­ta­jirica. Ánipa máicha: ");
INSERT INTO ignNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Pímaha, piyana­ya­resera pímerecava nayehe ena tuparai­rucana, apaesa náimamacavi. Énainapa timeta­ji­ri­ca­nayare eta yátupirahi pinaraca, pipachihapa. Nacuijasera picume­ta­cavaca eta nútirahi nucana­racavi. Tásiha, piyana­yareva me Viya. Picama­va­hu­ya­repahi eta pihasu­lu­pa­ya­chi­rayare taicha eta macana­ra­si­ravihi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tacahe, tiyanapa ema achane. Timeta­ji­ri­ca­pai­pasera, mametacapa namutu ena achaneana eta máichava­que­nevahi. Eta tacahe, ema Jesús vaipa máimere­ca­vahini te avasareana taicha eneva­ne­yarehi náurujiaca ena achaneana tímara­hijiana. Tacarine tiyanahi tayehe eta nájinaricha achane­na­hichaini. Énasera ena achaneana tiyana­naichucha napauchahi. Tiásihana tayehe tamutu avasareana. ");
INSERT INTO ignNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tacahe, te apana­varepa sache, tichavapa ema Jesús eta te Capernaum. Eta nasamai­ri­ri­sirahi eta matiari­hi­raripa éma, títeca­pa­napaipa ena achaneana, camuri­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tiyutu­tu­ca­vanapa eta te peti mávihahi éma. Tájinapa távira­vai­nahini eta te tapaja­chacaya. Ema Jesús máimitu­ca­vacaipa eta nacaiju­heraya me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tacahe, títeca­pa­na­varepa ena apamuriana, námapahi te áchuji ema achane muracaha. Cuátroana ena tíamanapahi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Váhisera náiteca­pau­chahini eta te mávihahi ema Jesús, taicha eta nayutu­tu­si­ravahi ena achaneana. Tacahe, naveta­ta­mae­quechapa eta peti eta te máinahu te manapaicahi ema Jesús. Te náitauchapa navetataca, nacaju­chu­chucapa ema macaju­maquene eta te áchuji te mamirahu ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te máimahapa ema Jesús eta nacasi­ña­vairahi eta mayehe, máichapa ema macaju­maquene: —Tiuri, nuchicha. Eta pipeca­tu­ranahi nucaepa­hai­navipa —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tacahe, éneri­chuvare natiari­hi­hivare téjacanahi ena escribá­noana. Napane­re­que­nehapa eta macaye­ma­quenehi ema Jesús. Tásiha, tisema­na­rinehi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ánipa nacahe te nasamureana: “Ema maca tímija­cha­vai­papuca Viya eta macaepa­hai­ra­yaréji eta pecatuana. ¡Tétavicava eta matapirava! Taicha macarichu ema Viya marataha macaepaha eta pecatuana. Nájina apanaina tiratahaina ticaepahaina eta pecatuana” tacahehi eta napane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Enurujipa ema Jesús máimara­ra­ca­vacahi eta nasamureana étapa eta napane­re­ruanahi éna. Tacahe, máichavacapa: —¿Tájaha tacayema téjecapava eta epane­reruana? ");
INSERT INTO ignNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tájina táejeravaina eta níchirahi ema maca: “Nucaepa­hai­navipa eta pipeca­tu­ra­nahi”. Máejera­re­pá­napuca níchahini: “Nucana­ra­cavipa. Péchepuca, piveha eta pímacaraji, piyana pipaica”. ");
INSERT INTO ignNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Tiuri puiti, nuti Manere­ji­ru­nuhi ema Viya, nímereu­cha­vainapa eta nurata­hairahi nucaepaha eta pecatu te juca apaquehe. Ímara­racanu —tacahe, máichapa ema macaju­maquene—. Puiti, nuchicha, nuvanecavi péchepuca. Piveha eta jara piyereruva. Piyana te pipena —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eneva­ne­rinehi téchepuca ema macáju­ma­quenéni. Mavehapa eta mayereruva. Tipaicapa te namirahu ena achaneana. Tiyanapa tiúchucapa. Eta náimairahi, ichape eta náramirahi namutu ena natiari­hi­que­neanahi. Tétavi­ca­vainehi eta nacuna­chirahi ema Viya. Ánipa nacahe: —¡Tétavicava tárami­careva eta máichaqueneana ema Viya! ¡Asulupaya, Tata! ¡Vahi vímaha­sa­ré­nahini! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tiuri, te apanapa sache, tiyana­varepa ema Jesús te tachausi eta cáquiure. Náiteca­pau­cha­varepa namutu ena achaneana eta mayehe. Tásiha, máimitu­ca­vacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tacahe, te tiápechavapa tipaica ema Jesús, máimahapa ema Mateo, machicha ema Alfeo. (Ema Mateo ticaija­re­hivare Leví.) Téjacahi eta te macatu­pa­ra­haiyahi eta macobra­re­sirahi eta impuesto. —Yare, péhicanu —máichapa ema Jesús. Tacahe, ema Mateo enevanepa tiyana máehica ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te jena sácheana, ema Mateo téniricapa eta te mapena. Mámapa ema Jesús énapa ena máimitureana. Camuri­queneana ena téhicanahi ema Jesús. Natiari­hivare maverana ena macuti­queneana ema Mateo ticobra­re­ca­rahiana tayehe eta impuesto. Mavera­na­hivare ena apamuriana máemuna­ca­sareana ema Mateo. Tiúrisa­mu­reanahi eta nanisirahi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Títeca­pa­na­varepa ena apanamuri achaneana: ena escribá­noana énapa ena fariséoana. Eta náimairahi eta macacha­nérahi ema Jesús ena máichuha­queneana ema Mateo, nacaecahipa. Ánipa nacahe nayehe ena máimitureana: —¿Tájaha tacayema tísapava ema eyehe maestro macacha­nevaca eta manisirahi ena nánitá­tajiana ticobra­re­ca­rahiana eta impuesto? ¡Tétávi­cavahi eta nacape­ca­tu­ra­raivahi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te masamapa ema Jesús eta náechaji­ri­ru­vanahi, máichavacapa: —Ena ticaju­manahi, tétavi­cavahi eta nacamu­nuirahi ema médico. Énasera ena majuma­reanahi vahi nácamu­nuimahi ema médico. Puítisera, eta tímite­canuhi núti nutanu­cayare namutu ena tisipe­ca­turana apaesa náeneucha­vahini, náinajica eta napeca­turana. Nácani matapi­ra­va­reanahi vahi nasama­vahini nácamu­nu­nuhini —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tacahe, te apahe­varepa, ayunanahi ena máimitureana ema Juan. Ayuna­na­hivare ena fariséoana. Náiteca­pauchapa ema Jesús ena apamuriana achaneana témeje­ca­pa­va­rahiana. Nayase­recapa: —¿Tájaha tacayema vahi naháyu­na­chahini ena pímitureana? ¿Tájaha tacayema vahi nácutihíni ena máimitureana ema Juan énapa ena fariséoana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Majicapapa ema Jesús: —Nímicu­ti­chinahe puiti. Vahi táuricaimahi ayúna­nái­nahíni nácani ticaichu­ha­ca­sianahi tinicanaya nayehe ena araimana. Tiúrisa­mu­rea­na­yarehi taicha matiarihihi ema arayena. Vahi táuricahini ayúna­nái­nahíni. Téhesera te tépenapuca éma, jéhesare ticati­sa­mu­re­va­nayare. Tacutiquene, vuíchaha táuricaimahi ayuna­nai­nahini ena nímitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Járaja­pai­na­pasera eta sácheyare, ticave­re­ji­ca­sia­nayare, taicha ticara­ta­ca­nua­nainapa ena ticapa­ca­nua­nayare núti. Jéhevarepa ayuna­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Esama­nuchaha. Eta juca eta nímitu­ra­pianahi, amairiha arairu. Mavaraha ema Viya arairuyare eta eyehe­re­pia­nayare eti nuchanerana. Vaipa tácuti­ca­caimahi eta nayehe­repiana ena apamuriana achaneana. Eta ítusirahi éti eta nímitu­rapiana, tavaraha ínajica eta ichasi eyehe­repiana tamauri­que­neanahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Eta jena sávarumuhu, tiyanapa tipaica ema Jesús. Mámamu­rihapa ena máimitureana. Témehi­ca­vanapa ena fariséoana. Náetavi­vi­ji­ca­paipahi eta isanitiana. Tacahe, eta napaisi­rapahi, ena máimitureana navechu­qui­ha­paipahi étaja­vapahi eta trigo. Navepi­ra­qui­hapaipa, tépura­ja­ca­cha­va­na­paipahi. Tinica­napaipa. Tísapa­ca­reichucha éta, taicha técuha­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Énasera ena fariséoana eta náimara­ra­si­rapahi, tisema­napaipa. Ánipa naicha ema Jesús: —Pímaha ena pímitureana. Ticaema­ta­nea­na­paichucha eta navepi­ra­qui­rapahi eta trigo puiti juca sache tétavi­cavahi eta tacapi­ca­hu­quenehi. Vahi tísapa­ca­rémahi eta juca nacaema­ta­nerahi puiti —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tacahe, majica­pa­vacapa ema Jesús: —Németeaca éti vahi ecaicutiara eta tacaye­maquene eta Sagrada Escritura, eta máichava­que­nevahi ema víyarahaini David eta mapaisi­rapahi técuhapaipa énerichuva ena téhica­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te émarichaha ema Abiatar náquenu­murihi ena tiyuja­ra­ca­rahiana, ema David tisiapapa eta te mapena ema Viya. Tiyase­se­recapa eta manica­yarehi. Náijaracapa eta pan tacapi­ca­hu­quenehi nanaca­sarehi te mamirahu ema Viya. Nanica­sarehi ena tiyuja­ra­ca­rahiana, émasera ema David vahi tátupa­ra­cahini manicahini. Étasera eta máecuavahi, manicapa eta pan, énapa ena macacha­ne­que­nea­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tímiyanava eta mameta­sirahi éna: —Ema Viya máepiyacahi nativa ena achaneana. Te táequenepa, máimija­re­chinapa eta sache nanara­siraya ena achaneana, tiúricha­yarehi éna. Vahi étainahini témepiyaca eta tihapa­pi­ri­ca­va­cayare éna. ");
INSERT INTO ignNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tiuri puiti, numeta­ca­heyare: Núti Manere­ji­ru­nuhi ema Viya, nútirichu néchahi eta sache nanara­siraya ena achaneana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tacahe, te apana­varepa sávarumuhu, tiyanavare ema Jesús, tisiapahi eta te náuruji­si­rareva. Matiari­hi­hivare ema émana achane vaipa tayamu­ri­cahini eta mavahu, tépena­vahuipa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Natiari­hi­hivare ena fariséoana, ena ticana­ra­ji­ri­canahi ema Jesús. Náimara­racapa éma te macana­ra­ca­ya­repuca ema achane eta te jena sache tacapi­ca­hu­quenehi. Natanu­nui­ricahi eta tiviucha­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tacahe, máichapa ema Jesús ema achane: —Yare, pitupi­hayare ani te namirahu ena achaneana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tacahe, máichapa ena achaneana: —Núti nuvaraha epane­rechaya. Puiti juca sache sávaru­muhuhi, ¿tájahapuca táurica eta víchayare? ¿Tísapa­ca­repuca vicha eta táuriqueneana? ¿Étapuca víchayare eta tamauri­queneana? ¿Táuricapuca vípuchavaca ena achaneana? ¿Vicapa­re­capuca? —máichavacapa. Énasera tímati­na­mu­ria­na­rinehi. ");
INSERT INTO ignNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tacahe, ticati­sa­mu­re­varine ema Jesús eta muracairahi eta nasamureana. Tacahe, tisema­ma­juhepa eta máeseni­mu­ri­hairahi éna. Máichapa ema achane macaju­maquene: —Nímaha. Picaja­ru­vauchava, pímechanu eta pivahu —máichapa. Eta máimere­sirahi eta mavahu ema achane, enevanepa tinara­vau­cha­vanepa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Énasera ena fariséoana, tisema­na­rinehi eta náimairahi eta juca máichaquenehi ema Jesús. Tiyananapa tisama­cacana nayehe ena políti­coana, machanerana ema Herodes, taicha navaraha nacapacaya ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Émasera ema Jesús tiyanapa téraji­cavapa eta te mávapahi apaquehe eta te tachausi eta cáquiure. Mámapa ena máimitureana. Náehicavare ena ichape­mu­ri­queneana achaneana ticava­sanahi eta te provincia Galilea. ");
INSERT INTO ignNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jéhesare, te nasamai­ri­ricapa eta máichaque­neanahi ema Jesús, títeca­panapa ena ichape­mu­ri­queneana achaneana. Tiásihanahi eta te avasare Jerusalén, eta te provincia Judea, eta provincia Idumea, eta provincia Siria, étapa eta avasareana te apachara eta cajacure Jordán. ");
INSERT INTO ignNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tásiha, ema Jesús mavanecapa ena máimitureana natsesi­nahini étasina pacure apaesa vahi nacutu­piaraca ena ichape­mu­ri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Taicha camuriana ena macana­ra­rua­napahi. Namutu ena nacaju­ma­queneana témeña­ha­va­napahi tiyumu­su­su­ji­ca­va­napahi eta náemeña­hai­ravaya, taicha navarahahi náemama­cayare. ");
INSERT INTO ignNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jéhesare, ena éreanana tiávahá­canahi ena achaneana, te náimahapa ema Jesús, tíaquipai­ca­vanapa te mamirahu éma. Tipiara­re­canapa: —¡Pítira Machicha ema Viya! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mavane­ca­pasera máecati­ha­vacapa nacuija nacume­taruina taicha vuíchaha mávara­hahini náimatihíni ena achaneana eta émaque­nérahi Machicha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tacahe, tiyanapa ema Jesús eta te mávapahi apaquehe máripahi. Mámamu­rihapa ena ánimuriana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tacahe, ánaqui manere­ji­ca­vacapa te nataracu ena dócequeneana mayehea­na­yarehi apóstoleana. Vaipa najuni­jia­caimahi éma, macacha­ne­yarehi tamutu sácheana. Matupa­ra­ca­vacapa eta nacame­ta­rai­rui­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Máijara­ca­vacapa ena dóceana eta narata­hai­ra­yarehi ticana­ra­recana ena nacaju­ma­queneana, náimiju­nai­ra­yareva ena éreanana tiávahá­canahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Eta juca náijareana ena manere­ji­rua­nahi: Ema Pedro (éma ticaija­revare Simón), ema Jacobo, ema maparape Juan, ema Andrés, ema Felipe, ema Bartolomé, ema Mateo, ema Tomás, ema apana Jacobo, ema Tadeo, ema apana Simón, émapa ema Júlasi Iscariote (ema tíjara­recahi ema Jesús). ");
INSERT INTO ignNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tacahe, tichavapa ema Jesús, énapa ena mayeheana apóstoleana te napena. Tiápecha­va­na­varepa tiúruji­cavana ena achaneana. Tásiha, vaipa náituji­ca­vahini tinicana taicha tétavi­cavahi eta nasimu­tuvahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Énasera ena mapara­pe­naveana ema Jesús, te nasamai­ri­ricapa, tiyananapa náepana­ya­rehini éma, taicha náimija­chaipahi máurishi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Éneri­chuvare natiarihipa ena escribá­noana, tiásihanahi te Jerusalén. Náepiyae­que­nehapa ema Jesús, ánipa nacahepa: —Ema maca Jesús, vémeteaca majupaha ema náquenu­murihi ena éreanana, émaripa ema Satanás. Táitusiava máijaracahi eta máitupa­ji­jia­si­ravahi eta macuchu­sirahi ena éreanana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tacahe, ema Jesús máichuha­vacapa ena ticaeca­hi­ra­hianahi. Eta máimitu­si­ra­vacahi, máimicu­ti­chinapa. Ánipa máichavaca: —Éti, téjeca­pavahi eta epane­reruana ímija­chanuhi majupa­hanuhi ema Satanás. Ímija­chapuca ticatia­na­ca­canahi ena éreanana. Váhisera énena tácahe. ");
INSERT INTO ignNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tacutihi ena machanerana ema gobierno. Éna, vahi típutsi­mu­ria­va­naimahi apinai­na­hi­pucaini partido. Te típutsi­mu­ria­vanapa, énaji­cacaini tiáquipai­cacana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Émaripa mácani achane te camurianahi ena machicha­naveana, váipari­ne­hivare típutsi­mu­ria­va­naimahi, náehaji­ri­ca­cahini, énaji­ca­cahini náquipai­ca­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ene macahehi ema Váinaraji Satanás, váiparine máisapahini típutsi­cacana ena machanerana, taicha mavarahahi tisimu­tua­na­yarehi éna, tímiya­na­va­yarehi eta nacaete­ma­ji­ri­si­ra­ha­vi­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Macutihi ema mácani achane tume. Te macara­tacahi eta mataquiriqui eta majanea­sirahi jácani macaye­he­queneana, nájina tiámeye­chaimahi. Tacamunuhi nacara­ta­ca­nu­mayare, náitiaca­nu­ma­yarehi ema túmequenehi achane. Jéhesare, náituru­ye­cha­sa­re­yarepa eta máimaha­queneana. Ene nucahehi núti, túmepa­nanuhi mayehe ema maca Satanás. ");
INSERT INTO ignNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Puiti nutupiruva numetacahe: Tiperdo­na­cha­ca­rea­nayare ena achaneana eta napeca­turana, tamutu jácani náechaji­sihaira eta táiñema­hi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jarari­hisera eta epecatura vahi tiperdo­na­cha­ca­remahi. Eti ímijachahi ema Satanás ema tiávahá­canuhi. Ichape eta éjeca­pi­ravahi, taicha ema tiávahá­canuhi nuti, émaquenehi ema Espíritu Santo. Éti epana­ra­ra­caripa éma. Tásiha, máitavacaca eta etapi­ra­vanaya —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tacahehi eta máechaji­ri­ruvahi taicha eta nacahe­cha­ji­ri­ru­vairahi: “Ema maca Jesús, majupaha ema Satanás”. ");
INSERT INTO ignNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Tacahe, te apanapa sache, tiúruji­ca­va­na­varepa ena camuri­queneana achaneana te tajuhe eta peti. Téjacanapa te machacaya ema Jesús. Títeca­panecha esu maena énapa ena mapara­pe­naveana. Nanasi­pasera te aneca taicha tiyutu­tu­ca­vanahi ena achaneana. Navarahahi náechaji­ca­yarehi éma. Tásiha, nametacapa ena apamuriana ema Jesús, ánipa naicha: —Esu pémuna­ru­quenehi pena, énapa ena pipara­pe­naveana nararihi ani te aneca. Navarahahi téchaji­caviana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Majicapapa éma: —Yátupi némuna­ca­vacahi esu meme, énapa ena nupara­pe­naveana. Narari­hisera ani te juca nuchacaya ena némuna­rua­na­hivare, nupara­pe­na­veanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tacahe, máeseni­mu­ríhapa ena máimitureana ena téjacanahi te machacaya. Tásiha, macahepa: —Ena nani ena némuna­rua­na­hivare. ");
INSERT INTO ignNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Taicha namutu nácani ticaema­ta­nea­canahi ema Tata, énahi ena némuna­ru­que­neanahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tacahe, te apanapa sache, tiápecha­vavare tímitureca ema Jesús te tachausi eta cáquiure. Tásiha, camuria­na­pa­hivare ena achaneana títeca­pau­chanahi éma. Eta navayu­chi­ra­varipa ena achaneana, ema Jesús tíavacuhapa tayehe eta pacure, tiápajue­cavapa apaesahi. Téjacapa eta máimitu­re­sirahi. Ena achaneana nanasipa tayehe eta te tachausi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Camuri eta máimicu­ti­cha­que­neanahi eta máimitu­si­ra­vacahi. Ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Esama­ra­ra­ca­nuchaha. Matiarihihi ema émana achane. Tévacahi te máesane. ");
INSERT INTO ignNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Eta mapaisi­rapahi, témiri­capaipa eta evaraqui te achene. Táimahapa eta cáyure, tanicapa. ");
INSERT INTO ignNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eta mayeherepi éma eta máevasira, máevaja­ja­pai­capaica eta apaquehe. Tásiha, eta apamuri evaraqui témiricapa te váhirichu tamitu­tuhini eta máteji taicha máripahi eta apaquehe. Tímaru­ca­va­ne­panéni táicha. ");
INSERT INTO ignNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Téhesera te tíjurepa eta sache, tacapa­jicapa; taicha vaipa táupare­va­cahíni. ");
INSERT INTO ignNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tacahe, eta apana evaraqui témiri­capaipa te tapare eta itapequiji. Tiúrina­hinéni eta táimarusira, étasera eta itape tacachu­ricapa eta tajuru­sirahi. Táemuriachapa eta sucureca. Tanasipa, vaipa tacahihini. ");
INSERT INTO ignNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tacahe, eta apamuri evaraqui témiri­capaipa te tiúrina máteji. Tijuru­ca­rahihi eta táimarusira. Ichape­murihi eta tahi. Eta étana, ticahipa apaesa­sa­ji­ruichucha. Eta apana, ticahipa tativa­re­re­ha­panapa. Eta apanavare, ticahivare tétupi­ca­va­panapa. ");
INSERT INTO ignNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Esama­ra­racanu emutu éti. Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tacahe, te najuni­jicapa ena apamuriana achaneana, témeña­ha­vanapa eta mayehe ema Jesús ena dócequeneana apóstoleana énapa ena apamuriana máimitureana. Nayase­recapa tájahapuca tacayemahi eta máimicu­tia­ra­chi­ra­va­caichucha eta máimitu­si­ra­vacahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tacahe, majicapapa éma: —Ema Tata titupa­ra­canuhi nítame­ta­ca­heyare éti eta juca mapane­reruana táequene­reruana tayehe eta macuchu­cui­ra­heyare eti achaneana. Mavarahahi ímatie­que­nehaya éti. ");
INSERT INTO ignNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Énasera ena apamuriana achaneana nímicu­tia­ra­chi­na­va­caichucha, apaesa vahi máejera­rémahi eta nacaicu­tia­rairaya eta nasama­quenehi. Tavaraha napane­re­chi­navaya. Eta nacaicu­tia­rairaya, náitsiva­chahini eta náitaresira, apaesa naperdo­na­cha­ca­repaini —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Éneri­chuvare máichavarepa: —Éti, ¿vuíchaha íturue­queneha eta juca nímicu­ti­cha­quenehi? Tavaraha eta epane­re­chi­navaya éti apanava apaesa íturue­queneha eta apamuriana nímicu­ti­cha­que­neanahi. Tiuri, numetacahe: ");
INSERT INTO ignNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Eta evaraqui eta máevaruhi ema achane tacutihi eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Natiarihi ena achaneana nacuti eta apaquehe muracapahi te achene, te táemiri­sihahi eta evaraqui. Ena nani nasama­ra­racahi eta nímitu­rapiana. Émasera ema Satanás macami­ti­si­ca­vanepa eta nasama­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Natiari­hivare ena apamuriana achaneana, nacutihi eta máteji máripahi. Te nasama­raraca eta nímitu­rapiana, natupi­ru­va­ne­hinéni nasuapa, tiúrisa­mu­rea­nainehi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Váhisera nárata­hahini nacara­va­huhini yátupi­nahíni. Vahi nácutihíni eta evaraqui tiúparehi. Ánipirichu eta náehisirahi, taicha vahi nacami­chahini jácani nacata­ji­vai­ranahi. Váhivare túmesa­mu­rea­nai­nahini te tatiarihipa eta jácani nacatichaira ena achaneana táichavenehi eta náehisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Natiari­hivare ena apamuriana achaneana nacuti eta máteji te távihahi eta itapequiji. Éneri­chuvare nasama­ra­ra­ca­hinéni eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Napane­ré­que­ne­ha­hinéni, tahapa­pi­ri­ca­va­ca­hisera eta jácani táichara­ca­vayare eta náitaresira. Tavayua­ca­va­cavare eta tájipa­racana, najamu­rachahi tamutu. Tahapa­pi­ri­cavare eta navarairahi tirricu­chavana. Tamutu eta juca táemeta­vicahi eta navarairahi téhicanuana. Tamapu­rujihi eta najaca­pirahi eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Natiari­hisera ena apamuriana achaneana nacuti eta tiúrina máteji. Éna, nasama­ra­racahi náunacahi yátupi eta nímitu­rapiana. Tájinavare náichira­vai­nahíni eta náehisi­ranuhi. Ichape eta nacaema­ta­nea­sirahi ema Viya. Nararihi ena apaesarichu eta nacaema­ta­nea­sirahi. Narari­hivare ena apamuriana, nativa­re­re­ha­panapa eta nacaema­ta­nea­sirahi. Tásiha, ena apamuriana, ichape­mu­ri­panapa eta nacaema­ta­nea­sirahi ema Viya —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tímiyanava eta máimitu­re­sirahi, ánipa macahe: —Te viyustaca eta vimícahu, váiparinehi táuricaimahi vijiha­pai­cahini, vinaca­hi­va­re­pucaini te tápecu eta vétsatsame vímasi­rarehi. Tacamunuhi vinaca­yarehi te anuquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jéhesare, tayana­pa­nepuca nacayu­muruqui, tamutu­ya­re­hisera ticaechera jácani tayumu­ru­re­vanahi. Tájina tépacu­chaimahi jácani najajai­ru­vanahi. Tamutu­yarehi téchacareya. ");
INSERT INTO ignNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya. ");
INSERT INTO ignNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Máichavarepa: —Tacamu­nuvare epanerecha yátupina eta esama­queneana. Te apaesa­richuhi eta epane­re­chirahi, apaesa­ri­chuvare eta ecaicu­tia­rairaya. Te esuapa yátupina eta nímitu­rapiana, ema Espíritu Santo tímitu­caheya tamutu eta tacaye­ma­quenehi. Jéhevare, tímitu­ca­heyare éma eta apamuriana yátupi­que­neanahi. Énasera nácani vahi návara­hahini napanerecha, váhivare nasuapa, énaji­vayare tíchavana ticave­re­ji­ca­sianaya eta nasama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Máichava­ca­varepa: —Nuvaraha nímicu­ti­chinahe eta nímitu­rapiana nuti Manere­ji­ru­nuhi ema Viya. Te yátupihi eta nasuapirahi eta nímitu­rapiana ena achaneana, náitsiva­chainapa arairuinapa eta napane­reruana étapa eta nayehe­re­pianaya eta náitaresira. Tacutihi eta máevaraqui mácani achane. Tévacahi te máesane. Tásiha, tinaracapa, macucha­pa­yarepa eta tacahi­rayare eta máevaraqui. ");
INSERT INTO ignNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tímarucapa eta evaraquiana. Tijuru­cavare. Ema achane, tájina macaicu­tia­rahini eta táimaru­sirahi. Váhivare macaicu­tia­rahini eta tajuru­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Taicha eta apaquehe, éta ticaima­rucahi. Tacuchucahi tativa eta tapacaji, táehicapa eta tanaqui. Te ticahipa, tiúchucapa eta tapiraqui. ");
INSERT INTO ignNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te tiyahapa eta tahi, ticaecha­tijipa te tumare, taicha étainapa eta tacave­ha­siraya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ánivare macahe: —Puiti nuti Manere­ji­ru­nuhi ema Viya, nímicu­ti­chinahe eta ichape­mu­rivaya eti íjara­ca­vanahi éhicanu. ");
INSERT INTO ignNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ecutiya eta ánichi­chaquene taqui eta sucureca ticaijare mostaza. Éta juca, ániqui­ti­ta­va­capana eta taqui te tamutu eta evaraquiana tatiari­hi­que­neanahi tayehe eta juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Téhesera te ticaevapa, tijurucapa eta tiápaju­cavahi ichapepana tayehe eta apamuriana sucurecana. Tatiarihi eta ichape­ta­vavaca. Tásiha, tacape­na­jicapa eta cáyureana —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ani tacahe tamutu eta máimitu­si­ra­vacahi ena achaneana. Camuriana eta máimicu­ti­cha­que­neanahi. Tamutuhi ticaicu­tia­ra­ca­revaca nayehe ena tivara­hanahi náiturue­queneha. ");
INSERT INTO ignNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tájina étahena te tímitureca, vahi macuna­cahini eta máimicu­tichira. Téhesera te macarichupa ema Jesús énapa ena máimitureana, máimicae­che­rachapa tamutu eta máimicu­ti­chi­na­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Tacahe, te jena sache, eta máejasirahi ema Jesús te pacure, tímitu­recahi. Te cápere­hi­chichapa, máichapa ema Jesús ena máimitureana: —Viyanaya viánueca te apachara —máichavacapa. Tacahe, ticame­ta­vanapa nayehe ena achaneana. Tásiha, námapa ema Jesús eta te pacure. Náehicapa ena apamuriana te pacure eta napaisi­rapahi. ");
INSERT INTO ignNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te ítupie­re­canapa, tachima­racapa eta muraca técaticava. Tépacucapa ichape eta cáquiure. Tisiapa­paipahi eta une tayehe eta pacure. Tiánehi­paipahi tacaeri­cavaca. ");
INSERT INTO ignNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Émasera ema Jesús, tímaca­paichucha te tahivu eta pacure te machunusi. Tásiha, nacaja­micapa éma. Ánipa náicha: —¡Tata maestro! ¡Picatiu­chahavi, véricainapa! ¿Váhipuca péñamava eta viyehe? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tásiha, enurujipa téchepuca éma. Titupihapa. Mavanecapa eta técaticava étapa eta une. Ánipa macahe: —¡Pámatina, pésami­ricava! —máichapa. Tacahe, tíchecapa eta técaticava. Tésami­ri­cavapa eta une. Tésami­rie­cavapa tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tacahe, máichavacapa ena máimitureana: —¿Tájaha tacayema epica? ¿Váhipuca ecasi­ña­vahini eta nutiari­hi­rapahi eta eyehe? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ena máimitureana, tétavi­ca­vainehi eta náramirahi. Tiyase­re­ca­canapa, ánipa nacahe: —¡Tétavi­cavapa eta máitupa­ji­jia­si­ravahi ema maca vimaestro! ¡Jéhesare, yátupiquene eta émairahi machichahi ema Viya! ¡Taicha tamutu tasuapahi, macama­ti­nacahi eta técaticava étapa eta une eta táepacu­sirahi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Títeca­panapa te apachara eta cáquiure eta te apaquehe ticaijare Gadara. ");
INSERT INTO ignNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ánaqui tatiarihi eta ecariana. Tacahe, te tiúcupaicapa ema Jesús eta te pacure, tiúchuji­ca­vanepa ema émana achane návaháruhi ena éreanana. ");
INSERT INTO ignNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Éma másihapahi eta te ecari, taicha macape­na­jue­cha­vacahi eta covachana. Nájina nárata­hahini náitiacahini éma. Étaripa eta ichapepi cadena, vahi tárata­hahini. ");
INSERT INTO ignNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Taicha máejeharipa nacarataca. Náitiji­vauchahi te cadena. Nanacavare eta grillo te mapiqui. Émasera mavena­ru­rujica eta cadena, mavena­ru­cavare eta mayehe grillo. Jéhesare, nájina narata­hahini namansu­chahini ema maca achane. ");
INSERT INTO ignNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Eta máitare­sirahi, eta mávirarehi tayehe eta ecari étapa eta mávapahi te anuqueheana mari. Tamutu sácheana, yátiana, tipiara­re­recahi éma. Tijarachava te márijahiana. ");
INSERT INTO ignNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tacahe, tiyere­hi­paichaha máimahapa ema Jesús, tijunapapa mapauchapa. Máepuyu­mi­rauchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ema Jesús, eta máimairahi ema achane, máichapa: —¡Pijunijica ema maca achane, piti éreana! —máichapa. Tipiara­recapa muraca eta majica­pirahi ema achane. Ánipa macahe: —¿Tájaha picha píteca pipauchanu, piti Jesús, Machicha­que­nevihi ema Viya? ¡Pájapanunu, vuíchaha picuva­necanu ánaqui te nucaicu­ñai­yayare! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tacahe, ema Jesús mayase­recapa ema éreana. Ánipa maicha: —¿Tájaha píjare píti? Majicapapa éma: —Núti nucaijare “Nacape­naharu ena ichape­mu­ri­queneana éreanana”. Jéhesarehi, ichape­mu­ri­havihi víti. ");
INSERT INTO ignNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","¡Pájapa­nu­ha­visera! Te piáquiji­ca­ha­vi­ya­repuca, ¡vahi picueva­ta­cahavi viyanaya te tiyerehi! —nacahepa ena éreanana tiávahá­canahi ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tiuri puiti, tatiari­hi­hivare eta camuri­que­neanahi cúchiana. Tinihi­canahi ánaqui te táemiri­paisine eta masihi. ");
INSERT INTO ignNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tacahe, ena éreanana tiyaseu­cha­vanapa mayehe ema Jesús. Ánipa nacahe: —¡Picata­ji­cahavi! Pévata­cahavi eta te távihahi eta jena cúchiana. Písapahavi visiapa­ha­cavaca eta jénana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tacahe, ema Jesús macuchu­chu­ji­ca­vacapa eta te máquehe ema achane, máisapapa nasiapa­ha­cavaca eta cúchiana. Tatiarihi cútimahi apina mil eta cúchiana. Tacahe, te tasamapa eta cúchiana eta nasiapa­ha­si­ra­vacahi ena éreanana, tijuna­pa­ra­canapa témiri­ri­ji­canapa te tachausi eta cáquiure. Tériri­ji­canapa tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Natiari­hi­hisera ena tijanea­ca­nainihi eta cúchiana. Te náimahapa, tiárame­ca­na­rinehi. Tiyananapa tijuna­pa­napaipa, timeta­ji­ri­ca­napaipa nácani nácapa­ji­ru­va­napahi, étapa te avasare namutuvare nametaca. Tiárami­ca­réinehi nayehe ena achaneana. Tiyananapa náimahapana tájahapuca eta táichava­que­nevahi eta cúchiana. ");
INSERT INTO ignNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te títeca­panapa, náimahapa ema achane návahá­ruinihi ena éreanana. Téjaca­ripahi te máivape­chacaya ema Jesús. Tájina­ripahi máichira­vai­nahini. Ticamui­ri­hai­pa­hivare. Tásihasera, tipica­na­rinehi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tavetijipa te náitame­tacapa ena tímahanahi eta táichava­que­nevahi eta cúchiana te macuchu­chu­ji­ca­vacapa ena éreanana ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tacahe, nayaseacapa ema Jesús váhini macuite­ca­pau­cha­vacaini tayehe eta návasahi éna, machava­va­nehini te másinehi. ");
INSERT INTO ignNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tacahe, te tiávacu­ha­yarepa ema Jesús, ema achane manararuhi tiyase­se­recapa eta mavarairapa máehica ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Émasera, vahi máisapahini. Ánipa maicha: —Piyanachucha pichava nayehe ena pijaneanana te piávasa. Pimetacaya eta macana­ra­si­ravihi ema Viya taicha eta majapa­nui­ravihi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tacahe, tiyanapa tichava ema achane. Timeta­ji­ri­ca­pai­pasera mameta­ca­va­capaipa eta máichaquenehi ema Jesús mayehe. Náraminehi namutu ena ticava­sanahi eta te provincia ticaijare Decápolis. ");
INSERT INTO ignNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tiuri, tichava­varepa tiánueca ema Jesús te apachara. Te títecapapa, náurujia­ca­vanepa ena ichape­mu­ri­queneana achaneana te mávinehi te tachausi eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tacahe, títecapapa ema émana achane ticaijare Jairo. Ema maca achane, tétavi­cavahi eta mapicau­cha­ca­revahi. Tuparai­rucahi tayehe eta náuruji­si­rareva. Te máiteca­pauchapa, tépuyucapa te mamirahu ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mayaseacapa, ánipa máichapa: —Tátachicha, surarihi esu nuchichasami, ticajumahi. Puiti téñama­ji­ri­cavaipa ésu. Picata­ji­ca­nupaini, tata. Pinasinanu eta pivahuana suyehe apaesa sunaraca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tacahe, masuapapa ema Jesús. Tiyanapa máehicahi ema achane. Náehica­varepa ena camuri­queneana achaneana. Náevata­ji­ri­canecha éma. ");
INSERT INTO ignNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tásiha, te nataracu sutiari­hi­pa­hivare esu esena sucaju­ma­quenehi. Doce áñoripahi eta sucaju­mairahi táichirahi eta suítine. ");
INSERT INTO ignNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ichaperipa eta sucata­ji­vairahi taicha camuria­naripa ena típuchanahi médicoana. Títaharipa eta suímaha­que­nea­nainihi. Tájinasera vahi suátiva­rehini. Suávira­pa­ra­sia­vaichuhi suvayu­ha­paichucha eta sujuma. ");
INSERT INTO ignNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ésu, sutanu­ca­paipahi ema Jesús, susamai­ri­ricahi eta tiárami­careana máichaque­neanahi. Supauchapa suéhique­cu­cha­paipahi te maquecu. ");
INSERT INTO ignNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Taicha tacahehi eta supane­reruhi: “Tarata­chuchaini némama­jia­cahini eta ñimuiriha, németeaca nunara­ca­pa­pucaini”, sucahe­sa­murepa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tacahe, suémama­jiacapa eta tacheyarapi eta mamuiriha. Jéhesa­réinehi, enurujipa tícheca eta suítine. Tisamavapa ésu eta sunara­si­raipahi tayehe eta sujumainihi. ");
INSERT INTO ignNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Émasera ema Jesús macaicu­tia­ra­vanepa eta sutiari­hirahi esu tacana­raruhi eta máitupa­ji­jia­si­ravahi. Enurujipa téviuru­cavahi te namuri ena ichape­mu­ri­queneana achaneana. Ánipa macahe: —¿Nájaha témama­jia­ca­nuanahi? ");
INSERT INTO ignNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tacahe, ena máimitureana náichapa: —Tata, téñatu­he­ji­ri­ca­canahi namutu eta achaneana taicha ichape eta nasimu­tuvahi. Piyase­re­ca­ha­vi­ri­chahava nájahapuca ena témama­jia­ca­vianahi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Émasera ema Jesús máeseni­mu­rihapa, matanucapa nájahapuca ena témama­jia­canahi. ");
INSERT INTO ignNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tásiha, supauchapa esu esena. Tiyaya­ca­repaipa taicha tipica­ripahi. Taichasuéchahi eta suíchaquenehi ésu. Suépuyu­mi­rau­cha­vanepa te mamirahu. Sumetacapa tamutu. ");
INSERT INTO ignNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tásiha, máichapa ema Jesús: —Tiuri, nuchicha. Pinaracapa puiti táichavenehi eta picasi­ñai­ranuhi. Vaipa picueñamava eta pichaviraya te pipena. Vaipa tichavaimahi eta pijumainihi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Téchaji­ri­ca­vai­chahahi ema Jesús eta suyehe esu esena, títeca­pa­nanecha ena tiásihanahi te mapena ema Jairo. Nameta­ca­vanepa: —Esu pichicha tépena­sa­mipahi. Vaipa picucamesa ema Maestro —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Émasera ema Jesús vahi masuapahini eta nameta­sirahi. Mavara­haichucha tiyana. Tacahe, máichapa: —Vahi picueñamava, piti Jairo. Pácasi­ña­vachucha eta nuyehe —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tacahe, ema Jesús vaipa máisapahini náehica ena apamuriana achaneana. Nacarinepa ema Pedro, ema Jacobo, émapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te títeca­panapa te mapena ema Jairo, máimahapa ema Jesús ena achaneana vaipa náituca­ca­ra­hahíni, tijaja­mu­ria­na­ripahi eta náiyairahi. Tipiara­re­ca­na­ripahi muraca. ");
INSERT INTO ignNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Émasera ema Jesús eta masiapirahi, máichavacapa: —¿Tájaha tacayema eta iúruji­ri­cavahi eta ani, íyaha­ra­cavapa? Vahi ecuiyaha. Esu suca amaperu, váhinéni suépenahini. Tímaca­richucha ésu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Énasera ena achaneana nacaeca­hi­richucha éma, técavanapa. Tacahe, ema Jesús macuchu­ca­vacapa te aneca namutu. Tacahe, tisiapapa te suávihahi esu amaperu, émapa ema suiya, ésupa esu suena, énapa ena mapanana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tacahe, macara­ta­vauchapa ésu. Máichapa: —Nuchicha, néchajicavi. Péjamica, péchepuca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Enurujipa esu amaperu téjamicapa, téchepuca. Tipaicapa te namirahu. Ichape­rinehi eta náramirahi ena tímahanahi. Tásiha, ema Jesús mavane­ca­vacapa náijaraca eta sunica esu amaperu. Matupa­ra­ca­varepa muraca eta vahi nacuecha­jisiha eta náimaha­quenehi. Esu amaperu, dóceripahi eta suhañora. Tacahe, tiyanapa ema Jesús. Tichavapa te mapena. ");
INSERT INTO ignNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tacahe, te apanapa sache, tiyana­varepa tipaica. Tichavapa tayehe eta mávasa Nazaret, mámamu­ri­hapaipa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Tacahe, te jena sache sávaru­mu­huquene, tiyanapa tayehe eta náuruji­si­rareva nayuja­ra­sirare ena achaneana. Tímitu­recapa. Camuriana ena tisama­ra­ra­canahi. Ichape eta tahapa­sa­mu­re­chi­ra­vacahi ena achaneana. Váhisera návara­hahini nasuapahini. Náepuru­richucha éma. Ánipa nacahe: —¿Távihapuca mavínehi eta júcana máimitu­ra­pia­na­hicacha ema máca? ¡Témuna­hi­ri­cavapa títupa­ji­jia­ca­vai­pa­hí­jicacha! ¿Távihasica macara­va­huinehi eta máichirayare eta tiárami­careana? Vivaraha vímaha víti apanava eta máichaque­nea­nahíji visamai­ri­ri­ruanahi. Taicha vímatihi ema maca. Carpinté­rochucha éma. Vímati­hivare esu maena María. Vímati­hivare ema maparape Jacobo, émapa ema José, émapa ema Judas, émapa ema Simón. Vímati­hivare ena esenana mapara­pe­na­veanahi, ticava­sanahi ani —náichacacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ema Jesús máimatihi eta napane­re­ruanahi. Tásiha, máichavacapa: —Tatuparaca epicau­cha­haviya vimutu viti mavaneruana ema Viya. Étisera eti nujanea­nanahi ecava­sanahi eta te juca viávasa, étipa eti nupara­pe­naveana, vahi epicau­cha­nuhini —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Éma, ichape eta máramirahi eta namasua­pa­ji­raivahi éna. Eta tacahe, tájina máimere­ca­hichaini eta tiárami­ careana. Tacarichu eta macana­ra­sirahi ena nacaju­ma­queneana eta máemama­ma­há­si­ra­vacahi te mavahuana. Vahi camuria­nai­nahíni ena macana­ra­ruanahi. Tacahe, ema Jesús tiyanapa mapaicahi eta avasareana máimitu­ca­va­capaipa ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Étana sache, macuru­ji­mu­rihapa ena dócequeneana mayeheana apóstoleana. Tacahe, máijara­ca­vacapa eta náitupa­ji­jia­si­ra­vayare narata­hai­rayare náquijica ena éreanana. Tacahe, mavanecapa tiyanana eta te apana­paneana avasareana, apina­na­ya­repahi eta napaisi­ra­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Matupa­racapa, ánipa máichavaca: —Tájina iámaimahi eta eyere­ruvana eta epaisiraya. Váhivare ecuama eta eniru­rucuha te alforja, étapa eta plata. ");
INSERT INTO ignNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Étana­ri­chuvare iámayare eta emuiriha. Tacarichu iámaya eta eyupairiqui. Ecaepa­ru­pe­va­ya­resera. ");
INSERT INTO ignNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te ítecapapa tayehe eta jácani peti íteca­pihaya te jácani avasare, ánasi tayehe. Te iúchuca­yarepa eta te jena avasare, epaenumava ejunijica eta íteca­pihahi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te váhipuca nacuja­capahe te jácani avasare, váhivare nacuvaraha nacusamahe, iúchuca­va­neyare. Étata­pe­va­cha­va­nu­ma­ya­resera eta máteji te ívapeana. Táicutia­rayare eta máicuña­si­ra­va­cayare ema Viya taicha eta namava­rairahi najaca­pa­hehini. Nutupiruva numetacahe, te táitecapa eta juicio, tiápaju­ca­vainapa eta náicuñayare. Tacachu­ri­cayare eta nacaicu­ñai­rayare ena achaneana váinara­ji­queneana ticava­sanaini te Sodoma étapa eta Gomorra —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tacahe, tiyananapa ena dóceana. Ticame­ta­rairuana eta tacamu­nui­ra­yarehi eta náeneuchi­ravaya ena achaneana, náinajica eta napeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Náimiju­na­va­capaipa ena éreanana tiávahá­canahi ena achaneana. Camuria­na­hivare ena nacana­raruana tayehe eta najumanaini, nacapa­ja­si­si­rapahi te nachuti eta aceite. ");
INSERT INTO ignNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tacahe, ema Herodes ema aquenucahi tayehe eta Galilea masamai­ri­ri­ca­varepa eta máichaque­neanahi ema Jesús, taicha náechaji­sihahi namutu ena achaneana. Nararihi ena téjeca­pa­vanahi eta napane­reruana, ánipa nacahe: —Ema maca Jesús, ¿váhipuca émaina ema Juan Tícacha­si­rí­ca­rahíni macaparuhi ema Herodes? Tichava­hi­chupuca títareca. Étapuca tacahehi puiti maratahahi maicha eta tiárami­careana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Narari­hisera ena apamuriana nacahepa: —Émapuca ema víyarahaini profeta Elías, téchepucahi. Ena apamuriana nacahepa: —Émarichuhi profeta, macuti­quenehi ena náinapu­reanáini antivuanaini. Váhisera téchepu­caimahi éma —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Émasera ema Herodes, eta masamai­ri­ri­sirahi, macahepa: —Németeacahi ema maca émaripa ema Juan, ema nímiyu­cha­ti­pi­que­nurehi, téchepu­ca­hipuca te máecari —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Eta macapa­sirahi ema Herodes ema Juan, ani tacahe eta táichara­ra­cavahi: Te jena año, ema Herodes mavehahi esu Herodías, esu machinenahi, mayenahi ema maparape Felipe. Máimina­jicapa ema suima. Tacahe, ema Juan macaja­cha­vacapa éna eta navira­ca­cairahi. Étapa tímica­tichahi ema Juan, sucatichapa esu Herodías. Tásiha, ema Herodes máeratacapa te cárcel ema Juan, macava­nai­ripipa náitiaca te carenapi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Esu Herodías, tétavicava eta sucati­chirahi ema Juan. Suvarahahi sucapaca éma. ");
INSERT INTO ignNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Váhisera surata­hahini, taicha matsiri­hacahi mapicauchahi ema Herodes ema Juan, taicha máechahi tétavicava eta máurivahi ema Juan. Máimati­hivare eta mavaneruhi ema Viya. Eta tacahehi, macatiuchahi éma apaesa tacuija suícharaca ésu. Táitusiava, ema Herodes máuricapa masama­ra­racahi eta máimitu­rapiana ema Juan; váhisera máiturue­que­ne­hahini tájahapuca máichara­ra­ca­va­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tacahe, eta te jena yati ticaija­re­muhupa ema Herodes, sucama­purapa esu Herodías eta máepiya­sirahi eta ichape piesta ema Herodes. Máichuhapa ena máevanachana énapa ena oficiáleana, énapa ena ticaima­ha­queneana ticava­sanahi tayehe eta Galilea. ");
INSERT INTO ignNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te tinicanapa téranapa, esu suchicha esu Herodías tisiapapa eta te návihahi ena achaneana. Esena­chi­charipa ésu. Tírimaicapa te namirahu. Ema Herodes máuricainehi ichape, énapa ena machimarana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tacahe, ema Herodes máichapa ésu: —Nujuracha te pimirahu. Piyaseacanu tájahapuca eta pivara­ha­quenéna. Núti níjara­ca­viyare jácani piyasea­ru­nuyare, tayanapane vácuticaca eta nímaha­queneana —máichapa ésu. ");
INSERT INTO ignNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tacahe, tiyanapa tiúchucapa esu amaperu. Suyase­re­panapa esu suena, ánipa suícha: —¿Tájahapuca eta nuyaseacaini eñi ñina Herodes? —sucahepa. Tásiha, suíchapa esu suena: —Píyaseacaya eta ñichuti eñi Juan, puítinarichu ñíjaracavi —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Enurujipa tichava tisiapa esu amaperu eta te mávihahi ema aquenuca Herodes. Suyaseacapa éma, ánipa suicha: —Nuvaraha píjaracanu puítinarichu eta ñichuti eñi Juan eñi tícacha­si­ri­carahi. Píjaracanu te curuja —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tásiha, eta masamirahi eta juca suyasearuhi ema rey Herodes, ichape­rinehi eta mapane­re­re­sirahi. Váhisera mávara­hahini mavayua­cahini ésu táicha nasama­ripahi ena machimarana eta máijara­si­ra­yarehi eta suyasea­ru­yarehi ésu. ");
INSERT INTO ignNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Tacahe, enurujipa mavaneca ema suntaru eta te cárcel. Mayucha­ti­pi­que­nu­hapana ema Juan. Tacahe, mámapaipahi eta machutini te curuja. Máijaracapa esu esena amaperu. Tásiha, suíjara­panapa esu suena. ");
INSERT INTO ignNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te nasamai­ri­ricapa ena máimitureana ema Juan, tiyananapa náepanapa eta máquehéni, náecara­panapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tacahe, tichavanapa tiúruji­cavana ena apóstoleana mayehe ema Jesús. Nametacapa tamutu eta náichaque­nea­napahi étapa eta najaca­pirahi ena achaneana eta náimitu­ra­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tacahe, máichavacapa ema Jesús: —Tiuri. Tájina táichava. Puiti viyana vácarichu eta te mávapahi apaesa vinaraca ánipina —máichavacapa. Taicha vahi téjiacavana ena achaneana. Tévacha­ji­ri­ca­canahi tiyanana. Vahi náituji­ca­vahini nanica­nu­mahini ena apóstoleana émapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tacahe, tiyananapa te pacure, tiávacu­hanapa. Nacaijuhepa te mávapahi apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Énasera ena achaneana naneca­paichucha eta nayanirahi. Camurianahi ena tímatianahi. Tacahe, tiyananapa tijuna­pa­napaipa, nameta­pa­na­yarehi ena apamuriana achaneana. Tásiha, tiúruji­ca­vanapa ena tiásihana te tamutu avasareana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te tiúcupaicapa ema Jesús, máimahapa ena camuri­queneana achaneana natiari­hi­ripahi. Tétavi­ca­vainehi eta majapa­nui­ra­vacahi, taicha nacutihi eta uvesana nájina tijaneacaina. Tacahe, máimitu­mu­ri­haripa. Camuri eta máimitu­rapiana. Tiuna eta máimitu­si­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te cáperehipa, ena máimitureana napauchapa éma. Náichapa: —Cáperehipa juca sache. Tiyere­hi­vacahi eta pétiana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tacahe, táuricapa pimeta­cavaca ena achaneana nayanapa, navachareca eta nanica te jácani isanitiana, avasa­re­chi­cha­napuca te vichaca­ya­ra­hanahi. Taicha ani, tájina naviyaimahi eta nanicahini —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Majica­pa­pasera éma: —Íjaraca étina eta nanica. Éna náichavare: —¿Pivara­hapuca viyana vivachareca eta pan? Tacamunuhi vácaye­hehini eta camuri plata apaesa námutupaini vítapa­ra­hahini vénicahini apaesai­nahini návami­nahini. ¡Vahi tarata­hahini eta dies mil páneana! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tacahe, mayase­recapa ema Jesús: —¿Áyana eta pan ecayehe puiti? Eyana ímaha. Te náechapa, nametacapa: —Cíncochichaichu eta pan, apiquipa eta jima jitaruca —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tacahe, macava­nai­ripipa náejaha­ha­ca­pai­cahini namutu te muíjipahi, náijamu­ri­paichuhi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tacahe, téjaha­pai­canapa ena achaneana. Náijamu­ri­paichuhi eta náejasirahi. Cincuenta­napahi, ciéntoanapahi. ");
INSERT INTO ignNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tacahe, ema Jesús mavehapa eta cíncoquene pan étapa eta apiqui jima. Máesenicapa eta te anuma. Mahasu­lu­pa­yachapa ema Viya. Mayuve­tu­tu­jicapa eta pan, tásiha máijaracapa ena apóstoleana. Éna, náijaracapa ena achaneana. Éneri­chuvare mayuve­tu­tu­he­si­navare eta apiqui jima. Tisimu­ri­va­capaipa eta náijaraca. ");
INSERT INTO ignNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tacahe, námutu tinicana, tisatueanapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tásiha, nacaema­cha­ri­cha­havare eta doce saye ichapehiana táinica­cha­va­cai­chahava eta náemacha­rajiana eta pan étapa eta jima. ");
INSERT INTO ignNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Camuriana ena máeniruanahi. Te nataracu, natiarihihi ena cinco mílqueneana ajairana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te tamutupa, enevanepa mavanecahi ema Jesús tiávacuhana eta te pacure ena máimitureana. Tínapu­ca­na­yarehi tiánuecana te apachara eta te avasare Betsaida. Émasera ema Jesús manasi­yarehi máevata­mu­ri­ha­nu­ma­yarehi ena achaneana. Tásiha, tiyananapa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tacahe, te tamutupa eta macame­ta­vairahi ema Jesús nayehe ena achaneana, tiyanapa tiápanahi tayehe eta anuquehe mari. Tiyuja­ra­ca­yarehi tayehe. ");
INSERT INTO ignNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tacahe, te tiúyatipa jena yati, ema Jesús manasi­richaha macarichuhi eta te anuquehe mari. Ena máimitureana itupie­re­canaipa tayehe eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tásiha, tachima­ra­ca­vacapa eta muraca técaticava, nácapa­qui­ha­paipahi. Te tijara­rahipa, ema Jesús máimahapa eta nanausi­rapahi muraca. Tacahe, tiyanapa macapa­ya­muriha. Mapaicae­capaipa eta une. Máetavi­ca­va­ca­pai­pasera. ");
INSERT INTO ignNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Éna máimitureana tipica­na­rinehi eta náimairahi eta mapaicae­si­rapahi eta une, náimija­chaipahi cunare. ");
INSERT INTO ignNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tipiara­re­canapa namutu eta náimairahi. Máechaji­ca­va­ne­pasera éma. Ánipa maicha: —Vahi ecupica. Nútichucha. Étumechava —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tacahe, mapauchapa éna. Tiávacuhapa nayehe. Tacahe, tíjahú­chavapa tíchecapa eta técaticava. Nárami­rinehi ichape ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Taicha vuíchaha nacaicu­tia­rahini eta tacaye­ma­quenehi eta macaeja­pa­sirahi eta pan, eta táimereu­chirahi éma eta vanairu­cairahi me Viya. Muraca­sa­mu­re­mu­ria­na­richaha. ");
INSERT INTO ignNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tacahe, te apanapa sache, tiápecha­va­na­varepa tiánuecana eta cáquiure. Títeca­panapa eta te avasare ticaijare Genesaret. ");
INSERT INTO ignNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te tiúcupai­canapa, náitiacapa eta napacure. Ena natiari­hi­que­neanahi náimati­vanepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tásiha, tiyananapa tijunapana timeta­ji­ri­ca­na­yarehi tayehe tamutu eta avasa­re­chichana tachaca­ya­ra­hanahi. Tacahe, tiúruji­ca­va­napahi ena achaneana te jácani máiteca­pi­hapahi ema Jesús. Námava­ca­paipahi eta te áchuji ena nacaju­ma­queneana. ");
INSERT INTO ignNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Éneri­chuvare, te jácani mayani­hapahi te acheneana téhepuca cálleana, nanaqui­pai­capahi ena nacaju­ma­queneana. Tacahe, nayasea­capahi éma máisapi­rai­nahíni náemamajiaca eta tacheyarapi eta mamuiriha. Tacahe, nácani témama­jia­ca­napahi, eneva­nepaipa tinara­ca­napahi. ");
INSERT INTO ignNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tiuri, te apanapa sache, náiteca­pauchapa ena apamuriana fariséoana énapa ena escribá­noana, tiásihanahi tayehe eta Jerusalén. Témeña­ha­vanapa eta mayehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te nataracu ena máimitureana ema Jesús, nararihi éna vahi nacasi­pa­va­hu­nu­mahini eta nanisirahi. Tacahe, ena fariséoana, eta náimairahi eta namaitau­chirahi eta nayehe­repihi, ichape­rinehi eta nasema­nevahi, taicha náimija­rechahi “máeperaji” eta juca. ");
INSERT INTO ignNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Taicha namutu ena israelítana, napicauchahi eta nayehe­repiana ena náchuca­na­veanaini, navetijipa ena fariséoana. Te vahi ticasi­pa­va­hu­nu­manahi, váhivare náisapaimahi tinicana. Taicha éna vahi návaraha tánasihíni eta tachipe­jihini ánichi­chai­nahini, taicha tipicanahi tamaepe­ra­ji­cahini eta náchanevana. ");
INSERT INTO ignNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Étaripa násiha­pa­hipuca te mercado, te plázapuca, te títeca­panapa te napena, ticasi­pa­va­hua­na­yarehi. Mavera eta apamuri nayehe­re­pianahi tipicau­cha­ca­reanahi nayehe, étaripa eta nasipa­si­ra­paraca eta náereresiana, étapa eta jarra, étapa eta návacu­ruhiana étapa eta catre náimasirare. ");
INSERT INTO ignNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tacahe, nacajachapa ema Jesús ena fariséoana énapa ena escribánoana. Ánipa náicha: —Pímaha. Ena pímitureana vahi náitauchahini eta viyeherepi. Namaepe­ra­jicapa eta náchanevana eta nanisirahi taicha vahi nacasi­pa­va­hu­nu­mahini. ¿Tájaha tacayema vahi napicau­chahini eta viyeherepi nanaquiruhi ena viáchuca­na­veanaini? ¿Étase­rapuca tacahehi eta pímitu­si­ra­vacahi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tacahe, majicapapa ema Jesús, ánipa maicha: —¡Éti ecaijarehi apimirahe! Tatupi­ruvahi eta máechaji­ri­ruvahi ema Viya, téchaji­siahehi éti eta te Sagrada Escritura. Ánipa macahe: “Ena nani achaneana, tétsera­ji­ca­nuanahi te najaca; váhisera táetupi­ca­vahini te nasamureana. ");
INSERT INTO ignNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Téneucha­vanahi eta nuyehe, tamapu­ru­ji­hisera eta náeneuchi­ravahi. Nacaera­ji­ca­hivare eta nuvanai­ripiana; tasapihapa náimica­pi­cauchahi eta nayehe­repiana táuchurechucha te napane­reruana ena náchuca­na­veánaini” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Ichape eta éjeca­pi­ravahi éti, taicha tasapihapa epicauchahi eta eyehe­repiana. Étasera eta mavanairipi ema Viya, vaipa epicau­chahini. Tasapihapa épuruhi eta mavanai­ripiana taicha tivayua­cahehi ichape eta ítauchirahi eta eyehe­repiana. ");
INSERT INTO ignNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Émarichuhi ema víyarahaini Moisés tiájuchahi eta mavanairipi ema Viya eta viyehe: “Pipicauchaya pémuna­ca­yareva ema piya ésupa esu pena”. Jucarihi eta apana vanairipi: “Mácani tiúmehahi ema maiya ésupa esu maena, vahi tijapa­nu­ca­rémahi nacapa­ca­yarehi”. ");
INSERT INTO ignNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Étisera vahi epicaucha eta júcana vanairipiana mayehe ema Viya. Taicha te marari­hipuca mácani achane ticama­va­hupuca me Viya eta máimaha­que­neanahi, eta ímiturapi éti “Vaipa tatupa­ra­caimahi ema achane eta máimica­ta­siraya ema maiya ésupa esu maena”. ");
INSERT INTO ignNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ani tacahehi eta ecaepahaira eta tasuapa­ca­revahi eta mavanai­ripiana ema Viya. Tasapihapa, ímica­pi­cáuchahi eta eyehe­re­pia­nachucha. Jarari­hivare eta apamuriana eta éjeca­pi­ra­vanahi tavasi­que­neanahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tacahe, máichuhapa ena achaneana, náurujicava eta máimitu­si­ra­va­cayare. Tásiha, máichavacapa: —Nuvaraha esamanu yátupina, apaesa ácaicutiara. ");
INSERT INTO ignNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tájina timaepe­ra­jicaina eta viáchanevana te vahi vicasi­pa­va­hu­numahi te vinicayare. Vahi étapa­racaina eta vinica­queneana. Étasera eta jácani evaina­ra­jivana táuchurea­napuca te ejaca, étapa eta evaina­ra­ji­pa­ne­reruana; jéhevare éta timaepe­ra­ji­cahehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tacahe, te tiyana­ra­canapa ena achaneana, macarinepa ema Jesús énapa ena máimitureana, nayase­recapa máitame­ta­ca­va­cahini eta máimiturapi. ");
INSERT INTO ignNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tacahe, máichavacapa: —¿Éneri­chuvare éti mapane­re­rurehe? ¿Váhipuca ácaicu­tia­rahini eta juca? Tamutu eta juca tasiapa­que­neanahi te vijaca vinica­sa­reanahi, vahi timaepe­ra­ji­ca­ha­vimahi, taicha vahi tasiapa te visamure. ");
INSERT INTO ignNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tatupiruhi te vijuhe. Tásiha, te tiúchucapa eta, apanapa eta táuchusihahi —máichavacapa ema Jesús. (Eta máichira­vacahi eta juca, máimicae­che­rachapa eta táurivahi tamutu eta tinica­careana.) ");
INSERT INTO ignNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Macahe­varepa: —Étasera jácani panere­rucana tamauri­queneana, te náisapa­vapuca ena achaneana, étara timaepe­ra­ji­ca­vacahi éna. ");
INSERT INTO ignNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Taicha te amahe eta nasamureana napane­rechahi eta tamauri­que­neanahi. Ema achane mapane­rechahi maveha esu apana esena mayena ema apana achane. Esu esena supane­re­cha­hivare suveha ema apana achane suima esu apana esena. Éna amaperuana napane­rechahi eta natuhu­sivaya. Nácani tipane­re­chanahi eta ticapa­recana, tiámerecana, tivayua­recana, téchaji­hihana. Te nasamureana, najamuracha eta apayeheana, ticapi­na­ru­rahiana, tétsera­ji­cavana eta nasiña­vairahi. Mapicau­rai­rahana, camuri­queneana eta napane­reruana máecharaireana. ");
INSERT INTO ignNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tamutu eta juca panere­rucana tamauri­queneana tiásihahi te nasamureana. Jéhesare, eta júcana eta timaepe­ra­jicahi eta náchanevana ena achaneana —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tacahe, tiyana­varepa tipaica ema Jesús, énapa ena máimitureana. Nacaiju­he­yarehi eta avasareana táunavanahi eta provincia Siria. Tásiha, títeca­panapa te jácani peti. Váhisera mávara­hahini náechahini ena apamuriana achaneana eta matiari­hirahi. Tásihasera náecharichucha éna. ");
INSERT INTO ignNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tacahe, susamai­ri­ricapa esu ésuna esena. Ésu, apava­sanahi, sirofe­níciana. Eta suécheji­riruva eta griego. Esu suchicha mávaháruhi ema émana éreana. ");
INSERT INTO ignNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Títeca­vanepa esu, suépuyu­mi­rauchapa te mamirahu ema Jesús. Tiyaseu­chavapa mayehe ema Jesús eta máimiju­ni­ji­cahini ema éreana suyehe esu suchicha. ");
INSERT INTO ignNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tacahe, máichapa esu: —Nativaya néchapa­ji­ri­cavaca ena nujaneanana. Taicha vahi táuricahini ásapi­hahíni néchapa­ji­ri­ca­hehini éti apava­sanana, éméta­vi­cahini ena nujaneanana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Esu esena sujicapapa: —Énehineni tacahehi, tátachicha. Yátupihi vahi pijanea­na­nui­nahini. Pájapa­nu­nusera, picata­ji­ca­nu­chuchaini. Víti apanava vácasi­ña­vahini eta piyehe eta vítáti­ji­vairaina —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tacahe, máichapa ésu: —Tiuri eta péchaji­riruva. Piyanapa pichava te pipena. Táichavene eta picasi­ñai­ranuhi, nímiju­ni­ji­caripa ema éreana suyehe esu pichicha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tacahe, tichavapa ésu te supena. Suchimapapa tívecahi esu suchicha te sucamane. Jéhesa­réinehi, májinaripa ema éreana, majuni­jia­caripa ésu. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tacahe, tiyana­na­varepa tipaicana najuni­jicapa eta provincia Siria. Nánucuhapa eta provincia ticaijare Decápolis. Tacahe, títeca­panapa eta te tachausi eta cáquiure Galilea, te tinapaica te táuchusine sache. ");
INSERT INTO ignNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tacahe, ena achaneana námapa ema émana achane mayehe ema Jesús. Túhuquiña, úpavare ema achane. Náechajiuchapa eta manaca eta mavahu mayehe ema achane, macana­ra­si­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tacahe, ema Jesús mañajichapa ema achane nayehe ena achaneana. Manacapa eta masuveraqui te maquiñana. Tacahe, tiátutu­qui­vau­chavapa. Tásiha, máemamacapa eta manene ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tacahe, máesenicapa te anuma. Tiúmitipa. Tacahe, máichapa: —¡Téchujihapa eta piquiñana! ");
INSERT INTO ignNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Enurujipa tisama­rahipa ema achane. Tijimuyapa eta manene, tiúripa téchejica. ");
INSERT INTO ignNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tacahe, máimichavapa ema achane nayehe ena majaneanana. Matupa­racapa éna eta nacuija nametaca. Énasera timeta­ji­ri­ca­naichucha. ");
INSERT INTO ignNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tétavicava eta náramirahi ena nameta­ruanahi. Ánipa nacahe: —Tétavicava táurica­careva tamutu eta máichaque­neanahi ema Jesús. Téchaji­ca­napahi ena úpana, tisama­ra­hia­na­varepa máicha ena túhuquiñana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tacahe, eta juca sácheanahi tiúruji­ca­vanapa ena ichape­mu­ri­queneana achaneana te mávihahi ema Jesús. Mapanaripa sache nacahehi ena achaneana, tájinaipa nanicahini. Tacahe, máichuha­vacapa ema Jesús ena máimitureana. Máichapa: ");
INSERT INTO ignNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nujapa­nuvaca ena nani achaneana, taicha mapana­ripahi sache puiti eta nacahehi eta viyehe. ­ Tájinai­pavare naviyahini nanica. Téchuri­ha­naripa eta nanicaquene. ");
INSERT INTO ignNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te névata­cavaca nayana te napenana, machu náquipaicava te achene taicha vaipa túmeva­caimahi eta náecuavahi. Taicha natiarihi ena tiásihanahi te tiyerehiana. Vénica­va­cayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tacahe, najicapapa ena máimitu­reanahi. Ánipa naicha: —¿Táviha­pucaini viviyahini eta vénisi­ha­yarehi ena nani camuri­queneana achaneana? Eta te juca mávapahi vámahi, tájina vítusiá­váimahi eta tinica­careana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tacahe, mayase­recapa éna. Ánipa máicha: —¿Áyanachaha eta pan eta iámaque­nea­napahi? —Jucarihi siéterine —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tacahe, macava­nai­ripipa eta náejaha­pai­mu­ri­hahini namutu ena achaneana. Tacahe, mavehapa eta siétequene pan, mahasu­lu­pa­yachapa ema Viya te anuma. Tásiha, mayuve­tu­ca­vacapa, máijaracapa ena máimitureana. Éna, náijara­ca­vacapa ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tatiari­hi­hivare eta ánimu­richicha eta jímachichana. Mahasu­lu­pa­ya­chavare ema Viya tayehe eta jima. Tacahe, mavane­ca­varepa eta náijara­si­ra­va­cayare ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tacahe, tinicanapa namutu, tisatu­heanapa. Tacahe, nacuru­jicapa eta náemacha­rájiana. Siete sáyeri­cha­ha­hivare eta náemachana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eta nasimu­tuvahi ena tinicanahi táetavica eta cuatro mil achaneana. Tacahe, te tamutupa eta juca, máevata­mu­rí­ha­sarepa ema Jesús ena achaneana nayanaya nachava te napenana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Enurujipa tiávacu­hanapa te pacure ema Jesús énapa ena máimitureana. Tiyana­na­varepa. Tiánuecana nacaijuhepa eta te avasare ticaijare Dalmanuta. ");
INSERT INTO ignNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tacahe, títeca­panapa ena apamuriana fariséoana. Tépana­vanapa nacana­ra­jirica ema Jesús. Eta navarairahi náimiaqui­pai­ca­yarehi, nayaseacapa máimere­cahini eta tiárami­careana, máimere­ca­vahini te yátupi­hipuca vanairucahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tásiha éma, tichurua­mi­cha­varine muraca. Tacahe, máichavacapa: —¿Tájaha tacayema eti achaneana eyaseacanu nímereca eta tiárami­careana? Núti nímatihe. Vahi esuapa­nuimahi te nímere­ca­pucaini eta tiáramicare. Tásiha, váiparine étina tatuparaca ímahahini eta tiárami­careana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tacahe, majuni­ji­ca­vacapa éna. Tiyana­varepa tiávacuha te pacure. Tiyananapa tiánuecana te apachara eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tiuri puiti, náemiti­sicahi ena máimitureana eta naniru­rucuha. Tatiari­hi­hisera eta étanahi pan eta te pacure. ");
INSERT INTO ignNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eta nayanirahi, máimitu­mu­rihapa ema Jesús éna. Máichavacapa: —Tímati­carehi eyehe eta levadura eta tasisi­jisira tamutu eta masa. Tacutirichu eta taparea­sirahi eta apimi­rai­ra­vacahi ena fariséoana étapa eta tacaeña­ma­rasira eta ecaima­ha­que­ne­rayare. Vahi ecucuti ena políti­coana. Échapaváicha tayehe, machu éhica éna —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tacahe, náichacacapa ena máimitureana. Ánipa nacahe: —Tímica­ja­cha­havihi eta vémiti­si­sirahi eta pan. Eta tacahe, macahehi tayehe eta levadura. ");
INSERT INTO ignNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Éma máimatia­ca­vacapa. Tásiha, máichavacapa: —¿Tájaha tacayema ecahe­cha­ji­ri­ruvahi eta émiti­si­sirahi eta pan? ¿Vuíchahacaru ácaicu­tai­rahini? ¿Tájina­ca­ruichaha epane­reruina éti? ¿Muraca­chu­ti­he­richaha? ");
INSERT INTO ignNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tamapu­ru­ji­chu­chapuca eta ímairahi eta níchaqueneana. ¿Vuíchahacaru ácaicu­tia­rahini? Tamapu­ru­jipuca eta esamirahi eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Váhivare échahini eta nucaeja­pa­sirahi eta cíncoquene pan, naniruhi ena cinco mílqueneana achaneana? ¿Áyanahi sáyeana eta náemacha­rajiana eveha­que­neanahi? —máichavacapa. Tacahe, najicapapa: —Doce sáyeana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Étapa eta siétequene pan naniruhi ena cuatro mílqueneana achaneana, ¿áyana­hivare sáye eta náemacha­ra­jianahi eveha­que­neanahi? —máichavacapa. Najica­pavare: —Siete sáye —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tacahe, máichavacapa: —¿Vuíchaha­caruva ácaicutiara? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tiuri, títeca­panapa eta te avasare Betsaida. Ánaqui, námapa ema achane púchuqui. Náechajiuchapa éma eta macana­ra­siraya ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tacahe, ema Jesús macara­ta­vauchapa ema púchuqui, mámapa te tachachacu eta avasare. Tacahe, mayaji­hau­quichapa eta mátuture eta te máuquihana. Tásiha, manacapa eta mavahuana eta te machuti. Tásiha, mayase­recapa: —¿Pímairi­ricapa? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tacahe, téseni­nicapa ema púchuqui. Macahepa: —Nímairi­ricapa apaesa. Eta nímairahi ena achaneana, ticuti­ma­hi­chu­chasera yucuquiana, tiyamu­ri­ca­na­hisera —máichapa ema púchuqui. ");
INSERT INTO ignNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tacahe, ema Jesús mápechavare manaca eta mavahuana eta te máuquihana ema púchuqui. Te mavehapa eta mavahuana, yátupipa tijarahipa eta máimairi­ri­sirahi. Tamutupa máimaha. ");
INSERT INTO ignNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tacahe, ema Jesús máevatacapa ema púchuquinihi, mayanapa te mapena. Máichapa: —Piyanapa pitupiru te pipena. Váhisera picusiapa eta te jena avasare eta piyanihaya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te táequenepa eta juca, tiyana­varepa tipaica ema Jesús, énapa ena máimitureana. Nacaijuhepa eta te avasa­re­chichana tachacaya eta ichape avasare ticaijare Cesarea, máepiyaruhi ema rey Felipe. Eta napaisi­rapahi, mayase­recapa ena máimitureana. Ánipa maicha: —¿Tájaha nacayema ena achaneana eta nuyehe? ¿Nájaha­nu­hipuca náimija­chanuhi núti? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tacahe, najicapapa: —Ena apamuriana náimija­chavihi téchepuca ema Juan Tícacha­si­ri­ca­rahini. Ena apamuriana tímija­cha­vianahi ema víyarahaini profeta Elías, téchepucahi éma. Ena apamuriana tímija­cha­via­na­hivare ema mácani apana profetaini antívuini, téchepucahi —náichapa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tacahe, tiápecha­vavare mayase­re­cavaca: —Étiyapa, ¿nájaha ímija­chanuhi núti? Majica­pa­vanepa ema Pedro: —Pítira yátupi­que­névihi Cristo —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tacahe, matupa­racapa muraca éna, nacuija nacumetaca eta émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tacahe, tépanavapa máimitu­ca­vacahi eta táichara­ra­ca­vayare eta máepeni­rayare. Ánipa maicha: —Nuti Manere­ji­ru­nuhi ema Viya, nutupa­ra­haichuhi ichapemuri eta nucata­ji­vai­rayare. Tépuru­nua­nayare ena tuparai­ru­cana énapa ena aquenu­ca­ra­hana. Éna, tímica­pa­ca­nua­na­yareva. Mapana­ya­rei­chu­hisera sache eta nucaheyare eta népeni­rayare. Tásiha, nuchava­yarehi néchepuca —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Máimicae­che­rachapa eta macaye­ma­quenehi. Tacahe, ema Pedro máiputsiacapa ema Jesús. Ánaqui macajachapa, máijara­si­ravahi eta mapane­reruhi. ");
INSERT INTO ignNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tacahe, téviuru­cavapa ema Jesús. Máesenicapa ena apamuriana máimitureana. Tásiha, macaja­cha­varepa émapava ema Pedro. Máichapa: —Píti, téjeca­pavahi eta pipane­reruhi. ¡Pínajica eta juca tamauri­quenehi! Pivarahapa pihapapica eta mapane­reruhi ema Viya. Eta juca pipane­reruhi tacutihi eta mapane­re­ruanahi ema Satanás, énapa ena machanerana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tacahe, máichuha­vacapa ena máimitureana énapa ena apamuriana achaneana. Máichavacapa éna: —Nácani navaraha náehicanu, tacamunu náinajica tamutu eta tihapa­pirica eta náehisi­ranuhi. Nacara­va­hu­yareva eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nácanisera téñamanahi eta náitaresira, tiávami­ra­huanaya eta náehisiranu, énaji­vayare ticami­tie­que­ne­ha­vanaya eta náitaresira. Énasera nácani yátupi tíjara­cavana téhicana eta náehisi­ranuhi, étapa eta námirahi eta tíurina échaji­ri­rucava, tayanapane táimica­pa­ca­va­capuca, éna títuji­ca­va­nayare tiúchucu­hayare eta náitare­si­ranaya. ");
INSERT INTO ignNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Éneri­chuvare nácani tacaeña­ma­ra­ruanahi eta nacaima­ha­que­néiraya te juca apaquehe, tíñehiyare eta náitaresira taicha eta tacaeña­ma­ra­si­ra­vacahi tahapa­pi­ri­ca­vacahi tayehe eta náuchucui­ra­ya­rehini. Tiyana­nainapa eta te yucu nacaicu­ñai­yayare. ");
INSERT INTO ignNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Taicha vahi márata­haimahi mácani achane mavacha­chahini eta máurivaya te apana vítaresira. ");
INSERT INTO ignNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Énaripa nácani titsiri­ha­napuca téhicanuana, náimitsi­ri­hapuca eta nímitu­rapiana te namirahuana ena achaneana mapicau­rui­rahana pecatu­mareana, núti apanava nutsiri­ha­yareva nayehe ena nani. Nucaera­ji­cainapa ena nani, nuti Manere­ji­ru­nuhi ema Viya, te táitecapapa eta sácheyare nuchavi­rayare aquenu­ca­nui­napaipa. Te jena sácheyare, námainapaipa núti eta majaraiva ema Tata, nucacha­né­napaipa ena sántoqueneana ángeleana. ");
INSERT INTO ignNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Éneri­chuvare máichavacapa: —Nutupiruva numetacahe: Puítiripa te etaracu éti etiarihi éti vahi épena­va­némahi, ímaha­nu­numaya eta táepaniraya eta nítupa­ji­jia­si­ravahi eta nucatu­pa­ra­hairahi aquenu­canuya me Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tiuri, sáisipa sache eta nanasirahi ánaqui. Tacahe, ema Jesús manaqui­ca­vacapa ena máimitureana. Nacarinehi máma ema Pedro, ema Jacobo, émapa ema Juan. Tiyananapa eta te étana mari anuque­hepana. Nacarichu éna. Eta ánaqui, náimahapa tihapa­mai­chavahi eta máimahi ema Jesús te namirahu éna. Tétavi­cavapa eta tajapuvahi tajara­ra­sirahi tamutu eta máquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eta mamuiriha, táetaviucha eta tajanu­nu­me­sirahi. Nájina tiratahaina tépachinacha tajanu­nu­me­cahini náicha eta muíriare. ");
INSERT INTO ignNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tacahe, tiárami­ca­rea­na­varepa tímere­cavana ena apina ajairana: ema víyarahaini profeta Elías émapa ema víyarahaini Moisés. Téchaji­ri­ca­va­na­ripahi mayehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tásiha, ema Pedro tímisia­pavapa, téchajicapa ema Jesús. Ánipa macahe: —Tata Náquenu, tétavi­cavapa táurica­careva eta viávihairahi eta ani. Tiúripa­na­hi­pucaini vépiya­cahini eta epena­hui­na­pa­chuhini. Pipena­hui­na­ri­chuhini píti, mapenainari­chu­hi­varéni ema Moisés, émapaini ema Elías —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Váhinéni máimatie­que­nehaini ema Pedro tájaha­hipuca eta mavara­ha­quenehi macayema. Namutu tíñacavana ichape ena mapanana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tacahe, tiárami­ca­re­varepa eta úcaji táepacú­mu­rihahi éna. Nasama­varepa eta mahu ema Viya tayehe eta úcaji. Ánipa macahe: —Ema maca, ema yátupi­quenehi nuchicha némuna­ru­quenehi. Éma esuapayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tíjahú­cha­va­varepa, te náeseni­ca­varepa, macarinehi ema Jesús. Nájinaripa ena apinana náimaha­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tacahe, te tichavanapa tiúcupai­ca­na­varepa, ema Jesús matupa­ra­ca­vacapa éna. Ánipa maicha: —Vuíchaha ecume­ta­jirica eta juca ímaha­quenehi puiti. Tiámainucava te néchepuca te nécari núti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tásiha, nasuapa eta matupa­raruhi. Napane­re­que­ne­ha­hisera eta macaye­ma­quenehi. Tiyase­re­ji­ri­ca­canapa: —¿Tájahapuca tacaye­marihi eta máechepu­si­rayare te máecari? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te tichavanapa tayehe eta anuquehe mari, nayase­recapa éma, ánipa naicha: —Ena escribá­noana tímitu­canahi eta machavi­rayare tiápechavaya títareca ema víyarahaini Elías, tínapu­ca­yarehi eta pímere­si­ra­va­yarehi piti Cristo. ¿Énapuca téjeca­pa­vanahi ena escribánoana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Majicapapa ema Jesús: —Yátupi, ema víyarahaini Elías títeca­pa­yarehi, máetupi­ri­pa­na­yarehi tamutu. Nútisera numetacahe: Títeca­ripahi ema Elías, váhisera náimatihini ena escribánoana. Váhivare najaca­pahini ena tuparai­rucana éma. Nacatia­na­ca­hisera nacapacahi éma, tacuti eta táechaji­si­ha­que­neanahi eta Sagrada Escritura eta máichava­que­ne­va­yarehi éma. Ene nucaheyare núti Manere­ji­ru­nuhi ema Viya. Ticatia­na­ca­nua­na­ya­re­hivare, tépuru­nua­na­yarehi. Ichape eta náemeca­ta­ji­chi­ra­nuyare eta náimica­pa­si­ranuya, tacutihi eta táechaji­si­ha­quenehi eta Sagrada Escritura eta nuyehe —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tacahe, te tichavanapa éna te návihahi ena apamuriana máimitureana, natiarihihi ena camuri­queneana achaneana te nachacaya. Natiari­hi­hivare ena apamuriana escribánoana, nacana­ra­ji­ri­ca­vacahi ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Eta náimairahi ema Jesús, náraminehi ena achaneana. Tijuna­pa­ra­canapa namutu náechaji­panaya. ");
INSERT INTO ignNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Te títeca­panapa te návihahi ena máimitureana, ema Jesús mayase­re­mu­rihapa éna. Ánipa maicha: —¿Tájaha eta ecana­ra­ji­ri­ca­vacahi ena nani escribánoana? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tacahe, tiúchuji­cá­vanepa ema émana achane. Majicapapa, ánipa maicha: —Tata maestro, picata­jicanu. Námapahi piyehe ema maca nuchichasami. Éma, vahi téchajica maicha ema éreana. ");
INSERT INTO ignNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mavarahapa jácani ema éreana, máijahúchava máquipaicahi ema nuchicha. Tásiha, ema amaperu ticari­sa­sa­jacapa, tinira­ta­quia­he­chavapa muraca. Tivirajipa máicha ema éreana, muraca­qui­ha­varepa. Nuyaseacahi ena pímitureana eta náimiju­nai­ra­ya­rehini ema éreana. Váhisera nárata­hahini —máichapa ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tacahe, máichapa ema Jesús: —¡Tétavicava emasua­pa­ji­rai­vavaca eti achaneana! ¡Cúvera­re­ca­cha­sicaini eta nucami­chi­ra­hé­nahini! Iáma ani ema amaperu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tacahe, náepanapa ema amaperu. Te máimahapa ema éreana ema Jesús, enurujipa macaeñamaca ema amaperu. Tacahe, tiáquipai­cavapa te apaquehe. Téchari­ri­pái­cavapa ticari­sa­sa­jacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tacahe, mayase­recapa ema Jesús ema maiya ema amaperu. Macahepa: —¿Tiyere­ri­pa­hipuca eta juca máichava­que­nevahi? —macahepa. Majicapapa ema achane: ");
INSERT INTO ignNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Te amuya­richaha. Máejeharipa máquipaica ema mara éreana te yucu téhevare une, taicha mavaraha macapaca éma nuchicha. Pítisera, te pirata­ha­pucaini, pájapa­nu­havini picata­ji­ca­ha­vi­samíni —macahepa ema achane. ");
INSERT INTO ignNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Majicapapa ema Jesús: —¿Tájaha picaye­maquene eta píchanuhi eta te nurata­ha­hi­pucaini núti? ¡Pítina­pucaini, te pirataha! ¡Pácasiñanu! ¡Tamutu títuji­cacare te ecasiña eti achaneana! —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Enurujipa majicapa ema achane. Tijaranu eta majica­pirahi, ánipa macahe: —¡Nucasiñavi, tata! ¡Pímica­tacanu eta néchuria­sirahi eta nucasi­ñai­ravaina piyehe! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tacahe, máimahapa ema Jesús ena achaneana tiúruji­ca­va­naripa mayehe. Tásiha, macajachapa ema éreana, ánipa maicha: —¡Piti váinaraji, piti pétuhu­qui­ñarahi, úpahi pícha éma! Núti nuvanecavi: ¡Pijuni­ji­cayare ema maca amaperu! ¡Vaipa picuchavaucha ema maca! —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tacahe, tipiara­recapa ema éreana. Mavayu­yu­jicapa tiyayacare ema amaperu máicha. Tacahe, majuni­jiacapa ema amaperu. Ema amaperu ticutipa máepenaquene. Tacahe, nacahepa ena achaneana: —Tépena­samipa —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tacahe, ema Jesús macara­ta­vauchapa, macaeche­pucapa ema amaperu. Tacahe, titupihapa ema amaperu, tiúripa. Tájina máichava. ");
INSERT INTO ignNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tacahe, te táequenepa, náiputsiacapa ema Jesús ena máimitureana. Nayase­recapa: —¿Tájaha tacayemahi eta vahi várata­hahini vicuchu­cahini ema éreana mayehe ema amaperu? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tacahe, majicapapa éma: —Ema maca éreana, muraca­panahi éma. Eta ecuchu­siraina ena nani macuti­que­neanahi tavaraha íchanu­mayare eta eyuja­ra­siraina étapa eta íchiraya eta ayuna —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tacahe, tiyana­na­varepa tipaicana. Nánucuhapa eta provincia Galilea. Vahi mávara­hahini ema Jesús eta nasamai­ri­ri­cahini ena achaneana eta nánucuirahi éna, machu nahapa­pi­ri­ca­pucaini eta máimitu­si­ra­vacahi ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eta máimitu­si­ra­vacahi, ánipa macahe: —Nuti Manere­ji­runuhi ema Viya, járaja­painapa eta sácheyare eta máijara­si­ránuya mácani achane nayehe ena ticatia­na­ca­nuanahi. Ticara­ta­ca­nua­nayare, ticapa­ca­nua­na­yareva. Téhesera te mapana­que­nénapa sache eta népeniraya, néchepu­cayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Énasera ena máimitureana váhiquene nacaicu­tia­rahini eta macaye­ma­quenehi. Natsiri­ha­ca­pasera nayase­re­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tacahe, títeca­panapa eta te avasare Capernaúm. Te peti náiteca­pihahi, mayase­re­ca­vacapa ena máimitureana. Ánipa macahe: —¿Tájahapuca eta ejica­pae­ma­ra­cacahi eta epaisi­rapahi te achene? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tásiha, vahi najica­pahini, taicha vahi návara­hahini náimereu­cha­vahini eta najica­pae­ma­ji­ri­ca­cai­rapahi eta nájahai­ra­ya­repuca mácani ticapi­ca­hu­panahi. ");
INSERT INTO ignNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tásiha, téjacapa ema Jesús. Máichuha­muripa ena dócequeneana eta napauchi­rayare náejaca eta te machacaya. Tacahe, máichavacapa: —Nácani navarahahi ticapi­ca­hu­pa­na­nayare te etaracu, tavaraha náechapa­ji­ri­cavaca namutu ena nachamuriana. Nacachu­ri­cayare eta náemuna­raivahi nayehe ena apamuriana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tacahe, máichuhapa ema émana amape­ruchicha. Majupacapa te namirahu éna. Tacahe, máichavacapa: ");
INSERT INTO ignNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nácani tijaca­pa­nayare ena amaperuana níchave­nénahi núti, ena nani yátupi náimerecaya eta náemuna­si­ranuhi núti taicha tímicu­ti­ji­ri­cavahi nútinahini najacapa. Taicha nácani tijaca­pa­nuanahi núti, éneri­chu­yareva tacahehi eta najaca­pirahi ema Ticachichanu, ema tivane­canuhi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tacahe, ema Juan mametacapa, ánipa máicha: —Tata maestro, vímahahi ema émana achane máquiji­ca­vacahi ena éreanana te píjare ticuti­rinehi pítinahini píjaraca eta máitupa­ji­jia­si­ravahi. Tásihasera vicavacahi éma, taicha vahi viúmuri­vai­nahini —máichapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Émasera ema Jesús máichapa: —Vahi ecucavaca éma. Taicha te máichahipuca ema mácani eta tiáramicare, mámapicahi eta níjare, vahi macaeca­hi­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tímica­ta­ca­havianahi nácani vahi ticatia­na­ca­ha­vianahi. ");
INSERT INTO ignNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jéhesare, nácani ticumpi­ra­chaheana eta une éti étaripa táichavenera eta étirahi nuchane­ra­nai­rahehi nuti Cristo, vahi námapu­ru­jimahi. Yátupihi ticava­chae­que­nea­na­yarehi éna —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tímiyanava eta máimitu­re­sirahi ema Jesús, ánipa macahe: —Tacutiquene mácani tímiáqui­paicaya nácani ena téhica­nuanahi mánsuque­neanahi. Tiúripa­na­hi­pucaini táijahú­cha­vahini máepenahini mativai­nahini éma. Váhiri­chu­pucaini macucai­cu­ñahini, taicha vahi macuimia­qui­pai­cahini ena téhica­nuanahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Éneri­chuvare máichavacapa: —Jéhevare, te tavara­hapuca táimipe­ca­tu­ra­cha­heyare eta evahu, tapami­si­ra­hé­na­papuca íchayare eta tamauri­queneana, tiúripana eyuchatica, apaesa vahi tacuímiá­qui­paicahe tayehe eta pecatu. Étaripa eta ívape, te tavara­hapuca támahe íchayare eta tamauri­queneana, tiúripana eyucha­ti­cavare, apaesa vahi tacuímiá­qui­paicahe tayehe eta pecatu. Étari­pavare eta iúquiha, te táimiaqui­pai­ca­hepuca tayehe eta pecatu, tavarairahi táimahayare eta tamauri­queneana tájipa­racana, tiúripana evecu­hau­quichava. Taicha tiúripana eta ejaca­pa­carehi éti eta esiapiraina eta te mávasa ema Viya, tayanapane táejiaca­vapuca eta iáquehe. Páurehe­sa­misera éti, te náepuju­qui­cha­hepuca eta te yucu infierno, tayana­panéni tamutu­cha­hahini eta iáquehe. Taicha ánaqui máemaha­ca­ca­quenehi eta yucu. Máitavacaca eta ecata­ji­vai­ra­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tacuti eta vépura­rajica eta icheve eta viniru, ene nacaheyare ena tiyana te yucu, ticaepu­ra­ra­ca­sia­nayare tayehe eta yucu. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Eta icheve, tétavi­cavahi eta táurivahi, taicha ticamu­nu­carehi. Ene ecaheyare éti eta ecamu­nu­ca­revahi eta nayehe ena achaneana. Váhi tacuepaha eta ecamu­nu­careva. Vahi ecucuti eta tajachira eta icheve, taicha tájina eta táicheve­vai­nahini. Tacuijavare tahapa­picahe eta iúrivahi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tacahe, tiyana­na­varepa tipaicana te tinapaica te vana. Nánucuhapa eta provincia Judea. Tásiha tiánuecanapa eta te apachara eta cajacure Jordán. Ánaqui tiápecha­va­navare tiúruji­mu­riavana ena ichape­muriana achaneana te jácani máiteca­pi­hapahi ema Jesús. Tásiha, tímitu­re­cavare éma, taicha tacahehi eta mayehe­repihi. ");
INSERT INTO ignNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tacahe, náiteca­pauchapa ena apamuriana fariséoana. Natanucahi eta ticaviu­re­yarehi ema Jesús. Ánipa náicha: —Vivaraha pimeta­cahavi ¿te táuricapuca máinajica ema achane esu mayena? ");
INSERT INTO ignNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tásiha, ema Jesús mayase­re­ca­varepa ema apana: —¿Tájahasica eta tacayema eta mavanairipi ema víyarahaini Moisés? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Najicapapa éna: —Ema víyarahaini Moisés máisapahi ema suima máejerare eta máinajisira esu mayena. Macava­nai­ri­piser májucha eta ajureca tayehe eta náinaji­cacaira. Tásiha, eta máijara­sirahi ésu eta juca ajureca, máinajica ésu. Tásiha, vaipa mayenai­nahini —nacahepa ena fariséoana. ");
INSERT INTO ignNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tacahe, ema Jesús máichavacapa éna: —Ena iáchuca­na­veanaini, te jácani eta nasemairahi, náinajica ena nayenana. Ema víyarahaini Moisés máisapahi tínaji­cacana táichavenehi eta namura­ca­sa­mu­re­vanahi éna, vahi náimitu­ca­ca­rehini táicha. ");
INSERT INTO ignNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Váhisera máuricahini ema Viya eta náinaji­ca­cahini. Taicha te tépana­vainapa acane, ema Viya máijaracahi ema achane ésuna­ya­reichuhi esu mayenayare. Esu esena émana­ya­rei­chuvare ema suímayarehi. ");
INSERT INTO ignNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ani tacahe eta mavanairipi ema Viya: “Mácani amaperu achane ésupa esu mayenayare, te ticaimanapa, tatupa­ra­ca­vacahi típutsi­ca­va­na­yarehi eta napenana ena ticachichana. Énaji­vainapa títáti­ca­ca­nayare. Eta naveha­ca­cairahi, tímicu­ti­ji­ri­cavaipa étana­rinehi eta náqueheana” tacahepa. Éna, tímicu­ti­ji­ri­ca­vainapa émanai­na­ri­chuhini te peti. Étanarichu eta napane­reruana. Vaipa táisapa­ca­rehini eta náinaji­ca­cai­rahini. ");
INSERT INTO ignNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eta tacahe, mácani máinajicahi esu mayena, éma máepuruhi eta juca mavanairipi ema Viya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te táequenepa, nacari­chui­pa­hivare ena tayehe eta peti náiteca­pihahi, ena máimitureana nayase­recapa ema ­ Jesús tayehe eta juca máechaji­ri­ru­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tacahe, máichavacapa éna: —Te máinaji­capuca esu mayena mácani achane, eta maviraya esu apana esena, ticape­ca­turaipa éma me Viya. Ichapevare eta máejeca­pi­ravahi suyehe. ");
INSERT INTO ignNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tacutiquene súcani esena, te suínaji­capuca ema suima, eta suviraya ema apana achane, ticape­ca­tu­rai­pavare ichape ésu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tacahe, ena achaneana námava­ca­paipahi ena amuyana eta mayehe ema Jesús. Navarahahi máemama­ha­ca­va­ca­yarehi éna, mayuja­rau­cha­va­ca­hi­varéni. Énasera ena máimitureana vahi náisapahini. Nacaiche­paicapa ena tiámanapahi ena amuyana. ");
INSERT INTO ignNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te máimahapa ema Jesús eta nacaiche­pai­sirahi, tisemapa. Tásiha, máichavacapa ena máimitureana: —Ésami­ri­cachucha ena amuyana, náitecaichaha eta nuyehe. Vahi ecucai­chepaica éna. Taicha ena nuchanerana nuti Cristo nacuti­yarehi ena nani amuyana eta nasuapa­jiraiva éna. ");
INSERT INTO ignNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nutupiruva numetacahe: Nácani vahi nácutihini ena amuyana eta nasuapa­jiraiva, vahi nuchane­ra­naimahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tacahe, majupa­ca­vacapa ena amuyana. Máemama­si­ca­varepa, mayuja­rau­cha­vacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tiuri, te apanapa sache, tiyana­na­varepa. Eta napaisi­rapahi, macahepaipa ema émana achane. Tijuna­paipahi. Matupiru máepuyu­miraucha te mamirahu ema Jesús. Mayase­recapa, ánipa maicha: —Tata maestro, piti piúriquene ¿Tájaha­pucaini eta níchara­ca­vahini eta nítuji­si­ravaina me Viya máichecua­ra­qui­ré­nahini eta nítaresira? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ema Jesús majicapapa: —¿Tájaha tacayema pímija­rechanu “Piti piúriquene”? Mararihi ema Viya. Jéhevare éma, tétavi­cavahi eta máurivahi. ");
INSERT INTO ignNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Téhesera te pivara­hapuca pecha eta apana vítaresira, pisuapa­yarehi eta mavanai­ripiana ema Viya. Píti pímatipa eta júcana: “Vahi picuca­pareca. Váhivare picuveha esu esena apayena. Váhivare picuamereca. Nacuija pépiyáe­que­neruina. Váhivare picuva­yuareca. Pipicau­cha­yareva ena ticachi­cha­viana” —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tacahe, majicapapa ema achane: —Tata, tamutu eta juca vanairipiana nusuapahi nítauchahi eta námape­ruvahi, puíticha juca ajairai­ranuipa —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tacahe, ema Jesús máimara­racapa ema achane, máemuna­cainehi. Tásiha, máichapa: —Jucari­hichaha eta pítaucha­que­neyare. Piyana, píjara­recaya tamutu eta pímaha­queneana. Tásiha, píjara­ca­vacapa ena páureana. Jéhevare eta, pijaca­payare eta pímaha­que­neyare te anuma, táitsivayare. Te tamutupa eta juca, píteca­vanepa péhicanu —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tásiha, témaha­sa­mu­re­rinehi ema achane taicha eta macaye­ma­quenehi ema Jesús. Ichape­rinehi eta mapane­re­re­sirahi, taicha mavayuchahi eta macaima­ha­que­nerahi. Macatie­que­ne­ha­rinehi tamutu. Tiyanachucha. ");
INSERT INTO ignNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tacahe, máesenicapa ema Jesús ena máimitureana natiari­hi­que­neanahi te machacaya. Tacahe, máichavacapa: —Yátupi­quenehi máitujiana eta náijara­si­ra­vai­nahini eta náehisi­ra­nui­nahini ena rícoana eta nasiapi­rai­nahini te anuma —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ena máimitureana náramine eta nasamirahi eta máechaji­ri­ruvana. Tásiha, mápecha­vacapa máicha: —Nuchicha­naveana, esamanu. ¡Máituji­quenehi eta náijara­si­ra­vai­nahíni téhicanuana ena ticasi­ñanahi eta nacaima­ha­que­nerahi! ");
INSERT INTO ignNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eta juca tímicu­ti­ji­ri­cavahi eta vipera camello, máitujihi tánucu­hahini te támicuejehe eta parirapa. Ene nacahehi ena rícoana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tásiha, náramine ena máimitureana, eta nasamirahi eta juca. Náichapa: —¡Tétavi­cavahi eta tamaitu­ji­ca­ca­revahi! ¡Nájina títuji­ca­vaimahi náuchucu­hahini! ");
INSERT INTO ignNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tacahe, máimara­ra­ca­vacapa ena máimitureana. Tásiha, máichavacapa: —Nájina émanaina achane émaji­vai­nahíni ticuchu­cuhava. Émasera ema Viya, macarichu marataha ticuchu­cureca. Taicha tájina máemeje­ra­cha­que­né­nahini ema Viya, tamutu marataha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tacahe, máichapa ema Pedro: —Vítisera, Tata, vinaquicahi tamutu eta vicaye­he­queneana, vivarairahi véhicavi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ema Jesús majica­pa­varepa: —Nutupiruva numetacahe: Namutu nácani nanaquicahi eta napena, najuni­ji­ca­hivare ena ticachi­chana, ena napara­pe­naveana, ena nachicha­naveana; étapa eta nayehe apaquehe, te nanaquicahi táichavenehi eta náehisi­ranuhi, étapa eta námirayare eta tiúrina echaji­ri­rucava; ");
INSERT INTO ignNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tiápaju­ca­vainapa camuri­pa­nayare ena napara­pe­na­vea­nayare ajairana, esenana, énapa ena náenana­vea­nayare, énapa ena nachicha­na­vea­nayare. Camuri­pa­na­yareva eta náitsiri­ji­si­ra­vayare. Ticati­cha­ca­rea­na­ya­resera nayehe ena apamuriana achaneana. Éneri­chuvare níjara­ca­vacaya eta nápechi­ra­vayare títarecana. Máichecua­ra­qui­renapa eta náurica­ca­re­va­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mavera­hesera eti etiari­hi­que­neanahi puiti, váhirichuhi ecapi­ca­huhini. Te jena sácheyare, ichape­pa­nainapa eta ecapi­ca­huiraya. Éna puiti ticapi­ca­huanahi, te táitauchavapa te jena sácheyare, énapa­vainapa téquene­ha­nayare —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Te apana­varepa sache, tiyana­na­varepa tipaicana. Nacaijuhepa eta te Jerusalén. Tínapu­capaipa ema Jesús te namirahu ena máimitureana. Nárami­paipahi éna. Natiari­hivare ena tipica­na­paipahi. Tacahe, ema Jesús mañaji­cha­muripa macaeta­va­ji­mu­ri­ha­varepa ena dóceana apóstoleana. Mameta­ca­vacapa eta jácani máichara­ra­ca­va­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Máichapa: —Ímaha puiti, viyanai­napaipa vicaiju­heyare eta Jerusalén. Ánaqui nucaija­ra­re­ca­siyare nuti Manere­ji­ru­nuhi ema Viya. Ticara­ta­ca­nua­nayare ena tuparai­rucana. Tímica­pa­ca­nua­na­yarehi, taicha tíjara­re­ca­nua­nayare nayehe ena suntaruana romanoana. Éna, nájina najapa­nu­quenéna. ");
INSERT INTO ignNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ticaeca­hi­nua­nayare. Tiátutu­qui­cha­nua­na­yareva. Téstaca­nua­na­yareva. Tásiha, ticapa­ca­nua­nainapa. Tásihasera, te mapana­que­nénapa sache néchepu­cainapa te nécari —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tacahe, te apanapa sache, témeña­ha­vanapa ema Jesús ena apinana ticapa­ra­pe­cacana ema Jacobo émapa ema Juan. Náichapa: —Tata maestro, vivaraha picata­ji­ca­ha­vihini eta viyasea­ru­viyare —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Tájaha ecamunu? —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Najicapapa éna: —Te jena sácheyare te péjacapa te piávacu­reyare aquenu­ca­vi­rayare, vivaraha picaeja­ca­ha­vi­hi­vareni te pichacaya, pijupa­ha­ha­vi­nahini, véjacaini te pivaure, ema émana te sapa —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tacahe, majicapapa ema Jesús: —Éti, vahi ímati tájahapuca eta nátaji­vayare nácani nujupa­ha­nayare. ¿Erata­ha­ya­repuca ecamicha eta íchava­que­ne­vayare ecata­ji­vai­rayare, te ecuti­nu­ya­repuca eta nucami­chi­rayare núti? ¿Váhiva­repuca epicayare ticapa­caheana tacuti eta nacapa­si­rá­nuyare núti? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ena najicapapa: —Virata­hayare vicamicha. Váhivare vipicaimahi. Tásiha, máichavacapa: —Yátupi ichape eta ecata­ji­vairaya, vicuti­cacaya eta nacapa­si­ra­ha­viyare. ");
INSERT INTO ignNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Étapasera eta nucaeja­siraya ena nujupa­ha­nayare, vaipa nútimahi necha. Ema Tata Nucaiyaquene, émahi tinere­ji­ca­yarehi éna nujupa­ha­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tacahe, te náechapa ena apamuriana apóstoleana, tisema­ma­ju­heanapa nayehe ena apinana. ");
INSERT INTO ignNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tásiha, máichuha­muripa namutu. Máichavacapa: —Écharichuhi éti ena aquenucana tayehe eta avasare, muraca eta nacava­nai­ripira. Énaripa ena tuparai­rucana, tétavi­cavahi tisuapa­ca­reanahi eta nacava­cu­rerahi. ");
INSERT INTO ignNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Váhisera ecucahe éti nayehe ena echamuriana. Mácani tímere­cavahi ticapi­ca­hupana, tacamunuhi máitáti­va­cayare ena apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te etiari­hi­va­repuca éti evarahahi ínapuca, tacamunuhi ímere­ca­vayare navana­ra­heyare ena echamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ecuti­nuyare nuti Manere­ji­ru­nuhi ema Viya. Vahi étaina tímitecanu nucaita­ti­ca­sihini. Nútiyarehi nítátihe éti. Éneri­chuvare níjara­ca­va­yarehi nímica­pacava íchave­ne­yarehi éti camuri­que­neanaya nucuchu­cu­rea­nayare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tiuri, títeca­panapa eta te avasare Jericó. Te apanapa sache tiyana­na­yarepa. Náehicapaipa ena camuri­queneana achaneana. Te achene­chacaya, matiarihihi ema achane púchuqui. Ticaijare Bartimeo, machicha ema Timoteo. Téjacahi tiyase­se­recahi limosna. ");
INSERT INTO ignNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te masamapa eta mánucui­rapahi ema Jesús Nazareno, tipiaracapa. Ánipa macahe: —¡Tátachicha Jesús! ¡Pítique­neripa yátupi­quenévi Cristo! ¡Picata­ji­ca­nupaini pájapa­nunuíni! ");
INSERT INTO ignNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tacahe, nacavacapa camuriana ena natiari­hi­que­neanahi. Náichapa: —Pámatina. Vaipa picupiaraca —náichapa. Émasera tipiara­caichucha: —¡Tátachicha Jesús! ¡Pítique­neripa yátupi­quenévi Cristo! ¡Picata­ji­ca­nupaini pájapa­nunuini! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tacahe, tíchepaicapa titupihapa ema Jesús. Máichapa: —Íchuha ema mara. Tacahe, náichuhapa ema púchuqui. Náichapa: —¡Pétumechava! Péchepuca, taicha tíchuhavipa ema Jesús —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eta manane­sirahi ema púchuqui, macami­ricapa eta máepacuha. Téchepucapa, tiyanapa mapauchahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tacahe, mayase­recapa ema Jesús ema púchuqui. Ánipa máicha: —¿Tájaha picamunu nuyehe? Majicapapa éma: —Tátachicha, nuvaraha picaimai­ri­ri­ca­nupaini —macahepa ema púchuqui. ");
INSERT INTO ignNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tacahe, máichapa ema Jesús: —Tiuri, nuchicha. Táichavenehi eta picasi­ñai­ranuhi, pinaracapa puiti. Tiúrinapa eta piyaniraya pipaisiraya —máichapa. Enuru­ji­rinehi tímairirica. Tacahe, máehicapa macacha­nepaipa ema Jesús eta mapaisi­rapahi te achene. ");
INSERT INTO ignNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tacahe, te apanapa semana tiyana­na­varepa. Tétava­ji­canaya tayehe eta avasa­re­chichana ticaijare Betfagé étapa eta Betania, te tachacaya eta cerro ticaijarehi Olivoquiji. Tiánehianapa eta te Jerusalén. Ánaqui, ema Jesús mavanecapa ena apinana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ánipa máicha: —Eyanayare eta te jena avasa­rechicha Betfagé. Te ítecapapa ánaqui, ímahayare ticaitihahi eta burrico. Eta jena sárare mávaeque­héchaha. Nájinaichaha ticape­rainahi. Eveja­pua­cayare, iámina­nuyare eta ani. ");
INSERT INTO ignNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te natiari­hi­napuca náeñama, emeta­cayare eta nucamu­nuirahi núti. Vahi táyeréimahi vímicha­va­va­neyare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tacahe, tiyananapa ena vanairu­canahi. Jéhesare, nachimapapa eta burrico. Ticaitihahi eta te calle te tapaja­chacaya eta peti. Tacahe, naveja­puacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Náichapasera ena ticayeheana: —¿Tájaha tacayema iámayare eta viyehe burrico? ");
INSERT INTO ignNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tacahe, najicapapa éna, nametacapa eta máimitu­rapihi ema Jesús. Tásiha, náisapapa eta námirahi eta burrico. ");
INSERT INTO ignNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tacahe, te títeca­panapa te mávihahi ema Jesús, náepaca­mae­quechapa eta náepacuhana. Tásiha, ticaperapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tacahe, tiúruji­ca­va­napaipa ena achaneana. Camuriana éna tiácapanahi, náepaca­pai­capaipa eta namuirihana eta te mayani­ha­ya­repahi éma. Ena apamuriana navehapa eta cáchipaca. Nanacavare te achene. ");
INSERT INTO ignNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ena tínapu­mi­rau­cha­na­paipahi énapa ena téquene­ha­napahi, namutu tipiara­ca­napaipa. Ánipa nacahe: ");
INSERT INTO ignNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—¡Yare, Tata! ¡Píti yátupi­que­névihi Cristo, réyvihi viyehe! ¡Asulupaya! ¡Vanairu­ca­que­névihi píti me Viya! ¡Ichape eta vicuna­chiravi píti! ¡Asulupaya me Viya te anuma! ¡Viva ema Viáquenu! ¡Viva! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tacahehi eta máiteca­pirahi ema Jesús eta te Jerusalén. Matupirupa tiyanahi te Templo. Te tamutupa máimahahi, tiyanapa tichava te Betania, namutupaichu ena dóceana apóstoleana, taicha cápere­hi­chi­charipa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te apana­varepa sache, te yáticarahi, tichava­navare te Jerusalén. Eta najuni­ji­sirahi eta Betania, técuhaipahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eta máimairahi tiyerehi eta étana yucuqui ticaijare higo. Ticaina­pu­cavahi ticápácaji. Tacahe, ema Jesús tiyanapa máimahapana te ticahi­hipuca. Téhesera te máiteca­pauchapa, máimahainehi tájina táhinahini. Tacarichuhi eta tapacajiana, taicha vúichaha tacahi­rai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tacahe, máichapa ema Jesús eta higo: —¡Piti pépiyainapa eta máhiri­qui­re­viyare! —macahepa. Nasama­ra­racahi ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tacahe, te títeca­panapa te Jerusalén, tiyana­na­varepa eta te Templo. Máimaha­rinehi ema Jesús ena achaneana tíjara­re­canahi eta sárareana, cáyureana. Ena apamuriana tivacha­re­canahi. Natiari­hivare ena títsiri­pe­re­ca­rahiana eta taplataneana eta apanapane avasareana. Tásiha, macuchu­chu­jicapa namutu. Máequehe­pui­chi­na­va­capaipa eta namesarana étapa eta nasiyana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nájinavare máisapa­que­né­nahini eta nánucu­hahini eta canchón tayehe eta Templo, námapahini jácani eta náijara­re­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tásiha, máimitu­ca­vacapa ena natiari­hi­que­neanahi. Ánipa máicha: —Ema Tata Nucaiyaquene, ani macahehi eta máechaji­ri­ruvahi te Sagrada Escritura: “Eta nupena tacarichu táicuchihi eta nayuja­ra­si­rareya ena achaneana tiásihana te tamutu avasareana” macahepa. Étisera eti tiámerahiana ecasia­pavapa eta te juca. Emaepe­ra­jicapa eta tacapi­ca­huirahi. ¡Eyana iúchuca­tataji! —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ena ticatia­na­canahi ema Jesús, te nasamai­ricapa eta juca máechaji­ri­ru­vanahi, tisemanapa. Tásiha, natanucapa eta jácani náichara­si­rayare eta náimica­pa­si­ra­yarehi éma. Taicha napica­rinehi éma, taicha náimahahi tétavi­cavahi eta masuapa­ca­revahi eta nayehe ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tacahe, te cápere­hi­chi­cha­rinehi, tiyana­varepa ema Jesús, tiúchuca eta te Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tacahe, te yática­rahipa, eta nachavi­ra­varepa eta te Jerusalén, náetavi­ca­pai­pa­hivare eta yucuqui higo. Náimahainehi tiájiri­quipahi éta. ");
INSERT INTO ignNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tacahe, téchavapa ema Pedro eta máechaji­ri­ru­vanahi ema Jesús cape sache. Tásiha, máichapa: —¡Pímaha, tata! ¡Tiájiriquipa eta higo eta pévaji­riaruhi! ");
INSERT INTO ignNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Majicapapa ema Jesús: —Ácasiñava yátupina eta me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jéhesare, éti apana esama­ca­re­yareva, te yátupina eta écasi­ña­vairaina eta me Viya. Tájina émaitu­caimahi. Erata­ha­yareva ecayejeca eta cerro te apachacaya, tájina iávami­ra­huimahi te esamureana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tacahe, numetacahe eta juca: Te eyasea­capuca ema Viya eta jácani, ecasiñava mayehe. Vahi ecueñamava eta ejaca­pi­rayare. Tásiha, tíjara­cahéna éma tamutu eta eyasea­ruanaya. ");
INSERT INTO ignNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Éneri­chuvare, eta eyuja­ra­siraina, eperdonacha éti nácani náejeca­pa­va­quenehi eta eyehe. Eperdo­na­chavaca apaesa maperdo­na­cha­hevare eta éjeca­pi­ravana ema Tata Ecaiyaquene te anuma. ");
INSERT INTO ignNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Téhesera vahi eperdo­nachahi, váhivare tiperdo­na­cha­hemahi eta éjeca­pi­ravana ema Tata Ecaiyaquene te anuma —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tiuri, títeca­pa­na­varepa eta te Jerusalén. Natupi­ru­varepa tiyanana te Templo. Te mapairi­ri­jue­charipa ema Jesús eta Templo, napauchapa ena ticatia­na­canahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nayase­recapa éma, ánipa naicha: —Píti, vahi vitupa­ra­ru­vi­nahini víti eta píchirahi eta júcana. ¿Nájahasica tímitu­cavihi? ¿Nájaha titupa­ra­ca­vianahi eta juca píchaque­neanahi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tacahe, majicapapa éma: —Núti apanava nuvaraha nuyase­recahe. Ejica­pa­nu­ya­resera apaesa numetacahe eta nucatu­pa­ra­hairahi eta níchirahi eta júcana. ");
INSERT INTO ignNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nájahapuca tivanecahi ema Juan eta máitesirahi máicacha­si­ri­si­rayare? ¿Émapuca ema Viya tivanecahi, émaji­va­hipuca eta máitesirahi? Ejicapanu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Váhisera náiturue­que­ne­hahini eta najica­pi­ra­yarehi. Tiácapae­ma­ji­ri­ca­canapa, ánipa nacahe: —¿Tájahasica vicaye­mayare eta vijica­pi­rayare ema maca? Te vémuna­hacava vicha: “Mavaneruhi ema Viya”, ema macahé­na­papuca: “Tásiha, ¿váhiyapa esuapahini éma?” ");
INSERT INTO ignNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Váhivare táurica víchahini: “Émaji­vaichucha eta máitesirahi”. ¿Tájahapuca vicaye­mayare eta vijica­pi­rayare? —náechaji­ri­cacapa. Nacahehi éna, taicha napica­racahi eta jácani náichara­si­ra­hipuca ena apamuriana achaneana, taicha namutuhi náimijachahi ema Juan profeta­quenehi yátupiquene mavaneruhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tacahe, najicapapa ema Jesús: —Vahi vecha víti —nacahepa. Ema Jesús máichavarepa: —Éneri­chuvare núti, vahi numeta­ca­hemahi nájahapuca ema titupa­ra­canuhi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tacahe, tépana­va­varepa tímitureca eta juca máimicu­ti­cha­quenehi. Ánipa macahe: —Matiarihi ema achane. Camuri eta máevaru uva te máesane, manarua­ca­hivare eta masucure. Máepiya­ca­varepa eta nacati­ca­re­si­hayare eta tachi eta uva. Máepiya­cavare eta torre, nápani­hayare eta najanea­si­rayare eta máevaru. Tásiha, máijaracapa ena achaneana, pártirá­rioa­na­yarehi. Taicha tiyana­yarehi ema achane te apana avasare. ");
INSERT INTO ignNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tacahe, te tiyahapa eta uva, máimiva­ne­recapa ema mamusura mayasea­pa­na­va­ca­yarehi ena pártirá­rioanahi eta tatuca­cha­que­ne­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Énasera ena pártirárioana tisemau­cha­va­na­richucha. Nacara­tacapa náehapa ema vanairucahi. Tichavapa éma, tájina náijara­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tacahe, tiápecha­vavare mavaneca ema apana mamusura. Váhivare nasuapahini éma. Natupi­sicapa eta te márijahiana, najara­sicapa. Náumeha­varepa éma vanairucahi. ");
INSERT INTO ignNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tacahe, ema achane mavane­ca­varepa ema apana mamusura. Tásiha, ena pártirárioana nacapacapa éma. Vuíchasera masemahini ema achane. Ticayehehi paciencia. Máimiva­ne­recapa ena apamuriana, camurianapa. Éneri­chuvare, tiápecha­vanapa náehava­ca­varepa. Nacapa­ca­vacapa ena apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tacahe, matiari­hi­cha­hasera ema apana mavane­ruyare. Émaja­ca­ruvapa máevataca ema machicha máemuna­ru­quenehi. Máimija­chaipahi émaina­hi­pucaini napicau­chahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Énasera ena pártirárioana, te náimahapa ema machicha ema achane, ánipa nacahe: “Émaina­papuca ticaye­heyare ema maca. Yare, vicapaca éma apanavare, apaesa tánasipa viyehe tamutu. Tájina máichara­ca­ha­vimahi ema achane­na­vaji” nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tacahe, nacara­tacapa ema machicha. Nacapacapa éma, náquiji­ca­pa­varepa eta máquehe te aneca tayehe eta úvaquiji. ");
INSERT INTO ignNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Puiti, nuyase­re­ca­heyare: ¿Tájahapuca máichara­ca­va­cayare ema achane ticayehe eta úvaquiji? Jéhesare, vaipa macaye­hehini paciencia. Títeca­va­nénapa macapa­pa­na­va­ca­yarepa ena pártirá­rioanahi máurira­hanahi. Tásiha, máijara­cai­na­varepa eta úvaquiji ena apamuriana pártirá­rioa­na­yareva. ");
INSERT INTO ignNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Nuvaraha epane­re­chapaini eta tacayemahi eta Sagrada Escritura, apaesa ácaicutiara éti. Ani tacahehi: “Ena tépiya­re­ca­rahiana eta Templo, tasapiha náepuruhi eta mari táicuchihi tatumea­rayare eta peti, taicha vahi náimatihini. Émasera ema Viya macaitecapa eta te táicuchihi eta tatupa­rahahi. Tacapi­ca­hu­quenehi puiti. Táitusiava tétavi­cavahi eta vicuna­chirahi víti ema Viya” tacahehi eta Sagrada Escritura. Nuvaraha ecaicu­tiaraya —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tacahe, ena ticatia­na­canahi ema Jesús, eta nasamirahi, tisema­na­rinehi taicha tímatia­ca­vanapa eta énairahi tayuna­cavaca eta máimicu­ti­chi­ra­vacahi. Eta nasamirahi, tisema­na­rinehi. Navarahapa nacara­ta­ca­ya­rehíni. Tipica­ca­va­na­chu­chasera nayehe ena achaneana, nacatiu­chahini ema Jesús. Tacahe, najuni­jiacapa éma, tiyananapa natanuca eta táichara­cavaya eta nacara­ta­si­rayare éma. ");
INSERT INTO ignNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tacahe, ena ticatia­na­canahi ema Jesús navanecapa ena témeje­ca­pa­ca­cha­nayare apaesa étaina­hi­pucaini taviuchahini ema Jesús. Natiarihi ena tinere­ji­ca­vanahi ena fariséoana. Natiari­hivare ena políti­coana. ");
INSERT INTO ignNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Te náiteca­pauchapa, ánipa nacahe: —Tata maestro, vímatihi eta tatupi­ru­vairahi tiuri eta juca pímitu­ra­pianahi. Vahi pipica­ca­ra­ca­vahini eta péchaji­si­hairahi eta náichava­que­nevahi nácani achaneana, tayana­pa­nepuca aquenucahi. Taicha pivaraha náehicahini namutu eta táurinaquene achene ticaijuhe me Viya. Vivara­ha­hisera viyase­re­ca­viyare eta pipane­reruhi: ¿Táurica­hipuca vivachacha eta viyasehana impuesto mayehe ema Presidente Emperador romano? Taicha víti, machane­ra­hávihi ema Viya, ¿masi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Máimati­va­ne­hisera ema Jesús eta apimi­rai­ra­vacahi éna, navarairahi ticaviu­re­yarehi éma. Tásiha, ema máichavacapa: —¿Tájaha tacayema evaraha ímiaqui­paicanu? Nímahaseji, iáminanu étapena eta reale —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Éna náijaracapa eta reale. Tásiha, máichavacapa: —¿Nájaha ticaijare eta juca? ¿Nájahavare ticava­simahi eta juca mirare eta te juca reale? —máichavacapa. Éna najicapapa: —Mayehe ema Presidente Emperador —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tacahe, máichavarepa: —Tiuri. Táuricahi íjaraca ema Presidente Emperador eta juca mayehe­richuhi éma. Tásiha, íjara­cavare ema Viya eta mayehe­ri­chu­hivare éma —máichavacapa. Te nasamapa ema Jesús eta majica­pi­ra­vacahi, náramipa eta máitupa­ji­jia­si­ravahi. ");
INSERT INTO ignNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nacahe­pai­pavare ena apamuriana achaneana. Saducéoa­nahi. Ena nani saducéoana, apanahi eta náimitu­rapiana. Éna, vahi nasuapa eta náechepu­si­rayare ena náepena­queneana­. Tiyananapa náimaha­panahi ema Jesús. Ánipa nacahe: ");
INSERT INTO ignNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tata maestro, ema víyarahaini Moisés manaquicahi eta ajureca máechaji­ri­ruvahi eta viyehe: “Te máepenae­que­ne­ha­hipuca ema achane esu mayena, tásiha, nájina­hipuca manaquie­que­ne­ru­vai­nahini machichai­nahini, te matiari­hi­hipuca mácani maparapehi, mavehayare esu machine­nae­quenéni, apaesa émainapuca macachicha eta suyehe, máitsivai­nahini ema maparapeni”. ");
INSERT INTO ignNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tacutiquene te natiari­hipuca ena siétequeneana ticapa­ra­pe­ji­ri­cacana, te títauchavapa ema náechavimuri. Máepenae­que­ne­ha­pasera esu mayena. Nájinahi machichai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tacahe, ema maparape máitauchavare esu machinena. Éneri­chu­va­resera máepenae­que­ne­havare, nájinavare machichai­nahini. Ema émana maparape máitauchavare ésu. Éneri­chuvare máepenae­que­ne­havare. ");
INSERT INTO ignNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Namutu ena siétequeneana navehahi ésu, tásihasera náepenae­que­ne­ha­paichucha, nájinaquene émanai­nahini mácachi­chahini eta suyehe. Te táequenepa, tépenapa esu esenaini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tacahe puiti, te apana­papuca eta náitare­si­rayare ena nani, ¿nájahapuca ena siétequeneana éma yátupi­quenehi suímaquenehi esu esena, taicha ena siétequeneana namutuhi suímanarihi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tásiha, ema Jesús majica­pa­vacapa: —Éjecapava éti. ¿Tájaha tacayema vahi evaraha ácaicu­tia­rahini eta táimiturapi eta Sagrada Escritura? Váhivare evara­hahini esuapahini eta tamutuirahi marataha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ánaqui te apana náitare­siraya, vaipa nácamu­nuimahi esu esena. Énaripa ena esenana váipavare nácamu­nuimahi ema ajaira. Nacutinapa ena ángeleana tiávihanahi te anuma eta vahi náitaucha­ca­cahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Éti, váhiva­repuca ácaicutiara eta yátupirahi eta vahi táepenahini eta náchanevana ena náepena­queneana. Váhipuca ácaicutiara eta máechaji­ri­ruvana ema Viya májucha­que­neanahi ema víyarahaini Moisés. Te juca Sagrada Escritura, eta te libro ticaijare Éxodo, téchajicapa ema Viya. Ánipa macahe: “Nútira yátupi­que­nenuhi Viya, macasi­ña­quenehi ema Abraham, ema Isaác émapa ema Jacobo” macahepa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nutupi­ruvahi numetacahe­: Ema Viya, éma téchahi eta náitare­sirana ena téhicanahi, tayanapane tépena­na­ri­papuca. Eta náchanevana, tímiya­na­va­na­richucha títareca te mamirahu éma. Éti, ichape eta éjeca­pi­ravahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tacahe, matiari­hi­hivare ema émana escribáno. Masama­ra­racahi eta nacana­ra­ji­ri­si­ra­cacahi. Máimati­vanepa eta táurivahi eta majica­pirahi ema Jesús. Tásihasera, tíjara­cavahi mayasereca ema Jesús, ánipa maicha: —Tata, nuvaraha pimeta­canuini ¿tájahapuca eta vanairipi tisuapa­ca­re­panahi tayehe eta mavanai­ripiana ema Viya? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Majicapapa ema Jesús: —Eta máechaji­riruva ema Viya te Sagrada Escritura, ani macahehi: “Esama, emutu eti achaneana israelítana. Nuti Viya, nucarichuhi nuti Iáquenu. Nacuija apanaina iáquenuina esiña­rajina. ");
INSERT INTO ignNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tásiha, yátupina eta émuna­si­ranuina nuti Iáquenu, táunasiraina te esamureana. Yátupina eta ecacha­ne­vai­ranuina núti. Epanerecha eta nímitu­rapiana tamutu sácheana, yátiana. Yátupina eta ecaema­ta­nea­siranu te tamutu eta ítupa­ji­jia­si­ravana”. ");
INSERT INTO ignNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jarari­hivare eta apana táehiruhi eta juca, ánivare tacahe: “Pémuna­cayare ema piparae­piyahi, tacuti eta pémuna­si­ravahi píti”. Eta juca apinaquene vanairipi, tacachurica eta tasuapa­careva tamutu eta apamuriana vanairipiana —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tacahe, máichapa ema escribáno: —Yátupiquene, tata maestro, tétupi­cavahi eta péchaji­riruva. Yátupihi eta macari­chuirahi ema Viáquenu, eta nájinairahi apanai­nahini Viáquenui­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yátupi­hivare tavaraha eta vémuna­siraina ema Viáquenu, étapa eta viúnasi­rayare te visamure, étapa eta vipane­re­chiraina eta máimitu­rapiana tamutu sácheana, étapa eta vicaema­ta­nea­siraina éma te tamutu eta vítupa­ji­jia­si­ravana, étapa eta vémuna­siraina ema viparae­piyahi. Jéhesare, eta táuriva eta vémuna­sirahi táetavicahi eta táuriva eta víjara­ca­sichira eta sárareana eta víjucha­queneana eta me Viya. Táetavi­ca­hivare tayehe eta táuriva tamutu eta apamuriana viámavahuana eta me Viya —máichapa ema escribáno. ");
INSERT INTO ignNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ema Jesús máimatie­que­nehapa eta táuriva eta majicapira ema achane. Tásiha, máichapa: —Píti piánehi eta píjara­si­ravaina eta péhisi­rayare ema Viya —máichapa. Tacahe, nájinapa náijara­ca­vahini nayase­re­cahini ema Jesús eta náemeje­ca­pa­va­chi­ra­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tacahe, ema Jesús tímiyanava tímitu­recahi, eta máejasirahi eta te Templo. Ánipa macahe: —Ena escribá­noana, ani tacahehi eta náimitu­rapiana: “Tiúchucayare ema Cristo, mámarie­que­neyare ema víyarahaini rey David” nacahehi. ");
INSERT INTO ignNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yátupihi ema Cristo achane­quenehi eta máimahi taicha mámarié­que­nénihi ema víyarahaini David. Nuvara­hasera epane­rechaya eta juca máechaji­ri­ruvahi ema David te májurehi Salmo, ani macahehi: “Ema Viya máichapa ema Tata Náquenu Cristo: Yare péjaca te nuvaure, eta picucha­pi­hayare eta nucaepu­yu­siraya te pimirahu ena ticatia­na­ca­vianahi” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ema David, eta máimija­re­chirahi ema Cristo, “Tata Náquenu”, ¿tájahapuca eta macaye­ma­quenehi? Núti németeaca Víyahivare ema Cristo. ¿Tájaha íchahi éti? —máichavacapa. Ena camuri­queneana achaneana náuricahi eta nasama­raraca eta máimitu­rapiana ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tímiya­navahi eta máimitu­re­sirahi ema Jesús, ánipa macahe: —Échapa­vayare éti, machu éhica eta nayehe­repiana ena escribánoana taicha tétavi­cavahi eta apimi­ra­nairahi éna. Tétavi­cavahi eta náurisirahi éna tiúmajihána, navarairahi ticuna­cha­ca­rea­na­yarehi nayehe ena achaneana eta nareli­gió­so­vanahi. Navara­havare ticapi­ca­hua­na­yarehi eta náechaji­siraya ena achaneana te jácani nácapa­ji­si­hapahi éna. ");
INSERT INTO ignNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tacutiquene tinere­jiu­ru­cavana eta táurina­queneana téjasi­ha­careana, te tiyanana te viúruji­si­ra­revana. Étaripa te nanisirana, ticaeja­ca­va­navare te jácani tiávihanahi eta tiúrini­sipana tinicacare. ");
INSERT INTO ignNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tacutiquene navere­ji­cavare eta nacaye­he­queneana ena tépenaimana, nájina najapa­nu­quenéna. Tásiha, tépiya­ca­vanapa religió­soanahi, tiúpiemána eta nayuja­rasira, namava­rairahi tácaeche­rahini eta náichira­que­neanahi eta tamauri­queneana. Énasera tiápaju­ca­vanahi eta náicuña­yayare muraca —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Eta máejasihahi ema Jesús, mávihahi te tamirahu eta chapamana eta nanaca­cui­rarehi eta plata námavahuana ena achaneana. Máimararaca ena camuri­queneana eta nanacacuira eta námavahuana. Natiarihihi ena rícoana, tinaqui­ca­va­napahi eta ichape­mu­ri­pa­navaca. ");
INSERT INTO ignNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tacahe, títecapapa esu esena suépenai­maquene, páurehi ésu. Sunaquicahi eta apipe­chichahi eta suplatane, váhirichu tasiva­chahini. ");
INSERT INTO ignNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tásiha, ema Jesús, eta máimairahi eta juca, máichuha­muripa ena máimitureana. Ánipa maicha: —Ímaha esu suca esena páurechicha. Ácuneucha eta suémuna­sirahi ema Viya. Jéhesare ésu, tímepa­návahi eta sunaquiruva, sucachu­ri­ca­vacahi namutu ena apamuriana achaneana. Ichape­rinehi eta sucuna­cha­ca­revahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Taicha namutu éna, tacarichu nanaquicahi eta náemacha­rajiana naplataneana. Ésusera esu suca páurehinéni, sunaqui­ca­hisera tamutu eta sucaye­he­quenehi. Suítahi eta suníca­va­cha­ya­rehíni —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tacahe, tiyana­ya­rehini ema Jesús, énapa ena máimitureana. Eta náuchusiraya tayehe eta Templo, máichapa ema émana máimiture: —¡Tata maestro! ¡Pímaha eta juca máriana! ¡Tétavicava eta táichapeva! ¡Tétavicava táurinava eta juca peti! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ema Jesús majicapapa: —Tamapu­ru­jiyare eta juca táurinava eta pétisami ímaha­quenehi puiti. Nutupiruva numetacahe: Járaja­payare eta sácheyare ticaqui­pai­ca­siyare tamutu eta juca Témplosami. Téjane­re­pai­cainapa tamutu eta juca táurina­que­neanahi ímaha­que­neanahi puiti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tacahe, tiyananapa eta te cerro ticaijare Olivoquiji, távihahi te apacharahi eta te tatava­rapihi te tamirahuhi eta Templo. Te téjacanapa nacarichuhi eta te jena quinta, nayase­recapa eta macaye­ma­quenehi. Matiarihi ema Pedro, émapa ema Jacobo, émapa ema Juan, émapa ema Andrés. Ánipa náicha: ");
INSERT INTO ignNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Vivaraha pimeta­cahavi. ¿Tájamu­hupuca eta náimiaqui­pai­si­rayare eta Témplosami? ¿Jarari­hi­ya­repuca eta ecutia­ra­reyare te tánehipaicha eta táitauchi­ra­vayare eta apana péchaji­si­ha­queneana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tacahe, majicapapa ema Jesús: —Ecuneu­chavaicha yátupina, machu navayuacahe, taicha náraja­payare ena tépiya­ca­va­na­ya­repahi tímiva­si­cha­va­nayare nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nacahe­ya­repahi éna: “Nútiripa Cristo”. Nasapiha, navayua­cayare ena camuriana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","Éneri­chuvare esamai­ri­ri­cayare eta táehaca­cai­rayare eta ichape­queneana avasareana. Ticana­ra­ji­ri­ca­ca­nainapa eta te avasareana tayere­hi­queneana, éneri­chuvare ticauya­ya­ca­renapa guierraina eyehe éti. Váhisera ecuarameca eta esamai­ri­ri­siraya, taicha ene tacaheyare eta táepani­ra­vayare eta ecutia­ra­rea­nayare. Vuíchahasera étaimahi eta táichecui­rayare. Éneri­chuvare tatiari­hi­yareva eta ichape tayamu­ri­si­ranaya eta apaquehe te jácani távihanaya táitupia­rua­nayare. Tatiari­hi­yareva eta ichape ecuha­mu­hu­yareva te jácani avasareana. Ichape eta nacata­ji­vai­rayare ena achaneana. Tamutu eta juca ecutia­ra­rea­nayare eta táepani­ra­vayare eta nátaji­va­nayare ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tásihasera eti nuchane­ranahi, ecuneu­cha­vayare, étume­cha­vayare. Taicha natiari­hiyare ena ticatia­na­ca­hea­nayare táichavenehi eta éhisi­ranuhi. Ticara­ta­ca­hea­nainapa, ecaya­se­se­re­hinapa nayehe ena juéseana. Téstaca­hea­nai­napava eta te náuruji­si­ra­revana. Tásiha, etiari­hiyare éti tiámaheanaya te namirahu ena aquenucana, téhevare te namirahu ena Presidenteana gobiernoanahi, ecaviu­re­vayare táichavenehi eta éhisi­ranuhi. Esapi­hasera éti, ecama­pu­ra­vainapa échaji­sia­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Éneri­chuvare, éti nuchanerana ecame­ta­rai­ru­yareva eta tiúrina echaji­ri­rucava nayehe ena achaneana tayehe tamutu avasareana te juca apaquehe. Te ítecapapa te tamutu, tépana­va­yarehi eta táichecui­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tacahe, te jácani nacara­ta­ca­he­papuca, námahe te namirahu ena aquenucana, vahi ecueñamava tayehe eta jácani échajiu­chi­ra­vayare, ecatiu­chi­ravaya. Échaji­sihaya eta échaji­ri­ru­cavana máijara­ru­heyare ema Espíritu Santo te jena sache. Taicha máimaha­heinepa. Tíjara­ca­heyare eta ítusi­rayare échajica. Vahi étiji­vaimahi eta échaji­siraya. ");
INSERT INTO ignNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Natiari­hi­yareva nácani achaneana tíjara­re­canaya ena napara­pe­queneana, navarairahi náimicapaca táichave­nénahi eta náehisi­ranuhi núti. Natiari­hi­yareva ena nácani náiyana, navara­ha­yareva náijarareca ena nachicha­naveana táichevenehi eta náehisi­ranuhi núti. Natiari­hi­yareva nácani nachicha­naveana nacana­rainapa ena náiyana, náimica­pa­cainapa táichavenehi eta náehisi­ranuhi núti. ");
INSERT INTO ignNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Namutu­yaréni ena achaneana ticatia­na­ca­hea­nayare táichave­nénahi eta éhisi­ranuhi. Téhesera ecamichahi tamutu, ímiya­navahi eta éhisi­ranuhi te táitavapa tamutu, núti nucuchu­cu­ha­heyare. ");
INSERT INTO ignNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Numeta­ca­he­va­nevare eta apana. Járaja­payare eta sache táiñehi­que­neyare. Tímere­ca­vayare ema achane váinara­jiquene. Mavane­cayare ena machanerana náechipe­ji­si­rayare eta tacapi­ca­hu­quenehi Templo, nacuchu­ca­va­cayare ena téhicanahi ema Viya. (Nácani navaraha nacaicutiara eta juca, tacamunuhi ticara­va­huyare eta májurehi ema víyarahaini profetaini Daniel.) Tásiha te ímahapa eta juca, esamai­ri­capuca, táuricapa etátájipa ejunavane, eti etiari­hi­que­neanahi te Judea. Ecaiju­heyare eta te cérroana, étaina eyumu­ru­siavaina. ");
INSERT INTO ignNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nácani tiávihanahi te nayehe canchón te nasamai­ri­ricapa eta juca téchacarehi, táuricapa najunavane. Vaipa táuricahini nasiapa­numahi te napenana, navehahini jácani náeñama­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nácani tachima­ra­rua­nayare te vámahi eta téchacarehi, táuricapa vaipa nacuchava tayehe eta avasare, tayanapane náeñamahi eta nayere­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Páureanasami nácani esenana tachima­ra­rua­nayare nácani ticaja­ria­na­hipuca, nácani esenana ticachi­chanahi eta amuya tiájicachaha! ");
INSERT INTO ignNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eta tacahe, eyasea­cayare ema Viya tacuija táichejicahe; váhivare tacuchi­ma­racahe eta ichape tiquiva te achene te eyana­papuca ejuna­. ");
INSERT INTO ignNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te jena sácheanayare, tétavi­ca­vayare eta nacata­ji­vai­ra­yarehi ena achaneana. Tájina tácutimahi eta táiñehi­vayare eta nacata­ji­vai­rayare, te táepani­ravahi eta máepiya­sirahi ema Viya eta juca apaquehe. Te táequenenapa eta tíñehiyare, tájinainapa tácutimahi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nájina tacaiti­ruimahi eta nacata­ji­vai­ra­yarehi ichape. Macaiche­ca­va­neyare ema Viya eta masemavahi ema maca achane váinara­jiquene, mavarairahi ema Viya macuchu­cu­havaca ena machanerana manere­jiruana, majapa­nu­que­nea­na­hivare. Taicha te vahi macucaicheca ema Viya, máitamu­ri­ha­hi­pucaini macapa­pa­ji­cavaca namutu ena achaneana ema maca achane. ");
INSERT INTO ignNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Éneri­chuvare te tánehipaicha eta juca, natiari­hinapa ena tivayua­rahiana tépiya­ca­va­nayare Cristo tímiva­si­cha­va­nainapa núti. Natiari­hivare ena tímicu­ti­ji­ri­ca­va­nayare profetana mavane­rui­nahini ema Viya. Áninapa nacaheyare: “Yare, éhicayare ema Cristo. Matiari­hipahi te juca vitaracu”. Ena apamuriana ánivare nacaheya: “Náepiya­hi­raivahi éna. Ema Cristo mávihahi te viávasa víti”. Étisera vahi ecusua­pavaca. Eta navarairahi tivayua­ca­heanaya eti machanerana ema Tata, náiturue­que­ne­hayare naicha eta ichape­queneana tiárami­careana ecutia­ra­rea­nayare. Camuria­na­sa­miyare ena navayua­rua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tásiha, ecuneu­chavaya nayehe. Numeta­ca­he­vanehi puiti apaesa écharipa —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Máichavarepa ema Jesús: —Te jena sácheanayare te táequenénapa eta jena nacata­ji­vai­rayare ichape ena achaneana, eta sache témahainapa, étaripa eta caje váipavare tijara­himahi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Témiri­ca­nai­na­varepa eta jarairiquiana. Étaripa eta tiávihanahi te anuma vimaima­ha­que­neanahi, éneri­chuvare tiyamu­ri­ca­nainapa, tiyeje­je­ca­va­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nupaenu­ma­vainapa níteca nuchava núti Manere­ji­ru­nuhi ema Viya. Namutu tímaha­nua­nayare eta núcupai­si­rayare. Tiámanui­napaipa eta úcaji. Tétavi­ca­vayare eta nujarai­va­ya­repahi, níñehi­napaipa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tacahe, nuvane­cainapa ena ángeleana nacuru­ji­cayare namutu ena nuchanerana nunere­ji­ruanahi, tiásiha­nayare te tamutu eta juca apaquehe te jácani návihahi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tiuri puiti, nuvaraha nímicu­ti­chinahe eta jácani yucuqui. Eta táitsiva­chi­ra­va­vacapa eta tapacajiana, te ímahapa eta tajimu­yairapa eta tatavaqui, tiúchuca­yarepa eta tapaca­jianaya arairu, tímati­carehi tiánehiripa eta únemu­hui­ra­yarepa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ene tacahehi, te ímaha­yarepa tacaecherapa eta júcana ecutia­rareana, ímaha­yarepa eta tánehi­rainapa eta nuchavira. ");
INSERT INTO ignNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Numeta­ca­he­vanecha: Vuíchaha títava­naimahi ena achaneana náitare­rua­naichaha te táitecapapa eta júcana ecutia­ra­rea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Títavainapa eta anuma étapa eta apaquehe. Tativa­ya­resera títauchava tamutu eta numeta­ru­heanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Eta juca tiárami­ca­re­ya­rechucha. Nájina téchaimahi tájamu­hu­ya­repuca eta táitauchi­ra­vayare, énaripa ena ángeleana vahi náechahini. Nútiva­ne­ré­ca­hi­pucaini néchahini. Macarichu ema Tata, éma téchahi. ");
INSERT INTO ignNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Eta tacahe, etsecavahi ecaune­hivare éti, eyuja­rau­cha­va­yareva. Taicha vahi echa eta tájamu­hu­ya­repuca eta nítesi­ra­yarepa. ");
INSERT INTO ignNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","36","Tamutu eta juca nímicu­ti­chinahe eta máichaquenehi ema mácani achane eta te tiyanayare tipairirica. Te tiyana­yarépa, máijara­cavaca namutu ena mamusurana eta náemataneana, matupa­ra­ca­vacapa eta najanea­si­ra­yarehi tamutu. Tacahe, matupa­ra­ca­varepa ema tijanea­re­carahi eta tapaja, macune­yarehi eta jácani hora machavira ema máquenu, téhepuca timapi­cu­cuhipa, téhepuca enumuhu yati, téhepuca tijara­ra­hi­yarepa, téhepuca yáticarahi. Ene ecaheyare éti. Ecauneya machu níjahúchava níteca­pauchahe, machu nuchima­racahe ímaca­caruhi. Taicha vahi échaimahi tájamu­hupuca níteca­payare nuti Iáquenu. ");
INSERT INTO ignNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eta juca numeta­ru­heanahi puiti, nuvaraha emeta­ca­ya­revare ena echamuriana, apaesa ecauneyare emutu —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tacahe, apina­rinecha sache eta piesta ticaijare Pascua, eta náepanavaira eta semana eta nanisirahi étachucha pan mayehere levadura. Tacahe, ena tuparai­rucana énapa ena escribánoana navara­haipaicha náimicapaca ema Jesús. Tásiha natanucahi eta táichara­cavaya eta nacara­ta­si­rayare. Váhisera navaraha eta naneca­pahini ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ánipa nacahe: —Vuíchaha vicuca­rataca éma achichu juca piéstairaya. Taicha camuria­na­yarehi ena achaneana, machu tájahapuca náichara­cahavi taicha navara­ha­yarehi nacatiucha éma. Vicuchapa nayananuma —nacahepa. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tacahe, ema Jesús tiyanapa tichava eta te avasa­rechicha Betania. Máichuha­quenehi eta manani­siraya mayehe ema achane ticaijare Simón ema leprosoinihi. Tacahe, eta manisirahi, sucahe­paipahi esu ésuna esena. Suámapahi eta perfume te bótechicha. Ticaijare nardo eta juca tíjiyeama amairiama. Táetaviuchahi eta tasiva­chavahi. Supauchapa ema Jesús. Suvechu­jihapa eta bótechicha, tásiha, suépusa­sicapa eta táijiyea­maquene perfume. ");
INSERT INTO ignNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Natiari­hisera ena váhiquene náuricahini eta suémepu­ru­re­sirahi eta tasiva­chaquene perfume, suámasi­chirahi ema Jesús. Ánipa nacahe: ");
INSERT INTO ignNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","—¿Tájaha tacayema suémepu­rureca eta juca tasiva­cha­quenehi perfume? Tiúripa­nahini víjara­re­cahini eta juca táijiyea­ma­quenehi. Vivehahini eta camuriquene plata, tásiha, vímica­ta­si­hahini ena páureana. ¡Máechema­rai­rahahi esu suca esena! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Émasera ema Jesús máuricapa eta suíchaquenehi. Ánipa máicha: —Ésamirica esu suca esena. ¿Tájaha tacayema ecaecahihi éti esu suca? Tétavicava eta táuriva eta suíchiranuhi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ena páureanasami, támutuchucha sácheana eta ecacha­ne­ra­va­cayare éna. Te jácani ávara­ha­papuca ímica­ta­cayare, nararihi ena ticamunuana. Nútisera vahi nánasi­que­némahi eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Esu suca suíchahi eta suímira­ta­ha­ruvahi. Eta juca suépusa­ha­si­ranuhi eta juca perfume. Sucaina­pucahi ésu eta suíjiye­chirahi eta náquehe tayehe­yarehi eta nucaeca­ra­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nutupiruva numetacahe: Nácani ticame­ta­rai­rua­nayare eta tiúrina echaji­ri­rucava, náechaji­si­ha­ya­revare eta juca suíchaquenehi esu suca esena. Témecha­nayare suyehe te tamutu avasareana te juca apaquehe —macahepa. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tacahe, tiyanapa ema Júlasi, émarichuhi nachamuri ena dócequeneana ­ apóstoleana. Mapauchapa ena tuparai­rucana, téchaji­ri­panava eta máijara­re­si­rayare ema Jesús eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tacahe, tiúrisa­mu­rea­narine ichape eta nasamirahi eta mavarairahi máijara­re­cayare ema Jesús. Tásiha, nametacapa eta náijara­si­ra­yarehi eta plata. Tásiha, jéhevarepa ema Júlasi matanucaipa eta máichara­ca­yarehi eta máimica­ra­ta­si­ra­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tacahe, títecapapa eta piesta Pascua, te tépanavahi eta semanahi nanicahi eta pan mayehere levadura. Étarichuhi eta sáche nacapa­sihahi eta uvesachicha naniru­yarehi te yátipa. Ena máimitureana nayase­recapa ema Jesús: —¿Táviha pivarahahi vácaijuhe eta vétupi­risiava eta vinisi­rayare eta uvesachicha eta viyeherepi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tacahe, mavanecapa ena apinana máimitureana. Máichavacapa: —Eyana tayehe eta Jerusalén. Te íteca­pa­yarepa tayehe, iácapa­ji­cayare ema émana achane tiámapahi eta une te yupi. Éhicayare éma. ");
INSERT INTO ignNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eta te peti masiapi­hayare, éti apana esiapa­yareva. Tásiha, emeta­cayare ema ticayehe eta peti, ani íchayare: “Ema viyehe Maestro tivane­ca­havihi viyase­re­panavi pímechahavi eta cuarto vinisi­hayare eta uvesachicha eta viyeherepi, vicacha­neyare éma” íchayare. ");
INSERT INTO ignNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tásiha, éma tímecha­hénapa eta ichape cuarto te anuquehe piso. Táurique­néipahi eta jácara téjasi­ha­careana, tacaetu­pi­ri­hi­que­neripa. Tásiha, étupi­ricapa eta viniruyare eta ánaqui —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tacahe, tiyananapa nacaijuhe te Jerusalén ena apinana vanairucana. Jéhesa­reinehi náimahapa étapaichuhi eta macaye­ma­que­neanahi ema Jesús. Tacahe, náetupi­ricapa eta naniruyare tayehe eta Pascua. ");
INSERT INTO ignNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tacahe, te yátipa títecapapa ema Jesús macacha­nepaipa ena apamuriana apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eta náejasi­ra­ripahi tinica­naripa, máichamuripa éna ema Jesús: —Jéhesa­reinehi, te etaracu éti, mararihi ema émana tíjara­re­ca­nuyare, émarichu tinicahi nucachanehi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tacahe, ichape­rinehi eta máimipa­ne­re­re­si­ra­vacahi éna eta juca máichira­vacahi. Nayase­recapa ena émanapachu, ánipa náicha: —¿Nútichupuca jácani? —macahepa ema émana. —¿Nútichupuca? —macahe­varepa ema apana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tacahe, majicapapa ema Jesús: —Ema émana te etaracu eti dócequeneana. Mácani néniruyare eta pan néchipae­jiruhi te juca nucuruja, émara ema tíjara­re­ca­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nuti Manere­ji­ru­nuhi ema Viya, étapaichuhi eta nacapa­si­ra­nu­yarehi, títaucha­va­yarehi eta nuyehe eta táechaji­ri­ruvahi eta Sagrada Escritura. ¡Páuresa­misera ema tíjara­re­ca­nuyare! ¡Muracayare eta máicuñayare! ¡Tiúripa­nai­chuhini te vahi macuchu­cahini te sujuhe esu máena! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tacahe, eta nanisirahi, mavehapa eta pan ema Jesús. Mahasu­lu­pa­yachapa ema Viya. Mayuve­tucapa máijara­ca­vacapa ena máimitureana. Tacahe, máichavacapa: —Eta juca néche. Enica —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tacahe, maveha­varepa eta vasu náerirare, mahasu­lu­pa­ya­cha­varepa ema Viya. Tásiha, máijara­ca­varepa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te náerapaipahi, máichavacapa: —Eta juca eta nítine. Éta táepusai­ru­vayare étari­chuvare táicutia­rayare eta nufirma­chi­ra­heyare eta arairu matratune ema Vicaiyaquene, nucaeja­si­ra­yareva eta matratune apaesa ejaca­pacare mayehe, ichape­mu­ri­va­ya­repahi éti. ");
INSERT INTO ignNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jéhesa­réi­ne­hisera, numetacahe: Vaipa nápecha­váimahi nérahi­varéni eta juca tachi eta uva, tiámainucava te táitauchavapa eta nusiapiraya eta nucava­cu­reiraya, nucaju­pa­hairaya ­ ema Tata Nucaiyaquene. Te jena sache, níjara­caheya vérainapa eta aramaruama —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eta náitane­sirapa, tijiranapa eta jirasare eta nahasu­lu­pa­ya­chirahi ema Viya. Te títapi­ri­canapa, tiúchucanapa, nacaijuhepa eta te huerta Getsemaní tiávihahi eta táemiri­pai­sinehi eta cerro ticaijare Olivoquiji. ");
INSERT INTO ignNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Eta napaisi­rapahi, máichavacapa ema Jesús: —Puiti juca yati ejuni­ji­ca­nuyare emutu éti, taicha epicayare eta náichara­si­ra­nu­yarehi. Tásiha, títaucha­va­yarehi eta máechaji­ri­ruvahi ema Tata eta te Sagrada Escritura: “Nísapayare nacarataca ema Pastor, nacapa­si­ra­ya­resami. Tásiha, tijuna­ra­ca­nainapa eta uvesana macuru­ji­rua­nai­nihi” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Téhesera te néchepucapa te nécari, nínapu­cainapa nuyanainapa te Galilea. Ánaqui nucucha­pia­heyare éti —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Émasera ema Pedro máichapa: —Tayanapane, Tata, najuni­ji­ca­vipuca ena apamuriana, nútisera vahi nujuni­ji­ca­vimahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ema Jesús máichavarepa: —Nutupiruva numetacavi pítisami Pedro: Puiti juca yati, te apíhénapa eta táechaji­si­rayare eta varayu, mapahe eta pépiya­si­ra­vayare vahi pímatinu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ema Pedro tijara­nurusi eta majica­pirahi. Ánipa macahe: —Tayana­pa­nepuca pímica­pacanu, váhique­nesera népiya­ca­vaimahi vahi nímativi, váhivare nínajia­ca­vimahi —máichapa. Étari­chu­hivare tacahehi eta náechaji­ri­ruvahi ena apamuriana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tacahe, títeca­panapa eta te quinta Getsemaní. Tacahe, máichamuripa ena máimitureana: —Éjacaichaha eta ani te juca. Ecucha­pa­nuchaha. Núti nuyuja­ra­pa­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tacahe, mámapa ánaquipana ema Pedro, émapa ema Jacobo, émapa ema Juan. Tépanavapa téñamava eta masamure, taicha muraca eta máichava­que­né­va­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tacahe, máichavacapa éna: —Tétavicava eta táeñamirava muraca eta nusamure. Tavaraha ticapacanu. Ánasichaha ani te juca. Váhisera ecuimaca. Ecuneu­chanuhi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Tacahe, tipaipanapa ánaqui­pa­na­chichahi éma. Tiáquipai­cavapa eta te apaquehe. Eta mayuja­ra­sirahi, ánipa macahe: —Tátachicha Nucaiyaquene, píti pirataha tamutu. Picata­ji­ca­nupaini. Váhini tacuitau­chavaini eta níchava­que­ne­vayare. Váhini picuisapaini eta nucata­ji­vairaya. Níjara­ca­vasera núti eta nítauchiraya eta pivara­ha­quenehi píti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tásiha, téchepucapa. Tichavapa eta te návihahi ena máimitureana. Máimaha­rinehi éna, tímaca­na­richucha. Máichapa ema Pedro: —Piti Simón, ¿pímaca­richucha? ¿Tájaha tacayema pímacahi? Váiparinehi pímica­ta­ca­nuhini pijanea­ca­nuhini étanai­na­hi­pucaini hora pácahehini. ");
INSERT INTO ignNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Éjamiuchava. Eyuja­rauchava apaesaina. Eyaseaca ema Viya eta etumevaina apaesa vahi macuitu­rucahe ema Satanás. Yátupi­hinéni eta iáchanevana taratahahi ticara­tacava. Étasera eta éche máteji, vahi tarata­haimahi ticara­tacava —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tacahe, tiápecha­va­varepa tiyana tiyujaraca. Eta mayuja­ra­sirahi, étarichuva eta máechaji­ri­ru­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tásiha, tichava­vanepa eta te návihahi ena máimitureana. Máimaha­varepa tímaca­na­ri­pavare, taicha muracaripa eta náechapune. Tájinavare nacaye­mahini táichavenehi eta natsirirahi. Tacahe, tiyana­varepa tiyuja­rapana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te mapahe­quenepa eta mayuja­ra­sirahi, tichavapa. Máichavacapa: —¿Iápecha­vaipava ímaca? ¿Vuíchahapuca enara­ha­ca­que­né­nahini? ¡Taratapa! Jéhesare, puiti títecapapa eta nutupa­rahahi nacara­ta­si­ra­nuyare ena ticatia­na­ca­nuanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ávane ema tíjara­re­ca­nuyare. Échepuca. Viyana viácapavaca —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Téchaji­ri­ca­vaichaha ema Jesús, macahe­painecha ema Júlasi. Mámamu­ri­ha­paipahi ena camuri­queneana suntaruana. Ticaepu­chi­ri­quia­na­paipahi, étapa eta nayeheana espada. Éna, vanairu­canahi nayehe ena ticatia­na­canahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ema Júlasi, tatiarihihi eta máicutia­ra­yarehi eta náimati­ra­yarehi ena suntaruana ema Jesús. Ani tacahehi eta máechaji­ri­ruvahi ema Júlasi: —Ecune­nuyare. Ema nétsera­re­ruyare, éma ecara­tacaya. Machu ecaitica, muraca eta ecara­ta­siraina —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te títeca­panapa, mapauchapa ema Júlasi ema Jesús. Máichapa: —Yátiheipa, tata Maestro —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tásiha, máetsera­recapa. Tacahe, ena suntaruana enevanepa nacara­tacahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tacahe, ema émana apóstole, eta máimaira nacara­ta­sirahi ema Jesús, mavehapa eta mayehe espada. Máquijica eta machaca ema mamusura ema aquenuca Caifás. ");
INSERT INTO ignNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Émasera ema Jesús máichavacapa ena suntaruana: —¿Tájaha tacayema ecasiña eta espada, ecaepu­chi­ri­qui­pai­pa­hivare eta ecara­ta­si­ra­nuyare, tímicu­ti­ji­ri­cavapa námera­hihini núti? ");
INSERT INTO ignNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Étaya­pasica cape juca tamutuhi sácheana nucacha­nehehi nímitu­cahehi tayehe eta Templo. Váhivare epatsi­ca­vahini ecara­ta­ca­nuhini. Tacahe­hisera éta, títaucha­va­yarehi tamutu eta téchaji­ri­ruvana eta Sagrada Escritura —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tacahe, tijuna­ra­canapa namutu ena apóstoleana nanaquicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Matiari­hivare ema émana amaperu achane. Téhicapahi. Ticaepa­cu­hapahi eta te sávana. Tacahe, nacara­ta­ca­varepa éma apana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tijuna­hisera manaquicapa eta máepacu­hainihi sávana. Tiyanapa mamuria­repaipa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","55","Tacahe, nacaite­capapa ema Jesús te mapena ema corregidor. Ema Pedro, máehieque­ne­hapahi éna, mayere­re­hi­pa­hisera. Títuji­cavapa tisiapa eta te canchón tayehe eta mapena ema corregidor. Tásiha, téjacapa macacha­ne­muripa ena suntaruana, tiásacavahi eta te yucu. Váhisera náimatihini éma. Tacahe, tiúruji­ca­vanapa namutu­yaréni ena apamuriana tuparai­rucana énapa ena aquenu­ca­ra­hana énapa ena escribánoana. Napane­rechaipa, natanu­nui­caripa eta ticaviu­re­yarehi ema Jesús. Náichuhapa ena tépiyae­que­ne­ha­na­yarehi eta matapi­ra­va­yarehi náicha, navarairahi náimica­pa­ca­yarehi éma. Váhisera náichima­vahini eta maviure­vai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Camuria­na­hinéni ena tépiyae­que­ne­hanahi éma, váhisera tácuti­ca­cahini eta nacaye­ma­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Titupi­ha­na­varepa ena apamuriana tépiya­hi­ra­hia­na­yarehi. Ánipa macahe ema émana eta máepiya­hi­raivahi: ");
INSERT INTO ignNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Núti nusamahi ani macahehi ema maca: “Núti nuveta­tai­cayare eta juca Templo náepiyaruhi ena achaneana. Tásiha, te mapána­que­nénapa sache, nímicha­vayare nucatupiha eta apana Templo. Váipasera tácutimahi eta náepiyaruhi ena achaneana”. Eta juca nusama­quenehi eta máechaji­ri­ru­vanahi ema Jesús —macahepa ema tépiya­hirahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Váhique­nesera tácuti­ca­cahini eta máechaji­ri­ru­vanahi nayehe ena apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tacahe, ema corregidor téchepucapa eta mayase­re­si­ra­yarehi ema Jesús. Ánipa maicha: —¿Tájaha tacayema vahi pijica­pavaca ena nani eta pimetau­cha­ca­sivahi? ¿Yátupipuca eta nacaye­ma­quenehi? Taicha vímahavi eta vahi picatiu­chi­ra­vai­nahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Émasera ema Jesús vahi majica­pa­va­cahini. Timati­naichucha. Tásiha, mápechavare mayasereca ema corregidor: —Nuvaraha pimetacanu. ¿Píti pímija­cha­va­hí­jicacha pítihi Cristo ema vicucha­pa­quenehi, Machicha ema Viya? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tacahe, ema Jesús majicapapa: —Yátupi nuti Cristonu. Nuti Manere­ji­ru­nuhi ema Viya. Tásiha, numeta­ca­heyare eta apana. Járajapaya eta sácheyare ímaha­nuyare eta néjasi­rayare te mavaure ema Viya máitupa­ji­ji­ha­quenehi. Ímaha­nu­yareva núti eta núcupai­si­ra­yareva, násihayare te anuma, támira­nu­ya­repahi eta úcaji —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Tacahe, ema corregidor eta masamirahi, tisema­rinehi ichape. Tivetsa­yu­jia­cavapa eta mamuiriha eta masema­nevahi. Tásiha, macahepa: —¡Émaquenepa visama ema maca tépiya­cavahi Machicha ema Viya! Tétavi­cavaipa eta maviureva taicha macaecahihi ema Viya. Vaipa tácamesa vitanu­cahini ena testigoa­nayare. Puiti esamaripa éti eta juca macaye­ma­quenehi. ¿Tájaha víchara­cayare puiti ema maca? —macahepa. Tacahe, namutupa najicapa: —¡Ticaviu­revaipa! ¡Étaina táimicapaca! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tacahe, nátutuáca éma. Náepacau­qui­cha­varepa, tásiha, náehami­ra­ha­varepa te mamira. Tásiha, náichapa: —Te yátupi­hipuca pítihi Cristo, pímati­nuyare nájaha­nupuca nuti néhavihi. ¡Pimeta­cahavi! —náichapa. Énapa ena suntaruana, te námapaipahi, náehavarepa. Ichape eta náichirahi. ");
INSERT INTO ignNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tiuri, ema Pedro, matiari­hi­chahahi eta te canchón. Tacahe, sucahe­paipahi esu mavanara ema corregidor. ");
INSERT INTO ignNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Suímahapa ema Pedro, tiásacavahi. Suímara­racapa eta mamira. Tásiha, suíchapa: —Németeaca pítirichu ñichamuri eñi ñica Jesús, eñi nazareno —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Émasera majicapapa: —Vahi nímati ema péchaji­si­ha­quenehi. ¿Távihapuca pímati­nenuhi píti? —máichapa. Tacahe, tiyanapa éma eta te portón. Téchaji­ca­vanepa eta varayu. ");
INSERT INTO ignNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Suímaha­varepa tiápechava esu esena. Sumeta­ca­vacapa ena natiari­hi­que­neanahi, suíchapa: —Éñi ñica eñi nachamuri ena téhicanahi eñi Jesús —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tiápecha­va­varepa ema Pedro tépiyacava vahi máimatihini ema Jesús. Tacahe, te tiyere­re­ha­chi­chavare, ena natiari­hi­quenehi náichapa ema Pedro: —Yátupiquene pítirichu machamuri ema maena Jesús, taicha eta péchajisira, tímati­carehi eta piásihairahi te Galilea —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tacahe, majicapapa: —Máicuña­canuine ema Viya, te vahi nucucahe yátupina. Váhique­nesera nímati ema achane échaji­si­ha­quenehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Enurujipa tiápechava téchajica eta varayu. Tíjahú­chavapa téchava ema Pedro eta macaye­ma­quenehi ema Jesús: “Te tamira­hui­na­paichaha eta apíhe­quenéna téchajica eta varayu, píti mapahe­naripa eta pépiya­ca­vayare vahi pímatinu”. Eta máechavairahi ema Pedro, tépanavapa tíyaha. ");
INSERT INTO ignNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Te tijarahipa, tiápecha­va­na­varepa tiúruji­cavana namutu­yaréni ena aquenu­ca­ra­hana, taicha náichuha­que­neanahi ena tuparai­ru­cana, éna escribá­noana. Tiyase­re­ji­ri­ca­canapa tájahapuca eta náichara­ra­ca­yarehi ema Jesús. Tacahe, nacuchucapa ticaiti­hapaipa eta námirapahi te mamirahu ema Prefecto Poncio Pilato. Eta máimairahi ema Pilato ema Jesús, mavarahapa máimati­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tacahe, mayase­recapa: —¿Yátupi­sareji réyvihi píti nayehe ena pijaneanana israelítana? —máichapa. Ema Jesús majicapapa: —Pétupi­cavahi eta juca piyase­re­si­ranuhi. Yátupihi eta nurreyvahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tásiha, ena tuparai­rucana nametauchaipa ema Jesús, camuri eta maviurevahi náicha. ");
INSERT INTO ignNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tacahe, mápechavare mayasereca ema Pilato. Máichapa: —¿Vahi péchajiuchava eta juca nametau­chi­ravihi? Camuri eta piviurevahi náicha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Émasera ema Jesús váhiquene majica­pahini. Tásiha, máramipa ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tiuri puiti, tatiarihi eta mayehe­repihi ema Pilato te Páscuamu­huana. Macaiti­ca­yarehi ema émana preso mácani nayasea­ru­yarehi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tacahe, natiarihihi eta te cárcel ena ajairana ticaera­tanahi. Ichape eta naviurevahi ena téhaji­ri­ca­ca­rahiana te revolución, nacapa­si­rapahi ena achaneana. Te namuri, matiarihihi ema achane ticaijare Barrabás. ");
INSERT INTO ignNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tásiha, ena achaneana nayaseacapa ema Pilato máichahini eta mayeherepi. Ánipa náicha: —Vivaraha picha eta piyeherepi te Páscuamuhuana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tacahe, mayase­re­mu­rihapa ema Pilato: —¿Evara­hapuca nucaitica ema eyehe Rey, iáquenumuri eti israelítana? —macahepa ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(Taicha ema Pilato máimatia­ca­ripahi eta nametau­chirahi ema Jesús ena tuparai­rucana taicha nacapi­naruhi éma.) ");
INSERT INTO ignNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Énasera ena tuparai­rucana náimitu­mu­ri­haripa ena achaneana, eta nayasea­si­ra­yarehi émaina máuchucuha ema Barrabás. ");
INSERT INTO ignNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tacahe, ema Pilato mayase­re­mu­ri­havare. Máichapa: —¿Tájahasica níchara­cayare ema Jesús ema íjare­cha­quenehi Rey iáquenumuri eti israelítana? —máichamuripa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Éna, tipiara­canapa eta najica­pirahi: —¡Pémeta­tareca te crusu! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tásiha, mápecha­varepa mayase­re­muriha, ánipa máicha: —¿Tájaha tacayemahi eyaseacahi eta németa­ta­re­siraya ema maca? ¿Tájahasica eta maviurevahi? —máichapa. Énasera tipiara­ca­navare muraca­panapa: —¡Pémeta­tareca te crusu! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ema Pilato mavarahahi tiúriyarehi nayehe ena achaneana. Tacahe, mavanecapa ena suntaruana, ánipa maicha: —Ecaiticaya ema Barrabás. Émasera ema maca Jesús, iámayare, éstacayare. Étata­ca­yareva te crusu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tacahe, ena suntaruana námapa ema Jesús tayehe eta náestasi­ha­yarehi te távirarehi eta guardia. Náimichu­ha­varepa namutu ena apamuriana suntaruana náumurivana. ");
INSERT INTO ignNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te náitauchapa eta náestasirahi éma, namuriachapa eta muíriare mularume. Náitsame­macapa eta itapepi eta majara­pi­yarehi. Nanacapa te machuti. ");
INSERT INTO ignNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Nacava­yue­ma­rajipa. Náepuyu­mi­rau­cha­varepa, ánipa náicha: —Tata, ¡pítitataji nayehe­vihíji Rey ena israelítana! —nacahepa. Náepuchi­sicapa eta te machuti tayehe eta curinaqui. Nátutuá­ca­varepa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tacahe, te títavanapa eta nacaete­ma­ji­ri­sirahi, naveja­mu­hiacapa eta mularume. Nanaca­varepa eta mamuirihaichu. Tásiha, námapa tayehe eta macaeta­tai­ya­yarehi te crusu. ­ Náetatacapa ema Jesús te crusu ");
INSERT INTO ignNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eta napaisi­rapahi te calle, nácapa­jicapa ema achane ticaijare Simón. Éma, másihapahi te máesane. Napamicapa éma manaracuha eta macurusura ema Jesús. (Ema maca Simón, máuchusinehi te jena avasare Cirene. Éma, máiyahi ema Alejandro émapa ema Rufo.) ");
INSERT INTO ignNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tacahe, nacaite­capapa tayehe eta masihi nacaeta­tairare ticaijare Gólgota. ");
INSERT INTO ignNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ánaquipa náesichinehi ema Jesús eta vino ticasi­riquiama eta ipuruji tisucareama ticaijare mirra. Váhisera máerahini. ");
INSERT INTO ignNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tacahe, náetatacapa éma te crusu. Ena suntaruana, nasuerte­hachapa eta mamuirihaini eta náijara­ji­ri­si­ra­ca­cayare. ");
INSERT INTO ignNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Te náetatacapa éma, las nuéveripa eta yáticarahi. ");
INSERT INTO ignNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te tápusi eta macurusura, tatiari­hi­hivare eta ajureca táechaji­sihahi eta tiviuchahi eta máepeni­ra­yarehi. Ani tacahehi eta ajureca: “Ema Rey nayehe ena israelítana”. ");
INSERT INTO ignNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Natiari­hivare ena apinana tiámerahiana. Ticaeta­ta­na­hivare te machacaya, ema émana te mavaure, ema apana te sapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tacahe, tamutu títauchavahi eta táechaji­ri­ruvana eta Sagrada Escritura, ani tacahe: “Náimijachahi ema nachamurihi ena namauri­queneana”. ");
INSERT INTO ignNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tacahe, ena tiánucu­mi­rau­cha­napahi, tépiupiu­si­ca­va­napaipa eta nacaeca­hi­ra­paipahi ema Jesús. Ánipa nacahe: —¡Pítitataji! Picahe­cha­ji­ri­ruvahi eta piáquipai­si­ra­ya­rehíji eta Templo, pirata­ha­hi­varéji pímichava picatupiha eta arairu Templo te mapana­ya­re­ri­chuhíji sache. Puiti vivaraha vímaha eta pítupa­ji­jia­si­ravahi. ");
INSERT INTO ignNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Piúcupaica te jara crusu. ¡Picatiuchava pítijivaina! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Éneri­chuvare ena tuparai­rucana nacaeca­hi­ji­ri­cavare, énapa ena escribánoana. Náichaji­ri­cácapa: —Ema mácacacha, macahehi eta máechaji­ri­ruvahi eta marata­hai­rahíji macatiu­chavaca ena apamuriana achaneana. Tásiha, puiti váhivare márata­hahini émaji­vai­nahini macatiu­cha­vahini eta te jara mávihahi. ");
INSERT INTO ignNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te yátupi­nahini Cristo, Reyinahini viyehe viti israelítana, macatiu­cha­vai­pahini, ¿masi? Máucupai­ca­ri­pahini te jara crusu, ¿masi? Visuapa­sa­repaini eta vímairai­nahini —nacahepa. Ena tiámerahiana ticaeta­ta­na­hivare te machacaya, éneri­chuvare nacaeca­hi­hivare éna apanavare. ");
INSERT INTO ignNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tacahe, te las dócequenepa, témahapa eta sache. Timapicupa tamutu eta apaquehe. Mapana hora eta tamapi­cuirahi. ");
INSERT INTO ignNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tásiha, te las trespa sache, tipiaracapa muraca ema Jesús, ánipa macahe: —Elí, Elí, ¡lama sabactani! —te véchaji­riruva, ani tacahe: “¡Tata Nucaiyaquene! ¡Tata Nucaiyaquene! ¡Vahi picuju­ni­jicanu!” ");
INSERT INTO ignNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tacahe, ena natiari­hi­que­neanahi ena tisamanahi, ánivarepa­ nacahe: —Esama. Ema maca achane mapiaracahi ema víyarahaini profeta Elías —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ema apana tiyanapa tijunapahi máepanapa eta machuchu­ji­ru­yarehi eta tisisica vino. Máitiacapa te tiúqui curinaqui. Máimica­pa­yacapa eta majaca, machuchu­ji­ca­yarehi. Tacahe, máichapa: —Ésami­ri­cachucha. Vímahayare te títeca­pa­ya­repuca macatiu­chapana ema Elías —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tacahe, tiápecha­va­varepa tipiaraca muraca ema Jesús. Tépenapa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tásiha, tíjahú­chavapa tétsayu­mecapa eta cortina tayehe eta Templo. Tépanava te anuquehe, tíchecuha te apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tásiha, ema nacapitara ena suntaruana romanoana, eta matupi­hairahi máimara­ra­sirahi te mamirahu ema Jesús, masamirahi eta mapiara­sirahi, ánipa macahehi: —Yátupi­que­ne­ri­chuyapa Machicha ema Viya ema maca —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tacahe, natiari­hi­hivare ena esenana. Náimara­racahi, nayere­re­hi­hisera. Te nataracu, sutiarihihi esu María Magdalena, esu Salomé, ésupa esu apana María. (Esu suca María, máenahi ema Jacobochicha émapa ema José.) ");
INSERT INTO ignNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ena nani esenana ena náumurivana ena téhica­rai­ri­ca­napahi téchapa­ji­ri­ca­napahi ema Jesús eta mapaisi­rapahi te másihapa te Galilea. Natiari­hivare ena camuriana apamuriana esenana náiteca­pa­quenehi te Jerusalén, téhica­napahi éma. ");
INSERT INTO ignNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Matiari­hi­hivare ema achane ticaijare José­. Ticavasahi te Arimatea te Judea. Éma, tétavi­cavahi eta mapicau­cha­ca­revahi. Masuapahi ema Jesús eta émairahi ema Cristo mavaneruhi ema Viya, étaripa eta émairahi ema téchayarehi namutu ena achaneana. Ema maca José, náumurivahi ena aquenu­ca­ra­hana. Tacahe, te cáperehipa eta jena sáchequenehi, tétume­chavapa ema José tiyanapa eta me Pilato, mayasea­panahi eta máquehe ema Jesús, mavarairahi máecarayare. Tacahe, tiyayau­chavapa taicha térica­ya­repahi eta sache. Vahi táisapa­ca­rehíni náecara­re­cahini te yátimuhu, váhivare táisapa­ca­rehini máejamia­cahini te jena sávarumuhu. ");
INSERT INTO ignNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Máraminehi ema Pilato eta máijahú­chi­ravahi tépenavane ema Jesús. Tásiha, máimichuhapa ema nacapitara. Te títecapapa ema nacapitara, mayase­recapa te yátupi­hipuca tépenaripa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tásiha, eta mameta­sirahi ema nacapitara eta máepeni­raipahi ema Jesús, máisapapa ema Pilato eta máquehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tacahe, tiyanapa ema José. Mámapa eta tiúrina sávana mavacha­reruhi. Tásiha, macucu­paicapa eta máquehe ema Jesús. Náyuruácapa tayehe eta sávana. Náiyara­cuhapa tayehe eta máecari eta te mari naseca­jueruhi. Tásiha, najihachapa te tapaja eta máecari eta ticheyarame mari tajita­ca­requene. ");
INSERT INTO ignNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sutiari­hi­hivare esu María Magdalena ésupa esu apana María­. Náimara­racahi, náimatipa eta nanasihahi eta máquehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tacahe, te jena sache sávaru­quenehi, téricaipa eta sache, tiyanapa esu María Magdalena, ésupa esu Salomé, ésupa esu apana María. Tivacha­re­canapa eta tíjiyequene perfume nayaria­si­hayare eta máquehe ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tásiha, te apanapa sache, lumíncu­quenehi, nayatirupa tiyanana eta te máecari. Te tiúchucapa eta sache, títeca­pa­napaipa éna eta te máecari. ");
INSERT INTO ignNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Eta napaisi­rapahi, tiyase­re­ji­ri­ca­ca­napaipa. Ánipa nacahe: —¿Nájaha­pa­pucaini náequehe­pui­chi­na­havini eta tajiha eta ñécari eñi Viáquenu eta mari tajita­ca­requene? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Te títeca­panapa, náimahapa eta márime tájina­ripahi te tapajacura eta máecari. ");
INSERT INTO ignNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tásiha, tisiapanapa. Ánaqui náimahapa ema émana amaperu achane, mávihahi te vaure. Eta mamuiriha, tétavicava eta tajapuva. Tiárame­ca­na­rinehi ena esenana. ");
INSERT INTO ignNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ema amaperu achane máechaji­ca­vacapa: —Vahi ecupica. Éti etanu­capahi ema Jesús Nazareno, ema macaeta­ta­que­nenihi. Májina­ripahi, taicha ticaeche­pu­ca­siripa. Yare, ímaha. Júcahi eta mávinehi. ");
INSERT INTO ignNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tiuri puiti, eyana emetaca ema Pedro, tásiha, namutu ena apamuriana echamuriana. Emeta­cavaca tiyanayare ema Jesús eta te Galilea. Ánaqui macucha­pia­heyare emutu éti. Échava­ri­chu­hipuca eta macaye­ma­que­neanahi te achane­richaha —máichavacapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tacahe, tiúchucanapa eta te máecari. Tiyananapa tijuna­pa­napaipa. Tiyaya­ca­rea­napaipa taicha eta náramirahi. Eta nayanirahi, nájina nameta­rui­nahini taicha eta napisirahi. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tiuri, eta máechepu­sirahi ema Jesús te máecari te jena lumíncu­quenehi te yática­ra­hichicha, sutivapa máimere­siavahi suyehe esu María Magdalena. (Esu suca María, esu máepachiaruhi ena siétequeneana éreanana te suáquehe.) ");
INSERT INTO ignNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tacahe, tiyanapa ésu, sumetapana ena suchamu­rianahi. Éna, tétavi­cavahi eta napane­re­re­sirahi, tíyahanahi eta nacati­sa­mu­re­vairahi. ");
INSERT INTO ignNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Váhisera nasuapahini eta sumeta­rapihi esu María eta máechepu­siraipa, machavi­raipahi títareca, étapa eta máimere­si­ravahi eta suyehe. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te táequenepa eta juca, tímere­ca­va­varepa ema Jesús nayehe ena apinana máimitureana eta napaisi­rapahi, nacaiju­heirahi eta avasa­rechicha te tachacaya eta Jerusalén. Tiápamai­cha­va­hisera eta mamira. Vahi náimatí­va­nehini éma. ");
INSERT INTO ignNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Téhesera náimatipa éma, majuni­jia­ca­vacapa. Tacahe, tichava­va­neanapa nametapana ena apamuriana nachamuriana. Váhique­ne­va­resera nasuapahini ena apinana, eta nameta­sirahi. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tiuri, te táequenepa, tiúruji­ca­vanahi eta nanisirahi ena óncequeneana apóstoleana. Tacahe, tíjahú­chavapa tímerecava ema Jesús eta nayehe. Macaja­cha­mu­ri­varepa eta namasua­pirahi eta nameta­ra­pianahi ena tímahanahi éma eta máechepu­si­raipahi. ­ ");
INSERT INTO ignNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tacahe, máichavarepa: —Eyana epaica te tamutu eta ­ avasareana eta te juca apaquehe. Ecame­ta­rai­ruyare eta tiúrina echaji­ri­rucava nayehe namutu ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nucuchu­cu­ha­va­cayare namutu ena tisuapa­ji­ra­hianaya, ena ticaica­cha­sianaya. Énasera éna vahi tisuapanaya, ticaicu­ña­nayare taicha tanasi­richuhi eta napeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ena tisuapa­ji­rahiana náimere­cayare eta juca tiárami­careana: Náimiju­ni­ji­cayare ena éreanana nayehe ena achaneana, taicha námapi­cayare eta níjare. Náitucayare téchajicana tayehe eta apanana échaji­ri­ru­cavana namaitu­ca­que­nea­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te nacara­ta­ca­hipuca eta quichareana, tájina táichara­caimahi. Te térana­hipuca eta venéno, tájinavare náichavaimahi. Nanacayare eta navahuana nayehe ena nácani nacaju­ma­queneana, tásiha, tinara­ca­nayare éna —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tacahe, te títavapa tamutu eta mameta­ra­pianahi ema Viáquenu Jesús, tiyanapa tiyapa te anuma. Ema Viya macaejacapa ema Machicha te mavaure. ");
INSERT INTO ignNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tacahe, tiyananapa eta te tamutu avasareana ena máimitureana. Ticame­ta­rai­rua­napaipa eta tiúrina echaji­ri­ru­cavana. Ichape eta máimica­ta­si­ra­va­capahi ema Viáquenu. Tétávi­cavahi tajaca­pa­ca­revahi máicha, eta náimitu­ra­pia­napahi. Taicha máijara­ca­va­capahi eta náimere­si­rapahi eta tiárami­careana ticuna­cha­ca­reanahi. Tamu­ tupa.");
INSERT INTO ignNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Némuna­ruquene nuparape Teófilo, nucajurevi puiti apaesa pecha píti apanavare eta juca néchaque­neanahi núti. Ichape­mu­rianahi ena vichamuriana tiájueque­ne­hanahi tayehe eta máichara­cavahi ema Viáquenu Jesucristo. Tásiha puiti, núti apanavare nájueque­ne­havare. Nucaeja­ru­sinahi tamutu eta nájueque­ne­hairahi, taicha tamutuhi nucaya­se­sereru nayehe ena tineca­pae­que­ne­hanahi, tímahanahi eta apaicape eta táepani­ravahi eta máitare­sirahi ema Viáquenu. ");
INSERT INTO ignNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Núti nuvaraha nímima­tichavi apaesa yátupina pecha tamutu eta juca piárava­huanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cape juca viásine­quenehi te émarichaha ema Aluresi aquenucahi, réyhi tayehe eta jena provincia Judea, matiari­hi­hivare ema émana achane, ticaijare Zacarías. Éma, náumuri­vanahi ena ticaijareana Abías. Eta náemata­nerepi éna, náechapa­jirica eta námava­huasana ena achaneana tayehe eta Templo. Esu mayena ema Zacarías ticaijaruhi Elisabet, mámarie­que­nenihi ésu ema víyarahaini Aarón. ");
INSERT INTO ignNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ema maca Zacarías ésupa esu mayena, tájina náichira­vai­nahini te mamirahu ema Viya. Tamutuhi náitaucha eta mavanai­ripiana ema Viáquenu. Tacahe, tájina náechaji­sie­que­né­nahini nayehe ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nájinasera nachichai­nahini, macheruhi esu Elisabet eta suítaresira. Váipavare ticachi­cha­naimahi taicha ichavi­ca­na­ripahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","10","Te jena sache, náichuhapa ema Zacarías eta masiapi­rayare tayehe eta Templo te Jerusalén, taicha áñopahi eta masiapi­rayare. Tacahe, ticátu­pa­rá­casipa éma. Émapa táetupiacahi eta máemata­ne­re­pi­yarehi máijucha­yarehi eta incienso te táinahu eta mesa náijuchi­rarehi, taicha tacahehi eta nayehe­repini ena israelítana. Tacahe, ema Zacarías tisiapapa te tajuhe eta cuarto tacapi­ca­hu­quenehi, máijuchapa eta incienso. Macari­chusera tísapa­carehi tisiapa. Ena apamuriana achaneana nanasipa te aneca, tiyuja­ra­ca­naripa éna. ");
INSERT INTO ignNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tiárami­carepa tímerecava ema émana ángele te mamirahu ema Zacarías. Mavaneruhi ema Viáquenu. Titupi­haripa ema ángele te vaure tayehe eta mesa náijuchi­rarehi eta incienso. ");
INSERT INTO ignNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tiárame­carine ema Zacarías eta máimairahi ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Émasera ema ángele máechajicapa: —Vahi picupica, Zacarías —máichapa—. Ema Viya masamahi eta piyase­se­repihi píti eta mayehe. Puiti esu piyena Elisabet ticachi­chayare. Juan eta máijareyare ema echichayare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ichapeyare eta piúrisa­mu­re­vayare te máuchucapa ema echichayare. Énaripa ena achaneana, ichape­yareva eta náurisa­mu­révaya taicha eta máuchusi­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Numetacavi: Ema pichichayare, ichapeyare eta macuna­cha­ca­re­vayare mayehe ema Viya. Píti, vahi písapaimahi tera eta vino, étaripa eta apamuriana téracareana muraca­queneana. Taicha éma, eta máuchusi­rayare, mávahá­ru­ya­repahi ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Éma pichichayare, éma tétupi­ri­cayare eta táurivayare eta napane­reruana ena pijaneanana israelítana, tachavi­rayare eta nasuapi­rayare ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ema maca pichichayare, éma tínapu­mi­rau­cha­ya­repahi ema Viáquenu. Macutiyare eta máitupa­ji­jia­si­ravaini ema víyarahaini profeta Elías. Ichapeyare eta máitusi­rayare eta macaji­mu­ya­si­rayare eta nasamureana ena achaneana apaesa tachava eta nasuapiraina ema Viya, tácuti eta nasuapa­ji­rai­vainihi ena náchuca­na­vea­nainihi. Énaripa ena váinara­ji­pa­ne­reruana, tisuapa­ji­ra­hia­na­yareva máicha. Mameta­ca­va­cayare ena achaneana natsecavaipa eta najaca­pi­rayare ema Viáquenu —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tásiha, ema Zacarías majicapapa. Ánipa macahehi: —Páurenusami, vaipa numaita­ca­vaimahi nucachi­chahini, ésuripa esu nuyena. Ichavi­ca­havipa víti. Váhicha nusuapa­pajica eta juca vicachi­chai­ra­ya­repuca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Émasera ema ángele máichavarepa: —Núti nucaijare Gabriel. Núti mavane­runuhi ema Viya. Nutupa­ra­ca­si­vaichuhi eta numeta­si­ra­viyare eta juca ecachi­chai­rayare. Piúriháine ichape­nahini eta piúrisa­mu­re­vai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Puítisera úpaviyare. Eta ecutia­ra­reyare piyehe taicha eta pimasua­pi­ranuhi. Tiámáinucava te táitauchavapa eta juca numeta­ruvihi, péchaji­cai­na­varepa —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tacahe, ena achaneana nanasi­que­neanahi te aneca nacucha­pa­rai­ri­caipaicha ema Zacarías, náramipa eta mayere­vai­pahicha te tajuhe. ");
INSERT INTO ignNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jéhesa­reinehi, te tiúchucapa ema Zacarías, vaipa máechaji­cahini. Náimatia­ca­pasera éna, eta máechaji­sirahi ema Viya te tajuhe. Tisuve­ve­re­ca­paipahi éma eta mavarairahi máimicu­tia­ra­chavaca ena achaneana eta yátupirahi masama­quenehi. Úpapaipahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tacahe, te títauchavapa tamutu eta jena sácheanahi eta matupa­ra­ca­sivahi, tiyanapa ema Zacarías tayehe eta mapena. Nueve caje eta mayere­va­yarehi eta mamaecha­ji­si­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tásiha, esu mayena Elisabet, ticajaripa ésu. Váipasera súchuchu­re­cahini te supena. Váhivare sumeta­ji­ri­cahini. Tiámainu­cavapa te títaucha­va­yarepa eta cíncoquenehi caje eta sucaja­rirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tétavi­cavahi eta súrisa­mu­revahi eta susami­ravahi ésu. Ánipa sucahe: —Ichape eta ñijapa­nui­ranuhi eñi Viya, tíjara­canuhi eñi nuchichayare. Váipasare nayuna­caimahi ena achaneana eta numache­ruvahi —sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tacahe, te sáisiquenepa caje, ema Viya mápechavare mavaneca ema ángele Gabriel tiúcupaica tayehe eta avasare Nazaret, tayehehi provincia eta Galilea. ");
INSERT INTO ignNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Máucupauchapa esu amaperu esena ticaijaru María. Ésu, tájina suímati­yahini ema ajaira. Matiari­hi­pasera ema suímayarehi, ema ticaijare José. Téjaca­ripahi eta natratune. Ésu, mámarié­que­néinihi ema víyarahaini rey David. ");
INSERT INTO ignNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tacahe, ema ángele máucupauchapa ésu tayehe eta suávihahi. Máichapa ésu: —Pícharacava, María. Piti manere­ji­ruvihi ema Viya. Tétavi­cavahi eta piúrica­ca­re­vayare taicha ichape eta majapa­nui­ravihi éma Viya. Picachu­ricahi namutu ena apamuriana esenana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ésusera tiárame­cainehi eta máechaji­sirahi ema ángele. Supane­re­que­ne­hainehi tájaha­hipuca tacayemahi eta máechaji­sirahi ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Émasera ema ángele máichavarepa: —Vahi picupica, María. Piti manere­ji­ruvihi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Numeta­pa­navihi puiti eta picaja­ri­rayare. Ajairayare ema pichichayare. Jesús eta máijareyare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tétavi­cavaya eta napicau­chi­rayare ena achaneana taicha Machicha­yarehi ema Viya. Ichape­que­neyare eta aquenu­cai­rayare éma taicha ema Viya manaca­yareva eta mávacu­reyare aquenu­cayare. Macuti­yarehi eta aquenu­cairahi ema máchucaini David. ");
INSERT INTO ignNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Éma téchayarehi namutu ena pijaneanana israelítana. Máepena­ca­cayare eta aquenu­cai­rayare —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tásiha, esu María, sujicapapa: —¿Tájahasica táichara­ca­vayare eta juca? Taicha núti nájinaichaha nímainahini —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Émasera ema ángele máichavarepa: —Picachi­chayare taicha eta máitupa­ji­jia­si­ravahi ema Viya. Timicau­cha­viyare eta majaraiva, tásiha, tisiapa­ha­ca­vinapa ema Espíritu Santo. Eta tacahe, ema amuya pínaruyare, sántoyare éma, taicha machicha­yarehi ema Viya. Náimatiyare namutu eta machichairahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Picutiyare esu pijaneana Elisabet, éneri­chuvare ticaja­ripahi ésu. Tayana­panehi ichavi­ca­chi­cha­ri­pa­hinéni ésu, macherui­ni­hinéni. Sáisiri­pasera caje eta sucaja­rirahi puiti. ");
INSERT INTO ignNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Taicha ema Viya, tájinaquene máemáituca éma —máichapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tacahe, esu María sujicapapa: —Núti ñivana­ra­nuichuhi eñi Viya. Nutiarihi puiti. Ñímaha­nuinepa éñi, eta ñíchara­ca­nuyare te ñivanai­ripiana —suíchapa ema ángele. Tacahe, eta masamirahi ema ángele, tiyanapa tichavahi­­. ");
INSERT INTO ignNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tacahe, te jena sácheana titátájipa esu María tiyana tayehe eta avasa­rechicha te tatara­cu­cu­jianahi eta márijuecu tayehe eta provincia Judea, suávasahi esu sujaneana Elisabet émapa ema Zacarías. ");
INSERT INTO ignNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te títecapapa esu María tayehe eta napenahi, suéchajicapa esu Elisabet. ");
INSERT INTO ignNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te susamapa esu Elisabet eta suahu esu María suéchaji­sirahi, tiyamu­ri­cainehi eta amuya te sujuhe esu Elisabet, enevanepa mávahácahi ésu ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tacahe, téchajicapa muraca esu Elisabet, suíchapa: —Píti, tétavi­cavahi eta piúrica­ca­revahi ñicha eñi Viya. Picachu­ri­ca­havihi vimutu viti esenana. Éñiripa eñi pichichayare, tétavi­ca­va­hivare eta ñicuna­cha­ca­revaya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nusapi­ha­samipa núti péjira­pa­nanuhi piti ñénavi­yarehi eñi Náquenu. ");
INSERT INTO ignNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Te nusamapa eta piahu eta péchaji­si­ranuhi, tiyamu­ri­cainehi te nujuhe eñi nuchicha, taicha eta tiúrisa­mu­réinehi éñi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tétavicava eta piúrica­ca­revaya píti taicha eta pisuapa­ji­raivahi ñe Viya. Títaucha­vainapa tamutu eta ñimeta­rapihi eñi Viáquenu eta piyehe —sucahepa esu Elisabet. ");
INSERT INTO ignNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tacahe, esu María sujicapapa: —Ichape­murihi te náchaneva eta nucuna­chirahi eñi Viáquenu. ");
INSERT INTO ignNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Taicha tétavi­cavapa eta táurisa­mureva eta nusamure ñicha eñi Viya Ticatiu­ra­hiquene eta nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Taicha éñi, vahi ñépuru­nuhini páurenu­hinéni nútisami. Tétavi­ca­va­hisera eta ñijapa­nui­ranuhi nuti ñivanarahi. Nútipa ñinere­ji­canuhi, tásiha, ichape­na­papuca eta nacapi­na­ru­nuiraya namutu ena achaneana natiari­hi­quenehi puiti, énapa ena araju­rua­nayare. “Tétavi­cavapa eta súrica­ca­revahi esu María” nacáhé­na­papuca. ");
INSERT INTO ignNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tétavi­cavapa eta ñítupa­ji­jia­si­ravahi eñi Viya, tíjara­canuhi eta núriva­yarehi ñicha. Jéhevare éñi, Sántoquenehi eta ñijare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eta tacaheyare eta ñijapa­nui­ra­ha­viyare puiti, énapa namutu ena araju­rua­nayare, nácani tipicau­cha­nayare éñi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eñi Viya, ñíjara­cayare eñi nuchichaya eta ñítupa­ji­jia­si­ravaya ichape. Tásiha, ñicaera­ji­ca­vacaya ena ticasi­ña­va­vai­ricana, énapa ena váinara­ji­pa­ne­re­rua­na­hivare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nácani aquenucana nacatia­na­cai­na­papuca, ñicapa­que­cha­va­ca­ya­re­hisera éñi. Nasapihapa ena páureana­samihi, ñinere­ji­ruanaya éna, ñijupa­ha­nayare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yátupiya eta ñíjara­si­ra­va­cayare eta táetaviu­chiraya eta náurica­ca­revaya namutu ena ticasi­ña­va­nayare ñiyehe. Énasera ena tímija­cha­vanahi tájinahini nácamu­nuhini, ñicaera­ji­ca­vacaya namutu. ");
INSERT INTO ignNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eñi Viya acane tíjara­cavahi ñiyehe eñi viáchucaini Abraham énapa ena ñiámarié­queneana, eta ñíjara­si­ra­va­cainapa eta táetaviu­chiraya eta náurica­ca­re­vanaya. Vahi ñémiti­si­caimahi eñi Viya eta ñéchaji­ri­ruvahi ñíjara­ruvahi. Puiti, eñi nuchichaya tiámaya­repahi tamutu eta viúrica­ca­re­vanaya viti israelítana. Máitava­ca­ca­yarehi éta —sucahepa esu María. ");
INSERT INTO ignNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tásiha, sunasi­panapa esu María te supena esu Elisabet. Mapana caje eta suyerevahi. Te táequenepa, tichava­varepa te supena. ");
INSERT INTO ignNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tacahe, títauchavapa eta sucajera esu Elisabet. Suínacapa ema suchicha. ");
INSERT INTO ignNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tiyananapa ena sujaneanana énapa ena suchaca­ya­pe­nanahi, náejirapana ésu. Táicha eta nasamai­ri­ri­sirahi eta súrivahi maicha ema Viya eta majapa­nuirahi ésu. Tiúrisa­mu­rea­na­rinehi namutu. ");
INSERT INTO ignNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tacahe, te óchoquenepa sache eta máuchusirahi ema amuya, nayanauchapa ena najaneanana, namarca­cha­pa­na­ya­rehi ema amuya; taicha tacahehi eta nayehe­repihi. Tásiha, navarahapa nanaca­yarehi eta máijare­yarehi Zacarías, mámapi­ca­yarehi eta máijare ema máiya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ésusera esu maena ema amuya vahi suvara­hahini. Suíchavacapa: —Juan eta ñíjareyare. ");
INSERT INTO ignNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tásiha, éna nacahepa: —¿Tájaha tacayema? Namutu ena pijaneanana, nájina ticaijarena eta Juan —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tásiha, éna náimicu­tia­ra­chinapa eta nayase­re­sirahi ema Zacarías tájahapuca eta máijare­yarehi maicha éma. ");
INSERT INTO ignNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tacahe, ema Zacarías tiyase­se­recapa eta táblamechicha, májuchi­ha­yarehi eta máijare­yarehi ema machicha. Eta ajureca, ani tacahehi: “Juan eta máijareyare”. Téseni­ji­ri­ca­ca­na­rinehi éna taicha eta máijare­yarehi ema amuya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tásiha, tíjahú­chavapa tichavapa eta máechajisira ema Zacarías. Macunachapa ema Viya eta máurisa­mu­revahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ichape eta tiárami­carehi nayehe ena natiari­hi­que­neanahi. Nasamai­ri­ri­ca­vanepa namutu ena távacuanahi eta avasa­re­chichana tayehe eta provincia Judea. Náechaji­sihapa eta juca nasamai­ri­ri­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Namutupa napane­re­que­nehahi. Nácani tisamai­ri­ri­ca­napahi, tiyase­re­ji­ri­ca­ca­naripa. Ánipa nacahe: —¿Cañarihi tacaye­ma­quenehi eta juca máuchusirahi ema amuya? —nacahepa. Tásiha, ema amuya, tétavi­cavahi eta majanea­sirahi ema Viya eta majuru­si­ra­paipahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tacahe, eta jena sáchequenehi eta macama­rcairahi ema amuya, étaripa eta nanasirahi eta máijare­yarehi, téchajicapa ema Zacarías. Macunachaipa ema Viya, taicha mávahá­caripa ema Espíritu Santo. Ánipa macahehi: ");
INSERT INTO ignNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Tétavi­cavapa eta macuna­cha­careva ema Tata Vicaiyaquene, ema véhiruhi vimutu viti israelítana. Taicha tijapa­nu­havihi vimutu viti machane­ranahi, ticuchu­cu­ha­ha­vi­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tíjara­ca­ha­vi­yarehi puiti ema yátupi­que­neyare eta macatiu­raivaya, ema manere­jiruhi te namuri ena mámarie­que­nea­nainihi ema David, ema mavana­rai­ni­hivare ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Títaucha­vaipahi eta náechaji­ri­ru­vanahi ena santo profeta­naini acane, eta nameta­ca­si­vanahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","73","Taicha tacahehi eta matratunehi ema Viya mayehe ema viáchucaini Abraham. Ema Viya tíjara­cahavi eta majapa­nui­ra­va­ca­yarehi ena viáchuca­na­veanaini, énapa ena ticachi­cha­haviana, vítipa puiti. Éneri­chuvare tíjara­cavahi eta mamaemi­ti­si­siraya eta macatiu­chi­ra­ha­viyare nayehe ena ticatia­na­ca­ha­vianahi. ");
INSERT INTO ignNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ema Cristo manere­jiruhi ema Viya, ticatiu­cha­ha­vi­yarehi taicha mamava­rairahi vipicahini, nacuija­hi­varéni ena nahapa­pi­ca­ha­vihini eta vicaema­ta­nea­si­ra­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Eta mavara­ha­quenehi tiúriyare eta vítare­si­ra­yarehi tamutu sácheana, tájina víchira­vaimahi te mamirahu éma. ");
INSERT INTO ignNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pítiripa, piti nuchicha, píchuare­ca­si­vaichuhi mayehe­viyare profeta ema Tata Vicaiyaquene taicha píti pínapu­mi­rau­cha­ya­repahi ema Viáquenu Cristo. ");
INSERT INTO ignNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pétupi­ri­ca­yarehi eta nasamureana ena achaneana, yátupinapa machane­ra­na­yarehi éna. Pímitu­ca­yareva nácaicu­tiaraya eta mavarairahi ema Viya macatiu­cha­va­cayare, macaepa­hai­ra­ya­re­hivare eta napeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Puítiripa, eta máemuna­si­ra­havihi ema Viya, macucu­pai­si­na­havihi te anuma ema Machicha. Éma, tímima­ti­cha­ha­vinapa eta majaraiva ema Tata Vicaiyaquene étapa eta táuriquene achene ticaijuhe mayehe. Máetuca­rá­ca­va­cayare eta nasamureana ena ticati­sa­mu­reanahi, nácani tépena­na­ya­rehíni —macahepa ema Zacarías. ");
INSERT INTO ignNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tacahe, ema amuya eta majuru­sirahi, tiámavapahi eta masuapa­ji­raivahi mayehe ema Viya. Váhivare étainahini te tajuhe eta avasare eta majuru­sinehi. Vámahi­cu­ruhahi eta majuru­sirahi. Tiámainucava te ajairapa, tímere­cavapa nayehe ena majaneanana israelítana, tépana­va­pasera ticame­tarairu. ");
INSERT INTO ignNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Tacahe, te jena áñoanahi cape juca viásine­quenehi te émarichaha aquenucahi ema Emperador Augusto, matiari­hi­hivare ema apana achane ticaijare Cirenio, majupahahi ema Augusto. Prefectohi éma, tayehe eta avasareana. Ticaijare Siria eta mávihahi­. Tacahe, te jena sácheana, ema Augusto macava­nai­ripipa nacuchuca eta vantu eta nacatu­pai­rayare namutu ena achaneana te avasareana. Tacahe, tiyananapa ena achaneana te návasa­napachu te náuchusineana eta nacatu­pai­ra­yarehi. Nasuapa­yarehi eta vanairipi. Táinapuiruhi censo maicha ema Emperador Augusto. ");
INSERT INTO ignNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Tacahe, tiyanapa ema José. Mámapa esu mayena María. Ticaja­ripaipa ésu. Tacahe, tiúchucanapa éna tayehe eta avasare ticaijare Nazaret te Galilea. Nacaijuhepa eta avasare ticaijare Belén te Judea, eta mávasainihi ema aquenucaini rey David. Étari­chuvare mávasahi ema José, taicha ema José mámarie­quenehi ema David. Tiyananapa ticatu­pa­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Tacahe, títeca­panapa te Belén. Tájinai­pasera távira­vai­nahini eta te pétiana eta náiteca­pi­hahini taicha camuri­que­neanahi ena achaneana náiteca­pa­que­neanahi. Tacahe, tisiapanapa eta te peti tapena eta sárareana. Tacahe, esu María tiyuri­ti­cavaipa eta sucajera eta suínasi­ra­yarehi. Tacahe, tínacapa jena yati. Suínacapa ema amuya ema suárachichahi. Tacahe, suáyuruacapa eta te mámara­tataji pañal. Sucaivecapa ema amuya alauchu. ");
INSERT INTO ignNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te vámahi te tachacaya eta avasare Belén, natiarihihi ena pástuléruana. Éna, najaneacahi eta nayeheana uvesana te jena yátiquenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tiárami­carepa tímerecava ema ángele mavaneruhi ema Viya. Jéhesare, tamicau­cha­mu­rinehi ena pástuléruana eta majaraivahi éma. Tiárame­ca­narine éna. ");
INSERT INTO ignNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tásihasera, ema ángele máichavacapa: —Vahi ecupica. Yare, jucarihi eta tímite­canuhi núti numeta­pa­na­heyare. Tétávicava táurisa­mu­ré­ca­revaya nayehe namutu ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Puiti te jena avasare Belén, mávasaini ema rey David, tiúchucaipa ema Ticatiu­ra­hiyare eyehe emutu éti. Éma, ticaijare Cristo Viáquenu. ");
INSERT INTO ignNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eta tacahe, nímicu­cu­tia­ra­chi­na­heyare eta ímairaya: Echima­payare ema amuya ticayu­ruhahi te mámara­tataji pañal. Tívecahi eta te tajuhe eta peti tapena eta sárareana —máichavacapa ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tásiha, tíjahú­chavapa tímere­cavana ena camuri­queneana ángeleana eta te mávihahi ema émana ángele. Najirahi eta alabanza eta nacuna­chirahi ema Viya te anuma. Ánipa nacahe: ");
INSERT INTO ignNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Tétávi­cavapa eta vicuna­chirahi ema Viya vimutu viti viávihanahi te anuma! ¡Jéhevare puiti, tiúrica­va­nainapa ena achaneana te juca apaquehe, ena manere­ji­ruanahi macata­ji­ruanahi ema Viya! ¡Tájinainapa náichira­vaimahi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tacahe, tiyananapa ena ángeleana, tichavana te anuma. Tásiha, náichacacapa ena pástuléruana: —Yare, viyana te Belén. Viyana vímahapana eta juca mameta­ru­havihi ema ángele mavaneruhi ema Viya Viáquenu —náichacacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tacahe, titátá­jia­na­paipahi tiyanana. Jéhesa­reinahi, te títeca­panapa, nachima­painehi esu María émapa ema José. Matiari­hi­sa­réipahi ema amuya. Tívecahi éma eta te tajuhe eta peti tapena eta sárareana. ");
INSERT INTO ignNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te náimahapa tamutu, tépana­vanapa náemechapa. Amairi­pahipa naecha eta mameta­ra­pianahi ema ángele eta máuchusi­raipahi ema amuya. ");
INSERT INTO ignNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tacahe, náraminehi namutu ena achaneana eta nameta­ra­pianahi ena pástuléruana. ");
INSERT INTO ignNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tásihasera, esu María supane­re­que­ne­hainehi te susamure tamutu eta juca susama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tacahe, ena pástuléruana tichavanapa tayehe eta te najanea­re­sihahi eta uvesana. Nacuna­chainehi ema Viya te anuma táichavene eta máechaji­ri­ruvahi ema ángele, táichave­nevare eta náimaira­hivare ema amuya alauchu. Étapaichuhi tacahehi eta macaye­ma­quenehi ema ángele. ");
INSERT INTO ignNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Te óchoquenepa sache eta máuchusirahi ema amuya, namarca­chapa éma taicha tacahehi eta nayeherepi ena israelítana. Tacahe, nanacapa eta máijareyare Jesús. Eta máijare máimija­re­cha­quenehi ema ángele te sucaja­ri­yarepa esu maena María. ");
INSERT INTO ignNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tacahe, te cuarenta­quenepa sache eta suínasirahi esu María, tiyananapa te Jerusalén. Eta tímiya­na­vacahi éna, náimere­pa­na­yarehi ema amuya mayehe ema Viya Viáquenu. Taicha ema Viya macava­nai­ripihi eta te Sagrada Escritura eta májurehi ema víyarahaini Moiséini, ánipa tacahehi: “Te ajairapuca ema mácani suárachicha esu esena, ímere­cayare nuyehe; íjara­ca­nuyare taicha nícuchichuhi ema”. Éneri­chuvare náitaucha­yarehi eta juca apana vanairipi tayehe eta napachi­hairaina ena esenana eta te táequenerapa eta náinasira. Ánipa macahe: “Esu súcani esena arainacahi, suíjara­ca­si­cha­nupana eta apihina paluma símarrune; te váhipuca, apina paluma suítati­queneana, amairu­hi­chi­cha­nasera”. ");
INSERT INTO ignNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiuri, matiarihihi te Jerusalén ema émana achane ticaijare Simeón. Tétávi­cavahi eta máuriva. Tipicaurahi éma. Émarichu mávaháruhi ema Espíritu Santo. Ticucha­pa­vai­pahicha ticaimai­ru­vaipaicha éma eta máimatiraya ema Cristo, éma ticauri­sa­mu­rerahi nayehe ena achaneana majaneanana israelítana. ");
INSERT INTO ignNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Taicha ema Espíritu Santo mameta­ca­ripahi ema Simeón eta vuíchaha tépena­va­nemahi éma, táicha máimati­nu­ma­yarehi ema Cristo mavane­ru­yarehi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tiuri, te jena sache, ema Espíritu mavanecapa ema achane Simeón mayana eta te Templo. Tacahe, títeca­panapa ena ticachichana ema Jesús. Námapaipa ema amuya. Náitaucha­yarehi eta vanairipiana taicha eta máuchusirahi ema suárachichahi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tacahe, te máimahapa ema Simeón ema amuya, mavehapa, majupacapa. Tásiha, macuna­cha­rinehi ema Viya te anuma. Macahepa ema Simeón: ");
INSERT INTO ignNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","—Tiuri puiti, Tata Náquenu te anuma, nuvarahapa nunaraca te juca apaquehe, nuti pivanarahi. Taicha núrisa­murepa eta nímairaipa ema Cristo. Étapaichuhi eta pimeta­runuhi. Nímatipa ema Ticatiu­ra­hi­que­ne­yarehi, ema pivaneruhi pitupa­raruhi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Éma, tímati­careya picha nayehe ena achaneana ticava­sanahi eta te tamutu avasareana. ");
INSERT INTO ignNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ticuna­cha­va­na­rinehi ena pinere­jiruana israelítana. Tíjara­hi­nevare te nasamure eta nacuna­chirahi. Éma, timicau­cha­vacaya ena apamuriana achaneana apava­sanana apaesa náimatiyare ema Viya —macahepa ema Simeón. ");
INSERT INTO ignNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Náraminehi ena ticachichana eta máechaji­ri­ru­vanahi ema Simeón mayehe ema­ amuya. ");
INSERT INTO ignNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tacahe, ema Simeón mayaseacapa ema Viya eta náurivaina éna. Tacahe, máichapa esu María esu maena ema amuya Jesús: —Pímaha. Ema maca amuya, matupa­ra­ca­si­vaichuhi me Viya eta máimitu­re­si­rayare eta máechaji­ri­ruvana ema Viya. Natiari­hi­ya­resera camuriana ena vijaneanana israelítana énaji­vayare tíchava­nayare, taicha náepuruyare ema pichicha, nacatia­na­ca­yareva. Tásiha, natiari­hi­ya­re­va­resera ena apamuriana vijaneanana tinara­ca­nayare tiúrica­va­nayare taicha eta nacasi­ñairaya éma. ");
INSERT INTO ignNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Étainapa tacaeche­raiyaya eta napane­re­rua­napachu te nasamureana. Éneri­chuvare, numetacavi piti María: Ichape eta picati­sa­mu­re­vayare, taicha pímahayare eta táiñehi­que­neyare máichara­ra­ca­vayare ema pichicha. Tímicu­ti­ji­ri­ca­vayare tayuva­ra­cahini eta pisamure eta tumare —máichapa ema Simeón. ");
INSERT INTO ignNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tiuri, sutiari­hi­hivare esu ésuna esena ichavi­cachicha. Ticame­ta­rai­rurahi ésu. Ticaijaruhi Ana. Ema suíyaini ticaijaréni Fanuel. Ésu, mámarie­quenehi ema víyarahaini Aser. Eta suámape­ruvahi ésu, siete año eta sucacha­nerahi ema suímaini. ");
INSERT INTO ignNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tásiha, ochenta y cuatro áñoripahi eta suépenai­mavahi. Sunasi­quenehi sucapenahi ésu eta te Templo. Tamutuhi sácheana, yátiana, tiyuja­racahi ésu. Suhayu­na­cha­hivare. ");
INSERT INTO ignNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tacahe, ema Simeón téchaji­ri­ca­vai­ni­richaha, títeca­panecha esu Ana. Eta suímairahi ema amuya Jesús, sucuna­cha­ri­ne­hivare ésu apana­hivare, suhasu­lu­pa­yachapa ema Viya máichavene ema amuya. Tásiha, sucame­ta­rairupa mayehe ema amuya. Suéchaji­sihahi éma nayehe ena tisuapa­ji­rai­rahana ticucha­panahi eta máiteca­pi­rayare te Jerusalén ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tiuri, náitauchapa tamutu eta mavanai­ripiana ema Viya eta te Sagrada Escritura. Tacahe, tichavanapa eta te Nazaret te Galilea, te návasaichuhi éna. ");
INSERT INTO ignNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tacahe, ema amuya Jesús tiúrijuruhi. Túmehi. Téchema­rahihi, tamutu maecha, taicha mamunavahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tiuri, tamutu áñoana te Páscuamuhuana, eta nayeherepi ena ticachichana ema amaperu Jesús, tiyana­na­yarehi tayehe eta avasare Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tacahe, ema Jesús, te macayehepa doce año, tatupa­ra­ca­ripahi ena ticachichana náimere­pa­na­yarehi éma, námayarehi tayehe eta Jerusalén, náimima­ti­cha­yarehi eta piesta ticaijare Pascua. ");
INSERT INTO ignNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tiuri, te jena táequenerapa eta piesta, tichavanapa te napena. Tímina­si­cha­va­pasera ema amaperu Jesús eta te Jerusalén. Eta napaisi­rapahi te achene, vahi náejiaca­va­nehini ena ticachichana, ");
INSERT INTO ignNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","taicha náimijachahi matiari­hipahi éma te namuri ena achaneana nacacha­ne­que­nea­napahi. Étana­ripahi sache eta napaisirahi, napaenu­mavapa náejiacahi éma. Te jena cápere­hi­quenepa, natanucapa te namuri ena najaneanana nacacha­ne­que­nea­napahi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Májinasera náichima­vahini. Tacahe, tichava­na­varepa te Jerusalén, natanu­pa­na­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tacahe, te jena mapana­quenepa sache eta natanu­sirahi, napaenu­mavapa náetupiacahi ema Jesús tayehe eta Templo. Macacha­ne­murihi, téjacahi te namuri ena máestroana. Masama­ra­ra­ca­vacahi, mayase­re­mu­ri­ha­va­ca­hivare éma apanavare. ");
INSERT INTO ignNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ichape­rinehi eta náraminehi namutu eta náimairahi eta máechema­raivahi, taicha táurivapahi eta majica­pi­ra­va­capahi éna, taicha eta máechema­raivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tacahe, tiárami­va­na­rinehi ichape ena ticachichana te náetupiacapa. Tásiha, suíchapa esu maena: —Nuchicha, ¿tájaha tacayema píchahavihi? Ichapemuri eta vicaña­ma­ra­si­ravahi pícha. Vitanu­ji­ri­ri­cavihi, núti éñipa eñi piya —suíchapa esu maena. ");
INSERT INTO ignNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tacahe, ema Jesús majicapapa: —¿Tájaha tacayema, meme, eta etanu­ji­ri­canuhi? ¿Váhipuca échahini éti eta návihairahi eta ani? Níchayare eta máemataneana ema Tata —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Énasera vahi nacaicu­tia­rahini eta macaye­ma­que­neanahi ema nachicha Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tacahe, tiyana­na­pasera tichavana te návasahi Nazaret. Ema Jesús, tisuapa­ji­rahihi nayehe ena ticachichana. Esu maena María tamutuhi supane­re­que­nehahi te susamure eta juca susama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tacahe, ema Jesús tijuru­capaipa, tijuru­ha­ca­pai­pavare eta máquehe, tacacha­ne­pa­hisera eta máitupa­ji­jia­si­ravahi. Máimica­tacahi ema Viya. Tétavi­ca­va­hivare eta náemuna­sirahi éma, ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tacahe, eta máepeni­raipahi ema aquenucaini Augusto, tisiapapa ema Tiberio máitsiva­quenehi. Émapa Emperadorhi. Quince áñoripahi eta macatu­pa­ra­hairahi. Ema Poncio Pilato, émaripa prefectohi tayehe eta departamento Judea. Tásiha, ema Herodes Antipas, machicha ema Aluresini, prefecto­hivare tayehe eta departamento Galilea. Ema maparape Felipe, prefecto­hivare éma, tayehe eta departamento Iturea étapa eta Traconite. Ema Lisanías, prefecto­hivare tayehe eta departamento Abilina. ");
INSERT INTO ignNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te Jerusalén, ema Caifás, corregi­dorhi. Éneri­chuvare tipicau­cha­carehi ema Anás, pasado corregidor, máimachuca ema Caifás. Tacahe, te jena sácheanahi, ema Juan machicha ema víyarahaini Zacarías, ajairaripa. Manasi­ri­cha­ha­hisera tayehe eta mávapahi majuru­sinehi. Tásiha, ticame­ta­casipa ema Juan eta mayehe ema Viya eta macame­ta­rai­rui­ra­yarepa eta máechaji­ri­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tacahe, tiyanapa tipaicahi ema Juan tayehe eta avasa­re­chichana tiávihanahi te tachausi eta cajacure Jordán. Mameta­ca­vapaipa ena achaneana. Ánipa maicha: —Ítsivacha eta epane­reruana. Éneuchava mayehe ema Viya apaesa maperdo­nachahe eta epeca­turana. Te éneucha­vapuca, núti nícacha­si­ca­hénapa —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Ema maca Juan, émaripa ema máechaji­si­ha­quenehi ema Viya eta te Sagrada Escritura, taicha ánaquia­pa­ripahi eta áñoana acane, ema Viya mametacapa ema víyarahaini profeta Isaías eta mapane­reruhi, eta mavane­si­rayare ema Machicha te juca apaquehe. Eta tímitecahi ticatiu­ra­hi­yarehi. Éneri­chuvare matiari­hi­yareva ema apana achane máichuha­que­ne­yarehi ema Viya. Macame­ta­rai­ru­yarehi, máetupi­ri­ca­va­cayare ena achaneana, náinaji­si­ra­yarehi eta napane­reruana tamauri­queneana, apaesa táuri eta najaca­pi­rayare ema Machicha ema Viya. Tacamu­nu­hivare yátupina eta nacasi­ñai­ra­va­yarehi mayehe, náinaji­ca­ya­re­hivare eta nacasi­ña­va­vai­sirahi, étapa eta navayua­raivahi. Nasapihahi tijapa­nu­ra­hia­nainapa éna. Tásiha, te máitecapapa ema ticatiu­ra­hi­yarehi, éma máimima­ti­chainapa namutu eta najaca­pa­ca­revaya me Viya namutu ena ticasi­ñavana mayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tacahe, ena achaneana tiyana­napaipa napauchapaipa ema Juan, navarahapa ticaica­cha­sia­nayare eta mayehe. Tásiha, éma máichavacapa: —¿Tájaha tacayema eta epauchi­ranuhi, eti tachicha­na­vea­na­tataji eta quichare? Esamai­ri­ri­ca­hipuca eta járaja­pai­ra­yarepa eta táiñehi­que­neyare ecuñaraqui. Evara­ha­hipuca iúchucu­hayare. ");
INSERT INTO ignNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tiuri puiti, te evara­hapuca eta iúchucuha, yátupina tátupiruva eta epane­reruana. Ímerecava eta ínaji­siraya eta epeca­turana. Váhivare ecuca­ja­murava eta mámarié­que­né­rahehi ema viáchucaini Abraham. Taicha tayanapane mámari­hepuca éma, váhisera iúchucu­haimahi te vahi ecuitsivacha eta epane­reruana. Ema Viya, tájina máemaitu­caimahi éma. Te mavara­hapuca, vahi máejeca­ra­chaimahi máepiyaca achaneanaina eta juca mari, mavarai­rainahi yátupina ena mámarie­que­neanaina ema Abraham. ");
INSERT INTO ignNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ecauneuchava, taicha tiánehipa títeca­pau­cha­heyare eta ecuñaraqui nayehe ena achaneana máituca­ra­hanahi téneuchavana, váhivare náitsiva­chahini eta napane­reruana. Tímicu­ti­ji­ri­cavaipa te máechuca­yarepa ema achane eta yucuqui máhireana; tásiha, máijuchainapa tamutu. Ene nacaheyare ena máeneucha­va­rahana —máichavacapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tásiha, ena achaneana nayase­recapa: —¿Tájahasica eta víchara­ca­vayare eta viúrivaina? ");
INSERT INTO ignNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ema Juan majicapapa: —Ecaji­ra­hiyare. Mácani tatiarihi apina eta macamisa, máijara­ca­si­cha­yarehi eta étana mácani tájina macamisaina. Énaripa nácani ticani­ruanahi, nacaji­yareva nácani tájina naviyahini eta nanicaquene —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Te jena sácheana, náiteca­pau­chavare ema Juan ena ticobra­re­ca­rahiana eta impuesto. Navarahapa ticaica­cha­sia­na­yarehi. Nayase­recapa ema Juan, náichapa: —Maestro, ¿tájahapuca víchara­cavaini eta viúrivainaini víti apanavare? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Majicapapa ema Juan: —Vaipa ecuapechava ecuva­yu­yujica eta ecobra­resira, tátupiruva jácani tavanai­ripihi eta ley —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Éneri­chuvare náitecapaucha ena suntaruana. Nayase­re­cavare ema Juan, náichapa: —Víti apanavare, ¿tájaha­pucaini víchara­ca­vayare eta viúrivaya? —nacahepa. Máichavacapa éma: —Vaipa ecuve­rejica eta náimaha­queneana ena achaneana. Váipavare ecuipi­ca­rareca. Nacuijapa ecuepi­ye­queneha. Tarataripa tacuri­sa­mu­rechahe eta evachasana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ena achaneana ticune­va­na­ripaicha eta mayehe ema Juan, náimija­chaipahi émaripa ema Cristo nacucha­pa­quenehi, cátiura­hi­yarehi. Váhisera námutuimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tásihasera ema Juan máichavacapa: —Yátupi núti nícacha­si­cahehi te une. Ávane­pai­pa­hisera mácani yátupiquene Cristo. Éma, tiápaju­pa­navahi nuyehe núti, eta mapicau­cha­ca­revahi. Váiparinehi nácuti­na­simahi eta máitupa­ji­jia­si­ravahi. Váipari­ne­hivare nácaemu­ña­vaimahi macamu­su­ra­nuhini nuti páuresami. Te yátupina ecasiñava mayehe, tícacha­si­ca­he­yareva; tíjara­ca­he­yareva ema Espíritu Santo. Téhesera vahi ecuca­si­ña­vapuca mayehe, tícuña­ca­heyare tayehe eta táijurequene yucu. ");
INSERT INTO ignNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Puiti éma máraja­painapa tinere­ji­ri­cai­napaipa nácani yátupi­que­neanahi téhica­nayare. Máunacainapa éna. Ticutinapa mácani achane te tiácata­ya­ji­ricahi eta arusu. Máunacainapa. Tásiha, máquijicapa eta tapiraquiji, máijucha­yarepa te yucu. Eta nacaheyare ena máurira­hanahi, tíjuanáinapa te yucu, máitava­ca­ca­yarehi eta tamuruira —máichavacapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tacahehi eta juca máechaji­si­ra­vacahi ema Juan. Ichape eta maconse­ja­chi­ra­vacahi ena achaneana, máimitu­si­ra­vacahi eta máechaji­riruva ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Émaripa ema Herodes Antipas ema aquenucahi, maconse­ja­cha­hivare vahi macuimi­yanava macuveha esu Herodías, mayenahi ema maparape Felipe. Váhivare macuimi­yanava macuquicha eta apamuriana táiñema­hi­queneana máichaqueneana. ");
INSERT INTO ignNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Émasera ema Herodes vahi masuapahini. Masapi­ha­richucha tisemahi, máimica­ra­tacapa ema Juan, macasia­pa­yarehi te cárcel. ");
INSERT INTO ignNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tiuri, te tamira­hu­paichaha eta macaera­tairaya ema Juan, tímiya­na­vai­chahahi máicacha­si­ca­vacahi ena achaneana. Étana sache, máiteca­pauchapa ema Jesús, mavarairahi ticaicachasi éma apanavare. Tacahe, te tamutupa eta macaica­cha­sirahi, mayuja­ra­sirahi. Tíjahú­chavapa téjiaca eta anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tiúcupaicapa ema Espíritu Santo, mavasi­ma­hipaipa eta paluma eta máimahi. Matupi­ru­ruchapa te mápusi ema Jesús. Tásiha, nasamapa eta mahu ema Viya te anuquehe. Ánipa macahehi: —Pítira nuchicha némuna­ruquene. Núrisa­murecha piyehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tiuri, ema Jesús, macaye­he­ripahi treinta año te tinacu­chavapa tímitu­recahi nayehe ena achaneana. Éma, náimija­cha­quenehi machicha ema José. Ema máiyainihi ema José, ema Elí. ");
INSERT INTO ignNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ema máiyaini­hivare ema Elí, ema Matat. Ema máiyaini­hivare ema Matat, ema Leví. Ema máiyaini­hivare ema Leví, ema Melqui. Ema máiyaini­hivare ema Melqui, ema Jana. Ema máiyaini­hivare ema Jana, ema José. ");
INSERT INTO ignNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ema máiyaini­hivare ema José, ema Matatías. Ema máiyaini­hivare ema Matatías, ema Amós. Ema máiyaini­hivare ema Amós, ema Nahum. Ema máiyaini­hivare ema Nahum, ema Esli. Ema máiyaini­hivare ema Esli, ema Nagai. ");
INSERT INTO ignNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ema máiyaini­hivare ema Nagai, ema Maat. Ema máiyaini­hivare ema Maat, ema Matatías. Ema máiyaini­hivare ema Matatías, ema Semei. Ema máiyaini­hivare ema Semei, ema José. Ema máiyaini­hivare ema José, ema Judá. ");
INSERT INTO ignNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ema máiyaini­hivare ema Judá, ema Joana. Ema máiyaini­hivare ema Joana, ema Resa. Ema máiyaini­hivare ema Resa, ema Zorobabel. Ema máiyaini­hivare ema Zorobabel, ema Salatiel. Ema máiyaini­hivare ema Salatiel, ema Neri. ");
INSERT INTO ignNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ema máiyaini­hivare ema Neri, ema Melqui. Ema máiyaini­hivare ema Melqui, ema Adi. Ema máiyaini­hivare ema Adi, ema Cosam. Ema máiyaini­hivare ema Cosam, ema Elmodam. Ema máiyaini­hivare ema Elmodam, ema Er. ");
INSERT INTO ignNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ema máiyaini­hivare ema Er, ema Josué. Ema máiyaini­hivare ema Josué, ema Eliezer. Ema máiyaini­hivare ema Eliezer, ema Jorim. Ema máiyaini­hivare ema Jorim, ema Matat. ");
INSERT INTO ignNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ema máiyaini­hivare ema Matat, ema Leví. Ema máiyaini­hivare ema Leví, ema Simeón. Ema máiyaini­hivare ema Simeón, ema Judá. Ema máiyaini­hivare ema Judá, ema José. Ema máiyaini­hivare ema José, ema Jonán. Ema máiyaini­hivare ema Jonán, ema Eliaquim. ");
INSERT INTO ignNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ema máiyaini­hivare ema Eliaquim, ema Melea. Ema máiyaini­hivare ema Melea, ema Mainán. Ema máiyaini­hivare ema Mainán, ­ ema Matata. Ema máiyaini­hivare ema Matata, ema Natán. ");
INSERT INTO ignNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ema máiyaini­hivare ema Natán, ema David. Ema máiyaini­hivare ema David, ema Isaí. Ema máiyaini­hivare ema Isaí, ema Obed. Ema máiyaini­hivare ema Obed, ema Booz. Ema máiyaini­hivare ema Booz, ema Salmón. Ema máiyaini­hivare ema Salmón, ema Naasón. ");
INSERT INTO ignNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ema máiyaini­hivare ema Naasón, ema Aminadab. Ema máiyaini­hivare ema Aminadab, ema Aram. Ema máiyaini­hivare ema Aram, ema Esrom. Ema máiyaini­hivare ema Esrom, ema Fares. Ema máiyaini­hivare ema Fares, ema Judá. ");
INSERT INTO ignNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ema máiyaini­hivare ema Judá, ema Jacob. Ema máiyaini­hivare ema Jacob, ema Isaac. Ema máiyaini­hivare ema Isaac, ema Abraham. Ema máiyaini­hivare ema Abraham, ema Taré. Ema máiyaini­hivare ema Taré, ema Nacor. ");
INSERT INTO ignNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ema máiyaini­hivare ema Nacor, ema Serug. Ema máiyaini­hivare ema Serug, ema Ragau. Ema máiyaini­hivare ema Ragau, ema Peleg. Ema máiyaini­hivare ema Peleg, ema Heber. Ema máiyaini­hivare ema Heber, ema Sala. ");
INSERT INTO ignNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ema máiyaini­hivare ema Sala, ema Cainán. Ema máiyaini­hivare ema Cainán, ema Arfaxad. Ema máiyaini­hivare ema Arfaxad, ema Sem. Ema máiyaini­hivare ema Sem, ema Noé. Ema máiyaini­hivare ema Noé, ema Lamec. ");
INSERT INTO ignNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ema máiyaini­hivare ema Lamec, ema Matusalén. Ema máiyaini­hivare ema Matusalén, ema Enoc. Ema máiyaini­hivare ema Enoc, ema Jared. Ema máiyaini­hivare ema Jared, ema Mahalaleel. Ema máiyaini­hivare ema Mahalaleel, ema Cainán. ");
INSERT INTO ignNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ema máiyaini­hivare ema Cainán, ema Enós. Ema máiyaini­hivare ema Enós, ema Set. Ema máiyaini­hivare ema Set, ema Adán. Ema Adán macaepi­ya­quenepa me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tacahe, ema Jesús, mávahá­caripa ema Espíritu Santo. Tásiha, ema Espíritu Santo eta mávasa­mu­re­chirahi, máimitu­caipahi eta mayani­ra­yarehi te mávapahi apaquehe. Majuni­ji­ca­yarehi eta cajacure Jordán. ");
INSERT INTO ignNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta sache macahehi tayehe. Tájinavare manicahini eta jena sácheanahi. Técuha­sa­murepa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tacahe, ema Váinaraji témeña­havapa mayehe. Mavarahapa macaete­ma­yarehi. Ánipa maicha: —¿Pécuhapa píti? Tacahe, pivaneca eta juca mari táepiyacava pan, taicha píti machichavihi ema Viya, ¿masi? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ema Jesús majicapapa: —Váhipuca pecha eta táechaji­ri­ruvahi eta Sagrada Escritura, ani tacahehi: “Vahi tácari­chuimahi eta tinicacare ticaita­re­cayare ena achaneana. Tacacha­ne­yarehi eta máechaji­riruva ema Viya. Jéhevare, éta ticaita­re­ca­ra­hiyare” —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tacahe, ema Váinaraji mámavarepa te táinahu eta anuquehe mari. Tíjahú­chavapa máimecha tamutu eta ichape­queneana avasareana te juca apaquehe ticuti­rinehi tacacha­ca­ya­ji­ri­ca­cahini taicha eta máitupa­ji­jia­si­ra­va­hicacha ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tásiha, máichavarepa ema Váinaraji: —Núti níjara­ca­viyare tamutu eta juca avasareana. Ichape eta napicau­chi­ra­viyare, nacuna­chi­ra­vi­yareva ena achaneana. Pítina náquenuvina ena távacuanahi eta avasareana. Taicha núti néchavacahi éna. Nútivare nécha mácani nuvara­ha­que­neyare níjaraca. ");
INSERT INTO ignNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pépuyu­ca­nu­masera te numirahu pitsiucanu apaesa níjara­ca­vi­sarepa tamutu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Émasera ema Jesús majicapapa: —Pévuisi­ha­tataji piti Satanás te juca numirahu. Váhipuca pecha eta táechaji­ri­ruvahi eta Sagrada Escritura. Ani tacahehi: “Macarichu ema Viya vépuyu­mi­rauchaya. Macari­chuvare vicaema­ta­nea­cayare” tacahepa. Váhiquene táurica nucaema­ta­nea­ca­vihini —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tacahe, vahi máevuisi­hahini ema Váinaraji. Mámavare te avasare Jerusalén. Máimiapanapa te táinahu eta Templo. Tásiha, máichavarepa: —Te yátupina machichavina ema Viya, písapa­vayare pémirica te anuquehe. Tájina píchavaimahi eta pémiri­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pécharichuhi eta táechaji­riruva eta Sagrada Escritura, ani tacahe: “Ema Viya mavanecapa ena mayeheana ángeleana téchapa­ji­ri­ca­via­nayare, éneva­ne­yarehi tijanea­caviana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tiámavia­nayare te navahuana, apaesa vahi picuca­yutetu eta máriana eta te pipaisirana” tacahepa. Tásiha, németeaca tijanea­ca­via­nayare puiti, vahi náisapaimahi picajara te pémirica —máichapa ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tacahe ema Jesús majica­pa­varepa: —Éneri­chuvare ani tacahe eta Sagrada Escritura: “Vahi picaitsa­ma­ra­jimahi ema Viya taicha éma Piáquenu” —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tacahe, tiyanapa ema Váinaraji. Majuni­jicapa ema Jesús taicha tímaha­vaipahi vahi máituru­cahini macaetema. Mavara­ha­hisera tichava­yarehi tiápecha­va­yarehi macaete­mapana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Tacahe, tépanavapa ema Jesús mapaica eta avasareana tayehe eta provincia Galilea. Ichape eta máitupa­ji­jia­si­ravahi taicha mávahá­capahi ema Espíritu Santo. Tímitu­re­capaipa tayehe eta náuruji­si­ra­revana te avasareana. Ichapemuri eta nacuna­chirahi namutu ena tisama­ra­ra­ca­napahi. Nasamai­ri­ri­ca­varepa ena apamuriana achaneana ticava­sanahi te tachacaya eta avasareana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tásiha, tiyana­varepa te avasare Nazaret te majuru­sinehi. Te jena sache sávaru, tiyanapa tayehe eta náuruji­si­rareva nayuja­rau­chirare ena achaneana, taicha tacahehi eta mayehe­repihi. Titupihapa ema Jesús, táicutiarahi eta mavarairahi téchaji­cureca eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Náichuha­sarepa eta máechaji­cu­re­siraya. Náijaracapa eta libro májurehi ema profetaini Isaías. Te mavejiacapa eta libro, matanucapa eta máechaji­cu­re­yarehi. Ani tacahehi eta táechaji­ri­ru­vanahi: ");
INSERT INTO ignNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tiávahá­canuhi ema Espíritu Santo. Taicha manere­ji­ru­nuichuhi núti ema Viya Viáquenu eta numeta­si­ra­va­cayare ena páureana eta juca máemuna­si­ra­vacahi éma, máimica­ta­si­ra­yareva. Eta tímite­canuhi nucana­ra­cayare ena ticati­sa­mu­re­vanahi. Nucaiti­ti­ji­ca­yareva ena máerata­ruanahi ema tivayuarahi Satanás. Nucaimai­ri­ri­ca­yareva ena púchuquiana. Nucuchu­cu­ha­yareva ena ticata­ji­vanahi, níjaracaya eta náurica­ca­revaya. ");
INSERT INTO ignNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Numeta­ca­yareva járaja­painapa eta sácheyare tamutuiraya máetupirica ema Viya, tamutuinapa tiúrisa­mu­ré­carepa máicha” tacahehi eta Sagrada Escritura eta máechaji­curehi. ");
INSERT INTO ignNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te tamutupa eta máechaji­cu­re­sirahi ema Jesús, máeratacapa eta libro. Máimichavapa mayehe ema tijanea­re­carahi eta líbroana. Téjaca­varepa ema Jesús. Náimara­ra­caripa ena achaneana natiari­hi­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tacahe, tépanavapa téchajica ema Jesús: —Nútiripa ema táechaji­si­ha­quenehi eta juca libro. Tímite­canuhi numetacahe eta máemuna­si­rahehi ema Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tacahe, náramipa namutu ena achaneana. Ánipa náichacaca: —¡Tétavi­cavahi tapachinava eta máechaji­ri­ru­vanahi ema maca! Émachu­chasera ema machicha ema Joséini ema carpintéroini. ¿Tájahasica eta juca? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Émasera ema Jesús máichavacapa: —Németeaca éti váhirichuhi esuapa­pa­ji­ca­nuhini. Tásiha, evara­ha­ri­nepuca íchanuyare: “Te yátupina píturue­queneha, pípuchavaca ena ticaju­manahi te juca. Vímahaséji piápecha­vavare picuchuca te juca piávasaichu tacuti eta pímereruhi te avasare Capernaum” ­ íchanuyare. ");
INSERT INTO ignNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nutupi­ru­vasera numetacahe: Tatuparaca eta epicau­chi­ra­haviya vimutu viti mavaneruana ema Viya. Étisera eti nujanea­nanahi ecava­sanahi eta te juca viávasa, vahi epicau­cha­nuhini, váhivare ejaca­panuini. Ecuti ena achaneana acane eta náepuruirahi ena apamuriana profetana mavane­ruanahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eta tacahe, eta máimairahi ema Viya eta náepurui­ra­vacahi, tivane­cavaca ena profetana nayana napauchayare ena apava­sanana. Acane, te matiari­hichaha ema profetaini Elías, mapana año y medio vahi taquivahini, tásiha, ichapevare eta ecuha. Németeaca núti camurianahi nácani ena tépenaimana israelítana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Váhisera étainahini macava­na­hi­yahini me Viya ema Elías eta nayehe ena majanea­nanahi. Ánaqui te avasare Sarepta tachacayahi eta avasare Sidón, étapa macava­na­hiyahi máiteca­pi­hayare suyehe esu ésunahi esena apavasana tépenaimahi. Ésupa máimica­taruhi táichavenehi eta susuapa­ji­raivahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Énaripa ena israelítana nacaju­ma­queneana eta lepra te jena sácheanahi te matiari­hichaha ema profetaini Eliseo. Váhivare énainahini macana­ra­cahini ena majaneanana. Masapihapa macana­racahi ema apava­sa­na­quenehi ticaijare Naamán, ticavasahi te Siria. Ema Naamán, tinara­caripa eta majuma, táichavenehi eta masuapa­ji­raivahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tacahe, eta juca máichira­vacahi ema Jesús, tisemanapa ena natiari­hi­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tásiha téchepu­mu­ri­hanapa éna. Nacuchucapa ema Jesús te tachachacu eta avasare, te tachausi eta táupenaquene, navarahapa nacami­ri­ca­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Émasera tichavapa mánucu­mu­ri­hapaipa éna. Tiyanapa, majuni­ji­ca­vacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tacahe, títecapapa ema Jesús tayehe eta avasare Capernaúm te Galilea. Tamutu sávaruana tiyanapa tayehe eta náuruji­si­rareva ena achaneana, tímitu­re­panaya. ");
INSERT INTO ignNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ichape náramihi ena achaneana eta máimitu­ra­pianahi taicha tétavi­cavahi eta máitusirahi mayuna­paicahi tamutu. Tétavi­ca­va­hivare eta tasuapa­ca­revahi eta máimitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Étana sávaru, matiarihihi te namuri ema émana achane mávaháruhi ema éreana. Tipiara­recahi, ánipa macahe: ");
INSERT INTO ignNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Núti nímativi. Pítira Sántoque­nevihi. Machicha­que­nevihi ema Viya. Pésami­ri­ca­ha­vipaini, piti Jesús Nazareno. Váhini picuesi­ru­ji­ca­havini. Pivara­hai­na­papuca picaja­ne­re­pai­ca­ha­viyare —macahepa ema achane. ");
INSERT INTO ignNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tacahe ema Jesús macajachapa ema éreana. Ánipa maicha: —¡Pámatina! ¡Piyana pijunijica ema maca achane! —máichapa. Tásiha, tíjahúchava tiáquipai­cavapa te apaquehe ema achane. Tásiha majuni­jiacapa ema éreana. Tájinasera máichavahini ema achane. ");
INSERT INTO ignNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Náraminehi ichape namutu ena achaneana eta náimairahi. Tiyase­re­ji­ri­ca­canapa: —¿Tájahasica tacayema eta juca? Ema maca Jesús, tétavicava eta máitupa­ji­jiá­si­ravahi, maratahahi máquijica nácani éreanana. Tásiha, ichape eta napisirahi éma. Vahi najica­pae­ma­chahini. Tamutupa arairu eta máimitu­ra­pianahi ema maca —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eneva­ne­varepa naecha namutu ena achaneana eta juca máichaque­neanahi ema Jesús. Énaripa ena ticava­sanahi te avasareana eta te provincia Galilea. ");
INSERT INTO ignNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Te tiúchucapa ema Jesús tayehe eta náuruji­si­rareva, tiyanapa te mapena ema Simón Pedro. Te tisiapapa, náechajiacapa ema Jesús máimaharine esu máimase ema Pedro. Ticajumahi ésu eta muraca fiebre. ");
INSERT INTO ignNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tásiha, mapauchapa ema Jesús. Máquiji­sinapa eta muraca fiebre. Tinara­ca­vanepa ésu, téchepu­ca­vanepa. Suéchapa­ji­ricapa éma, énapa ena ­ máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te jena cápere­hi­quenehi, te téricapa eta sache, ena achaneana námava­capaipa namutu ena nacaju­ma­queneana eta mayehe ema Jesús. Apana­pa­neneji eta najuma­napahi éna. Manacapaipa eta mavahu te náinahuana, macana­ra­ca­paipahi. ");
INSERT INTO ignNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mavera­navare ena éreanana máquiji­rua­napahi te náqueheana ena nacaju­ma­queneana. Tipiara­re­ca­napaipa eta náuchusi­rapahi. Ánipa nacahe: —Pítira Machicha­quenevi ema Viya. Émasera ema Jesús vaipa máisapahini náimiya­na­vahini napiaraca éma, taicha náimatihi éna eta émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te apanapa sache, te tijara­rahipa, tiyanapa ema Jesús te mávapahi. Natanu­ca­pasera ena achaneana. Náetupia­sirapa éma tayehe eta mávihahi. Navarahapa náimina­si­cha­ya­rehini. Vaipa náisapahini mayanahini. ");
INSERT INTO ignNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Émasera ema Jesús máichavacapa: —Nutupa­ra­ca­si­vaichuhi eta nuyani­rayare tayehe eta apana avasareana taicha nuvana­hi­richuhi eta níchuira­vacaya ena achaneana náehisiraina ema Viya apaesa macuchu­cu­havaca —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tacahe, tiyanapa tipaica ticame­ta­rai­rupaipa te náuruji­si­ra­revana tayehe eta avasareana te Galilea. ");
INSERT INTO ignNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Te jena sácheanahi, ema Jesús mávinehi te tachausi eta cáquiure ticaijare Galilea. Títeca­panapa ena camuri­queneana achaneana. Váipanecha nárata­vahini, tipami­he­ji­ri­ca­canapa eta navarairahi nasama eta macame­ta­rai­ruirahi ema Jesús eta máechaji­ri­ruvana ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Máimahapa ema Jesús eta apisi pacure te tachausi. Ena ticayeheana eta pacureana, tisipa­ji­ri­canahi eta ichape­queneana nayutaheana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tacahe, ema Jesús tiávacuhapa tayehe eta mapacurehi ema Simón Pedro. Mavanecapa máevataeca apaesachicha eta pacure. Téjacapa ema Jesús eta te pacure, tépanavapa máimitu­ca­vacapa ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te títapi­ricapa eta máimitu­si­ra­vacahi, máichapa ema Pedro: —Tata, iama eta juca epacure tayehe eta táupenamaiya. Iáquijieca eta ­ jara eyutahe —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ema Pedro majicapapa: —Maestro, tamutu yati vinajui­ricahi, tájinasera vítuca­vahini. Tavetijipa puiti eta tajara­hi­raripa. Nusuapa­visera eta juca pivane­si­ranuhi, náquijiecaya eta nuyutahe —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jéhesa­réinehi, te nachurucapa eta yutahe, tiyutu­tu­ca­vaipahi eta jímana. Vaipa tárata­vahini ténaru­jicapa eta ichape yutahe taicha eta tajita­careva eta jima. ");
INSERT INTO ignNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","10","Natiari­hi­hisera te apana pacure ena nachamuriana: ema Jacobo émapa ema Juan. Tacahe, náevehau­quichapa tímica­ta­ca­na­yarehi. Te títeca­panapa, náinicachapa eta apisiquene pacure. Tiánehi­ri­cha­havare vahi tárata­va­ya­rehini taicha eta tajita­ca­revahi, térica­ya­repaini eta pacure. Ichape eta nárame­sirahi namutu taicha eta náimairahi eta camuriquene jímana. Tásiha, ema Pedro máepuyu­mi­rauchapa ema Jesús. Máichapa: —Tata, pítiyara yátupi­que­névihi Viáquenuvi. Váhicha nímiuriacava nutupi­ha­mi­rauchavi núti. Nucape­ca­tu­ra­ra­hi­quenehi —máichapa. Matiarihihi ema Jacobo émapa ema Juan, machicha­naveana ema Zebedeo. Machamu­rianahi ema Pedro. Éneri­chuvare tiárame­ca­na­rinehi éna, énapa ena apamuriana natiari­hi­que­neanahi. Émasera ema Jesús máichapa: —Vahi picupica, Simón. Pínaji­cainapa puiti eta juca pémata­ne­repini. Núti níjara­caviya eta apana pémata­ne­re­piyare. Pitanu­cainapa ena achaneana nuchane­ranaya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tacahe, te nachuru­paicapa eta napacureana te tiájipahi, étapa nanaqui­sinehi. Tiyananapa náehicapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tacahe, eta mánucui­ra­paipahi ema Jesús eta avasa­rechicha, mácapa­jicapa ema émana achane macaju­ma­quenehi eta lepra, tamutu eta máquehe. Eta máimairahi ema Jesús, máiteca­pauchapa. Tépuyucapa te mamirahu. Máichapa: —Tata, nucasi­ñavahi eta piyehe, picana­ra­ca­nupaini. ");
INSERT INTO ignNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Majicapapa ema Jesús: —Nuvaraha nucana­racavi. Tájinapa píchiravaina puiti —máichapa. Manacapa eta mavahu. Éneva­ne­rinehi témitiacahi eta majumainihi. ");
INSERT INTO ignNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Matupa­ra­ca­pasera ema Jesús. Ánipa máicha: —Pímaha, nacuija picumetaca eta nútirahi nucana­ra­cavihi. Piyana­va­resera pímerecava nayehe ena tuparai­rucana, apaesa náimamacavi. Énainapa timeta­ji­ri­ca­nainapa eta yátupirahi pinaraca, pipachi­hairapa. Piyana­yareva me Viya. Picama­va­hu­ya­repahi eta pihasu­lu­pa­ya­chi­rayare taicha eta macana­ra­si­ravihi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tásihasera, náechapa namutu ena achaneana te avasareana eta máitupa­ji­jia­si­ravahi ema Jesús. Nayanau­chapaipa ena camuri­queneana achaneana, navarairahi nasama­ra­ra­ca­yarehi, macana­ra­si­ra­va­ca­ya­rehiva tayehe eta najumana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Émasera ema Jesús, majuni­ji­mu­ri­hachucha. Tiyanapa tayehe eta mávapa­hianahi apaquehe. Ánaqui mayuja­ra­si­ha­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Étana sache ema Jesús tímitu­recahi te tajuhe eta peti, camuriana ena achaneana. Natiari­hi­hivare ena fariséoana tépiya­cavana religiósoana, énapa ena escribá­noana, tímatiana eta nayehe­repiana ena israelítana. Éna, tiásihanahi te Jerusalén, ena apamuriana tiásiha­na­hivare te avasa­re­chichana tayehe eta Galilea, étapa te Judea. Ema Viya máimica­tacahi ema Jesús eta macana­ra­si­ra­va­ca­ya­repahi ena nacaju­ma­queneana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Títeca­pa­na­varepa ena apamuriana, námapahi te áchuji ema achane muracaha. Navara­hainipa nacasiapa te tajuhe te mávihahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Étasera eta nayutu­tu­si­ravahi ena achaneana, vahi náituji­ca­vahini nasiapahini. Tímipa­ne­re­cha­va­na­pasera náimiapanapa te tamaequehe eta peti. Naveta­ta­mae­quechapa eta peti te manapaicahi ema Jesús, nacaju­chu­chucapa ema macaju­maquene. ");
INSERT INTO ignNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tacahe, te máimahapa ema Jesús eta nacasi­ña­vairahi eta mayehe, máichapa ema macaju­maquene: —Tiuri, nuchicha. Eta pipeca­tu­ranahi, nucaepa­hai­navipa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ena escribánoana énapa ena fariséoana, eta napane­re­que­ne­hairahi eta macaye­ma­quenehi ema Jesús, tisema­na­rinehi. Ánipa nacahe te nasamureana: “Ema maca tímija­cha­vai­papuca Viya eta macaepa­hai­ra­yaréji eta pecatuana. ¡Tétavicava eta matapirava! ¡Taicha macarichu ema Viya marataha macaepaha eta pecatuana!” tacahehi eta napane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Émasera ema Jesús máimatihi eta napane­re­ruanahi. Máichavacapa: —¿Tájaha tacayema téjeca­pavahi eta epane­reruana? ");
INSERT INTO ignNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tájina táejeravaina eta níchirahi ema maca: “Nucaepa­hai­navipa eta pipeca­tu­ranaini”. Máejera­re­pá­napuca eta níchahini: “Péchepuca, piyana pipaica”. ");
INSERT INTO ignNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tiuri puiti, nuti Manere­ji­ru­nuhi ema Viya, nímereu­cha­vainapa eta nurata­hairahi nucaepaha eta pecatu te juca apaquehe. Ímara­racanu —tacahe, máichapa ema macaju­maquene—. Puiti nuchicha, nuvanecavi péchepuca. Piveha eta jara piyereruva. Piyana te pipena —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eneva­ne­rinehi téchepuruca ema macaju­ma­quenéni. Mavehapa eta mayereruva. Tipaicapa te namirahu ena achaneana. Tiyanapa te mapena. Ichape­rinehi eta macuna­chi­rapahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ichape­ri­ne­hivare eta náramirahi namutu ena natiari­hi­que­neanahi. Tétavi­ca­va­rinehi eta nacuna­chirahi ema Viya, napicau­cha­ri­ne­hivare. Ánipa nacahe: —Tétavi­cavapa tárami­careva eta juca vímaha­quenehi puiti —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Te táequenepa eta júcana, ema Jesús tiúchucapa. Eta mapaisi­rapahi, máimahapa ema achane ticaijare Mateo. (Ticaija­re­hivare Leví.) Téjacahi éma eta te macatu­pa­ra­haiyahi eta macobra­re­sirahi eta impuesto. —Yare, péhicanu —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Enurujipa téchepucahi ema Mateo. Manaquicapa tamutu eta matupa­ra­hainihi. Tiyanapa máehicahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tacahe, te jena sácheanahi, tépiya­recapa eta piesta ema Mateo te mapena. Máichuhapa ema Jesús eta máeniri­si­ra­yarehi, énapa ena camuri­queneana macuti­que­neanahi ticobra­re­ca­rahiana impuesto, énapa ena apamuriana máemuna­ca­sareana ema Mateo. ");
INSERT INTO ignNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Natiari­hi­hivare ena máimitureana ema Jesús. Tásiha títeca­pa­na­varepa ena fariséoana énapa ena escribánoana. Eta tímiya­na­vacahi, ticaeca­hi­re­ca­na­yarehi. Ánipa náichavaca ena máimitureana: —¿Tájaha tacayema ecacha­nemuri eta enisirahi ena nánita­tajiana ticobra­re­ca­rahiana eta impuesto? ¡Tétavi­cavahi eta nacape­ca­tu­ra­raivahi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Émasera ema Jesús, te masamai­ri­ricapa eta náechaji­ri­ru­vanahi, máichavacapa: —Ena majuma­reanahi vahi nácamu­nuimahi ema médico. ");
INSERT INTO ignNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Núti, vahi étaina tímitecanu nutanu­pa­na­va­cayare nácani matapi­ra­va­reanahi. Eta tímite­canuhi núti nutanu­pa­na­va­cayare ena tisipe­ca­tu­ra­na­panahi apaesa náitsivacha eta napane­reruana, náeneuchavapa me Viya —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tiuri, nayase­re­cavare ena achaneana ema Jesús: —¿Tájahapuca tacayema vahi ayúna­nai­nahíni ena pímitureana? Énaya­pasica ena máimitureana ema Juan náichahi eta muraca ayuna eta nayuja­ra­sirana. Énaripa ena fariséoana, éneri­chuvare. Tásiha, ena pímitureana píti tinicanahi, ­ térana­hivare —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Majicapapa ema Jesús: —Nímicu­ti­chinahe puiti. Vahi táuricaimahi ayúna­nai­nahíni icha ena íchuha­que­neanahi tinica­nayare nayehe ena araimana. Tiúrisa­mu­rea­na­yarehi taicha matiarihihi ema arayena. Tájina táuricahini ayúna­nai­nahíni. Téhesera te tépenapuca éma, jéhesare ticati­sa­mu­re­va­nayare. Tacutiquene, vuíchaha táuricaimahi ayúna­nai­nahíni ena nímitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Járaja­pai­na­pasera eta sácheyare, ticave­re­ji­ca­sia­nayare, taicha ticara­ta­ca­nua­nainapa ena ticapa­ca­nua­nayare núti. Jéhevarepa ayuna­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","38","Esama­nuchaha. Eta juca eta nímitu­ra­pianahi, amairiha arairu. Mavaraha ema Viya arairuyare eta eyehe­re­pia­nayare eti nuchanerana. Vaipa tácuti­ca­caimahi eta nayehe­repiana ena apamuriana achaneana. Eta ítusirahi éti eta nímitu­rapiana, tavaraha ínajica eta ichasi eyehe­repiana tamauri­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ticaje­rasera eta náinaji­sirahi ena achaneana eta nayehe­repiana tamauri­queneana. Apaesa­chi­charichu eta navarairahi naicha eta juca arairu nayehe­re­pia­nayare. Namutu­yaréni navaraha náimiyanava eta nayehe­repiana tásiha­que­neanahi eta napane­reruana ena náchuca­na­veanaini —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Eta jena sache sávaru­quenehi, tiyanapa tipaica ema Jesús. Mámamu­rihapa ena máimitureana. Témehi­ca­vanapa ena fariséoana. Náetavi­vi­ji­ca­paipahi eta isanitiana. Tacahe, eta napaisi­rapahi, ena máimitureana navechu­qui­ha­paipahi étaja­vapahi eta trigo. Navepi­ra­qui­hapaipa, tépura­ja­ca­cha­va­napaipa. Tinica­napaipa. Tísapa­ca­reichucha eta nanisira, taicha técuhanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tacahe, eta náimara­ra­si­rapahi ena fariséoana, tisema­napaipa. Ánipa naicha: —¿Tájaha tacayema vahi epicaucha éti eta juca sache tacapi­ca­hu­quenehi? Écharichuhi éti vahi tísapa­ca­rémahi eta vicaema­ta­nerahi puiti. Eta juca evepi­ra­qui­hapahi eta trigo, ticaijare ecaema­tanehi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tásiha, majica­pa­vacapa ema Jesús: —Németeaca éti vahi ecaicutiara eta tacaye­maquene eta Sagrada Escritura, eta máichava­que­nevahi ema víyarahaini David eta mapaisi­rapahi técuhapaipa, éneri­chuvare ena téhica­napahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Écharichuhi éti te masiapapa eta mapena ema Viya, tiyase­se­recapa eta manica­yarehi. Náijaracapa eta pan tacapi­ca­hu­quenehi nanaca­sarehi te namirahu ema Viya. Nanica­sarehi ena tiyuja­ra­ca­rahiana émasera ema David vahi tátupa­ra­cahini manicahini. Étasera eta máecuavahi, manicapa eta pan, énapa ena macacha­ne­que­nea­napahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tiuri puiti, numeta­ca­heyare: Nuti Manere­ji­runuhi ema Viya, nútirichu néchahi eta sache nanara­si­rayare ena achaneana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tiuri, te apanapa sávaru, tiyana­varepa ema Jesús tayehe eta náuruji­si­rareva. Tímitu­re­ca­varepa. Tásiha, matiarihihi ema émana achane, ticajumahi eta mavahu váure. Vaipa tayamu­ri­cahini, tépena­vahuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Natiari­hi­hivare ena escribánoana, énapa ena fariséoana. Náimaha­ripahi ema Jesús te macana­ra­ca­ya­re­hipuca ema macaju­maquene eta jena sache tacapi­ca­hu­quenehi. Natanu­nui­ricahi eta tiviucha­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Émasera ema Jesús máimatihi eta napane­reruana éna. Tacahe, máechajicapa ema achane ticaju­ma­vahuhi. Máichapa: —Yare, pitupi­hayare ani te namirahu ena achaneana —máichapa. Tásiha, titupihapa ema achane te namirahu. ");
INSERT INTO ignNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tásiha, máichavacapa ­ ema Jesús: —Nuvaraha epane­rechaya. Puiti juca sache sávaru­muhuhi, táuricahi víchaya eta táuriqueneana, ¿masi? Táuricahi vípuchayare ena nacaju­ma­que­neanahi, ¿masi? ¿Ímija­chapuca tiúriyare eta víchirayare eta tamauri­queneana, vicapa­re­capuca ena achaneana? ¿Tájahasica eta epane­rechahi? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tacahe, ema Jesús máeseni­mu­rihapa ena achaneana. Tásiha, máichapa ema achane macaju­maquene: —Nímaha, picaja­ru­vauchava pímereca eta pivahu —máichapa. Eta máimere­sirahi eta mavahu ema achane, enevanepa tinara­vau­cha­vanepa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tacahe, tisema­na­rinehi ena fariséoana eta náimairahi. Tásiha, tiyase­re­ji­ri­ca­canapa: —¿Tájahapuca vícharacaini ema mácatataji eta táimica­viúchaini? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te jena sácheanahi, tiyanapa ema Jesús tayehe eta tápusi eta márijuecu. Tamutu eta jena yati tiyuja­racahi me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te tijarahipa, máichuha­vacapa namutu ena máimitureana. Manere­jicapa ena dócequeneana mayehea­na­yarehi apóstole. ");
INSERT INTO ignNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ena nani ena manere­ji­ruanahi: ema Pedro (éma ticaija­revare Simón), émapa ema mapara­peichuhi ticaijare Andrés; émapa ema Jacobo émapa ema maparape Juan; émapa ema Felipe; émapa ema Bartolomé; émapa ema Mateo; émapa ema Tomás; émapa ema apana Jacobo; émapa ema apanavare Simón; émapa ema Judas; émapa ema Júlasi Iscariote (ema tíjara­recahi ema Jesús). ");
INSERT INTO ignNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tacahe, tichavapa ema Jesús, énapa ena máimitureana. Te tachachacu eta mari táinuna­pa­hinepa, étapa nacainu­nainehi ena camuri­queneana achaneana. Ena nani tiásihanahi eta te avasare Jerusalén, eta te provincia Judea, étapa eta provincia Siria. Eta tímite­canahi éna, navarahahi nasama ema Jesús eta máimitu­rapiana, navara­havare macana­ra­ca­va­cahini tayehe eta najumana. ");
INSERT INTO ignNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ena ticata­ji­vanahi návahá­ruanahi ena éreanana, macana­ra­ca­va­ca­pasera ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Namutu ena achaneana navarahahi náemamahaca ema Jesús taicha náechahi tinara­ca­na­yarehi eta najumana eta náemama­ha­si­rayare taicha títupa­ji­jia­cavahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tacahe, máeseni­mu­rihapa ema Jesús ena máimitureana. Máichavacapa: —Éti ímatihi eta tacamu­nu­que­neanahi eta iáchanevana, tétavi­cavahi eta iúrica­ca­re­va­yarehi taicha máejerare eta ejaca­pi­rayare eta máechaji­riruva ema Viya, machane­ra­hé­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Eti ejamu­rachahi puiti eta ítare­sirahi eta matapi­ra­va­recare te mamirahu ema Viya, tétavi­cavahi eta iúrica­ca­re­va­yarehi taicha tíjara­ca­heyare éma eta evara­ha­quenehi. Eti íyaucha­vanahi puiti taicha eta epeca­turana, tétavi­cavahi eta iúrica­ca­re­va­yarehi. Títeca­painapa eta evapi­na­vairaya, écavainapa, taicha eperdo­na­cha­careya me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Eti nuchane­ranahi, járaja­painapa eta sache ticatia­na­ca­hea­nainapa ena achaneana, navara­hainapa tiáquiji­caheana. Tipana­ra­ra­cha­hea­nainapa. Nacatia­na­pi­cainapa eta íjareana. Eta juca náichira­he­yarehi, táichavenehi eta éhisi­ranuhi nuti Manere­ji­ru­nuhi ema Viya. Váhisera ecuarami eta juca. Ene nacahehi eta nacata­ji­vairahi ena profetanaini. Te ticatia­na­ca­heanahi, ¡ecuri­sa­mu­re­cha­vachucha, evapi­na­vavare! ¡Tétavicava eta iúrica­ca­revaya taicha ejaca­painapa eta ícuchi­richuhi te anuma! ");
INSERT INTO ignNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tacahe, ema Jesús máechajicapa ena apamuriana achaneana, tímicu­ti­ji­ri­cavahi natiarihihi te mamirahu, tiyere­hia­na­hisera éna. Ánipa máicha: —Eti evapi­navapa eta ecaima­ha­que­nerahi, páurehe­sa­miyare éti. Tíchecu­hainapa eta evapi­nai­ra­vainihi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Páurehesami eti esatu­he­he­re­canahi, taicha ichapenapa eta écuhairaya. Páurehesami eti ecasa­mureana eta piesta, écarai­ri­cavahi, taicha ichapeyare íyairaya, ecati­sa­mu­re­vainapa. ");
INSERT INTO ignNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Páurehesami eti namuna­neanahi ena achaneana. Eta tacahehi eta nacuna­chi­ra­vacahi ena profetana tépiya­ca­vanahi tímija­chavana mavana­ranahi ema Viya, tivayua­ra­hia­na­hisera. ");
INSERT INTO ignNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Puítiripa eti esama­nuanahi, numetacahe: Émuna­cayare ena ticatia­na­caheana. Ímereca eta iúriva nayehe ena ticati­cha­heanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Eyaseaca ema Viya eta nayuja­rahuina nácani téchaji­canahi eyehe. Eyujaraucha ena tiúmeha­heanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te máehahepuca mácani achane te emira, vahi ecujicapa. Íjara­casera eta étachacaya eta emira. Te navere­ji­ca­hepuca eta esacu, ísapayare. Te navere­ji­ca­hevare eta ecámisa, éneri­chuvare ísapayare. ");
INSERT INTO ignNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Énaripa nácani tiyasea­ca­heanahi eta ecaji­rayare, íjaracaya. Te naverejicahepuca eta ímaha­queneana, vahi ecucamesa eta náimichaviraina. ");
INSERT INTO ignNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Numetacahe eta apana: Te evaraha eta náuriraya ena achaneana eta eyehe, titupa­racahe iúriyare éti eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Éti, tájina ecuna­cha­ca­re­vaimahi eta me Viya, te nacarichuhi émunaca nácani témuna­ca­heanahi éti. Apanasica témuna­rahiana ena máimati­ra­hanahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tacutiquene, tájinavare ecuna­cha­ca­re­vaimahi me Viya, te tacarichuhi icha eta táuriqueneana nayehe ena tiúrianahi eyehe. Apanasica títsiri­ji­ca­vanahi ena máimati­ra­hanahi ema Viya. Titupa­racahe ecachu­ri­ca­va­cayare eta iúriva. ");
INSERT INTO ignNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Téhevare nacari­chupuca íjaraca nácani títsiri­ji­ca­vanahi te ticapu­caheana, tájinavare tacuna­cha­ca­revaina eta me Viya. Apanasica ena máimati­ra­hanahi ema Viya tíjaracana ena títsiri­ji­ca­vanahi te ticapu­recana. ");
INSERT INTO ignNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Étisera émuna­cayare ena ticatia­na­caheana. Íchayareva eta táuriqueneana nayehe namutu. Íjara­cavare nácani ticapu­caheana. Vahi ecucuchapa eta náitsiri­ji­rá­piyare. Máimaharine ema Viya. Éma tíjara­ca­heyare eta táitsiva­yarehi eta iúrivanahi. Eta tacahehi eta ímereu­chirava eta machichaheira ema Tata Vicaiyaquene. Taicha éma, tétavi­cavahi eta máuriva nayehe namutu ena váinara­ji­queneana énaripa ena máechava­ra­hanahi eta máemuna­si­ra­vacahi éna. ");
INSERT INTO ignNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ejapa­nu­ra­hi­yareva, ecutiyare eta majapa­nui­ra­havihi ema Tata Vicaiyaquene. ");
INSERT INTO ignNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Vahi ecunemahi eta náejeca­pi­ravana ena apamuriana achaneana, váhivare ecucae­ca­hivaca, machu étina táimicu­ñacahe me Viya. Te máejeca­pa­vapuca mácani achane, vahi ecuvaraha macaicu­ñavane, apaesa vahi macuicu­ñacahe éti ema Viya. Eperdonacha ena téjeca­pavana eyehe apaesa maperdo­nachahe ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ecaji­rahiya nayehe ena achaneana. Ema Viya títsiri­ji­ca­vayare eyehe. Tímepa­ná­vainapa eta máijara­ru­heyare éma. Te iúrihi éti nayehe ena achaneana, ema Viya, tétavi­ca­va­yarehi eta máurivaya eta eyehe éti. ");
INSERT INTO ignNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tacahe ema Jesús, ánipa tacahe eta máimiturapi, máimicu­ti­chirahi: —Váiparinehi tichuru­ca­ca­naimahi ena apinana púchuquiana, taicha tiáquipai­ca­va­na­yarehi te pusu. ");
INSERT INTO ignNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Émaripa mácani amaperu te escuela­hipuca, váiparinehi macachu­ri­caimahi mácani mayehe maestro. Tapaenumava te máitucapa, macuti­sarepa ema mayehe maestro. ");
INSERT INTO ignNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Vahi táurica eta ecunerahi eta ánichi­cha­queneana náejeca­pi­ravana ena apamuriana achaneana. Titupa­racahe ecuneuchava eta táichapeva eta éjeca­pirava étijiva. ");
INSERT INTO ignNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vahi titupa­ra­ca­hemahi étupirica eta jácani ánichi­cha­quenehi máejeca­pi­ravahi ema eparaepiya. Tájina eviyahini eta econse­ja­ra­pi­nahini. Ichapesera eta tatupa­ra­si­rahehi étupirica eta éjeca­pi­ra­vanahi éti. Tapaenumava eta étupi­ri­sirapa eta íchava­que­né­vanahi, táuricapaini econsejacha ema eparaepiya tayehe eta máichava­que­névahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tacutiquene tímati­ca­re­hivare eta táhiana eta yucuquiana. Jararihi eta tinica­careana. Jarari­hivare eta vahi tánicacare. ");
INSERT INTO ignNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Éneri­chuvare eta yucuqui tímati­carehi eta táurinisiva eta táhi. Étaripa eta sitavere, váiparinehi tiúchucaimahi eta táhihini narasa­hi­na­hi­pucaini. Tásiha, eta ijicaqui váipari­ne­hivare tacahimahi eta tahi cachiche­ru­hi­nahini. ");
INSERT INTO ignNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ene nacahe nácani tiúriana achaneana tatupi­ruvahi eta náechaji­ri­sirava taicha tiúrihi eta nasamure. Nácanisera achaneana váinara­ji­pa­ne­reruana, vahi tiúrimahi eta náechaji­ri­sirava. Tíñema­hi­pi­vacahi taicha eta tavayuchahi eta tavaina­rajiva eta nasamure. ");
INSERT INTO ignNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Tájaha tacayema eta échajicanu éti, “Tata náquenu” ecahepa; tásiha vahi esuapahini eta nuvanai­ripiana? ");
INSERT INTO ignNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nácani tisuapa­nuanahi náitaucha­hivare eta nuvanai­ri­pianahi, téchema­ra­hianahi táicha. Nuvaraha nímicu­ti­chinahe éna. ");
INSERT INTO ignNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nacuti­yarehi mácani títuca ticatu­piareca peti, manaca­yarehi eta túmeana yucuqui emuruquiana. Tiúpena­vacahi máicha eta masucu­queruana. Jéhesare te járajapapa eta muraca técaticava, tiámaquiha eta tiquiva, tisiamapa eta une, váipasera tacaeya­ya­cahini eta peti, taicha máetupi­ricahi eta máepiya­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Narari­hivare ena tépiya­cavana tisuapanuana, váhisera náitauchahini eta nuvanai­ripiana. Éna nacutihi ema máitucaraha tépiyareca peti. Vahi manacaimahi eta túmeana yucuqui, váhivare táusiapi­rahini máicha. Te járajapapa eta muraca técaticava, tisiama­varepa eta une, tacaji­mu­ya­paicapa eta apaquehe. Tíjahú­chavapa tiáquipaicava eta peti, témitie­quenepa tamutu —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tiuri, te títapi­ricapa ema Jesús eta máimitu­si­ra­vacahi ena achaneana, tichavapa eta te avasare Capernaúm. ");
INSERT INTO ignNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Matiarihihi ema achane apavasana. Comandante éma nayehe ena suntaruana romanoana. Capitán eta mávacure. Ticajumahi ema mamusura. Tiánehi­ripahi tépena. Ichape­rinehi eta máeñami­ravahi taicha máemuna­ru­quenehi ema mamusurahi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tacahe, te masamai­ri­ricapa ema capitán eta matiari­hirahi ema Jesús, máevata­ca­vacapa ena náiyamu­rianahi ena israelítana náichuha­pa­na­yarehi ema Jesús, macana­ra­si­na­pa­nahini ema mamusura. ");
INSERT INTO ignNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Tacahe, te náiteca­pauchapa ema Jesús ena vanairu­canahi, nayaseacapa, ánipa naicha: —Mararihi ema capitán te viávasahi. Ichapemuri eta máimica­ta­si­ra­havihi. Máemepi­ya­re­ca­hivare eta ichape peti eta viúruji­si­rareva eta viyuja­ra­si­rarehi. Tásiha puiti, tivane­ca­havihi víchuha­panávi picata­ji­cahini picana­ra­si­na­pa­nahini ema mamusura. Tatupa­racahi pímica­tacaini ema maena —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tacahe, ema Jesús tísapavapa tiyana, máehica­vacapa éna. Étasera te tiánehianapa eta mapena, mavane­ca­vacapa ema capitán ena máimati­ca­sareana, nametapana ema Jesús. Ánipa naicha: —Tata Jesús, eta juca máechaji­ri­ruvahi ema capitán: “Tata, vahi picucae­ña­macava eta pítesiraina eta nuyehe, taicha vahi táuricahini pisiapau­cha­nu­sa­mihini te nupena. ");
INSERT INTO ignNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Eta tacahe, vahi nupatsi­ca­vahini nútija­ca­rú­vai­nahini níchuha­panávi. Németeaca tarata­harichu picava­nairipi eta picana­ra­siraya ema numusura. Taicha núti nusuapahi te tivane­canuana ena anuque­he­pa­nanahi eta nuyehe. Nútiripa nusuapa­ca­re­hivare nayehe ena nusunta­ru­ranahi. Te nuvane­cavaca, téhevare níchuha­va­capuca, tisuapa­nuanahi. Te nuvane­capuca ema nuvaneru, enurujipa tisuapa­nuvane” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te masamapa ema Jesús eta juca, ichape­rinehi márami eta yátupirahi macasi­ña­vairahi eta mayehe. Máichavacapa ena téhica­napahi: —Numetacahe: Nájina nímaha émanaina vijaneana israelíta mácutini ema maca achane apavasana eta macasi­ña­vairahi eta nuyehe —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tacahe, nacarinepa tichavanahi ena vanairucana. Te títeca­panapa, náimaha­rinehi ema macaju­ma­que­nehini, tinara­caripa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te táequenepa eta juca, tiyana­varepa ema Jesús tayehe eta avasare ticaijare Naín. Náehica­pa­hivare ena máimitureana, énapa ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te títeca­pa­na­yarepa te avasare nácapa­ji­ca­vacapa ena achaneana tiámanapahi ema máepenaquene, náecara­yarehi. Camuria­na­pa­hivare ena achaneana téhica­napahi. Éma máepena­quenehi, macarichuhi suchichahi esu esena suépenai­ma­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eta máimairahi ema Viáquenu, majapa­nu­rinehi esu esena. Tásiha, máichapa: —Vahi picuiyaha —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tásiha, mapauchapa ena tiámanapahi ema máepenaquene. Titupi­hanapa éna. Máemama­hicapa eta macajone. Tásiha, macahepa: —Nuchicha, núti nuvanecavi, péchepuca —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eneva­ne­rinehi téchepucapa ema amaperu máepena­que­nénihi. Téchajicapa ema amaperu. Tásiha, ema Jesús máijaracapa esu maena. ");
INSERT INTO ignNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tacahe, ichape­rinehi tiárami­carehi eta juca nayehe ena camuri­queneana achaneana. Ánipa nacahe: —Tétávicava eta macuna­cha­careva ema Viya. Jéhevare ema maca achane yátupiquene profeta, mavaneruhi ema Viya. Tétávi­cavapa táurisa­mu­re­careva eta máuchusirahi te vimuri —nacahepa. Ena apamuriana ánivare nacahe: —Ema Viya tiúcupau­cha­havihi tímica­ta­pa­na­hávihi viti machane­ranahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eta juca máichaquenehi ema Jesús, téchaca­re­vanepa tamutu avasareana te návasanahi ena israelítana. Títeca­varepa te táyere­hi­queneana avasareana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Éneri­chuvare ema Juan, te mávihahi te cárcel, masamai­ri­ricapa eta juca taicha nametacapa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tacahe, máevatacapa ena apinana, nayase­re­pa­na­yarehi ema Jesús te yátupi­hipuca émaripahi ema Cristo ema macucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tacahe, ena vanairu­canahi me Juan náiteca­pauchapa ema Jesús. Nayase­recapa, ánipa náichahi: —Ema viáquenu Juan tivane­ca­havihi viyase­re­pa­na­viyare te yátupi­hipuca pítiri­pa­hipuca Cristo ema vicucha­pa­quenehi. ¿Téhese­rapuca vímiya­na­va­ya­repuca vicuchapa? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eta náiteca­pau­chirahi ema Jesús, éma ticana­ra­re­re­cai­chahahi ena nacaju­ma­queneana, énapa ena nacaja­ra­queneana. Máquiji­cavare ena éreanana tiávahá­canahi nácani achaneana. Macaimai­ri­ri­cavare ena mavera­queneana púchuquiana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tacahe, ema Jesús majica­pa­vacapa ena vanairu­canahi me Juan. Máichavacapa: —Nuvaraha ímara­racaya eta níchaqueneana puiti. Nucaimai­ri­ri­ca­vacaipa ena púchuquiana. Nímipai­siraipa ena masariana. Nucana­ra­ca­vacaipa ena leprósoana, énapa ena túhuquiñana. Nucaeche­pu­si­ra­va­cai­pavare ena náepena­que­neanaini. Éneri­chuvare níchuhahi ena páureana náeneuchava apaesa náuchucuha. Tásiha, eyana emetaca ema Juan tamutu eta níchaque­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vaipa macueñamava ema Juan eta nuyehe. Tétavi­cavapa eta máurica­ca­revahi éma, te ticasi­ñavahi eta nuyehe —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tacahe, tichavanapa ena vanairu­canahi me Juan. Tásiha, tépana­va­varepa téchajica ema Jesús, máechaji­sihapa ema Juan. Ánipa macahe eta mameta­si­ra­vacahi ena achaneana: —Nuvaraha epane­reu­chayare ema Juan. Te jácani vuíchaha nacara­ta­cahini éma, te eyanapa te mávapahi apaquehe te mávihahi, ¿tájaha eta epane­reruana tayehe eta macame­ta­rai­ruirahi? Éti ímija­cha­vai­papuca mamapa­chi­chi­ji­ri­ru­vaichucha eta máechaji­sirahi tacutihi te vímararaca eta taflurena eta acutena te tacaya­mu­ri­ri­jicahi eta técaticava. ");
INSERT INTO ignNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ímija­chai­pa­va­repuca tavayuaruhi ema tiúrina­ná­ca­va­yarehi eta macamui­ri­hairahi. Écharichuhi éti mácani tiúrina­na­cavahi, píncanillahi eta máitaresira, váiparinehi tiúchucaimahi te sache, váhivare tiyanaimahi te mávapahiana apaquehe. Manasi­que­ne­yarehi te jácani tiúrina peti. ");
INSERT INTO ignNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nuyase­recahe: ¿Nájahapuca ímijachahi éma? ¿Ímati­hipuca eta profetairahi éma? Núti numetacahe: Matupi­ruvahi eta macame­ta­rai­ruirahi ema Juan. Mavaneruhi ema Viya eta yátupi­quenehi profetahi éma. Nájina mácutihini ena apamuriana profetana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ema maca Juan émara máechaji­si­ha­quenehi ema Viya eta te Sagrada Escritura, ánipa macahehi: “Nuvane­cayare ema tínapu­mi­rau­cha­vi­ya­repahi ema ticame­ta­rai­ru­ya­repahi, apaesa natseca­vapaipa ena achaneana eta najaca­pi­ra­viyare” tacahepa eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Núti nutupiruva numetacahe: Ema maca Juan, nájina mácuti nayehe ena achaneana. Tétavicava eta macuna­cha­ca­revahi. Iápaju­pa­na­va­hisera eta ecuna­cha­ca­revahi eti nuchane­ranahi, apaesa­chi­charipa eta ecaicu­tia­rairahi eta mapane­re­ruanahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ena achaneana, énaripa ena tisipe­ca­tu­ra­ra­hia­naini, náimatiacahi ema Juan eta mavane­ca­sivahi me Viya. Nasuapa­hivare eta mameta­rairuana ema Juan. Eta tacahe, ticaica­cha­sianapa mayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Énasera ena fariséoana énapa ena máestroana, éna máisapa­va­ra­hanahi nacaica­cha­sihini mayehe ema Juan. Témepu­ru­re­ca­va­naripa eta náuriva­ya­rehini maicha ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Etiarihihi eti achaneana puiti juca sácheana, eta emasua­pa­ji­raivahi, nímicu­ti­chi­nahesa ena amaperuana tiútseruanahi. Apapi­pi­jichucha eta nacaye­ma­que­nea­napahi. Ema apana macahe­papuca: “Vépiyacapa eta piéstachicha”. Énasera ena apamuriana vahi náisapa­vahini. Tásiha, ema apana macahepuca: “Vépiyacapa eta ecari”. Váhiva­resera náisapa­vahini. ");
INSERT INTO ignNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ema Juan Tícacha­si­ri­carahi, te tímere­cavapa, muraca eta máimitu­ra­pianahi. Eta manica­sareana, vahi tácutihini eta nanica­sareana ena achaneana. Narari­hisera te emuri ena tépiyae­que­ne­hanahi éma. Náimijachahi mávaháruhi ema éreana. ");
INSERT INTO ignNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Núti Manere­ji­ru­nuhi ema Viya, eta níteca­pau­chi­rahepa, nucacha­ne­heripa eti achaneana eta enisirahi. Etiari­hi­hi­va­resera eti épiyae­que­ne­hanuhi: “Ímaha ema maca, cánisiu­qui­tataji, cávahárasi. Macacha­ne­va­capaipa ena cóbrare­ca­ra­hia­na­tataji énapa ena apamuriana nasipe­ca­tu­ra­ra­hi­que­neanahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Éti épiya­cavapa épururahi, ticuti­rinehi yátupi­nahini échema­ra­hihini. Tétavi­ca­va­hisera eta éjeca­pi­ravahi taicha eta emasua­pa­ji­raivahi. Te yátupi­hi­pucaini échema­ra­hihini, ímati­nuhini eta nucava­na­hirahi eta me Tata­. ");
INSERT INTO ignNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Matiarihihi ema achane ticaijarehi Simón, fariséohi éma. Macumpi­rachapa ema Jesús, manipana te mapena. Masuapa­hisera ema Jesús. Tiyanapa. Te tiúripa eta tinicacare, téjacapa te mesa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Susamai­ri­ricapa esu ésuna esena tisipe­ca­tu­ra­ra­hinihi eta matiari­hirahi ema Jesús te mapena ema fariseo. Tásiha, tiyanapa supauchahi ema Jesús. Suámapaipa eta bótechicha. Tínicapahi eta táijiyequene perfume tasiva­cha­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tépuyucapa te máivapeana ema Jesús. Tíyaha­cavapa, táetsipa­pa­pe­vachapa eta sutsera. Suájahapa te suchutimaca. Tásiha, suépusa­pe­va­chavare eta suámaque­nepahi perfume, sutsiuca­pe­va­chavare. ");
INSERT INTO ignNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tacahe, eta máimairahi ema fariseo eta juca, mapane­re­que­nehapa. Téchajicapa te masamure: “Te yátupi­nahini profetai­nahini ema maca, máimatia­ca­ri­pahini esu suca esena eta susipe­ca­tu­ra­rai­va­ta­tajihi. Vahi táuricahini suémama­cahini” macahe­sa­murepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Émasera ema Jesús masamahi eta mapane­reruhi ema fariseo. Máichapa: —Simón, jucarihi nuvaraha numeta­caviya. Ema fariseo majicapapa: —Nímahaseji, pimetacanu, maestro —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tacahe, ema Jesús máimicu­tia­ra­chinapa, máichapa: —Natiarihi ena apinana ajairana ticante­veanahi mayehe ema rico. Ema émana ticantevehi quiniento; ema apana ticantevehi cincuenta. ");
INSERT INTO ignNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tacahe, vahi nárata­hahini navacha­chahini eta nanteveana. Tásiha, maperdo­na­cha­vacapa ema rico ena apinana. Tiuri puiti, nuyase­re­ca­viyare. Ena nani apinana, ¿nájahapuca ema témuna­ca­panahi ema rico? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Majicapapa ema Simón: —Ticutimahi ema tisinte­ve­panahi. Tacahe, máichapa ema Jesús: —Pímahai­pajira. ");
INSERT INTO ignNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tacahe, ema Jesús máimara­ra­ca­ripahi esu esena. Tásiha, máichapa: —Pipanereaca esu suca esena. Puítihi, te nusiapapa te pipena, vahi pímisi­pa­cahini eta nívape. Ésusera esu suca esena tisipa­pe­va­chanuhi te sutsera, tiájape­va­chanupa te suchutimaca. ");
INSERT INTO ignNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Píti vahi pitsiuca­nuhini eta pijaca­pi­ranuhi. Ésusera, ichape­murihi eta sutsiuca­pe­va­chi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Váhivare piámasi­cha­nuhini eta aceite eta pijaca­pi­ranuhi. Ésusera esu suca esena tisipa­pe­va­chanuhi eta te táijiyequene perfume. ");
INSERT INTO ignNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yátupi tisipe­ca­tu­rainihi esu suca. Numeta­ca­vi­ya­resera, nuperdo­na­cha­ripahi ésu tamutu eta supeca­tu­ranaini. Eta tacahe, ichape eta suímere­sirahi eta yátupirahi eta suémuna­si­ranuhi. Nácanisera apaesa­richuhi eta napeca­tu­ranaini, apaesa­ri­chu­hivare eta náemunaraiva, taicha apaesa­ri­chu­hivare eta najaca­pirahi eta nayehe perdón. ");
INSERT INTO ignNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tacahe, ema Jesús máichapa esu esena: —Vahi picueñamava, nuperdo­na­charipa tamutu eta pipeca­tu­ra­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tacahe, ena natiari­hi­que­neanahi chimara­canahi náejaruanahi te mesa nacahepa te nasamureana: “¿Nájahapuca ema maca ticaemu­ñavahi marataha maperdonacha eta pecatuana?” —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Émasera ema Jesús máichapa esu esena: —Táuricapa piyana. Yátupi eta piúchucu­hairaya táichavenehi eta picasi­ñai­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te táequenepa eta juca, tiyana­varepa ema Jesús, tipaicahi tayehe eta tasimu­tu­queneana avasa­re­chichana. Ticame­ta­rai­rupahi eta máechaji­riruva ema Viya eta náuchucui­rayare ena ticasi­ña­vanahi mayehe, machane­ra­na­yarehi. Náehica­pa­hivare ena dócequeneana apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Éneri­chuvare náehicapahi ena esenana máepachia­ruanahi nayehe ena éreanana tiávahá­ca­nainihi. Sutiari­hipahi esu María Magdalena, máepachiaruhi nayehe ena siétequeneana éreanana tiávahá­ca­nainihi ésu. Natiari­hi­hivare ena apamuriana esenana macana­ra­ruanahi tayehe eta apana­pa­ne­ne­ji­que­neanahi najuma­nainihi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sutiari­hipahi esu Susana, ésupa esu Juana, mayena ema Chuza. (Ema Chuza, mayehehi empleado ema Herodes, téchahi tamutu eta máimaha­queneana ema Herodes.) Mavera­na­hivare ena apamuriana esenana, tiámaucha­va­napahi eta nirure, náitáti­rapahi ema Jesús, énapa ena apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Te jena sácheanahi, camuriana ena achaneana tiyana­napaipa napaucha ema Jesús. ­ Tiásiha­napahi te avasareana. Te máimahapa éma ena camuri­queneana, máechaji­ca­vacapa; máimicu­tia­ra­chinapa eta máimitu­si­ra­vacahi. Ánipa máicha: ");
INSERT INTO ignNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Matiarihi ema émana achane. Tévapanahi te máesane. Tásihasera, eta mapaisi­rapahi témiri­ca­pai­papuca eta evaraqui te achene. Eta nanucui­ra­pa­racahi ena achaneana, nácata­ya­capaipa eta evaraqui táemiri­rua­napahi. Táimahapa eta cáyure, tanicapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tásiha, eta apana evaraqui témiricapa te máripahi apaquehe. Tímaru­cainipa, tásihasera tájijicapa eta sache taicha muraca­pahihi eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eta apana evaraqui témiricapa te taparereji eta itapequiji. Tiúrinainihi eta táimarusira, étasera eta itape tacachu­ricapa eta tajuru­sirahi, táemuriachapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eta apana evaraqui témiricapa te tiúrina máteji. Tijuru­ca­rahihi eta táimarusira. Tiúrina­hivare eta tahi. Táijaracahi ichapemuri eta tahi —macahepa. Te títapi­ricapa ema Jesús eta máechaji­ri­si­ra­vacahi, máichavacapa: —Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tacahe, ena máimitureana nayase­recapa ema Jesús tájahapuca tacayemahi eta máimicu­ti­cha­quenehi mayehe ema tévacarahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Émasera máichavacapa: —Ema Tata titupa­racanu nítame­ta­ca­heyare éti eta juca mapane­reruana táequene­reruana. Mavarahahi ímatie­que­nehaya éti. Énasera ena apamuriana achaneana nímicu­tia­ra­chi­na­vacahi, apaesa vahi máejera­rémahi eta nacaicu­tia­rairaya eta nasama­quenehi. Tavaraha napane­re­chi­navaya. Te vahi yátupina eta navaraira nasuapa, váhivare nacaicu­tia­raimahi eta nímitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Étara eta juca tacaye­ma­quenehi: Eta evaraqui tímicu­ti­ji­ri­cavahi eta máechaji­riruva ema Viya eta nímitu­ra­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Natiarihi ena achaneana nasama­ri­pa­hinéni eta nímitu­ra­pianahi, émasera ema Váinaraji vahi máisapahini tánasihini te nasamureana. Enevanehi macami­ti­si­cavaca eta nasama­quenehi, mamava­rairahi nacasi­ña­nuhini apaesa nucuchu­cu­ha­va­ca­ya­rehini. Éna, nacutihi eta máteji muracapahi te achene. ");
INSERT INTO ignNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Natiari­hivare ena apamuriana achaneana, nacutihi eta máteji máripahi. Te nasama­raraca eta nímitu­rapiana, nasuapa, tiúrisa­mu­rea­na­rinehi. Váhisera narata­hahini nacara­va­huhini yátupi­nahíni. Vahi nácutihíni eta evaraqui tiúparehi. Ánipirichu eta náehisirahi. Tínaji­ca­va­návane taicha eta náimairavahi eta nacata­ji­vairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Natiari­hivare ena apamuriana achaneana nacuti eta máteji te távihahi eta itapequiji. Éneri­chuvare nasama­ra­ra­ca­hinéni eta nímitu­rapiana. Napane­ré­que­ne­ha­hinéni, tahapa­pi­ri­ca­va­ca­hisera eta jácani táichara­ca­vayare eta náitaresira. Váhivare náinaji­cahíni eta tacaeña­ma­ra­si­ravaca eta tájipa­racana, étapa eta navarairahi tirrico­chavana. Váhivare náinaji­cahini eta náichirahi eta tamauri­queneana. Tamutu eta juca táemeta­vicahi eta navarairahi téhicanuana. Tamapu­rujihi eta najaca­pirahi eta nímitu­rapiana. Tájina vahi nacaema­ta­nea­cahini ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Natiari­hisera ena apamuriana achaneana nacutihi eta tiúrina máteji. Éna, nasama­ra­racahi eta nímitu­rapiana, náunacahi yátupi te nasamureana. Tájinavare náichira­vai­nahíni eta náehisi­ranuhi. Ichape eta nacaema­ta­nea­sirahi ema Viya. Vahi nayacu­jimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ánivare macahe: —Súnsuanahi nácani tiyusta­canahi eta lámpara namica­hu­yarehi, tásihasera, najiha­pai­ca­pa­pucaini, nanaca­va­re­pucaini te tápecu eta náetsatsame náimasirare. Vahi tamicau­chaimahi. Tacamunuhi nanaca­yarehi te anuquehe. Jéhesare ticaeche­ra­sa­re­yarepa tamutu apaesa nácani tisiapa­napahi, tímairi­ri­ca­na­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tayana­pa­nepuca ticayu­mu­ru­quianahi, tamutu­ya­re­hisera ticaechera jácani tayumu­ru­re­vanahi. Tájina tépacu­chaimahi jácani najajai­rai­ru­vanahi. Tamutu­yarehi téchacareya. ");
INSERT INTO ignNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eta tacahe, ecaquiñaicha yátupina eta juca. Taicha mácani máituru­rue­que­nehahi yátupi, tiápaju­ca­va­yarehi eta máitupa­ji­jia­si­ra­va­yarehi. Mácanisera apaesa­richuhi eta máitucaquene, te váipa mapane­re­que­ne­hahini, máemiti­si­ca­yarehi eta máituca­que­nénihi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tacahe, esu maena ema Jesús énapa ena mapara­pe­naveana títeca­panapa te peti te máimitu­re­sihahi ema Jesús. Váhisera náituji­ca­vahini nasiapahini taicha tiyutu­tu­ca­vanahi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nameta­ca­pasera ena apamuriana achaneana ema Jesús: —Esu pémuna­ru­quenehi pena énapa ena pipara­pe­naveana nararihi ani te aneca, navarahahi téchaji­caviana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Émasera majica­pa­vacapa: —Yátupi némuna­ca­vacahi esu meme énapa ena nupara­pe­naveana. Narari­hisera ani te juca nuchacaya ena némuna­rua­na­hivare, nupara­pe­na­veanahi. Taicha tisuapa­ji­ra­hianahi éna tayehe eta máechaji­ri­ruvana ema Viya, ticaema­ta­nea­ca­na­hivare éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Étana sache, ema Jesús tiávacuhapa eta te pacure. Tásiha, máichavacapa ena mayeheana apóstoleana: —Viyana, viánueca te apachara —máichavacapa. Tacahe, tiyananapa tiánueca­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eta napaisi­rapahi, ema Jesús tívecapa tímaca­paipahi. Tacahe, járaja­painapa eta muraca técaticava. Tépacucapa muraca eta cáquiure. Tasiapau­chapaipa eta une te pacure. Tipicanapa ena máimitureana, taicha tímatia­ca­vanapa eta náechari­si­ra­va­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tacahe nacaja­micapa ema Jesús, náichapa: —¡Maestro! ¡Maestro! ¡Péjamica! ¡Pímaha véchari­ca­vainapa taicha eta tépacuca! Enevanepa téchepucapa ema Jesús. Macama­ti­nacapa eta técaticava étapa eta táepacu­sirahi eta une. Tésami­rie­cavapa tamutu. ");
INSERT INTO ignNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tacahe, máichavacapa ena máimitureana: —¿Tájaha tacayema vahi ácasi­ña­vahini eta nutiari­hi­rapahi eta eyehe? —máichavacapa. Énasera tiárame­canapa. Téseni­ji­ri­ca­canapa, tásiha nacahepa: —¡Tétavi­cavapa eta máitupa­ji­jia­sirava! ¡Jéhesare, yátupiquene eta émairahi machichahi ema Viya! Taicha eta mavanairipi, tamutu tasuapahi eta técaticava étapa eta une —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tacahe, títeca­panapa te apachara tayehehi apaquehe eta provincia Gadara. Te apachara tacana­raipahi eta provincia Galilea. ");
INSERT INTO ignNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Te tiúcupaicapa ema Jesús, énapa ena máimitu­reanahi, máuchujiu­cha­vacapa ema émana achane. Ema maca achane mávasaichuhi tayehe eta juca avasare Gadara. Tájina­pasera máimati­yahini mayanahini te peti taicha namauri­shi­chaipahi ena camuri­queneana éreanana tiávahá­canahi. Ánaquia­paripa eta návahá­sirahi. Nameta­panéni ena achaneana nacarataca. Náitiaca te ichapepi carena étapa te enure, te náimaha­varepa tacana­nesica naicha ena tiávahá­canahi. Émasera, tétavi­ca­vaipahi eta matumevahi. Mavechu­qui­mu­rivare eta carena máitihanahi. Tijunavare, tiyana­varehi te mávapahiana naicha ena éreanana. Macape­na­jue­cha­vacahi eta ecariana. Mamuriarehi eta máitare­sirahi. Tacahe, te máimahapa eta matiari­hirahi ema Jesús, mapauchapa. Tépuyucapa te mamirahu. Ema Jesús mavane­ca­vacapa ena éreanana náinajiaca ema achane. Ema achane tipiara­recapa. Ánipa macahe: —¿Tájaha picha píteca pipauchanu, piti Jesús, Machicha­que­nevihi ema Viya? ¡Pájapanunu vuíchaha picuva­necanu ánaqui te nucaicu­ñai­yayare! —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tacahe, ema Jesús mayase­recapa: —¿Tájaha píjare píti? Ema achane majicapapa: —Núti nucaijare “Nacape­naharu ena ichape­mu­ri­queneana éreanana”. Éma, tacahehi eta majica­pirahi ema Jesús taicha camurianahi ena tiávahá­canahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tacahe, ena éreanana nayaseacapa ema Jesús vahi macuaqui­ji­cavaca te táupenaquene pusu náicuchihi návihayare éna. ");
INSERT INTO ignNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tatiari­hivare eta camuri­queneana cúchiana. Tinihi­canahi te táemiri­paisine eta masihi. Ena éreanana nayaseacapa ema Jesús máisapahini nasiapa­ha­cavaca eta cúchiana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tacahe, ema Jesús macuchu­chu­ji­ca­vacapa te máquehe ema achane, máisapa­hivare nasiapa­ha­cavaca eta cúchiana. Te tasamapa eta cúchiana eta nasiapa­ha­si­ra­vacahi ena éreanana, tijuna­pa­ra­canapa témiri­ri­ji­canapa te tachausi eta cáquiure. Tériri­ji­canapa tamutu. ");
INSERT INTO ignNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Natiari­hivare ena tijanea­ca­nainihi eta cúchiana. Te náimahapa, tiárame­ca­na­rinehi. Tiyananapa tijuna­pa­napaipa timeta­ji­ri­ca­napaipa nácani nácapa­ji­ru­va­napahi, étapa te avasare namutuvare nametaca. ");
INSERT INTO ignNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tiárami­ca­réinehi nayehe ena achaneana. Tiyananapa náimahapana tájahapuca eta táichava­que­nevahi eta cúchiana. Te títeca­panapa, náimahapa ema achane návahá­ruinihi ena éreanana. Téjaca­ripahi te máivape­chacaya ema Jesús. Tájina­ripahi máichira­vai­nahini. Ticamui­ri­hai­pa­hivare. Tásihasera, tipica­na­rinehi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tavetijipa te náitame­tacapa ena tímahanahi eta macuchu­chu­ji­sirahi ena éreanana te máquehe ema achane. ");
INSERT INTO ignNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tacahe, te nasamai­ri­ricapa, namutu ena achaneana ticava­sanahi te Gadara, vaipa napatsi­ca­vahini máiteca­pau­cha­va­cahini ema Jesús taicha náeñamaipahi tácahé­ma­hi­varéni eta apamuriana náitáti­queneana. Nayaseacapa ema Jesús machavahini te másinehi. Tacahe, tiávacu­ha­varepa éma, tichava­varepa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tacahe, ema achane mayasea­cainipa ema Jesús máisapahini máehica. Émasera máevata­caichucha machava te mapena. Ánipa maicha: ");
INSERT INTO ignNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Piyanachucha pichava te pipena. Pimeta­ji­ricaya eta majapa­nui­ravihi ema Viya eta macana­ra­si­ravihi —máichapa. Tacahe, tiyanapa tichavahi ema achane. Mameta­ca­va­capaipa namutu eta macana­ra­sirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Te títeca­pa­varepa ema Jesús te apachara, enevanepa nácapahi ena ichape­mu­ri­queneana achaneana taicha nacucha­pa­rai­ri­cai­pahicha. Tiúrisa­mu­rea­na­rinehi eta náimairahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Títeca­pa­varepa ema émana achane ticaijare Jairo. Ema maca achane, tuparai­rucahi tayehe eta náuruji­si­rareva tayehe eta jena avasare. Tacahe, ema maca achane tépuyucapa te mamirahu ema Jesús. Mayaseacapa macata­ji­cahini mayanahini te mapena, macana­ra­si­na­pa­nahini esu machicha. ");
INSERT INTO ignNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Taicha ésuna­ra­cavahi esu machichahi. Doce áñoripahi eta suhañorahi. Téñama­ji­ri­ca­vaipahi ésu, taicha eta sujuma. Tacahe, tiyanapa ema Jesús, máehicapa te mapena. Náehica­varepa ena camuri­queneana achaneana. Váipanecha nárata­va­pahini eta napaisi­rapahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sutiari­hi­pavare esu apana esena, sucaju­ma­que­ne­hivare. Doce áñoripahi tayerevahi eta suhitia­revahi. Ichape­muripa eta sutanu­sirahi ena médicoana, váhisera sucana­ra­cahini ésu. ");
INSERT INTO ignNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tépiya­ya­cavapa témeñahava te maquecu ema Jesús. Suémama­jiacapa te tacheyarapi eta mamuiriha. Eneva­ne­rinehi tinaraca ésu. Tíchecapa eta suítine. ");
INSERT INTO ignNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Émasera ema Jesús masama­richucha eta suémama­jia­sirahi. Macahepa: —¿Nájaha témama­jia­ca­nuanahi? —macahepa. Nájina tísapavaina. Émasera ema Pedro énapa ena machamuriana náichapa: —Maestro, pímaha­richuhi eta nasimu­tuvahi ena achaneana. Tiyutu­tu­ca­vanahi te pichacaya. Váiparinehi tímati­ca­rémahi nájahapuca nácani témama­jia­ca­vianahi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Émasera ema Jesús macahe­varepa: —Nacañárihi témama­jia­ca­nuanahi taicha nusamavahi núti eta nucana­ra­sirahi eta jumare táichavenehi eta nítupa­ji­jia­si­ravahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ésusera esu esena, tímatia­cavapa eta máimatirahi ema Jesús eta suémama­jia­sirahi, tiyanapa supauchahi. Tépuyucapa te máivape­chacaya. Tiyaya­ca­reripa eta supisirahi. Sutupi­ru­va­pasera timetau­re­cavahi eta ésuirahi témama­jiacahi. Ánipa sucahehi: —Tata, nútira némama­jia­cavihi, nuvarairahi nunaraca tayehe eta nujumahi. Nusama­vai­pasera eta nunara­sirahi —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tacahe, ema Jesús, máichapa esu esena: —Tiuri, nuchicha, pinaracapa puiti táichavenehi eta picasi­ñai­ranuhi. Vaipa picueñamava eta pichaviraya te pipena —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Téchaji­ri­ca­vai­chahahi ema Jesús eta suyehe esu esena, títeca­panecha ema émana achane tiásihahi te mapena ema Jairo. Mametacapa: —Esu pichicha tépena­sa­mipahi. Vaipa picucamesa ema Maestro —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Émasera ema Jesús, te masamapa, máichapa: —Vahi picuarameca, váhivare picueñamava. Pácasiñava eta nuyehe. Tinara­ca­yareichu esu pichicha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tacahe, tiyana­vanepa ema Jesús. Te títeca­panapa, vaipa máisapahini ema Jesús nasiapahini ena achaneana. Nacarichu tisiapanahi ema Pedro, ema Jacobo, ema Juan, émapa ema suiya esu amaperu, ésupa esu suena. ");
INSERT INTO ignNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Natiari­hi­hisera ena achaneana te tajuhe. Tíyaha­naripa éna. Te máimaha­vacapa ema Jesús, máichavacapa: —Vahi ecuiyaha. Váhira suépenahini esu suca amaperu. Tímaca­richucha —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Técava­na­ri­chu­chasera eta mayehe éma, taicha náimahahi eta suépeni­raipahi. ");
INSERT INTO ignNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tacahe, ema Jesús macara­tacapa eta suvahuana. Tásiha, máichapa: —Nuchicha, nuvanecavi: Péjamica, péchepuca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tacahe, esu amaperu tichavapa títareca. Tásiha, téchepu­ca­vanepa. Ema Jesús mavane­ca­vacapa ena ticachichana náijaraca eta sunica. ");
INSERT INTO ignNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ichape­rinehi eta náramirahi ena ticachichana. Émasera ema Jesús matupa­ra­ca­vacapa vahi nacuecha­jisiha eta náimaha­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ema Jesús macuru­ji­mu­rihapa ena dócequeneana mayeheana apóstoleana. Tacahe, máijara­ca­vacapa eta náitupa­ji­jia­si­ra­va­nayare narata­hai­rayare náquijica ena éreanana, narata­hai­ra­yareva nacanaraca nácani nacaju­ma­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tásiha, ticava­na­hianapa ticame­ta­rai­rua­nayare eta tacamu­nu­ca­re­va­yarehi náeneuchi­ra­va­yarehi ena achaneana, náinaji­siraina eta napeca­turana, náehica ema Cristo. Ticana­ra­re­ca­na­ya­re­pa­hivare nácani nacaju­ma­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eta mavane­si­ra­yacahi, máichavacapa: —Tájina iámaimahi eta eyereruva. Váhivare ecuca­yu­pai­ri­quipahi. Tacuijavare ecani­ru­ru­cuhaina te alforja. Étaripa eta plata, tacuijavare iama. Étanai­narichu eta emuiriha iámayare. ");
INSERT INTO ignNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Enasi­nu­ma­ya­re­pa­hisera te jácani peti nayehe ena tiúrihi eta najaca­pi­raheya. Tiámainucava te táitecapa eta eyani­ra­yareva. ");
INSERT INTO ignNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Téhesera nacuijapuca nacuvaraha najacapahe tayehe te jácani avasare, váhiva­repuca nacuvaraha nasama eta emeta­rairuya, iúchuca­vanepa. Étata­pe­va­cha­va­nu­ma­ya­resera eta máteji te ívapeana. Táicutia­rayare eta máicuña­si­rayare ema Viya taicha eta namava­rairahi najaca­pa­hehini —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tacahe, tiyananapa ena apóstoleana. Tamutu napaica eta avasa­re­chichana. Ticame­ta­rai­rua­na­paipahi eta máechaji­riruva ema Viya, eta viúchucuiraya majaca­pi­ra­ha­viyare éma. Ticana­ra­re­ca­na­pai­pavare ena nacaju­ma­queneana nácani náetupia­rua­napahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tacahe, ema aquenucahi Herodes masamai­ri­ri­cavare tamutu eta tiárami­careana máichaque­neanahi ema Jesús. Váipasera máituca­ca­rehini. Taicha masamai­ri­ricahi náimija­chahiji émahi ema Juan téchepucahi te máecari. ");
INSERT INTO ignNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ena apamuriana náimija­cha­hivare téchepuca ema antivuini profeta. Ena apamuriana náimija­cha­hivare ema Elías. ");
INSERT INTO ignNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Émasera ema Herodes macahepa: —Nútija­ca­ru­va­hisera nucava­nairipi náechatinuca ema Juan, eta máepenirahi. Puiti, ¿nájahapuca ema maca nusamai­ri­ri­rua­sa­pa­racahi eta máichira eta tiárami­careana? Nuvarahasa nímatini ema mácara —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tacahe, tichavanapa ena apóstoleana eta napaisirahi. Nametacapa ema Jesús tamutu eta náichaque­nea­napahi. Tásiha, éma mámamu­ri­ha­vacapa te mávapahi, tinapaicahi eta avasare Betsaida. ");
INSERT INTO ignNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Téhesera náechavarepa ena achaneana eta macaijuhehi ema Jesús, tiyana­na­varepa nacapa­yacahi. Émasera majaca­pa­va­caichucha, máimitu­mu­ri­ha­ri­pavare tayehe eta náitaresira ena machane­ranahi ema Viya. Macana­ra­cavare ena nacaju­ma­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te náimahapa ena apóstoleana cápere­hi­ya­reipahi, témeña­ha­vanapa eta mayehe ema Jesús. Tásiha, náichapa: —Táuricapa pivane­cavaca ena achaneana nayanapa natanuca eta nanisiha étapa eta náimasihaya te avasa­re­chichana tachaca­ya­ra­hanahi eta juca viávihahi, taicha ani, tajina náviya­vaimahi eta te juca —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tásiha, ema Jesús majicapapa: —Étina, íjaraca eta nanica. Énasera náichavarepa: —Tájina viviyaimahi eta nanicahini ena nani achaneana. Jucári­hinéni cinco eta pan, apiquipa jima jitaruca. Váipari­ne­hisera nárataimahi. Tayanapane tatiari­hi­na­pucaini eta vivacha­re­si­hahini eta tinicacare, váipari­ne­hi­va­resera nárataimahi ena nani camuri­queneana achaneana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ena achaneana, cinco mil eta náichape­mu­rivahi ena ajairana, énari­cha­havare ena esenana, énapa ena amaperuana. Tásiha, ema Jesús máichavacapa: —Evaneca náejaha­pai­cavaca ena achaneana. Cincuenta­va­cai­napahi eta náiputsi­tsi­si­ravaina —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Énepasera tacahehi naicha ena apóstoleana. Tásiha, ticaeja­re­canapa namutu. ");
INSERT INTO ignNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tacahe, ema Jesús mavehapa eta cíncoquene pan étapa eta apiqui jima. Máesenicapa te anuma. Mahasu­lu­pa­yachaipa ema Maiya eta máenisi­ra­va­ca­yarehi ena camuri­queneana achaneana. Mayuve­tu­tu­he­ca­vacapa, máijaracapa ena apóstoleana. Náijara­ca­pasera namutu ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Namutupa tinicana, tisatu­he­vacapa. Váhica­ruvare náitahini eta tinicacare. Dócehi saye ichapehiana tínicahi eta náemacha­rájiana. ");
INSERT INTO ignNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Étana sache, ema Jesús énapa ena máimitureana tiápechavare típutsia­cavana, tiyananapa tayehe eta nayuja­ra­si­ha­yarehi. Te títavanapa eta nayuja­ra­sirahi, éma mayase­re­ca­vacapa: —¿Tájaha nacayema ena achaneana eta nuyehe? ¿Nájahapuca náimija­chanuhi éna? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Éna najicapapa, ánipa naicha: —Ena apamuriana náimija­cha­vihiji téchepuca ema Juan Tícacha­si­ri­ca­rahini. Ena apamuriana tímija­cha­vianahi ema víyarahaini profeta Elías, téchepucahi éma. Ena apamuriana tímija­cha­via­na­hivare ema mácani apana profetaini antivuini, téchepucahi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ema Jesús mápechavare mayase­re­cavaca éna: —Étiyapa, ¿nájaha ímija­chanuhi núti? Ema Pedro majicapapa: —Pítira yátupi­quenevi Cristo, piásiha­quenehi me Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tásiha, matupa­ra­ca­va­ca­pasera ema Jesús nacuija nacumetaca eta émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tásiha, máichavarepa: —Tacamu­nuichaha eta ichape­mu­riyare eta nucata­ji­vairaya, nuti Manere­ji­ru­nuhi ema Viya. Tépuru­nua­nayare ena tuparai­ru­cana énapa ena aquenu­ca­ra­hana énapa ena escribá­noana. Éna, tímica­pa­ca­nua­na­yareva. Mapana­ya­rei­chu­hisera sache eta nucaheyare eta népeni­rayare. Tásiha, nuchava­yarehi néchepuca —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tásiha, máimitu­ca­vacahi namutu ena achaneana, ánipa máichavaca: —Nácani navaraha náehicanu, tacamunu náinajica tamutu eta tihapa­pi­ricana eta náehisi­ránuhi. Nacara­va­hu­yareva eta nímitu­rapiana. Náijara­ca­vavare eta táimica­pa­siraina eta náehisi­ránuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nácanisera téñamanahi eta náitaresira, tiávami­ra­huanaya eta náehisi­ránuya, énaji­vayare ticami­tie­que­ne­ha­vanaya eta náitaresira. Énasera nácani yátupihi tíjara­cavana téhicanuana, tayanapane táimica­pa­ca­va­capuca eta náehisi­ránuhi, éna títuji­ca­va­nayare tiúchucu­ha­nayare eta náitare­si­ranaya. ");
INSERT INTO ignNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Éneri­chuvare nácani tacáeña­ma­ra­ruanahi eta nacaima­ha­que­néi­rayare te juca apaquehe, tájina náimaeque­ne­haimahi, taicha eta tacaeña­ma­ra­si­ra­vacahi tahapa­pi­ri­ca­vacahi tayehe eta náuchucui­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Énaripa nácani titsiri­ha­napuca téhicanuana, náimitsi­ri­hapuca eta nímitu­rapiana, núti apanava nutsiri­ha­ya­revare nayehe ena nani. Nucaera­ji­cainapa ena nani, núti Manere­ji­ru­nuhi ema Viya, te táitecapapa eta sácheyare nuchavi­rayare aquenu­ca­nui­napaipa. Te jena sácheyare, námainapaipa núti eta nujaraiva, étaripa eta majaraiva ema Tata. Nucacha­né­napaipa ena sántoqueneana ángeleana. ");
INSERT INTO ignNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nutupiruva numetacahe: Puítiripa te etaracu éti, etiarihi éti vahi épena­va­néimahi, ímaha­nu­mayare eta nucatu­pa­ra­hairahi aquenu­canuya nuti Manere­ji­runuhi ema Viya —tacahepa eta máimitu­re­sirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tiuri, te táequenepa eta óchoquenehi sache, tiyanapa ema Jesús, tiápanahi te anuquehe mari. Tiyuja­ra­ca­yarehi. Mapana­na­ri­chusera ena mámaque­neanahi: ema Pedro, ema Jacobo, émapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tacahe, eta mayuja­ra­sirahi ema Jesús énapa ena mámaque­neanahi, tíjahú­chavapa títsiva­chavahi eta máimahi ema Jesús. Apaimahipa eta mamira étapa eta mamuiriha. Tétavi­cavapa eta tajapuvahi tajara­ra­sirahi tamutu eta máquehe. ");
INSERT INTO ignNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tásiha, tiárami­ca­rea­na­varepa tímere­cavana ena apinana ajairana. Téchaji­ri­ca­va­naripa mayehe ema Jesús. Ema émana, émahi ema víyarahaini Moisés. Ema apana, ema víyarahaini profeta Elías. ");
INSERT INTO ignNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tétavi­ca­vai­pa­hivare tajara­ra­sirahi eta te natupi­haiyahi. Náechaji­si­haipahi eta macata­ji­vai­ra­yarehi máepeni­ra­yarehi ema Jesús tayehe eta avasare Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tavara­hai­pai­chanéni tímaca ema Pedro énapa ena apinana machamu­rianahi. Téhesera te náimahapa eta tijara­racahi te nachacaya, témitia­ca­rinehi eta náechapuneana. Náimara­ra­ca­ripahi eta majaraivahi ema Jesús, énapa ena apinana ajairana tiúcupau­chanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tacahe, te máimahapa ema Pedro eta nachavi­ra­yarepa ena nani apinana, témeña­havapa. Tásiha, macahepa: —Tata Maestro, tétavi­cavapa táurica­careva eta viávihairahi eta ani. Tiúripa­na­hi­pucaini vépiya­cahini eta epena­hui­na­pa­chuhini. Pipena­hui­na­ri­chuhini píti, mapenainari­chu­hi­varéni ema Moisés, émapaini ema Elías —máichapa. Váhinéni máimatie­que­ne­hahini ema Pedro tájaha­hipuca eta mavara­ha­quenehi macayema. ");
INSERT INTO ignNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tacahe, eta máechaji­ri­si­ra­vai­chahahi, tíjahú­chavapa tiúcupaicahi eta úcaji, tamuicha­vacapa ema Jesús énapa ena apinana ajairana. ");
INSERT INTO ignNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tásiha, nasama­rinehi eta mahu ema Viya, tayehe eta úcaji. Ánipa macahe: —Ema maca ema yátupi­quenehi nuchicha némuna­ru­quenehi. Éma esuapayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te tímatinapa eta mahu ema Viya nasama­quenehi, náimahapa ema Jesús, macari­neipahi. Nájinaripa ena tiúcupau­chanahi. Tacahe, ena mapanana apóstoleana, tiyerehi eta namame­ta­sirahi ena apamuriana nachamuriana eta náimaha­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te apana­quenepa sache, tiúcupai­ca­na­varepa tayehe eta anuquehe mari návinehi. Natiari­hi­pavare ena camuri­queneana achaneana. Te náimahapa ema Jesús, tiyananapa nácapahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Matiarihihi ema émana achane te namuri ena camuri­queneana achaneana. Tipiaracapa muraca éma, ánipa macahe: —Tata maestro, picata­ji­ca­nupaini pípuchi­nanuini ema maca nuchicha. Émana­ra­cavahi te numirahu. ");
INSERT INTO ignNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mávaháruhi ema éreana. Macapia­ra­re­recahi téchari­pai­ca­vavare ticari­sa­sa­ja­cavare. Ichapemuri eta macata­jivaira máicha. Vahi mávaraha máinajiaca. ");
INSERT INTO ignNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Néchajia­ca­ri­pa­hinéni ena pímitureana. Váhisera nárata­hahini nacuchuca ema éreana tiávahácahi ema nuchichasami —máichapa ema achane. ");
INSERT INTO ignNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tásiha ema Jesús majicapapa: —¡Tétavicava emasua­pa­ji­rai­vavaca eti achaneana! ¡Cúvera­re­cai­cha­pucaini eta nucami­chi­ra­he­nahini! Piama ani ema pichicha. ");
INSERT INTO ignNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Témeña­ha­vainipa ema amaperu, tápecha­varepa tacaña­macahi tiáquipai­cavapa, téchari­ri­pai­ca­vai­pavare. Émasera ema Jesús, máquijicapa ema éreana, muraca­pavare eta macaja­chirahi. Tásiha, máijaracapa ema maiya, tinara­caipahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nárami­rinehi ena achaneana taicha eta tamutuirahi marataha ema Viya, máitupa­ji­jia­si­ravahi. Nanasi­ri­chahahi napane­re­que­nehahi ena achaneana eta juca náimaha­quenehi. Ema Jesús mápechavare mameta­cavaca ena máimitureana. Ánipa macahehi: ");
INSERT INTO ignNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ecaquiña yátupina eta juca numeta­ruheya. Váhivare ecuemi­tisica. Núti Manere­ji­ru­nuhi ema Viya, járaja­painapa eta sácheyare tíjara­re­ca­nuyare mácani achane nayehe ena ticatia­na­ca­nuanahi. Ticara­ta­ca­nua­na­yareva —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Énasera ena máimitureana váhiquene nácaicu­tia­rahini eta macaye­ma­que­neanahi. Taicha émarichuhi ema Viya tíjaracahi eta vuíchaha nácaicu­tia­raimahi. Váhivare napatsi­ca­vahini nayase­re­cahini tájahapuca tacayemahi eta máichira­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Te táequenepa eta juca, ena apóstoleana ticapi­na­ru­ji­ri­ca­canapa nájaha­hipuca ema ticapi­ca­hu­panahi. ");
INSERT INTO ignNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Émasera ema Jesús máimatia­ca­vacapa eta náechaji­ri­ru­vanahi. Máichuhapa ema émana amape­ruchicha, macatu­pihapa te namirahu. ");
INSERT INTO ignNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tásiha, máichavacapa ena apóstoleana: —Nácani tijaca­pa­nayare ena amaperuana níchave­néinahi núti, ena nani yátupi náimere­cayare eta náemuna­si­ranuhi núti taicha tímicu­ti­ji­ri­cavahi nútinahini najacapa. Taicha nácani tijaca­pa­nuanahi núti, éneri­chuvare tacahehi eta najaca­pirahi ema Ticachichanu, ema tivane­canuhi. Nácani náechapa­ji­ri­cayare namutu ena nachamuriana, náemuna­si­ra­va­ca­hivare, énahi ena ticapi­ca­hu­pa­na­nayare te etaracu —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tacahe ema Juan mametacapa, máichapa: —Tata Maestro, vímahahi ema émana achane máquiji­ca­vacahi ena éreanana te píjare ticuti­rinehi pítinahini píjara­cahini eta máitupa­ji­jia­si­ravahi. Tásihasera, vicavacahi éma, taicha vahi viúmuri­vai­nahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Émasera ema Jesús máichapa: —Vahi ecucavaca éma. Taicha nácani vahi ticatia­na­ca­ha­vianahi, éna tímica­ta­ca­haviana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te jena sácheanahi tiánene­hipaipa títecapa eta mayani­ra­yarehi ema Jesús te anuma. Tásiha, tíjara­ca­vaichaha eta mayani­ra­nu­mayare te Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Macava­nai­ripipa tiyanana ena tínapu­mi­rau­cha­na­ya­repahi. Titanu­ca­na­yarehi eta máiteca­pi­hayare tayehe eta jácani avasare. ");
INSERT INTO ignNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Énasera ena samari­tá­noana vahi návara­hahini najacapa taicha náimahahi éna eta matupi­rui­rapahi te Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tacahe, ena apinana apóstoleana, ema Jacobo émapa ema Juan, tisema­ma­ju­heanapa eta namaja­ca­pirahi ema Jesús. Tacahe, náichapa éma: —Tata Viáquenu, ¿pivara­hapuca viyase­sereca táemirica eta yucu tiásiha te anuma? Étaina táitapai­muriha ena náenata­tajiana, tácuti eta máichaquenehi ema profetaini Elías —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tacahe, ema Jesús máimara­racapa éna. Tásiha, macaja­cha­vacapa, máichapa: —¿Tájaha tacayema vahi tétupicava eta epane­reruana? Ticutipa vahi mávahá­ru­hénahi ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vahi étaina tímitecanu nícuña­ca­va­cayare ena achaneana, nuti Manere­ji­ru­nuhi ema Viya. Tímite­canuhi nucuchu­cu­ha­va­cayare éna —máichavacapa. Tásiha, tiánucu­hanapa te apachacaya te apana­hivare avasare. ");
INSERT INTO ignNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eta napaisi­rapahi te achene ema Jesús énapa ena máimitureana, nacainunapa ema émana achane, mavarahapa máehica. Ánipa macahehi: —Tata, núti apanavare nuvaraha néhicavi te jácani pivara­ha­que­neyare piámianu. ");
INSERT INTO ignNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ema Jesús, ánipa tacahehi eta majica­pirahi: —Tamutu eta sárareana ticape­navaca. Éneri­chuvare eta cáyureana tamaca­ji­pa­chuvare. Nútisera núti Manere­ji­ru­nuhi ema Viya, tájina nuviya nusiapi­hahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Te apana­varepa sache, máichuhapa ema Jesús ema apana máimiture apóstoleyare. Tásiha, ema majicapapa: —Tata, nuyaseacavi písapa­nu­hi­pucaini nuchava te nupena. Nucucha­pa­nu­ma­ya­rehini eta máepeniraya ema ticachichanu, nécara­numaya. Tásiha, nucapa­ya­cavipa néhicaviya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ema Jesús majicapapa: —Pésamirica náecara­ca­caichaha ena máecharaireana. Tájina táijara­ca­vimahi eta juca tihapa­sa­mu­re­re­cavihi. Yare, péhicanu. Níjara­ca­viyare eta pémata­neyare. Picame­ta­rai­ruyare eta máechaji­ri­ruvana ema Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Matiari­hivare ema apana éneri­chuvare macahehi: —Tata náquenu, núti nuvaraha néhicavi. Písapa­nusera nucame­ta­va­pa­na­numaya te nupena —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ema Jesús majica­pavare: —Mácani achane tipaicapahi téyare­capahi vahi tichavae­que­ne­ha­vaimahi mámarai­ri­cahini eta mámaquene. Ene picaheyare piti, vahi pichavae­que­ne­ha­vaimahi tayehe eta tájipa­racana. Taicha vahi nuvaraha mácani tínaji­cavahi eta macame­ta­rairuira eta máechaji­ri­ruvana ema Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te táequenepa eta júcana, ema Viáquenu Jesucristo manere­ji­ca­varepa ena setenta­queneana apamuriana máimitu­rea­na­hivare. Tiyananapa ticame­ta­rai­rua­na­yarehi te avasareana mapaisi­nea­napahi éma. Apina­na­va­capahi eta napaisi­rayare éna. ");
INSERT INTO ignNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Máichapa eta matupa­ra­si­ra­vacahi: —Tétavi­cavapa eta vicamu­nuirava ena tímica­ta­ca­ha­vianaya tayehe eta juca vémata­ne­repihi. Eyasea­ca­ya­resera ema Tata Vicaiyaquene máijara­cahavi ena náimica­ta­cahavi. Eta juca tímicu­ti­ji­ri­cavahi mácani achane eta macamu­nui­ravahi ena tímica­tacana eta máechati­ji­siraya eta maharusura. ");
INSERT INTO ignNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Puiti, névata­ca­heyare eyana epaica. Narari­hisera ena achaneana váinara­ji­que­neanahi étupia­rua­nayare. Éna nacutihi eta sárare táiñehi­que­neanahi. Étisera ecuti­yarehi eta uvesachicha eta tamansuvahi. ");
INSERT INTO ignNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eta epaisi­rayare, tájina iámaimahi eta tarera, váhivare iámaimahi eta billetera. Váhivare iámaimahi eta eparupeva. Eyaiyau­cha­va­ya­re­pa­hisera eta epaisi­ra­ya­repahi te achene. ");
INSERT INTO ignNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te jácani peti íteca­pi­ha­ya­repahi, ani tacaheyare eta échaji­si­rayare ena achaneana: “Ema Viya, tiúricha­heyare éti te juca peti”. ");
INSERT INTO ignNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Narari­hiyare ena achaneana navarahaya eta náurivaya mayehe ema Viya. Eta échaji­si­ra­va­cayare, tatupi­ruvaya me Viya máijaraca eta náurivaya. Téhesera vahi nacuvaraha najacapahe, vahi ecucae­ña­macava nayehe, taicha énapa téchinavana. ");
INSERT INTO ignNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Te jácani avasare, jácani peti eta najaca­pia­hepuca, enasi­pa­nayare tayehe eta peti íteca­pihahi. Vahi ecuepuru jácani tinica­careana náeniru­hea­nayare. Étaripa jácani náesiru­hea­nayare. Éti, táitsivayare eta ecaema­ta­nea­si­ra­nu­ya­repahi. Váhivare ecupa­mi­ra­hapahi ímaca­cu­hapahi eta pétiana. ");
INSERT INTO ignNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ecana­ra­ca­ya­repahi ena nacaju­ma­queneana natiari­hi­que­neanahi. Tásiha, emeta­ca­va­capaipa námutu ena achaneana eta núcupai­si­raripa nuti Cristo, nútirichuhi ema nacucha­pa­quenehi. Nucuchu­cu­ha­va­cayare namutu ena téneuchavana, ticasi­ña­va­navare eta nuyehe nuti Mavane­runuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Téhesera­ nacuija nacuja­chapahe te jácani avasare íteca­pi­ha­ya­repahi, iúchuca­vanepa te calle. ");
INSERT INTO ignNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ánipa ácahe: “Vétata­pe­va­chavahi eta juca tavaparu támaquenehi eta vívape. Eta juca táicutiarahi eta máicuña­si­ra­heyare ema Viya taicha eta emava­rairahi ejaca­pa­ha­vihini. Vivara­hasera vimetacahe eta máucupai­si­raripa ema Cristo, émarichuhi ema vicucha­pa­quenehi, ema Mavaneruhi ema Viya. Macuchu­cu­ha­hehini éti, te éneucha­vahini, ácasi­ña­vahini mayehe” íchava­cayare éna. ");
INSERT INTO ignNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jéhesare, te táitecapapa eta juicio, tiápaju­ca­vainapa eta náicuñayare. Tacachu­ri­cayare eta nacaicu­ñai­rayare ena achaneana váinara­ji­queneana ticava­sanaini te avasaréni Sodoma —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tacahe, ema Jesús máechajicahi ena apamuriana achaneana, tímicu­ti­ji­ri­cavahi natiari­hi­nahini te mamirahu. Ánipa macahe: —¡Páurehesami eti nujaneanana ecava­sanahi te avasare Corazín étipa eti ecava­sanahi te avasare Betsaida! Ichape eta ícuñayare taicha eti ímaharipa tamutu eta tiárami­careana níchaque­neanahi te emirahu, váhisera ávara­hahini éneucha­vahini. Ena nani achaneana ticava­sanahi te Siria, apava­sa­ná­na­hinéni, tétavi­ca­va­hinéni eta namaurivahi, németea­casera núti téneucha­va­na­va­nehini eta náimairahi eta níchaque­nea­napahi. Enéva­né­nahíni náimere­ca­vahíni yátupi eta náeneuchi­ra­vai­nahíni. ");
INSERT INTO ignNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tásiha puiti, muraca­pa­nayare eta ícuñayare éti, taicha eta emava­rairahi éneuchava. Tacachu­ri­cayare eta nacaicu­ñairaya ena achaneana apava­sanana ticava­sanahi te Siria. ");
INSERT INTO ignNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Étiripa eti ecava­sanahi te avasare Capernaúm, tamapuruji eta nímitu­si­rahehi étapa eta ímairahi eta tiárami­careana níchaque­nea­napahi. Eti ecasi­ña­va­vaicahi, ímija­chai­papuca eta ticaya­pa­heyare te anuma. Ichapesera eta etsiri­ha­ca­re­vayare, taicha épuju­qui­cha­vayare eta te yucu taicha vahi éneucha­vaimahi éti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tacahe, tiápecha­vavare máimitu­cavaca ema Jesús ena máimitureana, ánipa macahe: —Nácani tisuapa­hea­nayare, ticaeche­ranahi eta nasuapi­ra­nu­yareva núti. Énasera nácani tépuru­hea­na­ya­repahi, ticaeche­ra­na­yareva eta náepurui­ranuhi núti. Ene tacahehi eta náepurui­ravare ema Tata tivane­canuhi —máichavacapa ena máimitu­reanahi eta napaisi­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tacahe, tichavanapa ena setenta­queneana. Tiúrisa­mu­re­rea­ca­va­napaipa eta náiteca­pirahi. Ánipa nacahe: —Tata Viáquenu. Vítauchaipa eta pivanairipi. Virata­ha­hivare viáquiji­cavaca ena éreanana taicha eta vipiara­sirahi eta píjare —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ema Jesús majica­pa­vacapa: —Tájina­rinehi matume­vai­mahini ema Satanás eta viáquiqui­ji­si­rapahi ena majupahana. Taicha ema Espíritu Santo tímechanuhi eta nuneca­pirahi eta máquipai­si­ravahi ema Satanás, tacutihi eta térameca eta táijahú­chi­ravahi eta macaqui­jirahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Táitaure­vaquene núti, ichape eta nujanea­si­rahehi. Tayana­pa­nepuca iácatayaca eta quichare, alacránpuca, tájinasera táichara­ca­hémahi. Eta juca ítupa­ji­jia­si­ravaya níjara­ruhehi, tacachuriaca eta máitupa­ji­jia­si­ravahi ema Váinaraji Satanás, énapa ena majupa­hanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Váhisera ecuca­si­ña­vavaica eta erata­hairahi iáquijica ena éreanana. Iúrisa­mu­re­rea­ca­vasera eta táejasiraipa te anuma eta elistana. ");
INSERT INTO ignNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tacahe, enéva­ne­hinehi táiteca­pauchahi ema Jesús eta máurisa­mu­revahi maicha ema Espíritu Santo. Tásiha, macahepa: —Tata Nucaiyaquene, tétavicava eta nucuna­chiravi. Jéhevare píti táquenuvihi eta anuma étapa te juca apaquehe. Títauchavaipa eta pipane­reruhi. Vahi písapahini náitucahíni eta júcana ena achaneana tímija­cha­vanahi téchema­rahiana. Énapasera píjaracahi ena nani téhica­nuanahi, tájina­hinéni náechema­rai­vai­nahíni. Puiti nasapi­ha­ripahi nacachu­ricahi ena títupa­ji­jia­ca­vanahi. Tétávi­cavahi eta táurivahi eta pipane­reruhi, piti Tata Nucaiyaquene. ");
INSERT INTO ignNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tacahe, ema Jesús máichavacapa ena achaneana: —Ema Tata Nucaiyaquene, ema tíjara­canuhi eta nútiraya néchaya tamutu. Nájina nárata­haimahi énaji­vai­nahini náimatihini ema Tata. Nucarichu nuti néchinavahi ena nímima­ti­rua­nayare éma. Taicha núti yátupihi eta nímatirahi ema Tata Nucaiyaquene; tacuti­quenehi eta yátupi­ra­hivare eta máimati­ranuhi éma —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tacahe, mañaji­cha­muripa ena máimitureana, máichavacapa: —Tétavi­cavahi eta iúrica­careva éti taicha tíjara­cahehi ema Viya eta juca ímairahi puiti eta níchaque­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jéhesare, numetacahe: Acane ichape­muriana ena víyara­hanaini profetana énapa ena réyeanaini, tétavi­cavahi eta navarairahi tímatinuana, navarai­ra­hivare náimaha eta juca níchaque­neanahi ímaha­que­neanahi. Navara­ha­hivare nasama eta nímitu­re­sirahi. Váipasera nacapa­ya­cahini —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Matiarihihi ema achane, maestro tayehe eta mavanai­ripiana ema víyarahaini Moisés. Tiyanapa matanucahi ema Jesús, téchaji­ri­ca­va­yarehi eta mayehe. Mavarahahi macaicu­tia­rayare. Máichapa: —Tata maestro, ¿tájaha­pucaini níchara­cavaini eta níturu­si­rayare eta núchucui­rayare te apana vítaresira? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ema Jesús majicapa: —¿Tájahasica tacayemahi eta táechaji­ri­ruvahi eta Sagrada Escritura? ¿Tájaha tacayemahi eta pisamirahi eta péchaji­cuirahi? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tásiha, ema maestro majicapapa: —Ani tacahehi eta nécheji­cuirahi: “Macarichu ema Viya pémuna­cayare te pisamure. Macari­chuvare éma piáchane­va­queneya. Píjara­cayare tamutu eta pitumeva eta picaema­ta­nea­si­rayare. Éma pipane­re­chayare tamutu sácheana. Pémuna­ca­yareva ema piparae­piyahi tácuti eta pémuna­si­ravahi píti”. ");
INSERT INTO ignNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ema Jesús majicapapa: —Tétupicava eta juca pijica­pi­ranuhi. Te pítaucha eta juca, piúchucu­hayare. ");
INSERT INTO ignNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Émasera ema maestro vahi mavara­hahini apaque­he­re­rui­nahini. Máichapa: —¿Nájahasica ema nuparae­piyahi? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ema Jesús máichavarepa: —Nímicu­ti­chi­na­viyare eta juca. Matiarihi ema émana achane. Tipaicahi te achene, másiha te Jerusalén. Tiyana­yarehi te Jericó. Eta mapaisi­rapahi te achene, náuchujiuchapa ena tiámerahiana. Náepuchi­ri­ca­numapa. Tiánehi nacapa­ca­yaréni. Námeyechapa eta mámaque­nea­napahi étapa eta mamuiriha. ");
INSERT INTO ignNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tásiha, macahepaipa ema émana tiyuja­ra­carahi. Máimahapa ema achane te apaquehe te achene­chacaya. Váhisera májapa­nuhini máichejiu­chahini. Máetávi­caichucha. ");
INSERT INTO ignNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tásiha, macahe­pai­pavare ema apana achane. Éma, téchapa­ji­ricahi eta Templo. Éneri­chuvare te máimahapa, máetávi­cai­chu­chavare. ");
INSERT INTO ignNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tacahe, macahe­pai­pavare ema apana achane. Éma, indigenahi samari­tano. Éma, te máimahapa ema macaja­ra­quenehi, majapa­nu­rinehi. ");
INSERT INTO ignNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tícheca­numapa éma, témeña­havapa. Máipuchapa te aceite étapa eta alcohol eta majarana. Máepacu­cha­vacapa te amara­tataji. Tásiha, manara­cuhapa manaca­quechapa eta te maperapahi cavayu. Mámapa eta te máiteca­pi­ha­yarehi. Máipupua­ra­caipahi. ");
INSERT INTO ignNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te apanapa sache, tiyana­yarepa ema samaritano. Tivecua­cavapa apipe eta maplatane. Mavachachapa ema ticapenahi eta peti. Tásiha, máichapa: “Picata­jicanu. Péchapa­ji­ri­sinánu ema maca achane. Te tatiari­hi­napuca eta macamu­nuirava, píjara­si­nánuya. Nímaha­virine nuvachachavi te nuchava” máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tiuri puiti, nuyase­re­ca­viyare píti. ¿Nájahapuca ena nani mapana­queneana ema témunacahi ema maparaepiya najara­ru­quenehi ena tiámerahiana? —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ema maestro majicapapa: —Ema témunacahi ema maparaepiya, ema tijapanuhi —macahepa. Ema Jesús máichapa: —Pímahai­pajira, ene picaheyare piti apanava. Pijapa­nu­ra­hiyare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Tímiya­na­va­varepa eta mapaisirahi ema Jesús. Máiteca­pauchapa eta avasa­rechicha suávasa esu ésuna esena ticaijaruhi Marta, ésupa esu suparape ticaijaruhi María. Mayanauchapa te supena esu Marta. Tétávi­ca­va­hisera eta táurivahi eta najaca­pirahi éna. Tacahe, esu María téjacapa te máivape­chacaya ema Jesús. Susama­ra­ra­caripa eta máimitu­rapiana éma. ");
INSERT INTO ignNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ésusera esu Marta tahapa­pi­ri­caichucha eta sucapa­ru­jirahi, taicha eta suénisi­rayare ema Jesús. Tacahe, esu Marta tisema­ma­ju­heripa eta suímairahi esu suparape suéjara­sirahi. Tacahe, suíchapa ema Jesús: —Tata Náquenu, picata­ji­canupa. Pivane­sinanu esu suca nuparape súimica­ta­canuichu apaesaina tayehe eta emata­necana —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tásiha, ema Jesús majicapapa: —Páurevisami piti Marta, tétavi­cavapa tahapa­pi­ri­siravi eta pémata­ne­repiana. ");
INSERT INTO ignNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Titupa­racavi pínajica eta tihapa­pi­ri­cavihi. Picaravahu eta máechaji­riruva ema Viya. Esu suca piparape María tétupi­cavahi eta supanereru. Suvarahahi suítucayare. Eta tacahe, tisama­ra­ra­canuhi. Nájina tivere­ji­caimahi eta suvara­ha­quenehi suítuca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tacahe, te jácani apanapa sache, ema Jesús mávihahi eta te mayuja­ra­si­rarehi. Te títayu­jarápa, témeña­havapa ema émana máimiture, máichapa: —Tata Viáquenu, pímitu­cahavi eta viyuja­ra­si­rayare víti apanavare, tácuti eta máimitu­si­ra­vacahi ema Juan ena máimitu­reanahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tásiha, ema Jesús máimitu­ca­vacapa: —Ani tacaheyare eta eyuja­rau­chi­ravaina: Tata Vicaiyaquene, piti piávihahi te anuma, vipicauchahi yátupi eta píjare. Vivaraha ichapeina eta tasuapa­ca­revaina eta pivanai­ripiana nayehe namutu ena achaneana ani te apaquehe, tacuti eta nasuapi­ravihi ena ángeleana te anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pájapa­nuhavi píjara­cahavi puiti juca sache eta vicamu­nu­queneana vinica­que­ne­repiana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pájapa­nu­ha­vivare piperdo­na­chahavi eta viviurevana piyehe. Víti apanava viperdo­na­cha­va­caripa namutu ena ticaviu­re­vanahi viyehe. Vahi picuisa­pahavi vicha eta tamauriquene. Picatiu­chahavi mayehe ema Váinaraji. Tacaheya eta eyuja­rau­chi­ravaina. ");
INSERT INTO ignNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Máichavare ema Jesús: —Tiuri, nímicu­ti­chi­naheya puiti. Matiarihi ema émana achane. Tacahe, máiteca­pauchahi ema apana achane máituna­ca­sarehi te enumuhu yati. Viajéropahi éma. Émasera ema avasa­re­cu­ruhahi, tájina maviya eta máenicahini. Tásiha, mayana mayehe ema apana máituna­ca­sa­re­hivare. Máichaina­papuca: “Picata­jicanu, nucapucavi mapanaina pan. ");
INSERT INTO ignNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taicha títeca­pau­chanuhi ema nítuna­casare viajéropahi. Tájinasera nuviya nucumpi­ra­chahini”. ");
INSERT INTO ignNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tacahe, ema macaiju­he­quenehi váhipuca macuja­panuhi, macahé­na­papuca: “Vahi picuja­rareca eta néchapune. Pésami­ri­si­na­nuvare eta tapaja tacaera­ta­quenehi. Tímaca­na­hivare ena nuchicha­naveana. Vahi nítujicava néchepuca níjara­ca­vihini eta pivara­ha­quenehi” macahe­na­papuca. ");
INSERT INTO ignNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Máituna­ca­sa­re­que­né­ni­hipuca éma, váhisera máipura­jihini máechepu­cahini máijara­cahini eta mayase­se­reruhi. Téhesera te tímiya­na­vapuca mapiararaca ema ticamu­nuvahi, németeaca tipami­ca­va­yarehi téchepuca, máijara­ca­yarehi eta macamu­nu­que­nepahi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Eta tacahe, numetacahe: Échajica ema Tata Vicaiyaquene. Eyasea­cayare eta ecamu­nu­queneana. Éma, tijapa­nurahi. Tisama­heyare, tíjara­ca­he­yareva. Vahi ecuyacuji eta eyasea­siraina. Téhevare tatiari­hi­na­papuca eta jácani íchiraya ichapehi eta tacaje­ravaya, eyasea­cayare máijara­ca­hehini eta ítupai­ji­jia­si­ravaya. Éma, tíjara­ca­heyare. Te jarari­hipuca eta táicheji­mi­ráuchahe, éma macaevui­si­hai­na­heyare. ");
INSERT INTO ignNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Eta juca tímicu­ti­ji­ri­cavahi te natiari­hipuca ena echicha­na­veanahi éti, te tiyasea­ca­hea­napuca eta pan nanicayare, váiparinehi táuricaimahi íjara­cahini éti eta márijahi, tímicu­ti­ji­ri­cavaipa ecavi­ja­ruhini ena echicha­naveana. Étaripa te tiyasea­ca­hea­napuca eta jima, váhivare táuricaimahi íjara­cahini eta quichare. ");
INSERT INTO ignNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Étaripa te tiyasea­ca­hea­napuca eta varayuha, váhivare táuricaimahi íjara­cahini eta sáse. ");
INSERT INTO ignNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Étiarihi éti vahi ecaji­ra­hihini nayehe ena achaneana. Iúrihisera nayehe ena echicha­naveana. Ítucahi íjara­cavaca jácani nayasea­ru­heanahi táuriqueneana. Mavetiji ema Tata Ecaiyaquene tiávihahi te anuma. Éma, vahi ticavi­ja­ru­heimahi eta te eyase­se­repiana. Tíjara­ca­he­yarehi tamutu eta eyasearuana, émaripa ema Espíritu Santo tiávahá­ca­he­yarehi —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te apana­quenepa sache, ema Jesús macana­racahi ema achane, úpainihi eta máitaresira taicha eta mávahá­sirahi ema éreana. Tacahe, eta máuchusirapa ema éreana te máquehe ema úpainihi, tiúripa téchajica. Ichape­rinehi nárami ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Natiari­hi­hisera ena apamuriana achaneana, ánipa nacahehi: —Ema maca Jesús, vémeteaca majupahahi ema Satanás, ema náquenu­murihi ena éreanana. Máijararuhi jácani eta máitupa­ji­jia­si­ravahi eta macuchu­si­ra­vacahi éna —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Narari­hi­hivare ena apamuriana achaneana váhivare nasuapa­pa­ji­cahini ema Jesús. Eta tacahe, navarahapa nacaicu­tia­ra­yarehi, nayaseacapa macuchu­cahini eta tiáramicare, máimereu­chayare eta émairahi Cristo mavaneruhi ema Viya. Váhisera nasuapa­ya­rehini. ");
INSERT INTO ignNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Émasera máimatihi eta napane­reruana eta namasua­pirahi. Máichavacapa: —Nímicu­ti­chinahe puiti ena machanerana ema gobierno. Éna, vahi típutsi­mu­ri­ha­ca­ca­naimahi apinai­na­hi­pucaini partido. Te típutsi­mu­ria­ca­canapa, énaji­ca­cai­pa­pucaini tiáquipai­cacana. Émaripa mácani achane te camurianahi ena machicha­naveana, váipari­ne­hivare típutsi­mu­ria­va­naimahi náehaji­ri­ca­cahini, énaji­ca­cahini náquipai­ca­cahini. ");
INSERT INTO ignNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ene macahehi ema Váinaraji Satanás, váiparinehi máisapahini típutsi­cacana ena machamuriana, taicha mavarahahi tisimu­tua­na­yarehi éna, tímiya­na­va­yarehi eta nacaete­ma­ji­ri­si­ra­ha­vi­yarehi. Éti ímijachaipa nútirichuhi machamuri ema Satanás, táichavenehi eta nurata­hairahi nucuchu­cavaca ena éreanana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tájina vahi étupi­ca­vahini éti eta juca epane­reruana. Te émahipuca tímica­ta­canuhi ema Satanás, éneri­chu­hivare éti máimica­ta­rua­na­hivare jácani éma, eta ecuchu­si­ravaca ena éreanana. Epane­re­chi­ná­vanuma. ");
INSERT INTO ignNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Émaque­ne­hisera ema Viya, tíjara­canuhi eta juca nurata­hairahi nucuchu­cavaca ena éreanana. Eta juca étara ícutiaraya éti eta matupa­ra­si­ranuhi ema Viya eta nútirayare necha tamutu. Nútiripara nuti ecucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tacutiquene mácani achane tume. Te macara­tacahi eta mataquiriqui eta majanea­sirahi jácani macaye­he­queneana, nájina tiámeye­chaimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Téhesera macahepaipa mácani achane túmepanahi mayehe, mavere­ji­cayare eta mataqui­riquini macasi­ña­quenehi. Máitiacavane. Tásiha, émapa técha tamutu eta majanea­ruinihi ema achane. Ene nucahehi núti, túmepa­nanuhi mayehe ema maca Satanás. ");
INSERT INTO ignNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Te vahi ecuehicanu, ecucae­ma­ta­neacanu, éta tímereu­chaheya machamu­rihehi éti ema ticatia­na­canuhi. Masapiha ímica­tacahi éma eta macaete­ma­ji­ri­si­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tímiyanava eta máechaji­ri­si­ravahi ema Jesús, ánipa macahe: —Éneri­chuvare éti ecuti mácani achane máinajiruhi ema émana éreana. Ema éreana tiyanainapa matanu­cainapa eta jácani masiapi­ha­yarehi. Eta mamaichi­mavira eta mavara­haquene, mapane­re­cha­yarehi tichava. Macahé­na­papuca: “Nuyanayare nuchava, nusiapa­ha­ca­yareva ema návahá­ruinihi”. ");
INSERT INTO ignNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te títecapapa ema éreana mayehe ema achane mávahá­ruinihi, máimahapa ema achane máinaji­caripa tamutu eta mapeca­turana, vuíchahasera máehicahini ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tásiha, tiúrisa­murepa ema éreana. Tásiha, tíchuarecapa ena siétequeneana machamuriana. Váinara­ji­panána éna. Nasiapa­ha­cai­na­varepa namutu éna. Jéhesare, tiápaju­cavapa eta mavaina­rajiva ema paure achane —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mapaenu­mavahi títapirica ema Jesús eta juca máechaji­ri­ru­vanahi, tipiaracapa esu ésuna esena te namuri ena achaneana. Ánipa sucahehi: —¡Tétavi­cavapa eta sucuna­cha­ca­revahi esu pena, táichavenehi eta suínasi­ravihi, suájisi­ravihi eta sucaju­ru­si­ravihi! —sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ema Jesús majicapapa: —¡Tiápaju­ca­va­ya­resera eta nacuna­cha­ca­re­va­yarehi namutu ena tisama­nayare eta máechaji­ri­ru­vanahi ema Viya, yátupi­yarehi eta nasuapi­ra­yareva! —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tacahe, títeca­pa­ra­ca­na­paichucha te machacaya ema Jesús ena camuri­queneana achaneana. Tásiha, eta máimitu­si­ra­vacahi, máichavacapa: —Nararihi ena achaneana puiti juca náetaviuchahi eta navaina­ra­jivana taicha vahi návara­hahini nasuapa eta yátupirahi mavane­runuhi ema Viya. Tiyasea­ca­nuanahi nímecha­yarehi eta tiáramicare táicutiarahi eta mavane­si­ranuhi ema Viya. Váhisera nímechaimahi. Tacarichu náimahayare eta níchara­ra­cavaya tacuti eta máichara­ra­cavahi ema profetaini Jonás. ");
INSERT INTO ignNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ema profetaini Jonás yátupihi ecutia­rarehi éma eta mavane­sirahi ema Viya nayehe ena achaneana ticava­sanahi te avasare Nínive. Ene nucahehi nuti Manere­ji­ru­nuhi ema Viya, ecutia­ra­renuhi puiti eyehe eti achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tacutiquene, esu reina Seba eta acane, te susamai­ri­ricapa eta máitupa­ji­jia­si­ravahi yátupi ema Salomón. Ésu, tayere­hi­que­ne­hineni eta suávasa, tiyana­hisera sucapayaca ema Salomón taicha suvarahahi susama­yarehi éma. Tacahe, te táitecapapa eta sácheyare téchepu­canaya namutu, suyasea­cainapa ésu eta nacaicu­ñahini ena nani máetupi­cu­shianahi puiti. Sucáhé­na­papuca: “Táuricapa nacaicu­ñahini ena nani máetupi­cushiana, tájinapa náetseraruina nasamaripa ema Cristo, ema títupa­ji­jiá­pa­navahi mayehe ema Salomón, tásiha vuíchaha­caruva nasuapa” sucahénapa jácani. ");
INSERT INTO ignNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tacutiquene ena achaneana ticava­sanahi acane te Nínive. Tisipe­ca­tu­ra­rahiana éna. Natupi­ru­va­hisera nasuapa eta mametarairu ema Jonás. Téneucha­va­va­neanahi. Tásiha, nacahé­na­papuca te jena sácheyare: “Táuricapa nacaicuñaini ena nani mapara­juruana ema Cristo, taviuchahi eta namasua­pirahi éma. Taicha éma máurique­ne­panahi mayehe ema Jonás” nacahénapa. ­ Eta máimiturapiana ema Jesús, tamicahu eta vítaresira ");
INSERT INTO ignNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tímiyanava eta máechaji­ri­sirava ema Jesús, ánipa macahe: —Súnsuanahi nácani tiyusta­canahi eta lámpara namica­hu­yarehi, tásihasera nanaca­pa­pucaini te jácani tayumu­ru­revahi cuarto, najiha­pai­ca­pucaini te cajune. Tacamunuhi nanaca­yarehi te anuquehe. Jéhesare, tamicau­cha­sarepa tamutu apaesa tímairi­ri­ca­napaipa nácani tisiapa­napahi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ene ecahehi éti, eta esuapirahi eta nímitu­rapiana, tétavi­cavahi eta tamicau­chiraya eta iáchanevana. Tímiju­ni­ji­cayare eta emaurivahi. Téhesera vahi esuapahini, tétavi­cavahi eta tamapi­cuvahi eta iáchanevana. Tanasipa tamutu eta tamaurivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eta tacahe, machu ecaina­jiruva tayehe eta juca esama­que­neanahi ímaha­que­nea­na­hivare, machu tayanariana te timapicu eta iáchanevana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Téhesera yátupina esuapa eta nímitu­rapiana, tétavi­cavaya eta tamicau­chi­raheya tayehe eta ítare­si­ranahi. Tásiha, vahi eyasea­ca­nuimahi nímechahe eta tiárami­careana —macahepa. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tacahe, te títapi­ricapa ema Jesús eta máechaji­sirahi, témeña­havapa ema émana fariseo. Macumpi­rachapa tinipa­na­yarehi te mapena. Masuapa­hisera ema Jesús. ­ Tiyanapa te mapena ema fariseo. Te tiúripa eta tinicacare, téjacapa ema Jesús te mesa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","(Tiuri, ena fariséoana, jucarihi eta nayeherepi te tinica­nayare, tayana­pa­ne­hipuca tipachi­va­huanahi, ticasi­pa­va­hu­nu­ma­na­ya­re­hisera. Eta juca nasipa­vau­ru­si­ravahi, namava­rairahi náechipe­ji­cahini eta náchanevana.) Émasera Jesús, vahi masipa­vau­ru­ca­va­nu­mahini. Tacahe, máraminehi ichape ema maca fariséo eta mamaitau­chirahi eta nayehe­re­pianahi éna. ");
INSERT INTO ignNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Émasera ema Viáquenu Jesús máichapa: —Eti fariséoana, eta eyehe­repiana, ecaeña­ma­ra­cavahi esipa­canuma eta enisi­rareana étapa eta érirareana, emava­rairahi táetsera­rui­nahini tasiapahini eta pecatu te iáquehe. Étisera iápaju­pa­navahi eta tachipe­jivahi eta iáchanevana táichavene eta evaina­ra­jivana, étapa eta tavayua­si­rahehi eta ejamu­ra­chirahi tamutu. ");
INSERT INTO ignNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tétavi­ca­va­samihi eta tamura­cavahi eta esamureana! Ema Viya vahi tácarichu máimaha eta te iáquehe eta tiávihahi te ínahu. Éneri­chuvare máimahahi eta tiávihanahi te amahe esamureana. Éma yátupihi eta máimati­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tatupa­racahi ejapa­nu­rahiya nayehe ena ticamu­nu­vanahi. Tátupiruva te esamureana te échaji­ricava apaesa tacuija­sarepa tachipe­jivaina eta iáchanevana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Páurehesami eti fariséoana! ¡Tétavi­cavahi eta tamura­cavaya eta ícuñayare! Éti ímija­chavahi yátupi­quenehi eta religió­so­hérahi eta epami­sirava eta ecama­va­huirahi me Viya eta diésmuri tayehe tamutu eta évaraqui. Ecuna­cha­carehi taicha éta. Váhisera ecatiu­cha­va­cahini ena achaneana páureana macatiu­cha­va­rahana. Váhivare émuna­cahini ema Viya. Yátupi titupa­ra­cahehi eta ecamavahu eta diésmuri iámavahuana. Éneri­chuvare titupa­ra­cahehi eta ejapa­nu­raivaya, yátupi­navare eta émuna­siraina ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Jucari­hivare eta apana tiviuchahehi eti fariséoana! ¡Tétavicava eta esiña­va­vai­sirahi! Emetapa evaraha tipicau­chaheana, ticaeja­caheana te táurinaquene siya eta te iúruji­si­ra­revana. Evara­havare tipicau­cha­hea­na­yarehi eta náechaji­si­raheana ­ te cálleana. ");
INSERT INTO ignNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Jucari­hivare eta apana tiviuchahehi eti escribá­noana, étipa eti fariséoana, táichavenehi eta apimi­rai­rahehi! Ímija­chavahi epicau­cha­ca­rehiji. Étisera eta eyehe­repiana, émeje­ca­pavacha ena achaneana eta náehisirahi ema Viya. Páureanasami éna. Váhi náimatie­que­ne­hahini eta náejeca­pi­ravahi táichavene eta evayua­sirahi eta ecaete­mai­ra­vacahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Matiari­hivare ema émana maestro eta mavanai­ripiana ema Moisés. Máichavarepa: —Tata maestro Jesús, eta piyuna­si­ravaca ena fariséoana, tétavi­cavapa tayuna­si­ra­havihi víti apanavare viti máestroana. ¿Pivara­hapuca vicaviu­re­va­hi­vareni víti? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tacahe, ema Jesús majicapapa: —¡Eti apanavare eti máestroana, tétavi­ca­va­hivare eta eviurevahi! ¿Tájaha tacayema epami­ca­vacahi ena apamuriana achaneana eta júcana eyehe­repiana tacaje­ra­queneana? Nájinapa tirata­haimahi títaucha. Apanasica éti váhivare ítauchahini. ");
INSERT INTO ignNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","¡Jucari­hivare eta apana tiviuchahehi eta tamura­cavaya eta ícuñayare! Éti ecaijare apimirana, taicha ímija­chavahi machanerahe ema Viya eta eyehe­hea­ra­sirahi eta náecariana ena profetanaini nacapa­ruanahi ena iáchuca­na­veanaini. Puiti étarichuhi tacahehi eta epane­re­ruanahi eta evarairahi ecapa­cahavi viti mavana­ranahi ema Viya taicha eta épuruirahi eta vímitu­ra­pianahi táurique­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ema Viya, acane tímatihehi eta ecuti­ra­yarehi eta napanereru ena iáchuca­na­veanaini ticapa­canahi ena profetanaini. Eta tacahehi eta máechaji­ri­ru­vanahi: “Nuvane­cayare ena profetana; tásiha, nuvane­ca­yareva ena apóstoleana. Váhique­nesera nasuapaimahi ena tisama­na­yarehi eta náimitu­ra­pianaya ena nuvanarana. Napana­ji­ri­ca­va­ca­ya­rechucha ena nuvana­ranahi. Natiari­hi­yareva ena nacapa­ca­ya­repahi” macahehi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Eta tacahe, numetacahe núti: Eti nujaneanana israelítana etiari­hi­que­neanahi puiti, ecaicu­ñayare, taicha timuria­cahehi eta naviurevahi ena iáchuca­na­veanaini taicha eta nacapa­pa­ji­si­ra­vacahi ena profetanaini. Acane te tépana­vainapa eta apaquehe, ema Abel máinapuiruhi nacaparuhi. Máequeneruhi nacaparuhi ema maca Zacarías, ema nacaparuhi te tamirahu eta Templo. Camuria­na­hisera ena náumuri­vanaini. Puiti étipa tamuriacahi eta ícuñayare naicha ena iáchuca­na­veanaini. ");
INSERT INTO ignNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Páurehe­sa­mi­cha­pucaini eti máestroana! ¡Camuri­quenehi eta eviure­vanahi! Tamapu­rujipa eta ímatie­que­ne­hai­rainihi eta yátupi­queneana títuca­cáreana, taicha vahi esuapaimahi, váhivare éhicaimahi. Éti tásihahi ícheji­mi­ráu­ru­ca­vacahi ena tivara­hanahi tisuapanaya, náehicaya ema Viya —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tacahe, eta nasamirahi ema Jesús ena fariséoana énapa ena máestroana, tisema­na­rinehi eta mayehe. Tépana­va­na­varepa náitsama­rareca eta nayase­re­si­rapahi, navarairahi nasama te máejeca­pa­va­hi­pucaini eta macaye­ma­que­nea­napahi, navarairahi eta tiviucha­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tacahe, te jena sácheanahi, títeca­pa­ra­ca­na­paichucha ena camuri­queneana achaneana. Tiyutu­tu­ca­vanapa. Énasera ena máimitureana ema Jesús návihahi te machacaya. Tásiha, máichavacapa namutu: —Tímati­carehi eyehe eta levadura eta tasisi­ji­sirahi eta masa. Tacutirichu eta taparea­sirahi eta apimi­rai­ranahi ena fariséoana. Échapavaicha éti, machu napareacahe éna. ");
INSERT INTO ignNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Ema Viya tímara­ra­cahehi tamutu eta íchaque­neanahi, tayana­pa­ne­né­nipuca eyumu­ru­ca­va­que­né­napuca te timapicu. Tisama­he­hivare tamutu eta échaji­ri­ru­vanahi. Tímati­he­hivare tamutu eta epane­reruana. Te jácani sácheyare ticaeche­rayare tamutu, tétavi­cavaya eta etsiri­hairaya taicha eta emauri­vanahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Étiripa eti némuna­ca­sareana, numetacahe: Vahi ecupica nácani nacapa­capuca eta iáquehe, tacari­chusera náiturue­que­ne­hayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Numeta­caheva, macarichu ema Viya epicayare, taicha macarichu éma téchahi eta ítare­sirana. Jéhevare, éma maratahahi macami­tie­queneha eta iáchanevana tayehe eta táiñehiquene yucu infierno, te ecaina­jiruva táichavenehi eta episi­rapuca eta nacapa­si­ráhena. Jéhevare, éma epicayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nímicu­ti­chinahe eta cáyurechicha. Éti ímija­cha­papuca vahi tasiva­chahini éta. Téñama­ca­rea­na­hisera me Viya. Éma, téchavacahi eta táitare­si­ranahi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Evetijipa éti, éñama­ca­re­panahi me Viya. Éma téchahe­hivare tamutu eta ítare­sirana. Váiparinehi témiti­si­ca­hémahi. Eta tacahe, vahi ecueñamava éti tayehe eta ítare­sirana, taicha tétavi­cavahi eta emunavahi éti mayehe. Éma, máimatihi eta tatupa eta echuti­macana. ­ Vímereuchavayarehi eta véhisira ema Jesús ");
INSERT INTO ignNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Numetacahe puiti, nuti Manere­ji­ru­nuhi ema Viya: Namutu ena tímereu­cha­vanahi eta náehisi­ranuhi te namirahu ena achaneana, núti apanavare nímereuchaya eta nuchane­rai­ra­vacahi éna te namirahu ena ángeleana mayeheanahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nácanisera vahi návara­hahini náimereu­cha­vahini eta náehisi­ranuhi, núti apanava nímereuchaya eta vahi nuchane­ra­nai­nahini éna te namirahu ena ángeleana mayeheanahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Namutu nácani ticaeca­hi­nua­na­hipuca nuti Manere­ji­ru­nuhi ema Viya, tiperdo­na­cha­careana. Nácanisera nacaeca­hipuca ema Espíritu Santo, vahi tiperdo­na­cha­ca­rea­naimahi éna. ");
INSERT INTO ignNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jarari­hiyare eta sácheanayare tiámaheanaya te namirahu ena nacapi­tarana eta te náuruji­si­ra­revana, énapapuca ena tuparai­rucana, énapapuca ena juéseana te jácani avasareana eta nayase­se­re­siraya. Váhisera ecueñamava tayehe eta jácani ecatiu­chi­ra­vayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ema Espíritu Santo tímitu­ca­heyare eta táurivayare eta ecaye­mayare te jena sache ecaya­se­se­re­hinapa —macahepa. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Matiarihi ema achane te namuri ena camuri­queneana achaneana. Máechajicapa ema Jesús. Máichapa: —Tata maestro, pímica­tacanu, pimetaca ­ ema nuparape máijaracanu eta nuyehe parte eta nímaeque­ne­ruyare eta máimaha­quenéni ema ticachi­chanuini —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ema Jesús majicapapa: —Nuchicha, ¿tájaha tacayema pivaraha pinacanu juésnuyare eta eyehe? Vahi nútina néchaheyare tayehe eta máimaha­que­neanaini ema ticachi­chahéni —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Énerichu máichava­cavare ena apamuriana achaneana: —Échapa­vavare éti apanavare, machu émuna­hi­ricava, ejamu­rarahi tayehe eta tímaha­careana. Taicha eta tímaha­careana te juca apaquehe, vahi étaina ticaita­re­ca­heyare. Vahi táeñama­ca­rehini. ");
INSERT INTO ignNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tacahe, máimicu­tia­ra­chi­navare: —Matiarihi ema achane ricu. Ichape eta máesane. Tiúrina eta máevaru. ");
INSERT INTO ignNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tacahe, ema ricu mapane­rechapa, ánipa tacahe eta mapanereru: “Ániquehepa eta juca névaru, tájinapa núnasiha. ¿Tájahapuca nícharacaya? ");
INSERT INTO ignNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tiúripa­napuca nuvetataha eta núnavarahi nujanejuecha. Ichape­pa­nainapa nicha eta táitsivaya. Tiúripa­nainapa, apaesa táirijica tamutu eta néchatijiru étapa eta apamuriana nucaye­he­queneana. ");
INSERT INTO ignNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tásiha, nucahénapa: Jéhevare puiti tétávi­cavapa eta núrivayare. Tájinapa níchira­vaimahi. Ichape­murihi eta núnaru. Tarata­haquene juca áñoanayare. Nucana­ra­cavaya núti. Tamutu sache tiúriya eta nunisira, néraya. Ichape eta núrisa­mu­revaya” macahepa ema ricu. ");
INSERT INTO ignNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tásihasera ema Viya máichapa ema achane: “Tétávicava eta pisunsuva, piti achane. Puiti jena yati pépenaya. Tájina vahi pítapa­naimahi eta juca piúnaruhi”. ");
INSERT INTO ignNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ene nacahe ena achaneana ticuru­ji­ricana eta náimaha­queneana nayehe­chi­ra­varichu. Vahi nápane­re­chahini naicha eta táuriqueneana tacuna­cha­ca­rehini me Viya taicha tétávi­cavahi tahapa­sa­mu­re­chirahi eta nacaima­ha­que­néraya. ");
INSERT INTO ignNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","24","Te apahe­quenepa, ema Jesús máichavacapa ena máimitureana: —Étisera, nuvaraha ácasiñava yátupina mayehe ema Viya. Vahi ecucae­ña­ma­ra­ca­vavaicha tayehe eta enica­que­nerepi étapa eta emuiri­harapi puiti juca ítare­si­raichaha. Eta enica­que­nerepi étapa eta emuiri­harapi, tájina táeñama­va­ca­revaina. Ímara­ra­ca­richuhi eta cáyureana. Vahi tacaeña­ma­ra­ca­vahini tayehe eta tanica­que­nerepi. Vahi táevacahini, váhivare táechati­ji­ri­cahini, táunaca­hi­pucaini eta tanica­que­neyare. Émasera ema Viya máechapa­ji­ricahi máijara­sirahi tamutu eta tanica­que­ne­repiana. Evetijipa éti, iápaju­pa­navahi eta éñama­ca­révahi me Viya tayehe eta cáyureana. ");
INSERT INTO ignNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Vahi táuricahini eta ecaeña­ma­ra­ca­vahini eta júcana. Eyehe éti, nájina narata­hahini étiji­vai­nahini ecaju­ru­ca­vahini, tayanapane te tihapa­sa­mu­re­cha­he­hipuca. ");
INSERT INTO ignNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Vahi étiji­vaimahi íturucava ecaju­ru­ca­vahini, váhivare táuricahini ecaeña­ma­ra­ca­vahini tayehe eta júcana. ");
INSERT INTO ignNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ímara­ra­ca­richuhi eta tajuru­sirahi eta flúreana, vahi tacaeña­ma­ra­ca­vahini tacaema­ta­nehini, táijuru­re­ca­hi­pucaini. Táitsiva­hisera, te tépunehapa, tétavi­cavahi táurinavahi eta taflurene. Nájina nácuti eta nacamui­rihaira eta táurinava, émaripa ema víyarahaini rey Salomón eta tajanu­nusira eta macamui­ri­hai­ra­hinihi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Apanasica ema Viya máijaracahi eta táurinavahi, ánipi­ri­chu­hinéni eta táitare­sirahi. Evetijipa éti eta máechapa­ji­ri­si­rahehi, máijara­si­ra­he­yarehi eta emuiri­harapi eti achaneana. ¿Tájaha tacayema vahi ácasi­ña­vahíni eta mayehe? ");
INSERT INTO ignNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eta tacahe, vahi ecucae­ña­ma­ra­cavaicha tayehe eta enica­que­ne­repiana étaripa te échuri­ria­capuca eta une érayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ena apamuriana achaneana te juca apaquehe, ichape­murihi eta tacaeña­ma­ra­si­ra­vacahi eta júcana. Vahi nácasi­ña­vahini mayehe ema Viya, nacucha­pa­hi­pucaini eta máijara­ru­yarehi éma. Étisera, ecasi­ña­va­yarehi eta matiari­hirahi ema Ecaiyaquene. Máimatihi éma tamutu eta ecamu­nui­ra­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eta tacahe, tativayare íjaracava ecaema­ta­neacaya ema Viya, ecasa­mu­reraya eta ítauchi­rayare tamutu eta mavara­ha­que­neanahi. Máimaha­rinepa éma. Tíjara­ca­heyare tamutu eta ­ ecamu­nu­queneana. ");
INSERT INTO ignNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vahi ecupica, eti nuchicha­naveana. Tayanapane vahi camuri­hé­nahini, eti máichuha­que­neanahi ema Ecaiya­quenehi. Éma téchahehi. Eta tacahe, tétavi­cavahi eta mavapi­nai­ravahi eta majaca­pi­rahehi, machane­raheya. ");
INSERT INTO ignNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tacahe, te ecaima­ha­que­nepuca, íjara­re­cayare eta ímaha­queneana. Íjara­cayare nácani ticamu­nu­vanahi. Tásiha, ema Viya máimahainepa, éma tíjara­ca­heyare eta táitsivayare ánaqui te anuma. Máitava­ca­cainapa eta ecaima­ha­que­néraya. Tájina­varepa tévajai­ca­vaimahi. Váhivare táeñama­vacare ánaqui taicha nájinapa tiámeye­cha­hemahi, váipavare cachusi­rimahi eta ímaha­que­nea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Éti, te ecasa­mu­repuca eta ímaha­que­neanahi te juca apaquehe, evarahahi enasiyare te juca. Vahi ávara­hahini ejuni­ji­cahini eta ímaha­queneana. Téhesera te ecasa­mu­re­hi­chapuca eta ícuchiana te anuma, ánaqui evara­hayare eyana­va­neyare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Éti, yátupina eta ecucha­pi­ranuya eta nuchaviraya. Etsecavaya tamutu sácheana. ");
INSERT INTO ignNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ácutihi nácani achaneana músuana titseca­vanahi te tapaja navejie­que­néraya ema náquenu eta machavi­raipahi másihairahi mayehe ema arayenahi. Te máehaha­mecapa eta tapaja, eneva­ne­yarepa éna navejie­que­ne­hayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Tayanapane enumu­hupuca yati, tijara­ra­hipuca eta machavi­ra­yarehi ema náquenu. Tétavi­ca­vasera eta náurica­ca­revahi ena músuana eta machima­pirahi ema náquenu eta nacucha­pirahi, te vahi náimacae­que­ne­hahini. Nutupiruva numetacahe: Yátupi­na­sarepa eta máurisa­mu­re­vayare ema náquenu, macaeja­ca­va­cainapa te mamesara, máenica­va­cainapa. Émaja­ca­ru­vainapa máechapa­ji­ri­ca­va­cayare. ");
INSERT INTO ignNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nuvaraha ácaicu­tia­ra­quenéna. Machu ácutiriana mácani achane námeyeruhi ena tiámerahiana. Tájina máechapia­vahini tájahapuca hórayarehi eta náiteca­pau­chiraya te mapena. Te máechahi­pucaini, ticuneu­cha­vai­pahini éma, váipasare nacuame­ye­chahini. ");
INSERT INTO ignNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eta tacahe, éti écaune­cha­vayare tamutu sácheana, taicha vahi échaimahi tájamu­hu­ya­repuca eta nuchavi­rayare nuti Manere­ji­ru­nuhi ema Viya, machu iárameca —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tacahe, ema Pedro mayase­recapa. Ánipa maicha: —Tata Náquenu, eta juca pímicu­tia­ra­cha­que­ne­havihi, ¿viyehe­ya­re­chu­chapuca viti dócequeneana, téhesera vimutupuca viti véhica­vianahi? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tacahe, ema Viáquenu majicapapa: —Nímicu­ti­chi­nahepa eta apana. Macañá­ri­hipuca ema empleado máetaviuchahi eta máitupa­ji­jia­si­ravahi. Tisuapa­ji­ra­hivare éma. Ema máquenu tiyana­yarehi te apana avasare. Táitusiava matupa­racahi ema empleado eta máijara­siraya eta tinicacare ena apamuriana machamu­su­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tétavicava eta máurica­ca­revaya ema maca ticatu­pa­rahahi, te tamutuhi máitaucha jácani machima­pirana ema máquenu. ");
INSERT INTO ignNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Németeaca, eta tamutuirahi tiuri eta machima­pirahi, matupa­ra­cainapa éma téchayarehi tamutu eta máimaha­queneana. Eta tacahe, nuvaraha ácutipaini ema maca empleado tiúrihi eta máitauraiva. ");
INSERT INTO ignNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Téhesera, váhipuca tiuri eta mapane­reruana ema mácani empleado, máimija­chaichucha tiyere­yarehi eta máiteca­pi­ra­yarehi ema máquenu. Tásiha, macaete­ma­ji­ri­ca­va­ca­papuca ena machamu­su­vanahi, énapa ena vanara­canahi. Máichapapuca eta piesta, téniricapa térapa, ticavahapa. ");
INSERT INTO ignNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tásiha, vaipa maneca­pau­cha­vahini te títecapapa ema máquenu. Tásiha, machima­racapa ema empleado eta mamapa­chi­chi­ji­siraipa eta máimaha­queneana. Eta tacahe, ema máquenu macava­nai­ri­pinapa náestacayare muraca, taicha eta mamasua­pa­ji­raivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tacutiquene mácani musu, te máechahi eta mavara­ha­que­neanahi ema máquenu, tásiha vahi máitauchahi eta mavana­hianahi éma, muraca­yarehi eta macaicu­ñai­rayare. Ticaesta­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mácanisera musu, te vahi máechahi eta tacaye­ma­queneana, tásiha téjeca­pavapa, éma apaesa­yaréchu eta máicuñayare. Étipa eti ecaimi­tu­ca­sianahi eta yátupi­que­neanahi, tatupa­racahi ímitu­ca­va­cayare ena apamuriana achaneana. Núti, ánaquia­paripa eta nímitu­si­ráhehi; tásiha puiti, étipa táehanacahi eta juca ímitu­re­si­rayare. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Núti, eta nítesirahi te juca apaquehe, tímite­canuhi eta népeniraya. Yátupiyare eta nucata­ji­vai­rayare, naicha ena ticatia­na­canuana. Éti apanava, ticatia­na­ca­hea­nayare táichave­ne­yarehi eta éhisi­ranuhi núti. Tímicu­ti­ji­ri­ca­va­yarehi te tipaica eta yucu, eta tamuruira eta muiji. Eta juca, nuvara­ha­quenehi táitaucha­va­va­nehini. ");
INSERT INTO ignNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Éti ímija­chai­papuca eta nítesirahi te juca apaquehe, tájina tácaye­ma­ca­rémahi, ímija­chai­pa­va­repuca tiúrica­va­ca­re­yarehi nícha. Váhisera ene tacahe. Táichaveneya eta éhisi­ranuhi, ena achaneana tépuru­heanaya téraji­ca­vanaya eyehe. ");
INSERT INTO ignNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taicha puiti juca vicaiju­heyare, te natiari­hi­na­papuca te étanahi peti mácani achane, esu mayena, esu machicha, ema machicha, ésupa esu chínenaca. Te mapana­na­hipuca ena téhica­nuanahi, tásiha apina­na­hipuca ena ticatia­na­ca­nuanahi. Téhesera apina­na­hipuca ena téhica­nuanahi, mapana­na­hi­va­repuca ena ticatia­na­ca­nuanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mácani achane, súcani esena, te natiarihi ena nachicha­naveana, nacati­cha­yarehi ena ticachi­chanahi táichave­ne­yarehi eta náehisi­ranuhi éna. Mácani apana achane masuapa­ji­rai­rahahi, súcani esena, nacati­cha­yarehi ena nachicha­naveana táichavenehi eta náehisi­ranuhi, énapa ena nachine­na­naveana. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tacahe, ema Jesús máechajicapa ena achaneana: —Te ímaha timapi­curume, émetea­caripa tiquivayare. Ene tacahehi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Técati­ca­vapuca te vana, émetea­caripa váipavare tiquivai­mahi. Énevare tacahehi. ");
INSERT INTO ignNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Eti masuapa­ji­rai­rahana! ¡Yátupi­hinéni ímatie­que­nehahi te tiquivayare, váhisera ávara­hahini ímatie­queneha eta máimeruhehi ema Viya, te juca sácheana nucacha­ne­rahehi! ");
INSERT INTO ignNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Tájaha tacayema vahi ávara­hahini éhica eta juca yátupi­queneana? ");
INSERT INTO ignNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","Járaja­painapa eta sache ticaicu­ña­nainapa namutu ena achaneana. Tacamu­nurichu etanu­cayare puiti ema Viya, ecasi­ñayare ecuchu­cui­yavaina. Eta juca tímicu­ti­ji­ri­cavahi mácani achane te ticame­tau­cha­casiya. Tatupa­racahi tativaya máetupi­ri­ca­numaya eta mayasea­si­rayare perdón ema timetauchahi, mapurare vuíchaha masiapahini te cárcel. Taicha te masiapapa, ticaje­rae­que­nénapa eta máuchucuiraina. Numeta­cahehi puiti: Te jácani esiapa eta yucu infierno, váhiquene iúchucaimahi éti —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Étarichu te jena sache, títeca­pa­na­varepa ena apamuriana achaneana. Nametacaipa ema Jesús eta táiñehiquene máichaquenehi ema Pilato, étaripa eta máimica­pa­si­ra­vacahi ena tiyuja­ra­canahi te jena Templo te Jerusalén. Ánivare nacahe: —Ena nani, galiléoanahi éna. Tépenanapa te tachaca­yanahi eta sárareana nacapa­ruanahi námava­huá­sanahi. ¿Étapuca eta nasipe­ca­tu­rai­va­hipuca tímica­pa­ca­vacahi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tacahe, ema Jesús máichavacapa: —Éti ímijachaipa táimica­paruhi eta nasipe­ca­tu­rai­vanahi ena nani nayehe ena apamuriana najanea­nanahi te Galilea. ");
INSERT INTO ignNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nútisera numetacahe: Váhira étainahi táimica­pa­cahini eta nasipe­ca­tu­rai­vanahi. Vahi étapa­racaina. Tacamu­nusera éneuchavavane éti, machu táijahúchava eta épenira, machu ácuti éna. ");
INSERT INTO ignNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Némechahe ena nani diéciocho­queneana tacapa­ruanahi eta táevajai­si­ravahi eta torre tayucha­ma­rainihi te calle Siloé. Ímija­cha­papuca táimica­pa­ca­vacahi eta táichapevahi eta naviureva, naveti­ji­papuca nayehe ena apamuriana ticava­sanahi te Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nútisera numetacahe: Váhira ichapena eta naviureva ena apamuriana. Étiripa, te vahi ecueneuchava, éneri­chuvare tíjahú­chavaya eta épenira —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eta máechaji­ri­sirahi ema Jesús, máimicu­ti­ji­ri­chinapa. Ánipa macahehi: —Matiarihihi ema achane. Tatiarihihi eta masucure higo. Máhiri­qui­re­hisera. ");
INSERT INTO ignNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tacahe, máichapa ema mamusura: “Mapanapa año vahi ticahi eta juca nusucure. Péchupai­cayare puiti taicha tiápita­vái­ricaipa eta te juca isaniti” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Émasera ema musu majicapapa: “Tiúripa­na­pucaini, tata, vicucha­pai­chahaini étanai­na­varéni año. Nuvaraha némuri­na­he­chayare eta máteji apaesa tacahi­pa­pucaini. ");
INSERT INTO ignNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Téhesera váhique­né­nai­chapuca tacucahi, néchupai­ca­sarepa” macahepa ema musu. ");
INSERT INTO ignNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te apanapa sávaru, ema Jesús tímitu­re­ca­varepa tayehe eta náuruji­si­rareva. ");
INSERT INTO ignNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sutiarihihi esu esena mávaháruhi ema éreana, tépiñu­mai­quehehi eta suítaresira. Vahi táurihini sutupi­na­hahini. Diéciocho áñoripa eta sucaju­mairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Te máimahapa ema Jesús, máichuhapa. Tacahe, supauchapa. Máichapa ésu: —Páurevi piti esena, picajumahi. Puítisera pinara­cainapa —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tacahe, ema Jesús manacapa eta mavahuana te suápusi. Enevanepa titupi­nahahi ésu, tinaracapa eta sujumainihi. Ichape­rinehi eta sucuna­chirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Matiari­hi­hivare ema táquenu­ruhahi eta náuruji­si­rareva. Eta máimarahi eta juca, tisema­rinehi taicha eta macana­ra­sirahi ema Jesús esu sucaju­maquene te jena sache sávaru tacapi­ca­hu­quenehi. Tásiha, máichavacapa ena achaneana: —Saisi sache tatuparaha eta vicaema­ta­neraya, éneri­chuvare eta nacaipui­ra­yareva ena nacaju­ma­queneana. Puítisera juca sache, vahi táuricahini nacaipuhini taicha tacapi­ca­hu­quenehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tásiha, ema Viáquenu Jesús, majicapapa: —¡Tétavi­cavahi eta tamuracava eta esamureana! Te ticaitiquihi eta epera te jácani sache sávaru, eveja­pua­ca­yarehi eta ésichi­rayare eta une, tayanapane tacapi­ca­hu­que­ne­hinéni eta sache. ");
INSERT INTO ignNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Suvetijicha esu suca esena vicuti­quenehi achane, mámarie­quenehi ema viáchucaini Abraham, ticata­ji­ca­carehi eta nucana­ra­si­ra­yarehi tayehe eta máitiarapi ema Satanás. Taicha dieciocho áñoripahi eta máecáju­ma­chirahi ésu. ¡Táuricahi nucana­ra­ca­yarehi puiti juca sache tacapi­ca­hu­quenehi! —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eta nasamirahi ema Jesús, namutu ena ticatia­na­canahi titsiri­ha­na­rinehi. Énasera ena apamuriana achaneana tiúrisa­mu­rea­na­rinehi, taicha eta náimairahi eta táurica­ca­re­queneana máichaque­neanahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ánivare macahe ema Jesús: —Puiti nuvaraha nímicu­ti­chinahe eta nímitu­rapiana nuti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tacutihi eta ánichi­chaquene taqui eta mostaza. Te máevacapa ema achane te máesane, tiúnara­hi­yarehi eta tajurusira. Tásiha, járaja­painapa eta cáyureana, ticama­ca­ji­yarehi te tatavana eta sucureca. ");
INSERT INTO ignNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ánivare macahe ema Jesús: —Nímicu­ti­chi­na­he­yareva eta apana. ");
INSERT INTO ignNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eta nímitu­rapiana tacuti­hivare eta lévadura. Esu súcani esena tiúrihi eta tasisi­jisira eta suyehe lévadura te tamutu eta suépiyaruhi masa, tayanapane apina­pucaini arroba eta suyehe jarina, tasiha­ji­ca­hisera. Jéhesare, tiápuca­yarehi tiuri —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ema Jesús tiyanavare tipaica. Máimitu­ca­vacahi ena achaneana te jácani avasare máiteca­pi­hapahi. Macaijuhehi eta Jerusalén, váhisera máiteca­pa­va­nehini. ");
INSERT INTO ignNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Matiarihihi ema tiyase­se­recahi éma, ánipa maicha: —Tata Viáquenu, ¿váhipuca camuri­ha­via­nainaya viti viúchucu­hanaya? —máichapa. Tásiha, éma majicapapa: ");
INSERT INTO ignNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Vahi táechacare te ánimu­ri­hea­na­ya­rei­chupuca eti esiapanaya eta mávasa ema Viya. Étisera tacamunu epamicava esiapaya puiti. Vahi ecuyacuji. Taicha camuria­nayare ena apaesa­chi­charichu eta navarairahi tisiapanaya, váhisera títuji­ca­va­naimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Taicha járaja­painapa eta sácheyare, nérata­cainapa eta tapaja. Tásiha, íteca­pa­papuca éti, éhaha­mecapa eta tapaja, epiara­canupa: “Tátachicha, pivejie­que­ne­hahavi”. Tásiha, nujica­pa­hénapa núti: “¿Nájaha­hesica éti? Vahi nímatihe. Váhivare nuchane­ra­hénahi éti”. ");
INSERT INTO ignNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tásiha, ejica­pa­nui­na­papuca: “Vítirichu picacha­ne­que­neanahi te mesa eta vinisirahi. Pímitu­ca­ha­vi­hivare te plaza te jena viávasa”. ");
INSERT INTO ignNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tásiha, nujica­pa­hé­na­varepa: “Esama­nuripa, vahi nuchane­rahéna éti. Évuisiha eta te juca, emutu eti íchara­hianahi eta tamauri­queneana” níchahénapa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Járaja­painapa eta sache ímahainapa te tajuhe eta mávasa ema Viya te návihahi ena viáchuca­na­vea­nainihi: émaripa ema Abraham, ema Isaac, ema Jacobo, énapa namutu ena profetana. Étisera enasinapa te aneca. Tétavi­cavaya eta íyauchi­ravaya, ecapi­ti­quia­he­chi­ravaya taicha eta ecati­sa­mu­ré­ravaya étapa eta etsiriraya eta emasia­pirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nasapiha tisiapanaya ena camuri­queneana achaneana tiásiha­nayare te tamutu avasareana te juca apaquehe. Tétavi­ca­vainapa eta náurisa­mu­revaya. ");
INSERT INTO ignNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tásiha, te jena sácheyare, nácani téquene­hanahi puiti, nasapi­hainapa tisiapa­nayare. Étisera eti ínapu­reanahi puiti, étina­varepa vahi ítuji­ca­vaimahi esiapa —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tacahe, te jena sáche, títeca­panapa ena fariséoana te mávihahi ema Jesús. Náichapa: —Piyana. Pitátájiva piúchuca eta te juca. Taicha ema Herodes mavaraha ticapa­ca­viyare —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Émasera ema Jesús majicapapa: —Eyana emetaca ema mácara ticaete­ma­ra­hiquene. Vahi típica­ra­re­ca­nuimahi núti eta juca mameta­rapihi. Nunasi­ya­rechaha puiti, nucana­ra­re­ca­nu­mayare ena nacaju­ma­queneana énapa ena návahá­ruanahi ena éreanana. Núti jucarihi eta némata­ne­re­pipahi eta tímipai­ca­nupahi puiti juca sácheana, nítaucha­nu­mayare tamutu. Vahi émainayare técha eta népeniraya. Yátupisera eta Jerusalén návasahi ena ticapa­hianahi ena profetanaini. ");
INSERT INTO ignNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tétavi­cavahi eta táimica­ti­sa­mu­re­chiranu eta viávasa Jerusalén. Namapuruji ena tachicha­na­vea­nasami. Éna, ticapa­pa­ji­canahi ena profetanaini mavana­ranahi ema Tata. Puiti navara­hainapa nútipavaya ticapa­canuana. Ichape­mu­rinehi eta níchuira­vacahi éna, náurujia­ca­nuhini tacutihini eta varayu te tacuru­ji­muriha eta tachicha­naveana te tapava. Váhique­nesera návara­hahíni. ");
INSERT INTO ignNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Náimahai­na­pasera eta náichara­ra­ca­vayare. Ticaqui­pai­ca­siyare tamutu eta napenana. Táimiju­na­va­cainapa éna eta napisiraya. Numeta­ca­hevane puiti: Eta nínajia­si­ra­va­cainapa, vaipa tímaha­nua­naimahi. Tiámainu­ca­vainapa te náitsivacha eta napane­reruana, navara­hainapa tijaca­panuana. Nacahénapa: “Ichape eta vicuna­chiravi píti vanairu­ca­que­névihi me Viya” nacahénapa. ");
INSERT INTO ignNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tacahe, te jena sache sávaruhi, ema Jesús ticaichu­ha­casihi tinipanaya te mapena ema émana náiyamuri ena fariséoana. Ticaichu­ha­ca­sia­na­hivare ena apamuriana fariséoana, énapa ena máestroana tayehe máimitu­rapiana ema Moiséni. Navarahahi nacaicu­tia­ra­yarehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tíjahú­chavapa tímerecava te nataracu ema émana achane macaju­maquene. Tiámaquia­pe­vacahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ema Jesús, eta máimairahi ema macaju­maquene, mayase­re­ca­vacapa ena natiari­hi­que­neanahi: —¿Táuricapuca vicana­ra­cavaca ena nacaju­ma­queneana puiti juca sávaru­mu­huirahi tacapi­ca­hu­quenehi? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Énasera vahi najica­pahini, timati­na­na­richucha. Tásiha, ema Jesús macara­ta­vauchapa ema macaju­maquene. Eta macara­ta­vau­chirahi, enévanepa tinaraca. Tacahe, máevatacapa mayana te mapena. ");
INSERT INTO ignNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tásiha, máichavacapa ema Jesús: —Nímicu­ti­chinahe puiti. Éti, németeaca májina émanaina achane vahi macuja­pa­nuhini eta mapera burro, mavuiye­rapuca, te tiáquipai­cavahi te pusu te jena sache tacapi­ca­hu­quenehi. Eta máeñamirahi, tipatsi­ca­va­yarehi macaeche­pupana eta paure sárare, tayana­pa­ne­hinéni eta sache tacapi­ca­hu­quenehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Énasera vahi napatsi­ca­vahini najica­pahini. Timati­na­na­richucha. ");
INSERT INTO ignNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eta máimara­ra­si­ra­vacahi ema Jesús ena macumpi­ra­cha­que­neanahi ema fariseo, énajivahi tinere­jiu­chavana eta náejasi­ha­yarehi tiúrina­panana. Tacahe, ema Jesús maconse­ja­cha­vacapa, ánipa máichavacahi: ");
INSERT INTO ignNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Te natiari­hi­napuca nacumpi­rachahe, vahi ecaina­pu­pui­ca­vaimahi ecaejacava tayehe eta téjasi­ha­careana taicha tijuricati eta máejasi­ha­yarehi mácani ticapi­ca­hu­panahi eyehe éti. ");
INSERT INTO ignNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Taicha ema téniricahi, éma ticaeja­re­ca­yarehi, tijuricati macaeche­pucavi te péjasihahi macaeja­si­ha­yarehi mácani apana. Titsiri­ha­ca­repahi eta macaeja­ca­vihini te náequenemuri. ");
INSERT INTO ignNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Te ecaichu­ha­ca­sipuca, ecaeja­cavaya te náequenemuri, apaesa ema téchahi tíchuha­hénapa ticaeja­ca­heyare te návihahi ena tipicau­cha­ca­rea­na­panahi. Tásiha, ecuna­cha­ca­ré­na­sarepa nayehe ena natiari­hi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Taicha nácani ticasi­ña­va­vai­canahi tímija­cha­vanahi ticapi­cahuana, ema Viya máimica­tsi­ria­ca­va­ca­yarehi. Nácanisera mánsuanahi eta náitaresira, ichapeyare eta nacuna­cha­ca­re­vayare me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ema Jesús maconse­ja­chavare ema fariseo, ema ticumpi­ra­recahi: —Píti apanavare, te péniri­cayare, vahi nacucarichu píchuhavaca ena pémuna­ca­sa­rea­nahicha, ena pipara­pe­na­vea­napuca énaripa ena rícoana, táichave­nénahi eta pivarai­rainahi títsiri­ji­ca­vanaya eta piyehe. ");
INSERT INTO ignNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Píchuha­va­ca­yareva ena páureana, nácani nacahe­ma­hianahi: túpúpa­vaquiana, masariana, púchuquiana. ");
INSERT INTO ignNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Taicha ena nani, vahi títsiri­ji­ca­va­naimahi eta piyehe. Táitsivasera tétávi­ca­vayare eta piúrica­ca­re­vayare píti eta pijaca­pi­rayare eta pícuchihi te jena sácheyare picacha­ne­va­cayare ena náurique­neanahi macaeche­pureana ema Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tacahe, eta nasamirahi ema Jesús ena natiari­hi­que­neanahi te mesa, téchajicapa ema émana. Ánipa macahehi eta mayehe ema Jesús: —Tétávi­ca­vayare eta viúrica­ca­revaya te visiapapuca eta mávasa ema Viya, vinicayare te mamesara —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tásiha, ema Jesús majicapapa, máichapa: —¡Jéhesare, te esiapa­pa­pucaya! Nímicu­ti­chinahe puiti. Matiarihihi ema émana achane téniricahi eta ichape­mu­riquene tinicacare. Camuriana ena máichuha­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te máimahapa tiúripa eta tinicacare, mavanecapa ema mamusura mameta­cavaca náitecapa ena nacaichu­ha­ca­si­que­neanahi taicha tiúriripahi eta tinicacare. ");
INSERT INTO ignNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Namutusera natanucapa eta náetsera­ru­yarehi. Ema apana ánipa macahehi: “Vuíchaha nítuji­ca­vaimahi níteca. Nuyana­nu­mayare nímaha­pa­nayare eta nuvacha­reruhi apaquehe”. ");
INSERT INTO ignNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ema apana éneri­chuvare, ánivare macahe: “Picata­ji­ca­nuchaha. Vuíchaha nítuji­ca­vaimahi níteca, taicha nuyana­nu­mayare nímaha­pa­nayare eta cinco yúntaquene vuiye nuvacha­re­rua­nahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ema apana ánivare macahe: “Nupaenumava nítauchavahi eta nuveha­ca­cairahi. Eta tacahe, vahi nítuji­ca­vaimahi níteca”. ");
INSERT INTO ignNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te tichavapa ema musu vanairucahi, mametacapa ema máquenu eta namaitu­ji­si­ra­va­vacahi títecana ena máichuha­que­neanahi. Tásiha, tisemapa ema máquenu. Máichavarepa ema musu: “Tiuri, piyana puítirichu te plaza étapa te cálleana. Píchuhavaca ena páureana, ena masariana, ena púchuquiana, nácani pétupia­rua­nayare nacahe­ma­hi­que­nea­nahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tacahe, te tichava­varepa ema musu, mametacapa ema máquenu, máichapa: “Tata, nítaucharipa eta juca pivanai­ripihi. Jucari­hi­cha­hasera eta juca téjasi­ha­ca­reana”. ");
INSERT INTO ignNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tacahe, ema máquenu máichavarepa: “Piyanavare puítirichu te isanitiana. Píchuhavaca ena achaneana, nácanipa piácapa­ji­rua­na­ya­repahi te achene. Picame­savaca náiteca, apaesa nayuri­ticava eta juca téjasi­ha­careana mávacua­nai­chahahi. ");
INSERT INTO ignNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nusema­carupa puiti. Nájinava néniruimahi ena náinapu­reanahi níchuha­que­nea­nahi” macahepa ema téniricahi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Te jena sácheana, camuriana ena achaneana téhicanahi ema Jesús. Tásihasera, éma máeseni­mu­rihapa. Máichavacapa: ");
INSERT INTO ignNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Te etiari­hipuca éti evara­ha­nayare éhicanu, tacamunu epami­cavaya yátupina eta éhisi­ranuya. Nútinapa émuna­ca­pa­nayare, németa­vi­cainapa eta émuna­si­ra­vacaini ena ticachi­chaheana. Mácani achane németa­vi­ca­yareva eta máemuna­siraini esu mayena, machicha­na­vea­napuca, mapara­pe­na­vea­napuca. Váipavare éñamaimahi eta ítaresira. Téhesera apaesa­ri­chupuca eta émuna­si­ra­nuyare, vahi táuricaimahi éhica­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ecata­ji­vayare taicha eta éhisi­ra­nuyare. Te epica­hipuca íjaracava muraca, táimica­pa­ca­hepuca eta éhisi­ranuhi, tiúripanaichu vahi ecuehicanu. ");
INSERT INTO ignNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tacutiquene te epane­re­cha­hipuca éti épiya­re­cayare eta anuquehe peti apinapuca piso, vahi táuricahini émuna­na­si­ca­vahini enaha­ha­ji­si­ra­vai­na­richuini ecaematane, epane­re­cha­nu­ma­yarehi áyana­ya­re­hipuca egastaruya ítauchi­rainahi eta evara­ha­quenehi épiyaca. ");
INSERT INTO ignNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vahi ácaemu­ña­vaimahi épiyareca eta tiúrina peti, te vahi árata­haimahi ítaucha. ");
INSERT INTO ignNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tásiha, nacahé­na­papuca ena ticaeca­hi­hea­nayare: “Ímahapa, váhira márata­hahini máitauchahini eta jena peti, táurina­que­ne­ya­rehíji. Tíjara­ca­va­samipa. Ichape eta mamelaya” nacahe­na­papuca. ");
INSERT INTO ignNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Émaripa mácani rey, te tisema­hipuca, mavarairahi máichayare eta guerra, macana­yarehi mácani apana rey camuri­pa­nanahi ena machanerana, mapane­re­cha­nu­ma­yarehi te marata­ha­ya­repuca macanara taicha éma vahi camuria­nai­nahini ena machanerana. ");
INSERT INTO ignNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eta máimairahi vahi márata­ha­yarehi, váhivare tíjara­ca­vaimahi máehaca­cahini. Tásiha, máimiva­ne­re­cainapa mayehe ema mánara­ya­rehini táitavapa eta semanerehi, vaipa nacupa­ne­re­chahini. ");
INSERT INTO ignNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ene ecahehi éti. Eta evarairahi éhicanu, epane­re­cha­nu­ma­yarehi eta ínaji­si­rayare tamutu, erata­hai­ra­yarepa yátupi eta éhisi­ra­nuyare. Taicha te vahi erata­hayare, vahi ecucae­muñava éhica­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Eta icheve, tétavi­cavahi eta táurivahi taicha eta tacamu­nu­ca­revahi. Étasera eta tajachira eta icheve, tépuru­ca­repahi. ");
INSERT INTO ignNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tájinapa tacamu­nu­ca­re­vai­nahini. Ticaqui­ji­yarepa. Ene nacahehi ena tínaji­cavana eta náehisi­ranuhi. Nacutihi eta tajachira eta icheve. Te evara­hapuca ecaicutiara, tavaraha eta epane­re­chi­navaya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tiuri, te jácani sácheana, títeca­pa­ra­ca­na­varepa ena achaneana te mávihahi ema Jesús. Camuria­napahi éna. Natiari­hipahi ena cóbraré­ca­rahiana eta impuestoana. Namutu éna, ichape eta náepuru­ca­revahi nayehe ena fariséoana. Émasera ema Jesús, vahi máepuru­va­cahini. Tásiha, témeña­ha­vanapa éna te machacaya, taicha navarahapa nasama­ra­ra­ca­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Natiari­hi­pa­hivare ena fariséoana énapa ena máestroana. Ena nani, vahi náuricahini eta macacha­nei­ra­vacahi ema Jesús ena nani achaneana. Ánipa nacahe: —¡Vahi tiuri eta máichaquenehi ema maca! ¡Namutuchucha majaca­pavaca ena nacahe­que­ne­tá­tájiana ticaja­cha­ha­ca­reanahi! ¡Nasapihapa macacha­ne­vacahi eta nanisirahi ena nánita­ta­jiana! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tacahe, te masamapa ema Jesús eta juca, máimicu­ti­chi­na­vacapa eta máimitu­si­ra­vacahi. Ánipa máichavaca: ");
INSERT INTO ignNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Esama­nuchaha. Nímicu­ti­chi­naheya puiti. Matiarihi ema émana achane. Ticayehehi eta cien uvesa. Te témiti­ye­chapuca eta étana, ema achane tiyana­yarehi matanuca eta táemitiaruhi. Eta máeñami­ravahi, majuni­ji­ca­yarehi eta apamuri noventa y nueve uvesa te majanea­sihahi. ");
INSERT INTO ignNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jéhesare, te máichimavapa eta táemitiaruhi, tichavapa tiúrisa­mu­repaipa. Mámapaipa te machepa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te títecapapa te mapena, máichuhapa ena machaca­ya­penana májiriareana. Tacahe, máichapa éna: “Yare, éti apana iúrisa­mu­revare nuyehe núti. Taicha níchima­vaipahi eta uvesa táemitia­ruhi” máichapa ena májiriareana. ");
INSERT INTO ignNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tiuri, núti numetacahe eta juca: Énerichu ema Viya te anuma tiúrisa­mu­revare nayehe ena achaneana tiúrita­re­si­ranahi, taicha tájina náejeca­pi­ra­vai­nahini. Tétavi­ca­vai­ne­hisera eta máurisa­mu­revahi ema Viya nayehe nácani achaneana tímatianahi eta nacape­ca­tu­rairahi, tásiha téneucha­vanapa, náinajicapa eta napeca­tu­ranaini —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tímiyanava eta máechaji­ri­sirava ema Jesús, ánipa macahe: —Nímicu­ti­chi­naheya eta apana. Sutiarihi esu ésuna esena. Ticayehehi eta dies reale eta tijapu plata. Te témiti­ye­chapuca eta étape, tinane­si­yarehi sutanu­ca­yarehi eta táemitiaruhi. Eta sutanu­si­rayare, suyusta­cainapa eta sumicahu. Supihi­cainapa tamutu eta te tajuhe eta supena. ");
INSERT INTO ignNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te suíchimavapa, tiúrisa­mu­rénapa. Suíchuha­va­cainapa ena suchaca­ya­penana suájiriareana. Tacahe, suíchava­cainapa éna: “Yare, éti apana iúrisa­mu­revare nuyehe núti, taicha níchimavaipa eta reale nucami­tiaruhi” suíchava­cainapa esu esena ena suájiriareana. ");
INSERT INTO ignNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tiuri puiti, núti numetacahe eta juca: Ene macahehi ema Viya. Tétavi­ca­vainehi eta máurisa­mu­revaya te namuri ena ángeleana eta máeneuchi­ravapa mácani achane cápeca­tu­ra­rahini, máinaji­si­raipahi eta mapeca­tu­ranaini —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tímiyanava eta máechaji­ri­sirava ema Jesús, ánipa macahe: —Matiarihihi ema émana achane. Apinanahi ena machicha­naveana. Ajairana. ");
INSERT INTO ignNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Étana sache, máichapa ema maiya ema émana machicha amuyapana: “Tata, picata­ji­canupa, píjaracanu puiti eta nuyeheyare tatuca­cha­que­ne­nuyare eta picaye­he­queneana” máichapa. Tacahe, tísapavapa ema naiya. Máijara­ca­vacapa eta máimaha­queneana ena apinana machicha­naveana. ");
INSERT INTO ignNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tacahe, étarichuhi te jena sácheanahi, tétupi­ri­cavapa ema amaperu, tiyana­vanepa. Mámapa tamutu eta mayehe­chi­ra­va­ripahi máijararuhi ema maiya. Tiyanapa te apana avasare tayere­hiquene. Eta ánaqui, máitaiyahi tamutu eta máimaha­que­neanaini. Tamutupa mamapa­chi­chijica. ");
INSERT INTO ignNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tacahe, eta jena sácheana, táiteca­pauchapa eta ecuha eta avasare mávihahi ema amaperu. Tacahe, namutu ena achaneana tayehe eta te avasare téchuri­hanapa eta tinicacare. Tivayu­chavapa eta ecuha. Ema amaperu títara­haipahi eta máimaha­que­neanaini. Tásiha, tájinapa maviyahini eta manica. ");
INSERT INTO ignNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tásiha, ticaque­nu­recapa mayehe ema émana achane. Tacahe, ema máquenuhi mavanecapa ema amaperu eta majanea­sinaya eta cúchiana eta te máesane. ");
INSERT INTO ignNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ichapesera eta máecuavahi. Majamu­ra­chainehi manicahini eta taniru eta cúchiana, taicha nájina náitátihini éma. ");
INSERT INTO ignNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tacahe, téquecavapa eta mapane­re­ruanahi. Tipane­re­que­ne­havapa émajiva. Ánipa tacahehi eta mapane­reruhi: “Namutu ena mavanarana ema tata, tiúrihi eta nanisira. Nútisera ani ticapa­ca­nuinapa eta nécuava. ");
INSERT INTO ignNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Níjaracava, nuyana nuchava eta me tata ticachichanu. Tásiha, níchayare éma: Tátachicha, nucape­ca­turaipa mayehe ema Viya étapa eta piyehe piti tata. ");
INSERT INTO ignNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tayana­ri­nepuca táimicu­ti­ji­ri­ca­vai­nepuca vahi pichichanuina. Picata­ji­ca­nusera. Pijacapanu, nímiáque­nu­cha­varine piyehe piti tata. Nácutirine ena pivanarana. Níchayare ema tata”. Tacahepa eta mapane­reruhi ema amaperu achane. ");
INSERT INTO ignNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tásiha, tiyanapa tichava eta me maiya. Te tiánehipa títecapa ema amaperu, máimahapa ema maiya. Enurujipa máimativane. Ichape­rinehi eta majapa­nuirahi. Enurujipa tiyana tijunapa mácapa. Majupa­hacapa ema machicha. Máetsera­recapa eta máurisa­mu­revahi. ");
INSERT INTO ignNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Émasera ema amaperu, téchajicapa. Ánipa maicha: “Tátachicha, nucape­ca­turapa mayehe ema Viya étapa eta piyehe piti tata. Tásihasera, tayana­ri­nepuca táimicu­ti­ji­ri­ca­vai­nepuca vahi pichicha­nuinaya” máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Émasera ema maiya, mavaraha máimerecaya eta yátupirahi eta majaca­pirahi ema machicha. Vahi máicuña­cahini. Tásiha, mavanecapa ena mavanarana. Máichapa: “Etátá­jirica, iama eta muíriare tiúrinapana. Emuiriacha ema maca nuchicha. Iama eta tiúrinapana surtija; masuru­tijaina. Iámavare eta tiúrinapana eparupeva, máeparu­pevaina. ");
INSERT INTO ignNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Éneri­chuvare épana eta jena mamona tiújepana. Ecapaca, vinica. ¡Víchayare eta piesta! Viúrisa­mu­revaina eta máiteca­pirahi ema maca nuchicha. ");
INSERT INTO ignNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taicha éma, tímicu­ti­ji­ri­cavahi eta máepena­que­né­nahini ema maca, puítisera tiúchujicapa tichavapa ani nuyehe. Máemitiaruhi te numirahu, puítisera nímahapa éma” macahepa ema maiya. Tacahe, ichape eta náurisa­mu­revahi namutu. ");
INSERT INTO ignNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tiuri, ema émana machicha máechavihi tiyanahi te isaniti. Te tichavapa, te tiánehipa eta napena, masamapa eta piesta te tajuhe. ");
INSERT INTO ignNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tásiha, máichuhapa ema émana nacajurure. Mayase­recapa: “¿Tájaha tacayema eta juca piesta?” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tacahe, máichapa ema macajurure: “Ema piparape títecapahi. Tásiha, ema piya máimica­pacapa eta étana mamona tiújepana. Ichape eta piesta, taicha eta máurisa­mu­revahi ema piya eta máiteca­pirahi ema piparape” máichapa ema macajurure. ");
INSERT INTO ignNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tacahe, tisema­rinehi ema maparape. Vaipa mávara­hahini masiapahini. Tacahe, te máechapa ema naiya, tiúchucapa. Macamesapa macasiapa. ");
INSERT INTO ignNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Majica­pa­pasera ema machicha, ánipa maicha: “Pímaha, tata. Ánaquiapapa eta nítatí­ravihi núti. Tájina nímati­yahini nácapae­ma­cha­vihini te pivanai­ripiana. Tásihasera, tájina píjara­ca­nuhini eta étanai­nahini chívachi­chai­na­pucaini eta nunicahini nucapie­sta­ra­hi­pucaini núti, nácacha­nehini ena nájiriareana némuna­ca­sareana. ");
INSERT INTO ignNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tásiha, puiti pímica­pa­cainehi eta mamona tiújepana, taicha eta máiteca­pirahi ema émana pichicha­tataji. Ema mácatataji títaha­cavahi eta píjara­ruinihi picaye­he­que­nea­nainihi náichavenehi ena esenana túhusiana” máichapa ema machicha. ");
INSERT INTO ignNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tacahe, ema maiya máichapa: “Pímaha, nuchichachicha, píti ánaquia­paripa eta péjaha­si­ranuhi. Tásiha, tamutu eta nucaye­he­que­neanahi, piyehea­na­hivare píti. ");
INSERT INTO ignNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Puítisera, táuricaichucha vicha eta piesta eta viúrisa­mu­re­vainahi, taicha tímicu­ti­ji­ri­cavahi eta máepena­que­né­nahini ema maca piparape, puítisera tiúchujicaipa, tichavapa éma. Ema máemitiaruhi te vimirahu, puítisera viápecha­va­varepa vímaha éma” máichapa. Tacahehi eta máechaji­ri­ru­vanahi ema Jesús nayehe ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ema Jesús ánivare macahehi eta máimitu­si­ra­vacahi ena máimitureana: —Nímicu­ti­chinahe eta apana. Ema achane rico, matiarihihi ema mayehe capataz, téchahi tamutu eta máimaha­queneana ema máquenu. Tásiha, masamai­ri­ricapa ema máquenu eta mamapa­chi­chi­ji­si­raipahi eta máimaha­queneana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tacahe, ema máquenu máichuhapa. Mayase­recapa: “¿Tájaha tacayema eta juca? Nusamau­chavihi eta pimapa­chi­chi­ji­sirahi eta nímaha­queneana”. Émasera ema capataz tájina maviya­vahini macatiu­chia­vahini taicha yátupihi eta máejeca­pi­ravahi. Tacahe, ema máquenu máichapa: “Tiuri, vitupae­que­ne­hayare tamutu taicha vaipa nuvaraha pímiyanava eta nuyehe”. ");
INSERT INTO ignNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tacahe, ema capataz ichape­rinehi eta mapane­re­re­sirahi taicha eta máuchusiraya. Tásiha, macahepa te mapane­reruana: “¿Tájahai­na­papuca níchara­ca­vayare puiti? Ema náquenu ticuchu­ca­nuinapa tayehe eta juca némata­ne­repihi. Ichape eta nutsiri­ha­ca­re­vayare taicha vahi núrihahini nucaema­ta­nehini eta isaniti, váhivare nurata­haimahi eta tamuracava eta emataneca. Titsiri­ha­ca­re­hivare nuyase­se­re­cahini eta nunicaquene. ");
INSERT INTO ignNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tiuri, áni nucaheyare. Némeña­ha­vayare nayehe ena ticante­veanahi mayehe ema náquenu, tiámainucava te nítuca­va­pa­pucaini eta nítati­ji­ya­vayare” macahepa te mapane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tacahe, máichuha­vacapa namutu émanapahi ena ticante­veanahi mayehe ema máquenu. Tacahe, mayase­recapa ema máinapuiruhi: “¿Péchapuca áyana eta pintevehi mayehe ema náquenu?” ");
INSERT INTO ignNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tacahe, ema ticantevehi majicapapa: “200 lata eta aceite comer eta nuntevehi mayehe”. Tacahe, ema capataz máichapa: “Júcahi eta piyehe vale pifirmaruhi. Puítinarichu vítsivachaya eta apana vale. Vaipa pivacha­chaimahi tamutu. Cien latainarine eta pinteveyare” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tacahe, mayase­re­cavare ema apana: “¿Pítiyapa péchapuca áyana eta pintevehi?” Ema ticantevehi majicapapa: “Séisicientohi tarera eta trigo eta nuntevehi mayehe”. Tacahe, ema capataz máichavarepa: “Júcahi eta piyehe vale pifirmaruhi. Vítsivachaya eta piyehe vale. Vaipa pivacha­chaimahi tamutu. Quinientorine tarera eta pinteveyare”. Ene tacahehi eta máichirahi nayehe ena apamuriana ticante­veanahi, máitsiva­chi­ra­paipahi eta nayeheana váleana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tacahe, te máechapa ema máquenuini eta máichaque­neanahi ema mayeheni capataz eta macatiu­chi­ravahi, ánipa macahe: “Tétavi­cavapa eta máitusirahi masámápuha ema maena nuyeheni capataz” macahepa ema máquenuini. Ene nacahehi ena achaneana máimati­ra­hanahi ema Viya. Éna tiápaju­pa­na­va­na­hivare eta náitusirahi eta tayanirava. Nacachu­ricahi ena téhicanahi ema Viya, taicha tavayua­ca­vacahi eta tájipa­racana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Puiti numeta­ca­heyare eti nímitu­reanahi: Eta ítare­sirahi te juca apaquehe tamauri­quenehi, te ecaima­ha­que­ne­hipuca, ecajiyare te napaucha­hepuca ena ticamu­nu­vanahi. Tacahe, te ítecapapa te mávasa ema Viya, tiúriyare eta íteca­piraya, ánaqui ejaca­painapa eta táitsivayare. ");
INSERT INTO ignNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Taicha nácani tiúrihi eta náechapa­ji­ri­sirahi jácani ánichi­cha­quenehi, ene tacahe­yarehi eta táurivayare eta náechapa­ji­ri­si­rayare eta camuri­quenehi. Nácanisera vahi tiúrihi eta náechapa­ji­ri­sirahi jácani ánichi­cha­quenehi, éneya­rei­chu­hivare vahi tiúrimahi eta náechapa­ji­ri­si­rayare eta camuri­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Taicha te vahi tiúrihi eta ítauchirahi eta ecatu­pa­ra­hairahi échapa­ji­ricaya eta tímaha­ca­reanahi eta te juca apaquehe, ema Viya vahi titupa­ra­ca­hémahi eta tímaha­careana yátupi­queneana te anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eta tacahe, ítaura­hiyare tayehe jácani apayeheana apaesa máijaracahe ema Viya eta ícuchihi, taicha eta máimairahi éma eta ítauraivahi éti. ");
INSERT INTO ignNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Éti, eta ítare­sirahi, vahi táuricahini apina­nai­nahini ena iáquenuana. Taicha émuna­ca­pa­na­yarehi ema émana, tisuapa­ca­re­pa­na­ya­re­hivare. Tásiha, ema apana, apaesa­rineya eta émuna­siraina, váipainapa tisuapa­ca­remahi éma. Ene tacahehi eta juca ímaha­queneana, vahi ecuisapa tahapa­sa­mu­re­re­ca­hehini eta plata, machu tahapa­pi­ri­ca­heriana eta émuna­sirahi ema Viya, étapa eta ecaema­ta­nea­sirahi éma —máichavacapa ema Jesús ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Natiari­hi­hi­va­resera ena fariséoana. Nasama­ra­racahi eta juca máimitu­ra­pianahi ema Jesús. Tásiha, nacaeca­hi­ri­chu­chasera eta nasamirahi éma. Taicha tétavi­cavahi eta tavayua­si­ra­vacahi éna eta tímaha­careana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tacahe, ema Jesús máichavacapa: —Éti épiya­cavahi iuri eta ímairavahi nayehe ena achaneana. Émasera ema Viya máimatihi eta esamureana. Macatia­nacahi ichape éma eta apimi­ra­hérahi. ");
INSERT INTO ignNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Numeta­ca­hevare eta apana: Ema víyarahaini Moisés, énapa ena víyara­hanaini profetana tínapu­canahi eta náechaji­sihahi tayehe eta nítesi­ra­yarehi nuti Cristo ecucha­pa­quenehi. Puiti ichape eta navapi­nai­ravahi ena camuri­queneana téhica­nua­napaipa. Éti apana, titupa­racahe éhica­nu­yareva. ");
INSERT INTO ignNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Numetacahe puiti: Váhiquene títavaimahi eta tasuapa­ca­revahi eta máechaji­ri­ruvana ema Tata. Máichecua­raquire éta, tayana­pa­ne­hipuca táitava eta anuma étapa eta juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Éti, eta ímiturapi, ísapahi mácani achane máquijica esu mayena, tásiha, ísapa­hivare maveha esu apana esena. Nútisera numetacahe: Mácani achane, te máinaji­capuca esu mayena, tásiha maveha esu apana esena, éma ticape­ca­tu­raipahi me Viya. Tacutiquene mácani apanavare achane mavehapa esu esena máinajiruhi ema suima, éneri­chuvare ticape­ca­tu­ra­hivare me Viya taicha ésu, matiari­hichahi ema suímaquenehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tacahe, ema Jesús máimitu­ca­va­cavare ena achaneana. Ánipa macahe: —Nímicu­ti­chinahe eta apana. Matiarihihi ema émana achane. Mavayuchahi eta marricuva. Tétavi­cavahi táurinavahi eta macamui­rihaira. Tijanu­nu­ha­canecha. Tamutuhi sácheana máicha eta táurinaquene piesta. ");
INSERT INTO ignNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tásiha, matiari­hi­hivare ema apana achane paure ticaijare Lázaro. Ticajumahi. Amairihahi carachachaha eta majuma. Téjaha­pai­ricahi éma tamutu sácheana te mapajacura ema rico. ");
INSERT INTO ignNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ema maca paure tiyase­se­recahi manicayare eta máemacha­rajiana ema rico. Tájinasera náijara­caimahi. Tavetijipa, vahi túmenahini ema paure. Vaipa marata­hahini macatiu­cha­vahini eta táevera­sirahi eta tamucuana eta macarachana. ");
INSERT INTO ignNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Étana sache títecapapa eta máepenirahi ema paure. Nárajapapa ena ángeleana; náepanapa eta máchaneva ema Lázaro, námapa tayehe eta paraíso mávihahi ema viáchucaini Abraham. Tacahe, te táequenepa, tépena­varepa ema rico. Tiúrinavare eta náecarirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eta máepenirahi éma, tiyanapa tayehe eta macata­ji­vai­ya­yarehi. Tásiha, te téjami­háu­quichapa, máimahapa eta mávihahi ema Abraham, émapa ema Lázaro te machacaya. Mayere­hi­va­ca­hisera eta máimairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tacahe, tipiaracapa ema rícoini: “Tata Abraham, pájapanunu. Picata­jicanu, pivane­si­nanuini ema Lázaro máechipaicaini apaesa­chichaini eta mavauqui te une. Máecasa­re­cha­panaini eta nunene. Taicha tétavi­cavahi eta numaunevahi eta te juca nucata­ji­vaiyahi tayehe eta juca návihahi táijurequene yucu” máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Émasera ema Abraham majicapapa: “Vahi nuvane­caimahi. Péchavachucha, nuchicha, te achane­vichaha, tétavi­cavahi eta piúrica­ca­revahi. Tájina pácamu­nuhini eta pítare­sirahi. Ánipasera picata­ji­vaiyahi. Émasera ema maca Lázaro, ichape­murihi eta macata­ji­vairahi te achane­richaha. Puítisera vaipa macata­ji­vahini. Puiti éma, majaca­pa­ripahi eta máurica­ca­revahi. ");
INSERT INTO ignNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tacutiquene máitujihi eta mánucui­rai­nahini eta ára piyehe. Pítiripa váhivare pítuji­ca­vaimahi píteca­pau­chahavi ani te juca viávihahi víti, taicha jucarihi eta tícheji­mi­rau­cha­havihi eta viánucui­rai­nahini tacutihi eta tiúchausi cajacure. Máitujihi eta mayanahini” macahepa ema Abraham. ");
INSERT INTO ignNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tacahe, ema rícoini máichavarepa: “Tiuri, te váhipuca títuji­ca­carehi, picata­ji­ca­nusera. Pivane­si­nanuini mayana ema Lázaro te nupena. ");
INSERT INTO ignNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mameta­pa­ni­nanuini ena cíncoqueneana nupara­pe­naveana. Maconse­ja­cha­pa­na­vacaini eta náeneuchi­ra­vainaini éna, apaesa váhini nacuite­cahini tayehe eta juca návihahi núti nucata­ji­vaiyahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Émasera ema Abraham máichavarepa: “Éna, narataha téchaji­cu­recana, ticara­va­hua­nayare eta Sagrada Escritura. Te nasuapa­hi­va­repuca eta tavanai­ri­pianahi, vahi tisiapa­naimahi eta te jara ecuñaraqui piávihahi píti”. ");
INSERT INTO ignNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ema rícoini majica­pa­varepa: “Táitaure­vaquene ene tacahehi, tata Abraham. Tiúripa­na­hi­se­ra­hi­pucaini mayanahini ema émana máepena­quenehi eta nayehe ena nupara­pe­naveana, mameta­pa­na­va­cahini. Németeaca téneucha­va­va­nea­napaini”. ");
INSERT INTO ignNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ema Abraham máichavarepa: “Te váhipuca nacusua­pahini eta Sagrada Escritura, tacahe­yarehi eta namasua­pi­rayare mácani máechepurehi máepena­quenehi” macahepa ema Abraham. ");
INSERT INTO ignNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Te táequenepa, ema Jesús mameta­mu­ri­ha­varepa ena máimitureana. Ánipa macahe: —Yátupi eta vahi téjiaca­vaimahi eta tímiaqui­pai­cayare tayehe eta pecatu ena achaneana. Ichapesera eta náicuñayare nácani táemesia­va­nayare náimiaqui­pai­siraya nácani apamuriana tayehe eta pecatuana. ");
INSERT INTO ignNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mácani tímiaqui­paicaya ema émana amaperu, tiúripa­na­hi­pucaini máepenahini mativai­nahini éma. Váhiri­chu­pucaini macucai­cu­ñahini; taicha vahi macuimia­qui­pai­cahini ema amaperu tayehe eta pecatu. ");
INSERT INTO ignNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eta tacahe, échapavaya éti machu ímiaquipaica ena amaperuana. ­ Numetacahe eta apana: Te máejeca­pa­vapuca ema piparape eta piyehe, piconse­jachaya. Téhesera máeneuchava eta piyehe, piperdo­nachaya éma. ");
INSERT INTO ignNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tayanapane siétehé­napuca máejecapava te étana sache, máeneucha­vasera eta piyehe, titupa­racavi piperdo­na­chayare —macahepa ema Jesús. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tiuri, ena apóstoleana nayase­recapa ema Jesús: —Tata Viáquenu, picata­ji­cahavi. Pímitu­cahavi apaesa tajuru­ca­paipaini eta vicasi­ñai­ravahi mayehe ema Viya. Vivaraha ichapenaini eta vicasi­ñai­ravaya eta mayehe —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tacahe, ema Jesús majica­pa­vacapa: —Vahi tácamesa ichape­nahini­ eta ecasi­ñai­ravahi mayehe ema Viya. Tayana­pa­nepuca ánichi­chai­narichu eta ecasi­ñai­ravahi, tácutipuca eta táquichicha eta mostaza, tamutuyare erataha. Étaripa eta jácani yucuqui, te evara­hapuca ecayejeca, erata­ha­yarehi. Te íchapuca: “Piyejecava eta te juca, piyana pisucuchava te cáquiure”; tásiha, eta yucuqui tisuapa­he­yarehi. Tiyeje­ca­vainapa tayehe eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Étaripa ema mácani achane te ticamu­surahi, te másiha­pai­papuca ema musu te vámahi eta majanea­sirahi eta vaca, te tísaha­hipuca, te títecapapa te peti, ema máquenu váiparinehi matátáu­chaimahi máepiyaca eta tinicayare eta máenisiraya ema musu. ");
INSERT INTO ignNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Matátáu­cha­ya­rechucha mavaneca ema musu émaina máepiyaca eta tinicacare, máenicayare ema máquenu. Tásiha, máichainapuca: “Tiuri, nítanesipa. Pítipavapa pinica”. ");
INSERT INTO ignNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Váipari­ne­hivare mahasu­lu­pa­ya­chaimahi ema mamusura eta máitauchirahi eta mavana­hianahi. ");
INSERT INTO ignNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ene ecahehi éti, ecuti ema musu. Te ítauchapa tamutu eta evanahiana me Viya, ecahenapa: “Viti músuanahi vahi vicuna­cha­ca­rémahi. Tacarichuhi vicha eta vivana­hianahi” ecahenapa —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tímiya­na­vavare tipaica ema Jesús, macaijuhepa eta Jerusalén. Máetavi­ca­va­capaipa eta avasareana te provincia Galilea étapa eta Samaria. ");
INSERT INTO ignNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te máiteca­pauchapa eta apana avasa­rechicha, tiúchuji­canapa ena diésqueneana ajairana ticajumana eta lepra. Nacapa­yacapa éma. Váhisera náemeña­ha­vahini éna, nayere­hichucha. ");
INSERT INTO ignNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tacahe, napiaracapa ema Jesús: —Tata Jesús Nazareno, pájapa­nuhavi. Picata­ji­cahavi, picana­ra­cahavi eta vijuma —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tacahe, ema Jesús máeseni­ca­vacapa. Tásiha, máichavacapa: —Eyana, ímerecava te namirahu ena tuparai­rucana apaesa náimama­racahe. Énainapa nameta­jirica eta iúrivaipa, enara­si­raipahi eta ejuma­nainihi —máichavacapa. Nasuapa­vanehi éna. Tásiha, eta nayanirahi, tinara­ca­napaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tacahe, ema émana, eta máimairavahi eta manara­si­raipahi, tichavapa te mávihahi ema Jesús. Tipiara­ca­paipahi muraca eta macuna­chirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Matupirupa tépuyucahi te mamirahu ema Jesús. Tétipaicapa macaitecapa eta mamira te apaquehe, mamave­ra­ra­si­ravahi eta mahasu­lu­pa­ya­chirahi ema Jesús. Ema maca achane, indigenahi samari­tano. ");
INSERT INTO ignNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tacahe, ema Jesús máichapa: —Ticutimahi diésnahi ena nucana­ra­ruanahi. ¿Tájahapuca tacayemahi vahi nachavahini ena apamuriana nuévequeneana? ");
INSERT INTO ignNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Macarichuhi tichava ema maca apava­sa­que­ne­samihi, macuna­chapaipa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tacahe, ema Jesús máichapa ema achane: —Péchepuca, piyana pichava. Pinara­cai­pasera táichavenehi eta picasi­ñai­ranuhi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tiuri, ena fariséoana nayase­re­cavare ema Jesús tájamu­hu­ya­repuca eta máiteca­piraya ema Cristo nacucha­pa­quenehi. Éma, majica­pa­vacapa: —Eta máiteca­piraya ema ecucha­pa­quenehi, tájina metára­pimahi eta máimere­si­ravaya éma. Vahi tácaje­rahini eta ímairaya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nájinavare timeta­ji­ri­caimahi eta máiteca­piraya taicha matiari­hi­ripahi éma puiti ani. Nútiripa —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tacahe, máichavacapa ena máimitureana: —Tatiari­hiyare eta sáchevayare ichapeyare eta ecaimai­ru­nuiraya. Tétavi­cavaya eta evarairaya íjahú­cha­vayare ímahanu nuti Manere­ji­ru­nuhi ema Viya eta nuchaviraya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te navayua­ra­ca­hepuca nacahe­napuca: “Émaripa ema vímaha­quenehi ánaqui”. Ena apamuriana nacahé­na­va­repuca: “Émaripa ema maca vímaha­quenehi puiti eta ani”. Váhisera ecusua­pavaca éna. Váhivare ecuehi­cavaca. ");
INSERT INTO ignNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Taicha te táitauchavapa eta níteca­piraya núti, nucutiyare eta táijahú­chirava títecapa eta térameca. Namutuyare ena achaneana te juca apaquehe tineca­pa­nua­nayare. Tacaheyare eta nuchavi­rayare nuti Manere­ji­runuhi ema Viya. Ticaeche­ra­ya­resera, tájina vahi máchasimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tativa­ya­resera nucata­ji­va­nu­mayare ichape. Tépuru­nua­nayare ena achaneana natiari­hi­que­neanahi puiti. ");
INSERT INTO ignNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Tacutiyare eta acane ena achaneana machamu­rianaini ema Noé. Ena nani tinicai­ri­hia­na­rinecha, náemata­ne­rinecha, térana, tímare­re­canahi ena nachicha­naveana. Vahi téñama­va­naimahi eta náimairahi ema Noé eta masiapirahi tayehe eta ichape pacure. Tájina vahi natseca­vahini eta táiteca­pau­chi­ra­yarehi eta ichape une. Tacahe, eta táemiri­sirapa eta ichapequene tiquiva, tacapa­pa­ji­ca­vacahi namutu éna. Ene nacaheyare ena achaneana te jena sácheyare. Vahi titseca­va­naimahi tayehe eta nuchaviraya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tacutiquene ene nacahe­hivare acane ena achaneana ena machamuriana ema Lot. Tinicai­ri­hia­na­hivare éna, térara­ca­va­na­hivare. Étanecha napane­rechahi náijarareca eta náevava­reruana. Ena apamuriana natanu­ji­ri­ca­rinecha eta nacamu­nu­que­neanahi. Tépiya­re­re­ca­na­richucha pétiana. Vahi naéñama­vahini tayehe jácani ecuña­raquiya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Téhesera te majuni­jicapa ema víyarahaini Lot eta avasare Sodoma, tíjahú­chavapa tiquivapa eta yucu ticasiriqui azufre tiásihahi te anuma. Tacapa­pa­ji­ca­vacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ene tacaheyare eta nusache­rayare nuti Manere­ji­runuhi ema Viya eta nuchaviraya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Te jena sácheyare, nácani tachima­ra­rua­nayare te aneca, vahi táuricaimahi nasiapahini te napena naveha­nu­mahini jácani náeñama­que­neanahi náimaha­queneana. Énaripa ena napairi­ri­ruanahi te vámahi, váhivare tichavae­que­ne­ha­va­naimahi náepanahini eta náeñama­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Écharichuhi eta acane eta suíchara­ra­cavahi esu mayenaini ema Lot. Ésu, tétavi­cavahi eta suéñamae­que­ne­hairahi eta suímaha­queneana sujuni­ruanahi. Táichavenehi eta suvarairahi tichava, ésujivapa ticami­tie­que­ne­hava. ");
INSERT INTO ignNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nácani téñamanahi eta náitaresira, tahapa­pi­ri­ca­rinecha eta tájipa­racana te juca apaquehe, éna témitie­que­ne­hanaya eta náitaresira. Énasera nácani tahapa­pi­ri­ruanahi eta náehisi­ranuhi, tayana­pa­nepuca táimica­pa­cavaca, éna títuji­ca­va­nayare tiúchucu­ha­nayare eta náitare­si­ranaya. ");
INSERT INTO ignNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Numeta­ca­he­vanecha: Te jena yátiyare, te apina­na­hipuca nácani natiari­hi­que­neanahi te tajuhe peti, émanayare ema níchuha­que­neyare, ema apana manasiyare. ");
INSERT INTO ignNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tacutiquene, apina­na­hipuca ena esenana tiyuva­re­ca­na­hipuca. Éneri­chuvare ésuna esu níchuha­que­neyare. Esu apana sunasiyare. ");
INSERT INTO ignNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Te apina­na­hipuca ena ajairana te vámahi, éneya­rei­chuvare émana ema níchuha­que­neyare. Ema apana manasi­yareva —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eta nasamirahi ena máimitureana, nayase­recapa: —Tata Viáquenu, ¿távihapuca táitauchia­vayare eta juca pimeta­ra­pianahi? —nacahepa. Majicapapa éma: —Vahi ecueñamava eta távihapuca níteca­pi­hayare. Núti níteca­pau­chaheya te jácani iávihahi éti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ema Jesús máimitu­ca­va­cavare ena máimitureana vahi nacucai­na­jiruva eta nayuja­ra­sirana. Tímiya­na­vanaya, tayanapane vuíchaha najaca­pa­va­nehini eta nayasea­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eta máimicu­ti­chinahi, ánipa máichavacahi: —Matiarihi ema achane. Juézhi tayehe eta avasare. Éma, tájina vahi mapicau­chahini ema Viya. Nájinavare mapicauréna ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sutiari­hivare tayehe eta avasare esu ésuna esena suépenai­ma­quenehi. Suchavau­rui­ricahi ema juez taicha eta sumetau­chirahi ema sucatia­naruhi. ");
INSERT INTO ignNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Émasera ema juez vahi masuapahini eta sumetau­re­sirahi ésu. Váhisera sucai­na­ji­ru­va­hini. Tásiha, mapa­ne­re­que­ne­hapa maca­hepa: “Núti néchinava. Nájina nárataha napami­ca­nuhini. Váhivare tipami­ca­nuimahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ésusera esu suca esena, nuyacujipa eta suchavau­rui­ri­si­ranuhi. Níchari­nepuca eta suvara­ha­quenehi, apaesa vaipa sucuápechava suíteca” macahepa ema juez. ");
INSERT INTO ignNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Puiti, nuvaraha ecaicu­tia­ra­que­nehaicha eta juca nímitu­rapihi mayehe ema juez mapicau­ruiraha eta macatiu­chirahi esu suca esena táichavenehi eta suchavau­rui­ri­sirahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Ene macahehi ema Viya. Vahi máyere­re­jimahi eta macatiu­chi­ra­he­vaneya eti manere­ji­ruanahi, esama­ca­re­yarehi taicha eta emacai­na­ji­ru­vairahi eta eyuja­ra­si­rainahi tamutu sácheana, yátiana. Étaripa te táitecapa eta nuchavi­rayare nuti Manere­ji­ru­nuhi ema Viya, németeacahi natiari­hi­ya­reichaha nuchima­pa­que­neanaya ena vahi ticaina­ji­ru­vanahi eta nayuja­rasira, nacutihi esu suépenai­maquene eta sumacai­na­ji­ru­vairahi —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ema Jesús apanavare eta máimicu­ti­chinahi eta máimitu­re­sirahi, nayehe ena tímija­cha­vanahi tiúriana, tájina náichira­vainahi; náepuru­va­ca­hisera ena apamuriana achaneana. Tacahe, máichavacapa: ");
INSERT INTO ignNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Nímicu­ti­chinahe eta apana: Natiarihi ena apinana ajairana te Templo. Téneucha­vanahi. Ema émana achane, fariséohi éma. Ema apana, tisipe­ca­tu­ra­rahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ema fariseo, eta macasi­ña­va­vai­sirahi, témeña­havapa tayehe eta cuarto tacapi­ca­hu­quenehi te Templo. Ánipa macahehi eta mayuja­ra­sirahi: “Nuhasu­lu­pa­yachavi, Tata Dios, eta núrivahi te pimirahu. Vahi nácutihini ena apamuriana achaneana tiámera­hianahi, tisipe­ca­tu­ranahi, esena­ma­rea­na­hivare. Váhivare nácutihini ema mácatataji te juca nuchacaya. ");
INSERT INTO ignNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Píti pímatinuhi eta apiheirahi áyunanu te semanana. Níjara­ca­vivare eta plata nugana­reruasa. Te nugana­cha­hipuca eta dies peso, étanahi peso eta níjara­ca­vi­paraca. Téhesera cien pésohipuca eta nugana­reruhi, dies pésohivare eta níjaracavi. Vahi nuyava­nahini eta námava­huásana eta piyehe” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Émasera ema apana achane vahi máemeña­ha­vahini. Tiyere­hichucha eta máeneuchi­ravahi. Váhivare mapatsi­ca­vahini máeseni­cahini te anuma. Téhatu­pa­cha­va­hisera eta máeneuchi­ravahi. Ánipa macahehi: “Tata Dios, nucati­sa­mureva ichape eta nucape­ca­tu­rairahi piyehe. Pájapa­nu­nusera piperdo­nachanu eta nupeca­tu­rana” macahepa ena achane. ");
INSERT INTO ignNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tiuri, nutupiru numetacahe: Ema maca achane, eta machavi­raipahi te mapena, tijaca­pa­ca­réinehi me Viya taicha yátupihi eta máeneuchi­ravahi. Émasera ema fariseo vahi majaca­pa­ca­rehini. Taicha nácani ticasi­ña­va­vai­canahi, tímija­cha­vanahi ticuna­cha­carehi, éna tépuru­ca­rea­na­yarehi me Viya. Nácanisera ena tiyasea­canahi ema Viya eta májapa­nui­ra­vacaina, yátupihi tijaca­pa­ca­rea­na­yarehi mayehe —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tacahe, ena achaneana námava­ca­paipahi ena amuyana eta mayehe ema Jesús, navarairahi máemama­ha­ca­va­ca­yarehi éma. Énasera ena máimitureana vahi náisapahini, nacaichepaipa ena tiámanapahi ena amuyana. ");
INSERT INTO ignNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Émasera ema Jesús máichuha­va­caichucha ena amuyana. Tásiha, ena máimitureana máichavacapa: —Ésami­ri­cachucha ena amuyana, náitecaichaha eta nuyehe. Vahi ecucai­chepaica éna. Taicha ena nuchanerana nuti Cristo nacuti­yarehi ena nani amuyana eta nasuapa­jiraiva éna. ");
INSERT INTO ignNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nutupiruva numetacahe: Nácani vahi nácutihi ena amuyana eta nasuapa­jiraiva, vahi nuchane­ra­naimahi éna —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Matiarihi ema achane. Náiyaca­ra­ripahi ena achaneana. Témeña­havapa mayehe ema Jesús, mayase­recapa: —Tata maestro, piti piúriquene. ¿Tájaha­pucaini eta níchara­cavaini eta nítuji­si­ravaina me Viya máichecua­ra­qui­ré­nahini eta nítaresira? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ema Jesús majicapapa: —¿Tájaha tacayema pímija­rechanu “Piti piúriquene”? Mararihi ema Viya. Jéhevare éma, tétavi­cavahi eta máurivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Téhesera te pivara­hapuca pecha eta apana vítaresira, pisuapa­yarehi eta mavanai­ripiana ema Viya. Píti pímatipa eta júcana: “Vahi picuveha esu esena apayena. Vahi picuca­pareca. Vahi picuamereca. Nacuija pépiyae­que­neruina. Pémunacaya ena ticachi­cha­vianahi” —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tacahe, ema achane majicapapa: —Tamutu nusuapahi eta juca vanairipiana eta námape­ruvahi, puíticha juca ajaira­nuirapa —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tásiha, ema Jesús máichavarepa: —Jucari­hi­cha­hasera eta pítaucha­que­neyare. Píjara­recaya tamutu eta pímaha­queneana. Tásiha, píjara­ca­vacaya ena páureana. Jéhevare éta, pijaca­payare eta pímaha­que­neyare te anuma, táitsivayare. Te tamutupa eta juca, píteca­vanepa péhicanu —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Te masamapa ema achane eta juca macaye­ma­quenehi ema Jesús, ichape­rinehi eta mapane­re­re­sirahi, taicha mavayuchahi eta marricovahi. Macatie­que­ne­ha­rinehi tamutu. Tiyanapa tipane­re­re­capaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eta máimairahi ema Jesús eta mapane­re­re­sirahi, máichavarepa: —Yátupi­quenehi máitujihi eta náijara­si­ra­vai­nahini eta náehisi­ra­nui­nahini ena rícoana eta nasiapi­rai­nahini te anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Esama­nuchaha. Eta juca tímicu­ti­ji­ri­cavahi eta vipera camello, máitujihi tánucu­hahini te támicuejehe eta parirapa. Ene nacahehi ena ­ rícoana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tacahe, ena tisama­ra­ra­canahi, ánipa tacahehi eta nayase­re­sirahi: —¡Tétavi­cavahi eta tamáitu­ji­ca­ca­revahi! ¡Nájina títuji­ca­vaimahi náuchucu­hahini! ");
INSERT INTO ignNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ema Jesús majica­pa­vacapa: —Nájina émanaina achane émaji­vaimahi ticuchu­cuhava. Macarichu ema Viya marataha ticuchu­cuhahe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Émaripa ema Pedro máichavarepa: —Vítisera, Tata, vinaquicahi tamutu eta vicaye­he­queneana, vivarairahi véhicavihi. ");
INSERT INTO ignNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ema Jesús majica­pa­varepa: —Nutupiru numetacahe: Namutu nácani nanaquicahi eta napena, najuni­ji­ca­hivare ena ticachichana, ena napara­pe­naveana, nayena­napuca, nachicha­na­vea­napuca, táichave­ne­yarehi eta náehisi­ra­nuyare; ");
INSERT INTO ignNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jarari­hiyare eta táitsivayare te juca apaquehe eta náimaha­que­neyare. Narari­hi­ya­revare ena achaneana téchapa­ji­ri­ca­na­yareva. Tásiha, taveti­jinapa te náitecapapa te apana náitare­siraya, máichecua­ra­qui­renapa eta náurica­ca­revaya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ema Jesús máiputsia­mu­rihapa mámamu­rihapa ena dócequeneana máimitureana. Tásiha, máichavacapa: —Ímaha puiti, viyanainapa vicaiju­hé­napaipa te Jerusalén. Ánaqui táitauchia­vayare tamutu eta nájucu­na­cha­que­neanahi ena profetanaini eta níchara­ra­ca­va­yarehi núti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ánaqui nucaija­ra­re­ca­siyare núti nayehe ena apava­sa­queneana romanoana. Énainapa ticaeca­hi­ji­ri­ca­nua­nayare, ticaete­ma­ji­ri­ca­nuanaya, tiátutu­qui­cha­nua­na­yareva. ");
INSERT INTO ignNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Téstaca­nua­na­yareva. Tásiha, ticapa­ca­nua­nainapa. Tásihasera te mapana­que­nénapa sache, néchepu­cainapa te nécari —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Énasera ena máimitureana vahi nacaicu­tia­rahini eta juca mameta­si­ra­vacahi. Váhivare náimatie­que­ne­hahini tájahapuca eta máechaji­sihahi taicha vahi náemetea­cahini énema­hi­nahíni náichahini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tacahe, te tiánehipa títecapa ema Jesús tayehe eta avasare Jericó. Matiarihi ema achane púchuqui, téjacahi te achene­chacaya tasiapa­racuhi eta avasare. Tiyase­se­recahi eta limosna. ");
INSERT INTO ignNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te masama­vacapa ena camuri­queneana achaneana tiánucu­ha­napaipa, macaya­se­se­rerupa ema púchuqui tájaha­hipuca eta téchacarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nameta­ca­pasera eta émairahi tiánucu­ha­yarehi ema Jesús Nazareno. ");
INSERT INTO ignNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tacahe, tipiaracapa ema achane púchuqui: —¡Tátachicha Jesús! ¡Pítique­neripa yátupi­que­névihi Cristo! ¡Picata­ji­ca­nupaini! ¡Pájapanunu! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ena achaneana tínapu­mi­ráu­cha­napahi ema Jesús navarahapa nacama­ti­na­ca­ya­rehini. Émasera tipiara­re­caichucha: —¡Tátachicha Jesús! ¡Pítique­neripa yátupi­que­névihi Cristo! ¡Picata­ji­ca­nupaini! ¡Pájapa­nunuini! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tacahe, ema Jesús te macanarapa, tícheca­numapa. Macava­nai­ripipa náepana ema púchuqui. Te nacaitecapa, mayase­recapa: ");
INSERT INTO ignNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tájaha picamunu nuyehe? Ema púchuqui majica­pa­varepa: —Tátachicha, nuvaraha picaimai­ri­ri­ca­nupaini —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ema Jesús máichapa: —Tiuri, nuchicha. Táichavenehi eta picasi­ñai­ranuhi, pinaracapa puiti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jéhesa­reinehi, tíjahú­chavapa timairirica ema púchuqui. Tásiha, tiyanapa máehica ema Jesús tiúrisa­mu­repaipa. Macuna­cha­pai­pavare ema Viya. Énapa ena achaneana tímara­ra­canahi eta manara­sirahi, ichape­rinehi eta nacuna­chirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Tacahe, eta máiteca­piraipa ema Jesús te tajuhe eta avasare Jericó, matiarihi ema achane rico, ticaijare Zaqueo. Nacapi­tarahi ena cóbrare­ca­rahiana eta impuesto. ");
INSERT INTO ignNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Te masamai­ri­ricapa eta émairahi ema Jesús títeca­papahi, mavarahapa máimati­yarehi. Étasera eta máichipi­chuvahi éma, vahi márata­hahini máimahahini ema Jesús te namuri ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tásiha, tijunapapa eta te mayani­ha­ya­repahi ema Jesús. Tiápanapa te yucuqui, máimara­ra­ca­sa­réipahi ema mavara­ha­quenehi máimati. ");
INSERT INTO ignNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tacahe, te macapecupa ema Jesús eta yucuqui mávihahi ema Zaqueo, máesenicapa ema Jesús te anuquehe. Tásiha, máichapa: —Zaqueo. Yare, piúcupaica, taicha puiti nuvarahahi nunasi­nu­mayare te pipena —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tacahe, ema Zaqueo titátájipa tiúcupaicapa. Tiúrisa­mu­réinehi eta majaca­pirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eta náimairahi ena achaneana eta juca, téchaji­canapa mayehe ema Jesús. Náichapa: —Émamesapa máiteca­pau­cha­yarehi ema maca ticape­ca­tu­ra­hi­tátáji —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Te téjacanapa te tajuhe, témeña­havapa ema Zaqueo te mamirahu ema Jesús. Tásiha, macahepa: —Pímaha, Tata Náquenu. Núti néneuchavapa me Viya. Puiti níjara­cayare ena páureana ticuti­mu­riacaca eta nímaha­queneana. Nímicha­va­yareva te natiari­hipuca ena nucaete­ma­que­neanahi, cuátrohé­na­pasera eta táitsivayare eta nímicha­va­queneya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Tásiha, ema Jesús majicapa: —Nímahapa puiti eta yátupirahi eta péneuchi­ravahi eta pipeca­turana, taicha pivarahahi pímicha­vayare eta plata picaete­ma­re­ruanahi. Tásiha puiti, pijaca­pa­carepa me Viya. Vaipa pémitie­que­néimahi. Taicha píti picutipa ema viáchucaini Abraham eta macasi­ña­vairahi mayehe ema Viya. Píti nuchane­ravipa, picutipa ena apamuriana nucuru­ji­ruanahi. Taicha éta tímite­canuhi nuti Manere­ji­ru­nuhi ema Viya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tacahe, ena achaneana, eta náimairahi eta mánehi­raripa eta Jerusalén, náimija­chaipahi étapa tímiya­nayare éma, eta máimere­si­ra­vayare eta marreyva­yarehi. Tacahe, ema Jesús máimatia­caripa eta napane­re­ruanahi. Tásiha, máimitu­ca­vacapa eta apamuri máimicu­ti­chinapa apaesa nácaicutiara eta tayere­vaichaha eta marreyva­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Máichavacapa: —Matiarihihi ema achane. Ichape eta mapica­ca­revahi. Tiyana­yarehi te apana avasare tayere­hiquene. Eta tímiya­na­yarehi ánaqui máepani­ha­yarehi eta mávacu­re­yarehi eta marreyva­yarehi tayehe eta mávasa. Eta machavi­ra­yarepa, téjaca­yarepa éma. ");
INSERT INTO ignNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te tiyana­yarépa éma, máichuha­numapa ena diésqueneana machanerana. Máijara­ca­vacapa étapevaca eta maplatane tasiva­cha­quenehi. Tásiha, máichavacapa: “Ecaju­ru­cayare eta juca nuplatane. Te nuchava, táimecavaipa eta tachicha­nayare”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tacahe, tiyanapa ema rey-yarehi tayehe eta macaiju­he­yarehi. Te máequene­pasera, tisema­mu­rianapa ena majaneanana. Ánipa nacahe: “Vahi vávaraha émaina viyehéna rey ema maca” nacahepa. Náimiva­ne­recapa eta comisión, nayase­se­re­cayare vahi nacuijaraca eta mávacuréna. ");
INSERT INTO ignNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ticame­sa­vau­chu­chasera majaca­paichucha eta mávacurehi. Te tichavapa te mávasa, téjacapa émapa reyhi. Tásiha, máichuha­vacapa ena machanerana máijara­ruanahi eta maplatane. Mayase­recapa te tímeca­vai­pa­hipuca eta tachichanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tiyanapa ema émana tímere­cavapa. Máichapa: “Tata náquenu, eta piplatane píjara­runuhi tímecavaipa eta tachichanahi. Diésripa eta tajuru­sirahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ema rey majicapapa: “Tiuri, nuchicha. Tájina táichava. Tétavicava eta piúriva. Puiti vahi támapu­ru­jimahi eta piúrivahi tayehe eta juca ánichi­cha­quenehi níjara­ruvihi. Puiti níjara­ca­viyare pitupa­rahaya nujupa­haviya. Píti táquenuya eta diésquene avasareana”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tímere­ca­va­varepa ema apana mamusura. Máichapa: “Tata náquenu, eta píjara­runuhi piplatane, tímeca­vaipahi cinco eta tajuru­sirahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Majica­pa­varepa: “Tiuri, nuchicha. Tájina táichava. Tétavicava eta piúriva. Puiti nunaca­viyare aquenu­caviya tayehe eta cíncoqueneana avasareana”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tímere­ca­vavare ema apana mamusura. Máichapa: “Tata náquenu, júcahi eta piplatane. Vahi nucaju­ru­cahini. Núnacaichucha, nítipuichahi te pañuelo. ");
INSERT INTO ignNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Taicha nupicahi nácaete­hahini, machu pícuñacanu. Pétáviuchahi píti eta pivaina­rajiva, taicha píti pivehahi eta némata­ne­va­cha­yaréni”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tacahe, ema rey máichapa ema machanera: “Eta juca péchaji­ri­ruvahi, éta tímicae­che­ra­chavihi eta pépiya­hi­raivahi. Piplujuvahi eta tíchavihi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Te pímati­nu­hipuca eta nuvaina­ra­jivahi, eta nuvehairaya eta pémata­nevacha, étapa eta nícuña­si­ra­viyare te picami­tia­capuca, váhiyapa pinacapaini te banco eta nuplatane. Étainahini tajuru­si­hahini apaesai­nahini nímaeque­né­hahini puiti”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tásiha, máichavacapa ena apamuriana: “Everejica ema maca eta nuplatane. Íjaraca ema ticaju­rucahi eta diéspequene”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Éna nacahe­varepa: “Tata viáquenu, tímeca­vai­pa­hinéni diéspepahi eta tajuru­sirahi”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ema rey majica­pa­varepa: “Tiuri numeta­caheya: Nácani ticaju­ru­canahi camuri, nujane­chi­nayare eta apana. Nácanisera tájina­quenehi nacaju­ru­ré­nahini, nuvere­ji­cayare eta náijara­ca­sinihi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Énasera ena ticatia­na­ca­nuanahi éna vahi najaca­pa­nuhini eta nurreyvahi, iámina­nuyare ani te numirahu. Ecapa­pa­ji­cavaca éna”. ");
INSERT INTO ignNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tacahe, te tamutupa eta juca máimitu­re­sirahi, ema Jesús tímiya­na­va­varepa tipaica. Macaijuhepa eta te Jerusalén. Tínapucapa ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te apanapa semana, tiyana­na­varepa. Te tiánehipa eta avasa­re­chichana Betfagé étapa eta Betania, tacana­rai­pa­hivare eta masihi ticaijare Olivoquiji, tícheca­nu­manapa. Mavanecapa ema Jesús ena apinana máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Máichavacapa: —Eyanayare eta te jena avasa­rechicha Betfagé. Te íteca­pa­yarepa, ímahayare eta burrico ticaitihahi. Eta jena sárare mávuéque­héchaha, nájinaichaha ticape­rainahi. Eveja­pua­cayare, iámina­nuyare eta ani. ");
INSERT INTO ignNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te natiari­hi­napuca náeñama, emeta­cayare eta nucamu­nuirahi núti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tacahe, tiyananapa ena vanairu­canahi. Jéhesa­réinehi étapaichuhi eta mameta­rapihi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te naveja­pua­caripa eta burrico, ena ticayeheana nayase­recapa: —¿Táviha iámihayare eta viyehe burrico? ");
INSERT INTO ignNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Éna najicapapa: —Ema maena Viáquenu macamunuhi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tacahe, náisapapa eta námiraya eta burrico. Te náiteca­pauchapa ema Jesús, náepaca­mae­quechapa eta náepacuhana. Tásiha, ticaperapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te náimahapa ena achaneana tiúchuji­ca­paipahi ema Jesús, náimati­vanepa. Tiyananapa nácapahi éma. Tépaca­pai­ri­ca­napaipa te mamirahu eta náepacuhana te mayani­ha­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eta napaisirahi, témiri­ca­napaipa te tachausi eta cerro ticaijare Olivoquiji. Namutu ena máimitureana téhicanahi ema Jesús tipiara­ca­napaipa eta náurisa­mu­revahi taicha eta náimaha­que­neanahi tiárami­careana máichaque­neanahi éma. Ichape eta nacuna­chirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ánipa nacahehi eta napiara­si­rapahi: —Yare, Tata, ¡Piti réyquene, vanairu­ca­que­névihi me Viya! ¡Asulupaya! ¡Puiti, te anuma vicuti­cacahi eta viúrisa­mu­revahi víti te eta juca apaquehe! Tétávicava eta vicunachira ema Viya eta macata­ji­si­ra­havihi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tacahe, eta nasami­rapahi ena fariséoana natiari­hi­que­neanahi eta napiara­si­rapahi ena achaneana, náechajicapa ema Jesús: —Tata maestro, picama­ti­na­ca­vacaichu ena nani pímitureana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ema Jesús majica­pa­vacapa: —Tiuri, numetacahe puiti. Te namati­napuca ena nani, táitsivasera étainapa tipiaracaya eta máriana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tacahe, títeca­panapa te tápusi eta cerro Olivoquiji. Ticaecherapa eta Jerusalén. Eta máimairahi ema Jesús eta avasare, tíyahapa táicha. ");
INSERT INTO ignNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Macahepa eta máiyairahi: —Páurevisami piti návasasami Jerusalén. Te nácaicu­tiaraini apaesa­chi­chainaini ena pichicha­na­veanahi eta nuvarairahi nucuchu­cu­havaca núti. Puiti juca sache nutiari­hi­raripa ani piyehe, náurihainehi nácama­pu­ra­vahini eta náurica­ca­re­vahini. ");
INSERT INTO ignNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Taicha járaja­payare eta sácheyare táetaviu­chavaya eta nacata­ji­vairaya ena pichicha­naveana náicha ena piánaranaya tichaya­ca­via­nayare. Téhavia­nainapa, tájinapa piviya­vaimahi picatiu­chia­vaimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Témesta­pai­ca­via­nainapa te apaquehe. Nacapa­pa­ji­ca­va­cainapa ena pichicha­naveana. Tájina nacaema­cha­que­némahi eta peti. Tamutuyare náquipapaica. Eta piviurevaya, eta juca pimaja­ca­pi­ranuhi eta néjirai­ravihi nuti mavane­runuhi ema Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Tacahe, te apanapa sache, tiyanapa ema Jesús. Tisiapahi te Templo. Máimaha­rinehi ena achaneana tíjara­re­canahi eta sárareana, cáyureana. Tásiha, tisemapa. Eta macuchu­chu­ji­si­ra­vacahi, máichavacapa: —Ema Tata Nucaiyaquene, ani macahehi eta máechaji­ri­ruvahi te Sagrada Escritura: “Eta nupena tacarichu táicuchihi eta nayuja­ra­si­rareya ena achaneana” macahepa. Étisera eti tiámerahiana ecasia­pavapa eta te juca. Emaepe­ra­jicapa eta tacapi­ca­huirahi. ¡Eyana iúchuca­tataji! —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eta manasi­que­nerahi ema Jesús, tamutuhi sácheana tímitureca tayehe eta Templo. Énasera ena tuparai­ru­cana énapa ena escribá­noana, napane­re­chaipahi eta navarairahi nacapaca ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Váhisera napatsi­ca­vahini taicha natiarihi ena camuri­queneana achaneana tisama­ra­ra­canahi eta máimitu­rapiana éma. Váhivare náisapaimahi náichahini ena ticatia­na­canahi. ");
INSERT INTO ignNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Étana sache tímitu­re­caichaha ema Jesús tayehe eta Templo eta máechaji­riruva ema Viya. Títeca­pa­ra­canapa ena tuparai­rucana, énapa ena aquenu­ca­rahana, énapa ena escribánoana. ");
INSERT INTO ignNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nayase­recapa ema Jesús: —Píti, vahi vitupa­ra­ru­vi­nahini víti eta píchirahi eta júcana. ¿Nájahasica tivane­cavihi? ¿Nájaha titupa­ra­cavihi picha eta juca píchaqueneana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ema Jesús majica­pa­vacapa: —Núti apanavare nuvaraha nuyase­recahe. Ejica­pa­nu­ya­resera. ");
INSERT INTO ignNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nájahapuca tivanecahi ema Juan eta máitesirahi eta máicacha­si­ri­sirahi? ¿Émapuca ema Viya tivanecahi, émaji­va­hipuca eta máitesirahi? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Váhisera náiturue­que­ne­hahini eta najica­pi­ra­yarehi. Tiácapae­ma­ji­ri­ca­canapa. Ánipa nacahe eta náechaji­ri­ru­vanahi: —¿Tájahasica vicaye­mayare eta vijica­pi­rayare ema maca? Te vémuna­hacava vicha: “Mavaneruhi ema Viya”, éma macahé­na­papuca: “Tásiha, ¿váhiyapa esuapahini éma?” ");
INSERT INTO ignNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Téhesera vácahepuca: “Émaji­vaichucha eta máitesirahi”, ticauya­ya­careipa nacapa­cahavi ena achaneana te márijahiana, taicha náechahi éna émairahi ema Viya tivanecahi ema Juan —náechaji­ri­cacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tacahe, ánipa nacahehi eta najica­pirahi ema Jesús: —Vahi vecha víti —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ema Jesús máichavarepa: —Éneri­chuvare núti, vahi numeta­ca­hémahi nájahapuca ema titupa­ra­canuhi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tacahe, ema Jesús tépana­va­varepa máimitu­cavaca ena achaneana. Ánipa tacahehi eta máimitu­rapiana: —Nuvaraha nímicu­ti­chi­naheya, tatiarihi eta isaniti amairiha úvaquiji, masucurehi ema émana achane. Tiyana­ya­re­hisera ema ticayehe, tipairi­ri­ca­yarehi te apana avasare. Tacahe, matupa­ra­ca­vacapa ena tíreha­na­yarehi te áñoana eta mayehe uva. Partido­yarepa eta majuni­ji­si­ra­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tacahe, te títecapapa eta caje tayairahi eta uva, máimiva­ne­recapa ema mamusura mayasea­pa­na­va­ca­yarehi ena pártirá­rioanahi eta tatuca­cha­que­ne­yarehi éma. Énasera ena pártirá­rioanahi, tájina náijara­cahini. Tisemau­cha­va­na­richucha, náehapa ema vanairu­cainihi. ");
INSERT INTO ignNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tásiha, ema ticayehe máevata­ca­varepa ema apanavare mamusura, mayasea­pa­na­va­ca­yarehi éna. Éneri­chu­va­resera náumeha­varepa ema vanairu­cainihi, náehavarepa. Tájina náijara­cahini. ");
INSERT INTO ignNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tásiha, ema ticayehe vahi macaina­ji­ru­vahini. Máevata­ca­varepa ema apanavare mamusura. Éneri­chuvare náehavarepa ema vanairu­cainihi. Najarachapa, náquijicapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tacahe, ema ticayehe tipane­re­re­caripa: “¿Tájahasica níchara­ca­vayare?” macahepa. “Nuvane­capuca mayana émaja­ca­ruvaina ema nuchicha némuna­ru­quenehi. Tatiarihi te émaina­papuca napicaucha te náimahapa”. ");
INSERT INTO ignNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tacahe, te náimahapa ema machicha, naveti­jichucha eta nasemirahi. Tímitu­ji­ri­ca­ca­naripa. Ánipa nacahe: “Émaina­papuca ticaye­heyare ema maca. Yare, vicapaca, apaesa tánasipa tamutu vítinapa vicayehe”. ");
INSERT INTO ignNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tacahe, nacara­tacapa éma, nacuchucapa eta tayehe eta isaniti, nacapacapa. Puiti nuyase­re­ca­heyare: ¿Tájahapuca máichara­ca­vayare ema achane ticayehe eta úvaquiji? Jéhesare, vaipa macaye­hehini paciencia. ");
INSERT INTO ignNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Títeca­va­nénapa macapa­pa­na­va­ca­yarepa ena pártirá­rioanahi máurira­hanahi. Tásiha, máijara­cai­na­varepa eta úvaquiji ena apamuriana pártirá­rioa­na­yareva —macahepa ema Jesús. Tacahe, ena tisama­ra­ra­canahi, ánipa nacahehi: —Viti vicata­ji­cacare, vahi vácutihini ena nani máurirahana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ema Jesús máeseni­mu­ri­ha­vacapa. Tásiha, máichavacapa: —Jéhepuca, németea­casera vuíchaha ácaicu­tia­rahini eta tacaye­ma­quenehi eta Sagrada Escritura. Éta, áni tacahehi: “Ena tépiya­re­ca­rahiana eta Templo, tasapiha náepuruhi eta mari táicuchihi tatumea­rayare eta peti, taicha vahi náimatihini. Émasera ema Viya macaite­capapa eta táicuchihi eta tatupa­rahahi. Tacapi­ca­hu­quenehi puiti” tacahehi eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Puiti, núti nucutihi eta ichape mari náepuru­quenehi. Eti epuru­nuanahi, iáquipai­ca­vayare évetu­tu­ji­cayare. Tichima­ra­ca­heyare eta muraca ecuñaraqui taicha eta emava­ra­hairahi éhicanu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ena tuparai­ru­cana navarahapa náijahú­cha­ya­rehini nacarataca ema Jesús, taicha tímatia­ca­vanapa éna eta énairahi tayuna­cavaca eta máechaji­ri­ruvana ema Jesús. Váhisera napatsi­ca­vahini taicha návami­rahuhi ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tacahe, náimiva­ne­recapa ena apamuriana ajairana tépiya­ca­va­na­ya­repahi tiúriana te mamirahu, navarairahi natanu­cayare eta tímica­viu­cha­yarehi. Énayarepa timetau­cha­na­varehi mayehe ema aquenucahi prefecto Poncio Pilato. ");
INSERT INTO ignNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tacahe, nayase­recapa éma, ánipa nacahe: —Tata maestro, vímatihi eta tatupi­ru­vairahi tiuri eta juca pímitu­ra­pianahi. Nájinavare pinere­ji­rui­nahini ena achaneana, taicha pivarahahi náehicahini namutu eta táurinaquene achene ticaijuhe me Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Vivara­ha­hisera viyase­re­ca­viyare: ¿Táurica­hipuca vivachacha eta viyasehana impuesto mayehe ema Presidente Emperador romano? Taicha víti, machane­ra­havihi ema Viya, ¿masi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ema Jesús máimatia­ca­vacapa eta tamauri­vapahi eta napane­reruana. Tacahe, máichavacapa: —¿Tájaha tacayema evaraha ímiaqui­paicanu? ");
INSERT INTO ignNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nímahaseji, iáminanu étapena eta reale. Éna náijaracapa. Tásiha, ema máichavacapa: —¿Nájaha ticaijare eta juca? ¿Nájahavare ticava­simahi eta juca mirare eta te juca reale? —máichavacapa. Éna najicapapa: —Mayehe ema Presidente Emperador. ");
INSERT INTO ignNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tacahe, éma máichavacapa: —Tiuri. Táuricahi íjaraca ema Presidente Emperador eta juca mayehe­richuhi éma. Tásiha, íjara­cavare ema Viya eta mayehe­ri­chu­hivare éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Váhique­nesera nárata­hahini náimiaqui­pai­cahini eta nayase­re­sirahi te namirahu ena achaneana. Táitsivahi ichape eta náramirahi eta táurivahi eta majica­pi­ra­vacahi. Timati­nanapa ­ tésami­ri­ca­vanapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nacahe­pai­pavare ena apamuriana achaneana. Saducéoana. Ena nani saducéoana, apana eta náimitu­rapiana; váhi nasuapa eta náechepu­si­rayare ena náepena­queneana. Éna natanucahi eta táetsera­ru­vayahi. Tacahe, nayase­recapa ema Jesús: ");
INSERT INTO ignNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tata maestro, ema víyarahaini Moisés manaquicahi eta ajureca máechaji­ri­ruvahi eta viyehe: “Te máepenae­que­ne­ha­hipuca ema achane esu mayena, tásiha, nájina­hipuca manaquie­que­ne­ru­vai­nahini machichai­nahini; te matiari­hi­hipuca mácani maparapehi, mavehayare esu machine­naequene, apaesa émainapuca macachicha eta suyehe, máitsivainahi ema maparapeni”. ");
INSERT INTO ignNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tacutiquene te natiari­hipuca ena siétequeneana ticapa­ra­pe­ji­ri­cacana, te títauchavapa ema náechavimuri, máepenae­que­ne­ha­pasera esu mayena. Nájinahi machichai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tacahe, ema maparape máitauchavare esu machinena. Éneri­chu­va­resera máepenae­que­ne­havare, nájinavare machichai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ema émana maparape máitauchavare ésu. Éneri­chuvare máepenae­que­ne­havare. Namutu ena siétequeneana navehahi ésu, tásihasera náepenae­que­ne­hapahi, nájina émanai­nahini mácachi­chahini eta suyehe. ");
INSERT INTO ignNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te táequenepa, tépenapa esu esenaini. ");
INSERT INTO ignNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tacahe puiti, te jéhesa­repuca tichava­nayare títarecana te táequenénapa eta náepenirahi ena nani, ¿nájahapuca ena siétequeneana éma yátupi­quenehi suímaquenehi esu esena? Taicha ena siétequeneana namutuhi suímanarihi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tacahe, ema Jesús majica­pa­vacapa: —Ena ajairana te juca apaquehe natupa­ra­ca­si­vaichuhi títaucha­va­nayare suyehe esu esena. ");
INSERT INTO ignNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ánaquisera te apana náitaresira, nácani ticatu­pa­ra­ha­nayare eta nasiapi­rayare te anuma te náechepucapa, vaipa nácamu­nuimahi esu esena. Énaripa ena esenana, vaipa nácamu­nuimahi ­ ema ajaira. ");
INSERT INTO ignNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Taicha vaipa tiápecha­vaimahi tépenana. Nacutinapa ena ángeleana eta namaepe­na­ca­cairahi. Yátupinapa machicha­na­vea­nainapa ema Viya, taicha éma ticaeche­pu­ca­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Émaripa ema víyarahaini Moisés timeta­cahavi eta májurehi eta yátupirahi eta vahi tánasi tépena eta náchanevana ena náepena­queneana. Te máimahapa ema Moisés eta yucuqui timurujihi, eta macame­ta­ca­siyahi mayehe ema Viya eta émarichuhi ema macasi­ña­quenehi ema Abraham, ema Isaac, émapa ema Jacobo. ");
INSERT INTO ignNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Taicha ema Viya, ema téchahi eta náitare­sirana ena téhicanahi, tayanapane tépena­naripa. Namutu ena, tímiya­na­va­richucha títareca eta náchanevana te mamirahu éma —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tacahe, ena escribánoana, ena natiari­hi­que­neanahi náichapa ema Jesús: —Tétupicava eta juca péchaji­riruva, tata maestro —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Váipasera nacaemu­ña­vahini nápecha­vahini nayasereca. ");
INSERT INTO ignNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ema Jesús máichava­ca­varepa: —Éti ecahehi eta échaji­ri­ruvahi: “Tiúchucayare ema Cristo, mámarie­que­neyare ema víyarahaini rey David” ecahehi. ");
INSERT INTO ignNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yátupihi ema Cristo achane­quenehi eta máimahi taicha mámarie­que­nenihi ema víyarahaini David. Nuvara­hasera epane­rechaya eta juca máechaji­ri­ruvahi ema David te májurehi Salmo, ani macahehi: ");
INSERT INTO ignNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Ema Viya máichapa ema Tata Náquenu Cristo: Yare, péjaca te nuvaure, eta picucha­pi­hayare eta nucaepu­yu­siraya te pimirahu ena ticatia­na­ca­vianahi” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ema David, eta máimija­re­chirahi ema Cristo: “Tata Náquenu”, ¿tájahapuca eta macaye­ma­quenehi? Nutupiruva numetacahe: ema Cristo yátupi­quenehi Viya éma. ¿Tájaha ­ íchahi éti? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Namutu ena achaneana nasama­ra­racahi ema Jesús eta máechaji­si­ra­vacahi ena máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ánipa macahehi eta nayehe: —Échapa­vayare éti, machu éhica eta nayehe­repiana ena escribánoana. Navara­havare ticapi­ca­hua­na­yarehi eta náechaji­siraya ena achaneana te jácani nácapa­ji­si­hapahi éna. Tacutiquene tinere­jiu­ru­cavana eta táurina­queneana téjasi­ha­careana te tiyanana te viúruji­si­ra­revana. Étaripa te nanisirana, ticaeja­ca­va­navare te jácani távihahi eta tiúrini­sipana tinicacare. ");
INSERT INTO ignNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tacutiquene navere­ji­cavare eta nacaye­he­queneana ena tépenaimana, nájina najapa­nu­quenéna. Tásiha, tépiya­ca­vanapa religió­soanahi, tiúpiemana eta nayuja­rasira, namava­rairahi tácaeche­rahini eta náichira eta tamauri­queneana. Énasera tiápaju­ca­vanahi eta nacaicu­ñairaya muraca. ");
INSERT INTO ignNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ema Jesús máimara­racahi ena rícoana eta nanaqui­sirava eta plata tayehe eta chapama nanaqui­si­rareva eta námavahuana mayehe ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Éneri­chuvare máimahavare tinaquicava esu ésuna esena suépenai­maquene. Páurequenehi ésu. Sunaqui­ca­hisera eta apipe­chichahi eta suplatane. ");
INSERT INTO ignNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tacahe, ema Jesús macahepa: —Ímaha esu suca esena páurechicha. Ácuneucha eta suémuna­sirahi ema Viya. Jéhesare ésu, tímepa­návahi eta sunaquiruva, sucachu­ri­ca­vacahi namutu ena apamuriana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Taicha namutu éna tacarichu nanaquicahi eta náemacha­rajiana naplataneana. Ésusera esu suca páurehinéni, sunaqui­ca­hisera tamutu eta sucaye­he­quenehi. Suítahi eta sunica­va­cha­ya­rehini —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Natiarihihi ena téchaji­si­hanahi eta Templo. Náechaji­si­ha­hivare eta táurina­queneana tayere­ruvana nanaqui­ruanahi ena achaneana, étapa eta táurina­va­vacahi eta máriana tayeheanahi. Ichape­murihi eta táejeravahi te nacaema­ta­nénapa. Tacahe, ema Jesús máichavacapa: ");
INSERT INTO ignNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Járaja­payare eta sáchevayare ticaqui­pai­ca­sinapa tamutu eta juca Témplosami. Téjane­re­pai­cainapa tamutu eta juca táurina­que­neanahi ímaha­queneana puiti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tacahe, nayase­recapa ema Jesús. Náichapa: —Tata Maestro, ¿tájamu­hu­ya­re­hipuca eta náimiaqui­pai­si­rayare eta Témplosami? ¿Jarari­hi­ya­repuca eta ecutia­ra­reyare eta apana péchaji­si­ha­queneana? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ema Jesús máichavacapa: —Ecuneu­chavaicha yátupina, machu navayuacahe, taicha náraja­payare ena tépiya­ca­va­na­ya­repahi tímiva­si­cha­va­na­ya­repahi nuyehe. “Nútiripa Cristo” nacahénapa. Ena apamuriana nacahénapa: “Táiteca­pa­quenepa puiti eta sache”. Váhisera ecusua­pavaca, váhivare ecuehi­cavaca. ");
INSERT INTO ignNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Étaripa te esamai­ri­ri­capuca eta guerra, revolu­ciónpuca, váhivare ecuarameca. Taicha eta táinapua­ra­quia­na­yarehi eta júcana ecutia­ra­rea­nayare, vuíchahasera étaimahi eta táichecuiraya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ánivare macahe: —Téhaca­ca­yareva eta ichape­queneana avasareana. Ticana­ra­ji­ri­ca­ca­nainapa eta apamuriana. ");
INSERT INTO ignNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tatiari­hi­yareva eta ichapeyare tayamu­ri­sirana eta apaquehe. Te avasareana tatiari­hiyare eta ecuha­mu­hu­yareva, jumare­mu­hu­yareva. Te anuma tímere­ca­vai­na­varepa eta ichape ecutia­rareya, tiámayare eta ecuña­ra­quiyare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tativa­nu­ma­ya­resera tipana­ji­ri­ca­hea­nayare éti, táichave­nénahi eta éhisi­ranuhi núti. Ticara­ta­ca­hea­nayare, tiámahea­nayare te náuruji­si­ra­revana, ecaya­se­re­hinapa nayehe ena juéseana. Ecaeva­tainapa te cárcel. Tásiha, etiari­hiyare eti tiámaheanaya te namirahu ena aquenucana, téhevare te namirahu ena Presidenteana gobiernoanahi, ecaviu­re­vayare táichavenehi eta éhisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","14","Étume­cha­vasera. Te námahepa te ecaya­se­re­hiyaya, ecama­pu­ra­vainapa échaji­sia­nuyare. Váhi ecueñamava eta ecaye­mayare ecatiu­chi­ravaya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nímaha­héinepa núti, níjara­ca­heyare eta ítusi­rayare ecatiuchava. Nájina ácutimahi eta ítupa­ji­jia­si­ravaya. Ichape ecachu­ria­cayare ena iánaranaya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Etiari­hiyare éti énaja­ca­ru­vainapa ena ticachi­chaheana tíjara­re­ca­heanaya énaripa nácani epara­pea­napuca, énaja­ca­ru­va­yareva tíjara­re­caheana, énaya­re­pai­chupuca ena ejaneanana, ítuna­ca­sareana. Enere­ji­ca­vainapa eti nacapa­ruanaya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Namutu ena acha neana ticatia­na­ca­hea­nayare táichave­nénahi eta éhisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tayana­pa­nesera nacapa­ca­hepuca, nímaha­héi­ne­pasera núti. Vahi émitie­que­némahi. Étaripa eta echuti­macana, tájinavare témitie­que­némahi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Téhesera ecamichahi tamutu, ímiya­navahi eta éhisi­ranuhi, núti níjara­ca­heyare eta ítare­siraya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Te ímahapa ena suntaruana nachayacapa eta Jerusalén, étana­que­ne­yarehi ejercito eta náichape­mu­rivaya, étainapa ícutiaraya eta táitavi­rayare eta avasare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tásiha, te ímahapa eta juca, táuricapa etátá­jinapa ejuna, eti etiari­hi­que­neanahi te Judea. Ecaiju­heyare eta te cérroana, étaina eyumu­ru­siavaya. Nácani tiávihanahi te tajuhe eta avasare Jerusalén, tavara­haipahi náuchucavane tayehe. Nácani tiávihanahi te vámahiana, vaipa távara­hahini nachavahini tayehe eta avasare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Taicha táiteca­pau­chainapa eta tasache­ra­yarehi eta tacaicu­ñairaya, títaucha­vainapa eta tametarapi eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Páureanasami nácani esenana tachima­ra­rua­nayare, nácani ticaja­ria­na­hipuca, nácani esenana ticachi­chanahi eta amuya tiájicachaha! Támairi­ji­cainapa eta nacata­ji­vai­rayare namutu ena achaneana tiávihanahi te Jerusalén taicha eta náicuñayare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Natiarihi ena tépenanaya te guerra, ena apamuriana nacara­ta­ta­ji­cainapa prisioné­roa­nainapa. Námava­cainapa te apana­queneana avasareana. Ema Viya máisapainapa tisiapana te Jerusalén ena apava­sa­queneana. Énapa téchanayare eta Jerusalén. Tiámainucava te máicutichapa ema Viya, macuchu­ca­va­cai­na­varepa. ");
INSERT INTO ignNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tacahe, tímere­ca­va­nainapa eta ecutia­ra­reyare te sache, te caje, étapa te jarairiquiana. Tipica­nainapa ena achaneana te juca apaquehe. Tiárame­ca­nai­na­varepa taicha eta nasami­rayare eta muracaquene táepacuruha eta ichapequene une. ");
INSERT INTO ignNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ena achaneana tiáquipai­ca­va­nainapa eta napisiraya, taicha eta náimairayare eta ecutia­ra­rea­nayare, váhisera náimatie­que­ne­haimahi tájahapuca eta náichara­ra­ca­va­yarehi. Éneri­chuvare tiyeje­ca­va­va­cainapa eta tiávihanahi te anuquehe anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nupaenumava nítecainapa nuchava núti Manere­ji­runuhi ema Viya. Namutu tímaha­nua­nayare eta núcupai­si­rayare. Tiámanui­napaipa eta úcaji. Níñehi­napaipa eta táetaviu­chi­rayare eta nujarai­va­ya­repahi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te ímahapa tanacu­chavapa eta juca ecutia­ra­rea­nayare, evapi­na­vainapa éti taicha tiánehiripa eta níteca­piraya nucatiu­chi­rá­heyare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Máimicu­ti­ra­chi­navare eta máimitu­re­sirahi. Ánipa macahe: —Ecauneyare eta jácani yucuqui. ");
INSERT INTO ignNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Te ímahapa títsiva­cha­va­vacapa eta tapacajiana, tiánehiripa eta únemu­hu­yareipa. ");
INSERT INTO ignNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ene tacahehi, te ímaha­yarepa, ímatia­cainapa eta tánehi­raripa eta nítesi­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Numeta­ca­he­vanecha: Vuíchaha títava­naimahi ena achaneana náitare­rua­naichaha te táitecapapa eta juca ecutia­ra­reanaya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Títava­yarepa eta anuma étapa eta apaquehe. Tativa­ya­resera títauchava tamutu eta ­ numeta­ruhehi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Échapavaicha, machu tachima­racahe eta jena sache, vahi ecucuti ena tavayuaruana eta téracare, machu muraca­chu­tihéna táicha. Vahi ecueñamava eta ítaresira, machu tahapa­picahe eta éhisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Eta táiteca­pau­chi­rayare eta sache nuchavi­rayare tímicu­ti­ji­ri­cavahi eta táijahú­chirava eta táerata­sirava eta trampa. Ene nacaheyare ena achaneana te tamutu avasareana eta namane­ca­pau­chi­ravaya. ");
INSERT INTO ignNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eta tacahe, etsecavaicha yátupina. Eyuja­rau­chavahi támutu sácheana, apaesa túmehénapa eta ecami­chiraina tamutu eta juca táichara­ra­ca­vayare, apaesa tacuija ecuichi­ravaina eta íteca­pau­chi­ranuya te numirahu nuti Manere­ji­ru­nuhi ema Viya —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tiuri, tamutu sácheana tiyana eta te Templo ema Jesús. Tímitu­recahi. Te yátivare tiyanavare te avasa­rechicha Betania te táequenehi eta cerro Olivoquiji. ");
INSERT INTO ignNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ena achaneana, tamutu yática­rahiana, tiyanana te Templo, titseca­va­naripa eta nasama­ra­ra­si­rayare éma. ");
INSERT INTO ignNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tamira­hu­paipaicha eta piesta ticaijare Pascua, eta náepanavaira eta semana eta nanisirahi étachucha pan mayehere levadura. ");
INSERT INTO ignNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tacahe, ena tuparai­rucana énapa ena escribánoana, navara­haichaha náimicapaca ema Jesús. Tásiha, natanucahi eta náichara­cayare eta nacara­ta­si­rayare. Návami­ra­hu­hisera ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tacahe, ema Satanás mávahácapa ema émana máimiture ticaijare Júlasi. Émarichuhi nachamurihi ena dócequeneana apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tacahe, ema maca Júlasi tiyanapa matanu­pa­na­vacahi ena tuparai­ru­cana, énapa ena nacápi­tárana ena suntaruana tayehe eta Templo. Téchaji­ri­pa­na­va­yarehi nayehe, mameta­ca­vacaipa eta táichara­ca­va­yarehi eta máijara­re­si­ra­yarehi ema Jesús eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tiúrisa­mu­rea­na­rinehi eta mameta­si­ra­vacahi éma. Nametacapa eta ­ náijara­si­ra­yarehi eta plata. ");
INSERT INTO ignNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tacahe, éma majaca­pa­vacapa eta naplatane. Tásiha, máichavacapa: —Tiuri, núti népana­heyare te nímahapa nacuijapa ena achaneana te machacaya. Námahénapa tayehe eta mávihahi éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Títecapapa eta sache táepani­ravahi eta semana tapiestara eta nanisiraya eta pan mayehere levadura. Étari­chuvare eta jena sache ticaijare Pascua, nacapa­siraya eta uvesa ticaijare cordero pascual, nanisi­rayare te jena yati. ");
INSERT INTO ignNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ema Jesús mavane­ca­vacapa ena apinana máimitureana, ema Pedro émapa ema Juan. Máichavacapa: —Eyanayare étupi­ri­panaya eta viniruyare tayehe eta Pascua. ");
INSERT INTO ignNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Éna nayase­recapa: —¿Táviha pivaraha vétupi­ri­sihaya? ");
INSERT INTO ignNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ema Jesús majica­pa­varepa: —Eyanayare tayehe eta avasare. Te íteca­pa­yarepa tayehe, iácapa­ji­cayare ema émana achane tiámapahi eta une te yupi. Éhicayare éma te peti masiapi­hayare. Éti apana esiapa­yareva. ");
INSERT INTO ignNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Emeta­cayare ema ticayehe eta peti. Ani íchayare: “Ema viyehe Maestro tivane­ca­havihi viyase­re­panavi pímechahavi eta cuarto vinisi­hayare eta uvesachicha eta viyeherepi, vicacha­neyare éma” íchayare. ");
INSERT INTO ignNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Éma, tímecha­hénapa eta ichape cuarto te anuquehe piso. Táurique­néipahi eta jácara téjasi­ha­careana. Tásiha, étupi­ricapa eta viniruyare —máichavacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tiyananapa ena vanairu­canahi. Jéhesa­réinehi, náimahapa étapaichuhi eta macaye­ma­que­neanahi ema Jesús. Tacahe, náetupi­ricapa eta naniruyare tayehe­yarehi eta Pas­cua. ");
INSERT INTO ignNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tacahe, te hórapa eta nanisi­ra­yarehi, téjacanapa te mesa ema Jesús énapa ena apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Eta máenisi­ra­vacapa, máichavacahi éna: —Ichapemuri eta nuvarairahi nucachanehe eta nunisi­ra­yarehi eta juca téqueneha nénisi­rahehi puiti eta juca yati páscuairahi, mapurare vuíchaha táiteca­pahini eta népeni­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tásiha, numeta­ca­he­vaneya puiti, vaipa nápecha­vaimahi nunica eta Pascua, tiámainucava te táitauchavapa eta nusiapiraya eta nucava­cu­reraya, nucaju­pa­hairaya ema Tata —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tacahe, mavehapa eta vasu náerirare, mahasu­lu­pa­yachapa ema Viya. Tásiha, macahepa: —Era eta juca. Ecaji­ji­ricaca. ");
INSERT INTO ignNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Puiti numeta­ca­hevane: Vaipa nápecha­vaimahi nera eta juca tachi eta uva, tiámainucava te táitauchavapa eta nusiapiraya eta nucava­cu­reraya, nucaju­pa­hairaya ema Tata —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tacahe, maveha­varepa eta pan, mahasu­lu­pa­ya­cha­varepa ema Viya. Mayuve­tu­hecapa, máijara­ca­vacapa ena máimitureana. Tásiha, máichavacapa: —Eta juca neche. Enica. Étivenehi níjara­re­cavahi eta népeni­rayare. Eta juca apaja­ra­hiyare te apaquehe, te étipava énicaca, éta témecha­heyare nuyehe —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Éneri­chuvare, te títane­sianapa, maveha­varepa eta náerirare vasu. Máichavacapa: —Eta juca vino, táicutiarahi eta nítine táepusai­ruvaya íchavene éti, nufirma­chi­rayare eta arairu matratune ema Vicaiyaquene, nucaeja­si­ra­yareva eta matratune apaesa ejaca­pa­careya mayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Puítisera, ani te etaracu, mararihi ema tíjara­re­ca­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yátupi­quenehi eta nacapa­si­ra­nu­yarehi, taicha tacahehi eta mapane­reruhi ema Tata eta nuyehe nuti Manere­ji­runuhi éma. Páuresa­misera ema tíjara­re­canuya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tacahe, ena máimitureana tiyase­re­ji­ri­ca­canapa: —¿Nájahapuca mácani te vitaracu ema tíjara­recaya ema Viáquenu? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Te táequenepa, tiácapae­ma­ji­ri­canapa ena máimitureana tayehe eta nájaha­ya­repuca ema ichape­que­ne­panaya aquenuca te nataracu te náejasiraya te návacu­rea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Te máechapa ema Jesús, ánipa máichavaca: —Ena réyeana énapa ena aquenucana te ichape­queneana avasareana nacaete­ma­ji­ri­ca­vacahi ena achaneana, navarairahi ticapi­ca­hua­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Étisera vahi táuricaimahi ene ácahehini. Téhesera evara­ha­hipuca ecapicahu, vahi ecasi­ña­vaimahi. Ecutiyare ema amaperu eta mamansuvahi. Tacutiquene nácani tivane­canahi, tatupa­ra­ca­vacahi téñama­va­nayare eta náechapa­ji­ri­si­ra­va­cayare ena nachamuriana. ");
INSERT INTO ignNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Eta nayeherepi ena achaneana, ichape eta napicau­chirahi ema ténicahi eta tinicacare. Énasera ena vanairucana téchapa­ji­ri­canahi eta mesa, vahi nacapi­ca­huhini. Puítisera, nímitu­ca­heyare eta juca arairu nuvanairipi. Puiti ímahanuipa eta nítáti­rahehi. Nuvaraha ecutinuya. Ítáti­ca­cayare éti. ");
INSERT INTO ignNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Éti, ímara­ra­canuhi eta náichiranuhi ena ticatia­na­ca­nuanahi. Váhisera ejuni­ji­ca­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eta tacahe, níjara­ca­heyare núti eta etupa­ra­ha­nayare ecuti­nuyare núti eta nucatu­pa­ra­hairaya mayehe ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Éjacainapa tayehe eta ecatu­pa­ra­hairaya. Étinapa evane­recaya nayehe ena dócemu­ri­queneana ena vijaneanana israelítana. Ecacha­ne­nui­na­varepa te mesa eta enisiraya ánaqui te nucatu­pa­ra­hai­rayare —máichapa. ­ ");
INSERT INTO ignNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ema Viáquenu máichapa ema Pedro: —Nuchicha Simón, péchapa­vayare. Ema Satanás, ichape eta mavarairahi ticaicu­tia­ra­heyare tiáquipai­ca­heyare ­ emutu éti. ");
INSERT INTO ignNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nútisera nuyaseu­chahehi me Tata, pítiripa, apaesa vahi tacuemitiaca eta péhisi­ranuhi. Piáquipai­ca­va­sa­mi­ya­resera. Tichava­ya­resera eta picasi­ñai­ranuya, tásiha pétume­cha­va­cai­na­varepa ena apamuriana pichamuriana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ema Pedro majicapapa, máichapa: —Tata Náquenu, tájina vahi nujuni­ji­ca­vímahi. Níjaracava néhicavi tayehe eta cárcel. Te nacapa­ca­vipuca, núti apanavare níjara­ca­vavare nacapacanu apaesa nácachanevi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ema Jesús majicapapa: —Numeta­ca­vi­vaneya, Pedro. Puiti jena yati, te tamira­hui­na­richaha eta táechaji­siraya eta varayu, piti mapaheyare pépiya­ca­vayare vahi pímatinu, eta picatiu­chi­ra­vayare pítijiva —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tacahe, ema Jesús mayase­re­ca­va­ca­varepa ena máimitureana. Máichavacapa: —Te nuvane­ca­hénapa epaica, nutupa­ra­cahehi vahi ecuama eta tarera, eta billetera, eta eparu­pevana, ¿yátupihi, masi, vahi ecamu­nu­va­pahini? Ena najicapapa: —Tájina vácamu­nui­pahini. ");
INSERT INTO ignNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tásiha, máichava­ca­varepa: —Puítisera mácani ticata­rerahi, tiúripanahi mámayare eta matarera, étapa eta mayehe billetera. Émaripa mácani tájinahi mayehénahi espada, tiúripanahi máijarareca eta masacu, mavacha­re­sihaya eta mayeheyare espada. ");
INSERT INTO ignNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tacahe numeta­ca­hé­vanécha. Ena achaneana nacatia­na­ca­haviya muraca. Títaucha­vainapa eta táechaji­ri­ru­vanahi eta Sagrada Escritura eta níchara­ra­ca­va­yarehi: “Timicu­ti­ji­ri­cavahi námera­hihini náicha”. Tamutu títaucha­va­yarehi eta tacaye­ma­que­neanahi eta Sagrada Escritura eta ­ nuyehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tacahe, ena máimitureana náichapa: —Tata Viáquenu, jucarihi apinahi eta espada. Éma majica­pa­vacapa: —Tiuri, tarataquene. ");
INSERT INTO ignNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tacahe, tiúchucapa ema Jesús, énapa ena máimitureana, tiyananapa tayehe eta huerta Getsemaní tiávihahi te táemiri­pai­sinehi eta cerro ticaijarehi Olivoquiji, eta mayuja­ra­si­rarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te títeca­panapa tayehe eta Getsemaní, máichavacapa: —Eyuja­rauchava. Eyaseaca ema Viya eta étumevaina apaesa vahi macuitu­rucahe ema Satanás —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Téraji­pa­navapa apaesa ema Jesús eta nayehe. Cincuenta metro eta mayere­hi­né­vacahi. Tépuyucapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Eta mayuja­rau­chi­ravahi, ánipa macahe: —Tátachicha Nucaiyaquene, picata­ji­ca­nupaini. Nuyaseacavi vahi tacuitau­chavaini eta níchava­que­ne­vayare. Váhini picuisapaini eta nucata­ji­vairaya. Níjara­ca­vasera núti eta nítauchiraya eta pivara­ha­quenehi píti eta nuyehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tacahe, tiárami­carepa máucupaucha ema émana ángele tiásihahi te anuma. Máetume­cha­pa­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ichape eta máeñami­ravahi eta mayuja­ra­sirahi. Témiricapa eta máepatsure tacasi­ri­quia­mapahi eta máitine. Cuájujua­mapaipa eta táemiri­sirahi te apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te títapi­ricapa eta mayuja­ra­sirahi, téchepucapa. Tiyanapa te návihahi ena máimitureana. Máimahainehi éna, tímaca­na­ripahi táichavenehi eta nacati­sa­mu­re­vairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tásiha, máichavacapa: —¿Tájaha tacayema ímacaichucha éti? Échepuca. Eyuja­rauchava apaesaina. Eyaseaca ema Viya eta étumevaina apaesa vahi macuitu­rucahe ema Satanás —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tacahe, técheji­ri­ca­vai­ni­richaha ema Jesús, títeca­pa­nanecha ena camuri­queneana suntaruana. Máinapu­mi­rau­cha­va­ca­paipahi ema Júlasi. Témeña­havapa eta mayehe ema Jesús. Máetsera­recapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tásiha, ema Jesús máichapa: —Júlasi, ¿tájaha tacayema pétsera­recanu eta píjara­re­si­ranuhi nuti Manere­ji­runuhi ema Viya? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tacahe, ena máimitureana natiari­hi­que­neanahi, eta náimairahi ena camuri­queneana suntaruana, nayase­recapa ema Jesús. Ánipa nacahe: —Tata Viáquenu, ¿vicatiuchava te espada? ");
INSERT INTO ignNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tásiha, ema émana mavehapa eta mayehe espada. Mayucha­ti­pai­sinapa eta machaca tinapa te vaure ema mamusura ema aquenuca Caifás. ");
INSERT INTO ignNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ema Jesús máicha nuti Manere­ji­runuhi ema vacapa: —Ésami­ri­ca­vachucha —macahepa. Tásiha, ema Jesús mavehapa eta machacaini ema achane, máimichavapa máipistaca, tinara­ca­vanepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tásiha, máichavacapa ema Jesús ena tuparai­rucana natiari­hi­que­nea­napahi eta nacara­ta­sirahi éma, énapa ena aquenu­ca­rahana, énapa ena oficiáleana tayehe eta Templo. Macaja­cha­vacapa: —¿Tájaha tacayema ecasiña eta espada, ecaepu­chi­ri­qui­pa­hivare eta etanu­si­ra­nupahi, tímicu­ti­ji­ri­cavapa námera­hihini núti? ");
INSERT INTO ignNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Étaya­pasica cape juca tamutuhi sácheana nucacha­nehehi tayehe eta Templo. Váhivare epatsi­ca­vahini ecara­ta­ca­nuhini. Étisera iúricapuca eta tamapi­cuvahi eta yátimuhuhi eta íchirahi eta tamauri­que­neanahi taicha mávahá­ruhehi ema Satanás. Máisapa­que­né­he­varepa ema Tata eta ecara­ta­si­ra­nu­yarehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tacahe, nacara­tacapa ema Jesús. Námapa te mapena ema corregidor Caifás. Émasera ema Pedro máehieque­ne­ha­va­capaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ánaqui te tajuhe te canchón, ticamu­ru­re­canapa eta yucu násasia­va­yarehi. Téjamu­ri­hanapa te tachacaya eta yucu. Téjaca­varepa ema Pedro te namuri. ");
INSERT INTO ignNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sucahe­paipahi esu sirvienta, suímahapa ema Pedro eta máejasirahi te tachacaya eta yucu. Suímara­ra­ca­ripahi. Tásiha, suíchapa: —Eñi ñica achane éñirichu ñichamuri eñi Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Émasera ema Pedro tépiya­cavapa vahi máimati. Máichapa: —Pímaha, esena, vahi nímati núti ema píchaquenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te tiyere­re­ha­chi­chavare, máimara­rá­ca­ri­pavare ema apana. Máichapa: —Piti pítirichu machamurivi ema maca. Ema Pedro majica­pa­varepa: —Vahi, tata. Vahi machamu­rinuina —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te hórapapuca eta táetavi­si­ravahi, máimaha­varepa ema apana, máimatipa eta máechaji­ri­sirava ema Pedro. Máichapa: —Yátupiquene pítirichu machamuri ema maena Jesús, taicha eti ecavasana te Galilea, tímati­carehi eta échajisira —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ema Pedro majicapapa: —Vahi nímati, tata, nájahapuca ema maena píchaquenehi —macahepa. Tacahe, téchaji­ri­ca­vai­ni­richaha ema Pedro, énevanepa téchaji­canecha eta varayu. ");
INSERT INTO ignNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ema Viáquenu máesenicapa ema Pedro. Enéva­ne­rinehi téchava ema Pedro eta mameta­ra­pianahi ema Viáquenu eta máichirahi: “Te tamira­hui­na­richaha eta táechaji­si­rayare eta varayu, píti mapaheyare pépiya­ca­vayare vahi pímatinu”. ");
INSERT INTO ignNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tásiha, tiúchuca­vanepa ema Pedro. Tíyahapa taicha máimati­vanepa eta táichapevahi eta máejeca­pi­ravahi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ena suntaruana tijanea­canahi ema Jesús, nacaeca­hi­ji­ricapa éma. Náehara­racapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Náitiuqui­chavare. Náehami­ra­havare. Tásiha, náichapa: —Vímaha­se­jicacha, te pijarau­quipuca, pímati­ha­viyare nájahapuca ema téhami­ra­havíhi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ichape­mu­rivare eta napana­ra­ra­chirahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te tijarahipa, ticuru­ji­ca­canapa ena tuparai­ru­cana, énapa ena aquenu­ca­ra­hana, énapa ena escribá­noana. Námapa ema Jesús, nacatu­pihapa te namirahu. Nayase­recapa: ");
INSERT INTO ignNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Viyase­re­ca­viyare. ¿Pítisaréji Cristo, ema vicucha­pa­quenehi? —náichapa. Majicapapa ema Jesús: —Tiuri, te numetacahe eta nútirahi, éti vahi esuapa­nuimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Téhevare nímecha­hepuca eta ícutiaraina eta nútirahi, éti váhivare esuapa­nuimahi. Éneri­chuvare váhivare ecaiti­ca­nuimahi. ");
INSERT INTO ignNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Étaina­pasera nucaiju­heyare te anuma nuti Manere­ji­ru­nuhi ema Viya eta néjasi­rainapa te mavaure ema Tata, máitupa­ji­ji­ha­quenehi éma —máichapa éma Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nayase­re­cavare namutu, náichapa: —Tacahe piti, ¿pímija­cha­vapuca machichavi ema Viya? Ema majica­pa­vacapa: —Yátupi machichanu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tacahe, éna nacahepa: —Vaipa tácamesa vicaya­se­se­re­ruhini ena testígoana. Émaquenepa visamahi puiti eta juca máechaji­ri­ruvahi, étapa ticaviureya —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tacahe, téchepu­mu­ri­hanapa namutu. Námapa ema Jesús te mamirahu ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te nacaitecapa, náepiyae­que­nehapa éma. Ánipa nacahe: —Viámapahi ema maca achane ani te pimirahu. Mavarahahi mahapa­pi­si­na­ha­viyare ena vichane­ranahi. Éneri­chuvare macahehi váhiji táurica vivacha­chahini eta impuesto mayehe ema viyehe Presidente Emperador. Éneri­chuvare, macahe­hivare eta émairahíji Cristo, ema réy-yarehíji —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tásiha, ema Pilato mayase­recapa ema Jesús: —¿Yátupi­sareji réyvihi píti nayehe ena pijaneanana israelítana? —máichapa. Ema Jesús majicapapa: —Pitupi­ruvahi eta juca piyase­re­si­ranuhi. Yátupihi eta nurreyvahi —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tacahe, ema Pilato máichavacapa ena tuparai­rucana énapa ena achaneana natiari­hi­que­neanahi: —Tájina maviurevaina eta nímairahi ema maca achane —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Énasera nayurucapa muraca ema Pilato. Ánipa naicha: —Ema maca, ichape eta mahapa­pi­sirahi eta napane­reruana namutu ena achaneana vijaneanana israelítana, énaripa ena ticava­sanahi te Galilea étapa ani te juca Jerusalén —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Eta masami­ra­vacahi ema Pilato, macaya­se­se­rerupa te étahipuca te Galilea macavasahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te nametacapa eta étairahi macavasa ema Jesús, macava­nai­ripipa ema Pilato nama mayehe ema Herodes, aquenucahi tayehe eta Galilea, taicha ema Herodes matiarihihi tayehe eta Jerusalén eta jena sácheana páscuairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tacahe, tiúrisa­mu­réinehi ema Herodes eta máimairahi ema Jesús. Ichape­murihi eta mavarairahi máimati taicha masamai­ri­ricahi tamutu eta tiárami­careana máichaque­nea­napahi ema Jesús. Mavara­hainehi tíjahúchava máimahahini eta jácani tiáramicare. ");
INSERT INTO ignNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ichape­murihi eta mayase­se­re­sirahi. Émasera ema Jesús, tájina vahi majica­pahini. ");
INSERT INTO ignNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Natiari­hi­pa­hivare­ ena tuparai­rucana. Tétavi­cavahi eta nasema­nevahi eta náepiyae­que­ne­hai­rapahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tásiha, ema Herodes énapa ena masunta­rurana, ichape­rinehi eta náepuruirahi. Tacahe, ema Herodes mavehapa eta mamuirihaini manaqui­ria­ru­vaipahi, táepaha­me­que­ne­ripahi eta tajanu­nu­me­si­rainihi. Mamuriachapa ema Jesús. Táicutiarahi eta nacaeca­hirahi éma. Tásiha, macava­nai­ri­pi­varepa ema Herodes náimi­chava te mamirahu ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ema Herodes émapa ema Pilato ticatia­na­ca­ca­nainihi eta náitare­sirahi. Étasera te jena sáchequenehi tichavapa eta náemuna­si­ra­cacahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tacahe, ema Pilato eta máimairahi náimicha­virahi eta mayehe, macuru­ji­mu­rihapa ena tuparai­ru­canahi énapa ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tacahe, máichavacapa: —Eta iámirapahi ema maca achane te numirahu, ímijachahi mahapa­pi­cavaca ena achaneana. Nútisera nímahahi tájina maviure­vainahi eta nuyase­se­re­sirahi te emirahu eta ímija­cha­quenehi eta máejeca­pi­ra­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Émaripa ema Herodes máimicha­vavare eta ani nuyehe taicha tájinavare máimahahini eta máejeca­pi­ra­vai­nahini. Étaina­hi­pucaini taviuchahini táimica­pa­cahini. ");
INSERT INTO ignNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tiúrise­rapuca nímiva­nereca macaeme­charahi, tásiha, nucaiticapa —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Eta mayeherepi ema Pilato te Páscuamuhuana te áñoana macaiti­ca­yarehi ema émana preso te jena sáchequenehi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tacahe, ena achaneana vahi návara­hahini máuchucu­hahini ema Jesús. Tipiara­canapa muraca. Ánipa nacahe: —Vahi vávaraha máuchucuha ema maca. Émaina máuchucuha ema Barrabás —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ema Barrabás te cárcel mávihahi. Táimicu­ñaruhi eta máichirahi eta revolución étapa eta macapa­hivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Émasera ema Pilato mavara­haichucha macaiti­ca­yarehi ema Jesús. Mayase­re­mu­ri­ha­varepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Énasera muraca­pa­na­paichucha eta napiara­sirahi: —¡Pémeta­tareca te crusu! ¡Pémeta­tareca te crusu! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mapahe­quenepa eta mayase­re­si­ra­vacahi éma: —¿Tájasica eta maviurevahi ema maca? Núti tájina nímaha maviure­vainahi táimica­pa­cahini. Tiúrise­rapuca nímiva­nereca macaeme­charahi, tásiha, nucaiticapa —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Énasera tímitu­ji­ri­ca­canapa eta napiara­siraina nayasea­siraina eta macaeta­tairaya te crusu. ");
INSERT INTO ignNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jéhesa­réinehi, ema Pilato masuapa­vacapa eta nayasea­rapihi ena tuparai­rucana. ");
INSERT INTO ignNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Émapa tiúchucuhahi ema Barrabás ema nayase­se­reruhi, táimicu­ñaruhi eta máichirahi eta revolución étapa eta macapa­hivahi. Macava­nai­ripipa táitauchava eta navara­ha­quenehi éna, eta nacapa­siraya ema Jesús te crusu. ");
INSERT INTO ignNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tacahe, námapa ema Jesús tayehe eta macaeta­tai­ya­yarehi. Eta napaisi­rapahi te calle, nácapa­jicapa ema achane ticaijare Simón ticavasahi te Cirene. Éma, másihapahi te máesane. Napamicapa máevachacaya manara­cu­ha­yarehi eta macurusura ema Jesús, máehica­paipahi te máequene ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ichape­muriana ena achaneana téhica­napahi. Énaripa ena esenana, tipiara­re­ca­napaipa eta náiyairapahi taicha eta nacati­sa­mu­revahi, náimara­ra­sirahi eta máejapa­nu­ra­vapahi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Máeseni­mu­rihapa éma. Máichavacapa: —Vahi ecuiyauchanu, eti esenana tachicha­na­veanahi eta Jerusalén. Étina íyauchava, náichave­nénahi ena echicha­naveana. ");
INSERT INTO ignNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Taicha tatiari­hiyare eta sáchevayare nacapa­ca­ya­revare ena. Ichape eta nacaja­pa­nu­ra­vairaya eta nacapa­siraya. Tásiha ecahénapa: “Tétavi­cavapa náuriva ena esenana macheruana. Nájina náimipa­ne­re­re­cahini”. ");
INSERT INTO ignNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tásiha, ena achaneana, eta napisi­rayare, tijuna­nainapa te cérroana, tásiha, nacahénapa: “Tiúripa­na­pucaini viyumu­ru­ca­vahini eta te juca cerro.” Ena apamuriana nacahe­na­va­re­papuca: “Étapucaini te juca simena viyumu­ru­sia­vahini”. ");
INSERT INTO ignNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Apanasica núti ichapemuri eta nucata­ji­vairahi, tájina­hinéni taviucha­nuhini. Naveti­ji­yarecha éta nátaji­vayare ena echicha­na­veana­ —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Éneri­chuvare natiari­hi­pa­hivare ena apinana tiámerahiana macuti­que­nea­na­yarehi ema Jesús eta macaeta­tai­rayare. ");
INSERT INTO ignNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tacahe, nacaite­capapa tayehe eta masihi nacaeta­tairare ticaijarehi Calavera. Náetatacapa te crusu ema Jesús, énapa ena apinana tiámerahiana. Ema émana nanacapa te mavaure, ema apana te sapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Te náetatacapa ema Jesús, macahepa eta máechaji­ri­ruvahi: —Tata, piperdo­na­chavaca ena nani, taicha vahi nácaicu­tia­rahini eta juca náichiranuhi —macahepa. Tacahe, ena suntaruana nasuerte­hachapa eta mamuirihaini eta náijara­ji­ri­si­ra­cacahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Natiarihihi ena achaneana tímara­ra­canahi tamutu. Énaripa ena tuparai­rucana natiari­hi­hivare. Nacaeca­hi­ji­ri­caripa éma. Ánipa nacahe: —Ema mácacacha, macahehi eta máechaji­ri­ruvahi eta marata­hai­rahíji macuchu­cu­havaca ena apamuriana achaneana. Tásiha puiti, vivaraha vímaha máimereuchava eta máitupa­ji­jia­si­ra­vahíji, te yátupi­hipuca Cristo éma, Manere­ji­ruhíji ema Viya —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Éneri­chuvare ena suntaruana nacaeca­hi­ji­ri­ca­hivare éma. Navarahapa náesicha­yarehi eta tasisiru vino. ");
INSERT INTO ignNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Náichapa éma: —Te yátupi­napuca piti reyvihi nayehe ena israelíta, pítijivaina picuchu­cuhava —n­áichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tatiari­hi­hivare eta ajureca nanaca­quenehi te tachutisi eta macurusura. Eta juca ajureca tacaju­quenehi te náechaji­riruva te griego, te latín, téhapa hebreo. Ani tacahehi eta táechaji­ri­ruvahi: “Ema maca ema Rey nayehe ena israelítana”. ");
INSERT INTO ignNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ema émana tiámerahi macaeta­ta­quenehi te machacaya, éneri­chuvare éma macaecahihi. Ani macahehi: —Te yátupi­napuca pítiquenehi Cristo, picuchu­cuhava pítijivaina. Tásiha, picuchu­cu­ha­vivare víti apana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Émasera ema apana macaeta­ta­quenehi macahepa: —Váhipuca pipicahini píti ema Viya. Váhipuca péchahi étarichuhi viávacuha víti eta juca vícuñahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Víti, vivachachahi eta juca vitapi­ravahi taicha ichape­quenehi eta véjeca­pi­ra­vanahi. Émasera ema maca Jesús, ticata­jivahi tájina­hinéni taviuchahini. ");
INSERT INTO ignNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tacahe, máichapa: —Tata Jesús, péchanupaini te péjacapa tayehe eta piávacureya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ema Jesús majicapapa: —Numeta­ca­vivane, puiti píti nucacha­ne­viyare te paraíso —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Tacahe, te las dócequenepa, témahapa eta sache. Timapicupa tamutu eta apaquehe. Mapana hora eta tamapi­cuirahi. Étarichuhi eta jena máepenirahi éma, tíjahú­chavapa tétsayumeca eta tayehe cortina eta Templo. Ticuti­mecaca eta taetsayu­me­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ema Jesús tipiaracapa: —Tata, pijaca­pinanu eta náchaneva —macahepa. Te títapi­ricapa, tépenapa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tacahe, ema nacapitara ena suntaruana romanoana, tipica­rinehi eta máimairahi eta júca. Étapa macaicu­tiarapa, macunachapa ema Jesús, ánipa macahe: —Yátupi­que­néi­chuyapa ema maca achane matapi­ra­varehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Namutu ena achaneana natiari­hi­que­neanahi, eta náimairahi eta júcana, ichape­rinehi eta napisirahi. Téhatu­pa­chá­va­napáipa eta nacati­sa­mu­ré­vairahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Énasera ena téhica­napahi ema Jesús te másihainapa te Galilea, énapa ena esenana, namutuhi naneca­pa­ra­recahi eta juca táichava­que­ne­vanahi. Nayere­re­hi­hisera eta náimara­ra­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Matiari­hi­hivare ema achane ticaijare José. Ticavasahi te Arimatea te Judea. Tipicau­rahihi éma. Tétavi­ca­va­hivare eta máuriva. Masuapahi ema Jesús, eta émairahi ema Cristo mavaneruhi ema Viya, étaripa eta émairahi ema téchayarehi namutu ena achaneana. Ema maca José, náumurivahi ena aquenu­ca­ra­hana, váhisera mapaucha­va­cahini ena machamu­rianahi tayehe eta juca náichaque­neanahi tamauri­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Te cápere­hi­chichapa, eta máimairahi máepeni­raipahi ema Jesús, tiyanapa mayehe ema Pilato, mayasea­panahi eta máquehe ema Jesús, mavarairahi máecarayare. ");
INSERT INTO ignNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Te tichavapa, macucu­paicapa eta máquehe tayehe eta crusu. Máyuruacapa eta te sávana tijapu. Náiyara­cuhapa tayehe eta máecari eta te mari naseca­jueruhi. Nájinaichaha nacaeca­ra­sihini tayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Titata­jianapa taicha cápere­hi­chi­chaipahi. Taicha vahi táisapa­ca­rehini náecara­re­cahini te yati, váhivare te tijara­hia­caimahi taicha sávaru­mu­hu­yarepa. ");
INSERT INTO ignNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ena esenana téhica­napahi ema Jesús te másihainapa te Galilea, tiyananapa tayehe eta máecari, náimati­yarehi eta mávihahi. ");
INSERT INTO ignNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Te náimatipa, tichavanapa te napena. Natsecapa eta perfume mayaji­ha­yarehi. Tinara­ca­na­pasera te jena sáchequenehi, napicauchahi eta tapicau­cha­ca­revahi. ");
INSERT INTO ignNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te apanapa sache, te tijara­ra­hi­chichapa eta lumíncu­quenehi, tiyananapa ena esenana tayehe eta máecari. Námapaipa eta perfumeana náicure­vanahi, nacacha­ne­va­capaipa ena apamuriana esenana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Te títeca­panapa tayehe eta ecari, náimaha­rinehi eta ticheyarame mari tajihainihi eta ecari, téquehe­pui­chavaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tisiapanapa éna, náejiacainehi eta máquehe ema Viáquenu Jesús. Májina­ripahi. ");
INSERT INTO ignNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tiárame­ca­na­rinehi eta náejiasirahi. Váipa náimatie­que­ne­hahini tájaha­hipuca eta máichara­ra­cavahi. Tásiha, tiárami­carepa náimahahi ena apinana ajairana titupi­hanahi te nachacaya. Tijanu­nu­ca­vacahi eta namuirihana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eta nárame­sirahi éna, tétipai­mu­ri­hanapa. Énasera ena ajairana náimaha­que­neanahi náichapa: ");
INSERT INTO ignNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","—Éti ímija­chai­papuca manasihi tépenahi ema Jesucristo, Manere­jiruhi ema Viya. Májinaripa, tichava­ripahi títareca. Échava­ri­chu­hipuca eta macaye­ma­que­neanahi te achane­richaha te manasi­que­ne­richaha te Galilea. Macahehi eta máechaji­ri­ruvahi eta nacara­ta­si­ra­yarehi ena ticatia­na­canahi éma, náetata­si­ra­ya­rehiva te crusu. Téchepu­ca­ya­re­hisera te mapana­que­nénapa sache —nacahepa ena ajairana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tacahe éna, enuru­ji­rinehi náechavane eta máechaji­ri­ru­vanahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Te tichavanapa te napena, nametacapa ena óncequeneana apóstoleana, énapa ena apamuriana nachamu­rianahi. Te nataracu ena esenana tímahanahi ena ángeleana, sutiari­hipahi esu María Magdalena, esu Juana, ésupa esu apanavare María, máenahi ema Jacobo. ");
INSERT INTO ignNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Énasera ena apóstoleana vahi nasuapahini, náimija­chaichucha náepiya­hi­raivahi namauri­shivahi ena esenana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tiyana­va­ne­pasera ema Pedro tayehe eta ecari. Tijuna­pa­paipahi. Te títecapapa, máimahapa tacarinehi eta sávana. Mapane­re­que­ne­hainehi eta juca táichara­ra­cavahi. Tacahe, tichava­varepa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Étarichu te jena sáchequenehi, tipaica­napahi te achene ena apinana máimitureana ema Jesús. Násihahi éna te Jerusalén nacaiju­he­yarehi eta avasa­rechicha Emaús. Once kilometro eta tayere­hivahi. ");
INSERT INTO ignNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eta napaisi­rapahi nacasa­mu­re­paipahi eta nasamai­ri­riruhi. Téchaji­ri­ca­va­napaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eta náechaji­si­hai­rapahi eta juca táichara­ra­ca­vanahi, tiárami­carepa macapa­ya­mu­rihapa ema Jesús, macacha­ne­va­capaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Énasera vahi náimatihini, taicha éma vahi máisapahini náimati. ");
INSERT INTO ignNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tacahe, ema Jesús mayase­re­ca­vacapa: —¿Tájahasica eta juca échaji­si­hapahi eta epaisi­rapahi? ¿Tájaha eta tímipa­ne­re­re­ca­hepahi? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ema émana ticaijarehi Cleofas majicapapa: —Namutu ena achaneana náechahi eta juca táichara­ra­cavahi te Jerusalén puiti juca sácheanahi. ¿Picari­chu­hipuca píti vahi péchahini eta juca, eta piávihairahi te Jerusalén? ");
INSERT INTO ignNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Éma máichavarepa: —¿Tájahasica eta téchacarehi? Éna náichapa: —Émara véchaji­si­hapahi eta máichava­que­névahi ema Jesús Nazareno, ema profeta máurique­nehini nayehe ena achaneana. Tamutuinihi tiuri eta máimitu­rapiana, tétávi­ca­va­hivare eta máitupa­ji­jia­si­ravahi taicha ema Viya, éma tíjaracahi tamutu. ");
INSERT INTO ignNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Énasera ena tuparai­rucana te viávasa, éna tíjara­re­canahi nayehe ena apava­sanana taicha navarahahi náimicapaca. Tásiha, náetatacapa te crusu. ");
INSERT INTO ignNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Víti ichapemuri eta vicasi­ña­vai­rainihi eta mayehe. Vicucha­pa­vainihi eta macatiu­chi­ra­ha­vi­yarehi vimutu viti israelítana. Tamapu­ru­ji­pasera puiti, taicha tépenapa éma. Puiti mapanaripa sache eta táetávi­si­ravahi eta juca. ");
INSERT INTO ignNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Icháque­nesera te yática­ra­hi­chichapa, ticara­me­ca­ha­vianapa ena esenana vichamu­rianahi eta nayati­ruirahi tiyanana tayehe eta máecari. ");
INSERT INTO ignNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Vaipa nachima­pahini eta máquehe. Májinaipahi. Te tichavanapa, timeta­ca­ha­vianaipa eta náimairahi ena apinana ángeleana. Nameta­ca­va­capaji eta machavi­raipahi títareca ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tásiha, tiyana­va­neanapa ena apamuriana vichamuriana tayehe eta ecari. Jéhesa­réinehi májinaipa ema Jesús, étarichuhi eta nacaye­ma­que­nea­napahi ena esenana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Ema Jesús máichavacapa: —Tétávi­cavapa tájinaira ácaicu­tia­ra­quenéna eti páureana. Váhiva­repuca ácaicu­tia­rahini eta náechaji­ri­ru­vanahi ena profetanaini tayehe eta tacahe­yarehi eta macata­ji­vai­ra­yarehi ema Cristo eta máepeni­ra­numaya, tásiha tichava­yarehi títareca. Váhiva­repuca ácaicu­tia­rahini eta tacahe­yarehi eta mápani­ra­yarehi tichava éma te mávasa anuma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tásiha, mameta­ca­va­ca­pasera tamutu eta táechaji­ri­ru­vanahi eta Sagrada Escritura, eta táechaji­si­hairahi éma. Tépanavapa tayehe eta májureanahi ema víyarahaini Moisés; étapa eta apamuriana nájureanahi ena profetanaini. ");
INSERT INTO ignNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Títeca­pa­nanecha tayehe eta avasa­rechicha nacaiju­he­que­nepahi. Mavarahapa ema Jesús majuni­ji­ca­va­ca­ya­rehini. ");
INSERT INTO ignNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Énasera nacumpi­rachapa máehica­va­cahini te napena. Náichapa: —Pácaherine eta ani viyehe, taicha yátinapa eta jena —náichapa. Tásiha, ema Jesús manasipa tisiapapa eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te tiúripa eta tinicacare, mavehapa eta pan, mahasu­lu­pa­yachapa ema Viya, mayuve­tucapa, máijara­ca­vacapa éna. ");
INSERT INTO ignNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Enéva­ne­rinehi náimati­vanepa éma. Émasera tíjahú­chavapa témitiacahi te namirahu. ");
INSERT INTO ignNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Téseni­ji­ri­ca­canapa éna. Tásiha, nacahepa: —¿Tájaha tacayema eta vahi vímati­va­nehini ichaquene te achene te ticapa­ya­ca­havipa éma? Étapa eta vicacha­ne­rapahi, váhivare vímatia­ca­va­nehini, véjapu­sa­mu­re­cha­pai­pa­hinéni eta visami­ravahi eta máimitu­si­ra­ha­vipahi tayehe eta Sagrada Escritura —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tacahe, enévanepa téqueque­ca­vanahi tichavana te Jerusalén. Te títeca­panapa, tisiapanapa tayehe eta návihahi ena óncequeneana apóstoleana énapa ena apamuriana nachamuriana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ánaqui ticame­ta­ca­sia­na­ri­pavare éna. Nacahe­varepa ena apóstoleana: —Yátupi eta máechepu­siraipa ema Viáquenu. Máimaharipa ema Pedro —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ena apinana najica­pa­varepa: —Éneri­chuvare víti vímahai­pavare éma, te achene eta vipaisi­rapahi. Váhisera vímati­va­nehini. Tapaenumava te mayuve­tucapa eta pan, vímatipa éma —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tacahe, téchaji­ri­ca­va­na­richaha éna, tíjahú­cha­va­varepa tímerecava ema Jesús te namuri. Máechaji­ca­vacapa, ánipa macahe: —Íchara­racava, nuchicha­naveana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Énasera tipica­na­richucha, náimija­chaichucha cunarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Émasera ema Jesús máichavacapa: —Vahi ecupicanu. Étumecha eta esamureana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ímaha eta juca nuvahuana étapa eta nívapeana. Émama­hacanu apaesa écha eta nútique­nérahi. Eta cunare, tájina táechena, tájinavare táperaina. Vahi tácutihini eta nucaque­herahi núti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tacahe, eta máichira­vacahi, ticaja­ru­vau­chavaipa eta mavahuana, étapa eta máivapeana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vuíchahasera nasuapahini éna, tiúrisa­mu­rea­na­ri­pa­hinéni eta náimairahi, tacacha­ne­hisera eta napisirahi. Eta tacahe, máichavarepa: —¿Jararihi nunica? ");
INSERT INTO ignNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Éna náijaracapa eta nájimaru jima, étasipa vasu eta mápama. ");
INSERT INTO ignNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Majaca­pa­vacapa éma, tinicapa te namirahu éna. ");
INSERT INTO ignNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tásiha, máechaji­ri­ca­vacapa: —Eta juca níchava­que­nevahi, étara eta numeta­ruhehi cape juca nucacha­ne­ji­ri­ca­héi­chahahi. Eta tacahe­yarehi eta táitauchi­ra­va­yarehi eta májucha­que­neanahi ema víyarahaini Moisés núti táechaji­si­ha­quenehi. Étapa eta nájucha­que­nea­na­hivare ena profetanaini, étapa eta Salmo. ");
INSERT INTO ignNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Máemecha­va­caipahi eta táechaji­ri­ruvana eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tásiha, máichavarepa: —Étara eta juca tacaju­que­neanahi eta népeni­ra­yarehi nuti Cristo. Néchepu­ca­ya­re­hisera tayehe eta nécari te mapana­quenepa sache. ");
INSERT INTO ignNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Étaya­réi­chu­hivare iámapi­cayare eta níjare eta ímitu­re­siraya ena achaneana ticava­sanahi te tamutu avasareana. Étaripa te juca Jerusalén, emeta­ca­va­cayare ena achaneana eta náeneuchi­ravaina apaesa macaepaha ema Viya eta napeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Éti, nutupa­ra­ruheya eta ímitu­re­siraya eta júcana. ");
INSERT INTO ignNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Enasi­ya­re­cha­hasera ani te juca Jerusalén. Tiámainucava te máiteca­pau­cha­he­vacapa ema Espíritu Santo nuvane­ruyare, máijara­ru­nu­yarehi ema Tata. Éma, tíjara­ca­heyare eta ítupa­ji­jia­si­ra­va­nayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te títapi­ricapa eta máimitu­si­ra­vacahi, mámamu­rihapa te tachachacu eta avasare Jerusalén, te tachacayahi eta avasa­rechicha Betania. Macanu­quechapa eta mavahuana, mayuja­rau­cha­vacapa éna. ");
INSERT INTO ignNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te títapi­ricapa eta mayuja­rau­chi­ra­vacahi, timutse­ra­ha­vapaipa ticanu­que­cha­vapaipa eta mayapirahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eta náimairahi éna eta macanu­que­chi­ra­va­paipahi, tépuyu­mu­ri­hanapa eta naneca­pa­ra­re­sirahi eta mayanirahi. Tásiha, tichavanapa tayehe eta Jerusalén. Tiúrisa­mu­rea­napaipa. ");
INSERT INTO ignNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tájina vahi náejiaca­vahini tayehe eta Templo. Tiyuja­rau­cha­va­na­pa­racahi eta nacuna­chirahi ema Viya. Tamutupa eta juca numeta­si­ravihi ­ puiti.");
INSERT INTO ignNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Eta acane, te táepani­ravahi tamutu, matiari­hi­que­néipahi ema Jesucristo, ema Tímima­tirahi me Viya­. Éma, macachanehi ema Maiya eta máitare­sirahi, Víyahivare éma apanavare. ");
INSERT INTO ignNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ena apinana, nacuti­cacahi eta napane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eta táepani­ravahi eta acane, émarihi ema Cristo ticaema­ta­neacahi tamutu eta tatiari­hi­que­neanahi puiti, máitauchirahi eta mapane­re­ruanahi ema Maiya. Tájina máejeque­rui­nahini, nájinavare apanai­nahini náepiya­cahini eta tatiari­hi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Émari­chu­hivare ticaita­re­ca­havihi viti achaneana. Émari­chuvare tinacapa te viáchanevana eta tamicahu eta vítare­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Éma tímiyanava tímicau­chahavi taicha mavaraha máimiju­ni­ji­si­na­ha­viyare eta tamapicu te viáchanevana. Narari­hisera ena vahi náuricahini eta mamicau­chi­navaca. Navaraha nacaemaha eta mamicau­chi­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tacahe, te máimahapa tiuri, ema Jesucristo tiúcupaicapa te juca apaquehe. Tiáchane­chavapa. Yátupi­quenehi achane, macaechehi eta veche viti achaneana. Ticasi­ri­qui­havihi te jena áñoanahi majuru­sirahi. Matiari­hivare ema apana achane ticaijarehi Juan Tícacha­si­ri­carahi. Tacahe, ema Viya, te máimahapa tiuri, ticava­nahipa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Máinapu­mi­rau­cha­yarehi eta macame­ta­rai­ruyare eta máimere­si­ravaya ema Cristo, ema namica­huyare nácani ticasi­ña­va­nayare mayehe. Ehane­chavapa. Yátupi­quenehi achane, macaechehi eta veche viti achaneana. Ticama Juan mameta­ca­yarehi ena achaneana natsecava eta najaca­piraya ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ema Juan, vahi émainahini timícau­cha­mu­rimahi ena achaneana. Émahisera ticame­ta­rai­ru­ra­hi­yarehi eta máucupai­sirapa ema tiámahavihi eta yátupi­queneana mapane­re­ruanahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ema maca máechaji­si­haquene ema Juan, éma yátupi­quenehi eta mamicau­chi­ra­ha­vi­yarehi vimutu viti achaneana, taicha tímieche viti achaneana. Ticatu­cahavi eta mapane­reruana ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Ema Jesucristo, émahi acane tépiyacahi tamutu eta apaquehe, énapa ena viáchuca­na­veanaini. Puíticha éma téchahavi vimutu. Téhesera te tiúcupaicapa éma, namaima­ti­quenehi ena achaneana Viáquenuirahi éma, váhivare navara­hahini najaca­pahini éma. ");
INSERT INTO ignNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Natiari­hisera ena tinere­ji­ca­vanahi tijaca­panahi, téhicanahi éma. Ena nani, ichape­rinehi eta macuna­chi­ra­vacahi táichavene eta nacasi­ñai­ravahi mayehe. Éna, yátupi­que­neripa machicha­na­veanahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eta macachi­chai­ra­havihi ema Viya víti, émahi ema Viya tinere­ji­cahavi táichavene eta vicasi­ñai­ravahi mayehe. Vahi étapa­ra­cai­na­hi­pucaini eta náehisi­rai­na­hi­pucaini ena ticachi­cha­haviana. Váhivare étapa­ra­cai­na­hi­pucaini vivara­ha­hi­pucaini ichape víti. Váhivare étapa­ra­cai­na­hi­pucaini ichape­na­hi­pucaini eta mavarai­rahini mácani apana achane. ");
INSERT INTO ignNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","17","Viti véhicanahi ema Jesús eta matiari­hirahi te juca apaquehe, yátupi eta vímatirahi éma. Vímahahi te viúquihana. Vímati­varepa eta másihairahi te anuma, eta émairahi ema macari­chu­quenehi Machicha ema Viya. Yátupi­hivare eta víyairahi éma, macutihi ema Maiya. Éma, tímima­tirahi me Viya, taicha éma máimerecahi eta máetaviu­chirahi eta máemuna­si­ra­havihi, máimechi­ra­ha­vi­hivare eta yátupi­queneana mapane­reruana ema Maiya. Ema víyarahaini Moisés ticatu­pa­rahahi me Viya eta máimitu­si­ra­havihi viti achaneana eta vanairipiana. Émasera ema Jesucristo ticatu­pa­rahahi me Maiya eta máimitu­si­ra­havihi eta máemuna­si­ra­havihi, étapa eta máechaji­ri­ruvana yátupi­queneana ema Viya. Ema Cristo, tétavi­cavahi eta máuriva eta viyehe vimutu. Eta majanea­si­ra­ha­vipahi, tíjara­ca­havihi eta vitumevahi te tamutu sácheana. Émaripa ema Juan, ani macahehi eta máechaji­si­hairahi ema Jesús: “Émara ema maca ema néchaji­si­ha­quenehi eta eyehe cape juca. Yátupi núti nínapucahi eta núchusirahi, émasera matiari­hi­que­neipahi eta acane, májina­nui­chahahi núti. Eta tacahe, tipicau­cha­ca­re­panahi eta nuyehe” macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yátupiquene nájina náimatihini eta máimahi ema Viya. Émasera ema macari­chuquene Machicha, tímima­ti­cha­havihi eta máuriva ema Maiya taicha étaquenehi másiha te masamure ema Maiya. ");
INSERT INTO ignNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tacahe, te jena sácheana, ena tuparai­ru­canahi ticava­sanahi te Jerusalén navanecapa ena náevana­chana, nayanaucha ema Juan Tícacha­si­ri­carahi. Éna, nayase­recapa, ánipa nacahe: —Tamutu arairuhi eta pímitu­rapiana. ¿Pítinaripa ema Cristo vicucha­pa­quenehi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Matupi­ruvapa eta majica­pi­ra­vacahi. Ánipa macahe: —Núti mavane­runuhi ema Viya. Váhisera nútina ema ecucha­pa­quenehi ema ticaijare Cristo —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tacahe, nápecha­varepa nayasereca: —¿Nájaha­visica píti? ¿Pítipuca picaijare Profeta Elías? ¿Pichavahi eta te juca apaquehe? —náichapa. Émasera majica­pa­varepa: —Vahi nútina. Tásiha, nápecha­varepa nayasereca: —¿Nájaha­visica píti? ¿Pítipapuca ema apana profeta vicucha­pa­quenehi? —náichapa. Émasera majica­pa­varepa: —Vahi nútina. ");
INSERT INTO ignNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tacahe, náichavarepa: —¿Nájaha­vi­que­nesica píti? Pimeta­ca­ha­vichucha te nájaha­vipuca píti. Vivaraha véchayare, apaesa vimeta­cavaca ena tivane­ca­ha­vianahi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tacahe, ema Juan majica­pa­varepa: —Nútichucha máechaji­si­ha­quenehi te ajureca ema víyarahaini profeta Isaías. Núti nucame­ta­rairuhi nayehe ena achaneana vámahi­cu­rúhana. Níchuha­vacahi éna apaesa natsecava eta jácani máiteca­piraya ema Viáquenu —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Natiari­hi­hivare ena navane­ruanahi ena fariséoana. ");
INSERT INTO ignNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nayase­re­ca­varepa éna apanava: —¿Tájahasica tacayemahi eta pícacha­si­ri­sirahi ena vijaneanana, te váhipuca pítinahíni ema Cristo, váhivare pítinahíni ema profeta Elías, váhivare pítinahíni ema apana profeta vicucha­pa­quenehi? Ena vijaneanana vahi tácamu­nuhini nacaica­cha­sihini. Énasera ena apava­sanana, jéhesare tacamunu eta nácaica­cha­sivaca —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tacahe, éma majica­pa­vacapa: —Tiuri, núti yátupi nícacha­si­ca­vacahi te une ena achaneana, apaesa natsecava eta jácani máiteca­piraya ema vicucha­pa­quenehi. Matiari­hi­pasera puiti te vitaracu. Étisera vahi ímatihini éma. ");
INSERT INTO ignNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tímere­ca­va­va­nénapa. Ticuna­cha­ca­re­pa­na­ya­resera eta nuyehe. Váiparinehi nácuti­sa­mimahi eta máitupa­ji­jia­si­ravahi. Váipari­ne­hivare nácaemu­ña­vaimahi macamu­su­ra­nuhini núti páuresami —máichavacapa éna ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eta mávihahi ema Juan máicacha­si­ri­sinehi ticaijare Betábara, te apachara eta cajacure ticaijare Jordán, tinapaicahi te táuchusine eta sache. Eta nayase­re­si­ne­panahi ena vanairu­canahi. ");
INSERT INTO ignNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te apanapa sache, máimahapa ema Juan eta mapauchi­ra­paipahi ema Jesús. Tacahe, máichavacapa ena achaneana: —Ímaha, márajapa ema Cordero, matapi­ra­va­requene éma, vanairucahi me Viya. Éma, táimica­pa­ruyare eta macaepa­hai­rayare eta vipeca­turana viti achaneana te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Émara ema maca ema néchaji­si­ha­quenehi eta eyehe cape juca. Núti nínapucahi mayehe éma, émasera matiari­hi­que­néipahi eta acane, májina­nui­chahahi núti. Eta tacahe, tipicau­cha­ca­re­panahi eta nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nútiripa néchaji­sihahi éma, vuíchahasera nímatihini. Numeta­ca­he­hisera eti nujaneanana israelítana eta ecaica­cha­siraina apaesa etsecavahi eta ejaca­piraina éma te jácani máimere­cavapa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tacahe, cape sache, títeca­pau­chanupa ema Jesús, mavarairahi nícacha­si­cayare éma. Tásiha, te viúcupaicapa te une, nímahapa ema Espíritu Santo eta máucupai­sirahi te anuma, ticuti­parine eta paloma. Masiapa­hacapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tacahe, te nímahapa, nupaenu­mavapa nímati éma eta émairahi ema vicucha­pa­quenehi Cristo, taicha ema Viya tímitu­canupa eta máicutia­rayare. Ani macahehi: “Te pímaha ema Espíritu Santo máucupaucha te mápusi mácani achane, pímatiya eta émairahi ema Nuchicha nuvaneruhi. Éma, tíjara­ca­he­va­cayare ema Espíritu Santo, tisiapa­ha­ca­he­va­cainapa éti achaneana. Nuchane­ra­heinapa éti” máichanupa ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tásiha puiti, nímatipa éma. Táitusiava numetacahe puiti eta émairahi ema Cristo, Machicha ema Viya —máichavacapa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tacahe, te apana­varepa sache, ema Juan matiarihihi tayehe eta mávira­reasahi, vítipa viti apinahavi máimitu­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tásiha, máimahapa ema Jesús tiánucu­ha­paipahi. Tacahe, ema Juan máichahavipa: —Ímaha. Ema maena Jesús, émahi ema Cordero matapi­ra­va­requene, vanairucahi me Viya —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tacahe, eta vímairahi viti apinahavi máimitureana ema Juan, viyanapa véhicahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tásiha, ema Jesús tésenie­que­ne­havapa. Máimahapa eta véhisi­rapahi. Tiyase­re­ca­havipa: —¿Tájaha ecamunu nuyehe? —máichahavipa. Víti vijicapapa: —Tata maestro, ¿távihapuca eta píteca­pirare? ");
INSERT INTO ignNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ema Jesús tijica­pa­havipa: —Yare, ímaha apaesa ímativa. Tacahe, viyaninapa vímatipa eta mávirarehi. Vítaipahi eta jena sache eta viávihairahi eta mayehe, taicha las cuátroripahi sache te vítecapapa ánaqui. ");
INSERT INTO ignNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Andrés máijare éma nuchamuri téhicapahi ema Jesús. Tacahe, eta máurisa­mu­revahi ema Andrés, tiyana­vanepa matanucahi ema maparape Simón Pedro. Te máichimavapa, máichapa: —Vímaharipa ema vicucha­paquene Mesías ema Cristo —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tacahe, ema Andrés tichavapa mámapa ema maparape Simón eta te mávihahi ema Jesús. Te náiteca­pauchapa, ema Jesús máesenicapa ema Simón. Tásiha, máichapa: —Piti Simón, machichavihi ema Jonás. Nútisera nítsivachaya eta píjare. Núti níjare­chaviya Pedro, táichavenehi eta pétaviu­chi­rayare eta pitumeva —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te apanapa sache, ema Jesús mavarahapa tiyana­yarehi te tinapaica eta Galilea. Tásiha, macainunapa ema Felipe. Tásiha, máichapa: —Yare, péhicanu. ");
INSERT INTO ignNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Eta mávasahi ema Felipe eta te avasare ticaijare Betsaida, étari­chuvare mávasahi ema Andrés émapa ema Pedro. ");
INSERT INTO ignNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tacahe, ema Felipe tiyana­varepa, matanucahi ema Natanael. Te máetupiacapa, máichapa: —Vímaharipa ema achane máechaji­si­ha­quenehi te libro májucha­quenehi ema víyarahaini Moisés, émari­chuvare éma táechaji­si­ha­quenehi eta libro nájureanahi ena profetanaini. Ema ticaijarehi Jesús, machicha ema José. Ticavasahi te Nazaret —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tásiha, ema Natanael majicapapa: —Váiparinehi étainahini máuchusi­nehini ema achane tiuri tayehe eta avasare Nazaret —macahepa. Tásiha, ema Felipe máichavarepa: —Viyana, apaesa pímati —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tacahe, te náiteca­pauchapa, ema Jesús máimara­ra­caripa ema Natanael. Tásiha, macahepa: —Nímativi eta pipanereru. Píti yátupi­quenevi israelíta. Tétavi­cavahi táurivahi eta pítare­sirahi. Vahi pítuca pivayuareca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tásiha, ema Natanael majicapapa: —¿Táviha pímati­nenuhi? Ema Jesús máichapa: —Núti nímati­vipahi te vuíchaha máetupia­ca­vihini ema Felipe eta máichuira­vi­yarehi, te piáviharipa te tápecu eta yucuqui higo. ");
INSERT INTO ignNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tacahe, ema Natanael masuapa­vanepa ema Jesús. Máichapa: —Tata Maestro, pítiripa piti yátupiquene Machicha ema Viya. Píti yátupi­que­né­vivare Reyvihi viyehe viti israelítana. Núti níjara­cavapa néhicaviya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ema Jesús majicapapa: —Étachucha eta juca níchiravihi eta nímairavihi te tápecu eta yucuqui, pipatsi­cavapa píjaracava péhicanuya. Vahi tácarichu eta juca. Pímaha­yareva eta apana tiárami­ca­rea­napana tayehe eta juca. ");
INSERT INTO ignNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tásiha, ema Jesús máichahavipa vimutu: —Éti ímahayare eta anuma téjiacayare, énapa ena ángeleana tiúcupau­cha­nua­nayare núti Manere­ji­ru­nuhi ema Viya —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Te mapana­quenepa sache eta táetavi­si­ravahi, natiarihi ena araimanahi eta te avasare Caná te tinapaica eta Galilea. ");
INSERT INTO ignNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tásiha, esu maena ema Jesús, ánaqui suávinehi taicha sucaichu­ha­si­quenehi ésu. Éneri­chuvare ticaichu­ha­si­hivare ema Jesús, vítipa viti máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tacahe, ema arayenahi tacaima­marapa téchuriacapa eta máeresahi vino. Esu maena ema Jesús suíchapa ema suchicha: —Téchuria­canapa eta náeresahi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tásiha, ema Jesús majicapapa: —Picata­jicanu, mémechicha. Vuíchaha picuca­mesanu. Nímahaine núti te táuripa. Nútipa néchinava —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tásiha, suíchavacapa ena tésiri­canahi: —Tiuri, ñímaháinepa éñi. Esuapayare éti eta ñivanai­ripiana —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tacahe, tatiarihihi eta sáisihi ichapehiana tinajana, márihiana. Nayupi­sareana ena israelítana tayehe eta nayehe­repiana. Eta táichape­hi­va­vacahi eta tinajana, cíncohi lata eta tacavacu. ");
INSERT INTO ignNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tacahe, ema Jesús mavane­ca­vacapa ena tésiri­canahi: —Eyana eyereca eta une. Ínica­chayare eta juca tinajana —máichapa. Tacahe, náinica­ca­ji­ca­vacapa éna eta tinajana. ");
INSERT INTO ignNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tásiha, ema Jesús mavane­ca­vacapa: —Tiuri puiti, eveha ániamaina, eyana íjaraca ema téchapa­jirica eta juca piesta —máichavacapa. Tacahe, tiyananapa éna, náijara­panahi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mavehapa masamaecapa eta une, vínoripahi éta. Váhisera máechahini éma táviha­hipuca tásihahi éta. Nacarichu ena tésiri­canahi náechahi eta únerahi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Tacahe, ema téchapa­ji­ricahi eta piesta máichuhapa ema arayenahi. Máichapa: —Namutu ena achaneana te térana, tativa naera eta tiúriamapana vino. Tapaenumava te ticava­ha­ha­sianapa, náerapa eta vino váhipanaichu táuriamahini. Pítisera, apana eta pipane­reruhi. Tiúrihi eta vino píjara­ru­havihi tativa. Puítisera eta juca vino, tétavi­cavahi eta táuriamavahi. Tacachu­ri­ca­rinehi tamutu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eta juca táinapuiruhi tiáramicare máimerecahi ema Jesús, tayehe eta avasare Caná. Ichape­rinehi eta viáramirahi viti vineca­panahi eta juca máimere­sirahi eta máitupa­ji­jia­si­ravahi. Tacahe, ichape­rinehi eta visuapirahi viti máimitu­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te táequenepa eta juca, viyana­varepa te apana avasare ticaijare Capernaum. Vimutupaipa, esu maena, ena mapara­pe­naveana, vítipa viti máimitureana. Vinasipa jácani sácheana eta ánaqui. Vipaenumava viyanaya te Jerusalén. ");
INSERT INTO ignNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tacahe, eta jena sácheanahi, tiánehiripa eta Pascua, vipiestarahi víti israelítana. Ema Jesús tiyanapa tayehe eta avasare Jerusalén, vítipa víti máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te vítecapapa, viyanapa visiapahi tayehe eta Templo. Máimahainehi ema Jesús ena títsiri­pe­re­ca­rahiana eta plata, énapa ena tíjara­re­canahi eta vuíyeana, eta uvesana, étapa eta palómana. ");
INSERT INTO ignNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eta máimairahi éna, máepiyacapa eta machicute. Máquiji­mu­ríhapa eta naplataneana te apaquehe. Máequehe­pui­cha­vacapa eta namesarana. Macuchu­chu­ji­ca­vacapa namutu, étapa eta sárareana náijara­re­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tásiha, máichavacapa ena tíjara­re­canahi eta paloma: —¡Ecuchuca eta júcana eta te juca mapenahi ema Tata! ¡Vahi étaina ícuchina éti íjara­recana eta tájipa­racana! —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tacahe, viti máimitureana, eta vímairahi eta juca, eneva­nerine véchava eta táechaji­riruva eta Salmo tayehe eta tamura­cavahi eta máichara­ra­cavahi ema víyarahaini David táichavenehi eta máetaviu­chirahi eta máimipi­cau­chirahi eta, mapena ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jéhesare, enurujipa títeca­panapa ena tuparai­rucana. Nayase­recapa éma: —¿Tájaha tacayema eta picuchu­si­ravaca ena vichamuriana? Pímija­cha­va­hipuca vanairucavi me Viya. ¡Pímechahavi eta tiáramicare te yátupi­hipuca pivanahi eta juca! —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ema Jesús majica­pa­vacapa: —Te iáquipai­ca­ya­repuca éti eta juca templo, nútisera nucaechepuca te mapana­quenéna sache —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ena tuparai­rucana najica­pa­varepa: —Cuarenta y seis año eta tayerevahi eta náepiya­re­sirahi eta Templo. ¡Tétavi­cavahi eta pisiña­va­vai­sirahi picaemu­ña­va­yarehi picaeche­pu­cayare te mapana­quenéna sache! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eta máichira­vacahi ema Jesús, máechaji­sihahi éma eta táechepu­si­rayare eta máquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eta tacahe, te tiyerehi, te táequenepa eta máechepu­sirapa ema Jesús te máecari, véchavahi viti máimitureana eta juca mameta­rapihi tayehe eta máechepu­si­ra­yarehi. Eta tacahe, visuapa­rinehi eta táechaji­si­hairahi eta Sagrada Escritura eta mayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Eta manasi­rai­chahahi ema Jesús te Jerusalén, te Páscuamuhu, camurihi eta tiárami­careana máichaque­neanahi. Camuria­na­hivare ena achaneana tímahanahi. Tásiha, nasuapahi eta émairahi ema Cristo nacucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Émasera vahi macasi­ña­vahini eta nayehe taicha máimati­vacahi éna, vuíchaha yátupi­nahini eta náehisirahi éna. ");
INSERT INTO ignNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Taicha éma, tétavi­cavahi eta máitupa­ji­jia­si­ravahi, máimatirahi tamutu eta napane­reruana ena achaneana te amahe eta nasamureana. ");
INSERT INTO ignNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Matiarihi ema achane téhica­rai­ricahi ena fariséoana. Ticaijare Nicodemo. Ema maca achane, tétavi­cavahi eta macuna­cha­ca­revahi taicha máestrohi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tacahe, eta jena yátiquenehi, ema Nicodemo tiyanapa mapaipiu­cha­pa­napahi ema Jesús. Tacahe, eta náechaji­ri­si­ravahi, macahepa ema Nicodemo: —Tata maestro, véchahi eta vanairu­cavihi me Viya eta juca pítesirahi pímitu­si­ra­ha­vi­panahi. Taicha nájina apanaina achane títurue­que­ne­haimahi eta juca tiárami­careana píchaque­neanahi píti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ema Jesús majicapapa: —Puiti numetacavi eta juca yátupi­queneana: Nácani navarahaya títuji­cavana tisiapana tayehe eta mávasa ema Viya, tacamunuhi náitsiva­chayare eta náitaresira. Te vahi yátupina eta náijara­si­ravaina eta máitsiva­chi­ravaca ema Espíritu Santo, vahi títuji­ca­va­naimahi tisiapana eta te mávasa ema Viya. Tímicu­ti­ji­ri­ca­va­yarehi tiápecha­va­na­yarehi tiúchucana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tacahe, ema Nicodemo vahi mácaicu­tia­rahini eta máichirahi ema Jesús. Váhisera macucha­paimahi eta máitame­ta­sirahi ema Jesús. Ánipa macahe: —Váiparinehi vichavaimahi eta amúya­ha­vi­nahíni viti ichasiana, vichava­hi­va­re­pucaini visiapahini te sujuhe esu ticachi­chahavi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Majica­pavare ema Jesús: —Pisama­nuchaha. Te tiúchuca eta amuya te sujuhe esu taena, tímati­carehi eta machichairahi ema suima. Tacuti­quenehi, nácani mávaháruana ema Espíritu Santo, tiápecha­va­nayare tépanava eta náitare­si­ra­nayare, taicha machicha­ripahi. Nutupiruva numetacavi: Nacarichu ena machicha­naveana ema Espíritu Santo tisiapana eta mávasa ema Viya. Te tacuija eta machichai­rahéna éti, tájina vahi ítuji­ca­vaimahi esiapa. ");
INSERT INTO ignNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Vahi picuarami eta juca níchiravihi: Táitaure­vaquene ticachi­cha­he­yarehi ema Espíritu Santo. ");
INSERT INTO ignNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Eta juca tímicu­ti­ji­ri­cavahi eta técaticava, tacarichu visama eta tacaemaira. Váhisera tácaeche­rahini. Ene nacahehi ena mávahá­ruanaipa ema Espíritu Santo. Nanasirichu eta náimahi. Ticaitsi­vai­pasera eta náitaresira —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tásiha, ema Nicodemo mápecha­varepa mayasereca: —¿Tájahasica tacayema eta juca? ");
INSERT INTO ignNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ema Jesús máichavarepa: —Tétavi­cavahi eta picuna­cha­careva píti, taicha tiúrihi eta pímitu­si­ra­vacahi ena vijaneanana. Tasapi­hasera vahi pímatie­que­ne­hahini eta júcana. ");
INSERT INTO ignNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pisama­nuchaha. Yátupiquene eta numéta­si­rávihi. Tatupi­ruvahi eta néchaji­sihahi eta táichara­ra­ca­vanahi te anuma taicha nímahaipa. Étisera vahi esuapa­nuimahi eta numeta­si­rahehi eta nímaha­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Te cape juca sácheana, nímicu­ti­chi­nahehi eta táichara­ra­ca­vanahi te juca apaquehe tayehe eta táichara­ra­ca­vanahi te anuma. Étisera vahi esuapa­nuhini. Tavetijipa eta emasua­pi­ranuya te nutupi­ruvahi numetacahe eta táichara­ra­ca­vanahi te anuma. ");
INSERT INTO ignNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuti Manere­ji­ru­nuhi ema Viya, nucavasahi núti te anuma. Tásiha, núcupaicahi eta numeta­si­raheya. Nájina apanai­nahini mácani mameta­ca­hehini eta táichara­ra­ca­vanahi te anuquehe, taicha nájina nayanahini nápanahini te anuma, eta jácani náimatihini. ");
INSERT INTO ignNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Acane, eta napaisira ena viáchuca­na­veanaini eta te mávapahi apaquehe, táechucapahi eta quichareana ena masuapa­ji­rai­ra­ha­napahi mayehe ema Viya. Tacahe, ema víyarahaini Moisés máepiyacahi eta metal eta táimahi eta quichare. Manacahi te anuquehe eta te yucuqui. Tásiha, ena achaneana táechureana eta quichare, te náesenica eta quichare máepiyaru ema Moisés, tinara­ca­napahi, vahi náepena­pahíni. ");
INSERT INTO ignNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ene nucaheyare núti apana, tinaca­nua­na­yareva te anuquehe. Eta níchara­ra­ca­vayare apaesa nucuchu­cu­hapahi namutu ena nácani ticasi­ña­nua­na­ya­repahi. Tásiha, máichecua­ra­qui­renapa eta náitare­si­rayare. Tájina ticami­tie­que­ne­ha­va­caimahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Taicha ema Viya, tétavi­cavahi eta máemuna­si­rahavi viti achaneana te juca apaquehe. Eta máemuna­si­rahavi, máijaracahi ema macari­chu­quenehi Machicha eta máucupai­sirahi eta ani viyehe. Mavarahapa tíjara­ca­haviya máichecua­ra­qui­rénapa eta vítare­siraya vimutu viti vicasi­ñanahi éma. Tájina ticami­tie­que­ne­ha­ha­vimahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taicha ema Viya, vahi tácahehíni eta mapane­reruhi eta máucupai­sirahi ema Machicha máicuña­ca­ha­vihini viti achaneana. Étasera eta tímitecahi éma, ticuchu­cu­ha­ha­viyare vimutu. ");
INSERT INTO ignNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","19","Taicha nácani ticasi­ña­nayare ema Machicha ema Viya, vahi ticaicu­ña­naimahi. Nácanisera vahi nácasi­ñahini éma táimicu­ña­ca­va­ca­yarehi eta naviure­vanahi éna. Taicha vahi náuricahini eta tamicau­chi­ra­vacahi eta majaraiva ema Cristo táucupairuhi te juca apaquehe. Étachucha náurica eta timapicu taicha vahi návara­hahini tácaeche­rahini eta náichirahi eta tamauri­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Taicha nácani tíchanahi eta tamauri­queneana, nacaticha eta majaraiva ema Viya. Váiparinehi napauchaimahi, namava­rairahi tacaeche­rahini eta náichirahi eta tamauri­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Énasera ena tisuapanahi yátupi eta máechaji­riruva ema Viya, náurica­yarehi napaucha eta majaraiva. Jéhesare ticaeche­ra­na­sarepa eta machane­ra­na­ripahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te táequenepa eta juca, tiyana­varepa ema Jesús, tayehe eta avasa­re­chichana te táunava eta provincia Judea. Véhicahi viti máimitureana. Vinasipa jácani sácheana eta ánaqui. Viti máimitureana vícacha­si­ri­caripa ena achaneana tivara­hanahi náehicaya ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tásiha, ema Juan tícacha­si­ri­ca­hivare te jena Enón tachacayahi eta Salim, taicha ánaqui tatiarihihi eta une. Ena achaneana napauchahi éma. Jéhesare máicacha­si­ca­va­ca­paipahi ena tivara­hanahi náinaji­cayare eta napeca­turana. ");
INSERT INTO ignNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Eta juca máichahi ema Juan tamira­hu­paichaha eta jena sache eta náerata­si­ra­yarehi éma.) ");
INSERT INTO ignNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tacahe, te jena sácheana, ena religiósoana tiyananapa náimiyu­se­ma­ca­vacapa ena máimitureana ema Juan, nametacahi eta vicachu­ri­si­ra­vacahi viti máimitureana ema Jesús taicha tiápaju­mu­ria­va­na­panahi ena vícacha­si­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tacahe, eta nasemirahi ena máimitureana ema Juan, tiyananapa nameta­panahi éma. Náichapa éma: —Tata maestro, pímahaini ema maena péchaji­riruhi cape te tachausi eta juca cajacure Jordán. Ema Jesús pímijarecha Cristo, tícacha­si­ricahi puiti éma. Jéhesare, namutu­ya­rehini náehica éma —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tásiha, ema Juan majica­pa­vacapa: —Vahi ecueñamava. Ema Viya, éma téchahi eta máijara­sirahi eta máituca­quenehi nácani manere­jiruana. Németeaca tíjaracahi ema Viya eta máitupa­ji­jia­sirava ema maca Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Éti échavahi eta numeta­si­rahehi eta vahi nútinahini ema Cristo. Yátupisera nucava­nahini eta nínapu­mi­rau­chi­ra­ya­repahi éma, numeta­cavaca ena achaneana natsecavahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Núti nímicu­ti­ji­ri­sinahe: Te natiarihi ena araimanahi, namutu ena nacaichu­ha­si­queneana tiúrisa­mu­reanahi eta náimairahi ena araimana. Nacunachahi ema arayena. Ene nucaherihi núti eta núrisa­mu­revahi eta nímairahi puiti eta nacuna­chirahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Éma, te jácani mapaisi­ha­ya­repahi, tiápaju­ca­va­ya­repaipa eta macuna­cha­ca­revaya. Éma, mapaenu­mavapa tépanava eta macaema­ta­neasira ema Viya. Núti núrisa­murehi tayehe éta. Núti, tiánehipa eta nítauchi­rainapa eta nématane. Tásiha, váhirichu nucuna­chacare núti —macahepa ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ema Jesús, máimati­rinehi tamutu eta táichara­ra­ca­vanahi te anuma taicha másiha­quenehi éma te anuma. Víti achaneana viávihahi vicava­sanahi te juca apaquehe, vímatihi étachucha eta táichara­ra­ca­vanahi te juca apaquehe. Émasera ema Jesús, eta másihairahi te anuma, tímatihi tamutu, tiápaju­pa­navahi eta máitupa­ji­jia­si­ravahi. Ticachu­ri­ca­havihi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Éma, tímitecahi eta mameta­si­rahavi tamutu eta máimaha­que­neanahi étapa eta masama­queneana te anuma. Nájina­ya­ré­nisera nasuapahini eta macaye­ma­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Vítisera viti visuapanahi eta mameta­rapiana, vímatihi eta yátupihi eta máechaji­ri­ruvana ema Viya mámaque­neanahi ema maca Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taicha éma, vanairucahi me Viya, máechaji­si­ha­yarehi eta máechaji­ri­ruvana ema Viya. Éneri­chuvare tétavi­cavahi eta máimica­ta­sirahi ema Espíritu Santo taicha mávahácahi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ema Vicaiyaquene máemunacahi ema Machicha. Eta tacahe, matupa­racahi eta émaira­yarehi téchayare tamutu. ");
INSERT INTO ignNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Eta tacahe, nácani ticasi­ña­nayare ema Machicha, máichecua­ra­qui­reyare eta náitare­siraya. Namutusera ena macasi­ña­ra­hanahi ema Machicha ema Viya, vahi títare­ca­naimahi, taicha tanasihi eta naviurevana táichavenehi eta napeca­tu­ranahi. Ticaicu­ña­na­yarehi máitava­ca­c­ ayare. ");
INSERT INTO ignNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Tacahe, camurianahi ena tivara­hanahi tíjara­ca­vanaya náehicaya ema Viáquenu. Tásiha, viti máimitureana vícacha­si­ca­vacahi éna. Émasera ema Jesús vahi máicacha­si­ri­cahini. Camuri­panana ena vícacha­siruana nayehe ena máicacha­siruana ema Juan. Tacahe, ena fariséoana nasamai­ri­ricapa. Náramipa. Navanecapa ena tiyase­re­canaya. Tacahe, te tisamau­chavapa ema Jesús eta napane­reu­chirahi, majuni­jicapa eta Judea. Tiyanapa tichavahi tayehe eta Galilea, vítipa víti. ");
INSERT INTO ignNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Eta vipaisi­rapahi te achene, viánucu­hapaipa eta te provincia Samaria. ");
INSERT INTO ignNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Te la dócepa te sache eta víteca­pirahi te távihahi eta nória máepiyaruhi ema víyarahaini Jacob. Máijara­ca­si­cha­ripahi ema machicha José eta juca mayeheni apaquehe. Eta nória, tachacayahi eta avasa­rechicha ticaijare Sicar. Tacahe, eta mavitai­ra­paipahi ema Jesús, tícheca­numapa te tachausi eta nória. ");
INSERT INTO ignNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Eta víchesirahi, viyanapa viti máimitureana vivacha­re­pa­na­yarehi eta tinicacare te avasare. Macari­chuipahi ema Jesús. Sucahe­painecha esu ésuna esena indigenahi samari­tana tícapa­na­yarehi. Tacahe, máechajicapa ema Jesús: —Nuchicha, picata­jicanu picajinu une —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tásiha, esu esena sujicapapa: —Píti israelí­tavihi. ¿Tájaha tacayema piyaseacanu eta une, nuti samari­tá­nanuhi, vahi pijanea­na­nui­nahini? —suíchapa. (Ani tacahehi eta suéchaji­ri­sirahi, taicha ena israelí­tana énapa ena samari­tá­noana vahi náuriana­ca­cahini.) ");
INSERT INTO ignNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tásiha, ema Jesús majicapapa: —Te pímatihini eta mavara­ha­que­neanahi tíjaracavi ema Viya, téhevare pímati­nu­hi­varéni núti nuyasea­cavihi eta une, németeaca piyasea­ca­nui­pahíni eta une ticaita­re­carahi. Tásiha, núti níjara­ca­vihíni —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tásiha, esu esena suíchapa: —Tata, tiúpenahi eta juca nória. Píti, tájina enurena piviyahini eta une. ¿Távihasica tásihayare eta une ticaita­re­carahi eta pivara­ha­quenehi píjaracanu? ");
INSERT INTO ignNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Eñi viáchuca­quenéni Jacob, vímaeque­néhahi eta juca nória ñépiyaruhi. Nérira­rénihi eñi énapa ena ñichicha­naveana. Énerichuhi táerihahi eta ñiyeheana sárareana. ¿Piti pímija­cha­vapuca picuchu­cahini eta tiúriamapana une? —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ema Jesús majica­pa­varepa: —Namutu nácani térana eta juca une tiápecha­va­na­yarehi timauneanaya. ");
INSERT INTO ignNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nácanisera téranayare eta une níjara­ru­yarehi núti, vaipa tiápecha­va­naimahi timauneana. Taicha tacaju­ru­ca­yarehi eta náurica­careva. Tiúrinai­na­varepa eta náitaresira. Ticaita­re­ca­va­cayare máepena­ca­cayare —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tacahe, esu esena, eta susamirahi eta máechaji­ri­ru­vanahi, suíchapa: —Tata, píjara­ca­nupaini eta une ticaita­re­carahi, apaesa vaipa nucuape­chavaini numaune. Váipavare nucuite­cahini eta te juca nória népanahini une —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ema Jesús majica­pa­varepa: —Piyana, píchuhapana ema pima. Piáma eta ani. ");
INSERT INTO ignNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ésusera sujicapapa: —Nájina nímaina. Tásiha, ema Jesús máichapa: —Pitupiruva eta juca pimeta­si­ranuhi eta nájinairahi pímainahini. ");
INSERT INTO ignNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cíncoana­paipahi ena pímana­vea­nainihi. Tásiha puiti, ema picacha­ne­quenehi váhivare pímainahini. Pitupi­ruvahi eta péchaji­ri­ruvahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tacahe, tiárame­ca­rinehi esu esena eta susamirahi éma eta máichirahi. Tásiha, suíchapa: —Tátachicha, németea­cavihi eta pítique­né­ravihi profeta. Nuvaraha pimeta­canuya puiti, ¿távihapuca eta yátupiquene viyuja­ra­si­ra­re­yarehi? ");
INSERT INTO ignNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Taicha ena viáchuca­na­veanaini samari­tá­noanaini eta nayuja­ra­si­raréni eta te juca táinahu eta cerro. Puíticha tanasi­richuhi eta viyuja­ra­si­rarehi. Étisera eti israelítana, eta emetarapi eta viyuja­ra­si­ra­reyare ñe Viya téhenapa te Jerusalén —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ema Jesús mametacapa: —Nutupiruva numetacavi, nuchicha, ánipa táenasi­hayare puiti váipa tácame­saimahi íteca eyujaraca me Tata te juca táinahu eta cerro étaripa eyana­hi­pucaini te Jerusalén. Tamutuinapa eta táurivayare eta eyuja­ra­si­hayare. ");
INSERT INTO ignNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eti samari­tánoana, apaesa­chi­charichu eta ímatirahi ema Tata eyuja­raurehi. Vítisera vímatihi ema viyuja­raurehi, taicha viti israelítana víti vicatu­pa­rahahi viámayare eta máechaji­ri­ruvana ema Tata eta macuchu­cui­rayare namutu ena achaneana ticasi­ña­vanahi mayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Numeta­caviya eta apana: Ema Tata, tiávihahi te anuma, jéhevare éma, yátupi­quenehi Viya. Vahi máteji­nahini eta maeche macutihini viti achaneana. Eta tacahe, nácani tiyuja­racana mayehe, tatupi­ru­va­yarehi eta nasamure, tisuapa­ji­ra­hia­na­hivare tayehe eta máechaji­riruana. Vahi táca­me­saimahi ticasi­ña­rajiana. Eta juca tacahe­yarehi eta mavara­ha­que­neanahi ema Tata eta eyuja­ra­si­ra­yarehi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tásiha, esu esena suíchapa ema Jesús: —Téchacarehi eta ñíteca­pi­rayare te juca apaquehe eñi Cristo, ñivaneruya eñi Viya. Téchaca­re­hivare eta ñimeta­si­ra­ha­viyare tamutu eta yátupi­que­neanahi. ¿Píti, péchapuca tájamu­hu­ya­repuca eta ñíteca­pi­hayare? ");
INSERT INTO ignNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ema Jesús majicapapa: —Nútira nuti mavane­runuhi ema Viya. Nútira ecucha­pa­que­nenuhi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tásiha, víteca­panecha viti máimitureana. Tacahe, viáraminehi eta máechaji­ri­si­ravahi eta suyehe esu esena indigenahi. Vivarahahi viyasereca esu esena tájahapuca suvaraha eta mayehe. Vivara­ha­hivare viyasereca ema Jesús tájaha tacayema eta máechaji­sirahi esu esena. Váhisera vipatsicava viyase­re­cahini. ");
INSERT INTO ignNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tásiha, esu esena sunaquicapa eta suyupi. Tijunapapa tiyana te avasare, sumeta­pa­na­vacapa ena achaneana. Te títecapapa, suíchavacapa: ");
INSERT INTO ignNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Yare, ímahaya eñi achane profeta. Ñímatihi tamutu eta níchaque­neanahi néjeca­pi­ra­vanahi. Tamutuhi ñicuchu­chu­ji­si­nánuhi. Núti németeaca éñiripa eñi Ñivaneruhi eñi Viya, éñiri­pavare eñi vicucha­pa­quenehi ticaijare Cristo —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ena achaneana sumeta­ruanahi tiyananapa náehica esu eta te mávihahi ema Jesús, náimaha­pa­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eta nayere­va­paichaha ena achaneana suíchuha­que­neanahi esu esena, viti máimitureana víchuhapa ema Jesús tinica­nu­ma­yarehi. Víchapa: —Tata maestro, yare pinicanuma, apaesaina piávamina. ");
INSERT INTO ignNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tásiha, éma tijica­pa­havipa: —Núti, jucarihi eta tinicacare tanica­sarehi eta náchaneva emáima­tié­que­néruhi éti —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tásiha, véjeca­pa­va­sa­murepa víti. Víchacacapa: —¿Náenicai­papuca jácani? ");
INSERT INTO ignNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ema Jesús máimatihi eta vipane­re­ruanahi. Máichahavipa: —Eta ticaita­re­canuhi núti, eta nítauchirahi eta mavanai­ripiana ema Nucaiyaquene, taicha nuvaraha nítauchaya tamutu eta nucaema­ta­neasira éma. ");
INSERT INTO ignNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eta viyeherepi te véchaji­riruva: “Puiti vítapa eta vévasirapa eta trigo, cuátroyare caje eta vicuchapira eta vicuru­ji­siraya” vicahehi. Puítisera numetacahe núti: Vaipa táyeremahi eta vicuru­ji­si­rainapa. ¡Ésenica puiti te achene! Nárajapa ena achaneana ena névara­quianahi­­. ");
INSERT INTO ignNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ema Tata tíjara­caheya eta ícuchiyare te ímica­ta­ca­nuyare eta vicuru­jisira ena nani achaneana apaesa náuchucu­hayare, máichecua­ra­qui­reyare eta náitaresira. Tásiha, tétavi­cavaya eta viúrisa­mureva vimutu: éti, nútipa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ena achaneana, ticati­sa­mu­re­vanahi eta náechaji­risira: “Vítira vévacahi eta vésane; apana­pasera ema ticurujica” nacahehi. ");
INSERT INTO ignNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Vítisera te juca vivapi­na­vayare. Núti níchuhahehi eta ecuru­ji­siraya eta névaruhi. Éneri­chuvare nararihihi ena tínapu­canahi viyehe eta nacaema­ta­nerahi eta juca. Puiti vivapi­navaya eta vícuchiyare taicha vicuti­cacahi eta vicaema­ta­nea­sirahi ema Viya —máichahavipa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ena ticava­sanahi te jena avasare, camuri­que­neanahi ena tisuapanahi eta émairahi Mavaneruhi ema Viya táichavenehi eta suíchirahi eta macuchu­chu­ji­si­na­quenehi tamutu eta suíchaque­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tásiha, tiyananapa tiácapa­haviana. Te títeca­panapa, émaquenepa nasamahi. Tásiha, náechajicapa mánasi­pa­nahini nayehe. Masuapa­hisera ema Jesús. Apina sache eta mayerevahi, vítipa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tacahe, eta manasi­pa­nairahi tayehe eta avasare, namutupa nasamahi eta máimitu­rapiana. Tacahe, camuria­nainehi ena tisuapanahi, téhica­na­hivare éma. ");
INSERT INTO ignNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tásiha, náichavarepa esu esena: —Puiti émaquenepa visamahi. Vaipa tácari­chuhini visuapahini eta pimeta­rapihi. Véchapa viti apanava eta émaque­nérahi ema Cristo, ema vicucha­pa­quenehi, ema ticuchu­cu­ha­ha­viyare vimutu viti achaneana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Te táequenepa eta apina­quenehi sache, tiyana­varepa ema Jesús; macaijuhe eta te provincia Galilea. Véhica­pai­chu­hivare víti apanava. ");
INSERT INTO ignNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Eta mayani­ra­yarehi eta Galilea, vahi mácasi­ña­va­hichaini eta masuapa­ca­re­vai­nahini nayehe ena achaneana. Émarichuhi, ani macahehi eta máechaji­ri­ruvahi: “Mácani profeta, vahi tivapi­na­vanahi eta najaca­pirahi ena achaneana te mávasa”. ");
INSERT INTO ignNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Téhesera ­ te máiteca­pau­chapaipa ema Jesús eta avasa­re­chichana tinapai­canahi te Galilea, namutu najacapahi. Taicha náimatipa éma taicha náimahapa eta tiárami­careana máichaqueneana te mávihaipa te Jerusalén te jena piéstairahi eta Pascua. ");
INSERT INTO ignNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tásiha, tiápecha­va­varepa mayanaucha ema Jesús eta avasare Caná, te máepiya­sinehi vino eta une. Te apana­hivare avasare ticaijare Capernaúm, matiarihihi ema majupaha ema rey. Macaju­ma­quenehi ema machicha. ");
INSERT INTO ignNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te masamai­ri­ricapa ema achane eta máiteca­pi­raipahi ema Jesús te Caná, tiyanapa matanu­panahi. Eta máichimavapa, mayaseacapa eta macata­ji­cahini máehica­va­nehini te mapena, macana­ra­pa­nahini ema machicha taicha ema macaju­maquene tiánehiripa tépena­ya­rehini. ");
INSERT INTO ignNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Émasera ema Jesús máimatipa eta masamure ema achane, tásiha, máichapa: —Éti vahi esuapa­nuimahi, te vahi nímechahehi eta tiárami­careana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Émasera ema achane máichapa: —Picata­ji­ca­nuchucha, tátachicha. Péhicanu, machu máepenacaru ema nuchichasami —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ema Jesús majicapapa: —Tiuri, piyana. Vahi picueñamava, ema pichicha vahi tépenaimahi. Máenahi tinara­caipahi nícha —macahepa. Tacahe, ema achane masuapapa eta máichirahi ema Jesús. Tiyanapa tichavahi te mapena. ");
INSERT INTO ignNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te tiánehi­paipahi títecapa te mapena, nácapapa ena macaju­rureana. Náichapa: —Tata, ema pichicha tinara­caipahi. ");
INSERT INTO ignNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tacahe, ema mayase­re­ca­vacapa: —¿Tájaha hora te tinaracapa ema nuchicha? Éna náichapa: —Cape te la una te cáperehi, táetaviacapa eta fiebre —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tásiha, ema achane máechapa étairaichuhi eta hora eta mameta­sirahi ema Jesús eta manara­siraipa ema machicha. Tacahe, ichape­rinehi eta masuapirahi éma, énapa éna machicha­na­veanahi te peti, eta émairahi ema Cristo, Mavaneruhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eta juca eta tápinanehi eta tiárami­carehi máichaquenehi te Galilea, te táequenepa eta machavirahi eta te Judea. ");
INSERT INTO ignNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Te táequenepa eta juca, tatiarihihi eta apana piesta eta viúruji­si­rávana te Jerusalén. Tiyana­varepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te jena viávasa, tatiarihihi eta ichape tapaja náimisia­pirare eta uvesana nacapa­ruasana. Tatiari­hi­hivare eta ichape noque vímija­rechahi Betesda. Ticayehehi cinco eta cúlerureana. ");
INSERT INTO ignNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Eta návihahi ena nacaju­ma­queneana púchuquiana, masariana, énapa ena muraca­quihana. Namutu éna, ticucha­panahi eta macaya­mu­risira eta une ema ángele. Tásiha, namutu tiyanana téchipa­pai­cavana te une, taicha tímija­chavana mácani tínapuca téchipaicava, tacana­ra­ca­yarehi eta jácani majuma. ");
INSERT INTO ignNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tacahe, matiarihi ema achane macaju­maquene. Tréintayocho áñoripahi eta macata­ji­vairahi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tacahe, te tisiapa­paipahi ema Jesús, máimahapa ema achane macaju­maquene tívecahi. Máimativare eta tayere­vaipahi eta macaju­mairahi. Mayase­recapa: —¿Pivaraha pinaraca, nuchicha? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tásiha, ema achane majicapapa: —Nuvaraha, tata. Nájinasera ticasia­pa­nuimahi tayehe eta noque, te tiyamurieca eta une. Ticachu­ri­ca­nua­na­paraca ena apamuriana nucuti­queneana nacaju­ma­queneana —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tacahe, ema Jesús máichapa: —Péchepuca, piveha eta pímacaraji. Piyana pipaica —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tásiha, eta máichirahi ema Jesús, eneva­ne­rinehi tinaraca ema achane. Mavehapa eta máimacaraji. Tiyanapa tipaica. ");
INSERT INTO ignNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eta sache manara­sirahi ema achane, sávaru­muhuhi. Ticapi­cahuhi eta jena sache nayehe ena israelítana. Tacahepa, te náimahapa ena tuparai­rucana, nacajachapa éma. Ánipa ná­ icha: —¿Tájaha tacayema vahi pipicaucha puiti juca sache tacapi­ca­hu­quenehi? Vahi vísapa piámahini eta pímacaraji puiti juca —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ema achane majica­pa­vacapa: —Vahi nútina tásiha. Ema maca achane ticana­ra­canuhi, tivane­canuhi. Máichanuhi: “Piveha eta pímacaraji. Piyana pipaica” —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tásiha, éna nayase­recapa: —¿Nájahasica ema tivane­cavihi pipaica eta piámirapahi eta pímacaraji? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Émasera ema achane vaipa máimatihini eta máijare ema ticana­racahi. Váipavare náetupia­ca­ca­rehini ema Jesús te namuri ena camuri­queneana achaneana taicha tiyana­ripahi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Téhesera te táequenepa, tiyanapa ema achane eta te Templo. Ánaqui títeca­pa­varepa ema Jesús. Te máimahapa ema Jesús ema achane macana­raruhi, máichapa: —Pímaha, vaipa picuapechava picuca­pe­catura, machu tachavauchavi eta pijuma, máchuvare pávetiji —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tacahe, eta máimatirapa, ema achane tiyanapa mameta­pa­navaca ena tuparai­rucana eta émairahi ema Jesús ema ticana­racahi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","18","Eta tacahe, ena tuparai­rucana tisemanapa. Ichape­rinehi eta nacatia­na­sirahi ema Jesús táichavenehi eta macana­ra­sirahi te jena sache sávaru­muhuhi tacapi­ca­hu­quenehi. Tásiha, títeca­panapa, éna ticara­ta­ca­na­ya­rehini ema Jesús. Émasera máimatihi eta napane­reruana. Tacahe, máichavacapa: —Ema Tata tamutuchucha sache ticaematane. Ene nucahe­yarehi nuti apana. Nítauchayare eta mavanai­ripiana —macahepa. Eta nasamirahi ena tuparai­rucana eta máichira­vacahi, naveti­jipaicha eta nasemirahi. Navarahapa nacapa­ca­va­ne­yarehi éma. Eta tiviuchahi eta macana­ra­re­sirahi te sávaru­muhuana, náimija­chirahi máepuruhi eta nayeherepi. Taveti­jipaicha eta máimicae­che­ra­chi­ravahi Machichairahi ema Viya, Víyairahi ema ­ apana. ");
INSERT INTO ignNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Éneri­chuvare ema Jesús máichavacapa: —Nutupiruva numetacahe: Nuti Machicha ema Viya, eta nutupa­ra­hanahi mayehe, váiparinehi nútiji­ri­ca­vaimahi nícha jácani nuvara­ha­que­neanahi. Núti nímatie­que­nehahi tamutu eta máemata­ne­repihi ema Ticachichanu. Étaya­reichuhi níchayarehi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taicha yátupihi eta máemuna­si­ranuhi ema Ticachichanu. Eta tacahe, tímechanuhi tamutu eta máemata­ne­repiana. Éneri­chuvare tíjara­ca­nu­yareva eta nímechi­raheya eta apamuri tiárami­careana. Tiápaju­ca­vayare eta tárami­ca­re­vayare, apaesa iárami­ri­neyare, epica­yareva. ");
INSERT INTO ignNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ema Tata marataha macaechepuca ena náepena­queneana, máimicha­va­yarehi macaita­re­ca­vacaya. Énerichuva nuti Machicha, nurata­havare nucaitareca nácani nuvara­ha­que­neanaya, níjaraca eta náitare­siraya. ");
INSERT INTO ignNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nucatu­pa­ra­ha­hivare mayehe ema Tata eta nímairaya eta nacaicu­ñai­rayare namutu ena náejeca­pa­va­que­neanahi. Vaipa émainahi tícuñareca éma. ");
INSERT INTO ignNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taicha mavarahahi epicauchanu nuti Machicha, tácutirichu eta epicau­chirahi ema Tata. Nácanisera vahi tipicau­cha­nuanahi núti, váhivare napicau­chaimahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yátupi­que­nevare numetacahe eta juca apana. Nácani ticaqui­ña­nayare tisuapa­nayare eta néchaji­ri­ruvana, nasuapavare eta nucava­na­hirahi mayehe ema Tata, éna títare­ca­nayare, vaipa ticaicu­ña­naimahi. Taicha éna, tiúchucu­ha­naripa tayehe eta náicuña­yaréni te yucu. Náicuchihi eta náitare­siraya. ");
INSERT INTO ignNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tacutiquene nutupiruva numetacahe nuti Machicha ema Viya. Táiteca­pa­quenepa puiti juca sácheana, tisama­nua­nayare ena achaneana, tayanapane tépenahi eta náchanevana. Te nasuapa­ji­ra­hipuca, nucaita­re­ca­va­cayare eta náchanevana. ");
INSERT INTO ignNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taicha ema Tata namutuhi marataha macaitareca. Ene tacahe eta máijara­si­ranuhi núti Machicha eta namutu­yareva nurataha nucaita­re­cavaca. ");
INSERT INTO ignNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Éneri­chuvare titupa­ra­canuhi eta nícuña­si­ra­va­ca­ya­re­hivare taicha yátupi­que­nenuhi manere­ji­runuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Vahi ecuarami eta juca numeta­si­rahehi. Járajapa eta sácheyare eta nasami­rayare namutu ena náepena­queneana eta nahu núti. ");
INSERT INTO ignNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Téchepu­ca­nainapa namutu te náecariana. Nácani tíchanahi eta táuriqueneana, títare­ca­nainapa. Énasera ena tíchanahi eta tamauri­queneana, ticaicu­ña­nainapa. ");
INSERT INTO ignNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Núti vahi nútiji­ri­ca­váimahi nícuñareca. Nucucha­pa­yarehi eta mavanairipi ema Tata, ema tivane­canuhi. Tacahe, te nícuñareca, vahi numapa­chi­chi­ji­caimahi, tatupi­ru­va­yarehi nícha. Taicha tacahehi eta mavara­ha­quenehi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Te nácarichu núti nútiji­ru­vai­na­chuchaini eta nímere­ruanahi, vahi tácame­sahini esuapa­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Váhisera nucari­chuimahi, taicha matiarihihi ema apana títame­ta­si­nanuhi, émaripa ema Juan Tícacha­si­ri­carahi. Nímatihi núti eta matupi­ruvahi eta máichaque­neanahi eta tímereu­chanuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Éti ecava­nai­ripipa nayasereca ema Juan te nájaha­nu­hipuca núti. Matupi­ru­va­hisera éma eta majica­pi­ra­vacahi eta nútique­neipahi éma ecucha­pa­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Váhisera étapa­ra­caimahi eta juca eta matiari­hirahi ema tímereu­chanuhi. Eta ticamu­nu­ca­re­panahi eta esuapi­ranuina apaesa iúchucuhaiya éti nicha núti. ");
INSERT INTO ignNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ema Juan tímicu­ti­ji­ri­cavahi timícau­chahehi tayehe eta mameta­rapihi eta eyehe, te jena sácheanahi esama­ra­ra­sirahi éma. Iúrisa­mu­reinehi ichape, taicha eta tamicau­chi­rahehi eta máechaji­riruva. ");
INSERT INTO ignNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Váhisera mácarichu eta máimicae­che­ra­chi­ranuhi ema Juan. Jararihi eta apana táimicae­che­ra­chi­ranuhi, tiápaju­pa­navahi eta tárami­careva. Taicha núti nicha eta némata­ne­repiana máijara­runuhi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Émaripa ema Tata tivane­canuhi. Éma, vahi macuti­hémahi éti achaneana. Vahi esamahini eta mahu, váhivare ímahaimahi eta máquehe. Téhesera te jena Sagrada Escritura, timeta­cahehi eta níteca­piraya. ");
INSERT INTO ignNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Éti vahi evara­hahini esuapa­nuhini nuti mavaneruhi éma. Éta tímereu­chahehi eta váhivare iúnacahini eta máechaji­ri­ruvana te esamureana. ");
INSERT INTO ignNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Éti, tamapuruji eta ecara­va­huirahi eta Sagrada Escritura. Ímija­cha­ri­papuca eta ticaita­re­ca­he­yarehi. Váhisera ímatie­que­ne­hahini, váhivare ácaicu­tia­rahini eta nútirahi táechaji­sihahi núti nucaita­re­ca­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tacutiquene vahi ávara­hahini epaucha­nuhini éti, níjara­ca­hehini eta ítare­siraya máitava­ca­cai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Núti vahi nácamesa nacuna­cha­nuhini ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Títecapa, nímati­he­vacahi emutu éti eta emaemu­na­sirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Núti nuvane­ca­si­va­richuhi me Tata eta nítesirahi. Étisera vahi esuapa­nuhini, váhivare ejaca­pa­nuhini. Téhesera te máitecahini mácani apana achane, tímija­cha­vapuca Cristo ema ecucha­pa­quenehi, masapi­ha­pucaini ema tisuapa­ca­rehini eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Éti, vahi esuapa­nuhini taicha eta evarairahi ecuna­cha­careva ena achaneana. Esapi­hachucha éti vahi ávara­hahini ecuna­chacare me Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Váhisera nútinayare numetauchahe eta me Tata. Máimaha­he­rinepa ema Moisés. Éma timetau­cha­heyare. Éti ímija­chavahi ticuchu­cu­ha­heyare eta evarairahi ítaucha eta mavanai­ripiana éma. Tamapu­ru­ji­hi­sa­misera. ");
INSERT INTO ignNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Te yátupi­nahini esuapahini eta mameta­rapiana ema Moiséini, esuapa­nu­hi­va­re­pucaini núti táechaji­si­ha­quenehi eta májureanahi ema Moiséini. ");
INSERT INTO ignNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Váhisera esuapahini eta májucha­que­neanahi éma. Tavetijipa eta emasua­pi­ranuhi eta juca numeta­rapiana eyehe —macahepa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Te táequenepa, te jena sácheana tiánehipa eta Pascua, vipiesta­rasahi viti israelítana. Émasera ema Jesús, tiyana­varepa tiámaha­vivare eta viánuecahi eta cáquiure Galilea (ticaija­re­hivare Tiberias). Camuria­nasera ena achaneana tipaica­napahi téhica­napahi éma, taicha eta náimairahi eta tiárami­careana máichaque­neanahi eta macana­ra­si­ra­vacahi ena nacaju­ma­queneana. Te vítecapapa te apachara, viyanapa te jácani anuquerehi mávapahi. Tacahe, véjacapa vinara­ca­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Téhesera te máimahapa ema Jesús ena camuriana achaneana eta náiteca­pau­chirahi, máichapa ema vichamuri Felipe: —¿Táviha­pucaini vivacha­re­sihaini eta tinicacare vénisi­hahini namutu ena nani achaneana? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Eta juca mayase­re­sirahi étachu­chanéni eta mavarairahi éma macaicu­tia­ra­yarehi te tájahapuca macaye­ma­yarehi ema Felipe. Taicha ema Jesús máechahi eta máichaque­ne­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tásiha ema Felipe majicapapa: —Tacamunuhi vácaye­hehini eta camuri plata apaesa namutupaini vítapa­ra­hahini vénicahini apaesai­nahini návami­nahini. ¡Vahi tarata­hahini eta dies mil páneana! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tásiha, téchajicapa ema nuchamuri Andrés, maparapehi ema Pedro. Máichapa: ");
INSERT INTO ignNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Mararihi ani ema émana amaperu tiámapahi eta cíncochi­chapahi eta pan, apinapa eta jima. ¡Váipari­ne­hisera nárataimahi ena nani camuri­queneana achaneana! —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Émasera ema Jesús máichahavipa: —Evaneca náejahapaica námutu ena achaneana —macahepa. Taicha tiúrina­pa­hi­chíchahi eta apaquehe, muíjipa­hi­hivare. Cinco mil eta náichape­mu­rivahi ena ajairana. Vahi náimitu­pa­chahini ena esenana énapa ena amaperuana. ");
INSERT INTO ignNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tacahe, ema Jesús mavehapa eta páneana. Te tamutupa eta mahasu­lu­pa­ya­chirahi ema Viya, tíjara­ca­havipa. Véniricapa víti, víjara­ca­va­capaipa eta pan étapa eta jima. Tisimu­ri­va­ca­paipahi eta víjaraca. ");
INSERT INTO ignNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tinicanapa namutu. Tisatu­heanapa, nacaema­cha­ri­cha­havare. Tásiha, ema Jesús máichaha­vi­varepa: —Ecurujica eta náemacha­ra­jianahi, machu támapuruji —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tásiha, víti vicuru­jicapa eta pan náemacha­ra­jianahi. Táinica­chai­cha­havare eta dócehiquene ichapehiana saye. ");
INSERT INTO ignNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tacahe, eta náimairahi ena achaneana eta juca máichaque­neanahi ema Jesús, ichape­rinehi nárami. Tásiha, nacahepa: —Émaripa ema maca profeta ema vicucha­pa­quenehi máiteru­yarehi te juca apaquehe —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eta tacahe, navarahapa námaya­rehini nayehe­yarepa rey. Émasera máimatipa eta napane­reruhi. Tacahe, téraji­ca­va­varepa eta nayehe. Tiyanapa macarichuhi te tápusi eta cerro.­ ");
INSERT INTO ignNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tacahe, te jena cápere­hi­chichapa, viyanapa viti máimitureana tayehe eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te vítecapapa, viávacuhapa te pacure. Viánueca­yarehi te apachara. Vicaiju­he­yarehi eta avasare Capernaum. Tiveha­havipa eta yati eta viánuesirahi. Ema Jesús májinahi macacha­ne­ha­vi­pahini. ");
INSERT INTO ignNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Eta vipaisi­rapahi, tachima­racapa eta muraca técaticava. Tépacucapa muraca eta cáquiure. ");
INSERT INTO ignNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco kilóme­troipahi eta viyere­hivahi, vétupie­ca­paipahi, te vímahapa ema Jesús. Mapaicae­ca­paipahi eta une, tipaucha­ha­vipaipa. Víti vipicapa eta vímairahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Émasera máichahavipa: —Vahi ecupicanu. Nútichucha. ");
INSERT INTO ignNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tacahe, vímatipa éma. Viúrisa­mu­réinehi eta vijaca­pirahi eta mávacuirapa eta te vipacure. Tásiha, víteca­panecha eta te vicaiju­he­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te apanapa sache, ena achaneana manaqui­ruanahi ema Jesús, natanu­ji­ri­caipahi éma. Náimatiacapa eta vicari­chuirahi viánueca viti máimitureana. Tájina­hivare apanai­nahini pacure. ");
INSERT INTO ignNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tásiha, tacahe­painecha eta apana pacureana, nayehehi ena tiásihanahi te avasare Tiberias. Títeca­panapa te tachacaya eta nanisinehi eta pan ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tacahe, ena achaneana eta namaimairahi ema Jesús vítipa viti máimitureana, tiávacu­hanapa te pacureana. Tiyananapa ticapa­ya­ca­ha­via­na­yarehi te Capernaum, natanu­si­rapahi ema Jesús.­ ");
INSERT INTO ignNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te títeca­panapa ena achaneana te apachara, náetupiacapa ema Jesús. Tásiha, nayase­recapa: —Tata maestro, ¿tájamuhu pítecapahi eta ani? —náichapa­­. ");
INSERT INTO ignNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ema Jesús majica­pa­vacapa: —Nutupiruva numetacahe: Eti etanu­ca­nupahi táichavenehi eta nénisi­rahehi nésatu­he­chi­rahehi. Váhisera ácaicu­tia­rahini eta nímechi­rahehi eta tiárami­careana. ");
INSERT INTO ignNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eti tamapu­rujipa eta ecaña­ma­ra­si­ravahi etanuca eta enica­que­nerepi taicha títava­yarehi. Tatupa­ra­ca­hisera etanu­cayare eta tinicacare ticaita­re­ca­he­yarehi, máitava­cacahi éta. Étara eta juca níjara­ru­he­yarehi nuti Manere­ji­ru­nuhi ema Viya. Éta tímereu­chanuhi eta yátupirahi nuvane­ca­sivahi eta mayehe ema Tata —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tacahe, éna nayase­recapa: —¿Tájaha­pucaini eta mavara­ha­que­neanahi ema Viya eta vicaema­ta­nea­sirahi éma? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ema Jesús majica­pa­vacapa: —Eta mavara­ha­que­neanahi ema Viya íchaque­neyare, esuapa­nuyare nuti mavane­runuhi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tásiha, ena nayase­re­ca­varepa: —¿Tájahasica eta tiáramicare pímecha­ha­viyare apaesa visuapavipa? Vivaraha vímaha. ");
INSERT INTO ignNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eta acane ema víyarahaini Moisés tíjara­ca­vacahi ena viáchucae­que­neanaini tinicanahi eta ticaijare maná, ánaqui te apaquehe mávapahi. Taicha tacahehi eta táechaji­ri­ruvahi eta Sagrada Escritura ani tacahehi: “Máenica­vacahi eta tinicacare tiásiha te anuma”. Piti, ¿pímija­chavapa pirataha picachurica ema víyarahaini Moisés? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ema Jesús majica­pa­vacapa: —Nutupi­ru­vavare numetacahe. Éti, ichape eta éjeca­pirava. Ema víyarahaini Moisés, vahi émainahini macucu­pai­cahini eta maná. Ema Tata, émahi ticucu­paicahi eta maná. ");
INSERT INTO ignNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jararihi eta apana numetarapi eyehe: Puiti ema Tata mavaraha máijara­caheya eta yátupi­quenehi tinica­carehi. Étaripa tinica­carehi tiásihahi te anuma ticaita­re­ca­va­ca­yarehi namutu nácani tijaca­panaya. Étara eta tímite­canuhi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tásiha, najicapapa éna: —Tata maestro, piyasea­si­nahavi ema Viya ­ máijara­ca­ha­vipaini máejehai­nahini eta tinicacare péchaji­si­ha­quenehi —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tásiha, éma máichavarepa: —Nútira eta yátupiquene tinicacare nucaita­re­ca­he­yarehi. Eta tacahe, nácani tisuapa­nua­nayare, vaipa tiápecha­va­naimahi técuhana. Váipavare timaunea­naimahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Étasera eta níchaquene, ímaha­nui­paneni éti, váhisera esuapa­nuhini. ");
INSERT INTO ignNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nuvaraha ácaicu­tia­ra­quenéna yátupina. Namutu nácani tipaucha­nua­nayare, núti vahi névata­ji­ca­va­cáimahi taicha tásiha­que­néichuhi me Tata eta máijara­si­ranuhi éna. ");
INSERT INTO ignNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taicha núti, eta núcupai­sirahi te anuma, tímite­canuhi nítaucha­yarehi eta mavanai­ripiana ema Tata. Vahi nútiji­ri­ru­vai­nahini eta nítesirahi níchayarehi eta nuvara­ha­que­ne­nahini núti. ");
INSERT INTO ignNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","40","Eta mavara­ha­quenehi ema Tata eta mavane­si­ranuhi, nucaita­re­ca­yarehi nácani máijara­ru­nua­na­yarehi éma. Nácani téseni­ca­nua­nayare nuti Machicha, tisuapa­nua­na­ya­revare, máichecua­ra­qui­reyare eta náitare­siraya te nucaeche­pucapa éna te náecariana te jena sache táitecapapa eta népaní­ra­va­cayare. Váhiquene nucami­tia­caimahi ema émanaimahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tásiha, nararihi ena ticaeca­hi­rahiana eta máichira­vacahi ema Jesús eta émairahi eta yátupiquene tinicacare, máucupairuhi te anuma, ticaita­re­ca­ra­hiyare. ");
INSERT INTO ignNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ánipa náichacacahi: —Tépiya­hi­rahipa ema maca. Víti, vímatihi ema maiya, ticaijare José. Éneri­chuvare vímati­hivare esu máena. ¿Tájaha tacayema eta macahe­cha­ji­ri­ruvahi eta másihairahi te anuma? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ema Jesús máichavacapa: —Ámatina. ¿Tájaha tacayema épururahi? ");
INSERT INTO ignNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nacarichu témuna­hi­ri­ca­vanaya tipauchanuana nácani máichuha­que­neanahi ema Tata. Eta tacahe, ena máichuha­que­nea­na­yarehi éma, nucaeche­pu­ca­va­cayare núti te táitecapapa eta sache népaní­ra­va­cayare núti. ");
INSERT INTO ignNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Taicha tacahehi eta májurehi ema profeta víyarahaini Isaías, ani tacahehi: “Náimitu­ca­si­va­ya­reichuhi me Viya namutu ena achaneana”. Tacahe, ­ namutu ena máimitureana ema Tata, énara tipaucha­nua­nayare puiti. ");
INSERT INTO ignNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tayanapane váhihinéni náimahaimahi eta mamira ema Tata. Nucarichu núti nímahapa éma taicha étaquenehi eta násinehi eta mayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nutupi­ruvahi numetacahe: Nácani tisuapa­nua­nayare, níjara­cayare eta náitare­si­rayare máitava­ca­cayare. ");
INSERT INTO ignNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Núti, yátupi­quenehi eta nucaita­re­si­ra­vacahi ena ticasi­ña­vanahi eta nuyehe tacuti eta tinicacare tacaita­recahi eta viáqueheana. ");
INSERT INTO ignNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Éti, ena iáchuca­na­veanaini tinicanahi eta maná te mávapahi apaquehe. Váhisera náitare­cahini. Namutuhi tépena­ra­cánahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Nácanisera tinicanahi eta néche, vahi tépena­naimahi. Taicha núti núcupai­caripa te anuma. Eta neche, yátupi­quenehi tinica­carehi ticaita­re­carahi. Nácani tinica­nayare eta neche, máichecua­ra­qui­reyare eta náitare­siraya. Núti níjara­cayare eta neche taicha nuvaraha tacaita­re­ca­va­cahini namutu ena achaneana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tásiha, ena natiari­hi­queneana tiácapae­ma­ji­ri­cá­canapa. Ena apamuriana, ánipa nacahe: —¿Tájahapuca macayemahi eta máijara­si­rahavi eta maeche viniru­yarehi? Ena apamuriana, ánipa nacahe: —Vaipa tétupicava eta juca mapane­reruhi. Mavaraha vinica­ya­recacha eta máechenaváji —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Émasera ema Jesús máichavarepa: —Nutupiruva numetacahe: Te épuru­hipuca enica eta neche, nuti Manere­ji­ru­nuhi ema Viya, te épuru­hi­va­repuca éra eta nítine, vahi ítare­caimahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Taicha nácani tinica­nayare eta neche, térana­yareva eta nítine, éna máichecua­ra­qui­reyare eta náitaresira. Tásiha, núti nucaeche­pu­ca­va­cayare te náecariana te jena sache népaní­ra­va­cayare. ");
INSERT INTO ignNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Taicha eta neche yátupi­quenehi tinicacare tacaita­re­carahi. Énerichuhi eta nítine, yátupi­que­ne­hivare téracare ticaita­re­carahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Esama­nuchaha. Nácani tinica­nayare eta neche, térana­yareva eta nítine, éna tiávahá­ca­nua­na­yarehi núti. Tásiha, núti návahá­ca­va­ca­yareva éna. ");
INSERT INTO ignNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taicha ene nucahehi núti, tiávahá­canuhi ema Tata. Tásiha, núti návahá­ca­hivare éma. Máitava­cacahi eta máitaresira. Éma ticaita­re­canuhi. Tivane­ca­nu­hivare nucaita­re­ca­he­yarehi. Tásiha, nácani tinica­nayare eta neche, máitava­ca­cayare eta náitaresira nícha. ");
INSERT INTO ignNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Núti núcupaicahi te anuma eta níjara­si­ra­he­yarehi eta juca yátupi­quenehi tinicacare. Vahi tácutihi eta maná nanica­quenehi ena iáchuca­na­veanaini éti. Tépena­ra­ca­na­ri­chu­chaséra. Énasera ena tinica­nayare eta neche, máichecua­ra­qui­reyare eta náitare­siraya —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tamutu eta juca máimitu­rapiana ema Jesús te mávihaipahi te náuruji­si­rareva ticaijare sínagoga tayehe eta jena avasare Capernaum. ");
INSERT INTO ignNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tacahe, ena téhicanahi ema Jesús, eta nasamirahi eta juca máimitu­ra­pianahi, camuriana ena vaipa návara­hahini náehica. Ánipa nacahe: —Ticaje­rapicha eta vicaicu­tia­ri­rai­nahini eta juca máimitu­rapiana. Nájinavare tisuapa­naimahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Émasera ema Jesús máimatihi eta napane­re­ruanahi eta namava­rai­raripa náimiya­na­vahini náehicahini. Tacahe, máichavacapa: —Páurehehi éti eta evaraha ínajica eta éhisiranu taicha eta emacai­cu­tia­rairahi eta nímitu­ra­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Németeaca ímiya­na­vaichucha eta emasua­pa­ji­raivahi, tayana­pa­nepuca ímaha­nupuca eta nárairaya nuchavi­ra­yarehi te anuma, te návinehi acane, taicha núti Manere­ji­ru­nuhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ácaicutiara eta nucaye­ma­quenehi. Vahi étapa­racaini eta néchaquene. Eta juca nímitu­rapiana, te esuapapa, étara ticaita­re­caheya taicha yátupi­que­nerihi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","¡Páurehehi eti váhiquenehi evara­hahini esuapanu! —máichavacapa. Eta juca macaye­ma­que­neanahi ema Jesús, matupi­ruvahi eta máichira­vacahi taicha máimatipahi eta napane­reruana ena tijuni­jia­ca­na­yarehi, émapa ema tíjara­re­ca­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tacahe, máichavacapa: —Puiti, evaraha ínajicanu. Eta tacahehi eta níchirahehi: “Nacarichu témuna­hi­ri­ca­vanaya tipauchanuana nácani máichuha­que­neanahi ema Tata” —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eta nasamirahi eta nacaye­ma­que­neanahi, tínaji­ca­vanapa ena camuri­que­nea­nainihi. Vaipa náimiya­na­vahini náehicahini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tacahe, tiyase­re­ca­havipa viti dócequeneana máimitu­reanahi. Máichahavipa: —¿Evara­hai­na­papuca ejuni­ji­ca­nuyare éti apanavare? ");
INSERT INTO ignNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tacahe, ema Simón Pedro majicapapa: —Tata maestro, vahi vijuni­ji­ca­vimahi, taicha nájina pácuti eta péchaji­ri­ruvana. Tétavi­cavahi eta tacaita­re­ca­raivahi. ");
INSERT INTO ignNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Víti vitupi­ruvahi eta visuapi­ravihi. Véchahivare eta yátupi­que­né­ravihi Cristo, Machicha­que­névihi ema yátupi­quenehi Viya —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ema Jesús majicapapa: —Dócehe­hinéni eti nunere­ji­ruanahi. Marari­hisera ema émana te etaracu, ema mávaháruhi ema Váinaraji —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ema Jesús, máechaji­sihahi ema Júlasi. Taicha ema Jesús máimatihi eta émaira­yarehi tíjarareca, tayanapane éma vidoce­nénihi viti apóstoleana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tacahe, ema Jesús tímiya­na­paipahi tipaica­paipahi eta avasareana te tinapaica eta Galilea. Vahi mavara­hahini machavahini tayehe eta avasareana tinapaica eta Judea, taicha ena tuparai­ru­canahi te Jerusalén napane­re­chaipahi nacapa­ca­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tacahe, te jena sácheanahi, tiánehipa eta vipiestara viti israelítana eta vicape­na­hui­ya­vacahi eta viyusujiana. Étahi eta víteca­pi­ha­vacahi te Jerusalén, vihasu­lu­payacha me Viya eta macaju­ru­si­na­havihi eta visucureana te vésaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tiuri puiti, natiarihihi ena mapara­pe­naveana ema Jesús. Tacahe, náichapa éma: —Te pímijachava pítira máestrovi, vahi pánasi eta te ani. Piyana te Judea, apaesa ena pímitureana tiávihanahi ánaqui náimaha eta píchaque­nea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Taicha te pivara­ha­hipuca náimativi ena achaneana, tacamunuhi pímerecava yátupina te namirahu namutu. Vahi picuyu­muruca eta pítuca­queneana —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taicha ena mapara­pe­naveana váhique­nevare nasuapahini éma. ");
INSERT INTO ignNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tacahe, ema Jesús máichavacapa: —Vuíchaha táiteca­pau­cha­nuhini eta nuyani­rayare te Jerusalén. Étisera tamutuchucha tiuri eta eyaniraina. ");
INSERT INTO ignNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nútisera ticati­cha­nuanahi ena achaneana táichavenehi eta nímereu­chi­ra­vacahi eta náichaqueneana tamauri­queneana. Étisera vahi ticati­cha­hea­naimahi taicha tájina taviucha­hehini. ");
INSERT INTO ignNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Te evara­hapuca, eyana éti te piesta. Nútisera vuíchaha nuyanaimahi taicha vuíchaha táiteca­pau­cha­nuhini eta nuyani­rayare —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Máevatacahi ema Jesús ena mapara­pe­naveana, émasera ticaeque­ne­havapa. Manasi­pa­naichaha te Galilea. ");
INSERT INTO ignNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Te tiyananapa te piesta ena mapara­pe­naveana ema Jesús, éneri­chu­varéni éma tiyana­varepa. Váhisera máimere­ca­va­hichaini. ");
INSERT INTO ignNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Énasera ena tuparai­rucana natanucaipa éma, te jena piéstaquenehi. Tásiha, nacahepa: —¿Macáñá­ri­hi­pu­cacacha ema mácani achane? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Éneri­chuvare ena achaneana natiari­hi­que­neanahi te piesta, náechaji­sihahi éma. Ánipa nacahehi: “Vahi tiuri ema maena achane. Macaete­mavaca ena achaneana”. Ena apamuriana ánivare nacahe: “Tiúrihi ema maca. Vémeteaca tétavicava eta máurivahi”. ");
INSERT INTO ignNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Váhisera nacuchu­ji­pi­cahini eta nacaye­ma­que­neanahi taicha tipica­ca­ra­ca­va­na­richucha nayehe ena tuparai­rucana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te enumu­hu­quenepa eta piesta, mapaenu­mavapa tímerecava ema Jesús. Tiyanapa tisiapahi tayehe eta Templo. Tinaha­cavapa tímitu­recahi. ");
INSERT INTO ignNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ichape eta náramirahi ena tuparai­rucana, eta náimairahi eta máitusirahi yátupi. Tásiha, ánipa nacahehi: —Ema maca vahi vímitu­re­nahini. ¿Táviha maviyahi eta máituca­quenehi ema maca? Vahi mávami­rahuini eta máimitu­si­ra­vacahi ena achaneana —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Émasera ema Jesús máimatihi eta napane­re­ruanahi. Tacahe, máichavacapa: —Vahi nútiji­ri­ruvaina nuvehahini te nuchuti eta juca nímitu­ra­pianahi. Ema Tata tivane­canuhi, émahi titupa­ra­canuhi eta nímitu­siraya eta máimitu­rapiana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Te etiari­hi­napuca eti evarahahi ítaucha eta mavanai­ripiana ema Viya, ímatia­ca­va­neyare eta juca nímitu­ra­pianahi étairahi tiásihahi eta me Viya. Vahi nútiji­ri­cá­vai­nahini eta nímitu­sirahi. ");
INSERT INTO ignNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mácani achane émaji­ri­cavahi téchaji­sihava, mavarairahi ticuna­cha­ca­re­yarehi. Nútisera, eta nuvarairahi ecuna­chayare ema Tata tivane­canuhi, vahi népiya­hi­ra­himahi. Nutupi­ruvahi néchajisiha eta yátupi­queneana tisuapa­careana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Échavarichu éti eta máijara­si­rahehi ema víyarahaini Moisés eta mavanai­ripiana éhiru­yarehi. Váhisera ítauchahini éti émanai­nahini. ¿Tájahasica eta nuviureva eta evarairahi ecapa­canuya? —máichavacapa ena tuparai­rucana. ");
INSERT INTO ignNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ena achaneana najicapapa: —¡Péjecapava píti eta pipanereru! ¡Máurishi­vi­papuca píti! ¿Nájaha ticahehi eta vivarairahi vicapacavi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ema Jesús tímiyanava téchaji­ricava nayehe ena tuparai­rucana, ánipa máicha: —Táichavenehi eta nípure­sirahi te jena sache tacapi­ca­hu­quenehi sávaru­mu­hu­quenehi, éta tiviuchanuhi ichape eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Étiyapa epami­cavahi eta emarca­chiraya mácani amuya ajaira te óchopa eta masacherahi, tayanapane sávaru­mu­hu­hipuca. Taicha ichape evaraha ítauchayare eta mayehe­repini ema víyarahaini Moisés. (Váhisera émainahini máinapu­cahini manacu­chahini eta juca eyeherepi. Ema viáchucaini Abraham énapa ena machicha­naveana tínapu­canahi nanacucha eta viyehe­re­pi­yarehi.) ");
INSERT INTO ignNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Te tiúrihi ímaha eta emarca­chirahi mácani amuya alauchu te sávaru­muhuana, ítauchi­ra­paipahi eta mavanairipi ema Moisés, tatupa­racahe vahi ecuse­mahini eta nuyehe táichavenehi eta nucana­ra­sirahi ema maca achane te sávarumuhu. ");
INSERT INTO ignNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Vahi ecuému­na­ná­sicava eta epane­reruana. Epane­re­chinava tayehe eta táuriqueneana­­. Ácaicutiara eta táurivahi eta vicana­ra­sirahi ena achaneana, tayanapane eta sávaru­mu­hu­hipuca —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tacahe, natiarihi ena tinere­ji­cavana ena ticava­sanahi te Jerusalén, nacahepa éna: —Ema maca, émara ema natanu­ji­riruasa ena tuparai­rucana, ema navara­ha­quenehi nacapaca táichavenehi eta máimija­chirava ema Cristo mavaneruhi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ímahasera éma, vahi mapica­ca­ra­ca­vahini eta macame­ta­rai­ruirahi te juca Templo. Nájinavare ena tuparai­rucana náijara­ca­vahini nacara­ta­cahini. Nájinavare nacama­ti­na­cahini. ¿Nasuapa­ri­papuca puiti éna, eta émairahi ema Cristo? ");
INSERT INTO ignNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Vémetea­casera vuíchaha émaina ema Cristo, taicha vímatihi ema maca, étapa eta máuchusinehi. Te máitecapa ema yátupiquene Cristo, nájina téchaimahi távihapuca eta máuchusi­hayare —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Émasera ema Jesús máimatihi eta napane­reruana. Tásiha, muraca­panapa eta máechaji­sirahi eta te Templo máimitu­re­sirahi. Ánipa macahe: —¡Éti ímijachava ímatinuhi, étapa eta núchusinehi! ¡Váhisera ímati eta tímite­canuhi! ¡Váhivare ímati ema Eterno­quenehi, ema tivane­canuhi! Núti, vahi nútiji­ri­ru­vai­nahini eta nítesirahi. ");
INSERT INTO ignNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nútisera nímatihi éma taicha étaquenehi násinehi eta mayehe eta níteca­pau­chi­rahehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Eta nasamirahi éna tuparai­rucana, tiápaju­pa­navahi eta nasema­nevahi. Navarahapa nacara­ta­ca­ya­rehini, náerata­ca­ya­repaini, vuíchahasera máisapahini ema Viya eta nacara­tasira éma. ");
INSERT INTO ignNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Natiari­hisera camuriana ena tisuapanahi. Tásiha, nacahepa: —¡Víti vémeteaca émaripa ema Cristo ema maca! ¡Taicha nájina mácuti eta máichirahi eta tiárami­careana máichaque­neanahi ema maca! —nacahepa­­.­ ");
INSERT INTO ignNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ena fariséoana nasamae­machapa ena achaneana eta nacuna­chirahi ema Jesús. Tásiha, napane­reu­cha­vanepa ticuru­ji­ca­canapa ena tuparai­ru­cana. Náevatacapa ena suntaruana nacara­ta­pa­na­yarehi ema Jesús te Templo te mávihahi. ");
INSERT INTO ignNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tacahe, ema Jesús máichavacapa ena suntaruana: —Vuíchaha titupa­racahe eta ecara­ta­ca­nuhini. Yátupisera ánipirine eta nucaheyare eta eyehe. Tásiha, nuchavainapa mayehe ema tivane­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Éti, etanu­ca­nuinapa, váhisera íchima­va­nuimahi. Taicha vahi ítuji­ca­vaimahi ecapa­yacanu te návihayare núti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tacahe, ena ticatia­na­canahi tiyase­re­ji­ri­ca­canapa. Ánipa nacahe: —¿Táviha­papuca macaiju­hénapa eta vaipa virata­haimahi vicapa­ya­caimahi víti? ¿Mavara­hapuca tiyanayare te tayere­hiquene avasare, macapa­yacaya ena vijaneanana israelítana tiávihanahi te tayere­hiquene? ¿Mavara­hapuca máimitu­cayare ena apava­sanana? ");
INSERT INTO ignNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tájaha­pucáji tacayemahi eta juca máechaji­ri­ruvahi eta vaipa virata­haimahi vicapayaca te jácani macaiju­heyare? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te jena téqueneha sache eta piéstairahi, tímaha­ca­repana eta jena sache. Tiyana­varepa ema Jesús te namuri ena achaneana. Titupihapa, téchajicapa muraca. Ánipa macahe: —Te natiari­hi­napuca nácani timauneanahi, náiteca­pauchanu. Núti níjara­cayare eta náerayare nácani tisuapa­nua­nayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taicha ani tacahehi eta Sagrada Escritura: “Ema Mavaneruhi ema ­ Viya, tétavi­cavaya eta viúrica­ca­revana máicha, tacutiya eta ichape cajacure táuchurehi eta te máriana. Ticaita­re­ca­haviya éma” tacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Eta juca macaye­ma­que­neanahi ema Jesús, máimicae­che­rachahi eta masiapa­ha­si­ra­va­ca­yarehi ema Espíritu Santo te nasamureana nácani tisuapa­na­yarehi éma. Vuíchahasera táitaucha­vahini, taicha vuíchaha machavahini mápanahini te mávasa te anuma ema Jesús.­ ");
INSERT INTO ignNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","43","Tacahe, ena achaneana apana­panepa eta napane­reruana mayehe ema Jesús. Ena apamuriana achaneana, nacunachapa éma. Ánipa nacahe: —Yátupiquene ema maca achane, émaripa ema profeta ema vicucha­pa­quenehi máiteru­yarehi. Ena apamuriana, ánivare nacahe: —Émaripa ema maca ema Cristo. Énasera ena apamuriana, téjeca­pa­va­na­richucha. Ánipa nacahe: —Galileo ema maca Jesús. Váipari­ne­hiséra étainahi máuchusiha ema Cristo tayehe eta avasare Galilea. Taicha eta Sagrada Escritura táechaji­sihahi ema Cristo émayarehi mámarie­que­ne­yarehi ema víyarahaini Rey David. Téhesera te avasare Belén eta máuchusi­hayare, étaichuhi te mávasahi ema víyarahaini Rey David —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Natiari­hi­hivare ena apamuriana navara­haichucha náemera­ta­ca­yarehi, váhisera napatsi­ca­vahini nacara­ta­cahini.­ ");
INSERT INTO ignNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tacahe, ena suntaruana vanairu­canahi tichavanapa nayehe ena tivane­canahi tuparai­ru­canahi. Vahi náijara­ca­vahini nacara­ta­cahini éma. Tacahe, náichapa ena tuparai­rucana: —¿Tájaha tacayema vahi iámapahini éma? ");
INSERT INTO ignNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ena suntaruana najicapapa: —Víti vahi vipatsi­ca­vahini vicara­ta­cahini éma, taicha tétavicava eta máitupa­ji­jia­sirava ema maca. Émahipuca ema Cristo vicucha­pa­quenehi. Nájina mácuti eta máechajisira ema maca achane —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tacahe, ena fariséoana náichapa: —¡Éti apanavare ísapa­vaipahi tivayua­racahe ema mácara! ");
INSERT INTO ignNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nájina émanaina ema tuparairuca viyehe viti nasuapahini ema máenatataji. Váhivare émanaripa vichamuri fariséo, vahi masuapahini. ");
INSERT INTO ignNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Énasera ena nani achane­ta­tajiana máimati­ra­hanahi eta viyehe ley, náehicá­va­ne­ta­tajipa. Táurica nacaicu­ñahini táicha —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Matiari­hi­hivare ema Nicodemo, ema tipaipiuchahi ema Jesús te jena yátiquenehi. Fariséo­hivare éma. Máichavacapa: ");
INSERT INTO ignNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Váiparinehi vétavi­caimahi eta viyehe ley vítiji­ri­ca­vahini vicapa­cahini ema achane. Tacamunuhi véchanu­ma­yarehi eta maviurevahi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Éna najicapapa: —Vémeteaca píti apanavare pijanea­na­hipuca éma, pítiri­chupuca galiléovihi. Vivanecavi péchajicuha eta Sagrada Escritura apaesa pecha vahi étaimahi te Galilea máuchusi­hayare ema profeta Cristo vicucha­paquene —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tacahe, te títapi­ri­canapa eta náechaji­si­hairahi ema Jesús, téjane­re­canapa. Tiyana­ra­canapa te napenana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ema Jesús májina­ripahi. Tiyanaripa te tachachacu eta avasare, te cerro ticaijarehi Olivoquiji. Tatiarihihi eta avasa­rechicha ticaijarehi Betania, eta máiteca­pihahi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te apana­varepa sache, te tijara­ra­hi­chichapa, tiyana­varepa éma tayehe eta Templo. Téjacapa éma, tímitu­recapa. Namutu ena achaneana tiyananahi napaucha, nasama­ra­ra­ca­yarehi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tacahe, sutiarihihi esu esena ticaye­pe­hipuca, esu suvehahi ema apana achane. Ena escribá­noana énapa ena fariséona, eta náimereu­chirahi ­ ésu, námapa te mamirahu ema Jesús te namurihi ena achaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tacahe, náichapa ema Jesús: —Tata maestro, esu suca esena nachima­racahi ticayepehi, suvehahi ema apana achane. ");
INSERT INTO ignNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eta viyehe ley máijara­ruhavi ema víyarahaini Moisés, tímitu­ca­havihi vicapa­ca­yarehi eta vitupi­si­si­rayare te márijahiana nácani ticape­ca­tu­ranahi. ¿Tájahapuca picayema piti? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Éna nayase­se­recahi ema Jesús, taicha natanucahi eta tiviucha­yarehi éma. Émasera ema Jesús tétipaicapa tiájupai­ricapa te apaquehe te mavauqui. ");
INSERT INTO ignNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Énasera tímiya­na­va­na­richucha nayase­recahi. Tacahe, máeseni­mu­rihapa. Máichavacapa: —Te etiari­hipuca éti mapeca­tu­ra­reanahi, enere­jicava ínapuca eyuca esu suca esena —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tacahe, tétipai­ca­varepa tiájupai­ri­ca­varepa éma. ");
INSERT INTO ignNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eta nasamirahi eta juca, téchava­na­ri­chu­hinéni eta napeca­turana. Titsiri­ha­ca­vanapa. Tásiha, timutse­ra­ha­vanapa tiúchuchu­jicana. Nativapa tiúchucanahi ena ichavi­ca­panana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te máeseni­ca­varepa ema Jesús, nájina­ripahi éna. Sucari­neipahi esu esena. Tásiha, máichapa esu esena: —Nuchicha, tiyananapa namutu ena timetau­cha­vianahi. ¿Nájinapa apanai­nahini ena navaraha ticapa­caviana? ");
INSERT INTO ignNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tásiha, ésu suíchapa: —Nájina, tata. Éma máichavarepa: —Núti apanavare, váhivare nímica­pa­ca­vimahi. Piyana pichava. Váipasera picuapechava picuquicha eta pecatu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Te táequenepa eta juca, tépana­va­varepa tímitureca ema Jesús. Máichavacapa ena achaneana: —Nútira numicau­chahehi eti achaneana te juca apaquehe. Eta tacahe, nácani téhica­nua­nayare, vahi ­ téjeca­pa­va­naimahi. Taicha eta nímitu­rapiana, étapa timícau­cha­vacahi. Tásiha, nacati­chainapa eta timapicu, vaipa napauchaimahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tásiha, ena fariséoana natiari­hi­pa­hivare. Tacahe, náichapa: —Pítiji­váichucha péchaji­siavahi. Tájina pisuapa­ca­revaina. ");
INSERT INTO ignNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ema Jesús majica­pa­varepa: —Tisuapacare eta juca néchaji­ri­ruvana, tayanapane nútijivahi néchajisiava. Taicha nímatihi nutupa­ra­haichuhi eta nímere­si­ra­vayare. Nímati­hivare eta nucaiju­heyare. Étisera vahi ímatihini távihapuca eta násinehi, váhivare ímati eta nucaiju­heyare. ");
INSERT INTO ignNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Éti étachucha éhicahi eta nayehe­repiana nanaca­queneana ena iáchuca­na­veanaini. Étasera tíchahehi eta épurui­ranuhi. Nútisera vahi népuru­héimahi éti. ");
INSERT INTO ignNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jéheva­reséra, te jácani sácheyare, népuru­he­papuca táichavenehi eta emasua­pirahi, tatupi­ru­va­yarehi eta népurui­raheya taicha vahi nácari­chuimahi népuruhe núti. Matiarihi ema Tata tivane­canuhi. Ema apana máimahahi eta emasua­pa­ji­raivahi. Tépuru­he­ya­re­hivare éma. ");
INSERT INTO ignNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Te eyeherepi éti, te natiari­hipuca apinana ena títame­ta­ca­rahiana, te ticuti­ca­canahi eta náechaji­riruva, tisuapa­ca­rea­na­yarehi éna. ");
INSERT INTO ignNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ene nucahehi núti. Yátupihi eta numeta­rapiana. Émapa ema Ticachi­chanuhi, éma títame­ta­cahehi eta yátupirahi eta numeta­rapiana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Énasera nayase­re­ca­varepa: —¿Távihasica mávihahi ema ticachi­chavihi? Ema Jesús majica­pa­varepa: —Éti vahi ímatinu. Váhivare ímatimahi ema Ticachichanu. Te ímati­nuhini, ímati­pa­hi­vareini ema Ticachichanu —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Eta juca eta máechaji­ri­ru­vanahi ema Jesús eta máimitu­re­sirahi tayehe eta Templo. Eta máejasinehi te tachacaya eta nanasi­rareana eta námavahuana. Nájinasera napatsi­ca­vahini nacara­ta­cahini taicha vuíchaha máisapa­va­caimahi ema Viya eta nacara­ta­si­rai­nahini ­ éma. ");
INSERT INTO ignNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ema Jesús tiápecha­vavare mameta­cavaca: —Puiti tiánehipa eta nuyani­rayare. Éti etanu­ca­nuinapa. Váhisera íchima­va­nuimahi. Émepe­nainapa eta epeca­turana. Tímicu­ña­ca­heyare te infierno taicha vahi ecama­pu­ra­vahini eta nutiari­hirahi, esuapa­nuhini. Taicha vahi ítuji­ca­vaimahi ítecapa te návihaya núti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tásiha, ena ticatia­na­canahi náichacacapa: —Mavara­hai­napuca ticapa­ca­vayare. Táitusiava macahehi eta máechaji­ri­ruvahi eta váhiji virata­haimahi véhica éma. ¿Távihapuca eta macaijuheya? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ema Jesús máichavarepa: —Éti tayehehi eta apaquehe. Nútisera tayehenuhi te anuquehe. Eta iávasahi éti te apaquehe iávihahi. Núti návasaichuhi te anuquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eta tacahe, numeta­ca­he­numahi eta tanasinapa eta epeca­turana te épenapa. Taicha te vahi esuapa­nuhini eta nútique­nérahi ema ecucha­pa­quenehi, tanasiyare eta epeca­turana te épena —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tacahe, nayase­recapa éna: —Piti pímijachava mavaneruhi ema Viya. ¿Nájaha­visica pítinavaji? Ema máichavarepa: —¿Áyahe­papuca numetacahe? ");
INSERT INTO ignNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","¡Tétavi­cavahi eta tamura­cavahi eta esamureana! Tavaraha muraca eta nucaja­chi­raheya. Vuíchahasera nicha. Émasera ema tivane­canuhi, tatupi­ruvahi eta máechaji­ri­ruvana. Eta tacahe, eta néchaji­ri­ruvana núti eyehe eti achaneana, étarichuhi eta nusama­que­neanahi mayehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Énasera váhiquene nácaicu­tia­rahini eta mameta­si­ra­vacahi eta mayehe ema Maiya. ");
INSERT INTO ignNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tásiha, máichavarepa: —Jéheva­resera te ecatu­pi­hanupa te anuquehe, tapaenu­ma­vainapa ímati­nuyare eta nútique­nerahi ema Cristo ecucha­pa­quenehi. Ecaicu­tia­ra­yareva yátupihi nímitucahe eta máimitu­rapiana ema Tata. Vahi étaina nuviyahini te nuchuti nútiji­ri­ru­vai­nahini­­. ");
INSERT INTO ignNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Puíticha, ema Tata ticacha­nenuhi, vahi majuni­jia­ca­nuhini, váhivare nácari­chuhini taicha nítauchai­pa­hisera núti eta mavara­ha­que­neanahi éma —máichavacapa éna. ");
INSERT INTO ignNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Eta nasamirahi ena achaneana eta mameta­ra­pianahi, ichape­rinehi eta nasuapirahi ema Jesús ena camuri­queneana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tacahe, ema Jesús máichavacapa ena tisuapa­na­ripahi. Máichavacapa: —Te ímiyanava ecara­tacava eta esuapirahi eta nímitu­rapiana, éti yátupi­quenehe nímitu­rehehi. ");
INSERT INTO ignNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tásiha, ímatinapa eta yátupi­queneana táuriqueneana. Vaipa vanara­ca­hémahi éti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Narari­hi­hisera ena ticana­ra­ji­ri­canahi éma. Náichapa: —Viti mámarie­que­ne­hávini ema viáchucaini Abraham. Tájina vímati­yahini eta vítare­sirahi nacava­na­ra­ha­vihini. ¿Tájaha tacayema eta picahehi vaipa vanara­ca­ha­vimahi? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ema Jesús máichavarepa: —Nutupiruva numetacahe: Namutu nácani tíchanahi eta pecatu, tavayua­ruanahi éna. Nacutihi ena vanaracana taicha tétavicava eta tavayua­si­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","36","Ímija­cha­vaipahi machichahehi ema Viya. Váhisera tacahehini, taicha tavayua­ruhehi eta pecatu. Nútisera nuti Machicha ema Viya nuratahahi nucuchu­cuhahe. Vaipa vanara­ca­hémahi. Vaipa tivayua­ca­hémahi eta pecatu. Jéhesare, yátupina eta machicha­heraya, máichecua­ra­qui­reyare éta. ");
INSERT INTO ignNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Néchahivare núti eta mámarie­que­ne­hérahi ema viáchucaini Abraham. Epane­re­chai­chu­chasera ecapacanu, taicha ecatichahi eta nímitu­ra­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Núti néchaji­sihahi eta máimecha­que­né­nuanahi ema Tata. Étisera étachucha íchahi eta mavanai­ri­pia­na­richuhi ema ticachichahe ­ —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Éna najicapapa: —Viti machichae­que­neá­naichaha ema viáchucaini Abraham —nacahepa. Ema Jesús máichavarepa: —Te yátupi­nahini machichae­que­ne­hé­nahini ema Abraham, ecutihini éma eta yátupirahi eta macaema­ta­nea­sirahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Esapihahi éti, epane­re­chaichucha ecapacanu. Ema Abraham, vahi tácahehini eta mapane­reruhi éma. Núti numeta­cahehi eta yátupi­queneana mapane­reruana ema Viya. Váhisera esuapa­nui­ma­hisami. ");
INSERT INTO ignNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Éti ícharichucha eta máichaque­neasahi ema ticachichahe —máichavacapa. Ena najica­pa­varepa: —Víti vahi apáchi­cha­hávina. Émanaichu ema ticachi­chahavi, ema Viya —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ema Jesús majica­pa­varepa: —Te yátupi­nahini machicha­he­nahini ema Viya, etupi­ru­vai­pahini émunacanu. Taicha núti étaquenehi násiha me Viya. Vahi nútiji­ri­ru­vai­nahini eta nítesirahi puiti. Nuvane­ca­sivahi mayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tájaha tacayema vahi árataha ecaicutiara eta nímitu­rapiana? Étase­rapuca eta emava­rairahi esama. ");
INSERT INTO ignNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nútisera nímicae­che­ra­chi­na­heyare ema ticachichahe. Émara ema Váinaraji. Ema téchahehi, taicha evarahahi íchayare eta máichaqueneana éma. Taicha éma, ticapahi eta máitare­sirahi te tépana­vainapa. Váhiquene mávara­hahini máehicahini eta yátupi­queneana. Étachucha máurica tivayua­rereca. Tépiya­hi­ra­hipaipa. Máuriha­yapara eta máimahi. Éma, náiyahi ena tépiya­hi­rahiana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eta echichairahi ema maca tépiya­hirahi, váhique­nehíni esuapa eta juca nímitu­rapiana yátupi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Éti, ímija­cha­nupuca jararihi eta néjeca­pi­ravahi. Nutupi­ru­va­hi­ne­nisera eta numeta­si­rahehi eta yátupi­queneana. ¿Tájaha tacayema vahi esuapanu? ");
INSERT INTO ignNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Taicha nácani mayeheanahi ema Viya, náurica­yarehi nasama­raraca eta máechaji­ri­ruvana ema Viya. Étisera vahi machicha­hé­nahini ema Viya. Eta tacahe, vahi iúricahini esama­ra­ra­cahini eta máechaji­ri­ruvana numeta­ru­heanahi —máich­ avacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tacahe, ena ticatia­na­canahi náichavarepa: —Piti achane picahe­que­ne­ta­ta­jichucha. Yátupi­quenehi mávahá­ruvihi ema Váinaraji. Táitusiava, máurishivihi máicha —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ema Jesús majica­pa­varepa: —Vahi máurishi­nui­nahini. Eta juca nucaema­ta­nea­sirahi ema Tata, nuvarairahi ecuna­chayare éma. Étisera épuru­nuichucha. ");
INSERT INTO ignNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Núti vahi nucuna­cha­vaimahi. Matiari­hisera ema ticuna­chanuhi. Éma téchahavihi, te nútipuca nétupi­cavahi eyehe, téhesera étihipuca. ");
INSERT INTO ignNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nutupiruva numetacahe: Nácani tisuapa­nayare eta numeta­rapiana, máepena­ca­ca­nayare éna —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Najica­pa­varepa ena ticatia­na­canahi: —Jéhevare puiti, vímatia­cavipa eta pimáuri­shi­va­quenehi. Apana­sicáji ena profetana tépenanahi, émapa ema Abraham. Tásiha puiti, picahe­cha­ji­ri­ru­vavare eta nácani tisuapa­nayare eta pimeta­rapiana máepena­ca­ca­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Pivara­ha­papuca picachu­ri­cayare ema viáchucaini Abraham, apanasica ema tépenahi, énapa ena profetanaini. ¿Nájaha­visica piti pivayu­yua­cavapa? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ema Jesús majica­pa­varepa: —Tájina nucuna­cha­ca­rémahi, te nútiji­ri­ca­va­rí­chu­chapuca nucuna­chavahi. Marari­hisera ema Tata ticuna­chanuhi, ema ímija­cha­quenehi ema ecasiña éti. ");
INSERT INTO ignNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Éti ímija­chavahi ímati éma. Váhinéni ímatihini. Jéhevare núti nímatihi éma. Téhesera numeta­ca­hehini eta numaima­tirahi, népiya­hi­ra­hi­ri­pa­pucaini nácuti­he­rí­pahíni éti. Étasera yátupi­quenehi eta nímatirahi éma, nusuapa­hivare eta mavanai­ripiana. ");
INSERT INTO ignNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ema víyarahaini Abraham ema iáchucaini, tétavi­cavahi eta máurisa­mu­revahi eta máimati­ranuhi núti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tacahe, ena ticatia­na­canahi náichapa: —¡Vuíchaha pácayehe cincuenta áñoina! ¡Picaemu­ñavapa pímati ema víyarahaini Abraham! ");
INSERT INTO ignNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ema Jesús majica­pavare: —Nutupiruva numetacahe: Májinai­chahahi ema Abraham, nunasi­que­ne­ripahi núti —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tacahe, tiápaju­cavapa eta nasema­nevahi. Navehapa eta márijahiana, nayuca­ya­repaini éma. Tiúchuca­pasera éma eta te Templo. Tiyanapa tiyumu­ru­cavapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tacahe, eta mapaisirahi ema Jesús te tajuhe eta avasare, máetupiacapa ema achane máimiuchurehi eta mapuchu­quivahi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eta véhisi­rapahi ema Jesús viti máimitureana, viyase­recapa éma: —Tata maestro, ¿tájahapuca tiviuchahi ema maca eta mapuchu­quivahi te tiúchucainapa? ¿Énapuca tiviuchanahi ena ticachichana, téhesera mapeca­tu­rai­chu­hipuca éma? —vicahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tacahe, tijica­pa­havipa: —Váhinéni étaina taviuchahini eta mapecatura éma. Énaripa ena ticachichana, váhivare énapa­racaina. Matupa­ra­haichuhi me Viya, mavarairahi nímere­ca­yarehi puiti eta máitupa­ji­jia­si­ravahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Núti apanava nucama­pu­rayare eta sache níchirayare eta máemata­ne­repiana ema Tata eta mavane­si­ranuhi taicha járaja­pavare eta yati nájina ticaema­tanena. ");
INSERT INTO ignNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ticama­pu­ra­va­ca­re­richaha eta nutiari­hirahi te juca apaquehe nuti namicahuhi ena achaneana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tásiha, tiátutuicapa te apaquehe ema Jesús. Máepiyacapa eta tiúrajichicha te matuture. Mayaji­hau­quichapa ema púchuqui. ");
INSERT INTO ignNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tásiha, máichapa: —Piyana picasi­pau­quipana tayehe eta noque ticaijare Siloé —máichapa. (Te véchaji­riruva, eta Siloé ticaijare Vanairuca.) Tacahe, ema púchuqui tiyanapa ticasi­pau­qui­panahi. Tíjahúchava tímairirica. Tichavapa te mapena. ");
INSERT INTO ignNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Náraminehi ichape ena machaca­ya­pe­nanahi énapa ena tímatianahi eta mapuchu­qui­vainihi. Tásiha, nacahepa: —Vímatihi ema émana limosnerohi púchuquihi. Émasera ema maca achane tímairi­ricahi. ¿Apanapuca éma? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Najicapapa ena tímatianahi yátupi: —Émara ema maca. Ema apana, macahevare: —Vahi émaina. Mavasichucha. Émasera ema achane púchuquinihi máichavacapa: —Nútira núti púchuqui­nuinihi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tásiha, nayase­recapa ema achane: —¿Tájaha píchara­cavahi eta pímairi­ri­sirahi? —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Éma majicapapa: —Ema maena achane ticaijare Jesús máepiyacahi eta tiúrajichicha. Tásiha, tiyaji­hau­qui­chanupa. Tivane­canupa nucasi­pau­quipana te noque Siloé. Te nuyanapa nucasi­pau­qui­panahi, nímairi­ri­ca­rinehi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Éna náichapa: —¿Táviha ema mácara achane? Éma majicapapa: —Jéhepuca, vahi nécha. ");
INSERT INTO ignNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Tacahe, nasamai­ri­ricapa ena fariséoana eta manara­sirahi ema púchuquinihi. Tásiha, nacava­nai­ripipa náepana ema púchuquinihi, taicha natanucahi éna eta tiviucha­yarehi ema Jesús. Ichape­rinehi eta nacatia­na­sirahi éma táichavenehi eta máipure­sirahi te jena sache sávaru­mu­hu­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Te títecapapa ema púchuquinihi, nacatu­pihapa éma te namirahu. Nayase­recapa tájaha­hipuca táichara­cavahi eta máimairi­ri­si­raipahi. Éma, máichavacapa: —Ema achane típuchanuhi tiyaji­hau­qui­chanuhi eta mátuture. Tásiha, nucasi­pauquipa. Nímairi­ricapa —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nararihi ena nacahepa: —¡Ema mácara achane vahi machaneraina ema Viya, taicha vahi mapicau­chahini eta sávaru­muhuana tacapi­ca­huquene! Ena apamuriana, ánivare nacahe: —Váipari­ne­hisera máiturue­que­ne­haimahi maicha eta tiárami­careana te yátupi­nahini macape­ca­tu­ra­ra­hihíni —nacahepa. Tacahe, apana­pa­ne­nejiana eta napane­reruana. ");
INSERT INTO ignNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tásiha, nápechavare nayasereca ema achane: —¿Tájaha picayema píti mayehe ema achane ticaimai­ri­ri­cavihi? Éma, máichavacapa: —Núti németeaca émahi ema profeta. ");
INSERT INTO ignNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Énasera ena tuparai­rucana váhiquene nasuapahini eta émairahi ema púchuquini. Tásiha, náimichuhapa ena ticachi­chanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nayase­recapa: —Vivaraha viyase­recahe: ¿Yátupihi eta máimiuchurehi eta mapuchuquiva ema pichicha? ¿Tájaha táichara­ra­cavahi eta máimairi­ri­sirahi puiti? ");
INSERT INTO ignNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ena ticachi­chanahi najicapapa: —Yátupi ema maca ema vichicha. Máimiuchu­re­hivare eta mapuchu­qui­vainihi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Váhisera véchahini tájahapuca táichara­cavahi eta máimairi­ri­sirahi. Váhivare vecha nájahapuca ticaimai­ri­ricahi. Émaina eyasereca. Ajairaripa éma. Émapa téchinavahi eta mameta­si­ra­heyare —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tacahehi eta najica­pirahi taicha tipicanahi éna nacaicu­ñahini, nacaqui­ji­hi­varéni te náuruji­si­ra­revana taicha ena ticatia­na­canahi ema Jesús nacuchucapa eta vantu, nacava­na­ri­pirapa nacuija nasuapa ema Jesús émairahi ema Cristo. ");
INSERT INTO ignNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eta tacahehi eta náichirahi: “Émaina eyasereca. Émapa téchinavahi”. ");
INSERT INTO ignNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tacahe, ena tuparai­rucana nápechavare náicha ema achane púchuquini. Ánipa nacahepa: —Pátupiruva pimeta­cahavi te máijarepuca ema Viya eta pinara­sirahi. Vítisera vímatihi ema maena achane tisipe­ca­tu­rarahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Éma majica­pa­varepa: —Jéhepuca, vahi necha núti te tisipe­ca­tu­ra­ra­hi­hipuca éma. Tacarichu néchahi eta nupuchu­qui­vainihi nuti, puítisera nímairi­ri­caripa máicha —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nápechavare nayasereca éna: —¿Tájaha máichara­cavihi eta macaimai­ri­ri­si­ravihi? ");
INSERT INTO ignNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Majica­pa­varepa éma: —Cápachi numeta­ca­heripa. Vuíchahacaru esuapanu. ¿Evara­ha­hi­pu­casera éhicayare éma éti apanavare? —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tacahe, nacajachapa éma: —¡Pítisera péhicaipahi éma! Vítisera véhicahi ema víyarahaini Moisés. ");
INSERT INTO ignNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Taicha véchahi eta máechaji­sihahi ema Viya ema Moisés. Émasera ema máenatataji, vahi vecha távihapuca másiha —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ema achane majica­pa­varepa: —¡Tájina échaquenéna éti páureanasami! Vahi ímatie­queneha távihapuca másihahi ema ticaimai­ri­ri­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Váhipuca echa váiparinehi tisama­ca­remahi mayehe ema Viya mácani achane ticape­ca­tu­rarahi. Nacarichu tisuapa­ca­reanahi nácani títauchanahi eta mavanai­ri­pianahi ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Váhivare visamai­ririca nácani nacaimai­ri­ri­cahini ema mácani máimiuchurehi eta napuchuquiva. ");
INSERT INTO ignNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Núti németeaca te tacuijahini eta vanairu­cairahi me Viya ema maena achane, váhiva macura­ta­hahini maicha eta tiárami­careana máichaque­neanahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tacahe, tisemanapa éna eta máichira­vacahi. Nacahepa: —¡Píti pétaviu­re­quenehi eta picape­ca­tu­raivahi! ¡Éta tiviuchavihi! ¡Puiti pisapihapa pivarahaya pímitu­cahavi víti! —náichapa. Tásiha, nacuchucapa éma. ");
INSERT INTO ignNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ema Jesús masamai­ri­ricapa eta náquiji­sirahi ema máipucha­quenehi. Tásiha, te macainu­na­varepa, máichapa: —¿Pisuapapuca píti ema Machicha ema Viya? ");
INSERT INTO ignNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ema achane majicapapa: —Pimeta­ca­nupaini, tata. ¿Nájahapuca ema Machicha ema Viya, apaesa ­ nusuapahini? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ema Jesús majicapapa: —Nútiripara nuti pímaha­quenehi, nuti péchaji­runuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tacahe, ema achane tépuyucapa te mamirahu ema Jesús. Tásiha, máichapa: —Nusuapavi, Tata —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ema Jesús máichavarepa: —Núti tímite­canuhi te juca apaquehe, nímima­ti­chayare ena máimati­ra­hanahi eta yátupi­queneana máechaji­ri­ru­vanahi ema Viya, apaesa náimatie­queneha. Eta juca tímicu­ti­ji­ri­cavahi nucaimai­ri­ri­ca­yarehi nácani púchuquianahi tayehe eta máechaji­ri­ru­vanahi ema Viya. Nácanisera tímija­cha­vanahi téchema­rahiana, nímahaya te najaca­papuca eta nímiturapi, tísapa­va­na­ya­repuca eta nucaimai­ri­ri­si­ra­va­cayare. Téhesera vahi nacuisapava, tiápaju­pa­na­vainapa eta napuchu­qui­vayare. Étapa naviure­va­yarehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tacahe, ena fariséoana natiari­hi­que­neanahi te machacaya, eta nasamirahi, nayase­recapa: —Píti pímija­cha­ha­vi­ri­papuca púchuqui­havihi. ¡Váhira púchuqui­ha­vi­nahini! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ema Jesús majica­pa­vacapa: —¡Éti épiya­cavahi púchuquihe! Taicha vahi evaraha esuapa­nuhini. Tásiha, tanasipa eta eviurevahi táichavenehi eta epeca­turana. Te yátupi­na­hi­pucaini esuapa­nuhini, tacuijahini taviucha­hehini —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Tacahe, ema Jesús máechaji­sihahi eta tajanea­casiva eta uvesa, máimicu­ti­chirahi eta macatiu­chirahi ena téhicanahi éma. Ánipa macahe: —Nutupiruva numetacahe: Mácani tijanea­recahi eta uvesa, tétavi­cavahi eta máechapa­ji­ri­si­ra­yarehi. Te yátiana, máimisia­pa­yarehi te tapena, tásiha, máeratacapa eta tapajacura eta majanea­sirahi, apaesa tájina tacuqui­chi­ravaina. Taicha nararihi ena tiámerahiana, ticaete­ma­ra­hia­navare. Navarahahi ticayu­mu­ru­quia­na­yarehi eta nasiapi­ra­yarehi te tapena eta uvesa, námecha­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Émasera ema pástulero, te yáticarahi mavejié­que­nehahi eta tapaja, máichuhahi eta táijareana eta uvesana. Eta máichuirahi, tiúchuchu­ji­ca­napaipa táehicapaipa, taicha táimatia­huchahi ema pástulero. ");
INSERT INTO ignNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Éma, máinapu­mi­rau­chapaipa eta mayeheana uvesa. Táehimu­ri­hapaipa tamutu eta uvesana, taicha táimatihi eta mahu. ");
INSERT INTO ignNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Váipari­ne­hiséra táehicaimahi mácani apanaquene achane. Tavara­ha­yarehi tijuna­racana taicha vahi táimatia­hu­chahini ema apanaquene —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ema Jesús máimicu­ti­chinahi eta juca. Váhisera nácaicu­tia­rahini éna eta máimitu­si­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ema Jesús mápechavaca máimitu­cavaca. Ánipa macahe: —Nutupiruva numetacahe: Núti nímicu­ti­ji­ri­cavahi tapaja­curahi eta tapena eta uvesa te tanara­si­rarehi éta. ");
INSERT INTO ignNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tínapu­mi­rau­cha­nuanahi ena tépiya­cavana máestroana, váhisera máimitu­rea­nai­nahini ema Viya. Tiámera­hia­nachucha éna, ticaete­ma­rahiana. Váhisera táehicaimahi eta uvesana taicha vahi táimatia­hu­chahini éna. ");
INSERT INTO ignNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Núti nujanea­ca­vacahi ena nuchanerana, nucutihi eta tapena eta uvesa. Nácani ticasi­ñavana eta nuyehe, nucatiu­cha­yarehi núti. Tájina náichavaimahi, tájinavare náechuria­caimahi. Néchavacahi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ema tiámerahi, tímitecahi éma tiámere­cayare, ticapa­re­cayare. Macaeja­ne­re­pai­ca­yareva. Nútisera tímite­canuhi níjara­cayare eta náitare­siraya. Máitava­ca­cayare eta náurica­ca­re­vayare nícha. ");
INSERT INTO ignNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Éneri­chuvare núti yátupi­quenehi eta nujanea­si­ra­vacahi ena nuchanerana, tacutihi eta majanea­si­ra­vacahi mácani achane eta mayeheana uvesa. Núti níjarareca eta nítaresira eta nucatiu­chi­ra­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mácanisera tuparai­ru­cachucha, vahi macatiu­chaimahi eta uvesa. Te máimahapa eta tinicarahi sárare, tijuna­yarehi. Vahi tipatsi­ca­vaimahi macatiucha eta uvesa, taicha vahi mayehe­nahini. Tacahe, eta tinicarahi ticama­pu­ra­vainapa tacapa­cayare eta uvesa. Eta tacaitiruana, téjane­re­pai­canapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ema maca achane tijunaya taicha vahi téñama­vaimahi tayehe eta uvesa. Éma tímija­chavahi majanea­cavaca, étachu­chasera macunehi eta mavacha. ");
INSERT INTO ignNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Núti yátupiquenénu pastulérunu taicha tiúrihi eta nujanea­si­ravaca ena nuchanerana. Tímati­nu­hivare ema Tata, tacutihi eta nímatirahi núti éma. Éneri­chuvare tacahehi eta nímati­ra­vacahi ena nuchanerana. Éna tímati­nua­na­hivare. Eta néñamai­ra­vacahi, núti nímija­ra­re­cavahi eta nítaresira náichavenehi éna. ");
INSERT INTO ignNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Narari­hivare ena apamuriana nuchanerana. Váhisera ánina nacavasa. Nucuru­ji­ca­va­ca­ya­resera, népana­yareva. Tisuapa­nua­na­yareva namutu. Étanayaréichupa eta náumuriva. Nucari­nenapa núti néchavaca. ");
INSERT INTO ignNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ema Tata, yátupihi eta máemuna­siranu taicha nímija­ra­recahi eta nítaresira náichavenehi ena nuchanerana. Nuchava­ya­resera nítareca. ");
INSERT INTO ignNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nájinanéni napami­ca­nuhini eta nísapi­ravaya ticapa­canuana. Níjara­ruvahi núti eta nacapa­si­ranuya. Taicha nutupa­ra­haichuhi me Tata núti néchina­va­yarehi. Níjara­ru­vayare. Tásiha, nuchava­yareva nítareca —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Eta nasamirahi ena achaneana eta juca máechaji­ri­ru­vanahi ema Jesús, típutsi­mu­ria­va­va­ca­varepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Natiarihihi ena ticatia­na­canahi. Nacahepa: —¿Tájaha tacayema esuapa ema mara? Máurishi éma, mávahárupuca ema Váinaraji —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Énasera ena apamuriana, ánivare nacahe: —Te yátupi­nahini mávaháruinahini ema Váinaraji, vahi macura­ta­hahini macaimai­ririca ema púchuqui. Nájinavare mácuti eta máechajisira —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te jena sácheanahi diciembre­quenehi eta ticasa­ra­hi­muhuana te Jerusalén, ena achaneana napiestachahi eta año táepani­ravahi náetupirica eta Templo. ");
INSERT INTO ignNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ema Jesús matiarihihi te tajuhe eta te Templo te tayehe eta alar máepiyaruhi ema Reyni Salomón. ");
INSERT INTO ignNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Te náimahapa ena ticatia­nacana, nachayacapa ema Jesús. Tásiha, náichapa: —¿Tájaha tacayema pímipa­ne­re­re­cha­havihi? Pátupi­ruvapa pimeta­cahavi te yátupi­vi­hipuca pítiquenehi Cristo —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ema Jesús majica­pa­vacapa: —Cápachi numeta­ca­he­ripahi. Vuíchahacaru esuapanu. Eta juca níchaque­neanahi ímaha­que­neanahi tásiha­que­neanahi me Tata, étaripara tímereu­chanuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Étisera váhiquene esuapanu. Taicha vahi étinahíni nuyehe­he­nahini uvesa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eta nuyeheana uvesa tímatia­hu­cha­nuanahi éta. Núti apanavare nímati­va­ca­hivare. Eta tacahe, téhica­nuanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Níjara­ca­va­ca­ya­resera núti eta náitare­si­rayare máichecua­ra­qui­reyare. Váhiquene náimahahini eta náicuñayaréni. Nájinavare tivere­ji­ca­nua­naimahi ena nujanea­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taicha máijara­ru­nuanahi ema Tata. Éma, nájina ticachu­ria­cai­nahini. Nájinavare tirata­haimahi tivere­ji­caimahi ena majanea­ruanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taicha núti émapa ema Tata vicuti­cacahi eta vítupa­ji­jia­si­ra­va­vacahi —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tacahe, ena ticatia­nacana natanucapa eta márijahiana. Navarahapa natupi­si­ca­ya­rehini ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Máichava­ca­pasera éna: —Ichape­murihi eta níchirahi eta táuriqueneana ímaha­que­neanahi, máijara­ruanahi ema Tata. ¿Étase­rapuca tiviuchanuhi eta evarairahi etupi­sicanu te márijahi? ");
INSERT INTO ignNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tacahe, najica­pa­varepa: —Vahi étapa­racaina eta píchirapuca jácani táurique­neanahi. Eta tiviuchavihi pímija­chi­ravahi machichavi ema Viya. Pítirichuhi vicuti­quenehi achane. ¡Pítisera pímija­cha­vaipahi Víyavi! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ema Jesús majica­pa­varepa: —Eta ajureca te Salmo, vahi ímatie­que­ne­hahini eta táechaji­sia­herahi eta macaye­ma­quenehi ema Viya: “Víyahehi nícha eti nunere­ji­ru­hea­nahi”. ");
INSERT INTO ignNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Véchahi eta tacaye­ma­quenehi eta ajureca, vahi tépiya­hi­ra­himahi. Taicha tamutu eta táechaji­ri­ruvana eta Sagrada Escritura táechaji­si­hairahi eta juca máechaji­ri­ru­vanahi ema Viya. Nácani nacatu­pa­rahahi me Viya, éma tímija­re­cha­vacahi “Víyanahi”. ");
INSERT INTO ignNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nútiripa puiti, nuvetijipa nímija­re­chacare “Viya” taicha émarichu ema Viya tinere­ji­canuhi, tivane­canuhi eta núcupai­siraya te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Núti nítaucharahi eta mavanai­ripiana ema Tata tivane­canuhi. Tásiha, tatupa­racahe esuapa­nu­va­ne­yarehi. Tayanapane vahi tisuapa­carehi eta nímitu­rapiana eta eyehe, étapa­seraini esuapahini eta tiárami­careana níchaque­neanahi. Étara tímereu­chanuhi eta mávahásiranuhi ema Tata, návahásira­hivare núti apanava éma —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tacahe, tiápecha­va­na­varepa navaraha nacara­ta­ca­ya­rehini ema Jesús, napresu­cha­ya­rehini. Émasera tiúchuca­vanepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tásiha, tiyana­varepa ema Jesús te tinapaica te apachara eta cajacure Jordán. Manasi­panapa eta te avasa­rechicha Betábara te máicacha­si­ri­si­nehini ema Juan. ");
INSERT INTO ignNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Camuriana ena achaneana tiyana­ra­canahi eta mayehe. Tásiha, nacahepa éna: —Ema víyarahaini Juan, tayana­panehi tájina máimere­cahini eta tiárami­careana, yátupi­hisera eta profetairahi éma, taicha tamutupa eta mameta­rapiana mayehe ema maca Jesús, vímaharipa puiti eta yátupi­que­neanahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tacahe, ánaqui camurianahi ena achaneana tisuapanahi ema Jesús, téhica­nahivare. ");
INSERT INTO ignNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Matiarihi ema achane ticaijare Lázaro. Éma, máemuna­ca­sarehi ema Jesús. Ticavasahi tayehe eta avasa­rechicha ticaijare Betania, návasa­hivare ena mapara­pe­naveana, esu María ésupa esu Marta. Te jena sácheana, ticajumahi muraca ema achane. ");
INSERT INTO ignNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Esu suca María, ésuhi esu tisipa­pe­vachahi ema Jesús tayehe eta táijiye­quenehi perfumeama. Suájape­va­cha­hivare te suchutimaca.) ");
INSERT INTO ignNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tacahe, ena náni apinana esenana ticapa­ra­pe­cacana náimiva­ne­recapa, nameta­pa­na­yarehi ema Jesús eta macaju­mairahi muraca ema Lázaro. ");
INSERT INTO ignNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te máechapa ema Jesús, macahepa: —Eta juca jumare, vahi títaimahi ema Lázaro. Matupa­ra­hai­chusera me Viya, mavarairahi nímereca eta máitupa­ji­jia­sirava éma, nímere­si­ra­yareva eta nítupa­ji­jia­si­ravahi nuti Machicha, apaesa nacuna­chahavi ena achaneana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jéhesare, ema Jesús yátupihi eta máemuna­sirahi ema Lázaro, énapa ena esenana mapara­pe­naveana. ");
INSERT INTO ignNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Váhisera mayana­va­nehini máimaha­panahíni ema máemuna­casare. Manasi­richaha apinahi sache. ");
INSERT INTO ignNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tásiha, te apanapa sache, ema Jesús máichahavipa viti máimitureana: —Viyana vichava te Judea. ");
INSERT INTO ignNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Víti vijicapapa: —Tata maestro, cáperichaha ena ticatia­na­ca­vianahi navarahahi ticapa­caviana. Tásiha, puiti pivara­haichaha piyanayare ánaqui nayehe —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ema Jesús máechaji­sihahi eta mavane­ca­sivahi. Máichahavipa: —Vahi táeñamaváca­rehini. Yátupi eta sache ticayehe doce hora. Te vipaica te sáchemuhu, vahi vicáyutetuímahi taicha vímairi­ricahi tayehe eta tijarahi. ");
INSERT INTO ignNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nácanisera tipaicanahi te yátimuhu, ticayu­te­te­re­jia­na­yarehi taicha vahi náimairi­ri­cahini. Ema Tata tijanea­canuhi núti taicha nítauchahi tamutu eta mavara­ha­queneana. Vahi máisapahini jácani náichanuhini; tapaenumava máimaha tiuri —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tacahe, te táequenepa, macahe­varepa: —Ema vémuna­casare Lázaro máenahi tímacahi. Nuyana­ya­resera nucaja­mi­pa­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Víti víchapa: —Tata, te tímaca­hipuca éma, étapa táicutiarahi eta mativa­reraya —víchapa ema. ");
INSERT INTO ignNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","14","Víti vímija­chaichucha yátupihi tímaca. Tásiha, ema Jesús matupirupa timeta­ca­havihi: —Tépenaipa ema Lázaro. ");
INSERT INTO ignNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Núrisa­mu­resera eta májina­nuirahi eta ánaqui. Tiúripanaya eta eyehe taicha ímahaya eta níchaque­neyare apaesa esuapanu. Puiti viyanaya vímaha­pa­nayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tacahe, ema vichamuri Tomás máichahavipa viti machamuriana: —Viyana víti apanavare. Te nacapa­capuca éma, nacapa­ca­ha­vi­rineva víti apanava —máichahavipa ema Tomás. (Tatiari­hivare eta máchucarapi Chame.) ");
INSERT INTO ignNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Tiuri, viyanapa vicaijuhe eta avasa­rechicha Betania. (Eta Betania tachacayahi eta Jerusalén, apina kilómetro y medio eta tayere­hivahi.) Tásiha, te viánehipaipa, timeta­ca­ha­vianapa cuátroripa sache eta náecarairahi ema Lázaroini. ");
INSERT INTO ignNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Camuria­na­hi­cha­hasera ena achaneana te napena ena mapara­pe­naveana, esu Marta ésupa esu María. Nacami­ti­si­ri­panahi apaesa vahi nacuiya­ha­ra­cavaicha ena apinana. ");
INSERT INTO ignNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tacahe, te suéchapa esu Marta eta máiteca­pi­ra­yarehi ema Jesús, tiyanapa suácapahi. Ésusera esu María sunasi­richuhi te tajuhe eta peti. ");
INSERT INTO ignNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te suéchajicapa esu Marta ema Jesús, sumetacapa eta máepenirahi ema suparapeini. Tásiha, suíchapa: —Tátachicha, te pitiari­hi­nahini eta ani, vahi ñicuepe­nahini eñi nuparapeini. ");
INSERT INTO ignNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Váhisera néñamava. Nucasi­ñavihi eta piyehe. Pímahainepa píti eta pícharacaya eta piyasea­si­rayare eñi Viya —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ema Jesús majicapapa: —Tiuri eta péñamirahi ema piparape. Váhisera picupica. Tichavayare títareca te pimirahu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Esu Marta suíchavarepa: —Yátupi, Tata, néchahi eta ñichavi­rayare títareca te táitecapapa eta sácheyare náechepu­siraya ena náepena­queneana —sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ema Jesús máichavarepa: —Jéhevare núti, nucaita­rerahi nácani nucaeche­pu­reanaya. Táitusiava numetacavi: Nácani tisuapa­nua­nayare, tayana­pa­nepuca náepena, nucaita­re­ca­ya­resera núti. ");
INSERT INTO ignNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ene ecaheyare éti éhica­nuanahi, tayana­pa­nepuca épenayare, nútisera nucaita­re­ca­heyare. Tásiha, tájinapa tímiape­chaimahi épenahini. ¿Pisuapa­nupuca eta níchiravihi? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ésu sujicapapa: —Nusuapavi, Tata. Pítira yátupiquenévihi Cristo, Ñichichavi eñi Viya. Pítiripa piti vicucha­paquenévihi píteruyarehi te juca apaquehe —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Te títapi­ricapa eta suéchaji­sirahi esu Marta mayehe ema Jesús, tiyanapa suíchuha­panahi esu suparape María. Sujajaicapa, ani tacahehi eta suíchirahi: —Eñi Maestro ñirarihi eta ani. Ñicava­nairipi piyanayaréji —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te susamapa esu María eta matiari­hirahi ema Jesús, téchepu­ru­ca­vanepa. Tiyana­varepa suácapahi. ");
INSERT INTO ignNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Taicha ­ ema Jesús vuíchaha máiteca­pahini te napena. Manasi­richuhi eta te suácapinehi esu Marta. ");
INSERT INTO ignNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eta náimairahi ena suchimarana eta suéchepu­sirahi súchusirahi esu María, tiyananapa náehieque­nehahi. Náimijachahi éna tiyana­yarehi ésu te máecari ema suparapeini, tíyaha­pa­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tacahe, te suíteca­pauchapa ema Jesús, esu María sutupirupa tépuyucahi te máivape­chacaya. Tásiha, suíchapa: —Tátachicha, te pitiari­hi­nahini eta ani vahi ñicuepe­nahini eñi nuparapeini —suíchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","35","Tásiha, tíyahapa esu María, énapa ena téhica­napahi ésu. Eta máimairahi ema Jesús eta náiyairahi, ticati­sa­mu­re­va­varepa éma apanavare. Tíyaha­varepa. Tásiha, mayase­recapa: —¿Táviha écarihahi? —máichapa. Ena najicapapa: —Yare, Tata, pímaha. ");
INSERT INTO ignNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tacahe, ena natiari­hi­queneana eta náimairahi eta máiyairahi ema Jesús, téchaji­ca­canapa: —Piáha. Tíyahavaréra éma apanava. Tétavi­ca­vahipucáji eta máemuna­sirahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ena apamuriana, ánivare nacahe: —Ema maca ticaimai­ri­ricahi ema púchuqui. ¿Tájahapuca vahi macana­ra­cahini ema Lázaroi­nisami, apaesa vahi macuepenahini? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tacahe, ichape eta macati­sa­mu­re­vairahi ema Jesús. Mapauchapa eta ecari naseca­jueruhi te mari. Tatiari­hivare eta márime tajiha­jacahi eta tapajacura eta ecari. ");
INSERT INTO ignNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tacahe, ema Jesús mavane­ca­vacapa: —Ecaerajica eta jara tachujihi eta máecari. Ésusera esu Marta suíchapa: —Tata, németeaca tijecheripa jácani taicha cuátrorípahi sache eta ñépenirahi ­ —sucahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ema Jesús máichavarepa: —Cápachi numeta­cavipa, te pisuapanu yátupina, pímahayare eta macuna­cha­ca­revahi ema Viya taicha nímerecaya eta tamutuirahi marataha —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tacahe, nacaera­jicapa eta márime. Tásiha, ema Jesús máesenicapa te anuma, tiyuja­ra­ca­numapa: —Tata, nuhasu­lu­pa­yachavi eta pisami­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Váhiquene péñauchanu eta jácani nuyasea­ruviana. Puiti nuyaseacavi eta pítupa­jijiásirava, apaesa náimaha ena nani achaneana natiari­hi­que­neanahi, apaesa nacunachavi. Náechavare eta pítirahi pivanecanu —macahepa éma. ");
INSERT INTO ignNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te títapi­ricapa eta mayuja­ra­sirahi, máimara­racapa eta ecari. Tipiaracapa muraca, ánipa macahe: —Lázaro, péchepuca eta te jara piávihahi. Yare, piúchuca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tacahe, ema máepenaquenénihi tiúchucapa. Mámapaichuhi eta máyuru­hanahi étapa eta máepaca­mirahi. Tásiha, ema Jesús mavane­ca­vacapa naveruruaca eta máyuru­hanahi, apaesa tiyana­yarepa te peti. ");
INSERT INTO ignNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tacahe, ena suchima­ranahi esu María, eta náimairahi eta juca máichaquenehi ema Jesús, camuria­na­rinehi ena tisuapanahi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Natiari­hisera ena apamuriana tiyananapa nayehe ena fariséoana ticatia­na­cahahi ema Jesús. Eta namauri­sirahi eta juca, tiyanana nameta­pa­navaca ena tuparai­ru­ca­na. ");
INSERT INTO ignNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tacahe, ena tuparai­rucana náimichuhapa namutu ena juéseana, ticuru­ji­ca­canapa. Tásiha, nacahepa: —¿Tájaha víchara­ca­vayare, tátanaveana? Ema maena achane Jesús, tétavi­cavahi eta máitupa­jijiási­ravahi máichahi eta tiárami­careana. ");
INSERT INTO ignNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Vahi táuricahini vísapahini máimiya­na­vahini máitare­cahini, machu námuturiana náehica ena achaneana, masapi­hai­na­papuca nasuapayare éma. Machu ena aquenucana romanoana náimija­chi­na­papuca tatiari­hiyare eta tíñepiyare. Tisema­nai­na­papuca. Náraja­pai­na­papuca eta ani. Náquipai­si­na­ha­vi­na­papuca eta viávasa. Nasapi­hai­na­papuca tivere­ji­ca­ha­via­nayare eta viávacu­reanahi —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Matiarihihi ema achane ticaijarehi Caifás. Émahi ema ichape­quenehi tiyuja­ra­carahi te jena áñohi. Tacahe, máichavacapa éna: —Éti vahi ímatie­queneha eta víchara­ra­ca­vayare. ");
INSERT INTO ignNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Németeaca núti tiúripana máepena ema émanaina achane mavachareca eta náitare­siraina namutu ena apamuriana achaneana —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eta juca máechaji­ri­ruvahi ema Caifás, váhinéni étainahini táichahini eta máechema­raivahíni éma. Étahi eta émairahi ema ichape­quenehi tiyuja­ra­carahi te jena áñohi. Manaca­sa­mu­re­ruichuhi ema Viya eta máechaji­sihahi eta máepeni­rayare ema Jesús náichavene ena israelítana. ");
INSERT INTO ignNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Étasera juca máepeni­ra­yarehi ema Jesús, mavacha­re­cainapa eta naviurevahi namutu nácani machane­ra­na­yarehi ema Viya te apana­pa­ne­ne­queneana avasareana. Vahi tácari­chuhini eta naviurevana ena israelítana. Taicha te táequenénapa, mavarahahi macuru­ji­mu­ri­ha­yarehi, étamu­ria­na­yarehi namutu éna. ");
INSERT INTO ignNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tacahe, tacutipa eta napane­reruhi ena tuparai­rucana eta nacapa­si­rayare ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eta tacahe, ema Jesús vaipa máimere­ca­vahini eta te Jerusalén. Majuni­jicapa eta Judea. Tiyanapa eta te mávapahi apaquehe tachacaya eta avasare ticaijare Efraín. Manasi­panapa ánaqui, vítipa viti máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tacahe, semanayare eta Pascua, vipiestara viti israelítana. Namutu ena achaneana tiávihana te apanana avasareana tiyana­ra­canapa tayehe eta Jerusalén. Tisipa­ha­ca­va­na­yarehi taicha náimijachahi ani tacahehi tacuija nacuqui­chi­ravaina eta náimere­si­ra­vayare me Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tacahe, ena achaneana nacune­paipahi te Jerusalén ema Jesús. Eta návihairahi te Templo, téchaji­ri­ca­ca­naripa. Ánipa nacahe: —¿Tájaha ecayema? ¿Títeca­yarepucáji ema Jesús puiti juca piéstaya? —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Énaripa ena tuparai­rucana tivane­re­canapa ena ticunea­nayare ema Jesús. Te matiari­hi­napuca, nameta­pa­na­yarepa ena tuparai­rucana. Tásiha, éna náimica­ra­ta­ca­yarepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Séisirinehi sache eta piéstayarehi eta Pascua. Tichava­varepa ema Jesús tayehe eta avasa­rechicha Betania, mávasahi ema Lázaro, ema macaeche­purehi te máecari. Tacahe, ena máemuna­ca­sareana tiúrisa­mu­rea­na­rinehi eta náimairahi eta máiteca­pirahi ema Jesús eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ticache­ru­jianapa náenica­yarehi. Ema Lázaro macachanehi te mesa eta nanisirahi. Esu Marta téchapa­ji­ri­ca­vacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tacahe, esu María suámapaipa eta táijiyequene perfumeama te bótechicha. (Te navírare eta juca perfumeama te nasucure ticaijare nardo.) Tétavi­cavahi eta tasiva­chavahi. Ticutia­ma­cacahi te botella eta tasiamavahi. Tacahe, suépusa­pe­vachapa ema Jesús, suájape­vachapa te suchutimaca. Eneva­nerine táinicajuecha eta peti eta táijiyevahi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Matiarihihi ema vichamuri Júlasi. Ema maca émarichu tíjara­re­ca­yarehi ema Jesús. Témecha­ji­cavapa éma: ");
INSERT INTO ignNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Tájaha tacayema váhivaréyapa tacaija­ra­re­ca­sihini eta juca tasiva­cha­quenehi perfumeama? Vivehahini eta camuriquene plata, tásiha, vímica­ta­si­hahini ena páureana —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ema maca Júlasi, vahi étainahini eta majapa­nui­rai­nahini ena páureana. Étachuchanéni mavarairahi mayumuruca eta plata, taicha ema tiámerahihi. Títecapa émari­chu­hivare tiúnare­carahi eta plata. ");
INSERT INTO ignNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tacahe, ema Jesús máichapa: —Pésamirica esu suca esena. Suíchachaha ésu eta suvara­haquene taicha nícumu­nuichuhi eta juca tayehe­yarehi eta nécari. ");
INSERT INTO ignNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ena páureana, tamutuchucha sácheana eta ecacha­ne­ra­va­cayare éna. Te jácani ávara­ha­papuca ímica­ta­cayare, nararihi ena ticamunuana. Nútisera vahi nánasiquenémahi eta eyehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tacahe, camuriana ena tisamai­ri­ri­canahi eta matiari­hirahi ema Jesús te Betania. Tiyananapa náimaha­pa­na­yarehi. Éneri­chuvare náimaha­pa­na­ya­rehiva ema Lázaro, ema máechepurehi te máecari. ");
INSERT INTO ignNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tacahe, ena tuparai­rucana napane­re­cha­varepa nacapa­ca­yarehi ema Lázaro. ");
INSERT INTO ignNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Taicha émavenehi tíchahi eta nasuapi­raipahi ema Jesús ena camuri­queneana achaneana. Vaipa nasuapahini eta navanai­ripiana ena tuparai­rucana. ");
INSERT INTO ignNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te apanapa sache, ena nani achaneana táimiya­na­que­neanahi eta piéstayarehi eta Pascua, nasamai­ri­ricapa eta máiteca­pi­ra­yarehi ema Jesús tayehe eta avasare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tiúrisa­mu­rea­na­rinehi. Eta náurisa­mu­revahi, navehapa eta tajuru eta cáchipaca. Tiyananapa nácapahi éma. Eta napiara­si­rapahi, ánipa nacahe: —¡Yare, Tata! ¡Piti yátupiquenévihi rey viyehe viti israelítana! ¡Asulupaya! ¡Piti vanáirucaquenévihi me Viya! ¡Ichape eta vicuna­chiravi piti! ¡Viva ema Viáquenu! ¡Viva! —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ema Jesús ticape­rapahi eta burricu eta masiapirahi, taicha ene tacahehi eta táechaji­ri­ruvahi eta Sagrada Escritura: ");
INSERT INTO ignNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Eti ecava­sanahi te Jerusalén, vaipa ecupica, taicha márajapa ema eyeheyare Rey. Tímati­ca­re­yarehi éma, ticape­rayare eta burricuchicha. Mámapahi eta iúrita­re­si­ra­yare” tacahehi eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eta juca ajureca eta vimacai­cu­tia­ra­quenehi viti máimitureana. Tapaenumava te máechepucapa ema Jesús, vicaicu­tiarahi eta tacayemahi eta Sagrada Escritura, táechaji­si­hairahi éma, étapa eta tamutu eta apamuriana máichara­ra­ca­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tiuri puiti, ena apamuriana achaneana tímara­ra­ca­naripa ema Jesús eta macaeche­pu­sirahi ema Lázaro te máecari, náechaji­si­haipahi éna eta náimaha­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eta tacahe, camuri­que­neanahi ena achaneana tiyananahi nácapahi éma, taicha navarahahi náimati ema tíchahi eta tiáramicare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tásiha, eta náimairahi ena fariséoana eta camuria­nairahi ena tiácapanahi, náichacacapa: —¡Váhichara víturu­caimahi taicha tétavi­cavahi eta nasimu­tuvahi ena téhicanahi éma! ");
INSERT INTO ignNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Natiari­hivare ena apamuriana achaneana apajue­cu­ruhana tayehe eta Jerusalén. Énerichuhi éna tímite­canahi tiyuja­ra­pa­nanahi te jena piéstairahi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tiyananapa napauchahi ema vichamuri Felipe. Ánipa tacahe eta nayasea­sirahi: —Tata, víti apanava vivaraha vímati ema Jesús —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tacahe, ema Felipe tiyanapa mametacahi ema Andrés. Tásiha, ena apinana tiyananapa nameta­panahi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tásiha, ema Jesús máichavacapa: —Jéhevare puiti, tiánehipa eta népeniraya nuti Manere­ji­runuhi ema Viya. Nápecha­va­ya­resera nítareca, apaesa nucuna­cha­ca­reyare eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nutupiruva numetacahe: Te vahi vicuevaca eta evaraqui te apaquehe, vahi téjapa­caimahi. Tanasi­ya­reichuhi eta tasimutuva eta evaraqui. Téhesera vévacahi, tétavi­cavaya eta táejapa­siraya. ");
INSERT INTO ignNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nácani téñama­vanahi eta náitaresira, tiávami­rahuana eta náehisiranu, énaji­vayare ticami­tie­que­ne­ha­va­nayare eta náitaresira. Nácani tíjara­ca­va­nayare eta náehisi­ra­nuyare, tájinavare vahi náeñama­vahini eta náitaresira te juca apaquehe, tiúchucu­ha­nayare éna. Máichecua­ra­qui­reyare eta náitare­si­rayare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Éneri­chuvare nácani tivara­ha­nayare ticaema­ta­nea­canuana, tacamunu tímere­ca­va­nayare yátupi eta náehisi­ranuhi. Tásiha, núti nucaeja­ca­va­cayare éna te néjasi­hayare núti. Ena nani, tétavi­ca­vayare eta macuna­chi­rayare ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ema Jesús táimipa­ne­re­recahi eta máepeni­rayare. Ánipa macahehi eta máechaji­ri­ruvahi: —Tiánehinapa eta népeniraya. ¡Ichape eta nupisirahi! ¿Tiúripuca nuyaseaca ema Tata macatiu­chanuini apaesa vahi nucuca­ta­jivaini? ¡Váhiquene nuyasea­caimahi, taicha núti tímite­canuhi te juca apaquehe eta népeni­na­vacaya ena achaneana! ");
INSERT INTO ignNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tacahe, macahe­varepa: —Tata, pímereca eta pítupa­jijiásirava apaesa nacunachavi ena achaneana —macahepa. Tásiha, tíjahúchavapa nasamahi eta mahu ema Viya te anuma. Ánipa macahe: —Nímere­caripa eta nítupa­jijiási­ravahi. Jéhesare, nápecha­va­yareva nímere­cayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tacahe, ena achaneana natiari­hi­que­neanahi nasamahi eta máechaji­sirahi ema Viya. Váhisera nácaicu­tia­rahini, náimija­chaichucha tirureca. Tásiha, ena apamuriana, ángelepuca éma téchajicahi nacahevare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ema Jesús máichavacapa: —Vahi nútivenéna eta juca esama­quenehi. Ema Tata tímisa­mahehi, mavarairahi esuapayare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Achichu juca sácheanayare, ticapa­ca­nua­nainapa ena achaneana téhicanahi ema Váinaraji. Eta nacapa­si­ranuya, tacaviu­reyare namutu ena achaneana te juca apaquehe eta náicuñayare. Eta népeni­rayare nuvacha­chainapa eta nurata­hairaya nucuchu­cu­havaca nácani ticasi­ña­vanahi nuyehe. Téqueca­va­nainapa eta nuyehe ena machane­ra­nainihi ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eta tacahe, te nacatu­pi­hanupa te anuquehe te crusu, te nacaicu­tiarapa ena achaneana apana­pa­ne­nejiana eta nasamai­ri­ri­siraya, énaji­vainapa tipaucha­nuanaya téhica­nua­nainapa —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eta juca máichira­vacahi ema Jesús, mavarahahi nacaicu­tia­ra­yarehi eta táichara­ra­ca­va­yarehi eta máepenira. ");
INSERT INTO ignNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tacahe, ena achaneana tisama­ra­ra­canahi najicapapa éma: —¿Tájahasica tacayema eta péchaji­sihahi eta pépeniraya te crusu? Viti vímija­chaipahi pítiripa ema Cristo, piti Manere­ji­ruvihi ema Viya. Víti visamahi eta Sagrada Escritura te náechajicuha máichecua­ra­qui­re­yarehi eta máitare­siraya ema Cristo. Vahi ­ vicaicu­tia­rahini —náichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ema Jesús máichavacapa: —Ecama­purava esama­ra­racanu mapurare nutiari­hichaha eta eyehe. Numicau­cha­hechaha taicha ánipirine eta juca ímaira­nuyare apaesa vahi ecuca­yutete tayehe eta timapicu. Taicha nácani tájinahi náechaquenénahi, ticayu­te­tua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Esuapanu eta juca numicau­cha­he­richaha apaesa ímitu­recaya éti apanava, iámayare eta juca tajara­hiquene —máichapa. Te títapi­ricapa ema Jesús eta máichira­vacahi, tiyanapa majuni­ji­mu­rihapa. Vaipa máimere­ca­vahini eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ichape­murihi eta náimairahi ena ticava­sanahi te Jerusalén eta tiárami­careana máichaque­neanahi ema Jesús, váhique­nesera nasuapahini éna. ");
INSERT INTO ignNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","39","Étahisera tacahehi títaucha­va­yarehi eta májucha­que­neanahi te ajureca ema profetaini Isaías tayehe eta tamura­cavahi eta namasua­pi­rayare. Ani tacahehi eta táechaji­ri­ruvahi: “Tata Viáquenu, nájina ticaicu­tia­ranaina eta péchaji­ri­ru­vanahi vímitu­ra­pianahi víti. Píti pímere­ca­ripahi eta pítupa­ji­jia­si­ravahi, váhique­nesera nasuapa­vi­hini”. Éneri­chuvare ani tacahehi eta májucha­que­neanahi ema Isaías: ");
INSERT INTO ignNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ema Viya, eta máimairahi eta namura­ca­sa­mu­re­vanahi, máisapahi tiápajucava eta namasua­pa­ji­rai­ravahi, tímicu­ti­ji­ri­cavahi púchuquiana éna. Váhiquene tétupi­ri­sa­mu­re­cha­va­naimahi. Váhivare navara­haimahi nacasi­ña­vahini me Viya, apaesa macana­ra­ca­va­ca­hini” tacahehi eta májucha­quenehi ema víyarahaini Isaías. ");
INSERT INTO ignNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","(Ema profetaini Isaías, tiáramecahi eta máimairahi te mavapure eta táetavi­siraya eta majaraiva ema Cristo, étapa eta masantuvahi eta te máejasihahi.) ");
INSERT INTO ignNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Narari­hi­hisera ena aquenu­ca­rahana tinere­ji­ca­va­na­ripahi ena tisuapanahi. Váhisera návara­hahini náimere­ca­vahini eta náehisirahi, napisirahi nacaqui­jihini eta te návacureana. ");
INSERT INTO ignNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Taicha étachucha náuricahi eta nacuna­cha­ca­revahi nayehe ena nachamuriana, ena fariséona. Tasapi­haichucha náepuruhi eta nacuna­cha­ca­re­va­ya­rehini me Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ema Jesús tijaranupa eta máechaji­si­ra­vacahi ena achaneana. Máichavacapa: —Nácani navarahahi tisuapanuana, tímati­ca­rea­naripa eta nasuapi­ra­hivare ema Tata, ema tivane­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tacutiquene nácani tímati­nuanahi eta nímitu­rapiana, náimati­pa­hivare eta mapane­reruana ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taicha núti yátupiquenénuhi eta numicau­chi­ra­vacahi ena téhica­nuanahi te juca apaquehe. Váipasera tavehaimahi eta timapicu. ");
INSERT INTO ignNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Tacutiquene núti, vahi étaina táimite­ca­nuhini te juca apaquehe eta nícuña­ca­hehini eti achaneana. Eta tímite­canuhi, nucuchu­cu­ha­he­yarehi. Nácanisera nasamai­ri­ri­ca­ri­pahinénipuca eta néchaji­ri­ruvana, váhisera nasuapa­nuhini, nasapiha tépuru­nuanahi, muraca­yarehi eta náicuñayare. Eta náepuruirahi eta néchaji­ri­ruvana, étaripa tiviucha­va­cainapa te jena sácheyare nacaya­se­se­rehipa te mamirahu ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Taicha vahi nútiji­ri­ru­vai­nahini eta nímitu­re­sirahi. Ema Tata tivane­canuhi, éma tíjara­canuhi eta nímitu­ra­pia­na­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Eta tacahe, numeta­cahehi puiti tamutu eta numeta­ca­si­vanahi. Vahi nuhapa­pi­caimahi, taicha nímatihi tacaita­re­ca­yarehi nácani tisuapanahi eta máimitu­rapiana ema Tata —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tiuri, te jena sácheanahi tamira­hu­paipahi eta Pascua, ema Jesús máecharipa táiteca­pau­cha­yarepa eta majuni­ji­si­ra­yarehi eta juca apaquehe. Tiyana­yarepa mayehe ema Maiya. Tétavi­cavahi eta máemuna­si­ra­havihi viti máimitureana. ");
INSERT INTO ignNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Jéhesare ema Júlasi, máimipa­ne­re­charipa ema Váinaraji eta máijara­re­si­ra­yarehi ema Jesús. Émasera ema Jesús, máecharipa eta machavi­ra­yarepa mayehe ema Maiya taicha eta másinehi. Émarichuhi ema Maiya tíjaracahi eta tamutui­ra­yarehi máiturue­queneha. Tacahe, te jena yati, eta máenisi­ra­havihi viti máimitureana, téchepucapa ema Jesús. Tiveja­mu­hia­cavapa eta mamuiriha. Tiáyuru­ñe­que­chavapa te mayehe paño. ");
INSERT INTO ignNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tásiha, majucuhapa eta une te bañadora. Tépanavapa tisipa­pe­va­cha­havihi eta vívapeana viti máimitureana. Maveha­varepa eta paño, tiájape­va­cha­havipa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tásiha, te macapa­yacapa ema Pedro, éma vahi máisapa­vahini eta masipa­pe­vachira eta máivape. Máichapa: —Tata maestro, vahi táurica eta pisipa­pe­va­chi­ra­nuhini núti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tásiha, ema Jesús majicapapa: —Páuresa­mivihi píti. Vuíchaha picaicu­tia­rahini eta tacaye­ma­que­neanahi eta juca. Achichui­na­pasera picaicu­tia­rainapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ema Pedro máichavarepa: —Nútisera, vahi pisipa­pe­va­cha­nuimahi. Ema Jesús máichavarepa: —Te vahi nucusi­pa­pe­vachavi, vaipa pítipa­ra­caimahi eta nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tacahe, ema Pedro máichapa: —Tata, vahi tácari­chuimahi pisipaca eta nívapeana. Éneri­chuvare eta nuvahuana étapa juca nuchuti. ");
INSERT INTO ignNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tásiha, máichavarepa ema Jesús: —Nácani nacavi­ravahi vahi tácame­saimahi tiápechavana ticasipana. Tacarichu ticasi­pa­yarehi eta náivapeana. Éti, epachi­ha­va­caripa; váhisera ámutuhini epachi­hahini —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ema Jesús máichahavihi eta juca vahi vámutuhini vipachi­hahini taicha máimatihi ema tíjara­re­ca­yarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te títavapa eta masipa­pe­va­chi­ra­havihi, ticamui­ri­ha­varepa eta mamuiriha. Tásiha, téjacapa te mesa. Máichahavipa: —¿Ímatie­que­ne­hapuca éti eta juca níchirahehi? ");
INSERT INTO ignNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eti ímija­rechanu “Tata Maestro”. Étupi­ca­hisera, taicha yátupiquenénuhi eta numaestruvahi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eta níchirahehi núti emaestro nusipa­pe­va­chi­rahehi, ene ecaheyare éti eta ítare­siraya. Esipa­pe­va­cha­ca­cayare eta ívapeana. ");
INSERT INTO ignNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Éhicayare eta juca níchaquenehi. Étayareichu eta nímitu­si­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nutupiruva numetacahe: Ema musu vahi macachu­ri­caimahi ema máquenu. Émaripa ema vanairucahi váhivare macachu­ri­caimahi ema tivanecahi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Te yátupina ecara­va­huinapa eta juca nímitu­rapiana, tájina íchira­vaimahi. Ecuna­cha­ca­re­yareva eta ítauchiraya tamutu. ");
INSERT INTO ignNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Néchahinéni núti vahi ámutuhini esuapanu. Nímati­he­hivare eti yátupi­queneana nunere­ji­ruanahi. Títaucha­va­ya­re­hisera eta táechaji­ri­ruvahi eta Sagrada Escritura, ani tacahehi: “Ema néniruasahi, masapihahi ticatia­na­ca­nuhi”. ");
INSERT INTO ignNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Puiti nucaina­pucava numetacahe apaesa te táitauchavapa eta juca numetarapi, ímati­nuinapa nuti yátupiquenénuhi Cristo. ");
INSERT INTO ignNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nutupiruva numetacahe: Nácani tijaca­pa­hea­nayare éti nuvaneruana, ticaeche­ranahi eta najaca­pi­ranuhi núti apana. Éneri­chuvare, najaca­pa­hivare ema Tata Nucaiya­ quene. ");
INSERT INTO ignNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te títapi­ricapa eta máichira­havihi ema Jesús, téñamavaipa te masamure eta máijara­re­si­ra­yarehi ema émana vichamurihi. Tacahe, matupi­ruvapa máichahavihi: —Nutupiruva numetacahe: Mararihi ani te etaracu ema tíjara­re­ca­nuyare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tacahe, viárame­ca­rinehi eta máichira­havihi. Véseniu­qui­ji­ri­cacapa. Vahi vímatihini nájaha­hipuca ema máichaquenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nutiari­hisera nuti nachamuri máemuna­ru­pa­nanuhi ema Jesús. Nucacha­cayahi éma eta véjasirahi te mesa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tacahe, ema Pedro tiúmatsiu­qui­chanupa nuyase­re­cahini nájaha­hipuca ema máichaquenehi ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tásiha, núti nujajaicapa ema Jesús: —Tata, ¿nájahasica ema píchahi? ");
INSERT INTO ignNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tásiha, tijica­panupa: —Nuyuve­tu­mecaya eta pan, néchipae­jicaya. Ema níjara­ruyare, émara ema tíjara­re­ca­nuyare —macahepa. Tacahe, máechipae­jicapa eta pan, máijaracapa ema Júlasi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jéhesaréinehi, ema Váinaraji enevanepa mávahácahi éma. Tásiha, ema Jesús máichavanepa: —Júlasi, eta juca pipane­reruhi, táitaucha­va­vanepa puítinaichu —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Váhisera vácaicu­tia­rahini eta juca máichirahi ema Jesús ema Júlasi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Vímija­cha­hichucha eta mavacha­re­si­ra­ya­re­hivare eta tinicacare tayeheyare eta piesta, mácaji­hi­va­re­pucaini ena páureana, taicha émahi técha eta tarera máunasi­rarehi eta plata eta mateso­re­rovahi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te títanesipa ema Júlasi eta manisirahi eta pan, tiyanapa tiúchucahi. Tijuni­ji­ca­havipa te jena yátiquenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Eta máuchusiraipa ema Júlasi eta viyehe, ema Jesús máichahavipa: —Títecapapa puiti eta táitauchi­ra­vayare ímahainapa éti eta máitupa­ji­jia­sirava ema Viya étapa eta nítupa­ji­jia­si­ra­vayare núti Manere­ji­runuhi éma. Éti ecuna­cha­ha­vinapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nímere­cainapa eta máitupa­ji­jia­si­ravahi ema Tata, ema apana máimere­ca­yareva eta nítupa­ji­jia­si­ravahi nuti Machicha. Puiti juca sácheanayare títaucha­vainapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nuchicha­naveana, ánipirine eta juca ecacha­ne­ra­nuyare. Tásiha, nuyanainapa. Éti, etanu­ca­nuinapa; vuíchahasera ítuji­ca­vaimahi ecapa­yacanu. Étarichuhi eta numeta­rapihi nayehe ena ticatia­na­canuana eta níchira­vacahi vahi títuji­ca­va­naimahi ticapa­ya­canuana. ");
INSERT INTO ignNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Puiti nunaqui­cayare eta juca arairu nuvanairipi eta eyehe. Émuna­ca­ca­yarehi ena echamuriana. Ecuti­nu­yarehi eta némunasiráhehi núti. Ene ecaheyare éti apanavare. ");
INSERT INTO ignNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te yátupina émunacaca, eta tímatia­ca­hea­nayare ena achaneana étirahi eti nímitu­reanahi —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tásiha, ema Pedro mayase­recapa: —Tata Maestro, ¿távihainapa picaijuheya? Ema Jesús majica­pa­varepa: —Eta nucaijuheya puiti, éti vuíchaha ítuji­ca­vaimahi éhicanu. Ecapa­ya­ca­nu­ya­resera. Váhivare ánasimahi éti. Vuíchahasera tíjahúchavaimahi —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ema Pedro majica­pa­varepa: —¿Tájaha tacuichavaini vahi nucura­ta­hahini néhicavi, Tata? Núti níjaracava népena píchavenénahi píti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tacahe, ema Jesús máichapa: —Píti, pímija­cha­vapuca píjaracava pépena eta picatiu­chi­ranuya. Numeta­ca­visera: Puiti juca yati, te tamira­hui­na­richaha eta táechaji­siraya eta varayu te tijararahi, píti mapaheyare pépiya­ca­vayare vahi pímatinu, eta picatiu­chi­ra­va­yarehi píti —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Vahi ecueñamava éti. Ácasiñava eta me Viya; ácasi­ña­vavare eta nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taicha ánaqui te mávasa ema Tata, camuri eta tiávira­vacare iávihayare éti, taicha ícuchihi éti. Tacahe, tatupa­racahi nuyanayare nétupi­ri­cayare eta iávihayare. ");
INSERT INTO ignNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te táuripa eta iávihayare, nútija­pai­na­varepa nuchavainapa népanahénapa apaesa ácachanenu éti tayehe eta návihayare núti. ");
INSERT INTO ignNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eti ímatiripa eta nucaijuheya. Ímati­pa­hivare eta achene nuyani­hayare. ");
INSERT INTO ignNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tásiha, ema Tomás majicapapa: —Tata, váhira vímati távihapuca eta picaiju­heyare; váhivare vímati eta achene piyani­hayare —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ema Jesús majica­pa­varepa: —Nútira néhicacare. Nútirichuva nuti yátupiquenénuhi. Nútivare nucaita­rerahi, nájina apanaina ácasi­ñaimahi eta íteca­pi­rayare me Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eta ímati­ranuipa núti, ímati­ri­pa­hivare ema Tata, taicha ímaha­nuripa puiti eta juca nucachanérahehi —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ema Felipe máichapa: —Tata, pímecha­ha­vipaini ema Viya apaesa viúrisa­mu­repaini eta vímati­rai­nahini. ");
INSERT INTO ignNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ema Jesús majica­pa­varepa: —Ánaquia­paripa eta picacha­ne­ranuhi, piti Felipe, vuíchaha­ca­ruvare pímatinu. Eti ímaha­nu­ripahi, ímati­nui­pavare yátupihi. Tímicu­ti­ji­ri­ca­vaipahi émainahini ímara­ra­cahini ema Tata. ¿Tájaha tacayema pivara­hai­cha­havare nímechavi ema Tata? ");
INSERT INTO ignNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Váhipuca pisuapanuhi eta mávahásiranuhi ema Tata, tásiha, étapa eta návahásira­hivare núti apanava? Eta juca nucaye­ma­que­neanahi, vahi nuveha­que­neanaina te nuchuti. Étara eta mávahásiranuhi ema Tata, títauchavahi eta mavara­ha­que­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Esuapanu eta návahásirahi núti ema Tata, étapa eta mávahásira­nu­hivare éma. Te vuíchahapuca esuapa­nuhini eta numetarapi, étavanerécainaséra esuapa eta tiárami­ca­reanahi níchaque­neanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nutupiruva numetacahe: Nuyanainapa eta me Tata. Eta tacahe, éti yátupi eta esuapi­ranuhi, nítsivahe éti. Níjaracahe eta erata­hairaya ecuchuca eta tiárami­careana, ecuti­nuyare. Níjara­ca­hevare eta erata­hairaya ímitu­pirucha eta náchanevana ena achaneana. Jéhesare, eta juca tiápaju­pa­na­vayare eta tacuna­cha­careva tayehe eta tiárami­careana íchaque­nea­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Núti níjara­ca­he­yareva tamutu jácani eyasea­ru­nua­nayare te níjare, taicha nuvaraha ichape eta ecuna­chi­rayare ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Eta esuapi­ranuhi tímereu­chaheya eta yátupirahi eta émuna­si­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tásiha, núti nuyasea­cainapa ema Tata máevataca ema Espíritu Santo. Éma, tímica­ta­ca­heyare, ticuri­sa­mu­re­cha­he­yareva. Yátupi­que­nevare eta mávahásira­heyare eta ítare­si­rayare. Vahi tínajiacahémahi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Éma, tímitu­ca­heyare, máitame­ta­cayare tamutu eta yátupi­que­neanahi tásiha­queneana eta me Tata. Énasera ena achaneana, vahi ticaija­ra­ca­sia­naimahi, taicha vahi návara­hahini najaca­pahini éma. Eta namara­ta­hairahi náimaha éma, náimijachahi vahi máimati­carehíni éma. Étisera ímatiyare éma, taicha máitava­ca­cayare eta mávahásira­heyare. ");
INSERT INTO ignNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Núti, váhivare nujuni­jiacahémahi. Nuchavayare eyehe, ecacha­ne­nu­yareva. ");
INSERT INTO ignNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Puiti juca sácheanayare, ena achaneana vaipa tímaha­nua­naimahi. Étisera ímaha­nu­pa­racaya, taicha nuchava­yarehi nítareca. Éti apanavare ítare­ca­yareva nícha núti. ");
INSERT INTO ignNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te nuchavapa nítareca, échavainapa éti eta mávahásiranuhi ema Tata, échavai­na­varepa eta návahásira­hevare núti, éti apana iávahácanu­hivare. ");
INSERT INTO ignNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nácani náimatiyare eta nuvanai­ripiana, náitaucha­yareva, éta tímicae­che­ra­chayare eta yátupihi eta náemuna­si­ranuhi. Tásiha, ichapeyare eta namuna­vayare me Tata táichavenénahi eta náemuna­si­ranuhi. Núti apanavare ichape­yareva eta némuna­si­ra­va­cayare. Tásiha, nímere­ca­va­yareva nayehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ema Tadeo máichapa: —¿Táichara­ca­vayare, Tata, eta vicari­chui­rayare pímerecava eta viyehe; tásiha, ena apamuriana achaneana, vaipa tímaha­via­naimahi? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tacahe, ema Jesús majicapapa: —Nácani témuna­ca­nua­nayare, nasuapayare eta nuvanai­ri­pianahi. Tásiha, ema Tata, tétavi­ca­va­yarehi eta máemuna­si­ra­vacaya. Tásiha, vítija­painapa viávahácava­cayare éna. ");
INSERT INTO ignNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nácanisera vahi témuna­ca­nua­naimahi, váhivare nasuapaimahi eta nuvanai­ripiana. Eta juca esama­que­neanahi puiti, vahi tásiha­que­ne­nahini te nuchuti. Tásiha­quenehi me Tata, ema tivane­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nucama­purava numetacahe puiti taicha ánipirine eta juca nucaheyare eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Émasera ema Espíritu Santo mavane­ruyare ema Tata níchavenénahi núti, ema tímica­ta­ca­heyare, ticuri­sa­mu­re­cha­he­yareva. Énerichu tímitu­ca­heyare, témecha­heyare tamutu eta juca numeta­rapiana eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Puiti nucame­tavaya eta eyehe. Nuvara­hasera tacuijahini íchira­vai­nahini, ecana­ra­siraina eta epane­reruana. Núti vahi nácuti­nuhini ena apamuriana achaneana eta nujuni­ji­si­raheya. Vahi ecuva­yuchava eta éñama­vairaina. Váhivare ecupica. ");
INSERT INTO ignNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Puiti numeta­ca­heripa eta nuyani­rayare; tásiha, étapa eta nuchavi­rayare eta eyehe. Eta tacahe, te yátupina émunacanu, evapi­na­va­yarehi nuyehe núti eta nuchavi­rainapa mayehe ema Tata, nápechavaya nucachane éma tayehe eta máetaviu­chirahi eta majaraivahi étapa eta máitupa­ji­jia­sirava. ");
INSERT INTO ignNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nucame­ta­ra­pivane eta juca, apaesa te ímaha táitauchavapa, esuapainapa yátupi. ");
INSERT INTO ignNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ánipirine puiti eta juca néchaji­ri­si­ravahi eta eyehe taicha ávanepaipa títecapa ema Váinaraji eta mavarairahi tiáquipai­ca­nuyare. Éma, yátupihi táquenuhi eta juca apaquehe. Váhique­nesera títaha­ca­nuimahi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nuvara­hasera náimatiya ena achaneana eta némuna­sirahi yátupi ema Tata; tásiha, nítaucha­pa­racahi tamutu eta mavanai­ripiana. Échepuca. Viyana viyejecava eta te juca —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Núti nucutihi eta sucureca uva. Étiripa éti ecuti eta tatavana. Ema ticachichanu tímicu­ti­ji­ri­cavahi ema tijaneacahi eta sucureca. ");
INSERT INTO ignNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Éma máechuca eta máhiri­querehi tatava. Máepachia­cavare eta apana tatava eta ticahirisi apaesa tacahipana. ");
INSERT INTO ignNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eti epachi­ha­va­caipahi taicha eta nímitu­rapiana emeta­ca­si­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eta tacahe, ímiya­na­vayare eta iúrujia­si­ra­nuyare taicha eta návahásirahehi núti, apaesa ácuti eta tatava ticahiriqui. Taicha te viyuvetuca eta tatava eta uva, vaipa ticahimahi. Ene ecahehi éti, te vahi ecuimi­yanava iúrujiacanu, tájina vaipa ecaema­ta­nea­ca­nuimahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nápechava nímicu­ti­chinahe puiti. Núti nucutihi eta táenaquihi. Éti tímicu­ti­ji­ri­cavahi nutavahehi. Te ímiyanava iúrujiacanu, ichape­mu­ri­yarehi eta ecaema­ta­nea­si­ranuya. Téhesera ácarichu éti, tájina erata­haquenémahi ícha. ");
INSERT INTO ignNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nácani tijuni­jia­ca­nua­nayare, ticutia­nayare te ticaechu eta tatava. Tiájiqui­yarehi. Tásiha, nacuru­ji­cainapa, náijuchainapa te yucu. ");
INSERT INTO ignNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ímiyanava yátupina eta iúrujia­siranu. Yátupi­navare eta ítauchiraina eta nímitu­rapiana. Tásiha, te eyasea­ca­nupuca jácani evara­ha­que­neanahi, núti níjara­caheya. ");
INSERT INTO ignNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nuvaraha ímere­cavaya eta táurivayare eta ecaema­ta­nea­siranu, apaesa tétavi­ca­vainapa eta macuna­cha­ca­revaya ema Tata. Tásiha, ecaeche­raipahi eta yátupirahi nímiturehe. ");
INSERT INTO ignNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ímiyanava eta iávahásiranu taicha tétavi­cavahi eta némuna­si­rahehi tacuti eta máemuna­si­ranuhi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eta ímiya­nirava ítauchapaipa eta nuvanai­ripiana, tijuru­capaipa eta ímatirahi eta némuna­si­rahehi. Tacuti eta nítauchirahi núti eta mavanai­ripiana ema Tata, nímatipaipa eta máemuna­si­ranuhi éma. ");
INSERT INTO ignNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Eta juca nímicu­tia­ra­chirahi, nuvarahahi iápajuca eta iúrisa­mu­revahi tásiha­quenehi eta iávahásiranuhi núti. Ecutinuya eta núrisa­mu­revahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nápechahe numetacahe eta juca nuvanairipi eta eyehe: Yátupina eta émuna­si­ra­cacaina. Ácutinu eta némuna­si­rahehi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ena achaneana, te navarahahi náimerecaya eta náemuna­sirahi nácani náemuna­ruanahi, natanu­ca­yarehi náijara­casicha. Nácani tíjara­re­ca­va­napuca eta náepenirahi énavenehi ena náemuna­ca­sareana, éna yátupihi náimereca eta náemuna­sirahi. Ene nucahehi núti, níjara­re­ca­vayare eta népeniraya íchavene eti némuna­ca­sa­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jéhevare, éti yátupi­quenehi némuna­ca­sa­reanahi, eta ítauchirahi eta nuvanai­ri­pianahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vahi vánaracahéna nuyehe, taicha ena vanara­canahi vahi náimatimahi eta mapane­re­ruanahi ema náquenu. Étisera némuna­ca­sa­reanahi. Eta tacahe, numetacahe tamutu eta mapane­reruana ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Vahi étinahini enere­ji­ca­nuhini eta éhisi­ranuhi. Núti nunere­ji­cahehi. Puiti nutupa­racahe, nuvaraha táuri eta ecaema­ta­nea­siranu eta epaisiraya eta ecame­ta­rai­rui­rayare. Nuvaraha ecaji­mu­ya­cahini ena achaneana náehica­nuhini. Yátupina eta ímitu­siraina apaesa náimiyanava eta náehisi­ranuhi. Tásiha, ema Tata tíjara­ca­heyare tamutu eta eyasea­rua­nayare te níjare. ");
INSERT INTO ignNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nuvaraha ítaucha eta juca nuvanai­ripiana. Yátupina émunacaca. ");
INSERT INTO ignNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Puiti numeta­ca­hevare, te nacatia­nacahe ena achaneana, échavayare éti vahi étinahini nacatianaca. Núti nacatia­nacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Taicha, te étainai­chahini iávacu­hahini eta tayehe­repiana eta apaquehe, ena achaneana témuna­ca­hea­na­ri­pahini, tacutihini eta náemuna­ji­ri­si­ra­cacahi éna. Étasera eta nunere­ji­si­rahehi te nataracu ena achaneana, étapa tiviuchahehi eta nacatia­na­si­rahehi taicha ínajicaipa eta máepera­jiquene tayehe eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Échavavare eta juca numeta­ruhehi: “Vahi másapi­haimahi ticaemu­nacasi ema musu mayehe ema máquenuhi”. Núti ticatia­na­ca­nuanahi; ene ecahe­yarehi éti, eta nacatia­na­si­ra­he­yareva. Vahi nasuapahini eta nímitu­rapiana. Váhivare nasuapaimahi eta ímitu­rapiana éti apanava. ");
INSERT INTO ignNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eta éhisi­ranuhi núti, étaripa tiviucha­heyare tamutu eta juca nacatia­na­si­ra­heinapa táichavenehi vahi náimatihini ema Tata tivane­canuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tacuija­ri­chu­hi­pucaini naviure­vai­nahini éna, te vahi nucuite­cahini eta nímitu­si­ra­vacahíni. Tépuru­nuanahiséra, náepuru­hivare eta nímitu­rapiana; tásiha, tétavi­cavahi eta naviure­vanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Taicha nácani ticati­cha­nuanahi núti, nacatia­na­ca­hivare ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Éneri­chuvare tacuijahini taviucha­va­cahini te vahi nucuime­re­cahini eta tiárami­careana níchaque­neanahi. Mamara­ta­ha­quenehi máichahini mácani apana achane tacutihini eta níchaque­neanahi núti. Étasera náimaha­ripahi, váhique­nesera nasuapahini. Nasapiha ticatia­na­ca­nua­na­richucha, nacatia­na­ca­hivare ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Étasera tacahe­yarehi eta táitauchi­ra­va­yarehi eta táechaji­ri­ruvana eta Sagrada Escritura te Salmo, ani tacahehi: “Tájina taviucha­nuhini eta nacatia­na­si­ra­nuhi”. ");
INSERT INTO ignNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Étisera, marari­hiyare ema tímica­ta­ca­heyare, ticuri­sa­mu­re­cha­he­yareva. Te níteca­pau­cha­yarepa ema Tata, nuyaseacaya mavaneca ema Espíritu Santo. Éma, te máitecapapa, tímereu­cha­heyare eta yátupi­queneana. Tímereu­cha­nu­yareva núti eta eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Éti apanavare ímereu­cha­nu­yareva taicha tiyere­ripahi eta ecacha­ne­ranuhi, tépanavapa te nunérejicahénapa. ");
INSERT INTO ignNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Núti numetacahe eta juca apaesa vahi ecuarami eta nacatia­na­sirahe, váhivare ecuina­jicava eta éhisi­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Taicha tiáquiji­ca­hea­nayare tayehe eta viúruji­si­ra­revana. Éneri­chuvare navara­hayare ticapa­caheana. Éna, náimija­cha­yarehi tiúriyarehi eta náichirayare te mamirahu ema Viya. ");
INSERT INTO ignNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Éna, náichayare eta juca táichavene eta namáimatirahi ema Tata, váhivare náimati­nuhini núti. ");
INSERT INTO ignNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Numetacahe eta juca apaesa te táitecapapa eta íchava­que­nevaya, vaipa ecuarameca. Échainapa eta numeta­si­rahehi. ");
INSERT INTO ignNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Puiti tiánehinapa eta nuyaniraya nuchava eta me Tata. Eta nucacha­nei­rahehi, ticatia­na­ca­nuanahi núti ena achaneana. Puítisera eta májinai­ra­nuyare, ticatia­na­ca­hea­nainapa éti. Eta juca tacahehi, nupaenumava numeta­cahehi puiti. Étisera németeaca vuíchaha ecaicutiara eta numetarapi, taicha váhivare eyase­re­ca­nuhini eta nítame­ta­si­rayare, étahinéni eta nucaiju­heyare. ");
INSERT INTO ignNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Esapiha éti ecati­sa­mu­revahi taicha eta juca numeta­si­rahehi eta nuyaniraya. ");
INSERT INTO ignNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tayanapane vahi eyase­re­ca­nuhini, nutupi­ru­vasera numetacahe: Tatupa­racahi eta nuyaniraya nuchava mayehe ema Tata, taicha te vahi nucuyana, vahi títecaimahi ema nuvaneruya. Éma tiúricha­heyare, tímica­ta­ca­heyare, ticuri­sa­mu­re­cha­he­yareva. ");
INSERT INTO ignNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Éneri­chuvare ena achaneana te juca apaquehe, manaca­sa­mu­rechaya eta nacatu­pa­ra­hairahi náichayarehi eta táuriqueneana, náehica­nuvare núti. Manaca­sa­mu­re­cha­va­ca­yareva éna eta náimatiraina eta nasipe­ca­tu­ra­raivahi. Taicha te vahi nacuvaraha náinajica eta tamauri­queneana, téhevare vahi nacuvaraha náehicanu núti, ticaicu­ña­nainapa te yucu. ");
INSERT INTO ignNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","10","Ema Espíritu Santo manaca­sa­mu­re­cha­va­cayare ena achaneana eta najaca­pa­ca­revaya me Tata nácani ticasi­ña­va­napuca eta nuyehe, taicha nuyanaya eta me Tata, néchajiu­cha­va­cayare éna. (Vaipa ímaha­nuimahi éti.) Nácanisera vahi nasuapa­nuhini núti, tanasi­quenehi eta napeca­tu­ranahi. ");
INSERT INTO ignNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Manaca­sa­mu­re­cha­va­ca­yareva ema Espíritu Santo eta yátupina táiture­vayare éna eta máicuñayare ema Váinaraji náehiruhi te juca apaquehe. Éna apanava náepuju­qui­chainapa tayehe eta yucu infierno. ");
INSERT INTO ignNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mavera­cha­haneni eta juca nuvara­ha­que­neanahi numetacahe. Váhisera erata­haimahi ecaicutiara puiti. ");
INSERT INTO ignNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Téhesera máitecapapa ema Espíritu Santo, éma tiámaya­repahi eta yátupi­queneana numaimi­tu­re­hea­na­richaha, émainapa tímitu­ca­heyare. Taicha mameta­ca­sivahi eta máechaji­si­ra­heyare, éneri­chuvare timeta­ca­he­yareva eta íchava­quenéva­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ichapenapa eta nucuna­cha­ca­re­vayare máicha. Émainapa timeta­ca­heyare eta nuvanai­ri­pia­na­yarehi eyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Taicha ema Tata titupa­ra­canuhi eta nútira­yarehi nécha tamutu. Eta tacahe, eta juca mameta­ra­pia­nayare ema Espíritu Santo tásiha­que­nea­nayare nuyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ánipi­ya­rei­chusera eta emaimai­ra­nuyare. Téhesera táequenénapa, iápecha­vai­na­varepa ímaha­nuyare. Taicha nuyana­yarepa te mávihahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Tacahe ena apamuriana nuchamuriana tiyase­re­ca­nuanapa: —¿Tájahapuca tacayema eta juca mameta­rapihi, eta macahehi ánipirine eta vimaimai­rayare, tásiha, te táequenénapa viápecha­vai­na­varepa vímaha? ¿Tichava­va­nepuca eta mayani­rayare eta me Maiya? ¿Váhipuca mánasimahi eta machaviraya? Váipavare vácaicutiara eta ánipirine eta macaheyare eta viyehe —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ema Jesús macaicu­tia­ra­vacahi eta navarairahi nayasereca. Máichavacapa: —Núti numeta­cahehi eta ánipirine eta emaimai­ra­nuyare. Tásiha, te táequenénapa eta emaimai­ra­nuyare, iápecha­vai­na­varepa ímahanuya. Eta juca emacai­cu­tia­ra­quenehi. ");
INSERT INTO ignNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tásiha puiti, nutupiruva numetacahe eta íyahai­rai­na­samipa éti, ejapa­nu­vai­ra­yareva. Énasera ena apamuriana achaneana, tiúrisa­mu­rea­nainapa éna. Tásihasera te táequenénapa, vaipa íyahaimahi. Tétavi­ca­vasera eta iúrisa­mu­re­vainapa eta táitsivaya. ");
INSERT INTO ignNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Eta juca tímicu­ti­ji­ri­cavahi te tínacayare esu esena. Ánipichuhi eta sucati­ru­havahi taicha eta suínasi­ra­yarehi. Téhesera te tamutupa eta suínasirahi, suémiti­si­cainapa eta sucati­ru­ha­vainihi. Tiúrisamuréinapa eta suímairahi eta suchicha, tajuru­si­ra­yarehi te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ene ecaheya éti, ecati­sa­murehi puiti, ánipi­ri­chusera. Téhesera te viápechava vímaha­cacaya, tétavicava eta iúrisa­mu­revaya. Nájinai­na­varepa tihapa­picahémahi eta iúrisa­mureva. ");
INSERT INTO ignNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Te jena sácheyare, vahi nútimahi eyase­recanu. Émasera ema Tata eyase­re­ca­yarehi. Éma, tíjara­ca­he­yarehi tamutu jácani eyasea­rua­nayare te níjare. ");
INSERT INTO ignNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Puíticha tájinaichaha eyasea­ra­pi­nahini me Tata te níjare. Ticamu­nu­carehi eyasea­cayare. Éma tíjaracahénapa. Étainapa ticuri­sa­mu­re­re­ca­heyare ichape. ");
INSERT INTO ignNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Núti nímicu­ti­chi­nahehi eta juca numeta­si­rahehi. Téhesera te táequenénapa, nutupi­ru­vainapa numeta­ca­heyare eta yátupi­queneana mapane­re­ruanahi ema Tata. ");
INSERT INTO ignNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te jena sache, eyasea­cainapa ema Tata te níjare. Váipayare tacamu­nuimahi nuyaseuchahe eta mayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taicha émaripa ema Tata témuna­cahehi éti, táichavénehi eta émuna­si­ra­nu­hivare núti. Éti esuaparipa eta yátupirahi eta mavane­si­ranuhi ema Tata. Tíjara­cahéna­vanepa eta eyasea­rua­nayare. ");
INSERT INTO ignNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Núti, eta násihahi mayehe eta nítesirahi te juca apaquehe. Puítisera nujuni­ji­cai­na­varepa eta apaquehe, nuchavai­na­varepa mayehe ema Tata —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tacahe, viti máimitureana víchapa: —Jéhevare puiti pitupi­ruvapa eta péchaji­sihahi. Vaipa pímicu­tia­ra­chinahávihíni. ");
INSERT INTO ignNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vímati­varepa eta yátupirahi pímatie­queneha tamutu. Jéhesare, pímatie­queneha tamutu eta vipane­reruana, étaripa eta juca vivarairahi viyase­re­ca­viyare. Visuaparipa puiti eta yátupi­quenéravihi Machichavi ema Viya —víchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tacahe, ema Jesús máichahavipa: —Jéhepuca eta esuapiranu puiti. ");
INSERT INTO ignNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Puítisera juca yati, títeca­painapa eta éjane­repáisi­rayare éti. Ejuni­ji­ca­nuinapa, nucari­chuinapa núti. Matiari­hi­ya­resera ema Tata. Éma, ticacha­ne­nuyare. ");
INSERT INTO ignNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Numeta­ca­hevare tamutu eta juca apaesa vahi ecuarameca. Ácasiñava yátupina nuyehe apaesa tacuija ecuichi­ravaina, tayanapane ecata­ji­vayare muraca te juca apaquehe. Ácasi­ña­va­hisera eta nuyehe, taicha núti máijara­runuhi ema Tata eta nucapa­que­mu­ri­hai­rayare namutu ena nánaranahi —máichahavipa. ");
INSERT INTO ignNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Te títapi­ricapa ema Jesús eta máechaji­si­ra­havihi viti máimitureana, tépanavapa tiyuja­racahi. Máesenicapa te anuma. Ánipa macahe: —Tata Nucaiyaquene, títeca­pau­chanupa puiti eta táitauchi­ra­vayare eta pipane­reruana. Nuvara­hasera nucuna­cha­caréni eta piyehe, tácutini eta nucuna­chi­ravihi píti. ");
INSERT INTO ignNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yátupihi eta píjara­si­ranuhi eta aquenu­cai­ra­nuyare, te namirahu namutu ena achaneana. Nucaita­re­si­ra­ya­re­hivare namutu ena píchuha­que­neanahi píjara­ru­nuanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Níjara­cayare eta náitare­si­rayare máichecua­ra­qui­reyare ena píjara­ru­nua­nayare apaesa náimativi, piti Tata yátupi­que­névihi Viya, nútipa núti Jesucristo, núti pivane­runuhi te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Núti nímerecahi ne achaneana eta picuna­cha­ca­revahi. Nítauchaipahi tamutu eta pivanai­ri­pianahi pivara­ha­quenehi níchayarehi. ");
INSERT INTO ignNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Puítisera nuchavai­na­varepa eta piyehe. Píjara­ca­nuyare eta nuchavi­rayare te pijaraivahi. Néjacai­na­varepa te pivaure tayehe eta návinehi acane te tépana­vainapa eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nítamu­tu­ru­ca­ripahi eta nímitu­si­ra­vacahi ena píchuha­que­neanahi píjara­ru­nuanahi píti. Nímima­ti­cha­va­ca­hivare eta piúrivahi píti. Yátupi­hisera eta pichicha­na­veanahi éna, taicha nasuapahi eta nímitu­rapiana píjara­ru­nuanahi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Náecharipahi tamutu eta juca nímitu­rapiana tásiha­que­neanahi piyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Náechari­pa­hivare eta yátupi­que­nérahi eta pivane­si­ranuhi. Eta tacahe, natupi­ruvahi najacapa eta nímitu­si­ra­vacahi eta péchaji­ri­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Eta tacahe, puiti nuyaseacavi, Tata, eta pijanea­si­ra­vacaina ena píjara­ru­nuanahi téhica­nuanahi, taicha pichane­ranahi éna. Vahi énaina nuyaseu­chavaca ena masuapa­ji­rai­ra­hanahi te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Núti néchahi eta piyehe­ra­vacahi éna. Eta tacahe, néñamavahi eta nayehe, nuyehea­naipahi éna. Yátupihi eta náimati­ranuhi eta pivane­runuhi, tásiha ticuna­cha­nuanahi ichape. ");
INSERT INTO ignNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Puiti núti nujuni­ji­ca­va­cainapa ena píjara­runuana. Énasera nanasi­ya­rechaha te juca apaquehe. Nútisera nútija­painapa eta piyehe. Tata Nucaiyaquene, piti yátupi­que­névihi eta pisantuvahi. Nuyaseacavi pijanea­si­na­nu­va­cachucha éna, apaesa náimiya­navahi eta náurujia­si­ra­cacaina, návahá­si­ra­ca­cayare nácutihini eta viávahá­si­ra­cacahi víti. ");
INSERT INTO ignNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Núti nímima­ti­chavihi píti eta nayehe, étapa eta píjare, apaesa yátupina eta náehisi­ravina. Ichape­murihi eta nujanea­si­ra­vacahi éna eta nucacha­ne­ra­va­caichaha. Eta tacahehi, vahi náinaji­ca­vahini eta náehisi­ra­havihi. Émanarichu ema téjeca­pavahi, ema tijara­re­ca­nuyare. Étasera tacahe­yarehi eta táitauchi­ra­va­yarehi eta Sagrada Escritura. ");
INSERT INTO ignNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Puiti nútija­painapa, Tata, tayehe eta jara piávihahi. Eta nucacha­ne­ra­va­caichaha éna, numeta­ca­vacahi eta pipane­reruana, taicha nuvaraha vácuti­ca­cahini eta viúrisa­mu­revaina. ");
INSERT INTO ignNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taicha ena achaneana te juca apaquehe, ichape­murihi eta nacatia­na­si­ra­vacahi táichavenehi eta najaca­pirahi eta péchaji­ri­ruvana nímitu­si­ra­vacahi. Éna, vaipa náehicahini eta tayeheana eta juca apaquehe, ticuti­nua­na­ripahi núti eta numaehi­sirahi eta tayeheana eta te juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Vahi nuyaseacavi eta pivira­va­cai­nahini te juca apaquehe. Nuyaseacavi núti eta picatiu­chi­ra­va­cai­nahini mayehe ema Váinaraji. ");
INSERT INTO ignNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taicha yátupihi éna vaipa tayehea­nai­nahini eta juca apaquehe, ticuti­nua­naripa núti vahi tayehe­nui­nahini eta juca apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Píjara­ca­va­cahini eta náurivai­nahini eta piyehe, náitusi­rai­nahini cápachi eta péchaji­ri­ruvana yátupi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Píti pivane­canuhi nímitu­re­ca­yarehi eta péchaji­ri­ruvana nayehe ena achaneana te juca apaquehe. Tásiha, núti nuvane­ca­va­ca­yareva ena nímitureana, náimituca ena apamuriana achaneana. ");
INSERT INTO ignNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Puiti, eta némuna­si­ra­vacahi éna, níjara­recava núti, nítauchayare eta pivara­ha­quenehi. Nuvaraha ene nácahehini éna, yátupi­nahini náijara­ca­vahini eta nacaema­ta­nea­si­ra­vi­yarehi. Yátupi­na­hi­varéni nasuapa eta péchaji­ri­ruvana yátupi­queneana. ");
INSERT INTO ignNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Váhiva­resera nacarichuhi éna nuyaseu­cha­vacahi eta piyehe. Énerichu nuyaseu­chavaca ena tisuapa­nayare eta táunavayare eta áñoana, ena tijaca­pa­nayare eta péchaji­ri­ruvana. ");
INSERT INTO ignNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nuyasea­ca­vivare váhini tacuita­vahini eta náurujia­si­ra­ca­cayare éna. Píjara­ca­hi­varéni, Tata, te nasamureana eta návahá­si­ra­ha­vi­nahini tácutihini eta viávahá­si­ra­cacahi víti. Náurujia­si­ra­ha­vi­navare víti, apaesa ena achaneana te juca apaquehe náimatihini yátupina eta pivane­si­ranuhi. ");
INSERT INTO ignNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Núti níjara­ca­va­caipahi éna eta náitupa­ji­jia­si­ra­va­ca­yarehi tamutui­ra­yarehi narataha. Vicutihi víti eta tamutuira virataha. Návahá­ca­cahini éna, vácutihini víti eta viávahá­si­ra­cacahi. ");
INSERT INTO ignNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Píti piávahá­canuhi núti. Tásiha, núti návahá­ca­vacahi éna apaesa yátupi­nahini éna étanai­na­ri­chuyare eta napane­reruana, apaesa ena apamuriana achaneana te juca apaquehe étainahini náimatia­rai­nahini eta pivane­si­ranuhi, étapa eta pémuna­si­ra­vacahi ena nímitureana tacutihi eta pémuna­si­ranuhi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata Nucaiyaquene, píti píjara­canuhi ena nani píchuha­que­neanahi. Nuyaseacavi puiti eta nucacha­ne­ra­va­cai­nahini tayehe eta návihayare núti. Náimahahini eta nujaraiva píjara­runuhi taicha eta pémuna­si­ranuhi te tépana­vainapa eta tacaepi­yairahi eta apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata Nucaiyaquene, píti yátupi­que­névihi eta pisantuvahi. Ena achaneana te juca apaquehe vahi náimati­vihini. Nútisera nímativihi. ");
INSERT INTO ignNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ena nani píjara­ru­nuanahi nímima­ti­cha­vi­ripahi. Tétavi­cavahi eta pémuna­si­ranuhi. Tásiha, nuvaraha yátupina nasamava eta táetaviu­chirahi eta pémuna­si­ra­vacahi taicha éna tiávahá­ca­nuanahi núti. ");
INSERT INTO ignNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te títapi­ricapa ema Jesús eta mayuja­ra­sirahi, tiyanapa tiámamu­ri­ha­havipa te apachara eta tatavarapi ticaijare Cedrón. Ánaqui tatiarihi eta huerta ticaijare Getsemaní. Visiapapa tayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tacahe, ema Júlasi máimatihi eta juca viávirarehi taicha ichape­murihi eta vicacha­nerahi ema Jesús tayehe eta huerta. ");
INSERT INTO ignNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tacahe, te jena yátiquenehi, títecapapa ema Júlasi. Mámamu­ri­ha­paipahi ena oficialeana énapa ena camuri­que­neanahi suntaruana romanoana, vanairu­canahi éna nayehe ena tuparai­rucana, taicha napami­ca­vacahi ena fariséoana. Ticami­ca­hua­na­paipahi. Ticaepu­chi­ri­quia­napaipa, étapa eta nayehe espada. ");
INSERT INTO ignNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Émasera ema Jesús máecharipa eta nacara­ta­si­ra­yarehi. Tacahe, mácapa­vacapa éna. Máichavacapa: —¿Nájaha etánuca? ");
INSERT INTO ignNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ena najicapapa: —Ema Jesús Nazareno vitanu­capahi. Éma máichavarepa: —Nútira etánu­repahi. Ema Júlasi mapauchapa, máetsera­recapa. Tásiha, titupi­hachaha te machacaya. ");
INSERT INTO ignNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eta majica­pirahi ema Jesús, máichirahi: “Nútira etánu­repahi”, tiáquipai­mu­ria­vanapa ena suntaruana te apaquehe. ");
INSERT INTO ignNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tásiha, mayase­re­ca­varepa ema Jesús: —¿Nájaha ema etánu­capahi? —Ema Jesús Nazareno —najica­pa­varepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Éma, máichavarepa: —Cápachi numeta­ca­he­ripahi nútihira etánu­repahi. Te nútichucha etánu­ca­nupahi, ísapayare nayana ena nani —máichavacapa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Étapaichuhi eta máechaji­ri­ruvahi ema Jesús te tiyuja­racaipa nájina émanai­nahini náemitia­cahini te namuri ena máijara­ruanahi ema Maiya. ");
INSERT INTO ignNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tacahe, ema Pedro, tatiarihihi eta mayehe espada te mañahe. Mavehapa, máechucha­cachapa eta machaca te vaure ema achane ticaijare Malco, mavanarahi ema aquenuca Caifás. ");
INSERT INTO ignNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Émasera ema Jesús macahepa: —Pinaca te tatuma­ramuhi eta piyehe espada. Vahi pihapa­pi­caimahi eta táitauchi­ravaya eta mavara­ha­quenehi ema Tata, taicha nutupa­ra­haichuhi mayehe eta juca nucata­ji­vairaya —macahepa.­ ");
INSERT INTO ignNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tacahe, ena suntaruana émapa ema comandante nacara­tacapa ema Jesús, náitiji­vauchapa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tiyananapa námapa te mapena ema Anás. Étarichu mapena ema Caifás, taicha ema maca Anás máimachucahi ema Caifás, émapasera tuparai­rucahi te jena áñohi máitsivae­quenehi ema máimachuca. ");
INSERT INTO ignNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ema maca Caifás, émari­chuvare ticaecha­ji­ri­ruvahi eta máepeni­rai­nahini ema émana achane tivacha­cha­yarehi eta náitare­sirana namutu ena achaneana.­ ");
INSERT INTO ignNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ema Pedro, nútipa nuti Juan viyanapa véhieque­ne­hapaipa ema Jesús. Nusiapapa núti te tajuhe eta canchón mapenahi ema aquenuca Anás, taicha náimati­ca­sa­renuhi ena mavanarana. ");
INSERT INTO ignNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Émasera ema Pedro manasipa te aneca te tapaja­chacaya. Tásiha, néchajiacapa esu vanaracahi téchahi eta tapaja, sucasia­pahini ema Pedro. ");
INSERT INTO ignNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tásiha, esu suyase­recapa ema Pedro, ánipa ­ suicha: —¿Pítirichu jácani apanava ñímiture eñi ñica Jesús? Ema Pedro majicapapa: —Vahi nútina. ");
INSERT INTO ignNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tásiha, eta jena yátiquenehi táetaviuchahi eta tacasa­raivahi. Ena mavana­ranahi ema Anás, énapa ena suntaruana ticamu­ru­re­canapa eta yucu, násasia­va­yarehi. Eta náurujia­si­raipahi eta yucu, titupi­hai­pavare ema Pedro te nachacaya, másasia­va­hivare.­ ");
INSERT INTO ignNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tacahe, ema Anás mayase­recapa ema Jesús áyana­napuca ena téhicanahi éma, tájaha­hi­va­repuca eta máimitu­rapihi eta nayehe. ");
INSERT INTO ignNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ema Jesús majicapapa, ánipa macahe: —Núti vahi nuyumu­ru­ca­vahini eta nímitu­re­sirahi. Nímere­cavahi te namuri namutu ena achaneana te viúruji­si­ra­revana, étapa te Templo. Éta nímitu­re­si­ra­reanahi. ");
INSERT INTO ignNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tájaha tacayema piyase­recanu núti? Piyase­re­capaini ena tisama­ra­ra­ca­nuanahi. Énaina nametacavi eta nímitu­ra­pianahi núti —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Matiarihihi ema émana suntaru te machacaya. Eta masamirahi eta máechaji­ri­ruvahi ema Jesús, máehami­rahapa éma. Tásiha, máichapa: —¿Tájaha tacayema tíñemahi eta pijica­pirahi ema aquenuca macapi­ca­hu­quenehi? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tacahe, ema Jesús majicapapa: —Váhira táiñema­hihini eta nujica­pirahi ema aquenuca eta taviucha­nuhini. ¿Tájaha tacayema péhanu? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tacahe, ema Anás máevatacapa mayehe ema Caifás, émarichuhi corregidor. Ticaiti­ha­paipahi eta námirapahi éma.­ ");
INSERT INTO ignNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tacahe, ema Pedro manasi­richuhi titupihahi te tachacaya eta yucu, tiásacavahi éma. Nayase­re­ca­varepa­ nápechahi: —¿Pítirichu jácani máimiture ema maca achane? —náichapa. Ema Pedro majicapapa: —Vahi nútina —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tásiha, matiari­hi­hivare titupihahi ema mavanarahi ema aquenuca, macheji ema máechati­cha­caruhi ema Pedro. Tacahe, éma téchajicapa, máichapa: —Núti németeaca nímahavihi picachanehi éma tayehe eta huerta te vicara­ta­sinehi ema maca —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Émasera ema Pedro macahe­varepa: —Váhiquene nímati éma —macahepa. Tásiha, enurujipa téchaji­canecha eta varayu. ");
INSERT INTO ignNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Te jena yáticarahi, te tijara­rahipa, nacuchucapa ema Jesús te mapena ema Caifás. Námapa tayehe eta palacio mávihahi ema Pilato. Váipasera nasiapahini ena tuparai­rucana. Náimichuhahi ema Pilato. Nanasipa te aneca, namava­rairahi náechipe­ji­ca­vahini eta nanisi­ra­yarehi eta cordero pascual te jena sache. ");
INSERT INTO ignNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tacahe, ema Pilato tiúchucapa, máechaji­mu­rihapa éna. Máichavacapa: —¿Tájaha eta maviurevahi ema maca achane iámaque­nepahi eta ani nuyehe? —macahepa ema Pilato. ");
INSERT INTO ignNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Éna najicapapa: —Jucarihi eta maviurevahi. Eta tacahe, viámapahi eta piyehe. ");
INSERT INTO ignNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tásiha, ema Pilato, máichavacapa: —Eyana iama. Étina ícuñaca ema maca, taicha jararihi eta eyehe­re­pichuhi eti israelítana —máichapa. Éna najicapapa: —Étasera víti, vaipa ísapa­ha­vihini vítaucha eta viyeherepi vímicapaca mácani ticaviu­revahi, vitupisica ­ te márijahi. Émasera ema maca vivaraha máepena. Vivaraha pémeta­tacaini te crusu —nacahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tacahehi eta táitauchi­ra­vapaipa tamutu eta máechaji­ri­ru­va­napahi ema Jesús eta máepeni­ra­yarehi te crusu. ");
INSERT INTO ignNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tisiapa­varepa ema Pilato te tajuhe. Máichuhapa ema Jesús. Tacahe, mayase­recapa: —¿Yátupi­sareji réyvihi píti nayehe ena pijaneanana israelítana? —macahepa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ema Jesús máichapa: —¿Pitupi­ru­va­hipuca eta juca píchiranuhi, pivarairahi pecha te yátupi­hipuca eta nurreyvahi? ¿Pitanu­ca­hi­pu­casera eta nuviure­vayare, picuti­hipuca eta napane­reruhi ena nujaneanana israelítana? —máichapa ema Jesús. ");
INSERT INTO ignNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ema Pilato majica­pa­varepa: —Vahi nímati eta epane­reruana eti israelítana. Énarichuhi ena pijaneanana ena tuparai­rucana, éna tiámavia­napahi eta ani nuyehe. ¿Tájaha eta piviurevahi eta nayehe? —máichapa. ");
INSERT INTO ignNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tásiha, ema Jesús majica­pa­varepa: —Jéhesare, jararihi eta návacurehi; váhisera étaina te juca apaquehe. Te étainahini te juca apaquehe eta návacurehi, téhaca­cau­cha­nua­na­ri­pahini ena nímitu­reanahi, váhivare nacuca­ra­ta­ca­nuhini ena ticatia­na­ca­nuanahi. Taicha yátupi­quenehi eta návacurehi, vahi étaina te juca apaquehe —macahepa. ");
INSERT INTO ignNT_vpl VALUES