﻿USE sofia;
DROP TABLE IF EXISTS sofia.ify_vpl;
CREATE TABLE ify_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ify_vpl WRITE;
INSERT INTO ify_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yan laputu ey lintun Apu Dios hu kabunyan niya puyek. ");
INSERT INTO ify_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nem ya puyek ey eleg ni mapkel, ey endi nanha-ad diman. Edallem ni danum ni ebuh hu wadadman niya engeenget. Ey wada hu Ispirituh Apu Dios e heni dibdib di ta-pew ni danum. ");
INSERT INTO ify_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Immehel hi Apu Dios et kantuy “Kaweda kan kawwalwal.” Ey tu-wangun newalwalan. ");
INSERT INTO ify_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ey inang-ang Apu Dios humman ni lintu tu ey kayyaggud. Impan-appil tu hu kawwalwal niya engeenget. ");
INSERT INTO ify_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Et ngadanan tu hu kawwalwal ni aggew ey nginedanan tu hu engeenget ni hileng. Et mahileng nunman et mewa-wa ey humman hu nemangulun aggew. ");
INSERT INTO ify_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Kan mewan nan Apu Dios ey “Kaweda kan mengedwan danum et wadad ahpat edum ey wadad nandaul hu edum.” Ey humman neipahding. Ya etan wadad ahpat ey humman ida kulput ni kakelpuin udan, ey ya wadad nandaul ey humman danum eyad puyek. ");
INSERT INTO ify_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Humman ni nengedwan danum di ahpat et yad nandaul ey nginedanan Apu Dios ni kabunyan. Et mahileng et mewa-wa ey humman hu neikadwan aggew. ");
INSERT INTO ify_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kan Apu Dios ey “Kesiplud kan danum et meappil kad pangil ma-lat meang-ang hu puyek.” Ey humman neipahding. ");
INSERT INTO ify_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ya etan mamega ey nginedanan tun puyek, ey ya siniplud tun danum ey nginedanan tun baybay. Ey humman ni lintu tu ey kayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Immehel mewan hi Apu Dios et kantuy “Patmel mu e puyek emin hu nambakbaklang ni kameitnem niyadda keyew ni kaumlameh ni nebukelan ma-lat mannananeng ni wada henin nunman ni meitnem.” Ey neipahding humman. Ey kayyaggud humman ni lintun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nehileng et mewa-wa ey humman hu neikatlun aggew. ");
INSERT INTO ify_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kan mewan Apu Dios ey “Kawedadda umbebnang di kabunyan ma-lat meappil hu kawwalwal di hileng et pengiimmatunan niya pengamtaan ni tsimpuh ni aggew niyadda tsimpuh ni toon. ");
INSERT INTO ify_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Et humman idan umbebnang di kabunyan ey bebnangan da hu puyek.” Ey neipahding ida huyya. ");
INSERT INTO ify_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lintun Apu Dios hu dewwan et-eteng ni kaumbebnang e humman hu aggew e kaumbebnang ni kawwalwal et ya bulan e kaumbebnang ni hileng. Ey lintu tudda pay hu dakel ni bittuwen. ");
INSERT INTO ify_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Inha-ad tudda huyyan kaumbebnang di kabunyan ma-lat mabnangan hu puyek ");
INSERT INTO ify_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ni kawwalwal ni yan hileng, ey ma-lat meappil hu kawwalwal niya hileng. Ey inang-ang Apu Dios humman ni lintu tu ey kayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nehileng et mewa-wa ey humman neika-pat ni aggew. ");
INSERT INTO ify_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kan Apu Dios ey “Kawedan emin hu nambakbaklang ni mategud danum niya kaweda dakel ni nambakbaklang ni mantayyatayyab di kabunyan.” ");
INSERT INTO ify_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Et mawedan emin hu nambakbaklang ni mategud baybay e etta-teng ida edum. Ey lintu tu nambakbaklang ni sisit. Ey inang-ang Apu Dios ida humman ni lintu tu ey kayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Binendisyonan tudda hu mategun wadad baybay ma-lat medakkel ida et mapnu hu baybay. Ey binendisyonan tudda dama hu sisit ma-lat medakkel ida. ");
INSERT INTO ify_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nehileng et mewa-wa ey humman neikeliman aggew. ");
INSERT INTO ify_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Kan mewan Apu Dios ey “Kaweda eyad puyek hu nambakbaklang ni animal ni kaman-impah, yadda maeyum niyadda beken, yadda kamambinulluh, yadda kamangkinaddap niyadda kamandinallan.” Ey tu-wangun newadadda. Ey inang-ang Apu Dios ida humman ni lintu tu ey kayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Entanni ey kan Apu Dios ey “Yan nunya ey leltuen tayu law hu tuun henin hi-gatsu ma-lat pan-ap-apun emin ni mategud puyek, yad kabunyan niyad baybay.” ");
INSERT INTO ify_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Henin nunman hu impahding Apu Dios e lintu tu hu tuun mei-ingngeh hu elaw dad elaw tu. Ey lintu tuddan laki niya bii. ");
INSERT INTO ify_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Et bendisyonan tudda e kantuy “Kahlag kayu et medakkel kayu et mebebleyan ni emin eya puyek et hi-gayu hu ngenamung eyan puyek, anin idan deleg di baybay, yadda sisit niyaddan emin hu animal.” ");
INSERT INTO ify_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ey kantuy “Indaddan kun emin hu nambakbaklang ni kameitnem niyadda keyew ni kamekkan lameh da ma-lat wada kennen yu. ");
INSERT INTO ify_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ey winedak hu helek niyadda edum ni kameitnem ma-lat wada kennen idan animal niyadda sisit.” Emin ida huyya ey impahding tu ma-lat panyaggudan da. ");
INSERT INTO ify_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ey inang-ang nan Apu Dios ida humman ni lintu tu ey kayyaggud ni peteg. Nehileng et mewa-wa ey humman hu neika-nem ni aggew. ");
INSERT INTO ify_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hanniman hu nanletuan nan Apu Dios ni puyek niya kabunyan niyaddan emin hu wadadman. ");
INSERT INTO ify_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ginibbuh tu law ni emin hu ngunu tu et man-iyyatun meikkeppitun aggew. ");
INSERT INTO ify_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binendisyonan tu hu humman ni aggew et ibilang tun kamengillin tep humman ni aggew hu nengibbuhan tun ngunu tu et man-iyyatu. ");
INSERT INTO ify_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Hanniman hu naltuan ni kabunyan et ya puyek niya emin hu hipan wadadman. Lintun Apu Dios hu puyek niya kabunyan ");
INSERT INTO ify_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Endi hu neitnem niya endi simmemel di puyek tep endi ni udan ni impaelin Apu Dios ey endi ni hu mantennem. ");
INSERT INTO ify_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Entanni ey wadadda utbul ni menennum ni emin ni puyek. ");
INSERT INTO ify_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Entanni ey immala hi Apu Dios ni puyek, et kapyaen tun annel ni tuu et heb-ukan tu eleng tu, ey yimmayyah. ");
INSERT INTO ify_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Wada etan sineneman Apu Dios ni legunta e Eden di appit ni kasimmilin aggew et yadman nengiha-adan tun nunman ni tuun lintu tu. ");
INSERT INTO ify_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Impatmel Apu Dios di legunta hu nambakbaklang ni keyew ey kakkayyaggud ang-ang da niya lameh da. Yadman di gawwan etan ni legunta ey wada etan keyew ni kaum-idwat ni biyag et ya etan keyew ni kaum-idwat ni laing ni pengamtaan ni kayyaggud niya lawah. ");
INSERT INTO ify_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wada etan wangwang di Eden ni kamenennum ni nunman ni legunta. Yad a-allaw tu ey nan-epat huyyan wangwang. ");
INSERT INTO ify_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ya ngadan etan ni nemangulun wangwang ey Pishon e indalan tud Habilah. ");
INSERT INTO ify_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Yadman hu kawad-an ni nemahmah ni balituk, yadda etan nenginan batu niyadda etan kunan tun letan keyew ni kayyaggud hamuy tu. ");
INSERT INTO ify_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya ngadan etan ni meikkadwan wangwang ey Gihon e kamampellaw di bebley di Kush. ");
INSERT INTO ify_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ya etan meikkatlun wangwang ey Tigris e humman kamampellaw di Assyria di appit ni kasimmilin aggew. Ya etan meikka-pat ni wangwang ey Euphrates. ");
INSERT INTO ify_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Entanni et ilaw nan Apu Dios etan lintu tun tuud leguntad Eden, ma-lat hi-gatu mampaptek diman. ");
INSERT INTO ify_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kan Apu Dios ni hi-gatuy “Dammutun kennen mu hu lameh idan linggeman ni keyew eyad legunta, ");
INSERT INTO ify_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nem entan tu ekan hu lameh etan ni keyew ni pengamtaan ni kayyaggud niya lawah. Tep hedin kennen mu lameh ni nunman ni keyew ey mettey ka.” ");
INSERT INTO ify_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Entanni ey kan Apu Dios ey “Beken ni kayyaggud ni an manhahhakkey hu laki. Umletu-ak ni dayutun pangkadwa tun umbaddang ni hi-gatu.” ");
INSERT INTO ify_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Hi Apu Dios ey lintu tu dedan la hu nambakbaklang ni animal niya sisit e puyek hu naltuan da. Humman idan lintu tu ey tu impeang-ang etan ni laki ma-lat ngadanan tudda. Et emin hu hipan impangngadan tun hanhakkey ni hi-gada ey humman ngadan da. Nem emin ida humman ey endi dayutun pangkadwa tun umbaddang ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Et ya impahding Apu Dios ey inuyeng tu etan laki et ekalen tu hu hakey ni tu-ngal di taglang tu et han tu pandummit etan laman. ");
INSERT INTO ify_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kinapya tun bii humman ni tu-ngal ni taglang et ilaw tud kad-an etan ni laki. ");
INSERT INTO ify_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ey kan etan ni laki ey “Kayyaggud et wada law eya pangkadwak ni keingngeh ku. Nalpud tu-ngal ku niyad laman ku. Bii hu ngadan tu tep nalpud laki.” ");
INSERT INTO ify_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Et humman hu, hedin mengahwa hu laki ey hi-yanen tud ametun inetu et makiaddum etan ni bii et henidda hakey. ");
INSERT INTO ify_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Humman idan laki niya bii ey eleg ida mambalwasi, nem eleg ida umbaing. ");
INSERT INTO ify_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ya ketattallaman ni animal ni lintun Apu Dios eyad puyek, ey ya etan uleg. Kan etan ni uleg etan ni bii ey “Kaw makulug ni inhel Apu Dios ni hi-gayu e eleg kayu umkan ni lameh idan eyan linggeman ni keyew eyad legunta?” ");
INSERT INTO ify_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Hinumang etan ni bii e kantuy “Dammutun umkan kamiddan emin eyan lameh ni keyew eyad legunta, ");
INSERT INTO ify_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","nem kan Apu Dios ey eleg kami umkan niya eleg mi kepaa hu lameh eyan keyew ni neigawwa eyad legunta. Tep mettey kami kunu hedin umkan kamin nunman winu keppaen mi.” ");
INSERT INTO ify_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kan etan ni uleg etan ni bii ey “Eleg kayu kaya mettey. ");
INSERT INTO ify_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Hanniman impanghel nan Apu Dios tep amta tu e hedin kennen yu humman ey heni medyat hu mateyu et mei-ingngeh kayu law ni hi-gatu e amtaen yu hu kayyaggud niya lawah.” ");
INSERT INTO ify_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Inang-ang etan ni bii etan lameh nunman ni keyew ey kayyaggud ni peteg hu ang-ang tu et kayyaggud ni kennen. Ey ninemnem tu e pinhed tun mambalin ni nekallaing. Et umla et kanen tu et idwatan tu ahwa tu et kanen tu dama. ");
INSERT INTO ify_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yan nunman ni nengannan da ey heni nadyat mateda et pepuhdanan da law e nambelad ida. Et umladdan bulung ni keyew ni fig et dauben da et paneni dan annel da. ");
INSERT INTO ify_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kamangkehilleng ni nunman ey dingngel da hi Apu Dios ni kamandalladallan di legunta et mantaludda etan di keyew. ");
INSERT INTO ify_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nem kan Apu Dios nan hi Adam ey “Attu kad-an yu?” ");
INSERT INTO ify_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Himmumang hi Adam ey kantuy “Dingngel ku e kaka mengelli ey simmakuttak et eggak pinhed ni ang-angen muwak ni nambelad et mantalu-ak.” ");
INSERT INTO ify_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kan Apu Dios ey “Hipa nanghel ni hi-gam ni nambelad ka? Kaw kimman ka etan ni lameh ni keyew ni nakka ikka-leg?” ");
INSERT INTO ify_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kan Adam ey “Yan eya biin indawat mun pangkadwak hu nengidwat ni hi-gak et kanen ku.” ");
INSERT INTO ify_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kan Apu Dios etan ni bii ey “Kele mu impahding humman?” Kan etan ni bii ey “Hineul tuwak etan ni uleg.” ");
INSERT INTO ify_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Et kan Apu Dios etan ni uleg ey “Mekastigu ka tep ya nengipahdingan mun nunman. Emin ida hu animal ni lintuk ey hi-gam ni ebuh hu menelheltap eyan idut ku e meippalpun nunya ey mambulubuluh ka ey ya dep-ul hu kennekennen mun ingganah. ");
INSERT INTO ify_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Hi-gam niyaddalli helag mu et ya etan bii niyaddalli helag tu ey mambubuhhul kayullin ingganah. Kellaten mulli dapan etan ni helag ni bii, nem tegmilan tulli ulum.” ");
INSERT INTO ify_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ey kan Apu Dios etan ni bii ey “Panlelehhanam ali hu pan-ungngaam. Nem anin ni hanniman et pinheden mu metlaing hu ahwam niya hi-gatu pan-ap-apum.” ");
INSERT INTO ify_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Et kan Apu Dios daman Adam ey “Inu-unnud mu ahwam et kuman ka etan ni lameh ni keyew ni nakka ikka-leg. Et humman hu, iddutan ku hu puyek et melilligatan kallin ingganah ni mangngunnu ni han wada kennen mu. ");
INSERT INTO ify_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Umtetmel idalli helek niya hebit ey pangkennen yuddalli kumpulmih ni neitnem. ");
INSERT INTO ify_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mahapul ni manliligat ka niya umlinget kan mangngunnu et han wada ennien mu. Hanniman alin ingganah hu pambiyagam ingganah ni mambangngad kayud puyek di nalpuam, tep puyek hu nekapyaan mu ey puyek metlaing hu pambangngadan mu.” ");
INSERT INTO ify_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ya impangngadan Adam etan ni ahwatu ey Eva tep hi-gatu pan-innan emin ni tuu. ");
INSERT INTO ify_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Entanni ey binalwasian Apu Dios di Adam nan Eva ni katat ni animal ni kinapya tun balwasi. ");
INSERT INTO ify_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Et kan Apu Dios ey “Yan nunya ey neiingngeh law hu tuun hi-gatsu, e amta da hu kayyaggud niya lawah. Et humman hu, mahapul ni eleg ida umkan etan ni lameh ni keyew ni kaum-idwat ni biyag ma-lat eleg mannananeng hu biyag da.” ");
INSERT INTO ify_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Et pea-allaw Apu Dios ida etan di legunta e Eden et itu-dak tuddan an mangngunnud puyek ni nalpuan da. ");
INSERT INTO ify_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ya etan di legunta e Eden di appit ni kasimmilin aggew ey inha-ad tudda anghel ni mangguwalya niya ispadah ni kamantetebbel e kumpulmih hu tuka pengihhanggai ma-lat endi an meihnup di kad-an etan ni keyew ni kaum-idwat ni biyag. ");
INSERT INTO ify_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nan-ulig di Adam nan Eva ey newad-an hi Eva et man-ungnga ey laki. Et kan Eva ey “Bimmaddang hi Apu Dios et wada u-ungngak ni laki.” Et ngadanan tun Kain. ");
INSERT INTO ify_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Entanni ey newada hu neikadwan u-ungnga tu e hi Abel hu ngadan tu. Ya ngunu tun neettengan tu ey mampattul ni kalneroh. Hi Kain ey mampeyyew hu ngunu tu. ");
INSERT INTO ify_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Hakey ni aggew ey immiappit hi Kain nan Apu Dios ni ineni tu. ");
INSERT INTO ify_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hi Abel ey illa tudda hu kekakkayyaggudan ni parteh idan nemangulun impah ni kalneroh tu et iappit tu. Immamleng hi Apu Dios nunman ni impahding Abel et abuluten tu humman ni in-appit tu. ");
INSERT INTO ify_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nem eleg tu abuluten hu in-appit Kain. Et humman hu, nemahhig bunget Kain et tuka kekkeyunga. ");
INSERT INTO ify_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Et kan Apu Dios ni hi-gatu ey “Kele kaka umbubunget ey muka kekkeyunga? ");
INSERT INTO ify_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Gullat ni neiptek hu impahding mu et ebbuluten ku in-appit mu. Nem gapu tep neihla hu impahding mu ey hellipat-an Satanas hu pene-ulan tun hi-gam ma-lat hi-gatu hu ngenamung ni hi-gam, nem mahapul ni eleg mu i-abulut ni mehe-ul.” ");
INSERT INTO ify_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hakey ni aggew ey kan Kain nan agi tu e hi Abel ey “Umlaw itad payew.” Et lumaw ida, et wadaddadman ey pintey tu hi agitu. ");
INSERT INTO ify_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Entanni ey kan Apu Dios nan Kain ey “Attu hi agim ey?” Kan Kain ey “Tawwey ngu, kaw hi-gak hu kamengippaptek nan agik?” ");
INSERT INTO ify_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kan Apu Dios ni hi-gatuy “Hipa impahding mu? Inang-ang ku hu kuheyaw nan agim di puyek et mahapul ni ibbaleh ku. ");
INSERT INTO ify_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Et humman hu, meiddutan ka et endi law silbin ingngunum eyad puyek ni nengitmeg ni kuheyaw agim. ");
INSERT INTO ify_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Endilli ennien mu anin ni ippenaptek mu intanem mu. Ey endilli law maptek ni panha-adam et ka law manhawahawang.” ");
INSERT INTO ify_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Hinumang Kain hi Apu Dios e kantuy “Nemahhig huttan ni kastiguk, eggak ali han-isipel. ");
INSERT INTO ify_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tep ay pea-allaw muwak di deya et meiddawwi-ak di kad-an mu niya pambalin muwak ni manhawahawang ni ebuh. Et nanna-ud ni linggeman hu menang-ang ni hi-gak ey petteyen da-ak.” ");
INSERT INTO ify_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nem kan Apu Dios ni hi-gatuy “Eleg, tep hedin wada memettey ni hi-gam ey pitun tuu hu keiblehan ni pemetteyan dan hi-gam.” Et malkaan Apu Dios hi Kain ni pengi-immatunan ni tuun hi-gatu ma-lat eleg da pateyen. ");
INSERT INTO ify_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Et umidawwi law hi Kain nan Apu Dios et an mambebley di Nod di appit ni kakelinnugin aggew di Eden. (Ya keibbellinan ni Nod ey bebley ni panhawahawangan.) ");
INSERT INTO ify_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Entanni ey nengahwa hi Kain et man-ungngadda ey laki et ngadanan tun Enok. Impambalin Kain etan nambebleyan dan et-eteng ni bebley, et ngadanan tun Enok e ngadan etan ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hi Enok hu aman Irad, hi Irad hu aman Mehujael, hi Mehujael hu aman Metusael, hi Metusael hu aman Lamek. ");
INSERT INTO ify_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dewwa ahwan Lamek e di Adah nan hi Sillah. ");
INSERT INTO ify_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Nan-ungnga hi Adah et wada hi Jabal. Hi-gatu hu nahlagan idan kamampattul e nampambaley di tuldah. ");
INSERT INTO ify_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hi Jubal e agitu hu nahlagan idan nelaing ni man-ayyuding niya mantullaling. ");
INSERT INTO ify_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Nan-ungnga hi Sillah et wada hi Tubal Kain et ya etan agitun bii e hi Naamah. Hi Tubal Kain ey nambalin ni kaman-e-dih. ");
INSERT INTO ify_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Hakey ni aggew ey kan Lamek idan etan ni ahwatu e di Adah nan Sillah ey “Dengel yu eya e-helen ku. Pimmateyyak ni kamenikken ni laki tep liniputan tuwak. ");
INSERT INTO ify_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hi apu hi Kain ey meibleh ni pitun tuu hedin wada memettey ni hi-gatu, nem hedin hi-gak hu petteyen da, man meibleh ni nepitut pitun tuu.” ");
INSERT INTO ify_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Entanni ey nan-ungnga mewan hi Eva et kantuy “Indawtan tuwak nan Apu Dios ni meihhullul nan Abel e pintey nan Kain.” Et ngadanan tun Seth. ");
INSERT INTO ify_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nehiken hi Seth et wada u-ungnga tun hi Enos. Yan nunman ni tsimpuh hu nengilugian idan tutu-un meemmuemmung ni mandasal nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Yan eman ni nanletuan Apu Dios ni tuu ey lintu tuddan mei-ingngeh hu elaw dad elaw tu. Lintu tuddan laki niya bii ey binendisyonan tudda et ngadnan tuddan tuu. Huyyadda tenten ni helag Adam. ");
INSERT INTO ify_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Yan eman ni hanggatut et telumpulu toon Adam ey nan-ungngan hakey ni laki e nengalla-allan hi-gatu et ngadnan tun hi Seth. ");
INSERT INTO ify_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nambiyag pay ni walun gatut ni toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Yan eman ni neteyyan tu ey heyam ni gatut et telumpulu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hi Seth ey hanggatut et lima toon tu et han maweda etan u-ungnga tun hi Enos. ");
INSERT INTO ify_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nambiyag pay ni walun gatut et pitun toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Et yan eman ni neteyyan tu ey heyam ni gatut et hampulut dewwa toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Hi Enos ey nahyam hu toon tu et han maweda etan u-ungnga tun hi Kenan. ");
INSERT INTO ify_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nambiyag pay ni walun gatut et hampulut liman toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Et yan eman ni neteyyan tu ey heyam ni gatut et lima toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Hi Kenan ey nepitu toon tu et han maweda etan u-ungnga tu e hi Mahalalel. ");
INSERT INTO ify_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nambiyag pay ni walun gatut et na-pat ni toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Yan eman ni neteyyan tu ey heyam ni gatut et hampulu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Hi Mahalalel ey na-nem et lima toon tu et han maweda etan u-ungnga tu e hi Jared. ");
INSERT INTO ify_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nambiyag pay ni walun gatut et telumpulun toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Yan neteyyan tu ey walun gatut et nahyam et lima toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hi Jared ey hanggatut et na-nem et dewwa toon tu et han maweda etan u-ungnga tu e hi Enok. ");
INSERT INTO ify_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nambiyag pay ni walun gatut ni toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yan eman ni neteyyan tu ey heyam ni gatut et na-nem et dewwa toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hi Enok ey na-nem et lima toon tu et han maweda etan u-ungnga tun hi Methushelah. ");
INSERT INTO ify_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nambiyag pay ni telunggatut ni toon et mawedadda edum ni u-ungnga tu. Ey nekidagyum tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ya nga-mut ni toon ni nambiyagan Enok ey telunggatut et na-nem et lima. ");
INSERT INTO ify_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Yan nambiyagan tu ey nekidagyuman tun Apu Dios. Entanni ey endi maptek ey ettukaw hi Enok tep ingkuyug Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Hi Methushelah ey hanggatut et newalut pitu toon tu et han maweda etan u-ungnga tun hi Lamek. ");
INSERT INTO ify_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nambiyag pay ni pitun gatut et newalut dewwan toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Yan neteyyan tu ey heyam ni gatut et na-nem et heyam hu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hi Lamek ey hanggatut et newalut dewwa toon tu et han maweda etan u-ungnga tun laki. ");
INSERT INTO ify_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kantuy “Huyyan u-ungnga hu mengippeamleng ni hi-gatsun emin eyad neligat ni ngunu tayu eyad puyek ni inidutan Apu Dios.” Et ngadnan tun hi Noah. ");
INSERT INTO ify_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nambiyag pay hi Lamek ni liman gatut et nahyam et liman toon et mawedadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Yan neteyyan tu ey pitun gatut et nepitut pitu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Hi Noah ey limanggatut toon tu et han maweda tellun u-ungnga tu e hi Shem, hi Ham et hi Japet. ");
INSERT INTO ify_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Dimmakkel law hu tuud puyek ey wadadda hu kakat-agun bibi-i. Et yan eman ni nenang-angan idan wadad kabunyan idan nunman ni bibi-id puyek ey nan-iahwadadda pinhed da. ");
INSERT INTO ify_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kan Apu Dios ey “Nemahhig law hu kalinawah idan tuu. Et humman hu, wada pappeg ni pengan-anusan ni Ispirituh kun hi-gada. Iddawtan kuddan ebuh ni hanggatut et dewampulun toon ni pantuttuyyuan dan liwat da.” ");
INSERT INTO ify_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Humman newadaan ni etta-teng ni tuu eyad puyek ni nahlag ida etan ni bibi-in inahwaddan etan ni nalpud kabunyan. Yadda helag da ey et-eteng kabaelan da et mukun nandingngel ida. ");
INSERT INTO ify_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yan nenang-angan Apu Dios ni kalinawah ni emin ni tuud puyek e lawah ni emin hu wadad nemnem dan ingganah, ");
INSERT INTO ify_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ey nemahhig hu tuttuyyu tun nanletuan tun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Et mukun kan law Apu Dios ey “Bahbahen ku ew emin hu tuun lintuk et meendidda, anin idan animal ni kamandinallan ey kamambinulluh, niyadda sisit, tep nakka mantuttuyyun nanletuan kun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nem kaum-amleng hi Apu Dios nan Noah tep kayyaggud hu elaw tu. ");
INSERT INTO ify_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Huyya hu meippanggep nan Noah. Wada tellun u-ungnga tu e hi Shem, hi Ham, et hi Japet. Hi Noah ey kayyaggud ni tuu. Yan nunman ni ketaggu tu ey hi-gatun ebuh hu kayyaggud nekidagyuman tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nem yadda edum ni tuu ey nemahhig hu kalinewah da. Mabunget ida niya mapetey ida. ");
INSERT INTO ify_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kaang-ang-angan Apu Dios ey lawah eya puyek ni pambebleyan tep lawah idan emin hu tutu-u. ");
INSERT INTO ify_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Et kantun Noah ey “Bahbahen ku ew hu puyek et mepappeg hu biyag idan tuu tep ay lawah idan peteg e ida kamampapatey. ");
INSERT INTO ify_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Et humman hu, kapya kan bapor e ya kayyaggud ni keyew hu ussalen mu et kuwakuwaltuhen mu. Pudlitim ni pukut ida nambattanan ni dingding ma-lat endi an umhegep ni danum. ");
INSERT INTO ify_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ya kadinukkey tu ey epat ni gatut et neliman piyeh. Ya kalinakkeb tu ey nepitu et liman piyeh. Ya kasina-gey tu ey na-pat et liman piyeh. ");
INSERT INTO ify_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atepim, nem entan tu pakaddingding hu hampulut walun pulgadah di nanlinikweh di ta-pew tu ma-lat kawwalwal di bawang. Ey kapyam ni tellun gladuh niya kapya kan habyen di pinigging tu. ");
INSERT INTO ify_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pengapya dakan bapor tep lelbengan ku puyek et mebahbah emin hu mategu. ");
INSERT INTO ify_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nem wada planuh kun hi-gam ni peamnuk. Et humman hu, ihhehwang dakeyu. Hegep kayun ahwam, yadda u-ungngam niyadda ahwa da etan di bapor. ");
INSERT INTO ify_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Pekippahgep yudda nambulubulug ni emin ni nambakbaklang ni animal niyadda sisit ma-lat tumegudda. ");
INSERT INTO ify_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ipahgep yud bapor emin hu kennen yu niya kennen da.” ");
INSERT INTO ify_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Et ipahding Noah emin hu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Entanni ey nedatngan etan tsimpuh ni inhel Apu Dios et kantun Noah ey “Hegep kayuddan pamilyah mud bapor tep hi-gam ni ebuh hu imbilang kun kayyaggud di emin ni tuu. ");
INSERT INTO ify_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ipahgep mudda hu hampipitun nambulubulug ni kameibbillang ni malinih ni animal niya hanhakkey ni nambulubulug idan kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ey ipahgep mudda hu hampipitun nambulubulug ni nambakbaklang ni sisit. Ipahding mudda huyya ma-lat emin hu nambakbaklang ni animal niyadda sisit ey mebunnat ida eyad puyek. ");
INSERT INTO ify_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tep hanlingguan hu melebbah meippalpun nunya ey peellik hu udan ni na-pat ni aggew niya na-pat ni hileng ma-lat meendin emin ida mategun lintuk.” ");
INSERT INTO ify_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Et ipahding nan Noah emin hu intugun nan Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","12","Himmegep hi Noah, ya ahwatu, yadda u-ungnga tu niyadda ahwada etan di bapor ma-lat eleg ida malsing. Yadda nambulubulug ni animal ni kameibbillang ni malinih niyadda beken ni malinih, anin idan kamangkinaddap niyadda kamanbinulluh, yadda nambulubulug ni sisit, ey immalidda dama et mekihgep idan emin di bapor. Et malebah hu pitun aggew, e yan nunman hu meikkahampulut pitun aggew ni meikkadwan bulan ni nunman ni toon, ey inlaputu tu-wangun um-udan. Intaggan tu udan ni na-pat ni aggew niya na-pat ni hileng ey keut-utbul hu danum. Ey anin ni kabunyan et heni nantekang et kamangkaikuyag ali udan et malbengan hu puyek. Yan nunman ey enem ni gatut hu toon nan Noah. ");
INSERT INTO ify_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Yan nunman ni aggew ey himmegep hi Noah, ya ahwatu, yadda u-ungnga tu e hi Shem, hi Ham et hi Japet et niyadda ahwada etan di bapor. ");
INSERT INTO ify_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Nekihgep ni hi-gada hu nambulubulug ni nambakbaklang ni animal ni maeyum niya beken niyadda etan kaumtayab. ");
INSERT INTO ify_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Impahding da humman e inu-unnud da hu inhel Apu Dios ni pehding da. Et yan hinggepan dan emin etan di bapor ey inlekbin Apu Dios hu habyen. ");
INSERT INTO ify_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Sinaggan tu udan ni na-pat ni aggew et malbengan hu puyek. Lektattuy edallem law ni peteg hu danum ey simma-pew etan bapor. ");
INSERT INTO ify_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kamena-gey hu danum di puyek ey kamanta-ta-pew dama etan bapor di danum. ");
INSERT INTO ify_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Anin ni yadda etan ettata-gey ni duntug eyad puyek et nangkeli-muh ida. ");
INSERT INTO ify_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Taggan ni danum ta-gey et labhan tudda humman ni ettata-gey ni duntug ni enem ni mitroh. ");
INSERT INTO ify_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Et meendin emin hu mategu eyad puyek, yadda tuu, yadda animal ni maeyum niya beken, yadda kamambinulluh niya kamangkinaddap, niyadda sisit, tep nalsing idan emin. Yan ebuh hu neihwang ni eleg malsing ey hi Noah niyadda etan nekihgep ni hi-gatud bapor. ");
INSERT INTO ify_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Et malbengan hu puyek ni hanggatut et neliman aggew. ");
INSERT INTO ify_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nem eleg liwwanen Apu Dios hi Noah niyadda animal ni wada etan di bapor. Et paeli tu dibdib et ilepu etan ni danum ni metduk. ");
INSERT INTO ify_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nesiked law hu danum ni nalpud nandaul niya nesiked hu udan ");
INSERT INTO ify_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","et mambabbabbal ni natduk hu danum ni liman bulan. ");
INSERT INTO ify_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yan eman ni meikkahampulut pitun aggew ni meikkeppitun bulan ey nanha-ad etan bapor di ta-pew ni duntug e Ararat. ");
INSERT INTO ify_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nanengtun kamangketduk hu danum et yan lapun aggew ni meikkahampulun bulan ey kameang-ang ida law hu ta-pew ni duntug. ");
INSERT INTO ify_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nelabah hu na-pat ni aggew et han ibeghul nan Noah hu hakey ni habhabyen etan ni bapor ");
INSERT INTO ify_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","et ibukyat tu hakey ni gawwang. Eleg mambangngad et mantayyatayyab ingganah ni natduk hu danum. ");
INSERT INTO ify_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Entanni et ibukyat tu mewan hu hakey ni paluma ma-lat pengamtaan tu hedin natduk law hu danum. ");
INSERT INTO ify_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nem endi e-paan tu tep nanengtun dakel hu danum et mambangngad etan di bapor et ipahgep Noah. ");
INSERT INTO ify_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nelabah hanlingguan et ibukyat tu mewan etan paluma. ");
INSERT INTO ify_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kamangkehilleng ni nunman ey nambangngad etan paluma e wada himbat tun bulung ni olibah et humman nengamtaan Noah e natduk law danum. ");
INSERT INTO ify_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nelabah hanlingguan et ibukyat tu mewan etan paluma ey eleg law mambangngad. ");
INSERT INTO ify_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yan eman ni enem ni gatut et hakey hu toon nan Noah ni lapun aggew ni lapun bulan ey inbeghul tu bapor et man-ang-ang-ang ey kamangkema-gani law hu puyek. ");
INSERT INTO ify_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ey yan meikkadwampulut pitun aggew ni meikkadwan bulan ey nakamma-ganan law hu puyek. ");
INSERT INTO ify_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Et kan Apu Dios nan hi Noah ey “Dammutu law ni um-ehep kayun ahwam, yadda u-ungngam niyadda ahwa da. ");
INSERT INTO ify_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ibukyat mudda animal niyadda sisit et mahlag ida et medakkel ida et maihinap ida eyad puyek.” ");
INSERT INTO ify_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Et umhep hi Noah niyadda pamilyah tu. ");
INSERT INTO ify_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ey emin ida etan nambakbaklang ni animal, yadda kamandinallan niyadda kamangkinaddap, et yadda sisit ey immehep ida damad bapor e wada hakkeyey nan-uunnud ida etan ni keingngeh da. ");
INSERT INTO ify_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Entanni ey nengapya hi Noah ni altar ni pan-appitan tun Apu Dios et umlan hanhakkey idan animal niya sisit ni kameibbillang ni malinih et iappit tun hi-gatu e giniheb tudda. ");
INSERT INTO ify_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ey inebulut Apu Dios humman ni neiappit. Et kantud nemnem tuy “Eggak ali law iddusi hu puyek anin ni lawah hu nemnem niya kapehpehding idan tuu. Tep inamtak e neipalpu dedan ni keu-ungnga da ey hanniman elaw da. Eleggak ali law ippidwan lelbengen hu puyek ma-lat eleg mebahbah emin hu mategu. ");
INSERT INTO ify_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Hedin mannenneng eya puyek e eleg mebahbah man wadallin ingganah tsimpuh ni pantenneman, wada ahiani, wada manginudan, ya siaggew, ya kawwalwal niya hileng.” ");
INSERT INTO ify_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Entanni et bendisyonan Apu Dios hi Noah niyadda u-ungnga tu et kantun hi-gaday “Kahlag kayu et medakkel kayu et bebleyan yun emin eya puyek. ");
INSERT INTO ify_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Emin hu animal, yadda kamangkinaddap niya kamandinallan, yadda sisit niyadda mategud baybay ey tekkutan dakeyulli ey hi-gayulli kenamung ni pengippahdingan yun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iddawat kudda emin huyyan hi-gayu et mansilbin kennen yu, heniddan kameitnem e indawat kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nem entan tu ekan hu detag ni nanengtun wada kuheyaw tu, tep ya kuheyaw hu kad-an ni biyag. ");
INSERT INTO ify_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Et humman hu, ya tuun umpatey ni edum tun tuu ey mekastigu. Ey ya linggeman ni animal ni umpatey ni tuu ey mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tep lintuk hu tuun henin hi-gak, et humman hu hedin wada tuun petteyen tu edum tun tuu ey petteyen yu dama. ");
INSERT INTO ify_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Panhelag kayu et medakkel kayu et bebleyan yun emin hu puyek.” ");
INSERT INTO ify_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Entanni ey kan Apu Dios nan Noah et yadda u-ungnga tuy ");
INSERT INTO ify_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ihhammad kun mekitbal ni hi-gayu niyaddalli helag yu, ");
INSERT INTO ify_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","anin idan animal, yadda sisit niyaddan emin hu mategun edum yun himmegep etan di bapor. ");
INSERT INTO ify_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ey panna-ud kun e-helen ni hi-gayu e eleg law melbengi eya puyek ma-lat eleg mebahbah emin hu mategu. ");
INSERT INTO ify_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya pengi-ang-angan yun um-amnu eya inhel kun hi-gayu niyaddan emin hu mategu ey ");
INSERT INTO ify_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","weddaen ku sibbunglun di kulput di kabunyan et pengiang-angan yu niyaddalli helag yu e pannananeng kun ingganah hu nekitbalan kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Et hedin impaelik hu kulput di kabunyan et mewedda sibbunglun ");
INSERT INTO ify_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","16","ey nemnemen kulli humman ni nekitbalan kun hi-gayu niyaddan emin hu mategun wadad puyek e eggak law ippidwan peelli lebeng eyad puyek ma-lat eleg mebahbah ni emin hu mategu. ");
INSERT INTO ify_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Em, humman pengi-immatunan yu etan ni nekitbalan kun emin ni mategu eyad puyek.” ");
INSERT INTO ify_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yadda etan tellun u-ungngan Noah ni immehep di bapor ey hi Shem, hi Ham et hi Japet. Hi Ham hu aman Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Huyyaddan tellun u-ungngan Noah hu nahlagan idan katuutuu eyad puyek. ");
INSERT INTO ify_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hi amedan e hi Noah nemangulun nantanem ni grapes. ");
INSERT INTO ify_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Hakey ni aggew ey nebuteng ni meinnum ni kinapya tun grapes. Et mambelad ni neugip di a-abbung tun tuldah. ");
INSERT INTO ify_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hi Ham e aman Kanaan ey inang-ang tu ametu e hi Noah ni nambelad et tu ehelen idan agitu e di Shem nan Japet. ");
INSERT INTO ify_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Et umladdan wangal et iwa-ngal dad pahhannan da et dekugen da hi ameda ey daka panhinunnay ni limmaw di kad-an tu et egahen da etan wangal et mawengalan hi ameda e eleg da i-ang-ang ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","25","Yan binengunan Noah ni na-kalan ni buteng tu ey neamtaan tu hu impahding Ham e udidyan ni u-ungnga tu. Et kantuy “Ya idut idan helag Ham ey hi-gadalli bega-en idan helag di Shem nan Japet. ");
INSERT INTO ify_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nakka iddasal ni Ap-Apu e Dios ku e bendisyonan tu hi Shem. Ey pambalin tudda helag Ham ni bega-en idallin helag Shem. ");
INSERT INTO ify_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ey nakka iddasal e bendisyonan Apu Dios hi Japet et mambalin ni mahkang hu puyek tu ey mei-dum idallin helag Shem. Ey mambalin idalli helag Ham ni bega-en damaddan helag Japet.” ");
INSERT INTO ify_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hi Noah ey nambiyag ni telunggatut et neliman toon ni negibbuhan ni nalbengan ni puyek ");
INSERT INTO ify_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","et ya bilang emin ni toon tu et han matey ey heyam ni gatut et nelima. ");
INSERT INTO ify_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Huyyadda helag Shem, hi Ham et hi Japet e u-ungngaddan Noah. Dakel hu u-ungnga dan negibbuhan ni lebeng. ");
INSERT INTO ify_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yadda helag Japet ey hi Gomer, hi Magog, hi Madai, hi Jaban, hi Tubal, hi Meshek, et hi Tiras. ");
INSERT INTO ify_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Yadda helag Gomer ey hi Askenas, hi Ripat, et hi Togalmah. ");
INSERT INTO ify_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yadda helag Jaban ey nampambebley idad Elishah, yad Tarsis, yad Kittim niyad Rhodes. ");
INSERT INTO ify_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yadda helag Japet hu ammed idan tutu-un nampambebley di nangkeihnup niya nangkeigawwad baybay. Huyyaddan helag Japet ey nan-appiappil hu nambebleyan da niya nambakbaklang hu ehel da. ");
INSERT INTO ify_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Yadda helag Ham ey hi Kush, hi Misraim, hi Put et hi Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Yadda helag Kush ey yadda nambebley di Seba, yad Habilah, yad Sabtah, yad Raamah niyad Sabtekah. Yadda helag Raamah ey yadda nambebley di Seba niyad Dedan. ");
INSERT INTO ify_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ya hakey ni helag Kush ey hi Nimrod e nambalin ni ap-apuddan kamekiggubbat. Hi-gatu hu nemangulun nengenapput ni nekigubagubatan tud kebebbebley ");
INSERT INTO ify_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","niya hi-gatu kelalla-ingan ni mandedweng tep kabaddangin Apu Dios. Et humman hu, hin-addum ni kan idan tuud edum day “Heni kan Nimrod e nakallaing ni mandedweng.” ");
INSERT INTO ify_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Yadda bebley ni nan-ap-apuan tu ey yad Babilon, yad Erek, yad Akkad niyad Kalneh, e huyyadda bebley di Babilonia. ");
INSERT INTO ify_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Entanni ey limmaw hi Nimrod di Assyria et behwaten tu bebley di Nineveh, ya Rehobot-Ir, ya Kalah ");
INSERT INTO ify_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","niya Resen e bebley ni nambattanan ni Nineveh niya Kalah e et-eteng ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hi Misraim hu nahlagan idan nambebley di Lidia, yad Anam, yad Lehab, yad Naptuh, ");
INSERT INTO ify_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","yad Patrus, yad Kasluh, niyad Crete e nahlagan idan Pilistin. ");
INSERT INTO ify_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Yadda helag Kanaan ey hi Sidon e pengulwan et han hi Het. ");
INSERT INTO ify_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Newadadda edum ni u-ungngan Kanaan et humman idan u-ungnga tu nahlagan idan Jebusite, yadda Amorite, yadda Girgashite, yadda Hibite, yadda Arkite, yadda Sinite, yadda Arbadite, yadda Semarite niyadda Hamatite. Huyyaddan helag Kanaan ey neihinap ida. ");
INSERT INTO ify_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ya pappeg ni nambebleyan da ey neipalpud Sidon ingganah di Gerar e neihnup di Gaza. Nei-dum pay hu Sodom, Gomorrah, Admah niya Seboim ni neihnup di Lasha. ");
INSERT INTO ify_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Huyyadda hu helag Ham ni neihinap di kebebbebley e nambakbaklang hu ehel da. ");
INSERT INTO ify_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Hi Shem e neihnedan nan Japet hu nahlagan idan helag Eber. ");
INSERT INTO ify_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Yadda helag Shem ey hi Elam, hi Assur, hi Alpaksad, hi Lud et hi Aram. ");
INSERT INTO ify_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Yadda helag Aram ey hi Us, hi Hul, hi Gether et hi Meshek. ");
INSERT INTO ify_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Nahlag hi Alpaksad et wada hi Selah e aman Eber. ");
INSERT INTO ify_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hi Eber ey dewwa u-ungnga tu: hi Peleg hu ngadan ni hakey tep yan nunman ni ketaggu tu negenadwaan ni tutu-ud puyek. Hi Joktan hu ngadan agitu. ");
INSERT INTO ify_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Hi Joktan hu nahlagan idan tutu-un nambebley di Almodad, yad Selep, yad Hasarmabet, yad Jerah, ");
INSERT INTO ify_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","yad Hadoram, yad Usal, yad Diklah, ");
INSERT INTO ify_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","yad Obal, yad Abimael, yad Seba, ");
INSERT INTO ify_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","yad Ophir, yad Habilah niyad Jobab. Huyyaddan emin hu nahlag nan hi Joktan. ");
INSERT INTO ify_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ya nambebleyan da ey neipalpud Mesha ingganah di Sephar e duntuduntug ni bebley di appit ni kasimmilin aggew. ");
INSERT INTO ify_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Huyyaddan helag Shem ey neihinap idad dakel ni bebley ey nambakbaklang ehel da. ");
INSERT INTO ify_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Huyyaddan emin hu nahlagan idan u-ungngan Noah neipalpun negibbuhan ni nalbengan ni puyek. Neihinap idad kebebbebley eyad puyek meippuun di nahlagan da. ");
INSERT INTO ify_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Yan laputu ey hakey ni ebuh hu ehel ni tuu. ");
INSERT INTO ify_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nem entanni et ida kamangkedakkel ey limmaw idad appit ni kasimmilin aggew, ey dinteng da nedeklan ni puyek di Babilonia, et mambebley idadman. ");
INSERT INTO ify_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Et wada hakkeyey kanday “Mengapya itsun et-eteng ni bebley tayu. Ey behwaten tayu et-eteng niya eta-gey ni binattun baley et datengen tu kabunyan et mandingngel itsu niya eleg itsu mawehit eyad puyek.” Et ilepu dan mengapya. ");
INSERT INTO ify_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Entanni ey immali Apu Dios et tu ang-angen hu daka pangkapyaan bebley niya etan eta-gey ni baley. ");
INSERT INTO ify_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ey kantuy “Huyyaddan tuu ey hakey ida niya hakey hu ehel da. Huyya keilleppuan ni pengippahdingan dan pinhed da. Et dammutun emin ali law hu pinpinhed dan pehding ey pehding da. ");
INSERT INTO ify_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Itsuy, kelehbeng itsu et tayu pambakbaklang hu ehel da ma-lat eleg ida manhin-aawat!” ");
INSERT INTO ify_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Et iwehit Apu Dios idad puyek et isiked dan mengapya etan ni daka pangkapyaan bebley. ");
INSERT INTO ify_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ya impangngadan dan nunman ni bebley ey Babel tep yadman nenimengan Apu Dios ni hi-gada e impambakbaklang tu ehel da et iwehit tudda eyad ta-pew ni puyek. ");
INSERT INTO ify_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Huyyadda helag Shem. Yan eman ni nelabah hu dewwan toon neipalpun negibbuhan ni nalbengan ni puyek, eman ni hanggatut hu toon Shem ey nahlag et wada hi Arpachshad. ");
INSERT INTO ify_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nambiyag pay ni liman gatut ni toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Nantoon hi Alpaksad ni telumpulut lima ey nahlag et wada hi Selah. ");
INSERT INTO ify_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nambiyag pay ni epat ni gatut et tellun toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nantoon hi Selah ni telumpulu ey nahlag et wada hi Eber. ");
INSERT INTO ify_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nambiyag pay ni epat ni gatut et tellun toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Nantoon hi Eber ni telumpulut epat ey nahlag et wada hi Peleg. ");
INSERT INTO ify_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nambiyag pay ni epat ni gatut et telumpulun toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Nantoon hi Peleg ni telumpulu ey nahlag et wada hi Reu. ");
INSERT INTO ify_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nambiyag pay ni dewanggatut et heyam ni toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Nantoon hi Reu ni telumpulut dewwa ey nahlag et wada hi Serug. ");
INSERT INTO ify_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nambiyag pay ni dewanggatut et pitun toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Nantoon hi Serug ni telumpulu ey nahlag et wada hi Nahor. ");
INSERT INTO ify_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nambiyag pay ni dewanggatut ni toon et wadadda pay edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nantoon hi Nahor ni dewampulut heyam ey nahlag et wada hi Terah. ");
INSERT INTO ify_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nambiyag pay ni hanggatut et hampulut heyam ni toon et wadadda edum ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Nantoon hi Terah ni nepitu ey nahlag et wadadda u-ungnga tu e hi Abram, hi Nahor et hi Haran. ");
INSERT INTO ify_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Huyyadda helag Terah e amad Abram, hi Nahor et hi Haran. Nahlag hi Haran et wada hi Lot. ");
INSERT INTO ify_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hi Haran ey netey di bebley dad Ur di Babilonia ey nanengtun mategu hi ametu e hi Terah. ");
INSERT INTO ify_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Hi Abram ey inahwa tu hi Sarai. Hi Nahor ey inahwa tu hi Milkah e u-ungngan Haran. Wada agin Milkah ni bii e hi Iskah. ");
INSERT INTO ify_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hi Sarai ey nebasi et endi u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Hi Terah ey ingkuyug tu hi Abram e u-ungnga tu, hi Lot e inap-apu tu e u-ungngan Haran, hi Sarai e ahwan Abram et hi-yanen da hu Ur di Babilonia et lumaw idad Kanaan. Nem nanda-guh idad Haran et mambebley idadman. ");
INSERT INTO ify_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Et yadman neteyyan Terah eman ni dewanggatut et lima toon tu. ");
INSERT INTO ify_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yan eman ni eleg da ni peni-yanan ni Babilonia ey kan Apu Dios nan Abram ey “Hi-yan mu bebley mu, yadda aaggim, niyadda pamilyah amam et lumaw ka etan di bebley ni ittuduk ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Iddawtan dakan dakel ni helag mu et mandingngel kayu. Bendisyonan daka et man-amta ngadan mu, ey mebendisyonan edum ni tuu gapuh ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bendisyonan kudda etan memendisyon ni hi-gam, nem iddutan kudda mengiddut ni hi-gam ey bendisyonan kulli emin hu tuu eyad puyek gapuh ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Et hi-yanen Abram hu bebley tu et lumaw di nengitu-dakan Apu Dios e ingkuyug tu hi Lot. Nepitu et lima toon Abram ni neni-yanan tun Haran. ");
INSERT INTO ify_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ingkuyug tu hi Sarai e ahwatu, hi Lot e pengungngaan tu, yaddan emin hu limmu tu niyadda bega-en tun illa tud Haran, et lumaw idad Kanaan. Yan dintengan dad Kanaan, ");
INSERT INTO ify_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ey nanglaw ida ingganah ni dinteng da hakey ni bebley e neihnup di Sekem et kumapyaddan kampu dad kad-an ni oak e keyew di Moreh. Huyyan bebley ey nambebleyan idan helag Kanaan ni nunman ni tsimpuh. ");
INSERT INTO ify_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ey nampeang-ang hi Apu Dios nan Abram et kantuy “Huyya hu iddawat kuddan helag mun pambebleyan da.” Et mengapya hi Abram ni pan-appitan tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Entanni ey hini-yan da mewan humman ni bebley et manpalaw ida etan di duntuduntug ni bebley et mangkampuddad nambattanan ni Bethel di appit ni kakelinnugin aggew niyad Ai di appit ni kasimmilin aggew. Et kumapya mewan hi Abram ni pan-appitan et dayawen tu hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Nem eleg mannaneng diman. Nan-etaetan idan nanha-adan da ey nampalaw idad Negeb. ");
INSERT INTO ify_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Entanni ey wada nemahhig ni bisil di Kanaan et lumaw di Abram di Egypt et ida makibebley nidman. ");
INSERT INTO ify_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Yan eman ni daka penettengid Egypt, ey kantun ahwatuy “Hi-gam e Sarai ey kat-agu ka. ");
INSERT INTO ify_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Et hedin ang-angen dakaddan tuudya ey panna-ud da e han-ahwa ita et petteyen da-ak ma-lat al-en daka. ");
INSERT INTO ify_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Et humman hu, ehel mu e agi daka ma-lat eleg da-ak pateyen, nem kayyaggud hu pehding dan hi-gak gapuh ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Et yan dintengan dad Egypt, ey tu-wangun katettebaladdan tuudman hu kakinat-agun Sarai. ");
INSERT INTO ify_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Entanni ey inang-ang idan opisyal diman, et da ehelen ni patul da. Et ilaw da hi Sarai di baley tu. ");
INSERT INTO ify_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Et gapuh nan Sarai ey indawtan etan ni patul hi Abram idan kalneroh, gelding, baka, kamel, kebayyu, et yadda laki niyadda biin bega-en da. ");
INSERT INTO ify_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nem impandegeh nan Apu Dios etan patul niyadda wadad baley tu tep ya nengal-an tun Sarai. ");
INSERT INTO ify_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Et paeyag etan ni patul hi Abram et kantuy “Kele mu impahding huyyan hi-gak? Kele eleg mu ehelen e ahwam hi Sarai? ");
INSERT INTO ify_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kele kammuy agim hi Sarai et innang ni ahwaen ku? Awit mu et manglaw kayu!” ");
INSERT INTO ify_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Et mandalen etan ni patul ida tuu tu, et pea-allaw dad Abram, hi Sarai e ahwatu niyadda emin hu wadan hi-gada di diman e bebley da. ");
INSERT INTO ify_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hini-yan Abram hu Egypt et mambangngad di Negeb di Kanaan e ingkuyug tu ahwatu, hi Lot niyaddan emin hu wadan hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Kedangyan ni peteg hi Abram. Dakel hu balituk tu, ya pihhuh tu niyadda animal tu, henin kalneroh, gelding niya baka. ");
INSERT INTO ify_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Nangnanglaw ida et dumteng idad Bethel e nangkampuan da lan nunman di nambattanan ni Bethel niya Ai e yadman la hu nengapyaan tun pan-appitan. Yan nunman ni dintengan da ey dineyaw tu hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Hi Lot ey kedangyan dama e dakel hu kalneroh tu, ya baketu, ya gelding tu niyadda bega-en tu. ");
INSERT INTO ify_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Et humman hu, kulang law hu pampattulan da tep dakel ni peteg hu halun dan Abram. ");
INSERT INTO ify_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ey humman kaumhulun ni kapambabakaliddan daka pampattul. Yan nunman ey naneng tudda Kanaanite niyadda Perisite ni nambebley diman. ");
INSERT INTO ify_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Et kan Abram nan hi Lot ey “Beken ni kayyaggud hu ita mambekkal, anin idan taka pampattul, tep han-ama ita. ");
INSERT INTO ify_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ya kayyaggud ey man-appil ita haggud mahkang eya puyek. Pilim hu pinhed mun panha-adan et lumaw kayudman ma-lat man-appil ita. Ya etan eleg mu pillia, ey yadman hu panha-adak.” ");
INSERT INTO ify_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Et man-ang-ang-ang hi Lot ey ya etan nedeklan ni puyek e Jordan ingganah di Soar hu pinili tu e kamedennumin emin. Huyyan pintek Lot ey heni etan ni leguntan Apu Dios e Eden niya wada dama neiingngehan tud Egypt. Neipahding huyya et han bahbahan Apu Dios hu Sodom et ya Gomora. ");
INSERT INTO ify_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Humman hu pinilin nan Lot et lumaw diman e appit ni kasimmilin aggew. Humman hu impahding dan nan-appil. ");
INSERT INTO ify_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Et mambebley hi Abram di Kanaan. Nem hi Lot ey nekibebley di nedeklan ni neihnup di Sodom. ");
INSERT INTO ify_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Yadda tutu-udman ey lawah ida niya nemahhig hu liwat dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yan eman ni nan-appilan di Abram nan Lot, ey kan Apu Dios nan Abram ey “Pan-ang-ang-ang kad nanlinikweh ingganah di pappeg ni han-ang-ang mu. ");
INSERT INTO ify_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tep emin eya muka ang-ang-anga ey iddawat kun hi-gam niyaddalli helag mu et hi-gayulli hu kan puyek ni inggana. ");
INSERT INTO ify_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ey iddawtan dakallin dakel ni helag mun eleg mebillang e henin kadinakkel ni dep-ul. ");
INSERT INTO ify_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lakkay et mu ang-angen ni emin hu pappeg eyan puyek ni iddawat kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Et ialdan Abram hu kampu tud kad-an idan keyew ni oak di Mamre di Hebron. Ey nengapyan pan-appitan tun Apu Dios diman. ");
INSERT INTO ify_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Entanni ey wada gubat tep yadda etan epat ni patul e hi Amraphel di Babilon, hi Ariok di Ellasar, hi Kedorlaomer di Elam et hi Tidal di Goyim. ");
INSERT INTO ify_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ginubat dadda etan liman patul e hi Bera di Sodom, hi Birsa di Gomorrah, hi Sinab di Admah, hi Semeber di Seboim et ya etan patul di Bela e Soar hu hakey ni ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Humman idan liman patul ey impan-aaddum dadda sindalu dad etan di Nedeklandi Siddim e neihnup di Netey ni Baybay. ");
INSERT INTO ify_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yan hampulut dewwan toon ey hi Kedorlaomer hu ap-apu da, nem yan meikkeppulut tellun toon ey nginhay da law. ");
INSERT INTO ify_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nem yan meikkahampulut epat ni toon ey inemung nan Kedorlaomer hu sindalu tu niyadda sindalun edum tun patul, et gubaten dadda humman ni nangngehay ni nampambebley di Repaim di Asterot Karnaim, yadda Susim di Ham, yadda helag Emim di Saveh Kiriathaim ");
INSERT INTO ify_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","niyadda Horite di duntuduntug di Seir. Et pampedugen dadda ingganah di El Paran e neihnup di eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Et mambangngad idad En Mispat e ya ngadan tu law ey Kades, et gubaten dadda iAmalek niyadda Amorite ni nambebley di Hasason Tamal et apputen dadda. ");
INSERT INTO ify_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Entanni ey yadda etan liman patul di Sodom, yad Gomorrah, yad Admah, yad Seboim, niyad Bela, e Soar hu hakey ni ngadan tu, ey impan-aaddum da sindalu da et ida mambetak di Nedeklan e Siddim et gubaten dadman hi Kedorlaomer niyadda edum tun tellun patul. ");
INSERT INTO ify_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nem yadman ey dakel hu edallem ni bitu. Et umbebsik ida-et hu sindalun patul di Sodom niyad Gomorrah, ey nakna edum ni hi-gadadman. Nem yadda etan tellun edum dan patul ey bimmesik idad duduntug. ");
INSERT INTO ify_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Yadda etan epat ni patul ni nengapput ey nan-ala dan emin hu wadad Sodom niyad Gomorrah, anin idan kennen et handa hi-yana humman idan bebley. ");
INSERT INTO ify_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Anin hi Lot e pengungngaan nan hi Abram et impeki-la da, yadda halun tu niyaddan emin hu wadan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nem wada etan hakey ni tuun bimmesik, et tu idaddatteng nan Abram e Hebrew ni nangkampud neihnup idad keyew ni oak nan Mamre e Amorite. Hi Mamre niyadda agi tu e di Eskol nan hi Aner ey gayyum idan Abram. ");
INSERT INTO ify_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Yan nangngelan nan Abram e impeki-laddan etan ni epat ni patul hi Lot, e pengungngaan tu, ey inemung tudda tuu tun dammutun mekiggubbat, e telunggatut et hampulut walu idan emin, et unuden dadda ingganah di Dan. ");
INSERT INTO ify_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Dimmateng idadman et genedwaen Abram hu tuu tu. Et yan nunman ni hileng ey ginubat dadda humman ni patul e pindug dadda ingganah di Hobah e indalan dad Damascus. ");
INSERT INTO ify_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Et bangngaden tun emin hu imbesik da, anin hi Lot e pengungngaan tu, yadda limmu tu, yadda edum ni tuu niyadda bibi-in imbesik da. ");
INSERT INTO ify_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Yan nambangngadan nan Abram ni nengapputan tun Kedorlaomer, et yadda edum tun patul ey immali patul di Sodom et tu dammuen hi Abram di Nedeklandi Sabeh e Bebley ni Patul. ");
INSERT INTO ify_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Anin ni hi Melkisedek e patul di Salem e padin Apu Dios e Keta-ta-geyyan ey inlaw tu sinapay niya meinnum. ");
INSERT INTO ify_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Et bendisyonan tu hi Abram e kantuy “Abram, iddawat Apu Dios e Keta-ta-geyyan niya nanletun kabunyan niya puyek hu panyaggudan mu. ");
INSERT INTO ify_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Medeyyaw hi Apu Dios e nemaddang ni hi-gam et mengapput ka.” Et idwat nan Abram nan hi Melkisidek hu kapulun emin ni inapput dad nekigubatan tu. ");
INSERT INTO ify_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Entanni ey kan etan ni patul di Sodom nan hi Abram ey “Anin alam hu hipan binangngad mun imbesik da, nem pebangngad mun hi-gak ida tuuk.” ");
INSERT INTO ify_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nem kan Abram ey “Eleg, tep insapatah kun Ap-Apu e Dios e Keta-ta-geyyan niya nanletun kabunyan niya puyek ");
INSERT INTO ify_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","e endi nak ellan ni hipan hi-gayu, anin ni bedbed ni patut yu winu sinulid ma-lat eleg mulli penghel ey kimmedangyan hi Abram tep ya indawat kun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Yan ebuh hu kinan middan sindaluk ni an nekigubat hu eggak beyyadin hi-gayu. Nem idwat mu hu bingay eyaddan gayyum kun bimmaddang ni hi-gak e hi Aner, hi Eskol et hi Mamre.” ");
INSERT INTO ify_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Entanni ey nampeang-ang hi Apu Dios nan hi Abram di i-innep tu et kantuy “Abram, entan takut mu yaggud baddangan daka tep hi-gak hu heni panhappiyaw mu niya iddawtan dakan panyaggudam.” ");
INSERT INTO ify_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Nem hinumang nan Abram e kantuy “Apu Dios e Eta-gey ni peteg, anin ni ippahding mudda huttan et endi damengu silbitu tep endi u-ungngak ni pengippebeltanan kuddan wadan hi-gak. Ebuh etan bega-en ku e hi Elieser e iDamascus hu dammutun memeltan ni kinedangyan ku.” ");
INSERT INTO ify_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ey kan Apu Dios ni hi-gatuy “Beken hi Elieser e bega-en mu memeltan ni binaknang mu tep yalli u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Et ipengulun Apu Dios hi Abram di dallin et kantuy “Itengaw mud kabunyan et bilangen mudda bittuwen hedin hambilang mu. Tep henin nunman ali kadinakkel ni helag mu e eleg mebillang.” ");
INSERT INTO ify_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ey kinulug nan Abram hu inhel Apu Dios, et humman ni nengulugan tu hu gaputun nengibilangan Apu Dios ni hi-gatun kayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kan mewan Apu Dios ni hi-gatuy “Hi-gak hi Apu Dios e nengipea-allaw ni hi-gam etan di bebley di Ur di Babilonia ma-lat idwat kun hi-gam huyyan puyek ni pampuyyek mun ingganah.” ");
INSERT INTO ify_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ey kan Abram ey “Apu Dios e Eta-gey ni peteg, hipa pengamtaak e makulug ni pampuyyek ku huyya?” ");
INSERT INTO ify_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kan Apu Dios ni hi-gatuy “Ka alan baka et ya labah ni gelding niya lakkitun kalneroh e hantetlu toon da. Ey ala kan hakey ni paluma niya hakey ni balug.” ");
INSERT INTO ify_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Et an alen Abram humman idan imbagan Apu Dios ni hi-gatu, e impandewa tun ginedged, et iyayyaggud tu mewan ni hinandedwan inha-ad e impantatakdul tu. Nem yadda etan sisit ey eleg tu gedwaen. ");
INSERT INTO ify_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Entanni ey netapngan ida etan sisit ni kamengngan ni netey ni animal, nem inebul tudda. ");
INSERT INTO ify_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ey yan kamangkelinnug aggew ey naka-uyeng hi Abram, ey wada heni engeenget niya anggetakkut ni inang-ang tu. ");
INSERT INTO ify_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ey immehel hi Apu Dios e kantun Abram ey “Yallin edum ni aggew ey mekibbebley idalli helag mud edum ni bebley. Mambalin idallin himbut diman ni epat ni gatut ni toon et panhelheltapen daddalli. ");
INSERT INTO ify_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nem kastiguen kuddalli mengihhimbut ni hi-gada. Ey yallin peni-yanan dan nunman ni bebley ey ellan dalli kinedangyan idan tuudman. ");
INSERT INTO ify_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Hi-gam ey meka-a-amma kalli et han ka matey, niya melinggep ali ketteyyan mu. ");
INSERT INTO ify_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yadalli meikka-pat ni helag mu hu mambangngad eyad bebley. Yan nunman ali ey ihhi-met idan Amorite hu kalinawah da et kastiguen kudda.” ");
INSERT INTO ify_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yan nelinugan ni aggew et ma-nget, ey inang-ang nan Abram hu kaman-aahuk ni banga niya apuy ni kamantetebbel ni nelabah di nambattanan ida etan ni in-appit tun detag ni hinandedwa tun inha-ad. ");
INSERT INTO ify_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","21","Et yan nunman ey kan Apu Dios nan hi Abram ey “Iddawat kuddallin helag mu eya puyek meippalpud pappeg ni Egypt ingganah di Wangwang e Euphrates e nambebleyan idan Kenite, yadda Kenissite, yadda Kadmonite, yadda Hittite, yadda Perissite, yadda Repaite, yadda Amorite, yadda Kanaanite, yadda Gergashite, niyadda Jebusite.” ");
INSERT INTO ify_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hi Sarai e ahwan Abram ey nebasi et endi u-ungnga tu. Nem wada hi Hagar e bega-en tun iEgypt. ");
INSERT INTO ify_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Et kantun Abram ey “Anin ew ni iulig mu eya bega-en ku tep ay eleg i-abulut Apu Dios ni nak man-ungnga, et yalli u-ungnga yu hu pan-ungngak.” Ey inebulut Abram. Neipahding huyya eman ni nelabah hu hampulun toon ni nanha-adan dad Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","In-ulig Abram hi Hagar et mambutsug. Yan nengamtaan Hagar e nambutsug ey nemahhig hu tuka pemippihul nan Sarai. ");
INSERT INTO ify_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Et kan Sarai nan Abram ey “Bahul mu hu tuwak kapemippihulin bega-en ku. Ma-nu tep in-abulut ku e i-ulig mu, nem neipalpun nambutsugan tu ey tuwak kapippihula. Hamban anhan ang-angen Apu Dios hedin hipan hi-gatan dewwa hu neiptek, hi-gam winu hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kan Abram ey “Hi-gam hu kan bega-en ni hi-gatu et ngenamung hu pehding mun hi-gatu.” Et nemahhig hu kapehding Sarai nan Hagar et tuka panlelehhani et lektattuy bimmesik. ");
INSERT INTO ify_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Entanni ey dinteng etan ni anghel Apu Dios hi Hagar etan di hebwak etan di eleg mebebleyi di gilig ni dalan ni mampellaw di Sur. ");
INSERT INTO ify_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kan nunman ni anghel ey “Hagar e bega-en Sarai, kele wada kadya? Attu nalpuam niya attu lawwam?” Kan Hagar ey “Bimmesikkak e hini-yan ku hi Sarai e kan bega-en ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ey kan etan ni anghel ni hi-gatuy “Pambangngad kan hi-gatu et hi-gam hu mannenneng ni bega-en tu. ");
INSERT INTO ify_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Iddawtan dakan dakel ni helag mu e eleg mebillang. ");
INSERT INTO ify_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Huttan ni imbutsug mu ey laki. Ya pangngeddan mullin hi-gatu ey Ismael tep dingngel Apu Dios hu nampehemmehemmekan mun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Huttan alin u-ungngam ey heni ma-lem ni kebayyu. Anggebe-hel tullin emin tuu ey anggebe-hel dalli dama. Ey eleg tulli pinhed ni mekibbebley idan agitu.” ");
INSERT INTO ify_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kan Hagar di nemnem tuy “Kaw makulug ni inang-ang ku hi Apu Dios, ey nanengtun mategu-ak et e-ehhelen kulli meippanggep ni nunya?” Et kantuy “Hi-gam hu Dios ni kamenang-ang-ang ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Et humman hu ya kapangngeddan idan tuu etan ni hebwak ey “Hebwak etan ni wadan ingganah ni kamenang-ang-ang ni hi-gak.” Humman ni hebwak ey wadad nambattanan ni Kades niya Bered. ");
INSERT INTO ify_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Et iungngan Hagar etan u-ungnga dan Abram et ngadnan Abram ni hi Ismael. ");
INSERT INTO ify_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ya toon Abram ni nunman ey newalut enem. ");
INSERT INTO ify_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Yan nahyam et heyam hu toon Abram ey nampeang-ang mewan hi Apu Dios ni hi-gatu et kantuy “Hi-gak etan Dios e Kabaelan tun emin. U-unnud muwak et ya kayyaggud hu ipahding mun ingganah. ");
INSERT INTO ify_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mekitballak ni hi-gam et pedakkel kulli helag mu.” ");
INSERT INTO ify_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Et manyuung hi Abram ni nanlispituh tun hi-gatu. Kan Apu Dios ni hi-gatu ey ");
INSERT INTO ify_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“E-helen kun hi-gam e pan-emma dakallin dakel ni tuud kebebbebley. ");
INSERT INTO ify_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Yan nunya ey hullulan ku ngadan mu et bekken law ni hi Abram nem hi Abraham, tep pambalin dakallin aman dakel ni tuud kebebbebley. ");
INSERT INTO ify_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Iddawtan dakallin dakel ni helag mu. Mampatul idalli edum ni hi-gada niya mampambebley idallid dakel ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Pannananeng ku huyyan nekitbalan kun hi-gam niyadda helag mun edum ni aggew. Niya mannananeng ni hi-gak hu Dios ni daydayawen mu niyadda helag mu. ");
INSERT INTO ify_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Huyyan bebley e Kanaan ni nekibebleyan mu ey iddawat kun emin ni hi-gam niyaddalli helag mu ma-lat hi-gayu mengippuyyek ni ingganah, niya hi-gak ali hu Dios idan helag mu. ");
INSERT INTO ify_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","13","Mahapul ni mampekuggit ka, anin idan helag mu, ma-lat kei-ang-angan tu e pannananeng yu eya nekitbalan kun hi-gayu. Et humman hu, meippalpun nunya ey emin hu lakin helag mu, ey mahapul ni mekuggit idan meikkewwalun aggew ni neiungngaan da, anin idan i-ungngan bega-en yud baley yu niyadda himbut yun melpud edum ni bebley. Humman ni kekuggitan yu hu kei-ang-angan tu e mengmenglaw alin ingganah hu nekitbalan kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ya etan lakin eleg makugit ey eleg meibbillang ni tuuk tep eleg tu u-unnuden huyyan inhel ku.” ");
INSERT INTO ify_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Immehel mewan hi Apu Dios nan Abraham ey kantuy “Meippalpun nunya ey mehullulan law hu ngadan Sarai e ahwam, et hi Sarah law hu ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bendisyonan ku et wadalli u-ungnga yu! Et hi Sarah hu pan-innallin dakel ni tuu et wadaddalli patul ni helag tu.” ");
INSERT INTO ify_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Et dayawen nan Abraham hi Apu Dios. Nem kamangngi-ngi-ngi tep kantud nemnem tu ey “Kaw dammutu makkaw ni mewedda u-ungngak ey hanggatut law hu toon ku? Niya kaw an man-ungnga law hi Sarah ey nei-inna dama law e nahyam hu toon tu?” ");
INSERT INTO ify_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Et kan Abraham nan Apu Dios ey “Attu et hi Ismael kuma hu pengippeamnuam ni planuh mun hi-gakey?” ");
INSERT INTO ify_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nem kan Apu Dios ey “Eleg. Beken ni hi-gatu hu kangku. Man-ungngalli hi Sarah ni laki et ingngadnan mullin hi Isaac. Hi-gatu niyaddalli helag tu hu pengippeamnuan kun nekitbalan kun mannananeng ni ingganah. ");
INSERT INTO ify_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dingngel ku hu imbagam ni panyaggudan Ismael. Et humman hu, bendisyonan ku daman dakel ni peteg ni helag tu. Hi-gatulli kehlagan ni hampulut dewwan aap-apu niya huyyaddan helag tu ey et-eteng ali hu pambebleyan da niya mandingngel idalli dama. ");
INSERT INTO ify_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nem hi Isaac e i-ungngallin Sarah ni balin tun hanneyan tsimpuh hu pengippeamnuan ku eyan nekitbalan ku.” ");
INSERT INTO ify_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Negibbuh humman ni ung-ungbal da et hi-yanen Apu Dios hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yan nunman ni aggew ey inu-unnud nan Abraham hu inhel Apu Dios et kugiten tu hi Ismael e u-ungnga tu, yadda lalakkin kamanha-ad di baley tu niyadda lalakkin u-ungngaddan himbut tu. ");
INSERT INTO ify_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nekugit dama hi Abraham e yan nunman ey nahyam et heyam hu toon tu ");
INSERT INTO ify_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ey hampulut tellu toon Ismael. ");
INSERT INTO ify_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nandihhan idan han-aman nekugit ni nunman ni aggew, ");
INSERT INTO ify_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","anin idan emin ni lalakkin bega-en tu. ");
INSERT INTO ify_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Wadan pinhakkey ni nandattek aggew e kamanyuyyuddung hi Abraham di habyen ni a-abbung tu ey nampeang-ang hi Apu Dios ni hi-gatu etan di wada keyew di Mamre. ");
INSERT INTO ify_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","In-ang-ang tu, ey wada tellun lakin kaman-eh-ehneng et lumaw et manyuung ni panlispituh tun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","4","Et kantuy “Apuk ida, hedin kayyaggud yuka pannemnem ni hi-gak, panda-guh kayu ni anhan et man-iyyatu kayu eyad hengeg ni keyew et nak ali umlan danum ni pengullah yun heli yu. ");
INSERT INTO ify_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pandammuan tun pandaddanan kun kennen yu ma-lat wada ikkelmeg yu lad dalan.” Ey kanday “Ku anin tep.” ");
INSERT INTO ify_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Impapuut Abraham ni himmegep et kantun Sarah ey “Ganuim et umla ka etan ni kakkayyaggud ni alinah et menginkakapya kan sinapay.” ");
INSERT INTO ify_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Et papuut tu mewan ni limmaw di halun tu et an gumuyud ni mateban kilaw ni baka et degdegen tu hakey ni bega-en tun memalsi. ");
INSERT INTO ify_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nelutun emin et umlan gatas niyadda edum ni kennen et tu imangdad ni kennen idan nunman ni tuudman. Ida kamammangngan ey kaman-eh-ehneng hi Abraham di hengeg idan keyew diman. ");
INSERT INTO ify_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Entanni ey kanday “Attu hi Sarah e ahwamey?” Kan Abraham ey “Immen di bawang.” ");
INSERT INTO ify_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kan Apu Dios ey “Um-ali-ak ali mewan ni balin tun hanneyan tsimpuh et yan nunman ey wadalli law u-ungngan Sarah e ahwam.” Wada hi Sarah di habyen ni kampu di dingkuggan Abraham et dingngel tu humman ni ung-ungbal da. ");
INSERT INTO ify_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ey gapu tep nea-amma law hi Abraham niya nei-inna dama hi Sarah et nepappeg law hu kamelpud annel tu, ");
INSERT INTO ify_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ey kamangngi-ngi-ngi hi Sarah e kantud nemnem tuy “Inna-nu makkaw ni nak pan-ungngaan ey nei-inna-ak law niya nea-amma ahwak?” ");
INSERT INTO ify_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Et kan Apu Dios nan Abraham ey “Kele kamangngi-ngi-ngi hi Sarah? Kele kantuy ‘Kaw dammutun man-ungnga hu biin nei-inna, e henin hi-gak?’ ");
INSERT INTO ify_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kaw wada eleg kabaelin Apu Dios? Yallin pambangngadan kun kelebbahan ni heyam ni bulan ey man-ungnga hi Sarah ni laki.” ");
INSERT INTO ify_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Simmakut hi Sarah et iheut tu e kantuy “Eleggak ngumi-ngi.” Nem kan Apu Dios ey “Tam em, ngimmi-ngi ka.” ");
INSERT INTO ify_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Negibbuh humman ni nan-ungbalan da et han ida lumaw di lawwan da. Nekilaw hi Abraham ni hi-gada ingganah etan di kameuhdungi hu Sodom. ");
INSERT INTO ify_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kan Apu Dios di nemnem tuy “Heballi peamtak nan Abraham hu ninemnem kun pehding ku ");
INSERT INTO ify_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","tep yaddalli helag tu mambalin ni et-eteng ni bebley niya mandingngel idalli. Ey gapuh ni hi-gatu ey bendisyon kuddan tutu-u eyad puyek. ");
INSERT INTO ify_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Hi-gatu pinilik ni menuggun idan helag tun mengu-unnud ni hi-gak niya mengippahding ni kayyaggud niya limpiyuh ma-lat ipahding kullin emin hu insapatah kun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Et kan Apu Dios nan Abraham ey “Dingngel ku e yadda tuud Sodom niyad Gomora ey lawah ni peteg hu daka pehpehding. ");
INSERT INTO ify_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Et humman hu, mahapul ni umlawwak et nak ang-angen hedin makulug.” ");
INSERT INTO ify_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Yadda etan dewwan laki ey intuluy dan limmaw di Sodom. Nem ya etan katlu da e hi Apu Dios ey nanha-ad ni nekemtang et mekihummangan nan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kan Abraham nan Apu Dios ey “Kaw endien mudda tu-wangun emin hu tutu-ud Sodom e illagat mudda hu kayyaggud? ");
INSERT INTO ify_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Inna-nu hedin wadadda neliman tuun kayyaggud hu daka pehpehding, kaw bahbahen mu humman ni bebley winu eleg, ma-lat meihwang ida etan kayyaggud ni tuu? ");
INSERT INTO ify_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hi-gam ni huwet emin ni tuud puyek ey limpiyuh ka. Et humman hu, amtak e eleg mu illagat ida kayyaggud ni tuun pemahbahan muddan lawah ni tuu.” ");
INSERT INTO ify_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ey kan Apu Dios ey “Hedin wadadda hu neliman kayyaggud ni tuu, ey eleggak bahbaha humman ni bebley.” ");
INSERT INTO ify_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Immehel mewan hi Abraham ey kantuy “Apu, pesinsahi muwak anhan tep ay endi egen kun mengibbeggan hi-gam ni nunya tep endi-et lebbeng kun um-ehel tep tuu-ak ni ebuh. ");
INSERT INTO ify_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nem inna-nu hedin na-pat et liman ebuh hu kayyaggud ni tuudman, kaw bahbahen mu tep kulang ni lima?” Ey kan Apu Dios ey “Eleggak bahbaha humman ni bebley hedin wada na-pat et liman kayyaggud ni tuudman.” ");
INSERT INTO ify_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Immehel mewan hi Abraham ey kantuy “Inna-nu hedin na-pat idan ebuh?” Hinumang nan Apu Dios e kantuy “Eleggak bahbaha anin ni na-pat idan ebuh.” ");
INSERT INTO ify_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kan Abraham ey “Apu, entan anhan bunget mu tep wada pay ibbagak. Inna-nu hedin telumpulun ebuh hu kayyaggud ni tuudman?” Hinumang Apu Dios e kantuy “Eleggak bahbaha hedin wadadda telumpulu.” ");
INSERT INTO ify_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Et kan Abraham ey “Apu, pesinsahim anhan hu tuled kun mengibeggaddan nunyan hi-gam. Inna-nu hedin dewampuluddan ebuh?” Ey hinumang mewan Apu Dios e kantuy “Eleggak bahbaha humman ni bebley anin ni dewampulun ebuh hu kayyaggud ni tuudman.” ");
INSERT INTO ify_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kan mewan Abraham ey “Apu, entan anhan bunget mu, huyya law hu manggillig ni ibbagak. Inna-nu hedin hampulun ebuh hu kayyaggud ni tuudman?” Kan Apu Dios ey “Eleggak bahbaha anin ni hampulun ebuh hu kayyaddud diman.” ");
INSERT INTO ify_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Negibbuh humman ni ung-ungbal da et manglaw hi Apu Dios di lawwan tu. Et umenamut dama hi Abraham di baley tu. ");
INSERT INTO ify_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kamangkehilleng ni nunman ey dimmateng ida humman ni dewwan anghel di Sodom. Hi Lot e kamanyuyyuddung etan di eheb nunman ni bebley ey inang-ang tudda et tu dammuen ida et nanyuung ni nanlispituh tun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kantuy “Hi-gayuddan apuk, ikeyuy et lumaw itsud baley et ulahan yu heli yu. Ey mandedya itsu et han kayu humelaman ni kabbuhhan di lawwan yu.” Nem kanday “Anin ni linggeman hu keuggipan midya.” ");
INSERT INTO ify_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nem impapilit Lot et makilaw idad baley tu. Indaddanan tuddan kennen niya sinapay ni eleg mekamdugan ni kamengippalbag et mangan ida. ");
INSERT INTO ify_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Eleg ida pay maugip humman idan mangilin Lot ey hinelikub idan emin ni lalakkidman, yadda kamenikken niyadda nangkea-amma, hu baley Lot. ");
INSERT INTO ify_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Et itkuk dan Lot e kanday “Attudda etan lakin mangilim ey? Pa-hep mudda et i-ulig midda.” ");
INSERT INTO ify_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Immehep hi Lot et ilekbi tu et an makiungbal idan etan ni edum tun bimmebley. ");
INSERT INTO ify_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kantun hi-gada ey “Hi-gayuddan kaegiegi, entan anhan tu ipahding huttan ni lawah. ");
INSERT INTO ify_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Anin ew katteg ni yadda etan dewwan u-ungngak ni biin eleg ni mengahwa hu pe-hep ku et hi-gada pengippahdingan yun pinhed yu. Et beken ni yadda etan mangilik tep wadadda eyad baley ku et mahapul ni ippaptek kudda.” ");
INSERT INTO ify_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nem kanday “Hi-gam ni immalin nekibebley ni hi-gami, entan ngu dama keihihhimmal mu. Kele hi-gam hu menuttuddun hi-gami? A-allaw ka tep hi-gam ali anhan law hu pemellidpidan mi.” Et itulud da hi Lot ey da-et bahbahen hu habyen, ");
INSERT INTO ify_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","nem ginuyud ida etan ni dewwan minengili tud bawang hi Lot et ilekbi da. ");
INSERT INTO ify_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Et kulapen dadda etan tuun wadad dallin et eleg da hanhamak hu habyen. ");
INSERT INTO ify_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kan ida etan ni dewwan lakin mangilin Lot ni hi-gatuy “Kaw wadadda edum ni u-ungngam, inepum winu agim eyad bebley? Hedin wada, ehel mun hi-gada et uma-allaw kayudyan nunya, ");
INSERT INTO ify_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tep bahbahen mi huyyan bebley. Inamtan Apu Dios e nemahhig hu kalinawah idan tuudya et itu-dak dakemin memahbah eyan bebley.” ");
INSERT INTO ify_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Et papuut nan Lot ni limmaw et tu ehelen ida etan ni lakin mengi-ahwan u-ungnga tu e kantuy “Papuut tayu et uma-allaw itsudya tep bahbahen Apu Dios huyyan bebley.” Nem kan ida etan ni laki nem langlangkak tu. ");
INSERT INTO ify_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Yan nunman ni kamangkewa-wa ey kan ida etan ni anghel nan hi Lot ey “Papuut mu! Awit mu eya ahwam niyadda etan dewwan u-ungngam ni bii et uma-allaw kayu ma-lat eleg kayu mailegat ni kebahbahan eyan bebley.” ");
INSERT INTO ify_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kamandewadewa hi Lot, nem himmek Apu Dios et tengeden ida etan ni anghel hu ngamay tu, ya ngamay ahwa tu niyadda etan u-ungnga tu et ipengulu dadda ingganah ni immehep ida etan di bebley. ");
INSERT INTO ify_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kan etan ni hakey ni anghel ey “Besik kayu ma-lat eleg kayu matey. Entan panwiwwingngi yu. Ey entan panda-guh yu eman di nandeklan. Lakkayuy eman di duntug ma-lat eleg kayu mailegat ni kebahbahan idan nunyan bebley.” ");
INSERT INTO ify_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","20","Kan Lot ey “Kayyaggud anhan et himmek dakemi et deh e mategu kami, nem entan dakemi anhan palaw eman di duntug tep neidawwi ey meha-kupan kami et mettey kami. Attu anhan et yad eman di neihnup ni bebley hu bebsikan mi ma-lat meihwang kami? Iebulut yu anhan yaggud ek-ekut humman ni bebley.” ");
INSERT INTO ify_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kan etan ni anghel ey “Anin, ebbulutek hu kammu et eggak bahbaha humman ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Papuut yu! Pambesik kayun umlaw diman! Endi ni pehding ku ingganah umdateng kayudman.” Ya ngadan nunman ni bebley ey Soar tep kan Lot ey ek-ekut ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kamenimmil aggew ey umdateng di Lot di diman Soar. ");
INSERT INTO ify_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Linggab nan Apu Dios hu Sodom niya Gomorrah e nan-egah tu hu apuy niya sulfur diman. ");
INSERT INTO ify_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Et mebahbah humman ni bebley, anin idan bebley ni nangkeitakdul, yadda neitnem, yadda edum ni mategu, yadda tutu-u niyadda animal. ");
INSERT INTO ify_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ya ngu etan ahwan Lot ey nanwingi et mambalin ni kimmelhin ahin. ");
INSERT INTO ify_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Newa-wa ey bimmangun hi Abraham ni dagah et lumaw di inehnengan da lan nan-ung-ungbalan dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Et man-uhdung di nandeklan di Sodom niyad Gomorrah ey mahdel ni ahuk hu kameang-ang diman. ");
INSERT INTO ify_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nem ninemnem Apu Dios hi Abraham et hemeken tu hi Lot et eleg mailegat ni nemahbahan tun nunman idan bebley. ");
INSERT INTO ify_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Entanni ey hini-yan nan Lot niyadda etan dewwan u-ungnga tun bii hu Soar tep daka tekkusidda tuudman et lumaw idan an nambebley etan di leyang di duntug. ");
INSERT INTO ify_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Hakey ni aggew ey kan etan ni pengulwan nan hi agituy “Nea-amma law hi ama ey endin hekey hu lakin mengi-ahwan hi-gata ma-lat maweda u-ungnga ta. ");
INSERT INTO ify_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hedin ya ew pehding ta, ey buttengen ta hi ameta ma-lat makiulig itan hi-gatu ma-lat mahlag ita et eleg mepappeg hu helag tayu.” ");
INSERT INTO ify_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Et yan nunman ni hileng ey binuteng da hi ameda et makiulig etan pengulwan. Nem eleg amta ameda tep nakabbuteng. ");
INSERT INTO ify_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Newa-wa et kan etan ni pengulwan ni agituy “Nekiuliggak nan aman hileng. Buttengen ta mewan ni hileng et hi-gam dama meki-ullig ni hi-gatu ma-lat mahlag ita.” ");
INSERT INTO ify_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Et yan nunman ni hileng ey binuteng da mewan hi ameda et makiulig dama etan udidyan ey hanniman mewan e eleg amtan ameda tep nakabbuteng. ");
INSERT INTO ify_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Huyya impahding idan nunman ni dewwan u-ungngan Lot et mambutsug ida. ");
INSERT INTO ify_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nan-ungnga etan pengulwan ey laki et ngadnan tun hi Moab. Hi-gatu nahlagan idan iMoab. ");
INSERT INTO ify_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nan-ungnga dama etan udidyan ey laki mewan et ngadnan tun hi Ben-Ammi. Hi-gatu nahlagan idan iAmmon. ");
INSERT INTO ify_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Entanni ey hini-yan nan Abraham hu Mamre et lumaw di Negeb et manha-ad etan di nambattanan ni Kades niya Sur. Yan nanha-adan dad bebley di Gerar ey ");
INSERT INTO ify_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","kan tuddan tuudman ey agitu hi Sarah, et humman hu, hi Abimelek e patul ey tu impaeyag di baley tu hi Sarah ma-lat ahwaen tu. ");
INSERT INTO ify_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nem hakey ni hileng ey nan-i-innep hi Abimelek ey kan Apu Dios di i-innep tuy “Mettey ka, tep ya eya biin mu impaewit ey wada ahwa tu.” ");
INSERT INTO ify_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nem eleg ni iulig nan Abimelek hi Sarah. Et kantuy “Apu, kaw petteyen dakemiddan emin ni tuuk anin ni endi impahding kun lawah ni hi-gatu? ");
INSERT INTO ify_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Tam kangngun Abraham ey han-agidda ey anin daman eyan bii et humman dama kantu. Et humman hu, endi ngu amtak ni lawah ni nak impahding.” ");
INSERT INTO ify_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kan Apu Dios ey “Em, inamtak e endi bahul mu. Et mukun eggak iebulut ni mu i-ulig eya bii ma-lat eleg ka manliwat ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Pebangngad mu eya bii etan ni ahwa tu. Humman ni ahwatu ey prophet. Iddasalan dakan hi-gatu et eleg ka matey. Nem hedin eleg mu pebangngad, man mettey ka, anin idan tuum.” ");
INSERT INTO ify_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kamangkewa-wa ey impaeyag tudda opisyal tu et ehelen tun emin hu nekapkapya ey simmakut ida. ");
INSERT INTO ify_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Et paeyag tu hi Abraham et kantuy “Hipa huyyan mu impahding ni hi-gak? Hipa nak impahding et dakemi idwatan ni kebahbahan mi? Beken ni lebbeng ni an meippahding huyyan hi-gak. Kele mu impahding huyya?” ");
INSERT INTO ify_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ey kan Abraham ey “Mukun impahding ku huyya ey tep kangku ngu nem endi kamengullug nan Apu Dios di deya, et nakka umkaguh ni pemetteyan da-ak ma-lat piliwen da ahwak. ");
INSERT INTO ify_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Em, han-ahwa kami, nem ya kakulugan tu ey han-agi kami tep imbintan nan ama. ");
INSERT INTO ify_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Et yan nengipea-allawan nan Apu Dios ni hi-gak di bebley mi, ey kangkun Sarah ey anin attu lawwan mi, et e-helen tuddan tuu e han-agi kami et humman pengippeang-ang tun neminhed tun hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Et pebangngad Abimelek hi Sarah nan hi Abraham niya indawatan tun kakalneroh, yadda baka niyadda bega-en. ");
INSERT INTO ify_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ey kantun Abraham ey “Dammutun mampilli kan pinhed mun panha-adan eyad bebley ni nan-ap-apuan ku.” ");
INSERT INTO ify_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Et kantu daman Sarah ey “Iddawtan kun hanlibun palatah hi agim ma-lat keang-angan tun endi bahul mu niya pengamtaan idan edum yu e endi impahding mun lawah.” ");
INSERT INTO ify_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Et idasal Abraham nan Apu Dios e bendisyonan tu etan patul niya ahwatu, niyadda emin biin wadad baley tu ma-lat mampan-ungngadda. ");
INSERT INTO ify_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tep impambalin Apu Dios ni nebasi emin biidman e humman kastigun Abimelek ni tu nengal-an Sarah e ahwan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Entanni ey impeang-ang nan hi Apu Dios hu binabbal tun Sarah et peamnu tu inhel tu et man-ungngan nunman ni tsimpuh ni gintud tu. Neipahding huyya eman ni nea-amma law hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Et ngadanan Abraham humman ni gelang ni Isaac. ");
INSERT INTO ify_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Walun aggew etan ni gelang et kugiten nan Abraham tep humman hu inhel Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Yan nunman ni neiungngaan Isaac ey hanggatut hu toon nan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Immamleng hi Sarah et kantuy “Indawtan tuwak nan Apu Dios ni pan-am-amlengan ku. Emin ali mengngel ni nan-ungngaan ku ey mekiam-amleng idan hi-gak. ");
INSERT INTO ify_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hipa makkaw ngu an nannemnem ni nak mambutsug? Nem deh e wada u-ungnga min Abraham ey ay nea-amma law.” ");
INSERT INTO ify_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Yan eman ni naphuan Isaac ey nampahemul hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hakey ni aggew ey hi Ismael e u-ungngad Abraham nan hi Hagar e bega-en tun iEgypt ey tuka heghegnuda hi Isaac e u-ungngan Sarah. ");
INSERT INTO ify_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Inang-ang Sarah et kantun Abraham ey “Itu-dak mu eya himbut ni bii niya u-ungnga tu tep eleg mabalin ni an mekibbingngay etan di beltanen eyan u-ungngak e hi Isaac.” ");
INSERT INTO ify_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","El-eleg ni peteg hu kapannemnem nan hi Abraham ni nunman ni inhel Sarah tep u-ungnga tu dama hi Ismael. ");
INSERT INTO ify_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nem kan Apu Dios ni hi-gatuy “Entan tu ikakaguh hu meippahding eyan biin himbut niya u-ungnga tu. U-unnud mu hu inhel Sarah ni pehding mu tep hi Isaac e u-ungngam hu pengippeamnuan kun insapatah kun hi-gam e dakel ali helag mu. ");
INSERT INTO ify_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Iddawtan ku daman dakel ni helag eya u-ungngan etan ni himbut tep u-ungngam dama.” ");
INSERT INTO ify_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Et bumengun ni dagah hi Abraham ni newa-waan tu, et pan-idaddan tu kennen niya danum ni pebellun tun Hagar et ya u-ungnga tu et itu-dak tudda. Endi neputuk ni lawwan da et ida manhawahawang etan di eleg mebebleyi di Beersheba. ");
INSERT INTO ify_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Entanni ey na-puhan idan danum et hi-yanen Hagar etan u-ungnga tud hengeg ni kekkeyyew. ");
INSERT INTO ify_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Et an yumudung di a-allaw tu. Kantuy “Eggak han-isipel ni menang-ang ni ketteyyan ni u-ungngak.” Et kamanyuyyuddung ey kamannannangngih. ");
INSERT INTO ify_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dingngel Apu Dios hu nangih etan ni u-ungnga et kan alin anghel Apu Dios di kabunyan nan Hagar ey “Hagar, hipa muka kakkaguhi? Entan takut mu tep dingngel Apu Dios hu nangih ni u-ungngam. ");
INSERT INTO ify_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lakkay et mu awiten et a-alluken mu. Tep pambalin kuddalli helag tun et-eteng ni bebley.” ");
INSERT INTO ify_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Entanni ey heni dinyat nan Apu Dios hu matan Hagar ey inang-ang tu etan hibuy et an umehul et painuman tu etan u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Binendisyonan Apu Dios etan u-ungnga et meetteng di eleg mebebleyid Paran, nambalin ni nelaing ni mapena et pakiahwan inetun biin iEgypt. ");
INSERT INTO ify_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Yan nunman ni tsimpuh ey limmaw hi Abimelek e patul et hi Pikol e ap-apun sindalu tud kad-an nan Abraham et kan Abimelek ni hi-gatuy “Inamtak e daka kabaddangin Apu Dios di emin ni muka ippahding. ");
INSERT INTO ify_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Et mukun pinhed kun mansapatah kan Apu Dios e eleg ka mekibbuhhul ni hi-gak, yadda u-ungngak niyadda inap-apuk, nem mekiggayyum kan hi-gami eyad nekibebleyam henin nakka pehding ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Hinumang nan Abraham et kantuy “Dammutu, issapatah ku e eggak mekibbuhul ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Entanni ey nanlilih hi Abraham nan Abimelek meippanggep etan ni hibuy ni piniliw idan bega-en Abimelek. ");
INSERT INTO ify_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ey kan Abimelek ey “Eggak amta huttan ni neipahding niya eggak amta hu nengipahding tep ebuh ni nunyan pengngelan kun nuntan. Kele eleg mu ehelen ni hi-gak ni nunman?” ");
INSERT INTO ify_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Et idwatan Abraham hi Abimelek ni kalneroh niya baka ni kei-ang-angan ni kahinammad ni panggayyuman da. ");
INSERT INTO ify_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","29","Nem immal-an pay hi Abraham ni pitun kalneroh ni iddawat tun Abimelek ey kan Abimelek ey “Kele wada huttan?” ");
INSERT INTO ify_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hinumang nan Abraham e kantuy “Abulut mu huyyan iddawat kun hi-gam et kei-ang-angan tu e muka ebbuluta e hi-gak hu nengu-ku eyan hibuy.” ");
INSERT INTO ify_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Et meippalpun nunman ey neingadnan humman ni bebley ni Beersheba tep yadman neipahdingan ni hummangan da. ");
INSERT INTO ify_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Negibbuh humman ni hummangan da et mambangngad di Abimelek nan hi Pikol di Pilistia. ");
INSERT INTO ify_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Hi Abraham ey intanem tu keyew ni tamarisk di Beersheba et dayawen tu hi Apu Dios e wadan ingganah. ");
INSERT INTO ify_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nambebley Abraham di Pilistia ni nebayag. ");
INSERT INTO ify_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hakey ni aggew ey pinatnaan Apu Dios hi Abraham. Immehel ni hi-gatu e kantuy “Abraham.” Himmumang hi Abraham e kantuy “Em, Adyahhak, Apu.” ");
INSERT INTO ify_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kan Apu Dios ey “Ikuyug mu etan binugtung ni u-ungngam ni nakappinhed mu e hi Isaac et lumaw kayud Moriah et iappit mun hi-gak ni kagihheba etan di duntug ni ittuduk ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Bimmangun ni dagah hi Abraham ni newa-waan tu et dumikhal ni ittungu dan da pan-appitan. Et idaddan tu kebayyu et ikuyug tu hi Isaac niyadda dewwan bega-en tu et lumaw ida etan di inhel Apu Dios ni lawwan da. ");
INSERT INTO ify_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Yan meikkatlun aggew ey inang-ang Abraham etan lawwan da. ");
INSERT INTO ify_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kantudda etan ni bega-en ey “Di deya kayudya eyan kebayyu et madegah kamin han-amad dimmun et mi dayawen hi Apu Dios. Mambabangngad kamilli.” ");
INSERT INTO ify_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Impapehan nan Abraham etan ittungu nan Isaac et tengeden tu dama hu ewah niya etan pan-eppuy da. Ida kamenglaw ");
INSERT INTO ify_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ey kan Isaac ey “Ama, iyyadya ittungu niya pan-eppuy, nem attu etan kalneroh ni i-appit ey?” ");
INSERT INTO ify_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kan Abraham ey “Ngenamung hi Apu Dios.” Et manglaw ida. ");
INSERT INTO ify_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yan dintengan dad etan di inhel Apu Dios ni lawwan da ey kimmapya hi Abraham ni pan-appitan et iyayyaggud tun iha-ad etan ittungu. Binelud tu hi Isaac et ita-pew tun impebaktad etan di keyew di pan-appitan. ");
INSERT INTO ify_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inuknut tu hu ewah et petteyen tu-et etan u-ungnga tu, ");
INSERT INTO ify_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","nem immehel ali hu anghel Apu Dios di kabunyan e kantuy “Abraham!” Kan Abraham ey “Hipa humman e Apu.” ");
INSERT INTO ify_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kan ni anghel ey “Entan tu patey hu u-ungngam! Inamtak law e muka paka-u-unnuda hi Apu Dios tep eleg mu kawwanan eya hakey ni u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ey inang-ang nan Abraham hu kalneroh ni nehibudan hu ha-duk tud pewen di a-allaw tu et tu alen et humman hu in-appit tun Apu Dios et beken etan u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Et humman ni duntug ey ingngadnan nan Abraham ni “Hi Apu Dios hu kaum-idwat ni mahapul.” Et nanengtun humman hu ngadan tu ingganah ni nunya. ");
INSERT INTO ify_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ey kan ali mewan etan ni anghel Apu Dios di kabunyan nan Abraham ey ");
INSERT INTO ify_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Hi-gak e hi Apu Dios ey issapatah kud ngadan ku e bendisyonan daka tep kinulug muwak et eleg mu kawwanan ni i-appit ni hi-gak etan binugtung ni u-ungngam. ");
INSERT INTO ify_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Issapatah kun pedakkel hu helag mu et heniddalli bittuwen di kabunyan niya heniddalli palnah di gilig ni baybay e eleg mebillang. Huyyaddallin helag mu ey apputen da hu buhul da. ");
INSERT INTO ify_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bendisyonan kuddalli emin tuud puyek gapuh idan helag mu.” ");
INSERT INTO ify_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Et mambangngad idad kad-an idan etan ni bega-en tun ingkuyug tu et umenamut idad Beersheba. ");
INSERT INTO ify_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Entanni ey dingngel Abraham e walu ida lalakkin u-ungngan agi tu e hi Nahor nan ahwa tun hi Milkah. Hi Us hu pengulwan et han hi Bus, hi Kemuel e aman Aram, hi Kesed, hi Haso, hi Pildas, hi Jidlap et han hi Bethuel e udidyan e aman Rebekah. ");
INSERT INTO ify_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wadadda dama hu edum ni u-ungngad Nahor nan Reumah e hakey ni ahwatu e hi Tebah, hi Gaham, hi Tahas et hi Maakah. ");
INSERT INTO ify_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Hi Sarah ey hanggatut et dewampulut pitu toon tu et han matey di Hebron di Kanaan et ibeluan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Limmaw hi Abraham di kad-an idan Hittite et kantuy ");
INSERT INTO ify_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Hi-gak ey binunallak eyad bebley yu et endi nak pengikkullungan ni ahwak. Igetang kayu anhan ni puyek ma-lat nak pangikulungan ni hi-gatu.” ");
INSERT INTO ify_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Kanday “Dammutu. Hedin hi-gami man daka kaibbilang ni eta-gey ni ap-apu. Et humman hu, ngenamung kan mampillin pinhed mun pengikkullungan ni ahwam.” ");
INSERT INTO ify_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ey nanyuung hi Abraham di hinangga dan emin et kantuy ");
INSERT INTO ify_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Hedin i-abulut yun ikkulung ku ahwak di deya, ey ibega yu anhan nan Eplon e u-ungngan Sohar ");
INSERT INTO ify_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","et igetang tun hi-gak etan leyang di Makpelah di dagsin payew tu. Mahmahi yu hedin piga pengiggettang tu ma-lat bayadan kun wada kayun menang-ang et pambalin kun gungat ni pamilyah ku.” ");
INSERT INTO ify_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wadadman hi Eplon e kamekiyuyyuddung ni hi-gada et umhel et denglen idan emin ni tuun neamung etan di heggeppan di bebley. ");
INSERT INTO ify_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Kantun Abraham ey “Apu, iddawat kun hi-gam ni liblih humman ni leyang niya payew ni nunyan wadaddan emin eya tuun nangngel. Lakkay et mu ikulung diman etan ahwam.” ");
INSERT INTO ify_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nanyuung mewan hi Abraham di hinanggaddan Hittite. ");
INSERT INTO ify_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Et kantun Eplon ey “Eleg, abulut mu kuma et gatangen ku humman ni puyek et nak pangikulungan ni ahwak. Iddawat ku ustuh ni bayad tu.” Humman ni inhel tu ey dingngel idan etan ni tuun neamung. ");
INSERT INTO ify_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Hinumang nan Eplon e kantuy “Apu, ya balol nunman ni puyek ey epat ni gatut ni palatah ni ebuh. Nem kaw piga anhan humman ni hi-gatan dewwa? Mu kuma ikulung hu ahwam diman.” ");
INSERT INTO ify_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Inebulut Abraham et ipadngel tuddan Hittite ni binilang hu epat ni gatut ni palatah ni bayad etan ni puyek e in-ingngeh tud kapengigtang idan kamampanggettang. ");
INSERT INTO ify_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Et humman ni puyek Eplon di Makpelah e neihnup di Mamre e wada leyang tu, ya payew tu niyadda keyew tu ey nambalin ni puyek nan Abraham tep ginatngan tu. ");
INSERT INTO ify_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Emin ida Hittite ni neamung ey inamta da e puyek law Abraham humman ni puyek Eplon. ");
INSERT INTO ify_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Et an ikulung Abraham hi ahwa tu e hi Sarah etan di leyang di Makpelah ni neihnup di Mamre di Hebron di Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Et humman ni payew niya leyang e puyek etan ni Hittite ey puyek law nan Abraham et pambalin tun gungat ni pamilyah tu. ");
INSERT INTO ify_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Neka-a-amma law hi Abraham ey binendisyonan Apu Dios di emin ni impahding tu. ");
INSERT INTO ify_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Hakey ni aggew ey kan Abraham etan ni bega-en tun nengidinelan tun emin ni wadan hi-gatuy “Ita-pew mu ngamay mu eyad ulpuk ");
INSERT INTO ify_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","et isapatah mun Apu Dios e Dios di kabunyan niyad puyek e beken alidya Kanaan hu pampillian mun peahwam eyan u-ungngak. ");
INSERT INTO ify_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Lakkay alid bebley ni neiungngaan ku et ya u-ungngaddan agik hu mu pampillian ni ahwaen tu.” ");
INSERT INTO ify_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nem kan etan ni bega-en tuy “Nem inna-nu hedin wada hu hemmaken ku, nem eleg tu pinhed ni meikkuyyug ni hi-gak, kaw mambangngaddak et nak ikuyug eya u-ungngam et ilaw kudman?” ");
INSERT INTO ify_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kan Abraham ey “Eleg mabalin ni mu illaw eya u-ungngak diman. ");
INSERT INTO ify_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tep hi Apu Dios e Dios di kabunyan e nengi-lin hi-gak di deya et hi-yanen ku humman ni bebley ama niyadda agik, ey insapatah tun hi-gak e iddawat tuddan helag ku eya puyek di deya. Pemengngulu tu hu anghel tud lawwan mu ma-lat wada ewwiten mun ahwaen eyan u-ungngak. ");
INSERT INTO ify_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nem hedin eleg pinhed etan ni biin meki-lin hi-gam, ey meliblih ka eyad insapatah mu. Nem eleg mabalin ni mu ikkuyug eya u-ungngak di diman.” ");
INSERT INTO ify_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Et ita-pew etan ni bega-en hu ngamay tud ulpun Abraham et isapatah tu e u-unnuden tu humman ni inhel Abraham. ");
INSERT INTO ify_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Impeki-la tu hampulun kamel ni nengitakkayan tuddan kakkayyaggud ni tu la iddawat et lumaw di bebley Nahor di Mesopotamia. ");
INSERT INTO ify_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Yan dintengan tudman ey impan-iyatu tudda etan kamel di kad-an etan ni hibuy etan di a-allaw ni bebley. Hambatenganan ni nunman e humman hu tsimpuh ni kapan-ehhuliddan bibi-i. ");
INSERT INTO ify_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Et mandasal e kantuy “Apu Dios e Dios ni kadeyyawan apuk e hi Abraham, peang-ang mu anhan hu binabbal mun hi-gatu et baddangan muwak et umamnu etan inhel tun pehding ku. ");
INSERT INTO ify_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Adyahhak eyad hibuy ni kapan-ehhuliddan bibi-i eyad bebley. ");
INSERT INTO ify_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","E-helen kuddalli etan ni bibi-i e kangkuy ‘Idwasi muwak anhan ni inehul mun danum.’ Et ya etan biin peinnuman tuwak niyadda kamel ku ey humman pengamtaan ku e hi-gatulli ittudum ni ahwaen nan Isaac. Niya humman pengamtaan ku e impeamnum hu inhel mu etan ni kan bega-en ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Eleg tu gibbuhen hu dasal tu ey dimmateng hi Rebekah ni an man-ehhul. Hi-gatu hu u-ungngan Bethuel e u-ungngan agin Abraham e hi Nahor e ahwan Milkah. Hi Rebekah ey kat-agun biin eleg ni mengahwa. Limmaw ni an nan-ahul et kamangkeibbangngad ey ");
INSERT INTO ify_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","an dinammu etan ni bega-en et kantun hi-gatuy “Idwasi muwak anhan ni inehul mun danum.” ");
INSERT INTO ify_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kan etan ni bii ey “Em apu.” Et epahen tu etan inehul tu. ");
INSERT INTO ify_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Negibbuh ni imminum etan bega-en ey kan etan ni bii ey “Nak ali man-ehhul et painuman kudda dama eman kamel mu.” ");
INSERT INTO ify_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Et mambinbinangngad ni an nan-ahul ingganah impainuman tuddan emin etan kamel. ");
INSERT INTO ify_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kaum-eneeneng etan bega-en e tuka ang-ang-anga hedin hi-gatu tu-wangu pinilin Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Negibbuh ni impainuman tudda etan kamel ey impaukat etan ni bega-en hu betling niya gelhing ni balituk et idwat tu etan ni bii. ");
INSERT INTO ify_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kan etan ni bega-en ni hi-gatuy “Hipa kan u-ungngan hi-gam? Kaw dammutun wada keuggippan mid baley yun hileng?” ");
INSERT INTO ify_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kan Rebekah ey “Hi Bethuel hi ama e u-ungngad Nahor nan Milkah. ");
INSERT INTO ify_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Wada hu keuggipan yu niya dakel hu dagemin kennen ida eyan kamel.” ");
INSERT INTO ify_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nandukkun etan bega-en et dayawen tu hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kantuy “Kaka medeyyaw e Apu Dios e Dios ni kadeyyawan Abraham e kan bega-en ni hi-gak tep impeang-ang mu binabbal mu niya baddang mun hi-gatu. Et deh e impangulu muwak di baley idan agitu.” ");
INSERT INTO ify_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nambesik hi Rebekah di baley inetu et tu idaddatteng ni emin hu neipahding. ");
INSERT INTO ify_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Inang-ang nan Laban e agin Rebekah etan gelhing niya betling niya dingngel tu indaddatteng agitu ey nambesik di hibuy ey kaman-eh-ehneng etan bega-en di kad-an idan kamel. ");
INSERT INTO ify_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Et kantun hi-gatuy “Ikay et lumaw itad baley mi! Binendisyonan dakan Apu Dios! Wada hu indaddan kun panha-adan yud baley mi niya wada panha-adan idan kamel.” ");
INSERT INTO ify_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Et makilaw humman ni bega-en. Impaptek idan bega-en Laban etan kalga et han da pangan ida kamel et iap-ap da dagemi etan di panha-adan da. Ey ida immalan danum ni pengullah etan idan bega-en Abraham ni dapan da. ");
INSERT INTO ify_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yan eman ni neidaddan hu kennen da, ey kan etan ni bega-en ey “Eleggak mengngan ingganah e-helen ku hu gaputun nak illian di deya.” Kan Laban ey “Ku anin. Ehel mu.” ");
INSERT INTO ify_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kan etan ni bega-en ey “Hi-gak hu bega-en nan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Binendisyonan Apu Dios et kumedangyan. Dakel hu kalneroh tu, ya baka tu, ya kamel tu niya kebayyu tu, dakel hu silber tu, ya balituk tu niya bega-en tu. ");
INSERT INTO ify_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hi Sarah e ahwa tu ey nei-inna et han maweda etan hakey ni u-ungnga dan laki e hi-gatu hu nengipebeltanan Abraham ni emin ni kinedangyan tu. ");
INSERT INTO ify_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Impansapatah tuwak Abraham e u-unnuden ku hu kantu e beken ida etan bibi-id Kanaan hu pampillian kun ahwaen Isaac e u-ungnga tu, ");
INSERT INTO ify_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nem mampilli-ak kunun hi-gayuddan agitu. ");
INSERT INTO ify_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Et kangkuy ‘Nem inna-nu hedin eleg pinhed ni biin meki-lin hi-gak?’ ");
INSERT INTO ify_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ey kantuy ‘Hi Apu Dios e nakka u-unnuda ey pekillaw tu anghel tun memaddang ni hi-gam ma-lat wada ewwiten mun biin ahwaen eyan u-ungngak ni melpud helag ama. ");
INSERT INTO ify_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nem hedin umlaw kad kad-an idan aaggik ey eleg da ebbulutan pekillaw ni hi-gam etan bii ey meliblih kad insapatah mu.’ ");
INSERT INTO ify_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Et dumtengngak ni hambatenganan di hibuy ey indasal ku e kangkuy ‘Apu Dios e Dios ni kadeyyawan Abraham e kan bega-en ni hi-gak, baddangi muwak eyad nakka nemnemneman pehding ku. ");
INSERT INTO ify_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hedin wada kamenikken ni biin um-alin an man-ehhul ey ibbagak ma-lat idwatan tuwak ni innumen ku. ");
INSERT INTO ify_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Et hedin peinnuman tuwak niyadda kamel ku, ey humman pengamtaan ku e hi-gatu pinhed mun ahwaen ni u-ungngan kan bega-en ni hi-gak.’ ");
INSERT INTO ify_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nakka pan-iddasal huyya ey iyyalli hi Rebekah ni an man-ehhul. Negibbuh ni nan-ahul et kangkuy ‘Idwasi muwak anhan eyan inehul mu.’ ");
INSERT INTO ify_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ey impah tu etan inehul tu et kantuy ‘Imay, inum ka et hannak painumidda dama hu kamel mu.’ Et uminummak et tu painuman ida kamel ku. ");
INSERT INTO ify_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kangkun hi-gatuy ‘Hipa amam?’ Ey kantuy ‘Hi Bethuel hi ama e u-ungngad Nahor nan Milkah.’ Et iha-ad ku etan singsing di eleng tu niyadda gelhing di ngamay tu. ");
INSERT INTO ify_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Et mandukkunnak et dayawen ku hu Ap-Apu e Dios nan Abraham tep impangulu tuwak et hamaken ku hu biin u-ungngan agitu. ");
INSERT INTO ify_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Et ya pinhed kun e-helen ey hedin kabbabbal kayun hi-gatu et pinhed yun meki-eppun hi-gatu, ehel yu ma-lat amtaen ku hedin hipa pehding ku.” ");
INSERT INTO ify_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ey hinumang di Bethuel nan Laban e kanday “Hi Apu Dios hu nengi-lin hi-gayudya. Et kaw hipa mi e-helen? ");
INSERT INTO ify_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Anin ni ikuyug mu hi Rebekah et iahwan u-ungngan kan bega-en ni hi-gam te ay humman hu pinhed Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Yan nangngelan etan ni bega-en ni nunman ey nandukkun et dayawen tu hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Et ukaten tudda etan intabin tun gamgam ni balituk niya silber niyadda kakkayyaggud ni balwasin iddawat tun Rebekah. Inukat tudda dama etan nangkenginan iddawat tun inetu et ya agitu. ");
INSERT INTO ify_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Et han ida law mangan ni emin et mandeyadda etan bega-en et yadda edum tun hanlabbi. Newa-wa et bumengun ida ey kan etan ni bega-en ey “Imay tu-wa et lumaw kami.” ");
INSERT INTO ify_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nem kan di Laban nan hi ineda ey “Entanni ew man et malebah hu hampulun aggew ni panha-adan Rebekah et han mu ikuyug.” ");
INSERT INTO ify_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nem kan etan ni bega-en ey “Entan anhan tu taktak hu pambangngadan ku haggud deh e kayyaggud et binaddangan tuwak nan Apu Dios et kayyaggud hu nambalinan ni illian kudya.” ");
INSERT INTO ify_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kanday “Entanni ew tep et ayagan tayu hi Rebekah hedin hipa hu kantu.” ");
INSERT INTO ify_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Et aygan da hi Rebekah et kanday “Kaw pinhed mun mekillaw eyan tuu?” Ey kantuy “Em, pinhed kun mekillaw.” ");
INSERT INTO ify_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Et iebulut da law ni mekillaw hi Rebekah ida etan ni bega-en Abraham. Niya impakilaw da daman Rebekah etan bega-en tun nengipappaptek ni hi-gatu meippalpun kaglang tu. ");
INSERT INTO ify_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Binendisyonan da hi Rebekah e kanday “Mambalin kalli kayan inan kalibulibun tuu. Niya apputen idallin helag mu hu buhul da.” ");
INSERT INTO ify_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Et mantakkay di Rebekah niyadda bega-en tud kamel et makilaw ida. ");
INSERT INTO ify_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hi Isaac ey nambebley di Beer Lahai Roi di Negeb. ");
INSERT INTO ify_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Yan nunman ni mahmahdem ey an nandaddallan hi Isaac ey inang-ang tudda kamel ni iyyalli. ");
INSERT INTO ify_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ey inang-ang Rebekah hi Isaac et man-ayuhu etan di kamel. ");
INSERT INTO ify_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Minahmahan tu etan ni bega-en e kantuy “Hipa eman tuun kamandaddallan ni iyyallin an menammun hi-gatsu?” Kan etan ni bega-en ey “Humman u-ungngan kan bega-en ni hi-gak.” Et manhukyung hi Rebekah. ");
INSERT INTO ify_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Dimmateng hi Isaac et ehelen etan ni bega-en emin hu neipahding. ");
INSERT INTO ify_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inewit nan Isaac hi Rebekah etan di nambalyan inetun hi Sarah et man-addum ida. Nekappinhed nan Isaac hi Rebekah et hi-gatu nenga-alluk ni hi-gatun neteyyan inetu. ");
INSERT INTO ify_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Hi Abraham ey nambintan ni hakey ni bii e hi Keturah hu ngadan tu. Yadda u-ungnga da ey ");
INSERT INTO ify_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","hi Simran, hi Joksan, hi Medan, hi Midian, hi Isbak et hi Suah. ");
INSERT INTO ify_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Nahlag hi Joksan et di Seba nan Dedan. Nahlag hi Dedan et wadadda Assurim, yadda Letushim niyadda Leummim. ");
INSERT INTO ify_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Nahlag hi Midian et hi Ephah, hi Epher, hi Hanok, hi Abida et hi Eldaah. Huyyaddan emin hu helag Keturah. ");
INSERT INTO ify_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Hi Isaac hu nengipebeltanan Abraham ni emin ni wadan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nem yan eman ni ketaggu tu ey indawtan tudda dama etan u-ungnga tud edum ni ahwa tu et itu-dak tuddad appit ni kasimmilin aggew e neidawwid kad-an Isaac. ");
INSERT INTO ify_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Neka-a-amma hi Abraham et matey eman ni hanggatut et nepitu et lima toon tu. ");
INSERT INTO ify_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Et an ikulung idan u-ungnga tu e di Isaac nan Ismael etan di ginatngan Abraham ni leyang nan Eplon e u-ungngan Sohar e Hittite. Yadman dama neikulungan Sarah e ahwatu etan di takdul ni payew di Makpelah e neihnup di Mamre. ");
INSERT INTO ify_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Entanni ey binendisyonan nan Apu Dios hi Isaac. Ya nambebleyan tu ey yad Beer Lahai Roi. ");
INSERT INTO ify_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Huyyadda hu helag Ismael e u-ungngan Abraham nan Hagar e iEgypt e bega-en Sarah: ");
INSERT INTO ify_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya pengulwan ey hi Nebayot et han hi Kedar, hi Adbeel, hi Mibsam, ");
INSERT INTO ify_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","hi Misma, hi Dumah, hi Massa, ");
INSERT INTO ify_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","hi Hadad, hi Tema, hi Jetur, hi Naphis et han hi Kedemah e udidyan. ");
INSERT INTO ify_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Huyyaddan hampulut dewwan u-ungngan Ismael ey nei-peng idan nan-ap-apud hampulut dewwan bebley ni neingedanan ni ngadan da. ");
INSERT INTO ify_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Netey hi Ismael eman ni hanggatut et telumpulu et pitu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Yadda helag tu ey nei-peng idad kebebbebley neipalpud Habilah ingganah di Sur e neihnup di pappeg ni Egypt di appit ni kasimmilin aggew ni mampellaw di Assyria e neappil idad edum ni helag Abraham. ");
INSERT INTO ify_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Huyyadda hu nekapkapyad biyag nan hi Isaac e u-ungngan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Hi Isaac ey na-pat hu toon tun nan-ahwaan Rebekah e agin Laban niya u-ungngan Bethuel e iAramea di Paddan Aram di Mesopotamia. ");
INSERT INTO ify_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Dimmasadasal hi Isaac nan Apu Dios tep eleg pakeungnga hi Rebekah. Entanniy dingngel Apu Dios hu dasal tu et mambutsug hi Rebekah. ");
INSERT INTO ify_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ya etan imbutsug tu ey nandupi-il ey ida kaumbenultung di egeh tu. Et mandasal nan Apu Dios e kantuy “Kele henin nunya kameipahpahding ni hi-gak?” ");
INSERT INTO ify_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ey kan Apu Dios ni hi-gatuy “Huttan idan nandupi-il ni imbutsug mu ey mambalin idallin dewwan et-eteng ni bebley. E-etteng ali kabaelan ni hakey. Ya etan memengngulu ey mambalin ni bega-en ali etan ni meihned.” ");
INSERT INTO ify_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nedatngan hu pan-ungngaan tu ey makulug tu-wangun nandupi-il u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ya nemangulun neukat ey makaddalang belat tu niya nekabwekan emin annel tu et ingadnan dan hi Esau. ");
INSERT INTO ify_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ya etan neihayned ni neukat ey inhammad tun intenged di dapan nan Esau et ingadnan dan hi Jacob. Na-nem hu toon nan Isaac ni neiungngaan idan nunyan nandupi-il ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Yan nehiknan da ey nambalin hi Esau ni madweng e yad muyung hu tuka lallawwi. Hedin hi Jacob ey pinpinhed tun manha-ad di baley da. ");
INSERT INTO ify_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Hi Isaac ey pinpinhed tu hi Esau tep ya tuka i-anemut ni tuka dedwengan tuka ihhida. Nem hi Rebekah ey hi Jacob hu pinpinhed tu. ");
INSERT INTO ify_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Hakey ni aggew e kamene-eng hi Jacob ni ihhida ey dimmateng hi Esau ni nalpud muyung ey neka-upa. ");
INSERT INTO ify_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kan Esau nan Jacob ey “Idwasi muwak eyan madlang ni kennen ni inhaeng mu et kuman nak tep neka-upa-ak.” (Et ingadnan da hi Esau ni Edom. Ya hu keibbellinan ni Edom ey madlang.) ");
INSERT INTO ify_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kan Jacob ey “Dammutu, nem pakkaw ni iddawat mun hi-gak hu kelebbengan mun pengulwan.” ");
INSERT INTO ify_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kan Esau ey “Ku anin! Kaw hipa silbin kelebbengan hedin mettey yak ni upak?” ");
INSERT INTO ify_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kan Jacob ey “Pansapatah ka ni e iddawat mun hi-gak hu kelebbengan mu et han daka idwasi.” Et mansapatah hi Esau e idwat tu hu kelebbengan tu. ");
INSERT INTO ify_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Indawat nan Jacob etan kennen nan Esau et kanen tu et manglaw mewan. Humman ni impahding Esau ey impeang-ang tu e eleg tun hekey ibbilang etan kelebbengan tun pengulwan. ");
INSERT INTO ify_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Entanni ey wada mewan hu bisil e heni la etan ni bisil ni ketaggun Abraham et lumaw hi Isaac di bebley di Gerar di bebley nan Abimelek e patul di Pilistia. ");
INSERT INTO ify_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nampeang-ang hi Apu Dios nan hi Isaac et kantuy “Entan elaw di Egypt, nem pannaneng kayu etan di ittuduk ni panha-adan yu. ");
INSERT INTO ify_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","U-unnud mu et manha-ad kayudya, et ipaptek dakan hi-gak ni ingganah niya bendisyonan daka. Iddawat kun hi-gam niyadda helag mu eya puyek niya peamnuk hu insapatah ku lan amam e hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Iddawtan dakan dakel ni helag mun henin kadinakkel ni bittuwen e eleg mebillang. Bendisyonan kuddalli emin tuud puyek gapuh idan helag mu. ");
INSERT INTO ify_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mukun henin nunman hu pehding kulli ey tep inu-unnud Abraham ni emin hu tugun ku.” ");
INSERT INTO ify_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Et yadman law di Gerar hu nambebleyan di Isaac. ");
INSERT INTO ify_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Hedin minahmahan idan tuu meippanggep nan Rebekah, kan Isaac ey han-agidda. Kaumtakut ni menghel ni han-ahwadda tep entanniy petteyen da ma-lat piliwen da hi Rebekah tep kat-agun peteg. ");
INSERT INTO ify_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nem entanni ey inuhdungan Abimelek di habhabyen ni baley tu hi Isaac e tuka ak-akwala hi Rebekah. ");
INSERT INTO ify_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Et paeyag Abimelek hi Isaac et kantuy “Tam ahwam gayam hi Rebekah. Kele kammuy hi agim?” Et kan Isaac ey “Tep kangkuy entanni ey wada memettey ni hi-gak ma-lat piliwen da hi Rebekah.” ");
INSERT INTO ify_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kan Abimelek ey “Hipa huyyan impahding mun hi-gami? Gullat ni wada hu lakidyan nengiulig nan Rebekah, hi-gam et dedan hu umhulun ni pambehhulan mi.” ");
INSERT INTO ify_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Et peamta tuddan tuu tu e hedin wada mengippahding ni lawah di Isaac nan Rebekah, man pepettey tu. ");
INSERT INTO ify_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yan nunman ni toon ni nanleyakan hi Isaac ey dakel ni peteg hu ineni tu tep binendisyonan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Et kumedangyan hi Isaac, ey tagan tu pay hu kedangyan. ");
INSERT INTO ify_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Hantapug hu kalneroh tu, yadda baka niyadda bega-en tu. Et humman hu, kakeemmehiddan iPilistia. ");
INSERT INTO ify_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Et da tababen ni emin hu hibuy ni impeku-ku lan ametu e hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Lektattuy kan Abimelek nan Isaac ey “A-allaw ka eyad bebley mi tep ay nambalin kumedek ni e-etteng ni peteg hu kabaelan mu nem hi-gami.” ");
INSERT INTO ify_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Et ma-kal di Isaac diman et ida mambebley di Nedeklan e Gerar. ");
INSERT INTO ify_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Et peku-ku mewan nan Isaac ni emin hu hibuy ni impeku-ku lan ametu. Humman idan hibuy ey sinebab idan iPilistia ni neteyyan ametu. Impannaneng tu hu impangngadan lan ametuddan nunman idan hibuy. ");
INSERT INTO ify_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Et kumu-kudda mewan etan bega-en Isaac ni hibuy ey pintek da wada hu danum tu. ");
INSERT INTO ify_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nem immalidda kamampattul ni iGerar et ida kamekittuttut idan bega-en nan Isaac e kanday danum da kunu humman. Et ingadnan Isaac humman ni hibuy ni ‘Kapantututusi.’ ");
INSERT INTO ify_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nengu-kudda mewan etan bega-en Isaac di a-allaw tu ey hanniman mewan e nambabakalan da et ingadnan tun hibuy ni ‘Kapambabakali.’ ");
INSERT INTO ify_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hini-yan da humman et mampeku-ku mewan hi Isaac ni hakey ni hibuy ey eleg law pilliwaddan bimmebley. Et ingadnan tu humman ni hibuy ni Rehobot, e ya keibbellinan tu ey ‘Hibuy ni wada linggep.’ Tep kan Isaac ey “In-abulut Apu Dios ni manha-ad itsudya et yumaggud ali hu biyag tayu.” ");
INSERT INTO ify_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Entanni ey nan-aldan di Isaac di Beersheba. ");
INSERT INTO ify_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yan nunman ni hileng ni dinatngan da, ey nampeang-ang hi Apu Dios nan Isaac et kantuy “Hi-gak hu Dios amam e hi Abraham. Entan takut mu tep ippaptek daka et bendisyonan daka et idawtan dakan dakel ni helag mu tep huyya insapatah ku lan bega-en ku e hi Abraham.” ");
INSERT INTO ify_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Et mengapya hi Isaac ni pan-appitan et dayawen tu hi Apu Dios. Et mangkampu idadman et mengu-kudda etan bega-en tun hibuy. ");
INSERT INTO ify_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hakey ni aggew ey dimmateng hi Abimelek e patul, hi Ahussat e konsihal tu et hi Picol e ap-apun sindalu tun nalpud Gerar. ");
INSERT INTO ify_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kan Isaac ni hi-gaday “Kele kayu immali ey yan nunman ey anggebe-hel yuwak et degyunen yuwak?” ");
INSERT INTO ify_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kanday “Immali kami tep inamta mi law e daka kapakabbaddangin Apu Dios. Et humman hu, pinhed min mekitbal ni hi-gam ma-lat mandadagyum itsu. ");
INSERT INTO ify_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ihuhummangan tayu e endi mu pehding ni hi-gamin lawah, henin impahding min hi-gam ni neni-yanam ni hi-gami e endi mi impahding ni lawah. Et deh e binendisyonan dakan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Et mampedaddan hi Isaac ni kennen da et mangan ida niya nengi-innum ida. ");
INSERT INTO ify_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yan newa-waan tun binengunan da, ey nansapatah ida e endi da ippahding ni lawah di hanhakkey ni hi-gada. Negibbuh humman et umenamut di Abimelek e melinggep ida tep nanggagayyum ida law. ");
INSERT INTO ify_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Yan nunman ni aggew, ey immanemut ida bega-en nan Isaac et ehlen da e wada danum etan di hibuy ni kinu-kuan da. ");
INSERT INTO ify_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Et ingadnan Isaac humman ni hibuy ni Sibah e ya keibbellinan tu ey nansapatahan. Et humman hu, nengal-an dan nunman ni ngadan ni Beersheba. ");
INSERT INTO ify_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Yan na-pat hu toon nan Esau, ey inahwa tu dewwan biin Hittite e hi Judith e u-ungngan Beeri et hi Basemat e u-ungngan Elon. ");
INSERT INTO ify_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nem huyyaddan ahwan Esau ey daka pedgeh hu nemnem di Isaac nan Rebekah. ");
INSERT INTO ify_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yan nea-ammaan nan Isaac e eleg tu law han-ang-ang ey impaeyag tu hi Esau e pengulwan ni u-ungnga tu. Immali hi Esau et kantuy “Kela e ama?” ");
INSERT INTO ify_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kan Isaac ey “Deh e nea-amma-ak law et endilli maptek ey metteyyak. ");
INSERT INTO ify_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Alam etan panam et ka mandeweng. ");
INSERT INTO ify_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pinhed ku etan muka pene-eng ni mepelhat. Iheeng mu et i-lim et hedin negibbuhhak ni nengan ey e-helen ku hu bendisyon kun hi-gam et hannak matey.” ");
INSERT INTO ify_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nem dingngel Rebekah humman ni inhel nan Isaac nan hi Esau. Et yan linawwan Esau ni an mandedweng ey ");
INSERT INTO ify_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","kan Rebekah nan Jacob ey “Dingngel ku inhel amam nan agim e hi Esau e an mandedweng ni pehidda tun hi-gatu. Et hedin negibbuh ni nengan ey bendisyonan tud hinanggan Apu Dios et han matey. ");
INSERT INTO ify_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Et humman hu, u-unnud mu eya e-helen kun hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pengin-eellaw kallid halun tayu et ka umlan dewwan mateban impah ni gelding et iheeng kun pinpinhed amam ni pene-eng. ");
INSERT INTO ify_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Illaw mun hi-gatu et hedin nengan, ey hi-gam hu bendisyonan tu et han matey.” ");
INSERT INTO ify_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nem kan Jacob nan inetuy “Nem tam nakabwekan hu annel Esau ey malinah ngu belat ku. ");
INSERT INTO ify_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Inna-nu hedin keppaen tuwak et amtaen tu e bekennak hi Esau? Penghel tuy nakka he-uhe-ula et hamban tuwak kabendisyoni ey iddutan da-ak kumedek.” ");
INSERT INTO ify_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kan inetuy “Hedin amtaen tu, anin ew ni hi-gak hu keillawan ni idut tu. Elaw ka kuma et kalli umlan gelding.” ");
INSERT INTO ify_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Et u-unnuden nan Jacob hu inhel nan inetu et an ali umlan dewwan impah ni gelding et iheeng inetu etan ni pinpinhed nan ametun kapene-eng. ");
INSERT INTO ify_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Inlan inetu hu kekakkayyaggudan ni intatalu tun balwasin Esau et pebalwasi tun Jacob. ");
INSERT INTO ify_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Et ikapyaan tun nedutdutan ni belat ni gelding ni ihhuklub tud ngamay tu, anin di tengda tu. ");
INSERT INTO ify_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Et idwat tun Jacob etan meheng-ew ni ihhida niya sinapay ni kinapya tu. ");
INSERT INTO ify_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Inlaw Jacob nan ametu et kantuy “Ama.” Kan ametuy “Uh, hipa ka? Kaw hi-gam hi Esau winu hi Jacob?” ");
INSERT INTO ify_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kan Jacob ey “Hi-gak hi Esau e pengulwan ni u-ungngam. Inu-unnud ku hu kammu. Bangun ka et mangan ka et bendisyonan muwak.” ");
INSERT INTO ify_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kan Isaac ey “Kele kuma anggagannuy wada dinweng mu e u-ungngak?” Kan Jacob ey “Tep binaddangan tuwak nan Apu Dios e muka deyyawa.” ");
INSERT INTO ify_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ey kan Isaac ey “Ikay dih et kap-en daka hedin makulug ni hi-gam hi Esau.” ");
INSERT INTO ify_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Et meihnup hi Jacob et kap-en nan ametu ey kantuy “Ehel nan Jacob eya ehel mu, nem ngamay nan Esau eya ngamay mu.” ");
INSERT INTO ify_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Eleg tu immatunan hi Jacob tep nakabwekan ngamay tu e henin ngamay Esau. Et bendisyonan tu, ");
INSERT INTO ify_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nem impidwa tun imbaga e kantuy “Kaw makulug ni hi-gam hi Esau?” Kan Jacob ey “Em, hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kan ametuy “I-lim etan dinweng mu et ihidak et han daka bendisyoni.” Indawat Jacob etan kennen et mangan hi ametu. Et idwatan tun innumen tu. ");
INSERT INTO ify_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kan ametu hi Isaac ni hi-gatuy “Keihnup ka et akwalen muwak e u-ungngak.” ");
INSERT INTO ify_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Inakwal Jacob hi ametu ey hinemuy nan ametu etan imbalwasi tu et bendisyonan tu. Kantuy “Ya hamuy ni u-ungngak ey heni hamuy ni payew ni binendisyonan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Peellin Apu Dios ali udan di payew mu niya peyaggud tu iggaud mu ma-lat dakel ali ennien mu niya dakel ali innumem. ");
INSERT INTO ify_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pambega-en muddalli tuud kebebbebley niya hi-gam ali tengngawen dan ap-apu da. Anin idallin agim ni u-ungan inam et hi-gam hu pan-ap-apu da. Meiddutan idalli hu mengiddut ni hi-gam niya mebendisyonan ida memendisyon ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Negibbuh humman et umhep hi Jacob ey dimmateng hi Esau ni an nandeweng. ");
INSERT INTO ify_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Indaddan tu dama hu pinpinhed nan ametun ihhida et ilaw tud kad-an tu et kantuy “Ama, bangun ka et mangan ka et ihidam eya inhaeng ku et han muwak bendisyoni.” ");
INSERT INTO ify_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kan Isaac ey “Kaw hipa ka?” Kan Esau ey “Tam hi-gak hi Esau e pengulwan ni u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Dingngel Isaac humman ey kamanggegeygey. Kantuy “Hipattep la etan nengi-lin detag ni kinan kun nuntan et han ka umli? Hi-gatu kumedek hu binendisyonan ku. Humman man ahan ni bendisyon ey eleg mabalin ni an bangngaden.” ");
INSERT INTO ify_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Inhel nan ametu humman ey kamantete-ul hi Esau e kantuy “Ama, anin anhan nem bendisyoni muwak dama.” ");
INSERT INTO ify_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nem kan ametuy “Immali la hi agim et haulen tuwak et piliwen tu bendisyon mu.” ");
INSERT INTO ify_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kan Esau ey “Huyya pidwa tun nenaulan tuwak ni hi-gatu. Ambuley hi Jacob hu ngadan tu. Yan laputu, ey illa tu kelebbengan kun pengulwan. Et ya man nunya ey piniliw tu bendisyon ku. Kaw endi law ni hekey hu ibbendisyon mun hi-gak?” ");
INSERT INTO ify_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kan ametuy “Endi law nak pehding tep ay impambalin kun hi-gatu hu pan-ap-apu yu. Emin kayun han-aaggi ey impambalin kun pambega-en dakeyun hi-gatu. Binendisyonan kun dakel ni kennen niya meinnum. Et humman hu, endi law hu iddawat kun hi-gam e u-ungngak.” ");
INSERT INTO ify_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nem kamampehemmehemmek hi Esau e kantuy “Kaw ebuh humman ni bendisyon mu? Bendisyoni muwak anhan dama.” Ey nemahhig mewan hu nangih tu. ");
INSERT INTO ify_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Et kan ametuy “Neligat ali pambiyagam tep ya puyek ni panha-adam ey beken ni kayyaggud ni pantennemam niya endilli udan di panha-adam. ");
INSERT INTO ify_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Et humman hu, ya apputen mud pekiggubbatan mu hu pengellaam ni biyag mu. Mambalin kan bega-en nan agim, nem ngenghayen mulli ma-lat eleg ka mannananeng ni bega-en tu.” ");
INSERT INTO ify_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Et meippalpun nunman ey anggebe-hel law nan Esau hi Jacob tep piniliw tu hu bendisyon tu. Kantud nemnem tuy “Petteyek ali hi Jacob hedin mettey hi ama.” ");
INSERT INTO ify_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Dingngel Rebekah humman ni planuh Esau et paeyag tu hi Jacob et kantun hi-gatuy “Deh e pinhed dakan petteyen nan agim hi Esau ma-lat ibleh tu impahding mu. ");
INSERT INTO ify_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Et humman hu, dengel mu eya e-helen kun pehding mu. Besik kad Haran di kad-an nan pengemmaan mu e hi Laban. ");
INSERT INTO ify_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Et yadman ni panha-adan mu ingganah me-kal hu bunget nan agim. ");
INSERT INTO ify_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Et hannak ali umitu-dak ni mengeyyag ni hi-gam hedin liwwanen tu hu impahding mu. Tep eggak pinhed ni kayu mampettey et mandihhan kayun mettey ni hakey ni aggew.” ");
INSERT INTO ify_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hakey ni aggew ey kan Rebekah nan Isaac ey “Impeinglay ku eyadda Hittite ni ahwan Esau. Heballi ew metteyyak hedin mengahwa dama hi Jacob ni biin Hittite.” ");
INSERT INTO ify_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Et paeyag nan Isaac hi Jacob et bendisyonan tu et kantun hi-gatuy “Entan pengahwan biidya. ");
INSERT INTO ify_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lakkay di Paddan Aram di Mesopotamia di baley apum e hi Bethuel et ahwaen mu etan hakey ni u-ungngan pengemmaam e hi Laban. ");
INSERT INTO ify_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bendisyonan daka kaya nan Apu Dios e Kabaelan tun emin ey iddawtan dakallin dakel ni helag mu et hi-gam ali pan-ammed ni dakel ni tuu. ");
INSERT INTO ify_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bendisyonan dakan Apu Dios niyadda helag mun henin nemendisyonan tun apum e hi Abraham. Ey hi-gayulli kampuyek eyan indawat Apu Dios nan Abraham ni nekibebleyan tayu.” ");
INSERT INTO ify_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Et itu-dak nan Isaac hi Jacob di Paddan Aram di Mesopotamia di baley nan hi pengemmaan tu e hi Laban e agin inetu e u-ungngan Bethuel e iAramea. ");
INSERT INTO ify_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","8","Neamtaan nan Esau e binendisyonan ametu hi Jacob et han tu palaw di Mesopotamia ma-lat yadman hu pengahwaan tu et beken hu iKanaan ni i-ahwa tu. Niya inamta tu e inu-unnud Jacob di ametun inetu et lumaw di Mesopotamia. Et awatan tu law e eleg pinhed ametu hu bibi-in iKanaan. ");
INSERT INTO ify_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Et lumaw hi Esau di bebley nan pengemmaan tu e hi Ismael et ahwaen tu hi Mahalat e agin Nebayot e u-ungngan Ismael e u-ungngan Abraham. ");
INSERT INTO ify_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hi Jacob ey hini-yan tu hu Beersheba et lumaw di Haran. ");
INSERT INTO ify_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nehilngan di dalan et mangkampu. Et umlan batun pengi-ippingan tu et maugip. ");
INSERT INTO ify_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Entannit neuyeng ey ini-innep tu e wada teytey ni dinteng tu kabunyan. Ey inang-ang tudda anghel nan Apu Dios e nanteyed ida ni nandayyudda etan di teytey. ");
INSERT INTO ify_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ey wada hi Apu Dios e immehneng di ta-pew ni teytey e kantuy “Hi-gak hu Ap-Apu e Dios ni dinaydayaw nan apum e hi Abraham ni hi amam e hi Isaac. Iddawat kun hi-gam et yadda helag mu eya puyek ni muka pambakbaktadi. ");
INSERT INTO ify_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dakel ali helag mu e heniddalli dep-ul e eleg mebillang et meihhinnap idallid kebebbebley di puyek. Ey emin ali tuud kebebbebley di puyek ey bendisyonan kudda gapun hi-gam niyadda helag mu. ");
INSERT INTO ify_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ey emin di lawwan mu ey wada-ak ni mengippaptek ni hi-gam niya hi-gak hu ngenamung ni mengibbangngad ni hi-gam eyad bebley. Eleg daka e-waya, nem peamnuk emin eya impakulug kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Bimmangun hi Jacob ey simmakut et kantuy “Tam wada gayam hi Apu Dios di deya ey eleg ku amta! Anggetakkut di deya! Huyya na-mu hu baley Apu Dios e habyen ni umlaw di kabunyan.” ");
INSERT INTO ify_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bimmangun ni dagah ni newa-waan tu et alen tu batun impungan tu et peehneng tu et penginnemneman tun Apu Dios et duyagan tun lana. ");
INSERT INTO ify_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ingngadnan tu humman ni Bethel, nem ya ngadan tu dedan ni nunman ey Lus. ");
INSERT INTO ify_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Et isapatah Jacob e kantuy “Apu Dios, hedin itultuluy mun mekikkillalw ni hi-gak di lawwan ku niya ippaptek muwak et idwat mun emin hu kahapulan ku, henin kennen niya balwasik, ");
INSERT INTO ify_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","et kayyaggud hu pambangngadak di baley ama, man hi-gam e Ap-Apu hu deyyawen kun Dios ku. ");
INSERT INTO ify_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ey mambalin eya nengipeehnengan kun batun pandeyyawan ni hi-gam. Niya emin ali hu iddawat mun hi-gak ey pebangngad kun hi-gam hu kapulu tu.” ");
INSERT INTO ify_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Et mangmanglaw hi Jacob ey dimmateng di bebley di appit ni kasimmilin aggew ");
INSERT INTO ify_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Entanni ey inang-ang tu hu hibuy di pattullan. Wadaddadman hu nantelu-an ni neamung ni kalneroh ni kamanluklukbub di nanlinikweh di hibuy tep yadman daka innumi. Nem immen hu et-eteng ni batun neihu-let etan di hibuy. ");
INSERT INTO ify_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hedin neamung idan emin kalneroh ey han ginlid idan kamampattul etan batu ma-lat uminum ida. Hedin negibbuh ni imminum ida, impebangngad da mewan etan batu. ");
INSERT INTO ify_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Hinnup nan Jacob ida etan kamampattul ni kalneroh et kantun hi-gaday “Hi-gayuddan agik, attu bebley yu?” Kanday “Yad Haran.” ");
INSERT INTO ify_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kan Jacob ey “Kaw inamta yu hi Laban e u-ungngan Nahor?” Ey kanday “Tam em.” ");
INSERT INTO ify_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kan Jacob ey “Inna-nun biyag tu?” Kanday “Kayyaggud. Mundeh ali hi Rachel e u-ungnga tu e impangulu tu hu kalneroh ametu.” ");
INSERT INTO ify_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kan Jacob ey “Kele eleg yudda peinnumi eya kalneroh et yu pay ipattul ida haggud ba-ba ni kehillengan tu?” ");
INSERT INTO ify_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kanday “Eleg mi ni peinnumidda ingganah ni wadaddan emin hu kalneroh di deya et han mi gelida eya batun neihu-let di hibuy et painuman middan emin.” ");
INSERT INTO ify_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ida kaum-enungbal ey nandammuan tun dimmateng hi Rachel niyadda etan tuka ippattul ni kalneroh ametu. ");
INSERT INTO ify_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Inang-ang Jacob hi Rachel e u-ungngan pengemmaan tu niyadda etan kalneroh ametu ey limmaw et tu ekalen etan batun neihu-let di hibuy et painuman tudda etan kalneroh nan pengemmaan tu. ");
INSERT INTO ify_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Et kan tun Rachel ey “Hi-gak hu u-ungngan Rebekah e agin amam.” Et akwalen tu hi Rachel ey kamannengngih ni amleng tu. Et mambesik hi Rachel di baley da et tu ehlen nan ametu. ");
INSERT INTO ify_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dingngel Laban e wada etan pengungngaan tu ey impapuut tu et tu dammuen. Inakwal tu et ikuyug tud baley da. Et e-ehhelen nan Jacob emin hu neipahding. ");
INSERT INTO ify_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kan Laban ey “Makulug ni han-ama ita.” Nekiha-ad hi Jacob ni hambulan diman ");
INSERT INTO ify_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","et hakey ni aggew ey kan Laban ni hi-gatuy “Ambeken ni gapu tep pengungngaan daka ey eleg daka tangdani. Piga pinhed mun penangdan kun hi-gam?” ");
INSERT INTO ify_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hi Laban ey wada dewwan u-ungnga tun bii, hi Leah hu pengulwan ey hi Rachel hu neihned. ");
INSERT INTO ify_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Kakkayyaggud hu matan Leah, nem hi Rachel ey kakkayyaggud hu impenga-annel tu niya kat-agun peteg. ");
INSERT INTO ify_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Hi Jacob ey pinpinhed tu hi Rachel. Et humman hu, kantun Laban ey “Ingngunwan dakan pitun toon hedin i-abulut mun ahwaen ku hi Rachel.” ");
INSERT INTO ify_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kan Laban ey “Dammutu. Heballi hi-gam hu mengi-ahwan hi-gatu nem ya edum ni beken ni nalpud pewen tayu. Et humman hu, kayyaggud hedin di deya itsu.” ");
INSERT INTO ify_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Et mangngunun pitun toon hi Jacob ma-lat iahwa tu hi Rachel. Nem heni pigan aggew ni ebuh ni hi-gatu tep nakappinhed tu hi Rachel. ");
INSERT INTO ify_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Negibbuh humman ni pitun toon et kan Jacob nan Laban ey “Ahwaen ku law hi Rachel haggud negibbuh law hu insapatah kun toon ni pangngunnuan kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Et mandaddan hi Laban et aygan tudda tutu-u et manhahamul idan pan-ahwaan di Jacob nan Rachel. ");
INSERT INTO ify_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nem yan nunman ni hileng ey hi Leah kumedek hu impeahwan Laban ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Wada indawat nan Laban nan hi Leah ni hakey ni biin pambega-en tu e hi Silpah hu ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yan newa-waan tu ey inimmatunan nan Jacob e hi Leah hu nekiulig tu et kantun Laban ey “Hipa huyyan mu impahding ni hi-gak! Ingngunwan dakan pitun toon ma-lat ahwaen ku hi Rachel, ey kele muwak hineul?” ");
INSERT INTO ify_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ey kan Laban ey “Tep ya elaw mi ey beken ni ya udidyan hu memengngulun mengahwa. ");
INSERT INTO ify_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nem anin, heged mu hanlingguan eyan nan-ahwaan yu et dammutun i-ahwam hi Rachel. Nem mahapul ni ingngunwan muwak pay ni pitun toon.” ");
INSERT INTO ify_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Inebulut Jacob et malebah humman ni hanlingguan et han peahwan Laban hi Rachel ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Et idwat daman Laban hu hakey ni pambega-en nan Rachel e hi Bilhah hu ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Et iulig nan Jacob hi Rachel ey pinpinhed tu nem hi Leah. Et ingunwan tu pay hi Laban ni pitun toon. ");
INSERT INTO ify_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yan nenang-angan Apu Dios e pinpinhed nan Jacob hi Rachel nem hi Leah ey in-abulut tun mambutsug hi Leah. Nem eleg tu iebulut ni mewedda u-ungngan Rachel. ");
INSERT INTO ify_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Et man-ungnga hi Leah ey laki. Et kantuy “Inang-ang Apu Dios hu degeh ni nemnem ku, et yan nunya ey pinheden tuwak law ni ahwak.” Et ngadnan tu etan u-ungnga tun hi Reuben. ");
INSERT INTO ify_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Entanni ey nambutsug mewan et man-ungnga ey laki mewan. Et kantuy “Inamtan Apu Dios e eleg tuwak pinhed ni ahwak et idwatan tuwak ni hakey mewan ni u-ungngak.” Et ingadnan tun hi Simeon. ");
INSERT INTO ify_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nambutsug mewan et man-ungnga ey laki mewan. Et kantuy “Wada-et ni pekappinheden tuwak law ni ahwak tep ay tellu law u-ungnga min laki.” Et ingadnan tun hi Levi. ");
INSERT INTO ify_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nambutsug mewan et man-ungnga ey laki mewan. Kantuy “Deyyawen ku law hi Apu Dios.” Et ngadanan tun Judah. Ey eleg law man-ungnga. ");
INSERT INTO ify_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nem hi Rachel ey endi ngu u-ungnga tu. Et humman hu, kaum-ameh nan hi agitu hi Leah. Kantun Jacob ey “Idwasi muwak daman u-ungngak tep hedin endi, man heballi ew mettey yak.” ");
INSERT INTO ify_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Bimmunget hi Jacob et kantuy “Kaw hi-gak hi Apu Dios? Hi-gatun ebuh hu dammutun mengi-ebbulut ni mewedda u-ungngam, beken nak.” ");
INSERT INTO ify_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Et kan Rachel nan Jacob ey “Anin iulig mu ew eya bega-en kun hi Bilhah ma-lat hedin wada u-ungnga yu, ey meibillang ni u-ungnga ta.” ");
INSERT INTO ify_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Inebulut Jacob et iulig tu hi Bilhah. ");
INSERT INTO ify_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nambutsug hi Bilhah et man-ungnga ey laki. ");
INSERT INTO ify_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ingngadnan Rachel ni hi Dan tep kantuy “Impeang-ang Apu Dios e hi-gak hu lebbeng tun kan ahwan nan hi Jacob. Et humman hu, dingngel tu hu dasal kun hi-gatu et idwat tu huyyan u-ungngak ni laki.” ");
INSERT INTO ify_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","8","Entanni ey nambutsug mewan hi Bilhah et man-ungnga ey laki mewan. Et ngadanan Rachel ni Naptali, tep kantuy “Impenatnan agik ni pilliwen hu ahwak, nem inapput ku.” ");
INSERT INTO ify_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Inamtan Leah e eleg law man-ungnga et iebulut tu hi Silpah e bega-en tun i-ulig Jacob. ");
INSERT INTO ify_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nambutsug hi Silpah et man-ungnga ey laki. ");
INSERT INTO ify_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Et ngadanan Leah ni Gad, tep kantuy “Negahat tak tep wada mewan hakey ni u-ungngak.” ");
INSERT INTO ify_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nan-ungnga mewan hi Silpah ey laki mewan. ");
INSERT INTO ify_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Et ngadanan Leah ni Asher tep kantuy “Nakka man-am-amleng ni peteg! E-helen idallin edum ni bii e nakka man-am-amleng.” ");
INSERT INTO ify_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Hakey ni aggew ni ahiani ey wada himmak nan Reuben di payew ni mandrake e kameitnem et ienamut tun inetu hi Leah. Kan Rachel nan Leah ey “Idwasi muwak anhan eyan in-anemut ni u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nem kan Leah ey “Deh dedangngu e piniliw mu ahwak, ey mu mewan pilliwen eya himmak ni u-ungngak?” Nem kan Rachel ey “Idwasi muwak et hi-gam hu meki-ullig nan ahwak ni hileng.” ");
INSERT INTO ify_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yan mahmahdem ni nunman e iyalli hi Jacob ni nalpud payew ey an dinammun Leah et kantuy “Man-ullig itan hileng tep binaydan dakan mandrake ni himmak ni u-ungngak.” Et man-ulig idan nunman ni hileng. ");
INSERT INTO ify_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ey dingngel nan Apu Dios hu dasal Leah et mambutsug et man-ungngan laki et humman hu meikkelliman u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Et ngadanan Leah ni Issakar tep kantuy “Huyyan u-ungnga hu gungunah kun indawat Apu Dios tep in-abulut ku bega-en kun i-ulig ni ahwak.” ");
INSERT INTO ify_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Entanni mewan ey nambutsug hi Leah et man-ungnga ey laki et humman hu meikka-nem. ");
INSERT INTO ify_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Et ngadanan Leah ni Sebulun tep kantuy “Bendisyonan tuwak nan Apu Dios. Wadan pinheden tuwak law ni ahwak, tep enem hu u-ungnga min laki.” ");
INSERT INTO ify_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Entanni ey nambutsug mewan et man-ungnga ey bii et ngadanan tun hi Dinah. ");
INSERT INTO ify_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Entanni ey ninemnem nan Apu Dios hi Rachel et iebulut tun meweddaan ni u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nambutsug et man-ungnga ey laki. Kantuy “Kayyaggud anhan et indawtan tuwak Apu Dios ni u-ungngak et eleg da-ak law pipihulladan tuu.” ");
INSERT INTO ify_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Et ngadanan tun Joseph tep kantuy “Hamban anhan iddawtan tuwak pay nan Apu Dios ni hakey ni u-ungngak ni laki ey.” ");
INSERT INTO ify_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yan eman ni neiungngaan nan Joseph ey kan Jacob nan Laban ey “Iebulut mu et mambangngad dak law di bebley mi. ");
INSERT INTO ify_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ey iebulut mu et ikuyug kudda eya ahwak niyadda eya u-ungngak haggud deh e nakatteklak ida. Ey inamtam et nemahhig hu impangngunuk ni impangunum ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kan Laban ni hi-gatuy “Entan tuwak hi-yan tep kan etan ni madiba ey indawtan tuwak nan Apu Dios ni panyaggudak gapun hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ehel mun hi-gak hedin piga pinhed mun tangdan mu et humman iddawat ku.” ");
INSERT INTO ify_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kan Jacob ey “Inamtam hu impahding kun nengingunungunun impangunum ni hi-gak ni pigan toon, et deh e dimmakkel hu halun mu tep impenaptek ku. ");
INSERT INTO ify_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tep makulug ni hahhakkey la hu halun mun inlian ku. Nem yan nunya ey dimmakkel law ni peteg. Binendisyonan dakan Apu Dios gapuh ni hi-gak. Et yan nunya ey mahapul ni ya pamilyah ku dama law hu hengnguden ku.” ");
INSERT INTO ify_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Kan Laban ey “Hipa nisi pinhed mun ittangdan kun hi-gam?” Hinumang nan Jacob e kantuy “Eggak pinhed ni tangdanan muwak. Ittuluy kun mengippaptek ni halun mu hedin ebbuluten mu eya e-helen ku. Iebulut mu et nak appilen ni emin etan nangkebatekan ni kalneroh niya gelding niyadda andeket ni impah ni kalneroh mu et anin humman hu tangdan ku. ");
INSERT INTO ify_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Et edum alin aggew ey meang-ang e endi nak piniliw ni animal mu. Et hedin wadalli hu hemmaken mun kalneroh niya gelding ni beken ni nebalitan niya beken ni andeket ni impah ni kalneroh di halun ku, ey amtam e sinekew ku humman ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kan Laban ey “Dammutu, ebbuluten ku huttan ni kammu.” ");
INSERT INTO ify_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nem yan nunman ni aggew ey limmaw hi Laban et tu appilen ida etan nangkebatekan ni kalneroh niya gelding niyadda andeket ni impah ni kalneroh et pepaptek tuddan u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Et ilaw tuddad neidawwi e nandalan ni tellun aggew. Et yadda natdaan hu impepaptek Laban nan Jacob. ");
INSERT INTO ify_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nem ya impahding Jacob ey immalan pangan nambakbaklang ni keyew et wihwihan tu hanna-kut ni ukih da ma-lat meang-ang hu mablah. ");
INSERT INTO ify_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Et tu pan-iha-ad e inhangga tu etan di innumman idan gelding niya kalneroh ma-lat hedin um-aliddan um-inum e yan nunman hu daka pan-in-eenduli ey ang-angen da humman ni tu inha-ad. ");
INSERT INTO ify_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Et hedin man-impah ida ey nangkebalitan niya nangkebatekan hu i-impah da. ");
INSERT INTO ify_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Beken ni ebuh humman ni impahding Jacob, nem inappil tudda labah ni halun nan Laban. Et peendul tuddad andeket ni lakkitud halun tu. Henin nunya nedakkelan ni halun Jacob, nem eleg ma-duman hu halun Laban. ");
INSERT INTO ify_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Hedin ida kaman-in-eendul etan ida animal ni endi degeh tu, ey kapehanggan Jacob etan winihwihan tuddan keyew di hinangngab etan di innumman da. ");
INSERT INTO ify_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nem eleg tu ippahding humman etan di nangkepigut. Et lektattuy kakkayyaggud ni emin hu halun tu e endi degeh da. Nem hedin yadda halun Laban ey nangkepigut ida. ");
INSERT INTO ify_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Et ya nambalinan tu ey kimmedangyan hi Jacob. Dakel hu halun tu, ya bega-en tu, ya kamel tu niya kebayyu tu. ");
INSERT INTO ify_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Dingngel Jacob e ida kamanlillih ida etan u-ungngan Laban e kanday “Illan Jacob ni emin hu kinedangyan ametayu et deh e kimmedangyan.” ");
INSERT INTO ify_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Anin ni hi Laban et wada kaiggibek nan Jacob ni el-eleg ni tuka pehding ni hi-gatu e beken ni heni lan nunman. ");
INSERT INTO ify_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Entanni ey inhel Apu Dios nan hi Jacob e kantuy “Pambangngad kad bebley ni aammed mu niyadda aaggim haggud wada-ak ni mengippaptek ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Entanni ey impaeyag Jacob di Leah nan Rachel di pattullan tun kalneroh ");
INSERT INTO ify_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","et kantun hi-gaday “Nakka giggibbeka ey el-eleg law hu kapeang-ang-ang ameyun hi-gak, beken ni heni lan nunman hu tuka pengapngan hi-gak, nem nanengtun kaumbaddang ni hi-gak hi Apu Dios e kadeyyawan ama. ");
INSERT INTO ify_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inamta yu hu ligat kun nengingungngunnuan kun ameyu. ");
INSERT INTO ify_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nem kapyatun linugilugih tuwak e nampinhampulu hu nenullulan tun hummangan min tangdan ku. Nem kayyaggud et eleg iebulut nan Apu Dios ni wada tu pehding ni hi-gak ni lawah. ");
INSERT INTO ify_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","9","Heni hi Apu Dios hu nengi-tan ni halun ameyun hi-gak. Tep hedin kan ameyuy ya nangkebatekan ni gelding niya kalneroh hu iddawat tun tangdan ku, man nangkebatekan hu impah da. Hedin mewan kantuy ya nangkegalitan hu iddawat tun tangdan ku, man nangkegalitan hu impah ida. ");
INSERT INTO ify_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yan eman ni kapengenduliddan etan ni gelding ey ini-innep ku e nangkegalitan niya nangkebatekan idan emin etan lakkitun gelding ni kamengendul. ");
INSERT INTO ify_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ini-innep ku e immehel etan anghel Apu Dios ni hi-gak e kantuy ‘Jacob!’ Et kangkuy ‘Kela e Apu?’ ");
INSERT INTO ify_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kan etan ni anghel ey ‘Ang-ang mu kedi, emin ida eman lakkitun kamengendul ey nangkegalitan niya nangkebatekan edum. Hi-gak kamengippahding ni nunya tep inang-ang kun emin hu impahpahding nan Laban ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Hi-gak hu Dios ni nampeang-ang ni hi-gam di Bethel etan di nengiha-adam ni batun dinuyagam mun lanan penginemnemneman mun hi-gak et mansapatah kan hi-gak. Pandaddan ka et mambangngad kad bebley ni neiungngaan mu.’” ");
INSERT INTO ify_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Himmumang di Leah nan Rachel ey kanday “Anin haggud endi damengu beltanen min kinedangyan nan amemi ");
INSERT INTO ify_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","tep ya tuka pehding ni hi-gami ey heni kami hansinu-wan. Inggatang dakemi et umahen tun emin hu nanggatngan tu. ");
INSERT INTO ify_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Emin hu kinedangyan amemin heni inlan Apu Dios et idwat tun hi-gam ey hi-gatsuddan emin eyan u-ungnga hu lebbengtun keidwatan tu. Et humman hu, u-unnud mu etan inhel Apu Dios ni pehding mu.” ");
INSERT INTO ify_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","21","Et hakey ni aggew e limmaw hi Laban ni an memu-lit ni dutdut ni kalneroh tu, ey indaddan nan Jacob ni emin hu mahapul dan pambangngadan dad Kanaan e bebley ametu. Nan-itakkay tudda u-ungnga tu niyadda etan ahwatud kamel, et delunen dadda animal da et manglaw ida e impeki-la dan emin hu wadan hi-gadan limmu dan nanha-adan dad Paddan Aram di Mesopotamia. Et gapu tep endi hi ameda ey imbesik nan Rachel hu tuttu-un ametu. Yan nunman ni linawwan da ey eleg peamtan Jacob nan Laban. Impapuut dan limmaw et man-agwat idad Wangwang e Euphrates et mampalaw idad nangkedunduntug di Gilead. ");
INSERT INTO ify_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nelabah tellun aggew ey wada nengipeamtan Laban e bimmesik di Jacob. ");
INSERT INTO ify_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","25","Et ikuyug Laban ida tutu-u tu et mangunud ida. Et yan meikkeppitun aggew ey hina-kup daddad nangkedunduntug di Gilead ni nangkampuan da. Yan nunman ni hileng ey ini-innep nan Laban e kan Apu Dios ni hi-gatuy “Ang-ang mu kuma ma-lat endi lawah ni e-helen mun Jacob.” ");
INSERT INTO ify_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Et lumaw hi Laban di kad-an Jacob et kantuy “Kele heni balud di gubat ida eya u-ungngak e mudda imbesik? Hineul muwak. ");
INSERT INTO ify_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kele eleg mu e-ehhelen ey kayu nengali? Gullat et ni impeamtam, ey nandaddan nak ni pan-an-anlaan tayu et han kayu umgah di lawwan yu. ");
INSERT INTO ify_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Eggak ew anhan akwalen ida eya inap-apuk niyadda eya u-ungngak ey kayu nengali. Beken ni kayyaggud huyyan impahding mu. ");
INSERT INTO ify_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Gullat ni pinhed kun pehding ni hi-gam hu lawah et dammutu. Nem nampeang-ang ni hi-gak etan Dios ni kadeyyawan amam et ehelen tu e hellipat-an ku ma-lat endi nak e-helen ni hi-gam ni lawah. ");
INSERT INTO ify_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Inamtak e ya gaputun neala et hi-yanen yuwak ey tep kaka um-abtun mambangngad di bebley amam. Nem anin et, kele yu impeki-ladda etan dios ku?” ");
INSERT INTO ify_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kan Jacob ey “Eggak e-ehhelen ni hi-gam et mangeli kami tep kangku nem ikka-leg mudda u-ungngam. ");
INSERT INTO ify_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nem hedin ya meippanggep ida etan ni dios mu, ey mu panhamak et hedin wadan hi-gami hu nengala ey anin ni pepettey ku. Ey hedin wada ang-angen mun illamin hi-gam man issapatah kud hinanggadda eyan tutu-u ta e pebangngad ku.” Inhel Jacob huyya tep eleg tu amta e sinekew Rachel etan ida dios ametu. ");
INSERT INTO ify_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Et lumaw hi Laban et tu epengen ni hinemahemak di kampun Jacob, yad kampun Leah, yad kampuddan etan ni dewwan bega-en et han lumaw di kampun Rachel, nem endi. ");
INSERT INTO ify_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Hi Rachel e nengaladdan nunman ni dios ey intalu tud dallem ni yuddungngan ni kapantakkayi et yudungan tu. Intaggan nan Laban hamak, nem endi tu himmak. ");
INSERT INTO ify_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kan Rachel nan ametuy “Entan tu balaw e ama hu eggak ehnengi tep wada kamelpud annel ku.” Endi himmak nan Laban et ");
INSERT INTO ify_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","37","bumunget law hi Jacob et kantuy “Hipa bahul kun hi-gam? Kele muwak ali nampedug e heni kaka memdug ni nambahul et mu pambelukitkiten ni emin hu kalga mi. Paukat mu hedin wada himmak mun sinekew ku et ang-angen idan edum mu niyadda edum ku et iuh-uh da hedin hipan hi-gatan dewwa hu neiptek. ");
INSERT INTO ify_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Inamtam e dewampulun toon hu nengingngunnuan daka et ipenaptek kun emin hu gelding mu niya kalneroh mu et deh e nedakkel ida. Ey yan nunman idan toon ey endi nengunuh ni kalneroh niya gelding mu niya endin hekey hu nak kinleng ni inhidak. ");
INSERT INTO ify_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Hedin wada pintey idan animal di muyung di halun mu, man eggak peam-amta ni hinullulan ku. Anin idan kametellak ni hileng winu kawwalwal e muka pehullul ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ey insipesipel ku hu nemahhig ni petang ni kawwalwal niya nemahhig ni ketel ni hileng niya nakka metuttukal. ");
INSERT INTO ify_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Henin nunya hu hinelheltap kun dewampulun toon tep hampulut epat hu toon ni neneklaan kuddan eyan dewwan u-ungngam, niya enem ni toon hu neneklaan kudda eyan halun ku. Nem anin ni hanniman et nampinhampulu hu nenullulan mun tangdan ku. ");
INSERT INTO ify_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gullat na-mun eleg tuwak baddangan ni Dios nan apu hi Abraham et hi amak e hi Isaac et intu-dak muwak ni endin hekey hu indawat mun hi-gak. Nem kayyaggud et inang-ang Apu Dios hu lawah ni impahpahding mun hi-gak niya ligat ni ngunuk, et mampeang-ang ni hi-gam ni nahdem et ibunget daka.” ");
INSERT INTO ify_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Himmumang hi Laban ey kantuy “Yadda eya bii ey u-ungngak ida niya inap-apuk ida eya u-ungnga dadda. Ey animal ku eyadda kalneroh niyadda gelding. Ya kakulugan tu ey emin eya muka ang-ang-anga ey nalpun hi-gak. Nem endi inna-nuk ni mengikka-leg ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Et humman hu, imay kuma et manhummangan ita. Ey um-ala itan batun penginemnemneman tan ihhummangan ta.” ");
INSERT INTO ify_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Et umla hi Jacob ni batu et haaden tu ma-lat penginemnemneman dan nunman ni ihhummangan da. ");
INSERT INTO ify_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Inhel tuddan tuu tu e umpanuh idan batu et ipiggil da et mangan idan emin diman. ");
INSERT INTO ify_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Et ngadanan Laban humman ni Jegar Sahadutah. Ya impangngadan daman Jacob ey Galeed. ");
INSERT INTO ify_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kan Laban nan hi Jacob ey “Huyyan neipiggil ni batu hu mengippenemnem ni hi-gata.” Et mukun Galeed hu ngadan nunman ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nem nginedanan da mewan ni Mispah tep kan Laban ey “Hi Apu Dios hu menang-ang ni hi-gatan dewwa ma-lat ya ihhummangan ta hu meu-unnud, anin ni nandawwi ita. ");
INSERT INTO ify_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Eggak ali amtaa hedin ibbunget muddalli eya u-ungngak winu mengahwa kan edum ni bii, nem nemnem mu e wada hi Apu Dios ni kamenang-ang ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Adyah eya neipiggil ni batu niya eya batun hinead mu. ");
INSERT INTO ify_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Huyyaddan batu hu mengippenemnem ni hi-gatan dewwa etan ni inhummangan ta. Eggak lebbahi eya pappeg et umli-ak ni an mengippahding ni hi-gam ni lawah et hanniman daman hi-gam. ");
INSERT INTO ify_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ya etan Dios idan ammed tayu e di Abraham nan hi Nahor hu ngenamung ni mengastigu etan ni eleg mengu-unnud eyan inhummangan ta.” Et isapatah daman Jacob nan hi Apu Dios e kadeyyawan Isaac e u-unnuden tu huyyan inhummangan da. ");
INSERT INTO ify_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Et kumleng hi Jacob ni animal et iappit tun Apu Dios etan di duntug et aygan tudda etan tutu-u et mangan ida et manha-ad idadman ni hanlabbi. ");
INSERT INTO ify_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Newa-wa et bumengun hi Laban ni dagah et akwalen tudda u-ungnga tu niyadda etan inap-apu tu et bendisyonan tudda et han ida umenamut di bebley da. ");
INSERT INTO ify_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","2","Et mangmanglaw damad Jacob di lawwan da ey entanni ey wadadda anghel ni nenammun hi-gada. Inang-ang idan Jacob ey kantuy “Tam nangkampu gayam hi Apu Dios di deya.” Et ingadnan tu humman ni bebley ni Mahanaim. ");
INSERT INTO ify_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Impamengulun Jacob ida edum ni tuu tu ma-lat ida makihummangan nan agitun hi Esau di Seir di Edom. ");
INSERT INTO ify_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kan Jacob ni hi-gaday “Kan yun Esau ey: Hi Jacob e bega-en mu ey nanhahha-ad di baley nan pengemmaan yu e hi Laban. Et yan nunya ey pinhed tun mambangngad. ");
INSERT INTO ify_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Wadadda baketu, ya kebayyu tu, ya kalneroh tu, ya gelding tu et yadda bega-en tun lalakki niya bibi-i. Intu-dak dakemi ma-lat peamta mi hu ellian tu hedin ebbuluten mu.” ");
INSERT INTO ify_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nambangngad ida huyyan intu-dak Jacob et kandan hi-gatuy “Inhel min agim et iyyallin daitsu dammuen e wada hu ingkuyug tun epat ni gatut ni tutu-u tu.” ");
INSERT INTO ify_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dingngel nan Jacob humman ni inhel da ey nemahhig takut tu niya kaguh tu et pandewa tudda etan tutu-u tu niyadda halun tu. ");
INSERT INTO ify_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kantud nemnem tuy “Hedin umpatey hi Esau ey wada inna-nu eyan nanggillig ni umbebsik.” ");
INSERT INTO ify_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Et mandasal hi Jacob e kantuy “Apu e Dios ni kadeyyawa lan apuk hi Abraham ni hi ama e hi Isaac, hi-gam hu nengipanghel ni mambangngaddak di bebley idan aaggik niya ammed ku niya kammuy ippaptek muwak. ");
INSERT INTO ify_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Beken ni lebbengtun muwak peang-angan ni binabbal mun impeenang-ang mun hi-gak e bega-en mu. Makulug ni dakel ni peteg bendisyon mun hi-gak tep yan neni-yanan kun bebley mi et man-agwattak di Wangwang e Jordan ey ebuh hu hulkud kun intabin ku. Nem yan nunya ey nandewa-an ida tuuk ni ingkuyug ku. ");
INSERT INTO ify_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Apu Dios, ihwang muwak anhan di hipan lawah ni pehding agik e hi Esau tep ay nakka umtatakut. Tep entanniy petteyen dakemin emin ida eyan ahwak niyadda eya u-ungngak. ");
INSERT INTO ify_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nem inhel mun hi-gak nunman e ippaptek muwak niya kammuy pedakkel muddalli helag ku et heniddalli palnah di gilig ni baybay e eleg mebillang.” ");
INSERT INTO ify_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nanha-ad di Jacob ni hanlabbidman. Newa-wa et umappil ni animal ni iddawat tun agitu e hi Esau. ");
INSERT INTO ify_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Inappil tu hu dewanggatut ni labah ni gelding niya dewampulun lakki tu, ya dewanggatut ni labah ni kalneroh niya dewampulun lakki tu, ");
INSERT INTO ify_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ya telumpulun kamel ni wada impah tu, ya na-pat ni labah ni baka niya hampulun lakki tu, ya dewampulun labah ni kebayyu niya hampulun lakkitu. ");
INSERT INTO ify_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ginenadwa tudda et i-peng tudda etan idan bega-en tun mengippengulu et kantun hi-gaday “Pamengulu kayu ey ang-ang yu ma-lat wada pambabattanan yu.” ");
INSERT INTO ify_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Inhel tu etan ni nemangulun bega-en e kantuy “Hedin dammuen yu hi Esau et ibbagetu e kantuy ‘Attu lawwan yu? Hipa kan bega-en ni hi-gayu? Niya hipa kan halun idan nunya?’ ");
INSERT INTO ify_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ey kanyun humang yuy ‘Huyya hu halun nan bega-en mu e hi Jacob. Iddawat tun hi-gam e apu tu. Iyyalli e neitu-nud ni hi-gami.’” ");
INSERT INTO ify_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Hanniman dama hu inhel tun e-helen ida etan ni bega-en tun nangkeitu-nud. ");
INSERT INTO ify_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ey kantun hi-gaday “Entan tu liwwan ni e-helen ni hi-gatu e kanyuy ‘Hi Jacob e bega-en mu.’” Huyya impahding tu tep ya wadad nemnem tu ey meendi hu bunget Esau ni hi-gatu et ebbuluten tu hedin ang-angen tudda humman ni iddawat tun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Impamengulu tun impalaw ida etan animal ni iddawat tun Esau et manha-ad di kampu da ni nunman ni hileng. ");
INSERT INTO ify_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yan nunman ni hileng ey bimmangun hi Jacob et bangunen tudda etan dewwan ahwatu et yadda etan dewwan biin bega-en dan imbilang tun ahwatu niyadda etan hampulut hakey ni u-ungnga tu et agwaten da Wangwang e Jabbok. ");
INSERT INTO ify_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","Et iagwat tun emin hu wadan hi-gada et han mambangngad di kampu da et hahhakkey tun nandeyadman. Entanni ey wada immalin tuu et makibenultung ni hi-gatu ingganah kamangkewa-wa. ");
INSERT INTO ify_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nem eleg han-ilaw etan ni tuu hi Jacob et pangkubhil tu hu genit ni sipan Jacob. ");
INSERT INTO ify_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Et kan etan ni tuuy “Imay et lumawwak tep ay kamangkewa-wa.” Nem kan Jacob ey “Eleg daka pellaw ingganah bendisyonan muwak.” ");
INSERT INTO ify_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kan etan ni tuu ey “Hipa ngadan mu?” Kan Jacob ey “Hi-gak hi Jacob.” ");
INSERT INTO ify_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ey kan etan ni tuu ey “Beken law ni Jacob hu ngadan mu. Hi-gam law hi Israel. Tep nekihangga kad tuu et hi Apu Dios ey nengapput ka.” ");
INSERT INTO ify_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kan Jacob ey “Hipa ngadan mu?” Kan etan ni tuu ey “Eleg mahapul ni amtaen mu hu ngadan ku.” Et bendisyonan tu hi Jacob. ");
INSERT INTO ify_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kan Jacob ey “Inang-ang ku hi Apu Dios, nem kayyaggud et eleggak matey.” Et ngadanan tu humman ni Peniel. ");
INSERT INTO ify_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Simmimil hu aggew ni neni-yanan Jacob ni Peniel e kamampi-pi-day tep nangkubhil hu genit di sipetu. ");
INSERT INTO ify_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Et humman hu, ingganah ni nunya ey eleg ihhidaddan helag Israel hu ulat ni neipket di genit di sipan linggeman ni animal, tep humman hu neikubhil ni genit Jacob. ");
INSERT INTO ify_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Inang-ang nan Jacob hi Esau e iyyallin nangkuyug ni epat ni gatut ni tuu et pan-appiappil tudda pamilyah tu et mantu-tu-nud ida, e yadda u-ungngan Leah, yadda u-ungnga tun etan ni dewwan bega-en niyadda u-ungngan Rachel, et mantu-tu-nud ida. ");
INSERT INTO ify_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nemangulu etan dewwan biin bega-en niyadda u-ungnga da, et han maitu-nud hi Leah niyadda u-ungnga tu, et manggillig ida han-ina e di Rachel nan Joseph. ");
INSERT INTO ify_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nemappangngulu hi Jacob et kamangkeihnup nan agi tu hi Esau ey nanyuung ni nangkappitu. ");
INSERT INTO ify_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nambesik hi Esau ni an nenammun Jacob et akwalen tu ey ida kamannengngih ni dewwa. ");
INSERT INTO ify_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Inang-ang nan Esau ida etan bii niyadda etan u-ungnga da ey kantuy “Hipadda huyyan ingkuyug mu?” Kan Jacob ey “U-ungngak ida huyyan indawat Apu Dios tep kayyaggud ni peteg ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Immalidda etan dewwan bega-en niyadda u-ungnga da et manyuung idan Esau. ");
INSERT INTO ify_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Neitu-nud hi Leah et yadda etan u-ungnga tu et manyuung ida dama. Nanggillig di Rachel nan hi Joseph et manyuung ida daman Esau. ");
INSERT INTO ify_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Minahmahan mewan nan Esau e kantuy “Ey hipadda kan animal etan ni nemangulun dinammuk?” Kan Jacob ey “Humman iddawat kun hi-gam ma-lat abuluten mu hu inlian mi.” ");
INSERT INTO ify_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nem kan Esau ey “Agik, eggak mahapul ida humman tep wada dama hu halun ku, et humman hu anin ni bangngad mu kuma.” ");
INSERT INTO ify_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nem kan Jacob ey “Abulut mu kuma tep ay inebulut mu inlian mi. Et kayyaggud hu nandatngan ta et heni inang-ang ku hi Apu Dios ni nenang-angan kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kapepillit Jacob e kantuy “Alam kuma eya nakka iddawat ni hi-gam tep dakel hu halun kun indawat Apu Dios gapu ni hemek tun hi-gak.” Et abuluten nan Esau. ");
INSERT INTO ify_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kan Esau ey “Et imay tep et lumaw itsu. Ippangulu midda eyan tuuk hu dalan.” ");
INSERT INTO ify_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nem kan Jacob ey “Em, nem inna-nu e iyyaddadya hu gelang et ya halun ku niyadda impah da ey mahapul ni mambabbabbal kami tep entun mangkettey ida. ");
INSERT INTO ify_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Et humman hu pamengulu kayu et anin ni meitu-tu-nud kamin eyaddan u-ungnga et yadda halun, et han dakeyu la datngid Edom.” ");
INSERT INTO ify_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kan Esau ey “Anin, nem ibbatih kudda edum ni tuuk ni pan-e-dum yu.” Nem kan Jacob ey “Eleg, anin ebuh kami nemet peang-ang mu hu kayyaggud ni hi-gami.” ");
INSERT INTO ify_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Et umgah di Esau ni nambangngad di Edom. ");
INSERT INTO ify_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nem nampalaw idad Jacob di Sukkot. Nengapyad man ni kampu da niya hiddumman idan halun tu. Et mukun nginadnan da humman ni Sukkot. ");
INSERT INTO ify_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Intuluy dan nanglaw et lektattuy dimmateng idad Sekem di Kanaan. Et mangkampudda etan di neihnup ni bebley. Melinggep hu nandalnan da neipalpun immegahan dad Mesopotamia ingganah dimmateng idad Sekem. ");
INSERT INTO ify_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ginetang Jacob humman ni puyek ni hanggatut ni palatah idan helag Hamor e aman Sekem. ");
INSERT INTO ify_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Et ngadnan tun El Elohe e ya keibbellinan tu, Apu Dios ni kadeyyawan Israel. ");
INSERT INTO ify_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Hakey ni aggew ey limmaw hi Dinah e u-ungngad Jacob nan Leah ni an nekia-ayyam idan edum ni biidman ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hi Sekem e u-ungngan Hamor e Hibite e ap-apudman ni bebley ey inang-ang tu hi Dinah et tu piliten ni in-ulig. ");
INSERT INTO ify_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nakappinhed tun peteg hi Dinah tep kat-agu et tuka ena-alluka ma-lat man-ahwadda. ");
INSERT INTO ify_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Et tu ehelen nan ametu e hi Hamor e kantuy “Muwak i-hel idan a-ammed ni nunman ni bii tep pinhed kun ahwaen.” ");
INSERT INTO ify_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Entanni ey dingngel nan Jacob e wada lawah ni neipahding ni u-ungnga tu e hi Dinah, nem impemegga tu ni i-ineng tep limmaw idan emin etan u-ungnga tun lalakkin an nampattul. ");
INSERT INTO ify_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hi Hamor e aman nan hi Sekem ey limmaw ni an mekihhummangan nan hi Jacob. ");
INSERT INTO ify_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ey neipaddih ni iyyaddalli etan u-ungngan Jacob ni nalpun an nampattul. Dingngel da humman ni neipahding nan agi da ey nemahhig bunget dan nemaingan Sekem ni hi-gadan Hebrew tep lawah humman ni peteg ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kan Hamor nan Jacob ey “Inna-nu tu huyya e nakappinhed ni u-ungngak e hi Sekem etan u-ungngam e hi Dinah. Et humman hu, attu ew kuma et iebulut mu ma-lat man-ahwadda? ");
INSERT INTO ify_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Manhuhummangan itsu et man-aapu itsu. ");
INSERT INTO ify_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ey dammutun mekibbebley kayudya ey ngenamung kayun ngunnuen yu henin umgatang winu manggettang niya hipan keddangyanan yu.” ");
INSERT INTO ify_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kan Sekem nan aman Dinah niyadda agituy “Iebulut yu anhan et iahwak hi Dinah. Iddawat kun emin hu hipan ibbageyu. ");
INSERT INTO ify_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Anin piga ibbageyun iddawat ku et ebbuluten ku nemet iebulut yun ahwaen ku hi Dinah.” ");
INSERT INTO ify_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Nem gapu tep lawah hu impahding Sekem nan Dinah ey nanhina-ul da hu inhumang dan hi-gadan han-ama. ");
INSERT INTO ify_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kandan hi-gaday “Eleg mabalin ni mu ahwaen hu agi mi tep eleg ka makugit. Kebe-ingan mi hedin ebbuluten mi hu imbagam. ");
INSERT INTO ify_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nem hedin tetbalen yu et mampekuggit kayu ma-lat heni kayun hi-gami, man dammutun i-abulut min ahwaen Sekem hi agi mi. ");
INSERT INTO ify_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Et man-aapu itsu niya mambebley kamidya et mandadagyum itsu. ");
INSERT INTO ify_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nem hedin eleg yu tetbala eya kammi ey ewwiten mi ew hi Dinah et manglaw kami.” ");
INSERT INTO ify_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kayyaggud hu kapannemnem di Sekem nan Hamor ni nunman ni inhel da et abuluten da. ");
INSERT INTO ify_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","20","Hi Sekem ey hi-gatu kametbal di emin ni u-ungngan ametu. Gapu tep nakappinhed tu etan u-ungngan Jacob ey ganuganuddan han-aman limmaw di kakeemmungiddan tuud eheb ni nunman ni bebley et ehelen dan hi-gada hu inhuhummangan da. ");
INSERT INTO ify_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Kanday “Humman idan tuu ey kayyaggud hu daka pekiddagyumin hi-gatsu. Iebulut tayu mekibbebley idan hi-gatsu niya dammutun umgatang ida niya manggettang ida haggud mahkang eya bebley et lektattuy meki-eppu itsun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nem kanday ebbuluten dan mekibbebley ni hi-gatsu hedin mampekuggit itsun emin ni lalakki ma-lat heni itsun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hanniman hu pehding tayu ma-lat emin hu animal da niya emin hu wadan hi-gada ey ellan tayu. Abulut tayu kuma et makibebley idan hi-gatsu ma-lat meila-kam itsud kinedangyan da.” ");
INSERT INTO ify_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Et abuluten idan tuu et mampakugit idan emin hu lalakkidman. ");
INSERT INTO ify_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nelabah hu tellun aggew ni nekugitan da e maggeh ni hu kugit da ey limmaw di Simeon nan Levi e agiddan Dinah e nan-ispadah ida et da liguden ni pintey ida humman lalakkidman. ");
INSERT INTO ify_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Impakipetey dadda han-ama e di Hamor nan Sekem. Et awiten da hi agida e hi Dinah et ienamut ida. ");
INSERT INTO ify_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Limmaw ida dama etan edum ni u-ungngan nan Jacob et da pan-al-en hu hipan wadadman. Huyya nengiblehan dan neipahding nan agidan hi Dinah. ");
INSERT INTO ify_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Impeki-la daddan emin hu inhalun da niya emin hu wada etan di bebley. ");
INSERT INTO ify_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nan-aledadda bibi-i, yadda u-ungnga niya emin kinedangyan da. ");
INSERT INTO ify_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Entanni ey kan Jacob nan Levi et hi Simeon ey “Impambalin yuwak ni anggebe-hel ni emin ni tuudya. Inna-nu hedin mangkakahhakey ida Kanaanite niyadda Perisite et umliddan mengubbat ni hi-gatsu, kaw eleg daitsu petteyan emin tep ay hahhakkey itsu?” ");
INSERT INTO ify_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nem kanday “Bahul da tep heni biin tuka pebeyyad annel tu hu impahding Sekem ni agimi.” ");
INSERT INTO ify_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Entanni ey kan Apu Dios nan Jacob ey “Pan-aldan kad Bethel et mambebley kayudman. Ey pengapya kadman ni pan-appitan yun hi-gak e Dios ni nampeang-ang lan hi-gam ni nunman ni binsikam ni neni-yanam nan agim e hi Esau.” ");
INSERT INTO ify_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Et kan Jacob idan pamilyah tu niyaddan emin hu kamekihha-ad di baley tuy “Pan-ibkah yudda dios yun kinapyan tuu niya pan-emeh kayu et manhullul kayun malinih ni balwasi yu. ");
INSERT INTO ify_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tep umlaw itsud Bethel et nak kumapyan pan-appitan nan Apu Dios e nemenaddang ni hi-gak di emin ni ligat ku niya nengipenaptek ni hi-gak di emin ni linawwan ku.” ");
INSERT INTO ify_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Et idwat dan Jacob ni emin etan ida dios da niyadda betling da, et iku-ku tu etan di hengeg ni keyew ni oak ni neihnup di Sekem. ");
INSERT INTO ify_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yan kapenglawwid Jacob ey impatekut Apu Dios ida etan tutu-ud nangkeihnup ni bebley et eleg da pedugen ida. ");
INSERT INTO ify_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Entanni ey dimmateng idad Lus, e Bethel law ngadan tu, di Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Et kumapya hi Jacob ni pan-appitan et ngadanan tun El Bethel, tep yadman hu nampeang-angan Apu Dios ni hi-gatun binsikan tun neni-yanan tun agitu. ");
INSERT INTO ify_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Entanni ey netey hi Deborah e nengipappaptek nan Rebekah e inan Jacob et ikulung dad hengeg ni keyew ni oak e neihnup di Bethel. Et ngadanan da humman ni keyew ni “Keyew ni kapannannangngihi.” ");
INSERT INTO ify_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yan nalpuan Jacob di Paddan Aram di Mesopotamia ey nampeang-ang mewan hi Apu Dios ni hi-gatu et bendisyonan tu. ");
INSERT INTO ify_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kan Apu Dios ni hi-gatuy “Yan nunya ey beken law ni Jacob hu ngadan mu tep hi-gam law hi Israel.” Et huyya law hu ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kan Apu Dios ni hi-gatuy “Hi-gak hu Dios e Kabaelan tun emin. Kahlag kan dakel et pambebleyan dalli hu dakel ni bebley. Ey mampatul idalli edum ni helag mu. ");
INSERT INTO ify_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Hi-gam niyaddalli helag mu hu memeltan ni puyek ni indawat kun apum e hi Abraham ni hi amam e hi Isaac.” ");
INSERT INTO ify_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Negibbuh ni inhel nan Apu Dios humman et hi-yanen tu hi Jacob. Immala hi Jacob ni batun penginemnemneman tun nunman ni neipahding et haaden tudman etan di nenang-angan tun Apu Dios et du-yahan tun meinnum niya lana. ");
INSERT INTO ify_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Et ngadnan tu humman ni bebley ni Bethel. ");
INSERT INTO ify_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Entanni ey hini-yan di Jacob hu Bethel et lumaw idad Eprat. Nem eleg ida dumteng di Eprat ey indegeh tu hu egeh nan Rachel et man-ungnga. ");
INSERT INTO ify_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nampaligat ni nan-ungnga et yan neukatan etan ni gelang ey kan etan ni nenaya ey “Kayyaggud kaya, laki mewan eya in-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nem kamangkeungnguh hu yayyah Rachel et ngadanan tu etan gelang ni Ben-oni et han matey, nem Benjamin hu impangngadan ametu. ");
INSERT INTO ify_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Netey hi Rachel et ikulung dad neihnup di dalan ni umlaw di Eprat e Bethlehem hu ngadan tun nunya. ");
INSERT INTO ify_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Et haaden Jacob hu batud nengikulungan dan Rachel ni penginemnemneman tu, et ingganah nunya ey wada humman ni sinyal ni kulung. ");
INSERT INTO ify_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Intuluy di Jacob ni nanglaw et mangkampuddad a-allaw ni Eta-gey ni baley di Eder. ");
INSERT INTO ify_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yan wadaddadman hu nengiuligan nan Reuben nan Bilhah e bega-en da ey hakey ni ahwan ametu. Dingngel nan ametu hi Jacob humman ni impahding. Huyyadda ngadan ida etan ni hampulut dewwan lalakkin u-ungngan Jacob: ");
INSERT INTO ify_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Hi Reuben e pengulwan, hi Simeon, hi Levi, hi Judah, hi Issakar, hi Sebulun. Huyyadda u-ungnga dan nan Leah. ");
INSERT INTO ify_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ya u-ungnga dan Rachel ey di Joseph nan hi Benjamin. ");
INSERT INTO ify_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ya u-ungnga dan Bilhah e bega-en Rachel ey hi Dan et hi Naptali. ");
INSERT INTO ify_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ya u-ungnga dan Silpah e bega-en nan Leah ey hi Gad nan hi Asher. Emin ida huyyan u-ungngan Jacob ey neiungngaddad Paddan Aram di Mesopotamia. ");
INSERT INTO ify_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Immanemut di Jacob di kad-an nan ametu hi Isaac di Mamre e neihnup di Hebron e nambebleyan dama lan aputu hi Abraham. ");
INSERT INTO ify_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Yan nunman ey neka-a-amma law hi Isaac e hanggatut et newalu hu toon tu. Netey et ikulung idan u-ungnga tu e di Esau nan Jacob. ");
INSERT INTO ify_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Huyyadda nahlag nan Esau e hi Edom hu hakey ni ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Inahwa tudda tellun biin iKanaan. Hi Adah hu hakey e u-ungngan Elon e Hittite. Ya meikkadwa ey hi Oholibamah e u-ungngan Anah niya inap-apun Sibeon e Hibite. ");
INSERT INTO ify_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Et ya meikkatlu ey hi Basemat e agin Nebayot e u-ungngaddan Ismael. ");
INSERT INTO ify_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ya u-ungngad Esau nan Adah ey hi Eliphas. Ya u-ungnga dan Basemat ey hi Reuel. ");
INSERT INTO ify_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ya u-ungnga dan Oholibamah ey hi Jeus, hi Jalam ni hi Korah. Emin ida huyyan u-ungngan Esau ey neiungngaddad Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Entanni ey ninemnem Esau ni man-e-tan di edum ni bebley ma-lat meidawwin Jacob. Inewit tudda ahwatu, yadda u-ungnga tu, niyadda kamampanha-ad di baley tu. Impeki-la tudda halun tu niyaddan emin hu kinedangyan tun limmu tudman. ");
INSERT INTO ify_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Mukun nan-etan ey tep kulang law hu puyek dad Kanaan ni pengippattulan dan han-agin halun da tep dimmakkel ni peteg. ");
INSERT INTO ify_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Et an mambebley hi Esau di nangkedunduntug di Edom. ");
INSERT INTO ify_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Huyyadda nahlag nan Esau e nahlagan idan iEdom. ");
INSERT INTO ify_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Hi Eliphas e u-ungngad Esau nan Adah ey nahlag et wada liman lalakki, e hi Teman, hi Omar, hi Sepho, hi Gatam et hi Kenas. Ya meikka-nem ey hi Amalek e u-ungnga dan Timna e hakey mewan ni ahwa tu. Hi Reuel e u-ungngad Esau nan hi Basemat ey nahlag et wadadda dama epat ni lalakki e hi Nahat, hi Serah, hi Sammah et hi Missah. ");
INSERT INTO ify_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Yadda u-ungngad Esau nan Oholibamah e u-ungngan Anah niya inap-apun Sibeon ey hi Jeus, hi Jalam et hi Korah. ");
INSERT INTO ify_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Yadda u-ungngad Esau nan Adah ey hi Eliphas e pengulwan. Nahlag hi Eliphas et hi Teman, hi Omar, hi Sepho, hi Kenas, hi Korah, hi Gatam et hi Amalek. ");
INSERT INTO ify_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ya u-ungngad Esau nan Basemat ey hi Reuel. Nahlag hi Reuel et hi Nahat, hi Serah, hi Sammah et hi Missah e hi-gada hu ap-apuddan helag da. ");
INSERT INTO ify_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yadda dama u-ungngad Esau nan Oholibamah e u-ungngan Anah ey hi Jeus, hi Jalam et hi Korah. ");
INSERT INTO ify_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Emin ida huyyan netenten ey helag idan Esau e yad Edom hu nan-ap-apuan da. ");
INSERT INTO ify_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Yadda sigud ni nambebley di Edom ey nahlag idad helag Seir e Horite. Huyyadda ey hi Lotan, hi Sobal, hi Sibeon, hi Anah, hi Dishon, hi Eser et hi Dishan. ");
INSERT INTO ify_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Dewwa u-ungngan Lotan e di Hori nan Homam. Wada agin Lotan ni bii e hi Timna ngadan tu. ");
INSERT INTO ify_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Yadda u-ungngan Sobal ey hi Alban, hi Manahat, hi Ebal, hi Sepho et hi Onam. ");
INSERT INTO ify_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Hi Sibeon ey wadadda dewwan u-ungnga tu e di Aiah nan Anah. Huyyan hi Anah hu nenamak etan ni kaman-utbul ni maetung ni danum ni tu nengipattulan idan kebayyun ametud endi bebley. ");
INSERT INTO ify_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Yadda u-ungngan Anah ey hi Dishon et hi Oholibamah e bii. Yadda u-ungngan Dishon ey hi Hemdan, hi Esban, hi Itran et hi Keran. ");
INSERT INTO ify_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Yadda u-ungngan Eser ey hi Bilhan, hi Saaban et hi Akan. ");
INSERT INTO ify_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Yadda u-ungngan Dishan ey di Us nan Aran. ");
INSERT INTO ify_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Huyyadda aap-apuddan Horite di Edom: Hi Lotan, hi Sobal, hi Sibeon, hi Anah, hi Dishon, hi Eser et hi Dishan. Huyyadda nisi Horite ni nan-ap-apud Edom. ");
INSERT INTO ify_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Yan endi ni patul di Israel ey wadadda ngu dedan hu nanhuluhulul ni patul di Edom. ");
INSERT INTO ify_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ya nemangulu ey hi Bela e u-ungngan Beor e iDinhaba. ");
INSERT INTO ify_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Netey hi Bela et maihullul hi Jobab e u-ungngan Serah e iBosrah. ");
INSERT INTO ify_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Netey hi Jobab et maihullul hi Husham e iTeman. ");
INSERT INTO ify_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Netey hi Husham et maihullul hi Hadad e u-ungngan Bedad e iAbit. Huyyan hi Hadad hu nengapput idan iMidian eman ni nanggugubatan dad Moab. ");
INSERT INTO ify_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Netey hi Hadad et maihullul hi Samlah e iMasrekah. ");
INSERT INTO ify_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Netey hi Samlah et maihullul hi Saul e iRehobot e bebley di kad-an ni Wangwang e Euphrates. ");
INSERT INTO ify_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Netey hi Saul et maihullul hi Baal Hanan e u-ungngan Akbor. ");
INSERT INTO ify_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Netey hi Baal Hanan et maihullul hi Hadad e iPau. Ya ahwan Hadad ey hi Mehetabel e u-ungngan Matred ey inap-apun Mesahab. ");
INSERT INTO ify_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Hi Esau hu nahlagan idan iEdom e yadda nengipappangngulun hi-gada ey hi Timna, hi Albah, hi Jethet, hi Oholibamah, hi Elah, hi Pinon, hi Kenas, hi Teman, hi Mibsar, hi Magdiel et hi Iram. Nangkeingedan hu ngadan dad nampambebleyan da. ");
INSERT INTO ify_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Hi Jacob ey nannaneng di Kanaan e bebley ametu. ");
INSERT INTO ify_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Huyyadda nekapkapyan hi-gatu. Yan eman ni kapenikkenin u-ungnga tun hi Joseph e hampulut pitu toon tu ey nekikkillaw idan edum ni agitun u-ungngan ametud edum ni ahwatu e di Bilhah nan Silpah ni an mampattul ni halun ameda. Ey hin-addum ni wada tuka idenaddatteng nan ametun beken ni kayyaggud ni kapehpehding idan nunman ni agitu. ");
INSERT INTO ify_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Hi Jacob ey hi Joseph hu pinpinhed tud emin ida etan ni u-ungnga tu, tep hi-gatu neiungnga eman ni tuka pangkea-ammai. Hakey ni aggew ey indawtan tun andukkey ni balwasin kakkayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yadda agin Joseph ey inletu da e hi-gatu pinpinhed amedan hi-gadan han-aaggi, et mukun anggebe-hel da, et anin ni pekihhummanganan dan hi-gatu et daka pambinungnget. ");
INSERT INTO ify_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Entanni ey nan-i-innep hi Joseph ni meippanggep idan agitu et ehlen tun hi-gada et nema-ma bunget dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kantuy “Heninnuy hu ini-innep ku. ");
INSERT INTO ify_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Limmaw itsu kumangngun han-aaggid payew et tayu pambeteken ida etan neanin pagey. Entanni ey nebehwat etan bintek ku ey linikweh idan bintek yu et manyuung ida etan di bintek ku.” ");
INSERT INTO ify_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ey kan idan agi tuy “Kaw kammu nem mampatul kalli et hi-gam u-unnuden mi?” Et nema-man anggebe-hel da tep ya i-innep tu. Beken ni ya ini-innep tun ebuh hu daka pengibubbungesin hi-gatu, nem anin ni elaw ni tuka penge-ehhel ni i-innep tu. ");
INSERT INTO ify_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Entanni ey wada mewan hu ini-innep tu et e-ehhelen tuddan agitu. Kantuy “Ini-innep kun nanyuung idan hi-gak hu aggew, ya bulan niyadda hampulut hakey ni bittuwen.” ");
INSERT INTO ify_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Inhel tu daman ametu humman ni ini-innep tu ey imbunget ametu e kantuy “Kele hipa huttan ni i-innep? Kaw anin hi-gak, hi inam et yadda agim et manyuung kamillin hi-gam?” ");
INSERT INTO ify_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Et mukun wada ameh idan agin Joseph ni hi-gatu. Nem hedin hi ametu, man tuka nemnemnema hu keibbellinan nunman ni i-innep. ");
INSERT INTO ify_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Hakey ni aggew ey limmaw ida agin Joseph di Sekem ni an mengippattul ni inhalun ameda. ");
INSERT INTO ify_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Ey kan Jacob nan Joseph ey “Kaiunud ka et mu ang-angen ida agim di daka pampattuled Sekem. Mulli ang-ang hedin kayyaggud hu kameipahpahding ni hi-gada niyadda animal ni da impattul. Ey nambangngad ka et peamtam ni hi-gak.” Kan Joseph ey “Em, umlawwak.” Et umgah di bebley dad Hebron et lumaw di Sekem. Dimmateng hi Joseph di Sekem ");
INSERT INTO ify_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","et tu hamhamken ida agitu. Ey wada hakey ni tuun nenang-ang nan Joseph et kantun hi-gatuy “Hipa muka hemmahemmaka?” ");
INSERT INTO ify_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kan Joseph ey “Yadda etan agik ni an nampattul, nem eggak ida hanhamak. Kaw amtam kad-an da?” ");
INSERT INTO ify_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kan etan ni tuuy “Wadadda lan nuntan nem dingngel ku ung-ungbal da e umlaw idad Dothan.” Et maiunud hi Joseph diman. ");
INSERT INTO ify_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kamenetteng diman ey inang-ang idan agitu et ihuhummangan da petteyen dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kanday “Iyalli etan kaum-eni-innep. ");
INSERT INTO ify_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Petteyen tayu et egahen tayud bitu. Et hedin ibbagan ametayu, kantayuy kinan ni layon. Et ang-angen tayu pangngu numan hu pambalinan ni i-innep tu.” ");
INSERT INTO ify_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Dingngel Reuben humman ey eleg tu pinhed ni petteyen da et kantuy “Eleg tayu petteya. ");
INSERT INTO ify_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nealay inggah tayud bitu.” Mukun humman inhel tu ey tep tuka nemnemnema e ewwiten tulli et ienamut tun ametu. ");
INSERT INTO ify_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Dimmateng tu-wangu Joseph ey dimpap da et ekalen da etan andukkey ni balwasi tun kakkayyaggud. ");
INSERT INTO ify_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Et da egahen di bitun mamega. ");
INSERT INTO ify_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ida kamengngan ey wadadda tuun inang-ang dan nalpud Gilead ni umlaw di Egypt. Humman idan tuu ey helag idan Ismael e ya ngunu da ey ida kamanggettang ni linggeman. Yadda kamel da ey dakel kinalga dan kameikkamdug di ihhida niyadda bangbanglu. ");
INSERT INTO ify_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kan Judah idan agituy “Endi gungunahen tayun memettey eyan agi tayu anin ni he-ulen tayu ametayu. ");
INSERT INTO ify_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kayyaggud na-mu hedin iggatang tayu eyaddan kamangkelebbah ni helag Ismael et eleg tayu pateyen. Tep kaw tu-wan beken tayun agi?” Ey inebulut idan agi tu. ");
INSERT INTO ify_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Et da guyuden hi Joseph etan di bitu et igtang dan dewampulun palatah etan idan helag Ismael et ilaw dad Egypt. ");
INSERT INTO ify_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nambangngad hi Reuben et tu ang-angen hi Joseph etan di bitu ey endidman. Et makaggeh ni peteg nemnem tu et pambi-kien tu balwasi tu. ");
INSERT INTO ify_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Et lumaw di kad-an idan agitu et kantuy “Endi etan di bitu hi Joseph! Hipa law pehding ku?” ");
INSERT INTO ify_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Et ya law impahding da ey pintey da hakey ni gelding et ita-mel da balwasin Joseph etan di kuheyaw. ");
INSERT INTO ify_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","In-anemut da humman ni balwasin Joseph et peang-ang dan ameda et kanday “Himmak mi huyyan balwasid dalan. Ang-ang mu pangngu hedin huyya balwasi etan ni u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Inimmatunan tu e balwasin Joseph et kantuy “Tam em, balwasin etan ni u-ungngak! Endi! Binenuklin layon hu annel tu!” ");
INSERT INTO ify_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Bini-kin Jacob hu balwasi tu et mambalwasin langgusih gapuh ni lemyung tu tep endi etan u-ungnga tu. Ey kaumlelemyung ni pigan aggew. ");
INSERT INTO ify_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Immalidda u-ungnga tun menga-alluk ni hi-gatu, nem nanengtun kaumlelemyung. Kantuy “Ingganah ni metteyyak et hannak liwwana humman ni u-ungngak ni neendi.” ");
INSERT INTO ify_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yan nengidetengan dan Joseph di Egypt, ey inggatang dan Potiphar e ap-apuddan guwalyad baley ni patul. ");
INSERT INTO ify_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yan nunman dama, ey hini-yan Judah ida agi tu et an makiha-ad di baley Hirah e iAdullam. ");
INSERT INTO ify_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yadman nenammuan tu etan ni ahwa tun iKanaan e u-ungngan Sua. ");
INSERT INTO ify_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","5","Et maweda tellun u-ungnga tun laki. Ya impangngadan tu etan ni pengulwan ey hi Er. Newada etan neihayned et ngadanan tun hi Onan. Newada etan neikatlu et ngadanan tun hi Selah. Hi Selah e udidyan ey neiungnga eman ni wadaddad Kesib. ");
INSERT INTO ify_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kimmat-agu hi Er e pengulwan et peahwan ametun nan hi Tamar. ");
INSERT INTO ify_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nem hi Er ey nemahhig ni lawah hu tuka pehpehding e kabellawan Apu Dios et pateyen tu. ");
INSERT INTO ify_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Entanni ey kan Judah etan ni meikkadwan u-ungnga tu e hi Onan ey “Iahwam hi Tamar tep humman elaw tayu. Et hedin wada u-ungnga yu ey meibbillang ni u-ungnga etan ni agim ni netey.” Et iahwan Onan hi Tamar. ");
INSERT INTO ify_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nem inamtan Onan e beken tun meibbillang ni kan-u-ungngan i-ungnga da. Et humman hu, hedin nan-ulig idan Tamar, ey tuka pekewwa hu kamelpud annel tu et endi kamekapyan gelang. ");
INSERT INTO ify_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Eleg pinhed Apu Dios humman ni impahding tu et pateyen tu hi Onan. ");
INSERT INTO ify_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Et kan law Judah nan Tamar ey “Pambangngad ka ew di baley amam et hedin mehikken hi Selah ey han tuka iahwa.” Mukun hanniman impanghel tu ey tep kaumtakut tep entanni ey meippahding daman Selah etan neipahding idan agitu. Et mambangngad hi Tamar di baley di ametu. ");
INSERT INTO ify_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Entanni et malebah pigan toon ey netey etan ahwan Judah. Negibbuh hu nengibeluan tu et aygan tu etan gayyum tu e hi Hirah e iAdullam et lumaw idad Timnah ni an memu-lit ni dutdut ni kalneroh tu. ");
INSERT INTO ify_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Wada nanghel nan Tamar e hi Judah e nengapun hi-gatu ey umlaw di Timnah ni an memu-lit ni dutdut ni kalneroh tu. ");
INSERT INTO ify_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Et hullulan tun kakkayyaggud etan imbalwasi tun balwasin nebalu et manhukyung ma-lat eleg meimmatunan angah tu et an manyuyyuddung etan di eheb di Enaim e bebley ni kadellanan umlaw di Timnah. Mukun humman impahding tu ey tep inamta tu e nehiken law hi Selah, nem eleg peahwan ametun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kamangkelebbah hi Judah ey inang-ang tu et kantu na-mu ngu nem hi-gatu hakey ida etan ni biin daka pebeyyad hu annel da tep hinukyungan tu angah tu. ");
INSERT INTO ify_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Et lumaw di kad-an nunman ni bii et kantuy “Piga pinhed mun pemeyyad kun hi-gam ma-lat iulig daka?” Kan Tamar ey “Ngenamung ka hedin piga pinhed mun iddawat ni hi-gak.” Hi Judah ey eleg tu amta e humman etan biin inepu tu. ");
INSERT INTO ify_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Et kan Judah ey “Pei-lik alin hi-gam hu hakey ni gelding ku.” Ey kan Tamar ey “Dammutu, nem pakkadek ni wada iddawat mun nunya et hedin peellim etan gelding mu, man han mu binangngad.” ");
INSERT INTO ify_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kan Judah ey “Hipa pinhed mun iddawat kun nunya?” Kan Tamar ey “Dammutu eya imbanggel mu niya eya hulkud mu.” Inebulut Judah et idwat tudda humman et man-ulig ida et mewad-an hi Tamar. ");
INSERT INTO ify_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Immanemut hi Tamar et ekalen tu hukyung tu niya balwasi tu et ibalwasi tu mewan etan balwasin nebalu. ");
INSERT INTO ify_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yan eman ni nengitu-dakan Judah etan ni gayyum tu hi Hirah ni mengillaw etan ni gelding ni etan ni bii ma-lat bangngaden tudda etan indawat tu, nem endi humman ni bii. ");
INSERT INTO ify_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Et tu pan-ibgaddan lalakkid Enaim e kantuy “Ettu etan biin tuka pebeyyad hu annel tun kamanyuyyuddung la nid eheb ey?” Ey kanday “Endi ngu hu inamta min henin nunman ni biidya.” ");
INSERT INTO ify_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Et mambangngad et kantun Judah ey “Endidman etan bii. Anin ida etan ni lalakkidman et kanday endi hu henin nunman ni biidman.” ");
INSERT INTO ify_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Et kan Judah ey “Anin ew katteg ni diman et alen tudda etan indawat kun hi-gatu. Tep ngi-ngi-ngian daita hedin mambangngad itan an menemmak ni hi-gatu.” ");
INSERT INTO ify_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Entanni et nelabah tellun bulan ey wada nengidaddatteng nan hi Judah e ya etan ineputu e hi Tamar ey nambalin ni tuka pebeyyad hu annel tu et aye nela-la-gahan. Bimmunget hi Judah et kantuy “Mahapul ni yu pa-hep et giheben yu.” ");
INSERT INTO ify_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Nem yan linawwan dan an mengellan hi-gatu ey kantuy “Yu peang-ang nan Judah eya banggel niya hulkud et ehelen yun hi-gatu e ya ama eyan imbutsug ku ey ya etan kanbanggel niya kanhulkud ni nunya.” ");
INSERT INTO ify_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Da impeang-ang ey inimmatunan Judah e hi-gatuddan nunman et kantuy “Beken numan ni bahul Tamar hu impahding tu, tep eggak peahwan hi-gatu hi Selah.” Eleg tu law iulig hi Tamar. ");
INSERT INTO ify_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Yan nedatngan ni pan-ungngaan Tamar, ey neamta e nandupi-il hu u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Yan eman ni tuka ideggedeggeh ey indewdew etan ni hakey hu ngamay tu. Et ya etan biin meneyya ey, binedbedan tun madlang ni sinulid et kantuy “Huyya nemangulu.” ");
INSERT INTO ify_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nem entanniy ginuyud etan ni gelang hu ngamay tu et ya etan hakey hu nebukul ni neukat. Et kan etan ni biin nenaya “Hipa impahding mu et ka nebukul ni neukat?” Et ngadanan tun Peres. ");
INSERT INTO ify_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Neukat ali dama etan gelang ni nebedbedan ni sinulid hu ngamay tu et ngadanan tun Serah. ");
INSERT INTO ify_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yan dintengan idan helag Ismael di Egypt ey inggatang da Joseph nan Potipar e ap-apun guwalyad baley patul. ");
INSERT INTO ify_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hi Joseph ey wadan ingganah hi Apu Dios ni kaumbaddang ni hi-gatu et yan nunman ni nanha-adan tud baley Potipar ey kayyaggud hu nambalinan ni emin ni impahding tu. ");
INSERT INTO ify_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Et humman ni ap-apu e hi Potipar ey inamta tu e kabaddangin Apu Dios hi Joseph di emin ni tuka pehding. ");
INSERT INTO ify_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pinpinhed Potipar hi Joseph et pambalin tun hi-gatu mengippaptek ni emin ni wadad baley tu niya emin ni limmu tu. ");
INSERT INTO ify_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Et meippalpun nanha-adan Joseph diman ey binendisyonan Apu Dios ni emin hu impahding tud baley Potipar, anin niyadda daka ingngunud payew. ");
INSERT INTO ify_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hi Joseph law hu nengi-kudan Potipar ni emin ida etan ni wadad nanha-dan tu. Mukun hi Potipar ey endi law danag tu e ebuh law pinhed tun kennen ni kewa-wa-wan tuka nemnemnema. Hi Joseph ey kat-agun peteg niya kayyaggud hu impenga-annel tu. ");
INSERT INTO ify_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Et entanni ey wada neminhed etan ni ahwan Potipar ni hi-gatu et lektattuy kantun Joseph ey man-ullig ida. ");
INSERT INTO ify_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nem eleg ebbulutan Joseph ni pehding humman. Kantuy “Eleg mabalin ni nak pehding huttan. Ang-ang mu kedi e indinel ni apuk ni hi-gak ni emin eyan wadad baley yu. ");
INSERT INTO ify_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ma-nu tep nan-ingngeh hu kelebbengan min dewwa eyad baley, nem eleg daka idinel ni hi-gak tep ahwa dakan hi-gatu. Et humman hu, eleg mabalin ni nak pehding hu henin nuntan ni lawah ni peteg ni panliwwatan nan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Eleg mengmenghep humman ni ahwan Potipar et kewa-wa-wa ey tuka eyyaeyyagi hi Joseph ma-lat man-ulig ida, nem eleg pinhed Joseph anin ni ya tu pekiyuyyuddungan ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wada hakey ni aggew e himmegep hi Joseph e tu ippahding hu ngunu tu ey neipaddih ni endin hekey hu bega-en etan di baley. ");
INSERT INTO ify_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Et itnged etan ni ahwan Potipar di balwasin Joseph et kantuy “Ikay et ita man-ulig.” Nem bimmesik hi Joseph di dallin ey nela-nih balwasi tu et katetengngeda etan ni bii. ");
INSERT INTO ify_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yan nenang-angan etan ni bii e nanengtun tuka tetengngeda etan balwasin Joseph ");
INSERT INTO ify_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ey nantetekkuk et umlidda etan bega-en da ey kantuy “Ang yu kedi hu impahding etan ni Hebrew ni in-anemut ni ahwak e daitsu ni-ngangu be-ingen. Himmegep di kuwaltuh ku et tuwak et pilliten ni i-ulig, nem nantetekkukkak ");
INSERT INTO ify_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","et bumsik di dallin et adyadeh eya balwasi tu e eleg tu hanguden.” ");
INSERT INTO ify_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Et itlu tu humman ni balwasin Joseph ingganah ni immanemut etan ahwatun nunman ni hileng. ");
INSERT INTO ify_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Et idaddatteng tu e kantuy “Ang mu kedi etan in-anemut mun Hebrew e himmegep di kuwaltuh e tuwak et pilliten ni i-ulig. ");
INSERT INTO ify_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nem nantetekkukkak et bumsik di dallin e eleg tu hanguden eya balwasi tu.” ");
INSERT INTO ify_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Dingngel Potipar humman ni inhel ahwatu ey nemahhig hu bunget tu. ");
INSERT INTO ify_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Et tu pakelabut hi Joseph e an nei-dum idan edum ni impakelabut etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nem nanengtun kabbabbal hi Apu Dios ni hi-gatu. Et humman hu, pinpinhed etan ni ap-apud kallabbuttan. ");
INSERT INTO ify_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Impambalin tu hi Joseph ni ap-apuddan emin ni balud niya hi-gatu ngenamung emin ni kameipahpahding di kallabbuttan. ");
INSERT INTO ify_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ya etan ap-apud kallabbuttan ey kamedinnel ni kapehpehding nan Joseph tep inamta tu e kabaddangin Apu Dios et kayyaggud hu kapambalinin tuka pehding. ");
INSERT INTO ify_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Entanni et wadan pinhakkey hu bimmunget etan patul, tep wada nambahulan etan ni kamengapyan sinapay et ya etan kamampaptek ni meinnum ni innumen tu. ");
INSERT INTO ify_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Et ikelabut tudda etan di neikelabutan Joseph di baley etan ni ap-apuddan guwalya. ");
INSERT INTO ify_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Neayepaw idadman et ya etan ap-apun guwalya ey impambalin tu hi Joseph ni mampaptek ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Hakey ni hileng ey wada ini-innep idan nunman ni dewwan balud ey nambaklang keibbellinan da. ");
INSERT INTO ify_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yan newa-waan tu et lumaw hi Joseph di kad-an da ey inang-ang tu e ida kaumlelemyung. ");
INSERT INTO ify_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Et kan Joseph ni hi-gaday “Kele kayu kaumlelemyung ni nunya?” ");
INSERT INTO ify_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Himmumang ida ey kanday “Tep wada ini-innep mi, nem endi mengippeamtan keibbellinan da.” Kan Joseph ey “Hi Apu Dios hu kamengidwat ni kabaelan ni mengippeamtan keibbellinan ni i-innep. Ehel yun hi-gak hu ini-innep yu.” ");
INSERT INTO ify_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kan etan ni kamampaptek ni meinnum ey “Ya ini-innep ku ey wada kumangngu etan neitnem ni grapes ni ");
INSERT INTO ify_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","tellu panga tu. Entanni ey himmabung et anggagannuy neluum. ");
INSERT INTO ify_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nakka tettengngeda etan basuh ni patul et pihpihen ku etan grapes di basuh et idwat kun patul.” ");
INSERT INTO ify_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kan Joseph ni hi-gatu ey “Ya keibbellinan nuntan ni ini-innep mu ey heninnuy: Ya etan tellun panga ey tellun aggew. ");
INSERT INTO ify_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Melebbah hu tellun aggew, ey ibbukyat daka etan ni patul et pambangngad daka etan di ngunum dedan ni nunman. ");
INSERT INTO ify_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yan pambangngadam alid ngunum ey entan tuwak anhan liwwan et pakie-ehhel muwak etan ni patul et ilah tu-et ey ibbukyat tuwak dama. ");
INSERT INTO ify_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tep hi-gak ey imbesik da-ak alid bebley min Hebrew et igtang da-ak di deya. Et yan nunya ey iyyadya-ak eyad kallabbuttan anin ni endi nak impahding ni lawah.” ");
INSERT INTO ify_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Dingngel etan ni kamengapyan sinapay e kayyaggud hu keibbellinan ni i-innep etan ni kadwa tu ey kantu daman Joseph ey “Ya ini-innep ku ey wada kumangngu in-agtuk ni tellun basket. ");
INSERT INTO ify_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Yad etan di nanta-pew ni basket ey wadan emin hu nambakbaklang ni sinapay ni kennen etan ni patul. Nem immalidda sisit et kanen da.” ");
INSERT INTO ify_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kan Joseph ey “Ya keibbellinan ni tellun basket ey tellun aggew. ");
INSERT INTO ify_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Melebbah hu tellun aggew et peputtul etan ni patul hu ulum. Ey itta-yun tu annel mud keyew et pan-in-e-kanan idan sisit.” ");
INSERT INTO ify_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Entanni et malebah tellun aggew ey humman ni aggew hu neiungngaan etan ni patul et manhahamul ida etan idan opisyal tud baley tu. Et pa-hep tud kallabbuttan etan kamampaptek ni meinnum niya etan kamengapyan sinapay et paeyag tuddad kad-an tu. ");
INSERT INTO ify_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ya etan kamampaptek ni meinnum ey impambangngad tud ngunu tun nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nem ya etan kamengapyan sinapay ey impapetey tu. Humman idan neipahding ey humman hu inebig nan Joseph ni keibbellinan ni i-innep da. ");
INSERT INTO ify_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nem ya etan kamampaptek ni kainnuman patul ey liniwwan tu hi Joseph. ");
INSERT INTO ify_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nelabah dewwan toon ey ini-innep etan ni patul e kaman-eh-ehneng kumangngud gilig ni Wangwang e Nile. ");
INSERT INTO ify_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ey pinhakkeyey wada neukat etan di wangwang ni pitun mangkateban baka et ipa-yuh dan mengngan ni helek di gilig tu. ");
INSERT INTO ify_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Entanni mewan ey neukat ida dama hu pitun nangkepigut ni baka. Limmaw idad kad-an etan idan mangkateban baka ");
INSERT INTO ify_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","et entanni ey kinan dadda humman ni mangkateban baka. Ey inggibek etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nambangngad ni neugip ey nan-i-innep mewan. Ey inang-ang tu e wada simmemel ni hakey ni pagey e wada pitun udeng tun makabgah niya na-teng. ");
INSERT INTO ify_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Entanni mewan ey neukat pitun udeng tun nekupeh tep ya maetung ni dibdib ni kamelpud kasimmilin aggew. ");
INSERT INTO ify_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Entanni ey kinan idan nekupeh ida etan mabgah. Inggibek etan ni patul ey inamta tu law e nan-i-innep. ");
INSERT INTO ify_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Yan newa-waan tu ey tuka pannenemnem humman idan ini-innep tu et tudda paeyag ni emin hu nengamtan magic niyadda nangkenemneman di Egypt. Inhel tun hi-gada hu ini-innep tu, nem endi hakey ni nengamtan keibbellinan tu. ");
INSERT INTO ify_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Entanni ey kan etan ni kamampaptek ni meinnum etan ni patul ey “Yan eman ni nambahulan mi lan nunman ");
INSERT INTO ify_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ey bimmunget kan hi-gami etan ni kamengapyan sinapay et pakelabut dakemi etan di baley ni ap-apuddan guwalya. ");
INSERT INTO ify_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Hakey ni hileng ey wada ini-innep min dewwan nambaklang hu keibbellinan tu. ");
INSERT INTO ify_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ey wada etan kat-agun Hebrew ni edum min neikelabut e bega-en etan ni ap-apun guwalya. Inhel min hi-gatu ini-innep mi et ehlen tu hu keibbellinan tu. ");
INSERT INTO ify_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ey makulug numan ni neipahding hu inhel tun keibbellinan ni ini-innep mi. Hi-gak ey nambangngad dak di ngunuk, ey ya etan kamengapyan sinapay ey impapetey mu.” ");
INSERT INTO ify_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Et paeyag etan ni patul hi Joseph et pa-hep dad kallabbuttan. Nampepu-lit et hullulan tu balwasi tu et lumaw di kad-an etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Et ehlen etan ni patul ni hi-gatu hu ini-innep tu. Kantuy “Wada ini-innep ku, nem endi nengamtan keibbellinan tu. Kanday inamtam kunu keibbellinan ni i-innep et mukun impaeyag daka.” ");
INSERT INTO ify_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Himmumang hi Joseph ey kantuy “Apu, endi kabaelan kun menghel ni keibbellinan ni ini-innep mu. Nem hi Apu Dios hu menghel ni kayyaggud ni keibbellinan tu.” ");
INSERT INTO ify_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kan etan ni patul ey “Ini-innep ku e nakka man-eh-ehneng di gilig ni Wangwang e Nile ");
INSERT INTO ify_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ey wadadda pitun mangkateban bakan neukat etan di wangwang et ipa-yuh dan mengngan ni helek etan di gilig tu. ");
INSERT INTO ify_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Entanni mewan ey neukat ida hu pitun bakan nangkepigut. Humman idan baka hu kepippiggutan di emin ni bakan inang-ang kudya Egypt. ");
INSERT INTO ify_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Entanni ey kinan dadda etan mateban baka. ");
INSERT INTO ify_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nem endi hu tu kei-ang-angan tep nanengtun nepippigut ida. Et entanni ey inggibek ku. ");
INSERT INTO ify_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Entanni ey neuyengngak mewan ey ini-innep ku e wada simmemel ni hakey ni pagey e wada pitun udeng tun makabgah ey na-teng. ");
INSERT INTO ify_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Entanni ey neukat mewan pitun udeng tun kinupeh ni dibdib ni kamelpud appit ni kasimmilin aggew. ");
INSERT INTO ify_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ey yadda etan nekupeh ni pagey, ey kinan dadda etan makabgah. Inhel kuddan nengamtan magic huyyaddan ini-innep ku, nem eleg da amta hu keibbellinan da.” ");
INSERT INTO ify_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kan Joseph etan ni patul ey “Huttan ni dewwan ini-innep mu ey nan-ingngeh hu keibbellinan da. Hi Apu Dios ey impeamta tun hi-gam hu pehding tullin edum ni aggew. ");
INSERT INTO ify_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Yadda etan pitun mateban baka niyadda etan pitun mabgah ni pagey ey nan-ingngeh hu keibbellinan da e pitun toon. ");
INSERT INTO ify_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Yadda etan pitun bakan nepigut niyadda etan pitun nekupeh ni pagey ey pitun toon ni bisil. ");
INSERT INTO ify_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Humman etan kangkun nuntan ni impeamtan Apu Dios ni hi-gam hu ippahding tulli. ");
INSERT INTO ify_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yadya Egypt ey wadalli pitun toon ni dakel alin peteg hu ennien yu. ");
INSERT INTO ify_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Nem meittu-nud ali hu pitun toon ni bisil. Nemahhig ali humman ni bisil et mebahbah ali eya bebley, et meliwwan ida la etan nelabah ni kayyaggud ni toon ni dakel kennen. ");
INSERT INTO ify_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ey nampidwa hu nengi-innepan mu tep makulug ni peamnun Apu Dios ey anggegannu keippahdingan tu. ");
INSERT INTO ify_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Et humman hu, heninnuy hu mahapul ni pehding mu. Pilim hu hakey ni nenemneman niya nelaing ni mengippaptek eyan bebley. ");
INSERT INTO ify_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Ey pili kan edum ni aap-apu ma-lat da amungen hu hakey di liman betek ni meennin nunman ni pitun toon ni dakel hu kennen. Emmungen dan emin humman di aallang et guwalyaan da. ");
INSERT INTO ify_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Humman hu pehding mu ma-lat wadalli kennen ni nunman ni kedettengan ni pitun toon ni bisil et eleg matey ida tuun upa da.” ");
INSERT INTO ify_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ya etan patul niyadda etan opisyal tu ey pininhed da humman ni planuh ni inhel Joseph. ");
INSERT INTO ify_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Et kan etan ni patul idan opisyal tuy “Endi edum ni mei-ingngeh nan Joseph tep wadan hi-gatu ispirituh Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kan etan ni patul nan Joseph ey “Tep ay hi-gam hu nengipeamtaan Apu Dios ni nuntan ey humman kei-ang-angan tu e endi edum ni henin hi-gam e nenemneman niya nelaing. ");
INSERT INTO ify_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Et humman hu, puttuken dakan meihhayned ni hi-gak ni man-ap-apu eyad bebley. Et emin hu tuu ey u-unnuden da e-helen mu. ");
INSERT INTO ify_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yan nunya ey hi-gam hu gobernor emin eyad bebley di Egypt.” ");
INSERT INTO ify_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Et ukhupen etan ni patul etan singsing tun nemalkaan ni sinyal tu et ihuklub tud galumeymey Joseph. Humman ni nengidwatan etan ni patul ni singsing tun Joseph hu kei-ang-angan tu e hi Joseph law hu gobernor. Impebalwasian tun kakkayyaggud ni balwasi niya impebanggelan tun balituk. ");
INSERT INTO ify_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ey indawat tun hi-gatu etan kapanlugganin neihayned ni ap-apud Egypt. Et panlugan tu hi Joseph et ida kamenglaw ey wadadda kamemengngulun kaumtenekkutekkuk ma-lat kumiwang ida tuun pengippeang-angan dan lispituh dan hi-gatu. Et hi Joseph law hu gobernor di Egypt. ");
INSERT INTO ify_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kan etan ni patul ni hi-gatuy “Hi-gak hu patul di deya Egypt, nem hedin wada eleg mu i-abulut ey eleg mabalin ni meippahding.” ");
INSERT INTO ify_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Ingngadnan tu hi Joseph ni hi Saphenat Paneah e ngadan ni iEgypt niya impeahwa tun hi-gatu hi Asenat e u-ungngan Potipera e padid Heliopolis. Yan nunman ni nanggobernor hi Joseph di Egypt ey telumpulu toon tu. Et yan nunman ey tu inang-ang ni emin hu bebley diman. ");
INSERT INTO ify_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yan nemangulun pitun toon ey makulug tu-wangun dakel ni peteg hu kennen di kebebbebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Et paemung Joseph idad alang ni kinapyan gubilnu hu ineniddan tuud emin diman ni bebley. ");
INSERT INTO ify_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nemahhig e dakel kennen et isiked law Joseph ni manlelkud tep heni kadinakkel ni palnah di gilig ni baybay. ");
INSERT INTO ify_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ya nin nunman ni eleg pay medatngan hu bisil ey dewwa hu u-ungngad Joseph nan Asenat. ");
INSERT INTO ify_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ya impangngadan Joseph etan ni pengulwan ey hi Manasseh tep kantuy “Hi Apu Dios hu nenga-alluk ni hi-gak di nanhelheltapan ku niyad neidawwian kun ama.” ");
INSERT INTO ify_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya etan neikadwa ey nginadnan tun hi Epraim tep kantuy “Hi Apu Dios hu nengidwat ni u-ungngak eyad bebley ni nanhelheltapan ku.” ");
INSERT INTO ify_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Entanni ey nepappeg etan pitun toon ni dakel kennen di Egypt. ");
INSERT INTO ify_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Neilepu law etan bisil ni immamnu etan inhel Joseph. Emin di kebebbebley ey na-puhan idan kennen, nem yad Egypt ey dakel hu kennen diman. ");
INSERT INTO ify_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Entanni ey anin idan iEgypt et ida kamangke-puhin kennen et ida mambaga etan ni patul da. Nem kan etan ni patul ni hi-gaday “Kayu pambagan Joseph et ngenamung hu e-helen tu.” ");
INSERT INTO ify_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nemahhig law hu bisil di kebebbebley di Egypt et pebeghul Joseph ni emin etan aallang et pan-igtang tuddan katuutuudman hu in-alang da. ");
INSERT INTO ify_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Entanni ey kamampengellid Egypt hu tutu-ud edum ni bebley ni an umgatang nan Joseph ni kennen tep nemahhig hu bisil. ");
INSERT INTO ify_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Dingngel Jacob e wada kennen di Egypt et kantuddan u-ungnga tuy “Kele kayu kamanhintetkel ni ebuh e kayu kametemman pehding yu? ");
INSERT INTO ify_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Deh e dingngel ku e wada kennen di Egypt. Lakkay et kayulli gumtang ni kennen tayu ma-lat eleg itsu matey ni upa.” ");
INSERT INTO ify_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Et lumaw ida etan hampulun u-ungngan Jacob ni an umgatang ni kennen di Egypt. ");
INSERT INTO ify_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Eleg pakilaw nan Jacob hi Benjamin tep kaumkaguh ni entanniy wada meippahding daman hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Humman idan u-ungngan Jacob ey nekilaw idan edum ni tuun limmaw ni an umgatang ni kennen di Egypt tep anin ni yad Kanaan et bisil damadman. ");
INSERT INTO ify_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Hi Joseph e gobernor di Egypt hu kagettangiddan tutu-un kennen. Et mukun yad kad-an tu hu linawwan ida agitu et manyuung idad hinangga tun pengippeang-ang dan lispituh dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Yan nenang-angan nan Joseph idan agitu ey inimmatunan tudda. Nem eleg da immatunan hi Joseph e agi da. Et ya impahding Joseph ey immpeang-ang tu e heni eleg tudda amta et tuka pambinungnget hu tuka pan-e-ehhel ni hi-gada e kantuy “Ettu bebley ni nalpuan yu?” Himmumang ida agitu e kanday “Nalpu kamid Kanaan. Immali kamin umgatang ni kennen.” ");
INSERT INTO ify_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ninemnem Joseph hu ini-innep tun nunman meippanggep ni hi-gada. Et kantun hi-gaday “Tam immali kayun an mansi-im ni hi-gami ma-lat amtaen yu elaw eyan bebley mi hedin dammutun apputen dakemid gubat.” ");
INSERT INTO ify_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kanday “Apu, endi katteg hu henin nuntan ni nemnem mi, tep hi-gamin bega-en mu ey immali kamin umgatang ni kennen mi. ");
INSERT INTO ify_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Han-aaggi kami e u-ungnga dakemin hakey ni tuu. Kayyaggud ngu nemnem mi, bekken ni ya an mansi-im hu in-ali midya.” ");
INSERT INTO ify_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nem kaippilit nan Joseph e kantuy “Itek yu, immali kayu kumaddan ni mansi-im.” ");
INSERT INTO ify_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Et kan da mewan ni humang day “Makulug e apu et endi huttan ni nemnem mi. Hampulut dewwa kamin han-aaggin u-ungngan hakey ni tuud Kanaan. Nanha-ad ali etan udidyan di kad-an amemi, ya etan hakey ni agi mi ey neendi.” ");
INSERT INTO ify_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nem kaippilit nan Joseph e kantuy “Eleggak kulluga hu inhel yu. Inamtak et immali kayun an mansi-im. ");
INSERT INTO ify_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ya pematnak ni hi-gayu ma-lat pengamtaan ku hedin bekken ni itek huttan ni inhel yu ey eleg kayu um-anemut ingganah ni um-alidya etan udidyan yu. Et huyyan inhel ku ey mandal metlaing etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Et humman hu, mahapul ni umlaw ali hakey ni hi-gayun an mengewwit etan ni udidyan yu. Hi-gayun edum ey meikkellabut kayu et maguwalyaan kayu ingganah ni amtaen ku e makulug hu inhel yu. Tep hedin itek hu inhel yu ey humman keang-angan tu e makulug ni immali kayun mansi-im.” ");
INSERT INTO ify_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Et pakelabut Joseph idan tellun aggew. ");
INSERT INTO ify_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Yan meikkatlun aggew ey kan Joseph ni hi-gaday “Hi-gak ey hi Apu Dios hu nakka u-unnuda, et humman hu, eleg dakeyu pepettey hedin u-unnuden yu eya e-helen kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Anin ni ya hakey ni ebuh ni hi-gayu hu meikkellabut et anin ni umlaw kayun edum ma-lat ilaw yu etan gintang yun kennen et eleg ida matey ni upa etan ida hini-yan yud bebley yu. ");
INSERT INTO ify_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nem mahapul ni ikkuyug yulli etan udidyan yu et pengamtaan kun beken ni itek etan inhel yu et eleg dakeyu papetey.” Ey inebulut idan han-aaggi humman ni inhel Joseph. ");
INSERT INTO ify_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wada hakey ni hi-gada ey kanday “Yan nunya ey tayu kahelheltapa law etan nambahulan tayu la etan ni agi tayun hi Joseph. Inang-ang tayun nunman hu hineltap tun nampehemmehemmekan tun hi-gatsu, nem eleg tayu hemeken.” ");
INSERT INTO ify_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Et kan Reuben ey “Kan ku dedan ey entan kuma dakel hu yu pehding ni hi-gatu, nem eleg yuwak dengelen. Et yan nunya ey meibleh ni hi-gatsu hu neendian tu.” ");
INSERT INTO ify_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hi Joseph ey inawtan tu humman ni inhel da, nem kan da na-mu nem eleg tu han-awat tep hedin mekihhummangan idan hi-gatu, man wada kamengibbellin ni daka e-hela. ");
INSERT INTO ify_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Hini-yan Joseph ida et an mannannangngih. Et han mambangngad et hi Simeon hu impabelud tu e kaang-angaddan agi tu. ");
INSERT INTO ify_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Inhel Joseph ida etan ni bega-en tu e ha-adan dadda langgusih da niya ibbangngad dadda pihhuh da e itta-pew daddad langgusih da. Ey iddaddanan daddan balun dan kennen dad dalan. ");
INSERT INTO ify_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Negibbuh ni neidaddan hu kalga da et itakkay idan nunman ni agin Joseph di kebayyu da et manglaw ida. ");
INSERT INTO ify_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Entanni ey nehilngan ida et mandeyaddad dalan. Ey inubad etan ni hakey hu bedbed ni langgusi tu ma-lat umlan pekkan tun kebayyu tu ey inang-ang tu etan pihhuh ni impameyad tun neita-pew di langgusih tu. ");
INSERT INTO ify_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Et kantuddan agi tuy “Keyuy kedi et ang-angen yu, tam imbangngad da etan pihhuh ni imbayad ku. Adyah e inta-pew dad langgusih ku.” Ey simmakut ida e kanday “Nekele hanneya kapehding nan Apu Dios ni hi-gatsu?” ");
INSERT INTO ify_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Immanemut idad Kanaan et ehlen dan amedan emin hu neipahding ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kanday “Ya etan gobernor ey tuka pambinungnget ni meki-ungbal ni hi-gami. Kantuy limmaw kamin mansi-im di bebley da. ");
INSERT INTO ify_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kan min hi-gatuy ‘Bekken ni kami mansi-im tep kayyaggud ngu nemnem mi. ");
INSERT INTO ify_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hi-gami ey hampulut dewwa kamin han-aaggin u-ungngan hakey ni tuud Kanaan. Nanha-ad ali etan udidyan di kad-an amemi ey ya etan hakey ni agi mi ey neendi.’ ");
INSERT INTO ify_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ey kan etan ni gobernor ey ‘Ya pengamtaan ku hedin makulug hu inhel yu ey manha-ad ni hu hakey ni hi-gayu et umenamut kayun edum ma-lat ienamut yu hu gintang yun kennen et eleg ida matey ni upa etan ida hini-yan yud bebley yu. ");
INSERT INTO ify_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nem hedin um-ali kayu mewan ey mahapul ni ikuyug yulli etan udidyan yu ma-lat pengamtaan ku e beken ni itek hu inhel yun beken ni kayu mansi-im. Et han nak pa-hep di kallabbuttan etan agiyu niya dammutun um-ali kayu mewan ni umgatang ni kennen yu.’” ");
INSERT INTO ify_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Entanni et ubaden dan emin hu bedbed di langgusih da ey nei-peng di langgusih da hu pihhuh ni imbayad da. Ey simmakut ida, anin ni hi ameda e hi Jacob. ");
INSERT INTO ify_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Et kan amedan hi-gaday “Tam pinhed yun meendin emin hu u-ungngak. Neendi hi Joseph, ey neitu-nud mewan hi Simeon. Ey yan nunya mewan ey kanyuy ikkuyug yu hi Benjamin? Tam yuka ma-ma-maa hu nakka panhelheltapi.” ");
INSERT INTO ify_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nem kan Reuben nan hi ametuy “Hi-gak hu ngenamung e ama. Hedin eggak i-anemut hi Benjamin, man anin ew katteg ni petteyen mudda etan dewwan u-ungngak.” ");
INSERT INTO ify_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nem kan Jacob ey “Eleg mabalin ni mekillaw eya u-ungngak e hi Benjamin di Egypt. Tep inamta yu e hi-gatun ebuh natdaan ni u-ungnga min Rachel tep neendi etan hakey. Entanni mewan ey wada hu meippahding ni hi-gatud dalan. Hi-gak ey nea-amma-ak law et metteyyak hedin meendi eya u-ungngak.” ");
INSERT INTO ify_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nanengtun nemahhig hu bisil di Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Et yan na-puhan ni kennen ni da gintang, ey kan Jacob idan u-ungnga tuy “Lakkayuy ew mewan di Egypt et kayulli gumtang ni kennen tayu.” ");
INSERT INTO ify_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ey kan Judah ey “Em, nem kan mannuman etan ni gobernor ey eleg dakemi kunu i-abulut ni menang-ang ni hi-gatu hedin eleg mi ikkuyug etan udidyan mi. ");
INSERT INTO ify_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Et humman hu, hedin i-abulut mun mekillaw hi Benjamin ey umlaw kamin an umgatang ni kennen tayu. ");
INSERT INTO ify_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nem hedin eleg mu i-abulut ey eleg kami umlaw tep kan etan ni gobernor ey ‘Eleg dakeyu i-abulut ni menang-ang ni hi-gak hedin eleg yu ikkuyug etan agi yu.’” ");
INSERT INTO ify_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kan Jacob ey “Kele dedan yu inhel e wada hu hakey ni agi yu? Tam yuka ma-ma-maa hu nakka panhelheltapi!” ");
INSERT INTO ify_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kanday “Tep kantuy ‘Kaw mategu hi ameyu niya kaw wada pay hu edum ni agi yu?’ Et mahapul ni hummangen midda humman ni imbagetu. Kaw hipa nengamtaan mi e tu e-helen e mahapul ni ikkuyug mi etan agi mi?” ");
INSERT INTO ify_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Et kan Judah nan ametuy “Iebulut mun mekillaw hi Benjamin et lumaw kami ma-lat endin hi-gatsu hu mettey ni upa. ");
INSERT INTO ify_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Anin ni hi-gak hu ngenamung. Hedin eleg ku i-anemut ey hi-gak ali hu kambahul ni ingganah. ");
INSERT INTO ify_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Gullat et ni eleg kami metaktak wada-et ni nampidwa kamin limmaw.” ");
INSERT INTO ify_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Et kan ameday “Hedin henin nuntan, ey ala kayun hipan kakkayyaggud ni wada eyad bebley et idwat yu la etan ni gobernor. Ala kayun danum ni putsukan, ya kaikkamdug di ihhida, ya bangbanglun insensoh niyadda edum ni lameh ni intanem. ");
INSERT INTO ify_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ey mahapul ni edumi yu ellan yun pihhuh, et ibangngad yu etan pihhuh ni imbangngad dad ta-pew ni langgusih yu eman ni linawwan yu lan laputu tep nehimeng ida na-mu. ");
INSERT INTO ify_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Anin ew katteg ni ikuyug yu eya agiyu et lumaw kayu. ");
INSERT INTO ify_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hi Apu Dios e Kabaelan tun emin hu ngenamung ni memaddang ni hi-gayu ma-lat hemeken dakeyu etan ni gobernor et paenamut tulli hi Benjamin niya ma-lat pa-hep tud kallabbuttan hi agiyun hi Simeon et umenamut kayun emin. Nem hedin kantu et kapyatun wada meippahding ni hi-gada, ey ngenamung ew katteg diman!” ");
INSERT INTO ify_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Inu-unnud da humman ni inhel ameda et umladdan iddawat da etan ni gobernor niya induman da hu intabin dan pihhuh et lumaw ida e ingkuyug da hi Benjamin di Egypt. Et lumaw idad kad-an etan ni gobernor e hi Joseph. ");
INSERT INTO ify_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Inang-ang Joseph hi Benjamin ey kantu etan ni bega-en tun kamampaptek di baley tuy “Ipengulum idad baley ku niya keleng kayun ihhidemi tep mekikkan idan hi-gak ni emaggew.” ");
INSERT INTO ify_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inu-unnud etan ni bega-en et ipengulu tuddad baley Joseph. ");
INSERT INTO ify_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yan daka pampengillawwin hi-gada ey ida kaumkenebkeb et kanday “Mukun mannuman illaw daitsudman ey ya etan pihhuh ni imbayad tayun laputun imbangngad dad langgusih tayu. Nungay ngun pambalinen daitsun bega-en et peki-la dadda eya kebayyu tayu?” ");
INSERT INTO ify_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Dimmateng idad heggeppan di baley Joseph ey kanda etan ni bega-en ni kamampaptek di baley tuy ");
INSERT INTO ify_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Apu, hi-gamidda la etan immalin gimmatang ni kennen. ");
INSERT INTO ify_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Immali kami mewan ni umgatang ni i-anemut mi. Nem yan eman ni laputun gintangan mi et umenamut kami ey inang-ang mi e nei-peng di langgusih mi etan pihhuh ni imbayad mi. Ey eleg mi amta hedin hipa nengiha-ad diman. Et humman hu, adyah e impeki-la mi ma-lat ibangngad mi.” ");
INSERT INTO ify_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ey kan etan ni bega-en ey “Entan pandanag yu niya entan takut yu tep hi Apu Dios e kadeyyawan ameyu hu nengiha-ad ni nunman ni pihhuh. Tep inlak ida ngu etan pihhuh ni imbayad yu.” Entanni ey impaukat tu hi Simeon ");
INSERT INTO ify_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","et han tu pahgep idan emin di baley Joseph. Ey nandaddan ni danum ni pengullah dan heli da et pangan tudda hu kebayyu da. ");
INSERT INTO ify_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Inukat ida etan ni han-aaggi etan iddawat dan Joseph ni ellian tun emaggew tep dingngel da e mekikkan idan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Immanemut hi Joseph et idwat da etan inla dallid bebley dan iddawat dan hi-gatu et manyuung idan panlispituh dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Imbagetun hi-gada hedin inna-nudda. Ey kantuy “Inhel yu lan nunman e nea-amma law hi ameyu. Kaw nanengtun mategu?” ");
INSERT INTO ify_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Himmumang ida ey kanday “Em apu, nanengtun mategu hi amemi.” Et manyuung ida mewan ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Intekel nan Joseph hi Benjamin e agitun mismuh ey kantuy “Kaw huyya etan kan yun udidyan yu? Bendisyonan dakan Apu Dios e u-ungnga.” ");
INSERT INTO ify_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Entanni ey eleg han-isipel nan Joseph hu nangih tun nenang-angan tun agi tu et papuut tun umhep et lumaw di kuwaltuh tu et an mannannangngih diman. ");
INSERT INTO ify_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Insiked tu nangih et manda-lup et han maukat et ehlen tuddan bega-en tun iddaddan da hu kennen. ");
INSERT INTO ify_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Neappil hi Joseph ni nengan di hakey ni tebol et yadda dama agi tud hakey ni tebol. Neappil ida dama etan iEgypt ni mengngan tep eleg da pinhed ni mei-dum ni mekikkan idan Hebrew tep nebabah hu daka penang-ang ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Natngadda etan agin Joseph tep impanhenehened daddan impayudung meippalpud pengulwan ingganah di udidyan e inhangga dan Joseph. ");
INSERT INTO ify_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ya etan kennen da ey daka an ellad tebol Joseph. Daddakkel indawat dan kennen nan Benjamin e mampillima kedakkel tu nem ya indawat dan kennen idan agitu. Et makangngan idan emin et manginum ida. ");
INSERT INTO ify_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Entanni ey kan Joseph etan ni bega-en ni kamampaptek di baley tuy “Panhuduim hu sakuh da, ngenamung hu kabaelan dan tetngeden. Ey ibangngad mu pihhuh da e ita-pew mud Langgusih da. ");
INSERT INTO ify_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Niya ita-pew mu etan silver ni basuh kud langgusih ni udidyan.” Et u-unnuden etan ni bega-en. ");
INSERT INTO ify_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Yan newa-waan tu ey himmaleman idan limmaw e ingguyud dadda hu kebayyu da. ");
INSERT INTO ify_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nem eleg ida meidawwi ey kan Joseph etan ni bega-en tuy “Lakkay, unud mudda eman han-aaggi. Hedin ha-kupen mudda, kammun hi-gaday ‘Kele kakkayyaggud hu impeang-ang ni apuk hi-gayu ey lawah yu impahding? ");
INSERT INTO ify_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kele yu impeki-la etan nekangnginan basuh etan ni apuk? Humman ni basuh hu tuka innumi niya tuka ussalan man-ebbig. Et-eteng ni bahul huttan ni impahding yu.’” ");
INSERT INTO ify_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Et maiunud etan bega-en ey hina-kup tudda et ehelen tun hi-gada etan inhel Joseph. ");
INSERT INTO ify_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nem kandan hi-gatuy “Apu, hipa huttan ni muka pan-e-hela? Makulug ngu et endi mi impahding ni henin nuntan. ");
INSERT INTO ify_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tam inamtam mewan e imbangngad mi etan pihhuh ni neita-pew di langgusih min inenamutan mid Kanaan. Kele man kami menekkew ni silber winu balituk di baley ni apum? ");
INSERT INTO ify_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nem anin, ikay et panhamaken mud emin eyad langgusih mi et hedin wada hemmaken mu, ey anin papetey yu etan nengala niya pambalin dakemin edum ni bega-en tu.” ");
INSERT INTO ify_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kan etan ni bega-en ey “Dammutu huttan, nem ya pinhed ku ey ebuh etan nengalan mambalin ni bega-en. Hedin yadda edum ey dammutun um-anemut ida.” ");
INSERT INTO ify_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Et pan-epahen dadda langgusih da et wada hakkeyey inubad tu bedbed ni sakuh tu. ");
INSERT INTO ify_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Et ilepu etan ni bega-en Joseph ni menemmak di langgusih etan ni pengulwan. Entanni et dinteng tu etan langgusih etan ni udidyan ey himmak tu etan basuh. ");
INSERT INTO ify_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yadda etan han-aaggi ey nambi-ki da balwasi dan degeh ni nemnem da. Et pan-itakkay da mewan etan langgusih dad kebayyu da et mambangngad idan emin di bebley. ");
INSERT INTO ify_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Dimmateng idad baley Joseph ey immen diman et manyuung idan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ey kan Joseph ey “Kele hipa huttan ni yu impahding? Kaw eleg yu amta e dammutun amtaen ku hu impahding yu tep maebiggak?” ");
INSERT INTO ify_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kan Judah ey “Eleg mi amta ihhumang min hi-gam, apu gobernor. Ey anin ni e-helen mi hu makulug e kammiy eleg kami mambahul et endi damengu silbitu, tep huyyan neipahding ni hi-gami hu pengastigun Apu Dios ni hi-gamid nambahulan mi lan nunman. Et humman hu, anin ew katteg ni pambega-en dakemin emin ni hi-gam et beken ni ebuh etan nengalan basuh mu.” ");
INSERT INTO ify_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nem kan Joseph ey “Eleg mabalin ni nak pehding huttan! Ebuh etan nengalan basuh kun pambega-en ku. Hedin hi-gayun edum ey dammutun um-anemut kayud bebley yu di kad-an ameyu.” ");
INSERT INTO ify_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nem nekihummangan hi Judah nan Joseph et kantuy “Apu gobernor, hi-gam ey neiingngeh hu kabaelam etan ni patul, nem dengel mu anhan eya e-helen ku, entan anhan bunget mu. ");
INSERT INTO ify_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Apu, imbagam lan hi-gami eman ni laputun inlian mi hedin nanengtun wada amemi winu agimi. ");
INSERT INTO ify_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Et kammi ey ‘Wada amemin nea-amma niya wada hakey ni agi min udidyan ni newada eman ni kapangkea-ammain amemi. Ey inhel mi e wada agi etan ni agi min udidyan, nem neendi et ebuh tu law ni u-ungngan inetu. Et hi amemi ey nakappinhed tun peteg eya udidyan mi.’ ");
INSERT INTO ify_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Inhel mun hi-gamin ikkuyug mi et ang-angen mu. ");
INSERT INTO ify_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Et ehelen min hi-gam e apu e eleg mabalin ni hi-yanen tu ametu tep entanniy humman ali kumedek hu ikkatey amemi. ");
INSERT INTO ify_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nem kammuy eleg mabalin ni kami mewan mampeang-ang ni hi-gam hedin eleg mi ikkuyug huyyan udidyan mi. ");
INSERT INTO ify_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Et humman hu, yan inenamutan mid bebley mi, ey indaddatteng min amemi humman ni inhel mu. ");
INSERT INTO ify_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Et yan na-puhan ni gintang min kennen di deya ey kan amemi ey um-ali kami mewan ni umgatang. ");
INSERT INTO ify_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nem inhel min hi-gatu etan inhel mu e eleg mabalin ni kami mampidwan umgatang hedin eleg mi ikkuyug huyyan udidyan mi. ");
INSERT INTO ify_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ey kan amemin hi-gamiy ‘Inamta yu e dewwan ebuh hu u-ungnga min Rachel. ");
INSERT INTO ify_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ya etan hakey ey neendi. Nanna-ud ni nebeni-ki hu annel tun impahding ni animal di muyung tep ingganah ni nunya ey endin nambangngad. ");
INSERT INTO ify_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Et hedin ikkuyug yu eya agi yu et wada mewan meippahding ni hi-gatu ey e-duman yu degeh ni nemnem ku. Ey humman umhulun ni ketteyyan ku, nema-ma tep ay nea-amma-ak law.’ ");
INSERT INTO ify_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Et yan nunya e apu, ey hedin um-anemut kami et eleg mekillaw eya udidyan mi et endi tun ang-angen amemi ey makulug ni mettey. Tep heni neitekap hu biyag tu eyad udidyan ni u-ungngatu. Ey hedin iddawtan mi amemin dedgehan ni nemnem tu ey ay nea-amma man anhan ey mettey et hi-gami kambahul. ");
INSERT INTO ify_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ya hakey mewan ey inhel kun amemi e hi-gak hu ngenamung eyan udidyan mi et hi-gak hu kambahul ni ingganah hedin endin mambangngad. ");
INSERT INTO ify_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Et humman hu, nakka ibbagan hi-gam e apu e hi-gak ew hu pambega-en mu et beken eya udidyan ni agimi ma-lat umenamut nan amemi. ");
INSERT INTO ify_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tep eleg damengu mabalin ni nak um-anemut hedin eleg mi ikkuyug eya udidyan mi, tep eggak han-ituled ni menang-ang ni lawah ni meippahding nan amemin eleg tu penang-angi eyan agimi.” ");
INSERT INTO ify_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Entanni ey eleg law han-isipel nan Joseph et pinhed tun mampeamtan hi-gada. Et pa-hep tudda bega-en tu et ebuh idad agi tu et hantu ehela e hi-gatu etan agidan hi Joseph. ");
INSERT INTO ify_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nemahhig nangih tu et dengelen idan iEgypt et da peamta etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kan tuddan agituy “Hi-gak hi Joseph. Kaw makulug ni nanengtun mategu hi ama?” Nem eleg umhumang ida etan agitu et ida kaum-eneeneng tep simmakut idan nangngelan dan inhel tu. ");
INSERT INTO ify_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kan tun hi-gaday “Keihnup kayun hi-gak.” Et meihnup idan hi-gatu. Et kantu mewan ey “Hi-gak hi Joseph e agi yun inggatang yu lan nunman ida eman ni tuun mampeellidya Egypt. ");
INSERT INTO ify_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nem entan tu pabehuli annel yu di yu impahding, tep hi Apu Dios hu kannemnem ni mengippeellidyan hi-gak ma-lat meihwang ida tuu eyad bisil. ");
INSERT INTO ify_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yan nunya hu meikkadwan ebuh ni toon ni bisil et wada pay hu liman toon et han mepappeg huyyan bisil. ");
INSERT INTO ify_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Impabukul tuwak nan Apu Dios ni impaelidya ma-lat emin itsun han-aamma niya han-aaggi ey meteggu itsu e eleg itsu mettey ni upa tayu et mahlag itsu. ");
INSERT INTO ify_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Makulug ni hi Apu Dios hu nengi-lin hi-gak di deya, beken ni hi-gayu. Et deh e impambalin tuwak ni meihhayned ni ap-apu et hi-gak hu ngenamung eyad bebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Et yan nunya, ey papuut yu et lumaw kayu et kanyun ametayuy ‘Ya etan u-ungngam e hi Joseph ey impambalin Apu Dios ni gobernor di Egypt. Inhel tu e eleg itsu mantaktaktak et lumaw itsu kumadman. ");
INSERT INTO ify_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mambebley itsud Goshen di Egypt. Ikkuyug tayudda u-ungnga niyadda inap-apu tayu, anin idan inhalun tayu niya emin ni wadan hi-gatsu et manha-ad itsudman ma-lat meihnup itsun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Manha-ad itsudman Goshen et hi-gatu ngenamung ni kennen tayu tep wada pay hu liman toon ni bisil et eleg tu pinhed ni mettey itsun upa.’” ");
INSERT INTO ify_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Immehel mewan hi Joseph ni hi-gada ey kantuy “Inamta yu law e makulug ni hi-gak hi agiyu hi Joseph, anin ni hi-gam e Benjamin. ");
INSERT INTO ify_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Et humman hu, elaw kayu ma-lat yu peamtan ametayu hu kasina-gey ni saad kudya e bebley niya ehel yun hi-gatun emin hu inang-ang yu. Imay, lakkayuy et yulli awiten.” ");
INSERT INTO ify_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Negibbuh ni inhel tu humman et akwalen tu hi agitu hi Benjamin ey kamannengngih. Et akwalen daman Benjamin e kamannengngih dama. ");
INSERT INTO ify_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nanengtun kamannengngih hi Joseph ey tudda nan-akwal etan edum ni agitu. Et entanni ey ida law kamekihuhhummangan ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Dingngel etan ni patul niyadda opisyal tu e wadadda agin Joseph ey immamleng ida. ");
INSERT INTO ify_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kan etan ni patul nan Joseph ey “Ehel muddan agim et kalgaan dadda kebayyu dan kennen et han ida mambangngad di Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ey ehel mun hi-gada et dalli awiten hi ameyu niyadda pamilyah da et umliddadya. Ittudwan kuddan kekakkayyaggudan ni puyek ni panha-adan da et eleg ida mekulngan ni mahapul da. ");
INSERT INTO ify_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Niya ehel mun hi-gada et numa-yun idan panlugganan idan aahwada niyadda u-ungnga da niya ikkuyug dalli ameyudya. ");
INSERT INTO ify_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ehel mun hi-gada e eleg ida umkakaguh ni peni-yanan dan Kanaan tep iddawat kun hi-gada hu kekakkayyaggudan ni puyek di deya Egypt ni pambebleyan da.” ");
INSERT INTO ify_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Et abuluten idan han-aaggi humman ni inhel etan ni patul. Et mandaddan idan umlaw. Indawtan idan Joseph ni panlugganan dallin mambangngad niya kennen da lad dalan tep humman inhel etan ni patul ni hi-gatun pehding tu. ");
INSERT INTO ify_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ey indawtan tuddan hanhakkey ni balwasin panhullulan da. Nem hedin hi Benjamin, man indawtan tun liman balwasi niya telunggatut ni palatah. ");
INSERT INTO ify_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Niya impalaw tun ametu hu hampulun kebayyun nangkalgan dakel ni kakkayyaggud ni wadad Egypt niya hampulun kebayyun nangkalgan pagey, ya sinapay niya edum ni mahapul dad dalan. ");
INSERT INTO ify_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Immegah ida etan agitu ey kantuy “Entan la pambabakal yud dalan.” ");
INSERT INTO ify_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hini-yan da Egypt et mambangngad idad Kanaan. Dimmateng ida et kandan ameday ");
INSERT INTO ify_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Mategu hi Joseph! Hi-gatu ap-apud Egypt!” Nem natngan peteg e eleg tu kulluga humman ni inhel da. ");
INSERT INTO ify_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nem yan nanghelan dan emin ni impaad alin Joseph et yan nenang-angan tu etan idan panlugganan dan impaelin Joseph ni mengillaw ni hi-gadad Egypt ey immamleng ni peteg. ");
INSERT INTO ify_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kantuy “Kayyaggud anhan et mategu etan u-ungngak e hi Joseph! Mahapul ni umlawwak et nak ang-angen et hannak matey!” ");
INSERT INTO ify_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Et mandaddan di Jacob e impeki-la dan emin hu wadan hi-gada et umgah ida. Dimmateng idad Beersheba et iappitan tu etan Dios eman lan ametu hi Isaac. ");
INSERT INTO ify_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yan nunman ni hileng ey nampeang-ang hi Apu Dios nan Jacob et kantuy “Jacob!” Himmumang hi Jacob e kantuy “Hipa humman e Apu?” ");
INSERT INTO ify_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","Ey kantuy “Hi-gak etan Dios ni dinaydayaw lan amam. Entan takut mun umlaw di Egypt, tep pedakkel kulli hu helag mudman. Ippaptek dakeyun lawwan yudman ey ibbangngad kuddalli helag mudya. Ey wadalli hi Joseph di kad-an mun ketteyyan mud Egypt.” ");
INSERT INTO ify_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Newa-wa et ilugan mewan idan han-aaggi hi Jacob, yadda u-ungnga da niyadda aahwa da etan di impalaw ni patul ni panlugganan et hi-yanen da Beersheba. Impeki-la dan emin hu inhalun da niyadda emin hu limmudad Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Huyya ngadan idan u-ungngan Jacob ni limmaw di Egypt. Hi Reuben e pengulwan ");
INSERT INTO ify_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","niyadda etan u-ungnga tun hi Hanok, hi Pallu, hi Hesron, et hi Karmi. ");
INSERT INTO ify_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Hi Simeon niyadda etan u-ungnga tun hi Jemuel, hi Jamin, hi Ohad, hi Jakin, hi Sohar, et hi Saul e u-ungnga tu etan di hakey ni biin iKanaan. ");
INSERT INTO ify_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Hi Levi niyadda u-ungnga tun hi Gerson, hi Kohat et hi Merari. ");
INSERT INTO ify_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Hi Judah niyadda etan u-ungnga tun hi Sela, hi Peres et hi Serah. (Netey ida dewwan u-ungngan Judah e hi Er et hi Onan eman ni wadaddad Kanaan.) Wadadda hu inap-apun Judah ni u-ungngan Peres e di Hesron nan hi Hamul. ");
INSERT INTO ify_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Hi Issakar niyadda u-ungnga tun hi Tola, hi Puah, hi Jashub et hi Simron. ");
INSERT INTO ify_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Hi Sebulun niyadda u-ungnga tun hi Sered, hi Elon et hi Jahleel. ");
INSERT INTO ify_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Huyyadda u-ungngan Jacob nan Leah eman ni wadaddad Mesopotamya, nem eleg mei-dum etan u-ungnga dan biin hi Dinah. Telumpulut tellu hu bilang dan emin. ");
INSERT INTO ify_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Hi Gad niyadda u-ungnga tun hi Sephon, hi Haggi, hi Suni, hi Esbon, hi Eri, hi Arodi et hi Areli. ");
INSERT INTO ify_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Hi Asher niyadda etan u-ungnga tun hi Imnah, hi Isbah, hi Isbi, hi Beriah et hi Serah e bii, niyadda etan inap-apun Asher e u-ungngan Beriah e di Heber nan Malkiel. ");
INSERT INTO ify_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Huyyaddan hampulut enem hu nahlag di Jacob nan Silpah e bega-en nan Leah ni indawat ametun hi Laban. ");
INSERT INTO ify_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yadda u-ungngad Jacob nan Rachel ey di Joseph nan Benjamin. ");
INSERT INTO ify_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yadda u-ungngan Joseph di Egypt ey di Manasseh nan Epraim e ya ineda ey hi Asenat e u-ungngan Potipera e padid Heliopolis. ");
INSERT INTO ify_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Yadda u-ungngan Benjamin ey hi Bela, hi Beker, hi Asbel, hi Gera, hi Naaman, hi Ehi, hi Ros, hi Muppim, hi Huppim et hi Ard. ");
INSERT INTO ify_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Huyyaddan hampulut epat hu nahlag di Jacob nan Rachel. ");
INSERT INTO ify_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Yadda pitun helag di Jacob nan hi Bilhah e bega-en nan Rachel ni indawat ametu e hi Laban ey hi Dan, yadda etan u-ungnga tun hi Hushim, hi Naptali niyadda u-ungnga tun hi Jahseel, hi Guni, hi Jesher, et hi Sillem. ");
INSERT INTO ify_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Et ya bilang emin ni helag Jacob ni limmaw di Egypt ey na-nem et enem e eleg makibilang ida ahwan u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Hedin mei-dum ida etan dewwan u-ungngan Joseph di Egypt man nepitudda. ");
INSERT INTO ify_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yan eman ni kamenetteng di Jacob di Egypt ey impemappangngulun tu hi Judah ni an menghel nan Joseph ma-lat tudda dammuen di Goshen. ");
INSERT INTO ify_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Et manlugan hi Joseph di kalesah tu et tu dammuen di ametud Goshen. Nandateng idan ametu et akwalen tu et tagan tu nangih. ");
INSERT INTO ify_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ey kan Jacob ni hi-gatuy “Anin ni metteyyak law haggud inang-ang daka ey nanengtun mategu ka.” ");
INSERT INTO ify_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Et kan Joseph nan hi ametu, yadda agitu, niyadda etan edum ni nekilaw ni hi-gada ey “Umlawwak di kad-an etan ni patul ma-lat nak peamtan hi-gatu e immali kayun nalpud Kanaan. ");
INSERT INTO ify_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","E-helen kun hi-gatu e kayu kamampattul e intabin yuddalli animal yu niya emin hu wadan hi-gayu. ");
INSERT INTO ify_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ey hedin peeyyag dakeyun hi-gatu et ibbagetu ngunu yu, ");
INSERT INTO ify_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ehel yu e neipalpun keu-ungnga yu ey kayu kamampattul e henidda lan aammed tayu. Tep hedin huyya e-helen yun hi-gatu, man yadya Goshen hu ittudu tun pambebleyan yu ma-lat meappil kayuddan iEgypt tep daka pihhuladda hu kamampattul.” ");
INSERT INTO ify_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ingkuyug Joseph hu limadda etan ni aaggi tu et lumaw idad kad-an etan ni patul et an makihummangan. Kantu etan ni patul ey “Dimmateng di ama et yadda aaggik ni nalpud Kanaan e intabin dan emin hu inhalun da niya emin hu wadan hi-gada et immen idad Goshen.” ");
INSERT INTO ify_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Et peam-amta tu etan ni patul etan ida liman agitun ingkuyug tu. ");
INSERT INTO ify_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ey kan etan ni patul ni hi-gaday “Hipa ngunu yu?” Kanday “Kami kamampattul e apu, henidda lan aammed mi. ");
INSERT INTO ify_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Immali kamin mekibbebley di deya tep nemahhig hu bisil di bebley mid Kanaan et anin ni kennen idan inhalun mi ey endi. Et humman hu, hedin i-abulut mu e apu ey yad Goshen panha-adan mi.” ");
INSERT INTO ify_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ey kan etan ni patul nan Joseph ey “Kayyaggud et immali hi amam niyadda agim. ");
INSERT INTO ify_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Anin ni ngenamung kan ittudum ni pambebleyan. Itudum ni hi-gada hu Goshen e kekakkayyaggudan ni puyek di deyad Egypt. Ey hedin wadan hi-gada hu kabaelan dan mengippattul ni halun ku ey i-kud mun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Entanni ey an inewit nan hi Joseph hi ametu hi Jacob et ilaw tud kad-an etan ni patul. Et bendisyonan Jacob etan patul. ");
INSERT INTO ify_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kan etan ni patul ni hi-gatuy “Piga toon mu?” ");
INSERT INTO ify_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ey kan Jacob ey “Hanggatut et telumpulu toon kun nunya. Neligat niya ansikkey hu biyag ku nem ya biyag ida lan aammed ku.” ");
INSERT INTO ify_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Impidwan Jacob ni binendisyonan etan patul et han ida umhep ni han-aman Joseph. ");
INSERT INTO ify_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Inu-unnud Joseph hu inhel etan ni patul et itudu tun ametu niyadda agitu etan kekakkayyaggudan ni puyek ni neihnup di Rameses di Egypt et yadman pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Indawtan Joseph ni kennen hi ametu niyaddan emin hu agitu niyadda pamilyah da meippuun di bilang da. ");
INSERT INTO ify_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Inhi-met tu hu bisil, anin di Egypt niyad Kanaan et endin hekey hu kennen idan tuu. ");
INSERT INTO ify_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Et humman hu, mahapul ni umgatang ida tuu nan hi Joseph ni kennen da. Yadda nanggatngan tu ey tuka illaw di baley etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Entanni ey endi law hu pihhuh idan tutu-ud Egypt niyad Kanaan, et yadda iEgypt ey limmaw idan mampehemmehemmek nan Joseph e kanday “Endi law pihhuh min pengettang min kennen mi, nem idwasi dakemi anhan ma-lat eleg kami matey ni upa mi.” ");
INSERT INTO ify_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kan Joseph ey “Hedin endi law pihhuh yu ey dammutun yadda inhalun yu hu i-li yun iwwa-hi yud kennen.” ");
INSERT INTO ify_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Et pan-ilaw idan tuu hu kalnero, yadda gelding, yadda baka niyadda kebayyu dad kad-an nan Joseph, et humman inwa-hi dan kennen dan hantoon. ");
INSERT INTO ify_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nelabah hantoon ey na-puh hu inhalun idan tutu-u et umlidda mewan di kad-an Joseph et kanday “Apu, endi law hu iwwa-hi mid kennen tep na-puh hu pihhuh mi. Ey illam ni emin hu inhalun mi et ebuh hu annel mi niya puyek min natdaan. ");
INSERT INTO ify_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Hemek dakemi anhan ma-lat eleg kami matey! Anin ew katteg ni pambega-en dakemi etan ni patul niya anin ni pampuyyek tu hu puyek mi. Nemet idwatan dakemin kennen mi niya ittanem ma-lat eleg mebel-ah hu puyek mi.” ");
INSERT INTO ify_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Et lektattuy gintang Joseph emin hu puyek di Egypt et pampuyek etan ni patul, tep nepilit ida tuun nengigtang ni puyek da tep nemahhig hu bisil. ");
INSERT INTO ify_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Niya nambalin emin ida law hu tuudman ni bega-en etan ni patul. ");
INSERT INTO ify_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Yan ebuh law hu puyek idan padi hu eleg meigtang tep kamelpun etan ni patul hu daka kenna, et eleg mahapul ni da iggatang hu puyek da. ");
INSERT INTO ify_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kan Joseph idan tuu ey “Deh e ginetang dakeyu, anin ni yadda puyek yu et bega-en dakeyu law etan ni patul. Adyah hu pagey. Lakkayuy et yu pan-itnem. ");
INSERT INTO ify_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Et hedin man-enni kayu, ey iddawat yu etan ni patul hu hakey di liman betek ni ennien yu. Ellan yu metdaan ma-lat wada kennen yu niya ma-lat wada ittanem yun balin tu.” ");
INSERT INTO ify_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kan idan tuuy “Kami kaum-amleng tep ay himmek dakemi et eleg kami matey. Et humman hu, anin ew ni pambega-en dakemi etan ni patul.” ");
INSERT INTO ify_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Et kapyaen nan Joseph humman ni olden di emin ni bebley di Egypt et nanengtun nunya e kaiddawat idan tutu-u hu bingay etan ni patul di daka ennia. Ebuh ida etan padin eleg um-idwat ni daka ennia etan ni patul, tep beken tun puyek humman ni puyek da. ");
INSERT INTO ify_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Yadda etan helag Israel ey nannaneng idad Goshen et lektattuy kimmedangyan ida niya dimmakkel ni peteg hu bilang da. ");
INSERT INTO ify_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Hi Jacob ey nekibebley diman ni hampulut pitun toon et han matey eman ni hanggatut et na-pat et pitu hu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yan nengamtaan tu e ngannganih law hu ketteyyan tu, ey impaeyag tu hi Joseph et kantuy “Ikepam hu ngamay mu daul ni ulpuk et isapatah mu e eleg muwak ali ikkulung di deya Egypt. ");
INSERT INTO ify_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nem ikulung muwak alid neikulungan idan aammed ku.” Kan Joseph ey “Em e ama, u-unnuden ku huttan ni inhel mu.” ");
INSERT INTO ify_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ey kan Jacob ey “Pansapatah ka e u-unnuden mu hu inhel ku.” Et mansapatah hi Joseph. Et manyuung hi Jacob et dayawen tu hi Apu Dios e inhudngul tud hulkud tud pangal tu. ");
INSERT INTO ify_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Entanni ey dingngel Joseph e kamandedgeh hi ametu. Et ikuyug tu etan ida dewwan u-ungnga tu e di Manasseh nan Epraim et da ang-angen. ");
INSERT INTO ify_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Dingngel nan Jacob e dimmateng hi Joseph ey inhanekul tun bimmangun et yumudung etan di uggippan tu. ");
INSERT INTO ify_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Et kantun Joseph ey “Inamtam e yan eman ni wada kamid Lus di Kanaan ey nampeang-ang ni hi-gak hi Apu Dios e Kabaelan tun emin et bendisyonan tuwak. ");
INSERT INTO ify_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Et kantun hi-gak ey ‘Iddawtan dakan dakel ni helag mu et hi-gada hu kehlagan idan nambakbaklang ni tutu-ud kebebbebley eyad puyek niya iddawat kun hi-gam eya Kanaan et beltanen idallin helag mu et pampuyek dallin ingganah.’” ");
INSERT INTO ify_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Immehel mewan Jacob ey kantuy “Yadda eya dewwan u-ungngam, e di Epraim nan Manasseh ni neiungngadya et hannak umli ey eggamiden kuddan u-ungngak e henid Reuben nan Simeon e wada pebeltan kun hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nem hedin wadalli edum ni u-ungngam, ey yad beltanen di Epraim nan hi Manasseh hu kelpuan ni beltanen da. ");
INSERT INTO ify_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Henin nunya pehding ku gapuh nan inam la e hi Rachel e netey di Kanaan etan di neihnup di Eprat eman ni nalpuan tayud Mesopotamya. Et nemahhig hu lemyung ku gapuh neteyyan tu. Ingkulung ku hi inam etan di gilig ni dalan diman.” (Ya ngadan law ni Eprat ni nunya ey Bethlehem.) ");
INSERT INTO ify_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Inang-ang nan Jacob ida etan dewwan u-ungngan Joseph ey kantuy “Kaw huyyadda etan u-ungngam?” ");
INSERT INTO ify_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kan Joseph ey “Em, huyyadda indawat Apu Dios ni u-ungngak di deya.” Et kan Jacob ey “Ihnup muddallin hi-gak ma-lat bendisyonan kudda.” ");
INSERT INTO ify_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Eleg um-aang-ang hi Jacob tep naka-a-amma law et ihnup nan Joseph ida etan u-ungnga tu et akwalen idan apu da. ");
INSERT INTO ify_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ey kan Jacob nan Joseph ey “Kangku nem endi law hu nak penang-angan ni hi-gam, nem kayyaggud et deh e in-abulut Apu Dios ni ang-angen daka, anin ida eyan u-ungngam.” ");
INSERT INTO ify_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Impakiwang Joseph ida etan u-ungnga tu et manyuung nan ametu. ");
INSERT INTO ify_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Et han tu mewan pebangngad ida etan u-ungngatud hinanggan apuda e hi Manasseh ey di wannan ametu et hi Epraim di willi tu. ");
INSERT INTO ify_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Nem impampakhiw nan Jacob hu ngamay tu et ya wannan tu hu ingkapetud ulun nan Epraim e udidyan et ya willi tu ingkapetud ulun Manasseh e pengulwan. ");
INSERT INTO ify_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Et bendisyonan tu dama hi Joseph e kantuy “Ya etan Dios ni dinaydayaw ida lan aammed ku e di Abraham nan Isaac niya nengipenaptek ni hi-gak ingganah ni nunya, ");
INSERT INTO ify_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","e hi-gatu etan Anghel ni nengihwang ni hi-gak, hu memendisyon ida eyan u-ungnga. Hi-gadalli gaputun mandingngel hu ngadan ku niya ngadan idan aammed ku e di Abraham nan Isaac. Bendisyonim ida ma-lat dakel ni peteg ali hu helag da.” ");
INSERT INTO ify_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Hi Joseph ey eleg tu pinhed humman ni impahding ametu e ingkapetu wannan tud ulun nan Epraim e udidyan. Et tengeden tu ngamay ametu et i-aldan tu-et di ulun Manasseh e pengulwan. ");
INSERT INTO ify_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kan tun ametuy “Beken ni hi-gatu pengikap-im ni wannan mu! Tep hi diyyay hu pengulwan.” ");
INSERT INTO ify_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nem kan ametuy “Em, inamtak. Et-eteng ali daman bebley hu pambebleyan ni helag Manasseh, nem nema-malli eya udidyan tep e-etteng ali kabaelan tu niya mandingngel idalli helag tu.” ");
INSERT INTO ify_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binendisyonan tudda mewan e kantuy “Hedin mambendisyon idalli helag Israel ey kandalli ey ‘Bendisyonan dakeyun Apu Dios henid Epraim nan Manasseh.’” Yan nanghelan Jacob ni nunya ey impamengulu tun inhel hu ngadan Epraim e beken hi Manasseh. ");
INSERT INTO ify_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kan Jacob nan Joseph ey “Anggagannu law hu ketteyyan ku, nem ippaptek dakeyullin Apu Dios et ibbangngad dakeyullid Kanaan e puyek ida lan aammed tayu. ");
INSERT INTO ify_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ey beken ni yadda agim, nem hi-gam hu pengidwatan ku etan ni bebley di Sekem e mateba kameitnem diman. Humman ni bebley ey inapput kuddan Amorite e inusal ku ispadah ku niya panak.” ");
INSERT INTO ify_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Entanni ey hi Jacob, e hi Israel hu hakey ni ngadan tu ey impaeyag tun emin ida u-ungnga tu et kantun hi-gaday “Ikeyuy ma-lat denglen yu hu e-helen kun meippahding alin hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kantun hi-gaday “Hi-gayuddan u-ungngak, dengel yu eya e-helen ku e hi ameyun hi Israel. ");
INSERT INTO ify_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Hi-gam e Reuben e pengulwan, ey hi-gam hu nakka ikkedhel, tep hi-gam hu newada eman ni pakehikken ku. Hi-gam hu kametettebal niya keka-ka-letan. ");
INSERT INTO ify_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nem hi-gam ey kaka mei-ellig etan di na-let ni elwang e tuka deplugan emin. Et humman hu, eleg mannananeng hu muka ketbali, tep bineing muwak e hi amam eman ni nengiuligan mun hakey ni ahwak. ");
INSERT INTO ify_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Hi-gayu, Simeon nan Levi, ey nan-ingngeh kayun ya matedem hu yuka tetngeda e ya mekippettey hu wadad nemnem yu. ");
INSERT INTO ify_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hi-gak e hi ameyu ey eggak pinhed huttan ni yuka pehpehding, tep gapuh ni bunget yu ey pimmatey kayu. Ey hedin wada hina-kupan yun animal ey neala ni pini-day yu. ");
INSERT INTO ify_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Et humman hu, ya kastigu yu ey mehillit idalli helag yud emin ni pambebleyan idan helag ku. ");
INSERT INTO ify_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Hi-gam e Judah ey tettebalen dakaddallin aaggim. Manyu-ung idallin hi-gam niya apputen muddalli buhul mu. ");
INSERT INTO ify_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Heni kalli etan ni layon e hedin kinan tu etan pintey tu, man um-anemut et an man-u-uggip. Ey endi netuled ni memengngun ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yaddalli helag mu hu man-ap-apu e manhuluhulul ida ingganah ni um-ali etan hakey ni pinilin Apu Dios ni man-ap-apu et hi-gatulli u-unnuden ni katuutuu. ");
INSERT INTO ify_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ey emin ali hu mahapul tu ey wada. Ya ittanem tun grapes ey mateba niya malemeh et yad hengeg tu hu pengi-ikketan tun kebayyu tu. Madenum alin peteg hu lameh tu et gullat na-mun dammutu et pengibbalbalan tun balwasi tu. ");
INSERT INTO ify_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Et gapu tep dakel hu meinnum ni grapes ey mambabatag hu matetu niya mablah hu ngipen tu gapuh ni tuka penginnumin gatas. ");
INSERT INTO ify_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Hi-gam e Sebulun ey manha-ad kallid gilig ni baybay e ya pappeg tu ey ingganah di Sidon. Yadman ali hu panda-guhan idan bapor. ");
INSERT INTO ify_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Hi-gam e Issakar ey heni ka kebayyu, e ma-nut na-let, ");
INSERT INTO ify_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","nem hedin wada inang-ang tun kakkayyaggud ni pattulan ey umlaw diman et an man-u-uggip. Ey gapu tep yadman hu pinhed tun panha-adan ey lektattuy nambalin ni bega-en diman. ");
INSERT INTO ify_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Hi-gam e Dan ey baddangam idalli edum mun helag ku ma-lat limpiyuh hu pehding idan buhul dan hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Heni ka etan ni uleg di gilig ni dalan e tuka ikkalat di helin kebayyun kamelebbah ma-lat ma-gah etan nantakkay.” ");
INSERT INTO ify_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Entanni ey kan Jacob ey “Nakka hehheggeda pengihwangan mun hi-gak, e Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Entanni mewan ey kantuy “Hi-gam e Gad ey hedin wada matekew ni memdug ni hi-gam ey petekkut mu et hi-gam hu memdug ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Hi-gam e Asher, kayyaggud ni kennen ida meitnem di puyek mu e henin kakennan patul. ");
INSERT INTO ify_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Hi-gam e Naptali ey heni ka etan ni bimmukyat ni makwah ni kakkayyaggud hu impah tu. ");
INSERT INTO ify_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ey hi-gam e Joseph ey heni ka etan ni malemeh ni neitnem etan di wada hebwak ni umkalab di deplah. ");
INSERT INTO ify_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nemahhig hu hinelheltap mun impahpahding dan hi-gam e heni daka nan-himpapanaan. ");
INSERT INTO ify_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","25","Nem eleg ka meapput tep binaddangan dakan Dios ku e Kabaelan tun emin. Et hi-gatu e kamengippaptek ni hi-gatsu ey heni batun keihhikkugan tayun Hebrew. Hi-gatu hu mengidwat ni emin ni mahapul mu, henin udan niya petang ey anin ni danum ni kamelpud puyek. Ey medakkel ali hu halun mu niya helag mu. ");
INSERT INTO ify_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Huttan idan pemendisyon kun hi amam ni hi-gam ni panyaggudan mu ey endi kei-ingngehan tu. Um-amnu emin ida huttan ni hi-gam, Joseph e kametbal di emin ni agim. ");
INSERT INTO ify_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ey hedin hi-gam dama e Benjamin, ey netuled ka e heni ka etan ni kandan wolf. Apputen muddalli buhul mu niya pan-i-anemut mu hu kumpulmih ni ellan mun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Huyyadda hu inhel Jacob idan hampulut dewwan u-ungnga tu e neiunnud di nambakbaklang ni elaw da. ");
INSERT INTO ify_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Entanni ey kan mewan Jacob ni hi-gaday “Nakka giggibbeka ey ngannganih hu ketteyyan ku et nak mei-dum idan aammed kun nangketey. Ey ya pinhed kun pengikkullungan yun hi-gak ey yad bebley tayud Kanaan etan di leyang di Makpelah e demang ni Mamle. Humman ey gintang eman lan hi apu e hi Abraham nan Eplon e Hittite et pambalin tun gungat tayu. ");
INSERT INTO ify_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Et yadman hu neikulungan di Abraham nan Sarah. Anin di apu yu e di Isaac nan Rebekah et yadman hu neikulungan da. Ey yadman hu nengikulungan ku daman ineyu e hi Leah. ");
INSERT INTO ify_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mukun anin hi-gak et pinhed kun yadman ni leyang etan di kad-an ni payew ni gintang lan apu hi Abraham etan ni Hittite hu pengikkullungan yulli daman hi-gak.” ");
INSERT INTO ify_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Negibbuh ni inhel Jacob humman et bumaktad etan di uggippan tu ey impa-yuh tun netey. ");
INSERT INTO ify_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Inakwal nan Joseph hi ametu ey kamannengngih. ");
INSERT INTO ify_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Et iolden tudda etan ni kamambalsamuh et balsamuhen da hi ametu. ");
INSERT INTO ify_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Limmaw ni na-pat ni aggew et han da gibbuha tep in-u-unnud dan kapehding idan iEgypt. Et lemyungan dan dewwan bulan et hampulun aggew. ");
INSERT INTO ify_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Negibbuh hu lemyungan da et kan Joseph idan opisyal etan ni patul ey “Yu ehel anhan etan ni patul eya pinhed kun e-helen ni hi-gatu: ");
INSERT INTO ify_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ya eman ni kamangkatkatey hi ama ey impansapatah tuwak e nak ali ikkulung di Kanaan etan di indaddan tun keikkullungan tu. Et humman hu, iebulut mu anhan et nak ali ni ikulung hi ama et hannak ali mambangngad.’” ");
INSERT INTO ify_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Inebulut etan ni patul et kantuy “Dammutu, elaw ka et mu ipahding hu insapatah mun amam.” ");
INSERT INTO ify_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Et an iklung di Joseph hi ameda. Nekilaw ida emin hu opisyal etan ni patul niyaddan emin hu aap-apud Egypt, anin idan kametbal ni tuud Egypt. ");
INSERT INTO ify_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nekilaw ida pamilyah Joseph niyadda edum dan helag Jacob. Yan ebuh hu nehi-yan di Goshen ey yadda u-ungnga niyadda etan inhalun dan kalneroh, yadda gelding niyadda baka. ");
INSERT INTO ify_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nekilaw ida dama etan nampangkebayyu niya nampangkalesa et dakel ida nekilaw ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Yan dintengan da etan di kapan-illikid Atad e neihnup etan di Wangwang e Jordan ey nanda-guh idadman et hammaden dan ilemyungan ni pitun aggew e impappangngulun Joseph. ");
INSERT INTO ify_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ey yadda iKanaan ni nenang-ang ni nunman ni nekilemyungan idan iEgypt ey kanday “Anakkayang, tam nehammad numan hu daka pekillemyungin netey.” Et ngadanan da humman ni bebley ni Abel Misraim. ");
INSERT INTO ify_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yadda etan u-ungngan Jacob ey inu-unnud da hu inhel ameda ");
INSERT INTO ify_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","e da ingkulung di Kanaan etan di leyang di Makpelah e neihnup di Mamre, e humman etan payew ni gintang Abraham etan ni Hittite e hi Eplon, et pambalin tun gungat idan pamilyah tu. ");
INSERT INTO ify_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Negibbuh ni ingkulung di Joseph hi ameda et mambangngad idad Egypt e hi-gadan emin idan agitu niyadda etan iEgypt ni nekilaw ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yadda etan agin Joseph ey newada hu elem dan hi-gatu eman ni neteyyan ameda. Kanday “Yan nunya e endi law hi ametayu, ey ibbaleh tu na-mu law hu impahding tayun hi-gatu.” ");
INSERT INTO ify_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Et itu-dak da hakey ni mengippeamtan Joseph e kanday “Yan nunman ni mategu ni hi ametayu ey ");
INSERT INTO ify_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","inhel tun hi-gami e e-helen min hi-gam ma-lat liwwanen mu etan lawah ni impahding min hi-gam. Et humman hu, pesinsahi dakemi anhan e bega-en etan ni Dios ni dinaydayaw lan ametayu.” Dingngel Joseph humman ni inhel idan agitu ey kamannengngih. ");
INSERT INTO ify_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Entanni ey immalidda etan agitu et manyuung idan hi-gatu et kanday “Nandaddan kamin mambalin ni himbut mu.” ");
INSERT INTO ify_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nem kan Joseph ey “Entan takut yun hi-gak tep bekennak ni Dios ni menuwes niya mengastigun tuu. ");
INSERT INTO ify_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ma-nu tep lawah hu ninemnem yun pehding hi-gak, nem impambalin Apu Dios ni kayyaggud ma-lat keihwangan ni dakel ni tuu eyad bisil. ");
INSERT INTO ify_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Et humman hu, entan tattakut yu. Hi-gak hu ngenamung ni mengippaptek ni hi-gayu, anin idan u-ungnga yu.” Et luminggep law hu nemnem dan nangngelan dan nunman tep kabbabbal hu impanghel Joseph ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hi Joseph et yaddan emin ni helag ametu ey nannaneng idad Egypt. Netey hi Joseph eman ni hanggatut et hampulu toon tu. ");
INSERT INTO ify_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ey kayyaggud tep inang-ang tudda u-ungngan Epraim niyadda meikkadwan inap-apu tu, anin ni u-ungngan Makir e u-ungngan Manasseh. ");
INSERT INTO ify_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yan eman ni eleg ni matey hi Joseph ey kan tuddan agituy “Anggagannu law ey metteyyak, nem ngenamung hi Apu Dios ni mengibbangngad ni hi-gayu etan di bebley ni inhel tun pebeltan tuddan helag Abraham, hi Isaac et hi ametayu hi Jacob. ");
INSERT INTO ify_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ey yallin pambangngadan yud Kanaan ey entan tu liwwan et ienamut yu tu-ngal ku.” Et isapatah da e u-unnuden da humman ni inhel tu. ");
INSERT INTO ify_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Netey hi Joseph di Egypt eman ni hanggatut et hampulu hu toon tu et balsamuhen da et ilungun dadman. ");
INSERT INTO ify_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Huyyadda ngadan idan u-ungngan Jacob ni nekilaw ni hi-gatud Egypt e ingkuyug dadda pamilyah da e ");
INSERT INTO ify_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","hi Reuben, hi Simeon, hi Levi, hi Judah, ");
INSERT INTO ify_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","hi Issakar, hi Sebulun, hi Benjamin, ");
INSERT INTO ify_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","hi Dan, hi Naptali, hi Gad et hi Asher. ");
INSERT INTO ify_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Nepitun emin hu bilang ida eyan helag Jacob. Nekibilang hi Joseph e wada ngu dedan di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Entanni ey netey idan emin huyyan han-aaggi, anin hi Joseph. ");
INSERT INTO ify_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nem dakel hu helag dan neihullul ni hi-gada. Nahlag ida humman ni u-ungnga da et lektattuy dakel idan peteg et maihinap idad emin ni bebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nelabah hu dakel ni toon ey wada neihullul ni patul di Egypt ni eleg tu amta hu meippanggep lan Joseph niyadda etan kayyaggud ni impahpahding tun panyaggudan nunman ni bebley. ");
INSERT INTO ify_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kantuddan tuu tuy “Dimmakkel idan peteg eya helag Israel, et eleg tayu amta ey wadalli lawah ni pehding dan hi-gatsu. ");
INSERT INTO ify_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mahapul ni mannemnem itsun pehding tayu ma-lat eleg ma-duman hu bilang da. Tep nungay wada gubat ey mei-dum idan buhul tayu, et hedin neapput itsu ey hi-yanen da eya bebley tayu.” ");
INSERT INTO ify_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Et ya impahding idan iEgypt ey impambalin daddan himbut etan helag Israel et panhelheltap dadda. Pinutuk da makabbunget ni mengippengngulu, et pangunu dan hi-gada hu nekalligat ni ngunu. Impekapya dan hi-gada etan dewwan bebley, ya Pithom niya Rameses e humman pambodegahan ni patul. ");
INSERT INTO ify_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nem hedin kapan-imma-maddan iEgypt ni mengippehelheltap ni hi-gada, ey ida anhan law kamangkedakkel et ida kamangkeihhinnap. Mukun nema-man newada takut idan iEgypt ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Et humman hu endi law hemek da et daka pan-imma-man mengippelilligat ni hi-gadad emin ni daka pengunnu, henin ngunud payew niya mengapyan meikkapyan baley. ");
INSERT INTO ify_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Entanni ey minandal etan ni patul etan dewwan Hebrew e di Shiprah nan Puah e hi-gada hu kaumbaddang idan edum dan helag Israel ni man-ungnga. Kantun hi-gaday ");
INSERT INTO ify_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Hedin laki hu i-ungngan biin Hebrew man patey yu, nem hedin bii entan tu patey.” ");
INSERT INTO ify_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nem eleg da u-unnuden humman ni inhel etan ni patul, tep ida kaumtakut nan Apu Dios, et eleg da pateyen ida lalakkin neiungnga. ");
INSERT INTO ify_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Et humman hu impaeyag etan ni patul ida et kantuy “Kele eleg yuwak u-unnuden? Kele eleg yu pateyen ida lalakkin in-ungngaddan edum yun Hebrew?” ");
INSERT INTO ify_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Kanday “Apu, endi pehding mi tep hin-appil idan peteg hu edum min biin Hebrew nem yadda iEgypt tep anggagannu hu daka pan-ungngai e eleg kami umdateng ni neukat hu u-ungnga da.” ");
INSERT INTO ify_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Et humman hu dimmakkel idan peteg hu helag Israel niya immetteng law hu kabaelan da. Gapuh ni kapengu-unnudiddan nunyan bii nan hi Apu Dios, ey binendisyonan tudda et mengahwadda dama et mawedadda u-ungnga da. ");
INSERT INTO ify_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Entanni law ey in-olden etan ni patul idan tutu-u tu e kantuy “Yu pan-ibbeng ida hu pakeiungngan lalakkin Hebrew di Wangwang e Nile di diman Egypt, nem entan tudda ilegat hu biin pakeiungnga.” ");
INSERT INTO ify_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Yan nunyan tsimpuh ey wada etan han-ahwan helag Levi. ");
INSERT INTO ify_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nambutsug etan bii et man-ungnga ey laki. Inang-ang etan ni inetu e kakkayyaggud ni gelang et itattallu tun tellun bulan. ");
INSERT INTO ify_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Nem entanni ey eleg tu law han-itlu et lumaggan basket ni heni labba et pampudlitan tun pukut ma-lat eleg humgep danum. Inha-ad tudman etan gelang et tu itlud mekatlubbung di gilig ni Wangwang e Nile. ");
INSERT INTO ify_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ya etan biin agi etan ni gelang ey wadad man e kamantattallu etan di a-allaw tu e tuka ang-ang-anga hu meippahding ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Entanni ey immali etan biin u-ungngan patul ni an man-e-meh etan di wangwang. Kaman-e-meh ey ida nandaddallan etan bega-en tud gilig nunman ni wangwang. Inang-ang etan ni u-ungngan patul etan basket ni kamangkalkalyap etan di mekatlubbung et itu-dak tu hakey ni bega-en tu et tu al-en. ");
INSERT INTO ify_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Sinukwaban etan ni u-ungngan patul ey wada gelang ni lakin kamannengngih ey himmek tu. Kantuy “Huyya mannuman katteg hu hakey ni u-ungngaddan Hebrew.” ");
INSERT INTO ify_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Et henupen etan ni biin agin nunman ni gelang, et kantu etan ni u-ungngan patul ey “Kaw pinhed mu et nak umeyag ni biin Hebrew, ma-lat hi-gatu mengipaptek eyan gelang?” ");
INSERT INTO ify_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ey kantuy “Uh, elaw ka tep.” Et lumaw etan bii et hi inetu kumedek hu tu inaygan. ");
INSERT INTO ify_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kan etan ni u-ungngan patul etan ni inan gelang ey “Awit mu eya gelang ma-lat ipaptek mu et tangdanan daka.” Et awiten tu etan gelang et ipaptek tu. ");
INSERT INTO ify_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Et yan neettengan nunman ni gelang, ey inlaw inetu etan ni u-ungngan patul et ibilang tun u-ungnga tu. Ingngadnan tun hi Moses e ya keibbellinan tu ey ‘Iddakal’ tep indakal tud danum. ");
INSERT INTO ify_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Nehiken law hi Moses et hakey ni aggew, ey limmaw ni an menang-ang idan edum tun Hebrew ey inang-ang tu hu kapengippelilligasiddan iEgypt ni hi-gadad daka pengunnungunnu. Entanni ey inang-ang tu hakey ni iEgypt e tuka pambe-iga etan hakey ni edum tun Hebrew. ");
INSERT INTO ify_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kamanwingiwingi hi Moses ey endi hu kamenang-ang-ang ni hi-gatu et pateyen tu humman ni iEgypt et iku-ku tud palnah. ");
INSERT INTO ify_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Newa-wa mewan ey inang-ang tudda dewwan Hebrew e ida kamambekkal. Et kantu etan ni nambahul ey “Kele muka pangkewwaya eya edum mun Hebrew?” ");
INSERT INTO ify_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Himmumang humman ni tuu ey kantuy “Hipa hu nemutuk ni hi-gam ni mambalin ni ap-apu mi niya huwet mi? Kaw petteyen muwak dama henin impahding mu etan ni iEgypt ni kaalman?” Ey simmakut hi Moses ni nangngelan tun nunman e kantuy “Tam inamta law idan tutu-u humman ni impahding ku.” ");
INSERT INTO ify_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Entanni ey tu-wangun dingngel etan ni patul humman ni neipahding et tu-et pepettey hi Moses. Nem bimmesik di Midian et an makibebley diman. Hi Jetro hu padid Midian ni nunman ey wada pitun bibi-in u-ungnga tu. Hakey ni aggew e kamanyuyyuddung hi Moses di kad-an ni hibuy, ey immalidda humman ni bibi-in u-ungngan Jetro ni an man-ehhul ni peinnum daddan kalneroh niya gelding ameda. ");
INSERT INTO ify_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nem dinegyun idan edum ni kamampattul humman idan bibi-in u-ungngan Jetro. Inang-ang idan Moses et baddangan tudda et painuman tu hu animal da. ");
INSERT INTO ify_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Yan inenamutan da ey kan ameday “Kele anggagannuy immanemut kayu kuman nunya?” ");
INSERT INTO ify_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kanday “Tep wada etan iEgypt ni bimmaddang ni hi-gami et painuman tudda animal tayu.” ");
INSERT INTO ify_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kan ameday “Et attu humman ni tuu ey? Kele yu hini-yan diman? Yulli ayagi et makikan.” ");
INSERT INTO ify_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nekilaw hi Moses et lektattuy pininhed tun mekihha-ad di baley Jetro. Entanni ey impeahwan Jetro etan hakey ni u-ungnga tu e hi Sippora nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nan-ungnga hi Sippora ey laki et ngadanan Moses ni Gersom tep kantud nemnem tuy “Hi-gak ey hansinu-wannak di deya.” ");
INSERT INTO ify_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nelabah hu pigan toon ey netey etan patul di Egypt, nem nanengtun nemahhig metlaing hu kapanhelheltapiddan helag Israel, et humman hu, ida kamampehemmehemmek nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dingngel Apu Dios hu daka pampehemmehemmeki, ey ninemnem tu hu nekitbalan tud Abraham, hi Isaac et hi Jacob, ");
INSERT INTO ify_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","tep inamta tu dedan humman ni kapengippelilligasiddan iEgypt idan helag Israel et hemeken tudda. ");
INSERT INTO ify_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Hi Moses ey tuka ipappaptek ida animal ni nengapun hi-gatu e hi Jetro e padid Midian. Hakey ni aggew ey an impattul ida Moses hu kalneroh niya gelding etan di ba-hil ni eleg mebebleyi, et dumteng di Sinai e duntug ni kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Entanni ey nampeang-ang hu anghel Apu Dios ni hi-gatu etan di kamantettebbel ni ekkeket ni keyew. Inang-ang Moses e ma-nut kamantettebbel etan keyew, nem eleg megbu. ");
INSERT INTO ify_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Natnga hi Moses e kantud nemnem tuy “Kele nemalad humman ni keyew e eleg megbu? Imay pangngu et nak henupen et paka-ang-angen ku.” ");
INSERT INTO ify_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Inang-ang Apu Dios e kamangkeihnup hi Moses ey inhelan tu e kantuy “Moses!” Kan Moses ey “Uh Apu, iyadya-ak!” ");
INSERT INTO ify_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kan Apu Dios ey “Ehneng kadtan. Entan keihnup mudya. Ey ekal mu patut mu tep wada-ak eyad lugal ni inehnengan mu. ");
INSERT INTO ify_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Hi-gak hu Dios idan aammed mu e hi Abraham, hi Isaac et hi Jacob.” Et hanian Moses hu angah tu tep kaumtakut ni menang-ang nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Immehel mewan Apu Dios ni hi-gatu ey kantuy “Inang-ang ku e nemahhig hu kapanhelheltapiddan tuuk di Egypt niya dingngel ku hu daka pampehemmehemmekin daka pambeggain baddang ma-lat masiked hu daka panhelheltapi. Ey nakka hehmekadda, ");
INSERT INTO ify_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","et humman hu, immali-ak ma-lat ihwang kuddad kapengippelilligasiddan iEgypt ni hi-gada. Pe-kal kuddadman ni bebley et pellaw kudda etan di mahkang ni kayyaggud ni puyek ni mateba hu kameitnem e humman hu nambebleyan idan Kanaanite, yadda Hittite, yadda Amorite, yadda Perisite, yadda Hibite niyadda Jebusite ni nunya. ");
INSERT INTO ify_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Makulug ni dingngel ku hu palak idan helag Israel niya inang-ang ku hu nemahhig ni kapengippelilligasiddan iEgypt ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Et humman hu, yan nunya ey ittu-dak daka et ka makihummangan etan ni patul di Egypt ma-lat ipengulum ida tuuk ni peni-yanan yun nunman ni bebley.” ");
INSERT INTO ify_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Nem kan Moses ey “Apu, kaw hipa-ak kuman an mekihhummangan etan ni patul ma-lat iebulut tun ippanguluk ida etan edum kun helag Israel et hi-yanen mi Egypt?” ");
INSERT INTO ify_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ey kan Apu Dios ni hi-gatuy “Entan pandanag mu tep baddangan daka. Ya keang-angan tun hi-gak hu nengitu-dak ni hi-gam ey heninnuy: Yallin pengippengnguluan muddan tutu-uk ni peni-yanan yun Egypt, ey idaydayaw da-ak ni hi-gayu eyad duntug.” ");
INSERT INTO ify_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nem kan Moses ey “Nem inna-nu hedin umlawwak diman et kangkuddan edum kun helag Israel, ey intu-dak tuwak ni Dios idan aammed tayu et kanday ‘Hipa humman ni Dios ni muka pan-e-hela? Hipa ngadan tu?’ ey hipa ihhumang kun hi-gada?” ");
INSERT INTO ify_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kan Apu Dios ey “Hi-gak Etan Wadan Ingganah. Ehel mun hi-gada e kammuy ‘Ya etan wadan ingganah hu nengitu-dak ni hi-gak.’ ");
INSERT INTO ify_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ehel mun hi-gada e hi-gak etan Ap-Apu e Dios idan aammed yu e hi Abraham, hi Isaac et hi Jacob hu nengitu-dak ni hi-gam. Huyyan ngadan ku hu pangngeddan ni tutu-un hi-gak ni ingganah. ");
INSERT INTO ify_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Elaw ka et amungen muddan emin hu aap-apun helag Israel et ehelen mun hi-gada e hi-gak hu Ap-Apu e Dios idan aammed yu e hi Abraham, hi Isaac et hi Jacob ey nampeang-angngak ni hi-gam. Ehel mun hi-gada e baddangan kudda tep inang-ang ku hu kapengippelilligasiddan iEgypt ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ninemnem kun pe-kal idad Egypt ma-lat mepappeg hu daka panliligasi et palaw kudda etan di puyek ni mateba hu kameitnem e nambebleyan idan Kanaanite, yadda Hittite, yadda Amorite, yadda Perisite, yadda Hibite niyadda Jebusite. ");
INSERT INTO ify_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Elaw ka et nanna-ud ni kullugen idan aap-apun helag Israel hu e-helen mu. Elaw kayuddan emin ni aap-apun helag Israel et kayu makihummangan etan ni patul di Egypt. Et kanyun hi-gatuy ‘Ya etan Ap-Apu e Dios min Hebrew ey nampeang-ang ni hi-gami et mahapul ni i-appitan mi. Et humman hu, iebulut mu anhan ma-lat lumaw kami etan di eleg mebebleyi, e tellun aggew hu pandellanan mi, et kami mandayaw ni hi-gatu e Ap-Apu e Dios mi.’ ");
INSERT INTO ify_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nem inamtak e eleg tu i-abulut hedin eleg pillita. ");
INSERT INTO ify_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Et humman hu dakel ali hu pehding kun kaketngain kebahbahan ni Egypt et lektat tu ey i-abulut tun umlaw kayu. ");
INSERT INTO ify_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ey ang-angen ku et kayyaggud ali hu pannemnem idan iEgypt ni hi-gayu ma-lat yallin peni-yanan yun bebley da ey iddawtan dakeyullin mahapul yun ittabin yu. ");
INSERT INTO ify_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Et emin idalli bibi-in helag Israel ey mangkekdew idalliddan sinakdul dan bibi-in iEgypt ni kan bega-en ni hi-gadan balwasi niya linggeman ni usal ni nekapyad silber niya balituk et pampehuklub da niya pampebalwasi daddan u-ungnga da. Pehding dalli huyya et al-en da la hu kinedangyan ni Egypt e heni da imbesik di gubat.” ");
INSERT INTO ify_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Hinumang Moses hi Apu Dios e kantuy “Nem inna-nu hedin eleg kullugaddan edum kun helag Israel hu e-helen kun hi-gada? Hipa pehding ku hedin kanday beken ni makulug ni nampeang-ang kan hi-gak?” ");
INSERT INTO ify_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ey kan Apu Dios ni hi-gatuy “Hipa eya singnged mu?” Kan Moses ey “Tam hulkud.” ");
INSERT INTO ify_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kan Apu Dios ey “Bekah mud puyek.” Imbekah nan Moses ey nambalin ni uleg. Ey simmakut hi Moses et bumsik. ");
INSERT INTO ify_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nem kan Apu Dios ey “Tenged mu ikul tu.” Et tengeden Moses ey nambangngad mewan ni hulkud. ");
INSERT INTO ify_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Immehel mewan hi Apu Dios ey kantuy “Heninnuy pay hu ippahding mu ma-lat kulugen idan edum mun helag Israel e hi-gak e Ap-Apu e Dios idan aammed yu e hi Abraham, hi Isaac et hi Jacob ey makulug ni nampeang-angngak ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ihweng mu ngamay mud balwasim.” Et ihweng Moses hu ngamay tu et guyuden tu ey bimmelah e neleprosih. ");
INSERT INTO ify_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kantu mewan ey “Ipidwam ni ihhehweng.” Et ihweng tu mewan et guyuden tu ey na-kal humman ni leprosih di ngamay tu. ");
INSERT INTO ify_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Immehel mewan hi Apu Dios ey kantuy “Hedin eleg da kulugen etan nemangulun miracle man wada-et ni kullugen da huyyan meikkadwan peang-ang mu. ");
INSERT INTO ify_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ey hedin ippahding mudda huyyan dewwan miracle, nem kapyatun eleg ida mengullug, ala kan danum di Wangwang e Nile et iduyag mud puyek. Et humman ni danum ey mambalin ni kuheyaw.” ");
INSERT INTO ify_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nem kan Moses ey “Apu, beken ni hi-gak hu itu-dak mu tep inna-nu dan mengullug ni hi-gak e beken nak ngu dedan ni mahepit.” ");
INSERT INTO ify_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ey kan Apu Dios ni hi-gatuy “Kaw hipa nengapyan bungut ni tuu? Niya hipa kamenulleng niya kamangngengngan tuu? Ey hipa hu kabaelan tun mengullap winu memetyan matan tuu ma-lat han-ang-ang tu? Kaw hipa edum ni kabaelan tun mengippahding idan nunya hedin beken ni hi-gak e hi Apu Dios? ");
INSERT INTO ify_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Et humman hu, elaw ka kuma et mu ipahding hu inhel ku. Baddangan dakan umhapit niya ituttudduk hu e-helen mu.” ");
INSERT INTO ify_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nem kan Moses ey “Apu, eggak pinhed ni umlaw. Ya edum hu itu-dak mu.” ");
INSERT INTO ify_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ey bimmunget hi Apu Dios et kantuy “Ku anin tep. Hedin kammuy beken kan mahepit baddangan dakan agim e hi Aaron e helag Levi yaggud amtak e mahepit. Immen di dalan e kamengellin an menammun hi-gam. Inamtak et manggagayallin penang-angan tun hi-gam. ");
INSERT INTO ify_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ehel mun hi-gatu hu pinhed mun e-helen ma-lat hi-gatu hu menghel. Hi-gak hu mengituttuddun hi-gayun e-helen yu niya pehding yu. ");
INSERT INTO ify_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Hi-gatu menghel ni pinhed mun e-helen idan tuu. Ey hi-gam hu heni Dios ni menghel ni e-helen tu. ");
INSERT INTO ify_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ey itebin mu eya hulkud mu ma-lat huttan ussalen mun mengippahding ni dakel ni miracle.” ");
INSERT INTO ify_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Immanemut hi Moses di baley da et kantu etan ni nengapun hi-gatu e hi Jetro ey “Iebulut mu anhan et lumaw wak ali nid Egypt et nak ida ang-angen aaggik diman et nak pepuhdanan hedin nanengtun mategudda.” Ey simbal nan Jetro. ");
INSERT INTO ify_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Eleg ni hi-yanen nan Moses hu Midian ey immehel mewan hi Apu Dios ni hi-gatu ey kantuy “Pambangngad kad Egypt haggud netey ida law etan neminhed ni memettey ni hi-gam diman.” ");
INSERT INTO ify_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Et itakkay Moses di kebayyu etan ahwa tu niyadda u-ungnga tu et lumaw idad Egypt e impeki-la tu etan hulkud ni inhel Apu Dios ni ittabin tu. ");
INSERT INTO ify_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kan Apu Dios nan Moses ey “Hedin umdateng kayud Egypt, ey entan tu liwwan et ipahding mud hinanggan etan ni patul ida etan miracle haggud indawat ku hu kabaelan mun mengippahding idan nunman. Nem pambalin kun manghay humman ni patul et eleg tu i-abulut ni pellaw ida etan tuuk. ");
INSERT INTO ify_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Et humman hu mahapul ni e-helen mun hi-gatu huyya: Kan Apu Dios ey ‘Nakka ibbilang ni pengulwan ni u-ungngak ida helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ey kangkuy iebulut mudda ma-lat lumaw idan menaydayaw ni hi-gak e Dios da, nem manghay ka, et humman hu, petteyen ku hu pengulwan ni u-ungngam ni laki.’” ");
INSERT INTO ify_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yan kapenglawwid Moses di Egypt et mangkampuddad dalan ey nampeang-ang hi Apu Dios. Ey innang ni petteyen tu hi Moses. ");
INSERT INTO ify_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Nem hi Sippora e ahwan Moses ey immalan ewah et kugiten tu etan u-ungnga dan laki, et idehidah tud helin Moses et kantuy “Ayyakaw huyyan elaw yu e mahapul ni mekuggit kayu!” Et gapuh ni nunman ni impahding Sippora ey eleg law pateyen Apu Dios hi Moses. ");
INSERT INTO ify_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Hi Apu Dios ey inhel tu lan Aaron e tu dammuen di Moses etan di eleg mebebleyi. Et lumaw hi Aaron et tu dammuen hi Moses et akwalen tu. ");
INSERT INTO ify_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Et ehelen nan Moses nan Aaron ni emin hu inhel Apu Dios ni hi-gatu anin idan miracles ni pehding dan pambangngadan dad Egypt. ");
INSERT INTO ify_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Et mambangngad idad Egypt et amungen dadda etan aap-apuddan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Et ehelen nan Aaron emin ni hi-gada hu inhel Apu Dios nan Moses. Ey hedin hi Moses man impahding tudda miracle et ang-angen idan nunman ni tuun neamung. ");
INSERT INTO ify_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ey kinulug dan makulug ni intu-dak idan Apu Dios. Ey yan nunman nengamtaan da e tuka hehhemekaddad daka panhelheltapi. Et manyuung ida et dayawen da hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Entanni ey limmaw di Moses nan Aaron di kad-an etan ni patul et kandan hi-gatuy “Ya etan Ap-Apu e Dios min helag Israel ey kantuy ‘Iebulut mudda tuuk et lumaw idad eleg mebebleyi et ida mandayaw ni hi-gak.’” ");
INSERT INTO ify_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nem kan etan ni patul ey “Hipa ngu anhan humman ni kanyun Ap-Apu yu? Kele nak u-unnuden ey eggak amta humman ni Ap-Apu? Eleg mabalin ni kayu umlaw e helag Israel!” ");
INSERT INTO ify_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Hinumang di Aaron nan Moses e kanday “Nampeang-ang ni hi-gami etan Dios min Hebrew et kantuy umlaw kamid eleg mebebleyi e mandellan kamin tellun aggew ma-lat mi i-appitan diman humman ni Ap-Apu e Dios mi. Tep hedin eleg mi u-unnuda ey pandedgeh dakemi ey mettey kami winu um-itu-dak ni mengubbat ni hi-gami et petteyen dakemi.” ");
INSERT INTO ify_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ey kan etan ni patul ni hi-gaday “Hipa kayun menaktak idan tuun nakka pangngunnu! Lakkayuy kuma et yu ehelen idan edum yu ma-lat ida mampangngunu! ");
INSERT INTO ify_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Yan nunya law ni-ngangun dimmakkel kayun Hebrew nem hi-gamin iEgypt ey pinhed yun issiked ni mangngunnu?” ");
INSERT INTO ify_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Et yan nunman ni aggew ey in-olden etan ni patul ida etan ni kamengipappangnguluddan himbut ni Hebrew ");
INSERT INTO ify_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","e kantuy “Entan tu law idwasidda kamampangngunnun dagemin meikkamdug di pulan mekapyan brick. Ngenamung idan an menemmak. ");
INSERT INTO ify_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Nem mahapul ni mannenneng hu sigud ni bilang ni daka kapyaa. Eleg mabalin ni an mekullangan, anin hakey. Mahigadda dedan, et humman hu, daka ibbagabagan hi-gak e pellaw kudda kunu et da iappitan etan Dios da. ");
INSERT INTO ify_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Edumi yu ngunnuen da ma-lat wadan kenayun hu ngunnuen da et endi inna-nu dan an mandeddengngel ni itek.” ");
INSERT INTO ify_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Et ehelen idan nunman ni kamengipappangnguludda etan ni himbut e kanday “In-olden etan ni patul e eleg dakeyu law iddawsin dagemi ");
INSERT INTO ify_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","et ngenamung kayun an menemmak, anin ni di attu. Nem mahapul ni mannenneng hu sigud ni bilang ni yuka kapyaa.” ");
INSERT INTO ify_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Et hinapen idan helag Israel hu Egypt ni hamak dan dagemi. ");
INSERT INTO ify_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kaippilit idan kamengipappangngulu e mahapul ni kapyaen da etan bilang ni daka kapyaan nunman lan ida kameidwasin dagemin kapyaen da. ");
INSERT INTO ify_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nem eleg da hangkapya hu henin nunman ni bilang et yadda etan helag Israel ni nepilin mengipappangngulu hu nengipenuyuan da et pambaigen dadda. Et kandan hi-gaday “Kele kulang law hu yuka kapyaan nunya e beken ni henin nunman?” ");
INSERT INTO ify_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Entanni et lumaw ida humman ni helag Israel ni kamengipappangngulu et kanda etan ni patul ey “Apu patul, kele hanniman hu yuka pehpehding ni hi-gami? ");
INSERT INTO ify_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Insiked yun um-idwat ni dagemi ey kanyuy kapyaen mi hu henin kadinakkel ni mika kapyaan nunman? Ey dakemi kapanbaiga ey beken ni hi-gami kambahul.” ");
INSERT INTO ify_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nem kan etan ni patul ey “Makahhiga kayu kumaddan e eleg yu pinhed ni mangngunnu, et humman hu, yuka ibbagabagan hi-gak e i-abulut ku ma-lat lumaw kayun an man-appit ni Ap-Apu yu. ");
INSERT INTO ify_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pambangngad kayu kumad yuka pangngunnui. Endi an meidwat ni hi-gayun dagemi. Mahapul ni kapyaen yu hu bilang ni brick ni yuka kapyaan nunman.” ");
INSERT INTO ify_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Yan nunman hu nengamtaan idan nunman ni kamengipappangngulun helag Israel e endi mabalin ni da pehding nem u-unnuden da humman ni olden e mahapul ni kapyaen dan kewa-wa-wa hu sigud ni bilang ni brick ni daka kapyaa, anin ni endi meidwat ni hi-gadan dagemi. ");
INSERT INTO ify_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Negibbuh ni nekihummangan idan etan ni patul et umhep ida, ey wadad Moses nan Aaron ni kamanehhegged ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Et kandan hi-gaday “Hi Apu Dios hu mengastigun hi-gayu tep ya impahding yu himmulun et deh e anggebe-hel dakemi law etan ni patul et yadda opisyal tu. Et humman kumedek pay hu umhulun ni pemetteyan dan hi-gami.” ");
INSERT INTO ify_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Et makihummangan mewan hi Moses nan Apu Dios e kantuy “Kele muka i-abulut ida tuum ni manhelheltap? Kaw ya nengitu-dakan mun hi-gak ey ma-lat manhelheltap ida? ");
INSERT INTO ify_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tam meippalpu kumedek eman ni nak nekihummanganan etan ni patul et peamtak etan inhel mun hi-gak ey nema-man tudda kapanhelheltap ni peteg. Ey endi kammun baddangan mudda ma-lat meihwang ida.” ");
INSERT INTO ify_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hinumang Apu Dios hi Moses e kantuy “Yan nunya ey ang-angen mu law hu pehding ku etan ni patul. Pilliten kun mengipellaw ni hi-gayun tuuk. Et hi-gatu ngu mengittu-dak ni hi-gayu et hi-yanen yu hu bebley dan penang-angan tun et-eteng ni kabaelan ku. ");
INSERT INTO ify_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nampeang-ang ngak lan Abraham, hi Isaac, et hi Jacob et ya amta da ey hi-gak hu Apu Dios e Kabaelan tun emin. Nem eggak peamtan hi-gada e ya ngadan kun impeamtak nunya e hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nekitballak ni hi-gada niyaddalli helag da e iddawat kun hi-gada hu Kanaan e nekibebleyan da lan nunman. ");
INSERT INTO ify_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ey yan nunya ey peamnuk humman ni inhel kun hi-gada, tep dingngel ku kapampehemmehemmekiddan tuuk ni impanhimbut idan iEgypt. ");
INSERT INTO ify_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","7","Et humman hu, ehel muddan edum mun helag Israel e hi-gak hu Ap-Apu. Peang-ang ku hu et-eteng ni kabaelan kud nemahhig ni pengastiguk idan iEgypt, ma-lat pappegen ku hu nanhimbutan yun hi-gada niya ma-lat meihwang kayud yuka panhelheltapi. Et yallin pengippahdingan kun nunya hu pengamtaan yu e tuu dakeyun hi-gak e Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ippangulu dakeyu etan di bebley ni insapatah kun iddawat kun Abraham, hi Isaac et hi Jacob et hi-gayu memeltan ni nunman ni puyek ma-lat pambebleyan yu. Et nemnemen yu e hi-gak hu Ap-Apu yu.” ");
INSERT INTO ify_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Et lumaw hi Moses et tu ehlen idan edum tun helag Israel hu inhel Apu Dios nem eleg da kulluga tep ya nemahhig ni daka panhelheltapi ey nedismayah ida. ");
INSERT INTO ify_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lakkay di kad-an etan ni patul et mu ehlen e mahapul ni pellaw tudda tuuk ni helag Israel et hi-yanen da eya bebley.” ");
INSERT INTO ify_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nem kan Moses ey “Nem ang-ang mu kedi, anin idan edum kun helag Israel et eleg da-ak kulluga, nekamma-ma ngun etan ni patul e eleg tuwak kulluga tep beken nak ni nelaing ni umhapit.” ");
INSERT INTO ify_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Et mandalen Apu Dios di Moses nan Aaron e kantun hi-gaday “Elaw kayu et yu ehelen etan ni patul niyadda edum yun helag Israel e in-olden kun ippangulu yudda helag Israel et hi-yanen yu Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Huyyadda tenten ni edum ni helag Israel e hi Jacob: yadda u-ungngan Reuben e pengulwan ey hi Hanok, hi Pallu, hi Hesron et hi Karmi. Huyyadda kamengipappangnguluddan pewen ni pamilyah Reuben. ");
INSERT INTO ify_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Yadda u-ungngan Simeon e neihned ey hi Jemuel, hi Jamin, hi Ohad, hi Jakin, hi Sohar et hi Saul e ya inetu ey iKanaan. Huyyadda kamengipappangnguluddan pewen ni pamilyah Simeon. ");
INSERT INTO ify_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yadda u-ungngan Levi ey hi Gerson, hi Kohat et hi Merari. Hi Levi ey hanggatut et telumpulut pitu hu toon tu et han matey. ");
INSERT INTO ify_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Yadda u-ungngan Gerson ey hi Libni et hi Simei. Nahlag ida dama et dumakkel ida. ");
INSERT INTO ify_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Yadda u-ungngan Kohat ey hi Amram, hi Ishar, hi Hebron et hi Ussiel. Hi Kohat ey hanggatut et telumpulu et tellu toon tu et han matey. ");
INSERT INTO ify_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Yadda u-ungngan Merari ey di Mahli nan Mushi. Emin ida eya nengadan ey u-ungngan Levi niyadda helag dadda. ");
INSERT INTO ify_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Hi Amram ey inahwa tu hi Jokebed e agin ametu et man-ungngadda et di Moses nan Aaron. Hanggatut et telumpulut pitu toon Amram et han metey. ");
INSERT INTO ify_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yadda u-ungngan Ishar ey hi Korah, hi Nepheg, et hi Sikri. ");
INSERT INTO ify_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Yadda u-ungngan Ussiel ey hi Mishael, hi Elsaphan et hi Sitri. ");
INSERT INTO ify_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Hi Aaron ey inahwatu hi Elisheba e agin Nashon e u-ungngan Amminadab. Yadda u-ungnga da ey hi Nadab, hi Abihu, hi Eleasar et hi Ithamar. ");
INSERT INTO ify_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Yadda u-ungngan Korah ey hi Assir, hi Elkanah, et hi Abiasap. Huyyadda helag Korah. ");
INSERT INTO ify_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Hi Eleasar e u-ungngan Aaron, ey inahwa tu hu u-ungngan Putiel et mahlag ida et hi Pinehas. Emin ida huyyan nengadan ey hi-gada kamengipappangngulun helag Levi niyadda pamilyah da. ");
INSERT INTO ify_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Di Moses nan Aaron e netenten ni helag Levi hu minandal Apu Dios ni mengippengnguluddan helag Israel ni meni-yan ni Egypt. ");
INSERT INTO ify_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Hi-gada hu nekihummangan etan ni patul di Egypt et iebulut tu helag Israel ni meni-yan ni Egypt. ");
INSERT INTO ify_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Yan nekihummanganan Apu Dios nan Moses di Egypt ey kantuy “Hi-gak hu Ap-Apu. Elaw kad kad-an ni patul et mu ehelen emin eya e-helen kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Nem kan Moses ey “Inamtam e beken nak ngu katteg ni mahepit. Hipa hu inna-nu etan ni patul ni mengullug ni hi-gak?” ");
INSERT INTO ify_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ey kan Apu Dios nan Moses ey “Iddawtan dakan et-eteng ni kabaelan mu, ma-lat hi-gam hu mengi-ehneng ni hi-gak di hinanggan patul di Egypt. Ey hi agim e hi Aaron hu heni prophet mu. ");
INSERT INTO ify_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ehel mun Aaron emin hu e-helen kun hi-gam et ehlen tu etan ni patul, ma-lat iebulut dakeyun helag Israel ni meni-yan ni Egypt. ");
INSERT INTO ify_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","5","Nem pambalin ku etan patul ni manghay et kahingen tu e-helen yun hi-gatu, anin ni dakel hu anggetakkut ni pehding kud Egypt. Nemahhig ali hu pengastiguk idan iEgypt et han dakeyu ipengulun hi-gak ni meni-yan ni nunman ni bebley. Yan nunman ali hu pengamtaan da e hi-gak hu Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Et u-unnuden di Moses nan hi Aaron ni emin hu inhel Apu Dios ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Yan nunman ni da nekihummanganan etan ni patul ey newalu et tellu toon nan hi Aaron ey newalu hu toon nan hi Moses. ");
INSERT INTO ify_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kan Apu Dios di Moses nan hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Hedin ibbaga etan ni patul e mahapul ni peang-ang yu hu miracle ni pengullugan tu e intu-dak dakeyun hi-gak, ey ehel mun Aaron et bekahen tu etan hulkud di hinangga etan ni patul niyadda opisyal tu. Et humman ni hulkud ey mambalin ni uleg.” ");
INSERT INTO ify_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Et lumaw di Moses nan Aaron di kad-an etan ni patul e inu-unnud da hu inhel Apu Dios ni hi-gada. Bingkah nan Aaron hu hulkud tud hinangga etan ni patul niyadda opisyal tu ey nambalin tu-wangun uleg. ");
INSERT INTO ify_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","12","Nem ineyagan dama etan ni patul hu nangkelaing niyadda etan kamenippahding ni magic ni iEgypt et bekahen da hulkud da ey nambalin ida daman uleg. Nem kinan ni uleg nan Aaron ida. ");
INSERT INTO ify_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nem manghay damengu etan patul e eleg tu kullugad Moses nan Aaron e humman dedan hu inhel nan Apu Dios ni meippahding. ");
INSERT INTO ify_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Entanni ey kan Apu Dios nan Moses ey “Deh manghay ni peteg etan patul et eleg tu i-abulut ni hi-yanen yun tutu-uk hu Egypt. ");
INSERT INTO ify_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Et humman hu, elaw kallin an menammu etan ni patul ni lawwan tun kakkabbuhhan di Wangwang e Nile et hegeden mu etan di gilig tu. Ey itebin mu etan hulkud ni impambalin mu lan uleg. ");
INSERT INTO ify_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Et kammun hi-gatuy ‘Intu-dak tuwak ni Ap-Apu e Dios middan Hebrew ni menghel ni hi-gam ma-lat iebulut dakemin umlaw ni an menaydayaw ni hi-gatu etan di eleg mebebleyi. Nem ingganah ni nunya ey kahing ka. ");
INSERT INTO ify_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Et humman hu, amtaen mu law ni nunya, e hi-gatu hu Ap-Apu etan di ippahding tu. Ihheplat ku eya hulkud eyad Wangwang et mambalin ni kuheyaw hu danum. ");
INSERT INTO ify_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mangkettey iddalli hu deleg et manhahamuy hu danum et eleg mabalin ni yu innumen.’ ");
INSERT INTO ify_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ey ehel mu daman Aaron et tu idengdeng hulkud tuddad wangwang, yaddad kulukul niyaddad lebeng di ditan Egypt et mambalin ni emin hu danum diman ni kuheyaw, anin idan inehul da.” ");
INSERT INTO ify_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Impahding di Moses nan Aaron di hinangga etan ni patul niyadda opisyal tu hu inhel Apu Dios ni hi-gadan pehding da. Inheplat Aaron hu hulkud tud danum etan di wangwang et mambalin etan danum ni kuheyaw. ");
INSERT INTO ify_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ey nangketey ida hu deleg et mahemuy etan danum et eleg mabalin ni innumen idan iEgypt. Et humman hu neipahding e nambalin ni kuheyaw emin hu danum di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nem yadda dama magician di Egypt ey impambalin da danum ni kuheyaw. Et humman hu, nanengtun manghay etan patul, eleg tu u-unnuden hu inhel di Moses nan Aaron e humman dedan hu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nealay nanligguh etan patul et manglaw di baley tu e eleg tun hekey hanguden etan impahding da. ");
INSERT INTO ify_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Et wada hakkey idan iEgypt ey nengu-kuddad gilig ni Wangwang e Nile ni pan-ehhulan da tep nambalin emin hu danum ni kuheyaw. ");
INSERT INTO ify_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nelabah hu pitun aggew neipalpu eman ni impambalin Apu Dios hu Wangwang e Nile ni kuheyaw. ");
INSERT INTO ify_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Entanni ey immehel mewan hi Apu Dios nan Moses ey kantuy “Lakkay mewan et mu ehlen etan ni patul e kammuy ‘Kan ni Ap-Apu mi ey iebulut mudda tuuk et lumaw idan menaydayaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tep hedin kahing ka ey peelli tu hantapug ni tukak et um-apnal ida eyad bebley yu. ");
INSERT INTO ify_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mekapkapnullin tukak hu Wangwang e Nile et humman hu um-aliddalli edum eyad baley mu, yad baley idan opisyal mu, niyad baley idan tutu-um. Umhehgep idad kuwaltuh mu, ey umlaw idad uggippan mu, yaddad yuka pene-engi, anin idad bangeyu. ");
INSERT INTO ify_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ey anin alin attu kad-an yuddan opisyal mu et ya tuum ey um-alidda hu tukak ni hi-gayu.’ ");
INSERT INTO ify_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ey ehel mun Aaron et idengdeng tu hulkud tuddad emin di wangwang, yad kulukul niyaddad lebeng di Egypt ma-lat maukat hu dakel ni tukak et umapnal idan emin di puyek di Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Et idengdeng nan Aaron etan hulkud etan idad wada danum ey neukat idalli dakel ni tukak et mapnu hu bebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nem impahding ida damaddan magician hu hanniman e impaukat da dama hu dakel ni tukak. ");
INSERT INTO ify_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Et paeyag etan ni patul di Moses nan Aaron et kantuy “Pandasal kayun Ap-Apu yu ma-lat ekalen tudda tukak et iebulut kun umlaw kayu et yu iappitan etan Ap-Apu yu.” ");
INSERT INTO ify_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kan Moses ey “Getud mu hu aggew et idasalan dakeyun emin idan opisyal mu niyadda tuum, ma-lat meendidda eya tukak et ebuh di Wangwang e Nile ni panha-adan da.” ");
INSERT INTO ify_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kan etan ni patul ey “Yan kabbuhhan.” Et kan Moses ey “Dammutu hedin humman hu pinhed mu ma-lat pengamtaam e endi hu edum ni dios ni henin Ap-Apu e Dios mi. ");
INSERT INTO ify_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Endiddalli law eya tukak ni kamenuddukul ni hi-gayuddan opisyal mu niyadda tuum et ebuh alid Wangwang e Nile ni wada tukak.” ");
INSERT INTO ify_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Et hi-yanen di Moses nan Aaron etan patul et mandasal hi Moses nan Apu Dios ma-lat ekalen tudda etan dakel ni tukak ni impaeli tu. ");
INSERT INTO ify_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Dingngel Apu Dios hu dasal Moses et mangkatey ni emin hu tukak di baballey, yaddad aldattan niyad papayyew. ");
INSERT INTO ify_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Et pan-amungen idan iEgypt e pinenuppu-ul dadda. Entanni et nabwel ida etan tukak ey nemahhig ni kamanhemmuy etan bebley. ");
INSERT INTO ify_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nem yan nenang-angan etan ni patul e endidda law hu tukak ey kahing mewan et eleg tudda u-unnudad Moses nan Aaron e humman dedan la inhel Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kan mewan Apu Dios nan Moses ey “Ehel mun Aaron et iheplat tu etan hulkud tud puyek et mangkapyaddan emin hu dep-ul di Egypt ni imuk.” ");
INSERT INTO ify_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Et iheplat nan Aaron hu hulkud tu ey nangkapya hu dep-ul ni imuk. Et nemahhig e daka keammuammungidda tuu niyadda animal. Dakel ni peteg hu imuk anin di attun bebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Impatna-et damaddan magician ni pambalin hu dep-ul ni imuk, nem eleg da han-ipahding. ");
INSERT INTO ify_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Et kanda etan ni patul ey “Hi Apu Dios hu nengipahding ni nunya.” Nem nanengtun kahing etan patul e humman dedan la inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kan mewan Apu Dios nan Moses ey “Haleman kallin kabbuhhan et mu hegeden etan patul di wangwang et kammun hi-gatuy ‘Kan Apu Dios ey i-abulut mudda tuuk et lumaw idan menaydayaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nem hedin kahing ka, kastiguen dakeyu e peelli tu dakel ni allahhing et keam-amungan dakeyulli, anin idallin opisyal mu niyadda tuum. Ey nemahhig e mepnuddalli baballey yu. Ey anin attu lawwan yu et dakel alin peteg hu allahhing e endilli gessinen yu. ");
INSERT INTO ify_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nem endilli ngu allahhing di Goshen e nambebleyan idan tuuk. Huyya pehding ku e Apu Dios ma-lat pengamtaan mu e hi-gak hu Ap-Apu, ey hi-gak hu kamengippenahding eyaddan kamekapkapyadya Egypt. ");
INSERT INTO ify_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Hi-gak ey amtak hu tuuk niya amtak tuum. Et huyyan miracle ey ippahding kun kabbuhhan.’” ");
INSERT INTO ify_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Et mewa-wa ey nemahhig hu kapanligligasiddan tuud emin ni bebley di Egypt tep impaelin Apu Dios hu dakel ni allahhing. Et anin di baley etan ni patul et yad baley idan opisyal tu niyadda tuu tu ey napnun allahhing. ");
INSERT INTO ify_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Et paeyag mewan etan ni patul di Moses nan Aaron et kantuy “Lakkayuy et yu iappitan hu Dios yu, nem yadya e bebley mi hu pengippahdingan yu.” ");
INSERT INTO ify_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nem hinumang nan Moses e kantuy “Eleg mabalin ni yadya hu pan-appitan mi tep anggebe-hel ni peteg idan tuum hu keklengen min i-appit min Ap-Apu e Dios mi. Et kaw eleg dakemilli tengbaa hedin yadya pan-appitan mi? ");
INSERT INTO ify_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Mahapul ni u-unnuden mi hu kan ni Ap-Apu e Dios mi e umlaw kamin an man-appit ni hi-gatu etan di eleg mebebleyi e tellun aggew hu pandellanan.” ");
INSERT INTO ify_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kan nunman ni patul ey “Anin i-abulut dakeyun an man-appit ni Ap-Apu e Dios yu etan di eleg mebebleyi hedin eleg kayu um-eddawwin peteg. Ey idasali yuwak dama.” ");
INSERT INTO ify_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Hinumang Moses et kantuy “Yan lawwan mi ey mandasallak nan Apu Dios ma-lat ma-kal ida allahhing di bebley yuddan opisyal mu niyadda tuum. Nem entan dakemi mewan haul e hedin neendidda etan allahhing ey eleg dakemi i-abulut ni umlaw ni an man-appit ni Dios mi.” ");
INSERT INTO ify_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Et ebuhe hi-yanen di Moses etan patul et mandasal nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Dingngel Apu Dios hu dasal tu et meendiddan emin etan allahhing et anin hakey ey endi. ");
INSERT INTO ify_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nem ngimmehay mewan etan patul et eleg tudda mewan i-abulut ni umlaw. ");
INSERT INTO ify_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kan mewan Apu Dios nan Moses ey “Mu ehel etan ni patul e kammuy ‘Kan ni Ap-Apu e Dios min Hebrew ey iebulut mudda tuuk et lumaw idan menaydayaw ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Hedin kahing ka et eleg mu mewan i-abulut idan umlaw, ");
INSERT INTO ify_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","kastiguen daka e peellik hu pistin animal ma-lat mangkatey ida kebayyu yu, kamel yu, baka yu, kalneroh yu niya gelding yu. ");
INSERT INTO ify_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nem endillin hekey hu mettey ni animal idan helag Israel, tep immatunan ku hu animal yun iEgypt et humman ida petteyen ku. ");
INSERT INTO ify_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Et hi-gak e Ap-Apu ey ippahding ku huyyan kabbuhhan.’” ");
INSERT INTO ify_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ey tu-wangu e yan newa-waan tu ey impahding Apu Dios hu inhel tu et mangkatey ida animal idan iEgypt, nem endin hekey netey ni animal idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Immitu-dak etan patul ni an mammahmah ni meippanggep ni animal idan helag Israel, ey kanday makulug numan ni endi netey ni animal da. Nem nanengtun kahing etan patul et eleg tudda palaw. ");
INSERT INTO ify_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kan Apu Dios di Moses nan Aaron ey “Kayu gamal ni dep-ul di appuyyan et petu-ug nan Moses ni ihhebwag di hinanggan etan ni patul. ");
INSERT INTO ify_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ya etan dep-ul ey um-ehbuk et meihhinnap alid emin di Egypt et mangkepelhaan idallin emin hu tuu niyadda animal.” ");
INSERT INTO ify_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Et ida umlan dep-ul et lumaw idad kad-an etan ni patul et petu-ug nan Moses ni inhebwag. Entanniy nangkepelhaan tu-wangu emin hu tuud Egypt anin idan animal da. ");
INSERT INTO ify_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Et endi law hu mabalin ni ippahding etan ni magician, tep anin ni hi-gada et yadda edum dan iEgypt ey nangkepelhaan ida dama. ");
INSERT INTO ify_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nem mina-man nan Apu Dios hu ngehay etan ni patul et eleg tu u-unnuden di Aaron nan Moses e humman dedan la hu inhel Apu Dios nan Moses ni ippahding tu. ");
INSERT INTO ify_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kan Apu Dios nan Moses ey “Haleman kan kabbuhhan ma-lat mu mewan hegeden etan patul et kammun hi-gatuy ‘Kan Ap-Apu e Dios min Hebrew ey iebulut mudda tuuk ma-lat lumaw idan menaydayaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tep hedin kahing ka et eleg mudda pellaw, ey beken ni ebuh ida opisyal mu et yadda tuum ni kastiguen ku, nem anin ni hi-gam ma-lat pengamtaan mu e endi edum ni dios ni henin hi-gak eyad puyek. ");
INSERT INTO ify_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tep gullat na-mun impaelik hu nemahhig ni degeh et nanna-ud ni netey kayun emin. ");
INSERT INTO ify_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nem ninemnem ku dedan e eleg dakeyu petteya ma-lat ang-angen yu et-eteng ni kabaelan ku, ey ma-lat mandingngel hu ngadan tud emin ni tuud kebebbebley. ");
INSERT INTO ify_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nem ay ingganah ni nunya ey nanengtun manghay ka e eleg mu i-abulut ni umlaw ida tuuk. ");
INSERT INTO ify_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Et humman hu yan kabbuhhan ni henin nunyan olas, ey peellik hu nemahhig ni dallallu e endin hekey hu henin nunman neipalpu eman ni nambalin huyyan bebley. ");
INSERT INTO ify_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Et humman hu iolden muddan tuum ma-lat ihidum dadda animal da niya hipaddan wadan hi-gayu. Tep hedin peellik hu dallalu ey mettey emin tuu niya animal ni eleg maihidum.’” ");
INSERT INTO ify_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yadda edum ni opisyal etan ni patul ey simmakut ida etan ni inhel tu et dadda pan-ihidum hu bega-en da et yadda animal da. ");
INSERT INTO ify_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Nem yadda edum ey kahing idan inhel Apu Dios et eleg dadda pan-ihhidum hu bega-en da et yadda animal da. ");
INSERT INTO ify_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kan Apu Dios nan Moses ey “Idengdeng mu hulkud mud kabunyan et ma-gah idalli dallallu et mangka-gahan ida tuu, yadda animal niyadda intanem di Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Indengdeng nan Moses hulkud tud kabunyan ey impaeli tu-wangun Apu Dios di Egypt hu dallallu ey kamangkikidul niya kamangkekedyam. ");
INSERT INTO ify_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Nemahhig hu dallallu niya kedyam e anggetakkut ni peteg. Ey endi henin nunman di Egypt neipalpun nekapyaan nunman ni bebley. ");
INSERT INTO ify_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Et mangkebahbah ida neitnem ey nangketey ida tuu niyadda animal ni nangka-gahan ni dallallu. ");
INSERT INTO ify_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ebuh di Goshen e nambebleyan idan helag Israel ni endi na-gah diman ni dallallu. ");
INSERT INTO ify_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Impaeyag etan ni patul di Moses nan Aaron et kantun hi-gaday “Nakka ebbuluta e nambahullak. Neiptek hi Apu Dios ey neihla kamiddan tuuk. ");
INSERT INTO ify_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pandasal kan Apu Dios ma-lat pasiked tu eya kidul niya dallallu! Et iebulut kun umlaw kayu.” ");
INSERT INTO ify_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","30","Kan Moses ni hi-gatuy “Anin ni hannitan hu ehel mu ey amtak metlaing e hi-gam niyadda opisyal mu ey eleg kayu umtakut nan Apu Dios. Nem anin, hedin um-a-allawwak eyad bebley ey itta-gey ku ngamay ku et mekihhummangan nak nan Apu Dios et pasiked tu eya kidul niya dallallu. Humman pengamtaan mu e bagin Apu Dios eya puyek ni nambebleyan tayun tuu.” ");
INSERT INTO ify_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","Yadda neitnem ni kandan flax niya barley e ngannganih ni me-teng ey nangkebahbah. Nem eleg mebahbah hu intanem dan wheat niya spelt tep eleg ida ni pay tummel. ");
INSERT INTO ify_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Limmaw hi Moses di a-allaw etan ni bebley et ita-gey tu ngamay tu et mandasal nan Apu Dios ey nesiked hu kidul, ya udan niya dallallu. ");
INSERT INTO ify_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nem nesiked ida humman ey nanliwat mewan etan patul niyadda opisyal tu tep kahing ida mewan. ");
INSERT INTO ify_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Immamnu hu inhel Apu Dios nan Moses e eleg i-abulut etan ni patul ni umlaw ida helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kan Apu Dios nan Moses ey “Lakkay di kad-an etan ni patul et ka mewan makihummangan ni hi-gatu. Nem impambalin kun manghay anin idan opisyal tu ma-lat wada inna-nuk ni mengippeang-ang idan nunyan miracle. ");
INSERT INTO ify_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Et e-ehhelen yuddallin u-ungnga yu niya inap-apu yun edum ni aggew hu meippanggep idan nunyan impahding kun miracle ni nengastiguk idan eyan iEgypt. Et amtaen yun emin e hi-gak hu Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Et lumaw di Moses nan Aaron et kanda etan ni patul ey “Kan etan ni Ap-Apu e Dios min Hebrew ey ‘Pigantu pampekumbabahan mun hi-gak? Iebulut mudda tuuk et lumaw idan menaydayaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","5","Hedin nanengtun manghay ka et eleg mu i-abulut ida tuuk ni umlaw ey peellik ni kabbuhhan eyad bebley yu hu dakel ni dudun. Nemahhig e napnapan dallin emin hu puyek et endin hekey hu meang-ang ni puyek. Et kennen dallin emin hu intanem ni natdaan ni eleg bahbahen ni dallallu, anin idan keyew. ");
INSERT INTO ify_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mepnu baley mu, ya baley idan opisyal mu niya baley idan tuum. Huyyan mekapya ey nemahhig e anin ida lan a-ammed yu ey endi da inang-ang ni henin nunya neipalpun laputun nambebleyan dadya.’” Inhel Moses huyya et hi-yanen tu etan patul. ");
INSERT INTO ify_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yadda etan opisyal ey ida nanlilih etan ni patul da e kanday “Nekele, pigantu pengissikedan eyan tuun um-enidwat ni panligligatan tayu? Iebulut mudda eya helag Israel et lumaw idan an menadayaw ni Ap-Apu e Dios da. Kaw eleg mu ang-anga e nebahbah law eya bebley tayu?” ");
INSERT INTO ify_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Et paeyag etan ni patul di Moses nan Aaron et kantun hi-gaday “Dammutun i-abulut dakeyun umlaw et yu dayawen hu Ap-Apu e Dios yu. Nem kaw hipaddan hi-gayu umlaw?” ");
INSERT INTO ify_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Kan Moses ey “Mahapul ni umlaw kamin emin, anin idan u-ungnga mi, yadda nangkea-amma, yadda nangkei-inna niyadda animal mi ey peki-la min emin tep mahapul ni mampiyestah kami et manhahamul kamin menaydayaw ni Ap-Apu mi.” ");
INSERT INTO ify_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kan etan ni patul ey “Isapatah kud ngadan Apu Dios e eggak i-abulut ni mekillaw ida ahwa yu niya u-ungnga yu. Neaamta e wada lawah ni yuka nemnemneman pehding. ");
INSERT INTO ify_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ebuh hu lalakkin i-abulut kun umlaw ni an menaydayaw etan ni Ap-Apu e Dios yu tep ay humman hu muka ibbagan pehding yu.” Inhel tu humman et pa-hep tud Moses nan Aaron etan di baley tu. ");
INSERT INTO ify_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kan Apu Dios nan Moses ey “Ita-gey mu ngamay mu et umli dakel ni dudun di deya Egypt et kanen da emin hu sindaan ni dallallu.” ");
INSERT INTO ify_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Et ildeng nan Moses hu hulkud tud Egypt et paelin Apu Dios hu dibdib ni nalpud kasimmilin aggew, et ia-aggew tu niya inlallabi tun dimmenibdib. Ey yan newa-waan tu ey dakel ni peteg hu dudun ni in-alin etan ni dibdib. ");
INSERT INTO ify_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nemahhig e nenapnapan emin hu bebley di Egypt ni dudun. Endi la hanneyan ni kedakkel ni dudun di Egypt ey endilli hanneyan ni meippahding diman. ");
INSERT INTO ify_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Immepadda ey andeket hu kameang-ang. Kinan dan emin hu neitnem ni sindaan ni dallallu et endin hekey hu natdaan anin idan lameh ni keyew. Et emin di Egypt ey endin hekey hu kameang-ang ni bulung winu lameh ni neitnem. ");
INSERT INTO ify_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Et pagegannun etan ni patul ni impaeyag di Moses nan Aaron et kantun hi-gaday “Nakka ebbuluta e nanliwat tak nan Ap-Apu yu e Dios yu niya nambahullak ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Et humman hu pesinsahi yuwak anhan et mandasal kayu etan ni Ap-Apu e Dios yu et pasiked tu eya tuka pampalpaligat ni hi-gamin umhulun ni ketteyyan mi.” ");
INSERT INTO ify_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Et hi-yanen nan Moses etan patul et mandasal nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ey dingngel Apu Dios hu dasal nan Moses et bangiwen tu pellawwan ni dibdib, et palaw tud appit ni kasimmilin aggew et ityab tuddan emin hu dudun. Et endin hekey hu dudun di Egypt tep inlaw ni dibdib emin di Madlang ni Baybay. ");
INSERT INTO ify_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nem impambalin Apu Dios etan patul ni manghay et eleg tu mewan palaw ida etan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kan mewan Apu Dios nan Moses ey “Ita-gey mu hu ngamay mu e idengdeng mud kabunyan et ma-ngetan emin hu bebley di Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Inta-gey Moses hu ngamay tu ey na-ngetan emin hu bebley di Egypt ni tellun aggew. ");
INSERT INTO ify_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Et yadda iEgypt ey eleg da han-ang-ang hu anin hipa et eleg ida man-u-ukkat di baley dan tellun aggew. Nem yadda helag Israel ey kawwalwal ngu dedan di nambebleyan da. ");
INSERT INTO ify_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Impaeyag mewan etan ni patul hi Moses et kantun hi-gatuy “Lakkayuy et yu dayawen hu Ap-Apu e Dios yu. Dammutun mekillaw ida ahwa yu niyadda u-ungnga yu, nem entan peki-ladda animal yu henin kalneroh yu, gelding yu niya baka yu.” ");
INSERT INTO ify_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ey kan Moses ey “Eleg mabalin hu hanniman tep mahapul ni i-appitan mi hu Ap-Apu e Dios mi. ");
INSERT INTO ify_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Et humman hu mahapul ni peki-la min emin hu animal mi. Eleg man ahan mabalin ni yadya hu pampillian min animal ni i-appit min hi-gatu tep mahapul ni umdateng kamidman et han mi amtaa hu pillien min i-appit min hi-gatu.” ");
INSERT INTO ify_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nem impambalin mewan Apu Dios ni manghay etan patul et eleg tu pellaw ida etan Hebrew. ");
INSERT INTO ify_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Kan etan ni patul nan Moses ey “A-allaw kadya! Entan ali law pampeang-ang ni hi-gak tep petteyen daka hedin!” ");
INSERT INTO ify_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Kan Moses ey “Hi-gam apu patul hu meu-unnud. Eggak ali law mampeang-ang ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kan dedan lan Apu Dios nan Moses ey “Hakey law huyyan ligat ni peellik etan ni patul et yadda tuu tu. Et hedin megibbuh huyya ey i-abulut dakeyun umlaw. Ey ya kakulugan tu ey hi-gatu mengittu-dak ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Et ya pehding mu ey ehel muddan tuum et mambagaddan sinakdul yun iEgypt ni gamgam ni balituk niya silber.” ");
INSERT INTO ify_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yan nunman ey impambalin Apu Dios ida iEgypt ni nekalispituh niya kabbabbal daddan helag Israel. Ey anin idan opisyal ni patul niyadda tuu tu ey imbilang da hi Moses ni eta-gey hu saad tu. ");
INSERT INTO ify_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Et kan pay Moses etan ni patul ey “Kan etan ni Ap-Apu mi ey yallin gawan hileng ey um-ali et hinnapen tu emin hu bebley yud Egypt ");
INSERT INTO ify_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et emin hu pengulwan ni u-ungnga yun laki ey mettey. Meippalpun u-ungngam, e hi-gatu-et hu meihhayned ni hi-gam ni man-ap-apu, et ingganah ni pengulwan ni u-ungngaddan kebabahan ni bega-en mu et yadda nemangulun impah ni animal yu ey mettey ida. ");
INSERT INTO ify_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Medngel ali hu nangih ni endi tu neiingngehan tep endi neipahding ni henin nunyan nunman la ey endilli law henin nunyan meippahding. ");
INSERT INTO ify_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nem yadda helag Israel ey melinggep idalli tep endi meippahding ni hi-gada, anin idan animal da. Ey anin idan ahhu da et endi an umgunggung. Yan nunman ali pengamtaan yu e nambaklang hu kapengibbillang Apu Dios idan helag Israel et hi-gayuddan iEgypt. ");
INSERT INTO ify_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ey emin idalli opisyal mu ey um-aliddan manyu-ung ni mampehemmehemmek ni hi-gak ma-lat ipenguluk ida tuuk et hi-yanen mi eya Egypt. Ey makulug ni umlaw kami.” Inhel Moses humman et umhep e nemahhig bunget tu. ");
INSERT INTO ify_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kan dedan lan Apu Dios nan Moses ey “Nanengtun eleg dakalli u-unnuda etan ni patul ma-lat peang-ang ku dakel ni miracle di deya Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Et humman hu, anin impahding di Moses nan Aaron ida emin huyyan miracle di hinanggan etan ni patul, ey eleg tu i-ebulut ni umlaw ida etan helag Israel tep impambalin Apu Dios ni manghay. ");
INSERT INTO ify_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Entanni ey kan mewan Apu Dios di Moses nan Aaron di Egypt ey ");
INSERT INTO ify_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Huyyan bulan hu memengngulun bulan ni hantoon. ");
INSERT INTO ify_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ehel yuddan edum yun helag Israel ma-lat yallin meikkeppulun aggew ni nunyan bulan ey wada hakkey ni pamilyah ey umpilin impah ni kalneroh ni ihhideda e hanhakkey di hakey ni pamilyah. ");
INSERT INTO ify_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Hedin wada pamilyah ni eleg da han-epuh etan hakey ni kalneroh, mabalin ni mekiggedwa hu sinakdul da tep meippuun di kadinakkel etan ni pamilyah niya um-ustuh ni kennen. ");
INSERT INTO ify_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mahapul ni ya kayyaggud ni hantoon tun kalneroh winu gelding hu pillien yu. ");
INSERT INTO ify_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mahapul ni paka-ippaptek yudda huyyan animal ingganah ni mahmahdem ni meikkeppulut epat ni aggew. Et emin kayun helag Israel ey keklengen yun kehillengan tun nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Da-nihi yun kuheyaw hu nambina-hil ni pamedingan niya etan ta-pew ni habyen ni emin ni baballey yun pengikkannan yu. ");
INSERT INTO ify_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Itangtang yudda etan detag ey ihideyud sinapay ni eleg ma-duman ni kamampelbag, ey hidai yun mapeit ni kameitnem. ");
INSERT INTO ify_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Entan tu ekan ni meatta winu entan tu panhina-eng, nem itangtang yu e anin ni ya ulu tu, ya heli tu, ya puhu tu, ya altey tu niya egeh tu. ");
INSERT INTO ify_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mahapul ni kennen yun emin ni mahmahdem ey endi tetdaan yu. Nem hedin wada metdaan man, giheb yu. ");
INSERT INTO ify_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Heninnuy pay hu pehding yu, pambalwasi kayun heni wada lawwan yu niya pampatut kayu ey ala yu hulkud yu. Ey papuut yu ekan tep melebbah nunyan hileng hu anghel kud baballey yu. ");
INSERT INTO ify_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Yan nunman alin hileng ey hinnapen kun emin hu bebley di Egypt et petteyen kuddan emin hu lakin pengulwan ni u-ungngaddan iEgypt niyadda nemangulun impah ni animal da. Ey bahbahen kun emin hu dios dan daka deyyawa, ma-lat pengamtaan da e hi-gak ni ebuh hu Dios. ");
INSERT INTO ify_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ya etan kuheyaw ni idda-ni yud pamedingan yu hu pengimmatunan kun baballey yu et labhan ku ma-lat endi mettey ni hi-gayun ellian kun pemetteyan kuddan pengulwan ni u-ungngaddan iEgypt. ");
INSERT INTO ify_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mahapul ni pehding yudda eya inhel kun ippahding yu e mampiyestah kayu ma-lat penginemneman yun hi-gak e Ap-Apu yu. Ey ituttuddu yudda damaddan u-ungnga yu niya inap-apu yu huyya ma-lat eleg matelak huyyan elaw. ");
INSERT INTO ify_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pitun aggew hu eleg yu pengngannin sinapay ni neha-adan ni kamampelbag. Ey yan memengngulun aggew ey mahapul ni e-kalen yudda emin hu kamampelbag ni sinapay di baballey yu. Tep hedin wadan hi-gayu hu mengngan ni sinapay ni neha-adan ni kamampelbag ni sinapay ni nunman ni pitun aggew ey eggak ibbilang ni tuuk. ");
INSERT INTO ify_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Yan lapun aggew et yan meikkeppitun aggew ey meemmung kayu et mandayaw kayun hi-gak. Et endi an mangngunnun nunman idan aggew. Yan ebuh hu mabalin ni ingngunu yu ey ya mengiddaddan ni kennen yun pampiyestahan yu. ");
INSERT INTO ify_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mahapul ni pehding yu huyyan elaw tep yan nunyan aggew hu nengipa-kalan kun hi-gayud Egypt. Ey pannananeng yun ippahding huyyan Piyestah ni Sinapay e eleg meha-adan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Meippalpun mahmahdem ni meikkeppulut epat ni aggew ingganah ni mahmahdem ni meikkadwam pulut hakey ni aggew ni nunman ni nemangulun bulan ey eleg kayu mengngan ni sinapay ni neha-adan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Ey pitun aggew ni endi umkan ni sinapay ni neha-adan ni kamampelbag niya endi an meihha-ad ni kamampelbag di kabeley ni nunman idan aggew. Mahapul ni emin kayu, helag Israel winu beken, ey u-unnuden yu huyya tep ya etan mengehhing et eleg tu u-unnuda ey eggak law ibbilang ni tuuk.” ");
INSERT INTO ify_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Et paeyag ida Moses emin aap-apun helag Israel et kantun hi-gaday “Kayu pilin impah ni kalneroh ni keklengen yun hemmulen ni pamilyah yun pampiyestahan yun Passover e humman la Nelabahan ni Anghel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Niya betek kayun hissop ni itta-mel yu etan di kuheyaw ni kinleng yu et da-nihan yu nambina-hil ni pamedingan niya ta-pew ni habyen ni baley yu. Ey endin hi-gayu um-ehep ingganah ni mewa-wa. ");
INSERT INTO ify_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tep hedin um-alilli hi Apu Dios di emin ni bebley di Egypt ni memettey idan pengulwan ni lakin u-ungngaddan iEgypt et ang-angen tu e wada kuheyaw di nambina-hil ni pamedingan niyad ta-pew ni habyen ni baley yu, pelebbah tu etan anghel tu et eleg dakeyu illagat. ");
INSERT INTO ify_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Hi-gayu niyaddalli helag yu ey mahapul ni ippahding yudda huyyan katootoon ma-lat eleg matelak huyyan elaw. ");
INSERT INTO ify_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Et hedin umdateng kayu etan di lawwan yun puyek ni impakulug Apu Dios ni hi-gayu, ippahding yu huyyan Piyestah ni Passover. ");
INSERT INTO ify_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Hedin mahmahan idan u-ungnga yu e kele mahapul ni pehding yu huyya ");
INSERT INTO ify_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ey kanyun ihhumang yuy ‘Huyya piyestah ni penaydayaw min Apu Dios e i-appitan mi tep linabhan idan anghel tu baballey min helag Israel, et endi tu pinetey ni hi-gami, et ebuh ida ngu pengulwan ni lakin u-ungngaddan iEgypt ni pintey tu.’” Dingngel idan helag Israel humman ey nandukkun ida et dayawen da hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Et u-unnuden da hu inhel di Moses nan Aaron e humman intugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Yan nunman ni gawan hileng ey pintey Apu Dios emin hu pengulwan ni lakin u-ungngaddan iEgypt e neilepud u-ungngan etan ni patul e hi-gatu-et hu meihhayned ni mampatul ingganah di pengulwan ni u-ungngaddan nangkeikelabut, anin ni yadda nemangulun impah ni animal da. ");
INSERT INTO ify_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Yan nunman ni hileng, ey bimmangun etan patul, yadda opisyal tu niyadda emin hu iEgypt ey kanengih ida tep emin di kabeley ey wada netey. ");
INSERT INTO ify_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Et yan nunman ni hileng ey impaeyag etan ni patul di Moses nan Aaron et kantun hi-gaday “Lakkayuy et yudda ipengulu edum yun helag Israel, et manglaw kayu. Hi-yan yu eya bebley mi ma-lat yu dayawen etan Ap-Apu e Dios yu e humman hu yuka ibbagabagan pehding yu! ");
INSERT INTO ify_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pampeki-la yudda kalneroh yu niyadda edum ni animal yu, nem idasali yuwak anhan ma-lat wada dama hu panyaggudak.” ");
INSERT INTO ify_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Kapandegdegaddan iEgypt etan ida helag Israel e kanday “Papuut yu et manglaw kayun emin. Endilli maptek ey mettey kamin emin hedin eleg kayu um-a-allaw di deya!” ");
INSERT INTO ify_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Et panlibutan idan helag Israel hu pinelut dan alinah ni kapyaen dan sinapay ni eleg meha-adan ni mampelbag et libutan dan luput et pampahnen da. ");
INSERT INTO ify_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","36","Et manglaw ida e impeki-la da kinedangyan idan iEgypt tep nambaga idan hi-gadan hubeng, yadda silber niyadda balwasi e inu-unnud da inhel lan Moses ni pehding da. Nan-idwat idan iEgypt huyyan imbageda tep impambalin Apu Dios ni mekallispituh idan hi-gada. Hanniman hu nengal-an idan helag Israel ni kinedangyan idan iEgypt et itebin da. ");
INSERT INTO ify_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Immegah ida helag Israel di Rameses et mandaddallan idan limmaw di Sukkot. Ya bilang dan emin ni neni-yan ni Egypt ey enem ni gatut hu libu nem eleg ida maibilang hu u-ungnga niyadda bibi-i. ");
INSERT INTO ify_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ey dakel hu kalneroh da, gelding da niya baka dan impeki-la da. Dakel ida dama edum ni tuun beken ni helag Israel ni nekilaw ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Hedin nanha-ad ida, kinapya dan sinapay etan itabin dan alinah ni eleg meha-adan ni kamampelbag, tep hinaggadud hu immegahan da, et endi tsimpuh dan nengidaddan ni kennen da. ");
INSERT INTO ify_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Ya bilang ni toon ni nekibebleyan idan helag Israel di Egypt neipalpu eman ni linawwan dadman ingganah ni nunyan peni-yanan da ey epat ni gatut et telumpulun toon. ");
INSERT INTO ify_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Yadda helag Israel ey mahapul ni katootoon ey i-appit dan Apu Dios humman ni hileng ni nengihwangan tun hi-gada et hi-yanen da Egypt. ");
INSERT INTO ify_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Entanni ey immehel mewan hi Apu Dios et kantud Moses nan Aaron ey “Yahhuy hu olden ni meu-unnud ni pengippahdingan yun Piyestah ni Passover. Endi hansinu-wan ni beken ni edum yun helag Israel ni mekikkan ni hi-gayu etan ni indaddan yun kalneroh ni hemmulen yun penginemnemneman yun nelabahan ni anghel ku. ");
INSERT INTO ify_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nem dammutun mekikkan ida himbut yun gintang yu, hedin nekugit ida. ");
INSERT INTO ify_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Eleg mebellin ni mekikkan ida nekibebley ni hi-gayun nalpud edum ni bebley niyadda yuka pangngunnun kametangdani. ");
INSERT INTO ify_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ey mahapul ni kennen yun emin humman ni kalneroh etan di bawang ni baballey yu. Entan tu i-hep ey ang-ang yu et endi an megiplung ni genit nunman ni keklengen yu. ");
INSERT INTO ify_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Emin kayun helag Israel ey mahapul ni ippahding yu huyyan piyestah. ");
INSERT INTO ify_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nem eleg mabalin ni mekikkan hu tuun eleg makugit. Ey hedin wadadda nalpud edum ni bebley ni nekibebley ni hi-gayu et pinhed dan meki-dum ni pengippahdingan yun nuntan ni penginemnemneman yun nelabahan ni anghel ku, dammutu. Nem mahapul ni mekuggit idan emin hu lalakkid pamilyah da anin idan lalakkin kamekihha-ad ni hi-gada ma-lat heniddan hi-gayun helag Israel et han mabalin ni meki-dum ida. ");
INSERT INTO ify_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Emin kayun helag Israel et yadda etan tuun nekibebley ni hi-gayu ey mahapul ni u-unnuden yudda huyyan meu-unnud ni pengippahdingan ni Piyestah ni Passover.” ");
INSERT INTO ify_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Emin ida helag Israel ey inu-unnud da hu tugun Apu Dios ni inhel di Moses nan Aaron ni hi-gadan pehding dan peni-yanan dan Egypt. ");
INSERT INTO ify_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Et ipengulun Apu Dios idan meni-yan ni Egypt ni nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Emin hu pengulwan ni u-ungnga yun laki niya nemangulun impah ni animal yu ey ieng-eng yun hi-gak. Tep bagik emin hu pengulwan ni u-ungnga yun helag Israel, anin idan nemangulun impah ni animal yu.” ");
INSERT INTO ify_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kan Moses idan edum tun helag Israel ey “Nemnemnem tayun ingganah huyyan aggew ni neni-yanan tayun Egypt et meliblih itsud neihbutan tayu gapuh ni et-eteng ni kabaelan Apu Dios. Ey ang-ang tayu et eleg tayu kanen hu sinapay ni neha-adan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","5","Yan nunyan memengngulun bulan ni Abib ey hini-yan tayu Egypt et lumaw itsu etan di bebley ni impakulug Apu Dios ida lan ammed tayun iddawat tun hi-gatsu. Humman hu nambebleyan idan Kanaanite, Hittite, Amorite, Hibite niyadda Jebusite. Humman ni bebley ey dakel kennen ey mateba kameitnem. Hedin umdateng kayudman, ey entan tu liwwan ni ippahding hu pan-am-amlengan yu hedin nedatngan huyyan aggew ni katootoon. ");
INSERT INTO ify_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Et yan dettengan yudman ni kakkayyaggud ni bebley ey ang-ang yu et eleg yu kanen hu sinapay ni neha-adan ni kamampelbag niya mahapul ni endi kamampelbag ni sinapay di baballey yu et yad bebley yu ni memengngulun pitun aggew ni memengngulun bulan. Et yan meikkeppitun aggew ey mampiyestah kayu e manhahamul kayun penaydayaw yun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Et hedin ippahding yulli huyyan piyestah ni katootoon ey ehel yuddallin u-ungnga yu e mukun wada huyyan piyestah ey tep huyya penginemnemneman tayun impahding Apu Dios et hi-yanen tayu Egypt. ");
INSERT INTO ify_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Huyyan piyestah ey heni malkad ngamay winu tuktuk yun mengippenemnem ni hi-gatsun ingganah idan tugun Apu Dios. Huyya pehding tayu tep impa-kal daitsun hi-gatud Egypt gapuh ni et-eteng ni kabaelan tu. ");
INSERT INTO ify_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Et humman hu ippahding yulli huyyan piyestah di nagtud ni aggew ni katootoon. ");
INSERT INTO ify_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Yallin nunman alin dettengan yu etan di bebley ni impakulug Apu Dios ida lan ammed tayun iddawat tun hi-gatsu e humman hu nambebleyan idan iKanaan, ");
INSERT INTO ify_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ey mahapul ni ieng-eng yun Apu Dios hu pengulwan ni u-ungnga yu tep emin hu lakin pengulwan ni u-ungnga yu anin idan nemangulun lakin impah ni animal yu ey hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nem humman idan pengulwan ni lakin u-ungnga yun ieng-eng yun Apu Dios, ey dammutun hullulan yun lakkitun impah ni kalnero. Et ya nemangulun lakkitun impah ni kebayyu ey dammutun hullulan yun lakkitun impah ni kalnero. Nem hedin eleg yu pinhed ni hullulan, giplung yu buklew tu et matey. ");
INSERT INTO ify_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ey hedin ibbagaddallin u-ungnga yun edum ni aggew hu gaputun yuka pengippahdingin nunya, kan yulli ey ‘Mukun mika ippahding huyya ey tep gapuh ni et-eteng ni kabaelan Apu Dios ey impa-kal dakemid Egypt e neihbutan mi ");
INSERT INTO ify_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","e kinastigu tu etan patul et pateyen tu pengulwan ni u-ungnga tu, yadda pengulwan ni u-ungngaddan tutu-u tu niyadda nemangulun impah ni animal da tep manghay et eleg dakemi i-abulut ni me-kal diman. Et humman hu, mahapul ni iddawat tayuddan Apu Dios hu nemangulun lalakkin u-ungnga tayu et yadda nemangulun impah ni animal tayu. Nem ya meihhullul ni pengulwan ni lakin u-ungnga tayu ey ya impah ni kalnero. ");
INSERT INTO ify_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Huyyan pehding tayu ey heni malkad ngamay winu tuktuk tayu et penginemnemneman tayun ingganah ni nangkalan Apu Dios ni hi-gatsud Egypt gapuh ni et-eteng ni kabaelan tu.’” ");
INSERT INTO ify_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","18","Yan nengiebulutan etan ni patul ni hi-yanen idan helag Israel hu Egypt ey beken etan di keltad ni mampellaw di Pilistia hu impangulun Apu Dios ni dinlan da ey humman et hu neihnup. Et ya impangulu tu ey ya etan di eleg mebebleyi e mampellaw etan di Madlang ni Baybay nem nelikaw humman ni dinlan da. Tep kan Apu Dios ey “Nungay mantuttuyyu ida et mambangngad idad Egypt hedin mahapul ni mekiggubbat ida.” Humman ninemnem tun pehding anin ni wada almas dan intabin dan neni-yanan dan Egypt. ");
INSERT INTO ify_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yan neni-yanan di Moses ni Egypt ey neki-la tu genit Joseph tep inhel lan Joseph idan edum tun helag Israel e kantuy “Baddangan dakeyullin Apu Dios et hedin hi-yanen yulli Egypt, mahapul ni peki-la yulli genit ku.” ");
INSERT INTO ify_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Hini-yan idan helag Israel hu Sukkot et dumteng idad Etham di gilig etan ni eleg mebebleyi et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","Ya impahding Apu Dios ni nengipengulun hi-gada ey hedin kawwalwal, kamambalin ni kulput et tuka ippangnguludda et hedin hileng, kamambalin humman ni kulput ni et-eteng ni apuy ni kamantettebbel et humman daka penillag ni dellanen da. ");
INSERT INTO ify_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Entanni ey kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ehel muddan edum mun helag Israel et mambangngad kayu etan di neihnup di Pi Hahirot e nambattanan ni Migdol et ya Madlang ni Baybay, et mangkampu kayu etan di demang ni Baal Sepon. ");
INSERT INTO ify_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Et penghel etan ni patul ni Egypt ey nehama kayu niya nehukum kayu tep wada kayud nambattanan ni eleg mebebleyi et ya baybay, ");
INSERT INTO ify_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","et pedugen dakeyu tep pambalin ku mewan ni manghay. Implanuh ku huyya ma-lat usalen ku etan patul niyadda sindalu tun pengippeang-angan kun et-eteng ni dayaw ku, et pengamtaan idan iEgypt e hi-gak hu Ap-Apu.” Et an ehlen Moses idan edum tun helag Israel ey inu-unnud da. ");
INSERT INTO ify_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ya etan patul et yadda opisyal tu ey ida kamantuttuyyun limmawan idan helag Israel et eleg ida law mambangngad et kanday “Eyyakaw kumedek! Hipa ninemnem tayu, kele tayu in-abulut ni umbesik ida etan helag Israel? Tam endi law pambega-en tayu.” ");
INSERT INTO ify_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","8","Impambalin mewan Apu Dios ni manghay etan patul et paidaddan tu hu kalesah ni panlugganan tu ma-lat ipengulu tudda sindalu tu niyadda ap-apudan memdug idan helag Israel. Inusal da enem ni gatut ni kekakkayyaggudan ni kalesa et yadda edum ni kalesa di Egypt ni kameussal di gubat. Ey netuled idan emin ni namdug idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Yadda namdug idan helag Israel ey ya etan patul, yadda sindalun nandalan, yadda nampangkebayyu niyadda nampangkalesa et ha-kupen daddan nangkampud gilig ni Madlang ni Baybay e neihnup di Pi Hahirot niya demang ni Baal Sepon. ");
INSERT INTO ify_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yan nenang-angan idan helag Israel e iyyaddalli etan patul niyadda sindalu tu ey simmakut ida et ida kamampehemmehemmek nan Apu Dios ma-lat ihwang tudda. ");
INSERT INTO ify_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Kandan Moses ey “Eyyakaw kumedek, kaw in-ali dakemidyad eleg mebebleyi et matey kamidya? Kaw kulang hu keikkullungngan di Egypt? ");
INSERT INTO ify_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Inhel mi dedan ni hi-gam e eleg dakemi pekidimdima-u et anin ew ngun diman kamid Egypt. Kekkeddukdul tu hu nannaneng kamin himbut di diman nem ya etan kami mettey di deya!” ");
INSERT INTO ify_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nem kan Moses ey “Entan takut yu! Petuled yu nemnem yu et ang-angen yu hu pehding Apu Dios ni mengihwang ni hi-gatsun nunya. Tep humman idan iEgypt ey meendidda et endilli law yu penang-angan ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ya kayyaggud ni pehding tayu ey pelinggep tayu nemnem tayu et ngenamung hi Apu Dios ni mekiggubbat ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kan Apu Dios nan Moses ey “Kele kayu kamampehemmehemmek ni hi-gak? Ehel mu kumadda eyan tuu et ituluy yun menglaw. ");
INSERT INTO ify_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Idengdeng mu eya hulkud mud baybay et megedwa eya danum et mandalan kayuddan edum mun helag Israel di mamega. ");
INSERT INTO ify_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pambalin kudda mewan eya iEgypt ni manghay et anin kayu kamenglaw ey pan-unnuden dakeyu. Nem hi-gak hu mekiggubbat ni hi-gada et apputen ku etan patul, yadda sindalu tu, yadda sindalu tun nangkalesa et yadda nangkebayyu et meang-ang hu et-eteng ni kabaelan ku. ");
INSERT INTO ify_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Et humman ni pengapputan kun hi-gada hu pengamtaan da e hi-gak hu makulug ni Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Et ida kamenglaw hu helag Israel ey limmaw etan anghel ni kamengipappangngulun hi-gadad dingkuggan da ey limmaw dama etan kulput di nambattanan ");
INSERT INTO ify_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","idan helag Israel et yadda iEgypt et maiheni. Entanni et nehileng ey engeenget di kad-an idan iEgypt, nem kawwalwal di kad-an idan helag Israel tep nambalin ni apuy etan kulput. Et endi inna-nuddan iEgypt ni meihnup ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Dimmateng ida etan di baybay et idengdeng nan Moses etan hulkud tu ey impaelin Apu Dios hu na-let ni dibdib ni nalpud appit ni kasimmilin aggew et dumenibdibdib ingganah newa-wa. Entanni ey nanggedwa etan danum et mabudihan hu dalinat ni baybay. ");
INSERT INTO ify_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Et man-agwat ida helag Israel di baybay e nandalan idad mamegan puyek tep ya etan danum di nambina-hil di winilli niyad winannan ey heni natneng. ");
INSERT INTO ify_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ida kamangkeipdug hu iEgypt ni nampangkalesah ida niya nampangkebayyu. ");
INSERT INTO ify_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yan eleg pay ni mewa-wa ey nan-uhdung hi Apu Dios e wada etan di kulput et apuy. Et wadaen tu takut idan sindalun iEgypt. ");
INSERT INTO ify_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Endi maptek ey kamangkeillunnek hu heli idan kalesah da et ida kamampaligat ni umlaw. Et kanday “A-allaw itsu kumadya! Tep ya Dios idan helag Israel hu kamekihhanggan hi-gatsu.” ");
INSERT INTO ify_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yan nan-agwatan emin ni helag Israel di ba-hil ni baybay ey kan Apu Dios nan Moses ey “Idengdeng mu mewan hu ngamay mud baybay ma-lat mandammu etan danum et mangkalsing ida eya iEgypt ni kamangkeipdug.” ");
INSERT INTO ify_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","28","Et idengdeng Moses hu ngamay tud baybay ni kakkabbuhhan ey nambangngad etan danum. Et mangkaenud ida kalesa et yadda kebayyu ey nangkalsing ida sindalun iEgypt. Impatnaddan iEgypt et ni umdakal, nem nalsing idan emin gapun nunman ni impahding Apu Dios et endi natdaan. ");
INSERT INTO ify_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Nem yadda helag Israel ey nan-agwat ida e nandalan idad mamegan puyek di dalinat ni baybay e nambina-hil hu danum e heni nebatneng di winannan niyad winilli. ");
INSERT INTO ify_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","31","Natngadda helag Israel ey et-eteng law hu dinel dan Apu Dios et hi Moses e bega-en tun nenang-angan dan kabaelan tun nengihwangan tun hi-gadan nunman ni aggew e inapput tudda iEgypt et nangkalsing idan impahding tu. Et mangkaiwehit hu annel dad gilig ni baybay. ");
INSERT INTO ify_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Et gapuh ni nunman ni nengihwangan Apu Dios ni hi-gada ey impappangngulun Moses ida edum tun helag Israel et man-a-appeh. Kandad a-appeh day “Ia-appehan ku hi Apu Dios tep naka-apput tudda buhul tu e imbeng tud baybay etan ida kebayyu et yadda nantakkay. ");
INSERT INTO ify_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hi Apu Dios hu na-let ni mengi-ehneng ni hi-gak, ey hi-gatu mengihwang ni hi-gak. Hi-gatu hu Dios ku ey hi-gatu deyyawen ku. Ey hi-gatu Dios ni kadeyyawan ama, et humman hu ia-appeh ku meippanggep ni kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hi Apu Dios ey netuled ey nelaing ni mekiggubbat ey hi-gatu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Imbeng tuddad baybay hu sindalun iEgypt niyadda kalesa da. Et mangkalsing ida ketultuledan ni aap-apun sindalu da etan di Madlang ni Baybay. ");
INSERT INTO ify_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nalneng ida e henidda batun limmaw di nandallem. ");
INSERT INTO ify_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Hi-gam e Apu Dios ey et-eteng hu kabaelam e muka paka-apputa buhul mu. ");
INSERT INTO ify_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Gapuh ni kasina-gey niya kakina-let mu ey inapput muddan emin hu kamenanggan hi-gam. Impeang-ang mu bunget mun nengendian mun hi-gada, henin kapanggi-ingin apuy ni ulut. ");
INSERT INTO ify_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Inheb-uk mud baybay ey negedwa hu danum e heni natneng et ay heni nedingding et mabudihan hu mamegan puyek di dalinat ni baybay. ");
INSERT INTO ify_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kan etan ni buhul miy ‘Pepdugen kudda et hedin hina-kup kudda, nampatey kudda et al-en kun emin hu binaknang da et panggegedwa middan tuuk.’ ");
INSERT INTO ify_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nem inheb-uk mu mewan e Apu Dios, et mandammu etan danum et mangkalsing ida. Et malneng idad baybay e henidda gumek ni nalneng di nandallem. ");
INSERT INTO ify_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Apu Dios, endi edum ni dios ni henin hi-gam. Kaw wadan hi-gada hu kamedeyyaw ey kakkayyaggud e henin hi-gam? Et hipan hi-gada hu kabaelan tun mengippahding idan kamengippetngan muka ippenahding? ");
INSERT INTO ify_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Indengdeng mu wannan ni ngamay mu ey nangkeunug ida buhul mi et lumaw idad nandallem di puyek. ");
INSERT INTO ify_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nem hedin hi-gami, inhewang dakemi et ipengulu dakemi gapuh ni et-eteng ni impeminhed mun hi-gamin tuum. Ey gapuh ni et-eteng ni kabaelam ey ippaptek dakemi ingganah ni umdateng kami etan di bebley ni intudum ni panha-adan mi. ");
INSERT INTO ify_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dakel idalli hu tutu-ud kebebbebley ni mengngel alin nunman ni neipahding et umgeygey idan takut da. Nema-madda iPilistia, ");
INSERT INTO ify_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","anin idan aap-apun iEdom, niya iMoab. Ey nemahhig ali takut idan emin ni tuud Kanaan. ");
INSERT INTO ify_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Umtatakut idalli gapuh ni et-eteng ni kabaelam, Apu Dios, et humman hu um-eneeneng idalli e endi da pehding ni hi-gami ingganah ni melebbah kamin tuum ni liniblih mud neihbutan mi. ");
INSERT INTO ify_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Apu Dios, illaw dakemilli etan di duntug et heni dakemi ittanem diman ni pinilim ni panha-adam e kad-an ni baley mun kinapyam. ");
INSERT INTO ify_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hi-gam e Apu Dios hu mannananeng ni man-ap-apun inggana.” ");
INSERT INTO ify_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Yan wadadda kakalesa niyadda kebayyu et yadda sindalun iEgypt di gawwan baybay, ey impandammu mewan Apu Dios etan danum et malsing idan emin. Nem yadda helag Israel ey nema-ganan hu nandalnan da etan di baybay. ");
INSERT INTO ify_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Entanni ey hi Miriam e agin Aaron e prophet ey illatu tambourine tu et ipappangngulu tudda dama edum tun bii et wada hakkeyey impatnul tu hu tambourine tu et menattayyaw ida. ");
INSERT INTO ify_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Et man-a-appeh hi Miriam e kantuy “Ia-appehi tayu hi Apu Dios tep inapput tu buhul tayu ma-lat kaideyyawan tu. Imbeng tudda kebayyu et yadda nampantakkay etan di baybay et mangkalsing ida.” ");
INSERT INTO ify_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Entanni ey impangulun Moses mewan ida helag Israel et hi-yanen da etan Madlang ni Baybay et mampalaw idad Sur e eleg mebebleyi. Yan kaweda dadman ey tellun aggew ni endi da himmak ni danum ni innumen da. ");
INSERT INTO ify_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Entanni ey dimmateng idad Marah ey wada danum diman, nem mapeit. Et humman hu neal-an ni nunman ni ngadan ni bebley ni Marah. Tep ya keibbellinan ni Marah di ehel dan Hebrew ey mapeit. ");
INSERT INTO ify_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ey ida kaumguguhu et kandan Moses ey “Mahapul ni wada danum ni innumen et eleg itsu matey ni ewew tayu.” ");
INSERT INTO ify_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Et mampehemmehemmek hi Moses nan Apu Dios. Intudun Apu Dios ni hi-gatu etan pangan keyew. Et alen tu et ibelangdu tu etan di danum ey na-kal pait tu et mabalin law ni meinnum. Ey yan nunman ni kaweda dad Marah ey impeamtan Apu Dios ni hi-gada etan ida tugun tun mahapul ni u-unnuden da, ma-lat ang-angen tu hedin u-unnuden da winu eleg. ");
INSERT INTO ify_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kantuy “Hedin paka-u-unnuden yuwak et ippahding yudda etan pinhed ku et ya kayyaggud pehding yu, eleg dakeyu kastigua, beken ni heniddan iEgypt e kinastiguk idan degeh. Hi-gak hu Ap-Apu yu et ya panyaggudan yu hu nakka nenemnema.” ");
INSERT INTO ify_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Entanni ey dimmateng idad Elim e wada hampulut dewwan hebwak diman niya nepitun palmah e heni neyug et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Emin ida helag Israel ey hini-yan da mewan hu Elim et lumaw idad Sin e hakey mewan ni eleg mebebleyi di nambattanan ni Elim niya Sinai et mangkampuddadman. Yan dintengan dadman ey hambulan et hampulut liman aggew hu nelabah neipalpun neni-yanan dan Egypt. ");
INSERT INTO ify_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Yan wadaddadman ey kaigugguhu mewan idan tutu-u di Moses nan Aaron. ");
INSERT INTO ify_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kanday “Eyyakaw, kedukdul na-mu hedin pintey dakemin Apu Dios di Egypt. Kele dakemi ippangulun hi-gatu eyad eleg mebebleyi et kami mettey ni upa? Yad Egypt ey dakel kennen, hedin pinhed hu detag ey wada, heniddan edum ni klasih ni mekkan.” ");
INSERT INTO ify_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Et kan Apu Dios nan Moses ey “Peellik hu kennen ni melpud kabunyan. Nem mahapul ni kewa-wa-wa ey wada hakkeyey an mengemmung ni um-ustuh ni kennen tun nunman ni aggew. Et huyya pengamtaan ku hedin u-unnuden da e-helen ku. ");
INSERT INTO ify_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Nem yan meikka-nem ni aggew ni kelinglinggu ey emmungen da hu mampidwa kadinakkel tun daka emmungan kewa-wa-wa ma-lat wada kennen dan meikkeppitun aggew.” ");
INSERT INTO ify_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Et amungen di Moses nan Aaron ida etan edum dan helag Israel et kandan hi-gaday “Yallin nunyan mahmahdem ey amtaen yu e hi Apu Dios hu nengipengulun hi-gatsu et hi-yanen tayu Egypt. ");
INSERT INTO ify_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Ey yallin kakkabbuhhan ey ang-angen yulli hu et-eteng ni kabaelan tu. Dingngel tu hu lilih yun hi-gatu, tep ma-nut hi-gami yuka pengi-helin lilih yu, nem ya kakulugan tu ey hi-gatu hu nanlilihan yu, tep hi-gami ey bega-en dakemin ebuh ni hi-gatu. Hi-gatu hu mengidwat ni ihhideyun detag ni mahmahdem niya hi-gatu hu mengidwat ni mahapul yun sinapay ni kakkabbuhhan. Dingngel tu lilih yun hi-gatu, tep emin hu lilih yu ey hi-gatu nanlilihan yu.” ");
INSERT INTO ify_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kan Moses nan Aaron ey “Ehel muddan emin ni edum tan helag Israel et maemung idad kad-an Apu Dios tep dingngel tu lilih da.” ");
INSERT INTO ify_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Et kapan-e-helan Aaron humman ni hi-gada ey nampeang-ang hu kaumhilin dayaw Apu Dios etan di kulput. ");
INSERT INTO ify_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Immehel hi Apu Dios nan Moses e kantuy “Dingngel ku lilih ida eyan tuu. Ehel mun hi-gada e yan mahmahdem ey wada detag ni iddawat kun ihhideda. Et yan kakkabbuhhan ey iddawat ku emin hu sinapay ni mahapul da. Et humman pengamtaan da e hi-gak e Ap-Apu hu Dios yu.” ");
INSERT INTO ify_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Yan nunman ni mahmahdem ey immali tu-wangu hu hantapug ni sisit ni quail etan di nangkampuan da. Ey yan kakkabbuhhan ey dimmelnu hu nanlinikweh di nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Entannit endi law hu delnu ey nenapnapan etan puyek ni meingpih ni mangkablah e heni dallalu ang-ang tu. ");
INSERT INTO ify_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Et yan nenang-angan idan tuu ey kanday “Hipa ngu huyya?” Kan Moses ni hi-gaday “Huyyadda indawat Apu Dios ni hi-gatsun kennen tayu. ");
INSERT INTO ify_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Inhel tu e wada hakkeyey ya um-ustuh ni kennen tu hu emmungen yu e hantalub ni hanhakkey ni tuu.” ");
INSERT INTO ify_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Et wada hakey ey ida nengamung ni kennen da. Nem eleg man-iingngeh hu inemung da e wadadda daddakkel hu inemung tu nem yadda edum. ");
INSERT INTO ify_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nem yan nanlekudan dan inemung ni hanhakkey ni hi-gada ey endi nehawalan winu nekulangan. Wada hakkeyey immustuh hu inemung tun kennen tun han-aggew. ");
INSERT INTO ify_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kan Moses ni hi-gaday “Mahapul ni kennen yun emin ni nunyan mahmahdem ma-lat endi tetdaan yun kennen yun kakkabbuhhan.” ");
INSERT INTO ify_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nem wadadda eleg mengu-unnud ni nunman ni inhel nan Moses et tedaan da edum etan ni kennen. Nem yan kakkabbuhhan ey nebangleh etan sindaan da e nebigihan ey kamampanhemmuy. Neamtaan Moses humman ey nemahhig hu bunget tu. ");
INSERT INTO ify_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Et kekakkabbuhhan ey wada hakkeyey kaumlaw ni an mengemmung ni um-ustuh ni kennen ni pamilyah tu. Hedin na-let hu petang ey kameumah ida etan natdaan. ");
INSERT INTO ify_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hedin meikka-nem ni aggew, kamampidwa kadinakkel ni daka emmunga e handedwan talub ni hakey ni tuu. Entanniy limmaw ida etan nepilin kamengipappangngulu et da mahmahan nan Moses, kele hanniman. ");
INSERT INTO ify_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kan Moses ni hi-gaday “Ya gaputun mahapul ni mampidwa kadinakkel ni emmungen yun nunyan aggew ey tep intugun Apu Dios e yan kabbuhhan ey Sabadu e aggew ni nungew e endi mangngunnu ma-lat mandayaw itsun hi-gatu. Mahapul ni ihhaeng yun nunya kennen yun kabbuhhan.” ");
INSERT INTO ify_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Inu-unnud da inhel nan Moses et umiha-ad idan kennen dan kewa-waan tu. Ey ma-nu humman ni sindaan da tep eleg mebangleh niya eleg mabigihan. ");
INSERT INTO ify_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kan Moses ni hi-gaday “Huttan ni sindaan yu hu kennen yun nunyan Sabaduh, tep endi tayu hemmaken ni kennen. Yan nunyan aggew hu pandeyyawan tayun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Et humman hu meippalpun nunya ey henin nunman hu pehding yu e kayu mengemmung ni kennen yun enem ni aggew, nem yan kapitun aggew e Sabaduh ey endi hemmaken yun kennen.” ");
INSERT INTO ify_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Humman hu inhel nan Moses, nem yan nunman ni aggew ni Sabaduh ey wadadda metlaing etan limmaw ni an menemmak ni kennen, nem endi himmak da. ");
INSERT INTO ify_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kan Apu Dios nan Moses ey “Pigantu pengu-unnudan eyaddan tuun tugun ku? ");
INSERT INTO ify_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kaw eleg da nemnema e mampidwa kedakkel ni kennen ni nakka iddawat ni hi-gadan meika-nem ni aggew ma-lat um-ustuh ni kennen dan dewwan aggew? Tep hi-gak e Ap-Apu ey winedak hu meikkeppitun aggew ni pan-iyatuan yu e mannungngew kayu et eleg kayu umlaw ni an menemmak ni kennen yu.” ");
INSERT INTO ify_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Et neipalpun nunman ey ida kaman-iyatun meikkeppitun aggew. ");
INSERT INTO ify_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ya ngadan nunman ni kennen ey manna. Ya ang-ang tu ey heni mablah ni bukel ni coriander et ya tamtam tu ey heni sinapay ni neha-adan ni danum ni putsukan. ");
INSERT INTO ify_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kan Moses idan edum tuy “Inhel Apu Dios e um-itlu itsu eyan manna ma-lat ang-angen idallin helag tayun edum ni aggew huyyan indawat tun hi-gatsu eyad eleg mebebleyin nengipa-kalan tun hi-gatsud Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Et ehlen Moses nan Aaron e um-alan pa-nay et taluan tun kagedwah ni talub ni manna et tu iha-ad etan di kapanha-adin Apu Dios ma-lat penginemneman idallin helag idan ing-ingganah. ");
INSERT INTO ify_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Inu-unnud Aaron humman ni inhel Apu Dios nan Moses, et tu iha-ad huyyan pa-nay di hinangngab ni Kaban di bawang etan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Humman ni manna hu kikkinnan idan helag Israel ni na-pat ni toon etan di eleg mebebleyi ingganah ni dimmateng idad Kanaan. ");
INSERT INTO ify_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ya inusal dan nunman ni nanlekud ni manna ey omer e hantalub tuka ella.) ");
INSERT INTO ify_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Hini-yan idan helag Israel hu Sin et tagan da elaw e daka u-unnuda kae-helan Apu Dios ni lawwan da. Entanni ey dimmateng idad Repidim et mangkampuddadman, nem endidman hu danum ni innumen da. ");
INSERT INTO ify_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Et da mewan keigguguhu hi Moses ey ida kamangngungudu e kanday “Idwasi dakemin danum ni innumen mi.” Ey kan Moses ni hi-gaday “Entan tuwak igugguhu? Kele pinhed yun patnaan hu anus Apu Dios ni hi-gayu?” ");
INSERT INTO ify_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nem naka-wew ida etan tuu et ida kamangngungudu e kanday “Kele dakemi impangulun meni-yan ni Egypt, et kami mettey ni inwew mi anin idan eyan u-ungnga mi niyadda animal mi?” ");
INSERT INTO ify_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Et mandasal hi Moses nan Apu Dios et kantuy “Apu, hipa pehding ku? Deh e ida kaumbubunget eya tuun hi-gak e tengbaen da-ak.” ");
INSERT INTO ify_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","6","Et kan Apu Dios nan Moses ey “Pamengulu kayudda eyan nepilin mengipappangngulun helag Israel ni umlaw. Hehgeden dakeyulli etan di batud Duntug e Sinai. Itebin mu eya hulkud mun inheplat mu lad Wangwang e Nile, et iheplat mu etan di batu et maukat hu danum ni innumen yu.” Inu-unnud Moses huyyan inhel Apu Dios et iheplat tu hulkud tu etan di batu, ey neukat hu danum e kaang-ang-angaddan etan ni kamengipappangngulun helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Et ngadanan Moses humman ni bebley ni Massah, tep yadman hu nematnaan idan helag Israel ni anus Apu Dios ni hi-gada. Ey ingngadnan tun Meribah tep nanlilih ida etan tutu-un hi-gatu e kanday “Kaw makulug ni wada hi Apu Dios di deyan mengippaptek ni hi-gatsu winu endi?” ");
INSERT INTO ify_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yan wadadda helag Israel di Repidim ey limmaw ida iAmalek ni an mengubbat ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kan Moses nan Joshua ey “Pili kan lalakkin an menammuddan iAmalek ni iyyallin mengubbat ni hi-gatsu. Et yan kabbuhhan ey nak um-ehneng etan di tuktuk ni duntug e tetngeden ku etan hulkud ni inhel Apu Dios ni ussalen ku.” ");
INSERT INTO ify_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Inu-unnud Joshua hu inhel Moses et ida makigubat idan iAmalek. Yan nunman ni daka panggugubasi ey limmaw hi Moses, hi Aaron niya hakey ni kadwa da e hi Hur etan di tuktuk ni duntug. ");
INSERT INTO ify_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Hedin kaitta-ta-gey nan Moses etan hulkud, ida kamenga-apput hu helag Israel. Nem hedin nablay et imbabah tu ngamay tu, ida kamenga-apput hu iAmalek. ");
INSERT INTO ify_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Entanni ey nablay law hu ngamay Moses ni mengitta-ta-gey etan ni hulkud et pumulig di Aaron nan Hur ni batu et yudungan Moses. Nambina-hil idan hi-gatu et ita-ta-gey da ngamay tu ingganah ni nelinug hu aggew. ");
INSERT INTO ify_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Et apputen di Joshua ida iAmalek. ");
INSERT INTO ify_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Et kan Apu Dios nan Moses ey “Itudek yu eya meippanggep ni nengapputan yu, ma-lat eleg meliwwan ni ingganah. Ey ehel mun Joshua e petteyen kudda emin hu iAmalek.” ");
INSERT INTO ify_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Et kumapyad Moses diman ni pan-appitan nan Apu Dios et ingadnan tun “Hi Apu Dios hu bandelah ku.” ");
INSERT INTO ify_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kan tuddan edum tun helag Israel ey “Kayyaggud hedin hi Apu Dios hu nanengtun pengiddinnelan tayun mengittulluy ni mekiggubbat idan iAmalek ni ingganah.” ");
INSERT INTO ify_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Entanni ey dingngel Jetro e padid Midian e aman ahwan Moses hu meippanggep idan kayyaggud ni impahding Apu Dios nan Moses niyadda edum tun helag Israel et ya nengipa-kalan tun hi-gadad Egypt. ");
INSERT INTO ify_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Ninemnem tun ikkuyug etan u-ungnga tu e hi Sipporah e ahwan Moses et yadda u-ungnga da e di Gersom nan Elieser. Yan nunman la ey impaenamut nin Moses hi Sipporah et yadda u-ungnga da et ida makiha-ad di kad-an Jetro. Yan neiungngaan idan nunman ni u-ungnga tu ey nginedanan tu etan pengulwan ni Gersom tep kantuy “Hi-gak ey immali-ak ni ebuh ni nekibebley di deya.” Ey ya etan meikkadwa ey nginadnan tun Elieser tep binaddangan Apu Dios hi-gatu. Et kantuy “Hi Apu Dios e kadaydayawaddan ammed ku ey binaddangan tuwak et eleg tuwak pateyen etan ni patul di Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ingkuyug idan Jetro et lumaw idad nangkampuan di Moses etan di duntug ni eleg mebebleyi e yadman nampeang-angan Apu Dios lan nunman. ");
INSERT INTO ify_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Hi Moses ey amta tu e um-alidda tep impamengulu lan Jetro e aman ahwatun impeamtan hi-gatu hu lawwan dadman. ");
INSERT INTO ify_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ida kamenetteng ey an dinammun Moses et manyuung et akwalen tu. Et ikuyug Moses idad kampu tu. ");
INSERT INTO ify_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ine-ehhel nan Moses nan hi Jetro emin hu impahpahding Apu Dios etan ni patul di Egypt et yadda tuu tu niya impahding tun nemappeg ni daka pengippeligligasiddan edum tun helag Israel. Ine-ehhel tu pay hu nanhelheltapan da neipalpun neni-yanan dan Egypt ingganah ni dintengan da etan di nangkampuan da, et ya nemaddangan Apu Dios ni hi-gadan nunman ni nanligligatan da. ");
INSERT INTO ify_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Immamleng hi Jetro ni nangngelan tun nunman ");
INSERT INTO ify_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","et kantuy “Dayaw tayu hi Apu Dios tep inhewang dakeyud lawah ni impahpahding idan iEgypt et ya etan patul da. ");
INSERT INTO ify_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Yan nunya ey inamtak law e hi Apu Dios hu keta-ta-geyyan nem yadda dios ni kadeyyawaddan edum ni tuu tep impaptek dakeyun tuu tu. Et ihwang dakeyud pehding idan iEgypt ni nekababbah hu daka penang-ang ni hi-gayun helag Israel e tuu tu.” ");
INSERT INTO ify_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Entanni ey in-appit Jetro hu kagihheba et yadda edum ni iappit tun Apu Dios. Immalid Aaron et yadda etan aap-apun helag Israel ni menammun hi-gatu et manhahamul idan emin ni pengidaydayaw dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Newa-wa et ituluy Moses hu ngunu tun mengipennuh ni kapandidiklamuhiddan tuu. Tep meippalpun kakkabbuhhan ingganah ni mahmahdem, ey kamanhulluhullul ida tuun kaum-alin mandiklamuh. ");
INSERT INTO ify_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Inang-ang Jetro huyyan neligat ni peteg ni ngunun Moses ey kantuy “Kele muka hahhakkeyi huttan ni ngunu e endi hu kaumbaddang ni hi-gam? Nakka ang-ang-anga ey neligat ni peteg hu ngunum, tep dakel ni neyun hu kaum-alin tuun kamampebaddang ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","Hinumang nan Moses et kantuy “Mahapul ni ippahding ku huyyan ngunuk tep yan nakka pengippennuhin diklamuh idan tuu ey nak keituttuddun hi-gada tugun Apu Dios niyadda etan pinhed tun meunnud.” ");
INSERT INTO ify_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kan Jetro ni hi-gatuy “Beken ni kayyaggud hu henin nuntan! ");
INSERT INTO ify_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tep neligat ni peteg huttan ni ngunum ey muka hahhakkeyi! Lektattulliy peinglay mu et anin idalli eyan tuum. ");
INSERT INTO ify_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Et humman hu, kayyaggud hedin iddedngel mu eya tugun ku, yaggud daka kabaddangin Apu Dios. Ma-nu tep lebbeng tun i-ehneng mudda tuud hinanggan Apu Dios. Ey mampebaddang kan hi-gatu meippanggep di daka panhahallai, ");
INSERT INTO ify_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","niya ituttuddum ni hi-gada hu tugun tu, ya kayyaggud ni elaw et yadda etan lebbeng tun pehding da, ");
INSERT INTO ify_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","nem mahapul mu umbaddang ni hi-gam. Et humman hu pili kaddan kayyaggud elaw tu et hi-gada putuken mun mengi-ehneng idan tuu. Wadadda man-ap-apun hanlibu, hanggatut, nelima niya hampulu. Et humman idan man-ap-apu ey mahapul ni peka-u-unnuden da hi Apu Dios, ey ida kameiddinnel e eleg da ebbulutan metangdanan ni pengippahdingan dan lawah. ");
INSERT INTO ify_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ey hi-gada ngenamung ni mengippennuh ni diklamuh idan tuun inehnengan da. Nem yadda etan neligat ey humman i-ali dan hi-gam ni ippanuh mu. Nem yadda etan nelakah ni diklamuh ey ngenamung ida, ma-lat mee-ekkalan hu ngunum. ");
INSERT INTO ify_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Hedin u-unnuden mu huyya ey hedin kamei-unnud di pinhed Apu Dios ey eleg ka mekalliggatan di ngunum ey melinggep ida tuun um-anemut e neipenuh hu daka panhahallai.” ");
INSERT INTO ify_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Inu-unnud Moses humman ni tugun Jetro. ");
INSERT INTO ify_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Et pilien tudda etan kabaelan dan man-ap-apu. Impan-ap-apu tuddan hanlibu, hanggatut, nelima niya hampulu. ");
INSERT INTO ify_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Et humman idan nepili hu ngenamung ni mengippennuh ni diklamuh idan tuu. Et yadda etan neligat ni meippennuh ey humman illaw dan Moses. ");
INSERT INTO ify_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Negibbuh ni nanhummangan idan Moses et han umenamut hi Jetro di bebley tu. ");
INSERT INTO ify_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Hini-yan idan helag Israel hu Repidim et lumaw idad Sinai e eleg mebebleyi et mangkampu ida etan di hengeg nunman ni duntug. Ey yan nunman ni dintengan dadman ey dewwan bulan hu nelabah neipalpun neni-yanan dan Egypt. ");
INSERT INTO ify_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Entanni ey nanteyed hi Moses etan di duntug et an makihummangan nan Apu Dios. Ey kan Apu Dios ni hi-gatuy “Ehel muddan edum mun helag Israel e kammuy ‘Huyya hu kan Apu Dios: ");
INSERT INTO ify_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Inang-ang yu impahding kuddan iEgypt et ya impahding kun nengi-lin hi-gayudya e heni dakeyu intayab ni tuldu. ");
INSERT INTO ify_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Anin bagik emin eya wadad puyek ey hi-gayun ebuh ni helag Israel hu pillien kun pantu-uk hedin u-unnuden yuwak et ippahding yu hu e-helen kun pehding yu. Ey mambalin kayun padik ni mengippahding ni pinhed ku.’” ");
INSERT INTO ify_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nandayyu hi Moses et amungen tudda etan kamengipappangngulu et ehlen tun hi-gada hu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ey kan idan emin ni tuuy “Ippahding min emin hu e-helen Apu Dios.” Et manteyed mewan hi Moses et tu ehlen nan Apu Dios humman ni inhumang da. ");
INSERT INTO ify_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ey kan Apu Dios ni hi-gatuy “Um-ali-ak ni an menang-ang ni hi-gayu e ya ang-ang ku ey mahdel ni kulput et makihummangan nak ni hi-gam ma-lat meippalpun nunya ey kullugen dakaddan tuu. ");
INSERT INTO ify_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Lakkay et mu ehlen ni hi-gada et mandaddan idan nunya et yan kabbuhhan ey mandeyyaw idan hi-gak. Ey ehel mun hi-gada e balbalan da balwasi da ");
INSERT INTO ify_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ma-lat maidaddan idan bewahtun mandeyyaw ni hi-gak, tep um-ali-ak eyad tuktuk ni Duntug e Sinai et ang-angen da-ak ni hi-gadan emin. ");
INSERT INTO ify_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Nem ha-adim ni kelteg hu nanlinikweh eyan duntug et ehlen mu e eleg ida meba-hil winu an umteyed tep hedin wada eleg mengu-unnud ey mettey. ");
INSERT INTO ify_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hedin wada mengippahding ni nunman, entan tu kaway nem pana yu winu tengba yun batu, et matey anin hedin tuu winu animal. Ey ehel mun hi-gada e hedin wada umtenul ni tangguyup ey umlaw idan emin etan di hengeg ni duntug.” ");
INSERT INTO ify_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Et mandayyu mewan hi Moses et ehelen tudda etan ni tuu e kantuy “Pandaddan kayun menaydayaw nan Apu Dios ni bewahtu. Hedin hi-gayuddan nampengahwa, entan tu ni iulig hu ahwa yu.” Et ipahding idan tuu hu elaw ni panlinnih ni annel da ey imbalbal da babalwasi da. ");
INSERT INTO ify_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Yan nunman ni kakkabbuhhan ni meikkatlun aggew ey kamangkikidul ey kamangkekedyam niya wada mahdel ni kulput etan di ta-pew ni duntug. Wada pay hu na-let ni tenul ni tangguyup. Ey emin ida helag Israel ey ida kamanggegeygey ni takut da. ");
INSERT INTO ify_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Impangulun Moses idan an menammun Apu Dios, et lumaw idad hengeg etan ni duntug et umehneng idadman. ");
INSERT INTO ify_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hi Apu Dios ey apuy hu nampeang-angan tu, et mukun nehephepan etan duntug ni mahdel ni ahuk ni kamampellaw di ahpat e heni kamelpud et-eteng ni apuy. Ey nakkayyang e kamanyegyeg etan di duntug. ");
INSERT INTO ify_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Entanni ey kamangke-let hu tenul ni tangguyup. Ey kamanhuhhummangan di Moses nan Apu Dios e hedin immehel hi Moses, hinumang nan Apu Dios ni kidul. ");
INSERT INTO ify_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Entanni ey nelehbeng hi Apu Dios etan di tuktuk ni duntug et aygan tu Moses. ");
INSERT INTO ify_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kan Apu Dios nan Moses ey “Ehel muddan tuu e eleg ida meba-hil etan di kelteg ni um-alidyan menang-ang ni hi-gak tep hedin ippilit dan um-alidya, mettey ida. ");
INSERT INTO ify_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ey anin idan padin mei-ebbulut ni meihnup di kad-an ku ey mahapul ni ippahding da elaw ni panlinnih ni annel da. Tep hedin eleg da ipahding ey um-aliddadya, kastiguen kudda.” ");
INSERT INTO ify_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kan Moses nan Apu Dios ey “Eleg ida mantetyed hu tuu eyad duntug tep kammuy ha-adak ni kelteg eya nanlinikweh et endi an meba-hil di deya tep wada kadya.” ");
INSERT INTO ify_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ey kan Apu Dios ey “Lakkay et mulli ikuyug hi Aaron et umli kayun dewwadya. Nem yadda etan tuu niyadda padi ey eleg ida mabalin ni meba-hil di kelteg ni um-alidya tep hedin um-alidda, kastiguen kudda.” ");
INSERT INTO ify_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Et mandayyu mewan hi Moses et tu ehelen humman ni inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hi Apu Dios ey intugun tudda huyya e kantuy ");
INSERT INTO ify_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Hi-gak hi Ap-Apu e Dios yun nengihwang ni hi-gayun neihbutan yud Egypt. ");
INSERT INTO ify_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Hi-gak ni ebuh hu Dios ni deyyawen yu, endi edum. ");
INSERT INTO ify_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Entan pengapya yun heniddan wadad kabunyan, ya wadad puyek niya wadad danum ni deyyawen yun dios yu. ");
INSERT INTO ify_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Eleg mabalin ni kayu manyu-ung ni hi-gada ey yudda deyyawen ni dios yu. Tep hi-gak e Ap-Apu e Dios yu ey nemahhig bunget ku hedin wada edum ni ibbilang yun dios yu e beken ni hi-gak ni ebuh. Kastiguen kudda etan eleg mengibbillang ni hi-gak anin idallin u-ungnga da, yadda inap-apu da niyadda pidwan inap-apu da ");
INSERT INTO ify_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nem eleg mepappeg hu impeminhed kuddan etan ni tuun neminhed ni hi-gak niya kamengu-unnud ni tugun ku ingganah di meikkahanlibun helag da. ");
INSERT INTO ify_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Entan tu usal di legelegem hu ngadan ku e Ap-Apu e Dios yu, tep eggak hehmeka hu tuun mengippahding nunman et humman hu kastiguen ku. ");
INSERT INTO ify_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","U-unnud yu elaw ni Sabaduh ni kamengillin ni aggew ma-lat ipahding yudda lebbeng tun meipahding. ");
INSERT INTO ify_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Yan enem ni aggew di hanlingguan hu pengingunnuan yuddan ingngunu yu. ");
INSERT INTO ify_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Nem yan meikkeppitun aggew e Sabaduh ey endi an mangngunnun hi-gayu, yadda u-ungnga yun lalakki niya bibi-i, yadda bega-en yun lalakki niya bibi-i, anin idan animal yun baka niya kebayyu, yadda edum ni animal yu, et yadda nekibebley ni hi-gayu. Mahapul ni man-iyyatu kayun emin ni nunman ni aggew tep humman ni aggew ey neieng-eng ni hi-gak e Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tep enem ni aggew hu nanletuan kun kabunyan, ya puyek niya baybay, niya emin hu wadadman et man-iyyatu-ak ni kapitun aggew. Et humman hu hi-gak e Ap-Apu yu ey nakka ngillina humman ni aggew. ");
INSERT INTO ify_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","U-unnud yud ameyun ineyu ma-lat mebeyyag hu panha-adan yudman ni bebley ni iddawat kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Entan tu patey hu edum yun tuu. ");
INSERT INTO ify_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Entan tu iulig hu beken yu ahwa. ");
INSERT INTO ify_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Entan panekew yu. ");
INSERT INTO ify_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Entan tu ehel hu itek meippanggep ni edum yun tuu. ");
INSERT INTO ify_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Entan tu gamgami hu baley ni edum yu, ya ahwa da, ya bega-en da, ya bakeda, ya kebayyu da winu hipan wadan hi-gada.” ");
INSERT INTO ify_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yan nangngelan idan tuu etan ni kidul et ya etan na-let ni tenul ni tangguyup, niya nenang-angan dan nemahhig ni kedyam niya etan kaman-aahuk ni duntug ey ida kamanggegeygey ni takut da et uma-allaw ida. ");
INSERT INTO ify_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kandan Moses ey “Hi-gam ew hu pengi-hel ni hi-gamin pinhed Apu Dios ni e-helen et u-unnuden mi ma-lat beken tun mengi-hel ni hi-gami tep mettey kami.” ");
INSERT INTO ify_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ey kan Moses ni hi-gaday “Entan takut yu. Henin nunya hu pematnan Apu Dios ni hi-gayu ma-lat mengu-unnud kayun hi-gatu et eleg kayu manliwat.” ");
INSERT INTO ify_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nem yadda etan tuu ey nanengtun immen idad a-allaw tu, nem hi Moses ey an neihnup etan di andeket ni kulput di duntug ni kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kan Apu Dios ni hi-gatuy “Ehel muddan edum mun helag Israel e kammuy ‘Huyya hu kan Apu Dios: Inang-ang yu hu impahding ku e Dios di kabunyan ni nekihummangan ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Et humman hu hi-gak ni ebuh hu deyyawen yu. Entan pengapyan kumpulmih ni deyyawen yun dios yu heniddan nekapyan gumek niya balituk. ");
INSERT INTO ify_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ala kayun puyek et mengapya kayun pan-appitan yun hi-gak, et yadman pan-appitan yun baka niya kalneroh ni gihheben yun i-appit yun hi-gak et yadda edum ni i-appit yu. Emin hu ittuduk ni pandeyyawan yun hi-gak ey wada-ak diman ni memendisyon ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Entan tu usal hu nepahek ni batu hedin batu hu kapyaen yun pan-appitan yun hi-gak, tep eggak ebbuluta i-appit yu hedin humman ikkapya yu. ");
INSERT INTO ify_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ey entan tu ikapya hu pan-appitan yud kametyed tep hedin umteyed etan tuun man-appit ey hedin wada tuud ehpen ey tengngawen tu sipa winu hipan parteh ni annel yun nunman ni man-appit.’” ");
INSERT INTO ify_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel ");
INSERT INTO ify_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","e kanmuy ‘Huyya inhel Apu Dios: Hedin wada gintang yun himbut ni edum yun helag Israel, et ingunuwan dakeyun enem ni toon man ibukyat yun meikkepitun toon ey endi tu beyyadan ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Hedin eleg mengahwa eman ni neihbutan tu nem entanni ey nengahwa, meliblih hedin negibbuh humman ni enem ni toon, nem eleg meliblih etan bii. Nem hedin nengahwa ngu dedan eman ni neihbutan tun hi-gayu, meliblih idan dewwan kegibbuhan ni enem ni toon. ");
INSERT INTO ify_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nem hedin hi-gayun kan himbut nengipeahwan hi-gatu, et wada u-ungnga tu, ebuh etan himbut yun meliblih ni kegibbuhan ni pangngunnuan tun hi-gayu. Eleg meliblih etan ahwa tu niyadda u-ungnga da tep nanengtun hi-gayu hu kanhimbut ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nem hedin eleg pinhed etan ni lakin himbut yun meliblih tep nanengtun pinhed dakeyu ey eleg tu pinhed ni hi-yanen hu ahwa tu niya u-ungnga tu, ");
INSERT INTO ify_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mahapul ni illaw yu humman ni himbut yud yuka pandeyyawin Apu Dios et peehneng yud habyen et teleken yu tangiletud dakel ni tuu, et keang-angan tu e mannenneng ni himbut yu ingganah ni mettey. ");
INSERT INTO ify_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nem hedin bii etan himbut yun inggatang ametu, eleg meliblih. Beken ni henin lakin himbut e meliblih ni kegibbuhan ni enem ni toon. ");
INSERT INTO ify_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Hedin wada gimmatang ni biin himbut et iahwatu nem entanniy eleg tu pinhed, dammutun iggatang tu mewan etan di pamilyah ni nengatngan tu. Eleg mabalin ni tu iggatang di edum ni tuun nalpud edum ni bebley, tep lawah humman ni pehding tun nunman ni bii. ");
INSERT INTO ify_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Winu hedin wadan hi-gayu hu gimmatang ni bii et peahwa tu etan ni u-ungnga tu, ey mahapul ni ibbilang yu humman ni biin u-ungnga yu dama. ");
INSERT INTO ify_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Winu hedin wadan hi-gayu gimmatang ni i-ahwa tu, nem entanni ey nengahwa mewan ni hakey ni bii et dewwa law ahwa tu, ey mahapul ni eleg tu iwwalleng etan nemangulu, ey eleg tu kullangi etan sigud ni tuka iddawat ni kennen tu, anin ya balwasi tu, ey eleg melumman hu pengibbillang tun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tep hedin eleg tu ippahding humman idan lebbeng tun pehding tu ey mahapul ni ibbukyat tun liblih humman ni bii ma-lat endi law utang tun hi-gatu.’” ");
INSERT INTO ify_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kan Apu Dios nan Moses ey “Ehel muddan tuu e kanmuy ‘Huyya inhel Apu Dios: Hedin wadan hi-gayu hu pina-tu tu edum tu et matey, mahapul ni mettey humman ni pimma-tu. ");
INSERT INTO ify_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nem hedin eleg tu igeb-at ey heballi umbesik etan di puttuken tun bebsikan tu, ma-lat endi lawah ni mekapyan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nem hedin pimmatey hu hakey ni tuu ey inggeb-at tu tep ya bunget tu, mahapul ni mettey humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ya etan tuun kewwayen tu ammed tu ey mahapul ni mettey humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ya etan tuun um-ibsik ni edum tun tuu et tu igtang winu pambega-en tu ey mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ya etan tuun iddutan tu ammed tu ey mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Hedin nandepap hu dewwan tuu et duntuken etan ni hakey hu nekidpap tu winu sinuktukan tun batu et maliputan, nem eleg matey, eleg mekastigu humman ni kimmaway nem mahapul ni ");
INSERT INTO ify_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","baddangan tu humman ni kinway tu ingganah ni umyaggud. Ey beyyadan tu netaktakan tud ngunu tu. ");
INSERT INTO ify_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ya etan tuun nambakdungan tu himbut tu, laki winu bii gapuh ni bunget tu et matey ey mahapul ni mekastigu. ");
INSERT INTO ify_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nem hedin melabbah hu dewwan aggew ey eleg matey etan himbut, eleg mekastigu etan kan himbut tep himbut tu etan tuu. ");
INSERT INTO ify_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Hedin wada dewwan tuun nandepap, ey inlagat da hu biin nambutsug et humman himmulun ni nengunuhan tu, mahapul ni memulta etan nengilegat ni hi-gatu. Ya multa tu ey ngenamung hu ibbaga etan ni ahwan etan ni bii ey kaebbulutadda etan ni kamengippennuh nunman ni diklamuh ");
INSERT INTO ify_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Nem hedin neliputan etan bii, mahapul ni mekastigu etan nengilegat ni hi-gatu. Ey hedin netey etan bii, mahapul ni mettey dama etan nengilegat ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Hedin kinulap ni hakey ni tuu hu matan edum tu, mahapul daman kullapen yu mata etan ni nambahul. Hedin pinlag ni hakey ni tuu ngipen ni edum tu, mahapul ni peplagen yu dama ngipen etan ni nambahul. Hedin giniplung ni hakey ni tuu ngamay ni edum tu, mahapul ni giplungen yu dama ngamay etan ni nambahul. Hedin heli negiplung, mahapul ni giplungen yu dama helin etan ni nambahul. ");
INSERT INTO ify_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Hedin inetungan ni hakey ni tuu edum tu, winu liniputan tu edum tu, mahapul ni ettungan yu winu lipputan yu dama etan nambahul. ");
INSERT INTO ify_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ya etan tuun kinway tu bega-en tun bii winu laki et gapun nunman ey nekulap etan bega-en tu, mahapul ni ibbukyat tun liblih humman ni bega-en tu et humman bayad ni nekulapan tu. ");
INSERT INTO ify_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hedin naplag hu ngipen etan ni bega-en ey mahapul ni ibbukyat tun liblih humman ni bega-en et humman bayad ni naplagan ni ngipen tu.’” ");
INSERT INTO ify_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kan Apu Dios nan Moses ey “Ehel muddan tuu huyya: ‘Hedin wada neibukyat ni animal ey himma-duk ni tuu et matey, mahapul ni tegmilen humman ni animal et matey. Eleg mekastigu etan kan animal ni nunman niya entan tu ihida humman ni netegmilan ni animal. ");
INSERT INTO ify_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nem hedin inamtan etan ni kan animal e wada hina-duk tu lan nunman nem binay-an tu, ey hedin wada petteyen nunman ni animal ni tuu, mahapul ni tegmilen yu humman ni animal et matey niya mahapul ni mettey dama etan kan animal. ");
INSERT INTO ify_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nem mabalin ni eleg yu pepettey etan tuu hedin beyyadan tu ibbagaddan agin nunman ni netey ey kaebbulutaddan kamengippenuh nunman ni diklamuh. ");
INSERT INTO ify_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Anin ni laki winu bii pintey etan ni animal ey man-ingngeh hu kastiguh etan ni kan animal. ");
INSERT INTO ify_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nem hedin himbut ni laki winu bii pintey ni animal, mahapul ni beyyadan etan ni kan animal ni telumpulun silber etan di kan himbut niya mahapul ni tegmilen etan animal et matey. ");
INSERT INTO ify_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Hedin wada nangku-kun bitu ey eleg tu hababen et wada na-gah diman ni animal ni edum ni tuu, ");
INSERT INTO ify_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mahapul ni beyyadan etan ni nangku-ku etan animal. Hedin binaydan tu etan kan animal, mabalin ni i-anemut tu etan netey ni animal e heni tu gintang. ");
INSERT INTO ify_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Hedin wada nanlaban ni dewwan bulug ni baka ey netey hu hakey, mabalin ni manhummangan ida etan kan animal et igtang da etan pimmatey ma-lat panggedwada bayad tu. Ey panggedwada detag etan ni netey. ");
INSERT INTO ify_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Nem hedin neamta e mabunget etan bulug ni pimmatey ey eleg ippaptek etan ni kan bagi anin ni inhel dan hi-gatu nem kahing et deh e pimmatey ni edum ni animal, mahapul ni hullulan tu etan netey ni animal. Ey hedin i-abulut ni kan bagi etan netey ni animal, mabalin ni i-anemut tu humman ni netey ni animal.’” ");
INSERT INTO ify_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel e kammuy ‘Huyya hu inhel Apu Dios: Hedin wada nenakew ni animal et kelngen tu winu inggatang tu ey neha-kupan, mahapul ni hullulan tu humman ni sinekew tu. Hedin baka sinekew tu, hullulan tun liman baka. Hedin kalneroh sinekew tu, hullulan tun epat ni kalnero. ");
INSERT INTO ify_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Hedin neha-kupan nem eleg tu kelngen winu eleg tu igtang etan sinekew tun animal, mahapul ni hullulan tun dewwa anin hipa humman ni animal. Nem hedin eleg kabaelan etan ni nenakew ni hullulan etan sinekew tu mahapul ni mambalin ni bega-en etan ni kan animal ni sinekew tu. Hedin wada nenakew ni hileng ey pintey etan ni kan baley ni nenakewan tu, eleg mekastigu etan pimmatey tep beken tu bahul. Nem hedin kawwalwal hu nemateyan tu ey kantuy nenakew humman ni tuu ey nambahul et mahapul ni mekastigu. ");
INSERT INTO ify_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Hedin wada nengigeb-at ni nengibukyat ni animal tu et kanen tu intanem ni edum tu, mahapul ni hullulan etan ni kan animal. Ey ya ihhullul tu ey mahapul ni kakkayyaggud ey nalpud intanem tu. ");
INSERT INTO ify_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hedin nan-apuy hu hakey ni tuud puyek tu ey entanni ey immetteng etan apuy et mailegat ni nalgab hu intanem ni edum ni tuu, mahapul ni pekabbeyyadan tu etan ida nebahbah ni neitnem. ");
INSERT INTO ify_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Hedin wada dewwan tuun nanhummangan et patelun etan ni hakey hu pihhuh tu winu hipa humman ey sinekew da nem nehamak etan nenakew, mahapul ni mandubli hu ihullul etan ni nenakew etan ni sinekew tu. ");
INSERT INTO ify_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Nem hedin neendi etan impatelu etan ni hakey ey kan etan ni nengitlu ey netakew, nem eleg mahemak etan nenakew, mahapul ni mebistigal etan nengitlu etan di daka pandeyyawwin Apu Dios ma-lat meamta hedin makulug numan hu inhel tu. ");
INSERT INTO ify_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Hedin wada diklamuh yu meippanggep ni animal yu, henin baka, kebayyu, kalneroh winu balwasi winu wada netalak ni ngunut yun mahapul ni illaw yud yuka pandeyyawi. Ey hedin wada netalakan ni kumpulmi, nem entanni ey himmak yud baley ni edum ni tuu, nem kaippilit etan ni kan baley e bagi tu humman, mahapul ni yu ippanuh etan di yuka pandeyyawin Apu Dios et ya etan e-helen tun nambahul ey mandubli hu ibbayad tu. ");
INSERT INTO ify_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","11","Hedin impapekan ni hakey ni tuu hu animal tud sinakdul tu nem entanni ey netey, winu neliputan winu netakew nem endi nenang-ang ni mengi-hel ni makulug ni neipahding, mahapul ni umlaw etan nengipaptek et an mansapatah nan Apu Dios e endi lawah ni impahding tu etan ni animal. ");
INSERT INTO ify_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Hedin beken ni netakew etan animal, eleg beyyadi etan ni nengipaptek. Nem hedin wada nenakew etan ni animal, mahapul ni beyyadan etan ni nengipaptek. ");
INSERT INTO ify_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Hedin pintey ni animal di muyung, eleg memulta etan nengipaptek nem mahapul ni peang-ang tu annel etan ni netey ni animal etan ni kan bagi, ma-lat pengamtaan tun neipahding, ey eleg mahapul ni mebeyyadan etan animal. ");
INSERT INTO ify_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Hedin wada bimmaneh ni animal, nem entanni ey wada lawah ni nekapya etan ni animal ey eleg ang-ang-angen etan ni kan animal hedin hipa ustuh ni neipahding, mahapul ni hullulan etan ni bimmaneh winu beyyadan tu humman ni animal. ");
INSERT INTO ify_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Nem hedin inang-ang etan ni kan animal ustuh ni neipahding, eleg tu beyyadi etan ni nemaneh. Hedin neabangan, eleg mahapul ni mebeyyadan tep ya etan abang hu heni neibeyad.’” ");
INSERT INTO ify_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kan Apu Dios nan Moses “Ehel muddan edum mun helag Israel e kammuy: ‘Huyya inhel Apu Dios: Hedin in-ulig ni laki hu biin eleg meitgan hi-gatu mahapul ni i-ahwa tu ey beyyadan tu meippuun di kameu-unnud ni elaw da. ");
INSERT INTO ify_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nem hedin eleg pinhed etan ni aman etan ni biin mantulluy ida, eleg ida man-ahwa nem mahapul ni ittetbalan tu humman ni bii. ");
INSERT INTO ify_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Mahapul ni pepettey ida maeyak. ");
INSERT INTO ify_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ya tuun mengi-ullig ni animal et mekipeplet ni animal ey mahapul ni pepettey yu. ");
INSERT INTO ify_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ya tuun tuka deyyawa ey tuka i-apisi edum ni dios e beken ni hi-gak ni ebuh ey mahapul pepettey yu. ");
INSERT INTO ify_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Entan tu ipahding lawah idan tuun nalpud edum ni bebley ni immalin nekibebley ni hi-gayu tep nemnem yu e limmaw kayu daman nekibebley di Egypt. ");
INSERT INTO ify_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Entan tu ipahding hu lawah idan nebalun bii niyadda nepu-hig. ");
INSERT INTO ify_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tep hedin humman pehding yun hi-gada et mambeggaddan baddang ku, makulug ni baddangan kudda. ");
INSERT INTO ify_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Et gapuh ni nemahhig ni bunget ku ey peellik ida mengubbat ni hi-gayu et pateyen dakeyu et mabelludda ahwa yu ey mepu-hig ida u-ungnga yu. ");
INSERT INTO ify_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Hedin mampeuttang kayun pihhuh yuddan edum yun helag Israel ni mahapul tu baddang, entan iu-unnud idan edum ni kamampeuttang ni pihhu. Entan peporsentoh hu pihhuh yun peuttang yu. ");
INSERT INTO ify_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Hedin balwasi hu inla yun pengitngedan yun inutang etan ni tuu, mahapul ni kahilehileng ey pebangngad yu etan balwasi tu. ");
INSERT INTO ify_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Tep inna-nu hedin humman ni ebuh hu balwasi tu. Tep hedin eleg yu pebangngad ey mektel et eleg pakeugip ni kintel tu. Ey hedin mampehemmehemmek ni hi-gak man makulug ni idawat ku ibbagetu, tep hedin hi-gak man nakka pekahmekadda anggehemmek ni tuu. ");
INSERT INTO ify_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Entan tu pihul ey beken ni lawah hu yu e-helen idan neputuk ni mengipappangngulun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Hedin na-teng pagey yu, napget hu ingkail yu ey neluum ida lameh ni intanem yu, entan liwwan tun um-iappit nunman ni lebbeng tun kamei-appit ni hi-gak. Ey mahapul ni iddawat yun hi-gak hu pengulwan ni u-ungnga yu, nem ya animal hu ihhullul yun i-appit. ");
INSERT INTO ify_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Anin idan nemangulun impah ni baka niya kalneroh ey pakiha-ad yun inetun pitun aggew et i-appit yun hi-gak ni kawelun aggew ni nengappilan yud inetu. ");
INSERT INTO ify_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Hedin wada animal yun pintey ni animal di muyung, entan tu ihida. Diman et kanen ni ahhu tep tuu dakeyun hi-gak.’” ");
INSERT INTO ify_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Kan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel e kammuy ‘Huyya inhel Apu Dios: Entan ihinap hu linggeman ni beken ni makulug. Ey hedin mantistigu kayu, entan tu ehel hu itek ma-lat baddangan yu etan nambahul. ");
INSERT INTO ify_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Anin hedin kantu et dakel ida kamengippahding ni lawah e ida kamantistigun itek ma-lat eleg meipahding hu limpiyuh, entan tu iehneng ida humman ey entan tu u-unnud humman ni daka pehding. ");
INSERT INTO ify_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ey beken ni gapu tep newetwet etan nandiklamuh ey hi-gatu baddangan yu. ");
INSERT INTO ify_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Hedin wada inang-ang yun animal ni bimmukyat, guyud yu et ilaw yu etan ni kan animal anin hedin kantu et buhul yu humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Hedin kamampaligat hu kebayyun buhul mu e eleg pakeehneng tep mebel-at hu karga tu, baddangim etan tuu et peehneng mu etan kebayyu tu, beken nealay mu lebbahan. ");
INSERT INTO ify_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Entan tu kastigu hu hakey ni tuu gapu tep newetwet. ");
INSERT INTO ify_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ey entan tu legelegem deek ni edum yun tuu et kanyuy nambahul anin amta yun endi buhul tu et papetey yu, tep kastiguen ku mengippahding nunman ni lawah. ");
INSERT INTO ify_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Hedin kan ni hakey ni tuuy beyyadan dakeyu et iehneng yu etan di lawah ni tuka pehding, man entan tu abulut. Ya henin nunman ni bayad ey heni tu kullapen hu tuu et eleg meippahding hu limpiyuh etan idad endi hu bahul tu. ");
INSERT INTO ify_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Entan tu ipahding hu lawah etan idad edum ni tuun immalin nekibebley ni hi-gayu tep amta yu gibek tu tep anin ni hi-gayu et hiniktaman yu hanniman ni nekibebleyan yu lad Egypt.’” ");
INSERT INTO ify_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","11","Kan Apu Dios nan Moses “Ehel muddan helag Israel e kammuy ‘Enem ni toon hu panlelyakan yun payew yu ey enem ni toon hu pantenneman yun legutan yu ma-lat wada eppiten yun kennen yu. Nem yan meikkepitun toon ey eleg yudda tennemi. Ey hedin wada illameh idan etan ni sigud ni neitnem, ihulug yuddan newetwet et pengal-an dan kennen da. Hedin wada sindaan da, diman et pengannan idan animal di muyung. ");
INSERT INTO ify_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Yan hanlingguan ey enem ni aggew hu pangngunnuan yu, nem yan meikkepitun aggew ey man-iyattu kayu et yadda bega-en yu, anin idan nalpud edum ni bebley ni yuka pangngunnu ey anin idan animal yun yuka pan-elladu ey man-iyattudda dama. ");
INSERT INTO ify_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ang-ang yu et u-unnuden yun emin huyyan inhel Apu Dios. Entan tu dayaw hu edum ni dios ey entan tu ene-ehhel hu ngadan da.’” ");
INSERT INTO ify_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel e kammuy ‘Huyya inhel Apu Dios: Entan tu liwwan ni ippahding ida etan tellun piyestah ni katootoon. ");
INSERT INTO ify_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ya memengngulu ey ya Piyestah ni Sinapay ni eleg meha-adan ni kamampelbag. Meu-unnud etan inhel kun pehding yu eman ni wada kayud Egypt. Eleg kayu mengngan ni sinapay ni neha-adan ni kamampelbag ni pitun aggew, ey mahapul ni wada i-appit yun pandeyyawan yun hi-gak ni nunyan piyestah. ");
INSERT INTO ify_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ya meikkadwa ey ya Piyestah ni Ani. Pehding yu huyyan piyestah ni pengilleppuan yun man-enni. Et ya meikkatlun piyestah ey ya Piyestah ni Kampu e puggahen yu grapes niyadda edum ni kamekkan ni lameh ni keyew. ");
INSERT INTO ify_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ippahding yudda huyyan piyestah ni katootoon. Mahapul ni um-alidda emin hu helag Israel ni lalakkin menaydayaw ni hi-gak e Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Entan pan-appit ni sinapay ni nekamdugan ni kamampelbag ni pan-appitan yun animal. Ey ang-ang yu et endi metdaan ni kewa-waan tun tabaddan animal ni i-appit yun hi-gak ni nunyan piyestah. ");
INSERT INTO ify_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ey mahapul ni illaw yud baley ku e Ap-Apu e Dios yu hu kekakkayyaggudan idan memengngulun lameh ni intanem yu et iappit yun hi-gak. Entan tu iheeng hu impah ni kalneroh winu gelding di gatas ni inetu.’” ");
INSERT INTO ify_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Entanni ey immehel mewan hi Apu Dios et kantun Moses ey “Ehel muddan edum mun helag Israel e kammuy ‘Huyya inhel Apu Dios: Ittu-dak ku anghel kun mengippengngulun hi-gayu ingganah ni umdateng kayu etan di indaddan kun yu pambebleyan. ");
INSERT INTO ify_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","U-unnud yu e-helen nunyan anghel. Entan tu kahing tep hi-gak nengitu-dak ni hi-gatu. Hedin kehhingen yu, eleg dakeyu pessinsahi. ");
INSERT INTO ify_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nem hedin u-unnuden yu, et ipahding yun emin hu e-helen ku ey hi-gak hu ngenamung ni mekihhanggaddan buhul yu. ");
INSERT INTO ify_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Humman ni anghel ku mengippengngulun hi-gayu ingganah ni umdateng kayud bebley idan Amorite, Hittite, Perissite, Kanaanite, Hebite, niyadda Jebusite, et kayu mambebley diman. Hi-gak e Dios hu mekihhanggan hi-gada et pateyen kudda. ");
INSERT INTO ify_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Entan tu dayaw hu dios da ey entan tu iu-unnud di daka pehding ni menaydayaw ni dios da. Bahbah yu kumadda etan kinapya dan dios da niyadda hinead dan batun daka deyyawa. ");
INSERT INTO ify_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Hi-gak e Ap-Apu e Dios yu hu deyyawen yu, iddawtan dakeyun kennen yu niya danum ni innumen yu ey e-kalen ku degeh yu. ");
INSERT INTO ify_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ey endiddan aahwa yu hu mengunnuh niya endi an mebessi ey iddawtan dakeyun andukkey ni biyag. ");
INSERT INTO ify_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Petekkut ku ey himmengen kudda mengubbat ni hi-gayu ma-lat hedin kayu kamengelli ey memsik ida. ");
INSERT INTO ify_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Pemengnguluk ni peelli inelit ma-lat pabsik dadda Hibite, yadda Kanaanite niyadda Hittite ni wadadman. ");
INSERT INTO ify_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nem beken ni ida menga-mut ni me-kal emin ni hantoon et endi an metdaan. Tep hedin mambalin ni mamuyung etan bebley, umdakkel idalli anggetakkut ni animal et anggetakkut ali kumamman. ");
INSERT INTO ify_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Heballi in-inut hu pehding kun mengkal ni hi-gada ingganah umdakkel kayu et penuen yu etan bebley. ");
INSERT INTO ify_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ihhammad kulli pappeg ni bebley ni lawwan yu e meippalpud Madlang ni Baybay ingganah di gilig ni baybay di Pilistia et mampalaw la etan di eleg mebebleyi ingganah di Wangwang e Euphrates. Baddangan dakeyun lawwan yudman ma-lat apputen yudda tuudman et degyunen yudda. ");
INSERT INTO ify_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nem entan pekidagyum ni hi-gada niya entan peki-dum ni mandeyyaw ni dios da. ");
INSERT INTO ify_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ey entan iebuluttuddan mekibbebley ni hi-gayu tep meewwis kayulli kumedek ni mengippahding ni panliwwatan ni pandeyyawan dan dios da.’” ");
INSERT INTO ify_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Immehel hi Apu Dios nan Moses e kantuy “Ikuyug muddallid Aaron, hi Nadab, hi Abihu niyadda etan nepitun kamengipappangngulun helag Israel et manteyed kayu eyad kad-ak nem meidaddawwiddan menaydayaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Nem hi-gam ni ebuh hu meihnup ni hi-gak. Yadda ikkuyug mu ey meidaddawwidda et yadda etan tuu ey eleg mabalin ni ida umtetyed eyad duntug.” ");
INSERT INTO ify_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Nandayyu hi Moses et ehelen tuddan edum tun helag Israel hu intugun Apu Dios ni pehding da. Ey emin ida ey kanday “Ippahding min emin huttan ni inhel Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Intudek Moses ida emin hu Tugun Apu Dios. Newa-wa et humelaman hi Moses ni an nengapyan pan-appitan nan Apu Dios di hengeg ni duntug. Et iha-ad tu hampulut dewwan batud nanlinikweh nunman ni pan-appitan ni mengi-ehneng idan hampulun dewwan helag eman ni ammed da e hi Israel. ");
INSERT INTO ify_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Et ehelen tuddan nangkehiken ni lalakkin man-appit nan Apu Dios ni kagihheba niyadda kilaw ni bakan i-appit dan pekiddagyuman. ");
INSERT INTO ify_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Inha-ad Moses idad mahukung ni duyu hu kagedwah ni kuheyaw et ya gedwatu ey inwakgih tu etan di pan-appitan. ");
INSERT INTO ify_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ey inla tu etan libluh ni nengitudekan tuddan tugun Apu Dios et eleten tun imbidbid idad edum tun helag Israel. Ey kanday “U-unnuden mi Apu Dios ey ippahding midda emin hu inhel tu.” ");
INSERT INTO ify_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Inlan Moses etan kuheyaw et wakgihan tudda etan tuu e kantuy “Huyyan kuheyaw hu mengippeamta e mahapul ni u-unnuden tayu hu nekitbalan Apu Dios ni hi-gayu eman ni nanghelan tuddan emin eyan tugun.” ");
INSERT INTO ify_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Negibbuh humman et ikuyug Moses di Aaron, hi Nadab, hi Abihu niyadda etan nepitun kamengipappangngulu et manteyed ida etan di duntug, ");
INSERT INTO ify_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ey inang-ang da etan Dios da. Ya immehnengan tu ey heni neap-apan ni batu e sapphire e kamanlinnang e heni ang-ang ni kabunyan hedin endi kulput. ");
INSERT INTO ify_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Anin inang-ang idan nunyan kamengipappangngulun helag Israel hi Apu Dios ey eleg tudda pateyen. Nengan ida ey imminum idadman di hinangga tu. ");
INSERT INTO ify_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Entanni ey kan mewan Apu Dios nan Moses ey “Panteyed kalli eyad duntug ni kad-an ku et idwat kun hi-gam etan dewwan batun neitudkan idan Tugun kun u-unnuden idan helag Israel.” ");
INSERT INTO ify_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Et umgah hi Moses e kadwa tu etan kaumbabbaddang ni hi-gatu e hi Joshua et manteyed ida etan di duntug. ");
INSERT INTO ify_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Yan nunman ni immegahan da ey inhel Moses idan etan ni aap-apu e kantuy “Dideya kayu. Heged dakemi ingganah mambangngad kami. Hedin wada diklamu, lakkayuy di kad-an di Aaron nan Hur et hi-gada mengippennuh.” ");
INSERT INTO ify_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yan eman ni kamenyed di Moses nan Joshua ey hinephepan ni kulput etan duntug. ");
INSERT INTO ify_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Humman ni kulput hu kei-ang-angan ni kawedan Apu Dios ey nanha-ad etan di duntug ni enem ni aggew. Ey yan meikkepitun aggew ey hi Apu Dios e wada etan di kulput ey immehel nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ya impenang-ang idan helag Israel ni wadad hengeg etan ni duntug ni nunman ni dayaw Apu Dios di ta-pew ni duntug ey heni kamantetebbel ni apuy. ");
INSERT INTO ify_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Limmaw hi Moses etan di ta-pew ni duntug ni hinephepan ni kulput et manha-ad diman ni na-pat ni aggew niya na-pat ni hileng. ");
INSERT INTO ify_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ehel muddan edum mun helag Israel et iappitan da-ak ni hi-gada. Humman idan i-appit dan hi-gak ey meippuun di pinhed dan iddawat. ");
INSERT INTO ify_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Huyyadda dammutun i-appit da: ya balituk, ya silber, ya giniling, ");
INSERT INTO ify_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ya sinayyum ni blue, ya purple, ya makadlang, ya kayyaggud ni luput, ya edum ni luput ni nekapyad dutdut ni gelding, ");
INSERT INTO ify_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ya katat ni lakkitun kalneroh ni nambalin ni madlang, ya katat ni mategun wadad baybay, ya keyew ni akasyah, ");
INSERT INTO ify_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ya lanan olibah e kameihha-ad di kengkeh, ya lanan kaihha-ad di ulu, ya bangbanglun insensoh, ");
INSERT INTO ify_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ya onyx niyadda edum ni nangkenginan batun meittekkap di ephod e balwasin padi niya etan luput ni meittekkap di pagew tu. ");
INSERT INTO ify_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ey mahapul ni ikkapyaan da-ak ni Tabernacle e a-abbung ni tuldah ma-lat makiha-addak ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kapya yu huyyan Tabernacle e iu-unnud yu etan di inhel kun pengapya yu.” ");
INSERT INTO ify_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Kan mewan Apu Dios nan Moses ey “Pengapya kayun Kaban e usal yu keyew ni akasyah. Na-pat et liman pulgadah kadinukkey tu, dewampulut pitun pulgadah kalinakkeb tu, niya dewampulut pitun pulgadah kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Takapi yun nemahmah ni balituk humman ni Kaban, anin ya bawang tu niya nanlinikweh ni nunman ni Kaban. ");
INSERT INTO ify_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ey ikapya yu hu epat ni netullikeng ni balituk diman ni Kaban e handedwad nambina-hil. ");
INSERT INTO ify_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ey kapya kayun keyew ni akasyah ni pan-attang e takapi yun balituk, ");
INSERT INTO ify_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","et idduduk yuddadman ni netullikeng di nambina-hil di Kaban. ");
INSERT INTO ify_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Huyyaddan pan-attang ey mena-yun diman e eleg mabalin ni an me-kal. ");
INSERT INTO ify_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Hedin negibbuh, ihudum diman ni Kaban etan iddawat kun hi-gam ni dewwan batun neitudekan idan Tugun ku. ");
INSERT INTO ify_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Pengapya kayun nemahmah ni balituk ni hu-keb nunyan Kaban. Ya kadinukkey tu ey na-pat et liman pulgadah ey dewampulut pitun pulgadah hu kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Pengapya kayun dewwan anghel di nambinengwah di hu-keb e meihakkey hu kapya tu. ");
INSERT INTO ify_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Manhinnanggadda e mebekyag payak da et hephepan da huyyan hu-keb. ");
INSERT INTO ify_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ihu-keb yu etan di kapyaen yun Kaban ni pengihha-adan yudda etan ni dewwan batun iddawat kun hi-gam. ");
INSERT INTO ify_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Um-ali-ak alid ta-pew ni hu-keb di nambattanan idan etan ni dewwan anghel et idwat kun emin ni hi-gam ida tugun kun u-unnuden yun emin ni helag Israel.” ");
INSERT INTO ify_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kan mewan Apu Dios nan Moses ey “Pengapya kayun tebol e usal yu hu keyew ni akasyah. Ya kadinukkey tu ey tellun piyeh, ya kalinakkeb tu ey hakey et kagedwah ni piyeh niya nehuluk ni dewwan piyeh kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Takapi yun nemahmah ni balituk huyyan tebol niya nanlinikweh ni gilig tu. ");
INSERT INTO ify_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hu-upi yun tellun pulgadah di nanlinikweh ni gilig tu ey takapi yun balituk. ");
INSERT INTO ify_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ikapyai yun hanhakkey ni netullikeng ni balituk etan epat ni helin nunyan tebol di dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ikapya yudda huyyan netullikeng di daul ni gilig ni tebol. ");
INSERT INTO ify_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ey pengapya kayun keyew ni akasyah ni pan-attang yun nunyan tebol ey takapi yun balituk. ");
INSERT INTO ify_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ey pengapya kayun nemahmah ni balituk ni duyun pengihha-adan ni bangbanglun insensoh, ya basuh, ya pa-nay niya mahukung ni duyun pengidduyyagan yun meinnum ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mahapul ni wadan kenayun hu sinapay ni ihha-ad yud hinangngab ku etan di tebol ni kapyaen yu.” ");
INSERT INTO ify_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Kan mewan Apu Dios ey “Pengapya kayun nemahmah ni balituk ni pengippettukan ni kengkeh. Ihakkey yun panday hu hengeg tu niya palat tu. Ey ihakkey yuddan kapya hu heni basuh niyadda habung ni al-alkus tu. ");
INSERT INTO ify_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Humman ni pengippettukan ni kengkeh ey enem panga tu e hantetlud nambina-hil. ");
INSERT INTO ify_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Mei-peng idan nunman ni enem ni panga hu basuh ni heni habung ni almond. ");
INSERT INTO ify_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ya etan palat nunman ni pengippettukan ni kengkeh, ey neal-alkusan ni epat ni heni dama habung ni almond. ");
INSERT INTO ify_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","I-peng yun ikkapya hu hanhakkey ni habung ni eleg mebekyag di daul ni handedwan pangan etan ni pengippettukan ni kengkeh. ");
INSERT INTO ify_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Huyyaddan habung ni eleg mebekyag et yadda panga ey meihakkey hu kapkapya tud pengippettukan ni kengkeh. Nemahmah ni balituk hu mekapyan emin idan nunya. ");
INSERT INTO ify_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Pengapya kayun pitun kengkeh et ipetuk yuddad kapyaen yun pengippettukan et madilagan hu hinangnga tu. ");
INSERT INTO ify_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ey mahapul ni ya nemahmah ni balituk hu kapyaen yuddan ipit anin etan ni ha-addan. ");
INSERT INTO ify_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Umlaw ni telumpulut epat ni kiloh ni nemahmah ni balituk hu kapyaen yun nunyan pengippettukan ni kengkeh niyadda emin huyyan meussal. ");
INSERT INTO ify_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mahapul ni kapyaen yudda huyya e peka-i-u-unnud mu etan di impeang-ang kun hi-gam eyad duntug.” ");
INSERT INTO ify_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Kan mewan Apu Dios ey “Heninnuy hu pengapya yun Tabernacle ni panha-adan ku: Pengapya kayun hampulun kultinah. Usal yu kakkayyaggud ni luput et ya blue, ya purple niya makadlang ni sinayyum, ey bordai yuddan nepayakan ni anghel. ");
INSERT INTO ify_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Emin ida huyyan kultinah ey man-iingngeh ida e umlaw di na-pat et dewwan piyeh hu kadinukkey da niya enem ni piyeh hu kalinakkeb da. ");
INSERT INTO ify_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pengapya kayun dewwan melakkeb ni kultinah e pandadagsi yun kugguten hu lima idan nunyan kultinah et meihakkey ida. Hanniman dama pehding yu etan ni liman kultinah. ");
INSERT INTO ify_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tullikeng yu hu sinayyum ni blue et ikugut yudda huyyad gilig idan nunman ni dewwan nanggillig ni kultinah. ");
INSERT INTO ify_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Hannenelima hu ikkugut yun netullikeng di gilig idan nunman ni dewwan kultinah ey mahapul ni mampepettek ida. ");
INSERT INTO ify_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Pengapya kayun neliman balituk ni pengippit yun gilig idan nunman ni dewwan kultinah ma-lat meikkahhakey hu dingding ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kapya kayun hampulut hakey ni kultinah ni dutdut ni gelding et itta-kep yuddad luput ni kultinah ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Pan-iingngeh yudda humman ni kultinah e ya kadinukkey ni hakey ey na-pat et liman piyeh niya enem ni piyeh hu kalinakkeb ni hakey. ");
INSERT INTO ify_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pandadagsi yun kugguten hu liman nunyan kultinah et meihakkey ida. Hanniman dama pehding yu etan di enem ni kultinah e pandadagsi yun kugguten ida. Ya etan meikka-nem ni kultinah ey melugpi e meleyyag di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ikapya yu hanneneliman netullikeng di gilig idan nunman ni lima niya enem ni kultinah ni nandadagsin nekugut. ");
INSERT INTO ify_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ey pengapya kayun neliman giniling ni pengippit yun gilig idan nunman ni kultinah et meihakkey ida. ");
INSERT INTO ify_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Meleyyag dama hu utduk dad awwidan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ey meleyyag damad nambina-hil di Tabernacle hu umlaw di hampulut walun pulgadah. ");
INSERT INTO ify_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Pengapya kayun dewwan tuldah ni katat ni lakkitun kalneroh niya kakkayyagud ni katat ni mei-dah. Huyya pengettep yun Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Pengapya kayun kalkalimangngan Tabernacle ni akasyah ni keyew. ");
INSERT INTO ify_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ya kadinukkey idan nunman ni ikkapya yu ey hampulut liman piyeh niya kalinakkeb da ey dewampulut pitun pulgadah. ");
INSERT INTO ify_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Wada man-iingngeh ni handedwan dimmewdew di emin etan di frames ma-lat panhuhuup yudda. ");
INSERT INTO ify_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","21","Hinead dadda handedwampulu idan nunman di appit ni south niyad north ni Tabernacle. Ey ingkapya da newalun silber ni pengittu-unan idan nunman e handedwa neikapyad hengeg ni hakey. ");
INSERT INTO ify_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Yad awwidan ni Tabernacle di appit ni kakelinnugin aggew ey ituun yu hu enem idan nunman ");
INSERT INTO ify_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","niya ituun yu hanhakkey etan di dewwad dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Humman idan meikkapyad dugu ey mandedkep ida meippalpud hengeg tu ingganah di utduk di ta-pew tu e meihhuklub hu netullikeng et mandekep ida. Henin nunman ipahding yud dewwan dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Et walun emin ni henin nunman hu ikkapya yudman ni awwidan ni Tabernacle ey iha-ad yu hu hampulut enem ni silber ni pengittu-unan idan nunman e handedwad hakey idan nunman. ");
INSERT INTO ify_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Pengapya kayun hampulut liman keyew ni akasyah ni meibballabag etan idad kalkalimangngan Tabernacle. Ikapya yu hanlilmad appit ni north, yad south et yad awwidan di appit ni kakelinnugin aggew. ");
INSERT INTO ify_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ya etan ida meiggawwan meiballabag di gawwaddan nunman ni kalkalimangnga ey meipalpud hakey ni dugu ingganah lad hakey mewan ni dugu. ");
INSERT INTO ify_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Pengapya kayu pay ni netullikeng ni balituk ni mengnged idan meibballabag ni keyew. Ey takapi yun balituk huyyan kalkalimangnga, anin idan etan ni meibballabag. ");
INSERT INTO ify_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Hanneya pengapya yun Tabernacle e iu-unnud yu etan impeang-ang kun hi-gam eyad duntug.” ");
INSERT INTO ify_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kan mewan Apu Dios nan Moses ey “Heldak yu bawang ni Tabernacle ni kultinah ni nekapyad kakkayyaggud ni luput e nebordaan ni nepayakan ni anghel. Humman ni luput ey blue, ya purple niya makadlang. ");
INSERT INTO ify_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ihabley yu huyyan kultinah di epat ni tukud ni akasyah e metekkapan ni balituk ey meikkapyaan ni balituk ni hableyyan. Humman idan tukud ey meippeehneng di silber ni pengippeehnengan. ");
INSERT INTO ify_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Humman ni kultinah ni ihha-ad yud bawang ni Tabernacle ey humman manheldak ni Nesantuh ni Kuwaltuh et ya Nekassantuh ni Kuwaltuh Apu Dios. Ey meihha-ad etan Kaban Apu Dios di ba-hil nunman ni kultinah. ");
INSERT INTO ify_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Iha-ad yu etan hu-keb ni Kaban Apu Dios di Nekassantuh ni Kuwaltuh. ");
INSERT INTO ify_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ey iha-ad yu etan kapyaen yun tebol etan di ba-hil ni Kuwaltuh Apu Dios, anin ya etan pengippettukan ni kengkeh. Meihha-ad di willi hu tebol ey yad wannan hu pengippettukan ni kengkeh. ");
INSERT INTO ify_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Pengapya kayu pay ni hakey ni meikkultinah di heggeppan di Tabernacle. Usal yu kakkayyaggud ni luput et ya blue, ya purple niya makadlang ni sinayyum ey iyayyaggud yun bordaan. ");
INSERT INTO ify_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ikapyai yu huyyan kultinah ni liman tukud ni akasyah e tekkapan yun balituk. Et ya kawit da ey balituk dama. Ya keittu-unan idan tukud ey giniling.” ");
INSERT INTO ify_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Kan mewan Apu Dios nan Moses ey “Kapya yu hu altar e usal yu akasyah ni keyew. Humman ni altar ey kuwadladuh e pitu et kagedwah ni piyeh hu kadinukkey tu niya kalinakkeb tu, ey epat et kagedwah ni piyeh kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ey ikapya yu hu heni ha-duk idad ta-pew ni epat ni dugu tu e neihakkey hu kapkapya tud altar. Hedin megibbuh ni kinapya yu ey takapi yun giniling. ");
INSERT INTO ify_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Pengapya kayuddan meussal di pan-appitan henin baldih ni pengihha-adan yun dep-ul, ya pala, ya besin, ya tewik ni detag niya penellukduk ni ngalab. Kapyaen yun emin ida huyyad giniling. ");
INSERT INTO ify_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","5","Kapya kayun nelaggan giniling ni meihha-ket di dimmewdew di gawwan bawang ni altar. Kapya yu epat ni netullikeng etan di epat ni dugun nunman ni altar ni keidduddukan idan pan-attang. ");
INSERT INTO ify_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ey pengapya kayun keyew ni akasyah ni pan-attang et takapan tun giniling. ");
INSERT INTO ify_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Iduduk yudda humman ni pan-attang etan idad netullikeng ni ikkapya yuddad dugun altar ma-lat pengitngedan idan mengi-attang. ");
INSERT INTO ify_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ya tabla hu kapya yun nunman ni altar nem entan tu det-ali hengeg tu. Iu-unnud yu pengapya yu etan di impeang-ang kun hi-gayu eyad duntug.” ");
INSERT INTO ify_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kan mewan Apu Dios nan Moses ey “Pengapya kayun dallin ni Tabernacle e mekultinahan ni kakkayyaggud ni luput hu appit ni south e hanggatut et neliman piyeh kadinukkey tu. ");
INSERT INTO ify_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ya mengnged nunman ni kultinah ey dewampulun tukud ni giniling ni meittu-un di dewampulun giniling ni pengittu-unan. Meihhabley ida etan idad silber ni kawit ey silber ni pengihhableyan ni neikapyaddad tukud. ");
INSERT INTO ify_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hanniman damad appit ni north e hanggatut et neliman piyeh hu kadinukkey ni kultinah ni meihhabley di silber ni kawit ey silber ni pengihhableyan ni meikkapyad dewampulun giniling ni tukud ni meittu-un di dewampulun giniling ni pengittu-unan. ");
INSERT INTO ify_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Yad awwidan di appit ni kakelinnugin aggew ey nepitu et lima hu kadinukkey ni meikkultinah e meihhabley di hampulun tukud ey meittu-un di hampulun pengittu-unan. ");
INSERT INTO ify_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hanniman damad heggeppan di dallin ni Tabernacle di appit ni kasimmilin aggew e mekultinahan ni nepitu et liman piyeh kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Yadman ni heggeppan ey meikkapya hu dewwan kultinah e hakey ni kultinah di winannan ey hakey di winilli. Handedwampulut dewwa et kagedwah ni piyeh hu kalinakkeb ni hakey. Ey hantetlu hu tukud ni meittu-un di tellun nekapyan pengittu-unan hu pengihhableyan idan nunyan kultinah. ");
INSERT INTO ify_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ya etan gawwan heggeppan di dallin ni Tabernacle e mekultinahan ni telumpulun piyeh hu kalinakkeb tu. Meikkapya hu kakkayyaggud ni luput et ya blue, ya purple niya makadlang ni sinayyum ey meiyayyaggud ni mebordaan. Meihhabley huyyan kultinah di epat ni tukud e meittu-un di epat ni pengittu-unan. ");
INSERT INTO ify_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Emin ida tukud di dallin ni Tabernacle ey meikkapyaan ni silber ni kawit niya hableyyan, ey meittu-un idad giniling ni pengittu-unan. ");
INSERT INTO ify_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Et ya lekud ni dallin ni Tabernacle ey hanggatut et neliman piyeh kadinukkey tu, ey nepitu et liman piyeh hu kalinakkeb tu, ey pitu et kagedwah ni piyeh hu kasina-gey tu. Ya etan meikkultinah, ey mahapul ni kayyaggud ni luput hu mekapya. Yadda pengittu-unan idan tukud ni keihhableyan idan kultinah ey giniling hu mekapya. ");
INSERT INTO ify_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Emin hu meussal di Tabernacle, anin idan paghek ey giniling hu mekapya. ");
INSERT INTO ify_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Imandal muddan edum mun helag Israel et umi-liddan kekakkayyaggudan ni lanan olibah ni meihha-ad idad kengkeh ni pandillag di Tabernacle et mantettebbel idan ingganah. ");
INSERT INTO ify_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Meihha-ad etan pengippettukan ni kengkeh di ba-hil ni kultinah ni Kuwaltuh Apu Dios. Hi Aaron et yadda u-ungnga tun lalakki hu mampaptek idan nunman ni kengkeh ey mahapul ni mantettebbel idan neyun ni hileng ingganah kakkabbuhhan di kad-an Apu Dios. Mannenneng huyyan olden ni pehding idan helag Israel et yadda u-ungnga da.” ");
INSERT INTO ify_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kan mewan Apu Dios nan Moses ey “Hi Aaron e agim et yadda u-ungnga tun lalakki e hi Nadab, hi Abihu, hi Eleasar et hi Ithamar hu nepilin mampeddin mansilbin hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pakugut kan balwasin Aaron ma-lat melispituh ey kayyaggud ang-ang tun pengippahdingan tun ngunu tu ey keang-angan tu e hi-gatu ey neieng-eng ni hi-gak e Dios. ");
INSERT INTO ify_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ehel muddan nelaing ni menguggut et kuguten da balwasin Aaron et meang-ang e hi-gatu ey neieng-eng ni mampeddin mansilbin hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Huyyadda mekuggut ni ussalen ni padi: Ya luput ni meittekkap di pagew, ya ephod, ya mei-dah ni balwasi, ya nebordaan ni balwasi, ya meipnget di ulu et ya mei-ewwakeh. Pampakugut ka pay ni kayyaggud ni ibbalwasiddan lalakkin u-ungngan Aaron ni pengippahdingan dan ngunu dan padik. ");
INSERT INTO ify_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Humman ida ey mekapyad kayyaggud ni luput niya balituk ni heni sinulid, ya blue, ya purple, niya makadlang ni sinayyum. ");
INSERT INTO ify_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Mahapul ni kayyaggud ni luput niya balituk ni heni sinulid hu kapyaen yun ephod, ey mebordaan ni blue, ya purple, niya makadlang ni sinayyum. ");
INSERT INTO ify_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Huyyan ephod ey dewwan luput ni nan-appil e hakey di hinangga, ey hakey di beneg e keittekkapan ni dewwan luput ni meihhabley di pahhannan. ");
INSERT INTO ify_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mahapul daman ya kayyaggud ni luput hu mekapyan meibalkeh di ephod, ey mahapul ni meiyayyaggud ni mebordaan ni balituk ni sinayyum, ya blue, ya purple niya makadlang. ");
INSERT INTO ify_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ala kayun dewwan batun onyx et iku-lit yudman hu ngadan idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Enem ni ngadan hu meikku-lit di hakey ni batu, ey enem damad hakey, et meiku-lit emin hu ngadan idan helag Israel meippuun di nanhahaynedan dan neiungnga, meippalpud pengulwan ingganah di udidyan. ");
INSERT INTO ify_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Iku-lit mudda huyyan ngadan idan helag Israel henin kapehding ni nelaing ni mengikku-lit ni sinyal di nenginan batu. Itekap mudda huyyan dewwan batu etan di balituk ni keihha-adan da, ");
INSERT INTO ify_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","et itakap dadda huyyan batu etan di neihabley di nambina-hil di pahhannan ni ephod. Huyyaddan batu hu penginemnemneman Apu Dios idan helag Israel. Peang-ang Aaron di pahhannan tudda humman ni neiku-litan ni ngadan da, et nemnemnemen kun ingganah ida tutu-uk. ");
INSERT INTO ify_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Itekap mudda huyyan dewwan batud balituk. ");
INSERT INTO ify_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ey pengapya kayun dewwan heni linubid ni nekapyad nemahmah ni balituk et iiket muddan nunman ni balituk. ");
INSERT INTO ify_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Pengapya kayun luput ni meittekkap di pagew ni ephod, et usalen ni padin mengamtan pinhed Apu Dios ni meippahding. Nan-ingngeh hu ussalen yun nunyad etan di kapyaen yun ephod ey iyayyaggud yu daman bordaan. ");
INSERT INTO ify_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kuwadladuh huyyan luput e melugpi, et heyam ni pulgadah hu kadinukkey tu ey kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Itekap yudya hu epat ni linyah ni nambakbaklang ni nebalol ni batu: yad etan di nemangulun linyah ey itekap yu hu ruby, ya topaz niya garnet, ");
INSERT INTO ify_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","yad meikkadwan linyah ey ya emerald, ya sapphire niya diamond, ");
INSERT INTO ify_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","yad meikkatlun linyah ey ya turquoise, ya agate niya amethyst, ");
INSERT INTO ify_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","niyad meikka-pat ni linyah ey ya beryl, ya onyx niya jasper. Meittekkap idan emin huyyan nebalol ni batud balituk. ");
INSERT INTO ify_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Meitudek emin hu ngadan idan hampulut dewwan u-ungngan Jacob idadman ni nenginan batu et iehneng dan emin hu helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ikapyai yun nelubid ni banggel ni nemahmah ni balituk huyyan luput ni meittekkap di pagew ni ephod, ");
INSERT INTO ify_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ey pengapya kayun dewwan netullikeng ni balituk et ikugut yud dewwan dugun nunman ni luput di ta-pew tu. ");
INSERT INTO ify_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Iiket yu humman ni dewwan nelubid ni balituk di diman ni netullikeng. ");
INSERT INTO ify_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ey ya utduk idan nunman ni nelubid ni banggel ey iiket yu etan di dewwan balituk ni keipketan idan batun onyx ni meittekkap etan di meihhabley di pahhannan ni ephod. ");
INSERT INTO ify_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Pengapya kayu mewan ni dewwan netullikeng ni balituk, ey ikugut yu etan di dewwan dugun etan ni utduk ni luput ni meittekkap di pagew ni ephod. Meikkuggut ida huyyad piggad etan ni luput et maitumuk di ephod. ");
INSERT INTO ify_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Pengapya kayu pay ni dewwan netullikeng ni balituk ey ikugut yud hinanggan nunyan luput di ta-pew ni balkeh ni ephod. ");
INSERT INTO ify_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Usal yu blue ni linubid ni mengi-ikket diman ni netullikeng ni meikkuggut di luput ni meittekkap di pagew ni ephod di ta-pew ni balkeh tu. ");
INSERT INTO ify_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Hedin umhegep hi Aaron di Nesantuh ni Kuwaltuh di Tabernacle, ey ihhuklub tu humman ni luput ni meittekkap di pagew e wada ngadan idan u-ungngan Israel di pettek ni puhu tu, et maipenemnem kayun tutu-uk ni ingganah. ");
INSERT INTO ify_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ihudu yu etan Urim et ya Thummim etan di bulsan nunman ni luput ni meittekkap di pagew et meita-pew di pettek ni puhun Aaron hedin ibbalwasi tun lawwan tud kuwaltuh ku, ma-lat wadan ingganah nan Aaron ida humman ni pengamtaan yuddan tutu-uk ni pinhed kun pehding yu. ");
INSERT INTO ify_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Kugut kayu pay ni blue ni balwasin mei-dah di ephod. ");
INSERT INTO ify_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kapyai yun huklubban ni ulu ey kuguti yun luput hu gilig nunman ni huklubban henin edum ni balwasi ma-lat eleg mebi-ki. ");
INSERT INTO ify_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Pengapya kayun henin lameh ni pomegranate e usal yu hu blue, ya purple et ya makadlang ni sinayyum ey inta-yun yuddad nanlinikweh di utduk nunyan balwasi e meibbenattan di balituk ni kingking. ");
INSERT INTO ify_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hedin inta-yun yu hakey ni kingking, intu-nud yu hakey etan ni heni pomegranate ingganah melikweh hu utduk nunman ni balwasi. ");
INSERT INTO ify_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ibbalwasin Aaron huyyan heggeppan tud Nesantuh ni Kuwaltuh di Tabernacle ni pansilbian tun hi-gak e Ap-Apu et mantettennul hu kingking ni heggeppan tu niyan e-hepen tu. Mahapul ni u-unnuden tun emin huyya ma-lat eleg matey. ");
INSERT INTO ify_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ey pengapya kayun medal ni nemahmah ni balituk et iku-lit yu hu ‘Neieng-eng nan Apu Dios.’ ");
INSERT INTO ify_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Iiket yu blue ni linubid di medal, ey ittakap yud hinanggan etan ni kapyaen yun penget Aaron. ");
INSERT INTO ify_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Meittekkap huyyan medal di tuktuk nunman ni penget, et heni in-agtu tu hu bahul hedin wada keihhallaan idan helag Israel ni meippanggep ni i-appit da. Mahapul ni i-usal tun ingganah huyyan penget et hi-gak e Ap-Apu ey ebbuluten kun emin hu i-appit idan tuuk. ");
INSERT INTO ify_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ya kayyaggud ni luput hu pakugut yun mei-dah ni balwasin Aaron. Hanniman dama etan ni penget tu e mahapul ni ya kayyaggud ni luput hu pakugut yu. Pakugut kayun neiyayyaggud ni nebordaan ni meibalkeh di gitang tu. ");
INSERT INTO ify_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ey pakugut kayun mei-dah ni balwasi damaddan u-ungngan Aaron, ya mei-ewwakeh di gitang da, et ya penget da ma-lat kayyaggud ang-ang da ey melispituh idad ngunu da. ");
INSERT INTO ify_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pebalwasim nan hi agim e hi Aaron humman ni nekugut ni balwasi tu, ey pebalwasim ida daman u-ungnga tu hu nekugut ni balwasi da, ey duyagim hu ulu dan lanan olibah, et keang-angan tu e nepiliddan mampeddin mansilbin hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ey pakugut kayu mewan ni andukkey ni mandallem ni balwasi da e meippalpud gitang da ingganah di ulpu da. ");
INSERT INTO ify_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Mahapul ni i-usal nan Aaron et yadda u-ungnga tudda huyyan heggeppan dad Tabernacle et yan lawwan dad altar di Nesantuh ni Kuwaltuh ni da pengippahdingan ni ngunu da. Hedin hanniman hu pehding da, man eleg ida mebehhuli et eleg ida mettey. Huyyan olden kun u-unnuden Aaron et yadda helag tun manhuluhulul ni mampeddi ey mannananeng ni ingganah.” ");
INSERT INTO ify_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kan Apu Dios nan Moses ey “Heninnuy hu pehding mun mengi-eng-eng nan Aaron et yadda u-ungnga tun mampeddi et mansilbiddan hi-gak. Ala kan kilaw ni lakkitun baka et ya dewwan lakkitun kalneroh ni endi dipektoh da, ");
INSERT INTO ify_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ey pengapya kan sinapay e usal mu kekakkayyaggudan ni alinah ey entan tu kamdugin kapampelbag. Pengapya kayu pay ni meingpih ni sinapay ey mekayya-meh edum e naha-dan ni mansikan olibah. ");
INSERT INTO ify_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Iha-ad mudda huyyad agyag et iappit mun hi-gak di heggeppan di Tabernacle e mei-unnud etan di kilaw ni lakkitun baka et ya dewwan lakkitun kalneroh. ");
INSERT INTO ify_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ipahding mu huyyan elaw ni mengi-eng-eng nan Aaron et yadda u-ungnga tud heggeppan di Tabernacle ey ulahim ida e u-unnud mu elaw ni panlinnih. ");
INSERT INTO ify_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Pebalwasim nan Aaron etan mei-dah ni balwasi tu, ya etan nebordaan ni mei-dah di ephod, ya ephod niya etan luput ni meittekkap di pagew ni ephod et ya etan meibalkeh. ");
INSERT INTO ify_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ey ipapnget mun hi-gatu etan penget ni netakapan ni balituk ni medal, ");
INSERT INTO ify_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ey duyagim hu ulu tun lanan olibah et keang-angan tu e neputuk hi-gatun mampeddi. ");
INSERT INTO ify_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hedin negibbuh ni in-eng-eng mu hi Aaron ey ieng-eng mudda dama u-ungnga tu e pebalwasim ida etan mei-dah ni balwasi da. ");
INSERT INTO ify_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ey pebalkeh mun hi-gada etan ida neabel ni balkeh ey papnget mun hi-gada hu penget da. Henin nunya ipahding mun mengi-eng-eng nan Aaron et yadda u-ungnga tun lalakki et hi-gada mampadin ingganah. ");
INSERT INTO ify_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","I-lim hu lakkitun bakad hinanggan Tabernacle et ita-pew nan Aaron niyadda u-ungnga tu hu ngamay dad ulun nunman ni baka ");
INSERT INTO ify_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ey keleng mud kad-an kud heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ala kan kuheyaw tu et itdek mu ngamay mu et ha-adam ida etan heni ha-duk ni altar, ey iduyag mu hu edum ni kuheyaw di hengeg nunman ni altar. ");
INSERT INTO ify_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ekal mun emin hu taban neikuyeput di egeh niya etan ni altey, et ya etan dewwan basin niyadda neikuyeput ni taba et giheben muddad altar. ");
INSERT INTO ify_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ya natdaan ni parteh ni baka e humman ida hu belat, yadda laman, et yadda kinan tu ey gihheben mun emin di a-allaw ni kampu hu kamei-appit tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","16","Ey alam hu hakey etan ni lakkitun kalneroh et itta-pew nan Aaron niyadda u-ungnga tu ngamay dad ulu tu. Keklengen mu et tayaen mu hu kuheyaw tu et iwwakgih mud dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tegteg mu humman ni kalneroh ey ulahim hu egeh tu et ya heli tu et ita-pew mu etan di ulu tu et yadda edum ni parteh ni annel tu, ");
INSERT INTO ify_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","et giheben mud altar. Ya hamuy nunyan kagihheban kamei-appit ey peamleng tuwak. ");
INSERT INTO ify_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Alam mewan etan meikkadwan kalneroh et ita-pew nan Aaron niyadda u-ungnga tu hu ngamay dad ulu tu ");
INSERT INTO ify_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","et kelengen mu. Tayam hu kuheyaw tu et ha-adim hu wannan ni tangilan Aaron et yadda u-ungnga tu. Ha-adim daman kuheyaw hu wannan ni am-ama-an ni ngamay da et ya heli da, ey iwakgih mu hu metdaan ni kuheyaw di dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ala ka mewan ni kuheyaw et kamdugam ni lanan olibah, et wakgihan mu Aaron et yadda u-ungnga tu anin ni ya balwasi da, ma-lat mei-eng-eng ida niyadda balwasi dan hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ey alam emin hu taban etan ni lakkitun kalneroh ni keklengem, anin taban neikuyeput di egeh niya etan ni altey, et ya etan dewwan basin niyadda neikuyeput ni taba, ya taban ikul tu et ya wannan ni ulpu tu. Huyyan lakkitun kalneroh ni keklengem ey mei-appit di pampeddian nan Aaron et yadda u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ala kaddan sinapay ni eleg meha-adan ni kamampelbag ni neiappit ni hi-gak ni neiha-ad di kad-an ku. Ala kan hakey ni sinapay ni neha-adan ni mansikan olibah, ya hakey ni eleg, niya hakey ni meingpih ni sinapay. ");
INSERT INTO ify_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Petnged muddan Aaron et yadda lalakkin u-ungnga tu et ita-gey dan impeang-ang ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Alam ida et giheben mud altar, anin etan ni kalneroh. Ya hamuy idan nunman ni kamei-appit ey kamengippeamleng ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ya etan pagew ni kinleng mun kalneroh ey ita-gey mu et ipeang-ang mun mei-appit ni hi-gak. Hedin negibbuh ni in-appit mu ey inlam tep humman hu patal mu. ");
INSERT INTO ify_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Appil mu hu pagew et ya ulpun etan ni kalneroh ni impeang-ang mun mei-appit ni pampeddian Aaron et yadda u-ungnga tu et idwat mun hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Et yan edum ni aggew ey hedin man-appit ida helag Israel ni pekiddagyuman winu pampesalamatan dan hi-gak e Ap-Apu, ey meidwat ni ingganah humman ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Hedin mettey hi Aaron ey meippebeltan ida neieng-eng ni balwasi tud hakey idan u-ungnga tun puttuken yun meihhullul ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ey humman ni meihhullul ni eta-gey ni padi ey ibbalwasi tudda huyyan pitun aggew ni kei-eng-engan tu et han tu ilepun mansilbid Tabernacle et yad Nesantuh ni Kuwaltuh ku. ");
INSERT INTO ify_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ya etan pagew et ya ulpun kalneroh ey iheeng mud nengilinan ni lugal. ");
INSERT INTO ify_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kennen Aaron niyadda u-ungnga tudda humman anin ya etan sinapay ni neiha-ad di basket di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Hi-gadan ebuh ni padi hu dammutun mengngan idan nunman ni mei-appit ni ke-kalan ni liwat da. Eleg mabalin ni kennen ni kumpulmih ni tuu ida humman, tep neieng-eng ida humman ni detag. ");
INSERT INTO ify_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ey hedin wada sindaan dan nunman ni detag winu sinapay ni kewa-waan tu, ey mahapul ni gihheben mu. Eleg mabalin ni kennen ida humman tep neieng-eng. ");
INSERT INTO ify_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Henin nunman hu pehding yun mengippahding nunman ni elaw ni pampeddian nan Aaron et yadda u-ungnga tu. Ipahding yudda huyyan pitun aggew. ");
INSERT INTO ify_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kewa-wa-wa ey keleng yu hu hakey ni kilaw ni lakkitun baka et meiappit ni ke-kalan ni liwat. Ey pan-appit kayun pengippahdingan yun elaw ni panlinnih ni altar, ey duyagi yun lanan olibah et maibilang ni malinih niya mei-eng-eng. ");
INSERT INTO ify_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pitun aggew hu pengippahdingan yuddan nunya. Hedin negibbuh ey neieng-eng law ni pan-appitan humman ni altar, et emin hu meittummuk diman ey mei-eng-eng nan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Kan Apu Dios nan Moses ey “Ya i-appit yun kewa-wa-wa ey ya dewwan hantoon ni kalneroh ");
INSERT INTO ify_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","e hakey ni kakkabbuhhan niya hakey ni mahmahdem. ");
INSERT INTO ify_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ya etan i-appit yun kakkabbuhhan ni hakey ni kalneroh ey unnudi yun umlaw di hakey ni kiloh ni alinah ni nekamdugan ni hambusih ni mansika. Ey iappit kayun hambusih ni meinnum. ");
INSERT INTO ify_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Et ya etan i-appit yun mahmahdem ni hakey ni kalneroh ey unnudi yu daman nan-ingngeh kedakkel tun alinah, ya mansikan olibah niya meinnum. Huyyaddan kamei-appit ey megihheb ida et hi-gak e Dios ey um-amlengngak ni hamuy da. ");
INSERT INTO ify_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Meippalpun nunya ey man-appit kayun tutu-uk ni kewa-wa-wa, anin idallin helag yun edum ni aggew di heggeppan di Tabernacle e kad-an ku, ma-lat makihummangannak ni hi-gayudman. ");
INSERT INTO ify_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mekiddammu-ak idan tutu-uk diman di Tabernacle, tep neieng-eng humman ni hi-gak tep wada-ak diman. ");
INSERT INTO ify_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Em, mei-eng-eng ni hi-gak etan Tabernacle niya altar, anin hi Aaron niyadda u-ungnga tu et mansilbiddan hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mekihha-addak idan helag Israel e tutu-uk et hi-gak hu Dios da. ");
INSERT INTO ify_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ey amtaen da e hi-gak hu Ap-Apu e Dios dan nengipa-kal ni hi-gadad Egypt. Em, mekihha-addak ni hi-gada tep hi-gak dedan hu Ap-Apu e Dios da.” ");
INSERT INTO ify_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Kan mewan Apu Dios nan Moses ey “Ala kayun keyew ni akasyah et mengapya kayun altar ni pengiggihheban ni bangbanglun insensoh ni i-appit yun hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kuwadladuh huyya e ya kadinukkey tu et ya kalinakkeb tu, ey hampulut walun pulgada ey tellun piyeh kasina-gey tu. Ikapya yu hu umdewdew ni heni ha-duk di ta-pew idan epat ni dugu tu e meihakkey hu kapkapya tu etan di altar. ");
INSERT INTO ify_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Takapi yu huyyan altar ni balituk, ya ta-pew tu, yadda etan dimmewdew ni heni ha-duk, ya nanlinikweh ni gilig tu. ");
INSERT INTO ify_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ikapya yu hu dewwan netullikeng ni balituk di daul ni gilig tun pengidduddukan etan ni dewwan pan-attang. ");
INSERT INTO ify_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Pengapya kayun dewwan akasyah ni pan-attang e netakapan ni balituk. ");
INSERT INTO ify_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Iha-ad mudda huyyad ba-hil ni kuwaltuh ni keihha-adan etan ni Kaban ni neiha-adan idan neitudekan ni Tugun ku. ");
INSERT INTO ify_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ey yan kekakkabbuhhan ni an pengippaptekan nan Aaron idan kengkeh, niya pengihheban tun bangbanglun insensoh di altar. ");
INSERT INTO ify_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Hanniman ni hileng ni tu pengintegan idan kengkeh e umgiheb ni bangbanglun insensoh. Mahapul ni pehding tun ingganah huyya anin idan helag yullin edum ni aggew. ");
INSERT INTO ify_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Entan tu iappit di altar hu eleg meibbillang ni malinih ni bangbanglun insensoh winu kumpulmih ni kagihheban kamei-appit henin pagey niya meinnum. ");
INSERT INTO ify_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ippahding Aaron hu elaw ni panlinnih nunyan altar ni pinhakkey ni hantoon e ha-adan tuddan kuheyaw ni animal ni kamei-appit tep ya liwat ni tutu-u etan epat ni dugu tun heni ha-duk. Mahapul ni pehding yun ingganah huyya tep mei-eng-eng huyyan altar ni hi-gak e Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Hedin billangen mudda edum mun helag Israel ey mahapul ni ya hanhakkey ni hi-gada ey wada ibbayad dan hi-gak ni pihhuh ni wa-hin annel dan nunman ni kebillangan da ma-lat endi um-alin ligat ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ya ibbayad ni hakey ni tuu ey meippuun di kameunnud ni olden meippanggep ni Tabernacle. Humman ni pihhuh ey i-appit dan hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Mekibbilang ida dewampulu winu nehuluk hu toon tu. ");
INSERT INTO ify_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Huyyan bayad ni annel yun iddawat yun hi-gak ey man-iingngeh, kedangyan winu newetwet. ");
INSERT INTO ify_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Dawat mudda huyyan ibbayad idan edum mun helag Israel, et ussalen mun mengippaptek ni Tabernacle. Huyyan ibbayad da ey heni wa-hin biyag da ey mengippenemnem ni hi-gak et ipaptek kudda.” ");
INSERT INTO ify_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Pengapya kayun giniling ni besen niya giniling ni pengippettukan tu. Iha-ad yu huyyad nambattanan ni Tabernacle et ya altar. Ha-adim ni danum ");
INSERT INTO ify_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","21","et pan-ulahan nan Aaron niyadda u-ungnga tun ngamay da niya heli da, et han ida lumaw di Tabernacle di kad-an ku, niya hedin da gihheben hu kamei-appit di altar. Mahapul ni u-unnuden da huyya ma-lat eleg ida matey. Huyyan olden ey mahapul ni u-unnuden idan helag Israel ni ingganah.” ");
INSERT INTO ify_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ala kan kekakkayyaggud ni bangbanglu: Ya mir e umlaw di enem ni kiloh, ya tellun kiloh ni cinnamon, ya tellun kiloh ni unah, ");
INSERT INTO ify_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ya enem et kagedwah ni kiloh ni cassia et ya hanggalon ni lanan olibah, ");
INSERT INTO ify_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","et pangkakamdug mudda et mengapya kan lanan neieng-eng ni ussalen ni padi. ");
INSERT INTO ify_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Usal mu huyyan pengi-eng-engan mun Tabernacle, ya Kaban Apu Dios, ");
INSERT INTO ify_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ya tebol, yadda ngunut diman, ya etan pengippettukan ni kengkeh, yadda ngunut ni meussal diman, niya etan altar ni pengiggihheban ni bangbanglu. ");
INSERT INTO ify_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Hanniman daman altar ni pengiggihheban ni kamei-appit, yadda ngunut diman, ya etan besen et ya etan pengippettukan tu. ");
INSERT INTO ify_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Duyagim ni lana ida huyya et mei-eng-eng idan hi-gak. Ey emin ida meittummuk idan nunya ey mei-eng-eng idan hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Duyagim ni nunyan lana hu ulun Aaron niyadda ulun u-ungnga tun pampeddian da et mansilbiddan hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ehel muddan edum mun helag Israel e itultuluy dan mengapyan nunman ni lana et usalen yun ingganah ni pandeyyawan yun hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Eleg mabalin ni mu idduyag di ulun kumpulmih ni tuu ey eleg mabalin ni mu iu-unnud et kumapya kan ussalen mud hipan pinhed mun pengi-ussalan. Tep huyya ey neieng-eng di pinhed kun kei-ussalan tu e beken di nalgem hu pengi-ussalan mu. ");
INSERT INTO ify_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ya etan tuun mengi-unnud ni mengapyan henin nunya winu mengidduyyag di kumpulmih ni tuu e beken ni padi ey eggak law ibbilang ni tuuk.” ");
INSERT INTO ify_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kan Apu Dios nan Moses ey “Ala kan bangbanglun henin resin, ya mollusk, ya galbanum niya nemahmah ni frankincense e man-iingngeh kedakkel da, ");
INSERT INTO ify_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","et mengapya kan bangbanglun insensoh. Edumim ni ahin ma-lat memahmah, ey beken ni nalgem pengi-ussalan yu. ");
INSERT INTO ify_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Giling mu edum idan nunman et mapinu ey inha-ad mud Tabernacle di hinanggan Kaban kun neiha-adan ni nekitbalan ku. Yadman nakka pekiddammuin hi-gam. Huyyan bangbanglun insensoh ey neieng-eng ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Beken ni neala ey ka nengapya et usalem di pinhed mun pengi-ussalan. ");
INSERT INTO ify_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ya etan tuun mengapyan henin nunya et usalen tud pinhed tun pengi-usalan ey eggak law ibbilang ni tuuk.” ");
INSERT INTO ify_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Pinilik hu hakey ni helag Judah e hi Besalel e u-ungngan Uri e u-ungngan Hur. ");
INSERT INTO ify_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Winedak ni hi-gatu hu Ispirituh ku et maweda laing tun mengapyan hipan neal-alkusan. ");
INSERT INTO ify_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Nelaing ni mengapyan kakkayyaggud ni ngunut e ya balituk, ya silber niya giniling hu tuka ussalan pan-alkus tu, ");
INSERT INTO ify_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","anin idan mealkusan ni nenginan batu. Nelaing pay ni man-e-dih ey mampaot ni hipan usal ni kayyaggud ang-ang tu. ");
INSERT INTO ify_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Pinilik dama hi Oholiab e u-ungngan Ahishamak e helag Dan ni umbaddang ni hi-gatu. Wadadda pay edum ni pinilik et wadaen kun hi-gada hu et-eteng ni kabaelan dan mengippahding idan nunyan inhel kun pekapyam: ");
INSERT INTO ify_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ya Tabernacle, ya etan Kaban kun neiha-adan ni nekitbalan ku, ya hu-keb tu, niya hipan ngunut ni mahapul di Tabernacle ");
INSERT INTO ify_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","henin tebol, yadda ngunut diman, ya etan balituk ni pengippettukan ni kengkeh et yadda meussal diman, ");
INSERT INTO ify_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ya altar ni pan-appitan yun keklengen yu, yadda emin ni ngunut ni meussal diman, ya etan besen ni pan-ullahan niya pengippettukan tu. ");
INSERT INTO ify_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Hi-gada pay hu menguggut idan balwasin padin ussalen nan Aaron niyadda u-ungnga tun pampeddian da. ");
INSERT INTO ify_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ey hi-gada hu mengapyan lana niya bangbanglun insensoh ni meussal di Nesantuh ni Kuwaltuh. Hedin kapyaen dadda huyya ey mahapul ni paka-u-unnuden da hu inhel kun hi-gam ni pengapya yu.” ");
INSERT INTO ify_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ehel muddan edum mun helag Israel et eleg ida mangngunnun Sabaduh tep humman penginemnemneman yun ingganah ni nekitbalan kun hi-gayu, et hi-gak e Ap-Apu yu ey impambalin dakeyun tuuk. ");
INSERT INTO ify_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Em, endi mangngunnun nunman ni aggew tep kamengillin humman ni aggew. Hedin wada manghay et mangngunnun nunman ni aggew, mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Tep wada enem ni aggew ni pengingunnuan yun emin ni ngunu yu, nem yan meikkeppitun aggew e Sabaduh e pan-iyatuan yu ey nakka ngillina. Et humman hu, hedin wada kahing et mangngunnun nunman ni aggew, mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Hi-gayuddan helag Israel ey mahapul ni ngillinen yu huyyan aggew ni ingganah et penginemneman yun etan ni nekitbalan kun hi-gayun ingganah. ");
INSERT INTO ify_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Huyya penginemneman yun hi-gak ni ingganah tep hi-gak ni Ap-Apu yu ey enem ni aggew hu nanletuan kun kabunyan niya puyek et yan kapitun aggew ey nan-iyyatu-ak.” ");
INSERT INTO ify_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ginibbuh Apu Dios ni inhel ida huyyan nan Moses, et idwat tu etan dewwan batun neitudkan ni Tugun tu. ");
INSERT INTO ify_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nebayag hi Moses di duntug et maemung ida edum tun helag Israel di kad-an Aaron et kandan hi-gatuy “Pengapya ka ew ni dios tayun mengippengngulun hi-gatsu tep hi Moses e nengipengulun hi-gatsun neni-yan ni Egypt ey endin kaum-ali. Eleg tayu amta hu nekapyan hi-gatu etan di linawwan tu.” ");
INSERT INTO ify_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Et kan Aaron ni hi-gaday “Hedin hannitan, pan-i-li yudda hu balituk ni betling idan ahwa yu niya u-ungnga yu.” ");
INSERT INTO ify_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Et pan-ekalen da hu betling da et idwat dan Aaron. ");
INSERT INTO ify_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ineyug Aaron ida humman et mengapyan balituk ni baka. Inang-ang da humman ey kanday “Hi-gatsun helag Israel, huyya hu dios tayun nengipengulun hi-gatsun neni-yanan tayun Egypt.” ");
INSERT INTO ify_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Dingngel Aaron humman ey nengapyan pan-appitan di etan ni balituk ni baka et kantun hi-gada ey “Yan kabbuhhan ey mampiyestah itsu et dayawen tayu eya Ap-Apu tayu.” ");
INSERT INTO ify_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Yan kakkabbuhhan ni newa-waan tu ey himmaleman ida etan tuu e nan-ilaw da hu animal dan gihheben dan i-appit da niyadda animal ni i-appit dan pekiddagyuman dan Apu Dios. Et manhahamul ida etan tuu et manginum ida ey nenattayyaw idan penaydayaw da etan ni kinapya dan bakan dios da. ");
INSERT INTO ify_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Entanni ey kan Apu Dios nan hi Moses ey “Papuut mu et mandayyu ka tep dingkug da-ak idan tuun impangulum ni neni-yan ni Egypt et deh e daka kapkapyaa lawah. ");
INSERT INTO ify_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kinehing dan emin hu tugun kun hi-gada et deh, nengapya idan balituk ni bakan daka daydayawa et i-appitan da. Kanday humman hu dios dan nengipengulun hi-gadan neni-yan ni Egypt. ");
INSERT INTO ify_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nemahhig hu ngehay da. ");
INSERT INTO ify_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Entan tudda idleppi tep petteyen kudda gapuh ni bunget ku. Et hi-gam ni ebuh e Moses hu metdaan ni mehlag ni dakel.” ");
INSERT INTO ify_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nem nampehemmehemmek hi Moses nan Ap-Apu e Dios tu e kantuy “Apu Dios, entan ahan tu pamehig hu bunget idan eyan tuum e himmek mu, et pa-kal muddad Egypt ni nengipeang-angan mun et-eteng ni kabaelam. ");
INSERT INTO ify_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Hedin pehding mu etan kammu e endien mudda, penghel nguddan iEgypt e ya gaputun nengipenguluan mudda, ey ma-lat pateyen mudda et endi metdaan ni hi-gada. Entan ahan bunget. Anusim ida et eleg mudda pateyen. ");
INSERT INTO ify_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nemnem mu e inhel mudda lan bega-en mu e hi Abraham, hi Isaac et hi Jacob e kammun hi-gaday pedakkel mu helag da, et heniddan bittuwen di kabunyan e eleg mebillang. Ey nemnem mu e kammuy ya helag da hu pengidwatan mun etan ni bebley ni kammun panha-adan dan ingganah.” ");
INSERT INTO ify_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Dingngel Apu Dios et eleg tudda pateyen. ");
INSERT INTO ify_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nandayyud Moses di kad-an idan edum da e inla tu etan dewwan batun netudekan di nambina-hil ni Tugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kinapyan Apu Dios ida humman ni batu et itudek tuddadman hu Tugun tu. ");
INSERT INTO ify_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kamenetteng di Moses nan Joshua ey dingngel Joshua hu ngaladdan tuu et kantun Moses ey “Kele henidda kamanggugubat di nangkampuan tayu?” ");
INSERT INTO ify_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ey kan Moses ey “Ya met hu nakka pengngel ey beken ni ngalan kamenga-apput winu palak ni kamangkeapput, nem henidda kaman-a-appeh.” ");
INSERT INTO ify_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Yan kamangkeihnup di Moses di kampu da etan di hengeg ni duntug, ey inang-ang tu etan balituk ni bakan kinapya da e daka itattayyawi, ey nemahhig hu bunget tu et itengba tu etan dewwan batun singnged tu et mepeni-ang ida. ");
INSERT INTO ify_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Inla tu etan balituk ni bakan kinapya da et ayugen tu. Entanni et pambalin tun heni dep-ul et ikamdug tud danum et painum tun hi-gada. ");
INSERT INTO ify_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kantun Aaron ey “Hipa impahding ida eyan tuun hi-gam et mu in-abulut ni da pehding huyyan nemahhig ni liwat?” ");
INSERT INTO ify_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ey kan Aaron ey “Entan bunget ni hi-gak tep inamtam e ya lawah hu pinhed dan peteg ni ippahding. ");
INSERT INTO ify_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kandan hi-gak ey ‘Pengapya ka kuman dios tayun mengippengngulun hi-gatsu tep hi Moses e nengipengulun hi-gatsu et hi-yanen tayu Egypt ey endin kaum-ali. Eleg tayu amta hu neipahding ni hi-gatu etan di linawwan tu.’ ");
INSERT INTO ify_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Et ehlen ku law ni hi-gadan pan-i-ali dan hi-gak hu balituk ni betling da et pan-ibkah kud apuy ey neukat ali eya balituk ni baka!” ");
INSERT INTO ify_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nem inamtan Moses e in-abulut Aaron ida etan tuun mengippahding ni nunman ni pinhed da, et gapun nunman ey kangi-ngi-ngiiddan buhul da. ");
INSERT INTO ify_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Et an umehneng hi Moses di heggeppan di kampu et itkuk tu e kantuy “Hi-gayuddan neminhed ni menaydayaw nan Apu Dios ey keappil kayud dih.” Ey ebuh ida helag Levi ni limmaw di kad-an tu. ");
INSERT INTO ify_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Et kantun hi-gaday “Kan Apu Dios e kadaydayawan ammed tayu la e hi Israel ey, yu ala pingway yu et pampateyen yudda eya edum yu e ipalpu yud dih ingganah di ba-hil. Pampatey yu anin agi yu, gagayyum yu winu sinakdul yu.” ");
INSERT INTO ify_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Inu-unnud da huyyan inhel Moses et pampateyen dadda ey tellun libu hu pintey dan nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Entanni ey kan Moses idan nunman ni helag Levi ey “Yan nunyan aggew ey meappil kayu et eleg kayu meika-dum di edum yun helag Israel, tep nambalin kayun padin mansilbin Apu Dios, tep inu-unnud yu inhel tun pehding yu et anin ni agi yu niya u-ungnga yu ey impakipetey yu. Et gapun nunman ey bendisyonan dakeyun Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Newa-wan nunman et kan Moses ida etan ni tuuy “Nemahhig ni liwat humman ni impahding yu. Nem mantetyeddak mewan di duntug di kad-an Apu Dios, et nak makihummangan ni hi-gatu hedin mabalin anhan ni pesinsahan dakeyu.” ");
INSERT INTO ify_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Et maibangngad mewan hi Moses di kad-an Apu Dios et kantun hi-gatuy “Eteng hu nanliwatan idan nunman ni tuu tep nengapyaddan balituk ni baka, et kanday humman hu dios dan deyyawen da. ");
INSERT INTO ify_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nem anin anhan ni hanniman ey hemek mudda et pesinsahan mu humman ni impahding da. Tep hedin eleg mu pesinsahidda, ekal mu ew hu ngadan kud nengilistaam ni ngadan idan tuum.” ");
INSERT INTO ify_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nem kan Apu Dios ey “Eleg mabalin. Ebuh ida etan nanliwat ni hi-gak ni e-kalen ku ngadan da. ");
INSERT INTO ify_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lakkay kuma et ipengulum ida et lumaw kayu etan di bebley ni inhel kun nunman ni lawwan yu, yaggud wada hu anghel kun mengippaptek ni hi-gayu. Nem kastiguen kuddalli huttan ni tuu gapuh ni nunman ni impahding da.” ");
INSERT INTO ify_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Entanni ey impaeli tu-wangun Apu Dios hu degeh idan nunman ni tuu gapuh ni nunman ni impahding da e impilit dan Aaron ni mengapyan balituk ni baka et dayawen da. ");
INSERT INTO ify_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kan mewan Apu Dios nan Moses ey “Hi-gam niyadda edum mun helag Israel ni impangulum ni nalpud Egypt, hi-yan yu Sinai et lumaw kayu etan di bebley ni insapatah kun Abraham, hi Isaac et hi Jacob ni pebeltan kun helag da. ");
INSERT INTO ify_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Um-itu-dakkak ni anghel ni mengipappangngulun hi-gayu et degyunen tudda Kanaanite, yadda Amorite, yadda Hittite, yadda Perisite, yadda Hibite et yadda Jebusite ni nambebley diman et hi-gayu maihullul. ");
INSERT INTO ify_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Wadan emin hu mahapul yudman ni bebley e kamehawwahawwal hu gatas niya danum ni putsukan. Nem eggak mekillaw ni hi-gayu tep manghay kayu. Entanni kumedek ey pebungnget yuwak et pampetteyen dakeyud dalan.” ");
INSERT INTO ify_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Dingngel da huyyan inhel Apu Dios ey ida kaumlelemyung e eleg da pinhed ni ussalen hu gamgam da. ");
INSERT INTO ify_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Tep kan Apu Dios nan Moses ey “Ehel mun hi-gada e kangkuy: Manghay kayu! Et humman hu, anin na-mun nekemtang hu pekillawwak ni hi-gayu et bahbahen dakeyu. Ekal yudda inusal yun gamgam yu henin betling niya balituk ni banggel et nemnemnemek hedin hipa pehding kun hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Et meippalpun eman ni neni-yanan dan nunman ni Duntug e Sinai, ey eleg ida law man-ussal idan gamgam da. ");
INSERT INTO ify_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kaikkapyan Moses hu tabernacle di a-allaw ni kampu da ma-lat hedin wada neminhed ni mekihhummangan nan Apu Dios ey kaumlaw diman. ");
INSERT INTO ify_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Hedin limmaw hi Moses diman tabernacle ey kaum-ehneng ida tutu-ud habyen ni kampu da et ang-ang-angen da hi Moses ingganah umhegep. ");
INSERT INTO ify_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ey ya etan heni tukud ni kulput ey kamelehbeng di heggeppan di tabernacle hedin himmegep hi Moses ni mekihhummangan nan Apu Dios e wada etan di kulput. ");
INSERT INTO ify_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Hedin inang-ang idan helag Israel huyyan kulput ni nelehbeng di heggeppan ni tabernacle, ey um-ehneng idad heggeppan ni kampu da et manyuung ida. ");
INSERT INTO ify_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kamekihinnangga hi Apu Dios nan hi Moses ni mekihhummangan e henin kapanhummanganin dewwan tuun hanggayyum. Hedin negibbuh idan nanhummangan, nambangngad hi Moses di kampu da, nem hi Joshua e nehiken ni u-ungngan Nun ni kaumbabbaddang ni hi-gatud tabernacle ey wadan neyun diman. ");
INSERT INTO ify_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kan Moses nan Apu Dios ey “Kammuy ippanguluk ida huyyan tutu-u et lumaw kamid bebley ni kammun lawwan mi, nem eleg mu ehelen hedin hipadda mekillaw ni hi-gak. Kammu mewan ey neka-amta muwak ey kamengippeamleng ni hi-gam hu nakka pehpehding. ");
INSERT INTO ify_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Hedin makulug, peamtam tep anhan ni hi-gak ni emin hu planuh mu et amtaen ku niya ma-lat ipahding ku hu pinhed mu. Ey nemnem mu anhan e pinilim ida huyyan tuum.” ");
INSERT INTO ify_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ey kan Apu Dios nan Moses ey “Hi-gak mismuh hu mekillaw ni hi-gam ma-lat luminggep ka, ey ma-lat kayyaggud ni emin hu meippahding ni hi-gam.” ");
INSERT INTO ify_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kan Moses ey “Mukun humman hu kangku ey tep hedin eleg ka mekillaw ni hi-gami ey heballi di deya kami, eleg kami meglid. ");
INSERT INTO ify_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ey inna-nun edum ni tutu-un mengamta e pinpinhed mudda eya tutu-um ey pinpinhed muwak, hedin eleg ka mekillaw ni hi-gami? Tep hedin mekillaw kan hi-gami ey humman keang-angan tu e hin-appil kamiddan edum ni tuu eyad puyek.” ");
INSERT INTO ify_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ey kan Apu Dios nan Moses ey “Nakka ebbuluta huttan ni imbagam tep nakka man-am-amleng ni muka pehpehding ey kayyaggud muka pekiddagyumin hi-gak.” ");
INSERT INTO ify_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Entanni ey wada mewan hakey ni imbagan Moses nan Apu Dios. Kantuy “Attu anhan et peang-ang mun hi-gak hu dayaw mu?” ");
INSERT INTO ify_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Hinumang Apu Dios e kantuy “Peang-ang kun hi-gam hu kakinayyaggud ku ey peamtak ni hi-gam e hi-gak hu Ap-Apu. Ey peang-ang ku pay hu binabbal niya hemek kuddan tuun pinhed ku. ");
INSERT INTO ify_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nem eleg mabalin ni ang-angen mu angah ku, tep mettey hu tuun menang-ang ni angah ku. ");
INSERT INTO ify_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ehneng ka eyad batun takdul ku. ");
INSERT INTO ify_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ihha-ad daka ni eyad dehak ni batu et hanian dakan ngamay ku ingganah melebbahhak, ");
INSERT INTO ify_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","et hannak ekala ngamay ku et ang-angen mun ebuh beneg ku, nem eleg mu ang-anga angah ku.” ");
INSERT INTO ify_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kan Apu Dios nan Moses ey “Pahek kan dewwan batun heni eman lan nemangulu, et ipidwak ni ittudek etan intudek ku la etan idad nemangulun batun binahbah mu. ");
INSERT INTO ify_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Et yan kakkabbuhhan ni kabbuhhan ey panteyed kalli mewan eyad Duntug e Sinai et mandammu itad tuktuk tu. ");
INSERT INTO ify_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Endi an meki-lin hi-gam ey endidda an mandaladalan di hengeg nunyan duntug anin idan kalneroh winu baka.” ");
INSERT INTO ify_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Inu-unnud Moses et pumehek ni dewwan batu et humelaman ni limmaw etan di tuktuk ni Duntug e Sinai e intabin tudda humman ni dewwan batu. ");
INSERT INTO ify_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Limmehbeng etan kulput ni kad-an Apu Dios ey immen hi Moses e immehneng. Et ehelen tun Moses e ya ngadan tu ey Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nelabah hi Apu Dios di hinanggan Moses et kantun hi-gatuy “Hi-gak ni Ap-Apu e Dios ni kabbabbal ni peteg. Beken nak ni kabbubunget. Ey eleg melumman hu impeminhed kuddan tuu, ey nakka ippahding ni emin hu inhel ku. ");
INSERT INTO ify_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Pannananeng ku impeminhed kuddan manhahayned ni helag yu, ey pessinsahan ku emin liwat da anin idan etan nangngehay ni hi-gak. Nem eggak hehmeka, et kastiguen kuddalli u-ungnga da, yadda inap-apu da niyadda inap-apuddan inap-apu da.” ");
INSERT INTO ify_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ey nanlukbub hi Moses di puyek et dayawen tu Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Et kantun Apu Dios ey “Apu Dios, hedin makulug ni muka pan-amlengi eya nakka pehpehding, ibbagak anhan ni hi-gam e mekillaw kan hi-gami. Et anin ni nemahhig hu ngehay ida eyan tuu, pesinsahim anhan hu lawah ni impenahding mi ma-lat abuluten dakemin tuum.” ");
INSERT INTO ify_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hinumang Apu Dios hi Moses et kantuy “Ku em tep. Mekittebbalannak ni nunyan hi-gayuddan helag Israel. Emin kayu ey ang-angen yuddalli kamengippetngan pehding kun panyaggudan yun endi henin nunman ni neipahding di edum ni bebley eyad puyek. Hi-gak e Ap-Apu yu ey pehding kuddalli humman et ang-angen alin emin ni tuu. ");
INSERT INTO ify_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mahapul ni u-unnuden yun helag Israel ida eya Tugun ni e-helen kun nunyan hi-gam. Ey e-helen kun hi-gam e yallin ngannganih dettengan yud bebley ni inhel kun lawwan yu, ey degyunen kudda nambebley diman ni Amorite, Kanaanite, Hittite, Perisite, Hibite et ya Jebusite. ");
INSERT INTO ify_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ang-ang yu et eleg kayu makidagyum idan nambebley di lawwan yu tep mambalin idan heni bitun keknaan yu. ");
INSERT INTO ify_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pambahbah yu kumadda etan daka pan-appisi, anin idan batun neieng-eng ni dios da, et yadda tukud ni daka penginemnemnemin Asherah e biin dios da. ");
INSERT INTO ify_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Entan tu dayaw hu edum ni dios tep hi-gak e Ap-Apu ey eggak pinhed ni wada edum ni yu deyyawen ni dios e beken ni hi-gak ni ebuh. ");
INSERT INTO ify_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Entan nisi pekidagyum yuddan tutu-un nambebley di lawwan yu heniddan etan ni daka pebeyyad annel da niyadda etan kaman-appit di beken ni makulug ni dios. Tep hedin mekiddagyum kayun hi-gada ey ewwisen dakeyun menaydayaw idan dios da, et lektattuy meewwis kayu. ");
INSERT INTO ify_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ey lektattuy nan-iahwaddan u-ungnga yun lalakki hu bibi-i da et hi-gada umhulun ni pengiwwallengan dan hi-gak et ya edum ni dios hu deyyawen da. ");
INSERT INTO ify_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Entan pengapyan dios yun deyyawen yu. ");
INSERT INTO ify_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Mahapul ni itultuluy yun pehding ni pitun aggew hu Piyestah ni Sinapay ni eleg meha-adan ni kapampelbag ni memengngulun bulan ni katootoon, tep yan nunman ni bulan hu neni-yanan yun Egypt. ");
INSERT INTO ify_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Emin hu nemangulun lalakkin impah ni animal yu henin baka yu niya kalneroh ey bagik ida. ");
INSERT INTO ify_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Dammutu mewan ni ihhullul yu hu impah ni kalneroh di nemangulun impah di kebayyu et humman mei-appit. Nem hedin eleg yu pinhed ni hullulan, ey hepung yu buklew nunman ni kebayyu. Ey ya pengulwan ni lakin u-ungnga yu ey mahapul ni beyyadan yu, et maibangngad idan hi-gayu. Mahapul ni emin kayu ey man-appit kayun hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Mahapul ni enem ni aggew ni ebuh pangngunnuan yun hanlingguan. Entan pangngunu yun meikkeppitun aggew anin ni ahigaud winu ahiani ma-lat man-iyyatu kayu. ");
INSERT INTO ify_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ey mahapul ni pehding yu hu Piyestah ni Ani hedin negibbuh hu ahiani. Ey ipahding yu hu Piyestah ni Kampu hedin nedateng ida lameh ni intanem yu. ");
INSERT INTO ify_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Niya mahapul ni yan hantoon ey mampitluddan um-alin emin hu lalakkin helag Israel ni mampresentah ni hi-gak e Ap-Apu e Dios dan helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Hedin u-unnuden yu huyya e mampitlu kayun um-alid kad-an ku, ey endi mengubbat ni hi-gayu niya endi memilliw ni bebley yu. Degyunen kudda hu nambebley di bebley ni lawwan yu ma-lat lumakkeb hu bebley yu. ");
INSERT INTO ify_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Entan tu iappit hu sinapay ni nekamdugan ni kapampelbag ni pan-appitan yun animal. Hedin man-appit kayun hi-gak ni impah ni kalneroh ni Piyestah ni Passover ey mahapul ni endi tetdaan yun detag ni nunman ni hileng. ");
INSERT INTO ify_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ey mahapul ni illaw yud baley ku e Ap-Apu e Dios hu kekakkayyaggudan idan nemangulun lameh ni intanem yu et meiappit ni hi-gak. Ey entan tu iheeng hu impah ni kalneroh winu gelding di gatas ni inetu.” ");
INSERT INTO ify_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kan mewan Apu Dios nan Moses ey “Itudek mun emin ida huttan ni inhel ku tep huttan ida pengippuunan kun pekitbalak ni hi-gam niyadda edum mun helag Israel.” ");
INSERT INTO ify_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nanha-ad hi Moses di Duntug e Sinai ni na-pat ni aggew ey na-pat ni hileng e impangkadwa tu hi Apu Dios. Yan nunman ni wadaddadman ey eleg mangamangan ey eleg uminuinum. Yan nunman ni tsimpuh hu nengitudekan tud dewwan nedampilag ni batun etan idan Hampulun Tugun nan Apu Dios e huyyadda neipuunan ni nekitbalan tu. ");
INSERT INTO ify_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Entanni ey dimmayyu hi Moses di Duntug e Sinai e singnged tudda etan dewwan nedampillag ni batun neitudekan ni Hampulun Tugun Apu Dios. Ey kaumhili angah tu tep nekihuhhummangan nan Apu Dios, nem eleg tu amta e kaumhili angah tu. ");
INSERT INTO ify_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Inang-ang nan Aaron et yadda tutu-u humman ni kaumhilin angah Moses ey ida kaumtakut ni meihnup ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nem ineyagan idan Moses aap-apu ma-lat manhuhummangan ida. ");
INSERT INTO ify_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Immalidda et ehelen Moses ni hi-gadan emin hu Tugun ni indawat Apu Dios ni hi-gatud Duntug e Sinai. ");
INSERT INTO ify_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Negibbuh ni immehel hi Moses et manhukyung et mahenian angah tu. ");
INSERT INTO ify_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Nem hedin himmegep di Tabernacle ni an mekihhummangan nan Apu Dios, ey tuka e-kala hukyung tu. Hedin immehep et e-helen tuddan tutu-u hu intugun Apu Dios ni hi-gada, ");
INSERT INTO ify_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ey kaang-angaddan tutu-u hu kaumhilin angah tu. Hedin mewan negibbuh ey kamanhukyung ingganah medettengan mewan hu pekihhummanganan tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Inemung Moses idan emin hu edum tun helag Israel et kantun hi-gaday “Mahapul ni u-unnuden yudda huyyan intugun Apu Dios! ");
INSERT INTO ify_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Yan hanlingguan ey enem ni aggew pangngunnuan yu. Ey yan meikkeppitun aggew e Sabaduh ey man-iyatu kayu tep humman ni aggew ey neieng-eng nan Apu Dios. Yadda eleg mengu-unnud et mangngunnuddan nunman ni aggew ey mettey ida. ");
INSERT INTO ify_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ey eleg mei-ebbulut ni kayu man-eppuy di baballey yun nunman ni aggew.” ");
INSERT INTO ify_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kan Moses idan tutu-uy “Kan Apu Dios ey: Pan-appit kayun hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Hedin man-appit kayu, huyyadda dammutun i-appit yu: ya balituk, ya silber niya giniling, ");
INSERT INTO ify_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ya sinayyum ni blue, ya purple niya makadlang, ya kayyaggud ni luput, ya edum ni luput ni nekapyad dutdut ni gelding, ");
INSERT INTO ify_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ya katat ni lakkitun kalneroh nambalin ni madlang, ya katat ni mategun wadad baybay, ya keyew ni akasyah, ");
INSERT INTO ify_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ya lanan olibah ni kameihha-ad di kengkeh, yadda mekapyan lanan kaihha-ad di ulu, ya bangbanglun insensoh, ");
INSERT INTO ify_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ya onyx, yadda edum ni nangkenginan batun meittekkap di ephod ni padi niya luput ni meittekkap di pagew tu. ");
INSERT INTO ify_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Hi-gayuddan nelaing ni mengippahding ni hipan ngunu, ali kayu et ingunu yudda huyyan pengunnun Apu Dios: ");
INSERT INTO ify_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ya Tabernacle, ya tuldah ni meihhephep, yadda meikkultinah, yadda kawit, yadda meibballabag, yadda tukud niyadda keittu-unan da, ");
INSERT INTO ify_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ya Kaban Apu Dios, yadda pan-attang, ya etan hu-keb tu, ya etan kultinah di bawang di Kuwaltuh Apu Dios, ");
INSERT INTO ify_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ya etan tebol, yadda pan-attang, yadda emin hu meussal etan di tebol, niya etan sinapay ni meihha-ad di Kuwaltuh Apu Dios, ");
INSERT INTO ify_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ya pengippettukan idan kengkeh niyadda etan meussal diman, yadda kengkeh ni meippettuk diman, ya etan lanan meihha-ad di kengkeh, ");
INSERT INTO ify_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ya altar ni pengiggihheban ni bangbanglun kamei-appit, yadda pan-attang, ya lanan kameihha-ad di ulu ya etan bangbanglun insensoh, ya etan kultinah di heggeppan di Tabernacle, ");
INSERT INTO ify_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ya etan altar ni pengiggihheban ni kamei-appit ni animal, ya etan nelaggan giniling ni pengitta-pewan ni kagihheban animal, yadda pan-attang, yadda ngunut ni kameussal di pan-appitan, ya etan et-eteng ni besen ni pan-ulahan niya etan pengippettukan nunman, ");
INSERT INTO ify_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","yadda meikkultinah di nanlinikweh di Tabernacle, yadda tukud niyadda pengittu-unan idan nunyan tukud, ya kultinah di heggeppan di dallin ni Tabernacle, ");
INSERT INTO ify_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","yadda paghek ni pengi-ikketan ni Tabernacle, ya dallin tu, yadda iket, ");
INSERT INTO ify_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","yadda balwasin padin ussalen dan pengippahdingan dan ngunu dad Kuwaltuh Apu Dios et yadda neieng-eng ni balwasin Aaron et yadda balwasin u-ungnga tu.” ");
INSERT INTO ify_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Entanni ey hini-yan idan emin ni tutu-u hi Moses diman ma-lat da pan-idaddan hu i-appit da. ");
INSERT INTO ify_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Et emin ida neminhed ni man-appit ey in-ali da i-appit dan Apu Dios ni mahapul ni mekapyad Tabernacle, yadda ngunut diman niyadda ibbalwasiddan padi. ");
INSERT INTO ify_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Yadda lalakki ey bibi-in neminhed ni um-idwat ni i-appit da ey nan-i-li da balituk ni betling, yadda singsing niyadda banggel. Emin hu klasih ni balituk ni tenged da ey in-appit dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","In-alin edum hu blue, purple niya makadlang ni luput, ya kakkayyaggud ni luput, ya dutdut ni gelding, ya katat ni lakkitun kalneroh ni nambalin di madlang niya kayyaggud ni katat. ");
INSERT INTO ify_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Yadda edum ey in-ali da giniling winu silber ey in-ali daman edum hu keyew ni akasyah ma-lat iappit da daman Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nan-i-li damaddan bibi-in nelaing ni memuddun ni kayyaggud ni sinayyum ni blue, ya purple, ya makadlang niya kayyaggud ni luput. ");
INSERT INTO ify_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Yadda bibi-in nelaing ni man-ebbel ey immi-liddan inebel dan dutdut ni gelding. ");
INSERT INTO ify_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","In-alidda daman aap-apun helag Israel hu onyx niyadda edum ni nenginan batun meittekkap di ephod niya etan di luput ni meittekkap di pagew ni ephod. ");
INSERT INTO ify_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","In-ali da pay hu pampebanglun kennen, ya lanan olibah ni meihha-ad di kengkeh, ya lanan meihha-ad di ulu niya bangbanglun insensoh. ");
INSERT INTO ify_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Emin ida helag Israel, yadda bibi-i niya lalakkin neminhed ni man-appit nan Apu Dios, ey in-ali dadda mahapul di pengngunnu tun hi-gadan in-olden tun Moses. ");
INSERT INTO ify_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kan Moses idan tutu-uy “Hi Apu Dios ey pinili tun iddawtan hu hakey ni helag Judah e hi Besalel e u-ungngan Uri e u-ungngan Hur ");
INSERT INTO ify_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ni kalinaing ni mengapyan hipan pekapya tu, ");
INSERT INTO ify_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","henin mamplennuh ni man-al-alkus niya mengapyan ngunut e ussalen tu balituk, silber winu giniling. ");
INSERT INTO ify_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Nelaing pay ni man-e-dih niya mampaot ni batu niya keyew, ey nelaing ni mengapyan kumpulmih ni kayyaggud ang-ang tu. ");
INSERT INTO ify_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ya pinilin Apu Dios ni pan-e-dum Besalel ey hi Oholiab e u-ungngan Ahishamak e helag Dan. Indawat Apu Dios hu kabaelan dan mengituttuddun inamta dad edum da. ");
INSERT INTO ify_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ey indawat nan Apu Dios hu laing dan mengapyan kakkayyaggud ni banggel, ya betling, ya singsing, ya nambakbaklang ni penguggut ni balwasi, ya pan-ebbel, ya pambordah ni blue, purple ey makadlang di kayyaggud ni luput. Indawat tu pay hu laing dan mamplennuh ni pengapya daddan nunman et kayyaggud ang-ang da.” ");
INSERT INTO ify_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Et humman hu, hi Besalel, hi Oholiab niyadda edum ni indawtan Apu Dios ni laing hu mengapyan Tabernacle meippuun di olden tu. ");
INSERT INTO ify_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Et paeyag nan Moses di Besalel nan Oholiab et ehelen tun illapu dan mangngunnu e hi-gadaddan edum tun indawtan Apu Dios ni laing ni mengingngunnun impangunu tu. ");
INSERT INTO ify_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Indawat Moses ni hi-gada humman idan in-aliddan tutu-un ussalen dan mengapyan Tabernacle. Kekakkabbuhhan ey kapan-i-aliddan tutu-u hu edum ni iddawat da, ");
INSERT INTO ify_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","et lektattuy limmaw ida huyyan kamangngunnud ");
INSERT INTO ify_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kad-an Moses et kandan hi-gatuy “Dakel kumamman ni peteg hu nei-lin meussal etan di pekapyan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Et mengapya hi Moses ni olden ni impalaw tuddan tutu-u. Kantuy “Isiked yu law ni um-i-lin i-appit yun meikkapyad Tabernacle tep nehawal kumamman indawat yu.” Et isiked ida law ni tutu-un um-i-lin meikkapya ");
INSERT INTO ify_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","tep nehawal kumamman in-ali dan meussal di pekapyan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Nengapyadda etan nelaing ni hampulun kultinah e inusal da kakkayyaggud ni luput et ya blue, purple niya makadlang ni sinayyum. Ey imborda dadda hu u-ukkul ni anghel. ");
INSERT INTO ify_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Emin ida huyyan kultinah ey nan-ingngeh ida e umlaw di na-pat et dewwan piyeh hu kadinukkey da niya enem ni piyeh hu kalinakkeb da. ");
INSERT INTO ify_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Nengapya hi Besalel ni dewwan melakkeb ni kultinah e impandadagsi tun kinugut hu lima idan nunyan kultinah et meikahhakey ida. Hanniman dama impahding tu etan ni liman kultinah. ");
INSERT INTO ify_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Sinullikeng tu hu sinayyum ni blue et ikugut tudda huyyad gilig idan nunman ni dewwan nanggillig ni kultinah. ");
INSERT INTO ify_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Hannenelima hu ingkugut tun netullikeng di gilig idan nunman ni dewwan kultinah ey nampepettek ida. ");
INSERT INTO ify_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ey nengapyan neliman balituk ni pengippit tun gilig idan nunman ni dewwan kultinah ma-lat meihakkey hu dingding ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nengapyan hampulut hakey ni kultinah ni dutdut ni gelding, et ita-kep tuddad luput ni kultinah ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Impan-iingngeh tudda humman ni kultinah e ya kadinukkey ni hakey, ey na-pat et liman piyeh niya enem ni piyeh hu kalinakkeb ni hakey. ");
INSERT INTO ify_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Impandadagsi dan kinugut hu liman nunyan kultinah et meihakkey ida. Hanniman dama impahding dan etan di enem ni kultinah e impandadagsi dan kinugut. Ya etan meikka-nem ni kultinah ey melugpi e meleyyag di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ingkapya da hanneneliman netullikeng di gilig idan nunman ni lima niya enem ni kultinah ni nandadagsin nekugut. ");
INSERT INTO ify_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ey nengapyan neliman giniling ni pengippit tun gilig idan kultinah et meihakkey ida. ");
INSERT INTO ify_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nengapyan dewwan tuldah ni katat ni lakkitun kalneroh niya kakkayyagud ni katat ni mei-dah. Huyya pengettep dan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Nengapyan kalkalimangngan Tabernacle ni akasyah ni keyew. ");
INSERT INTO ify_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ya kadinukkey idan nunman ni ingkapya tu ey hampulut liman piyeh niya kalinakkeb da ey dewampulut pitun pulgadah. ");
INSERT INTO ify_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Wada nan-iingngeh ni handedwan dimmewdew di emin etan di frames ma-lat manhuhuup ida. ");
INSERT INTO ify_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","26","Hinead tudda handedwampulu idan nunman di appit ni south niyad north ni Tabernacle. Ey ingkapya tu newalun silber ni pengittu-unan idan nunman e handedwa neikapyad hengeg ni hakey. ");
INSERT INTO ify_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Yad awwidan ni Tabernacle di appit ni kakelinnugin aggew ey intuun tu enem idan nunman ");
INSERT INTO ify_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","niya intuun tu hanhakkey di dewwad dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Humman idan neikkapyad dugu ey nandekep ida meippalpud hengeg tu ingganah di utduk di ta-pew tu e neihhuklub hu netullikeng et mandekep ida. Henin nunman hu impahding tud dewwan dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Et walun emin ni henin nunman hu ingkapya tudman ni awwidan ni Tabernacle ey inha-ad tu hu hampulut enem ni silber ni pengittu-unan idan nunman et handedwad hakey idan nunman. ");
INSERT INTO ify_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Nengapyan hampulut liman keyew ni akasyah ni meibballabag etan idad kalkalimangngan Tabernacle. Ingkapya tu hanlilmad appit ni north, yad south et yad awwidan di appit ni kakelinnugin aggew. ");
INSERT INTO ify_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ya etan ida neigawwan neiballabag di gawwaddan nunman ni kalkalimangnga ey neipalpud hakey ni dugu ingganah lad hakey mewan ni dugu. ");
INSERT INTO ify_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Nengapya pay ni netullikeng ni balituk ni mengnged idan meibballabag ni keyew. Ey sinekapan tun balituk huyyan kalkalimangnga, anin idan etan ni meibballabag. ");
INSERT INTO ify_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ya etan kultinah di bawang ni Tabernacle ey kakkayyaggud ni luput et ya blue, purple niya makadlang ni sinayyum hu kinapya da. Ey ya hakey ni nelaing ni mangngunnu hu nengibordan u-ukkul ni anghel. ");
INSERT INTO ify_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ingkapyaan tudda huyyan kultinah ni epat ni akasyah ni tukud ni netakapan ni balituk, ey epat ni silber ni pengittu-unan idan nunman ni tukud, ey epat mewan ni balituk ni kawit ni pengihhableyan ni kultinah. ");
INSERT INTO ify_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nengapyan hakey pay ni meikkultinah di heggeppan di Tabernacle. Inusal tu kakkayyaggud ni luput et ya blue, ya purple niya makadlang ni sinayyum ey inyayyaggud dan binordaan. ");
INSERT INTO ify_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ingkapyaan tu huyyan kultinah ni liman tukud ni akasyah e sinekapan tun balituk. Et ya kawit da niya al-alkus da ey balituk dama. Ya keittu-unan idan tukud ey giniling. ");
INSERT INTO ify_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Nengapya hi Besalel ni Kaban Apu Dios e inusal tu keyew ni akasyah. Na-pat et liman pulgadah kadinukkey tu, dewampulut pitun pulgadah kalinakkeb tu, niya dewampulut pitun pulgadah kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Sinekapan tun nemahmah ni balituk humman ni Kaban, anin ya bawang tu niya nanlinikweh ni gilig tu. ");
INSERT INTO ify_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ey ingkapya tu epat ni netullikeng ni balituk diman ni Kaban e handedwad nambina-hil. ");
INSERT INTO ify_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ey nengapyan keyew ni akasyah ni pan-attang e sinekapan tun balituk, ");
INSERT INTO ify_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","et iduduk tuddadman ni netullikeng di nambina-hil di Kaban. ");
INSERT INTO ify_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Kinapya tu nemahmah ni balituk ni hu-keb ni Kaban. Ya kadinukkey tu ey na-pat et liman pulgadah ey dewampulut pitun pulgadah hu kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nemahmah daman balituk hu kinapya tuddan dewwan u-ukkul ni nepayakan ni anghel. ");
INSERT INTO ify_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Inha-ad tuddad nambinengwah di utduk ni hu-keb ni Kaban e neihakkey hu nengikapya tu etan di hu-keb. ");
INSERT INTO ify_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nanhinnanggadda e nebekyag payak da et hephepan da huyyan hu-keb. ");
INSERT INTO ify_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ginibbuh tu humman et mengapyan tebol e inusal tu hu keyew ni akasyah. Ya kadinukkey tu ey tellun piyeh, ya kalinakkeb tu ey hakey et kagedwah ni piyeh niya nehuluk ni dewwan piyeh kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Sinekapan tun nemahmah ni balituk huyyan tebol niya nanlinikweh ni gilig tu. ");
INSERT INTO ify_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hinu-upan tun tellun pulgadah di nanlinikweh ni gilig tu ey sinekapan tun balituk. ");
INSERT INTO ify_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ingkapyaan tun hanhakkey ni netullikeng ni balituk etan epat ni helin nunyan tebol di dugu tu. ");
INSERT INTO ify_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ey ingkapya tudda huyyan netullikeng di daul ni gilig ni tebol. ");
INSERT INTO ify_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ey nengapyan keyew ni akasyah ni pan-attang ni nunyan tebol ey sinekapan tun balituk. ");
INSERT INTO ify_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ey nengapyan nemahmah ni balituk ni duyun pengihha-adan ni bangbanglun insensoh, ya basuh, ya pa-nay niya mahukung ni duyun pengidduyyagan ni meinnum ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nengapya hi Besalel ni nemahmah ni balituk ni pengippettukan ni kengkeh. Ingkahhakey tun pinanday hu hengeg tu niya palat tu. Ey ingkahhakey tuddan kinapya hu heni basuh niyadda habung ni al-alkus tu. ");
INSERT INTO ify_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Humman ni pengippettukan ni kengkeh ey enem panga tu e hantetlud nambina-hil. ");
INSERT INTO ify_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Nei-peng idan nunman ni enem ni panga hu basuh ni heni habung ni almond. ");
INSERT INTO ify_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ya etan palat nunman ni pengippettukan ni kengkeh, ey neal-alkusan ni epat ni heni dama habung ni almond, ");
INSERT INTO ify_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","In-epeng tun ingkapya hu hanhakkey ni habung ni eleg mebekyag di daul ni handedwan pangan etan ni pengippettukan ni kengkeh. ");
INSERT INTO ify_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Huyyaddan habung ni eleg mebekyag et yadda panga ey neihakkey hu kapkapya tud pengippettukan ni kengkeh. Nemahmah ni balituk hu nekapyan emin idan nunya. ");
INSERT INTO ify_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Anin idan ipit niyadda melakkeb ni duyun penellukduk ni ngalab, et nemahmah daman balituk hu nekapya. ");
INSERT INTO ify_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ya ingkapyan Besalel di pengippettukan ni kengkeh niyadda emin huyyan meussal ey umlaw ni telumpulut epat ni kiloh ni nemahmah ni balituk. ");
INSERT INTO ify_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ya etan altar ni pengiggihheban ni bangbanglun insensoh, ey keyew ni akasyah dama hu nekapya. Kuwadladuh e hampulut walun pulgadah hu kalinakkeb tu, ey hampulut walun pulgadah hu kadinukkey tu, ey tellun piyeh kasina-gey tu. Yadda epat ni dugu tu ey dimmewdew ni heni ha-duk ey neihakkey hu kapkapya tud altar. ");
INSERT INTO ify_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Netakapan hu ta-pew nunman ni altar ni balituk, anin idan dingding tu niyadda etan dimmewdew ni heni ha-duk et yad nanlinikweh ni gilig tu. ");
INSERT INTO ify_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ingkapya tu hu handedwan netullikeng ni balituk di nambina-hil nunman ni altar di daul ni gilig tu, et kaidudukan idan pan-attang. ");
INSERT INTO ify_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Akasyah hu nekapyaddan nunman ni pan-attang e netakapan ni balituk. ");
INSERT INTO ify_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nengapyan lanan neieng-eng ni ussalen ni padi, ey nengapya pay ni nemahmah ni bangbanglun insensoh henin kapengapyan nelaing ni mengapyan bangbanglun insensoh. ");
INSERT INTO ify_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Nengapya pay di Besalel et yadda edum tun altar ni pengihheban ni kamei-appit e inusal da keyew ni akasyah. Huyyan altar ey kuwadladuh e pitu et kagedwah ni piyeh hu kadinukkey tu niya kalinakkeb tu, niya epat et kagedwah ni piyeh hu kasina-gey tu. ");
INSERT INTO ify_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ingkapya tu hu heni ha-duk idad ta-pew ni epat ni dugu tun neihakkey hu kapkapya tud altar. Negibbuh ni kinapya tu et takapan tun giniling. ");
INSERT INTO ify_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nengapya pay idan meussal di pan-appitan henin baldih ni pengi-ha-adan ni dep-ul, ya pala, ya besin, ya tewik ni detag niya penellukduk ni ngalab. Emin ida huyya ey nekapyad giniling. ");
INSERT INTO ify_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","5","Nengapyan nelaggan giniling ni meihha-ket di dimmewdew di gawwan bawang ni altar. Ingkapya tu epat ni netullikeng etan di epat ni dugun nunman ni altar ni keidduddukan idan pan-attang. ");
INSERT INTO ify_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ey nengapyan keyew ni akasyah ni pan-attang e sinekatan tun giniling. ");
INSERT INTO ify_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Induduk tudda humman ni pan-attang etan idad netullikeng ni ingkapya tuddad dugun altar ma-lat pengitngedan idan mengi-attang. Tabla hu kinapyan tun altar ey eleg tu det-alan. ");
INSERT INTO ify_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kinapya da etan giniling ni besen ni pan-ulahan niya etan giniling ni neipetukan tu e inusal dadda diggal ni indawat idan bibi-in kamangngunnud heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ey kinapya da hu dallin ni Tabernacle e nekultinahan ni kakkayyaggud ni luput hu appit ni south e hanggatut et neliman piyeh kadinukkey tu. ");
INSERT INTO ify_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ya mengnged nunman ni kultinah, ey dewampulun tukud ni giniling ni meittu-un di dewampulun giniling ni pengittu-unan. Meihhabley ida etan idad silber ni kawit ey silber ni pengihhableyan ni neikapyaddad tukud. ");
INSERT INTO ify_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Hanniman damad appit ni north e hanggatut et neliman piyeh hu kadinukkey ni kultinah ni meihhabley di silber ni kawit ey silber ni pengihhableyan ni meikkapyad dewampulun giniling ni tukud ni meittu-un di dewampulun giniling ni pengittu-unan. ");
INSERT INTO ify_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Yad awwidan di appit ni kakelinnugin aggew ey nepitu et liman piyeh hu kadinukkey ni neikultinah e neihabley di hampulun tukud ni neituun di hampulun pengittu-unan. Silber hu nekapyan kawit niya hableyyan. ");
INSERT INTO ify_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hanniman damad heggeppan di dallin ni Tabernacle di appit ni kasimmilin aggew e mekultinahan ni nepitu et liman piyeh kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Yadman ni heggeppan ey meikkapya hu dewwan kultinah e hakey ni kultinah di winannan ey hakey di winilli. Handedwampulut dewwa et kagedwah ni piyeh hu kalinakkeb ni hakey. Ey hantetlu hu tukud ni meittu-un di tellun nekapyan pengittu-unan hu pengihhableyan idan nunyan kultinah. ");
INSERT INTO ify_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Emin ida humman ni kultinah ni neihabley di nanlinikweh di dallin ni Tabernacle, ey kayyaggud ni luput. ");
INSERT INTO ify_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ey emin ida neituunan ni tukud ey giniling nekapya, nem yadda kawit niya hableyyan ey silber. Et yadda utduk ni tukud ey netakapan ni silber. Emin ida tukud ey nekapyaan ni silber ni hableyyan. ");
INSERT INTO ify_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Yadda kultinah ni neihenid heggeppan ey telumpulun piyeh hu kadinukkey da, ey pitut kagedwah ni piyeh kasina-gey da heniddan etan ni kultinah ni neidingding ni nekapyad kayyaggud ni luput, ey nebordaan ni sinayyum ni blue, purple niya makadlang. ");
INSERT INTO ify_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Epat hu tukud tu ey neituun idad giniling ni pengittu-unan. Neha-adan daman silber hu utduk da, anin idan neilibed et yadda pengihhableyan ni kultinah ey nekapyad silber. ");
INSERT INTO ify_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ey emin ida paghek ni Tabernacle, anin idad nanlinikweh di dallin tu ey giniling hu nekapya. ");
INSERT INTO ify_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ya bilang ni balituk ya silber niya giniling ni neusal di Tabernacle ey intudek idan helag Levi tep humman in-olden Moses. Hi Ithamar e u-ungngan Aaron e padi hu ap-apu da. ");
INSERT INTO ify_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Hi Besalel e u-ungngan Uri e u-ungngan Hur e helag Judah hu ingkalgaduh di emin idan nunyan meippahding ni in-olden Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bimmaddang ni hi-gatu hi Oholiab e u-ungngan Ahishamak e helag Dan. Nelaing ni man-al-alkus ey mengibbordan blue, ya purple niya makadlang ni sinayyum di kayyaggud ni luput. ");
INSERT INTO ify_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hanlibun kiloh ni balituk hu in-aliddan helag Israel ni neusal di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Tellun libu et epat ni gatut et telumpulut dewwan kiloh ni silber hu neamung ni indawat idan tutu-u eman ni nebilangan da e nekibilang ida lalakkin dewampulu toon da winu nehuluk e umlaw di enem ni gatut et tellun libu et liman gatut et nelima hu bilang da. ");
INSERT INTO ify_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tellun libu et epat ni gatut ni kiloh ni silber hu neusal idad hanggatut ni neituun ni tukud ni Tabernacle, et yadda neituunan ni tukud ni pengihhableyan ni kultinah ");
INSERT INTO ify_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ey dewampulun kiloh ni silber hu nekapyan kawit, yadda neibaddeng ni hableyyan ni kultinah niyadda inha-ad dad ta-pew idan tukud, ");
INSERT INTO ify_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","niya dewwan libu et epat ni gatut ni kiloh ni neamung ni giniling ni indawat idan tutu-u. ");
INSERT INTO ify_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Nekapyadda huyyad keittu-unan idan tukud di heggeppan di Tabernacle, ya altar, ya etan nelaggan neiha-ad di bawang tu, et yadda ngunut ni meussal di altar. ");
INSERT INTO ify_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Neiusal pay hu giniling di neituunan idan tukud ni keihhableyan idan kultinah di nanlinikweh di dallin ni Tabernacle, yad heggeppan, et yadda paghek pengi-ikketan idan kultinah. ");
INSERT INTO ify_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Yadda etan nelaing ni menguggut ey nengapyaddan kayyaggud ni luput ni blue, purple niya makadlang et kuguten dan ibbalwasin padin pengippahdingan dan pengunnun Apu Dios. Kinugut da huyyan luput ni ibbalwasin Aaron meippuun di in-olden Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nengapyaddan ephod ni kayyaggud ni luput niya balituk ni heni sinulid ey nebordaan ni blue, ya purple niya makadlang ni sinayyum. ");
INSERT INTO ify_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nengapyaddan balituk ni sinulid e minenassilyu da hu balituk ma-lat umingpih et han da genunsingen, et mambalin ni heni sinulid et iyayyaggud dan imborda anin etan idan blue, purple et ya makadlang ni sinayyum di diman ni kayyaggud ni luput. ");
INSERT INTO ify_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ya nengapya dan ephod ey dewwan luput ni nan-appil e hakey di hinangga ey hakey di beneg e tetngeden ni dewwa mewan ni luput ni meihhabley di pahhannan. ");
INSERT INTO ify_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kayyaggud daman luput hu ingkapya dan meibalkeh di ephod, ey binordaan dan balituk ni sinulid, ya blue, ya purple niya makadlang sinayyum. ");
INSERT INTO ify_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Impeket dadda hu batun onyx di balituk et iyayyaggud dan iku-lit hu ngadan idan helag Israel diman henin kapehding ni mengikku-lit ni sinyal. ");
INSERT INTO ify_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Intakap dadda huyyan batu etan di neihabley di nambina-hil di pahhannan ni ephod. Huyyaddan batu hu penginemnemneman Apu Dios idan helag Israel. Impahding dan emin huyya e inu-unnud da intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Nengapyaddan luput ni meittekkap di pagew ni ephod. Nan-ingngeh hu inusal dan nunya etan di kinapya dan ephod ey inyayyaggud da daman binordaan. ");
INSERT INTO ify_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kuwadladuh huyyan luput e melugpi et heyam ni pulgadah hu kadinukkey tu ey kalinakkeb tu. ");
INSERT INTO ify_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Intakap dadya hu epat ni linyah ni nambakbaklang ni nebalol ni batu: yad etan di nemangulun linyah ey intakap da hu ruby, ya topaz niya garnet, ");
INSERT INTO ify_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","yad meikkadwan linyah ey ya emerald, ya sapphire niya diamond, ");
INSERT INTO ify_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","yad meikkatlun linyah ey ya turquoise, ya agate niya amethyst, ");
INSERT INTO ify_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","niyad meikka-pat ni linyah ey ya beryl, ya onyx niya jasper. Neitekap idan emin huyyan nebalol ni batud balituk. ");
INSERT INTO ify_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Neitudek emin hu ngadan idan hampulut dewwan u-ungngan Jacob idadman ni nenginan batu et iehneng dan emin hu helag Israel. ");
INSERT INTO ify_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ingkapyaan dan heni nelubid ni banggel ni nemahmah ni balituk huyyan luput ni meittekkap di pagew ni ephod, ");
INSERT INTO ify_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ey nengapyaddan dewwan netullikeng ni balituk, et ikugut dad dewwan dugun nunman ni luput di ta-pew tu. ");
INSERT INTO ify_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","In-iket da humman ni dewwan nelubid ni balituk di diman ni netullikeng. ");
INSERT INTO ify_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ey ya utduk idan nunman ni nelubid ni banggel ey in-iket da etan di dewwan balituk ni neipketan idan batun onyx ni neitekap etan di neihabley di pahhannan ni ephod. ");
INSERT INTO ify_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Nengapyadda mewan ni dewwan netullikeng ni balituk ey ingkugut da etan di dewwan dugun etan ni utduk ni luput ni meittekkap di pagew ni ephod. Neikugut ida huyyad piggad etan ni luput et maitumuk di ephod. ");
INSERT INTO ify_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nengapyadda pay ni dewwan netullikeng ni balituk ey ingkugut dad hinanggan nunyan luput di ta-pew ni balkeh ni ephod. ");
INSERT INTO ify_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Inusal da hu blue ni linubid ni nengi-iket diman ni netullikeng ni neikugut di luput ni neitekap di pagew ni ephod di ta-pew ni balkeh tu. Impahding dan emin huyya e inu-unnud da intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nengugut idan blue ni balwasin mei-dah di ephod. ");
INSERT INTO ify_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kinapyaan dan huklubban ni ulu ey kinugutan dan luput hu gilig nunman ni huklubban henin edum ni balwasi ma-lat eleg mebi-ki. ");
INSERT INTO ify_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Nengapyaddan henin lameh ni pomegranate e inusal da hu blue, ya purple et ya makadlang ni sinayyum ey inta-yun yuddad nanlinikweh di utduk nunyan balwasi. ");
INSERT INTO ify_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nengapyadda mewan ni nemahmah ni balituk ni kingking e imbenattan dad heni lameh ni pomegranate et ita-yun dad nanlinikweh ni utduk ni balwasi. ");
INSERT INTO ify_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Inta-yun da hakey ni kingking ni intu-nud da hu hakey ni pomegranate ingganah nelikweh hu utduk ni balwasin padi. Impahding dan emin huyya e inu-unnud da intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ingkugutan da hi Aaron et yadda lalakkin u-ungnga tun mei-dah, ");
INSERT INTO ify_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ya penget, ya taddung, ya ansikkey ni pantalon ");
INSERT INTO ify_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","niya etan meibbalkeh e inusal da kayyaggud ni luput ni nebordaan ni blue, purple ni ya makadlang ni sinayyum. Impahding dan emin huyya e inu-unnud da intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ey nengapyaddan medal ni nemahmah ni balituk et iku-lit da hu ‘Neieng-eng nan Apu Dios.’ ");
INSERT INTO ify_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","In-iket da blue ni linubid di medal et itekap dad hinanggan etan ni kinapya dan penget Aaron. Impahding dan emin huyya e inu-unnud da intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Huyya law hu negibbuhan ni Tabernacle. Yadda helag Israel ey impahding dan emin hu in-olden Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Inlaw dan Moses hu kalkalimangngan Tabernacle, yadda kawit tu, yadda tukud tu, yadda keyew ni meibballabag, yadda keittu-unan da, ");
INSERT INTO ify_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","yadda katat ni lakkitun kalneroh ni impambalin dan madlang, ya kayyaggud ni katat, ya etan kultinah di bawang di Kuwaltuh Apu Dios, ");
INSERT INTO ify_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ya Kaban Apu Dios, yadda keyew ni pan-attang niya hu-keb tu, ");
INSERT INTO ify_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ya tebol niyadda meussal diman, ya sinapay ni meihha-ad di Kuwaltuh Apu Dios, ");
INSERT INTO ify_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ya balituk ni pengippettukan ni kengkeh niyadda meussal diman, ya lanan meihha-ad di kengkeh, ");
INSERT INTO ify_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ya balituk ni altar, ya lanan meihha-ad di ulun padi, ya bangbanglun insensoh, ya kultinah di heggeppan di Tabernacle, ");
INSERT INTO ify_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ya giniling ni altar, ya giniling ni nelaggan meihha-ad di bawang tu, yadda keyew ni pan-attang, niyadda emin ngunut ni meussal diman, ya besen niya pengippettukan nunyan besin, ");
INSERT INTO ify_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","yadda kultinah ni meiddingding, yadda tukud niyadda keittu-unan da, ya etan kultinah ni neiha-nin di heggeppan di dallin, yadda iket, yadda paghek niyadda edum ni meussal di Tabernacle, ");
INSERT INTO ify_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","yadda balwasin padin ussalen dan mangngunnud Tabernacle, yadda balwasin Aaron niyadda balwasin u-ungnga tun lalakki. ");
INSERT INTO ify_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Impahding idan helag Israel humman e inu-unnud dan emin hu in-olden nan Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Inang-ang Moses emin ida huyyan kinapya da ey ustuh e neka-u-unnud da inhel Apu Dios ni pengapya da. Et bendisyonan Moses ida. ");
INSERT INTO ify_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Yan memengngulun aggew ni memengngulun bulan hu pemehwatan yun Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ipahgep yu etan Kaban diman ey ihabley mudda kultinah et meha-ninan. ");
INSERT INTO ify_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ilaw mu etan tebol ey iha-ad mudda meihha-ad diman. Ey ipahgep mu etan pengippettukan ni kengkeh et ituun mudda kengkeh. ");
INSERT INTO ify_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Iha-ad mu etan altar ni pengiggihheban ni bangbanglun insensoh etan di demang ni Kaban ku. Ey ihabley mu hu kultinah di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ey ya etan altar ni pengiggihheban ni kamei-appit ey iha-ad mud hinanggan heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Penum ni danum etan besen ey inha-ad mud nambattanan nunyan altar et ya Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kapyam hu dallin ni Tabernacle ey ihabley mu hu kultinah di heggeppan. ");
INSERT INTO ify_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Hedin negibbuh, wakgihim ni lana hu Tabernacle niyadda etan meussal diman et maieng-eng idan emin ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Wakgihim dama etan altar ni pengiggiheban ni kamei-appit niyadda meussal diman et maieng-eng idan hi-gak ");
INSERT INTO ify_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","anin ya etan besen niya etan pengippettukan tu. ");
INSERT INTO ify_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ipahding mu hu elaw ni panlinnih nan hi Aaron niyadda u-ungnga tud heggeppan di Tabernacle, ");
INSERT INTO ify_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","et pebalwasim nan Aaron hu balwasin padi ey duyagim hu ulu tun lana et keang-angan tu e hi-gatu neieng-eng ni padin mansilbin hi-gak. ");
INSERT INTO ify_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Pebalwasim damaddan u-ungnga tu etan intugun kun ibbalwasi da, ");
INSERT INTO ify_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ey duyagim dama hu ulu dan lana, henin pehding mun ameda et maieng-eng idan padin mansilbin hi-gak. Huyyan pena-adan mun lanan ulud Aaron niyadda u-ungnga tu hu keang-angan tu e ebuh hu helag dan manhulluhullul ni mampeddiddan helag Israel.” ");
INSERT INTO ify_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Inu-unnud Moses emin humman ni intugun Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Yan nemangulun aggew ni nemangulun bulan ni meikkadwan toon neipalpun neni-yanan dan Egypt ey binehwat da etan Tabernacle ni panha-adan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ingkapyan Moses etan pengittu-unan daddan tukud niyadda etan kalkalimangnga tu. ");
INSERT INTO ify_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Et han tu ietep etan tuldah et iha-ad tudda etan dingding e inu-unnud tu inhel Apu Dios ni pengapya tu. ");
INSERT INTO ify_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Inla tu etan dewwan batun neitudkan ni Tugun Apu Dios, et iha-ad tu etan di Kaban et hu-keban tu. Et iduduk tudda etan keyew ni pan-attang etan di netullikeng ni neikapyad Kaban. ");
INSERT INTO ify_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Et ipahgep tu huyyan Kaban di Tabernacle et ita-yun tu etan kultinah ma-lat maiheni etan di Kaban. Impahding tudda e inu-unnud tu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Impahgep tu hu tebol etan di bawang ni Tabernacle di hinanggan etan ni kultinah ");
INSERT INTO ify_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","et iha-ad tudman etan sinapay ni kamei-appit nan Apu Dios e inu-unnud tu hu inhel Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Impahgep tu pay etan pengippettukan idan kengkeh di Tabernacle, et iha-ad tud demang etan ni tebol di appit ni south. ");
INSERT INTO ify_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Et integan tudda humman idan kengkeh di hinanggan Apu Dios e inu-unnud tu inhel tu. ");
INSERT INTO ify_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Et iha-ad tu etan balituk ni pan-appitan di hinanggan ni kultinah, ");
INSERT INTO ify_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et giheben tu bangbanglun insensoh ni kamei-appit nan hi Apu Dios e inu-unnud tu inhel tun pehding tu. ");
INSERT INTO ify_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Negibbuh humman et kultinahan tu etan heggeppan etan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inha-ad tud dallin ni Tabernacle etan pan-appitan daddan kagihheba. Yadman nan-appitan tu etan ni kinleng tu niya ineni dan in-appit da e inu-unnud tu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inha-ad tu etan besen di nambattanan etan ni Tabernacle niya pan-appitan et penuen tun danum. ");
INSERT INTO ify_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Yadman hu pan-ullahan di Moses, hi Aaron niyadda u-ungnga tun heli da niya ngamay da ");
INSERT INTO ify_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","hedin umhehgep idad Tabernacle. Impahding tudda huyya meippuun di in-olden Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ya nanggillig ni impahding Moses, ey kinultinahan tu nanlinikweh ni dallin ni Tabernacle niya etan ni heggeppan tu, et megibbuh hu ngunu dad Tabernacle. ");
INSERT INTO ify_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Entanni ey hinephepan ni kulput etan Tabernacle ey kaumhili tep wada Apu Dios diman. ");
INSERT INTO ify_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Et eleg pakahgep hi Moses tep hinephepan nisin nunman ni kulput ey kaumhili dayaw Apu Dios. ");
INSERT INTO ify_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Hedin immahpat etan kulput et immela, han ida immegah hu helag Israel et unuden da et lumaw idad lawwan da. ");
INSERT INTO ify_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nem hedin eleg meglid man eleg ida dama. Nem hedin immela, immeladda dama. ");
INSERT INTO ify_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Yan kawwalwal ey kameipettek di ahpat ni Tabernacle ey hedin hileng, kamambalin ni apuy ma-lat panilag idan helag Israel. Humman ni kulput ey wadan ingganah ni nunman ni da nandaldalnan. ");
INSERT INTO ify_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Hi Apu Dios e wada etan di Tabernacle ey ineyagan tu hi Moses et ehelen tun emin ni hi-gatu ");
INSERT INTO ify_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","hu u-unnuden idan helag Israel hedin man-appit idan animal da, henin baka, ya kalneroh winu gelding. ");
INSERT INTO ify_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kan Apu Dios ni hi-gatuy “Yahhuy hu e-helen mun hi-gada: ‘Hedin ya i-appit ni tuu ey ya kagihheban baka, ey mahapul ni ya lakkitu niya mahapul ni kayyaggud e endi dipektoh tu. I-ali tu humman et idwat tun padid heggeppan di Tabernacle ma-lat abuluten Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Itta-pew nunman ni tuu hu ngamay tud ulu etan ni baka ma-lat abuluten Apu Dios humman ni i-appit tu et ma-kal hu liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ey wa-teken tu humman ni baka, et alen idan padin helag Aaron hu kuheyaw tu et iwakgih dad altar di hinanggan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Latlaten tu belat etan ni baka et hantu tenegtega, ");
INSERT INTO ify_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ey pantungnguan idan padi hu altar et man-apuy ida. ");
INSERT INTO ify_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ey inta-pew da etan ida netenegteg ni detag ni baka, anin idan ulu et yadda taba etan di apuy. ");
INSERT INTO ify_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Yadda wadad egeh tu e henin altey niya bala, et yadda heli, ey mahapul ni ullahan etan ni tuu et han i-dum idan padin gihheben di altar et iappit dan Apu Dios. Ya hamuy nunyan kamei-appit ey kamengippeamleng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Hedin ya i-appit etan ni tuu ey ya kalneroh winu ya gelding, ey mahapul ni ya lakkitu niya mahapul ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Keklengen tud appit ni north etan ni altar di hinanggan Apu Dios. Ey iwwakgih idan padi hu kuheyaw di dingding nunman ni altar. ");
INSERT INTO ify_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Tennegtegen nunman ni tuu hu detag nunman ni animal, et alen ni padi et ita-pew tu etan di kamantetebbel ni apuy di altar, anin ya ulu et ya taba. ");
INSERT INTO ify_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mahapul ni ullahan etan ni tuu hu wadaddad egeh etan ni animal, henin altey et ya bala, anin ida heli et i-dum ni padin gihheben di altar et iappit tun Apu Dios. Ya hamuy nunyan kamei-appit ey kamengippeamleng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Hedin ya kamei-appit ni kagihheba ey ya sisit, ey mahapul ni ya paluma winu ya balug. ");
INSERT INTO ify_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","16","Illaw ni padid altar etan sisit et siluden tu buklew tu. Ey e-kalen tu bihugung tu niya kinan tu, et ibbeng tuddad kapengihha-adin dep-ul di a-allaw ni altar di appit ni kasimmilin aggew, niya iwwakgih tud dingding etan ni altar hu kuheyaw etan ni sisit. ");
INSERT INTO ify_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ey hantu hinukla humman ni sisit, nem ang-angen tu et eleg melahlah hu payak, et han tu gihebad apuy di altar. Ya hamuy nunyan kamei-appit ey kamengippeamleng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Hedin begah hu i-appit ni tuun Apu Dios, ey mahapul ni megilling ma-lat mambalin ni alinah. Ey kamdugan tun mansikan olibah niya bangbanglun insensoh, ");
INSERT INTO ify_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","et ilaw tuddad kad-an ni padin helag Aaron. Umgamal etan padin nunman ni alinah ni nekamdugan ni mansikan olibah niya bangbanglun insensoh, et giheben tud altar ma-lat keiang-angan tu e neiappit humman ni alinah nan Apu Dios. Ya hamuy nunyan kamei-appit ey kamengippeamleng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ya edum nunyan kamei-appit ni alinah ey meidwat nan Aaron et yadda u-ungnga tu. Huyyan alinah ey mei-eng-eng nan Apu Dios tep kamei-appit ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Hedin sinapay hu i-appit yu, ey mahapul ni ya kayyaggud ni alinah hu nekapyaan tu, niya mekamdugan ni mansikan olibah niya bangbanglun insensoh, nem entan tu kamdugin kamampelbag. ");
INSERT INTO ify_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Hedin ya sinapay ni kameihhe-eng di nepayyad ni gumek hu i-appit yu, ey mahapul ni kayyaggud ni alinah hu nekapyaan tu. Mekamdugan ni mansikan olibah, nem eleg mekamdugin kamampelbag. ");
INSERT INTO ify_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Gudduen yu ey kamdugan yun mansika et humman i-appit yun alinah. ");
INSERT INTO ify_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Hedin ya sinapay ni kameihhe-eng di palhu hu i-appit yu, ey mahapul ni ya kakkayyagud ni alinah ni nekamdugan ni mansikan olibah hu kapyaen yu. ");
INSERT INTO ify_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hedin man-appit kayun Apu Dios ni begah, anin ni hipa pehding yun mengiddaddan, ey illaw yu etan ni padi et ilaw nunman ni padid altar. ");
INSERT INTO ify_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Um-ala etan padin ekket ni nunman ni kamei-appit et giheben tud altar et keang-angan tu e neiappit nan Apu Dios humman, et ya hamuy tu ey kamengippeamleng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ya edum nunman ni kamei-appit ey meidwat di Aaron et yadda u-ungnga tu. Neieng-eng nan Apu Dios huyya, tep neiappit ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Mahapul ni eleg mekamdugin kamampelbag, niya putsukan humman ni alinah ni kamei-appit nan Apu Dios, tep eleg mabalin ni gihheben hu kamampelbag ni sinapay, winu putsukan hedin ya kamei-appit ey kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Hedin ya nebukul ni neani hu i-appit yu, ey dammutun mekamdugan ni kamampelbag winu putsukan, nem eleg mabalin ni gihheben humman ni i-appit yun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Mekamdugan ni ahin hu begah ni kamei-appit nan Apu Dios ma-lat huyya mengippenemnem ni hi-gayu etan ni nehammad ni nekitbalan tun hi-gayu. Ippidwak ni e-helen e entan tu liwwan ni ha-adan ni ahin hu i-appit yu. ");
INSERT INTO ify_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ihanglag yu humman ni mebukkul ni ennien yun i-appit yun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ey ha-adi yun mansikan olibah niya bangbanglun insensoh. ");
INSERT INTO ify_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Um-ala etan padin ekket ni nunman ni neihanglag ni begah ni nekamdugan ni mansikan olibah niya insensoh et giheben tud altar e humman i-appit tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Hedin man-appit kayun pekiddagyuman yun Apu Dios, ey mahapul ni ya bulug winu ya keba-yan ni bakan endin hekey dipektoh tu hu i-appit yu. ");
INSERT INTO ify_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Itta-pew yu ngamay yud ulu etan ni bakan i-appit yu, et kelengen yud neihnup di heggeppan di Tabernacle, et iwakgih idan padin helag Aaron hu kuheyaw nunman ni bakad nanlinikweh ni dingding etan ni altar. ");
INSERT INTO ify_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Emin ida taban wadad kad-an ni egeh ni nunman ni baka, ");
INSERT INTO ify_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","yadda etan dewwan basin, anin ya etan taban neilibutan da, et ya altey, ey mei-appit nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ihha-ad idan padin helag Aaron ida huyyan emin di ta-pew ni detag ni kamei-appit nan Apu Dios et makigiheb di apuy. Ya hamuy idan nunyan kamei-appit ey kamengippeamleng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Hedin ya kalneroh winu gelding hu mei-appit ni pekiddagyuman nan Apu Dios, ey dammutu hu lakkitu winu ya labah ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","8","Hedin ya kalneroh hu i-appit yu, ey itta-pew yu ngamay yud ulu etan ni kalneroh ey kinleng yud neihnup di heggeppan di Tabernacle. Ey han inwakgih idan padi hu kuheyaw nunman ni kalneroh di nanlinikweh ni dingding etan ni altar. ");
INSERT INTO ify_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","Ya ikul, yadda taban wadad kad-an ni egeh, ya etan dewwan basin, et ya etan taban neilibutan da, niya altey tu ey kamei-appit nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Gihheben ni padi ida huyyan kennen ni kamei-appit ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Hedin gelding hu i-appit ni tuun nan Apu Dios, ");
INSERT INTO ify_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ey itta-pew tu ngamay tud ulun nunman ni gelding et kelengen tud neihnup di heggeppan di Tabernacle. Et han iwakgih idan padin helag Aaron hu kuheyaw nunman ni gelding di nanlinikweh ni dingding etan ni altar. ");
INSERT INTO ify_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","Ya ikul, ya egeh, ya etan dewwan basin, et ya etan taban neilibutan da, niya altey tu ey e-kalen ");
INSERT INTO ify_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ni padi, et giheben tun emin di altar et meiappit nan Apu Dios, et ya hamuy tu ey kamengippeamleng ni hi-gatu. Nemnem yu e emin hu taba ey neieng-eng ni kamei-appit nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Et mukun eleg mabalin ni yu kennen hu taba niya kuheyaw. Huyyan tugun ey mannananeng ni ingganah ey mahapul ni u-unnuden idan helag yu, anin di attun bebley hu pambebleyan da.’” ");
INSERT INTO ify_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ehel mudda huyyan helag Israel, kammuy: ‘Hedin eleg u-unnuden ni hakey ni tuu hu tugun Apu Dios et manliwat, nem eleg tu igeb-at, ey heninnuy hu mahapul ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ya etan eta-gey ni padi hu nanliwat, ey meilleggat ida etan tuu tud liwat tu. Et humman hu, mahapul ni i-appit tun Apu Dios hu lakkitun kilaw ni bakan endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Illaw tud neihnup di heggeppan di Tabernacle, et ita-pew tu ngamay tud ulun nunman ni baka, ey kinleng tudman di hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ya etan padin neputuk ni mansilbin nunman ni aggew ey um-alan kuheyaw etan ni baka et ihgep tud Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ittetdek tu kimeng tud kuheyaw et iwakgih tun meminpittud hinanggan kultinah di hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Niya ha-adan tun kuheyaw etan epat ni ha-duk di duguddan altar ni gihhebban ni insensoh. Ya etan natdaan ni kuheyaw ey idduyag tud hengeg ni altar ni neihnup di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Mahapul ni e-kalen ni padin emin hu taba etan ni baka, anin idan tabad egeh tu. ");
INSERT INTO ify_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Peki-kal tu etan dewwan basin, anin ya etan taban neilibutan da, et ya altey tu ");
INSERT INTO ify_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ni giniheb tud altar ni gihhebban ni kamei-appit. Henin nunman dama hu pehding tu etan ni taban lakkitun bakan wa-teken tun kamei-appit ni pekiddagyuman tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nem ya etan edum ni detag etan ni baka, heniddan belat, ya laman, ya ulu, ya heli et ya egeh tu, ey ellan etan ni padi ");
INSERT INTO ify_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","et ilaw tud a-allaw ni bebley ni kameibbillang ni malinih et giheben tu etan di kad-an ni ibbengngan ni dep-ul. ");
INSERT INTO ify_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ey hedin nanliwat idan emin hu bimmebley ni helag Israel tep eleg da u-unnuden hu tugun Apu Dios, anin eleg da amta e nanliwat ida, ey meibbillang idan emin ni nanliwat. ");
INSERT INTO ify_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Nem hedin neamtaan da law e nanliwat ida, man mahapul ni um-aladda hu aap-apun bimmebley ni kilaw ni lakkitun bakan kamei-appit tep ya liwat, et peang-ang da etan di neihnup di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Et han da ita-pew ngamay dad ulun nunman ni lakkitun baka, et kelengen dad hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ey ellan etan ni padi hu edum ni kuheyaw etan ni baka et ihgep tud Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ittetdek tu kimeng tu etan di kuheyaw, et iwakgih tun meminpittud hinanggan etan ni kultinah di hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Niya ha-adan tun kuheyaw etan epat ni ha-duk di duguddan altar ni gihhebban ni insensoh. Ey idduyag tu etan natdaan ni kuheyaw di hengeg ni altar ni neihnup di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mahapul ni e-kalen ni padin emin hu taba et giheben tud altar ");
INSERT INTO ify_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ey ippahding tu hu henin tuka pehding ni kamei-appit tep ya liwat tu, ma-lat ma-kal hu liwat idan tuu. ");
INSERT INTO ify_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Illaw tu edum ni parteh ni annel etan ni bakad a-allaw ni bebley et giheben tudman, henin tuka pehding ni kamei-appit tep ya liwat tu. Huyyan kamei-appit hu mengkal ni liwat idan bimmebley ni helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Hedin nanliwat hu ap-apu tep eleg tu u-unnuden hu tugun Apu Dios e Dios tu, anin ni eleg tu igeb-at, ey meibbillang ni nanliwat. ");
INSERT INTO ify_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Nem hedin neamtaan tu e nanliwat, man mahapul ni i-ali tu hu lakkitun gelding ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Itta-pew tu ngamay tud ulun nunman ni gelding, et kelengen tud altar di heggeppan di Tabernacle ni daka pengiklengin kagihheban kamei-appit nan Apu Dios ma-lat ma-kal liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ey ittetdek ni padi hu kimeng tud kuheyaw nunman ni gelding, et ida-nih tuddad ha-duk etan ni altar ni gihhebban ni kamei-appit. Ey idduyag tud hengeg nunman ni altar etan natdaan ni kuheyaw. ");
INSERT INTO ify_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Niya gihheben tuddan emin hu tabad altar, henin tuka pehding ni taban kamei-appit ni kapekiddagyumin Apu Dios. Humman hu pehding ni padi ma-lat ma-kal hu liwat nunman ni ap-apu. ");
INSERT INTO ify_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Hedin wada helag Israel ni eleg mengu-unnud ni tugun Apu Dios, ey meibbillang ni nanliwat, anin ni eleg tu igeb-at. ");
INSERT INTO ify_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Hedin neamtaan tu e nanliwat, mahapul ni i-ali tu hakey ni labah ni gelding ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Itta-pew tu ngamay tud ulun nunman ni gelding, et kelengen tud appit ni north etan ni altar ni kapengiklengin kamei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ittetdek ni padi hu kimeng tud kuheyaw nunman ni gelding, et ida-nih tuddad ha-duk di dugun nunman ni altar et han tu iduyag hu natdaan ni kuheyaw di hengeg tu. ");
INSERT INTO ify_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","E-kalen tudda taban nunman ni gelding, henin tuka pehding ni kamei-appit ni kapekiddagyumin Apu Dios, et giheben tudda huyyad altar. Ya hamuy nunyan kamei-appit ey kamengippeamleng ni hi-gatu. Huyyan pehding ni padi hu mengkal ni liwat etan ni tuun nan-appit. ");
INSERT INTO ify_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Hedin ya pakeetteng tun kalneroh hu in-ali etan ni tuun i-appit tu ma-lat ma-kal hu liwat tu, ey mahapul ni ya labah ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Itta-pew tu ngamay tud ulun nunman ni kalneroh ey kinleng tud altar ni kapengiklengin kagihheban kamei-appit. ");
INSERT INTO ify_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ittetdek ni padi kimeng tud kuheyaw nunman ni gelding, et ida-nih tuddad ha-duk di dugun nunman ni altar ey idduyag tu hu natdaan ni kuheyaw etan di hengeg tu. ");
INSERT INTO ify_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","E-kalen tun emin taba henin impahding tu etan ni pakeetteng tun kalneroh ni kamei-appit ni kapekiddagyumin Apu Dios ni giniheb tu e ita-pew tud edum ni kagihheban kamei-appit. Henin nunya hu pehding ni padi ma-lat ma-kal hu liwat etan ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Hedin impaeyag da hakey ni tuu ma-lat mantistigun meippanggep ni inang-ang tu winu dingngel tu, nem eleg um-ehel e tuka pakdag i-ineng, ey mambehhul et mahapul ni mekastigu. ");
INSERT INTO ify_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Hedin eleg igeb-at etan ni tuu ey kinepa tu hu linggeman ni kameibbillang ni beken ni malinih henin netey ni animal di muyung winu maeyum, niyadda kamangkinaddap, ey meibbilang ni nanliwat humman ni tuu tep kameibbillang ida humman ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ey anin ni eleg igeb-at ni hakey ni tuu nem wada kinepa tun linggeman ni lugit ni kamelpud annel ni edum ni tuu ey meibbillang ni nanliwat hedin neamtaan tu law hu impahding tu. ");
INSERT INTO ify_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Hedin mewan nansapatah hu hakey ni tuu, ey eleg tu pakannemnemen, anin ni lawah winu kayyaggud hu insapatah tun pehding tu, et meibbillang ni nanliwat hedin neamtaan tu law. ");
INSERT INTO ify_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Hedin impahding ni hakey ni tuu ida huyya et neamtaan tu, man mahapul ni ebbuluten tu e impahding tu humman. ");
INSERT INTO ify_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Niya mahapul ni i-appit tun Apu Dios hu hakey ni labah ni kalneroh winu gelding ma-lat ma-kal hu liwat tu. Ya padi hu mengi-appit ni nunyan kamei-appit ni ke-kalan ni liwat nunman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Hedin eleg hanggela etan ni tuu hu kalneroh winu gelding, ey dammutu hu dewwan paluma winu balug, et humman i-appit tu tep ya liwat tu. Ya hakey idan nunman ni sisit ey mei-appit tep ya liwat ey ya etan hakey ey kamei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Illaw tudda humman ni sisit di kad-an ni padi et mamengulun i-appit ni padi etan kamei-appit tep ya liwat. Silluden tu buklew nunman ni sisit, nem eleg tu puttula ulu tu. ");
INSERT INTO ify_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ey iwwakgih tu hu kuheyaw nunman ni sisit di dingding ni altar et han tu iduyag hu natdaan di hengeg nunman ni altar. Huyya hu kamei-appit tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ya etan meikkadwan sisit ey i-appit ni padi e meikkahhakey ni megihheb meippuun di elaw ni pehding ni kamei-appit ni kagihheba. I-appit ni padi huyya ma-lat ma-kal hu liwat etan ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Hedin eleg hanggela etan ni tuu hu dewwan paluma winu balug, ey mahapul ni um-i-lin dewwan kiloh ni kakkayyaggud ni alinah, et humman i-appit tu tep ya liwat tu. Eleg tu ha-adin mansikan olibah winu hipan mengippebanglu, tep mei-appit huyya tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Illaw tu etan ni padi humman ni alinah et gumemal, ma-lat keang-angan tun neiappit nan Apu Dios humman, et ita-pew tud edum ni kamei-appit ni kagihhebad altar. Mei-appit huyya tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ya padi mengi-appit ni nunman ma-lat meliwwan hu liwat idan nunman ni tuu. Ellan ni padi etan edum ni alinah tep neieng-eng humman ni hi-gatu henin tuka pehding ni alinah ni kamei-appit.’” ");
INSERT INTO ify_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Huyyadda hu intugun Apu Dios nan Moses ni mahapul ni meunnud: ");
INSERT INTO ify_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Hedin wada hu hakey ni tuun nanliwat tep impahding tu hu beken ni lebbeng tun pehding di hipan neieng-eng nan Apu Dios, anin eleg tu igeb-at, ey mahapul ni i-appit tu hakey ni lakkitun kalneroh winu lakkitun gelding ni endi dipektoh tu. Humman hu kamei-appit tep ya nanliwatan tu. Ya pambalol dan nunman ey meippuun di inhel idan aap-apun kameunnud. ");
INSERT INTO ify_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mahapul ni mambeyyad etan tuu tep ya humman ni impahding tu niya e-duman tu ibbayad tun dewampulun porsentoh, et humman multa tu. Iddawat tun padi humman ni ibbayad tu et ya etan padi hu mengi-appit ni nunman ni animal, ma-lat ma-kal hu liwat nunman ni tuun nambahul. ");
INSERT INTO ify_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ey hedin nanliwat hu hakey ni tuu tep eleg tu u-unnuden hu intugun Apu Dios, ey mahapul ni mambeyyad ni multa tu, anin ni eleg tu igeb-at humman ni nanliwatan tu. ");
INSERT INTO ify_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Mahapul ni illaw tun padi hu hakey ni lakkitun kalneroh et iappit ni padi, tep ya liwat nunman ni tuu. Mahapul ni endi dipektoh ni nunman ni i-appit tu ey ustuh hu balol tu. Mei-appit humman ni kalneroh ma-lat ma-kal hu liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Humman ni mei-appit ey bayad ni nanliwatan nunman ni tuu nan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Hedin nanliwat hu hakey ni tuun hi-gak e Apu Dios, tep nan-itek e kantuy netalak winu netakew etan impatelun edum tun hi-gatu winu nan-itek winu sinekew tu humman ni impatelu dan hi-gatu, ");
INSERT INTO ify_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","winu hedin kantu et himmak tu hu sinlak ni edum tu, nem ay insapatah tu e kantuy endi himmak tu, winu wada edum ni hanniman ni impahding tun pambehhulan tu, ey mahapul ni heninnuy ida pehding tu: ");
INSERT INTO ify_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Mahapul ni ibbangngad tu hu hipan inla tu tep ya itek tu, yadda pinilit tun inlad edum tun tuu, winu hipan sinekew tu, anin yadda impatelu dan hi-gatu winu indinel idan edum tun hi-gatu, winu netalak et hamaken tu, ");
INSERT INTO ify_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","winu inggeb-at tun inla, nem nan-itek. Mahapul ni ibbangngad tudda humman niya mambeyyad ni dewampulun porsentoh etan ni tuun nengipahdingan tun nunman ni bahul ni nunman ni aggew ni pan-appitan tu tep ya liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","7","Mahapul ni illaw etan ni nambahul etan ni padi hu kamei-appit tep ya liwat, e ya lakkitun kalneroh ni endi dipektoh tu et iappit tun hi-gak e Apu Dios. Hedin beken, ey ya pihhu hu i-ali tu, meippuun di kameunnud ni balol nunman ni animal ma-lat ma-kal hu liwat nunman ni tuu.” ");
INSERT INTO ify_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Entanni ey kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Itugun mun Aaron et yadda lalakkin u-ungnga tu eyadda meunnud ni pan-appitan ni kagihheba. Ya kamei-appit ni kagihheba ey mahapul ni meihha-ad di altar ni hanlabbi ingganah ni kakkabbuhhan, niya mahapul ni mannenneng hu apuy e eleg me-dep. ");
INSERT INTO ify_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Hedin newa-wa ey ihhuklub ni padi etan kayyaggud ni balwasi tu, anin ya etan balwasi tun kamei-dah di nandallem, et linihan tu etan altar e e-kalen tu dep-ul ni neiappit ni kagihheba et iha-ad tud takdul nunman ni altar. ");
INSERT INTO ify_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hedin ginibbuh tu, ey e-kalen tu etan kakkayyaggud ni imbalwasi tu et ihullul tu etan tuka ibbalwasi dedan et ilaw tu etan dep-ul di a-allaw ni kampu, et tu ibbeng etan di puyek ni kameibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ya etan apuy di altar ey mahapul ni eleg me-dep. Mahapul ni ha-adan ni padin ittungu hu altar ni kewa-wa-wa ey iyayyaggud tun ihha-ad diman hu kamei-appit ni kagihheba, et giheben tu taban nunman ni kamei-appit ni pekiddagyuman nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Entan tu liwwan e mahapul nisin mannenneng hu apuy di altar e eleg me-dep. ");
INSERT INTO ify_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Huyyadda meunnud di pan-appitan ni kayyaggud ni alinah: Ellan ni hakey ni padin helag Aaron huyyan kamei-appit nan Apu Dios et ilaw tud hinanggan altar. ");
INSERT INTO ify_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ey um-ala etan padin hanggamal nunman ni alinah ni neha-adan ni mansikan olibah niya insensoh et giheben tud altar. Ya hamuy nunyan kamei-appit ey kamengippeamleng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Ya etan natdaan ni alinah ni neiappit ey meidwat nan Aaron et yadda u-ungnga tu ma-lat kanen da. Kapyaen dan sinapay nem eleg da ha-adin kamampelbag et kanen dad dallin ni Tabernacle. Huyya hu iddawat Apu Dios ni patal idan padi di kamei-appit ni hi-gatun kagihheba. Neieng-eng humman ni kamei-appit henin kai-appit tep ya liwat niya bahul. ");
INSERT INTO ify_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Meidwatan emin hu helag Aaron ni lalakki, anin idan helag tun edum ni aggew, tep humman patal da. Ey emin hu hipan tuun mengeppan nunman ni kennen ey mahapul ni neieng-eng nan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Huyyadda edum ni inhel Apu Dios nan Moses ni meunnud: ");
INSERT INTO ify_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Yan aggew ni kei-eng-engan idan helag Aaron ni mampeddi ey mahapul ni man-appit idan Apu Dios ni hakey ni kiloh ni alinah, henin kamei-appit ni kewa-wa-wa. Mei-appit hu gadwa tu huyya ni kakkabbuhhan ey mei-appit hu gadwa tun mahmahdem. ");
INSERT INTO ify_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Mahapul ni mekamdugan ni mansikan olibah niya meihhe-eng di nepayyad ni palhu niya megennedwa. Ya hamuy tu huyyan kamei-appit ey kamengippeamleng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Emin hu manhinhinullul ni helag Aaron ey huyya i-appit dan ingganah nan Apu Dios etan ni aggew ni kei-eng-engan dan mampeddi. Megihheb huyyan kamei-appit. ");
INSERT INTO ify_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ey eleg mabalin ni an kennen huyyan i-appit idan padi, tep kagihheban emin.” ");
INSERT INTO ify_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Itugun mun Aaron et yadda lalakkin u-ungnga tu eyadda tugun ni meunnud ni pan-appitan da tep ya liwat: Ya etan animal ni kamei-appit tep ya liwat ey neieng-eng nan Apu Dios, et humman hu, mahapul ni keklengen dad hinangga etan ni altar e kapengiklengin kagihheba ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ya etan padin mengi-appit ni nunman ey dammutun kennen tu patal tud dallin ni Tabernacle e neieng-eng daman Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ya etan mengeppa winu meittummuk eyan kamei-appit ey mambalin ni mei-eng-eng nan Apu Dios. Ey ya balwasin mewakgihan ni kuheyaw ni kamei-appit ey mahapul ni ibbalbal etan di neputuk ni pengibbalbalan. ");
INSERT INTO ify_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Hedin pulan banga hu neiheengan ni neiappit ni detag, ey mahapul ni mephik. Hedin giniling ni banga hu neiheengan tu, ey mahapul ni mead-adan et maka-ulahan. ");
INSERT INTO ify_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ebuh ida etan lalakkin u-ungngan padin dammutun mengngan ni nunman ni kamei-appit, tep huyya ey neieng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Nem hedin meippahgep hu kuheyaw etan ni kamei-appit tep ya liwat di Nesantuh ni Kuwaltuh di Tabernacle, ey mahapul ni gihheben hu annel etan ni animal tep eleg mabalin ni kennen. ");
INSERT INTO ify_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Huyyadda hu mahapul ni u-unnuden ni pan-appitan tep ya bahul: Huyyaddan kamei-appit ey mei-eng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mahapul ni mekleng humman ni kamei-appit di kapengiklengin kamei-appit ni kagihheba. Ey meiwwakgih hu kuheyaw tu etan di epat ni dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ey e-kalen ni padi emin taba, ya tabad ikul, emin etan taban wadad kad-an ni egeh tu, ");
INSERT INTO ify_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ya etan dewwan basin et ya taban neilibutan da, niya etan altey tu, ma-lat maiappit di altar. ");
INSERT INTO ify_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Gihheben ni padin emin ida huyyad altar, tep huyya kamei-appit nan Apu Dios tep ya bahul ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ebuh ida etan lalakkin u-ungngan padin mengngan ni nunman ni kamei-appit. Nem mahapul ni yad Tabernacle e kapanha-adin Apu Dios hu pengngannan da, tep humman ni mekkan ey neieng-eng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Nan-ingngeh hu meunnud di kapan-appisi tep ya liwat niya bahul ni tuu e ellan ni padin mengi-appit hu detag ni animal ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Hedin ya dama etan belat ni animal ni kamei-appit ni kagihheba ey ellan ni padin mengi-appit ni nunman. ");
INSERT INTO ify_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ey emin hu kamei-appit ni begah ey ellan etan ni padin nengiappit ni nunman anin ni hipa neiheengan tu. ");
INSERT INTO ify_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nem emin etan begah ni eleg maiheeng ni kamei-appit ni mekkan, e nekamdugan ni mansikan olibah winu eleg, ey meidwat idan padin helag Aaron. ");
INSERT INTO ify_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Huyyadda hu meunnud ni pan-appitan ni tuun pekiddagyuman tun Apu Dios: ");
INSERT INTO ify_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Hedin man-appit hu hakey ni tuun pansalamatan tun Apu Dios, ey i-e-dum tun i-appit hu mahdel niya meingpih ni sinapay ni eleg mekamdugan ni kamampelbag, nem mekamdugan ni mansikan olibah. ");
INSERT INTO ify_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ey dammutun i-e-dum tun i-appit hu sinapay ni mekamdugan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Hanhakkey idan nunyan sinapay hu kamei-appit nan Apu Dios. Ey meidwat ida huyyan kamei-appit etan ni padin mengiwwakgih ni kuheyaw di altar. ");
INSERT INTO ify_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Niya mahapul ni kennen ni emin ni nunman ni aggew hu detag etan ni animal ni kamei-appit ma-lat endi an metdaan. ");
INSERT INTO ify_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Nem hedin man-appit hu hakey ni tuun pengippeang-angan tu e impahding tu insapatah tu, winu inggeb-at tun man-appit, ey eleg mahapul ni kennen ni emin etan detag ni nunman ni aggew. Anin ni kennen dan kewa-waan tu hu natdaan hedin wada. ");
INSERT INTO ify_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nem hedin wada eleg mekkan ni nunman ni meikkadwan aggew, ey mahapul law ni megihheb. ");
INSERT INTO ify_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Tep hedin kennen da etan metdaan ni katlun aggew, ey eleg law ebbulutan Apu Dios humman ni in-appit etan ni tuu et endi law silbitu, tep meibbillang law ni beken ni malinih. Ey ya etan tuun mengngan ni nunman ey heltapen tu hu ligat ni meippahding ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Hedin wada keittummukan etan ni detag ni kameibbillang ni beken ni malinih, ey eleg mabalin ni kennen humman ni detag, tep pi-yew, et mukun mahapul ni megihheb. Nem yadda etan edum ni detag ni neiappit ni nunman, ey dammutun kennen etan ni tuun kameibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ey ya etan tuun kameibbillang ni beken ni malinih, nem mengngan ni detag ni neiappit ni pekiddagyuman idan tuun Apu Dios, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ya etan tuun kinepa tu hu hipan eleg meibbillang ni malinih, anin ni ya tuu winu animal winu hipan kameibbillang ni beken ni malinih, nem kinan tu etan detag ni neiappit, ey eleg law meibbillang ni tuun Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ehel muddan helag Israel e eleg da kenna taban baka, ya kalneroh et ya gelding. ");
INSERT INTO ify_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ey eleg da kenna hu taban animal ni netey winu pintey idan animal di muyung, nem dammutun meussal di edum ni kei-ussalan tu. ");
INSERT INTO ify_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ya etan tuun mengngan ni taban etan ni kagihheban kamei-appit nan Apu Dios ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Yadda helag Israel ey eleg mabalin ni da kennen hu kuheyaw ni animal winu sisit, anin ni di attu pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ya etan eleg mengu-unnud ni nunya ey eleg law meibbillang ni tuun Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Itugun muddan helag Israel e kammuy: Ya etan tuun man-appit ni pekiddagyuman ey i-ali tu edum ni kamei-appit nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Tetngeden etan ni tuu humman ni kagihheban kai-appit ni taba et ya pagew ni animal et ita-gey tun peang-ang nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ey gihheben ni padi humman ni tabad altar, nem ya etan pagew ey meidwat idan padi e hi Aaron et yadda u-ungnga tun lalakki. ");
INSERT INTO ify_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Anin etan wannan ni ulpun animal, ");
INSERT INTO ify_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","34","et meidwat etan ni padin nengiwakgih ni kuheyaw niya nengiheb etan ni taban kamei-appit di altar. Tep ya etan pagew et ya wannan ni ulpu ey iddawat Apu Dios idan padi. Humman hu lebbeng tun meidwat ni ippatal idan helag Israel ni hi-gadan papaddid i-appit dan pekiddagyuman dan Apu Dios. Mahapul ni meunnud huyyan olden ni ingganah. ");
INSERT INTO ify_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Huyya hu meidwat ni patal idan papaddin u-ungngan Aaron anin idan helag dan edum ni aggew. Netudun patal da huyya neipalpu eman ni neputukan dan mampeddi et mansilbiddan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yan nunman ni aggew ni neputukan dan mampeddi ey in-olden Apu Dios idan helag Israel e iddawat da huyyan patal idan padi, et yadda helag dallin edum ni aggew. Mahapul ni meunnud huyyan olden ni ingganah. ");
INSERT INTO ify_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Huyyadda meunnud ni pan-appitan ni kagihheba, ya pan-appitan ni begah, ya pan-appitan tep ya liwat, ya pan-appitan tep ya bahul, ya pan-appitan ni pampeddian niya pan-appitan ni pekiddagyuman nan Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Intugun nan Apu Dios ida huyyan Moses di eleg mebebleyid Duntug e Sinai eman ni nengioldenan tuddan tutu-u tun helag Israel e man-appit idan hi-gatudman. ");
INSERT INTO ify_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Kan Apu Dios nan Moses ni nunman ey ");
INSERT INTO ify_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ilaw mu hi Aaron et yadda lalakkin u-ungnga tud heggeppan di Tabernacle. Itebin da hu balwasi dan balwasin padi, ya lanan kameussal ni neputuk ni mansilbin Apu Dios, ya kilaw ni lakkitun bakan kamei-appit tep ya liwat, ya dewwan lakkitun kalneroh et ya sinapay ni eleg meha-adan ni kapampelbag ni neiha-ad di agyag. ");
INSERT INTO ify_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ey ayagim idan emin hu bimmebley, et umliddadman di heggeppan di Tabernacle.” ");
INSERT INTO ify_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Inu-unnud Moses humman ni inhel Apu Dios ni hi-gatu, et yan neamungan idan tuu ");
INSERT INTO ify_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ey kantun hi-gaday “Adyah e ippahding ku hu inhel nan Apu Dios!” ");
INSERT INTO ify_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Et ilaw tu hi Aaron et yadda lalakkin u-ungnga tud hinanggaddan tuu, et ipahding tun hi-gada hu elaw ni panlinnih. ");
INSERT INTO ify_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Impebalwasi tun Aaron etan kaibbalwasin padi et pambalkeh tu. Ey impehuklub tu etan ephod e humman hu kamanta-pew ni kamei-dah ni balwasin padi, et pebalkeh tu etan balkeh ni neabel et mangnged nunman ni ephod. ");
INSERT INTO ify_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Niya inha-ad tu etan kameittekkap ni luput di pagew et ihudu tudman etan Urim et ya Thummim. ");
INSERT INTO ify_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Impapnget tun Aaron etan penget et itekap tu etan balituk ni medal di hinanggan nunman ni penget. Humman ni tu impahding ey neiunnud etan di inhel Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ey inla Moses etan lana et wakgihan tu etan Tabernacle niyadda emin hu wadadman ma-lat maieng-eng idan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Inwakgih tu etan lana ni neminpittud altar anin idan hipan kameussal diman, henin besen niya etan neipetukan tu et mei-eng-eng ida. ");
INSERT INTO ify_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Et duyagan tun lana hu ulun Aaron et maieng-eng daman Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Inlaw tudda dama hu lalakkin u-ungngan Aaron di hinanggan Tabernacle, et pebalwasi tu etan balwasi da ey impebalkeh tu balkeh da et papnget tu penget da, e inu-unnud tu hu intugun Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Negibbuh humman et iappit Moses hu lakkitun baka tep ya liwat. Inta-pew nan Aaron niyadda u-ungnga tu hu ngamay dad ulun nunman ni baka ");
INSERT INTO ify_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","et han kelengan Moses. Immalan kuheyaw nunman ni baka et itdek tu kimeng tu et ida-nih tu etan di epat ni ha-duk ni dimmewdew ni dugun altar ma-lat ipahding tu hu elaw ni panlinnih. Et iduyag tu etan edum ni kuheyaw di hengeg ni altar ma-lat maieng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Inlan Moses emin hu taban neikuyeput di egeh niya etan ni altey, et ya etan dewwan basin niyadda neikuyeput ni taba et giheben tuddan emin di altar. ");
INSERT INTO ify_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Et alen tudda etan natdaan ni parteh ni baka e humman ida hu belat, yadda laman, et yadda kinan tu et tu giheben idan emin di a-allaw ni kampu, tep humman hu inhel Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Impeang-ang mewan nan Moses hu lakkitun kalneroh ni i-appit tun kagihheba. Et ita-pew nan Aaron niyadda lalakkin u-ungnga tu hu ngamay dad ulun nunman ni kalneroh, ");
INSERT INTO ify_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","et kelengen Moses. Tinaya tu etan kuheyaw et iwakgih tuddad dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Sinenegteg tu humman ni kalneroh et giheben tudda etan edum ni laman ni netegteg. Anin etan ulu et yadda taba et nekigiheb tu. ");
INSERT INTO ify_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Inulahan tu egeh et yadda heli et pakigiheb tud altar. Ya kayyaggud ni hamuy ni nunman ni neiappit ni kagihheba ey kamengippeamleng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Entanni ey impeang-ang nan Moses nan hi Apu Dios etan meikkadwan lakkitun kalneroh ni mekleng ni pampeddian di Aaron et yadda lalakkin u-ungnga tu. Inta-pew da ngamay dad ulun kalneroh ");
INSERT INTO ify_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","et kelengen nan Moses. Immalan kuheyaw et ha-adi tud wannan ni tangilan Aaron, et yad wannan ni am-ama-an ni ngamay tu niyad helitu. ");
INSERT INTO ify_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Et ha-adi tudda dama kuheyaw etan di wannan ni tangiladdan lalakkin u-ungngan Aaron, et yad wannan ni am-ama-an ni ngamay da niyad heli da. Et iwakgih tu etan edum ni kuheyaw di dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Inla tudda emin hu taba, anin taban neikuyeput di egeh niya etan ni altey, et ya etan dewwan basin niyadda neikuyeput ni taba, ya taban ikul tu et ya wannan ni ulpu tu. ");
INSERT INTO ify_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ey immalan tellun klasih ni sinapay ni neieng-eng nan Apu Dios, e hakey ni sinapay ni eleg meha-adan ni kamampelbag, ya hakey ni sinapay ni neha-adan ni mansikan olibah et ya meingpih ni sinapay, et ita-pew tuddad taba et yad wannan ni ulpun kalneroh. ");
INSERT INTO ify_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Impatnged Moses emin ida huyyan Aaron niyadda lalakkin u-ungnga tu et ita-gey dan impeang-ang nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Inla mewan Moses ida humman et ita-pew tuddad kamei-appit ni kagihhebad altar et giheben tu. Humman hu kamei-appit ni pampeddian di Aaron et yadda u-ungnga tu. Ya hamuy idan nunman ni neiappit ey kamengippeamleng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Entanni ey inlan Moses hu pagew et ita-gey tun impeang-ang nan Apu Dios. Humman hu patal Moses etan di lakkitun kalneroh ni neiappit ni pampeddian idan padi. Huyya impahding tu tep inu-unnud tu intugun Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Immala mewan hi Moses ni lana et ya kuheyaw di altar et iwakgih tud Aaron et yadda u-ungnga tu et yad balwasi da. Henin nunya impahding tu ma-lat maieng-eng idan Apu Dios, anin idan balwasi da. ");
INSERT INTO ify_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kan Moses nan Aaron et yadda u-ungnga tuy “Ilaw yu etan detag di heggeppan di Tabernacle et iheeng yu et kanen yudman. Ey ekan yu etan ida sinapay di basket ni neiappit ni nampadian yu, tep humman intugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Giheb yun emin hu metdaan ni detag et ya metdaan ni sinapay. ");
INSERT INTO ify_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Panha-ad kayu eyad heggeppan di Tabernacle ni pitun aggew ingganah megibbuh hu elaw ni kei-eng-engan yun pampeddian yu. ");
INSERT INTO ify_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Huyyan impahding tayun nunya ey meippuun di intugun Apu Dios ma-lat ka-kalan ni liwat yu. ");
INSERT INTO ify_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mahapul nisin manha-ad kayud heggeppan di Tabernacle ni pitun aggew niya pitun hileng et ipahding yu hu intugun Apu Dios ni pehding yu ma-lat eleg kayu matey.” ");
INSERT INTO ify_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Et u-unnuden nan Aaron et yadda u-ungnga tun emin hu inhel Moses ni intugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Yan newa-waan ni negibbuhan ni neieng-engan di Aaron et yadda u-ungnga tun lalakkin mampeddi ey ineyagan idan Moses, anin ida etan ni kamengipappangngulun helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ey kantun Aaron ey “I-li kan hantoon tun lakkitun baka et ya lakkitun kalneroh ni endi dipektoh da et iappit muddan Apu Dios. I-appit mu etan baka tep ya liwat idan tuu ey hedin ya etan kalneroh, man iappit mun kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ey ehel muddan helag Israel et umi-liddan lakkitun gelding ni mei-appit tep ya liwat da, ya hantoon tun baka et ya kalneroh ni kamei-appit ni kagihheba. Emin ida huyyan mei-appit ey mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ey man-appit idan bulug ni baka et ya lakkitun kalneroh ni pekiddagyuman dan Apu Dios. Unnudan dadda huyyan alinah ni neha-adan ni mansikan olibah. Mahapul ni pehding idan tuu huyya, tep mampeang-ang hi Apu Dios ni hi-gayun nunya.” ");
INSERT INTO ify_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Inlaw idan tutu-ud hinanggan Tabernacle ida humman ni inhel nan Moses et maemung idan menaydayaw nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kan Moses ey “Huyya inhel Apu Dios ni pehding yu ma-lat mampeang-ang ni hi-gayu hu kaumhilin dayaw tu.” ");
INSERT INTO ify_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Et kan Moses nan Aaron ey “Lakkay di altar et man-appit ka tep ya liwat, ey man-appit kan kagihheba ma-lat ma-kal liwat mu et ya liwat idan tuu. Ipahding mu huyya meippuun di intugun Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Et lumaw hi Aaron di altar et kelengen tu etan hantoon tun bakan kamei-appit tep ya liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Indawat idan u-ungnga tun laki hu kuheyaw, et itdek tu kimeng tu et ida-nih tuddad heni ha-duk ni dimmewdew di dugun altar, et iduyag tu etan natdaan ni kuheyaw di hengeg ni altar. ");
INSERT INTO ify_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Giniheb tudman di altar hu taba, yadda basin et ya altey ni neiappit tep ya liwat e inu-unnud tu intugun Apu Dios ni inhel Moses. ");
INSERT INTO ify_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nem tu giniheb di a-allaw ni kampu etan ida detag et ya belat. ");
INSERT INTO ify_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Negibbuh humman et kelengen Aaron etan i-appit tun kagihheba, et idwat idan lalakkin u-ungnga tu hu kuheyaw nunman ni animal et iwakgih tuddad dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ey hinakkehakkey dan indawat ni hi-gatu etan ida negenedged ni detag, anin ya ulu et giheben tuddad altar. ");
INSERT INTO ify_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Inulahan tudda wadad egeh et yadda heli et giheben tudda etan di altar. ");
INSERT INTO ify_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Negibbuh humman et peang-ang tu etan gelding ni kamei-appit tep ya liwat idan tuu et kelengen tu, henin impahding tu etan ni neiappit tep ya liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","In-appit tu humman ni kagihheba e inu-unnud tu hu kameunnud ni kapan-appisi. ");
INSERT INTO ify_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Et hantu peang-ang etan kamei-appit ni begah e gimmamal, et pakigiheb tud altar e in-edum tudda etan di edum ni kamei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Kinleng tu etan bulug ni baka niya etan lakkitun kalneroh ni kamei-appit ni pekiddagyuman idan tuun nan Apu Dios. Indawat idan lalakkin u-ungnga tu etan kuheyaw idan nunman ni animal et iwakgih tuddad dingding ni altar. ");
INSERT INTO ify_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","21","Inta-gey tudda etan pagew et ya ulpu et peang-ang tuddan Apu Dios meippuun di inhel Moses ni pehding tu. Inta-pew tuddadman etan ida taban lakkitun baka, ya taban lakkitun kalneroh, ya taban ikul da, ya tabad kad-an ni egeh da, yadda basin da niya altey da ma-lat giheben tuddad altar. ");
INSERT INTO ify_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Negibbuh humman et ita-gey tu hu ngamay tud hinanggaddan tuu et bendisyonan tudda et han melehbeng e nalpu etan di altar. ");
INSERT INTO ify_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Et humgep di Moses nan Aaron di Tabernacle. Entanni ey immehep ida et bendisyonan dadda etan tutu-u, ey nampeang-ang hu kaumhilin dayaw Apu Dios ni hi-gadan emin. ");
INSERT INTO ify_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ey pinhakkeyey impaelin Apu Dios hu kamantetebbel ni apuy, et giheben tun emin etan ida neiappit ni kagihheba et yadda tabad altar. Inang-ang idan tuu humman ey ida kamantetekkuk ni amleng da et lumukbub idad puyek. ");
INSERT INTO ify_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hedin di Nadab nan Abihu e u-ungngaddan Aaron ni laki ey inla da etan pengiggihheban ni bangbanglun insensoh, et ha-adan dan ngalab et wakgihan dan insensoh et peang-ang dan Apu Dios. Huyyan impahding da ey eleg da u-unnuden hu intugun Apu Dios ni pehding dan mengihheb ni insensoh. ");
INSERT INTO ify_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Et humman hu, endi maptek ey impaelin Apu Dios hu apuy et matey idad hinangga tu. ");
INSERT INTO ify_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kan Moses nan hi Aaron ey “Huyya hu pinhed Apu Dios ni e-helen etan di kantun ‘Mahapul ni emin ida mansilbin hi-gak ey amtaen da e kayyagguddak ni peteg niya meiddeyyawwak idad tuuk.’” Nem kapakdag Aaron hu i-ineng. ");
INSERT INTO ify_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ineyagan nan Moses di Mishael nan Elsaphan e u-ungngaddan Ussiel, e agin a-ammed Aaron, et kantun hi-gaday “Ekal yu annel ida eyan dewwan agi yu eyad yuka pandaydayawi et ilaw yuddad a-allaw ni kampu” ");
INSERT INTO ify_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Immalidda et itnged dad balwasi etan idan netey et iguyud daddad a-allaw ni kampu e inu-unnud da hu inhel Moses ni pehding da. ");
INSERT INTO ify_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Entanni ey kan Moses nan Aaron et yadda u-ungnga tu e di Eleasar nan Ithamar ey “Hagu yu bewek yu niya entan tu bi-ki balwasi yu ma-lat eleg yu peang-ang e kayu kaumlelemyung. Tep hedin peang-ang yu lemyung yu, man mettey kayu ey illagat Apu Dios idan emin hu helag Israel tep ya bunget tu. Nem yadda edum tayun helag Israel ey dammutun peang-ang da lemyung da, tep ya neteyyan ida eyan dewwan pintey Apu Dios ni apuy. ");
INSERT INTO ify_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ey entan tu hi-yan eya heggeppan di Tabernacle, tep neieng-eng kayun pangngunnun Apu Dios neipalpun neduygan ni ulu yun lana.” Et u-unnuden da humman ni intugun Moses ni pehding da. ");
INSERT INTO ify_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Entanni ey kan Apu Dios nan Aaron ey ");
INSERT INTO ify_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Eleg mabalin ni kayu umhegep idan helag mu eyad Tabernacle e kad-an ku, hedin imminum kayun kaumbuteng, tep hedin hanniman pehding yu, man mettey kayu. Mahapul ni u-unnuden idan helag mun ingganah huyyan olden. ");
INSERT INTO ify_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ey mahapul ni amtaen yu hedin hipadda etan neieng-eng ni hi-gak niya hedin hipa kei-ussalan da. Niya mahapul ni amtaen yu hu kameibbillang ni malinih niyadda etan kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ey mahapul ni ituttuddum idan helag Israel ni emin hu intugun kun inhel kun Moses.” ");
INSERT INTO ify_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Entanni ey kan Moses nan Aaron et yadda etan ni dewwan u-ungnga tun di Eleasar nan Ithamar ey “Aleyu etan natdaan ni alinah ni neiappit nan Apu Dios et kapyaen yun sinapay. Nem entan tu kamdugin kamampelbag. Ey ekan yud takdul ni altar tep neieng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mahapul ni kennen yudda humman di kad-an ni neieng-eng ni lugal, tep humman ni mekkan ni kamei-appit ni hi-gatu hu patal yu ey patal ida daman helag yu. Huyya tugun tun e-helen kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nem dammutun kennen yudda pagew niya ulpun neipeang-ang nan Apu Dios di attun kameibbillang ni malinih. Tep patal yun emin idan helag yun lalakki et yadda bibi-i humman ni i-appit idan edum yun helag Israel ni pekiddagyuman dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Humman idan ulpu et ya pagew ey meillaw di altar e pengiggihheban ni taba et meita-gey ni meippeang-ang nan Apu Dios. Ey huyyadda patal yu et yadda helag yun ingganah meippuun di intugun tu.” ");
INSERT INTO ify_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Minahmahan Moses hedin hipa neipahding etan ni gelding ni neiappit ni ke-kalan ni liwat, et yan nengamtaan tun negiheb ey imbunget tud Eleasar nan Ithamar e natdaan ni u-ungngan Aaron. ");
INSERT INTO ify_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Kantun hi-gaday “Kele eleg yu kanen di dallin ni Tabernacle humman ni neiappit ni ke-kalan ni liwat? Tep humman ni neiappit ey neieng-eng nan Apu Dios. Indawat tun hi-gayu ma-lat iappit yun ke-kalan ni liwat idan tuu. ");
INSERT INTO ify_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Eleg yu ihgep hu kuheyaw nunman ni neiappit di bawang ni Tabernacle. Et humman hu, gullat et, kinan yud dallin. Kaw eggak itugun e hanniman pehding yu?” ");
INSERT INTO ify_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Hinumang Aaron ey kantuy “Tam nan-appit ida tuun nunya nan Apu Dios ni ke-kalan ni liwat da niya nan-appit idan kagihheba. Nem bimmunget damengu hi Apu Dios et pateyen tudda dewwan u-ungngak. Kaw kammu nem um-amleng hi Apu Dios hedin kinan kun nunya hu detag ni neiappit ni ke-kalan ni liwat?” ");
INSERT INTO ify_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Dingngel Moses humman ni inhel Aaron ey inebulut tu. ");
INSERT INTO ify_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kan Apu Dios di Moses nan hi Aaron ey “Ehel yuddan ");
INSERT INTO ify_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","edum yun helag Israel e yadda hu animal ni dammutun kennen da ");
INSERT INTO ify_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ey yadda etan negadwa kukub da niya daka pennidwaan galgala hu kinan da. ");
INSERT INTO ify_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Nem eleg mabalin ni kennen yu kamel, ya badger niya rabbit, tep ma-nut daka pennidwaan galgala hu kinan da, nem eleg megadwa kukub da winu heli da. Et humman hu, eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Entan tu ekan hu killum, tep ma-nut negadwa kukub da, nem eleg da pennidwaan galgala hu kinan da. Et humman hu, eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Entan tudda ekan huyyan animal ey entan tu kapa annel da hedin netey ida tep eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Hedin yadda mategun wadad danum, ey ebuh ida hu wada lukhip tu niya ipay tun dammutun kennen yu. ");
INSERT INTO ify_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","Entan tu ekan ida endi lukhip tu niya ipay tu, tep eleg ida meibbillang ni malinih. Ey entan tudda kapa hedin netey ida. ");
INSERT INTO ify_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Pidwaek ni e-helen, e eleg mabalin ni yu kennen hu hipan mategun wadad danum ni endi lukhip tu niya ipay tu. ");
INSERT INTO ify_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Yadda sisit ni eleg mabalin ni kennen yu ey ya tulduh, ya akup, ya gawwang, ya falcon, ya kukkuk, ya sisit ni kamengngan ni netey, ya butbut, ya ostrich, ya seagull, ya stork, ya heron, ya pelican, ya cormorant, ya hoopoe, ya panniki niya litlit. ");
INSERT INTO ify_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Emin hu nepayakan ni insect ni epat heli tun kaumkadap ey entan tu ekan, tep eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nem yadda edum ni nepayakan ni insect ni kaumpaytuk ey ida kameibbillang ni malinih et dammutun kennen yudda. ");
INSERT INTO ify_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Henin dudun, ya cricket niya taggunnay. ");
INSERT INTO ify_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Nem yadda edum ni nepayakan, nem ida kaumkadap ey entan tudda ekan, tep eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ya tuun nengapan netey ni annel idan nunyan animal ey meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Hedin gegliden ni tuu annel idan nunyan animal, ey mahapul ni pepu-ut tun balbalan balwasi tu, nem mannenneng ni meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Yadda netey ni animal ni eleg megadwa kukub da winu eleg da pennidwaan galgala hu kinan da ey eleg ida meibbilang ni malinih. Et ya etan tuun mengeppan annel da ey meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Yadda netey ni animal ni epat heli dan wada kimeng da ey eleg ida meibbilang ni malinih, et ya etan tuun mengeppan annel da ey meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Hedin pini-dit winu ginlid ni hakey ni tuu hu netey ni animal, ey mahapul ni pepu-ut tun balbalan hu balwasi tu, nem mannenneng ni meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Emin hu moles, ya utut, ya kallulu, ya kutkutli niya silay ey eleg ida meibbilang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Et ya etan tuun mengeppaddan nunman anin ni mategudda winu netey ida ey meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Meibbillang daman beken ni malinih hu hipan ke-gahan da hedin netey ida, henin keyew, ya luput, ya lalat, ya langgusih, winu hipan kameussal. Et humman hu, mahapul ni meitta-mel idad danum, nem eleg ida damengu meibbillang ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Hedin na-gah hu netey ni annel dad pulan banga ey meibbillang ni beken ni malinih anin ya neihududman. Et humman hu, mahapul ni pephiken yu humman ni banga. ");
INSERT INTO ify_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Yadda kennen ni neduyagan ni danum ni neiha-ad diman ni banga ey entan tu ekan tep meibbillang law ni beken ni malinih. Ey eleg mabalin ni innumen yu hu danum ni neiha-ad diman tep meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anin ni pugun ni kapengihhe-engin sinapay winu banga et hedin na-gahan ni netey ni annel idan nunman ey meibbillang ida law ni beken ni malinih. Et humman hu, mahapul ni bahbahen yudda. ");
INSERT INTO ify_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nem hedin hebwak winu tangkih ni danum hu na-gahan idan nunman ni netey ey nanengtun meibbillang ni malinih etan danum, nem ya etan tuun an mengkal hu meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Hedin na-gahan idan nunman ni netey hu bukel ni meitnem ey nanengtun meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nem hedin neita-mel etan bukel ey na-gahan idan nunman ni netey ey meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ya etan animal ni dammutun kennen ey meibbillang ni beken ni malinih hedin netey. Et humman hu, ya etan tuun mengeppan netey ni annel tu ey eleg meibbillang ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ya etan tuun mengngan winu mengnged ni nunman ey mahapul ni ibbalbal tu balwasi tu, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","Eleg mabalin ni kennen yudda kamambinulluh winu kamangkinaddap di puyek ni epat winu dakel heli tu tep eleg ida meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Entan tudda ekan humman ma-lat eleg kayu maibilang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Entan tudda nisi kapa niya entan tudda ekan humman ni kamambinulluh winu kamangkinaddap di puyek ma-lat eleg kayu mambalin ni beken ni malinih. Tep hi-gak e Ap-Apu e Dios yu ey kayyagguddak ni peteg. Et humman hu, mahapul ni kayyaggud kayu daman peteg. ");
INSERT INTO ify_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Hi-gak e Ap-Apu hu nengipengulun hi-gayun neni-yanan yun Egypt, ma-lat hi-gak hu daydayawen yun Dios yu. Et humman hu, mahapul ni kayyaggud kayu e endi yu pehding ni lawah, tep hi-gak ey kayyagguddak ni peteg. ");
INSERT INTO ify_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Huyyadda meunnud ni tugun meippanggep ni animal, yadda sisit, yadda mategun wadad danum, yadda kamangkinaddap, yadda kamambinulluh niyadda kamandinallan di puyek. ");
INSERT INTO ify_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Mahapul ni paka-ang-angen yu hedin hipadda dammutun kennen yun kameibbillang ni malinih niyadda eleg mabalin ni kennen yun eleg meibbillang ni malinih.” ");
INSERT INTO ify_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Immehel mewan hi Apu Dios nan Moses ey kantuy: Yaddahhuy hu meunnud ni pan-ungngaan idan biin helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Hedin newad-an hu hakey ni bii et man-ungngan laki, ey meibbillang ni beken ni malinih ni pitun aggew henin kaelliin kamelpud annel tun kabulabulan. ");
INSERT INTO ify_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ya etan gelang ey mahapul ni mekuggit ni meikkewwalun aggew tu. ");
INSERT INTO ify_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ey meibbillang ni beken ni malinih ni hambulan et tellun aggew tep ya kuheyaw ni impakewah tun nan-ungngaan tu. Eleg ni mabalin ni tu keppaen ida kameussal di kapandeyyawi niya eleg mabalin ni an umhegep diman ingganah megibbuh pengippahdingan tun elaw ni panlinnih ni annel. ");
INSERT INTO ify_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Hedin bii in-ungnga tu, ey meibbillang ni beken ni malinih ni dewwan lingguan, henin kaelliin kamelpud annel tu. Ey hehgeden tu dewwan bulan et enem ni aggew et han dammutun ippahding tu elaw ni panlinnih ni kuheyaw tep ya nan-ungngaan tu. ");
INSERT INTO ify_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Hedin negibbuh hu nengipahdingan tun elaw ni panlinnih etan ni in-ungnga tun laki winu bii, ey mahapul ni illaw tu etan ni padi hu hantoon tun kalneroh di heggeppan di Tabernacle et iappit tun kagihheba nan Apu Dios. Ey illaw tu hu hakey ni paluma winu balug et iappit tu tep ya liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ellan etan ni padi humman et iappit tu, et han dammutun meibbillang ni malinih etan bii. Huyyadda hu mahapul ni pehding ni bii hedin negibbuh ni nan-ungnga. ");
INSERT INTO ify_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nem hedin newetwet etan bii et eleg tu hanggela hu kalneroh, ey dammutu hu dewwan paluma winu dewwan balug. Mei-appit hu hakey ni kagihheba ey mei-appit hu hakey tep ya liwat tu. Huyya pehding ni padin man-appit ma-lat dammutu mewan ni meibbillang ni malinih etan bii.” ");
INSERT INTO ify_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kan Apu Dios di Moses nan hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Hedin wada hakey ni tuun wada simmemel di belat tun anggetakkut ni gulid winu pelha winu wada limmebag di belat tu, winu mablah belat tu, ey ilaw yu padi e hi Aaron winu hakey ni helag tu. ");
INSERT INTO ify_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mahapul ni ang-angen ni padi humman ni gulid et hedin bimmelah hu bewek etan di belat ni negulid niya himmalem, ey anggetakkut humman ni degeh et mahapul ni e-helen ni padi e meibbillang humman ni tuun beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Nem hedin eleg humelem etan nebebla ey eleg bumlah hu bewek, ey appilen ni ebuh ni padi humman ni tuun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Et hedin nedatngan hu meikkeppitun aggew, ey ang-angen mewan ni padi humman ni tuu et hedin eleg maihinap etan gulid di annel tu, ey appilen tun pitu pay ni aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ey ang-angen mewan ni padin kapitun aggew et hedin napwahan, ey e-helen ni padi e meibbillang ni malinih humman ni tuu, tep gulid ni ebuh humman. Nem mahapul ni ibbalbal etan ni tuu balwasi tu et han maibilang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Nem hedin meibbangngad humman ni gulid tu et meihhinnap, ey mahapul ni an mampeang-ang mewan etan ni padi. ");
INSERT INTO ify_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Et hedin neihinap, ey e-helen tu e meibbillang ni beken ni malinih humman ni tuu niya e-helen tu e anggetakkut humman ni gulid tu, tep kamei-tan. ");
INSERT INTO ify_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Emin hu tuun wada gulid tun kamei-tan ey mahapul ni an mampeang-ang ni padi. ");
INSERT INTO ify_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Et hedin ang-angen tu ey limmebag niya nebebla ey bimmelah bewek diman, ");
INSERT INTO ify_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ey humman keang-angan tu e kamei-tan humman ni gulid. Et humman hu, e-helen ni padi e meibbillang ni beken ni malinih humman ni tuu. Et eleg law mahapul ni appilen tu ma-lat ang-ang-angen tu, tep nanna-ud ni meibbillang ni beken ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","13","Nem hedin napwahan etan gulid tu et ebuh law piklat ni wada, ey e-helen ni padi e kantuy ‘Meibbillang ka law ni malinih.’ ");
INSERT INTO ify_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","15","Nem hedin meibbangngad hu nebeblad annel tu, ey e-helen ni padi e kantuy ‘Leprosih huyya, meibbillang kan beken ni malinih.’ ");
INSERT INTO ify_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nem hedin napwahan humman ni nebebla, et mambangngad hu ang-ang dedan etan ni belat etan ni tuu, ey mahapul ni umlaw di kad-an ni padi ");
INSERT INTO ify_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ma-lat ang-angen tu mewan. Et hedin kayyaggud law etan belat ni tuu, ey e-helen ni padi e dammutu law ni meibbillang ni malinih etan tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Hedin wada hakey ni tuun napwahan hu pelha tu, ");
INSERT INTO ify_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nem entanni ey wada kamanlelbag ni mablah ang-ang tu winu wada kamandadalang niya mablah ni neihullul ni simmemel di kad-an lan pelha, ey mahapul ni umlaw etan tuud kad-an ni padi, et tu peang-ang hedin hipa humman. ");
INSERT INTO ify_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Hedin ang-angen ni padi ey himmalem niya bimmelah hu bewek diman, ey e-helen tu e meibbillang humman ni tuun beken ni malinih, tep kamei-tan humman ni degeh ni belat. ");
INSERT INTO ify_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nem hedin eleg bumlah hu bewek etan di limmebag niya eleg humelem et lektattuy neumah, ey mahapul ni appilen ni padi humman ni tuun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Et hedin yan nunman ni pitun aggew ey neihinap etan mablah di annel tu, ey mahapul ni e-helen ni padi e meibbillang ni beken ni malinih humman ni tuu, tep kamei-tan hu degeh tu. ");
INSERT INTO ify_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Nem hedin eleg maihinap e nepiklatan ni ebuh, ey e-helen ni padi e meibbillang ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Hedin neatungan etan belat ey bimmelah winu dimmalang hu petek ni neatungan, ");
INSERT INTO ify_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ey mahapul ni tu peang-ang ni padi. Et hedin ang-angen tu ey bimmelah hu bewek diman niya himmalem humman ni neatungan, ey meibbillang ni beken ni malinih humman ni tuu, tep kamei-tan humman ni degeh ni belat tu. ");
INSERT INTO ify_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Nem hedin eleg bumlah hu bewek etan di neatungan niya kamangkeibbangngad hu ang-ang dedan ni belat tu, ey appilen ni padin pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ang-angen tu mewan ni meikkeppitun aggew, et hedin kamangkeihhinnap mewan etan nebeblad annel etan ni tuu, ey e-helen ni padi e eleg meibbillang ni malinih humman ni tuu, tep kamei-tan humman ni degeh ni belat tu. ");
INSERT INTO ify_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nem hedin napwahan etan nebebla, nem neatungan ni ebuh et mepiklatan, ey humman keang-angan tu e eleg mei-tan humman ni degeh. Et e-helen ni padi e meibbillang ni malinih etan ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ya etan laki winu biin wada nebeblad ulu tu winu pangal tu, ");
INSERT INTO ify_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ey mahapul ni ang-angen ni padi, et hedin himmalem niya himmin-appil hu ang-ang ni bewek diman, ey e-helen ni padi e meibbillang ni beken ni malinih humman ni tuu, tep kamei-tan humman ni degeh tu. ");
INSERT INTO ify_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nem hedin ang-angen ni padi ey beken ni hanniman, mahapul ni appilen tun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ey ang-angen mewan ni padin meikkeppitun aggew, et hedin eleg maihinap ey eleg humelem niya hedin eleg humin-appil hu ang-ang ni bewek diman, ");
INSERT INTO ify_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ey mahapul ni memukmukan humman ni tuu, nem eleg tu kep-uhi hu bewek di pettek ni nebebla. Ey appilen tu mewan ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Hedin nedatngan hu meikkeppitun aggew, ey ang-angen mewan ni padi et hedin eleg maihinap niya eleg humelem, ey e-helen tu e meibbillang ni malinih humman ni tuu. Ey mahapul ni ibbalbal etan ni tuu balwasi tu ma-lat maibilang ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nem hedin neibangngad etan nebebla et neihinap, ");
INSERT INTO ify_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ey mahapul ni pidwaen mewan ni padin ang-angen, et hedin tu-wangun neihinap hu nebebla ey e-helen tu e beken ni malinih humman ni tuu, anin ni eleg humin-appil hu ang-ang etan ni bewek. ");
INSERT INTO ify_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nem hedin ang-angen ni padi ey eleg maihinap etan nebebla, tep napwahan ey kamemmel hu bewek diman, ey e-helen ni padi e meibbillang ni malinih etan tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Hedin wadadda simmemel ni mangkablah di belat ni laki winu bii, ");
INSERT INTO ify_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ey mahapul ni ang-angen ni padi, et hedin beken ni mablah ni peteg, ey e-helen ni padi e meibbillang ni malinih etan tuu tep eleg mei-tan humman ni degeh. ");
INSERT INTO ify_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Anin ni nemukmukan hu hakey ni tuu tep naplag bewek tu, et meibbillang ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Nem hedin wada simmemel ni mangkadlang ey mablah etan di naplagan ni bewek di ulu tu, ey kamei-tan humman ni degeh ni belat tu. ");
INSERT INTO ify_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","44","Et mahapul ni ang-angen ni padi humman ni tuu, et hedin tu-wangun wada mangkadlang niya mablah ni gulid di ulu tu, ey e-helen tu e meibbillang ni beken ni malinih humman ni tuu, tep kamei-tan humman ni degeh. ");
INSERT INTO ify_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ya etan tuun wada degeh tun kamei-tan, ey mahapul ni mambalwasin nebi-ki ey eleg tu heggua bewek tu niya hennian tu bungut tu. Ey itekkutekkuk tu hu ‘Beken nak ni malinih! Beken nak ni malinih!’ ");
INSERT INTO ify_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Mannenneng ni meibbillang ni beken ni malinih humman ni tuu ingganah ni me-kal humman ni degeh ni belat tu. Ey mahapul ni meappil et an manha-ad di a-allaw ni kampu et meidawwid edum tun tuu. ");
INSERT INTO ify_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","Hedin bimmuut hu balwasin nekapyad dutdut ni kalneroh winu kayyaggud ni luput, winu kumpulmih ni nekapyad katat niya hedin yadda humman ey meatta winu madmadlangngan, ey humman ida etan kameihhinnap. Et humman hu, mahapul ni ang-angen ni padi. ");
INSERT INTO ify_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Binbinen ni padi humman ni bimmuut ey ellan tu et itlu tun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Hedin nedatngan etan meikkeppitun aggew ey binbinen tu mewan, et hedin neihinap ida humman ni buut, ey meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Et emin ida etan luput winu katat ni wada hanniman ni buut ni kameihhinnap, ey mahapul ni gihheben etan ni padi. ");
INSERT INTO ify_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Nem hedin ang-angen ni padi ey eleg maihinap, ");
INSERT INTO ify_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ey pebalbal tu etan luput et iwaklin tu mewan ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Hedin nedatngan etan nagtud ni aggew et ang-angen tu ey eleg humin-appil hu ang-ang tu, ey anin ni eleg maihinap etan buut et meibbillang ni beken ni malinih. Et humman hu, mahapul ni gihheben anin hedin kantu et wadad beneggan winu hangga-an ni balwasi etan buut. ");
INSERT INTO ify_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nem hedin ang-angen ni padi ey kamangke-kal etan buut ni nengibalbalan da, ey bi-kien tu humman ni nebuutan et ekalen tu. ");
INSERT INTO ify_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Nem hedin mewedda mewan etan buut et meihhinnap, ey mahapul ni gihheben humman ni balwasi. ");
INSERT INTO ify_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nem hedin neibalbal etan luput ey neendi etan buut, ey mahapul ni ippidwan ibbalbal et han maibilang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Huyyadda mahapul ni u-unnuden hedin bimmuut hu luput winu balwasin nekapyad dutdut ni kalneroh winu kayyaggud ni luput winu katat et han dammutun meibillang ni malinih winu beken ni malinih.” ");
INSERT INTO ify_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Huyyadda meunnud ni pengippahdingan ni elaw ni panlinnih hedin na-kal hu degeh ni belat ni kamei-tan. Mahapul ni meillaw nan padi etan tuun na-kal hu henin nunman ni degeh tu, ");
INSERT INTO ify_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ma-lat ilaw tu humman ni tuud a-allaw ni bebley et pakabbinbinen tu. Et hedin makulug ni napwahan hu humman ni degeh ni belat tu, ");
INSERT INTO ify_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ey e-helen ni padi etan ni tuu et i-li tu hu dewwan sisit ni kameibbillang ni malinih ni kamei-appit, ya keyew ni sedar, ya madlang ni sinulid et ya pingin hissop. ");
INSERT INTO ify_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ey immandal ni padi e keklengen da etan hakey ni sisit etan di neiteyan pulan mahukung ni duyu ni neha-adan ni pakeahul ni danum di hebwak. ");
INSERT INTO ify_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ey itta-mel ni padi etan di kuheyaw ni sisit ni nakleh hu hakey ni mategun sisit e pekitta-mel tu etan madlang ni sinulid et ya etan keyew ni sedar. ");
INSERT INTO ify_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Niya iwwakgih tu etan kuheyaw ni meminpittu etan ni tuun na-kal degeh tu. Ey han tu inhel etan ni tuu e meibbillang law ni malinih. Hedin ginibbuh ni padi ey peteyyab tu law etan hakey ni sisit di a-allaw ni bebley. ");
INSERT INTO ify_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Humman ni tuun na-kal degeh ni belat tu ey mahapul ni ibbalbal tu balwasi tu niya kep-uhan tu emin hu bewek di annel tu, anin ni iming tu, et han pan-emeh et han maibilang ni malinih. Et han dammutu law ni umhegep di kampu, nem eleg ni umhegep di baley dan pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Yan meikkeppitun aggew ey kep-uhan tu mewan ni emin hu bewek di annel tu, ya bewek di ulu tu, ya iming tu niya kidey tu. Ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh et han law maibilang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Yan meikkewwalun aggew ey um-i-li humman ni tuun dewwan hantoon dan lakkitun kalneroh et ya hakey ni labah ni kalneroh ni endi dipektoh da, ya nehuluk ni dewwan kiloh ni kayyaggud ni alinah ni nekamdugan ni mansikan olibah, et ya hambasuh ni mansikan olibah. ");
INSERT INTO ify_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ey illaw ni padi etan tuu et yadda i-appit tud heggeppan di Tabernacle di kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ellan ni padi hu hakey etan ni kalneroh, et ya hambasuh ni mansika et ita-gey tu et peang-ang tun Apu Dios et maiappit tep ya bahul. ");
INSERT INTO ify_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Keklengen tu humman ni kalneroh etan di kapengiklengin kamei-appit tep ya liwat niya kamei-appit ni kagihheba. Humman ni kalneroh ni kamei-appit tep ya bahul ey meidwat idan padi, henin kamei-appit tep ya liwat. Humman ida ey neieng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Hedin negibbuh ni kinleng ni padi, ey um-alan kuheyaw nunman ni kalneroh, et ha-adan tu wannan ni tangilan nunman ni nan-appit, ya am-ama-an ni wannan ni ngamay tu et ya heli tu ma-lat maibilang law ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Um-ala mewan etan padin lanan olibah et iduyag tud willin tepayya tu ");
INSERT INTO ify_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","et itdek tu wannan ni ledledengngan tu et iwakgih tun meminpittud hinanggan Tabernacle e kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ey ihha-ad ni padi etan edum ni natdaan ni lanan olibah etan idad neha-adan ni kuheyaw e yad wannan ni tangilan nunman ni nan-appit, yad wannan ni am-ama-an ni ngamay tu niya heli tu et maibilang ni malinih humman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ey ya etan natdaan ni lanan olibah, ey ihha-ad ni padid ulu etan ni tuu, ma-lat ma-kal liwat tun Apu Dios et maibilang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ey i-appit ni padi etan kamei-appit tep ya liwat, ey pehding tu etan elaw ni panlinnih etan di tuun na-kal degeh tu. Hedin negibbuh ey keklengen tu etan kamei-appit ni kagihheba ");
INSERT INTO ify_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","et iappit tud altar e i-e-dum tu etan alinah ni kamei-appit. Pehding ni padi humman ni elaw ni panlinih ma-lat maibilang ni malinih etan tuu. ");
INSERT INTO ify_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Hedin newetwet etan tuu et eleg tu hanggela hu dewwan pakeetteng tun lakkitun kalneroh ey anin ni hakey i-ali tun i-appit tu tep ya bahul, ya hangkiloh ni kayyaggud ni alinah ni nekamdugan ni mansikan olibah, et ya hambasuh ni mansikan olibah. Humman ni kamei-appit ni ke-kalan ni liwat etan ni tuu ey itta-gey ni padi et peang-ang tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Um-i-li mewan humman ni tuun dewwan paluma winu dewwan balug, et mei-appit hu hakey tep ya liwat ey ya etan hakey ey mei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Yan meikkewwalun aggew ey i-alin nunman ni tuu etan ni padi etan ida kamei-appit et ipahding da hu elaw ni panlinnih di kad-an Apu Dios di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ey ellan ni padi etan pakeetteng tun kalneroh ni kamei-appit tep ya bahul niya mansikan olibah, et ita-gey tun peang-ang tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Keklengen tu humman ni pakeetteng tun kalneroh ni kamei-appit tep ya bahul, et umlan kuheyaw tu et ha-adan tu wannan ni tangila etan ni tuu et ya am-ama-an ni wannan ni ngamay tu et ya heli tu. ");
INSERT INTO ify_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ey um-iduyag etan padin lanan olibah di willin tepayya tu ");
INSERT INTO ify_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","et itdek tu wannan ni ledledengngan tu et iwakgih tun meminpittud kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ey ha-adan tun lanan olibah humman idan neha-adan ni kuheyaw di wannan ni tangilan nunman ni nan-appit, ya wannan ni am-ama-an ni ngamay tu niya heli tu. ");
INSERT INTO ify_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ihha-ad tu etan natdaan ni lanad ulu etan ni tuu et ipahding tu elaw ni panlinnih nunman ni tuun na-kal degeh tu. ");
INSERT INTO ify_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","31","Ey i-appit etan ni padi hu hakey etan ni dewwan paluma winu balug tep ya liwat nunman ni tuu hedin humman hanggela tu. Ey ya etan hakey ey mei-appit ni kagihheba e i-e-dum tu etan di kamei-appit ni alinah. Hanniman pehding ni padin pengippahdingan tun elaw ni panlinnih nunman ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hanniman meunnud ni pengippahdingan tun elaw ni panlinnih idan newetwet ni wada degeh ni belat dan kamei-tan.” ");
INSERT INTO ify_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Entanni ey kan mewan Apu Dios di Moses nan hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Hedin umdateng kayud Kanaan ni iddawat kun pambebleyan yu, et weddaek di edum ni baballey hu lumuy ni kameihhinnap, ");
INSERT INTO ify_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ey mahapul ni umlaw etan kan baley di kad-an ni padi et kantuy ‘Wada lumuy di baley ku’. ");
INSERT INTO ify_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Immandal etan ni padi e mei-hep nin emin hu hipan wada etan di baley, et han lumaw diman ni an menang-ang, tep meibbillang ni beken ni malinih hu hipan ha-kupan tun eleg mei-hep. Hedin mei-hep ni emin hu ngunut ey han himmegep etan padid bawang ni baley, ");
INSERT INTO ify_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","et tu pekabbinbinen humman ni lumuy. Hedin wada ang-angen tun madmadlangngan winu meatta ang-ang tun kamenglaw di dallem idan dingding e beken ni yad ta-pew tun ebuh, ");
INSERT INTO ify_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ey um-ehep etan padi et ilekbi tu etan baley ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Umlaw ali mewan ni meikkeppitun aggew et tu ang-angen. Hedin kamangkeihhinnap humman ni lumuy, ");
INSERT INTO ify_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ey i-olden tun pikwalen da etan batun neidingding ni wada lumuy tu et tu bekahen di a-allaw ni bebley di kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Immandal mewan etan ni padi e kep-uhan dadda dingding, ey emmungen da kinep-uh da et da ibbeng di a-allaw ni bebley ni kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ey hullulan da etan ida nepikwal ni batu anin idan na-kal ni kapemket ni dingding. ");
INSERT INTO ify_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Hedin megibbuh ni melinnihan niya mehullulan ida etan batu niya kapemket ey kapyatun mewedda mewan hu lumuy, ");
INSERT INTO ify_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ey an ang-angen mewan ni padi, et hedin neihinap etan lumuy ey e-helen tu e meibbillang ni beken ni malinih humman ni baley. ");
INSERT INTO ify_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Et mahapul ni bahbahen da et ilaw da etan di a-allaw ni bebley ni kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ya etan tuun umhegep di baley ni neilekbi, tep kameibbillang ni beken ni malinih, ey meibbillang daman beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ey ya etan umbaktad winu mengngan diman ey mahapul ni ibbalbal tu balwasi tu. ");
INSERT INTO ify_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Nem hedin ang-angen etan ni padi ey endi law hu lumuy etan di baley, ey e-helen tu e malinih law humman ni baley tep na-kal hu lumuy tu. ");
INSERT INTO ify_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Nem mahapul ni ippahding ni padi hu elaw ni panlinnih e um-alan dewwan sisit, ya sedar ni keyew, ya madlang ni sinulid et ya pingin hyssop. ");
INSERT INTO ify_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Keklengen tu etan hakey ni sisit etan di neityan pulan mahukung ni duyun neha-adan ni danum ni pakeahul di hebwak. ");
INSERT INTO ify_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","Ey ellan tudda etan sedar ni keyew, ya pingin hyssop, ya etan makadlang ni sinulid niya etan hakey ni sisit, et ita-mel tuddad kuheyaw ni nakleh ni sisit ni nekamdugan ni danum et wakgihan tun meminpittu etan baley. Hedin negibbuh ni impahding tu huyyan elaw ni panlinnih etan ni baley, ");
INSERT INTO ify_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ey peteyyab tu etan mategun sisit di a-allaw ni bebley. Pehding tu huyya ma-lat maibilang ni malinih mewan etan baley. ");
INSERT INTO ify_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Huttan ida meunnud ni meippahding hedin wada kameihhinnap ni buut di balwasi winu lumuy di baley, winu kamei-tan ni degeh ni belat. ");
INSERT INTO ify_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Huttan hu pengamtaan ni tuu hedin meibbillang ni malinih winu eleg hu tuu niya hipan ngunut.” ");
INSERT INTO ify_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kan mewan Apu Dios di Moses nan Aaron ey ");
INSERT INTO ify_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Ehel yuddan edum yun helag Israel ida huyyan ittugun ku: Ya etan lakin wada kamelpud annel tu ey meibbillang ni beken ni malinih, ");
INSERT INTO ify_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","anin ni kantu et nanengtun wada kameukkat winu nesiked. ");
INSERT INTO ify_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Meibbillang mewan ni beken ni malinih etan yinudungan tu winu neugipan tu. ");
INSERT INTO ify_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ey ya etan tuun meittummuk di uggippan nunman ni laki, ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ya etan tuun umyudung di yinudungan ni lakin wada kamelpud annel tu ey mahapul ni ibbalbal tu balwasi tu ey man-e-meh, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Hanniman dama etan tuun mengeppa etan ni lakin wada kamelpud annel tu e mahapul ni ibbalbal tu balwasi tu, nem meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Hedin linupdaan ni lakin wada kamelpud annel tu hu hakey ni tuu, ey mahapul ni ibbalbal etan ni nelupdaan hu balwasi tu, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ya etan lakin wada kamelpud annel tu ey meibbillang ni beken ni malinih etan yuddungngan tun pantakkayan tud kebayyu. ");
INSERT INTO ify_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Anin ni ya etan tuun mengeppan yinudungan nunman ni laki et mahapul ni ibbalbal tu balwasi tu, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Hedin eleg mambulu etan lakin wada kamelpud annel ey kinepa tu hakey ni tuu, ey mahapul ni ibbalbal nunman ni kinepa tu hu balwasi tu niya man-e-meh. Nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ya pulan bangan keppaen nunman ni lakin wada kamelpud annel tu ey mahapul ni mephik. Ey hedin keyew ni duyun mahukung hu kinepa tu, man mahapul ni meullahan. ");
INSERT INTO ify_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Hedin nesiked law hu kamelpud annel nunman ni laki ey melebbah hu pitun aggew et han tu ipahding hu elaw ni panlinnih e ibbalbal tu balwasi tu, ey an man-e-meh di hebwak et han dammutun meibbillang law ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Yan meikkewwalun aggew ey mahapul ni um-alan dewwan paluma winu dewwan balug et lumaw di heggeppan di Tabernacle et idwat tun padi. ");
INSERT INTO ify_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","I-appit etan ni padi hu hakey tep ya liwat ey mei-appit ni kagihheba etan hakey. Pehding ni padi humman, ma-lat maibilang humman ni lakin malinih di hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Hedin wada mewan kamelpud annel ni laki, ey mahapul ni man-e-meh, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Anin ni hipan luput winu katat hu neha-adan ni nunman ni kameukkat et mahapul ni mebalbalan, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Hedin nan-ulig hu laki niya bii, ey mahapul ni man-e-meh ida, nem nanengtun meibbillang idan beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Hedin immali hu binnulan ni kamelpud annel ni bii, ey meibbillang ni beken ni malinih ni pitun aggew. Et ya etan tuun mengeppan hi-gatu ey meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ey emin hu keuggipan winu yuddungan nunman ni bii ey meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Ya etan tuun mengeppan neugipan winu yinudungan nunman ni bii ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ya etan lakin mengi-ullig nunman ni bii et maida-nih ni hi-gatu humman ni kamelpud annel tu, ey meibbillang ni beken ni malinih ni pitun aggew. Anin ni ya keuggipan nunman ni laki et meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ya etan biin wada kamelpud annel tun pigan aggew, nem beken humman etan kaum-alin binnulan, ey meibbillang ni beken ni malinih ingganah mesikked humman ni kamelpud annel tu. ");
INSERT INTO ify_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ey meibbillang ni beken ni malinih etan tuka keuggipi niya tuka yuddungi henin kaelliin binnulan ni kamelpud annel tu. ");
INSERT INTO ify_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ya etan tuun mengeppan kakeuggipin nunman ni bii, ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh, nem nanengtun meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Hedin nesiked hu kamelpud annel nunman ni bii, ey billangen tu pitun aggew et han dammutun meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Yan meikkewwalun aggew ey um-alan dewwan paluma winu dewwan pakeetteng tun balug et ilaw tun padid heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mei-appit hu hakey tep ya liwat ey mei-appit ni kagihheba etan hakey. Pehding ni padi humman ma-lat maibilang ni malinih di hinanggan Apu Dios etan bii.” ");
INSERT INTO ify_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kan Apu Dios nan Moses ey “Huyyadda ituttuddum ma-lat eleg pambalin idan helag Israel hu annel dan beken ni malinih, et eleg da hibiten hu Tabernacle ni wadad kad-an da et eleg ida matey. ");
INSERT INTO ify_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","Huyyadda ituttuddum ni u-unnuden ni lakin meibbillang ni beken ni malinih tep wada neukat ni kamelpud annel tu, niya u-unnuden ni biin kaelliin binnulan ni kamelpud annel tu et ya u-unnuden ni lakin mengi-ullig ni biin wada binnulan ni kamelpud annel tu.” ");
INSERT INTO ify_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yan eman ni neteyyan idan dewwan u-ungngan Aaron tep eleg da u-unnuden hu intugun Apu Dios ni pehding dan man-appit ");
INSERT INTO ify_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ey kan Apu Dios nan Moses ey “Ehel mun agim e hi Aaron et beken ni neala ni himmegep etan di Nekassantuh ni Kuwaltuh ni nehanian ni kultinah di hinanggan nehu-keban ni Kaban, tep mettey hedin henin nunman pehding tu, tep wada-ak di kulput di ta-pew nunman ni Kaban. ");
INSERT INTO ify_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Et humman hu, hedin umhegep hi Aaron diman ey pakkaw ni wada i-appit tun hantoon tun bakan kamei-appit tep ya liwat niya hakey ni lakkitun kalneroh ni kamei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Huyya hu mahapul ni pehding tu et han humgep diman. Ey pakkaw mewan ni man-e-meh niya ihhuklub tu hu balwasin padi et ya etan kamei-dah, ey balkehan tu gitang tu niya mampepnget, tep humman ida neieng-eng ni balwasi tu. ");
INSERT INTO ify_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ey mahapul ni um-idwat idan hi-gatu hu edum tun helag Israel ni dewwan lakkitun gelding ni kamei-appit tep ya liwat et ya hakey ni lakkitun kalneroh ni kamei-appit ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","I-appit nan Aaron humman ni bulug ni baka tep ya liwat tu niya liwat ni pamilyah tu. ");
INSERT INTO ify_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Niya i-ali tu hu dewwan gelding et tu peang-ang nan Apu Dios di heggeppan di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Et ibubunut tu hedin hipa etan di dewwan gelding hu i-appit tu winu ibbukyat tu. ");
INSERT INTO ify_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","I-appit nan Aaron nan Apu Dios etan mebunnut ni kamei-appit tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Hedin ya etan gelding ni mebunnut ni meibbukyat ey peang-ang tun Apu Dios et hantu ibukyat di eleg mebebleyi, ma-lat keang-angan tu e heni inlaw nunman ni gelding hu liwat idan helag Israel di edawwi, ma-lat maibilang ida law ni malinih tep na-kal law liwat da. ");
INSERT INTO ify_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ey hedin ya etan bulug ni baka, man i-appit Aaron tep ya liwat tu et ya liwat idan pamilyah tu. ");
INSERT INTO ify_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ellan tu etan pengiggihheban ni bangbanglun neha-adan ni ngalab ni nalpud altar di hinanggan Apu Dios. Ey um-alan dewwan gamal ni nakaggudun bangbanglu, et ihgep tud kuwaltuh ni nekultinahan ");
INSERT INTO ify_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","et iha-ad tu humman ni bangbanglud apuy. Et ya etan mampetyed ni ahuk tu ey hennian tu hu-keb ni Kaban. Hedin u-unnuden Aaron ida huyya hedin umhegep diman, ey eleg mettey. ");
INSERT INTO ify_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ya hakey mewan ni pehding tu ey ittetdek tu kimeng tu etan di kuheyaw ni bulug ni baka et iwakgih tu etan di hu-keb ni Kaban et yad hinanggan nunman ni Kaban ni meminpittu. ");
INSERT INTO ify_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Hedin negibbuh, keklengen tu etan gelding ni kamei-appit tep ya liwat idan tuu. Ey ihhehgep tu humman ni kuheyaw di kuwaltuh ni nekultinahan, et wakgihan tu etan hu-keb ni Kaban et ya hinanggan nunman ni Kaban ni meminpittu, henin impahding tun kuheyaw ni baka. ");
INSERT INTO ify_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ippahding Aaron huyyad Nekassantuh ni Kuwaltuh et yad Tabernacle, ma-lat ipahding tu hu elaw ni panlinnih ma-lat abuluten Apu Dios ida huyya. Ippahding Aaron ida huyya tep ya liwat niya ngehay idan helag Israel ni hi-gatu e Dios. ");
INSERT INTO ify_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Hedin himmegep hi Aaron di Tabernacle ni man-appit di Nekassantuh ni Kuwaltuh ma-lat ma-kal hu liwat tu, ya liwat ni pamilyah tu niya liwat idan helag Israel, ey eleg mabalin ni wada edum ni umhegep diman. ");
INSERT INTO ify_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ey han immehep hi Aaron et tu ipahding hu elaw ni panlinnih ni altar e um-alan kuheyaw ni bulug ni baka niya gelding, et ha-adan tudda neidengdeng ni dugun nunman ni pan-appitan. ");
INSERT INTO ify_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ey ittetdek tu kimeng tud kuheyaw idan nunman ni animal, et wakgihan tun meminpittu humman ni altar, et ipahding tu hu elaw ni panlinnih ma-lat maibilang ni malinih. Tep yan nunman ey neibilang ni beken ni malinih tep ya liwat idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Hedin negibbuh ni impahding tu humman di Nekassantuh ni Kuwaltuh, ya Tabernacle niya etan altar ey ellan tu etan mategun gelding et peang-ang tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","22","Ey han tu inta-pew hu dewwan ngamay tud ulun nunman ni gelding, ey e-helen tun emin hu nanliwatan idan helag Israel niya nangngehayan da, et heni tudda in-etan ni nunman ni gelding. Et pebeltan tu etan ni neputuk ni tuun mengibbukyat, ma-lat ilaw nunman ni gelding emin hu liwat idan tuu di eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Yan heggeppan mewan nan Aaron di Tabernacle ey e-kalen tu hu imbalwasi tun himmegep di Nekassantuh ni Kuwaltuh et iha-ad tudman. ");
INSERT INTO ify_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ey mahapul ni man-e-meh etan di nengilinan ni emmehhan ey hantu inhuklub etan balwasi tu ngu dedan et han umhep et man-appit ni kagihheban i-appit tu niya i-appit idan tuu. Huyya pehding tu ma-lat ma-kal liwat tu niya liwat idan tuu. ");
INSERT INTO ify_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ey hantu giniheb di altar ni emin hu tabaddan nunman ni animal ni kamei-appit tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ya etan tuun an mengibbukyat ni gelding di eleg mebebleyi ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh et han dammutun mambangngad di kampu da. ");
INSERT INTO ify_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ya etan bulug ni baka niya etan gelding ni kamei-appit tep ya liwat ni kan kuheyaw ni ihhehgep Aaron di Nekassantuh ni Kuwaltuh ma-lat ma-kal hu liwat idan helag Israel, ey meillaw idad a-allaw ni kampu et magiheb idadman. Mekiggihheb hu belat da, ya laman da niya egeh da. ");
INSERT INTO ify_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ey ya etan tuun mengihheb idan nunman ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh et han mambangngad di kampu da. ");
INSERT INTO ify_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Huyya hu tugun ni meunnud ni ingganah: Emin hu helag Israel, anin idan nekibebley ni hi-gada ey mannungngew ida e eleg ida an mangngunu niya mantetpel ida e eleg ida mengngan ni meikkeppulun aggew ni meikkeppitun bulan. ");
INSERT INTO ify_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Yan nunman ni aggew hu pengippahdingan dan elaw ni ke-kalan ni liwat da, ma-lat malinih idad hinanggan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Humman ey aggew ni Sabaduh ni Nungew e endin hekey hu mangngunnu niya mantetpel ida, tep huyyan aggew ey kamengillin ni peteg. Mahapul ni meunnud ni ingganah ida huyyan tugun. ");
INSERT INTO ify_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ya mengippahding nunyan elaw ni ke-kalan ni liwat ey ya helag Aaron ni neputuk ni eta-gey ni padi. Ihhuklub tu hu balwasin padi ");
INSERT INTO ify_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","et ipahding tu hu elaw ni panlinnih ni Nekassantuh ni Kuwaltuh, ya Tabernacle, et ya altar. Ey ippahding tu hu elaw ni ke-kalan ni liwat idan padi et yadda emin ni helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Meunnud ni ingganah ida huyyan emin ni tugun meippanggep ni elaw ni ke-kalan ni liwat yun helag Israel. Pinhakkey ni hantoon hu pengippahdingan yun nunya.” Et u-unnuden Moses ni emin ida huyyan tugun ni inhel Apu Dios ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Ehel mun Aaron, yadda u-ungnga tu niyadda edum yun helag Israel ida huyyan ittugun kun hi-gada: ");
INSERT INTO ify_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","‘Hedin man-appit hu hakey ni helag Israel ni lakkitun baka, ya impah ni kalneroh winu ya gelding, ey mahapul ni i-ali tud heggeppan di Tabernacle, ma-lat peang-ang tun i-appit tun Apu Dios. Tep hedin yad kampu winu yad a-allaw tu hu pengi-appitan tu, ey meibbillang ni nanliwat humman ni tuu, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Mukun wada huyyan tugun ey ma-lat i-liddan helag Israel nan Apu Dios hu daka i-enappit di nalgem ni lugal. Tep mahapul nisin humman idan i-appit da ey i-ali daddan padid heggeppan di Tabernacle et iappit dan pekiddagyuman dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Huyya pehding da ma-lat iwakgih ni padi hu kuheyaw etan ni animal di altar niya giheben tu hu taba et umamleng hi Apu Dios ni hamuy tu. ");
INSERT INTO ify_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Mahapul ni issiked idan helag Israel ni man-appit ni dimonyoh et ihakkey dan Apu Dios hu pandeyyaw da. Ey mahapul ni u-unnuden dan ingganah huyyan tugun.’ ");
INSERT INTO ify_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ey ehel mun hi-gada e kammuy ‘Ya hakey ni helag Israel winu hansinu-wan ni nekibebley ni man-appit ni kagihheba winu hipan edum ni kamei-appit nan Apu Dios, ");
INSERT INTO ify_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","nem eleg tu i-alid heggeppan di Tabernacle, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Hedin kennen ni helag Israel winu hipan nekibebley hu animal ni eleg ma-kal kuheyaw tu, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Tep ya kuheyaw hu kad-an ni biyag. Et mukun, in-olden Apu Dios e idduyag ni padid altar hu kuheyaw ni animal ni neiappit ma-lat ma-kal hu liwat yu, tep ya kuheyaw hu kamengkal ni liwat ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Et humman hu, intugun Apu Dios e eleg mabalin ni ihhidaddan helag Israel niyadda nekibebley ni hi-gada hu detag ni animal ni eleg ma-kal kuheyaw tu. ");
INSERT INTO ify_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Hedin wada hakey ni helag Israel winu hipan nekibebley ni wada dinweng tun animal winu wada kinna tun sisit ni kameibbillang ni malinih, ey mahapul ni peih-ih tu kuheyaw da et ta-bunan tun puyek. ");
INSERT INTO ify_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Tep ya biyag ni animal ey wadad kuheyaw tu. Et humman hu, hedin eleg u-unnuda etan ni tuu huyyan tugun, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ya etan tuun helag Israel winu hipan nekibebley ni mengngan ni detag ni gandat ngun netey ni animal winu pintey ni animal di muyung, ey mahapul ni ibbalbal tu balwasi tu niya man-e-meh, nem nanengtun eleg meibbillang ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Hedin eleg tu u-unnuda huyya, man mekastigu.’” ");
INSERT INTO ify_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","2","Kan mewan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel huyyan ittugun kun hi-gada: Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Entan tu iu-unnud di elaw idan tuud Egypt e nambebleyan yu lan nunman. Ey entan tu iu-unnud di elaw idan iKanaan ni nambebley di bebley ni pengillawwak ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ipahding yu pinhed ku ey u-unnud yu tugun ku. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hedin u-unnuden yu tugun ku, kayyaggud pambalinan ni biyag yu tep ya pengippahdingan yuddan nunman. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","U-unnud yudda eya tugun ku: Entan tudda iulig aaggi yu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Entan tu iulig hi ineyu tep be-ingen yu hi ameyu. Nemnem yu e hi ineyu humman. ");
INSERT INTO ify_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ey entan tu iulig hu ahwan ameyu, tep kebe-ingan nan ameyu. ");
INSERT INTO ify_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Entan tu iulig hu agiyun bii, anin ni u-ungngan ameyud edum ni bii winu u-ungngan ineyud edum ni laki, anin ni eleg meetteng di baley yu. ");
INSERT INTO ify_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Entan tu iulig hu inap-apu yun bii, tep kebe-ingan yu. ");
INSERT INTO ify_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Entan tu iulig hu imbintan ameyu, tep agiyu humman. ");
INSERT INTO ify_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Entan tu iulig hu biin agin ameyu winu agin ineyu, tep agiddan ameyun ineyu. ");
INSERT INTO ify_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Entan tu iulig hu ahwan agin ameyu ma-lat eleg yudda baingen, tep a-ammed yudda. ");
INSERT INTO ify_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Entan tu iulig hu inepu yun bii, tep ahwan u-ungnga yu. ");
INSERT INTO ify_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Entan tu iulig hu ahwan agiyu ma-lat eleg yu baingen hu agiyu. ");
INSERT INTO ify_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Entan tu iulig hu han-ina ey entan tu iulig hu inap-apu tu, tep lawah ni peteg humman. ");
INSERT INTO ify_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Entan tu ahwa hu agin ahwa yu hedin mategu ahwa yu. ");
INSERT INTO ify_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Entan tu iulig hu biin wada kamelpud annel tu, tep kameibbillang humman ni biin beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Entan tu iulig hu ahwan sinakdul yu, tep meibbillang kayun beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Entan tu iebulut ni mei-appit hu u-ungnga yun Molek, tep langlangkuyyaen yu hu ngadan ku e Dios yu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Eleg mabalin ni i-ulig ni laki hu edum tun laki, tep lawah ni peteg humman. ");
INSERT INTO ify_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Eleg mabalin ni an i-ulig ni tuu hu animal, tep meibbillang ni beken ni malinih hu tuun mengippahding nunman. Ey lawah ni peteg humman ni pehding ni hakey ni tuu. ");
INSERT INTO ify_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Entan tu ipahding ida huyya, tep meibbillang kayun beken ni malinih. Humman impenahding idan tuun nampambebley di pengillawwak ni hi-gayu, et maibilang idan beken ni malinih. Et mukun degyunen kudda et maihullul kayu. ");
INSERT INTO ify_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Nambalin hu bebley dan beken ni malinih tep yadda humman ni impenahding da. Et humman hu, kastiguen kudda ma-lat ma-kal idadman. ");
INSERT INTO ify_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","Nem hedin hi-gayu, anin idan nekibebley ni hi-gayu, ey mahapul ni paka-u-unnuden yun emin hu tugun ku, et eleg yu ipahding ida humman ni lawah ni peteg. Impenahding idan nambebley ditan ida humman ni kamengippebungnget et mambalin bebley dan beken ni malinih. Nem hedin nisin hi-gayu niyadda nekibebley ni hi-gayu, ey mahapul ni u-unnuden yu tugun ku. ");
INSERT INTO ify_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Hedin ippahding yudda dama humman ey bellawen dakeyu etan ni bebley heni lan neipahding idan nambebley diman. ");
INSERT INTO ify_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hedin wadan hi-gayun helag Israel hu mengippahding idan nunya, ey eleg law meibbillang ni tuun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","U-unnud yu tugun ku ey entan tu iu-unnud di kapehding idan tuun nambebley di lawwan yun yu pambebleyan, ma-lat eleg kayu maibilang ni beken ni malinih. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Kan mewan nan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel huyyan ittugun kun hi-gada: Mahapul ni kayyaggud kayun peteg e endi yu ippahding ni lawah, tep hi-gak e Ap-Apu e Dios yu ey kayyagguddak ni peteg. ");
INSERT INTO ify_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Mahapul ni lispituhen yu hi ameyun ineyu. Ey mahapul ni u-unnuden yu hu elaw ni Sabaduh. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Entan tu dayaw hu dios ni kinapyan tuu niya entan pengapkapya yun gumek ni dios ni deyyawen yu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Hedin man-appit kayun animal ni pekiddagyuman yun hi-gak ey mahapul ni u-unnuden yu intugun kun pehding yu ma-lat abulutek hu i-appit yu. ");
INSERT INTO ify_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ey mahapul ni kennen yu detag tun nunman ni aggew ni naklengan tu winu yan kewa-waan tu. Hedin wada metdaan ni meikkatlun aggew, ey giheb yu. ");
INSERT INTO ify_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Hedin wada mengngan nunman ni detag ni meikkatlun aggew, ey eggak ebbuluta humman ni kamei-appit, tep meibbillang law ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ey ya etan tuun mengngan nunman ey nanliwat ni hi-gak, tep eleg tu lispituhen hu neieng-eng ni hi-gak. Et eleg law meibbillang ni tuuk. ");
INSERT INTO ify_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Hedin man-enni kayu ey entan tu pakieni etan ida nangkeigillig ey entan an pambangngad et yu paka-aniyen hu linabhan yu. ");
INSERT INTO ify_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Hanniman mewan hu grapes e entan pambangngad yun mengehhim ni eleg yu bugbugen. Diman ida humman et wada ellan idan newetwet et yadda nekibebley ni hi-gayu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Entan panekew yu. Ey entan tu haul hu edum yun tuu. Niya entan tu ehel hu beken ni makulug. ");
INSERT INTO ify_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Entan tu isapatah di ngadan ku hedin yuka nemnemnema e eleg yu pehding humman ni issapatah yu, ma-lat eleg yu langlangkuyyaen hu ngadan ku e Dios yu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Entan tu helamhami hu edum yu niya entan tu piliw limmu tu. Ey entan tu igeb-at ni babbayyagen ni iddawat hu sinangdan ni impangngunu yu. ");
INSERT INTO ify_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Entan tu ehel hu lawah etan ni netuleng ni tuu niya entan tu iha-ad hu kehellapdungan ni nekulap ni tuu. Humman pengippeang-angan yun lispituh yun hi-gak e Dios yu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Mahapul ni limpiyuh pengippennuh yun kasuh et eleg yu ituppug hu bahul di newetwet winu kedangyan. ");
INSERT INTO ify_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Entan tu ihinap hu itek meippanggep ni hakey ni tuu. Ey entan tu ipahding hu umhulun ni ketteyyan ni edum yun tuu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Entan tu pannananeng ni anggebe-helen hu hipan agiyu. Hedin wada nanhallaan yu, ey ihummangan yu et eleg kayu manliwat tep ya humman. ");
INSERT INTO ify_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Entan tu nenemnem ni ibbaleh hedin wada lawah ni impahding ni hakey ni tuun hi-gayu. Ey entan tu pannananeng ni anggebe-helen humman ni tuu, nem peang-ang yu impeminhed yun hi-gatu e henin impeminhed yun annel yu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","U-unnud yu tugun ku. Entan tu peendul hu hakey ni animal di hin-appil ni animal. Entan tu itnem di payew yu hu dewwan nambaklang ni kameitnem. Ey entan tu ibalwasi hu nekapyad dewwan nambaklang ni luput. ");
INSERT INTO ify_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ya etan biin himbut ni ahwaen ni hakey ni laki, nem eleg ni meliblih di neihbutan tu, tep eleg mebaydan, ey hedin i-ulig ni hakey ni laki, man mekastiguddan dewwa. Nem beken ni katey hu kastigu da tep eleg meliblih di neihbutan tu etan bii. ");
INSERT INTO ify_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ya etan lakin mengi-ullig ni nunman ni bii ey mahapul ni um-ilaw ni lakkitun kalneroh di heggeppan di Tabernacle et iappit tun hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ey humman hu pengippahdingan etan ni padin elaw ni ke-kalan ni liwat nunman ni tuu ma-lat liwwanen ku hu liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Hedin umlaw kayud Kanaan et mantennem kayun keyew ni kamekkan lameh tu, ey entan tu ekan hu illameh dan tellun toon, tep meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ey iappit yun hi-gak ni emin hu illameh dan meikka-pat ni toon et pengipeang-angan yun yuka pandeyyaw ni hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Dammutun kennen yu illameh dan meikkelliman toon. Hedin u-unnuden yudda huyya ey dakel illameh ni ittanem yu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Entan tu ekan hu detag ni eleg ma-kal kuheyaw tu. Ey entan pan-anap yu niya entan pan-ayak yu. ");
INSERT INTO ify_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Entan tu pu-liti hu bewek di nambina-hil ni ulu yu ey entan tu pu-liti hu iming yu. ");
INSERT INTO ify_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Entan tu liputi annel yu niya entan tu bateki annel yun pengippeang-angan yun lemyung yu tep ya netey. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Entan tu iebulut hu biin u-ungnga yun mampebeyyad ni annel tun lalakki, tep mebe-ingan ida et lektattuy medakkel hu daka pebeyyad annel da et mambalin hu bebley yun lawah ni pambebleyan. ");
INSERT INTO ify_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ipahding yu elaw ni Sabaduh, ey lispituh yu hu baley kun pandeyyawan yun hi-gak. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Entan pampebaddang yud tuun kamelpu kabaelan dad edum ni ispirituh, tep meibbillang kayun beken ni malinih hedin hanniman pehding yu. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Lispituh yudda nangkea-amma niya nangkei-inna. Ey peka-u-unnud yuwak. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Entan tu ipahding hu lawah idan tutu-un nekibebley ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nem ipahding yun hi-gada hu henin yuka pehding idan edum yun helag Israel. Nemnem yu e nekibebley kayu damad Egypt ni nunman. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Entan tu talam hu edum yun pengi-ussalan yun beken ni ustuh ni killohhan, ya kapanlelkud niya kapambillang. ");
INSERT INTO ify_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ya ustuh ni killohhan, ya ustuh ni lekud niya ustuh ni bilang hu usal yu. Hi-gak hu Ap-Apu e Dios yun nengipengulun hi-gayun neni-yanan yun Egypt. ");
INSERT INTO ify_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","U-unnud yun emin hu tugun ku niya olden ku. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ehel muddan edum mun helag Israel huyyan ittugun kun hi-gada: Ya etan helag Israel winu hansinu-wan ni nekibebley ni hi-gayun gihheben tu u-ungnga tun iappit tu etan ni dios e hi Molek ey mahapul ni tengbaen idan bimmebley ni batu et matey. ");
INSERT INTO ify_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Iwwalleng ku hu tuun mengippahding nunya ey eggak law ibbilang ni tuuk, tep pambalin tun beken ni malinih hu baley ku niya langlangkuyyaen tu ngadan kun pengidwatan tun u-ungnga tun Molek. ");
INSERT INTO ify_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ey hedin eleg hengngudaddan bimmebley humman ni impahding tu et eleg da petteya humman ni tuu, ");
INSERT INTO ify_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ey iwwalleng ku humman ni tuu, yadda pamilyah tu et yadda edum tun kamenaydayaw nan Molek, et eleg ida law maibilang ni tuuk. ");
INSERT INTO ify_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Hedin wada hakey ni tuun mampebaddang niya mengu-unnud ni e-helen idan tuun kamekihhummangan ni linnawan netey, ey iwwalleng ku et eleg law meibbillang ni tuuk. ");
INSERT INTO ify_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Tuu dakeyun hi-gak, et humman hu, ang-ang yu et ya kayyaggud hu ipahding yu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","U-unnud yu tugun ku, tep hi-gak e Dios ey dakeyu kapambalin ni kayyaggud. ");
INSERT INTO ify_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ya etan tuun tuka iduti a-ammed tu ey mekastigun katey, tep humman kastigun bahul tu. ");
INSERT INTO ify_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Hedin i-ulig ni hakey ni laki hu ahwan hakey ni tuu ey ya kastigun nunman ni laki, anin etan biin in-ulig tu, ey katey. ");
INSERT INTO ify_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ya etan lakin in-ulig tu ahwan ametu ey bineing tu hi ametu. Ya kastigu dan dewwa etan ni biin in-ulig tu ey katey. Hi-gada ngu kambahul ni ketteyyan da. ");
INSERT INTO ify_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ya dama kastigun hakey ni lakin nengiulig ni ahwan u-ungnga tu ey katey. Anin ni ya etan biin in-ulig tu et mettey dama. Lawah ni peteg impahding da, et humman hu, mahapul ni mettey ida. ");
INSERT INTO ify_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ya kastigun lakin in-ulig tu hakey ni laki ey ya katey. Henin nunman dama kastigu etan ni in-ulig tu. Lawah ni peteg humman ni impahding da, et humman hu, hi-gada ngu kambahul ni ketteyyan da. ");
INSERT INTO ify_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Hedin inahwan hakey ni laki hu han-ina, ey mekastiguddan tellu et magiheb idad apuy, tep ya humman ni anggeba-ing ni impahding da. Eleg mabalin ni wada mengippahding ni henin nunman ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ya lakin mengi-ulig ni animal ey mahapul ni mekastigu et matey. Ey anin ya etan animal et mahapul daman petteyen yu. ");
INSERT INTO ify_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Hedin in-ulig ni hakey ni bii hu animal ey mahapul ni mettey idan dewwa. Tep hi-gada ngu kambahul ni ketteyyan da. ");
INSERT INTO ify_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Hedin inahwan hakey ni laki hu agi tun bii, winu biin u-ungngan ametu, winu u-ungngan inetu, ey baingi yuddad kedaklan ni tuu niya degyun yudda et eleg ida makibebley ni hi-gayu. Heltapen da kastigu da, tep in-ulig da agi da. ");
INSERT INTO ify_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ya etan lakin mengi-ullig ni biin wada kamelpud annel tu ey medegyun idan dewwa et eleg ida makibebley ni hi-gayu, tep eleg da u-unnuden hu elaw ni panlinnih. ");
INSERT INTO ify_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ya etan lakin mengi-ullig ni agin inetu winu agin ametu ey mekastigu, anin etan ni bii, tep eleg da u-unnuden etan tugun ni kameunnud ni elaw ni nan-aagian. ");
INSERT INTO ify_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ya etan lakin mengi-ullig ni ahwan agin ametu ey nambabul etan ni agin ametu. Et humman hu, mekastigu etan laki, anin etan bii et eleg ida man-ungnga, tep hi-gada ngu kambahul. ");
INSERT INTO ify_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ya etan lakin piniliw tu ahwan agitu ey meibbillang ni beken ni malinih humman ni impahding tu, tep eleg tu lispituhen hi agi tu. Et humman hu, meiddutan ida et endi u-ungnga da. ");
INSERT INTO ify_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","U-unnud yun emin hu tugun ku niyadda olden ku, tep hedin eleg yu u-unnuda ey medegyun kayud bebley ni pengillawwak ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ey entan tu iu-unnud idan elaw ni bimmebley diman. Degyunen kudda tep lawah ni peteg hu daka pehpehding, et mukun anggebe-hel kuddan peteg. ");
INSERT INTO ify_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Inhel ku dedan lan nunman e iddawat kun hi-gayu humman ni kayyaggud ni puyek e mateba kameitnem ma-lat pambebleyan yu. Hi-gak hu Ap-Apu e Dios yu ey hi-gayu pinilik ni pantu-uk di emin ni tutu-u eyad puyek e heni kayu neieng-eng ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Et humman hu, mahapul ni pesi-ngai yu hedin hipaddan animal winu sisit hu kameibbillang ni malinih winu beken. Entan nisi ekan tu hu animal winu sisit ni kameibbillang ni beken ni malinih. Hi-gak nengiolden ni beken idan malinih humman. Et mukun hedin kennen yudda humman ey meibbillang kayu daman beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mahapul ni kayyaggud kayu tep hi-gak e Ap-Apu ey kayyagguddak ni peteg. Ey hi-gayu pinilik ni pantu-uk di emin ni tutu-u eyad puyek e heni kayu neieng-eng ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ya etan tuun mekihhummangan ni linnawan netey ey tengbaen ni batu et matey, tep hi-gatu ngu kambahul.” ");
INSERT INTO ify_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kan mewan Apu Dios nan Moses ey “Ehel muddan padin helag Aaron huyyan ittugun kun hi-gada: Eleg mabalin ni an keppaen ni padi hu netey ni aaggi tu ma-lat eleg maibilang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Nem dammutu hedin humman ni netey ey hi inetu, winu hi ametu, winu u-ungnga tun laki winu bii, winu agitun laki, ");
INSERT INTO ify_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","winu ya eleg malehin ni agi tun biin kamekihha-ad di baley tu. ");
INSERT INTO ify_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Eleg mabalin ni an mekidimdima-u hedin nekiepu etan ni netey, tep meibbilang ni beken ni malini. ");
INSERT INTO ify_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Eleg mabalin ni mukmukan ni padi ulu tu, winu tu kep-uhan hu iming tu, winu tu lipputan hu annel tun pengippeang-angan tun lemyung tu. ");
INSERT INTO ify_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mahapul ni kayyaggud hu padi ma-lat eleg tu langlangkuyyaen hu ngadan ku e Dios, tep hi-gatu mengi-appit ni hi-gak ni kennen ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ey eleg mabalin ni an ahwaen ni padi hu biin tuka pebeyyad annel tun laki, winu biin in-ulig ni edum ni laki winu nekihi-yan ni ahwa tu. Tep mahapul ni kayyaggud idan peteg hu padi. ");
INSERT INTO ify_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mahapul ni kayyaggud hu kapengibbillang idan tuun padi tep hi-gada mengi-appit ni kennen ni hi-gak. Hi-gak e Ap-Apu ey kayyagguddak ni peteg ey pambalin kudda tuuk ni kayyaggud. ");
INSERT INTO ify_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Hedin pebeyyad ni biin u-ungngan padi hu annel tun laki, ey mahapul ni gihheben dan mategu, tep be-ingen tu hi ametu. ");
INSERT INTO ify_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ya etan eta-gey ni padi e neduyagan hu ulu tun lanan nampadian tu et maieng-eng ni hi-gak et ibalwasi tu balwasin padi. Et humman hu, anin ni kaumlelemyung et hegguen tu bewek tu niya eleg tu bi-kia balwasi tu. ");
INSERT INTO ify_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","Humman ni eta-gey ni padi ey neieng-eng ni hi-gak. Et mukun eleg mabalin ni tu ippahding hu umhulun ni pambalinan tun beken ni malinih. Et humman hu, eleg mabalin ni tu hi-yanen hu Tabernacle et lumaw di kad-an ni netey ni tuu, anin ni hi ametu winu hi inetu hu netey, ma-lat eleg mambalin ni beken ni malinih hu Tabernacle. ");
INSERT INTO ify_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ey mahapul nisin ya ahwaen ni padi ey ya etan biin endi nengiulig ni hi-gatu, ");
INSERT INTO ify_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","niya hakey ni pewen nahlagan da. Eleg mabalin ni tu ahwaen hu nebalu, winu ya nekihi-yan, winu ya biin tuka pebeyyad annel tun laki. ");
INSERT INTO ify_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Tep mahapul ni meibbillang ni malinih ida u-ungnga tu. Hi-gak hu Ap-Apu e Dios ni nengieng-eng ni hi-gatun eta-gey ni padi.” ");
INSERT INTO ify_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Ehel mun Aaron e kammuy: Endiddan u-ungngam ni wada dipektoh ni annel da hu an mampeddin mengi-appit ni kennen ni hi-gak. Huyyan tugun ey mahapul ni u-unnuden yullin ingganah. ");
INSERT INTO ify_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Eleg mabalin ni meihnup ni hi-gak ida tuun wada dipektoh ni annel da, henin nekulap, ya nedahuy, ya nepi-day, ");
INSERT INTO ify_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ya neik-ik hu heli tu winu ngamay tu, ");
INSERT INTO ify_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ya nebu-kung, ya ekkekut hu ingkatuu tu, ya wada degeh ni matetu, ya wada nebeblad belat tu niya napnahan. ");
INSERT INTO ify_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Endi nisiddan helag Aaron hu wada dipektoh tu hu an man-appit ni hi-gak ni kennen. ");
INSERT INTO ify_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Nem dammutun kennen tudda etan kennen ni neiappit ni hi-gak, yadda kennen ni kameibbillang ni kayyaggud niya kayyaggud ni peteg. ");
INSERT INTO ify_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nem ya henin nunman ni tuu ey eleg mabalin ni an meihnup etan di Nesantuh ni Kuwaltuh winu an meihnup di altar, tep pambalin tun beken ni malinih ida humman ni ngunut, tep hi-gak e Ap-Apu hu nengieng-eng idan nunman et mambalin idan kayyaggud.” ");
INSERT INTO ify_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Huyyadda intugun nan Moses nan Aaron, yadda u-ungnga tu niyaddan emin hu helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ehel mun Aaron et yadda lalakkin u-ungnga tu huyyan ittugun kun hi-gada: Lispituh yu hu i-appit idan helag Israel ni hi-gak ma-lat eleg yu langlangkuyyaen hu ngadan ku. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Hedin wadaddan helag yu hu kameibbillang ni beken ni malinih ey limmaw et an meihnup etan idad in-appit idan edum yun helag Israel ni hi-gak, ey eleg law mabalin ni an mansilbin hi-gak di altar, tep ya humman ni tu impahding. Huyyan tugun ey meunnud ni ingganah. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Endi mewan idan helag Aaron ni wada degeh ni belat dan kamei-tan, winu wada kamelpud annel da, hu an mengngan idan kamei-appit ni hi-gak ingganah meibbillang idan malinih. Meibbillang ni beken ni malinih hu padi hedin kinepa tu hu netey ni tuu, hedin wada neukat ni kamelpud annel tu, ");
INSERT INTO ify_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","niya hedin wada kinepa tun animal winu tuun kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Meibbillang humman ni padin beken ni malinih ingganah mehilleng niya eleg mabalin ni umkan idan neiappit ni hi-gak ingganah man-e-meh. ");
INSERT INTO ify_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Hedin nelinug hu aggew ey meibbillang law ni malinih, et dammutu law ni mengngan idan neiappit ni hi-gak e humman ida dedan daka kenna. ");
INSERT INTO ify_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Eleg mabalin ni kennen da hu detag ni netey ni animal winu pintey ni animal di muyung, tep kameibbillang ni beken ni malinih ida humman. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Mahapul ni u-unnuden idan emin ni padi hu tugun ku, tep mekastigudda et mettey ida hedin eleg ida mengu-unnud. Hi-gak hu Ap-Apu ni nemutuk ni hi-gada, ey nak ida kapambalin ni kayyaggud. ");
INSERT INTO ify_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ebuh ida pamilyah ni padin mengngan ni neiappit ni hi-gak, endi edum. Anin idan kamekihha-ad ni hi-gada et eleg mabalin ni ida mekikkan. ");
INSERT INTO ify_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nem ya etan bega-en ni gintang ni padi, e pihhuh tu nengatang tu, winu himbut tun neiungngad baley tu, ey dammutun mekikkan. ");
INSERT INTO ify_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ya etan biin u-ungngan padin inahwa tu hu beken ni padi ey eleg mabalin ni mekikkan idan nunman. ");
INSERT INTO ify_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Nem hedin nebalu etan biin u-ungngan padi winu hini-yan ni ahwa tu niya endi u-ungnga tu, et mambangngad di baley ametu, ey dammutun mekikkan idan kennen ni meidwat nan ametu. Beken ni linggeman ni tuu hu mengngan idan nunman, ebuh nisi pamilyah ni padi. ");
INSERT INTO ify_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Ya etan tuun eleg maibilang di pamilyah ni padi ey nekikan, nem eleg tu igeb-at, ey mahapul ni beyyadan tun padi etan kinan tu niya e-duman tun dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Eleg mabalin ni an langlangkuyyaen ni padi hu kai-appit idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Et mukun eleg mabalin ni tu i-abulut hu linggeman ni tuun an mengngan ida nunman. Tep manliwwat humman ni tuu et mahapul ni mekastigu. Hi-gak hu Ap-Apu, ey nakka pambalin idan neieng-eng humman idan kennen ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Ehel mun Aaron, yadda lalakkin u-ungnga tu niyaddan emin hu helag Israel huyyan ittugun kun hi-gada: Hedin man-appit ni kagihheba hu hakey ni helag Israel winu hakey ni nekibebley e beken ni helag Israel ni pengippahdingan tun insapatah tu winu iggeb-at tu ngu dedan ni man-appit, ");
INSERT INTO ify_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ey mahapul ni ya endi dipektoh tun lakkitun baka, kalneroh winu gelding hu i-appit tu. Ebbuluten ku hu i-appit tu hedin lakkitu niya endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Eggak ebbuluta hu i-appit ni hakey ni tuu hedin wada dipektoh etan ni animal. ");
INSERT INTO ify_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Hanniman dama etan ni kamei-appit ni pekiddagyuman tun hi-gak winu kamei-appit ni pengippeamnuan tun insapatah tu winu iggeb-at tun i-appit e mahapul ni endi dipektoh etan ni animal ma-lat abuluten ku. ");
INSERT INTO ify_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Entan tu igeb-at ni i-appit ni hi-gak e Ap-Apu hu animal ni nekulap, winu nepi-day, winu neliputan, winu nekupu winu nebebla annel tu. Ey entan tu iebulut ni mei-appit ni kagihheba hu henin nunman ni hi-gak e Ap-Apu di altar. ");
INSERT INTO ify_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Dammutun ebbulutek hu animal ni nebuni winu wada ekket ni dipektoh tu hedin meiggeb-at ni mei-appit. Nem eleg mabalin ni ida mei-appit di pengippeamnuan ni insapatah ni pehding. ");
INSERT INTO ify_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Niya eleg mabalin ni yu i-appit ni hi-gak hu animal ni negapun, winu napdit, winu neliputan winu negedged et ma-kal hu batbatu tu. Eleg mei-ebbulut hu henin nunman eyad bebley yu. ");
INSERT INTO ify_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ey entan tu iappit hu hanniman ni animal ni gintang yud hansinu-wan. Eggak ebbuluta henin nunman ni animal tep meibbillang ni wada dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Hedin neiimpah hu baka, ya kalneroh winu gelding, ey eleg ni mabalin ni appilen inetu ingganah melebbah pitun aggew. Hedin nelabah hu pitun aggew ey dammutun mei-appit ni kagihheba humman ni impah tu. ");
INSERT INTO ify_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Eleg mabalin ni yu i-appit hu han-inan baka winu kalneroh ni hakey ni aggew. ");
INSERT INTO ify_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Hedin man-appit kayun pansalamatan yun hi-gak, ey mahapul ni u-unnuden yudda etan intugun kun meunnud et hannak abuluta hu i-appit yu. ");
INSERT INTO ify_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ey mahapul ni kennen yun emin hu in-appit yun nunman ni aggew. Eleg mabalin ni wada yu tetdaan. Hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","U-unnud yun emin hu tugun ku, tep hi-gak hu Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Entan tu langlangkuyyaen hu kayyaggud ni peteg ni ngadan ku. Mahapul ni emin hu tutu-ud Israel ey ebbuluten da e kayyagguddak ni peteg. Hi-gak hu Ap-Apu ni nemilin hi-gayu, ey dakeyu kapambalin ni kayyaggud. ");
INSERT INTO ify_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Mukun impangulu dakeyun neni-yanan yun Egypt ey ma-lat hi-gak hu daydayawen yu. Hi-gak hu Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Kan mewan Apu Dios nan Moses ey “Ehel muddan edum mun helag Israel huyyan ittugun kun hi-gada: Huyyadda hu piyestah ni meippahding ma-lat maemung kayun helag Israel ni mandeyyaw. ");
INSERT INTO ify_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Mei-ebbulut kayun mangngunnun enem ni aggew. Nem yan meikkeppitun aggew e Sabaduh e kamengillin ni aggew ey mahapul ni man-iyyatu kayu, tep neieng-eng huyyan aggew ni hi-gak ma-lat maemung kayun mandaydayaw ni hi-gak, anin ni attu pambebleyan yu. ");
INSERT INTO ify_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Huyyadda hu piyestah ni pehding yud nagtud ni aggew. ");
INSERT INTO ify_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Mahapul ni pehding yu hu Piyestah ni Passover ma-lat keidaydayawak e Ap-Apu yu. Ya pengilleppuan yun pengippahdingan nunyan piyestah, ey yan mahmahdem ni meikkahampulun epat ni aggew ni memengngulun bulan. ");
INSERT INTO ify_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Et yan meikkahampulun liman aggew ey illapu yun eleg mengngan ni sinapay ni neha-adan ni kamampelbag e huyya pehding yun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Yan memengngulun aggew nunman ni pampiyestahan yu ey meemmung kayu et mandayaw kayun hi-gak. Endi nisi mangngunnun nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Man-appit kayun hi-gak ni kagihheba ni kewa-wa-wan pitun aggew. Ey kaemung kayu mewan ni meikkeppitun aggew, ma-lat mandayaw kayun hi-gak niya eleg kayu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Hedin umlaw kayu etan di bebley ni iddawat kun hi-gayu et man-enni kayu, ey ilaw yun padi hu memengngulun hakey ni betek ni ennien yu. ");
INSERT INTO ify_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Itta-gey ni padi humman et peang-ang tun hi-gak e Ap-Apu ni nunman ni aggew ni meittu-nud di Sabaduh ma-lat abuluten dakeyun hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Yan nunman ni aggew ey i-appit yun hi-gak hu hantoon tun lakkitun kalneroh e endi dipektoh tu et giheben yu. ");
INSERT INTO ify_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Pakigiheb yu dewwan kiloh ni kamei-appit ni alinah ni neha-adan ni mansikan olibah. Kamengippeamleng ni hi-gak hu hamuy idan nunman ni i-appit yun kagihheba. I-dum yun i-appit hu hakey ni litroh ni meinnum. ");
INSERT INTO ify_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Entan tu ekan ida pakeani yu, anin ni ematta, winu neihanglag, winu nekapyan sinapay, hedin eleg yu ni iappit ida humman nan Apu Dios. Mahapul ni mannenneng ni u-unnuden ni helag yun ingganah huyyan tugun, anin ni attu kad-an da. ");
INSERT INTO ify_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Bilang yu pitun linggu meippalpun kewa-waan ni Sabaduh ni nengilawwan yu etan ni padin hambetek ni ineni yu et iappit tun hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ey man-appit kayu mewan ni pagey ni nunman ni aggew ni kewa-waan ni meikkeppitun Sabaduh. ");
INSERT INTO ify_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Wada hakey ni pamilyah ey man-appit ni hi-gak e Ap-Apu ni dewwan sinapay ni nekapyad dewwan kiloh ni alinah ni nekamdugan ni kamampelbag. Humman ni kamei-appit ni memengngulun ineni yu ey iddawat yun hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","I-dum yun nunman ni i-appit yun hi-gak hu pitun lakkitun impah ni kalneroh e hantoon da ya hakey ni bulug ni baka, niya dewwan lakkitun kalneroh e endi dipektoh dan emin, et iappit dan kagihheba. Ey i-dum yun i-appit hu begah niya meinnum. Ya hamuy idan nunya ey kamengippeamleng ni hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ey man-appit kayun hakey ni lakkitun gelding tep ya liwat niya dewwan hantoon ni lakkitun kalneroh ni pekiddagyuman yun hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Itta-gey ni padin peang-ang ni hi-gak e Ap-Apu ida humman ni dewwan lakkitun kalneroh et yadda sinapay ni nekapyad pakeanin pagey et iappit yun hi-gak. Huyyaddan kamei-appit niya mei-eng-eng ni hi-gak ey meidwat idan padi. ");
INSERT INTO ify_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Entan nisi pangngunu yun nunyan aggew, nem kaemung kayu et mandaydayaw kayun hi-gak. Mannenneng huyyan tugun ni ingganah ey mahapul ni u-unnuden idan helag yu, anin ni attu pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Hedin man-enni kayu ey entan tu paka-ala hu pagey di nangkeigillig ey entan an kaibangngad et yu paka-al-en ida linabhan yu. Diman ida humman ma-lat wada ellan idan newetwet niyadda nekibebley ni hi-gayu. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Yan memengngulun aggew ni meikkeppitun bulan ey mahapul ni man-iyyatu kayu. Petnul yu tangguyup yu et maemung kayun emin ni mandaydayaw. ");
INSERT INTO ify_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Entan nisi pangngunu yu, nem pan-appit kayun hi-gak e Ap-Apu ni kagihheba.” ");
INSERT INTO ify_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Kan mewan nan Apu Dios nan Moses ey “Ipahding yu hu elaw ni ke-kalan ni liwat idan tuu etan ni meikkeppulun aggew nunman ni meikkeppitun bulan ni katootoon. Mantetpel kayu e eleg kayu mengngan nunman ni aggew. Meemmung kayun mandaydayaw niya man-appit ni kagihheban hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Entan nisi pangngunu yun nunman ni aggew tep yan nunman pengippahdingan yun elaw ni ke-kalan ni liwat. ");
INSERT INTO ify_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ya etan tuun mengngan e eleg mantetpel nunman ni aggew ey eleg law meibbillang ni tuuk. ");
INSERT INTO ify_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ey petteyen ku etan tuun mangngunnun nunman ni aggew tep eleg mengu-unnud. ");
INSERT INTO ify_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Tep endi nisi mangngunnun nunman ni aggew. Mannenneng huyyan tugun ey mahapul ni u-unnuden ni emin ni helag Israel, anin ni attu pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Huyyan aggew ni pan-iyyatuan ey meippalpun kelinnugan ni aggew ni meikkahyam ni aggew ingganah melinnug hu aggew ni kewa-waan tu, e humman meikkahampulun aggew nunman ni meikkeppitun bulan. Yan nunman ni aggew ey endi nisi hu mengngan.” ");
INSERT INTO ify_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Kan mewan Apu Dios nan Moses ey “Ehel muddan helag Israel huyya: Ya Piyestah ni Kampu ey ipahding yun pitun aggew, meippalpun meikkahampulut liman aggew ni nunman ni meikkeppitun bulan. ");
INSERT INTO ify_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Yan memengngulun aggew ey meemmung kayun mandaydayaw ni hi-gak niya eleg kayu mangngunu. ");
INSERT INTO ify_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Man-appit kayun kagihheba ni kewa-wa-wan nunman ni pitun aggew. Ey yan meikkewwalun aggew ey meemmung kayu mewan et mandaydayaw kayu niya man-appit kayun kagihheba. Endi nisin hi-gayu hu an mangngunnu. ");
INSERT INTO ify_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ipahding yudda huyyan piyestah et mandaydayaw kayun hi-gak e Ap-Apu e man-appit kayun kagihheba, ya begah, ya kakenna et ya kainnuma. Mahapul ni pehding yudda huyyad nagtud ni aggew ni keippahdingan tu. ");
INSERT INTO ify_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Huyyaddan piyestah ni pehding yu ey mei-dum di pengu-unnudan yun elaw ni Sabaduh, yadda kenayun ni yuka iddawat, yadda yuka i-appit ni insapatah yu et yadda yuka iggeb-at ni iddawat ni hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Hanniman nisi pehding yu e hedin man-enni kayu ey mampiyestah kayun pitun aggew ni pandeyyawan yun hi-gak e Ap-Apu. Ilepu yun meikkahampulut liman aggew ni meikkeppitun bulan. Nemnem yu e yan memengngulu et yan meikkewwalun aggew ey man-iyyatu kayu. ");
INSERT INTO ify_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Yan nunman ni memengngulun aggew ey um-ala kayuddan kekakkayyaggudan ni lameh ni intanem yun keyew, ya bulung ni palmah et ya makabbulung ni pangan keyew et ilepu yu piyestah ni pandaydayaw yun hi-gak e Ap-Apu e Dios yun pitun aggew. ");
INSERT INTO ify_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hi-gayu et yadda helag yu ey mahapul ni pehding yu huyyan piyestah ni pitun aggew ni meikkeppitun bulan ni katootoon. ");
INSERT INTO ify_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ey mahapul ni manha-ad kayud kampun pitun aggew, ");
INSERT INTO ify_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ma-lat pengamtaan idan helag yun edum ni aggew e hi-gak e Ap-Apu ey impangkampuk ida la aammed yu eman ni nengipenguluak ni hi-gadan neni-yanan dan Egypt. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Huttan ida piyestah ni inhel Moses ni pehding idan helag Israel ni pandaydayaw dan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ehel muddan helag Israel et umi-liddan nemahmah ni lanan olibah, et iha-ad yuddad kengkeh di Tabernacle ma-lat mannananeng ni eleg me-dep hu dilag diman. ");
INSERT INTO ify_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Integan Aaron ida humman ni kahilehileng niya ang-angen tu et mandiddillag ingganah mewa-wa etan di ba-hil ni kultinah di kuwaltuh ni kad-an kun Ap-Apu. Huyyan olden ey mannananeng ni meunnud ni ingganah. ");
INSERT INTO ify_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Mahapul ni wadan ingganah hu mengippaptek idan nunman ni kengkeh ni neipetuk di balituk ni kapengippettukid kad-an kun Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Usal yu hampulut dewwan kiloh ni alinah, et mengapya kayun hampulut dewwan sinapay. ");
INSERT INTO ify_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Iha-ad yudda humman ni sinapay e mandedwan metu-tu-nud e han-e-nem etan di nemahmah ni balituk ni tebol di kuwaltuh ni kad-an kun Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Wakgihi yun bangbanglun insensoh hu nambattanan idan netu-tu-nud ni sinapay, et humman hu i-appit yun kagihheban hi-gak e Ap-Apu, e beken ida etan sinapay. ");
INSERT INTO ify_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mahapul ni ihha-ad yu hu henin nunman ni sinapay di kad-an kun Ap-Apu hedin nedateng hu Sabaduh. I-appit yun ingganah ida humman ni sinapay ni hi-gak, ma-lat mannananeng hu nekitbalan kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Meidwat ida humman ni sinapay nan Aaron niyadda lalakkin helag tu et kanen dad kad-an ku tep humman patal da etan di kennen ni kamei-appit ni kagihheban hi-gak e Ap-Apu.” ");
INSERT INTO ify_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Wada hakey ni lakin iEgypt hu ametu ey helag Israel hu inetu, e nekibekal ni hakey ni helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Huyyan laki ey u-ungngan Selomit e u-ungngan Dibri e helag Dan. Yan nunman ni nekibekalan tu ey lawah ni peteg hu inhel tun Apu Dios et ilaw dad kad-an Moses, ma-lat ehelen tu hedin hipa meippahding nunman ni laki. ");
INSERT INTO ify_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ginuwalyaan da et hegeden da hedin hipa pinhed Apu Dios ni pehding dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ilaw yu huttan ni lakid a-allaw eyan kampu, ma-lat emin ida nangngel ni lawah ni peteg ni inhel tu, ey itta-pew da ngamay dad ulu tu et tistiguan da e nanliwat et pantengbaen yun emin ni bimmebley et matey.” ");
INSERT INTO ify_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Heninnuy ehel muddan helag Israel: “Ya etan tuun lawah e-helen tun Apu Dios ey heltapen tu kastigu tu, tep ya humman ni liwat tu. ");
INSERT INTO ify_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ey ya kastigun tuun manliwwat ni henin nunman, anin ni helag Israel winu nekibebley ni hi-gada, ey tengbaen idan bimmebley ni helag Israel et matey. ");
INSERT INTO ify_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Hedin pimmatey hu hakey ni tuu ey mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ya memettey ni animal ni edum ni tuu ey mahapul ni hullullan tu. Ey mahapul ni ya mategu hu ihhullul tud pintey tu. ");
INSERT INTO ify_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ya etan tuun liniputan tu edum tu, ey mahapul ni meippahding daman hi-gatu humman ni impahding tu. ");
INSERT INTO ify_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Hedin himpung ni tuu hu genit ni hakey ni tuu, ey mahapul ni hehpungen dama genit etan ni nambahul. Hedin kinulap ni tuu hu hakey ni matan edum tun tuu, ey mahapul ni mekullap dama hakey ni mata etan ni nambahul. Hedin pinlag ni hakey ni tuu hu hakey ni ngipen ni edum tun tuu, ey mahapul ni e-kalen dama hakey ni ngipen etan ni nambahul. Mahapul ni meippahding dama etan ni tuu hu impahding tun edum tu. ");
INSERT INTO ify_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Hedin pintey ni hakey ni tuu hu animal ni edum tun tuu, ey mahapul ni hullulan tu. Nem hedin tuu pintey tu, ey mahapul ni mettey dama. ");
INSERT INTO ify_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Huyyaddan olden ey mahapul ni u-unnuden yun emin ni helag Israel, anin idan nalpud edum ni bebley ni nekibebley ni hi-gayu. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Negibbuh ni inhel Moses idan helag Israel ida huyyan tugun et ilaw da humman ni nanliwat di a-allaw ni bebley et tengbaen da et matey e inu-unnud da inhel Apu Dios nan Moses ni pehding da. ");
INSERT INTO ify_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yan eman ni wada hi Moses di Duntug e Sinai ey kan Apu Dios ni hi-gatu ey ");
INSERT INTO ify_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Ehel mudda huyyan ittugun kuddan helag Israel: Hedin umlaw kayud bebley ni iddawat kun pambebleyan yu, ey panlatang yu hu payew yun kapitun toon, et pengipeang-angan yun yuka pandeyyaw ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Enem ni toon hu dammutun pemeyyewan yun payew yu, ya pengkalan yun pingin intanem yun grapes, ya pengennian yu niya pemuggahan yun lameh idan intanem yun kamekkan. ");
INSERT INTO ify_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Nem yan meikkeppitun toon ey mahapul ni panlatang yu hu puyek yu, tep humman ni toon ey neieng-eng nan Apu Dios. Entan tu tanemi payew yu ey entan tu ekal hu pingin intanem yun grapes ni nunman ni toon. ");
INSERT INTO ify_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ey eleg mabalin ni kayu mantennem winu yu ellan hu lameh idan hipan impemegga tu temel e eleg yu itnem, anin idan lameh ni grapes ni eleg yu ekalen pingi da. Tep humman ni toon hu heni pan-iyyatuan ni puyek yu. ");
INSERT INTO ify_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Anin ni eleg mepeyyew ni hantoon hu puyek yu, et eleg kayu me-puhin kennen yuddan pamilya yu, yadda bega-en yu, yadda kametangdanin yuka pangngunnu, yadda hansinu-wan ni nekibebley ni hi-gayu, ");
INSERT INTO ify_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","yadda animal yu niyadda ma-lem ni animal ni wadad puyek yu. Dammutun kennen yu lameh idan simmemel di payew yu niyad legunta yun eleg yu ipaptek. ");
INSERT INTO ify_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ya hakey mewan ni pehding yu ey bilang yu hu na-pat et heyam ni toon e meminpittu hu pitun toon, ");
INSERT INTO ify_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","et yan meikkeppulun aggew ni meikkeppitun bulan ni meikkeneliman toon e yan nunman hu Aggew ni Ke-kalan ni Liwat idan tuu, ey petnul yu tangguyup di kebebbebley. ");
INSERT INTO ify_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Huyyan meikkeneliman toon ey mei-eng-eng ni hi-gak. Man-am-amleng kayun nunyan toon, tep anin idan neigtang ni himbut et meibbangngad idad pamilyah da dedan. Ey emin hu neigtang ni puyek ey meibbangngad di kampuyek. ");
INSERT INTO ify_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Yan nunman ni meikkeneliman toon ey eleg kayu mantennem niya eleg yu ella lameh idan impemegga da temel, anin idan lameh ni grapes di legunta yun eleg yu ipaptek, ");
INSERT INTO ify_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","tep neieng-eng humman ni toon ni hi-gak. Ekan yu etan ineni yu ngu dedan di payew yu. ");
INSERT INTO ify_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Yan nunyan toon ey meibbangngad ni emin hu neigtang ni puyek di kampuyek dedan. ");
INSERT INTO ify_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Et humman hu, hedin wada gettangen yu, winu iggatang yun puyek di edum yun helag Israel, ey entan tu talam. ");
INSERT INTO ify_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ya pambalol yu ey meippuun di piga kameenni ey hedin pigan toon et han madeteng hu pengippebangngadan yu. ");
INSERT INTO ify_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Hedin dakel pay ni toon hu melebbah et han madeteng humman ni toon, ey nengingnginna pambalol yu, nem hedin anggegannu kedettengan tu, ey nelallakkah, tep ya kamebeyyadi ey ya kedakkel ni pan-ennian etan di puyek. ");
INSERT INTO ify_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Entan panhintatalam yu, tep humman pengippeang-angan yun kayu kamengu-unnud ni hi-gak. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","19","Hedin u-unnuden yun emin hu tugun ku niya olden ku ey melinggep hu panha-adan yud bebley yu, ey dakel ennien yu e eleg kayu me-puhin kennen yu. ");
INSERT INTO ify_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kanyu na-muy ‘Hipa tep kennen min meikkepitun toon hedin eleg kami mantennem et endi ennien mi?’ ");
INSERT INTO ify_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Heninnuy humang nuntan: ‘Panyaggud kulli ittanem yun meikka-nem ni toon et dakel hu ennien yu ma-lat mandammun kennen yun tellun toon. ");
INSERT INTO ify_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hedin mantennem kayu law ni meikkewwalun toon ey nanengtun wada pay etan hu ineni yu lan meikka-nem ni toon, et humman kennen yu. Eleg kayu me-puhi ingganah medetteng hu intanem yun meikkahyam ni toon.’ ");
INSERT INTO ify_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ya puyek yun iggatang yu ey beken ni lebbengtun an mannananeng ni meigtang, tep hi-gak kampuyek nunman, beken yu puyek. Kayu kamekibebbebley ni ebuh niya kayu kamekipappayyew ni ebuh eyad bebley ku. ");
INSERT INTO ify_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Emin hu puyek ni neigtang ey wada kelebbengan ni kampuyek ni memangngad. ");
INSERT INTO ify_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Hedin nambalin ni newetwet hu hakey ni helag Israel et nepilitan ni nengigtang ni puyek tu, ey dammutun ya keih-ihnupan ni aaggi tu hu memangngad nunman ni puyek. ");
INSERT INTO ify_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Hedin endiddan aaggi tu hu kabaelan tun memangngad, et entanniy wada dammutun pemangngad etan ni nengigtang, ey dammutun hi-gatu mismuh hu memangngad. ");
INSERT INTO ify_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Mahapul ni ibbangngad tu pihhuh etan ni nengatang meippuun di balol tu hedin mampiggan man-enni ingganah di nagtud ni toon ni pengibbangngadan ni gintang. ");
INSERT INTO ify_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Nem hedin kulang hu pihhuh nunman ni tuun pemangngad tun puyek tu, ey mannenneng hu kelebbengan etan ni nengatang ingganah medettengan etan toon ni pengippebangngadan ni gintang. Yan nunman ni toon hu pengibbangngadan emin ni gintang ni puyek di kampuyek. ");
INSERT INTO ify_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Hedin ya baley ni neigtang ey wadad nehammad ni neluhud ni bebley, ey wada kelebbengan ni kambaley ni memangngad hedin eleg malebbah hu hantoon meippalpu etan ni aggew ni neigtangan nunman ni baley. ");
INSERT INTO ify_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nem hedin eleg bangngada etan ni nengigtang nunman ni toon, ey mambalin law ni baley etan ni nengatang. Eleg law mabalin ni meibbangngad etan di nengigtang anin ni medettengan etan toon ni pengippebangngadan ni gintang. ");
INSERT INTO ify_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nem hedin ya etan baley di eleg maluhud ni bebley, ey meibbillang ni heni payew e wada kelebbengan ni kambaley ni memangngad nunman ni baley tun kumpulmih ni aggew niya mahapul ni meibbangngad di nengigtang ni nagtud ni toon ni pengippebangngadan ni ginetang. ");
INSERT INTO ify_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Nem hedin yadda helag Levi ey wada kelebbengan dan memangngad ni neigtang ni baley dan wadad bebley dan kumpulmih ni aggew, hedin wada humman ni baley dad bebley da. ");
INSERT INTO ify_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Hedin wada baley ni inggatang idan helag Levi ni wadad bebley dan eleg mebangngad, ey mahapul ni meibbangngad di nagtud ni toon ni pengippebangngadan ni gintang, tep hedin yadda baley idan helag Levi di nambebleyan da ey baley da ngu dedan ni ingganah. ");
INSERT INTO ify_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Nem hedin yadda pattullan di nanlinikweh di bebley da, ey eleg mabalin ni iggatang da, tep puyek idan helag Levi ni ingganah. ");
INSERT INTO ify_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Hedin wadadda dinagsi yun helag Israel hu nambalin ni newetwet, et eleg paketuging ni annel tu, ey mahapul ni iddawtan yun mahapul tu henin yuka pehding ni yuka tangtangdanin yuka pangngunnu, ma-lat nanengtun mekibbebley humman ni edum yun helag Israel ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Entan tu peporsentoh hu peuttang yun hi-gatu. Nem u-unnud yu Dios yu et ibilang yun agi yu niya pekibebley yud nambebleyan yu. ");
INSERT INTO ify_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Entan nisi tu peporsentoh hu peuttang yun hi-gatu ey entan tu panggenansahid kennen ni iggatang yun hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hi-gak hu Ap-Apu e Dios yun nengipengulun hi-gayun neni-yanan yun Egypt, ma-lat i-li dakeyud bebley di Kanaan et hi-gak dayawen yun Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Hedin wada hu edum yun helag Israel ni nambalin ni nakawwetwet et mahapul ni ihhehbut tu annel tun hi-gayu, ey entan tu pangngunun henin himbut. ");
INSERT INTO ify_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Mekihha-ad ni hi-gayun heniddan yuka tangtangdanin yuka pangngunnu ingganah medettengan etan nagtud ni Toon ni Jubilee ni keliblihan tu. ");
INSERT INTO ify_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Yan nunman ni toon ey meibbangngad idad pamilyah dad bebley ni nahlagan da e kad-an idan aaggi da. ");
INSERT INTO ify_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Hi-gayun helag Israel ey bega-en dakeyun hi-gak e Ap-Apu yun nengipengulun hi-gayun neni-yanan yun Egypt. Humman gaputun eleg mabalin ni kayu meihbut. ");
INSERT INTO ify_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Entan tu ibubbunget ida, nem u-unnud yuwak e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Hedin mahapul yu himbut, ey gatang kayud bebley di nanlinikweh ni bebley yu. ");
INSERT INTO ify_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Dammutu mewan ni umgatang kayun u-ungngaddan edum ni tuun nekibebley ni hi-gayu. Ey dammutun panhimbut yudda u-ungnga dan neiungngad bebley yu. ");
INSERT INTO ify_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ey dammutun beltanen idan u-ungnga yu et panhimbut dadda ingganah mettey ida. Nem hedin yadda edum yun helag Israel, ey eleg mabalin ni hanniman pehding yun hi-gada. ");
INSERT INTO ify_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Hedin wada edum ni tuun nekibebley ni hi-gayun kimmedangyan niya hedin wada edum yun helag Israel ni nambalin ni newetwet et tu inhebut annel tun nunman ni tuu, winu yaddad u-ungngan nunman ni kedangyan, ");
INSERT INTO ify_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ey wada kelebbengan nunman ni himbut ni mebangngad. Dammutun ya lakin agi tu memangngad ni hi-gatu, ");
INSERT INTO ify_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","winu ya lakin agin ammed tu, ya naka-ihnup ni aaggi tu, winu hi-gatu mismuh hu memeyyad ni keliblihan tu, hedin wada inemung tun pihhuh tu. ");
INSERT INTO ify_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Mahapul ni e-helen tu etan ni nengatang ni hi-gatu, et bilangen da toon meippalpun neigtangan tu ingganah ni kedettengan ni nagtud ni toon ni keibbangngadan ni gintang, et ihummangan da meibbeyyad ni keliblihan tu meippuun di katangdanan kametangdanin kapangngunnu. ");
INSERT INTO ify_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Hedin ayepaw hu kedettengan ni toon ni pengibbangngadan ni gintang, ey mahapul ni e-etteng ni pihhuh hu pebangngad tu etan ni nengatang ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nem hedin anggegannu kedettengan nunman ni toon, ey ekkut ni ebuh hu beyyadan tun pemangngad tu, ");
INSERT INTO ify_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ma-lat heni netangdanan ni katootoon. Mahapul ni ang-ang yu et eleg panligligat etan ni nengatang ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Hedin wada helag Israel ni eleg meliblih ey nedateng hu meikkeneliman toon e humman hu toon ni pengippebangngadan emin ni gintang ey mahapul ni meliblih ida et yadda u-ungnga da. ");
INSERT INTO ify_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ya helag Israel ey eleg mabalin ni manhimbut ni ingganah, tep himbut dakeyun hi-gak. Hi-gak hu nengipengulun hi-gayun neni-yanan yun Egypt. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Kan mewan Apu Dios ey “Entan pengapkapya yun i-ingngeh ni dios ni deyyawen yu henin tuttu-u, yadda pinaot ni keyew, winu batu, tep hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Pannananeng yun u-unnuden hu elaw ni Sabaduh niya lispituh yu hu baley kun yuka pandeyyawin hi-gak. Hi-gak hu Ap-Apu e Dios yu. ");
INSERT INTO ify_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Hedin u-unnuden yu tugun ku ma-lat maiunnud di pinhed ku hu pambiyag yu, ");
INSERT INTO ify_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ey peellik hu udan ni aggew ni peneppulan yu, ma-lat wada ennien yu niya ma-lat lumemeh ida intanem yun keyew ni kamekkan lameh da. ");
INSERT INTO ify_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ey umyaggud hu intanem yu et eleg mepappeg hu pan-ennian yu ey medetteng mewan hu pemuggahan yun grapes. Eleg mewan megibbuh pemuggahan yun grapes ey medettengan mewan hu pantenneman yu. Meweddan emin hu mekkan ni pinhed yun kennen niya melinggep kayud bebley yu. ");
INSERT INTO ify_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Weddaek hu linggep di bebley yu et mekallinggep kayun meuggip e endi tekkutan yu. Ey iddawwi kudda ida anggetakkut ni animal ni memettey ni hi-gayu niya eggak i-abulut ni wada mengubbat ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ey hi-gayu pengapput ku hedin wada mengubbat ni hi-gayu, ");
INSERT INTO ify_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ma-lat anin ni ebuh hu liman hi-gayu et apputen yu hanggatut, niya anin ni ebuh hu hanggatut ni hi-gayu et apputen yu hampulun libu. ");
INSERT INTO ify_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ey bendisyonan dakeyu ma-lat dakel ali helag yu, niya ma-lat umamnu hu nekitbalan kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Bendisyonan ku mewan hu intanem yu ma-lat dumakkel ni peteg hu ennien yu. Et pan-ibbeng yulli baak yu ma-lat wada pengihha-adan yun pakeani yu. ");
INSERT INTO ify_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mekibbebleyyak ni hi-gayu ey eleg dakeyu iwwalleng. ");
INSERT INTO ify_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Em, mekibbebleyyak ni hi-gayun ingganah et hi-gak hu daydayawen yun Dios yu ey hi-gayu pantu-uk. ");
INSERT INTO ify_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Hi-gak hu Ap-Apu e Dios yu. Impa-kal dakeyud Egypt, ma-lat eleg kayu mannananeng ni himbut idan tuudman. Ingkal ku kabaelan dan mengippehelheltap ni hi-gayu, ma-lat meliblih kayu e eleg kayu law mebabba-ingi.” ");
INSERT INTO ify_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Kan mewan Apu Dios ey “Hedin eleg yuwak u-unnuda niya hedin ngenghayen yudda huyyan tugun kun hi-gayu, ");
INSERT INTO ify_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","niya hedin iwwalleng yu tugun ku et eleg yu pehding hu in-olden kun pehding yu, ey hedin ippangil yu nekitbalan kun hi-gayu, ");
INSERT INTO ify_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ey kastiguen dakeyun hi-gak. Peellik ligat ni hi-gayu, henin degeh ni eleg meeggahi, ya nemahhig ni atung ni annel e kaumkulap niya degeh ni kamengpuh annel. Hedin mewan mantennem kayu, ey endi silbitu tep hehgepen dakeyun buhul yu et hi-gada mengngan ni intanem yu. ");
INSERT INTO ify_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Iwwalleng dakeyun hi-gak et meapput kayud gubat ey yadda tuun anggebe-hel dakeyu hu pan-ap-apu yu. Nemahhig ali takut yu et anin ni endi memdug ni hi-gayu et memsik kayu. ");
INSERT INTO ify_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Hedin meippahding ida huyyan hi-gayu ey kapyatun eleg yuwak u-unnuda, ey e-duman ku mewan ligat yun pambalin kun memimpittu hu kaligat tu. ");
INSERT INTO ify_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Eggak peelli udan et kumelhi hu puyek ni pantenneman yun heni gumek, et pemappeg kun yuka pampahhiyyai. ");
INSERT INTO ify_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ey anin piga pehding yun man-aatun mangngunnu et endi silbitu, tep endi illameh ni ittanem yu. ");
INSERT INTO ify_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Hedin pannananeng yun mangngenghay ni hi-gak et eleg yuwak u-unnuda, ey kastiguen dakeyu mewan et edumak hu ligat yun memimpittu. ");
INSERT INTO ify_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Peellik hu anggetakkut ni animal di muyung ma-lat pampateyen da u-ungnga yu, ey ma-lat bahbahen da animal yu. Hahhakkey ali tetdaan dan hi-gayu et mebel-ah dalan yu. ");
INSERT INTO ify_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Hedin eleg kayu mesilleg idan nunyan pengastiguk ni hi-gayu et nanengtun ngenghayen yuwak e eleg yuwak dedngela, ");
INSERT INTO ify_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ey kastiguen dakeyu mewan ni hi-gak et edumak ni meminpittu hu ligat yu. ");
INSERT INTO ify_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Peellik hu mengubbat ni hi-gayu tep ya nengihallaan yun nekitbalan kun hi-gayu. Hedin mewan neamung kayun meihhikkug idad etta-teng ni bebley ey peellik hu eleg meeggahin degeh et mapilit kayun mansukkuh idan buhul yu. ");
INSERT INTO ify_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Bahbahek hu pengellaan yun kennen yu et dammutu hu hakey ni ebuh ni pene-engan ni sinapay ni ussalen ni hampulun bibi-in pengihhe-engan dan metdaan ni alinah yu, et humman hanna-kuten yun ikaka-peng. Et anin ni mengngan kayu et eleg kayu mephel. ");
INSERT INTO ify_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Nem hedin eleg kayu pay masileg et nanengtun manghay kayu e eleg yuwak u-unnuda, ");
INSERT INTO ify_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ey kastiguwen dakayu mewan tep ya bunget ku et meminpittu kaligat tu nem ya etan impalebah yun nengastiguk ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Nemahhig ali upa yu e eleg yulli han-isipel et kennen yulli u-ungnga yu. ");
INSERT INTO ify_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Bahbahen kudda mewan yuka pandeyyawin wadad ta-pew ni duntug, anin idan yuka pengiggihhebin insensoh, niya ibbeng ku netey ni annel yud kad-an idan kinapya yun i-ingngeh ni dios yu. Anggebe-hel dakeyullin hi-gak, ");
INSERT INTO ify_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ey bahbahek bebley yu et yadda yuka pandeyyawi niya eggak ebbuluta hu i-appit yun hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Pakabbahbahek hu bebley yu et mahngang idalli buhul yun um-alin mambebley diman ni penang-angan dan nakabbahbahan tu. ");
INSERT INTO ify_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Peellik ali mengubbat ni hi-gayu et iwehit dakeyud kebebbebley et mebel-ah hu pupuyyek yu niya mannananeng ni mebahbah hu bebley yu. ");
INSERT INTO ify_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Et mei-ellig ni man-am-amleng idallin man-iyyatu hu pupuyyek yu, tep eleg yu u-unnuden hu intugun kun pan-iyyatuan ni puyek yun nunman idan toon. Ey yan nunman iddallin toon ni panha-adan yud bebley idan buhul yu ey mebel-ah puyek yu ma-lat man-iyyatudda. ");
INSERT INTO ify_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ey hedin yadda metdaan ni hi-gayu ey pambalin dakeyun makattakut idad bebley ni keillawwan yu, et anin ni tenul ni ebuh ni bulung ni keyew ni meiddibdib et umbesik kayu tep ya takut yu e heni dakeyu kapampedugan buhul yud gubat. Ey anin ni endi meihnup ni buhul yu et metu-li kayu. ");
INSERT INTO ify_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Mangketu-li kayulli anin ni endi kamampemdug ni hi-gayu. Ey endilli kabaelan yun mekihhanggan buhul yu. ");
INSERT INTO ify_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mangkettey kayullid bebley ni keillawwan yu e heni dakeyu inekmun idan nunman ni bebley idan buhul yu. ");
INSERT INTO ify_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Et yaddalli hahhakkey ni metdaan ni hi-gayu ey umlelemyung idad bebley ni buhul yu tep ya liwat da niya liwat idan ammed da. ");
INSERT INTO ify_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","Nem hedin negibbuh ni hinelheltap idan tuuk hu nemahhig ni pengastiguk ni hi-gada, tep impalaw kuddad bebley idan buhul da ey lektattuy mampekumbabah ida et mantuttuyyudda et abuluten da liwat da et ya liwat idan ammed dan nangngehay ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Ey yan nunman ali pannemneman kun nekitbalan kun Jacob, hi Isaac, et hi Abraham, et peamnuk ali etan inhel kun nunman ni hi-gada e iddawat kuddan tuuk etan bebley ni pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Humman ni pengippellawwak ni hi-gadad edum ni bebley hu kastigu da tep ya liwat da, tep eleg da u-unnuden ida tugun ku, nem pinihul da. Et yan nunman ni peni-yanan dan bebley da ey heni man-iyyatu hu puyek da. ");
INSERT INTO ify_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Nem anin ni hanniman et eggak ida iwwalleng ey eggak ida pakabbahbaha. Pannananeng ku nekitbalan kun hi-gada, tep hi-gak hu Ap-Apu e Dios da. ");
INSERT INTO ify_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nemnemen kulli mewan hu nekitbalan kun eman idan aammed dan nengipenguluak ni hi-gadan neni-yanan dan Egypt, et ang-angen emin ni tuud kebebbebley hu kabaelan ku. Hi-gak hu Ap-Apu e Dios.” ");
INSERT INTO ify_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Huyyaddan emin hu intugun Apu Dios nan Moses di Duntug e Sinai et han itugun Moses idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Itugun muddan helag Israel huyya: ‘Hedin mansapatah hu hakey ni tuu et ieng-eng tun Apu Dios hu hakey ni tuu, ey beyyadan tu balol tu. ");
INSERT INTO ify_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Huyyadda hu meunnud ni pambeyyad. Ya lakin dewampulu ingganah di na-nem hu toon tu, ey neliman palatah ni silber hu bayad tu. ");
INSERT INTO ify_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ya kat-agun biin hanniman toon tu e dewampulu ingganah di na-nem, ey telumpulun palatah ni silber bayad tu. ");
INSERT INTO ify_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ya lakin lima ingganah di dewampulu toon tu, ey dewampulun palatah ni silber bayad tu. Ya biin hanniman dama toon tu ey hampulun palatah ni silber bayad tu. ");
INSERT INTO ify_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ya lakin hambulan tu ingganah di lima toon tu, ey liman palatah ni silber bayad tu. Ya biin henin nunman toon tu, ey tellun palatah ni silber bayad tu. ");
INSERT INTO ify_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ya lakin nehuluk ni na-nem hu toon tu, ey hampulun liman palatah ni silver bayad tu. Ya biin hanniman dama toon tu, ey hampulun palatah ni silber bayad tu. ");
INSERT INTO ify_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Hedin newetwet etan tuu et eleg tu hanggela hu meibbeyyad, ey illaw tu humman ni neieng-eng ni tuud kad-an ni padi, et ngenamung etan padin menghel ni beyyadan tu meippuun di kabaelan tu. ");
INSERT INTO ify_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Hedin insapatah ni tuu hu animal ni kameibbillang ni malinih e kaebbulutan Apu Dios ni kamei-appit ni hi-gatu, ey mambalin humman ni animal ni neieng-eng ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ey eleg mabalin ni hullulan humman ni animal. Eleg mabalin ni hullulan hu kayyaggud ni lawah winu lawah ni kayyaggud. Hedin hullulan ni nunman ni tuu, ey meidwat nan Apu Dios etan animal ni neieng-eng et ya etan neihullul. ");
INSERT INTO ify_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nem hedin ya insapatah etan ni tuu ey animal ni kameibbillang ni beken ni malinih e eleg ebbulutan Apu Dios ni mei-appit ni hi-gatu, ey mahapul ni illaw etan ni tuu etan ni padi. ");
INSERT INTO ify_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Et ya etan padi menghel hedin kayyaggud winu lawah, et ngenamung tun menghel hedin piga bayad tu, et humman ni inhel tun bayad tu ey eleg mabalin ni mehullulan. ");
INSERT INTO ify_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Hedin pinhed etan ni tuun bangngaden, ey mahapul ni beyyadan tu niya e-duman tu pay ni dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Hedin in-eng-eng ni hakey ni tuu hu baley tun hi-gak e Ap-Apu, ey ya padi menghel ni bayad tu meippuun di klasih nunman ni baley, ey humman ni na-hel ni bayad tu ey eleg mabalin ni mehullulan. ");
INSERT INTO ify_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nem hedin pinhed nunman ni tuun bangngaden humman ni baley, ey mahapul ni beyyadan tu niya e-duman tun dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Hedin ya in-eng-eng ni hakey ni tuu nan Apu Dios ey ya puyek tu, ey ya bayad nunman ey meippuun di kedakkel ni kameitnem diman. Ya bayad ni hakey ni bushel ey hampulun palatah ni silber. ");
INSERT INTO ify_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Hedin neieng-eng hu puyek ni meikkeneliman toon e keibbangngadan ni gintang, ey mannenneng hu balol tu. ");
INSERT INTO ify_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Hedin babbayyag hu neieng-engan tu, ey balolan ni padi meippuun di bilang ni toon ingganah medettengan etan nagtud ni toon ni keibbangngadan ni emin ni gintang et hi-gatu manghel ni balol tu. ");
INSERT INTO ify_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Hedin pinhed etan ni kampuyek ni bangngaden humman ni puyek, ey mahapul ni beyyadan tu niya e-duman tun dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Nem hedin inggatang tu humman ni puyek di edum ni tuu ey eleg tu bayadan nan Apu Dios eman ni nengieng-engan tu, ey meendi law kelebbengan tun memangngad ni nunman ni puyek. ");
INSERT INTO ify_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Et humman hu, hedin medettengan hu meikkeneliman toon ni pemangngadan ni neigtang, ey meibbangngad law idan padi, tep nambalin law ni neieng-eng nan Apu Dios humman ni puyek. ");
INSERT INTO ify_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Hedin in-eng-eng ni hakey ni tuu nan Apu Dios hu payew ni gintang tu, ");
INSERT INTO ify_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ey balolan ni padi meippuun di bilang ni toon et han medatngan humman ni meikkeneliman toon ni pengippebangngadan ni gintang et bayadan nunman ni tuun nunman ni aggew. Ya etan pihhuh ni ibbayad tu ey mei-eng-eng nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Yan nunman ni nagtud ni toon ey meibbangngad etan payew etan di kampuyek dedan winu yadda helag tu. ");
INSERT INTO ify_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Emin hu hipan mebeyyadan ey meippuun di na-hel ni meunnud ni pemeyyad. ");
INSERT INTO ify_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Niya emin mewan hu memengngulun impah ni animal, henin impah ni baka, ya kalneroh niya gelding ey mei-eng-eng nan Apu Dios. Et mukun eleg mabalin ni an iggeb-at ni hakey ni tuun mengi-eng-eng idan nunman ni hi-gatu, tep neieng-eng ida ngu dedan. ");
INSERT INTO ify_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Nem ya nemangulun impah idan kameibbillang ni beken ni malinih ni animal ni neieng-eng ey dammutun bangngaden etan ni tuu hedin beyyadan tu meippuun di kameunnud ni kapemeyyad niya e-duman tun dewampulun porsentoh. Hedin eleg tu bangngada humman ni animal, ey dammutun meigtang humman e mebalolan meippuun di kameunnud ni kapemeyyad. ");
INSERT INTO ify_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nem emin ida neiappit ngu dedan nan Apu Dios, tep neieng-eng idan hi-gatu, henin animal, ya tuu niya puyek, ey eleg mabalin ni mebangngad winu meigtang, tep neieng-eng ida humman ni ingganah nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ya etan tuun pinutuk Apu Dios ni mebahbah ey eleg mabalin ni mebeyyadan ma-lat bangngaden, tep mahapul ni mettey. ");
INSERT INTO ify_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Emin hu illameh ni meitnem ey mei-eng-eng nan Apu Dios hu meikkeppulu. ");
INSERT INTO ify_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Hedin pinhed ni hakey ni tuun bangngaden ida humman ey mahapul ni beyyadan tu meippuun di kameunnud ni kapemeyyad niya e-duman tun dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ey emin hu meikkeppulun animal ey mei-eng-eng nan Apu Dios. Hedin nambilang hu hakey ni tuun animal tu, ey mei-eng-eng nisin Apu Dios hu meikkeppulu. ");
INSERT INTO ify_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Eleg mabalin ni an peppeteken ni tuu etan ida animal ni wada dipektoh tu et humman kantun meikkeppulu. Eleg mewan mabalin ni tu hullulan hu naptek ni meikkeppulu. Hedin hullulan tu etan naptek ni meikkeppulu, ey mei-eng-eng nan Apu Dios etan naptek et ya etan ihhullul tu. Ey eleg law mabalin ni an beyyadan ni tuu ida humman et tu bangngaden.’” ");
INSERT INTO ify_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Huyyadda intugun Apu Dios nan Moses di Duntug e Sinai ni ittugun nan Moses idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yan eman ni nemangulun aggew ni meikkadwan bulan neipalpun neni-yanan idan helag Israel ni Egypt e nanengtun wadaddad Sinai ey immehel hi Apu Dios nan Moses etan di daka pandeyyawi et kantuy ");
INSERT INTO ify_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“Ehel mun Aaron et yu bilangen ida edum yun helag Israel meippuun di pewen da niya pamilyah da. Ilista yudda ngadan emin idan lalakkin dewampulu toon da winu nehuluk e humman ida dammutun mekiggubbat. ");
INSERT INTO ify_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ehel mu et baddangan dakeyuddan ap-apun hanhakkey ni pewen ni mambillang. ");
INSERT INTO ify_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Huyyadda ngadan ni aap-apun neputuk ni umbaddang ni hi-gayu. Yad helag Reuben ey hi Elisur e u-ungngan Sedeur. ");
INSERT INTO ify_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Yad helag Simeon ey hi Selumiel e u-ungngan Surishaddai. ");
INSERT INTO ify_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yad helag Judah ey hi Nashon e u-ungngan Amminadab. ");
INSERT INTO ify_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Yad helag Issakar ey Nethanel e u-ungngan Suar. ");
INSERT INTO ify_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Yad helag Sebulun ey hi Eliab e u-ungngan Helon. ");
INSERT INTO ify_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yad helag Epraim e u-ungngan Joseph ey hi Elishama e u-ungngan Ammihud. Yad helag Manasseh e hakey pay ni u-ungngan Joseph ey hi Gamaliel e u-ungngan Pedahsur. ");
INSERT INTO ify_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Yad helag Benjamin ey hi Abidan e u-ungngan Gideoni. ");
INSERT INTO ify_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Yad helag Dan ey hi Ahieser e u-ungngan Ammishaddai. ");
INSERT INTO ify_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Yad helag Asher ey hi Pagiel e u-ungngan Okran. ");
INSERT INTO ify_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Yad helag Gad ey hi Eliasap e u-ungngan Deuel. ");
INSERT INTO ify_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Yad helag Naptali ey hi Ahira e u-ungngan Enan.” ");
INSERT INTO ify_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Huyyadda neputuk ni mengi-ehneng ni helag da e ap-apuddan pewen da. ");
INSERT INTO ify_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Di Moses nan Aaron niyadda humman ni hampulut dewwan aap-apu ");
INSERT INTO ify_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ey impaeyag dan emin ida helag Israel ni nunman ni aggew, et ilistadadda lalakkin nantoon ni dewampulu et nehuluk meippuun di nahlagan da, ");
INSERT INTO ify_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","tep humman hu naka-ittugun Apu Dios nan Moses. Et bilangen di Moses idadman Sinai e eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Meippalpun Reuben e pengulwan ni u-ungngan Israel e hi Jacob hakey ni ngadan tu, ey inlista dadda helag dan dammutun mansindalun nantoon ni dewampulu et nehuluk meippuun di pewen da niya pamilyah da. Huyya listaan ni bilang da: Ya nahlagan da Ya bilang da Hi Reuben 46,500 Hi Simeon 59,300 Hi Gad 45,650 Hi Judah 74,600 Hi Issakar 54,400 Hi Sebulun 57,400 Di Epraim nan Manasseh e u-ungngan Joseph ey neibilang idan u-ungngan Israel Hi Epraim 40,500 Hi Manasseh 32,200 Huyyadda edum ni helag Israel Hi Benjamin 35,400 Hi Dan 62,700 Hi Asher 41,500 Hi Naptali 53,400 Ya bilang dan emin ey 603,550. ");
INSERT INTO ify_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Yadda helag Levi ey eleg ida mei-dum ni neilista ");
INSERT INTO ify_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","tep inhel Apu Dios nan Moses ni nunman e kantuy ");
INSERT INTO ify_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Entan tudda i-dum di listaan ni mansindalu. ");
INSERT INTO ify_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Tep ya ngunu da ey ya mampaptek ni Tabernacle niyadda ngunut ni wadadman. Hi-gada pay memehhan ni Tabernacle niyadda ngunut diman hedin hi-yanen yu nangkampuan yu et man-e-tan kayu. Ey mahapul ni mangkampuddad nanlinikweh ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Hedin man-e-tan kayu, ey hi-gada hu memukkal ni Tabernacle niya hi-gada mengiyayyaggud ni kei-tanan yu. Eleg mabalin ni an meihnup ida edum yun helag Israel tep mettey ida. ");
INSERT INTO ify_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Meennappil kayun helag Israel ni mangkampu meippuun di pewen yu e wada hakey idan mengipappangngulu ey i-ehneng da pewen da niya wada bandelah da. ");
INSERT INTO ify_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Yad nanlinikweh ni Tabernacle hu pangkampuan idan helag Levi, tep mangguwwalyadda ma-lat endi an meihnup idan edum ni helag Israel, et eleg kudda kastiguen gapuh ni bunget ku.” ");
INSERT INTO ify_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Et ipahding idan helag Israel huyyan emin ni inhel Moses ni intugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Kan Apu Dios mewan nan Moses et hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Hedin mangkampudda hu helag Israel ey wada hakey idan pewen ey metuddu pangkampuan da e wada bandelah ni helag da. Mangkampuddad nanlinikweh e gawwaen da hu Tabernacle, nem meidaddawwidda. ");
INSERT INTO ify_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Yadda mangkampud appit ni kasimillin aggew ey yadda helag Judah, yadda helag Issakar et yadda helag Sebulun. Emin ida ey hakey hu bandelah da. Hi Nashon e u-ungngan Amminadab hu mengipappangngulun helag Judah ");
INSERT INTO ify_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","e ya bilang da ey 74,600. ");
INSERT INTO ify_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Yadda helag Issakar ey hi Nethanel e u-ungngan Suar hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","e ya bilang da ey 54,400. ");
INSERT INTO ify_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Yadda helag Sebulun ey hi Eliab e u-ungngan Helon hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","e ya bilang da ey 57,400. ");
INSERT INTO ify_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ya nga-mut ni bilang idan nunyan tellun helag ey 186,400. Huyyadda hu memengngulud dalan hedin man-e-tan ida helag Israel ni pangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Yadda mangkampud appit ni south ey yadda helag Reuben, yadda helag Simeon et yadda helag Gad. Emin ida ey hakey hu bandelah da. Hi Elisur e u-ungngan Sedeur hu mengipappangnguluddan helag Reuben ");
INSERT INTO ify_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","e ya bilang da ey 46,500. ");
INSERT INTO ify_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Yadda helag Simeon ey hi Selumiel e u-ungngan Surishaddai hu mengipappangulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","e ya bilang da ey 59,300. ");
INSERT INTO ify_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Yadda helag Gad ey hi Eliasap e u-ungngan Deuel hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","e ya bilang da ey 45,650. ");
INSERT INTO ify_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ya nga-mut ni bilang idan nunyan tellun helag ey 151,450. Hi-gada hu meittu-nud. ");
INSERT INTO ify_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Meittu-nud ida helag Levi e pehhanen da hu Tabernacle. Emin ida helag Israel ey mantu-tu-nud idan umlaw e meunnud hu nantutu-nudan dan nangkampu. Wada hakey ey unnuden da bandelah ni helag da. ");
INSERT INTO ify_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Yadda mangkampud appit ni kakelinnugin aggew ey yadda helag Epraim, yadda helag Manasseh niyadda helag Benjamin. Emin ida ey hakey hu bandelah da. Hi Elishama e u-ungngan Ammihud hu mengipapangngulun helag Epraim ");
INSERT INTO ify_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ey ya bilang da ey 40,500. ");
INSERT INTO ify_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Yadda helag Manasseh ey hi Gamaliel e u-ungngan Pedahsur hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","e ya bilang da ey 32,200. ");
INSERT INTO ify_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Yadda helag Benjamin ey hi Abidan e u-ungngan Gideoni hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","e ya bilang da ey 35,400. ");
INSERT INTO ify_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ya nga-mut ni bilang idan nunyan tellun helag ey 108,100. Hi-gada neitu-nud idan helag Levi ");
INSERT INTO ify_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Yadda mangkampud appit ni north ey yadda helag Dan, yadda helag Asher niyadda helag Naptali. Emin ida ey hakey hu bandelah da. Yadda helag Dan ey hi Ahieser e u-ungngan Ammishaddai hu mengipappangnguluddan hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","e ya bilang da ey 62,700. ");
INSERT INTO ify_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Yadda helag Asher ey hi Pagiel e u-ungngan Okran hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","e ya bilang da ey 41,500. ");
INSERT INTO ify_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Yadda helag Naptali ey hi Ahira e u-ungngan Enan hu mengipappangngulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","e ya bilang da ey 53,400. ");
INSERT INTO ify_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ya nga-mut ni bilang idan nunyan tellun helag Israel ey 157,600. Hi-gada manggillig ni meittu-nud hedin man-e-tan idad pangkampuan da.” ");
INSERT INTO ify_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ya bilang emin ni sindalun helag Israel ni neilista ey 603,550. ");
INSERT INTO ify_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Eleg dadda i-e-dum hu helag Levi ni illista, tep humman intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Impahding idan helag Israel hu emin ni hipan intugun Apu Dios nan Moses ni pehding da. In-amag da kampudad pettek ni bandelah da. Hedin mewan man-e-tan ida, man man-uunnud ida e wada hakey ni grupuh ey wada bandelah da, tep humman inhel Apu Dios ni pehding da. ");
INSERT INTO ify_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Huyyadda hu pamilyah Aaron nan Moses ni neitudek eman ni immehel hi Apu Dios nan Moses di Duntug e Sinai. ");
INSERT INTO ify_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Yadda lalakkin u-ungngan Aaron ey hi Nadab e pengulwan, hi Abihu, hi Eleasar et hi Ithamar. ");
INSERT INTO ify_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Neputuk idan mei-eng-eng ni mampeddi, ");
INSERT INTO ify_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","nem netey di Nadab nan Abihu di hinanggan Apu Dios eman ni wadaddad Sinai e eleg mebebleyi, tep nan-appit idan hi-gatun apuy ni eleg mengippeamleng ni hi-gatu. Endi lakin u-ungnga da, et ebuh law hi Eleasar nan Ithamar ni nampadi eman ni ketaggun amedan hi Aaron. ");
INSERT INTO ify_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ayagim idadya hu helag Levi et putuken muddan umbaddang nan Aaron e padi. ");
INSERT INTO ify_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Hi-gada mengippahding idan mahapul ni meingngunnud Tabernacle e kad-an ku et mansilbiddan Aaron niyadda edum dan bimmebley. ");
INSERT INTO ify_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Mahapul mewan ni ippaptek da ngunut di Tabernacle niya mansilbiddadman e i-ehneng dadda edum dan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Putuk mudda nisin umbaddang di Aaron ni han-aamma. ");
INSERT INTO ify_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ebuh di Aaron niyadda lalakkin u-ungnga tun mengippahding ni ngunun padi. Ya kumpulmih ni tuun an meihnup di Tabernacle et tu ipahding hu ngunun padi ey meippepettey.” ");
INSERT INTO ify_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Yadda helag Levi hu pinilik idan helag Israel tep hi-gada hu mei-eng-eng ni hi-gak. Hi-gada meihhullul di emin ni pengulwan ni lalakkin u-ungngaddan helag Israel tep emin hu pengulwan ni lalakkin u-ungngaddan helag Israel ey mei-eng-eng idan hi-gak. Ya eman ni nemateyak idan pengulwan ni lalakkin u-ungngaddan iEgypt ey neieng-eng ni hi-gak idan emin hu pengulwan ni lalakkin u-ungngaddan helag Israel, anin idan nemangulun impah ni animal da. Hi-gak hu Ap-Apu e Dios.” ");
INSERT INTO ify_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Kan mewan nan Apu Dios nan Moses di diman Sinai ey ");
INSERT INTO ify_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bilang mudda lalakkin helag Levi ni hakey bulan tu niya nehuluk meippuun di pewen da niya pamilyah da.” ");
INSERT INTO ify_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Et bilangen Moses ida e inu-unnud tu intugun Apu Dios ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Huyyadda ngadan ni lalakkin u-ungngan Levi: hi Gerson, hi Kohat et hi Merari. ");
INSERT INTO ify_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Wada dewwan u-ungngan Gerson ni lalakki e hi Libni et hi Simei. ");
INSERT INTO ify_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Epat dama lakin u-ungngan Kohat: hi Amram, hi Ishar, hi Hebron et hi Ussiel. ");
INSERT INTO ify_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Dewwa dama hu lalakkin u-ungngan Merari e di Mahli nan Mushi. Huyyadda nahlag nan Levi ni neitudek meippuun di pamilyah da. ");
INSERT INTO ify_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Yadda nahlag nan Gerson ey nalpud pamilyah di Libnih nan Simei. ");
INSERT INTO ify_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ya bilang emin ni lalakkin helag dan neilistan hakey bulan tu niya nehuluk ey 7,500. ");
INSERT INTO ify_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Hi-gada mangkampud awwidan ni Tabernacle di appit ni kakelinnugin aggew. ");
INSERT INTO ify_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Hi Eliasap e u-ungngan Lael hu mengipappangngulun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","26","Hi-gada ngenamung ni mengippaptek ni Tabernacle anin idan ngunut diman, yadda kultinah ni meihhennid heggeppan di bawang niyad dallin, yad nanlinikweh di Tabernacle niyad altar. Hi-gada pay ngenamung ni mengippaptek idan linubid niyadda edum ni kameussal diman. ");
INSERT INTO ify_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Yadda nahlag nan Kohat ey yadda pamilyah Amram, hi Ishar, hi Hebron et hi Usiel. ");
INSERT INTO ify_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ya bilang emin ni lalakkin helag dan neilistan hakey bulan tu niya nehuluk ey 8,600. Hi-gada mengippaptek idan neieng-eng ni usal. ");
INSERT INTO ify_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Hi-gada mangkampud appit ni south. ");
INSERT INTO ify_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Hi Elisaphan e u-ungngan Usiel hu mengipappangngulun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Yaddahhuy hu ippaptek da: ya Kaban Apu Dios, ya tebol, ya pattukkan ni kengkeh, yadda altar, yadda edum ni ngunut ni kaussalan padid bawang ni Tabernacle et ya kultinah ni neihenid heggeppan di kad-an Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hi Eleasar e padin u-ungngan Aaron hu mengipappangngulun emin idan helag Levi. Ey hi-gatu ingkalgaduh idan kamangngunnud Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Yadda nahlag nan Merari ey humman ida pamilyah Mahli nan Mushi. ");
INSERT INTO ify_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ya bilang emin ni lalakkin helag dan neilistan hakey bulan tu niya nehuluk ey 6,200. ");
INSERT INTO ify_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Hi-gada mangkampud north ni Tabernacle. Hi Suriel e u-ungngan Abihail hu mengipappangngulun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hi-gada ngenamung ni mengippaptek idan kalkalimangngan Tabernacle, yadda meibballabag, yadda tukud, yadda pengippeehnengan ni tukud niyaddan emin kameussal deya. ");
INSERT INTO ify_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Hi-gada pay ngenamung ni mengippaptek ni wadad dallin ni Tabernacle heniddan tukud, yadda pengippeehnengan ni tukud, yadda pa-pa niyadda linubid ni mahapul. ");
INSERT INTO ify_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Hi Moses nan Aaron niyadda u-ungnga tun lalakki hu mangkampud hinanggan Tabernacle di appit ni kasimmilin aggew. Hi-gada mengingngunnuddan hipan meippahding di Tabernacle, et mansilbiddan helag Israel. Ya kumpulmih ni tuun mengippatnan mengippahding ni ngunu da ey meippepettey. ");
INSERT INTO ify_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ya bilang emin idan lalakkin helag Levi ni hakey bulan tu niya nehuluk ni inlistad Moses nan Aaron meippuun di intugun Apu Dios ey 22,000. ");
INSERT INTO ify_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","Kan Apu Dios nan Moses ey “Emin hu lalakkin pengulwan ni helag Israel ey mei-eng-eng ni hi-gak. Mahapul ni illista yu ngadan idan hambulan tu niya nehuluk. Nem hedin ya mengi-ehneng ni hi-gadan mei-eng-eng ni hi-gak ey yadda helag Levi. Hi-gak hu Ap-Apu e Dios. Anin idan animal ni helag Levi et meiwwa-hiddan nemangulun impah ni animal idan helag Israel.” ");
INSERT INTO ify_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Inu-unnud Moses et bilangen tuddan emin hu pengulwan ni lalakkin helag Israel meippuun di tugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ya bilang emin ni pengulwan ni lalakkin helag Israel ey 22,273. ");
INSERT INTO ify_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ieng-eng mun hi-gak ida helag Levi et meihullul idan emin ni pengulwan ni lalakkin helag Israel, anin idan animal da et meihhullul idan nemangulun impah ni animal idan helag Israel. Mei-eng-eng ida helag Levi ni hi-gak. Hi-gak hu Ap-Apu e Dios. ");
INSERT INTO ify_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Hedin yadda etan dewanggatut et nepitut tellun pengulwan ni lalakkin helag Israel ni nehuluk di bilang idan helag Levi ey mahapul ni wada wa-hi da. ");
INSERT INTO ify_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ya bayad ni hakey meippuun di kameunnud ni pambeyyad ey liman palatah ni silber. ");
INSERT INTO ify_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Humman ni pihhuh ni bayad da ey meidwat nan Aaron et yadda u-ungnga tu.” ");
INSERT INTO ify_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Inu-unnud mewan Moses et amungen tu bayad idan nunman ni nehuluk di bilang ni neihullulan idan helag Levi ");
INSERT INTO ify_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ey 1,365 ni palatah ni silber, ");
INSERT INTO ify_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","et idwat tun Aaron et yadda lalakkin u-ungnga tu meippuun di Tugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Kan mewan Apu Dios nan Moses et hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ilista yu emin hu helag Kohat meippuun di pewen da niyad pamilyah da. ");
INSERT INTO ify_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Bilang yudda lalakkin dammutun mangngunnud Tabernacle ni telumpulu ingganah di nelima toon tu. ");
INSERT INTO ify_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ya ngunnuen dad Tabernacle ey ippaptek dadda neieng-eng ni ngunut. ");
INSERT INTO ify_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Nem hedin man-e-tan ida helag Israel di pangkampuan da man mahapul ni umhegep ni hi Aaron niyadda u-ungnga tu et da lugpien hu kultinah ni neihenid Kuwaltuh Apu Dios et ihephep dad kaban tu. ");
INSERT INTO ify_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ey ihhephep da mewan hu kayyaggud ni katat niya itta-kep da etan blue ni luput et handa iduduk etan ida pan-attang. ");
INSERT INTO ify_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ya etan tebol ey aplagan dan blue ni luput et handa iha-ad diman ida duyu, yadda mahukung ni duyun pengihha-adan ni kamei-appit, yadda pengihha-adan ni meinnum niyadda sinapay ni meihha-ad diman ni kamei-appit nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Mahapul ni hephepan daddan makadlang ni luput niya itta-kep dan ihhephep hu kayyaggud ni katat ni gelding et handa iduduk hu pan-attang. ");
INSERT INTO ify_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Mahapul mewan ni hephepan dan luput ni blue hu pattukkan ni dilag, yadda kengkeh, yadda ipit, yadda et-eteng ni duyu niyadda ha-addan ni lanan olibah. ");
INSERT INTO ify_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Illibut dadda huyyad kayyaggud ni katat niya ihha-ad dad pan-attangan. ");
INSERT INTO ify_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Hedin ya etan balituk ni altar ey mahapul ni hephepan dan blue ni luput et ita-kep da hu kayyaggud ni katat, et handa iduduk hu pan-attang. ");
INSERT INTO ify_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Illibut da mewan di blue ni luput ida ngunut di Tabernacle niya hephepan dan kayyaggud ni katat et handa iha-ad di pan-attangan. ");
INSERT INTO ify_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Mahapul mewan ni e-kalen da dep-ul di altar niya hephepan dan madlang ni luput. ");
INSERT INTO ify_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ihha-ad dadman ida ngunut ni meussal di altar henin penellukduk ni ngalab, yadda tewik, yadda pala niyadda besin, et hephepan daddan kayyaggud ni katat et handa iduduk hu pan-attang. ");
INSERT INTO ify_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Et humman hu, hedin man-e-tan kayud pangkampuan yu ey mahapul ni gibbuhen Aaron niyadda u-ungnga tun hephepan emin ida humman ni neieng-eng ni ngunut, et han attangaddan helag Kohat. Mahapul ni henin nunya pehding yu tep eleg mabalin ni keppaen dadda humman tep mettey hu kumpulmih ni tuun mengeppa. ");
INSERT INTO ify_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hi Eleasar e u-ungngan Aaron e padi hu ngenamung ni mengippaptek ni Tabernacle et yadda wadadman, henin lanan olibah ni kameihha-ad di kengkeh, yadda bangbanglu, yadda pagey niya lanan olibah ni kamei-appit.” ");
INSERT INTO ify_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Kan mewan Apu Dios nan Moses et hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Heninnuy mewan hu mahapul ni meippahding et eleg ida matey hu helag Kohat anin ni meihnup idad kameussal di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Mekihgep ni hi-gada hi Aaron niyadda lalakkin u-ungnga tud Tabernacle, et itudu dan hi-gada hedin hipa ingngunu da. ");
INSERT INTO ify_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Tep hedin eleg da pehding huyya, man eleg mabalin ni umhehgep ida hu helag Kohat di Tabernacle, tep mettey ida hedin ang-angen da hu usal diman, anin ni nekemtang ni ebuh.” ");
INSERT INTO ify_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Itudek mudda emin hu helag Gerson e u-ungngan Levi meippuun di pewen da niyad pamilyah da. ");
INSERT INTO ify_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bilang mudda emin hu lalakkin dammutun mangngunnud Tabernacle ni telumpulu ingganah di nelima toon tu. ");
INSERT INTO ify_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Hi-gada mengnged idan nunya: ");
INSERT INTO ify_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ya Tabernacle, ya meihhephep ni luput et ya meitta-kep ni kakkayyaggud ni katat, ya kultinah di heggeppan ni Tabernacle, ");
INSERT INTO ify_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","yadda kultinah et ya linubid di dallin ni Tabernacle niyad altar, ya kultinah di heggeppan di dallin niyadda kameussal ni pengitta-yunan idan kultinah. Hi-gada mewan ngenamung ni mengippaptek idan nunya hedin man-e-tan ida helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Hi Aaron niyadda lalakkin u-ungnga tu hu menang-ang idan helag Gerson hedin daka ippahding hu neitudun ngunu da, yadda mahapul ni ippahding da hedin man-e-tan ida niyadda edum ni ngunu da. Ittudu da mewan ni hi-gada hedin hipa tetngeden da. ");
INSERT INTO ify_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Huyyadda neitudun ngunuddan helag Gerson di Tabernacle. Hi Ithamar e u-ungngan Aaron hu ngenamung ni menang-ang ni ngunu da.” ");
INSERT INTO ify_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Immehel mewan hi Apu Dios nan Moses ey kantuy “Ilistam ida emin hu helag Merari meippuun di pewen da niyad pamilyah da, ");
INSERT INTO ify_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","niya bilang mudda emin hu lalakkin dammutun mangngunnud Tabernacle ni telumpulu ingganah di nelima toon tu. ");
INSERT INTO ify_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Hi-gada mengnged ni kalkalimangngan Tabernacle heniddan kameibballabag, ");
INSERT INTO ify_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","yadda tukud, yadda neituunan ni tukud, yadda pa-pa, yadda linubid di nanlinikweh ni Tabernacle niyaddan emin ida kameussal di pengikkapyaan idan nunya. Wada hakey ni hi-gada ey ngenamung tun mengippahding ni neitudun ngunu tu. ");
INSERT INTO ify_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huyyadda neitudun ngunnuen idan helag Merari di Tabernacle. Hi Ithamar e u-ungngan Aaron hu mengituttuddun pehding da.” ");
INSERT INTO ify_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Inu-unnud di Moses nan Aaron niyadda kamengipappangngulun helag Israel hu olden Apu Dios et ilista dan emin hu lalakkin helag Kohat, hi Gerson et hi Merari e u-ungngaddan Levi, meippuun di pewen da niyad pamilyah da. Binilang dan emin hu dammutun mangngunnud Tabernacle ni telumpulu ingganah di nelima toon tu et heninnuy hu bilang ni helag da: hi Kohat ey 2,750, hi Gerson ey 2,630, et hi Merari ey 3,200. Ya nga-mut ni bilang dan emin ey 8,580. ");
INSERT INTO ify_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Meippuun di intugun Apu Dios nan Moses ey neilistaddan emin niya neitudun hanhakkey ni hi-gada ngunnuen da winu hipan pehding da. ");
INSERT INTO ify_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Itugun muddan helag Israel e pe-kal dad nangkampuan da hu tutu-un wada anggetakkut ni degeh dan kamei-aldan, et yadda tutu-un wada kamelpud annel da ni yadda etan eleg meibbillang ni malinih tep kinepa da winu sinikdun da hu annel ni netey. ");
INSERT INTO ify_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Man-ingngeh ni meippahding huyyad laki winu bii et ma-kal idad pangkampuan yu tep eggak pinhed ni meluggit eya bebley ni pekibbebleyan kun hi-gayun tutu-uk.” ");
INSERT INTO ify_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Inu-unnud idan helag Israel hu intugun Apu Dios nan Moses, et pa-kal dad nangkampuan da etan ida tuun kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Itugun muddan helag Israel huyya: ya etan laki winu biin eleg tu u-unnuda hi Apu Dios, et pehding tu lawah di edum tun tuu ey mambehhul. ");
INSERT INTO ify_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Humman ni tuu ey mahapul ni ebbuluten tun nambahul et bayadan tu multa tu etan di tuun nambahulan tu ey e-duman tun dewampulun porsentoh. ");
INSERT INTO ify_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Nem hedin netey etan tuu et endi neihnup ni aaggi tun pengidwatan etan ni nambahul ni bayad tu ey meidwat nan Apu Dios humman, et usalen idan padi. Hin-appil ngu dedan etan lakkitun kalneroh ni ukkaten ni nambahul et kelengen tun pengippahdingan tun elaw ni panlinnih. ");
INSERT INTO ify_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Emin hu illaw idan helag Israel ni iddawat dan Apu Dios ey ellan idan padin menewwat. ");
INSERT INTO ify_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Emin hu hipan meidwat etan ni padi ey ellan tu.” ");
INSERT INTO ify_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Huyyadda intugun Apu Dios nan Moses ");
INSERT INTO ify_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ni ittugun tuddan helag Israel: Hedin ngullaw an nenamak hu hakey ni biin edum ni lakin beken tu ahwa ");
INSERT INTO ify_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","et man-ulig ida, nem endi tistigu et endi nena-kup ni hi-gada, ");
INSERT INTO ify_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ey hedin man-annil etan lakin ahwan nunman ni bii winu man-e-lem hu hakey ni laki e anin ni endi impahding ni ahwa tun lawah, ");
INSERT INTO ify_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ey mahapul ni illaw ni laki hu ahwa tud kad-an ni padi. Niya mahapul ni um-ilaw ni hangkiloh ni alinah ni eleg meha-adan ni mansikan olibah winu bangbanglu tep mei-appit huyyan panmahmahan ni kaman-annil ni laki ma-lat meamta hedin makulug ni nambahul hu ahwa tu. ");
INSERT INTO ify_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Illaw etan ni padi etan bii et tu peehneng di hinanggan altar, ");
INSERT INTO ify_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","niya um-alan danum et iduyag tud bewed niya um-alan dep-ul di det-al ni Tabernacle et i-dum tud danum. ");
INSERT INTO ify_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Hedin negibbuh ni impeang-ang etan ni padi etan bii di hinanggan Apu Dios, ey ukkahen tu betek ni bewek ni nunman ni bii et patnged tun hi-gatu etan neiappit ni alinah et pengamtaan hedin makulug etan kapan-annilin laki. Um-ehneng etan padid hinangga etan ni bii niya tetngeden tu etan bewed ni neha-adan ni mapeit ni danum ni um-idwat ni idut etan di nambahul. ");
INSERT INTO ify_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pansapatah ni padi etan bii ey kantun hi-gatuy “Hedin eleg ka makiulig di edum ni laki niya hedin endi impahding mun lawah ni umhulun ni keibbillangan mun beken ni malinih ey eleg um-amnu eya idut ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Nem hedin nekiulig kad edum ni laki ey ");
INSERT INTO ify_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","hi Apu Dios hu mengiddut ni hi-gam ma-lat pippihulen dakan edum mun tuu. Pambalin dakan mebessi ");
INSERT INTO ify_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","eyan neidutan ni danum ni innumem.” Hummangen etan ni bii et kantuy “Ebbulutek huttan ni pehding Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ittudek etan ni padi huyyan idut di katat, et hantu ulahi etan neitudek etan di mapeit ni danum di bewed. ");
INSERT INTO ify_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Peinnum ni padi etan ni bii humman ni danum ni neidutan et manhelheltap hedin tu-wangun nambahul. ");
INSERT INTO ify_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ellan mewan etan ni padi etan singnged ni biin alinah ni neiappit gapuh ni annil et ita-gey tu et ipeang-ang tun Apu Dios ey hantu ilaw di altar. ");
INSERT INTO ify_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Umgamal etan padin nunman ni alinah et giheben tu, et painum tu mewan etan ni bii etan danum. ");
INSERT INTO ify_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Hedin nekiulig etan biid edum ni laki, man nemahhig hu helheltapen tun iddawat ni danum ni neidutan et mebessi. Pippihulen idallin tutu-u. ");
INSERT INTO ify_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Nem hedin eleg tu ipahding hu lawah, ey mehlag tep eleg um-amnu hu idut ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Huyya hu tugun ni meippanggep ni annil. Hedin nekiulig hu biid edum ni laki ");
INSERT INTO ify_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","winu kaman-annil hu laki e ya wadad nemnem tu ey wada edum ni lakin ahwa tu, ey illaw tu ahwa tu et peehneng ni padid hinanggan Apu Dios et ipahding tu huyyan tugun. ");
INSERT INTO ify_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Endi bahul ni laki, nem hedin nambahul hu bii, man heltapen tu kastigu tu. ");
INSERT INTO ify_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Intugun mewan Apu Dios nan Moses ");
INSERT INTO ify_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","e ittugun tuddan helag Israel huyya: “Hedin wada laki winu biin mansapatah ma-lat mambalin ni Nasirite et i-eng-eng tu annel tun Apu Dios, ");
INSERT INTO ify_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ey mahapul ni eleg um-inum ni kaumbuteng. Eleg um-inum ni hipan meinnum ni nekapyad grapes niya eleg mengngan ni grapes niya raisins. ");
INSERT INTO ify_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Anin ni hipan nekapyad grapes, ya bukel tu winu ukih tu ey eleg mabalin ni tu kennen. ");
INSERT INTO ify_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Eleg mabalin ni an mampepu-lit niya eleg mabalin ni tu e-kalen iming tu. Yan nunman ni tsimpuh ni pambalinan tun Nasirite ey mahapul ni pedukkey tu bewek tu niya iming tu. Mahapul mewan ni pannenneng tun pehding hu insapatah tu ma-lat maibilang ni malinih ingganah melebbah humman ni tsimpuh ni insapatah tun pansilbian tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ey eleg mabalin ni an meihnup di netey ni tuu. ");
INSERT INTO ify_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Anin ni kantu et hi ametu, hi inetu winu yadda aaggi tu hu mettey, et eleg mabalin ni tu hibbiten annel tu gapun hi-gada, tep neieng-eng nan Apu Dios, e ya bewek tu hu keang-angan tu e hi-gatu ey Nasirite. ");
INSERT INTO ify_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Hedin ya hakey ni tuu ey insapatah tun mambalin ni Nasirite et maieng-eng nan Apu Dios ey mahapul ni pehding tu hu neitugun ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Hedin nehibit hu bewek ni hakey ni Nasirite tep neidagsid annel etan ni tuun neminpinhakkey ni netey, ey mahapul ni hehgeden tun pitun aggew et hantu mukmuki ulu tu niya e-kalen tu iming tu et han dammutun meibbillang ni malinih. ");
INSERT INTO ify_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Yan meikkewwalun aggew ey illaw tu etan ni padi hu dewwan paluma winu dewwan balug di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","I-appit ni padi hu hakey tep ya liwat niya gihheben tu hakey di altar ma-lat mambalin mewan ni malinih humman ni tuu tep ya neidagsian tud annel ni netey. Yan nunman ni aggew ey ippidwa tu mewan ni mansapatah nan Apu Dios niya dukkeyen tu mewan bewek tu. ");
INSERT INTO ify_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ippidwa tu mewan ni ieng-eng annel tun Apu Dios et mambalin mewan ni Nasirite. Eleg meibbillang etan tsimpuh ni nunman tep nehibit hu neieng-eng ni bewek tu. Mahapul mewan law ni man-appit ni hantoon tun lakkitun kalneroh gapuh ni bahul tu. ");
INSERT INTO ify_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Hedin negibbuh ni impahding ni Nasirite hu insapatah tun pansilbian tun Apu Dios, man umlaw di heggeppan ni Tabernacle ");
INSERT INTO ify_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","et peang-ang tun i-appit nan Apu Dios hu hakey ni hantoon tun lakkitun kalneroh ni kamei-appit ni kagihheba, ya hakey ni hantoon tun labah ni kalneroh ni kamei-appit tep ya liwat et ya hakey ni lakin kalneroh ni kamei-appit ni pekiddagyuman tun Apu Dios. Huyyaddan animal ey mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Um-iappit mewan ni hambasket ni sinapay ni eleg meha-adan ni pampelbag, yadda mahdel ni sinapay ni nekamdugan ni mansikan olibah, yadda mangkeingpih ni sinapay ni neha-adan ni mansikan olibah, yadda pagey niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Peang-ang etan ni padi ida huyyan kamei-appit Apu Dios e pemengngulu tudda kamei-appit tep ya liwat niya kagihheba, ");
INSERT INTO ify_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","et hantu itu-nud hu kamei-appit gapuh ni pekiddagyuman nan Apu Dios niya hambasket ni sinapay ni eleg mekamdugan ni pampelbag, ya pagey niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Mukmukan etan ni Nasirite hu bewek tud heggeppan ni Tabernacle et giheben tud pengiggihheban ni kamei-appit ni pekiddagyuman nan hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Hedin negibbuh ni nemukmukan hu bewek tu, ey iddawat ni padin hi-gatu hu hanhakkey ni nelutun lapan lakkitun kalneroh, et yadda mahdel niya meingpih ni sinapay ni eleg meha-adan ni pampelbag. ");
INSERT INTO ify_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Itta-gey ni padin peang-ang nan Apu Dios humman idan meidwat ni bingay idan padi et memei-dum di pagew et ya lapan kalneroh. Hedin negibbuh ida huyya ey dammutu law ni um-inum etan Nasirite ni meinnum. ");
INSERT INTO ify_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Huyyadda tugun ni meu-unnud di pan-appitan ni Nasirite. Hedin wada pay hu insapatah tun iddawat tun Apu Dios ni mei-dum di kamei-appit ngu dedan, ey dammutu. Nem mahapul ni pehding tu hu insapatah tu.” ");
INSERT INTO ify_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ehel mud Aaron niyadda u-ungnga tu e heninnuy hu pambendisyon daddan helag Israel: ");
INSERT INTO ify_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Hi Apu Dios hu mambendisyon niya mengippaptek ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hi Apu Dios hu mengippeang-ang ni binabbal tu niya hemek tun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Hi-gatu hu mengidwat ni linggep yu ey peang-ang tu amleng tun hi-gayu.’” ");
INSERT INTO ify_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Kan mewan Apu Dios ey “Hedin ngeddanen idan padi hu ngadan kun pemendisyonan dan helag Israel ey bendisyonak ida.” ");
INSERT INTO ify_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ginibbuh nan Moses ni binehwat hu Tabernacle, et ipahding tu hu elaw ni pengi-eng-engan dan Apu Dios ni nunman, yadda kameussal diman, ya altar niyadda usal diman. ");
INSERT INTO ify_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Yadda etan aap-apun helag Israel ni kamanlistaddan tutu-u ");
INSERT INTO ify_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ey in-ali da hu iddawat dan Apu Dios. Humman ida ey enem ni kaliton et ya hampulut dewwan bulug ni baka. Hakey ni kaliton hu indawat ni dewwan ap-apu, niya hakey ni bulug ni baka hu indawat ni hakey ni ap-apu. Impeang-ang dadda emin huyyad hinanggan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Abulut mudda huyyan indawat da et mausal di hipan ngunu eyad Tabernacle. Idwat muddan helag Levi et usalen dad ngunu da.” ");
INSERT INTO ify_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Et idwat Moses idan helag Levi hu ida humman ni kaliton niyadda bulug ni baka. ");
INSERT INTO ify_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Indawat tu dewwan kaliton et ya epat ni bulug ni baka idan helag Gerson et usalen dad ngunu da, ");
INSERT INTO ify_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","niya indawat tuddan helag Merari hu epat ni kaliton et ya walun bulug ni bakan ussalen da damad ngunu da. Ya ap-apu dan mengituttuddun ngunu da ey hi Ithamar e u-ungngan Aaron. ");
INSERT INTO ify_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Endi an indawat nan Moses ni kaliton idan helag Kohat tep eleg da mahapul di ngunu da, tep hi-gada kamemehhan ni neieng-eng ni ngunut di Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Yan etan ni neieng-engan ni altar hu nengi-lian idan aap-apun nunman idan indawat da et ipeang-ang dan inha-ad dad hinanggan altar. ");
INSERT INTO ify_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kan dedan lan Apu Dios nan Moses ey “Ehel muddan helag Israel e kewa-wa-wan hampulut dewwan aggew ey i-alin hakey ni ap-apu hu iddawat tun meussal ni pengi-eng-engan ni altar.” ");
INSERT INTO ify_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Ey ya nengi-lin iddawat tun nemangulun aggew ey hi Nahson e u-ungngan Amminadab e helag Judah. Yan meikkadwan aggew ey hi Nethanel e u-ungngan Suar. Yan meikkatlun aggew ey hi Eliab e u-ungngan Helon e helag Sebulun. Yan meikka-pat ni aggew ey hi Elisur e u-ungngan Sedeur e helag Reuben. Yan meikkelliman aggew ey hi Selumiel e u-ungngan Surishaddai e helag Simeon. Yan meikka-nem ni aggew ey hi Eliasap e u-ungngan Deuel e helag Gad. Yan meikkeppitun aggew ey hi Elisham e u-ungngan Ammihud e helag Epraim. Yan meikkewwalun aggew ey hi Gamaliel e u-ungngan Pedahsur e helag Manasseh. Yan meikkahyam ni aggew ey hi Abidan e u-ungngan Gideoni e helag Benjamin. Yan meikkeppulun aggew ey hi Ahieser ey u-ungngan Ammishaddai e helag Dan. Yan meikkeppulu et hakey ni aggew ey hi Pagiel e u-ungngan Okran e helag Asher. Yan meikkeppulut dewwan aggew ey hi Ahira e u-ungngan Enan e helag Naptali. Emin ida ey nan-iingngeh indawat da e hanhakkey ni duyun silber ni umlaw di hangkiloh et kagedwah bel-at tu, ya hanhakkey ni mahukung ni silber ni umlaw di hangkiloh bel-at tu meippuun di kameunnud ni lekud da. Napnudda humman ni kayyaggud ni alinah ni nekamdugan ni mansikan olibah, e huyya kamei-appit ni pagey. Indawat da mewan hu hanhakkey ni ek-ekut ni mahukung ni duyun balituk ni umlaw ni 1/8 ni kilo hu bel-at tu e neha-adan ni bangbanglun insensoh, ya hanhakkey ni kilaw ni lakkitun baka, ya hanhakkey ni lakkitun kalneroh, ya hanhakkey ni hantoon tun impah ni kalneroh ni kamei-appit ni kagihheba, ya hanhakkey ni gelding ni kamei-appit tep ya liwat. Yadda indawat dan kamei-appit di pekiddagyuman ey: handedwan bulug ni baka, hanlilman lakkitun kalneroh, hanlilman gelding et ya hanlilman hantoon tun impah ni kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Et ya bilang emin ni indawat idan hampulut dewwan aap-apun helag Israel ni meussal di kei-eng-engan ni altar ey: Hampulut dewwan silber ni duyu et ya hampulut dewwan silber ni mahukung ni duyun umlaw di telumpulun kilo, hampulut dewwan balituk ni ekka-kut ni mahukung ni duyun umlaw ni hangkiloh et kagedwah bel-at tun nangkapnun insensoh, hampulut dewwan lakkitun baka, hampulut dewwan lakkitun kalneroh, hampulut dewwan hantoon tun impah ni kalneroh, ya alinah ni i-appit dan mei-unnud ida nunman ni kagihheba et ya hampulut dewwan gelding ni kamei-appit tep ya liwat. Ya in-ali da pay ni kamei-appit ni pekiddagyuman dan Apu Dios ey dewampulut epat ni lakkitun baka, na-nem ni lakkitun kalneroh, na-nem ni gelding et ya na-nem ni hantoon tun impah ni kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Yan hinggepan nan Moses di Tabernacle et makihummangan nan Apu Dios ey dingngel tu kaman-e-hel di nambattanan ni dewwan nepaot ni nepayakan ni anghel di ta-pew ni hu-keb ni Kaban Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ehel mun Aaron et hedin ippatuk tudda etan pitun dilag di pattukkan ey ang-angen tu et madilagan hu pettek ni hinanggan nunman ni pattukkan.” ");
INSERT INTO ify_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Inu-unnud Aaron et iha-ad tudda dilag etan di dammutun medillagan hu hinanggan etan ni pattukkan. ");
INSERT INTO ify_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Humman ni pattukkan ni dilag ey nekapyad balituk meippalpud hengeg tu ingganah di utduk tu e neu-unnud hu impeang-ang Apu Dios nan Moses ni pengiu-unnudan tu. ");
INSERT INTO ify_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Appil mudda helag Levi idad edum dan helag Israel, et ipahding mu hu elaw ni panlinnih ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Wagkihim idan danum ni kapanlinnih et pelabahah mu bewek di ulu da niyad annel da, ey pebalbal mun hi-gada balwasi da et maibilang idan malinih. ");
INSERT INTO ify_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ehel mu mewan ni hi-gada et umi-liddan pakeetteng tun lakkitun baka, ya alinah ni nekamdugan ni mansikan olibah ni kamei-appit, niya kilaw ni lakkitun bakan kamei-appit tep ya liwat. ");
INSERT INTO ify_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ayagim idan emin hu helag Israel niya peehneng mudda helag Levi di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ey yadda helag Israel ey itta-pew da ngamay dad uluddan helag Levi. ");
INSERT INTO ify_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ipeang-ang Aaron idan hi-gak hu helag Levi et maieng-eng idan hi-gak tep hi-gak pansilbian da. ");
INSERT INTO ify_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Itta-pew idan helag Levi hu ngamay dad ulun etan ni dewwan lakkitun baka. Mei-appit hu hakey tep ya liwat niya gihheben da etan hakey. Huyya hu elaw ni panlinnih idan helag Levi. ");
INSERT INTO ify_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Peehneng muddad hinanggan Aaron niyadda u-ungnga tu et maieng-eng idan hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hanneya pehding mun mengi-eng-eng idan helag Levi, tep hi-gada pinilik di edum dan helag Israel ni mengippahding ni pengunnuk. ");
INSERT INTO ify_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Hedin negibbuh ni impahding mu humman ni elaw ni panlinnih ni hi-gada ey ipeang-ang mudda et dammutu law ni umhehgep idad Tabernacle et ipahding da hu pengunnuk ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Neieng-eng ida helag Levi ni hi-gak, tep hi-gada neihullul di emin ni pengulwan ni lakin u-ungngaddan helag Israel, ");
INSERT INTO ify_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","tep mei-eng-eng dedan ni hi-gak hu emin ni pengulwan ni lakin u-ungngaddan helag Israel, anin idan nemangulun impah ni animal da. Pinilik ida dedan ni mei-eng-eng ni hi-gak nunman ni hileng ni nemateyak emin ni pengulwan ni lakin u-ungngaddan iEgypt. ");
INSERT INTO ify_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Et humman hu, yadda helag Levi hu ihullul kuddan pengulwan ni lakin u-ungngaddan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Hi-gada mewan hu pinilik ni emin di helag Israel ni mengippahding idan ittudun Aaron niyadda u-ungnga tun ingngunu dad Tabernacle ma-lat iehneng dadda edum dan helag Israel. Pehding da hu elaw ni panlinnih ni hi-gada et endi an meippahding ni lawah ni hi-gada hedin meihnup idad Tabernacle.” ");
INSERT INTO ify_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Inu-unnud Moses, hi Aaron niyadda helag Israel hu intugun Apu Dios ni pehding daddan helag Levi. ");
INSERT INTO ify_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Impahding idan helag Levi hu elaw ni panlinnih niya imbalbal da balwasi da et peang-ang Aaron idan Apu Dios ey impahding tu hu elaw ni panlinnih ni hi-gada ma-lat maibilang idan malinih. ");
INSERT INTO ify_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Neipalpun nunman ey ida law kaumhegep hu helag Levi ni mangngunnud Tabernacle, et baddangan da hi Aaron niyadda u-ungnga tun laki. Inu-unnud dan emin hu intugun Apu Dios nan Moses ni pehding da. ");
INSERT INTO ify_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mahapul mewan ni u-unnuden idan helag Levi huyya: Hedin dewampulut liman toon ida laki ey illapu dan mangngunnud Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Issiked dan mangngunnud man hedin nelima law toon da. ");
INSERT INTO ify_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hedin dinteng da humman ni toon ey umbaddang idan ebuh di edum dan helag Levi ni mangguwalyad Tabernacle, nem beken law ni hi-gada mengippahding ida etan ni ngunudman. Humman ida ittudum ni ngunuddan helag Levi.” ");
INSERT INTO ify_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yan eman ni nemangulun bulan ni meikkadwan toon neipalpun neni-yanan idan helag Israel ni Egypt ey immehel hi Apu Dios nan Moses di Sinai ");
INSERT INTO ify_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","et kantuy “Ehel muddan helag Israel et ipahding da hu Piyestah ni Passover e Nelabahan ni Anghel etan di nagtud ni tsimpuh. ");
INSERT INTO ify_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Pehding yu huyya meippalpun kamangkehilleng ni meikkahampulut epat ni aggew nunman ni bulan. Mahapul ni paka-u-unnuden yudda intugun kun pehding yu meippanggep nunyan Piyestah.” ");
INSERT INTO ify_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Inhel Moses idan tutu-u e ippahding da humman ni Piyestah ");
INSERT INTO ify_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ni mahmahdem ni meikkahampulut epat ni aggew ni memengngulun bulan di diman Sinai, et ipahding idan tutu-u humman e inu-unnud da hu intugun Apu Dios nan Moses. ");
INSERT INTO ify_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nem wadadda eleg mangipahding ni nunman ni Piyestah tep kinepa da annel ni netey et maibilang idan beken ni malinih, et lumaw idan Moses nan Aaron nunman ni aggew ");
INSERT INTO ify_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","et kandan Moses ey “Eleg kami meibillang ni malinih tep kinepa mi netey ni tuu. Nem anin et anhan, kele dakemi ikka-leg ni man-appit nan Apu Dios ni nunyan nagtud ni tsimpuh ey ma-nudda edum min helag Israel tep nan-appit ida?” ");
INSERT INTO ify_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Kan Moses ni hi-gaday “Heged yu et amtaek hedin hipa e-helen Apu Dios ni meippanggep ni hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ehel muddan helag Israel e hedin wadan hi-gadan nunya winu yan edum ni aggew hu meibbillang ni beken ni malinih ni tsimpuh ni Piyestah ni Passover tep kinepa tu netey winu wada linawwan da et endiddan nunman ni nagtud ni tsimpuh ey dammutun pehding da humman ni Piyestah ");
INSERT INTO ify_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ni mahmahdem ni meikkahampulut epat ni aggew ni meihhayned ni bulan. Yan nunman ni tsimpuh pengngannan dan pakeetteng tun kalneroh et ya mapeit ni ihhidan natnateng et ya sinapay ni eleg mekamdugan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Mahapul ni kennen dan emin et endi an metdaan ni kewa-waan tu. Mahapul mewan ni endi hehpungen dan genit ni animal ni neiappit. Mahapul ni u-unnuden dan emin hu meunnud hedin pehding da humman ni Piyestah. ");
INSERT INTO ify_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nem ya tuun eleg mengippahding nunya anin kameibbilang ni malinih winu anin ni endi linawwan tu ey eleg law meibbillang ni tuuk tep eleg tuwak iappitan ni nunman ni nagtud tsimpuh. Et heltapen tu kastigu tu tep ya humman ni liwat tu. ");
INSERT INTO ify_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ya edum ni tuun nekibebley ni hi-gayun neminhed ni mengippahding ni nunyan Piyestah ey dammutun pehding tu nem mahapul ni paka-u-unnuden tu hu meunnud ni pehding. Anin ni hansinu-wan humman ni tuu winu helag dedan Israel et mahapul ni u-unnuden tu hu meunnud ni pehding.” ");
INSERT INTO ify_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Yan eman ni neiha-adan etan ni Tabernacle ey nelehbeng hu kulput et hephepan tun kawwalwal. Hedin hileng man kamambalin ni apuy humman ni kulput. ");
INSERT INTO ify_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hanniman kameippahding e hedin kawwalwal ey kamelehbeng humman ni kulput ey hedin hileng ey kamambalin ni apuy. ");
INSERT INTO ify_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","18","Hedin immahpat etan kulput, ey amtaddan helag Israel e pinhed Apu Dios ni man-e-tan ida. Et humman hu, bukkalen da kampu da ma-lat man-etan ida. Ey ihha-ad da mewan hedin nansiked niya melehbeng etan kulput. Nem hedin mannenneng etan kulput di Tabernacle, ey amta da e pinhed Apu Dios ni mannenneng idadman ni nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Anin ni meeyyapaw hu panha-adan ni kulput di Tabernacle et manhahha-ad idadman e eleg ida man-e-tan ni pangkampuwan da et u-unnuden da pinhed Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Hin-addum ni kamebillang ni ebuh hu aggew ni kapanhahha-adin kulput etan di Tabernacle. Et humman ni ebuh ni aggew hu panha-adan idan tuud nangkampuan da. Nem hedin in-olden Apu Dios ni man-e-tan ida ey daka u-unnuda. ");
INSERT INTO ify_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Hin-addum mewan ni hakey ni hileng ni ebuh hu panha-adan ni kulput di Tabernacle et ida kaman-e-tan ni kewa-waan tu hedin immahpat etan kulput. Nem anin ni kawwalwal winu hileng et hanniman daka pehding e hedin immahpat etan kulput man mahapul ni man-e-tan ida. ");
INSERT INTO ify_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Nem eleg ida man-e-tan anin ni dewwan aggew, hambulan, hantoon winu mea-ayyapaw pay hedin eleg um-ahpat etan kulput. Nem hedin nisin immahpat etan kulput man bukkalen da kampuda ma-lat man-etan ida. ");
INSERT INTO ify_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ya daka pengu-unnudin Apu Dios hu daka pemukkalin kampu da niya daka pengikkapyai hedin humman inhel Apu Dios nan Moses ni pehding da. ");
INSERT INTO ify_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kapya kan dewwan silber ni tangguyup et mausal ni pan-eyyag idan tuu ma-lat maemung ida ey humman pay pengippeamtaan hedin mahapul ni bukkalen da kampu da. ");
INSERT INTO ify_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Hedin meippatnul ni dewwa etan ida tangguyup, humman pengamtaan idan tuu e mahapul ni meemmung idad kad-am mud heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Nem hedin hakey ni ebuh hu meippatnul, ey ebuh ida etan kamengipappangnguluddan tuu hu meemmung di kad-am. ");
INSERT INTO ify_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ey hedin kamamputuputul hu tenul etan ni tangguyup ey bukkalen idan nangkampud appit ni kasimmilin aggew hu kampu da et man-etan ida. ");
INSERT INTO ify_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Yan pidwatun pengippatnulan dan tangguyup ni mamputuputul ey bukkalen damaddan nangkampud appit ni south hu kampu da et maitu-nud ida. ");
INSERT INTO ify_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Nem hedin eyyagan yudda tuu ma-lat maemung ida, ey dukkedukkey yu hu tenul ni tangguyup. ");
INSERT INTO ify_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Yadda padin u-ungngan Aaron ni ebuh hu dammutun mengippatnul ni tangguyup. Ey mahapul ni u-unnuden idan meittu-nud ni helag dadda huyya. ");
INSERT INTO ify_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ey mahapul ni petnul yudda huyyan tangguyup et peamta yu e wada gubat hedin wada buhul yun menggep ni bebley yu et mekigubat kayun pengihwang yun annel yu. Baddangan dakeyun hi-gak e Ap-Apu e Dios yu ma-lat meihwang kayud buhul yu. ");
INSERT INTO ify_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Patnul yu mewan tangguyup yun tsimpuh ni pan-an-anlaan yu henin Piyestah ni Kaketellakin Bulan winu yadda edum ni piyestah. Ey patnul yu mewan tangguyup yud pan-appitan yun kagihheba niya pekiddagyuman yun Apu Dios. Humman ni tenul ni tangguyup hu mengippenemnem ni hi-gayun nan Apu Dios. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Yan eman ni meikkadwampulun aggew ni meikkadwam bulan ni meikkadwan toon neipalpun neni-yanan idan helag Israel ni Egypt ey himma-pat hu kulput ni wadad Tabernacle, ");
INSERT INTO ify_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","et umgah ida helag Israel et hi-yanen da hu eleg mebebleyid Sinai et manglaw ida ingganah nansiked etan kulput di Paran e eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nedatngan hu pan-e-tanan da mewan et iolden Apu Dios nan Moses e umlaw ida. ");
INSERT INTO ify_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yan inggahan da ey nantutu-nud ida e nemanguludda helag Judah niyadda edum ni helag ni nekikampun hi-gada. Impanguluddan Nahson e u-ungngan Amminadab. ");
INSERT INTO ify_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Neitu-nud ida helag Issakar e hi Nethanel e u-ungngan Suar hu nengipengulun hi-gada ");
INSERT INTO ify_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","et han maitu-nud hu helag Sebulun e impanguluddan Eliab e u-ungngan Helon. ");
INSERT INTO ify_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Et han law maitu-nud ida helag Gerson niyadda helag Merari e nangnged etan ni binukal dan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Neitu-nud ida helag Reuben et yadda edum da e impangulun Elisur e u-ungngan Sedeur. ");
INSERT INTO ify_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Neitu-nud ida helag Simeon e impangulun Selumiel e u-ungngan Surishaddai. ");
INSERT INTO ify_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Et maitu-nud ida helag Gad e impangulun Eliasap e u-ungngan Deuel. ");
INSERT INTO ify_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Neitu-nud ida helag Kohat e helag Levi e hi-gada nangnged idan neieng-eng ni usal di Tabernacle. Yan dintengan da etan di pangkampuan da ey neiha-ad law etan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Neitu-nud damadda helag Epraim e impanguluddan Elishamah e u-ungngan Ammihud. ");
INSERT INTO ify_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Neitu-nud ni hi-gada hu helag Manasseh e impanguluddan Gamaliel e u-ungngan Pedahsur. ");
INSERT INTO ify_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Neitu-nud ida dama helag Benjamin e impanguluddan Abidan e u-ungngan Gideoni. ");
INSERT INTO ify_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ya nanggillig ni tellun helag Israel ey yadda helag Dan, yadda helag Asher niyadda helag Naptali e humman ida ey guwalyad benneggan. Ya nengipengulun hi-gada ey yadda helag Dan e impanguluddan Ahieser e u-ungngan Ammishaddai. ");
INSERT INTO ify_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Neitu-nud hu helag Asher e impanguluddan Pagiel e u-ungngan Okran, ");
INSERT INTO ify_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","et yadda law hu helag Naptali e impanguluddan Ahira e u-ungngan Enan. ");
INSERT INTO ify_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hanneya hu elaw ni negenedwaan idan helag Israel niya nantutu-nudan dad lawwan dan da pan-e-tanan. ");
INSERT INTO ify_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Hakey ni aggew ey kan Moses nan hi aydu tu e hi Hobab e u-ungngan Jetro e iMidian ey “Umlaw kamid bebley ni inhel Apu Dios ni iddawat tun hi-gamin helag Israel. Pakilaw kan hi-gami et idwatan dakan panyaggudam tep inhel Apu Dios e iddawat tu panyaggudan min tuu tu.” ");
INSERT INTO ify_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Nem kan Hobab ey “Eleggak mekillaw ni hi-gayu. Mahapul ni mambangngaddak di pamilyah kud bebley mi.” ");
INSERT INTO ify_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kan mewan Moses ni hi-gatuy “Entan anhan dakemi hi-yan. Pakilaw ka kumaddan ni hi-gami, tep hi-gam hu nengamta hedin attu pangkampuan tayu eyad eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Iddawtan dakaddan dakel ni panyaggudan ni iddawat Apu Dios ni hi-gatsu.” ");
INSERT INTO ify_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Yan neni-yanan idan helag Israel di Sinai ey nandalan idan tellun aggew. Nemangulu hu Kaban Apu Dios tep hedin attu nansikedan tu ey yadman pangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Hedin kawwalwal et ida kamenglaw ey kamei-unnuunnud ni hi-gada etan kulput. ");
INSERT INTO ify_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Hedin mewan immegah ida et umlaw ida e in-attang da etan Kaban Apu Dios ey kan Moses ey “Apu Dios, inah ka et mudda pan-iwehit hu buhul mu. Pabsik mudda tuun anggebe-hel daka!” ");
INSERT INTO ify_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Hedin dimmateng idad pangkampuan da et inha-ad da Kaban Apu Dios, kan Moses ey “Kaibangngad ka e Apu Dios di kad-an min kalibulibun helag Israel.” ");
INSERT INTO ify_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Entanni ey inlapuddan helag Israel ni manlillih nan Apu Dios tep yadda ligat da. Dingngel Apu Dios hu ngudu da ey bimmunget et paeli tu apuy et malgab hu pangil ni nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nampehemmehemmek idan nampebaddang nan Moses et mandasal nan Apu Dios et ma-dep hu apuy. ");
INSERT INTO ify_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nginedanan dan Taberah humman ni nangkampuan da e ya keibbellinan tu ey ‘Kamantetebbel ni bebley’ tep immali apuy Apu Dios di kad-an da. ");
INSERT INTO ify_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Entanni ey kaheppuladdan beken ni helag Israel ni nekilaw ni hi-gada hu kayyaggud ni kennen ni wadad Egypt, henin detag. Anin idan helag Israel et ida dama kamanlillih e kanday “Hamban wada detag ni ihhida tayu ey. ");
INSERT INTO ify_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Yan kaweda tayud Egypt ey hedin pinhed tayu deleg man wada, liblih pay. Dakel pay diman bihhu-ut, yadda melon, niyadda dakel ni klasih ni danggu niya tapal! ");
INSERT INTO ify_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nem yan nunya ey nehingla itsu law ni peteg ni manah tep ebuh humman tayu kakennakennan kewa-wa-wa!” ");
INSERT INTO ify_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ya manah ey heni ekka-ket ni bukel e beken ni makablah ang-ang tu. ");
INSERT INTO ify_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Ida kame-gah ni hileng di kad-an ni nangkampuan idan helag Israel, et hedin newa-wa man inemung da. Daka beyyua et mamblin ni heni alinah ey handa kinapyan nedampillag ni sinapay. Hedin ya tamtam tu man heni sinapay ni nekamdugan ni mansikan olibah. ");
INSERT INTO ify_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Kadeddengngelan Moses e ida kamanpanlillih etan tuun neamung di heggeppan ni kampu ey kamemunnumunnu nemnem tu tep bimmubbunget hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Et kantun Apu Dios ey “Kele hanneya muka pehding ni hi-gak e bega-en mu e muwak kapanliligat? Hipa nak impahding ni muka bellawa et hi-gak mu nengidinelan ida eyan dakel ni tuun hanneya elaw da? ");
INSERT INTO ify_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Beken ni hi-gak hu namyuh ni hi-gada niya beken ni hi-gak hu ammed da! Ey kele nak nambalin ni heni kaman-e-ban hi-gada et nak ida illaw di bebley ni inhel mun iddawat muddan aammed mi? ");
INSERT INTO ify_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Attu nak pengellaan ni dakel ni detag ni pehiddak idan nunyan dakel ni tuu? Anin anhan et ida kaumlilililih e ida kaumbagabagan detag. ");
INSERT INTO ify_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Eggak kabaelin hakkeyan ni mengippaptek ni hi-gada. Nakka meliggasin peteg! ");
INSERT INTO ify_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Hedin hanneya pehding mun hi-gak man kedukdul hu patey muwak ew katteg et eggak helheltapen hu hanneya. Nem hedin daka kapeamleng man entan tuwak anhan panliligat.” ");
INSERT INTO ify_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Entanni ey kan Apu Dios nan Moses ey “Ayagim ida nepitun kamengipappangngulun helag Israel et maemung idad Tabernacle di kad-an mu. ");
INSERT INTO ify_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Um-ali-ak et umhellak ni hi-gam diman, ey weddaek alin hi-gada hu Ispirituh ni henin winedak ni hi-gam ma-lat baddangan dakan hi-gadan mengippaptek idan etan ni tuu et eleg mu hakkeyan. ");
INSERT INTO ify_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ehel mun hi-gada e mahapul ni pehding da hu elaw ni panlinnih tep hi-gak e Ap-Apu ey dingngel ku lilih da e kanday ‘Hamban wada detag ni ihhida tayu ey’ niya kanday ‘Kedukdul hu biyag tayud Egypt’. Et humman hu, weddaek hu detag ni kabbuhhan ey mahapul ni kennen da. ");
INSERT INTO ify_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Beken ni han-aggew ni ebuh winu dewwan aggew, winu lima, winu hampulu, winu dewampulun aggew, tep mahapul ni ");
INSERT INTO ify_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","kennen dan kewa-wa-wan hambulan ingganah makahhingladda et henidda um-uta. Hanneya meippahding tep inwalleng da-ak et kanday ‘Kele dedan tayu hini-yan hu Egypt?’” ");
INSERT INTO ify_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Nem kan Moses nan Apu Dios ey “Ya bilang ida eyan impanguluk ni tuun dammutun mansindalu ey enem ni gatut ni libu, ey kele kammuy iddawtan idan emin ni detag ni kennen dan hambulan? ");
INSERT INTO ify_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Anin na-mun keklengen min emin animal mi et umkulang ni kennen da. Ey anin na-mun hellepen min emin hu deleg di baybay et umkulang ni pekkan ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Et kan Apu Dios nan Moses ey “Kaw wada pappeg ni kabaelan ku? Yan nunya penang-angam hedin um-amnu eya inhel ku!” ");
INSERT INTO ify_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Limmaw hi Moses et tu ehelen ni hi-gada hu inhel Apu Dios, et ayagan tudda nepitun kamengipappangngulun hi-gada, et peehneng tuddad nanlinikweh ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Entanni ey immali hi Apu Dios etan di kulput et umhel nan Moses. Wineda tudda etan ni nepitun tuun nepili hu Ispirituh ni henin wineda tun Moses. Yan newadaan ni Ispirituh ni hi-gada ey nambalin idan prophet ni nekemtang, nem yan nunman ni ebuh. ");
INSERT INTO ify_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Yadda etan dewwa e hi Eldad nan Medad e nekilistaddad nepitun tuu ey wadaddad kampu da tep eleg ida lumaw di Tabernacle ni nunman ni tsimpuh, nem anin ni hi-gada et nan-abig idan newadaan ni Ispirituh ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Et wada hu kamenikken ni lakin nambesik et tu ehelen nan Moses e immen di Eldad nan Medad di kampu da e ida kaman-ebbig. ");
INSERT INTO ify_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Immehel hi Joshua e u-ungngan Nun e hi-gatu kamemabbaddang nan Moses neipalpun keu-ungnga tu ey kantun Moses ey “Mu pasiked ida, apu!” ");
INSERT INTO ify_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Nem kan Moses ey “Entan tuwak ikakkaguh. Kaw beken mewan ni kayyaggud hedin weddaen Apu Dios di emin ni tuu tu hu Ispirituh tu et mambalin idan emin ni prophet?” ");
INSERT INTO ify_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Negibbuh huyya et mambangngad di Moses niyadda etan nepitun kamengipappangngulud kakampu da. ");
INSERT INTO ify_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Entanni ey impaelin Apu Dios hu dibdib ni nengi-lin dakel ni peteg ni sisit ni nalpud baybay et umpaddad puyek ey neipu-ul ida et tellun piyeh keta-gey da ey nenap-apan hu mahkang etan di nangkampuan idan helag Israel e henin kedawwin kadellanan han-aggew. ");
INSERT INTO ify_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Et itattaggan idan tutu-u hu ala e in-a-aggew da et ilallabbi da, et mewa-wa mewan et ia-aggew da ala. Ya inlan hakey ni hi-gada ey umlaw di neliman bushel et da pan-iha-pey di nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nem entannit daka pankennadda humman ni sisit, ey impaelin Apu Dios hu nemahhig ni degeh tep bimmubbunget ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Dakel ni hi-gada netey et mukun nginedanan da humman ni nangkampuan dan ‘Kibrot Hataabah.’ Ya keibbellinan tu ey ‘Kulung idan nadmut ni detag’ tep ingkulung daddadman hu tutu-un kamanlillih meippanggep ni kennen ni kaiddawadawat Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Entanni ey hini-yan idan helag Israel humman et lumaw idad Haserot et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Yan kaweda dad Haserot ey pinihul di Miriam nan hi Aaron hi Moses tep inahwa tu hu biin Kushite. ");
INSERT INTO ify_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kanda pay ey “Kaw hi Moses ni ebuh hu inhelan Apu Dios? Kaw eleg dama umhel ni hi-gata?” Humman ni inhel da ey dingngel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Yad emin ni tuud puyek ey endi henin Moses e kamampekumbabah.) ");
INSERT INTO ify_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Pinhakkeyey ineyagan Apu Dios hi Moses, hi Aaron et hi Miriam et kantun hi-gaday “Lakkayuy ni tellud Tabernacle!” Et lumaw idan tellu. ");
INSERT INTO ify_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Entanni ey nelehbeng hi Apu Dios di kulput e heni tukud di heggeppan ni Tabernacle et aygan tud Aaron nan Miriam. Inu-unnud da et lumaw idan dewwad kad-an tu. ");
INSERT INTO ify_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kan Apu Dios ni hi-gaday “Dengel yu eya e-helek! Hedin wada pinhed kun e-helen idan prophet ey peamtak ni hi-gadad i-innep da. ");
INSERT INTO ify_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nem hedin hi Moses e bega-en ku ey beken ni hanniman, tep indinel kun emin ni hi-gatu hu helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Humman gaputun nakka mekihhinnanggan mekihhummangan ni hi-gatu niya nakka panna-ud hu pinhed kun e-helen ni hi-gatu, et heni da-ak inang-ang. Kele eleg kayu umtakut ni memihhul ni hi-gatu?” ");
INSERT INTO ify_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nemahhig bunget Apu Dios ni hi-gada et hi-yanen tudda. ");
INSERT INTO ify_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kamangkeitta-gey etan kulput di ta-pew ni Tabernacle ey endi maptek ey newada hu leprosih nan Miriam e nambalin ni pukaw hu belat tu. Inang-ang Aaron humman ni neipahding, ");
INSERT INTO ify_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ey kantun Moses ey “Apu, entan dakemi anhan kastigu tep ya nambahulan min eleg mi pakannemnemen et ipahding mi. ");
INSERT INTO ify_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ang-ang mu anhan et eleg mambalin hi Miriam ni heni neiungngan gelang ni netey e kamangkebwel ngu dedan ni neukatan tu.” ");
INSERT INTO ify_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Et mandasal hi Moses nan Apu Dios e kantuy “Peyaggud mu anhan e Apu Dios hi Miriam!” ");
INSERT INTO ify_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Hinumang Apu Dios ey kantun Moses ey “Gullat ni linupdaan ametu angah tu, et mahapul ni issipel tu baing tun pitun aggew. Et humman hu, idawwi yu nid kampu yun pitun aggew, et hedin negibbuh ey han dammutun mambangngad di kampu.” ");
INSERT INTO ify_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Indawwi da hi Miriam di nangkampuan dan pitun aggew et eleg ida man-etan ingganah nambangngad hi Miriam di kampu da. ");
INSERT INTO ify_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hini-yan da hu Haserot et lumaw idad Paran e eleg mebebleyi et mangkampudda mewan diman. ");
INSERT INTO ify_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Pili kan hanhakkey di hampulut dewwan helag Israel et palaw muddan an mansi-im di Kanaan e bebley ni iddawat kun hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Et u-unnuden Moses humman inhel Apu Dios. Intu-dak tudda hampulut dewwan lalakkin kamengipappangnguluddan helag Israel et umgah idadman Paran e nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Huyyadda ngadan da: hi Sammua e u-ungngan Sakkur di helag Reuben, ");
INSERT INTO ify_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","hi Saphat e u-ungngan Hori di helag Simeon, ");
INSERT INTO ify_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","hi Kaleb e u-ungngan Jephunneh di helag Judah, ");
INSERT INTO ify_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","hi Igal e u-ungngan Joseph di helag Issakar, ");
INSERT INTO ify_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","hi Hosea e u-ungngan Nun di helag Epraim, ");
INSERT INTO ify_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","hi Palti e u-ungngan Raphu di helag Benjamin, ");
INSERT INTO ify_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","hi Gaddiel e u-ungngan Sodi di helag Sebulun, ");
INSERT INTO ify_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","hi Ammiel e u-ungngan Gemalli di helag Dan, ");
INSERT INTO ify_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","hi Gaddi e u-ungngan Susi di helag Manasseh e u-ungngan Joseph, ");
INSERT INTO ify_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","hi Sethur e u-ungngan Michael di helag Asher, ");
INSERT INTO ify_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","hi Nahbi e u-ungngan Bopsi di helag Naptali, ");
INSERT INTO ify_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","et hi Geuel e u-ungngan Maki di helag Gad. ");
INSERT INTO ify_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Huyyadda intu-dak Moses ni an mansi-im ni bebley ni lawwan da. Yan nunyan tsimpuh hu nenullulan nan Moses ni ngadan Hosea e u-ungngan Nun ni Joshua. ");
INSERT INTO ify_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Yan nengitu-dakan Moses ni hi-gada ey kantuy “Elaw kayud appit ni north e idlan yud Negeb ingganah di appit ni south ni Kanaan ey nedagah kayud etan di duntuduntug ni bebley. ");
INSERT INTO ify_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Hedin dimmateng kayudman ey ang-ang yu hedin hipa elaw tu humman ni bebley niyadda bimmebley, hedin dakel ida winu hahhakkey ida winu hedin nangka-let ida winu eleg. ");
INSERT INTO ify_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","20","Ey ang-ang yu hedin kayyaggud humman ni bebley winu lawah. Ang-ang yu hedin neluhud winu eleg. Niya ang-ang yu hedin mateba neitnem winu eleg, niya hedin dakel keyew. Ey yallin pambangngadan yu, ey ienamut kayun lameh ni neitnem diman.” (Yan nunman ni tsimpuh ey nelapuan ni melu-um hu grapes.) ");
INSERT INTO ify_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Limmaw ida humman ni lalakki et ilepu dan man-ang-ang-ang di eleg mebebleyid Sin di Kanaan ingganah di Rehab e neihnup di Hamat. ");
INSERT INTO ify_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nampalaw ida nid appit ni north et mandalan idad Negeb et han-ida lumaw di Hebron e nambebleyan di Ahiman, hi Sehai et hi Talmai e helag idan etta-teng ni tutu-un kameingngadnin Anakim. (Ya Hebron hu nemangulun nekapyan bebley ni pitun toon et han hu Soan e bebley di Egypt.) ");
INSERT INTO ify_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Yan linawwan dad Nedeklan e Eskol ey immaladdan hambu-ngul ni grapes. Makabbel-at et pakkadek ni in-attang ni dewwan tuu. Immaladda pay ni lameh ni pomegranate niya lameh ni fig et ienamut da. ");
INSERT INTO ify_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Nginedanan idan nunman ni helag Israel humman ni Nedeklan e Eskol e ya keibbellinan tu ey ‘nebu-ngul’ tep yadman nengal-an dan nebu-ngul ni grapes. ");
INSERT INTO ify_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Nelabah hu na-pat ni aggew ni nansiiman da et mambangngad ");
INSERT INTO ify_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","idad Kades di Paran e kad-an di Moses nan Aaron niyadda edum dan helag Israel. Ine-ehhel da hu inenang-ang da et peang-ang da etan lameh idan neitnem ni in-anemut da. ");
INSERT INTO ify_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kandan Moses ey “Limmaw kamid bebley ni nengitu-dakam ni hi-gami ey inang-ang mi e kayyaggud niya makatmel ey mateba nangkeitnem diman. Dakel putsukan, ey adyah hu in-anemut min lameh idan neitnem ni inla midman. ");
INSERT INTO ify_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nem yadda tutu-un nambebley diman ey nangka-let ida. Mahkang hu bebley da niya nehammad ni neluhud. Ey anggetakkut tep wada etta-teng ni tutu-udman e nahlag idan Anak. ");
INSERT INTO ify_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Hedin yadda iAmalek ey nambebley idad Negeb. Yadda Hittite, yadda Jebusite niyadda Amorite ey nambebley idad duntuduntug diman. Yadda iKanaan ey nambebley idad gilig ni baybay niyaddad gilig ni Wangwang e Jordan.” ");
INSERT INTO ify_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kamanlillih ida helag Israel nan Moses nem impaineng Kaleb et kantuy “Itsuy kuma et tayudda gubaten et hi-gatsu mambebley diman tep nanna-ud ni apputen tayudda.” ");
INSERT INTO ify_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nem kan ida etan ni edum tun an nansiim ey “Eleg tayudda mannuman han-apput tep ka-ang-ang e et-eteng kabaelan da nem hi-gatsu.” ");
INSERT INTO ify_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Inhinap dad edum dan helag Israel hu beken ni makulug ni meippanggep etan ni bebley. Kanday “Lawah hu puyek diman tep kulang hu kaillameh idan neitnem ni kennen ni emin ni nambebley diman niya etta-teng idan tutu-u hu nambebley diman. ");
INSERT INTO ify_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Immen ida pay diman hu helag Anak et hedin ya mika penang-ang ni annel mi ey heni kami taggunnay ey nanna-ud ni hanniman hu penang-ang dan hi-gami.” ");
INSERT INTO ify_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Yan nunman ni hileng ey nemahhig hu nangih idan helag Israel tep ya inamta da ey endi law namnamah da, ");
INSERT INTO ify_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","et manlilih idan Moses nan Aaron e kanday “Heballi netey kamid Egypt winu ya eyad desert! ");
INSERT INTO ify_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kele daitsu in-alin Apu Dios eyad bebley et itsu matey di gubat ma-lat alen da ahwa tayu niyadda u-ungnga tayu et pambalin daddan himbut? Kedukdul ew katteg hu mambangngad itsud Egypt!” ");
INSERT INTO ify_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Entanni tu-wangu ey wada hakkeyey kanday “Pili itsun mengippengngulun hi-gatsu et mambangngad itsud Egypt.” ");
INSERT INTO ify_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Neamtaan di Moses nan Aaron et manyuung idad hinanggaddan nunman ni tutu-u. ");
INSERT INTO ify_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Hedin hi Joshua e u-ungngan Nun et hi Kaleb e u-ungngan Jephunneh e nekilaw ni an nansiim ey nemahhig lemyung da et bi-kien da balwasi da. ");
INSERT INTO ify_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Kandaddan tutu-uy “Kakkayyaggud kaya etan bebley ni mi inang-ang. ");
INSERT INTO ify_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Hedin peamleng tayu hi Apu Dios man illaw daitsun melinggep di bebley ni iddawat tun hi-gatsu e matmel niya mateba kameitnem ey dakel hu putsukan. ");
INSERT INTO ify_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Entan kuma an pangngehay nan Apu Dios. Entan takut yuddan tutu-udman tep nanna-ud ni apputen tayudda. Hedin hi-gada man endi mengihwang ni hi-gada, nem hedin hi-gatsu man wada hi Apu Dios ni memaddang, et humman hu entan takut yu.” ");
INSERT INTO ify_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Entanni ey nanhuhummangan idan emin etan tuu e da tengbaen di Joshua nan Kaleb, nem endi maptek ey nampeang-ang hi Apu Dios ni hi-gadan emin e kaumhili heyaw tud Tabernacle ni daka pandeyyawi. ");
INSERT INTO ify_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ey immehel hi Apu Dios nan Moses e kantuy “Kele anhan ingganah nunyay da-ak kangengngehayadda eyan tutu-u? Kaw eleg da-ak ni hekey kulluga, anin ni dakel impenahding kun miracle ni inenang-ang da? ");
INSERT INTO ify_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Peellik hu degeh et meendidda huyyan tutu-u et hi-gam hu iddawtan kun dakel ni helag niya iddawtan dakan e-etteng ni kabaelan da nem yadda huyyan tutu-u!” ");
INSERT INTO ify_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Nem nampehemmehemmek hi Moses nan Apu Dios et kantuy “Apu Dios, inamtaddan iEgypt e impa-kal mudda huyyan tuudman ni bebley da tep ya et-eteng ni kabaelam. Ey hedin ippahding mu humman et dedngelen da, ey hi-gada mengippeamtaddan ");
INSERT INTO ify_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","nampambebley di deyan nuntan ni mu pehding. Dingngel da e hi-gam e Apu Dios ey nampeang-ang kan hi-gami niya wada ka etan di kulput ni kamei-unnuunnud ni hi-gamin kawwalwal et ipengulu dakemi, niya hedin hileng man kamambalin ni apuy ma-lat panilag mi. ");
INSERT INTO ify_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nem hedin henin nuntan pehding mu e endien mudda emin tutu-um ey penghel ngun tutu-ud edum ni bebley ni nangngel ni meippanggep ni hi-gam niya et-eteng ni kabaelam ");
INSERT INTO ify_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","e mukun pintey mudda tutu-um di desert ey tep eleg mu kabaelan ni iddateng idad bebley ni inhel mun pengillawwam ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Et humman hu, peang-ang mu anhan hu elaw mu e humman hu inhel mu lan kammuy: ");
INSERT INTO ify_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Hi-gak e Dios ey bekennak ni nelakah ni umbunget. Et-eteng hu impeminhed kun hi-gayu. Ey nakka liwwana liwat yu niya ngehay yu. Nem eggak ebbulutan eleg mekastigu hu liwat yu, tep kastiguek ali hu u-ungnga yu tep ya liwat yun a-ammed da, anin idan inap-apu yu.’ ");
INSERT INTO ify_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Et humman hu, gapuh ni et-eteng ni impeminhed mu e Apu Dios, ey nakka iddasal e pesinsahim anhan hu liwat idan nunyan tutu-u henin impenading mun hi-gada meippalpun neni-yanan dan Egypt.” ");
INSERT INTO ify_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Hinumang Apu Dios e kantuy “Em, anin pessinsahak ida, tep imbagam ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nem hi-gak e wadan ingganah niya kamedeyyaw ni Dios ey issapatah ku ");
INSERT INTO ify_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","e endin hi-gadalli mategun an umdateng di diman ni bebley. Tep anin ni inang-ang dad Egypt niyad eleg mebebleyi hu dayaw ku niyadda impahding kun eleg kabaelan ni tuu ey kapyatun eleg da u-unnuda tugun ku et daka patnai anus kun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Et humman hu, eleg mabalin ni wadan hi-gada an umdateng etan di bebley ni inhel ku lan aammed dan iddawat kun hi-gada. Tep eleg mabalin ni mekidteng ida tutu-un eleg mengu-unnud ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nem hi Kaleb e bega-en ku ey nanengtun et-eteng hu dinel tun hi-gak. Et humman hu, hi-gatun ebuh hu dammutun mekidteng di diman ni bebley ni tu siniim et mambebley ida helag tudman. ");
INSERT INTO ify_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Entan pampalaw di nedeklan ni nambebleyan idan iAmalek niyadda iKanaan tep yan kabbuhhan ey mambangngad kayu et mampalaw kayud eleg mebebleyid appit ni Madlang ni Baybay.” ");
INSERT INTO ify_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kan mewan nan Apu Dios nan Moses et hi Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Endi pappeg ni lilih idan nunyan tutu-un hi-gak et deh e imminglayyak law. ");
INSERT INTO ify_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ehel yu huyyan hi-gada e kangkuy ‘Nanna-ud ni pehding kun hi-gayu hu inhel yun meippahding ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nanlilihan kayun hi-gak, et humman hu mettey kayun emin eyad eleg mebebleyi! Endin hi-gayun meippalpud dewampulu toon tun nekilista etan ni nebilangan ni tuu ");
INSERT INTO ify_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","hu an umdateng di bebley ni insapatah kun iddawat kun hi-gayu. Ebuh di Kaleb e u-ungngan Jephunneh nan hi Joshua e u-ungngan Nun ni umdateng diman. ");
INSERT INTO ify_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Yadda etan u-ungnga yun kanyuy ellan ni buhul yu ey hi-gada pedetteng kudman e bebley ni pinihul yu et hi-gada mambebley diman et man-am-amleng ida. ");
INSERT INTO ify_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Nem hedin hi-gayun a-ammed da, ey mettey kayu eyad eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Yadda u-ungnga yu hu manhelheltap eyad eleg mebebleyi ni na-pat ni toon et lumeniklikweh ida tep eleg yu u-unnuden hu tugun ku ingganah ni endi metdaan ni hi-gayu, anin ni hakey. ");
INSERT INTO ify_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ya etan na-pat ni aggew ni yu nansiiman di Kanaan ey pambalin kun na-pat ni toon ni panliggatan yu tep ya liwat yu et penang-angan yun bunget kun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Et makulug ni hanniman pehding kuddan lawah ni tutu-un nangngehay ni hi-gak ma-lat matey idan emin eyad eleg mebebleyi. Hi-gak e Ap-Apu e Dios hu nanghel ni nunya.’” ");
INSERT INTO ify_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Yadda intu-dak Moses ni an nansiim et idaddatteng da beken ni makulug et humulun ni nanlilihan idan nunman ni helag Israel ey impandegeh idan Apu Dios et matey ida. ");
INSERT INTO ify_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ebuh law di Joshua e u-ungngan Nun et hi Kaleb e u-ungngan Jephunneh ni nanengtun mategun hi-gadan hampulut dewwan nansiim. ");
INSERT INTO ify_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Inhel Moses idan edum tun helag Israel hu inhel Apu Dios ey nemahhig lemyung da. ");
INSERT INTO ify_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kanday “Em, mika ebbuluta e nanliwat kami. Et humman hu, nandaddan kami law ni umlaw di bebley ni inhel Apu Dios ni lawwan mi.” Kamangkewa-wa ey immegah idan umlaw di duntuduntug ni bebley di Kanaan. ");
INSERT INTO ify_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nem kan Moses ni hi-gaday “Kele nealay eleg yu u-unnuda olden Apu Dios ni mambangngad kayud eleg mebebleyi? Endi silbin nuntan ni pehding yu. ");
INSERT INTO ify_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Entan kuma panglaw yu! Eleg dakeyu baddangin Apu Dios. Nanna-ud ni meapput kayu. ");
INSERT INTO ify_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Mettey kayun an mekiggubbat idan Amalekite niyadda Kanaanite. Inwalleng dakeyun Apu Dios tep nginhay yu.” ");
INSERT INTO ify_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nem impilit idan helag Israel ni limmaw di duntuduntug ni bebley ey eleg da itebin hu Kaban Apu Dios niya eleg makilaw hi Moses. ");
INSERT INTO ify_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Entanni ey immalidda Amalekite niyadda Kanaanite ni nambebley diman et apputen dadda et pampedugen dadda humman ni helag Israel ingganah di Hormah. ");
INSERT INTO ify_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kan mewan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ehel mu huyya idan edum mun helag Israel: Hedin umdateng kayud Kanaan e iddawat kun pambebleyan yu ");
INSERT INTO ify_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","et man-appit kayun hi-gak ni kagihheba, ey mahapul ni ya animal yun kalneroh winu gelding ey baka hu i-appit yu. Nem hedin man-appit kayun kagihheba gapuh ni insapatah yu winu iggeb-at yun man-appit winu ya etan yuka i-appit ni katootoon ni piyestah, ");
INSERT INTO ify_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ey mahapul ni meunnudan ni hangkiloh ni kayyaggud ni alinah ni neha-adan ni hakey ni litroh ni mansikan olibah. ");
INSERT INTO ify_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ya mei-unnud di hakey ni pakeetteng tun kalneroh ni kamei-appit ni kagihheba ey hakey ni litroh ni meinnum ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Hedin lakkitun kalneroh hu mei-appit ni kagihheba ey meunnudan ni dewwan kiloh ni alinah ni na-duman ni ngannganih ni hakey et kagedwah ni litroh ni mansikan olibah, ");
INSERT INTO ify_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ey ngannganih ni hakey et kagedwah ni litroh ni meinum ni kamei-appit. Ma-lat hi-gak e Ap-Apu ey um-amlengngak tep ya nebanglun hamuy da. ");
INSERT INTO ify_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Hedin kilaw ni lakin baka hu mei-appit ni kagihheba gapuh ni insapatah winu gapuh ni pekiddagyuman nan Apu Dios, ");
INSERT INTO ify_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ey mahapul ni meunnudan ni tellun kiloh ni alinah ni nekamdugan ni epat ni litroh ni mansikan olibah, ");
INSERT INTO ify_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","niya dewwan litroh ni meinnum, ma-lat umamlengngak ni hamuy da. ");
INSERT INTO ify_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Huyyadda hu mahapul ni meunnud di pan-appitan ni kilaw ni lakkitun baka winu lakkitun kalneroh niya pakeetteng tun kalneroh winu gelding. ");
INSERT INTO ify_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hanniman ipahding yun emin hedin man-appit kayuddan nunyan animal. ");
INSERT INTO ify_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mahapul ni emin kayun helag Israel ey u-unnuden yudda huyyan emin ni pan-appitan yun hi-gak e Ap-Apu. ");
INSERT INTO ify_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Anin idan nalpud edum ni bebley ni nekibebley ni hi-gayu et mahapul ni u-unnuden dadda huyyan kameunnud ni pan-appitan dan hi-gak ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hi-gayuddan helag Israel niyadda nekibebley ni hi-gayun nalpud edum ni bebley, ey mahapul ni u-unnuden yudda huyyan tugun ni meunnud ni ingganah, tep nan-iingngeh nakka pengibbillang ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Man-iingngeh hu tugun ni u-unnuden yun helag Israel niyadda nekibebley ni hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Immehel mewan hi Apu Dios nan Moses ey kantuy ");
INSERT INTO ify_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ehel mudda huyyan helag Israel: ‘Hedin wada kayulli law di bebley ni pengillawwak ni hi-gayu, ");
INSERT INTO ify_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ey mahapul ni wada appilen yun i-appit yun hi-gak e Dios yu etan idad kamekkan ni lameh ni neitnem diman. ");
INSERT INTO ify_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hedin mewan mengapya kayun sinapay ni nalpud pakeani yu, ey mahapul ni um-appil kayun mei-appit henin yuka pehding ni memengngulun meennin intanem yu. ");
INSERT INTO ify_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mahapul ni man-appit kayun hi-gak ni katootoon idan nunman ni sinapay ni kapyaen yud nemangulun ineni yu. ");
INSERT INTO ify_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Hedin wada eleg mengu-unnud idan Tugun kun indawat kun Moses, ");
INSERT INTO ify_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","niya hedin kantu et wadaddallid helag yun edum ni aggew hu eleg mengu-unnud idan nunyan Tugun, ");
INSERT INTO ify_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","nem eleg da igeb-at niya eleg amtan emin idan helag Israel humman ey mahapul ni i-appit dan kagihheba hu hakey ni kilaw ni lakkitun baka, niya unnudan dan alinah niya meinnum et umamlengngak ni nebanglun hamuy tu. Mahapul mewan ni man-appit idan hakey ni lakkitun gelding tep ya liwat da. ");
INSERT INTO ify_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","I-appit ni padi ida humman ni pengippahdingan tun elaw ni panlinnih et pesinsahak hu nanliwatan dan emin ni bimmebley tep eleg da igeb-at niya tep nan-appit idan hi-gak ni kagihheba ey nan-appit ida tep ya liwat da. ");
INSERT INTO ify_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Anin idan nekibebley ni hi-gada et neilegat idan emin di eleg da pengigeb-atan ni nanliwatan da, nem pessinsahak ida tep yadda humman ni kamei-appit. ");
INSERT INTO ify_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Hedin hakey hu nanliwat e eleg tu igeb-at, ey i-appit tu hakey ni hantoon tun labah ni gelding. ");
INSERT INTO ify_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","I-appit ni padin hi-gak e Ap-Apu humman ni i-appit etan ni tuu ma-lat pesinsahak hu liwat tu. ");
INSERT INTO ify_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Huyyan tugun ey mahapul ni u-unnuden ni emin ni helag Israel niyadda nekibebley ni hi-gada tep neilegat idan emin nunman ni eleg meigeb-at ni liwat. ");
INSERT INTO ify_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","31","Hedin inggeb-at ni helag Israel winu ya etan nekibebley ni hi-gadan nanliwat, tep imbilang tun endi silbitu hu tugun ku et eleg tu u-unnuden ey humman keang-angan tun tuwak kangenghaya. Et humman hu, eleg law meibbillang ni tuuk. Hi-gatu ngu kan bahul ni kekastiguan tu.’” ");
INSERT INTO ify_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Yan kawedaddan helag Israel di eleg mebebleyi ey wada hu hina-kupan dan an nangyew ey Sabaduh nunman e pi-yew hu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Inewit da et ilaw dad kad-an di Moses nan Aaron niyadda edum da. ");
INSERT INTO ify_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Impeguwalya da ni et hegeden da hu peamtan Apu Dios ni pehding dan hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Entanni ey kan Apu Dios nan Moses ey “Mahapul ni mettey humman ni nanliwat. Ilaw yud a-allaw ni nangkampuan yu et yu tengbaen diman et matey.” ");
INSERT INTO ify_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Inu-unnud idan helag Israel humman ni intugun Apu Dios, et ilaw da humman ni tuud a-allaw ni nangkampuan da et tengbaen da et matey. ");
INSERT INTO ify_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Immehel mewan hi Apu Dios nan Moses ey kantuy ");
INSERT INTO ify_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ehel mu mewan idan tuu et ha-adan da utduk ni balwasi dan buybuy e nebedbed ni blue ni sinulid. Mahapul ni mannananeng ni hanniman hu pehding idallin helag yun edum ni aggew. ");
INSERT INTO ify_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Huyyaddan buybuy ni balwasi yu hu mengippenemnem ni hi-gayun tugun ku, ma-lat u-unnuden yu et beken ni yadda pinpinhed yu hu pehding yu, tep humman ida dedan daydayu tun pehding yu ");
INSERT INTO ify_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ma-lat nemnemen yun u-unnuden ida huyyan tugun ku et eleg yu liwwanen e hi-gayu tuuk. ");
INSERT INTO ify_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Hi-gak hu Ap-Apu e Dios yu! Impa-kal dakeyud Egypt ma-lat dayawen yuwak. Hi-gak hu Ap-Apu e Dios yu.” ");
INSERT INTO ify_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Hakey ni aggew ey nantutuggun di Korah e u-ungngan Ishar e helag Kohat e u-ungngan Levi, et yadda helag Reuben e di Dathan nan Abiram e u-ungngaddan Eliab, et hi On e u-ungngan Peleth, ");
INSERT INTO ify_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","e ngenghayen da hi Moses. Entanni ey nei-dum ni hi-gada hu dewanggatut et neliman kamengipappangnguluddan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Limmaw idad kad-an di Moses nan Aaron et kandan hi-gada ey “Nehalman kumamman yuka pehding! Emin itsun helag Israel ey neieng-eng itsun Apu Dios ey wada hi-gatud emin ni hi-gatsu. Kele yuka pannemnem ni annel yu man eta-ta-gey kayu nem yadda eya edum ni tuun Apu Dios?” ");
INSERT INTO ify_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Dingngel Moses hu inhel da ey limmukbub di puyek et mandasal. ");
INSERT INTO ify_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Entanni ey kantun Korah et yadda etan edum tuy “Peamtan Apu Dios ni kakkabbuhhan hedin hipan hi-gatsu hu pinili tun bega-en tu ey hedin hipan hi-gatsu hu kayyaggud di hinangga tu. Hedin hipa pillien tun hi-gatsu ey hi-gatu eyyagan tud altar e kad-an tu. ");
INSERT INTO ify_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Et humman hu, hi-gam e Korah et yadda edum mu ey mahapul ni heninnuy hu pehding yu. Yan kakkabbuhhan ey ala kayun emin ni pengiggihheban ni insensoh ni i-appit yun Apu Dios. Ha-adi yun insensoh ni gihheben yu et ilaw yud kapan-appisin nan Apu Dios, et ang-angen tayu hedin hipa pillien tun kakkayyaggud. Ya kakulugan tu ey hi-gayun helag Levi hu nehalman kumamman!” ");
INSERT INTO ify_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kan mewan nan Moses nan Korah ey “Dengel yu huyya, hi-gayuddan helag Levi! ");
INSERT INTO ify_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kaw yuka kullanga hu impahding nan Apu Dios e yaddad emin ni helag Israel ey hi-gayun helag Levi hu pinili tun meihnup ni hi-gatun pengippahdingan yuddan ngunu yud Tabernacle niya kayu kaum-ehneng di hinanggaddan tutu-un pengippahdingan yun panyaggudan da? ");
INSERT INTO ify_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Hi-gayun ebuh et yadda edum yun helag Levi hu nengidewatan tun nuntan ni ngunu. Yan nunyay pinhed yu pay ni hi-gayu mampeddi? ");
INSERT INTO ify_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hi Apu Dios hu kakulugan tun nginhay yu, tep kaw hipa hi Aaron ni yuka ingngudungudu?” ");
INSERT INTO ify_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Impaeyag Moses di Dathan nan Abiram e u-ungngaddan Eliab nem kanday “Eleg mi pinhed ni um-ali! ");
INSERT INTO ify_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kela, kaw kulang pay hu impahding mun impa-kal dakemid Egypt e makatmel ey mateba kameitnem ey dakel kennen niya putsukan et i-li dakemi eyad eleg mebebleyi, ma-lat matey kamidya? Pinhed mu mewan ni hi-gam ni ebuh hu tengngawen min ap-apu? ");
INSERT INTO ify_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hakey pay ey ingganah nunyay eleg dakemi ilaw di bebley ni matmel kameitnem ey dakel kennen niya putsukan. Niya attu mewan etan kammun iddawat mun puyek mi ey payew mi ey? Kaw dakemi kahe-uhe-ula? Eleg kami mannuman um-ali!” ");
INSERT INTO ify_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Entanni ey bimmunget hi Moses et mandasal nan Apu Dios e kantuy “Apu Dios, iddasal ku e entan tu abulut hu i-appit idan nunyan tuun hi-gam. Endi nak impahding ni lawah ni hi-gada e endi nak inlan animal da ey hanneya daka pehding ni hi-gak.” ");
INSERT INTO ify_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kantu mewan nan Korah ey “Mahapul ni um-ali kayun emin idan edum mun kabbuhhan di kapandeyyawin Apu Dios. Anin hi Aaron et um-ali. ");
INSERT INTO ify_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ang-ang mu et emin ida etan dewanggatut et neliman immunud ni hi-gam, ey um-i-liddan pengiggihheban ni insensoh et iappit yun Apu Dios di pan-appitan. Anin hi Aaron et um-i-li daman i-appit tu.” ");
INSERT INTO ify_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Immalidda et umi-liddan pengiggihheban e hina-adan dan ngalab et ya insensoh et makiehneng idad Moses nan Aaron di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hi Korah hu nenuttudduddan edum tun ngenghayen da hi Moses et hi Aaron. Humman hu neamung idan emin et umehneng idad heggeppan ni Tabernacle, ey endi maptek ey nampeang-ang hu kaumhilin dayaw Apu Dios ni hi-gadan emin. ");
INSERT INTO ify_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Immehel hi Apu Dios e kantud Moses nan Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Keibtaw kayud kad-an da et endiek idan nunya.” ");
INSERT INTO ify_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nem nanyuung di Moses nan Aaron et mandasal idan hi-gatu e kanday “Apu Dios e kakelpuin biyag, kaw hedin nambahul hu hakey ni tuu man illagat mun ibbunget idan emin eyadda edum da?” ");
INSERT INTO ify_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ehel muddan eyan tuu et uma-allaw idad kampud Korah, hi Dathan et hi Abiram.” ");
INSERT INTO ify_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Impapuut Moses ni limmaw di kampud Dathan nan Abiram ey neiunud idan hi-gatu hu aap-apun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kantuddan etan ni tuu ey “A-allaw kayud kampuddan eyan lawah ni tuu ey ang-ang yu et endi keppaen yun usal da, et eleg kayu mailegat ni mekikkettey ni hi-gada gapuh ni nanliwtan da.” ");
INSERT INTO ify_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Inu-unnud da et uma-allaw idad kampud Korah, hi Dathan et hi Abiram. Entanni ey immehep hi Dathan et hi Abiram, yadda ahwa da, ya u-ungngada et yadda gegellang ni u-ungnga da et umehneng idad pettek ni habyen ni kampu da. ");
INSERT INTO ify_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kan Moses ey “Huyya pengamtaan yun hi Apu Dios hu nemutuk hi-gak ni mengippahding idan nunya e beken ni emin nalpud nemnem ku. ");
INSERT INTO ify_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hedin mettey ida huyyan tuu e beken ni gapuh ni pengastigun Apu Dios ey humman keang-angan tun eleg da-ak putuken nan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Nem hedin meippahding ni hi-gada hu kamengippetnga e nealay neunug ida lad puyek anin idan ngunut da et maikulung idan mategu ey humman pengamtaan yun inwalleng da hi Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Negibbuh ni immehel hi Moses ey pinhakkeyey nadhak hu puyek ni inehnengan da, ");
INSERT INTO ify_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","et maunug ida, yadda pamilyah da, et yadda etan immunud nan Korah, anin idan ngunut da. ");
INSERT INTO ify_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mateguddan neunug di kad-an idan nangketey. Nekiunug ni hi-gadadda emin hu wadan hi-gada, et han mewan mambangngad hu puyek ni nangketem et meendidda. ");
INSERT INTO ify_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Emin ida helag Israel ni wadadman ni nangngel ni pekaw da ey namsik ida ey ida kamantetekkuk e kanday “Besik itsu tep entanniy ekmunen daitsu daman puyek!” ");
INSERT INTO ify_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Entanni ey impaelin Apu Dios hu apuy et magiheb ida etan dewanggatut et neliman nan-appit ni insensoh. ");
INSERT INTO ify_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ehel mun Eleasar e u-ungngan Aaron e padi et tu amungen ida hu pengiggihheban ni insensoh ni inusal etan idan nunman ni nangketey ni lalakki. Ehel mun hi-gatu et tudda iwehit hu ngalab di a-allaw tu, tep neieng-eng ida humman ni pengiggihheban ni insensoh ");
INSERT INTO ify_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ni inusal idan nunman ni lalakkin nambahul et mangketey ida. Ehel mu et humman idan pengiggihheban ni insensoh ey kapyaen tuddan meingpih ni meittekkap di altar et mambalin ni warning idan helag Israel. Humman idan pengiggihheban insensoh ey neieng-eng tep neipeang-ang idan hi-gak e Dios.” ");
INSERT INTO ify_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Limmaw Eleasar e padi et tu pan-amungen ida humman ni dewanggatut et neliman pengiggihheban ni insensoh, et kapyaen tuddan meittekkap di altar e inu-unnud tu inhel Apu Dios ni inhel Moses ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Humman hu mengippenemnem idan helag Israel e endi edum, ebuh ida helag Aaron ni dammutun mengihheb ni insensoh ni kamei-appit nan Apu Dios. Tep hedin linggeman ni tuu hu umlaw diman ni mengihheb ni insensoh, ey mettey et henid Korah et yadda etan edum tu. ");
INSERT INTO ify_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nem entanni et mewa-wa ey ida mewan kamanlillih humman idan tuun nan Moses et hi Aaron e kanday “Pintey yudda edum ni tuun Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Yan nunman ni neamungan dan daka panlillihid Moses nan Aaron ey inang-ang da etan di Tabernacle hu kaumhilin heyaw Apu Dios di kulput ni neihephep diman. ");
INSERT INTO ify_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","An immehneng di Moses nan Aaron di heggeppan ni Tabernacle ");
INSERT INTO ify_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ey immehel hi Apu Dios nan Moses e kantuy ");
INSERT INTO ify_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Keibtaw kayudda eyan tuu et pateyen kudda!” Nem nanlukbub mewan di Moses nan Aaron di puyek. ");
INSERT INTO ify_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Entanni ey kan Moses nan Aaron ey “Papuut mu et mu alen hu pengiggihheban ni insensoh, et ha-adam ni ngalab melpud altar et ya insensoh et lumaw kad kad-an ida eyan tuu et iappit mun Apu Dios tep ya liwat da. Bimmunget tu-wa anhan law hi Apu Dios ni hi-gada et paeli tu degeh et deh e neilepun ida kamangkettey.” ");
INSERT INTO ify_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Inu-unnud nan Aaron et tu alen hu kapanggihhebin insensoh et mambesik di gawwaddan nunman ni tuu. Inang-ang tu e nelapuan ni ida kamandedgeh nem nan-appit ni insensoh nan Apu Dios tep ya liwat da, ");
INSERT INTO ify_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","et masiked etan degeh et tu i-ang-ang ey immehneng di nambattanan idan mategu et yadda nangketey. ");
INSERT INTO ify_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ya bilang idan tuun netey ni nunman ey hampulut epat ni libu et pitu gatut. Nem eleg makibilang ida etan netey ni immunud nan Korah. ");
INSERT INTO ify_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Nesiked etan degeh et han mambangngad hi Aaron di kad-an Moses di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Entanni ey immehel mewan hi Apu Dios nan Moses ey kantuy ");
INSERT INTO ify_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ehel mudda etan ni hampulut dewwan kamengipappangngulun helag Israel et umidwat idan hanhakkey ni hulkud ni hi-gam. Ey intudek mu ngadan dad hulkud da. ");
INSERT INTO ify_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Yad hulkud ni kamengipappangnguluddan helag Levi ey itudek mu ngadan Aaron. Mahapul ni wadan emin hu hulkud idan kamengipappangngulun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ey ipahgep mudda humman ni hulkud di Tabernacle di kuwaltuh di kad-an kun taka pandammui et iha-ad mud hinangga etan ni Kaban ni neitluan ni neitudek ni Tugun ku. ");
INSERT INTO ify_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ka-immatun tep umpingi hu hulkud etan ni tuun pilliek, ma-lat masiked hu lilih idan edum mun helag Israel ni hi-gam tep ya humman ni pehding ku.” ");
INSERT INTO ify_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Inhel Moses huyyan meippahding idan helag Israel et wada hakey idan hampulun dewwan kamengipappangngulu, anin hi Aaron et umidwat idan hanhakkey ni hulkud dan Moses. ");
INSERT INTO ify_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Inha-ad Moses emin humman idan hulkud di bawang ni Tabernacle di hinanggan Kaban Apu Dios e neitluan ni Tugun tu. ");
INSERT INTO ify_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Entanni et newa-wa et lumaw hi Moses di bawang ni Tabernacle ey inang-ang tu e pimmingi hu hulkud Aaron e nengiehneng idan helag Levi niya wada lameh tun almond ni neluum. ");
INSERT INTO ify_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Inla tuddan emin etan hulkud et tu peang-ang idan edum tun helag Israel et ang-angen da neipahding, et ibangngad tudda humman ni hulkud etan idad kamengipappangngulu. ");
INSERT INTO ify_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Kan Apu Dios nan Moses ey “Ibangngad mu hulkud Aaron di hinanggan Kaban ma-lat mengipenemnem idan kamangngenghay ni tutu-u e hedin eleg da issiked ni manlillih man mettey ida.” ");
INSERT INTO ify_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Et ipahding Moses hu inhel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Kan idan tutu-u nan Moses ey “Heni kami damengu netey tep nanna-ud ni mettey kami. ");
INSERT INTO ify_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Anin anhan ni keihnupan di Tabernacle et mettey ita, et humman hu, heni kami damengu netey!” ");
INSERT INTO ify_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Kan Apu Dios nan Aaron ey “Hi-gam niyadda u-ungngam niyadda agim ni helag Levi hu mebehhulan hedin hipa meippahding eyan Tabernacle. Nem hedin ya meippanggep ni meihhallad pansilbian yun papaddi, ey hi-gayuddan u-ungngam ni ebuh hu mebehhulan. ");
INSERT INTO ify_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Aygim ida agim ni helag Levi et baddangan dakeyuddan u-ungngam ni pengippahdingan yuddan meingngunnud hinanggan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Nem ang-ang yu et yan pengippahdingan dan ngunu da ey eleg da keppaa hu ngunut ni neieng-eng, anin etan altar. Tep hedin wada keppaen da ey mettey kayun emin. ");
INSERT INTO ify_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mahapul mewan ni mei-dum idan hi-gayun pengippahdingan dan ngunu dan mengippaptek eyan Tabernacle, nem eleg mabalin ni wada hu beken ni helag Levi ni mekingngunnun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Hedin ya ngunu yuddan u-ungngam ey ippaptek yu hu Tabernacle niya altar. Hedin u-unnuden yudda huyyan tugun ku ey eggak law umbunget ni hi-gayun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Hi-gak hu nemiliddan agi yun helag Levi di emin idan helag Israel et bumaddang idan hi-gayu. Neieng-eng idan hi-gak e Ap-Apu ma-lat mangngunudda eyad Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nem mahapul ni hi-gam niyadda anhan ni u-ungngam hu mengippahding idan ngunun padid altar niyad Kuwaltuh ni kad-ak. Tep hi-gayu hu pinilik ni mengippahding idan nunman ni ngunu. Et humman hu, hedin wada edum ni tuun mengippahding idan nunman et um-alin meihnup eyad kad-an ku man mettey.” ");
INSERT INTO ify_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Heninnuy ida hu intugun Apu Dios nan Aaron: “Hi-gayun papaddin pinilik ni mengi-appit idan i-appit ni helag Israel ni hi-gak, ey iddawtan dakeyun ingganah ni patal yuddad i-appit da. ");
INSERT INTO ify_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Meidwatan kayun kamei-appit ni eleg gihheba henin kamei-appit ni pagey, yadda kamei-appit tep ya liwat niyadda kamei-appit tep ya bahul. ");
INSERT INTO ify_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Hedin kennen yudda huttan, ey nemnemnem yu e neieng-eng idan hi-gak, niya ebuh ida lalakkin dammutun mengngan idan nuntan. ");
INSERT INTO ify_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Meidwatan kayu pay idan edum ni i-appit idan helag Israel ni itta-gey dan peang-ang ni hi-gak. Dammutun kennen idan u-ungngam ni lalakki niyadda bibi-i huyya, nem ebuh ida kameibbillang ni malinih ni dammutun mengngan idan nunman. ");
INSERT INTO ify_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Iddawat ku mewan ni hi-gayu hu kekakkayyaggudan ni mansikan olibah, yadda memengngulun ennien da niyadda memengngulun lameh ni intanem da. ");
INSERT INTO ify_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Emin ida humman ni i-aliddan edum yun helag Israel ni hi-gak ey iddawat kun hi-gayu. Nem ebuh ida etan kameibbillang ni malinih ni mengngan idan nunman. ");
INSERT INTO ify_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Iddawat ku pay ni hi-gayu emin ni iggeb-at dan i-appit ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Emin mewan hu pengulwan ni lalakkin u-ungngaddan edum yun helag Israel, anin idan memengngulun impah ni animal dan iddawat dan hi-gak ey iddawat kun hi-gayu. Meidwat pay ni hi-gayudda etan ibbayad idan tuun pemangngadan dan pengulwan ni lalakkin u-ungnga da niyadda ibbayad dan memengngulun lakkitun impah ni animal ni kameibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ya gelang ni hambulan tu ey liman palatah ni silber hu bayad ni pemangngad dan hi-gatu, meippuun di kameunnud ni kapemeyyad. ");
INSERT INTO ify_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Nem eleg mabalin ni mebangngad hu nemangulun impah ni baka, ya kalneroh niya gelding, tep neieng-eng ida humman ni kamei-appit ni hi-gak. Iwakgih yu kuheyaw dad kapan-appisi niya giheb yu tabeda ma-lat umamlengngak ni hamuy da. ");
INSERT INTO ify_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ellan yudda humman ni detag, henin pagew niya wannan ni lapan meitta-gey ni meippeang-ang ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Iddawat ku nisin hi-gam, yadda u-ungngam ni lalakki niyadda bibi-i ni emin hu neieng-eng ni i-appit idan edum yun helag Israel ni hi-gak. Huyyan inhel ku ey mannenneng e eleg mabalin ni mekyat winu mehullulan.” ");
INSERT INTO ify_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Immehel mewan hi Apu Dios nan Aaron ey kantuy “Eleg dakeyu iddawsin puyek ni beltanen yu tep hi-gak e Ap-Apu hu mahapul yun ebuh. Hi-gak hu mei-ellig ni beltanen yu. ");
INSERT INTO ify_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hedin yadda edum mun helag Levi ey iddawat kun hi-gada hu kapulun lelmuen idan emin ni helag Israel ni i-appit dan hi-gak, et humman tangdan dan pangngunnuan da eyad Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Meippalpun nunya ey eleg mabalin ni maka-ihnup di Tabernacle hu edum yun helag Israel ni beken ni helag Levi ey beken ni padi tep mekastigudda et matey ida. ");
INSERT INTO ify_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Yadda helag Levi ni ebuh hu mangngunnud Tabernacle et hedin wada ngu neihallan impahding da ey hi-gada ngu kan bahul. Huyyan olden ey mannannang ni ingganah e eleg mehulluli. Endi an meidwat ni hi-gadan beltanen dan puyek eyad Israel, ");
INSERT INTO ify_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","tep hedin ya iddawat kun hi-gada ey ya kapulun i-appit idan emin ni helag Israel. Et humman hu, gaputun endi da beltanen ni puyek da.” ");
INSERT INTO ify_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Kan Apu Dios daman Moses ey ");
INSERT INTO ify_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Itugun muddan helag Levi e hedin dewwaten da hu kapulun limmuddan edum dan helag Israel e humman hu iddawat kun beltanen da ey mahapul ni i-appit dan hi-gak hu kapulun nunman idan dewwaten da. ");
INSERT INTO ify_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Et humman ni i-appit da daman hi-gak ey heni humman nemangulun pagey nalpud illikkan da winu meinnum ni nalpud daka pengapyain meinnum. ");
INSERT INTO ify_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Humman ni i-appit da daman hi-gak ni kapulun dewwaten dad kapulun limmuddan edum dan helag Israel ey iddawat dan Aaron e padi. ");
INSERT INTO ify_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mahapul ni i-appit dan hi-gak hu kekakkayyaggudan ni dewwaten da. ");
INSERT INTO ify_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Humman idan i-appit dan hi-gak ey humman dama etan nemangulun pagey winu meinnum ni i-appit idan edum dan helag Israel ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Yadda edum ni dewwaten da ey dammutun kennen dadda pamilyah da di kumpulmih ni lugal tep sinekla dadda humman di daka pangngunnuid Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Eleg ida mebehhulin pengngannan daddan nunman hedin in-appit dan hi-gak hu kekakkayyaggudan. Nem mahapul ni eleg da hibbita humman idan i-appit ni edum dan helag Israel ni hi-gak. Tep hedin lelgemen da pehding da ey mettey ida.” ");
INSERT INTO ify_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Immehel mewan hi Apu Dios nan Moses et hi Aaron ey kantuy ");
INSERT INTO ify_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ehel yuddan helag Israel huyyan Tugun kun hi-gada: Mahapul ni um-i-liddan madlang ni labah ni bakan endi dipektoh tu niya eleg tu ni patnaan ni mangngunnu ");
INSERT INTO ify_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","et idwat dan Eleasar e padi. Meillaw humman ni bakad a-allaw ni nangkampuan da et kelngen dad hinanggan Eleasar. ");
INSERT INTO ify_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Um-ala hi Eleasar ni kuheyaw nunman ni baka et itdek tu kimeng tu et iwakgih tun meminpittud appit ni hinanggan Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Mei-appit ni kagihheba humman ni bakad hinanggan Eleasar e eleg mede-ut et makigiheb hu belat tu, ya laman tu niya egeh tu. ");
INSERT INTO ify_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Um-ala mewan hi Eleasar e padin keyew ni sedar, ya hissop niya madlang ni sinulid et pakigiheb tu etan ni baka. ");
INSERT INTO ify_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hedin negibbuh humman ey pakkaw ibbalbal tu balwasi tu niya man-e-meh et han dammutun umhegep di nangkampuan da, nem meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mahapul daman ibbalbal etan ni tuun nengiheb ni baka hu balwasi tu niya man-e-meh, nem meibbillang ni beken ni malinih ingganah mehilleng. ");
INSERT INTO ify_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ya etan tuun meibbillang ni malinih ey ellan tu etan dep-ul ni bakan negiheb, et tu iha-ad di a-allaw ni kampun kameibbillang ni malinih, ma-lat ussalen idan helag Israel huyyan dep-ul ni pengippahdingan dan elaw ni panlinnih e ikkamdug dad danum. Humman ni pehding dan elaw ni panlinnih ey ke-kalan ni liwat. ");
INSERT INTO ify_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Humman ni tuun mengellan dep-ul ey mahapul ni ibbalbal tu balwasi tu, nem meibbillang ni beken ni malinih ingganah mehilleng. Mannenneng ni meunnud ni ingganah huyyan tugun idan helag Israel niyadda nekibebley ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ya etan tuun mengeppan annel ni netey ni tuu ey meibbillang ni beken ni malinih ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mahapul ni pehding tu hu elaw ni panlinnih ni katlun aggew et yan kapitun aggew et han dammutun meibbillang ni malinih. Nem hedin eleg tu pehding huyyan meikkatlu et yan meikkeppitun aggew, ey mannenneng ni meibbillang ni beken ni malinih anin ni melebbah pitun aggew. ");
INSERT INTO ify_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ya etan tuun kinepa tu annel ni netey nem eleg tu ipahding hu elaw ni panlinnih, ey hinibit tu hu Tabernacle. Et humman hu, eleg law mabalin ni meki-dum idan tuuk. Mannananeng ni beken ni malinih humman ni tuu tep eleg maduyagan ni danum ni kapanlinnih. ");
INSERT INTO ify_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Hedin wada netey di hakey ni a-abbung etan di kampu ey ya etan tuun wadadman, anin ni ya etan tuun himmegep diman ey meibbillang ni beken ni malinih ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Emin hu bewed winu bangan eleg mehu-keban ni wadadman ey meibbillang ni beken ni malinih. ");
INSERT INTO ify_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ya etan tuun mengeppan pintey dan tuu winu netey ni gandat di a-allaw ni bebley ey meibbillang ni beken ni malinih. Anin ya etan tuun mengeppan genit ni netey winu kulung et meibbillang daman beken ni malinih ni pitun aggew. ");
INSERT INTO ify_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Hedin wada hakey ni tuun kameibbillang ni beken ni malinih ni mengippahding ni elaw ni panlinnih, ey ellan ni hakey ni tuun kameibbillang ni malinih etan dep-ul ni negiheb ni baka, et iha-ad tud bewed et duyagan tun danum. ");
INSERT INTO ify_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Et humman ni tuu ey um-alan hissop et ita-mel tudman et iwakgih tud kampu etan ni tuun beken ni malinih niyaddan emin di hipan wadadman, anin idan tutu-u. Ey wakgihan tu etan tuun nengapan genit ni netey, ya etan pintey dan winu gandat ni netey niya kulung. ");
INSERT INTO ify_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Humman ni tuun meibbillang ni beken ni malinih ey mewakgihan ni meikkatlu et yan meikkeppitun aggew. Ey mahapul ni ibbalbal tu hu balwasi tu niya man-e-meh ni meikkeppitun aggew et han maibillang ni malinih nunman ni hileng. ");
INSERT INTO ify_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Nem ya etan tuun kameibbillang ni beken ni malinih ey eleg tu ipahding hu elaw ni linih ey eleg law mabalin ni meki-dum idan tuuk, tep hinibit tu hu Tabernacle ey mannenneng ni beken law malinih tep eleg maduyagan hu annel tun danum ni panlinnih. ");
INSERT INTO ify_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Mahapul ni meippahding ni ingganah huyyan elaw ni panlinnih. Ya etan tuun mengiwwakgih ni danum ni kapanlinnih ey mahapul ni ibbalbal tu dama balwasi tu. Ey ya etan tuun mengeppan danum ni kapanlinnih ey meibbillang ni beken ni malinih ingganah ni hileng. ");
INSERT INTO ify_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Emin hu keppaen ni tuun kameibbillang ni beken ni malinih ey meibbillang law ni beken ni malinih, et yadda etan tuun mengeppaddan nunman ni kinepa tu, ey meibbillang idan beken ni malinih ingganah mehilleng.” ");
INSERT INTO ify_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Yan eman ni nemangulun bulan ey dimmateng ida helag Israel di Sin e eleg mebebleyi et mangkampuddad Kades. Yan kaweda dadman hu neteyyan Miriam et maikulung diman. ");
INSERT INTO ify_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Endi danum ni innumen idan tuud nangkampuan da et maemung idad kad-an di Moses nan Aaron ");
INSERT INTO ify_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","et manlillih idan Moses e kanday “Heballi ew nekiketey kamiddan edum min pintey Apu Dios! ");
INSERT INTO ify_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Kaw dakemi ingkuyug di deya e eleg mebebleyi ma-lat matey kamin emin, anin idan animal mi? ");
INSERT INTO ify_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kele dakemi dedan impangulu et mi hini-yan hu Egypt et kami umli eyad bebley ni endi kaumtemel ni neitnem? Endidya begah, ya fig, ya grapes winu pomegranates. Ey endi pay anhan danum ni innumen!” ");
INSERT INTO ify_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Hini-yan di Moses nan Aaron ida et ida umehneng di heggeppan ni Tabernacle et manlukbub idad puyek. Entanniy nampeang-ang hu kaumhilin heyaw Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Immehel hi Apu Dios nan Moses ey kantuy ");
INSERT INTO ify_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Alam etan hulkud di hinanggan Kaban et amungen yun Aaron emin ida tuu. Hedin neamung ida, ehel ka etan ni batu et maukat danum ma-lat wada innumen idan tuu niyadda animal da.” ");
INSERT INTO ify_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Inu-unnud Moses hu inhel Apu Dios et tu alen etan hulkud. ");
INSERT INTO ify_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Inemung dan Aaron ida tuud kad-an ni batu et kan Moses ey “Dengel yu e mangkanghay ni tutu-u. Kaw pepillit yun peukkat ku danum eyad batu?” ");
INSERT INTO ify_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Et iheplat tu hu hulkud ni nampidwa etan di batu ey neukat hu dakel ni danum et uminum ida etan tuu niyadda animal da. ");
INSERT INTO ify_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nem bimmunget hi Apu Dios nan Moses et hi Aaron et kantun hi-gaday “Beken ni hi-gayu mengidteng idan edum yun helag Israel di bebley ni inhel kun iddawat kun hi-gada tep eleg yuwak u-unnuden niya eleg yuwak dayawen ni nunman ni impahding yu.” ");
INSERT INTO ify_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yadman nanlilihan idan tuun nan Apu Dios et mangedanan ni Meribah. Yadman mewan nengipenang-angan Apu Dios e hi-gatu ey limpiyuh e meandeng tuka pehding. ");
INSERT INTO ify_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Yan kawedad Moses di Kades ey nenu-dak ni an mekihhummangan ni patul ni Edom et da ehelen e kanday “Heninnuy hu inhel idan agim ni helag Israel: Inamtam anhan et nemahhig hu nanhelheltapan mi. ");
INSERT INTO ify_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nekibebley idan nunman hu aammed mid Egypt ni nebayag ey impanhelheltap dadda, anin ni hi-gami. ");
INSERT INTO ify_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Et mampehemmehemmek kamin Apu Dios ey dingngel dakemi et itu-dak tu anghel ni nengipengulun hi-gamin meni-yan ni Egypt. Yan nunya ey wada kamid Kades e pappeg eyan bebley yu. ");
INSERT INTO ify_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Mika ibbaga e iebulut mu anhan et mandalan kami niyadda animal mi eyad bebley yu. Unnuunnuden mi keltad et eleg kami mandalan idad payew yu niyad habal yu niya eleg kami um-inum ni danum di bubun yu. Ya keltad ni ebuh unnuden mi ingganah melebbah kami eyad bebley yu.” ");
INSERT INTO ify_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nem kan etan ni patul di Edom ey “Entan pandalan yu eyad bebley mi tep gubbaten dakeyu hedin iddalan yudya!” ");
INSERT INTO ify_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Kan ida mewan ni helag Israel ey “Ettu kuma et iebulut mu haggud ya keltad ni ebuh unnuden mi ey? Hedin hipa et um-inum kamiddan animal min danum yu ey ku anin katteg ni beyyadan mi, nemet mandalan kami anhan eyad bebley yu.” ");
INSERT INTO ify_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nem kahing etan patul di Edom e kantuy “Eggak nisi i-abulut ni kayu mandellan eyad bebley mi!” Et idaddan kumedek idan iEdom hu dakel ni sindalu dan mengubbat idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Et hin-appil law nengidlanan da tep kaikka-leg idan iEdom hu pandellanan dadman. ");
INSERT INTO ify_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Hini-yan idan helag Israel hu Kades et mampalaw idad duntuduntug di Hor e pappeg ni Edom. ");
INSERT INTO ify_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yan nunman ni wadaddadman ey immehel mewan hi Apu Dios nan Moses et hi Aaron. ");
INSERT INTO ify_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Kantuy “Hedin hi-gam e Aaron ey eleg ka umdateng etan di bebley ni iddawat kun hi-gayun helag Israel tep mettey ka. Hanneya meippahding tep eleg yuwak u-unnuden di Meribah. ");
INSERT INTO ify_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hedin hi-gam e Moses ey ikuyug mu hi Aaron et hi Eleasar e u-ungnga tu et manteyed kayud Duntug e Hor, ");
INSERT INTO ify_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ey ekal mu hu balwasin padin inhuklub Aaron et pebalwasim nan Eleasar tep yadman ketteyyan Aaron.” ");
INSERT INTO ify_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Inu-unnud Moses humman ni inhel Apu Dios et manteyed idan tellu ey kaang-ang-angaddan tuu. ");
INSERT INTO ify_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Dimmateng idad ta-pew ni duntug et ekalen Moses hu balwasin padin inhuklub Aaron et pebalwasi tun Eleasar. Yadman di ta-pew ni duntug hu neteyyan Aaron. Entanni et mandayyud Moses et hi Eleasar di kad-an idan tutu-u. ");
INSERT INTO ify_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Dingngel idan tutu-u e netey hi Aaron et lumelemyung idan telumpulun aggew. ");
INSERT INTO ify_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ya etan patul di Kanaan e hi Arad e nambebley di Negeb ey dingngel tun iyaddalli helag Israel di keltad di Atharim ey tudda ginubat et ibsik tudda edum ni hi-gada et pambalin tuddan balud. ");
INSERT INTO ify_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Entanni et mansapatah ida helag Israel nan Apu Dios e kanday “Hedin baddangan dakemi et apputen midda ey pekabbahbahen min emin hu bebley da.” ");
INSERT INTO ify_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Dingngel Apu Dios dasal da et baddangan tuddan mengapput ni iKanaan, et pekabbahbahen dadda bebley diman et ngadanan dan Hormah. ");
INSERT INTO ify_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hini-yan idan helag Israel hu Duntug e Hor et idlan dad keltad ni mampellaw di Madlang ni Baybay et ilikweh dad Edom. Nem wadaddad dalan ey imminglay ida, ");
INSERT INTO ify_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","et daka pan-ingngudu hi Apu Dios et hi Moses. Kanday “Endi kennen di deya niya endi innumen. Impeinglay mi law eyan lawah ni mika kennakennan manna! Kele dakemi impangulun meni-yan ni Egypt et dakemi in-ali eyad eleg mebebleyi et kami matey di deya?” ");
INSERT INTO ify_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Entanni ey impaelin Apu Dios hu dakel ni anggetakkut ni uleg et pangkalaten dadda dakel ni hi-gada et mangkatey ida. ");
INSERT INTO ify_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Limmaw ida hu tuud kad-an Moses et kanday “Mika ebbuluta e nanliwat kami tep ya lawah ni inhel min Apu Dios et hi-gam. Idasali dakemi anhan et ekalen Apu Dios ida eya uleg.” Et idasalan idan Moses. ");
INSERT INTO ify_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Kan Apu Dios nan Moses ey “Kapya kan i-ingngeh ni uleg ni giniling et ipelat mud utduk ni hulkud et hedin sinengaw idan tuun kinlat ni uleg man eleg ida mettey.” ");
INSERT INTO ify_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Inu-unnud Moses et kumapyan giniling ni uleg et ipelat tud hulkud et hedin kinlat ni uleg hu hakey ni tuu et in-ang-ang tudman ey eleg mettey. ");
INSERT INTO ify_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Entanni ey nampalaw ida mewan hu helag Israel di Obot et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Hini-yan da Obot et lumaw idad Iye Abarim e eleg mebebleyi e pappeg ni Moab di appit ni kasimmilin aggew. ");
INSERT INTO ify_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Entanniy ida nangkampud Nedeklan e Sered. ");
INSERT INTO ify_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Hini-yan da mewan humman et lumaw idad ba-hil ni Wangwang e Arnon di eleg mebebleyi e dagsin bebley idan Amorite. Ya Arnon hu nampappegan ni Moab et ya bebley idan Amorite. ");
INSERT INTO ify_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Et mukun yad Libluh ni Meippanggep idan Gubat Apu Dios ey neitudek diman hu “Yad bebley e Waheb di Suphah et yadda deplah ya Wangwang e Arnon, ");
INSERT INTO ify_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","niyadda deplah di utduk etan ni nebebleyan di Ar di pappeg ni Moab.” ");
INSERT INTO ify_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Immegah idadman et lumaw idad Beer e kad-an etan ni bubun et umhel hi Apu Dios nan Moses diman e kantuy “Amung mudda tuu et idwatak idan danum.” ");
INSERT INTO ify_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Yan nunman ni tsimpuh nengia-appehan idan helag Israel ni nunyan a-appeh: “Kaukat kan danum eyad bubun et ia-appeh mi meippanggep ni hi-gam. ");
INSERT INTO ify_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","I-a-appeh mi huyyan bubun ni kinu-kuan idan u-ungngan patul, kinu-kuan idan aap-apu e inusal da hulkud da.” Hini-yan idan helag Israel humman ni eleg mebebleyi et manglaw ida et labhan da Mattanah, ");
INSERT INTO ify_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ya Nahaliel et ya Bamot, ");
INSERT INTO ify_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","et lumaw idad nedeklan di Moab di ehpen ni Pisgah e duntug e kameuhdungi etan eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Entanni et menu-dak ida helag Israel ni an mekihhummangan nan Sihon e patul idan Amorite. Heninnuy da e-helen ni hi-gatu: ");
INSERT INTO ify_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Iebulut mu anhan et idlan mi eyad bebley yu. Ya keltad ni ebuh unnuunnuden mi ingganah lebbahan mi eya bebley yu. Ey ang-angen mi ma-lat endin hi-gami, anin idan animal mi hu mengigsin ni intanem yud payew yu niyad legunta yu. Eleg kami um-inum di bubun yu.” ");
INSERT INTO ify_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nem eleg iebulut nan Sihon e patul diman ni mandellan ida hu helag Israel di bebley da. Inemung tu kumedek ida sindalu tu et dadda gubaten hu helag Israel di eleg mebebleyid Jahas. ");
INSERT INTO ify_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Nem nampatey idan helag Israel humman idan buhul dan Amorite et hi-gada mambebley di bebley da meippalpu etan di Wangwang e Arnon ingganah di Wangwang e Jabok. Nem eleg da hanhegep hu Ammon tep nehammad ni peteg hu luhud ni bebley da. ");
INSERT INTO ify_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Sinekup idan helag Israel emin hu bebley idan Amorite, ya Hesbon niyadda nanlinikweh ni bebley diman et mambebley idadman. ");
INSERT INTO ify_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Yad Hesbon e et-eteng ni bebley hu nambebleyan nan patul e hi Sihon. Inapput nan Sihon ni nunman hu Moab et sakupen tu Hesbon niyaddan emin hu bebley ingganah di Wangwang e Arnon. ");
INSERT INTO ify_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Et mukun wada neitudek ni a-appeh e kantuy: “Ali kayud Hesbon e et-eteng ni bebley Sihon, et iyayyaggud yu huyyan bebley tu et heni la mewan nunman. ");
INSERT INTO ify_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Yan nunman ey henilli nalpu apuy di Hesbon e bebley Sihon et malgab hu Ar e et-eteng ni bebley di Moab, niya nalgab ida duntug di ahpat ni Arnon. ");
INSERT INTO ify_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Anggehemmek kayun iMoab, hi-gayun kamandaydayaw nan Kemos tep nebahbah kayu. Impambalin dakeyun dios yun hi Kemos ni balud nan Sihon e patul idan Amorite. ");
INSERT INTO ify_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nem yan nunya ey nebahbah ida Amorite, anin ni yadda bebley da meippalpud Hesbon ingganah di Dibon, ey meippalpud Nophah ingganah di Medeba.” ");
INSERT INTO ify_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nampambebley ida helag Israel di bebley idan Amorite. ");
INSERT INTO ify_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Entanni ey intu-dak Moses hu an mansi-im ni Jaser. Dadda ginubat et sakupen da, anin idan nanlinikweh ni bebley diman. Sinekup da humman ni bebley et degyunen daddan emin hu Amorite ni nambebley diman. ");
INSERT INTO ify_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Entanni et unuden da keltad et mampalaw idad Bashan. Hi Og e patul diman ni bebley ey impangulu tu sindalu tu et dadda gubaten ida helag Israel di Edrei. ");
INSERT INTO ify_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kan Apu Dios nan Moses ey “Entan takut mun hi-gatu, tep baddangan daka et apputem hi Og niyadda sindalu tu et sakupem bebley da. Ipahding mun hi-gatu hu henin impahding mu etan ni patul idan Amorite e hi Sihon e patul di Hesbon.” ");
INSERT INTO ify_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Nengapput ida tu-wangu hu helag Israel ni nanggugubatan da et pateyen da hi Og, yadda u-ungnga tu niyadda bimmebley. Endin hekey natdaan et sakupen da humman ni bebley da. ");
INSERT INTO ify_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nanglaw ida helag Israel et dumteng idad nandeklan di Moab e neihnup di Wangwang e Jordan e demang ni Jericho et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ya etan patul di Moab e hi Balak e u-ungngan Sippor ey dingngel tu hu impahding idan helag Israel idan Amorite. ");
INSERT INTO ify_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Inang-ang idan iMoab e dakel idan peteg hu helag Israel ey nemahhig takut ni patul da niyadda tutu-u. ");
INSERT INTO ify_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kan idan aap-apud Moab idan aap-apud Midian ey “Iyyaddalli dakel ni helag Israel. Nanna-ud ni bahbahen dan emin hu hipan wada eyad bebley tayu henin kapehding idan bakaddan helek e daka kenna emin!” Et impahding nan Balak e patul ni Moab, ");
INSERT INTO ify_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ey nenu-dak ni an mekihhummangan nan Balaam e u-ungngan Beor di Pethor e bebley ni neihnup di Wangwang e Euphrates. Heninnuy hu inhel Balak ni e-helen dan Balaam: “Immalidda dakel ni tutu-un nalpud Egypt ey nemahhig ni ida kamangkeihhinnap di kebebbebley eyad puyek et iyyaddadyan nambebley idad dagsin bebley mi. Et humman hu, nakka umkakaguh tep entanniy pilliwen da eya bebley mi. ");
INSERT INTO ify_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Endi kabaelak ni mekihhanggan hi-gada, et humman hu, ali ka anhan et idutam ida ma-lat apputen middad gubat et bumsik ida. Inamtak e kamebendisyonidda tuun muka bendisyoni, niya kameiddusidda muka iddusi.” ");
INSERT INTO ify_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Et lumaw ida etan opisyal ni intu-dak nan Balak e opisyal di Moab niyad Midian ni mekihhummangan nan Balaam. Ey nantabin idan pihhuh ni ibbayad dan hi-gatu ma-lat idutan tudda helag Israel. Dinteng da et ehelen da hu impaad nan Balak. ");
INSERT INTO ify_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ey kan Balaam ni hi-gada ey “Pandeya kayu et ngenamung hu peamtan Apu Dios ni ihhumang kun hi-gayu.” Et mandeyadda humman ni aap-apun iMoab ni intu-dak Balak. ");
INSERT INTO ify_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yan nunman ni hileng ey kan Apu Dios nan Balaam ey “Hipadda eya edum mu?” ");
INSERT INTO ify_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kan Balaam ey “Huyyadda intu-dak nan Balak e patul di Moab ni mengippeamtan hi-gak ");
INSERT INTO ify_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","e neihinap kunu dakel ni tuun nalpud Egypt. Et humman hu, pinhed nunman ni patul ni iddutak ida kunu humman ni tutu-u, ma-lat hedin gubbaten dadda ey apputen tudda et medegyun ida.” ");
INSERT INTO ify_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nem kan Apu Dios nan Balaam ey “Entan kaya pakilaw mun hi-gada niya entan tudda idusi hu helag Israel tep binendisyonan kudda.” ");
INSERT INTO ify_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Newa-wa et kan Balaam idan nunman ni tuu ey “Lakkayuy kuma tep eleg i-abulut Apu Dios ni mekillawwak ni hi-gayu.” ");
INSERT INTO ify_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Et mambangngad ida et ehelen dan Balak e eleg abuluten nan Balaam ni mekillaw ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Nem eleg mengmenghep hi Balak et menu-dak mewan ni daddakkel niya eta-ta-gey saad da nem yadda etan nemangulun intu-dak tu. ");
INSERT INTO ify_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Limmaw ida et kandan Balaam ey “Heninnuy hu kan Balak e u-ungngan Sippor: ‘Ali kan ali anhan ni memaddang ni hi-gami. ");
INSERT INTO ify_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Dakel ibbayad kun hi-gam niya pehding ku hu hipan ibbagam nemet umli ka et idutam ida huyyan tutu-u.’” ");
INSERT INTO ify_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nem kan Balaam ey “Anin na-mun iddawat Balak ni hi-gak hu baley tu e baley ni patul niya hipan wadadman, heniddan balituk niya pihhuh et eleg mabalin ni nak ngenghayen hu intugun Apu Dios e Dios kun hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nem anin ni hanniman et pandeya kayu, henin impahding idan nemangulun immali et amtaek hedin wada edum ni pinhed Apu Dios ni peamtan hi-gak.” ");
INSERT INTO ify_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Yan nunman ni hileng ey kan Apu Dios nan Balaam ey “Hedin ya inlian ida eyan tuu ma-lat daka ikuyug, ku anin, pandaddan ka et makilaw ka, nem ebuh e-helen kun hi-gam ipahding mu.” ");
INSERT INTO ify_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Newa-wa et mantakkay hi Balaam di kebayyu tu et makilaw ida etan ni aap-apud Moab. ");
INSERT INTO ify_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nem bimmunget hi Apu Dios ni nekilawwan Balaam, et kamenglaw e ingkuyug tudda dewwan bega-en tu ey limmaw etan anghel Apu Dios et maihenid dalan. ");
INSERT INTO ify_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Inang-ang etan ni kebayyun Balaam etan anghel ni immehneng e inta-gey tu ispadah tu et ihingngi tu nengidlanan tud payew, ey hineplit Balaam etan kebayyu et mambangngad di keltad. ");
INSERT INTO ify_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Entanni mewan ey an immehneng etan anghel di keltad ni nahkit e nambattanan ni dewwan leguntan neluhud ni batu. ");
INSERT INTO ify_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Inang-ang mewan etan ni kebayyu etan anghel ni immehneng ey impilit tun immusip etan di tuping ni luhud et meigandut hu helin Balaam tep neipit et hepliten mewan Balaam etan kebayyu. ");
INSERT INTO ify_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Entanni ey nandayyu mewan etan anghel di nahkit ni dalan e endi dammutun ussipan etan ni kebayyu. ");
INSERT INTO ify_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Inang-ang mewan etan ni kebayyu etan anghel ey limmukbub et pan-iheplit nan Balaam hu hulkud tun kebayyu tu tep ya bunget tu. ");
INSERT INTO ify_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Entanni ey impa-hel Apu Dios etan kebayyu e kantuy “Hipa nak impahding ni hi-gam et muwak hineplit ni nampitlu?” ");
INSERT INTO ify_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Hinumang Balaam e intekuk tu e kantuy “Tep impeang-ang mu e heni endi nemnem ku. Gullat ni wada ispadah ku et nanna-ud ni petteyen daka.” ");
INSERT INTO ify_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Immehel mewan etan kebayyu ey kantuy “Nem kaw beken ni hi-gak hu kebayyum ni nunman ingganah ni nunya? Kaw wada nengipahdingak ni hanneyan nunman ni hi-gam?” Kan Balaam ey “Endi!” ");
INSERT INTO ify_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Entanni ey heni dinyat nan Apu Dios hu matan Balaam et ang-angen tu etan anghel ni immehneng di dalan e inta-gey tu ispadah tu ey limmukbub hi Balaam di puyek di hinanggan nunman ni anghel. ");
INSERT INTO ify_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Et kan etan ni anghel ni hi-gatuy “Kele mu hineplit hu kebayyum ni nampitlu? Immali-ak et haniak hu dellanem tep muka ippilit ni umlaw tep muwak kangenghaya. ");
INSERT INTO ify_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Nampitlun inang-ang tuwak eyan kebayyum et idlan tud pangil. Gullat ni eleg tu idlan di pangil et pintey dakan hi-gak, nem ya kebayyum ey eggak petteya.” ");
INSERT INTO ify_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Kan Balaam ey “Nakka ebbuluta e nanliwattak. Eggak amta e immehneng kad dalan et hanian mu dellanek. Anin ni mambangngaddak hedin eleg mu pinhed ni umlawwak.” ");
INSERT INTO ify_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nem kan etan ni anghel Apu Dios ey “Dammutun mekillaw kaddan eyan aap-apun intu-dak Balak nem mahapul ni ebuh hu e-helen kun hi-gam ni e-helen mu.” Et makilaw hi Balaam idan opisyal nan Balak. ");
INSERT INTO ify_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Dingngel Balak e iyyallid Balaam ey tudda dinammud Ar e bebley di gilig ni Wangwang e Arnon di pappeg ni Moab. ");
INSERT INTO ify_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Kan Balak nan Balaam ni nandatengan day “Kele eleg ka umli etan ni laputun nengayagan daka? Kaw eleg mu kulugen hu kangkun et-eteng hu ibbayad kun hi-gam?” ");
INSERT INTO ify_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Kan Balaam ey “Immali-ak nem endi kabaelan kun menghel ni anin hipa. Ebuh hu e-helen Apu Dios ni dammutun e-helek.” ");
INSERT INTO ify_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Et makilaw hi Balaam nan Balak di Kiriat Husot. ");
INSERT INTO ify_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nan-appit hi Balak ni babakka ey kakalneroh et idwatan tu hi Balaam niyadda aap-apun nekilaw ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Newa-wa et ipengulun Balak hi Balaam di Bamot Baal e kameuhdungidda edum ni helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Kan Balaam nan Balak e patul ey “Ikapyai muwak ni pitun pan-appitan di deya niya idaddan mu hu pitun kilaw ni lakkitun baka niya pitun lakkitun kalneroh ni kamei-appit.” ");
INSERT INTO ify_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Inu-unnud Balak humman ni inhel Balaam et iappit tu hu hanhakkey ni kilaw ni lakkitun baka niya hanhakkey ni lakkitun kalneroh etan idad kinapya tun pan-appitan. ");
INSERT INTO ify_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kan mewan nan Balaam nan Balak ey “Ehneng kad kad-an eyaddan in-appit mun kagihheba et uma-allawwak et ang-angek hedin hummangen tuwak nan Apu Dios. Hannak ali ehelan hi-gam hedin hipa peamta tun hi-gak.” Et hakey hi Balaam ni limmaw di ta-pew ni duntug ");
INSERT INTO ify_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","et dammuen Apu Dios diman. Kan Balaam ni hi-gatuy “Nengapya-ak ni pitun pan-appitan et man-appittak idadman ni hanhakkey ni lakkitun baka ey kalneroh.” ");
INSERT INTO ify_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Inhel Apu Dios nan Balaam hu pinhed tun e-helen nan Balak et kantun Balaam ey “Lakkay di kad-an Balak et ehelem hu inhel kun hi-gam.” ");
INSERT INTO ify_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Nambangngad hi Balaam ey immen pay hi Balak e kaman-eh-ehneng di kad-an idan neiappit ni kagihheba e hi-gadaddan emin etan idan aap-apun iMoab. ");
INSERT INTO ify_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Immehel hi Balaam et kantuy “Tuwak impaeyag nan Balak e patul di Moab di bebley kud duntug di appit ni kasimmilin aggew di Aram, et idutak ida kunu helag Israel e e-helek hu lawah ni meippahding ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nem hipa nak pengiddutan idan eleg idutan Apu Dios? Hipa nak penghelan ni lawah ni meippahding hedin endi inhel Apu Dios? ");
INSERT INTO ify_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Immehnengngak di ta-pew ni duntug et ang-angek ey dakel ida nem neappil ida e beken idan henin edum ni tutu-u. ");
INSERT INTO ify_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Dakel idan peteg hu helag Israel e henidda dep-ul, e eleg ida mebillang. Pinhed kun melinggep hu ketteyyak et heni-ak idan nunman ni tuun Apu Dios e neibilang idan kayyaggud.” ");
INSERT INTO ify_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kan Balak nan Balaam ey “Kele kangkuy iddutam ida humman ni buhul ku ey binendisyonam ida kumedek?” ");
INSERT INTO ify_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Hinumang Balaam e kantuy “Em, tep ebuh hu kae-helan Apu Dios ni dammutun e-helek.” ");
INSERT INTO ify_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Entanni et kan Balak nan Balaam ey “Ikay et lumaw itad eman di a-allaw tu e kameang-ang hu edum idan helag Israel et mudda idutan tep humman pinhed kun pehding mu.” ");
INSERT INTO ify_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Impangulu tu hi Balaam di Sophim e ta-pew ni Duntug e Pisgah. Kinapya tu mewan hu pitun pan-appitan diman et man-appit ni hanhakkey ni bulug ni baka niya hanhakkey ni lakkitun kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Et kan mewan Balaam nan Balak ey “Ehneng ka eyad kad-an ni in-appit mun kagihheba et nak dammuen hi Apu Dios.” ");
INSERT INTO ify_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Et an dammuen nan Apu Dios hi Balaam et ehelen tu hu e-helen Balaam nan Balak. ");
INSERT INTO ify_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Nambangngad hi Balaam di kad-an Balak et yadda edum tun ap-apud Moab ey ida kaman-eh-ehneng di kad-an ni in-appit dan megihheb. Ihik hi Balak ni mengamta et kantuy “Hipa inhel Apu Dios?” ");
INSERT INTO ify_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kan Balaam ey “Dengel mu e Balak e u-ungngan Sippor huyyan e-helek. ");
INSERT INTO ify_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Hi Apu Dios man beken ni henin tuu e kaman-ittek winu kamangkekyat. Tep hedin hi-gatu man tuka pehding ni emin hu tuka e-hela. Hedin inhel tu man kameippahding. ");
INSERT INTO ify_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Neimandal ni hi-gak e bendisyonak ida hu nebendisyonan. Hedin binendisyonan Apu Dios ey eleg mabalin ni nak kekyaten. ");
INSERT INTO ify_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Endi an meippahding ni lawah idan helag Israel niya endi hu hipan ligat ni um-alin hi-gada tep wada Ap-Apu e Dios dan memaddang ni hi-gada. Hi-gatu hu pinili dan patul da. ");
INSERT INTO ify_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Hi Apu Dios hu an nengawit ni hi-gadad Egypt. Hi-gatu hu kamei-ellig ni ma-lem ni bulug ni bakan neka-let ni ihhangga da. ");
INSERT INTO ify_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Endi kabaelan ni idut winu ayak idan helag Israel. Et heninnuy hu e-helen idallin tutu-u meippanggep ni hi-gada: ‘Ang-ang yu hu impahding Apu Dios idan helag Israel!’ ");
INSERT INTO ify_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ida kamei-ellig hu helag Israel di layon e neka-let e eleg man-iyyatu ingganah pamba-nuten tu dimpap tun kennen tu niya ingganah innumen tu kuheyaw ni pintey tu.” ");
INSERT INTO ify_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Entanni ey kan Balak nan Balaam ey “Hedin eleg mudda iddusi, ey entan tudda ew mewan bendisyoni.” ");
INSERT INTO ify_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nem kan Balaam ey “Kaw eggak ehelen ni hi-gam e pehding kun ebuh hu e-helen Apu Dios ni hi-gak?” ");
INSERT INTO ify_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kan Balak ey “Pakilaw kan hi-gak et ilaw daka etan di hakey ni bebley et ilah tu ey dammutun i-abulut Apu Dios ni iddutam idadman.” ");
INSERT INTO ify_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Et ilaw tu hi Balaam di tuktuk ni Duntug e Peor e kameuhdungi hu eleg mebebleyi. ");
INSERT INTO ify_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Kan Balaam ni hi-gatuy “Ikapyai muwak ni pitun pan-appitan di deya niya i-lim hu pitun bulug ni baka niya pitun lakkitun kalneroh ni mei-appit.” ");
INSERT INTO ify_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Inu-unnud Balak et man-appit ni hanhakkey ni bulug ni baka niya hanhakkey ni lakkitun kalneroh etan idad pitun pan-appitan. ");
INSERT INTO ify_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Yan nunman ey inamta law Balaam e hedin ya pinhed Apu Dios ni pehding tu ey bendisyonan tudda helag Israel, et eleg tu law ipahding hu anap ma-lat pengamtaan tun pinhed Apu Dios ni pehding tu, e humman imminghan tuka ippenahding. Nanligguh et iang-ang tud eleg mebebleyi ");
INSERT INTO ify_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ey inang-ang tudda helag Israel ni nangkampu e neena-appil ida meippuun di nahlagan da. Entanniy immali Ispirituh Apu Dios ni hi-gatu ");
INSERT INTO ify_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","et kantuy “Hi-gak e hi Balaam e u-ungngan Beor e matneng nakka penang-ang, ");
INSERT INTO ify_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ey nakka deddengngela ehel Apu Dios e Keta-ta-geyyan ey nakka ang-ang-anga hu peang-ang tun hi-gak: ");
INSERT INTO ify_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‘Kakkayyaggud ni peteg hu kampuddan helag Jacob, kakkayyaggud hu baballey da. ");
INSERT INTO ify_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Heniddan netu-tu-nud ni palmah, ey henidda garden di gilig ni wangwang, heniddan kapampebanglun kennen ni intanem Apu Dios, niya heniddan sedar di gilig ni lebeng. ");
INSERT INTO ify_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Dakel ali danum da et anin idan ittanem da et eleg mekullangin danum. Ya patul da ey et-etteng ali kabaelan tu nem hi Agag. Sekkupen tulli dakel ni bebley. ");
INSERT INTO ify_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ingkuyug idan Apu Dios ni neni-yanan dan Egypt ey neka-let ida e henidda ma-lem ni bulug ni baka. Daka paka-apputa kamekibbuhhul ni hi-gada e daka panhepunga genit da niya dadda kapampanaa. ");
INSERT INTO ify_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Henidda layon ni kamanhehhegged ni dedpapen tu. Henidda mewan etan ni labah ni layon e endi netuled ni an memengngun ni hi-gatu! Emin hu memendisyon ni Israel ey mebendisyonan. Nem meiddutan etan tuun mengiddut ni hi-gada.’” ");
INSERT INTO ify_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nemahhig hu bunget Balak nan Balaam e ginemgem tu ngamay tun bunget tu et itkuk tu e kantuy “Ineyagan daka ma-lat idutam ida buhul ku ey binendisyonam ida kumedek ni nampitlu! ");
INSERT INTO ify_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Pampenga-allaw kadya! Anemut kad bebley yu! Inhel ku e et-eteng penangdan kun hi-gam nem eleg iebulut nan Apu Dios ni ellam humman.” ");
INSERT INTO ify_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Himmumang hi Balaam ey kantuy “Tam inhel ku dedan lan etan idan intu-dak mun mengeyyag ni hi-gak ");
INSERT INTO ify_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","e anin na-mun iddawat mun hi-gak ni emin hu silber niya balituk di baley mu et eleg mabalin ni nak ngenghayen hi Apu Dios et nak ipahding hu pinhed ku. Niya inhel ku dedan ni hi-gam e ebuh hu e-helen Apu Dios ni dammutun e-helek. ");
INSERT INTO ify_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Mambangngaddak law di bebley mi nem e-helek nin hi-gam hu ippahding idallin helag Israel idan tuum ni edum ni aggew.” ");
INSERT INTO ify_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Heninnuy inhel Balaam: “Hi-gak e hi Balaam e u-ungngan Beor e matneng nakka penang-ang ");
INSERT INTO ify_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ey nakka deddengngela hu ehel Apu Dios e Keta-ta-geyyan ey nakka ang-ang-anga hu impeang-ang tun hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nakka ang-ang-anga e yallin edum ni aggew ey meweddallid helag Israel hu hakey ni patul ni kamei-ellig di makaddilag ni bittuwen. Panggegmiken tulli uluddan iMoab niyadda bimmebley di Seth. ");
INSERT INTO ify_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Apputen tulli buhul tud Edom niyad Seir et sakupen tu bebley da. Ey meweddalli et-eteng ni kabaelan idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Humman alin ap-apun melpud helag Israel ey endien tuddalli hu metdaan ni mategu.” ");
INSERT INTO ify_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","In-uhdung nan Balaam mewan idan iAmalek et heninnuy impeamta tun meippahding alin hi-gada: “Ma-nu tep ya Amalek hu kee-ettengan kabaelan tud emin ni bebley nem mebahbah ali et meendin ingganah.” ");
INSERT INTO ify_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","In-uhdung tu damaddan iKenite et kantuy “Ma-nut melinggep kayud bebley yun heni buyad ta-pew ni mabetu, ");
INSERT INTO ify_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","nem mebahbah kayullin ellian idan iAssyria et alan dakeyu et mambalin kayun balud di bebley da.” ");
INSERT INTO ify_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Heninnuy mewan hu inhel Balaam: “Hipa mannenneng ni mategu hedin pehding Apu Dios hu hanneya? ");
INSERT INTO ify_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Um-aliddalli bapor ni melpud gilig ni baybay di Cyprus. Panhelheltap dalli iAssyria niyadda iEber, nem anin ni hi-gada et mekabbahbah idalli.” ");
INSERT INTO ify_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Negibbuh ni inhel Balaam ida huyya et umenamut di bebley da ey immanemut dama hi Balak. ");
INSERT INTO ify_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Yan nangkampuan idan helag Israel di Akasia ey in-ulig idan edum ni lalakki da hu bibi-in iMoab. ");
INSERT INTO ify_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Et ayagan idan nunman ni bibi-in iMoab ida humman ni lalakkid daka pan-appisin dios dad Moab. Entanni ey nekihemul ida et lektattuy dinaydayaw da law ida dios di Moab. ");
INSERT INTO ify_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ey neki-dum idan nenaydayaw nan Baal di Peor. Et nemahhig bunget Apu Dios idan tuu tu tep ya huyyan neipahding. ");
INSERT INTO ify_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kantun Moses ey “Ayagim idan emin hu nengipappangngulun nengipahding nunman et papetey muddad hinanggaddan helag Israel ma-lat ma-kal hu bunget kun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Et iolden Moses idan huwet ni Israel e kantuy “Ang-ang yun emin hu tuu yun kamandaydayaw nan Baal di Peor et papetey yudda.” ");
INSERT INTO ify_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Entanni ey wada hu hakey ni helag Israel ni nengihgep ni hakey ni biin iMidian di kampu tu e neka-ang-ang nan Moses niyadda etan neamung ni kamannengngih di heggeppan ni Tabernacle. ");
INSERT INTO ify_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Hi Pinehas e padin u-ungngan Eleasar e inap-apun Aaron ey inang-ang tu dama et tu alen pahul tu ");
INSERT INTO ify_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","et unuden tu etan lakid kampu tu. Himmegep et iba-wek tu pahul tu etan ni laki et mailegat pay etan biin nesibik. Humman nesikedan ni degeh ni neihinap idan helag Israel ");
INSERT INTO ify_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","nem neil-uh ni netey ida dewampulut epat ni libun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Entanniy kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Na-kal law bunget kuddan helag Israel tep ya humman ni impahding Pinehas. Ka-ang-ang e eleg tun hekey pinhed ni wada edum ni dios ni daydayawen da, et humman hu, eggak law ittuluy hu planuh kun memahbah ni hi-gadan emin tep ya bunget ku. ");
INSERT INTO ify_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Et humman hu, ehel mun Pinehas e issapatah ku e wadallin ingganah hu linggep tu. ");
INSERT INTO ify_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Hi-gatu niyadda helag tu hu mannenneng ni mampeddin ingganah, tep eleg tu iebulut ni wada edum ni dios daydayawen idan edum tun helag Israel, et humman hu, nepesinsahan hu liwat idan helag Israel tep ya impahding tu.” ");
INSERT INTO ify_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ya ngadan etan ni lakin helag Israel ni netey e kadwa etan ni biin iMidian ey hi Simri e u-ungngan Salu e nahlag nan Simeon. ");
INSERT INTO ify_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ya ngadan etan ni bii ey hi Kosbi e u-ungngan Sur e hakey ni kamengipappangnguluddan Midian. ");
INSERT INTO ify_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Gubat yudda iMidian et bahbahen yudda ");
INSERT INTO ify_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","tep lawah impahding da e hineul dakeyu et dayawen yu hi Baal di Peor niya gapuh etan ni u-ungngan kamengipappangnguluddan iMidian e hi Kosbi e pintey Pinehas ni nunman ni aggew ni neihinapan ni degeh di Peor.” ");
INSERT INTO ify_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ya eman ni nesiked hu degeh idan helag Israel e humman kastigu da ey kan Apu Dios nan Moses et hi Eleasar e u-ungngan Aaron ey ");
INSERT INTO ify_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Bilang yudda mewan hu lalakkin dewampulu toon tu winu nehuluk et meamta hedin pigad hakey ni pamilyah hu dammutun mansindalu.” ");
INSERT INTO ify_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Yan nunman ni tsimpuh ey nangkampudda helag Israel di nandeklan di Moab di gilig ni Wangwang e Jordan e demang ni Jericho. Inu-unnud nan Moses et hi Eleasar e padi humman et iolden daddan aap-apun helag Israel hu pehding dan memillang idan lalakki. ");
INSERT INTO ify_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Kanday “Bilang yuddan emin hu lalakkin helag Israel ni dewampulu toon tu winu nehuluk meippuun di in-olden Apu Dios ni meippahding.” Huyyadda hu helag Israel ni neni-yan ni Egypt: ");
INSERT INTO ify_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Huyyadda nahlag nan Reuben e pengulwan ni u-ungngan Jacob e Israel hu hakey ni ngadan tu: yadda helag Hanok, yadda helag Pallu, ");
INSERT INTO ify_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","yadda helag Hesron, niyadda helag Karmi. ");
INSERT INTO ify_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ya bilang emin ni lalakkin helag Reuben ey 43,730. ");
INSERT INTO ify_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Hi Pallu hu nahlagan nan Eliab ");
INSERT INTO ify_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","e aman Nemuel, hi Dathan et hi Abiram. Di Datham nan Abiram hu nengipappangngulu lan nunman ni nekibaddang nan Korah ni nangngehay di Moses nan Aaron et hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nem nadhak puyek et mangke-hung idad dallem tu anin hi Korah niyadda etan dewanggatut et neliman neki-dum ni hi-gadan pintey ni apuy. Humman ni neipahding ni hi-gada hu pengi-ang-angan ni edum ni tuu ma-lat tumekut idan mengippahding ni impahding da. ");
INSERT INTO ify_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Nem eleg ida matey hu u-ungngan Korah ni nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Huyyadda nahlag ni u-ungngan Simeon: yadda helag Nemuel, yadda helag Jamine, yadda helag Jakin, ");
INSERT INTO ify_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","yadda helag Serah niyadda helag Saul. ");
INSERT INTO ify_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ya bilang idan emin ni lalakkin helag Simeon ey 22,200. ");
INSERT INTO ify_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Huyyadda nahlag nan Gad: yadda helag Sephon, yadda helag Haggi, yadda helag Suni, ");
INSERT INTO ify_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","yadda helag Osni, yadda helag Eri, ");
INSERT INTO ify_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","yadda helag Arodi niyadda helag Areli. ");
INSERT INTO ify_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ya bilang ni emin ni lalakkin helag Gad ey 40,500. ");
INSERT INTO ify_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Di Er nan Onan e u-ungngan Judah ey netey idad Kanaan. ");
INSERT INTO ify_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yadda nahlag nan Judah ey yadda helag Sela, yadda helag Peres, niyadda helag Serah. ");
INSERT INTO ify_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Yadda nahlag nan Peres ey yadda helag Hesron, niyadda helag Hamul. ");
INSERT INTO ify_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ya bilang idan emin ni lalakkin helag Judah ey 76,500. ");
INSERT INTO ify_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Huyyadda nahlag nan Issakar: yadda helag Tola, yadda helag Puah, ");
INSERT INTO ify_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","yadda helag Jashub niyadda helag Simron. ");
INSERT INTO ify_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ya bilang emin idan lalakkin helag Issakar ey 64,300. ");
INSERT INTO ify_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Huyyadda nahlag nan Sebulun: yadda helag Sered, yadda helag Elon niyadda helag Jahleel, ");
INSERT INTO ify_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ya bilang idan emin ni lalakkin helag Sebulun ey 60,500. ");
INSERT INTO ify_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Huyyadda nahlag nan Joseph: yadda helag di Manasseh nan Epraim. ");
INSERT INTO ify_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Huyyadda nahlag nan Manasseh: yadda helag Makir, niyadda helag Gilead. (Hi Gilead hu u-ungngan Makir.) ");
INSERT INTO ify_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Yadda nahlag nan Gilead: yadda helag Jesser, yadda helag Helek, ");
INSERT INTO ify_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","yadda helag Asreil, yadda helag Sekem, ");
INSERT INTO ify_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","yadda helag Semida niyadda helag Hepher. ");
INSERT INTO ify_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Hi Selophehad e u-ungngan Hepher ey endi lakin u-ungnga tu, bibi-in emin u-ungnga tu e hi Mahlah, hi Noah, hi Hoglah, hi Milkah et hi Tirsah.) ");
INSERT INTO ify_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ya bilang idan emin ni lalakkin helag Manasseh ey 52,700. ");
INSERT INTO ify_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Huyyadda nahlag nan Epraim: yadda helag Suthelah, yadda helag Beker niyadda helag Tahan. ");
INSERT INTO ify_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Yadda nahlag nan hi Suthelah ey yadda helag Eran. ");
INSERT INTO ify_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ya bilang ni emin idan lalakkin helag Epraim ey 32,500. ");
INSERT INTO ify_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Huyyadda nahlag nan Benjamin: yadda helag Belah, yadda helag Asbel, yadda helag Ahiram, ");
INSERT INTO ify_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","yadda helag Supham niyadda helag Hupham. ");
INSERT INTO ify_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Yadda nahlag nan Belah: yadda helag Ard niyadda helag Naaman. ");
INSERT INTO ify_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ya bilang idan emin ni lalakkin helag Benjamin ey 45,600. ");
INSERT INTO ify_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","Yadda nahlag nan Dan: yadda helag Suham. Ya bilang ni emin idan lalakkin helag Dan ey 64,400. ");
INSERT INTO ify_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Huyyadda nahlag nan Asher: yadda helag Immah, yadda helag Isbi niyadda helag Beriah. ");
INSERT INTO ify_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Yadda nahlag nan Beriah: yadda helag Heber niyadda helag Malkiel. ");
INSERT INTO ify_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Hi Asher ey wada u-ungnga tun biin hi Serah.) ");
INSERT INTO ify_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ya bilang emin idan lalakkin helag Asher ey 53,400. ");
INSERT INTO ify_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Huyyadda nahlag nan Naptali: yadda helag Jahseel, yadda helag Guni, ");
INSERT INTO ify_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","yadda helag Jesher niyadda helag Sillem. ");
INSERT INTO ify_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ya bilang ni emin idan lalakkin helag Naptali ey 45,400. ");
INSERT INTO ify_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Et ya bilang ni emin ni lalakkin helag Israel ni neilista ey 601,730. ");
INSERT INTO ify_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Genedwam eya puyek meippuun ni kedakkel idan helag Israel et ika-peng mun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Idwat mu melallakkeb ni puyek idan daddakkel helag da ey idwat mu nehehhekkit idad hahhakkey helag da. Meang-ang hu kedakkel ni hakey ni pewen di kelakkeb ni puyek ni meidwat ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ang-ang mu et binnunut hu pehding mun mengikka-peng ni puyek niya meippuun etan di neitudek ni bilang idan helag ni u-ungngan Israel. ");
INSERT INTO ify_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Mahapul ni binnunut hu pehding mun mengikka-peng ni puyek et hedin daddakkel idad hakey ni pewen ey ya mahmahkang hu meidwat ni hi-gada, hedin hahhakkey idad pewen da ey ya nehehhekkit hu meidwat ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Huyyadda nahlag nan Levi: yadda helag Gerson, yadda helag Kohat niyadda helag Merari. ");
INSERT INTO ify_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Huyyadda edum ni nahlag nan Levi: yadda helag Libni, yadda helag Hebron, yadda helag Mahli, yadda helag Mushi niyadda helag Korah. Hi Kohat hu aman Amram ");
INSERT INTO ify_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","e nengiahwan Jokebed. Hi Jokebed e neiungngad Egypt ey nahlag metlaing nan Levi. Nan-ungngad Amram nan Jokebed et di Aaron nan Moses, et hi Miriam e biin agi da. ");
INSERT INTO ify_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Epat ni lalakki u-ungngan Aaron: hi Nadab, hi Abihu, hi Eleasar et hi Ithamar. ");
INSERT INTO ify_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nem netey di Nadab nan Abihu eman ni nan-appitan dan Apu Dios e eleg da u-unnuden hu inhel tun pehding ni mengihheb ni insensoh. ");
INSERT INTO ify_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ya bilang idan lalakkin nahlag nan Levi ni hambulan tu winu nehuluk ey 23,000. Neappil ngu listaan ni bilang da tep eleg ida meidwasin beltanen dan puyek di Israel. ");
INSERT INTO ify_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Huyyadda binilang di Moses nan Eleasar eman ni nemilangan dan emin ni helag Israel etan di nandeklan di Moab di gilig ni Wangwang e Jordan e demang ni Jericho. ");
INSERT INTO ify_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Endi anin hakey idan nunya hu nekibilang eman ni nemangulun nambilangan Moses idan helag Israel ni kaweda dad Sinai e eleg mebebleyi. Emin ida hu nebilang ni nunman ey endin hi-gada natdaan ni mategu, netey idan emin. ");
INSERT INTO ify_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Inhel dedan Apu Dios ni nunman e mettey idan emin etan di eleg mebebleyi. Nem ebuh di Kaleb e u-ungngan Jepunneh et hi Joshua e u-ungngan Nun ni natdaan ni eleg matey. ");
INSERT INTO ify_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","4","Hakey ni aggew ey limmaw ida hu bibi-in u-ungngan Selophehad e hi Mahlah, hi Noah, hi Hoglah, hi Milkah et hi Tirsah di heggeppan ni Tabernacle di kad-an di Moses, hi Eleasar e padi, yadda kamengipappangngulu niyadda edum dan bimmebley et kanday “Netey hi amemi di eleg mebebleyi ey endi helag tun laki. Netey tep ya liwat tu, e beken ni ya neki-duman tun Korah ni nangngehayan dan Apu Dios hu himmulun. Et humman hu, kele an metellak ngadan amemi tep ya keendin u-ungnga tun laki? Idwasi dakemi kuma anhan ni puyek ni indawat yuddan aaggin amemi.” Hedin hi Selophehad man u-ungngan Hepher e u-ungngan Gilead e u-ungngan Makir e u-ungngan Manasseh e u-ungngan Joseph. ");
INSERT INTO ify_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Nekihummangan hi Moses nan Apu Dios meippanggep ni nunman ");
INSERT INTO ify_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ey kan Apu Dios ni hi-gatuy ");
INSERT INTO ify_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Neiptek ida numan hu u-ungngan Selophehad. Idwasim idan puyek ni henin neidwat idan aaggin ameda. Itudum ni hi-gada hu lebbeng tun beltanen ameda. ");
INSERT INTO ify_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ehel muddan helag Israel e hedin netey hu hakey ni laki ey endi u-ungnga tun laki ey mahapul ni meidwat hu beltanen tuddad bibi-in u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Hedin endin hekey u-ungnga tu ey meidwat hu beltanen tun lakin agitu. ");
INSERT INTO ify_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Hedin endi lakin agi tu ey meidwat hu beltanen tun lakin agin ametu. ");
INSERT INTO ify_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Hedin endi lalakkin agin ametu ey meidwat hu beltanen tuddan kumpulmih ni neka-ihnup ni aaggi tu. Mahapul ni u-unnuden idan helag Israel huyyan Tugun ni indawat kun hi-gam e Moses.” ");
INSERT INTO ify_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Hakey ni aggew ey kan Apu Dios nan Moses ey “Panteyed kad ta-pew ni Duntug e Abarim di appit ni kasimmilin aggew, et ang-angen mu hu bebley ni iddawat kuddan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Hedin negibbuh ni inang-ang mu ey mettey ka e henin nan agim hi Aaron. ");
INSERT INTO ify_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Tep nginhay yu dama hu tugun ku eman ni nanlilihan idan tuun hi-gak di Meribah di eleg mebebleyid Sin, tep eleg mu peang-ang ni hi-gada hu et-eteng ni kabaelan ku.” (Hedin ya Meribah ey humman hu hebwak di Kades.) ");
INSERT INTO ify_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Nandasal hi Moses nan Apu Dios e kantuy ");
INSERT INTO ify_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Apu Dios e Dios ni kakelpuin biyag ni emin ni mategu, putuk ka anhan ni hakey ni kabaelan tun mengippengnguludda eyan tuum. ");
INSERT INTO ify_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Em, putuk ka anhan ni mengippengngulun hi-gadan mekiggubbat et beken idan heni kalneroh ni endi mampattul ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kan Apu Dios nan Moses ey “Hi Joshua e u-ungngan Nun hu wada kabaelan tun mengipappangnguluddan tuu. Ayagim et ita-pew mu ngamay mud ulu tu. ");
INSERT INTO ify_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Peehneng mud hinanggan Eleasar e padi niyad emin idad edum yun helag Israel et ehelen mun hi-gada e hi-gatu meihhullul ni hi-gam ni mengippengngulun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Pebeltan mun hi-gatu kabaelam et mengu-unnud idan emin hu helag Israel ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Hedin wada pinhed dan ibbagan hi-gak ey um-ehneng hi Joshua di hinanggan Eleasar e padi et amtaen tu hedin hipa inhumang ku meippuun ni binnunut e ussalen da Urim niya Thummim. Henin nunya pengamtaan nan Eleasar ni e-helen tun Joshua niyadda etan tuu hedin hipa pinhed kun pehding da.” ");
INSERT INTO ify_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Inu-unnud Moses huyyan intugun Apu Dios et peehneng tu hi Joshua di hinanggan Eleasar e padi niyaddad emin etan ni tuu, ");
INSERT INTO ify_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Et ita-pew tu hu ngamay tud ulun Joshua et ehelen tu e hi-gatu meihhullul ni mengippengnguluddan helag Israel meippuun di tugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Inhel mewan Apu Dios nan Moses ");
INSERT INTO ify_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","e ittugun tuddan helag Israel huyya e kantuy “Mahapul ni peang-ang yun hi-gak di nagtud ni tsimpuh etan ida kamengippeamleng ni kennen ni kagihheba. ");
INSERT INTO ify_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ya i-appit yun kagihheban kennen ni kewa-wa-wa ey dewwan hantoon tun lakkitun kalneroh ni endi dipektoh tu. ");
INSERT INTO ify_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","I-appit yu hu hakey ni kakkabbuhhan ey hakey mewan ni kamangkehilleng. ");
INSERT INTO ify_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","7","Unnudi yun kamei-appit ni begah e ngannganih ni hangkiloh ni alinah ni nekamdugan ni hakey ni litroh ni mansikan olibah. Unnudi yu pay ni kamei-appit ni meinnum ni hakey ni litroh. Giheb yudda huyya et iappit yun hi-gak ni kewa-wa-wa ma-lat umamlengngak ni hamuy tu. Huyyan pehding yu ey neitugun dedan ni nunman di Duntug e Sinai. ");
INSERT INTO ify_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Hanneya ipahding yun kakkabbuhhan niyan kamangkehilleng. Huyyan i-appit yun kennen ni kagihheba ey mengippeamleng ni hi-gak hamuy tu. ");
INSERT INTO ify_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Yan Sabaduh e kamengillin ni aggew ey iappit yu dewwan hantoon dan lakkitun kalneroh ni endi dipektoh da, ya ngannganih ni dewwan kiloh ni alinah ni nekamdugan ni mansikan olibah niya kamei-appit ni meinnum. ");
INSERT INTO ify_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Meikkahhakey ni gihheben yudda huyyan i-appit yu e mei-dum di i-appit yun kewa-wa-wan meunnudan ni meinnum. ");
INSERT INTO ify_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Peang-ang yu hu kagihheban i-appit yun hi-gak e Dios ni memengngulun aggew ni kabulabulan e ya dewwan kilaw ni lakkitun baka, hakey ni lakkitun kalneroh niya pitun hantoon dan lakkitun kalneroh. Mahapul ni emin ida huyyan animal ey endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Unnudi yu etan hakey ni lakkitun bakan kamei-appit ni begah e umlaw di tellun kiloh ni alinah ni nekamdugan ni mansikan olibah, dewwan kiloh etan di lakkitun kalneroh ");
INSERT INTO ify_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","niya hanhakkey ni kiloh etan idad hantoon tun lakkitun impah ni kalneroh. Huyyan kamei-appit ni kagihheba niya kamei-appit ni kennen ey mengippeamleng ni hi-gak hu hamuy tu. ");
INSERT INTO ify_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Mahapul mewan ni um-iappit kayun meinnum ni dewwan litroh ni unnud ni hakey ni baka, hakey et kagedwah ni litroh ni unnud ni lakkitun kalneroh, niya hakey ni litroh ni unnud ni lakkitun impah ni kalneroh. Huyyadda kamei-appit ni memengngulun aggew ni kabulabulan. ");
INSERT INTO ify_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ey iappit yu hakey ni gelding ni kamei-appit ni liwat e i-e-dum yu etan di i-appit yun kewa-wa-wa e unnudi yun kamei-appit ni meinnum. ");
INSERT INTO ify_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Yan meikkahampulut epat ni aggew ni memengngulun bulan hu pengippahdingan yun piyestah ni penginemnemneman yun Nelabahan ni Anghel Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Yan meikkahampulut liman aggew hu keilleppuan ni pitun aggew ni piyestah yun eleg kayu mengan ni sinapay ni nekamdugan ni kamampelbag. ");
INSERT INTO ify_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Yan memengngulun aggew nunman ni piyestah yu ey meemmung kayu et mandaydayaw kayun eleg kayu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Man-appit kayun kagihheba et humman kennen ni i-appit yun Apu Dios. I-appit yudda hu dewwan kilaw ni lakkitun baka, ya hakey ni lakkitun kalneroh, niya pitun hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Hanhakkey ida huyya niya meunnudan ni kamei-appit ni begah e humman hu alinah ni nekamdugan ni mansikan olibah. Ya hakey ni baka ey meunnudan ni dewwa et kagedwah ni kilo, ya hakey et kagedwah ni kiloh di hakey ni lakkitun kalneroh, ");
INSERT INTO ify_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ey hangkiloh di hakey ni pakeetteng tun lakkitun kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ey man-appit kayun lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. ");
INSERT INTO ify_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Peang-ang yun emin ida huyyan i-appit yun kagihheba e mei-dum di i-appit yun kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Humman nisi pehding yun kewa-wa-wan pitun aggew ni piyestah ey man-appit kayun hi-gak ni kennen e giheb yu et umamlengngak ni hamuy tu. Hin-appil nisi ngu dedan etan ida i-appit yun kagihheba niya i-appit yun meinnum. ");
INSERT INTO ify_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Yan meikkeppitun aggew ey meemmung kayu mewan et mandayaw kayun hi-gak e eleg kayu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Yan memengngulu mewan ni aggew ni Piyestah ni Ani ey meemmung kayu et mandayaw kayun hi-gak e eleg kayu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Man-appit kayun kagihheba et umamlengngak ni hamuy tu. Huyyadda i-appit yu: dewwan kilaw ni lakkitun baka, hakey ni lakkitun kalneroh niya pitun hantoon tun lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","29","Man-appit kayu pay ni begah e iappit yu hu alinah ni nekamdugan ni mansikan olibah. Ya hakey ni baka ey meunnudan ni ngannganih ni tellun kiloh ni alinah, ya ngannganih ni dewwan kiloh ni alinah di hakey ni lakkitun kalneroh ey ya hangkiloh ni alinah di hakey ni hantoon tun lakkitun kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Man-appit kayu pay ni hakey ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Humman ni pan-appitan yu hu pengippahdingan yun elaw ni panlinnih yun tuu. ");
INSERT INTO ify_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Humman idan i-appit yun kagihheba ey unnudi yun kamei-appit ni meinnum e hin-appil ngu dedan etan i-appit yun kagihheba niya begah ni kewa-wa-wa. Mahapul ni emin ida i-appit yun animal ey endi hu dipektoh da.” ");
INSERT INTO ify_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Meemmung kayu mewan emin et mandayaw kayun hi-gak ni memengngulun aggew ni meikkeppitun bulan. Entan pangngunu yun nunman ni aggew, nem patnul yu tangguyub yu, ");
INSERT INTO ify_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","niya man-appit kayun hi-gak ni kagihheba, ma-lat umamlengngak ni hamuy tu. Huyyadda i-appit yu: hakey ni lakkitun baka, hakey ni lakkitun kalneroh niya pitun hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Wada hakey idan nunyan animal ey meunnudan idan kamei-appit ni begah e humman hu alinah ni nekamdugan ni mansikan olibah. Ya hakey ni baka ey meunnudan ni ngannganih ni tellun kiloh ni alinah, ngannganih ni dewwan kiloh hu mei-unnud di hakey ni lakkitun kalneroh ");
INSERT INTO ify_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","niya hangkiloh mei-unnud di hakey ni hantoon tun lakkitun kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Man-appit kayu pay ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. ");
INSERT INTO ify_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Hin-appil ngu dedan hu i-appit yun kagihheba e meunnudan ni kamei-appit ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. Huyyaddan i-appit yun kagihheba ey mengippeamleng ni hi-gak hu hamuy tu. ");
INSERT INTO ify_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Meemmung kayun mandaydayaw ni hi-gak ni meikkeppulun aggew ni meikkeppitun bulan. Mantetpel kayu e eleg kayu mengngan niya eleg kayu mangngunnu. ");
INSERT INTO ify_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Man-appit kayun hi-gak ni kagihheba ma-lat umamlengngak ni hamuy tu. Yadda huyya i-appit yu: hakey ni kilaw ni lakkitun baka, ya hakey ni lakkitun kalneroh niya pitun hantoon dan lakkitun kalneroh. Ey mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ya hanhakkey idan nunman ey meunnudan ni kamei-appit ni pagey e humman hu alinah ni nekamdugan ni mansikan olibah. Ya etan hakey ni baka ey meunnudan ni ngannganih ni tellun kiloh ni alinah, ngannangih ni dewwan kiloh di hakey ni lakkitun kalneroh ");
INSERT INTO ify_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","niya hangkiloh hu mei-unnud di hakey ni hantoon tun kalneroh. ");
INSERT INTO ify_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Man-appit kayu mewan ni lakkitun gelding tep ya liwat e mei-dum di i-appit yu ma-lat ma-kal liwat yun pengippahdingan yun elaw ni panlinnih yun tuu. Hin-appil ngu dedan etan ida i-appit yun kagihheba e meunnudan ni alinah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Meemmung kayu mewan et mandaydayaw kayun hi-gak ni meikkahampulut liman aggew ni meikkeppitun bulan. Ey eleg kayu mangngunnun nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Yan memengngulun aggew ey man-appit kayun kagihheba e humman i-appit yun hi-gak ni kennen ma-lat umamlengngak ni hamuy tu. Huyyadda i-appit yu: ya hampulut tellun kilaw ni lakkitun baka, ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Hanhakkey idan nunyan animal ey unnudan yun kamei-appit ni begah e humman hu alinah ni neha-adan ni mansikan olibah. Ya hakey ni baka ey meunnudan ni ngannganih ni tellun kiloh ni alinah, et ya hakey ni lakkitun kalneroh ey meunnudan ni ngannganih ni dewwan kiloh ni alinah ");
INSERT INTO ify_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","niya hakey ni hantoon tun lakkitun kalneroh ey meunnudan ni ngannganih ni hangkiloh ni alinah. ");
INSERT INTO ify_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Man-appit kayu mewan ni lakkitun gelding ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheba e meunnudan ni alinah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Yan meikkadwan aggew ey iappit yu hu hampulut dewwan kilaw ni lakkitun baka ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Humman idan animal ey meunnudan idan kamei-appit ni alinah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Man-appit kayu mewan ni lakkitun gelding ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheba e meunnudan ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Yan meikkatlun aggew ey iappit yu hampulut hakey ni kilaw ni lakkitun baka, ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Meunnudan ida humman ni animal ni i-appit yun begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Man-appit kayu ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Mei-dum ida humman di i-appit yun kagihheba e meunnudan ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Yan meikka-pat ni aggew ey iappit yu hu hampulun kilaw ni lakkitun baka ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Huyyaddan animal ey meunnudan ni i-appit yun begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Man-appit kayu mewan ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheban meunnudan ni begah niya meinnum ni memengngulun aggew ni kabulabulan ey kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Yan meikkelliman aggew ey man-appit kayun heyam ni kilaw ni lakkitun baka, ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Humman idan animal ey meunnudan ni i-appit yun begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Man-appit kayu mewan ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheban meunnudan ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Yan meikka-nem ni aggew ey man-appit kayun walun kilaw ni lakkitun baka, ya dewwan lakkitun kalneroh niya hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Humman idan animal ey meunnudan idan kamei-appit ni begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Man-appit kayu mewan ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheban meunnudan ni begah niya meinnum ni memengngulun aggew ni kabulabulan ey kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Yan meikkeppitun aggew ey man-appit kayun pitun kilaw ni lakkitun baka, dewwan lakkitun kalneroh ey hampulut epat ni hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Humman idan animal ey meunnudan idan kamei-appit ni begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Man-appit kayu mewan ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Hin-appil ngu dedan hu i-appit yun kagihheban meunnudan ni kamei-appit ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Yan meikkewwalun aggew ey kaemung idan emin tuu e endi mangngunnun nunman ni aggew. ");
INSERT INTO ify_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Huyyadda i-appit yun kagihheban mengippeamleng ni hi-gak: ya hakey ni kilaw ni lakkitun baka, ya hakey ni lakkitun kalneroh niya pitun hantoon dan lakkitun kalneroh. Mahapul ni endi dipektoh da. ");
INSERT INTO ify_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Humman idan animal ey meunnudan idan kamei-appit ni begah niya meinnum. ");
INSERT INTO ify_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Man-appit kayu mewan ni lakkitun gelding tep ya liwat ma-lat ma-kal liwat yu. Mei-dum ida huyyad i-appit yun kagihheban meunnudan ni kamei-appit ni begah niya meinnum ni memengngulun aggew ni kabulabulan niyan kewa-wa-wa. ");
INSERT INTO ify_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Emin ida huyyan ni mei-appit nunman ni piyestah ey hin-appil ngu dedan idad kamei-appit ni kagihheba, ya pagey, ya meinnum niya i-appit yun pekiddagyuman yun hi-gak e Dios. Hin-appil mewan etan issapatah yu niya iggeb-at yun i-appit.” ");
INSERT INTO ify_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Intugun Moses emin huyyan tugun Apu Dios idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Huyya intugun Apu Dios nan Moses ni e-helen tuddan kamengipappangngulun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“Hedin insapatah ni hakey ni tuu e iddawat tu hu hipa nan Apu Dios ey mahapul ni pehding tu hu insapatah tu e eleg tu kekyata. ");
INSERT INTO ify_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ya etan biin kamanha-ad di kad-an ametun mansapatah nan Apu Dios ");
INSERT INTO ify_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ey anin ni dingngel ametu nem tuka pakdag i-ineng e eleg tu ikka-leg, ey mahapul ni pehding tu humman ni insapatah tu. ");
INSERT INTO ify_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nem hedin dingngel ametu ey eleg tu pinhed, ey dammutun anin ni eleg pehding etan ni bii humman ni insapatah tu. Pessinsahan Apu Dios humman ni bii tep ingka-leg ametun pehding tu hu insapatah tu. ");
INSERT INTO ify_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Hedin ya eleg mengahwan bii hu mansapatah anin ni kantu et nekannemnem tu winu eleg et mansapatah, ey entanni ey nengahwa ");
INSERT INTO ify_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","et neamtaan ni ahwa tu hu nansapatahan tu ey eleg tu ikka-leg, ey mannenneng hu insapatah tu. ");
INSERT INTO ify_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Nem hedin eleg pinhed ni ahwa tu ey dammutun anin eleg tu ippahding humman ni insapatah tu, ey eleg ibbilang Apu Dios e bahul tu humman. ");
INSERT INTO ify_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Hedin ya nebalu winu ya biin hini-yan ni ahwatu hu nansapatah ey mahapul ni pehding tu hu insapatah tun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Hedin nengahwa etan biin nansapatah ey nan-addum idan ahwatu, ");
INSERT INTO ify_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ey neamtaan etan ni ahwa tu ey eleg tu ikka-leg, ey mahapul ni mannenneng hu insapatah tu. ");
INSERT INTO ify_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Nem hedin neamtaan ni ahwatu ey eleg tu pinhed, dammutun anin eleg tu ippahding humman ni insapatah tu ey eleg ibbilang Apu Dios ni bahul humman. ");
INSERT INTO ify_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Wada kelebbengan ni ahwatun mengikka-leg winu mengi-ebbulut ni pengippahdingan tun insapatah tu. ");
INSERT INTO ify_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Nem hedin neamtaan ni ahwa tu ey kaum-i-ineng e eleg tu ikka-leg, ey mahapul ni pehding tu humman ni insapatah tu. Humman keang-angan tu e in-abulut tu hedin eleg tu ika-leg ni nunman ni aggew ni nangngelan tu. ");
INSERT INTO ify_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Nem hedin nebaybayag et han tu ika-leg ey hi-gatu mekastigud eleg pengippahdingin etan ni biin insapatah tu.” ");
INSERT INTO ify_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Huyyadda hu inhel Apu Dios nan Moses meippanggep ni han-ahwan biin laki niya pehding ni hakey ni ama di biin u-ungnga tun eleg mengahwan kamekihha-ad di baley tu. ");
INSERT INTO ify_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Kastigum ida tutu-ud Midian tep ya impahding daddan helag Israel. Hedin negibbuh ni impahding mu humman ey mettey ka law.” ");
INSERT INTO ify_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Et kan Moses ida etan ni tuu ey “Pandaddan kayun mekiggubbat e iehneng yu hi Apu Dios et yudda gubaten hu iMidian et meibleh hu impahding da. ");
INSERT INTO ify_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mahapul ni hanlilibu hu melpud hanhakkey ni helag Israel.” ");
INSERT INTO ify_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Et pumili idan hanlilibud emin idan helag ni u-ungngan Israel, et ya bilang dan emin ni an mekiggubbat ey hampulut dewwan libu. ");
INSERT INTO ify_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Intu-dak Moses ida humman ni sindalun impanguluddan Pinehas e u-ungngan Eleasar e padi e hi-gatu hu ngenamung ida etan ni neieng-eng ni usal, anin idan tangguyup ni ussalen dan mengippeamta hedin wada gubat. ");
INSERT INTO ify_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Et da ida iMidian meippuun di inhel Apu Dios nan Moses ni pehding da et patyen dan emin hu lalakki, ");
INSERT INTO ify_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","anin etan idan liman patul diman e hi Ebi, hi Rekem, hi Sur, hi Hur et hi Reba. Ey nekipetey da hi Balaam e u-ungngan Beor. ");
INSERT INTO ify_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Inla dadda bibi-idman ni bebley anin idan kaungaunga, yadda baka da, yadda kalneroh da niyaddan emin hu kinedangyan da, ");
INSERT INTO ify_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","et legaben da bebley da niyadda kampu da. ");
INSERT INTO ify_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Inemung dan emin hu nan-ale dadman ni bebley, yadda tutu-u niyadda animal ");
INSERT INTO ify_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","et ienamut dan emin di kad-an Moses nan Eleasar e padi niyadda edum dan helag Israel etan di nangkampuan dad nandeklan di Moab e gilig ni Wangwang e Jordan e demang ni Jericho. ");
INSERT INTO ify_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","An dinammud Moses, hi Eleasar e padi niyadda kamengipappangngulun helag Israel ida etan di a-allaw ni nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ey bimmunget hi Moses idan opisyal niyadda ap-apun sindalun nambangngad ni an nekigubat. ");
INSERT INTO ify_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Kantun hi-gaday “Kele eleg yudda pateyen emin hu bibi-i? ");
INSERT INTO ify_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Hi-gada hu nengawis idan edum tayu et ngehayen da hi Apu Dios di Duntug e Peor tep inu-unnud da intugun Balaam ni hi-gada. Et humman himmulun et paelin Apu Dios hu degeh ni hi-gatsun tuu tu. ");
INSERT INTO ify_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Pampatey yuddan emin hu lalakkin u-ungnga, anin idan bibi-in in-ulig ni laki. ");
INSERT INTO ify_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Nem entan tudda patey hu bibi-in gegellang niya bibi-in eleg i-ulig ni laki et alen yudda. ");
INSERT INTO ify_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Hi-gayun wada pintey tu winu kinepa tun annel ni netey ey panha-ad kayu nid a-allaw ni kampu tayun pitun aggew. Mahapul ni pehding yu hu elaw ni panlinnih anin idad balud yun meikkatlu niyan meikkeppitun aggew. ");
INSERT INTO ify_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Mahapul mewan ni pehding yu hu elaw ni panlinnih idan balwasi yu winu kumpulmih ni nekapyad katat winu bewek ni gelding, anin idan nekapyad keyew.” ");
INSERT INTO ify_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Entanni ey kan Eleasar e padi etan idan lalakkin an nekigubat ey “Huyyadda hu inhel Apu Dios nan Moses ni u-unnuden tayu. ");
INSERT INTO ify_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Emin ida eleg gihheba, henin balituk, silber, giniling, gumek, lata winu ihmay ");
INSERT INTO ify_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ey mahapul ni pedellan yud apuy et han dammutun meibbillang ni malinih. Nem hedin yadda etan kagihheba ey mahapul ni ya danum ni ebuh hu ussalen yun panlinnih idan nunman. ");
INSERT INTO ify_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ya pehding yun meikkepitun aggew ey ibalbal yu balwasi yu et maibilang kayun malinih et dammutun umhegep kayud kampu tayu.” ");
INSERT INTO ify_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Mahapul ni billangen yud Eleasar niyadda kamengipappangngulun tuu emin hu nealad gubat anin idan balud niyadda animal. ");
INSERT INTO ify_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ey gedwam et idwat muddan sindalu hu kagedwah niya idwat muddan tuu hu kagedwah. ");
INSERT INTO ify_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nem ya memengngulun pehding mu ey idwat mun hi-gak hu patal kuddan balud, yadda baka, kebayyu, kalneroh niyadda gelding e meellad patal idan sindalu. Appil mu hu hakey di hanlilmanggatut et humman mei-eng-eng ni hi-gak. ");
INSERT INTO ify_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Idwat mudda huyyan patal kun Eleasar e padi et iappit tun hi-gak e Dios. ");
INSERT INTO ify_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Hedin yadda etan meidwat ni tutu-u ey iddawat dan hi-gak hu hakey di hanneneliman balud, yadda baka, kebayyu, kalneroh niyadda gelding. Ellan idan helag Levi e kamampaptek ni Tabernacle huyya.” ");
INSERT INTO ify_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Inu-unnud di Moses nan Eleasar hu inhel Apu Dios et ipahding da. ");
INSERT INTO ify_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Heninnuy hu bilang ni inladdan sindalu: Yadda lakkitun kalneroh ey 675,000, ");
INSERT INTO ify_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","yadda bulug ni baka ey 72,000, ");
INSERT INTO ify_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","yadda lakkitun kebayyu ey 61,000. ");
INSERT INTO ify_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Yadda biin balud ni eleg iulig ni laki ey 32,000. ");
INSERT INTO ify_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ya kagedwah ni neidwat idan sindalun nekigubat ey 337,500 ni kalneroh, ");
INSERT INTO ify_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ya neidwat nan Apu Dios ey 675 ");
INSERT INTO ify_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","yadda baka ey 36,000 ey neidwat nan Apu Dios hu 72, ");
INSERT INTO ify_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","yadda kebayyu ey 30,500 ey neidwat nan Apu Dios hu 61, ");
INSERT INTO ify_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","yadda balud ni biin eleg iulig ni laki ey 16,000 ey neidwat nan Apu Dios hu 32. ");
INSERT INTO ify_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Indawat Moses nan Eleasar e padi hu bingay Apu Dios meippuun di intugun tu. ");
INSERT INTO ify_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ya inappil Moses ni meidwat idan tutu-u ey ");
INSERT INTO ify_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","337,500 ni kalneroh, ");
INSERT INTO ify_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 ni baka, ");
INSERT INTO ify_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 ni kebayyu ");
INSERT INTO ify_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","niya 16,000 ni biin eleg iulig ni laki. ");
INSERT INTO ify_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Inlan Moses hu hanhakey di hanneneliman balud niyadda animal et idwat tuddan helag Levi e kamengippaptek ni Tabernacle Apu Dios. Neipahding emin huyya meippuun di intugun Apu Dios nan Moses ni pehding tu. ");
INSERT INTO ify_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Entanni ey limmaw ida opisyal niyadda aap-apun sindalud kad-an Moses ");
INSERT INTO ify_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","et kanday “Apu, binilang min emin ida sindalu mi ey wadaddan emin. Endi neendi anin hakey. ");
INSERT INTO ify_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Et humman hu in-ali midda inla mid gubat ni balituk ni kameihhuklub di ngamay, yadda singsing, yadda betling niyadda banggel et iappit min Apu Dios ma-lat pengipeang-ang min mika pansalamati, tep endin hekey hu netey ni hi-gami.” ");
INSERT INTO ify_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Et amungen di Moses nan Eleasar e padi humman ni in-aliddan sindalun balituk ni tenged. ");
INSERT INTO ify_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ya bel-at idan nunman ni balituk ni in-appit idan aap-apun sindalu nan Apu Dios ey umlaw ni dewanggatut ni kiloh. ");
INSERT INTO ify_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Emin ida sindalu ey inla da patal da etan idad inla dad gubat. ");
INSERT INTO ify_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Inlad Moses nan Eleasar etan ida balituk ni indawat idan ap-apun sindalu et ilaw dad Tabernacle et penginemnemneman Apu Dios e tuu tudda hu helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Yadda helag di Reuben nan Gad ey dakel ni peteg animal da. Et yan nenang-angan da e kayyaggud hu Jaser et ya Gilead ni pampattulan dan animal da ");
INSERT INTO ify_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ey limmaw idan Moses nan Eleasar e padi niyadda edum ni kamengipappangngulun helag Israel et kandan hi-gaday ");
INSERT INTO ify_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Hi-gamin bega-en yu ey dakel animal mi. Ey kayyaggud ni pampattulan ida bebley di Atarot, ya Dibon, ya Jaser, ya Nimrah, ya Hesbon, ya Elealeh, ya Sibmah, ya Nebo niya Beon e sinekup tayu tep ya baddang Apu Dios ma-lat pambebleyan tayun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Idwat yudda anhan ida humman ni bebley ni hi-gami et anin ni eleg kami meagwat di Jordan.” ");
INSERT INTO ify_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Kan Moses ey “Kaw hedin ya pinhed yu ey manha-ad kayudya et yadda edum yun helag Israel ni ebuh hu man-agwat di Jordan et hi-gada makigubat? ");
INSERT INTO ify_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Hedin heni nuntan pehding yu ey dismayahen yudda edum yun man-agwat ni umlaw di bebley ni indawat Apu Dios ni hi-gada? ");
INSERT INTO ify_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Henin nuntan tu-wangu impahding idan aammed yu eman ni nengitu-dakak idad Kades Barnea et da ang-angen humman ni bebley. ");
INSERT INTO ify_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Limmaw ida et meipappeg idad Nedeklan e Eskol, nem entannit nambangngad ida ey dinismayah dadda edum dan helag Israel ni umlaw di bebley ni indawat Apu Dios ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Et umhulun humman ni impahding da ey bimmunget hi Apu Dios et isapatah tu ");
INSERT INTO ify_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","e kantuy ‘Issapatah ku e emin ida hu dewampulu toon tu winu nehuluk ni neni-yan ni Egypt, ey endi an umdateng ni hi-gadad bebley ni inhel kun Abraham, hi Isaac et hi Jacob ni iddawat kun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ebuh hi Kaleb e u-ungngan Jephunneh e Kenissite et hi Joshua e u-ungngan Nun ni umdateng diman tep naka-u-unnud da hi Apu Dios.’ ");
INSERT INTO ify_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Humman idan helag Israel ey limmeniklikweh idad eleg mebebleyin na-pat ni toon ingganah netey idan emin hu nanliwat nan Apu Dios tep nemahhig bunget tun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ey itten kayu mewan ni nekalliwtan ni tuun pinhed yun ippahding hu henin impahding ida lan aammed yu! Yuka panma-maa bunget Apu Dios ni hi-gayun helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Hedin eleg yu mewan u-unnuda hi Apu Dios, hi-gayuddan helag Reuben niyadda helag Gad et umbunget et iwwaleng daitsu eyad eleg mebebleyi ey hi-gayu kambahul ni kebahbahan tayu.” ");
INSERT INTO ify_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Nem kandan Moses ey “Hedin ya pinhed min pehding ey mengapya kamin pengikkubkuban min kalneroh mi ey hammaden min luhhuden eya bebley et panha-adan idan ahwa mi niyadda u-ungnga mi. ");
INSERT INTO ify_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Et hedin negibbuh, ey iddaddan mi almas mi et ipengulu midda edum min helag Israel ni an mekiggubbat ingganah melinggep idan mambebley di bebley ni meidwat ni hi-gada. Ey melinggep ida dama pamilyah mi eyad bebley ni hammaden min luhhuden tep endi pekahgep ni tuun an mengubbat ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Eleg kami um-anemut ingganah ellan idan edum min helag Israel emin hu beltanen dan puyek da. ");
INSERT INTO ify_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Anin ni endi meidwat ni hi-gamin puyek di ba-hil ni Jordan. Pinhed min mambebley eyad appit ni kasimmilin aggew ni neitudun beltanen mi.” ");
INSERT INTO ify_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kan Moses ey “Hedin makulug ni pehding yu hu inhel yu et mandaddan kayun mekiggubbat ma-lat iehneng yu hi Apu Dios, ");
INSERT INTO ify_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","niya hedin man-agwat ida sindalu yu et ipengulun Apu Dios idan mengubbat ni buhul tayu ingganah degyunen tudda, ");
INSERT INTO ify_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ey dammutun mambangngad kayu tep impahding yu hu lebbeng tun pehding yun pengu-unnudan yun Apu Dios, ey impahding yu hu lebbeng tun pemaddang yuddan aaggi tayun helag Israel. Ey dammutu law ni mambebley kayu eyad bebley ni appit ni kasimmilin aggew di Jordan ni iddawat Apu Dios ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Nem hedin eleg yu ippahding huttan ni inhel yu ey manliwat kayun Apu Dios. Et humman hu ang-ang yu kuma tep makulug ni mekastigu kayu hedin manliwwat kayu. ");
INSERT INTO ify_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Anin pengapya kayun baballey yu niya pengikkubkuban yuddan kalneroh yu nem mahapul ni pehding yu hu inhel yu.” ");
INSERT INTO ify_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Kan idan helag Reuben niyadda helag Gad ey “Hi-gamin bega-en mu ey u-unnuden mi inhel mu. ");
INSERT INTO ify_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Manha-ad idadya Gilead hu ahwa mi, yadda u-ungnga mi niyadda animal mi, ");
INSERT INTO ify_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","nem hedin hi-gamin lalakki ey mandaddan kamin mekiggubbat e hi Apu Dios mengippengngulun hi-gami. U-unnuden mi inhel mun man-agwat kamid Jordan et kami makigubat.” ");
INSERT INTO ify_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Intugun Moses nan hi Eleasar, hi Joshua et yadda kamengipappangngulun tuu e kantuy ");
INSERT INTO ify_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Hedin man-agwat ida helag Gad niyadda helag Reuben di Jordan et mekillaw idan hi-gayun an mekiggubbat e ippangulu dakeyun Apu Dios, ey hedin sinekup yun emin hu bebley ey idwat yun hi-gada Gilead et pambebleyan da. ");
INSERT INTO ify_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Nem hedin eleg da pinhed ni mekillaw ni hi-gayun an mekiggubbat ey yad bebley di Kanaan hu pekibbingngayan dan pambebleyan da.” ");
INSERT INTO ify_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kan idan helag Gad niyadda helag Reuben ey “Apu, u-unnuden mi intugun Apu Dios. ");
INSERT INTO ify_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ihhammad min man-almas et man-agwat kamid Jordan et lumaw kamid Kanaan et kami makigubat et iehneng mi hi Apu Dios, nem huyyan ba-hil ni Jordan hu beltanen mi.” ");
INSERT INTO ify_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Et idwat Moses idan helag Reuben, yadda helag Gad niyadda kagedwah ni helag Manasseh e u-ungngan Joseph hu bebley Sihon e patul idan Amorite, ya bebley Og e patul di Basah niyaddan emin hu nanlinikweh ni bebley diman. ");
INSERT INTO ify_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Inyayyaggud idan helag Gad hu bebley di Dibon, ya Atarot, ya Aroer, ");
INSERT INTO ify_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ya Atrot-Sophan, ya Jaser, ya Jogbehah, ya ");
INSERT INTO ify_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimrah et ya Bet Haran. Et nehammad law ni neluhud ni tuping ida humman ni bebley ey wadadda pengikkubkuban dan animal da. ");
INSERT INTO ify_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Inyayyaggud ida daman helag Reuben hu bebley di Hesbon, ya Elealeh, ya Kiriathaim, ");
INSERT INTO ify_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ya Nebo, ya Baal Meon niya Sibmah. Hinullulan da ngadan idan edum ni bebley ni sinekup da et iyayyaggud da. ");
INSERT INTO ify_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Yadda helag Makir e u-ungngan Manasseh ey sinekup da Gilead et degyunen dadda Amorite ni nambebley diman. ");
INSERT INTO ify_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Et idwat nan Moses hu Gilead idan helag Makir e u-ungngan Manasseh et mambebley idadman. ");
INSERT INTO ify_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yadda etan edum ni bebley di Gilead ey sinekup ni helag Jair e helag daman Manasseh et hullulan da ngadan da et ngadnan dan Bebley Jair. ");
INSERT INTO ify_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Hi Nobah ey ginubat tu et sakupen tu Kenat niyadda nanlinikweh ni bebley diman et ngadnan tun Nobah. ");
INSERT INTO ify_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Huyyadda neitudek ni ngadan idan nangkampuan idan helag Israel eman ni nalpuan dad Egypt e di Moses nan Aaron nengipengulun hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Intudek Moses hu ngadan idan nunman ni nangkampuan da tep humman hu inhel Apu Dios ni pehding tu. Huyyadda dindinlan da e meamtad nangkampuan da. ");
INSERT INTO ify_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Hini-yan idan helag Israel hu bebley di Rameses di Egypt eman ni meikkahampulut liman aggew ni nemangulun bulan ni newa-waan ni nelabhan ni Anghel Apu Dios. Yan neni-yanan idan helag Israel ni nunman ni bebley ey kaang-ang-angaddan tuudman ida. ");
INSERT INTO ify_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Yan nunman daman aggew ey daka pan-ikkulung hu pengulwan ni u-ungnga dan pintey Apu Dios. Humman ni impahding Apu Dios hu nengipeang-angan tu e et-eteng kabaelan tu nem yadda dios di Egypt. ");
INSERT INTO ify_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Hini-yan idan helag Israel hu Rameses et lumaw idad Sukkot et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Entanni et lumaw idad Etham di gilig ni eleg mebebleyi et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Hini-yan da Etham et ibabbangngad da et ilikweh dad Pi Hahirot e demang ni Baal-Sephon et mangkampuddad Migdol. ");
INSERT INTO ify_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Hini-yan da Pi Hahirot et man-agwat idad Madlang ni Baybay et lumaw ida etan di eleg mebebleyi. Nandalan idan tellun aggew et dumteng idad Marah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Hini-yan da humman et lumaw idad Elim et mangkampudda mewan diman tep wada hampulut dewwan hebwak niya nepitun palmah diman. ");
INSERT INTO ify_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Hini-yan da humman et ida mangkampuddad gilig ni Madlang ni Baybay. ");
INSERT INTO ify_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Hini-yan da humman et lumaw idad Sin e eleg mebebleyi et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Entanni ey limmaw idad Dopkah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Hini-yan da Dopkah et ida mangkampud Alus. ");
INSERT INTO ify_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Entanni ey nampalaw idad Rephidim e endi innumen ni danum et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Hini-yan da humman et mampalaw idad Sinai e eleg mebebleyi et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Hini-yan da humman et ida mangkampud Kibrot Hattaabah. ");
INSERT INTO ify_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Entanni ey limmaw idad Haserot et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Hini-yan da Haserot et ida mangkampud Ritmah. ");
INSERT INTO ify_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Hini-yan da humman et mangkampuddad Rimmon Peres. ");
INSERT INTO ify_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Entanni ey limmaw idad Libnah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Limmaw idad Rissah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Entanni ey nampalaw idad Kehelathah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Hini-yan da humman et mampalaw idad Duntug e Sepher et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Hini-yan da humman et ida mangkampud Haradah. ");
INSERT INTO ify_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Limmaw idad Makhelot et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Hini-yan da humman et ida mangkampud Tahat. ");
INSERT INTO ify_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Hini-yan da Tahat et ida mangkampud Terah. ");
INSERT INTO ify_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Hini-yan da Terah et ida mangkampud Mitkah. ");
INSERT INTO ify_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Entanni et lumaw idad Hasmonah et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hini-yan da humman et ida mangkampud Moserot. ");
INSERT INTO ify_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Nampalaw idad Bene Jaakan et ida mangkampudman. ");
INSERT INTO ify_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Entanni et lumaw idad Hor Haggidgad et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Hini-yan da humman et ida mangkampud Jotbathah. ");
INSERT INTO ify_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Hini-yan da humman et ida mangkampud Abronah. ");
INSERT INTO ify_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Entanni et lumaw idad Esion Geber et ida mangkampudman. ");
INSERT INTO ify_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Nampalaw idad Kades di kad-an ni Sin e eleg mebebleyi et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Entanni et mampalaw idad Duntug e Hor di pappeg ni Edom et ida mangkampudman. ");
INSERT INTO ify_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Yan nunman ni kaweda da etan di hengeg ni duntug ey inhel Apu Dios nan Aaron e mantetyed di ta-pew nunman ni duntug et matey diman. Neipahding huyya eman ni nangginawwa hu siyaggew ni meikka-pat ni pulun toon neipalpun neni-yanan idan helag Israel ni Egypt. ");
INSERT INTO ify_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Ey yan nunman ni neteyyan Aaron ey hanggatut et dewampulut tellu toon tu. ");
INSERT INTO ify_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ey yan nunman hu nangngelan Arad e patul di Kanaan e kamengelidda helag Israel e ida kamangkeihnup di bebley tu. ");
INSERT INTO ify_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Hini-yan da Duntug e Hor et ida mangkampud Salmonah. ");
INSERT INTO ify_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Hini-yan da Salmonah et ida mangkampud Punon. ");
INSERT INTO ify_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Hini-yan da Punon et ida mangkampud Obat. ");
INSERT INTO ify_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Entanni ey limmaw idad Iye Abarim di pappeg ni Moab et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Hini-yan da humman et ida mangkampud Dibon Gad. ");
INSERT INTO ify_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Hini-yan da humman et ida mangkampud Almon Diblathaim. ");
INSERT INTO ify_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Entanni et lumaw idad duntug di Abarim e neihnup di Duntug e Nebo et mangkampuddadman. ");
INSERT INTO ify_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Hini-yan da humman et ida mangkampud nandeklan di Moab e gilig ni Wangwang e Jordan e demang ni Jericho. ");
INSERT INTO ify_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Nedagdagsi hu kakampu dadman di gilig ni Wangwang e Jordan neipalpud Bet Jeshimot ingganah di Abel Sittim. ");
INSERT INTO ify_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Immehel hi Apu Dios nan Moses di diman e kantuy ");
INSERT INTO ify_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Ehel muddan helag Israel e hedin man-agwat ida eyad Wangwang e Jordan et umlaw idad Kanaan ");
INSERT INTO ify_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ey mahapul ni degyunen daddan emin hu nambebley diman. Ey mahapul ni bahbahen dan emin hu kinapya dan dios da anin idan baley nunman idan dios da. ");
INSERT INTO ify_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Pambebleyan dadda humman ni bebley tep indawat kudda humman ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ya pehding mun mengikka-peng nunman ni puyek ey ibubunut yu. Ya kelakkeb tu ey meippuun di kedakkel idan pengidwatam. Ya melallakkeb ni puyek hu meidwat idan daddakkel bilang da ey beken ni melakkeb hu meidwat idan ekket bilang da. Hedin hipa binunut da, man humman beltanen dan puyek, eleg mabalin ni mehullulan. Hanneya hu ipahding yun helag Israel ni mengikka-peng ni puyek. ");
INSERT INTO ify_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Nem hedin eleg yudda degyuna hu nambebley diman ey mambalin idallin heni butad mateyu winu heniddalli hebit. Iddawtan dakeyullin panligligatan yudman ni pambebleyan yu. ");
INSERT INTO ify_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ey kastiguen dakeyu henin implanuh kun pehding kun hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Huyyadda inhel Apu Dios ni ittugun Moses idan helag Israel: ");
INSERT INTO ify_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Eleg mebayyag ey umlaw kayud bebley di Kanaan e humman hu bebley ni iddawat kun hi-gayun beltanen yu ey huyyadda pappeg tu: ");
INSERT INTO ify_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Ya pappeg tud appit ni south ey meippalpud Sin e eleg mebebleyi di pappeg ni Edom. Ya pappeg tud appit ni kasimmilin aggew ey meippalpud Netey ni Baybay. ");
INSERT INTO ify_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Neliked di appit ni south e melebbahan hu Scorpion Pass et mampalaw di Sin ingganah di Kades Barnea. Mampellaw mewan di Hasar Addai ingganah di Asmon. ");
INSERT INTO ify_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Meippalpud Asmon et maliked di wangwang di Egypt et meipappeg di Baybay e Mediterranean. ");
INSERT INTO ify_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Ya pappeg tud appit ni kakelinnugin aggew ey yad gilig ni Baybay e Mediterranean. ");
INSERT INTO ify_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ya pappeg tud appit ni north ey meippalpud Baybay e Mediterranean, et mampalaw di appit ni kasimmilin aggew di Duntug e Hor ");
INSERT INTO ify_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ingganah di Lebo Hamat et mampalaw di Sedad, ");
INSERT INTO ify_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","niyad Sipron ingganah di Hasar Enan. Huyyadda pappeg ni bebley yud appit ni north. ");
INSERT INTO ify_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Ya pappeg tud appit ni kasimmilin aggew ey meippalpud Hasar Enan, et mampalaw di appit ni south di Sepham, ");
INSERT INTO ify_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ey nampedayyud Riblah di appit ni kasimmilin aggew di Ain. Meippalpudman et mampedayyud gilig ni Baybay e Galilee di appit ni kasimmilin aggew, ");
INSERT INTO ify_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ey inunud tu hu Wangwang e Jordan ingganah di Netey ni Baybay. Huttan emin hu pappeg ni bebley yu.” ");
INSERT INTO ify_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Kan Moses idan helag Israel ey “Humman idan bebley hu panggegedwaan yun ibubunut yu. Yadda manggegedwan nunman ni bebley ey yadda etan heyam et kagedwah ni helag Israel e humman dedan la hu intudun Apu Dios ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Hedin yadda helag Reuben, yadda helag Gad niyadda kagedwah ni helag Manasseh, ey neidwatan ida dedan law ni puyek da et genedwaen da meippuun di pamilyah da. ");
INSERT INTO ify_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Yadda bebley ni nanggegedwaan da, ey yaddad gilig ni Wangwang e Jordan di appit ni kasimmilin aggew e demang ni Jericho.” ");
INSERT INTO ify_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Entanni ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Yadda mengedwa etan ni puyek ey di Eleasar e padi nan hi Joshua e u-ungngan Nun. ");
INSERT INTO ify_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ey ayagi yu hanhakkey idad helag Israel ni memaddang ni hi-gada. ");
INSERT INTO ify_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Huyyadda ngadan da: hi Kaleb e u-ungngan Jephunneh di helag Judah, ");
INSERT INTO ify_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","hi Semuel e u-ungngan Ammihud di helag Simeon, ");
INSERT INTO ify_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","hi Elidad e u-ungngan Kislon di helag Benjamin, ");
INSERT INTO ify_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","hi Bukki e u-ungngan Jogli di helag Dan, ");
INSERT INTO ify_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","hi Hanniel e u-ungngan Ephod di helag Manasseh e u-ungngan Joseph, ");
INSERT INTO ify_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","hi Kemuel e u-ungngan Siptan e helag Epraim e u-ungngan Joseph, ");
INSERT INTO ify_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","hi Elisaphan e u-ungngan Parnak di helag Sebulun, ");
INSERT INTO ify_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","hi Paltiel e u-ungngan Ashan di helag Issakar, ");
INSERT INTO ify_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","hi Ahihud e u-ungngan Selomi di helag Asher ");
INSERT INTO ify_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","et hi Pedahel e u-ungngan Ammihud di helag Naptali.” ");
INSERT INTO ify_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Huyyadda tuun pinilin Apu Dios ni menang-ang ni kegennedwaan ni Kanaan et ika-peng idan helag Israel. ");
INSERT INTO ify_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yan eman ni wadadda pay nid nandeklan di Moab di gilig ni Jordan e demang ni Jericho ey kan Apu Dios nan Moses ey ");
INSERT INTO ify_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ehel muddan helag Israel e iddawtan dadda helag Levi ni pambebleyan dan meunnudan ni kudal. ");
INSERT INTO ify_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Meidwat ni hi-gada humman idan bebley ma-lat pambebleyan da niya pampattulan dan baka da, yadda kalneroh da niya edum ni animal da. ");
INSERT INTO ify_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Ya kalinakkeb ni pampattulan da meippalpud luhud di nanlinikweh di hanhakkey etan idad bebley ni meidwat ni hi-gada ey limanggatut ni metroh. ");
INSERT INTO ify_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ya kalinakkeb etan ni kuwadladuh di nambina-hil ey ngannganih ni hanlibun metroh, ey meiggawwadman hu et-eteng ni bebley. ");
INSERT INTO ify_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Ya bilang ni bebley ni iddawat yun hi-gadan helag Levi ey na-pat et dewwa, niya idwat yu hu enem ni bebley ni keihhikkugan ni tuun pimmatey nem eleg tu igeb-at. ");
INSERT INTO ify_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ya bilang emin ni bebley ni iddawat yun hi-gada ey na-pat et walu e neunnudan idan kudal. ");
INSERT INTO ify_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Ya bilang ni bebley ni iddawat ni hanhakkey idan helag Israel idan aaggi dan helag Levi ey meippuun di kalinakkeb ni puyek ni meidwat ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Huyya mewan hakey ni inhel Apu Dios nan Moses ");
INSERT INTO ify_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","ni ittugun tuddan helag Israel: “Hedin man-agwat kayud Wangwang e Jordan et umlaw kayud Kanaan, ");
INSERT INTO ify_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ey pili kayun bebley ni keihhikkugan ma-lat yadman bebsikan ni tuun pimmatey nem eleg tu igeb-at. ");
INSERT INTO ify_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Huyya pehding yu ma-lat endi inna-nuddan aaggin pintey tun mengibleh. Ya tuun pimmatey ey eleg mabalin ni meippepettey hedin eleg ni meihuhummangan di hinanggaddan bimmebley. ");
INSERT INTO ify_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Putuk yu enem ni bebley ni keihhikkugan, ");
INSERT INTO ify_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","tellud appit ni kasimmilin aggew di Wangwang e Jordan ey tellud Kanaan di appit ni kakelinnugin aggew. ");
INSERT INTO ify_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Humman idan bebley hu keihhikkugan idan helag Israel, yadda hansinu-wan ni nekibebley ni hi-gayu niya anin ni hipan tuun pimmatey ni eleg tu igeb-at. ");
INSERT INTO ify_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","Nem hedin wada inusal etan ni pimmatey ni tuun nematey tu, henin gumek, batu winu keyew, ey meibbillang humman ni tuun pimmatey. Et humman hu mahapul ni mekastigu et matey. ");
INSERT INTO ify_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ngenamung ida agi etan ni netey ni mengibleh ni memettey ni nunman ni pimmatey. Et hedin ha-kupan da, petteyen da. ");
INSERT INTO ify_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Hedin ya hakey ni tuu ey anggebe-hel tu hu edum tun tuu et ittuldun tu winu tegmilan tu ");
INSERT INTO ify_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","winu duntuken tu et matey ey meibbillang humman ni tuun pimmatey. Mahapul ni mekastigun katey. Ya etan neihnup ni agin netey hu an memettey nunman ni pimmatey. ");
INSERT INTO ify_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","23","Nem hedin kantu et intuldun ni hakey ni tuu hu edum tun tuu winu imbekah tu batu winu inggah tu batu et metegmilan etan tuu et matey, nem eleg tu igeb-at niya beken tun anggebe-hel, ey eleg mebehhuli etan pimmatey. ");
INSERT INTO ify_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Hedin wada hanniman, ey eleg ibbilang idan bimmebley ni huwet ni nambahul etan tuun nengipahding nunman niya eleg da ibbilang lebbeng tun ibbaleh idan agi etan ni netey. ");
INSERT INTO ify_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mahapul ni ang-angen idan bimmebley et eleg patyen idan agi etan ni netey humman ni pimmatey. Nem mahapul ni ittu-dak da etan di bebley ni panha-adan tun keihhikkugan tu. Manha-ad law diman ingganah ketteyyan etan ni keta-ta-geyyan ni padi. ");
INSERT INTO ify_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Nem hedin meukkat etan pimmatey diman ");
INSERT INTO ify_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","et ang-angen idan neihnup ni agi etan ni netey et patyen da, ey eleg mekastigu humman ni nematey ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ya etan tuun pimmatey nem eleg tu igeb-at ey mahapul dedan ni mannenneng ni mambebley di bebley ni keihhikkugan ingganah mettey etan keta-ta-geyyan ni padi, et han law dammutun mambangngad di bebley da. ");
INSERT INTO ify_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Huyyaddan tugun ey mahapul ni u-unnuden yun ingganah anin idan helag yu niya anin ni attu pambebleyan yu. ");
INSERT INTO ify_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ya etan tuun pimmatey tep pinhed tun umpatey winu umhulun hu bunget tu, ey mekastigun katey hedin wadadda tistigun mengi-uh-uh ni impahding tu. Eleg mabalin ni mekastigu hedin hakey ni ebuh hu mantistigu. ");
INSERT INTO ify_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ya etan tuun pimmatey tep pinhed tun umpatey winu umhulun hu bunget tu, ey mahapul nisin mekastigun katey. Eleg mabalin ni mambeyyad et meliblih di kastigu tu. ");
INSERT INTO ify_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Eleg mewan mabalin ni mambeyyad et meliblih hu hakey ni pimmatey ni bimmesik di bebley ni keihhikkugan ma-lat dammutun mambangngad ey eleg ni matey etan keta-ta-geyyan ni padi. ");
INSERT INTO ify_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Tep hedin i-abulut yun ippahding ni pimmatey humman ey mehibit hu bebley ni panha-adan yu. Et humman hu, mahapul ni pepettey yu etan pimmatey tep humman ni ebuh dammutun panlinnih yun nehibit ni bebley. ");
INSERT INTO ify_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Entan tu hibit hu bebley ni yu pambebleyan tep hi-gak e Dios yu ey mekibbebleyyak ni hi-gayun helag Israel.” ");
INSERT INTO ify_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Limmaw ida hu kamengipappangngulun pamilyah idan helag Gilead e u-ungngan Makir e u-ungngan Manasseh e u-ungngan Joseph di kad-an Moses niyadda edum ni aap-apu ");
INSERT INTO ify_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","et kanday “Intugun Apu Dios e ibinnunut hu pengennedwaam ni puyek et ika-peng min helag Israel. Intugun tu pay e iddawwat mu puyek agi mi e hi Selophehad idan biin u-ungnga tu. ");
INSERT INTO ify_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Nem intugun tu e hedin ya edum ni pewen hu peki-ahwaan da man umlaw etan beltanen dan puyek di nengapun hi-gada. Et hedin hanniman meippahding ey me-kalan law hu puyek ni meidwat ni hi-gami. ");
INSERT INTO ify_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ey hedin nedatngan hu toon ni pengibbangngadan ni hipan ginetang di nengatngan, ey meibbangngad di sigud ni kampuyek, et ya etan puyek Selophehad ni bineltan idan biin u-ungnga tu, ey mei-dum ali law di puyek idan nekiahwaan da et pampuyyek dallin ingganah et me-kalan law puyek ni helag mi.” ");
INSERT INTO ify_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Et itugun Moses idan tuu hu inhel Apu Dios e kantuy “Neiptek hu inhel idan helag Manasseh. ");
INSERT INTO ify_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Heninnuy hu intugun Apu Dios meippanggep idan bibi-in u-ungngan Selophehad: Anin ni mampilliddan pinhed dan ahwaen, nem mahapul ni ya edum dan helag Manasseh hu ahwaen da, ");
INSERT INTO ify_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ma-lat mannananeng di pewen da hu puyek ni beltanen da. Mahapul ni wada hakkey ni hi-gayun helag Israel ey mannananeng hu puyek ni beltanen yu. ");
INSERT INTO ify_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Et humman hu, emin hu bibi-in helag Israel ni wada beltanen tun puyek, ey mahapul ni mengahwad pewen da ma-lat eleg ma-kalan hu puyek ni bineltan idan hanhakkey ni helag Israel, ey ma-lat mannananeng di helag da hu bineltan da. ");
INSERT INTO ify_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Hanniman ipahding yu ma-lat eleg lumaw di edum ni pewen hu bineltan da nem mannananeng ni hi-gada.” ");
INSERT INTO ify_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Inu-unnud idan u-ungngan Selophehad hu intugun Apu Dios nan Moses ni pehding da, ");
INSERT INTO ify_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","et emin ida e hi Mahla, hi Tirsah, hi Hoglah, hi Milkah et hi Noah ey inahwa da hu lalakkin agi dan u-ungngan agin amedan ");
INSERT INTO ify_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","helag Manasseh e u-ungngan Joseph. Et mannananeng ni hi-gadan pewen hu puyek ni bineltan da. ");
INSERT INTO ify_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Huyyadda intugun Apu Dios nan Moses et itugun tudda daman edum tun helag Israel eman ni nangkampuan dad nandeklan di Moab di gilig ni Wangwang e Jordan ey demang ni Jericho. ");
INSERT INTO ify_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Huyyan libluh hu neitudekan idan inhel Moses idan helag Israel eman ni wadaddad eleg mebebleyi di appit ni kasimmilin aggew di Wangwang e Jordan. Nangkampuddad man di Nedeklan e Jordan e neihnup di Sup e nambattanan ni Paran et yadda bebley ni Tophel, Laban, Haserot et ya Disahab. ");
INSERT INTO ify_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Ya ustuh dedan ni bilang ni aggew ni pandellanan meippalpud Duntug e Sinai ingganah di Kades Barnea hedin iddalan di Duntug e Seir ey hampulun hakey ni aggew.) ");
INSERT INTO ify_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Yan eman ni nemangulun aggew ni meikkahhampulun hakey ni bulan ni meikkana-pat ni toon neipalpun nalpuan dad Egypt, ey inhel Moses emin hu intugun Apu Dios idan edum tun helag Israel. ");
INSERT INTO ify_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Yan nunman ey negibbuh ni impeapput Apu Dios hi Sihon e patul idan Amorite ni nan-ap-apud Hesbon, et hi Og e patul di Bashan e nan-ap-apud Astarot et yad Edrei. ");
INSERT INTO ify_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Intuttuddun Moses idan helag Israel hu meippanggep idan nunman ni tugun Apu Dios eman ni wadaddad Moab di appit ni kasimmilin aggew di Wangwang e Jordan. ");
INSERT INTO ify_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Kantun hi-gaday “Yan eman ni kaweda tayud Duntug e Sinai ey kan Apu Dios tayuy ‘Nebayag kayu law ni nanha-ad di deya. ");
INSERT INTO ify_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Bukal yu kampu yu et lumaw kayud duntuduntug ni bebley idan Amorite, yaddad nanlinikweh ni bebley diman, yad nandeklan di Jordan, yaddad bebley di dunduntug, yaddad nedeklan ni bebley di appit ni kakelinnugin aggew, di Negeb et yaddad bebley ni wadad gilig ni Baybay e Mediterranean. Ey elaw kayud Kanaan ey labhi yudda duntug di Lebanon ingganah di Wangwang e Euphrates. ");
INSERT INTO ify_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Huyyadda hu bebley ni insapatah kun iddawat kuddan aammed yu e di Abraham, hi Isaac et hi Jacob et yadda helag da. Elaw kayu et yu pambebleyan.’” ");
INSERT INTO ify_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Kan Moses idan etan ni tuu “Yan wada itsu pay nid Duntug e Sinai ey inhel kun hi-gayu e eggak kabaelan ni mengippaptek ni hi-gayun emin. ");
INSERT INTO ify_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Tep impedakkel dakeyun Ap-Apu e Dios yun henin kadinakkel idan bittuwen di kabunyan. ");
INSERT INTO ify_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Hi Apu Dios e Dios idan aammed tayu hu mengippedakkel pay ni hi-gayun meminhanlibu niya hi-gatu memendisyon ni hi-gayu et kumedangyan kayu. ");
INSERT INTO ify_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Nem inna-nuk ni mengippennuh idan yuka panhahallai niya inna-nuk ni umbaddang di ligat yu e hakey yak ni mengippahding? ");
INSERT INTO ify_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Hannemnem yu etan inhel ku lan nunman e kangkuy pampili kayud hanhakkey ni helag Israel idan nelaing, wada kabaelan dan mengewwat, niya kayyaggud elaw da et hi-gada pambalin kun mengipappangngulun hi-gayu. ");
INSERT INTO ify_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ey inebulut yu e ‘Kanyuy kayyaggud humman ni ninemnem kun pehding tayu.’” ");
INSERT INTO ify_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Et humman idan pinili yu hu impambalin kun huwet niya opisyal yu. Et yadda edum ey impambalin kuddan man-ap-apun hanlibun tuu, yadda edum ey man-ap-apun hanggatut, yadda edum ey man-ap-apun nelima et yadda edum ey man-ap-apun hampulu. ");
INSERT INTO ify_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Intugun kuddan nunman ni huwet e kangkun hi-gaday “Mahapul ni meandeng ni ingganah hu pehding yu, beken ni ebuh ida helag Israel, nem anin idan nalpud edum ni bebley ni nekibebley ni hi-gayu. ");
INSERT INTO ify_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ihummangan yun ustuh hu kapandidiklamuhiddan edum yun helag Israel. Entan tu ipahhig idan kedangyan. Mahapul ni man-iingngeh ni meandeng hu pehding yun menuwwet idan kedangyan niya newetwet. Entan takut ni hipan pehding da, tep yuka i-ehneng hi Apu Dios ni pengippennuhan yuddan kasuh. I-li yun hi-gak ida kasuh ni kayu kameliggasin mengippennuh. ");
INSERT INTO ify_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Ey yan nunman inhel kun hi-gayun emin hu hipan lebbeng tun pehding yu.” ");
INSERT INTO ify_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Entanni ey hini-yan tayu hu Duntug e Sinai tep humman inhel Apu Dios e Dios tayun pehding tayu. Et mandalan itsud eleg mebebleyin mahkang, ey anggetakkut e inang-ang tayun emin. Et han itsu mampalaw di duntuduntug e bebley idan Amorite. Dimmateng itsud Kades Barnea et ");
INSERT INTO ify_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","kangkun hi-gayuy ‘Dimmateng itsu law di bebley ni indawat Apu Dios e Dios tayun hi-gatsu. ");
INSERT INTO ify_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ammandeh! Elaw kayu et pambebleyan yu. Entan pandewadewa, niya entan takut yu tep inhel Apu Dios e Dios ida lan aammed tayu, e iddawat tun hi-gayu humman ni bebley.’ ");
INSERT INTO ify_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Nem kanyun hi-gak ey ‘Um-itu-dak itsun an mansi-im et ehelen dan hi-gatsu hedin attu hu kayyaggud ni dellanen tayu, ey hedin hipan bebley hu tayu hehgepen.’ ");
INSERT INTO ify_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ey ya impannemnem kun nunman ni inhel yu ey kayyaggud, et pumili-ak ni hampulut dewwan lalakkin nalpud hanhakkey di helag Israel. ");
INSERT INTO ify_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Limmaw ida e linabhan da etan duntuduntug et datngen da hu Nedeklan e Eskol et da hinapen ni inang-ang humman ni bebley. ");
INSERT INTO ify_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Nengaladdan lameh ni keyew ni in-anemut dan neibangngadan da et kandan hi-gatsuy ‘Kayyaggud ni pambebleyan humman ni indawat Apu Dios e Dios tayun hi-gatsu.’ ");
INSERT INTO ify_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Nem nginhay yu hu inhel Apu Dios e Dios yu tep eleg yu pinhed ni umlaw diman. ");
INSERT INTO ify_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Nangngungudu kayu niya nanlilih kayu e kanyuy ‘Anggebe-hel daitsun Apu Dios, tep impangulu daitsu et hi-yanen tayu Egypt, et i-li daitsudya ma-lat pateyen daitsuddan Amorite. ");
INSERT INTO ify_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Et humman hu, eleg itsu kaya umlaw diman. Endi law tuled tayu, tep yadda intu-dak tayun an nansiim ey kanday etta-ta-gey ida tuudman, niya na-na-let ida nem hi-gatsu. Ey eta-ta-gey hu tuping ni luhud ni bebley da e dettengen tu kabunyan. Ey inang-ang da pay kunu hu etta-teng ni tutu-un helag Anak.’ ");
INSERT INTO ify_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Nem inhel kun hi-gayu e kangkuy ‘Entan takut idan nunman ni tuu, ");
INSERT INTO ify_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","tep ippangulu dakeyun Apu Dios e Dios yu. Hi-gatu mekiggubbat et iehneng dakeyu, henin inang-ang yun impahding tud Egypt, ");
INSERT INTO ify_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","niya impahding tud eleg mebebleyi. Anin ni hi-gayu, ey neka-ang-ang yu hu nengipenaptekan Apu Dios e Dios yun hi-gatsu eyad eleg mebebleyi, henin kapemaptek ni hakey ni aman u-ungnga tu. Et deh e in-ali daitsudya.’ ");
INSERT INTO ify_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","Nem anin ni henin nunman impenahding Apu Dios e Dios tayu e kamambalin ni heni apuy ni hileng, niya kamambalin ni heni kulput ni kawwalwal ni nengipengupengulun hi-gatsuddad kayyaggud ni tayu nangkampuan. Ey eleg yu damengu idinel ni hi-gatu. ");
INSERT INTO ify_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Et humman hu, nemahhig bunget Apu Dios ni nangngelan tun lilih yu et isapatah tu e kantuy ");
INSERT INTO ify_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Endin hekey ni hi-gayun nekalliwtan ni tutu-un nunya hu mategun umlaw ni an menang-ang etan ni kayyaggud ni bebley ni insapatah kun iddawat kudda lan aammed yu. ");
INSERT INTO ify_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Ebuh hi Kaleb e u-ungngan Jephunneh hu dammutun umlaw diman. Iddawat kun hi-gatu et yadda helag tu etan bebley ni tu dindinlan, tep impannanneng tu hu tuka pengu-unnud ni hi-gak.’ ");
INSERT INTO ify_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Gapun hi-gayu ey bimmunget dama hi Apu Dios ni hi-gak et kantuy ‘Anin ni hi-gam Moses et eleg ka mabalin ni umlaw diman. ");
INSERT INTO ify_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Nem petuled mu hi Joshua e u-ungngan Nun e kamemabbaddang ni hi-gam, et hi-gatu mengipengnguluddan etan ni tutu-un mambebley diman.’ ");
INSERT INTO ify_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Entanniy kan Apu Dios ni hi-gatsuy ‘Yadda u-ungnga yun kamenangpa e eleg da pay ni amta hu lawah winu kayyaggud, e hi-gada etan yuka itattakkut ni belluden idan buhul yu, hu umlaw ni an mambebley diman. ");
INSERT INTO ify_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Nem hedin hi-gayu, man meibbangngad kayu e iddalan yu mewan di eleg mebebleyi et mampalaw kayud appit ni Madlang ni Baybay.’ ");
INSERT INTO ify_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Entanni ey kanyun hi-gak ey ‘Nanliwat kamin Apu Dios e Dios tayu, nem umlaw kamin nunya, et kami makigubat ma-lat mambebley kamidda etan di bebley tep humman dedan hu inhel tu.’ Et pan-ihakbat yu almas yu, et lumaw kayun nekigubat tep kanyu nem nelakah hu penggepan yun nunman ni duntuduntug ni bebley. ");
INSERT INTO ify_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Nem kan Apu Dios ni hi-gak ey ‘Ehel mun hi-gada e eleg ida umlaw ni mekiggubbat tep eggak baddangan ida. Hedin umlaw ida, ey nanna-ud ni apputen idaddan buhul yu.’ ");
INSERT INTO ify_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Inhel kun hi-gayu humman ni inhel Apu Dios, nem kahing kayu. Et nealay nanglaw kayun nekigubat idan nambebley diman ni duntuduntug ni bebley e indinel yu annel yu tep nginhay yu hi Apu Dios. ");
INSERT INTO ify_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Neukat idalli hu hantapug ni Amorite e henidda putsukan et gubaten dakeyu, et pampedugen dakeyu meippalpud Seir ingganah di Hormah, et apputen dakeyu etan di duntuduntug ni bebley di Edom. ");
INSERT INTO ify_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Entanni ey nambangngad kayu et mampehemmehemmek kayun mampebaddang nan Apu Dios, nem eleg tu hanguden hu dasal yu, ");
INSERT INTO ify_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","et manhahha-ad itsud Kades Barnea ni nebayag. ");
INSERT INTO ify_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Nambangngad itsu et mampalaw itsud eleg mebebleyid appit ni Madlang ni Baybay, tep humman inhel Apu Dios ni hi-gak ni pehding tayu. Et lumeniklikweh itsud duntuduntug di Edom ni nebayag. ");
INSERT INTO ify_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","3","Entanni ey kan Apu Dios ni hi-gak ey ‘Nebayag kayu law ni limmeniklikweh eyad duntuduntug ni bebley, et yan nunya, ey palaw kayud north. ");
INSERT INTO ify_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ey tugun mudda tutu-u e kammuy: Li-bahi yu Seir e nambebleyan idan Edomite e aaggi yun helag Esau. Umtakut idan hi-gayu, nem ang-ang yu pehding yu, ");
INSERT INTO ify_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ey entan tudda gubat tep indawat kun hi-gada etan ida bebley di nanlinikweh di Duntug e Seir. Endin hekey hu bebley di diman ni nak iddawat ni hi-gayu anin ni ekket, tep humman bineltan Esau. ");
INSERT INTO ify_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Nem dammutun umgatang kayun hi-gadan mekkan niya danum.’ ");
INSERT INTO ify_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Nemnem yu e binendisyonan daitsun Apu Dios e Dios tayud emin ni impenahding tayu. Ey impenaptek daitsud nanhahha-adan tayu eyad mahkang ni eleg mebebleyi, ey wadan hi-gatsun ingganah eyan nelabah ni na-pat ni toon, niya indawat tun emin hu mahapul tayu. ");
INSERT INTO ify_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Intuluy tayun nangnanglaw et labhan tayu hu nambebleyan idan agi tayun helag Esau di Seir, ey eleg tayu idlan di keltad e Arabah e nampatyed ni nalpud Elat niyad Esion Geber. Et yan eman ni nampalaw itsud appit ni north e indalan tayud eleg mebebleyid Moab, ");
INSERT INTO ify_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ey immehel hi Apu Dios e kantuy ‘Ang-ang yu et endi yu pehding ni umhulun ni pekiggubbatan idan iMoab e helag Lot ni hi-gayu, tep indawat ku hu Ar ni hi-gada ey endi nak iddawat ni hi-gayudman ni bebley.’” ");
INSERT INTO ify_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Ya nambebley dedan lan nunman di Ar ey yadda etan Emim e etta-teng niya etta-gey ni tuu. Nan-iingngeh idan helag Anak e etta-teng ida. ");
INSERT INTO ify_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Huyyaddan Emim et ya helag Anak hu kamengeddanin Repaim, nem ya kapangngedan idan iMoab ni hi-gada ey Emim. ");
INSERT INTO ify_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Yan nunman la ey yadda Horite hu nambebley di Seir, nem dinegyun idan helag Esau. Binahbah da humman ni bebley et han ida maihullul ni nambebley diman henin impahding idan helag Israel, e dinegyun dadda nambebley di Kanaan tep indawat Apu Dios humman ni pambebleyan da.) ");
INSERT INTO ify_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Et man-agwat itsud Kulukul e Sered, tep humman inhel Apu Dios ni pehding tayu. ");
INSERT INTO ify_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Yan nunman ni nan-agwatan tayu ey nelabah hu telumpulut walun toon neipalpu eman ni dintengan tayud Kades Barnea. Yan nunman ni tsimpuh ey netey ida law ni emin etan lalakkin dammutun mekiggubbat, tep humman dedan hu insapatah lan Apu Dios. ");
INSERT INTO ify_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Nemahhig hu impahding Apu Dios ni hi-gada ingganah netey idan emin. ");
INSERT INTO ify_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Netey ida law emin a-ammed yu ");
INSERT INTO ify_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ey kan Apu Dios ni hi-gak ey ");
INSERT INTO ify_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Hi-yan yu Moab nunyan aggew. Idlan yud Ar e pappeg tu, ");
INSERT INTO ify_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","et lumaw kayud nambebleyan idan Ammonite e helag Lot, nem entan tudda gubat, tep endi nak iddawat ni hi-gayun ni puyek diman tep indawat kun hi-gada humman ni bebley.’” ");
INSERT INTO ify_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Humman ni bebley ey Repaim la ngadan tu e humman hu ngadan idan lan nambebley diman. Ey ya kapangngedan ni Ammonite ni hi-gada ey Samsummim. ");
INSERT INTO ify_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Eta-ta-gey ida Rapaim e heniddan Anakim. Dakel ida ey nangka-let ida, nem binahbah idan Apu Dios, et maihullul ida Ammonite ni nambebley di bebley da. ");
INSERT INTO ify_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Hanniman dama impahding Apu Dios idan Horite ni nambebley di Seir e binahbah tudda, et pambebleyan idan Edomite e helag Esau humman ni bebley da. Et hi-gada mambebley diman ingganah nunya. ");
INSERT INTO ify_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Hanniman dama impahding idan nalpud Crete e ginubat dadda Abbite, et bahbahen dadda et maihullul idan nambebley di Gaza e bebley da.) ");
INSERT INTO ify_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Yan linabhan tayu Moab ey kan Apu Dios ni hi-gatsuy ‘Agwat yu eya Wangwang e Arnon et yu gubaten hi Sihon e Amorite e patul di Hesbon yaggud pengapput dakeyun hi-gak et hi-gayu mambebley di nambebleyan da.’ ");
INSERT INTO ify_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Kan tu pay ey ‘Meippalpun nunya ey pambalin kun tekkutan dakeyuddan emin ni tutu-un mengngel ni meippanggep ni hi-gayun helag Israel, et anin ni ngeddanen dan ebuh ngadan yu, ey umgeyenggeng idan takut da.’ ");
INSERT INTO ify_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Ey yan wada itsu etan di eleg mebebleyid Kedemot, ey nenu-dakkak ni an mekihhummangan nan Sihon e patul di Hesbon, ma-lat kayyaggud hu pandadagyuman tayu. ");
INSERT INTO ify_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Kangkuy ‘Iebulut mu anhan ni mandellan kami eyad bebley yu. Anin ni unnuunnuden mi hu keltad e eleg mi ihhingngid payew di wannan winu willi. ");
INSERT INTO ify_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Beyyadan min hi-gayu emin hu mekkan niya meinnum ni ellan mi. Ya mika ibbagan ebuh ey i-abulut mun mandellan kami eyad bebley yu ");
INSERT INTO ify_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","henin impahding idan helag Esau ni nambebley di Seir, et yadda Moabite ni nambebley di Ar e in-abulut da et mandalan kamid bebley da et malebah kami et man-agwat kamid Jordan et lumaw kamid bebley min indawat Apu Dios e Dios mi.’ ");
INSERT INTO ify_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Nem eleg iebulut Sihon e patul di Hesbon ni tayu iddalan di bebley da. Mukun hanniman ey tep hi Apu Dios e Dios tayu ey impambalin tun manghay, ma-lat wada umhulun ni panggugubatan tayu, et peapput tun hi-gatsu. Et deh, e humman tu-wangu impahding tu. ");
INSERT INTO ify_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Entanni ey kan Apu Dios ni hi-gak ey ‘Peapput kun nunya hi Sihon e patul ey iddawat ku bebley dan hi-gayu. Et humman hu, lakkayuy et yu gubaten et pambebleyan yu bebley da.’ ");
INSERT INTO ify_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Et yan wada itsud Jahas, ey immali hi Sihon, niyadda sindalu tu et gubaten daitsu. ");
INSERT INTO ify_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Nem impeapput idan Apu Dios e Dios tayu et pateyen tayu hi Sihon e patul da, yadda u-ungnga tun lalakki niyadda sindalu tu. ");
INSERT INTO ify_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ey binahbah tayu bebley da ey nampatey tayudda bimmebley, yadda lalakki, yadda bibi-i niyadda kaungaunga et endin hekey hu natdaan. ");
INSERT INTO ify_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Inla tayudda animal da niya emin ni nebalol ni wadad bebley da. ");
INSERT INTO ify_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Binaddangan daitsu mewan nan Apu Dios e Dios tayu, et sakupen tayu hu Aroer di gilig ni Nedeklan e Arnon, et yadda bebley ni neigawwad Arnon ingganah lad Gilead. Emin ida humman ni bebley ni nehammad luhud tu ey kinabaelan tayun hinggep. ");
INSERT INTO ify_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Nem eleg itsu mampalaw di nambebleyan idan Ammonite, yaddad bebley di gilig ni Wangwang e Jabbok, yaddad bebley di duntuduntug et yad emin ni bebley ni inhel Apu Dios e Dios tayun eleg tayu lawwi. ");
INSERT INTO ify_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Entanni et mampalaw itsud Bashan ey dinammu daitsun Og e patul diman e impangulu tu sindalu tu et gubaten daitsud neihnup di Edrei. ");
INSERT INTO ify_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Nem kan Apu Dios ni hi-gak ey ‘Entan takut ni hi-gatu tep peapput kun hi-gayu tutu-u tu niya pebeltan kudda bebley tu. Ipahding yun hi-gatu hu henin impahding yun Sihon e patul idan Amorite di Hesbon.’ ");
INSERT INTO ify_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Ey humman neipahding e impeapput Apu Dios e Dios tayu hi Og et yadda sindalu tu e pintey tayuddan emin. ");
INSERT INTO ify_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Et hegepen tayudda etan na-nem ni bebley di Argob di Bashan e nampatulan tu, ");
INSERT INTO ify_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Ey anin ni etta-gey niya nangkehammad ni neluhud hu nanlinikweh nunman ni etta-teng ni bebley niya nehammad eheb da ey hinggep tayu. Ey hinggep tayu pay ida etan bebley diman ni eleg maluhud. ");
INSERT INTO ify_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Et bahbahen tayudda bebley diman niya pintey tayudda bimmebley ni lalakki, yadda bibi-i, niyadda kaungungan henin impahding tayud kebebbebley di nan-ap-apuan Sihon e patul di Hesbon. ");
INSERT INTO ify_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ey nan-ala tayu animal niya emin ni hipan wadadman e bebley. ");
INSERT INTO ify_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Et yan nunman ey sinekup tayu humman idan bebley ni dewwan patul idan Amorite di appit ni kasimmilin aggew di Wangwang e Jordan meippalpud Wangwang e Arnon ingganah di Duntug e Hermon. ");
INSERT INTO ify_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Hedin ya kapangngeddan idan Sidonian ni Duntug e Hermon ey Sirion. Ey hedin yadda dama Amorite Senir hu daka pangngeddan.) ");
INSERT INTO ify_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Sinekup tayun emin hu bebley Og e patul di Bashan, humman ida ey bebley di ta-pew ni duntug,