﻿USE sofia;
DROP TABLE IF EXISTS sofia.ifu_vpl;
CREATE TABLE ifu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ifu_vpl WRITE;
INSERT INTO ifu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hay hato chi napfulog an himpangapo an narpugwan Hesu Kristo an holag Ari David an narpu ay Abraham. ");
INSERT INTO ifu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nunholag hi Abraham ta hi Isaak. Nunholag hi Isaak ta hi Jakob. Nunholag hi Jakob ta hi Judah ja chin a-akhi na an linala-e. ");
INSERT INTO ifu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ja nunholag cha Judah ay Tamar ta cha Perez ja hi Zerah. Nunholag hi Perez ta hi Hezron. Nunholag hi Hezron ta hi Ram. ");
INSERT INTO ifu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ja nunholag hi Ram ta hi Aminadab. Nunholag hi Aminadab ta hi Nashon. Nunholag hi Nashon ta hi Salmon. ");
INSERT INTO ifu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ja nunholag cha Salmon ay Rahab ta hi Boaz. Nunholag cha Boaz ay Ruth ta hi Obed. Nunholag hi Obed ta hi Jesse. ");
INSERT INTO ifu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ja nunholag hi Jesse ta hi David an hija chin Arin chi Israel. Nunholag cha Ari David ay Batsheba an namalo ay Uriah ta hi Solomon. ");
INSERT INTO ifu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ja nunholag hi Solomon ta hi Rehoboam. Nunholag hi Rehoboam ta hi Abijah. Nunholag hi Abijah ta hi Asa. ");
INSERT INTO ifu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ja nunholag hi Asa ta hi Jehoshafat. Nunholag hi Jehoshafat ta hi Joram. Nunholag hi Joram ta hi Uziah. ");
INSERT INTO ifu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ja nunholag hi Uziah ta hi Jotam. Nunholag hi Jotam ta hi Ahaz. Nunholag hi Ahaz ta hi Hezekiah. ");
INSERT INTO ifu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ja nunholag hi Hezekiah ta hi Manaseh. Nunholag hi Manaseh ta hi Amos. Nunholag hi Amos ta hi Josiah. ");
INSERT INTO ifu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ja nunholag hi Josiah ta hi Jekoniah ja chin a-akhi na. Ja metongor chin timpon Jekoniah chin nangapfakan hachi eBabilon hay hachi Hudju ja enekak cha chicha ad Judea ta in-uy cha ad Babilon. ");
INSERT INTO ifu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chin agawwachaan cha ad Babilon, ja nunholag hi Jekoniah ta hi Shealtiel. Nunholag hi Shealtiel ta hi Zerubabel. ");
INSERT INTO ifu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ja nunholag hi Zerubabel ta hi Abiud. Nunholag hi Abiud ta hi Eliakim. Nunholag hi Eliakim ta hi Azor. ");
INSERT INTO ifu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ja nunholag hi Azor ta hi Zadok. Nunholag hi Zadok ta hi Akim. Nunholag hi Akim ta hi Eliud. ");
INSERT INTO ifu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ja nunholag hi Eliud ta hi Eleazar. Nunholag hi Eleazar ta hi Mattan. Nunholag hi Mattan ta hi Jakob. ");
INSERT INTO ifu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ja nunholag hi Jakob ta hi Josep an ahagwan Mary an hijay nangtoꞌkhong ay Hesus an ma-ali hi Kristo. ");
INSERT INTO ifu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hotti himpolo ta apat hana napfulog an himpangapo nete-a ay Abraham ingkhana ay Ari David. Ja himpolo ta apat khu nete-a ay Ari David ingkhanah chin nangpakakan cha ay chicha ta immuy cha ad Babilon. Ja himpolo ta apat khu hana napfulog an himpangapo nete-a chin agawwachaan cha ad Babilon ingkhanah chin nituꞌkhungan Kristo. ");
INSERT INTO ifu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Amat heto chin nituꞌkhungan Hesu Kristo an empfalay Mary. Nihahhapit hi Mary an ahagwaon Josep. Agkhuy cha pay tenom-on ja inannilan Mary an nunhapfin hija khapo ay ni apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naꞌna-unnud hi Josep hana urchin chi Hudju, muti achi na podhon an pfa-inan hi Mary. Hotti hay nenomnom na an aton ja un amat hina an ma-id ar-ali ja tenaynana hi Mary. ");
INSERT INTO ifu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Khuna nomnomnomon hitay an aton muti enenop na hi nalo-ana ja tinnig na han angher Apo Jos an nangali hi, “Josep an holag Ari David, achi a mun-ub-ubjah an manget-on ay Mary. Ti nunhapfin hija khapo ay ni apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hot etoꞌkhong na han lala-e ja hay epengachan mu ja hi Hesus, ti hija hini manakhu hi tatakhu na ta achi cha matoy khapoh pfahor cha.” Hitay chi inalin chin angher. ");
INSERT INTO ifu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na-at an amin hay hato ta nipa-annung chin inalin Apo Jos an impadtun profeta Isaiah, ");
INSERT INTO ifu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","chin nangarjana hi, “Munhapfin han pfupfai an ma-id oh-ohhah lala-e nangeloꞌ ay hija, hot etoꞌkhong na han lala-e an mangadnan hi Emanuel.” Hitay podhona an hapiton ay tay ngachan an Emanuel ja hi Apo Jos ja gawwacha ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Enelan Josep ja inunud na chin inalin chuy angher. Hotti entoloy na an nanget-on ay Mary ");
INSERT INTO ifu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","muti nungkhipid hi Josep ingkhanah netoꞌkhong chin empfalay Mary an lala-e. Ja nginadnan Josep hija hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Netoꞌkhong hi Hesus ad Betlehem an provincian chi Judea, an nun-ap-apugwan Ari Herod. Ja gwacha han mun-anomnom an linala-e an narpu hichi pfutajan omarkhaw ja immuy cha ad Jerusalem. Ja khun cha epfokha hachi tatakhu hi, ");
INSERT INTO ifu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Chaad mah hinuy unga an netoꞌkhong an Ari ju an Hudju? Ti tinnig mi han pfittuwan hichi pfutajan omarkhaw an hinjar ni nituꞌkhungana, hijaot un ami immali ta i mi dayawon hija.” ");
INSERT INTO ifu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Unot chengngor Ari Herod hitay khun allon hachi linala-e, ja napukhit hi punnomnomana, ja amat khu hina an amin hachi tatakhu ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Empa-ajag Herod an amin hana a-ap-apon chi papachi ja hana memehtolon chi urchin Moses, ja empfokha na nu ngay pituꞌkhungan ni Hennag Apo Jos an Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tempfar cha ja inali cha hi, “Metoꞌkhong ad Betlehem an provincian chi Judea. Ti amat heto chin impatulaꞌ Apo Jos ay profeta Micah hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hichuy pfuglay ad Betlehem an provincian chi Judea, ja achi matalili-an ti mumpfalin hi ma-ar-ali an pfuglay. Ti gwa han mun-ap-apo an marpu ad Betlehem an mangpaptoꞌ hana tatakhuꞌ an holag Israel.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Amat hichi ja empa-ajag Ari Herod hachi mun-anomnom an linala-e ta un cha umi-igway ta enhanhana ay chicha nu aꞌ-anuna chin nahhun an nannikhan cha chin pfittuwan. ");
INSERT INTO ifu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Napfalin ja hennag na chicha an umuy ad Betlehem ja inali na hi, “Umuy aju ta ep-ephod ju an i hingiton hinuy an unga. Chinakngan ju ayya ja numpfangngad aju ta ipa-innila ju ay ha-in ta miꞌjujaꞌ khu an i mundayaw ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Napfalin an chengngor cha hitay inalin Ari Herod ja entoloy cha an umuy ta i cha hingiton hichin unga. Ja tinnig cha khu chin pfittuwan an narpu hichi pfutajan omarkhaw, ja achi anhan chin an-anla cha. Ja khun cha un-unuchon chin pfittuwan ingkhana hi intaꞌchug na chin agawwachaan chin unga. ");
INSERT INTO ifu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Himmikhop cha ay chuy an pfalay ja tinnig cha chin unga ja hi Mary an ammod na. Nunheppe cha an nundayaw ay hija ja nun-ipapfutay cha hachi isagot cha an pfalituꞌ, ja insenso, ja mira. ");
INSERT INTO ifu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ja numpa-enop hi Apo Jos ay chicha ja inali na hi achi cha mumpfangngad ay Ari Herod. Hotti empacheh cha an umanamut an nab-on chin enenggwa cha. ");
INSERT INTO ifu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nakak hachi linala-e ja nun-enop khu hi Josep ja tinnig na han angher Apo Jos. Ja inalin chin angher hi, “Pfumangon a ta ipfakgwit mu hini unga ja hi ina na. Umuy aju ad Egypt ja nihihidchi aju ingkhana hi ha-in chi mangali hi mumpfangngad aju. Ti tan hay nenomnom Ari Herod ja honakhona hana umali an maningit ay tay unga ta epapatoy na.” ");
INSERT INTO ifu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hotti pfimmangon hi Josep ja enekak na chin unga ja hi Mary ay chuy an lapfi, ja immuy cha ad Egypt. ");
INSERT INTO ifu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja nihihidchi cha ingkhanah chin natajan Ari Herod. Na-at hay hato ta mipa-annung chin inalin Apo Jos an impadtun han ohan profeta hi nangarjana hi, “Ajakhaꞌ hini empfalay u ta makak ad Egypt.” ");
INSERT INTO ifu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Unot inannilan Ari Herod an un pfinarpfalijan hachi mun-anomnom an linala-e hija ja nunhegla chin pfungot na. Hennag na hachi hinchalo na ta umuy cha ad Betlehem ja hana nun-ehnot an pfuglay ta i cha patajon an amin chi ung-ungungnga an linala-e an chugway tagwona ja mumpababa. Ti impa-innilan hachi mun-anomnom an linala-e chin timpo an nituꞌkhungan ni unga. ");
INSERT INTO ifu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na-at hitay ta mipa-annung chin impadtun profeta Jeremiah hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gwa han mun-okhab an magngor ad Ramah, an kumila ja omepfer. Hi Rakel ja khuna kilaan hachi empfapfalay na. Ja achi na podhon an mumpa-ay-ajub ti nun-atoy cha.” ");
INSERT INTO ifu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nihihidchi cha pay ad Egypt chin natajan Ari Herod. Nun-enop khu hi Josep ja tinnig na han angher Apo Jos. Inalin chin angher hi, ");
INSERT INTO ifu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Pfumangon a ta ekak mu hini unga ja hi ina na, ta mumpfangngad aju ad Israel. Ti natoy hini mamhod an mamatoy ay ni unga.” ");
INSERT INTO ifu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hotti pfimmangon hi Josep ja empacheh cha an mumpfangngad ad Israel. ");
INSERT INTO ifu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Muti chengngor Josep an hi Arkelaus an empfalay Herod chi nepallog an mun-ap-apo ad Judea, ja temma-ot an mumpfangngad hichi. Numpa-enop khu hi Apo Jos ja inali na hi achi cha umuy ad Judea ta un cha umuy ad Galilee. Ja inunud Josep. ");
INSERT INTO ifu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Immuy cha ad Nazaret an provincian chi Galilee. Hot nipa-annung chin inalin hachi profeta an “Ma-ali hija an oha an eNazaret.” ");
INSERT INTO ifu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ay chuy an timpo ja immuy hi John Bautista hichi let-ang ad Judea an khun i mangaskasaba. Ja hay khuna allon ja, ");
INSERT INTO ifu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Muntutuju aju ja chin-ug ju hana pfahor ju. Ti achi mapfajag hot machakngan hini Pun-ap-apugwan Apo Jos hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hitay an hi John ja hija chin impadtun profeta Isaiah ay tay intulaꞌ na an nangarjana hi, “Gwa han khun mun-ugwap hichi let-ang an khuna allon hachi tatakhu hi, ‘Epaphod ju hini agwun ni umali an Apo. Anchongon ju hana nakillokillo an chalan ta maphod hi agwuna.’” ");
INSERT INTO ifu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Han lopfong John ja na-apfor an chutchut chi kemer, ja chin pfalekeh na ja lalat. Hay khuna ijilog ja chuchun ja chilu. ");
INSERT INTO ifu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ja cho-ocho-or chin tatakhu an narpu ad Jerusalem ja hana apfuglapfuglay ad Judea ja an amin hana pfuglay an nun-ehegkhon ay chuy gwanggwang an Jordan an immuy chin agawwachaan John. ");
INSERT INTO ifu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Khun cha ipudnu hana pfahor cha hon numpabautisar cha ay John hichi gwanggwang an Jordan. ");
INSERT INTO ifu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ja cho-or hachi Farisee ja Saducee an niꞌjuy ta i cha meꞌpabautisar ay John. Unaagkhu tinnig chicha ja inali na hi, “Chaꞌju an lomahlalahlah! Ngay nangali hi mapfalin an mergwang aju ay ni pundusaan Apo Jos hana pfimmahor? ");
INSERT INTO ifu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Achi mapfalin, ti mahapor an aton juy maphod an mangpatikhaw an umannung an chin-ug ju hana pfahor ju. ");
INSERT INTO ifu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ja achi ju punhohodlanan an miꞌtakhu khapo ta holag chaꞌju ay Abraham. Hay alloꞌ ay chaꞌju ja anong un hato pfato ja mapfalin an pumpfalinon Apo Jos hi holag Abraham ta maparkhan aju! ");
INSERT INTO ifu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hini Punhugijan Apo Jos ja amat hi gwahay an lenallajat ni munli-oy hi ajiw. Ti an amin chi ajiw an achi maphod chi pfunga na ja mali-oy ta mituud ay ni apoy hot mapoolan. Ja amat hina hini umali an adusaan ju. ");
INSERT INTO ifu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gwa han umali an metob ay ha-in ja munnaud an napfagpfagto. Ja achi mapfalin an ipadchungaꞌ ay hija. Ha-in ayya ja bautisaraꞌ chaꞌju hi chanum ta matikhaw an chin-ug ju hana pfahor ju, muti hija ja bautisaran chaꞌju hi Espiritu Santo ja apoy. ");
INSERT INTO ifu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ja toꞌnona hay hana namati ay cha nuy agkhuy namati an amat ay ni muntaap an etapar na hini chukhi ta mataynan hini pfokhah. Ja enorpfong na hini pfokhah ja penoolana hini chukhi hi apoy an achi madmachop.” ");
INSERT INTO ifu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Amat hichi ja nakak hi Hesus ad Galilee ja immuy ay John hichi gwanggwang an Jordan ta i meꞌpabautisar. ");
INSERT INTO ifu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Achi podhon John an hijay mumbautisar ay Hesus ja inali na hi, “Ha-in koma chi mumpabautisar ay he-a, ta pfu-un agkhu he-a chi mumpabautisar ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tempfar Hesus ja inali na hi, “Achi a mun-okhon, ta ad ugwani ja aton ta an amin chi magpong an penhod Apo Jos.” Hotti inapfulut John ja binautisarana. ");
INSERT INTO ifu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Napfalin an nabautisaran hi Hesus, ja chimma-ar ja nipfughor ad langit. Tinnig na chin Espiritu Santo an nun-ohop an amat hi kaloma chin tikhaw na, ja numpattoꞌ ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ja gwa han chengngor cha an hapit an narpu ad langit an nangali hi, “Hitay hini podpodhoꞌ an Empfalay u. Mun-an-anlaaꞌ khapo ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Napfalin an nabautisaran hi Hesus ja enedchong ni Espiritu Santo an umuy hichi let-ang ta toptopngan Satanas. ");
INSERT INTO ifu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Agkhuy nangnangan hi Hesus hi apat chi poloh arkhaw hotti hemmenaang. ");
INSERT INTO ifu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ja immuy hi Satanas an i manopngan ay hija ja inali na hi, “He-a jaꞌ hini Empfalay Apo Jos. Hotti allom hay hato pfato ta mumpfalin cha hi tenapay ta gway anum.” ");
INSERT INTO ifu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tempfar Hesus ja inali na hi, “Achi. Ti allona ay ni hapit Apo Jos hi, ‘Pfu-un hini anun ja angkhay chi atakhuwan chi takhu, ti mahahapor khu an amin hini hapit an marpu ay Apo Jos ja un gway piꞌtakhuwan.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Amat hichi ja initnud Satanas hi Hesus ja immuy cha ad Jerusalem an nasantuwan an siudad, ja i cha numpattoꞌ chin Templo. ");
INSERT INTO ifu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ja inalin Satanas ay hija hi, “He-a jaꞌ hini Empfalay Apo Jos, hotti omaꞌpfaw a. Ti allona ay ni Hapit Apo Jos hi, ‘Honakhon Apo Jos hana angher na ta halimunan chi-a, ja tapajaon chi-a hot achi a mepahpah hi pfato.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tempfar Hesus ja inali na ay Satanas hi, “Achi, ti achiꞌ podhon an toptopngan hi Ama. Ti nitulaꞌ khu ay ni Hapit Apo Jos an allona hi, ‘Achim toptopngan hi Apo Jos an Apom.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Initnud khu Satanas hi Hesus ja immuy cha han pfuludna an nataꞌnang hi munnaud, ja impatikhaw na an amin hana numpfino-ob-on an pun-ap-apugwan heto lota ja hini enachangjan cha. ");
INSERT INTO ifu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ja inali na ay Hesus hi, “An amin hay hato an pun-ap-apugwan ay tay lota ja ichat u ay he-a nu munheppe a an mundayaw ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tempfar Hesus ja inali na hi, “Makak aot, Satanas! Ti allona ay ni hapit Apo Jos hi, ‘Hi Apo Jos an Apom chi edaydayaw mu ja unuchom ja angkhay.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amat hichi ja nakak hi Satanas. Ja immuy hachi angher Apo Jos an nanulungan ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Unagkhu chengngor Hesus an nipfalud hi John Bautista ja numpfangngad ad Galilee ");
INSERT INTO ifu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","muti agkhuy numpfangngad ad Nazaret, an i neꞌheto ad Kapernaum an nehnot hichi Baybay ad Galilee ja hajop chin lota an inchat Apo Jos chin holag cha Zebulun ja holag Naftali. ");
INSERT INTO ifu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Amat hichi ja nipa-annung chin inalin Apo Jos an impadtun profeta Isaiah hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ad Galilee an gwachaan hachi holag cha Zebulun ja holag Naftali, an negpong ay ni baybay an chammang ni gwanggwang an Jordan ja hijay gwachaan hana Hentil. ");
INSERT INTO ifu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hachi tatakhu hichi ja napfajag an naheherngan chi piꞌtakhuwan cha, muti mahilagwan cha ad ugwani han mumpfinang an hilaw. Hichuy pfuglay cha an naherngan an amat ad Chalom ja nahilagwan ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nete-a ay chuy ja ente-an Hesus an khun mangaskasaba an khuna allon hi, “Muntutuju aju ja chin-ug ju hana pfahor ju. Ti achi mapfajag hot machakngan hini Pun-ap-apugwan Apo Jos hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gwa han ohan arkhaw an khun chumalan hi Hesus hichi pingngit ni Baybay ad Galilee, ja gwa han tinnig na an chugwa an linala-e an hin-akhi, an cha Simon an nangadnan hi Peter, ja hi Andrew an ibpfa na. Gwa an khun cha manapfukur ti tamu chay mangachiw. ");
INSERT INTO ifu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ja niꞌhapit hi Hesus ja inali na hi, “Umali aju ta mitnud aju ay ha-in, ta gway honakhoꞌ an i mun-ajag hana tatakhu ta miꞌ-unud cha ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Amat hichi ja tenaynan cha hachi tapfukur cha ja nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Empacheh cha an umuy ja tinnig Hesus han chugwa khu an linala-e an hin-akhi, an cha James ay John an empfalay Zebedee. Inu-umpfun cha an hen-a-amma ay chuy pfalangay cha an khun cha ephod hachi tapfukur cha. Enajakhan Hesus cha chuy an hin-akhi, ");
INSERT INTO ifu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ja tenaynan chaot chin pfalangay ja hi ama cha, ja nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Immuy hi Hesus hana apfuglapfuglay ad Galilee an i nuntudtuchu hana sinagogan chi Hudju. Ja engkasaba na hini Ebanghelyo an mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos ay tay lota. Ja khuna epatenong an amin chi chokhoh ja likhat cha. ");
INSERT INTO ifu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nunchongor hay hato khuna aton an amin ad Syria, hotti in-uy cha ay hija hachi mumpunchokhoh ja hachi mumpunlikhat an nun-ahuꞌlungan ja mumpun-orchah ja nun-apechoy. Ja empatenong Hesus chichan amin. ");
INSERT INTO ifu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cho-ocho-or cha an nakhagong an narpu ad Galilee ja hachi himpolo an pfuglay an nangadnan hi Dekapolis, ja ad Jerusalem, ja ad Judea, ja hachi apfuglapfuglay hichi chammang ni gwanggwang an Jordan, ja ninitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Unot tinnig Hesus hachi atakhutakhu an nakhagong ja nunti-id han pfuludna ja inumpfun. Ja immuy hachi disipolo na ay hija ");
INSERT INTO ifu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ja ente-a na an muntudtuchu. Inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Akhaꞌkhaja hana tatakhu an mangapfulut an ma-id olog cha an mangat hi maphod nu achi tomolong hi Apo Jos, ti chichay midchum ay ni Pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Akhaꞌkhaja hana tatakhu an kumila an muntutuju hi pfahor cha ti ichat Apo Jos chi pun-ar-alenagwaan chi nomnom cha. ");
INSERT INTO ifu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Akhaꞌkhaja hana tatakhu an napakumbaba ti meꞌpfanoh cha hay hana mun-aphod an ingkarin Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Akhaꞌkhaja hana tatakhu an munhenaang ja ma-ugaw an mangat hi magpong, ti mapnek cha. ");
INSERT INTO ifu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Akhaꞌkhaja hana tatakhu an gway nignikha na ti nignikhaon khu Apo Jos chicha. ");
INSERT INTO ifu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Akhaꞌkhaja hana tatakhu an e-ohha chay nomnom cha ay ni penhod Apo Jos, ti tikhan cha hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Akhaꞌkhaja hana tatakhu an mangipanuh hi pun-oh-ohhaan chi tatakhu, ti ma-ali cha an empfapfalay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Akhaꞌkhaja hana tatakhu an maparpalikhat khapo hi pangatan cha hana magpong an penhod Apo Jos, ti midchum cha ay ni Pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Akhaꞌkhaja aju nu pahigwon ja pinarpalikhat chaꞌju ja un cha tugwali luti-on hon nun-epa-abpfa chay pfahor ay chaꞌju khapo hi niꞌ-unuchan ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mun-an-anla aju nu ma-at hay hato, ti gwacha han lagpfu ju an napfalor an enchachaag Apo Jos hichi ad langit. Nomnomon ju an hija khu chi enat cha hay hachi profetan Apo Jos chin nahop.” ");
INSERT INTO ifu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Inalin khu Hesus hi, “Chaꞌju an khun miꞌ-unud ay ha-in ja khenong aju hi ahin hay hana tatakhu ay tay lota. Muti nu achi ju etoloy an miꞌ-unud ja hihiya aju ay ni penomhaw an ahin an ma-id mahpay tamtam na. Penomhaw ayya ja achi mi-ahin ja ma-id herpfi na, hotti un metapar ja ilait chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Amat aju khu hi hilaw an khun manilagwan hana tatakhu ay tay lota. Nomnomon ju an hini pfuglay an gwa hi panpantotoꞌ chi pfulludna ja maꞌ-attikhaw ti ma-id munhalin. ");
INSERT INTO ifu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Achi ta-o torkhan hay panor ja i ta-o halinan, ta un ta-o gwot epattoꞌ hay napataw ta an amin hana humikhop ay nuy an pfalay ja mahilagwan cha. ");
INSERT INTO ifu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Amat hina khu an matikhaw koma hana mun-aphod an khun ju aton ta munhilaw aju, ta dayawon chi tatakhu hi Apo Jos an Ama ju an gwa ad langit.” ");
INSERT INTO ifu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Inalin khu Hesus hi, “Unchani ja khemhon ju hi unaꞌ immali an mangpaꞌ-igwin hay hana urchin Apo Jos ja hana intudtuchun hachi profetan Apo Jos. Muti achi an hay immaliyaꞌ ja ta mipa-annung hay hato. ");
INSERT INTO ifu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Umannung hitay alloꞌ ay chaꞌju an ma-upfah hitay lota ja ad uchu muti achi ma-ub-upfah hay hato urchin Apo Jos, anong un hay it-ittang hi nikhulit, ingkhanah ma-at an amin chi nitulaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hotti hana mangpaꞌ-igwin hi oha ay cha tay an urchin, anong un hini it-ittangan, ja tinuchugwan cha khu hana uchumna ta peꞌ-at cha, ja chichay nababa ay ni Pun-ap-apugwan Apo Jos. Hana ayya mangunud ay cha tay an urchin ja tinuchugwan cha hana uchumna ta unuchon cha, ja chichay natakhay ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hay alloꞌ ay chaꞌju ja mahapor an ilahiyan ju hachi Farisee ja memehtolon chi urchin Moses ay ni magpong an piꞌtakhuwan ju. Ti achi ju ayya ja achi aju midchum ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ja inalin khu Hesus hi, “Chin khun cha itudtuchu chin nahop ja, ‘Achi aju pomatoy, ti hana pomatoy ja mechalom cha hot madusa cha.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Muti hay alloꞌ ay chaꞌju ja, anong un hay pfumungtan hi ibpfah takhu ja madusa. Hini mangali ay ni ibpfa na an takhu hi, ‘Ma-id inherpfim’ ja hugijon chi Sanhedrin. Ja hini mangali hi ‘Un a nagwonggwong’ hot madusa ad impferno an gwachaan chi apoy. ");
INSERT INTO ifu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hotti, gwa ayya chi in-uy mu hichi Templo an i idaton ay Apo Jos ja nenomnom mu an gway enat mu hi pukhiton chi ibpfam ay he-a, ");
INSERT INTO ifu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ja egwallang mu hini im idaton ta mumpfangngad a ta i ju epfanag hini pukhitona ay he-a. Napfalin ayya ja un mu etoloy an i mundaton. ");
INSERT INTO ifu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nu khulat ta gway mangchalom ay he-a ja itnud chi-a an umuy hichi korti ja hay maphod hi atom ja epacham gwot an epfanag hini pfahor mu ay ni nangchalom ay he-a ta achi khahin un chi-a ijuy ay ni hugi. Ti nu achim ayya aton heto hot echalom chi-a ay ni hugi. Ja hini hugi ja ichat chi-a ay ni pulih ta ipipfalud chi-a. ");
INSERT INTO ifu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ja alloꞌ ay he-a an achi chi-a ipapfutay hi pfaluchan ingkhana hi pfajacham an ami-amin hini mortam.” ");
INSERT INTO ifu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Entoloy khu Hesus an nangali hi “Chengngor ju khu hitay khun cha itudtuchu chin nahop an ‘Achi aju umilugtap.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Muti hay alloꞌ ay chaꞌju ja anong mangkay un hini aton ni lala-e an mannig ay ni pfupfai ja khuna nomnomon hini podhona an aton, ja hihiya an neꞌkammalala. ");
INSERT INTO ifu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nu hini agwan an matam chi chumalat hi pfumahulam ja toꞌ-onot un mu u-iton ja entapar mu. Ti anongkay ja ma-id hini oha an mata ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway mata ja mituud chamchama an amin hini achor mu ad impferno. ");
INSERT INTO ifu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja nu hini agwan an ngamoy mu chi chumalat hi pfumahulam ja toꞌ-onot un mu potnan. Ti anongkay ja ma-id hini oha an ngamoy ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway ngamoy ja mituud chamchama hini achor mu ad impferno.” ");
INSERT INTO ifu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Inalin khu Hesus hi, “Hay oha khu an khun cha ituchu chin nahop ja, ‘Hini lala-e an manghijan hi ahagwa na ja mahapor an gway mapermaan hi tulaꞌ an nunhijan cha ta u-ugnan ni pfupfai.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Muti hay alloꞌ ay chaꞌju ja, nu khulat ta hini pfupfai an agkhuy na inlugtap hini ahagwa na ja achi khulaton ni lala-e an ihijan hini pfupfai. Ti atona ayya, ja hijay chumalat hi umilugtapan ni pfupfai hi un marhin hi uchumna. Ja hay lala-e an mangahagwa hi pfupfai an nihijan, ja hihiya an immilugtap.” ");
INSERT INTO ifu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Inalin khu Hesus hi, “Hay oha khu hi khun itudtuchun hachi tatakhu chin nahop ja, ‘Achi ju paꞌ-iyon hay enhapata ju. Mahapor an aton an amin hana enhapata ay ni ngachan Apo Jos.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Muti hay alloꞌ ay chaꞌju ja achi aju koma munhapata. Achi aju koma munhapata an ad langit chi ehapata ju, ti hijay trono an inu-umpfunan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Achi aju khu munhapata an hitay lota chi ehapata ju, ti hijay nangchachaꞌ-angan Apo Jos. Achi aju khu munhapata ay ni ngachan an Jerusalem, ti hijay pfuglay ni Napfagpfagto an Ari an hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Achi aju khu munhapata ay ni ulu ju, ti anong un hay oha hi pfuuꞌ ay ni ulu ju ja ma-id olog ju an mangpapuchaw ja mangpangitit. ");
INSERT INTO ifu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hay maphod ja nu allon ju hi, ‘Aa, atoꞌ’ ja enat ju. Ja nu allon ju hi, ‘Achiꞌ aton’ ja achi ju aton. Hana punhapataan hay hato an ngachan ja narpu ay Satanas.” ");
INSERT INTO ifu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Inalin khu Hesus hi, “Hay oha khu an chengngor ju an khun mitudtuchu ja, ‘Nu gway munlu-it ay ni matam ja lu-iton cha khu hini matan ni limmu-it ta pfalloh na. Ja nu gway mamanguwan ay ni pfapfam ja panguwan cha khu ta pfalloh na.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Muti hay alloꞌ ay chaꞌju ja achi ju epfalloh hay napukhit an enat chi takhu ay chaꞌju. Nu gway manoplat ay ni apeng mu ja entajam khu hini oha. ");
INSERT INTO ifu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ja nu gway mangchalom ay he-a ta alaona hini lopfong mu ja achim i-achi, ja anong kay ja neꞌ-ala na khu hini jaket mu. ");
INSERT INTO ifu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja nu gway mangpapilit an itulud mu hija hi ohah kilomitlu ja achi a mun-ad-achi, ja anong kay ja intulud mu hi chugwah kilomitlu. ");
INSERT INTO ifu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ichatam hana mun-achaw ja pa-utangam nu gway umutang.” ");
INSERT INTO ifu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Inalin khu Hesus hi, “Hay oha khu hi chengngor ju an khun mitudtuchu ja, ‘Podpodhon ju hana ibpfa ju an tatakhu, ja apfoholan ju hana mabmapfohhor ay chaꞌju.’ ");
INSERT INTO ifu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Muti hay alloꞌ ay chaꞌju ja podpodhon ju hana mabmapfohhor ay chaꞌju ja ekalalakhan ju hato an mamarpalikhat ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nu amat hetoy aton ju hot chaꞌjuy empfapfalay Apo Jos ad langit. Ti hijay nangephod ay ni hukhit an khun pfumutay ta munchichipat an mahilagwan ta-o an amin, an anong un hana napukhit ja hana maphod an takhu. Ja hijay mangchat hi uchan ay ni lotan hana tatakhu an mangat hi maphod ja anong un hana khun mangat hi napukhit. ");
INSERT INTO ifu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma-id lagpfu ju nu hana mammamhod ay chaꞌju chi podpodhon ju ja angkhay. Ti anong un hay hana meꞌpepelaꞌ an khun munhenger hi pakha ja podpodhon cha hana mammamhod ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ja nu hana i-ibpfa ju ja angkhay chi pangpatikhagwan ju hi maphod ja un aju chamchama amat hana ma-id anila na ay Apo Jos, ti hitay chi khun cha khu aton. ");
INSERT INTO ifu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mahapor an miꞌtakhu aju hi magpong an amat ay Ama ju ad langit an magpong.” ");
INSERT INTO ifu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tikhan ju ta achi ju epa-akhaja hana maphod an khun ju aton ta achi khahin un annilaon hana tatakhu. Ti nu amat hetoy aton hot ma-id lagpfu ju ay Jos Ama an gawwa ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hotti hana umchat hay hana napubli, achi cha khurkhulaton an mangpa-innila ay ni inchat cha. Ti hitay chi khun aton hana mumpfuhuur an etongor cha hi achoꞌlan chi tatakhu hichi sinagoga ja hichi palaha an ipa-innila hini inchat cha, ta gway aton cha kan kaykhu an madayaw. Alloꞌ ay chaꞌju hi nakhibpfoh an enala cha hini dayaw cha hot angkhaynana, ma-id lagpfu cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hay aton ju koma an umchat hay hana napubli, ja achi khahin un annilaon ni ikhid an ngamoy hini inchat ni agwan an ngamoy. ");
INSERT INTO ifu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Achi khahin un gway manginnila ay ni inchat ju. Ti anong un ma-id oh-ohhah nanginnila ay ni maphod an enat ju, ja tinnig chamchama Jos Ama, ja hijay mangchat hi lagpfu ju.” ");
INSERT INTO ifu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ja inalin khu Hesus hi, “Mungkalalag aju ayya ja achi ju eng-enghon hana mumpumpfuhuur. Am-amjaꞌ cha an tumataꞌchug an mungkalalag hi achoꞌlan chi tatakhu hichi sinagoga ja hichi palaha ta gway aton cha kan kaykhu an madayaw. Muti alloꞌ ay chaꞌju an nakhibpfoh an enala cha hini dayaw cha hot ma-id lagpfu cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Chaꞌju ayya, nu mungkalalag aju ja humikhop aju ay ni kwarto ju ja impfukhot ju hini pantaw ja un aju gwot mungkalalag ay Jos Ama an achi matikhaw. Hotti anong un ma-id oh-ohhah nanginnila ay tay maphod an enat ju, ja tinnig chamchama Jos Ama, ja hijay mangchat hi lagpfu ju. ");
INSERT INTO ifu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ja nu mungkalalag aju, ja achi khahin un ju lupillupiton hay allon ju. Ti hitay chi khun aton hana agkhuy nanginnila ay Apo Jos, an hay khemhon cha ja chonglon Apo Jos hana kalalag cha nu anchu-anchu-oy. ");
INSERT INTO ifu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hi Apo Jos an Ama ju ja aniꞌ-ila na hana mahapor ju ja un ju epfokha, hotti achi khahin un ju lupillupiton an mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Amat heto chi aton ju an mungkalalag: ‘Jos Ama an gawwa ad langit, he-a adniꞌ chi daydayawon chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","He-a adniꞌ chi mun-ap-apo ay chaꞌmi. Hini adniꞌ penhod mu chi aton mi heto lota an amat ay ni khun cha aton hina ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ichat mu khu hay anun mi ad ugwani an arkhaw. ");
INSERT INTO ifu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ja pakawanom an amin chi pfahor mi, amat khu ay ni pammakawan mi hay hana pfimmahor ay chaꞌmi. ");
INSERT INTO ifu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ja i-achawwim ay chaꞌmi hana atopngan an achi ami paꞌ-ahchor, ta achi chaꞌmi apfakon ay Satanas.’ ");
INSERT INTO ifu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mahapor an pakawanon ju hana pfimmahor ay chaꞌju hot pakawanon chaꞌju khu ay Ama ju ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Muti achi aju ayya pomakawan ja achi chaꞌju khu pakawanon ay Jos Ama.” ");
INSERT INTO ifu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ja inalin khu Hesus hi, “Nu mun-ayunar aju, achi aju amat hana mumpumpfuhuur an tatakhu an ipatikhaw cha an amat cha hi mun-ayyong. Nguningunit cha ja agkhuy nahukhud hini pfuuꞌ cha, ta ipa-innila cha an khun cha mun-ayunar. Alloꞌ ay chaꞌju an nakhibpfoh an enala cha hini dayaw cha, hot ma-id lagpfu cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Chaꞌju ayya, nu mun-ayunar aju, lampfon ju hini ulu ju ja mun-ihu aju ");
INSERT INTO ifu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta achi matikhaw an khun aju mun-ayunar. Ti anong un ma-id oh-ohhah nanginnila ay tay maphod an enat ju ja tinnig chamchama Jos Ama, ja nangamong hija an mangchat hi lagpfu ju.” ");
INSERT INTO ifu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ja inalin khu Hesus hi, “Achi aju mun-amung hana enachangjan ay tay lota an mapfutan, ja machonot, ja ma-akaw. ");
INSERT INTO ifu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ehakhanaan ju gwot hini achor ju ay ni enachangjan ad langit an achi mapfutan, achi machonot ja achi ma-akaw. ");
INSERT INTO ifu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ti hini ipfilang ju an napfalor ay chaꞌju ja hinuy hini mun-o-onan ay ni nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Hini mata ju chi hilaw nuy achor ju. Nu maphod hini pannig ju ja mahilagwan an amin hini nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Muti napukhit ayya hini pannig ju ja munhehellong an amin hini nomnom ju. Hotti nu ma-id manilagwan ay ni piꞌtakhuwan ju hot munnaud aju an naherngan. ");
INSERT INTO ifu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hini takhala ja achi mapfalin an munchehhan an miꞌtamu ay ni chugwa an ap-apo, ti hay atona ja podhona hini oha ja chin-ug na hini oha. Unuchona hini oha ja pinahiw na hini oha. Amat khu hina ay chaꞌju an achi mapfalin an punchehhanon ju an munserbi ay Apo Jos ja hay enachangjan. ");
INSERT INTO ifu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Hitay chi khapo na hi pangarjaꞌ ay chaꞌju hi achi aju mundanag ay ni piꞌtakhuwan ju, hi hay anun ja inumon ju. Ja achi aju mundanag hi hay elopfong ju. Hay atakhuwan ja pfu-un anun ja elopfong ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tikhagwun ju akay niꞌ hay hana hagwiti an achi cha muntanum ja mumpfotoꞌ, ja ma-id alang cha, muti hi Apo Jos an Na-ilangitan an Ama ju ja panganuna chamchama chicha. Hotti achi aju mundanag, ti munnaꞌnaud aju an napfalor mu hay hana hagwiti. ");
INSERT INTO ifu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma-id chi oha hi mangpa-anchuꞌchuꞌ-oy hi piꞌtakhuwana khapo hi danag na. ");
INSERT INTO ifu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja anagkha ta madanakhan aju hi elopfong ju? Tikhan ju akay niꞌ hay hana palagwer hichi acha an achi cha muntamu ja mun-apfor. ");
INSERT INTO ifu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Alloꞌ ay chaꞌju an ma-id oha hi meꞌmeꞌnong chi lopfong na hay hato palagwer, anong un hi Ari Solomon an pfuher chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hana agkhu niꞌ holoꞌ an un homangaw hon napoolan ja khun lupfungan Apo Jos hi maphod. Hotti un chah achi om-omod ay chaꞌju? It-ittang kaykhu hini pammati ju! ");
INSERT INTO ifu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hotti achi aju agkhu madanakhan ja inali ju chi, ‘Ngay nin i ta-o pangalan hi anun, ja hay inumon ja elopfong?’ ");
INSERT INTO ifu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hay hana gwah to lota an agkhuy namati ja hay hato chi ikhimoh cha an hingiton. Muti anilan Jos Ama an gwa ad langit an mahapor ju hay hato. ");
INSERT INTO ifu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hotti hay pachot-anan juwot niꞌ ja hini pun-ap-apugwan Apo Jos ay chaꞌju ja hini pangatan ju ay ni magpong an penhod na, hot an amin hana mahapor ju ja ichat na. ");
INSERT INTO ifu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hotti achi aju madanakhan hi hay likhat an umali hi uchum chi arkhaw. Khenong ta umali hinuy an arkhaw ja un hanguwon, ti ammuna otniꞌ hana likhat ad ugwani an arkhaw hi hanguwon ju.” ");
INSERT INTO ifu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Inalin khu Hesus hi, “Achi ju hugijon hana papadchung ju an tatakhu ta achi chaꞌju khu hugijon ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ti hugijon chaꞌju khu an amat ay ni aton ju an manugwi hi uchumna. Ti hini punlukud ju ay ni ibpfa ju an takhu ja amat hina khu hini punlukud Apo Jos ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Anagkha ta matikhaw mu hini pfahor ni padchung mu an takhu an amat ay ni it-ittang an pfuta, muti niya an achim matikhaw hini ot-ottong an pfahor mu an amat hi pfin-u an immuy ay ni matam? ");
INSERT INTO ifu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Achi mapfalin an allom ay ni padchung mu an takhu hi, ‘Ijam ta aanuꞌ hinuy pfuta ay ni matam’ nu gawwacha hini pfin-u an immuy ay ni matam. Un chah paꞌ-at a ay tay? ");
INSERT INTO ifu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mumpfuhuur a! Pahhunom pay an ánun hinuy pfin-u an immuy ay ni matam hot mattag hini pannig mu an mangaan ay ni pfutan ni padchung mu an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Alloꞌ khu hitay pangngarig, an achi ju ichat hana napfalor an khina-u hana na-akhar an aho ti omalat cha. Ja achi ju khu ichat hana pfoong hana pfapfuy, ti pun-ilait cha.” ");
INSERT INTO ifu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ja inalin khu Hesus hi, “Mun-achaw aju hot michatan aju, hingiton ju hot chakngan ju, mungkorkug aju hot mipfughor hini pantaw. ");
INSERT INTO ifu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ti hini mun-achaw ja michatan, ja hini maningit ja machakngana, ja hini mungkorkug ay ni pantaw ja mipfughor. ");
INSERT INTO ifu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ma-id ammod hi mangchat hi pfato nu hay tenapay chi epfokhan ni empfalay na. ");
INSERT INTO ifu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ja achi na khu ichat chi ulog nu khachiw chi epfokha na. ");
INSERT INTO ifu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hotti, anong un aju khun pfumahor ja anila ju an mangchat hi mapmaphod ay ni empfalay ju. Nu amat hina chi khun ju aton, ja un chah achi om-omod hi Ama ju an gwa ad langit an ichatana hi mapmaphod hana mumpfokha ay hija? ");
INSERT INTO ifu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Hotti hini podhon ju an aton chi tatakhu ay chaꞌju ja hija khu chi aton ju ay chicha. Hitay chi ituchun ni urchin Moses ja hachi profetan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ja inalin khu Hesus hi, “Miꞌhikhop aju ay ni nahugkhipfit an pantaw. Ti gwa han ampfilog an pantaw an nalaka hi hongkhopan muti un agwun an mi-uy ad impferno, ja cho-or hana manggwa. ");
INSERT INTO ifu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ja nahugkhipfit hini pantaw an humikhupan, ja nalikhat hini agwun an mi-uy ay ni piꞌtakhuwan an ma-id chi pogpogna, ja un cha tortollo hana manakngan ay tay an chalan.” ");
INSERT INTO ifu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Inalin khu Hesus hi, “Achi aju ma-allilaw hana munlahlah an profeta. Mumpatikhaw cha an maphod cha an amat hi karnero an maꞌma-ulloy, muti hini umannung an omaꞌ-atan cha ja un cha amat hi khenger an pomatoy. ");
INSERT INTO ifu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imatunan ju chicha nu tikhan ju hana napukhit an pfungan ni khun cha aton. Ma-id alaon ju hi ubas ay ni karkalunay ja ma-id khu alaon ju hi higos hay hana nun-apakhatan an holoꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hini ayya maphod an ajiw ja pfumunga hi maphod. Hini ayya napukhit an ajiw ja pfumunga khu hi napukhit. ");
INSERT INTO ifu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Achi pfumunga hini maphod an ajiw hi napukhit ja achi khu pfumunga hini napukhit an ajiw hi maphod. ");
INSERT INTO ifu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","An amin hana ajiw an achi pfumunga hi maphod ja mali-oy ta mituud ay ni apoy hot mapoolan. ");
INSERT INTO ifu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ja amat hina khu hana munlahlah an profeta, an ma-innila hini gwa ay ni nomnom cha ay ni pfungan ni khun cha aton. ");
INSERT INTO ifu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Achi an amin hana mangali ay ha-in hi, ‘Apo, Apo’ ja midchum ay ni Pun-ap-apugwan Apo Jos. Hana midchum ja hana khun mangat ay ni penhod Ama an gwa ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ay nuy an arkhaw an Panugijaꞌ hi tatakhu ja cho-or hana mangali hi, ‘Anagkha, Apo, an un he-ay narpugwan ni apfalinan mi an numpadtu, ja penakak mi hana napukhit an ispiritu ay ni apfalinan ni ngachan mu, ja cho-or chin enat mi an milagro ay ni apfalinam?’ ");
INSERT INTO ifu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ja tompfalaꞌ an alloꞌ ay chicha hi, ‘Ma-id oh-ohhah anilaꞌ ay chaꞌju. Hotti makak aju, chaꞌju an khun mangat hi napukhit.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Inalin khu Hesus hi, “Hitay chi amatan ni takhu an munchongor ay ni ituchuꞌ ja inunud na, an mipadchung ay ni manomnom an lala-e an numpakhad hi pfalay na. Empfo-eh na hichin pfato ta hijay nangpapfunana chin tu-ud. ");
INSERT INTO ifu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Napfalin an nahaꞌ-ad chin pfalay ja pimmuwoꞌ ja nunchatong. Ja nituchug chin chanum ay chuy an pfalay muti agkhuy natuꞌ-in, ti nehamad chin tu-ud an nipapfun chin pfato. ");
INSERT INTO ifu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ja hini ayya munchongor ay ni ituchuꞌ ja achi na unuchon, ja mipadchung ay ni napfongang an takhu an numpakhad hi pfalay na muti una impapfun chin tu-ud chin panag. ");
INSERT INTO ifu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Immali khu chin puwoꞌ ja nunchatong. Immijah ja natuꞌ-in chin pfalay ja nun-apaꞌ-i.” ");
INSERT INTO ifu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nakhibpfoh hitay nuntudtuchugwan Hesus, ja nanor chin tatakhu an nakhagong chin panudtuchu na. ");
INSERT INTO ifu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ti matikhaw cha an gway apfalinana, an achi amat hachi memehtolon chi urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Unot nunchayyu hi Hesus ay chuy pfuludna ja cho-or chin tatakhu an nangunud. ");
INSERT INTO ifu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ja gwacha han lala-e an na-unit an immuy ay Hesus an i nunheppe ja inali na hi, “Apo, otong hini apfalinam hotti podhom ayya ja epatenongaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ja hen-an Hesus chin na-unit ja inali na hi, “Podhoꞌ. Hotti tomenong a.” Ja emmat an na-aan gwot chin unit na. ");
INSERT INTO ifu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ja inalin Hesus hi, “Achi la-ahna ja gway im pangar-arjan ay tay an na-at ay he-a. Hay atom ja umuy a ay ni pachi ta i a mumpatikhaw an temmenong a. Ja ipidaton mu ay hija hini allon ni urchin Moses an khun idaton ay Apo Jos an panginnilaan an umannung an na-aan hini unit mu.” ");
INSERT INTO ifu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Emmatam cha Hesus ad Kapernaum ja gwa han kapitan chi hinchalo an eRome an immuy ay hija. Ja numpakpaka-ahi ");
INSERT INTO ifu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ja inali na hi, “Apo, gwa han takhalaꞌ an un la-ahna ja napechoy ja gwa an numpepekheng hichi pfalay mi ja munnaud an malikhatan.” ");
INSERT INTO ifu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ja inalin Hesus hi, “Aa, umuy ta, ta epatenong u hija.” ");
INSERT INTO ifu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Muti inalinot chin kapitan hi, “Apo, khahinon un a miꞌjali hi pfalay mi. Ti pfuma-inaꞌ. Ti ammuna un mu allon hi tomenong hitay takhalaꞌ hot ma-at. ");
INSERT INTO ifu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ti anong un ha-in ja gway apoꞌ an khun mamaar ay ha-in, ja gwacha khu hana hinchaloꞌ an khun u pfaalon. Ti alloꞌ ay ni oha an hinchalo hi, ‘Umuy a!’ ja immuy. Ja alloꞌ khu ay ni oha hi, ‘Umali a!’ ja immali. Ja alloꞌ ay ni takhalaꞌ hi, ‘Atom hitay!’ ja enat na. Ja om-omod ay he-a an gway apfalinam an mangali hot ma-at.” ");
INSERT INTO ifu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja nanor hi Hesus hi nangngolana ay tay inali na. Ja inali na hachi tatakhu an ninitnud ay hija hi, “Umannung hitay alloꞌ ay chaꞌju, an ma-id oha hi Hudju hi tinnig u an gway pammati na an miꞌpadchung ay ni otong an pammatin tay pfu-un Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Alloꞌ ay chaꞌju hi cho-or hay hana tatakhu an marpu hana nunleneꞌgwoh tay lota ta meꞌ-orpfong cha ay cha Abraham, Isaak ja hi Jakob hichi Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Muti cho-or hana Hudju an holag Abraham an midchum koma ay ni Pun-ap-apugwan Apo Jos ja agkhuy cha penenhod an miꞌ-unud, hot pakakon Apo Jos chicha ta umuy cha ay ni munhehellong. Ja mihihidchi cha an midchum hana khun mun-okhab ja khun mungngelot hana pfapfa cha.” ");
INSERT INTO ifu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amat hichi ja niꞌhapit khu hi Hesus chin kapitan ja inali na hi, “Aa, umanamut a. Ti ma-apja hini empfokham khapo ay ni pammatim.” Ja emmat, an unot ay chuy ja temmenong chin takhala na an napechoy. ");
INSERT INTO ifu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Immuy cha Hesus hichi pfalay cha Peter an adalana. Ja tinnig na chin pfupfai an ammod ni ahagwan Peter an numpepekheng, ti mapfi-ah han potang na. ");
INSERT INTO ifu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Penchon Hesus ja na-aan gwot chin potang na. Amat hichi ja pfimmangon hitay pfupfai ja enhakhanaana cha Hesus hi anun cha. ");
INSERT INTO ifu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Unot nahilip ja in-uy cha ay Hesus hachi cho-or an tatakhu an nun-ahuꞌlungan hi napukhit an ispiritu. Ja un ammuna chin aton Hesus an munhapit hon nun-a-akak hachi napukhit an ispiritu. Ja nun-epatenong na an amin hachi mumpunchokhoh. ");
INSERT INTO ifu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ay tay an enat na ja nipa-annung chin inalin profeta Isaiah hi nangarjana hi, “Henaꞌpfatana hana likhat ja chokhoh ta-o ta tomenong ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Khapo hachi cho-or an tatakhu an khun malimali-ub ay Hesus ja inali na hachi disipolo na ta mumpfalangay cha ta gway aton cha an umuy hichi chammang ni baybay. ");
INSERT INTO ifu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Agkhuy cha pay nakak ja gwa han mehtolon chi urchin Moses an immuy ay hija ja inali na hi, “Rabbi, mimitnuchaꞌ ay he-a an amin hi omajam.” ");
INSERT INTO ifu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tempfar Hesus ja inali na hi, “Un chah angkhiloh, ti ha-in an Na-ilangitan an Takhu ja ma-id nunhitugwaꞌ hi khun u alo-an, an uchuꞌchuna agkhu niꞌ hay hana amunin ti gway hogong hi humigpan cha, ja hay hana hagwiti ti gway hapang hi pumpattu-an cha.” ");
INSERT INTO ifu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ja immuy khu han oha an disipolo na, ja inali na hi, “Apo, miꞌjaliyaꞌ koma ay he-a muti unchani mah ta umanamotaꞌ pay ta ujaꞌ ilupfuꞌ hi ama.” ");
INSERT INTO ifu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Muti inalin Hesus ay hija hi, “Achi ti tan enajakhaꞌ he-a ta mitnud a ay ha-in, ti hay hana agkhuy namati chi manikhaw hay hana i-ibpfa cha an natoy.” ");
INSERT INTO ifu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Amat hichi ja nunlukhan hi Hesus chin pfalangay ja nitalinud khu hachi disipolo na. ");
INSERT INTO ifu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Empacheh cha ta umuy cha ad Gadara ja himpfumagkha ja gwacha han mapfi-ah an puwoꞌ. Nuntepjaꞌ-ong chin chanum ja nittugwan chin pfalangay ja gwa an munlinong. Hi Hesus ayya ja gwa an nanalloꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Immuy hachi disipolo na ja pfinangon cha hi Hesus. Ja inali cha hi, “Apo, tulungan chaꞌmi! Ti tayya an marteng ta-o!” ");
INSERT INTO ifu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Enelan Hesus ja inali na hi, “Anagkha ta toma-ot aju? Un kaykhu it-ittang hini pammati ju!” Lemmeggwat ja inhingar na chin puwoꞌ ja chin chanum an khun muntipjaꞌ-ong. Khemmenong cha ja munnaud an malenong. ");
INSERT INTO ifu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nanor hachi tatakhu an nannig ja khun cha allon hi, “Ngachah chi atakhuwan tay an takhu? Anong un puwoꞌ ja chanum ja unuchon cha hini allona!” ");
INSERT INTO ifu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Emmatam cha Hesus hichi chammangna, an pfuglay hachi eGadara. Ja chinittum na han chugwa an linala-e an narpu cha hichi lijang an lupfuꞌ ja nun-ahuꞌlungan cha hi napukhit an ispiritu. Hay hachi chugwa an linala-e ja munnaud an mun-apfungot cha hotti ma-id aton chi takhu an maloh ay ni agawwachaan cha. ");
INSERT INTO ifu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ja iniꞌgwap cha an nangali hi, “He-a an Empfalay Apo Jos! Ngachah ni atom ay chaꞌmi? Un a chah immali an mamalikhat ay chaꞌmi an un agkhuy pay nachakngan hini timpo na?” ");
INSERT INTO ifu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ja cho-or hachi apfapfupfapfuy an nenebtaw ay chuy agawwachaan cha an khun cha munhu-oy. ");
INSERT INTO ifu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ja numpakpaka-ahi hachi napukhit an ispiritu an inali cha ay Hesus hi, “Nu pakakon chaꞌmi, ja un ami mah niꞌ mehoꞌlong hachi pfapfuy.” ");
INSERT INTO ifu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ja inalin Hesus hi, “Umuy aju!” Hotti nun-a-akak hachi napukhit an ispiritu ay cha chuy chugwa an linala-e ja icha nun-ehoꞌlong hachi apfapfupfapfuy. Ja nungkhakhayyat hachi pfapfuy an nunchayyu ja nun-ilipaw cha ay chuy baybay ja nun-arteng cha. ");
INSERT INTO ifu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hachi khun mumpfantay hachi pfapfuy ja nungkhakhayyat cha an nakak. Ja immuy cha hichi pfuglay an i nangpa-innila an amin chin tinnig cha an na-at hachi nahuhuꞌlungan an linala-e ja hachi pfapfuy. ");
INSERT INTO ifu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hotti napfu-ar hachi tatakhu an i nanittum ay Hesus. Un chaot tinnig hi Hesus ja numpakpaka-ahi hachi tatakhu an nangali hi makak hija ay nuy pfuglay cha. ");
INSERT INTO ifu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Amat hichi ja nunlukhan cha Hesus chin pfalangay ta pfumad-ang cha an umuy ad Capernaum an pfuglay na. ");
INSERT INTO ifu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja gwah chi han napechoy an lala-e an impfapfalahhong cha an in-uy ay Hesus. Na-ormana chin pammati cha ja inali na ay chuy napechoy hi, “Achi a madanakhan, akhiꞌ, ti napakawan hana pfahor mu.” ");
INSERT INTO ifu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ja gwa hichi hana uchumna an memehtolon chi urchin Moses an khun cha allon hi, “Anagkha agkhu niꞌ hitay an takhu an ipadchung na hichuy achor na ay Apo Jos, an allona hi un pomakawan hi pfahor.” ");
INSERT INTO ifu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Anilan Hesus chin khun cha nomnomnomon ja inali na ay chicha hi, “Anagkha ta amat hina hini nomnom ju an napukhit? ");
INSERT INTO ifu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma-id olog chi takhu an mamakawan hi pfahor ja ma-id khu olog cha an mangpatenong hi chokhoh. ");
INSERT INTO ifu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Muti ay ha-in an Na-ilangitan an Takhu ja epatenong u hitay an napechoy ta panginnilaan ju an gwacha khu chi apfalinaꞌ heto lota an mamakawan hi pfahor.” Ja inali na chin napechoy hi, “Pfumangon a ja impi-ug mu hinuy pfalahhong mu ja immanamut a.” ");
INSERT INTO ifu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ja natantannaꞌchug chin napechoy ja immanamut. ");
INSERT INTO ifu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Unagkhu tinnig hachi atakhutakhu chin na-at ja nang-entata-ot cha, ja khun cha dayawon hi Apo Jos an nangchat hi amat hina an apfalinan ay ni ohan takhu. ");
INSERT INTO ifu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Empacheh Hesus ja gwa an khun umuy ja tinnig na han lala-e an hay ngachana ja hi Matthew. Oha hija an khun munhenger hi pakha an inu-umpfun hichin opihhina na. Ja inalin Hesus ay hija hi, “Umali a ta mitnud a ay ha-in.” Amat hichi ja nitnud hi Matthew ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ja gwa han namenghan an i nangan hi Hesus ja hachi disipolo na hichi pfalay cha Matthew. Ja neꞌ-orpfong hachi cho-or an khun munhenger hi pakha ja hachi uchumna an allon cha an napfahulan an tatakhu an i ni-ib-ipfun ay cha Hesus ja cha chuy disipolo na. ");
INSERT INTO ifu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tinnig hachi Farisee ja inali cha hachi disipolon Hesus hi, “Anagkha mah hitay mehtolo ju ta meꞌ-orpfong hay hachi khun munhenger hi pakha ja hachi uchumna an nun-apfahulan?” ");
INSERT INTO ifu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Unot chengngor Hesus hitay inali cha ja tempfar na ja inali na ay chicha hi, “Hana gway chokhoh na chi munhapor hi choktor an pfu-un hini ma-id chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Annilaon ju koma hini podhon Apo Jos an hapiton ay tay impatulaꞌ na hi nangarjana hi, ‘Hay aton ju an munnignikha hi papadchung ju ja napfarpfalor ay ha-in mu hini pangdatunan ju hi animar.’ Ti immalijaꞌ an tomolong hana napfahulan ta chuꞌkhon cha hana pfahor cha an pfu-un hana mangali hi ma-id pfahor cha.” ");
INSERT INTO ifu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gwacha hana disipolon John Bautista an immuy ay Hesus ja inali cha hi, “Chaꞌmi ayya ja khun ami mun-ayunar ja amat hina khu hachi Farisee. Hotti anagkha ta hato disipolom ja achi cha miꞌ-ayunar?” ");
INSERT INTO ifu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tempfar Hesus ja inali na hi, “Nu khulat ta gway mungkasar ja un ju chah allon hi umayyong hay hana na-ila nu gawwacha pay hini mungkasar? Achi mit mapfalin. Muti umali han arkhaw an ekak cha hini lala-e an nungkasar ja hijay pun-ayunalan cha. Hotti gawwachaaꞌ ayya ja achi pay mun-ayunar hato disipoloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ja nun-arig hi Hesus ja inali na hi, “Ma-id manger-ob hi pfakhu an pfinacha ay ni nachochonot an lopfong. Ti nu amat hetoy atona hot mun-ohon hini pfakhu an ner-ob ja inatona hini nachochonot hot omom-omod an mapfingit. ");
INSERT INTO ifu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma-id khu mangitto hi paꞌ-arpoh an chanum chi ubas ay ni na-usar an lalat an khun pittugwan hi ma-inum. Ti nu amat hetoy atona hot mapfughi hini lalat, ja metapar hini chanum chi ubas ja mapaꞌ-i khu hini lalat. Hini ayya paꞌ-arpoh an chanum chi ubas ja mitto ay ni pfakhu an lalat ta mehaꞌpfa.” ");
INSERT INTO ifu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gwa an khun munhapit hi Hesus ja immuy han oha an ap-apo an i nunheppe ay hija. Ja inali na hi, “Miꞌjali a adniꞌ hi pfalay mi, ti unot paꞌ-atoy han empfalay u an pfupfai, ta hoꞌ-om hija ta tumakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Amat hichi ja nitnud hi Hesus ja hachi disipolo na. ");
INSERT INTO ifu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja gwa han ohan pfupfai an khun mangunud ay chicha an hay chokhoh na ja achi maymajat han chala an khun pfumutay ay hija hi himpolo ta chugwa hi tagwon. Immuy ay chuy negpong chin khatud Hesus ja heneꞌkhad na hini khalampfay ni lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ti hay gwa hi nomnom na ja un ammuna hi una heꞌkhachon chin lopfong Hesus hot tomenong hija. ");
INSERT INTO ifu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nunligkhoh hi Hesus ja tinnig na chin pfupfai, ja inali na hi, “Achi a madanakhan, hiton akhiꞌ, ti khapo ay ni pammatim ja temmenong a.” Ja emmat an temmenong gwot hija. ");
INSERT INTO ifu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Un chaagkhu emmatam chin pfalay chin ap-apo ja tinnig Hesus hachi atakhutakhu an khun cha mahanalaꞌ an umiha, ja hachi uchumna an khun manongngali. ");
INSERT INTO ifu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ja inali na hi, “Makak aju adchiya, ti agkhuy natoy hichuy an unga an un nanalloꞌ.” Muti kenekejan cha hitay inali na. ");
INSERT INTO ifu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Impapfutay Hesus hachi tatakhu an nakhagong ja himmikhop. Ja inugnana chin ngamoy chuy unga ja pfimmangon. ");
INSERT INTO ifu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ja nunchongor hitay an enat na hachi apfuglapfuglay. ");
INSERT INTO ifu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gwa an empacheh cha Hesus ja khun mangumangunud han chugwa an napfulaw. Ja iniꞌgwap cha an nangali hi, “Apo an holag Ari David, ka-ahiyan chaꞌmi adniꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Unot himmikhop hi Hesus ay chuy nunhihittugwana ja immuy hachi napfulaw ja inalin Hesus ay chicha hi, “Mamati aju chah an gway apfalinaꞌ an mangakhahan ay chaꞌju?” Tempfar cha ja inali cha hi, “Aa, Apo, mamati ami.” ");
INSERT INTO ifu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Amat hichi ja hen-an Hesus chin mata cha ja inali na hi, “Hot ma-at hinuy pinati ju.” ");
INSERT INTO ifu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ja mitikhaw gwot chin mata cha. Ja naꞌnaꞌ-allon Hesus ay chicha hi, “Tikhan ju ta ma-id i ju pangar-arjan ay tay an na-at.” ");
INSERT INTO ifu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Muti agkhuy cha inunud hitay inali na, ti un chaagkhu ay nun-ipa-innila hitay enat Hesus hi apfuglapfuglay. ");
INSERT INTO ifu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gwa an epacheh cha chuy chugwa an na-akhahan ja in-uy cha khu han lala-e an nakalud khapo ta nahuhuꞌlungan hi napukhit an ispiritu. ");
INSERT INTO ifu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Empakak Hesus chin napukhit an ispiritu ja himmapit chin lala-e. Ja nanor chin atakhutakhu an nakhagong ja khun cha allon hi, “Ma-id tintinnig ta-o hi mipadchung ay tay heto ad Israel.” ");
INSERT INTO ifu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Muti inalin hachi Farisee hi, “Un kaykhu hini ap-apon chi nun-apukhit an ispiritu chi nangchat ay hija ay ni apfalinana an khun mangpakak hana napukhit an ispiritu.” ");
INSERT INTO ifu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Khun munlawlaw hi Hesus an amin hana pfarju ja pfuglay an khun muntudtuchu hay hana sinagoga. Engkasaba na hini Ebanghelyo an mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos. Ja khuna epatenong an amin chi chokhoh ja likhat cha. ");
INSERT INTO ifu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Unaagkhu tinnig hachi tatakhu an nakhagong ja na-apja chin nignikha na. Ti amat cha hi karnero an maliglikhatan ja nakaꞌka-ahi khapo ta ma-id mangpunoꞌ ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ja inali na hachi disipolo na hi, “Cho-or hana mabtoꞌ muti un aju tortollo an mumpfotoꞌ, ti cho-or hana tatakhu an nehahagkhana an matuchugwan muti tan un aju tortollo an umuy muntuchu. ");
INSERT INTO ifu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hotti ekalalag ju ay Ama an khun mangpagpong hi mumpfotoꞌ ta honakhona hana umuy mumpfotoꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Enajakhan Hesus chin himpolo ta chugwa an adalana ja inchatana chicha hi apfalinan an mangpakak hi napukhit an ispiritu an khun mehoꞌlong. Inchat na khu hay apfalinan cha an mangpatenong an amin hi chokhoh. ");
INSERT INTO ifu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja hay hato chi ngachan hay hachi himpolo ta chugwa an nginadnana hi apostol. Chin nahhun ja hi Simon an nangadnan hi Peter, ja hi Andrew an akhi na, ja hi James an empfalay Zebedee, ja hi John an akhi na, ");
INSERT INTO ifu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ja hi Philip, ja hi Bartolomew, ja hi Tomas, ja hi Matthew an chin khun munhenger hi pakha, ja hi James an empfalay Alfeus, ja hi Tadeus, ");
INSERT INTO ifu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ja hi Simon an oha an Zealot, ja hi Judas Iskariot an hijay mangngina ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hennag Hesus hay hato himpolo ta chugwa ja hijah tay chi imbilina an inali na ay chicha hi, “Achi aju umuy hana pfuglay chi Hentil ja achi aju khu umuy hana pfuglay chi Samaritan. ");
INSERT INTO ifu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hay pahhunon ju gwot niꞌ an omajan ja hana gwachaan hachi holag Israel an amat cha hi karnero an na-utaw. ");
INSERT INTO ifu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","An amin chi omajan ju ja mangaskasaba aju ja allon ju hi, ‘Achi mapfajag hot machakngan hini Pun-ap-apugwan Apo Jos hi tatakhu.’ ");
INSERT INTO ifu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Epatenong ju hana mumpunchokhoh, ja tinakhu ju hana natoy ja akhahan ju khu hana na-unit, ja pun-epakak ju hana napukhit an ispiritu an nun-ehoꞌlong. Ja achi aju mumpapfajad, ti agkhuy ju pfinajachan hitay apfalinan an nichat ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Achi aju mun-ochon hi pihu, ");
INSERT INTO ifu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ja hape-eng. Achi aju mun-ochon hi hay pun-orkhan ju ja hay hapato ja hay pfunguhan. Ti an amin hana muntamu ja kalintikhan cha an omagwat hana mahapor cha ay ni takhu an piꞌtamuwan cha. ");
INSERT INTO ifu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nu omatam aju ay ni ohan pfuglay ja tikhan ju hay takhu an mamhod an mangajakhan ay chaꞌju, ja meꞌheto aju ay hija ingkhana hi akakan ju ay nuy an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu humikhop aju ay ni pfalay ja allon ju hi, ‘Pomhod hini piꞌtakhuwan ju an nunheto ay tay an pfalay.’ ");
INSERT INTO ifu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ja nu hini nunheto ay ni pummangiliyan ju ja apfuluton cha hitay allon ju hot pomhod cha. Muti achi cha ayya apfuluton hot mumpfangngad hini bindisyon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ja nu khulat ta hana tatakhu ay nuy an pfuglay ja achi chaꞌju podhon an mangiliyon ja achi cha egngor hini itudtuchu ju, ja pumpuꞌpu-an ju hay chapor an nep-ot ay ni chapan ju hi akakan ju ay nuy an pfalay wenno pfuglay. ");
INSERT INTO ifu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Umannung hitay alloꞌ ay chaꞌju an umali ayya hini arkhaw an Panugijan Apo Jos hi tatakhu, ja machamchamot hini dusan hana tatakhu ay nuy an pfuglay mu hachi tatakhu ad Sodom ja Gomorah an khenhob Apo Jos chin timpon Abraham. ");
INSERT INTO ifu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tan pfaaloꞌ chaꞌju an amat hi naꞌna-unnud an karnero an umuy hana achaan chi tatakhu an amat hi mun-apfungot an khenger. Hotti manomnom ja maꞌma-ulloy aju koma. ");
INSERT INTO ifu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tikhagwun ju, ti gwacha mangkay hana tatakhu an pfumuhur ay chaꞌju. Ijuy chaꞌju hana hugi ta echalom chaꞌju, ja ipahuplit chaꞌju hichi sinagoga. ");
INSERT INTO ifu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ja ijuy chaꞌju hana gobernador ja ar-ari khapo hi immunuchan ju ay ha-in. Ja hinuy chi timpo an puntihtikhuwan ju ay chicha ja hana Hentil ay ni hapit u. ");
INSERT INTO ifu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu echalom chaꞌju ja achi aju madanakhan hi hay allon ju an ehongpfat ju ay chicha. Ti ay nuy an timpo an humanguwan ju ja ituchun Apo Jos hay ehongpfat ju. ");
INSERT INTO ifu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ti pfu-un chaꞌju ja angkhay chi munhapit, an hini Espiritun Apo Jos chi mangchalan ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Ay nuy an timpo ja pfuhulon chaꞌju an amin hi tatakhu khapo ay ni nangunuchan ju ay ha-in. Hana uchumna ja anong un hana a-akhi cha ja epfaag cha hana ap-apo ta patajon cha. Amat khu hina chi aton ni oha an ammod hay empfalay na. Ja hana ungunga, chuꞌkhon cha hana a-ammod cha ja empapatoy cha chicha. Muti hana mangedpor hay hato ingkhanah atajan cha an achi cha epfot hini pammati cha, ja miꞌtakhu cha. ");
INSERT INTO ifu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu palikhaton chaꞌju ay ni oha an pfuglay ja lomajaw aju ta umuy aju ay ni oha. Umannung hitay alloꞌ, an achi ju pachaꞌpuhon an lawlagwon an amin hana apfuglapfuglay ad Israel hot umali hini arkhaw an pumpfangngachaꞌ an Na-ilangitan an Takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ja inalin khu Hesus hi, “Hini mun-ad-achar ja achi nangatngato mu hini mehtolo na. Ja hini takhala ja achi napfagpfagto mu hini apo na. ");
INSERT INTO ifu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hotti nu ma-apfoholan hini mehtolo, ja nomnomon ni khun mitudtuchugwan an anong un hija ja ma-apfoholan khu. Ja amat khu ay ni himpfut, an ma-apfoholan nu ma-apfoholan hini apo na. Ja ay ha-in an apo ju, ja tayya an ma-apfoholanaꞌ, ti nan allon cha hi un ha-in hi Beelzebul an ap-apon chi napukhit an ispiritu. Hotti achi mehalla an omom-omod an pfuhulon chaꞌju an tatakhuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hotti achi aju toma-ot ay chicha. Ti an amin hana ililiꞌ-ud cha an aton an achi ma-innila ad ugwani muti gwa han arkhaw an ma-innila chamchama. ");
INSERT INTO ifu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hotti nu amat heto ja an amin hana inaliꞌ ay chaꞌju ad ugwani an immiꞌ-igway ta-o, ja epagngor jun to hi achaan chi tatakhu. Ad ugwani ja i-am-amu heto unig muti iꞌgwap jun to hichi pfutayna. ");
INSERT INTO ifu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ja achi aju toma-ot hay hana umali an mamatoy ay ni achor ju, ti ma-id olog cha an mamatoy ay ni lennagwa ju. Eta-ot juwot niꞌ hi Apo Jos an gway apfalinana an mamaꞌ-i ay ni achor ja lennagwa hichi impferno. ");
INSERT INTO ifu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Anila ju an anong un hini chugwa an pfucheng an mahalape, ja ma-id oh-ohha hi makhah ay tay lota nu achi apfuluton Jos Ama. ");
INSERT INTO ifu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ja anong un hay hana pfuuꞌ ju ja pfinibpfilang na. ");
INSERT INTO ifu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hotti achi aju toma-ot, ti napfarpfalor aju mu hay hana cho-or an pfucheng. ");
INSERT INTO ifu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","An amin hana achi mangpfa-in an mangpa-innila hi nidchuman cha ay ha-in, ja achiꞌ khu ipfa-in chicha an ipa-innila hichi gwachaan Ama ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Muti hay hana mangpfa-in ay ha-in hi hangon hana tatakhu, ipfa-in u khu chicha hichi gwachaan Ama ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Un chah khemhon ju un hay apanuhan ju chi immaliyaꞌ heto lota? Achi amat heto, ti hitay immaliyaꞌ ja mangchat hi punchichinnuꞌ-ukhan ju. ");
INSERT INTO ifu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Khapo ay ha-in ja chuꞌkhon ni lala-e hinuy ammod na an lala-e, ja chuꞌkhon ni pfupfai hinuy ammod na an pfupfai, ja chuꞌkhon ni na-apo an pfupfai hini ammod ni ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hana pfuhur ni ohan takhu an namati ja hana a-akhi na. ");
INSERT INTO ifu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Hini ayya takhu an ot-ottong chi pamhod na ay ni ammod na wenno empfalay na mu hini pamhod na ay ha-in ja achiꞌ ipfilang hi takhuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja achiꞌ ipfilang hi takhuꞌ hini achi mami-ug ay ni kros na ta unuchonaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ti hini ayya takhu an mangpa-ennongan ay ni piꞌtakhuwana heto lota ja angkhay, ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota khapo hi pangunuchana ay ha-in, ja miꞌtakhu ay Apo Jos hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Hini mangakhamid ay chaꞌju ja inakhamichaꞌ khu. Ja hini mangakhamid ay ha-in ja inakhamid na hi Ama an nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hini mangakhamid ay ni profetan Apo Jos khapo ta profeta ja michatan hi lagpfu an hihiya ay ni lagpfun chi ohan profeta. Ja hini mangakhamid ay ni magpong an takhu khapo ta magpong ja michat ay hija hini lagpfun chi oha an magpong an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ja alloꞌ ay chaꞌju an hini takhu an tomolong hi oha an nabnababba an namati khapo hi pangunuchana ay ha-in, anong un himpfahpfahhu hi chanum chi ichat na hi inumona, ja gwachay linagpfu na ay nuy an enat na.” ");
INSERT INTO ifu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Napfalin hitay nuntukhunan Hesus hachi himpolo ta chugwa an adalana ja empacheh na an umuy muntudtuchu ja mangaskasaba hachi apfuglapfuglay chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ay chuy an timpo ja nipfabpfalud hi John Bautista ja chengngor na chin khun at-aton Hesu Kristo. Hotti hennag na hana disipolo na ");
INSERT INTO ifu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","an umuy ay Hesus an i mangpfokha hu-un hija chah hini inalin John an hennag Apo Jos an hahadchon cha, wenno hay oha. ");
INSERT INTO ifu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Enhanhan cha ay Hesus ja tempfar na ja inali na ay chicha hi, “Mumpfangngad aju ta allon ju ay John hay hato tinnig ju ja chengngor ju. ");
INSERT INTO ifu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Allon ju chi tinnig mi an hana napfulaw ja tumikhaw cha, hana napechoy ja chumalan cha, hana na-unit ja temmenong cha, hana napo-it ja chomngor cha, ja hana nun-atoy ja timmakhu cha. Ja khun mekasaba hini maphod an Hapit Apo Jos hana napubli. ");
INSERT INTO ifu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ja allon ju khu chi madmachennor hini takhu an achi munhalinchugwa hini nomnom na ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amat hichi ja empacheh chin disipolon John an nakak ja inalin Hesus hini omaꞌ-atan John ay cha chuy atakhutakhu. Inali na hi, “Chin immajan ju ay John hichi let-ang ja ngay nenomnom ju hi i ju tikhan? Unchah hay potaar an khun mumpfiwpfiwwapfiw? Pfu-un. ");
INSERT INTO ifu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hot ngachah mah chi i ju tinnig? Un aju chah immuy ta tikhan ju hay takhu an maphod chi lopfong na? Pfu-un khuh niꞌ, ti hana ayya khun munlopfong hi maphod ja hay pfalay chi ari chi punhihittugwan cha. ");
INSERT INTO ifu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hotti ngachah tugwali chi i ju tinnig? Hay profetan Apo Jos? Aa, ja alloꞌ ay chaꞌju an napfagpfagto pay hija mu hana uchumna an profeta. ");
INSERT INTO ifu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ti hi John hini nitulungan ni nitulaꞌ an Hapit Apo Jos hi nangarjana hi, ‘Tayya an honakhoꞌ hitay mangpangpangullu ja un he-a ta ehakhana na hini agwum.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ja inalin khu Hesus hi, “Umannung hitay alloꞌ ay chaꞌju an hi John Bautista hini napfagpfagto an amin hi hay takhu heto lota. Muti napfagpfagto pay hini nabnababba an takhu an nidchum ay ni Pun-ap-apugwan Apo Jos hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nete-a chin immaliyan John ja ingkhana ad ugwani ja cho-or hachi mungkhikhihhu an mun-e-egkhad an midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hini omaꞌ-atan chuy Pun-ap-apugwana ja intuchun hachi profetan Apo Jos ja chin Urchin Moses ingkhanah immaliyan John Bautista. ");
INSERT INTO ifu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ja na-awatan ju koma an hi John hinuy nipadtu an Elijah an umali. ");
INSERT INTO ifu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hotti pa-ennongan ju an munchongor ay tay alloꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Alloꞌ ay chaꞌju hini eꞌ-eꞌnongan ju an tatakhu ad ugwani an timpo, an meꞌmeꞌnong aju hana ung-ungungnga an um-umpfun hinun palaha an munlewlegwa muti ma-id maptoꞌ hi podhon cha. Ti iꞌgwap hana uchumna an allon cha ay ni khun cha peꞌlewlegwa hi, ");
INSERT INTO ifu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nanongngali ami muti agkhuy aju temmajaw. Ja emmepfer ami muti agkhuy aju niꞌkila.’ ");
INSERT INTO ifu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","An amat ay chaꞌju an ma-id maptoꞌ hi podhon ju. Ti immali hi John Bautista ja khun mun-ayunar ja achi umin-inum hi pfajah, ja allon ju hi un mun-angaw. ");
INSERT INTO ifu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja tan immaliyaꞌ an Na-ilangitan an Takhu, ja khunaꞌ meꞌ-orpfong an meꞌ-an, ja nuja an pahigwonaꞌ an khun ju allon hi, ‘Tikhan ju akay niꞌ hitay an takhu an nahopo ja khun mapfutong. Ja niꞌkhayyum khu hana khun munhenger hi pakha ja hana uchumna an nun-apfahulan an tatakhu!’ Hotti tayya an pahigwon chaꞌmi an chugwa. Muti nomnomon ju hitay, an hini aphod ja kinala-eng Apo Jos ja matikhaw ay ni piꞌtakhuwan hay hana nangapfulut ay ni itudtuchu mi ay John.” ");
INSERT INTO ifu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nunhapit khu hi Hesus ja pinahiw na hana tatakhu an gwa ay cha chuy pfuglay an nangatana hachi otong an milagro ti agkhuy cha chamchama chin-ug hana pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ja inali na hi, “Ka-ahi cha hay hana eKorazin ja eBetsaida! Nu na-at ad Tiro ja ad Sidon hachi otong an milagro an enat u ay chuy pfuglay cha, hot gwa agkhu niꞌ an napfajag an nunlopfong cha hi kamma ja inlipfu chay chapor ay ni ulu cha an pangpatikhagwan chay nan-ukhan cha hi pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Alloꞌ ay chaꞌju hi, umali ayya hini arkhaw an Panugijan Apo Jos an amin hi tatakhu, ja machamchamot hini dusan hana eKorazin ja eBetsaida mu hay hana eTiro ja hana eSidon. Ti hay hato an eKorazin ja eBetsaida ja khun cha tikhan hay hato milagro ja achi cha chamchama chuꞌkhon hana pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja hay hana eKapernaum, khemhon chaot un cha ma-ar-ali an napfagpfagto. Muti pfu-un an chicha chi umuy ad chalom. Ti nu na-at ad Sodom hachi otong an milagro an enat u ay nuy pfuglay cha hot chidchin-ug agkhu niꞌ hachi eSodom hana pfahor cha hot agkhuy koma khenhob Apo Jos chin pfuglay cha ta gawwacha ingkhana ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Alloꞌ ay chaꞌju hi, umali ayya hini arkhaw an Panugijan Apo Jos hana tatakhu, ja machamchamot hini dusan hana tatakhu ad Capernaum mu hay hachi tatakhu ad Sodom an khenhob Apo Jos chin timpon Abraham.” ");
INSERT INTO ifu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Emmopoh hitay an inalin Hesus ja nungkalalag an inali na hi, “Ama, munyamanaꞌ ay he-a an Ap-apo hina ad langit ja heto lota, ta agkhuy mu impa-innila hay hato hana tatakhu an mangali an manomnom an cho-or chi achar cha, ta hay hana ma-id achar na chi nangpa-innilaam. ");
INSERT INTO ifu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Maphod hitay, Ama, ti hijah tay hini penhod mu.” ");
INSERT INTO ifu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Inalin khu Hesus hachi tatakhu hi, “Impulang Ama an amin ay ha-in ta ha-in chi mangpagpong. Ma-id chi uchumnah nanginnila hi omaꞌ-ataꞌ nu pfu-un hi Ama ja angkhay. Amat hina khu ay Ama an ma-id chi hay nanginnila hi omaꞌ-atana nu pfu-un ha-in an Empfalay na ja hana podhoꞌ an pangpa-innilaan ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Umali aju an amin ay ha-in, chaꞌju an machachamtan ja maliglikhatan. Ehchor ju an amin ay ha-in hot ha-in chi mangchat hi pun-ar-alenagwaan ju. ");
INSERT INTO ifu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Unuchon ju hana tukhun u ja mumpatuchu aju ay ha-in, ti ma-olojaꞌ ja napakumbaba, hot mun-ar-alenagwa aju. ");
INSERT INTO ifu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti hana tukhun u ja achi nalikhat hi unuchon an achi pumalikhat.” ");
INSERT INTO ifu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Unot achi mapfajag ja enenggwan cha Hesus han natamman hi trigo. Ja netongor ja Hapfachu an ngilin chi Hudju. Hemmenaang hachi disipolo na an ninitnud ay hija ja ente-a cha an pfumangkhi hachi trigo ta anun cha. ");
INSERT INTO ifu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gwacha hachi Farisee an nannig ja inali chaot ay Hesus hi, “Tikham akay niꞌ hay hato disipolom an khun cha mun-utim. Ja un chah pfu-un tamu chi mun-utim an paꞌ-iyona hini urchin ta-o, an paniyaw chi muntamu ti ngilin?” ");
INSERT INTO ifu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tempfar Hesus ja inali na hi, “Un ju chah agkhuy pfinaha chin enat chin apo ta-o an hi Ari David ja chin numpun-ibpfa na hi i cha hemmenaangan, ");
INSERT INTO ifu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","an himmikhop hi David hichin pfalay Apo Jos ja enala na chin tenapay an netpfar ay Apo Jos, ja inana ja inchatana khu chin numpun-ibpfa na. Ja paniyaw chi mangan ay ni netpfar an tenapay, ti hana papachi chi mangan ja angkhay. Ja ma-id inalin Apo Jos hi un pfahor hitay enat cha. ");
INSERT INTO ifu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ja pfinaha ju mit khu ay ni urchin Moses hini aton chi pachi, an khun cha muntamu hichi Templo hi nun Hapfachu an ngilin, ja pfu-un pfahor hitay khun cha aton. ");
INSERT INTO ifu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Alloꞌ ay chaꞌju an gwacha ad ugwani an mimidchum ay chaꞌju hini napfagpfagto mu hini Templo. ");
INSERT INTO ifu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Allon ni Hapit Apo Jos hi, ‘Hini aton ju an munnignikha hi papadchung ju an tatakhu chi napfarpfalor ay ha-in mu hini pangdatunan ju hi animar.’ Nu na-awatan ju hitay hot achi ju koma papfaholon hana ma-id pfahor na.” ");
INSERT INTO ifu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja en-ang-angonoh Hesus an nangali hi, “Ha-in an Na-ilangitan an Takhu chi mangali nu ngay paniyaw ay ni arkhaw chi ngilin.” ");
INSERT INTO ifu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Atoꞌtogna chin agawwachaan cha hichi pajaw ja immuy cha Hesus hichi sinagoga. ");
INSERT INTO ifu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ja gwa hichi han lala-e an napechoy chin oha an ngamoy na. Ja khun hempfogpfokhon hana tatakhu ay Hesus hi, “Mapfalin chah ay ni urchin Moses chi mangpatenong hi munchokhoh hi timpon chi ngilin?” Ja henehemmon cha hay pehallaan ni pampfar Hesus ta gway ipapfahor cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Muti tempfar Hesus ja inali na hi, “Nu khulat ta gway oha hi karnero ju an na-ubhung hi pfito hi arkhaw chi ngilin, ja un ju chah achi i inaton khapo ta ngilin? ");
INSERT INTO ifu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ja munnaud an napfarpfalor hini takhu mu hay karnero. Hotti achi pumaꞌ-i ay ni urchin hini pangatan hi maphod anong un arkhaw chi ngilin.” ");
INSERT INTO ifu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ja inalin Hesus ay chuy napechoy hi, “Uꞌjachom hini ngamoy mu.” Unaot inuꞌjad ja numpfangngad mahpay an mechon chin ngamoy na ja niꞌpadchung chin oha. ");
INSERT INTO ifu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amat hichi ja nakak hachi Farisee ja i cha nunhahappitanan nu ngay aton cha an mamatoy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Inannilan Hesus hitay khun hahapiton hachi Farisee ja nakak ay chuy an pfuglay. Cho-or hachi ninitnud ay hija ja empatenong na an amin hachi gway chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ja inali na ay chicha ta ma-id i cha pangar-allan ay ni nitakhuwana. ");
INSERT INTO ifu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Inali na hitay ta ipa-annung na chin intulaꞌ profeta Isaiah chin nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tayya hitay pfaar u an piniliꞌ. Hijay podpodhoꞌ ja munchenolaꞌ ay hija. Honakhoꞌ hitay Espirituꞌ ta munheto ay hija Ja ipa-innila na hini atoꞌ an manugwi hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ja achi meꞌhohongnger ja achi mun-ugwap, Ja achi mango-otong an munhapit hichi kurha. ");
INSERT INTO ifu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Achi na punhopiꞌ hini nahpaꞌ an hepeng, Ja achi na odpon hini mamadchop an panor. Amat heto chi atona ingkhana hi mangapfak hini magpong an planon Apo Jos, ");
INSERT INTO ifu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ja hijay pangehcholan an amin chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gwa han in-uy cha ay Hesus an lala-e an napfulaw ja nakalud khapo ta nahuhuꞌlungan hi napukhit an ispiritu. Empakak Hesus chin napukhit an ispiritu ja himmapit chin nakalud ja mitikhaw chin mata na. ");
INSERT INTO ifu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja nanor hachi tatakhu an nannig ay tay an na-at. Khun cha allon hi, “Ma-id maptoꞌ nu hitay hini Mamahhod an holag Ari David?” ");
INSERT INTO ifu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Muti unagkhu chengngor hachi Farisee hitay inalin hachi tatakhu ja inali cha hi, “Un kaykhu hi Beelzebub an ap-apon chi nun-apukhit an ispiritu hini nangchat ay hija ay ni apfalinana an khun mangpakak hana napukhit an ispiritu.” ");
INSERT INTO ifu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aniꞌ-ilan Hesus chin khun cha nomnomon ja inali na ay chicha hi, “Nu khulat ta hana tatakhu ay ni oha an himpangili ja ma-a-aggwa cha ta un chicha khu hon numpapattoy cha, hot un loꞌtatna hot mapaꞌ-i hinuy an himpangili. Amat hina khu nu itannong hana hen-a-amma hon numpapattoy cha, hot un loꞌtatna hot mapaꞌ-i cha khu. ");
INSERT INTO ifu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Omaꞌ-at hina khu nu hi Beelzebub an hi Satanas chi mangpakak hi napukhit an ispiritu. Nu amat heto hot un mah hi Satanas hon neꞌpatoy khu hay hana in-inupfor na. Ja khulat ta amat heto chi i na amatan hot un hija hon pinaꞌ-i na khu hini pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Allon ju hi un narpu ay Beelzebub hitay apfalinaꞌ an mangpakak hi napukhit an ispiritu. Ja gwacha khu hana padchung ju an Hudju an khun mangpakak hi napukhit an ispiritu. Hot un ju chah allon un narpu ay Beelzebub hini apfalinan cha? Hotti tayya an hay hato padchung ju chamchama an Hudju chi muntihtikhu an nehahalla hini khun ju nomnomnomon ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ay ha-in ja inchat ni Espiritun Apo Jos hini apfalinaꞌ an mangpakak hi napukhit an ispiritu, ja hay hato chi panginnilaan ju an nete-a hini pun-ap-apugwan Apo Jos ay tay lota. ");
INSERT INTO ifu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hi Satanas ja amat ay ni mapfi-ah an takhu an mumpfantay ay ni pfalay na. Nu khulat ta gway mamhod an mangakaw ay ni khina-u na ja ma-id olog na. Khahin un kha-utan hinuy mapfi-ah an takhu ja un ma-ala hana khina-u na. ");
INSERT INTO ifu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hana takhu an achi midchum ay ha-in ja chicha hini pfomopfohhor ay ha-in. Ja hay hana achi tomolong an mangajakhan hana tatakhu an miꞌ-unud ay ha-in ja chicha hana mangaapfor hi tatakhu ta achi cha midchum ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hotti hitay chi alloꞌ ay chaꞌju, an mapakawan an amin hana pfumahulan chi tatakhu ja hana pangallan cha hi napukhit an mipfuhur hi ibpfa chah takhu. Muti hana munhapit hi mipfuhur ay ni Espiritu Santo ja achi cha mapakawan ta pfahor cha ja ingkhana. ");
INSERT INTO ifu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja an amin hana munhapit hi napukhit ay ha-in an Na-ilangitan an Takhu ja mapakawan cha, muti hana munhapit hi napukhit ay ni Espiritu Santo ja achi cha mapakawan, ta pfahor cha ad ugwani ja ingkhana ay ni me-aggwa an piꞌtakhuwan.” ");
INSERT INTO ifu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Hini ayya ma-ali an maphod an ajiw ja maphod chi pfunga na. Napukhit ayya hini pfunga na ja hija hini napukhit an ajiw. Ti hini pfungan ni ajiw chi panginnilaan ay ni kalahe na. ");
INSERT INTO ifu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hotti chaꞌju an napukhit chi nomnom na ja achi mehalla an hay pfumutay ay ni ta-o ju ja napukhit. Ti hini pfumutay ay ni ta-on ni takhu ja hijah nuy hini gwa ay ni nomnom na. ");
INSERT INTO ifu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nahamad ayya hini takhu an maphod hini nomnom na ja maphod hini hapitona. Napukhit ayya hini takhu an napukhit hini gwa ay ni nomnom na ja napukhit khu chi hapitona. ");
INSERT INTO ifu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Alloꞌ ay chaꞌju hi, ay nuy arkhaw an Punhugijan Apo Jos ja hongpfatan hana tatakhu ay hija an amin hana agkhuy cha enor-oloꞌla an hinapit. ");
INSERT INTO ifu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ti hini hinapit mu chi panugijan Apo Jos ay he-a. Maphod ayya ja hijay panginnilaan an maphod hini nomnom mu hot achi a madusa. Napukhit ayya ja hijay panginnilaan hi gway pfahor mu hot madusa a.” ");
INSERT INTO ifu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Amat hichi ja himmapit chin uchumna an Farisee ja memehtolon chi urchin Moses an inali cha ay Hesus hi, “Apo, ipatikhaw mu adchiya hay milagro ta panginnilaan mi an narpu ay Apo Jos hini apfalinam.” ");
INSERT INTO ifu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ja inalin gwot Hesus hi, “Un aju kaykhu mumpunlahlah an tatakhu ad ugwani an timpo, ti napukhit hini nomnom ju ja chin-ug ju hi Apo Jos. Itugtukha ju an mangpfokha hi hay ipatikhaw u hi panginnilaan ju an narpu ay Apo Jos hitay apfalinaꞌ. Muti ma-id, ti un angkhay hini omaꞌ-at chin na-at ay profeta an hi Jonah chi ipatikhaw u ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ti hi Jonah ja inuꞌmun chin ekan ja nihihidchi poto na hi toloh arkhaw. Amat hina khu ay ha-in an Na-ilangitan an Takhu, an milupfu-aꞌ hi toloh arkhaw. ");
INSERT INTO ifu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Machakngan ayya chin arkhaw an Panugijan Apo Jos hi tatakhu hot miꞌtaꞌchug hay hana eNineveh hot chichay mangpatikhaw an gway pfahor ju. Ti hay hachi eNineveh ja chengngor cha chin engkasaban Jonah ja chin-ug chay pfahor cha. Ja tayya an ad ugwani ja gawwa ay chaꞌju han napfagpfagto mu hi Jonah an muntugtukhun ay chaꞌju ja niya an achi ju chuꞌkhon hana pfahor ju. ");
INSERT INTO ifu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ja miꞌtaꞌchug khu hichin pfupfai an reyna ad Sheba chin nahop hot hijay mangpatikhaw an gway pfahor ju. Ti hichuy an reyna ja narpu hi achawwi ta i na chonglon hichin manomnom an muntukhun an hi Ari Solomon. Ja tayya an gawwa ay chaꞌju ad ugwani han napfagpfagto mu hi Solomon muti niya an achi ju chonglon hini tukhuna.” ");
INSERT INTO ifu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Inalin khu Hesus hi, “Nu makak hini oha an napukhit an ispiritu an nehoꞌlong ay ni takhu hot umuy hana lukhar an ma-id nunheto ta i maningit hi i na pun-enanaan muti ma-id machakngana. ");
INSERT INTO ifu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hotti allona hi, ‘Un u gwot pfangngachon chin pfalay an tenaynaꞌ.’ Hotti mumpfangngad ja tikhana chin pfalay na an maleneh ja napanuh, ti ma-id nepallog an munheto. ");
INSERT INTO ifu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hot epacheh na khu an i mun-aw-agwit hi peto hi munnaꞌnaud an napukhit an ispiritu ta gway pun-ibpfa na an i munheto ay ni pfalay an tenaynana. Hotti munnaꞌnaud an kaꞌka-ahi hinuy an takhu mu hichin pengpenghana. Ja hijah nuy chi ma-at ay chaꞌju ad ugwani an nunchongor ay tay tukhun u muti achi ju pattiyon.” ");
INSERT INTO ifu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gwa an khun muntudtuchu hi Hesus chin tatakhu ja emmatam chin ammod na an hi Mary ja chin a-akhi na an linala-e ay chuy agawwachaana. Timmataꞌchug cha hichi pfutayna ja empa-ajag cha hi Hesus ti penhod cha an miꞌhapit ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ja gwa han oha an nangali ay Hesus hi, “Chiya an gwacha hi inam ja hana a-akhim an timmataꞌchug hichi pfutayna ja khun chi-a epa-ajag ta miꞌhapit cha ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ja inalin Hesus hachi tatakhu hi, “Aa, muti un chah chicha chi a-ammod u ja a-akhiꞌ ja angkhay?” ");
INSERT INTO ifu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ja lenchong na hachi disipolo na ja inali na hi, “Hay hato khu chi a-ammod u ja a-akhiꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ti hay hana khun mangat ay ni penhod Ama an gwa ad langit ja chichay mipfilang hi a-akhiꞌ ja chichay a-ammod u.” ");
INSERT INTO ifu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ay chuy gwot an arkhaw ja nakak cha Hesus ay chuy an pfalay ja immuy cha hichi pingngit chi baybay, ja inumpfun hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ja munhihiꞌ-ig hachi atakhutakhu an mali-ub ay hija, hotti immuy nunlukhan han pfalangay an nebnebtaw ay chuy palantag an timmataꞌchukhan chin cho-or an tatakhu, ja inumpfun ta muntuchu. ");
INSERT INTO ifu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ja cho-or chin intuchun Hesus an in-ari-arig na. Ja inali na hi, “Gwa han ohan takhu an immuy nunhapuwaꞌ hi pfugwa hichi hapfar na. ");
INSERT INTO ifu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Khun munhapuwaꞌ ja nepochag chin uchumna ay ni chalan, ja numpanga-ali chin hagwiti ja nun-a-an cha. ");
INSERT INTO ifu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chin uchumna ja nepochag chin mapfinato an lota. Khagkhaju cha an hemmangaw ti maymayyapit chin lota ");
INSERT INTO ifu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","muti chin apfi-ahan chi hukhit ja naꞌleng, ti un nitutu-i chin hemmangagwana. ");
INSERT INTO ifu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nepochag khu chin uchumna chin achoꞌlan chi holoꞌ an nun-apakhatan. Un chaagkhu hemmangaw ja emmaꞌlap hachi nun-apakhatan an holoꞌ ja hinaꞌpfungan cha chin nitanum hotti agkhuy penomhod. ");
INSERT INTO ifu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ja chin uchumna ja nepochag chin maphod an lota, ja numpangahangaw cha ja numpangapfunga cha. Ja hachi uchumna ja pfimmunga hi hinkhakhahot, ja hachi uchumna ja pfimmunga hi unum chi polo, ja hachi uchumna ja pfimmunga hi tolom polo.” ");
INSERT INTO ifu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ja inalin khu Hesus hi, “Pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Immuy hachi disipolo ay Hesus ta i cha epfokha hi, “Anagkha mah ta pangngarig hini atom an muntudtuchu ay cha tay an tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ja inalin Hesus hi, “Aa, ti chaꞌju hana pangpa-innilaan Apo Jos ay ni omaꞌ-atan ni Pun-ap-apugwana. Hana ayya uchumna an achi miꞌ-unud ja achi mipa-innila ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ti hini takhu an miꞌ-unud ay ni ituchuꞌ ja umannung an ma-ug-ugman hini mituchu ay hija ta chomchom-or chi annilaona. Hini ayya takhu an una lamangon an achi miꞌ-unud ay ni ituchuꞌ ja anong un hini anila na ja ma-utaw ay ni nomnom na. ");
INSERT INTO ifu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hotti hini atoꞌ an muntudtuchu ja pangngarig, hot anong un cha khun tikhan hana khun u aton ja chengngor cha hana khun u itudtuchu ja achi cha chamchama ma-awatan. ");
INSERT INTO ifu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ti immannung chin impadtun profeta Isaiah hi nangarjana hi, ‘Hay hato an tatakhu, anong un nun-alu-angan hana inga cha ja achi cha chomngor, Ja anong un himulimuli hini mata cha ja achi cha tumikhaw. ");
INSERT INTO ifu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Empop cha hachi inga cha ta achi cha chonglon chi tukhun, Ja inimit cha hachi mata cha ta achi cha tikhan hini umannung an omaꞌ-atana. Ja pfimmato hini nomnom cha. Ti allon Apo Jos hi, “Anaad tugwali ta achi cha podhon an tumikhaw ja an chomngor? Ja anagkha ta achi cha podhon an matuchugwan? Ja anagkha ta achi cha chuꞌkhon hana pfahor cha ja achi cha mungkalalag ay ha-in ta takhuwoꞌ chicha?” ’ ” ");
INSERT INTO ifu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ja inalin Hesus hachi disipolo na hi, “Akhaꞌkhaja aju ti mitikhaw hana mata ju ja chomngor hana inga ju. ");
INSERT INTO ifu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ja umannung hitay alloꞌ ay chaꞌju an akhaꞌkhaja aju pay mu hachi cho-or an profetan Apo Jos ja magpong an tatakhu chin nahop, ti penhod cha an ah-upan an manikhaw hato khun ju tikhan muti agkhuy cha niꞌtikhaw. Ja penhod cha khu an munchongor hato khun ju chonglon muti agkhuy cha ne-egngor. ");
INSERT INTO ifu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hotti chonglon ju ta alloꞌ hini podhon tay pangngarig an hapiton. ");
INSERT INTO ifu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hana pfugwa an nepochag ay ni chalan ja hija hana tatakhu an nunchongor ay ni mitudtuchu an omaꞌ-atan ni Pun-ap-apugwan Apo Jos ja agkhuy cha na-awatan. Ja umuy hi Satanas ta akagwona chin hapit an chengngor cha. ");
INSERT INTO ifu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja hana ayya nepochag ay ni mapfinato an lota ja hija hana tatakhu an nun-an-anla an nunchongor ay ni Hapit Apo Jos ja inapfulut cha gwot, ");
INSERT INTO ifu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","muti un naꞌnaꞌ-omtang, ti agkhuy limmamot hini hapit na ay chicha. Unchani ta umali hana apalikhatan ja apahigwan khapo hi nangapfulutan cha ay ni hapit Apo Jos ja chin-ug chaot hini pammati cha. ");
INSERT INTO ifu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja hana ayya nepochag ay ni achoꞌlan chi holoꞌ an napakhatan ja hija hana tatakhu an nunchongor, muti immali ayya hana pundanakhan ay tay piꞌtakhuwan ja hana homalegwa an nomnom hi omachangjanan, ja nahi-ig hini Hapit Apo Jos ja achi cha miꞌpfunga. ");
INSERT INTO ifu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hana ayya nepochag ay ni maphod an lota ja hija hana nunchongor ay ni Hapit Apo Jos ja na-awatan cha. Ja pfimmunga cha hi maphod, hachi uchumna ja hinkhakhahot chi pfunga cha, ja hachi uchumna ja hin-uꞌnum chi polo, ja hachi uchumna ja hintotlompolo.” ");
INSERT INTO ifu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Inalin khu Hesus hachi atakhutakhu han pangngarig an amat heto, “Hini pipadchungan tay Pun-ap-apugwan Apo Jos ja mipadchung ay ni takhu an i na enhamar han pfinlungan an trigo. ");
INSERT INTO ifu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Unot limmapfi an naloꞌ an amin chi tatakhu ja immuy hini pfuhur na ja i na nun-epfetaꞌ an intanum han holoꞌ ay chuy trigo ja nakak. ");
INSERT INTO ifu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ja hemmangaw chin trigo ingkhana an numpfuhug, ja matikhaw hachi holoꞌ an neꞌhangaw. ");
INSERT INTO ifu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ja immuy hachi takhala na ja inali cha ay ni apo cha an nanghapfar hi, ‘Apo, maphod chin intanum mu an trigo ay ni hapfar mu, muti gwa mangkay hana holoꞌ an nun-epfetaꞌ ay nuy trigo.’ ");
INSERT INTO ifu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tempfar chin apo cha ja inali na hi, ‘Aa, ti gwacha han pfuhur ta-o an hijay nangat.’ Ja inali cha hi, ‘Ti podhom ayya ja i mi pumpfaꞌkhut hinuy holoꞌ.’ ");
INSERT INTO ifu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Muti inali na hi, ‘Achi ju, ti unchani ja niꞌpfaꞌkhut hana trigo. ");
INSERT INTO ifu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Anong kay ja neꞌ-otong hana holoꞌ ingkhana an machakngan chin ahebtoꞌ. Ja alloꞌ hana mumpfotoꞌ ta pahhunon cha an ánun hana holoꞌ ja pfina-ud cha ta i cha poolan, ja un chaot etoloy an pfot-on hinuy trigo ta amungon cha ja i cha emponpon ay ni alang u.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Intuchun khu Hesus han pangngarig ja inali na hi, “Hini Pun-ap-apugwan Apo Jos ja mipadchung ay ni ohan pfugwan chi lakotta an intanum han takhu ay ni hapfar na. ");
INSERT INTO ifu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hija hini it-ittangan an amin hi pfugwa heto lota muti hemmangaw ayya ja khun um-umuy chi arkhaw ja umajiw ja ot-ottongan mu hay hana uchumna an hamchaꞌ. Ja mapfalin an pun-emengan chi hagwiti hini hepeng na.” ");
INSERT INTO ifu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ja intuchun khu Hesus han pangngarig ja inali na hi, “Hini Pun-ap-apugwan Apo Jos ja ipadchung u khu ay ni pfinoꞌpfoꞌ an inidchum han pfupfai han toloh halug an alena. Ja impalaꞌ-ukhun chuy it-ittang an pfinoꞌpfoꞌ hichuy cho-or an alena.” ");
INSERT INTO ifu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pangngarig chin enat Hesus an nangtuchu an amin hay hato, ja ma-id intuchu na hi agkhuy na in-arig. ");
INSERT INTO ifu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Enat na heto ta mipa-annung chin inalin chin oha an profetan Apo Jos hi nangarjana hi, “Pangngarig hini panudtuchuꞌ ay chicha, Ja chin agkhuy nipa-innila nete-a chin narmugwan tay lota ja itudtuchuꞌ ay chicha ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Amat hichi ja tenaynan Hesus chin atakhutakhu ja himmikhop cha ay ni pfalay an nunhihittugwan cha. Ja niꞌhapit chin disipolo na ja inali cha hi, “Ituchum adchiya ngay i-arig ni holoꞌ an nepfetaꞌ ay ni trigo.” ");
INSERT INTO ifu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ja inalin Hesus hi, “Hini ayya nuntanum ay ni maphod an trigo ja ha-in an Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hini ayya hapfar ja hija hitay lota. Hana maphod an pfugwan chi trigo ja chicha hana tatakhu an nidchum ay ni Pun-ap-apugwan Apo Jos. Hana ayya holoꞌ ja chicha hana tatakhun Satanas. ");
INSERT INTO ifu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hinuy pfuhur an i nangpfetaꞌ ay ni holoꞌ ja hi Satanas. Hini pfotoꞌ ja hija hini apogpokhan tay lota, ja hana mumpfotoꞌ ja chicha hana angher. ");
INSERT INTO ifu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tipunon cha hachi holoꞌ ja mapoolan cha, ja amat hina khu chi ma-at chin apogpokhan tay lota. ");
INSERT INTO ifu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ti ha-in an Na-ilangitan an Takhu, ja honakhoꞌ hana angher u ta umuy cha an amin ay ni Pun-ap-apugwaꞌ, ta amungon cha an amin hana nangat hi napukhit ja hana chimmalat hi pfimmahulan chi ibpfa chah takhu. ");
INSERT INTO ifu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Amungon cha ja intuud cha ay ni khun munchalang an apoy hot mun-okhab cha ja mungngelot hana pfapfa cha. ");
INSERT INTO ifu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ja hana ayya magpong an tatakhu ja humilaw cha ay ni Pun-ap-apugwan Ama cha an amat ay chuy hukhit. Hotti pa-ennongan ju an ekhongahan hitay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Inalin khu Hesus hi, “Hini Pun-ap-apugwan Apo Jos ja mipadchung han pfalituꞌ an nilulupfuꞌ han lota. Unot chinakngan han ohan takhu ja munnaud an mun-an-anla. Amat hichi ja khinapfunana ja empacheh na an i nangeplaꞌ an amin hachi khina-u na ta i na pola-on hichuy an lota an nilub-an chuy pfalituꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hay oha khu an pipadchungan ni Pun-ap-apugwan Apo Jos ja amat ay ni mungkumerchu hi perlas an homenad an i maningit hi maphod an perlas. ");
INSERT INTO ifu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Unaagkhu chinakngan han maꞌ-aphod an perlas ja ina eneplaꞌ an amin hana khina-u na ta pola-ona hichuy an perlas.” ");
INSERT INTO ifu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Inalin khu Hesus hi, “Hini Pun-ap-apugwan Apo Jos ja mipadchung han tapfukur an en-apja cha hichi baybay ja cho-or hachi numpfino-ob-on an khachiw an neꞌna. ");
INSERT INTO ifu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Napnu ayya chin tapfukur ja khinujud cha ta echa-ar cha. Inumpfun cha ta polenan cha hana maphod hi ihcha ja nun-itto cha hana tempfa. Hana ayya achi mihcha ja nun-etapar cha. ");
INSERT INTO ifu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amat hina khu chi ma-at chin apogpokhan tay lota. Umali hana angher ta annikhon cha hana tatakhu an napukhit chi ugali na, ja annikhon cha khu hana tatakhu an ipfilang Apo Jos hi magpong. ");
INSERT INTO ifu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hot hana napukhit chi ugali na ja etapar cha ay ni apoy. Ja mun-okhab cha ja mungngelot hana pfapfa cha.” ");
INSERT INTO ifu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ja inalin Hesus hi, “Hot na-awatan ju chah an amin hay hato?” Ja inali cha chi aa. ");
INSERT INTO ifu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ja inali na khu hi, “Hot ma-awatan ju hitay alloꞌ an nu gway mehtolon chi urchin Moses an natudtuchugwan ay ni omaꞌ-atan tay Pun-ap-apugwan Apo Jos, ja mipadchung ay ni oha an nangpfalay an gway enhaꞌpfa na hi pfakhu an khina-u, ja gwacha khu chi enhaꞌpfa na hi napfajag an khina-u. Hot anila na an mangpapfutay ay ni mahapor na, nu pfakhu wenno napfajag.” ");
INSERT INTO ifu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Napfalin an intuchun Hesus hay hato an pangngarig ja nakak ");
INSERT INTO ifu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ta numpfangngad ay ni pfuglay an emmer-erkhana. Ja immuy hichi sinagoga an i nuntudtuchu. Ja nanor hachi khun munchongor, ja inali cha hi, “An ngay nangalan tay ay ni nomnom na? Ja ngay nangalana ay ni apfalinana an mangat hi milagro? ");
INSERT INTO ifu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Un chah pfu-un hitay hini empfalay ni karpentero? Un chah pfu-un hi Mary chi ammod na, ja a-akhi na cha James ay Josep ja hi Simon ja hi Judas? ");
INSERT INTO ifu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja neꞌhehetto khu hana i-ibpfa na an pfinapfai. Hot ngay nangalana ay ni nomnom na ja apfalinana?” ");
INSERT INTO ifu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja angkhay hachi ja pfen-on cha. Ja inalin Hesus ay chicha hi, “Egngor hana tatakhu hini profeta an narpu hi uchumna an pfuglay muti achi cha egngor ay ni pfuglay an narpugwana ja anong un hini pamilya na.” ");
INSERT INTO ifu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hotti ma-id cho-or hi milagro hi enat Hesus ad Nazaret khapo hi achi cha pammatiyan ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nunchongor chin omaꞌ-atan Hesus hachi apfuglapfuglay ja chengngor khu Herod an ap-apo ad Galilee. ");
INSERT INTO ifu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ja inali na hachi takhala na hi, “Hitay an hi Hesus ja hija khuh niꞌ hi John Bautista an un nummahu, hijaot un gway apfalinana an mangat hi milagro.” ");
INSERT INTO ifu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Inalin Herod hitay khapo ta hijay nangpapatoy ay John. Chimmalat chin himminglan John, ti hi Herod ja ma-id mahamma na ja i na penloh hi Herodias an ahagwan Philip an ibpfa na. Khun allon John ay Herod hi pfahor hitay enat Herod, hotti hennag na hana i naniliw ay John ja impipfalud na. ");
INSERT INTO ifu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Penhod na an mangpapatoy ay John muti ma-id enat na, ti temma-ot hija hachi tatakhu an namati ay John an hijay profeta. ");
INSERT INTO ifu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Unot nachakngan chin arkhaw an i nituꞌkhungan Herod ja nun-ajag hi tatakhu ta pfehtaan cha. Ja gwa han empfalay Herodias ay Philip an pfalahang ja immuy nunsala ta tikhan hachi tatakhu an na-amung. Enamnagwan Herod chin enat na an nunsala, ");
INSERT INTO ifu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hotti enhapata na an ichat ay hija nu ngachah ni epfokha na. ");
INSERT INTO ifu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Timpug nuy pfalahang chin ammod na an hi Herodias nu ngay epfokha na ay chuy Ari hi ichat na. Ja hay intukhun Herodias ja inali na ay ni pfalahang hi epfokha na ay Herod hini ulun John Bautista ta itto cha hi chuju ja inchat cha ay hija. Inunud chin pfalahang chin intukhun ni ammod na, ");
INSERT INTO ifu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ja muntutuju hi Ari Herod chin inali na muti un amat ja inimit na, ti chengngor hachi na-ila chin enhapata na. ");
INSERT INTO ifu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hotti hennag na han hinchalo na ta immuy hichi pfaluchan ta i na pinutulan chin ulun John. ");
INSERT INTO ifu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ja initto na chin ulu han chuju ja in-uy na ay chuy pfalahang. Ja in-uy khu chuy pfalahang ay chuy ammod na an hi Herodias. ");
INSERT INTO ifu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja immuy hachi disipolon John ja enala cha chin achor na ta i cha inlupfuꞌ. Napfalin ja i cha impa-innila ay Hesus hitay an na-at. ");
INSERT INTO ifu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Inannilan Hesus an penatoy cha hi John ja initnud na hachi disipolo na an nakak ay chuy an pfuglay ta i cha mun-ohha an i mun-eblajan. Hotti nunlukhan cha han pfalangay ja empacheh cha an umuy. Muti unagkhu inannilan hachi tatakhu hi apfuglapfuglay chin immajan cha Hesus ja chinallan cha an nangunud. ");
INSERT INTO ifu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Unagkhu emmatam cha Hesus ja nakak ay chuy pfalangay ja tinnig na hachi atakhutakhu. Ja na-apja hini nignikha na ay chicha, ja empatenong na hachi mumpunchokhoh. ");
INSERT INTO ifu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Unot gwa an nahilip ja immuy hachi disipolo ay Hesus ja inali cha hi, “Honakhom hato tatakhu ta umuy cha hachi pfarju ta i cha ngumina hi anun cha. Ti chiya an nahilip ja ma-id pfarpfalay ay tay agawwachaan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ja inalin Hesus hi, “Achi khahin un cha makak ta chaꞌjuwot chi mangchat hi anun cha.” ");
INSERT INTO ifu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ja inali cha ay hija hi, “Ma-id ichat ta-o hi anun cha, Apo, ti tan un angkhay han lema an tenapay ja han chugwa an khachiw chi gwa heto.” ");
INSERT INTO ifu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ja inalin Hesus hi, “Ijali ju ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Amat hichi ja impapfun Hesus hachi tatakhu. Enala na chin lema an tenapay ja chin chugwa an khachiw, ja entangad na an nunyaman ay Apo Jos. Napfalin ja initta-ittang na ja inchat na hachi disipolo ta egwanah cha hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangan cha hotti na-apchan cha an amin. Inamung hachi disipolo hachi nahagwar ja nun-apnu han hempolo ta han chugwa an pfahkit. ");
INSERT INTO ifu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ja umuy hi lemay lipfu hana linala-e an penangan Hesus, ja to-ona hachi nidchum an pfinapfai ja inung-ungungnga. ");
INSERT INTO ifu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Unot napfalin hay hato ja hennag Hesus hachi disipolo na ta i cha nunlukhan chin pfalangay ta ipangpangullu cha an umuy chin chammangna. Nuntaynan hi Hesus ja nun-ipa-anamut na chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Un chaot nakak ja nunti-id hi Hesus ay chuy pfuludna ta i omohha an mungkalalag. Gwa an nadhom ja gawwa pay hi Hesus hichi pfuludna an emmo-ohha. ");
INSERT INTO ifu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ja chin pfalangay an nunlulukhanan hachi disipolo ja gwacha hichi khawwan chi baybay. Ja khun matangitangillig, ti gwa han ijah an mangpapfangngad ay chuy pfalangay ja mapfi-ah an muntipjaꞌ-ong chin chanum. ");
INSERT INTO ifu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Unot penghan chi talanu ja nangunud hi Hesus ay chuy agawwachaan cha an khun chumalan ay chuy chanum. ");
INSERT INTO ifu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Unot tinnig hachi disipolo ja nang-entata-ot cha. Ja iniꞌgwap cha hi, “Chiya han pfanig!” ");
INSERT INTO ifu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ja himmapit gwot hi Hesus ja inali na hi, “Achi aju toma-ot ti ha-in. Hotti papfi-ahon ju hini nomnom ju.” ");
INSERT INTO ifu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Amat hichi ja niꞌhapit hi Peter ja inali na hi, “Ti he-a ayya, Apo, ja mapfalin chah an meꞌchalanaꞌ ay tay chanum ta umaliyaꞌ ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ja inalin Hesus hi, “Aa, hotti umali a.” Ja pfimmutay hi Peter chin pfalangay ja ente-a na an chumalan ay chuy chanum an umuy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Muti unaagkhu tinnig chin chanum an khun muntipjaꞌ-ong ja temma-ot, ja ente-a na an munlinong. Ja nun-ugwap an allona hi, “Apo, tulunganaꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Inchugwagwan Hesus chin ngamoy na ja penchona hi Peter ja inali na ay hija hi, “Un kaykhu it-ittang hini pammatim! Agkhuy a koma nunharhalinchugwa.” ");
INSERT INTO ifu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amat hichi ja immuy cha niꞌlukhan chin pfalangay ja khemmenong gwot chin ijah. ");
INSERT INTO ifu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ja hachi nunlulukhan ay chuy pfalangay ja ente-a cha an mundayaw an allon cha hi, “Umannung an he-a hini Empfalay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pfinad-ang cha chin baybay ja emmatam cha ad Genesaret. ");
INSERT INTO ifu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Immatunan hachi tatakhu ad Genesaret hi Hesus hotti empa-ajag cha an amin hana mumpunchokhoh hay hachi nun-ehegkhon an apfuglapfuglay ta in-uy cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ja numpakpaka-ahi cha ay Hesus ta hachi mumpunchokhoh ja hoꞌ-on cha chin lopfong na, anong un hichin khalampfay na. Ja numpangatenong hachi nan-a chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gwacha hachi uchumna an Farisee ja memehtolon chi urchin Moses an narpu ad Jerusalem ja immuy cha ay ni gwachaan Hesus. Ja inali cha ay hija hi, ");
INSERT INTO ifu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Anagkha mah ta hachi disipolom ja achi cha khun unuchon chin intuchun hachi a-ammod ta-o an paniyaw chi mangan nu agkhuy ta numpfulu?” ");
INSERT INTO ifu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ja inalin khu Hesus hi, “Chaꞌju mah, chin-ug ju jaꞌ hana urchin Apo Jos, ti hinurpfuchan ju hini aton ju an mangat hana nepfanoh an ugali ju. ");
INSERT INTO ifu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ti in-urchin Apo Jos an, ‘Mahapor an unuchon ju hana a-ammod ju.’ Ja in-urchina khu an, ‘Hini mamahiw ay ni ammod na an lala-e wenno pfupfai ja patoy hini ohong na.’ ");
INSERT INTO ifu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Muti nab-on hini khun ju itudtuchu, ti hay allon ju ja nu enetpfar ni takhu ay Apo Jos hay mapfalin hi itolong na hana a-ammod na, ja achi na ichat ay cha nuy ammod na, ta achi mapaꞌ-i chin inali na an netpfar ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hotti tayya an khapo ay ni pangatan ju ay nuy nepfanoh an ugali ju ja amat hi ma-id pfalor nuy umannung an urchin Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Un aju kaykhu mumpfuhuur! Umannung chin impadtun profeta Isaiah an omaꞌ-atan ju chin nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Allon Apo Jos hi, “Hay hato an tatakhu ja khunaꞌ edaydayaw ay chicha muti un mepogpog ay ni ta-o cha an achi cha nomnomon an umunud ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ma-id inherpfin ni khun cha aton an mundayaw ay ha-in ti un hana urchin an enephod chi takhu hini khun cha itudtuchu, hon inali cha hi un narpu ay ha-in.”’ ” ");
INSERT INTO ifu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Enajakhan Hesus hachi tatakhu ta immuy cha ay hija ja inali na ay chicha hi, “Chonglon ju hitay alloꞌ ta ma-awatan ju. ");
INSERT INTO ifu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pfu-un hana anun an umuy ay tay ta-o chi mangpapukhit ay ni ohan takhu. Ti hini mangpapukhit ay hija ja hana na-uti-ot an nomnom na an pfumutay ay ni ta-o na.” ");
INSERT INTO ifu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Immuy hachi disipolo ay Hesus ja inali cha hi, “Anilam, Apo, an pukhiton hachi Farisee hinuy inalim.” ");
INSERT INTO ifu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ja nun-arig hi Hesus an nangali hi, “An amin chi homangaw an pfu-un hi Ama ad langit chi nangtanum ja mapfaꞌkhut. ");
INSERT INTO ifu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Un cha ikhad, hay hachi Farisee, ti allon cha hi khun cha ituchu hini agwun chi tatakhu muti napfulaw cha. Ja nu itnud ni napfulaw hini padchung na an napfulaw hot muntunud cha an makhah hay khohang.” ");
INSERT INTO ifu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ja nunhanhan pay hi Peter an empfokha na ay Hesus nu ngay podhon tay pangngarig an hapiton. ");
INSERT INTO ifu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tempfar Hesus ja inali na hi, “Un chah anong un chaꞌju ja achi ju pay ma-awatan? ");
INSERT INTO ifu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ti umannung chin inaliꞌ an hana anun an umuy ay tay ta-o ja achi umuy ay ni nomnom ni takhu, an un umuy ay ni poto na ja pfumutay khu ta metapar. ");
INSERT INTO ifu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ti hini mangpapukhit ay ni ohan takhu ja hana na-uti-ot an nomnom na an pfumutay ay ni ta-o na. ");
INSERT INTO ifu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hini napukhit an nomnom chi takhu ja hijay arpugwan chi napukhit. Ja hay ipfunga na ja napukhit an ugali, an amat hay hana i pomatoy, me-eloꞌ hi pfu-un ahagwa cha, omakaw, munlahlah an muntihtikhu, ja pumahiw. ");
INSERT INTO ifu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","An amin hay hato an napukhit an ugali ja hijay mangpapukhit ay ni ohan takhu. Hini ayya un ta mangan an agkhuy ta numpfulu ja pfu-un hinuy chi mangpapukhit ay ni takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Napfalin hay hato ja nakak cha Hesus ta umuy cha han pfuglay an nehegkhon ad Tiro ja ad Sidon. ");
INSERT INTO ifu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ja gwah chi han pfupfai an eKana-an an Hentil. Immuy ay Hesus ja numpakpaka-ahi an nangali hi, “Apo an holag Ari David, ka-ahiyanaꞌ adniꞌ, ti nahuhuꞌlungan han empfalay u an pfupfai hi napukhit an ispiritu ja munnaud an maliglikhatan.” ");
INSERT INTO ifu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Muti agkhuy tempfar Hesus. Immuy hachi disipolo ja inali cha ay hija hi, “Apo, honakhom hitay an pfupfai, ti tan khun mangumangunud an lulud an mumpakpaka-ahi.” ");
INSERT INTO ifu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ja inalin Hesus hi, “Hay immaliyaꞌ ja ta hingitoꞌ hana holag Israel an amat hi karnero an na-utaw, pfu-un hana Hentil an amat ay tay an pfupfai.” ");
INSERT INTO ifu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nehnot chamchama chin pfupfai ay hija ja nunheppe ja inali na hi, “Apo, tulunganaꞌ adniꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Impangngarig Hesus an nunhapit ja inali na hi, “Panganun ta-o pay hana ung-ungungnga ta ma-apchan cha. Ti achi maphod un alaon hini anun hana ung-ungungnga ja empa-an hana aho.” ");
INSERT INTO ifu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tempfar chin pfupfai ja inali na hi, “Umannung hini inalim, Apo, muti nu ipadchung chaꞌmi an Hentil hi aho, ja anun chi aho hana mun-akhah hi un mangan hana nang-aho.” ");
INSERT INTO ifu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ja inalin Hesus hi, “Otong hinuy pammatim! Hotti ma-at hini penhod mu.” Ja unot na-omtang hi nangarjan Hesus ay tay ja nakak chin napukhit an ispiritu an nehohoꞌlong ay chuy unga. ");
INSERT INTO ifu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Amat hichi ja nakak cha Hesus ay chuy an pfuglay ja numpfangngad hichi Baybay ad Galilee. Nunti-id han pfuludna ja inumpfun. ");
INSERT INTO ifu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ja cho-ocho-or hachi immuy ay hija, an initnud cha hachi napilay, napfulaw, napunguchan, nakalud, ja hachi pay uchumna an gway chokhoh na. In-uy cha chin agawwachaan Hesus ja nun-epatenong na chicha. ");
INSERT INTO ifu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ja manotoꞌ-ong hachi atakhutakhu an nannig, ti himmapit hachi nakalud, ja nepfangngad hachi nun-apunguchan, ja khun chumalan hachi napilay, ja mitikhaw hachi matan hachi napfulaw. Ja khun cha daydayawon hi Apo Jos an Jos cha an holag Israel. ");
INSERT INTO ifu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chin me-atloh arkhaw hi nihihidchijan cha ad Galilee ja enajakhan Hesus hachi disipolo ja inali na hi, “Tayya an nignikhaoꞌ hay hato an tatakhu ti neꞌhehetto cha ay chita-o hi toloh arkhaw ja chiya an napoh chin hongot cha. Achiꞌ podhon an mangpa-anamut ay chicha an agkhuy cha nangan, ti mahichingan cha an umuy.” ");
INSERT INTO ifu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ja inalin chin disipolo na hi, “Hotti ngay mah aton ta-o? Ti ma-id i ta-o pangalan hi omanay hi epa-an ay cha tay an cho-or an tatakhu, ti tan nenebtaw hitay agwachaan ta-o hichi pfuglay.” ");
INSERT INTO ifu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ja inalinot Hesus hi, “Atanay tenapay hi gawwa ay chaꞌju?” Tempfar cha ja inali cha hi, “Ti tan un peto, ja han tortollo an i-itang an khachiw.” ");
INSERT INTO ifu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Amat hichi ja impapfun Hesus hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Enala na chin peto an tenapay ja chin khachiw, ja nunyaman ay Apo Jos. Napfalin ja initta-ittang na ja inchat na hachi disipolo ta egwanah cha hachi tatakhu, ja enat cha. ");
INSERT INTO ifu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangan hachi tatakhu hotti na-apchan cha an amin. Inamung chin disipolo hachi nahagwar ja nun-apnu han peto an otong an pfahkit. ");
INSERT INTO ifu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hay pfilang hachi nangan ja apat hi lipfu an linala-e, ja to-ona hachi nidchum an pfinapfai ja inung-ungungnga. ");
INSERT INTO ifu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Amat hichi ja impa-anamut Hesus hachi tatakhu ja nunlukhan cha Hesus han pfalangay ta umuy cha han ohan pfuglay an ad Magadan. ");
INSERT INTO ifu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Immuy hachi uchumna an Farisee ja Saducee ay Hesus ta toptopngan cha. Inali cha ta ipatikhaw na hay milagro ta panginnilaan cha an narpu ay Apo Jos hini apfalinana. ");
INSERT INTO ifu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Muti agkhuy inapfulut Hesus ja inali na hi, “Nu gwan mahilip ta munlatikha ad uchu ja allon ju chi ukhaw ay nuy mun-inggwiꞌgwiit. ");
INSERT INTO ifu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ja nu gwa ayya ta nanong ta mango-orpfob ja allon ju chi lomomlom ay nuy an arkhaw. Anila ju an mangmatunan ay ni podhonan hapiton hana matikhaw hichi ad uchu, ja anagkha mah ta achi ju imatunan hini podhonan hapiton hay hato khun maꞌma-at ad ugwani an timpo? ");
INSERT INTO ifu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Un aju kaykhu mumpunlahlah an tatakhu ad ugwani an timpo, ti napukhit chi nomnom ju ja chin-ug ju hi Apo Jos. Itugtukha ju an mangpfokha hi hay ipatikhaw u hi panginnilaan ju an narpu ay Apo Jos hitay apfalinaꞌ. Muti ma-id, ti un angkhay hini amat chin na-at chin profeta an hi Jonah chi ipatikhaw u ay chaꞌju.” Amat hichi ja empacheh Hesus ja tenaynana chicha. ");
INSERT INTO ifu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Amat hichi ja nunlukhan cha Hesus chin pfalangay ja pfinad-ang cha chin baybay. Emmatam cha hichi chammangna ja nenomnom hachi disipolo an nalichuwan cha an nunhongot. ");
INSERT INTO ifu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Himmapit hi Hesus ja inali na ay chicha hi, “Elanna mangkay, achi la-ahna ja i ju inapfulut hini pfinoꞌpfoꞌ hachi Farisee ja hachi Saducee.” ");
INSERT INTO ifu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ja khun munhahapit chin disipolo an khun cha allon chi, “Inalin Hesus hinuy khapo ta ma-id hengngot ta-o hi tenapay.” ");
INSERT INTO ifu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aniꞌ-ilan Hesus chin khun cha hapiton ja inali na hi, “Anagkha ta unagkhu hini a-id chi tenapay chi ikhimoh ju an haphapiton? Un kaykhu it-ittang hini pammati ju! ");
INSERT INTO ifu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Akamoh ja achi ju ma-awatan. Nomnomon ju chin lema an tenapay an empa-an u hachi lemay lipfu an tatakhu, ja atanay pfahkit hi pinnu ju chin nahagwar? ");
INSERT INTO ifu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ja nomnomon ju khu chin peto an tenapay an empa-an u hachi apat hi lipfu an tatakhu, ja atana hachi otong an pfahkit hi pinnu ju chin nahagwar? ");
INSERT INTO ifu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na-awatan ju koma an pfu-un hay tenapay chi khun u hapiton. Hay alloꞌ ja achi ju apfuluton hini pfinoꞌpfoꞌ hachi Farisee ja hachi Saducee.” ");
INSERT INTO ifu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ja na-awatan mahpay chin disipolo an pfu-un hini pfinoꞌpfoꞌ an mangpaluꞌ-ukhu hi tenapay chi khuna hapiton, an hay penhod na an hapiton ja hini khun itudtuchun hachi Farisee ja Saducee. ");
INSERT INTO ifu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Immuy cha Hesus han lukhar an nehnot ad Cesarea Filipos. Ja inali na hachi disipolo hi, “Ngachah tugwali chi allon hana tatakhu hi omaꞌ-ataꞌ an Na-ilangitan an Takhu?” ");
INSERT INTO ifu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tempfar cha ja inali cha hi, “Gwacha hana mangali hi un he-a hi John Bautista. Ja gwacha khu hana mangali hi un he-a hi Elijah, ja allon khu hana uchumna hi un he-a hi Jeremiah wenno hay uchumna an profeta chin nahop.” ");
INSERT INTO ifu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ja inali na hi, “Chaꞌju mah? Ngay allon ju tugwali hi omaꞌ-ataꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tempfar Simon Peter ja inali na hi, “He-a hini Hennag Apo Jos an Mamahhod. He-a hini Empfalay ni mamattakhu an Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ja inalin Hesus hi, “Akhaꞌkhaja a, Simon an empfalay Jona, ti pfu-un takhu chi nangtuchu ay he-a ay tay an inalim, ti hi Ama an gwa ad langit chi nangtuchu. ");
INSERT INTO ifu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ja ha-in chi mangali ay he-a, an he-a hi Peter an hay podhona an hapiton ja pfato. Ja hitay an pfato chi pangpfangunaꞌ ay ni iglesiaꞌ, an hija hana tatakhu an mamati ay ha-in. Ja anong un hini apfalinan chi patoy ja achi na apfakon chicha. ");
INSERT INTO ifu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja ichat u ay he-a hini torpfoꞌ ni Pun-ap-apugwan Apo Jos. Hotti nu gwacha chi achim i-apfulut heto lota ja achi khu mi-apfulut ad langit. Ja hini i-apfulut mu heto lota ja mi-apfulut khu ad langit.” ");
INSERT INTO ifu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ja naꞌnaꞌ-allon Hesus hi, “Achi ju pay epfaꞌpfaag hachi tatakhu an ha-in hini Hennag Apo Jos an Mamahhod.” ");
INSERT INTO ifu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nete-a ay chuy ja khun ipaꞌpa-innilan Hesus hachi disipolo hana umali an punlikhatana. Khuna allon hi, “Mahapor an umujaꞌ ad Jerusalem, ti mahapor an hortapoꞌ hana cho-or an likhat an epahaꞌpfat hay hana a-ap-apon chi Hudju ja hana a-ap-apon chi papachi ja memehtolon chi urchin Moses. Patajonaꞌ muti ay ni me-atloh arkhaw hot mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chengngor Peter hitay an inalin Hesus ja enegnad Peter hija ja inali na hi, “Achi maphod an im hapiton chi amat hina, Apo, ti achi mapfalin an ma-at hay hato ay he-a!” ");
INSERT INTO ifu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Muti nunchu-ug hi Hesus ja inali na ay Peter hi, “Makak a, Satanas, ay ha-in! Achi mapfalin an halegwaonaꞌ ay he-a. Ti hini podhom ja pfu-un hini penhod Apo Jos, an un meꞌ-ampoy ay ni penhod chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inalin Hesus hachi disipolo na hi, “Hini mamhod an midchum ay ha-in ja mahapor an chuꞌkhona hini piꞌtakhuwana heto lota ja pi-ukhona hini kros na, ja inunuchaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ti hini takhu an mangpa-ennongan ay ni piꞌtakhuwana heto lota ja angkhay ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota khapo hi pangunuchana ay ha-in, ja miꞌtakhu ay Apo Jos hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Anong un alan ni takhu an amin chi enachangjan ay tay lota ja ma-id pfalor na hu-un ma-utaw chamchama hini piꞌtakhuwana ja nadusa hija hi ma-id chi pogpogna. Ma-id ichat na hi hugwar ni piꞌtakhuwana. ");
INSERT INTO ifu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mumpfangngachaꞌ an Na-ilangitan an Takhu an magwachaan ay ni apfalinan ja pfinang Apo Jos ja itnud u hana angher, hot oha-ohaoꞌ an amin chi tatakhu an ichatan hi lagpfu na an me-okor ay ni neꞌ-at na. ");
INSERT INTO ifu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Muti umannung hitay alloꞌ an gwacha hana uchumna ay chaꞌju an achi matoy hot ah-upan cha hini pangte-aaꞌ an Pun-ap-apugwan an Na-ilangitan an Takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nalahin chi unum hi arkhaw ja initnud Hesus hi Peter ja cha James ay John an hin-akhi, hotti un cha emma-angkhay an nunti-id han pfuludna. ");
INSERT INTO ifu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Unagkhu la-ahna ja tinnig cha hi Hesus an narman chin tikhaw na. Humili hichin angah na an amat ay chuy hukhit, ja pomooꞌ chin pinuchaw chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tinnig cha khu ja gawwacha cha Moses ay Elijah an khun cha miꞌhapit ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Himmapit hi Peter ja inali na ay Hesus hi, “Apo, maphod ta immali ta-o heto. Penhod mu ayya ja mun-ephochaꞌ hi tolo hi apfong ta henohha aju ay cha Moses ja hi Elijah.” ");
INSERT INTO ifu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Unagkhu khun munhapit hi Peter ja himpfumagkha ja gwa han munhenag an pfonot an nunliꞌnup ay chicha. Ja gwacha han hapit an narpu ay chuy pfonot an allona hi, “Hitay hini podpodhoꞌ an Empfalay u. Mun-an-anlaaꞌ khapo ay hija. Hotti egngor ju hija!” ");
INSERT INTO ifu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Unagkhu chengngor hachi tolo an adalan hichuy an hapit ja nunluꞌpfub cha ti nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nehnot hi Hesus ja hen-a na chicha, ja inali na hi, “Achi aju toma-ot. Tumaꞌchug aju.” ");
INSERT INTO ifu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Menohgwat cha hi Hesus ja nama-id chin numpun-ibpfa na an un angkhay hija. ");
INSERT INTO ifu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Amat hichi ja empacheh cha an nunchayyu ja khun allon Hesus ay chicha hi, “Achi ju epfaꞌpfaag hitay an tinnig ju ingkhana hi mummahuwaꞌ an Na-ilangitan an Takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ja inalin hachi adalan hi, “Anagkha mah, Apo, ta hachi memehtolon chi urchin Moses ja ituchu cha an mahapor an mahhun hi Elijah an umali ja un umali hini Mamahhod?” ");
INSERT INTO ifu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tempfar Hesus ja inali na hi, “Umannung an mahapor an mahhun hi Elijah an umali an manghakhana hana tatakhu ja un umali hini Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Muti alloꞌ ay chaꞌju hi immali mahpay hi Elijah muti agkhuy cha immatunan ja enat cha an amin hana napukhit an penhod cha an aton ay hija. Ja amat khu ay ha-in an Na-ilangitan an Takhu, an palikhatonaꞌ ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na-awatan hachi tolo an adalan hitay inali na, an hichuy Elijah an hinapit na ja hi John Bautista. ");
INSERT INTO ifu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Emmatam cha Hesus ay chuy agawwachaan hachi numpun-ibpfa cha ja cho-or chin tatakhu an na-amung. Ja gawwacha han lala-e an nidchum chin tatakhu an immuy ay Hesus. Nunheppe an numpakpaka-ahi ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, ka-ahiyam adniꞌ han empfalay u an lala-e. Ti un mun-orchah ja munnaud an malikhatan. Mahmahkhod an mepoloꞌ hi apoy ja makhah hi gwanggwang. ");
INSERT INTO ifu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ja un u agkhu in-ali ay cha tay disipolom ta epatenong cha ja ma-id olog cha.” ");
INSERT INTO ifu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ja inalin Hesus hi, “Munlinapoh aju kaykhu an tatakhu an napukhit chi ugali na. An akamoh an unaꞌ napfajag an gawwacha ay chaꞌju ja inanuhaꞌ chaꞌju, ja un kaykhu la-ahna ja ingkhana ad ugwani ja ma-id pammati ju. Ijali ju heto hini unga.” ");
INSERT INTO ifu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","In-uy cha ja inalin Hesus hi “Makak a, ton napukhit an ispiritu.” Ja nakak chin nehohoꞌlong an ispiritu, ja ma-id mahpay chin likhat chuy unga. ");
INSERT INTO ifu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ay chuy an arkhaw ja immi-igway cha Hesus ay cha chuy disipolo na ja inali cha ay hija hi, “Anagkha ta ma-id olog mi an mangpakak ay nuy napukhit an ispiritu?” ");
INSERT INTO ifu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tempfar Hesus ja inali na hi, “Ti aa, ti un it-ittang hini pammati ju. Umannung hitay alloꞌ ay chaꞌju, nu gwa koma hay pammati ju hi mipadchung ay ni it-ittang an pfugwan chi lakotta, ja mapfalin an allon ju ay tay pfuludna hi omoꞌ-ojay ta umuy hichi pangngerna, hot umuy. An amin ja mapfalin ju an ma-at nu nahamad hini pammati ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Muti hichuy an kalahen chi ispiritu ja achi makak nu achi ta mungkalalag ja mun-ayunar.” ");
INSERT INTO ifu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gwa han namenghan an na-amung cha Hesus ja hachi disipolo na ad Galilee ja inalin Hesus ay chicha hi, “Ha-in an Na-ilangitan an Takhu, ja achi mapfajag hot michataꞌ hana pfuhur u, ");
INSERT INTO ifu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hot patajonaꞌ. Muti ay ni me-atloh arkhaw hot mummahuwaꞌ.” Ja immayyong hachi disipolo hi nangngolan cha ay tay. ");
INSERT INTO ifu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Emmatam cha Hesus ja hachi disipolo na ad Kapernaum ja gwah chi hana khun munhenger hi pakha an michat hi Templo. Immuy cha ay Peter ja inali cha hi, “Hinuy mehtolo ju an hi Hesus, piꞌpfajad na chah hini pakha?” ");
INSERT INTO ifu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Atoꞌtogna ja inalin Peter hi, “Aa, pfajachana.” Unot numpfangngad hi Peter chin gwachaan cha Hesus ja nahhun hi Hesus an niꞌhapit ja inali na hi, “Ngay tugwali allom, Simon? Ngay anilam hi punhengelan hana ar-ari heto lota hi pakha? Un chah hana pamilya cha, wenno hana uchumna an tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tempfar Peter ja inali na hi, “Ti hana ma-id nikhamilana an tatakhu chi mahenger chi pakha cha.” Ja inalin khu Hesus hi, “Aa, hotti achi khahin un meꞌpfajad hana empfapfalay. ");
INSERT INTO ifu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Muti anong un amat heto, ja mumpfajad ta, ta ma-id apahigwan. Hotti umuy a ta i a mamunggwit, ta hini mahhun an meꞌna an khachiw ja ta-angom hini ta-o na hot gwacha han chakngam an pelaꞌ an omanay ay ni pakha ta an chugwa. Alaom ja in-uy mu hana munhenger.” ");
INSERT INTO ifu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hichin gawwachaan cha ad Capernaum ja immuy hachi disipolo ay Hesus ja inali cha hi, “Ngachah chi napfagpfagto ay chaꞌmi ay ni Pun-ap-apugwan Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Enajakhan Hesus han ung-ungnga ja impitaꞌchug na, ");
INSERT INTO ifu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ja inali na hi, “Umannung hitay alloꞌ, an mahapor an hukatan ju hini nomnom ju hi na-umlong an amat hi nomnom chi ung-ungnga. Ti achi ju ayya hot achi aju midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hini mangpakumbaba ay ni achor na, an amat ay tay unga, ja hija hini napfagpfagto ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hini mangakhamid hi takhu an nabnababba an amat ay tay unga khapo hi pammati na ay ha-in ja ma-id uchumna hi inakhamid na nu pfu-un ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Muti hini takhu an chimmalat hi pfimmahulan chi oha an nabnababba an namati ay ha-in, ja madusa. Toꞌ-onot un ekho-od hay machamot an pfato ay ni pfokhang na ja intuud hichi baybay ta marteng, mu hini un hijay chumalat hi pfumahulan. ");
INSERT INTO ifu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ahighikha hana tatakhu ay tay lota ti khun cha matoptopngan. Umannung an cho-or hana khun pfumahulan, ti khangayna. Muti munnaꞌnaud an ka-ahi hini takhu an chumalat hi pfumahulan. ");
INSERT INTO ifu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Hotti nu hini ngamoy wenno hu-i chi chumalat hi pfumahulam ja toꞌ-onot un mu potnan! Ti anong kay ja un oh-ohha hini ngamoy wenno hu-i ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong atag un chugway ngamoy ja hu-i ja mituud ta chamchama hichi impferno an gawwachaan chi apoy an achi madmachop. ");
INSERT INTO ifu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja nu hini matam chi chumalat hi pfumahulam ja toꞌ-onot un mu u-iton ja entapar mu! Ti anong kay ja un oh-ohha hini mata ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway mata ja mituud ta chamchama hichi impferno an gawwachaan chi apoy.” ");
INSERT INTO ifu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Entoloy Hesus an nangali hi, “Tikhan ju ta achi ju pahigwon hana amat ay tay an unga, ti alloꞌ ay chaꞌju hi halimunan hana angher cha an gawwacha ay Ama ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ja ha-in an Na-ilangitan an Takhu ja immaliyaꞌ an manakhu hana na-utaw an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nomnomon ju akay niꞌ hitay alloꞌ. Nu khulat ta gwa hay takhu an hingkhahot chi karnero na, ja na-utaw chi oha. Ngay tugwali atona? Taynana hini hijam chi polo ta han hijam an karnero hichi pahto ta i na hingiton hini oha an na-utaw. ");
INSERT INTO ifu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ja chinakngana ayya hot munnaꞌnaud pay chi pun-an-anlaana khapo ay nuy oha an nachakngan mu hachi hijam chi polo ta hijam an agkhuy na-utaw. ");
INSERT INTO ifu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Amat hina khu an achi podhon Ama ad langit an ma-utaw hana tatakhu na, anong un hay oha an nababa.” ");
INSERT INTO ifu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu khulat ta gway ibpfam an namati ja pfimmahor ay he-a, ja umuy a ay hija ta chumuchuwwa aju an munhapit ta allom hini pfahor na. Ja apfulutona ayya hini tukhun mu ta muntutuju hot maphod an mepfangngad hini i ju pun-oh-ohhaan. ");
INSERT INTO ifu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Muti achi na ayya apfuluton ja ajakham hay oha wenno chugwa hi pun-ibpfam ta muntutunud aju an i manukhun ay hija ta gway chugwa wenno tolo an mun-oh-ohha an muntihtikhu ay ni allon ju. ");
INSERT INTO ifu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu achi na khu egngor ja ipa-innilam ay ni iglesia. Ja nu achi na khu egngor hini tukhun chi iglesia, ja chuꞌkhon ju hija an amat ay ni achi ju khun pangidchuman hana Hentil ja hana uchumna an achi miꞌ-unud ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Umannung hitay alloꞌ ay chaꞌju an hini achi ju i-apfulut heto lota ja achi khu mi-apfulut ad langit. Ja hini i-apfulut ju heto lota ja mi-apfulut khu ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ja hay oha khu hi alloꞌ ay chaꞌju ja nu chugwa aju an mun-oh-ohha an mungkalalag hot aton Ama an gwa ad langit hini epfokha ju. ");
INSERT INTO ifu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ti anong un aju chugwa wenno tolo an na-amung khapo hi nidchuman ju ay ha-in, ja gawwachaaꞌ ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amat hichi ja immuy hi Peter ay Hesus ja inali na hi, “Apo, nu khulat ta gway oha hi ibpfa an takhu an khun pfumapfumahor ay ha-in hon numpakawan, ja apoꞌpongna mah hi pamakawanan? Ti ammuna nin hini mumpapeto an pamakawanan.” ");
INSERT INTO ifu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tempfar Hesus ja inali na hi, “Achi amat hina, an hay amatana ja numpapetoy polo ta han peto an pakawanom hini ibpfam an takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Amat hichi ja gwa han in-arig Hesus an omaꞌ-atan ni Pun-ap-apugwan Apo Jos an pun-achalan ay ni aton an mamakawan hi ibpfa. Inali na hi, “Gwa han ohan ari an podhona an hengelon chin inutang hachi takhala na. ");
INSERT INTO ifu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ente-a na an munhenger hotti empa-ajag na han ohan takhala an himpoloy milyon chin utang na. ");
INSERT INTO ifu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma-id omanay hi pumpfajad na ja inalin chuy ari hi ‘Ma-id ayya omanay hi pumpfajad mu ja eplaꞌ mu an amin hana khina-um ja mingina aju an pamilya ta gway pamajad mu ay tay utang mu.’ ");
INSERT INTO ifu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nunheppe hichuy takhala an numpakpaka-ahi ay chuy ari ja inali na hi, ‘Apo Ari, ka-ahiyanaꞌ adniꞌ! Ta hadhachom muti pfajachaꞌ an amin hato utang u.’ ");
INSERT INTO ifu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ninignikhan tay an ari ja inali na hi, ‘Aa, hotti umanamut a ja angkhaynana an achiꞌ epapfajad hitay otong an utang mu.’ ");
INSERT INTO ifu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Unagkhu nakak hichuy takhala ja chinittum na han padchung na an takhala an immutang ay hija hi lemay khahot. Empfogkhangana hitay oha an takhala ja khuna allon hi, ‘Hukatam gwot chin inutang mu ay ha-in!’ ");
INSERT INTO ifu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nunheppe hichuy gway utang na ja numpakpaka-ahi ja inali na hi, ‘Hadhachom adniꞌ muti hukataꞌ hitay utang u ay he-a.’ ");
INSERT INTO ifu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Muti ma-id nignikhan tay an takhu ja unaagkhu i impipfalud ingkhana an hukatana chin utang na. ");
INSERT INTO ifu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tinnig hachi numpun-ibpfa cha an takhala hitay enat na ja napukhit hi i cha punnomnoman. Hotti i cha empfaag ay chuy ari an apo cha. ");
INSERT INTO ifu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Empa-ajag chin ari hichuy takhala ja inali na hi, ‘Napukhit hitay an im enat! Un u agkhu penakawan chin otong an utang mu ja inaliꞌ hi achim pfajachan khapo ta numpakpaka-ahi a, ");
INSERT INTO ifu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ja anagkha ta achim nignikhaon hinuy padchung mu an takhala an gway utang na ay he-a? Kina-ahiyam koma khu an amat ay ni enat u ay he-a.’ ");
INSERT INTO ifu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nunlinapoh chin pfungot tay an ari ja impipfalud na hichuy takhala na ta maparpalikhat ingkhana hi hukatana an amin chin otong an utang na. ");
INSERT INTO ifu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Amat heto khu chi aton Ama an gwa ad langit ay chaꞌju nu achi napudnu hini pammakawanan ju hi papadchung ju an tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Napfalin an inalin Hesus hay hato ja nakak ad Galilee ja immuy ad Judea an chammang ni gwanggwang an Jordan. ");
INSERT INTO ifu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cho-or chin tatakhu an nangunud, ja empatenong na hachi gway chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ja gwacha hachi uchumna an Farisee an immuy ay hija ta toptopngan cha. Ja inali cha hi, “Ngay allom, mapfalin chah ay ni urchin ta-o an ihijan ni lala-e hini ahagwa na an pfupfai nu ngachah chuy an chumalat hi achi na pamhochan ay hija?” ");
INSERT INTO ifu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tempfar Hesus ja inali na hi, “Anilaꞌ an pfinaha ju hini Hapit Apo Jos hi nangarjana hi, chin hunhunana an narmugwan tay lota ja himpfun Apo Jos chi takhu an lala-e ja pfupfai. ");
INSERT INTO ifu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ja inalin Apo Jos hi ‘Hijaot un taynan ni lala-e hana a-ammod na ta i midchum ay ni ahagwa na an pfupfai, hot mumpfalin cha hi ohah achor.’ ");
INSERT INTO ifu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hotti achi cha chugwa an un cha oh-ohha. Hotti hini numpfalinon Apo Jos hi oh-ohha ja achi mapfalin an punhijanon chi takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ja inalin khu hachi Farisee hi, “Nu amat hina ayya, ja anagkha mah ta agkhuy empagwan Moses an ihijan ni lala-e hini ahagwa na an pfupfai? Ti in-urchina an ichatan ni lala-e hini pfupfai hi tulaꞌ an napermaan an nunhijan cha ja unaot pakakon.” ");
INSERT INTO ifu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tempfar Hesus ja inali na hi, “Chin hunhunana ja achi amat heto. Muti khapo ta munnaud aju an nalikhat hi matuchugwan, hijaot un himmikha hi Moses ja in-urchina hini aton ni lala-e nu ihijana hini ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hay alloꞌ ay chaꞌju ja, nu khulat ta hini pfupfai an achi na lugtapan hini ahagwana ja un tugwali luti-on ni lala-e an manghijan ta i pumiggwa, ja hihiya an immilugtap chamchama.” ");
INSERT INTO ifu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Himmapit hachi disipolon Hesus ja inali cha hi, “Nu amat hina ayya an mepagwa chi punhijanan, ja uchuꞌchuna agkhu niꞌ un ta achi marhin.” ");
INSERT INTO ifu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ja inalin Hesus hi, “Aa, gwacha hana uchumna an nichatan hi apfalinan ay Apo Jos ta achi cha marmarhin. Muti achi an amin chi tatakhu ja kaya cha an aton hitay. ");
INSERT INTO ifu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Numpfino-ob-on hini khumapo hi achi arhinan chi linala-e. Hana uchumna ja un nihikhud an un ma-id pamhod cha an marhin, ja hana uchumna ja achi cha marhin ti napnahan cha. Ja hana uchumna ja achi cha marhin khapo ta achi cha podhon an mahalegwa an munserbi ay Apo Jos. Hana mungkaya an mangat ay tay ja inunud cha koma.” ");
INSERT INTO ifu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gwa han namenghan an in-uy cha hachi ung-ungungnga ay Hesus, ti podhon cha an eh-a na hini ngamoy na ta ekalalakhana chicha, muti nun-ihingar hachi disipolo chicha. ");
INSERT INTO ifu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ja inalin Hesus hachi disipolo na hi, “Anong khu ja in-ali cha ay ha-in hato ung-ungungnga. Achi ju epagwa, ti hay hana tatakhu an miꞌpadchung hi ung-ungungnga ja chicha chi midchum ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Amat hichi ja enohha-ohha na an hen-a ta engkalalakhana chicha. Napfalin ja empacheh cha Hesus an umuy. ");
INSERT INTO ifu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Immuy han lala-e ay Hesus ja inali na hi, “Apo, ngay ngata maphod hi peꞌ-at u ta magwachaanaꞌ hi piꞌtakhuwan an ma-id chi pogpogna?” ");
INSERT INTO ifu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ja inalin Hesus ay hija hi, “Anagkha ta ha-in chi punhanhanam nu ngay maphod hi atom? Oh-ohha hi Apo Jos an maphod. Hotti nu penhod mu an miꞌtakhu hi ma-id chi pogpogna, ja unuchom hana urchina.” ");
INSERT INTO ifu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ja inalin khu chin lala-e hi, “Ngachan hay hana urchin an unuchoꞌ?” Tempfar Hesus ja inali na hi, “Achi aju pomatoy, ja achi aju umilugtap, ja achi aju omakaw, ja achi aju muntihtikhu hi achi umannung. ");
INSERT INTO ifu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Unuchon ju hana a-ammod ju, ja podhon ju hana papadchung ju an takhu an amat ay ni pamhod ju ay ni achor ju.” ");
INSERT INTO ifu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tempfar chin lala-e ja inali na hi, “Khun u unuchon hay hato an urchin. Hot ngay uchumna pay hi atoꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ja inalin Hesus ay hija hi, “Nu penhod mu an ma-id oh-ohha hi pungkulangam ja umuy a ta eplaꞌ mu an amin hana enachangjan mu, ja inchat mu hini polaꞌ na hana napubli, hot michatan a hi enachangjan ad langit. Enat mu ayya hitay ja immali a ta mitnud a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Unaagkhu chengngor hitay inalin Hesus ja immayyong an nangpacheh, ti munnaud chi enachangjana ja ay-ayyugwana. ");
INSERT INTO ifu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Niꞌhapit hi Hesus hachi disipolo na ja inali na hi, “Alloꞌ ay chaꞌju hi nalikhat hana achangjan an midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nalaklaka agkhu niꞌ hini kemer an lompfot ay ni opfot ni tanud mu hini achangjan an midchum ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nanor hachi disipolo hi nangngolan cha ay tay, ja inali cha hi, “Hotti nu achi miꞌtakhu hana achangjan, ja ngay ngachah mah chi hay miꞌtakhu ay Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Emmohchong Hesus chicha ja inali na hi, “Hana achi mapfalin chi takhu ja mapfalin an amin ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Himmapit hi Peter ja inali na ay Hesus hi, “Hot chaꞌmi mah an nanaynan an amin ta nitnud ami ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ja inalin Hesus ay chichan amin hi, “Umannung hitay alloꞌ ay chaꞌju, an machakngan ayya hini ahukatan tay lota ja ma-innila hini apfalinaꞌ an Na-ilangitan an Takhu, ti umpfunaꞌ ay ni tronon chi mumpaptoꞌ ta mun-ap-apowaꞌ. Ja mi-ipfun aju han himpolo ta chugwa an trono ta midchum aju ay ha-in an mun-ap-apo hana tatakhu an narpu ay ni himpolo ta chugwa an holag Israel. ");
INSERT INTO ifu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ja hana nanaynan hi pfalay cha, a-akhi cha, a-ammod cha, empfapfalay cha, ja lota cha khapo hi pamhod cha an munserbi ay ha-in, ja choꞌchoꞌ-olan chi michat ay chicha ay tay piꞌtakhuwan cha heto lota, ja omaꞌ-angonoh ja michatan cha khu hi piꞌtakhuwan hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cho-or cha hana nun-apfagto heto lota an chicha chi mi-ud-uchichi hichi ad langit. Ja gwacha hana tatakhu an ma-id nitagtakhuwana heto lota muti chicha agkhu chi mipapfagpfagto ad langit.” ");
INSERT INTO ifu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Inalin Hesus hi, “Hitay chi pipadchungan ni Pun-ap-apugwan Apo Jos, an amat ay ni takhu an gway kharchina an natamman hi ubas. Nalum chin ubas ja henerhelong na an umuy mun-ajag hana mumpokhah. ");
INSERT INTO ifu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gwacha hachi chinakngana hotti nunhahappitanan cha an malagpfuwan cha hi henohha hi denarius hi ohay arkhaw, ja unaot honakhon chicha an i mumpokhah ay ni ubas. ");
INSERT INTO ifu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Unot nungkhagwa ja immuy khu hichi palaha an i maningit hi uchumna an i meꞌpokhah. Chinakngana han linala-e an numpangataꞌchug ti ma-id i cha peꞌpfoꞌlaan. ");
INSERT INTO ifu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ja inali na ay chicha hi, ‘Mangunud aju hay hana immuy hichi kharchin u ta i aju meꞌpokhah ay ni ubas, muti lagpfuwoꞌ chaꞌju ay ni ohto an lagpfu ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ja immuy hato an linala-e. Unot gwa an nahaꞌ-ad ja gwacha khu hachi hennag na an i meꞌpokhah. Unagkhu gwa khu an napujaw ja gwacha khu hachi uchumna an hennag na an midchum an i meꞌpokhah. ");
INSERT INTO ifu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Unot gwa an mahilip ja immuy pay an i maningit khu hay uchumna an i meꞌpokhah, ja gwacha pay hachi chinakngana an ma-id at-aton cha. Ja inali na ay chicha hi, ‘Anagkha ta linahin ju hitay ohay arkhaw an ma-id tinamtamuwan ju?’ ");
INSERT INTO ifu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tempfar cha ja inali cha hi, ‘Ti ma-id immali an nangajakhan ay chaꞌmi ta i ami meꞌpfoꞌla.’ Ja inali na khu hi, ‘Hot mangunud aju hichi kharchin u ta i aju meꞌpokhah ay ni ubas.’ Ja immuy cha. ");
INSERT INTO ifu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Unot gwa an madhom ja inalin chuy takhu ay ni khuna pumpfantajon ay chuy kharchina hi, ‘Ajakham hana nuntamu ta ichat mu hini pfinoꞌla cha. Pahhunom hana ne-ang-angonoh an immali ja en-ang-angonoh mu hay hana nahnahhun.’ ");
INSERT INTO ifu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Amat hichi ja immuy hachi nangte-a hi nahilip ja enala cha chin linagpfu cha an henohha hi denarius. ");
INSERT INTO ifu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Inannilan hachi nahnahhun an nangte-a an nuntamu chin herhelong hini pfinoꞌlan hana nangte-a hi nahilip, ja khemhon cha gwot hi choꞌchoꞌ-or chi michat ay chicha. Na-ajakhan cha ta peꞌ-ala cha hichin pfinoꞌla cha, muti un chaagkhu neꞌ-ala ja un miꞌpadchung ay ni nichat hana uchumna. ");
INSERT INTO ifu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hotti ngimmulungur cha an inali cha ay chuy numpapfoꞌla hi, ");
INSERT INTO ifu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Anagkha mah ta un na-omtang hi nuntamuwan hato uchumna ja ay chaꞌmi an henen-arkhaw mi an naghitan an nuntamu, ja un la-ahna ja un mumpapadchung hitay panerchum ay chaꞌmi.’ ");
INSERT INTO ifu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ja chin nangpapfoꞌla ja inali na ay chuy oha ay chicha hi, ‘Agkhuy u lenahlahan chaꞌju. Ti nunhahappitanan ta-o mit hini pfoꞌlaon ju hi ohay arkhaw. ");
INSERT INTO ifu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hotti tayya, alaom hitay pfinoꞌlam ta umanamut a. Hay podhoꞌ ja pumpapadchungoꞌ hini ichat u ay chaꞌju, anong un hay hana ne-ang-angonoh an nuntamu. ");
INSERT INTO ifu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Un ju chah agkhuy anila an ikhachaꞌ an mangpadchong hi pihuꞌ? Hotti anagkha ta pukhitonaꞌ hi unaꞌ maꞌma-idchat?’ ” ");
INSERT INTO ifu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ja en-ang-angonoh Hesus an nangali hi, “Amat hina tugwali ay ni Pun-ap-apugwan Apo Jos, an mipapfagpfagto hana uchumna an ma-id pfirpfilang na heto lota, ja mi-ud-uchichi hana uchumna an napfagpfagto ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Khun munti-id cha Hesus an umuy ad Jerusalem ja en-ohha na hachi himpolo ta chugwa an adalana, ja inali na ay chicha hi, ");
INSERT INTO ifu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Chonglon ju! Tayya an umuy ta-o ad Jerusalem ja ha-in an Na-ilangitan an Takhu ja michataꞌ hay hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses. Hugijonaꞌ ay chicha ja epapatojaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ja mipulangaꞌ hay hana Hentil an mangekejan ja manuplit ay ha-in. Epfakhataꞌ han kros ta matojaꞌ, muti ay ni me-atlon arkhaw ja mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Immuy ay Hesus chin ahagwan Zebedee ja initnud na hachi chugwa an empfalay na an linala-e an adalan. Nunheppe ay Hesus ja inali na hi, “Apo, gwa akkay han epfokhaꞌ ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ja inalin Hesus hi, “Ngachah nuy epfokham?” Tempfar na ja inali na hi, “Machakngan ayya chin pipapfagpfagtuwam ta umpfun a an mun-ap-apo, ja allom mah ta mi-ipfun hay hato chugwa an empfalay u an miꞌ-ap-apo, oha ay ni nun-appit hi agwan mu ja oha ay ni nun-appit hi ikhid mu.” ");
INSERT INTO ifu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ja inalin Hesus ay cha chuy chugwa an adalana hi, “Ma-id anila ju ay ni epfokha ju. Agkhuy ju atag anila chi hay omaꞌ-atana. Un chah angkhiloh un aju paꞌ-ahchor ay ni likhat an haꞌpfatoꞌ?” Ja inali cha hi, “Olog mi.” ");
INSERT INTO ifu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ja inalin khu Hesus hi, “Umannung an haꞌpfaton ju hana likhat an amat ay ni likhat u. Muti tan pfu-un ha-in chi mangpadchong ay ni mi-ipfun ay tay nun-appit hi agwan u ja ay tay nun-appit hi ikhid u, ti hi Ama chi mangpadchong ay ni enchachaag na.” ");
INSERT INTO ifu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Unagkhu inannilan hachi himpolo an papadchung cha an adalan hichuy an empfokhan cha James ay John ja mapfungot cha. ");
INSERT INTO ifu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hotti inam-amamung Hesus chicha an amin, ja una allon hi, “Nomnomon ju akay niꞌ hana khun mun-ap-apo hi tatakhu heto lota an khun cha ipapilit hini podhon cha. Ja hana mun-ap-apo an gway apfalinana, ja khun cha palikhaton hana tatakhu an khun cha pfaapfaalon. ");
INSERT INTO ifu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Achi koma amat hetoy aton ju. Ti hini mamhod an ma-ar-ali ja mahapor an tulunganay padchung na an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ja hini mamhod an mumpfalin hi pangulu ja mahapor an munhimpfut hana padchung na an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amat ay ha-in an Na-ilangitan an Takhu, an agkhujaꞌ immali ta chaꞌju an tatakhu chi munserbi ay ha-in. Muti immaliyaꞌ an munserbi hana cho-or an tatakhu, ja ta matojaꞌ an pfajad chi pfahor cha.” ");
INSERT INTO ifu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tenaynan cha Hesus ad Jeriko ja cho-or chin tatakhu an ninitnud. ");
INSERT INTO ifu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ja gwa han chugwa an napfulaw an inu-umpfun ay chuy pingngit chi kurha an khun mun-ad-adchaw. Un chaot chengngor an maloh hi Hesus ja ente-a cha an mun-ugwap an mangali hi, “Hesus an holag Ari David, ka-ahiyan chaꞌmi adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hachi tatakhu ja inhingar cha chicha ta khomenong cha muti en-om-omod hachi napfulaw an nangiꞌgwap hi, “Apo Hesus an holag Ari David, ka-ahiyan chaꞌmi adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Intaꞌchug Hesus ja empa-ajag na chicha. Ja empfokha na hi, “Ngay podhon ju hi atoꞌ ay chaꞌju?” ");
INSERT INTO ifu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ja inali cha hi, “Apo, penhod mi an mitikhaw hato mata mi!” ");
INSERT INTO ifu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ja ninignikhan Hesus chicha, ja hen-a na chin mata cha. Ja mitikhaw gwot chin matan hachi napfulaw ja nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Empacheh cha Hesus an khun cha homnot ad Jerusalem. Emmatam cha ad Betfage an achaan chuy pfulludna an nangadnan hi Olibo ja hennag Hesus han chugwa an disipolo na ");
INSERT INTO ifu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","an inali na hi, “Ipangulu ju ay chuy pfarju hichi chammangna. Nu omatam aju hot chakngan ju han nekhokhoꞌ-od an donkey ja han pfoꞌtot an empfalay na. Upfachon ju ja in-ali ju heto. ");
INSERT INTO ifu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja nu gway mangpfokha hi, ‘Anagkha ta alaon ju hato donkey?’ ja allon ju hi, ‘Alaon mi, ti nan mahapor Apo ta-o,’ hot i-apfulut cha.” ");
INSERT INTO ifu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na-at hitay ta mipa-annung chin inalin chin profetan Apo Jos chin hophopapna hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Allon ju hana tatakhu an eSion hi, ‘Chiya an umali hichuy Ari ju, An napakumbaba ja nunhahakkay han pfoꞌtot an donkey.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Immuy hachi chugwa an disipolo ja inunud cha chin inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Enala cha chin donkey ja chin empfalay na ja in-uy cha ay Hesus. Enopnan cha chin khatud cha hi lopfong ja nunhakay hi Hesus ay ni oha. ");
INSERT INTO ifu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hi khun cha omajan ja chenom-or chin tatakhu, ja nunloh-op cha chin uchumna an lopfong cha hon en-ap-ap cha chin chalan. Hachi uchumna ja numpateng cha chin tupfun chi ajiw ja nun-e-ap-ap cha khu ay chuy chalan. ");
INSERT INTO ifu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hachi ayya nangpangpangullu ja hachi khun mangun-unud an atakhutakhu ja khun cha iꞌgwap hi, “Madaydayaw a an holag Ari David. Mabindisyonan a an hennag Apo Jos. Madaydayaw hi Apo Jos ad langit!” ");
INSERT INTO ifu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Unagkhu emmatam cha Hesus ad Jerusalem ja napfu-ar hachi atakhutakhu ja khun cha allon hi, “Ngay ngachan tay an takhu?” ");
INSERT INTO ifu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ja hachi nitnud ja hi-a-ali cha hi, “Hitay hinuy profetan Apo Jos an hi Hesus an eNazaret hichi provincian chi Galilee.” ");
INSERT INTO ifu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Immuy hi Hesus ay chuy partug chi Templo ja chinakngana hachi khun mungkumerchu hi animar an hijay khun nguminaan hana takhu hi ipidaton cha ay Apo Jos. Ja nun-epakak na hay hachi khun ngumina ja mungngina. Nun-ipfu-allo na hachi lamehaan hachi khun munhukat hi pihu, ja chin umpfunan hachi khun mungngina hi hagwiti an pfalug. ");
INSERT INTO ifu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ja inali na ay chicha hi, “Allona ay ni hapit Apo Jos hi, ‘Hitay pfalay u ja pfalay an pungkalalakhan.’ ” Muti tayya an numpfalinon ju hi a-amungan chi mangakaw. ");
INSERT INTO ifu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chin agwachaan Hesus hichi Templo ja immuy ay hija hachi nun-apfulaw ja hachi nun-apilay ja nun-epatenong na. ");
INSERT INTO ifu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Muti hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses ja emmomohchong cha hay hato milagro an enat na, ja chedchengngor cha hachi ung-ungungnga an gwah chi partug chi Templo an khun cha iꞌgwap hi, “Madaydayaw hitay holag Ari David!” Ja pfimmungot hato a-ap-apo ");
INSERT INTO ifu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ja inali cha ay Hesus hi, “Chonglom akay niꞌ hay hato khun cha iꞌgwap.” Ja inalin Hesus hi, “Aa, chengngor u. Un ju chah agkhuy pfinaha hitay Hapit Apo Jos hi nangarjana hi, ‘Tinuchugwam hana ung-ungungnga ja hana paꞌ-ipfutay an khun mun-inum Ta mapmaphod hini aton cha an mundayaw ay he-a.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amat hichi ja tenaynan Hesus chicha ad Jerusalem ja immuy nunnanong ad Betani. ");
INSERT INTO ifu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chin nun-inggwiꞌgwiit ja pfimmugwah cha Hesus an mumpfangngad ad Jerusalem ja hemmenaang hija. ");
INSERT INTO ifu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Enamang na han ajiw an higos ay chuy pingngit chuy chalan ja immuy ta i omala hay pfunga na. Unagkhu emmatam chin achaan chuy ajiw ja ma-id oh-ohhah pfunga na, an un angkhay chin malupfong an tupfu na. Ja inalin Hesus ay chuy an ajiw hi, “He-a ton ajiw, achi a mahpay pfumungpfunga ja ingkhana!” Unot empa-opoh Hesus hitay an inali na ja naꞌleng chin higos. ");
INSERT INTO ifu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nanor hachi disipolo ja khun cha allon hi, “Anagkha ta ngay na-at ta hin-alina ja i naꞌleng hitay higos?” ");
INSERT INTO ifu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ja inalin Hesus hi, “Umannung hitay alloꞌ ay chaꞌju, nu munchomoꞌ aju ay Apo Jos an atona hini epfokha ju, an achi munharhalinchugway nomnom ju, hot mapfalin an aton ju khu chi amat ay tay enat u ay tay higos. Ja pfu-un hitay ja angkhay, an mapfalin an allon ju ay tay an pfulludna hi, ‘Makak a heto ta i a mituud hichi baybay’ hot ma-at. ");
INSERT INTO ifu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hotti nu ngachah chi ekalalag ju ay Apo Jos, ja ma-at an ma-at nu gway pammati ju.” ");
INSERT INTO ifu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Emmatam cha ad Jerusalem ja immuy cha ay chuy partug chuy Templo. Khun muntudtuchu hi Hesus ja immuy hachi a-ap-apon chi papachi ja hachi uchumna an a-ap-apon chi Hudju ja empfokha cha ay hija hi, “Ngachah chi narpugwan ni apfalinam an mangat hay hato khun mu aton? Ja ngay nangchat ay nuy apfalinam?” ");
INSERT INTO ifu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tempfar Hesus ja inali na hi, “Unchani adchiya ta topfalon ju pay hitay peꞌpfokhaꞌ. Nu topfalon ju hot alloꞌ ay chaꞌju hini narpugwan tay apfalinaꞌ an mangat hato. ");
INSERT INTO ifu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hotti allon ju adchiya tugwali, ngay nannag ay John Bautista an immali an khun mumbautisar? Hi Apo Jos wenno hay takhu?” Ja khun cha manghempfopfogkha an khun cha allon hi, “Hot ngachah chi allon ta-o mah? Nu allon ta-o hi un hennag Apo Jos hot allona hi ‘Nu hi Apo Jos chi nannag ay John ja anagkha mah ta agkhuy ju pinati hija?’ ");
INSERT INTO ifu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ja nu allon ta-o khu hi hennag chi hay takhu hot pfumungot hay hato tatakhu, ja unakkay gway aton cha ay chita-o, ti namati cha an amin an profetan Apo Jos hi John.” ");
INSERT INTO ifu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hotti hay nampfar cha ay Hesus ja inali cha hi, “Ma-id anila mi nu ngachah chi nannag ay hija.” Tempfar khu Hesus ja inali na hi, “Nu amat hina hot achiꞌ khu epfaag nu ngay nangchat ay ha-in hi apfalinaꞌ an mangat hay hato.” ");
INSERT INTO ifu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Inalin khu Hesus hachi a-ap-apo hi, “Ut-utnuwon ju akay niꞌ nu ngay penhod tay pangngarig an hapiton. Gwa han lala-e an chugwa han empfalay na an linala-e. Immuy niꞌhapit ay chuy panguluwan ja inali na hi, ‘Umuy a akay ta i a muntamu hichi kharchin ta-o.’ ");
INSERT INTO ifu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ja inalin chin panguluwan hi, ‘Ti tan mahulit hotti achiyaꞌ umuy.’ Muti unagkhu nahnahop ja nunnomnom ja immuy chamchama. ");
INSERT INTO ifu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Immuy khu hi ama cha ay chuy netob ja inali na khu hi, ‘Umuy a akay ta i a muntamu hichi kharchin ta-o.’ Ja inalin chin netob hi, ‘Aa, umujaꞌ,’ muti agkhuy chamchama immuy. ");
INSERT INTO ifu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hot ngay allon ju ay cha tay an chugwa hi nangat ay ni penhod ama na?” Tempfar cha ja inali cha hi, “Hinuy panguluwan.” Ja inalin Hesus hi, “Aa, ja umannung hitay alloꞌ ay chaꞌju, an khun mahhun hana nun-apfahulan an tatakhu an midchum ay ni Pun-ap-apugwan Apo Jos, an amat hana khun munhenger hi pakha ja hana putah. ");
INSERT INTO ifu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti immali hi John an nangtuchu hana magpong an peꞌ-at cha ja inunud cha. Muti chaꞌju ayya ja agkhuy ju inunud. Tinnig ju mit hitay enat cha an namati ja agkhuy ju tugwali chin-ug hana pfahor ju ta niꞌpati aju koma.” ");
INSERT INTO ifu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Inalin khu Hesus hi, “Chonglon ju pay hitay oha khu an pangngarig. Gwa han ohan lala-e an nuntanum hi cho-or hi ubas ay ni kharchina. Enalad na chin kharchin ja tinau-ana han pfato an khun cha pang-amungan hi chanum chi ubas hi un cha lochehon. Empahaꞌ-ad na khu han nataꞌnang an ab-abpfong an oma-ayyan chi mumpfantay. Napfalin hay hato ja empapfengpfeng na hichuy kharchina ja unot makak an umuy hichi achawwi. ");
INSERT INTO ifu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Unot nachakngan chin ahipokhah ja hennag na hachi takhala na an i meꞌ-aggwa ay chuy penokhah cha an ubas. ");
INSERT INTO ifu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Muti hay hato an neꞌpfengpfeng ja enala cha hachi takhala ja numpakhuh cha hichuy oha, penatoy cha khu hichuy oha, ja nungkhajang cha hichuy oha. ");
INSERT INTO ifu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ja hennag na khu hana choꞌchoꞌ-or pay an takhala na, ja hihiya, an pinalikhat hachi neꞌpfengpfeng. ");
INSERT INTO ifu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Unot omaꞌ-angonoh ja hennag na chin empfalay na an lala-e an umuy meꞌ-aggwa ta alom ja egngor hachi neꞌpfengpfeng hija. ");
INSERT INTO ifu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Muti unot nangalimutugwan hachi neꞌpfengpfeng hichuy empfalay na ja nunhahapit cha ja inali cha hi, ‘Hijah tay hini empfalay ni khun ta-o peꞌpfengpfengan an hijay mamanoh ay tay lotan ama na. Unot la-ahna ja penatoy ta-o ta chita-oy mangheꞌ-a ay tay lota.’ ");
INSERT INTO ifu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Amat hichi ja enekak cha ja penatoy cha.” ");
INSERT INTO ifu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ja inalin Hesus hachi a-ap-apon chi papachi ja hachi Farisee hi, “Ngachah tugwali chi aton tay an takhu hay hachi neꞌpfengpfeng ay hija?” ");
INSERT INTO ifu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tempfar cha ja inali cha hi, “Epapatoy na kaykhu hay hato an napupukhit an tatakhu ja empapfengpfeng na hinuy kharchin hi uchumna an achi ngumangannu an mangchat ay ni khaggwa na.” ");
INSERT INTO ifu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ja entoloy Hesus an nangali hi, “Anilaꞌ an pfinaha ju hitay nitulaꞌ an Hapit Apo Jos hi nangarjana hi, ‘Hinuy pfato an namlenan hay hana mumpakhad hi pfalay Ja hijay numpfalin hi na-ahammad an pognad tay an pfalay. Hi Apo Jos chi nangat ay tay, Ja nakaskasda-aw hi pannikhan ta-o!’ ");
INSERT INTO ifu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hijaot un u khun allon ay chaꞌju an pfu-un mahpay chaꞌju an Hudju chi tatakhun Apo Jos an midchum ay ni Pun-ap-apugwana, ti enaan chaꞌju ja empallog na hana khun mangat ay ni penhod na. ");
INSERT INTO ifu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hinuy pfato an namlenan cha ja nu gway makhah ta meꞌna ay tay an pfato ja mun-igwa-itay. Ja nu meꞌna hitay an pfato ay ni takhu hot mun-akhupung.” ");
INSERT INTO ifu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Unagkhu chengngor hachi a-ap-apon chi papachi ja hachi Farisee hay hato in-arig Hesus ja anila cha an chicha hana khuna hapiton an nan-ug ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Penhod cha an tiligwon hi Hesus muti agkhuy cha entoloy ti toma-ot cha hachi cho-or an tatakhu an nangapfulut an profetan Apo Jos hija. ");
INSERT INTO ifu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Inalin khu Hesus han ohan pangngarig an amat heto. ");
INSERT INTO ifu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hini pipadchungan tay Pun-ap-apugwan Apo Jos ja ipadchung u han ari an nunhakhana ta mungkasar hini empfalay na an lala-e. ");
INSERT INTO ifu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nachakngan chin arkhaw an pungkasalan cha ja hennag chuy ari hachi takhala na ta i cha allon ta umali hachi na-ila. Muti achi cha penhod an i meꞌkasar. ");
INSERT INTO ifu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hennag na khu hachi uchumna an takhala ta i cha khu allon ay cha chuy na-ila hi, ‘Umali aju ti tan nehakhana hitay kasar, ja naparti hato nepatapfa an pfakah hi ihcha ta-o, ti nan marhin hinuy empfalay na.’ ");
INSERT INTO ifu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Muti agkhuy cha enegngor chin i nun-ila ja unagkhu immuy hichuy oha an i muntamuh pajaw, ja immuy khu hichuy oha an i mungkumerchu. ");
INSERT INTO ifu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ja na-ala agkhu hato uchumna an na-ila ja chimpap cha hay hachi takhala an khun mun-ajag, ja pinalikhat cha ja penatoy cha chicha. ");
INSERT INTO ifu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pfimmungot chin ari ja hennag na hachi hinchalo na ta i cha penatoy hay hachi namatoy chin takhala na ja khenhob cha chin pfuglay cha. ");
INSERT INTO ifu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ja enajakhana hachi uchumna an takhala na ja inali na hi, ‘Tayya an enep-ephod u an enhakhana hitay kasar muti hachi na-ila ja achi cha ma-ikari. ");
INSERT INTO ifu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hotti umuy aju hana kurha ay tay an pfuglay ta-o ta ajakhan ju an amin hana tatakhu an ah-upan ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Amat hichi ja immuy chin takhala na hachi kurha ja initnud cha an amin hana inah-upan cha an tatakhu, napukhit man wenno mapmaphod chi ugali cha. Na-amung cha hichi pungkasalan hotti napnu hichuy pfalay. ");
INSERT INTO ifu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amat hichi ja immuy chin ari ta i miꞌ-an-annila hay hachi immuy neꞌkasar, ja gwa han tinnig na an takhu an agkhuy neꞌlopfong ay ni empegwanah nuy ari an elopfong hachi ay neꞌkasar. ");
INSERT INTO ifu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ja inalin chin ari ay hija hi, ‘Anagkha ta niꞌhikhup a an agkhuy mu neꞌlopfong hinuy lopfong chi meꞌkasar?’ Muti khemmegkhenong hichuy takhu. ");
INSERT INTO ifu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ja inalinot chin ari hachi takhala na hi, ‘Kha-utan ju hini ngamoy na ja hu-i na ja entapar ju hichi munhehellong, hot midchum hana khun mun-okhab ja mungngelot hana pfapfa na hichi.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ja en-ang-angonoh Hesus an nangali hi, “Cho-or hana ajakhan Apo Jos muti un tortollo hana piliyona an midchum ay nuy Pun-ap-apugwana.” ");
INSERT INTO ifu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hachi Farisee an ne-egngor hay hato inalin Hesus ja nakak cha ta i cha hahapiton hay aton cha an manoptopngan ay hija ta alom ja gway ehallaana ay ni atona an munhapit. ");
INSERT INTO ifu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hotti hennag cha hachi uchumna an disipolo cha an Farisee ja nitnud khu hachi uchumna an Herodianes. Immuy cha ja inali cha ay Hesus hi, “Apo, anila mi an umannung hana khun mu allon anong un pahigwon chi tatakhu. Ti anong un nun-atakhay hana tatakhu an munchongor wenno nababa ja khun mu gwot itudtuchu hini umannung an podhon Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ja khun cha hempfogpfogkhon an allon cha hi, “Hotti hay podhon mi adchiya an annilaon ja ngay punnomnomam? Mapfalin chah ay ni urchin ta-o an Hudju nu mumpfajad ta-o hi pakha ay ni Emperador ad Rome? Pfajachan mi chah wenno achi mi?” ");
INSERT INTO ifu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na-orman Hesus an un cha toptopngan hija ja inali na hi, “Anagkha ta toptopnganaꞌ ay chaꞌju an khun pfumuhupfuhuur? ");
INSERT INTO ifu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","I-ali ju hay pihu an michat hi pakha ta tikhaꞌ.” Inchugwagwa cha han denarius an pihu ");
INSERT INTO ifu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ja inali na hi, “Ngay nang-angah ay tay gwa ay tay pihu? Ja ngay nang-enngachan ay tay an nitulaꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tempfar cha ja inali cha hi, “Hini Emperador.” Ja inalin khu Hesus hi, “Hotti ichat ju ay ni Emperador hini michat ay ni Emperador, ja inchat ju ay Apo Jos hini michat ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Un chaagkhu chengngor hichuy nampfar na ja nanor cha, ti agkhuy nehalla an nungkhokhodchong. Hotti tenaynan cha hi Hesus ja nakak cha. ");
INSERT INTO ifu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ay chuy khu an arkhaw ja gwacha hay hana uchumna an Saducee an immuy ay Hesus. Saducee ayya ja achi cha mamati an gway amahuwan. ");
INSERT INTO ifu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ja inali cha ay hija hi, “Apo, intulaꞌ Moses chi urchin ay chita-o an, matoy ayya hini oha an lala-e an narhin ja ma-id empfalay na, ja mahapor an ahagwaon ni akhi na an lala-e hitay an pfupfai an napfalo, ta hana empfapfalay cha ja mipfilang an empfalay nuy natoy an ibpfa na. ");
INSERT INTO ifu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hotti gwacha han peto an hin-a-agkhi an linala-e ay tay an pfuglay mi. Narhin hitay panguluwan ja natoy an ma-id empfalay cha. Hijaot un nepallog chin netob ta enahagwa na khu hitay an pfalo ");
INSERT INTO ifu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ja natoy khu an ma-id empfalay cha. Hotti nepallog khu chin me-atlo ja ingkhana chin me-apeto ja nun-a-atoy cha an amin an ma-id empfalay cha. ");
INSERT INTO ifu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Omaꞌ-angonoh ja ne-etoy hitay an pfupfai an napfalo. ");
INSERT INTO ifu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hotti nu allom chi gway amahuwan chi natoy ja ngacha mah ay cha tay peto an linala-e chi nang-en-ahagwa ay tay pfupfai nu umali hini amahuwan chi tatakhu? Ti enahagwa cha mit an amin hitay an pfupfai.” ");
INSERT INTO ifu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tempfar Hesus ja inali na hi, “Nehalla aju ti ma-id anila ju ay ni Hapit Apo Jos ja hini apfalinana. ");
INSERT INTO ifu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mummahu ayya hana tatakhu ja achi cha mangah-ahagwa, an amat cha hay hana angher ad langit an achi mangahagwa. ");
INSERT INTO ifu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ja hini ayya amahuwan chi nun-a-atoy, un ju chah agkhuy pfinaha chin nitulaꞌ an Hapit Apo Jos hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ha-in chi Jos an khun dayawon Abraham, ja hi Isaak, ja hi Jakob.’ Inali na hitay anong un napfajag an nanattoy cha Abraham. An hay podhona an hapiton ja hijay Jos hana mamattakhu an pfu-un Jos chi natoy. Hotti niya an khun aju mehalla nu ehaot ju hini amahuwan chi natoy.” ");
INSERT INTO ifu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja nanor hachi atakhutakhu hi nangngolan cha hay hato intuchu na. ");
INSERT INTO ifu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Unagkhu chengngor hachi Farisee an ma-id olog hachi Saducee an manoptopngan ay Hesus ja nuntutunud cha an immuy ta i cha khu toptopngan hija. ");
INSERT INTO ifu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ja himmapit chin oha ay chicha an mehtolon chi urchin Moses ta toptopngana hi Hesus, ja empfokha na hi, ");
INSERT INTO ifu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Rabbi, ngay ngachah nuy urchin Apo Jos an napfarpfalor hi unuchon?” ");
INSERT INTO ifu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tempfar Hesus ja inali na hi, “Hini urchin an allona hi, ‘Mahapor an podhon ju hi Apo Jos an amin hi puhu ja nomnom ja pfi-ah ju ja an amin hi piꞌtakhuwan ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hitay hini napfarpfalor an urchin hi unuchon. ");
INSERT INTO ifu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ja omaꞌ-at hina khu hitay me-aggwa an urchin an allona hi, ‘Podhon ju hini padchung ju an takhu an amat ay ni pamhod ju ay ni achor ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hay hato chugwa an urchin chi nepognachan an amin hana urchin ja chin intulaꞌ hachi profeta.” ");
INSERT INTO ifu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ay chuy an na-amungan hachi Farisee ja gwa han empfokhan Hesus ay chicha ");
INSERT INTO ifu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","an inali na hi, “Ngay anila ju hi omaꞌ-atan nuy Hennag Apo Jos an Mamahhod? Ngay nangholag ay hija?” Tempfar cha ja inali cha hi, “Hijay holag Ari David.” ");
INSERT INTO ifu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ja inalin khu Hesus hi, “Nu holag na ayya hini Mamahhod ja anagkha tugwali ta allon khu David hi ‘Apo’ ay hija? Umannung an hijay Apon David, ti enchalan ni Espiritu Santo hi David ta inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Inalin Apo Jos ay nuy tenangad u an Apoꞌ hi, “Umpfun a ay tay nun-appit hi agwan u, Ingkhana hi pangapfakaꞌ an amin hana pfuhur mu ta he-ay tangachon cha.” ’ ");
INSERT INTO ifu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Inalin Ari David ay tay Hennag Apo Jos an Mamahhod hi, ‘Apo’ ti napfagpfagto mu hija. Nu amat heto chi allon Ari David hotti hini hahadchon ju ja pfu-un la-eng holag David ja angkhay.” ");
INSERT INTO ifu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma-id oh-ohhah pampfar cha ja tabpfi na ay chuy ja mun-okhon cha an i mangpfokha hi uchumna. ");
INSERT INTO ifu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Inalin khu Hesus hachi nakhagong an tatakhu ja hachi disipolo na hi, ");
INSERT INTO ifu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hay hachi memehtolon chi urchin Moses ja hachi Farisee, ja nehaad cha an muntudtuchu ay nuy urchin Moses, ");
INSERT INTO ifu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","hotti mahapor an unuchon ju an amin hana ituchu cha. Muti achi ju peꞌ-at hana khun cha aton. Ti achi cha khun unuchon hana khun cha itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Cho-or hana nalikhat an allon hachi Farisee hi aton hachi tatakhu an achi cha paꞌ-at, ja ma-id oh-ohha hi itolong cha. ");
INSERT INTO ifu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ipatpatikhaw cha hana khun cha aton ta gway aton kan kaykhu chi tatakhu an mangdayaw ay chicha. Epa-otong cha hana pangittugwan hi texto an ingkha-ut cha ay ni ulu cha ja ay ni taꞌlay cha, ja nun-ipa-anchu-oy cha hana khalampfay chi lopfong cha. ");
INSERT INTO ifu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja am-amja-on cha khu an i umpfun hana umpfunan chi a-ap-apo hichi sinagoga ja nun gwachaan chi pfehta. ");
INSERT INTO ifu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ja penhod cha khu an gway khun mangpaꞌpa-innila ay chicha hi achoꞌlan chi tatakhu, ja mahapor an allon hi ‘Rabbi’ ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Muti ay chaꞌju ayya ja achi khahin un cha allon hi, ‘Rabbi’ ay chaꞌju, ti hin-a-agkhi aju ja un oh-ohha hini mehtolo ju. ");
INSERT INTO ifu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ja ma-id chi oha hi takhu hi i ju dayawon an allon hi, ‘Ama’ ay hija, ti un oh-ohha hini dayawon ju an Ama ju an gwa ad langit. ");
INSERT INTO ifu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ja achi khahin un allon hana i-ibpfa ju hi ‘Apo’ ay chaꞌju ti ha-in an hi Kristo hini oh-ohha an Apo ju. ");
INSERT INTO ifu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hini napfagpfagtuwan ay chaꞌju ja hija hinuy khun tomolong hana i-ibpfa na an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hini mangpapfagto ay ni achor na ja ma-ibaba. Ja ma-ipapfagto hana mumpakumbaba. ");
INSERT INTO ifu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ka-ahi aju, chaꞌju an memehtolon chi urchin Moses ja chaꞌju an Farisee, ti mumpfuhuur aju! Henalegwa ju hana tatakhu an midchum ay ni Pun-ap-apugwan Apo Jos. Achi aju midchum ja enchagkha ju khu an nangpagwa hana mamhod an midchum. ");
INSERT INTO ifu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ka-ahi aju an khun munlahlah! Ti pomloh aju hi khina-un chi pfalo, ja khurkhulaton ju an manganchu-oy an mungkalalag ta allon kan kaykhu hana tatakhu hi nasantuwan aju. Hotti munnaud chi i ju adusaan khapo hay hato khun ju aton! ");
INSERT INTO ifu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ka-ahi aju mangkay an memehtolon chi urchin Moses ja chaꞌju an Farisee ti un aju mumpfuhuur! Ti pfad-angon ju hana baybay ja umuy aju hana ni-achawwi an pfuglay ta i aju mannig hi midchum ay chaꞌju, anong un hay oh-ohha. Ja nu gway midchum, hot pfumi-ah an mangat ay ni napukhit an khun ju aton. Madusa aju ad impferno hi ma-id pogpogna ja e-ar-alla na pay hinuy dusan nuy oha an nidchum ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ka-ahi aju, ti un aju napfupfulaw ja khun aju agkhu muntuchu hi agwun. Nu khulat ta gway munhapata ja hinuy Templo chi ehapata na, ja allon ju hi pfu-un pfahor hini achi na pangatan ay nuy enhapata na. Muti nu khulat ta hini pfalituꞌ hichi Templo chi enhapata na ja allon ju hi pfahor nu achi na aton hinuy enhapata na. ");
INSERT INTO ifu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Naherngan tugwali hinuy nomnom ju! Un ju chah agkhuy anila an napfagpfagto hini Templo mu hini pfalituꞌ? Hini pfalituꞌ ja napfalor ay Apo Jos khapo ta gawwacha ay ni Templo. ");
INSERT INTO ifu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ja amat hina khu nu gway munhapata ja hini altar chi ehapata na, ja allon ju hi pfu-un pfahor hini achi na pangatan ay ni enhapata na. Muti nu khulat ta hini indatona an negwallang ay nuy altar chi enhapata na ja pfahor nu achi na aton hini enhapata na. ");
INSERT INTO ifu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Naherngan hini nomnom ju! Un ju chah agkhuy anila an napfagpfagto hini altar mu hini negwallang an nidaton ay Apo Jos? Hinuy nidaton ja napfalor ay Apo Jos khapo ta gawwacha ay ni altar. ");
INSERT INTO ifu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hini munhapata an hini altar chi enhapata na, ja midchum an amin hana gwa ay ni altar an peꞌhapata na. ");
INSERT INTO ifu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ja amat hina khu, hini munhapata an hini Templo chi ehapata na ja midchum an amin hana gwa ay ni Templo an peꞌhapata na, ja hi khu Apo Jos an nunheto. ");
INSERT INTO ifu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ja hini munhapata an hichi ad langit chi ehapata na ja nidchum hichuy tronon Apo Jos ja hi Apo Jos an inu-umpfun ay nuy trono an peꞌhapata na. ");
INSERT INTO ifu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ka-ahi aju mangkay, chaꞌju an memehtolon chi urchin Moses ja chaꞌju an Farisee ti un aju mumpfuhuur! Manu ti anong un hana munnaud an iꞌ-iꞌ-itang an iꞌnut ju, ja khun ju ichat hini khaggwan Apo Jos. Muti tayya an achi ju nomnomon hana napfarpfalor an urchin, an amat ay ni allon Apo Jos hi mungkhochong koma hini aton ju an munhugwi, ja chin khu inali na hi nignikhaon ju hana ka-ahi, ja chin inali na hi achi aju munlahlah. Hay aton ju koma ja khun ju ichat hini khaggwan Apo Jos muti achi ju alichuwan an mangunud hay hato napfarpfalor an urchin. ");
INSERT INTO ifu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Un aju napfupfulaw an memehtolo! Ti pa-ennongan ju an ánun hinuy it-ittang an imoꞌ ay ni inumon ju ja agkhuy ju gwot anila an niꞌ-uꞌmun ju hini otong an kemer. ");
INSERT INTO ifu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ka-ahi aju, chaꞌju an memehtolon chi urchin Moses ja chaꞌju an Farisee, ti mumpfuhuur aju! Ti ipatpatikhaw ju an mangat hi maphod muti hini piꞌtakhuwan ju ja na-ikot ja mangakaw. Amat aju ay ni takhu an ep-ephod na an ulahan hini nangimpfuttay ni pfahu ja chuju, muti achi na ulahan hichi chohar na. ");
INSERT INTO ifu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Naherngan hinuy nomnom ju an Farisee! Ulahan ju pay hinuy unig ni pfahu ja chuju, hot maleneh khu hini nangimpfuttay. ");
INSERT INTO ifu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ka-ahi aju, chaꞌju an memehtolon chi urchin Moses ja chaꞌju an Farisee, ti mumpfuhuur aju! Omaꞌ-at aju hi lupfuꞌ, ti hini nangimpfuttay ja napintulan hi mapuchaw ja maphod hini tikhaw na, muti hichi unig ja nittugwan hi paang ja napfuluꞌ an achor chi natoy. ");
INSERT INTO ifu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amat hina khu ay chaꞌju, an maphod hi pannig chi tatakhu hana ipatpatikhaw ju an ugali ju, muti napnu aju hi lahlah ja napukhit hini nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ka-ahi aju, chaꞌju an memehtolon chi urchin Moses ja Farisee, ti mumpfuhuur aju! Un ju agkhu khun ep-e-ep-ephod hana lupfuꞌ chin profetan Apo Jos, ja ar-arkuhan ju hana lupfuꞌ hana magpong an takhu. ");
INSERT INTO ifu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Allon ju hi, ‘Nu chaꞌmi koma chi gawwacha chin timpon chin a-ammod mi, hot agkhuy ami neꞌ-op ay chuy namatajan cha hachi profetan Apo Jos.’ ");
INSERT INTO ifu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hotti tayya an chaꞌju hitay mangpa-innila an holag chaꞌju hay hachi namatoy hachi profeta. ");
INSERT INTO ifu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hot takha, ikhibpfoh ju an aton hato napupukhit an ena-enat chin a-apo ju. ");
INSERT INTO ifu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Haw chaꞌju pay an lomahlalahlah an khun umallilaw hi tatakhu, ngay nin aton ju ta achi aju umuy ad impferno? ");
INSERT INTO ifu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hijaot agkhu un u honakhon hay hana profeta ja mun-anomnom an tatakhu ja hana muntudtuchu ay ni Hapit Apo Jos. Muti anilaꞌ an patajon ju hana uchumna, ja epepfakhat ju hana uchumna hi kros. Ja pumpakhuh ju hana uchumna hina sinagoga ju ja lomajaw cha ayya, hon inunud ju nu ngay omajan cha ta palikhaton ju chicha. ");
INSERT INTO ifu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chaꞌju chi manchor hi dusan nuy nun-a-atajan an amin chin magpong an tatakhu an penatopatoy cha. Nahhun hi Abel an penatoy cha ja hachi uchumna ingkhanah chin namatajan cha ay Zekariah an empfalay Barakiah an inah-upan cha ay ni numpfattanan ni altar ja hini Templo. ");
INSERT INTO ifu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Umannung hitay alloꞌ ay chaꞌju, an chaꞌju an tatakhu ad ugwani chi manchor an amin hi dusa khapo hi nun-a-atajan hato tatakhun Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Haw inay atag kaykhu chaꞌju an tatakhu ad Jerusalem, an un la-ahna ja un ju patajon hana profeta ja nungkhajang ju an amin hana honakhon Apo Jos ay chaꞌju! Khun u nomnonomnomon an manga-allungan ay chaꞌju an amat hi upfuwan an eloꞌ-ob na hana empah na, muti achi ju podhon! ");
INSERT INTO ifu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hotti tayya an te-a-an chaꞌju ay Apo Jos ja ipulang na hitay pfuglay ay chaꞌju ta un aju ikhad. ");
INSERT INTO ifu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Alloꞌ ay chaꞌju hi achiyaꞌ mahpay matigtikhaw ay chaꞌju ingkhanah chin arkhaw an pangallan ju hi, ‘Mabindisyonan hini Hennag Apo Jos an immali an mun-ap-apo ay chita-o.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Unagkhu gwa an makak hi Hesus hichi Templo ja gwacha gwot hachi disipolo na. Ja podhon cha an ipatikhaw ay Hesus hichuy Templo an napfarpfalongabpfingan. ");
INSERT INTO ifu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ja inalin Hesus hi, “Tayya an matikhaw ju hitay aphod tay Templo, muti umannung hitay alloꞌ ay chaꞌju, an umali han arkhaw hot mun-ahagwer ja mun-egwa-at cha hay hato pfato an apja na.” ");
INSERT INTO ifu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nunti-id cha Hesus ay chuy pfulludna an ad Olibo ja inumpfun. Immi-igway hachi disipolo na an i niꞌhapit ay hija ja inali cha hi, “Apo, aꞌ-anunay pa-atan hay hato inalim? Ipa-innilam adchiya hay pangmatunan ay ni pumpfangngacham an apogpokhan tay lota.” ");
INSERT INTO ifu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tempfar Hesus ja inali na hi, “Tikhagwun ju gwot niꞌ ta achi aju ma-allilaw. ");
INSERT INTO ifu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ti cho-or chi umali an mangali hi, ‘Ha-in hini Hennag Apo Jos an Mamahhod,’ ja cho-or chay mamati muti un cha napfarpfalijan. ");
INSERT INTO ifu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ja chonglon ju an gway mungkhukhupfat hana nehegkhon an pfuglay ja ipa-innila cha khu an gway mungkhukhupfat hana nun-i-achawwi an pfuglay, muti achi aju tomakhaw. Ti mahapor an ma-at hay hato muti pfu-un pay hitay chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hay ma-at ja mungkhukhupfat chi apfuglapfuglay ja anong un hay hana nasyon. Ja gwachay khihu ja umali chi ulat ton numpfino-ob-on an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Muti hay hato ja un pay teꞌte-an hana umali an punlikhatan heto lota. ");
INSERT INTO ifu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ijuy chaꞌju hana hugi ta palikhaton chaꞌju, ja patajon chay uchumna. Ja pfuhulon chaꞌju an amin hi tatakhu khapo hi nangunuchan ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ay nuy an timpo ja cho-or hana man-ug ay ni pammati cha ay ha-in. Ja hana tatakhu ja itannong cha hon inliput cha hana ibpfa cha hay hana ap-apo ta patajon cha. Hot mumpfipfinnuhur cha. ");
INSERT INTO ifu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ja cho-or hana umali an munlahlah an profeta, ja cho-or hana allilagwon cha. ");
INSERT INTO ifu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Khapo hi chom-olan hato napukhit an khun aton chi tatakhu ja ma-apfak hini pumpepennohhochan cha. ");
INSERT INTO ifu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Muti hana mangedpor hay hato ingkhanah atajan cha an achi cha epfot hini pammati cha, ja miꞌtakhu cha. ");
INSERT INTO ifu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja mekasaba hitay Ebanghelyo ta mipa-innila hini Pun-ap-apugwan Apo Jos an amin hi apfuglapfuglay ta chonglon chi atakhutakhu. Na-at ayya hitay hot mapogpog hitay lota.” ");
INSERT INTO ifu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Entoloy Hesus an nangali hi, “Unchani hot tikhan ju hini na-ali-ali an ‘Pumapaꞌ-i an Apfopfohor hi Pannikhan Apo Jos’ an hija chin hinapit chin profetan Apo Jos an hi Daniel. Ti tikhan ju an i tumaꞌchug hichi Templo an nasantuwan. Chaꞌju an khun mumpfaha, mahapor an ma-awatan ju. ");
INSERT INTO ifu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nu pfumutay hitay na-ali an Pumapaꞌ-i hot lomajaw hana gwa ad Judea ta umuy cha hichi pfuludna. ");
INSERT INTO ifu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hini takhu an gwa hi partug ni pfalay na ja achi agkhu i humikhop ta alaonay khina-u na, ta un atoꞌtogna ja empacheh na an lomajaw. ");
INSERT INTO ifu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ja hini takhu an gawwa hichi pajaw ja achi na ihi-ar an umanamut an i mangala hi uchumnah lopfong na ta un atoꞌtogna ja lemmajaw. ");
INSERT INTO ifu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Munnaud aju an malikhatan ay nuy an timpo, om-omod hay hana numpunhapfin ja hana khun mumpahuhu! ");
INSERT INTO ifu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mungkalalag aju ta ma-at ayya hay hato ja achi metongor hi ahitungnin wenno hay Hapfachu an arkhaw chi ngilin. ");
INSERT INTO ifu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ti nete-a chin na-apjaan tay lota ja ingkhana ad ugwani ja ma-id chi hay immali hi likhat hi miꞌpadchung ay tay umali an munlinapoh an likhat. Ja anong un hi uchum chi arkhaw ja ma-id ma-at hi likhat an amat heto. ");
INSERT INTO ifu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma-umah an amin chi tatakhu nu agkhuy koma inhumang Apo Jos an mangpahoꞌhoꞌchod ay nuy timpo an punlikhatan cha. Hoꞌhoꞌchochona khapo hi khohkhoh na hay hana tatakhu an pinili na. ");
INSERT INTO ifu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nu khulat ta gway mangali hi, ‘Tayya hini Hennag Apo Jos an Mamahhod!’ wenno ‘Chuyya hija!’ ja achi ju pattiyon. ");
INSERT INTO ifu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ti gwacha hana pfumarpfali an mangali hi un chicha anu hini Hennag Apo Jos an Mamahhod, ja uchumna ja allon cha hi chicha anu chi profetan Apo Jos. Gway apfalinan cha an mangat hi numpfino-ob-on an milagro ta mapfalijan chi tatakhu, anong un hana tatakhu an pinilin Apo Jos nu apfalinan cha an aton. ");
INSERT INTO ifu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hotti pa-ennongan ju, ti tayya an impa-innilaꞌ an amin hay hato ja un cha ma-at. ");
INSERT INTO ifu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nu khulat ta gway mangali hi, ‘Numpfangngad hi Kristo ja gawwa hichi let-ang’ ja achi aju umuy an i mannig. Ja nu khulat ta allon cha khu hi, ‘Gwah to unig’ ja achi ju pattiyon. ");
INSERT INTO ifu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ti ha-in an Na-ilangitan an Takhu ja mumpfangngachaꞌ an amat hi ilat an mepfachong ad uchu ja tikhan an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Anila ju an ay ni achaan chi natoy ja ma-amung hana hagwiti an i omman ay ni achor na.” ");
INSERT INTO ifu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Entoloy Hesus an nangali hi, “Mahiꞌnut an ma-at hay hato an likhat an inaliꞌ hot homelong hichuy hukhit ja achi khu humilaw hichuy pfulan. Makiharpfu ad uchu hot mun-a-akhah hachi pfittuwan. ");
INSERT INTO ifu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja gwa han matikhaw ad uchu an panginnilaan ay ni khumaju an umaliyaꞌ an Na-ilangitan an Takhu. Kumila hana atakhutakhu heto lota ti nehnot hini ahugijan cha. Ja unaꞌ gwot tikhan ay chicha an Na-ilangitan an Takhu, an marpuwaꞌ ad langit an midchum hi pfonot. Munnaud chi pfinang u ja magwachaanaꞌ hi apfalinan. ");
INSERT INTO ifu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Khumangoh hay abpfuu ja honakhoꞌ hana angher u an umuy ay tay nunleneꞌgwoh tay lota ta amungon cha hana tatakhu an piniliꞌ an amin hi apfuglapfuglay.” ");
INSERT INTO ifu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Inalin khu Hesus hi, “Nomnomon ju hini ajiw an higos ti gwa han epa-achar na. Ti hini ayya higos, nu tikhan ju an umughoꞌ ja tumupfu hot ma-annila an nehnot hini tijarkhaw. ");
INSERT INTO ifu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Amat hina khu, nu tikhan ju an khun ma-at hay hato inaliꞌ, hot ma-annila ju an nenehnot hini pumpfangngachaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Umannung hitay alloꞌ an achi pay matoy an amin chi tatakhu ay tay an himpangapo hot ma-at an amin hay hato inaliꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hitay lota ja ad uchu ja ma-upfah cha, muti achi ma-ub-upfah hitay hapit u.” ");
INSERT INTO ifu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Entoloy Hesus an nangali hi, “Ma-id oh-ohhah nanginnila ay nuy arkhaw wenno oras an pumpfangngachaꞌ, anong un hana angher Apo Jos ja ha-in an Empfalay na. Angkhay hi Jos Ama chi nanginnila. ");
INSERT INTO ifu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hay omaꞌ-atan ni pumpfangngachaꞌ an Na-ilangitan an Takhu ja amat chin na-at chin timpon Noah, ");
INSERT INTO ifu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","an chin agkhuy pay nartotan tay lota ja khun mangmangan hachi tatakhu, ja khun cha mangin-inum, ja khun cha mumpun-ah-ahagwa ingkhanah chin arkhaw an himmikhupan cha Noah chin papor. ");
INSERT INTO ifu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kheꞌ-emhon cha ja immali chin lotot ja ni-anud cha an amin hot nun-a-atoy cha. Amat hina ay ni pumpfangngachaꞌ an Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ay nuy pumpfangngachaꞌ ja nu gway chugwa hi takhu an khun muntamu hichi pajaw, ma-ala hini oha ja mataynan hini oha. ");
INSERT INTO ifu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ja khulat na ta gwacha hay chugwa hi pfupfai an khun mungkheleng, ma-ala hini oha ja mataynan hini oha. ");
INSERT INTO ifu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hotti peꞌhehemad ju, ti agkhuy ju anila hini timpo an pumpfangngachaꞌ an Apo ju. ");
INSERT INTO ifu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anila ju an nu khulat ta hini ammod ay ni oha an pfalay ja anila na hini timpo an umaliyan ni mangakaw, hot tumu-ar ta mumpfantay ta epagwa na hi humigpana ay ni pfalay na. ");
INSERT INTO ifu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hotti munhahagkhana aju, ti mumpfangngachaꞌ an Na-ilangitan an Takhu ay ni timpo an agkhuy ju anila.” ");
INSERT INTO ifu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Alloꞌ ay chaꞌju hay amatan chi takhala an manomnom ja mapagtarkan. Hijay potpot-on ni apo na an mangpagpong ay ni pfalay na, ja managwit ay ni enarkhaw an peꞌ-an hana papadchung na an takhala ay ni timpon chi punhapulan cha. ");
INSERT INTO ifu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mun-an-anla hini takhala an chakngan ni apo na an khun mangat ay ni impatamu na. ");
INSERT INTO ifu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Alloꞌ ay chaꞌju hi ehaad tay apo na hitay an takhala ta hijay mumpfantay an amin ay ni enachangjana. ");
INSERT INTO ifu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Muti khulat ta napukhit hini nomnom tay an takhala ja allona hi, ‘Aa, tayya an mapfajag ja un umanamut hini apoꞌ,’ ");
INSERT INTO ifu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ja ente-a na an mumpanuplit hana padchung na an takhala, ja khun mangmangan ja khun miꞌ-in-inum hana khun mapfutong. ");
INSERT INTO ifu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Umali han timpo an agkhuy inannilan tay takhala ja umanamut hinuy apo na hot ah-upana hato an khuna aton. ");
INSERT INTO ifu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hot punnauchon nuy apo na an palikhaton hija ja etapar na ad impferno ta midchum hay hana tatakhu an mumpfuhuur ta maparpalikhat. Ja mun-okhab cha ja mungngelot chi pfapfa cha.” ");
INSERT INTO ifu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Inalin Hesus hi, “Amat heto chi pipadchungan tay Pun-ap-apugwan Apo Jos. Mipadchung han himpolo an pfabpfalahang an nahnag an i manittum ay ni lala-e an marhin. Enala cha chin panor cha ja empacheh cha. ");
INSERT INTO ifu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Natottot chin lema ay chicha ja manomnom khu chin lema. ");
INSERT INTO ifu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ti hachi lema an natottot ja inugnan cha chin panor cha muti ma-id uchumna hi inugnan cha hi lana hi itto cha chin panor cha hi un mapoh hini nitto. ");
INSERT INTO ifu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hachi lema ja manomnom, ti nenomnom cha an mangala pay hi pfoterja an nittugwan hi lana ta gway usaron cha hi un machop chin chilag cha. ");
INSERT INTO ifu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nataktak chin lala-e an i cha chittumon hotti immijahop cha ja naloꞌ cha hi papannochan cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Unagkhu temmonga ja gwa han mun-ugwap an allona hi, ‘Chan umali hini lala-e an marhin! Umali aju ta i ta-o chittumon.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Napfalleꞌgwachang hachi himpolo an pfabpfalahang ja enhakhana cha chin panor cha. ");
INSERT INTO ifu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ja inalin hachi lema an natottot hay hachi lema an manomnom hi, ‘Achi aju amat hina ta ichatan chaꞌmi ay nuy lana ju, ti tan mamadchop hay hato panor mi.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ja inalin hachi lema an manomnom hi, ‘Achi mapfalin ti un akkay ad-adchi hi usaron ta-o an amin. Umuy aju gwot ta un aju i ngumina.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Immuy cha an i ngumina ja unchaagkhu nakak ja emmatam hichin lala-e. Nitnud hachi lema an nunhahagkhana an immuy ay chuy pfalay an pungkasalana. Himmikhop cha ja nipfukhot ja nicha-ig chin pantaw. ");
INSERT INTO ifu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma-id umijahop ja tuwoy chin lema an natottot an pfabpfalahang ja khun cha mun-ugwap hichi pfutayna an allon cha hi, ‘Apo! Ipfughor mu ta miꞌhikhop ami!’ ");
INSERT INTO ifu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ja tempfar chin lala-e ja inali na hi, ‘Achi mapfalin, ti umannung an ma-id anilaꞌ ay chaꞌju.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ja en-ang-angonoh Hesus an nangali hi, “Hotti peꞌhehemad ju, ti agkhuy ju anila hini arkhaw ja oras an pumpfangngachaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Inalin khu Hesus hi, “Amat heto khu chi pipadchungan ni Pun-ap-apugwan Apo Jos. Mipadchung ay ni takhu an munhakhana an i mumpfaat. Empapfokha na hana takhala na ta ipulang na ay chicha hinuy enachangjana ta ikumerchu cha. ");
INSERT INTO ifu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hotti inchat na ay chicha hini me-okor ay ni la-eng cha an mungkumerchu. Inchatana chin oha hi lemay lipfu, ja inchatana khu chin oha hi chugway lipfu, ja inchatana khu chin oha hi ohay lipfu, ja unaot epacheh an umuy. ");
INSERT INTO ifu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chin ayya oha an takhala an nichatan hi lemay lipfu ja ingkumerchu na gwot ja lemah lipfu chin intu-u na. ");
INSERT INTO ifu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hichuy khu oha an nichatan hi chugwah lipfu ja ingkumerchu na ja chugwah lipfu khu chin intu-u na. ");
INSERT INTO ifu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ja na-ala agkhu hitay oha an nichatan hi ohay lipfu ja unaagkhu kaykhu ay in-ukah ta ehaꞌpfa na chin pelaꞌ chuy apo na. ");
INSERT INTO ifu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nalahin chi at hichi hi arkhaw ja numpfangngad chin apon hachi takhala, ja empapfokha na chicha ta annilaona nu atanay intu-un ni pihu na. ");
INSERT INTO ifu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Immuy chin oha an inchatana hi lemah lipfu ja inugnana chin himpoloh lipfu, ja inali na hi, ‘Apo, lemay lipfu chin impulang mu ay ha-in ja ingkumerchuꞌ ja tayya han lemay lipfu khu an intu-u na.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Inalin chin apo na hi, ‘Maphod a an takhala ja mapagtarkan. Empa-ennongam an nangpaptoꞌ ay nuy it-ittang an impulang u ay he-a, hotti ehaad u he-a an mangpaptoꞌ hi choꞌchoꞌ-or. Hot meꞌ-an-anla a ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ja immuy khu chin oha an inchatana hi chugway lipfu ja inali na hi, ‘Apo, chugway lipfu chin impulang mu ay ha-in ja ingkumerchuꞌ ja tayya han chugway lipfu khu an intu-u na.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ja inalin chin apo na hi, ‘Maphod a an takhala ja mapagtarkan. Empa-ennongam an nangpaptoꞌ ay nuy it-ittang an impulang u ay he-a, hotti ehaad u he-a an mangpaptoꞌ hi choꞌchoꞌ-or. Hot meꞌ-an-anla a ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ja immuy khu chin oha an inchatana hi ohay lipfu ja inali na hi, ‘Apo, anilaꞌ an mapfungot a an takhu, ja khun chaꞌmi alan ta pungkumerchuwon chaꞌmi ta gway atom an omachangjan. ");
INSERT INTO ifu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hotti temma-otaꞌ atag ja ijaꞌ in-ukah hitay pelaꞌ mu ta mehaꞌpfa. Tayya an nunchochodcha hotti alaom.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ja inalin chin apo na hi, ‘Napukhit a an takhala ti nahachot a! Nu anilam koma an khun u pungkumerchuwon chaꞌju ta gway atoꞌ an omachangjan, ");
INSERT INTO ifu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ja anagkha ta agkhuy mu mah niꞌ i imbangko hinuy pelaꞌ u ta gway ma-alaꞌ hi intu-u na ad ugwani an numpfangngachaꞌ?’ ");
INSERT INTO ifu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ja inalin chin apo na hachi uchumna an takhala na hi, ‘Alaon ju hichuy pelaꞌ an gwa ay hija ta ichat ju ay chuy takhala an himpoloy lipfu chi pihu na. ");
INSERT INTO ifu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ti hini mangpa-ennongan ay ni nichat ay hija ja ma-ug-ugman ta choꞌchoꞌ-or. Muti hini ayya achi mangpa-ennongan ay ni nichat ay hija hot anong un hay it-ittang hi gwa ay hija ja pfangngachon Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ja hitay ayya ma-id herpfi na an takhala, etapar ju hichi gwachaan chi munhehellong ta midchum hana khun mun-okhab an mungngelot chi pfapfa na.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Inalin khu Hesus hi, “Mumpfangngachaꞌ an Na-ilangitan an Takhu an magwachaan hi pfinang ja apfalinan. Mitnud hana a-anghe-angher ja umpfunaꞌ ay ni tronoꞌ an mun-ap-apo. ");
INSERT INTO ifu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","An amin hana tatakhu ja ma-amung cha an humango ay ha-in. Ja khaggwoꞌ chicha an amat hi mumpahtor an annikhona hana karnero ja inannig na khu hana khancheng. ");
INSERT INTO ifu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hana magpong an tatakhu an ipadchung u hi karnero, ja ipi-uy u ay tay nun-appit hi agwan u. Ja hana ipadchung u hi khancheng, ipi-uy u ay tay nun-appit hi ikhid u. ");
INSERT INTO ifu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ja ha-in an Ari, alloꞌ hay hana tatakhu an gwa ay tay nun-appit hi agwan u hi, ‘Binindisyonan chaꞌju ay Jos Ama hotti umali aju an midchum ay ni Pun-ap-apugwan Apo Jos an enchachaag na hichin narmugwan tay lota hi pfanoh ju. ");
INSERT INTO ifu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ti hemmenaangaꞌ ja penanganaꞌ ay chaꞌju, na-ugagaꞌ ja inchat juy ininum u. Ma-id anilaꞌ hi ujaꞌ punnangngan hon minangiliyaꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma-id pohodna hi peꞌlopfong u ja linupfunganaꞌ ay chaꞌju. Nunchokhohaꞌ ja enggwangalaꞌ ay chaꞌju, ja nipfaluchaꞌ ja immali aju an nannig ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hot allon cha tay an magpong an tatakhu hi, ‘Apo, aꞌ-anunay nannikhan mi ay he-a an hemmenaang ja penangan mi he-a, wenno na-ugaw ja inchat mi hay ininum mu? ");
INSERT INTO ifu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aꞌ-anunay immaliyam ja minangili mi he-a, wenno ma-id pohodna hi peꞌlopfong mu ja linupfungan mi he-a? ");
INSERT INTO ifu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ja ngay nunchogham wenno nipfalucham ja immali ami an nannig ay he-a?’ ");
INSERT INTO ifu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ja ha-in an Ari, ja alloꞌ ay chicha hi, ‘Umannung hitay alloꞌ an hay hato an enat ju an temmolong hay hana tatakhuꞌ, anong un hana ma-id pfirpfilang na an takhu, ja hihiya an ha-in chi nangatan ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ja alloꞌ khu hana tatakhu an gwa ay tay nun-appit hi ikhid u hi, ‘Makak aju, chaꞌju an nahumarja ta madusa aju. Umuy aju ad impferno an gwachaan chi apoy an achi madmachop an nechachaag hi pituuchan Satanas ja hana i-ibpfa na an nun-apukhit an angher. ");
INSERT INTO ifu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ti hemmenaangaꞌ ja agkhujaꞌ penangan ay chaꞌju. Na-ugagaꞌ ja ma-id inchat ju hi ininum u. ");
INSERT INTO ifu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma-id anilaꞌ hi ujaꞌ punnangngan ja agkhujaꞌ minangili ay chaꞌju. Ma-id pohodna hi peꞌlopfong u ja agkhujaꞌ linupfungan ay chaꞌju. Nunchokhohaꞌ ja nipfaluchaꞌ ja ma-id immali ay chaꞌju an nanggwangar ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hot allon cha hi, ‘Apo, aꞌ-anunay nannikhan mi ay he-a an hemmenaang, ja na-ugaw, ja ma-id im punnangngan, ja ma-id pohodna hi peꞌlopfong mu, ja nunchokhoh a, ja nipfalud a, ja agkhuy chi-a hinalimunan?’ ");
INSERT INTO ifu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ja alloꞌ ay chicha hi, ‘Umannung hitay alloꞌ ay chaꞌju, an hini enat ju an agkhuy nanulungan hay hana nababa an tatakhuꞌ, ja hihiya an ha-in chi nangatan ju.’ ");
INSERT INTO ifu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hotti hay hato ja umuy cha ad impferno ta madusa cha hi ma-id pogpogna. Ja hana magpong an tatakhu, ja miꞌtakhu cha ay Apo Jos hi ma-id pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Napfalin an intuchun Hesus hay hato ja inali na hachi disipolo na hi, ");
INSERT INTO ifu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Anila ju an malahin chi chugwah arkhaw hot machakngan chin Pfehta an Pangnomnoman cha chin Nalohan chin Angher Apo Jos chin A-apo cha ad Egypt, ja ha-in an Na-ilangitan an Takhu, me-agwataꞌ hana pfuhur u ta epfakhataꞌ han kros.” ");
INSERT INTO ifu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Netongor ja na-amung hachi a-ap-apon chi papachi ja hana uchumna an a-ap-apon chi Hudju hichi pfalay nuy Natakhay an Pachi, an hi Kayfas. ");
INSERT INTO ifu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nunhahappitanan cha hay aton cha an maniliw ay Hesus ta ma-id oh-ohhah manginnila ta epapatoy cha. ");
INSERT INTO ifu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ja inali cha hi, “Achi ta-o koma etongor ay tay umali an pfehta an achoꞌlan chi tatakhu, ti unchani ja chumalat ja gway pumpapattajan chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hichin agawwachaan cha Hesus ad Betani hi pfalay cha Simon an oha an na-unit an enakhahan Hesus ");
INSERT INTO ifu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ja khun cha mangan hi himmigpan han pfupfai. Inu-ugnana han alabastro an pfoterja an nittugwan hi naꞌ-angngina an lanob. Nehnot chin pfupfai ay Hesus ja inhiit na chin lanob chin ulu na. ");
INSERT INTO ifu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Unot tinnig hachi disipolo na ja lemmallataꞌ cha ja khun cha allon hi, “Ay-ayyu a mah hichuy an lanob an una am-amhan. ");
INSERT INTO ifu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Uchuꞌchuna agkhu niꞌ una ingngina ta ichat na hini pfajad na hay hana napubli.” ");
INSERT INTO ifu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Muti anilan Hesus hini khun cha allon ja inali na hi, “Achi ju amujuwan hija! Pfuher hitay enat na ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hana ayya publi ja gawwacha cha ay chaꞌju hi a-arkha-arkhaw, muti ha-in ja nehnot chin arkhaw an panaynaꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hitay an pfupfai ja inhiit na hitay lanob ay tay achor u ta mehahagkhana ay nuy umali an pilub-aꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Umannung hitay alloꞌ. An amin chi omajan hana mangkaskasaba ay ni Ebanghelyo ay tay nunleneꞌgwoh tay lota, ja pigpiggwon cha hitay enat tay pfupfai ta achi malidlichuwan.” ");
INSERT INTO ifu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Amat hichi ja immuy hi Judas Iskariot, an oha ay cha chuy himpolo ta chugwa an adalan Hesus, ta i niꞌhapit hachi a-ap-apon chi papachi. ");
INSERT INTO ifu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Inali na ay chicha hi, “Atanay lagpfuꞌ nu e-agwat u hi Hesus ay chaꞌju?” Ja inchatan cha hija hi tolompolo hi pelaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hotti nete-a ay chuy ja henehemmon Judas hay atona an mangtuchu ay Hesus ta tiligwon cha. ");
INSERT INTO ifu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nachakngan chin penghan chi arkhaw chi Pfehta an Panganan cha hi Tenapay an Ma-id Pfinoꞌpfoꞌ na. Immuy hachi adalan ay Hesus ja inali cha hi, “Ngay podhom hi i mi punhakhanaan ay ni anganan ta-o ay tay Pfehta?” ");
INSERT INTO ifu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ja inalin Hesus hi, “Umuy aju ad Jerusalem hichi pfalay nuy lala-e an anila ta-o, ja allon ju ay hija hi, ‘Empaad nuy Apo ta-o an allon mi hi gwa an machakngan hini timpo an pa-atan chin eneꞌchan Apo Jos an ma-at ay ha-in. Hotti umaliyaꞌ an midchum hana adalan u ta heto pfalay ju chi anganan mi ay tay an Pfehta.’ ” ");
INSERT INTO ifu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hotti inunud hachi adalan chin inali na ja immuy cha ta i cha nunhakhana ay ni anun cha ay chuy an pfehta an i cha Pangnomnoman chin Nalohan chin Angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Unagkhu nadhom ja neꞌ-orpfong hi Hesus hachi himpolo ta chugwa an adalan ay chuy an pfalay. ");
INSERT INTO ifu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Khun cha mangan ja inalin Hesus hi, “Umannung hitay alloꞌ ay chaꞌju, an gwa han oha ay chaꞌju an i mangpfaag ay ha-in hana pfuhur u.” ");
INSERT INTO ifu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Magkhoh hi punleꞌnaan hachi adalan ay chuy inalin Hesus ja un gwahchinonon hon at hi mangpfokha hi, “Apo, un chah ha-in hini allom an mangat?” ");
INSERT INTO ifu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tempfar Hesus ja inali na hi, “Hini mangngina ay ha-in ja oha an khun meꞌhawhaw ay ha-in hi tenapay ay tay chuju. ");
INSERT INTO ifu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ti ha-in an Na-ilangitan an Takhu ja matojaꞌ an matoy ta mipa-annung chin impatulaꞌ Apo Jos hachi profeta chin hopapna. Muti ka-ahi hini mangngina ay ha-in! Toꞌ-onot un agkhuy netoꞌkhong hija!” ");
INSERT INTO ifu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ja himmapit hi Judas an hija hinuy mangngina ay Hesus ja inali na hi, “Apo, un chah ha-in hini mangat?” Ja inalin Hesus hi, “Aa, he-a.” ");
INSERT INTO ifu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Gwa an khun cha mangan ja unot alan Hesus han tenapay ja nunyaman ay Apo Jos ja initta-ittang na. Ja enggwanah na chin adalan ja inali na hi, “Tayya, alaon ju hitay tenapay ja inan ju, ti hitay hini achor u.” ");
INSERT INTO ifu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ja enala na khu chin pfahu an nittugwan hi chanum chi ubas. Nunyaman ay Apo Jos ja inchat na ay chicha ja inali na hi, “Hiniꞌ-itangon ju an inumon ");
INSERT INTO ifu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ti hijah tay hini chalaꞌ an mangpa-annung hi neꞌtobpfalan Apo Jos ay chaꞌju. Umajuh hitay chalaꞌ ta gway aton chi pfahor hana cho-or an tatakhu an mapakawan. ");
INSERT INTO ifu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Alloꞌ ay chaꞌju hi hitay chi ang-angonohna hi piꞌ-inumaꞌ hi chanum chi ubas ingkhanah chin arkhaw an piꞌ-inumaꞌ ay chaꞌju ay nuy nat-on an chanum chi ubas ay nuy Pun-ap-apugwan Ama.” ");
INSERT INTO ifu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Emmopoh hitay inalin Hesus ja engkanta cha han ohan Psalm ja un chaot epacheh an umuy hichi pfulludna an ad Olibo. ");
INSERT INTO ifu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Inalin Hesus chin adalana hi, “Ad ugwani an lapfi ja anilaꞌ an te-a-anaꞌ ay chaꞌju. Ti allona ay ni hapit Apo Jos hi, ‘Patajoꞌ hini khun mumpahtor hot mahihijaꞌ hay hana karnero.’ ");
INSERT INTO ifu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Muti nummahuwaꞌ ayya ja ipanguluꞌ an umuy ad Galilee ta hichi punchichittuman ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Himmapit hi Peter ja inali na hi, “Anong un chi-a taynan hato uchumna an adalan, muti ay ha-in ja achiꞌ mangkay taytaynan he-a.” ");
INSERT INTO ifu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ja inalin Hesus ay Peter hi, “Umannung hitay alloꞌ. Ehaotaꞌ ay he-a hi mumpitlo ad ugwani an lapfi ja unot tumalanu.” ");
INSERT INTO ifu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Muti inalin Peter hi, “Achiꞌ ehaot he-a, anong unaꞌ me-etoy.” Ja amat khu hina chin inalin an amin hachi adalan. ");
INSERT INTO ifu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Amat hichi ja immuy cha Hesus han lukhar an nangadnan hi Getsemane, ja inali na chin adalan hi, “Mehetay aju ta umujaꞌ mungkalalag.” ");
INSERT INTO ifu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Muti initnud na cha Peter ja hachi chugwa an empfalay Zebedee. Munnaud an munchokhoh hi punnomnomana, ");
INSERT INTO ifu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","hotti inali na ay chicha hi, “Ma-id ay chita an munnaud an machamot hi punleꞌnaaꞌ ja tan omataꞌ hi matoy. Hotti mehetay aju ja achi aju agkhu maloꞌ ta un aju miꞌtu-ar ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ja pfinumtaw ja i nunheppe an nungkalalag ja inali na hi, “Ama, nu mapfalin koma, ja i-achawwim adniꞌ hini umali an apalikhataꞌ. Muti pfu-un hini podhoꞌ chi ma-at ta hini podhom.” ");
INSERT INTO ifu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Numpfangngad hi Hesus chin agawwachaan chin tolo an adalana ja chinakngana chicha an nanalloꞌ. Ja inali na ay Peter hi, “Un chah achi mapfalin an miꞌtu-ar a ay ha-in hi ohay upfun mah niꞌ? ");
INSERT INTO ifu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Achi aju agkhu maloꞌ ta un aju gwot meꞌkalalag ta achi aju ma-apfak nu matopngan hini pammati ju. Ti anilaꞌ an ay ni nomnom ju ja podhon ju an miꞌ-unud muti ma-id olog ni achor ju.” ");
INSERT INTO ifu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Amat hichi ja immuy an i khu nungkalalag ja inali na khu hi, “Ama, nu achi mapfalin an ergwangaꞌ ay tay ujaꞌ apalikhatan ja apfulutoꞌ ta ma-at hini penhod mu.” ");
INSERT INTO ifu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Numpfangngad khu chin agawwachaan hachi tolo an adalan ja chinakngana chicha an nanalloꞌ, ti achi medpor chin enloꞌ cha. ");
INSERT INTO ifu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hotti tenaynana khu chicha ja immuy nungkalalag an hihiya chin engkalalag na. ");
INSERT INTO ifu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chin petlon chi pumpfangngachana ja inali na hachi adalan hi, “Hot anagkha mah un aju mamamalloꞌ ja mun-en-enana? Pfumangon aju ti toja an nachakngan hitay timpo an eneꞌchan Apo Jos hi ipulangaꞌ an Na-ilangitan an Takhu ay cha nuy napfahulan an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lomeggwat aju, ti chuja an umali hichuy nangngina ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Khun pay munhapit hi Hesus ja emmatamot hi Judas, an oha ay cha chuy himpolo ta chugwa an adalan, an impfupfulog na hachi cho-or an tatakhu an numpumpfangid ja numpumpang-or cha. Hay nannag ay chicha ja chin a-ap-apon chi papachi ja chin uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ja intuchun Judas han pangmatunan cha ay Hesus, an hini takhu an agwalona ja hija chi tiligwon cha. ");
INSERT INTO ifu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Un chaot emmatam ja immuy hi Judas ja enagwar na hi Hesus ja inali na hi, “Immali ami, Apo!” ");
INSERT INTO ifu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ja inalin Hesus ay hija hi, “Akhiꞌ, anagkha ta immali a heto?” Ja nehom hachi numpun-ibpfan Judas an i numpangugnan ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Henoꞌnot chin oha an nun-ibpfan Hesus chin pfangid na ja impakhit na chin takhalan chi natakhay an pachi hotti nakhingahan chin inga na. ");
INSERT INTO ifu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ja inalin Hesus hi, “Ehe-ot mu gwot hinuy pfangid mu. Ti nu pomatoy a an usarom chi pfangid ja mumpfangngad an hija khu chi im atajan. ");
INSERT INTO ifu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Khemhom un amat hetoy atom an tomolong ay ha-in muti agkhuy mu nenomnom an nu podhoꞌ an mumpatolong hot alloꞌ ay Ama ta honakhona gwot hay hingkhahot hi lipfu an angher ta gway tomolong ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Muti nu atoꞌ hitay ja ngay mah aton ni nitulaꞌ an Hapit Apo Jos an mipa-annung?” ");
INSERT INTO ifu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ja inalin Hesus hachi atakhutakhu hi, “Unaꞌ chah ngumangannu ta numpfapfangid ja numpun-ochon aju hi pang-or an immali an mampap ay ha-in? A-arkha-arkhaw ja gawwacha ta-o an amin hichi Templo hi khun u puntudtuchugwan ja agkhujaꞌ tiniliw. ");
INSERT INTO ifu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Muti na-at hay hato ta mipa-annung hana impatulaꞌ Apo Jos chin profeta.” Nakhibpfoh hitay an inalin Hesus ja nahijaꞌ hachi adalan ja nataynan hija. ");
INSERT INTO ifu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hay hachi naniliw ay Hesus ja in-uy cha hija ay ni pfalay chin natakhay an pachi an hi Kayfas, ti hichi chi na-amungan chin memehtolon chi urchin Moses ja chin uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Khun mangun-unud hi Peter ingkhanah emmatam chin partug chin pfalay chuy natakhay an pachi. Himmikhop ja ni-ipfun hachi gwarja ta annilaona hay ma-at. ");
INSERT INTO ifu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chin a-ap-apon chi papachi ja an amin chin numpun-ibpfa cha an membron chi Sanhedrin, ja henehemmon cha hay panghiꞌ-ingan cha hi pamatajan cha ay Hesus, anong un achi ohto. ");
INSERT INTO ifu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Muti ma-id chinakngan cha, anong un cho-or hana nunlahlah an nuntihtikhu. Unot napfaypfajag, ja gwa han chugwa an immuy hichi sango, ");
INSERT INTO ifu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ja inali cha hi chengngor cha an inalin Hesus hi, “Paꞌ-iyoꞌ hini Templon Apo Jos muti un umuy chi toloh arkhaw hot ehaꞌ-ad u khu.” ");
INSERT INTO ifu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hotti timmaꞌchug chin Natakhay an Pachi ja inali na ay Hesus hi, “Anagkha ta achi a tompfar? Ngay pampfar mu hay hato epapfahor cha ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Muti khemmegkhenong hi Hesus. Ja inalin khu chin natakhay an pachi hi, “Alloꞌ ay he-a hi mahapor an ipudnum khapo ay tay mamattakhu an Jos nu he-a chah hini Mamahhod an Empfalay Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tempfar Hesus ja inali na hi, “Ti niya mah an he-a chi nangali. Ja hay alloꞌ khu ay chaꞌju ja umali han arkhaw an panikhan ju ay ha-in an Na-ilangitan an Takhu an mi-i-ibpfun ay ni nun-appit hi agwan Apo Jos an gway apfalinana. Ja tikhanaꞌ khu hi pumpfangngachaꞌ an marpu ad uchu an midchum hi pfonot.” ");
INSERT INTO ifu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Amat hichi ja hinaꞌ-in chin natakhay an pachi chin lopfong na khapo hi pfungot na. Ja inali na hachi tatakhu hi, “Tayya an chengngor ta-o hitay inali na an ipadchung na hitay achor na ay Apo Jos. Hotti un chah khahin khu un gway muntihtikhu? ");
INSERT INTO ifu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngay allon ju tugwali?” Ja hi-a-ali cha hi, “Un ta-o gwot epapatoy, ti otong chi pfahor na!” ");
INSERT INTO ifu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ja tinuppaan cha chin angah na ja hinuntuk cha, ja henoplat chin uchumna ");
INSERT INTO ifu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hon inali cha hi, “Nu profeta a, he-a an Kristo, ja pfugwaom adchiya nu ngachah nuy nanuntuk ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ay chuy an ni-i-ibpfunan Peter chin partug chuy pfalay ja immuy han pfalahang an takhala ay hija ja inali na hi, “Oha a jaꞌ an khun mitnud ay Hesus an eGalilee.” ");
INSERT INTO ifu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Enhaot Peter ja inali na hay hachi gwah chi hi, “Pfu-un mangkay! Ma-id anilaꞌ ay nuy allom.” ");
INSERT INTO ifu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Immuy hichi pingngit chin partug ja tinnig han oha khu an pfalahang an takhala. Ja inali na hachi niꞌtataꞌchug hi, “Hitay an lala-e, ja hija chi oha an khun mitnud ay Hesus an eNazaret.” ");
INSERT INTO ifu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ja hen-enhaot khu Peter an inali na hi, “Anilan Apo Jos an umannung an agkhuy u anila hinuy an takhu.” ");
INSERT INTO ifu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Unot achi mapfajag ja immuy hachi niꞌtataꞌchug ta inali cha ay Peter hi, “Umannung an nidchum a ay chicha, ti omod hinuy atom an munhapit an hapit chi eGalilee.” ");
INSERT INTO ifu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ja hen-enhaot Peter an inali na hi, “Pfu-un numpay! Anong ja dusaonaꞌ ay Apo Jos hi un lahlah hitay alloꞌ, ti agkhuy u anila hinuy an takhu an khun ju hapiton.” Ja timmalanu gwot chin agwitan. ");
INSERT INTO ifu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ja nenomnom Peter chin inalin Hesus ay hija an, “Ehaotaꞌ hi mumpitlo ad ugwani an lapfi ja unot tumalanu.” Pfimmutay hi Peter ja achi anhan chin kila na khapo hi tutuju na. ");
INSERT INTO ifu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Unot gwa an nagwa-ah ja na-amung chin a-ap-apon chi papachi ja chin uchumna an a-ap-apon chi Hudju ta nunhahapit cha hay i cha aton an mamatoy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Napfalin ja pinawwid cha chin ngamoy na ja in-uy cha ay chuy Gobernador an hi Pilato ta mahumarja. ");
INSERT INTO ifu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hi ayya Judas an nangngina ay Hesus, unaot inannila an hugijon cha hi Hesus ta matoy, ja nuntutuju chin enat na. Enala na chin tolompolo an pelaꞌ an inchat hachi a-ap-apon chi papachi ja hachi uchumna an ap-apo, ja immuy ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ja inali na hi, “Pfimmaholaꞌ ti ingnginaꞌ han takhu an ma-id pfahor na ja tan patajon cha hija.” Ja inali cha hi, “He-aot ti un chah gway anila mi?” ");
INSERT INTO ifu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hotti impuchit Judas chin pelaꞌ hichi Templo ja nakak. Immuy numpfeꞌkhor ja natoy. ");
INSERT INTO ifu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nun-alan hachi a-ap-apon chi papachi chin pelaꞌ ja inali cha hi, “Achi ay chita mapfalin ay ni urchin ta-o an i ta-o idchum hitay ay ni pihun ni Templo, ti hijay palit chi ohan takhu. Hot ngay pang-atan ta-o?” ");
INSERT INTO ifu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hay nunhahappitanan cha ja pomlaꞌ cha han lotan chin khun munchugwin hi pfanga ta gway panglub-an cha hu-un gway matoy hi mangili cha. ");
INSERT INTO ifu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hijaot un cha nginadnan hichuy lota hi Lota an Negwaꞌgwa-an hi Chala, ja hijay ngachana ingkhana ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hotti nipa-annung chin inalin Jeremiah an profetan Apo Jos hi nangarjana hi, “Enala cha chin tolompolo an pelaꞌ an nunhahappitanan cha chuy Hudju an holag Israel hi palit na. ");
INSERT INTO ifu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ja inchat cha an pfajad han lotan nuy khun munchugwin hi pfanga, ti hijah tay chi inalin Apo Jos ay ha-in hi ma-at.” ");
INSERT INTO ifu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Timmataꞌchug hi Hesus hi gwachaan gobernador Pilato ja inalin Pilato ay hija hi, “Un chah he-a hini Arin chi Hudju?” Tempfar Hesus ja inali na hi, “Ti niya mah an inalim.” ");
INSERT INTO ifu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Muti agkhuy henongpfatan Hesus hachi cho-or an empapfahor hachi a-ap-apon chi papachi ja hachi uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ja inalin Pilato ay hija hi, “Un chah achim chonglon hay hato cho-or an epapfahor cha ta achim topfalon?” ");
INSERT INTO ifu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Muti agkhuy tenomtompfar hi Hesus, ja nanor hi Pilato. ");
INSERT INTO ifu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hay khun aton gobernador Pilato hi un Pfehtan Chin Nalohan Chin Angher Apo Jos, ja emmengha ay hija an khun mangpfu-aan hi oha hi nipfalud an piliyon hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ja netongor ay chuy an timpo ja gwa han nipfalud an hi Barabas chi ngachana, ja nunchongor hachi nun-apupukhit an enat na. ");
INSERT INTO ifu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gwa an na-amung hachi atakhutakhu ja inalin Pilato ay chicha hi, “Ngachan nuy penhod ju hi ipfu-aaꞌ hi pfalud ad ugwani an pfehta? Hi Barabas wenno hi Hesus an ma-ali hi Kristo?” ");
INSERT INTO ifu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Inali na hitay ti anila na an hachi a-ap-apo chi nang-agwat ay Hesus khapo hi ámoh cha, ja podhona khu an chonglon nu ngay piꞌ-alin hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hay oha khu hi pamhochan Pilato an mangpfu-aan ay Hesus ja ay chuy inu-umpfunana ay chuy umpfunan chi munhugwi, ja gwa han empaad cha an inalin ni ahagwa na an, “Achi a manger-er hi im aton ay nuy an takhu an ma-id pfahor na, ti enenop u ad a-ukhab, ja atattata-ot ja tan unaꞌ omelo-elob.” ");
INSERT INTO ifu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Muti hay hachi a-ap-apon chi papachi ja hachi uchumna an a-ap-apo ja enchokhochokhor cha hachi tatakhu ta allon chay Barabas chi mipfu-aan, ja matoy koma hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hotti chin piggwana hi nangarjan Pilato hi, “Hot ngachan ni penhod ju hi mipfu-aan ay cha tay an chugwa?” ja inali cha gwot hi, “Hi Barabas!” ");
INSERT INTO ifu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ja inalin khu Pilato hi, “Nu amat hina ayya ja ngay allon ju hi atoꞌ ay tay an hi Hesus an ma-ali hi Kristo?” Ja hi-a-ali cha hi, “Epepfakhat mu hi kros!” ");
INSERT INTO ifu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ja inali na khu hi, “Anagkha? Ngay tugwali pfahor na?” Muti en-ar-alla cha an nangiꞌgwap hi, “Epepfakhat mu!” ");
INSERT INTO ifu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Amat hichi ja tinikhaw Pilato an achi ma-arjan hachi tatakhu ja gwa an munhohongnger cha. Hotti empa-ala na han pfatja an nittugwan hi chanum ja numpfulu ta tikhan hachi atakhutakhu. Ja inali na hi, “Tayya an pfinulugwaꞌ hay hato ngamoy u ta panginnilaan ju an agkhujaꞌ neꞌ-ampoy ay chaꞌju ay tay i ju pamatajan ay tay an takhu. Hotti nangamong aju!” ");
INSERT INTO ifu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ja inalin hachi tatakhu hi, “Aa, nangamong ami. Epapatoy mu ja anong kay ja chaꞌmi ja hana holag mi chi ipuypujan chi pfahor.” ");
INSERT INTO ifu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hotti na-arjan hi Pilato ja impfu-aana hi Barabas, muti hi Hesus ja impahuplit na ja impulang na hachi hinchalo na ta i cha epfakhat hi kros. ");
INSERT INTO ifu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Initnud hachi hinchalo hi Hesus an inhikhop chin pfalay chi gobernador, ja inamung cha an amin chin nun-ibpfa cha an hinchalo. ");
INSERT INTO ifu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Enaan cha chin lopfong na ja linupfungan cha han lopfong an mumpfolah an amat hi lopfong chi ari. ");
INSERT INTO ifu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ja pfenalengawngaw cha han pagwit ja impihuꞌlub cha ay chuy ulun Hesus an amat hi korona. Ja enala cha han lunu ja empachon cha chin agwan an ngamoy na an amat hi hinjar chi ari. Nunheppe cha ay hija hon tenangkhatangkhaan cha hi khun cha pangarjan hi, “Madaydayaw a, he-a an Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hon tinuppaan cha ja enala cha khu chin lunu ja impakhuh cha ay chuy ulu na. ");
INSERT INTO ifu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Himmikha cha an nangekejan ay hija ja enaan cha chin impilopfong cha an mumpfolah ja empallog cha chin lopfong na. Ja initnud cha an i epfakhat hi kros. ");
INSERT INTO ifu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hi khun cha omajan ja chinittum cha han hi Simon an eCyrene. Impapilit hachi hinchalo an pi-ukhona chin kros Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ja emmatam cha ay chuy pfulludna an nangadnan hi Golgota, an hay podhona an allon ja pfulludna an amat hi ulun chi paang. ");
INSERT INTO ifu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ja allon chaot ta ipa-inum cha ay Hesus han pfajah an nidchuman hi mumpa-it ta poh-onay chokhoh hi pangpfakhatan cha ay hija. Muti unaagkhu tenamtaman ja achi na penhod hotti agkhuy na ininum. ");
INSERT INTO ifu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Amat hichi ja empfakhat cha. Ja numpfepfeleng hachi hinchalo ta machotoꞌ hay mumpangala hachi lopfong Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ja inumpfun cha an khun mumpfantay. ");
INSERT INTO ifu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ja gwa han neꞌpfakhat cha ay chuy uhun chin ulu na an natutula-an ay ni chiklamu cha ay hija, an hay nitulaꞌ ja, “Hitay hi Hesus an Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ja gwacha khu han chugwa an lala-e an napfahulan an neꞌchehhan an nepfakhat, hotti nun-appiton cha hi agwan Hesus chin oha, ja nun-appit hi ikhid chin oha. ");
INSERT INTO ifu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gwa hachi tatakhu an naloh ja munggwiggwikhigwig cha hon pinahiw cha hi Hesus ");
INSERT INTO ifu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","an inali cha hi, “Un mangkay tugwali he-a hini nangali hi paꞌ-iyom hini Templo muti un umuy hi toloh arkhaw ja ehaꞌ-ad mu khu! Hot chaadma mah hini apfalinam ta takhuwom hinuy achor mu? Nu umannung an he-a hini Empfalay Apo Jos, ja mun-opah a ay nuy kros!” ");
INSERT INTO ifu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amat khu hina an tenangkhatangkhaan chin a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses ja hachi uchumna an a-ap-apon chi Hudju, an khun cha allon hi, ");
INSERT INTO ifu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tinakhu na hana uchumna an tatakhu muti ma-id olog na an manakhu ay chuy achor na. Hija anu hini Ari ta-o an holag Israel, hotti mun-opah koma ay chuy kros hot mamati ta-o ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mamati hija anu ay Apo Jos ja allona an hija hini Empfalay Apo Jos, hotti hi Apo Jos chi manakhu ay hija nu penhod na.” ");
INSERT INTO ifu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Anong un chin chugwa an neꞌpfapfakhat ja khun cha piꞌpahiw hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Unagkhu gwa an nahaꞌ-ad ja himpfumagkha ja hemmelong an amin ay chuy an lota ingkhana hichin napujaw. ");
INSERT INTO ifu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja chin napujaw ja unagkhu la-ahna ja nun-ugwap hi Hesus an nangali hi, “Eli, Eli, lama sabachtani?” an hay podhona an hapiton ja, “Jos u, Jos u, anagkha ta tene-a-anaꞌ ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chengngor hachi uchumna an niꞌtataꞌchug hichuy an iniꞌgwap na ja inali cha hi, “Niya an khuna ajakhan hi Elijah an manakhu ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chin oha ja temmagtag an i emmala han omaꞌ-at hi apoh ja entamor na han pfimmanger an pfajah, ja empa-aw na han paor. Immuy ay chuy kros ja intumuꞌ na chin ta-on Hesus ta inumona. ");
INSERT INTO ifu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Muti inalin hachi uchumna hi, “Khenong adchiya tugwali ta tikhan ta-o hu-un umali hi Elijah an manakhu ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ja impiggwan Hesus an nun-ugwap ja na-ongoh chin hochohcha na. ");
INSERT INTO ifu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja hichi Templo ad Jerusalem ja himpfumagkha ja na-ittang chin ma-uꞌtor an kurtina an nanahhalin ay chuy Na-assantuwan an Kwarto, nete-a chin uhuna ja chimmapoh chin puuna. Ja nungkhihu, ja naphar hachi o-otong an pfato. ");
INSERT INTO ifu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ja nipfughor hachi lupfuꞌ ja timmakhu hachi cho-or an nun-a-atoy an tatakhun Apo Jos, ");
INSERT INTO ifu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ja pfimmutay cha ay ni lupfuꞌ cha. Nalahin chin nummahuwan Hesus ja immuy hato an namahuwan an tatakhu ad Jerusalem an Siudad Apo Jos, ja cho-or hachi nanikhaw ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chin kapitan chi hinchalo ja chin numpun-ibpfa na an khun mumpfantay ay Hesus ja naleꞌna cha chin khihu ja tinnig cha hachi na-at, ja nang-entata-ot cha. Ja inali cha hi, “Umannung ay chita an Empfalay Apo Jos hitay an takhu!” ");
INSERT INTO ifu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ja gwah chi chin cho-or an pfinapfai an nenebtaw an nannig chin natajan Hesus. Chicha hana ninitnud ay Hesus nete-a chin agawwachaana ad Galilee an khun tomolong ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ja nidchum cha Mary Magdalen, ja hi Mary an ammod cha James ay Josep, ja hini ahagwan Zebedee. ");
INSERT INTO ifu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Unot gwa an mahilip, ja emmatam han achangjan an lala-e an e-Arimatea, an hi Josep chi ngachana. Oha hija an disipolon Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Immuy ay Pilato an i nangippug ta i na ilupfuꞌ chin achor Hesus. Inapfulut Pilato ja inali na ta opahon cha chin achor Hesus ja inchat cha ay Josep. ");
INSERT INTO ifu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Enalan Josep ja pinuttiputana han pfinacha an maphod ja maleneh. ");
INSERT INTO ifu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ja in-uy Josep chin achor Hesus ay chuy paꞌ-ephod cha an linijangan cha an pfato an hijay ilub-ana hu-un matoy. Ja impahikhup na chin achor Hesus ja inulina han otong an pfato an tanglib chin lupfuꞌ ja unot makak. ");
INSERT INTO ifu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ja gwah chi khu cha Mary Magdalen ja chin oha an Mary an inu-umpfun cha an homahhakhang ay chuy lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hichuy an arkhaw ja Alemana an Punhakhanaan hachi Hudju ay ni Hapfachu an khun cha ngilinon. Ja chin nun-ingwiꞌgwiit an ngilin ja immuy hachi a-ap-apon chi papachi ja hachi Farisee ay Pilato ");
INSERT INTO ifu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ja inali cha hi, “Apo Gobernador, nenomnom mi an chin atattakhun nuy munlahlah an hi Hesus, ja inali na hi mummahu hija ay ni me-atloh arkhaw hi natajana. ");
INSERT INTO ifu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hotti un chah achi mapfalin an gway im pumpfantajon ay nuy lupfuꞌ na ingkhanah chin me-atloh arkhaw ay ni natajana? Ti khemhon ja gway umuy hana disipolo na an i manglajaw ay nuy achor na ta gway aton cha an mamarpfalijan hato tatakhu an allon chay nummahu hija. Hot pa-am-amchon cha chin lahlah na.” ");
INSERT INTO ifu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ja inalin Pilato hi, “Aa, ajakhan ju hana hinchalo ta ep-ephod ju an pfantajan hinuy lupfuꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hotti immuy cha hichi lupfuꞌ ja linita cha hi maphod chin tanglib ta matikhaw nu gway mangpfughor, ja empapfantay cha hachi hinchalo. ");
INSERT INTO ifu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Unot nun-inggwiꞌgwiit an Markhachu an nalahin chin ngilin, ja pfimmugwah cha Mary Magdalen ay Mary an chin nun-ibpfa na an immuy hichi lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Himpfumagkha ja gwa han mapfi-ah an khihu ti nun-opah han angher Apo Jos an narpu ad langit, ja inulina chin pfato an tanglib ja inumpfunana. ");
INSERT INTO ifu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mumpfinang hichuy angher an amat hi ilat, ja munnaud chin pinuchaw chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nang-entata-ot hachi gwarja ja khun cha munggwoggwog, ja nun-achapor cha an amat cha hi natoy. ");
INSERT INTO ifu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Muti niꞌhapit chin angher hachi pfinapfai ja inali na hi, “Achi aju toma-ot. Anilaꞌ an khun ju hingiton hi Hesus an empfakhat cha chin kros. ");
INSERT INTO ifu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ma-id heto ti nummahu ti hijah tay chin inali na. Umali aju ta tikhan ju chin negwagwallangana. ");
INSERT INTO ifu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hotti khalakhalon ju an umuy ay ni gwachaan hana disipolo na ta allon ju hi, ‘Nummahu hi Hesus, ja ipangpangulu na an umuy ad Galilee ta hichi chi i ju panittuman ay hija.’ Hitay chi allon ju.” ");
INSERT INTO ifu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Temma-ot hachi pfinapfai muti mun-an-anla cha khu. Empacheh cha gwot an umuy ta i cha ipa-innila hay hachi disipolon Hesus. Mun-igwigwilit cha an umuy ");
INSERT INTO ifu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ja unagkhu himpfumagkha ja gwacha hi Hesus an i nanittum ay chicha. Ja inali na hi, “Omod aju.” Nehnot cha ja nunheppe cha ja impukhud cha chin hu-i na ja nundayaw cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ja inalin Hesus hi, “Achi aju toma-ot. Umuy aju ta i ju allon hachi disipoloꞌ an i-ibpfaꞌ ta umuy cha ad Galilee ta hichi punchichittuman mi.” ");
INSERT INTO ifu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Immuy hato pfinapfai hichi gwachaan hachi disipolon Hesus, ja gwa an nunhalemottongan hachi hinchalo an nunggwarja chin lupfuꞌ ja empacheh chin uchumna an umuy ad Jerusalem ta ipa-innila cha hay hachi a-ap-apon chi papachi hay hato naꞌna-at. ");
INSERT INTO ifu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Empapfokhan hachi a-ap-apon chi papachi hay hachi uchumna an a-ap-apon cu unhahappitanan cha nu ngay aton cha ta achi cha epfaag hini umannung an na-at. Hotti hay inali cha ja un cha pfajachan hachi hinchalo, ");
INSERT INTO ifu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ja intuchu cha hini allon cha an amat heto, “Hay allon ju hana tatakhu ja immali hachi disipolon Hesus ja inah-upan chaꞌmi an nanalloꞌ ja enlajaw cha chin achor na ay chuy an lapfi. ");
INSERT INTO ifu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hijay allon ju ja, nu khulat ta chonglon Gobernador ja allonay, ‘Anagkha ta amat hetoy na-at?’ ja nangamong ami an mangar-aloꞌ ay hija hot ma-id ma-at ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hotti enalan hachi hinchalo chin pasuksuk ja enat cha chin inalin hachi a-ap-apo. Ja ingkhana ad ugwani ja hitay chi khun allo-allon hana Hudju. ");
INSERT INTO ifu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Immuy chin himpolo ta oha an adalan Hesus ad Galilee ay chuy pfulludna an inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja un chaot tinnig hi Hesus ja dinaydayaw cha hija, muti gwacha hachi uchumna an munharhalinchugway nomnom na hi un hi Hesus hichuy numpatikhaw. ");
INSERT INTO ifu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nehnot hi Hesus ja inali ni hi, “An amin chi apfalinan hichi ad langit ja heto lota ja nichat ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hotti umuy aju hana nunleneꞌgwoh tay lota ta itudtuchugwan ju an amin chi tatakhu ta miꞌ-unud cha ay ha-in. Bautisaran ju chicha ay ni ngachan Jos Ama ja ha-in an Empfalay na ja hini Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ja an amin chin in-urchin u aychaꞌju hi unuchon ju, ja ituchu ju khu hana tatakhuta peꞌ-at cha. Nomnomon ju an mimidchumaꞌ ay chaꞌju hi a-arkha-arkhaw ja ingkhanah chin apogpokhan tay lota.”");
INSERT INTO ifu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hitay itulaꞌ u ja hitay Ebanghelyo an manapit ay ni omaꞌ-atan Hesu Kristo an Empfalay Apo Jos. Hay nete-aana ja ");
INSERT INTO ifu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","chin inalin Apo Jos an impatulaꞌ na ay profeta Isaiah hi nangarjana hi, “Tayya an honakhoꞌ hay mangpangpangullu an manghakhana ay ni agwum. ");
INSERT INTO ifu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Gwa han khun mun-ugwap hichi let-ang an khuna allon hachi tatakhu hi, ‘Epaphod ju hini agwun ni umali an Apo. Anchongon ju hana nakillokillo an chalan ta maphod hi agwuna.’ ” ");
INSERT INTO ifu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ja emmat, ti tinnig cha hi John Bautista hichi let-ang ja tinudtuchugwana hachi i nunchongor. Ja hay engkasaba na ja, “Muntutuju aju ja chin-ug ju hana pfahor ju ja mumpabautisar aju ta pakawanon Apo Jos hana pfahor ju.” ");
INSERT INTO ifu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ja cho-ocho-or chin tatakhu an narpu ad Jerusalem ja hana apfuglapfuglay ad Judea an immuy chin agawwachaan John. Khun cha ipudnu hana pfahor cha hon numpabautisar cha ay John hichi gwanggwang an Jordan. ");
INSERT INTO ifu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Han lopfong John ja na-apfor an chutchut chi kemer, ja chin pfalekeh na ja lalat. Hay khuna ijilog ja chuchun ja chilu. ");
INSERT INTO ifu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ja khun mangaskasaba an allona hi, “Gwacha han umali an metob ay ha-in an munnaud an napfagto ja achi mapfalin an ipadchungaꞌ ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ha-in ayya ja binautisaraꞌ chaꞌju hi chanum, muti hija ja bautisaran chaꞌju hi Espiritu Santo.” ");
INSERT INTO ifu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chin khun puntudtuchugwan John ja immuy hi Hesus an narpu ad Nazaret an provincian chi Galilee, ja i numpabautisar ay John hichi Jordan. ");
INSERT INTO ifu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Unot chimma-ar hi Hesus ja tinnig na an nipfughor ad langit. Ja tinnig na chin Espiritu Santo an nun-ohop an amat hi kaloma chin tikhaw na, ja numpattoꞌ ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ja gwa han chengngor cha an hapit an narpu ad langit an nangali ay hija hi, “He-a hini podpodhoꞌ an Empfalay u. Mun-an-anlaaꞌ khapo ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Amat hichi ja enedchong ni Espiritu Santo hi Hesus an umuy hichi let-ang. ");
INSERT INTO ifu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ja nihichi hi apat chi polo hi arkhaw ja tenopngatopngan Satanas. Ja gwah chi hana atattata-ot an animar muti gwa hachi angher Apo Jos an immuy ay Hesus an nanulungan ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Napfalin an nipfalud hi John ja numpfangngad hi Hesus ad Galilee an i nangkaskasaba ay ni Ebanghelyo an narpu ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Khuna allon hi, “Tayya an nachakngan chin arkhaw an eneꞌchan Apo Jos. Achi mapfajag hot machakngan hini Pun-ap-apugwana hi tatakhu. Hotti chuꞌkhon ju hana pfahor ju ja pinati ju hitay Ebanghelyo an khun u itudtuchu.” ");
INSERT INTO ifu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gwa han namenghan ja enenggwan Hesus hichi pingngit ni Baybay ad Galilee ja tinnig na cha Simon ay Andrew an hin-akhi. Gwa an khun cha manapfukur ti tamu chay mangachiw. ");
INSERT INTO ifu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Niꞌhapit hi Hesus ja inali na hi, “Umali aju ta mitnud aju ay ha-in, ta gway honakhoꞌ an i mun-ajag hana tatakhu ta miꞌ-unud cha ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Amat hichi ja tenaynan cha hachi tapfukur cha ja nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gwa an emmoꞌ-ojay cha ja tinnig khu Hesus cha James ay John an hin-akhi an empfalay Zebedee. Inu-umpfun cha ay chuy pfalangay cha an khun cha ephod hachi tapfukur cha. ");
INSERT INTO ifu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Enajakhan Hesus cha chuy an hin-akhi ja nitnud cha khu ay hija. Hotti tenaynan cha chin ammod cha an hi Zebedee ja hachi numpun-ibpfa na an khun meꞌpfoꞌla ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Napfalin hay hato ja immuy cha Hesus ad Kapernaum. Unot nachakngan chin Hapfachu an ngilin chi Hudju, ja immuy cha hichi sinagoga ja ente-an Hesus an muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ja nanor hachi tatakhu chin panudtuchu na, ti matikhaw cha an gway apfalinana, an achi amat hachi memehtolon chi urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ay chuy gwot ja gwa han lala-e ay chuy sinagoga an nahuhuꞌlungan hi napukhit an ispiritu. Ja nungkii ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hesus an eNazaret! Ngachah chi atom ay chaꞌmi? Un a chah immali an mangdusa ay chaꞌmi? Anilaꞌ he-a, an he-a hini nasantuwan an Empfalay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ja himmingar hi Hesus ja inali na ay chuy napukhit an ispiritu hi, “Khomegkhenong a, ja makak aot!” ");
INSERT INTO ifu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Unot inalin Hesus hitay ja nun-egwakhot chin napukhit an ispiritu hichuy lala-e an nihuhuꞌlungana ja iniꞌgwap na an nungkii ja nakak. ");
INSERT INTO ifu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nanor cha an amin ja khun cha munhahapit an khun cha allon hi, “Ngay ngachah tay nabnab-on an panudtuchu? Anong un hana nehohoꞌlong an napukhit an ispiritu ja gway apfalinana an mummanjar ay chicha hon inunud cha hini allona.” ");
INSERT INTO ifu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ja nunchongor hi apfuglapfuglay hichi ad Galilee hana ena-enat Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nakak cha Hesus chin sinagoga ja empacheh cha an umuy hi pfalay cha Simon ja hi Andrew, ja nitnud cha James ay John. ");
INSERT INTO ifu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gwah chi chin pfupfai an ammod chin ahagwan Simon an numpepekheng, ti mapfi-ah han potang na. Unot ne-atam cha Hesus ja impa-innila cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Immuy hi Hesus ay chuy munchokhoh ja pfenohgwat na. Na-aan gwot chin potang na ja enhakhanaana cha Hesus hi anun cha. ");
INSERT INTO ifu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gwa an na-uynu hichin hukhit ja in-uy cha ay Hesus hachi mumpunchokhoh ja hachi nun-ahuꞌlungan hi napukhit an ispiritu. ");
INSERT INTO ifu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","An amin chi tatakhu ay chuy an pfuglay ja na-amung cha hi pfalay cha Simon. ");
INSERT INTO ifu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ja empatenong Hesus hachi numpfino-ob-on an chokhoh hachi cho-or an tatakhu. Nun-epakak na khu chin cho-or an nun-apukhit an ispiritu. Ja agkhuy na nunhapiton hay hachi napukhit an ispiritu, ti anila cha an hija hini Hennag Apo Jos an Mamahhod muti achi na podhon an chichay mangpfaag. ");
INSERT INTO ifu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chin nun-inggwiꞌgwiit hi herhelong ja pfimmangon hi Hesus ja nakak ay chuy an pfalay ta immuy han lukhar an ma-id takhu ta i mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Unot pfimmangon cha Simon ja hachi numpun-ibpfa na ja i cha hiningit hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Un chaagkhu chinakngan ja inali cha hi, “An amin hana tatakhu ja khun chi-a i hingiton.” ");
INSERT INTO ifu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ja inalin Hesus hi, “Umuy ta-o chamchama hana uchumna an nun-ehnot an pfuglay ta gway atoꞌ an mungkasaba khu ay chicha. Ti hijah tay hini immaliyaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Amat hichi ja immuy hi Hesus hana apfuglapfuglay ad Galilee ja khun mangaskasaba hachi sinagoga cha. Ja nun-epakak na hachi napukhit an ispiritu an nun-ehoꞌlong ay cha chuy uchumna an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gwa han namenghan an immuy han lala-e an na-unit ay Hesus. Nunheppe ja numpakpaka-ahi an nangali hi, “Apo, otong hini apfalinam hotti podhom ayya ja epatenongaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ninignikhan Hesus hitay an na-unit ja hen-a na, ja inali na hi, “Podhoꞌ. Hotti tomenong a.” ");
INSERT INTO ifu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ja emmat an na-aan gwot chin unit na. ");
INSERT INTO ifu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ja naꞌnaꞌ-allon Hesus ay hija hi, “Achi la-ahna ja gway im pangar-arjan ay tay an na-at ay he-a. Hay atom ja umuy a ay ni pachi ta i a mumpatikhaw an temmenong a. Ja ipidaton mu ay hija hini allon ni urchin Moses an khun idaton ay Apo Jos an panginnilaan an umannung an na-aan hini unit mu.” ");
INSERT INTO ifu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Muti hichuy lala-e an temmenong ja agkhuy na inunud chin inalin Hesus. Immuy ja khuna hapihapiton chin na-at ay hija. Nunchongor hichuy an enat Hesus hotti ma-id atona an umuy hachi pfuglay an achoꞌlan chi tatakhu, ti tinnig cha ayya hon hemmajomhom cha ay hija. Hotti un khun umuy hachi lukhar an ma-id nunheto, muti cho-or chamchama hachi tatakhu an khun umuy ay hija an narpu hi apfuglapfuglay. ");
INSERT INTO ifu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nalahin chi at hichi hi arkhaw ja numpfangngad hi Hesus ad Kapernaum, ja inannilan hachi tatakhu an immuy hija ay chuy pfalay an khuna chumakngan. ");
INSERT INTO ifu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Achi omopoh hachi tatakhu an umuy ay chuy agwachaana ingkhanah napnu cha anong un chin negpongan chin pantaw, ja khun cha munhihiꞌ-ig. Gwa an khun mangaskasaba hi Hesus ");
INSERT INTO ifu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ja in-ali cha han napechoy an impfapfalahhong han apat an linala-e. ");
INSERT INTO ifu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Muti khapo ta cho-or hachi tatakhu ja ma-id enat cha an i mangehnot ay Hesus. Hotti in-uy cha chin atop chin pfalay ja khinutapfan cha chin negpong ay chuy gwachaan Hesus. Napfalin ja inujuy cha chin napechoy. ");
INSERT INTO ifu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Unagkhu tinnig Hesus hitay otongngan an pammati cha ja inali na ay chuy napechoy hi, “Akhiꞌ, napakawan hana pfahor mu.” ");
INSERT INTO ifu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ja gwa hichi hana uchumna an memehtolon chi urchin Moses an ni-i-ibpfun ja khun cha nomnomnomon hi, ");
INSERT INTO ifu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anagkha agkhu niꞌ hitay an takhu an ipadchung na hichuy achor na ay Apo Jos, an allona hi un pomakawan hi pfahor. Ti un chah gway uchumna hi mamakawan hi pfahor an un hi Apo Jos ja angkhay.” ");
INSERT INTO ifu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Anilan Hesus hini gwa ay ni nomnom cha ja inali na ay chicha hi, “Anagkha ta amat hina hini nomnom ju? ");
INSERT INTO ifu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma-id olog chi takhu an mamakawan hi pfahor ja ma-id khu olog cha an mangpatenong hi chokhoh. ");
INSERT INTO ifu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Muti ay ha-in an Na-ilangitan an Takhu ja epatenong u hitay an napechoy ta panginnilaan ju an gwacha khu chi apfalinaꞌ heto lota an mamakawan hi pfahor.” Ja inali na chin napechoy hi, ");
INSERT INTO ifu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Alloꞌ ay he-a hi pfumangon a, ipi-ug mu hinuy pfalahhong mu ja immanamut a.” ");
INSERT INTO ifu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ja tinnig hachi tatakhu an natantannaꞌchug chin napechoy, impi-ug na chin nipfalahhungana ja empacheh na an umanamut. Nanor an amin hachi tatakhu ja khun cha mundaydayaw ay Apo Jos ja khun cha allon hi, “Anagkha ay chita an nabnab-on hitay tinnig ta-o ad ugwani an arkhaw.” ");
INSERT INTO ifu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nakak hi Hesus ad Kapernaum ja immuy khu ay chuy pingngit chi baybay ad Galilee. Na-amung hachi tatakhu ja ente-a na an tuchugwan chicha. ");
INSERT INTO ifu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Napfalin ja empacheh na ja unagkhu gwa an khun chumalan ja tinnig na han khun munhenger hi pakha an hay ngachana ja hi Levi an empfalay Alfeus, an inu-umpfun chin opihhina na. Ja inalin Hesus ay hija hi, “Umali a ta mitnud a ay ha-in.” Amat hichi ja nitnud hi Levi ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ja gwa han namenghan an i nangan hi Hesus ja hachi disipolo na hichi pfalay Levi. Ja neꞌ-orpfong hachi cho-or an khun munhenger hi pakha ja hachi uchumna an allon cha an napfahulan an tatakhu an khun umalipfuypfuy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hachi Farisee an khun muntudtuchu ay ni urchin Moses ja tinnig cha an neꞌ-orpfong cha Hesus hachi mapahiw an tatakhu ja inali cha hachi disipolo na hi, “Anagkha mah hitay Apo ju ta meꞌ-orpfong hay hachi khun munhenger hi pakha ja hachi uchumna an nun-apfahulan?” ");
INSERT INTO ifu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Unot chengngor Hesus hitay inali cha ja tempfar na ja inali na ay chicha hi, “Hana gway chokhoh na chi munhapor hi choktor an pfu-un hana ma-id chokhoh na. Immalijaꞌ an tomolong hana napfahulan ta chuꞌkhon cha hana pfahor cha an pfu-un hana mangali hi ma-id pfahor cha.” ");
INSERT INTO ifu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gwa han namenghan an khun mun-ayunar hachi disipolon John Bautista ja amat khu hachi Farisee. Immuy hachi uchumna an tatakhu ay Hesus ja inali cha hi, “Tinnig mi an khun mun-ayunar hachi disipolon John Bautista ja amat hina khu hana disipolon hachi Farisee. Hotti anagkha ta hato disipolom ja achi cha miꞌ-ayunar?” ");
INSERT INTO ifu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tempfar Hesus ja inali na hi, “Nu khulat ta gway mungkasar ja un ju chah allon hi achi mangan hay hana i na-ila nu gawwacha pay hini mungkasar? Achi mit mapfalin. ");
INSERT INTO ifu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Muti umali han arkhaw an ekak cha hini lala-e an nungkasar ja hijay pun-ayunalan cha. Hotti gawwachaaꞌ ayya ja achi pay mun-ayunar hato disipoloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ja nun-arig hi Hesus ja inali na hi, “Ma-id manger-ob hi pfakhu an pfinacha ay ni nachochonot an lopfong. Ti nu amat hetoy atona hot mun-ohon hini pfakhu an ner-ob ja inatona hini nachochonot hot omom-omod an mapfingit. ");
INSERT INTO ifu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma-id khu mangitto ay ni paꞌ-arpoh an chanum chi ubas ay ni na-usar an lalat an khun pangittugwan hi ma-inum. Ti nu amat hetoy atona hot mapfughi hini lalat, ja metapar hini chanum chi ubas ja mapaꞌ-i khu hini lalat. Hini ayya paꞌ-arpoh an chanum chi ubas ja mitto ay ni pfakhu an lalat ta mehaꞌpfa.” ");
INSERT INTO ifu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gwa han ohan Hapfachu an ngilin chi Hudju an nanggwaan cha Hesus han natamman hi trigo. Pfimmangkhi hachi disipolo na chin trigo ja inutim cha ta anun cha. ");
INSERT INTO ifu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gwacha hachi Farisee an nannig ja inali chaot ay Hesus hi, “Tikham akay niꞌ hay hato disipolom an khun cha mun-utim. Ja un chah pfu-un tamu chi mun-utim an paꞌ-iyona hini urchin ta-o, an paniyaw chi muntamu ti ngilin?” ");
INSERT INTO ifu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tempfar Hesus ja inali na hi, “Un ju chah agkhuy pfinaha chin enat chin apo ta-o an hi Ari David ja chin numpun-ibpfa na hi i cha hemmenaangan? ");
INSERT INTO ifu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chin nehaachan Abiatar an Natakhay an Pachi ja himmikhop hi David chin pfalay Apo Jos ja enala na chin tenapay an netpfar ay Apo Jos, ja inana ja inchatana khu chin numpun-ibpfa na. Ja paniyaw chi mangan ay ni netpfar an tenapay, ti hana papachi chi mangan ja angkhay. Ja ma-id inalin Apo Jos hi un pfahor hitay enat cha.” ");
INSERT INTO ifu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja en-ang-angonoh Hesus an nangali hi, “Agkhuy enephod Apo Jos hana tatakhu ta ngilinon cha hini Hapfachu. Hini nangephochan Apo Jos ay ni Hapfachu an ngilin ja ta aphochan chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hotti ha-in an Na-ilangitan an Takhu chi mangali nu ngay paniyaw ay ni arkhaw chi ngilin.” ");
INSERT INTO ifu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gwa khu han ohan arkhaw an ngilin ja immuy hi Hesus hichi sinagoga ja gwa hichi han lala-e an napechoy chi oha an ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ja henehemmonot hachi na-amung hi un epatenong Hesus hichuy lala-e ay chuy an arkhaw chi ngilin ta gway ipapfahor cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ja inalin gwot Hesus ay chuy napechoy chi ngamoy na hi, “Umali a heto.” Ja immuy. ");
INSERT INTO ifu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ja inalin Hesus hachi tatakhu hi, “Allon ju adchiya tugwali nu ngay allon ni urchin Moses hi aton ta-o hi un ngilin. Tomolong ta-o chah hi takhu wenno mun-ephod ta-o hi napukhit? Inali na chah hi takhuwon ta-o hini ohan takhu wenno patajon ta-o?” Muti khemmegkhenong cha. ");
INSERT INTO ifu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Intikhaw Hesus hachi atakhutakhu ja pfimmungot, ti napukhit chi punnomnomana hachi pfimmatoy nomnom na. Ja inalin Hesus chin lala-e hi, “Uꞌjachom hini ngamoy mu.” Unaot inuꞌjad ja numpfangngad mahpay an mechon chin ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Amat hichi ja nakak hachi Farisee hichi sinagoga ja i cha niꞌ-amung hay hachi allon cha an Herodianes ta i cha punhahappitanan hay aton an mamatoy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nakak hi Hesus ja hachi disipolo na ay chuy an pfuglay ja immuy cha hichi pingngit chi baybay. Ja cho-or hachi eGalilee an nitnud ay chicha. Ja cho-or khu hachi narpu ad Judea, ");
INSERT INTO ifu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ja ad Jerusalem, ja ad Idumea, ja ay chuy chammang chi gwanggwang an Jordan. Ja gwa hana narpu ad Tiro ja ad Sidon ja ay chuy nunleneꞌgwoh an apfuglapfuglay. Immuy cha ay Hesus ti chengngor cha hana natnat-on an khuna aton. ");
INSERT INTO ifu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cho-or hachi tatakhu hotti inalin Hesus hachi disipolo na ta i cha tikhan hay pfalangay hi punlukhanana ta pfumpfumtaw ta achi mahajomhoman. ");
INSERT INTO ifu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ti lini-ub hachi cho-or an tatakhu hi Hesus, ja anong un hachi mumpunchokhoh ja munhihiꞌ-ig cha an i mehnot ta gway aton cha an man-a ay hija ta tomenong cha. ");
INSERT INTO ifu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tinnig ayya hachi tatakhu an nun-ahuꞌlungan hi napukhit an ispiritu hi Hesus hon nunheppe cha hon nungkii cha an nangali hi, “He-a hini Empfalay Apo Jos!” ");
INSERT INTO ifu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ja inhingar Hesus chicha ta ma-id i cha pangar-allan ay ni nitakhuwana. ");
INSERT INTO ifu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Napfalin hay hato ja inti-id Hesus han pfulludna, ja enajakhana hachi penhod na an itnud. Ja un chaagkhu na-amung ja ");
INSERT INTO ifu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","pinilin Hesus han himpolo ta chugwa an ngenadnana hi apostol ta mimidchum cha ay hija ta gway honakhona an i mangaskasaba. ");
INSERT INTO ifu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ja ichatana chicha hi apfalinan an mangpakak hi napukhit an ispiritu an khun mehoꞌlong. ");
INSERT INTO ifu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hay hato chi pinili na, an hi Simon an ngenadnana hi Peter, ");
INSERT INTO ifu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ja cha James ay John an empfapfalay Zebedee an ngenadnan Hesus hi Boanerges, an hay podhona an hapiton ja amat hi ichor, ");
INSERT INTO ifu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ja hi Andrew, ja hi Philip, ja hi Bartolomew, ja hi Matthew, ja hi Tomas, ja hi James an empfalay Alfeus, ja hi Tadeus, ja hi Simon an oha an Zealot, ");
INSERT INTO ifu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja hi Judas Iskariot an hijay mangngina ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Amat hichi ja immanamut cha Hesus. Ja na-amung gwot hachi tatakhu hotti ma-id chi hay aton cha Hesus an mangan. ");
INSERT INTO ifu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Unagkhu inannilan chin a-akhin Hesus hachi naꞌna-at ja empacheh cha ta i cha ekak ay chuy nunnanangngana. Ti chengngor cha chin khun allon hachi tatakhu hi un emmangaw hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ja inalin hachi memehtolon chi urchin Moses an narpu ad Jerusalem hi, “Nahuhuꞌlungan mangkay hitay an hi Hesus ay Beelzebub an hini ap-apon chi nun-apukhit an ispiritu, ja un kaykhu hi Beelzebub hini nangchat ay hija ay ni apfalinana an khun mangpakak hi napukhit an ispiritu.” ");
INSERT INTO ifu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hotti enajakhan Hesus chicha ja inali na hitay an pangngarig, “Nomnomon ju adchiya. Un chah hi Satanas hon empakak na hini achor na? ");
INSERT INTO ifu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nu khulat ta hana tatakhu ay ni oha an himpangili ja ma-a-aggwa cha ta un chicha khu hon numpapattoy cha, hot un loꞌtatna hot mapaꞌ-i hinuy an himpangili. ");
INSERT INTO ifu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Amat hina khu nu itannong hana hen-a-amma hon numpapattoy cha, hot loꞌtatna hot munhihijan cha. ");
INSERT INTO ifu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Omaꞌ-at hina khu nu hi Satanas hon neꞌpatoy khu hay hana in-inupfor na. Ja khulat ta amat heto chi i na aton hot ma-a-aggwa hini pun-ap-apugwana hot mapogpog. ");
INSERT INTO ifu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hi Satanas ja amat ay ni mapfi-ah an takhu an mumpfantay ay ni pfalay na. Nu khulat ta gway mamhod an mangakaw ay ni khina-u na ja ma-id olog na. Khahin un kha-utan hinuy mapfi-ah an takhu ja un ma-ala hana khina-u na. ");
INSERT INTO ifu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Umannung hitay alloꞌ ay chaꞌju, an mapakawan an amin hana pfumahulan chi tatakhu ja hana pangallan cha hi napukhit an mipfuhur hi ibpfa chah takhu. ");
INSERT INTO ifu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Muti hana munhapit hi mipfuhur ay ni Espiritu Santo ja achi cha mapakawan, ta pfahor cha ja ingkhana.” ");
INSERT INTO ifu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Inalin Hesus hitay khapo ta pinahiw cha hini Espiritu Santo an gwa ay hija hi nangarjan cha hi un hi Satanas chi nangchat ay ni apfalinana. ");
INSERT INTO ifu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Emmatam chin ammod Hesus an hi Mary ja chin a-akhi na an linala-e ay chuy agawwachaana. Timmataꞌchug cha hichi pfutayna ja empa-ajag cha hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Inu-umpfun hi Hesus an linili-ub chin cho-or an tatakhu ja inali cha ay hija hi, “Chiya an gwacha hi inam ja hana a-akhim an timmataꞌchug cha hichi pfutayna, ja khun chi-a epa-ajag ta miꞌhapit cha ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ja inalin Hesus hi, “Aa, muti un chah chicha chi ammod u ja a-akhiꞌ ja angkhay?” ");
INSERT INTO ifu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Intikhaw Hesus hachi inu-umpfun an nangakhawwong ay hija ja entoloy na an nangali hi, “Hay hato khu chi a-ammod u ja a-akhiꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ti hay hana mangat ay ni penhod Apo Jos ja chichay mipfilang hi a-akhiꞌ ja chichay a-ammod u.” ");
INSERT INTO ifu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gwa khu han namenghan ja immuy hi Hesus hichi pingngit chi baybay ja ente-a na an muntudtuchu. Munhihiꞌ-ig hachi atakhutakhu an mali-ub ay hija, hotti immuy nunlukhan han pfalangay an nebnebtaw ay chuy palantag an timmataꞌchukhan chin cho-or an tatakhu, ja inumpfun ta muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ja cho-or chin intuchun Hesus an in-ari-arig na. Ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ep-ephod ju an chonglon. Gwa han ohan takhu an immuy nunhapuwaꞌ hi pfugwa hichi hapfar na. ");
INSERT INTO ifu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Khun munhapuwaꞌ ja nepochag chin uchumna ay ni chalan, ja numpanga-ali chin hagwiti ja nun-a-an cha. ");
INSERT INTO ifu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chin uchumna ja nepochag chin mapfinato an lota. Khagkhaju cha an hemmangaw ti maymayyapit chin lota, ");
INSERT INTO ifu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","muti chin apfi-ahan chuy hukhit ja naꞌleng, ti un nitutu-i chin hemmangagwana. ");
INSERT INTO ifu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nepochag khu chin uchumna chin achoꞌlan chi holoꞌ an nun-apakhatan. Un chaagkhu hemmangaw ja emmaꞌlap hachi nun-apakhatan an holoꞌ ja hinaꞌpfungan cha chin nitanum, hotti agkhuy niꞌpfunga. ");
INSERT INTO ifu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ja chin uchumna ja nepochag chin maphod an lota, ja numpangahangaw cha ja numpangapfunga cha. Ja hachi uchumna ja pfimmunga cha hi hintotlompolo, ja hachi uchumna ja pfimmunga hi unum chi polo, ja hachi uchumna ja pfimmunga hi hingkhahot.” ");
INSERT INTO ifu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ja inalin khu Hesus hi, “Pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Unot nakak hachi cho-or an tatakhu, ja immuy hachi himpolo ta chugwa an adalan Hesus ja hachi uchumna an nitnud ay chicha ta i cha hanhanan ay Hesus hay podhon chin pangngarig an hapiton. ");
INSERT INTO ifu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ja inalin Hesus hi, “Aa, chaꞌju hana pangpa-innilaan Apo Jos ay ni omaꞌ-atan ni Pun-ap-apugwana an agkhuy na empfaag chin hophopapna. Hana ayya achi miꞌ-unud ja pangngarig hini atoꞌ an mangtuchugwan ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hot anong un himulimuli hini mata cha ja achi cha khun tikhan hana khun u aton, ja anong un nun-alu-angan hana inga cha ja achi cha chamchama ma-awatan hana khun u itudtuchu. Chuꞌkhon cha koma hana pfahor cha ta pakawanoꞌ chicha.” ");
INSERT INTO ifu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ja inalin khu Hesus ay chicha hi, “Umannung chah an agkhuy ju anila hitay an pangngarig? Ngay aton ju mah an manginnila hi uchumna? ");
INSERT INTO ifu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hitay hini podhona an hapiton. Hachi pfugwa an nihapuwaꞌ ja hija hini Hapit Apo Jos an khun mitudtuchu. ");
INSERT INTO ifu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ja hana nepochag ay ni chalan ja hija hana tatakhu an nunchongor ay ni Hapit Apo Jos muti immuy hi Satanas ta akagwona chin hapit an chengngor cha. ");
INSERT INTO ifu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ja hana ayya nepochag ay ni mapfinato an lota ja hija hana tatakhu an nun-an-anla an nunchongor ay ni Hapit Apo Jos ja inapfulut cha gwot, ");
INSERT INTO ifu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","muti un naꞌnaꞌ-omtang, ti agkhuy limmamot hini hapit na ay chicha. Unchani ta umali hana apalikhatan ja apahigwan khapo hi nangapfulutan cha ay ni Hapit Apo Jos ja chin-ug chaot hini pammati cha. ");
INSERT INTO ifu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja hana ayya nepochag ay ni achoꞌlan chi holoꞌ an napakhatan ja hija hana tatakhu an nunchongor, ");
INSERT INTO ifu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","muti immali ayya hana pundanakhan ay tay piꞌtakhuwan ja hana homalegwa an nomnom hi omachangjanan ja hana uchumna an ma-amnagwan, ja nahi-ig hini Hapit Apo Jos ja achi cha miꞌpfunga. ");
INSERT INTO ifu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hana ayya nepochag ay ni maphod an lota ja hija hana nunchongor ay ni Hapit Apo Jos, ja inapfulut cha ja inunud cha, ingkhana hi matikhaw hana maphod an pfunga cha. Hachi uchumna ja hintotlompolo, ja hachi uchumna ja hin-uꞌnum chi polo, ja hachi uchumna ja hinkhakhahot chi pfunga cha.” ");
INSERT INTO ifu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Inalin khu Hesus hi, “Achi ta-o torkhan hay panor ja i ta-o halinan wenno epachaor hi kama, ta un ta-o gwot epattoꞌ hay napataw. ");
INSERT INTO ifu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ja amat hina khu hay hato in-arig u, ti an amin hana enhaꞌpfan Apo Jos an agkhuy na pay impa-innila ja umali han arkhaw hot ipa-innila na. Ja hana achi ma-awatan ja umali khu han arkhaw hot ma-awatan. ");
INSERT INTO ifu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hotti pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ja inalin khu Hesus hi, “Ehemad ju an munchongor hay hato alloꞌ. Hini lopong ni aton ju ja hija khu hini lopong ni aton Apo Jos ay chaꞌju ja ma-ug-ugman pay. ");
INSERT INTO ifu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hini takhu an gway pamhod na an miꞌ-unud ay ni ituchuꞌ ja umannung an ma-ug-ugman hini anila na. Hini ayya takhu an una lamangon an achi miꞌ-unud ay ni ituchuꞌ ja anong un hini maphod an anila na ja ma-utaw ay ni nomnom na.” ");
INSERT INTO ifu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Inalin khu Hesus han pangngarig an amat heto. “Hini Pun-ap-apugwan Apo Jos ja mipadchung ay ni ma-at nu gway i munhamar hi pakhuy. ");
INSERT INTO ifu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Napfalin ja khun um-umuy chi arkhaw ja maloꞌ hini khun muntamu hi amadhomadhom hon pfimmangon hi nun nanong an i muntamu. Ja khun homangaw chin intanum na, ja achi na anila hini aton cha an khun homangaw, ");
INSERT INTO ifu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ti un cha ikhad. Mahhun hini lumipiyana ja unot mumpfoto ja unot mumpfohpfoh. ");
INSERT INTO ifu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Unchani ta natong ja immuy khu hini nangtanum ta i na pfot-on, anong una agkhuy inannila hini enat cha an hemmangaw.” ");
INSERT INTO ifu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Inalin khu Hesus hi, “Tayya han oha an i-arig u an pipadchungan tay Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mipadchung ay ni ohan pfugwan chi lakotta an hija hini it-ittangan an amin hi pfugwa heto lota. ");
INSERT INTO ifu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Muti hemmangaw ayya ja khun um-umuy chi arkhaw ja umajiw ja ot-ottongan mu hana uchumna an hamchaꞌ. Umanchu-oy hana hepeng na ja hijay pun-emengan chi hagwiti.” ");
INSERT INTO ifu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja cho-or pay chin pangngarig an inalin Hesus hi khuna puntudtuchugwan ay ni hapit Apo Jos, an ne-anoꞌnong ay ni kaya cha an ma-awatan. ");
INSERT INTO ifu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","An amin chin nuntudtuchugwana ja pangngarig chin khuna aton, muti unchani ta umi-igway cha ayya hana adalana hon empfaag na ay chicha hini podhona an hapiton. ");
INSERT INTO ifu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Unot gwa an nahilip ja inalin Hesus hachi disipolo na hi, “Pfumad-ang ta-o ay tay baybay.” ");
INSERT INTO ifu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hotti niꞌlukhan cha chin pfalangay an inu-umpfunan Hesus ja tenaynan cha hachi tatakhu. Ja nitnud khu hachi uchumna an pfalangay. ");
INSERT INTO ifu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Unagkhu himpfumagkha ja gwacha han mapfi-ah an puwoꞌ. Ja mapfi-ah an muntipjaꞌ-ong chin chanum ja nittugwan chin pfalangay ja gwa an munlinong. ");
INSERT INTO ifu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hi Hesus ayya ja i nanalloꞌ han opfog ay chuy halugitiw chin pfalangay. Immuy hachi disipolo na ja pfinangon cha hi Hesus. Ja inali cha hi, “Rabbi! Anagkha ta nanalloꞌ a ti tayya an marteng ta-o!” ");
INSERT INTO ifu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Enelan Hesus ja inali na chin puwoꞌ ja chin chanum an khun muntipjaꞌ-ong hi, “Khomenong aju!” Khemmenong cha ja munnaud an malenong. ");
INSERT INTO ifu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ja inalin Hesus hachi disipolo na hi, “Anagkha ta temma-ot aju? Un chah ma-id pammati ju ay ha-in?” ");
INSERT INTO ifu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ja nang-entata-ot cha ja khun cha allon chi, “Ngachah ay chita tay an takhu? Anong un puwoꞌ ja chanum ja unuchon cha hini allona!” ");
INSERT INTO ifu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Entortoloy cha Hesus an immuy ja emmatam cha hichi chammangna, an pfuglay hachi eGerasa. ");
INSERT INTO ifu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Unot pfimmutay hi Hesus chin pfalangay ja chinittum na han lala-e an narpu hichi lijang an lupfuꞌ ja nahuhuꞌlungan hi napukhit an ispiritu. ");
INSERT INTO ifu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hitay an mun-angaw ja un amjaꞌ na an munhehetto hana lijang an lupfuꞌ, ja anong un cha epacha an pfangkelengan ja ma-id olog cha. ");
INSERT INTO ifu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Un chaagkhu pfangkelengan hon nunhopchot na ja ad-adchi cha pa-adchon ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A-arkha-arkhaw ja amadhomadhom ja mihihidchi lupfuꞌ ja un la-ahnaon hichi pfuludna, hon ingkhimoh na an kumii, hon nun-okhod na chin achor na hi pfato. ");
INSERT INTO ifu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nebnebtaw hi Hesus hi nannikhan tay an lala-e ja entagtag na an i nanittum ja nunheppe an mundayaw ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ja iniꞌgwap na an nangali hi, “Hesus an Empfalay chi Napfagto an Jos! Ngachah ni atom ay ha-in? Ehapatam ay Apo Jos ta achiyaꞌ adniꞌ palikhaton!” ");
INSERT INTO ifu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hay nangarjana ay tay ja inalin Hesus ay chuy napukhit an ispiritu hi makak ay chuy takhu. ");
INSERT INTO ifu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ja inalin Hesus ay hija hi, “Ngay ngachan mu?” Tempfar na ja inali na hi, “Linipfulipfu ami, ti munhikhapfu ami.” ");
INSERT INTO ifu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ja pemmakhomakhoh hachi napukhit an ispiritu an inali cha hi, “Achi chaꞌmi adniꞌ epakak ay tay an pfuglay.” ");
INSERT INTO ifu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ja cho-or hachi apfapfupfapfuy an khun munhu-oy ay chuy an pfulludna. ");
INSERT INTO ifu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ja numpakpaka-ahi hachi napukhit an ispiritu an inali cha ay Hesus hi, “Hotti un ami mah niꞌ mehoꞌlong hay hachi pfapfuy!” ");
INSERT INTO ifu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ja inalin Hesus hi, “Umuy aju.” Hotti nun-a-akak hachi napukhit an ispiritu ay chuy an lala-e ja i cha nun-ehoꞌlong hachi apfapfupfapfuy. Ja nungkhakhayyat hachi pfapfuy an nunchayyu ja nun-ilipaw cha ay chuy baybay ja nun-arteng cha. Ja hay pfilang chin pfapfuy ja chugway lipfu. ");
INSERT INTO ifu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hachi khun mumpfantay hachi pfapfuy ja nungkhakhayyat cha an nakak. Ja immuy cha hichi pfuglay cha ja hachi uchumna an pfuglay an i nangpa-innila hato an tinnig cha. Hotti napfu-ar hachi tatakhu an i miꞌtikhaw. ");
INSERT INTO ifu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Un chaot emmatam chin agawwachaan Hesus ja tinnig cha chin mun-angaw an ni-i-ibpfun an nunlolopfong ja nagwachaan hi maphod an nomnom. Ja nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ja impa-innilan hachi nannig ay chuy na-at chin lala-e an nakakan hachi ispiritu ja chin khu na-at hachi pfapfuy. ");
INSERT INTO ifu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ja numpakpaka-ahi hachi tatakhu an nangali hi makak hi Hesus ay nuy pfuglay cha. ");
INSERT INTO ifu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Gwa an miꞌlukhan hi Hesus chin pfalangay ja inalin chuy an lala-e an nakakan hachi napukhit an ispiritu hi, “Mitnuchaꞌ adniꞌ ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Muti inalin Hesus hi, “Un aot umanamut ta im ipa-innila hana khakhayyum mu hitay maphod an enat Apo Jos ay he-a ja hini nunnignikhaana ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hotti immanamut ja i na impa-innila an amin chin nunleneꞌgwoh an apfuglapfuglay ad Dekapolis hitay mapmaphod an enat Hesus ay hija. Ja an amin hachi nangngor ja nanannor cha. ");
INSERT INTO ifu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nunlukhan khu cha Hesus ay ni pfalangay ja numpfangngad cha chin narpugwan cha. Na-am-amamung khu hachi tatakhu ja lini-ub cha hija ay chuy agawwachaana an pingngit chi baybay. ");
INSERT INTO ifu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ja immuy ay Hesus han lala-e an hi Jairus an ap-apon han sinagoga hichi. Ja nunheppe ay Hesus ");
INSERT INTO ifu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","an numpakpaka-ahi an nangali hi, “Miꞌjali a adniꞌ hi pfalay mi, ti gwa an ma-uꞌlud han empfalay u an pfupfai, ta hoꞌ-om hija ta tomenong ta gway atona an miꞌtakhu.” ");
INSERT INTO ifu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Amat hichi ja nitnud hi Hesus ja immuy cha, ja khun munhihiꞌ-ig hachi tatakhu an immalipfuypfuy ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja gwa han pfupfai an khun mangunud ay chicha an hay chokhoh na ja achi maymajat han chala an khun pfumutay ay hija hi hempolo ta chugwa hi tagwon. ");
INSERT INTO ifu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nunnaud an nalikhatan ti khinahto na an amin chi pelaꞌ na an i numpa-akhah, muti agkhuy na-akhahan an unagkhu emmom-omod. ");
INSERT INTO ifu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Immuy ay chuy negpong chin khatud Hesus ja heneꞌkhad na chin lopfong na. Ti chengngor na hana impa-innila cha an khun aton Hesus, ");
INSERT INTO ifu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ja hay gwa hi nomnom na ja un ammuna hi una heꞌkhachon chin lopfong na hot tomenong. ");
INSERT INTO ifu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ja emmat, an najat gwot chin chala an khun pfumutay ay hija, ja naleꞌna na an temmenong chin chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Naleꞌnan Hesus an gwa han immuy an apfalinana han takhu hotti nunligkhoh ja inali na hi, “Ngay naneꞌkhad ay tay lopfong u?” ");
INSERT INTO ifu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ja himmapit hachi disipolo na ja inali cha hi, “Apo, ngay machotoꞌ hi naneꞌkhad ay he-a, an tan cho-or hato tatakhu an nali-ub ay he-a an khun munhihiꞌ-ig.” ");
INSERT INTO ifu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Muti khun matmatmaton Hesus ta tikhana hini naneꞌkhad ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inannilan chin pfupfai hitay na-at ay hija ja immuy nunheppe ay Hesus ja khun mun-elob. Ja empfaag na an amin hini na-at. ");
INSERT INTO ifu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ja inalin Hesus ay hija hi, “Khapo ay ni pammatim ja temmenong a. Hotti mun-an-anla a an umanamut ti achi mumpfangpfangngad hini chokhoh mu.” ");
INSERT INTO ifu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Unagkhu khun miꞌhapit hi Hesus chin pfupfai ja ne-atam gwot chin hennag cha an narpu hichi pfalay cha Jairus. Ja inali cha ay Jairus hi, “Achi ta-o ungalon hitay Apo ta-o, ti natoy chamchama atag hini empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Unot chengngor Hesus ja inali na ay Jairus hi, “Achi a mundanag. Ehchor mu ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Amat hichi ja empacheh cha muti empagwan Hesus chi hay mitnud, hotti un angkhay hi Peter ja cha James ay John an hin-akhi chi nitnud. ");
INSERT INTO ifu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ne-atam cha Hesus hichi pfalay cha Jairus ja chengngor cha hachi hingalangala an tatakhu an khun cha mahanalaꞌ an umiha. ");
INSERT INTO ifu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Himmikhop hi Hesus ja inali na hi, “Anagkha ta mahanalaꞌ aju an umiha? Agkhuy natoy hichuy unga an un nanalloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Muti kenekejan cha hitay inali na. Amat hichi ja impapfutay Hesus chicha an amin, ja un angkhay chin a-ammod chin unga ja hachi ini-itnud na chi impahikhop na ay chuy agawwachaan chuy unga. ");
INSERT INTO ifu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Immu-immuy hi Hesus ja inugnana chin ngamoy chin unga ja inali na ay ni hapit cha an Hudju hi, “Talita, kum” an hay podhona an hapiton ja, “Pfumangon a, hiton unga.” ");
INSERT INTO ifu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Amat hichi ja napfanpfannangon chin unga ja chimmalan, ja nanor hachi nannig. Hitay an unga ja muntagwon hi gway hempolo ta chugwa. ");
INSERT INTO ifu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ja inalin Hesus hi, “Ichatan ju hitay unga hi anuna. Ja achi la-ahna ja gway i ju pangar-arjan ay tay an na-at.” ");
INSERT INTO ifu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nitnud hachi disipolo na hi nakakan Hesus an omajana ay chuy pfuglay an emmer-erkhana. ");
INSERT INTO ifu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nachakngan chin Hapfachu an ngilin ja immuy hichi sinagoga an i nuntudtuchu. Ja cho-or chi nanor ay chuy panudtuchu na, ja khun cha allon hi, “An ngay i nangalan tay ay ni nomnom ja apfalinana? Ti tan otong chi apfalinana an mangat hi milagro! ");
INSERT INTO ifu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Un chah pfu-un hitay chin karpentero an empfalay Mary? Un chah pfu-un a-akhi na cha James ay Joses ja hi Judas ja hi Simon? Ja neꞌhehetto khu hana i-ibpfa na an pfinapfai.” Ja un angkhay hato ja pfen-on cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ja inalin Hesus ay chicha hi, “Egngor hana tatakhu hini profeta an narpu hi uchumna an pfuglay muti achi cha egngor ay ni pfuglay an narpugwana, an anong un hana i-ibpfa na.” ");
INSERT INTO ifu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hotti ma-id aton Hesus an mangat hi milagro ay chuy an pfuglay cha, an un angkhay han tortollo an mumpunchokhoh an hen-a na ja temmenong cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ja nanor hi Hesus khapo hi achi cha pammatiyan ay hija. Amat hichi ja pfina-er Hesus hachi apfuglapfuglay an i muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enajakhana hachi hempolo ta han chugwa an adalana ja hininchuggwa na chicha an hennag an i muntudtuchu, muti inchatana chicha hi apfalinan an mangpakak hi napukhit an ispiritu an nehoꞌlong. ");
INSERT INTO ifu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ja inali na ay chicha hi, “Un aju mangew-egwayya an umuy. Hay pfunguhan chi ugnan ju ja angkhay. Achi aju munhongot ja munhape-eng ja mun-ochon hi pihu. ");
INSERT INTO ifu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mumpunhapato aju muti un ammuna hini inlolopfong ju. ");
INSERT INTO ifu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nu gway i ju punnangngan hi pfalay ja hijay punnanangngan ju ingkhana hi akakan ju ay nuy an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ja nu khulat ta hana tatakhu ay ni oha an pfuglay ja achi chaꞌju podhon an mangiliyon ja achi cha egngor hini itudtuchu ju, ja nu makak aju ayya ay nuy an pfuglay ja pumpuꞌpu-an ju hay chapor hi nep-ot ay ni chapan ju ta panginnilaan an hugijon Apo Jos hana tatakhu ay nuy an pfuglay khapo hi achi cha pammatiyan ay ni hapit na.” ");
INSERT INTO ifu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amat hichi ja empacheh hachi adalan an i mangaskasaba hachi tatakhu ta mahapor an chuꞌkhon cha hana pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cho-or chin nun-ehoꞌlong an napupukhit an ispiritu an nun-epakak cha. Ja nun-i-apjut chay lanob hachi mumpunchokhoh hon numpangatenong cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hi Ari Herod ja chengngor na hachi ena-enat Hesus ti nunchongor chin ngachana hi apfuglapfuglay. Ja khun allon chin uchumna an tatakhu hi, “Hitay an hi Hesus ja hija hi John Bautista an un nummahu, hijaot un gway apfalinana an mangat hi milagro.” ");
INSERT INTO ifu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ja inalin hachi uchumna hi hija hi profeta Elijah an un immali an numpatikhaw. Ja gwacha khu hachi khun mangali hi oha hija an profeta an un omaꞌ-at chin profetan Apo Jos chin nahop. ");
INSERT INTO ifu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Muti unagkhu chengngor Herod hachi ena-enat Hesus ja khuna allon hi, “Hijah tay ay chita hi John Bautista an empapotor u chi ulu na, ja tayya an nummahu.” ");
INSERT INTO ifu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Inalin Herod hitay khapo ta hijay nangpatiliw ja nangpipfalud ay John. Chimmalat chin himminglan John, ti hi Herod ja ma-id mahamma na ja i na penloh hi Herodias an ahagwan Philip an ibpfa na. ");
INSERT INTO ifu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Khun allon John ay Herod hi pfahor hitay enat na an namloh ay ni ahagwan ibpfa na, ");
INSERT INTO ifu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","hijaot un pfen-on Herodias hi John, ja penhod na an epapatoy. Muti ma-id enat na, ");
INSERT INTO ifu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ti toma-ot hi Herod ay John, hotti empapfantay na khapo ta anila na an magpong an takhu an immunud ay Apo Jos. Penpenhod Herod an munchongor ay ni itudtuchun John anong un omab-a-ab-ab hini puhu na. ");
INSERT INTO ifu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amat hichi ja nachakngan chin arkhaw an nituꞌkhungan Ari Herod ja ay chuy mahpay chi panghiꞌ-ingan Herodias an mangpapatoy ay John. Amat hetoy na-at, an empa-ajag Herod hachi nun-angangato an a-ap-apon chi khupferno, ja hachi a-ap-apon chi hinchalo ja hachi uchumna an ma-ar-ali an tatakhu ad Galilee. ");
INSERT INTO ifu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja gwa han empfalay Herodias ay Philip an pfalahang ja immuy nunsala ta tikhan hachi tatakhu an na-amung. Ja enamnagwan Herod ja hachi tatakhu chin enat na an nunsala, hotti inalin Herod ay hija hi, “Epfokham chi hay penenhod mu hot ichat u ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ja enhapata na an nangali hi, “Nu ngachah ni epfokham ja ichat u an ichat, anong un makhaggwa hitay agawwachaan ta-o an ujaꞌ nun-ap-apugwan.” ");
INSERT INTO ifu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Immuy chin pfalahang ay chuy ammod na an hi Herodias ja inali na hi, “Ngay ngata epfokhaꞌ ay Ari Herod?” Ja inalin Herodias hi, “Hay epfokham ja ichat Herod hini ulun John Bautista ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ja engkhalakhar chuy pfalahang an numpfangngad chin agawwachaan cha Herod ja inali na hi, “Hay podhoꞌ hi ichat mu ay ha-in ad ugwani ja hini ulun John Bautista an mimitto hi chuju.” ");
INSERT INTO ifu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ja nunheglay tutujun Ari Herod ay chuy inali na muti un amat ja inimit na, ti achi na podhon an paꞌ-iyon chin enhapata na an chengngor hachi na-amung. ");
INSERT INTO ifu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hotti amat hichi ja hennag na han hinchalo an immuy hichi pfaluchan ta i na pinutulan chin ulun John. ");
INSERT INTO ifu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ja initto na chin ulu han chuju ja in-uy na ay chuy pfalahang. Ja in-uy khu chuy pfalahang ay chuy ammod na an hi Herodias. ");
INSERT INTO ifu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Unot chengngor hachi disipolon John hitay na-at ja i cha enala chin achor na ta i cha inlupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Numpfangngad hachi himpolo ta chugwa an apostol ja inali cha ay Hesus an amin chin intudtuchu ja ena-enat cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ja inalin Hesus ay chicha hi, “I ta-o omohha ta gway aton ta-o an mun-eblajan hi naꞌnaꞌ-omtang.” Ti achi omopoh chin tatakhu an mun-en-enlog an umuy ja ma-id aton cha Hesus an mangan. ");
INSERT INTO ifu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Amat hichi ja i cha nunlukhan han pfalangay an i emmohha. ");
INSERT INTO ifu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Muti cho-or chamchama chin nannig an nangmatunan ay cha Hesus hi nangpachihan cha. Hotti tenaynan cha hachi apfuglapfuglay an numpun-arpugwan cha ja entagtag cha an umuy, hotti nahhun cha an emmatam ay chuy omajan cha Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Unagkhu emmatam cha Hesus ja pfimmutay ay chuy pfalangay, ja tinnig na hachi cho-or an tatakhu, ja na-apja chin nignikha na. Ti amat cha hi karnero an ma-id chi hay mangpunoꞌ ay chicha. Amat hichi ja ente-a naot an muntudtuchu ja ma-ar-ar chin intuchu na. ");
INSERT INTO ifu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Unot gwa an nahilip ja immuy hachi disipolo ay Hesus ja inali cha hi, “Honakhom hato tatakhu ta umuy cha hachi nun-ehnot an pfarju ta i cha ngumina hay anun cha. Ti chiya an nahilip ja ma-id pfarpfalay ay tay agawwachaan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ja inalin Hesus hi, “Chaꞌjuwot chi mangchat hi anun cha.” Ja inalin hachi disipolo na hi, “Un chah hay allom ja chaꞌmi chi mungkhahto hi linipfu h i mingina hi tenapay an mepa-an ay chicha?” ");
INSERT INTO ifu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ja inali na ay chicha hi, “Atanay tenapay hi gwa ay chaꞌju? I ju tikhan.” I cha tinikhaw ja numpfangngad cha, ja inali cha hi, “Tayya han lema an tenapay ja han chugwa an khachiw.” ");
INSERT INTO ifu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ja inalin Hesus hachi tatakhu hi, “Ma-aggwa-aggwa aju an umpfun hana holoꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hotti na-aggwa-aggwa cha hi hinkhakhahot, ja henlermay polo an numpanga-umpfun. ");
INSERT INTO ifu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Enalan Hesus chin lema an tenapay ja chin chugwa an khachiw, ja entangad na an nunyaman ay Apo Jos. Napfalin ja initta-ittang na chin tenapay ja inchat na hachi disipolo na ta egwanah cha hachi tatakhu. Ja enat na khu chin khachiw. ");
INSERT INTO ifu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangan cha hotti na-apchan cha an amin. ");
INSERT INTO ifu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Inamung hachi disipolo chin nahagwar ja nun-apnu han hempolo ta chugwa an pfahkit. ");
INSERT INTO ifu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja umuy hi lemay lipfu hana linala-e an nidchum hay hachi nangan. ");
INSERT INTO ifu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Unot napfalin hay hato ja hennag Hesus hachi disipolo na ta i cha munlukhan chin pfalangay ta ipangpangullu cha an umuy ay chuy chammangna ad Betsaida. Nuntaynan hi Hesus ja nun-ipa-anamut na chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Un chaot nakak ja nunti-id hi Hesus ay chuy pfuludna ta i mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gwa an nadhom ja gawwacha pay hi Hesus hichi pfuludna an emmo-ohha. Ja nungkhinawwa chin pfalangay an nunlulukhanan hachi disipolo ay chuy baybay. ");
INSERT INTO ifu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inudhungan Hesus hachi disipolo na ja tinnig na an malikhatan cha an mangedchong ay chuy pfalangay, ti gwa han ijah an mangpapfangngad ay chicha. Unot penghan chi talanu ja nangunud hi Hesus ay chuy agawwachaan cha an khun chumalan ay chuy chanum. Gwa an ilahiyana chicha ");
INSERT INTO ifu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","ja tinnig cha hija, hotti nang-entata-ot cha. Nun-ugwap cha, ti khemhon cha un pfanig an khun chumalan ay chuy baybay. Ja himmapit gwot hi Hesus ja inali na hi, “Achi aju toma-ot ti ha-in. Hotti papfi-ahon ju hini nomnom ju.” ");
INSERT INTO ifu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Amat hichi ja niꞌlukhan hija chin pfalangay ja khemmenong gwot chin ijah. Ja nunnaud an nanor hachi disipolo na, ");
INSERT INTO ifu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ti anong un cha tinnig chin enat na an nangpacho-or chin tenapay, ja agkhuy cha na-awatan hay hato tinnig cha an enat na, ti pfimmato hini nomnom cha. ");
INSERT INTO ifu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pfinad-ang cha chin baybay ja emmatam cha ad Genesaret ja engkho-od cha chin pfalangay. ");
INSERT INTO ifu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Un chaot pfimmutay ay chuy pfalangay ja immatunan hachi tatakhu hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nun-ekhalakhar hachi tatakhu an umuy hachi nun-ehegkhon an apfuglapfuglay an i mangpfalahhong hay hachi mumpunchokhoh, ta ijuy cha ay ni anila cha an agawwachaan Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ja an amin chin immajan Hesus, anong un it-ittang wenno otongngan an pfuglay ja hana nun-ebtaw an lukhar, ja inamung cha hachi mumpunchokhoh ay ni palaha an pummarkhachuwan. Ja numpakpaka-ahi cha ay Hesus ta hachi mumpunchokhoh ja hoꞌ-on cha chin khalampfay chin lopfong na. Ja numpangatenong an amin hachi nan-a chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Gwa han namenghan an hachi Farisee ja chin uchumna an memehtolon chi urchin Moses an narpu ad Jerusalem ja na-amung cha ay chuy gwachaan Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ja nalimuhan cha an khun mangan hay hachi uchumna an disipolon Hesus an agkhuy cha numpfulu. ");
INSERT INTO ifu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ti hitay chi oha hi ugalin chin Farisee ja an amin chin uchumna an Hudju, an paniyaw chi mangan nu agkhuy numpfulu, ti hijay intuchun chin a-ammod. ");
INSERT INTO ifu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Paniyaw khu ay chicha hi mangan hana nanginaan hichi tenchaan nu achi cha mumpfulu. Ja cho-or pay chi urchin, an amat ay ni aton cha an mangulahan hi pfahu ja pun-otanan ja pfanga an khumoꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hijaot un hachi Farisee ja hachi memehtolon chi urchin Moses ja inali cha ay Hesus hi, “Anagkha mah ta hachi disipolom ja achi cha khun unuchon chin intuchun hachi a-ammod an paniyaw chi mangan nu agkhuy ta numpfulu?” ");
INSERT INTO ifu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ja inalin Hesus ay chicha hi, “Umannung chin impadtun profeta Isaiah an omaꞌ-atan ju an mumpfuhuur. Ti intulaꞌ Isaiah hi, ‘Allon Apo Jos hi, Hay hato an tatakhu ja khunaꞌ edaydayaw ay chicha muti un mepogpog ay ni ta-o cha an achi cha nomnomon an umunud ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma-id inherpfin ni khun cha aton an mundayaw ay ha-in, ti un urchin an enephod chi takhu hini khun cha itudtuchu, hon inali cha hi un narpu ay ha-in.’ ” ");
INSERT INTO ifu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ja inalin Hesus ay chicha hi, “Empolag ju agkhu hana urchin Apo Jos ta hana ugali an intuchun chi takhu hini khenokhotan ju.” ");
INSERT INTO ifu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Entoloy Hesus an nunhapit ja inali na hi, “Nakhaꞌ-ila aju ti niya an chin-ug ju hana urchin Apo Jos, ti hinurpfuchan ju hini aton ju an mangat hana nepfanoh an ugali ju. ");
INSERT INTO ifu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ti impa-innilan Moses hitay an urchin Apo Jos an, ‘Mahapor an unuchon ju hana a-ammod ju.’ Ja hitay oha khu an, ‘Hini mamahiw ay ni ammod na an lala-e wenno pfupfai ja patoy hini ohong na.’ ");
INSERT INTO ifu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Muti nab-on hini khun ju itudtuchu. Ti hay allon ju ja nu enetpfar ni takhu ay Apo Jos hay mapfalin hi itolong na hay hana a-ammod na, ");
INSERT INTO ifu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ja hijay panghiꞌ-ingan ju an Farisee an mangali hi achi na ichat ay cha nuy ammod na, ta achi mapaꞌ-i chin inali na an netpfar ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hotti tayya an khapo ay ni pangatan ju ay nuy ugali ju an khun ju ituchu ja amat hi ma-id pfalor nuy umannung an urchin Apo Jos. Ja cho-or hana uchumna an khun ju aton an omaꞌ-at hina.” ");
INSERT INTO ifu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Enajakhan khu Hesus hachi tatakhu ja inali na ay chicha hi, “An amin aju, ja chonglon ju hitay alloꞌ ta ma-awatan ju. ");
INSERT INTO ifu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pfu-un hana anun an umuy ay tay ta-o chi mangpapukhit ay ni ohan takhu. Ti hana mangpapukhit ay hija ja hana na-uti-ot an narpu ay ni nomnom na an pfumutay ay ni ta-o na. ");
INSERT INTO ifu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hotti pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Amat hichi ja tenaynan cha Hesus hachi cho-or an tatakhu ja immanamut cha, ja henanhanan hachi disipolo na nu ngay penhod na an hapiton ay nuy inali na an pangngarig. ");
INSERT INTO ifu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tempfar Hesus ja inali na hi, “Un chah anong un chaꞌju ja achi ju pay ma-awatan? Ti umannung chin inaliꞌ an hana anun an umuy ay tay ta-o ja achi mangpapukhit ay ni ohan takhu. ");
INSERT INTO ifu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ti hana uꞌmunona ja achi umuy ay ni nomnom na, an un umuy ay ni poto na ja pfumutay khu ta metapar.” Hay oha khu hi intuchun Hesus ay tay an inali na ja an amin chi ma-an ja achi paniyaw hi panganan. ");
INSERT INTO ifu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Entoloy Hesus an nangali hi, “Hini marpu ay ni nomnom ni takhu chi mangpapukhit ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ti hini napukhit an nomnom chi takhu ja hijay arpugwan chi napukhit. Ja hay ipfunga na ja hay napukhit hi ugali, an amat hay hana khun me-eloꞌ hi pfu-un ahagwa cha, omakaw cha, pomatoy cha, ");
INSERT INTO ifu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","umilugtap cha, omamnaw cha, aton chay napukhit ay ni ibpfa chah takhu, pfumarpfali cha, aton cha hana napukhit an penhod chi achor, omaamoh cha, pumahiw cha, mumpa-akhaja cha, ja un cha munlokhom. ");
INSERT INTO ifu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","An amin hay hato an napukhit an ugali ja narpu ay ni nomnom chi takhu ja hay hato chi mangpapukhit ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Napfalin hay hato ja nakak hi Hesus ta umuy hana pfuglay an nehegkhon ad Tiro ja ad Sidon. Himmikhop han pfalay ti penhod na an achi cha annilaon muti inannila cha chamchama. ");
INSERT INTO ifu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ja gwa han pfupfai ay chuy an pfuglay an narpu ad Fenisia an provincian chi Syria, an Griego hini hapit na an pfu-un Hudju. Ja gwa han empfalay na an pfupfai an nahuhuꞌlungan hi napukhit an ispiritu. Unaagkhu chengngor an gwa hi Hesus ja immuy gwot an i nunheppe ay hija ja numpakpaka-ahi ta pakakona chin nehohoꞌlong ay chuy empfalay na. ");
INSERT INTO ifu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Impangngarig Hesus an nunhapit ja inali na hi, “Panganun ta-o pay hana ung-ungungnga ta ma-apchan cha. Ti achi maphod un alan hini anun hana ung-ungungnga ja empa-an hana aho.” ");
INSERT INTO ifu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tempfar chin pfupfai ja inali na hi, “Umannung hini inalim, Apo, muti nu ipadchung chaꞌmi an Hentil hi aho, ja anun chi aho hana mun-a-akhah hi un mangan hana ung-ungungnga.” ");
INSERT INTO ifu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ja inalin Hesus ay hija hi, “Maphod hitay enat mu an nampfar, hotti mapfalin an umanamut a, ti nakak mahpay hini napukhit an ispiritu ay ni empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Immanamut chin pfupfai ja enatamana chin empfalay na an numpepekheng ja ma-id chin napukhit an ispiritu ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Napfalin hitay ja tenaynan Hesus hana pfuglay an nun-eh-ehnot ad Tiro ja enenggwa na ad Sidon ja unot hana pfuglay an Dekapolis ta numpfangngad hichi Baybay ad Galilee. ");
INSERT INTO ifu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gwah chi han lala-e an napo-it ja nangutar. In-uy cha ay Hesus ja numpakpaka-ahi cha ta hoꞌ-ona ta tomenong. ");
INSERT INTO ifu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Amat hichi ja en-oꞌ-ojay Hesus chin napo-it ja chenhoꞌ na chin inga na, ja unaot tod-on chin tuppa na ja inchiꞌlah na ay chuy himot chuy lala-e. ");
INSERT INTO ifu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ja entangad Hesus ad uchu ja khapo hi otong an nignikha na ja inali na ay chuy napo-it hi, “Effata” an hay podhona an hapiton ja “Mipfughor.” ");
INSERT INTO ifu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja himpfumagkha ja chomngor chin ingan chuy lala-e ja ma-anchong mahpay chin panapit na. ");
INSERT INTO ifu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja inalin Hesus hachi tatakhu hi ma-id i cha pangar-arjan ay chuy an na-at. Naꞌna-arjona hi achi cha ipa-innila muti un chaagkhu khun omala an mangpa-innila. ");
INSERT INTO ifu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nanor cha ja khun cha allon hi, “Mapmaphod ay chaꞌju an amin hitay enat na. Ti niya an anong un hana napo-it ja chomngor cha, ja hana nangutar ja munhapit cha.” ");
INSERT INTO ifu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gwa khu han namenghan an na-amung hachi cho-or an tatakhu ay chuy agawwachaan Hesus. Nihihidchi cha ja napoh chin hongot cha. Ja enajakhan Hesus hachi disipolo na ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tayya an nignikhaoꞌ hay hato an tatakhu ti neꞌhehetto cha ay chita-o hi toloh arkhaw ja chiya an napoh chin hongot cha. ");
INSERT INTO ifu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Achiꞌ podhon an mangpa-anamut ay chicha an agkhuy cha nangan, ti mahichingan cha an umuy, ti hana uchumna ja achawwi hana nun-arpugwan cha.” ");
INSERT INTO ifu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Himmapit chin disipolo na ja inali cha chi, “Hotti ngay mah aton ta-o? Ti ma-id i ta-o pangalan hi omanay hi epa-an ay cha tay cho-or an tatakhu, ti tan nenebtaw hitay agwachaan ta-o hichi pfuglay.” ");
INSERT INTO ifu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ja inalinot Hesus hi, “Atanay tenapay hi gawwa ay chaꞌju?” Tempfar cha ja inali cha hi, “Ti tan un peto.” ");
INSERT INTO ifu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Inalin Hesus hachi tatakhu ta umpfun cha. Enala na chin peto an tenapay ja nunyaman ay Apo Jos. Napfalin ja initta-ittang na ja inchat na chin disipolo na ta egwanah cha hachi tatakhu, ja enat cha. ");
INSERT INTO ifu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ja gwacha khu han tortollo an i-itang an khachiw ja nunyaman khu hi Hesus ja inali na ta egwanah hachi adalana. ");
INSERT INTO ifu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangan hachi tatakhu hotti na-apchan cha an amin. Inamung chin disipolo hachi nahagwar ja nun-apnu cha han peto an otong an pfahkit. ");
INSERT INTO ifu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hay pfilang hachi nangan ja umuy hi apat hi lipfu. Impa-anamut Hesus hachi tatakhu ");
INSERT INTO ifu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ja nunlukhan hija ja chin disipolo na chin pfalangay ta umuy cha ad Dalmanuta. ");
INSERT INTO ifu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Emmatam cha Hesus ja gwacha hachi Farisee an i miꞌtukki ay hija. Tenoptopngan cha ta ipatikhaw na hay milagro ta panginnilaan cha an narpu ay Apo Jos hini apfalinana. ");
INSERT INTO ifu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Machamot hi punnomnoman Hesus ja inali na hi, “Anagkha chaꞌju an tatakhu ad ugwani an timpo ta itugtukha ju an mangpfokha hi hay ipatikhaw u hi panginnilaan ju an narpu ay Apo Jos hitay apfalinaꞌ. Alloꞌ ay chaꞌju hi ma-id oh-ohhah ipatikhaw u hi hay amat hina.” ");
INSERT INTO ifu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ja tenaynan Hesus chicha ja nunlukhan khu chin pfalangay, ja empacheh cha an pfumad-ang chin chammangna. ");
INSERT INTO ifu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chin disipolon Hesus ja nalichuwan cha an nunhongot ja un oh-ohha han inu-ugnan cha an tenapay hichi pfalangay. ");
INSERT INTO ifu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Himmapit hi Hesus ja inali na hi, “Elanna mangkay, achi la-ahna ja i ju inapfulut hini pfinoꞌpfoꞌ hachi Farisee ja hini pfinoꞌpfoꞌ Herod.” ");
INSERT INTO ifu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ja khun munhahapit hachi disipolo an khun cha allon chi, “Inalin Hesus hinuy khapo ta ma-id hengngot ta-o hi tenapay.” ");
INSERT INTO ifu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aniꞌ-ilan Hesus hini khun cha hapiton ja inali na hi, “Anagkha ta unagkhu hini a-id chi tenapay chi ikhimoh ju an haphapiton? Akamoh ja achi ju annilaon hini apfalinaꞌ. Unchani ja un pfimmato hini nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Anong un khun mummulimuli hay hana mata ju ja achi ju matikhaw. Ja anong un nun-alu-angan hay hana inga ju ja achi megngor. Khenong chi un ju nalichuwan hana ena-enat u. ");
INSERT INTO ifu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chin nangi-ittangaꞌ chin lema an tenapay an empa-an u hachi lemay lipfu an tatakhu, ja atanay pfahkit hi pinnu ju chin nahagwar?” Tempfar cha ja inali cha hi, “Himpolo ta chugwa.” ");
INSERT INTO ifu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ja inalin khu Hesus hi, “Ja chin nangi-ittangaꞌ chin peto an tenapay an empa-an u hachi apat hi lipfu hi tatakhu, ja atana hachi o-otong an pfahkit hi pinnu ju chin nahagwar?” Ja inali cha hi, “Peto.” ");
INSERT INTO ifu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ja inalin Hesus hi, “Aa, hotti un ju chah achi pay ma-awatan hini podhoꞌ an allon?” ");
INSERT INTO ifu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Emmatam cha Hesus ad Betsaida ja in-uy cha han napfulaw ay hija. Numpakpaka-ahi cha ta hoꞌ-ona ta ma-akhahan. ");
INSERT INTO ifu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hotti penchon Hesus chin napfulaw ja initnud na ja in-uy na hichi pingngit chuy an pfuglay. Inchiꞌlah Hesus chin tuppa na ay chuy matan chuy napfulaw ja hen-a na ja inali na hi, “Gway chah matikhaw mu?” ");
INSERT INTO ifu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ja nummohmohgwat chin napfulaw ja inali na hi, “Gwacha. Chiya hachi tatakhu muti omaꞌ-at cha hi ajiw an khun munchallachallan.” ");
INSERT INTO ifu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Impiggwan Hesus an nan-a chin mata na. Ja nunchiyat na ja mattag mahpay chi pannig na. ");
INSERT INTO ifu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Inalin Hesus ay chuy napfulaw hi, “Umanamut a, muti achim eꞌgwa ay chuy pfuglay an narpugwan ta.” ");
INSERT INTO ifu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Napfalin hitay ja empacheh Hesus ja hachi disipolo na an umuy hachi apfuglapfuglay an nun-ehnot ad Cesarea Filipos. Hi khun cha omajan ja inali na hi, “Ngachah tugwali chi allon hana tatakhu hi omaꞌ-ataꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tempfar cha ja inali cha hi, “Gwacha hana mangali hi un he-a hi John Bautista. Ja gwacha khu hana mangali hi un he-a hi Elijah, ja allon khu hana uchumna hi un a oha an profeta chin nahop.” ");
INSERT INTO ifu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ja inalin Hesus hi, “Chaꞌju mah? Ngay allon ju tugwali hi omaꞌ-ataꞌ?” Tempfar Peter ja inali na hi, “He-a hini Hennag Apo Jos an Mamahhod.” ");
INSERT INTO ifu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja naꞌnaꞌ-allon Hesus hi, “Achi ju pay epfaꞌpfaag hitay hana tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nete-a ay chuy ja khun ipaꞌpa-innilan Hesus hachi disipolo na hini cho-or an umali an punlikhatana. Khuna allon hi, “Ha-in an Na-ilangitan an Takhu ja cho-or chi likhat hi hortapoꞌ. Ja pfuhulonaꞌ hay hana a-ap-apon chi Hudju ja hana a-ap-apon chi papachi ja memehtolon chi urchin Moses. Patajonaꞌ muti ay ni me-atloh arkhaw hot mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ja enhamahamaid Hesus an nangali hay hato ja enegnad Peter hija ja inali na hi, “Achim khun allon hinuy.” ");
INSERT INTO ifu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Muti nunligkhoh hi Hesus ja intikhaw na hachi disipolo na ja inhingar na hi Peter ja inali na hi, “Makak a, Satanas, ay ha-in! Ti hini podhom ja pfu-un hini penhod Apo Jos, an un meꞌ-ampoy ay ni penhod chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Amat hichi ja enajakhan Hesus chin tatakhu ja chin disipolo na, ja inali na ay chicha hi, “Hini mamhod an midchum ay ha-in ja mahapor an chuꞌkhona hini piꞌtakhuwana heto lota ja pi-ukhona hini kros na, ja inunuchaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ti hini ayya takhu an mangpa-ennongan ay ni piꞌtakhuwana heto lota ja angkhay, ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota khapo hi pangunuchana ay ha-in ja hitay Ebanghelyo, ja miꞌtakhu ay Apo Jos hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anong un alan ni takhu an amin chi enachangjan ay tay lota ja ma-id pfalor na hu-un ma-utaw chamchama hini piꞌtakhuwana ja nadusa hija hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma-id ichat na hi hugwar ni piꞌtakhuwana. ");
INSERT INTO ifu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cho-or cha ad ugwani chi nan-ug ay Apo Jos ja napukhit hana ugali cha. Hotti hay hana tatakhu an mangpfa-in ay ha-in ja hana khun u ituchu, ja ha-in an Na-ilangitan an Takhu, ja ipfa-in u khu chicha ay ni arkhaw an pumpfangngachaꞌ, an magwachaan ay ni pfinang ja apfalinan Ama ja mimitnud hana nasantuwan an angher.” ");
INSERT INTO ifu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ja en-ang-angonoh Hesus an nangali hi, “Umannung hitay alloꞌ an gwacha hana uchumna ay chaꞌju an achi matoy hot ah-upan cha hini ete-aan ni Pun-ap-apugwan Apo Jos hi tatakhu ay tay lota an gwachaan hi apfalinan.” ");
INSERT INTO ifu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nalahin chi unum hi arkhaw ja initnud Hesus hi Peter ja hi James ja hi John hotti un cha emma-angkhay an nunti-id han pfuludna. Unagkhu la-ahna ja tinnig cha hi Hesus an narman chin tikhaw na, ");
INSERT INTO ifu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ja pomooꞌ chin pinuchaw chin lopfong na, an ma-id chi ipadchungan chin pinuchaw na heto lota. ");
INSERT INTO ifu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tinnig cha khu ja gawwacha cha Elijah ay Moses an khun cha miꞌhapit ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Himmapit hi Peter ja inali na ay Hesus hi, “Apo, maphod ta immali ta-o heto. Mun-ephod ami hi tolo hi apfong ta henohha aju ay cha Moses ja hi Elijah.” ");
INSERT INTO ifu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma-id maptoꞌ hi i na hapiton ti nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Unagkhu himpfumagkha ja gwa han pfonot an nunliꞌnup ay chicha. Ja gwacha han hapit an narpu ay chuy pfonot an allona hi, “Hitay hini podpodhoꞌ an Empfalay u. Hotti egngor ju hija!” ");
INSERT INTO ifu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Un chaagkhu munlengngalengngaw ja himpfumagkha ja nama-id chin numpun-ibpfan Hesus an un angkhay hija. ");
INSERT INTO ifu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Amat hichi ja empacheh cha an nunchayyu ja khun allon Hesus ay chicha hi, “Achi ju epfaꞌpfaag hitay an tinnig ju ingkhana hi mummahuwaꞌ an Na-ilangitan an Takhu.” ");
INSERT INTO ifu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inunud cha hitay inali na muti khun cha haphapiton nu ngay podhona an allon ay ni nangarjana hi mummahu hija. ");
INSERT INTO ifu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ja inali cha ay Hesus hi, “Anagkha mah, Apo, ta hachi memehtolon chi urchin Moses ja ituchu cha an mahapor an mahhun hi Elijah an umali ja un umali hini Mamahhod?” ");
INSERT INTO ifu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tempfar Hesus ja inali na hi, “Umannung an mahapor an mahhun hi Elijah an umali an manghakhana hana tatakhu ja un umali hini Mamahhod. Muti gwacha khu hini Hapit Apo Jos an nitulaꞌ hi nangarjana hi, ha-in an Na-ilangitan an Takhu ja cho-or chi uy u hortapon hi likhat ja chuꞌkhonaꞌ hay hana tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ja alloꞌ ay chaꞌju hi immali mahpay hi Elijah ja enat cha an amin hana napukhit an penhod cha an aton ay hija, ti hijah tay chi inalin ni Hapit Apo Jos an ma-at ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Emmatam cha Hesus ay chuy agawwachaan hachi uchumna an disipolo na ja tinnig cha hachi cho-or an tatakhu an nangakhawwong ay chicha. Ja gawwacha hachi memehtolon chi urchin ja khun cha miꞌhanu an miꞌhahapit hay hachi disipolo. ");
INSERT INTO ifu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Unagkhu tinnig hachi tatakhu hi Hesus ja nanor cha ja temmagtag cha an i mang-alaw an mangali ay hija hi, “Maphod ta immali a.” ");
INSERT INTO ifu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ja empfokhan Hesus hay hachi disipolo na hi, “Ngachah ni khun ju piꞌhahannugwan ay chicha?” ");
INSERT INTO ifu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ja gwa han lala-e ay cha chuy tatakhu an tenompfar ja inali na hi, “Rabbi! In-aliꞌ ay he-a hitay empfalay u an lala-e an un la-ahnaon naheꞌpan hi napukhit an ispiritu, hijaot un makalud. ");
INSERT INTO ifu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gwa ayya ta neh-ap hini ispiritu hon numpfitug ja mungngelot chi pfapfa na hon immupag hini ta-o na hon nangu-ulajat. Ja un u agkhu inali ay cha tay disipolom hi pakakon cha ja ma-id olog cha.” ");
INSERT INTO ifu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ja inalin Hesus hi, “Munlinapoh aju kaykhu an tatakhu. An akamoh an unaꞌ napfajag an gawwacha ay chaꞌju ja inanuhaꞌ chaꞌju, ja un kaykhu la-ahna ja ingkhana ad ugwani ja ma-id pammati ju. Ijali ju heto hini unga.” ");
INSERT INTO ifu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","In-uy cha ja unagkhu tinnig chuy neh-ap an ispiritu hi Hesus ja enggwakhot na chin unga ja pimmanullipullig ja immupag chin ta-o na. ");
INSERT INTO ifu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja empfokhan Hesus ay chuy aman chuy unga hi, “Aꞌ-anunay nangte-aana hi amatana heto?” Tempfar na ja inali na hi, “Nete-a chin a-ung-ungnga na. ");
INSERT INTO ifu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Empachapachan ni ispiritu an mamatoy ay hija hi khuna pangpulu-an hi apoy ja pangtuuchana hi gwanggwang. Hotti ka-ahiyan chaꞌmi adniꞌ, Apo, ja tinulungan chaꞌmi ta alom adniꞌ ja gway apfalinam.” ");
INSERT INTO ifu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ja inalin Hesus hi, “Anagkha ta allom hi, nu gway apfalinaꞌ? Mapfalin an amin ay ni takhu an gway pammati na ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ja munluluwa an nangiꞌgwap hichuy ammod chuy unga hi, “Gwa hitay pammatiꞌ muti tan un ad-adchi hotti un mu adniꞌ ug-ugman!” ");
INSERT INTO ifu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tinnig Hesus an cho-or hachi tatakhu an umuy ay chicha ja henonglar naot hichuy napukhit an ispiritu ja inali na hi, “He-a an napukhit an ispiritun chi po-it ja kalud, alloꞌ ay he-a hi makak a ay tay unga ja achi a mumpfangpfangngad!” ");
INSERT INTO ifu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nungkii chin neh-ap an ispiritu ja mun-a-ajog-og chin unga hi akakan chin ispiritu. Amat hi un natoy chin tikhaw chuy unga hotti inalin hachi tatakhu hi, “Chiya an natoy.” ");
INSERT INTO ifu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Muti penchon Hesus ja pfinangona ja impataꞌchug na hichuy unga. ");
INSERT INTO ifu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Napfalin ja himmikhop cha Hesus ay chuy pfalay an nunhihittugwan cha ta immi-igway cha ja un allon hachi disipolo na hi, “Anagkha ta ma-id olog mi an mangpakak ay nuy napukhit an ispiritu?” ");
INSERT INTO ifu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tempfar Hesus ja inali na hi, “Hinuy an kalahen chi ispiritu ja achi makak nu achi ta mungkalalag ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Empacheh cha Hesus ja enenggwa cha ad Galilee. Penhod Hesus an ma-id manginnila ay chuy agawwachaan cha ");
INSERT INTO ifu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ti khuna tuchugwan chin disipolo na. Ja inali na ay chicha hi, “Ha-in an Na-ilangitan an Takhu, ja achi mapfajag hot michataꞌ hana pfuhur u hot patajonaꞌ. Muti ay ni me-atloh arkhaw hot mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Muti agkhuy cha na-awatan hitay an inali na ja mun-okhon cha an manghanhan. ");
INSERT INTO ifu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Amat hichi ja emmatam cha Hesus ad Kapernaum. Unagkhu gwa an himmikhop cha han pfalay ja empfokhan Hesus hachi disipolo na hi, “Ngachah ni khun ju punhahannugwan ay nuy chalan hi khun ta-o umaliyan?” ");
INSERT INTO ifu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Muti pfimma-in cha an mampfar ti chin khun cha haphapiton ja nu ngachah chi napfagpfagto ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Inumpfun hi Hesus ja enajakhana hachi himpolo ta chugwa an adalana ja inali na ay chicha hi, “Hini mamhod an mamangulu ja mahapor an na-upfay ja hijay mi-ud-uchichi, ja tomolong an amin hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Penchon Hesus han ung-ungnga ja impataꞌchug na. Len-om na ja inali na ay chicha hi, ");
INSERT INTO ifu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hini mangakhamid hi takhu an nabnababba an amat ay tay unga khapo hi pammati na ay ha-in ja ma-id uchumna hi inakhamid na nu pfu-un ha-in. Ja hini mangakhamid ay ha-in ja pfu-un ha-in ja angkhay chi inakhamid na, ti inakhamid na khu hi Ama an nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Inalin John ay Hesus hi, “Apo, tinnig mi han ohan takhu an khun mangpakak hi napukhit an ispiritu ay ni apfalinan ni ngachan mu. Ja inhingar mi ta epokhong na, ti agkhuy nidchum ay chita-o.” ");
INSERT INTO ifu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ja inalin Hesus ay chicha hi, “Achi ju epagwa. Ma-id chi hay mangat hi milagro ay ni apfalinan ni ngachan u, ja napfalin ja gway i na agkhu allon hi napukhit ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ti chicha ja un hihiya na ay chita-o nu achi cha pfumuhur. ");
INSERT INTO ifu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ja umannung hitay alloꞌ ay chaꞌju an hini takhu an magmagkhohkhoh ay chaꞌju khapo hi nidchuman ju ay ha-in, anong un himpfahpfahhu hi chanum chi ichat na hi inumon ju, ja gwachay linagpfu na ay nuy an enat na. ");
INSERT INTO ifu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Muti hini takhu an chimmalat hi pfimmahulan chi oha an nabnababba an namati ay ha-in, ja madusa. Toꞌ-onot un ekho-od hay machamot an pfato ay ni pfokhang na ja intuud hichi baybay ta marteng, mu hini un hijay chumalat hi pfumahulan. ");
INSERT INTO ifu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Hotti nu hini ngamoy mu chi chumalat hi pfumahulam ja toꞌ-onot un mu potnan! Ti anongkay ja oh-ohha hini ngamoy ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway ngamoy ja mituud a chamchama hichi impferno an gawwachaan chi apoy an achi madmachop. ");
INSERT INTO ifu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ja nu hini hu-im chi chumalat hi pfumahulam ja toꞌ-onot un mu potnan! Ti anongkay ja oh-ohha hini hu-i ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway hu-i ja mituud a chamchama hichi impferno. ");
INSERT INTO ifu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja nu hini matam chi chumalat hi pfumahulam ja toꞌ-onot un mu u-iton! Ti anongkay ja oh-ohha hini mata ja akhaja ta miꞌtakhu taot niꞌ ad langit. Ti anong un chugway mata ja mituud a chamchama hichi impferno. ");
INSERT INTO ifu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hini omaꞌ-atana hichi impferno ja mun-apfighan cha hi pfekheh an achi matmatoy, ja mapleng cha hi apoy an achi madmachop.” ");
INSERT INTO ifu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ja inalin khu Hesus hi, “An amin chi tatakhu ja mahapor an metnob cha hi likhat ta gway aton cha an pomhod. An amat ay ni anun an midaton, an mahapor an gway ahina ja un akhajaon Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ja inalin khu Hesus hi, “Maphod hini ahin muti penomhaw ayya ja achi mumpfangngad hini tatam na. Hotti amat aju koma hi maphod an ahin ta mun-oh-ohha aju.” ");
INSERT INTO ifu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nakak cha Hesus ad Galilee ta immuy cha ad Judea ja un chaot pfad-angon hini gwanggwang an Jordan. Cho-or khu chin tatakhu an immuy ay hija hotti intudtuchugwana chicha, ti hitay chi emmengha hi atona. ");
INSERT INTO ifu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ja gwacha hachi uchumna an Farisee an immuy ay hija ta toptopngan cha. Ja inali cha hi, “Ngay allom, mapfalin chah ay ni urchin ta-o an ihijan ni lala-e hini ahagwa na an pfupfai?” ");
INSERT INTO ifu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ja inalinot Hesus hi, “Ngay tugwali allon chin urchin Moses?” ");
INSERT INTO ifu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tempfar cha ja inali cha chi, “Hay in-urchin Moses ja mapfalin an ihijan ni lala-e hini ahagwa na, nu ichatana hi tulaꞌ an napermaan an nunhijan cha ja unaot pakakon.” ");
INSERT INTO ifu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ja inalin Hesus hi, “Umannung an in-urchin Moses hitay, muti hay khapo na ja munnaud aju an nalikhat hi matuchugwan. ");
INSERT INTO ifu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ti chin ayya hunhunana an narmugwan tay lota ja himpfun Apo Jos chi takhu an lala-e ja pfupfai. ");
INSERT INTO ifu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja inalin Apo Jos hi, ‘Hijaot un taynan ni lala-e hana a-ammod na ta i midchum ay ni ahagwa na an pfupfai, ");
INSERT INTO ifu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hot mumpfalin cha hi ohah achor.’ Hotti achi cha chugwa an un cha oh-ohha. ");
INSERT INTO ifu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hotti hini numpfalinon Apo Jos hi oh-ohha ja achi mapfalin an punhijanon chi takhu.” ");
INSERT INTO ifu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Unot numpfangngad cha Hesus chin nunhihittugwan cha ja entoloy chin disipolo na an nunhanhan ay tay an intuchu na. ");
INSERT INTO ifu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ja inalin Hesus ay chicha hi, “Hini lala-e an manghijan hi ahagwa na ta i pumiggwa ja hihiya an inlugtap na hini ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ja lugtap khu ay ni pfupfai nu ihijana hini ahagwa na ja nangahagwa hi aha.” ");
INSERT INTO ifu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gwa han namenghan an in-uy cha hachi ung-ungungnga ay Hesus, ti podhon cha an eh-a na hini ngamoy na ta bindisyonana chicha, muti nun-ihingar hachi disipolo chicha. ");
INSERT INTO ifu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Unot tinnig Hesus hitay an enat hachi disipolo na ja himmingar an inali na hi, “Anong khu ja in-ali cha ay ha-in hato ung-ungungnga. Achi ju epagwa, ti hay hana tatakhu an miꞌpadchung hi ung-ungungnga ja chicha chi midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Umannung hitay alloꞌ ay chaꞌju an hini aton ju an mangapfulut ay ni Pun-ap-apugwan Apo Jos ja mahapor an amat ay ni aton ni unga an mangakhamid hi michat ay hija. Ti nu achi amat heto hot achi aju midchum.” ");
INSERT INTO ifu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Amat hichi ja len-om na hachi ung-ungungnga ja enohha-ohha na an hen-a ta binindisyonana chicha. ");
INSERT INTO ifu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Unagkhu empacheh cha Hesus an umuy ay chuy i cha omajan ja gwa han lala-e an khun tomagtag an i nunheppe ay hija. Ja inali na hi, “Maphod a, Apo. Hotti ngay allom hi atoꞌ ta magwachaanaꞌ hi piꞌtakhuwan an ma-id chi pogpogna?” ");
INSERT INTO ifu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ja inalin Hesus ay hija hi, “Anagkha ta allom hi unaꞌ maphod? An un hay maphod ja hi Apo Jos ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Anilam jaꞌ hana urchin an allon cha hi, ‘Achi aju pomatoy, ja achi aju umilugtap, ja achi aju omakaw, ja achi aju i muntihtikhu hi achi umannung, ja achi aju pfumarpfali, ja unuchon ju hana a-ammod ju.’ ” ");
INSERT INTO ifu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tempfar chin lala-e ja inali na hi, “Khun u unuchon hay hato an urchin, nete-a chin a-ung-ungngaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Intikhaw Hesus ay hija ja narmu chin otong an pamhod na ay chuy an lala-e ja inali na hi, “Gwacha pay han oha an agkhuy mu enat. Eplaꞌ mu an amin hana enachangjan mu ja inchat mu hini polaꞌ na hana napubli, hot michatan a hi enachangjan ad langit. Enat mu ayya hitay ja immali a ta mitnud a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Unaagkhu chengngor hitay an inalin Hesus ja nun-itong na ja immayyong an nangpacheh, ti munnaud chin enachangjana ja ay-ayyugwana. ");
INSERT INTO ifu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Inggwingin Hesus hachi disipolo na ja inali na ay chicha hi, “Munnaud an nalikhat hana achangjan an midchum ay ni Pun-ap-apugwan Apo Jos!” ");
INSERT INTO ifu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ja nanor hachi disipolo na hi nangarjana ay tay ja impiggwa na an nangali hi, “Chaꞌju an empfapfalay u, nalikhat mangkay chi midchum ay ni piꞌtakhuwan ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nalaklaka agkhu niꞌ hini kemer an lompfot ay ni opfot ni tanud mu hini achangjan an midchum ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nanor hachi disipolo na hi nangngolan cha ay tay, ja inali cha hi, “Hotti nu achi miꞌtakhu hana achangjan ja ngay ngachah mah chi hay miꞌtakhu ay Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Emmohchong Hesus chicha ja inali na hi, “Hana achi mapfalinan chi takhu ja kayan Apo Jos ti mapfalin an amin ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Himmapit hi Peter ja inali na hi, “Hot chaꞌmi mah an nanaynan an amin ta nitnud ami ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ja inalin Hesus hi, “Umannung hitay alloꞌ ay chaꞌju, an hana nanaynan hi pfalay cha, a-akhi cha, a-ammod cha, empfapfalay cha ja lota cha khapo hi pamhod cha ay ha-in ja hitay Ebanghelyo, ");
INSERT INTO ifu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ja choꞌchoꞌ-olan chi michat ay chicha ay tay piꞌtakhuwan cha heto lota. Gway ehakhanan Apo Jos hi pfalay cha, a-akhi cha, a-ammod cha, empfapfalay cha ja lota cha. Maparpalikhat cha khu muti omaꞌ-angonoh ja michatan cha hi piꞌtakhuwan an ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cho-or cha hana nun-apfagto heto lota an chicha chi mi-ud-uchichi hichi ad langit. Ja gwacha hana tatakhu an ma-id nitagtakhuwana heto lota muti chicha agkhu chi mipapfagpfagto ad langit.” ");
INSERT INTO ifu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Khun ipangpangullun Hesus hi khun cha punti-ichan an umuy ad Jerusalem. Ja unagkhu la-ahna ja nun-elob chin disipolo na ja nanor cha. Henhenod Hesus hachi himpolo ta chugwa an adalana ja impa-innila na khu hay hana ma-at ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Inali na hi, “Chonglon ju! Tayya an umuy ta-o ad Jerusalem ja ha-in an Na-ilangitan an Takhu ja michataꞌ hay hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses. Hugijonaꞌ ay chicha ja epapatojaꞌ. Ja mipulangaꞌ hay hana Hentil ");
INSERT INTO ifu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","an mangekejan ja manuppaan ja manuplit ay ha-in. Patajonaꞌ muti ay ni me-atlon arkhaw ja mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cha James ay John an empfalay Zebedee ja immuy cha ay Hesus an i nangali hi, “Apo, gwa han epfokha mi ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ja inalin Hesus hi, “Ngachah nuy epfokha ju?” ");
INSERT INTO ifu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tempfar cha ja inali cha hi, “Machakngan ayya chin pipapfagpfagtuwam ta umpfun a an mun-ap-apo, ja hay epfokha mi ja piꞌpapfun chaꞌmi an miꞌ-ap-apo, oha ay ni nun-appit hi agwan mu ja oha ay ni nun-appit hi ikhid mu.” ");
INSERT INTO ifu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ja inalin Hesus ay chicha hi, “Ma-id anila ju ay nuy empfokha ju. Agkhuy ju atag anila chi hay omaꞌ-atana. Un chah angkhiloh un aju paꞌ-ahchor ay ni likhat an haꞌpfatoꞌ ja paꞌ-ahchor ay ni patoy an amat ay tay ujaꞌ pancholan an atajaꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ja inali cha hi, “Olog mi.” Ja inalin Hesus ay chicha hi, “Umannung an haꞌpfaton ju hana likhat an amat ay ni likhat u, ja matoy aju an amat ay ni atoꞌ an matoy. ");
INSERT INTO ifu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Muti tan pfu-un ha-in chi mangpadchong ay ni mi-ipfun ay tay nun-appit hi agwan u ja ay tay nun-appit hi ikhid u, ti hi Apo Jos chi mangpadchong ay ni enchachaag na.” ");
INSERT INTO ifu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Unagkhu inannilan hachi himpolo an padchung cha an adalan hichuy an empfokhan cha James ay John ja mapfungot cha. ");
INSERT INTO ifu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hotti inam-amamung Hesus chicha an amin, ja una allon hi, “Nomnomon ju akay niꞌ hana khun mun-ap-apo hi tatakhu heto lota an khun cha ipapilit hini podhon cha. Ja hana a-ap-apo an gway apfalinana, ja khun cha palikhaton hana tatakhu an khun cha pfaapfaalon. ");
INSERT INTO ifu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Achi koma amat hetoy aton ju. Ti hini mamhod an ma-ar-ali ja mahapor an tulunganay padchung na an takhu. ");
INSERT INTO ifu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ja hini mamhod an mumpfalin hi pangulu ja mahapor an munhimpfut an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Amat ay ha-in an Na-ilangitan an Takhu, an agkhujaꞌ immali ta chaꞌju an tatakhu chi munserbi ay ha-in. Muti immaliyaꞌ an munserbi hana cho-or an tatakhu ja ta matojaꞌ an pfajad chi pfahor cha.” ");
INSERT INTO ifu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eneꞌgwan Hesus ja chin disipolo na ad Jeriko ja gwa an malahin cha ay chuy an pfuglay ja nitnud khu chin cho-or an tatakhu. Ja gwah chi han napfulaw an hi Bartimeus chi ngachana an empfalay Timeus. Inu-umpfun hija ay chuy pingngit chi kurha an khun mun-ad-adchaw. ");
INSERT INTO ifu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Unaot chengngor an maloh hi Hesus an eNazaret ja ente-a na an nun-ugwap an nangali hi, “Hesus an holag Ari David, ka-ahiyanaꞌ adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cho-or hachi nanghingar ay hija ta khomenong muti en-om-omod chin napfulaw an nangiꞌgwap hi, “Hesus an holag Ari David, ka-ahiyanaꞌ adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Intaꞌchug Hesus ja inali na hachi tatakhu hi, “Ajakhan ju hichuy lala-e.” Hotti enajakhan cha ja inali cha ay hija hi, “Munchenor a, ti chuyya an ajakhan chi-a ay Apo Hesus.” ");
INSERT INTO ifu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Enaana chin enhahapfelloy na an lopfong ja natantannaꞌchug an umuy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ja inalin Hesus ay hija hi, “Ngay podhom hi atoꞌ ay he-a?” Tempfar chuy napfulaw ja inali na hi, “Apo, podhoꞌ an mitikhaw hitay mataꞌ!” ");
INSERT INTO ifu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ja empfokhan Hesus hi, “Aa, hotti umuy a ay ni omajam, ti mitikhaw hini matam khapo ay ni pammatim.” Ja mitikhaw gwot chin matan chuy napfulaw ja nitnud ay cha Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Empacheh cha Hesus ja khun cha homnot ad Jerusalem. Emmatam cha ad Betfage ja Betani an achaan chuy pfulludna an nangadnan hi Olibo ja hennag Hesus han chugwa an disipolo na ");
INSERT INTO ifu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","an inali na hi, “Ipangulu ju ay chuy pfarju hichi chammangna. Nu omatam aju hot chakngan ju gwot han nekhokhoꞌ-od an donkey an pfoꞌtot an agkhuy nahak-hakajan. Upfachon ju ja in-ali ju heto. ");
INSERT INTO ifu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ja nu gway mangpfokha hi, ‘Anagkha ta alaon ju hitay donkey,’ ja allon ju hi, ‘Alaon mi, ti nan mahapor Apo ta-o muti un na-omtang hot epepfangngad na.’” ");
INSERT INTO ifu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Immuy hachi chugwa an disipolo ja immannung, ti chinakngan cha chin inali na an donkey an pfoꞌtot an nekhokhoꞌ-od chin pantaw han pfalay ay chuy pingngit chuy kurha. Unagkhu gwa an khun cha upfachon ");
INSERT INTO ifu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ja inalin hachi niꞌtataꞌchug hi, “Anagkha ta alaon ju hitay donkey?” ");
INSERT INTO ifu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ja inali cha hi, “Alaon mi ti nan mahapor Apo ta-o.” Ja agkhuy empagwan chin tatakhu hi nangujuchan cha. ");
INSERT INTO ifu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","In-uy cha chin donkey ay Hesus ja enopnan cha chin khatud na hi lopfong ja nunhakay hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hi khun cha omajan ja chenom-or chin tatakhu, ja nunloh-op cha chin uchumna an lopfong cha hon en-ap-ap cha chin chalan. Hachi uchumna ja nun-e-ap-ap cha hachi tupfun chi ajiw an i cha numpateng. ");
INSERT INTO ifu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hachi ayya nangpangpangullu ja hachi khun mangun-unud an atakhutakhu ja khun cha iꞌgwap hi, “Madaydayaw a! Mabindisyonan a an hennag Apo Jos! ");
INSERT INTO ifu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Epaphod mu adniꞌ, Apo Jos, hini pun-ap-apugwan tay Ari mi an mepallog chin ammod mi an hi Ari David! Madaydayaw hi Apo Jos ad langit!” ");
INSERT INTO ifu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Unagkhu emmatam cha Hesus ad Jerusalem ja himmikhop hija hichi Templo. Ja tinnig na an amin chi hay gwa hichi muti khapo ta nahilip ja empacheh na an umuy ad Betani. Ja nitnud chin himpolo ta chugwa an adalana. ");
INSERT INTO ifu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chin nun-inggwiꞌgwiit ja empacheh cha Hesus ad Betani ta mumpfangngad cha ad Jerusalem, ja hemmenaang hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Enamang na han ajiw an higos an cho-or chi tupfu na. Ja immuy an i mangala koma hay pfunga na. Unagkhu emmatam chin achaan chuy ajiw ja ma-id oh-ohhah pfunga na an un angkhay chin malupfong an tupfu na, ja pfu-un ahipfungan chi higos. ");
INSERT INTO ifu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja inalin Hesus ay chuy an ajiw hi, “He-a ton ajiw, mete-a ad ugwani ja ma-id oh-ohha hi mangan hi hay pfungam.” Ja chedchengngor chin disipolo na hitay an inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Unagkhu emmatam cha Hesus ad Jerusalem ja immuy ay chuy partug chi Templo ja chinakngana hachi khun mungkumerchu hi animar an hijay khun nguminaan hana takhu hi ipidaton cha ay Apo Jos. Ja nun-epakak na hachi khun ngumina ja mungngina. Nun-ipfu-allo na hachi lamehaan hachi khun munhukat hi pihu, ja chin umpfunan hachi khun mungngina hi hagwiti an pfalug. ");
INSERT INTO ifu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ja empagwa na hachi tatakhu an mangeꞌgwa hachi khun cha ingina ay chuy partug chuy Templo. ");
INSERT INTO ifu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ay chuy puntudtuchugwan Hesus hachi tatakhu ja inali na hi, “Allona ay ni Hapit Apo Jos hi, ‘Hitay pfalay u ja pfalay an pungkalalakhan.’ Muti tayya an numpfalinon ju hi a-amungan chi mangakaw.” ");
INSERT INTO ifu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Unot inannilan hachi a-ap-apon chi papachi ja memehtolon chi urchin hitay an enat Hesus ja khun cha nomnomnomon hay aton cha an mamatoy ay hija. Ti toma-ot cha ay hija khapo ta nanor hachi tatakhu ay chuy khuna ituchu. ");
INSERT INTO ifu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ja nahilip ayya hon nakak hi Hesus ja hachi adalana ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hichin nun-inggwiꞌgwiit hi nannanong an pumpfangngachan cha Hesus ad Jerusalem ja tinnig cha chin ajiw an higos an naꞌleng, anong un chin lamot na. ");
INSERT INTO ifu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ja nenomnom Peter chin enat Hesus ja inali na hi, “Chiya, Apo, an naꞌleng hichuy higos an tinubtupfam!” ");
INSERT INTO ifu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ja inalin Hesus hi, “Mamati aju ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Umannung hitay alloꞌ ay chaꞌju, nu munchomoꞌ aju ay Apo Jos an atona hini epfokha ju, an achi munharhalinchugway nomnom ju, hot mapfalin an allon ju ay tay an pfulludna hi, ‘Makak a ta i a mituud hichi baybay’ hot ma-at. ");
INSERT INTO ifu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hotti hay alloꞌ ay chaꞌju ja nu ngachah chi ekalalag ju ay Apo Jos, ja ma-at an ma-at nu munchomoꞌ aju ay hija an atona. ");
INSERT INTO ifu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nu mungkalalag aju ta nepanomnom hi hay pfimmahor ay chaꞌju ja pakawanon ju, ta pakawanon chaꞌju khu ay Ama ju ad langit. ");
INSERT INTO ifu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Muti achi aju ayya pomakawan ja achi chaꞌju khu pakawanon ay Jos Ama an gwa ad langit.” ");
INSERT INTO ifu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Emmatam cha ad Jerusalem ja unagkhu gwa an khun munchallachallan hi Hesus ay chuy partug chuy Templo ja immuy hay hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses ja hachi uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ja empfokha cha ay hija hi, “Ngachah chi narpugwan ni apfalinam an mangat hay hato khun mu aton? Ja ngay nangchat ay nuy apfalinam?” ");
INSERT INTO ifu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tempfar Hesus ja inali na hi, “Unchani adchiya ta topfalon ju pay hitay peꞌpfokhaꞌ. Nu topfalon ju hot alloꞌ ay chaꞌju hini narpugwan tay apfalinaꞌ an mangat hato. ");
INSERT INTO ifu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hotti allon ju adchiya tugwali, ngay nannag ay John Bautista an immali an khun mumbautisar? Hi Apo Jos wenno hay takhu?” ");
INSERT INTO ifu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ja khun cha manghempfopfogkha an khun cha allon hi, “Hot ngachah chi allon ta-o mah? Nu allon ta-o hi un hennag Apo Jos hot allona hi, ‘Nu hi Apo Jos chi nannag ay John ja anagkha mah ta agkhuy ju pinati hija?’ ");
INSERT INTO ifu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ja nu allon ta-o khu hi hennag chi hay takhu hot pfumungot hay hato tatakhu.” Ti temma-ot hachi a-ap-apo hachi tatakhu ti namati cha an amin an umannung an profetan Apo Jos hi John. ");
INSERT INTO ifu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hotti hay nampfar cha ay Hesus ja inali cha hi, “Ma-id anila mi nu ngachah chi nannag ay hija.” Tempfar khu Hesus ja inali na hi, “Nu amat hina hot achiꞌ khu epfaag nu ngay nangchat ay ha-in hi apfalinaꞌ an mangat hay hato.” ");
INSERT INTO ifu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Amat hichi ja inalin khu Hesus ay chicha hitay an pangngarig. “Gwa han ohan lala-e an nuntanum hi cho-or hi ubas ay ni kharchina. Enalad na chin kharchin ja tinau-ana han pfato an khun cha pang-amungan hi chanum chi ubas hi un cha lochehon. Empahaꞌ-ad na khu han nataꞌnang an ab-abpfong an oma-ayyan chi mumpfantay. Napfalin hay hato ja empapfengpfeng na hichuy kharchina ja unot makak an umuy hichi achawwi. ");
INSERT INTO ifu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Unot nachakngan chin ahipokhah ja hennag na han ohan takhala na an i meꞌ-aggwa ay chuy penokhah cha an ubas. ");
INSERT INTO ifu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Muti hay hato an neꞌpfengpfeng ja enala cha chin takhala ja numpakhuh cha ja empapfangngad cha an ma-id oh-ohhah inchat cha. ");
INSERT INTO ifu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hennag na khu han oha an takhala na ja numpang-or cha ja pinarpalikhat cha. ");
INSERT INTO ifu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hennag na khu chin me-atlo an takhala na ja penatoy cha. Ja amat hina khu hay hachi cho-or an takhala na an nepallog. Numpakhuh chay uchumna ja penatoy cha chin uchumna. ");
INSERT INTO ifu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Un emma-emmat heto ja napoh chin takhala na, ja un angkhay hini oh-ohha an empfalay na an lala-e an penpenhod na. Omaꞌ-angonoh ja hennag na hitay an empfalay na an allona hi, ‘Alom ja egngor hachi neꞌpfengpfeng hija.’ ");
INSERT INTO ifu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Muti nunhahapit hay hachi neꞌpfengpfeng ja inali cha hi, ‘Hijah tay hini empfalay ni khun ta-o peꞌpfengpfengan an hijay mamanoh ay tay lotan ama na. Unot la-ahna ja penatoy ta-o ta chita-oy mangheꞌ-a ay tay lota na.’ ");
INSERT INTO ifu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Amat hichi ja enala cha ja penatoy cha, ja i cha entapar hichi pingngit chin kharchin.” ");
INSERT INTO ifu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ja inalin Hesus hachi tatakhu hi, “Ngachah tugwali chi aton tay an takhu hay hachi neꞌpfengpfeng ay hija? Umuy hija ja epapatoy na chicha ja empapfengpfeng na hi uchumna.” ");
INSERT INTO ifu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ja en-ang-angonoh Hesus an nangali hi, “Anilaꞌ an pfinaha ju hitay nitulaꞌ an Hapit Apo Jos hi nangarjana hi, ‘Hinuy pfato an namlenan hay hana khun mumpakhad hi pfalay Ja hijay numpfalin hi na-ahammad an pognad ni pfalay. ");
INSERT INTO ifu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hi Apo Jos chi nangat ay tay, Ja nakaskasda-aw hi pannikhan ta-o!’ ” ");
INSERT INTO ifu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Empa-opoh Hesus an nangali hay hato ja penhod hachi a-ap-apon chi Hudju an tiligwon hija. Ti anila cha an mipfuhur hinuy an pangngarig ay chicha an nan-ug ay Hesus. Muti agkhuy cha entoloy, ti temma-ot cha hachi cho-or an tatakhu. Amat hichi ja tenaynan cha hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gwacha hachi uchumna an Farisee ja Herodianes an hennag cha an immuy ay Hesus an i manoptopngan ta hehemmon cha un gway ehallaana ay ni atona an munhapit. ");
INSERT INTO ifu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Immuy cha ja inali cha ay Hesus hi, “Apo, anila mi an umannung hana khun mu allon anong un pahigwon chi tatakhu. Ti anong un nun-atakhay hana tatakhu an munchongor wenno nababa ja khun mu gwot itudtuchu hini umannung an podhon Apo Jos.” Ja khun cha hempfogpfogkhon an allon cha hi, “Hotti hay podhon mi adchiya an annilaon ja mapfalin chah ay ni urchin ta-o an Hudju nu mumpfajad ta-o hi pakha ay ni Emperador ad Rome? Ngay allom, pfajachan mi chah wenno achi mi?” ");
INSERT INTO ifu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Na-orman Hesus an un cha toptopngan hija ja inali na hi, “Anagkha ta toptopnganaꞌ? I-ali ju hay pihu an michat hi pakha ta tikhaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inchugwagwa cha han pihu ja inali na hi, “Ngay nang-angah ay tay gwa ay tay pihu? Ja ngay nang-enngachan ay tay an nitulaꞌ?” Ja inali cha hi, “Hini Emperador.” ");
INSERT INTO ifu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ja inalin khu Hesus hi, “Hotti ichat ju ay ni Emperador hini michat ay ni Emperador, ja inchat ju ay Apo Jos hini michat ay Apo Jos.” Un chaagkhu chengngor hichuy nampfar na ja nanor cha, ti agkhuy nehalla an nungkhokhodchong. ");
INSERT INTO ifu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Gwa hay hana uchumna an Saducee an immuy ay Hesus. Saducee ayya ja achi cha mamati an gway amahuwan. Ja inali cha ay hija hi, ");
INSERT INTO ifu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Apo, intulaꞌ Moses chi urchin ay chita-o an matoy ayya hini oha an lala-e an narhin ja ma-id empfalay na, ja mahapor an ahagwaon ni akhi na an lala-e hitay an pfupfai an napfalo, ta hana empfapfalay cha ja mipfilang an empfalay nuy natoy an ibpfa na. ");
INSERT INTO ifu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hotti gwacha han peto an hin-a-agkhi an linala-e. Narhin hitay panguluwan ja natoy an ma-id empfalay cha. ");
INSERT INTO ifu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hijaot un nepallog chin netob ta enahagwa na khu hitay an pfalo ja natoy khu an ma-id empfalay cha. Hotti nepallog khu chin me-atlo ");
INSERT INTO ifu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ja ingkhana chin me-apeto ja nun-atoy cha an amin an ma-id empfalay cha. Omaꞌ-angonoh ja ne-etoy hitay an pfupfai an napfalo. ");
INSERT INTO ifu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hotti nu allom chi gway amahuwan chi natoy ja ngacha mah ay cha tay an peto an linala-e chi nang-en-ahagwa ay tay pfupfai nu umali hini amahuwan chi tatakhu? Ti enahagwa cha mit an amin hitay an pfupfai.” ");
INSERT INTO ifu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tempfar Hesus ja inali na hi, “Nehalla aju ti ma-id anila ju ay ni Hapit Apo Jos ja hini apfalinana. ");
INSERT INTO ifu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mummahu ayya hana tatakhu ja achi cha mangah-ahagwa, an amat cha hay hana angher Apo Jos an achi mangahagwa. ");
INSERT INTO ifu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ja hini ayya amahuwan chi nun-a-atoy ja un ju chah agkhuy pfinaha chin nitulaꞌ an Hapit Apo Jos an chin nannikhan Moses chin ajiw an khun chumalang, ja inalin Apo Jos ay hija hi, ‘Ha-in chi Jos an khun dayawon Abraham, ja hi Isaak, ja hi Jakob.’ Inali na hitay anong un napfajag an nanattoy cha Abraham. ");
INSERT INTO ifu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","An hay podhona an hapiton ja hijay Jos hana mamattakhu an pfu-un Jos chi natoy. Nunnaud aju an nehalla nu ehaot ju hini amahuwan chi natoy.” ");
INSERT INTO ifu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Gwa han oha an mehtolon chi urchin Moses an niꞌtataꞌchug chin khun punhahappitan cha Hesus ja chin Saducee. Chengngor na an maphod chin nampfar Hesus ja inali na ay hija hi, “Apo, ngay ngachah nuy urchin Apo Jos an napfarpfalor hi unuchon?” ");
INSERT INTO ifu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tempfar Hesus ja inali na hi, “Hini urchin an allona hi, ‘Chonglon ju, chaꞌju an holag Israel. Un oh-ohha hini Apo ju an hi Apo Jos ja ma-id uchumna. ");
INSERT INTO ifu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mahapor an podhon ju hi Apo Jos hi an amin hi puhu ja nomnom ja pfi-ah ju ja an amin hi piꞌtakhuwan ju.’ ");
INSERT INTO ifu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hini me-aggwa ja, ‘Podhon ju hana padchung ju an takhu an amat ay ni pamhod ju ay ni achor ju.’ Ma-id chi uchumna an urchin an napfarpfalor mu hay hato.” ");
INSERT INTO ifu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ja inalin chin mehtolon chi urchin hi, “Umannung hini inalim, Apo. Un oh-ohha hi Apo Jos an ma-id uchumna. ");
INSERT INTO ifu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ja umannung khu an mahapor an podhon ta-o hija hi an amin hi puhu ja nomnom ja pfi-ah ja hi an amin hi gwa ay tay piꞌtakhuwan, ja penhod ta-o chi papadchung ta-o an takhu an amat ay ni pamhod ay tay achor. Napfarpfalor hay hato ay Apo Jos mu an amin chi animar an khun midaton ay hija ja hana uchumna an khun midaton.” ");
INSERT INTO ifu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Unot chengngor Hesus hitay nampfar na ja anila na an manomnom hichuy an lala-e ja inali na hi, “Niya an na-awatam, hotti nehnot hini pidchumam ay ni Pun-ap-apugwan Apo Jos.” Ja empokhong cha an munhanhan ti mun-okhon cha an mangpfokha hi uchumna. ");
INSERT INTO ifu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hi khun puntudtuchugwan Hesus hichi Templo ja inali na hi, “Hay khun itudtuchun hachi memehtolon chi urchin, ja hini Hennag Apo Jos an Mamahhod ja marpu hi holag Ari David. Anagkha nin ta allon cha hitay? ");
INSERT INTO ifu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti anong un hi Ari David ja enchalan ni Espiritu Santo ta intulaꞌ na hitay Hapit Apo Jos an nangarjana hi, ‘Inalin Apo Jos ay nuy tenangad u an Apoꞌ hi, “Umpfun a ay tay nun-appit hi agwan u, Ingkhana hi pangapfakaꞌ an amin hana pfuhur mu ta he-ay tangachon cha.” ’ ");
INSERT INTO ifu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Inalin Ari David ay tay Hennag Apo Jos an Mamahhod hi, ‘Apo’ ti napfagpfagto mu hija. Nu amat heto chi allon Ari David hotti hini hahadchon ju ja pfu-un la-eng holag David ja angkhay.” Ja hachi cho-or an tatakhu an nunchongor chin khun itudtuchun Hesus, ja penpenhod cha. ");
INSERT INTO ifu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Entoloy na an nuntudtuchu ja inali na hi, “Tikhagwun juwot niꞌ ta achi aju munchunu hay hana memehtolon chi urchin Moses. Ti hay hana ayya ja un cha mumpa-akhaja an munlopfong hi makhajad, ja podhon cha an gway khun mangpaꞌpa-innila ay chicha hi achoꞌlan chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ja am-amja-on cha khu an i umpfun hana umpfunan chi a-ap-apo hichi sinagoga ja nun gwachaan chi pfehta. ");
INSERT INTO ifu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ja pomloh cha hi khina-un chi pfalo ja khurkhulaton cha an manganchu-oy an mungkalalag ta allon kan kaykhu hana tatakhu hi nasantuwan cha. Hotti munnaud chi i cha adusaan khapo hay hato khun cha aton.” ");
INSERT INTO ifu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Inumpfun hi Hesus ay chuy nehnot hi khun cha pun-amungan hi pihu hichi Templo ja khuna titigkhan chin tatakhu an mangitto hi pihu. Cho-or chin a-achangjan an nangitto hi cho-or hi pihu. ");
INSERT INTO ifu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ja immuy han oha an napubli an pfalo ja niꞌjuy na han chugwa an hepeng. ");
INSERT INTO ifu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Enajakhan Hesus hay hachi disipolo na ja inali na hi, “Umannung hitay alloꞌ ay chaꞌju. Napfarpfalor hichuy it-ittang an inchat chuy napubli an pfalo mu an amin hana inchat chi uchumna. ");
INSERT INTO ifu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ti hay hachi achangjan ja khun cha mangchat muti un hini upag chi enachangjan cha chi khun cha ichat. Hichuy ayya an pfalo an napubli ja khapo hi pamhod na an mangchat ja inunghiw na an inchat hichuy pelaꞌ na.” ");
INSERT INTO ifu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Unagkhu gwa an makak cha Hesus hichi Templo ja inalin han oha an disipolo na hi, “Tikham, Apo, hitay Templo an mapmaphod ja napfarpfalongabpfingan, an o-otong hay hato pfato an apja na!” ");
INSERT INTO ifu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tempfar Hesus ja inali na hi, “Tayya an matikhaw ju hitay otong an Templo an napfarpfalongabpfingan, muti umali han arkhaw hot mun-ahagwer ja mun-egwa-at cha hay hato pfato an apja na.” ");
INSERT INTO ifu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nunti-id cha Hesus ay chuy pfulludna an ad Olibo an ni-a-adchumang chin Templo ja inumpfun. Immi-igway cha Peter ja hi James ja hi John ja hi Andrew an i niꞌhapit ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ja inali cha hi, “Apo, aꞌ-anunay pa-atan hay hato inalim? Ipa-innilam adchiya hay pangmatunan ay ni pa-atana.” ");
INSERT INTO ifu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tempfar Hesus ja inali na hi, “Tikhagwun ju gwot niꞌ ta achi aju ma-allilaw. ");
INSERT INTO ifu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ti cho-or chi umali an mangali hi, ‘Ha-in hini Hennag Apo Jos an Mamahhod’ ja cho-or chay mamati muti un cha mapfarpfalijan. ");
INSERT INTO ifu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nu chonglon ju an gway mungkhukhupfat hana nehegkhon an pfuglay ja ipa-innila cha khu an gway mungkhukhupfat hana nun-i-achawwi an pfuglay, ja achi aju tomakhaw. Ti mahapor an ma-at hay hato muti pfu-un pay hitay chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hay ma-at ja mungkhukhupfat chi apfuglapfuglay ja anong un hay hana nasyon. Ja gwachay khihu ton numpfino-ob-on an pfuglay, ja umali chi ulat. Muti hay hato ja un pay teꞌte-aan hana umali an punlikhatan heto lota. ");
INSERT INTO ifu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hotti chaꞌju an khun u tuchugwan ja pa-ennongan ju. Ti ijuy chaꞌju hana hugi ta echalom chaꞌju, ja ipahuplit chaꞌju hichi sinagoga. Ja ijuy chaꞌju hay hana gobernador ja ar-ari khapo hi nangunuchan ju ay ha-in, ja hinuy chi timpo an puntihtikhuwan ju ay chicha ay ni hapit u. ");
INSERT INTO ifu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja mahapor an mekasaba hitay Ebanghelyo an amin hi apfuglapfuglay ja un mapogpog hitay lota. ");
INSERT INTO ifu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nu tiligwon chaꞌju ja enchalom chaꞌju ja achi aju madanakhan hi hay aton ju an manongpfatan ay chicha. Ti ay nuy an timpo ja ituchun Apo Jos hay ehongpfat ju. Hot pfu-un chaꞌju ja angkhay chi munhapit, an hini Espiritu Santo chi mangchalan ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Ay nuy an timpo ja pfuhulon chaꞌju an amin hi tatakhu khapo hi nangunuchan ju ay ha-in. Hana uchumna ja anong un hana a-akhi cha ja epfaag cha hana a-ap-apo ta patajon cha. Amat khu hina chi aton ni oha an ammod hay empfalay na. Ja hana ungunga, chuꞌkhon cha hana a-ammod cha ja empapatoy cha chicha. Muti hana mangedpor hay hato ingkhanah atajan cha an achi cha epfot hini pammati cha, ja miꞌtakhu cha.” ");
INSERT INTO ifu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Entoloy Hesus an nangali hi, “Unchani hot tikhan ju hini na-ali-ali an ‘Pumapaꞌ-i an Apfopfohor hi Pannikhan Apo Jos’ an immuy agkhu niꞌ ta i tumaꞌchug hichi Templo an agkhuy nechaag hi i na oma-ayyan. Chaꞌju an khun mumpfaha, mahapor an ma-awatan ju. Nu pfumutay hitay na-ali an Pumapaꞌ-i hot lomajaw hana gwa ad Judea ta umuy cha hichi pfuludna. ");
INSERT INTO ifu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hini takhu an gwa hi partug nuy pfalay na ja achi agkhu i humikhop ta alaonay khina-u na, ta un atoꞌtogna ja empacheh na an lomajaw. ");
INSERT INTO ifu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ja hini takhu an gwa hichi pajaw ja achi na ihi-ar an umanamut an i mangala hi uchumnah lopfong na ta un atoꞌtogna ja lemmajaw. ");
INSERT INTO ifu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Munnaud aju an malikhatan ay nuy an timpo, om-omod hay hana numpunhapfin ja hana khun mumpahuhu! ");
INSERT INTO ifu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mungkalalag aju ta ma-at ayya hay hato ja achi metongor hi ahitungnin. ");
INSERT INTO ifu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti nete-a chin na-apjaan tay lota ja ingkhana ad ugwani ja ma-id chi hay immali hi likhat hi miꞌpadchung ay tay umali an munlinapoh an likhat. Ja anong un hi uchum chi arkhaw ja ma-id ma-at hi likhat an amat heto. ");
INSERT INTO ifu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma-umah an amin chi tatakhu nu agkhuy koma inhumang Apo Jos an mangpahoꞌhoꞌchod ay ni timpo an punlikhatan cha. Hoꞌhoꞌchochona khapo hi khohkhoh na hay hana tatakhu an pinili na. ");
INSERT INTO ifu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nu khulat ta gway mangali hi ‘Tayya hini Hennag Apo Jos an Mamahhod!’ wenno ‘Chuyya hija’ ja achi ju pattiyon. ");
INSERT INTO ifu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ti gwacha hana pfumarpfali an mangali hi un chicha anu hini Hennag Apo Jos an Mamahhod, ja uchumna ja allon cha hi chicha anu chi profetan Apo Jos. Gway apfalinan cha an mangat hi numpfino-ob-on an milagro ta mapfalijan chi tatakhu, anong un hana tatakhu an pinilin Apo Jos nu apfalinan cha an aton. ");
INSERT INTO ifu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hotti pa-ennongan ju, ti tayya an impa-innilaꞌ an amin hay hato ja un cha ma-at.” ");
INSERT INTO ifu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Entoloy Hesus an nangali hi, “Mahiꞌnut an ma-at hay hato an likhat an inaliꞌ hot homelong hichuy hukhit ja achi khu humilaw hichuy pfulan. ");
INSERT INTO ifu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Makiharpfu ad uchu hot mun-a-akhah hachi pfittuwan. ");
INSERT INTO ifu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ay nuy an timpo ja tikhanaꞌ an Na-ilangitan an Takhu, marpuwaꞌ ad langit an midchum hi pfonot. Magwachaanaꞌ hi pfinang ja munnaud chi apfalinaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ja honakhoꞌ hana angher u an umuy ay tay nunleneꞌgwoh tay lota ta amungon cha hana tatakhu an piniliꞌ an amin hi apfuglapfuglay.” ");
INSERT INTO ifu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Inalin khu Hesus hi, “Nomnomon ju hini ajiw an higos ti gwa han epa-achar na. Ti hini ayya higos, nu tikhan ju an umughoꞌ ja tumupfu hot ma-innila an nehnot hini tijarkhaw. ");
INSERT INTO ifu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Amat hina khu, nu tikhan ju an khun ma-at hato inaliꞌ, hot ma-innila ju an nehnot hini pumpfangngachaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Umannung hitay alloꞌ an achi pay matoy an amin chi tatakhu ay tay an himpangapo hot ma-at an amin hay hato inaliꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hitay lota ja ad uchu ja ma-upfah cha, muti achi ma-ub-upfah hitay hapit u.” ");
INSERT INTO ifu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Entoloy Hesus an nangali hi, “Ma-id oh-ohhah nanginnila ay ni arkhaw wenno oras an pumpfangngachaꞌ, anong un hana angher Apo Jos ja ha-in an Empfalay na. Angkhay hi Jos Ama chi nanginnila. ");
INSERT INTO ifu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hotti peꞌhehemad ju ja niꞌhahalichit ju, ti agkhuy ju anila hini timpo an pumpfangngachaꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hay omaꞌ-atan chi pumpfangngachaꞌ ja amat hi takhu an munhakhana an i mumpfaat. Ipulang na ay cha nuy takhala na hini pfalay na ta gwahchinonon hon anila nay peꞌ-at na. Ja inali na ay ni oha ta pfapfabpfantajana hini pantaw. ");
INSERT INTO ifu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Amat hina khu ay chaꞌju an peꞌhehemad ju, ti agkhuy ju anila hini timpo an pumpfangngachaꞌ an Apo ju, nu mahihilip, tongan chi lapfi, tumalanu, wenno hi herhelong. ");
INSERT INTO ifu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ti nu himpfumagkha ja gwachaaꞌ, ja maphod nu achi chaꞌju ah-upan an nanalloꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hotti hitay inaliꞌ ay chaꞌju ja alloꞌ an amin hi tatakhu ta munhahagkhana cha ay ni pumpfangngachaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chugway arkhaw hi malahin ja un machakngan chin penghan chi arkhaw chin Pfehta an Panganan cha hi Tenapay an Ma-id Pfinoꞌpfoꞌ Na, ja arkhaw an pangnomnoman hachi Hudju chin Nalohan Chin Angher Apo Jos. Hachi a-ap-apon chi papachi ja chin memehtolon chi urchin, ja nunhahapit cha hay aton cha an maniliw ay Hesus ta ma-id manginnila ta epapatoy cha. ");
INSERT INTO ifu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ja inali cha hi, “Achi ta-o koma etongor ay tay umali an pfehta an achoꞌlan chi tatakhu, ti unchani ja chumalat hi pumpapattajan chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hichin agawwachaan cha Hesus ad Betani hi pfalay Simon an oha an na-unit an enakhahan Hesus, ja khun cha mangan hi himmigpan han pfupfai. Inu-ugnana han alabastro an pfoterja an nittugwan chi naꞌ-angngina an lanob an allon cha an nardo. Nehnot chin pfupfai ay Hesus ja entoꞌgwab na chin pfoterja ja unaot ihiit chin lanob ay chuy ulun Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lemmallataꞌ hachi uchumna an nangmomodhong ay chuy enat na ja hingupfungupfu cha an mangali hi, “Ay-ayyu a mah hichuy an lanob an una am-amhan. ");
INSERT INTO ifu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Munnaud an nangina hichuy an lanob an pfoꞌlaon hi ohay tagwon. Uchuꞌchuna agkhu niꞌ una ingngina ta ichat na hini pfajad na hay hana napubli.” Ja khun cha amujuwan chin pfupfai. ");
INSERT INTO ifu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Muti nunhapit hi Hesus ja inali na hi, “Achi ju amujuwan hija! Khegkhenong aju ta ikhad hija, ti pfuher hitay enat na ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hana ayya publi ja gawwacha cha ay chaꞌju hi a-arkha-arkhaw ja mapfalin an tulungan chicha hi kompormi an arkhaw. Ha-in ayya ja nehnot chin arkhaw an panaynaꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hitay an pfupfai ja enat na hini mapfalina an peꞌ-at. Ti inhiit na ta lanob ay tay achor u ta memehhod ay ni umali an pilub-aꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Umannung hitay alloꞌ. An amin chi omajan hana mangkaskasaba ay ni Ebanghelyo ay tay nunleneꞌgwoh tay lota, ja pigpiggwon cha hitay enat tay pfupfai ta achi malidlichuwan.” ");
INSERT INTO ifu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amat hichi ja immuy hi Judas Iskariot, an oha ay cha chuy himpolo ta chugwa an adalan Hesus, an i nangali hay hachi a-ap-apon chi papachi hi e-agwat na hi Hesus ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nun-an-anla cha an nangngor ja inali cha hi ichat cha hay pihu an lagpfu na. Hotti henehemmon Judas hay atona an mangtuchu ay Hesus ta tiligwon cha. ");
INSERT INTO ifu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nachakngan chin penghan chi arkhaw chi Pfehta an Panganan cha hi Tenapay an Ma-id Pfinoꞌpfoꞌ Na, ja hichuy chi khun cha pumpartiyan hi pfoꞌtot an karnero an pangnomnoman cha chin Nalohan Chin Angher Apo Jos. Immuy hachi adalan ay Hesus ja inali cha hi, “Ngay podhom hi i mi punhakhanaan ay ni anganan ta-o ay tay pfehta?” ");
INSERT INTO ifu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hennag Hesus han chugwa ay chicha ja inali na hi, “Umuy aju ad Jerusalem. Chittumon chaꞌju han lala-e an nangpipi-ug han pun-otanan, ja unuchon ju ");
INSERT INTO ifu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ay ni pfalay an i na humigpan, ja allon ju ay ni nunheto hi, ‘Inalin ni Apo ta-o hi chaad mah anu hini kwarto an panganana an peꞌ-anan mi an adalana ad ugwani an pfehta.’ ");
INSERT INTO ifu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hot hini nunheto ay nuy an pfalay ja ituchu na hini nangennaꞌjab an otongngan an kwarto an gwah chi an amin chi mahapor. Ja hichi chi punhakhanaan ju ay ni anganan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Empacheh chin chugwa an adalan an umuy ad Jerusalem ja immannung an amin chin inalin Hesus. Ja enhakhana cha chin anun cha ay chuy an pfehta an i cha Pangnomnoman chin Nalohan chin Angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Unagkhu nadhom ja immuy cha Hesus hachi himpolo ta chugwa an adalana ay chuy an pfalay. ");
INSERT INTO ifu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Khun cha mangan ja inalin Hesus hi, “Umannung hitay alloꞌ ay chaꞌju, an gwa han oha ay chaꞌju an neꞌ-o-orpfong an i mangpfaag ay ha-in hana pfuhur u.” ");
INSERT INTO ifu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Magkhoh hi punleꞌnaan hachi adalan ay chuy inalin Hesus ja un gwahchinonon hon at hi mangpfokha hi, “Apo, un chah ha-in hini allom an mangat?” ");
INSERT INTO ifu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tempfar Hesus ja inali na hi, “Ohanna ay chaꞌju an himpolo ta chugwa chi mangngina ay ha-in. Khun meꞌhawhaw ay ha-in hi tenapay ay tay chuju. ");
INSERT INTO ifu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ti ha-in an Na-ilangitan an Takhu ja matojaꞌ an matoy ta mipa-annung chin impatulaꞌ Apo Jos hachi profeta chin hopapna. Muti ka-ahi hini mangngina ay ha-in. Toꞌ-onot un agkhuy netoꞌkhong hija!” ");
INSERT INTO ifu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gwa an khun cha mangan ja unot alan Hesus han tenapay ja nunyaman ay Apo Jos ja initta-ittang na. Ja enggwanah na chin adalan ja inali na hi, “Anun ju, ti hitay hini achor u.” ");
INSERT INTO ifu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ja enala na khu hini pfahu an nittugwan hi chanum chi ubas. Nunyaman ay Apo Jos ja inchat na ay chicha ta hiniꞌ-itangon cha an inumon. ");
INSERT INTO ifu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ja inali na hi, “Hijah tay hini chalaꞌ an mangpa-annung hi neꞌtobpfalan Apo Jos ay chaꞌju. Umajuh hitay chalaꞌ ta gway aton chi pfahor hana cho-or an tatakhu an mapakawan. ");
INSERT INTO ifu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alloꞌ ay chaꞌju hi hitay chi ang-angonohna hi piꞌ-inumaꞌ hi chanum chi ubas ingkhanah chin arkhaw an panginumaꞌ ay ni nat-on an chanum chi ubas ay nuy Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Emmopoh hitay inalin Hesus ja engkanta cha han ohan Psalm ja un chaot epacheh an umuy hichi pfulludna an ad Olibo. ");
INSERT INTO ifu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Inalin Hesus chin adalana hi, “Anilaꞌ an te-a-anaꞌ ay chaꞌju an amin. Ti allona ay ni Hapit Apo Jos hi, ‘Patajoꞌ hini khun mumpahtor hot mahihijaꞌ an amin hay hana karnero.’ ");
INSERT INTO ifu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Muti nummahuwaꞌ ayya ja ipanguluꞌ an umuy ad Galilee ta hichi punchichittuman ta-o.” ");
INSERT INTO ifu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ja inalinot Peter hi, “Anong un chi-a taynan hato uchumna an adalan ja achiꞌ taytaynan he-a.” ");
INSERT INTO ifu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ja inalin Hesus ay hija hi, “Umannung hitay alloꞌ. Ehaotaꞌ ay he-a hi mumpitlo ad ugwani an lapfi ja unot mumpiggwa an tumalanu han agwitan.” ");
INSERT INTO ifu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Muti impapilit Peter an nangali hi, “Achiꞌ ehaot he-a, anong unaꞌ me-etoy.” Ja amat khu hina chin inalin an amin hachi adalan. ");
INSERT INTO ifu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Amat hichi ja immuy cha Hesus han lukhar an nangadnan hi Getsemane, ja inali na chin adalana hi, “Mehetay aju ta umujaꞌ mungkalalag.” ");
INSERT INTO ifu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Muti initnud na hi Peter ja hi James ja hi John. Munnaud an munchokhoh hi punnomnomana, ");
INSERT INTO ifu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","hotti inali na ay chicha hi, “Ma-id ay chita an munnaud an machamot hi punleꞌnaaꞌ ja tan omataꞌ hi matoy. Hotti mehetay aju ja achi aju agkhu maloꞌ ta un aju miꞌtu-ar ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nakhibpfoh chin inali na ja pfinumtaw an i nunheppe an nungkalalag ta nu mapfalin ayya ja achi na koma hoꞌmon hini umali an punlikhatana. ");
INSERT INTO ifu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Inali na hi, “Ama, mapfalin mu an aton an amin hini penhod mu, hotti nu mapfalin ja ergwangaꞌ ay nuy umali an apalikhataꞌ. Muti pfu-un hini podhoꞌ chi ma-at ta hini podhom.” ");
INSERT INTO ifu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Numpfangngad hi Hesus chin agawwachaan chin tolo an adalana ja chinakngana chicha an nanalloꞌ. Ja inali na ay Peter hi, “Simon, un a chah agkhu naloꞌ? Un chah achi mapfalin an miꞌtu-ar a ay ha-in hi ohay upfun mah niꞌ? ");
INSERT INTO ifu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Achi aju agkhu maloꞌ ta un aju gwot meꞌkalalag ta achi aju ma-apfak nu matopngan hini pammati ju. Ti anilaꞌ an ay ni nomnom ju ja podhon ju an miꞌ-unud muti ma-id olog ni achor ju.” ");
INSERT INTO ifu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Amat hichi ja immuy an i khu nungkalalag ay Apo Jos ja piniggwa na chin engkalalag na. ");
INSERT INTO ifu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Numpfangngad khu hi agawwachaan cha chuy tolo an adalan ja chinakngana chicha an nanalloꞌ, ti achi medpor chin enloꞌ cha. Pfimma-in cha ja ma-id maptoꞌ hi pampfar cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hotti hin-immuy khu hi Hesus an i nungkalalag. Ja chin petlon chi numpfangngachana ja inali na hachi adalan hi, “Hot anagkha mah un aju agkhu mamalloꞌ ja mun-en-enana? Ammuna akay niꞌ hini enloꞌ ju, ti toja an nachakngan hitay timpo an eneꞌchan Apo Jos hi ipulangaꞌ an Na-ilangitan an Takhu ay cha nuy napfahulan an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lomeggwat aju, ti chuja an umali hichuy nangngina ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Khun pay munhapit hi Hesus ja emmatamot hi Judas, an oha ay cha chuy himpolo ta chugwa an adalan, an impfupfulog na hachi cho-or an tatakhu an numpumpfangid ja numpumpang-or cha. Hay nannag ay chicha ja chin a-ap-apon chi papachi ja chin memehtolon chi urchin Moses ja chin uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja intudtuchun Judas han pangmatunan cha ay Hesus, an hini takhu an agwalona ja hija chi tiligwon cha ta gwarjaan cha an ekak. ");
INSERT INTO ifu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hotti un chaot emmatam ja immuy hi Judas ta enagwar na hi Hesus ja inali na hi, “Apo!” ");
INSERT INTO ifu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ja nehom hachi numpun-ibpfa na an i numpangugnan ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Henoꞌnot chin oha an niꞌtataꞌchug ay Hesus chin pfangid na ja impakhit na chin takhalan chi natakhay an pachi hotti nakhingahan chin inga na. ");
INSERT INTO ifu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja inalin Hesus hachi tatakhu hi, “Unaꞌ chah ngumangannu ta numpfapfangidaju ja numpun-ochon aju hi pang-or an immali an mampap ay ha-in? ");
INSERT INTO ifu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A-arkha-arkhaw ja gawwacha ta-o an amin hichi Templo hi khun u puntudtuchugwan ja agkhujaꞌ tiniliw. Mahapor chamchama an mipa-annung hana nitulaꞌ an Hapit Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nakhibpfoh hitay an inalin Hesus ja nahijaꞌ hachi adalan ja nataynan hija. ");
INSERT INTO ifu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Gwa han unga an lala-e an khun mangunud ay cha Hesus an nun-u-uloh ja angkhay. Lenom hachi tatakhu an tiligwon hotti linapchuꞌ cha chin uloh na. ");
INSERT INTO ifu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ja at hi nangepolag chin uloh hotti lemmajaw an nummomolleh. ");
INSERT INTO ifu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nun-ugnan cha hi Hesus ja in-uy cha ay ni pfalay chin natakhay an pachi. Hichi chi na-amungan an amin chi a-ap-apon chi papachi ja memehtolon chi urchin Moses ja chin uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Khun mangun-unud hi Peter ingkhanah emmatam chin partug chin pfalay chuy natakhay an pachi. Ja ni-ipfun ay cha chuy gwarja an miꞌ-anichu. ");
INSERT INTO ifu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chin a-ap-apon chi papachi ja an amin chin numpun-ibpfa cha an membron chi Sanhedrin, ja henehemmon cha hay panghiꞌ-ingan cha an pamatajan ay Hesus muti ma-id chinakngan cha. ");
INSERT INTO ifu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ti cho-or chi nunlahlah an nuntihtikhu an nangpeꞌla hi pfahor Hesus, muti agkhuy numpapadchung chin inali cha. ");
INSERT INTO ifu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gwacha hachi uchumna an munlahlah an timmaꞌchug ta tihtikhuwan cha ");
INSERT INTO ifu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","an chengngor cha an inalin Hesus hi, “Paꞌ-iyoꞌ hini Templo an henaꞌ-ad chi tatakhu, muti un umuy chi toloh arkhaw hot ehaꞌ-ad u hay oha hi mepallog an pfu-un takhuy nangephod.” ");
INSERT INTO ifu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Muti anong un chicha ja achi mumpapadchung chin inali cha. ");
INSERT INTO ifu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hotti timmaꞌchug chin natakhay an pachi ay chuy gawwachaan cha ja inali na ay Hesus hi, “Anagkha ta achi a tompfar? Ngay pampfar mu hay hato epapfahor cha ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Muti khemmegkhenong hi Hesus. Ja inalin khu chin natakhay an pachi hi, “He-a chah hini Mamahhod an Empfalay ni madaydayaw an Jos?” ");
INSERT INTO ifu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tempfar Hesus ja inali na hi, “Umannung hinuy inalim, ja umali han arkhaw an panikhan ju ay ha-in an Na-ilangitan an Takhu an mi-i-ibpfun ay ni nun-appit hi agwan Apo Jos an Napfagpfagtuwan. Ja tikhanaꞌ khu hi pumpfangngachaꞌ an marpu ad uchu an midchum hi pfonot.” ");
INSERT INTO ifu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Amat hichi ja hinaꞌ-in chin natakhay an pachi chin lopfong na khapo hi pfungot na. Ja inali na hachi tatakhu hi, “Tayya an chengngor ta-o hitay inali na an ipadchung na hini achor na ay Apo Jos. Hotti un chah khahin khu un gway muntihtikhu? Ngay allon ju tugwali?” Ja inapfulut cha an amin an gway pfahor na hotti mahapor an matoy hija. ");
INSERT INTO ifu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ja ente-an hachi uchumna an manuppaan chin angah na ja inukupan cha chin mata na. Nunhuntuk cha hija hon inali cha hi, “Nu profeta a, pfugwaom adchiya nu nga cha nuy nanuntuk ay he-a.” Ja nunlaꞌlaꞌ hachi gwarja ja nunhoplat cha hija. ");
INSERT INTO ifu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ay chuy an ni-i-ibpfunan Peter chin partug chuy pfalay ja naloh han pfalahang an takhalan chi natakhay an pachi. ");
INSERT INTO ifu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Unaagkhu tinnig hi Peter an niꞌ-a-anichu ja emmomohchong na ja inali na hi, “Oha a jaꞌ an khun mitnud ay Hesus an eNazaret.” ");
INSERT INTO ifu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Enhaot Peter ja inali na hi, “Pfu-un mangkay! Achiꞌ anila ja achiꞌ ma-awatan hinuy khun mu allon.” Amat hichi ja empacheh na an umuy hichi pingngit chin partug. Ja timmalanu han agwitan. ");
INSERT INTO ifu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hintinnig khu chin pfalahang hi Peter ja inali na hachi niꞌtataꞌchug hi, “Hitay an lala-e, ja hija chi oha an khun mitnud ay cha Hesus.” ");
INSERT INTO ifu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ja hen-enhaot khu Peter. Unot achi mapfajag ja inalin hachi niꞌtataꞌchug ay hija hi, “Umannung an nidchum a ay chicha, ti un a chah pfu-un eGalilee?” ");
INSERT INTO ifu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ja enhaot khu Peter an inali hi, “Pfu-un numpay! Anong ja dusaonaꞌ ay Apo Jos hi un lahlah hitay alloꞌ, ti agkhuy u anila hinuy an takhu an khun ju hapiton!” ");
INSERT INTO ifu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ja ay chuy gwot ja impiggwan chin agwitan an timmalanu, ja nenomnom Peter chin nangarjan Hesus ay hija hi, “Ehaotaꞌ hi mumpitlo ad ugwani an lapfi ja un mumpiggwa an tumalanu han agwitan.” Ja achi anhan chin kilan Peter khapo hi tutuju na. ");
INSERT INTO ifu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chin mun-agwagwa-ah ja na-amung chin a-ap-apon chi papachi ja memehtolon chi urchin Moses ja chin uchumna an a-ap-apon chi Hudju, ja an amin chin Sanhedrin ta nunhahapit cha hay i cha aton ay Hesus. Napfalin ja pinawwid cha hi Hesus ja in-uy cha ay chuy Gobernador an hi Pilato ta mahumarja. ");
INSERT INTO ifu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ja empfokhan Pilato ay Hesus hi, “Un chah he-a hini Arin chi Hudju?” Tempfar Hesus ja inali na hi, “Ti niya mah an inalim.” ");
INSERT INTO ifu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ja cho-or chi empapfahor hachi a-ap-apon chi papachi ay Hesus, ");
INSERT INTO ifu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ja inalin khu Pilato hi, “Tayya an chengngor mu an amin hay hato chiklamu ay he-a ja un mu chah achi topfalon?” ");
INSERT INTO ifu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Muti agkhuy tenomtompfar hi Hesus ja nanor hi Pilato. ");
INSERT INTO ifu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hay khun aton Gobernador Pilato hi un Pfehtan Chin Nalohan Chin Angher Apo Jos, ja emmengha ay hija an khun mangpfu-aan hi oha hi nipfalud an piliyon hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ay chuy an timpo ja cho-or cha hachi nipfalud, ti gway penatopatoy cha chin neꞌpapattajan cha hi khupferno, ja hi Barabas chi oha ay chicha. ");
INSERT INTO ifu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ja inalin hachi tatakhu ay Pilato ta ipfu-aana hay ohah pfalud ti hijah tay chi empa-engha na an aton. ");
INSERT INTO ifu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ja inalin Pilato hi, “Penhod ju chah an ipfu-aaꞌ hitay Ari ju an Hudju?” ");
INSERT INTO ifu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Inali na hitay ti anila na an hachi a-ap-apon chi papachi chi nang-agwat ay Hesus khapo hi ámoh cha, ja podhona khu an chonglon hay piꞌ-alin hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Muti chin a-ap-apon chi papachi ja enchokhochokhor cha hachi tatakhu ta allon cha ay Pilato hi Barabas chi mipfu-aan an pfu-un hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Himmapit khu hi Pilato ja inali na hi, “Nu amat hina ayya ja ngay allon ju hi atoꞌ ay Hesus an allon ju an Ari ju an Hudju?” ");
INSERT INTO ifu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ja hi-u-ugwap cha an nangali hi, “Epepfakhat mu hi kros!” ");
INSERT INTO ifu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ja inalin Pilato hi, “Anagkha? Ngay tugwali pfahor na?” Muti en-ar-alla cha an nangiꞌgwap hi, “Epepfakhat mu!” ");
INSERT INTO ifu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hotti inunud Pilato chin inali cha ti podhona an pa-anlaon chicha. Impfu-aana hi Barabas muti hi Hesus ja impahuplit na ja impulang na hachi hinchalo na ta i cha epfakhat hi kros. ");
INSERT INTO ifu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Initnud hachi hinchalo hi Hesus an inhikhop chin pfalay chi gobernador ja inamung cha an amin chin nun-ibpfa cha an hinchalo. ");
INSERT INTO ifu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Linupfungan cha hi Hesus han lopfong an mumpfolah an amat hi lopfong chi ari. Ja pfenalengawngaw cha han pagwit ja impihuꞌlub cha ay chuy ulun Hesus an amat hi korona. ");
INSERT INTO ifu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ja ente-a cha an kekejan hi khun cha pangarjan hi, “Madaydayaw a, he-a an Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ja numpakhuh cha chin ulu na ja nuntuppaan cha hon tenangkhatangkhaan cha hon nunheppe cha an nundayaw ay hija. ");
INSERT INTO ifu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Himmikha cha an nangekejan ay hija ja enaan cha chin impilopfong cha an mumpfolah ja empallog cha chin lopfong na. Ja initnud cha an i epfakhat hi kros. ");
INSERT INTO ifu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hi khun cha omajan ja chinittum cha han hi Simon an umuy ad Jerusalem. ECyrene hi Simon ja empfalay na cha Alexander ja hi Rufus. Impapilit chin hinchalo an pi-ukhon Simon chin kros Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ja entoloy cha an umuy ay chuy pfulludna an nangadnan hi Golgota, an hay podhona an allon ja pfulludna an amat hi ulun chi paang. ");
INSERT INTO ifu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Emmatam cha ja allon chaot ta ipa-inum cha ay Hesus han pfajah an nidchuman hi mira ta poh-onay chokhoh hi pangpfakhatan cha ay hija. Muti achi penhod Hesus an inumon. ");
INSERT INTO ifu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Amat hichi ja empfakhat cha. Ja numpfepfeleng hachi hinchalo ta machotoꞌ hay mumpangala hachi lopfong Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nungkhagwa chin nangpfakhatan cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ja gwa han neꞌpfakhat cha chin kros na an natutula-an ay ni chiklamu cha ay hija, an hay nitulaꞌ ja “Hitay hini Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ja gwacha khu han chugwa an lala-e an napfahulan an neꞌchehhan an nepfakhat, hotti nun-appiton cha hi agwan Hesus chin oha, ja nun-appit hi ikhid chin oha. ");
INSERT INTO ifu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hotti nipa-annung chin Hapit Apo Jos hi nangarjana hi, “Niꞌpfilang cha hini Hennag Apo Jos an oha an napfahulan.” ");
INSERT INTO ifu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gwa hachi tatakhu an naloh ja munggwiggwikhigwig cha hon pinahiw cha hi Hesus an inali cha hi, “Un mangkay tugwali he-a hini nangali hi paꞌ-iyom hini Templo muti un umuy chi toloh arkhaw ja ehaꞌ-ad mu khu! ");
INSERT INTO ifu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hot chaadma mah hini apfalinam ta takhuwom hini achor mu ja nun-opah a ay nuy an kros!” ");
INSERT INTO ifu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Amat khu hina ja tenangkhatangkhaan chin a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses an khun cha allon hi, “Tinakhu na hana uchumna an tatakhu muti ma-id olog na an manakhu ay chuy achor na. ");
INSERT INTO ifu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tikhan ta-o adchiya hitay Hennag Apo Jos an Arin hato holag Israel, nu mun-opah ay tay kros ta gway aton ta-o an mamati ay hija.” Anong un chin chugwa an neꞌpfapfakhat ja khun cha piꞌpahiw hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Unagkhu gwa an nahaꞌ-ad ja himpfumagkha ja hemmelong an amin ay chuy an lota ingkhana hichin napujaw. ");
INSERT INTO ifu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ja chin napujaw ja unagkhu la-ahna ja nun-ugwap hi Hesus an nangali hi, “Eloi, Eloi, lama sabachtani?” an hay podhona an hapiton ja, “Jos u, Jos u, anagkha ta tene-a-anaꞌ ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chengngor hachi uchumna an niꞌtataꞌchug hichuy an iniꞌgwap na ja inali cha hi, “Niya an khuna ajakhan hi Elijah an manakhu ay hija.” ");
INSERT INTO ifu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chin oha ja temmagtag an i emmala han omaꞌ-at hi apoh ja entamor na han pfimmanger an pfajah, ja empa-aw na han paor. Immuy ay chuy kros ja intumuꞌ na chin ta-on Hesus ta inumona. Ja inali na hi, “Khenong adchiya tugwali ta tikhan ta-o hu-un umali hi Elijah an mangpah ay hija!” ");
INSERT INTO ifu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ja nun-ugwap hi Hesus ja na-ongoh chin hochohcha na. ");
INSERT INTO ifu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ja hichi Templo ad Jerusalem ja himpfumagkha ja na-ittang chin ma-uꞌtor an kurtina an nanahhalin ay chuy Na-assantuwan an Kwarto, nete-a chin uhuna ja chimmapoh chin puuna. ");
INSERT INTO ifu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ja unot tinnig chin kapitan chi hinchalo an nanahhangot ay Hesus chin enat na an natoy ja inali na hi, “Umannung ay chita an Empfalay Apo Jos hitay an takhu!” ");
INSERT INTO ifu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ja gwah chi hachi uchumna an pfinapfai an nenebtaw an nannig chin natajan Hesus. Ja nidchum cha Mary Magdalen ja hi Salome, ja hi Mary an ammod cha James ay Joses. ");
INSERT INTO ifu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chicha hana ninitnud ay Hesus nete-a chin agawwachaana ad Galilee an khun tomolong ay hija. Ja gwah chi khu chin cho-or an pfinapfai an ninitnud ay Hesus chin immajana ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hichuy an arkhaw ja Alemana an Punhakhanaan hachi Hudju ay ni Hapfachu an khun cha ngilinon. Gwa han hi Josep an e-Arimatea, an oha an malihpito an membron chi Sanhedrin, ja oha khu an mamannod ay ni Pun-ap-apugwan Apo Jos. Unot gwa an mahilip ja jinagjag na chin ta-ot na ja immuy ay Pilato an i nangippug ta i na ilupfuꞌ chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nanor hi Pilato chin nangngolana an natojagkhu gwot hi Hesus, hotti empapfokha na chin kapitan chi hinchalo ta i na emamad un umannung. ");
INSERT INTO ifu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Unot chengngor Pilato chin inalin chin kapitan an natoy hi Hesus ja inapfulut na an opahon Josep chin achor na. ");
INSERT INTO ifu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Amat hichi ja immuy hi Josep an i ngimmina hi maphod an pfinacha ja i na empah chin achor Hesus. Pinuttiputana ja unaot ipahikhop han linijangan cha an lupfuꞌ. Ja inulina han otong an pfato ja intanglib na ay chuy lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ja gwah chi khu cha Mary Magdalen ja hi Mary an ammod Joses, ja tinikhaw cha chin i nanglub-an Josep chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chin nahilip an nalahin chin ngilin ja immuy cha Mary Magdalen ja hi Mary an ammod James ja hi Salome an i ngimmina hi mumpfango an lanob ta elanob cha ay chuy achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hotti chin nun-inggwiꞌgwiit an Markhachu ja pfimmugwah cha an immuy hi lupfuꞌ ja ne-atam cha hi gwa an hurhulajap chin hukhit. ");
INSERT INTO ifu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ja khun cha munhahapit an nangali hi, “Ngacha mah taꞌgway mangulin chin pfato an tanglib ni lupfuꞌ?” ");
INSERT INTO ifu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti khun cha nomnomon an otongngan chin tanglib. Emmatam cha ja un chaagkhu menohgwat ja nangalimutugwan cha an nipapaꞌ-igwin chin tanglib. ");
INSERT INTO ifu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Un chaagkhu himmikhop ja tinnig cha han unga an lala-e an inu-umpfun hi nun-appit hi agwan cha an nunlolopfong hi mapuchaw. Ja temma-ot hachi pfinapfai. ");
INSERT INTO ifu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ja inalin chin lala-e ay chicha hi, “Achi aju tomakhaw. Anilaꞌ an khun ju hingiton hi Hesus an eNazaret an empfakhat cha chin kros. Ma-id heto ti nummahu! Tayya chin nanggwagwallangan cha chin achor na. ");
INSERT INTO ifu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hotti un aju gwot umuy ay ni gwachaan cha Peter ja hana uchumna an disipolo na ta allon ju hi, ‘Ipangulun Hesus an umuy ad Galilee ta hichi chi i ju panittuman ay hija, amat heto khu chin inali na ay chaꞌju.’ ” ");
INSERT INTO ifu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Temmakhaw hachi pfinapfai ja higwogwoggwog cha hi ta-ot cha, hotti pfimmutay cha hichi lupfuꞌ ja lemmajaw cha. Ja ma-id i cha nangarjan ay tay tinnig cha, ti temma-ot cha. ");
INSERT INTO ifu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nummahu hi Hesus chin Chumingkhu hi herhelong ja hay nahhun hi numpatikhagwana ja hi Mary Magdalen, chin pfupfai an nangpakakan Hesus chin peto an napukhit an ispiritu an nehohoꞌlong. ");
INSERT INTO ifu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Empacheh Mary an i mangpa-innila hay hachi numpun-ibpfan Hesus ja chinakngana chicha an khun kumila khapo ay chuy natajan Hesus. ");
INSERT INTO ifu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ay chuy nangngolan cha an timmakhu hi Hesus an tinnig Mary ja agkhuy cha pinati. ");
INSERT INTO ifu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chin me-aggwa an numpatikhagwan Hesus ja han chugwa an disipolo an khun chumalan an umuy hichi pfarju. Muti chin pengpenghana ja agkhuy cha immatunan, ti nat-on chin tikhaw na. ");
INSERT INTO ifu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Un chaagkhu inannila an hija hi Hesus an nummahu ja numpfangngad cha ad Jerusalem ta i cha impa-innila hachi uchumna an disipolo, muti achi cha chamchama pattiyon. ");
INSERT INTO ifu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Napfalin ja immuy khu hi Hesus chin agawwachaan chin himpolo ta oha an adalan ja metongor hi khun cha anganan. Inhingar na chicha ti un ma-id pammati cha ja pfimmato chin nomnom cha, ti un cha achi pattiyon chin inalin hachi nannig ay hija an nummahu. ");
INSERT INTO ifu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ja inali na ay chicha hi, “Lawlagwon ju an amin hitay lota ta i ju ekasaba hitay Ebanghelyo an amin hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ja hini ayya mamati ay ha-in ja numpabautisar, hot miꞌtakhu ay Apo Jos. Hini ayya achi mamati hot mahugwi ta nadusa. ");
INSERT INTO ifu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hana mamati ay ha-in ja ichataꞌ chicha hi apfalinan an panginnilaan an ha-in chi nannag ay chicha. Khapo ay ni apfalinaꞌ ja pun-epakak cha hana napukhit an ispiritu an nun-ehoꞌlong, ja munhapit cha hi numpfino-ob-on an hapit an pfu-un hapit cha. ");
INSERT INTO ifu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Anong un cha ugnan chi ulog wenno pa-inuman cha chicha hi pfininu, ja ma-id ma-at ay chicha. Ammuna un cha eh-a hini ngamoy cha hana mumpunchokhoh hot tomenong cha.” ");
INSERT INTO ifu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Napfalin an nunhapit hi Apo Hesus hachi adalana ja timmalakhuy hija ad langit ja i inumpfun ay nuy nun-appit hi agwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ja immuy hachi adalana hachi apfuglapfuglay an i nangkaskasaba ay ni Ebanghelyon Apo Hesus. Ja khuna tulungan chicha, ja khuna tihtikhuwan an umannung hini itudtuchu cha hi nangchatana ay chicha hi apfalinan an mangat hi milagro.");
INSERT INTO ifu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Apo Teofilus, cho-or hachi nunnomnom an nangtulaꞌ hana naꞌna-at hichin gawwachaan Hesus ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hana uchumna an ninitnud ay Hesus an khun mangi-ali ay ni tukhun Apo Jos, ja impa-innila cha ay chaꞌmi hay hana tinnig cha an en-enat na. ");
INSERT INTO ifu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hotti ha-in khu ja enep-ephod u an menahmahan an amin, ja pinanuh u ta itulaꞌ u ay he-a, ");
INSERT INTO ifu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ti podhoꞌ an annilaom an umannung an amin hana nituchu ay he-a. ");
INSERT INTO ifu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hitay an itulaꞌ u ay he-a ja hachi naꞌna-at nete-a chin nun-ap-apugwan Ari Herod ad Judea. Ay chuy an timpo ja gwa han ohan pachi an hi Zekariah an holag pachi Abijah. Ja hi Elisabet an ahagwa na ja oha khu an holag Aaron an pengpenghan chi pachi. ");
INSERT INTO ifu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cha tay an hempfalay ja magpong cha hi pannig Apo Jos, ti khun cha unuchon an amin chi urchina. ");
INSERT INTO ifu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Muti ma-id empfalay cha, ti un mumpfahig hi Elisabet ja nala-ay cha khu an chugwa. ");
INSERT INTO ifu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nachakngan chin arkhaw an cha Zekariah chi umuy ad Jerusalem an munserbi ay Apo Jos hichi Templo. ");
INSERT INTO ifu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Immuy cha ay cha chuy numpun-ibpfa na an papachi ja numbobonot cha nu ngachah ay chicha chi i manorkhan chin insenso hichi Templo, ti hitay chi khun aton chi papachi. Ja hay nabonot ja hi Zekariah. ");
INSERT INTO ifu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chin himmigpan Zekariah hichi Templo hi i na panorkhan chin insenso, ja khun mungkalalag hachi tatakhu hichi pfutayna. ");
INSERT INTO ifu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Unagkhu gwa an khun mapoolan chin insenso ja tinnig Zekariah han angher Apo Jos an timmataꞌchug ay ni nun-appit hi agwan ay chuy altar an penonodnochan chi insenso. ");
INSERT INTO ifu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nun-objot ja nang-entata-ot hi Zekariah ay chuy an tinnig na. ");
INSERT INTO ifu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ja inalin chuy angher hi, “Achi a toma-ot, Zekariah. Ti tan unaꞌ immali an mangali ay he-a an chengngor Apo Jos chin kalalag mu. Hot magwachaan aju ay Elisabet hi empfalay an lala-e. Ja hay epengachan mu ay ni unga ja hi John. ");
INSERT INTO ifu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Metoꞌkhong ayya hitay an unga hot munnaud chi pun-an-anlaan ju ja meꞌ-anla khu hana cho-or an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ti ipapfagton Apo Jos hija. Ja magwachaan hija ay ni apfalinan ni Espiritu Santo, anong un hi pihahabpfinana. Ja mahapor an achi khu uminum hi pfajah ja hana uchumna an pfumutong.” ");
INSERT INTO ifu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ja inali na khu hi, “Umilog ayya hitay unga ja ituchugwana hana cho-or an tatakhu an holag Israel ta muntutuju cha ja mumpfangngad cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hijay honakhon Apo Jos an umali an manghakhana hi umaliyan ni Apo. Chin apfalinan ni Espiritu Santo an gawwa ay profeta Elijah ja hijay magwacha khu ay hija. Ja ipanuh na hay hana hen-a-amma ta mun-oh-ohha cha. Ja ituchugwana hana ngumangannu ay Apo Jos ta pomhod hini nomnom cha. Hitay chi atona an manghakhana hana tatakhu ja un umali hini Apo.” ");
INSERT INTO ifu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Muti inalin Zekariah hi, “Ti ngay panginnilaaꞌ un umannung hitay inalim? Ti tayya an lakajaꞌ ja pfakit hi ahagwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tempfar na ja inali na hi, “Ha-in hi Gabriel an oha an angher an khun honakhon Apo Jos. Hennakhaꞌ an immali ta ipa-innilaꞌ hitay maphod an inali na hi ma-at ay he-a. ");
INSERT INTO ifu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ja khapo ta achim pattiyon hitay inaliꞌ, hot makalud a ja ingkhana chin arkhaw an pituꞌkhungan ni empfalay ju. Ti hitay an inaliꞌ ja ma-at an ma-at ay ni timpo an eneꞌchan Apo Jos hi pa-atana.” ");
INSERT INTO ifu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Umijahop hachi tatakhu an gawwa hichi pfutayna an khun cha nomnomnomon hi, “Anagkha ta ahop ja achi pfumutay hi Zekariah?” ");
INSERT INTO ifu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ja unagkhu pfimmutay ja achi humapit an un khun munhinjar ti nakalud. Ja inannilan hachi tatakhu an gway numpatikhaw ay hija hichi hikhop chi Templo. ");
INSERT INTO ifu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nakhibpfoh chin arkhaw an punserbiyan Zekariah hichi Templo ja immanamut. ");
INSERT INTO ifu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Immuy chi at hichi hi arkhaw ja nunhapfin hi Elisabet an ahagwa na ja nilulu-uꞌ hi lemay pfulan. ");
INSERT INTO ifu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ja khun nomnomnomon Elisabet hi, “Maphod ta kina-ahiyanaꞌ ay Apo Jos ta inchat na hitay empfalay u ta achiyaꞌ mahpay mipfapfa-in.” ");
INSERT INTO ifu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chin me-adchang hi pfulan hi nunhapfinan Elisabet ja hennag Apo Jos hi angher Gabriel an immuy ad Nazaret an provincian chi Galilee. ");
INSERT INTO ifu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Immuy hi Gabriel han pfalahang an hi Mary an nihahhapit an ahagwaon Josep an oha an holag Ari David. ");
INSERT INTO ifu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Henongkhop hitay angher chin agawwachaan Mary ja inali na hi, “Mun-an-anla a Mary, ti engkhohkhohan chi-a ay Apo Jos ja hijay gawwacha ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ja temma-ot hi Mary ja khuna nomnomnomon chin inalin chin angher ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja inalin khu chin angher hi, “Achi a toma-ot Mary, ti podhon Apo Jos an ekhohkhohan chi-a. ");
INSERT INTO ifu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hot munhapfin a ja etoꞌkhong mu han lala-e, ja hay epengachan mu ja hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ja magwachaan hija hi apfalinan, hot allon cha chi hijay Empfalay Apo Jos an Napfagpfagto. Ja ipapfun Apo Jos hija an mun-ari an amat ay apo na an hi Ari David ");
INSERT INTO ifu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ta hijay mun-ap-apo an amin hay hana holag Israel. Ja hitay an pun-ap-apugwana ja achi mapogpog.” ");
INSERT INTO ifu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tempfar Mary ja inali na hi, “Ti aa, muti un chah la-ahnaon nunhapfinaꞌ an un ma-id ahagwaꞌ?” ");
INSERT INTO ifu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ja inalin chin angher hi, “Mapfalin an munhapfin a, ti ipa-alin Apo Jos hini Espiritu Santo an gway apfalinana. Hotti metoꞌkhong hitay an unga an ma-id oh-ohha hi pfahor na ja hijay ma-ali hi Empfalay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ja hi ibpfam khu an hi Elisabet an allon cha an mumpfahig, ja unum chi pfulan hini inhahabpfina an anong un munnaud an pfakit. ");
INSERT INTO ifu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ti hi Apo Jos ja gway apfalinana an mangat an amin hi podhona an aton.” ");
INSERT INTO ifu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ja inalin Mary hi, “Aa, apfulutoꞌ an ma-at hini penhod Apo Jos an ma-at ay ha-in an pfaar na.” Amat hichi ja nakak chin angher. ");
INSERT INTO ifu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Agkhuy napfajag ja immuy hi Mary ay chuy pfuglay an gawwachaan cha Zekariah ad Judea. ");
INSERT INTO ifu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Immuy hichi pfalay cha ja himmikhop ja inali na ay Elisabet hi, “Tan immaliyaꞌ, ibpfaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja unot chengngor Elisabet chin inalin Mary ay hija ja enheꞌjad chin unga an inhahabpfina. Nagwachaan hi Elisabet ay ni apfalinan ni Espiritu Santo ");
INSERT INTO ifu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ja iniꞌgwap na an nangali hi, “He-a Mary chi akhaꞌkhaja an amin hi pfinapfai! Ja hini unga an inhahabpfin mu ja omepa-anla ay Apo Jos! ");
INSERT INTO ifu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anagkha agkhu niꞌ ta ha-in an nababa an takhu chi egwangar mu Mary, an un he-a chi nihahabpfinan ni Apo ta-o? ");
INSERT INTO ifu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ja tan un u agkhu chengngor hini inalim ay ha-in ja enheꞌjad tay unga an inhahabpfin u khapo hi an-anla na. ");
INSERT INTO ifu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mun-an-anla a, ti namati a an ma-at hini inalin Apo Jos ay he-a!” ");
INSERT INTO ifu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ja inalin Mary hi, “Edaydayaw u hi Apo Jos, ");
INSERT INTO ifu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ja mun-an-anlaaꞌ ta tinakhuwaꞌ ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ti unaꞌ nababa an takhu an pfaar Apo Jos ja agkhujaꞌ agkhu niꞌ nalichuwan ay hija. Mete-a ad ugwani ja hay allon chi tatakhu ja ha-in chi akhaꞌkhaja, ");
INSERT INTO ifu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","khapo ay tay maphod an enat Apo Jos ay ha-in, ti napfagto ja nasantuwan hija! ");
INSERT INTO ifu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ti khuna ipa-ipatikhaw chi nignikha na hana tatakhu an umunud ay hija, nete-a chin hophopapna ja ingkhana ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impatikhaw Apo Jos hini apfalinana an mamaꞌ-i hi napukhit an nomnom hana mumpa-akhaja. ");
INSERT INTO ifu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nunlo-eh na hana uchumna an napfagto an ap-apo ja empapfagto na hana nababa an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Penangana hana munhenaang hi maphod hi anun, ja penakak na hana achangjan an nangew-egwayya cha. ");
INSERT INTO ifu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ja tinulungan chita-o an holag Israel an pfaar na, ti hijah nuy chin inali na chin a-apo ta-o. Ja nenomnom na an nignikhaon hi Abraham, ja an amin hana holag na hi ma-id chi pogpog na!” ");
INSERT INTO ifu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ja niꞌhihidchi hi Mary ay Elisabet hi toloh pfulan ja unot umanamut. ");
INSERT INTO ifu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nachakngan chin arkhaw an tumuꞌkhungan Elisabet ja entoꞌkhong na han lala-e. ");
INSERT INTO ifu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Unot chengngor hachi hahakhokhong na ja hachi a-akhi na hini otong an nignikhan Apo Jos ay Elisabet ja neꞌ-an-anla cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gwa an gwaloh arkhaw chin unga ja immuy hachi mungkugit ja kinugit cha. Ja podhon cha an hi Zekariah chi epengachan cha ta pfunatona hi ama na. ");
INSERT INTO ifu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Muti inalin Elisabet hi, “Pfu-un ta hi John chi epengachan ta-o ay hija.” ");
INSERT INTO ifu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ja inali cha hi, “Ti aa, muti un chah gway a-ammod ju hi nangngachan hi John?” ");
INSERT INTO ifu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ja inhinjar cha ay Zekariah ta annilaon cha nu ngay podhona hi epengachan. ");
INSERT INTO ifu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Inhinjar Zekariah ta ichat cha hay puntula-ana. Ja nanor cha an amin hi nangtula-ana an hini ngachan chuy unga ja hi John. ");
INSERT INTO ifu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ja un gwot ay chuy ja pfimmutay chin hapit Zekariah ja khuna edaydayaw hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ja an amin hachi hahakhokhong cha ja narmu chin ta-ot cha ay Apo Jos khapo hay hato an na-at. Ja nunchongor hitay an amin hachi apfuglapfuglay ad Judea. ");
INSERT INTO ifu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","An amin hachi nangngor ja khun cha nomnomnomon hi, “Ngay nin amatan tay an unga hi un umilog?” ");
INSERT INTO ifu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nagwachaan hi Zekariah ay ni apfalinan ni Espiritu Santo ja numpadtu an inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Edaydayaw ta-o hi Apo Jos an Apo ta-o an holag Israel. Ti tinulungana hana tatakhu na ja hennag na hay Manugwar hi pfahor cha ");
INSERT INTO ifu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","an narpu ay ni holag Ari David an pfaar na, ja gway apfalinana an manakhu ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hija chin impa-innilan chin nasantuwan an profeta an inalin Apo Jos hi ");
INSERT INTO ifu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","haniyan chita-o hay hana pfuhur ta-o ja hana humihigkha ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ja ipa-annung na khu chin inali na chin a-ammod ta-o an nignikhaona chicha ja achi na alichuwan chin napfalor an neꞌtobpfalana ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ja ingkarin Apo Jos ay Abraham an apo ta-o ");
INSERT INTO ifu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","an haniyan chita-o hana pfuhur ta-o ta ma-id i ta-o tomaꞌtan an umunud ay Apo Jos, ");
INSERT INTO ifu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta magpong ja najusan hini aton ta-o an munserbi ay hija ingkhana hi apogpokhan chi piꞌtakhuwan.” ");
INSERT INTO ifu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ja inalin khu Zekariah hi, “He-a hiton empfalay u chi ma-ali hi profetan tay Numpfagto an Jos. He-a chi mangpangpangullu ja un umali hini Apo ta im ipa-innila hana tatakhu ta munhakhana cha. ");
INSERT INTO ifu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ja ipa-innilam khu an pakawanon Apo Jos hana pfahor cha hot miꞌtakhu cha. ");
INSERT INTO ifu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ti na-anuh hi Apo Jos ja ma-id pogpog ni nignikha na. Hot gwa han ipa-ali na an marpu ad langit an manenakhan ay chita-o an nun-aherngan an neꞌcha hi patoy. Ja edchong chita-o ay ni malenong an piꞌtakhuwan.” ");
INSERT INTO ifu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gwa an khun omer-ellog hi John ja khun omor-ortong chin nomnom na. Ja i nun-ohha han lota an ma-id chi nunheto ingkhanah chin arkhaw an pumpatikhagwana ja pangte-aana an panuchugwan hachi holag Israel. ");
INSERT INTO ifu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hichin nituꞌkhungan John Bautista ja hi Emperador Agustus chi ap-apo ad Rome. Ja in-urchina ta an amin chi tatakhu ja i cha mumpalehta. ");
INSERT INTO ifu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ay chuy an pengpenghana an i cha pumpalehtaan ja hi Kwirinius chi gobernador ad Syria. ");
INSERT INTO ifu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ja oha-ohanna hon empacheh na an i mumpalehta ay ni pfuglay an narpugwan chin a-apo na. ");
INSERT INTO ifu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Neꞌpacheh khu Josep an narpu ad Nazaret an provincian chi Galilee, ta umuy ad Betlehem an provincian chi Judea. Ti hijah tay chi pfuglay an nituꞌkhungan Ari David an nangholag ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ja initnud na hi Mary an nihahhapit an ahagwaona ta umuy cha meꞌpalehta. Ja ay chuy ja nunhahabpfin hi Mary. ");
INSERT INTO ifu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chin gawwachaan cha ad Betlehem ja nachakngan chin arkhaw an i tumuꞌkhungan Mary. ");
INSERT INTO ifu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hotti entoꞌkhong na han lala-e an pengpenghan chi empfalay na. Pinuttiputana ja empapekheng na chin anganan chi ampfaju, ti ma-id i cha peꞌnangngan. ");
INSERT INTO ifu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ay chuy an lapfi ja gwacha hachi timmu-ar an khun mumpahtor hi karnero hichi pahto. ");
INSERT INTO ifu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Unagkhu himpfumagkha ja numpatikhaw han angher Apo Jos ay chicha ja nahenakhan cha chin pfinang Apo Jos, ja nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Muti inalin chin angher hi, “Achi aju toma-ot, ti tan unaꞌ immali an mangpa-innila han maphod an na-at an pun-an-anlaan an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ti ad ugwani ja netoꞌkhong hini Manakhu ay chaꞌju hichi ad Betlehem an pfuglay Ari David, an hija hi Kristo an Apo ta-o. ");
INSERT INTO ifu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hitay chi pangmatunan ju ay hija, an naputtiputan ja nepapappekheng han anganan chi ampfaju.” ");
INSERT INTO ifu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Unagkhu himpfumagkha ja pfimmutay khu hachi cho-odcho-or an angher ja khun cha mundaydayaw ay Apo Jos an hay khun cha allon ja, ");
INSERT INTO ifu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Madaydayaw hi Apo Jos an gwa hichi ad langit. Pomhod hini piꞌtakhuwan ju heto lota, chaꞌju an tatakhu an engkhohkhohana.” ");
INSERT INTO ifu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ja unot nakak chin cho-odcho-or an angher an numpfangngad cha ad langit, ja nunhahapit hay hachi khun mumpahtor ja inali cha hi, “Ita-o gwot mah hichi ad Betlehem ta i ta-o tikhagwun hitay an na-at an impa-innilan Apo Jos ay chita-o.” ");
INSERT INTO ifu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ja engkhalakhar cha an i tikhan ja chinakngan cha hi Mary ja hi Josep ja tinnig cha tatagwa chin pfuꞌjug an nepapappekheng chin anganan chi ampfaju. ");
INSERT INTO ifu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Un chaot tinnig ja impa-innila cha an amin chin inalin chin angher an omaꞌ-atan chin unga. ");
INSERT INTO ifu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ja nanor cha an amin hachi nangngor chin inali cha. ");
INSERT INTO ifu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hi Mary ayya ja enhemahemad na an khun nomnomnomon hay hato an na-at. ");
INSERT INTO ifu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ja numpfangngad hachi khun mumpahtor hichi pahto ja khun cha edaydayaw hi Apo Jos khapo ay ni chengngor cha ja tinnig cha, ti immannung an amin chin inalin chin angher. ");
INSERT INTO ifu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nachakngan chin me-agwaloh arkhaw chin unga ja impakugit cha. Ja empengachan cha hi Hesus, ti hijay inalin chin angher ja un mihapfin. ");
INSERT INTO ifu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nachakngan chin arkhaw an immajan cha Josep ay Mary hichi Templo ad Jerusalem ta ipidaton cha hini ni-urchin an idaton ni pfupfai an temmoꞌkhong ta maleneh hi pannig Apo Jos. Hotti neꞌ-ajon cha hi Hesus hichi Templo. ");
INSERT INTO ifu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ti allon ni urchin Apo Jos an midaton ay hija an amin chi panguluwan an lala-e. ");
INSERT INTO ifu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ja impidaton cha chin ni-urchin an chugwa an kaloma wenno pfalug an daton chi pfupfai an temmoꞌkhong. ");
INSERT INTO ifu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gwa han lala-e ad Jerusalem an hi Simeon chi ngachana. Maphod chi ugali na, ti khuna unuchon an amin chi urchin Apo Jos. Ja una ipipitti-an an hahadchon hini umaliyan ni Manakhu ay chicha an holag Israel. Ja gwacha ay hija hini Espiritu Santo ");
INSERT INTO ifu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","an nangali hi, “Achi a matoy ingkhana hi tikham hi Kristo an honakhon Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Enedchong ni Espiritu Santo hi Simeon an immuy hichi Templo chin nundatunan cha Josep ay Mary ta ma-unud hini urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hinaꞌjujun Simeon chin unga ja endaydayaw na hi Apo Jos an inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tayya an impa-annung mu, Apo Jos, hini inalim ay ha-in. Mun-an-anlaaꞌ, ti angkhaynana hi hahadchoꞌ hotti mapfalin an alaonaꞌ ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ti tinikhaw u mahpay hini hennag mu an Manakhu ay chaꞌmi an holag Israel, ");
INSERT INTO ifu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","an hija chin empagpong mu an mipa-innila an amin hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hija chi hilaw an manenakhan hana Hentil ta annilaon cha an miꞌtakhu ay Apo Jos. Ja hijay mangpapfagto hana tatakhum an holag Israel.” ");
INSERT INTO ifu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja nanor cha Josep ay Mary ay tay an inalin Simeon. ");
INSERT INTO ifu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ja binindisyonan Simeon chicha ja inali na ay Mary hi, “Hitay an empfalay mu ja pinilin Apo Jos ta hijay khumapo hi adusaan hana cho-or an holag Israel, ja cho-or khu hana miꞌtakhu khapo ay hija. Hijay mangpa-innila ay ni omaꞌ-atan Apo Jos, muti cho-or chi mamahiw ay hija, ");
INSERT INTO ifu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ja hijay panginnilaan an napukhit chi nomnom cha. Ja munchokhoh chi im punnomnoman Mary, khapo hay hato an i ma-at.” ");
INSERT INTO ifu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ja gwacha khu han oha an pfakit an profeta an hay ngachana ja hi Ana an empfalay Fanuel an holag Aser. Petoy tagwon hi narhinana ");
INSERT INTO ifu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ja napfalo, ingkhana ay chuy an timpo an nuntagwon hi gwaloy polo ta han apat. Khun umu-umuy hichi Templo an i mungkalalag ja mun-ayunar hi a-arkhagwan ja anong un lapfi. ");
INSERT INTO ifu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gawwacha pay cha Josep ay Mary hichi Templo hi immajan Ana. Nunyaman hi Ana ay Apo Jos ja inali na hini amatan Hesus hay hachi tatakhu an mamannod ay ni pangpfu-aan Apo Jos hay hana tatakhu an holag Israel. ");
INSERT INTO ifu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nakhibpfoh an enat cha Josep ay Mary an amin hana urchin Apo Jos ja immanamut cha ad Nazaret an provincian chi Galilee. ");
INSERT INTO ifu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Emmer-ellog hi Hesus ja numpfalin hi manomnom, ti empaptoꞌ Apo Jos hija. ");
INSERT INTO ifu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Atagwotagwon hon khun umuy cha Josep ay Mary ad Jerusalem an i meꞌpfehta ta Pangnomnoman cha chin Nalohan chin Angher Apo Jos chin a-apo cha ad Egypt. ");
INSERT INTO ifu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Gwa an himpolo ta chugwa chi tagwon Hesus ja niꞌjuy hija ay cha Josep ay Mary chin i cha peꞌpfehtaan ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gwa an nakhibpfoh chin pfehta ja empacheh cha an umanamut. Ja nuntaynan hi Hesus ad Jerusalem muti agkhuy anilan chin ammod na, ");
INSERT INTO ifu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ti khemhon cha chi un gwa an niꞌpfupfulog. Hijaot un cha chimmalan hi ohay arkhaw ja un cha ete-a an maningit ay Hesus hachi i-ibpfa cha ja khakhayyum cha. ");
INSERT INTO ifu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma-id chinakngan cha hotti numpfangngad cha ad Jerusalem an i maningit. ");
INSERT INTO ifu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chin me-atloh arkhaw ja un cha chakngan hi Hesus hichi Templo an ni-i-ibpfun hay hachi memehtolon chi urchin Moses ta munchochongngor ay chicha, ja cho-or chin empfogpfokha na. ");
INSERT INTO ifu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ja nanor an amin hachi nangnangngor chin atona an miꞌhahapit ja homongpfat. ");
INSERT INTO ifu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Unagkhu tinikhaw cha ama na ay ina na ja nanor cha khu. Ja inalin Mary hi, “Anagkha ta amat hetoy im enat? Ti tayya an khun mi hingihingiton he-a ja ma-id maptoꞌ hi aton mi.” ");
INSERT INTO ifu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ja inalin Hesus hi, “Anagkha ta ijaꞌ khun hingihingiton ay chaꞌju? Un ju chah agkhuy anila an mahapor an mehehettuwaꞌ heto Pfalay Ama?” ");
INSERT INTO ifu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Muti agkhuy cha na-awatan chi podhona an hapiton. ");
INSERT INTO ifu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Amat hichi ja nitnud hi Hesus ay chicha an immanamut ad Nazaret. Ja inunud na an amin chi allon cha. Ja hi Mary ja khuna nomnomnomon hay hachi an naꞌna-at. ");
INSERT INTO ifu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Emmer-ellog hi Hesus ja khun manomnomnoman. Ja emmar-alla chin anlan Apo Jos ay hija ja amat hina khu hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hichin me-ahimpolo ta leman tagwon hi nun-ap-apugwan Emperador Tiberius ad Rome, ja hi Pontius Pilato chi gobernador ad Judea ja hi Herod chi ap-apo ad Galilee. Hi Philip an ibpfan Herod chi ap-apo ad Iturea ja Trakonitis, ja hi Lisanias chi ap-apo ad Abilene. ");
INSERT INTO ifu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hay hachi natakhay an pachi hichi Templo ad Jerusalem ja cha Anas ay Kayfas. Ay chuy an timpo ja nihihidchi hi John an empfalay Zekariah hichi let-ang. Ja hichi chi nangpa-innilaan Apo Jos ay hija hi hay i na ituchu. ");
INSERT INTO ifu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hotti leneꞌgwoh John hichuy lota an nun-ehnot ay chuy gwanggwang an Jordan an khun i mangaskasaba, an hay khuna allon ja, “Muntutuju aju ja chin-ug ju hana pfahor ju ja mumpabautisar aju ta pakawanon Apo Jos hana pfahor ju.” ");
INSERT INTO ifu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hitay chin impatulaꞌ Apo Jos ay profeta Isaiah hi nangarjana hi, “Hichi let-ang ja gwacha han khun mun-ugwap an khuna allon hachi tatakhu hi, ‘Epaphod ju hini agwun ni umali an Apo. Anchongon ju hana nakillokillo an chalan ta maphod hi agwuna. ");
INSERT INTO ifu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Taponan ju hana na-alu-an ja nunchotalon ju an amin hana pfuludna. Ja enanchong ju hana naliꞌ-oliꞌ-ot an chalan ja enep-ephod ju ta ma-id humalipadchung, ");
INSERT INTO ifu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ta an amin chi tatakhu ja tikhagwun cha hini hennag Apo Jos an Manakhu ay chita-o.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Cho-or chin tatakhu an immuy ay John an i mumpabautisar. Ja inali na ay chicha hi, “Chaꞌju an lomahlalahlah! Ngay nangali hi mapfalin an mergwang aju ay ni pundusaan Apo Jos hana pfimmahor? ");
INSERT INTO ifu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Achi mapfalin, ti mahapor an aton juy maphod an mangpatikhaw an umannung an chin-ug ju hana pfahor ju. Ja achi ju punhohodlanan an miꞌtakhu khapo ta holag chaꞌju ay Abraham. Hay alloꞌ ay chaꞌju ja anong un hato pfato ja mapfalin an pumpfalinon Apo Jos hi holag Abraham ta maparkhan aju! ");
INSERT INTO ifu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hini Punhugijan Apo Jos ja amat hi gwahay an lenallajat ni munli-oy hi ajiw. Ti an amin chi ajiw an achi maphod chi pfunga na ja mali-oy ta mituud ay ni apoy hot mapoolan. Ja amat hina hini umali an adusaan ju.” ");
INSERT INTO ifu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ja inalin hana tatakhu hi, “Hot ngay aton mi mah?” ");
INSERT INTO ifu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tempfar John ja inali na hi, “Hini gway chugwa hi lopfong na ja ichat na hini oha ay ni ma-id lopfong na. Ja hini khu gway anuna ja ichatana hana napohan.” ");
INSERT INTO ifu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gwacha hachi uchumna an khun munhenger hi pakha an niꞌjuy ta meꞌpabautisar cha. Ja empfokha cha ay John hi, “Ngay peꞌ-at mi, Apo?” ");
INSERT INTO ifu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tempfar na ja inali na hi, “Achi ju khun hulukan hini hengelon ju.” ");
INSERT INTO ifu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ja neꞌpfokhan hachi uchumna an hinchalo hi, “Hot chaꞌmi mah? Ngay peꞌ-at mi?” Tempfar na ja inali na hi, “Achi aju mumpabpapfahor ja tomattata-ot ta gway i ju panghunungan hi pangalan hi pelaꞌ, ja achi ju unguhan hini herchu ju.” ");
INSERT INTO ifu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Unagkhu chengngor chin tatakhu chin khuna allon ja khun cha nomnomnomon nu hi John hini Hennag Apo Jos an hahadchon cha. ");
INSERT INTO ifu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ja inalin John ay chichan amin hi, “Pfu-un ha-in hini Mamahhod. Ti gwa han umali an metob ay ha-in an munnaud an napfagpfagto. Ja achi mapfalin an ipadchungaꞌ ay hija. Ha-in ayya ja bautisaraꞌ chaꞌju hi chanum muti hija ja bautisaran chaꞌju hi Espiritu Santo ja apoy. ");
INSERT INTO ifu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ja toꞌnona hay hana namati ay cha nuy agkhuy an amat ay ni muntaap an etapar na hini chukhi ta mataynan hini pfokhah. Ja enorpfong na hini pfokhah ja penoolana hini chukhi hi apoy an achi madmachop.” ");
INSERT INTO ifu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ja cho-or pay chin tukhun John chin tatakhu ja engkasaba na khu hini maphod an hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ja inhingar John hi Herod an ap-apo ad Galilee, ti penloh na hi Herodias an ahagwan ibpfa na. Ja cho-or chi uchumna hi napukhit an enat na. ");
INSERT INTO ifu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ja en-om-omod na an nangat hi napukhit ti i na impipfalud hi John. ");
INSERT INTO ifu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chin agkhuy na pay nipfaluchan ja binautisaran John hachi cho-or an tatakhu ja niꞌjuy hi Hesus an neꞌpabautisar. Napfalin an binautisaran John ja nungkalalag hi Hesus. Ja nipfughor ad langit ");
INSERT INTO ifu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ja nun-ohop ay hija hini Espiritu Santo an amat hi kaloma chi tikhaw na. Ja gwa han chengngor cha an hapit an narpu ad langit an nangali hi, “He-a hini podpodhoꞌ an Empfalay u. Mun-an-anlaaꞌ khapo ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Hay hato chi napfupfulog an himpangapo an narpugwan Josep an khemhon chin tatakhu hi un hijay ammod Hesus. 38 Himpfun Apo Jos hi Adam ja nunholag ta hi Set. Nunholag hi Set ta hi Enos. 37 Ja nunholag hi Enos ta hi Kainan. Nunholag hi Kainan ta hi Mahalil. Nunholag hi Mahalil ta hi Jared. Nunholag hi Jared ta hi Enok. Nunholag hi Enok ta hi Metusela. 36 Ja nunholag hi Metusela ta hi Lamek. Nunholag hi Lamek ta hi Noah. Nunholag hi Noah ta hi Shem. Nunholag hi Shem ta hi Arfaxad. Nunholag hi Arfaxad ta hi Kainan. 35 Ja nunholag hi Kainan ta hi Shelah. Nunholag hi Shelah ta hi Eber. Nunholag hi Eber ta hi Peleg. Nunholag hi Peleg ta hi Reu. Nunholag hi Reu ta hi Serug. 34 Ja nunholag hi Serug ta hi Nahor. Nunholag hi Nahor ta hi Terah. Nunholag hi Terah ta hi Abraham. Nunholag hi Abraham ta hi Isaak. Nunholag hi Isaak ta hi Jakob. 33 Ja nunholag hi Jakob ta hi Judah. Nunholag hi Judah ta hi Perez. Nunholag hi Perez ta hi Hezron. Nunholag hi Hezron ta hi Ram. Nunholag hi Ram ta hi Aminadab. 32 Ja nunholag hi Aminadab ta hi Nashon. Nunholag hi Nashon ta hi Sarmon. Nunholag hi Sarmon ta hi Boaz. Nunholag hi Boaz ta hi Obed. Nunholag hi Obed ta hi Jesse. 31 Ja nunholag hi Jesse ta hi David. Nunholag hi David ta hi Natan. Nunholag hi Natan ta hi Matata. Nunholag hi Matata ta hi Mena. Nunholag hi Mena ta hi Melea. 30 Ja nunholag hi Melea ta hi Eliakim. Nunholag hi Eliakim ta hi Jonam. Nunholag hi Jonam ta hi Josep. Nunholag hi Josep ta hi Judah. Nunholag hi Judah ta hi Simeon. 29 Ja nunholag hi Simeon ta hi Levi. Nunholag hi Levi ta hi Mattat. Nunholag hi Mattat ta hi Jorim. Nunholag hi Jorim ta hi Eliezer. Nunholag hi Eliezer ta hi Joshua. 28 Ja nunholag hi Joshua ta hi Er. Nunholag hi Er ta hi Elmadam. Nunholag hi Elmadam ta hi Kosam. Nunholag hi Kosam ta hi Adi. Nunholag hi Adi ta hi Melki. 27 Ja nunholag hi Melki ta hi Neri. Nunholag hi Neri ta hi Shealtiel. Nunholag hi Shealtiel ta hi Zerubabel. Nunholag hi Zerubabel ta hi Resa. Nunholag hi Resa ta hi Joanan. 26 Ja nunholag hi Joanan ta hi Joda. Nunholag hi Joda ta hi Josek. Nunholag hi Josek ta hi Semein. Nunholag hi Semein ta hi Matatias. Nunholag hi Matatias ta hi Maat. 25 Ja nunholag hi Maat ta hi Nagai. Nunholag hi Nagai ta hi Esli. Nunholag hi Esli ta hi Nahum. Nunholag hi Nahum ta hi Amos. Nunholag hi Amos ta hi Matatias. 24 Ja nunholag hi Matatias ta hi Josep. Nunholag hi Josep ta hi Jannai. Nunholag hi Jannai ta hi Melki. Nunholag hi Melki ta hi Levi. Nunholag hi Levi ta hi Mattat. 23b Ja nunholag hi Mattat ta hi Heli. Nunholag hi Heli ta hi Josep an allon cha an ammod Hesus. Ja tolom poloh tagwon Hesus ja una ete-a an muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Napfalin an nabautisaran hi Hesus ja nagwachaan hi apfalinan ni Espiritu Santo. Nakak hichi gwanggwang an Jordan ja enedchong ni Espiritu Santo an umuy hichi let-ang. ");
INSERT INTO ifu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ja immuy hi Satanas an i nanopngatopngan ay Hesus hi agkhuy na nangnanganan hi apat chi polon arkhaw hotti hemmenaang. ");
INSERT INTO ifu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Inalin Satanas ay hija hi, “He-a jaꞌ hini Empfalay Apo Jos. Hotti allom hay hato pfato ta mumpfalin cha hi tenapay ta gway anum.” ");
INSERT INTO ifu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tempfar Hesus ja inali na hi, “Achi. Ti allona ay ni hapit Apo Jos hi, ‘Pfu-un hini anun ja angkhay chi atakhuwan chi takhu.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Amat hichi ja initnud Satanas hi Hesus ja immuy cha han pfuludna, ja impatikhaw na hi naꞌnaꞌ-omtang an amin hana numpfino-ob-on an pun-ap-apugwan heto lota. ");
INSERT INTO ifu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ja inali na ay Hesus hi, “Ichatan chi-a hi apfalinan an mun-ap-apo an amin hay hato an pun-ap-apugwan ta he-a chi ipapfagpfagton chi tatakhu. Ti nichat an amin hay hato lota ay ha-in hotti mapfalin an ichat u ay ni podhoꞌ an pangchatan. ");
INSERT INTO ifu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nu mundaydayaw a ay ha-in hot ichat u an amin ay he-a hay hato.” ");
INSERT INTO ifu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tempfar Hesus ja inali na hi, “Achi. Ti allona ay ni hapit Apo Jos hi, ‘Hi Apo Jos an Apom chi edaydayaw mu ja unuchom ja angkhay.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Initnud khu Satanas hi Hesus ja immuy cha ad Jerusalem an i numpattoꞌ chin Templo. Ja inalin Satanas ay hija hi, “He-a jaꞌ hini Empfalay Apo Jos, hotti omaꞌpfaw a. ");
INSERT INTO ifu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ti allona ay ni hapit Apo Jos hi, ‘Honakhon Apo Jos hana angher na ta halimunan chi-a,’ ");
INSERT INTO ifu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ja allona khu hi, ‘Tapajaon chi-a hot achi a mepahpah hi pfato.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tempfar Hesus ja inali na ay Satanas hi, “Achi, ti achiꞌ podhon an toptopngan hi Ama. Ti allon khu ni hapit Apo Jos hi, ‘Achim toptopngan hi Apo Jos an Apom.’” ");
INSERT INTO ifu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Empa-opoh Satanas an nanopngatopngan ay Hesus muti ma-id olog na, ja tenaynana ta hachona khu hay uchumnah arkhaw. ");
INSERT INTO ifu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Numpfangngad hi Hesus ad Galilee an nagwachaan hi apfalinan ni Espiritu Santo. Ja impa-innila cha hana ena-enat Hesus an amin hana nunleneꞌgwoh an apfuglapfuglay ja chengngor an amin chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ja khun umuy hana sinagoga an i muntudtuchu, ja hachi nunchochongngor ja khun cha dayawon hija. ");
INSERT INTO ifu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Gwa han ohan arkhaw an immuy hi Hesus ad Nazaret, chin pfuglay an emmer-erkhana. Nachakngan chin Hapfachu an arkhaw an pungngilinan chi Hudju ja niꞌjuy hichi sinagoga cha, ti hitay chi emmengha ay hija. Timmaꞌchug ta hijay mangepfaha ay ni hapit Apo Jos, ");
INSERT INTO ifu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","hotti inchat cha ay hija han nalolo-ot an nitula-an chin inalin chin profeta an hi Isaiah. Pfiniꞌlag na ja chinakngana chin podhona an pfahaon hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hini Espiritun Apo Jos ja gwacha ay ha-in. Piniliyaꞌ ay hija an umuy mangkaskasaba ay ni maphod an hapit Apo Jos hay hana napubli. Hennakhaꞌ an umali an mangpa-innila an mipfu-aan hana pfinalud Satanas, tumikhaw hana napfulaw, ja matulungan hana maliglikhatan. ");
INSERT INTO ifu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hennakhaꞌ khu an mangpa-innila an takhuwon Apo Jos hana tatakhu na ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nakhibpfoh an pfinaha na ja leno-ot na khu ja empfangngad na ay chuy nangchat ay hija ja inumpfun an muntudtuchu. Ja an amin hachi tatakhu hichi sinagoga ja intittikhaw cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ja inali na ay chicha hi, “Ad ugwani an arkhaw ja nipa-annung hitay nitulaꞌ an hapit Apo Jos an chengngor ju.” ");
INSERT INTO ifu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dinayaw an amin hachi tatakhu hija ja nanor cha, ti megngor chin khuna hapiton. Muti inali cha hi, “Un chah pfu-un hitay hini empfalay Josep?” ");
INSERT INTO ifu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ja inalin Hesus ay chicha hi, “Gwa han hapit an allona hi, ‘He-a an choktor, akhaham otniꞌ hini achor mu.’ Ja anilaꞌ an hijay allon ju ay ha-in, ti allon ju hi, ‘Gwacha anu hana milagro an enat mu ad Kapernaum hotti peꞌ-at mu adchiya heto pfuglay ta-o.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ja inalin khu Hesus ay chicha hi, “Umannung hitay alloꞌ ay chaꞌju, an egngor hana tatakhu hini profeta an narpu hi uchumna an pfuglay muti achi cha egngor ay ni pfuglay an narpugwana. ");
INSERT INTO ifu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Umannung hitay alloꞌ ay chaꞌju. Chin timpon profeta Elijah ja agkhuy immud-uchan hi toloh tagwon ta han khaggwa, ja na-ulat an amin chi tatakhu ay tay an lota. Ja ay chuy an timpo ja cho-or hachi pfalo heto ad Israel. ");
INSERT INTO ifu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Muti agkhuy hennag Apo Jos hi Elijah ta umuy tomolong hay hachi an pfalo an Hudju, ta hini agkhu niꞌ tinulungana ja chin pfalo an pfu-un Hudju ad Zarefat an provincian chi Sidon. ");
INSERT INTO ifu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ja cho-or khu hachi nun-a-unit heto ad Israel chin tempon profeta Elisha. Ja ma-id oh-ohha hi enakhahan Apo Jos ay chicha, muti hi agkhu niꞌ Naaman an eSyria an pfu-un Hudju chi na-akhahan.” ");
INSERT INTO ifu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja nang-enpfupfungot hachi tatakhu an gwa hichi sinagoga hi nangngolan cha ay tay an khun allon Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lemmeggwat cha ja enekak cha hi Hesus, ja inti-id cha ay chuy pfulludna an haꞌjab chin nunhihittugwan cha ta okhahon cha koma han tukhi. ");
INSERT INTO ifu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Muti un hin-alina ja enenggwan Hesus chin khawwan hachi tatakhu ja khun umuy. ");
INSERT INTO ifu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Amat hichi ja immuy hi Hesus ad Kapernaum an provincian chi Galilee. Nachakngan chin Hapfachu an ngilin chi Hudju ja niꞌjuy hija hichi sinagoga an i nuntudtuchu hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ja nanor cha chin panudtuchu na ti gway apfalinana. ");
INSERT INTO ifu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ja gwa hichi han ohan lala-e an nahuhuꞌlungan hi napukhit an ispiritu. Ja impfi-ah na an nungkii ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hesus an eNazaret! Ngachah ni atom ay chaꞌmi? Un a chah immali an mangdusa ay chaꞌmi? Anilaꞌ he-a, an he-a hini nasantuwan an Empfalay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja himmingar hi Hesus ja inali na ay chuy napukhit an ispiritu hi, “Khomegkhenong a, ja makak aot!” Tinuꞌ-in chin napukhit an ispiritu chin lala-e chin gwachaan hachi tatakhu ja nakak. Muti ma-id natipor ay chuy lala-e. ");
INSERT INTO ifu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nanor cha an amin ja gwahchinonon hon inali na hi, “Ngachah nuy aton tay an munhaphapit? Anong un hana nehohoꞌlong an napukhit an ispiritu ja gway apfalinana an mummanjar ay chicha hon nun-a-akak cha.” ");
INSERT INTO ifu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ja nunchongor hi apfuglapfuglay hana ena-enat Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nakak hi Hesus hichi sinagoga ja immuy hichi pfalay cha Simon an adalana. Ja gwah chi chin pfupfai an ammod chin ahagwan Simon an mapfi-ah han potang na. Ja numpakpaka-ahi cha ay Hesus ta tulungana. ");
INSERT INTO ifu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Henontan Hesus hichuy munchokhoh ja empakak na chin potang na, ja na-aan. Napfanpfannangon hija ja enhakhanaana cha Hesus hi anun cha. ");
INSERT INTO ifu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gwa an na-uynu hichin hukhit, ja nun-i-ali cha hachi mumpunchokhoh ay Hesus. Enohha-ohha na an hen-a chicha ja temmenong cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hachi cho-or an napukhit an espiritu an nehohoꞌlong chin uchumna an tatakhu ja nun-a-akak cha an khun cha pun-iꞌgwap an mangali ay Hesus hi, “He-a hini Empfalay Apo Jos!” Muti himmingar hi Hesus ja agkhuy na nunhapiton chicha, ti anila cha an hija hini Hennag Apo Jos an Mamahhod muti achi na podhon an chichay mangpfaag. ");
INSERT INTO ifu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Unot nagwa-ah ja nakak hi Hesus ta immuy han lukhar an ma-id takhu, ja ingkhimoh hachi tatakhu an i hingiton. Inah-upan cha ja pinala-ud cha ta achi pay makak ay chuy pfuglay cha. ");
INSERT INTO ifu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Himmapit hi Hesus ja inali na hi, “Achi, ti mahapor an umujaꞌ khu hana uchumna an pfuglay ta ujaꞌ ekaskasaba hini Ebanghelyo an mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos. Ti hijah tay hini nannakhanaꞌ ay Ama.” ");
INSERT INTO ifu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Amat hichi ja immuy hachi sinagogan chi Hudju hichi provincian chi Judea an i mangaskasaba. ");
INSERT INTO ifu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gwa han ohan arkhaw an i timmataꞌchug hi Hesus hichi pingngit chi Baybay ad Genesaret ja khun muntudtuchu. Ja munhihiꞌ-ig hachi tatakhu an i munchongor ay ni hapit Apo Jos ja hemmajomhom cha ay hija hotti ma-id atona an muntuchu. ");
INSERT INTO ifu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tinnig na han chugwa an nipipingngit an pfalangay an tenaynan hachi khun mangachiw, ti i cha nun-ulah chin tapfukur cha. ");
INSERT INTO ifu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ja immuy nunlukhan hi Hesus ay chuy oha an pfalangay Simon, ja pfinokhaana hi Simon ta eb-ebtaw na. Inumpfun hi Hesus chin pfalangay ja ente-a na an muntudtuchu chin tatakhu an gawwacha ay chuy palantag chuy baybay. ");
INSERT INTO ifu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nakhibpfoh chin nuntudtuchugwan Hesus hachi tatakhu ja inali na ay Simon hi, “Edchong mu hitay pfalangay ay chuy adchalum ta manapfukur aju.” ");
INSERT INTO ifu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tempfar Simon ja inali na hi, “Apo, timmu-ar ami an nanapfukur ad a-ukhab ja ma-id oh-ohha hi khinachiw mi! Muti anong un amat heto ja khapo ta he-a chi nangali ja aton mi.” ");
INSERT INTO ifu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gwa an negpong cha chin adchalum ja intuud cha chin tapfukur. Cho-or chin neꞌna an khachiw ja mun-apfipfingit chin tapfukur cha. ");
INSERT INTO ifu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ja gwinakhijan cha chin ibpfa cha ay chuy oha an pfalangay ta gway tomolong ay chicha. Immuy cha ja pinnu cha chin chugwa an pfalangay hi khachiw ja gwa an mumpunlinong, ti mun-achamot. ");
INSERT INTO ifu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Unagkhu tinnig Simon Peter hitay an na-at ja nunheppe ay Hesus ja inali na hi, “Apo, pfuma-inaꞌ ay he-a, ti ohaaꞌ an napfahulan an takhu. Hotti achi a mehnot ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ja nanor cha Simon ay chuy cho-or an khinachiw cha. ");
INSERT INTO ifu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ja amat hina khu ay cha James ay John an empfalay Zebedee an khun itnud Simon an i manapfukur. Ja inalin Hesus ay Simon hi, “Achi a pfuma-in an midchum ay ha-in. Ti mete-a ad ugwani ja hay tamum ja un a i mun-ajag hana tatakhu ta miꞌ-unud cha ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amat hichi ja encha-ar cha chin pfalangay ja tenaynan cha an amin ta nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gwa han ohan arkhaw an gawwacha hi Hesus han pfuglay an agwachaan han lala-e an na-unit. Unagkhu tinikhaw tay na-unit hi Hesus ja i nunheppe ay hija ja numpakpaka-ahi an nangali hi, “Apo, otong hini apfalinam hotti podhom ayya ja epatenongaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ja hen-an Hesus chin na-unit ja inali na hi, “Podhoꞌ. Hotti tomenong a.” Ja emmat an na-aan gwot chin unit na. ");
INSERT INTO ifu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ja inalin Hesus hi, “Ma-id im pangar-arjan ay tay an na-at ay he-a. Hay atom ja umuy a ay ni pachi ta i a mumpatikhaw an temmenong a. Ja ipidaton mu ay hija hini allon ni urchin Moses an khun idaton ay Apo Jos an panginnilaan an umannung an na-aan hini unit mu.” ");
INSERT INTO ifu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Muti anong un agkhuy penenhod Hesus an i na ipa-innila ja nunchongor chamchama chin enat na. Achi omopoh hachi cho-odcho-or an tatakhu an umuy munchongor ay Hesus ja hachi umuy mumpa-akhah hi chokhoh cha. ");
INSERT INTO ifu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Muti umu-udchum hon immuy nun-ohha hi Hesus ta gway atona an mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gwa han namenghan an khun muntudtuchu hi Hesus, ja ni-i-ibpfun hachi uchumna an Farisee ja hachi memehtolon chi urchin Moses. Narpu cha hana apfuglapfuglay ad Galilee ja Judea, ja ad Jerusalem. Nagwachaan hi Hesus ay ni apfalinan Apo Jos ja nun-epatenong na chin mumpunchokhoh. ");
INSERT INTO ifu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Gwa han napechoy an impfapfalahhong han linala-e ta i cha ihikhop ta pe-ehnot cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Muti ma-id aton cha, ti nahodhod hichin pfalay hi tatakhu. Hotti in-uy cha chin atop chin pfalay ja khinutapfan cha. Napfalin ja inujuy cha chin napechoy ay chuy tongan chin tatakhu an agawwachaan Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Unagkhu tinnig Hesus hitay otongngan an pammati cha ja inali na ay chuy napechoy hi, “Akhiꞌ, napakawan hana pfahor mu.” ");
INSERT INTO ifu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja gwahchinonon hon inalin hachi memehtolon chi urchin Moses ja hachi Farisee hi, “Anagkha agkhu niꞌ hitay an takhu an ipadchung na hichuy achor na ay Apo Jos. Ti un chah gway uchumna hi mamakawan hi pfahor an un hi Apo Jos ja angkhay?” ");
INSERT INTO ifu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aniꞌ-ilan Hesus hini khun cha nomnomnomon ja inali na ay chicha hi, “Anagkha ta amat hina hini nomnom ju? ");
INSERT INTO ifu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma-id olog chi takhu an mamakawan hi pfahor ja ma-id khu olog cha an mangpatenong hi chokhoh. ");
INSERT INTO ifu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Muti ay ha-in an Na-ilangitan an Takhu ja epatenong u hitay an napechoy ta panginnilaan ju an gwacha khu chi apfalinaꞌ heto lota an mamakawan hi pfahor.” Ja inali na chin napechoy hi, “Alloꞌ ay he-a hi pfumangon a, ipi-ug mu hinuy pfalahhong mu ja immanamut a.” ");
INSERT INTO ifu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ja tinnig hachi tatakhu an natantannaꞌchug chin napechoy, impi-ug na chin pfalahhong na ja immanamut an khun mundaydayaw ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nanor an amin hachi tatakhu ja khun cha mundaydayaw ay Apo Jos an khun cha allon hi, “Anagkha ay chita an nabnab-on hitay tinnig ta-o ad ugwani an arkhaw!” ");
INSERT INTO ifu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nakhibpfoh hay hato an enat Hesus ja pfimmutay ay chuy an pfalay. Ja tinnig na hi Levi an oha an khun munhenger hi pakha an inu-umpfun hichin opihhina na. Ja inalin Hesus ay hija hi, “Umali a ta mitnud a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Amat hichi ja tenaynana an amin chin tamu na ja nitnud ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja gwa han namenghan an i impartiyan Levi hi Hesus hichi pfalay cha. Ja i niꞌhahali-ochot hi Hesus hachi cho-or an papadchung Levi an khun munhenger hi pakha ja hachi uchumna an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ngimmulungur hachi Farisee ja hachi papadchung cha an khun muntudtuchu ay ni urchin Moses ja inali cha hachi disipolon Hesus hi, “Anagkha ta khun aju meꞌ-orpfong hay hachi khun munhenger hi pakha ja hachi uchumna an nun-apfahulan?” ");
INSERT INTO ifu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tempfar Hesus ja inali na hi, “Hana gway chokhoh na chi munhapor hi choktor an pfu-un hana ma-id chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Immalijaꞌ an tomolong hana napfahulan ta chuꞌkhon cha hana pfahor cha an pfu-un hana mangali hi ma-id pfahor cha.” ");
INSERT INTO ifu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gwa hana immuy ay Hesus an nangali hi, “Hana disipolon John Bautista ja omarkhaw cha an mun-ayunar ja mungkalalag. Ja amat hina khu hana disipolon hana Farisee. Muti hay hato disipolom ja achi cha miꞌ-ayunar?” ");
INSERT INTO ifu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tempfar Hesus ja inali na hi, “Nu khulat ta gway mungkasar ja un ju chah allon hi achi mangan hay hana i na-ila nu gawwacha pay hini mungkasar? Achi mit mapfalin. ");
INSERT INTO ifu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Muti umali han arkhaw an ekak cha hini lala-e an nungkasar ja hijay pun-ayunalan cha. Hotti gawwachaaꞌ ayya ja achi pay mun-ayunar hato disipoloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ja nun-arig hi Hesus ja inali na hi, “Ma-id manger-ob hi pfakhu an lopfong ay ni nachochonot an lopfong. Ti nu amat hetoy atona hot un ay-ayyu hini pfakhu an lopfong ja mahahamma hi tikhan. ");
INSERT INTO ifu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma-id khu mangitto hi paꞌ-arpoh an chanum chi ubas ay ni na-usar an lalat an khun pittugwan chi ma-inum. Ti nu amat hetoy atona hot mapfughi hini lalat, ja metapar hini chanum chi ubas ja mapaꞌ-i khu hini lalat. ");
INSERT INTO ifu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hini ayya paꞌ-arpoh an chanum chi ubas ja mitto ay ni pfakhu an lalat ta mehaꞌpfa. ");
INSERT INTO ifu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ja hini uminum hi naꞌna an chanum chi ubas ja achi na podhon hini paꞌ-arpoh. Ti allona hi mapmaphochan hini naꞌna.” ");
INSERT INTO ifu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gwa han ohan Hapfachu an ngilin chi Hudju an nanggwaan cha Hesus han natamman hi trigo. Pfimmangkhi hachi disipolo na chin trigo hon inutim cha ja inan cha. ");
INSERT INTO ifu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tinnig hachi Farisee ja inali chaot hi, “Anagkha ta khun aju mun-utim? Un chah pfu-un tamu chi mun-utim an paꞌ-iyona hini urchin ta-o, an paniyaw chi muntamu ti ngilin?” ");
INSERT INTO ifu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tempfar Hesus ja inali na hi, “Un ju chah agkhuy pfinaha chin enat chin apo ta-o an hi Ari David ja chin numpun-ibpfa na hi i cha hemmenaangan, ");
INSERT INTO ifu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","an himmikhop hi David hichin pfalay Apo Jos ja enala na chin tenapay an netpfar ay Apo Jos, ja inana ja inchatana khu chin numpun-ibpfa na. Ja paniyaw chi mangan ay ni netpfar an tenapay, ti hana papachi chi mangan ja angkhay. Ja ma-id inalin Apo Jos hi un pfahor hitay enat cha.” ");
INSERT INTO ifu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja en-ang-angonoh Hesus an nangali hi, “Ha-in an Na-ilangitan an Takhu chi mangali nu ngay paniyaw ay ni arkhaw chi ngilin.” ");
INSERT INTO ifu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gwa khu han ohan Hapfachu an i nuntudtuchugwan Hesus han ohan sinagoga, ja gwa hichi han lala-e an napechoy chin agwan an ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ja henehemmonot hachi memehtolon chi urchin Moses ja hachi Farisee hi un epatenong Hesus hichuy lala-e ay chuy an arkhaw chi ngilin ta gway ipapfahor cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Anilan Hesus chin khun cha nomnomnomon muti inali na ay chuy napechoy chi ngamoy na hi, “Umali a ta miꞌtaꞌchug a heto.” Amat hichi ja i niꞌtaꞌchug. ");
INSERT INTO ifu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ja inalin Hesus hay hachi tatakhu hi, “Allon ju adchiya tugwali nu ngay inalin ni urchin Moses hi aton ta-o hi un ngilin. Tomolong ta-o chah hi takhu wenno mun-ephod ta-o hi napukhit? Inali na chah hi takhuwon ta-o hini ohan takhu wenno un ta-o amhan hini piꞌtakhuwana?” ");
INSERT INTO ifu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Intikhaw Hesus hachi atakhutakhu ja unaot allon ay chuy napechoy hi, “Uꞌjachom hini ngamoy mu.” Unaot inuꞌjad ja numpfangngad mahpay an mechon chin ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ja nang-enpfupfungot hachi Farisee ja hachi memehtolon chi urchin Moses, ja nunhahapit cha nu ngachah chi i cha aton ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gwa han namenghan an immuy hi Hesus hichi pfuludna ja timmu-ar an nungkalalag ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Unot nagwa-ah ja immuy an i nangajakhan hachi disipolo na. Ja pinili na han hempolo ta chugwa an numpfalinona hi apostol. ");
INSERT INTO ifu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja hay hato chi ngachan cha, an hi Simon, an nginadnana hi Peter, ja hi Andrew an akhi na, ja hi James, ja hi John, ja hi Philip, ja hi Bartolomew, ");
INSERT INTO ifu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ja hi Matthew, ja hi Tomas, ja hi James an empfalay Alfeus, ja hi Simon an oha an Zealot, ");
INSERT INTO ifu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ja hi Judas an empfalay James, ja hi Judas Iskariot an hijay mangngina ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Amat hichi ja nunchayyu cha han nunchochottar ja timmataꞌchug hi Hesus. Ay chuy an timmataꞌchukhana ja na-amung hachi cho-or an tatakhu an khun mitnud ay hija ja hachi uchumna an narpu hi apfuglapfuglay hichi ad Judea, ja ad Jerusalem ja amat khu ad Tiro ja ad Sidon an nehehegkhon hichi baybay. Na-amung cha an amin an munchongor hay ituchu na, ja empatenong Hesus hachi gway chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Niꞌjuy chin nun-ahuꞌlungan hi napukhit an ispiritu ja nun-epakak Hesus hachi an ispiritu ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ja penhod an amin hachi atakhutakhu an hoꞌ-on hi Hesus, ti un ammuna un cha hoꞌ-on hija hon gwa han immuy an apfalinana ay chicha hon temmenong cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Intikhaw Hesus ay cha chuy disipolo na ja inali na hi, “Akhaꞌkhaja aju an napubli, ti midchum aju ay ni Pun-ap-apugwan Apo Jos! ");
INSERT INTO ifu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Akhaꞌkhaja aju an munhenaang ad ugwani, ti mappog aju. Akhaꞌkhaja aju an khun kumila ad ugwani, ti unchani hot mun-an-anla aju! ");
INSERT INTO ifu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Akhaꞌkhaja aju an ma-apfoholan, mipapaꞌ-igwin ja me-enga-engadnan ja pa-abpfaan cha hi pfahor khapo hi piꞌ-unuchan ju ay ha-in an Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ipatikhaw ju hini achi anhan an anla ju nu ma-at hay hato ay chaꞌju, ti gwacha han lagpfu ju an napfalor an enchachaag Apo Jos hichi ad langit. Nomnomon ju an hija khu chi enat hachi a-ammod cha hachi profetan Apo Jos chin nahop. ");
INSERT INTO ifu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ka-ahi aju gwot niꞌ, chaꞌju an achangjan, ti hempog ju hini aphochan chi piꞌtakhuwan ju ad ugwani muti mapogpog! ");
INSERT INTO ifu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ka-ahi aju khu an mamabhug ad ugwani, ti unchani hot homenaang aju! Ka-ahi aju an makmakekke ad ugwani, ti unchani hot umayyong ja kumila aju! ");
INSERT INTO ifu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ka-ahi aju, chaꞌju an khun padayawon an amin chi tatakhu, ti nomnomon ju an anong un achi umannung an profeta, ja dinayaw chin a-ammod ju.” ");
INSERT INTO ifu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Inalin khu Hesus hi, “Hitay chi itukhun u ay chaꞌju. Podpodhon ju hana mabmapfohhor ay chaꞌju ja hay maphod chi aton ju hay hana humihigkha ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ekalalag ju ta ekhohkhohan Apo Jos hay hana muntubtub ja mamahipahiw ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ja nu gway manoplat ay ni apeng mu ja entajam khu hini oha. Ja nu gway mangala ay ni lopfong mu ja achim i-achi, ja anong kay ja neꞌ-ala na khu hini uchumna. ");
INSERT INTO ifu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ja ichatam an amin hana mun-achaw. Ja nu gway neꞌ-ala cha hi khina-um ja achim pfangngachon. ");
INSERT INTO ifu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ja hini podhon ju an aton chi tatakhu ay chaꞌju ja hija khu chi aton ju ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ma-id linagpfu ju nu hana mammamhod ay chaꞌju chi podpodhon ju ja angkhay. Ti anong un hay hana achi khun miꞌ-unud ay ni hapit Apo Jos ja podpodhon cha hana mammamhod ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ja ma-id khu linagpfu ju nu aton juy maphod hana anila ju an mangat khu hi maphod ay chaꞌju. Ti hitay chi khun aton hana achi khun miꞌ-unud ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ja ma-id khu linagpfu ju nu pa-utangan ju ja angkhay hay hana anila ju an gway panukat na. Ti anong un hay hana achi khun miꞌ-unud ay ni hapit Apo Jos ja pa-utangan cha hay padchung cha nu anila cha an gway panukat cha. ");
INSERT INTO ifu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Muti achi aju koma amat hina ta un ju gwot podhon hana achi mammamhod ay chaꞌju ja aton juy mapmaphod ay chicha. Ja mumpa-utang aju anong un hana anila ju an ma-id i cha pangalan hi pangojoh cha. Nu amat hetoy iju aton hot otong chi lagpfu ju ja ma-ali aju an empfapfalay ni Napfagpfagto an Jos. Ti hi Apo Jos ja magmakhohkhoh an anong un hay hana ma-id anila na an munyaman ay hija ja hana khun pfumahor. ");
INSERT INTO ifu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Otong chi nignikhan Apo Jos hotti amat aju khu.” ");
INSERT INTO ifu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Inalin khu Hesus hi, “Achi ju hugijon hana papadchung ju an tatakhu hot achi chaꞌju khu hugijon ay Apo Jos. Achi ju papfaholon hana papadchung ju an tatakhu hot achi chaꞌju khu papfaholon ay Apo Jos. Pakawanon ju hana papadchung ju an tatakhu hot pakawanon chaꞌju khu ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Umchat aju hot mangchat khu hi Apo Jos ay chaꞌju. Ti hini lopong ni ichat ju ja amat hina khu hini lopong ni ichat Apo Jos, ja choꞌchoꞌ-or pay an nahodhod ja nipuꞌ-ug ja mun-etatappar hini mepfangngad ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ja inalin Hesus hitay pangngarig ay chicha. “Achi mapfalin an itnud ni napfulaw hini padchung na an napfulaw. Ti nu amat hetoy aton cha hot muntunud cha an makhah hay khohang. ");
INSERT INTO ifu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hini mun-ad-achar ja achi nangatngato mu hini mehtolo na. Muti nakhibpfoh ayya an natuchugwan ja mapfalin an miꞌpadchung ay ni mehtolo na. ");
INSERT INTO ifu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Anagkha ta matikhaw mu hini pfahor ni padchung mu an takhu an amat ay ni it-ittang an pfuta, muti niya an achim matikhaw hini ot-ottong an pfahor mu an amat hi pfin-u an immuy ay ni matam? ");
INSERT INTO ifu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Achi mapfalin an allom ay ni padchung mu an takhu hi, ‘Ijam ibpfaꞌ, ta aanuꞌ hinuy pfuta ay ni matam’ nu achim tikhan hini pfin-u an immuy ay ni matam. Un chah paꞌ-at a ay tay? Mumpfuhuur a! Pahhunom pay an aanun hinuy pfin-u an immuy ay ni matam hot mattag hini pannig mu an mangaan ay ni pfutan ni padchung mu an takhu.” ");
INSERT INTO ifu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Inalin khu Hesus hi, “Achi pfumunga hini maphod an ajiw hi napukhit ja achi khu pfumunga hini napukhit an ajiw hi maphod. ");
INSERT INTO ifu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hini pfungan ni ajiw chi panginnilaan ay ni kalahe na. Ma-id alaon ju hi higos ay ni karkalunay ja ma-id khu alaon ju hi ubas ay ni ugwoy. ");
INSERT INTO ifu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amat hina khu hana tatakhu. Nahamad ayya hini takhu an maphod hini gwa ay ni nomnom na ja maphod hini hapitona. Napukhit ayya hini takhu an napukhit hini gwa ay ni nomnom na, ja napukhit khu chi hapitona. Ti hini pfumutay ay ni ta-on ni takhu ja hijah nuy hini gwa ay ni nomnom na.” ");
INSERT INTO ifu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Inalin khu Hesus hi, “Anagkha ta allon ju an ha-in chi Apo ju ja achi ju unuchon hini alloꞌ? ");
INSERT INTO ifu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Alloꞌ ay chaꞌju hini amatan ni takhu an umali ay ha-in an munchongor ay ni ituchuꞌ ja inunud na. ");
INSERT INTO ifu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mipadchung ay ni takhu an numpakhad hi pfalay na an empfo-eh na hichin pfato ta hijay nangpapfunana chin tu-ud. Napfalin an nahaꞌ-ad chin pfalay ja nunchatong. Ja nituchug chin chanum ay chuy an pfalay muti agkhuy natuꞌ-in, ti nehamad chin tu-ud an nipapfun chin pfato. ");
INSERT INTO ifu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ja hini ayya munchongor ay ni ituchuꞌ ja achi na unuchon, ja mipadchung ay ni takhu an numpakhad hi pfalay na muti una impapfun chin tu-ud chin lota. Immali khu chin otong an chatong ja nituchug ay ni agawwachaan chin pfalay. Ja himpfumagkha ja natuꞌ-in ja nun-apaꞌ-i.” ");
INSERT INTO ifu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Empa-opoh Hesus hay hato inali na hachi tatakhu ja immuy hichi ad Kapernaum. ");
INSERT INTO ifu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ja gwa hichi han ohan kapitan chi hinchalo. Ja gwa han takhala na an podpodhona an khun munchokhoh ja khumaju an matoy. ");
INSERT INTO ifu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Unot chengngor chin kapitan an immali hi Hesus ja pfinaar na hachi uchumna an ap-apon chi Hudju ta i cha pfokhaan hi Hesus ta epatenong na hichuy takhala na. ");
INSERT INTO ifu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Immuy cha ay Hesus ja numpakpaka-ahi cha an nangali hi, “Umali a adniꞌ, ti mahahapor ni kapitan hini tolong mu. ");
INSERT INTO ifu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ti anong un pfu-un padchung an Hudju ja podpodhon chita-o. Ti empahaꞌ-ad na han sinagoga mi.” ");
INSERT INTO ifu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Amat hichi ja niꞌjuy hi Hesus ay chicha. Unagkhu gwa an mehnot cha Hesus ay chuy pfalay chin kapitan ja chinittum chaot hachi hennag na an khayyum na. Ja inali cha ay Hesus chin inalin ni kapitan an amat heto. Inali na hi, “Apo, khahinon un a miꞌjali hi pfalay mi. Ti pfuma-inaꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja pfuma-inaꞌ khu an umali ay he-a. Ti ammuna un mu allon hi tomenong hitay takhalaꞌ hot ma-at. ");
INSERT INTO ifu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ti anong un ha-in ja gway apoꞌ an khun mamaar ay ha-in, ja gwacha khu hana hinchaloꞌ an khun u pfaalon. Ti alloꞌ ay ni oha an hinchalo hi, ‘Umuy a!’ ja immuy. Ja alloꞌ khu ay ni oha hi, ‘Umali a!’ ja immali. Ja alloꞌ ay ni takhalaꞌ hi, ‘Atom hitay!’ ja enat na. Ja om-omod ay he-a an gway apfalinam an mangali hot ma-at.” ");
INSERT INTO ifu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja nanor hi Hesus hi nangngolana ay tay inali cha. Nunligkhoh ja inali na hachi atakhutakhu an ninitnud ay hija hi, “Alloꞌ ay chaꞌju hi ma-id oha hi Hudju hi tinnig u an gway pammati na an miꞌpadchung ay ni otong an pammatin tay pfu-un Hudju.” ");
INSERT INTO ifu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Numpfangngad hay hachi hennag chin kapitan ja chinakngan cha chin takhala an temmenong. ");
INSERT INTO ifu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Amat hichi ja immuy khu hi Hesus han ohan pfuglay an ad Nain. Ja ninitnud hachi disipolo na ja hachi cho-or an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Unagkhu gwa an mehnot cha ay chuy an pfuglay ja chinittum cha hachi umuy munlapfun. Hichuy an natoy ja un oh-ohha an lala-e an empfalay han pfalo. Ja cho-or chin tatakhu ay chuy an pfuglay an nitnud. ");
INSERT INTO ifu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Unagkhu tinnig Apo Hesus hichuy an pfalo ja ninignikha na ja inali na hi, “Ammuna, epokhong mu an kumila.” ");
INSERT INTO ifu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Immuy ja hen-a na chin longon chuy natoy ja intaꞌchug hachi nangpipi-ug. Ja inalin Hesus chin natoy hi, “Pfumangon a.” ");
INSERT INTO ifu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pfimmangon hichuy natoy ja himmapit. Ja inalin Hesus chin pfalo hi, “Tayya hitay empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nang-entata-ot an amin hachi atakhutakhu ja nundaydayaw cha ay Apo Jos ja khun cha allon hi, “Tayya an numpatikhaw ay chita-o hitay an napfagto an profeta. Maphod ti tayya an nenomnom chita-o an takhuwon ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hitay an enat Hesus ja nunchongor an amin hichi ad Judea ja chin nun-ehnot an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chin disipolon John Bautista ja impa-innila cha ay hija an amin chi ena-enat Hesus. Hotti hennag John han chugwa an disipolo na ");
INSERT INTO ifu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","an umuy ay Hesus ta i mangpfokha hu-un hija chah hini inalin John an hennag Apo Jos an hahadchon cha, wenno hay oha. ");
INSERT INTO ifu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Unot emmatam hachi hennag John ja inali cha ay Hesus hi, “Hennag chaꞌmi ay John Bautista ta mahmahan mi hu-un he-a chah chin inali na an mamahhod an umali?” ");
INSERT INTO ifu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Amat hichi ja empatenong Hesus hachi mumpunchokhoh ja nun-epakak na hachi nun-ehoꞌlong an napukhit an ispiritu ja inchatana hi pannig hachi nun-apfulaw. ");
INSERT INTO ifu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nakhibpfoh hay hato an enat Hesus ja unaot allon ay cha chuy hennag John hi, “Mumpfangngad aju ta allon ju ay John hay hato tinnig ju ja chengngor ju. Allon ju chi tinnig mi an hana napfulaw ja tumikhaw cha, hana napechoy ja chumalan cha, hana na-unit ja temmenong cha, hana napo-it ja chomngor cha, ja hana nun-atoy ja timmakhu cha. Ja khun mekasaba hini maphod an Hapit Apo Jos hana napubli. ");
INSERT INTO ifu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ja allon ju khu hi madmachennor hini takhu an achi munhalinchugwa hini nomnom na ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Amat hichi ja nakak hachi hennag John, ja inalin Hesus hini omaꞌ-atan John ay cha chuy atakhutakhu. Inali na hi, “Chin immajan ju ay John hichi let-ang ja ngay nenomnom ju hi i ju tikhan? Unchah hay potaar an khun mumpfiwpfiwwapfiw? Pfu-un. ");
INSERT INTO ifu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hot ngachah mah chi i ju tinnig? Un aju chah immuy ta tikhan ju hay takhu an maphod chi lopfong na? Pfu-un khuh niꞌ, ti hana ayya khun munlopfong hi maphod ja maphod chi piꞌtakhuwan cha, ja hay pfalay chi ari chi punhihittugwan cha. ");
INSERT INTO ifu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hot ngachah tugwali chi i ju tinnig? Hay profetan Apo Jos? Aa, ja alloꞌ ay chaꞌju an napfagpfagto pay hija mu hana uchumna an profeta. ");
INSERT INTO ifu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ti hi John hini nitulungan ni nitulaꞌ an hapit Apo Jos hi nangarjana hi, ‘Tayya an honakhoꞌ hitay mangpangpangullu ja un he-a ta ehakhana na hini agwum.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ja inalin khu Hesus hi, “Alloꞌ ay chaꞌju an hi John Bautista hini napfagpfagto an amin hi hay takhu heto lota. Muti napfagpfagto pay hini nabnababba an takhu an nidchum ay ni Pun-ap-apugwan Apo Jos hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Achechenor hi pangngolan hachi cho-or an tatakhu ja anong un hachi khun munhenger hi pakha chin inalin Hesus. Ti inunud cha hana magpong an in-urchin Apo Jos ja numpabautisar cha ay John. ");
INSERT INTO ifu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Muti hana Farisee ja memehtolon chi urchin Moses ja ngumanu cha an mangapfulut chin penhod Apo Jos hi aton cha ja agkhuy cha khu numpabautisar ay John. ");
INSERT INTO ifu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ja inalin khu Hesus hi, “Alloꞌ ay chaꞌju hini eꞌ-eꞌnongan ju an tatakhu ad ugwani an timpo, an ");
INSERT INTO ifu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","meꞌmeꞌnong aju hana ung-ungungnga an um-umpfun hinun palaha an munlewlegwa muti ma-id maptoꞌ hi podhon cha. Ti iꞌgwap hana uchumna an allon cha ay ni khun cha peꞌlewlegwa hi, ‘Nanongngali ami muti agkhuy aju temmajaw. Ja emmepfer ami muti agkhuy aju niꞌkila.’ ");
INSERT INTO ifu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","An amat ay chaꞌju an ma-id maptoꞌ hi podhon ju. Ti immali hi John Bautista ja khun mun-ayunar ja achi umin-inum hi pfajah, ja allon ju hi un mun-angaw. ");
INSERT INTO ifu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ja tan immalijaꞌ an Na-ilangitan an Takhu, ja khunaꞌ meꞌ-orpfong an meꞌ-an, ja nuja an pahigwonaꞌ an khun ju allon hi, ‘Tikhan ju akay niꞌ hitay an takhu an nahopo ja khun mapfutong. Ja niꞌkhayyum khu hana khun munhenger hi pakha ja hana uchumna an nun-apfahulan an tatakhu!’ Hotti tayya an pahigwon chaꞌmi an chugwa. ");
INSERT INTO ifu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Muti nomnomon ju hitay, an hini aphod ja kinala-eng Apo Jos ja matikhaw ay ni piꞌtakhuwan hay hana nangapfulut ay ni intudtuchu mi ay John.” ");
INSERT INTO ifu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Gwa han Farisee an hi Simon chi ngachana an nangajakhan ay Hesus ta miꞌjuy hichi pfalay cha an i meꞌ-an. Hotti niꞌjuy hi Hesus ja i neꞌ-orpfong. ");
INSERT INTO ifu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ay chuy an pfuglay an niꞌjajan Hesus ja gwa han pfupfai an miꞌlalala-e. Chengngor na an i nummangili hi Hesus ay chuy nunhitugwan chin Farisee ja in-uy na han mumpfango an lanob an ninitto han alabastro an pfoterja. ");
INSERT INTO ifu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Timmataꞌchug hichin negpongan Hesus ja khun kumila ja nuntidtid chin luwa na hichin hu-in Hesus. Impuꞌnah chuy pfupfai chin pfuuꞌ na ja inungngu na chin hu-in Hesus ja unaot khu epelanob chin mumpfango an lanob. ");
INSERT INTO ifu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Unot tinnig chin Farisee an nangajakhan ay Hesus ja khuna nomnomnomon hi, “Mu pfu-un ay chita profeta hi Hesus. Ti khulat ta profeta hot anila na an napukhit chi ugalin tay an pfupfai an khun man-a ay hija.” ");
INSERT INTO ifu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ja inalin Hesus ay chuy Farisee hi, “Simon, gwa han alloꞌ ay he-a.” Tempfar Simon ja inali na hi, “Ngachah nuy allom, Apo?” ");
INSERT INTO ifu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ja inalin Hesus hi, “Gwa han chugwa an lala-e an immutang han khun mumpa-utang hi pihu. Lemay khahot chi utang chin oha ja lemay polo chi utang chin oha. ");
INSERT INTO ifu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma-id epfangngad cha ja agkhuy na empapallog. Ngachah tugwali chi anilam ay cha tay an chugwa hi ot-ottong chi pamhod na ay chuy immutangan cha?” ");
INSERT INTO ifu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tempfar Simon ja inali na hi, “Hinuy nin ot-ottong chi utang na.” Ja inalin Hesus hi, “Umannung hitay nampfar mu.” ");
INSERT INTO ifu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nunligkhoh ay chuy pfupfai ja inali na ay Simon hi, “Tikham hitay an pfupfai. Tan immalijaꞌ heto pfalay ju ja agkhuy mu enat hini ugali ta-o an ma-id inchat mu hi chanum ta nangulah u ay tay hu-iꞌ. Muti hitay an pfupfai ja inulahana hay hato hu-iꞌ ay ni luwa na ja impuꞌnah na hichuy pfuuꞌ na ay tay hu-iꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ja agkhujaꞌ inungngu ay he-a hi immaliyaꞌ muti inungngu-ungngun tay an pfupfai hay hato hu-iꞌ an ente-a na hi chimmakngaꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma-id ni-iꞌchat mu hi lanob ta elanob u ay tay pfuuꞌ u muti hitay an pfupfai ja lenanob na hitay hu-iꞌ hi mumpfango an lanob. ");
INSERT INTO ifu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ja tayya an alloꞌ ay he-a an hitay otong an impatikhaw na an pamhod na ja hijay panginnilaan an napakawan hay cho-or an pfahor na. Muti hini takhu an it-ittang hini empakawana an pfahor ja it-ittang khu hini pamhod na ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ja inalin khu Hesus ay chuy pfupfai hi, “Napakawan an amin chi pfahor mu.” ");
INSERT INTO ifu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Khun nomnomnomon chin uchumna an neꞌ-orpfong ay Hesus hi, “Ngachah agkhu niꞌ tay an takhu an mamakawan pay hi pfahor?” ");
INSERT INTO ifu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ja inalin Hesus ay chuy pfupfai hi, “Khapo ay ni pammatim ja miꞌtakhu a. Hotti mun-an-anla a an umanamut.” ");
INSERT INTO ifu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Immuy chi at hichi hi arkhaw ja immuy hi Hesus hachi apfuglapfuglay ja apfarjupfarju an khun mangkaskasaba ay ni Ebanghelyo an mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos hi tatakhu ay tay lota. Ini-itnud na hachi himpolo ta chugwa an adalana. ");
INSERT INTO ifu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nitnud khu chin uchumna an pfinapfai an empatenong Hesus chi chokhoh cha ja hachi uchumna an nangpakakana hi napukhit an ispiritu an nun-ehoꞌlong ay chicha. Oha hi Mary an nginadnan cha hi Magdalen an nakakan han peto an napukhit an espiritu an nehohoꞌlong. ");
INSERT INTO ifu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ja hi Joana an ahagwan ni ap-apon chi takhalan Ari Herod an hi Chusa, ja hi Susana, ja chin cho-or pay an pfinapfai an temmolong an nangchat chin mahapor cha Hesus ay cha chuy adalana. ");
INSERT INTO ifu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cho-or pay chin uchumna an tatakhu an khun umuy ay Hesus an narpu cha hi numpfino-ob-on an pfuglay. Unot chenom-or hachi tatakhu ja inali na hitay an pangngarig. ");
INSERT INTO ifu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Gwa han ohan takhu an immuy munhapuwaꞌ hi pfugwa hichi hapfar na. Khun munhapuwaꞌ ja nepochag chin uchumna ay ni chalan ja nun-ilait cha, ja numpanga-ali chin hagwiti ja nun-a-an cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chin uchumna ja nepochag chin mapfinato an lota. Ja hemmangaw cha muti agkhuy napfajag ja nun-alango cha ja naꞌleng, ti un nitutu-i chin hemmangagwana. ");
INSERT INTO ifu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nepochag khu chin uchumna chin achoꞌlan chi holoꞌ an nun-apakhatan. Un chaagkhu hemmangaw ja emmaꞌlap hachi nun-apakhatan an holoꞌ ja hinaꞌpfungan cha chin nitanum ja agkhuy penomhod. ");
INSERT INTO ifu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ja chin uchumna ja nepochag chin maphod an lota, ja numpangahangaw cha ja numpangapfunga cha hi cho-odcho-or an hinkhakhahot.” Ja inalin khu Hesus hi, “Pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Henanhanan hachi adalan ay Hesus nu ngay podhon tay an pangngarig an hapiton. ");
INSERT INTO ifu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ja inalin Hesus hi, “Aa, ti chaꞌju hana pangpa-innilaan Apo Jos ay ni omaꞌ-atan ni Pun-ap-apugwana. Hana ayya uchumna an achi miꞌ-unud ja pangngarig hini atoꞌ an mangtuchugwan ay chicha. Hot anong un himulimuli hini mata cha ja achi cha khun tikhan hana khun u aton, ja anong un nun-alu-angan hana inga cha ja achi cha chamchama ma-awatan hana khun u itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hitay chi podhon tay an pangngarig an hapiton. Hana pfugwa an nihapuwaꞌ ja hija hini hapit Apo Jos an khun mitudtuchu. ");
INSERT INTO ifu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ja hana nepochag ay ni chalan ja hija hana tatakhu an nunchongor ay ni hapit Apo Jos muti immuy hi Satanas ta akagwona chin hapit an chengngor cha ta achi cha mamati ta achi cha miꞌtakhu ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ja hana ayya nepochag ay ni mapfinato an lota ja hija hana tatakhu an nun-an-anla an nunchongor ay ni hapit Apo Jos ja inapfulut cha, muti un naꞌnaꞌ-omtang, ti agkhuy limmamot hini hapit na ay chicha. Unchani ta immali hana apalikhatan khapo hi nangapfulutan cha ay ni hapit Apo Jos ja chin-ug cha hini pammati cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja hana ayya nepochag ay ni achoꞌlan chi holoꞌ an napakhatan ja hija hana tatakhu an nunchongor, muti immali ayya hana pundanakhan ay tay piꞌtakhuwan ja hana homalegwa an nomnom hi omachangjanan ja hana pun-an-anlaan heto lota, ja nahi-ig hini pammati cha ja achi cha miꞌpfunga. ");
INSERT INTO ifu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hana ayya nepochag ay ni maphod an lota ja hija hana nunchongor ay ni hapit Apo Jos ja intanum cha ay ni nomnom cha ja na-ennongan cha an unuchon ingkhana an matikhaw hini pomhochan chi piꞌtakhuwan cha.” ");
INSERT INTO ifu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Inalin khu Hesus hi, “Achi ta-o torkhan hay panor ja i ta-o halinan wenno epachaor hi kama, ta un ta-o gwot epattoꞌ hay napataw ta mahilagwan hay takhu an humikhop ay nuy an pfalay. ");
INSERT INTO ifu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ja an amin hana nililiꞌ-ud ja gwa han arkhaw an mipatikhaw. Ja hana achi ma-innila ad ugwani ja gwa khu han arkhaw hot ma-innila chamchama. ");
INSERT INTO ifu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hotti tikhan ju hini aton ju an munchongor ay ni ituchuꞌ. Ti hini takhu an miꞌ-unud ay ni ituchuꞌ ja umannung an ma-ug-ugman hini anila na. Hini ayya takhu an una lamangon an achi miꞌ-unud ay ni ituchuꞌ ja anong un hini anila na ja ma-utaw ay ni nomnom na.” ");
INSERT INTO ifu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Emmatam chin ammod Hesus an hi Mary ja chin a-akhi na an linala-e ay chuy agawwachaana. Muti ma-id aton cha an mehnot, ti cho-or hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ja gwa han nangali ay Hesus hi, “Chiya an gwacha hi inam ja hana a-akhim an timmataꞌchug hichi pfutayna ja khun chi-a epa-ajag ta miꞌhapit cha ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ja inalin Hesus hachi tatakhu hi, “Hana mangegngor ja mangunud ay tay hapit Apo Jos ja chicha chi a-ammod u ja a-akhiꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gwa han ohan arkhaw ja inalin Hesus chin adalana hi, “Pfumad-ang ta-o ay tay baybay.” Nunlukhan cha han pfalangay ja ente-a cha an umuy. ");
INSERT INTO ifu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Gwa an khun cha umuy ja i naloꞌ hi Hesus. Unagkhu himpfumagkha ja gwacha han mapfi-ah an puwoꞌ. Nuntipjaꞌ-ong chin chanum ja nittugwan chin pfalangay ja gwa an munlinong. ");
INSERT INTO ifu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Immuy hachi disipolo na ja pfinangon cha hi Hesus. Inali cha hi, “Apo! Tayya an marteng ta-o!” Enelan Hesus ja inhingar na chin puwoꞌ ja chin chanum an khun muntipjaꞌ-ong. Khemmenong chin puwoꞌ ja chin chanum ja munnaud an malenong. ");
INSERT INTO ifu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ja inali na hachi adalana hi, “Un chah ma-id pammati ju ay ha-in?” Nanor cha ja nang-entata-ot cha ja khun cha allon chi, “Ngachah ay chita tay an takhu? Anong un puwoꞌ ja chanum ja unuchon cha hini allona!” ");
INSERT INTO ifu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Entortoloy cha an khun umuy ja emmatam cha hichi chammangna, an pfuglay hachi eGerasa. ");
INSERT INTO ifu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pfimmutay hi Hesus chin pfalangay ja immuy ay chuy palantag chin baybay ja chinittum na gwot han lala-e an eGerasa an nahuhuꞌlungan hi nun-apukhit an espiritu. Un mummomolleh ja achi na podhon an munheto hi pfalay an un amjaꞌ na an munhehetto hana lijang an lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Omarkhaw an mahuꞌlungan hitay an lala-e ja anong un cha ugnan ja pfangkelengan hana ngamoy na ja hu-i na hon nunhopchot na hon empalajaw ni napukhit an espiritu ta umuy hichi let-ang. Unot tinnig tay an lala-e hi Hesus ja nungkii ja nunheppe ay hija. Ja iniꞌgwap na an mangali hi, “Hesus an Empfalay chi Napfagto an Jos! Ngachah chi atom ay ha-in? Achiyaꞌ adniꞌ palikhaton!” Hay nangarjana ay tay ja inalin Hesus ay chuy napukhit an espiritu ta makak ay chuy takhu. ");
INSERT INTO ifu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ja inalin Hesus ay hija hi, “Ngay ngachan mu?” Tempfar na ja inali na hi, “Linipfulipfuwaꞌ.” Ti cho-or hachi napukhit an espiritu an nun-ehoꞌlong ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ja inalin hachi napukhit an espiritu hi, “Achi chaꞌmi adniꞌ ipi-uy ad chalom.” ");
INSERT INTO ifu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ja cho-or hachi apfapfupfapfuy an khun munhu-oy ay chuy an pfulludna. Ja numpakpaka-ahi hachi napukhit an ispiritu an inali cha ay Hesus hi, “Hotti un ami mah niꞌ mehoꞌlong hay hachi pfapfuy!” Ja inalin Hesus hi, “Umuy aju.” ");
INSERT INTO ifu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hotti nun-a-akak hachi napukhit an espiritu ay chuy an lala-e ja i cha nun-ehoꞌlong hachi apfapfupfapfuy. Ja nungkhakhayyat hachi pfapfuy an nunchayyu ja nun-ilipaw cha ay chuy baybay ja nun-arteng cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Unagkhu tinnig hachi khun mumpfantay hachi pfapfuy chin na-at ja nungkhakhayyat cha an nakak. Ja immuy cha hichi pfuglay cha ja hachi uchumna an pfuglay an i nangpa-innila hay hato an tinnig cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hotti napfu-ar hachi tatakhu an i miꞌtikhaw. Un chaot emmatam chin agwachaan Hesus ja tinnig cha chin lala-e an ni-i-ibpfun an nunlolopfong ja nagwachaan hi maphod an nomnom. Ja nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ja impa-innilan hachi nannig chin enat Hesus an nangpakak hay hachi napukhit an espiritu. ");
INSERT INTO ifu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Khapo hi nunnaud an temmaꞌtan cha ja empfokhan an amin hachi eGerasa ta makak hi Hesus ay nuy pfuglay cha. Hotti nunlukhan cha Hesus chin pfalangay ta epacheh cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ja hichuy an lala-e an nakakan hachi napukhit an espiritu ja inali na ay Hesus hi, “Mitnuchaꞌ adniꞌ ay he-a.” Muti inalin Hesus hi, ");
INSERT INTO ifu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Achi, ta un aot umanamut ta im ipa-innila hitay maphod an enat Apo Jos ay he-a.” Hotti immanamut ja i na impa-innila an amin hachi tatakhu ay chuy an pfuglay hitay mapmaphod an enat Hesus ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Unagkhu numpfangngad cha Hesus chin chammangna an narpugwan cha ja mun-an-anla hachi tatakhu an nanannod ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ja immuy ay Hesus han lala-e an hi Jairus an ap-apon han sinagoga hichi. Ja nunheppe ay Hesus ja numpakpaka-ahi ta miꞌjuy hi Hesus hichi pfalay cha. ");
INSERT INTO ifu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ti gwa an ma-uꞌlud hini oh-ohha an empfalay na an pfupfai an himpolo ta chugwa chi tagwona. Hotti ninitnud hi Hesus ta umuy cha ja khun munhihiꞌ-ig hachi tatakhu an munli-ub ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ja gwa han ohan pfupfai an khun mangunud ay chicha an hay chokhoh na ja achi maymajat han chala an khun pfumutay ay hija hi himpolo ta chugwa hi tagwon. Khun mumpa-akhah muti ma-id oh-ohha hi nanginnila an mangakhahan ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Immuy ay chuy negpong chin khatud Hesus ja heneꞌkhad na chin khalampfay ni lopfong na ja najat gwot chin chala an khun pfumutay ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ja inalin Hesus hi, “Ngay naneꞌkhad ay ha-in?” Ja ohanna hon inali cha hi, “Pfu-un mangkay ha-in.” Ja himmapit hi Peter ja inali na hi, “Apo, cho-or hay hato nali-ub ay he-a an tatakhu an khun munhihiꞌ-ig.” ");
INSERT INTO ifu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ja inalin Hesus hi, “Ti aa muti nu han naneꞌkhad ay ha-in. Ti omod an naleꞌnaꞌ an gwa han immuy an apfalinaꞌ ay hija.” ");
INSERT INTO ifu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na-orman tay an pfupfai an inannilan Hesus chin enat na hotti immuy nunheppe ay hija an khun mun-elob. Ja chengngor an amin hachi tatakhu chin khuna allon ay Hesus an khapo na hi naneꞌkhachana ay chuy lopfong na, ja chin enat na an temmenong. ");
INSERT INTO ifu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ja inalin Hesus ay hija hi, “Khapo ay ni pammatim ja temmenong a. Hotti mun-an-anla a an umanamut.” ");
INSERT INTO ifu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Unagkhu khun miꞌhapit hi Hesus chin pfupfai ja ne-atam gwot chin hennag cha an narpu hi pfalay cha Jairus. Ja inali na ay Jairus hi, “Achi ta-o ungalon hitay Apo ta-o, ti natoy chamchama hini empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chengngor Hesus hitay ja inali na ay Jairus hi, “Achi a mundanag. Ehchor mu ay ha-in hot tumakhu hini empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ne-atam cha Hesus hichi pfalay cha Jairus ja gwa hana khun umiha ja inalin Hesus hi, “Epokhong ju an umiha, ti agkhuy natoy hichuy unga an un nanalloꞌ.” Muti kenekejan cha chin inalin Hesus, ti anila cha an natoy. Himmikhop hi Hesus ja hay niꞌhigpona ja hi Peter ja hi John ja hi James ja chin a-ammod chuy unga ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amat hichi ja nehnot hi Hesus ay chuy unga ja inugnana chin ngamoy na ja inali na hi, “Pfumangon a, hiton unga.” ");
INSERT INTO ifu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Timmakhu hichin unga ja napfanpfannangon. Ja inalin Hesus hi, “Ichatan ju hija hi anuna.” ");
INSERT INTO ifu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nanor hachi a-ammod na ja inalin Hesus ay chicha hi, “Ma-id i ju pangar-arjan ay tay an na-at.” ");
INSERT INTO ifu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Enajakhan Hesus hachi himpolo ta chugwa an adalan ta inchatana chicha hi apfalinan an mangpakak an amin hi nehohoꞌlong an napukhit an ispiritu ja an mangpatenong hi chokhoh, ");
INSERT INTO ifu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ja unaot honakhon chicha an umuy ta i cha ekasaba hini umali an Pun-ap-apugwan Apo Jos hi tatakhu ja an i mangpatenong hana mumpunchokhoh. ");
INSERT INTO ifu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ja inali na ay chicha hi, “Un aju mangew-egwayya an umuy. Achi aju mumpfunguhan ja mun-ochon hi hape-eng, hongot ja pihu, anong un hay ihukat ju. ");
INSERT INTO ifu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nu umuy aju ay ni oha an pfalay ja podhon chaꞌju an mangiliyon, ja munnanannong aju ingkhana hi akakan ju. ");
INSERT INTO ifu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ja nu achi chaꞌju podhon an mangiliyon, ja nu makak aju ayya ay nuy an pfuglay ja pumpuꞌpu-an ju hay chapor an nep-ot ay ni chapan ju ta hitay chi panginnilaan an hugijon Apo Jos hana tatakhu ay chuy an pfuglay khapo hi achi cha pammatiyan ay ni hapit na.” ");
INSERT INTO ifu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amat hichi ja empacheh chin adalan an immuy hi apfarjupfarju ta i cha engkasaba hini Ebanghelyo. Ja nun-epatenong cha hachi mumpunchokhoh an amin ay chuy immajan cha. ");
INSERT INTO ifu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chengngor Herod an ap-apo ad Galilee an amin hana ena-enat Hesus ja ma-id maptoꞌ hi i na punnomnoman. Ti khun allon hachi uchumna hi, “Hitay an hi Hesus ja hija hi John Bautista an un nummahu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ja khun khu allon hachi uchumna hi un hija hi Elijah an immali an mumpatikhaw. Ja gwacha khu hachi khun mangali hi un oha hija an profetan Apo Jos chin nahop an nummahu. ");
INSERT INTO ifu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ja khun allon Herod hi, “Empapotor u hini ulun John muti ngay ngachah tay khu an hi Hesus an ikhimoh cha an haphapiton?” Hotti penenhod Herod an peꞌmamad an tikhan hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Numpfangngad hachi himpolo ta chugwa an apostol ja inali cha ay Hesus an amin chin ena-enat cha. Amat hichi ja initnud Hesus chicha ta immi-igway cha an immuy han pfuglay an ad Betsaida. ");
INSERT INTO ifu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Unagkhu inannilan hachi tatakhu hi apfuglapfuglay chin immajan cha Hesus ja chinallan cha an nangunud. Emmatam cha chin agwachaan cha Hesus ja inali na ay chicha hi, “Maphod ta immali aju.” Ja intuchu na gwot ay chicha hini omaꞌ-atan ni Pun-ap-apugwan Apo Jos hi tatakhu ja nun-epatenong na hachi gway chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Unot gwa an nahilip ja immuy chin himpolo ta chugwa an adalan ay Hesus ja inali cha hi, “Honakhom hato tatakhu ta umuy cha mannig hi anun cha ja punnangngan cha hay hachi nun-ehnot an pfarju. Ti tan ma-id pfarpfalay ay tay agawwachaan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ja inalin Hesus hi, “Chaꞌjuwot chi mangchat hi anun cha.” Ja inalin hachi adalan hi, “Ma-id ichat ta-o hi anun cha, Apo, ti tan un angkhay han lema an tenapay ja han chugwa an khachiw chi gwa heto. Ad-adchi ami mangkay pa-angina hi anun an amin hato an tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ti lemay lipfu chin pfilang chin linala-e an nidchum ay chuy an khagong. Ja inalin khu Hesus hi, “A-aggwon ju hato tatakhu ta henlermay polo cha hon impapfun ju.” ");
INSERT INTO ifu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hotti ena-aggwa cha ja impapfun cha an amin hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Enalan Hesus chin lema an tenapay ja chin chugwa an khachiw, ja entangad na ad uchu an nunyaman ay Apo Jos. Napfalin ja initta-ittang na ja inchat na hachi adalan ta egwanah cha hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangan cha ja na-apchan cha an amin. Inamung hachi adalan hachi nahagwar ja nun-apnu han hempolo ta chugwa an pfahkit. ");
INSERT INTO ifu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gwa han namenghan an tenaynan Hesus hachi atakhutakhu ta i nun-ohha an nungkalalag. Ja ninitnud hachi disipolo na, ja inali na ay chicha hi, “Ngachah tugwali chi allon hana tatakhu hi omaꞌ-ataꞌ?” ");
INSERT INTO ifu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tempfar cha ja inali cha hi, “Gwacha hana mangali hi un he-a hi John Bautista. Ja gwacha khu hana mangali hi un he-a hi Elijah, ja allon khu hana uchumna hi un a oha an profeta chin nahop an nummahu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ja inali na hi, “Chaꞌju mah? Ngay allon ju tugwali hi omaꞌ-ataꞌ?” Tempfar Peter ja inali na hi, “He-a hini Hennag Apo Jos an Mamahhod!” ");
INSERT INTO ifu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ja naꞌnaꞌ-allon Hesus hi, “Achi ju pay epfaꞌpfaag hitay hana tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ja inalin khu Hesus hi, “Ha-in an Na-ilangitan an Takhu, ja mahapor an hortapoꞌ hana cho-or an likhat, ja pfuhulonaꞌ hana a-ap-apon chi Hudju, ja hana a-ap-apon chi papachi ja hana memehtolon chi urchin Moses. Patajonaꞌ muti ay ni me-atloh arkhaw hot mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ja inali na khu ay chichan amin hi, “Hini mamhod an midchum ay ha-in ja mahapor an chuꞌkhona hini piꞌtakhuwana heto lota ja pi-ukhona hini kros na hi a-arkha-arkhaw, ja inunuchaꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ti hini ayya takhu an mangpa-ennongan ay ni piꞌtakhuwana heto lota ja angkhay, ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota khapo hi pangunuchana ay ha-in, ja miꞌtakhu ay Apo Jos hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anong un alan ni takhu an amin chi enachangjan ay tay lota ja ma-id pfalor hu-un ma-utaw chamchama hini piꞌtakhuwana ja nadusa hija hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hini takhu an mangpfa-in ay ha-in ja hana khun u ituchu, ja ha-in an Na-ilangitan an Takhu ja ipfa-in u khu hija ay ni arkhaw an pumpfangngachaꞌ an magwachaan hi apfalinan ja pfinang u ja hini pfinang Ama ja hana nasantuwan an angher na. ");
INSERT INTO ifu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Muti umannung hitay alloꞌ an gwacha hana uchumna ay chaꞌju an achi matoy hot ah-upan cha hini ete-aan ni i Pun-ap-apugwan Apo Jos hi tatakhu ay tay lota.” ");
INSERT INTO ifu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nalahin chin ohay markhachu ja initnud Hesus hi Peter ja hi John ja hi James, ja nunti-id cha han pfuludna ta i cha mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gwa an khun mungkalalag hi Hesus ja narman chin tikhaw chin angah na ja pomooꞌ chin pinuchaw chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Unagkhu la-ahna ja gwacha han chugwa an linala-e an khun miꞌhapit ay hija, an cha Moses ay Elijah. ");
INSERT INTO ifu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Numpatikhaw cha an nagwachaan hi apfalinan ja pfinang Apo Jos ja khun cha haphapiton hini umali an atajan Hesus ad Jerusalem ta mipa-annung chin eneꞌchan Apo Jos an ma-at. ");
INSERT INTO ifu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Khun michumor cha Peter muti na-aan chin enloꞌ cha, ti tinikhaw cha hi Hesus an gway pfinang na ja chin chugwa an linala-e an niꞌtataꞌchug. ");
INSERT INTO ifu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gwa an makak cha Moses ja inalin gwot Peter ay Hesus hi, “Apo, maphod ta immali ta-o heto. Mun-ephod ami hi tolo hi apfong ta henohha aju ay cha Moses ja hi Elijah.” Inalin Peter hitay, ti un na-apfu khapo chin tinnig cha. ");
INSERT INTO ifu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Unagkhu khun munhapit hi Peter ja himpfumagkha ja gwa han pfonot an linigmana chicha. Ja temma-ot hachi adalan, ti nun-opah chin pfonot ja liniꞌnupana chicha. ");
INSERT INTO ifu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ja gwacha han hapit an narpu ay chuy pfonot an allona hi, “Hitay hini Empfalay u an piniliꞌ. Hotti egngor ju hija!” ");
INSERT INTO ifu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Intaꞌchug chin khun munhapit ja matikhaw hi Hesus an un emmo-ohha. Ja agkhuy empfaꞌpfaag hachi adalan hato tinnig cha an na-at ingkhanah napfalin an nummahu hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chin nun-inggwiꞌgwiit ja nunchayyu cha ja cho-or hachi tatakhu an immuy an i nanittum ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Unagkhu la-ahna ja gwa han lala-e an nanggwapan ay Hesus ja inali na hi, “Rabbi! Ka-ahiyam adniꞌ han oh-ohha an empfalay u an lala-e! ");
INSERT INTO ifu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ti khun mahuꞌlungan hi napukhit an ispiritu hon himpfumagkha hon nun-ugwap hon immalipag ingkhana an umupag hini ta-o na. Punnauchon tay napukhit an ispiritu an palikhaton hija ja ahop hon un makak. ");
INSERT INTO ifu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja numpakpaka-ahiyaꞌ hay hachi disipolom ta pakakon cha hitay napukhit an ispiritu muti ma-id olog cha.” ");
INSERT INTO ifu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ja inalin Hesus hi, “Munlinapoh aju kaykhu an tatakhu an napukhit chi ugali ju. An akamoh an unaꞌ napfajag an gawwacha ay chaꞌju ja inanuhaꞌ chaꞌju, ja un kaykhu la-ahna ja ingkhana ad ugwani ja ma-id pammati ju.” Ja inali na chin ammod na hi, “Ijalim heto hini empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gwa an mehnot chin unga ay Hesus ja inhungpfub chin napukhit an ispiritu ja impa-alipag na. Muti henonglar Hesus hichin ispiritu ja penakak na. Empatenong na chin unga ja inali na ay ama na hi, “Tayya hitay empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ja nanor an amin hachi tatakhu ay ni otongngan an apfalinan Apo Jos an gwa ay Hesus. Khun cha pay haphapiton hichuy enat na ja inalin Hesus hachi disipolo na hi, ");
INSERT INTO ifu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Achi ju alichuwan hitay alloꞌ ay chaꞌju! Ha-in an Na-ilangitan an Takhu, ja achi mapfajag hot michataꞌ hana pfuhur u ja patajonaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Muti agkhuy cha na-awatan hitay inali na, ti agkhuy impa-innilan Apo Jos ay chicha, ja mun-okhon cha an manghanhan. ");
INSERT INTO ifu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gwacha han khun punhohongngilan hachi adalan nu ngachah chi napfagpfagto ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Inannilan Hesus chin khun cha nomnomnomon, hotti penchona han ohan ung-ungnga ja timmaꞌchug cha an chugwa. ");
INSERT INTO ifu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ja inali na ay chicha hi, “Hini mangakhamid hay hana namati an mipadchung ay tay unga ja inakhamichaꞌ khu. Ja hini mangakhamid ay ha-in ja inakhamid na hini nannag ay ha-in. Ti hini nabnababba ay chaꞌju ja chichay napfagpfagto ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Inalin John ay Hesus hi, “Apo, tinnig mi han ohan takhu an khun mangpakak hi napukhit an espiritu ay ni apfalinan ni ngachan mu. Ja inhingar mi ta epokhong na, ti agkhuy nidchum ay chita-o.” ");
INSERT INTO ifu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ja inalin Hesus ay chicha hi, “Achi ju epagwa. Ti un hihiya na ay chaꞌju nu achi pfumuhur ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Unot gwa an khun mehmehnot chin arkhaw an puntalakhujan Hesus ad langit ja nenomnom na an umuy an umuy hichi ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hotti hennag Hesus hana mangpangpangulu an umuy mangpa-innila han ohan pfarjun chi Samaritan ta ehakhanaan cha hija. ");
INSERT INTO ifu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Muti achi penhod hachi tatakhu hichi an mangiliyon hi Hesus khapo ta Hudju ja un maloh an umuy ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Unagkhu inannilan chin adalan an cha James ay John chin inalin hay hachi Samaritan ja empfokha cha ay Hesus hi, “Apo, epfokha mi chah ay Apo Jos ta khobhona hay hana Samaritan?” ");
INSERT INTO ifu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Muti nunligkhoh hi Hesus ja inhingar na chicha. ");
INSERT INTO ifu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Amat hichi ja empacheh cha an umuy han oha an pfarju. ");
INSERT INTO ifu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Un chaagkhu khun chumalan an umuy ja gwa han immuy ay Hesus an nangali hi, “Mimitnuchaꞌ ay he-a an amin hi omajam.” ");
INSERT INTO ifu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tempfar Hesus ja inali na hi, “Un chah angkhiloh, ti ha-in an Na-ilangitan an Takhu ja ma-id nunhitugwaꞌ hi khun u alo-an, an uchuꞌchuna agkhu niꞌ hay hana amunin ti gway hogong hi humigpan cha, ja hay hana hagwiti ti gway hapang hi pumpattu-an cha.” ");
INSERT INTO ifu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ja inalin khu Hesus han oha hi, “Miꞌjali a ay ha-in.” Tempfar na ja inali na hi, “Mapfalin, Apo, muti unchani mah ta umanamotaꞌ pay ta ujaꞌ ilupfuꞌ hi ama.” ");
INSERT INTO ifu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Muti inalin Hesus ay hija hi, “Achi, ti hay hana agkhuy namati chi manikhaw hay hana i-ibpfa cha an natoy. Muti ay he-a ja tamum chi i mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ja inalin khu han oha ay hija hi, “Apo, miꞌjalijaꞌ ay he-a. Muti khenong mah ta umujaꞌ pfumukha pay hichi pfalay mi.” ");
INSERT INTO ifu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Muti inalin Hesus ay hija hi, “Unchah gway takhu hi mun-alachu ja nunliligkhoh? Amat khu hina ay ni takhu an nangte-a an miꞌ-unud ay ha-in ja nunligkhoh hay hana homalegwa, ja ma-id inherpfin ni punserbiyana ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gwa han ohan arkhaw ja pinilin Hesus han petoy polo ta chugwa an tatakhu ja hininchuggwa na chicha an hennag ta ipangulu cha an umuy hay hana pfarju ja pfuglay an nenomnom na an omajan. ");
INSERT INTO ifu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ja inali na ay chicha hi, “Cho-or hana mabtoꞌ muti un aju tortollo an mumpfotoꞌ, ti cho-or hana tatakhu an nehahagkhana an matuchugwan muti tan un aju tortollo an umuy muntuchu. Hotti ekalalag ju ay Ama an khun mangpagpong hi mumpfotoꞌ ta honakhona hay umuy mumpfotoꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ja inali na khu hi, “Tan pfaaloꞌ chaꞌju an amat hi naꞌna-unnud an pfoꞌtot an karnero an umuy hana achaan chi tatakhu an amat hana mun-apfungot an khenger. ");
INSERT INTO ifu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Achi aju mun-ochon hi pihu, hape-eng ja hapato, ja achi aju khu miꞌhapihapit hana alagwon ju hiton chalan. ");
INSERT INTO ifu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu humikhop aju hi ohah pfalay ja hitay chi mahhun hi allon ju, ‘Pomhod hini piꞌtakhuwan ju an nunheto ay tay an pfalay.’ ");
INSERT INTO ifu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja nu gway mangapfulut ay ni pomhochan cha hot pomhod cha. Muti ma-id ayya mangapfulut hot mumpfangngad hini bindisyon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Munnanannong aju ay nuy an pfalay ja anun ju ja inumon ju hay epahango cha ay chaꞌju, ti hitay chi lagpfu ju. Ti an amin hana muntamu ja kalintikhan cha an omagwat hi linagpfu cha ay ni takhu an piꞌtamuwan cha. Achi aju i mumpfa-er hi i ju punnangngan. ");
INSERT INTO ifu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu umuy aju ay ni oha an pfuglay ja penhod chaꞌju an mangiliyon, ja ihcha ju an amin chi hay epahango cha ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ja epatenong ju hay hana mumpunchokhoh ay nuy an pfuglay, ja allon ju ay chichan amin hi, ‘Nehnot hini Pun-ap-apugwan Apo Jos ay tay lota.’ ");
INSERT INTO ifu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Muti nu umuy aju ay ni oha an pfuglay ja achi chaꞌju ayya podhon an mangiliyon, ja umuy aju ay nuy kurha ja inali ju ay chicha hi, ");
INSERT INTO ifu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Anong un hay chapor ay tay an pfuglay ju an nep-ot ay tay chapan mi ja puꞌpu-an mi ta panginnilaan ju an nakhibpfoh hini tamu mi ay chaꞌju. Hotti ikhad aju. Ti nuyya an chengngor ju hitay inali mi an nehnot hini Pun-ap-apugwan Apo Jos ay tay lota.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ja inalin khu Hesus hi, “Hotti alloꞌ ay chaꞌju, an umali ayya hini arkhaw an Panugijan Apo Jos hi tatakhu, ja machamchamot hini dusan hana tatakhu ay tay an pfuglay mu hachi tatakhu ad Sodom an khenhob Apo Jos chin timpon Abraham.” ");
INSERT INTO ifu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Inalin khu Hesus hi, “Ka-ahi cha hay hana eKorazin ja eBetsaida! Nu na-at ad Tiro ja ad Sidon hachi otong an milagro an enat u ay chuy pfuglay cha hot gwa agkhu niꞌ an napfajag an inumpfun cha an nunlolopfong hi kamma ja inlipfu chay chapor ay ni ulu cha an pangpatikhagwan chay nan-ukhan cha hi pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Umali ayya hini arkhaw an Panugijan Apo Jos an amin hi tatakhu ja machamchamot hini dusan hana eKorazin ja eBetsaida mu hay hana eTiro ja eSidon. Ti hay hato an eKorazin ja eBetsaida ja khun cha tikhan hay hato milagro ja achi cha chamchama chuꞌkhon hana pfahor cha. ");
INSERT INTO ifu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ja hay hana eKapernaum, khemhon chaot un chicha chi ma-ar-ali an napfagpfagto. Muti pfu-un an chicha chi umuy ad chalom.” ");
INSERT INTO ifu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ja niꞌhapit khu hi Hesus hachi adalana ja inali na hi, “Hay hana mangegngor ay chaꞌju ja enegngolaꞌ khu. Ja hay hana achi mamhod ay chaꞌju ja agkhujaꞌ khu penenhod ay chicha. Ja hay hana achi mamhod ay ha-in ja agkhuy cha khu penenhod hi Ama an nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Immuy chi at hichi hi arkhaw ja numpfangngad chin petoy polo ta chugwa an hennag Hesus an immuy nuntudtuchu. Ja mun-an-anla cha an mangali hi, “Apo, anong un hana napukhit an ispiritu ja nuntornug cha ay chaꞌmi ja lemmajaw cha khapo ay ni apfalinan ni ngachan mu.” ");
INSERT INTO ifu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tempfar Hesus ja inali na hi, “Amat tugwali hina, ti tinnig u hi Satanas an amat hi ilat an nakhah ad langit. ");
INSERT INTO ifu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inchat u ay chaꞌju chi apfalinan an mangkhamchit hi ulog ja hana pomatoy an oneneper ja an mangameh khu hana pfumuhur ay chaꞌju an ipangpanguluwan Satanas. Hotti achi chaꞌju apfakon. ");
INSERT INTO ifu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Muti achi aju mun-an-anla khapo ta muntornug hana napukhit an ispiritu ay chaꞌju. Hay pun-an-anlaan ju gwot ja hini nitula-an ni ngachan ju ad langit.” ");
INSERT INTO ifu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Emmopoh hitay an inalin Hesus ja empa-anlan ni Espiritu Santo hija ja nungkalalag an inali na hi, “Ama, munyamanaꞌ ay he-a an Apo hina ad langit ja heto lota, ta agkhuy mu impa-innila hay hato hana tatakhu an mangali an manomnom an cho-or chi achar cha, ta hay hana ma-id achar na chi nangpa-innilaam. Maphod hitay, Ama, ti hijah tay chi penhod mu.” ");
INSERT INTO ifu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Inalin khu Hesus hachi tatakhu hi, “Impulang Ama an amin ay ha-in ta ha-in chi mangpagpong. Ma-id uchumnah nanginnila hi omaꞌ-ataꞌ nu pfu-un hi Ama ja angkhay. Amat hina khu ay Ama an ma-id chi hay nanginnila hi omaꞌ-atana nu pfu-un ha-in an Empfalay na ja hana podhoꞌ an pangpa-innilaan ay hija.” ");
INSERT INTO ifu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Emmopoh chin inalin Hesus ja nunligkhoh ay cha chuy disipolo na ja inali na hi, “Akhaꞌkhaja aju ti tayya an khun ju tikhan hay hato khun maꞌma-at. ");
INSERT INTO ifu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ja umannung hitay alloꞌ ay chaꞌju an akhaꞌkhaja aju pay mu hachi cho-or an profetan Apo Jos ja magpong an tatakhu chin nahop, ti penhod cha an ah-upan an manikhaw hato khun ju tikhan muti agkhuy cha niꞌtikhaw. Ja penhod cha khu an munchongor hato khun ju chonglon muti agkhuy cha ne-egngor.” ");
INSERT INTO ifu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gwa han ohan arkhaw ja khun muntudtuchu hi Hesus ja timmaꞌchug han ohan mehtolon chi urchin Moses ta toptopngana hi Hesus. Ja empfokha na hi, “Rabbi, ngay peꞌ-at u ta magwachaanaꞌ hi piꞌtakhuwan an ma-id chi pogpogna?” ");
INSERT INTO ifu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tempfar Hesus ja inali na hi, “Ngay allon ni urchin Apo Jos? Ngachah chi anilam hi podhona an hapiton?” ");
INSERT INTO ifu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ja inalin chin lala-e hi, “Allon ni urchin Apo Jos hi mahapor an podhon ta-o hi Apo Jos an amin hi puhu ja nomnom ja pfi-ah ta-o, ja an amin ay tay piꞌtakhuwan ta-o. Ja allon khu tay urchin Apo Jos hi podhon ta-o hana papadchung ta-o an tatakhu an amat ay ni pamhod ay tay achor ta-o.” ");
INSERT INTO ifu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ja inalin Hesus hi, “Umannung hinuy inalim. Hotti atom hay hato hot miꞌtakhu a ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ja achi podhon chin lala-e an mapfa-inan hotti inali na khu hi, “Aa, ja ngay ngachah hay hana padchung u an tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tempfar Hesus ja inali na hi, “Gwa han ohan lala-e an narpu hichi ad Jerusalem an umuy ad Jeriko, ja pfinta-an chi mangakaw. Nun-ala cha chin lopfong na, ja numpakhuh cha ja tenaynan cha hija an gwa an mamattoy. ");
INSERT INTO ifu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Netongor ja naloh han oha an pachi. Ja tinnig na chin lala-e an mamattoy ja inliglig na. ");
INSERT INTO ifu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gwacha khu han Levita an naloh chin agwachaana ja gwan tinnig na ja inliglig na khu. ");
INSERT INTO ifu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ja naloh khu han ohan Samaritan an nunhahakkay. Ja unot emmatam chin gwachaan chin mamattoy an lala-e ja tinnig na ja ninignikha na hija. ");
INSERT INTO ifu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Immuy ja inulahana ja enakhahana hi lanob ja pfinachar na chin hukhat na ja unaot ehakay, ja in-uy na han ohan pfalay an khun ma-apfangan ja hinalimunana. ");
INSERT INTO ifu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chin nun-inggwiꞌgwiit ja inchat na han pihu ay chuy khun mumpfantay ay chuy pfalay ja inali na hi, ‘Halimunam hitay an lala-e ja un ayya ad-adchi hitay hi khahtuwom ay hija ja pfajachaꞌ hi pumpfangngachaꞌ.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ja empfokhan Hesus ay chuy mehtolon chi urchin hi, “Ngay allom tugwali ay cha tay an tolo an naloh chi gway niꞌ-ibpfa na ay tay lala-e an pfinta-an cha?” ");
INSERT INTO ifu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tempfar na ja inali na hi, “Hinuy nanakha-uy ay hija.” Ja inalin Hesus ay hija hi, “Hotti hijah tay chi atom.” ");
INSERT INTO ifu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Entoloy cha Hesus ja hachi adalan an umuy ja ne-atam cha han ohan pfarju. Ja gwa han pfupfai ay chuy an pfarju an hi Marta chi ngachana, ja enajakhana chicha hichi pfalay cha. ");
INSERT INTO ifu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja gwa han ibpfan Marta an hay ngachana ja hi Mary. Ja enep-ephod Mary an inumpfun chin hangon Hesus ta munchongor chin haphapitona. ");
INSERT INTO ifu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Muti hi Marta ja agkhuy ne-egngor, ti cho-or chin ehaghakhana na. Immuy ay Hesus ja inali na hi, “Achim adniꞌ aton hina, ti tan unaꞌ empa-ohha ay ibpfaꞌ an munhakhana. Ta allom ay hija ta tulunganaꞌ!” ");
INSERT INTO ifu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tempfar Hesus ja inali na hi, “Anagkha kaykhu, Marta, ta un cho-or chi pundanakham ");
INSERT INTO ifu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","an un hitay hini oha an mahapor. Ti tan pinilin Mary hini mapmaphochan hotti ma-id chi hay mangpagwa ay hija an munchongor.” ");
INSERT INTO ifu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gwa han ohan arkhaw an nakak hi Hesus an i nungkalalag. Emmopoh chin kalalag na ja inalin han ohan disipolo na hi, “Apo, ituchugwan chaꞌmi adchiya an mungkalalag, amat chin enat John hachi disipolo na.” ");
INSERT INTO ifu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ja inalin Hesus ay chicha hi, “Nu mungkalalag aju ja amat heto chi aton ju: ‘Ama, he-a adniꞌ chi daydayawon chi tatakhu. He-a adniꞌ chi mun-ap-apo ay chaꞌmi. ");
INSERT INTO ifu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ichat mu khu hay anun mi ad ugwani an arkhaw. ");
INSERT INTO ifu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ja pakawanom an amin chi pfahor mi, amat khu ay ni pammakawan mi hay hana pfimmahor ay chaꞌmi. Ja i-achawwim ay chaꞌmi hana atopngan an achi ami paꞌ-ahchor.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Inalin khu Hesus hay hachi disipolo na hi, “Nu khulat ta gway oha ay chaꞌju hi immuy ay ni khayyum na hi tongan chi lapfi ja inali na hi, ‘Akhiꞌ, ichatanaꞌ adniꞌ hay epa-an u ");
INSERT INTO ifu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","han mangili an immali an nunnanong hi pfalay mi, ti ma-id oh-ohhah epa-an u ay hija.’ ");
INSERT INTO ifu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nu ngay allon ni i na numpfokhaan hi, ‘Achi a umali hina an mamangopfangon, ti tayya an nicha-ig hitay pantaw ja tan ene-elloꞌ u hay hato ung-ungungnga. Hotti ma-id atoꞌ an pfumangon an mangchat ay ni epfokham.’ ");
INSERT INTO ifu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hotti alloꞌ ay chaꞌju hi anong un cha pfelot an khayyum ja achi na podhon an pfumangon an mangchat ay ni epfokha na. Muti khapo ta achi na penhod an gway ipahiw cha ay hija, ja pfumangon chamchama an mangchat ay ni mahapor na.” ");
INSERT INTO ifu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja inalin Hesus hi, “Hitay chi alloꞌ ay chaꞌju. Mun-achaw aju hot michatan aju, hingiton ju hot chakngan ju, mungkorkug aju hot mipfughor hini pantaw. ");
INSERT INTO ifu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ti hini mun-achaw ja michatan, ja hini maningit ja machakngana, ja hini mungkorkug ay ni pantaw ja mipfughor. ");
INSERT INTO ifu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ma-id ammod hi mangchat hi ulog nu hay khachiw chi epfokhan ni empfalay na. ");
INSERT INTO ifu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ja achi na khu ichat chi oneneper nu iklug chi epfokha na. ");
INSERT INTO ifu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hotti anong un aju khun pfumahor ja anila ju an mangchat hi mapmaphod ay ni empfalay ju. Nu amat hina chi khun ju aton ja un chah achi om-omod hi Ama ju an gwa ad langit an ichat na hini Espiritu Santo hay hana mumpfokha ay hija?” ");
INSERT INTO ifu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gwa han namenghan an empakak Hesus han ohan ispiritun chi nakalud an nehohoꞌlong han ohan takhu. Ja unot gwa an empakak na ja himmapit chin lala-e. Ja nanor chin tatakhu an nannig ay chuy an na-at. ");
INSERT INTO ifu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Muti allon hachi uchumna hi, “Un kaykhu hi Beelzebub an hini ap-apon chi nun-apukhit an ispiritu hini nangchat ay hija ay ni apfalinana an khun mangpakak hana napukhit an ispiritu.” ");
INSERT INTO ifu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ja hachi uchumna ja podhon cha khu an toptopngan hi Hesus, ja inali cha ta ipatikhaw na hay milagro an panginnilaan an narpu ay Apo Jos hini apfalinana. ");
INSERT INTO ifu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aniꞌ-ilan Hesus chin khun cha nomnomon ja inali na ay chicha hi, “Nu khulat ta hana tatakhu ay ni oha an himpangili ja ma-a-aggwa cha ta un chicha khu hon numpapattoy cha, hot un loꞌtatna hot mapaꞌ-i hinuy an himpangili. Amat hina khu nu itannong hana hen-a-amma hon numpapattoy cha, hot loꞌtatna hot mapaꞌ-i cha khu. ");
INSERT INTO ifu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Omaꞌ-at hina khu ay ni allon ju an hi Beelzebub an hi Satanas chi mangpakak hi napukhit an ispiritu. Nu amat heto hot un mah hi Satanas hon neꞌpatoy khu hay hana in-inupfor na. Ja khulat ta amat heto chi i na amatan hot un hija hon pinaꞌ-i na khu hini pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Allon ju an narpu ay Beelzebub hitay apfalinaꞌ an mangpakak hi napukhit an ispiritu. Ja gwacha khu hana padchung ju an Hudju an khun mangpakak hi napukhit an ispiritu. Hot un ju chah allon un narpu ay Beelzebub hini apfalinan cha? Hotti tayya an hay hato padchung ju chamchama an Hudju chi muntihtikhu an nehahalla hini khun ju nomnomnomon ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ay ha-in ja narpu ay Apo Jos hini apfalinaꞌ an mangpakak hi napukhit an ispiritu, ja hay hato chi panginnilaan ju an hennakhaꞌ ay Apo Jos an mun-ap-apo. ");
INSERT INTO ifu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Hi Satanas ja amat ay ni mapfi-ah an takhu an mumpfantay ay ni pfalay na. Enhahagkhana na hana armas na ta pfantajana hana khina-u na. ");
INSERT INTO ifu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Muti nu umali hay oha an mapfiꞌpfi-ah hot apfakona hija ja penloh na an amin hana armas na an nangehcholana, ja nun-ala na an amin hana khina-u an naploh ta pun-epfangngad na ay cha nuy tatakhu an namlohana. ");
INSERT INTO ifu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hana tatakhu an achi midchum ay ha-in ja chicha hini pfomopfohhor ay ha-in. Ja hay hana achi tomolong an mangajakhan hana tatakhu an miꞌ-unud ay ha-in ja chicha hana mangapfor hi tatakhu ta achi cha midchum ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Inalin khu Hesus hi, “Nu makak hini oha an napukhit an ispiritu an nehoꞌlong ay ni takhu hot umuy hana lukhar an ma-id nunheto ta i maningit hi i na pun-enanaan muti ma-id machakngana. Hotti allona hi, ‘Un u gwot pfangngachon chin pfalay an tenaynaꞌ.’ ");
INSERT INTO ifu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hotti mumpfangngad ja tikhana chin pfalay na an maleneh ja napanuh. ");
INSERT INTO ifu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hot epacheh na khu an i mun-aw-agwit hi peto hi munnaꞌnaud an napukhit an ispiritu ta gway pun-ibpfa na an i munheto ay ni pfalay an tenaynana. Hotti munnaꞌnaud an kaꞌka-ahi hinuy an takhu mu hichin pengpenghana.” ");
INSERT INTO ifu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gwa an khun munhapit hi Hesus ja nun-ugwap han ohan pfupfai ay chuy an khagong ja inali na ay Hesus hi, “Madmachennor hini ammod mu an nangtoꞌkhong ja nangpa-ilog ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Muti tempfar Hesus ja inali na hi, “Munnaꞌnaud an machenor hay hana munchongor ja mangat ay ni hapit Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gwa an khun chomchom-or chin tatakhu an immuy an munchongor ay Hesus ja entoloy na an munhapit ja inali na hi, “Un aju kaykhu mumpunlahlah an tatakhu ad ugwani an timpo, ti napukhit hini nomnom ju. Itugtukha ju an mangpfokha hi hay ipatikhaw u hi panginnilaan ju an narpu ay Apo Jos hitay apfalinaꞌ. Muti ma-id, ti un angkhay han omaꞌ-at chin na-at ay profeta an hi Jonah chi ipatikhaw u ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti chin nanakhuwan Apo Jos ay Jonah chi nanginnilaan hachi eNineveh an hi Apo Jos chi nannag ay hija. Amat hina khu ay chaꞌju ad ugwani. Nu mummahuwaꞌ hot hijay panginnilaan ju an hi Apo Jos chi nannag ay ha-in an Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ja anila ju an hichin pfupfai an reyna ad Sheba chin nahop ja narpu hichi achawwi an immuy ay ni agawwachaan Ari Solomon ta i nunchongor chin tukhuna. Ja tayya an ad ugwani ja gawwa ay chaꞌju han napfagpfagto mu hi Solomon muti niya an achi ju chonglon hini tukhuna. Machakngan ayya hini arkhaw an Panugijan Apo Jos hi tatakhu hot miꞌtaꞌchug hitay an pfupfai hot hijay mangpatikhaw an gway pfahor ju. ");
INSERT INTO ifu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja miꞌtaꞌchug khu hay hachi eNineveh hot chichay mangpatikhaw an gway pfahor ju. Ti hay hachi eNineveh ja chengngor cha chin engkasaban Jonah ja chin-ug chay pfahor cha. Ja tayya an ad ugwani ja gawwa han napfagpfagto mu hi Jonah an muntugtukhun ay chaꞌju ja niya an achi ju chuꞌkhon hana pfahor ju.” ");
INSERT INTO ifu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Inalin khu Hesus hi, “Achi ta-o torkhan hay panor ja i ta-o ihinop wenno halinan, ta un ta-o gwot epattoꞌ hay napataw ta mahilagwan hay takhu an humikhop ay nuy an pfalay. ");
INSERT INTO ifu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hini mata ju chi hilaw nuy achor ju. Nu maphod hini pannig ju ja mahilagwan an amin hini nomnom ju. Muti napukhit ayya hini pannig ju ja munhehellong an amin hini nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tikhagwun ju mah ta mahihillagwan hini piꞌtatagkhuwan ju ta achi munhehellong. ");
INSERT INTO ifu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nu hini hilaw chi magwacha ay chaꞌju an ma-id chi munhehellong hot mahilagwan an amin hini nomnom ju an amat hi gway mumpfinang an hilaw an manenakhan ay ni piꞌtakhuwan ju.” ");
INSERT INTO ifu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Emmopoh chin khun punhapitan Hesus ja enajakhan han Farisee ta umuy meꞌ-an ay hija. Hotti immuy hi Hesus ja i neꞌ-orpfong ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tinnig chin Farisee an agkhuy niꞌpfulu hi Hesus ja nanannor, ti hinuy chi khun aton hana Hudju ja un cha mangan. ");
INSERT INTO ifu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Muti inalin Hesus ay hija hi, “Chaꞌju an Farisee, ipatpatikhaw ju an mangat hi maphod muti hini piꞌtakhuwan ju ja na-ikot ja mangakaw. Amat aju ay ni takhu an ep-ephod na an ulahan hini nangimpfuttay ni pfahu ja chuju, muti achi na ulahan hini chohar na. ");
INSERT INTO ifu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Natottot aju an takhu! Un chah hi Apo Jos an nangephod ay ni mamattikhaw ja agkhuy na neꞌ-ephod hay hana achi matikhaw? ");
INSERT INTO ifu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tomolong aju hay hana napubli hot malenehan hini puhu ju. ");
INSERT INTO ifu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Chaꞌju an Farisee, ja manu ti anong un hana munnaud an iꞌ-iꞌ-itang an iꞌnut ju ja khun ju ichat hini khaggwan Apo Jos. Muti tayya an achi mungkhochong hini aton ju an munhugwi, ja ma-id pamhod ju ay Apo Jos. Hay koma aton ju ja khun ju ichat hini khaggwan Apo Jos muti achi ju alichuwan an mangunud hay hato napfarpfalor an urchin. ");
INSERT INTO ifu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Un aju kaykhu munnaud an Farisee an am-amja-on ju an i umpfun hana umpfunan chi ap-apo hichi sinagoga. Ja penhod ju khu an gway khun mangpaꞌpa-innila ay chaꞌju hi achoꞌlan chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Muti ka-ahi aju, ti omaꞌ-at aju hi ni-ukah an lupfuꞌ an pungkhakhattinan chi tatakhu, ti agkhuy cha anila an gway nilupfuꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ja inalin han ohan mehtolon chi urchin Moses hi, “Apo, nidchum ami an memehtolo an napfa-inan ay tay inalim hay hato Farisee.” ");
INSERT INTO ifu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ja inalin gwot Hesus hi, “Aa, chaꞌju an memehtolo ja ka-ahi aju mangkay khu, ti cho-or hana nalikhat an allon ju hi aton hachi tatakhu an achi cha paꞌ-at, muti ma-id oh-ohha hi itolong ju. ");
INSERT INTO ifu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ka-ahi aju pay, ti un ju agkhu khun ep-e-ep-ephod hana lupfuꞌ chin profetan Apo Jos an penatoy hachi a-apo ju chin nahop. ");
INSERT INTO ifu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hotti tayya an chaꞌju hitay mangpa-innila an un aju meꞌ-ampoy hichin enat chin a-apo ju. Ti chichay namatoy hachi profetan Apo Jos chin nahop ja chaꞌju chi khun mun-ephod hi lupfuꞌ cha ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja aniꞌ-ilan Apo Jos, hijaot una allon hi, ‘Honakhoꞌ hay hana profeta ja hay hana pfaar u an umuy hay hana Hudju, ja anilaꞌ an patajon cha chi uchumna ja palikhaton chay uchumna.’ ");
INSERT INTO ifu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hotti ikhad aju, chaꞌju an tatakhu ad ugwani an ar-arkhaw, ti an amin chin profetan Apo Jos an nete-a chin hophopapna ingkhana ad ugwani ja penatopatoy cha. Chaꞌju chi manchor hi dusan ni nun-a-atajan chan amin. ");
INSERT INTO ifu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nahhun hi Abel an penatoy cha ja hachi uchumna ingkhanah chin namatajan cha ay Zekariah an inah-upan cha ay ni numpfattanan ni altar ja hini Templo. Hotti tayya an alloꞌ ay chaꞌju, an chaꞌju an tatakhu ad ugwani chi manchor an amin hi dusa khapo hi nun-a-atajan hato tatakhun Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ka-ahi aju mangkay an memehtolon chi urchin Moses. Ti henalegwa ju hana tatakhu ay ni aton cha an manginnila ay ni podhon Apo Jos an peꞌ-at cha. Achi ju podhon an unuchon ja enchagkha ju khu an nangpagwa hana mamhod an mangunud.” ");
INSERT INTO ifu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Emmopoh chin inalin Hesus ja nakak ay chuy an pfalay. Ja limmapoh chin aton hachi Farisee ja memehtolon chi urchin an mamahiw ay hija. Inunud cha khu hija ja cho-or chin henanhanan cha, ");
INSERT INTO ifu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ti un cha hehemmon nu gway ehallaana ta gway aton cha an mamahiw ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gwa an khun ma-ammu-ammung chin cho-ocho-or an tatakhu ja khun cha munhihiꞌ-ig. Ja niꞌhapit hi Hesus hay hachi disipolo na ja inali na hi, “Tikhagwun ju otniꞌ ta achi aju ma-alinan hana lahlah hay hachi Farisee, ti amat ay ni pfinoꞌpfoꞌ an inla-ok ayya hana khun ta-o anun ja lomanona hini tatam na. ");
INSERT INTO ifu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti an amin chi mehaꞌpfa ja gwa han arkhaw hot mipapfutay, ja an amin hini miliꞌ-ud ja gwa han arkhaw hot ma-innila. ");
INSERT INTO ifu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hotti nu amat heto, ja an amin chi miliꞌ-ud an hapiton ja gwa han arkhaw hot ma-innila chamchama. Anong un hay i ju i-am-amu hichi kwarto ju ta ma-id mangngor ja gwa han arkhaw hot miꞌgwap.” ");
INSERT INTO ifu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Inalin khu Hesus hi, “Alloꞌ ay chaꞌju an khakhayyum u hi achi aju toma-ot hay hana umali an mamatoy ay ni achor ju. Ti un makhibpfoh hini pomatajan cha ja angkhaynana hi ma-at cha ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Muti ipa-innilaꞌ hini i ju tomaꞌtan. Eta-ot juwot niꞌ hi Apo Jos an gway apfalinana an mamatoy ay ni achor ja mangtuud ay ni lennagwa hichi impferno. Hija gwot niꞌ chi eta-ot ju. ");
INSERT INTO ifu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Anila ju an anong un hini lema an pfucheng an mahalape ja ma-id oh-ohha hi alichuwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ja anong un hay hana pfuuꞌ ju ja pfinibpfilang na. Hotti achi aju toma-ot, ti napfarpfalor aju mu hay hana cho-or an pfucheng.” ");
INSERT INTO ifu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Inalin khu Hesus hi, “Alloꞌ ay chaꞌju, an amin hana achi mangpfa-in an mangpa-innila hi nidchuman cha ay ha-in, ja ha-in an Na-ilangitan an Takhu, achiꞌ khu ipfa-in chicha an ipa-innila hana angher Apo Jos ad langit. ");
INSERT INTO ifu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Muti hay hana mangpfa-in ay ha-in hi hangon hana tatakhu, ipfa-in u khu chicha hi hangon hana angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja an amin hana munhapit hi napukhit an mipfuhur ay ha-in an Na-ilangitan an Takhu ja mapakawan cha, muti hana munhapit hi napukhit an mipfuhur ay ni Espiritu Santo ja achi cha mapakawan. ");
INSERT INTO ifu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu ijuy chaꞌju hichi sinagoga ta i chaꞌju echalom hi hangon hay hana a-ap-apo, ja achi aju madanakhan hi hay aton ju an manongpfatan ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ti ay nuy an timpo an humanguwan ju ja ituchun ni Espiritu Santo hay ehongpfat ju.” ");
INSERT INTO ifu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ja gwa han oha ay cha chuy an nakhagong an himmapit ja inali na hi, “Apo, allom adchiya ay ibpfaꞌ ta khaggwona hini pfanoh mi ja inchat na hini khaggwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Muti inalin Hesus hi, “Akhiꞌ, ngay nangali ay he-a hi un ha-in chi hugi an mangaggwa hi pfanoh ju an hin-akhi?” ");
INSERT INTO ifu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ja entoloy Hesus an nangali ay chichan amin hi, “Tikhan ju hini peꞌ-at ju ta achi aju omamnaw. Ti hitay piꞌtakhuwan ja agkhuy netataꞌ-od hi enachangjan.” ");
INSERT INTO ifu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Amat hichi ja inali na hitay pangngarig. “Gwa han ohan achangjan an lala-e an cho-or han pfentoꞌ na. ");
INSERT INTO ifu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja nenomnom na hi, ‘Ngachah chi atoꞌ? Ti tayya an achi omanay hato pang-ittugwaꞌ hay hato pfentoꞌ u.’ ");
INSERT INTO ifu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na-omtang ja nenomnom na ja inali na hi, ‘Aa, hitay chi atoꞌ. Paluhoꞌ hay hato alang u ta mumpakhachaꞌ hi o-ot-ottong ta gway pang-ittugwaꞌ hay hato pfentoꞌ u ja hay hato khina-uꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hot alloꞌ ay tay achor u hi, “Tayya! Maphod hi punleꞌleꞌnaam, ti tayya an nehahagkhana an amin chi mahapor mu hi atagwotagwon. Hotti un a tumuttungaw, ton achor, ja khun a mangmangan ja khun a umin-inum ja nun-an-anla a.”’ ");
INSERT INTO ifu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Muti inalin Apo Jos ay hija hi, ‘He-a ton natottot an lala-e, ad ugwani an lapfi ja mapogpog hini piꞌtakhuwam. Hotti ngay mangan hay hato pfentoꞌ mu?’ ” ");
INSERT INTO ifu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ja en-ang-angonoh Hesus an nangali hi, “Omaꞌ-at heto chi hay amatan hay hana mangkhimoh an mun-amung hi khina-u muti napubli cha ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ja inalin khu Hesus hay hana disipolo na hi, “Hitay chi khapo na hi pangarjaꞌ ay chaꞌju hi achi aju mundanag ay ni piꞌtakhuwan ju, hi hay i ju anun ja hay elopfong ju. ");
INSERT INTO ifu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hay atakhuwan ja pfu-un hay anun ja elopfong ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tikhagwun ju akay niꞌ hay hana hagwiti an achi cha muntanum ja mumpfotoꞌ, ja ma-id alang cha, muti panganun chamchama Apo Jos chicha. Hotti achi aju mundanag, ti munnaꞌnaud an napfalor aju mu hay hana hagwiti. ");
INSERT INTO ifu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma-id chi oha hi mangpa-anchuꞌchuꞌ-oy hi piꞌtakhuwana khapo hi danag na. ");
INSERT INTO ifu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hotti nu achi ju kaya an mangat ay tay, ja un chah chamchama lumugwon ni danag ju hana mahapor ju? ");
INSERT INTO ifu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tikhan ju akay niꞌ hay hana palagwer an achi cha muntamu ja mun-apfor. Alloꞌ ay chaꞌju an ma-id oha hi meꞌmeꞌnong chi lopfong na hay hato palagwer, anong un hi Ari Solomon an pfuher chin lopfong na. ");
INSERT INTO ifu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hana agkhu niꞌ holoꞌ an un homangaw hon napoolan ja khun lupfungan Apo Jos hi maphod. Hotti un chah achi om-omod ay chaꞌju? It-ittang kaykhu hini pammati ju! ");
INSERT INTO ifu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hotti pfu-un koma hay aton ju an maningit hi anun ja inumon chi mun-o-onan ay ni nomnom ju. ");
INSERT INTO ifu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","An amin hay hana gwah to lota an agkhuy namati ja hay hato chi ikhimoh cha an hingiton. Muti anilan Jos Ama an mahapor ju hay hato. ");
INSERT INTO ifu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hotti hay pa-ennongan juwot niꞌ ja hini pun-ap-apugwan Apo Jos ay chaꞌju, hot an amin hana mahapor ju ja ichat na.” ");
INSERT INTO ifu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Inalin khu Hesus hi, “Chaꞌju an adalan u, anong un aju tortollo, ja achi aju toma-ot, ti podpodhon Ama ju an midchum aju ay ni Pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eplaꞌ ju hana khina-u ju ta ichat ju hay hana napubli. Ehakhanaan ju gwot hini achor ju ay ni enachangjan ad langit an achi machonot, achi mapoh, achi ma-akaw ja achi mapfutan. ");
INSERT INTO ifu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ti hini ipfilang ju hi napfalor ay chaꞌju ja hinuy chi mun-o-onan ay ni nomnom ju.” ");
INSERT INTO ifu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Inalin khu Hesus hay hachi adalan hi, “Amat aju koma hi takhala an ehehemad cha an muntamu an amin hi timpo. Ja tenotorkhan cha hini chilag cha ");
INSERT INTO ifu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ta hahadchon cha hini pumpfangngachan ni apo cha an i neꞌkhagong hi kasar. Ta nu umanamut ayya ja nungkorkug ja nehahagkhana cha gwot an mangpfughor ay ni pantaw. ");
INSERT INTO ifu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uchuꞌchuna hay hana an takhala an chakngan ni apo cha an matu-ar ja mahi-ar. Alloꞌ ay chaꞌju hi munhukat hitay apo ta gway atona an mangehakhanaan hay hato takhala na ja unaot ajakhan ay ni anganan ta panganuna. ");
INSERT INTO ifu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Uchuꞌchuna hay hana takhala an chakngan ni apo cha an gwa an nunhahagkhana, anong un tongan chi lapfi wenno penghan chi talanu. ");
INSERT INTO ifu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anila ju an nu khulat ta hini ammod ay ni oha an pfalay ja anila na hini timpo an umaliyan ni mangakaw, hot mumpfantay ta epagwa na hi humigpana ay ni pfalay na. ");
INSERT INTO ifu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hotti munhahagkhana aju, ti mumpfangngachaꞌ an Na-ilangitan an Takhu ay ni timpo an agkhuy ju anila.” ");
INSERT INTO ifu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ja inalin Peter hi, “Apo, un chah chaꞌmi an adalan mu chi pangarjam ay tay an pangngarig wenno ay cha tay an tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tempfar Apo Hesus ja inali na hi, “Tayya an alloꞌ ay chaꞌju hini amatan chi takhala an manomnom ja mapagtarkan. Hijay potpot-on ni apo na an mangpagpong ay ni pfalay na, ja managwit ay ni enarkhaw an peꞌ-an hana papadchung na an takhala ay ni timpon chi punhapulan cha. ");
INSERT INTO ifu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mun-an-anla hini takhala an chakngan ni apo na an khun mangat ay ni impatamu na. ");
INSERT INTO ifu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Alloꞌ ay chaꞌju hi ehaad tay apo na hitay an takhala ta hijay mumpfantay an amin ay ni enachangjana. ");
INSERT INTO ifu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Muti khulat ta nomnomon nuy an takhala ja allona hi, ‘Aa, tayya an mapfajag ja un umanamut hini apoꞌ,’ ja ente-a na an mumpanuplit hana padchung na an takhala, ja khun mangmangan ja khun miꞌ-in-inum ja napfutong. ");
INSERT INTO ifu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Umali han timpo an agkhuy inannilan tay takhala ja umanamut hinuy apo na hot ah-upana hato an khuna aton. Hot punnauchon nuy apo na an palikhaton hija ja etapar na ad impferno ta midchum hay hana tatakhu an ngumangannu ta maparpalikhat. ");
INSERT INTO ifu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hini ayya takhala an nanginnila hi ipatamun ni apo na ja una tugwali achi aton hot munnaꞌnaud chi dusa na. ");
INSERT INTO ifu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hini ayya takhala an agkhuy nanginnila hi ipatamun ni apo na ja nehalla hay enat na, ja manghan hini dusa na. Cho-or chi hengelon Apo Jos hay hana nangchatana hi cho-or, ja munnaꞌnaud chi hengelona hay hana nangchatana hi choꞌchoꞌ-olan.” ");
INSERT INTO ifu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Inalin khu Hesus hi, “Khapo hi immaliyaꞌ heto lota ja humarjaon Apo Jos an amin chi tatakhu. Ja podhoꞌ gwot an mete-a hitay. ");
INSERT INTO ifu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anilaꞌ an pachaoꞌ hay munnaud an punlikhataꞌ ja munchokhoh hitay nomnom u ingkhana hi pa-atana. ");
INSERT INTO ifu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Un chah khemhon ju un hay apanuhan ju chi immaliyaꞌ heto lota? Achi amat heto, ti hitay immaliyaꞌ ja mangchat hi punchichinnuꞌ-ukhan ju. ");
INSERT INTO ifu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mete-a ad ugwani ja ma-a-aggwa hana hen-a-amma. Nu khulat ta lema cha ja na-aggwa cha ta tolo cha ay ni pangngerna ja chugwa cha ay ni pangngerna. ");
INSERT INTO ifu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hini ammod an lala-e ja chuꞌkhona hini lala-e an empfalay na, ja chuꞌkhon ni empfalay na an lala-e hi ama na. Amat hina khu ay ni ammod an pfupfai an chuꞌkhona hini pfupfai an empfalay na, ja chuꞌkhon ni empfalay na an pfupfai hini ammod na an pfupfai. Ja chuꞌkhon ni ina hini inapuna an pfupfai, ja chuꞌkhon khu ni na-apo an pfupfai hini ammod ahagwa na.” ");
INSERT INTO ifu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ja inalin khu Hesus hay hachi atakhutakhu hi, “Nu tikhan ju hichi alimhan omarkhaw an mahjong ja allon ju hi, ‘Chiya an umuchan,’ ja umuchan tatagwa. ");
INSERT INTO ifu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nu hini ijah ja narpu hichi negpongan chi let-ang ja allon ju an munnaud an hukhit, ja humkhit tatagwa. ");
INSERT INTO ifu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mumpfuhuur aju! Ti anila ju an mangmatunan ay ni podhonan hapiton hana matikhaw hichi ad uchu ja heto lota. Ja anagkha mah ta achi ju imatunan hini podhonan hapiton hay hato khun maꞌma-at ad ugwani an timpo?” ");
INSERT INTO ifu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Inalin khu Hesus hi, “Anagkha ta achi ju ut-utnuwon hay maphod hi peꞌ-at ju? ");
INSERT INTO ifu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ti amat aju ay ni gway utang na ja immali hini nangutangana an mangchalom ay hija. Hay maphod hi atom ja ay ni khun ju chumalanan an omajan ay ni hugi, ja empacham an miꞌhapit ta epfanag ju. Nu achim ayya aton heto hot echalom chi-a ay ni hugi. Ja hini hugi ja ichat chi-a ay ni pulih ta ipipfalud chi-a. ");
INSERT INTO ifu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ja alloꞌ ay he-a an achi chi-a ipapfutay hi pfaluchan ingkhana hi pfajacham an amin hini utang mu.” ");
INSERT INTO ifu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gwacha chin uchumna an takhu an neꞌkhagong an nangpa-innila ay Hesus hay hana eGalilee an empapatoy Pilato hi khun cha pumpadatunan hichi Templo ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ja inalin Hesus ay chicha hi, “Unchah hay nomnom ju ja ot-ottong chi pfahor hay hato mu hay hana uchumna an eGalilee khapo ta amat heto chi enat cha an nun-a-atoy? ");
INSERT INTO ifu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Achi mapfalin an amat heto. Alloꞌ ay chaꞌju, nu achi ju chuꞌkhon hana pfahor ju hot ma-upfah aju khu an amin. ");
INSERT INTO ifu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ja ngay tugwali allon ju chin himpolo ta gwalo an natoy an nakhatnan chin natuꞌ-inan chin anchu-oy an pfalay ad Siloam? Unchah hay nomnom ju ja munnaud chi impukhit cha mu hay hana uchumna an mihihidchi ad Jerusalem? ");
INSERT INTO ifu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Achi amat hina. Alloꞌ ay chaꞌju, nu achi ju chuꞌkhon hana pfahor ju hot ma-upfah aju khu an amin.” ");
INSERT INTO ifu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ja inalin Hesus ay chicha hitay pangngarig. “Gwa han lala-e an nuntanum hi ajiw an higos ay ni lota na. Immuy an i nannig nu gway pfunga na ja ma-id oh-ohha. ");
INSERT INTO ifu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ja inali na ay chuy khuna pungkharchinon hi, ‘Me-atloh tagwon ad ugwani hi khun u uma-umaliyan an pannikhan hi pfungan tay an intanum u an ajiw, ja tan agkhuy pfimmungpfunga. Hotti li-ajomot! Ti tayya an hija agkhu chi mun-onan ay tay lota.’ ");
INSERT INTO ifu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tempfar chin khun mungkharchin ja inali na hi, ‘Apo, hadhachon ta adchiya pay hi ohah tagwon ta tapfu-aꞌ hichuy puun chuy ajiw. ");
INSERT INTO ifu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja maphochot niꞌ un pfumunga ay tay umali an tagwon. Ja un ayya achi ja impali-oy mu.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gwa han Hapfachu an pungngilinan chi Hudju ja khun muntudtuchu hi Hesus han ohan sinagoga. ");
INSERT INTO ifu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ja gwacha han pfupfai an pfinoꞌ-ong chi napukhit an ispiritu hi himpolo ta gwaloh tagwon ja achi ma-an-anchong hichin khatud na. ");
INSERT INTO ifu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Unot tinnig Hesus hichuy an pfupfai ja pfinokhaana ja inali na ay hija hi, “Ad ugwani ja nawaya-an a ay tay likhat mu.” ");
INSERT INTO ifu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amat hichi ja hen-an Hesus hija ja na-uꞌjad gwot chin khatud na ja dinaydayaw na hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Khapo ay tay enat Hesus ja pfimmungot chin pangulun chuy an sinagoga. Ja inali na hay hachi tatakhu hi, “Khinumchang chi arkhaw hi puntamuwan, ja hay hato an arkhaw chi umaliyan ju an pumpa-akhahan an pfu-un hay Hapfachu an ngilin.” ");
INSERT INTO ifu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ja inalin Hesus hi, “Mumpfuhuur aju! Un chah angkhiloh un ngilin ayya ja achi ju ipfu-aan hana pfakah ja ampfaju ju ta i cha uminum? ");
INSERT INTO ifu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nu khun ju aton hitay an anong un ngilin, ja un chah achi om-omod ay tay an pfupfai an holag Abraham, an pfinalud Satanas hi himpolo ta gwaloh tagwon, ja achi agkhu niꞌ tulungan ta mipfu-aan?” ");
INSERT INTO ifu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ay chuy an inalin Hesus ja pfimma-in hachi achi mamhod ay chuy enat na. Muti mun-an-anla hachi cho-or an tatakhu khapo hay hachi milagro an khuna aton. ");
INSERT INTO ifu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Inalin khu Hesus hi, “Amat heto chi pipadchungan tay Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ipadchung u han it-ittang an pfugwan chi lakotta an enalan han lala-e ja i na intanum ay ni kharchina. Hemmangaw ayya ja emmotong ja immajiw. Ja hana hepeng na chi pun-emengan chi hagwiti.” ");
INSERT INTO ifu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ja inalin khu Hesus hi, “Amat heto khu chi pipadchungan tay Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ipadchung u khu ay ni pfinoꞌpfoꞌ an inidchum han pfupfai han toloh halug an alena. Ja impalaꞌ-ukhun chuy it-ittang an pfinoꞌpfoꞌ hichuy cho-or an alena.” ");
INSERT INTO ifu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chin khun omajan cha Hesus hichi ad Jerusalem ja empacharchallana an muntudtuchu chin pfuglay ja apfarjupfarju an khun cha agwun. ");
INSERT INTO ifu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ja gwa han nangali ay hija hi, “Apo, un chah tortollo chi tatakhu hi miꞌtakhu ay Apo Jos hi ma-id chi pogpogna?” ");
INSERT INTO ifu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tempfar Hesus ja inali na ay chicha hi, “Peꞌhehemad ju gwot niꞌ an miꞌhikhop ay ni nahugkhipfit an pantaw. Ti tayya han alloꞌ ay chaꞌju, an cho-or mangkay hana mamhod an humikhop muti achi cha miꞌhikhop. ");
INSERT INTO ifu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hini ama ay chuy pfalay, nu impfukhot na ayya hini pantaw hot mataynan aju hina pfutayna. Ja anong un aju mungkorkug an khun ju allon hi, ‘Apo, ipfughor mu adniꞌ hitay pantaw,’ hot tompfar ja allona hi, ‘Ma-id oh-ohhah anilaꞌ ay chaꞌju!’ ");
INSERT INTO ifu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ja allon ju khu hi, ‘Anagkha an un ami khun meꞌ-orpfong ay he-a. Ja nuntudtuchu a pay hichi pfuglay mi.’ ");
INSERT INTO ifu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ja tompfar khu hot allona hi, ‘Ma-id numpay anilaꞌ ay chaꞌju. Hotti makak aju, chaꞌju an khun mangat hi napukhit.’ ");
INSERT INTO ifu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja mun-okhab aju ja mungngelot ay tay pfapfa ju nu tikhan ju cha Abraham, Isaak, ja hi Jakob, ja an amin hachi profeta an gwahna cha ay ni Pun-ap-apugwan Apo Jos ad langit ja pakakon chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja gwacha hana tatakhu an marpu ay tay nunleneꞌgwoh tay lota ta meꞌ-orpfong cha ay ni pumpfehtaan ad langit. ");
INSERT INTO ifu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gwacha hana uchumna an allon cha hi ma-id pfirpfilang na heto lota, an najuna ja chicha agkhu niꞌ chi mipapfagpfagto ay ni Pun-ap-apugwan Apo Jos. Ja gwacha hana allon cha hi napfagpfagto heto lota, an chicha chi mi-ud-uchichi.” ");
INSERT INTO ifu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Emmopoh hay hato an inalin Hesus ja immuy hachi uchumna an Farisee ay hija ja inali cha hi, “Makak a heto ta umuy a hi uchumnah pfuglay, ti nan podhon Ari Herod an epapatoy chi-a.” ");
INSERT INTO ifu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ja inalin Hesus ay chicha hi, “Umuy aju ta allon ju ay nuy na-uti-ot chi nomnom na an ad ugwani ja hi magwiit ja pun-epakak u hana nehoꞌlong an napukhit an ispiritu ja epatenong u hana munchokhoh, ja ay nuy me-atloh arkhaw ja khibpfohoꞌ hana tamuwaꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ja anong un amat hina chin inalin Ari Herod, ja etoloy u an umuy ad ugwani ja hi magwiit ja hi ahhanchi hichi ad Jerusalem. Ti ngay atajan ni ohan profetan Apo Jos nu pfu-un chamchama hichi ad Jerusalem? ");
INSERT INTO ifu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Haw inay atag kaykhu chaꞌju an tatakhu ad Jerusalem, an un la-ahna ja un ju patajon hana profeta ja nungkhajang ju an amin hana honakhon Apo Jos ay chaꞌju. Khun u nomnomnomon an manga-allungan ay chaꞌju an amat hi upfuwan an eloꞌ-ob na hana empah na, muti achi ju podhon! ");
INSERT INTO ifu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hotti tayya an te-a-an chaꞌju ay Apo Jos ja ipulang na hinuy pfuglay ay chaꞌju ta un aju ikhad. Alloꞌ ay chaꞌju hi achiyaꞌ mahpay matigtikhaw ay chaꞌju ingkhana chin arkhaw an pangallan ju hi, ‘Mabindisyonan hini Hennag Apo Jos an immali an mun-ap-apo ay chita-o.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gwa han ohan Hapfachu an ngilin chi Hudju ja i neꞌ-an hi Hesus hi pfalay han ap-apon chi Farisee. Ja henehemmon chin tatakhu hay atona. ");
INSERT INTO ifu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ja gwacha han lala-e an numpanga-oꞌmom chi hu-i na ja taꞌlay na an immuy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Empfokhan Hesus ay cha chuy Farisee ja memehtolon chi urchin Moses hi, “Mapfalin chah ay ni urchin Moses chi mangpatenong hi munchokhoh hi timpon chi ngilin?” ");
INSERT INTO ifu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Muti khemmegkhenong cha. Amat hichi ja hen-an Hesus chin munchokhoh ja temmenong, ja inali na hi, “Umanamut a.” ");
INSERT INTO ifu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ja inali na ay chicha hi, “Nu khulat ta gway empfalay ju wenno pfakah ju an na-ubhung hi pfito, ja un ju chah achi i inaton khapo ta ngilin?” ");
INSERT INTO ifu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ja ma-id nampfar cha. ");
INSERT INTO ifu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chin agawwachaan Hesus ay chuy pfalay an i na neꞌ-anan, ja tinnig na hachi na-ila an mumpopolloh an i umpfun hachi umpfunan chin napili an tatakhu. Ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu khulat ta enajakhan chi-a an i miꞌ-amung hay kasar ja achi a i umpfun ay ni umpfunan hana napili an tatakhu. Ti unchani ja umali hini takhu an akhaꞌkhaja mu he-a ja hijay umpfun. ");
INSERT INTO ifu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ti umali hini nun-ila ay chaꞌju an chugwa hot allona ay he-a hi, ‘I a mannig hay pi-ipfunam ta ipapfun ta-o hitay mangili.’ Ja apfaloloy ja khun ur-ulayyon an i mipingngit. ");
INSERT INTO ifu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hitay koma chi atom. Nu na-ajakhan a, ja i a mi-ipfun hichi pingngit na. Hot umali hini nun-ila ay he-a hot i chi-a ipapfun ay ni mapmaphod an umpfunan. Hot napfagto a hi pannig hana papadchung mu an mangili. ");
INSERT INTO ifu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hini mangpapfagto ay ni achor na ja ma-ibaba. Ja ma-ipapfagto hana mumpakumbaba.” ");
INSERT INTO ifu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ja inalin Hesus ay chuy nun-ila ay hija hi, “Nu mumparti a ayya, ja achim e-ajag hana khakhayyum mu, ja hana a-akhim, ja hana achangjan an hakhokhong mu. Ti ilaon chi-a hi piggwana hot ma-ohngan hini enat mu ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hay koma atom ja nu mumparti a ayya ja hana napubli, hana napechoy, hana napi-on ja hana napfulaw chi ilaom. ");
INSERT INTO ifu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hot madmachennor a ti ma-id epfangngad cha ay he-a, muti hi Apo Jos ja ohngana hitay maphod an enat mu ay ni arkhaw an pummahuwana hay hana magpong an tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Unot chengngor han oha an neꞌ-o-orpfong ay chicha hitay ja inali na ay Hesus hi, “Madmachennor hini takhu an meꞌ-an ay nuy enhakhanan Apo Jos ay ni Pun-ap-apugwana ad langit.” ");
INSERT INTO ifu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tempfar Hesus ja inali na hi, “Gwa han ohan takhu an nunchaan ta mumparti. Ja nun-ila hi cho-or hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nachakngan chin arkhaw an pumpartiyana ja hennag na chin takhala na an i nangajakhan hachi tatakhu ta umali cha, ti nehahagkhana an amin. ");
INSERT INTO ifu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Muti an amin hay hato an na-ajakhan ja cho-or chin pampfar cha an homalegwa. Inalin chin oha ay chuy takhala hi, ‘Tan achiyaꞌ miꞌjali, ti gwa han ngininaaꞌ an lota, ja tan un u i emamad an tikhan.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ja inalin chin me-aggwa hi, ‘Tan achiyaꞌ miꞌjali, ti un gwa han ngininaaꞌ an himpolo an pfakah, ja tan unaꞌ umuy ta ujaꞌ epacha an i-alachu.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ja inalin khu chin oha hi, ‘Tan unaꞌ paꞌ-arhin hotti achiyaꞌ miꞌjali.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Numpfangngad hichuy takhala ja inali na an amin hay hato ay chuy apo na. Pfimmungot hichuy apo na ja inali na hi, ‘Ekhalakhar mu an umuy hana kurha ja hana chalan ay tay an pfuglay ta itnud mu hana napubli ja hana napechoy ja hana napfulaw ja hana napi-on ta i-alim chicha heto.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Unot naꞌnaꞌ-omtang ja napfanangngad chin takhala ja inali na ay chuy apo na hi, ‘Enat u hini inalim muti tayya an achi pay mapnu hitay pfalay.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja inali na khu ay chuy takhala na hi, ‘Nu amat hina ja umuy a hana nebtaw an kurha ja pfarju ta pilitom hana tatakhu an umali heto ta gway aton tay pfalay u an mapnu.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ja inalin chuy apo hay hachi na-amung ay chuy pfalay na hi, ‘Tayya, an alloꞌ ay chaꞌju hi achi peꞌtamtam hay hachi nahhun an na-ajakhan an agkhuy immali hitay enhakhanaꞌ.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cho-or chin tatakhu an khun mangumangunud ay Hesus ja nunligkhoh ja inali na ay chicha hi, ");
INSERT INTO ifu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“An amin hana mamhod an midchum ay ha-in ja mahapor an ot-ottong hini pamhod na ay ha-in mu hini pamhod na ay ni ammod na, ahagwa na, empfapfalay na, a-akhi na ja anong un hini piꞌtakhuwana ja un mipfilang hi disipoloꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ja mahapor khu an pi-ukhona hini kros na ja inunuchaꞌ. Achi na ayya aton hay hato ja achi mipfilang hi disipoloꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nu khulat ta gwa hay oha ay chaꞌju hi munnomnom an mumpakhad hi pfalay na, ja un chah achi umpfun hi mahhun ta nomnomona nu omanay chi pelaꞌ na hi khahtuwona ingkhanah apfalinana? ");
INSERT INTO ifu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nu achi na nomnomon hini khahtuwona ja ente-a na an manaꞌ-ad ay ni tu-ud, ja napoh hini pelaꞌ na ja ma-id pamalina ay nuy pfalay. Hot kekejan an amin chi tatakhu an mannig ay tay an ente-a na an pakhachon an pfalay ");
INSERT INTO ifu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","hot allon cha hi, ‘Tayya han takhu an nunte-a an mumpakhad muti chiya an ma-id olog na an mamalin.’ ");
INSERT INTO ifu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Amat khu hina ay ni oha an ari an un himpoloh lipfu chi hinchalo na ja podhona an khupfaton han ohan ari an chugwam poloh lipfu chi hinchalo na. Un chah achi umpfun hi mahhun ta munnomnom nu olog na an khupfaton hinuy ari an choꞌchoꞌ-or chi hinchalo na? ");
INSERT INTO ifu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nu nomnomona ta ma-id olog na ja achi na etoloy an i miꞌkhupfat hotti honakhona hana takhu na an i mamajaw ay chuy oha an ari.” ");
INSERT INTO ifu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","En-ang-angonoh Hesus an nangali hi, “Hot amat hina khu ay chaꞌju nu podhon ju an mumpfalin hi disipoloꞌ, ja mahapor an chuꞌkhon ju an amin hay hana gwa ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Inalin khu Hesus hi, “Hini umunud ay ha-in ja padchung nay ahin an maphod an mi-ahin. Muti nu achi na etoloy an miꞌ-unud ja hihiya ay ni penomhaw an ahin an ma-id mahpay tamtam na. Penomhaw ayya ja achi mi-ahin ");
INSERT INTO ifu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ja ma-id herpfi na an anong mah niꞌ un allon hi un itapfuꞌ. Hot unot etapar. Hotti pa-ennongan ju an munchongor ay tay alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gwa han namenghan an cho-or chi tatakhu an i nunchongor ay Hesus an nidchuman hana khun munhenger hi pakha ja hana uchumna an allon cha hi napfahulan an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ja mungngulongor hachi Farisee ja memehtolon chi urchin Moses ja inali cha hi, “Anagkha mah hi Hesus ta hanguwona hay hachi nun-apfahulan an tatakhu ja neꞌ-orpfong khu ay chicha?” ");
INSERT INTO ifu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Amat hichi ja inalin Hesus ay chicha hitay an pangngarig. ");
INSERT INTO ifu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nu khulat ta gway oha ay chaꞌju hi hingkhahot chi karnero na, ja na-utaw chi oha. Ngay tugwali atona? Taynana hini hijam chi polo ta han hijam an karnero hichi pahto ta i na hingiton hini oha an na-utaw ingkhanah chakngana. ");
INSERT INTO ifu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ja chinakngana ayya hot mun-an-anla an mami-ug ");
INSERT INTO ifu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","an mang-anamut. Hot ajakhana hana khakhayyum na ja hahakhokhong na hot allona hi, ‘Mun-an-anla ta-o, ti toja an chinakngaꞌ hitay karnero an na-utaw.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Alloꞌ ay chaꞌju hi amat hina khu an munnaꞌnaud chi pun-an-anlaan cha ad langit khapo ay ni ohan takhu an nan-ug hi pfahor na mu ay ni hijam chi polo ta han hijam an tatakhu an mangali hi ma-id pfahor cha hotti achi cha mahapor an muntutuju.” ");
INSERT INTO ifu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ja entoloy Hesus an nangali hi, “Amat hina khu han pfupfai an gway himpolo hi pelaꞌ na an napfalor, ja na-utaw chin oha. Ngay tugwali atona? Torkhana hini panor ta gway panikhana, ja munhikhid ta ep-ephod na an hingiton ingkhana hi chakngana. ");
INSERT INTO ifu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chinakngana ayya hot ajakhana hana khakhayyum na ja hana hahakhokhong na hot allona ay chicha hi, ‘Mun-an-anla ta-o, ti toja an chinakngaꞌ hitay na-utaw an pelaꞌ u.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Alloꞌ ay chaꞌju hi amat hina khu an mun-an-anla hi Apo Jos ja hana angher na khapo ay ni oha an takhu an nan-ug hi pfahor na.” ");
INSERT INTO ifu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ja entoloy Hesus an nangali hi, “Gwacha han ohan lala-e an chugway empfalay na an linala-e. ");
INSERT INTO ifu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Inalin chin uchichiyan ay ama na hi, ‘Ama, ichat mu gwot an amin hini epfanoh mu ay ha-in.’ Amat hichi ja eneꞌchan ama cha chin epfanoh na chin chugwa an empfalay na. ");
INSERT INTO ifu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Immuy chi at hichi hi arkhaw ja nun-inginan tay uchichiyan hichin pfanoh na ja enala na chin nungnginaana ja empacheh na. Immuy hichi achawwi an pfuglay ja khinahto na an amin hi ma-id chi poot na. ");
INSERT INTO ifu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Napoh chin pelaꞌ na ja netongor ja ulat ay chuy an pfuglay ja ma-id i na pangalan hi mahapor na. ");
INSERT INTO ifu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amat hichi ja ineꞌ-op han ohan takhu ay chuy an pfuglay. Ja hay tamu na ja i khun munchukhan. ");
INSERT INTO ifu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Munnaud an munhenaang ja podhona an i meꞌ-an chin anun chi pfapfuy, muti ma-id mangchat hi anuna. ");
INSERT INTO ifu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amat hichi ja nunnomnom ja inali na hi, ‘An akamoh hini khun anun hana takhalan ama ja gwachaaꞌ heto an matoy hi henaang na. ");
INSERT INTO ifu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hotti una-ot mumpfangngad ay ama ta alloꞌ ay hija hi, numpfaholaꞌ ay Apo Jos ja ay he-a. ");
INSERT INTO ifu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ja achiyaꞌ mipfilang hi empfalay mu. Muti ipfilangaꞌ adniꞌ hi oha an takhalam.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Amat hichi ja empacheh na an mumpfangngad ay ama na. Achawwi pay chin agwachaana ja immatunan ama na ja narmu chin otong an nignikha na. Amat hichi ja temmagtag an i nanittum ja len-om na hija. ");
INSERT INTO ifu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja inalin chin unga hi, ‘Ama, numpfaholaꞌ ay Apo Jos ja ay he-a. Ja achiyaꞌ mipfilang hi empfalay mu.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Muti inalin gwot ama na hay hachi takhala na hi, ‘Ekhalakhar ju ta i ju alan hini mapmaphochan an lopfong ta epelopfong ju ay hija. Hinghingan ju ja hinapatuwan ju. ");
INSERT INTO ifu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ja i ju alaon hini matapfa an pfakah ta partiyon ju ta mumpfehta ta-o. ");
INSERT INTO ifu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ti khenong atag chi un natoy hitay empfalay u ja un tumakhu, i nun-utaw ja tayya an immanamut.’ Amat hichi ja numpfehta cha. ");
INSERT INTO ifu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hichin panguluwan ja narpu an i nuntamu. Unagkhu gwan me-atam hi pfalay cha ja chengngor na chin hingalangala. ");
INSERT INTO ifu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ja enajakhana chin ohan takhala ja empfokha na hi, ‘Ngachah chuy khun cha aton?’ ");
INSERT INTO ifu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tempfar chin takhala ja inali na hi, ‘Immanamut hi ibpfam hotti impartiyan amam ay ni empatapfa na an pfakah, ti immanamut an mamattakhu.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pfimmungot chin panguluwan ja achi na podhon an miꞌhikhop. Amat hichi ja pfimmutay hi ama na ja inar-aloꞌ na. ");
INSERT INTO ifu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Muti inali na hi, ‘Tikham akay niꞌ, Ama. Atanay tagwon hi nanganuhaꞌ an nangatan hana impatamum ja inunud u an amin hana inalim ay ha-in. Ja ma-id mah niꞌ oha hi khancheng hi inchat mu ta partiyon mi hay hana khakhayyum u. ");
INSERT INTO ifu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ja unagkhu immanamut hitay empfalay mu an nangahto an amin hana empfanoh mu ay hija hi ma-id chi poot na ja i na pay empfabpfapfai, ja impartiyam agkhu niꞌ ay ni empatapfam an pfakah.’ ");
INSERT INTO ifu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ja inalin ama na hi, ‘Amat heto, ton empfalay u. Ay tay a-arkha-arkhaw ja gawwacha a ay ha-in ja an amin hato khina-uꞌ ja khina-um. ");
INSERT INTO ifu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hotti un ta-o chah achi mun-an-anla ja impartiyan ta-o? Ti tayya an khenong atag chi un natoy hi ibpfam ja un tumakhu, i nun-utaw ja tayya an immanamut.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Inalin Hesus hachi disipolo na hi, “Gwacha han ohan achangjan an nangpapfantay chin enachangjana han takhala na. Inchiklamu cha ay hija chin khun aton chin takhala na an agkhuy na empa-ennongan hichuy tamu na. ");
INSERT INTO ifu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hotti empapfokha na hichuy takhala na ja inali na hi, ‘Ngachah nuy inali cha an im enat? Ijalim an amin hana lehtaan an gwa ay he-a, ti tan aanuꞌ he-a ad ugwani.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nunnomnom hitay an takhala ja inali na hi, ‘Ngachah chi atoꞌ? Ti tan aanunaꞌ ay tay tamuꞌ. Ad-adchiyaꞌ an i miꞌtamu hi anuꞌ ja pfuma-inaꞌ khu an mun-achaw. ");
INSERT INTO ifu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, anilaꞌ mahpay hay atoꞌ, ta gway aton chi tatakhu an mangeꞌ-op ay ha-in nu aanunaꞌ ay tay tamuꞌ.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ja enohha-ohha na an enajakhan hana gway utang na ay chuy apo na. Inali na chin oha hi, ‘Atanay utang mu ay ni apoꞌ?’ ");
INSERT INTO ifu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tempfar na ja inali na hi, ‘Hingkhahot an angang hi mantika.’ Ja inalin khu chin takhala hi, ‘Tayya hitay lihhipfum hotti alaom ta hukatam gwot hitay nitulaꞌ hi un lemay polo hini utang mu.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ja inali na khu chin oha hi, ‘Atanay utang mu ay ni apoꞌ?’ Tempfar na ja inali na hi, ‘Hingkhahot an pfajon hi trigo.’ Ja inalin chin takhala hi, ‘Tayya hitay lihhipfum ta hukatam hitay nitulaꞌ hi un gwaloy polo hini utang mu.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Unot inannilan chin apo na hitay enat na ja inali na hi, ‘Mu agkhu niꞌ an tayya kan kaykhu an nakhaꞌ-ila hitay an takhala. Ti anila na hini aphochan ni piꞌtakhuwana.’ ” Ja inalin khu Hesus hi, “Tikhan ju an munnaꞌnaud an nakhaꞌ-ila hana agkhuy namati mu hana namati, ti anila cha an meꞌkadwa hi papadchung cha an agkhuy namati. ");
INSERT INTO ifu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Hotti tayya han alloꞌ ay chaꞌju. Hay maphod ja khahtuwon ju hini enachangjan ju heto lota ay ni ap-aphochan chi tatakhu, ta umali ayya hini apogpokhan chi piꞌtakhuwan an ma-id mahpay pungkhahtuwan, ja mun-an-anla hana tinulungan ju an tatakhu an manittum ay chaꞌju ad langit an agwachaan chi piꞌtakhuwan an ma-id chi pogpog na. ");
INSERT INTO ifu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hini takhu an mapagtarkan an mangpapaptoꞌ an mangat hi it-ittang an tamu ja epapaptoꞌ na khu an tamuwan hay ot-ottong. Muti hini munloko hi it-ittang an tamu ja om-omod an lukuwana hini ot-ottong. ");
INSERT INTO ifu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hotti mahapor an anila ju an mangpaptoꞌ hana enachangjan heto lota nu podhon ju an michatan hi nahamad an enachangjan ad langit. ");
INSERT INTO ifu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja mahapor khu an anila ju an manalimun hay hana enachangjan chi uchumna nu podhon ju an michatan. ");
INSERT INTO ifu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hini takhala ja achi mapfalin an munchehhan an miꞌtamu ay ni chugwa an ap-apo, ti hay atona ja podhona hini oha ja chin-ug na hini oha. Unuchona hini oha ja pinahiw na hini oha. Amat hina khu ay chaꞌju an achi mapfalin an punchehhanon ju an munserbi ay Apo Jos ja hay enachangjan.” ");
INSERT INTO ifu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Unot chengngor hachi Farisee an mammamhod hi pelaꞌ chin inalin Hesus ja piniwpigwitan cha ja pinahiw cha hija. ");
INSERT INTO ifu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ja inalin Hesus ay chicha hi, “Chaꞌju hana tatakhu an mangpatpatikhaw an magpong aju muti anilan Apo Jos hini nun-u-uttor ay ni nomnom ju. Gwa hana khun aton chi tatakhu an khemhon chay maphod muti unagkhu ipapfubpfungot hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Chin urchin Moses ja chin intulaꞌ chin profetan Apo Jos ja hijay nangtuchu hi aton chin tatakhu ingkhanah immaliyan John Bautista. Nete-a ay chuy ja khun mekasaba hini Ebanghelyo an mangpa-innila ay ni umali an Pun-ap-apugwan Apo Jos. Ja cho-or cha an mungkhikhihhu an mamhod an midchum. ");
INSERT INTO ifu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Muti anong un ma-upfah hitay lota ja ad uchu muti achi ma-utaw hini urchin Moses, an anong un hay it-ittang hi nikhulit. ");
INSERT INTO ifu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hini lala-e an manghijan hi ahagwa na ta i pumiggwa ja hihiya an immilugtap chamchama. Ja hihiya an immilugtap khu hini lala-e an mangahagwa ay ni pfupfai an nihijan.” ");
INSERT INTO ifu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ja inalin Hesus hitay an pangngarig. “Gwacha han ohan pfaꞌnang an nun-angingina an amin chi lopfong na, ja a-arkha-arkhaw hon maphod hini khuna anun. ");
INSERT INTO ifu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ja gwacha khu han napubli an hay ngachana ja hi Lazarus an napoghaan an amin chi achor na. Ja i cha empapekheng hichin pantaw ni pfalay chuy pfaꞌnang. ");
INSERT INTO ifu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Penhod Lazarus an anun hay makhah ay ni lamehaan ni pfaꞌnang muti achi cha podhon an ichat. Meꞌchagkha khu ja i khun chirchilan hachi aho hay hachi pogha na. ");
INSERT INTO ifu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nachakngan chin natajan Lazarus ja in-uy hana angher chin lennagwa na an i nidchum ay Abraham. Natoy khu chin pfaꞌnang ja nilupfuꞌ ");
INSERT INTO ifu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ja immuy hichi ad chalom, ja munnaud an malikhatan. Tenangad na ja tinnig na cha Abraham ay Lazarus an ni-a-achawwi. ");
INSERT INTO ifu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ja nun-ugwap ay hi Abraham ja inali na hi, ‘Apo Abraham, ka-ahiyanaꞌ adniꞌ ta allom ay Lazarus ta tod-ona hay chanum ta ijali na an itidtid ay tay himot u. Ti tan munnauchaꞌ an malikhatan ay tay apoy.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tempfar Abraham ja inali na hi, ‘Nomnomnomom an chin achaam hichi lota ja maphod an amin chi niꞌtakhuwam. Hi Lazarus ayya ja ma-id pohodna hi niꞌtakhuwana. Ad ugwani ja gwa heto hi Lazarus an mun-an-anla ja gwa a hina an malikhatan hi munnaud. ");
INSERT INTO ifu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ja meꞌchagkha khu ja tayya han enephod Apo Jos an numpfattanan ta, hotti achi mapfalin an gway marpu heto an umali hina. Ja ma-id khu marpu hina hi umali heto.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tempfar chin pfaꞌnang ja inali na hi, ‘Ti kan un ayya amat hina ja honakhom adniꞌ hi Lazarus ta umuy hichi pfalay cha ama. ");
INSERT INTO ifu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ti gwacha han lema an a-akhiꞌ, ta i na tukhunon chicha ta achi cha miꞌjali heto achaan chi likhat.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Muti inalin Abraham hi, ‘Gwa hichi hana impatulaꞌ Apo Jos an intuchun Moses ja hachi profeta an pfahaon cha.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ja inalin chin pfaꞌnang hi, ‘Achi omanay hinuy, Apo Abraham, ti nu gwachay natoy an mummahu an umuy ay chicha hot muntutuju cha.’ ");
INSERT INTO ifu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Muti inalin Abraham hi, ‘Nu achi cha pattiyon chin impatulaꞌ Apo Jos an intuchun Moses ja hachi profeta, ja anong un gway mummahu ja achi cha chamchama mamati.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ja inalin Hesus hay hachi disipolo na hi, “Umannung an umali hana khumapo hi pfumahulan chi tatakhu, ti khangayna. Muti munnaꞌnaud an ka-ahi hini takhu an chumalat hi pfumahulan. ");
INSERT INTO ifu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Toꞌ-onot hi un ekho-od hay machamot an pfato ay ni pfokhang na ja intuud hichi baybay ta marteng, mu hini un hijay chumalat hi pfumahulan chi oha an paꞌ-amati ay ha-in, anong un hay oha an nababa. ");
INSERT INTO ifu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hotti pa-ennongan ju hini peꞌ-at ju. Ihingar mu hini ibpfam nu pfumahor, ja pakawanom nu umali an mumpakawan ay he-a. ");
INSERT INTO ifu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anong un mumpapeto an pfumahor ay he-a hi hen-arkhaw hon immali an mumpakawan ja mahapor an pakawanom hija.” ");
INSERT INTO ifu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Inalin hachi apostol ay Hesus hi, “Ipapfiꞌpfi-ah mu hitay pammati mi!” ");
INSERT INTO ifu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tempfar Hesus ja inali na hi, “Nu gwa koma hay pammati ju hi mipadchung ay ni it-ittang an pfugwan chi lakotta, ja mapfalin an allon ju ay tay otong an ajiw hi, ‘Mapfaꞌkhut a ta i a mitanum hichi baybay!’ hot ma-at.” ");
INSERT INTO ifu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Inalin khu Hesus hi, “Nu khulat ta gwacha ay chaꞌju chi gway takhala na an i nun-alachu wenno nun-enchog hi karnero ja immanamut, ja un mu chah allon hi, ‘Umali a gwot ta umpfun a ta mangan a’? ");
INSERT INTO ifu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Achim an hay allom ja, ‘I a munhukat ja enhakhanam ta mahhunaꞌ an mangan ja un a meꞌ-an.’ ");
INSERT INTO ifu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Achi khahin un a munyaman ay ni takhalam. Atona tugwali hana inalin ni apo na ti tamu na. ");
INSERT INTO ifu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Amat hina khu ay chaꞌju. Napfalin an enat ju an amin chi inalin Apo Jos an peꞌ-at ju ja hay gwahna koma ay ni nomnom ju ja, ‘Un ami tugwali takhala, hotti enat mi hitay tamu mi.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Entoloy Hesus chin omajana ad Jerusalem ja eneꞌgwa na ay nuy numpfattanan chi Samaria ja Galilee. ");
INSERT INTO ifu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ja unagkhu gwa an me-atam cha han oha an pfarju ja gwa han himpolo an linala-e an nun-a-unit an alagwona. Tinnig cha chuy an linala-e hi Hesus ja intaꞌchug cha ta achi cha mehnot. ");
INSERT INTO ifu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ja hi-u-ugwap cha an mangali hi, “Apo Hesus, ka-ahiyan chaꞌmi adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tinnig Hesus chicha ja inali na hi, “Umuy aju mumpatikhaw hay hana papachi.” Ja gwa an khun cha umuy ja temmenong cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tinikhaw chin oha an na-aan chin unit na ja numpfangngad ja khuna pun-iꞌgwap an mundayaw ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Temmagtag an i nunheppe ay Hesus ja nunyaman. Ja un pay Samaritan hitay an lala-e. ");
INSERT INTO ifu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja inalin Hesus hi, “Un chah achi himpolo chi temmenong? Chaadma mah hini hijam? ");
INSERT INTO ifu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Anagkha ta un oha hitay Hentil chi numpfangngad an nunyaman ay Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Amat hichi ja inalin Hesus ay hija hi, “Tumaꞌchug a ta umuy a ay ni omajam, ti tan temmenong a khapo ay ni pammatim.” ");
INSERT INTO ifu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gwa hana Farisee an nangpfokha ay Hesus hi, “Aꞌ-anunay umaliyan ni Pun-ap-apugwan Apo Jos ay chita-o?” Tempfar Hesus ja inali na hi, “Hini umaliyana ja ma-id pangmatunan hi mamattikhaw. ");
INSERT INTO ifu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja achi mapfalin an allon cha hi, ‘To heto’ wenno ‘Chiya hichi’ ti tayya an gawwacha ay chaꞌju ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Amat hichi ja inalin khu Hesus hachi disipolo na hi, “Umali han arkhaw an umijahop aju hi pumpfangngachaꞌ an Na-ilangitan an Takhu, muti achiyaꞌ pay umali. ");
INSERT INTO ifu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Allon chi tatakhu ay chaꞌju hi, ‘Tayya heto hini Hennag Apo Jos an Mamahhod!’ wenno ‘Chiya hichi!’ Achi ju unuchon chicha. ");
INSERT INTO ifu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ti ha-in an Na-ilangitan an Takhu ja mumpfangngachaꞌ an amat hi ilat an mepfachong ad uchu ja tikhan an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Muti hay mahhun ja munlikhataꞌ ja chuꞌkhonaꞌ hi tatakhu ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hay omaꞌ-atan ni pumpfangngachaꞌ an Na-ilangitan an Takhu ja amat chin na-at chin timpon Noah ");
INSERT INTO ifu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","an chin tatakhu ja un cha khun mangmangan ja mangin-inum ja mumpun-ah-ahagwa ingkhanah chin arkhaw an himmikhopan cha Noah chin papor. Kheꞌ-emhon cha ja immali chin lotot ja narteng cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hihiya khu hini na-at chin timpon Lot an un cha khun mangmangan ja mangin-inum, ngumina ja mungngina, muntamu ja mumpakhad chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ja unot nachakngan chin arkhaw an nakakan Lot hichi ad Sodom ja amat hi uchan chin apoy an narpu ad uchu ja nagpfu cha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja amat hina khu nu mumpfangngachaꞌ an Na-ilangitan an Takhu an marpu ad langit, an khemhon chi tatakhu unaꞌ achi mumpfangngad. ");
INSERT INTO ifu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ay nuy an arkhaw an pumpfangngachaꞌ ja hini takhu an gwa hi partug ni pfalay na ja achi agkhu i humikhop ta alaonay khina-u na, ta un atoꞌtogna ja empacheh na an lomajaw. Ja hini takhu an gawwa hichi pajaw ja achi umanamut an mangala hi khina-u na ta un atoꞌtogna ja lemmajaw. ");
INSERT INTO ifu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Un ju chah agkhuy anila hichin na-at chin ahagwan Lot? ");
INSERT INTO ifu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hini takhu an mangpa-ennongan ay ni piꞌtakhuwana heto lota ja angkhay, ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota ja miꞌtakhu ay Apo Jos hi ma-id chi pogpog na. ");
INSERT INTO ifu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Alloꞌ ay chaꞌju hi, chin pumpfangngachaꞌ ja nu gway chugwa hi takhu an nunchechelloh an nanalloꞌ, ma-ala hini oha ja mataynan hini oha. ");
INSERT INTO ifu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ja khulat na ta gwacha hay chugwa hi pfinapfai an khun mungkheleng, ma-ala hini oha, ja mataynan hini oha. ");
INSERT INTO ifu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ja anong un hay chugwa hi linala-e an khun muntamu, ma-ala hini oha ja mataynan hini oha.” ");
INSERT INTO ifu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ja empfokhan hachi adalan hi, “Apo, chaad chi pa-atan hato?” Ja inali na hi, “Anila ju an ay ni achaan chi natoy ja ma-amung hana hagwiti an i omman ay ni achor na.” ");
INSERT INTO ifu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ja inalin Hesus hay hachi disipolo na hitay an pangngarig ta ituchu na an mahapor an etortoloy cha an khun mungkalalag ta achi cha inganuy. ");
INSERT INTO ifu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ja inalin Hesus hi, “Gwa han hugi han ohan pfuglay an ma-id ta-ot na ay Apo Jos. Ja achi na ipfilang hana papadchung nah takhu. ");
INSERT INTO ifu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ja gwa han ohan napfalo ay chuy an pfuglay an omarkhaw an umuy ay tay hugi an khun i mangamangali hi, ‘Tulunganaꞌ adniꞌ ay ni achi ohto an i cha nangchaloman ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Khun umu-umuy hitay an pfalo hon nginangannun tay hugi. Muti omaꞌ-angonoh ja nenomnom na hi, ‘Anong tatagwa un ma-id ta-ot u ay Apo Jos ja achiꞌ ipfilang hana papadchung u an takhu ");
INSERT INTO ifu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ja tulungaꞌ hitay an pfalo ta epadchong u an hijay omapfak ay ni nangchaloman cha ay hija, ti tan pahikhaonaꞌ ay tay khuna uma-umaliyan.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ja inalin Hesus hi, “Nu chengngor ju hitay inalin tay napukhit an hugi an tulungana hitay an napfalo, ");
INSERT INTO ifu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ja un chah achi om-omod ay Apo Jos an tulungana hay hana tatakhu an pinili na an khun mumpatolong ay hija hi a-arkha-arkhaw ja alapfilapfi? Alloꞌ ay chaꞌju hi achi na ekhenkhenong an ");
INSERT INTO ifu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","manulungan ay chicha. Anong chamchama un amat heto chi aton Apo Jos ja chin pumpfangngachaꞌ an Na-ilangitan an Takhu ja cho-or hana humikha ja mangnganuy an mungkalalag, ti ma-id pammati cha.” ");
INSERT INTO ifu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ja inalin khu Hesus hitay pangngarig hay hachi mumpa-akhaja an tatakhu an nange-ehchor ay ni aphod cha ja khun cha pumahiw hana uchumna an tatakhu. Ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Gwa han chugwa an linala-e an i nungkalalag hichi Templo. Farisee chin oha ja munhenger hi pakha chin oha. ");
INSERT INTO ifu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Gwan himmikhop cha ja i nun-ohha an nungkalalag hitay an Farisee ja inali na hi, ‘Agyamanaꞌ, Apo Jos, ta achiyaꞌ amat hana uchumna an khun omakaw, ja pumaꞌ-i hi urchin ja khun umilugtap. Ja agyamanaꞌ ta achiyaꞌ amat ay tay khun munhenger hi pakha an napfahulan. ");
INSERT INTO ifu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ti chugwah arkhaw chi pungngilinaꞌ hi ohay markhachu an achiyaꞌ khun mangan, ja khun u ichat hini apagkapollon an amin hay hana khun u iꞌnut ja pfoꞌlaon.’ ");
INSERT INTO ifu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Muti hitay khun munhenger hi pakha ja nenebtaw an timmataꞌchug. Pfuma-in an mangtangad an mungkalalag muti unaot nun-ug-ug chin pfokhaꞌ na ja inali na hi, ‘Apo Jos, ka-ahiyanaꞌ adniꞌ an oha an napfahulan.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ja inalin Hesus hi, “Tayya han alloꞌ ay chaꞌju, an hitay khun munhenger hi pakha ja immanamut an penakawan Apo Jos chi pfahor na. Muti hitay an Farisee ja agkhuy napakawan. Ti hini mangpapfagto ay ni achor na ja ma-ibaba. Ja ma-ipapfagto hini mumpakumbaba.” ");
INSERT INTO ifu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gwa han namenghan an in-uy cha hachi ung-ungungnga ay Hesus, ti podhon cha an eh-a na hini ngamoy na ta bindisyonana chicha. Unot tinnig hachi disipolo na ja nun-ihingar cha chicha. ");
INSERT INTO ifu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ja enajakhan gwot Hesus hachi ung-ungungnga ja inali na hachi disipolo na hi, “Anong khu ja in-ali cha ay ha-in hato ung-ungungnga. Achi ju epagwa, ti hay hana tatakhu an miꞌpadchung hi ung-ungungnga ja chicha chi midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Umannung hitay alloꞌ ay chaꞌju an hini aton ju an mangapfulut ay ni Pun-ap-apugwan Apo Jos ja mahapor an amat ay ni aton chi unga an mangakhamid hi michat ay hija. Ti nu achi amat hetoy aton ju hot achi aju midchum.” ");
INSERT INTO ifu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nunhanhan han ohan ap-apon chi Hudju ay Hesus ja inali na hi, “Maphod a, Apo. Hotti ngay allom hi atoꞌ ta magwachaanaꞌ hi piꞌtakhuwan an ma-id chi pogpogna?” ");
INSERT INTO ifu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ja inalin Hesus ay hija hi, “Anagkha ta allom hi unaꞌ maphod? An un hay maphod ja hi Apo Jos ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anilam jaꞌ hana urchin an allon cha hi, ‘Achi aju umilugtap, ja achi aju pomatoy, ja achi aju omakaw, ja achi aju muntihtikhu hi achi umannung, ja unuchon ju hana a-ammod ju.’” ");
INSERT INTO ifu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tempfar chin lala-e ja inali na hi, “Khun u unuchon hay hato an urchin, nete-a chin a-ung-ungngaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chengngor Hesus hitay ja inali na hi, “Gwacha pay han oha an agkhuy mu enat. Eplaꞌ mu an amin hana enachangjan mu ja inchat mu hini polaꞌ na hana napubli, hot michatan a hi enachangjan ad langit. Enat mu ayya hitay ja immali a ta mitnud a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Unaagkhu chengngor hitay inalin Hesus ja immayyong hija, ti munnaud chin enachangjana ja ay-ayyugwana. ");
INSERT INTO ifu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Emmohchong Hesus hitay an achangjan ja inali na hi, “Munnaud an nalikhat hana achangjan an midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nalaklaka agkhu niꞌ hini kemer an lompfot ay ni opfot ni tanud mu hini achangjan an midchum ay ni Pun-ap-apugwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hachi nangngor ja empfokha cha ay Hesus hi, “Hotti nu achi miꞌtakhu hana achangjan, ja ngay ngachah mah chi hay miꞌtakhu?” ");
INSERT INTO ifu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tempfar Hesus ja inali na hi, “Hana achi mapfalinan chi takhu ja mapfalin an amin ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Himmapit hi Peter ja inali na ay Hesus hi, “Hot chaꞌmi mah an nanaynan hi nunhitugwan mi ta nitnud ami ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ja inalin Hesus ay chichan amin hi, “Umannung hitay alloꞌ ay chaꞌju, an hana nanaynan hi pfalay cha, ahagwa cha, a-akhi cha, a-ammod cha ja empfapfalay cha khapo hi punserbiyan cha ay ni Pun-ap-apugwan Apo Jos ");
INSERT INTO ifu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ja choꞌchoꞌ-olan chi michat ay chicha ay tay piꞌtakhuwan cha heto lota, ja omaꞌ-angonoh ja michatan cha khu hi piꞌtakhuwan an ma-id chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","En-ohhan Hesus hachi hempolo ta chugwa an adalana ja inali na ay chicha hi, “Chonglon ju! Tayya an umuy ta-o ad Jerusalem ja umannung an ma-at an amin hana intulaꞌ hana profeta an ma-at ay ha-in an Na-ilangitan an Takhu, ");
INSERT INTO ifu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","an mipulangaꞌ hana Hentil an mangekejan ja mamahiw ja manuppaan ");
INSERT INTO ifu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ja manuplit ay ha-in. Patajonaꞌ muti ay ni me-atlon arkhaw ja mummahuwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Muti ma-id oh-ohha hi anilan hachi adalan chin khun hapiton Hesus, ti khenong chi nahahallinan hini nomnom cha ja agkhuy cha pay na-awatan hini podhona an allon. ");
INSERT INTO ifu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Gwa an omatam cha Hesus hichi ad Jeriko ja gwa han napfulaw an inu-umpfun ay chuy pingngit chi chalan an khun mun-ad-adchaw. ");
INSERT INTO ifu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Naleꞌnan chuy an napfulaw an cho-or hachi maloh ja empfokha na hi, “Ngay ngachan hay hana?” ");
INSERT INTO ifu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ja inali cha ay hija hi, “Chiya an un maloh hi Hesus an eNazaret.” ");
INSERT INTO ifu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Amat hichi ja iniꞌgwap chin napfulaw an nangali hi, “Hesus an holag Ari David, ka-ahiyanaꞌ adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hachi nangpangpangullu ja inhingar cha hija ta khomenong, muti en-om-omod chin napfulaw an nangiꞌgwap hi, “Hesus an holag Ari David, ka-ahiyanaꞌ adniꞌ!” ");
INSERT INTO ifu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Intaꞌchug Hesus ja inali na hi, “Ijali ju hichuy napfulaw ay ha-in.” In-uy cha ay Hesus ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngay podhom hi atoꞌ ay he-a?” Ja inalin chin napfulaw hi, “Apo, podhoꞌ an mitikhaw hitay mataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ja inalin Hesus hi, “Mitikhaw hini matam khapo hi pammatim.” ");
INSERT INTO ifu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ja mitikhaw gwot chin matan chin napfulaw ja nitnud ay Hesus ja khuna daydayawon hi Apo Jos. Ja an amin hachi tatakhu an nannig ay tay an na-at ja dinaydayaw cha khu hi Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Entoloy cha Hesus an umuy ad Jerusalem ja enenggwa cha ad Jeriko. ");
INSERT INTO ifu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ja gwa han lala-e an achangjan hichi ad Jeriko an hay ngachana ja hi Zakeyus. Oha hija an ap-apon hana khun munhenger hi pakha. ");
INSERT INTO ifu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Podhona an piꞌtikhaw hi Hesus muti khapo ta hoꞌhoꞌchod ja ma-id atona, ti lini-ub chin cho-or an tatakhu hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hotti hay enat na ja entagtag na ta impangulu na ja emmajat han sikamor an ajiw ta gway atona an manikhaw ay Hesus an maloh. ");
INSERT INTO ifu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Unagkhu emmatam hi Hesus chin agawwachaan Zakeyus ja tenangad na ja inali na ay hija hi, “Zakeyus, mun-opah a gwot, ti tan miꞌjalijaꞌ ay he-a ad ugwani hichi pfalay ju.” ");
INSERT INTO ifu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Khinalakhar Zakeyus an nun-opah ja nun-an-anla an nangali hi, “Maphod ta miꞌjali a hi pfalay mi.” ");
INSERT INTO ifu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja an amin hachi tatakhu an nannig an niꞌjuy hi Hesus ay Zakeyus ja hingungulungor cha an nangali hi, “Anagkha ta i mumpamangili hi Hesus ay ni pfalay tay an khun munhenger hi pakha an napfahulan?” ");
INSERT INTO ifu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Timmaꞌchug hi Zakeyus ja inali na ay Apo Hesus hi, “Tayya an ad ugwani ja ichat u hitay khaggwan tay khina-uꞌ hay hana napubli, ja epfangngad u an amin chi enakaw u hi mumpa-apat ay ni pfalor na.” ");
INSERT INTO ifu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ja inalin Hesus ay hija hi, “Ad ugwani ja immali hini panakhuwan Apo Jos ay tay an pamilya, ti oha khu hija an numpfalin hi umannong an holag Abraham khapo hi pammati na. ");
INSERT INTO ifu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ti ha-in an Na-ilangitan an Takhu, ja immaliyaꞌ an maningit hay hana na-utaw an tatakhu ta takhuwoꞌ chicha.” ");
INSERT INTO ifu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nehnot cha ad Jerusalem ja khemhon hachi tatakhu unot machakngan hini Pun-ap-apugwan Apo Jos nu umuy cha ad Jerusalem. Hotti entoloy Hesus an nangali ay tay an pangngarig. ");
INSERT INTO ifu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ja inali na hi, “Gwa han oha an ap-apo an umuy han achawwi an pfuglay an i munhapata ta mun-ari ja unot mumpfangngad ay chuy pfuglay an pun-ap-apugwana. ");
INSERT INTO ifu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Empapfokhan tay ap-apo han himpolo an takhala na ja inchatana chicha an amin hi pelaꞌ ja inali na hi, ‘Ikumerchu ju hitay ingkhana hi pumpfangngachaꞌ.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amat hichi ja empacheh na. Muti khapo ta achi podhon hachi tatakhu ay chuy pfuglay an pun-ap-apugwana ja hennag cha hachi umuy an i mangpa-innila an achi cha podhon an mun-ari hija ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nunhapata chamchama an hijay ari hotti numpfangngad. Ja empapfokha na chin himpolo an takhala an inchatana hi pelaꞌ ta annilaona nu atanay intu-u na. ");
INSERT INTO ifu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Immuy chin oha ja inali na hi, ‘Apo, ingkumerchuꞌ chin pelaꞌ mu ja tayya an numpapolo hitay intu-u na.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ja inalin chin apo na hi, ‘Maphod a an takhala. Empa-ennongam an nangpaptoꞌ ay nuy it-ittang an impulang u ay he-a, hotti pumpfantajoꞌ he-a hi himpolo hi pfuglay.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Immuy khu chin oha an takhala ja inali na hi, ‘Apo, tayya an numpalema hitay intu-un chin pelaꞌ mu.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ja inalin chin apo na hi, ‘Maphod. Hotti pumpfantajoꞌ he-a hi lema hi pfuglay.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Immuy khu chin oha an takhala ja inali na hi, ‘Apo, tayya atag an epfangngad u chin pelaꞌ mu. Ti un u teneplakhan ja enhaꞌpfaꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Temma-otaꞌ atag ay he-a, ti anilaꞌ an mapfungot a an takhu, ja khun chaꞌmi alan ta pungkumerchuwon chaꞌmi ta gway atom an omachangjan.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ja inalin chin apo na hi, ‘Napukhit a an takhala! Anong un amat hina chi allom ja ipatikhaw na chamchama an napukhit hitay enat mu. Ti nu anilam an mapfungotaꞌ an takhu ja khun u pungkumerchuwon chaꞌju ta gway atoꞌ an omachangjan, ");
INSERT INTO ifu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ja anagkha ta agkhuy mu mah niꞌ i imbangko hinuy pelaꞌ u ta gway ma-alaꞌ hi intu-u na ad ugwani an numpfangngachaꞌ?’ ");
INSERT INTO ifu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ja inalin chin ap-apo hachi numpangataꞌchug hi, ‘Alaon ju hichuy pelaꞌ an gwa ay hija ta ichat ju ay chuy takhala an choꞌchoꞌ-olan chi intu-u na.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ja inali cha ay tay ap-apo hi, ‘Apo, anagkha ta i ta-o agkhu ichat ay hija, ti un ta-o chah i ug-ugman an un numpapolo hini intu-u na?’ ");
INSERT INTO ifu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ja inali na hi, ‘Alloꞌ ay chaꞌju hi hini mangpa-ennongan ay ni nichat ay hija ja ma-ug-ugman. Muti hini ayya achi mangpa-ennongan ay ni nichat ay hija hot anong un hay it-ittang hi gwa ay hija ja pfangngachon Apo Jos.’ ");
INSERT INTO ifu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja inali na khu hi, ‘An amin hachi pfuhur u an achi mamhod an ha-in chi mun-ari ay chicha ja in-ali ju ay ha-in ta patajon ta-o.’” ");
INSERT INTO ifu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Emmopoh hay hato an inalin Hesus ja impangulu na ta umuy cha ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Un chaagkhu nehnot ad Betfage ja Betani an achaan chuy pfulludna an nangadnan hi Olibo ja hennag Hesus han chugwa an disipolo na an inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ipangulu ju ay chuy pfarju hichi chammangna. Nu omatam aju hot chakngan ju han nekhokhoꞌ-od an pfoꞌtot an donkey an agkhuy nahak-hakajan. Upfachon ju ja in-ali ju heto. ");
INSERT INTO ifu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja nu gway mangpfokha hi, ‘Anagkha ta alaon ju hitay donkey?’ ja allon ju hi, ‘Alaon mi, ti nan mahapor Apo ta-o.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Immuy cha ja immannung an amin chin inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Gwa an khun cha upfachon chin donkey ja inalin chin khun mumpfantay hi, “Anagkha ta alaon ju hitay donkey?” ");
INSERT INTO ifu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ja inali cha hi, “Alaon mi ti nan mahapor Apo ta-o.” ");
INSERT INTO ifu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amat hichi ja enala cha chin donkey ja in-uy cha ay Hesus. Enopnan cha chin khatud na hi lopfong ja enhakay cha hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gwa an khun umuy ja nunloh-op cha chin uchumna an lopfong cha hon en-ap-ap cha chin chalan. ");
INSERT INTO ifu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Gwa an lemmammag cha ay chuy pfulludna an ma-ali hi Olibo ja an amin chin mimitnud ay Hesus ja ente-a cha an mangiꞌgwap an mangdaydayaw ay Apo Jos. Ja nun-an-anla cha khapo hachi tinnig cha an milagro an enat Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ja iniꞌgwap cha an mangali hi, “Madaydayaw a an Ari an hennag Apo Jos! I-ali nay i ta-o peꞌ-oh-ohhaan ay Apo Jos. Hotti mipapfagpfagto hi Apo Jos ad langit!” ");
INSERT INTO ifu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ja inalin hachi uchumna an Farisee an neꞌkhakhawwong hi, “Apo, ihingar mu hay hachi disipolom an khun mundaydayaw ay he-a!” ");
INSERT INTO ifu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tempfar Hesus ja inali na hi, “Nu khomenong cha hot mepallog hay hana pfato an mundayaw.” ");
INSERT INTO ifu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Gwa an enamang Hesus ad Jerusalem ja kinilaana hana tatakhu hichi, ");
INSERT INTO ifu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ja inali na hi, “Inannila ju koma ad ugwani hini mangchat hi pomhochan ju. Muti tayya an achi ju ma-imatunan. ");
INSERT INTO ifu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Umalin to han arkhaw an hay hana pfuhur ju ja umali cha an meꞌpapattoy ay chaꞌju. Liꞌmuton cha hini pfuglay ju ja mun-ephod cha hi alad an munleneꞌgwoh ay ni pfuglay ju hot ma-id aton ju an lomajaw. ");
INSERT INTO ifu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apfakon chaꞌju ja penatoy chaꞌju an munheto ja pun-idchum cha hana empfapfalay ju. Anong un hana pfinatto an pfalay ju ja mun-apaꞌ-i cha. Ti agkhuy ju tugwali immatunan hini immali an Manakhu ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ne-atam cha Hesus hichi ad Jerusalem ja himmikhop ay chuy partug chi Templo. Ja nun-epakak na hay hachi khun mungkumerchu. ");
INSERT INTO ifu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ja inali na ay chicha hi, “Allona ay ni hapit Apo Jos hi, ‘Hitay pfalay u ja pfalay an pungkalalakhan.’ ” Muti tayya an numpfalinon ju hi a-amungan chi mangakaw. ");
INSERT INTO ifu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nete-a ay chuy ja a-arkha-arkhaw ja khun muntudtuchu hi Hesus hichi Templo. Muti hay hachi a-ap-apon chi pachi ja memehtolon chi urchin Moses ja a-ap-apon chi tatakhu, ja podhon cha an patajon hija. ");
INSERT INTO ifu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Muti ma-id aton cha an mamatoy ti khun gwacha gwachay tatakhu an mamhod an munchongor ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gwa han ohan arkhaw an khun muntudtuchu hi Hesus hichi Templo an khuna ekasaba hini Ebanghelyo. Ja immuy ay Hesus hay hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin Moses ja hachi uchumna an a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ja empfokha cha ay hija hi, “Ngachah chi narpugwan ni apfalinam an mangat hay hato khun mu aton? Ja ngay nangchat ay tay apfalinam?” ");
INSERT INTO ifu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tempfar Hesus ja inali na hi, “Unchani adchiya ta topfalon ju pay hitay peꞌpfokhaꞌ. Hotti allon ju adchiya tugwali, ");
INSERT INTO ifu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ngay nannag ay John Bautista an immali an khun mumbautisar? Hi Apo Jos wenno hay takhu?” ");
INSERT INTO ifu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ja khun cha manghempfopfogkha an khun cha allon chi, “Hot ngachah chi allon ta-o mah? Nu allon ta-o hi un hennag Apo Jos hot allona hi, ‘Nu hi Apo Jos chi nannag ay John ja anagkha mah ta agkhuy ju pinati hija?’ ");
INSERT INTO ifu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ja nu allon ta-o khu hi hennag chi hay takhu hot pungkhajang chita-o hay hato tatakhu, ti namati cha an profetan Apo Jos hi John.” ");
INSERT INTO ifu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hotti hay nampfar cha ay Hesus ja inali cha hi, “Ma-id anila mi nu ngachah chi nannag ay hija.” ");
INSERT INTO ifu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tempfar khu Hesus ja inali na hi, “Nu amat hina hot achiꞌ khu epfaag nu ngay nangchat hi apfalinaꞌ an mangat hay hato.” ");
INSERT INTO ifu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amat hichi ja inalin khu Hesus hachi tatakhu hitay an pangngarig. “Gwa han ohan lala-e an nuntanum hi cho-or hi ubas ay ni kharchina ja unaot epapfengpfeng. Ja nakak an immuy hi achawwi hi pfuglay ja i napfajag hichi. ");
INSERT INTO ifu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Unot nachakngan chin ahipokhah ja hennag na han ohan takhala na ta i meꞌ-aggwa ay chuy penokhah cha an ubas. Muti hay hato an neꞌpfengpfeng ja numpakhuh cha hitay an takhala ja empapfangngad cha an ma-id oh-ohha hi inchat cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hennag na khu han oha an takhala na ja numpakhuh cha khu ja pinalikhat cha ja empapfangngad cha an ma-id oh-ohha hi inchat cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hennag na khu chin me-atlo an takhala na ja pinalikhat cha ja empapfangngad cha an nun-ahukhatan. ");
INSERT INTO ifu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ja inalin tay nangpapfengpfeng hi, ‘Ngachah niꞌ chi atoꞌ? Ijam ta honakhoꞌ hitay podpodhoꞌ an empfalay u ta alom ja egngor hachi neꞌpfengpfeng hija.’ ");
INSERT INTO ifu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Muti unot nangalimutugwan hachi neꞌpfengpfeng hichuy empfalay na ja nunhahapit cha ja inali cha hi, ‘Hijah tay hini empfalay ni khun ta-o piꞌpfengpfengan an hijay mamanoh ay tay lotan ama na. Unot la-ahna ja penatoy ta-o ta chita-oy mangheꞌ-a ay tay lota.’ ");
INSERT INTO ifu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Amat hichi ja enekak cha ja penatoy cha.” Ja inalin Hesus hachi tatakhu hi, “Ngachah tugwali chi aton tay an takhu hay hachi neꞌpfengpfeng ay hija? ");
INSERT INTO ifu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umuy hija ja epapatoy na chicha ja epapfengpfeng na hi uchumna.” Unot chengngor hachi tatakhu chin inalin Hesus ja inali cha hi, “Achi adniꞌ ma-at hay hato.” ");
INSERT INTO ifu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Emmohchong Hesus hachi tatakhu ja inali na hi, “Hotti ngay podhona an hapiton ay tay an nitulaꞌ an hapit Apo Jos hi nangarjana hi, ‘Hinuy pfato an namlenan hay hana mumpakhad hi pfalay Ja hijay numpfalin hi na-ahammad an pognad tay an pfalay.’ ");
INSERT INTO ifu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","An amin hini makhah ta meꞌna ay tay an pfato ja mun-igwa-itay. Ja nu meꞌna hitay an pfato ay ni takhu hot mun-akhupung.” ");
INSERT INTO ifu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Emmopoh hay hato an inalin Hesus ja podhon hachi memehtolon chi urchin Moses ja hachi a-ap-apon chi papachi an tiligwon hija. Ti anila cha an mipfuhur hichuy an pangngarig ay chicha an nan-ug ay Hesus. Muti agkhuy cha entoloy, ti temma-ot cha hay hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Muti nanganap cha chamchama hi aton cha an maniliw ay hija. Ja hennag chaot hachi umuy an i mamarpfali an i muntoon hi pehallaan Hesus hi hapitona ta gway panghiꞌ-ingan cha an i mangchalom ay hija ay ni gobernador. ");
INSERT INTO ifu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja inali cha ay Hesus hi, “Apo, anila mi an umannung hana khun mu allon ja hana khun mu itudtuchu. Ja anila mi khu an achim lomanon hini ituchum ta ipan-uy mu ay ni penhod hay hana munchongor muti ituchum chamchama hini umannung an podhon Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ja khun cha hempfogpfogkhon an allon cha hi, “Hotti hay podhon mi adchiya an annilaon ja mapfalin chah ay ni urchin ta-o an Hudju nu mumpfajad ta-o hi pakha ay ni Emperador ad Rome? Pfajachan mi chah wenno achi mi?” ");
INSERT INTO ifu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na-orman Hesus an un cha toptopngan hija ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“I-ali ju hay pihu an michat hi pakha ta tikhaꞌ.” Inchugwagwa cha han pihu ja inali na ay chicha hi, “Ngay nang-angah ay tay gwa ay tay pihu? Ja ngay nang-enngachan ay tay an nitulaꞌ?” Tempfar cha ja inali cha hi, “Hini Emperador.” ");
INSERT INTO ifu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ja inalin khu Hesus hi, “Hotti ichat ju ay ni Emperador hini michat ay ni Emperador, ja inchat ju ay Apo Jos hini michat ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nanannor cha chin enat na an hemmongpfat, ti ma-id chi hay nappap cha hi hinapit na hi sangwanan hana tatakhu an chumalat hi pangchaloman cha ay hija, hotti un cha khemmegkhenong. ");
INSERT INTO ifu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gwa hay hana uchumna an Saducee an immuy ay Hesus. Saducee ayya ja achi cha mamati an gway amahuwan. ");
INSERT INTO ifu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ja inali cha ay hija hi, “Apo, intulaꞌ Moses chin urchin ay chita-o an, matoy ayya hini oha an lala-e an narhin ja ma-id empfalay na, ja mahapor an ahagwaon ni akhi na an lala-e hitay an pfupfai an napfalo, ta hana empfapfalay cha ja mipfilang an empfalay nuy natoy an ibpfa na. ");
INSERT INTO ifu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hotti gwacha han peto an hin-a-agkhi an linala-e. Narhin chin panguluwan ja natoy an ma-id empfalay cha. ");
INSERT INTO ifu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hijaot un nepallog chin netob ta enahagwa na khu hitay an pfalo ja natoy khu an ma-id empfalay cha. ");
INSERT INTO ifu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hotti nepallog khu chin me-atlo ja ingkhana chin me-apeto ja nun-atoy cha an amin an ma-id empfalay cha. ");
INSERT INTO ifu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Omaꞌ-angonoh ja ne-etoy hitay an pfupfai an napfalo. ");
INSERT INTO ifu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hotti nu allom chi gway amahuwan chi natoy ja ngacha mah ay cha tay an peto an linala-e chi nang-en-ahagwa ay tay pfupfai nu umali hini amahuwan chi tatakhu? Ti enahagwa cha mit an amin hitay an pfupfai.” ");
INSERT INTO ifu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tempfar Hesus ja inali na hi, “Hana tatakhu ay tay lota ja mangahagwa cha. ");
INSERT INTO ifu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ja hay hana napili an mamahuwan an miꞌtakhu hi ma-id chi pogpogna ja achi cha mangah-ahagwa, ");
INSERT INTO ifu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","an amat cha hay hana angher an achi cha matmatoy. Ti empfapfalay Apo Jos chicha an minahuwana. ");
INSERT INTO ifu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ja hini ayya amahuwan chi nun-a-atoy, ja anong un hi Moses ja piꞌ-ali na an mummahu hana natoy. Ti chin intulaꞌ na an omaꞌ-atan chin ajiw an khun chumalang ja allona an hi Apo Jos ja hijay Jos an khun dayawon Abraham, ja hi Isaak ja hi Jakob, anong un napfajag an nanattoy cha Abraham. ");
INSERT INTO ifu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","An hay podhona an hapiton ja hijay Jos hana mamattakhu an pfu-un Jos chi natoy, ti ay ni hangon Apo Jos ja mamattakhu an amin chi lennagwan chi takhu. Hotti niya an khun aju mehalla nu ehaot ju hini amahuwan chi natoy.” ");
INSERT INTO ifu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ja inalin hachi uchumna an memehtolon chi urchin Moses hi, “Maphod hitay intuchum, Apo!” ");
INSERT INTO ifu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ja empokhong cha an munhanhan, ti mun-okhon cha an mangpfokha hi uchumna. ");
INSERT INTO ifu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ja inalin Hesus ay chicha hi, “Hay nitudtuchu ja hini Hennag Apo Jos an Mamahhod ja marpu hi holag Ari David. Hotti anagkha tugwali ta allon khu David hi ‘Apo’ ay hija? ");
INSERT INTO ifu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Umannung an hijay Apon David, ti gwa han intulaꞌ David ay ni Libjun chi Psalms an allona hi, ‘Inalin Apo Jos ay nuy tenangad u an Apoꞌ hi, “Umpfun a ay tay nun-appit hi agwan u, ");
INSERT INTO ifu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ingkhana hi pangapfakaꞌ an amin hana pfuhur mu ta he-ay tangachon cha.” ’ ");
INSERT INTO ifu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Inalin Ari David hi, ‘Apo’ ti napfagpfagto hitay Hennag Apo Jos an Mamahhod mu hija. Nu amat heto chi allon David, ja hini hahadchon ju ja pfu-un la-eng holag David ja angkhay.” ");
INSERT INTO ifu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gwa an munchochongngor hachi tatakhu ja inalin Hesus hay hachi disipolo na hi, ");
INSERT INTO ifu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tikhagwun juwot niꞌ ta achi aju munchunu hay hana memehtolon chi urchin Moses. Ti hay hana ayya ja un cha mumpa-akhaja an munlopfong hi makhajad ja podhon cha an gway khun mangpaꞌpa-innila ay chicha hi achoꞌlan chi tatakhu. Ja am-amja-on cha khu an i umpfun hana umpfunan chi a-ap-apo hichi sinagoga ja nun gwachaan chi pfehta. ");
INSERT INTO ifu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ja pomloh cha hi khina-un chi pfalo ja khurkhulaton cha an manganchu-oy an mungkalalag ta allon kan kaykhu hana tatakhu hi nasantuwan cha. Hotti munnaud chi i cha adusaan khapo hay hato khun cha aton.” ");
INSERT INTO ifu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Unagkhu emmohgwat Hesus ja tinnig na hay hachi a-achangjan an khun cha pun-itto hay hachi pihu cha chin pun-amungan hi pihu hichi Templo. ");
INSERT INTO ifu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tinnig na khu han oha an napubli an pfalo an niꞌjuy na han chugwa an hepeng. ");
INSERT INTO ifu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Inalin Hesus hi, “Umannung hitay alloꞌ ay chaꞌju. Napfarpfalor hichuy it-ittang an inchat chuy napubli an pfalo mu an amin hana inchat hachi uchumna. ");
INSERT INTO ifu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ti hay hachi achangjan ja khun cha mangchat muti un hini upag chi enachangjan cha chi khun cha ichat. Hichuy ayya an pfalo an napubli ja khapo hi pamhod na an mangchat ja inunghiw na an inchat hichuy pelaꞌ na.” ");
INSERT INTO ifu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Khun haphapiton hay hachi uchumna an adalan chin aphod chin Templo, ti cho-or chin maꞌmaꞌ-inah an pfato an apja na ja chin chaꞌlig na an na-arkuhan hi khina-u an indaton cha ay Apo Jos. Ja inalin Hesus hi, ");
INSERT INTO ifu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tayya an matikhaw ju hay hato, muti umali han arkhaw hot mun-ahagwer ja mun-egwa-at cha hay hachi pfato an apja na.” ");
INSERT INTO ifu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ja inali cha hi, “Apo, aꞌ-anunay pa-atan hay hato inalim? Ipa-innilam adchiya hay pangmatunan hi pete-aan hay hato an ma-at.” ");
INSERT INTO ifu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tempfar Hesus ja inali na hi, “Tikhagwun ju gwot niꞌ ta achi aju ma-allilaw. Ti cho-or hana umali an mangali hi, ‘Ha-in hini Hennag Apo Jos an Mamahhod.’ Ja allon cha khu hi, ‘Nehnot hini Panugijan Apo Jos hi tatakhu.’ Muti tikhan ju ta achi aju ma-allilaw ja achi ju unuchon. ");
INSERT INTO ifu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nu chonglon ju an gway mungkhukhupfat ja achi aju toma-ot. Ti mahapor an mahhun an ma-at hay hato muti pfu-un pay hitay chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ja inali na ay chicha hi, “Mungkhukhupfat chi apfuglapfuglay ja anong un hay hana nasyon. ");
INSERT INTO ifu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ja gwachay mapfi-ah hi khihu ja gway ulat ja cho-or chi mun-a-atoy hi chokhoh hi apfuglapfuglay. Ja cho-or pay chi atattata-ot an ma-at ad uchu an pangmatunan. ");
INSERT INTO ifu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Muti achi pay ma-at hay hato, an hay mahhun ja tiligwon chaꞌju ja palikhaton chaꞌju. Echalom chaꞌju hichi sinagoga ja impfalud chaꞌju. Ja echalom chaꞌju hay hana ar-ari ja gobernador khapo hi niꞌ-unuchan ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja ay tay panumarjaan cha ay chaꞌju ja hijay timpo ju an mangali ay chicha ay ni hapit u. ");
INSERT INTO ifu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Itanum ju ay ni nomnom ju an ma-id chi i ju pundanakhan nu ngachah chi allon ju. ");
INSERT INTO ifu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ti ha-in chi mangtuchu ay chaꞌju hay allon ju hot ma-id olog ni mamuhur ay chaꞌju an mampfar. ");
INSERT INTO ifu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anong un hana a-ammod, a-akhi, ja khakhayyum ju ja ichat chaꞌju hay hana mamuhur ay chaꞌju. Ja patajon chay uchumnan chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pfuhulon chaꞌju an amin hi tatakhu khapo hi nangunuchan ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Muti anong un amat heto ja achi matoy hini lennagwa ju, ti halimunan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nu edpor ju hay hato an likhat hot miꞌtakhu aju hi ma-id chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Inalin khu Hesus hi, “Nu matikhaw ju an liꞌmuton chi hinchalo heto ad Jerusalem hot annilaon ju an nehnot hini apaꞌ-iyana. ");
INSERT INTO ifu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hot lomajaw hana gwa ad Judea ta umuy cha hichi pfuludna. Ja hay hana gwah to ad Jerusalem ja makak cha. Ja hana nakak ad Jerusalem ja achi cha khu mumpfangngad. ");
INSERT INTO ifu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti hay hato chi arkhaw hi pangdusaan Apo Jos ad Jerusalem ta mipa-annung hini nitulaꞌ an hapit na. ");
INSERT INTO ifu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Munnaud an malikhatan aju ay nuy an timpo, om-omod hay hana numpunhapfin ja hana khun mumpahuhu! Ja nunhegla hana atattata-ot an ma-at ay tay an pfuglay ja umali hini pfungot Apo Jos ay cha tay an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ja patajon hana hinchalo hana uchumna an tatakhu, ja enala cha hana uchumna hi pfalud ja in-uy cha hana apfuglapfuglay ay tay lota. Ja hana Hentil chi mehannot heto ad Jerusalem ingkhana hi mapogpog hana arkhaw an eneꞌchan Apo Jos ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Inalin khu Hesus hi, “Gwa hana pangmatunan an ma-at ay chuy hukhit ja pfulan ja hachi pfittuwan nu mehnot hini apogpokhan tay lota. Ja mungkhongaah ja muntipjaꞌ-ong an amin hana chanum heto lota ta an amin chi tatakhu ja ma-id maptoꞌ hi aton cha. ");
INSERT INTO ifu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hegwogwoggwog cha hi ta-ot cha hay hato an ma-at heto lota, ti makiharpfu ad uchu. ");
INSERT INTO ifu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ay nuy an timpo ja tikhanaꞌ an Na-ilangitan an Takhu an marpu ad langit an midchum ay ni pfonot. Munnaud chi pfinang u ja magwachaanaꞌ hi apfalinan. ");
INSERT INTO ifu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu tikhan ju an mete-a hay hato inaliꞌ ay chaꞌju an ma-at, ja ehehemmad ju, ti ay nuy hini khopong chi umaliyaꞌ, ja hijay panginnilaan ju an khun homnot hini ipfu-aanan ju.” ");
INSERT INTO ifu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Emmopoh hay hato an inalin Hesus ja inali na khu hitay an pangngarig. “Nomnomon ju hini ajiw an higos ja hana uchumna an ajiw. ");
INSERT INTO ifu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ti hay hato ajiw, nu tikhan ju an tumupfu hot ma-innila an nehnot hini tijarkhaw. ");
INSERT INTO ifu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Amat hina khu, nu tikhan ju an khun ma-at hay hato inaliꞌ, hot ma-annila ju an nehnot hini pun-ap-apugwan Apo Jos hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Umannung hitay alloꞌ an achi pay matoy an amin chi tatakhu ay tay an himpangapo hot ma-at an amin hay hato inaliꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hitay lota ja ad uchu ja ma-upfah cha, muti achi ma-ub-upfah hitay hapit u.” ");
INSERT INTO ifu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Inalin khu Hesus hi, “Epa-ennongan ju ta pfu-un hana na-inlubungan an pun-an-anlaan ja apfukngan ja hana pundanakhan heto lota chi mun-o-onan ay ni piꞌtakhuwan ju. Ti nu hay hato chi mun-onan ay ni nomnom ju hot himpfumagkha ja machakngan hini arkhaw an Punhugijan Apo Jos hot ma-ah-upan aju. ");
INSERT INTO ifu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ti ma-id oh-ohha hi takhu ay tay lota hi achi mahumarja. ");
INSERT INTO ifu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Peꞌhehemad ju ja achi ju epogpokhong an mungkalalag ta mapfalinan ju an anuhan hay hato maꞌma-at, hot achi aju pfuma-in an humango ay ha-in an Na-ilangitan an Takhu ay ni pumpfangngachaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A-arkha-arkhaw ja khun muntudtuchu hi Hesus hichi Templo, ja nadhom ayya hon inhinud na hichi pfulludna an ad Olibo. ");
INSERT INTO ifu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gwa ayya an nannanong hon immuy hachi tatakhu hichi Templo ta i cha munchongor chin itudtuchu na. ");
INSERT INTO ifu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gwa an machakngan chin arkhaw an Panganan cha ay ni Tenapay an Ma-id Pfinoꞌpfoꞌ Na an hitay chi arkhaw an punnomnoman chi Hudju chin Nalohan chin Angher Apo Jos chin Pfarpfalay chin A-apo cha ad Egypt. ");
INSERT INTO ifu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin ja hehemmon cha hay aton cha an mamatoy ay Hesus an ma-id manginnila, ti temma-ot cha chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Amat hichi ja nehoꞌlong hi Satanas ay Judas Iskariot an oha ay cha chuy himpolo ta chugwa an adalan Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ja immuy hi Judas an i niꞌhapit hay hachi a-ap-apon chi papachi ja hachi a-ap-apon chi gwarja hichi Templo ta e-agwat na hi Hesus ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nun-an-anla cha ja inali cha hi ichat cha hay pihu an lagpfu na. ");
INSERT INTO ifu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ja inapfulut Judas hotti henehemmona hay timpo an ma-id cho-or hi tatakhu ta gway atona an mangtuchu ay Hesus ta tiligwon cha. ");
INSERT INTO ifu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nachakngan chin penghan chi arkhaw chi Pfehta an Panganan cha hi Tenapay An Ma-id Pfinoꞌpfoꞌ Na, ja hichuy hini khun cha pumpartiyan hi pfoꞌtot an karnero an Pangnomnoman cha Chin Nalohan Chin Angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hotti hennag Hesus cha Peter ay John an inali na ay chicha hi, “Umuy aju ta i ju ehakhana hay anun ta-o an pangnomnoman ta-o hi Nalohan chin Angher Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ja empfokha cha hi, “Chaamah chi i mi punhakhanaan?” ");
INSERT INTO ifu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tempfar na ja inali na hi, “Chonglon ju. Nu me-atam aju ad Jerusalem hot chittumon chaꞌju han lala-e an nangpipi-ug han pun-otanan. Unuchon ju hija ay ni pfalay an i na humigpan, ");
INSERT INTO ifu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ja allon ju ay ni nunheto hi, ‘Inalin ni Apo ta-o hi chaad mah anu hini kwarto an peꞌ-anan mi an adalana ad ugwani an pfehta.’ ");
INSERT INTO ifu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hot hini nunheto ay nuy an pfalay ja ituchu na hini nangennaꞌjab an otongngan an kwarto an gwah chi an amin chi mahapor. Ja hichi chi punhakhanaan ju ay ni anganan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Un chaot emmatam ja immannung an amin chin inalin Hesus. Ja enhakhana cha chin anun cha ay chuy an pfehta an i cha Pangnomnoman chin Nalohan chin Angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Unagkhu nadhom ja neꞌ-orpfong hi Hesus ay cha chuy apostol na ay chuy an pfalay. ");
INSERT INTO ifu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ja inalin Hesus ay chicha hi, “Otong chi pamhod u an meꞌ-orpfong ay chaꞌju ay tay i ta-o pangnomnoman chin Nalohan Chin Angher Apo Jos ja una-ot matoy. ");
INSERT INTO ifu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hitay chi ang-angonoh hi peꞌ-anaꞌ ay tay an ngilin ingkhana hi mipa-annung hini penhod na an hapiton ay ni Pun-ap-apugwan Apo Jos ad langit.” ");
INSERT INTO ifu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ja enala na chin pfahu an nittugwan hi chanum chi ubas ja nunyaman ay Apo Jos ja inali na ay chicha hi, “Hiniꞌ-itangon ju an inumon, ");
INSERT INTO ifu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ti hitay chi ang-angonoh hi piꞌ-inumaꞌ hi chanum chi ubas ingkhanah machakngan chin Pun-ap-apugwan Apo Jos hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Enala na khu han tenapay ja nunyaman ay Apo Jos ja initta-ittang na. Ja enggwanah na ay chicha ja inali na hi, “Hitay hini achor u an midaton khapo ay chaꞌju. Hitay chi khun ju aton ta pangnomnoman ju ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Napfalin chin nanganan cha ja enala na chin pfahu ja inali na hi, “Hitay chanum chi ubas ja hija hini mun-ajuh an chalaꞌ an pangpa-annungan ay ni pfakhu an neꞌtobpfalan Apo Jos ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ja alloꞌ ay chaꞌju hi hini mangngina ay ha-in ja gawwacha ay chaꞌju an neꞌ-o-orpfong. ");
INSERT INTO ifu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ti ha-in an Na-ilangitan an Takhu ja matojaꞌ an matoy, ti hijah tay chi empagpong Apo Jos an ma-at. Muti ka-ahi hini mangngina ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ja ente-a cha an munhahapit an allon cha hi, “Ngay ngachah ay chita-o chi i mangat heto?” ");
INSERT INTO ifu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ente-an hachi adalan an punhohongngilan nu ngay napfagpfagto ay chicha an amin. ");
INSERT INTO ifu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ja inalin Hesus ay chicha hi, “Hana ari heto lota an khun mangpaptoꞌ hi tatakhu ja khun cha ipapilit hini podhon cha. Ja hana mun-ap-apo an gway apfalinana ja podpodhon cha an epa-akhaja hana khun cha at-aton. ");
INSERT INTO ifu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Muti achi koma amat hetoy aton ju. Hini mamhod an ma-ar-ali ja amat koma hi hijay ung-ungngaan. Ja hini mamhod an mumpfalin hi pangulu ja mahapor an tulunganay padchung na an takhu. ");
INSERT INTO ifu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ay ni ugalin chi takhu ja ipapfun cha hini napfagto an apo ta hachona hini ijalin ni takhala an anuna. Muti ha-in an Apo ju ja impadchung u hitay achor u hi pfaar. ");
INSERT INTO ifu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Chaꞌju ja gawwacha aju ay ha-in an amin hi ujaꞌ nunliglikhatan. ");
INSERT INTO ifu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chin enat Ama an nangpadchong hi ujaꞌ pun-ap-apugwan ja hitay khu chi atoꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nu umali chin pun-ap-apugwaꞌ ja meꞌ-an aju ja miꞌ-inum aju ay ni enhakhanaꞌ an anganan ta-o. Ja umpfun aju hi umpfunan chi ari ta chaꞌjuy mun-ap-apo hana tatakhu an narpu ay ni himpolo ta chugwa an holag Israel.” ");
INSERT INTO ifu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ja inalin khu Hesus ay Simon Peter hi, “Simon, chonglom akay niꞌ hitay alloꞌ. Inippug Satanas ay Ama ta umali ta pachaona an paꞌ-iyon hini pammati ju an adalan u. ");
INSERT INTO ifu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Muti engkalalakhaꞌ he-a, Simon, ta achi mapaꞌ-i hini pammatim. Inhalimuwat mu ayya ja papfi-ahom hana papadchung mu an adalan.” ");
INSERT INTO ifu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tempfar Simon ja inali na hi, “Apo, ehehemad u an mitnud ay he-a anong un ta mipfalud wenno matoy.” ");
INSERT INTO ifu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ja inalin Hesus hi, “Peter, tayya han alloꞌ. Ehaotaꞌ ay he-a hi mumpitlo ad ugwani an lapfi ja unot tumalanu.” ");
INSERT INTO ifu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ja inalin khu Hesus hi, “Chin nannakhaꞌ ay chaꞌju ja ma-id inugnan ju hi pihu ja hape-eng ja hapato. Ja ngay ngachah chi agkhuy nichat ay chaꞌju?” Ja inali cha hi, “Ma-id.” ");
INSERT INTO ifu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ja unaot khu allon ay chicha hi, “Hot ad ugwani ja hay alloꞌ ay chaꞌju ja hini gway pihu na, ja hape-eng na ja inugnana. Ja hini ma-id pfangid na ja ingngina na hay lopfong na ta gway pungngina na. ");
INSERT INTO ifu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gwa han nitulaꞌ an hapit Apo Jos hi nangarjana hi, ‘Impfilang cha hini Hennag Apo Jos an oha an napfahulan.’ Ja umannung hitay an ma-at ay ha-in ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ja inalin hachi adalan hi, “Tayya han chugwa an pfangid.” Ja inalin Hesus hi, “Hot ammuna.” ");
INSERT INTO ifu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nakak hi Hesus ad Jerusalem ta umuy hichi pfulludna an Olibo an empa-engha na an khun omajan. Ja nitnud hay hachi adalana ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Un chaot ne-atam ja inali na ay chicha hi, “Mungkalalag aju ta achi aju ma-apfak nu matopngan hini pammati ju.” ");
INSERT INTO ifu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nakhibpfoh chin inali na ja pfinumtaw ja i nunheppe an nungkalalag. ");
INSERT INTO ifu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ja inali na hi, “Ama, podhom ayya adniꞌ ja ergwangaꞌ ay nuy umali an apalikhataꞌ. Muti pfu-un hini podhoꞌ chi ma-at ta hini podhom.” ");
INSERT INTO ifu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Amat hichi ja numpatikhaw han ohan angher an narpu ad langit ja impapfi-ah na chin nomnom Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Khapo chin machamot an punnomnomana ja impapati na an mungkalalag ja nachalaan chin lengot na an khun muntidtid. ");
INSERT INTO ifu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nakhibpfoh chin nungkalalakhana ja timmaꞌchug ja i na tinnig hachi adalana. Ja chinakngana chicha an nanalloꞌ, ti nunheglay immayyungan cha chin khun allon Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ja inali na ay chicha hi, “Anagkha ta mamalloꞌ aju agkhu? Pfumangon aju ta mungkalalag aju ta achi aju ma-apfak nu matopngan hini pammati ju.” ");
INSERT INTO ifu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Khun pay munhapit hi Hesus ja emmatam hachi cho-or an tatakhu an impapangulun Judas an oha ay chicha an adalan Hesus. Ja nehnot ay Hesus ta enagwar na. ");
INSERT INTO ifu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Muti inalin Hesus ay hija hi, “Judas, un chah pamhod mu hitay pangagwalam ay ha-in an Na-ilangitan an Takhu? Anilaꞌ an hini nangatam ay tay ja ta ituchuwaꞌ ay he-a hay hato tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Unot na-orman hachi adalan Hesus chin ma-at ja inali cha hi, “Apo, pumpakhit mi chah hay hato?” ");
INSERT INTO ifu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amat hichi ja impakhit tatagwa chin oha chin pfangid na ay chuy takhalan chin natakhay an pachi, ja na-aan chin agwan an inga na. ");
INSERT INTO ifu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Muti inalin Hesus hi, “Ammuna.” Ja hen-a na chin hukhat ja nepfangngad chin ingan chin takhala. ");
INSERT INTO ifu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Amat hichi ja inalin Hesus hachi a-ap-apon chi papachi ja hachi a-ap-apon chi gwarja hichi Templo ja hachi uchumna an a-ap-apo an immuy an mampap ay hija hi, “Unaꞌ chah ngumangannu ta numpfapfangid ja numpun-ochon aju hi pang-or an immali an mampap ay ha-in? ");
INSERT INTO ifu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A-arkha-arkhaw ja gawwacha ta-o an amin hichi Templo ja agkhujaꞌ tiniliw. Muti na-at chamchama hitay, ti hitay chi neꞌcha an timpon chi pangatan ju hi podhon ju ja hini podhon ni ap-apon chi napukhit an hi Satanas.” ");
INSERT INTO ifu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nun-ugnan cha hi Hesus ja in-uy cha ay ni pfalay chin natakhay an pachi. Ja khun mangun-unud hi Peter. ");
INSERT INTO ifu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ja gwacha han pun-anichuwan ay chuy partug chuy pfalay, ja ni-ipfun hi Peter an miꞌ-anichu. ");
INSERT INTO ifu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Gawwah chi han takhala an pfupfai ja tinnig na hi Peter, ti nahilagwan chin apoy an khun cha pun-anichuwan, ja tenotoꞌ-or na hija ja inali na hi, “Oha jaꞌ hitay an khun mitnud ay chuy lala-e an tiniliw cha.” ");
INSERT INTO ifu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Enhaot Peter an inali na hi, “Agkhuy u anila hichuy an takhu.” ");
INSERT INTO ifu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gwa an naꞌnaꞌ-omtang ja immatunan khu han oha an takhu ja inali na ay Peter hi, “Oha a jaꞌ an khun mitnud ay chuy an lala-e.” Tempfar Peter ja inali na hi, “Achiyaꞌ mangkay khun mitnud ay hija!” ");
INSERT INTO ifu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Immuy chi ohah upfun ja gwa khu han ohan lala-e an impapilit na an nangali hi, “Ninitnud ay chita hitay ay chuy lala-e an tiniliw cha, ti un chah pfu-un eGalilee?” ");
INSERT INTO ifu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tempfar Peter ja inali na hi, “Ma-id mangkay anilaꞌ ay chuy khun mu hapiton!” Agkhuy na pay empa-opoh hitay me-atlo an nanghaotana ay Hesus ja timmalanu gwot chin agwitan. ");
INSERT INTO ifu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nunligkhoh hi Hesus ja emmomohchong na hi Peter. Ja nenomnom Peter chin nangarjan Hesus ay hija an “Ehaotaꞌ hi mumpitlo ad ugwani an lapfi ja unot tumalanu.” ");
INSERT INTO ifu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pfimmutay hi Peter ja achi anhan chin kila na khapo hi tutuju na. ");
INSERT INTO ifu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hachi khun munggwarja ay Hesus ja ente-a cha an manuntuk ja an mangekejan ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ja inukupan cha chin mata na ja inali cha ay hija hi, “Nu profeta a, pfugwaom adchiya nu ngachah nuy nanuntuk ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ja cho-or pay chi umipapfa-in an inali cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Unagkhu nagwa-ah ja na-amung hachi a-ap-apon chi papachi ja hachi memehtolon chi urchin ja hachi uchumna an a-ap-apon chi Hudju. Ja empapfokha cha hi Hesus ta munhahapit cha. ");
INSERT INTO ifu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ja inali cha ay hija hi, “Epfaag mu nu he-a hini Hennag Apo Jos an Mamahhod.” Tempfar Hesus ja inali na hi, “Anong chamchama un u allon ja achiyaꞌ pattiyon. ");
INSERT INTO ifu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ja nu ha-in chi mangpfokha ay chaꞌju ja achi aju chamchama tompfar. ");
INSERT INTO ifu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Muti tan alloꞌ ay chaꞌju hi ha-in an Na-ilangitan an Takhu, ja ipapfunaꞌ ay ni nun-appit hi agwan Apo Jos an gway apfalinana, ta mun-ap-apowaꞌ ad ugwani ja ingkhana.” ");
INSERT INTO ifu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ja inali cha an amin chi, “Hot he-a chah tatagwa hini Empfalay Apo Jos?” Tempfar Hesus ja inali na hi, “Ti niya mah an chaꞌju chi nangali.” ");
INSERT INTO ifu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ja nunhahapit cha ja inali cha hi, “Tayya an chengngor ta-o hay hato inali na hotti un chah khahin khu un gway muntihtikhu?” ");
INSERT INTO ifu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Amat hichi ja initnud hachi tatakhu an in-uy hi Hesus ay Pilato an gobernador ad Judea ta mahumarja. ");
INSERT INTO ifu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Enchalom cha hi Hesus ja inali cha hi, “Tinnig mi hitay an takhu an una allilagwon hay hato tatakhu ay tay an pfuglay mi. Ja intukhuna khu an achi mi ichat hana pakha ay ni Emperador ad Rome. Ja allona khu chi un hija hini Kristo an Ari an pinilin Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ja empfokhan Pilato ay Hesus hi, “Un chah he-a hini Arin chi Hudju?” Tempfar Hesus ja inali na hi, “Ti niya mah an inalim.” ");
INSERT INTO ifu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Amat hichi ja inalin Pilato hachi a-ap-apon chi papachi ja hachi tatakhu hi, “Ma-id chi machakngaꞌ hi hay panghiꞌ-ingan hi pangchaloman ay tay an takhu.” ");
INSERT INTO ifu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Muti impapilit cha an khun cha allon hi, “Hitay hini mangchokhochokhor hi atakhutakhu ta achi cha unuchon hini khupferno. Ente-a na hichi ad Galilee ja ingkhana ad Judea ja tan ne-atam heto ad Jerusalem.” ");
INSERT INTO ifu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chengngor Pilato hay hato inali cha ja empfokha na nu eGalilee hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Unagkhu inannilan Pilato an eGalilee hi Hesus ja impa-uy na ay Herod an Ari hichi ad Galilee, ti netongor ja gawwacha ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ja madmachennor hi Herod an nanikhaw ay Hesus, ti napfajag an penhod na an tikhagwun hija. Ti chengngor na an amin hini ena-enat Hesus ja podhona an piꞌtikhaw hay atona hi milagro. ");
INSERT INTO ifu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cho-or chin empfokhapfokha na muti agkhuy tenomtompfar hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ja chin a-ap-apon chi papachi ja memehtolon chi urchin an numpangataꞌchug, ja impapilit cha an gway pfahor Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Amat hichi ja hi Herod ja hachi hinchalo na ja khun cha kekejan hon pinahiw cha hi Hesus. Linupfungan cha hija hi maphod an amat hi lopfong chi ari ja un chaot epapfangngad ay Pilato. ");
INSERT INTO ifu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cha Pilato ay Herod ja munchuꞌ-ukhan cha muti ay chuy an arkhaw ja ente-a cha an mungkhayyum. ");
INSERT INTO ifu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Empapfokhan Pilato hachi a-ap-apon chi papachi, ja hachi uchumna an ap-apo, ja hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ja inali na ay chicha hi, “In-ali ju hitay an takhu ja inali ju an intudtuchu na hay aton chi tatakhu an ngumangannu. Muti tayya an chengngor ju an menahmahaꞌ hitay impapfahor ju ay hija ja ma-id umannung. ");
INSERT INTO ifu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Anong un hi Herod ja ma-id chinakngana hi pfahor tay an takhu. Hijaot una empapfangngad ay chita-o. Hotti tayya an ma-id matikhaw hi ujaꞌ panghiꞌ-ingan an pamatajan ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hotti ipahuplit u hija ja un u ipfu-aan.” ");
INSERT INTO ifu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hay khun aton Gobernador Pilato hi un Pfehtan chin Nalohan chin Angher Apo Jos, ja emmengha ay hija an khun mangpfu-aan hi oha hi nipfalud an piliyon hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ja nunchechehhan hay hachi tatakhu an nangiꞌgwap hi, “Epapatoy mu hi Hesus! Ti hi Barabas chi podhon mi hi ipfu-aam!” ");
INSERT INTO ifu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Hitay an hi Barabas ja nipfalud, ti pemmatoy ja nginangannu nay khupferno. ");
INSERT INTO ifu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Niꞌhapit khu hi Pilato hachi tatakhu khapo hi pamhod na an mangpfu-aan ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Muti hi-u-ugwap cha an nangali hi, “Epepfakhat mu! Epepfakhat mu hi kros!” ");
INSERT INTO ifu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ja empetlon Pilato an niꞌhapit hachi tatakhu ja inali na hi, “Anagkha? Ngay tugwali pfahor na? Ma-id ay chita chinakngaꞌ hi enat na hi panghiꞌ-ingan hi pamatajan ay hija. Hotti tayya an ipahuplit u hija ja un u ipfu-aan.” ");
INSERT INTO ifu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Muti entotoloy cha pay an nangiꞌgwap hi, “Epepfakhat mu hi Hesus hay kros!” Ja na-unud chin khun cha iꞌgwap. ");
INSERT INTO ifu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hotti inapfulut Pilato chin inali cha an epapatoy na hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Impfu-aana chin empfokha cha an hi Barabas an ngimmangannu ja pemmatoy. Ja impulang na hi Hesus ay chicha ta aton cha hini podhon cha an aton ay hija. ");
INSERT INTO ifu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ini-itnud hachi hinchalo hi Hesus, ja enalaw cha han hi Simon an eCyrene an umuy ad Jerusalem. Ininat cha hija ja impapi-ug cha chin kros ja khuna i-un-unud ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cho-or chin tatakhu an khun mangun-unud ay Hesus ja khun kumila hachi uchumna an pfinapfai, ti nignikhaon cha hija. ");
INSERT INTO ifu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nunligkhoh hi Hesus ja inali na ay chicha hi, “Chaꞌju an pfinapfai an eJerusalem, achiyaꞌ kilaan ta hay hana achor ju ja hana empfapfalay juwot niꞌ chi kilaan ju. ");
INSERT INTO ifu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ti umali han arkhaw an punlikhatan ju hot allon ju hi, ‘Akhaꞌkhaja hana pfinapfai an agkhuy emmempfalay ja agkhuy numpahuhu ta ma-id meꞌchagkha hi hay i cha punlikhatan.’ ");
INSERT INTO ifu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ay chuy an timpo chi pangarjan chi tatakhu hi, ‘Megchay aju adniꞌ, ton pfuludna, ta khapfunan chaꞌmi.’ ");
INSERT INTO ifu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nu ay ha-in an ma-id pfahor na ja palikhatonaꞌ hot munnaꞌnaud pay hana gway pfahor na.” ");
INSERT INTO ifu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ini-itnud cha khu han chugwa an pfalud an i cha peꞌpfakhat. ");
INSERT INTO ifu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ja unchaagkhu ne-atam ay chuy pfurpfulludna an amat hi ulun chi paang, ja empfakhat cha hi Hesus chin kros. Neꞌpfakhat cha khu hachi chugwa an pfalud ay chi kros cha, ja nun-appit chin oha hi agwan Hesus, ja nun-appit chin oha hi ikhid. ");
INSERT INTO ifu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ja inalin Hesus hi, “Ama, pakawanom adniꞌ hay hato tatakhu, ti agkhuy cha anila hitay khun cha aton.” Ja numpfeleng hachi hinchalo nu ngay mumpangala hay hachi lopfong Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Khun titigkhan hachi numpangataꞌchug an tatakhu hi Hesus ja ente-an hachi a-ap-apon chi Hudju an mamahiw ay hija ja khun cha allon hi, “Tinakhu na hana uchumna an tatakhu ja chaad mah ta haniyana hichuy achor na nu hija chi Kristo an pinilin Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Anong un hachi hinchalo ja nehnot cha ay Hesus ja niꞌpahiw cha hija. Intumuꞌ cha han pfimmanger an pfajah chin ta-o na ");
INSERT INTO ifu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ja inali cha hi, “Takhuwom hini achor mu nu he-a hini Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ti gwa han nitulaꞌ ay chuy kros Hesus an allona hi, “Hijah tay hini Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chin oha an pfalud an neꞌpfapfakhat ja pinahiw na hi Hesus ja inali na hi, “Un chah pfu-un he-a hi Kristo? Chaad mah ta takhuwom hini achor mu ja chaꞌmi!” ");
INSERT INTO ifu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Muti chin oha an pfalud ja inhingar na hija ja inali na hi, “Un chah ma-id ta-ot mu ay Apo Jos ta allom hinuy? An un ta-o numpapadchung an nahugi an matoy. ");
INSERT INTO ifu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ja chita ayya ja nahugi ta khapo hana enat ta an napukhit. Muti hitay an takhu ja ma-id napukhit hi enat na.” ");
INSERT INTO ifu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Amat hichi ja inali na ay Hesus hi, “Achiyaꞌ adniꞌ alichuwan an pi-idchum nu umali a an mun-ap-apo.” ");
INSERT INTO ifu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ja inalin Hesus ay hija hi, “Umannung hitay alloꞌ ay he-a, ad ugwani an arkhaw ja midchum a ay ha-in ad Paradise.” ");
INSERT INTO ifu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Gwa an nahaꞌ-ad ja himpfumagkha ja hemmelong chin hukhit ja munhehellong an amin ay chuy an lota ingkhana hichin napujaw. Ja hichi Templo ad Jerusalem ja himpfumagkha ja na-ittang chin ma-uꞌtor an kurtina an nanahhalin ay chuy Na-assantuwan an Kwarto. ");
INSERT INTO ifu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja iniꞌgwap Hesus an nangali hi, “Ama, ichat u ay he-a hitay lennagwaꞌ.” Nakhibpfoh hitay an inali na ja na-ongoh chin hochohcha na. ");
INSERT INTO ifu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Unot tinnig chin kapitan chi hinchalo hichin na-at ja nundaydayaw ay Apo Jos ja inali na hi, “Umannung an ma-id pfahor tay an takhu.” ");
INSERT INTO ifu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","An amin chin tatakhu an na-amung an nannig hay hato an na-at ja immanamut cha ja khun cha pun-ug-ug hachi pfokhaꞌ cha hi tutuju cha. ");
INSERT INTO ifu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ja hay hachi nangin-innila ay Hesus ja hay hachi pfinapfai an ninitnud ay hija an narpu ad Galilee ja nuntaynan cha ta tikhan cha nu ngay ma-at. ");
INSERT INTO ifu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Gwacha han ohan lala-e an hay ngachana ja hi Josep an e-Arimatea an provincian chi Judea. Maphod ja magpong hija an takhu. Oha khu hija an mamannod ay ni Pun-ap-apugwan Apo Jos hi tatakhu. Ja anong un oha hija an membron chi Sanhedrin ja agkhuy immapfulut chin nunhahappitanan cha an aton cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja immuy ay Pilato an i nangippug ta i na ilupfuꞌ chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Amat hichi ja i na empah chin achor Hesus ja pinuttiputana hi pfinacha ja unaot ipahikhop han linijangan cha an pfato an lupfuꞌ an ma-id pay i nilupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja gwa an mahilip ay chuy Alemana an arkhaw chi Punhakhanaan hachi Hudju hotti mete-a hini arkhaw chi ngilin. ");
INSERT INTO ifu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hachi ayya pfinapfai an narpu ad Galilee an ninitnud ay Hesus ja nangunud cha ay Josep. Tinnig cha chin lupfuꞌ ja chin enat Josep an nanglupfuꞌ chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Immanamut cha ja nunhakhana cha hi mumpfango an lanob ta gway epelanob cha chin achor Hesus. Ja timmungaw cha ay chuy an Hapfachu an miꞌngilin, ti hitay chi urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Unot nun-inggwiꞌgwiit an Markhachu an nalahin chin ngilin, ja pfimmugwah chin pfinapfai an immuy hichi lupfuꞌ ta in-uy cha chin lanob an enhakhana cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Un chaagkhu emmatam ja nangalimutugwan cha an nipapaꞌ-igwin chin tanglib chin lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Himmikhop cha ja tinnig cha an ma-id hichin achor Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ja mun-am-amungaw hay hachi pfinapfai. Unagkhu himpfumagkha ja gwa han chugwa an linala-e an timmataꞌchug an pomooꞌ chi lopfong cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nang-entata-ot hachi pfinapfai ja inloppolop cha. Ja inalin hachi angher ay chicha hi, “Anagkha ta hingiton ju hini mamattakhu ay tay an ilub-an chi natoy? ");
INSERT INTO ifu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma-id heto, ti nummahu! Nomnomon ju chin inali na hi agawwachaan ju ad Galilee ");
INSERT INTO ifu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","hi nangarjana hi, ‘Ha-in an Na-ilangitan an Takhu, ja mahapor an mipulangaꞌ hay hana napfahulan an tatakhu ja epfakhataꞌ hay kros ja chin me-atloh arkhaw hot mummahuwaꞌ.’ ” ");
INSERT INTO ifu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ja nenomnom mahpay hachi pfinapfai chin inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Numpfangngad cha hichi agawwachaan hachi himpolo ta oha an adalan ja hachi uchumna an numpun-ibpfa cha. Ja impa-innila cha an amin chin tinnig cha ja chengngor cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chin pfinapfai an cha Mary Magdalen, ja hi Joana, ja hi Mary an inan James, ja chin uchumna an pfinapfai an numpun-ibpfa cha chi nangpa-innila ay cha chuy apostol. ");
INSERT INTO ifu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Muti khemhonot hachi apostol un cha pangar-ali, hijaot un cha agkhuy pinati chin inali cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Un angkhay hi Peter chi pfimmutay ja temmagtag an immuy hichi lupfuꞌ. Unagkhu emmatam ja inhichip na ja un hay tinnig na ja chin namiꞌlug cha ay Hesus an negwagwallang. Amat hichi ja empacheh na ja khuna nomnomnomon hitay an na-at. ");
INSERT INTO ifu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ay chuy khu an arkhaw ja gwa han chugwa an takhu an khun umuy ad Emaus an himpolo ta oha chi kilomitlu hi inachawwi na ad Jerusalem. Cha tay an chugwa ja khun cha mitnud ay Hesus chin khuna puntudtuchugwan. ");
INSERT INTO ifu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Khun cha haphapiton an amin hachi en-enat chin tatakhu ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ay chuy an khun cha panaphapitan ja nehnot hi Hesus ja nitnud ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tinikhaw cha muti agkhuy cha immatunan, ti achi na podhon an mumpa-innila. ");
INSERT INTO ifu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ja inalin Hesus ay chicha hi, “Ngachah atag nuy khun ju haphapiton hi khun ju chumalanan?” Intaꞌchug cha ja tinnig na an ahighikha chin angah cha khapo chin khun cha haphapiton. ");
INSERT INTO ifu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inalin chin oha an hi Kleopas hi, “He-a nin ja angkhay chi i nummangili ad Jerusalem an agkhuy nanginnila chin naꞌna-at hichi ay tay immuy an ar-arkhaw.” ");
INSERT INTO ifu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Inalin Hesus hi, “Ngay ngachah hana na-at?” Tempfar cha ja inali cha hi, “Hay hana ena-enat cha ay Hesus an eNazaret. Oha hija an profeta an hennag Apo Jos. Ja matikhaw hana tatakhu an gway apfalinana an muntudtuchu ja an mangat hi milagro. ");
INSERT INTO ifu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Muti hachi a-ap-apon chi papachi ja hachi uchumna an a-ap-apo mi chi nangpulang ay hija ay Pilato ta hugijona an gway pfahor na ja empapatoy na. Ja empepfakhat na hija han kros. ");
INSERT INTO ifu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hijay enehchor mi an mangepfangngad ay chita-o an holag Israel ay ni pun-ap-apugwan ta-o. Ja ad ugwani chi me-atlo hi arkhaw chin natajana. ");
INSERT INTO ifu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ja gwa han nakasda-aw an na-at ad ugwani, ti hana uchumna an ibpfa mi an pfinapfai ja pfimmugwah cha an immuy hichi lupfuꞌ ");
INSERT INTO ifu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ja un chaagkhu inhichip ja ma-id chin achor Hesus. Immali cha an nangali an tinnig cha hana angher an nangpa-innila an nummahu hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Amat hichi ja immuy hachi uchumna an ibpfa mi hichi lupfuꞌ ja tinnig cha an umannung hichin inalin hachi pfinapfai muti ma-id tinnig cha ay Hesus.” ");
INSERT INTO ifu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja inalin Hesus ay chicha hi, “Natottot aju kaykhu, ti nalikhat hi pamatiyan ju hachi inalin chin profetan Apo Jos! ");
INSERT INTO ifu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Un ju chah agkhuy anila an mahapor an hortapon tay an Kristo hato an likhat ja unot mipapfagto?” ");
INSERT INTO ifu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ja impa-innilan Hesus an amin hay hana nitulaꞌ an hapit Apo Jos an ma-at ay hija, nete-a hichin intulaꞌ Moses ingkhana hichin intulaꞌ hachi profeta. ");
INSERT INTO ifu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gwa an mehnot cha chin pfuglay an omajan cha ja enchapchapoh Hesus an amat hi achawwi pay chi omajana. ");
INSERT INTO ifu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Muti impa-ud cha hija ja inali cha hi, “Achi a umuy ta meheto ta-o, ti chiya an mahilip.” Amat hichi ja nitnud ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Inumpfun cha an mangan ja enalan Hesus chin tenapay ja nunyaman ay Apo Jos ja unaot itta-ittangon an inchat ay chicha. ");
INSERT INTO ifu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ay chuy an nangatana ja immatunan cha mahpay an hija hi Hesus. Unagkhu amat hichi ja na-upfah hija. ");
INSERT INTO ifu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ja khun munhapit cha chuy an chugwa an inali cha hi, “Anagkha ta agkhuy ta immatunan ad anachi hi khuna piꞌhapitan ay chita hichi chalan? Hijaot un ta khun mun-an-anla hi nangtuchugwana ay ni hapit Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amat hichi ja empacheh chaot an numpfangngad hichi ad Jerusalem. Ja chinakngan cha an na-a-amung hachi himpolo ta oha an adalan ja hachi uchumna an numpun-ibpfa cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ja inalin hachi adalan hi, “Umannung an nummahu hi Apo Hesus, ti numpatikhaw ay Simon Peter.” ");
INSERT INTO ifu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amat hichi ja impa-innilan khu chin chugwa chin na-at ay chicha hichi ad Emaus, an hay nangmatunan cha khu ay Apo Hesus hi nangitta-ittangana chin tenapay. ");
INSERT INTO ifu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ay chuy an khun cha punhahapitan ja numpatikhaw hi Hesus an timmataꞌchug ay chuy nuntotongngaan cha, ja inali na hi, “Hay lenong chi magwacha ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ja nun-abjot cha ja nang-entata-ot cha, ti khemhon cha un pfanig hitay tinnig cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ja inali na ay chicha hi, “Achi aju toma-ot ja achi aju munharhalinchugwa. ");
INSERT INTO ifu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tikhagwun ju hay hato hukhat tay ngamoy u ja hay hato hu-iꞌ an un ha-in. Aplohonaꞌ hot annilaon ju an gway achor u ja tungar u. Ti un chah gway achor ja tungar chi pfanig?” ");
INSERT INTO ifu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Unaot inali hay hato ja impatikhaw na chin ngamoy na ja chin hu-i na. ");
INSERT INTO ifu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nanannor cha ja mun-an-anla cha an nannig ay Hesus muti munharhalinchugwa chamchama chin nomnom cha. Amat hichi ja empfokhan Hesus ay chicha nu gway mapfalin hi ma-an. ");
INSERT INTO ifu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ja inchat cha han negkhong an khachiw ");
INSERT INTO ifu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ja tittinnig cha an enala na ja inana. ");
INSERT INTO ifu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nakhipfoh an nangan ja inali na ay chicha hi, “Hay hato chin inali-aliꞌ ay chaꞌju chin khun ju pitnuchan ay ha-in, an mahapor an ma-at ay ha-in an amin chi intulaꞌ Moses ja chin intulaꞌ chin profeta ja hini nitulaꞌ an libjun chi Psalms.” ");
INSERT INTO ifu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Amat hichi ja inchatana chicha hi maphod an nomnom an manginnila ay ni hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ja inali na ay chicha hi, “Hitay chin nitulaꞌ an hapit Apo Jos, an mahapor an matoy hi Kristo ja unot mummahu ay ni me-atlo hi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ja ekasaba cha hitay tukhun Apo Jos an allon cha hi, ‘Chuꞌkhon ju hana pfahor ju hot pakawanon chaꞌju ay Apo Jos.’ Heto ad Jerusalem chi pangte-aan cha an pangtudtuchugwan ja unot hay hana uchumna an apfuglapfuglay.” ");
INSERT INTO ifu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ja inalin khu Hesus hi, “Chaꞌju chi muntihtikhu an umannung hay hato an na-at. ");
INSERT INTO ifu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ipa-aliꞌ hini Espiritu Santo an inalin Ama. Hotti hahadchon ju heto ja achi aju makmakak ingkhana hi umali an mangchat hi apfalinan ju an muntihtikhu.” ");
INSERT INTO ifu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Emmopoh hay hato an inali na ja initnud na hachi na-amung an tatakhu ja nakak cha ad Jerusalem. Un chaot ne-atam ad Betani ja entag-oy na chin ngamoy na ta ijapfana chicha. ");
INSERT INTO ifu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ay chuy an khuna pangijapfan ay chicha ja khun tumalakhuy ad uchu. ");
INSERT INTO ifu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ja dinaydayaw cha hija ja numpfangngad cha ad Jerusalem an nunhegla chi an-anla cha. ");
INSERT INTO ifu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ja khun cha umu-umuy hichi Templo an i mundaydayaw ay Apo Jos.");
INSERT INTO ifu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Chin hunhunana an agkhuy na-apja hitay lota, ja hikhud an gawwacha han Hapit an ma-id uchumna nu pfu-un hi Kristo. Gawwacha hija ay Apo Jos ja Jos khu hija. ");
INSERT INTO ifu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hotti gawwacha hija ay Apo Jos chin hunhunana. ");
INSERT INTO ifu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Khapo ay tay an Hapit ja un marmu an amin hana narmu, ja ma-id oh-ohha hi narmu an agkhuy na limmu. ");
INSERT INTO ifu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hitay an Hapit an hi Kristo ja hijay narpugwan chi piꞌtakhuwan, ja hitay piꞌtakhuwan ja hijay hilaw an manenakhan hi nomnom chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ti khenong chi un naherngan hitay lota khapo hi agkhuy nanginnilaan chi tatakhu ay Apo Jos hotti hi Kristo chi nunhilaw. Ja hitay an hilaw ja achi amehon chi munhehellong. ");
INSERT INTO ifu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gwacha han lala-e an nangngachan hi John, an hennag Apo Jos ");
INSERT INTO ifu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","an muntihtikhu hay omaꞌ-atan tay an hilaw an hi Kristo, ta khapo ay tay atona ja mamati an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pfu-un hi John chi ma-ali an hilaw, an un hija chin hennag Apo Jos an muntihtikhu hay omaꞌ-atan tay an hilaw. ");
INSERT INTO ifu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ti hi Kristo an hini umannung an hilaw ja umali heto lota ta mahenakhan an amin chi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ja gawwacha ay tay lota an himpfu na ja anong un hijay Nampfu hi tatakhu ja agkhuy cha immatunan. ");
INSERT INTO ifu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Anong un chin tatakhu ay chuy pfuglay na ja agkhuy cha inapfulut hija. ");
INSERT INTO ifu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Muti chin nangapfulut ja namati ay hija, ja inchatana chicha hi kalintikhan an mipfilang hi empfapfalay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hay enat cha an numpfalin hi empfapfalay Apo Jos ja achi amat ay ni aton ta-o an tatakhu an metoꞌkhong, ja achi khapo hi pamhod chi hempfalay an magwachaan hi empfalay cha, ti hi Apo Jos chi nanghumang an pun-empfalay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hitay ma-ali an Hapit ja numpfalin hi takhu, ja neꞌheto ay chita-o ay tay lota. Impatikhaw na ay chita-o an amin chi khohkhoh Apo Jos ja hini umannung an omaꞌ-atana. Tinikhaw mi chi kinajos na an oh-ohha an Empfalay Jos Ama. ");
INSERT INTO ifu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hitay chi tinihtikhuwan John ja iniꞌgwap na an nangali hi, “Hija chin inali-aliꞌ ay chaꞌju an umali an metob ay ha-in an napfagpfagto, ja gawwacha hija chin hunhunana ja una-ot magwacha.” ");
INSERT INTO ifu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nakhotkhotap chi maphod an enat na ay chita-o ti otongngan chi khohkhoh na. ");
INSERT INTO ifu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ti chin ayya urchin Apo Jos ja impatulaꞌ na ay Moses hotti impa-innila na, muti hini ayya umannung an omaꞌ-atan Apo Jos ja hini khohkhoh na, ja hi Hesu Kristo chi nangpa-innila ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma-id chi hay nanikhaw ja nangpa-innila ay Apo Jos, an un angkhay hi Hesu Kristo an oh-ohha an Empfalay na. Ti Jos khu hija an ninidchum ay Ama na. ");
INSERT INTO ifu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gwa han namenghan an hennag chin a-ap-apon chi Hudju ad Jerusalem chin uchumna an papachi ja Levita an immuy hichin agawwachaan John, ta hanhanan cha nu ngay nitakhuwana. ");
INSERT INTO ifu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Agkhuy enhaot John an empfaag na hini umannung an pfu-un hija chi Hennag Apo Jos an Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ja empfokha cha khu hi, “Hotti ngay nitakhuwam mah? He-a chah chin profeta Elijah an un a nummahu?” Ja inali na hi, “Pfu-un.” Hen-empfokha cha khu hi, “Hotti he-a chah hini Profeta an hahadchon mi an umali?” Ja inali na khu hi, “Pfu-un.” ");
INSERT INTO ifu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ja hen-empfokha cha khu hi, “Hot ngay nitakhuwam mah? Mahapor an epfaag mu hini omaꞌ-atam ta gway ipa-innila mi hana nannag ay chaꞌmi.” ");
INSERT INTO ifu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tempfar John ja inali na hi, “Ti anila ju chin impadtun profeta Isaiah hi nangarjana hi, ‘Hichi let-ang ja gwacha han khun mun-ugwap an khuna allon hachi tatakhu hi, “Epaphod ju hini agwun ni umali an Apo.” ’ Ja ha-in hitay hinapit Isaiah.” ");
INSERT INTO ifu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gwa hachi uchumna an Farisee an nidchum hay hana hennag cha ");
INSERT INTO ifu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ja empfokha cha hi, “Hot anagkha mah ta un he-a hon khun a mumbautisar un pfu-un he-a hini Mamahhod, ja pfu-un he-a hi Elijah, ja pfu-un he-a hinuy Profeta an umali?” ");
INSERT INTO ifu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tempfar John ja inali na hi, “Ha-in ayya ja khunaꞌ mumbautisar hi chanum muti gwa han ninidchum ay chaꞌju an achi ju imatunan. ");
INSERT INTO ifu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hijay metob ay ha-in muti achi mapfalin an ipadchungaꞌ ay hija, ti munnaud hija an napfagpfagto.” ");
INSERT INTO ifu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na-at hay hato ad Betani ay ni chammang ni gwanggwang an Jordan, an hichi chi numbautisaran John chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Unot chin nun-ingwiꞌgwiit ja tinnig John hi Hesus an khun umuy ay chuy agawwachaana, ja inali na hi, “Chuyya hini amat hi pfoꞌtot chi karnero an inchat Apo Jos an midaton ta ma-aan hana pfahor ta-o an tatakhu heto lota. ");
INSERT INTO ifu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hitay hichin inaliꞌ ay chaꞌju an, ‘Gwacha han metob ay ha-in an napfagpfagto, ti gawwacha hija chin hunhunana ja una-ot magwacha.’ ");
INSERT INTO ifu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Anong un ha-in ja agkhuy u anila hitay an umali. Muti hijaot unaꞌ pfinaar ay Apo Jos an mumbautisar hi chanum ta ipa-innilaꞌ hija ay chaꞌju an holag Israel.” ");
INSERT INTO ifu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja nuntihtikhu hi John an inali na hi, “Umannung an tinnig u hini Espiritun Apo Jos an nun-ohop ay hija an narpu ad langit an amat hi kaloma chin tikhaw na. ");
INSERT INTO ifu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Agkhuy u immatunan hija muti hi Apo Jos an namaar ay ha-in an mumbautisar hi chanum, ja hijay nangali ay ha-in hi, ‘Hini takhu an tikham an omajan ni Espiritu ja hija hini mumbautisar hi Espiritu Santo.’ ");
INSERT INTO ifu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ja naꞌna-atigkhaꞌ an hijah tay chi na-at, ja umannung hitay tihtikhuwaꞌ ay chaꞌju an hija hini Empfalay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chin nun-inggwiꞌgwiit ja gawwah chi khu hi John ja han chugwa an disipolo na. ");
INSERT INTO ifu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Unaagkhu tinikhaw hi Hesus an maloh ja inali na hi, “Chuyya chin inaliꞌ an amat hi pfoꞌtot chi karnero an inchat Apo Jos an midaton.” ");
INSERT INTO ifu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Unot chengngor chin chugwa an disipolo na hitay an inali na ja nitnud cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nunligkhoh ja tinnig na chicha an ninitnud, ja inali na hi, “Ngachah chi penhod ju?” Tempfar cha ja inali cha hi, “Chaadmah chi nunhihittugwam, Rabbi?” Ay ni hapit chi Hudju ja Rabbi chi pangali cha ay ni khun muntuchu. ");
INSERT INTO ifu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tempfar Hesus ja inali na hi, “Miꞌjali aju ay ha-in ta tikhan ju hini nunhihittugwaꞌ.” Hotti nitnud cha ay hija. Emmatam cha chin napujaw, ja ni-ib-ipfun cha. ");
INSERT INTO ifu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hay ngachan chin oha ay cha chuy an chugwa an nangngor chin inalin John an i nitnud ay Hesus, ja hi Andrew an akhin Simon Peter. ");
INSERT INTO ifu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Amat hichi ja chinaꞌpuh Andrew an i mannig ay ibpfa na an hi Simon. Unaot tinikhaw hi ibpfa na ja inali na hi, “Tinikhaw mi mahpay hini Mamahhod, an hija hini ma-ali an Mesias.” Hitay an Mesias ja hi Kristo hi hapit chi Griego. ");
INSERT INTO ifu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ja initnud Andrew hi ibpfa na an hi Simon ja immuy cha ay Hesus. Unagkhu emmohchong Hesus hi Simon ja inali na hi, “He-a hi Simon ja hay ngachan amam ja hi John, muti mangadnan a hi Sefas.” Hitay an ngachan an Sefas ja hihiya ay Peter, an hay podhona an hapiton ja pfato. ");
INSERT INTO ifu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gwa khu an nun-inggwiꞌgwiit ja nenomnom Hesus an umuy ad Galilee. Tinikhaw na hi Philip ja inali na ay hija hi, “Miꞌjali a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hi Philip ja eBetsaida an pfuglay khu cha Andrew ay Peter. ");
INSERT INTO ifu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Inapfulut Philip chin inalin Hesus ja i na tinnig hi Nataniel. Ja inali na hi, “Chinittum mi hini Mamahhod an hinapit Moses ay ni intulaꞌ na ay ni urchin Apo Jos, ja nitulaꞌ khu hachi libjun chi profetan Apo Jos chin pengpenghana. Hay ngachana ja hi Hesus an eNazaret, an empfalay Josep.” ");
INSERT INTO ifu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ja inalin Nataniel hi, “Un chah gway maphod hi marpu ad Nazaret?” Ja inalin Philip hi, “Miꞌjali a akay niꞌ ta tikham.” Ja niꞌjuy. ");
INSERT INTO ifu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Unot tinnig Hesus hi Nataniel an gwa an me-atam ja inali na hi, “Tayya han takhu an nahamad an holag Israel ja ma-id lahlah na.” ");
INSERT INTO ifu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ja inalin Nataniel hi, “Ngay nanginnilaam ay ha-in?” Tempfar Hesus ja inali na hi, “Tinnig u he-a an inu-umpfun han puun chi ajiw an higos ja unot umali hi Philip an mangagwit ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ja inalin Nataniel ay hija hi, “Rabbi, umannung an he-a hini Empfalay Apo Jos! He-a hini Ari mi an holag Israel!” ");
INSERT INTO ifu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ja inalin Hesus hi, “Niya an namati a khapo ta inaliꞌ hi tinnig u he-a hi inu-umpfunam han puun chi higos. Cho-or pay chi tikham hi o-ot-ottong an maꞌma-at mu hitay.” ");
INSERT INTO ifu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ja inalin khu Hesus hi, “Umannung mangkay hitay alloꞌ ay chaꞌju, an matikhaw ju an mipfughor ad langit. Ja tikhan ju khu hana angher Apo Jos an munhigwar an khun tomolo an umuy ad langit hon numpfangngad an umali ay ha-in an Na-ilangitan an Takhu.” ");
INSERT INTO ifu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nalahin chi chugwah arkhaw, ja gwacha han kasar ad Kana an provincian chi Galilee. Ja gawwah chi hi Mary an ammod Hesus ");
INSERT INTO ifu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ja neꞌ-ajag cha khu hi Hesus ja hachi disipolo na. ");
INSERT INTO ifu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Unagkhu khimminagwa chin kasar ja napoh chin pfajah, ja inalin chin ammod Hesus ay hija hi, “Chiya an napoh hichuy inumon hachi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ja inalin Hesus ay hija hi, “Ikhachaꞌ, ina, hi atoꞌ, ti agkhuy pay nachakngan hini timpo an pangpa-innilaaꞌ ay ni omaꞌ-ataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Amat hichi ja inalin ina na hachi takhala hi, “Unuchon ju nu ngay allona hi aton ju.” ");
INSERT INTO ifu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gwa han unum an pfato an pfuhih an khun cha pangittugwan hi chanum an mipfulu. Ti paniyaw ay cha nuy Hudju nu achi cha mumpfulu hon nangan cha. Ja himpoloh tempfa hi chanum chi mitto ay ni oha an pfuhih. ");
INSERT INTO ifu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Amat hichi ja inalin Hesus hachi takhala hi, “Punggwon ju hay hachi pfuhih hi chanum.” Hotti pinnu cha. ");
INSERT INTO ifu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ja unaot khu allon ay chicha hi, “Amat hina ja pinauꞌ ju ta ichat ju ay chuy khun mangpadchong ay tay kasar.” Enat cha ");
INSERT INTO ifu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","hot tenamtaman chin khun mangpadchong ay chuy kasar chin chanum an numpfalinon Hesus hi pfajah. Muti agkhuy na anila nu ngay nangalan cha ay chuy pfajah an un angkhay hachi pimmauꞌ chi nanginnila. Enajakhana hichuy lala-e an nungkasar ");
INSERT INTO ifu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ja inali na hi, “Hay ugali ta-o ja ipa-inum ta-o hi mahhun hini mapmaphochan an pfajah, ja unchani ayya ta cho-or chi ininum chi tatakhu, ja un ta-o ipapfutay hini achi munnaud an maphod. Muti tan he-a, ja en-ang-angonoh mu an impa-inum hitay pfuher an pfajah!” ");
INSERT INTO ifu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Enat Hesus hitay ad Kana an provincian chi Galilee, ja hijah tay chi pengpenghan chi milagro hi enat na an nangpatikhagwana ay ni nakaskasda-aw an apfalinana. Ja namati hachi disipolo na ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Napfalin hitay ja empacheh cha Hesus ja hi ina na ja hachi ibpfa na an linala-e ja hachi disipolo na, ja immuy cha ad Kapernaum ja nihihidchi cha. ");
INSERT INTO ifu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gwa an machakngan hichin pfehtan chi Hudju an Pangnomnoman cha chin Nalohan ni Angher Apo Jos chin Pfalay chin A-ap-apo cha ad Egypt, ja immuy hi Hesus ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Unot ne-atam ay chuy partug chi Templo ja chinakngana hachi khun mungkumerchu hi pfakah, karnero ja kaloma an hijay khun nguminaan hana tatakhu hi ipidaton cha ay Apo Jos. Ja tinnig na khu hachi numpanga-umpfun an khun munhukat hi pihun hachi tatakhu hi pihun chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Enala na hachi tali ja enephod na hi huplit ja nun-epakak na hachi khun mungkumerchu ja hachi karnero ja pfakah ay chuy partug chi Templo. Nun-ipfu-allo na khu hachi lamehaan an nun-egwallangan hachi pihu hotti nun-egwa-at cha. ");
INSERT INTO ifu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Inali na hachi khun mungngina hi kaloma hi, “Pun-ekak ju hana ingina ju! Achi ju pumpfalinon hitay pfalay Ama hi pungkumerchuwan!” ");
INSERT INTO ifu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ja nenomnom chin disipolo na hichin nitulaꞌ an hapit Apo Jos hi nangarjana hi, “Amat hi chumalang hitay puhuꞌ khapo hi punnomnomaꞌ ay tay pfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Napfalin an tinnig hachi a-ap-apon chi Hudju hichuy an enat Hesus ja empfokha cha ay hija hi, “Anagkha ta un he-a hon enat mu chi amat heto? Ipatikhaw mu adchiya ay chaꞌmi hay panginnilaan an he-a ja gway apfalinam.” ");
INSERT INTO ifu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tempfar Hesus ja inali na hi, “Paꞌ-iyon ju hitay Templo muti un umuy hi toloh arkhaw hot ehaꞌ-ad u khu, ta panginnilaan ju ay ni apfalinaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ja inali cha hi, “Apat chi polo ta han unum hi tagwon ja un mapakhad hitay Templo ja un chah olog mu an mamakhad hi toloh arkhaw?” ");
INSERT INTO ifu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Muti hini templo an hinapit Hesus ja hini achor na. ");
INSERT INTO ifu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja chin nummahuwana ay chuy me-atloh arkhaw hi natajana, ja un nomnomon hachi disipolo na hitay an inali na. Ja pinati cha mahpay chin nitulaꞌ an Hapit Apo Jos ja hachi inalin Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ay chuy an neꞌpfehtaan Hesus ad Jerusalem, ja cho-or chi namati ay hija khapo ta tinnig cha hana ena-enat na an nangpatikhaw an gway apfalinana. ");
INSERT INTO ifu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Muti hi Hesus ja agkhuy nunchunu ay chicha, ti aniꞌ-ila nay nitakhuwan cha. ");
INSERT INTO ifu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Achi khahin un gway mangpa-innila ay hija ay ni omaꞌ-atan chi tatakhu ti aniꞌ-ila na hini nomnom cha. ");
INSERT INTO ifu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Gwacha han ohan Farisee an ap-apon chi Hudju an hi Nicodemus chi ngachana. ");
INSERT INTO ifu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gwa han ohan nadhom ja immuy hi Nicodemus ay Hesus ja inali na hi, “Rabbi, anila mi an he-ay mehtolo an hennag Apo Jos, ti omod an cho-or hana khun mu aton an achi ma-at chi takhu nu ma-id hi Apo Jos an mangchat hi apfalinan.” ");
INSERT INTO ifu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Himmapit hi Hesus ja inali na hi, “Umannung mangkay hitay alloꞌ ay he-a, an achi midchum hini takhu ay ni Pun-ap-apugwan Apo Jos nu achi mumpiggwa an metoꞌkhong.” ");
INSERT INTO ifu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ja inalin Nicodemus hi, “Aa, muti ngay aton ni ma-ilog an metoꞌkhong khu? Unchah mapfalin an mumpfangngad ay ni poton ina na ta mumpiggwa an metoꞌkhong?” ");
INSERT INTO ifu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tempfar Hesus ja inali na hi, “Umannung hitay alloꞌ ay he-a an mahapor an metoꞌkhong hini takhu hi chanum ja ay ni Espiritu Santo ja un midchum ay ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hini takhu ja omempfalay hi takhu. Hini ayya Espiritu Santo ja ichat nay pfakhu an na-ispirituwan an piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Achi a mamannor ay ni inaliꞌ an mahapor an mumpiggwa aju an metoꞌkhong. ");
INSERT INTO ifu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ti un amat ay ni ijah an mumpfurpfuluud muti ma-id maptoꞌ hi arpugwana ja omajana, an un ikhad hija. Amat hina khu ay ni Espiritu Santo an muntamu ay ni takhu ta mumpiggwa an metoꞌkhong.” ");
INSERT INTO ifu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ja inalin Nicodemus hi, “Hot ngay amatana mah?” ");
INSERT INTO ifu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tempfar Hesus ja inali na hi, “He-ay oha an ma-ar-ali an muntudtuchu hana holag Israel ja anagkha ta achim ma-awatan hitay inaliꞌ? ");
INSERT INTO ifu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Umannung hitay alloꞌ ay he-a, an anila mi ja tinnig mi hana khun mi hapiton. Anong un amat hina ja achi ju pattiyon hana khun mi tihtikhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tayya an impa-innilaꞌ ay chaꞌju hini omaꞌ-atan hana gwah to lota ja niya an achiyaꞌ pattiyon. Hotti om-omod an achi aju mamati nu etoloy u an mangpa-innila hana khun maꞌma-at ad langit. ");
INSERT INTO ifu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ti ma-id ohah takhuh immuy ad langit ja numpfangngad ta ipa-innila na hini omaꞌ-atana, an un angkhay ha-in an Na-ilangitan an Takhu an narpu ad langit. ");
INSERT INTO ifu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hay ma-at ay ha-in ja amat chin khumoꞌ an ulog an nipfitin chin ajiw an empachoꞌ Moses. Amat hina khu ay ha-in an Na-ilangitan an Takhu an mipfitinaꞌ han kros, ");
INSERT INTO ifu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta an amin hana mamati ay ha-in ja miꞌtakhu cha hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ti otong hini pamhod Apo Jos hay hana tatakhu ay tay lota. Hijaot una impa-ali hini oh-ohha an Empfalay na ta an amin hana mamati ay hija ja achi cha ma-utaw ta un chaot miꞌtakhu hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Agkhuy hennag Apo Jos hini Empfalay na an immali heto lota an manugi hi takhu ta madusa cha, an hay nannakhan Ama na ja umali an Manakhu hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hana ayya mamati ay ni Empfalay na ja achi cha mahugi an madusa. Ja hana ayya achi mamati ja napfalin an nahugi cha an madusa, ti achi cha pattiyon hini oh-ohha an Empfalay na. ");
INSERT INTO ifu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hini adusaan cha ja immali hini manilagwan hi tatakhu, muti penpenhod cha hini munhehellong mu hini mumpapattar, ti napukhit hana khun cha aton. ");
INSERT INTO ifu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ti hana khun mangat hi napukhit ja pfuhulon cha hini mumpapattar ja achi cha mehnot ay ni hilaw, ti achi cha podhon an mapfu-ihan hana napukhit an khun cha aton. ");
INSERT INTO ifu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hana ayya khun miꞌtakhu hi magpong ja umali cha ay ni hilaw ta matikhaw hana maphod an khun cha aton khapo ay ni apfalinan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Napfalin hay hachi, ja immuy cha Hesus ja hachi disipolo na hichi provincian chi Judea. Nihihidchi cha hi at hichi hi arkhaw ta mumbautisar cha. ");
INSERT INTO ifu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja gwacha khu hi John Bautista ad Enon an nehnot ad Salim. Hichi khuna pumbautisaran an achoꞌlan chi chanum. Ja gwa hachi immuy ay hija an numpabautisar. ");
INSERT INTO ifu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ay chuy ja agkhuy pay nipfalud hi John. ");
INSERT INTO ifu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ja gwa han nunhohongngilan cha chuy disipolon John ja han ohan Hudju, an chumalat hini aton an mun-ulah ta maleneh hini takhu hi pannig Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Immuy cha ay John ja inali cha hi, “Rabbi, anilam chah hini khun aton chin nun-ibpfam an takhu chin agawwachaan ju hichi chammang chi Jordan, chin khun mu tihtikhuwan ay chaꞌmi? Gwa mangkay an khun mumbautisar ad ugwani ja hijay omajan an amin chi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ja inalin John hi, “Aa, ti otong hini apfalinana, ja ma-id apfalinan hi amat hina nu pfu-un hi Apo Jos chi mangchat. ");
INSERT INTO ifu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Chengngor ju mit chin inaliꞌ an pfu-un ha-in hini Mamahhod muti ha-in hini hennag Apo Jos an mangpangpangullu ja un umali hija. ");
INSERT INTO ifu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ti amat heto, an unaꞌ amat ay ni lala-e an mangpangpangulu ay ni kasar ni khayyum na an mungkasar. Anong un pfu-un hijay mangahagwa ay ni pfalahang ja otong chi anla na an manginnila an immali hini lala-e an mangahagwa ay hija. Amat hina khu ay ha-in, an hini enat u ja enhakhanaꞌ hini umaliyan ni Mamahhod, ja munnaud chi pun-an-anlaaꞌ ti tan immali hija. ");
INSERT INTO ifu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mahapor an hijay ipapfagpfagton chi tatakhu ta pfu-un ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hana tatakhu ja gawwacha cha ay tay lota, ja hana gwah to lota chi khun cha hapihapiton. Hini ayya narpu ad langit ja hijay napfagpfagto an amin. ");
INSERT INTO ifu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hapitona hana tinnig na ja chengngor na muti un tortollo hana mangapfulut ay ni khuna tihtikhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ja hana mangapfulut ay ni khuna tihtikhuwan ja tihtikhuwan cha khu an umannung hana hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti hapit Apo Jos hana allon ni Hennag na an muntihtikhu, ti hijay nangchatan Apo Jos an amin hi apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti hi Jos Ama, ja podpodhona hitay an Empfalay na ja impulang na an amin ay hijay apfalinan ta hijay mangpaptoꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hana ayya mamati ay tay an Empfalay na ja miꞌtakhu cha hi ma-id chi pogpogna. Hana ayya man-ug ay tay Empfalay na ja achi cha miꞌtakhu, ja hoꞌmon cha hini ma-id pogpogna an pundusaan Apo Jos ay chicha khapo hi pfungot na. ");
INSERT INTO ifu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Inannilan Hesus an chengngor hachi Farisee an choꞌchoꞌ-or hachi khun i mumpabautisar ay hija an numpfalin hi disipolo na mu ay John. ");
INSERT INTO ifu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Muti pfu-un hi Hesus chi khun mumbautisar an un hachi disipolo na. ");
INSERT INTO ifu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hotti amat hichi ja nakak cha Hesus ad Judea ja numpfangngad cha ad Galilee. ");
INSERT INTO ifu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ja mahapor an eꞌgwa cha hichi provincian chi Samaria. ");
INSERT INTO ifu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Gwa an nahaꞌ-ad ja ne-atam cha hichi ad Sikar an ohan pfuglay ad Samaria, an nehnot ay ni lota an empfanoh Jakob chin nahop ay Josep an empfalay na. Ay chuy an lotan Jakob ja gwa han pfupfun ja inu-umpfun hi Hesus ay chuy ngapfar na, ti naꞌ-ablay an chimmalachalan. ");
INSERT INTO ifu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Emmo-ohha hi Hesus, ti nakak hachi disipolo na an i ngumina hi anun cha ay chuy nehnot an pfuglay. Ay chuy inu-umpfunan Hesus ja immuy han pfupfai an eSamaria ay chuy an pfupfun an i humaꞌchu. Niꞌhapit hi Hesus ja inali na hi, “Miꞌ-inumaꞌ adniꞌ ay tay chanum ju.” ");
INSERT INTO ifu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ja nanannor chin pfupfai, ti hachi Hudju ja khun cha pahigwon hachi eSamaria ja ugali cha an achi cha midmidchum ay chicha. Ja inalin chin pfupfai hi, “Aa, muti Hudju a jaꞌ, ja anagkha ta la-ahna ja ha-in an eSamaria chi pumpfokhaam hi hay inumom?” ");
INSERT INTO ifu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tempfar Hesus ja inali na hi, “Nu inannilam hini ichat Apo Jos, ja nu imatunanaꞌ an nangpfokha ay he-a hi chanum, hot he-aot koma chi mangpfokha ay ha-in ta ichat u hini chanum an mangchat hi nahamad an piꞌtakhuwan.” ");
INSERT INTO ifu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ja inalin chin pfupfai hi, “Apo, ma-id panggwoꞌ mu ja adchalum khu hitay an pfupfun. Hot ngay pangalam ay ni allom an chanum an mangchat hi nahamad an piꞌtakhuwan? ");
INSERT INTO ifu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Chin apo mi an hi Jakob chi nangpfanoh ay tay an pfupfun an khun cha uminuman hachi empfapfalay na, ja anong un hachi khuna panganun. Un chah hay allom ja napfagpfagto a mu hi Jakob?” ");
INSERT INTO ifu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tempfar Hesus ja inali na hi, “Hana na-ugaw an uminum ay tay an chanum ja ma-ugaw cha khu. ");
INSERT INTO ifu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Muti hini ayya uminum ay ni chanum an ichat u ja achi mahpay ma-ugaw. Ti hini chanum an ichat u ja amat hi opfob ay ni achor na an achi matmatchuꞌ, ja ichat nay piꞌtakhuwan an ma-id chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ja inalin chin pfupfai hi, “Apo, hot ichatanaꞌ mah ay ni allom an chanum ta achiyaꞌ ma-ugaw ja achi khahin unaꞌ khun uma-umali heto an humaꞌchu.” ");
INSERT INTO ifu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ja inalin Hesus hi, “Im agwiton hini ahagwam ja numpfangngad aju heto.” ");
INSERT INTO ifu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Inalin chin pfupfai hi, “Ma-id ahagwaꞌ.” Ja inalin Hesus hi, “Aa, umannung hinuy inalim an ma-id ahagwam ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Muti numpalema a an narhin, ja hini ayya lala-e an nun-i-ibpfam ad ugwani ja pfu-un ahagwam. Hotti umannung hinuy inalim.” ");
INSERT INTO ifu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ja inalin khu chin pfupfai hi, “Apo, imatunaꞌ an profeta a. Hotti tayya han epfokhaꞌ ay he-a. ");
INSERT INTO ifu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chin a-apo mi an eSamaria, ja hitay an pfuludna chi khun cha pundayawan ay Apo Jos. Chaꞌju ayya an Hudju, ja hay allon ju ja khahin un ad Jerusalem chi i pundayawan. Ngachah chi maptoꞌ ay tay?” ");
INSERT INTO ifu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ja inalin Hesus ay hija hi, “Mamati a akay niꞌ ay tay alloꞌ, ti umali han arkhaw an pfu-un hitay pfuludna chi pundayawan chi tatakhu ay Jos Ama ja pfu-un khu ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chaꞌju an eSamaria, agkhuy ju inannila hi Apo Jos an khun ju dayawon. Muti chaꞌmi an Hudju ja anila mi, ti hini Manakhu hi tatakhu ja marpu hana Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Muti umali han timpo ja mete-a ad ugwani, an hana umannung an mundayaw ay Jos Ama ja nahamad hini aton cha an mundayaw ja mumpa-echalan cha ay ni Espiritu Santo. Hitay hini podhon Apo Jos an aton chi tatakhu an mundayaw ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hi Apo Jos ja ispiritu an achi matikhaw. Hotti hana mundayaw ay hija ja mahapor an mumpachalan cha ay ni Espiritu Santo ja annilaon cha hini nahamad an aton an mundayaw.” ");
INSERT INTO ifu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ja inalin chin pfupfai hi, “Anilaꞌ an umali hini Mesias, an hinuy ma-ali an hi Kristo. Nu umali ja ipa-innila na an amin hana agkhuy ta-o pay anila.” ");
INSERT INTO ifu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tempfar Hesus ja inali na hi, “Ha-in an khun miꞌhapit ay he-a hini inalim an hahadchon ju.” ");
INSERT INTO ifu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Khun pay miꞌhapit hi Hesus hi numpfangngachan hachi disipolo na, ja nanor cha hi nannikhan cha ay Hesus an khun miꞌhapit hi pfupfai. Muti ma-id oha hi nangpfokha nu ngay mahapor chuy pfupfai ja anagkha ta khun miꞌhapit hi Hesus ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Amat hichi ja tenaynan chin pfupfai chin pfanga an ihaꞌchu na, ja numpfangngad ay nuy pfuglay cha. Ja inali na chin tatakhu hi, ");
INSERT INTO ifu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Umali aju akay niꞌ ta i ta-o tikhagwun han lala-e an chinittum u ja inali na an amin hana ena-enat u. Ma-id maptoꞌ un hijah nuy hi Kristo an hini allon cha an Mamahhod?” ");
INSERT INTO ifu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amat hichi ja empacheh cha an i mannig ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gwa an nakak chin pfupfai ja impapilit chin disipolon Hesus ta mangan hija. ");
INSERT INTO ifu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Muti inalin Hesus hi, “Gwa han nabnab-on an khun u anun an agkhuy ju anila chi omaꞌ-atana.” ");
INSERT INTO ifu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ja khun cha nomnomnomon hi, “Un chah gway uchumna hi nang-ali hi anun Hesus?” ");
INSERT INTO ifu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ja inalin Hesus hi, “Hay ayya tanud u ja hini pangataꞌ ay ni penhod ni nannag ay ha-in ja hay atoꞌ an mamalin ay ni ipatamu na. ");
INSERT INTO ifu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gwa han khun ju allon an amat heto. Hini pakhuy an nebkhay ja hachon ta umuy hi apat chi pfulan ja un mabtoꞌ. Muti alloꞌ ay chaꞌju hi ahebtoꞌ ad ugwani. Tikhagwun ju hachi tatakhu an khun cha umali. Omaꞌ-at cha hi pakhuy an natong an munhohhood hi mamtoꞌ, ti nehahagkhana cha an mamati. ");
INSERT INTO ifu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hana i mumpfotoꞌ ja malagpfuwan cha, ja hana pfentoꞌ cha ja miꞌtakhu cha hi ma-id chi pogpogna. Hotti numpadchung an hini numpfokhay ja hini numpfotoꞌ ja mun-an-anla cha. ");
INSERT INTO ifu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ti umannung hitay khun cha allon, an egpfay chi oha ja pfot-on chi oha. Amat hina khu ay ni tamun Apo Jos, an ");
INSERT INTO ifu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","hennag u chaꞌju ta i ju pfot-on hana agkhuy ju na-unglan. Hotti chaꞌju hini mamtoꞌ hana pfungan chi na-unglan hana nahnahhun.” ");
INSERT INTO ifu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cho-or hana eSamaria an namati ay Hesus khapo ta inalin chuy pfupfai hi, “Inalin nuy an lala-e an amin hana ena-enat u.” ");
INSERT INTO ifu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hotti immuy cha ay Hesus ja inali cha hi, “Achi a adchiya umuy ta mehetheto ta-o pay.” Hotti nihichi hi Hesus hi chugwah arkhaw. ");
INSERT INTO ifu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ja choꞌchoꞌ-or pay hay hachi namati khapo hi nangngolan cha ay chuy khuna itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ja inali cha chin pfupfai hi, “Pfu-un hinuy inalim ja angkhay chi namatiyan mi, ti enhemad mi an nunchongor ay hija, ja anila mi an umannung an hija hini Manakhu hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nalahin chi chugwah arkhaw ja nakak cha Hesus ad Samaria ta umuy cha hichi ad Galilee an emmer-erkhana. ");
INSERT INTO ifu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Immuy hichi hi Hesus ti hijay nangali hi, “Hini profeta ja achi egngor hana tatakhu ay ni pfuglay an narpugwana.” ");
INSERT INTO ifu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Muti un chaagkhu emmatam ad Galilee ja inapfulut hachi tatakhu hi Hesus, ti tinnig cha an amin hana enat na an pangpa-innilaana ay ni apfalinana chin neꞌpfehtaan cha ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Amat hichi ja numpfangngad cha Hesus ad Kana an pfuglay hichi Galilee, an nangephochana chin chanum hi pfajah. Ja gwa ad Kapernaum han ap-apo an nunchokhoh han empfalay na an lala-e. ");
INSERT INTO ifu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Unot chengngor tay ap-apo an nakak hi Hesus ad Judea ta umuy ad Galilee, ja immuy an i numpakpaka-ahi ay Hesus ja inali na hi, “Apo, miꞌjali a adniꞌ hichi pfalay mi ad Kapernaum ta epatenong mu han empfalay u an lala-e, ti gwa an ma-uꞌ-uꞌlud.” ");
INSERT INTO ifu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ja inalin Hesus hi, “Tan khahin hi gway tikhan ju hi panginnilaan ay ni apfalinaꞌ ja un aju mamati ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ja inalin gwot chin ap-apo hi, “Apo, panga-ahim ta miꞌjali a adniꞌ ta achi matoy hini empfalay u.” ");
INSERT INTO ifu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ja inalin Hesus hi, “Umanamut a, ti temmenong hini empfalay mu.” Pinati na chin inalin Hesus ja empacheh na an umanamut. ");
INSERT INTO ifu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gwa an khun umuy ja chinittum na hachi takhala na an nangali ay hija hi, “Temmenong hini empfalay mu.” ");
INSERT INTO ifu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ja henanhanana hi aꞌ-anunay temmengngana ja inali cha hi, “Temmenong ad akhapfan hi napujaw.” ");
INSERT INTO ifu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ja nenomnom chin lala-e an hichuy chin timpo an nangarjan Hesus hi, “Temmenong hini empfalay mu.” Hotti an amin cha an hen-a-amma ja namati cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Piggwana hitay hi nakakan Hesus ad Judea ta umuy ad Galilee an nangatana hi milagro an nangpatikhaw ay ni apfalinana. ");
INSERT INTO ifu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nalahin chi at hichi hi arkhaw ja gwa han pfehtan chi Hudju ad Jerusalem, ja immuy hi Hesus an i meꞌpfehta. ");
INSERT INTO ifu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ja gwa han pohong ad Jerusalem an nangadnan hi Betesda hi hapit chi Hudju, an nehnot chin Pantaw chi Karnero. Ja gwah chi han lema an piligman ");
INSERT INTO ifu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","an khun pumpepegkhengan hay hachi mumpunchokhoh. Gway napfulaw, napi-on ja napechoy, an munhohhood hi puntepja-an chuy chanum. ");
INSERT INTO ifu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ti umu-udchum anu hon khun umuy han angher Apo Jos ay chuy an pohong ta ina puntepja-on. Ja hini ayya mahhun an i muntamor nu muntepjaꞌ, ja hijay ma-akhahan chi chokhoh na. ");
INSERT INTO ifu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ja gwa ay chuy han ohan lala-e an khun munchokhoh hi tolompolo ta han gwalo hi tagwon. ");
INSERT INTO ifu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tinnig Hesus hija an numpepekheng ja inannila na an napfajag hichuy chokhoh na. Nehnot hi Hesus ja inali na ay hija hi, “Podhom chah an tomenong hini chokhoh mu?” ");
INSERT INTO ifu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tempfar chin munchokhoh ja inali na hi, “Ti aa, Apo, muti ma-id atag chi manglaꞌ-oy ay ha-in ta ujaꞌ etamor ay chuy chanum nu muntepjaꞌ. Ja enhehemad u an i meꞌtamor hon nahhun hay hana uchumna.” ");
INSERT INTO ifu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ja inalin Hesus hi, “Pfumangon a ja lenaꞌ-oy mu hinuy opfog mu ja chimmalan a.” ");
INSERT INTO ifu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ja pfimmangon ja linaꞌ-oy na chin opfog na ja khun chumalan. Hay na-atan tay ja Hapfachu an ngilin chi Hudju, ");
INSERT INTO ifu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","hijaot un inalin hachi uchumna an a-ap-apon chi Hudju ay chuy lala-e an empatenong Hesus hi, “Hapfachu ad ugwani an ngilin, ja pinaꞌ-im hini urchin ta-o ti niya an inu-ugnam hinuy opfog mu.” ");
INSERT INTO ifu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tempfar chin lala-e ja inali na hi, “Hini nangpatenong ay tay chokhoh u chi nangali ay ha-in hi laꞌ-ajoꞌ hitay opfog u ja chimmalanaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ja inali cha hi, “Ngay ngachan nuy an lala-e an nangali ay nuy?” ");
INSERT INTO ifu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Muti ma-id maptoꞌ hi logngona, ti nunlonoh hi Hesus ay chuy achoꞌlan chi nakhagong. ");
INSERT INTO ifu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Unot achi mapfajag ja immuy hi Hesus hichi Templo ja inah-upana chin lala-e an empatenong na ja inali na hi, “Niya an temmenong a, hotti epokhong mu an pfumahor ta ma-id umali hi om-omod an likhat ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nakak chin lala-e ja i na impa-innila hachi a-ap-apon chi Hudju an hi Hesus chin nangpatenong ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hijaot un cha ente-a an namarpalikhat ay Hesus ti i na empatenong hinuy munchokhoh hi arkhaw an ngilin. ");
INSERT INTO ifu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Himmapit hi Hesus ja inali na ay chicha hi, “Tumamutamu hi Ama hi a-arkha-arkhaw ja mahapor an hijay peꞌ-at u.” ");
INSERT INTO ifu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chumalat hitay an inali na ja emmomod chin aton hachi a-ap-apon chi Hudju an munnomnom hi aton cha an mangpapatoy ay hija. Ti pinaꞌ-i na hini urchin cha hi numpatengngana hi chokhoh ay ni arkhaw an ngilin. Ja meꞌchagkha khu ja impadchung na hini achor na ay Apo Jos hi nangarjana hi, hi Apo Jos chi Ama na. ");
INSERT INTO ifu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Himmapit hi Hesus ja inali na hi, “Umannung hitay alloꞌ ay chaꞌju, an ha-in an Empfalay Apo Jos, ja achi mapfalin an unaꞌ umi-igway an mangat ay ni atoꞌ, an hay khun u aton ja hana khun u tikhan an aton Ama. Ti an amin hini aton Ama, ja hija khu chi peꞌ-at u. ");
INSERT INTO ifu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ti hi Ama ja penenpenhochaꞌ an Empfalay na ja khuna ituchu ay ha-in an amin hana khuna aton. Ja ot-ottong pay chi ituchu na hi atoꞌ an milagro mu hay hato tinnig ju, hot mamannor aju. ");
INSERT INTO ifu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hi Ama ja khuna pummahuwon hana nun-atoy ta miꞌtakhu cha. Ja amat hina khu ay ha-in an Empfalay na, an ichat u hini nahamad an piꞌtakhuwan hay hana penhod u an pangchatan. ");
INSERT INTO ifu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ja pfu-un hi Ama hini manugi hi tatakhu, ti inchat na ay ha-in an Empfalay na hini apfalinan an manugi. ");
INSERT INTO ifu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ti penhod na an hay hachi tatakhu ja padayawonaꞌ an Empfalay na, an amat ay ni aton cha an mangpadayaw ay hija. Achiyaꞌ ayya padayawon ja hihiya an achi cha padayawon hi Ama an nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Umannung hitay alloꞌ, an hana michatan ay ni nahamad an piꞌtakhuwan an ma-id chi pogpogna ja hana mangawatan ay ni khun u ituchu ja namati cha ay Ama an nannag ay ha-in. Achi cha mahpay mahugi ta matoy cha, muti miꞌtakhu cha hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ja umannung khu hitay an alloꞌ. Umali han timpo, ja mete-a ad ugwani, an hana ma-id pay piꞌtakhuwan na ay Apo Jos ja chonglon cha hini hapit u an Empfalay na. Ja hana mangat ay ni chengngor cha ja miꞌtakhu cha. ");
INSERT INTO ifu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hi Ama hini arpugwan chi piꞌtakhuwan, ja eneꞌcha na an amat hina khu hini piꞌtakhuwaꞌ an Empfalay na. ");
INSERT INTO ifu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ja inchatanaꞌ khu hi apfalinan an manugi, ti ha-in hini Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Achi aju masda-aw ay tay inaliꞌ, ti umali han arkhaw an chonglon an amin hana nun-a-atoy hini ajag u ");
INSERT INTO ifu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hot mumpangapfutay cha ay ni lupfuꞌ cha, ja michatan hana nangat hi maphod hi piꞌtakhuwan an ma-id chi pogpogna, ja mahugi hana nangat hi napupukhit ta madusa cha. ");
INSERT INTO ifu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Achi mapfalin an omo-ohhaaꞌ hon enat uy atoꞌ. Ti nu ha-in chi manugi ja mahapor an unuchoꞌ hini ituchun Apo Jos. Hotti nahamad hini atoꞌ an manugi, ti pfu-un hini penhod u chi unuchoꞌ an hini penhod nuy nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nu ha-in ja angkhay chi mangali ay ni omaꞌ-ataꞌ ja mapfalin an allon ju hi achi umannung. ");
INSERT INTO ifu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Muti gwa han oha an manihtikhuwan ay ha-in, ja anilaꞌ an umannung hini panihtikhu na ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ja hennag ju khu hachi immuy ay John Bautista an i nunhanhan, ja impa-innila na hini umannung an omaꞌ-ataꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Achiꞌ allon hay hato khapo ta munhocholaꞌ ay ni nuntihtikhuwan John wenno hay uchumna hi tatakhu, muti hay pangarjaꞌ ja ta mamati aju ta gway aton ju an miꞌtakhu. ");
INSERT INTO ifu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Hi John ja mipadchung hi hilaw an numpfinang, ja madmachennor aju chin pfinang na hi naꞌnaꞌ-omtang. ");
INSERT INTO ifu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Muti gwa han oha an nahamhamad chi panihtikhu na ay ha-in mu hi John, an hija hay hato milagro an khun u aton an inalin Ama hi atoꞌ. Hay hato chi panginnilaan an hennakhaꞌ ay Ama. ");
INSERT INTO ifu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hay oha hi muntihtikhu ja hi Ama an nannag ay ha-in. Muti agkhuy ju chengchengngor chi hapit na ja agkhuy ju tintinnig hini omaꞌ-atana, ");
INSERT INTO ifu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ja agkhuy ju intanum ay ni nomnom ju hini intuchu na, ti achiyaꞌ pattiyon an hennag na. ");
INSERT INTO ifu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Khun ju acha-achalon hini nitulaꞌ an Hapit Apo Jos, ti hay khemhon ju ja hijay pangalan ju hi piꞌtakhuwan hi ma-id chi pogpogna. Muti ha-in hini khun hapiton hay hato an Hapit na, ");
INSERT INTO ifu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ja achi ju chamchama podhon an umali ay ha-in an gway apfalinana an mangchat hi nahamad an piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Achiꞌ khun hapulon chi pundayawan chi tatakhu ay ha-in, muti anong un u hapulon ja achi aju mundayaw ");
INSERT INTO ifu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ti anilaꞌ an ma-id pamhod ju ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ti hi Ama chi nannag ay ha-in an immali heto lota ja tan achiyaꞌ apfuluton ay chaꞌju. Hay hana agkhu niꞌ uchumna an ma-id chi nannag ay chicha, an un cha ikhad hon immali cha, hon inapfulut ju. ");
INSERT INTO ifu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pa-appodhon ju nu padayawon chaꞌju hay hana i-ibpfa ju, muti achi ju agkhu pachot-anan hini pedayawan Apo Jos ay chaꞌju. Hijaot un aju achi mamati ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Anong un aju amat heto ja pfu-un ha-in chi mangchalom ay chaꞌju ay Ama. Hana intulaꞌ Moses an nange-ehcholan ju chi mangchalom ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ti nu umannung an pinati ju hi Moses hot namati aju koma ay ha-in, ti ha-in hini hinapit Moses ay ni intulaꞌ na. ");
INSERT INTO ifu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Muti agkhuy ju pinati chin intulaꞌ na, hijaot un aju achi mamati ay ni hapit u.” ");
INSERT INTO ifu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Immuy chi at hichi hi arkhaw ja pfimmad-ang cha Hesus chin baybay ad Galilee an nangadnan khu hi Tiberias. ");
INSERT INTO ifu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cho-or chin tatakhu an nangunud ti tinnig cha hana milagro an en-enat na an nangpatikhaw ay ni apfalinana, ti nun-epatenong na hachi mumpunchokhoh. ");
INSERT INTO ifu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nunti-id cha Hesus ja chin disipolo na han pfulludna ja inumpfun cha. ");
INSERT INTO ifu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Metongor ay chuy ja machakngan chin pfehtan chi Hudju an Pangnomnoman cha chin Nalohan chin Angher Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Unagkhu nuntigkhatigkhaw hi Hesus ja tinnig na hachi cho-or an tatakhu an khun mehmehnot ay hija, ja inali na ay Philip hi, “Chaad nin chi i ta-o nguminaan hi epa-an hay hato tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Inali na hitay ta toptopngana hi Philip, ti aniꞌ-ilan Hesus hini atona. ");
INSERT INTO ifu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tempfar Philip ja inali na hi, “Anong un inginay pfinoꞌla hi gwaloy pfulan ja achi omanay hi hiniꞌ-itangon cha.” ");
INSERT INTO ifu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ja inalin Andrew an oha ay cha chuy adalan Hesus an ibpfan Simon Peter hi, ");
INSERT INTO ifu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tayya han ung-ungnga an lala-e an nunhohongot hi lema an tenapay ja chugwa an khachiw. Muti achi omanay ti cho-or hato tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ja inalin Hesus hi, “Ipapfun ju hachi tatakhu.” Hotti impapfun cha ay chuy agawwachaan cha an achoꞌlan chi holoꞌ. Ja umuy hi lemay lipfu hachi linala-e ay chuy an khagong. ");
INSERT INTO ifu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Enalan Hesus chin lema an tenapay ja nunyaman ay Apo Jos, ja empe-ap-apong na hachi tatakhu an numpanga-umpfun. Ja enat na khu chin khachiw. Nangan cha hotti na-apchan cha an amin. ");
INSERT INTO ifu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Unagkhu na-apchan chin tatakhu ja inalin Hesus hachi disipolo na hi, “I ju tipunon hay hachi nun-ahagwar ta ma-id metapar.” ");
INSERT INTO ifu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hotti enat cha ja nun-apnu han himpolo ta chugwa an pfahkit chin nun-ahagwar ay chuy lema an tenapay an inan hachi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tinnig hachi tatakhu hichuy enat Hesus an nangpatikhaw ay ni apfalinana, ja inali cha hi, “Hijah tay hini nipadtu an Profetan Apo Jos an umali heto lota.” ");
INSERT INTO ifu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aniꞌ-ilan Hesus an khun cha nomnomon an piliton cha hija an mumpfalin hi ari cha. Muti achi na podhon, hotti tenaynana chicha ja inti-id na khu ay chuy an pfulludna ta iomohha. ");
INSERT INTO ifu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gwan nahilip ja nunchayyu hachi disipolon Hesus hichi baybay, ");
INSERT INTO ifu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ja nunlukhan cha han pfalangay ta umuy cha hichi chammangna an ad Kapernaum. Gwa an nadhom ja ma-id pay tinnig cha hi mangunud ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Unagkhu himpfumagkha ja immali han mapfi-ah an ijah ja nuntipjaꞌ-ong chin chanum. ");
INSERT INTO ifu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Khun mungkhaud hachi disipolon Hesus ja unagkhu immachawwi cha hi lema wenno unum hi kilomitlu ay chin pingngit chi baybay an narpugwan cha, ja tinnig cha hi Hesus an khun chumalan ay chuy chanum, ja khun mehmehnot ay chicha. Ja nang-entata-ot cha. ");
INSERT INTO ifu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Himmapit hi Hesus ja inali na hi, “Achi aju toma-ot ti ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ja nun-an-anla cha an nanglukhan ay hija. Naꞌnaꞌ-omtang ja emmatam cha chin pingngit chi baybay an negpongan ni i cha omajan. ");
INSERT INTO ifu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chin nun-ingwiꞌgwiit ja gawwacha cha pay hachi tatakhu ay chuy pingngit chuy baybay an chammang ni immajan hachi disipolon Hesus. Tinnig cha an ma-id uchumna hi pfalangay, ja anila cha an agkhuy niꞌlukhan hi Hesus chin oh-ohha an nunlukhanan hachi disipolo na. ");
INSERT INTO ifu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Muti ay chuy an nanong ja gwacha chin uchumna an pfalangay an narpu ad Tiberias an nangtaꞌchug ay chuy negpongan chin nanganan hachi tatakhu ay chuy tenapay an nunyamanan Apo Hesus ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tinnig hachi tatakhu an ma-id hi Hesus, ja ma-id khu hachi disipolo na, hotti amat hichi ja niꞌlukhan cha chin pfalangay, ja neꞌpacheh cha an umuy ad Kapernaum ta i cha hingiton hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Unot inah-upan hachi tatakhu hi Hesus ay chuy chammangna an ad Capernaum ja inali cha ay hija hi, “Rabbi, aꞌ-anunay immaliyam heto?” ");
INSERT INTO ifu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ja inalin Hesus hi, “Umannung hitay alloꞌ, an hini khunaꞌ paningitan ay chaꞌju ja khapo ta inan ju chin tenapay ja na-apchan aju. Achiyaꞌ khun hingiton khapo ta na-awatan ju hana enat u an panginnilaan ju ay ni apfalinaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hay maphod hi aton ju ja pfu-un hini anun heto lota chi epa-ennongan ju an itamu, ti hay hato ja mapogpog. Hay epa-ennongan ju an hingiton ja hini anun an achi mapogpog, an hijay mangchat hi piꞌtakhuwan an ma-id chi pogpogna. Hini mangchat ay tay an achi mapogpog an anun ja un angkhay ha-in an Na-ilangitan an Takhu, ti hi Ama chi nangchat hi kalintikhaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ja empfokha cha ay hija hi, “Hot ngay aton mi an mangat ay ni penhod Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tempfar Hesus ja inali na hi, “Hay podhon Apo Jos hi aton ju ja mamati aju ay ha-in an hennag na.” ");
INSERT INTO ifu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ja empfokha cha khu hi, “Hot gwacha mah chi ipatikhaw mu ta panginnilaan mi ay ni apfalinam ta gway aton mi an mamati ay he-a. Hotti ngay mah atom? ");
INSERT INTO ifu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hi Moses ja penangana chin a-apo ta-o hi mana hichi let-ang. Ti allona ay ni hapit Apo Jos hi, ‘Penangana chicha ay ni anun an narpu ad langit.’ ” ");
INSERT INTO ifu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tempfar Hesus ja inali na hi, “Umannung hitay alloꞌ, an pfu-un hi Moses chi nangchat ay chuy inan cha an narpu ad langit, an hi Ama chi nangchat. Ja chin khun cha anun an narpu ad langit, ja pfu-un hijay nahamad an anun an ichat Apo Jos ay chaꞌju ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ti hinuy nahamad an anun an ichat Apo Jos ja hijah nuy hini narpu ad langit ta ichat nay piꞌtakhuwan hay hana tatakhu an mamati ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ja inali cha hi, “Apo, khun mu akay mah ichat hinuy allom an anun ay chaꞌmi.” ");
INSERT INTO ifu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ja inalin Hesus hi, “Ha-in hini mipadchung hi anun an mangchat hi piꞌtakhuwan. Ti hini mamati ay ha-in ja achi homenhenaang ja achi ma-ug-ugaw. ");
INSERT INTO ifu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Muti umannung chin inaliꞌ, an anong unaꞌ tinikhaw ay chaꞌju ja agkhujaꞌ pattiyon. ");
INSERT INTO ifu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","An amin hana eneꞌchan Ama an mumpfalin hi tatakhuꞌ ja umali cha ay ha-in. Ja hini umali ay ha-in ja akhamichoꞌ an achiꞌ epakak. ");
INSERT INTO ifu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti immaliyaꞌ an narpu ad langit ta atoꞌ hini penhod Ama an nannag ay ha-in an pfu-un hini penenhod u. ");
INSERT INTO ifu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hijah tay chi penhod Ama hi atoꞌ, an pummahuwoꞌ an amin hana inchat na ay ha-in ay tay umali an apogpokhan tay lota ta ma-id oh-ohha hi ma-utaw. ");
INSERT INTO ifu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ti hitay hini penhod Ama, ta an amin hana tatakhu an nanginnila ja namati ay ha-in, ja miꞌtakhu cha hi ma-id chi pogpogna. Hotti pummahuwoꞌ chicha chin apogpokhan tay lota.” ");
INSERT INTO ifu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Unot chengngor hachi Hudju chin inali na ja ente-a cha an mungngulungur, ti achi cha penhod chin inali na an, “Ha-in hini mipadchung hi anun an narpu ad langit.” ");
INSERT INTO ifu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ja khun cha allon hi, “Unchah pfu-un hitay hini empfalay Josep an hi Hesus? Anila ta-o cha nuy a-ammod na, ja anagkha ta allona hi un narpu hija ad langit?” ");
INSERT INTO ifu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ja inalin Hesus ay chicha hi, “Epokhong ju an mungngulungur. ");
INSERT INTO ifu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma-id chi hay oha hi mamati ay ha-in an khahin un hi Ama an nannag ay ha-in chi mangehnot ay chicha. Hana ayya mamati ja pummahuwoꞌ chicha chin apogpokhan tay lota. ");
INSERT INTO ifu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ti gwa han nitulaꞌ an hapit Apo Jos an intulaꞌ hachi profeta hi nangarjana hi, ‘An amin chi tatakhu ja tuchugwan Apo Jos.’ Hini munchongor ay ni ituchun Ama ja khenokhotana, ja mamati ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma-id chamchama nannig ay Ama, ti un angkhay ha-in an narpu ay hija chi nannig. ");
INSERT INTO ifu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Umannung hitay alloꞌ, hana mamati ay ha-in ja miꞌtakhu cha hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja ha-in hini mipadchung hi anun an mangchat hi nahamad an piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chin a-apo ju an nangan chin mana hichin agawwachaan cha hichi let-ang ja nun-a-atoy cha chamchama. ");
INSERT INTO ifu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Muti hitay inaliꞌ an anun an narpu ad langit, ja hini mangan hot achi matoy. ");
INSERT INTO ifu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja ha-in hini mipadchung hi anun an narpu ad langit an mangchat hi piꞌtakhuwan. Hini mangan ay tay an anun ja miꞌtakhu hi ma-id chi pogpogna. Ti hitay an anun ja hija hitay achor u an ichat u ta gway aton chi tatakhu an miꞌtakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chengngor hachi Hudju ja ente-a cha khu an nunhohongnger ja inali cha hi, “Ngay aton tay an takhu an mangchat ay chuy achor na ta anun ta-o?” ");
INSERT INTO ifu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ja inalin Hesus hi, “Umannung hitay alloꞌ. Nu achi aju meꞌ-an ay tay achor u an Na-ilangitan an Takhu, ja miꞌ-inum ay tay chalaꞌ, hot achi aju magwachaan hi nahamad an piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hana ayya meꞌ-an ay tay achor u ja miꞌ-inum ay tay chalaꞌ ja magwachaan cha hi piꞌtakhuwan an ma-id chi pogpogna, ja pummahuwoꞌ chicha chin apogpokhan tay lota. ");
INSERT INTO ifu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ti hitay achor u ja nahamad an anun, ja hini chalaꞌ ja nahamad an ma-inum. ");
INSERT INTO ifu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hana meꞌ-an ay tay achor u ja miꞌ-inum ay tay chalaꞌ ja meꞌ-oh-ohha cha ay ha-in. Ja gawwachaaꞌ khu ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hi Ama an mamattakhu chi nannag ay ha-in, hijaot un gwa ay ha-in hini nahamad an piꞌtakhuwan. Amat khu hina hana mangan ay ha-in, an magwachaan cha hi nahamad an piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ti ha-in hini nahamad an anun an narpu ad langit, an achi amat chin khun anun hachi a-apo ju chin nahop. Ti hay hachi nangan ay chuy an anun, ja nun-a-atoy cha chamchama. Muti hana ayya meꞌ-an ay tay an anun, ja miꞌtakhu cha hi ma-id chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Inalin Hesus hay hato chin nuntudtuchugwana ay ni sinagoga ad Kapernaum. ");
INSERT INTO ifu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chengngor hachi disipolon Hesus hitay an intuchu na, ja cho-or chay nangali hi, “Mun-achamot kaykhu hay hato khuna ituchu ja ngachah chi mangngor?” ");
INSERT INTO ifu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Inannilan Hesus an khun cha mungngulungur ja inali na hi, “Un ayya angkhay hay hato inaliꞌ ja napukhit hi punnomnoman ju, ");
INSERT INTO ifu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ja ngay nomnomon ju nu tikhanaꞌ an Na-ilangitan an Takhu an mumpfangngad ad langit an narpugwaꞌ? ");
INSERT INTO ifu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hay alloꞌ ja hini mangchat ay ni nahamad an piꞌtakhuwan ja hini Espiritun Apo Jos an pfu-un hitay lamoh. Ja hana inaliꞌ ay chaꞌju ja narpu ay ni Espiritun Apo Jos, hotti hay hato chamchama chi mangchat hi piꞌtakhuwan. ");
INSERT INTO ifu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Muti gwachay uchumna ay chaꞌju chi achi mamati ay ha-in.” Inalin Hesus hitay ti napfajag an iniꞌ-ila na hana achi mamati ay hija ja hini oha an i mangngina ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ja entoloy Hesus an nangali hi, “Anilaꞌ an gway achi mamati ay chaꞌju. Hijaot un u inali hi ma-id chi hay oha hi mamati ay ha-in an khahin un ekhohkhohan Ama chicha.” ");
INSERT INTO ifu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chumalat hay hachi nun-ali na ja cho-or hachi ninitnud ay hija an nun-akak. ");
INSERT INTO ifu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ja inalin Hesus hachi himpolo ta chugwa an adalan hi, “Chaꞌju ngay, un ju chah podhon an me-ekak?” ");
INSERT INTO ifu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tempfar Simon Peter ja inali na hi, “Apo, ngay uchumna hi i mi unuchon? An un he-a ja angkhay chi mangtuchu ay ni aton an miꞌtakhu hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ja namati ami ay he-a ti inannila mi an he-a hini pinilin Apo Jos an nasantuwan.” ");
INSERT INTO ifu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ja inalin khu Hesus hi, “Aa, ti ha-in chi namili ay chaꞌju an himpolo ta chugwa an adalan u. Muti anong ja gwa han oha ay chaꞌju an amat ay Satanas hini nomnom na.” ");
INSERT INTO ifu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hay pitulungan tay an inalin Hesus ja hi Judas an empfalay Simon Iskariot. Ti anong un oha hija hay hachi himpolo ta chugwa an adalan, ja hija chi i mangngina ay Hesus ta patajon cha. ");
INSERT INTO ifu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Napfalin hay hato ja leneꞌgwoh Hesus ad Galilee. Ja agkhuy immuy ad Judea ti penhod hachi a-ap-apon chi Hudju an patajon hija. ");
INSERT INTO ifu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Gwa an machakngan chin pfehtan chi Hudju an Pangephochan cha hi A-ab-abpfong, ");
INSERT INTO ifu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ja inalin chin a-akhin Hesus an linala-e ay hija hi, “Ti un la-ahna ja tenaynam hitay an pfuglay ta miꞌjali a ad Judea ta piꞌtikhaw hana disipolom hichi hana milagro an khun mu aton. ");
INSERT INTO ifu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Hini takhu an mamhod an ma-ar-ali ja achi na iliꞌ-ud hana khuna aton. Gwacha ay he-a hini apfalinan an mangat hi milagro, hotti mumpa-innila a hana tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Inali cha hitay, ti anong un chicha an a-akhin Hesus ja agkhuy cha khu namati ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tempfar Hesus ja inali na hi, “Achiyaꞌ miꞌjali, ti agkhuy pay nachakngan hini neꞌcha an timpo an omajaꞌ. Manu ay chaꞌju ti timpo ju an amin chi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Achi chaꞌju pfuhulon hay hana tatakhu heto lota. Muti ha-in ayya, ja tan khunaꞌ pfuhulon, ti khun u ipa-innila an napukhit hana khun cha aton. ");
INSERT INTO ifu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chaꞌjuy umuy an i meꞌpfeha ti achiyaꞌ miꞌjali. Ti agkhuy pay nachakngan hini timpo an pangpa-innilaaꞌ ay ni omaꞌ-ataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Amat hetoy inali na, hotti nuntaynan ad Galilee. ");
INSERT INTO ifu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Unot immuy hachi a-akhi na an i meꞌpfehta, ja nangunud hi Hesus muti agkhuy numpatpatikhaw. ");
INSERT INTO ifu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hachi a-ap-apon chi Hudju ja khun cha hingiton hi Hesus ay chuy gwachaan chi pfehta, ja khun cha epfogpfokha hachi tatakhu nu ngay agawwachaana. ");
INSERT INTO ifu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Muti hachi tatakhu ja un cha khun i-am-amu an manaphapapit ay hija. Allon chi uchumna hi, “Maphod hija an takhu.” Ja allon khu chi uchumna hi, “Achi, ti un umallilaw hi tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Muti khun cha iliꞌliꞌ-ud an hapiton ta achi chonglon hachi a-ap-apon chi Hudju, ti toma-ot cha. ");
INSERT INTO ifu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gwa an nungkhinagwa chin pfehta ja immuy hi Hesus hichi Templo ja ente-a na an muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nanannor hachi a-ap-apon chi Hudju ja inali cha hi, “An ngay i nangalan tay ay ni la-eng na, an un agkhuy nun-ehkor?” ");
INSERT INTO ifu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ja inalin Hesus hi, “Hay hato khun u ituchu ja agkhuy narpu ay tay nomnom u, an un narpu an amin ay Apo Jos an nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hana mangapfulut an mangat ay ni penhod Apo Jos, ja achi cha munharhalinchugwa an hana khun u itudtuchu ja narpu ay Apo Jos, an agkhuy narpu ay tay nomnom u. ");
INSERT INTO ifu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ti nu hini takhu ja ikhad hija hon inali na hini gwa ay ni nomnom na, ja hay podhona ja hijay padayawon chi tatakhu. Muti ay ha-in ja achi amat heto. Ti hay podhoꞌ ja hi Apo Jos an nannag ay ha-in chi madaydayaw, ja hijah tay chi panginnilaan ju an umannung hana khun u itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Umannung an hi Moses chi nangpa-innila ay chaꞌju ay ni urchin Apo Jos. Muti ma-id oh-ohha ay chaꞌju hi khun mangunud ay ni allon ni urchin. Ti khulat ta khun ju aton hot ma-id i ju punnomnoman an mamatoy ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tempfar cha ja inali cha hi, “Un a kaykhu mun-angaw. Ti un chah gway nangali hi un chi-a patajon?” ");
INSERT INTO ifu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ja inalin khu Hesus hi, “Unagkhu angkhay chin nangakhahaꞌ hichin munchokhoh hi Hapfachu an ngilin, ja manotoꞌ-ong aju, ti panijagwon ju chi muntamu hi ngilin. ");
INSERT INTO ifu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Hot un chah pfu-un tamu hini pumpakugitan ju ay ni empfapfalay ju an linala-e, an anong un Hapfachu? In-urchin Moses an mahapor an ipakugit ju hana empfapfalay ju an linala-e ay ni me-agwalo an arkhaw. Muti pfu-un tatagwa hi Moses chi narpugwan tay ti nete-a chin timpon hachi nahnahhun an a-apo ju. Ja anong un metongor hi Hapfachu ja khun ju unuchon ta achi mapaꞌ-i hitay urchin Moses. Ja anagkha ta mapfungot aju ay ha-in chin nangakhahaꞌ hi munchokhoh hichin timpon chi ngilin? ");
INSERT INTO ifu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Achi koma atoꞌtogna hon hinugi ju hini takhu nu agkhuy ju menahmahan ta emamad ju hini umannung.” ");
INSERT INTO ifu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amat hichi ja inalin chin uchumna an tatakhu ad Jerusalem hi, “Un chah pfu-un hitay hini Hesus an podhon cha an patajon? ");
INSERT INTO ifu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Muti tayya an khun muntudtuchu hi achoꞌlan chi tatakhu ja ma-id hay ar-allon hachi a-ap-apo ta-o. Unchani ja un cha inannila an hija hini Hennag Apo Jos an Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Muti pfu-un nin, ti umali ayya hini Mamahhod ja ma-id oh-ohhah manginnila ay ni arpugwana, ja anila ta-o jaꞌ hini narpugwan tay an takhu.” ");
INSERT INTO ifu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Amat hichi ja ini-iꞌgwap Hesus an muntudtuchu hichi Templo ja inali na hi, “Mapfalin an anilaaꞌ ay chaꞌju ja anila ju hini narpugwaꞌ. Muti pfu-un ha-in chi nanghumang an immali heto lota, an gwacha hini nannag ay ha-in. Umannung an amin hini khuna allon muti agkhuy ju inannila hija. ");
INSERT INTO ifu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ha-in ja anilaꞌ hija, ti hijay narpugwaꞌ ja hijay nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Un chaot chengngor hay hato nun-alin Hesus ja penhod cha an tiligwon hija muti agkhuy na-at, ti agkhuy nachakngan chin eneꞌchan Apo Jos an timpo hi pangatan cha. ");
INSERT INTO ifu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cho-or chamchama hana tatakhu an namati ay hija. Ja khun cha allon hi, “Ti un chah gway umali khu hi choꞌchoꞌ-or chi atona an panginnilaan an narpu hini apfalinana ay Apo Jos? Hotti hija khuh niꞌ hini Hennag Apo Jos an Mamahhod.” ");
INSERT INTO ifu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chengngor chamchama hachi Farisee chin khun i-am-amun chin tatakhu an khun cha haphapiton hi Hesus. Hotti hay enat chin Farisee ja hachi a-ap-apon chi papachi, ja un cha hennag hachi khun munggwarja hichi Templo ta i cha tiligwon hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ja gwa an khun muntudtuchu hi Hesus ja inali na hi, “Achi mapfajag hitay piꞌhihittugwaꞌ ay chaꞌju hot mumpfangngachaꞌ ay ni agawwachaan nuy nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hotti hingitonaꞌ ay chaꞌju muti achiyaꞌ machakngan, ti achi mapfalin an miꞌjali aju ay ni ujaꞌ omajan.” ");
INSERT INTO ifu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nunhahapit khu chin a-ap-apon chi Hudju ja inali cha hi, “Ngay nin i na omajan ta achi ta-o machakngan? Un chah umuy hija hichi achawwi an pfuglay chi Griego an agawwachaan hana uchumna an i-ibpfa ta-o an Hudju ta hichi puntudtuchugwana ad ugwani? ");
INSERT INTO ifu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngay podhona an hapiton ay nuy inali na an, ‘Anong unaꞌ hingiton ja achiyaꞌ machakngan, ja achi mapfalin an miꞌjali aju ay ni ujaꞌ omajan?’ ” ");
INSERT INTO ifu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nachakngan chin angonoh an arkhaw chi pfehta an hijah tay hini am-amchan an pun-an-anlaan chi tatakhu. Ja timmaꞌchug hi Hesus ja khuna iꞌ-iꞌgwap an mangali hi, “An amin aju an ma-ugaw, ja umali aju ay ha-in an uminum. ");
INSERT INTO ifu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hijah tay hini nitulaꞌ an Hapit Apo Jos an omaꞌ-atan ni takhu an mamati ay ha-in, an allona hi, ‘Padchungnay gwa ay hija han opfob an khun pfumutajan ni chanum an mangchat hi nahamad an piꞌtakhuwan.’ ” ");
INSERT INTO ifu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hini hinapit Hesus ay tay ja hija hini Espiritu Santo an honakhon Apo Jos ta munheto hana namati. Ti ay chuy an timpo ja achi pay munheto hini Espiritu Santo hi tatakhu, ti agkhuy pay numpfangngad hi Hesus ad langit an mipapfagpfagto. ");
INSERT INTO ifu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hachi uchumna an nangngor ay tay inalin Hesus ja inali cha hi, “Umannung an hijah tay hini Profetan Apo Jos an hahadchon ta-o.” ");
INSERT INTO ifu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ja inalin chin uchumna hi, “Hijay Kristo an Hennag Apo Jos an Mamahhod.” Ja inalin khu chin uchumna hi, “Achi ti un chah ad Galilee chi arpugwan ni Mamahhod? ");
INSERT INTO ifu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Hay nitulaꞌ an Hapit Apo Jos an hini ayya Mamahhod ja holag Ari David, ja metoꞌkhong ad Betlehem an pfuglay an narpugwan Ari David.” ");
INSERT INTO ifu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Amat hichi ja na-aggwa hachi tatakhu, ti numpfino-ob-on chin nenomnom cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Podhon hachi uchumna an tiligwon muti ma-id hay nangat ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Amat hichi ja hachi khun munggwarja hichi Templo ja numpfangngad cha ay chuy gawwachaan hachi a-ap-apon chi papachi ja hachi Farisee an nannag ay chicha. Ja henanhanan cha hi, “Hot chaadma mah hi Hesus? Anagkha ta agkhuy ju tiniliw?” ");
INSERT INTO ifu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tempfar cha ja inali cha hi, “Agkhuy mi ay chita, ti ma-id chengchengngor mi hi amat ay ni panudtuchu na.” ");
INSERT INTO ifu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ja inalin hachi Farisee hi, “Ma-id ay chita an niya an anong un chaꞌju ja na-allilaw aju. ");
INSERT INTO ifu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Un chah hay anila ju ja chaꞌmi an a-ap-apo ja Farisee ja mamati ami ay hija? Ma-id mangkay oh-ohha ay chaꞌmi hi mamati. ");
INSERT INTO ifu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hana namati ay hija ja hana agkhuy nanginnila ay ni urchin ta-o, ja chichay dusaon Apo Jos!” ");
INSERT INTO ifu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gawwah chi hi Nicodemus an oha khu an Farisee. Hitay an hi Nicodemus ja hija chin i niꞌhapit ay Hesus chin ohan lapfi. Inali na hachi numpun-ibpfa na hi, ");
INSERT INTO ifu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ay ni urchin ta-o, ja achi mapfalin an hugijon hini takhu nu agkhuy pay nahumarja. Mahapor an humarjaon ta chonglon hay allona ta mapfu-ihan nu gway enat na an napukhit.” ");
INSERT INTO ifu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ja inali cha hi, “Anagkha, un a chah eGalilee? Muti ep-ephod mu akay niꞌ an pfahaon hini Hapit Apo Jos hot annilaom an ma-id allona hi gway profetan Apo Jos an marpu ad Galilee.” ");
INSERT INTO ifu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","muti hi Hesus ja immuy hichi pfulludna an Olibo. ");
INSERT INTO ifu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chin nun-inggwiꞌgwiit ja pfimmugwah hija an numpfangngad hichi Templo. Na-amung khu chin tatakhu ja lini-ub cha hija. Amat hichi ja inumpfun hi Hesus ja ente-a na an muntudtuchu. ");
INSERT INTO ifu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gwa an khun muntudtuchu ja immali hachi memehtolon chi urchin Moses ja hachi Farisee. Ini-itnud cha han pfupfai an inah-upan cha an ne-eloꞌ han lala-e an pfu-un ahagwa na. Impataꞌchug cha hichuy pfupfai ay chuy achoꞌlan chi tatakhu, ");
INSERT INTO ifu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ja inali cha ay Hesus hi, “Apo, hitay an pfupfai ja inah-upan cha an ne-eloꞌ han lala-e an pfu-un ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ja allon ni urchin Moses, an hini pfupfai an amat heto ja pumpfu-or ingkhana hi matoy. Hotti ngay allom?” ");
INSERT INTO ifu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inali cha hitay ta topngan cha hi Hesus ta mehalla ayya hini pampfar na hot hijay panghiꞌ-ingan cha an pangchaloman ay hija. Muti agkhuy tenompfar hi Hesus, ja nunjakhotto ja enerchong na chin lodlochong na an muntulaꞌ ay chuy lota. ");
INSERT INTO ifu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Entoloy cha an munhanhan ay hija ja lemmeggwat ja inali na hi, “Hay alloꞌ ja hini ma-id pfahor na ay chaꞌju chi mahhun an mam-or ay tay pfupfai.” ");
INSERT INTO ifu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Amat hichi ja nunjakhotto khu an nangtoloy an nuntulaꞌ ay chuy lota. ");
INSERT INTO ifu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Un chaagkhu chengngor hichuy inali na, ja un ohanna hon nakak, an impangpangulun hachi menaꞌma-ellog. Ja un angkhay hi Hesus chi nataynan ja chin pfupfai an timmataꞌchug. ");
INSERT INTO ifu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lemmeggwat hi Hesus ja inali na ay chuy pfupfai hi, “Chaad cha mah? Un chah ma-id chi hay oh-ohhah nuntaynan ta gway mam-or ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tempfar chuy pfupfai ja inali na hi, “Ma-id, Apo.” Ja inalin Hesus hi, “Anong un ha-in, ja achiꞌ hugijon he-a an matoy. Hotti umanamut a, ja achim ipigpiggwa an pfumahor.” ");
INSERT INTO ifu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Entoloy Hesus an nangtudtuchugwan hachi tatakhu ja inali na hi, “Ha-in chi hilaw an manenakhan hana nomnom chi tatakhu heto lota. Hana mangunud ay ha-in ja achi cha chumalan hi munhehellong, ti mahenakhan cha ay tay an hilaw an mangchat hi nahamad hi piꞌtakhuwan.” ");
INSERT INTO ifu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hachi Farisee an ne-eꞌ-egngor ja inali cha hi, “Un he-a hon tinihtikhuwam hini achor mu. Ngay machotoꞌ nu umannung hini khun mu allon?” ");
INSERT INTO ifu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tempfar Hesus ja inali na hi, “Anong un ha-in chi manihtikhuwan ay tay achor u, ja umannung chamchama hini panihtikhuꞌ, ti anilaꞌ hini narpugwaꞌ ja hini omajaꞌ. Chaꞌju ayya ja agkhuy ju anila. ");
INSERT INTO ifu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Achi magpong hini aton ju an munhugi ti un khun marpu ay chaꞌju an tatakhu. Ha-in ayya ja ma-id chi hay oha hi ijaꞌ hugijon. ");
INSERT INTO ifu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Muti khulat ta ha-in chi munhugi ja magpong, ti achiyaꞌ omo-ohha, an gwacha hi Ama an nannag ay ha-in an miꞌhugi. ");
INSERT INTO ifu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja allon ni urchin ju an mahapor an pattiyon hini numpadchung an allon chi hay chugwa hi muntihtikhu. ");
INSERT INTO ifu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ohaaꞌ an manihtikhuwan ay tay achor u, ja me-aggwa hi Ama an nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ja empfokha cha hi, “Hot chaad mah hi amam?” Tempfar Hesus ja inali na hi, “Nu inannilaaꞌ koma ay chaꞌju hot inannila ju khu hi Ama. Muti agkhujaꞌ anila, hijaot un ma-id khu anila ju ay Ama.” ");
INSERT INTO ifu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chin khun puntudtuchugwan Hesus an amin hay hato ja hichi Templo ay chuy negpongan chuy khun cha pangittugwan hi pihu. Muti ma-id chi hay i naniliw ay hija ti agkhuy pay nachakngan chin timpo an eneꞌchan Apo Jos an atajana. ");
INSERT INTO ifu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Entoloy Hesus an nunhapit ja inali na hi, “Umali han arkhaw ja taynaꞌ chaꞌju ja hingitonaꞌ, muti matoy aju an agkhuy napakawan hana pfahor ju. Achi mapfalin an miꞌjali aju ay ni omajaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chengngor hachi a-ap-apon chi Hudju ja khun cha munhahapit an mangali hi, “Anagkha nin ta allona hi, ‘Achi mapfalin an miꞌjali aju ay ni omajaꞌ?’ Una chah patajon hichuy achor na?” ");
INSERT INTO ifu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Inalin khu Hesus hi, “Chaꞌju ja narpu aju ay tay lota. Muti ha-in ja narpuwaꞌ ad langit. ");
INSERT INTO ifu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hijaot un u inali hi matoy aju an agkhuy napakawan hana pfahor ju, ti umannung an ma-at nu achi ju pattiyon chin inaliꞌ ay chaꞌju an omaꞌ-ataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ja inali cha hi, “Hot ngay omaꞌ-atam mah?” Tempfar Hesus ja inali na hi, “Hini omaꞌ-ataꞌ ja hija chin khun u allo-allon nete-a chin pengpenghana. ");
INSERT INTO ifu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cho-or hana mapfalin an alloꞌ ja cho-or koma hana ipapfahor u ay chaꞌju. Muti hay pachot-anaꞌ otniꞌ hi ipa-innilaꞌ ja hana chengngor u ay nuy nannag ay ha-in, ti umannung an amin hana khuna allon.” ");
INSERT INTO ifu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hachi nunchongor ay Hesus ja agkhuy cha na-awatan an hi Jos Ama chi khuna hapiton. ");
INSERT INTO ifu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hotti entoloy Hesus an nangali hi, “Nu makhibpfoh an ipfitinaꞌ an Na-ilangitan an Takhu, hot annilaon ju an umannung hini alloꞌ an omaꞌ-ataꞌ. Ja annilaon ju an achiyaꞌ umi-igway hon empadchong u chi hay atoꞌ. Hay intuchun Ama ay ha-in chi hapitoꞌ ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja gawwacha ay ha-in hini nannag ay ha-in an achiyaꞌ taytaynan, ti khun u aton an amin hini podhona.” ");
INSERT INTO ifu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja ay cha chuy an nunchongor ja cho-or chay namati ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Amat hichi ja inalin Hesus hachi Hudju an namati ay hija hi, “Nu epa-ennongan ju an mangat ay ni ituchuꞌ hot chaꞌjuy ma-ali hi disipoloꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Annilaon ju hana umannung, hot mipfu-aan aju ta achi aju mahpay himpfut.” ");
INSERT INTO ifu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Inalin hachi Hudju hi, “Holag chaꞌmi mangkay ay Abraham ja ma-id chi hay namenghan hi i mi numpfalinan hi himpfut. Ja anagkha ta allom hi un ami mipfu-aan?” ");
INSERT INTO ifu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tempfar Hesus ja inali na hi, “Umannung hitay alloꞌ, an hini khun pfumahor ja himpfut chi pfahor. ");
INSERT INTO ifu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hini himpfut ja un neneꞌ-op ay ni apo na, ja gway arkhaw hot pakakon wenno ingina na. Achi amat ay ni oha an unga ay ni pamilya na an achi ma-aan. ");
INSERT INTO ifu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hotti nu ha-in an Empfalay Apo Jos chi mangpfu-aan ay chaꞌju ja umannung an mipfu-aan aju. ");
INSERT INTO ifu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Anilaꞌ an hi Abraham chi nangholag ay chaꞌju muti achi aju amat ay hija. Ti niya an achi ju apfuluton hini itudtuchuꞌ, hijaot un aju munnomnom an mamatoy ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hato khun u hapiton ja hana impatikhaw Ama ay ha-in. Amat hina khu ay chaꞌju an hini khun ju aton ja hini intuchun ni ammod ju.” ");
INSERT INTO ifu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ja inali cha hi, “Aa, muti hi Abraham chi ammod mi.” Ja inalin Hesus hi, “Nu umannung an holag chaꞌju ay Abraham, ja anagkha ta achi ju unuchon hana ena-enat na an maphod, ");
INSERT INTO ifu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","an hay khun ju nomnomnomon ja hay aton ju an mamatoy ay ha-in an nangtuchu ay chaꞌju hana umannung an chengngor u ay Apo Jos. Ma-id ay chita amat heto hi enat Abraham. ");
INSERT INTO ifu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hini ammod ju hini inunud ju.” Ja inali cha hi, “Pfu-un chaꞌmi chi ne-akhah an ma-id anila mi hi ammod mi. Hi Apo Jos chi ama mi an khun mi unuchon ja ma-id uchumna.” ");
INSERT INTO ifu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ja inalin Hesus hi, “Nu umannung an hi Apo Jos chi ama ju hot podhonaꞌ koma, ti narpuwaꞌ ay hija ja unaꞌ umali heto lota. Pfu-un ha-in chi nanghumang hi immali heto lota an hi Ama chi nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Achi ju ma-awatan hana khun u allon ti un tugwali ma-id eke-ekejana hi pangngolan ju hana khun u ituchu. ");
INSERT INTO ifu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amat aju ay ni ammod ju an hi Satanas ja podhon ju an unuchon hini penhod na. Hija ja pemmatopatoy nete-a chin hophopapna. Ipapaꞌ-igwina an amin chi umannung ti ma-id oh-ohha hi magpong hi ugali na. Lomahlalahlah ti hijay emmengha hi ugali na ja hijay arpugwan an amin chi lahlah. ");
INSERT INTO ifu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Muti ha-in, khapo ta umannung hana khun u allon, ja achiyaꞌ pattiyon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nomnomon ju man nu ngachah chi hay epapfahor ju ay ha-in. Ma-id khuh niꞌ. Ti umannung an amin chi alloꞌ ja anagkha ta achiyaꞌ pattiyon? ");
INSERT INTO ifu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hana tatakhun Apo Jos ja chonglon cha hini tukhuna. Achi ju khun unuchon hi Apo Jos ti pfu-un chaꞌjuy tatakhu na.” ");
INSERT INTO ifu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Inalin khu hachi Hudju hi, “Umannung man chin inali mi an Samaritan a an nahuhuꞌlungan hi napukhit an ispiritu.” ");
INSERT INTO ifu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ja inalin Hesus hi, “Achi ju allon hi unaꞌ nahuhuꞌlungan, ti un u khun padayawon hi Ama, muti niya an unaꞌ chochohhon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ja achiꞌ allon hitay khapo ta podhoꞌ an madaydayaw, ti hi Ama chi mangdaydayaw ay ha-in ja hijay manugi hana mamipihhor ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Umannung hitay alloꞌ, hini mangunud ay ni ituchuꞌ ja achi matmatoy.” ");
INSERT INTO ifu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ja inalin hachi Hudju hi, “Umannung an un a nahuhuꞌlungan. Ti nun-a-atoy cha Abraham ja chin profetan Apo Jos, ja anagkha ta allom hi achi matmatoy hana mangunud ay ni ituchum? ");
INSERT INTO ifu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Un a chah napfagpfagto mu hi Abraham an apo ta-o ja hachi profeta an nun-a-atoy? Akamoh kaykhu hini atom ay ni achor mu.” ");
INSERT INTO ifu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ja inalin khu Hesus hi, “Nu ha-in chi mangpapfagto ay tay achor u ja ma-id herpfi na. Gwa han mangdaydayaw ay ha-in, hija hi Ama an allon ju an Apo Jos ju. ");
INSERT INTO ifu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Muti munlahlah aju ti agkhuy ju inannila hija. Ha-in ja anilaꞌ hija. Nu alloꞌ hi ma-id anilaꞌ ay hija hot omataꞌ ay chaꞌju an munlahlah. Ti umannung an anilaꞌ hija ja khun u unuchon hini allona. ");
INSERT INTO ifu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hi Abraham an apo ju ja khun mun-an-anla chin atattakhu na ti anila na an tikhana hini arkhaw an umaliyaꞌ. Tinnig na ja nunnaꞌnaud chin anla na.” ");
INSERT INTO ifu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ja inalin hachi Hudju hi, “Unagkhu ma-id pay lemay polo hi tagwon mu, ja inalim agkhu hi un mu tinnig hi Abraham?” ");
INSERT INTO ifu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tempfar Hesus ja inali na hi, “Umannung hitay alloꞌ. Agkhuy pay netoꞌkhong hi Abraham ja gawwachaaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Un chaagkhu chengngor hitay an inali na ja numpichit cha hachi pfato ta ipuhit cha ay hija. Muti khun mihalin hachi tatakhu ja pfimmutay hichi Templo ja tenaynana chicha. ");
INSERT INTO ifu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hi khun chumalanan cha Hesus ja inah-upan cha han lala-e an napfulaw nete-a hichin nituꞌkhungana. ");
INSERT INTO ifu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ja inalin hachi disipolo na hi, “Rabbi, ngay nangpfahor ta netoꞌkhong hitay lala-e an napfupfulaw? Unchah hija wenno hana ammod na?” ");
INSERT INTO ifu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tempfar Hesus ja inali na hi, “Pfu-un hay pfahor nay chimmalat hi napfulagwana ja pfu-un khu hay pfahor hana a-ammod na. Hay umannung hi khapo na ja penhod Apo Jos an mangpatikhaw ay ni apfalinana hi pangpatenongana ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mahapor an aton ta-o hana ipatamun Apo Jos an nannag ay ha-in. Achi ta-o i-un-unchani, ti umali hini timpo an ma-id aton ta-o an mangat. Amat hana i muntamu an muntamu cha hi a-arkhagwan, ti nadhom ayya ja ma-id i muntamu. ");
INSERT INTO ifu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ay tay agawwachaaꞌ ay chaꞌju ja ha-in hini hilaw an manenakhan hana nomnom chi tatakhu ay tay lota.” ");
INSERT INTO ifu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Napfalin an inalin Hesus hitay ja tinuppaana chin lota ja pinilot na ta numpfalin hi pitoꞌ. Enala na, ja in-apjut na chin matan chuy napfulaw. ");
INSERT INTO ifu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ja inali na hi, “Umuy a ta i a mun-ihu hichi pohong ad Siloam.” Hitay ngachan an Siloam ja Nahnag hini podhona an hapiton. Hotti immuy nun-ihu chin lala-e ja immanamut an mitikhaw mahpay chin mata na. ");
INSERT INTO ifu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Unagkhu tinnig hachi hahakhokhong na ja hachi uchumna an khun mannig ay hija an un omanad-adchaw, ja inali cha hi, “Un chah pfu-un hitay chin napfulaw an u-umpfun an khun mun-ad-adchaw?” ");
INSERT INTO ifu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Inalin hachi uchumna hi, “Hija.” Ja inalin hachi uchumna hi, “Pfu-un ay chita, an un meꞌmeꞌnong ay hija.” Muti inalin chin lala-e hi, “Ha-in chin napfulaw.” ");
INSERT INTO ifu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ja inali cha hi, “Ngay enat mu ta mitikhaw hini matam ad ugwani?” ");
INSERT INTO ifu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tempfar na ja inali na hi, “Hinuy allon cha an hi Hesus, ja in-apjut na han pitoꞌ ay tay mataꞌ, ja unaot allon hi unaꞌ umuy mun-ihu hichi pohong ad Siloam. Inunud u ja immujaꞌ nun-ihu ja tayya an mitikhaw hitay mataꞌ ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ja inali cha hi, “Hotti chaad mah hini allom an hi Hesus?” Tempfar na ja inali na hi, “Ma-id machotoꞌ hi agawwachaana.” ");
INSERT INTO ifu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Amat hichi ja in-uy cha chin lala-e hachi Farisee ta i cha epfaag an enakhahan Hesus hija. ");
INSERT INTO ifu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hapfachu an ngilin chin nang-apjutan Hesus chin pitoꞌ hi nangakhahana chin napfulaw. ");
INSERT INTO ifu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Empfokhan hachi Farisee ay hija hi, “Ngay enat mu ta mitikhaw hini matam ad ugwani?” Ja inali na hi, “Ti amat heto an in-apjut na han pitoꞌ ay tay mataꞌ ja immujaꞌ nun-ihu. Napfalin ja mitikhaw mahpay hitay mataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ja khun munhahapit hachi Farisee ja inalin chin uchumna hi, “Hini nangat ay tay ja pfu-un hi Apo Jos chi nannag ay hija, ti achi na khun unuchon hini urchin Apo Jos an ma-id muntamu hi ngilin.” Ja inalin hachi uchumna hi, “Un chah gway apfalinan chi napfahulan an mangat hi amat heto an milagro?” Na-aggwa cha, ");
INSERT INTO ifu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","hijaot un cha impiggwa an pa-ahhanhanan ay chuy lala-e ja inali cha hi, “He-a an mangali hi una enakhahan hini matam, ngay allom hi omaꞌ-atana?” Tempfar na ja inali na hi, “Hay anilaꞌ ay hija ja profetan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hachi ayya a-ap-apon chi Hudju ja achi cha mamati an napfupfulaw hija ja unot mitikhaw hini mata na. Khahin un cha empa-ajag hachi ammod na ");
INSERT INTO ifu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ja empfokha cha hi, “Umannung chah an hitay hini empfalay ju an allon ju an netoꞌkhong ja un tugwali napfupfulaw? Nu napfulaw ja anagkha ta mitikhaw hana mata na ad ugwani?” ");
INSERT INTO ifu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tempfar hachi ammod na ja inali cha hi, “Aa, hijah tay hini empfalay mi ja umannung an netoꞌkhong an napfulaw. ");
INSERT INTO ifu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Muti ma-id anila mi ay ni enat na an na-akhahan. Ja agkhuy mi khu anila hini nangakhahan ay hija. Ma-ilog, hotti hijay panghanhanan ju, ti anila nay pampfar na.” ");
INSERT INTO ifu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Amat hinay enat cha an nampfar ti toma-ot cha hachi a-ap-apon chi Hudju. Ti nunhahappitanan hachi a-ap-apo an hini takhu an manihtikhuwan an hi Hesus hini Mamahhod, ja aanun cha ay ni sinagoga ta achi mimidchum hana papadchung na an Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hijaot un cha inali hi, “Ma-ilog, hotti hijay panghanhanan ju.” ");
INSERT INTO ifu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hotti empa-ajag khu hachi Farisee chin lala-e ja inali cha hi, “Munhapata a ay Apo Jos ta epfaag mu hini umannung! Ti anila mi an napfahulan an takhu hinuy an nangakhahan ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ja inalin chin lala-e hi, “Ma-id niꞌ maptoꞌ hi un napfahulan wenno agkhuy. Ti un hay anilaꞌ ja unaꞌ napfulaw ja tan ad ugwani ja mitikhaw hitay mataꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ja inali cha hi, “Muti ngay enat na ta mitikhaw hana matam?” ");
INSERT INTO ifu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tempfar na ja inali na hi, “Un aju humupar! Chun u inali ay chaꞌju ad anachi muti nan un ju achi chonglon. Ja anagkha ta ejarkhaw ju an epfokha. Unchani ja un ju podhon an mumpfalin hi disipolo na.” ");
INSERT INTO ifu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Un chaagkhu chengngor hitay an inali na ja pinahiw cha hija ja inali cha hi, “Un kaykhu he-a hini disipolo na. Ti chaꞌmi ayya ja hi Moses chi khun mi unuchon. ");
INSERT INTO ifu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ti anila mi an niꞌhapit hi Apo Jos ay Moses. Muti hinuy an takhu ja ma-id pay anila mi hi narpugwana!” ");
INSERT INTO ifu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ja inalin chin lala-e hi, “Haw chaꞌju pay hina, an enakhahana hitay mataꞌ ti gway apfalinana, ja agkhuy ju pay anila hini narpugwana. ");
INSERT INTO ifu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Un chah hongpfatan Apo Jos chi kalalag hana napfahulan an tatakhu? Achi, ti anila ta-o an hana khun mundayaw ay hija an khun cha unuchon hini allona, ja chichay mahongpfatan chi kalalag na. ");
INSERT INTO ifu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nete-a chin narmugwan tay lota ja ma-id chengchengngor ta-o hi takhu hi nangakhahan hana netoꞌkhong an napfulaw ta tumikhaw cha. ");
INSERT INTO ifu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Achi mapfalin an aton tay an takhu chi amat heto nu pfu-un hi Apo Jos chi nannag ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ja inalin khu hachi Farisee hi, “He-a agkhu niꞌ an napfahulan nete-a chin nituꞌkhungam ja un chah he-ay mangtuchugwan ay chaꞌmi?” Amat hichi ja penakak cha hija. ");
INSERT INTO ifu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chengngor Hesus an penakak chin Farisee chin lala-e an enakhahana, ja i na hiningit. Chinakngana ja inali na hi, “Mamati a chah ay ni Na-ilangitan an Takhu?” ");
INSERT INTO ifu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tempfar na ja inali na hi, “Hotti ngay ngachana mah, Apo, ta pattiyoꞌ?” ");
INSERT INTO ifu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Inalin Hesus hi, “Tinnig mu mahpay, ti khun miꞌhapit ay he-a ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ja inalin khu chin lala-e hi, “Apo, mamatiyaꞌ ay he-a!” Ja nunheppe an nundayaw ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ja inalin Hesus hi, “Immaliyaꞌ heto lota ta ma-innila hana nanginnila ay Apo Jos ja hana agkhuy nanginnila ay hija. Hana ayya agkhuy nanginnila ay Apo Jos ja mipadchung cha hi napfulaw, ja aanuꞌ hini pfinulaw cha ta tumikhaw cha. Ja hana mangali hi anila cha hi Apo Jos muti un cha munlahlah, ja ipatikhaw u an napfulaw cha.” ");
INSERT INTO ifu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chengngor hachi uchumna an Farisee an gwa an niꞌtataꞌchug ja inali cha hi, “Un chah hay allom ja napfulaw ami khu?” ");
INSERT INTO ifu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tempfar Hesus ja inali na hi, “Nu khulat ta apfuluton ju an napfulaw aju hot mapfalin an mapakawan hana pfahor ju. Muti nan ipapilit ju an agkhuy aju napfulaw ti anila ju hi Apo Jos, ja hihiya an achi mapakawan hana pfahor ju.” ");
INSERT INTO ifu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Inalin khu Hesus hi, “Umannung hitay alloꞌ ay chaꞌju. Nu khulat ta gway kular chi karnero, ja hini takhu an manggwa ay ni pantaw, ja hija hini umannung an khun mumpahtor. Hini ayya omajat an manggwa ay nuy alad ja un mangakaw wenno pomatoy. ");
INSERT INTO ifu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hini khun mumpfantay an gwa ay ni pantaw ni kular ja ipahikhop na hini khun mumpahtor ja angkhay. Ja imatunan hana karnero hini hapit na ja oha-ohaona an ajakhan chicha ta mitnud cha an miꞌpfutay. ");
INSERT INTO ifu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Napfalin an impfutay na an amin hana karnero ja impangpangullu na. Mangunud hana karnero ti imatunan cha hini hapit na. ");
INSERT INTO ifu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Achi cha unuchon hini agkhuy cha anila, an un chaot lomajaw, ti achi cha imatunan hini hapit na.” ");
INSERT INTO ifu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Inalin Hesus hitay pangngarig ja agkhuy cha na-awatan hini podhona an hapiton. ");
INSERT INTO ifu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hotti inalin khu Hesus hi, “Umannung hitay alloꞌ ay chaꞌju. Ha-in hini pantaw ni kular chi karnero, an hijay agwun an humikhop. ");
INSERT INTO ifu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","An amin hana uchumna an nahhun mu ha-in an immali, ja chicha hana mangakaw ja mamatoy hana karnero. Muti achi chonglon hana karnero chicha. ");
INSERT INTO ifu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ha-in hini pantaw an agwun cha. Hana humikhop ay tay an pantaw ja takhuwoꞌ chicha. Halimunaꞌ chicha an amat ay ni khun mumpahtor an halimunana hana karnero hi pfumutajan cha hi icha anganan ingkhana hi humigpan cha. ");
INSERT INTO ifu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hini omakaw, ja ma-id uchumna hi nomnomona nu pfu-un hini atona an i omakaw, pomatoy ja pumaꞌ-i. Ha-in ayya ja immaliyaꞌ ta hana tatakhu an ipadchung u hi karneroꞌ ja miꞌtakhu cha hi nahamad an ma-id chi pogpog na. ");
INSERT INTO ifu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ha-in hini maphod an khun mumpahtor. Ti nehahagkhanaaꞌ an matoy khapo ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hini ayya khun mapfajachan an mumpahtor ja taynana hana karnero nu gway umali hi khenger. Taynana ti pfu-un hijay nangheꞌ-a. Hot pun-alat ni khenger hana karnero ja nun-apfur cha ja nun-ahijaꞌ cha. ");
INSERT INTO ifu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Taynan nuy khun mumpfantay ti un hini pfinoꞌla na chi podhona ja angkhay, ja achi na ihi-ar hana karnero. ");
INSERT INTO ifu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ha-in hini maphod an khun mumpahtor. Anilaaꞌ ay Ama ja anilaꞌ khu hija. Amat hina khu an anilaꞌ hana karneroꞌ ja anilaaꞌ ay chicha. Halimunaꞌ chicha, ja nehahagkhanaaꞌ an matoy khapo ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Gwacha hana uchumna an karneroꞌ an agkhuy pay niꞌhikhop ay tay an kular. Mahapor an piꞌpahikhop u chicha. Me-egngor cha ay ni hapit u ja meꞌ-oh-ohha cha hay hana nahhun an na-ajakhan. Ja ohaaꞌ an khun mumpahtor ay chichan amin. ");
INSERT INTO ifu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Podpodhonaꞌ ay Ama, ti apfulutoꞌ chi atajaꞌ ta gway atoꞌ an mummahu. ");
INSERT INTO ifu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma-id mangpagpong hi atajaꞌ, an ha-in chi nangapfulut hi atajaꞌ. Ti gwa ay ha-in an mangpagpong ay ni atajaꞌ ja gwa khu ay ha-in hini apfalinan ta mummahuwaꞌ. Hitay hini inalin Ama hi atoꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chimmalat chin inalin Hesus ja na-a-aggwa khu chin Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cho-or cha an nangali hi, “Un mangkay ay chita mun-angaw hitay an takhu ti nahuhuꞌlungan! Anagkha ta i ta-o chodchonglon hija?” ");
INSERT INTO ifu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Muti allon chin uchumna hi, “Nu allon ju hi nahuhuꞌlungan, ja un chah amat hinay panaphapit na? Ja un chah olog khu chi napukhit an ispiritu an mangakhahan hi napfulaw ta tumikhaw?” ");
INSERT INTO ifu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nachakngan chin pfehtan chi Hudju an pangnomnoman cha chin arkhaw an Nidatunan chin Templo ad Jerusalem. Ja netongor an ahitungnin. ");
INSERT INTO ifu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gawwacha hi Hesus hichi Templo an khun chumalan ay chuy Pfarkon Ari Solomon. ");
INSERT INTO ifu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na-amung hachi Hudju ja lini-ub cha hija ja inali cha hi, “Epfaag mu gwot hini ohto, ti tan ma-id maptoꞌ hi i mi punnomnoman. He-a chah hini Hennag Apo Jos an Mamahhod wenno pfu-un?” ");
INSERT INTO ifu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tempfar Hesus ja inali na hi, “Ina-alliꞌ ay chaꞌju muti achiyaꞌ chamchama pattiyon. Hi Ama chi nangchat ay ni apfalinaꞌ ta ma-at hay hana khun u aton, ja hay hato chi panginnilaan ju nu ngay omaꞌ-ataꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Muti tan achiyaꞌ chamchama pattiyon ti pfu-un chaꞌju hini karneroꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hay ipfilang u hi karneroꞌ ja hana mangkhongahan ay ni alloꞌ. Anilaꞌ chicha ja unuchonaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ichat u ay chicha hini nahamad an piꞌtakhuwan an ma-id chi pogpogna, hot achi cha ma-utaw, ja ma-id chi hay oha hi gway apfalinana an mamloh ay chicha ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ti hi Ama chi napfagpfagto an amin ja hijay nangchat ay chicha ay ha-in. Ja ma-id olog chi uchumna an mamloh ay chicha ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ti ha-in ja hi Jos Ama ja un ami oh-ohha.” ");
INSERT INTO ifu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chengngor hachi Hudju hichuy an inali na ja pimmichit cha khu hi pfato ta ipuhit cha ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Inalin Hesus ay chicha hi, “Cho-or chi maphod hi enat u hi inalin Ama hi atoꞌ ja tinnig ju. Ngachah ay cha tay enat u chi i ju panghiꞌ-ingan hi pangajangan ay ha-in?” ");
INSERT INTO ifu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tempfar hachi Hudju ja inali cha hi, “Pfu-un hay maphod hi enat mu chi pangajangan mi ay he-a muti hini pangpadchungam ay ni achor mu ay Apo Jos. Un ta-o numpapadchung an tatakhu ja un chah achi mipfuhur hitay ay Apo Jos?” ");
INSERT INTO ifu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ja inalin Hesus hi, “Un ju chah nalichuwan chin nitulaꞌ an Hapit Apo Jos hi nangarjana hachi a-apo ta-o an Hudju chin hophopapna hi, ‘Inaliꞌ hi, amat aju hi jos.’ ");
INSERT INTO ifu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hotti hachi tatakhu an enajakhan Apo Jos an i mangpa-innila ay ni Hapit na, ja ma-ali cha hi jos. Mapfaha hitay ay ni Hapit Apo Jos ja achi ma-ub-upfah. ");
INSERT INTO ifu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hotti un chah achi om-omod ay ha-in an inumlaan Apo Jos ja hennakhaꞌ an immali heto lota? Anagkha ta allon ju hi un mipfuhur ay Apo Jos hini pangpfaakhaꞌ an ha-in hini Empfalay na? ");
INSERT INTO ifu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu achiꞌ aton hini khun aton Ama hot mapfalin an achiyaꞌ pattiyon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Muti tayya an khun u unuchon hi Ama. Hotti hay hato khun u aton chi pattiyon ju nu achi ju pattiyon hana khun u allon. Hot annilaon ju an gawwacha hi Apo Jos ay ha-in jagawwachaaꞌ khu ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chengngor hachi Hudju hitay an inali na ja henlenom cha khu an maniliw ay hija muti nun-irpfut na ja tenaynana chicha. ");
INSERT INTO ifu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Amat hichi ja pfimmad-ang hi Hesus chin gwanggwang an Jordan ta numpfangngad chin khun pumbautisaran John Bautista hachi tatakhu. Ja nihihidchi hija. ");
INSERT INTO ifu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cho-or chin tatakhu an immuy ay Hesus ja inali cha hi, “Ma-id en-enat John hi milagro muti umannung an amin hini impa-innila na an omaꞌ-atan tay an takhu.” ");
INSERT INTO ifu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja cho-or chin tatakhu hichi an namati ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Gwacha han tolo an hin-a-agkhi ad Betani an cha Lazarus ja hi Mary ja hi Marta. Hitay an hi Mary ja hija chi nanghiit chin mumpfango an lanob chin hu-in Apo Hesus, ja pinuꞌnahana ay chuy pfuuꞌ na. Ja hi Lazarus ja khun munchokhoh ");
INSERT INTO ifu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","hotti empepaad chin a-akhi na an pfinapfai hi Hesus, ta allon cha an hini khayyum na an penpenhod na ja khun munchokhoh. ");
INSERT INTO ifu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chengngor Hesus hitay ja inali na hi, “Hinuy chokhoh Lazarus ja pfu-un hijay atajana, muti hinuy an nunchoghana ja ta gway aton Apo Jos an madayaw, ja gway atoꞌ khu an Empfalay na an madayaw.” ");
INSERT INTO ifu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Penpenhod Hesus cha Marta ay Mary ja hi Lazarus. ");
INSERT INTO ifu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Muti anong una inannila an khun munchokhoh hi Lazarus ja una khinulat an entaktak hi chugwah arkhaw, ");
INSERT INTO ifu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ja unaot allon hachi disipolo na hi, “Mumpfangngad ta-o ad Judea.” ");
INSERT INTO ifu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ja inali cha hi, “Rabbi, agkhuy napfajag chin nakakan ta-o hi pamhochan hachi Hudju hi pangajangan chi-a. Ja anagkha ta i ta-o khu mumpfangngad hichi?” ");
INSERT INTO ifu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ja inalin gwot Hesus hi, “Himpolo ta chugwah oras hini a-arkhagwan, ja hini chumalan hi a-arkhagwan ja achi mahalipadchung, ti gwa hini hilaw ay tay lota an manilagwan ay ni agwuna. ");
INSERT INTO ifu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Muti hini takhu an chumalan hi lapfi ja mahalipadchung, ti ma-id ay hija hini hilaw.” ");
INSERT INTO ifu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ja entoloy Hesus an nangali hi, “Hi akhi ta-o an hi Lazarus ja nanalloꞌ, muti umujaꞌ ta ujaꞌ pfangunon.” ");
INSERT INTO ifu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ja inalin chin disipolo na hi, “Maphod, Apo, ta nanalloꞌ ta gway atona an tomenong.” ");
INSERT INTO ifu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Inali cha hinuy ti khemhon cha un ohto an nanalloꞌ muti hay penhod Hesus hi allon ja natoy hi Lazarus. ");
INSERT INTO ifu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hotti immohag na an nangali ay chicha hi, “Natoy hi Lazarus, ");
INSERT INTO ifu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","muti khapo ay chaꞌju ja mun-an-anlaaꞌ ta mama-ichaꞌ hi natajana ta gway aton ju an mamati nu tikhan ju hay atoꞌ. Hotti umuy ta-o hichi pfalay cha.” ");
INSERT INTO ifu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ja hi Tomas, an nangadnan hi Nun-eper, ja inali na hachi padchung na an disipolo hi, “Ti miꞌjuy ta-o mangkay ad Judea ta patajon cha ayya hi Hesus ja anong kay ja ne-etoy ta-o ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Emmatam cha Hesus ad Betani ja inannila cha an nalahin chi apat hi arkhaw hi nilub-an Lazarus. ");
INSERT INTO ifu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hitay an Betani ja toloh kilomitlu chi inachawwi na ad Jerusalem, ");
INSERT INTO ifu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ja cho-or chin Hudju an immuꞌ-uy ta i cha egwangar cha Marta ay Mary khapo ta natoy chin akhi cha an hi Lazarus. ");
INSERT INTO ifu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Unagkhu inannilan Marta an khun umali hi Hesus ja immuy ta i na chinittum. Ja nuntaynan hi Mary. ");
INSERT INTO ifu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ja inalin Marta ay Hesus hi, “Apo, nu gawwa ah to chin ar-arkhaw hot agkhuy natoy hi ibpfaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Muti anong un ad ugwani ja anilaꞌ an ichat Apo Jos ay he-a chi epfokham.” ");
INSERT INTO ifu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ja inalin Hesus hi, “Pfumangon hi ibpfam.” ");
INSERT INTO ifu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ja inalin khu Marta hi, “Anilaꞌ an mummahu hija chin ang-angonoh na an pummahuwan an amin chi natoy.” ");
INSERT INTO ifu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ja inalin Hesus ay hija hi, “Ha-in hini pummahuwan ja ha-in hini arpugwan chi piꞌtakhuwan. Hini mamati ay ha-in ja, anong un matoy, ja miꞌtakhu hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hini takhu an namati ay ha-in, ja magwachaan hi piꞌtakhuwan an ma-id chi pogpogna. Pattiyom chah hitay?” ");
INSERT INTO ifu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tempfar Marta ja inali na hi, “Aa, Apo, pattiyoꞌ an he-a hi Kristo, hini Empfalay Apo Jos an Mamahhod an umali heto lota.” ");
INSERT INTO ifu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Empa-opoh Marta hitay inali na ja numpfangngad ta i na enajakhan hi ibpfa na an hi Mary. Ja in-am-amu na hi, “Niya an immali hini Apo ta-o ja nan epa-ajag chi-a.” ");
INSERT INTO ifu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Unagkhu chengngor Mary hitay ja napfanpfannutay ta i na chinittum hi Hesus, ");
INSERT INTO ifu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ti gawwacha pay hija ay chuy i nanittuman Marta an agkhuy pay ne-atam hichi pfuglay. ");
INSERT INTO ifu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hachi Hudju an immuy hi pfalay cha Mary an i ni-ib-ipfun ja tinnig cha an napfanpfannutay hi Mary. Ja inunud cha ti khemhon cha un i umiha hichi lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Unot emmatam hi Mary chin gwachaan Hesus ja nunheppe ay hija. Ja inali na hi, “Apo, nu gawwa ah to chin ar-arkhaw hot agkhuy natoy hi ibpfaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tinnig Hesus an khun kumila hi Mary ja hachi Hudju an numpun-ibpfa na, ja machamot chi punnomnomana khapo hi nignikha na ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Empfokha na hay i cha nanglub-an. Ja inali cha hi, “Miꞌjali a, Apo, ta i ta-o tikhan.” ");
INSERT INTO ifu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja khun mun-a-agkhah chi luwan Hesus ");
INSERT INTO ifu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ja inalin hachi Hudju hi, “Chiya an otong hini pamhod na ay Lazarus.” ");
INSERT INTO ifu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Muti inalin hachi uchumna hi, “Gway apfalinana an nangpfangngad ay ni pannig nuy napfulaw, ja anagkha mah ta agkhuy na empatenong chin chokhoh Lazarus ta agkhuy natoy?” ");
INSERT INTO ifu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Munnaud an machamot hi punnomnoman Hesus chin immajan cha hichi lupfuꞌ. Lijang chin nanglub-an cha an natanglipfan hi ampfilog an pfato. ");
INSERT INTO ifu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Inalin Hesus hi, “Ipaꞌ-igwin ju hichuy tanglib.” Inalin Marta an ibpfan Lazarus hi, “Apo, anong ja gwa an immakhub ti apat hi arkhaw chi nalahin hi nilub-ana.” ");
INSERT INTO ifu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tempfar Hesus ja inali na hi, “Aa, muti hay inaliꞌ ja mipatikhaw ay he-a hini kinajos Apo Jos nu mamati a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Enaan cha chin tanglib ja entangad Hesus ja inali na hi, “Ama, agyamanaꞌ ta chengngor mu hini inaliꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Anilaꞌ an khunaꞌ chonglon ay he-a, muti alloꞌ hitay ta chonglon cha tay tatakhu an niꞌtataꞌchug, ta gway aton cha an mamati an he-a chi nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Napfalin ja iniꞌgwap Hesus an nangali hi, “Lazarus, pfumutay a!” ");
INSERT INTO ifu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Amat hichi ja pfimmutay an napuputtiputan chin achor na ja anong un chin ulu na. Ja inalin Hesus ay chicha hi, “Upfachon ju hichuy nelelepfod an pfinacha ta gway atona an umanamut.” ");
INSERT INTO ifu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hachi Hudju an i ni-ib-ipfun ay Mary ja tinnig cha chin enat Hesus, ja cho-or chay namati ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Muti gwacha gwot kaykhu hachi uchumna an i nangpfaag hachi Farisee ay chuy enat Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hotti hachi Farisee ja hachi a-ap-apon chi papachi ja empa-ajag cha chin uchumna an a-ap-apon chi Hudju ja inali cha hi, “An ngacha mah ay chita chi aton ta-o? Ti tan cho-or hana milagro an khun aton nuy an takhu! ");
INSERT INTO ifu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu achi ta-o epagwa hot mamati an amin hato tatakhu ay hija. Ja hay metob ja nu chonglon hana eRome an gway ohah mumpfalin hi ap-apo hot umali cha mangkay an mamaꞌ-i ay ni Templon Apo Jos ja hato pfuglay ta-o an Hudju hot megwa-at ta-o!” ");
INSERT INTO ifu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Muti gwa han oha ay chicha an hi Kayfas chi ngachana, hija chi natakhay an pachi ay chuy an tagwon. Ja inali na hi, “Un chah ma-id oh-ohhah anila ju? ");
INSERT INTO ifu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma-awatan ju koma an mapmaphochan un gway oha hi matoy ta achi ta-o matoy an amin ja achi ta-o ma-umah an Hudju.” ");
INSERT INTO ifu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hitay an inalin Kayfas ja agkhuy narpu ay ni nomnom na ti enchalan Apo Jos hija an natakhay an pachi ay chuy an tagwon, ta ipadtu na an e-atoy Hesus hana Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ja pfu-un hachi Hudju ja angkhay chi e-atoy na, muti midchum an amin hana empfapfalay Apo Jos an negwa-at hi apfuglapfuglay ta mun-oh-ohha cha. ");
INSERT INTO ifu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tabpfi na ay chuy ja nenomnom hachi a-ap-apon chi Hudju hay aton cha an mamatoy ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hotti agkhuy numpatpatikhaw hi Hesus ja hachi disipolo na hay hachi tatakhu ad Judea. Hotti han enat cha ja inhinud cha han ohan pfuglay an nangadnan hi Efraim an nehnot hichi let-ang. Ja nihihidchi cha. ");
INSERT INTO ifu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja gwa an machakngan chin pfehtan chi Hudju an Pangnomnoman cha chin Nalohan chin Angher Apo Jos hachi Pfalay chin A-apo cha ad Egypt. Ja cho-or chay tatakhu an narpu hi numpfino-ob-on an pfuglay an immuy ad Jerusalem ta aton cha chin ugali cha an i khun mun-amoh, ta maleneh cha hi pannig Apo Jos ja un machakngan chin pfehta. ");
INSERT INTO ifu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Khun cha hingiton hi Hesus ja, na-amung ayya hana tatakhu hichi Templo hon khun cha manghenhahanhan an mangali hi, “Ngay allon ju tugwali? Achi nin ngata miꞌjali hi Hesus an meꞌpfehta?” ");
INSERT INTO ifu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hachi ayya a-ap-apon chi papachi ja hachi Farisee ja inali cha hi, nu gway nanginnila ay ni agawwachaan Hesus ja epfaag na ta gway aton chi hay i maniliw ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Unum chi arkhaw ja un machakngan hichin Pfehtan chin Nalohan chin Angher Apo Jos, ja immuy hi Hesus ad Betani an pfuglay cha Mary ja hi Marta ja hi Lazarus, chin natoy an minahuwan Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja impartiyan cha hija. Hi Marta chi khun munhakhana ja i neꞌ-orpfong hi Lazarus ay cha Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amat hichi ja enalan Mary han lanob an munnaud an nangina an maphod chi hunghung na, an allon cha an nardo. Chugway pfahu chin lanob an empelanob Mary ay ni hu-in Hesus ja impuꞌnah na chin pfuuꞌ na. Ja napnu chin pfalay an agawwachaan cha hi pfangon chin lanob. ");
INSERT INTO ifu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Gawwah chi hi Judas Iskariot an oha an adalan an i mangngina ay Hesus. Ja unagkhu gwa an tinnig na chin enat Mary ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Anagkha ta agkhuy ju ingngina hinuy an lanob ta ichat ju hini ngina na hana publi? Un angkhaynana hon napfalor, an pfoꞌlaon hi ohay tagwon.” ");
INSERT INTO ifu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Inali na hitay muti najuna gwot ja ma-id nignikha na hana publi. Ti hini pfalor ni lanob chi nun-o-onan hichin nomnom na, khapo ta emmengha an hijay mamangchon chin pihun cha Hesus ja khuna aꞌ-aanan. ");
INSERT INTO ifu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ja inalin Hesus hi, “Achi ju papfaholon hitay an pfupfai. Ikhad hija ti enhahaꞌpfa na hitay an lanob ta enchaag na an melanob ay tay achor u ja unaꞌ imilupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hana ayya publi ja gawwacha cha ay chaꞌju hi a-arkha-arkhaw, muti ha-in ja nehnot chin arkhaw an panaynaꞌ ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Unot chengngor chin cho-or an Hudju an gwacha hi Hesus ad Betani, ja immuy cha an i nanikhaw ay hija. Ja pfu-un hija ja angkhay chi i cha tikhan muti penhod cha an piꞌtikhaw hi Lazarus an minahuwan Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ja nunhahappitanan hachi a-ap-apon chi papachi an pi-idchum cha hi Lazarus an epapatoy. ");
INSERT INTO ifu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ti nete-a chin nummahuwana ja cho-or chi Hudju an nan-ug hachi a-ap-apo cha ta mamati cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chin nun-inggwiꞌgwiit ja cho-or chay tatakhu an na-amung ad Jerusalem an meꞌpfehta ay ni Pfehtan chin Nalohan chin Angher Apo Jos. Un chaot chengngor an gwa an omatam hi Hesus ");
INSERT INTO ifu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ja emmala cha hachi tupfu an amat hi tupfun chi khattiloy. Ja i cha chinittum hi Hesus ja khun cha iꞌgwap an mangali hi, “Madaydayaw hi Apo Jos! Mabindisyonan hitay an hennag Apo Jos. Madaydayaw hitay Ari ta-o an holag Israel!” ");
INSERT INTO ifu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Empa-alan Hesus han pfoꞌtot an donkey ja nunhakay, ti hijah nuy chin nitulaꞌ an hapit Apo Jos hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Achi aju toma-ot, chaꞌju an eSion, Chiya an khun umali hichuy Ari ju an nunhahakkay han pfoꞌtot an donkey.” ");
INSERT INTO ifu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Agkhuy pay na-awatan chin disipolon Hesus hichuy an enat na, ingkhana hi nummahu ja un cha annilaon an nipa-annung chin nipadtu ay ni hapit Apo Jos ja na-at ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Chin cho-or an tatakhu an nannig chin enat Hesus hi namokhaana ay Lazarus hichi lupfuꞌ ta timmakhu, ja khun cha haphapiton. ");
INSERT INTO ifu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nunchongor hitay an milagro an enat Hesus, hijaot un cho-or chay tatakhu an i nanittum. ");
INSERT INTO ifu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amat hichi ja nunhahapit hachi Farisee an allon cha hi, “Angkhaynana, ma-id mapfalin ta-o. Ti tayya, an amin hato tatakhu ja immunud cha ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gwacha chin uchumna an Griego an niꞌjuy ad Jerusalem ta meꞌpfehta cha. ");
INSERT INTO ifu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Immuy cha ay Philip an eBetsaida ad Galilee, ja inali cha hi, “Apo, podhon mi an miꞌhapit ay Hesus.” ");
INSERT INTO ifu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Immuy hi Philip ay Andrew an i nangpfaag ay nuy inali cha, ja immuy cha an chugwa ay Hesus an i mangali. ");
INSERT INTO ifu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ja inalin Hesus hi, “Nehnot chin timpo an ipapfagtuwaꞌ an Na-ilangitan an Takhu. ");
INSERT INTO ifu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Umannung hitay alloꞌ ay chaꞌju. Hini pfugwa, nu achi mitanum ay tay lota hot achi homangaw ja achi chom-or an un hihiya an oh-ohha. Muti nitanum ayya ja amat hi un natoy muti homangaw ja cho-or chi pfunga na. ");
INSERT INTO ifu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ti hini takhu an un hini piꞌtakhuwana heto lota chi podpodhona ja angkhay, ja achi miꞌtakhu ay Apo Jos. Muti hini takhu an man-ug ay ni piꞌtakhuwana heto lota ja miꞌtakhu ay Apo Jos hi ma-id chi pogpog na. ");
INSERT INTO ifu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hini mamhod an mangat ay ni penhod u ja mahapor an unuchonaꞌ ta an amin chi hay agawwachaaꞌ, ja gawwacha khu hija. Ja ipapfagton Ama hana mangat ay ni penhod u.” ");
INSERT INTO ifu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Entoloy Hesus an nangali hi, “Machamot hitay ujaꞌ punleꞌnaan ad ugwani, muti un u chah allon ay Ama hi, ‘Haniyanaꞌ adniꞌ ay tay an umali an punlikhataꞌ?’ Achi mapfalin ti hini immaliyaꞌ heto lota ja ta lahinoꞌ hini neꞌcha an atajaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ja inalin khu Hesus hi, “Ama, ipatikhaw mu hini kinajos mu!” Ja gwacha gwot han tenompfar ad langit an nangali hi, “Impatikhaw u hini kinajos u ja ipiggwaꞌ khu an aton.” ");
INSERT INTO ifu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chengngor hachi na-amung an tatakhu an niꞌtataꞌchug hichuy hapit ja inali cha hi, “Niya an immichor!” Ja inalin hachi uchumna hi, “Niya han angher Apo Jos an niꞌhapit ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ja inalin Hesus ay chicha hi, “Chaꞌju koma chi mangngor ay nuy an hapit, ti agkhuy ni-ali hinuy an hapit khapo ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Khumaju an machakngan han panugijan Apo Jos hana tatakhu ay tay lota, hot ma-apfak hini ap-apo heto lota an hi Satanas. ");
INSERT INTO ifu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Muti ha-in nu mipfitinaꞌ hot ma-akhuy-uy an amin chi tatakhu an umali ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inali na hitay ta ipa-innila na ay chicha hini atona an matoy. ");
INSERT INTO ifu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tempfar chin tatakhu an inali cha hi, “Hay anila mi hi allona ay ni hapit Apo Jos ja ma-id chi hay umali hi atajan ni Mamahhod an hi Kristo. Hotti anagkha ta allom hi mahapor an mipfitin hini Na-ilangitan an Takhu? Ngay ngachah nuy an Na-ilangitan an Takhu?” ");
INSERT INTO ifu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tempfar Hesus ja inali na hi, “Ha-in an mipadchung hi hilaw ja un naꞌnaꞌ-omtang chi pipidchumaꞌ ay chaꞌju. Hotti pa-ennongan ju gwot an mangat hay hana itudtuchuꞌ ad ugwani an gawwachaaꞌ ta achi aju ma-ah-upan ay ni munhehellong. Ti hini chumalan ay ni hehellong ja ma-id maptoꞌ hi agwuna. ");
INSERT INTO ifu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hotti mamati aju akay niꞌ ay ha-in an manilagwan ay chaꞌju ad ugwani an agawwachaaꞌ ay chaꞌju ta mahilagwan hana nomnom ju.” Emmopoh chin inalin Hesus ja tenaynana chicha ja ma-id anila cha hi immajana. ");
INSERT INTO ifu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anong un cho-or chin milagro an enat na ta pannikhan cha koma an narpu hini apfalinana ay Apo Jos ja achi cha chamchama mamati ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hotti nipa-annung chin intulaꞌ profeta Isaiah hi nangarjana hi, “Apo, anagkha mah ta ma-id chi hay namati chin intudtuchu mi, ja ma-id khu chi hay nanginnila ay ni apfalinam?” ");
INSERT INTO ifu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Umannung hitay an intulaꞌ Isaiah an un honger hachi tatakhu an mamati. Hijaot un intulaꞌ khu Isaiah hi, ");
INSERT INTO ifu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Un loꞌtat ja pfinulaw Apo Jos hana mata cha ta achi cha tumikhaw, ja henerngana hini nomnom cha ta un chaot mah achi maka-awat. Ti allon Apo Jos hi, ‘Anagkha tugwali ta achi cha podhon an tumikhaw ja achi cha podhon an ma-awatan. Ja anagkha ta achi cha chuꞌkhon hana pfahor cha ja achi cha mungkalalag ay ha-in ta takhuwoꞌ chicha?’” ");
INSERT INTO ifu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Intulaꞌ Isaiah hitay ti nipatikhaw ay hija hini nakaskasda-aw an apfalinan Hesus, hijaot una intulaꞌ chi omaꞌ-atana. ");
INSERT INTO ifu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cho-or chamchama hachi a-ap-apon chi Hudju an namati ay Hesus. Muti agkhuy cha inar-ali, ti toma-ot cha hay hachi Farisee an nangali hi un cha ánun chicha ay ni sinagoga nu tihtikhuwan cha an namati cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ti napfalor ay chicha hini pedayawan cha hi tatakhu mu hini dayaw an marpu ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ja iniꞌgwap Hesus an nangali hi, “Hini namati ay ha-in ja pfu-un ha-in ja angkhay chi pinati na, an pinati na khu hini nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hini nannig ay ha-in ja hihiya an tinnig na hini nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Immaliyaꞌ heto lota an munhilaw ta achi mahpay maherngan chi nomnom hana mamati ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hini nangngor ay tay tukhun u ja achi na unuchon, ja pfu-un ha-in chi manugi ay hija. Ti unaꞌ immali heto lota an manakhu hi tatakhu, an agkhujaꞌ immali an manugi ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muti nu machakngan hini Punhugijan Apo Jos, ja hana tatakhu an nan-ug ay ha-in ja ay ni tukhun u ja mahugi cha khapo hay hana hapit u an agkhuy cha pinati. ");
INSERT INTO ifu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ti achiyaꞌ omo-ohha hon empadchong u hini alloꞌ, ti hi Ama an nannag ay ha-in ja inali na an amin chi hapitoꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja anilaꞌ an miꞌtakhu hi ma-id chi pogpogna hini mangat ay ni allon Apo Jos. Hijaot un an amin hini hapitoꞌ ja hana intuchun Ama hi alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gwa an machakngan chin pfehtan chi Hudju an Pangnomnoman cha chin Nalohan chin Angher Apo Jos, ja anilan Hesus an nehnot hini arkhaw an panaynana ay tay lota ta mumpfangngad ay Ama na. Nete-a chin hopapna ja penpenhod na hana tatakhu na ay tay lota, muti ad ugwani ja ipatikhaw na hini nunhegla an pamhod na. ");
INSERT INTO ifu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ay chuy an nadhom ja na-orpfong cha Hesus ja hachi adalana ja empanomnom mahpay Satanas ay Judas an empfalay Simon Iskariot hay atona an mangngina ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hi Hesus ja anila na an impulang Ama na an amin ay hija ta hijay khun mangpagpong. Ja anilan Hesus an hi Apo Jos chi narpugwana ja hija khu chi pumpfangngachana. ");
INSERT INTO ifu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Amat hichi ja timmaꞌchug hi Hesus ja lenoh-op na chin negtap an lopfong na, ja enala na han tugwarja ja empfar-oh na. ");
INSERT INTO ifu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Inhiit na han chanum han pfatja ja ente-a na an ulahan chin hu-in hachi adalana hon pinuꞌnahana ay chuy tugwarja an empfar-oh na. ");
INSERT INTO ifu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ja unot negpong ay Simon Peter ja inalin Peter ay hija hi, “Apo, un chah he-a agkhu chi mun-ulah ay tay hu-iꞌ?” ");
INSERT INTO ifu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tempfar Hesus ja inali na hi, “Agkhuy mu pay anila hitay khapo na an pangataꞌ heto, muti unchani hot annilaom.” ");
INSERT INTO ifu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ja inalin Peter hi, “Achi mapfalin unagkhu niꞌ la-ahna ja he-a chi mangulahan hato hu-iꞌ!” Ja inalin khu Hesus hi, “Nu achim pa-ulah hini hu-im ay ha-in hot achi a mangkay mipfilang hi takhuꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ja inalin Simon Peter hi, “Ti un ayya amat hina, Apo, hotti ulaham hato hu-iꞌ, ja inidchum mu mah an piꞌ-ulah hato ngamoy u ja hitay uluꞌ!” ");
INSERT INTO ifu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ja inalin Hesus hi, “Nun-amoh ayya hini takhu ja maleneh an amin hini achor na, hotti angkhay hana hu-i chi khun ipiggwa an ulahan. Maleneh aju an amin, muti gwa han oha ay chaꞌju an achi maleneh.” ");
INSERT INTO ifu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ti aniꞌ-ilan Hesus hini mangngina ay hija, hijaot una inali hi, “Gwa han oha ay chaꞌju an achi maleneh.” ");
INSERT INTO ifu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Napfalin an inulahan Hesus hachi hu-i cha ja inlopfong na khu chin lenoh-op na an lopfong, ja numpfangngad an i ni-ipfun chin nanganan cha. Ja inali na hi, “Na-awatan ju chah hitay enat u ay chaꞌju? ");
INSERT INTO ifu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Khun ju allon hi un ha-in chi Manudtuchu ay chaꞌju ja ha-in chi Apo ju, ja umannung. ");
INSERT INTO ifu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Muti tayya an anong un ha-in an Apo ju an Manudtuchu ay chaꞌju, ja inulahaꞌ hana hu-i ju. Hotti anong koma un chaꞌju ja munhin-i-innulah aju hi hu-i. ");
INSERT INTO ifu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hay nangataꞌ ay tay ja ta gway tuntunchon ju ta peꞌ-at ju. ");
INSERT INTO ifu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Umannung hitay alloꞌ ay chaꞌju. Hini takhala ja achi napfagpfagto mu hini apo na, ja achi khu napfagpfagto hini pfaar mu hini khun mamaar ay hija. Hotti nu ha-in an Apo ju ja enat u hitay, ja un chah napfagpfagto aju mu ha-in ta achi ju peꞌ-at? ");
INSERT INTO ifu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tayya an inannila ju mahpay hitay umannung an tukhun u, hotti madmachennor aju nu unuchon ju. ");
INSERT INTO ifu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pfu-un chaꞌju an amin hini nangarjaꞌ, ti anilaꞌ hini omaꞌ-atan an amin hana piniliꞌ. Mahapor an ma-at hini nitulaꞌ an Hapit Apo Jos an nangarjana hi, ‘Hini nan-ug ay ha-in ja oha an khun meꞌ-an ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ipa-innilaꞌ hitay ay chaꞌju ja un ma-at, ta tikhan ju ayya an nipa-annung ja namati aju an ha-in hini Kristo an Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Umannung hitay alloꞌ ay chaꞌju, an hini mangakhamid hay hana takhu an honakhoꞌ ja inakhamichaꞌ khu. Ja hini mangakhamid ay ha-in ja inakhamid na khu hi Ama an nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Empa-opoh Hesus hay hato inali na ja machamot hi punnomnomana, ja enhemad na an nangali chin adalana hi, “Umannung hitay alloꞌ ay chaꞌju. Gwacha han oha ay chaꞌju an i mangpfaag ay ha-in hana pfuhur u.” ");
INSERT INTO ifu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nanghenmomohgwat hachi adalana ti agkhuy cha anila nu ngay pitulungan chuy an inali na. ");
INSERT INTO ifu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ja gwa han oha an adalan an penenpenhod Hesus an nechechelloh ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ja inhinjar Simon Peter chin nechechelloh ay Hesus ta hanhanana ay Hesus chi ngachan ni allona an i mangpfaag ay hija hana pfuhur na. ");
INSERT INTO ifu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hotti inggwingi na ay Hesus ja inali na hi, “Apo, epfaag mu man hini adalan an i mangpfaag ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tempfar Hesus ja inali na hi, “Hini pangchataꞌ ay ni tenapay an ehawhaw u ja hija hini i mangpfaag ay ha-in.” Amat hichi ja enala na han tenapay ja enhawhaw na, ja inchat na ay Judas an empfalay Simon Iskariot. ");
INSERT INTO ifu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chinugwagwan Judas chin tenapay ja nehoꞌlong gwot hi Satanas ay hija. Ja inalin Hesus ay hija hi, “Umuy aot ta im aton hini nenonomnom mu an aton.” ");
INSERT INTO ifu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hachi uchumna an adalan ja agkhuy cha na-orman hitay an i inalin Hesus ay Judas. ");
INSERT INTO ifu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Hay khemhon hachi uchumna ja un pfinaar Hesus ta i ngumina hay mahapor cha ay chuy an pfehta, ti hi Judas chi mamangchon chin pihu cha. Ja khemhon khu hachi uchumna hi unakkay pfinaar Hesus an i mangchat hay tolong hay hana napubli. ");
INSERT INTO ifu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Unot enalan Judas chin tenapay ja nakak. Nanadhom ay chuy an nakakana. ");
INSERT INTO ifu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nakak hi Judas ja inalin Hesus hi, “Ad ugwani ja timpo na an mipapfagpfagtuwaꞌ an Na-ilangitan an Takhu, ja khapo ay ha-in ja mipapfagpfagto hi Ama. ");
INSERT INTO ifu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ja nu mipapfagto hi Apo Jos khapo ay ha-in ja achi na etantan an mangpapfagpfagto khu ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chaꞌju an impfilang u hi empfapfalay, achi mapfajag hot taynaꞌ chaꞌju. Hingitonaꞌ ay chaꞌju muti tan ipiggwaꞌ an mangali chin inaliꞌ hachi a-ap-apon chi Hudju, an achi mapfalin an miꞌjali aju gwot ay ni omajaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ja tayya han oha an idchum u an i-urchin hot unuchon ju. Mahapor an mumpepennohhochan aju an amat ay ni enat u an namenhod ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ti nu mumpepennohhochan aju ja hijay pangmatunan an amin chi tatakhu an chaꞌjuy disipoloꞌ an immunud ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Empfokhan Simon Peter ay Hesus hi, “Hotti ngay mah im omajan, Apo?” Ja inalin gwot Hesus hi, “Achi mapfalin an miꞌjali a chamchama ay ni omajaꞌ, ta unchani ja un a mangunud.” ");
INSERT INTO ifu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ja inalin khu Peter hi, “Anagkha mah, Apo, ta achi mapfalin an mitnuchaꞌ ad ugwani? Nehahagkhanaaꞌ an matoy khapo ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ja inalin Hesus hi, “Un chah angkhiloh un mu ichat hini piꞌtakhuwam khapo ay ha-in? Tayya an alloꞌ hini umannung, an ehaotaꞌ ay he-a hi mumpetlo ad ugwani an lapfi ja unot tumalanu.” ");
INSERT INTO ifu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Inalin Hesus hi, “Achi aju madanakhan, ta un aju gwot mamati ay Apo Jos ja mamati aju khu ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hichi pfalay Ama, ja cho-or chi punhitugwan, hotti umujaꞌ ta ijaꞌ ehakhana hini piꞌhitugwan ju. Nu achi umannung hot achiꞌ koma allon ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nu nakhibpfoh ayya an enhakhanaꞌ hini piꞌhitugwan ju hot mumpfangngachaꞌ ta agwitoꞌ chaꞌju ta mihihidchi aju ay ni agawwachaaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ti anila ju mit hini chalan an mangedchong ay ni omajaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ja inalin Tomas ay hija hi, “Apo, agkhuy mi anila hini omajam, hotti ngay mah panginnilaan mi ay ni chalan?” ");
INSERT INTO ifu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tempfar Hesus ja inali na hi, “Ha-in chi chalan ja ha-in chi umannung ja ha-in chi arpugwan chi nahamad an piꞌtakhuwan. Ma-id umuy ay Ama nu pfu-un ha-in chi agwuna. ");
INSERT INTO ifu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu inannilaaꞌ koma ay chaꞌju hot niꞌ-annila ju khu hi Ama. Mete-a ad ugwani ja inannila ju hija ja tinnig ju.” ");
INSERT INTO ifu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ja neꞌpfokhan Philip ay hija hi, “Apo, ipatikhaw mu mah hi Amam ay chaꞌmi ta mapnek ami.” ");
INSERT INTO ifu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tempfar Hesus ja inali na hi, “Akamoh kaykhu hini ninidchumaꞌ ay chaꞌju ja agkhujaꞌ pay la-eng inannila ay he-a, Philip, ja anagkha ta allom hi un u ipatikhaw hi Ama ay chaꞌju? Ti hini takhu an nanikhaw ay ha-in ja tinikhaw na khu hi Ama. ");
INSERT INTO ifu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Un mu chah achi pattiyon an hi Ama ja gawwacha ay ha-in ja gawwachaaꞌ khu ay hija? Hay hato ayya an khun u allon ay chaꞌju ja pfu-un ha-in chi narpugwana, an hi Ama. Gawwacha hija ay ha-in, ja hijay mangat ay ni penhod na an aton. ");
INSERT INTO ifu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mahapor an pattiyon ju an gawwachaaꞌ ay Ama ja gawwacha khu hi Ama ay ha-in. Nu achi ju ayya pattiyon khapo ta un u khun hapiton, ja mamati aju koma khapo hay hato milagro an khun u aton. ");
INSERT INTO ifu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Umannung hitay alloꞌ ay chaꞌju, an hini takhu an mamati ay ha-in ja mapfalin an atona hana khun u aton, ja gwa pay chi ma-at na hi ot-ottong, ti mumpfangngachaꞌ ay Ama. ");
INSERT INTO ifu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ja an amin hana epfokha ju khapo hi neꞌ-oh-ohhaan ju ay ha-in, ja atoꞌ ta gway aton Ama an madaydayaw khapo ay ha-in an Empfalay na. ");
INSERT INTO ifu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hotti an amin hana epfokha ju khapo hi neꞌ-oh-ohhaan ju ay ha-in ja atoꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Inalin Hesus hi, “Hini panginnilaan an gway pamhod ju ay ha-in ja hini pangunuchan ju hay hana urchin u. ");
INSERT INTO ifu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Epfokhaꞌ ay Ama ta ipa-ali na hay oha khu hi Tomolong an munheto ay chaꞌju hi ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hijah tay hini Espiritu Santo an hijay mangtuchu ay chaꞌju an amin hana umannung. Hana ayya agkhuy namati ay ha-in ja achi mapfalin an apfuluton cha hitay Espiritu Santo, ti achi cha imatunan ja ma-id anila cha ay hija. Chaꞌju ayya ja anila ju, ti gawwacha ad ugwani ja umali han arkhaw hot munheto ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Anong un u taynan chaꞌju ja achi aju mumpfalin hi ngoho, ti mumpfangngachaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Achi mapfajag hot achiyaꞌ mahpay tikhan hay hana agkhuy namati. Muti chaꞌju ayya, ja hintikhanaꞌ khu. Ja khapo ta matattakhuwaꞌ ja miꞌtattakhu aju khu. ");
INSERT INTO ifu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ay nuy an timpo ja annilaon ju an gawwachaaꞌ ay Apo Jos, jagawwacha aju ay ha-in ja gawwachaaꞌ khu ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hini takhu an mangapfulut hay hana urchin u ja inunud na, ja hija hini ma-ali hi gway pamhod na ay ha-in. Ja hini gway pamhod na ay ha-in ja penhod Ama ja penhod u khu, ja ipa-innilaꞌ hini omaꞌ-ataꞌ ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ja inalin Judas, pfu-un hi Judas Iskariot, hi, “Apo, anagkha ta chaꞌmi ja angkhay chi pangpa-innilaam ay ni omaꞌ-atam ja achi an amin hi tatakhu?” ");
INSERT INTO ifu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tempfar Hesus ja inali na hi, “Hini gway pamhod na ay ha-in ja unuchona hini alloꞌ. Podpodhon Ama hija ja umali ami an munheto ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hini ayya ma-id pamhod na ay ha-in ja achi na unuchon hini alloꞌ. Hay hato an inaliꞌ ay chaꞌju ja agkhuy narpu ay ha-in ja angkhay, ti hi Ama an nannag ay ha-in chi khun mangtuchu ay ni khun u allon. ");
INSERT INTO ifu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Impa-innilaꞌ hay hato ay tay an agawwachaaꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ja unchani ta umali hini Tomolong, an hija hini Espiritu Santo an ipa-alin Ama, ta etoloy na hini tamuꞌ an mangitudtuchu ay chaꞌju, ja epanomnom na an amin hay hana inaliꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Hay taynaꞌ ay chaꞌju ja hini nahamad an pomhochan chi piꞌtakhuwan ju, an achi amat ay ni khun allon chi tatakhu an pomhochan chi piꞌtakhuwan. Hotti achi aju madanakhan ja achi aju toma-ot. ");
INSERT INTO ifu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chengngor ju chin inaliꞌ hi umujaꞌ muti mumpfangngachaꞌ. Hot nu umannung an penenhochaꞌ ay chaꞌju ja mun-an-anla aju koma hi omajaꞌ hichi achaan Ama, ti napfagpfagto hija mu ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Impa-innilaꞌ hitay ay chaꞌju ja un ma-at ta tikhan ju ayya an nipa-annung, ja namati aju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Achiꞌ anchu-ajon hitay piꞌhapitaꞌ ay chaꞌju ti nganngani an umali hini mun-ap-apo heto lota an hi Satanas. Ma-id chamchama apfalinana an mangapfak ay ha-in, ");
INSERT INTO ifu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","muti apfulutoꞌ hana eneꞌchan Ama an ma-at ta gway aton chi tatakhu an manginnila an podpodhoꞌ hi Ama. Hijaot un u aton an amin chi hay inali na hi atoꞌ. Hot lomeggwat aju ta umuy ta-o.” ");
INSERT INTO ifu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Inalin Hesus hi, “Ha-in hini nahamad an nitanum an ubas ja hi Ama hini khun manalimun. ");
INSERT INTO ifu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","An amin hana halepeng an achi pfumunga ja ánun ni khun manalimun. Hana ayya halepeng an khun pfumunga ja portu-ana ta gway atona an ngumalenge ta chomchom-or ja pomhod chi pfumungaana. ");
INSERT INTO ifu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ja chaꞌju an disipoloꞌ hini halepeng an nalenehan mahpay khapo hana hapit u an intudtuchuꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mimidchum aju ay ha-in ja mimidchumaꞌ khu ay chaꞌju. Ti amat ay ni halepeng, an achi pfumunga nu na-aan ay ni achor na. Amat hina khu an ma-id pfungan ni pammati ju nu achi aju mimidchum ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Impiggwan Hesus an nangali hi, “Ha-in hini nahamad an nitanum an ubas ja chaꞌju hana halepeng na. Hini mimidchum ay ha-in ja mimidchumaꞌ khu ay hija, hot cho-or chi pfunga na. Muti nu umachawwi aju ay ha-in hot ma-id oh-ohhah ma-at ju. ");
INSERT INTO ifu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hini ayya achi mimidchum ay ha-in ja metapar an amat ay ni halepeng an na-aan ay ni ubas. Unchani ta malango hana na-aan an halepeng ja tiniptipun ta mapoolan. ");
INSERT INTO ifu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu mimidchum aju ay ha-in, ja khokhotan ju hana intudtuchuꞌ ta khun ju unuchon, hot ma-at an amin chi epfokha ju. ");
INSERT INTO ifu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hini pfumungaan ju hi cho-or ja ichat nay dayaw ay Ama. Nu amat heto ayya hot hijay panginnilaan hi nangunuchan ju ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Penpenhochaꞌ ay Ama ja amat hina khu hini pamhod u ay chaꞌju. Hotti mimidchum aju ay ha-in ta magwachaan aju ay tay pamhod u. ");
INSERT INTO ifu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu khun ju unuchon hana urchin u hot magwacha ay chaꞌju hitay pamhod u. An amat khu ay ha-in, an khun u unuchon hana urchin Ama ja gawwacha ay ha-in hini pamhod na. ");
INSERT INTO ifu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Inaliꞌ hay hato ta magwachaan aju hi an-anla an amat ay ni anla an gwa ay ha-in. Ja achi kumuchang chi i ju pun-an-anlaan. ");
INSERT INTO ifu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hitay chi urchin u ay chaꞌju, an mahapor an mumpepennohhochan aju an amat ay ni nahamad an pamhod u ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hini omaꞌ-atan chi nahamad an pamhod an ma-id ipadchungana, ja hini pangchatan ay ni piꞌtakhuwan ta gway aton hana khakhayyum an matakhu. ");
INSERT INTO ifu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma-ali aju an khakhayyum u nu khun ju unuchon hana in-urchin u. ");
INSERT INTO ifu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Achiꞌ mahpay ipfilang chaꞌju hi takhala, ti hini ayya takhala ja achi na ma-innila hana khun aton ni apo na. Chaꞌju ayya ja impfilang u chaꞌju hi khakhayyum, hijaot un u impa-innila ay chaꞌju an amin hana chengngor u ay Ama. ");
INSERT INTO ifu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pfu-un chaꞌjuy namili ay ha-in ti ha-in chi namili ay chaꞌju an i mangat ay ni tamun Apo Jos, ja mapmaphod hini pfunga na, an achi ma-upfah. Nu amat hetoy aton ju hot ichat Ama an amin hana epfokha ju an namati ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hotti hitay chi urchin u ay chaꞌju, an mahapor an mumpepennohhochan aju.” ");
INSERT INTO ifu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Inalin khu Hesus hachi disipolo na hi, “Pfuhulon chaꞌju hay hana tatakhu an agkhuy namati ay ha-in. Muti nomnomon ju an pfinuhulaꞌ hi nahhun ja unot chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu amat aju hay hana agkhuy namati ay ha-in hot podpodhon chaꞌju, ti ipfilang chaꞌju hi ibpfa cha. Muti achi aju amat ay chicha, ti piniliꞌ chaꞌju an tatakhuꞌ hot ma-id niꞌ-ibpfaan ju ay chicha. Hijaot un chaꞌju pfuhulon ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hotti nonomnomon ju chin inaliꞌ ay chaꞌju, an hini takhala ja achi napfagpfagto mu hini apo na. Pinalikhataꞌ an Apo ju, hotti anong un chaꞌju ja piꞌpalikhat chaꞌju. Ja khulat ta gway nangapfulut hana intudtuchuꞌ hot apfuluton cha khu hana itudtuchu ju. ");
INSERT INTO ifu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hay pangatan cha heto ja khapo ta chaꞌjuy tatakhuꞌ, ti agkhuy cha anila hi Ama an nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nu agkhujaꞌ immali an nuntudtuchu ay chicha hot pfu-un pfahor hini achi cha pammatiyan ay ha-in. Muti tayya an chengngor cha hana hapit u, hotti ma-id pampfar cha. ");
INSERT INTO ifu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hana pfumuhur ay ha-in ja niꞌpfuhur cha khu hi Ama. ");
INSERT INTO ifu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ja nu ma-id impatikhaw u ay chicha hi milagro an achi ma-at chi tatakhu hot pfu-un pfahor hini achi cha pammatiyan ay ha-in. Muti tayya an tinnig cha hachi milagro, ja pfinuhulaꞌ chamchama ja anong un hi Ama. ");
INSERT INTO ifu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Achi koma amat heto muti mahapor an mipa-annung hini nitulaꞌ an Hapit Apo Jos hi nangarjana hi, ‘Pfinuhulaꞌ anong un ma-id nanghunungan cha.’ ");
INSERT INTO ifu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Unchani ta umali hini Tomolong an ipa-aliꞌ an marpu ay Ama, hot tihtikhuwanaꞌ ay hija. Hija hini Espiritu Santo an marpu ay Ama ta ituchu na an amin chi hay umannung. ");
INSERT INTO ifu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hotti chaꞌju khu, ja mahapor an tihtikhuwanaꞌ, ti chaꞌjuy ini-itnud u nete-a chin nuntudtuchugwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Entoloy Hesus an nangali hi, “Inaliꞌ hay hato ay chaꞌju ta gwa ayya an ma-at ja achi ju epolag hini pammati ju. ");
INSERT INTO ifu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Alloꞌ ay chaꞌju hi hay hana papadchung ju an Hudju ja ánun chaꞌju ay ni sinagoga ta achi aju mimidchum ay chicha. Ja umali pay han timpo an gway mamatoy ay chaꞌju, ti khemhon cha un maphod ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aton cha hay hato ay chaꞌju, ti ma-id anila cha ay Ama, ja ma-id khu anila cha ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Muti impa-innilaꞌ hay hato ta nachakngan ayya hini pamalikhatan cha ay chaꞌju, hot mepanomnom an ina-alliꞌ hay hato.” Ja entoloy Hesus an nangali hi, “Chin nangte-aaꞌ an nuntudtuchugwan ja agkhuy u impa-innila hay hato an ma-at ti gawwachaaꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ja tan ad ugwani ja mumpfangngachaꞌ ay ni nannag ay ha-in an immali heto lota. Muti tan ma-id chi oha ay chaꞌju hi mangpfokha hi, ‘Ngachah chi im omajan?’ ");
INSERT INTO ifu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","An unagkhu hitay nangarjaꞌ ay chaꞌju an akakaꞌ chi nonomnomon ju, ja niya agkhu an immayyong aju. ");
INSERT INTO ifu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Muti umannung hitay alloꞌ, an hay ap-aphochan juy panaynaꞌ ay chaꞌju ta umali hini Tomolong an hija hini Espiritu Santo. Ti nu achiyaꞌ umuy hot achi khu umali hini Espiritu Santo. Hijaot unaꞌ umuy ta honakhoꞌ hija an umali ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja umali ayya hot hijay mangpa-innila ay cha nuy agkhuy namati ay ha-in chi omaꞌ-atan chi pfahor, ja niꞌpa-innila na hini aphod u, ja hini omaꞌ-atan chi panugijan Apo Jos ay chicha, ti nehahalla cha. ");
INSERT INTO ifu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hitay oha an ipa-innilan ni Espiritu Santo ja pfahor hini agkhuy cha namatiyan ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Hitay khu oha ja ipa-innilan ni Espiritu Santo an ha-in chi magpong. Hay pangannilaan cha ja hini pummahuwaꞌ an omajaꞌ ay Ama, ja achiyaꞌ mahpay matigtikhaw heto lota. ");
INSERT INTO ifu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ja ipa-innila na khu hini omaꞌ-atan chi panugijan Apo Jos, ti napfalin an nahugi hi Satanas an khun mun-ap-apo heto lota. ");
INSERT INTO ifu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Cho-or pay koma chi alloꞌ ay chaꞌju muti anilaꞌ an achi aju paꞌ-ahchor ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Unchani ta umali hini Espiritu Santo an mangtuchu hi umannung hot tulungan chaꞌju ta gway aton ju an mangannila an amin hi umannung. Hana allona ja agkhuy narpu ay hija, an una ipa-innila hana chengngor na ay Ama, ja ipa-innila na hana maꞌma-at. ");
INSERT INTO ifu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ipapfagtuwaꞌ ay hija ay ni pangpa-innilaana ay chaꞌju hana penhod u an allon. ");
INSERT INTO ifu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ti an amin hana gwa ay Ama ja gwa khu ay ha-in, hijaot un u allon hi ipa-innilan ni Espiritu Santo ay chaꞌju hana alloꞌ ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Entoloy Hesus an nangali hi, “Achi mapfajag hot achiyaꞌ tigtikhan ay chaꞌju, ja achi khu mapfajag hot tikhagwunaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ja khun manghinpfopfogkha hachi disipolon Hesus an allon cha hi, “Ngay nin podhona an allon ay tay nangarjana hi, ‘Achi mapfajag hot achiyaꞌ matigtikhaw ay chaꞌju, ja achi khu mapfajag hot matikhagwaꞌ?’ Ja anagkha mah ta allona hi, ‘Ma-at hay hato ti mumpfangngachaꞌ ay Ama?’ ");
INSERT INTO ifu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nga khun tay ‘achi mapfajag’ an hinapit na? Ma-id machotoꞌ nu ngay podhona an hapiton.” ");
INSERT INTO ifu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na-orman Hesus an penhod cha an hanhanan ay hija, ja inali naot hi, “Khun aju manghinpfopfogkha nu ngay penhod u an allon ay tay nangallaꞌ hi, achi mapfajag hot achiyaꞌ tigtikhan ay chaꞌju, ja achi khu mapfajag hot tikhagwunaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Umannung hitay alloꞌ ay chaꞌju, an umali han timpo an kumilaan ja umayyungan ju, muti hana agkhuy namati ja mun-an-anla cha. Lumapoh hini umayyungan ju muti unchani hot mahukatan hi an-anla. ");
INSERT INTO ifu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Amat ay ni tomoꞌkhong an pfupfai, an ma-id eke-ekejana hi punleꞌnaana. Unchani ta entoꞌkhong na hini pfuꞌjug ja achi na mahpay manomnom chin chokhoh na, ti unot mun-an-anla khapo ay ni unga an entoꞌkhong na. ");
INSERT INTO ifu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Amat hina khu ay chaꞌju an ma-id pohodna hi punleꞌnaan ju ad ugwani, muti unchani ta hi pannikhanaꞌ ay chaꞌju hot munnaud chi i ju pun-an-anlaan. Ja nehamad hitay an an-anla ju an achi maploh. ");
INSERT INTO ifu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ay nuy an timpo an punchichittuman ta-o ja ma-id mahpay hanhanan ju ay ha-in. Umannung hitay alloꞌ ay chaꞌju. An amin hana epfokha ju ay Apo Jos khapo hi niꞌ-ibpfaan ju ay ha-in ja inchat na. ");
INSERT INTO ifu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ingkhana ad ugwani ja ma-id empfokha ju khapo hi niꞌ-ibpfaan ju ay ha-in. Hotti ete-a ju an khun mun-achaw ta michatan aju, hot munnaud chi pun-an-anlaan ju.” ");
INSERT INTO ifu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Entoloy Hesus an nangali hi, “Hini enat u an nangtudtuchu ay chaꞌju ja un pangngarig. Muti umali han timpo an achiꞌ ipangngarig hini alloꞌ ay chaꞌju ta un u pun-emohag an mangtudtuchu ay ni omaꞌ-atan Ama. ");
INSERT INTO ifu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ay nuy an timpo ja hijay pangpfokhaan ju hi mahapor ju khapo hi niꞌ-ibpfaan ju ay ha-in. Achi khahin un ha-in chi mangpfokha ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ti hi Ama ja podpodhon chaꞌju, ti penenpenhochaꞌ khu ay chaꞌju ja pinati ju an narpuwaꞌ ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja umannung an narpuwaꞌ ay Ama ja immaliyaꞌ heto lota. Unchani hot makakaꞌ heto lota ta mumpfangngachaꞌ ay Ama.” ");
INSERT INTO ifu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Inalin hachi disipolo na ay hija hi, “Niya mah an nun-emohag mu hini enat mu an nunhapit ad ugwani an agkhuy mu impangngarig. ");
INSERT INTO ifu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tan ma-awatan mi ad ugwani an anilam an amin, anong un hana nomnom chi tatakhu. Ti anilam hana hanhanan cha ay he-a ja un chaot ehanhan. Hijaot un mi pattiyon an hi Apo Jos chi narpugwam.” ");
INSERT INTO ifu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tempfar Hesus ja inali na hi, “Hotti pattiyonaꞌ chah ad ugwani? ");
INSERT INTO ifu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Muti nonomnomon ju hitay an alloꞌ, an nehnot hini timpo an punhihijanan ju, ja mumpanga-anamut aju ja taynanaꞌ an omo-ohha. Muti achiyaꞌ chamchama omo-ohha ti gawwa hi Ama an pun-i-ibpfaꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Impa-innilaꞌ hay hato ta chaꞌju an ninidchum ay ha-in ja magwachaan aju hi lenong. Khangayna an malikhatan aju an miꞌtakhu heto lota. Muti ipapfi-ah ju hini nomnom ju! Ti enapfak u hana napukhit an gwah to lota.” ");
INSERT INTO ifu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Empa-opoh Hesus an nangali hay hato ja entangad na ad uchu an mungkalalag ay Ama na ja inali na hi, “Ama, nachakngan hini eneꞌcham an timpo, hotti ipapfagpfagtuwaꞌ an Empfalay mu, ta gway atoꞌ an mangpapfagpfagto ay he-a. ");
INSERT INTO ifu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ti inchatanaꞌ hi apfalinan an mangpadchong an amin hi tatakhu. Hotti an amin hana pinilim an tatakhuꞌ, ja ichataꞌ chicha hi piꞌtakhuwan an ma-id chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ja hini omaꞌ-atan chi piꞌtakhuwan an ma-id chi pogpogna ja hija hini nanginnilaan cha ay he-a an oh-ohha an umannung an Jos, ja ay ha-in an hi Hesu Kristo an hennag mu an immali heto lota. ");
INSERT INTO ifu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Empapfagpfagtoꞌ he-a ay ni nangataꞌ hay hana impatamum ay ha-in ta medaydayaw a heto lota, ja tayya an pfinalin u. ");
INSERT INTO ifu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ad ugwani ja mumpfangngachaꞌ ay he-a, Ama, hotti epfangngad mu ay ha-in hichin gloryaꞌ an gawwaay ha-in hi agkhuy pay narmugwan tay lota ja hi agawwachaaꞌ ay he-a. ");
INSERT INTO ifu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Impa-innilaꞌ he-a hay hana pentoꞌ mu an tatakhuꞌ. Tatakhum chicha ja impulang mu ay ha-in, ja inunud cha hini hapit mu. ");
INSERT INTO ifu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hotti ad ugwani ja inannila cha an narpu ay he-a an amin hana gwa ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Intuchuꞌ ay chicha hana intuchum ay ha-in, ja inapfulut cha. Ja inannila cha an umannung an he-a chi narpugwaꞌ, ja pattiyon cha an he-ay nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Khun u ekalalakhan chicha ad ugwani. Achiꞌ ekalalakhan hana agkhuy namati, an hay ekalalakhaꞌ ja hay hana tatakhu an inchat mu ay ha-in, ti tatakhum chicha. ");
INSERT INTO ifu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","An amin hana tatakhuꞌ ja tatakhum, ja tatakhuꞌ an amin hana tatakhum. Ja madaydayawaꞌ ad ugwani khapo ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tan umaliyaꞌ ay ni achaam ad ugwani ja taynaꞌ hitay lota, muti tan gawwacha cha pay ay tay lota. Hotti hay kalalag u ay he-a, Ama an Nasantuwan, ja halimunam chicha ay ni apfalinam an amat ay ni inchat mu ay ha-in ta mun-oh-ohha cha an amat ay ni nun-oh-ohhaan ta. ");
INSERT INTO ifu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ay tay ninidchumaꞌ ay chicha ja hinalimunaꞌ chicha ay ni apfalinam an inchat mu ay ha-in. Ja ma-id oh-ohhah na-utaw ay chicha, an un angkhay hini oha an neꞌcha an ma-utaw, ta gway aton ni nitulaꞌ an Hapit mu an mipa-annung. ");
INSERT INTO ifu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ja tan umaliyaꞌ ay he-a ad ugwani, hijaot un u allon hay hato ay chicha ja un u taynan hitay lota, ta munnaud chi pun-an-anlaan cha ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Intuchuꞌ an amin hini tukhun mu ay chicha ta unuchon cha, hijaot un apfoholan hana agkhuy namati chicha. Ti ma-id niꞌ-ib-ibpfaan cha hay hana agkhuy namati an amat khu ay ha-in an ma-id niꞌ-ibpfaaꞌ ay chicha an agkhuy namati. ");
INSERT INTO ifu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Achiꞌ allon hi un mu agwiton hay hato ta taynan cha hitay lota. Muti ekalalag u ta haniyam chicha ta achi cha ma-apfak ay Satanas. ");
INSERT INTO ifu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ti amat cha ay ha-in an ma-id chi niꞌ-ib-ibpfaana hay hana agkhuy namati an tatakhun Satanas. ");
INSERT INTO ifu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hini Hapit mu ja hija hini umannung. Hotti ipa-innilam ay chicha ta chuꞌkhon chay pfahor ja naꞌna-unnud cha ay ni umannung an Hapit mu. ");
INSERT INTO ifu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hennakhaꞌ an immali heto lota an mangtudtuchugwan hato tatakhu, hotti honakhoꞌ khu chicha an umuy hay hana agkhuy namati ta itudtuchu cha hini tukhun mu. ");
INSERT INTO ifu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Khapo hay hato mangapfulut ay ni umannung an tukhun ja ichat u hitay piꞌtakhuwaꞌ ta gway aton ni piꞌtakhuwan cha an meꞌcha ay he-a. ");
INSERT INTO ifu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pfu-un hay hato ja angkhay chi ekalalakhaꞌ, an idchum u an amin hay hana mamati ay ha-in khapo hi puntudtuchugwan cha. ");
INSERT INTO ifu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Hay kalalag u, Ama, ja mun-oh-ohha cha koma an amin ja meꞌ-oh-ohha cha ay chita, an amat ay he-a an gawwacha ay ha-in, ja gawwachaaꞌ khu ay he-a. Mun-oh-ohha cha koma ta pattiyon chi tatakhu an he-a chi nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inchat u ay chicha hini glorya an inchat mu ay ha-in ta mun-oh-ohha cha an amat ay ni nun-oh-ohhaan ta. ");
INSERT INTO ifu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ha-in chi gawwacha ay chicha, ja he-ay gawwacha ay ha-in. Hot mun-oh-ohha cha ja annilaon chi tatakhu an he-ay nannag ay ha-in, ja penenpenhod mu chicha an amat ay ni enat mu an namenhod ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Hay podhoꞌ, Ama, ja hay hana tatakhu an impulang mu ay ha-in ja umali cha an meꞌheto hina ad langit an umaliyaꞌ, ta piꞌtikhaw cha hini glorya an inchat mu ay ha-in khapo ta penenpenhochaꞌ ay he-a nete-a chin agkhuy pay narmugwan tay lota. ");
INSERT INTO ifu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama an magpong, hana agkhuy namati ja ma-id anila cha ay he-a. Muti anilaꞌ he-a, ja inannilan hay hato an he-a chi nannag ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impa-innilaꞌ he-a ay chicha ja etortoloy u an aton, ta hini pamhod mu ay ha-in ja gawwacha ay chicha, ja gawwachaaꞌ khu ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Empa-opoh Hesus an nungkalalag ja empacheh cha ay cha chuy adalana. Pfinad-ang cha hini henge an Kidron an na-alu-an ja immuy cha ay chuy chammangna an natamman hi ajiw an olibo. ");
INSERT INTO ifu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hi Judas an nangngina ay Hesus, ja aniꞌ-ila na hichuy an na-alu-an ti hichuy chi emmengha hi khun omajan Hesus ja hachi adalana. ");
INSERT INTO ifu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hotti initnud Judas han hempfontog an hinchalo ja hachi khun munggwarja hichi Templo an pfinaar hachi a-ap-apon chi papachi ja hachi Farisee, ja immuy cha ay chuy an na-alu-an. Numpunchilag cha ja numpun-ochon cha hi pfangid ja pang-or. ");
INSERT INTO ifu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","5","Hi Hesus an nanginnila an amin hana ma-at ay hija, ja i na chinittum chicha. Ja gwa hi Judas an niꞌtataꞌchug ay chicha. Ja inalin Hesus hi, “Ngay ngachan nuy hingiton ju?” Tempfar cha ja inali cha hi, “Hini hingiton mi ja hi Hesus an eNazaret.” Ja inali na hi, “Ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ay chuy nangarjana hi, “Ha-in” ja nun-ipfugnud cha ja agkhuy cha naleꞌna ja nun-atuꞌ-in cha. ");
INSERT INTO ifu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ja impiggwan Hesus an nangali hi, “Ngay ngachah nuy hingiton ju?” Ja inali cha khu hi, “Hi Hesus an eNazaret.” ");
INSERT INTO ifu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ja inalin Hesus hi, “Ti inaliꞌ mit an ha-in hi Hesus. Nu ha-in ayya hini hingiton ju an tiligwon, ja tojaꞌ ja. Muti achi ju pi-idchum hay hato numpun-ibpfaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inali na hitay ta mipa-annung chin inali na ay Ama na an, “Ma-id oh-ohhah ujaꞌ inutaw ay cha tay an tatakhuꞌ an impulang mu ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Inuꞌnoh Simon Peter chin pfangid na ja enhegwat na, ja na-aan chin agwan an ingan ni ohan takhalan chin Natakhay an Pachi. Ja hini ngachan chuy an takhala ja hi Malkus. ");
INSERT INTO ifu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ja inalin Hesus hi, “Peter, ehe-ot mu hinuy pfangid mu. Un mu chah chamchama epagwa an un u inapfulut hini eneꞌchan Ama an ujaꞌ punlikhatan.” ");
INSERT INTO ifu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Amat hichi ja hachi hinchalo ja chin ap-apo cha ja hachi gwarja an Hudju, ja tiniliw cha hi Hesus ja pfina-ud cha chin ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hay nahhun hi nang-ajan cha ja ay Anas an ammod chin ahagwan Kayfas an Natakhay an Pachi ay chuy an timpo. ");
INSERT INTO ifu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hitay an hi Kayfas chin nangali hachi a-ap-apon chi Hudju hi, “Mapmaphod un gway oha hi matoy ta achi ta-o matoy an amin an Hudju.” ");
INSERT INTO ifu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hi Simon Peter ja han oha an nun-ibpfa na an adalan ja nangunud cha ay cha Hesus. Hichuy oha an adalan ja an-annilan chuy Natakhay an Pachi, hotti niꞌhikhupon cha ay chuy na-alad an partug an nunhitugwan ni Natakhay an Pachi. ");
INSERT INTO ifu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Hi Peter ayya ja agkhuy cha an-annila hotti nataynan hichi pfutayna. Muti niꞌhapit chin nun-ibpfa na han pfupfai an khun mumpfantay ay chuy pantaw ja niꞌhikhupona hi Peter. ");
INSERT INTO ifu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ja inalin chin pfupfai ay Peter hi, “Oha a jaꞌ an disipolon chuy lala-e an tiniliw cha.” Ja inalin Peter hi “Pfu-un mangkay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tungnin ay chuy an lapfi, hotti nun-apoy hachi takhala ja hachi gwarja ta gway pun-anichuwan cha. Timmataꞌchug cha an nalili-ub ay chuy apoy ja niꞌtataꞌchug hi Peter an khun miꞌ-anichu. ");
INSERT INTO ifu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Amat hichi ja ente-an chin Natakhay an Pachi an hi Anas an munhanhan ay Hesus nu ngay amatan hana disipolo na ja ngay ngachah hana khuna itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ja inalinot Hesus hi, “Hini enat u an nuntudtuchu ja chengngor an amin chi tatakhu. Khunaꞌ muntudtuchu hay hana sinagoga ja hichi Templo an khun pa-amungan an amin chi Hudju, ja ma-id oh-ohhah intuchuꞌ hi agkhuy cha chengngor. ");
INSERT INTO ifu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hotti anagkha ta epfokham ay ha-in? Hay koma pangpfokhaam ja hay hana nangngor ay ni intudtuchuꞌ, ti anila cha.” ");
INSERT INTO ifu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Unagkhu inalin Hesus hitay ja henoplat han ohan gwarja ja inali na hi, “Un chah ma-id pfa-in mu ta amat hinay pampfar mu ay tay Natakhay an Pachi?” ");
INSERT INTO ifu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tempfar Hesus ja inali na hi, “Allom adchiya tugwali nu ngay inaliꞌ hi nehahalla. Ma-id ayya ja anagkha ta hoplatonaꞌ?” ");
INSERT INTO ifu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Amat hichi ja impi-uy Anas hi Hesus an napfabpfa-ud ay Kayfas an natakhay an pachi ta hijay munhumarja nu gway machakngan hi panghiꞌ-ingan an pangchaloman ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ja gawwacha pay hi Peter an niꞌtataꞌchug an khun miꞌ-anichu hichi pfutayna. Ja gwa hana nangali ay hija hi, “He-a khuh niꞌ hini oha an disipolon chuy lala-e an tiniliw cha.” Ja enhaot Peter ja inali na hi, “Pfu-un mangkay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ja gwa khu ay chuy han ohan takhalan ni Natakhay an Pachi, an akhin ni takhala an khiningahan Peter. Ja inali na hi, “Un chah pfu-un he-a chin tinikhaw u hichi na-alu-an an ninitnud ay hija?” ");
INSERT INTO ifu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Enhaot khu Peter ja timmalanuwot chin agwitan. ");
INSERT INTO ifu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Napfalin an nahumarja hi Hesus hichi achaan Kayfas ja naꞌ-arkhaw. Ja in-uy hachi a-ap-apon chi Hudju hija ay Gobernador Pilato. Muti agkhuy himmikhop hachi Hudju ay chuy pfalay na, ti podhon cha an meꞌ-an ay chuy Pfehtan chin Nalohan chin Angher Apo Jos an khun cha ngilinon. ");
INSERT INTO ifu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hotti hi Pilato chi pfimmutay ja inali na ay chicha hi, “Anagkha? Ngay i ju pangchaloman ay tay an takhu?” ");
INSERT INTO ifu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tempfar cha ja inali cha hi, “Ti nu ma-id pfahor na hot agkhuy mi in-ali ay he-a, Apo Gobernador.” ");
INSERT INTO ifu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ja inalin Pilato hi, “Gway urchin ju an Hudju, hotti ekak ju ta chaꞌjuy manugi.” Tempfar hachi Hudju ja inali cha hi, “Achi, ti matoy koma hija, muti achi ju mit apfuluton an chaꞌmi an Hudju chi mamatoy hay pfimmahor.” ");
INSERT INTO ifu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na-at hitay ta mipa-annung chin inalin Hesus an omaꞌ-atan ni atajana. ");
INSERT INTO ifu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Himmikhop khu hi Pilato ay chuy punhumarjaan ja empa-ajag na hi Hesus, ja inali na hi, “Un chah he-a hini arin chi Hudju?” ");
INSERT INTO ifu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ja inalinot Hesus hi, “Narpu chah ay he-a hinuy inalim wenno ngay nangali ay he-a ja un mu allon?” ");
INSERT INTO ifu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ja inalin Pilato hi, “Pfu-unaꞌ Hudju, hotti ngay nanginnilaaꞌ ay he-a? Hachi i-ibpfam an Hudju ja hachi a-ap-apon chi papachi chi nang-ali ay he-a. Hotti ngachah tugwali chi im enat?” ");
INSERT INTO ifu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tempfar Hesus ja inali na hi, “Hini pun-ap-apugwaꞌ ja pfu-un heto lota. Ti nu khulat ta gwah to lota hini pun-ap-apugwaꞌ, hot meꞌpapattoy hana tatakhuꞌ ta achiyaꞌ ichat hay hana Hudju. Muti achiyaꞌ amat ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ja inalin Pilato hi, “Hotti umannung chah an ari a?” Tempfar Hesus ja inali na hi, “Ti niya mah an inalim. Hitay chi khapo na hi immaliyaꞌ heto lota an netoꞌkhong, ta tihtikhuwaꞌ hini umannung. An amin hana mamhod an manginnila ay ni umannung, ja chonglon cha hana alloꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ja inalin Pilato hi, “Ngay ngachah nuy umannung an khun mu hapiton?” Amat hichi ja pfimmutay khu hi Pilato ja inali na hay hachi Hudju hi, “Ma-id chi machakngaꞌ hi hay panghiꞌ-ingan hi pangchaloman ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hotti hay aton ta-o ja hini emmengha an khun ta-o aton, an machakngan ayya hitay Pfehta hon impfu-aaꞌ hay oha hi pfalud an penhod ju an mipfu-aan. Hotti podhon ju ayya ja ipfu-aaꞌ hitay Ari ju an Hudju.” ");
INSERT INTO ifu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ja iniꞌgwap cha gwot an nangali hi, “Achi, pfu-un hija chi penhod mi hi ipfu-aam ta hi Barabas!” Hitay an hi Barabas ja oha an pemmatoy. ");
INSERT INTO ifu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Amat hichi ja impahuplit Pilato hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pfinalengawngaw hachi hinchalo han pagwit ja impihuꞌlub cha chin ulun Hesus an amat hi korona. Ja impilopfong cha han mumpfolah an lopfong an amat hi lopfong chi ari, ");
INSERT INTO ifu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ja numpenpenalog cha an mehnot ay hija an mangali hi, “Madaydayaw a, he-a an Arin chi Hudju,” hon henaplat cha. ");
INSERT INTO ifu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pfimmutay khu hi Pilato ja inali na hachi Hudju hi, “Tayya an ipapfutay u hija ta panginnilaan ju an ma-id chi machakngaꞌ hi hay panghiꞌ-ingan hi pangchaloman ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Amat hichi ja impapfutay cha hi Hesus an nunlolopfong hichin mumpfolah, ja inhuhuꞌlub na chin pagwit an korona. Ja inalin Pilato hachi tatakhu hi, “Tayya, ta emohchong ju hitay an takhu.” ");
INSERT INTO ifu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Unot emmohchong hachi khun munggwarja hichi Templo ja hachi a-ap-apon chi papachi hi Hesus, ja at cha hi nangiꞌgwap an nangali hi, “Epepfakhat mu hija! Epepfakhat mu hay kros!” Ja inalin Pilato hi, “Hotti tayya, ikhad aju an i mangpfakhat. Ti tan ay ha-in ja ma-id mangkay oh-ohhah chinakngaꞌ hi panghiꞌ-ingan hi pangchaloman ay hija.” ");
INSERT INTO ifu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Muti himmapit hachi Hudju ja inali cha hi, “Achi, ti gwa han urchin mi an inlukhangeh na hi nangarjana hi un hija hini Empfalay Apo Jos. Ja hini dusan ni manglukhangeh ay tay an urchin ja mahapor an matoy.” ");
INSERT INTO ifu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Unagkhu chengngor Pilato hichin inali cha ja emmom-omod chin ta-ot na. ");
INSERT INTO ifu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Amat hichi ja himmikhop khu ay chuy punhumarjaan ja inali na ay Hesus hi, “Chaad chi narpugwam?” Muti agkhuy tenomtompfar hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ja inalin Pilato hi, “Anagkha ta achiyaꞌ topfalon ay he-a? Anilam, ha-in chi gway apfalinana an mangpfu-aan ay he-a ja an mangpapfakhat ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tempfar Hesus ja inali na hi, “Aa, muti ma-id ayya hini apfalinam an inchat Apo Jos ay he-a ja un chah la-ahnaon gway ma-at mu ay ha-in? Hotti hini takhu an nangpulang ay ha-in ay he-a, ja hijay machamchamot chi pfahor na.” ");
INSERT INTO ifu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Unagkhu chengngor Pilato chin inalin Hesus ja ente-a na an munnomnom hay atona an mangpfu-aan ay hija. Muti impapilit hachi Hudju an nangiꞌgwap hi, “Nu ipfu-aam ayya hitay an takhu, ja hijay panginnilaan mi an achim apfuluton hini Emperador ad Rome! Hini mangali hi hijay oha an ari ja pfuhur ni Emperador!” ");
INSERT INTO ifu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Unot chengngor Pilato hichin inali cha ja impapfutay na khu hi Hesus, ja i inumpfun ay chuy umpfunan chi hugi ay chuy nachaꞌcha-an an nginadnan hachi Hudju hi Gabata. ");
INSERT INTO ifu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ja ay chuy ja arkhaw an Punhakhanaan cha ay ni Pfehtan chin Nalohan chin Angher Apo Jos. Gwa an mahaꞌ-ad ja inalin Pilato hachi Hudju hi, “Tayya, emohchong ju hitay an Ari ju.” ");
INSERT INTO ifu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Muti iniꞌgwap cha an nangali hi, “Epapatoy mu! Epapatoy mu! Epepfakhat mu hi kros.” Ja inalin Pilato hi, “Un ju chah podhon an epepfakhat u hitay an Ari ju?” Tempfar hachi a-ap-apon chi papachi ja inali cha hi, “Hini Emperador ad Rome chi ari mi ja ma-id uchumna!” ");
INSERT INTO ifu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hotti inunud Pilato hini penhod hachi tatakhu ja impulang na hi Hesus hachi mangpfakhat ay hija. Amat hichi ja initnud hachi hinchalo hi Hesus ");
INSERT INTO ifu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ja impapi-ug cha hichin kros ay hija. Ja emmatam cha ay chuy pfulludna an nangadnan hi Golgota ay ni hapit chi Hudju, an hay podhona an allon ja pfulludna an amat hi ulun chi paang. ");
INSERT INTO ifu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ay chuy an lukhar chi nangpfakhatan cha ay hija ay chuy kros. Ja gwa han chugwa an neꞌchehhan an nepfakhat, ja khinakhawwa cha chin kros Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ja gwa han intulaꞌ Pilato han tabla ja empepfakhat na ay chuy kros Hesus. Hay intulaꞌ na ja, “Hitay hi Hesus an eNazaret, an Arin chi Hudju.” ");
INSERT INTO ifu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chin lukhar an nangpfakhatan cha ay Hesus ja nehnot ad Jerusalem, hotti cho-or chin Hudju hi naloh an namaha chin intulaꞌ Pilato. Nitulaꞌ hi toloh kalahen chi hapit, an hapit chi Hudju ja Griego ja Latin. ");
INSERT INTO ifu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Unagkhu angkhay ay chuy nitulaꞌ ja khun mungngulungur hachi a-ap-apon chi papachi ja icha inali ay Pilato hi, “Agkhuy mu koma intulaꞌ an hija hini Arin chi Hudju. Hay intulaꞌ mu koma ja ‘Inalin tay chi hija hini Arin chi Hudju.’ ” ");
INSERT INTO ifu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tempfar Pilato ja inali na hi, “Hichuy chi enat u an nangtulaꞌ, hotti achi mahukatan.” ");
INSERT INTO ifu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Napfalin an empfakhat cha hi Hesus ja enalan chin apat an hinchalo hachi enaan cha an lopfong na, ja en-ap-apong cha. Enala cha khu chin ohan lopfong na an na-apfor an ma-id nunchaꞌ-itana. ");
INSERT INTO ifu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ja inalin hachi hinchalo hi, “Achi ta-o koma i-ittangon hitay ta un ta-o pumpfilingan ta nangamong hay mangala.” Enat cha ja nipa-annung hitay nitulaꞌ an Hapit Apo Jos hi nangarjana hi, “Khinakhaggwa cha hana lopfong u, ja numpfipfilingan cha hini na-apfor an lopfong u.” ");
INSERT INTO ifu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ja timmataꞌchug hi inan Hesus ja han ibpfan ina na an pfupfai, ja hi Mary an ahagwan Klopas, ja hi Mary Magdalen, an nenehnot cha ay chuy kros na. ");
INSERT INTO ifu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Unot inudhungan Hesus chin ammod na ja chin ohan adalana an penenpenhod na an niꞌtataꞌchug, ja inali na chin ammod na hi, “Ina, hinuy adalan u chi ipfilang mu hi empfalay mu ad ugwani.” ");
INSERT INTO ifu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ja inali na khu ay chuy an adalana hi, “Ipfilang mu hija hi inam.” Hotti nete-a ay chuy ja in-anamut chuy adalana hi Mary ta mihihidchi pfalay cha. ");
INSERT INTO ifu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Inannilan Hesus an napfalin an amin hini nichat an tamuwana heto lota, ja inali na hi, “Tayya an na-ugagaꞌ.” Inali na hitay ta mipa-annung chin nitulaꞌ an Hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ja gwa han malokong hichi an nanapnu hi pfajah an pfimmanger. Hotti enalan hachi hinchalo ja entamor cha han omaꞌ-at hi apoh ay chuy an pfajah ja empa-aw na han paor, ja intumuꞌ cha ay chuy ta-o na ta inumona. ");
INSERT INTO ifu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Unot hinihip Hesus hichuy pfimmanger an pfajah ja inali na hi, “Tan napfalin hini tamuwaꞌ heto lota.” Injungjung na ja na-ongoh chin hochohcha na. ");
INSERT INTO ifu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Amat hichi ja immuy hachi a-ap-apon chi Hudju ay Pilato an i nangippug ta ipa-ipong cha hachi hu-in hachi tolo an takhu an nepfapfakhat ay chuy kros cha, ta gway aton cha an matoy ja un cha opahon chicha. Hay nangatan cha ja Alemana an arkhaw chi punhakhanaan cha ay ni pfehta, ja Hapfachu an ngilin chi Hudju chin nun-inggwiꞌgwiit, hotti ma-id koma mepfapfakhat hi takhu ay chuy an Hapfachu, om-omod ay chuy an pfehta. ");
INSERT INTO ifu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Inapfulut Pilato hotti immuy hachi hinchalo an i numpangipong hachi hu-in hachi chugwa an neꞌchehhan ay Hesus an nepfakhat. ");
INSERT INTO ifu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Muti un chaagkhu nehnot ay Hesus ja tinnig cha an natoy, hijaot un cha agkhuy niꞌ-ipong chin hu-i na. ");
INSERT INTO ifu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Oha ay cha chuy hinchalo chi nangchuhag ay chuy huꞌ-ud na chin taglang Hesus ja immajuh hachi chala ja chanum. ");
INSERT INTO ifu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ha-in an nangtulaꞌ ay tay ja alloꞌ ay chaꞌju hi umannung hitay intulaꞌ u, ti ha-in chi oha an nannig ay tay an na-at ay Hesus. Enhamad u an nanihtikhuwan ay tay umannung an na-at ta gway aton ju khu an mamati. ");
INSERT INTO ifu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ti na-at hay hato ta mipa-annung hini nitulaꞌ an Hapit Apo Jos hi nangarjana hi, “Ma-id oh-ohhah ma-ipong ay ni tungar na.” ");
INSERT INTO ifu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ja gwa khu han oha an nitulaꞌ an Hapit Apo Jos hi nangarjana hi, “Tikhagwun cha hichuy an takhu an chinuhag cha.” ");
INSERT INTO ifu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Napfalin hay hato ja gwa han oha an lala-e an immuy ay Pilato an hi Josep an e-Arimatea. Hitay an lala-e ja oha an disipolon Hesus muti agkhuy na impa-innila khapo hi ta-ot na hachi a-ap-apon chi Hudju. Immuy ay Pilato an i nangippug ta i na ilupfuꞌ chin achor Hesus, ja inapfulut Pilato. Hotti enala na chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ja niꞌjuy hi Nikodemus an chin i niꞌhapit ay Hesus chin ohan nadhom. Ja inugnana han mumpfango an porpoh an mira an nala-okan hi aloes, an nahulok hi tolompoloh kilo. ");
INSERT INTO ifu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Amat hichi ja enekak cha chin achor Hesus ja i cha enala han pfakhu an maphod an pfinacha. Khun cha ittugwan hi porpoh hon enlepfod cha chin achor na, ti hijah tay chi ugalin chi Hudju nu gway ilupfuꞌ cha hi natoy. ");
INSERT INTO ifu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ay chuy pangnger chin nangpfakhatan cha ay Hesus ja gwa han na-alu-an an agwachaan han paꞌ-ephod an lupfuꞌ an lijang an ma-id pay i nilupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ay chuy ja arkhaw an Punhakhanaan chi Hudju chin umali an Hapfachu ja khapo ta gwa an machakngan chin ngilin, ja hitay nenehnot an lupfuꞌ chi nang-ajan cha chin achor Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Unot nun-inggwiꞌgwiit an Markhachu an nalahin chin ngilin, ja pfimmugwah hi Mary Magdalen an immuy ay chuy nilub-an Hesus. Ja nangalimutugwana an na-ulin chin pfato an tanglib. ");
INSERT INTO ifu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Amat hichi ja temmagtag hi Mary an immuy ay cha Simon Peter ja chin oha an adalan an penpenhod Hesus. Ja inali na ay chicha hi, “Enala cha chin achor Apo ta-o ti ma-id hichi lupfuꞌ, ja ma-id machotoꞌ hi i cha nang-ajan.” ");
INSERT INTO ifu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ja unot inalin Mary hitay ja empacheh cha Peter an umuy hichi lupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nun-etagtag cha ja ma-aher chin oha mu hi Peter, hotti nahhun an ne-atam. ");
INSERT INTO ifu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ja unaagkhu inhichip ja tinnig na chin namiꞌlug cha ay Hesus an negwagwallang, muti agkhuy himmikhop. ");
INSERT INTO ifu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Neꞌ-atam khu hi Simon Peter ja nunchapchapoh an himmikhop ay chuy lupfuꞌ. Ja tinnig na chin pfinacha an negwagwallang, ");
INSERT INTO ifu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ja chin oha an pfinacha an nepapattang chin pangngerna an naloh-op chin ulun Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ja niꞌhikhop khu chin ohan adalan an nahhun an ne-atam, ja niꞌtikhaw na chin emmaꞌ-atana ja pinati na an nummahu hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ti agkhuy cha pay na-awatan hini nitulaꞌ an Hapit Apo Jos an mahapor an mummahu hija. ");
INSERT INTO ifu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Amat hichi ja immanamut hachi chugwa an adalan. ");
INSERT INTO ifu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hi Mary ayya ja nuntaynan an timmataꞌchug an khun kumila hichi lupfuꞌ. Unaagkhu inhichip chin lupfuꞌ ");
INSERT INTO ifu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ja tinnig na han chugwa an angher Apo Jos an nunlolopfong hi mumpuchaw. Inu-umpfun cha chin negwagwallangan chin pfinacha an namuttiput cha ay Hesus. Inu-umpfun chin oha ay chuy nun-appit hi ullugwan ja inu-umpfun chin oha ay chuy unchayyan. ");
INSERT INTO ifu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Empfokhan hachi angher ay hija hi, “Anagkha ta khun a kumila?” Tempfar na ja inali na hi, “Tayya an enala cha chin achor Apo Hesus ja ma-id machotoꞌ hi i cha nang-ajan.” ");
INSERT INTO ifu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Inali na hitay ja nunggwingi, ja tinnig na han takhu an timmataꞌchug, muti agkhuy na immatunan un hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Himmapit hi Hesus ja inali na hi, “Anagkha ta kumila a? Ngachah ni hingitom?” Khemhon Mary un hija hini khun mumpfantay ay chuy an lukhar, hijaot una inali hi, “Nu he-a ayya adniꞌ, ibpfaꞌ, chi nangala ay ni achor Hesus ja ituchum hini nang-ajam ta ujaꞌ alaon.” ");
INSERT INTO ifu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Inalin khu Hesus ay hija hi, “Mary” ja nang-inliligkhoh hi Mary ja inali na hi, “Raboni!” an hay podhona an hapiton ja mehtolo ay ni hapit chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ja inalin khu Hesus ay hija hi, “Achiyaꞌ ug-ugnan ti agkhujaꞌ pay numpfangngad ay Ama. Hay atom ja un aot umuy hana i-ibpfaꞌ an disipoloꞌ ta allom ay chicha hi mumpfangngachaꞌ ay Ama an hijay Ama ju khu, ja Jos u an Jos ju khu.” ");
INSERT INTO ifu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hotti empacheh Mary ja immuy ay cha chuy disipolon Hesus ja inali na hi, “Umannung an tinnig u hini Apo ta-o.” Ja impa-innila na hachi inalin Hesus ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chin nadhom ay chuy an Markhachu ja na-amung hachi disipolon Hesus han pfalay. Ja incha-ig cha hachi pantaw, ti toma-ot cha hachi a-ap-apon chi Hudju. Unagkhu himpfumagkha ja gwacha hi Hesus an timmataꞌchug ay chuy nuntotongngaan cha, ja inali na hi, “Hay lenong chi magwacha ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Empa-opoh na an inali hitay ja impatikhaw na chin ngamoy na ja taglang na an napfilatan. Ja mun-an-anla hachi disipolo na an nannig ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Impiggwan Hesus an nangali hi, “Hay lenong chi magwacha ay chaꞌju.” Ja entoptop na an nangali hi, “Honakhoꞌ chaꞌju an i muntudtuchu, an amat ay ni enat Ama an nannag ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Inhapud na ay chicha ja inali na hi, “Magwachaan aju ay ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hijay mangtuchugwan ay chaꞌju ta hana ayya allon ju an napakawan chi pfahor na janapakawan, ja hana ayya allon ju hi agkhuy napakawan chi pfahor na ja agkhuy.” ");
INSERT INTO ifu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ay tay an numpatikhagwan Hesus hay hachi disipolo na, ja netongor ja ma-id chin oha ay cha chuy adalana an hi Tomas, an nginadnan cha hi Nun-eper. ");
INSERT INTO ifu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ja impa-innilan hachi uchumna an disipolon Hesus ay Tomas an tinnig cha hini Apo cha. Muti inalin Tomas hi, “Mahapor an tikhaꞌ ja inaploh u hini pfilat ni ngamoy na, ja mahapor an aplohoꞌ khu hini taglang na an natuggwiꞌ. Achiꞌ ayya ja achiyaꞌ mamati an nummahu hija.” ");
INSERT INTO ifu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Unot immuy chi ohay markhachu ja na-am-amamung khu hachi disipolon Hesus ja niꞌ-amung hi Tomas. Nichacha-ig khu hachi pantaw chuy pfalay an a-adchaan cha muti anong un emmat ja himmikhop chamchama hi Hesus, ja timmaꞌchug ay chuy nuntongngaan cha, ja inali na hi, “Hay lenong chi magwacha ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ja inali na ay Tomas hi, “Tayya hato ngamoy u, hot umali a ta aplohom hato pfilat. Ja niꞌ-aploh mu khu hitay taglang u. Achi a humalihalinchugwa ta un a gwot mamati.” ");
INSERT INTO ifu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ja inalin Tomas hi, “Aa, he-a chi Apoꞌ ja Jos u.” ");
INSERT INTO ifu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ja inalin khu Hesus ay hija hi, “Namati a ti tinikhagwaꞌ. Muti akhaꞌkhaja hana tatakhu an anong unaꞌ achi tikhan ja mamati cha ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cho-or pay chin en-enat Hesus an tinnig hachi disipolo na an nangpatikhaw ay ni apfalinana an agkhuy nitulaꞌ ay tay an libju. ");
INSERT INTO ifu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Muti hay hato chi piniliꞌ an intulaꞌ ta gway aton ju an mamati an hi Hesus ja hija hini Empfalay Apo Jos an hini Hennag na an Mamahhod, ja ta magwachaan aju hi nahamad an piꞌtakhuwan khapo hi pidchuman ju ay hija. ");
INSERT INTO ifu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gwacha khu han ohan arkhaw an numpatikhagwan hi Hesus hay hachi adalana ay chuy pingngit chi Baybay an Tiberias. Ja amat heto chin enat na an numpatikhaw ay chicha. ");
INSERT INTO ifu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ay chuy an arkhaw ja nunchichittum cha Simon Peter, ja hi Tomas an nangadnan hi Nun-eper, ja hi Nataniel an eKana ad Galilee, ja hachi chugwa an empfalay Zebedee, ja han chugwa pay an adalan Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Inalin Simon Peter hachi numpun-ibpfa na hi, “Tan ujaꞌ manapfukur.” Ja inali cha hi, “Hot umuy a ayya ja miꞌjali ami.” Amat hichi ja empacheh cha an i nunlukhan han pfalangay. Timmu-ar cha an manapfukur ingkhana hi nagwa-ah, muti ma-id oh-ohha hi enala cha. ");
INSERT INTO ifu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Unagkhu gwa an nagwa-ah ja timmataꞌchug hi Hesus ay chuy pingngit chi baybay, muti agkhuy cha immatunan. ");
INSERT INTO ifu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Himmapit hi Hesus ja inali na hi, “Omod, gwacha chah chi khinachiw ju?” Tempfar cha ja inali cha hi, “Ma-id numpay oh-ohha.” ");
INSERT INTO ifu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ja inalin khu Hesus hi, “Ituud ju hinuy tapfukur ju ay ni nun-appit hi agwan ni pfalangay hot gwa han ma-ala ju.” Enat cha ja un chaagkhu lenom an mangujud chin tapfukur ja ad-adchi cha, ti naꞌ-apnu hi khachiw. ");
INSERT INTO ifu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chin oha an adalan an penpenhod Hesus ja inali na ay Peter hi, “Hot anagkha ay chita an un hi Apo Hesus hichuy.” Unot inannilan Simon Peter an hi Hesus hini himmapit, ja inlopfong na chin enaꞌ-aana an lopfong ja emmaꞌpfaw an himmalug, ja chimma-ar hichi pingngit na an agawwachaan Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chin pfalangay ja achi achawwi ay chuy pingngit na, ti un hingkhahot hi mitlu chi inachawwi na. Hotti chin ayya numpun-ibpfan Peter ja khun cha eh-ehnot chin pfalangay ay chuy pingngit na, ja khun cha khu khujuchon chin tapfukur an napnu hi khachiw. ");
INSERT INTO ifu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gwa an emmatam cha ay chuy palantagna ja tinikhaw cha han apoy. Ja gwa han nenegkhong an khachiw ja han tenapay an negwagwallang. ");
INSERT INTO ifu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ja inalin Hesus ay chicha hi, “Ijali ju hay tortollo ay nuy khinachiw ju.” ");
INSERT INTO ifu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Amat hichi ja immuy hi Simon Peter ay chuy pfalangay ja encha-ar na chin tapfukur an naꞌ-apnu hi o-otong an khachiw. Hay pfilang na ja hingkhahot ta han lemay polo ta han tolo (153). Ja anong un at hichi chin pfilang hachi khachiw ja agkhuy napaꞌ-i chin tapfukur. ");
INSERT INTO ifu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Inalin Hesus ay chicha hi, “Umali aju ta mangan ta-o.” Ja khun mun-ong-ongang hachi adalan an mangali hi, “Ngay ngachan mu?” muti immatunan cha an hija hi Hesus. ");
INSERT INTO ifu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ja enalan Hesus chin tenapay ja empapong na, ja enat na khu chin khachiw. ");
INSERT INTO ifu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hitay chi me-atlo an numpatikhan Hesus hachi adalana nete-a chin nummahuwana. ");
INSERT INTO ifu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Napfalin an nangan cha ja inalin Hesus ay Simon Peter hi, “Simon, an empfalay John, ot-ottong chah hini pamhod mu ay ha-in mu hini pamhod cha tay i-ibpfam?” Ja inalin Peter hi, “Aa, Apo, anilam an podpodhoꞌ he-a.” Ja inalin khu Hesus hi, “Hotti ipahtulam hana tatakhu an namati ay ha-in, an amat hi pahtor an mun-enchog hi pfoꞌtot an karnero.” ");
INSERT INTO ifu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ja impiggwan Hesus an nangali ay Peter hi, “Simon, an empfalay John, podpodhonaꞌ chah ay he-a?” Ja inalin Peter hi, “Aa, Apo, anilam an podpodhoꞌ he-a.” Ja hin-inalin khu Hesus hi, “Hotti halimunam hana tatakhuꞌ an namati ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ja impitlon Hesus an nangali hi, “Simon, an empfalay John, podpodhonaꞌ chah ay he-a?” Loꞌtat ja pimmukhit chin punleꞌnaan Peter hi nangpiggwapiggwaan Hesus an nangali hi, “Podpodhonaꞌ chah ay he-a?” Ja inalin Peter hi, “Apo, anilam an podpodhoꞌ he-a, ti anilam an amin.” Ja inalin Hesus hi, “Hotti halimunam hana tatakhuꞌ. ");
INSERT INTO ifu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Umannung hitay alloꞌ ay he-a an chin a-ungam ja un a ikhad hon en-apjam chi pfalekeh mu. Ja nu gway penhod mu hi omajan ja immuy a. Muti unchani ta mala-ay a, hot uꞌjachom hana ngamoy mu ja kha-utan chi-a ta ijuy chi-a ay ni achim podhon an omajan.” ");
INSERT INTO ifu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Inalin Hesus hitay ta impa-innila na hini aton Peter an matoy ta michat hini dayaw ay Apo Jos. Ja entoptop na an nangali ay Peter hi, “Unuchonaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nunligkhoh hi Peter ja tinnig na an khun mangunud chin ohan adalan an penpenhod Hesus. Hija hichin nenehnot ay Hesus chin nanganan cha an nangali ay Hesus hi, “Apo, ngay ngachan ni mangpfaag ay he-a hana pfuhur mu?” ");
INSERT INTO ifu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Unot tinnig Peter ja inali na ay Hesus hi, “Apo, hichuy mah ibpfaꞌ, ngay ma-at ay hija?” ");
INSERT INTO ifu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ja inalin Hesus hi, “Achi khahin un mu annilaon. Ti ikhachaꞌ nu alloꞌ hi matattakhu ingkhana hi pumpfangngachaꞌ. Muti ay he-aot niꞌ an hay alloꞌ ja unuchonaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Khapo ay tay an inalin Hesus ja gwa hana namati an khun mangali hi achi anu matmatoy hitay an adalan Hesus. Muti ma-id inalin Hesus hi amat heto, an un hay inali na ja, “Ikhachaꞌ nu alloꞌ hi matattakhu ingkhana hi pumpfangngachaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ha-in an nangtulaꞌ ay tay, ja ha-in chin adalan an penenpenhod Hesus, ja ha-in hitay khun muntihtikhu an amin hato nitulaꞌ ay tay an libju. Ja anila mi an umannung hay hato intulaꞌ u. ");
INSERT INTO ifu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Achi angkhay hay hato chi enat Hesus, ti cho-or pay. Nu amoton an itulaꞌ hot ad-adchi hitay lota hi pegwallangan chi alibjulibju an mephod.");
INSERT INTO ifu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chin nahhun an intulaꞌ u, Apo Teofilus, ja intulaꞌ u an amin chin ena-enat Hesus ja chin intudtuchu na chin nangte-aana an i nuntudtuchugwan ");
INSERT INTO ifu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ingkhana chin timmalakhujana ad langit. Chin agkhuy na pay timmalakhujan ja gwa hana imbilina hachi pinili na an apostol khapo ay ni apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Napfalin an natoy ja nummahu ja ingkhana chin timmalakhujana ad langit ja apat chi polo hi arkhaw an khun mumpatikhaw hay hachi apostol na. Ja cho-or chin ena-enat na an nanginnilaan cha an umannung an nummahu hija, ja khuna ituchu ay chicha hini omaꞌ-atan ni Pun-ap-apugwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja gwacha han ohan arkhaw an neꞌ-anan Hesus hachi apostol ja inali na ay chicha hi, “Achi aju makak heto ad Jerusalem ta hachon ju hini ingkarin Jos Ama an ipa-ali na hini Espiritu Santo ay chaꞌju, an hijah tay chin inaliꞌ ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Binautisaran John hana tatakhu hi chanum muti achi mapfajag hot mabautisaran aju hi Espiritu Santo.” ");
INSERT INTO ifu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gwacha khu han namenghan an na-amungan hachi disipolo na, ja numpatikhaw hi Hesus ay chicha ja empfokha cha ay hija hi, “Apo, unchah ad ugwani chi pangepfangngacham ay tay khupferno ay chita-o an holag Israel?” ");
INSERT INTO ifu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ja inalin Hesus hi, “Achi mapfalin an annilaon ju, ti ikhad hi Jos Ama an nangeꞌcha hi timpo an a-atan hana maꞌma-at. ");
INSERT INTO ifu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Muti ipa-innilaꞌ an umali hini Espiritu Santo ay chaꞌju ta magwachaan aju hi apfalinan an i manihtikhuwan ay ha-in heto ad Jerusalem, ja an amin hi pfuglay ay tay an provincia ad Judea, ja hichi provincian chi Samaria, ja an amin hi apfuglapfuglay.” ");
INSERT INTO ifu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Unot inalin Hesus hitay ja timmalakhuy ad uchu ja khun cha pachipchipuhan ingkhana an hinalinan chi pfonot. ");
INSERT INTO ifu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tenattangad cha ad uchu ja unagkhu himpfumagkha ja gwacha han chugwa an linala-e an nunlolopfong hi mapuchaw an niꞌtataꞌchug. ");
INSERT INTO ifu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ja inalin chuy chugwa hi, “Chaꞌju an eGalilee, anagkha ta tatangngachon ju ad uchu? Hitay an hi Hesus an tinnig ju an immuy ad langit, ja umali han arkhaw an mumpfangngad heto lota an midchum hi pfonot, an hihiya ay tay tinnig ju hi timmalakhujana ad langit.” ");
INSERT INTO ifu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Napfalin hitay an na-at ay chuy pfulludna an Olibo ja numpfangngad hachi apostol hichi ad Jerusalem an ohay kilumitluy inachawwi na. ");
INSERT INTO ifu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ne-atam cha ad Jerusalem ja immuy chaot ay chuy nangennaꞌjab an kwarto an khun cha punnangngan. Ja hay ngachan hay hachi apostol ja hi Peter, ja hi John, ja hi James, ja hi Andrew, ja hi Philip, ja hi Tomas, ja hi Bartolomew ja hi Matthew, ja hi James an empfalay Alfeus, ja hi Simon an oha an Zealot, ja hi Judas an empfalay James. ");
INSERT INTO ifu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ja hay empachot-anan cha an aton ja khun cha mun-oh-ohha an amin an mungkalalag. Ja khun midchum hachi uchumna an pfinapfai, ja hi Mary an ammod Hesus, ja hachi a-akhi na an linala-e. ");
INSERT INTO ifu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Immuy chi at hichi hi arkhaw ja gwahna cha khu an na-amung hachi namati, ja hay pfilang cha ja hingkhahot ta han chugwampolo. Ja timmaꞌchug hi Peter ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“A-akhiꞌ, mahapor an mipa-annung chin hapit Apo Jos an impa-innilan ni Espiritu Santo ay Ari David. Chin intulaꞌ Ari David ja nipa-annung ay Judas an hijay nangpangulu hachi naniliw ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ja anila ta-o an oha hi Judas ay chaꞌmi an apostol, ti hija chi oha an napili an miꞌtamu ay tay tamu mi.” ");
INSERT INTO ifu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hitay chi na-at ay Judas. Chin pihu an linagpfuna hi nangatanah napukhit ja eneplaꞌ cha han lota. Hichuy lota chi nakhahana ja napfughi chin poto na ja natoy. ");
INSERT INTO ifu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chengngor an amin hachi tatakhu ad Jerusalem hitay an na-at, hijaot un cha nginadnan hichuy lota an nakhahana hi Akeldama, an hay penhod na an allon ja Lota an Negwaꞌgwa-an hi Chala. ");
INSERT INTO ifu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ja inalin khu Peter hi, “Chin intulaꞌ David han ohan Psalm ja, ‘Un koma adniꞌ mapfau hini pfalay na ta ma-id munhetheto.’ Ja allon ni oha khu an Psalm hi ‘Gwacha koma hay mepallog ay tay an tamu na.’ ");
INSERT INTO ifu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Hotti mahapor an piliyon ta-o hay mihukat ay Judas ta midchum ay chaꞌmi an apostol an manihtikhuwan chin nummahuwan Apo Hesus. Hay piliyon ta-o ja mahapor an oha hija an khun mitnud ay chaꞌmi an disipolon Hesus chin agawwachaana heto lota, nete-a chin numpabautisarana ay John ingkhana chin timmalakhujana ad langit.” ");
INSERT INTO ifu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ja inalin hachi na-amung han ngachan han chugwa an lala-e an pumpiliyan cha, an cha Josep Justus an mungngachan khu hi Barsabas, ja hi Mattias. ");
INSERT INTO ifu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ja nungkalalag cha ay Apo Jos an inali cha hi, “Apo Jos, he-a chi nanginnila an amin hi nomnom chi takhu, hotti ipa-innilam hini pinilim ay cha tay chugwa ");
INSERT INTO ifu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ta mihukat ay Judas an apostol. Ti chin-ug Judas hini kina-apostol na ja immuy ay ni neꞌcha an immajana.” ");
INSERT INTO ifu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Napfalin cha an nungkalalag ja imbonot cha chin ngachan chin chugwa ja hay nabonot ja chin ngachan Mattias, hotti hijay nidchum chin himpolo ta oha an apostol. ");
INSERT INTO ifu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nachakngan chin pfehta an Pentekostes ja na-amung an amin chin namati ay Hesus han oha an pfalay. ");
INSERT INTO ifu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ja unagkhu himpfumagkha ja gwa han chengngor cha an mumpfuluud an amat hi mapfi-ah an ijah an narpu ad uchu, ja nun-onan ay chuy an pfalay an agawwachaan cha. ");
INSERT INTO ifu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ja tinnig cha han amat hi chalang chi apoy an numpun-ohop hi oha-ohanna ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ja nagwachaan cha an amin ay ni apfalinan ni Espiritu Santo ja ente-a cha an hihahapit hi numpfino-ob-on an hapit, ti hijay enchalan ni Espiritu Santo hi hapiton cha. ");
INSERT INTO ifu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ay chuy an timpo ja cho-or hachi Hudju ad Jerusalem an nehamad chi aton cha an miꞌ-unud ay ni urchin Apo Jos, ja narpu cha hi numpfino-ob-on an apfuglapfuglay an numpfino-ob-on chi hapit cha. ");
INSERT INTO ifu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ja un chaagkhu chengngor chin hingalangala ja na-amung hachi cho-or an tatakhu ay ni gwachaan hachi namati. Ja nanor cha ti un oha-ohanna ay chicha hon chengngor na hini hapit na an khun ihapit hachi namati. ");
INSERT INTO ifu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ja nanor cha ja inali cha hi, “Anagkha ta amat heto? Unchah pfu-un eGalilee hay hato? ");
INSERT INTO ifu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Muti anagkha mah ta gwahchinonon hon chengngor ta-o hini numpfino-ob-on an hapit ta-o an agkhuy cha jaꞌ anila? ");
INSERT INTO ifu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ja tan gwahto ta-o an ePartia, eMedia, e-Elam, ja gwahto hato eMesopotamia, eJudea, eKapadosya, ja gwahto khu hato ePontus, ja e-Asia, ");
INSERT INTO ifu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","eFrigia, ePamfilia, e-Egypt, ja hato narpu hachi apfuglapfuglay ad Libya an nehnot ad Cyrene, ja anong un hato eRome. ");
INSERT INTO ifu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ja Hudju chi uchumna ay chita-o jaHentil chi uchumna an khun miꞌ-unud ay ni tudtuchun chi Hudju. Ja gwahto khu hato eKrete ja e-Arabia. Ja an amin hana numpfino-ob-on an hapit ta-o, ja tayya an chonglon ta-o an ihapit cha ay ni pangarjan cha hana maphod an khun aton Apo Jos an mangpatikhaw ay ni kinapfagto na.” ");
INSERT INTO ifu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ma-id machotoꞌ hi nomnomon cha, ja khun cha manghinpfopfogkha an allon cha hi, “Anaad ay chita ta amat heto? Ngachah chi podhona an hapiton?” ");
INSERT INTO ifu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Muti hachi uchumna ja kenekejan cha hay hachi an namati ja nun-ali cha hi, “Un mangkay nun-apfutong hay hachi!” ");
INSERT INTO ifu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Timmaꞌchug hi Peter ja hachi himpolo ta oha an ibpfa na an apostol ja iniꞌgwap na an nangali hachi atakhutakhu hi, “Chaꞌju an papadchung u an Hudju ja chaꞌju an amin an neꞌheto ad Jerusalem, ekhongahan ju akay niꞌ hitay alloꞌ ta annilaon ju nu ngay amatana. ");
INSERT INTO ifu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Khemhon ju gwot unami nun-apfutong muti agkhuy ami ti ma-id pay uminum hi nungkhagwa. ");
INSERT INTO ifu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hitay na-at ay chaꞌmi ja hijah tay chi nipa-annungan chin inalin chin profetan Apo Jos an hi Joel hichin hopapna hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Hitay chi allon Apo Jos. Chin angonoh chi ar-arkhaw ja ipa-aliꞌ hini Espirituꞌ an amin hi tatakhu, hot ipadtun hana empfapfalay ju an linala-e ja pfinapfai hay podhoꞌ an ipa-innila ay chaꞌju, ja tikhan hana ungunga an linala-e hay ipatikhaw u ay chicha, ja empon hana lallakay hay epa-enop u ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja anong un hana pfaar an linala-e ja pfinapfai an namati ay ha-in, ja piꞌchataꞌ khu chicha hi Espiritu Santo ay nuy an arkhaw ta ipadtu cha hana ipa-innilaꞌ ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ja gwacha hana atoꞌ hichi ad uchu ja hina lota an nabnab-on an mangpatikhaw hi apfalinaꞌ, hot tikhan chi tatakhu heto lota hay chala ja apoy ja cho-or an ahoꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Homelong hichuy hukhit ja pfumlah hichuy pfulan an amat hi chala ja unot machakngan chin ma-id ipadchungana an arkhaw an panugijan Apo Jos hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Muti an amin hana takhu an mumpfokha hi tolong ay ha-in ja takhuwoꞌ chicha an allon Apo Jos.’” ");
INSERT INTO ifu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Entoloy Peter an munhapit ja inali na hi, “Chaꞌju an papadchung u an holag Israel, chonglon ju adchiya hitay alloꞌ. Hi Hesus an eNazaret ja cho-odcho-or chi milagro an enat na heto pfuglay ju, ti inchat Apo Jos hini apfalinana an mangat hana achi kayan chi tatakhu an aton, ta annilaon ju an hi Apo Jos chi nannag ay hija. Anila ju an umannung hitay. ");
INSERT INTO ifu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hitay an hi Hesus ja ne-agwat ay chaꞌju ja empapatoy ju hana napukhit an tatakhu ta empfakhat cha hi kros. Muti hini umannung an omaꞌ-atana ja hitay hini nipa-annungan chin eneꞌchan Apo Jos an ma-at. ");
INSERT INTO ifu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Empapatoy ju muti minahuwan Apo Jos hija ta amehona hini patoy, ti achi mapfalin an munchochodcha hija ay ni patoy. ");
INSERT INTO ifu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hi Hesus chi nipa-annungan chin intulaꞌ Ari David chin hopapna hi nangarjana hi, ‘Apo, achiyaꞌ toma-ot, ti anilaꞌ an gawwacha a ay ha-in ja khunaꞌ tulungan an amin hi timpo. ");
INSERT INTO ifu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hijaot unaꞌ mun-an-anla ja khun u tihtikhuwan hini aphocham, Apo. Ja anong un matoy hitay achor u ja munchomo-aꞌ ay ni inalim Apo Jos an atom. ");
INSERT INTO ifu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ti ha-in an naꞌna-unnud an empfalay mu ja anilaꞌ an achiyaꞌ taynan hichi lupfuꞌ ja achim apfuluton an mapfuluꞌ hitay achor u. ");
INSERT INTO ifu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ti impa-innilam ay ha-in hini atoꞌ ta miꞌtakhuwaꞌ ay he-a hi ma-id chi pogpogna. Ja he-ay pun-i-ibpfaꞌ, hijaot un munnaud chi pun-an-anlaaꞌ.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Entoloy Peter an nunhapit ja inali na hi, “A-akhiꞌ, umannung hitay alloꞌ ay chaꞌju, an natoy hi David ja nilupfuꞌ hini achor na, ja ingkhana ad ugwani ja matikhaw ju an gawwah to lota hini lupfuꞌ na, hotti pfu-un hini achor na chi khuna hapiton ay tay. ");
INSERT INTO ifu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Oha hi David an profeta an nanghapataan Apo Jos an piliyona hay ohah holag na ta mun-ari hi uchum chi tagwon an amat ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Inannilan David an mahuwan Apo Jos hinuy an holag na an hija hini Hennag Apo Jos an Mamahhod. Hotti hitay Mamahhod chi impadtu na an achi mataynan hichi lupfuꞌ ja achi mapfalin an mapfuluꞌ hini achor na. ");
INSERT INTO ifu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hitay an hi Hesus ja hija hini mamahhod an minahuwan Apo Jos. Ja tihtikhuwan mi an umannung hitay, ti umannung an tinnig mi an amin an nummahu. ");
INSERT INTO ifu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Timmalakhuy ad langit ja nipapfagto ay ni nun-appit hi agwan Apo Jos. Ja inchatan Ama na hi apfalinana an mangpa-ali ay ni Espiritu Santo ti hijah tay chi ingkari na. Hotti hay hato chengngor ju ja tinnig ju, ja enat ni Espiritu Santo an impa-alin Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ti pfu-un hi David chi timmalakhuy ad langit. Hotti pfu-un hini achor na chi hinapit na ay tay intulaꞌ na an, ‘Inalin Apo Jos ay ni Apoꞌ hi, “Umpfun a ay tay nangappit hi agwan u, ");
INSERT INTO ifu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ingkhana hi apfakoꞌ hana pfumuhur ay he-a ta he-ay tangachon cha.”’ ” ");
INSERT INTO ifu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja inalin khu Peter hi, “Hotti paꞌpa-alloꞌ ay chaꞌju an holag Israel, an hi Hesus an empepfakhat ju chin kros ja hijay hennag Apo Jos an mamahhod. Ja hija khu chi impapfagton Apo Jos ta hijay Apo ta-o.” ");
INSERT INTO ifu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Unagkhu chengngor hachi tatakhu hitay inalin Peter ja nunheglay enat cha an nuntutuju, ja inali chaot ay Peter ja chin i-ibpfa na an apostol hi, “A-akhi, ngay mah aton mi?” ");
INSERT INTO ifu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tempfar Peter ja inali na hi, “Chuꞌkhon ju gwot an amin hana pfahor ju ja numpabautisar aju an amin ta ipatikhaw ju an hi Hesu Kristo chi Apo ju, ta mapakawan an amin chi pfahor ju ja un ichat Apo Jos hini Espiritu Santo ay chaꞌju. ");
INSERT INTO ifu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ti hitay chi ingkarin Apo Jos, an ipa-ali na hini Espiritu Santo ay chita-o ja hana empfapfalay ta-o ja an amin hana uchumna an tatakhu hi apfuglapfuglay an ajakhana an midchum ay hija.” ");
INSERT INTO ifu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ja cho-or pay chin inalin Peter ja enhamhamad na an nuntukhun an inali na hi, “Mamati aju ay Hesus ta miꞌtakhu aju ta achi aju midchum ay ni adusaan hana tatakhu ad ugwani an napukhit chi ugali cha an achi mamati.” ");
INSERT INTO ifu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Cho-or chay namati chin inali na ja numpabautisar cha gwot ja umuy hi toloy lipfu hana nidchum an namati ay Hesus ay chuy an arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ja impapati cha an khun mun-achar ja an miꞌ-unud hay hana itudtuchun hachi apostol. Ja khun cha munlalammong ja mun-oh-ohha cha an mungkalalag ja an mangan ay ni pangnomnoman cha chin natajan Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hachi atakhutakhu ja narmu chin ta-ot cha ay Apo Jos hichin nannikhan cha hachi cho-or an milagro an ena-enat hachi apostol an nangpatikhaw hi apfalinan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Amat hichi ja khun ma-am-amamung hachi namati ja khun cha manghin-i-idchat hi mahapor chi oha-ohanna ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Uchumna ja ingngina cha hay khina-u cha ta gway ichat cha hay hana munlikhat an me-okor ay ni mahapor cha. ");
INSERT INTO ifu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A-arkha-arkhaw hon nun-oh-ohha cha an immuy hichi Templo. Ja khun cha ma-amung an mangan hichi pfarpfalay cha an gwachaan hi an-anla, ja ma-id na-ikot ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ja khun cha mundaydayaw ay Apo Jos, ja penhod an amin chi tatakhu hana maphod an ugali cha. Ja enarkhaw an khun ug-ugman Apo Jos hachi namati an tinakhuna. ");
INSERT INTO ifu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gwacha han himpumupujaw ja niꞌjuy cha Peter ay John hichi Templo ay ni oras an khun pungkalalakhan. ");
INSERT INTO ifu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ja gwacha han ohan napilay an lala-e an achi chumalan nete-a chin nituꞌkhungana. A-arkha-arkhaw ja khun cha ijuy hichi Templo hon impapfun cha ay ni pantaw an nginadnan cha hi Maphod, ta mun-achaw hi pihun hana humikhop. ");
INSERT INTO ifu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Gwa an tinnig na cha Peter ay John an humikhop cha ja nun-achaw hi hay ichat cha. ");
INSERT INTO ifu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ja emmohchong cha hija ja inalinot Peter hi, “Mohgwaton chaꞌmi.” ");
INSERT INTO ifu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ja emmohgwat na ay chicha ja hehennod na hay ichat cha. ");
INSERT INTO ifu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Muti inalin Peter hi, “Ma-id oh-ohha hi pihuꞌ muti hini gwacha ay ha-in ja hijay itolong u ay he-a. Tomenong a khapo ay ni apfalinan Hesu Kristo an eNazaret, hotti tumaꞌchug a ja chimmalan a.” ");
INSERT INTO ifu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ja penchon Peter chin agwan an ngamoy na ta tulungana an tumaꞌchug. Unagkhu hin-aꞌ-alina ja na-anchong chin hu-i na ");
INSERT INTO ifu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ja nelaneggwat ja chimmalan ti temmenong. Ja niꞌhikhop hija hichi Templo an khun chumalan ja khun lomattoꞌ an mundaydayaw ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ja tinnig an amin chin tatakhu hija an khun chumalan ja mundaydayaw ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ja immatunan cha an hija chin u-umpfun an khun mun-ad-adchaw ay chuy pantaw an nangadnan hi Maphod, ja nanor cha ay chuy an na-at. ");
INSERT INTO ifu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pfimmutay cha Peter ay John ay ni pfarkon an nginadnan cha hi Pfarkon Solomon, ja chin lala-e an nepatenong ja pfinijaw na chicha. Hitatagtag chin tatakhu an umuy hi gwachaan cha ti nanor cha ay chuy natnat-on an na-at. ");
INSERT INTO ifu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Unagkhu tinnig Peter ja inali na hi, “A-akhiꞌ an holag Israel, anagkha ta nanannor aju? Ja anagkha ta pa-emmohchongon chaꞌmi? Unchah khemhon ju un chaꞌmi chi nangpachallan ay tay an lala-e khapo hi apfalinan mi wenno khapo ta naꞌna-unnud ami ay Apo Jos? ");
INSERT INTO ifu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mahapor an annilaon ju an hitay an hi Apo Jos an khun dayawon hachi a-ammod ta-o, an cha Abraham, ja hi Isaak, ja hi Jakob, chi nangat ta ipapfagpfagto na hini Apo mi an hi Hesus an pfaar na. En-agwat ju hija hachi a-ap-apo ja chin-ug ju hija chin nunhumarjaan Pilato, an anong una podhon an ipfu-aan ja in-achi ju. ");
INSERT INTO ifu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Chin-ug ju hi Hesus an magpong ja ma-id oh-ohha hi pfahor na, ja inali ju agkhu ay Pilato an hay ipfu-aana ja chin oha an pemmatoy! ");
INSERT INTO ifu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Penatoy ju hini khun mangchat hi piꞌtakhuwan muti minahuwan Apo Jos chamchama. Ja tihtikhuwan mi an umannung hitay, ti niꞌtikhaw mi. ");
INSERT INTO ifu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ja anagkha ta chimmallan hitay an lala-e? Aa, ti hini apfalinan Hesus ja hini pammati mi ay hija chi nangpachallan ay tay an lala-e an anila ju ja tinnig ju. Hi Hesus chi nangpapfi-ah ay ni nomnom na an mamati ay hija, hijaot un temmenong ad ugwani hi agawwachaan ju.” ");
INSERT INTO ifu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Entoloy Peter an nunhapit ja inali na hi, “A-akhiꞌ, anilaꞌ an chin nangpapatajan ju ay Hesus, ja agkhuy ju anila an hija chi hennag Apo Jos an mamahhod. Ja anong un chin a-ap-apo ta-o ja agkhuy cha khu anila. ");
INSERT INTO ifu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Muti chin natajan Hesus ja nipa-annung chin impadtun hachi profetan Apo Jos chin hopapna. Ti impa-innilan Apo Jos ay chicha an mahapor an matoy hini honakhona an mamahhod. Ja tan ad ugwani chi na-atana. ");
INSERT INTO ifu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hotti chuꞌkhon ju hana pfahor ju ja numpfangngad aju ay Apo Jos ta pakawanona an amin chi pfahor ju. ");
INSERT INTO ifu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu amat hetoy aton ju, ja i-alin Apo Jos chi pun-ar-alenagwaan ju ja unaot honakhon khu hi Hesus an umali, hija an pinili na an hahadchon ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Muti mahapor an mihihidchi hija ad langit ingkhana an machakngan chin arkhaw an pangpa-annungann Apo Jos an amin chin impa-innila na an inalin hachi nasantuwan an profeta chin hopapna. ");
INSERT INTO ifu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hay oha an impa-innila na ja hitay inalin Moses hi nangarjana hi, ‘Honakhon Apo Jos han profeta an umali ay chaꞌju an amat ay ha-in an profeta na, ja oha hija khu an ibpfa ta-o an holag Israel, ja mahapor an unuchon ju an amin chi hay allona. ");
INSERT INTO ifu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ti an amin chi achi mangngor ja milahin cha hana tatakhun Apo Jos ta madusa cha.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Entoloy Peter an nunhapit ja inali na hi, “Hachi khu uchumna an profetan Apo Jos nete-a ay Samuel ja an amin chin netonetob ay hija, ja impa-innila cha khu hato naꞌna-at ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chita-o ad ugwani chi mangagwat hana ingkarin Apo Jos an inalin hachi profeta na, ja nidchum ta-o chin neꞌtobpfalana chin a-ammod. Ti inali na ay Abraham hi, ‘Hini holag mu chi pomhochan an amin chi tatakhu heto lota.’ ");
INSERT INTO ifu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hotti chita-o chi nahhun an nangpa-aliyana ay Hesus an pfaar na ta pomhod hini piꞌtakhuwan ta-o, ti tulungan chita-o ay Apo Jos an man-ug hay hana nihikhud an pfahor ta-o.” ");
INSERT INTO ifu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Khun pay miꞌhapit cha Peter hay hachi tatakhu, ja numpanga-ali hachi uchumna an papachi ja hini kapitan chi gwarja hichi Templo ja hana uchumna an Saducee. ");
INSERT INTO ifu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ja pfimmungot cha, ti khun itudtuchun cha Peter ay John an nummahu hi Hesus, hotti mummahu an amin chi natoy. ");
INSERT INTO ifu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hotti chimpap cha cha Peter ay John ja khapo ta madhom, ja impipfalud cha chicha ta mun-inggwiꞌgwiit ja un cha mahumarja. ");
INSERT INTO ifu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Muti cho-or khu hay hachi ne-egngor an namati chin intuchu cha. Ja hay pfilang chi linala-e an namati ja umuy hi lemay lipfu. ");
INSERT INTO ifu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nun-inggwiꞌgwiit ja na-amung cha ad Jerusalem hay hachi pangulu ja hachi uchumna an a-ap-apon chi Hudju ja hachi memehtolon chi urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Niꞌ-amung han natakhay an pachi an hi Anas, ja hi Kayfas ja hi John ja hi Alexander ja hana uchumna an a-akhin Anas. ");
INSERT INTO ifu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Empapfokha cha hi Peter ja hi John ja ente-a chaot an munhanhan an allon cha hi, “Ngay nangalan ju ay ni apfalinan ju an nangpatenong ay tay napilay? Wenno ngay nangchat ay ni apfalinan ju?” ");
INSERT INTO ifu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nagwachaan hi Peter ay ni apfalinan ni Espiritu Santo ja inali na hi “Chaꞌju an pangulu ja a-ap-apo, ");
INSERT INTO ifu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nu mahumarja ami ad ugwani khapo ay ni maphod an na-at ay tay napilay ja hini enat na an nepatenong ");
INSERT INTO ifu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ja chonglon ju hitay. Mahapor an annilaon ta-o an amin chi holag Israel an nepatenong hitay lala-e an natikhaw ju khapo ay ni apfalinan Hesu Kristo an eNazaret an empepfakhat ju chin kros muti minahuwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hitay an hi Hesus ja hija hini allona ay ni hapit Apo Jos an mipadchung hi pfato an namlenan ju an khun mumpakhad hi pfalay, muti hijay numpfalinon Apo Jos hi na-ahammad an pognad tay an pfalay.” ");
INSERT INTO ifu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja entoloy Peter an nangali hi, “Hi Hesus ja angkhay chi Manakhu hi tatakhu, ti ma-id uchumna hi hennag Apo Jos an Manakhu ay chita-o ay tay lota nu pfu-un hija. Hija hini mahapor an punhocholan ta-o.” ");
INSERT INTO ifu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nanor hachi a-ap-apon chi Hudju ay ni impatikhaw cha Peter ay John an anong un cha agkhuy neꞌ-ehkor ja ma-id chi nangato hi haad cha, ja achi cha chamchama toma-ot an homongpfat. Ja na-awatan hachi a-ap-apo an hay achi cha pfuma-inan ja oha cha an khun mitnud ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ja ma-id ma-ali cha ay cha Peter ay John, ti niꞌtataꞌchug chin lala-e an nepatenong. ");
INSERT INTO ifu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hotti penakak cha chicha ay chuy punhumarjaan ta gway aton cha an munhahapit. ");
INSERT INTO ifu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ja inali cha hi, “Ngay aton ta-o mah ay cha tay, ti an amin hana tatakhu heto ad Jerusalem ja inannila cha an gwachay enat cha tay hi otongngan an milagro ja achi mehaot. ");
INSERT INTO ifu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mahapor an ihingar ta-o chicha ta epokhong cha an ihaphapiton hini omaꞌ-atan Hesus, ta achi chomchom-or chi mangannila.” ");
INSERT INTO ifu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hotti empaghop cha khu cha Peter ay John, ja nun-ihingar cha ta epokhong cha an muntihtikhu ja an mangtuchu ay ni omaꞌ-atan Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tempfar cha Peter ay John ja inali cha hi, “Hotti nomnomon ju adchiya. Maphod chah ay Apo Jos nu chaꞌjuy ma-unud ta pfu-un hi Apo Jos? ");
INSERT INTO ifu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti ay chaꞌmi mangkay ja achi mapfalin an epokhong mi an mangali chin tinnig mi ja chengngor mi ay Hesus.” ");
INSERT INTO ifu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chengngor hachi a-ap-apo hitay ja impiggwa cha an nangali ay cha Peter an madusa cha nu etoloy cha an muntudtuchu ay ni omaꞌ-atan Hesus. Muti penakak cha chamchama ti ma-id manomnom cha hi aton cha gwot an mangdusa ay chicha, ti temma-ot cha hachi cho-or an tatakhu an khun mundaydayaw ay Apo Jos khapo ay tay milagro an na-at. ");
INSERT INTO ifu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hichuy napilay ja nahulok hi apat chi poloy tagwona ja un tomenong. ");
INSERT INTO ifu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Unot nipfu-aan cha Peter ay John ja immuy cha hachi i-ibpfa cha an namati ja impa-innila cha an amin chin inalin hachi a-ap-apon chi papachi ja hachi a-ap-apon chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Unagkhu chengngor hachi namati chin inali cha ja nun-oh-ohha cha an nungkalalag an inali cha hi, “Apo Jos an Apo mi, he-a chi Nampfu an amin ad uchu ja heto lota ja hichi baybay ja an amin hana nagwacha. ");
INSERT INTO ifu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","He-a chi nangali hana impatulaꞌ ni Espiritu Santo chin apo mi an hi Ari David an pfaar mu hi nangarjana hi, ‘Anagkha ta hana Hentil ja pfimmungot cha ay Apo Jos, ja anagkha ta i monnomnom hana Hudju hay i cha aton an ma-id herpfi na? ");
INSERT INTO ifu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ja na-amung hana ar-ari ja a-ap-apo heto lota ja nehahagkhana cha an miꞌkhupfat ay Apo Jos ja ay Kristo an pinili na an Mamahhod.’ ");
INSERT INTO ifu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ja na-at chin impa-innilam, Apo Jos, ti nunchichittum cha Herod ja hi Pontius Pilato ja hana Hentil ja anong un hana Hudju an holag Israel ay tay an pfuglay, ja nunhahappitanan cha chin enat cha an namatoy ay Hesus an nasantuwan an pfaar mu, an enhaad mu an hija hini Kristo an Mamahhod. ");
INSERT INTO ifu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ja umannung an penatoy cha, muti khapo ta he-a chi khun mangpaptoꞌ, ja nipa-annung ay tay an enat cha chin eneꞌcham chin hopapna an penhod mu an ma-at. ");
INSERT INTO ifu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anilam, Apo Jos, hini inali cha an nanattata-ot ay chaꞌmi hotti papfi-ahon chaꞌmi an pfaar mu ta achi ami toma-ot an i muntudtuchu ay ni hapit mu. ");
INSERT INTO ifu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ja ipatikhaw mu hini apfalinam ta epatenong mi hana mumpunchokhoh ja aton mi hana uchumna an milagro khapo ay ni apfalinan Hesus an nasantuwan an pfaar mu.” ");
INSERT INTO ifu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Unot napfalin chin nungkalalakhan cha ja aꞌ-alina ja negwakhot chin pfalay an i cha na-amungan. Ja nagwachaan cha ay ni apfalinan ni Espiritu Santo, hotti agkhuy cha temma-ot an i muntudtuchu ay ni hapit ApoJos. ");
INSERT INTO ifu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","An amin hachi nahhun an namati ja nun-oh-ohha cha hi nomnom ja leꞌna. Ma-id na-ikot an un chaot khun manghin-i-idchat hi mahapor chi oha-ohanna ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ja nagwachaan hana apostol hi otong an apfalinan an i manihtikhuwan ay ni nummahuwan Apo Hesus. Ja otong hini khohkhoh Apo Jos an amin hana namati. ");
INSERT INTO ifu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma-id chi hay namati an kumuchang chi mahapor na. Ti hana gway lota wenno pfalay cha ja ingngina cha ");
INSERT INTO ifu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ta inchat cha hini polaꞌ na hachi apostol, ta chichay mangchat hay hana ma-id mapfalina an namati. ");
INSERT INTO ifu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amat hina han enat Josep an ohan holag Levi an eCyprus. Nginadnan hachi apostol hi Barnabas ti hay podhona an hapiton ja khun mangpapfi-ah hi nomnom. ");
INSERT INTO ifu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ingngina na han lota na ja inchat na chin polaꞌ na hachi apostol. ");
INSERT INTO ifu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gwacha han hempfalay an cha Ananias ja hi Safira, ja eneplaꞌ cha han pajaw cha ta gway pi-iꞌchat cha hachi apostol. ");
INSERT INTO ifu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Muti nunhappitanan cha an hempfalay an aꞌ-aanan cha chin pihu an polaꞌ ni pajaw ja un cha ichat. In-uy Ananias chin uchumna an pihu hachi apostol, ");
INSERT INTO ifu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ja inalin Peter hi, “Anagkha he-a Ananias ta inunud mu chin empanomnom Satanas ja lenahlaham hini Espiritu Santo ta enhaꞌpfam hini aggwan ni pihu an polaꞌ nuy pajaw ju? ");
INSERT INTO ifu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lota ju hinuy hotti gwa ay chaꞌju nu ingina ju wenno achi ju. Ja napfalin an eneplaꞌ ju, ja ikhad aju nu gway penhod ju an aton ay ni polaꞌ na. Anagkha ta nenomnom mu an mangat heto? Hi Apo Jos mangkay chi lenahlaham an pfu-un hay takhu.” ");
INSERT INTO ifu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Unagkhu chengngor Ananias hitay ja natuꞌ-in ja natoy. Ja gwa hichi hachi uchumna an ungunga an linala-e ja pfiniꞌlukhan cha chin achor na ja i cha inlupfuꞌ. Ja nang-entata-ot cha an amin an nangngor ay tay an na-at. ");
INSERT INTO ifu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Immuy chi toloh oras ja immali hi ahagwan Ananias an hi Safira muti agkhuy na anila chin na-at ay ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Empfokhan Peter ay Safira hi, “Allom adchiya, un chah angkhay hitay hi polaꞌ ni pajaw ju?” Ja inali na hi “Aa, angkhay hinuy.” ");
INSERT INTO ifu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ja inalinot Peter hi, “Anagkha ta nunhappitanan ju an hempfalay an padpachaon hini Espiritun Apo Jos? Niya an umali hana i nanglupfuꞌ ay ahagwam ja i chi-a khu piꞌlupfuꞌ!” ");
INSERT INTO ifu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Himpfumagkha ja natuꞌ-in hi Safira ay chuy negpongan Peter ja natoy. Himmikhop hachi ungunga an linala-e ja tinnig cha an natoy hija hotti enala cha khu ja i cha encheloh ay ahagwa na. ");
INSERT INTO ifu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nang-entata-ot an amin hana namati ja amat hina khu an amin hana ne-egngor ay tay an na-at. ");
INSERT INTO ifu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Khun ma-amung an amin hachi namati ay ni Pfarkon Solomon hichi Templo ja cho-or chi numpfino-ob-on an milagro an ena-enat hachi apostol an panginnilaan an gawwa ay chicha hini apfalinan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Anong un hachi agkhuy namati ja khun cha dayawon hachi immunud ay Hesus, muti mun-okhon cha an midchum ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ja khun cha ma-ug-ugman hachi namati ay Apo Hesus ti cho-odcho-or hachi linala-e ja pfinapfai an khun midchum an mamati. ");
INSERT INTO ifu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cho-or chi enat hachi apostol an milagro, hijaot un cha nun-i-ali hachi mumpunchokhoh, ja nun-epapekheng cha chicha hi kama wenno ap-ap hichi pingngit chi kurha, ta naloh ayya hi Peter ja anong un cha ma-agwaan ay ni agwa na ja temmenong cha. ");
INSERT INTO ifu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Numpanga-ali khu hachi tatakhu an narpu hachi nun-ehnot an pfuglay ad Jerusalem ja nun-i-ali cha hachi mumpunchokhoh ja hay hachi nahuꞌlungan hi napukhit an ispiritu, ja temmenong cha an amin. ");
INSERT INTO ifu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chin natakhay an pachi ja chin i-ibpfa na an Saducee ja nunlinapoh chin ámoh cha hachi apostol. ");
INSERT INTO ifu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hotti impatiliw cha chicha ta mipfalud cha. ");
INSERT INTO ifu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Muti ay chuy an lapfi ja immuy han angher Apo Jos ja i na impfughor hachi pantaw chin pfaluchan ja impfutay na chicha ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Umuy aju hichi Templo an i mangpa-innila hachi tatakhu ay ni pfakhu an piꞌtakhuwan an narpu ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Inunud hachi apostol chin inali na, hotti gwa an naꞌ-arkhaw ja immuy cha hichi Templo an i muntudtuchu. Amat hichi ja inamung chin natakhay an pachi hachi nun-ibpfa na, ja enajakhan cha an amin hachi a-ap-apon chi Hudju ta munhahapit cha. Ja hennag cha hachi i mangagwit hachi apostol, ti khemhon cha un cha gawwa hichi pfaluchan. ");
INSERT INTO ifu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Muti unagkhu emmatam hachi hennag cha hichi pfaluchan ja ma-id hachi apostol, hotti numpfangngad cha hichi punhumarjaan ja inali cha hachi a-ap-apo hi, ");
INSERT INTO ifu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Immuy ami hichi pfaluchan ja nun-atorpfoꞌ ja gawwacha pay hana khun munggwarja hichi pantaw. Muti un mi agkhu impipfughor ja ma-id hay hachi pfalud.” ");
INSERT INTO ifu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Unagkhu chengngor chin ap-apon chi gwarja hichi Templo ja chin a-ap-apon chi pachi ja ma-id machotoꞌ hi nomnomon cha ti agkhuy cha anila nu ngay pumpfanakhan hachi naꞌna-at. ");
INSERT INTO ifu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ja gwa han immuy ay chicha an nangali hi, “Chin linala-e an impipfalud ju ja gawwacha cha mangkay hichi Templo an khun muntudtuchu hana tatakhu.” ");
INSERT INTO ifu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hotti immuy hachi gwarja jachin a-ap-apo cha an imangagwit ay chicha ta epfangngad cha hichi punhumarjaan. Ja agkhuy cha pinilit chicha ti toma-ot cha hi pangajangan hachi tatakhu ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eneghop cha hachi apostol hichi punhumarjaan ta humarjaon hachi a-ap-apon chi Hudju, ja inalin chin natakhay an pachi hi, ");
INSERT INTO ifu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Inhingar mi chaꞌju ta epokhong ju an i mangitudtuchu ay nuy an takhu an inunud ju. Muti tan agkhuy ju enegngor ja natuchugwan cha gwot an amin hato tatakhu heto ad Jerusalem. Ja chaꞌmi ochot chi papfaholon ju an nangpapatoy ay hija.” ");
INSERT INTO ifu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tempfar cha Peter ja chin i-ibpfa na an apostol ja inali cha chi, “Aa, ti mahapor an unuchon mi hi Apo Jos an pfu-un hay takhu. ");
INSERT INTO ifu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Hi Apo Jos an khun dayawon chin a-ammod ta-o ja minahuwana hi Hesus an empapatoy ju chin kros. ");
INSERT INTO ifu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ja impapfagto na gwot hi Hesus ta inumpfun ay ni nun-appit hi agwana an miꞌ-ap-apo. Ja hija khu chi Ap-apo ja Manakhu ay chita-o an holag Israel ta gway aton ta-o an man-ug hi pfahor ta-o ja ta gway aton ta-o an mapakawan. ");
INSERT INTO ifu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tihtikhuwan mi an umannung an amin hay hato, ja tihtikhuwan khu ni Espiritu Santo an inchat Apo Jos an amin hana miꞌ-unud ay hija.” ");
INSERT INTO ifu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Unagkhu chengngor hachi a-ap-apo hitay ja pfimmungot cha ja penhod chaot an patajon hachi apostol. ");
INSERT INTO ifu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Muti gwacha han oha ay chicha an hi Gamaliel an Farisee. Hitay an lala-e ja mehtolon chi urchin Moses an lihpituwon chi tatakhu. Timmaꞌchug hija ja impapfutay na hachi apostol ta umi-igway cha an munhahapit an a-ap-apo. ");
INSERT INTO ifu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ja inali na hi, “A-akhi an holag Israel, pa-anomnomon ta-o gwot niꞌ hini i ta-o aton ay cha tay. ");
INSERT INTO ifu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nomnomon ta-o chin lala-e an hi Teudas. Khuna allon hi hijay napfagpfagto ja nidchum chi apat hi khahot an tatakhu ay hija. Penatoy cha hi Teudas ja nunhihijan hay hachi nun-ibpfa na ja hijah chuy chi pogpogna. ");
INSERT INTO ifu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nepallog khu han oha an hi Judas an eGalilee chin timpo an pumpalehtaan cha hi ngachan. Cho-or khu hachi immunud ay hija ja penatoy cha khu, ja nunhihijan hay hachi nun-ibpfa na. ");
INSERT INTO ifu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hotti ad ugwani ja hay itukhun u ay chaꞌju, ja ma-id koma at-aton ta-o ay chicha ta un cha ikhad. Ti nu narpu hi nomnom chi takhu hay hato khun cha aton hot ma-id toloy na. ");
INSERT INTO ifu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Muti nu umannung an hi Apo Jos chi khun mangat hay hato ja ma-id chamchama olog ta-o an mangpataꞌchug ay chicha. Oha khu ja unchani ja ma-id uchumna hi khun ta-o pfuhulon nu pfu-un hi Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ja enegngor cha chin intukhun Gamaliel. Impahikhop cha khu hachi apostol ja impahuplit cha chicha ja inhingar cha ta achi cha ipigpiggwa an i mangali ay ni omaꞌ-atan Hesus. Ja impfu-aan cha chicha. ");
INSERT INTO ifu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Amat hichi ja nakak hachi apostol ay chuy punhumarjaan ja khun cha mun-an-anla, ti impfilang Apo Jos chicha an miꞌlikhat ja an mapfa-inan khapo hi niꞌ-unuchan cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A-arkha-arkhaw hon immuy cha hichi Templo ja anong un hana pfarpfalay an imangkaskasaba an hi Hesus hini Kristo an mamahhod. ");
INSERT INTO ifu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hichi ad Jerusalem ja khun chomchom-or hay hachi namati. A-arkha-arkhaw ja gwacha hachi khun manggwanah hay itolong cha hachi namati an khun makuchangan hi mahapor cha. Muti hachi Hudju an Griego chi hapit cha ja neꞌhohongnger cha hachi Hudju an khun munhapit hi Hebrew, an allon cha hi khun cha lah-angan hana pfalo an papadchung cha ta hana pfalo an Hebrew chi hapit cha chi michatan hi tolong ja angkhay. ");
INSERT INTO ifu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chengngor hachi apostol hitay an na-at, hotti inamung cha an amin hachi namati ja inali cha ay chicha hi, “Pfu-un chaꞌmi chi mangpachot-anan ay tay an tamu an khun munggwanah hana mitolong, ti kan epokhong mi agkhu an i mangkaskasaba ay tay Hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hotti hay aton ta-o, a-akhi, ja piliyon ta-o hay peto an linala-e an nidchum ay chita-o an maphod chi ahaphapitan cha ja manomnom ja nagwachaan cha ay ni apfalinan ni Espiritu Santo, ta chichay ehaad mi an khun mangchat hana mitolong, ");
INSERT INTO ifu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ta hay pachot-anan mi an aton ja un ami mungkalalag ja khun umuy muntudtuchu ay ni hapit Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","An amin hachi na-amung ja penhod cha chin inalin hachi apostol ja pinili cha han peto an linala-e. Oha hi Stephen an nehamad chi pammati na ja nagwachaan ay ni apfalinan ni Espiritu Santo, ja hi Philip, ja hi Prokoros, ja hi Nikanor, ja hi Timon, ja hi Parmenas, ja hi Nikolaus an e-Antokya an Hentil muti khun miꞌ-unud ay ni ugalin chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ja in-uy cha hay hato peto hay hachi apostol. Ja eneh-an hachi apostol hachi ngamoy cha ja engkalalakhan cha chicha. ");
INSERT INTO ifu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Amat hichi ja emmom-omod pay an nunchongor hitay Hapit Apo Jos ja khun ma-ug-ugman hay hachi namati ad Jerusalem. Anong un hana papachin chi Hudju ja cho-or chay namati ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Otong chi tolong Apo Jos ay Stephen ja inchatana hija hi apfalinan an mangat hi o-otong an milagro ja hana uchumna an achi kayan chi takhu an aton, ja tinnig chin tatakhu. ");
INSERT INTO ifu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Muti gwacha hachi pfimmuhur ay Stephen an dati an himpfut an nawaya-an, ja khun cha ma-amung han sinagoga cha. Ja gwacha khu hay hachi uchumna an Hudju an eCyrene, ja e-Alexandria, ja eSilisya, ja e-Asia, ja immuy cha niꞌhongnger ay Stephen. ");
INSERT INTO ifu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Muti agkhuy na-ahujan hija ti tinulungan ni Espiritu Santo ay ni enat na an nunhapit. ");
INSERT INTO ifu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hotti i cha pfinajachan hachi uchumna an linala-e ta munlahlah cha, ja inali cha hi, “Chengngor mi hitay an hi Stephen ja khun munhapit hi mipfuhur ay ni urchin Moses ja hi Apo Jos!” ");
INSERT INTO ifu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Enchokhochokhor cha hay hachi tatakhu ja hachi a-ap-apon chi Hudju ja hachi memehtolon chi urchin Moses, ta chupopon cha gwot hi Stephen ja in-uy cha hichi punhumarjaan. ");
INSERT INTO ifu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ja enajakhan cha hana munlahlah an muntihtikhu ja inali cha hi, “Hitay an lala-e ja khuna pahigwon hini nasantuwan an Templo heto ad Jerusalem ja hini urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ti chengngor mi an inali na an hi Hesus an eNazaret ja paꞌ-iyona hini nasantuwan an Templo ta-o ja hukatana anu hana ugali ta-o an empfanoh Moses.” ");
INSERT INTO ifu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ja hachi na-amung ay chuy punhumarjaan ja emmomohchong cha hi Stephen ja tinnig cha chin angah na an meꞌmeꞌnong hi angah chi angher. ");
INSERT INTO ifu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Inalin chin natakhay an pachi ay Stephen hi, “Umannung chah hitay inali cha?” ");
INSERT INTO ifu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tempfar Stephen ja inali na hi, “Chaꞌju an a-ammod ja a-akhi, chonglon ju mah hitay alloꞌ. Anila ju an hi Apo Jos an napfagto ja numpatikhaw ay Abraham an ammod ta-o chin agawwachaana ad Mesopotamia hi agkhuy na pay numpfunakhan ad Haran. ");
INSERT INTO ifu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ja inalin Apo Jos ay hija hi, ‘Taynam hitay pfuglay ju ja hana i-ibpfam ta umuy a han lukhar an ituchuꞌ ay he-a.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hotti nakak cha Abraham hichi ad Mesopotamia, an nginadnan cha hi Kaldea, ja immuy cha ad Haran. Napfalin an natoy hi ama na ja un honakhon Apo Jos hija an umali heto pfuglay ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Agkhuy inchat Apo Jos ay Abraham hitay an lota, anong mah niꞌ un hay hinggwanit, muti na-ikari an lota na ti mepfanoh hay hana holag na. Ja chin nangarjan Apo Jos ay tay an kari, ja ma-id pay empfalay Abraham. ");
INSERT INTO ifu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Amat heto chin inalin Apo Jos ay hija an, ‘Hana holag mu ja umuy cha han pfuglay an pfu-un pfuglay cha, ja palikhaton cha chicha ja pumpfalinon cha hi himpfut hi apat chi khahot hi tagwon. ");
INSERT INTO ifu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Muti hugijoꞌ hachi mamarpalikhat ay chicha ja un cha makak ta umali cha heto, ta heto chi pundayawan cha ay ha-in.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ja intuchun Apo Jos an mahapor an makugit cha Abraham ja hana linala-e an holag na ta hinjar ni neꞌtobpfalana ay chicha. Hotti netoꞌkhong hi Isaak an empfalay Abraham, ja kinugit Abraham ay ni me-agwalo an arkhaw na. Ja enat khu Isaak chin empfalay na an hi Jakob. Ja enat khu Jakob chin himpolo ta han chugwa an empfapfalay na an linala-e an nangholag ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ja anila ju chin enat hachi a-ammod an nangholag ay chita-o an Hudju. Nunlinapoh chin ámoh cha ay Josep an akhi cha, hotti ingngina cha ja numpfalin hi himpfut hichi ad Egypt. Muti gawwacha hi Apo Jos ay hija ");
INSERT INTO ifu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ja tinulungana an amin chin i na nunlikhatan. Ja inchatan Apo Jos hi Josep hi nomnom ta un maphod chi pannig chin Faraon ay hija. Hijaot un enhaad ni Faraon hija hi gobernador hi apfuglapfuglay ad Egypt, ja impulang na ay hija an amin hachi khina-u na. ");
INSERT INTO ifu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Amat hichi ja na-ulat cha ad Egypt ja ad Kana-an, ja nunnaud cha an nalikhatan. Ja ma-id pangalan chin a-ammod ta-o ad Kana-an hi anun cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Unot chengngor Jakob an gway anun ad Egypt ja hennag na chin empfapfalay na an nangholag ay chita-o ta i cha ngumina hi anun cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ja chin piggwana an i cha nguminaan ja empfaag Josep an hija chin akhi cha, ja inannilan khu ni Faraon an gway a-akhin Josep. ");
INSERT INTO ifu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ja hennag Josep chin i mangagwit ay ama na an hi Jakob ja hay hana uchumna an i-ibpfa cha. Ja petom polo ta han lema cha an immuy ad Egypt. ");
INSERT INTO ifu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ne-atam cha Jakob ad Egypt ja hichi chi natajana. Ja hichi khu chi natajan chin uchumna an a-ammod ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ja in-uy cha chin tungar chi nun-atoy chin lota ad Shekem an ngininaan Abraham ay ni holag Hamor chin hopapna ja hichi chi nilub-an cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Gwacha an machakngan chin timpo an pangpa-annungan Apo Jos chin ingkari na ay Abraham an omajan cha ad Kana-an, ja khun chomchom-or chin holag Jakob ad Egypt. ");
INSERT INTO ifu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Immuy chi atagwotagwon ja khun munhinhinukat hachi mun-ari ad Egypt ja gwacha han oha an nepallog an nun-ari an ma-id chengchengngor na hi omaꞌ-atan Josep. ");
INSERT INTO ifu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ja cho-or chin napukhit an enat na an namarpalikhat chin a-ammod ta-o ja in-urchina an etapar cha hana paꞌ-etoꞌkhong ta mun-a-atoy cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ay chuy an nun-ariyana chi nituꞌkhungan Moses an mapmaphod an unga. Ja toloh pfulan hi nunhalimunan ina na hichi pfalay cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Napfalin ja in-uy na hichi gwanggwang, ja chinakngan chuy empfalay ni Faraon an pfupfai. Impa-ilog na ja impfilang na hija hi empfalay na. ");
INSERT INTO ifu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ja natuchugwan hi Moses an amin hi nomnom chi e-Egypt, ja madayaw an amin chi hapit na ja atona.” ");
INSERT INTO ifu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Entoloy Stephen an nunhapit ja inali na hi, “Gwa an apat chi poloh tagwon Moses ja nenomnom na an i manikhaw nu ngay amatan hachi i-ibpfa na an holag Israel. ");
INSERT INTO ifu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ja inah-upana chin e-Egypt an khuna pumpakhuh chin ohan Hudju. Ja tinulungana hichuy ibpfa na ja penatoy na hichuy e-Egypt. ");
INSERT INTO ifu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Khemhon Moses un anilan chin i-ibpfa na an Hudju an hijay usaron Apo Jos an tomolong ay chicha, muti agkhuy cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nun-inggwiꞌgwiit ja inah-upana khu chin chugwa an Hudju an khun mumpatoy. Ja immuy hi Moses an munta-in ja inali na hi, ‘Achi aju mumpatoy, ti un aju hin-ibpfa.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Muti chin oha an pfimmahor ay chuy ibpfa na ja inturchuna hi Moses ja inali na hi, ‘Ngay nanghaad ay he-a an mun-ap-apo ja manugi ay chaꞌmi? ");
INSERT INTO ifu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Unaꞌ chah khu patajon an amat ay ni enat mu ad akhapfan ay nuy e-Egypt?’ ");
INSERT INTO ifu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Unot chengngor Moses an na-innila chin enat na ja lemmajaw, ja i neꞌheto hichi ad Midian. Narhin hichi ja en-empfalay na chin chugwa an linala-e. ");
INSERT INTO ifu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Immuy chi apat chi poloh tagwon ja numpatikhaw ay Moses chin Angher Apo Jos ay chuy khun munchalang an ajiw an nehnot hichi pfuludna ad Sinai. ");
INSERT INTO ifu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ja nanor hi Moses hotti henontana ta paꞌpa-atigkhana, ja chengngor na hini hapit Apo Jos an inali na hi, ");
INSERT INTO ifu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ha-in chi Jos an khun dayawon chin a-ammod mu an hi Abraham ja hi Isaak ja hi Jakob.’ Ja gimmoggwog hi Moses hi ta-ot na ja inimit na. ");
INSERT INTO ifu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ja inalin Apo Jos hi, ‘Ánum hini hapatom ti nasantuwan hitay achaam.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja inali na khu hi, ‘Tinnig u an amin chi enat hachi e-Egypt an namarpalikhat hana tatakhuꞌ ja chengngor u hini kila cha, hijaot unaꞌ umali ta takhuwoꞌ chicha. Hotti tayya an honakhoꞌ he-a an mumpfangngad ad Egypt ta atom hana penhod u an ma-at ta matulungan cha.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Khun munhapit hi Stephen ja inali na hi, “Hitay an hi Moses ja agkhuy inapfulut hachi a-ammod ta-o hija an mun-ap-apo, an inali cha hi, ‘Ngay nanghaad ay he-a an mun-ap-apo ja manugi ay chaꞌmi?’ Muti hi Moses chi enhaad Apo Jos an mangpangpangulu ja an tomolong ay chicha ta makak cha ad Egypt. Ja chin angher an numpatikhaw ay chuy ajiw an khun munchalang chi temmolong ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja hi Moses chi nangpangulu ay chicha chin nakakan cha ad Egypt. Cho-or chin enat na hi milagro hichi ad Egypt, ja hichi Baybay an Mumpfolah, ja hichi khu let-ang hi apat chi poloh tagwon, an panginnilaan an gwa ay hija hini apfalinan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Hi Moses chi nangpa-innila hachi a-ammod ta-o an, ‘Honakhon Apo Jos ay chaꞌju han profeta an amat ay ha-in. Oha hija an holag Israel an amat ay chita-o.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hi Moses chi niꞌhapitan chin angher Apo Jos chin na-amungan hachi a-ammod ta-o hichi pfuludna an ad Sinai. Ja hijay nangagwat hana hapit Apo Jos an mangchat hi piꞌtakhuwan. Ja hichuy an hapit Apo Jos chi khun mepfanopfanoh ay chita-o an holag chi Israel. ");
INSERT INTO ifu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Muti chin a-ammod ta-o, ja chin-ug cha hi Moses an achi cha pattiyon chin inali na, ti immingoho cha hachi ugalin chi e-Egypt an tenaynan cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chin nunti-ichan Moses ad Sinai ja inalin chin tatakhu ay Aaron hi, ‘Ephod mu mah hay jos ta-o ta gway mangpangulu ay chita-o. Ti tan ma-id hinuy mun Moses an nangpangulu ay chita-o chin nakakan ta-o ad Egypt ja ma-id maptoꞌ nu ngay na-at ay hija.’ ");
INSERT INTO ifu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hotti hinuy chi nangapjaan cha chin pfolor an omaꞌ-at hi pfoꞌtot an pfakah ja impartiyan cha ja pfinehtaan cha ti penhod cha chin enapja cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hijaot un chin-ug Apo Jos chicha ta ikhad cha an mundayaw ay chuy hukhit ja pfulan ja pfittuwan an gawwacha ad uchu. Ja hitay chin Hapit Apo Jos an intulaꞌ chin profeta na hi nangarjana hi, ‘Chaꞌju an holag Israel, pfu-un ha-in chi nangidatunan ju hana naparti an animar ja hana daton ju chin apat chi poloh tagwon an agawwachaan ju hichi let-ang. ");
INSERT INTO ifu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ti khun ju ita-in chin pfaꞌpfaꞌlay chin pfolor an ma-ali hi Molok ja chin pfolor an ma-ali hi Refan an ngachan chi pfittuwan, ti hay hato chi enephod ju an khun ju dayawon. Hotti pakakoꞌ chaꞌju ta umuy aju han pfuglay an achawwi mu ad Babilon.’” ");
INSERT INTO ifu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Entoloy Stephen an nunhapit ja inali na hi, “Hachi a-ammod ta-o ja enephod cha chin torcha an apfong an panginnilaan an gawwacha hi Apo Jos ay chicha hichi let-ang. Ja ene-eꞌnong cha chin impatikhaw Apo Jos ay Moses hi aton cha an mun-ephod. ");
INSERT INTO ifu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Natoy hi Moses ja nepallog hi Joshua an nangpangpangulu ay chicha chin immaliyan cha heto. Ja chin torcha an apfong an nepfanoh ay chicha, ja inta-in cha heto chin nangpakakan Apo Jos hana nunheto ad Kana-an ta nepallog cha. Ja gawwah to chin apfong ingkhanah chin nun-ap-apugwan Ari David. ");
INSERT INTO ifu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ja penpenhod Apo Jos hi David hotti empfokhan David nu mapfalin an ehaꞌ-ad na hay pfalay an pundayawan hachi holag Jakob ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Muti pfu-un hi Ari David chi nunhaꞌ-ad hi pfalay an pundayawan ay Apo Jos, ti chin empfalay na an hi Ari Solomon chi nanaꞌ-ad. ");
INSERT INTO ifu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Muti hitay munnaud an napfagto an Jos ja achi munheto hana pfalay an ephod chi takhu, ti hitay chi intulaꞌ chin profeta chin hopapna ");
INSERT INTO ifu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","an inalin Apo Jos hi, ‘Ad langit chi umpfunaꞌ an mun-ap-apo ja hichi lota chi pangchaꞌ-angaꞌ, hot ngay amatan chi pfalay an ephod ju hi punhitugwaꞌ? Ma-id chi hay pfalay an nepakhad an maphod hi ujaꞌ pun-enanaan. ");
INSERT INTO ifu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ti ha-in chi nangephod an amin chi nagwacha.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ja inalin khu Stephen hi, “Munnaud aju an ngumangannu an amat aju hi Hentil an ma-id anila cha ay Apo Jos ja achi cha chonglon hini allona. Hihiya aju chin a-ammod ta-o chin hopapna, ti tan khun ju pfuhupfuhulon hini Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gwacha chah chi oha an profetan Apo Jos an agkhuy pinalikhat chin a-ammod ta-o? Penatoy cha an amin hana nangpa-innila ay ni umaliyan Hesus an magpong an empfalay Apo Jos. Ja tan ad ugwani ja chaꞌju chi nangpappap ja nangpapatoy ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chaꞌju chi nangpapfanhan cha chin urchin Apo Jos an in-alin hachi angher, muti anong ja agkhuy ju chamchama inunud!” ");
INSERT INTO ifu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chengngor hachi khun munhumarja chin inalin Stephen ja nun-itti-ittib cha hi pfungot cha. ");
INSERT INTO ifu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Muti hi Stephen ja nagwachaan ay ni apfalinan ni Espiritu Santo ja entangad na ad uchu, ja tinnig na hini pfinang Apo Jos ja tinnig na khu hi Hesus an timmataꞌchug ay chuy nun-appit hi agwan Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ja inali na hi, “Chuyya an matikhaw u ad langit, ja chiya hini Na-ilangitan an Takhu an timmataꞌchug ay chuy nun-appit hi agwan Apo Jos!” ");
INSERT INTO ifu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Unchaot chengngor hitay ja hi-u-ugwap cha ja empop cha chin inga cha ja hitatagtag cha an i namohpoh ay Stephen. ");
INSERT INTO ifu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ja nungkhujud cha hija an in-uy hichi pingngit chi pfuglay ja un cha pumpfu-or. Ja hachi nangchalom ay Stephen ja nun-egwallang cha hachi lopfong ay ni timmataꞌchukhan han unga an lala-e an hay ngachana ja hi Saul. ");
INSERT INTO ifu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ja khun cha pumpfu-or ja khun mungkalalag hi Stephen ja inali na hi, “Apo Hesus, alaom hitay lennagwaꞌ.” ");
INSERT INTO ifu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ja nunheppe ja iniꞌgwap na an nangali hi, “Apo Hesus, achim ipfilang hitay enat cha hi pfahor cha.” Unaot inali hichuy ja natoy. ");
INSERT INTO ifu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Niꞌ-apfulut hi Saul hi namatajan cha ay Stephen. Ja nete-a ay chuy an arkhaw ja cho-or hachi mamarpalikhat chin namati ad Jerusalem. Hotti negwa-at hachi namati an immuy hachi apfuglapfuglay hichi provincian chi Judea ja ad Samaria, ja hachi apostol chi nataynan. ");
INSERT INTO ifu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ay chuy natajan Stephen ja immuy hachi namati an linala-e ta i cha inlapfun, ja munnaud chin immayyungan cha khapo ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hi Saul ja penhod na an paꞌ-iyon hachi namati, hotti khun umuy hachi numpunhitugwan cha hon pfinalak na hachi linala-e ja pfinapfai, ja impipfalud na. ");
INSERT INTO ifu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chin namati an negwa-at hachi apfuglapfuglay ja khun cha ekaskasaba hini hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Oha hi Philip an immuy ay ni oha an pfuglay ad Samaria, ja intuchu na an hi Hesus ja hija hini Kristo an hahadchon cha an marpu ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chengngor hachi atakhutakhu hana intuchun Philip ja tinnig cha khu hay hachi milagro an khuna aton, ja pinati cha. ");
INSERT INTO ifu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ti cho-or hachi napukhit an ispiritu an hi-u-ugwap cha an nun-akak ay cha chuy tatakhu an nihuhuꞌlungan cha. Ja chin nun-apechoy ja nun-apilay ja temmenong cha. ");
INSERT INTO ifu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hijaot un nunheglay an-anla cha ay chuy an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gwacha han lala-e ay chuy an pfuglay an hi Simon. Napfajag hitay an khun mun-anap hotti cho-or chi eSamaria an inapfu na. Mumpa-akhaja hija an allonay hijay napfagto an takhu. ");
INSERT INTO ifu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ja enegngor an amin chin tatakhu hi Simon, anong un hachi pfapfaꞌnang ja hana ma-id mapfalina, an khun cha allon hi, “Hitay an takhu ja na-ab-apfunijanan, ti tan gwa ay hija hini ma-id ipadchungana an apfalinan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ja pinati cha hi Simon ti napfajag an napfalipfalijan hachi tatakhu ay ni atona an mun-anap. ");
INSERT INTO ifu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Muti chin namatiyan cha chin engkasaban Philip an Ebanghelyo an mangpa-innila ay ni omaꞌ-atan ni Pun-ap-apugwan Apo Jos ja hi Hesu Kristo, ja numpabautisar cha an linala-e ja pfinapfai. ");
INSERT INTO ifu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ja anong un hi Simon ja niꞌpati ja neꞌpabautisar. Hotti ninitnud ay Philip ja nanannor hija hachi khun maꞌma-at an milagro ja hachi uchumna an achi kayan chi takhu an aton. ");
INSERT INTO ifu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chengngor hachi apostol ad Jerusalem an inapfulut chin eSamaria hini hapit Apo Jos, hotti hennag cha hi Peter ja hi John an umuy hichi. ");
INSERT INTO ifu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Unchaot ne-atam ja engkalalakhan cha hachi namati ta magwachaan cha ay ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ti agkhuy cha pay nagwachaan hi Espiritu Santo ti un cha nabautisaran hi chanum ja angkhay khapo hi namatiyan cha ay Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hotti eneh-an cha Peter ay John hachi ngamoy cha hay hachi namati ja nagwachaan cha ay ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Unagkhu tinnig Simon hichuy enat cha Peter ta nagwachaan hachi namati ay ni Espiritu Santo chin nan-aan cha, ja inchugwagwa na han pihu, ");
INSERT INTO ifu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ja inali na hi, “Ichatanaꞌ mah ay tay an apfalinan ta an amin hana hoꞌ-oꞌ an takhu, ja magwachaan cha hi Espiritu Santo.” ");
INSERT INTO ifu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ja inalinot Peter hi, “Hini mangkay pihum chi mang-uy ay he-a ad impferno. Ti unchah khemhom un manginaan hini apfalinan an ichat Apo Jos? ");
INSERT INTO ifu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Achi a midchum ay tay an tamu, ti anilan Apo Jos an napukhit hini nomnom mu. ");
INSERT INTO ifu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chuꞌkhom hinuy nenomnom mu an napukhit ja nungkalalag a ay Apo Jos ta pakawanon chi-a nu mapfarpfalin. ");
INSERT INTO ifu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ti matikhaw u an nunhegla hini ámoh mu ja nakha-utan a hi pfahor.” ");
INSERT INTO ifu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ja inalin Simon hi, “Ekalalakhanaꞌ mah ta achi ma-at ay ha-in hay hato an inalim.” ");
INSERT INTO ifu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Gwa an napfalin chin nuntihtikhuwan cha Peter ay John ja chin nangtudtuchugwan cha ay ni Hapit Apo Jos, ja numpfangngad cha ad Jerusalem. Ja khun cha ekasaba hini Ebanghelyo hana enenggwa cha an apfarjupfarju ad Samaria. ");
INSERT INTO ifu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Gwacha han angher Apo Jos an nangali ay Philip hi, “Munchayyu a ja enenggwam hichi let-ang ingkhana hi chakngam hini kurha an narpu ad Jerusalem an mi-uy ad Gaza.” ");
INSERT INTO ifu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hotti immuy gwot ja chinittum na han lala-e an e-Etiopia an narpu ad Jerusalem an i neꞌdayaw ay Apo Jos, an umanamut hichi pfuglay cha. Hitay an lala-e ja ma-ar-ali, ti hini haad na ja hijay khun manalimun an amin hi pihun ni Kandace an hinuy chin pungngachan cha ay ni reyna cha ad Etiopia. ");
INSERT INTO ifu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ay chin nunlulugkhanana an kalesa ja khun mumpfaha ay ni intulaꞌ chin profeta an hi Isaiah. ");
INSERT INTO ifu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ja inalin ni Espiritu Santo ay Philip hi, “Hontam hichuy nunlulugkhanana.” ");
INSERT INTO ifu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Temmagtag hi Philip an i nehnot ja chengngor na an khuna pfahaon chin intulaꞌ profeta Isaiah, ja inali na hi, “Ma-awatam chah hini khun mu pfahaon?” ");
INSERT INTO ifu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ja inali na hi, “Achiꞌ numpay, ti ma-id mangtuchu ay ha-in.” Ja inali na ay Philip ta miꞌlukhan hija chin kalesa an nunlulugkhanana. ");
INSERT INTO ifu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ja hitay hapit Apo Jos an khuna pfahaon ja allona hi, “Hay enat na, ja omaꞌ-at hi karnero an achi omar-aleggwah hu-un cha khorton, ja omaꞌ-at khu hi pfoꞌtot an karnero an achi mun-ukha hu-un cha poꞌlehan. Ti khemmegkhenong hija. ");
INSERT INTO ifu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ja pfina-inan cha hija ja achi mungkhochong chin enat cha an nanugi. Ma-id manaphapapit ay ni holag na ti penogpog cha hini piꞌtakhuwana heto lota.” ");
INSERT INTO ifu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ja inalin chin ap-apo ay Philip hi, “Ngachah chi podhon nuy profeta an hapiton ay tay, hini achor na wenno hay uchumna?” ");
INSERT INTO ifu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ja hitay an intulaꞌ Isaiah chi nanghunungan Philip an nangtuchu ay ni omaꞌ-atan Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Khun cha um-umuy ja emmatam cha han gwachaan chi chanum ja inalin chin ap-apo hi, “Tayya mah han chanum hotti mapfalin chah an bautisaranaꞌ?” ");
INSERT INTO ifu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ja inalin Philip hi, “Ti umannung ayya an namati a ja aton ta.” Ja tempfar na ja inali na hi, “Aa, umannung an namatiyaꞌ an hi Hesu Kristo chi Empfalay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hotti impitaꞌchug chin ap-apo hichin kalesa ja immuy cha ay chuy chanum, ja numpabautisar hija ay Philip. ");
INSERT INTO ifu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Muti un chaagkhu chimma-ar ja himpfumagkha ja enekak ni Espiritu Santo hi Philip. Ja ma-id mahpay matikhaw chuy ap-apo ay Philip muti entoloy na an immanamut an khun mun-an-anla. ");
INSERT INTO ifu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Unagkhu hin-aꞌ-alina ja gwa hi Philip ad Azotus, ja lenawlaw na hachi apfuglapfuglay an i khun mangkaskasaba ay ni Ebanghelyo ingkhana hi ne-atamana ad Cesarea. ");
INSERT INTO ifu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Hi Saul ja entoloy na an khun manattata-ot hay hana namati ay Hesu Kristo ja enat na an amin chi mapfalina ta epapatoy na chicha. Hijaot un immuy ay ni natakhay an pachin chi Hudju ");
INSERT INTO ifu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta epa-apja na hay tulaꞌ ta ipatikhaw na hana a-ap-apon hana sinagoga ad Damaskus an gway apfalinana an mamalak hana ah-upana an namati an linala-e wenno pfinapfai ta i na ipahumarja chicha hichi ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Empacheh cha Saul an umuy ad Damaskus ja gwa an omatam cha, ja himpfumagkha ja gwacha han mumpfinang an narpu ad langit ja henenakhana chin gwachaan cha Saul. ");
INSERT INTO ifu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natuꞌ-in ja chengngor na han hapit an nangali hi, “Saul, Saul, anagkha ta parpalikhatonaꞌ ay he-a?” ");
INSERT INTO ifu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ja inalin Saul hi, “Apo, ngay ngachan mu mah?” Ja inalin chin khun munhapit hi, “Ha-in hiHesus an khun mu parpalikhaton. ");
INSERT INTO ifu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Hotti lomeggwat a ta etoloy mu an umuy ad Damaskus hot mipa-innila ay he-a hini atom.” ");
INSERT INTO ifu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hay hachi linala-e an nitnud ay Saul ja intaꞌchug cha ja na-ukum cha ti chengngor cha chin hapit, muti ma-id tinnig cha hi khun munhapit. ");
INSERT INTO ifu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Hotti lemmeggwat hi Saul ja unaagkhu chijaton ja achi mitikhaw chin mata na, hotti un cha pepenchon an in-uy ad Damaskus. ");
INSERT INTO ifu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ja toloh arkhaw an achi tumikhaw hini mata na ja agkhuy nangnangan ja immin-inum. ");
INSERT INTO ifu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Gwa han namati ad Damaskus an hi Ananias ja numpatikhaw hi Apo Hesus ay hija ja inali na hi, “Ananias!” Tempfar na ja inali na hi, “Tojaꞌ ja, Apo.” ");
INSERT INTO ifu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ja inalin Apo Hesus hi, “Umuy a hichi pfalay Judas an negpong ay ni kurha an nangadnan hi Ma-anchong, ta im tikhan han eTarsus an hi Saul an gwa an khun mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ti impatikhaw u ay hija han lala-e an nangadnan hi Ananias an immuy nan-a ay hija ta mepfangngad an mitikhaw hini mata na.” ");
INSERT INTO ifu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Muti inalin Ananias hi, “Aa Apo, muti cho-or hana nangali an hinuy an lala-e ja munnaud an napukhit hana ena-enat na an namarpalikhat hay hana namati ay he-a hichi ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ja tan ad ugwani ja gwah to, ti inchatan hachi a-ap-apon chi papachi hi apfalinana an umali an maniliw ay chaꞌmi an amin an khun mundayaw ay he-a.” ");
INSERT INTO ifu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Muti inalin Apo Hesus hi, “Umuy a, ti hijay piniliꞌ an i mangpa-innila ay ha-in hana Hentil ja anong un hana ari cha ja hana khu i-ibpfam an holag Israel. ");
INSERT INTO ifu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ja ha-in chi mangpa-innila ay hija ay ni atona an mapalikhat khapo hi pangunuchana ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hotti immuy hi Ananias ja himmikhop ay chuy pfalay an agawwachaan Saul. Ja hen-a na hi Saul ja inali na hi, “Akhiꞌ Saul, hi Apo Hesus an numpatikhaw ay he-a ay chuy kurha hi immaliyan ju, ja hijay nannag ay ha-in ta gway aton ni matam an mitikhaw ja ta magwachaan a ay ni apfalinan ni Espiritu Santo.” ");
INSERT INTO ifu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ja unagkhu himpfumagkha ja gwacha han amat hi lahhip an naloꞌgwab ay chuy matan Saul ja mitikhaw mahpay. Amat hichi ja timmaꞌchug hija ja numpabautisar. ");
INSERT INTO ifu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ja unagkhu nangan ja numpfangngad chin pfi-ah na. Neꞌnanannong hi Saul hachi namati ad Damaskus hi at hichi hi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ja ente-a naot an i muntudtuchu hay hachi sinagoga, ja intudtuchu na an hi Hesus chi Empfalay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ja nanor an amin hachi nangngor ja inali cha hi, “Unchah pfu-un hitay chin khun mamarpalikhat hachi namati ay Hesus ad Jerusalem ta ma-umah cha koma? Ja tan immali khu heto ta tiligwona hay hana namati ta ijuy na hay hachi a-ap-apon chi papachi hichi ad Jerusalem.” ");
INSERT INTO ifu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Muti khun pfumiꞌpfi-ah hi Saul an muntudtuchu, ja impatikhaw na an hi Hesus hini Hennag Apo Jos an Mamahhod. Ja ma-id pampfar hachi Hudju ad Damaskus. ");
INSERT INTO ifu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Immuy chi at hichi hi arkhaw ja nunhahapit chin Hudju hay aton cha an mamatoy ay Saul. ");
INSERT INTO ifu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","A-arkhagwan ja anong un lapfi ja gwacha hachi mumpfopfottaꞌ ay ni agwun an pfumutay ay nuy an pfuglay, ta maloh ayya hi Saul ja penatoy cha. Muti inannilan Saul hichuy plano cha. ");
INSERT INTO ifu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hotti gwa han ohan nadhom an hachi namati an tinudtuchugwan Saul, ja in-uy cha hija ay ni alad nuy an pfuglay. Initto cha hija han upfi ja inujuy cha ta gway atona an makak. ");
INSERT INTO ifu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Immuy hi Saul ad Jerusalem ja midchum koma hay hachi namati muti toma-ot cha, ti achi cha pattiyon an umannung an namati hija. ");
INSERT INTO ifu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Muti initnud Barnabas hi Saul ja in-uy na hachi apostol ja impa-innila na chin na-at, an numpatikhaw ja niꞌhapit hi Apo Hesus ay Saul ay ni chalan an mi-uy ad Damaskus. Ja inali na khu an hi Saul ja agkhuy nun-og-okhon an nangkaskasaba ay Hesus hichi ad Damaskus. ");
INSERT INTO ifu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hotti nidchum hi Saul ay chicha ja agkhuy temmaꞌta-ot an nanglawlaw an i khun mangitudtuchu ay Apo Hesus ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ja i khun meꞌhohollahor hi Saul hachi Hudju an munhapit hi Griego muti achi cha podhon an chonglon ja un chaagkhu podhon an patajon hija. ");
INSERT INTO ifu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ja inannilan hachi uchumna an namati an ma-at hitay, hotti intulud cha hija hichi ad Cesarea ja impilukhan cha han papor ta umuy hi pfalay cha ad Tarsus. ");
INSERT INTO ifu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Amat hichi ja nepokhong chin aparpalikhatan hachi namati hi apfuglapfuglay hichi ad Judea ja ad Galilee ja ad Samaria, ja khun cha omer-ellog hi pammati. Khun cha chomchom-or khapo ay ni tolong ni Espiritu Santo, ja niꞌtakhu cha an gway ta-ot cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hi Peter ja khuna lawlagwon hachi apfuglapfuglay ta i na pfihhitaon hana namati. Ja immuy hichi ad Lidda han ohan arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ja chinakngana han lala-e an hi Eneas an napechoy an agkhuy pfimmangpfangon hi gwaloy tagwon. ");
INSERT INTO ifu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Inalin Peter hi, “He-a Eneas, epatenong chi-a ay Hesu Kristo hotti tumaꞌchug a ja linupig mu hini opfog mu.” Ja natantannaꞌchug hi Eneas. ");
INSERT INTO ifu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Cho-or hachi tatakhu ad Lidda ja ad Sharon an nannig an temmenong hija ja namati cha khu ay Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ja gwacha han ohan pfupfai an namati ad Jopa an hi Tabita, an hay ngachana hi hapit chi Griego ja Dorkas, an hay podhona an hapiton ja urha. Hitay an hi Dorkas ja cho-or hana maphod an khuna aton, ja khuna tulungan hay hana napubli. ");
INSERT INTO ifu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ay chuy an agawwachaan Peter ad Lidda ja nunchokhoh hi Tabita ja natoy. Amat hichi ja enamoh cha ja empapekheng cha han nangennaꞌjab an kwarto. ");
INSERT INTO ifu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ja chengngor hachi namati ad Jopa an gwacha hi Peter hichi ad Lidda an nehnot ad Jopa, hotti hennag cha han chugwa an lala-e an i numpakpaka-ahi an nangali hi, “Umuy ta-o gwot mah hichi pfuglay mi.” ");
INSERT INTO ifu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hotti niꞌ-uy hi Peter ay chicha. Ne-atam cha ad Jopa ja in-uy cha hija hichin nangennaꞌjab an kwarto an gwachaan chuy natoy. Ja khinagong hachi pfalo hi Peter ja khun cha kumila ja khun cha ipatikhaw hachi lopfong an inukhutan Dorkas chin atattakhu na. ");
INSERT INTO ifu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Impapfutay Peter an amin hachi tatakhu ja nunheppe an nungkalalag. Ja inligkhoh na ay chuy natoy ja inali hi, “Tabita, pfumangon a!” Unagkhu la-ahna ja chiniyat na, ja tinnig na hi Peter ja pfimmangon hija. ");
INSERT INTO ifu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Penchon Peter chin ngamoy na ta tumaꞌchug, ja enajakhana hachi pfalo ja hachi uchumna an namati ja impatikhaw na an timmakhu hi Dorkas. ");
INSERT INTO ifu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chengngor an amin hachi tatakhu ad Jopa hitay an na-at ja cho-or chay namati ay Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Gwacha han hi Simon ad Jopa an khun mun-okhot hi lalat ja hijay nummangili ay Peter hi at hichi hi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gwa han ohan lala-e ad Cesarea an hi Kornelius an kapitan han hingkhahot an hinchalo an nginadnan cha hi Bonggoy chi Italy. ");
INSERT INTO ifu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hitay an lala-e ja pfu-un Hudju muti khun meꞌdaydayaw ay Apo Jos. Ja amat cha khu hina an amin an hen-a-amma. Cho-or chi khuna ichat an tolong hay hana ma-id mapfalina an Hudju, ja e-epong na an khun mungkalalag ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gwa han himpumupujaw an khun mungkalalag, ja gwa han impatikhaw Apo Jos ay hija. Ja naꞌna-atigkhana han henongkhop an angher Apo Jos ay chuy a-adchaana. Ja inalin chin angher ay hija hi, “Kornelius!” ");
INSERT INTO ifu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Temma-ot hi Kornelius ja nunchiyat na an nannig ay chuy angher ja inali na hi, “Ngachah nuy, Apo?” Ja inalin chin angher hi, “Chengngor Apo Jos hana kalalag mu ja tinnig na an amin hana khun mu aton an tomolong hana napubli, ja inapfulut na. ");
INSERT INTO ifu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hotti honakhom hay umuy ad Jopa ta i na pfokhaan han lala-e an hi Simon Peter ");
INSERT INTO ifu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","an nunnanannong han pfalay Simon an nipipingngit hichi baybay. Hay tamun Simon ja un khun mun-ekhe ja mun-okhot hi lalat.” ");
INSERT INTO ifu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Unot nakak chin angher, ja enajakhan Kornelius han chugwa an ene-eꞌ-op na ja han ohan hinchalo na an khun tomolong ay hija ja khun khu meꞌdayaw ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ja inali na an amin chin na-at, ja hennag na chicha an umuy ad Jopa. ");
INSERT INTO ifu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chin nun-inggwiꞌgwiit hi nahaꞌ-ad ja gwa an omatam hachi hennag Kornelius an khun umuy ad Jopa. Netongor ja immuy hi Peter ay chuy pfopfong ni pfalay Simon an imungkalalag. ");
INSERT INTO ifu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hemmenaang hi Peter ja podhona an mangan. Gwa an khun cha ehakhana chin anuna, ja gwacha han impatikhaw Apo Jos ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Amat hi nagwangan ad uchu ja gwacha han amat hi uloh an ampfilog an khun ma-ujuy, an nun-akhaꞌchan chin nunchinugkhuwana. ");
INSERT INTO ifu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ja nipfapfaꞌjug hachi numpfino-ob-on an animar ja nidchum hana he-adcha-adchap ay tay lota, ja hana hetayyatayyap ad uchu, an panijagwon chi Hudju hi ihcha. ");
INSERT INTO ifu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ja gwacha han hapit an nangali hi, “Tayya, Peter, mumparti a hi ihcham.” ");
INSERT INTO ifu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Muti inalin Peter hi, “Achiꞌ aton, Apo, ti ma-id chi inih-ihchaꞌ hi amat heto, ti paniyaw ay ni urchin.” ");
INSERT INTO ifu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ja inalin khu chin hapit hi, “Achim allon hi paniyaw hana allon Apo Jos ad ugwani hi pfu-un paniyaw.” ");
INSERT INTO ifu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ja numpitlo an inali na hitay ja un tomolo chin uloh ad uchu. ");
INSERT INTO ifu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Khun nomnomnomon Peter hini penhod tay tinnig na an hapiton, ja netongor ja emmatam hachi hennag Kornelius ja impatuchu cha hana tatakhu hini agwun an umuy hichi pfalay cha Simon. Gwa an emmatam cha ay chuy pfalay Simon ja immuy cha ay chuy pantaw, ");
INSERT INTO ifu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ja nun-ali cha ta hanhanan cha nu hichuy hini pfalay an nunnangngan Simon an nangadnan khu hi Peter. ");
INSERT INTO ifu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Hi Peter ja gwa an khuna nomnomnomon chin impatikhaw Apo Jos ja inalin ni Espiritu Santo ay hija hi, “Nuy han tolo an linala-e an manapor ay he-a. ");
INSERT INTO ifu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hotti khumahad a ta im tikhan. Achi a mun-okhon an miꞌjuy, ti ha-in chi nannag ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Khimmahad hi Peter ja inali naot hachi linala-e hi, “Ha-in hini khun ju hingiton hotti ngay mahapor ju?” ");
INSERT INTO ifu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ja inali cha hi, “Hennag chaꞌmi ay Kornelius an kapitan hichi ad Cesarea. Magpong hija an takhu, ja khun meꞌdayaw ay Apo Jos, ja an amin hana papadchung mu an Hudju ja etoꞌ cha hini aphod na. Ja gwacha han angher Apo Jos an nangali ay hija ta epa-ajag chi-a hichi pfalay cha ta chonglona hay ituchum.” ");
INSERT INTO ifu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hotti empaghop Peter ja minangili na chicha ay chuy nadhom. Nun-inggwiꞌgwiit ja neꞌpacheh na ay chicha an umuy, ja nitnud khu hachi uchumna an namati an eJopa. ");
INSERT INTO ifu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nun-inggwiꞌgwiit khu ja emmatam cha hichi ad Cesarea an punhohhochan cha Kornelius an hen-a-amma ja chin uchumna an enajakhana an ibpfa na ja khakhayyum na. ");
INSERT INTO ifu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ja gwa an humikhop hi Peter ay chuy pfalay cha ja chinittum Kornelius ja nunheppe an mundayaw ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Muti empaleggwat Peter ja inali na hi, “Achi a munheppe ay ha-in. Tumaꞌchug a, ti un ta numpadchung an takhu.” ");
INSERT INTO ifu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ja khun munhapit cha Peter ay Kornelius hi khun cha humikhupan hichi pfalay ja tinnig Peter hachi cho-or an tatakhu an na-amung. ");
INSERT INTO ifu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ja inali na ay chicha hi, “Anila ju an paniyaw ay chaꞌmi an Hudju chi i midchum hana Hentil muti intuchun Apo Jos ay ha-in hi achiꞌ koma panijagwon chi hay ujaꞌ idchuman hana papadchung u an tatakhu an pfu-un Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hijaot unaꞌ agkhuy nun-ad-achi chin nangpa-ajakhanaꞌ ja tan immalijaꞌ. Hotti ngachah ni epfokha ju ay ha-in?” ");
INSERT INTO ifu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ja inalin Kornelius hi, “Ay tay immuy an ar-arkhaw ja gwa han hinpumupujaw ja khunaꞌ mungkalalag heto pfalay mi. Unagkhu himpfumagkha ja numpatikhaw han lala-e an timmataꞌchug an pomooꞌ chi lopfong na. ");
INSERT INTO ifu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ja inali na ay ha-in hi, ‘Kornelius, chengngor Apo Jos hana kalalag mu ja tinnig na an amin hana khun mu aton an tomolong hana napubli, ja inapfulut na. ");
INSERT INTO ifu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hotti honakhom hay i mamokhaan han hi Simon Peter hichi ad Jopa an nunnanannong han pfalay Simon an nipipingngit hichi baybay. Hay tamun Simon ja un khun mun-ekhe ja mun-okhot hi lalat.’ ");
INSERT INTO ifu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hotti tan empa-ajag u he-a ja maphod ta immali a. Ja tan na-amung ami ja anila mi an gawwa hi Apo Jos hotti podhon mi an chonglon hay inalin Apo Jos hi ipa-innilam ay chaꞌmi.” ");
INSERT INTO ifu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ja ente-an Peter an nunhapit ja inali na hi, “Ad ugwani ja inannilaꞌ an munchichipat hini pannig Apo Jos an amin hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ti apfuluton Apo Jos an amin hana nahamad chi aton cha an mundayaw ay hija ja khun cha aton hini podhona, anong un numpfino-ob-on chi narpugwan cha. ");
INSERT INTO ifu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Hotti anila ju hini Ebanghelyo an impa-innilan Apo Jos ay chaꞌmi an holag Israel an khapo chin enat Hesu Kristo hi natajana hichi kros ja napogpog chin niꞌpfipfinnuhulan ta-o ay Apo Jos. Ja hi Hesu Kristo chi Apo ta-o an amin an tatakhu. ");
INSERT INTO ifu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Anila ju an, napfalin chin nangkaskasabaan John Bautista ay ni aton an mumpabautisar, ja nipa-innila hana ena-enat Hesu Kristo hichi ad Galilee ja hana uchumna an apfuglapfuglay ad Judea. ");
INSERT INTO ifu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ja anila ju an inchat Apo Jos hini Espiritu Santo ja hini apfalinana ay Hesus an eNazaret. Hotti an amin chi immajana ja cho-or chi enat na an maphod, ja empatenong na an amin hana pinarpalikhat Satanas, ti gwacha hi Apo Jos ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Chaꞌmi an apostol ja tinnig mi an amin hana enat na hichi ad Jerusalem, ja hana uchumna an pfuglay chi Hudju. Ja empepfakhat cha hija han kros ja natoy. ");
INSERT INTO ifu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Muti chin me-atlon arkhaw hi natajana ja minahuwan Apo Jos hija. Ja impatikhaw Apo Jos hija ");
INSERT INTO ifu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ay chaꞌmi an timmakhu, ja neꞌ-an ami ay hija. Muti agkhuy nipatikhaw an amin hi tatakhu an un angkhay chaꞌmi an pinilin Apo Jos an i manihtikhuwan ay ni tinnig mi. ");
INSERT INTO ifu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ja hi Hesus chi nangali ay chaꞌmi hi i ami mangaskasaba ta ipa-innila mi hana tatakhu an hijay pinilin Apo Jos an manugi hana mamattakhu ja hana nun-atoy ay nuy arkhaw an punhugijana. ");
INSERT INTO ifu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ja hitay an hi Hesus chin inalin an amin hachi profetan Apo Jos hi khapo ay hija ja mapakawan hana pfahor an amin chi mamati ay hija.” ");
INSERT INTO ifu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Gwa an khun pay munhapit hi Peter ja nagwachaan an amin hachi nunchochongngor ay ni apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ja nanor hachi namati an Hudju an nitnud ay Peter, ti tinnig cha an anong un hachi Hentil ja inchatan Apo Jos ay ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ti chengngor cha an khun cha munhapit hi numpfino-ob-on an hapit an pfu-un hapit cha, ja khun cha mundaydayaw ay Apo Jos. Ja inalin Peter hi, ");
INSERT INTO ifu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tan nagwachaan hato Hentil hi Espiritu Santo an amat khu ay chita-o, hotti ma-id koma mangpagwa ay chicha hi abautisaran cha hi chanum.” ");
INSERT INTO ifu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hotti inalin Peter ta mumpabautisar cha ta ipatikhaw cha an hi Hesu Kristo chi Apo cha, ja enat cha. Pemmakhomakhoh cha ay Peter ta mihichi pay hi at hichi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Chengngor hachi apostol ja hachi papadchung cha an namati ad Judea chin na-at, an anong un hana Hentil ja namati cha ay ni hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chin numpfangngachan Peter ad Jerusalem ja pinahiw hachi uchumna an Hudju an namati, ti khun cha pay unuchon an amin hana urchin chi Hudju. Ja inali cha hi, ");
INSERT INTO ifu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Achi maphod hini enat mu ti immuy a ay ni pfalay hana Hentil, ja neꞌ-an a pay ay chicha!” ");
INSERT INTO ifu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hotti enep-ephod Peter an nangpa-innila an amin chin na-at ja inali na hi, ");
INSERT INTO ifu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Hichin achaaꞌ ad Jopa ja gwa han ohan arkhaw an khunaꞌ mungkalalag, ja gwacha han nipatikhaw ay ha-in. Tinnig u han omaꞌ-at hi ampfilog an uloh an nun-akhaꞌchan chin nunchinugkhuwana, an khun ma-ujuy chin achaaꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ja naꞌna-atigkhaꞌ hay hachi numpfino-ob-on an animar an nipfaꞌjug ay chuy uloh. Gwacha hana atap an animar ja hana he-adcha-adchap ay tay lota ja hana hetayyatayyap ad uchu, an panijagwon ta-o an Hudju hi ihcha. ");
INSERT INTO ifu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ja chengngor u han hapit an nangali hi, ‘Tayya, Peter, mumparti a hi ihcham.’ ");
INSERT INTO ifu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tempfar u ja inaliꞌ hi, ‘Achiꞌ aton, Apo, ti ma-id inih-ihchaꞌ hi amat heto, ti paniyaw ay ni urchin.’ ");
INSERT INTO ifu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ja inalin chin hapit an narpu ad uchu hi, ‘Achim allon hi paniyaw hana allon Apo Jos ad ugwani hi pfu-un paniyaw.’ ");
INSERT INTO ifu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ja numpitlo an inali na hitay ja un tomolo chin uloh ad uchu. ");
INSERT INTO ifu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ja ay chuy gwot ja emmatam han tolo an linala-e an hennag han kapitan chi hinchalo ad Cesarea an immali an mamokhaan ay ha-in. ");
INSERT INTO ifu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ja inalin ni Espiritu Santo an mitnuchaꞌ ay chicha, an achiyaꞌ mun-okhon. Ja nitnud khu hay hato unum an ibpfa ta-o an namati ja immuy ami hichi pfalay kapitan Kornelius. ");
INSERT INTO ifu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ja impa-innilan Kornelius han tinnig na an angher an timmataꞌchug hichi pfalay cha an nangali hi, ‘Honakhom hay umuy ad Jopa an i mangajakhan han lala-e an hay ngachana ja hi Simon Peter. ");
INSERT INTO ifu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ti hijay mangtuchu ay chaꞌju an hen-a-amma ay ni aton ju an miꞌtakhu ay Apo Jos hi ma-id chi pogpogna.’ ");
INSERT INTO ifu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ja unagkhu gwa an khunaꞌ munhapit ja immali hini Espiritu Santo ay chicha an amat hichin na-at ay chita-o chin Pentekostes. ");
INSERT INTO ifu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ja nenomnom u chin inalin Apo Hesus an, ‘Binautisaran John hana tatakhu hi chanum muti mabautisaran aju hi Espiritu Santo.’ ");
INSERT INTO ifu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hot tan hay hana Hentil, ja miꞌpadchung cha ay chita-o ad ugwani, ti inchat Apo Jos ay chicha hini Espiritu Santo chin namatiyan cha ay Apo Hesu Kristo. Hotti un chah ha-in an pfaar Apo Jos chi mangpagwa ay ni penhod na an aton?” ");
INSERT INTO ifu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Un chaagkhu chengngor hitay an inalin Peter ja empokhong cha an mamahiw ay hija, ja nundaydayaw cha ay Apo Jos an allon cha hi, “Hotti amat hina ayya, ja ekhohkhohan Apo Jos hay hana Hentil, ta gway aton cha an man-ug hi pfahor cha ta miꞌtakhu cha hi ma-id chi pogpogna.” ");
INSERT INTO ifu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nete-a chin namatajan cha ay Stephen ja khun cha palikhaton hachi namati ad Jerusalem hotti negwa-at cha. Ja immuy hana uchumna ad Fenisia ja ad Cyprus ja ad Antokya, ja khun cha muntudtuchu ay ni hapit Apo Jos, muti hachi Hudju ja angkhay chi tinuchugwan cha. ");
INSERT INTO ifu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Muti gwacha hana uchumna an eCyprus ja eCyrene an immuy ad Antokya, ja inidchum cha khu hay hana Hentil an engkasabaan ay ni omaꞌ-atan Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ja khapo ta gwa hini apfalinan Apo Jos ay chicha an muntudtuchu, ja cho-or chi namati, ja niꞌ-unud cha ay Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chengngor hachi namati ad Jerusalem chin na-at ad Antokya hotti hennag cha hi Barnabas ta umuy hichi. ");
INSERT INTO ifu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ne-atam hija ja nun-an-anla chin nanginnilaana ay ni nangekhohkhohan Apo Jos hachi tatakhu. Hotti tinukhuna chicha ta ehamad cha an mamati ay Apo Hesus ta hija ja angkhay chi unuchon cha. ");
INSERT INTO ifu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Maphod an takhu hi Barnabas an nagwachaan ay ni apfalinan ni Espiritu Santo ja pammati, ja cho-or chi tinulungana ad Antokya ta namati cha khu ay Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Immuy hi Barnabas ad Tarsus ta i na hingiton hi Saul. ");
INSERT INTO ifu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chinakngana ja initnud na an numpfangngad ad Antokya. Umuy chi ohay tagwon hi ninidchuman cha ay chuy khun a-am-amungan hachi namati ja tinuchugwan cha hachi cho-or an tatakhu. Ja hachi namati ad Antokya chi nahhun an na-ali an Krischano. ");
INSERT INTO ifu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Hichin nihihidchijan cha Barnabas ay Saul ad Antokya ja gwacha hana profetan Apo Jos an immali an narpu ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ja gwacha han oha ay chicha an hi Agabus, ja timmaꞌchug hichi na-amungan hachi namati, ja impa-innilan ni Espiritu Santo ay hija ta allona hi ma-ulat an amin chi apfuglapfuglay. Ja immannung an na-at chin inali na hichin nun-ap-apugwan Klaudius an Emperador. ");
INSERT INTO ifu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chengngor hachi namati ad Antokya chin inalin Agabus, ja nunhahapit cha ta ichatan cha hachi i-ibpfa cha an namati ad Judea hay mapfalin an ichat chi oha-ohanna hi tolong. ");
INSERT INTO ifu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ja empachon cha chin amung cha ay cha Barnabas ay Saul ta chichay mangchat hay hachi mangpangpangulu hi namati ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ay chuy an timpo ja empapfalak Ari Herod chin uchumna an namati ad Jerusalem ja pinalikhat na. ");
INSERT INTO ifu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ja empapotor na chin ulun James an ibpfan John. ");
INSERT INTO ifu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ja tinnig Herod an penhod hana Hudju chin enat na hotti impapfalak na khu hi Peter. Netongor ay chuy ja pfehtan chi Hudju an Panganan cha hi Tenapay an Ma-id Pfinoꞌpfoꞌ na. ");
INSERT INTO ifu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Gwa an pfinalak cha hi Peter ja impipfalud na, ja gwacha han himpolo ta han unum an hinchalo an munggwarja, ta hen-aꞌpat cha an mumpenallog an munggwarja ay hija. Ti nenomnom Ari Herod an humarjaon hi Peter ay ni achoꞌlan chi tatakhu nu mapfalin chin ngilin ja unaot epapatoy. ");
INSERT INTO ifu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hotti gwinagwarjaan cha hi Peter hichi pfaluchan, muti hachi namati ja pena-ennongan cha an nungkalalag ay Apo Jos ta tulungana hija. ");
INSERT INTO ifu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chin mun-inggwiꞌgwiit ja un hugijon Herod hi Peter, hotti naloꞌ hija an napfapfangkelengan hi chugwa hi pfangkeleng, ja khinakhawwan han chugwa an gwarja. Ja gwacha khu hana nunggwarja chin pantaw chuy pfaluchan. ");
INSERT INTO ifu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Unagkhu himpfumagkha ja gwacha han angher Apo Jos an timmataꞌchug ay chuy achaan Peter ja nahilagwan chin pfaluchan. Enegwor na hi Peter ja inali na hi, “Khalakhalom an pfumangon.” Pfimmangon hi Peter ja na-aan chin pfangkeleng ay chuy ngamoy na. ");
INSERT INTO ifu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ja inalin khu chin angher hi, “E-apjam hini pfalekeh mu ja nunhapato a.” Ja enat Peter ja inalin khu chin angher hi, “Alaom hinuy lopfong mu ja nitnud a ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nitnud hi Peter ay chuy angher an pfumutay muti khemhona un empa-enop Apo Jos hichuy khun ma-at. ");
INSERT INTO ifu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Linahin cha chin chugwa an pantaw an nagwarjaan ja gwa an me-atam chin khumoꞌ an pantaw an mi-uy hichi kurha, ja himpfumagkha ja nipfughor. Gwa an khun cha chumalan ay chuy kurha ja unagkhu aꞌ-alina ja nama-id chinangher. ");
INSERT INTO ifu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Amat hichi ja nunhalemottongan Peter an achi khun mun-en-enop ja inali na hi, “Immannung an hennag Apo Jos hinuy angher na ta haniyanaꞌ ay ni aton Ari Herod, ja hana napukhit an penhod hana Hudju an ma-at ay ha-in.” ");
INSERT INTO ifu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Amat hichi ja immuy hi Peter hichi pfalay cha Mary an inan John Mark an na-amungan hachi cho-or an namati an khun mungkalalag. ");
INSERT INTO ifu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nungkorkug hi Peter ay chuy pantaw ja immuy han takhala an hi Roda ta i na tikhan. ");
INSERT INTO ifu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Unaagkhu immatunan chin hapit Peter ja nunheglay an-anla na ja nalichuwana an mangpfughor chin pantaw, ja unagkhu temmagtag an i mangpa-innila hachi uchumna an gwacha hi Peter hichi pfutayna an timmataꞌchug. ");
INSERT INTO ifu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ja inali cha hi, “Un a kaykhu mun-angaw!” Muti impapilit na an umannung, ja inali cha hi, “Unakkay hini angher na.” ");
INSERT INTO ifu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Khun mungkomungkorkug hi Peter hotti i cha impfughor. Ja un chaagkhu tinnig an hija tatagwa ja nanor cha. ");
INSERT INTO ifu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Penajapan Peter chicha ta khomenong cha, ja impa-innila na chin enat Apo Jos an nangpapfutay ay hija hichi pfaluchan. Ja inali na khu hi, “Ipa-innila ju hitay an na-at ay James an akhin Apo Hesus ja hana uchumna an a-akhi ta-o an namati.” Ja tenaynana chicha ta umuy han ohan pfuglay. ");
INSERT INTO ifu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Unagkhu gwa an naꞌ-arkhaw ja ma-id maptoꞌ hi nomnomon hachi hinchalo an khun munggwarja, ti nama-id hi Peter. ");
INSERT INTO ifu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Impahingit Ari Herod hi Peter muti agkhuy cha chinakngan. Ja hinugi na hachi hinchalo an nunggwarja ta matoy cha. Napfalin hitay ja nakak hi Ari Herod ad Judea ja immuy ad Cesarea ta nihihidchi. ");
INSERT INTO ifu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Chin agawwachaan Ari Herod hichi ja nunlinapoh chin pfungot na hay hachi tatakhu ad Tiro ja ad Sidon. Hotti khun cha hingiton hay aton cha an meꞌpfajaw ay hija, ti hini pfuglay an nun-ap-apugwan Herod chi khun arpugwan ni anun cha. Hay enat cha ja pinahhun cha an niꞌhapit han hi Blastus an khun munggwarja ay ni pfalay Ari Herod ta tomolong hija ay ni aton cha an meꞌpfajaw ay Herod. Ja nun-oh-ohha cha an immuy ay Herod ta i cha uyyachon chin pfungot na. ");
INSERT INTO ifu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nachakngan chin arkhaw an eneꞌchan Ari Herod hi a-amungan hachi tatakhu, ja nunlopfong hija hi lopfong chi ari ja inumpfun ay ni trono na. Ja nunhapit hija hachi atakhutakhu. ");
INSERT INTO ifu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Chengngor hachi tatakhu ja iniꞌgwap cha an nangali hi, “Pfu-un takhu hitay khun munhapit muti oha an ab-apfunijan an madayaw!” ");
INSERT INTO ifu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ja inapfulut Ari Herod an dayawon cha hija an agkhuy na inali an hi Apo Jos chi madayaw ja angkhay. Hotti ay chuy gwot ja nunchoghon ni angher Apo Jos hija, ja nun-a-an chi pfekheh chin achor na ja unot matoy. ");
INSERT INTO ifu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ja khun mitudtuchu hini hapit Apo Jos hi apfuglapfuglay ja khun chomchom-or hachi namati. ");
INSERT INTO ifu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ja khinibpfoh cha Barnabas ay Saul chin tamu cha ad Jerusalem ja numpfangngad cha ad Antokya ja initnud cha hi John an hi Mark khu chi ngachana. ");
INSERT INTO ifu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Hichi ad Antokya ja nidchum hay hana namati hana uchumna an profeta ja hana manudtuchu. Hay ngachan hay hato ja hi Barnabas, hi Simeon an nangadnan khu hi Niger, hi Lucius an eCyrene, hi Manaen an nun-ibpfan Ari Herod, ja hi Saul. ");
INSERT INTO ifu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gwa han ohan arkhaw an khun mun-ayunar hay hachi namati ad Antokya ja khun cha mundaydayaw ay Apo Jos. Ja inalin ni Espiritu Santo ay chicha hi, “Et-on ju cha Barnabas ay Saul, ti gwa han ipatamuꞌ ay chicha.” ");
INSERT INTO ifu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hotti entortoloy cha an mundaydayaw ja nun-ayunar ja hen-a cha hi Barnabas ja hi Saul ta engkalalakhan cha ja un chaot honakhon chicha. ");
INSERT INTO ifu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Amat hichi ja enedchong ni Espiritu Santo cha Barnabas ay Saul ta nunchayyu cha ad Seleusia ja un chaot munlukhan hi papor ta umuy cha ad Cyprus. ");
INSERT INTO ifu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ja nitnud hi John Mark an tomolong ay chicha. Un chaot emmatam hichi ad Cyprus ja intaꞌchug cha han pfuglay an ad Salamis, ja ente-a cha an muntudtuchu ay ni hapit Apo Jos hay hana sinagoga an khun a-amungan chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Leneꞌgwoh cha ad Cyprus ja ingkhana ad Pafos an nanittuman cha han ohan Hudju an hi Bar-Jesus an mun-anap, ja allona hi un profetan Apo Jos hija muti achi umannung. ");
INSERT INTO ifu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hitay an mun-anap ja hijay pun-i-ibpfan han manomnom an Gobernador an hi Sergius Paulus. Empapfokhan tay Gobernador cha Barnabas ay Saul ti penhod na an chonglon hini hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Muti hi Bar-Jesus an hay ngachana hi hapit chi Griego ja Elimas, an hay podhona an hapiton ja mun-anap, ja podhona an paꞌ-iyon chin khun ituchun cha Barnabas ay Saul ta achi pattiyon chin Gobernador. ");
INSERT INTO ifu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Muti hi Saul an nangadnan hi Paul ja nagwachaan ay ni apfalinan ni Espiritu Santo ja neꞌpfottog ay Elimas ");
INSERT INTO ifu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ja inali na hi, “He-a an empfalay chi diablo, he-a hini pfumuhur an amin hi magpong. Na-uti-ot hini nomnom mu, ja ehahallam an amin hana magpong an hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ad ugwani ja dusaon chi-a ay Apo Jos. Pfulagwon chi-a ta achi mitikhaw hini matam hi at hichi hi arkhaw.” Unagkhu himpfumagkha ja achi mitikhaw chin matan Elimas ja khun mun-ap-apo-ap hay mamchon ay hija. ");
INSERT INTO ifu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Unagkhu tinnig chin Gobernador hitay an na-at ay Elimas ja namati, ti nakaskasda-aw hini apfalinan Apo Hesus an khun cha itudtuchu. ");
INSERT INTO ifu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Amat hichi ja nakak cha Paul hichi ad Pafos ja nunlukhan cha han papor an umuy hichi ad Perga an provincian chi Pamfilia, ja un muntaynan hi John Mark ta mumpfangngad hichi ad Jerusalem. ");
INSERT INTO ifu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amat hichi ja nakak cha Paul ad Perga ta umuy cha hichi ad Antokya an provincian chi Pisidia. Ne-atam cha ad Antokya ja unot nachakngan chin Hapfachu an pungngilinan chi Hudju ja niꞌjuy cha hichi sinagoga ja ni-ipfun cha. ");
INSERT INTO ifu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Napfalin an nepfaha chin intulaꞌ Moses ja chin uchumna an intulaꞌ hachi profetan Apo Jos, ja empapfokhan hachi a-ap-apon chuy sinagoga cha Paul ja inali cha hi, “A-akhi, nu gwacha ayya chi piꞌtukhun ju ja niꞌ-ali ju mah.” ");
INSERT INTO ifu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hotti lemmeggwat hi Paul ja penajapana hachi tatakhu ta khomenong cha, ja inali na hi, “Chaꞌju an a-akhiꞌ an holag Israel ja chaꞌju khu an Hentil an khun meꞌdayaw ay Apo Jos, chonglon ju hitay alloꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hini Jos ta-o an holag Israel ja pinili na chin a-ammod ta-o ja nunholakhona chicha ta chenom-or cha hichi ad Egypt. Ja enekak na chicha ad Egypt khapo ay ni otong an apfalinana. ");
INSERT INTO ifu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hinalimunana chicha hi apat chi polo hi tagwon hichi let-ang ingkhana hi ");
INSERT INTO ifu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","enapfak na chin peto an nasyon hichi ad Kana-an ja empfanoh na chin a-apo ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nete-a hichin immajan cha ad Egypt ingkhana chin immajan cha ad Kana-an ja immuy chi apat hi khahot ta han lemay polo hi tagwon. Napfalin hitay ja enhaad Apo Jos hana mun-ap-apo ay chicha ingkhana hi nun-ap-apugwan Samuel an profeta na. ");
INSERT INTO ifu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chin nun-ap-apugwan Samuel ja empfokha cha ay Apo Jos hay Ari cha. Ja pinilin Apo Jos hi Saul an empfalay Kish an holag Benjamin ta hijay mun-ari, ja nun-ari hi apat chi poloh tagwon. ");
INSERT INTO ifu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ja enaan Apo Jos hi Saul ta empallog na hi Ari David an mun-ari ay chicha. Ja tinihtikhuwan Apo Jos hini omaꞌ-atan David hi nangarjana hi, ‘Hinuy empfalay Jesse an hi David, ja podpodhoꞌ hija, ti khuna unuchon an amin hana penhod u hi atona.’ ");
INSERT INTO ifu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Holag David chin inalin Apo Jos an Manakhu ay chita-o an holag Israel, ja nipa-annung hitay chin nangpa-aliyana ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nahhun hi John Bautista an immali ja unot hi Hesus. Ja engkasaban John ay chita-o an holag Israel an mahapor an chuꞌkhon ta-o hana pfahor ta-o ja numpabautisar ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Unot gwa an mapfalin chin tamun John ja inali na hi, ‘Ngay anila ju hi omaꞌ-ataꞌ? Pfu-un ha-in hini mamahhod an Manakhu hi tatakhu. Hijay metob ay ha-in, ja anong un u podhon an mumpfalin hi himpfut na ja achiyaꞌ mipfilang, ti munnaud hija an napfagto.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ja entoloy Paul an nunhapit ja inali na hi “A-akhiꞌ an holag Abraham, ja chaꞌju khu an Hentil an khun meꞌdayaw ay Apo Jos, chita-o chi nangpa-innilaan Apo Jos ay ni atona an manakhu hi tatakhu. ");
INSERT INTO ifu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Muti hachi tatakhu hichi ad Jerusalem ja chin a-ap-apo cha, ja agkhuy cha immatunan an hi Hesus hini Hennag Apo Jos an Mamahhod. Ja anong un cha khun pfahaon hi ahapfahapfachu hana intulaꞌ chin profetan Apo Jos chin nahop, ja agkhuy cha na-awatan an hi Hesus hini khun cha hapiton ay ni intulaꞌ cha. Muti impa-annung cha chamchama hay hachi inalin hachi profeta chin nanugijan cha ay Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Anong un ma-id pfahor na hi pamatajan cha, ja chinagchag cha hi Pilato ta empapatoy na. ");
INSERT INTO ifu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gwa an napfalin an impa-annung cha an amin chin nitulaꞌ an ma-at ay Hesus ja empah cha hija chin kros ja i cha inlupfuꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Muti minahuwan Apo Jos hija. ");
INSERT INTO ifu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Chin nummahuwana ja cho-or chi arkhaw hi numpatikhana chin numpun-ibpfa na an narpu ad Galilee hi immajan cha hichi ad Jerusalem. Ja chicha ad ugwani chi mangpa-innila ay Hesus ay chita-o an Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Hotti tayya an immali ami heto an mangpa-innila ay tay maphod an hapit Apo Jos an hija hitay. Chin ingkarin Apo Jos chin a-ammod ta-o, ");
INSERT INTO ifu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ja impa-annung na ad ugwani ay chita-o an holag cha chin nummahuwan Hesus. Hijah tay chin inalin Apo Jos ay ni me-aggwa an Psalm hi nangarjana hi, ‘He-a chi empfalay u Ja ad ugwani ja impatikhaw u an ha-in chi amam.’ ");
INSERT INTO ifu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ja gwa hana uchumna an ingkarin Apo Jos an nipa-annung ay Hesus. Hay ingkari na ja mahuwana hi Hesus ta achi khu matoy, ja hitay chi oha an nitulaꞌ an hapit Apo Jos hi nangarjana hi, ‘Ichat u an ichat ay chaꞌju an amin hana bindisyon an ingkariꞌ ay Ari David.’ ");
INSERT INTO ifu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hi Hesus hini nipa-annungan tay an ingkari na, ti gwacha khu han allon ni oha an Psalm an inalin Ari David ay Apo Jos hi, ‘Anilaꞌ an ha-in an naꞌna-unnud an empfalay mu, ja achim apfuluton an mapfuluꞌ hitay achor u.’ ");
INSERT INTO ifu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Hi David ayya, napfalin an enat na hana penhod Apo Jos chin atattakhu na ja natoy. Ja nilupfuꞌ ay ni nilub-an chin a-ammod na ja napfuluꞌ chin achor na. ");
INSERT INTO ifu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Muti hi Hesus ayya ja agkhuy napfuluꞌ chin achor na ti minahuwan Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Entoloy Paul an nunhapit, ja inali na hi, “A-akhiꞌ, mahapor an innilaon ju hitay. Khapo chin enat Hesus ja mapfalin an mapakawan an amin chi pfahor ta-o. Hitay chi ipa-innila mi ay chaꞌju ad ugwani. ");
INSERT INTO ifu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Khapo ay tay enat Hesus ja ipfilang Apo Jos hi magpong an amin hana mamati ay hija, muti ma-id chi oha hi mipfilang hi magpong hi pannig Apo Jos khapo hi pangunuchana ay ni urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hotti tikhan ju gwot niꞌ ta achi ma-at ay chaꞌju chin impatulaꞌ Apo Jos chin profeta hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Chonglon ju, chaꞌju an khun tomangkhatangkha, ti gwa han atoꞌ ad ugwani an atattakhu ju an natnat-on, hot masda-aw aju, muti matoy aju chamchama. Ti achi ju pattiyon, anong un gway mangpa-innila ay chaꞌju!’” Angkhay hitay hi inalin Paul. ");
INSERT INTO ifu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Gwa an pfimmutay cha Paul ay Barnabas ay chuy sinagoga, ja inalin chin tatakhu hi, nu mapfarpfalin, ja etoloy cha koma hini itudtuchu cha ay ni umali an Hapfachu. ");
INSERT INTO ifu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pfimmutay cha an amin chin tatakhu ja cho-or chi nitnud ay cha Paul ay Barnabas an Hudju ja Hentil an khun miꞌ-unud ay ni urchin chi Hudju. Ja tinukhun cha Paul ay Barnabas chicha ta etortoloy cha an monhochor ay ni khohkhoh Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Unot nachakngan chin Hapfachu, ja na-amung an amin chin tatakhu ay chuy an pfuglay ta chonglon cha hini hapit Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Unagkhu tinnig chin Hudju hachi atakhutakhu an na-amung ja emmaꞌ-amoh cha. Ja unagkhu nunhapit hi Paul ja ente-a cha an mamahiw ay hija ja an mamaꞌ-i chin khuna hapiton. ");
INSERT INTO ifu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Muti agkhuy temma-ot cha Paul ay Barnabas ja inali cha hi, “Mahapor an chaꞌju an Hudju chi mahhun an pangtuchugwan mi ay tay hapit Apo Jos. Muti tayya an chin-ug ju, hotti un chaꞌju hon hinugi ju hini achor ju an achi mipfilang an miꞌtakhu ay Apo Jos hi ma-id chi pogpogna. Hotti nangamong aju ta hay hana Hentil chi i mi pangtuchugwan. ");
INSERT INTO ifu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ti amat heto chin inalin Apo Jos an, ‘Piniliꞌ chaꞌju an manilagwan hay hana Hentil ta tuchugwan ju an amin hay hana tatakhu heto lota ay tay hapit u, ta gway aton cha an miꞌtakhu ay ha-in hi ma-id chi pogpogna.’ ” ");
INSERT INTO ifu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ja unot chengngor hachi Hentil chin inalin Paul ja mun-an-anla cha ja khun cha haphapiton hini aphod ni hapit Apo Jos an chengngor cha. Ja an amin hana pinilin Apo Jos an miꞌtakhu hi ma-id chi pogpogna ja namati cha. ");
INSERT INTO ifu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ja nunchongor chin hapit Apo Jos an amin hachi apfuglapfuglay hichi. ");
INSERT INTO ifu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Muti chinagchag chin Hudju hay hachi a-ap-apon chuy an pfuglay ja hana ma-ar-ali an pfinapfai an khun meꞌdayaw hachi Hudju ta miꞌpahiw cha ay cha Paul ay Barnabas. Amat hichi ja empakak cha chicha ay chuy pfuglay cha ad Antokya. ");
INSERT INTO ifu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Cha Paul ay Barnabas ja pinuꞌpu-an cha chin chapor ay chuy chapan cha ta panginnilaan chin tatakhu ad Antokya an napfalin chin tukhun cha ay chicha hotti un cha ikhad. Amat hichi ja empacheh cha an umuy ad Ikonium. ");
INSERT INTO ifu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ja hay hachi nataynan an namati hichi ad Antokya ja nagwachaan cha hi an-anla ja ay ni apfalinan ni Espiritu Santo. ");
INSERT INTO ifu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Emmatam cha Paul hichi ad Ikonium ja immuy cha hichin sinagoga an khun a-amungan chi Hudju. Jacho-or chi namati an Hudju ja Hentil ti megngor chin panudtuchu cha. ");
INSERT INTO ifu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Muti gwacha khu hana agkhuy namati an Hudju, ja hinurpfuchan cha ta mapaꞌ-i chin nomnom hachi Hentil ta pfuhulon cha hachi namati. ");
INSERT INTO ifu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nihihidchi chamchama cha Paul ay Barnabas hi at hichi hi arkhaw ja agkhuy cha temma-ot an un chaot entoloy an nuntudtuchu ay ni omaꞌ-atan ni khohkhoh Apo Jos. Ja tinihtikhuwan Apo Jos an umannung chin intuchu cha hi nangchatana ay chicha hi apfalinan an mangat hi milagro. ");
INSERT INTO ifu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ja nunchinuꞌ-ukhan chi nomnom chin tatakhu ay chuy an pfuglay, hotti na-aggwa cha, an gway neꞌ-ampoy chin Hudju ja gway uchumna an neꞌ-ampoy chin apostol. ");
INSERT INTO ifu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Amat hichi ja hay enat hachi Hudju ja chin a-ap-apo cha ja hachi uchumna an Hentil, ja nunhahappitanan cha an palikhaton ja pumpfu-or cha hachi apostol. ");
INSERT INTO ifu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Unot inannilan cha Paul ay Barnabas chin khun cha hahapiton ja lemmajaw cha ta immuy cha hichi ad Listra ja ad Derbe an provincian chi Likonia, ja chin nunlawlaw an pfuglay. ");
INSERT INTO ifu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ja engkasaba cha hini Ebanghelyo an amin hachi apfuglapfuglay an immajan cha. ");
INSERT INTO ifu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ja gwacha han lala-e hichi ad Listra an napilay, an agkhuy chimmarchalan nete-a chin nituꞌkhungana. ");
INSERT INTO ifu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ja ne-egngor tay an napilay chin khun ituchun Paul. Emmohchong Paul ja na-ormana an gway pammatin chuy napilay an mepatenong. ");
INSERT INTO ifu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ja iniꞌgwap Paul an nangali hi, “Tumaꞌchug a.” Ja natantannaꞌchug hichuy napilay ja khun munchallachallan. ");
INSERT INTO ifu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Unagkhu tinnig hachi tatakhu hitay enat Paul ja hi-u-ugwap cha hi hapit cha ad Likonia ja khun cha allon chi, “Tayya an immali hay hato ab-apfunijan an numpatikhaw an amat hi takhu.” ");
INSERT INTO ifu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ja nginadnan cha hi Barnabas hi Zeus an ngachan chi oha an jos cha. Ja nginadnan cha khu hi Paul hi Hermes ti hijay khun munhapit. ");
INSERT INTO ifu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Gwacha han pfalay hichi pingngit ad Listra an khun cha pundayawan ay Zeus, ja gwa han mumpfuni an khun mundaton. Ja enalan chuy mumpfuni hachi pfuta-ar an pfakah ja hachi palagwer ja in-uy na ta mundaton cha ay cha Paul ay Barnabas. ");
INSERT INTO ifu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Unagkhu inannilan cha Barnabas ay Paul hitay i cha aton ja nunhagwek cha chin lopfong cha ta ipatikhaw cha an napukhit chi punnomnoman cha. Ja entagtag cha an i nun-utor hachi na-amung an tatakhu. Ja khun cha iꞌgwap an mangali hi, ");
INSERT INTO ifu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Chaꞌju an tatakhu, anagkha ta idatunan chaꞌmi? An un ami khu takhu an amat ay chaꞌju. Immali ami heto an muntudtuchu ay chaꞌju ay tay maphod an tukhun Apo Jos, ta chuꞌkhon ju hana khun ju pundatunan, ti ma-id ichat na hi aphochan, ta un aju gwot miꞌ-unud ay Apo Jos an mamattakhu an nangapja ay tay lota, ja hichi ad uchu, ja hichi baybay ja an amin chi hay nagwacha. ");
INSERT INTO ifu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chin hopapna ja inikud Apo Jos an dayawon hachi Hentil hini penhod cha an dayawon. ");
INSERT INTO ifu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Muti anong un amat heto ja gwa hana khuna aton an panginnilaan an hijay umannung an Jos, ti khuna ichat hana aphochan chi tatakhu. Hijay mangchat hi uchan ja papfungaona an amin chi mitanum ta omanay hi anun ta miꞌtakhu ta-o an gwachaan hi an-anla.” ");
INSERT INTO ifu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ja anong un inalin chin apostol hitay ja nalikhatan cha chamchama an nangpagwa hachi tatakhu an mundaton ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nalahin chi at hichi hi arkhaw ja immali hana Hudju an agkhuy namati an narpu ad Antokya ja ad Ikonium ta unuchon cha hi Paul. Ja chinagchag cha chin tatakhu hichi ad Listra ta numpfu-or cha hi Paul. Ja khinujukhujud cha an in-uy hichin pingngit chuy pfuglay, ti hay anila cha ja natoy. ");
INSERT INTO ifu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Muti inunud hay hachi namati ja lini-ub cha hi Paul ja pfimmangon hija. Ja timmaꞌchug ja chimmalan an numpfangngad ay chuy pfuglay. Nun-inggwiꞌgwiit ja empacheh cha Paul ay Barnabas an immuy hichi ad Derbe. ");
INSERT INTO ifu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Emmatam cha hichi ad Derbe ja ente-a cha khu an mangkaskasaba ay ni Ebanghelyo ja cho-or chin inawis cha an namati ay Hesu Kristo. Napfalin ad Derbe ja numpfangngad cha khu hichi ad Listra, ja ad Ikonium, ja unot ad Antokya an provincian chi Pisidia. ");
INSERT INTO ifu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","An amin hay hato pfuglay an immajan cha ja khun cha muntudtuchu ta papfi-ahon cha hachi namati. Ja tinukhun cha chicha ta munchochodcha cha ay ni pammati cha. Ja intuchu cha khu an cho-or hana likhat hi hopkhon chi namati ja un omatam ay ni Pun-ap-apugwan Apo Jos ad langit. ");
INSERT INTO ifu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","An amin hana iglesia an immajan cha ja enhaad cha hana mangpangpangulu hi namati. Ja khun cha mun-ayunar ja mungkalalag, ta ehchor cha hay hato pinili cha ay Apo Hesu Kristo an pinati cha. ");
INSERT INTO ifu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Amat hichi ja empacheh khu cha Paul ay Barnabas ja ene-enggwa cha hichi provincian chi Pisidia ja un chaot omatam ay ni provincian chi Pamfilia. ");
INSERT INTO ifu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ja nuntudtuchu cha ay ni hapit Apo Jos ad Perga an provincian chi Pamfilia ja un chaot ichayyu an umuy hichi ad Atalia. ");
INSERT INTO ifu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Omaꞌ-angonoh ja nunlukhan cha han papor hichi pingngit chi baybay ad Atalia an mumpfangngad ad Antokya an narpugwan cha, ti pfinalin cha mahpay hana impatamun Apo Jos ay chicha. Hichi ad Antokya chi nangkalalakhan chin namati ay chicha an enehchor cha ay Apo Jos ta hijay mangkhohkhohan ay chicha ay ni pangatan cha ay ni impatamu na ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Unot emmatam cha Paul ad Antokya ja inamung cha chin namati ta impa-innila cha an amin chin impatamun Apo Jos ay chicha, ja hini tolong na hi nangaskasabaan cha hachi Hentil ta gway aton cha khu an mamati. ");
INSERT INTO ifu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ja nihihidchi cha Paul ay Barnabas ay cha chuy papadchung cha an namati ad Antokya hi at hichi hi arkhaw. ");
INSERT INTO ifu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Gwacha hachi namati an narpu ad Judea an immuy ad Antokya, ja khun cha muntudtuchu hi umapfu an khun cha allon hachi namati hi, “Nu achi aju mumpakugit, achi aju miꞌtakhu ay Apo Jos, ti hitay chin urchin Moses.” ");
INSERT INTO ifu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Muti achi apfuluton cha Paul ay Barnabas ja neꞌhohongnger cha ay chicha. Khapo ta ma-id epfanakhana ja nunhahapit hay hachi namati ja pinili cha hi Paul ja hi Barnabas ja hana uchumna an namati, ta chichay hennag cha an umuy hichi ad Jerusalem an i miꞌhapit chin apostol ja hachi papangulun chi namati hichi ta epfanag cha. ");
INSERT INTO ifu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Empacheh cha an umuy ad Jerusalem ja enenggwa cha ad Fenisia ja ad Samaria. Ja khun cha ipa-innila hachi namati an gwacha mahpay hana Hentil an niꞌ-unud ay Hesus. Mun-an-anla hay hachi namati hi nangngolan cha ay tay inalin cha Paul. ");
INSERT INTO ifu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ne-atam cha ad Jerusalem ja mun-an-anla chin apostol ja hana pangulun chi namati ja an amin hana namati, ja inali cha hi, “Maphod ta immali aju.” Amat hichi ja impa-innilan cha Paul chin en-enat Apo Jos ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Muti timmaꞌchug hay hachi uchumna an Farisee an namati ja inali cha hi, “Mahapor an mumpakugit hana Hentil, ja mahapor an allon ta-o ta unuchon cha hini urchin Moses.” ");
INSERT INTO ifu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Amat hichi ja na-amung chin apostol ja hachi pangulun chi namati ta nunhahappitanan cha hitay an inali cha. ");
INSERT INTO ifu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Uja-ud hi nunhahappitanan cha ja timmaꞌchug hi Peter ja inali na hi, “A-akhi, anila ju an chin pengpenghana, ja ha-in chi pinilin Apo Jos ay chita-o an i mangtuchu ay ni Ebanghelyo, ta gway aton hana Hentil an mangngor ja mamati. ");
INSERT INTO ifu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Hi Apo Jos an nanginnila an amin hi nomnom chi takhu chi nangpatikhaw ay chita-o an Hudju an apfulutona khu hana Hentil, ti inchat na khu ay chicha hini Espiritu Santo an amat khu ay ni nangchatana ay chita-o. ");
INSERT INTO ifu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Numpapadchung chi enat Apo Jos ay chita-o an Hudju ja ay chicha an Hentil, ti penakawana an amin hana pfahor cha khapo hi namatiyan cha. ");
INSERT INTO ifu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hotti un ta-o chah achi ipahikha hi Apo Jos nu palikhaton ta-o hana Hentil an namati? Anong otniꞌ unchin a-ammod ja chita-o ja ad-adchi ta-o paꞌ-at ay ni urchin Moses. ");
INSERT INTO ifu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Muti namati ta-o an un ta-o miꞌtakhu ay Apo Jos khapo hi khohkhoh na an in-alin Apo Hesus, amat khu hina hay hana Hentil.” ");
INSERT INTO ifu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nepallog cha Barnabas ay Paul an nunhapit, ja khemmegkhenong an amin hachi tatakhu an na-amung ta chonglon cha khu chin piꞌ-ali cha. Ja impa-innila cha hana enat Apo Jos chin Hentil hi nangchatana hi apfalinan cha Paul an nangat chin cho-or an numpfino-ob-on an milagro an panginnilaan an inapfulut na chin nuntudtuchugwan cha hana Hentil. ");
INSERT INTO ifu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Un chaot napfalin an nunhapit ja nepallog khu hi James ja inali na hi, “A-akhi, chonglon ju hitay piꞌ-aliꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Chengngor ju chin inalin Simon Peter ad anachi an enat Apo Jos hi nangpatikhagwana ay ni pamhod na hana uchumna an Hentil ta midchum cha hay hana tatakhu na. ");
INSERT INTO ifu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hitay ayya an enat Apo Jos ay cha tay Hentil ja hijah tay chin inalin Apo Jos an impatulaꞌ na hachi profeta chin nahop hi nangarjana hi, ");
INSERT INTO ifu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Chin nun-ap-apugwan hachi holag Ari David ja mipadchung hi pfalay an napaꞌ-i ja agkhuy natoloy. Muti ha-in an hi Apo Jos ja mumpfangngachaꞌ ta pfangunoꞌ hini pun-ap-apugwan cha. ");
INSERT INTO ifu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ja an amin chi tatakhu ja tomangad cha ay ha-in, ja midchum an amin hana Hentil an piniliꞌ hi tatakhuꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Hitay chi impa-innilan Apo Jos chin pengpenghana.’” ");
INSERT INTO ifu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Entoloy James an nunhapit ja inali na khu hi, “Hay gwa ay ha-in ja achi ta-o agkhu palikhaton hana Hentil an namati ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Hay aton ta-o ja muntulaꞌ ta-o ay chicha, ta allon ta-o hi achi cha mi-ihcha hi nabnijan ja achi cha me-eloꞌ hi pfu-un ahagwa cha, ja achi cha khu mi-ihcha hana agkhuy naglot ja hana chala. ");
INSERT INTO ifu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ti hay hato khun ta-o unuchon an Hudju ja gwa ay ni Urchin Moses an napfajag an khun mitudtuchu hi ahapfahapfachu hichi sinagogan chi Hudju hi apfuglapfuglay.” ");
INSERT INTO ifu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hachi apostol ja hachi pangulun chi namati ja an amin hachi namati, ja inapfulut cha chin inalin James. Ja pinili cha hay mitnud ay cha Paul ay Barnabas an mumpfangngad ad Antokya. Hay napili ja han chugwa an linala-e an cha Judas an mungngadngachan hi Barsabas ja hi Silas. ");
INSERT INTO ifu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ja empachon cha han tulaꞌ an hay nitulaꞌ ja allona hi, “Chaꞌmi an apostol an a-akhi ju hi pammati ja hato khun mangpangpangulu chi namati heto ad Jerusalem, ja tayya an muntulaꞌ ami ay chaꞌju an a-akhi mi an Hentil hina ad Antokya ja ad Syria ja ad Silisya. ");
INSERT INTO ifu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ti chengngor mi an gwacha hana narpu heto an immali hina achaan ju an nab-on chi i cha intudtuchu, ja na-apfu aju an ma-id maptoꞌ hi i ju unuchon. Ipa-innila mi an pfu-un chaꞌmi chi nannag hay hachi immali hina an nuntudtuchu hi nehahalla. ");
INSERT INTO ifu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hijaot un mi nunhahappitanan an honakhon mi hato chugwa an linala-e an mitnud ay cha tay podpodhon ta-o an a-akhi an cha Barnabas ay Paul. ");
INSERT INTO ifu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ti anila ta-o an cha Paul ay Barnabas ja impusta cha hini piꞌtakhuwan cha an mangat an amin hi tamun Apo ta-o an hi Hesu Kristo. ");
INSERT INTO ifu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hotti tan honakhon mi cha Judas ay Silas an mangali ay ni intulaꞌ mi ay chaꞌju ");
INSERT INTO ifu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","an empanomnom ni Espiritu Santo ay chaꞌmi. Ti achi mahapor an i mi ipapilit ay chaꞌju an umunud hana khun mi aton an Hudju. Angkhay hay hato chi mahapor hi unuchon ju. ");
INSERT INTO ifu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Achi aju mi-ihcha hi nabnijan ja hi chala. Ja achi aju khu umihcha hi agkhuy naglot ja achi aju me-eloꞌ hi pfu-un ahagwa ju. Aphochan ju hay hato nu unuchon ju. Angkhay hay hato chi penhod mi an allon ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Napfalin an intulaꞌ cha ja hennag cha chin linala-e an mang-uy chin tulaꞌ ad Antokya. Ne-atam cha ja inamung cha an amin hachi namati ja inchat cha chin tulaꞌ. ");
INSERT INTO ifu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pfinahan chin tatakhu ja mun-an-anla cha ay chuy maphod an tukhun. ");
INSERT INTO ifu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Cha Judas ay Silas ja profetan Apo Jos, hotti cho-or chin intugtukhun cha hachi namati, ja impapfi-ah cha hini pammati cha. ");
INSERT INTO ifu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nihichi cha Judas ay Silas hi at hichi hi arkhaw, ja chin pumpfangngachan cha ad Jerusalem ja inalin hay hachi namati ad Antokya hi, “Hi Apo Jos chi manalimun ay chaꞌju ingkhanah omataman ju ad Jerusalem.” Ja numpfangngad cha ay cha chuy nannag ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Muti penhod Silas an muntaynan ad Antokya. ");
INSERT INTO ifu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nuntaynan khu cha Paul ay Barnabas hichi ad Antokya ja niꞌlammong cha chin cho-or an namati an muntudtuchu ja mangkaskasaba ay ni hapit ApoJos. ");
INSERT INTO ifu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Unot immuy chi at hichi hi arkhaw ja inalin Paul ay Barnabas hi, “I ta mah pfangngachon an tikhan an amin hana intuchugwan ta an namati ay Apo Jos, ta i ta emamad hini omaꞌ-atan ni pammati cha.” ");
INSERT INTO ifu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Inapfulut Barnabas ja penhod na an piꞌjajon cha hi John Mark. ");
INSERT INTO ifu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Muti hi Paul ja achi na penhod an pitnuchon hi John Mark, ti tenaynana chicha ad Pamfilia ja agkhuy na entoloy an tomolong ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ja nunhongnger cha Paul ay Barnabas ja nunhijan cha. Initnud Barnabas hi John Mark, ja nunlukhan cha han papor an umuy ad Cyprus. ");
INSERT INTO ifu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pinilin khu Paul hi Silas hi pun-ibpfa na. Ja engkalalakhan chin namati ad Antokya, ta hi Apo Jos chi manalimun ay chicha ay ni agwun cha, ja un chaot epacheh. ");
INSERT INTO ifu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ja enenggwa cha hichi ad Syria ja ad Silisya ja nuntugtukhun cha hachi namati ay Hesus ta meꞌ-er-ellog cha hi pammati. ");
INSERT INTO ifu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Immuy cha Paul ay Silas hichi ad Derbe ja ad Listra an agwachaan han namati an hi Timoti chi ngachana. Hi ina na ja Hudju an namati ja Griego hi ama na. ");
INSERT INTO ifu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ja khun haphapiton hachi namati ad Listra ja ad Ikonium hini kina-aphod Timoti. ");
INSERT INTO ifu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Penhod Paul an mangitnud ay Timoti hotti kinugit na khapo hay hana Hudju hichi, ti anila cha an amin an Griego hi ama na hotti agkhuy nakugit. ");
INSERT INTO ifu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Amat hichi ja initnud Paul hi Timoti ja immuy cha hachi apfuglapfuglay an i mangpa-innila chin nunhahappitanan cha hay hachi apostol ja hachi pangulun chi namati ad Jerusalem an mahapor an unuchon chin intulaꞌ cha an urchin. ");
INSERT INTO ifu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hotti khun meꞌ-er-ellog chin pammatin hachi namati, ja enarkhaw an khun cha chomchom-or. ");
INSERT INTO ifu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ja podhon cha Paul an umuy hichi provincian chi Asia an i muntudtuchu muti agkhuy cha entoloy ti empagwan ni Espiritu Santo. Hotti eneꞌgwa cha hichi provincian chi Frigia ja ad Galatia. ");
INSERT INTO ifu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ja ne-atam cha hichi pingngit chi provincian chi Misia ja penhod cha an umuy hichi provincian chi Bitinia muti empagwan khu ni Espiritun Apo Hesus. ");
INSERT INTO ifu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hotti un cha inchayyu an umuy hichi ad Troas an ohan pfuglay chi Misia. ");
INSERT INTO ifu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ay chuy an lapfi ja nipatikhaw ay Paul han lala-e an eMasedonia an timmataꞌchug an khun mumpakpaka-ahi an mangali hi “Umali aju adniꞌ heto ad Macedonia ta tulungan chaꞌmi.” ");
INSERT INTO ifu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Amat hichi ja nunhakhana cha ja neꞌhakhanaaꞌ khu ta umuy ami ad Macedonia, ti na-awatan mi an enajakhan chaꞌmi ay Apo Jos an i mangkaskasaba ay tay Ebanghelyo hay hana tatakhu hichi. ");
INSERT INTO ifu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hotti nakak ami ad Troas ja nunlukhan ami han papor an munchapchapoh an umuy ad Samotrace. Nunnanong ami hichi ja nun-inggwiꞌgwiit ja immuy ami khu ad Neapolis ay nuy provincian chi Macedonia. ");
INSERT INTO ifu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Emmatam ami ad Neapolis ja enehlong mi hichi ad Filipos an otongngan an pfuglay an nidchum ay ni pun-ap-apugwan chi Rome. Manghan hi ohay chumingkhu hi nunnangngan mi hichi. ");
INSERT INTO ifu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Gwa an nachakngan chin Hapfachu an ngilin chi Hudju ja nakak ami ay chuy pfuglay ja immuy ami hichi gwanggwang an i manikhaw hay pungkalalakhan chi Hudju. Ja enataman mi hachi pfinapfai an na-a-amung, ja ni-ipfun ami ta muntudtuchu ami. ");
INSERT INTO ifu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Oha ay cha tay an pfinapfai ja hi Lidia an eTiatira an khun mungngina hi nangina an pfinacha. Oha hija an khun meꞌdaydayaw ay Apo Jos. Ja inchatan Apo Jos hija hi pannaka-awat ja namati mahpay chin inalin Paul. ");
INSERT INTO ifu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Numpabautisar hi Lydia ja chin numpun-ibpfa na an neꞌheto hichi pfalay cha. Napfalin ja inali na hi, “Miꞌjali aju mah ta munnanong aju hi pfalay mi, nu ipfilangaꞌ ay chaꞌju hi oha an namati ay Apo ta-o an hi Hesus.” Achi na pijon an mangali hotti niꞌjuy ami. ");
INSERT INTO ifu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gwa han namenghan an umuy ami hichi khun pungkalalakhan, ja chinittum mi han pfupfai an himpfut an nahuhuꞌlungan hi napukhit an espiritu an gway apfalinana an mangali hay hana ma-at ay ni ohan takhu hi uchum chi arkhaw. Hotti cho-or chi lagpfun tay an mun-anap an khun alaon hachi apo na. ");
INSERT INTO ifu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Khun mangumangunud hitay pfupfai ay chaꞌmi ay Paul ja khuna iꞌgwa-iꞌgwap hi, “Cha tay an linala-e ja pfaar tay napfagto an Jos. Ja immali cha an mangtuchu ay ni aton an miꞌtakhu ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ja a-arkha-arkhaw an amat hetoy khun aton tay an pfupfai, ja loꞌtat ja impahikha na hi Paul. Ja nunligkhoh ja inali na chin nehohoꞌlong an ispiritu hi, “Ay ni apfalinan Hesu Kristo ja epakak u he-a.” Ja ay chuy an nangarjana ja nakak gwot chin nehohoꞌlong ay chuy pfupfai. ");
INSERT INTO ifu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Unagkhu inannilan hachi apon chuy pfupfai an ma-id mahpay pumpihuwan cha ja chimpap cha hi Paul ja hi Silas. Ja nungkhujud cha an in-uy hichi palaha ta ijuy cha hay hana ap-apo ay chuy pfuglay. ");
INSERT INTO ifu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ja inali cha hay hachi a-ap-apo cha an Romano hi, “In-ali mi ay chaꞌju hay hato Hudju an pumapaꞌ-i ay tay an pfuglay ta-o. ");
INSERT INTO ifu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ti khun cha itudtuchu hana ugali cha an mekontra ay ni urchin ta-o ja achi mapfalin an unuchon ta-o an Romano.” ");
INSERT INTO ifu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pinahiw hachi tatakhu cha Paul ja nun-epa-aan chin a-ap-apo chin lopfong cha ja impahuplit cha chicha. ");
INSERT INTO ifu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Napfalin ja impipfalud cha, ja inali cha ay chuy khun munggwarja chin pfaluchan ta hahalichitona an pfantajan chicha. ");
INSERT INTO ifu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Inunud chuy gwarja chin inalin chin ap-apo na hotti in-uy na cha Paul hichi pumpfaluchan ja impahikhop na chicha hichi chohachohar na. Enala na han ajiw an khun cha pangorpit hi hu-in chi mipfalud, ja inorpit na chin hu-i cha ja tenorpfoꞌ na. ");
INSERT INTO ifu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gwa an temmonga ja khun mungkalalag ja mungkankanta cha Paul ay Silas an mundaydayaw ay Apo Jos. Ja khun chodchonglon chin uchumna an nipfalud. ");
INSERT INTO ifu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ja unagkhu himpfumagkha ja gwa han mapfi-ah an khihu. Ja nun-a-egwor an amin chin pfaluchan. Ja un aꞌ-alina ja nun-ipfughor an amin chin pantaw ja nun-a-aan khu an amin chin pfangkeleng hachi nun-ipfalud. ");
INSERT INTO ifu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ja pfimmangon chin khun munggwarja ja tinnig na chin pantaw an nun-ipfughor. Ja khemhona un lemmajaw an amin hachi nun-ipfalud, hotti hinuꞌnut na chin pfangid na ta patajona hini achor na. ");
INSERT INTO ifu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Unot tinnig Paul chin atona ja nun-ugwap an allona hi, “Achim patajon hini achor mu ti tayya ami heto an amin.” ");
INSERT INTO ifu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Numpfokha chin gwarja hay hilaw ja entagtag na an umuy ay chuy achaan cha Paul. Ja khun munggwoggwog hi ta-ot na ja nunheppe ay chicha. ");
INSERT INTO ifu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ja initnud na chicha an pfumutay ja inali na hi, “A-akhiꞌ, ituchu ju adniꞌ hay atoꞌ ta miꞌtakhuwaꞌ ay Apo Jos.” ");
INSERT INTO ifu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tempfar cha Paul ja inali cha hi, “Mamati a ay Apo ta-o an hi Hesus hot takhuwon chaꞌju, he-a ja an amin aju an hen-a-amma.” ");
INSERT INTO ifu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ja intugtukhun cha Paul hini hapit Apo Jos ay hija ja an amin cha an hen-a-amma. ");
INSERT INTO ifu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ja ay chuy an lapfi ja in-uy chin gwarja chicha han gwachaan chi chanum ta inulahana chin hukhat cha, ja un cha mumpabautisar an amin an hen-a-amma. ");
INSERT INTO ifu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Napfalin ja eneghop na cha Paul ay Silas ay ni pfalay cha ta panganuna. Ja nunheglay an-anla cha an hen-a-amma khapo hi namatiyan cha ay Apo Jos. ");
INSERT INTO ifu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ja gwa an nanong ja hennag hachi a-ap-apo an Romano hachi polih an i mangali chin gwarja ta epakak na cha Paul ay Silas. ");
INSERT INTO ifu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hotti inalin chin gwarja ay Paul hi, “Tayya an inalin hana apo mi an makak aju heto pfaluchan. Hotti amat hina ja makak aju ta ma-id chi hay mannig ay chaꞌju.” ");
INSERT INTO ifu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Muti inalin Paul hachi polih hi, “Unchah amat hina chi aton mi an makak? Impapfalud chaꞌmi an agkhuy chaꞌmi hinumarja. Allon ju hay hachi a-ap-apo hi ma-id tinnig ju hi pfahor mi ja impahuplit chaꞌmi hi achoꞌlan chi tatakhu, ja numpapadchung ta-o an Romano. Ja un ju chah allon hi makak ami an ma-id oha hi manginnila? Achi mapfalin! Allon ju ta umali hachi a-ap-apo ta chichay mangitnud ay chaꞌmi an makak.” ");
INSERT INTO ifu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Amat hichi ja numpfangngad chin polih hay hachi a-ap-apo cha an i mangpa-innila chin inalin Paul. Unot chengngor chin a-ap-apo an un Romano cha Paul ja temma-ot cha. ");
INSERT INTO ifu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hotti immuy cha hichi pfaluchan an i numpakawan ay cha Paul. Ja impapfutay cha hi Paul ja hi Silas an inali cha hi, “Makak aju ta umuy aju hi uchumna hi pfuglay.” ");
INSERT INTO ifu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ja nakak cha Paul ay chuy pfaluchan ja immuy cha hichi pfalay cha Lidia. Ja tinukhun cha hachi namati ja un cha epacheh. ");
INSERT INTO ifu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Empacheh cha Paul ay Silas ja eneꞌgwa cha hichi ad Amfipolis ja ad Apolonia ja un chaot me-atam ad Tesalonika an achaan han sinagoga an khun a-amungan chi Hudju. ");
INSERT INTO ifu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ja niꞌjuy hi Paul hichi sinagoga ti hijah tay chi khuna aton an amin hi apfuglapfuglay hi omajana. Ja intuchu na hana ni