﻿USE sofia;
DROP TABLE IF EXISTS sofia.ifk_vpl;
CREATE TABLE ifk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ifk_vpl WRITE;
INSERT INTO ifk_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Handih lappuna ya lintun Apu Dios di kabunyan ya luta. ");
INSERT INTO ifk_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mu maid ni-an di napkol an umat tuh luta ya maid di niha-ad hidi te adallom an danum ya abuy wadah di ya tapottapol. Ya wada nan Espiritun Apu Dios an umat hi dibdib nah tap-on di danum. ");
INSERT INTO ifk_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ya kimmalih Apu Dios an kananay “Mawaday pat-al.” Ya pimmat-al. ");
INSERT INTO ifk_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ya maphod hidiyen lintuna. Inappil nay pat-al ya tapol ");
INSERT INTO ifk_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ot nan pat-al ya nginadananah mapat-al ya nan tapol ya nginadananah hilong. Ot mala-uh diyen hilong ot mabigat ya hidiyey namangulun algo. ");
INSERT INTO ifk_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Kanan bon Apu Dios di “Mawaday mangodwa nah danum ta wadah nuntap-o ya wadah nundaul.” Ya athidiy naat. Hanan wadad tap-o ya hidiye nadan kulabut an kalpuwan di udan ya nan wadad da-ul ya nan danum tuwali tuh luta. ");
INSERT INTO ifk_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Hanan nuntap-o ya nginadanan Apu Dios hi kabunyan. Nahilong bon diye ot mabigat ot hidiyey mikadwan algo. ");
INSERT INTO ifk_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ya kanan Apu Dios di “Amungok nan danum ta maappil ta matiboy luta.” Ya athidiy naat. ");
INSERT INTO ifk_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ot nan mamaga ya nginadananah luta ya nan naamung an danum ya nginadananah baybay. Ya hidiyen lintun Apu Dios ya maphod. ");
INSERT INTO ifk_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Kimmali boh Apu Dios an kananay “Tummol tuh lutan am-in di nunhihinnatkon an mitanom ya kakaiw an bumungan waday buwana ta nanongnan waday athidin mitanom.” Ya nawadan am-in. Ya maphod dadiyen lintun Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ot mahilong bo ot mabigat ya hidiyey mikatlun algo. ");
INSERT INTO ifk_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kanan bon Apu Dios di “Mawada day pumat-al hi kabunyan ta maappil di algo nah hilong ta pangiang-angan hi tiempo, algo, toon ya nadan tiempon di toon. ");
INSERT INTO ifk_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ta dadiyen pumat-al hi kabunyan ya pat-alan day luta.” Ya naat datuwe. ");
INSERT INTO ifk_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lintunay duwan o-ongal an pumat-al. Hanan algo an mamat-al tuh luta nah mapat-al ya nan bulan an mamat-al tuh luta nah hilong. Ya athidi bon winadana nadan dakol an bittuwon. ");
INSERT INTO ifk_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Inha-ad na datuwen pumat-al ad kabunyan ta mamat-al hi luta ");
INSERT INTO ifk_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","nah hilong ya nah mapat-al ta maappil di mapat-al ya hilong. Ya hidiyen lintun Apu Dios ya maphod. ");
INSERT INTO ifk_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nahilong bo ot mabigat ya hidiyey mikap-at an algo. ");
INSERT INTO ifk_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kanan bon Apu Dios di “Mawadan am-in di nunhihinnatkon an matagun mihaad hi danum ya mapnuy kabunyan hi nunhihinnatkon an muntayyapan.” ");
INSERT INTO ifk_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ot mawadan am-in di nunhihinnatkon an matagun wadah baybay an o-ongngal day udum. Ya athidi bon lintunay nunhihinnatkon an hamuti. Ya maphod dadiyen lintun Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Binendisyonana nadan wadah danum ta dumakol dat mapnuy baybay ya athidi bon binendisyonana nadan hamuti ta dumakkodakkol da. ");
INSERT INTO ifk_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nahilong bon diye ot mabigat ya hidiyey mikaliman algo. ");
INSERT INTO ifk_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Kanan bon Apu Dios di “Mawada tuh lutan am-in di nunhihinnatkon an aggayam, mailom ya adi. Ya mawada day mundallanan, nadan mungkaddapan ya nadan mumbulluhan.” Ya nawada da. Ya maphod dadiyen lintun Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ya kanan bon Apu Dios di “Ad uwani ya lutuwon taku moy tagu an umat ke ditaku ta pun-ap-apun am-in nadan mumbibiyag tuh luta, kabunyan ya baybay.” ");
INSERT INTO ifk_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Athidiy inat Apu Dios an lintu nay tatagu an miingngoy pangi-eda hi pangi-ena. Ya nan lintuna ya lalaki ya babai. ");
INSERT INTO ifk_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ot bendisyonan Apu Dios dida an kananay “Mahlag kayu ta dumakol kayu ta maboblayan am-in tun luta ya dakayuy nangamung tuh luta. Dakayu boy nangamung nadah dolog hi baybay, nadah hamuti ya am-in di aggayam.” ");
INSERT INTO ifk_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kanana boy “Indadaan kuy nunhihinnatkon an nitanom ya kaiw an bumunga ta waday kanon yu. ");
INSERT INTO ifk_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ya winadak di holok ya nadan udum an nitanom ta kanon nadan waday biyag na umat hi aggayam ya hamuti.” Ya am-in datuwe ya inat na ta kiphodan da. ");
INSERT INTO ifk_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ya maphod am-in dadiyen lintun Apu Dios. Nahilong kediye ot mabigat ya hidiyey mikan-om an algo. ");
INSERT INTO ifk_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Athituy nunlutuwan Apu Dios hi luta ya kabunyan ya am-in di wadah di. ");
INSERT INTO ifk_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ginibbunan am-in dadiyen ngununa ot nah mikapitun algo ya nun-iyatu. ");
INSERT INTO ifk_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binendisyonanah diyen mikapitun algo ya imbilang nah diyen algon ngilinon te kediyey nangibbuwanah ngununa ot mun-iyatu. ");
INSERT INTO ifk_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Athituy nunlutuwan APU DIOS hi kabunyan ya luta ya am-in nadan wadah di. Kediyen nunlutuwan APU DIOS hi luta ya kabunyan ya ");
INSERT INTO ifk_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","maid di nitanom ya maid di tinummol hi nganneh diye te maid di impaalinah udan ya maid di muntanom, ");
INSERT INTO ifk_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","mu indani ya wadaday mun-otbol ta madanuman di luta. ");
INSERT INTO ifk_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Indani ya immalah APU DIOS hi luta ot kapyaonay adol di tagu ot hap-udanay olong na ya yimmahya. ");
INSERT INTO ifk_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Wada nan Lagunta an Eden an tinanoman APU DIOS nah nangappit hi timilan di algo ot hidiy pangiha-adanan diyen tagun lintuna. ");
INSERT INTO ifk_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Impatmol nah diy nunhihinnatkon an mungkakaphod an kaiw an maphod di bunga da. Hanah gawwan diyen lagunta ya wada nan kaiw an umidat hi nitaguwan ya wada bo nan kaiw an umidat hi laing di tagu ta inilaon day maphod ya gaga-iho. ");
INSERT INTO ifk_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ya wada bo nan wangwang hidid Eden an mundanum nah nitanom nah lagunta. Mu nah e-elena ya naganodwan numbalin hi opat an wangwang. ");
INSERT INTO ifk_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Hay ngadan nan namangulu ya Pishon an indalana nah bobled Habilah. Hidiy kahamakan di namahman balituk ya nadan nabalol an batu ya nadan konakkonan an nabanglun lotan di kaiw. ");
INSERT INTO ifk_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya nan ngadan di mikadwan wangwang ya Gihon an indalana nah bobled Kush. ");
INSERT INTO ifk_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ya hana ken mikatlun wangwang ya Tigris an indalanad Assyria nah nangappit hi timilan di algo. Ya nan mikap-at an wangwang ya hidiye nan nangadanan hi Euphrates. ");
INSERT INTO ifk_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Hi APU DIOS ya inha-ad na nan lintunan tagu hidid Eden ta hiyay mumpaptok hidi. ");
INSERT INTO ifk_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kanan APU DIOS ke hiyay “Am-in di bungan tudan kaiw ya damanan kanom, mu ");
INSERT INTO ifk_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ammuna nan ohan kaiw an adim kanon di bungana. Hidiye nan mangidat hi laing an manginilah maphod ya gaga-iho. Te deket kanom hidiye ya mate ka.” ");
INSERT INTO ifk_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Indani ya kanan APU DIOS di “Adi maphod an maoh-ohhah tuwen lalaki. Mangapyaak hi daydayunan pungkadwana an bumaddang ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Hi APU DIOS ya lintuna tuwalin am-in nadan aggayam ya hahamuti an lutay nakapyaan da. Dadiyen lintuna ya ena impatibo nah lalaki ta ngadanana dida ot nan nungngadanah hin-oh-an dida ya hidiyey nunnanong an ngadan da. Mu maid ke dadiyey daydayunan pun-ibbanan bumaddang ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ot hay inat APU DIOS ya impahuyop na nan lalaki ot kaanonay ohan gunit nah taglang na ot ahina punduttumon nan laman. ");
INSERT INTO ifk_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kinapyanah diyen gunit hi babai ot iena nah kad-an nan lalaki. ");
INSERT INTO ifk_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kanan nan lalakiy “Maphod ta dehtu on pun-ibbak an kapaddung ku. Hiya ya nalpuh gunit ku ya laman ku. Babaiy ngadana te nalpuh lalaki.” ");
INSERT INTO ifk_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hituwey gapunan deket malahin di lalaki ya tayanana da inanan amana ta miaddum nah babai ta kay da oha. ");
INSERT INTO ifk_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Datuwen namangulun lalaki ya babai ya uggeda nabulwatiyan, mu adida bumain. ");
INSERT INTO ifk_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Am-in di aggayam an lintun APU DIOS ya nan ulog di kataltalaman. Kanan nan ulog nah babaiy “Kon makulug an kinalin Apu Dios ke dakayun adi kayu kuman hi bungan di kumpulmin kaiw ketuwen lagunta?” ");
INSERT INTO ifk_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ya kanan nan babaiy “Damanan kanon miy bungan di kumpulnan kaiw hitu, ");
INSERT INTO ifk_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mu kanan Apu Dios di ammuna nan bungan nan kaiw an nigawwa an adimi kanon ya adimi dapaon, te mate kami hin kanon mi.” ");
INSERT INTO ifk_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kanan nan ulog nah babaiy “Makangullug kayu! Adi kayu kaya mate. ");
INSERT INTO ifk_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Man-uket kananah di ya inilanan deket kanon yu ya kay madiyat di matayu an miingngo kayu mon hiya an inilaon yu hin nganney maphod weno gaga-iho.” ");
INSERT INTO ifk_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Indani ya hay nangang-ang nan babai ya makaphod ya mahong-oy bungan nan kaiw. Ya immalih nomnom nan maphod di lumaing ot e umala ot kuman. Indatana nan inayana ot kuman damdama. ");
INSERT INTO ifk_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kediyen kinan da nan bunga ya makulug an kay nadiyat di matada ot papohdanan dan maid di bulwati da. Ot kumugut da moh tubun di kaiw an fig ot panani dah adol da. ");
INSERT INTO ifk_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kediyen mungkahilong kediye ya dingngol dah APU DIOS an mundaldallanan nah lagunta ot eda mitalu nadah waday kakaiw. ");
INSERT INTO ifk_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mu kimmalih APU DIOS ke Adam an kananay “Daan kayu?” ");
INSERT INTO ifk_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Himmumang hi Adam an kananay “Dingngol kun mangali ka ya timmakutak ya adik pinhod an tibonak an maid di bulwatik kinali nuntaluwak.” ");
INSERT INTO ifk_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kanan APU DIOS di “Dahdiy nangalin he-an numbollad ka? Kon kinan yu nan bungan kinalik an adiyu kanon?” ");
INSERT INTO ifk_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kanan nan lalakiy “Tun indat mun pun-ib-ibbak an babaiy nangidat ke ha-on ot kanok.” ");
INSERT INTO ifk_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ot kanan APU DIOS nah babaiy “Antipet em inat di athidi?” Kanan nan babaiy “Hinaulak nah ulog.” ");
INSERT INTO ifk_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ot kanan APU DIOS nah ulog di “Makastigu ka gapuh nangatam kediye. Ta am-in hanadah aggayam an lintuk ya he-ay namahig di punholtapanah dug-ak. Kinali mipalpud uwani ya mumbulluwan ka ya hay dap-ul di kanom. ");
INSERT INTO ifk_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","He-a ya nadan holag mu ya nan babai ya nadan holag na ya mumbuhhulan kayu ta inggana. Ya he-a ya kalatom di hukin nan holag nan babai mu ahina tugmilan di ulum.” ");
INSERT INTO ifk_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kanan APU DIOS damdama nah babaiy “He-a ke ya udmak di ligat mu nah puntungowam an namahig di hakit na on ahika nuntungo. Yaden pinhodom metlaing nan inayam ya hiyay un-unudom an pun-ap-apum.” ");
INSERT INTO ifk_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ya kinalin APU DIOS damdama ke Adam di “Gapu te inidngol mu nah inayam ot kanom nan bungan iadik ya dug-ahak tun luta ta maliligatan kat ingganah ngunum on ahi waday kanon yu. ");
INSERT INTO ifk_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tummol day holok ya pagit, ta hidiye nan ahiyu pungkan di kumpulmin nitanom. ");
INSERT INTO ifk_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kah-in di munligat ka ya ilingotam di ngunum ta ahi waday aniyom. Athidit nangamung di biyag mu inggana kibangngadam hi lutan nalpuwam te lutay nakapyaam, kinali luta boy pumbalinam.” ");
INSERT INTO ifk_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hay nungngadan Adam nah inayana ya Eva te hiyay ahi pun-inan am-in di tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Indani ya binulwatiyan APU DIOS didah bulwati an nakapyah bolat di aggayam. ");
INSERT INTO ifk_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ot kanan APU DIOS di “Ad uwani ya niingngo moy tagun ditaku an inilada hin nganney maphod weno gaga-iho. Ta hidiye nan mahapul an adida kuman nah bungan di kaiw an umidat hi biyag te indani ya munnananong di biyag da.” ");
INSERT INTO ifk_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ot dog-alon mon APU DIOS dida nah Lagunta an Eden ta eda ngunuwon nan lutan nangal-ana hi kinapya na nah lalaki. ");
INSERT INTO ifk_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ya nah nangappit hi timilan di algo nah Lagunta an Eden ya inha-ad Apu Dios nan anghel an pungguwalyana an mundadalang di otak na an kumpulmiy pangihanggaana. Ta maid di e mih-up kediyen kaiw an umidat hi biyag. ");
INSERT INTO ifk_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Inhuyop Adam nan inayanan hi Eva ya nawadaan ot mun-imbabale ya lalaki. Ot kanan Evay “Gapuh baddang APU DIOS ya wadah tuwen imbabalek.” Ot ngadananah Kain. ");
INSERT INTO ifk_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Indani ya nitun-ud di oha bon lalaki ot ngadananah Abel. Naongngal ot hay ngununa ya mumpattol hi kalnero. Hi Kain ke damdama ya munliyak hi payo. ");
INSERT INTO ifk_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ohan algo ya immianamut hi Kain hi inani nan intanom na ot iappit nan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hi ke Abel ya inalana on namangulun impan di kalnerona ot iappit nan Apu Dios nadan dotag an makalamman. Immamlong hi APU DIOS nah inat Abel ot abulutonah diyen in-appit na. ");
INSERT INTO ifk_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mu uggena inabulut di in-appit Kain, ta hidiye nan bimmubbungot hi Kain an matiboh anganan mumboldang. ");
INSERT INTO ifk_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ot kanan APU DIOS ke Kain di “Tipet bumubbungot ka? Tipet athinay angam an mumboldang? ");
INSERT INTO ifk_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Gulat nat niptok di inat mu ya wada ot an matbal ka. Mu gapu te adi maphod nan inat mu ya halipat-an Satanas di punhaulanan he-a ta hiyay nangamung ke he-a, mu takon di athidi ya mahapul an iwalong muy punliwatan.” ");
INSERT INTO ifk_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ohan algo ya inayagan Kain hi tulang nan hi Abel an kananay “Makat ibbaanak ta eta mundaldallanan nah payo.” Indanit wadada nah payo ya pinaten Kain hi tulang na. ");
INSERT INTO ifk_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Indani ya kanan APU DIOS ke Kain di “Daan hi tulang mun hi Abel?” Kanan Kain di “Uggek inila. Kon ha-oy di mumpaptok ke tulang ku?” ");
INSERT INTO ifk_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kanan APU DIOS ke hiyay “Kain, tipet em in-athidi? Inilak nan inat mu te tinibok di dalan nan ibam nah luta, kinali mahapul an ibalok. ");
INSERT INTO ifk_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kinali nadug-ahan ka ta maid moy hilbin di ingunum kediyen luta an initmog nay dalan tulang mu hi namatayam ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Maid di idat di lutah aniyom takon di ipanaptok mu. Ya maid di em kiha-adan ta humanawwangan ka.” ");
INSERT INTO ifk_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kanan Kain ke APU DIOS di “Nahalman hituwen kastiguk, adiyak pakaippol. ");
INSERT INTO ifk_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Te dog-alonak tuh lutan punliyakak ya midawwiyak ke he-a. Abuna moy eyak humanawwangan ta kumpulnay mangakhup ke ha-on ya patayonak.” ");
INSERT INTO ifk_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mu kanan APU DIOS ke hiyay “Adi, te wada key mamaten he-a ya pitun tataguy awit mu.” Ot markaan APU DIOS hi Kain ta pangimatunan di tatagu ta adida patayon. ");
INSERT INTO ifk_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ot tumayan hi Kain nah kad-an APU DIOS ot mumpaed Nod an nangappit hi timilan di algo ad Eden. (Hay kibalinan di Nod ya punhanawwangan.) ");
INSERT INTO ifk_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nalahin hi Kain ot muntanud ya lalaki ot ngadananah Enoch. Impumbalin Kain hi ongal an boble nan numboblayan da ot ngadananah Enoch an ngadan nan imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nahlag hi Enoch ot hi Irad. Nahlag hi Irad ot hi Mehujael. Nahlag damdamah Mehujael ot hi Metusael. Ya nahlag hi Metusael ot hi Lamek. ");
INSERT INTO ifk_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Hi Lamek ya duway inayana an da Adah ke Sillah. ");
INSERT INTO ifk_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Nun-imbabaleh Adah ot ngadanan dah Jabal an hiyay nahlagan nadan mumpattol ya mumbale dah kampu. ");
INSERT INTO ifk_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hay tulang Jabal ya hi Jubal an hiyay nahlagan nadan nalaing an mun-ayyuding ya nadan mun-ippiip. ");
INSERT INTO ifk_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Hi ke damdama Sillah ya nun-imbabale ot da Tubal Kain ya nan babain hi Naamah. Hi Tubal Kain ya numbalin an mumpanday. ");
INSERT INTO ifk_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Indani ya kanan Lamek nadah duwan inayanay “Dakayu Adah ke Sillah ya donglon yu tun kalyok. Pinatek on kumat-agun lalaki te pinat-uwanak. ");
INSERT INTO ifk_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Deket pituy awit apun hi Kain ya ha-on ke ya napitut pituy awit ku.” ");
INSERT INTO ifk_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nawada boy ohan lalakin imbabalen da Adam ke Eva. Ot kanan Evay “Indat Apu Dios ta mihannot ke Abel an pinaten Kain.” Ot ngadananah Seth. ");
INSERT INTO ifk_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Handih kimmat-aguh Seth ya nalahin ot muntanud ya lalaki ot ngadananah Enos. Ya kediyen tiempoy nangipalpuwan di tagun maamung an mundasal ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Handih nunlutuwan Apu Dios hi tagu ya in-ummat nah pangi-ena. Lintuna didan lalaki ya babai ya binendisyonana dida ot ngadanana didah tagu. Hituwey tonton di holag Adam. ");
INSERT INTO ifk_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Handih hinggatut ta tulumpuluy toon Adam ya nahlag boh ohan lalakin nanguk-ukbun hiya ot ngadananah Seth. ");
INSERT INTO ifk_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Timmagu pay hi waluy gatut an toon ya nawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Handih natayana ya hiyam di gatut ta tulumpuluy toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hi Seth ya hinggatut ta limay toona ot ahi mawada nan imbabalenan hi Enos. ");
INSERT INTO ifk_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Timmagu pay hi waluy gatut ta pituy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Handih natayana ya hiyam di gatut ta himpulut duway toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Hi Enos ya nahiyam di toona ot ahi mawada nan imbabalenan hi Kenan. ");
INSERT INTO ifk_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Timmagu pay hi waluy gatut ta himpulut limay toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Handih natayana ya hiyam di gatut ta limay toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Hi Kenan ya napituy toona ot ahi mawadah Mahalalel. ");
INSERT INTO ifk_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Timmagu pay hi waluy gatut ta nap-at an toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Handih natayana ya hiyam di gatut ta himpuluy toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Hi Mahalalel ya nan-om ta limay toona ot ahi mawadah Jared. ");
INSERT INTO ifk_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Timmagu pay hi waluy gatut ta tulumpuluy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Handih natayana ya waluy gatut ta nahiyam ta limay toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hi Jared ya hinggatut ta nan-om ta duway toona ot ahi mawada nan imbabalenan hi Enoch. ");
INSERT INTO ifk_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ot tumagu pay hi waluy gatut an toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Handih natayana ya hiyam di gatut ta nan-om ta duway toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hi Enoch ya nan-om ta limay toona ot ahi mawada nan imbabalenan hi Methuselah. ");
INSERT INTO ifk_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Timmagu pay hi tulun gatut an toon ot mawada day udum an imbabalena. Hiya ya nakihayyup ke Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hay ngam-ut di toon an numbiyagana ya tulun gatut ta nan-om ta lima. ");
INSERT INTO ifk_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Kediyen numbiyagana ya maphod di nakihayyupanan Apu Dios. Indani ya mama-id te ingkuyug Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Hi Methuselah ya hinggatut ta nawalut pituy toona ot ahi mawada nan imbabalenan hi Lamek. ");
INSERT INTO ifk_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Timmagu pay hi pitun gatut ta nawalut duwan toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ot mate handih hiyam an gatut ta nan-om ta hiyam di toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hi Lamek ya hinggatut ta nawalut duway toona ot ahi mawada nan imbabalenan lalaki. ");
INSERT INTO ifk_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ya kananay “Maphod ta wada tun ungan kalpuwan di alubyag takun am-in tuh naligat an ngunu taku tuh lutan dinug-ahan APU DIOS.” Ot ngadana nah Noah. ");
INSERT INTO ifk_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ot tumaguh Lamek hi liman gatut ta nahiyam ta liman toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Handih natayana ya pituy gatut ta napitut pituy toona. ");
INSERT INTO ifk_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Hi Noah ya nuntoon hi liman gatut ot ahi mawada nan tulun imbabalenan da Sem, hi Ham ya hi Japet. ");
INSERT INTO ifk_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Dimmakol da moy tatagu ot mungkihinap da tuh luta ya wadaday mamaddikit an binabai. Ya handih inang-ang nadan wadad kabunyan dadiyen binabai tuh luta ya in-ine da nan pinhod da. ");
INSERT INTO ifk_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kanan APU DIOS di “Waday poppog di pangan-anusan di Espirituk hi tatagu te namahig di kinagaga-iho da, kinali idat ku ya abuy hinggatut ta duwan puluy toon hi puntutuyuwan dah liwat da.” ");
INSERT INTO ifk_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Hidiyey nawadaan di o-ongal an tatagu tuh lutan nahlag nadah binabain nakiine nadah nalpud kabunyan. Datuwen holag da ya ongal di kabaelan da ot makalkali da handih done. ");
INSERT INTO ifk_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Gapu te tinibon APU DIOS di kinagaga-ihon di tagu ya makatuttuyu hi nunlutuwanah dida te gaga-ihot nangamung di wadah nomnom da. ");
INSERT INTO ifk_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ot kananay “Dadagok ta mama-id tun tatagun lintuk ya takon nadan aggayam ya nadan hamuti te makatuttuyuwak an nunlutu ke dida.” ");
INSERT INTO ifk_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mu hi Noah di pun-amlongan APU DIOS te maphod di pangi-ena. ");
INSERT INTO ifk_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Hituwey na-na-at ke Noah. Hi Noah ya maphod an tagu dih tiempona te maphod di nakihayyupanan Apu Dios. Waday tulun linalakin imbabalena an hi Sem, hi Ham ya hi Japet. ");
INSERT INTO ifk_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mu nadan udum an tatagu tuh luta ya namahig di kinagaga-iho da ya mumpapatte da. ");
INSERT INTO ifk_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ta hi Apu Dios ya tibtibbonan ad-adi tun lutan pumboblayan te gaga-iho dan am-in di tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ot kananan Noah di “Dadagok tun luta ta mapoppog di biyag di tagu te nahalman an gaga-ihoy atoaton dan mumpapatte da. ");
INSERT INTO ifk_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kinali mangapya kah bapor an kaiw ya kuwakuwartuwom. Ya hulatam hi pukot nadan numbattanan di dingding ta maid di humgop hi danum. ");
INSERT INTO ifk_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hay lukud di kadukkena ya opat di gatut ta naliman piye ya napitut liman piyey kabilog na ya nap-at ta liman piyey katag-ena. ");
INSERT INTO ifk_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atopam, mu tibom ta waday ohat kagodwan piyey pumbattanan nan atop ya dingding. Kapyaom an tulun gladu ya pantowam nah pinigging na. ");
INSERT INTO ifk_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Man-uket kanak di mangapya kah bapor ya ahik lobngon tun luta ta madadag am-in di matagu. ");
INSERT INTO ifk_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mu he-a ke ya waday planuk an ipaannung ku, kinali ihwang dakayun ha-on. Humgop kayun nah inayam ya nadan imbabalem ya nadan inayan da nah bapor. ");
INSERT INTO ifk_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ya pakighop yu nah bapor di numbullubullug am-in hanadah nunhihinnatkon an aggayam ya nadan hahamuti ta tumagu da. ");
INSERT INTO ifk_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ipaghop yu damdamay kanon yu ya hay kanon da.” ");
INSERT INTO ifk_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ot aton am-in Noah nan kinalin Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kanan APU DIOS ke Noah di “Humgop kayun am-in an himpamilya nah bapor. Man-uke ya tibtibbok an am-in hantudah tatagu ya he-a ya abuy maphod. ");
INSERT INTO ifk_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tibom ta umipaghop kah himpipitun numbullubullug nadah aggayam an napilin miappit ke ha-on ya ohan numbullug ya abu nadah adi miappit. ");
INSERT INTO ifk_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ya pakipaghop yu boy himpipitun numbullubullug am-in hanadah hahamuti. Athituy atom am-in hanadah nunhihinnatkon an aggayam ta waday mumbunat hituh luta. ");
INSERT INTO ifk_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Te mala-uy pitun algo ya ipaalik di udan ta umudan hi nap-at an algo ya nap-at an hilong ta mama-id am-in di matagun lintuk.” ");
INSERT INTO ifk_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ot aton Noah am-in dadiyen kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","12","Hiya ya nan inayana, nadan imbabalena ya nadan inayan da ya hinumgop da nah bapor ta adida malting. Hanadan numbullubullug an aggayam an miappit ya nadan adi miappit ya immali da ot humgop da nah bapor. Takon nadan numbullubullug an hamuti, nadan mungkaddapan ya nadan mumbulluhan ya immali da damdama nah bapor ot humgop da. Ot handih nala-uy pitun algo an kediye ya mikahimpulut pitun algon diyen mikadwan bulan kediyen toon ya linappuwana tut-uwa anhan an umudan. Intottool nay udan hi nap-at an algo ya nap-at an hilong ya mumpun-otbol di danum ya takon nan kabunyan ya kay nalukatan ta namahig di udan ot malbongan di luta. Ya kediye ya onom di gatut di toon Noah. ");
INSERT INTO ifk_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nalbongan di luta, mu da Noah, nan inayana ya nadan imbabalena an hi Sem, hi Ham ya hi Japet, takon nadan inayan da ya uggeda nalting te hinumgop da tuwali nah bapor. ");
INSERT INTO ifk_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Ya nadan numbullubullug an nunhihinnatkon an aggayam, maayum ya mailom, takon nadan muntayyapan ya nakiha-ad dan am-in ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hidiyey kinalin Apu Dios an aton da. Ot kediyen hinumgopan da am-in nah bapor ya indakkig APU DIOS nan panto. ");
INSERT INTO ifk_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Taganay udan hi nap-at an algo ot adallom mo nan danum ya timmap-o nan bapor. ");
INSERT INTO ifk_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nabigat on mungkadakol nan danum an tumag-en tumag-e yaden muntaptap-o nan bapor. ");
INSERT INTO ifk_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Takon nadan nungkatag-en bibilid tuh luta ya hinabyat na. Tagan di danum di tag-e ta loktat ya nahawwal hi onom an metroy katag-ena nah tap-on dadiyen natag-en bibilid. ");
INSERT INTO ifk_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Ot mama-id am-in di matagun munyahyahya tuh luta, nadan tatagu, nadan aggayam, mailom ya maayum, nadan mumbulluhan ya nadan hahamuti te nalting dan am-in. Hay ya abu nihwang an ugge nalting ya da Noah ya nadan udum an wadan nah bapor. ");
INSERT INTO ifk_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Hanan danum ya ug-ugge dimma-ul inggana nala-uy hinggatut ta nalimay algo. ");
INSERT INTO ifk_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ugge kinal-iwan Apu Dios da Noah ya nadan aggayam an wadan nah bapor ot ipaali nay dibdib ot matmatdukan nan danum. ");
INSERT INTO ifk_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ya natikod mo nadan danum an malpud dalom ya ad kabunyan ");
INSERT INTO ifk_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ot mun-ul-ulen natduk hi liman bulan. ");
INSERT INTO ifk_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Handih mikapulut pituy algon di mikapitun bulan ya nipattuk nan bapor nah Bilid an Ararat. ");
INSERT INTO ifk_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mungkatduk nan danum ot handih namangulun algo kediyen mikapulun bulan ya matibo moy tuktuk di bibilid. ");
INSERT INTO ifk_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nala-uy nap-at an algo ot ahi ibughul Noah di ohan tawang nan bapor. ");
INSERT INTO ifk_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ot ipatayap nay ohan gawwang, mu ugge nibangngad te timmanayyapan ta inggana matduk nan danum. ");
INSERT INTO ifk_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ot ipatayap na bo nan ohan paloma ta panginil-ana hin natduk nan danum. ");
INSERT INTO ifk_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mu maid di ena opaan te ugge ni-an natduk di danum ot mibangngad nah bapor ot alan Noah ot ipaghop na. ");
INSERT INTO ifk_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hin-od nay pitun algo ot ahina bo ipatayap nan paloma. ");
INSERT INTO ifk_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mungkahilong kediye ya nibangngad nan paloma an waday himbat nah tubun di kaiw an oliba. Ot hidiyey nanginilaan Noah an natduk mo nan danum. ");
INSERT INTO ifk_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ot pala-uwona boy pitun algo ot ahina ipatayap hidiyen paloma, mu ug-ugge nibangngad. ");
INSERT INTO ifk_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Handih onom di gatut ta ohay toon Noah kediyen namangulun algoh namangulun bulan ya maid moy danum ot ibughul na nan bapor ot mun-ang-ang-ang ya mungkamag-anan moy luta. ");
INSERT INTO ifk_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ya handih nala-uy duwampulut pitun algoh mikadwan bulan ya nakammag-anan mo nan luta. ");
INSERT INTO ifk_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kanan Apu Dios ke Noah di ");
INSERT INTO ifk_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Damana mon lumah-un kayun nah inayam, nadan imbabalem ya nadan inayan da. ");
INSERT INTO ifk_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ya palah-unom nadan aggayam takon nadan hamuti ta mumbunat dat mihinap da tuh luta.” ");
INSERT INTO ifk_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ot lumah-un hi Noah ya nan pamilyana nah bapor. ");
INSERT INTO ifk_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Takon nadan aggayam, nadan hamuti ya nadan mungkaddapan ya limmah-un da an waday oha on nun-uunnud da nadah kaingngo da. ");
INSERT INTO ifk_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nangapyah Noah hi pun-appitan ke APU DIOS ot alanay hin-oh-a nadah aggayam ya hamuti an miappit ot gobhonan in-appit nan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ya inabulut APU DIOS hidiyen niappit ke hiya. Ot kananah nomnom nay “Adik mo ipidwan dug-ahan di luta takon di gaga-ihoy pangi-en di tagu. Te inilak an nunna-ud tuwali handih kaunga dan adi maphod di wadah nomnom da. Adik mo ipidwan lobngon tun lutat adi madadag am-in di matagu. ");
INSERT INTO ifk_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ya adi mapa-i tun luta ta nanongnan waday tiempon puntanoman ya waday ahiani, wadat nangamung di tialgo ya ahiudanan ya waday pat-al ya hilong.” ");
INSERT INTO ifk_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hi Apu Dios ya binendisyonanah Noah ya nadan iimbabalena an kananay “Mangaddu kayu ta dumakol kayu ta boblayan yun am-in tun luta. ");
INSERT INTO ifk_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Am-in di aggayam, nadan hahamuti ya nadan matagun wadah baybay ya tumakut dan dakayu ya dakayuy nangamung hi pangiatan yun dida. ");
INSERT INTO ifk_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Am-in datuwe ya idat kun dakayu ta pananud yuh adol yu umat nadah nitanom an indat kun dakayu. ");
INSERT INTO ifk_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mu iadik an kanon yu nadan dotag an nanongnan waday dalana te nan dalay kawad-an di biyag. ");
INSERT INTO ifk_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kinali nan tagun patayonay ibbanan tagu ya kastiguwok ya kate damdamay pangastiguk nah aggayam an pumateh tagu. ");
INSERT INTO ifk_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Te lintuk di tagu an umat ke ha-on, ta hidiye nan waday pumateh ibbanan tagu ya patayon yu damdama. ");
INSERT INTO ifk_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Maphod di mangaddu kayu ta dumakol di imbabale yu ta mihinap da tuh luta.” ");
INSERT INTO ifk_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kanan bon Apu Dios ke Noah ya nadah imbabalenay ");
INSERT INTO ifk_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Dakayu ya takon nadan holag yu ya ipaannung kuy planuk hi kiphodan yu ");
INSERT INTO ifk_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","takon nadan aggayam ya hahamutin impalah-un yu nah bapor. ");
INSERT INTO ifk_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ya punna-udok mon kalyon ke dakayu an adi mo malbongan tun luta ta adi mo madadag am-in di matagu. ");
INSERT INTO ifk_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Hay pangitib-an yun umannung tun kinalik ke dakayu takon nadan aggayam ya punnanongok ta nangamung di nakitobbalak ke dakayu an wadaok di at-atibungalon nah kulabut hi kabunyan ta ahi damdama pangitib-an di holag yu. ");
INSERT INTO ifk_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ta deket nah waday at-atibungalon hi kabunyan ");
INSERT INTO ifk_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","16","ya hidiyey panginomnomak nah kinalik ke dakayu ya am-in di matagun wada tuh luta an adi mo mapidwan malbongan tun luta. ");
INSERT INTO ifk_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hidiyey pangimatunan yu nah kinalik an kiphodan am-in di matagu tuh luta.” ");
INSERT INTO ifk_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Hanadan tulun imbabalen Noah an limmah-un nah bapor ya hi Sem, hi Ham ya hi Japet. Diday nalpuwan am-in di tatagun nihinap tuh luta. Hi Ham ya hiyay aman Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hay ngunun amadan hi Noah ya muntanom. Hiyay namangulun nuntanom nah grapes. ");
INSERT INTO ifk_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Waday naminghan an kinapya na nan grapes hi mainum ot inumona. Handih nabutong ya numbollad ot pamaganah bakilang nah abung nan nakapyah tulda. ");
INSERT INTO ifk_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hi Ham an hi aman Kanaan ya tinibonah amana an hi Noah an numbollad ya ena kinali nah duwan tulang na an da Sem ke Japet. ");
INSERT INTO ifk_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ot diday e nangulon amada an inwang-al da nan uloh indoggan da ot ihunohhunod dan mangeh kad-an amada ta adida iang-ang ke hiya ot handih nih-up da ya ingga da nan ulo ot maulohan hi amada. ");
INSERT INTO ifk_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Handih napaey binutong Noah ot inilaonay inat Ham an udidiyan an imbabalena ");
INSERT INTO ifk_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ya kananay “Hay dug-an di iKanaan an holag Ham ya diday ahi kababbabaan an muttatyun nadan holag da tulang nan hi Sem ya hi Japet. ");
INSERT INTO ifk_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Madayaw hi AP-APU an Dios Sem ya mabendisyonan anhan hiya. Mu nadan iKanaan ya mumbalin dan muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ya hana ot ta hi Apu Dios ya padakkolonay holag Japet ya mid-um da nah holag Sem. Mu mumbalin nadan iKanaan an himbut nadan holag Japet.” ");
INSERT INTO ifk_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hi Noah ya timmaguh tuluy gatut ta naliman toon nipalpu handih nagibbuwan di nalbongan di luta. ");
INSERT INTO ifk_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ta hay ngam-ut am-in di toona ot ahi nate ya hiyam di gatut ta nalima. ");
INSERT INTO ifk_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Datuwey holag nadan tulun imbabalen Noah an hi Sem, hi Ham ya hi Japet handih nagibbuwan di nalbongan di luta. ");
INSERT INTO ifk_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Hanadan holag Japet ya hi Gomer, hi Magog, hi Madai, hi Jaban, hi Tubal, hi Meshek ya hi Tiras. ");
INSERT INTO ifk_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Hi Gomer ya nahlag ot wadada Askenas, hi Ripat ya hi Togarmah. ");
INSERT INTO ifk_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Hi Jaban ya nahlag ot dadiye nan numpumbobled Elishah, Tarsis, Kittim, ya ad Rodes. ");
INSERT INTO ifk_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Datuwen holag Japet di aammod nadan tatagun numpumbobleh nungkih-up ya nungkigawwah baybay. Datuwey holag Japet an nun-aappil di numboblayan da ya nunhihinnatkon di kalida. ");
INSERT INTO ifk_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nahlag hi Ham ya da Kush, hi Misraim, hi Put ya hi Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Hanadan holag Kush ya dadiye nadan tatagud Seba, Habilah, Sabtah, Raamah ya ad Sabteka. Ya nadan holag Raamah ya dadiye nadan tatagud Seba ya ad Dedan. ");
INSERT INTO ifk_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Waday imbabalen Kush an hi Nimrod an numbalin hi ap-apun di makigubat. Hiyay namangulun nanganapput hi nakigubatanah kabobboble ");
INSERT INTO ifk_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ya hiya ya nakala-ing an mun-anup gapuh baddang APU DIOS. Kinali kanan di tataguh ibbaday “Hana ot ta pumbalinon dakan APU DIOS an makangannup an umat ke Nimrod.” ");
INSERT INTO ifk_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hanadan boblen pun-ap-apuwana ya Babel, Erek, Akkad ya Kalneh. Datuwen boble ya sakup di Babilon. ");
INSERT INTO ifk_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Inlagat na boy Assyria ot iphod na nadan boblen Nineveh, Rehobot Ir, Kalah ");
INSERT INTO ifk_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ya Resen an numbattanan di Nineveh ya ad Kalah an ohan ongngaongngal an boble. ");
INSERT INTO ifk_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hanadan holag Misraim ya dadiye nadan bimmobled Lydia, Anam, Lehab, Naptuh, ");
INSERT INTO ifk_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Kasluh ya ad Crete an nahlagan nadan Pilistia. ");
INSERT INTO ifk_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Hanadan holag Kanaan ya hi Sidon an panguluwan ot ahi hi Het. ");
INSERT INTO ifk_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Nawaday udum hi imbabalen Kanaan ot dadiyen imbabalenay nahlagan nadan Jebusite, Amorite, Girgashite, Hibite, Arkite, Sinite, Arbadite, Semarite ya nadan Hamatite. Datuwen holag Kanaan ya nihinap da. ");
INSERT INTO ifk_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ta hay poppog di numboblayan da ya nipalpud Sidon ingganad Gerar an nih-up ad Gaza, nah nangappit hi timilan di algod Sodom, Gomorrah, Admah ya ad Seboim an nih-up ad Lasha. ");
INSERT INTO ifk_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Datuwey holag Ham an nihinap hi kabobboble an waday oha on hinnatkon di kalida. ");
INSERT INTO ifk_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Hi Sem an nihaynod an Japet ya hiyay nahlagan nadan Hebrew. ");
INSERT INTO ifk_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Nahlag hi Sem ot wadada Elam, hi Assur, hi Arpachshad, hi Lud, ya hi Aram. ");
INSERT INTO ifk_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Hay holag damdaman Aram ya dadiye nadan wadad Us, Hul, Gether ya Meshek. ");
INSERT INTO ifk_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Hi Arpachshad ya nahlag ot hi Selah an aman Eber. ");
INSERT INTO ifk_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hi Eber ya duway imbabalenan linalaki. Hay ngadan nan oha ya hi Peleg te handih kataguna ya naganodwa day tatagu tuh luta. Ya nan oha ya hi Joktan. ");
INSERT INTO ifk_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Hituwen hi Joktan di nahlagan nadan tatagun wadad Almodad, Selep, Hasarmabet, Jerah, ");
INSERT INTO ifk_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Diklah, ");
INSERT INTO ifk_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO ifk_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Habilah ya Jobab. Datuwen am-in di nahlag ke Joktan. ");
INSERT INTO ifk_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Hay numboblayan da ya nipalpud Mesha ingganad Separ an mabilid an boble nah nangappit hi timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Datuwey holag Sem an nihinap dah dakol an boble an waday oha on hinnatkon di kalina. ");
INSERT INTO ifk_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Datuwen am-in di nahlag nadah imbabalen Noah nipalpu dih nagibbuwan di nalbongan di luta. Ot mihinap dah kabobboble mipuun hanadah nahlagan da. ");
INSERT INTO ifk_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Handih pinghana ya oha ya abuy kalin di tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Handih mungkadakol da ya numpae dah nangappit hi timilan di algo ya dinatngan da on nundotal an lutad Babilon ot mumboble dah di. ");
INSERT INTO ifk_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Indani ya waday ninomnom dah aton da. Ot kanan day “Aga ket iphod taku tun boble takut mundingngol. Mangapya takuh nakattag-en binattun bale ta datnganad kabunyan ta mundingngol taku ya adi taku miwahit.” Ot ilappu dan mangapya. ");
INSERT INTO ifk_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Indani ya immalih APU DIOS ot tibona nan boblen pun-iphod datuwen tatagu ya nan binattun balen pungkapya da. ");
INSERT INTO ifk_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kananay “Datuwen tatagu ya niohha da ya ohay kalida. Hituwey kilappuwan di pangatan da nadah pinpinhod dan aton, ta loktat ya am-in di nomnomon dan aton ya mabalin an aton da. ");
INSERT INTO ifk_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kinali agat punhihinnatkonon takuy kalida ta adida mungkakainnawatan.” ");
INSERT INTO ifk_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Athidiy inat APU DIOS ot miwahit da tuh luta ot itikod dan mangapya nah pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Hay nungngadan dan diyen boble ya Babel te hidiy nunhimongan APU DIOS ke dida an hinannotanay kalida hi nunhihinnatkon ot iwahit na didah kabobboble tuh luta. ");
INSERT INTO ifk_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Datuwey holag Sem. Handih nala-uy duwan toon nipalpuh nagibbuwan di nalbongan di luta, handih hinggatut di toon Sem ya nahlag ot wadah Arpachshad. ");
INSERT INTO ifk_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Timmagu pay hi Sem hi limay gatut an toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kimmat-aguh Arpachshad ot handih tulumpulut limay toona ya nahlag ot hi Selah. ");
INSERT INTO ifk_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ot tumagu pay hi opat di gatut ta tuluy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kimmat-aguh Selah ot handih tulumpuluy toona ya nahlag ot hi Eber. ");
INSERT INTO ifk_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Timmagu pay hi Selah hi opat di gatut ta tuluy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Handih tulumpulut opat di toon Eber ya nahlag ot hi Peleg. ");
INSERT INTO ifk_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Timmagu pay hi Eber hi opat di gatut ta tulumpuluy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Hi Peleg ya nuntoon hi tulumpulu ot mawada nan imbabalenan hi Reu. ");
INSERT INTO ifk_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Timmagu pay hi Peleg hi duway gatut ta hiyam an toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Handih tulumpulut duway toon Reu ya nawadah Serug an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Timmagu pay hi duway gatut ta pituy toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Handih tulumpuluy toon Serug ya nawada nan imbabalenan hi Nahor. ");
INSERT INTO ifk_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Timmagu pay hi duway gatut an toon ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Hi Nahor ya duwam pulut hiyam di toona ot mawada nan imbabalenan hi Terah. ");
INSERT INTO ifk_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Timmagu pay hi Nahor hi hinggatut ta himpulut hiyam ot mawada day udum an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Hi Terah ya napituy toona ot ahi mawada nadan imbabalenan da Abram, hi Nahor ya hi Haran. ");
INSERT INTO ifk_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Datuwey holag Terah an hi aman da Abram, hi Nahor ya hi Haran. Nahlag hi Haran ot hi Lot. ");
INSERT INTO ifk_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hi Haran ya nate nah bobledad Ur ad Babilon yaden matagu ni-an hi amanan hi Terah. ");
INSERT INTO ifk_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","In-inen Abram hi Sarai ya hi Nahor ke ya in-ine nah Milkah an imbabalen Haran an hi aman damdaman Iskah. ");
INSERT INTO ifk_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hi Sarai ya adi pakaimbabale. ");
INSERT INTO ifk_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Hi Terah ya ingkuyug nah Abram an imbabalena, hi Lot an inap-apuna an imbabalen Haran ya hi Sarai an inayan Abram ot taynan dad Ur hidid Babilon ot umga dan ume dad Kanaan. Mu nundag-u dad Haran ot mihaad dah di. ");
INSERT INTO ifk_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ot hidiy natayan Terah handih duway gatut ta limay toona. ");
INSERT INTO ifk_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Handih uggeda ni-an tinaynan di Babilon ya kanan APU DIOS ke Abram di “Tayanam nan boblem ya nadan iibam ta ume kan nah boblen itudduk ke he-a. ");
INSERT INTO ifk_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Idattan dakah dakol hi holag mu ta mundingngol kayu. Bendisyonan daka ta mundingngol di ngadan mu ya mabendisyonan di udum an tatagu gapun he-a. ");
INSERT INTO ifk_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ya bendisyonak nan tagun mumbendisyon ke he-a, mu dug-ahak nadan mundug-an he-a. Ya gapun he-a ya bendisyonak am-in di tatagu tuh luta.” ");
INSERT INTO ifk_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Handih napitut limay toon Abram ya tinayananad Haran an inun-unud nay kinalin APU DIOS ke hiyan atona. Ingkuyug na nan inayana, nan imbabaleyonan hi Lot ya impakiala da nadan limmu dad Haran, nadan muttatyu da ya am-in di kinadangyan da ot ume dad Kanaan. Kediyen dimmatong dad Kanaan ");
INSERT INTO ifk_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ya nangenange da ot ingganay datngan da nan pundayawan di tataguh di nah kad-an nan kaiw ad Moreh ad Sekem. Hay numpumbobleh di kediyen tiempo ya nadan nahlag ke Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Numpatiboh APU DIOS ke Abram ot kananay “Hiyah tuwe nan boblen idat kuh holag mu.” Ot mangapyah Abram hi pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Indani ya nit-an da bon nah mabilid an boble ot mungkampu dah di an numbattanan di Bethel an wadah nangappit hi kalin-oban di algo ya nan bobled Ai an wadah nangappit hi timilan di algo. Ot mangapya boh dih pun-appitan ot dayawonah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mu ugge nunnanong hidi te nun-ottaottan da an numpae dad Negeb ad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Indani bo ya waday nahalman an bitil ad Kanaan ot mumpae bo da Abram ad Egypt ot miha-ad da ni-an hidi. ");
INSERT INTO ifk_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Handih manatong dad Egypt ya kanan Abram ke Sarai di “He-a ya maddikit ka. ");
INSERT INTO ifk_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ya deket tibon daka nadah tataguh tu ya deket inilaon dan inayan daka ya patayonak ta alan daka. ");
INSERT INTO ifk_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kinali hay kalyom ya tulang daka ta adiyak patayon, mu maphod di aton dan ha-on gapun he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Handih dimmatong dad Egypt ya makulug tut-uwan maddikit di panibon nadan tatagu ke Sarai. ");
INSERT INTO ifk_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ya tinibon damdaman nadan mungngunuh balen nan patul ot eda kalyon nah patul an maddikit hi Sarai ot e ipaawit nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ya gapun Sarai ya maphod di pangat nan patul ke Abram an indatanah dakol an kalnero, gulding, baka, kamel, kabayu ya muttatyu. ");
INSERT INTO ifk_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mu gapuh nangalaan nan patul ke Sarai ya impundogon APU DIOS nan patul takon nadan tatagun wadah din nah balena. ");
INSERT INTO ifk_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ot ipaayag nan patul hi Abram ot kananan hiyay “Tipet athituy inat mun ha-on? Tipet uggem kinalin inayam hi Sarai? ");
INSERT INTO ifk_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tipet kanam di tulang mu ta deyan ek ot iine? Awitom tun inayam ta mange kayu!” ");
INSERT INTO ifk_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ot mandalon nan patul nadan tataguna ot patayanon dah Abram ya nan inayana kediyen boble da. Handih timmayan da ya impakial-ala dan am-in nadan ngunut da ya limmu da. ");
INSERT INTO ifk_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Timmayan da Abram ad Egypt ot mibangngad dad Kanaan an ingkuyug na nan inayana ya hi Lot ya impakialanan am-in nadan wadan dida. ");
INSERT INTO ifk_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Kaddakaddangyan hi Abram te dakol di bakana, kalnerona, gulding na, balituk na ya pihhuna. ");
INSERT INTO ifk_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nangenange da bo ot loktat ya dinatngan da nan niha-adan da handi nah numbattanan di Bethel ya Ai ");
INSERT INTO ifk_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","an hidi nan nangapyaanah pun-appitan handi. Kediyen dinatngan da ya dinayaw nah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Hi Lot ya wada damdamay pamilyana ya athidi bon wadada damdamay kalnerona, bakana, gulding na ya muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ta hidiye nan kumudang moy pumpattolan da te dimmakol di halun dan Abram. ");
INSERT INTO ifk_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hidiyey humlun hi punhahannuwan nadan pumpattolon da. Kediyen tiempo ya nanongnan hidiy numboblayan nadan holag Kanaan ya nadan Perisite. ");
INSERT INTO ifk_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ot kanan Abram ke Lot di “Adi maphod an munhannu ta ya takon nadan pumpattolon ta te hin-ama ta. ");
INSERT INTO ifk_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kinali kudukdulna kattog di munhi-an ta. Potkom di pinhod mun kiha-adan ta mumpae kayuh di ta mun-appil ta. Hanan adim piliyon ya hidiy pangayak.” ");
INSERT INTO ifk_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ot mun-ang-ang-ang hi Lot ya tinibona on nundotal ad Jordan ingganad Soar. Maphod hidiye te dakol di danum hidi an umat nah laguntan APU DIOS ad Eden ya wada boy niingngohanad Egypt. Naat hituwe handih ugge ni-an dinadag APU DIOS ad Sodom ya Gomorrah. ");
INSERT INTO ifk_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hidiyen nundotal ad Jordan di pinilin Lot ot ipluy dah nangappit nah timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ya hi Abram ya nunnanong ad Kanaan ya hi Lot ke ya nakiboble nah nundotal an nih-up ad Sodom. ");
INSERT INTO ifk_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mu nadan tataguh di ya gaga-iho da ya nahalman di liwat dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Handih nunhi-anan da Abram ke Lot ya kanan APU DIOS ke Abram di “Iang-ang muh nunlinikkod ingganay kipoppogan di ang-angom. ");
INSERT INTO ifk_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Te idat kun am-in dadiyen lutan he-a an tawid yun nadah holag mu ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ya idattan dakah holag mu an umat hi kadakol di dap-ul tuh lutan adi mabilang. ");
INSERT INTO ifk_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Eka ta em tibon am-in nan lutan idat kun he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ot idlig mo bon Abram nan kampu da ot eda mihaad nah nih-up nadah kakaiw nah bobled Mamre ad Hebron. Ot mangapya boh dih pun-appitan ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Indani ya waday gubat te nadan patul an hi Amraphel ad Babilon, hi Ariok ad Ellasar, hi Kedorlaomer ad Elam ya hi Tidal ad Goyim ");
INSERT INTO ifk_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ya eda nakigubat nadah liman patul an da Bera ad Sodom, hi Birsa ad Gomorrah, hi Sinab ad Admah, hi Semeber ad Seboim ya nan patul ad Bela an Soar di ohan ngadana. ");
INSERT INTO ifk_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Danaen liman patul ya nun-aaddumon day tindalu da nah Nundotal an Siddim an nih-up nah Naten Baybay. ");
INSERT INTO ifk_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Handi ya hi Kedorlaomer di patul dadiyen liman patul hi himpulut duway toon. Mu handih mikahimpulut tuluy toon ya ngohayon da mo. ");
INSERT INTO ifk_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ot amungon Kedorlaomer titindaluna ya nadan tindalun nadan udum an papatul an bumaddang ke hiya ot eda gubaton nadan tatagun ngimmohe handih mikahimpulut opat an toon. Dadiye ya nadan Repaim ad Asterot Karnaim, nadan Susim ad Ham, nadan Emim ad Kiriathim ");
INSERT INTO ifk_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ya nadan Horite nah mabilid ad Seir. Pindug da dida ot inggana nah adi maboblayan ad El Paran. ");
INSERT INTO ifk_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Imbangngad da bod En Mispat an hay ngadana mod uwani ya Kades ot gubaton da bo nadan holag Amalek ya nadan Amorite an numbobled Hasason Tamal ot apputon da dida. ");
INSERT INTO ifk_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Indani ya inamung nadan liman patul ad Sodom, ad Gomorrah, ad Admah, ad Seboim ya ad Bela an Soar di ohan ngadanay titindalu da ot eda munhood ad Siddim ");
INSERT INTO ifk_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ot gubaton dah Kedorlaomer ya nadan ibbanan tulun patul. ");
INSERT INTO ifk_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mu hidin nah eda nundadammuwan ya dakol di luyun ta handih e bumtik nadan tindalun nan duwan patul an patul di Sodom ya patul di Gomorrah ya naknay udum hanadah luyun, mu nadan tulun ibba dan patul ya binumtik da nah mabilid. ");
INSERT INTO ifk_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ot nadan opat an patul an nangapput ya nun-ala dan am-in di kumpulmin wadad Sodom ya Gomorrah takon di makan ot ahida tayanan dadiyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Takon hi Lot an numbobled Sodom an imbabaleyon Abram ya nadan haluna ya am-in di wadan hiya ya impakiala da. ");
INSERT INTO ifk_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mu maphod udot ta wada nan ohan binumtik ot ena idatdatong nah Hebrew an hi Abram an nungkampu nah nih-up nadah kakaiw Mamre an iAmorite. Hi Mamre ya nadan tutulang nan da Eskol ke Aner ya gagayyum Abram dida. ");
INSERT INTO ifk_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Handih dingngol Abram an impakialan nadan opat an patul hi Lot an imbabaleyona ya inamung nan am-in nadan tatagunan damanan makigubat an umeh tuluy gatut ta himpulut walu. Imme dan inunud da nadan patul an nangal-an Lot inggana nah bobled Dan. ");
INSERT INTO ifk_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Dimmatong dah di ot ganodwaon Abram nadan tataguna. Nahilong kediye ot ahida gubaton nadan patul an pindug da dida ingganad Hobah an indalan dad Damascus. ");
INSERT INTO ifk_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ot bangngadon dan am-in di inibtik da. Takon hi Lot an imbabaleyona ya am-in di limmuna ya nadan udum an tatagu ya nadan binabain inibtik da ya binangngad da. ");
INSERT INTO ifk_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Handih nibangngad da Abram hi nangapputan dan Kedorlaomer ya nadan ibbanan patul ya dinamun nan patul di Sodom dida ad Sabe an Nundotal an Boblen di Patul di ohan ngadana. ");
INSERT INTO ifk_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Takon nan patul di Salem an hi Melkisidek an padin nan Katagtag-ayan an Dios ya in-e nay mainum ya tinapay. ");
INSERT INTO ifk_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Ot bendisyonanah Abram an kananay “Abram, hana ot ta paphodon dakan Apu Dios an Katagtag-ayan ya nunlutuh kabunyan ya luta. Ya hana ot ta madayaw hiya an nangipangapput ke he-a.” Ot ne idat Abram ke Melkisidek di mikapulun am-in nah inapput dah eda nakigubatan. ");
INSERT INTO ifk_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Indani ya kanan nan patul di Sodom ke Abram di “Takon di nan tataguk ya abuy ibangngad mun ha-on. Hanada ken nabalol an ngunut an naalah boble mi ya takon di ibagim am-in.” ");
INSERT INTO ifk_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mu kanan Abram di “Adik aton hina te insapatak ke APU DIOS an Katagtag-ayan an nunlutuh kabunyan ya luta ");
INSERT INTO ifk_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","an maid di ek alan takon di gakod di apatut yu ta maid di ahim kalyon hi udum hi algo an he-ay nangipakadangyan ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Abuna nan kinan mi nadah tataguk an e nakigubat di adik ibangngad ke he-a. Mu idat muy bingay da Aner, hi Eskol ya hi Mamre an gagayyum kun bimmaddang ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Indani ya numpatiboh APU DIOS ke Abram hi in-inop na. Kananay “Adika tumakut Abram te paddungnay ha-oy di happiyom ya ha-oy di mangipaphod ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Hinumang Abram an kananay “APU DIOS an Nakattag-e, takon di atom hina ya nganne damdamay hilbinan maid di indat muh imbabalek an pangipaboltanak nadah wadan ha-on. Hay ya abu mabalin an mamoltan ya nan muttatyuk an iDamascus an hi Elieser.” ");
INSERT INTO ifk_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ya himmumang hi APU DIOS an kananay “Bokon hinaen muttatyum an hi Elieser di mamoltan te hay imbabalem.” ");
INSERT INTO ifk_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Impalah-un APU DIOS hi Abram ot kananan hiyay “Itangad mud kabunyan ta bilangom nadan bittuwon hin pakabilang ka. Te ahi athidiy kadakol di holag mu.” ");
INSERT INTO ifk_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ya kinulug Abram hi APU DIOS. Gapun tuwen nangulugan Abram ke APU DIOS ya imbilang nah Abram an maphod an tagu. ");
INSERT INTO ifk_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ot kanan APU DIOS ke hiyay “Ha-on nan DIOS an nangipakaan ke he-a nah bobled Ur ad Babilon ta idat kun he-ah tuwen luta.” ");
INSERT INTO ifk_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kanan Abram ke hiyay “APU DIOS an Nakattag-e, nganney panginilaak an ahik boltanon?” ");
INSERT INTO ifk_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kanan APU DIOS ke hiyay “Eka umalah baka, gulding ya kalnero an tangbal an hintutluy toon da ta ialim hitu. Ya immala ka boh ohan paloma ya ohan balug.” ");
INSERT INTO ifk_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ot e alan Abram am-in dadiyen imbagan Apu Dios ke hiya. Dinaut na didan impapinni-ang na ot punduwaonan pinalpaldang, mu nada ken duwan hamuti ya uggena pini-ang. ");
INSERT INTO ifk_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Indani ya natapangan nadan hamutin mangan hi naten aggayam, mu inabul Abram dida. ");
INSERT INTO ifk_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Indanit tuwen malimuy algo ya nakayyongyong hi Abram ya waday kay munhihhilong an katatakut. ");
INSERT INTO ifk_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ya kanan APU DIOS ke hiyay “Hi udum an algo ya ume nadan holag mun makibobleh udum an boble. Mumbalin dah himbut hi opat di gatut an toon ya paholholtapon da dida. ");
INSERT INTO ifk_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mu ahik kastiguwon nadan tatagu kediyen boblen mangipaholholtap ke dida. Ya deket tumayan datuwen holag mu kediyen boble ya pakiala day kinadangyan diyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","He-a ya maka-am-ama kat ahika mate ya malinggop di katayam. ");
INSERT INTO ifk_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ingganay mikap-at an holag mu ya ahida mibangngad ketuwen boble. Ahi milodlod di kinagaga-ihon tudan Amorite ta kastiguwok dida.” ");
INSERT INTO ifk_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kediyen nalimuy algo an nahilong mo ya waday tinibon Abram hi bangan mun-aahuk ya apuy an mundadalang an naaliwannat nah numbattanan nadan dotag an impunduwanan pinalpaldang. ");
INSERT INTO ifk_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ya kediye ya kanan APU DIOS ke hiyay “Hituwen luta ya idat kun he-a ya nadan holag mu, mipalpu nah poppog di Egypt inggana nah Wangwang an Euphrates an ");
INSERT INTO ifk_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","numboblayan nadan Kenite, Kenissite, Kadmonite, Hittite, Perisite, Repaim, Amorite, Kanaanite, Gergashite ya nadan Jebusite.” ");
INSERT INTO ifk_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hi Sarai an inayan Abram ya adi pakaimbabale, mu ninomnom nan iabulut nah Hagar an muttatyunan iEgypt an ihuyop Abram. ");
INSERT INTO ifk_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Ta hidiye nan kananan Abram di “Takomboy ihuyop mu tun muttatyuk ta kal-ina ot ya imbabaleyam ta waday imbabale ta teden adi iabulut APU DIOS an mun-imbabaleyak.” Ya inabulut Abram hidiyen kinalin Sarai. Hay naatan tuwe ya handih nala-uy himpulun toon hi niha-adan dad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nunhuyop da Abram ke Hagar ot mawadaan hi Hagar. Handih ininnilan Hagar an nawadaan ya mumpahhiya ya namahig di pamihul na ke Sarai. ");
INSERT INTO ifk_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ot kanan Sarai ke Abram di “He-ay kon bahul hi pamihulan nan muttatyuk ke ha-on. Man-u te in-abulut kun ihuyop mu, mu nipalpu handih nawadaan ya pihupihulonak ke hiya. Hana ot ta tibon APU DIOS hin dahdiy niptok ke ditan duwa, he-a weno ha-oy.” ");
INSERT INTO ifk_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ya kanan Abram ke hiyay “He-ay kon muttatyun hiya, nangamung kah pinhod mun aton ke hiya.” Ot nahalman di aton Sarai an palohalohananah Hagar ot loktat ya binumtik. ");
INSERT INTO ifk_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Indani ya inakhupan nan anghel APU DIOS hi Hagar nah ob-ob nah adi maboblayan hi pingngit di kalatan mumpaed Sur. ");
INSERT INTO ifk_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kananan hiyay “Hagar an muttatyun Sarai, tipet wada kah tu? Daanay nalpuwam ya daanay pangayam?” Ya kanan Hagar di “Binumtikak an tinayanak hi Sarai an kon muttatyun ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ot kanan nan anghel ke hiyay “Mibangngad ka ke hiya ta munnanong kan muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Idattan dakah dakol hi holag mun adi mabilang. ");
INSERT INTO ifk_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hinaen imbutyug mu ya lalaki. Ya deket mitungo ya ngadanam hi Ismael te dingngol APU DIOS di numpahpahmokam ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hinaen ahim iimbabale ya ahi mialig nah mailom an kabayu. Ya pakaibboh-ol nay ibbanan tagu ya pakaibboh-ol damdaman di udum an tatagu. Ya ahi mihi-an hi iibana.” ");
INSERT INTO ifk_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kanan Hagar hi nomnom nay “Kon nin makulug an tinibok hi Apu Dios yaden kapyanan mataguwak ta ahik kalkalyon di mipanggep ketuwe?” Ot ngadananah APU DIOS an kimmalin hiya hi “Hanan Dios an manmannibon ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ta hidiye nan hay pungngadan di tatagu kediyen ob-ob an numbattanan di Kades ya Bered ya “Ob-ob nan wadat nangamung an manmannibon ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Intungon Hagar nan imbabale dan lalaki ot ngadanan Abram hi Ismael. ");
INSERT INTO ifk_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hay toon Abram kediye ya nawalut onom. ");
INSERT INTO ifk_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Handih umeh nahiyam ta hiyam di toon Abram ya numpatibo boh APU DIOS ke hiya ot kananay “Ha-oy nan Dios an Kabaelanan amin. Un-unudonak ya hay maphod di atom ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Paannungok nan kinalik ke he-a an idattan dakah dakol hi holag mu.” ");
INSERT INTO ifk_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kediyen mungkalih Apu Dios ya nunyuung hi Abram hi punlispitu nan hiya. Kanan bon Apu Dios di ");
INSERT INTO ifk_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kalyok ke he-a an he-ay ahi kahlagan di dakol an tataguh kabobboble. ");
INSERT INTO ifk_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ad uwani ya hay mo ngadan mu ya hi Abraham, bokon mo Abram, te pumbalinon dakah pun-aman di dakol an tataguh kabobboble. ");
INSERT INTO ifk_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Idattan dakah dakol an holag mu. Mumbalin day udum hi patul ya dumakol di pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Punnanongok hituwen kinalik ke he-a takon hanadah holag muh udum hi algo. Hituwen nakitobbalak ke dakayu ya munnananong an maid di poppog na. Ya munnanong an ha-on di Dios an dayawom ya athidi bon hanadah holag mu an ha-on di Dios an dayawon dat nangamung. ");
INSERT INTO ifk_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Hituwen boblen Kanaan an nakiboblayam ya idat kun am-in ke he-a ya nadah holag mu ta dakayuy kon lutat inggana ya ha-oy an Dios di dayawon da. ");
INSERT INTO ifk_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","13","Mahapul an he-a ya nadan holag mu ya mumpakugit kayu ta kitib-anan punnanongon yu tun nakitobbalak ke dakayu. Kinali mipalpud uwani ya makugit am-in di lalakin mitungo nah mikawalun algo mipalpuh nitungawan da, takon nadan itungon di himbut yuh nunhituwan yu ya nadan himbut an iali dan malpuh udum an boble ya makugit da damdama. Hituwen kakugitan yuy kitib-ana an adi mapoppog di nakitobbalak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Hanan lalakin ugge nakugit ya adi mibilang an taguk te uggena inun-unud nan kinalik an planuk.” ");
INSERT INTO ifk_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kanan bon Apu Dios ke Abraham di “Hi Sarai an inayam ya hi Sarah moy ngadana mipalpud uwani. ");
INSERT INTO ifk_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bendisyonak ta mun-imbabale kayuh lalaki. Pumbalinok hi Sarah an pun-inan di tataguh kabobboble. Ya wadaday ahi mumpatul hi holag na.” ");
INSERT INTO ifk_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ya nunyuung hi Abraham hi pundayaw nan Apu Dios. Mu makatattawah nomnom na te kananay “Kon e mo uppe pakaimbabaley tagun hinggatut di toon na? Ya takon di hi Sarah an nahyam di toona ya kon e mo pakaimbabale?” ");
INSERT INTO ifk_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ot kanan Abraham ke Apu Dios di “Daan mot hi Ismael ot ya abu?” ");
INSERT INTO ifk_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mu kanan Apu Dios di “Bokon te mun-imbabaleh Sarah hi lalaki ta ahiyu ngadanan hi Isaac. Hiya ya nadan holag nay ahik pangipaannungan nah kinalik ke he-a an planuk an adi mahannotan, mu munnananong ta inggana. ");
INSERT INTO ifk_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dingngol ku nan imbagam an kiphodan Ismael, kinali bendisyonak damdamat idatak hi dakol an holag na. Hiyay ahi pun-aman di himpulut duwan aap-apu ya datuwen holag na ya ongngaongngal di pumboblayan da ya madmadngol da damdama. ");
INSERT INTO ifk_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mu hay pangipaannungak nah kinalik ke he-an planuk ya nan imbabalem an hi Isaac an ahi itungon Sarah hi athitun tiempo tuh umalin toon.” ");
INSERT INTO ifk_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ginibbun Apu Dios hidiyen kinalina ot tayananah Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kediyen algo ya inun-unud Abraham nan kinalin Apu Dios ot kugitona nan imbabalenan hi Ismael ya am-in nadan linalakih nunhituwana takon nadan imbabalen di muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ya takon hiya ya numpakugit an hay toon an diye ya nahiyam ta hiyam ");
INSERT INTO ifk_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ya hi Ismael ke ya himpulut tuluy toona. ");
INSERT INTO ifk_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nundihhan dan hin-ama an numpakugit kediyen algo ");
INSERT INTO ifk_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ya takon nadan linalakin muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Waday ohan maka-al-algo an um-umbun hi Abraham nah panton di abung da ya numpatiboh APU DIOS ke hiya nah waday kakaiw ad Mamre. ");
INSERT INTO ifk_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","In-ang-ang na ya tinibo nay tulun linalakin muntattaddog ot ume ot munyuung hi punlispitu nan dida. ");
INSERT INTO ifk_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","5","Ot kananay “Aap-apu, mundag-u kayu ni-an ot dehtuwak an idadaan kuy mahapul yu. Ongal di amlong kuh nangidalanan yu tuh nunhituwak. Mun-iyatu kayu ni-an tuh puun di kaiw ta eyak umalah danum hi pangula yuh hukiyu, dammunay pundadaanak hi kanon yu ta waday ikilog yun ume nah pangayan yu.” Ya timbal da an kanan day “Takombo mo.” ");
INSERT INTO ifk_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Galagalah Abraham an hinumgop nah abung da ot kananan Sarah di “Umala ka nah makakkaphod an alina ta manginkakapya kah tinapay.” ");
INSERT INTO ifk_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Gimmagala bo nah halun da ot dumpap nah makaphod an bakana ot paguyud nah ohan muttatyuna ot ena partiyon. ");
INSERT INTO ifk_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nalutun am-in ot idadaana nadan udum an makan ya gatas ot iena ot mangan nadan tulun tatagu nah puun di kaiw. ");
INSERT INTO ifk_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kediyen mangmangngan da ya kanan day “Daan moh Sarah an inayam?” Ya kananay “Dehdih bohongna.” ");
INSERT INTO ifk_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kanan APU DIOS di “Umaliyak boh toon hi athitun tiempo ya wada moy imbabalen Sarah an lalaki.” Ya hi Sarah an wadan nah pantoh indoggan Abraham ya dingngol nah diyen kinali da. ");
INSERT INTO ifk_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ya gapu te naam-amah Abraham ya nain-ina damdamah Sarah ya natikod moy malpuh adol na, ");
INSERT INTO ifk_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","kinali makatattawah Sarah hi nomnom na an kananay “Ad uwani ke moppen in-inaak ya am-ama moh Abraham ya kon eyak mo mawadaan?” ");
INSERT INTO ifk_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ot kanan APU DIOS ke Abraham di “Tipet makatattawah Sarah an kananay ‘Kon mabalin moppen mun-imbabaleyak yaden in-inaak?’ ");
INSERT INTO ifk_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kon waday adi kabaelan APU DIOS? Deya bon kanak di, hantuh kibangngadak an mala-uy hiyam an bulan ya muntungoh Sarah hi lalaki.” ");
INSERT INTO ifk_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Timmakut hi Sarah ot ihaut nan kananay “Uggeyak timmatawa.” Mu kanan Apu Dios di “Makulug an timmatawa ka.” ");
INSERT INTO ifk_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nagibbuh diyen nunhuhummanganan da ot ahida ume nah pangayan da. Ot ibbaan Abraham dida inggana nah mauhdungan di Sodom. ");
INSERT INTO ifk_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Indani ya kanan APU DIOS di “Kudukdul nay ipainilak ke Abraham di ninomnom kun atok. ");
INSERT INTO ifk_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Hanadan holag na ya ahida mumbalin an ongal an boble ya diday madmadngol. Ya gapun hiya ya bendisyonak am-in di nunhihinnatkon an tatagu tuh luta. ");
INSERT INTO ifk_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Hiyay pinilik ta wada ot an tugunona nadan holag na ta ha-oy di un-unudon da ya maphod di aton da. Deket un-unudon dah diyen pinhod ku ya atok am-in nadan kinalik ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ot kanan APU DIOS ke Abraham di “Dingngol kuy mipanggep hi gaga-ihon at-atton nadan tatagud Sodom ya ad Gomorrah. ");
INSERT INTO ifk_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kinali mahapul an umeyak ta ek tibon hin makulug.” ");
INSERT INTO ifk_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hanadan duwan lalaki ya intuluy dan numpaed Sodom. Mu nan katlu da an hi APU DIOS ya numbati an ugge naki-e. ");
INSERT INTO ifk_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kanan Abraham ke APU DIOS di “An ma-idom tut-uwa am-in nadan tatagud Sodom ta takon nadan maphod di at-atton da ya milagat da? ");
INSERT INTO ifk_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nungay ta waday nalimay bilang di tatagun maphod di at-atton da, kon dadagom hidiyen boble? Weno adim ta adi milagat nadan maphod an tatagu? ");
INSERT INTO ifk_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","He-a an Huwes am-in tuh luta ya limpiyu ka, kinali inilak ot adim pakidadag nadan maid di bahul na nadah nabahulan.” ");
INSERT INTO ifk_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kanan APU DIOS di “Deket wadaday naliman tatagun maphod di at-atton da ya adik dadagon hidiyen boble.” ");
INSERT INTO ifk_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ot kanan bon Abraham di “Apu, pasensiyaanak anhan hin maid di agol kun mangibagan he-a ketuwe te inilak an gulat na ya maid di lebbeng kun kumali te taguwak ya abu. ");
INSERT INTO ifk_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nungay ta nap-at ta lima ya abuy maphod hidi, kon dadagom hidiyen boble?” Ya kanan APU DIOS di “Adik dadagon hidiyen boble hin waday nap-at ta liman maphod an tatagu.” ");
INSERT INTO ifk_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ya kanan bon Abraham di “Nungay ta nap-at da ya abu?” Ya kanan bon Apu Dios di “Adik dadagon, takon di nap-at da ya abuy maphod.” ");
INSERT INTO ifk_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ya kanan bon Abraham di “Apu Dios, adika anhan bumoh-ol te wada pay di ibagak. Nungay ta tulumpulu ya abuy maphod hidi?” Ya kanan Apu Dios di “Adik dadagon hin wadaday tulumpulu.” ");
INSERT INTO ifk_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ya kanan bon Abraham di “Apu Dios, iabulut mu ta ituluy kun ibaga tun wadah nomnom ku. Nungay ta wada ya abuy duwampulu?” Ya kanan bon Apu Dios di “Adik dadagon hidiyen boble takon di duwampulu ya abuy maphod an tataguh di.” ");
INSERT INTO ifk_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kanan bon Abraham di “Apu, adika anhan umingle, hituwe moy manguddidih ibagak. Nungay ta himpulu da ya abuy maphod hidi?” Ya kanan Apu Dios di “Adik dadagon hidiyen boble takon di himpulu da ya abu.” ");
INSERT INTO ifk_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nagibbuh diyen nunhummanganan da ot taynan APU DIOS hi Abraham. Ot umanamut damdamah Abraham hi bale da. ");
INSERT INTO ifk_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mungkahilong kediye ya dimmatong dadiyen duwan anghel ad Sodom. Hi Lot ya um-umbun nah hoob diyen boble ya tinibona dida ot ena dammuwon dida an nunyuung hi punlispitu na. ");
INSERT INTO ifk_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kananay “Iiba, makayu ta ume takuh balemi. Ipaptok dakayun ha-oy ta ulahan yuy hukiyu ya mun-iyan taku. Ta deket hi biggatna ya ahi kayu immeh pangayan yu.” Mu kanan day “Takon di kumpulnay kahuypan mih tu.” ");
INSERT INTO ifk_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mu namahig di pangayag Lot ke dida ot indani ya timbal da ot maki-e dah balena. Indadaanan diday makan ya tinapay an ugge nakammohan hi mumpalbag ot mangan da. ");
INSERT INTO ifk_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kediyen ugge ni-an nahuyop dadiyen bisitan Lot ya linikkub nadan bimmoblen kakat-agu ya nadan aam-amay balen da Lot. ");
INSERT INTO ifk_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ot pun-itkuk dan Lot an kanan day “Ipalah-un mu nadan linalakin bisitam ta ihuyop mi dida.” ");
INSERT INTO ifk_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Limmah-un hi Lot ot inay-unan indakkig nan panto. ");
INSERT INTO ifk_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ot kanana nadah tataguy “Dakayun iibba, adiyu bo anhan iathina. ");
INSERT INTO ifk_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Takon kattog di nan duwan imbabalek an binabain ugge ni-an nangahaway ipalah-un kut nangamung di pinhod yun aton ke dida. Ta bokon hantudan bisitak te mahapul an ipaptok ku dida.” ");
INSERT INTO ifk_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mu kanan day “He-a ke boppon immalin makibobleh tu ya makaan kah na ya bokon he-ay manuttudun dakami. Loktat ya he-ay pangimal-iyan mi ya nahalhalman mo udot di aton min he-a!” Intulud dah Lot ta eda ot pa-iyon nan panto, ");
INSERT INTO ifk_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","mu ingguyud nadan duwan tataguh Lot hi bohongna ot idakig da nan panto ");
INSERT INTO ifk_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ot kulapon da nadan tatagun wadad dola, ta adida pakaptok nah panto. ");
INSERT INTO ifk_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kanan nadan duwan lalaki ke Lot di “Kon wadaday udum hi imbabalem, inapum weno tutulang mun wada tuh boble? Deket wada ya kalyom ke didat makaan kayuh tu ");
INSERT INTO ifk_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","te dadagon mih tuwen boble. Inilan APU DIOS an namahig an gaga-ihoy atoaton di tataguh tu, kinali intud-ak dakamin e manadag ketuwen boble.” ");
INSERT INTO ifk_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ot e kalyon Lot nadah linalakin mangiine nah duwan imbabalenan kananay “Gal-an yu ot ta makaan takuh tu te dadagon APU DIOS hituwen boble.” Mu uggeda naki-e te pangali da pe on langlangkak na. ");
INSERT INTO ifk_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kediyen mungkabigat ya pumbangun nan duwan anghel hi Lot an kanan day “Bumangun ka ot ta awitom nan inayam ya nan duwan imbabalem ta tumayan kayuh tu ta adi kayu milagat hi kadadagan tuwen boble.” ");
INSERT INTO ifk_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mu munhalinduwah Lot an tumayan. Mu himmok APU DIOS dida ot podnon nadan duwan anghel di taklen Lot, nan inayana ya nadan imbabalena ot ipangulu da dida inggana bimmuddu da kediyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ya kanan nan ohan anghel ke diday “Galgal-an yun bumtik dih bilid! Adiyu iwingi nah boblen tinaynan yu. Ya adi kayu mundag-un dih nundotal ta adi kayu milagat nah kadadagan datuwen boble.” ");
INSERT INTO ifk_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Ot kanan Lot di “Maphod anhan ta himmok dakami ot inihwang dakami, mu bokon nah bilid di eyu kanan hi butikan mi te nidawwi ya kal-ina ya adi kami dumatong ya maakhupan kami ta milagat kami. ");
INSERT INTO ifk_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Daan mot hidiyen it-ittay an bobley butikan mi tedeyan nihnih-up ta siguladun mihwang kami. Takombo ot deyan it-ittay hidiyen boble.” ");
INSERT INTO ifk_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ot kanan nan anghel di “Takombo moy hidiy pangayan yu, adimi pakidadag hidiyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Gal-an yu! Butikon yun umeh di! Adimi ni-an dadagon tun boble inggana dumatong kayuh di.” Nipalpun diye ya Soar di ngadan diyen boble an hay kibalinana ya ittay. ");
INSERT INTO ifk_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Handih dimmatong da Lot hidid Soar ya timmimil di algo. ");
INSERT INTO ifk_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kal-ina di ya pun-ogan APU DIOS di mundadalang an sulfur ya apuy hidid Sodom ya ad Gomorrah. ");
INSERT INTO ifk_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ot mapa-i dadiyen boble, takon nadan boblen nungkipaldang ya am-in di matagu, nadan tatagu, aaggayam ya nadan nungkitanom. ");
INSERT INTO ifk_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Hana ken inayan Lot ya nunwingi ot mumbalin an kimmulhin ahin. ");
INSERT INTO ifk_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mungkabigat kediye ya immeh Abraham nah timmaddogan dan APU DIOS handih nunhummanganan da ");
INSERT INTO ifk_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ot mun-uhdung ad Sodom ya Gomorrah ya namahig an ahuk am-in di matibo. ");
INSERT INTO ifk_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mu ninomnom Apu Dios hi Abraham ot homkonah Lot ot ugge nilagat handih nanadagana ke dadiyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Hi Lot ya nadan duwan binabain imbabalena ya tumakut dan miha-ad ad Soar ot eda miha-ad hi ohan liyang nah bilid. ");
INSERT INTO ifk_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ohan algo ya kanan nan panguluwan nah ibanay “Hi ama ya naam-ama ya maid di udum hi lalakin mangiinen dita ta mawaday imbabale ta. ");
INSERT INTO ifk_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Butongon tah amata ta ihuyop ta, ta waday innun tan mahlag ta adi mapoppog di holag taku.” ");
INSERT INTO ifk_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kediyen hilong ya binutong dah amada ot ihuyop nan panguluwan. Mu ugge inilan amada te nabutong. ");
INSERT INTO ifk_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nabigat ot kanan nan panguluwan nah ibanay “Dih hilong ya inhuyop kuh ama. Butongon ta boh ama ta ihuyop mu po ta waday innun tan mahlag.” ");
INSERT INTO ifk_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Binutong da boh amada kediyen hilong ot makihuyop damdama nan nihaynod ke hiya. Mu ugge bo inilan amada te nabutong. ");
INSERT INTO ifk_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hituwey inat nadan duwan imbabalen Lot ot mawadaan da. ");
INSERT INTO ifk_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Hanan panguluwan an imbabalen Lot ya nun-imbabaleh lalaki ot ngadananah Moab. Hiyay nahlagan nadan iMoab ad uwani. ");
INSERT INTO ifk_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Hanan nihaynod an imbabalen Lot ya nun-imbabale boh lalaki ot ngadananah Ben-Ammi. Hiyay nahlagan nadan iAmmon ad uwani. ");
INSERT INTO ifk_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Indani ya ninomnom Abraham an taynan ad Mamre ot ume dad Negeb an numbattanan di Kades ya Sur. Indani ya eda bo niha-ad ad Gerar. ");
INSERT INTO ifk_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ot handih wadadah di ya kanana nadah tataguh diy tulang nah Sarah. Kinali nan patul an hi Abimelek ya impaayag nah Sarah ta iinena. ");
INSERT INTO ifk_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ohan hilong ya nun-in-inop hi Abimelek an kanan Apu Dios ke hiyay “He-a ya mate ka te hinaen babain em impaawit ya waday inayana.” ");
INSERT INTO ifk_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mu hi Abimelek ya uggena inhuyop hi Sarah ot kananay “Apu, kon patayon dakamin nadah tataguk yaden maid di ad-adih inat kun hiya? ");
INSERT INTO ifk_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hi Abraham ya kananay tulang na ya athidi bon nah babai an kananay hintulang da. Kinali uggek inilan gaga-ihoy inat ku.” ");
INSERT INTO ifk_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kanan Apu Dios ke hiyay “Om, inilak an uggem ninomnom an aton di gaga-iho, kinali uggek in-abulut an ihuyop mu ta adika mumbahul ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kinali mahapul an ibangngad muh naen babai nah inayana. Hanan inayana ya idasalan dakat adika mate te hiya ya profetas. Te deket adim ibangngad ya mate kayun am-in hanadah tatagum.” ");
INSERT INTO ifk_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mungkabigat kediye ot ipaayag Abimelek am-in nadan opisyal na ot kalyonan diday mipanggep nah inin-inop na ya namahig di takut da. ");
INSERT INTO ifk_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Impaayag nah Abraham ot kananan hiyay “Nganneh tuwen inat mu ke dakami? Nganney bahul kun he-a ta edakami idatan hi kadadagan mi? Adina lebbeng an e maat hituwen ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Tipet em inat di athitu?” ");
INSERT INTO ifk_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ya kanan Abraham di “Man-uket inat kuh nae ya kanak on maid di mangulug ke Apu Dios hitu ta kalina ya patayonak ta pulhon da tun inayak. ");
INSERT INTO ifk_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Om, himbale kami, mu hi kakulugana ya hintulang kami te hiya ya imbintan ama. ");
INSERT INTO ifk_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Handih kanan Apu Dios di tayanak nan numboblayan min da ama ya kanak ke Sarah di ‘Takon di daanay pangayan mi ya kalyonah tatagu an hintulang kami. Hidiyey pangipatibonah pamhod nan ha-on ya kiphodak hidiye.’” ");
INSERT INTO ifk_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ot ibangngad mon Abimelek hi Sarah ot idatanah Abraham hi kalnero ya baka ya muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ot kanana bon Abraham di “Damanan mamili kah pinhod mun kiha-adan tuh boblen pun-ap-apuwak.” ");
INSERT INTO ifk_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ot kanana bon Sarah di “Idat kun tulang mu tun hinlibun kalang ta kitib-anan maid di bahul mu. Ya hituwey panginilaan nadan iibbam an maid di ad-adih inat mu.” ");
INSERT INTO ifk_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ot idasal Abraham ke Apu Dios ta paphodona nan patul, nan inayana ya am-in nadan binabain wadah nunhituwanat damana mon mawaday imbabale da. ");
INSERT INTO ifk_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Te ugge ni-an inabulut APU DIOS an eda mawadaan hi imbabale an hidiyey kastigun Abimelek hi ena nangal-an ke Sarah an inayan Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Indani ya impaannung APU DIOS nan kinalinan Sarah handi. ");
INSERT INTO ifk_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ot mawadaan handih am-ama moh Abraham. Intungona nan golang handih nadatngan nan gintud Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","5","Ot ngadanan Abraham hidiyen imbabale da hi Isaac. Hay toon mon Abraham kediye ya hinggatut. Ya handih waluy algon Isaac ya kinugit na te hidiyey kinalin Apu Dios an atona. ");
INSERT INTO ifk_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Immamlong hi Sarah an kananay “Indatanak ke Apu Dios hi pun-an-anlaak ya inilak ot am-in di mangngol ketuwen nun-imbabaleyak ya makian-anla dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Te takon di dahdi ya inila dan adiyak pakaimbabale. Mu deyan ad uwani ya nitungo tun lalakin imbabale min Abraham yaden am-ama mo.” ");
INSERT INTO ifk_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Immongngal hi Isaac ot handih naphuwana ya numpahamul hi Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ohan algo ya taltalanggaan Ismael an imbabalen Abraham nah iEgypt an muttatyun hi Hagar hi Isaac an imbabalen da Abraham ke Sarah. ");
INSERT INTO ifk_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tinibon Sarah diye ot kananan Abraham di “Itud-ak mu hanan himbut ya nan imbabalena te adi mabalin an e makibingay nah boltanon tun imbabalek an hi Isaac.” ");
INSERT INTO ifk_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mabulubulun hi Abraham kediye te imbabalena damdamah Ismael. ");
INSERT INTO ifk_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mu kimmalih Apu Dios ke hiya an kananay “Adika madanagan ke Ismael ya hi inanan hi Hagar. Un-unudom di kinalin Sarah te hi Isaac di pangipaannungak nah kinalik ke he-an dumakol di holag mu. ");
INSERT INTO ifk_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hinaen imbabalem nah muttatyu ya idatak hi dakol an holag na te hiya ya imbabalem damdama.” ");
INSERT INTO ifk_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ot mungkabigat kediye ya indadaan Abraham di makan ya danum an ipabalunan da Hagar an hin-ina ot itud-ak na dida. Imme da ot eda humanawwangan nah adi maboblayan ad Beersheba. ");
INSERT INTO ifk_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Indani ya nap-uhan dah danum ot taynan Hagar nan imbabalena nah puun di ka-kaiw. ");
INSERT INTO ifk_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ot e umbun nah e-elena an kananay “Adiyak pakaitulid an mangang-ang hi katayan nan imbabalek.” Ya mungkokkoggan um-umbun. ");
INSERT INTO ifk_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dingngol Apu Dios di kogan nan unga ot indani ya kimmali nan anghel Apu Dios ke Hagar an kananay “Nganney kabulubulunam Hagar? Adika madanagan ot dingngol Apu Dios di kogan nan imbabalem. ");
INSERT INTO ifk_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tumaddog ka ot ta em awiton ya inal-aluk mu. Ahik pumbalinon an aman di dakol an tataguh udum hi algo.” ");
INSERT INTO ifk_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Indani ya kay diniyat Apu Dios di matan Hagar ya tinibona on bubun ot humagob hi ena painum nah imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Impappaptok Apu Dios nan unga nah kiha-ha-adan da nah adi maboblayan ad Paran. Hidiy immongngalana an numbalin hi nakala-ing an mun-anup. E inhamakan inanah kaboblayanan iEgypt ot ipaahawanan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Handih immayan da Abimelek ya nan ap-apun di tindalunan hi Pikol hi kad-an Abraham ya kanan Abimelek ke hiyay “Inilak an badbaddangan dakan Apu Dios am-in nah atom. ");
INSERT INTO ifk_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ta hituwe nan makihummanganak ke he-at isapatam ke Apu Dios an adika makibuhul ke ha-on, nadah imbabalek ya inap-apuk, mu makigayyum kan dakami umat hi pangat kun he-a tuh boble min nakiboblayam.” ");
INSERT INTO ifk_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ya kanan Abraham di “Om, isapatak ke Apu Dios an athinay maat.” ");
INSERT INTO ifk_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ot ne mundiklamu poh Abraham ke Abimelek mipanggep nah bubun an pinlon nadan muttatyun Abimelek. ");
INSERT INTO ifk_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kanan Abimelek di “Uggek inilah naen naat ya uggek inila hin dahdiy nangat. Tipet uggem kinali handi?” ");
INSERT INTO ifk_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Indattan Abraham hi Abimelek hi kalnero ya baka an kitib-an di nahamad an punggayyuman da. ");
INSERT INTO ifk_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Immappil boh Abraham hi pitun impan di kalnero. ");
INSERT INTO ifk_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ya kanan Abimelek di “Tipe nae?” ");
INSERT INTO ifk_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ya kanan Abraham di “Alam datuwe ta kitib-anan abulutom an ha-oy di nanga-ut tuh bubun.” ");
INSERT INTO ifk_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ot ngadanan dah diyen boble hi Beersheba te hidiy naatan nan hummangan da. ");
INSERT INTO ifk_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Nagibbuh diyen hummangan da ot mibangngad da Abimelek ke Pikol ad Pilistia. ");
INSERT INTO ifk_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Intanom Abraham on kaiw an tamarisk hidid Beersheba ot dayawonah dih APU DIOS an wadat nangamung. ");
INSERT INTO ifk_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ot hidid Pilistia di numboblayan da Abraham hi nabayag. ");
INSERT INTO ifk_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ohan algo ya pinatnaan Apu Dios hi Abraham. Kimmali ke hiya an kananay “Abraham.” Himmumang hi Abraham an kananay “Om, Apu.” ");
INSERT INTO ifk_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ya kanan Apu Dios di “Awitom nan binugtung an imbabalem an hi Isaac an impakappinhod mu ta ume kayud Moriah ta iappit mun ha-on nah bilid an ahik ituddu.” ");
INSERT INTO ifk_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ot mungkabigat hi nabigatana ya dimmikhal hi Abraham hi kaiw an usalon da nah eda pun-appitan. Indadaana nan kabayu an pangitakkayanah karga da ot awitonah Isaac ya hay duwan muttatyuna ot ume da nah intuddun Apu Dios an pangayan da. ");
INSERT INTO ifk_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Handih mikatlun algo ya tinibon Abraham nan pangayan da. ");
INSERT INTO ifk_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kanana nadah muttatyu nay “Mihtu kayuh tu takon tun kabayu ta madagga kamin hin-ama ta ekami mundayaw ke Apu Dios ne ahi kami nibangngad.” ");
INSERT INTO ifk_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Impipah-on Abraham ke Isaac nan itungu ot hiyay mangdon nah uwa ya nan pun-apuy da. Handih mange da ");
INSERT INTO ifk_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ya kanan Isaac di “Ama, tipet man-ut waday pun-apuy ya kaiw, mu daan nan kalneron miappit?” ");
INSERT INTO ifk_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kanan Abraham di “Nangamung hi Apu Dios.” Ot ituluy dan mange. ");
INSERT INTO ifk_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Dimmatong da nah kinalin Apu Dios ot iphod Abraham nan pun-appitan an iniphod nan nun-uuhhunon nadan kaiw. Binobodanah Isaac ot ihakmo na nah kaiw nah pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inukat na nan uwa ta ena ot patayon nan imbabalenat iappit nan APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","mu kimmali nan anghel APU DIOS ad kabunyan an kananay “Abraham!” Kanan Abraham di “Om, Apu!” ");
INSERT INTO ifk_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kanan nan anghel di “Adim patayon nan unga! Inilak mon paka-un-unudom hi Apu Dios te uggem kinawwanan nan ohan imbabalem.” ");
INSERT INTO ifk_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Indani ya inang-ang Abraham nah e-elena on kalneron nihab-ut di hakgud nah ka-kaiw. Ot ena alan ot hidiyey iappit na an bokon mo nan imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ta hay nungngadan Abraham kediyen lugal ya “Hi APU DIOS di umidat hi mahapul.” Ot ingganad uwani ya hidiyey pungngadan di tatagu kediyen bilid. ");
INSERT INTO ifk_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kanan bon nan anghel APU DIOS ke Abraham di ");
INSERT INTO ifk_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ha-oy an APU DIOS ya isapatak hi ngadan ku an gapuh uggem nangawwanan nah binugtung an imbabalem an em ot iappit ke ha-on ");
INSERT INTO ifk_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ya ongal di bendisyon kun he-a ta idattan dakah dakol an holag mu umat hi kadakol di bittuwon hi kabunyan ya lona nah pingngit di baybay. Ya apputon dan am-in di makibuhul ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ya gapun dida ya bendisyonak am-in di tataguh kabobboble tuh luta te inun-unudak ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ot mibangngad da Abraham nah nunhoodan nadan muttatyuna ot umanamut dan am-in ad Beersheba. ");
INSERT INTO ifk_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Indani ya dingngol Abraham an walu day linalakin imbabalen tulang nan hi Nahor nah inayanan hi Milkah. Hay panguluwan ya hi Us ot ahih Bus, hi Kemuel an hi aman Aram, hi Kesed, hi Haso, hi Pildas, hi Jidlap, ot ahi nan udidiyan an hi Bethuel an kon imbabalen Rebekah. ");
INSERT INTO ifk_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wadada boy udum an imbabalen Nahor hi ohan babai an hi Reumah. Hay ngadan da ya hi Tebah, hi Gaham, hi Tahas ya hi Maakah. ");
INSERT INTO ifk_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Hi Sarah ya hinggatut ta duway pulut pituy toona ");
INSERT INTO ifk_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ot ahi mate nah numboblayan dad Hebron hidid Kanaan. Ot ibaluwan Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Immeh kad-an nadan Hittite ot kananan diday ");
INSERT INTO ifk_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ha-oy ya bokonak ihitu ta deyan maid di ek pangilubukan nah inayak. Deket damana ya umigattang kayun ha-on hi luta yu ta pangilubukak ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Ya kanan day “Dakami ya ibilang dakan ohan nakattag-en ap-apu. Kinali damanan ituddum di pinhod mu tuh boble mih pangilubukam nah inayam ta idat mi.” ");
INSERT INTO ifk_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ot munyuung hi Abraham hi pangipatibonah lispitunan dida ");
INSERT INTO ifk_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ot kananay “Athina ken iabulut yun ilubuk kuh tu nan inayak ya eyu ibaga ke Eplon an imbabalen Sohar ");
INSERT INTO ifk_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ta igattang nan ha-on nan liyang ad Makpelah an paldang di payona. Mahmahan yu hin kaatnay pangigattang na ta bayadak an wada kayun manibo ta pumbalinok an gungat di pamilyak.” ");
INSERT INTO ifk_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hi Eplon ya wadah din makibkib-un hanadah tatagun naamung nah hoob ");
INSERT INTO ifk_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ot kananay “Apu, idat kun he-ah diyen liyang ta em pangilubukan nah inayam ya pakidat ku pay nan payok. Ot deyan dingngol tudan iibbak an idat kun he-ah diye.” ");
INSERT INTO ifk_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nunyuung boh Abraham hanadah Hittite ");
INSERT INTO ifk_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ot kananan Eplon di “Iabulut mu ot ya abun gatangok ta ahik pangilubukak nah inayak, bayadak hi ustu.” Hidiyen kinalina ya dingngol nadan tatagu an naamung hidi. ");
INSERT INTO ifk_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kanan Eplon di ");
INSERT INTO ifk_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Apu, hay balol diyen payo ya opat di gatut an kalang. Mu takombo. Em ot ilubuk hidi nan inayam.” ");
INSERT INTO ifk_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Inabulut Abraham hidiyen kinalin Eplon ot ipadngol na nadah Hittite an binilang di opat an gatut an kalang an pamayad na nah lutan in-ingngo nah pangigattang nadan mumpunggattang. ");
INSERT INTO ifk_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ot hidiyen lutan Eplon ad Makpelah an nih-up ad Mamre an payo ya liyang ya waday kakaiw ya numbalin mon lutan Abraham te ginatang na. ");
INSERT INTO ifk_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Am-in da nan Hittite an wadah din nanibo ya inila dan hi Abraham moy kon lutan diye. ");
INSERT INTO ifk_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ot ena mo ilubuk nan inayanan hi Sarah kediyen liyang ad Makpelah hidid Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hidiyen lutan nan Hittite ya lutan mon Abraham ot pumbalinonah gungat di pamilyana. ");
INSERT INTO ifk_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Naka-am-ama moh Abraham ya binendisyonan APU DIOS am-in di inainat na. ");
INSERT INTO ifk_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ohan algo ya kanana nah muttatyun nangidinolanan am-in hi wadan hiyay “Ihakmom di taklem tuh ulpuk ");
INSERT INTO ifk_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ta munsapata ka. Isapatam ke APU DIOS an Dios hi kabunyan ya luta an bokon hitud Kanaan di pumpiliyam hi iinen tun imbabalek an hi Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mahapul an ume ka nah boblen nitungowak ta nan imbabalen tulang kuy em pumpiliyan hi iinena.” ");
INSERT INTO ifk_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mu kanan nan muttatyuy “Nungay ta waday hamakok, mu adina pinhod an maki-ali, kon mabalin an mibangngadak ta awitok hi Isaac ta iek hidi?” ");
INSERT INTO ifk_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ya kanan Abraham di “Adi mabalin! Tibom ot ta adim ieh di nan imbabalek. ");
INSERT INTO ifk_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hi APU DIOS an Dios hi langit di nangali an tayanak hidiyen boble min da ama ya nan tutulang ku. Ot hammadonan kalyon ke ha-on an hituwen lutay ipaboltanan ha-on ya nadah holag ku. Ya pamanguluwonay anghel na nah pangayam ta waday awitom hi iinen tun imbabalek. ");
INSERT INTO ifk_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mu kal-ina ket adi pinhod nan babain maki-ali ke he-a ya ilamangam ot kattog. Malibli ka tuh insapatam. Mu mahapul an takon di nganney maat ya adim ie tun imbabalek hidi.” ");
INSERT INTO ifk_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ot ihakmon nan muttatyuy takle nah ulpun Abraham ot isapatanan un-unudonay kinalin Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ot pakialan tuwen muttatyuy himpulun kamel an impungkargana nadah mungkaphod an ena idat ot umed Mesopotamia an boblen Nahor. ");
INSERT INTO ifk_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Dimmatong hidi ya tinibona on bubun ot pun-iyatuwona nadan kamel nah e-elena. Himbatangan an kediyey humagoban nadan binabaih di. ");
INSERT INTO ifk_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ya nundasal an kananay “APU DIOS an dayawon Abraham an kon muttatyun ha-oy, ipatibom anhan di ulem ke hiya ta adi mibahho nan ena ipaat ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Dehtuwak tuh bubun an umaliyan nadan binabai ketuwen boble an humagob. ");
INSERT INTO ifk_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ahik kalyon hanadah binabaiy ‘Umidat ka anhan hi inumok’ ta deket painumanak ya painumana bo nadan kamel, ya hana ot ta hidiyey piliyom an iinen nan muttatyum an hi Isaac. Deket maat di athidi ya hidiyey panginilaak an impaannung muy kinalim nah kon muttatyun ha-oy.” ");
INSERT INTO ifk_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Uggena ginibbuh diyen dasal na ya dimmatong hi Rebekah an e humagob. Hituwey imbabalen Bethuel an imbabalen nan tulang Abraham an hi Nahor an inayan Milkah. ");
INSERT INTO ifk_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Hi Rebekah ya maddikit an babai an ugge nalahin. Immen nah bubun ot e humagob ot mungkibangngad ");
INSERT INTO ifk_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ya e dinammun nan muttatyu ot kananay “Umidat ka anhan hi inumok.” ");
INSERT INTO ifk_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ya kanan nan babaiy “Om, apu, damana.” Ot lokahona nan hinagob na. ");
INSERT INTO ifk_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nagibbun imminum ya kanan bon Rebekah di “Agat ek pay painuman nadan kamel mu.” ");
INSERT INTO ifk_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ot mumbinangngad an e himmagob hi impainum na inggana nainuman am-in nadan kamel. ");
INSERT INTO ifk_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Hanan muttatyu ya op-opya an tibtibbona hin hiyay ituddun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kediyen ginibbun Rebekah an pinainuman nadan kamel ya inukat nan muttatyu nan balituk an hingat ot ipahingat nan hiya. Inukat na bo nan duwan balituk an takkalang ot ipahuklub nah taklena. ");
INSERT INTO ifk_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kanan nan muttatyu ke hiyay “Dahdiy kon imbabalen he-a? An damanan waday kahuyopan hi baleyu ta mun-iyan kami ke datuwen iibbak?” ");
INSERT INTO ifk_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ot kalyon Rebekah di “Imbabaleyak ke Bethuel an imbabalen da Nahor ke Milkah. ");
INSERT INTO ifk_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Damanan waday kahuyopan yu ya deyyah diy kanon hantudan kamel.” ");
INSERT INTO ifk_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hanan muttatyu ya nundukkun ot dayawonah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ot kananay “Madayaw ka APU DIOS an Dios Abraham an kon muttatyun ha-oy te maule ka nah ap-apuk ya ongal di baddang mun hiya. Ta hidiye nan impanguluwak hi kad-an tudan tutulang nan kon muttatyun ha-oy.” ");
INSERT INTO ifk_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Bintik Rebekah an immeh baleda ot kalyonan inanah diyen naat. ");
INSERT INTO ifk_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Hi Laban an lalakin tulang Rebekah ya tinibona nan hingat ya nadan takkalang na ya dingngol na nan pungkalina ot butikonan imme nah bubun ya muntattaddog nan muttatyuh kad-an nadan kamel na. ");
INSERT INTO ifk_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ot kananan hiyay “Ume tah balemi! Binendisyonan dakan APU DIOS! Waday indadaan kuh kiha-adan yu ya hantudan kamel mu.” ");
INSERT INTO ifk_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ot maki-e da. Impaptok Laban nadan karga ot ahina panganon nadan kamel. In-ap-ap nay dagamin nah allung an kiha-adan nadan kamel. Ya immie boh danum hi pangulan nadan muttatyun Abraham hi hukida. ");
INSERT INTO ifk_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Handih nidadaan di kanon da ya kanan nan muttatyuy “Adiyak ni-an mangan ingganay kalyok di gapunah immaliyak hitu.” Kanan Laban di “Ot takon, agam kalyom.” ");
INSERT INTO ifk_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kananay “Ha-on nan muttatyun Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Hi APU DIOS ya ongal di bendisyona ke hiya ot kumadangyan. Dakol di kalnerona, bakana, kamel na ya kabayuna. Ya dakol boy pihhuna, balituk na ya muttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hi Sarah an inayana ya in-ina ot ahi mawada nan ohan imbabale dan lalaki an hiyay nangipaboltanan Abraham am-in hi kinadangyana. ");
INSERT INTO ifk_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Impunsapataak ke Abraham an bokon nadan binabaih did Kanaan di pumpiliyak hi iinen nan imbabalena an hi Isaac, ");
INSERT INTO ifk_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mu mumpiliyak kanu ke dakayun iibanah tu. ");
INSERT INTO ifk_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ot kanak di ‘Nganney atok hin adi pinhod nan babain maki-alin ha-on hi kibangngadak?’ ");
INSERT INTO ifk_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kananay ‘Maki-ali te hi APU DIOS an nanongnan un-unudok ya paki-ayonay anghel nan bumaddang ke he-at awitom nan iinen tun imbabalek an malpuh iibak hi appit ama. ");
INSERT INTO ifk_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Atom hinaen kinalik ta deke kattog ta adida abuluton ne nganney innun muden ta inat mu nan insapatam ke ha-on.’ ");
INSERT INTO ifk_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kinali handih dimmatongak nah bubun ya nundasalak an kanak di ‘He-a APU DIOS an dayawon nan kon muttatyun ha-oy, baddanganak anhan ta adi mibahho nan gapunah immaliyak hitu. ");
INSERT INTO ifk_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Deket waday kat-agun babain umalin humagob ya ibagak an idatanak hi inumok. ");
INSERT INTO ifk_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ta deket ipainumanak ya nadan kamel ku ya hidiyey panginilaak an hiyah diye nan pinhod mun iinen nan imbabalen nan kon muttatyun ha-oy.’ ");
INSERT INTO ifk_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Uggek ginibbu nan dasal ku ya mangalih Rebekah an e humagob. Nagibbun himmagob ot kanak ke hiyay ‘Uminumak anhan nah hinagob mu.’ ");
INSERT INTO ifk_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ya lingkana nan hinagob na ot kananay ‘Teya, uminum kat ahik e painuman nadan kamel mu.’ Ot uminumak ot ahina painuman nadan kamel ku. ");
INSERT INTO ifk_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ot hanhanak di ngadan amana ya kananay ‘Hi Bethuel an imbabalen da Nahor ke Milkah.’ Ot ipahingat ku mo nan balituk ya impahuklub ku bo nadan balituk an takkalang hi taklena. ");
INSERT INTO ifk_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nundukkunak ot dayawok nan AP-APU an Dios nan ap-apuk an hi Abraham hi nangipanguluwanan ha-on hi kad-an yun iibana ot potkok nan iinen nan imbabalen Abraham an kon muttatyun ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kinali pinhod kun kalyon yu hin pinhod yun makiapu nah kon muttatyun ha-oy weno adi ta inilaok hin nganney atok.” ");
INSERT INTO ifk_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ya kanan da Laban ke Bethuel di “Deyan nainila an athinay pinhod APU DIOS ya dahdi kamin e mangalih pinhod mi? ");
INSERT INTO ifk_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Takon, awitom hi Rebekah ta iinen nan imbabalen nan kon muttatyun he-a te hidiyey pinhod APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Dingngol nan muttatyuh diyen kinali dan hiya ya nundukkun ot dayawonah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ot ukatona nadan intabinan gamgam an balituk ya silber ya nadan makakkaphod an bulwati ot idat nan Rebekah. Indatana damdamah tulang Rebekah an hi Laban ya hi inada nadah udum an nabalol an intabina. ");
INSERT INTO ifk_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ot ahida uppe mangan an didan am-in hanadah ibbana ot mun-iyan da. Nabigat ot bumangun da ot kanan nan muttatyuy “Agat ume kami.” ");
INSERT INTO ifk_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mu kanan Laban ya hi inanay “Indanit mala-u ni-moy himpulun algoh kiha-adan Rebekah tu ta ahi dakami taynan.” ");
INSERT INTO ifk_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mu kanan nan muttatyuy “Adiyu anhan e taktakon di kibangngadak ot deyan maphod ta binaddanganak ke APU DIOS ta ugge nibahhoy immaliyak hitu.” ");
INSERT INTO ifk_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kanan day “Indanit mot ayagan takuh Rebekah hin nganney kanana.” ");
INSERT INTO ifk_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ot kanan dan Rebekah di “Kon pinhod mun maki-e ketuwen tagu?” Ya kanan Rebekah di “Om, pinhod kun maki-e.” ");
INSERT INTO ifk_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ot iabulut da mon maki-eh Rebekah nadah muttatyun Abraham. Ya impaki-e da bon Rebekah nan muttatyun nangipaptok ke hiya nipalpuh kagolang na. ");
INSERT INTO ifk_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Binendisyonan dah Rebekah an kanan day “Hana ot ta mumbalin kah inan di dakol an tatagu. Ya nadan holag muh udum hi algo ya ahida apputon nadan makibuhul ke dida.” ");
INSERT INTO ifk_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nagibbu ot e mitakke da Rebekah ya nadan muttatyuna nadah kamel nan muttatyun Abraham ot ume da. ");
INSERT INTO ifk_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hi ke Isaac ya numbobled Beer Lahai Roi ad Negeb. ");
INSERT INTO ifk_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","E nundaldallanan hi mungkahilong ya tinibona on kakamel an mangali. ");
INSERT INTO ifk_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tinibon Rebekah Isaac ot marka nah kamel na. ");
INSERT INTO ifk_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Hinanhanana nah muttatyun kananay “Dahdih diyen tagun mangalin manamun ditaku?” Kanan nan muttatyuy “Hidiye nan imbabalen nan kon muttatyun ha-oy.” Ot munhukyung hi Rebekah. ");
INSERT INTO ifk_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Handih dimmatong nan muttatyu ya kinalinan am-in ke Isaac di na-na-at. ");
INSERT INTO ifk_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inawit Isaac hi Rebekah ot eda mihaad nah abung inanan hi Sarah ot munhimbale da. Impakappinhod Isaac hi Rebekah ya hiyay naal-alubyagana hi natayan inana. ");
INSERT INTO ifk_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Hi Abraham ya numbintan ke Keturah ");
INSERT INTO ifk_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ot mawadah Simran, hi Joksan, hi Medan, hi Midian, hi Isbak ya hi Suah. ");
INSERT INTO ifk_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Nahlag hi Joksan ot da Seba ke Dedan. Ot muntanud hi Dedan ot nadan Assurim, Letushim ya Leummim. ");
INSERT INTO ifk_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Nahlag hi Midian ot da Ephah, hi Epher, hi Hanok, hi Abida ya hi Eldaah. Datuwen am-in di holag Keturah. ");
INSERT INTO ifk_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Hay nangipaboltanan Abraham am-in hi wadan hiya ya hi Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mu wada damdamay indat na nadah udum an imbabalena nadah udum an inayana. Ot ahina itud-ak didan e mumboble nah nangappit hi timilan di algo ta midawwi dan Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Hay toon Abraham ya hinggatut ta napitut lima an naka-am-ama ot ahi mate ot e mid-um hanadah aammod nan nungkakate. ");
INSERT INTO ifk_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ot e ilubuk nadan imbabalenan hi Ismael ya hi Isaac nah ginatang Abraham ke Eplon an imbabalen nan Hittite an hi Sohar an liyang an nilubukan Sarah nah paldang nan payo ad Makpelah an nih-up ad Mamre. ");
INSERT INTO ifk_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Hi Isaac an imbabalen Abraham ya binendisyonan Apu Dios. Hay numboblayana ya ad Beer Lahai Roi. ");
INSERT INTO ifk_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hi Ismael an imbabalen Abraham ke Hagar an iEgypt an muttatyun Sarah ya nahlag. ");
INSERT INTO ifk_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ot datuwey nunhahaynod an imbabalena, hi Nebayot an panguluwan, hi Kedar, hi Adbeel, hi Mibsam, ");
INSERT INTO ifk_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","hi Misma, hi Dumah, hi Massa, ");
INSERT INTO ifk_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","hi Hadad, hi Tema, hi Jetur, hi Naphis ya hi Kedemah an udidiyan. ");
INSERT INTO ifk_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Datuwen himpulut duwan imbabalen Ismael ya nip-ong dan nun-ap-apu nadah himpulut duwan boblen niha-adan da an ningadanan di ngadan da. ");
INSERT INTO ifk_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hay bilang di toon Ismael ya hinggatut ta tulumpulut pitu ot ahi mate. ");
INSERT INTO ifk_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hay numboblayan nadan holag na ya nah numbattanan di Habilah ya Sur an nih-up nah poppog di Egypt nah nangappit hi timilan di algon dalanon an umed Assyria an naappil da nadah udum an imbabalen Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hituwey na-na-at ke Isaac an imbabalen Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Hi Isaac ya nap-at di toona handih nun-adduman dan Rebekah an tulang Laban an dida nan imbabalen Bethuel an iAramea ad Mesopotamya. ");
INSERT INTO ifk_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Dumasadasal ke APU DIOS te adi pakaimbabaleh Rebekah ot indani ya dingngol APU DIOS di dasal na ot mawadaan hi Rebekah. ");
INSERT INTO ifk_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hanan imbutyug Rebekah ya nundappil ta kay da bumanultung hi putuna. Ot mundasal ke APU DIOS an kananay “Tipet athituy ma-ma-at ke ha-on?” ");
INSERT INTO ifk_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ya kanan APU DIOS ke hiyay “Hanan imbutyug mu an nundappil ya ahi mun-appil di holag dan mumboble. Hanan oha ya makodkodhol mu nan ibana. Ya nan mamangulu ya hiyay ahi pummuttatyun nan mihaynod.” ");
INSERT INTO ifk_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Handih nuntungoh Rebekah ya makulug an duwan linalaki. ");
INSERT INTO ifk_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Hanan namangulun bimmuddal ya ma-maingit ya nakabu-ukkan di adol na, kinali nginadanan dah Esau. ");
INSERT INTO ifk_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nitun-ud nan mikadwa ya inhamad nan inid-on hi mukud Esau ot ngadanan dah Jacob. Hi Isaac ya nan-om di toona handih nitungo datuwen imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Handih kimmat-agu da ya nalaing hi Esau an mun-anup ta nah muyung di imminghah pangapangayana. Hi ke Jacob ya hi nunhituwan day kiha-ha-adana. ");
INSERT INTO ifk_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Hi Isaac ya pinpinhod nah Esau te gapu nah anuponan oggana ihda. Mu hi Rebekah ya hi Jacob di pinpinhod na. ");
INSERT INTO ifk_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ohan algon munha-ha-ang hi Jacob hi ihda ya dimmatong hi Esau an nalpuh muyung an nakaaggangan. ");
INSERT INTO ifk_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kananan Jacob di “Iyalim aga nan ma-maingit an inha-ang mun ihda ta kanok te deh tun nakaagganganak.” Ot ngadanan dah Esau hi Edom. (Hay kibalinan di Edom ya maingit.) ");
INSERT INTO ifk_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kanan Jacob ke hiyay “Damana, mu mahapul an idat mu nan kalebbengam an panguluwan.” ");
INSERT INTO ifk_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kanan Esau di “Takombo, nganney pangiatak nah kalebbengak yaden dehtun mateyak hi inagang ku.” ");
INSERT INTO ifk_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ot kanan Jacob di “Mahapul an isapatam an idat mun ha-oy nan kalebbengam ta ahik idat.” Ot isapatan Esau an idat nan Jacob nan kalebbenganan panguluwan. ");
INSERT INTO ifk_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ot idat nuppen Jacob nan kanona. Nabhug ot ipayu na bon mange. Kediye ya impatibon Esau an adina ibilang nan kalebbenganan panguluwan. ");
INSERT INTO ifk_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Indani ya wada boy bitil kediyen boble an hinnatkon pe tuwali nan bitil handih katagun Abraham. Ot ume da Isaac ad Gerar nah boblen nan patul di Pilistia an hi Abimelek. ");
INSERT INTO ifk_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Numpatiboh APU DIOS ke Isaac ot kananan hiyay “Adi kayu madaggad Egypt, mu munnanong kayu nah itudduk an kiha-adan yu. ");
INSERT INTO ifk_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Un-unudom ta mihtu kayu ot wadaak ta nangamung an mangipaptok ke he-a ya bendisyonan daka. Idat kun he-a ya nadan holag mun am-in hituwen boble an hidiye din insapatak handi ke amam an hi Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Idatan dakah dakol an holag mu umat hi kadakol nadan bittuwon hi kabunyan an adi mabilang. Ya diday pangidatak am-in datuwen luta. Ya gapun dida ya bendisyonak am-in di tatagu tuh luta. ");
INSERT INTO ifk_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Man-uket athidiy atok ya inun-unud Abraham am-in di tugun ku.” ");
INSERT INTO ifk_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ot hidi mod Gerar di numboblayan da Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Deket minahmahan nadan tataguh di ke Isaac di mipanggep ke Rebekah on kananay hintulang da. Man-uke ya tumakut an kal-ina ya patayon dat alan dah Rebekah te maddikit an babai. ");
INSERT INTO ifk_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mu indani ya waday naminghan an in-uhdung nan patul an hi Abimelek nah tawang na ya tinibona da Isaac ke Rebekah an mun-aw-awwalan da. ");
INSERT INTO ifk_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ot ipaayag Abimelek hi Isaac ot kananan hiyay “Ya- kon himbale kayu yaden kanam di hintulang kayu.” Ya kanan Isaac di “Man-uket kanak di tulang ku ya tumakutak an kal-ina ya patayonak ta alan dah Rebekah.” ");
INSERT INTO ifk_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ot kanan Abimelek di “Tipet athidiy atom ke dakami? Gulat nat wada hantudah linalakih tuy nangihuyop nah inayam ya he-ay humlun hi pumbahulan mi.” ");
INSERT INTO ifk_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ot kalyan Abimelek nadan tatagunan kananay “Hanan tagun mangat hi adi maphod ke da Isaac an himbale ya mipipate.” ");
INSERT INTO ifk_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nunliyak da Isaac hidi ya dakol di inani da an paddungnay naminhinggatut di kadakol na gapuh ongal an baddang APU DIOS ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ot kumadangyan hi Isaac, mu mungkaudman pay di kinadangyana. ");
INSERT INTO ifk_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Dakol di bakana, kalnerona ya muttatyuna. Ta hidiye nan umamo nadan iPilistia. ");
INSERT INTO ifk_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ot eda tababon am-in di bubun an impaka-ut Abraham an aman Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Loktat ya kanan nan patul an hi Abimelek ke Isaac di “Makaan ka tuh boble mi te numbalin ot ya abun ong-ongal di kabaelam mu dakami.” ");
INSERT INTO ifk_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ot makaan mo da Isaac hidi ot eda mumboble nah nundotal an Gerar. ");
INSERT INTO ifk_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ot paka-ut na bo nadah muttatyunan am-in nadan bubun an impaka-ut din hi amanan hi Abraham. Te handih nate ya tinabab nadan iPilistia dadiyen bubun. Impunnanong na nadan ngadan an impungngadan amana ke dadiyen bubun. ");
INSERT INTO ifk_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ot kuma-ut bo nadan muttatyun Isaac hi udum an bubun ya pintok da on waday mun-otbol hi danum hidi. ");
INSERT INTO ifk_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mu indani ya imme nadan mumpumpattol an iGerar ya makiawwit da nadah pumpattolon Isaac te kanan nadan iGerar di danum da kanuh diye. Ot ngadanan mon Isaac hidiyen bubun hi “punhahannuwan.” ");
INSERT INTO ifk_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ot e mo bo mumpaka-ut hi Isaac ya athidi bon nun-aawwitan da. Ot ngadanan bon Isaac hidiyen bubun hi “pun-aawwitan.” ");
INSERT INTO ifk_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Imme-ele da ot mumpaka-ut bo ya maid moy makiawwit ke dida ot ngadana nah diyeh Rehobot an hay kibalinana ya bubun an waday linggop. Ot kanan Isaac di “Ad uwani ya in-abulut APU DIOS an miha-ad takuh tu ta hituy pumhodan di biyag taku.” ");
INSERT INTO ifk_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Indani ya tinaynan da Isaac boh diye ot ume dad Beersheba. ");
INSERT INTO ifk_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kediyen hilong hi dimmatongan da ya numpatiboh APU DIOS ke hiya an kananay “Ha-on nan Dios an daydayawon din hi amam an hi Abraham. Adika tumakut te wadaak ta nangamung an mangipaptok ke he-a. Ya bendisyonan daka. Ya idatan dakah dakkodakkol an holag mut mumbalin dah ongal an boble. Athituy atok gapu nah muttatyuk an hi Abraham.” ");
INSERT INTO ifk_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ot mangapyah Isaac hi pun-appitan dah di ot dayawonah APU DIOS. Nungkampu dah di ot e bo kuma-ut nadan muttatyunah oha bon bubun. ");
INSERT INTO ifk_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ohan algo ya imme da Abimelek, hi Ahussat an konsihal na ya hi Pikol an ap-apun di tindaluna an nalpu dad Gerar an e manibon Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kanan Isaac ke diday “Tipet ekayu immali, nunna-ud an adi maphod di manibon ha-on. Handi ya inhihhingitak ot dog-alonak ke dakayu nah bobleyu?” ");
INSERT INTO ifk_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ya kanan day “Man-uke ya ininnila mi mon wadah APU DIOS ke he-a. Kinali pinhod min munhahayyup taku. ");
INSERT INTO ifk_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ihuhummangan takun maid di atom ke dakamih ad-adi, umat ke dakamin maid di inat min he-ah ad-adi takon handih nangitud-akan min he-an tumayan nah boble mi ot deyan ongal di bendisyon APU DIOS ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ot mumpadadaan hi Isaac hi makan ot mangan da ya nanginum da. ");
INSERT INTO ifk_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bimmangun dah kabigatana ot isapata dan maid di aton dah ad-adih hin-oh-an dida. Nagibbuh diye ot umanamut da Abimelek hi boble dan malinggop da te nunggagayyum da mo. ");
INSERT INTO ifk_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kediyen algo ya immanamut nadan muttatyun Isaac ot kalyon dan hiyan waday danum nah bubun an eda kina-utan. ");
INSERT INTO ifk_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ot ngadanan Isaac hidiyen bubun hi “Siba” an hay kibalinana ya nunsapataan. Hidiyey naalaan nan ngadan diyen boblen Beersheba. ");
INSERT INTO ifk_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Handi nap-at di toon Esau ya nalahin hi duwan babain Hittite an da Judith ke Basemat. Hi Judith ya imbabalen Beeri ya hi Basemat ya imbabalen Elon. ");
INSERT INTO ifk_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mu datuwen inayan Esau ya ongal di idat dan da Isaac ke Rebekah hi kabulubulunan da. ");
INSERT INTO ifk_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Handih naam-amah Isaac an adi mo pakatibo ya impaayag nah Esau an imbabalena. Immalih Esau ot kananay “Tipe- ama?” ");
INSERT INTO ifk_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kanan Isaac di “Deyan am-amaak mo ya maid uhup ya mateyak. ");
INSERT INTO ifk_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Alam nan panam ta eka mun-anup. ");
INSERT INTO ifk_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pinhod ku nan oggan mu pana-ang an mahong-o. Deket nagibbun nanganak ya ahik kinali nan bendisyon kun he-an kiphodam ta ahiyak mate.” ");
INSERT INTO ifk_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mu hi Rebekah ya dongdonglonah diyen kinalin Isaac ke Esau ot handih immeh Esau an e nun-anup ");
INSERT INTO ifk_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ya kanan Rebekah ke Jacob di “Dingngol kun kinalin amam ke Esau ");
INSERT INTO ifk_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","an e mun-anup hi ipahidanan hiya. Ta deket nagibbun nangan ya ahina indat di bendisyonan hiyah hinangngab APU DIOS ta ahi mate. ");
INSERT INTO ifk_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kinali donglom ya unudom tun kalyok ke he-a. ");
INSERT INTO ifk_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mangin-e-e kat eka dumpap hi duwa nadah gulding taku. Piliyom di duwah mataban mungkaong-ongal, ne in-alim ta iha-ang ku nan pakappinhod amam pana-ang hi ihdana. ");
INSERT INTO ifk_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ta em pihdan hiya ta he-ay pangidatanah bendisyonat ahi mate.” ");
INSERT INTO ifk_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mu kanan Jacob ke inanay “Nganney innuk an hi ke Esau ya nakabu-ukkan di adol na yaden ha-on ke ya madangiy bolat ku? ");
INSERT INTO ifk_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nungay dapaonak ya inilaonan bokonak hi Esau ta kanan ot ya abuy kalyonay kiphodak ya bokon te dug-ahanak.” ");
INSERT INTO ifk_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kanan inanay “Kal-ina ket waday athidi ya takon di ha-oy di kiayan di dug-ana. Eka ot ta em alan nan gulding.” ");
INSERT INTO ifk_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ot e alan Jacob di duwa nah gulding ot iha-ang inana nan pakappinhod amanan hi Isaac an ihda. ");
INSERT INTO ifk_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Inalan Rebekah nan makaphod an bulwatin Esau an indulina ot ipabulwati nan Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Impahuklub na boh taklen Jacob ya inha-ad nah tongod na nan bolat di gulding an nakabu-ukkan ");
INSERT INTO ifk_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ot ahina idat ke Jacob nan mahong-on inha-ang nan ihda ya nan kinapya nan tinapay. ");
INSERT INTO ifk_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","In-en Jacob ke amana ot kananay “Ama.” Ya kanan amanay “An dahdi ka?” ");
INSERT INTO ifk_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kanan Jacob di “Ha-oy nan panguluwan an hi Esau. Inun-unud ku nan kanam. In-alik tun kanom. Bumangun ka, ama, ta mangan ka ne binendisyonanak.” ");
INSERT INTO ifk_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kanan Isaac di “Nganney inat mun imbabalek ta maid uhup ya waday inanup mu?” Kanan Jacob di “Binaddanganak ke APU DIOS an daydayawom.” ");
INSERT INTO ifk_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ya kanan Isaac di “Mih-up kat dapaon daka hin makulug an he-ah Esau.” ");
INSERT INTO ifk_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ot mih-up hi Jacob ot dapaon amana ya kananay “Hay kalim ya hi Jacob, mu hay taklem ya taklen Esau.” ");
INSERT INTO ifk_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Uggena inimatunan an hi Jacob hidiye te nakabu-ukkan di taklena an umat hi taklen Esau. Ot bendisyonanah Jacob muden ");
INSERT INTO ifk_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","impidwana bon hinanhanan an kananay “Kon makulug an he-ah Esau?” Kanan Jacob di “Om, ha-oy.” ");
INSERT INTO ifk_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ot kanan Isaac di “Ialim nan inanup mut ihdak ta ahik kalyon nan bendisyon an kiphodam.” Ot idat Jacob nan kanona ot mangan ya indat na bo nan inumona. ");
INSERT INTO ifk_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ot kanan Isaac ke hiyay “Makan imbabalek ta iawal mun ha-oy.” ");
INSERT INTO ifk_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Inawal Jacob hi amana ot hamuyon amanay bulwatina ot ahina kalyon di bendisyonan hiya an kananay “Hay hamuy mun imbabalek ya umat nah hamuy di payon binendisyonan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hana ot ta ipaalin Apu Dios di udan nah payom ya paphodonat dumakol di aniyom ta dakol di makan ya mainum. ");
INSERT INTO ifk_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya hay tataguh kabobboble ya mumbalin dan muttatyum an he-ay tangadon dan ap-apu. Ya takon nadan tutulang mu ya nadan holag inam ya he-ay ibilang dan ap-apuda. Ya nadan mundug-a ke he-a ya madug-ahan da ya nadan mumbendisyon ke he-a ya mabendisyonan da.” ");
INSERT INTO ifk_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Nagibbu ot lumah-un hi Jacob ya dimmatong hi Esau an e nun-anup. ");
INSERT INTO ifk_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Inha-ang na damdama nan pakappinhod amanan ihda ot iena ot kananay “Ama, bumangun kat mangan ka ta ihdam tun inha-ang ku ta ahim kalyon nan bendisyon mun ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ya kanan amanay “An dahdi ka?” Ya kanan Esau di “Ha-oy hi Esau an panguluwan an imbabalem.” ");
INSERT INTO ifk_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ya munggagayonggong hi Isaac. Kananay “Dahdi mo nan nangialih dotag an inihdak dih indani ot ahika umali? Hiya moy nangidatak hi bendisyon. Deyan nil-u ya athidi mot inggana an adi mabaliwan.” ");
INSERT INTO ifk_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ya nahalman di kogan Esau hi nangngolanan diye ot kananay “Ama, takon, mu umidat ka damdaman ha-oy hi bendisyon ku.” ");
INSERT INTO ifk_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kanan Isaac di “Hinaulak ke tulang mu ot hiya moy nanawat nah idat ku ot ke he-an bendisyon mu.” ");
INSERT INTO ifk_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kanan Esau di “Kinali anhan tuwali hi Jacob di ngadana! Hituwey pidwanah nunhaulanan ha-on. Handi ya hinaulak ot alana nan kalebbengak an panguluwan ya ad uwani bo ya pinlona nan bendisyon an midat ot ke ha-on. Ot kon maid moy idat mun ha-oy hi bendisyon ku?” ");
INSERT INTO ifk_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Hinumang Isaac an kananay “Nganney innun an imbabalek an nagibbu mon indat ku? Impumbalin kun hiyay natagtag-e ke dakayun duwa. Ya am-in day iibana ya numbalinok an muttatyuna. Ya hiyay binendisyonak hi dakol an makan ya mainum. Kinali maid moy mabalin an idat kun he-an imbabalek.” ");
INSERT INTO ifk_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Mu nahalman an pihpihmok hi Esau ke amanan kananay “Kon abunah diyen bendisyon mu, ama? Bendisyonanak anhan damdama.” Ya namahig boy koga na. ");
INSERT INTO ifk_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kanan amanay “Hanan lutan kiha-adam ya adi maphod an puntanoman ya maid di udan an malpuh kabunyan. ");
INSERT INTO ifk_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ta nan apputom hi pakigubatam di pangal-am hi kitaguwam. Mumbalin kan muttatyun nan ibam, mu loktat ya ngohayom ta adika munnanong an muttatyu na.” ");
INSERT INTO ifk_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ot nipalpun diye ya nahalman di boh-ol Esau ke Jacob gapu nah bendisyonan an pinlona. Ta hay nomnomnomona ya patayonah Jacob ten mateh amada. ");
INSERT INTO ifk_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Dingngol Rebekah diyen planun Esau ot ipaayag nah Jacob ot kananan hiyay “Deyan planun tulang mun hi Esau an patayon dakat ibalo nay inat mu. ");
INSERT INTO ifk_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kinali bumtik kah kad-an nan ammodom an hi Laban hidid Haran. ");
INSERT INTO ifk_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ta hidi ni-an di em kiha-adan inggana maalubyag di boh-ol tulang mu. ");
INSERT INTO ifk_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ta deket nakal-iwana nan inat mun hiya ya ahiyak umitud-ak hi mangayag ke he-a. Te adik pinhod an ekayu mumpatte te ugge inila ya mundihhan kayun mateh ohan algo.” ");
INSERT INTO ifk_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ohan algo ya kanan Rebekah ke Isaac di “Dehtun impainglek mo anhan hantudan Hittite an inayan Esau. Deket Hittite an babai boy iinen Jacob ya kudukdulnay mateyak.” ");
INSERT INTO ifk_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ot ipaayag Isaac hi Jacob ot bendisyonana ya tinugunan kananay “Mahapul an bokon ihituy iinem. ");
INSERT INTO ifk_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kudukdulnay ume kad Mesopotamya an boblen da apum an hi Bethuel ta iinem di ohan nah imbabalen Laban an hi tulang inam. ");
INSERT INTO ifk_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hana ot ta bendisyonan Apu Dios an Kabaelanan am-in ta mahlag kat udum hi algo ya he-ay pun-ammod am-in di katagutagu. ");
INSERT INTO ifk_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ya hana ot ta nan kinalinan Abraham an bendisyon ya mipaannung ke he-a ya nadah holag mu ta takon di makibobboble takuh tu ya abu ya loktat ya dakayuy ahi mangiluta ketuwen indat Apu Dios ke Abraham.” ");
INSERT INTO ifk_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ot itud-ak nah Jacob ad Mesopotamya hi balen da Laban. Hi Laban ya tulang Rebekah an hi inan da Jacob ke Esau. Ya hay aman da Laban ya hi Bethuel an iAramea. ");
INSERT INTO ifk_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ininnilan Esau an binendisyonan amanan hi Isaac hi Jacob ot ahina itud-ak ad Mesopotamya ta hidiy kalahinana ta bokon hay iKanaan di iinena. ");
INSERT INTO ifk_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ya ininnila na bon inun-unud Jacob di intugun da amanan inana ot umed Mesopotamya. ");
INSERT INTO ifk_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ketuwe ya naawatanan adi pinhod ama day pangahawaan dah iKanaan. ");
INSERT INTO ifk_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ot umeh Esau hi balen da Ismael an hi tulang amana ot iinena boh Mahalat an hi tulang Nebayot an imbabalen Ismael an imbabalen Abraham. ");
INSERT INTO ifk_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hi Jacob ya tinayanana ad Beersheba ot mumpaed Haran. ");
INSERT INTO ifk_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nahilngan hi dalan ot mungkampu. Immalah batu ot pangippinganah uluna ot mahuyop. ");
INSERT INTO ifk_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kediyen nayongyong ya inin-inop nan wada on teden dinatnganay kabunyan. Ya wadaday anghel Apu Dios an timmikid da on dimmayyu da kediyen tete. ");
INSERT INTO ifk_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ya wadah APU DIOS an timmaddog nah udun nan teten kananay “Ha-oy hi APU DIOS an dayawon din hi apum an hi Abraham ya hi amam an hi Isaac. Hituwen lutan nibakilangam ya idat kun he-a ya nadan holag mu. ");
INSERT INTO ifk_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ahi dumakkodakkol di holag mun adida mabilang umat hi kadakol di hupuk ta mihinap dah kabobboble tuh luta. Ya gapun he-a ya nadan holag mu ya bendisyonak am-in di tatagu tuh luta. ");
INSERT INTO ifk_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ya am-in nah pangayam ya wadaak an mangipaptok ke he-a ya ha-oy boy nangamung an ahi mangipabangngad ke he-a ketuwen boble. Adi daka iwalong, mu ipaannung ku nan kinalik ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Inggibok Jacob ya kananay “Uggek inilan wada gayam hi APU DIOS hitu.” ");
INSERT INTO ifk_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Timmakut hi Jacob ya kananay “Katatakut hitu! Hituwey hoob an umeh langit an balen Apu Dios.” ");
INSERT INTO ifk_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bimmangun hi Jacob hi nabigatana ot alana nan batun impungana ot ha-adonah panginomnomanan Apu Dios kediyen naat ot duyaganah lana. ");
INSERT INTO ifk_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nginadananah diyen bobleh Bethel, mu hay tuwali ngadan diyen boble ya Lus. ");
INSERT INTO ifk_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ot isapatan Jacob an kananay “APU DIOS, ituluy mu ken maki-kien ha-on hi kumpulnan pangayak ta ipaptokak ke he-a ya idat mun am-in di mahapul ku, umat hi kanok ya bulwatik ");
INSERT INTO ifk_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ta ingganah kibangngadak hi balen ama ya he-an AP-APU di dayawok an Dios ku. ");
INSERT INTO ifk_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Hituwen batun hina-ad kuy panginomnomak hi nangin-inopak ke he-a ya hituy pundaydayawak ke he-a. Ya am-in di idat mun ha-oy ya ibangngad kun he-ay mikapulu.” ");
INSERT INTO ifk_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Intultuluy Jacob an mangen nah pangayanan numpaeh nangappit hi timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Indani ya dinatngana on pumpattolan an waday bubun an pun-inuman di kalnero. Wada dahdiy tulun halun an kalneron munluklukbub dah nunlinikkod kediyen bubun ya waday ongal an batun nim-ut kediyen bubun. ");
INSERT INTO ifk_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Deket naamung nadan kalnero on dinlig nadan mumpattol nan batu ta uminum da. Deket nagibbun imminum da on imbangngad dan inim-ut nan batu. ");
INSERT INTO ifk_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","E nunhanhan hi Jacob nadah mumpattol an kananay “Iiba, daan di bobleyu?” Ya kanan day “Ad Haran.” ");
INSERT INTO ifk_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kananan diday “Kon inila yuh Laban an hi nak Nahor?” Ya kanan day “Om, inila mi.” ");
INSERT INTO ifk_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kananay “Nganney innuna?” Ya kanan day “Maphod. Deyan mangalih Rachel ya nadan kalneron amana.” ");
INSERT INTO ifk_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kanan Jacob di “Deyan uhup ta ahi mahilong ya tipet adiyu ot ya abu painuman didat ibangngad yu bon e ipattol?” ");
INSERT INTO ifk_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ya kanan day “Adi te kah-in di umali dan am-in nadan kalnero ta ahimi duligon nan batun nim-ut nah bubun ya ahimi impainuman didan am-in.” ");
INSERT INTO ifk_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kediyen munhuhummangan da ya dimmatong hi Rachel ya nadan kalneron ipattol na. ");
INSERT INTO ifk_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tinibon Jacob hi Rachel ya nadan kalnero ya ena kinaan nan batun nim-ut nah bubun ot painumana nadan kalneron pangamaonan hi Laban. ");
INSERT INTO ifk_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ot awalonah Rachel ya mungkogah amlong na. ");
INSERT INTO ifk_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ot kanan Jacob ke Rachel di “Ha-oy ya imbabaleyak ke Rebekah an tulang amam.” Ot butikon Rachel ot ena kalyon ke amana. ");
INSERT INTO ifk_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dingngol Laban an wada nan imbabaleyona ya bintik na damdama ot ena damuwon. Inawal nah Jacob ot awitonah baleda. Ot kalkalyon Jacob am-in di na-na-at. ");
INSERT INTO ifk_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kanan Laban di “Makulug an hin-ama ta.” Nakiha-ad hi Jacob hidih himbulan ");
INSERT INTO ifk_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ot ohan algo ya kanan Laban ke Jacob di “Adi gapu te imbabaleyon daka ya abunay edaka pungngunngunuwwon. Kinali maphod ten kalyom di pinhod mun idat kun he-ah boklaom.” ");
INSERT INTO ifk_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hi Laban ya waday duwan binabain imbabalenan hay ngadan nan panguluwan ya hi Leah ya nan nihaynod ya hi Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Hi Leah ya mapmaphod di matana, mu hi Rachel ya maddikit ya mapmaphod di adol na. ");
INSERT INTO ifk_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Hi Jacob ya pinpinhod nah Rachel. Kinali kananan Laban di “Takon di ingunuwan dakan ha-oy hi pituy toon mu ta iabulut mun iinek hi Rachel.” ");
INSERT INTO ifk_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ot kanan Laban di “O a, kudukdul nan he-ay pangipaahawaak ke hiya mu hay udum. Kinali mihtu taku.” ");
INSERT INTO ifk_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ot ingunuwan Jacob hi Laban hi pituy toon ta iine nah Rachel. Mu hidiyen pituy toon ya kay ya abu nabilang an algo gapuh naminhod nan Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nagibbuh diyen pituy toon ot kalyon Jacob ke Laban an pinhod nan mun-addum da mon Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ot idadaan Laban di pungkasalan nan imbabalena ot ipaayag nan am-in di tagu. ");
INSERT INTO ifk_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mu nahilong kediye ya hi Leah ot ya abuy impiinen Laban ke Jacob ot hiyay ihuyop na. ");
INSERT INTO ifk_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Indat Laban nan muttatyu dan hi Silpah ta punmuttatyun Leah. ");
INSERT INTO ifk_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nabigat ya ininnilan Jacob an hi Leah di inhuyop na. Ot ena ibagan Laban an kananay “Tipet athidiy inat mu? Kon bokon hi Rachel di ingngunungunuwak? Tipet eyak hinaul?” ");
INSERT INTO ifk_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ot kanan Laban di “Man-uke ya hay pangi-e mihtu ya mahapul an hay panguluwan di maunnan malahin. ");
INSERT INTO ifk_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mu takon di athina ya had-om ta magibbuh tuwen hinlingguwan an pungkasalan yun Leah ta ahik iabulut hi Rachel. Mu mahapul an ingunuwam boh pituy toon.” ");
INSERT INTO ifk_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Timbal Jacob ot magibbuh diyen hinlingguwan ot ahi iabulut Laban hi Rachel an iine na bo. ");
INSERT INTO ifk_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ya hay indat damdaman Laban ke Rachel an pummuttatyuna ya hi Bilhah. ");
INSERT INTO ifk_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ot ihuyop bon Jacob hi Rachel ya ong-ongal di impaminhod nan hiya mu hi Leah. Ot ingunuwana boh Laban hi pituy toon. ");
INSERT INTO ifk_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Handih tinibon APU DIOS an ong-ongal di impaminhod Jacob ke Rachel ya hi Leah di in-abulut nan mawadaan hi imbabale, mu hi Rachel ya uggena in-abulut an mawadaan. ");
INSERT INTO ifk_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nawadaan hi Leah ot muntungo ya lalaki. Ot ngadananah Reuben an kananay “Maphod ta tinibon APU DIOS tun hakit di nomnom ku. Pinhodonak mo nah inayak ad uwani.” ");
INSERT INTO ifk_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Indani ya nawadaan bo ot mun-imbabale ya lalaki bo ot kananay “Maphod ta indat APU DIOS boh tuwen imbabalek te inilanan adiyak pinhod tuh inayak.” Ot ngadana nah Simeon. ");
INSERT INTO ifk_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Indani bo ya nawadaan ot mun-imbabale ya lalaki bo ot ngadana nah Libay. Ya kananay “Wadan pinhodonak mo tuh inayak te tulu moy imbabale min linalaki.” ");
INSERT INTO ifk_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Indani ya nawadaan bo ot mun-imbabale ya lalaki bo ot ngadana nah Judah. Kananay “Ad uwani ya hi APU DIOS di dayawok.” Ya nipalpun diye ya ugge mo nawadaan. ");
INSERT INTO ifk_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ma-ma-id di imbabalen Rachel ta hidiye nan nakapyay amo nan tulang nan hi Leah. Kananan Jacob di “Idattanak damdamah imbabalek te maid ke ya kudukdulnay mateyak.” ");
INSERT INTO ifk_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ya bimmoh-ol hi Jacob ke Rachel an kananay “Kon ha-oy hi Apu Dios? Hiyay adi mangipaimbabalen he-a, bokon ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ya kanan Rachel di “Takomboy ihuyop mu nan muttatyuk an hi Bilhah ta deket inimbabaleyam ya mibilang an imbabale ta.” ");
INSERT INTO ifk_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Timbal Jacob ot ihuyop nah Bilhah. ");
INSERT INTO ifk_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nawadaan hi Bilhah ot muntungo ya lalaki. ");
INSERT INTO ifk_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nginadanan Rachel hi Dan te kananay “Impatibon Apu Dios an ha-oy di lebbengnan kon inayan ke Jacob, kinali dingngol nay dasal kun hiya ot idat nah tuwen imbabalek an lalaki.” ");
INSERT INTO ifk_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Indani ya nawadaan boh Bilhah ot muntungo ya lalaki bo ");
INSERT INTO ifk_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ot ngadanan Rachel hi Naptali te kananay “Impanatnan tulang kun pulhon nan inayak, mu ad uwani ya inapput ku.” ");
INSERT INTO ifk_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Handih magibok Leah an natikod di pun-imbabaleyana ya in-abulut na bon ihuyop Jacob nan muttatyunan hi Silpah. ");
INSERT INTO ifk_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Indani ya nawadaan hi Silpah ot mun-imbabale ya lalaki. ");
INSERT INTO ifk_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nginadanan Leah hi Gad te kananay “Nagahatak te nawada boh tuwen imbabalek.” ");
INSERT INTO ifk_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nawadaan boh Silpah ot muntungo ya lalaki bo. ");
INSERT INTO ifk_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ot kanan Leah di “Ongal di amlong ku! Hay punnomnom mon nadan binabain ha-on ya maka-am-amlongak.” Kinali nginadananah Asher. ");
INSERT INTO ifk_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ohan algon ahiani ya immeh Reuben hi payo ya waday hinamak nah nitanom an mihda an mandrake. Inalana ot ena idat ke inanan hi Leah ya mungkodoh Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mu kanan Leah ke hiyay “Deya bon pinlom nan inayak ya ad uwani bo ya pinhod mun alan tun in-anamut di imbabalek.” Mu kanan Rachel di “Idattanak anhan ta takon di he-ay makihuyop ke Jacob hi hilong.” ");
INSERT INTO ifk_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nahilong kediyen manganamut hi Jacob an nalpuh payo ya e dinamun Leah ot kananan hiyay “Ha-oy di makihuyop ke he-ah hilong te binayadan dakah mandrake an makan an in-anamut nan imbabalek.” Ot hiyay inhuyop Jacob kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ya dingngol Apu Dios di dasal Leah ot mawadaan. Nuntungoh lalaki an hidiyey mikalima. ");
INSERT INTO ifk_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ot ngadananah Issakar te kananay “Hituwey ginun-ud kun indat Apu Dios hi nangiabulutak an makihuyop nan muttatyuk nah inayak.” ");
INSERT INTO ifk_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Indani bo ya nawadaan hi Leah ot muntungo ya lalaki an hidiyey mikan-om. ");
INSERT INTO ifk_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ot ngadananah Sebulun te kananay “Hi Apu Dios ya indatanak hi maphod. Ot wadan pohdonak mon nah inayak tedeyan onom moy imbabalemi.” ");
INSERT INTO ifk_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Indani ya nawadaan bo ya babai ot ngadananah Dinah. ");
INSERT INTO ifk_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Indani ya ninomnom mon Apu Dios hi Rachel ot iabulut nan mawadaan hi imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nawadaan ot muntungo ya lalaki ya kananay “Maphod ta indat Apu Dios on imbabalek ta adiyak mo pihulon hi tatagu.” ");
INSERT INTO ifk_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nginadananah Joseph an kananay “Hana ot anhan ta kadwaan APU DIOS hi oha bon lalaki.” ");
INSERT INTO ifk_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kediyen nawadah Joseph ya kanan Jacob ke Laban di “Ad uwani ya pinhod kun mibangngad moh boble mi. ");
INSERT INTO ifk_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Iabulut mut awitok tudan inayak ya nadan imbabalemi ot deyan impakabboklak dida. Ya inilam an namahig di impungngunuk nah impangunum ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ya kanan Laban ke hiyay “Adim ot doldolawwon ta eyak taynan ke he-a. Te hay kinalin nan mun-abig ya kananay dakol kanuy maphod an inat APU DIOS ke ha-on gapun he-a. ");
INSERT INTO ifk_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kalyom ot ya abu hin kaatnay pinhod muh binoklam ta idat ku.” ");
INSERT INTO ifk_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ya kanan Jacob ke hiyay “Inilam hin kaatnay nungngunuk nah impangunum ke ha-on hi kaatnay toon ot dumakol di halun mu te impanaptok ku. ");
INSERT INTO ifk_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Handih ka-alik ya o-ohay halun mu. Mu deyan dimmakol ya ongal di kiphodam an indat APU DIOS gapun ha-on. Ta ad uwani ya hay mahapul mo damdaman di pamilyak di hangudok.” ");
INSERT INTO ifk_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kanan Laban ke hiyay “Ot kalyom nimpey pinhod mun binoklam ta idat ku.” Ya kanan Jacob di “Adiyak mumbagah binoklak, mu tobalom ke tun kalyok ya takon di ituluy kun ipaptok di halun mu. ");
INSERT INTO ifk_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hay atok ya ek appilon am-in nadan mangitit an impan di kalnero ya nan nabatokan an impan di gulding ta dadiyey kay ku binokla. ");
INSERT INTO ifk_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ta udum hi algo ya makainnila an maid di pinlok ke he-a. Matibo te deket waday ugge nabatokan an gulding ku weno bokon mangitit an kalnero ya mainilan nalpuh halun muh diye.” ");
INSERT INTO ifk_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ya timbal Laban hidiye. ");
INSERT INTO ifk_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mu hay inat Laban kediyen algo ya immen nah haluna ot appilonan am-in nadan mangitit an kalnero ya nadan nabatokan an laki ya laba an gulding. Ot ipipaptok na nadah imbabalenan linalaki. ");
INSERT INTO ifk_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ot ie dah nidawwi an tuluy algoy nundallanan da. Ot nadan imbati da ya hidiyey impipaptok na ke Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mu hay inat Jacob ya nangalah hapang di nunhihinnatkon an kaiw ot wihwihanay hingkikitay nah uki ta mumbobolay matibo. ");
INSERT INTO ifk_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Inip-ong na dadiyen impahangngab na nadah pun-inuman da te deket nah eda uminum an kediyey punmiminnayaan da. Ta deket nun-impa da on nungkagulitan ya nungkabatokan. ");
INSERT INTO ifk_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Bokon ya abuh diyen inat Jacob, mu inappil na pay ni-an nadan labah an bagin Laban. Ot impamaya na nadah mangitit an lakin bagina. Athituy dimmakkolan di halun Jacob. Mu hi ke pe Laban ya ugge nad-uman di haluna. ");
INSERT INTO ifk_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ya deket mummiminnaya nadan mungkaphod ya mungkakodhol on impahangga nan dida nan nawihwihan an kaiw nah pun-inuman da. ");
INSERT INTO ifk_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mu adina aton hidi nadah nungkakuug. Ot loktat ya mungkaphod am-in nadan haluna an maid di dogoda, mu nada ken halun Laban ya nungkakuug da. ");
INSERT INTO ifk_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Loktat ya kimmadangyan hi Jacob ya dimmakol di muttatyuna ya haluna takon nadan kamel na ya kabayu na. ");
INSERT INTO ifk_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hi Jacob ya dingngol nan kanan nadan linalakin imbabalen Laban di “Inalan Jacob am-in nan halun ama taku ot ikadangyana.” ");
INSERT INTO ifk_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ya inilmu na bon takon hi Laban ya numbaliw te makudang moy pangapnga nan hiya an adi umat handih lappuna. ");
INSERT INTO ifk_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kanan APU DIOS ke hiyay “Kudukdulnay mibangngad kah boblen nan aammod mu ya nan tutulang mu ot wadaak an mangipaptok ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Indani ya impaayag Jacob da Rachel ke Leah ot umali da nah pumpattolanah kalnero. ");
INSERT INTO ifk_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kananan diday “Magibok kun hi amayu ya numbaliw te makudang moy pangapnganan ha-oy an adi umat handih lappuna. Mu maphod ta hi Apu Dios an daydayawon ama ya nanongnan baddanganak. ");
INSERT INTO ifk_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inila yu met kattog an nahalman di nungngunuk am-in nah impangunun ama yun ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mu kapyanan linugilugiyak ke hiya te naminhimpulun kinudakudanganay binoklak. Mu maphod ta ugge in-abulut Apu Dios an dadagonak ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","9","Hay kitib-anan ongal di baddang Apu Dios ke ha-on ya deket kanan ama yuy hay nungkabatokan an gulding di idat nah boklaok on nungkabatokan di iimpa da. Ya deke bot hinannotanay nomnom nat kananay hay nungkagulitan di boklaok on nungkagulitan di iimpa da. Ta hidiye nan kay hiyay nangit-an ke ha-on hanadah halun amayu. ");
INSERT INTO ifk_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Handih mummaya nadan gulding ya inin-inop kun nada ken lakin gulding an munmanada ya nungkagulitan ya nungkabatokan di udum. ");
INSERT INTO ifk_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mungkali nan anghel Apu Dios ke ha-on nah in-inop ku ot kanak di ‘Deh tuwak Apu.’ ");
INSERT INTO ifk_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kananay ‘Tibom ken am-in nadan lakin gulding an munmanada ya nungkabatokan da ya nungkagulitan di udum. Iathituk te tinibok am-in nan inainat Laban ke he-a. ");
INSERT INTO ifk_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ha-oy nan Dios an numpatibon he-a ad Bethel ot duyagam hi lana nan hina-ad mun batun panginomnomnomam ke ha-on ya nunsapata kan ha-on. Ot ad uwani ya mundadaan ka ta mibangngad ka nah boblen nitungawam.’” ");
INSERT INTO ifk_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ya kanan da Rachel ke Leah di “Takon di dakami ya maid anhan di impaboltanan dakami ");
INSERT INTO ifk_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ya kay kami hintaguwan hi pangat na. Kay dakami inihbut ot umahonan am-in di bayad mi. ");
INSERT INTO ifk_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hidiyen kanam an kinadangyan aman kay inalan Apu Dios ot it-anan he-a ya bagi takun am-in ke datuwen u-unga. Kinali nan kinalin Apu Dios ke he-ay un-unudom.” ");
INSERT INTO ifk_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Ot ohan algon e nangaan hi Laban hi dutdut di kalnero na ya indadaan Jacob am-in di mahapul dah kibangngadan dad Kanaan an boblen amana. Hanadan imbabalena ya inayana ya impuntakke na didah kamel. Ot ipangulu na dida ya nadan halun da ot mange dan impakial-ala dan am-in nadan wadan didan limmu dad Padan Aram ad Mesopotamya. Ot gapu te maid hi amada ya inibtik Rachel nadan nakapyan dios amana. ");
INSERT INTO ifk_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Indalunun da Jacob an immen uggeda impainilan Laban. ");
INSERT INTO ifk_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inal-alan Jacob am-in nadan wadan dida ot umagwat da nah Wangwang an Euphrates ot mumpae da nah mabilid ad Gilead. ");
INSERT INTO ifk_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Handih mikatlun algoh timmayanan da Jacob ya waday nangipainilan Laban kediyen binumtikan da. ");
INSERT INTO ifk_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","25","Inamung na nadan tataguna ot unudon dah Jacob. Handih mikapitun algo ya nih-up da mo ke dida nah mabilid ad Gilead an nungkampuwan da. Nahilong kediye ya inin-inop Laban an kanan Apu Dios ke hiyay “Tibom ot ta maid di kalyom ke Jacob hi ad-adi.” ");
INSERT INTO ifk_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ot umeh Laban ke Jacob ot kananay “Tipet athinay inat mun kay mu inibtik tudan imbabalek hi gubat? ");
INSERT INTO ifk_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tipet eyu indalunun timmayan? Gulat nat impainila yun ha-oy ya wadan nundadaanak hi pun-an-anlaan takun am-in ta ahi kayu tumayan. ");
INSERT INTO ifk_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Uggeyak anhan nakiap-apnga hantudah inap-apuk ya hantudah imbabalek ya timmayan kayu. Adi maphod hituwen inat mu. ");
INSERT INTO ifk_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Gulat na ya takon di nganney atok ke he-a ya mabalin, mu numpain-inop nan Dios an dayawon amam handih hilong an kananay maid di kalyok ke he-ah ad-adi. ");
INSERT INTO ifk_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Inilak di gapunah timmayanan yu te uma-abtu kan umanamut hi balen amam. Mu takon ot, tipet eyu impakiala nadan tinattaggun dios ku?” ");
INSERT INTO ifk_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kanan Jacob di “Man-uke ya umagolak an kal-ina ya iadim hantudan imbabalem. ");
INSERT INTO ifk_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mu nan kanam an nakapyan dios mu ya punhamak yu ta deket hamakon yu ya mipipate nan nangala. Ya deket waday tibom hi bagim ya ituddum ta pun-hintitib-an tun tatagun nun-ibba taku.” Athidiy nangalin Jacob te uggena inilan hi Rachel di nangala. ");
INSERT INTO ifk_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ot op-opngon Laban an hinamak nadah kampun Jacob ot ahih kampun Leah, nah kampun nan duwan muttatyu ot ahih kampun Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mu maid. Hi Rachel ya inhudu na nadan nakapyan dios amana nah ubunan hi puntakkayan ot ub-ubunnana. ");
INSERT INTO ifk_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kananan amanay “Adim ad-adiyon di ek adi tumaddogan te waday malpuh adol ku.” Ot maid di hinamak Laban. ");
INSERT INTO ifk_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Hidiyey bimmoh-olan Jacob ot kananan Laban di “Nganney numbahulak ke he-a ta eyak inunud? ");
INSERT INTO ifk_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Deyan binalukitkit mun am-in ya deket waday hinamak muh kanam hi bagim ya ibudal mut tibon tudan ibbam ya tudan ibbak ta diday mangiuh-u hin dahdi ke ditay nihalla. ");
INSERT INTO ifk_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Inilam an duwampuluy toon di nungngunuwak ke he-a ot ipanaptok kuy halun mu ot deyan dimmakol. Ya takon di oha ya maid di ek kinlong ot ihdak. ");
INSERT INTO ifk_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ya wada key pinaten di layon nah halun mu on uggek impainilan he-a on hinannotak. Athidi bo nadah maakoh hilong weno mapat-al an ipahannot mun ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ya initpoitpol kuy potang nah mapat-al ya kotol nah hilong ya deke on matukatukalak. ");
INSERT INTO ifk_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Athituy hinolholtap kuh duway pulun toon te himpulut opat di toon di namoklaak ke datuwen duwan imbabalem ya onom di toon di namoklaak ke datuwen halun ku. Mu naminhimpulun kinudangam di binoklak. ");
INSERT INTO ifk_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gulat nat uggeyak binaddangan ke Apu Dios an dayawon nadan aammod kun hi Abraham ya hi Isaac ya wadan intud-akak an ma-ma-idan di indat mu. Mu maphod ta tinibon Apu Dios di nunligatak ya hay inat kun nungngunu ot handih hilong ya kinalinan he-an maid di kalyom ke ha-on hi ad-adi.” ");
INSERT INTO ifk_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ya kanan Laban di “Hantudan binabai ya imbabalek dida ya inap-apuk tudan imbabaleda. Ya takon tun halun ya nalpun ha-on. Hay kakulugana ya am-in tun matibom ya bagik. Mu gaput maid moy maat ku ya ");
INSERT INTO ifk_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","mahapul an munhummangan ta. Aga, umiha-ad tah batun panginomnoman ta.” ");
INSERT INTO ifk_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ot umalah Jacob hi batu ot ha-adona ta panginomnoman da kediyen ihummangan da. ");
INSERT INTO ifk_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ya kinalina nadah ibbana ot umipiggil dah batu ot mangan dan am-in hidi. ");
INSERT INTO ifk_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nginadanan Laban hidiyeh Jegar Sahadutah. Hay impungngadan damdaman Jacob ya Galeed. ");
INSERT INTO ifk_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kanan Laban ke Jacob di “Hituwen piniggil di panginomnoman tan duwa.” Kinali hay ngadan diyen boble ya Galeed. ");
INSERT INTO ifk_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mu nginadanan da boh Mispah te kanan Laban di “Hi APU DIOS di manmannibon ditan duwa ta nan inhummangan ta ya maunud takon di nundawwiyan ta. ");
INSERT INTO ifk_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Adik inilaon hin iboh-ol mu tudan imbabalek weno malahin ka boh udum, mu nomnomom an wadah Apu Dios an manmannibon he-a. ");
INSERT INTO ifk_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Hay mangipanomnom ke dita ya hituwen piniggil an batu ya nan batun hina-ad mu. Ya adi mabalin an la-uwak ta waday atok ke he-ah ad-adi ya athidi bon he-an adi mabalin an la-uwam ta waday atom ke ha-on hi ad-adi. ");
INSERT INTO ifk_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hanan Dios an dayawon din hi Abraham ya hi Nahor di nangamung an mangastigu nah mangibahho ketuwen inhummangan ta.” Ot munsapata damdamah Jacob nah Dios an dayawon Isaac an un-unudonah tuwen inhummangan da. ");
INSERT INTO ifk_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ot iappitan Jacob hi Apu Dios nah bilid. Inayaganan am-in nadan tatagu ot mangan da. Ot mun-iyan dahdi kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nabigat ot bumangun hi Laban ot awalona nadan inap-apuna ya imbabalena ot bendisyonana dida ot ahida umanamut hi bobleda. ");
INSERT INTO ifk_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Da Jacob damdama ya intuluy dan imme ya indani ya wadaday anghel an nidamun dida. ");
INSERT INTO ifk_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tinibon Jacob dida ot kananay “Wada gayam hi Apu Dios.” Ot ngadananah diyen boble hi Mahanaim. ");
INSERT INTO ifk_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ot ipamangulun Jacob di udum nah tatagunat ume dad Edom ta eda makihummangan ke tulang nan hi Esau. ");
INSERT INTO ifk_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kananay “Hituwey kalyon yun Esau: ‘Hanan muttatyum an hi Jacob ya nakiha-ha-ad hi balen da amaon yun hi Laban an tulang inayu ot ad uwani ya pinhod nan mibangngad. ");
INSERT INTO ifk_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Waday halunah kalnero, baka, kabayu ya gulding ya wadada boy muttatyu nah binabai ya linalaki. Ya impamangulu dakamin intud-ak ta ipainila min he-ay umaliyan da hin abulutom.’” ");
INSERT INTO ifk_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nibangngad datuwen intud-ak Jacob ot kanan dan hiyay “Kinali min tulang mu ot tuwen e ditaku damuwon an waday ingkuyug nah opat di gatut an tataguna.” ");
INSERT INTO ifk_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dingngol Jacob hidiye ya namahig di takut na ya danag na ot hay inat na ya ginodwa na nadan tataguna ya nan haluna. ");
INSERT INTO ifk_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Hay nomnom na ya kal-ina ket mundadammu da ya pumateh Esau ya waday innun nadan nanguddidin bumtik. ");
INSERT INTO ifk_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ot mundasal hi Jacob an kananay “He-an AP-APU an Dios an dayawon apun hi Abraham ya hi aman hi Isaac, he-ay nangalin ha-on an mibangngadak nah numboblayan nadan iibak ya aammod ku ta nangamung kan mangipaptok ke ha-on ta pumhod di nitaguwak. ");
INSERT INTO ifk_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Hay punnomnom ku ya adina ot lebbeng an eyak impatipatib-an hi ulem ot deyan ongal di bendisyon mun ha-on te handih timmayanak hi balemi ot agwatok nan Wangwang an Jordan ya abunay patanong kun intabtabin ku, mu ad uwani ya deyan nunduwa-an hantudan ingkuyug ku. ");
INSERT INTO ifk_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kinali dawatok ke he-a, Apu, ta ihwang dakami anhan hi kumpulmin adi maphod an nomnomnomon tulang kun hi Esau an aton ke dakami. Te dehtun tumattakutak an abu te kal-ina ya patayon dakamin am-in takon hantudan inayak ya hantudan imbabalek. ");
INSERT INTO ifk_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kinalim handi an ipaptokak ke he-a ya idattanak hi dakol an holag kun umat hi kadakol di lona nah pingngit di baybay an adi mabilang.” ");
INSERT INTO ifk_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nahilong ot mun-iyan da. Nabigat ya ninomnom nan idattanah tulang nan hi Esau hi aggayam ot umappil hi idat nan hiya ");
INSERT INTO ifk_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","an duway gatut an laban gulding, duway pulun laki, duway gatut an laban kalnero ya duway pulun laki, ");
INSERT INTO ifk_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tuluy pulun kamel an waday impana, nap-at an baka ya himpulun bulug, duway pulun laban kabayu ya himpulun laki. ");
INSERT INTO ifk_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ginanodwana ot ip-ong na nadan muttatyuna an ohan halun on ipaptok di oha. Kananan diday “Mamangulu kayu ya tibon yu ta waday pumbabattanan yu.” ");
INSERT INTO ifk_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ot kanana nah namangulun muttatyu nay “Deket dammuwon yuh Esau ta hanhananan kananay ‘Daanay pangayam ya dahdiy kon muttatyun he-a? Ya dahdiy kon halun ke datuwe?’ ");
INSERT INTO ifk_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ya kanan yun hiyay ‘Halun nan muttatyum an hi Jacob datuwe an idat nan he-an apuna. Ya hi Jacob ya mangalin nanguddidi.’” ");
INSERT INTO ifk_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kinalinan am-in hanadah muttatyunan mitun-ud an athidin am-in di kalyon da. ");
INSERT INTO ifk_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kanana bon dida “Adiyu kal-iwan an kalyon ke hiyay ‘Hi Jacob an muttatyum ya mangali.’” Te hay wadah nomnom na ya maal-alubyag di boh-ol tulang nan hiya hin tibona datuwen idat na ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ot pamanguluwona didan impae, mu dida ke ya nun-iyan da kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kediyen hilong ya bimmangun hi Jacob ot pamanguluwona nadan duwan inayana, nadan duwan muttatyu dan mibilang an inayana ya nadan himpulut ohan imbabale dat umagwat da nan Wangwang an Jabbok. ");
INSERT INTO ifk_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Impae na bon am-in nadan ngunut da ya nadan limmu da. ");
INSERT INTO ifk_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ot oh-ohhana mo nah nungkampuwan da. Kal-ina di ya wada on immalin tagu ot mumbultung da inggana mungkabigat. ");
INSERT INTO ifk_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mu magibok nan tagun adi pakaipali ke Jacob ot pungkubhilonay gunit di tipana. ");
INSERT INTO ifk_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ot kananay “Agat umeyak tedeyan mungkabigat.” Mu kanan Jacob di “Adi mabalin an ume ka, mahapul an bendisyonanak ni-an.” ");
INSERT INTO ifk_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kanan diyen taguy “Kalyom boh moy ngadan mu.” Ot kanan Jacob di “Ha-oy hi Jacob.” ");
INSERT INTO ifk_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ya kanan diyen taguy “Mipalpud uwani ya bokon mo Jacob di ngadan mu te Israel. Te nakihangga kah tagu ya ke Apu Dios ya nangapput ka.” ");
INSERT INTO ifk_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kanan Jacob di “Nganne poy ngadan mu?” Mu kanan diyen taguy “Adi mahapul an inilaom di ngadan ku.” Ot bendisyonanah Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ot ngadanan Jacob hidiyen bobleh Peniel. Te kananay “Tinibok di angan Apu Dios, mu maphod ta uggeyak nate.” ");
INSERT INTO ifk_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Timmimil di algo handih timmayan hi Jacob ad Penuel an mungge-ek te nungkubhil di gunit nan tipana. ");
INSERT INTO ifk_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ta hidiye nan ingganad uwani ya adi ihdan nadan holag Israel di ulat an nipkot nah gunit di tipan di kumpulmin aggayam te hidiyey nikubhil an gunit Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Tinibon Jacob an mangalih Esau ya nan opat an gatut an ingkuyug na ot pun-aappilona nadan pamilyana ot muntutun-ud da. ");
INSERT INTO ifk_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Impamangulu na nan duwan muttatyuna ya nadan imbabalenan dida ot ahih Leah ya nadan imbabaleda ot ahi nadan hin-ina an da Rachel ke Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mu hi Jacob di namangulu ke didan am-in. Handih mungkih-up da ya nunyuung hi namimpitu ke tulang nan hi Esau. ");
INSERT INTO ifk_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yaden bintik Esau an ena dinammuh Jacob ot awalona ya mungkoga dan duwa. ");
INSERT INTO ifk_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","In-ang-ang Esau ya tinibona nadan binabai ya nadan u-unga ot kananay “Dahdi datuwen ingkuyug mu?” Ya kanan Jacob di “Imbabalek datuwe an indat Apu Dios gapuh homok nan ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Immali nadan duwan muttatyun da Jacob ya nadan imbabaleda ot munyuung dan Esau. ");
INSERT INTO ifk_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nitun-ud hi Leah ya nadan imbabalena ot munyuung da damdama ot ahi uppe da Rachel ke Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Minahmahan bon Esau an kananay “Tipe nadan aaggayam an namangulun dinammuk?” Ya kanan Jacob di “Hidiyey ninomnom kun idat kun he-a ta abulutom di immaliyak.” ");
INSERT INTO ifk_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mu kanan Esau ke hiyay “Tulang ku, adik mahapul dadiye te wada damdamay halun ku, kinali takon di bangngadom ot ya abu.” ");
INSERT INTO ifk_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Mu kanan Jacob di “Abulutom teden inabulut muy immaliyan mi. Ot deyan impatibom di apngam ke dakami ya kay ku tiniboh Apu Dios.” ");
INSERT INTO ifk_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ipapilit Jacob an kananay “Alam ot ya abu tun idat kun he-a te dakol di halun kun indat Apu Dios gapuh homok nan ha-on.” Ot abuluton Esau. ");
INSERT INTO ifk_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Nagibbuy nunhummanganan da ot kanan Esau di “Ot etaku mot ipanguluk di dalan.” ");
INSERT INTO ifk_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mu kanan Jacob ke hiyay “O, mu deyan nakapuy dan mundallan hantudan u-unga. Takon hantudan halun ya nadan impada ya adik honanon dida te indani ya mungkakate da. ");
INSERT INTO ifk_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kinali kudukdulnay mamangulu kayu ta mituntun-ud kami ta takon di mun-ul-ule kami hantudah u-unga ya nadan halun ta ahi dakayu datngan ad Edom.” ");
INSERT INTO ifk_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ot kanan Esau di “Aga mot ibatik di udum hantudah tataguk.” Mu kanan Jacob di “Adi mahapul, mu ta maphod di ipatibom ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ot mibangngad mo da Esau hidid Edom kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mu da Jacob ya numpae dad Sukkot ot mangapya dah kampu da ya hay punhiduman nadan halun da. Kinali nginadanan dah diyen bobleh Sukkot. ");
INSERT INTO ifk_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Intuluy da bon mange nah pangayan da ot loktat ya dimmatong dad Sekem ad Kanaan. Ot mungkampu dan nah nihag-on nah boble. Malinggop di nundallanan da nipalpu handih timmayan dad Mesopotamya ot inggana dimmatngan dad Sekem. ");
INSERT INTO ifk_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ginatang Jacob hidiyen lutah hinggatut an kalang nadah holag Hamor an aman Sekem. ");
INSERT INTO ifk_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ot ngadananah El Elohe an hay kibalinana ya Dios an daydayawon Israel. ");
INSERT INTO ifk_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Waday ohan algo an hi Dinah an babain imbabalen da Jacob ke Leah ya e nakiay-ayyam hanadah binabai kediyen boble. ");
INSERT INTO ifk_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hi Sekem an imbabalen Hamor an Hibite an ap-apu kediyen boble ya tinibonah Dinah ot ena piliton an ihuyop. ");
INSERT INTO ifk_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mu nawaday naminhod Sekem ke Dinah te maddikit, ta hidiye nan makihanummangan ta mun-ine da. ");
INSERT INTO ifk_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kinali na bon amanan hi Hamor an kananay “Eyak ikali nah aammod tun babai te pinhod kun iine.” ");
INSERT INTO ifk_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Hi Jacob ya ininnila nah diyen adi maphod an naat nah imbabalenan babai, mu maid di maat na te ugge immanamut nadan imbabalenan linalakin e numpattol. ");
INSERT INTO ifk_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hi aman Sekem an hi Hamor ya e nakihummangan ke Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Nipaddin diyen mangali nadan imbabalen Jacob an e numpattol ya dingngol dah diyen naat ke tulang da ya nahalman di boh-ol dah e nama-inan Sekem ke didan Hebrew. ");
INSERT INTO ifk_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kanan Hamor ke Jacob di “Nganney innunan deyan impakappinhod tun imbabalek nan imbabalem an hi Dinah? Kinali daan mo anhan ta iabulut mut mun-ine da. ");
INSERT INTO ifk_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Maphod di munhuhummangan taku ta mun-aapu taku. ");
INSERT INTO ifk_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ya miha-ad takuh tun am-in ta takon di daanay tudduwon yuh tun kiha-adan yu ya mabalin. Ya damana bon kumpulnay ngunuwon yuh tu, gumatang kayu ya munggattang kayu hin pinhod yu.” ");
INSERT INTO ifk_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kanan Sekem ke Jacob ya nadah iiban Dinah di “Tobalon yu anhan nan imbagan ama an iinek hi Dinah. Ta kumpulnay ibaga yu ya idat ku. ");
INSERT INTO ifk_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Adi kayu mun-ogon an mangibaga takon di kaatna ya idat ku, mu ta iabulut yun iinek hi Dinah.” ");
INSERT INTO ifk_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mu gapu te ad-adiy inat Sekem ke Dinah ya hinaul nadan linalakin imbabalen Jacob da Sekem an hin-ama. ");
INSERT INTO ifk_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ot kanan day “O, mu adi mabalin an makiine nan ibamin babai nah tagun ugge nakugit te adi maphod ke dakami. ");
INSERT INTO ifk_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mu deket tobalon yu ta mumpakugit kayu ta umat kayun dakami ya damanan iabulut mi. ");
INSERT INTO ifk_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ta mun-aapu taku ya makiboble kamih tu ta munhahayyup taku. ");
INSERT INTO ifk_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mu deket adiyu tobalon an mumpakugit kayun linalaki ya awiton mi nan ibamin babai ya timmayan kamih tu.” ");
INSERT INTO ifk_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Timbal da Sekem an hin-ama te maphod hidiyen eda inhuhummangan. ");
INSERT INTO ifk_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","20","Hi Sekem ya hiyay madayaw am-in hanadah imbabalen Hamor. Gapuh ongal an naminhod na nah imbabalen Jacob ya gahugahu dan hin-aman imme nah kaam-amungan di tatagu nah hoob diyen boble ot kalyon da nadah tataguy ");
INSERT INTO ifk_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Datuwen immalin tatagu ya maphod di pakiib-ibbaan dan ditaku. Maphod ot hin makiboble dan ditakuh tu ya gumatang da ya munggattang da ot deyan ambilog tun boble taku, ta deke ya nakiapu takun dida. ");
INSERT INTO ifk_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mu kanan day tobalon dan makibobleh tu, hin mumpakugit takun am-in an linalaki ta umat takun dida, ta ahida makiapu ke ditaku. ");
INSERT INTO ifk_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kon adi taku tobalon ta makihtu dat kal-ina ot ya ibagi takun am-in nadan halun da ya nadan wadan dida?” ");
INSERT INTO ifk_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Timbal am-in nadan linalaki kediyen boble ot mumpakugit da. ");
INSERT INTO ifk_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nala-uy tulun algoh numpakugitan da an munlolobag nadan kugit da ya imme da Simeon ke Libay an tutulang Dinah an inala day otak da ot idalunu dan numpate nadan linalaki. ");
INSERT INTO ifk_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Impakipate da nadan hin-ama an da Sekem ke Hamor ot awiton da nan ibadan hi Dinah ot mange da. ");
INSERT INTO ifk_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Imme da damdama nadan udum an imbabalen Jacob ot eda pun-ibtik di wada nah boble ta pangibalowan da nah naat nah ibadan babai. ");
INSERT INTO ifk_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Inibtik dan am-in di halun da ya am-in di wada nah boble, ");
INSERT INTO ifk_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","takon nadan nabalol an ngunut. Ya impakiala da nadan u-unga ya binabai. ");
INSERT INTO ifk_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Hi ke Jacob ya kanana ke da Simeon ke Libay di “Hidiyen inat yu ya humlun hi pakibuhhulan nadan tataguh udum an boble ke ditaku. Nungay ta miohha nadan Kanaanite ya Perisite ya nadan udum ta umali dat gubaton ditaku, kon adi ditaku patayon am-in an deyan o-oha taku?” ");
INSERT INTO ifk_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mu kanan day “Bahul da te tipet na-ala ya athidiy nangat da nah ibami an babai an kay maid di bilang nan tagu.” ");
INSERT INTO ifk_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Indani ya kanan Apu Dios ke Jacob di “Mit-an kayud Bethel ta hidiy pumboblayan yu. Mangapya kayuh dih pun-appitan yun ha-on an Dios an numpatibon he-a handih inibtikam hi tulang mun hi Esau.” ");
INSERT INTO ifk_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ot kanan Jacob nadah pamilyana ya nadan makiha-ad ke diday “Iwele yu nadan dios dan kinapyan di tagu ya nun-amo kayu ya numbulwati kayuh malini. ");
INSERT INTO ifk_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tumayan taku ta ume takud Bethel ta mangapyaak hi pun-appitan ke Apu Dios an namanaddang ke ha-on am-in hi ligat ku ya nangipanaptok ke ha-on am-in hi nangayak.” ");
INSERT INTO ifk_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ot idat dan Jacob am-in nadan dios da ya hingat da ot ika-ut na nah puun nan ohan kaiw an oak hidid Sekem. ");
INSERT INTO ifk_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Handih mange da Jacob ya impatakut Apu Dios nadan tatagu nadah nungkih-up an boble ot uggeda pindug dida. ");
INSERT INTO ifk_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Dimmatong dad Lus an hay mo ngadana ya Bethel ad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nangapyah Jacob hi pun-appitan ke Apu Dios hidi ot ngadana nah El Bethel te hidiy numpainilaan Apu Dios ke hiya handih binumtikana gapu ke tulang na. ");
INSERT INTO ifk_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Indani ya nateh Deborah an nangipanaptok ke Rebekah ot ilubuk da nah puun di kaiw an oak an nih-up ad Bethel. Hidiyen kaiw ya nginadanan dah pungkogaan. ");
INSERT INTO ifk_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Handih nibangngadan Jacob an nalpud Mesopotamya ya numpatibo boh Apu Dios ke hiya ot bendisyonana. ");
INSERT INTO ifk_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kanan Apu Dios ke hiyay “Ad uwani ya bokon mo Jacob di ngadan mu te he-a moh Israel.” Ot hituwe moy ngadana. ");
INSERT INTO ifk_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kanan bon Apu Dios di “Ha-oy nan Dios an Kabaelanan amin. Punholagon dakah dakol ta he-ay kalpuwan di nunhihinnatkon an tatagu tuh luta. Ya mumpatul day udum an holag mu. ");
INSERT INTO ifk_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ya hituwen lutan indat kun da apum an hi Abraham ya hi amam an hi Isaac ya ipaboltan kun he-a ya nadan holag mu.” ");
INSERT INTO ifk_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nagibbun kinalin Apu Dios hidiye ot taynana. ");
INSERT INTO ifk_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Immalah Jacob hi batu ot ha-adonah di nah nanib-anan Apu Dios ot duyaganah lana ya mainum ta panginomnomana kediyen naat. ");
INSERT INTO ifk_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ot ngadana nah diyen bobleh Bethel. ");
INSERT INTO ifk_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Indani ya ninomnom bon Jacob an tayanan ad Bethel ot ume dad Eprat. Mu uggeda dimmatong ad Eprat ya inhakit nay putun Rachel ot muntungo. ");
INSERT INTO ifk_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Numpaligat an nuntungo ot handih bimmuddu nan golang ya kanan nan manayay “Maphod kaya, lalaki bo tun intungom.” ");
INSERT INTO ifk_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mu kediye ya mungkaguyud di yahyan Rachel ot ikutyam nan kananay “Hay ngadana ya Ben Oni.” Mu hay impungngadan amana ya Benjamin. ");
INSERT INTO ifk_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nateh Rachel ot ilubuk dah di nah pingngit di dalan an umed Eprat an hidiye nan Betlehem ad uwani. ");
INSERT INTO ifk_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ot ha-adon bon Jacob on batu nah nangilubukan dan Rachel an panginomnomnomana ot ingganad uwani ya dehdi nan batun sinyal nan lubuk. ");
INSERT INTO ifk_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Intuluy bon da Jacob an mange ot mungkampu da nah mala-uwan ad Migdal Eder ot ikapya day kampu dah di. ");
INSERT INTO ifk_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Kediyen niha-adan dah diy nangihuyopan Reuben ke Bilhah an muttatyu dan oha bon inayan amana. Hi Jacob ya ininnila nah diye ot namahig di boh-ol na. Hay ngadan nadan himpulut duwan imbabalen Jacob ");
INSERT INTO ifk_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ya hi Reuben an panguluwan, hi Simeon, hi Libay, hi Judah, hi Issakar, ta ahi uppe Sebulun. Datuwey imbabale dan Leah. ");
INSERT INTO ifk_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ya hay imbabale dan Rachel ya da Joseph ke Benjamin. ");
INSERT INTO ifk_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Hay imbabale da ke Bilhah an muttatyun Rachel ya hi Dan ya hi Naptali. ");
INSERT INTO ifk_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ya hay imbabale dan Silpah an muttatyun Leah ya hi Gad ya hi Asher. Am-in datuwen imbabalen Jacob ya nitungo dad Mesopotamya. ");
INSERT INTO ifk_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Immanamut da Jacob hi kad-an amanan hi Isaac ad Mamre an boblen apunan hi Abraham an nih-up ad Hebron. ");
INSERT INTO ifk_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Kediye ya naka-am-ama moh Isaac an hinggatut ta nawaluy toona. Nate ot ilubuk nadan duwan imbabalenan da Esau ke Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Datuwey nahlag ke Esau an Edom di ohan ngadana. ");
INSERT INTO ifk_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","In-inenay tulun iKanaan an hay oha ya hi Adah an imbabalen Elon an iHittite. Ya nan mikadwa ya hi Oholibamah an imbabalen Anah ya inap-apun Sibeon an iHibite. ");
INSERT INTO ifk_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ya nan mikatlu ya hi Basemat an hi tulang Nebayot an imbabalen Ismael. ");
INSERT INTO ifk_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Hay imbabale dan Ada ya ohan lalaki an hi Eliphas ya oha bon lalakiy imbabale dan Basemat an hi Reuel. ");
INSERT INTO ifk_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ya hay imbabale dan Oholibamah ya tulun linalaki, hi Jeus, hi Jalam, ya hi Korah. Am-in datuwen imbabalen Esau ya nitungod dad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Indani ya ninomnom Esau an mit-an hi ohan boble ta midawwi ke Jacob ot awitona nadan inayana, imbabalena ya nadan tataguna. Impakial-alana nadan haluna ya am-in di nganneh diyen wadan dida ");
INSERT INTO ifk_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","te adi mo gumla nan boble dad Kanaan an mananud hi halun dan hintulang te dimmakol. ");
INSERT INTO ifk_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ot eda miha-ad nah mabilid ad Edom. ");
INSERT INTO ifk_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Datuwey nahlag ke Esau an ammod nadan iEdom. ");
INSERT INTO ifk_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Hi Eliphas an imbabalen da Esau ke Adah ya nahlag ot wadaday liman linalaki, hi Teman, hi Omar, hi Sepho, hi Gatam ya hi Kenas. Ya nikan-om hi Amalek an imbabalenah ohan babain hi Timna. Hi Reuel an imbabalen da Esau ke Basemat ya nahlag ot wadada bo damdamay opat an linalaki, hi Nahat, hi Serah, hi Sammah ya hi Missah. ");
INSERT INTO ifk_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ya nadan imbabalen da Esau ke Oholibamah ya hi Jeus, hi Jalam ya hi Korah. Hi Oholibamah ya imbabalen Anah ya inap-apun Sibeon. ");
INSERT INTO ifk_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Hay imbabalen da Esau ke Adah ya hi Eliphas an panguluwan. Nahlag hi Eliphas ot hi Teman, hi Omar, hi Sepho, hi Kenas, hi Korah, hi Gatam ya hi Amalek. ");
INSERT INTO ifk_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hi Reuel an imbabalen da Esau ke Basemat ya nahlag ot hi Nahat, hi Serah, hi Sammah ya hi Missah an diday aap-apun di holag da. ");
INSERT INTO ifk_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Hanadan imbabalen da Esau ke Oholibamah an imbabalen Anah ya hi Jeus, hi Jalam ya hi Korah ya dida damdamay aap-apun di holag da. ");
INSERT INTO ifk_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Am-in datuwen natonton ya holag Esau. ");
INSERT INTO ifk_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Hanadan datin tatagud Edom ya nahlag da nadah holag Seir an Horite. Datuwe ya hi Lotan, hi Sobal, hi Sibeon, hi Anah, hi Dishon, hi Eser ya hi Dishan. ");
INSERT INTO ifk_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Hi Lotan ya waday tulang nan babai an hi Timna. Hi Lotan di kon imbabalen Hori ya hi Heman. ");
INSERT INTO ifk_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ya hi Sobal ya hiyay aman da Alban, hi Manahat, hi Ebal, hi Sepho ya hi Onam. ");
INSERT INTO ifk_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Hi Sibeon ya wadaday duwan imbabalenan linalakin da Aiah ke Anah. Hituwen hi Anah nan nanamak nah mun-otbol an maatung an danum handih ena impattol nadan kabayun amana nah adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Nahlag hi Anah ot da Dishon ke Oholibamah. Hi Dishon ya hiyay aman da Hemdan, hi Esban, hi Itran ya hi Keran. ");
INSERT INTO ifk_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Hi Eser ya hiyay aman da Bilhan, hi Saaban ya hi Akan. ");
INSERT INTO ifk_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Hi Dishan ya hiyay aman da Us ya hi Aran. ");
INSERT INTO ifk_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Kinali datuwey aap-apun nadan Horite hidid Edom: hi Lotan, hi Sobal, hi Sibeon, hi Anah, hi Dishon, hi Eser ya hi Dishan. Datuwe nadan Horite an nun-ap-apud Edom. ");
INSERT INTO ifk_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Handih maid da ni-an di numpatul ad Israel ya wadada tuwaliy nahanhanot an patul ad Edom. ");
INSERT INTO ifk_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Hay namangulu ya hi Bela an imbabalen Beor an iDinhaba. ");
INSERT INTO ifk_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nateh Bela ot mihannot hi Jobab an imbabalen Serah an iBosrah. ");
INSERT INTO ifk_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nateh Jobab ot mihannot boh Husham an iTeman. ");
INSERT INTO ifk_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nateh Husham ot ahi mihannot hi Hadad an imbabalen Bedad an iAbit. Hituwen hi Hadad nan nangapput nadah iMidian handih nunggugubatan dad Moab. ");
INSERT INTO ifk_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nateh Hadad ot mihannot hi Samlah an iMasrekah. ");
INSERT INTO ifk_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Nateh Samlah ot mihannot hi Saul ad Rehobot an boble nah kad-an di Wangwang an Euphrates. ");
INSERT INTO ifk_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nateh Saul ot mihannot hi Baal Hanan an imbabalen Akbor. ");
INSERT INTO ifk_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nateh Baal Hanan ot mihannot hi Hadad an iPau. Hay inayan Hadad ya hi Mehetabel an imbabalen Matred ya inap-apun Mesahab. ");
INSERT INTO ifk_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hi Esau di nahlagan nadan tatagud Edom an holag da Timna, hi Albah, hi Jethet, ");
INSERT INTO ifk_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","hi Oholibamah, hi Elah, hi Pinon, ");
INSERT INTO ifk_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","hi Kenas, hi Teman, hi Mibsar, ");
INSERT INTO ifk_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","hi Magdiel ya hi Iram an oha on naappil da an nungkingadan di ngadan dah boblen niha-adan da. ");
INSERT INTO ifk_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Hi Jacob ya nunnanong ad Kanaan an boblen da amana. ");
INSERT INTO ifk_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ot athituy na-na-at ke da Jacob. Handih mangat-agu nan imbabalenan hi Joseph an himpulut pituy toona ya naki-kie nadah udum an tutulang nan imbabalen amana ke da Bilhah ke Silpah an e nakipanattol hi halun amada. Deke on waday oggana idatdatong ke amanah adi maphod an at-atton nadan tutulang na. ");
INSERT INTO ifk_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Hi Jacob ya hi Joseph di pakappinhod nan am-in hanadah imbabalena te hiyay nitungo handi mungkaam-ama. Ohan algo ya indatanah bulwatin andukke an makakkaphod. ");
INSERT INTO ifk_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Hanadan tutulang Joseph ya inilmu dan hiyay impakappinhod amada. Ta hidiye mo nan humihhingit dan Joseph ta takon di pakihummanganan dan hiya ya pabinnoh-ol da. ");
INSERT INTO ifk_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Indani ya wada on inin-inop Joseph mipanggep nadah tutulang na ot namam-ay hingit dan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kananay “Athituy inin-inop ku. ");
INSERT INTO ifk_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Imme taku kanun hintutulang hi payo ot etaku pun-uyun nadan nagapas an page. Indani ya naha-ad nan inuyun ku ya nan inuyun yu ya linikkub da ot munyuung da.” ");
INSERT INTO ifk_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ya namam-ay boh-ol dan kanan day “Nganney pinhod mun kalyon? Kon hay kanam ya mumbalin kah patul ta he-ay un-unudon mi?” Bokon ya abuh tuwen in-inop nay pangibobboh-olan dan hiya, mu hana bon atonan mangalkali nah inin-inop na. ");
INSERT INTO ifk_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Indani ya wada boy inin-inop na ot kalkalyona bo nadah tutulang na an kananay “Inin-inop kun nunyuung da kanun ha-oy nan algo ya nan bulan ya hay himpulut ohan bittuwon.” ");
INSERT INTO ifk_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kinalina damdaman amanah diyen in-inop na ya binoh-olan amanan kananay “Nganne boppoh naen in-inop mu! Kon takon di ha-oy ya hi inam ya hantudan iibam ya munyuung kamin he-a?” ");
INSERT INTO ifk_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Gapun diye ya waday amon nadan tutulang Joseph ke hiya. Mu hi ke amana ya ad-addi makaan hi nomnom nah diye. ");
INSERT INTO ifk_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Waday ohan algon imme nadan tutulang Joseph ad Sekem an eda impattol nan halun amada. ");
INSERT INTO ifk_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Ya kanan Jacob ke Joseph di “Miunud ka nadah tutulang mu ta em tibon hin maphod di ma-ma-at ke dida. Ne nibangngad kat ipainilam ke ha-on.” Inun-unud Joseph ot tumayan ad Hebron an boble da ot umed Sekem. Handih dimmatong ");
INSERT INTO ifk_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ya ena hinamahamak dida. Ya wada on tagun nanibon Joseph ot kananan hiyay “An dahdiy em hamahamakon?” ");
INSERT INTO ifk_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ya kanan Joseph di “Nadan tutulang kun e numpattol, mu deyan adiyak pakahamak ke dida. Kon tinibom dida?” ");
INSERT INTO ifk_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kanan nan taguy “Om, mu dingngol kun kanan day ume dad Dothan.” Ot miunud moh Joseph hidi. ");
INSERT INTO ifk_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Handih manatong ya tinibon nadan tutulang na ot ihuhummangan dan patayon da. ");
INSERT INTO ifk_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kanan day “Tuwe nan makangngin-inop. ");
INSERT INTO ifk_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Patayon taku ot ne ingga takuh bitu. Ta deket ibagan ama taku ya kanan takuy kinan di layon. Ta tibon taku peman hin nganney pumbalinan nadan in-inop na.” ");
INSERT INTO ifk_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Dingngol Reuben hidiye ya adina pinhod an patayon da. Ot kananay “Adi taku patayon. ");
INSERT INTO ifk_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kudukdulnay na-ala ya ingga takun nah bitu.” Man-uket kinali nah diye ya nomnomnomonan ahina awiton ta ianamut na ke amada. ");
INSERT INTO ifk_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Dimmatong hi Joseph ya dimpap da ot pungkaan da nan andukken bulwatinan makakkaphod. ");
INSERT INTO ifk_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ot eda ogahon nah bitun maid di danum na. ");
INSERT INTO ifk_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Indani ya tiempon di pinnangan ot mangan da. Kediye ya wadaday tinibo dah tatagun nalpud Gilead an mumpae dad Egypt. Dadiyen tatagu ya holag Ismael an hay ngunuda ya munggattang hi kumpulna. Hanadan kamel da ya dakol di kinarga dan umat nadah mikamoh ihda ya raisin. ");
INSERT INTO ifk_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kanan Judah nadah tutulang nay “Maid di gun-udon takun mamate tuh tulang taku, takon di haulon takuh ama taku. ");
INSERT INTO ifk_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kudukdulnay igattang taku hantudah holag Ismael ta adi taku patayon te tulang taku tut-uwa.” Ya timbal da. ");
INSERT INTO ifk_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ot eda guyudon hi Joseph nah bitu ot igattang dah duwampulun kalang ke dadiyen holag Ismael an umed Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nibangngad hi Reuben ta ena tibon hi Joseph nah bitu ya maid hidi. Ta makahakkit di nomnom na ot pumbik-inay bulwatina. ");
INSERT INTO ifk_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ot umeh kad-an nadan tutulang na ot kananay “Maid hidih Joseph, nganne nin moy atok?” ");
INSERT INTO ifk_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hay mo inat da ya pinate day ohan gulding ot itam-ol da nan bulwatin Joseph nah dala. ");
INSERT INTO ifk_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ot ipatibo dan amada handih immanamutan da. Kanan day “Tinibo mih tuwe nah dalan. Imatunam hin kal-ina hinae nan bulwatin nan imbabalem.” ");
INSERT INTO ifk_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Inimmatunana ot kananay “Om. Hituwe nan bulwatin nan imbabalek. Maid mo anhan an nabanik-i nin di adol nah nangat di mailom aggayam ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ot pumbik-in Jacob di bulwati nah hakit di nomnom na ot hay langgotey ibulwatina. Athidih kaatnay algon u-umyungan gapu kediyen nama-idan nan imbabalena. ");
INSERT INTO ifk_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Immali nadan imbabalena ya nadan inayan dan mangalubyag ke hiya, mu nanongnan u-umyungan. Kananay “Inggana mateyak ta ahik kal-iwan nan imbabalek an nama-id.” ");
INSERT INTO ifk_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Handih indatong dah Joseph ad Egypt ya inggattang da bon Potipar an ap-apun di mungguwalya nah balen di patul. ");
INSERT INTO ifk_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ketuwen tiempo damdamay nanayanan Judah nadah tutulang na ot e makiha-ad nah ohan tagu an hi Hirah an iAdullam. ");
INSERT INTO ifk_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Hidiy nanamuwana nah in-ine nan iKanaan an imbabalen Sua. ");
INSERT INTO ifk_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","5","Ot mawaday tulun imbabalenan linalaki. Hay nungngadan Judah nah panguluwan ya hi Er ya nadan duwan nitun-ud ya hi ina day nungngadan ke dida. Hi Onan di oha ya nan udidiyan ya hi Selah an hiya nan nitungo handih kawada dad Kesib. ");
INSERT INTO ifk_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kimmat-aguh Er an panguluwan ot ipaahawan amana ke hiya on babain hi Tamar. ");
INSERT INTO ifk_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mu hi Er ya namahig an gaga-ihoy atoatonan adi pinhod APU DIOS ot patayona. ");
INSERT INTO ifk_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Athidiy naat ot kanan Judah nah mikadwan hi Onan di “Iinem hi Tamar te hidiyey lebbengnan aton ta deket waday imbabale yu ya mibilang an imbabalen tulang mun nate.” Ot iahawan Onan hi Tamar. ");
INSERT INTO ifk_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mu gapu te inilan Onan an takon di waday imbabaleda ya bokon damdama hiyay mibilang an kon imbabale ya deket nunhuyop da on pakawahona nan malpuh adol nat maid di makapyah golang. ");
INSERT INTO ifk_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hidiyen inat na ya adi pinhod APU DIOS ot patayona bo. ");
INSERT INTO ifk_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ot kanan mon Judah ke Tamar di “Mibangngad ka kattog hi balen da amam ta deket kimmat-aguh Selah ya ahi daka in-ine.” Man-uket kananah di ya umagol te kal-ina bo ya maat ke Selah nan naat nadah duwan iibana. Ot mumbangngad moh Tamar hi balen da amana. ");
INSERT INTO ifk_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Indanit nabaybayag ya nate nan inayan Judah. Imbaluwanah diyen natayan nan inayana ot handih nagibbu ya imme da ke Hirah an gayyum nan iAdullam ad Timnah an eda mangaan hi dutdut di kalneron Judah. ");
INSERT INTO ifk_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Waday nangalin Tamar an immeh Judah an nangapun hiya ad Timnah an e mangaan hi dutdut di kalnerona. ");
INSERT INTO ifk_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ot hannotanah makakkaphod nan imbulwatinan bulwatin di nabalu ot munhukyung ta adi maimatunan di angana ot e um-umbun nah hoob ad Enaim an boblen dalanon an umed Timnah. Man-uket in-athituna ya inilanan kat-agu moh Selah yaden adida ipaahawan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Handih mala-u da Judah ya inang-ang nah Tamar, mu kanana pe on hiya ya oha nadah babain pabpabbayad nay adol na te nunhukyung an nakaluban di angana. ");
INSERT INTO ifk_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ot umeh kad-ana ot kananay “An kaatnay pinhod muh pamayad kuh pangihuyopak ke he-a?” Ya kanan Tamar di “Nangamung ka hin kaatnay pinhod mun idat ke ha-on.” Ugge inilan Judah an hidiye nan inapuna. ");
INSERT INTO ifk_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ya kanan Judah di “Ahik ipaalin he-ay ohan gulding ku.” Ya kanan Tamar di “Damana, mu kah-in di waday idat mud uwani ta deket impialim nan gulding mu ya ahim binangngad.” ");
INSERT INTO ifk_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kanan Judah di “Nganney pinhod mun idat kun he-a?” Ya kananay “Mabalin nan imbanggol mu ya nan patanong mu.” Ot hidiye moy indat Judah ot ahina ihuyop ot mawadaan hi Tamar. ");
INSERT INTO ifk_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Immanamut hi Tamar ot kaanona nan hukyung na ya nan imbulwatina ot ibulwatina bo nan bulwatin di nabalu. ");
INSERT INTO ifk_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Handih intud-ak Judah nan gayyum nan hi Hirah ta iena nan gulding ta bangngadona nah babai nan patanong ya banggol ya maid hidi nan babai. ");
INSERT INTO ifk_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ot ena pun-ibaga nadah linalakih did Enaim an kananay “Daan nan babain pabpabbayad nay adol nan inum-umbun ni-an nah hoob hitu?” Ya kanan day “Maid man di inila mih athinan babaih tu.” ");
INSERT INTO ifk_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ot mibangngad mo ot kalyona ke Judah an kananay “Maid hidi nan babai ya takon nadan linalakih di ya kanan day maid kanuy inila dah athidin babaih di.” ");
INSERT INTO ifk_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ot kanan mon Judah di “Takon kattog di bagina nan indat kun hiya. Te katataw-an dita hin mibangngad tan e manapul ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Indanit nala-uy tuluy bulan ya waday nangidatdatong ke Judah an hi Tamar an inapuna ya numbalin an pabpabbayad nay adol na ot deyan nawadaan. Ya bimmoh-ol hi Judah ot kananay “Eyu palah-unon ta gobhon yu.” ");
INSERT INTO ifk_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mu handih imme da nan e mangalan hiya ya kananay “Eyu ni-an ipatibo tun patanong ya tun banggol ke Judah. Kalyon yun hiyan hay aman tun golang hi putuk ya nan kon bagin datuwe.” ");
INSERT INTO ifk_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Handih eda impatibo ke Judah ya inimmatunana an bagina dadiye ot kananay “Bokon peman bahul Tamar hidiyen naat te uggek inat nan kinalik an ipaahawak ke hiyah Selah.” ");
INSERT INTO ifk_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Handih nadatngan di puntungawan Tamar ya nainila an nundappil nan wadah putuna. ");
INSERT INTO ifk_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kediyen ihakhakkit na ya impabudal nan ohay taklena ot nan babain manaya ya ginakdanah maka-ingit an tinulid. Ot kananay “Hituwey namangulu.” ");
INSERT INTO ifk_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mu indani ya ginuyud nan golang di taklena ot nan ohay bimmudal. Hanan babain manaya ya kananay “Tipet he-ay namangulun bimmudal.” Ot ingadananah Peres. ");
INSERT INTO ifk_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Indani uppe ya bimmudal nan nagakdan di taklena ya lalaki bo ot ngadananah Serah. ");
INSERT INTO ifk_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Handih dimmatngan nadan holag Ismael ad Egypt ya eda damdama inggattang hi Joseph ke Potipar an ap-apun di guwalya nah balen nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hi Joseph ya wadat nangamung APU DIOS an bumaddang ke hiya, kinali handih niha-adanah balen Potipar ya maphod di numbalinan am-in di inat na. ");
INSERT INTO ifk_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ta nan ap-apu an hi Potipar ya inilanan badbaddangan APU DIOS hi Joseph am-in hi ngununa. ");
INSERT INTO ifk_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Kinali ongal di dinol Potipar ke Joseph ot hiyay pumbalinonan mangipaptok am-in hi nganneh diyeh balena ya nadan wadan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ot nipalpun diye, gapu ke Joseph ya binendisyonan APU DIOS am-in nadan makiha-ad hi balen Potipar, takon nadan ingunu dah payona. ");
INSERT INTO ifk_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hi Joseph moy nangiukodan Potipar hi am-in nadan wadah nunhituwana. Abunay oggan ibagan Potipar di pinhod nan kanon. Hi Joseph ya maphod di kinalalaki na ");
INSERT INTO ifk_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ot nabaybayag ya nawaday naminhod nan inayan Potipar ke hiya ta loktat mo anhan ya ayaganan makihuyop ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mu adih Joseph an kananay “Adi mabalin an pa-iyok di ongal an dinol nan apuk ke ha-on. Tibom an indinol nan ha-on am-in di wada tuh baleyu. ");
INSERT INTO ifk_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Man-ut nun-ingngoy kalebbengan min duwa tuh bale, mu he-a ya abuy maid di kalebbengak te ugge daka indinol ke ha-on. Kinali adi mabalin an ek aton di athinan punliwatan ke Apu Dios.” ");
INSERT INTO ifk_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mu adi manghop nan inayan Potipar ta kabigabigat an ayaganah Joseph ta munhuyop da, mu adi pinhod Joseph takon di hay ena pakibkib-unan ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ohan algon hinumgop hi Joseph an ena aton di ngununa ya nipaddin maid nadan muttatyun nah bale, takon di oha. ");
INSERT INTO ifk_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ot ipudon nan inayan Potipar an pilitonan munhuyop da. Mu binumtik hi Joseph nah dola an nabati nan bulwatinan nangid-onan nan babai. ");
INSERT INTO ifk_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Handih tinibon nan babain nabatiy bulwatin Joseph an nanongnan oodnana ya ");
INSERT INTO ifk_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","muntukuk nadah muttatyu dan kananay “Tibon yu key inat nan Hebrew an in-anamut nan inayak. Babainon ditaku! Hinumgop an eyak piliton an ihuyop, mu muntukukak ");
INSERT INTO ifk_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ya binumtik an uggena hinangud tun bulwatina.” ");
INSERT INTO ifk_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ot ena italuh diyen bulwatin Joseph ot had-onan umanamut nan inayana kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ot idatdatong nan kananay “Deya on Hebrew an in-anamut mun na-ala ya hinggopak ta eyak piliton an ihuyop. ");
INSERT INTO ifk_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mu muntukukak ya binumtik ad dolan uggena hinangud tun bulwatina.” ");
INSERT INTO ifk_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ya nahalman di boh-ol Potipar ");
INSERT INTO ifk_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ot ena ipakalabut hi Joseph an inid-um da nadah udum an impakalabut nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mu nanongnay baddang APU DIOS ke Joseph, ta hidiye nan pakappinhod nan ap-apun di kalabut. ");
INSERT INTO ifk_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Impumbalinah Joseph an ap-apun am-in di balud ya hiyay nangamung am-in hi ma-ma-at nah kalabut. ");
INSERT INTO ifk_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Hanan ap-apun di kalabut ya ongal di dinol nah at-atton Joseph te inilanan badbaddangan APU DIOS ta maphod am-in di pumbalinan di atona. ");
INSERT INTO ifk_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Indanit nabaybayag ya bimmungot nan patul te waday numbahulan nan mangapyah tinapay na ya nan mumpaptok hi bayan inumona. ");
INSERT INTO ifk_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ot ipakalabut na dida nah nikalabutan Joseph hi balen nan ap-apun di guwalya. ");
INSERT INTO ifk_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nabaybayag dah di nah kalabut ta loktat ya impumbalin nan ap-apun di guwalyah Joseph an mangipaptok ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ohan hilong ya waday inin-inop dadiyen duwan balud an nunhinnatkon di kibalinana. ");
INSERT INTO ifk_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ta kediyen nabigatana an e tibon Joseph dida ya matibon mabulubulun da. ");
INSERT INTO ifk_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hinanhanana an kananay “Tipet mabulubulun kayu?” ");
INSERT INTO ifk_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ya kanan day “Man-uke ya waday inin-inop mi, mu maid di mangipainilah kibalinana.” Kanan Joseph di “Hi Apu Dios di kalpuwan di kabaelan an mangipainilah kibalinan di in-inop. Kalyon yun ha-on di inin-inop yu.” ");
INSERT INTO ifk_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ot kanan nan mumpaptok hi bayay “Athituy in-inop ku. Wada nan nitanom an grapes an ");
INSERT INTO ifk_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","tuluy hapang na. Indani ya himmabung ot mumbalin hi bunga ya gagalan nal-um. ");
INSERT INTO ifk_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Inodnak nan basun nan patul ot umalaak nah grapes ot pohpohok nah basu ot idat ku nah patul.” ");
INSERT INTO ifk_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ya kanan Joseph di “Hay kibalinan nae ya athitu: Nan tulun hapang ya tulun algo. ");
INSERT INTO ifk_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mala-uy tulun algo ya mipae kat pumbangngadon dakan nah patul nah ngunum tuwali. ");
INSERT INTO ifk_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ya deket anhan ta mibangngad ka nah ngunum ya adiyak kal-iwan ta ahiyak pakikalkali nah patul ta kal-ina ot ya mipaeyak damdama. ");
INSERT INTO ifk_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Te ha-oy ya inibtikak an inilpuwak hi boble min Hebrew ot deyan dehtuwak hi kalabutan mu maid di bahul ku.” ");
INSERT INTO ifk_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Dingngol nan pangapyaon nan patul hi tinapay an maphod di kibalinan nan inin-inop nan ibbana ya kinali na damdaman Joseph di in-inop na. Kananay “Hay inin-inop ku ya waday in-agtuk hi tulun basket. ");
INSERT INTO ifk_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ya nah nuntap-on basket ya waday niha-ad hi mungkaphod an tinapay an kanon nan patul, mu nungkan di hamuti.” ");
INSERT INTO ifk_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kanan Joseph ke hiyay “Hay kibalinan naen tulun basket ya tulun algo. ");
INSERT INTO ifk_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mala-uy tulun algo ya ipaputul nan patul di ulum ya itattayu nay adol mut pungkan di hamuti.” ");
INSERT INTO ifk_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Handih nala-uy tulun algo ya nadatngan di algon nitungawan nan patul ot ayaganan am-in nadan aap-apun pungngunuwona ot munhahamul da. Impalah-una nadan duwan nikalabut an dadiye nan mangapyah tinapay ya nan mumpaptok hi mainum ot paaliyona didah kad-ana. ");
INSERT INTO ifk_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hanan mumpaptok hi bayan inumona ya nipae ot mibangngad nah ngununa tuwali. ");
INSERT INTO ifk_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mu nan mangapyah tinapay ya impipatena. Dadiyen naat ya dadiyey inabig Joseph an kibalinan di in-inop da. ");
INSERT INTO ifk_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mu hanaken mumpaptok hi bayan inumon nan patul ya nakakkal-iwanay mipanggep ke Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nala-uy duwan toon ya inin-inop nan patul an wada nah pingngit di Wangwang an Nile an muntattaddog. ");
INSERT INTO ifk_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kal-ina di ya bimmudal di pitun makatabban baka nah wangwang ot ipayu dan mangan hi holok nah pingngit na. ");
INSERT INTO ifk_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Indani ya bimmudal boy pitun nakuug an baka ot eda mipaldang nadah mataban baka. ");
INSERT INTO ifk_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Indani bo ya kinan da nadan mataban baka. Ya inggibok nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nibangngad an nahuyop ya inin-inop na bo on ohan puun an pagen waday pitun udongnan mabga ya nat-ong. ");
INSERT INTO ifk_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Indani ya timmul-u boy pitun udong, mu nakupo gapu nah maatung an dibdib an malpuh timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Indani bo ya kinan da nadan makabgan page. Inggibok nan patul ot bumangun ya kon ot in-inop na. ");
INSERT INTO ifk_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Handih nabigatana ya mabulubulun nan patul mipanggep nah in-inop na. Ot ipaayag nan am-in nadan nanginilah magic ya nadan nungkanomnoman hidid Egypt. Naamung da ot kalkalyon nan patul ke dida nan in-inop na, mu maid ke diday nanginilah kibalinana. ");
INSERT INTO ifk_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hanan mumpaptok hi mainum ya kanana nah patul di “Handih waday numbahulan mi ot ");
INSERT INTO ifk_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","bumoh-ol kan dakami nah mangapyah tinapay ya ingkalabut dakami nah balen di ap-apun di mungguwalya. ");
INSERT INTO ifk_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ohan hilong ya waday inin-inop min duwan nunhinnatkon di kibalinan da. ");
INSERT INTO ifk_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ya wada on kat-agun Hebrew an ibbamin nikalabut an hiyay nangalih kibalinana. Hituwen Hebrew ya muttatyun nan ap-apun di guwalya. ");
INSERT INTO ifk_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hanan inabig nan kibalinan nan inin-inop mi ya makulug an naat. Deyan ha-oy ke ya nibangngadak hi ngunuk yaden nan mangapyah tinapay ya impipatem.” ");
INSERT INTO ifk_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Dingngol nan patul hidiye ya immitud-ak hi e mangayag ke Joseph nah kalabut. Numpapu-lit ni-an hi Joseph ot hannotanay bulwati nah maphod ot ahi umeh kad-an nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kanan nan patul ke hiyay “Waday inin-inop ku, mu maid di nanginilah kibalinana. Waday nangalin inilam kanuy kibalinan di in-inop.” ");
INSERT INTO ifk_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ya kanan Joseph di “Apu, adik kabaelan, mu hi Apu Dios ya kabaelana.” ");
INSERT INTO ifk_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kanan nan patul di “Nun-in-inopak an wadaak nah pingngit di Wangwang an Nile an muntattaddogak. ");
INSERT INTO ifk_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ya kal-ina di ya wadaday pitun mataban bakan bimmudal nah wangwang ot ipayu dan mangan hi holok nah pingngit na. ");
INSERT INTO ifk_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Indani bo ya bimmudal di pitun bakan nakuug. Dadiyen bakay kaku-kuugan an bakan tinibok hitud Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Indani ya kinan da nadan mataban baka, ");
INSERT INTO ifk_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","mu maid di ena kiang-angan te nanongnan nakuug da. Indani ya inggibok ku. ");
INSERT INTO ifk_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Indanit nayongyongak ya inin-inop ku bon wada on ohan puun an pagen waday pitun udongnan makabga da ya nat-ong da. ");
INSERT INTO ifk_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Indani ya timmul-u boy pitun udong an nakupo gapu nah dibdib an malpuh timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Hanadan nakupo ya kinan da nadan makabga. Kinalik hinaen in-inop ku, mu ugge inilan nadan nanginilah magic di kibalinana.” ");
INSERT INTO ifk_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kanan Joseph ke hiyay “Danaen duwan in-inop mu ya nun-ingngoy kibalinan da. Hi Apu Dios ya impainila nan he-ay atonah udum hi algo. ");
INSERT INTO ifk_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Hanan pitun mataban baka ya nan pitun mabgan page ya nun-ingngon pitun toon di kibalinan da. ");
INSERT INTO ifk_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ya hay kibalinan nan pitun bakan nakuug ya pitun pagen nakupo ya pitun toon an bitil. ");
INSERT INTO ifk_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kinalik dih indani an hi Apu Dios ya impainilanan he-ay ahina aton. ");
INSERT INTO ifk_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hitud Egypt ya waday pitun toon an makabbunga day nitanom an dakol di apiton yu, ta ahi mahawwahawwal di makan. ");
INSERT INTO ifk_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Mu ahi mitun-ud boy pitun toon an bitil. Namahig hidiyen bitil an manadag tuh boble, ta hidiye nan makal-iwan nadan nalana-un toon an dakol di makan. ");
INSERT INTO ifk_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ya man-uket naminduway nangin-inopam ya hidiyey pangipainilaan Apu Dios an makulug an ipaannung na ya gagala ya maat. ");
INSERT INTO ifk_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hay mahapul an atom ya piliyom di ohan nanomnoman ya nalaing ta hiyay nangamung an mangipaptok am-in tuh boble. ");
INSERT INTO ifk_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Ya pumili ka boh udum an aap-apu ta amungon day oha hi liman botok an maani ke dadiyen pitun toon an dakol di makan ta idulin dah aalang nadah kabobboble ya ginuwalyaan da. ");
INSERT INTO ifk_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ta waday makan hantuh kadatngan di pituy toon an bitil ta adi matey tataguh inagang da.” ");
INSERT INTO ifk_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hanan patul ya nadan opisyal na ya timbal dah diyen kinalin Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ot kediye ya kanan nan patul nadah iibba nay “Hay punnomnom ku ya maid di udum hi umat ke Joseph te waday Espiritun Apu Dios ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kanan nan patul ke Joseph di “Deyan he-ay nangipainilaan Apu Dios ke nae ya nainilan maid di udum hi umat ke he-an nanomnoman. ");
INSERT INTO ifk_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tudduwon dakan mihaynod ke ha-on an mun-ap-apu tuh boble ya am-in di tagu ya un-unudon day kalyom. ");
INSERT INTO ifk_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ad uwani ya he-ay munggobernador hitud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ot kaanon nan patul nan singsing hi taklenan namarkaan hi sinyal na ot ihuklub nah gamat Joseph. Hidiyen nangidatan nan patul ke Joseph nah singsing di kitib-anan hiyay tinuddunan munggobernador. Ya indatanah makaphod an bulwati ya impabanggolanah balituk. ");
INSERT INTO ifk_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Indat na pay ke hiya nan punluganan di mihaynod an ap-apud Egypt. Deket waday pangayana ya wadaday mamangulun mangit-itkuk ta kumiwang day tataguh pangipatibo dah lispitu dan hiya. Ot ne hi Joseph moy gobernador ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kanan bon nan patul di “Ha-oy di patul hitud Egypt, mu hin waday nganneh diyen adim iabulut ya adi mabalin an e maat.” ");
INSERT INTO ifk_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Nginadananah Joseph hi Saphenat Paneah an ngadan di iEgypt ya impaahawanan hiyah Asenat an imbabalen Potipera an padid Heliopolis. Handih nangilappuwan Joseph an munggobernador ad Egypt ya tulumpuluy toona. Kediye ya ena tinibon am-in nadan bobleh di. ");
INSERT INTO ifk_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Handih namangulun pitun toon ya makulug an dakol di makan hi kabobbobled Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Impaamung Joseph di inanin di tatagu ot ipadulina nadah aalang an kinapyan di gubilnu nadah boble. ");
INSERT INTO ifk_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Namahig an dakkodakkol di makan an umat hi lona nah pingngit di baybay ta adina mo hangudon an lukudon. ");
INSERT INTO ifk_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Duwa day imbabalen Joseph ke Asenat handih ugge ni-an nadatngan di bitil. ");
INSERT INTO ifk_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Hay nungngadan Joseph nah panguluwan ya hi Manasseh te kananay “Hi Apu Dios di nangalubyag ke ha-on nah ongal an nunligligatak ya nah ek nidawwiyan ke ama.” ");
INSERT INTO ifk_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya nan nikadwa ya nginadananah Eplaim te kananay “Hi Apu Dios di nangidat hi imbabalek hituh boblen nunholholtapak.” ");
INSERT INTO ifk_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Indani ya napoppog nan pitun toon an dakol di makan ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Inlappuna mo nan pitun toon an bitil an hidiye nan kinalin Joseph. Am-in hi kabobboble ya nap-uhan dah makan, mu ad Egypt ya dakol di makan. ");
INSERT INTO ifk_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Indani ya mungkap-uhan damdama nadan tatagud Egypt hi kanon da ot eda mumbaga nah patul. Mu kanan nan patul di “Ekayu mumbagan Joseph, nangamung di kalyona.” ");
INSERT INTO ifk_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Namahig moy bitil ad Egypt ot ipabughul Joseph nadan aalang ot pun-igattang na nadan indulin dan makan hanadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Indani ya mange dad Egypt di tataguh kabobboble tuh luta ta eda gumatang hi makan ke Joseph te namahig di bitil. ");
INSERT INTO ifk_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Dingngol Jacob an waday makan ad Egypt ot kanana nadah imbabalenay “Tipet naala ya munhintotkol kayun matama kayuh aton yu? ");
INSERT INTO ifk_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Deyan dingngol kun wada kanuy makan ad Egypt. Daan mot ekayu gumatang ta adi taku mateh inagang.” ");
INSERT INTO ifk_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ot ume da nan himpulun imbabalen Jacob ad Egypt an e gumatang hi makan. ");
INSERT INTO ifk_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ugge impakien Jacob hi Benjamin te umagol an kal-ina ya wada boy maat damdaman hiya. ");
INSERT INTO ifk_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Dadiyen imbabalen Jacob ya naki-e da nadah udum an tatagun e gumatang hi makan ad Egypt te takon ad Kanaan ya bitil damdama. ");
INSERT INTO ifk_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Hi Joseph an gobernador ad Egypt gumattangan di tataguh makan. Ot ume da nan tutulang na ot munyuung dah hinangngab nah pangipatibo dah lispitu da. ");
INSERT INTO ifk_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Uggeda inimatunan hi Joseph an tulang da. Mu hi Joseph ya inimmatunana dida, mu impatibonan kay na ugge inila dida. Ta makabbungot an kumalin didan kananay “Daanay bobleyu?” Ya kanan day “Nalpu kamid Kanaan. Immali kamin gumatang hi makan.” ");
INSERT INTO ifk_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ya ninomnom Joseph nan in-inop na handi mipanggep ke dida. Ot kananan diday “Man eyu si-siimon tun boble mi ta inilaon yuy ine-ena hin mabalin an apputon dakamih gubat.” ");
INSERT INTO ifk_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kanan day “Apu, maid kattog di athinah nomnom mi te dakamin muttatyum ya immali kami ya abun gumatang hi makan. ");
INSERT INTO ifk_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Adi kami munsiim te maphod di nomnom min immalih tu. Dakami ya hintutulang kami an ohay amami.” ");
INSERT INTO ifk_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mu ipapilit Joseph an kananay “Langkak yu, immali kayun munsiim.” ");
INSERT INTO ifk_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ya kanan day “Adi apu, te dakami ke ya himpulut duwa kamin am-in an hintutulang an imbabalen di ohan tagud Kanaan, mu nama-id di oha ya nan udidiyan ya dehdin nabati ke amami.” ");
INSERT INTO ifk_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Mu hi Joseph ya namahig an ipapilit nan kananay “Adik kulugon hinae. Inilak ot immali kayun munsiim. ");
INSERT INTO ifk_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hay pamatnak ke dakayu ta panginilaak hin bokon langkak nan kinali yu ya adi mabalin an umanamut kayu ingganay umalih tu nan udidiyan yu. Ya hinaen kinalik ya kay mandal damdaman nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kinali umey ohan dakayu ta eyu awiton nan udidiyan yu. Ya dakayun udum ya mikalabut kayu ya maguwalyaan kayu ingganay inilaok an makulug di kinali yu. Te deket langkak ya hidiyey kitib-anan makulug an munsi-siim kayu.” ");
INSERT INTO ifk_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ot ipakalabut Joseph didah tuluy algo. ");
INSERT INTO ifk_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Handih mikatlun algo ya kanan Joseph ke diday “Ha-oy ya hi Apu Dios di un-unudok, kinali adi dakayu pipate hin un-unudon yu tun kalyok. ");
INSERT INTO ifk_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Takon di oha ya abun dakayuy mabatin tuh kalabut ta ume kayun udum ta ie yu nan ginatang yun makan ta adida mateh inagang nadan tinaynan yuh bobleyu. ");
INSERT INTO ifk_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mu mahapul an iali yuh tu nan udidiyan yu ta kitib-anan adi kayu munlangkak, ta adi dakayu pipate.” Ya timbal nadan hintutulang hidiye. ");
INSERT INTO ifk_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Munhuhummangan dan kanan day “Ad uwani ya holholtapon taku mo nan inat taku nah tulang takun hi Joseph. Pihpihmok peyampo ke ditaku, mu ugge taku hinangud.” ");
INSERT INTO ifk_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kanan Reuben di “Kinalik tuwalin adi dakodakol di aton yun hiya, mu adiyak donglon. Deyan mibalo mon ditaku nan ena nama-idan.” ");
INSERT INTO ifk_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hi Joseph ya naawatanah diyen ihuhummangan da, mu uggeda inila te deket makihummangan dan hiya ya waday mangibalin hi kalyon da. ");
INSERT INTO ifk_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tinaynan Joseph dida te adi pakaippol hi koga na. Ot ahi mibangngad ya hi Simeon di impabalud na yaden ang-ang-angon nadan iibana. ");
INSERT INTO ifk_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kinalin Joseph nadah muttatyunan ha-adan da nadan sakuda ya ipabangngad da nadan pihhun imbayad dan itap-o da nadah sakuda. Ya indadaanan da didah balun dan kanon dah dalan. ");
INSERT INTO ifk_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nun-ikarga da nadah kabayu nadan ginatang da ot mange da. ");
INSERT INTO ifk_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Handih nun-iyanan da nah dalan te nahilngan da ya inubad di ohay bobod di sakunat umalah pakanah kabayuna ya tinibona nan pihhun imbayad nan nitap-oh sakuna. ");
INSERT INTO ifk_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kanana nadah tutulang nay “Makayu ket tibon yu, imbangngad da nan imbayad kun dehtun intap-o da tuh sakuk!” Kediye ya timmattakut dan kanan day “Nganne mo anhan hituwen aton Apu Dios ke ditaku?” ");
INSERT INTO ifk_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Immanamut dah boble dad Kanaan ot kalkalyon dan am-in ke amaday na-na-at ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kanan day “Hanan gobernador ya makabbungot an kumalin dakami. Kananay imme kamin munsiim nah bobleda. ");
INSERT INTO ifk_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kanan min hiyay ‘Adi kami munsi-siim te dakami ya maphod kamin tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dakami ya himpulut duwa kamin am-in an hintutulang an ohay amami. Mu nama-id di oha ya nan udidiyan mi ya dehdin nabati ke ama mid Kanaan.’ ");
INSERT INTO ifk_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ya kanan nan gobernador di ‘Hay panginilaak an adi kayu munlangkak ya mibatiy ohan dakayu ta ume kayun udum ta ianamut yu nan ginatang yun makan ta adida mateh inagang nadan tinaynan yu. ");
INSERT INTO ifk_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mu deket umali kayu ya mahapul an ikuyug yu nan udidiyan yu ta panginilaak an bokon langkak nan kinali yun adi kayu munsiim. Ya pabangngadok nan tulang yu ya mabalin bon umali kayun gumatang hi pidwana.’” ");
INSERT INTO ifk_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Indani ot ubadon dan am-in di sakuda ya nipnip-ong nadah saku nadan imbayad dan pihhu. Ya timmakut da, takon hi ama dan hi Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ot kanan ama day “Kon pinhod yun mama-id am-in di imbabalek? Deyan nama-id hi Joseph, deya bon hi Simeon ya ad uwani ya kanan yuy ikuyug yuh Benjamin. Dehtun mam-aon yuy punholholtapak!” ");
INSERT INTO ifk_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mu kanan Reuben ke amanay “Ha-oy di nangamung, ama. Deket adik ianamut ya takon kattog di nan duwan imbabalek di patayom.” ");
INSERT INTO ifk_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mu kanan bon amadan hi Jacob di “Adi mabalin an maki-e tun imbabalek an hi Benjamin ad Egypt. Te inila yun hiya ya abuy natdaan an imbabale min inanan hi Rachel te nama-id nan oha. Kal-ina bo ya waday maat ke hiya nah dalan. Ha-oy ya naam-amaak mo ya mateyak hin mama-id hituwen imbabalek.” ");
INSERT INTO ifk_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mungkilodlod nan bitil ad Kanaan ot ");
INSERT INTO ifk_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","handih nap-u moy kanon da Jacob an hin-am-a ya kanana bon hanadah imbabalenay “Ume kayu bot ekayu gumatang hi kanon taku.” ");
INSERT INTO ifk_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ya kanan Judah ke hiyay “O, mu kanan nan gobernador di adi mabalin an ekami bo gumatang hin adimi ikuyug nan udidiyan mi. ");
INSERT INTO ifk_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kinali deket iabulut mut maki-e ya ume kamit ekami gumatang hi kanon taku. ");
INSERT INTO ifk_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mu deket adim iabulut ya adi kami ume te kanan nan gobernador di ‘Adi mabalin an ekayu bo umalih tu hin adiyu ikuyug nan tulang yu.’” ");
INSERT INTO ifk_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ya kanan ama day “Ya- kon pun-udman yu ot ya abuy kabulubulunak! Antipe bo tuwalit eyu kinalin waday ohan tulang yu?” ");
INSERT INTO ifk_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ya kanan day “Man-uke ya mahapul an humangon miy ibagana. Kananay ‘Kon mataguh amayu ya kon wada pay di tulang yu?’ Nganney panginilaan min mahapul an ikuyug mi nan tulang mi?” ");
INSERT INTO ifk_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ot kanan Judah ke amanay “Iabulut mun maki-eh Benjamin ta adi taku maten am-in hi inagang. ");
INSERT INTO ifk_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Takomboy ha-oy di nangamung. Deket adik ianamut ya ha-oy di kon bahul ta inggana. ");
INSERT INTO ifk_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kon gulat nat ugge kami natanaktak ya numpidwa kami ot mon imme.” ");
INSERT INTO ifk_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ot kanan amaday “Deket athina ne umidadaan kayu nadah mungkaphod an wada tuh boble taku, hay danum di iyyukan, hay mikamoh ihda ya nadan udum an bungan di nitanom ta eyu idat nah gobernador. ");
INSERT INTO ifk_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ya mahapul an maminduway kadakol di pihhuh itabin yu ta ibangngad yu nan pihhun imbangngad dah sakuyu handih pinghanah nangayan yu. Wadan nahimong da. ");
INSERT INTO ifk_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Takon kattog di ikuyug yu tun ibayu ta ume kayu. ");
INSERT INTO ifk_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hi Apu Dios an Kabaelanan am-in di nangamung an mangipaule kediyen gobernador ta homkon dakayun hiya ta ipaenah Simeon ya iabulut na boh Benjamin ta umanamut kayun am-in. Mu kal-ina ket kapyanan waday maat ke dida ya nganney innun.” ");
INSERT INTO ifk_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Inun-unud dah diyen kinalin amada ot umala dah eda idat nah gobernador ot udman day intabin dah pihhu ot ikuyug dah Benjamin ad Egypt. Ot ume dah kad-an nan gobernador an hi Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Handih tinibon Joseph hi Benjamin ya kanana nah muttatyu nan mumpaptok nah balenay “Ipangulum didah bale. Ahida makikan ke ha-on hi maal-algo, kinali kumlong kayuh ihda mi.” ");
INSERT INTO ifk_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inun-unud nan muttatyu ot ipanguluna nadan iiban Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Handih mange nadan hintutulang ya kumanobkob dan kanan dah nomnom day “Man-uke in-ali ditakuh tu ya gapu nah pihhun numbayad takun dih pinghanan nibangngad nadah saku taku. Kal-ina ya nganney aton dan ditaku ya pumbalinon ditakun muttatyuna ya impakialana hantudan kabayu taku.” ");
INSERT INTO ifk_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Dimmatong da nah hogpan hi balen Joseph ya kanan da nah muttatyun mumpaptok hi balenay ");
INSERT INTO ifk_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Apu, dakami nan immali handi an gimmatang hi makan. ");
INSERT INTO ifk_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Mu handih umanamut kami ya tinibo min nipnip-ong nadan pihhun imbayad mi nah tap-on nadan saku mi. Ya uggemi inila hin dahdiy nangiha-ad hidi. Kinali dehtun impakiala mi ta ibangngad mi te immali kami bon gumatang hi ianamut mi.” ");
INSERT INTO ifk_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kanan nan muttatyuy “Adi kayu madanagan ya adi kayu tumakut. Hi Apu Dios an dayawon ama yuy nangiha-ad kediyen pihhu. Te hana ken imbayad yu ya wada an inalak.” Indani ya impabudal nah Simeon ");
INSERT INTO ifk_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ot ahina paghopon didan am-in nah balen Joseph. Nundadaan boh danum hi pun-ulahan dah hukida ot panganona bo nadan kabayu da. ");
INSERT INTO ifk_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hanadan hintutulang ya nun-ukat da nadan idat dan Joseph hi anamutanah maal-algo te dingngol dan makikan dan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Handih immanamut hi Joseph ya indat dan hiya nadan inilpu dah boble dan idat dan hiya ya nunyuung dah punlispitu dan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Imbaga na hin nganney innun da ya kananay “Nganne ta-way innun amayu, an matagu pay?” ");
INSERT INTO ifk_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ya kanan day “Om apu, nanongnan mataguh amami.” Ot munyuung da bon hiya. ");
INSERT INTO ifk_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tinibon Joseph hi Benjamin an tulang nan mismu ya kananan diday “Ah, hiyah tuwe nan udidiyan yu?” Ot kananan Benjamin di “Hi Apu Dios di mumbendisyon ke he-an unga.” ");
INSERT INTO ifk_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Indani ya adi pakaippol hi Joseph hi koga nah nanib-anan tulang na ot manginlalah-un ot umeh kuwartuna ot e kumgah di. ");
INSERT INTO ifk_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Intikod nay koga ot mun-ihu ot ahi bumudal. Ot kalyona nadah muttatyun idadaan day makan. ");
INSERT INTO ifk_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hi Joseph ya naappil an mangan nah ohan lamesaan. Ya nadan tutulang na ya naappil da damdamah ohan lamesaan. Naappil bo nadan iEgypt te adida pinhod an mid-um an makikan hanadah Hebrew te nakababbay panibo dan dida. ");
INSERT INTO ifk_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Hanadan tutulang Joseph ya nah lamesaan hi hinangngab nay inumbunan da ya namodwong da te impumpapaldang da didan nipalpuh panguluwan ingganah udidiyan. ");
INSERT INTO ifk_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hanan kanon da ya malpu nah lamesaan Joseph. Hi ke Benjamin ya dakdakol di indat dan hiyah kanonan maminlimay kadakol na mu hay indat da nadah iibana. Ya mun-an-anla dan am-in an nangan ya nanginum. ");
INSERT INTO ifk_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Handih nundadaan nadan tutulang Joseph an umanamut ya kanana nah muttatyun mangipaptok hi balenay “Punhuduwam di sakudah kabaelan dan kargaon ya ipabangngad mu nadan pihhun imbayad dan itap-om hi sakuda. ");
INSERT INTO ifk_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ya pakiha-ad mu nan basuk an nakapyah silber hi sakun Benjamin.” Ot un-unudon nan muttatyu. ");
INSERT INTO ifk_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nabigat ot humalaman nadan tutulang Joseph an immen ginuyud da nadan kabayu da. ");
INSERT INTO ifk_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Uggeda bo imme-ele ya kanan Joseph nah muttatyu nay “Ekat unudom dida. Deket inakhupam dida ya kanam di ‘Tipet mapmaphod di impatibon nan gobernador ke dakayu yaden eyu inat di adi maphod? ");
INSERT INTO ifk_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tipet eyu inala nan nakangnginan basun nan apuk? Hidiyey pun-inumana ya hidiyey usalonan mun-abig. Ongal an bahul hinaen inat yu.’” ");
INSERT INTO ifk_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ot miunud nan muttatyu ya inakhupana dida ot kalyonan dida nan kinalin Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mu kanan dan hiyay “Apu, nganneh naen pungkalim? Makulug an maid di inat mih athina. ");
INSERT INTO ifk_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Inilam met an imbangngad mi nan pihhun hinamak min nitap-oh sakumi handih immanamutan mid Kanaan. Ya tipe bot ekami umalah basu weno nganneh diyen wadah balen nan gobernador? ");
INSERT INTO ifk_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Agamana, punhamak mun am-in tuh kakarga mi, ta deket wada ya takon di patayon yu nan nangala ya impumbalin dakamin udum an muttatyuna.” ");
INSERT INTO ifk_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ya kanan nan muttatyuy “Mabalin hinae, mu hay pinhod ku ya ammuna nan nangalan mumbalin hi muttatyun Joseph ya nada ken udum ya umanamut da.” ");
INSERT INTO ifk_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ot punloka da nadan karga dan waday oha on inubad nay gakod di sakuna. ");
INSERT INTO ifk_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inlappun nan muttatyun Joseph an manamak nah sakun nan panguluwan. Indanit dinatngana nan sakun nan udidiyan ya hinamak na nan basu. ");
INSERT INTO ifk_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hanadan hintutulang ya numbik-i day bulwati dah hakit di nomnom da. Ot pun-itakke da mo boy kakarga da nadah kabayu da ot mibangngad dan am-in nah boble. ");
INSERT INTO ifk_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Handih dimmatong dah balen Joseph ya deh di ot munyuung dan hiya. ");
INSERT INTO ifk_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ya kanan Joseph ke diday “Nganneh naen inat yu? Kon uggeyu inilan hay umat ke ha-on an mun-abig ya mabalin an inilaonay nangakon diye?” ");
INSERT INTO ifk_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ya kanan Judah di “Uggemi inilay ihumang min he-a, apu gobernador. Ya takon di kalyon miy makulug an ugge kami numbahul ya maid damdamay hilbina te hituwey pangastigun Apu Dios ke dakami hi numbahulan mi. Ta hidiye nan takon kattog di mumbalin kamin am-in hi muttatyum ta adi ammuna nan nangalah basum.” ");
INSERT INTO ifk_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mu kanan Joseph di “Adi mabalin an ek iathina! Ammuna nan nangalah basuk di mumbalin an muttatyuk. Dakayu ken udum ya damanan umanamut kayuh kad-an amayu.” ");
INSERT INTO ifk_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mu nakihummangan hi Judah ke Joseph ot kananay “Apu gobernador, he-a ya niingngoy kalebbengam nah patul, mu donglom anhan tun kalyok ya adika anhan bumoh-ol. ");
INSERT INTO ifk_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Handih lappuna ya minahmaham ke dakami hin waday amami weno hay tulang mi. ");
INSERT INTO ifk_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ot kalyon min waday amami an naam-ama ya waday udidiyan min lalakin niimbabale handih mungkaam-amah amami. Ot kalyon mi bon waday tulang tuwen udidiyan mi, mu nate ta ohana mon natdaan hi imbabalen inana ya hiyay pakappinhod amami. ");
INSERT INTO ifk_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ya kinalim ke dakamin ikuyug mit tibom. ");
INSERT INTO ifk_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ot kalyon min he-a, apu gobernador, an adi mabalin an tayananah amami te kal-ina ya abunadi ya ikaten amami. ");
INSERT INTO ifk_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mu kanam di adi mabalin an ekami bo mumpatibon he-a hin adimi ikuyug hituwen udidiyan mi. ");
INSERT INTO ifk_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kinali handih immanamut kami ya kinali min amamih diyen kinalim. ");
INSERT INTO ifk_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ot handih nap-u nan ginatang mih tun makan ya kanan bon amamiy umali kami bon gumatang. ");
INSERT INTO ifk_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mu kinali min hiya nan kanam an adi mabalin an umali kami boh tu hin adimi ikuyug hituwen udidiyan mi. ");
INSERT INTO ifk_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ya kanan amamiy ‘Inila yun duwa ya abuy imbabale min Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mu nama-id nan oha. Nunna-ud an nabanik-iy adol nah nangat di mailom an aggayam te maid an nibangngad. ");
INSERT INTO ifk_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Deke bot eyu ikuyug tun oha ta waday maat ke hiya ya pun-udman yuy hakit di nomnom ku. Deya bo udot an naam-amaak ya kal-ina ya humlun hi katayak.’ ");
INSERT INTO ifk_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ot ad uwani, apu, deket umanamutak an adi maki-e tun udidiyan mit maid an tibon amami ya makulug an mate te kay nitakap di biyag na ketuwen udidiyan. Kinali deket idatan mih ama mih hakitan di nomnom na yaden naam-ama bo udot, ta mate ya dakamiy kon bahul. ");
INSERT INTO ifk_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Oha bo ya kinalik ke ama min ha-oy di nangamung ketuwen udidiyan mi ta ha-oy di kon bahul ta nangamung hin maid an mibangngad. ");
INSERT INTO ifk_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kinali ibagak anhan ke he-a apu gobernador an takon kattog di ha-oy di pumbalinom an muttatyum ta bokon tun udidiyan ta umanamut ke amami. ");
INSERT INTO ifk_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Te adi metlaing mabalin an eyak umanamut hin maid tun udidiyan mi te adiyak pakaitulid an manibon diyen ad-adin ahi maat ke amami gapuh adina panib-an tuh ibami.” ");
INSERT INTO ifk_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Indani ya adi mo pakaippol hi Joseph an numpainila. Ot palah-unona nadan muttatyuna te pinhod nan ammuna dan hintutulang hi pangalyanan hiya nan tulang da. ");
INSERT INTO ifk_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Namahig di koga na ya dingngol am-in nadan wadah balena ot eda ipainila nah patul. ");
INSERT INTO ifk_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kanana nadah tutulang nay “Ha-oy hi Joseph. Kon makulug an nanongnan mataguh ama?” Mu nadan tutulang na ya adida pakahumang te nahngang da. ");
INSERT INTO ifk_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ot ayagan mon Joseph didat mihmih-up dan hiya ot kanana boy “Ha-oy hi Joseph an tulang yu an inggattang yu handi nadah mumpaalih tud Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mu adiyu pabahulon di adol yu kediyen eyu inat, te hi Apu Dios di kon nomnom an nangipaalih tun ha-oy ta mihwang di tatagud uwanin bitil. ");
INSERT INTO ifk_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Duwan toon mod uwaniy nala-u, mu waday pay di liman toon an umali ta ahi mapoppog nan bitil. ");
INSERT INTO ifk_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Impamanguluwak hitu ke Apu Dios ta ihwang dakayu tuh bitil ta adi taku mateh inagang ta mahlag taku. ");
INSERT INTO ifk_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Makulug an hi Apu Dios di nangipaalin ha-oy hitu, bokon dakayu. Ot pumbalinak an mihaynod nah ap-apu ta ha-oy di nangamung am-in hi ma-ma-at hitud Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kinali aga, gal-an yu ta ume kayu ta kanan yun ama takuy ‘Nan imbabalem an hi Joseph ya impumbalin Apu Dios an gobernador ad Egypt. Kananay ume taku ot ya abun am-in hidi. ");
INSERT INTO ifk_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mumboble takud Goshen hidid Egypt. Takon nadan imbabale taku ya inap-apu taku ya nadan halun taku ya miha-ad dahdi ta mih-up takun hiya. ");
INSERT INTO ifk_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Deket miha-ad takuh di ya hiya kanuy nangamung hi kanon taku te wada pay di liman toon an bitil ya adina pinhod an mate takuh inagang takon nadan halun taku.’” ");
INSERT INTO ifk_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Intuluy bon Joseph an kananay “Maimatunanak ke dakayun ha-oy hi Joseph takon di he-a Benjamin. ");
INSERT INTO ifk_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ipainila yun amay kinatag-ek ketuwen boble ya kalyon yun hiyan am-in nadan tinibo yu. Aga, ekayu ta eyu awiton.” ");
INSERT INTO ifk_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ot awalonah tulang nan hi Benjamin an mungkoga. Takon hi Benjamin ya inawal na damdaman mungkoga. ");
INSERT INTO ifk_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nanongnan mungkogah Joseph ya ena nun-awal nadan udum an tutulang na. Indani ya makihummangan da nuppen hiya. ");
INSERT INTO ifk_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Dingngol nan patul ya nadan opisyal nan immali nadan tutulang Joseph ya immamlong da. ");
INSERT INTO ifk_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kanan nan patul ke Joseph di “Kalyom hanadah tutulang mu ta kargaan da nadan kabayu dah makan ta mibangngad dad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ta eda awiton hi amam ya nadan pamilya da ta umali dah tu ta itudduk ke diday kapkaphodan an lutah tud Egypt ta hidiy kiha-adan dat adida makudangan hi mahapul da. ");
INSERT INTO ifk_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ya kalyom ke didat uminay-un dah punluganan nadan inayan da ya nadan iimbabale da ya ikuyug dah ama yu ta umali dah tu. ");
INSERT INTO ifk_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kalyom bon didan adida kumakkaguh panaynan dad Kanaan te idat kun dida nan kapkaphodan an lutah tud Egypt ta pumboblayan da.” ");
INSERT INTO ifk_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ot tobalon nadan imbabalen Jacob hidiyen kinalin nan patul. Ot mundadaan dan ume ot idat Joseph nadah tutulang nay ahida punluganan ya hay balun dan kanon dah dalan te hidiyey kanan nan patul an atona. ");
INSERT INTO ifk_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Indatana bo didah hin-oh-an bulwatin punhannotan da. Mu hi ke Benjamin ya limay indat na ya indatana pay hi tuluy gatut an kalang. ");
INSERT INTO ifk_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ya hay impae nan amana ya himpulun kabayun nungkarga nadah dakol an makakkaphod an wadad Egypt ya himpulun laban kabayun nungkargah page, tinapay ya nadan udum an mahapul dah dalan. ");
INSERT INTO ifk_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nidadaan am-in ot kananan diday “Ekayu, mu adi kayu bo mun-aawwit nah dalan.” ");
INSERT INTO ifk_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tinaynan day Egypt ot umanamut dad Kanaan hi kad-an amada. ");
INSERT INTO ifk_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Dimmatong da ot kanan dan ama day “Mataguh Joseph an hiyay gobernador ad Egypt.” Mu namodwong hi amada ya adina kulugon. ");
INSERT INTO ifk_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mu kinali dan am-in di impaad Joseph ya inang-ang na nadan punluganan dan impialin Joseph ya kinulug na uppe. ");
INSERT INTO ifk_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ot kananay “Maphod anhan ta makulug an matagu nan imbabalek an hi Joseph! Mahapul an umeyak ta ek tibon ta ahiyak mate.” ");
INSERT INTO ifk_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ot mundadaan da Jacob an impakial-ala dan am-in nadan wadan dida ot umga dan ume. Dimmatong dad Beersheba ot iappitana nan Dios amanan hi Isaac. ");
INSERT INTO ifk_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kediyen hilong ya inin-inop Jacob an numpatiboh Apu Dios an mungkalin kananay “Jacob!” Ot humangon Jacob an kananay “Om, Apu!” ");
INSERT INTO ifk_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ya kananay “Ha-oy nan Dios an dinaydayaw din hi amam! Adika tumakut an umed Egypt. Te ahik ipadakol di holag muh di. ");
INSERT INTO ifk_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Wadaak ta nangamung ke dakayuh pangayan yuh di. Ya ha-oy boy ahi nangamung an mangipabangngad nadah holag muh tu. Ahika mated Egypt ya hantuh mungkatkate ka ya wadah Joseph hi kad-am.” ");
INSERT INTO ifk_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Nabigat ot ilugan bon nadan hintutulang hi amadan hi Jacob, nadan imbabaleda ya nadan inayan da nadah punluganan an impitabin nan patul ot tumayan dad Beersheba. Impakial-alan da Jacob am-in di halun da ya nadan limmu da ad Kanaan ot ume dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Datuwey ngadan nadan holag Jacob an immed Egypt. Hi Reuben an panguluwan ");
INSERT INTO ifk_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ya nadan imbabalenan hi Hanok, hi Pallu, hi Hesron ya hi Karmi. ");
INSERT INTO ifk_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Hi Simeon ya nadan imbabalenan hi Jemuel, hi Jamin, hi Ohad, hi Jakin, hi Sohar ya hi Saul an imbabalena nah ohan babain iKanaan. ");
INSERT INTO ifk_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Hi Libay ya nadan imbabalenan hi Gershon, hi Kohat ya hi Merari. ");
INSERT INTO ifk_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Hi Judah ya nadan imbabalenan hi Selah, hi Peres ya hi Serah. (Nate day duwan imbabalen Judah an da Er ke Onan handih wada dad Kanaan.) Ya wadaday inap-apun Judah an imbabalen Peres an da Hesron ke Hamul. ");
INSERT INTO ifk_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Hi Issakar ya nadan imbabalenan hi Tola, hi Puah, hi Jashub ya hi Simron. ");
INSERT INTO ifk_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Hi Sebulun ya nadan imbabalenan hi Sered, hi Elon ya hi Jahleel. ");
INSERT INTO ifk_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Datuwey nahlag ke da Jacob ke Leah handih kawada dad Mesopotamya an ugge nid-um nan babain hi Dinah. Tulumpulut tuluy bilang dan am-in. ");
INSERT INTO ifk_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Hi Gad ya nadan imbabalenan hi Sephon, hi Haggi, hi Suni, hi Esbon, hi Eri, hi Arodi ya hi Areli. ");
INSERT INTO ifk_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Hi Asher ya nadan imbabalenan hi Imnah, hi Isbah, hi Isbi, hi Beriah ya hi Serah an babai ya nan duwan inap-apun Asher an imbabalen Beriah an da Heber ke Malkiel. ");
INSERT INTO ifk_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Danaen himpulut onom di nahlag ke da Jacob ke Silpah an muttatyun Leah. ");
INSERT INTO ifk_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Hay imbabalen da Jacob ke Rachel ya da Joseph ke Benjamin. ");
INSERT INTO ifk_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Hay imbabalen Joseph hidid Egypt ya da Manasseh ke Eplaim. Hay inada ya hi Asenat an imbabalen Potipera an padid Heliopolis. ");
INSERT INTO ifk_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Hay imbabalen damdaman Benjamin ya hi Bela, hi Beker, hi Asbel, hi Gera, hi Naaman, hi Ehi, hi Ros, hi Muppim, hi Huppim ya hi Ard. ");
INSERT INTO ifk_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Danaen himpulut opat di nahlag ke da Jacob ke Rachel. ");
INSERT INTO ifk_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Ya nada uppen pitun nahlag da Jacob ke Bilhah ya hi Dan ya nan imbabalenan hi Hushim, hi Naptali ya nadan imbabalenan hi Jahseel, hi Guni, hi Jeser ya hi Sillem. Hi Bilhah ya indat Laban ke Rachel an imbabalenat pummuttatyuna. ");
INSERT INTO ifk_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Hay ngam-ut am-in di holag Jacob an immed Egypt an adi makibilang di inayan nadan imbabalena ya nan-om ta onom. ");
INSERT INTO ifk_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Deket mid-um nadan duwan imbabalen Joseph an nitungod Egypt ya napitu da. ");
INSERT INTO ifk_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Handih manatong da Jacob ad Egypt ya impamangulunah Judah ta ena kalyon ke Joseph ta ena damuwon didad Goshen. ");
INSERT INTO ifk_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ot munlugan hi Joseph nah kalesanat ena damuwon hi amanad Goshen. Handih dimmatong ya inawal nah amana ot taganay koga. ");
INSERT INTO ifk_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kanan Jacob ke hiyay “Takombo moy mateyak ot deyan tinibo dakan matagu ka.” ");
INSERT INTO ifk_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ot kanan Joseph ke amana ya nadah tutulang na takon hanadah udum an wadah nunhituwan amanay “Ek ipainilan nah patul an immali kayun nalpud Kanaan. ");
INSERT INTO ifk_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ya kalyok ke hiyan mumpattol di ngunu yu ya inal-ala yun am-in di halun yu ya am-in di wadan dakayu. ");
INSERT INTO ifk_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Deket ipaayag dakayun hiya ta ibagana hin nganney ngunu yu ");
INSERT INTO ifk_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ya kalyon yun nipalpu handih kaunga yu ya mumpattol kayuh halun an umat handidah aammod taku. Te deket hidiyey kalyon yun hiya ya hitud Goshen di ituddunan pumboblayan yu ta maappil kayu nadah iEgypt te pihulon day tatagun mumpattol di ngunuda.” ");
INSERT INTO ifk_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Ingkuyug Joseph di lima nadah tutulang na ot ume dah kad-an nan patul ot eda makihummangan. Kanana nah patul di “Dimmatong da ama ya nadan tutulang kun nalpud Kanaan an impakial-ala dan am-in di halun da ya am-in di wadan dida ya dehdi da mod Goshen.” Ot ipainilana nah patul nan tutulang nan ingkuyug na. ");
INSERT INTO ifk_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ya kanan nan patul ke diday “Nganney ngunu yu?” Ya kanan day “Dakami, apu patul ya hay halun di ipappaptok mi, umat handidah aammod mi. ");
INSERT INTO ifk_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mu deyan ad uwani ya immali kamih tu te nahalman di bitil hidid Kanaan an takon anhan di kanon di halun mi ya maid. Kinali deket iabulut mu ya hidid Goshen di kiha-adan mi.” ");
INSERT INTO ifk_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ya kanan nan patul ke Joseph di “Deyan immali da amam ya nadan iibam ya ");
INSERT INTO ifk_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","nangamung di pinhod dan pumboblayan ya ituddum ke diday Goshen an hidiyey kapkaphodan an lutah tud Egypt. Ya deket wadan diday kabaelanan mumpattol hi halun ku ya iukod mun dida.” ");
INSERT INTO ifk_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ot awiton Joseph hi amanan hi Jacob ot ena ipatibo nah patul. Binendisyonan Jacob nan patul ");
INSERT INTO ifk_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ot kanan nan patul ke hiyay “Kaatnay toon mu?” ");
INSERT INTO ifk_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ya kanan Jacob di “Hinggatut ta tulumpuluy toon kud uwani. Naligat ya antikkey biyag kun adi umat hi biyag handidan aammod kun andukke.” ");
INSERT INTO ifk_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Impidwan Jacob an binendisyonan nan patul ot ahida lumah-un an hin-ama. ");
INSERT INTO ifk_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Inun-unud Joseph di kinalin nan patul ot ituddu na ke amana ya nadan iibana nan kapkaphodan an boblen nih-up nah ongal an bobled Rameses ad Egypt ta hidiy kiha-adan da. ");
INSERT INTO ifk_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Indatan Joseph hi amana ya nadan tutulang nah kanon da mipuun hi bilang di pamilya da. ");
INSERT INTO ifk_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Inlodlod nay bitil, takon ad Egypt ya ad Kanaan ot ma-ma-idan di kanon di tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kinali mahapul an gumatang nadan tataguh makan ke Joseph. Ya deket waday nunggattangana on in-e nah balen nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Indani ya maid moy natdaan hi pihhun nadan tatagud Egypt ya ad Kanaan ot kanan dan Joseph di “Maid moy pihhu mih pangatang mih makan, mu idattan dakami anhan ta adi kami mateh inagang mi.” ");
INSERT INTO ifk_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ya kanan Joseph di “Deket maid moy pihhu yu ya mabalin bon hay halun yuy iali yun ihannot yuh makan.” ");
INSERT INTO ifk_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ot pun-ien nadan tataguy kalnero, gulding, baka, ya kabayu ot dadiyey inhanannot dah makan ke Joseph hi hintoon. ");
INSERT INTO ifk_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nala-uh diyen toon ya nap-u nadan halun nadan tatagu ot ume da bon Joseph ot kanan day “Apu, maid moy ihannot mih makan te nap-uy pihhu mi ya takon di halun mi ya maid moy natdaan. Abuna moy adol mi ya luta mi. ");
INSERT INTO ifk_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Homkon dakami anhan ta adi kami mate. Takon kattog di pummuttatyuwon dakamin nah patul ya hiyay mangiluta nah luta mi. Mu ta idattan dakamih kanon mi ya itanom mi ta ekami bo muntanom ta adi madadag nadan luta mi.” ");
INSERT INTO ifk_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Loktat ya numbalin an lutan nan patul am-in di lutad Egypt te ginatang am-in Joseph ot ibagin nan patul. Am-in nadan iEgypt ya napilit dan nangigattang hi luta da te namahig di bitil. ");
INSERT INTO ifk_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ya numbalin bon am-in nadan tataguh muttatyun nan patul. ");
INSERT INTO ifk_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hay ya abu ugge nigattang an luta ya hay niha-adan nadan papadi te wada tuwaliy id-iddat nan patul hi kanon dat adi mahapul an gumatang dah makan. ");
INSERT INTO ifk_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kanan Joseph nadah tataguy “Deyan ginatang dakayu, takon nadan luta yu ta muttatyu dakayu mon nah patul. Mu idatan dakayuh eyu itanom hi papayo yu. ");
INSERT INTO ifk_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ta deket nadatong ta aniyon yu ya idat yu nah patul di oha hi liman botok ya bagi yu nan udum ta waday kanon yun nadah pamilya yu.” ");
INSERT INTO ifk_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ya kanan nadan tataguy “Umamlong kami te himmok dakamit ugge kami nate. Ot gapu teden maphod kan dakami ya mummuttatyu kamin nah patul.” ");
INSERT INTO ifk_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Impumbalin Joseph an olden hidiye an deket ahiani on indat nadan tataguy bingay nan patul. Ta ingganad uwani ya maun-unud hidiyen olden ad Egypt. Hay ya abu lutan nadan papadiy ugge imbagin nan patul, kinali adi mahapul an idatan dah inani da. ");
INSERT INTO ifk_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hanadan holag Israel ya nunnanong dad Goshen ya loktat ya kimmadangyan da ya dimmakol di imbabaleda. ");
INSERT INTO ifk_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Hi Jacob ya immeh himpulut pituy toon di niha-adanad Egypt ot ahi mate an hay ngam-ut di toon an diye ya hinggatut ta nap-at ta pitu. ");
INSERT INTO ifk_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Handih dandanin mate ya impaayag nah Joseph ot kananan hiyay “Ihakmom di taklem tuh ulpuk ta isapatam an adiyak ilubuk hitud Egypt. ");
INSERT INTO ifk_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Adiyak nimpe ilubuk hitud Egypt, mu eyak ilubuk nah nilubukan nadan aammod ku.” Kanan Joseph di “Om ama, atok hinaen kinalim.” ");
INSERT INTO ifk_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ya kanan Jacob ke hiyay “Mahapul an munsapata ka.” Ot munsapatah Joseph ya nunyuung hi amanan hi Jacob an inihkag na nan patanong na ot mundaydayaw ke Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Indani ya waday nangipainila ke Joseph an mundogoh amana. Ot ikuyug na nan duwan imbabalenan da Manasseh ke Eplaim ot eda tibon. ");
INSERT INTO ifk_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Handih dingngol Jacob an dimmatong da Joseph ya inhanakul nan bimmangun ot umbun nah kahuypana. ");
INSERT INTO ifk_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ot kananan Joseph di “Inilam an handih wada kamid Lus hidid Kanaan ya numpatiboh Apu Dios an Kabaelanan am-in ke ha-on ot bendisyonanak.” ");
INSERT INTO ifk_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kananan ha-on di “Idattan dakah dakkodakkol an holag mut diday kahlagan di nunhihinnatkon an tataguh kabobboble tuh luta. Ya idat kun he-a ya nadan holag muy Kanaan ta didat nangamung di kon luta.” ");
INSERT INTO ifk_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ya kanana boy “Hanan duwan imbabalem an da Eplaim ke Manasseh an nitungoh tud Egypt ot ahiyak umali ya ibilang ku didan imbabalek an umat ke da Reuben ke Simeon an waday boltanon dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mu nan udum an ahim iimbabale ya adi athidi. Hay pangal-an dah boltanon da ya da Eplaim ke Manasseh. ");
INSERT INTO ifk_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Athituy atok te gapun inam an hi Rachel an nated Kanaan nah nih-up ad Eprat handih nalpuwan takud Mesopotamya. Kediyen natayana ya namahig di u-umyunganak hi hakit di nomnom ku. Inlubuk kuh inam nah pingngit di dalan an umed Eprat.” (Hay ngadan di Eprat ad uwani ya Betlehem.) ");
INSERT INTO ifk_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tinibon Jacob nadan imbabalen Joseph ya kananay “An datuwe nadan imbabalem?” ");
INSERT INTO ifk_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ya kanan Joseph di “Om, datuwe nadan imbabalek an indat Apu Dios ke ha-on hitud Egypt.” Kanan Jacob ke Joseph di “Ih-up mu didan ha-on ta bendisyonak dida.” ");
INSERT INTO ifk_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Hi Jacob ya adi tumittibo te am-ama mo. Ot ih-up mon Joseph nadan imbabalena ke hiya ot awalona dida. ");
INSERT INTO ifk_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kanan Jacob ke Joseph di “Handi ya kanak on maid moy ek panib-an ke he-a, mu maphod ta deyan in-abulut Apu Dios an tibon daka, takon hantudan imbabalem.” ");
INSERT INTO ifk_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Impakiwang Joseph nadan imbabalena ot munyuung ke amanan hi Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ot ahina bo pabangngadon didah hinangngab apu dan inha-ad nah Manasseh hi winawwan ya hi Eplaim nah iniggid. ");
INSERT INTO ifk_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mu numpakhiwon Jacob di taklena ta hay ulun Manasseh di nangihakmowanah iggid an taklena ya hi Eplaim nah wawwana yaden hiyay udidiyan. ");
INSERT INTO ifk_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Binendisyonana damdamah Joseph an kananay “Hana ot ta nan dinaydayaw din aammod kun hi Abraham ya hi Isaac an Dios an nangipanaptok ke ha-on ingganad uwani ");
INSERT INTO ifk_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","an hiya nan Anghel an nangihwang ke ha-on ya hiyay mumbendisyon ke datuwen u-unga. Hana ot ta gapun dida ya mundingngol di ngadan ku ya ngadan handidan ammod kun hi Abraham ya hi Isaac. Ya hana ot ta mahlag dat dumakkodakkol da.” ");
INSERT INTO ifk_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mu adi pinhod Joseph hidiyen inat amanan nah ulun Eplaim an udidiyan di nangihakmowanah wawwan an taklena. Ot odnanay taklen amana ot it-anah ulun nan panguluwan an hi Manasseh. ");
INSERT INTO ifk_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kananan amanay “Bokon athina ama, tun panguluwan di pangihakmowam hi wawwan mu.” ");
INSERT INTO ifk_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mu kanan amanay “Om, inilak. Hi Manasseh ya dumakol damdamay holag na. Mu tun udidiyan ya ahi natagtag-e ya ahi mundingngol nadan holag na.” ");
INSERT INTO ifk_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binendisyonana bo didan kananay “Hana ot ta hay ngadan yuy ngadanon di holag Israel hin mumbendisyon dan kanan day ‘Bendisyonan dakayun Apu Dios ta kumadangyan kayu umat ke da Eplaim ke Manasseh.’” Ketuwen kinalin Jacob ya impamangulunan kinaliy ngadan Eplaim an bokon hi Manasseh. ");
INSERT INTO ifk_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kanan Jacob ke Joseph di “Inilak an adi mabayag ya mateyak. Mu ahi dakayu ipaptok ke Apu Dios ta ibangngad dakayuh boblen nadan aammod taku. ");
INSERT INTO ifk_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ya he-a an bokon nadan tutulang muy pangidatak hi Sekem an maluwab di mitanom hidi. Hidiyen boble ya inapput ku nadah Amorite an inusal kuy otak ku ya panak.” ");
INSERT INTO ifk_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Indani ya impaayag Jacob an hi Israel di ohan ngadana am-in nadan imbabalena ot kananan diday “Makayu ta donglon yuy kalyok an ahi maat ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kananan diday “Dakayun imbabalek, donglon yu tun kalyok an hi amayu an hi Israel. ");
INSERT INTO ifk_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","He-a Reuben an panguluwan, he-ay kodhol ku, te he-ay nawada handih kat-aguwak. He-ay makakkatbal ya kalkal-otan. ");
INSERT INTO ifk_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mu he-a ya umat ka nah olwang an kumpulmiy daplugona, ta hidiye nan adi munnanong di kinatag-em gapun nah himpappangen inat mun ha-on an hi amam hi em nangihuyopan nah ohan inayak. ");
INSERT INTO ifk_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Dakayu ke Simeon ke Libay ya nun-ingngo kayun wada di on hay matadom di odnan yu ta pumate kayu gapuh bungot yu. ");
INSERT INTO ifk_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ha-oy an hi amayu ya adik pinhod hinaen at-atton yu an gapuh bungot yu ya pumate kayu, bokon ke bo ya naala on pinate yuy akhupan yun aggayam. ");
INSERT INTO ifk_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kinali hay kastigu yu gapuh bungot yu ya miwahit nadan holag yu hi am-in nah pumboblayan di holag ku. ");
INSERT INTO ifk_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","He-a Judah ya tobalon daka nadah tutulang mu ya he-ay tangadon da ya apputom di buhul mu. ");
INSERT INTO ifk_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mialig ka nah layon an deket kinana nan pinate na ya immanamut ta mahmahhuyop ya umagol dan mamangun ke hiya. ");
INSERT INTO ifk_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Hanadan holag muy ahi mumpatul ya mun-ap-apun mahanhanot da inggana umali nan ohan pinilin Apu Dios an mun-ap-apu ta hiyay un-unudon di tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ya am-in di mahapul na ya wada. Hay itanom nan grapes ya maluwab ya makabbunga ta hi puunay pangigakdanah kabayuna ya makadannum di bunganan damanan pangibalbalanah bulwatina. ");
INSERT INTO ifk_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ya gapuh kadakol di mainum an grapes ya bumatag di matanah panginum na ya mabayak di bob-anah panginumanah gatas. ");
INSERT INTO ifk_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","He-a Sebulun ya miha-ad kah pingngit di baybay an pundag-uwan di bapor ya hay poppog di kiha-adam ya ingganad Sidon. ");
INSERT INTO ifk_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","He-a Issakar ya umat ka nah kabayun nakal-ot, ");
INSERT INTO ifk_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","mu deket tinibo nay mapmaphod an pumpattolan ya immet e mahmahhuyop hidi. Ya gapu te hidiy pinhod nan kiha-adan ya loktat ta numbalin hi muttatyun nan kon lutan diye. ");
INSERT INTO ifk_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","He-a ke Dan ya maandong di pangat mu nadah iibam an holag ku. ");
INSERT INTO ifk_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Mialig ka nah ulog nah pingngit di dalan an wada key mala-uh kabayu ya ikalat nah huki nat mag-a nan nitakke.” ");
INSERT INTO ifk_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Indani ya kanan Jacob di “Hadhad-ok di pangihwangam ke ha-on, APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ya kanana boy “He-a Gad ya wadada key mangakon mamdug ke he-a ya loktat ta he-a ot ya abuy mamdug ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ya he-a Asher, hanah puntanomam ya mawaday mungkaphod an makan an umat hi kanon di patul. ");
INSERT INTO ifk_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","He-a Naptali ya mialig ka nah nibukan makawan makaphod di impada. ");
INSERT INTO ifk_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ya he-a Joseph ya mialig ka nah maluwab ya mabungan nitanom nah waday ob-ob an kumayat nadah dopla. ");
INSERT INTO ifk_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Namahig di hinoltap muh inainat dan he-a an kay daka nunhimpapannaan. ");
INSERT INTO ifk_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","25","Mu uggeka naapput te binaddangan dakan nah Dios ku an ongal di kabaelana. Ta hiya an mangipaptok ke ditakuy kay batun kihikugan takun Hebrew ya idat nan am-in di mahapul mu, umat hi udan ya potang ya nadan danum an malpu nah luta. Ya dumakol di halun mu ya holag mu. ");
INSERT INTO ifk_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Danaen ibendisyon kun hi amam ke he-a hi kiphodam ya maid kiingngohana. Danaen am-in ya umannung ke he-a Joseph an matbal nadah tutulang mu. ");
INSERT INTO ifk_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ya he-a ke Benjamin ya natulid kan umat ka nah kanan dan wolf. Ahim apputon di buhul mu ya nun-ianamut muy maalam ke dida.” ");
INSERT INTO ifk_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Danaey kinalin Jacob nadah himpulut duwan imbabalenan niunnud nah nunhihinnatkon an pangi-eda. ");
INSERT INTO ifk_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Indani ya kanan bon Jacob ke diday “Inilak an dandaniy katek ta eyak mid-um hanadah aammod kun nungkakate. Ya hay pinhod kun pangilubukan yun ha-oy ya hidid Kanaan nah liyang ad Makpelah an dommang di Mamre. Hidiye ya ginatang din hi apun hi Abraham nah Hittite an hi Eplon ot pumbalinonah gungat taku. ");
INSERT INTO ifk_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ot hidiy nilubukan dan himbale ke Sarah, takon da apu yun da Isaac ke Rebekah. Hidi boy nangilubukak ke inayun hi Leah. ");
INSERT INTO ifk_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ilubukak nimpeh di nah liyang nah kad-an di payon ginatang apun hi Abraham nah Hittite.” ");
INSERT INTO ifk_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nagibbun kinalin Jacob dadiye ot mibakilang nah kahuypana ot ipayunan mate. ");
INSERT INTO ifk_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nitongbah Joseph ke amanan in-ipping nan hiya ya mungkoga. ");
INSERT INTO ifk_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Indani ya ena kalyon hanadah mun-embalsamo ot embalsamowon dah amana. ");
INSERT INTO ifk_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Immeh nap-at an algo ot ahida gibbuwon an nun-embalsamo. Ot ibaluwan dah duway bulan ta himpuluy algo te in-un-unud da nah pangat di iEgypt. ");
INSERT INTO ifk_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Napoppog nan pumbaluwan da ot kanan Joseph nadah opisyal nan patul di “Eyu anhan kalyon nah patul tun kalyok: ");
INSERT INTO ifk_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Handih mungkatkateh ama ya impunsapataak ke hiyan ek ilubuk ad Kanaan nah indadaanan kilubukana. Kinali iabulut mu anhan ta ek ilubuk hi ama ne ahiyak bo nibangngad.’” ");
INSERT INTO ifk_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","In-abulut nan patul an kananay “Om, atom nan insapatam ke amam.” ");
INSERT INTO ifk_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ot umeh Joseph an naki-en am-in nadan opisyal nan patul, nadan ap-apu ya nadan madayaw an tatagud Egypt, ");
INSERT INTO ifk_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","nadan pamilyan Joseph ya nadan iibanan holag Jacob. Hay ya abu nataynan ad Goshen ya nadan imbabale da ya nadan halun dan kalnero, gulding ya baka. ");
INSERT INTO ifk_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Naki-e damdama nadan nungkabayu ya nungkalesa ot dakkodakkol dan imme. ");
INSERT INTO ifk_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Handih dimmatong da nah pumpolagan ad Atad hi page an nih-up nah Wangwang an Jordan ya nuntikod da ot namahig di nangibaluwan dan hiya hi pituy algon impangpangulun Joseph. ");
INSERT INTO ifk_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ya nadan iKanaan an nanibon diyen pumbaluwan di iEgypt ya kanan day “Anakkaya bo peman an nahamad di pangibaluwan dah nate.” Ot ngadanan dah diyen boble hi Abel Misraim. ");
INSERT INTO ifk_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hanadan imbabalen Jacob ya inun-unud day kinalin amada ");
INSERT INTO ifk_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ot eda ilubuk ad Kanaan nah liyang ad Makpelah an nih-up ad Mamre an hidiye nan ginatang Abraham nah Hittite an hi Eplon an impumbalinah lubukan di pamilyana. ");
INSERT INTO ifk_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nagibbun inlubuk da Joseph hi amada ot mibangngad dad Egypt an didan am-in hanadah tutulang na ya nadan iEgypt an naki-en dida. ");
INSERT INTO ifk_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Hanadan imbabalen Jacob ya nawaday takut da ke tulang dan hi Joseph handih maid moh amada. Kanan day “Ad uwanin maid moh ama taku ya wadan ibalona nan inat takun hiya.” ");
INSERT INTO ifk_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ot itud-ak day ohan e mangipainila ke Joseph an kanan day “Handih matagu ni-an hi ama taku ya ");
INSERT INTO ifk_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","kinalinan dakamin ibaga min he-at kal-iwam nan gaga-ihon inat min he-a. Kinali deyan ibaga min pasensiyaan dakami anhan an muttatyun nan Dios an dinaydayaw din hi ama taku.” Handih kinali dan Joseph hidiye ya mungkoga. ");
INSERT INTO ifk_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Indani ya immali nadan tutulang na ot munyuung da ot kanan day “Nundadaan kamin mumbalin an muttatyum.” ");
INSERT INTO ifk_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mu kanan Joseph ke diday “Adi kayu tumakut ke ha-on, bokonak hi Apu Dios an munhumalya ya mangastiguh tatagu. ");
INSERT INTO ifk_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Man-ut gaga-ihoh diyen inat yun ha-on, mu impumbalin Apu Dios hi maphod ta mihwang di dakol an tatagu ketuwen bitil. ");
INSERT INTO ifk_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kinali adi kayu tumakut. Ha-oy di nangamung an mangipaptok ke dakayu takon nadan imbabale yu.” Ot maal-alubyag uppey nomnom dah nangngolan dan diye te mauley nungkalin Joseph ke dida. ");
INSERT INTO ifk_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hi Joseph ya am-in nadan iibanan holag amana ya nunnanong dad Egypt. Nate handih immeh hinggatut ta himpuluy toona. ");
INSERT INTO ifk_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Mu maphod udot te tinibo nay inap-apunan imbabalen Eplaim ya hay inap-apun tuwen imbabalena. Takon di hay imbabalen Makir an imbabalen Manasseh ya tinibona dida. ");
INSERT INTO ifk_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Handih kataggun Joseph ya kinalina nadah tutulang nan kananay “Gagala mo ya mateyak, mu nangamung hi Apu Dios an mangibangngad ke dakayu nah boblen kinalinan ipaboltanah holag handin apu takun Abraham, hi Isaac ya hi ama takun hi Jacob. ");
INSERT INTO ifk_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ya hantuh kibangngadan yud Kanaan ya adiyu kal-iwan an ianamut di gunit ku.” Ot isapata dan aton dah diyen kinalina. ");
INSERT INTO ifk_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nate nimpeh Joseph ad Egypt handih hinggatut ta himpuluy toona. Inembalsamo da ot ilungun dah di.");
INSERT INTO ifk_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Datuwey ngadan nadan imbabalen Jacob an naki-en hiyad Egypt an intabin day pamilya da: ");
INSERT INTO ifk_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","hi Reuben, hi Simeon, hi Libay, hi Judah, ");
INSERT INTO ifk_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","hi Issakar, hi Sebulun, hi Benjamin, ");
INSERT INTO ifk_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","hi Dan, hi Naptali, hi Gad ya hi Asher. ");
INSERT INTO ifk_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Napitun am-in di bilang datuwen holag Jacob an Israel di ohan ngadana an nakibilang da Joseph an wada tuwalid Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Indani ya naten am-in datuwen hintutulang takon hi Joseph. ");
INSERT INTO ifk_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mu dakol day imbabale dan nihannot ke dida. Nahlag damdama datuwen imbabale da ot loktat ya dakkodakkol dan nihinap dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nala-uy kaatnan toon ya waday nihannot an patul ad Egypt an uggena inilay mipanggep ke Joseph ya nadan inainat nan kiphodan nan boble da. ");
INSERT INTO ifk_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kanana nadah tatagu nay “Dimmakkodakkol hantudan holag Jacob ta ugge inila ya waday ahida aton ke ditakuh ad-adi. ");
INSERT INTO ifk_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mahapul an waday aton takut adi mad-uman di bilang da. Te wada key gubat ya kal-ina ya mid-um dah buhul taku ta deket inapput ditaku ya taynan da tun boble taku.” ");
INSERT INTO ifk_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ot hay inat nadan iEgypt ya numbalinon da nadan holag Israel an himbut da ot punholholtapon da dida. Tinuddu day makabbungot an porman ot pangunu dan diday nakalligat an ngunu. Impakapya dan dida nadan duwan boble an Pithom ya Rameses an pumbodegaan nan patul. ");
INSERT INTO ifk_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mu deket pun-udman nadan iEgypt di ligat nadan Hebrew ya namam-a ot ya abun mungkadakol dat mungkihinap da, kinali nawaday takut nadan iEgypt ke dida. ");
INSERT INTO ifk_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Ta hidiye nan maid moy homok da ot paligligaton da didah am-in hanadah ipangunu da umat hi ngunuh payo, ya mangapyah bale. ");
INSERT INTO ifk_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Indani bo ya minandal nan patul nadan duwan Hebrew an da Siprah ke Puah an dadiye nadan oggan bumaddang nadah ibba dan binabain Hebrew nah puntungawan da. Kananan diday ");
INSERT INTO ifk_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Deket lalakiy itungon nan babain Hebrew ya patayon yu, mu deket babai ya adiyu.” ");
INSERT INTO ifk_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mu ugge inun-unud datuwen duwan binabaiy kinalin nan patul te tumakut dan APU DIOS ot uggeda pinate nadan linalakin nitungo. ");
INSERT INTO ifk_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kinali impaayag nan patul dida ot kananay “Tipet uggeyu numpate nadan linalakin intungon nadan Hebrew?” ");
INSERT INTO ifk_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Kanan day “Apu, maid di maat mi te hanada ken binabain Hebrew ya adida umat hi binabain iEgypt te nakalakka dan muntungon adi kami dumatong on bimmuddu mo nan golang.” ");
INSERT INTO ifk_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Kinali dimmakkodakkol day holag Israel ya immongngal di kabaelan da. Ya gapuh pangun-unudan datuwen binabai ke Apu Dios ya binendisyonana dida ot malahin da ot mawada damdamay imbabaleda. ");
INSERT INTO ifk_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Indani mo anhan ya in-olden nan patul nadah tatagunan eda pun-iwele nadan linalakin ka-itungon imbabalen di Hebrew nah Wangwang an Nile hidid Egypt, mu adida ilagat nadan binabain ka-itungo. ");
INSERT INTO ifk_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ketuwen tiempo ya waday himbalen holag Libay. ");
INSERT INTO ifk_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nawadaan nan babai ot mun-imbabale ya lalaki. Tinibon nan inana an makakkaphod di kagolang na. Ena it-ittaluh diyen golang hi tuluy bulan. ");
INSERT INTO ifk_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mu handih adina mo mabalin an italu ya immalah basket an papyrus ot pumpudlitanah pukot ta adi humgop di danum. Inhudu na nan golang hidi ot ena iha-ad nah makatlubung nah pingngit di Wangwang an Nile. ");
INSERT INTO ifk_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hanan babain tulang tuwen golang ya wadah din mitmittalu nah e-elena ta tibona hin nganney maat ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Indani ya immali nan babain imbabalen nan patul an e mun-amo nah wangwang yaden nadan binabain muttatyuna ya mundaldallanan da nah pingngit na. Indani ya tinibon nan imbabalen nan patul nan basket an muntaptap-on nah makatlubung ot itud-ak nay oha nadah muttatyuna ot ena alan. ");
INSERT INTO ifk_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Binukatan nan imbabalen nan patul ya wada on golang an lalakin taganay koga ya himmok na. Kananay “Hituwe man bo kattog di oha nadah imbabalen di Hebrew.” ");
INSERT INTO ifk_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ot mih-up nan babain tulang nan golang ot kanana nah imbabalen nan patul di “An pinhod mut eyak umayag hi babain Hebrew ta hiyay mangipaptok tuh golang?” ");
INSERT INTO ifk_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ya kananay “Om, eka.” Ot ume nan babai ot hi inana ot ya abuy inayagana. ");
INSERT INTO ifk_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kanan nan imbabalen nan patul ke hiyay “Awitom tun golang ta ipaptok mut tangdanan daka.” Ot awitona nan golang ot ipaptok na. ");
INSERT INTO ifk_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Naong-ongal nan golang ot ien inana kediyen imbabalen nan patul ot ibilang nan imbabalena. Ya nginadananah Moses an hay kibalinana ya “idakal” te indakal na nah danum. ");
INSERT INTO ifk_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ohan algo, handih kimmat-agu moh Moses ya limmah-un nah balen nan patul ta ena tibon nadan ibbanan Hebrew ya tinibo nay pangipaligligatan nadan iEgypt ke didah ipangunu da. Indani ya tinibona on ohan iEgypt an punhuplit nay oha nadah ibbanan Hebrew ot bumungot. ");
INSERT INTO ifk_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Munwingiwingi ya maid di mangang-ang ke hiya ot patayonah diyen iEgypt ot ika-ut na nah lona. ");
INSERT INTO ifk_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nabigat bo kediye ya tinibonay duwan Hebrew an mun-awwit. E nun-anawa an kanana nah numbahul di “Antipe bot pundaw-em tun ibbam an Hebrew?” ");
INSERT INTO ifk_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mu kanan ot ya abun nan lalakiy “Dahdiy nanuddun he-an mumbalin an ap-apu mi ya huwes mi? An patayonak damdama umat nah inat mu nah iEgypt ad nakugab?” Timmakut hi Moses hi nangngolanan diye an kananah nomnom nay “Ya- ininnilan mon di tataguh diyen inat ku.” ");
INSERT INTO ifk_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Indani tut-uwa ya dingngol nan patul ta ena ot pipateh Moses, mu binumtik ad Midian ot e makibobleh di. Hi Jetro an padid Midian kediyen tiempo ya waday pitun binabain imbabalena. Waday ohan algon um-umbun hi Moses nah bubun ya immali datuwen binabain e humagob hi ipainum da nadah kalnero ya gugulding amada. ");
INSERT INTO ifk_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mu nadan udum an mumpattol ya dinog-al da datuwen binabain imbabalen Jetro. Tinibon Moses hidiye ya nabaal ot ena baddangan didan humagob ot painumana nadan aggayam da. ");
INSERT INTO ifk_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Handih immanamut dadiyen binabai ya kanan ama day “Tipe udot ta imma-aliyan kayud uwani?” ");
INSERT INTO ifk_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ya kanan day “Man-uke ya wada on iEgypt an bimmaddang ke dakami ot painumana nadan aggayam taku.” ");
INSERT INTO ifk_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kanan ama day “Daan hidiyen tagu? Tipet eyu tinaynan? Eyu ayagan ta makikan ke ditaku.” ");
INSERT INTO ifk_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Naki-eh Moses ot loktat ya pininhod nan makiha-ad hi balen da Jetro. Indani ya impaahawan Jetro ke hiyah Sipporah an oha nadah imbabalena. ");
INSERT INTO ifk_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nun-imbabaleh Sipporah lalaki ot ngadanan Moses hi Gersom te kananah nomnom nay “Ha-oy ya hintaguwanak hitu.” ");
INSERT INTO ifk_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nala-uy kaatnan toon ya nate nan patul di Egypt, mu nanongnan munholholtap nadan holag Israel ta namahig di pumpahpahmokan dan Apu Dios hi pumbagaan dah baddang. ");
INSERT INTO ifk_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dingngol Apu Dios hidiyen pumpahpahmokan da ya ninomnom na handin nakitobbalanan Abraham, hi Isaac ya hi Jacob ");
INSERT INTO ifk_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","te inilana tuwalih diyen pumpalpaligat nadan iEgypt nadah holag Israel ot homkona dida. ");
INSERT INTO ifk_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Hi Moses ya hiyay mangipappaptok nadah aggayam nan nangapun hiyan hi Jetro an padid Midian. Ohan algo ya ena impattol dida nah binah-el nan ugge naboblayan ot dumatong ad Sinai an bilid an kawad-an APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Indani ya numpatibo on anghel APU DIOS ke hiya nah mundadalang an ittay an kaiw. Tinibon Moses an man-ut mundadalang nan kaiw, mu ad-addi magbu. ");
INSERT INTO ifk_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Namodwong hi Moses an kananah nomnom nay “Nangimalad mo anhan hituwe, tipe nin ta adi magbu din kaiw? Agannat ek pakatibbon.” ");
INSERT INTO ifk_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tinibon APU DIOS an mungkih-up hi Moses ya kananan hiyay “Moses!” Himmumang an kananay “Om, dehtuwak, Apu!” ");
INSERT INTO ifk_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kanan Apu Dios di “Umohnong kah na. Adika mih-up hitu. Ya kaanom di apatut mu te dehtuwak ketuwen lugal an timmaddogam. ");
INSERT INTO ifk_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ha-oy nan Dios an daydayawon handidan aammod mu an da Abraham, hi Isaac ya hi Jacob.” Ot haniyan Moses di angana te tumakut an mangang-ang ke Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ot kanan bon APU DIOS di “Tinibok di nahalman an ligat nadan tataguk ad Egypt. Ya dingngol kuy pumpahpahmokan dah pumbagaan dah baddang ta matikod di punholholtapan da. Homhomkok dida, ");
INSERT INTO ifk_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","kinali immaliyak ta ihwang ku didah at-atton nadan iEgypt ke dida. Ipakaan ku dida kediyen boble ta ume da nah ambilog an lutan maluwab di mitanom an numboblayan nadan Kanaanite, nadan Hittite, nadan Amorite, nadan Perisite, nadan Hibite ya nadan Jebusite ad uwani. ");
INSERT INTO ifk_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Makulug an dingngol kuy palak nadan holag Israel ya tinibok di pangipaholholtapan nadan iEgypt ke dida. ");
INSERT INTO ifk_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kinali ad uwani ya itud-ak dakat eka makihummangan nah patul di Egypt ta ipangulum nadan tataguk an tumayan hidi.” ");
INSERT INTO ifk_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mu kanan Moses di “Apu, kon dahdiyak an e makihummangan nah patul ta iabulut nat ipanguluk nadan ibbak an holag Israel ta tumayan kamih di.” ");
INSERT INTO ifk_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kanan Apu Dios di “Adika madanagan te wadaak an mamaddang ke he-a. Hay kitib-anan ha-oy di nangitud-ak ke he-a ya athitu: Hantuh pangipanguluwam hanadah tataguk hi panaynan yud Egypt ya ahiyak dayawon ke dakayu ketuwen bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mu kanan Moses di “Mu nungay umeyak hidi ta kalyok nadah holag Israel an intud-akak ke he-an Dios handidan aammod mi ya kanan day ‘Dahdih diyen Dios an pungkalim? Nganney ngadana?’ Nganney panumang ku?” ");
INSERT INTO ifk_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kanan Apu Dios di “HA-OY NAN WADAT NANGAMUNG. Kanam ke diday ‘Hiya an WADAT NANGAMUNG di nangitud-ak ke ha-on.’ ");
INSERT INTO ifk_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kalyom ke didan ha-oy di AP-APU an Dios handidan aammod yun hi Abraham, hi Isaac ya hi Jacob di nangitud-ak ke he-a. Hidiyen ngadan kuy pungngadan di tatagun ha-on ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ume kat amungom nadan ap-apun di holag Israel ta kalyom ke didan ha-oy an AP-APU an Dios din aammod yun da Abraham, hi Isaac ya hi Jacob ya numpatibowak ke he-a. Kalyom ke dida an baddangak dida te tinibok di pumpaholholtap nadan iEgypt ke dida. ");
INSERT INTO ifk_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ninomnom kun pakaanon didad Egypt ta mapoppog di punligligatan da. Ta ipaek dida nah lutan maluwab di mitanom an boblen nadan Kanaanite, Hittite, Amorite, Perisite, Hibite ya nadan Jebusite. ");
INSERT INTO ifk_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ume ka, ot nunna-ud an kulugon daka ke dadiyen aap-apun nadan holag Israel ta ekayu makihummangan nah patul hidid Egypt ta kanan yun hiyay ‘Hanan AP-APU an Dios min Hebrew ya numpatibon dakami ta mahapul an iappitan mi. Kinali iabulut mu anhan ta ume kami nah ugge naboblayan an tulun algoy pundalanan mi ta emi dayawon nan AP-APU an hiya nan Dios mi.’ ");
INSERT INTO ifk_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mu inilak an adina iabulut an ekayu ume hin adik piliton. ");
INSERT INTO ifk_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ta hidiye nan dakol di ahik aton an umipamodwong an kapa-iyan di Egypt ta loktat ya iabulut nan tumayan kayuh di. ");
INSERT INTO ifk_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ya tibok bot ahi maphod di punnomnom nadan iEgypt ke dakayu ta deket ekayu tumayan ya idatan dakayun didah mahapul yu ta waday itabin yu hantuh tumayanan yuh di. ");
INSERT INTO ifk_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ta am-in nadan binabain holag Israel ya eda kumdoh bulwati ya kumpulnan usal di babai umat hi balituk ya silber nadah hinag-on dan binabain iEgypt an kon muttatyun dida. Ta pun-ipahuklub da nadah imbabale dat itabin day kinadangyan nadan iEgypt an kay da inibtik hi gubat.” ");
INSERT INTO ifk_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Hinumang Moses hi APU DIOS an kananay “Mu kal-ina ya adi kulugon nadan holag Israel di kalyok? Ya nganney atok hin kanan day adi makulug an numpatibo kan ha-oy?” ");
INSERT INTO ifk_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ya kanan Apu Dios ke hiyay “Nganne nan inodnam?” Ya kanan Moses di “Patanong.” ");
INSERT INTO ifk_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kanan APU DIOS di “Ibkam nah luta.” Ot ibkan Moses ya numbalin hi ulog ya e ot bumtik te timmakut. ");
INSERT INTO ifk_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mu kanan APU DIOS ke hiyay “Odnam di iwit na.” Ot piditon Moses ya numbangngad bon patanong. ");
INSERT INTO ifk_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Kanan bon APU DIOS di “Hituwe boy atom ta pangitib-an nadan holag Israel an ha-on an AP-APU yu an Dios handidan aammod yun hi Abraham, hi Isaac ya hi Jacob ya makulug an numpatibowak ke he-a. ");
INSERT INTO ifk_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ihwong muy taklem nah bulwatim.” Inihwong Moses di taklena ot guyudona ya naleprosy an kay nakupliyan ta kalulugnin. ");
INSERT INTO ifk_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kanana boy “Ipidwam bon ihwong nan taklem.” Inun-unud Moses ot ihwong na ot guyudona ya nakaan nan kay kupli. ");
INSERT INTO ifk_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ot kanan APU DIOS di “Deket uggeda kinulug nan namangulun milagro ya wada ot an kulugon dah tuwen mikadwan ipatibom. ");
INSERT INTO ifk_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mu deket atom datuwen duwa ya nanongnan kahing da ya umala kah danum nah Wangwang an Nile ta iduyag mu nah luta. Ya hituwen danum ya mumbalin hi dala.” ");
INSERT INTO ifk_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mu kanan Moses di “Apu, bokon ha-oy di itud-ak mu te nganney innun dan mangulug ke ha-on an ha-oy ke ya adiyak pe tuwali mahapit takon ad uwani.” ");
INSERT INTO ifk_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ya kanan APU DIOS ke hiyay “Kon dahdiy nangapyah tokon di tagu? Ya dahdiy mangipalulok weno mangipangangah tagu? Dahdi boy kabaelanan mangulap hi tagu weno maniyat hi matana ta pakatibo? Dahdiy udum an kabaelanan mangat ke datuwe hin bokon ha-oy ya abu an DIOS? ");
INSERT INTO ifk_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kinali eka ot ya abu ot baddangan dakan ha-oy ta ituttuduk di ahim kalyon.” ");
INSERT INTO ifk_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mu kanan bon Moses di “Apu, adiyak! Hay udum di itud-ak mu.” ");
INSERT INTO ifk_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ketuwe ya bimmoh-ol mo anhan hi APU DIOS ke Moses ot kananay “Aga, deket adika pakahappit ya baddangan dakan tulang mun hi Aaron an holag Libay. Inilak an hiya ya mahapit. Wadah dalan an mangalin manamun he-a ya inilak an mun-am-amlong hi panib-an daka. ");
INSERT INTO ifk_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kalyom ke hiya nan pinhod mun kalyon ta hiyay mangali. Ha-oy di mangituttudun dakayuh kalyon yu ya aton yu. ");
INSERT INTO ifk_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Hiyay punhapitom ta kalyona nadah tataguy pinhod mun kalyon ke dida ya he-ay kay Dios an mangalih kalyona. ");
INSERT INTO ifk_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ya tibom ta itabin mu tun patanong te hituwey usalom an mangat hi dakol an milagro.” ");
INSERT INTO ifk_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Immanamut hi Moses ot kanana nah nangapun hiya an hi Jetroy “Iabulut mu anhan ta mibangngadak ad Egypt ta ek papohdanan hin nanongnan matagu nadan iibak hidi.” Ya timbal Jetro ot umgah Moses. ");
INSERT INTO ifk_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ugge ni-an timmayan hi Moses ad Midian ya kimmali boh APU DIOS ke hiya an kananay “Mibangngad kad Egypt ot nate mo nadan naminhod an mamaten he-ah di.” ");
INSERT INTO ifk_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ot puntakkeyon Moses nan inayana ya nadan imbabaleda nah kabayu ot ume dad Egypt an inal-alana nan patanong an kinalin Apu Dios an al-alana. ");
INSERT INTO ifk_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kalyon bon APU DIOS ke Moses di “Deket dumatong kayud Egypt ya adim kal-iwan ta atom hi hinangngab nan patul nadan milagro ot indat kuy kabaelam an mangat ke dadiye. Mu ahik pumbalinon an mangoheh diyen patul ta adina iabulut an tumayan nadan tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kinali mahapul an ahim kanan ke hiyay ‘Kinalin APU DIOS an ibilang na hantudan holag Israel an panguluwan an imbabalena. ");
INSERT INTO ifk_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ya kananay iabulut mu kanu ta ume dan e mundayaw ke hiya an Dios da, muden mangohe ka, kinali patayona nan panguluwan an imbabalem an lalaki.’” ");
INSERT INTO ifk_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Handih mange da Moses ad Egypt ot mungkampu dah dalan ya numpatiboh APU DIOS ya innang an patayonah Moses. ");
INSERT INTO ifk_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Mu immalah uwa nan inayanan hi Sipporah ot kugitona nan imbabale da. Inalana nan bolat an ginogod na ot idahida nah hukin Moses an kananay “Himpappangeh tuwen pangi-e yun mahapul an makugit kayu!” Ot ugge mo pinaten APU DIOS hi Moses gapun diyen inat Sipora. ");
INSERT INTO ifk_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Indani ya intud-ak APU DIOS hi Aaron an e manamu ke Moses nah ugge naboblayan ot e damuwon Aaron ot awalona. ");
INSERT INTO ifk_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ot kalyon Moses ke Aaron am-in nadan kinalin APU DIOS ke hiya takon nadan milagron aton dah kibangngadan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ot mibangngad dad Egypt ot amungon dan am-in nadan aap-apun di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ot kalyon Aaron ke didan am-in nadan kinalin APU DIOS ke Moses. Ya hi Moses ke damdama ya inat na nadan milagro ot tibon dadiyen tatagun naamung, ");
INSERT INTO ifk_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ya kinulug dan intud-ak APU DIOS dida. Ya kediyey nanginilaan dan ongal di homok APU DIOS ke dida nah punholholtapan da ot munyuung da ot dayawon da. ");
INSERT INTO ifk_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Indani ya imme da Moses ke Aaron hi kad-an nan patul di Egypt ot kanan dan hiyay “Hanan AP-APU mi an hiya nan Dios an dayawon min holag Israel ya kananay iabulut mu nadan tatagunat eda maamung nah ugge naboblayan ta mundayaw dan hiya.” ");
INSERT INTO ifk_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mu kanan nan patul di “Dahdi ni-boh naen kanan yun AP-APU yu? Tipet ek un-unudon yaden uggek inila? Adinadaman tumayan kayun holag Israel!” ");
INSERT INTO ifk_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kanan bon da Moses ke Aaron di “Numpatibo ke dakami nan Dios an dayawon min Hebrew. Kinali iabulut mu anhan ta ume kami nah ugge naboblayan an umeh tulun algoy pundalanan ta emi iappitan nan AP-APU an Dios mi. Te deket adimi iathidi ya pundogohon dakamit mungkakate kami weno umitud-ak hi mangubat ke dakamit patayon dakami.” ");
INSERT INTO ifk_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ya kanan nan patul di “Tipet eyu taktakon nadan tatagun pungngunuwok te kon dahdi kayu! Eyu ot kalyon hanadah ibbayu ta eda mungngunu! ");
INSERT INTO ifk_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ad uwani mo udot an dimmakkodakkol kayu mu dakamin iEgypt ya pinhod yun itikod an mungngunu!” ");
INSERT INTO ifk_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kediyen algo ya impaen nan patul di olden hanadah porman nadan himbut an Hebrew ");
INSERT INTO ifk_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","an kananay “Adiyu mo idatan nadan mungngunuh dagamin mikamoh pula an makapyah brick an pundingding ta nangamung dan e manamak. ");
INSERT INTO ifk_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mu tibon yu ta nan datin bilang di oggan da kapyaon an paningding an brick ya hiya damdamah diyey bilang di kapyaon da ya tibon yu ta adi makudangan takon di oha. Mangidlu da tuwali, kinali ibagabaga dan ha-on an iabulut ku kanun eda iappitan nan Dios da. ");
INSERT INTO ifk_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Udman yuy ngunuda ta wadat nangamung di ngunuwon dat maid di innun dan e mundongdongngol hi langkak.” ");
INSERT INTO ifk_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ot e kalyon dadiyen porman hanadah himbut an kanan day “In-olden nan patul an adi dakayu mo idatan hi dagami ");
INSERT INTO ifk_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ta nangamung kayun e manamak, takon di daana. Mu mahapul an nan datin bilang nan kanapyaon yun brick ya hiyah diyey kapyaon yu.” ");
INSERT INTO ifk_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ot hinapon nadan holag Israel di Egypt hi eda panamakan hi dagami. ");
INSERT INTO ifk_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Hanadan porman ya ipilit dan mahapul an nan datin bilang nan oggan da kapyaon an brick ya hidiyey bilang di kapyaon da, takon di diday e manamak hi dagami. ");
INSERT INTO ifk_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ya adida mo kabaelan an kapyaon nan datin bilang di oggan da kapyaon. Ot imal-in nadan iEgypt di boh-ol da nadah holag Israel an napilin porman ot punhoplat da dida. Kanan dan diday “Tipet makudang moy kapyaon yun brick an adi umat handi?” ");
INSERT INTO ifk_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Gapu ketuwe ya imme nadan holag Israel an porman ot eda mundiklamu nah patul. Kanan day “Apu patul, tipet athituy pangat yun dakami? ");
INSERT INTO ifk_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Intikod yun umidat hi dagami yaden ipapilit yun kapyaon miy umat metlaing hi kadakol di kapyaon mi handi, ta deyan punhoplat dakami yaden bokon mi bahul.” ");
INSERT INTO ifk_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ya kanan nan patul di “Makahigga kayu ot tuwalin adiyu pinhod an mungngunu, kinali wadadan dakayuy nangibagan ha-oy an iabulut dakayun e mun-appit nah AP-APU yu. ");
INSERT INTO ifk_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mibangngad kayu ot ya abu ta ekayu mungngunu! Adi kayu midatan hi dagami, mu mahapul an kapyaon yuy umat nah datin bilang di brick an oggan yu kapyaon.” ");
INSERT INTO ifk_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kediye mo ya ininnilan nadan porman an holag Israel an maid di maat da nah nimandal ke didan aton da, mu mahapul an un-unudon dat kabigabigat ya mangapya dah brick, takon di maid di midat ke didah dagami. ");
INSERT INTO ifk_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Handih limmah-un da nah balen nan patul ya tinibo dah Moses ke Aaron an munho-ho-od ke dida, ");
INSERT INTO ifk_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ot kanan dan diday “Kastiguwon dakayun APU DIOS te inilanan hinaen inat yuy humlun hi bumobboh-olan nan patul ya nadan opisyal nan dakami. Om, hinaen inat yuy gumapuh pamatayan dan dakami.” ");
INSERT INTO ifk_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Gapu kediyen naat ya nakihummangan boh Moses ke APU DIOS an kananay “Tipet iabulut mun eda munholholtap hantudan tatagum? Kon hituwey gapunah nangitud-akam ke ha-on hitu? ");
INSERT INTO ifk_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tipet nipalpu handih nakihummanganak nah patul mipanggep nah kinalim ke ha-on ya pun-imam-ana ot ya abuy pangipaholholtapana hantudah tatagum yaden maid di kanam on baddangam dida!” ");
INSERT INTO ifk_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hinumang APU DIOS hi Moses an kananay “Ad uwani ya tibom di atok nah patul ta mapilit an mangiabulut an tumayan kayun tataguk hina. Hay kakulugana ya hiyay ahi mangipilit an makaan kayu nah boble da ten tibonay atok gapuh ongal an kabaelak. ");
INSERT INTO ifk_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Numpatibowak ke da Abraham, hi Isaac ya hi Jacob, mu hay inila dah ngadan ku handi ya Dios an Kabaelanan am-in. Uggeda inilah tuwen ngadan kun impainilak ad uwani an ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Kinalik ke didan diday pangidatak nah bobled Kanaan an nakiboblayan da handi. ");
INSERT INTO ifk_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ad uwani ya ipaannung kuh diyen kinalik ke dida te dingngol kuy pumpahpahmokan nadan holag Israel an impumbalin nadan iEgypt an himbut. ");
INSERT INTO ifk_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","7","Kinali kalyom hanadah ibbam an holag Israel an kanak di ‘Ha-oy di AP-APU. Ipatibok di ongal an kabaelak nah namahig an pangastiguk nadah iEgypt ta patikodok di nihbutan yun dida ya mihwang kayu nah punholholtapan yu. Ya hantuh pangatak ketuwe ya inilaon yu an ha-oy di AP-APU an Dios yu ya dakayuy tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ipangulu dakayu nah boblen insapatak an idat ku ke da Abraham, hi Isaac ya hi Jacob ta dakayuy mamoltan kediyen boble. Ya nomnomon yun ha-oy di AP-APU.’” ");
INSERT INTO ifk_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Impainilan Moses nadah ibbanan holag Israel hituwen kinalin Apu Dios, mu adida mo kulugon, gapuh nahalman an punligligatan da. ");
INSERT INTO ifk_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Indani ot kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ekat em kalyon nah patul di Egypt an mahapul an iabulut nat tumayan kayun holag Israel hina.” ");
INSERT INTO ifk_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mu kanan Moses di “Ta deyan takon nadan ibbak an holag Israel ya adida kulugon di kalyok, ot immam-anan diyen patul an adiyak kulugon te adiyak mahapit.” ");
INSERT INTO ifk_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ot mandalon APU DIOS da Moses ke Aaron an kananan diday “Ume kayu mon duwat eyu kalyon nah patul ya nadah holag Israel an in-olden kun ipangulu yu nadan holag Israel an tumayan hinad Egypt.” ");
INSERT INTO ifk_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Datuwey tonton nadan udum an holag Jacob: hi Reuben an panguluwan ya opat di imbabalenan linalakin hi Hanok, hi Pallu, hi Hesron ya hi Karmi. Datuwe nadan mangipangpanguluh puun di pamilyan Reuben. ");
INSERT INTO ifk_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Hi Simeon ya onom di imbabalenan linalakin hi Jemuel, hi Jamin, hi Ohad, hi Jakin, hi Sohar ya hi Saul an imbabalena nah inayanan iKanaan. Datuwe nadan mangipangpanguluh puun di pamilyan Simeon. ");
INSERT INTO ifk_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Hi Libay ya tuluy imbabalenan linalakin hi Gershon, hi Kohat ya hi Merari. Hi Libay ya hinggatut ta tulumpulut pituy toona ot mate. ");
INSERT INTO ifk_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Nahlag hi Gershon hi duwan linalaki ot hi Libni ya hi Simei. Nahlag damdama datuwe ot dumakol di holag da. ");
INSERT INTO ifk_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Nahlag boh Kohat hi opat an linalaki ot hi Amram, hi Ishar, hi Hebron ya hi Ussiel. Hay toon Kohat handih natayana ya hinggatut ta tulumpulut tulu. ");
INSERT INTO ifk_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Nahlag damdamah Merari hi duwan linalaki ot hi Mahli ke Mushi. Am-in datuwen nangadan ya imbabalen Libay ya nadan holag da. ");
INSERT INTO ifk_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Hi Amram ya in-ine nah Jokebed an tulang amanan hi Kohat. Nahlag da ot wada da Aaron ke Moses. Hay toon Amram handih natayana ya hinggatut ta tulumpulut pitu. ");
INSERT INTO ifk_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Nahlag damdamah Ishar hi tulun linalaki ot hi Korah, hi Nepheg ya hi Sikri. ");
INSERT INTO ifk_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Nahlag hi Ussiel hi tulun linalaki ot hi Mishael, hi Elsaphan ya hi Sitri. ");
INSERT INTO ifk_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","In-inen Aaron hi Elisheba an tulang Nashon an imbabalen Amminadab ot hay imbabale da ya hi Nadab, hi Abihu, hi Eleasar ya hi Itamar. ");
INSERT INTO ifk_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Hi Korah ya nahlag hi tulun linalaki ot hi Assir, hi Elkanah ya hi Abiasap. Dida nadan makalin holag Korah. ");
INSERT INTO ifk_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Hi Eleasar an imbabalen Aaron ya in-inenay oha nadah binabain imbabalen Putiel ot mahlag da ot hi Pinehas. Am-in datuwen nangadan ya dida nadan mangipangpanguluh holag Libay ya nadan pamilya da. ");
INSERT INTO ifk_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Da Aaron ke Moses an nangadan ketuwen tonton di minandal APU DIOS an e mangipangulu nadah holag Israel ta tumayan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ya diday nakihummangan nah patul di Egypt ta iabulut nan tumayan nadan holag Israel hidi. ");
INSERT INTO ifk_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Handih kimmalih APU DIOS ke Moses ad Egypt ya ");
INSERT INTO ifk_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kananay “Ha-oy an DIOS, kalyom nah patul ad Egypt am-in tun kalyok ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mu kanan Moses di “Inilam an adiyak pe kattog mahapit, nganney innun nan patul an mangulug ke ha-on?” ");
INSERT INTO ifk_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ya kanan APU DIOS ke Moses di “Idatan dakah ongal an kabaelam ta he-ay mangitakdog ke ha-on nah hinangngab nan patul di Egypt ya hi tulang mun hi Aaron di kay mu profetas. ");
INSERT INTO ifk_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kalyom ke Aaron am-in di kalyok ke he-a ta hiyay mangali nah patul ta iabulut nat tumayan kayun holag Israel ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","5","Mu pumbalinok nan patul an mangohe ta adi dakayu un-unudon takon di dakol di atok an katatakut ad Egypt. Namahig di ahik pangastigu nadah iEgypt ta ahi dakayu ipangulun ha-on an tataguk ta tumayan kayu. Kediyey ahida panginilaan an ha-oy di AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ot aton da Moses ke Aaron am-in di kinalin APU DIOS an aton da. ");
INSERT INTO ifk_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Kediyen tiempon nakihummanganan da nah patul ya nawaluy toon Moses ya hi ke Aaron ya nawalut tulu. ");
INSERT INTO ifk_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kanan APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Deket ibagan nan patul an mahapul an aton yuy ohan milagro ta panginil-an dan intud-ak dakayun ha-on ya kalyom ke Aaron ta ibkana nan patanong nah hinangngab nan patul. Ya hidiyen patanong ya mumbalin hi ulog.” ");
INSERT INTO ifk_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ot ume da Moses ke Aaron hi balen di patul ot aton dah diyen kinalin APU DIOS. Inibkan Aaron nan patanong nah hinangngab nan patul ya nadan opisyal na ya numbalin nan patanong hi ulog. ");
INSERT INTO ifk_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","12","Mu inayagan damdaman nan patul am-in nadan nungkalaing ya nadan kabaelan dan mangat hi magic ot ibka day papatanong da nah hinangngab na ya numbalin da damdamah ulog. Mu inukmun nan ulog Aaron dida. ");
INSERT INTO ifk_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mu mangohe nan patul an adina kulugon da Moses ke Aaron an hidiye tuwaliy kinalin APU DIOS an maat. ");
INSERT INTO ifk_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Indani ya kanan bon APU DIOS ke Moses di “Deyan mangohe nan patul an adina iabulut an tumayan kayun tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kinali, ume kat em dammuwon hi biggatnah pangayana nah Wangwang an Nile ya hin-od muh pingngit na. Ya al-alam nan patanong an impumbalin mu ni-an hi ulog. ");
INSERT INTO ifk_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kanam ke hiyay ‘Intud-akak nah AP-APU an Dios min Hebrew ta kalyok ke he-at iabulut dakamin e mundayaw ke hiya nah ugge naboblayan. Mu gapu te ingganad uwani ya adim tobalon, ");
INSERT INTO ifk_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ya kananay inilaom mod uwani an hiyay AP-APU nah ahina aton. Ihoplat ku tun patanong tuh Wangwang ta mumbalin hi dala nan danum. ");
INSERT INTO ifk_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ahi mungkakate nadan dolog ta humamuy di danum ta himpappangen adi mabalin an eyu inumon.’ ");
INSERT INTO ifk_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ya kalyom damdama ke Aaron ta ena idongdong nan patanong na nadah wangwang, wa-el ya lobong hinad Egypt ta mumbalin am-in nadan danum hi dala takon nadan hinagob da.” ");
INSERT INTO ifk_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Inat da Moses ke Aaron hi hinangngab nan patul ya nadan opisyal na nan kinalin APU DIOS an aton da. Inhoplat Aaron nan patanong na nah danum nah wangwang ot mumbalin hi dala. ");
INSERT INTO ifk_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ya nungkakate nadan dolog ot humamuy nan danum ta adi mo mabalin an inumon nadan iEgypt. Am-in di danum ad Egypt ya numbalin hi dala. ");
INSERT INTO ifk_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mu impumbalin damdaman nadan mangat hi magic an iEgypt di danum hi dala. Kinali, mangohe nan patul an adina kulugon da Moses ke Aaron an hidiye tuwaliy kinalin APU DIOS an maat. ");
INSERT INTO ifk_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mu ugge hinangud nan patul hidiyen naat, ot umanamut hi balena. ");
INSERT INTO ifk_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ot waday oha nadah iEgypt ya nungka-ut hi bubun nah pingngit di wangwang ta waday pangal-an dah danum an inumon da te numbalin am-in nan danum nah wangwang hi dala. ");
INSERT INTO ifk_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nala-uy pitun algo nipalpu handih impumbalin APU DIOS nan Wangwang an Nile hi dala. ");
INSERT INTO ifk_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Indani ya kimmali boh APU DIOS ke Moses an kananay “Ume ka bo nah patul ta kanam ke hiyay ‘Kinalin nan AP-APU min iabulut mut ume kamin tatagunan e mundayaw ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Te deket mangohe ka ya ipaali nay dakol an bakbak ta umapnal da tuh boble yu. ");
INSERT INTO ifk_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Makakkapnuy Nile ta mangali day udum tuh balem takon hanadah balen nadan opisyal mu ya tatagum. Humgop dah kukuwartum ya ume dah kamam di udum ya mange day udum nah punha-angan yu ya nadah babanga yu. ");
INSERT INTO ifk_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Takon di daanay kad-an yu nadah tatagum ya opisyal mu ya umali day bakbak ke dakayu.’ ");
INSERT INTO ifk_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ne kinalim ke Aaron ta ena idongdong nan patanong na nadah wangwang, wawa-el ya lobong hinad Egypt ta bumudal day dakol an bakbak ta umapnal da nah boble.” ");
INSERT INTO ifk_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ot e idongdong Aaron nan patanong na nadah waday danum ya bimmudal di dakol an bakbak ot umapnal dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mu athidi damdamay inat nadan mangat hi magic an iEgypt an impabudal day dakol an bakbak. ");
INSERT INTO ifk_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Impaayag nan patul da Moses ke Aaron ot kananan diday “Mundasal kayu nah AP-APU ta kaanona datuwen bakbak ta iabulut kun ume kayun tataguna ta eyu iappitan nan AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kanan Moses di “Gutudom di algo ta idasalan dakayun am-in hanadah opisyal mu ya tatagum ta mama-id hantudan bakbak ta ammuna nah Wangwang an Nile di kiha-adan da.” ");
INSERT INTO ifk_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kanan nan patul di “Hi bigat.” Ot kanan Moses di “Damana hin hinaey pinhod mu ta panginilaam an maid di udum an Dios an umat nah AP-APU an Dios mi. ");
INSERT INTO ifk_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mama-id hantudan bakbak an mamulubulun ke dakayun am-in hanadah opisyal mu ya tatagum ta ammuna nah Wangwang an Nile di kiha-adan da.” ");
INSERT INTO ifk_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tinaynan da Moses ke Aaron nan patul ot mundasal hi Moses ke APU DIOS ta kaanona nadan dakol an bakbak an impaalina. ");
INSERT INTO ifk_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ya dingngol APU DIOS hidiyen dasal Moses ot mungkakate nadan bakbak nadah babale, nadah dola ya nadah papayo. ");
INSERT INTO ifk_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ot amungon nadan iEgypt an impu-upu-ul da. Indanit nabuluk nadan bakbak ya namahig an mun-agub nan boble. ");
INSERT INTO ifk_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mu handih nama-id nadan bakbak ya nibangngad boy ngohen nan patul an adina un-unudon da Moses ke Aaron an hidiye tuwaliy kinalin APU DIOS an maat. ");
INSERT INTO ifk_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kanan bon APU DIOS ke Moses di “Kalyom ke Aaron ta ihoplat nay patanong na nah lutat am-in di hupuk hitud Egypt ya mumbalin dah langaw.” ");
INSERT INTO ifk_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","18","Inhoplat Aaron nan patanong na ya numbalin hi langaw nadan hupuk ot namahig an al-alibungbungan day tatagu ya aaggayam. Takon di daana ya dakkodakkol di langaw. Impatnan damdaman nadan mangat hi magic an ipabudal di langaw, mu adida kabaelan. ");
INSERT INTO ifk_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ot kanan da nah patul di “Hi Apu Dios di nangat ketuwe!” Mu kapyanan mangohe nan patul. Hidiye tuwaliy kinalin APU DIOS an adi un-unudon nan patul da Moses ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kanan bon APU DIOS ke Moses di “Humalaman kah bigat ta em had-on nan patul nah wangwang ta kanam ke hiyay ‘Kinalin APU DIOS an iabulut dakamin tataguna ta ekami mundayaw ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Mu deket ngohayom ya kastiguwon daka bot ipaali nay dakol an lihing ta kaalibungbungan dakayu, nadan opisyal mu ya nadan tatagum. Mapnuy babale yu ya takon di daana ta maid di gattinon yu. ");
INSERT INTO ifk_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mu adina ilagat di Goshen an boblen nadan tataguna. Athituy aton APU DIOS ta panginilaam an hiya nan AP-APU. Hiyay mangmangngat ke datuwen ma-ma-at hitud Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Hiya ya inilana hin dahdi day tataguna ya dahdi day tatagum. Atonah tuwen milagroh bigat.’” ");
INSERT INTO ifk_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Nabigat ya nadadag am-in di bobled Egypt te impaalin APU DIOS di dakkodakkol an lihing. Takon nan balen nan patul, hay balen nadan opisyal na ya hi babalen nadan tataguna ya napnuh lihing. ");
INSERT INTO ifk_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Impaayag bon nan patul da Moses ke Aaron ot kananan diday “Damanan iappitan yu nan Dios yu, mu hituh bobley pangatan yu.” ");
INSERT INTO ifk_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ya kanan Moses di “Adinadaman hituy pangatan mi te nunna-ud an balawon nadan tatagum nadan kolngon min aggayam an iappit mi nah Dios mi ya tugmilan dakamih batu. ");
INSERT INTO ifk_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Mahapul an un-unudon miy kinalin nan AP-APU an Dios min emi iappitan nah ugge naboblayan an tulun algoy pundallanan.” ");
INSERT INTO ifk_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ya kanan nan patul di “Takombo. Damanan ume kayu! Mu tibon yu ta adi kayu midaddawwi ya idasalanak.” ");
INSERT INTO ifk_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Hinumang Moses an kananay “Hi indanih pangayan mi ya mundasalak ke APU DIOS ta mama-id nadan lihing an umalibungbung ke dakayu nadah opisyal mu ya tatagum. Mu adi dakami bo haulon an deke udot ta nama-id nadan lihing ya ahim bo in-adiy emi pundayawan ke APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Tinaynan Moses nan patul ot e mundasal ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ya dingngol APU DIOS di dasal na ot makamma-id am-in nadan lihing. ");
INSERT INTO ifk_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mu imbahho ot ya abu bon nan patul nan kinalina te nibangngad boy ngohena ot adina bo iabulut didan ume. ");
INSERT INTO ifk_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kanan bon APU DIOS ke Moses di “Em bo kalyon nah patul an kanam di ‘Kanan nan AP-APU an Dios min Hebrew di: Iabulut mu nadan tataguk an e mundayaw ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Deke kahing kat adim bo ipae dida ");
INSERT INTO ifk_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ya kastiguwon dakat ipaalik di dogon di aggayam ta mungkakate day kabayu yu, kamel yu, baka yu, kalnero yu ya gulding yu. ");
INSERT INTO ifk_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mu maid di mate nadah aggayam nadan holag Israel te imatunak di aggayam da nadah aggayam yu! ");
INSERT INTO ifk_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ha-oy an AP-APU ya atok hi bigat hituwe!’” ");
INSERT INTO ifk_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ot mabigat ya inat APU DIOS hidiyen kinalina ot mungkakate nadan aggayam di iEgypt. Mu maid di nate nadah aggayam nadan holag Israel, takon di oha. ");
INSERT INTO ifk_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ot umitud-ak nan patul hi e manibo hin makulug an maid di nateh aggayam nadan holag Israel ya makulug an athidiy naat. Muden kapyanan mangohe nan patul an adina iabulut didan ume. ");
INSERT INTO ifk_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kanan APU DIOS ke da Moses ke Aaron di “Ekayu gumamal hi dap-ul nah pun-apuyan ta patu-ugon Moses an ihabuwag hi hinangngab nan patul ");
INSERT INTO ifk_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ta umuhbuk an mihinap hi kabobbobleh nad Egypt ta mungkapoghaan day tatagu ya nadan aaggayam da.” ");
INSERT INTO ifk_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Eda immalah dap-ul ot ume dah kad-an nan patul ot ipatu-ug Moses an inhabuwag. Indani ya nungkapoghaan tut-uwa nadan tatagu ya aaggayam. ");
INSERT INTO ifk_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Kediye ya maid moy maat nadan mangat hi magic te takon di dida ya nadan ibba dan iEgypt ya nungkapoghaan da. ");
INSERT INTO ifk_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mu minam-an APU DIOS di ngohen nan patul ta adina un-unudon da Moses ke Aaron. Hidiye tuwaliy kinalin APU DIOS ke Moses an ahi maat. ");
INSERT INTO ifk_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kanan bon APU DIOS ke Moses di “Humalaman kah bigat ta em bo tibon nan patul ta kanam ke hiyay ‘Kanan nan Dios an AP-APU min Hebrew di: Iabulut mu nadan tataguk ta eyak dayawon. ");
INSERT INTO ifk_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Te deket adim iabulut dida ya bokon ya abu nadan opisyal mu ya nadan tatagum di kastiguwok, mu takon di he-a ta panginilaam an maid di udum an Dios an miingngon ha-on hituh tap-on di luta. ");
INSERT INTO ifk_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Te gulat nat impaalik di nahalman an dogo ya nunna-ud an nungkakate kayun am-in. ");
INSERT INTO ifk_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mu ingnguddan kun adi dakayu patayon ta tibon yuy ongal an kabaelak ya ta mundingngol di ngadan kuh kabobboble tuh luta. ");
INSERT INTO ifk_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Muden ingganad uwani ya mangohe kan adim iabulut nadan tataguk an tumayan. ");
INSERT INTO ifk_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ta hidiye nan hi athitun oras hi bigat ya ipaalik di o-ongal an dalalu. Himpappangen abuh tuwen maat an maid di athidin naat hitud Egypt nipalpu handih numbalin hituwen boble. ");
INSERT INTO ifk_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kinali iolden mut mihigup am-in di aggayam yu ya kumpulnan odon yu te deket ipaalik di dalalu ya maten am-in nadan tatagu ya aggayam an wadah dolan miknaan.’” ");
INSERT INTO ifk_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Hanadan udum an opisyal an nangngol nah kinalin APU DIOS ya timmattakut da ot ipahigup da nadan muttatyu da ya am-in di aggayam da. ");
INSERT INTO ifk_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mu nadan udum an uggeda hinangud di kalin APU DIOS ya uggeda impahigup nadan muttatyu da ya nadan aggayam da. ");
INSERT INTO ifk_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kanan APU DIOS ke Moses di “Idongdong muy taklem hi kabunyan ta umaliy dalalut mag-ahan di tatagu, aaggayam ya nadan nungkitanom hitud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ot idongdong Moses di patanong nah kabunyan ya impakidul APU DIOS ya impaalinay dalalu ya kil-at hi luta. ");
INSERT INTO ifk_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Namahig nan dalalu ya mungkikil-at ta nahalman an katatakut hituwen naat ad Egypt an maid di niingngohana nipalpu handih numbalin hituwen boble. ");
INSERT INTO ifk_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ot mungkapa-i nadan nitanom ya nungkakatey tatagu ya aaggayam an nag-ahan hi dalalu. Takon di kakaiw ya nadadag da. ");
INSERT INTO ifk_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ammunad Goshen an numboblayan nadan holag Israel an maid di dalalun nag-ah di. ");
INSERT INTO ifk_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Impaayag nan patul da Moses ke Aaron ot kananan diday “Abulutok an numbahulak. Niptok hi APU DIOS ya dakamin nadah tataguk di nihalla. ");
INSERT INTO ifk_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mundasal ka anhan APU DIOS ta ipatikod na tun dalalu ya kil-at. Ta iabulut kut takomboy ume kayu.” ");
INSERT INTO ifk_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","30","Kanan Moses ke hiyay “Takon di athinay pangalim ya inilak an he-a ya nadan opisyal mu ya adi kayu tumakut ke APU DIOS. Mu takon, itaggek di taklek ta mundasalak ke APU DIOS ta ipatikod na tun kil-at ya kidul ya dalalu. Kediyey panginilaam an hantun lutan numboblayan takun tatagu ya bagin APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","Hanadan nitanom an flax ya barley an dandanin mat-ong ya nungkapai, mu nadan wheat ya spelt ya uggeda pay ni-an tinummol. ");
INSERT INTO ifk_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Immeh Moses nah e-elen di boble ot mundasal ke APU DIOS an intagge nay taklena ya natikod nan kidul, nan udan ya dalalu. ");
INSERT INTO ifk_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mu indanit natikod dadiye ya nunliwat bo nan patul ya nadan opisyal na te nibangngad boy ngohe da. ");
INSERT INTO ifk_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ta immannung nan kinalin APU DIOS ke Moses an adi iabulut nan patul nadan holag Israel an ume. ");
INSERT INTO ifk_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kanan APU DIOS ke Moses di “Ume ka boh kad-an nan patul ta makihummangan kan hiya. Mu impumbalin kun mangohe, takon nadan opisyal nat waday innuk an mangipatibon dida ke datuwen milagro. ");
INSERT INTO ifk_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ta ahiyu kalkalyon hanadah imbabale yu ya inap-apu yuy mipanggep ke datuwen inat kun milagron pangastiguk hantudah iEgypt ta panginilaan yun am-in an ha-oy di AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ot ume da Moses ke Aaron ot kanan da nah patul di “Hituwey kanan nan Dios an AP-APU min Hebrew: Kakon-anay pumpakumbabaam? Iabulut mu nadan tataguk an e mundayaw ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Deket nanongnan mangohe kat adim iabulut didan ume ya paaliyok hi bigat hituh boble yuy dakol an dudun ");
INSERT INTO ifk_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ta maap-apan am-in tun bobleyu ta maid di matiboh luta. Kanon dan am-in di nganneh diyen natdaan an ugge pina-in di dalalu, takon di kakaiw. ");
INSERT INTO ifk_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ya mapnuy balem ya hay balen nadan opisyal mu ya tatagum. Himpappangeh tuwen maat an takon nadan aammod yu dih done ya maid di eda tiniboh umat hitu nipalpu dih pinghanah numboblayan dah tu.” Nagibbun kinalin Moses hituwe ot tayanana nan patul. ");
INSERT INTO ifk_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Hanadan opisyal nan patul ya eda nundiklamun hiya an kanan day “Kakon-anay pangitikodan tun tagun mamulubulun ke ditaku? Iabulut mu hantudan holag Israel ta eda dayawon nan Dios da. Kon adim tibon an deyan nadadag mo anhan tun boble taku?” ");
INSERT INTO ifk_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ot paayag bon nan patul da Moses ke Aaron ot kananan diday “Iabulut kun ume kayu ta eyu dayawon nan AP-APU an Dios yu. Mu pinhod kun inilaon hin dahdi day ume.” ");
INSERT INTO ifk_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ya kanan Moses di “Mahapul an ume kamin am-in takon nadan goggolang ya nadan nungkaam-ama ya nungkain-ina. Mahapul bon pakial-ala mi nadan kalnero mi, gulding mi ya baka mi te munhahamul kamin mundayaw nah AP-APU mi.” ");
INSERT INTO ifk_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kanan nan patul di “Isapatak nah AP-APU an adik iabulut an maki-e nadan imbabale yu takon nadan binabai te makainnilan waday gaga-ihon planu yu. ");
INSERT INTO ifk_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Abunay linalakin iabulut kun umen mundayaw nah AP-APU an Dios yu teden pinhod yun abun e mundayaw.” Kinalin nan patul hidiye ot palah-unona da Moses ke Aaron nah balena. ");
INSERT INTO ifk_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kanan APU DIOS ke Moses di “Idongdong muy taklem hituh bobled Egypt ta umaliy dakkodakkol an dudun ta pungkan dan am-in nadan nitanom an tindaan di dalalu.” ");
INSERT INTO ifk_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ot idongdong Moses di patanong na ya impaalin APU DIOS di dibdib an nalpuh timilan di algo ot ial-algona ya inhilhilong nan dimmanibdib. Nabigat kediye ya dakkodakkol di dudun an in-alin di dibdib. ");
INSERT INTO ifk_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Namahig an dakkodakkol da ta naap-apan am-in di bobled Egypt. Maid di athitun naat handi ya maid di ahi maat hi athitu. ");
INSERT INTO ifk_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Inumpa da ya mangitit am-in di matibo. Kinan dan am-in nadan nitanom an ugge pina-in di dalalu takon nadan bungan di kakaiw, ta ma-ma-idan di maang-ang hi tubu weno bunga. ");
INSERT INTO ifk_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ginalgal-an nan patul an nangipaayag ke da Moses ke Aaron ot kananan diday “Abulutok an numbahulak nah Dios an AP-APU yu ya ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kinali kal-iwan yu anhan ta mundasal kayu nah Dios yu ta patikodonah tuwen pumpalpaligat nan dakamin humlun hi katayan mi.” ");
INSERT INTO ifk_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ot lumah-un hi Moses nah balen nan patul ot mundasal ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Dingngol APU DIOS di dasal Moses ot bangiwonay puluyon nan dibdib an impaena nah nangappit hi timilan di algo ot ien di dibdib am-in nadan dudun nah Maingit an Baybay, ot maid di natdaan ad Egypt takon di oha. ");
INSERT INTO ifk_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mu impangohen APU DIOS nan patul ta iadinan ume nadan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kanan bon APU DIOS ke Moses di “Itaggem di taklem hi kabunyan ta tumapol di kabobbobled Egypt.” ");
INSERT INTO ifk_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Intaggen Moses di taklenah kabunyan ya timmapol ad Egypt hi tuluy algo. ");
INSERT INTO ifk_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Adi pakatibo nadan iEgypt ot mihahhaad dah babale dah tuluy algo. Mu hanada ken holag Israel ya mapat-al nah numboblayan da. ");
INSERT INTO ifk_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Inayagan bon nan patul hi Moses ot kananan hiyay “Iabulut kun eyu dayawon nan AP-APU yu an takon di paki-ayon yu nadan imbabale yu ya nadan binabai. Mu adiyu al-alan nadan kalnero yu, gulding yu ya baka yu.” ");
INSERT INTO ifk_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ya kanan Moses di “Adi mabalin te mahapul an waday iappit mi nah Dios an AP-APU mi. ");
INSERT INTO ifk_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kinali mahapul an itabin min am-in nadan aggayam mi. Adi bo mabalin an hituy pamiliyan mih emi iappit ke APU DIOS te mahapul an deket dimmatong kami nah pundayawan mi ya ahi kami nuppe numpilih iappit mi.” ");
INSERT INTO ifk_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mu impangohen bon APU DIOS nan patul ta iadina bon ume nadan Hebrew. ");
INSERT INTO ifk_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Kanan nan patul ke Moses di “Tumayan ka ya adika mo mumpatibon ha-on! Te patayon daka ten umali ka bo!” ");
INSERT INTO ifk_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Kanan Moses di “Om, niptok ka. Adiyak mo mumpatpatibon he-a.” ");
INSERT INTO ifk_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kinali tuwalin APU DIOS ke Moses an kananay “Hituwey ahi manguddidin ligat an ipaalik nah patul ya nadah tataguna. Deket nagibbuh tuwe ya iabulut nan ume kayu. Hay kakulugana ya hiyay ahi mangipakaan ke dakayuh tu. ");
INSERT INTO ifk_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Em kalyon hanadah holag Israel an binabai weno linalaki ta mumbaga dah nungkanginan odon an nakapyah balituk ya silber nadah hinag-on dan iEgypt.” ");
INSERT INTO ifk_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kediye mo ya numbalinon APU DIOS nadan iEgypt an makallispitu ya maule nadah holag Israel. Takon nadan opisyal nan patul ya nadan tataguna ya imbilang dah Moses an natag-en tagu. ");
INSERT INTO ifk_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kinali kalyon mon Moses nah patul di “Kanan APU DIOS di ‘Hi gawan di hilong ya ena hinapon am-in di bobled Egypt ");
INSERT INTO ifk_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ta am-in nadan linalakin panguluwan an imbabale yu ya mungkakate da. Mipalpu nah panguluwan an imbabalem an hiya ot di mihaynod an mumpatul, inggana nah panguluwan an imbabalen nan kababbabaan an muttatyum. Takon nadan namangulun impan di aaggayam yu ya mungkakate da damdama. ");
INSERT INTO ifk_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ahi makadngol di koga yu an maid di kiingngohana te maid di naat hi athidi handi weno ahi maat hi athitu. ");
INSERT INTO ifk_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mu ahida makallinggop nadan holag Israel te maid di maat ke dida takon hanadah aggayam da. Takon nadan ahu ya maid di munggunggung.’ Kediyey ahiyu panginilaan an hi APU DIOS ya hinnatkon di pangibilang na nadah holag Israel ya dakayun iEgypt. ");
INSERT INTO ifk_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ta am-in nadan opisyal mu ya ahida umalin munyuung ke ha-on an mumpahpahmok dat ipanguluk nadan tataguk ta tumayan kami. Ya kediye ya makulug an tumayan kami.” Kinalin Moses hidiye ot lumah-un an namahig di boh-ol na. ");
INSERT INTO ifk_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kinalin tuwalin APU DIOS ke hiya an kananay “Ahi ngohayon nan patul di kalyom ta waday innuk an mangipatiboh dakol an milagroh tud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Kinali handih inat da Moses ke Aaron am-in datuwen milagroh hinangngab nan patul ya kapyanan mangohen adina iabulut an tumayan nadan holag Israel ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Indani ya kanan APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Hituwen bulan di ibilang yun mamangulun bulan nah hintoon. ");
INSERT INTO ifk_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kalyon yun am-in hanadah ibba yun holag Israel ta hantuh mikapulun algo ketuwen bulan ya pumili kayuh impan di kalnero an hin-oh-ah ohan pamilya. ");
INSERT INTO ifk_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Mu deket waday pamilyan adida pakap-u nah ohan kalnero ya mahapul an pumbingayan da nah hinag-ona mipuun hi kadakol nan pamilya da ya nan umustun kanon da. ");
INSERT INTO ifk_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mahapul an hay piliyon yu ya nan hintoonan maid dipektonan kalnero weno gulding. ");
INSERT INTO ifk_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Pakaippaptok yu datuwen aggayam inggana mikahimpulut opat an algo ta ahiyu kolngon hi kahilongana. ");
INSERT INTO ifk_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ahiyu ha-adan hi dala nadan pamadingan yu ya nadan tap-on di panton pangikanan yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Itbong yu nan dotag ya ihda yuh tinapay an ugge naha-adan hi mumpalbag ya hinidaan yu nadah mitanom an mapait. ");
INSERT INTO ifk_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Adiyu ma-ataon weno pahinnaang, mu itbong yu takon di ulu, huki, puhu, alte ya putu. ");
INSERT INTO ifk_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mahapul an kanon yun am-in nah mahmahdom ta maid di matdaan. Mu deket waday matdaan ya gobhon yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ya athituy aton yu, mumbulwati kayun kay waday pangayan yu ya mun-apatut kayu ya mumpatanong kayu. Ya gal-an yun mangan, te hituwen hilong nan kala-uwan di Anghel APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Kediyen hilong ya hinapok di Egypt ta patayok am-in nadan linalakin panguluwan an imbabalen nadan iEgypt takon nadan namangulun impan di aggayam da. Ya pa-iyok am-in nadan daydayawon dat panginilaan dan ha-oy an DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Hanan dala an idan-i yuh panto yuy ahik pangimatunan hi babale yu ta la-uwak ta maid di mate ke dakayuh pangastiguwak nadah iEgypt. ");
INSERT INTO ifk_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mahapul an adiyu kal-iwan ta nangamung hituwen algo. Aton yuh tuwen piyestah katootoon ta panginomnomnoman yun ha-on an AP-APU yu. Ya ituttudu yu damdamah tuwe nadah imbabale yu ya inap-apu yu ta adi matalak hituwen pangi-e. ");
INSERT INTO ifk_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pitun algoy adiyu panganan hi tinapay an naha-adan hi mumpalbag. Hanah mamangulun algo ya mahapul an kaanon yu nadan mumpalbag hi tinapay an wadah babale yu. Te deket wadan dakayuy kuman hi tinapay an naha-adan hi mumpalbag kediyen pitun algo ya adi mo mibilang an taguk. ");
INSERT INTO ifk_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hanah mamangulu ya mikapitun algo ya mahapul an maamung kayu ta mundayaw kayun ha-on. Ya tibon yu ta adi kayu mungngunu ke dadiyen pitun algo. Hay ya abu mabalin an aton yu ya hay pundadaanan yuh kanon yuh pumpiyestaan yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mahapul an aton yu ta nangamung hi tuwen pangi-e te ketuwen algoy pangaanak ke dakayud Egypt. Ya punnanongon yuh tuwen pangi-e an Piyestan di Tinapay an ugge naha-adan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Milappun tuwen hilong di mikapulut opat an algo nah mamangulun bulan ingganah hilong di mikaduwampulut ohan algo kediyen bulan ya adi kayu nimpe kuman hi tinapay an naha-adan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Pituy algon maid di kuman hi tinapay an naha-adan hi mumpalbag ya maid di e miha-ad hi babale yuh mumpalbag hi tinapay ke datuwen nabilang an algo. Mahapul an am-in kayu ya un-unudon yuh tuwe takon di nadan nakiboblen dakayu te hanan mangahing ketuwe ya adi mo mibilang an taguk.” ");
INSERT INTO ifk_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ot paayag Moses am-in nadan ap-apun di holag Israel ot kananan diday “Ekayu pumilih impan di kalnero yun kolngon yu ta hamulon di pamilya yuh pumpiyestaan yuh Nala-uwan di Anghel Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bumtok kayuh hapang di hissop ta itam-ol yu nah dalan nan kinlong yu ya indan-i yuh tap-on di panto yu ya nadah pamadingan yu. Ya tibon yu ta maid di e lumah-un ke dakayu inggana mabigat. ");
INSERT INTO ifk_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ta deket hinapon APU DIOS tun boblen e mamate nadah panguluwan an imbabalen nadan iEgypt ya la-uwan dakayu nah anghel nat adi dakayu ilagat ten tibona nan dalah panto yu ya pamadingan yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Dakayu ya nadan holag yu ya mahapul an aton yu nimpeh katootoon hituwen pangi-et adi matalak. ");
INSERT INTO ifk_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Deket bot dimmatong kayu nah boblen kinalin APU DIOS an pangayan yu ya mahapul an aton yuh tuwen Piyestan di Nala-uwan di Anghel Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Deket hanhanan nadan imbabale yu hin tipet aton yuh tuwen piyesta ");
INSERT INTO ifk_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ya kanan yun diday ‘Hituwey pun-appitan ke APU DIOS te handih ena pamatayan hanadah iEgypt ya lina-uwan di anghel nay babale min holag Israel ot ugge dakami inlagat an pinate.’” Dingngol nadan tataguh tuwe ot mundukkun da ot dayawon dah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ot aton dan am-in nadan kinalin APU DIOS ke da Moses ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kediyen gawan di hilong ya pinaten APU DIOS am-in nadan linalakin panguluwan an imbabalen nadan iEgypt nipalpu nah imbabalen nan patul an ahi ot mihaynod an mumpatul inggana nadah imbabalen nadan nungkikalabut. Takon nadan namangulun impan di aaggayam da ya nate da. ");
INSERT INTO ifk_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kediyen hilong ya nabangun nan patul ya nadan opisyal na ya am-in nadan iEgypt ot ahi kokoga da te maid di ohan baled Egypt an maid di nate. ");
INSERT INTO ifk_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ot kediyen hilong ya impaayag nan patul da Moses ke Aaron ot kananan diday “Eyu ipangulu nadan ibba yun holag Israel ta mumpapange kayu! Tumayan kayu tuh boble mi ta eyu dayawon nan AP-APU an Dios yun hidiye nan imbagabaga yun aton yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pakial-ala yu nadan kalnero yu ya nadan udum an aggayam yu, mu idasalanak anhan ta mawaday kiphodak damdama.” ");
INSERT INTO ifk_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nun-igag-a nadan iEgypt nadan holag Israel ta gal-an dan tumayan te kanan day “Loktat ya mate kamin am-in hin adi kayu tumayan hitu.” ");
INSERT INTO ifk_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Inal-alan nadan holag Israel di napalut an alinan kapyaon dah tinapay an ugge naha-adan hi mumpalbag an linibbutan dah luput ot pun-ipah-on da, ");
INSERT INTO ifk_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","36","ot mange da. Ya impakiala day kinadangyan di iEgypt te inun-unud da handin kinalin Moses an aton da. Ot handih numbaga dan didah balituk, silber ya bulwati ya nun-idat da datuwen ibaga da te impumbalin APU DIOS didan makallispitu ya maule ke dida. Athituy inat nadan holag Israel an nangalah kinadangyan nadan iEgypt. ");
INSERT INTO ifk_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nundallan dan inlappu dad Rameses ot ingganad Sukkot. Ya hay bilang dan am-in an timmayan ad Egypt ya umeh onom an gatut di libu, mu ugge nauyap di goggolang ya binabai. ");
INSERT INTO ifk_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Dakol di aggayam dan intabin da umat hi kalnero, gulding ya baka ya dakol boy bokon da ibban holag Israel an naki-en dida. ");
INSERT INTO ifk_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ot mangapya dah tinapay an kinapya da nah alinan indaddaan dad Egypt an ugge naha-adan hi mumpalbag te ginagaddud di timmayanan da ot maid di tiempo dan nundadaan hi kanon da. ");
INSERT INTO ifk_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Hay bilang di toon an niha-adan nadan holag Israel ad Egypt nipalpu handih nangayan dah di ingganad uwanin tumayan da ya opat di gatut ta tuluy pulun toon. ");
INSERT INTO ifk_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Hanadan holag Israel ya mahapul an iappit dan APU DIOS hituwen hilong hi katootoon te ketuwen hilong di nangihwanganan dida ot tumayan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Indani ya kimmali boh APU DIOS ke da Moses ke Aaron an kananay “Datuwen kalyok di maunud nah pangatan yuh Piyestan di Nala-uwan di Anghel ku. Hay oha ya adinadaman makikan di hintaguwan an bokon yu ibban holag Israel nah panganan yu nah panginomnomnoman yuh nala-uwan di anghel ku. ");
INSERT INTO ifk_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mu nada ken himbut yu ya damanan makikan da, mu mahapul an makugit da ni-an. ");
INSERT INTO ifk_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Adinadaman makikan di nalpuh udum an boblen nakiboblen dakayu weno nadan tinangdanan yun pungngunuwon yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ya nadan idadaan yun makan ya mahapul an kanon yun am-in hi bohongnan adi kayu umilah-un. Ya tibon yu bot adiyu gi-uwon di gunit nan kolngon yu. ");
INSERT INTO ifk_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Am-in kayun holag Israel ya mahapul an aton yuh tuwen piyesta. ");
INSERT INTO ifk_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mu adinadaman makikan di ugge nakugit. Deket waday nalpuh udum an boblen nakiboblen dakayu an pinhod nan makid-um hi pangatan yun naen panginomnomnoman yuh nala-uwan di anghel ku ya mahapul an makugit am-in di linalakih nunhituwana ta ahi damanan makid-um dat kay da tonok an ibbayun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ya am-in di holag Israel ya nadan nalpuh udum an boble ya mahapul an aton da datuwen maunud hi pangatan nah Piyestan di Nala-uwan di Anghel ku.” ");
INSERT INTO ifk_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ya am-in nadan holag Israel ya timbal dah tuwen tugun an nalpun APU DIOS an intugun da Moses ke Aaron ke dida. ");
INSERT INTO ifk_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ot ipangulun APU DIOS nadan holag Israel an tumayan dad Egypt kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Idawat yun ha-on nadan linalakin panguluwan an imbabale yu te midawat ke ha-on am-in di panguluwan an imbabale yun holag Israel, takon nadan namangulun impan di aggayam yu.” ");
INSERT INTO ifk_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ot e kalyon Moses nadah ibbanan holag Israel an kananay “Adi taku kal-iwan hituwen algon nanayanan takud Egypt an nihbutan yu gapuh ongal an kabaelan APU DIOS. Ya tibon yu nimpe ta adi kayu mangan hi tinapay an naha-adan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","5","Ad uwanin mamangulun bulan an Abib ya taynan takuy Egypt ta ume taku nadah boblen kinalin APU DIOS handidah aammod takun ipaboltanan ditaku. Datuwe nadan numboblayan di Kanaanite, Hittite, Amorite, Hibite ya nadan Jebusite, an dakol di makan ya maluwab di mitanom. Deket dumatong kayuh di ya adiyu kal-iwan an mun-an-anla ketuwen algoh katootoon. ");
INSERT INTO ifk_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Ya kediye ya mahapul an adi kayu mangan hi tinapay an naha-adan hi mumpalbag nah mamangulun pitun algoh mamangulun bulan. Ya mahapul an maid di mumpalbag hi tinapay hi nunhituwan yu ya hi boble yu ke dadiyen algo ya ahi kayu mumpiyestan munhahamul kayuh pundayaw yun APU DIOS nah mikapitun algo. ");
INSERT INTO ifk_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Kediyen piyesta ya ahiyu kalyon hanadah imbabale yun man-uket aton yuh tuwe ya gapu nah inat APU DIOS ot ahiyu tayanan ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Hituwen piyesta ya paddungnay markah takle weno hi tuktuk taku ta panginomnomnoman takut nangamung nadah tugun APU DIOS. Aton takuh tuwen piyesta te gapuh ongal an kabaelana ya impakaan ditakud Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kinali aton takuh tuwen piyesta nah nagtud an algoh katootoon. ");
INSERT INTO ifk_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Hantuh datngan yu nah boblen kinalin APU DIOS handidah aammod takun ipaboltanan ditakun numboblayan nadan iKanaan ");
INSERT INTO ifk_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ya mahapul an idawat yu nadan linalakin panguluwan an imbabale yun hiya, takon nadan mamangulun lakin impan di aggayam yu. Te am-in di panguluwan an linalakin imbabale yu takon nadan namangulun impan di aggayam yu ya bagin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mu dadiyen panguluwan an linalakin imbabale yun idat yu ya damanan hannotan yuh impan di kalnero. Ya takon nadan namangulun impan di kabayu yu ya damanan hannotan yu boh impan di kalnero. Mu deket adiyu pinhod an hannotan ya gi-uwon yuy bagang nan kabayu. ");
INSERT INTO ifk_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Deket hanhanan di imbabale yuh udum hi algo hin nganney gapunah pangatan yun datuwe ya kanan yuy ‘Man-uke ya gapuh ongal an kabaelan APU DIOS ya impakaan dakamid Egypt an nihbutan mi. ");
INSERT INTO ifk_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Te handih wada kamih did Egypt ya mangohe nan patul an adi dakami iabulut an tumayan hidi, ot patayon APU DIOS nan panguluwan an imbabalena ya am-in di panguluwan an imbabalen nadan iEgypt, takon nadan namangulun impan di aggayam da. Hidiyey gapunan mahapul an idawat takun APU DIOS nadan namangulun linalakin imbabale taku ya hay namangulun impan di aaggayam taku. Mu hay mihannot nadah panguluwan an linalakin imbabale taku ya hay impan di kalnero. ");
INSERT INTO ifk_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Hituwen aton taku ya kay nimarkah takle taku weno hi tuktuk taku ta panginomnoman takut nangamung hi nangaanan APU DIOS ke ditakud Egypt gapuh ongal an kandamana.’” ");
INSERT INTO ifk_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","18","Handih in-abulut nan patul an tumayan nadan holag Israel ya bokon nan dalan an mumpaed Pilistiay impangulun Apu Dios an dinalan da, yaden hidiye ot kumay antiktiken pangidalanan dan ume nah pangayan da. Ot hay impangulunan dinalan da ya nah ugge naboblayan an mumpaen nah Maingit an Baybay. Te kanan Apu Dios di “Adik pinhod an kal-ina ya muntutuyu datuwen tatagu ta mibangngad da ten tibon dan mahapul an makigubat da.” Hituwey ninomnom nan aton takon di waday almas nadan holag Israel an timmayan ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Handih timmayanan da Moses ad Egypt ya impakial-ala da nan gunit Joseph te hidiyey kinalina tuwali handi nadah iibanan holag Israel an kananay “Hantuh pangihwangan Apu Dios ke dakayu ta tumayan kayuh tu ya mahapul an pakial-ala yuy gunit ku.” ");
INSERT INTO ifk_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tinaynan nadan holag Israel di Sukkot ot dumatong dad Etham an boble nah pingngit di ugge naboblayan ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","Hay inat APU DIOS an nangipangulun dida ya deket mapat-al ya wadat nangamung nan kulabut an mangipangpangulun dida. Ya deket hilong ya mumbalin hidiyen kulabut hi ongal an apuy an mundadalang ta mapat-alan di dalanon da. ");
INSERT INTO ifk_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Indani ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kalyom hanadah ibbam an holag Israel ta mibangngad kayu nah nih-up ad Pi Hahirot an numbattanan di Migdol ya nan Maingit an Baybay ta mungkampu kayu nah dommang di Baal Sephon. ");
INSERT INTO ifk_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ta pangalin nan patul di Egypt on nahamma kayu ya nahkuk kayu te numbattanan dakayu nah ugge naboblayan ya nan baybay ");
INSERT INTO ifk_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ta pudugon dakayu te pumbalinok bon mangohe. Implanuk hituwe ta usalok nan patul ya nadan tindalunah mangipatiboh ongal an dayaw ku. Hituwey ahi panginilaan nadan iEgypt an ha-oy di AP-APU.” Ot umeh Moses an e nangalin tuwe nadah holag Israel ot un-unudon dah diye. ");
INSERT INTO ifk_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Handih dingngol nan patul di Egypt an timmayan mo nadan holag Israel an adida mibangngad ya makatuttuyu takon nadan opisyal nan kanan day “Nganneh tuwen etaku inat! Tipet etaku in-abulut didan ume? Dahdi moy pummuttatyu taku?” ");
INSERT INTO ifk_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Impidadaan nan patul nan punlugananan kalesa ta ipanguluna nadan tindalunan mamdug nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","8","Impangohen APU DIOS nan patul ot mandalona nadan onom an gatut an tindalunat pudugon da didan usalon da nadan kapkaphodan an kalesa ya nadan udum an kalesad Egypt an usalon dan makigubat. Naki-e damdama nadan aap-apun di numpungkalesa ot pudugon da nadan holag Israel an maid di takut dan mange. ");
INSERT INTO ifk_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hanan patul, am-in nadan tindaluna nungkalesa, nadan nungkabayu, ya nadan tindalun nundallan ya numpudug da nadan holag Israel ot akhupan da didan nungkampu nah pingngit nan Maingit an Baybay an nih-up ad Pi Hahirot ya dommang di Baal Sephon. ");
INSERT INTO ifk_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Handih tinibon nadan holag Israel an mangali nan patul ya nadan tindaluna ya timmattakut da ot pihpihmok dan APU DIOS ta baddangana dida. ");
INSERT INTO ifk_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Kanan dan Moses di “Tipet e dakami in-ali tuh ugge naboblayan ta hituy emi katayan? Kon makudang di lubukan ad Egypt? ");
INSERT INTO ifk_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kinali mi tuwalin he-an adi dakami pakibibiyangan ta takombo pey mihdi kamid Egypt. Kudukdul nay nunnanong kamin himbut hidi mu nan ekami mateh tu!” ");
INSERT INTO ifk_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mu kanan Moses di “Adi kayu tumakut! Patulidon yuy nomnom yu ta tibon yuy aton APU DIOS an mangihwang ke dakayud uwani. Te dadiyen iEgypt an tibtibbon yu ya mama-id dan am-in ta maid moy pangang-angan yun dida. ");
INSERT INTO ifk_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hay maphod an aton taku ya dumin-ong taku ta nangamung hi APU DIOS an makigubat ke dida.” ");
INSERT INTO ifk_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kanan APU DIOS ke Moses di “Tipet mumpahpahmok kayun ha-on? Kalyom ot ya abu nadah tatagum ta ituluy yun ume! ");
INSERT INTO ifk_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Idongdong mu nan patanong mu nah baybay ta munhi-an nan danum ta mamagay dalanon yu nadah ibbam an holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pungngohayok bo nan patul ta mange kayu yaden pun-unud dakayu. Mu ha-oy di makigubat ke didat apputok nan patul, nadan tindaluna, nadan tindalunan nungkalesa ya nadan nungkabayu ta mipatiboy ongal di kabaelak. ");
INSERT INTO ifk_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ta hidiyen pangapputak ke diday panginilaan dan ha-oy di makulug an AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Indanit mange nadan holag Israel ya imme nan anghel Apu Dios an mangipangpangulun didah indoggan da ya imme damdama nan kulabut hi numbattanan ");
INSERT INTO ifk_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","nadan holag Israel ya nadan iEgypt ot mihanit muntatapol nah kad-an nadan iEgypt, mu mapat-al nah kad-an nadan holag Israel ot maid di innun dan mih-up ke dida kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Dimmatong da nah baybay ot idongdong Moses nan patanong nah di ya impaalin APU DIOS di nal-ot an dibdib an nalpuh nangappit hi timilan di algo ot dumanibdib inggana mabigat. Loktat ya nagodwa nan danum ot mabudhan nan luta. ");
INSERT INTO ifk_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ot idalan nadan holag Israel hidi. Hanan danum nah numbinah-el nah iniggid ya winawwan ya kay nabanong. ");
INSERT INTO ifk_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nipdug da nadan iEgypt an nungkalesa da ya nungkabayu da. ");
INSERT INTO ifk_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mu indanit mungkabigat ya nun-uhdung hi APU DIOS an wada nah kulabut ya apuy ot wadaonay takut nadan tindalun di Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Maid maptok ya mungkilunok di pilid nadan kalesa dat mumpaligat dan ume. Ot kanan day “Tumayan taku ot hitu te deyan nan AP-APU an Dios nadan holag Israel di makihanggan ditaku!” ");
INSERT INTO ifk_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Handih wada mon am-in nadan holag Israel nah binnah-el nan baybay ya kanan APU DIOS ke Moses di “Idongdong mu boy taklem nah baybay ta mundammu nan danum ta malting hantudan iEgypt an mungkipdug.” ");
INSERT INTO ifk_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","28","Ot idongdong Moses di taklena nah baybay hi biggatna ya numbangngad nan danum ot mungkaanud nadan kalesa ot malting nadan tindalu ya nadan nungkitakkeh kakabayu. Ipatnan ot nadan iEgypt an dumakal, mu nalting dan am-in an maid di ohah natdaan gapun diyen inat APU DIOS ke dida. ");
INSERT INTO ifk_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mu hanada ken holag Israel ya nundalan da nah mamagan lutan kay nabanong nan danum hi numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","31","Namodwong da ya ongal moy dinol dan APU DIOS ya nah muttatyunan hi Moses handih tinibo day ongal an kabaelan APU DIOS hi nangihwanganan dida kediyen algon inapput na nadan iEgypt an nungkalting dah impangat na ot mungkiwahit di adol da nah pingngit di baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Gapuh nangihwangan APU DIOS ke dida ya nungkanta da Moses ya nadan ibbanan holag Israel an kanan day “Ikantaak hi APU DIOS te impaka-apput na nadan buhul nan inibka na dida ya nadan kabayu dah baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hi APU DIOS di nal-ot an mangitakdog ke ha-on ya hiyay nangihwang ke ha-on. Hiyay Dios ku, kinali hiyay dayawok. Hiya boy Dios an dayawon ama, kinali ikantak di mipanggep hi kinatag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hi APU DIOS ya natulid an makigubat ya hiyay AP-APU. ");
INSERT INTO ifk_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Inibkana nadan tindalun di Egypt ya nadan kalesa da nah baybay. Ta am-in nadan katultulidan an ap-apun di tindalu da ya nungkalting dan nah Maingit an Baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nalnong dan kay da batun immed dalom nan baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","APU DIOS, ongal di kabaelam, paddungnay guduwom nadan buhul mu. ");
INSERT INTO ifk_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Gapuh kinatag-em ya inapput mun am-in nadan makilaban ke he-a. Impatibom di boh-ol mu ot ma-idom dida umat hi punggohoban di apuy hi ulut. ");
INSERT INTO ifk_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Inhap-ud mun nah baybay ya nagodwa nan danum an kay nabanong ya kay nadingding ya numbalin an makulhi nan dallom di baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kanan nan buhul miy ‘Pudugok didat deket akhupak dida ya numpalang ku dida. Ne inalak am-in nadan odon dat punggogodwaan mi nadah tataguk.’ ");
INSERT INTO ifk_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mu inhap-ud mu bo, APU DIOS ot mundammu nan danum ot malting da. Ot malnong da nah baybay an kay da gumok an nalnong ad dalom. ");
INSERT INTO ifk_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","APU DIOS, dahdiy udum hi dios an umat ke he-a? Kon waday makakkaphod ya madayaw an umat ke he-a? Ya dahdiy kabaelanan mangat nah umipamodwong an at-attom? ");
INSERT INTO ifk_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Indongdong muy wawwan an taklem ya nauhbung nadan buhul mi ot ume dad dalom di luta. ");
INSERT INTO ifk_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Inihwang dakami ya impangulu dakami gapuh ongal an pamhod mun dakamin tatagum. Ya gapuh ongal an kabaelam ya ipaptok dakami inggana dumatong kami nah boblen intuddum an kiha-adam. ");
INSERT INTO ifk_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dakol day tataguh kabobboblen ahi mangngol nah naat ya gumayonggong dah takut da. Namam-a nadan iPilistia, ");
INSERT INTO ifk_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","nadan aap-apun di iEdom, iMoab ya nadan ap-apun di iKanaan. ");
INSERT INTO ifk_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ahida tumattakut gapu nah ongal an kabaelam, APU DIOS ta op-opya dan maid di eda aton ke dakami inggana mala-u kamin tatagum an liniblim hi nihbutan mi. ");
INSERT INTO ifk_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ahi dakami ien paddungnay edakami itanom nah bilid an hidiye nan pinilim, APU DIOS, an kiha-adam. Hidi nah balem an kinapyam. ");
INSERT INTO ifk_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","He-a, APU DIOS di mun-ap-aput nangamung.” ");
INSERT INTO ifk_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Handih wada nadan kakabayu ya kalesa ya nadan nuntakken tindalun di Egypt nah gawwan di baybay ya impaen APU DIOS di danum ot malting da. Mu nada ken holag Israel ya namag-anan di nundalanan da nah baybay. ");
INSERT INTO ifk_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Indani ya hi Miriam an tulang Aaron ya oha nadah profetas APU DIOS ya inalana nan ayyuding na ot ipanguluna nadan ibbanan binabai ot waday ohan dida on pun-ipagango day ayyuding da ya nannannayo da. ");
INSERT INTO ifk_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Nungkantah Miriam an kananay “Ikantaan takuh APU DIOS te inapput nay buhul taku ta kidayawana. Inibkana nadan kakabayu ya nadan nungkitakke nah baybay ot malting da.” ");
INSERT INTO ifk_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Indani ya impangulun bon Moses nadan holag Israel ot tumayan da nah Maingit an Baybay ot ipayu dad Sur an ugge naboblayan. Kediyen pangayan dah di ya uggeda imminum hi tulun algo te maid di hinamak dah uminuman da. ");
INSERT INTO ifk_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Indani ya dimmatong dad Marah ya waday danum hidi, mu mumpait, kinali nginadanan dah diyen boble hi Marah. Te hay kibalinan di Marah hi Hebrew ya mumpait. ");
INSERT INTO ifk_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ya mundiklamu nadan tatagun kanan dan Moses di “Nganney inumon taku?” ");
INSERT INTO ifk_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ot mumpahpahmok hi Moses ke APU DIOS. Intuddun APU DIOS nan hapang di kaiw ot alan Moses ot igyang na nah danum ya nakaan di pait na ot mabalin mon inumon da. Impainilan APU DIOS ke didah di nadan tugun an mahapul an un-unudon dat tibona hin un-unudon da weno adi. ");
INSERT INTO ifk_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kananay “Deket paka-un-unudonak ke dakayu ta aton yuy pinhod ku ya aton yuy maphod ya adi dakayu kastiguwon ta adi kayu umat nadah iEgypt an kinastiguk didah dogo. Ha-oy di AP-APU an mangipaphod ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Indani ya dimmatong dad Elim an waday himpulut duwan ob-ob ya napitun niyug ot mungkampu da nah nih-up ke dadiyen ob-ob. ");
INSERT INTO ifk_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Tinayanan day Elim ot ume dad Sin an oha bon ugge naboblayan an numbattanan di Elim ya Sinai ot mungkampu dah di. Kediyen dimmatongan dah di ya nala-uy himbulan ta himpulut limay algo nipalpu handih timmayanan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kediyen wada dah di ya namahig boy diklamun nadan tatagu ke Moses ya hi Aaron ");
INSERT INTO ifk_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","an kanan day “Kudukdul na boy pinate dakamin APU DIOS ad Egypt mu nan edakami ingkuyug ke dakayu tuh ugge naboblayan ta ekami mateh inagang. Hidid Egypt ya dakol di makan an deket pinhod di dotag ya wada, athidi bo nadah udum an klasen makan.” ");
INSERT INTO ifk_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ot kanan APU DIOS ke Moses di “Ogahok di makan an malpud kabunyan. Mu mahapul an kabigabigat on imme nadan tatagut umamung dah umustuh kanon da kediyen algo. Ketuwey panginilaak hin un-unudon day kalyok. ");
INSERT INTO ifk_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Deket nah mikan-om an algo hi kalinggulinggu ya dakdakolon day amungon dan mumpidway kadakol nan oggan da amungon hi hin-algo ta waday kanon da nah mikapitun algo.” ");
INSERT INTO ifk_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ot amungon da Moses ke Aaron nadan ibba dan holag Israel ot kanan dan diday “Hi hilong ya inilaon yun hi APU DIOS di nangipangulun ditaku ot tayanan takud Egypt, ");
INSERT INTO ifk_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","ya hi biggatna ya tibon yuy kabaelana. Dingngol nay diklamu yun hiya te man-ut dakamiy nangalyan yuh diklamu yu, mu hay kakulugana ya hiyay nundiklamuwan yu te dakami ya muttatyu dakami ya abun hiya. Hiyay mangidat hi ihda yun dotag nah hilong ya hiya boy mangidat hi mahapul yun tinapay nah biggatna. Dingngol nay diklamu yun hiya te am-in di diklamu yun dakami ya hiyay nundiklamuwan yu.” ");
INSERT INTO ifk_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kanan Moses ke Aaron di “Kalyom am-in hanadah tatagut maamung dah kawad-an APU DIOS te dingngol nay diklamu da.” ");
INSERT INTO ifk_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mungkalih Aaron hanadah tatagu ya nunliggu da ot iang-ang da nah ugge naboblayan ya tinibo day makahhiyon dayaw APU DIOS nah kulabut. ");
INSERT INTO ifk_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Kimmalih APU DIOS ke Moses an kananay ");
INSERT INTO ifk_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Dingngol kuy diklamun nadan tatagu. Kalyom ke dida an hi mungkahilong ya waday dotag an idat ku. Ya nah biggatna ya idat kuy tinapay an mahapul da. Hituwey panginilaan dan ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Indani peman ot mahilong ya immaliy dakol an hamuti nah kampu da. Ya nabigat ya dimmulnu nah nunlinikkod di nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Namag-anan nan dulnu ya nanapnapan nan lutah mungkaingpin mabayak an kay dalaluy ang-ang na. ");
INSERT INTO ifk_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Handih tinibon nadan tatagu ya kanan day “Nganne nin datuwe?” Hinumang Moses an kananan diday “Datuwe nan makan an indat APU DIOS ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Kanan APU DIOS di “Am-in kayu ya mahapul an hay umustun kanon yuh hin-algoy amungon yun hintalub hi ohan tagu.” ");
INSERT INTO ifk_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ot waday oha nadah tatagu ya e nangamung hi kanona, mu ugge nun-iingngoy inamung dan dakdakol di inamung di udum mu nadan ibba da. ");
INSERT INTO ifk_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mu indanit eda lukudon di inamung di hin-oh-an dida ya maid di nahawwal weno makudang. Waday oha on umustuy inamung na nah kanonah hin-algo. ");
INSERT INTO ifk_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kanan Moses ke diday “Mahapul an upuwon yun am-in nadan makan ad uwanin hilong ta maid di matdaan.” ");
INSERT INTO ifk_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mu wadaday udum ke didan ugge nangun-unud kediyen kinalin Moses ot tod-an day udum, mu eda tibon hi biggatna ya nabigiyan ya himpappangey hamuy na. Indanit ininnilan Moses hidiye ya bimmoh-ol. ");
INSERT INTO ifk_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kabigabigat nah biggatna on imme nadan tatagun e mangamung hi damanan kanon di pamilya dah hin-algo. Deket inumlot di potang on nauma nadan uggeda inamung. ");
INSERT INTO ifk_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Deket nah mikan-om an algo ya dubliyon day kadakol nan makan an amungon dat hindudwa mon talub hi ohan tagu. Indani ya imme nadan napilin aap-apu ot eda mahmahan ke Moses hin tipet athidi. ");
INSERT INTO ifk_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ya kanan Moses ke diday “Man-uket mahapul an dubliyon yuy amungon yud uwanin algo ya intugun APU DIOS an hi bigat ya mun-iyatu kayun maid di mungngunu ta mundayaw takun hiya. Mahapul an pakiha-ang yud uwaniy kanon yuh bigat.” ");
INSERT INTO ifk_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Inun-unud day kinalin Moses ot umiha-ad dah kanon dah kabigatana. Indanit eda tibon ya ugge nadang-o ya ugge nabigiyan. ");
INSERT INTO ifk_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kanan Moses ke diday “Hinaen tindaan yuy kanon yud uwanin Sabadu te ad uwanin algoy pundayawan ke APU DIOS ya maid di eyu mahamak hi makan. ");
INSERT INTO ifk_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mipalpud uwani ya athidiy aton yun ekayu mangamung hi kanon yuh onom an algo. Mu hi mikapitun algo an Sabadu ya maid di mahamak yuh makan.” ");
INSERT INTO ifk_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Athidiy kinalin Moses, mu kapyanan wadada nadan adi manghop ta kediyen Sabadu ya eda ot mangamung hi makan, mu maid di hinamak da. ");
INSERT INTO ifk_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ot kanan APU DIOS ke Moses di “Kon-ana nin ta ahi mangun-unud hantudan tataguh itugun ku? ");
INSERT INTO ifk_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kon adida nomnomon an mumpidway kadakol nan makan an idat kun dida nah mikan-om an algo ta umustuh kanon dah duwan algo? Te ha-oy an AP-APU yu ya winadak nan mikapitun algo an pun-iyatuwan yun adi kayu umen e manamak hi kanon yu, mu tumungo kayu.” ");
INSERT INTO ifk_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ot mipalpun diye ya tumungo nadan holag Israel nah mikapitun algon adida mungngunu. ");
INSERT INTO ifk_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Hay nungngadan da kediyen makan ya “manna” ya umat hi bayak nan buwan di coriander ya hay tamtam na ya umat nah tinapay an naha-adan hi danum di iyyukan. ");
INSERT INTO ifk_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kanan Moses nadah tataguy “Kinalin APU DIOS an umitalu taku ketuwen manna an indat nan ditaku tuh ugge naboblayan handih nangipakaanana ke ditakud Egypt ta ahi tibon di iimbabale taku ya inap-apu takuh udum hi algo.” ");
INSERT INTO ifk_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ot kanan Moses ke Aaron di “Umala kah buhi ta huduwam hi kagodwan di talub an manna ya em inha-ad nah kad-an APU DIOS ta ahi panginomnomnoman nadan holag takut nangamung.” ");
INSERT INTO ifk_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Inun-unud Aaron hidiyen kinalin APU DIOS ke Moses ot ena iha-ad nan buhih hinangngab nan kahon nah bohongnan di Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Hituwen manay kinakinan nadan holag Israel handih niha-adan dah nap-at an toon nah ugge naboblayan inggana dimmatong dad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Hay inusal da handi an nunlukud nah manna ya nan omer an maalanay ohan talub.) ");
INSERT INTO ifk_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Tinaynan nadan holag Israel di Sin an oha bon ugge naboblayan ot tagan day ee an un-unudon day kalyon APU DIOS an pangayan da. Indani ya dimmatong dad Repidim ot mungkampu da boh di, muden maid di danum hidi. ");
INSERT INTO ifk_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Bumobboh-ol nadan tatagu ke Moses an mungngudu ya munlili dan kanan day “Idatan dakamih danum an inumon mi!” Mu kanan Moses di “Adi kayu bumobboh-ol ke ha-on! Tipet pinhod yun patnaan di anus APU DIOS ke dakayu?” ");
INSERT INTO ifk_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mu naka-uwo nadan tatagu, ta hidiye nan mungngungudu dan kanan day “Tipet edakami impangulun tumayan ad Egypt ta ekami mateh inuwo takon nadan iimbabale mi ya aaggayam mi?” ");
INSERT INTO ifk_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ot mundasal hi Moses ke APU DIOS an kananay “Apu, nganney atok? Deyan bumobboh-ol hantudan tatagu ke ha-on an tugmilanak mo anhan ke dida.” ");
INSERT INTO ifk_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","6","Ot kanan APU DIOS ke Moses di “Mamangpangulu kayun ume nadah napilin mangipangpanguluh holag Israel. Had-on dakayu nah batu nah Bilid an Sinai. Al-alam nan patanong mun inhoplat mu nah Wangwang an Nile ta ihoplat mu nah batut bumudal di danum an inumon yu.” Inun-unud Moses hituwen kinalin APU DIOS ot ihoplat na nan patanong na nah batu ya bimmudal di danum an ang-ang-angon nadan napilin mangipangpanguluh holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ot ngadanan Moses hidiyen boble hi Massah te hidiy namatnaan nadan holag Israel hi pangan-anusan APU DIOS ke dida. Nginadanana boh Meribah te nundiklamu nadan tatagun hiyan kanan day “An makulug nin an wadah tuh APU DIOS an mangipaptok ke ditaku weno maid?” ");
INSERT INTO ifk_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Handih wada nadan holag Israel ad Repidim ya imme nadan iAmalek ot eda gubaton dida. ");
INSERT INTO ifk_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kanan Moses ke Joshuay “Pumili kah linalakin e manamu nadah mangalin iAmalek an gumubat ke ditaku. Hi bigat ya tumaddogak nah tuktuk di bilid an odnak nan patanong an kinalin Apu Dios an usalok.” ");
INSERT INTO ifk_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Inun-unud Joshuay kinalin Moses ot makigubat da nadah iAmalek. Kediyen munggugubat da ya imme da Moses, hi Aaron ya hi Hur nah tuktuk nan bilid hidi. ");
INSERT INTO ifk_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Deket itagtaggen Moses nan patanong na on mangap-apput nadan holag Israel. Mu deket nablet inda-ul nay taklena on mangap-apput nadan iAmalek. ");
INSERT INTO ifk_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Indani mo anhan ya nabley taklen Moses an mangitatagge nah patanong ot pumulig da Aaron ke Hur hi batu ot ubunan Moses. Numbinah-el dan hiya ot itatag-e day taklena inggana nalin-ob di algo. ");
INSERT INTO ifk_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ot apputon da Joshua nadan iAmalek. ");
INSERT INTO ifk_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Indani ya kimmalih APU DIOS ot kananan Moses di “Itudok yuy mipanggep ketuwen nangapputan yu ta ad-addi makal-iwan. Ya kalyom ke Joshua an ma-idok am-in nadan iAmalek.” ");
INSERT INTO ifk_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Nangapyah Moses hi pun-appitan ke APU DIOS hidi ot ngadana nah “Hi APU DIOS di bandelak.” ");
INSERT INTO ifk_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kanana nadah tataguy “Maphod an hi APU DIOS di nanongnan pundinolan takut hiyat nangamung di makigubat nadah iAmalek.” ");
INSERT INTO ifk_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Indani ya dingngol nan aman nan inayan Moses an hi Jetro an padid Midian am-in nan maphod an inat Apu Dios ke Moses ya nadan ibbanan holag Israel takon di hay nangipakaananan didad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Ot ikuyug na nan imbabalenan hi Sipporah an inayan Moses ya nadan imbabale da an da Gersom ke Elieser. Handi ya impaanamut ni-an Moses hi Sipporah ya nadan imbabaleda ot eda mihaad hi kad-an Jetro. Man-uket nginadanan Moses nan panguluwan hi Gersom ya kananay “Ha-oy ya immaliyak ya abun nakibobleh tu.” Ya nan mihaynod ya nginadananah Elieser gapuh namaddangan Apu Dios ke hiya. Kananay “Hi Apu Dios an daydayawon di aammod ku ya binaddanganak ot ihwangak hi pamatayan nan patul di Egypt ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ingkuyug Jetro dida ot ume dah nungkampuwan Moses nah bilid nah ugge naboblayan an numpatib-an Apu Dios handi. ");
INSERT INTO ifk_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Inilan Moses an mangali da te impamangulu tuwalin amanan impainilan hiyay pangayan dah di. ");
INSERT INTO ifk_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Manatong da ya e dinamun Moses dida ot munyuung hi hinangngab Jetro ot awalona ot ahina ikuyug didah kampuna. ");
INSERT INTO ifk_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ot ab-abigon Moses am-in nadan inat APU DIOS nah patul di Egypt ya nadah tataguna ot ahina ihwang nadan ibbanan holag Israel. Ya inab-abig na bo nadan hinolholtap da mipalpuh kimmaanan dad Egypt inggana dimmatong dah kampu da takon di hay namanaddangan APU DIOS ke dida ke dadiyen nunligatan da. ");
INSERT INTO ifk_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Dingngol Jetroh datuwe ya maan-anla ");
INSERT INTO ifk_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ot kananay “Dayawon takuh APU DIOS te inihwang dakayu nadah inat diyen patul di Egypt ya nadan tataguna ya impatikod nay pumpalpaligat dan dakayun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ad uwani ya inilak mon hi APU DIOS ya natagtag-e tut-uwa mu nadan dios an dayawon di udum an tatagu te ipaptok dakayun tataguna. Ot ihwang dakayun nadah iEgypt an nakababbay panibo dan dakayu.” ");
INSERT INTO ifk_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Indani ya nun-appit hi Jetroh hi maghob ya nadan udum an miappit ke Apu Dios. Kediye ya immali da Aaron ya nadan udum an aap-apun di holag Israel an manamun hiya ta makihamul dah pundayaw dan Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nabigat kediye ot ituluy Moses nan at-attona tuwalih kabigabigat an mangipanuh diklamun nadan tatagu. Te mipalpuh biggatna inggana hilong ya mahanhanot day tatagun mundiklamu. ");
INSERT INTO ifk_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Handih tinibon Jetroh tuwen namahig an naligat an ngunun Moses ya kananay “Tipet oh-ohhaam hituwen am-in an maid di kabaddang mu? Tibtibbok ya madam-ot an abuy ngunum te dakkodakkol ta nangamung di tatagun umalin mumbagah baddang ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","Ya kanan Moses di “Mahapul an atok hituwe te hanah pangipanuwak hi diklamu da ya kediyey pangipainilaak ke dida nah tugun Apu Dios ya am-in nadan pinhod nan maunud.” ");
INSERT INTO ifk_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kanan Jetro ke hiyay “Adi maphod di athitu, ");
INSERT INTO ifk_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","te nakalligat hituwen ngunum yaden ohhaam. Ta loktat ya immingle ka ya athidi bo nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kinali maphod hin donglom tun tugun ku, ot baddangan dakan Apu Dios. Man-u te lebbeng nan itakdog muy tataguh hinangngab Apu Dios ya mumpabaddang kan hiya mipanggep nadah punhahallaan da ");
INSERT INTO ifk_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ya ituttudum ke dida nadan tuguna, hay maphod an pangi-e ya nadan lebbengnan aton da, ");
INSERT INTO ifk_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","mu mahapul muy bumaddang ke he-a. Kinali pumili ka nadah maphod di pangi-e dat diday tudduwom an mangitakdog nadah tatagu. Wadaday mun-ap-apuh hinlibu, hinggatut, nalima ya himpulu. Ya nadan mun-ap-apu ya mahapul an paka-un-unudon dah Apu Dios ya damanan pundinolan didan adida mabayadan hi pangatan dah gaga-iho. ");
INSERT INTO ifk_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ta diday nangamung an mangipanu nadah i-itay an punhahallaan nadan tatagun niukod ke dida. Mu nadan naligat an mipanu ya dadiyey iali dan he-at ipanum ta yumapyap-oy ngunum. ");
INSERT INTO ifk_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Deket un-unudom hituwen kinalik ya deket miunnud hituweh pinhod Apu Dios, ya adika makaliggatan nah ngunum ya malinggop am-in hantudan tatagun umanamut hi nunhituwan da te nipanuy punhahallaan da.” ");
INSERT INTO ifk_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Inun-unud Moses hidiyen tugun Jetro, ");
INSERT INTO ifk_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ot piliyona nadan kabaelan dan mumpangpangulu. Tinuddu na didan mun-ap-apuh himpulu, nalima, hinggatut ya hinlibu. ");
INSERT INTO ifk_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dadiyen napiliy nangamung an mangipanuh punhahallaan nadan tatagut ammuna nadan naligat an adida kabaelan di ie dan Moses. ");
INSERT INTO ifk_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Nagibbu datuwen naat ot ahi umanamut hi Jetroh boble na. ");
INSERT INTO ifk_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Tinaynan nadan holag Israel di Repidim ot ume da nah ugge naboblayan ad Sinai ot mungkampu da nah puun diyen bilid. Handih dimmatngan dah di ya duway bulan di nala-u nipalpuh timmayanan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Indani ya nuntikid hi Moses nah bilid ot e makihummangan ke APU DIOS. Ya kanan APU DIOS ke hiyay “Kalyom hanadah ibbam an holag Israel an kanam di ‘Hituwey kanan APU DIOS: ");
INSERT INTO ifk_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Tinibo yuy inat ku nadah iEgypt ya hay inat kun nangialin dakayuh tun kay dakayu intayyap hi hamuti. ");
INSERT INTO ifk_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Takon di bagik am-in tun wadah luta ya dakayun holag Israel ya abuy piliyok an tataguk hin un-unudonak ta aton yu nadan kalyok an aton yu. Ya mumbalin kayun papadik an mangiat hi pinhod ku.’” ");
INSERT INTO ifk_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nundayyuh Moses ot amungona nadan mangipangpangulu ot kalyonan dida nan kinalin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ya kanan am-in nadan tataguy “Aton min am-in di kinalin APU DIOS.” Imme boh Moses ot ena kalyon ke APU DIOS hidiyen kinali da, ");
INSERT INTO ifk_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ya kanan APU DIOS ke hiyay “Umaliyak an manibon dakayu an hay ang-ang ku ya mahdol an kulabut ta makihummanganak ke he-a ta wada ot an mipalpud uwani ya kulugon daka nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ekat em kalyon hanadah tatagut mundadaan dad uwanin algo ta hi bigat ke ya mundayaw dan ha-on. Kalyom bon didat ibalbal day bubulwati da ");
INSERT INTO ifk_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ta midadaan dah ohhandi an mundayaw ke ha-on te umaliyak tuh tap-on tun bilid ta tibonak ke didan am-in. ");
INSERT INTO ifk_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Mu likkodom an koltogon tun bilid ta kalyom ke didan maid di bumah-el ya maid di tumikid, te wada key adi mangun-unud ya mate. ");
INSERT INTO ifk_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hanan adi mangun-unud ya adiyu daw-ayon, mu panaon yu weno tugmilan yu, takon di aggayam. Ya kalyom ke didan deket waday gimmangoh tangguyub ya umali dan am-in nah puun tun bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Dimmayyu boh Moses ot kalyona nadah tataguy “Mundadaan kayun mundayaw ke APU DIOS hi ohhandi. Dakayu ken nalahin ya adiyu ni-an ihuyop di inayan yu.” Inat nadan tataguy ine-en di punlini dah adol da ya linabaan day bubulwati da. ");
INSERT INTO ifk_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kediyen biggatnah mikatlun algo ya mungkikidul ya mungkikil-at, waday mahdol an kulabut nah tap-on nan bilid, ya waday nal-ot an gangon di tangguyub. Ya munggagayonggong nadan holag Israel gapuh takut da. ");
INSERT INTO ifk_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Impangulun Moses didan e manamu ke Apu Dios ot umohnong da nah puun nan bilid. ");
INSERT INTO ifk_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hi APU DIOS ya apuy di numpatib-ana, kinali nan bilid ya nahophopan hi mahdol an ahuk an mumpaed tap-o an kay nalpuh ongngaongngal an apuy ya namahig an mungkolyog nah bilid. ");
INSERT INTO ifk_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ya pun-olot nan tangguyub di gangona. Indani ya munhummangan da Moses ke Apu Dios an deket kimmalih Moses on himmumang hi Apu Dios an kay gangon di kidul di kalinat donglon am-in nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Indani ya dimma-ul hi APU DIOS nah tuktuk nan bilid ot ayaganah Moses hi kad-ana. ");
INSERT INTO ifk_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kanan APU DIOS ke hiyay “Em kalyon hanadah tatagut adida bumah-el nah koltog an umalih tun e manibon ha-on te deket ipapilit dan umali ya mate da. ");
INSERT INTO ifk_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ya takon nadan padin miabulut an mih-up hi kad-ak ya mahapul an inat da nan ine-en di punlini dah adol da. Te deket uggeda yaden umali dah tu ya kastiguwok dida.” ");
INSERT INTO ifk_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kanan Moses ke APU DIOS di “Adi tumikid nadan tatagu te kanam di adi mabalin an bumah-el da nah koltog.” ");
INSERT INTO ifk_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ot kanan APU DIOS di “Em ikuyug hi Aaron ta umali kayun duwah tu. Mu hanada ken papadi ya nadan tatagu ya adi mabalin an bumah-el da nah koltog an umalih tu te umali da ke ya kastiguwok dida.” ");
INSERT INTO ifk_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ot mundayyu boh Moses ot ena kalyon hidiyen kinalin APU DIOS nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hi Apu Dios ya intuguna datuwe an kananay ");
INSERT INTO ifk_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ha-oy an AP-APU an Dios yun nangipakaan ke dakayud Egypt an nihbutan yu. ");
INSERT INTO ifk_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ha-oy ya abuy Dios an dayawon yun maid di udum. ");
INSERT INTO ifk_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Adi mabalin an ekayu mangapyah ing-ingon di nganneh diyen wadah kabunyan ya luta weno kumpulnan wadah danum ta dayawon yu. ");
INSERT INTO ifk_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Adi mabalin an ekayu munyuung ke dida ya eyu dayawon didan dios yu, te ha-oy an AP-APU an Dios yu ya adik iabulut an waday udum an ibilang yun dios yu. Kastiguwok nadan mangihihhingit ke ha-on takon nadan imbabaleda ya hay inap-apu da ya nadan imbabalen datuwen inap-apu da. ");
INSERT INTO ifk_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mu adi mapoppog di naminhod ku nadah naminhod ke ha-on ya mangun-unud hi tugun ku, takon di nadan mikahinlibun holag da. ");
INSERT INTO ifk_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Adi bo nalgom di pangiusalan yuh ngadan kun AP-APU yu te nan tagun mangiathidi ya adik homkon, mu kastiguwok. ");
INSERT INTO ifk_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Un-unudon yuy ine-en di Sabadun Tungo an niong-ong ke ha-on ta aton yu nadan lebbeng nan maat kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Hanan onom an algo nah hinlingguwan di pangingunuwan yu nadah ngunu yu. ");
INSERT INTO ifk_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mu hana ken mikapitun algo an Sabadu ya niong-ong ke ha-on an AP-APU an Dios yu. Maid di mungngunu ketuwen algo, takon di dakayu, nadan imbabale yun linalaki ya binabai, ya nadan muttatyu yun linalaki ya binabai, nadan aaggayam yu, ya takon nadan hintaguwan an nakiboblen dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Te onom di algoy nunlutuwak tuh luta, nan kabunyan ya nan baybay ya am-in nadan wada ke datuwe. Ot handih mikapitun algo ya nun-iyatuwak, kinali ha-oy an AP-APU yu ya ngilinok hidiyen algon tungo. ");
INSERT INTO ifk_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Un-unudon yu da amayun inayu ta mabayag di kiha-adan yu nah boblen kinalik an idat kun dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Adi kayu pumate. ");
INSERT INTO ifk_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Adiyu ihuyop di bokon yu inayan. ");
INSERT INTO ifk_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Adi kayu mangako. ");
INSERT INTO ifk_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Adiyu kalyon di adi makulug mipanggep hi ibbayu. ");
INSERT INTO ifk_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ya hay manguddidin tugun ku ya adiyu omnawan an ibagiy nganneh diyen wada nah ibba yun tagu umat hi balena, inayana, hay muttatyuna, bakana, kabayuna weno kumpulnan odona.” ");
INSERT INTO ifk_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Handih dingngol nadan tatagu nan kidul, nan nal-ot an gangon nan tangguyub ya tinibo da nan namahig an kil-at ya nan mun-aahuk an bilid ya munggagayonggong dah takut da ot mibata-an da. ");
INSERT INTO ifk_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kanan dan Moses di “He-ay mangibagan dakami nah pinhod Apu Dios an aton mit un-unudon mi ta bokon hiyay kumalin dakami te mate kami.” ");
INSERT INTO ifk_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kanan Moses ke diday “Adi kayu tumakut. Athituy pamatnan Apu Dios ke dakayu ta mangun-unud kayun hiya ta adi kayu munliwat.” ");
INSERT INTO ifk_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mu nanongnan dehdi nadan tatagu nah nidawdawi yaden hi ke Moses ya e nih-up nah mun-aahuk an bilid an kad-an Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kanan APU DIOS ke Moses di “Kalyom hanadah ibbam an holag Israel an kanam di: Hituwey kanan APU DIOS ‘Tinibo yuy inat ku an Dios hi langit an nakihummangan ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kinali ha-oy ya abuy dayawon yu. Adi kayu mangapyah kumpulna on dinayaw yun dios yu umat nadah nakapyah gumok ya balituk. ");
INSERT INTO ifk_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Umala kayuh lutat mangapya kayuh pun-appitan yun ha-on, ta hidiy pun-appitan yuh baka weno kalneron maghob an iappit yun ha-on. Am-in di itudduk an pundayawan yun ha-on ya wadaak an bumaddang ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Adiyu usalon di napahok an batu ten batuy kapyaon yun pun-appitan yun ha-on. Te deket napahok di usalon yu ya adik abuluton di iappit yu. ");
INSERT INTO ifk_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ya adiyu e ikapya nah matalukadan di dalanon yun umeh di. Te deket tumikid kayun mun-appit ya kal-inat waday tagud da-ul ya tibonay tipa yu weno kumpulnan nahaniyan an parten di adol yu.’” ");
INSERT INTO ifk_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kanan Apu Dios ke Moses di “Kalyom hanadah tatagun ");
INSERT INTO ifk_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","kanam di hituwey kinalin Apu Dios ‘Deket waday ginatang yun himbut an ibba yun holag Israel ot ingunuwan dakayuh onom an toon, ya ipae yun libli nah mikapitun toon an maid di bayadanan dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Deket ugge nalahin handih nihbutanan dakayu, mu indani ya nalahin ya malibli ten magibbuh diyen onom an toon, mu adi malibli nan babai. Mu deket nalahin tuwali handih nihbutanan dakayu ya malibli dan duwah kagibbuwan di onom an toon. ");
INSERT INTO ifk_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Deket linahin yu nan himbut yu ta waday imbabaleda ya oha nan himbut yun maliblih kagibbuwan di pungngunuwanan dakayu. Adi malibli nan inayana ya nan imbabaleda te nanongnan dakayuy kombagin dida. ");
INSERT INTO ifk_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mu deket adi pinhod nan himbut yun tumayan te nanongnan pinhod dakayu ya adina pinhod an tayanan nan inayana ya nadan iimbabalena, ");
INSERT INTO ifk_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ya mahapul an ie yuh diyen himbut yu nah pundayawan yun Apu Dios ta ipataddog yuh kad-an di panto ya tinlok yuy inganah kadaklan di tatagu ta kitib-anan mihbut ke dakayu inggana mate. ");
INSERT INTO ifk_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Mu deket babai nan himbut yu ya adi malibli. Adi umat nah lalakin maliblih kagibbuwan di onom an toon. ");
INSERT INTO ifk_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ya deket waday gimmatang hi babain himbut ot iine na, mu indani ya adina pinhod, ya damanan ipabangngad nan igattang hidiyen babai nah pamilyan nangattangana. Adi mabalin an igattang nah hintaguwan te adi maphod hidiyen inat na nah babai. ");
INSERT INTO ifk_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Weno deket wadan dakayuy gumatang hi ohan babait ipaahawana nah imbabalena ya mahapul an ibilang yuh diyen babain imbabale yu damdama. ");
INSERT INTO ifk_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Weno deket wadan dakayuy gumatang hi iiena, mu indani bo ya nangahawah oha ta duwa moy inayana, tibonat adina iwalong hidiyen namangngulun inayana ya adina kaanan nan datin pananud nan hiya takon nan bulwatina, ya adi malumman di pangibilang nan hiya. ");
INSERT INTO ifk_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Te deket adina aton datuwen lebbeng nan atona ya mahapul an ipaenan libli ta maid moy utang nan hiya.’” ");
INSERT INTO ifk_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kanan bon Apu Dios ke Moses di “Kalyom bo nadah tatagun kanam di hituwey kinalin Apu Dios: ‘Deket wadan dakayuy dimmaw-e ot mate nan dinaw-ena ya mahapul an mateh diyen dimmaw-e. ");
INSERT INTO ifk_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mu deket uggena ingnguddan an pinate nan tagu ya kudukdul nay bumtik nah potkonan butikan ta maid di ad-adin maat ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mu deket pimmatey ohan tagun ingnguddana gapuh bungot na ya mahapul an mateh diyen tagu. Takon hin kananat e muntalu nah pundayawan ya eyu lupdukon ta patayon yu. ");
INSERT INTO ifk_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ya deket wadan dakayuy daw-eyonay aammod na ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Hanan umibtik hi ohan tagut ena igattang weno ena pumbalinon hi muttatyu na ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Hanan tagun idutanay aammod na ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Deket nun-awwit di duwan tagu ta dinanug nan oha nan kaawwit na weno tinuktukanah batu ot maliputan, mu ugge nate ya adi makastiguh diyen dimmaw-e. Mu mahapul ");
INSERT INTO ifk_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","an baddanganah diyen dinaw-ena inggana pumhod. Ya bayadanay nataktakan diyen naliputan hi ngununa. ");
INSERT INTO ifk_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Hanan tagun hinalmanan hinoplat di muttatyu nan babai weno lalaki gapuh bungot na ot mate nan muttatyu ya mahapul an makastigu. ");
INSERT INTO ifk_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mu deket nala-uy duwan algo ya ugge nate nan muttatyu ya adi makastigu nan tagu te bagina nan muttatyu. ");
INSERT INTO ifk_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Deket waday nun-awwit ot ilagat da on numbutyug an babai ot mangunu yaden maid di udum an naat ke hiya ya mahapul an mamolta nan tagun nangilagat ke hiya. Hay molta na ya nangamung di kalyon nan inayan nan babain tobalon nadan mangipanuh diklamu. ");
INSERT INTO ifk_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mu deket naliputan nan babai ya mahapul an makastigu nan tagu. Ya deket nate nan babai ya mahapul an mate nan tagu. ");
INSERT INTO ifk_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Deket kinulap di ohan taguy ohan matan di ibbana ya mahapul an kulapon yu damdamay ohan matan nan numbahul. Deke bot pinlag di ohan taguy ohan bab-an di ibbana ya mahapul an polagon yu damdamay ohan bab-an nan numbahul. Deket gini-un di ohan taguy taklen di ibbana ya mahapul damdaman gi-uwon yuy taklen nan tagun numbahul. Deket hay hukin nan taguy nagi-u ya mahapul an gi-uwon yuy hukin diyen tagun numbahul. ");
INSERT INTO ifk_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ya deket inatungan weno liniputan di ohan taguy ibbana ya mahapul an atungan yu ya liputan yu damdamah diyen tagun numbahul. ");
INSERT INTO ifk_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Hanan dumaw-eh muttatyu nan babai weno lalaki ot gapun diye ya nakulap nan muttatyuna ya mahapul an ipaenan liblih diyen muttatyu nat hidiyey bayad di nakulapana. ");
INSERT INTO ifk_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ya deket nakaan di bob-an nan muttatyu ya ipaenan libli nan muttatyu nat hidiyey bayad di naplagan di bab-ana.’” ");
INSERT INTO ifk_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kanan Apu Dios ke Moses di “Kalyom hanadah tataguh tuwe: ‘Deket waday nipaen aaggayam yu ya himmakgud hi tagu ot mateh diyen hinakgud na ya mahapul an tugmilan nan aggayam ta mate. Adi makastigu nan kon bagi nah aggayam ya adiyu ihdah diyen natugmilan an aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mu deket inilan nan kon aggayam an waday hinakgud na handi ya uggena impukung ya deket pimmate nan aggayam hi tagu ya mahapul an matugmilan nan aggayam ta mate ya mahapul an mate damdama nan kon bagi. ");
INSERT INTO ifk_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mu mabalin an adi mipipate nan tagu hin bayadanay ibagan nadan tutulang nan nate ya tobalon nadan mangipanuh diklamu. ");
INSERT INTO ifk_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Takon di lalaki weno babaiy pinaten nan aggayam ya mun-ingngoy kastigun nan kon aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Deket pinaten nan aggayam di lalaki weno babain muttatyu ya mumbayad nan kon aggayam hi tulumpulun silber nah kon muttatyu ya mahapul an matugmilan nan aggayam ta mate. ");
INSERT INTO ifk_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Deket waday kimma-ut hi bitu ya uggena tinabab ot waday mauhbung hi aggayam di udum an tatagu ");
INSERT INTO ifk_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ya mahapul an bayadana nan aggayam. Deket nagibbun binayadana nan kon aggayam ya mabalin an ianamut na nan naten aggayam an kay na ginatang. ");
INSERT INTO ifk_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Deke bot waday duwan bulug an numpatte ot matey oha ya munhummangan nadan kon aggayam ta igattang da nan pimmatet godwaon day bayad na. Ya punggodwa-an da boy dotag nan naten aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mu deket dakol tuwaliy pindug nan bulug hi udum an aggayam mu ugge impukung nan kon bagi takon di kinali dan hiya te mangindol ot deyan pimmate mo anhan hi udum an aggayam ya mahapul an hannotan nan kon bagi nan naten aggayam. Ya deket iabulut nan kon bagi, mabalin an ianamut na nan naten aggayam.’” ");
INSERT INTO ifk_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kanan Apu Dios ke Moses di “Kalyom hanadah tatagun kanam di ‘Hituwey kinalin Apu Dios: Deket waday nangakoh aggayam di ibbana ot patayona weno inggattang na ya naakhupan, ya mahapul an hannotanah diyen inako na. Deket bakay inako na ya liman bakay ihannot na. Deket kalneroy inakona ya opat an kalneroy ihannot na. ");
INSERT INTO ifk_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Mu deket naakhupan mu uggena pinate weno uggena inggattang nan inakonan aggayam ya duway ihannot na, takon di nganneh diyen aggayam. Mu deket adi kabaelan nan nangakon manannot nah inakona ya mahapul an mumbalin an muttatyun nan tagun nangakawanat boklaonay moltana. Deket waday nangakoh hilong ot patayon nan kon bale ya adi makastigu nan pimmate te bokona bahul. Mu deket pinate nah mapat-al te igadul nan mangakoh diyen tagu ya mabahulan ta mahapul an makastigu. ");
INSERT INTO ifk_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Deket waday nanginguddan an nangipaeh aggayam na ot kanonay intanom di udum ya mahapul an hannotan nan kon aggayam di kinan nan aggayam na. Ya hay ihannot na ya nan kapkaphodan an malpuh intanom na. ");
INSERT INTO ifk_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Deket nunlogab di ohan taguh lutana ya indani ya immongngal nan apuy ot ilagat nay intanom di udum ya mahapul an bayadana nan nadadag an nitanom. ");
INSERT INTO ifk_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Deket waday duwan tagun nunhummangan ot ipatalun nan ohay pihhuna weno kumpulnan ngunut na nah oha ya indani ya naakoh diyen impatalu na ya nahamak nan nangako, mahapul an mundubliy ihannot nan nangako. ");
INSERT INTO ifk_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mu deket nama-id nan nipatalu ya kanan nan nangitaluy naako, mu adi mahamak hin dahdiy nangako, mahapul an mahumalyah diyen nangitalu nah pundayawan yu ta mainilaan hin makulug peman nan kinalina. ");
INSERT INTO ifk_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Deket waday diklamu yuh mipanggep hi aggayam yu umat hi baka, kabayu, kalnero weno bulwati weno waday natalak an ngunut yu ya mahapul an eyu ipanu nah pundayawan yu. Ya deket waday natalakan hi kumpulmi ya indani ya hinamak yu nah balen di udum an tagu mu ipilit nan kon balen bagi nah diye ya mahapul an eyu ipanu nah pundayawan yu ta nan kalyon Apu Dios an numbahul ya mundubliy ibayad na. ");
INSERT INTO ifk_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Deket impaptok nan ohan taguy aggayam nan ohan tagu mu indani ya nate nan aggayam weno naliputan weno naako ya maid di tistigu hin nganney makulug an naat, ");
INSERT INTO ifk_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ya mahapul an ume nan nangipaptok ta e munsapatan Apu Dios an maid di ad-adin inat na nah aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Deket ugge naako nan aggayam, adi bayadan nan nangipaptok nan aggayam. Mu deket makulug an naako nan aggayam ya mahapul an bayadan nan nangipaptok hidiyen aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Deket pinaten di mailom an aggayam ya adi mamolta nan nangipaptok, mu mahapul an ena ipatibo nah kon bagi nan naten aggayam ta panginnilaanah naat ya adi bayadan nan numpaptok nan aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Deket waday bimmanoh aggayam di ibbana mu indani ya waday naat nah aggayam ya ugge tinibon nan kon bagi hin nganney ustun naat ya mahapul an hannotan nan bimmano weno bayadanah diyen aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mu deket wada nan kon aggayam ot tibonay naat nah aggayam ya adi bayadan nan namano. Mu deket naabangan nan aggayam ya adi mahapul an mabayadan te nan abang di kay nibayad.’” ");
INSERT INTO ifk_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kanan Apu Dios ke Moses di “Kalyom hanadah tatagun kanam di: Hituwey kinalin Apu Dios ‘Deket inhuyop di ohan lalaki on babain ugge nitbin hiya ya mahapul an iine na nan babai ya idat nay bayad diyen inayana mipuun hi maunud an pangi-e da. ");
INSERT INTO ifk_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mu deket adi pinhod nan aman nan babain muntuluy da ya adida mun-ahawa, mu mahapul an ien nan lalakiy imbango na nah babai. ");
INSERT INTO ifk_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hanadan mun-ayak ya mahapul an mate da. ");
INSERT INTO ifk_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Mahapul an matey makipollot hi aggayam. ");
INSERT INTO ifk_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ya mahapul an mate nan tagun dayawona ya iappitanay udum an dios an bokon ha-on ya abu. ");
INSERT INTO ifk_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Adiyu aton di gaga-iho nadah hintaguwan an nalpuh udum an boblen immalin makiboblen dakayu te takon di dakayu ya ekayu nakibobled Egypt handi. ");
INSERT INTO ifk_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ya adiyu aton di ad-adih nabalun babai ya nadan napuh-ig an u-unga, ");
INSERT INTO ifk_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","te deket mumpahpahmok dan mumbagah baddang ke ha-on ya baddangak dida. ");
INSERT INTO ifk_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ta gapuh namahig an bungot ku ya ipaalik di mangubat ke dakayu ta patayon dakayu ta mabalu nadan iinayan yu ya mapuh-ig nadan iimbabale yu te maid kayun aama da. ");
INSERT INTO ifk_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ya deket mumpautang kayuh pihhuh ibba yun Hebrew an munhapul hi baddang, ya adiyu iun-unud nadah udum an mumpautang hi pihhu. Adiyu ipaporsientoy ipautang yu. ");
INSERT INTO ifk_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ya deket inala yuy bulwatinan pangid-onan yu nah inutang na ya kahilohilong on imbangngad yu ni-an nan bulwati na ");
INSERT INTO ifk_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ten ammunah diyen wadan hiya. Te deket adiyu iathidi ya maktol ta adi mo pakahuyop hi kintol na. Te deket adiyu ipabangngad ta mumpahpahmok ke ha-on ya makulug an idat kuy ibagana, te ha-oy ya makaulleyak nadah mahmok an tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Adiyu pihulon weno eyu kalyon di gaga-iho nadah napilin mangipangpangulun dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Deket nat-ong di page yu, napgot di mainum yu ya nal-um di bungan di intanom yu ya adiyu ibbahon umiappit ke dadiyen lebbengnan miappit ke ha-on. Ya mahapul an iappit yun ha-on nadan panguluwan an imbabale yu, mu hay aggayam di ihannot yun iappit. ");
INSERT INTO ifk_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ya iappit yun ha-on nan namangulun impan di baka yu weno kalnero yu. Pakiadduman yun inanah pitun algo ya in-appit yun ha-on hi mikawalun algo. ");
INSERT INTO ifk_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Deket waday aggayam yun pinaten di mailom an aggayam ya adiyu ihda, mu ipakan yuh ahu yu te tagu dakayun ha-on.’” ");
INSERT INTO ifk_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Kanan Apu Dios ke Moses di “Kalyom hanadah tatagun kanam di ‘Hituwey kinalin Apu Dios: Adiyu ihinap di kumpulnan adi makulug. Ya deket muntistigu kayu ya adiyu kalyon di langkak ta baddangan yu nan numbahul. ");
INSERT INTO ifk_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Takon di dakdakol day mangat hi gaga-ihon munlangkak dan muntistigu ta adi maat di limpiyu ya adiyu itakdog weno eyu unnudan hidiyen aton da. ");
INSERT INTO ifk_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ya adi gapu te nawotwot nan nundiklamu ya hiyay baddangan yu. ");
INSERT INTO ifk_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Deket waday tinibo yun bimmukan an aggayam ya guyudon yu ta ie yu nah kon bagi, takon di buhul yuh diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Deket mumpaligat di nuwang nan buhul yun adi pakataddog te madam-ot di kargana ya baddangan yu nan tagu ta pataddogon yu nan nuwang na, adi na-ala ya eyu la-uwan. ");
INSERT INTO ifk_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Adiyu kastiguwon di ohan tagu, takon di inila yun maid di bahul na gapu te nawotwot. ");
INSERT INTO ifk_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ya adi na-ala on pabahulon yuy ohan tagu, takon di inila yun maid di bahul nat pipate yu, te kastiguwok di mangat hi athinan gaga-iho. ");
INSERT INTO ifk_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Deket kanan di ohan taguy bayadan dakayu ta itakdog yu nah gaga-ihon atona ya adiyu abuluton. Hay athidin bayad ya kay na kulapon di tagu ta adi maat di limpiyu nadah maid di bahulna. ");
INSERT INTO ifk_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Adiyu aton di ad-adi nah hintaguwan an immalih boble yu te inila yuy gibok na te takon di dakayu ya hiniktaman yuy athidi handih nakiboblayan yud Egypt.’” ");
INSERT INTO ifk_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","11","Kanan Apu Dios ke Moses di “Kalyom hanadah holag Israel an kanam di ‘Onom an toon di punliyakan yuh papayo yu ya onom an toon di puntanoman yuh lalagunta yu ta waday aniyon yu weno apiton yuh kanon yu. Mu hanah mikapitun toon ya miathidi, adiyu ngunuwon. Ya deket waday ibungan nan datin intanom yuh di ya ihulug yu nadah nawotwot ta pangalaan dah kanon da. Deket waday tindaan da ya miathidit panganan damdaman nadan aggayam hi muyung. ");
INSERT INTO ifk_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Hi hinlingguwan ya onom an algoy pungngunuwan yu, mu hanah mikapitun algo ya itikod yun mungngunu. Ta mun-iyatu damdama nadan muttatyu yu ya nadan nalpuh udum an boblen pungngunuwon yu, takon nadan aggayam yun pun-aladuwon yu ya mun-iyatu da damdama. ");
INSERT INTO ifk_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Tibon yu ta un-unudon yun am-in datuwen kinalin APU DIOS. Adiyu dayawon di udum an dios ya adiyu oggan kalyon di ngadan da.’” ");
INSERT INTO ifk_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kanan Apu Dios ke Moses di “Kalyom hanadah tatagun kanam di: Hituwey kinalin Apu Dios: ‘Adiyu kal-iwan an aton nan tulun piyestah katootoon. ");
INSERT INTO ifk_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Hay mamangulu ya nan Piyestan di Tinapay an ugge naha-adan hi mumpalbag an miunnud nah kinalik ke dakayun aton yu handih wada kayud Egypt. Adi kayu mangan hi pitun algo hi tinapay an nakammohan hi mumpalbag. Ya mahapul an waday iappit yu nah pundayawan yun ha-on ketuwen piyesta. ");
INSERT INTO ifk_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Hay mihaynod ya nan Piyestan di Ani. Aton yuh tuwen piyesta nah pangilappuwan yun pun-aniyan. Ya aton yu nan Piyestan di Kampu nah ahi polagan hi grapes ya nan udum an bungbunga-an ");
INSERT INTO ifk_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Katootoon hi pangatan yu ke datuwen tulun piyesta ya mahapul an umalin am-in di linalakin mundayaw ke ha-on an AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Adiyu iappit di tinapay an nakammohan hi mumpalbag nah pun-appitan yuh aggayam. Tibon yu ta maid di matdaan hi kabigatana nadah taban di aggayam an iappit yun ha-on ke datuwen piyesta. ");
INSERT INTO ifk_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ya mahapul an ie yuh balek an AP-APU an Dios yuy kapkaphodan hanadah mamangulun bungan di intanom yu ta miappit ke ha-on.’” Adiyu iha-ang di impan di kalnero weno gulding nah gatas inana. ");
INSERT INTO ifk_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Kanan bon APU DIOS ke Moses di “Kalyom hanadah tatagu an kanam di hituwey kinalin APU DIOS: ‘Itud-ak kuy anghel kun mangipangpangulun dakayu inggana dumatong kayu nah boblen indadaan kun pangayan yu. ");
INSERT INTO ifk_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Un-unudon yuy kalyon tuwen anghel. Adiyu ngohayon te ha-oy di nangitud-ak ke hiya. Deket ngohayon yu ya adi dakayu pakawanan. ");
INSERT INTO ifk_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mu deket un-unudon yu ta aton yun am-in di kalyona ya ha-oy di nangamung an manangga nadah makibuhul ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Hidiyen anghel kuy mangipangulun dakayu inggana dumatong kayu nah boblen nadan Amorite, Hittite, Perisite, Kanaanite, Hibite ya nadan Jebusite. Ha-oy an Dios di makihanggan dida ta dadagok dida. ");
INSERT INTO ifk_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Adiyu dayawon nadan dios da ya adiyu un-unudon nadan aton dan mundayaw hi dios da. Dadagon yu ot ya abu nadan kinapya dan dios da ya nadan hina-ad dan batun dayawon da. ");
INSERT INTO ifk_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Deket ha-oy an AP-APU an Dios yuy dayawon yu ya idatan dakayuh kanon yu ya hay danum an inumon yu, ya kaanok di dogo yu. ");
INSERT INTO ifk_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ya maid nadah babai yuy mangunu ya maid di adi pakaimbabale. Ya idatan dakayuh andukken biyag. ");
INSERT INTO ifk_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Patakutok ya allilawok nadan mangubat ke dakayu ta mangali kayu yaden mamtik da. ");
INSERT INTO ifk_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Pamanguluwok an ipaey inalit ta abulon da nadan Hibite, nadan Kanaanite ya nadan Hittite an wadah di. ");
INSERT INTO ifk_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mu tibok ta adida mamingpinghan makaan am-in hi ohan toon ta maid di e matdaan. Te deket matoan nadan boble ya dumakol di mailom an aggayam ya katatakut bo kayay athidi. ");
INSERT INTO ifk_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Hay atok ya in-inutok didan pakaanon hidi inggana dumakol kayu ta punuwon yu nan boble. ");
INSERT INTO ifk_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ahik ihamad di poppog nan boblen pangayan yu mipalpun nah Maingit an Baybay ta dumatong nah baybay ad Pilistia ta umen nah ugge naboblayan inggana nah Wangwang an Euphrates. Baddangan dakayu ta apputon yu nadan numbobleh did uwani, ta dog-alon yu didah pangayan yuh di. ");
INSERT INTO ifk_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mu adi kayu makihayyup ke dida weno ekayu makid-um an mundayaw nadah dios da. ");
INSERT INTO ifk_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ya adiyu iabulut didan makiboble ke dakayu te maawis kayun mangat hi punliwatan nah pundayawan dah adi makulug an dios. Te deket aton yuh diye ya madadag kayu.’” ");
INSERT INTO ifk_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kanan APU DIOS ke Moses di “Ikuyug mu da Aaron, hi Nadab, hi Abihu ya nadan napitun mangipangpangulu nadah holag Israel ta tumikid kayu tuh kad-ak. Mu umohnong da nah nibata-an an mundayaw ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","He-a ya abuy mih-up ke ha-on, mu nadan ikuyug mu ya midawdawi da. Ya nadan tatagu ya adi mabalin an tumikid da tuh bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Dimmayyuh Moses ot kalyona nadah tatagun am-in nadan intugun APU DIOS an aton da. Ya am-in nadan tatagu ya kanan day “Aton min am-in danaen kinalin APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Am-in nadan kinalin APU DIOS an tuguna ya intudok Moses. Nabigat kediye ya himmalaman hi Moses ot e mangapyah pun-appitan ke APU DIOS nah puun nan bilid ot ha-adonay himpulut duwan batun nah nunlinikkod diyen pun-appitan an mangitakdog nadah himpulut duwan imbabalen din ammod dan hi Israel. ");
INSERT INTO ifk_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Indani ot ahina baalon di kakat-agun linalakin mun-appit ke APU DIOS hi maghob ya ka-ongal nan lakin babakan miappit hi punlinggopan da. ");
INSERT INTO ifk_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Inalan Moses di godwan di dalan nadan niappit ot pun-iha-ad nah mamalukung. Hanan godwana ya inwaghik na nah kinapya nan pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ya inalana nan liblun nangitudkana nadah Tugun APU DIOS ot oltonan ibidbid nadah tatagu. Kanan nadan tataguy “Un-unudon mih APU DIOS ya aton min am-in di kinalina.” ");
INSERT INTO ifk_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Inalan Moses nadan malukung ot waghikana nadan tataguh dalan kananay “Hituwen dalay mangihamad nah kinalin APU DIOS an atonan dakayu handih nangidatanan am-in ke datuwen Tugun.” ");
INSERT INTO ifk_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nagibbuh diye ot ikuyug Moses hi Aaron, hi Nadab, hi Abihu ya nadan napitun mangipangpangulu ot tumikid da nah bilid ");
INSERT INTO ifk_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ya tinibo da nan Dios dan holag Israel. Hanan timmaddogana ya kay naap-apan hi batun sapphire an munlinnang an kay ang-ang di kabunyan ten maid di kulabut. ");
INSERT INTO ifk_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Takon di inang-ang datuwen mangipangpangulun holag Israel hi Apu Dios ya uggena dinadag dida. Nangan da ya nanginum dah dih hinangngab na. ");
INSERT INTO ifk_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Indani bo ya kanan APU DIOS ke Moses di “Tumikid ka tuh bilid an kad-ak ta mihtu kat idat kun he-a nan duwan batun kitudokan nadan Tugun kun un-unudon nadan tatagu.” ");
INSERT INTO ifk_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ot umgah Moses an ibbana nan bumadbaddang ke hiyan hi Joshua ot tumikid da nah bilid. ");
INSERT INTO ifk_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kediyen inumgahan da ya kimmalih Moses nadah udum an aap-apun kananay “Had-on dakami inggana mibangngad kami. Deket waday diklamu yu ya ume kayun da Aaron ke Hur.” ");
INSERT INTO ifk_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Handih manikid da Moses ya hinophopan di kulabut nan bilid. ");
INSERT INTO ifk_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Hidiyen kulabut an kitib-an di kawadan APU DIOS ya niha-ad kediyen bilid hi onom an algo. Ya hanah mikapitun algo ya kimmalih APU DIOS nah kulabut ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Hay nangang-ang nadan holag Israel an wada nah puun nan bilid hi dayaw APU DIOS nah tap-on nan bilid ya kay mundadalebdeb an apuy. ");
INSERT INTO ifk_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Immeh Moses nah tap-otap-on nan bilid an hinophopan nan kulabut ot mihdih nap-at an algo ya nap-at an hilong. ");
INSERT INTO ifk_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kalyom hanadah holag Israel ta iappitanak ke dida. Dawatom dadiyen iappit dan ha-on mipuun hi pinhod dan idat. ");
INSERT INTO ifk_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Datuwey damanan iappit da: Hay balituk, silber ya giniling, ");
INSERT INTO ifk_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","hay tinulid an blue, purple ya maka-ingit, hay makaphod an luput ya hay luput an nakapyah dutdut di gulding, ");
INSERT INTO ifk_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","hay lalat di lakin kalneron numbalin hi maingit, hay lalat di matagun wadah baybay, hay kaiw di akasia, ");
INSERT INTO ifk_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","hay lanan di oliban mihuduh kingke, nadan makapyah lanan miduyag hi ulu, hay bangbanglun insenso, ");
INSERT INTO ifk_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","hay onyx ya nadan udum an nungkanginan batun mitakap hi ephod nan padi ya nah luput an mitakap nah pagona. ");
INSERT INTO ifk_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ya mahapul an ikapyaanak hi abung an tuldan kiha-adak ta makibobleyak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kapyaon yuh tuwen Tabernacle an miunnud nah itudduk an pangapya yu.” ");
INSERT INTO ifk_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Kanan bon APU DIOS ke Moses di “Umala kah kaiw an akasia ta mangapya kayuh kahon an nap-at ta liman pulgaday kadukke na, duway pulut pitun pulgaday kabilog na, ya duway pulut pitun pulgaday katag-e na. ");
INSERT INTO ifk_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Amhon yuh balituk an namahma, takon nan dallomna. Ya takapan yu boh balituk hi nunlinikkod ta milibod ketuwen kahon. ");
INSERT INTO ifk_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ya ikapya yu boy opat an natuligonggong an balituk kediyen kahon an hindudwah numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ya mangapya kayuh pun-attang hi kaiw an akasia an takapan yuh balituk. ");
INSERT INTO ifk_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Iduduk yu datuwe ke dadiyen natuligonggong an nitakap nah Kahon ta pun-attang. ");
INSERT INTO ifk_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Datuwen pun-attang ya miathidin adi mabalin an e makaan. ");
INSERT INTO ifk_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Nagibbu ke ya ihudum kediyen Kahon nan idat kun he-an duwan batun nitudokan nadan Tugun ku. ");
INSERT INTO ifk_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Mangapya kah hukap tuwen Kahon an hay kapyaom ya namahman balituk. Hay kadukkena ya nap-at ta liman pulgada ya duwampulut pitun pulgaday kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Mangapya kah duwan anghel hi numbinongwa ketuwen hukap an miohhay kapyana. ");
INSERT INTO ifk_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Munhinnangga dan mabokyag di payak dat hophopan dah tuwen hukap. ");
INSERT INTO ifk_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ihukap mu kediyen Kahon an kapyaon yun pangiha-adam hanadah duwan batun ahik idat ke he-a. ");
INSERT INTO ifk_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ahiyak umali nah tap-on nan hukap an numbattanan dadiyen duwan anghel ta idat kun he-an am-in nadan Tugun kun un-unudon yun am-in an holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kanan bon APU DIOS ke Moses di “Umala kah tablan akasia ta mangapya kah lamesaan. Hay kadukkena ya tulun piye, ohat godwan piyey kabilog na ya duwan piye ya tulun pulgaday katag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Oddahan yuh balituk ya takapan yu boh balituk di nunlinikkod nan pingngit na. ");
INSERT INTO ifk_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Da-itan yuh tulun pulgaday pipingngit nan lamesaan ya tinakapan yuh balituk. ");
INSERT INTO ifk_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kapyaan yuh hin-oh-an natuligonggong an balituk nadan opat an hukin diyen lamesaan hanadah duguna. ");
INSERT INTO ifk_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ikapya yu datuwen natuligonggong nah da-ul di pingngit nan lamesaan. ");
INSERT INTO ifk_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ya mangapya kayuh akasian pun-attang nah lamesaan an amohon yuh balituk. ");
INSERT INTO ifk_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Mangapya kayuh namahman balituk an duyu, basu, buwod ya malukung an pangiduyagan yuh mainum an iappit yu. ");
INSERT INTO ifk_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mahapul an wadat nangamung di tinapay an iha-ad yuh hinangngab ku nah lamesaan an kapyaon yu.” ");
INSERT INTO ifk_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Kanan bon APU DIOS di “Mangapya kayuh namahman balituk an pangipattukan hi dilag. Pandayon yuy puuna ya palat na. Iohha yuy pangapya yun dadiye nadah kay basun kiha-adan nadan dilag ya nadan palawer an al-alkus na. ");
INSERT INTO ifk_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hidiyen pangipattukan hi kingke ya onom di hapang nan hintutluh numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Nip-ong ke dadiyen onom an hapang di basun kay habung di almond di pormana. ");
INSERT INTO ifk_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Hanan adol nan pangipattukan hi kingke ya naal-alkusan hi opat an kay damdama habung di almond di pormana. ");
INSERT INTO ifk_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ya ip-ong yuy hin-oh-an habung an ugge nabokyag an ikapya yu nah da-ul di nundammuwan nadan hindudwan hapang nan pangipattukan hi kingke. ");
INSERT INTO ifk_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Datuwen habung an ugge nabokyag ya nadan hapang ya miohhan kapyaon yu nah kipattukan di kingke. Am-in datuwe ya makapyah namahman balituk. ");
INSERT INTO ifk_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Mangapya kayuh pitun kingket ipattuk yu ketuwen kapyaon yun kipattukan dat madilagan di hinangngab na. ");
INSERT INTO ifk_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mahapul an namahman balituk di kapyaon yu nadah ipit ya ambilog an duyun pangiha-adan hi bala. ");
INSERT INTO ifk_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Umeh tulumpulut opat an kiloy dam-ot nadan balituk an kapyaon yu ketuwen pumpattukan hi kingke ya nadan kapkapya na. ");
INSERT INTO ifk_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mahapul an paka-i-un-unud yun kapyaon datuwe nah impatibok ke dakayu tuh bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Kanan bon APU DIOS di “Athituy pangapya yu nah Tabernacle an kiha-adak: Mangapya kayuh himpulun kurtinan makaphod an luput an usalon yuy tinulid an blue, purple, ya maka-ingit ya bordaan yu datuweh anghel. ");
INSERT INTO ifk_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Am-in datuwen kurtina ya mun-iingngoy kabilog dan umeh nap-at ta duwan piyey kadukke da ya onom an piyey kabilog da. ");
INSERT INTO ifk_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pundada-iton yuy lima ke datuwen luput ta miohha da. Athidi bo nah liman kurtinan pundada-iton yu dida. ");
INSERT INTO ifk_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ya ahi kayu immalah blue an linubid ta tuligonggongon yu ya ingkugut yu datuwe nadah pingngit nadan duwan namingngit an kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Hinnanalimay ikapya yun natuligonggong hi pingngit dadiyen duwan kurtina ya mahapul an mumpopottok da. ");
INSERT INTO ifk_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ya mangapya kayuh naliman balituk an ipit ta pangipit yu ke datuwen duwan kurtina ta miohha nan dingding nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Umala kayuh dutdut di gulding ta kapyaon yuh himpulut ohan kurtinan pun-odda yu nadah luput an kurtinan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Pun-iingngohon yu dadiyen kurtinan hay kadukken di oha ya nap-at ta liman piye ya onom an piyey kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pundada-iton yuy lima ke datuwen kurtinat miohha da. Athituy aton yu nah onom bon kurtinan pundada-iton yu dida. Hanan mikan-om ya makuppin an mauy-uy nah hogpan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ikapya yuy hinnanaliman natuligonggong nadah nundammuwan dadiyen lima ya onom an kurtinan nundada-it. ");
INSERT INTO ifk_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ya mangapya kayuh naliman giniling an pangipit yuh pundammuwan datuwen kurtinat miohha da. ");
INSERT INTO ifk_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mauy-uy di udun tuwen tulda nah indoggan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ya mauy-uy boh numbinah-el hi pingngit nan Tabernacle hi umeh himpulut walun pulgaday kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Mangapya kayu pay hi duwan tuldan lalat di lakin kalnero ya lalat di gulding ta iodda yu. Athituy aton yun mangatop nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ikapya yu boy akasian kaiw hi kalkalimangngan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Hay katag-en nadan frames an ikapya yu ya himpulut liman piye ya hay kabilog da ya duwampulut pitun pulgada. ");
INSERT INTO ifk_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ha-adan yun am-in nadan frames hi mun-iingngon hindudwan nidongdong an kaiw ta munhuhu-up da. ");
INSERT INTO ifk_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","21","Ipataddog yuy hindudwampulun datuwen frames hi nangappit hi south ya hi north nan Tabernacle. Ya ikapya yuy nawalun silber an pangipab-unan ke datuwen frames an hindudway mikapyah puun di oha. ");
INSERT INTO ifk_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Hanan awidan nan Tabernacle an nangappit hi kalin-oban di algo ya ipataddog yuy onom hanadah frames ");
INSERT INTO ifk_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ya ipataddog yu boy hin-oh-an hanadah duwan duguna. ");
INSERT INTO ifk_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Datuwen duwan frames an mikapyah duguna midokkop da mipalpuh puuna inggana tap-onan mihuklub di natuligonggong ta miohha da. Athidiy aton yu nadah duwan dugu. ");
INSERT INTO ifk_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kinali, walun am-in di frames di ikapya yu kediyen indoggan nan Tabernacle ya iha-ad yu boy himpulut onom an silber an pangipab-unan ke dadiyen frames ta hindudwah ohan frame. ");
INSERT INTO ifk_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Mangapya kayuh himpulut liman kaiw an akasian miballabag nadah frames nan Tabernacle. Ikapya yuy hinlilmah nangappit hi north, hi south ya hi awidan an nangappit hi kalin-oban di algo. ");
INSERT INTO ifk_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Hana ken migawwan miballabag nah gawwan nadan mipataddog an frames ya mikapyah ohan pangngelna ya munlikkod nah ha-ob na. ");
INSERT INTO ifk_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ya amhon yuh balituk datuwen frames an mipataddog ya nadan miballabag an kaiw. Mangapya kayu boh natuligonggong an balituk an mangdon hanadah miballabag an kaiw. ");
INSERT INTO ifk_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kapyaon yu nan Tabernacle an iingngo yu nah impatibok ke dakayu tuh bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kanan bon APU DIOS ke Moses di “Holdakon yuh kurtinay bohongnan Tabernacle hi makaphod an luput an nabordaan hi anghel. Hay color diyen luput ya blue, purple ya maka-ingit. ");
INSERT INTO ifk_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ihable yuh tuwen kurtinah opat an tukud an akasia an matakapan hi balituk ya makapyaan hi balituk an hablayan. Dadiyen tukud ya mipataddog hi silber an pangipataddogan. ");
INSERT INTO ifk_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Iha-ad yu nan kurtinah bohongnan nan Tabernacle an hidiyey munholdak nah Nasantun Kuwartu ya nah Nakassantun Kuwartun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ya iha-ad yu nan hukap nan Kahon APU DIOS hidi nah Nakassantun Kuwartu. ");
INSERT INTO ifk_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Iha-ad yu nan lamesaan an kapyaon yu nah binnah-el nan kuwartun APU DIOS, takon nan kipattukan di kingke. Munha-ob dan miha-ad hi kannigid nan lamesaan ya nan kipattukan di kingkeh kannawan. ");
INSERT INTO ifk_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Mangapya kayu boh ohan kurtinah hogpan nan Tabernacle. Hay kapyaon yu ya makaphod an luput an blue, purple ya maka-ingit, ya ip-iphod yun bordaan. ");
INSERT INTO ifk_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ikapyaan yuh tuwen kurtinah balituk an kawit na ya liman tukud an akasian maamoh balituk ya mipab-un dah giniling.” ");
INSERT INTO ifk_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Kanan bon APU DIOS ke Moses di “Kapyaon yu nan altar an usalon yuy akasian kaiw. Hidiyen altar ya kuwadladun pitut kagodwan piyey kadukkena ya kabilog na, ya opat ta kagodwan piyey katag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ya ikapya yuy kay hakgud nadah tap-on nan opat an dugunan miohhay kapyana nah altar. Nagibbu ken kinapya yu ya amhon yuh giniling. ");
INSERT INTO ifk_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mangapya kayu bo nadah mahapul hi pun-appitan umat hi baldin pangiamungan yuh dap-ul, hay pala, hay palanggana, hay tobong di dotag an miappit ya hay palhun pangaan yuh balan di nun-apuyan yu. Giniling di kapyaon yun am-in ke datuwe. ");
INSERT INTO ifk_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ya mangapya kayuh giniling an nalagga ya takapan yuh opat an giniling an natuligonggong nan opat an duguna. ");
INSERT INTO ifk_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Iha-ad yuh tuwen nah dallom nan altar nah gawwanan mihak-ot nah nakapyan kihak-otana. ");
INSERT INTO ifk_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Mangapya kayuh duwan akasian kaiw an pun-attang nah altar an amohon yuh giniling. ");
INSERT INTO ifk_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Iduduk yu datuwe nadah natuligonggong an mitakap hi numbinah-el nan altar ta pangid-onan nadan mangiattang. ");
INSERT INTO ifk_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hanan pun-appitan an kapyaon yu ya makapyah tabla, mu adi madulungan di puuna. Iun-unud yuy pangapya yu nah impatibok ke dakayu tuh bilid.” ");
INSERT INTO ifk_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kanan bon APU DIOS ke Moses di “Mangapya kayuh dolan nan Tabernacle ya kurtinaan yuh makaphod an luput hi nunlinikkod diyen dola. Hanah nangappit hi south ya hinggatut ta naliman piyey kadukken di ikurtina yu. ");
INSERT INTO ifk_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Duwampulun tukud an giniling an mipab-un hi duwampulu bon giniling an pangipab-unan di mangdon ke dadiyen kurtina. Mihable dan nadah silber an kawit ya silber an pangihablayan an nikapya nadah tukud. ");
INSERT INTO ifk_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Athidi bo damdamay aton yu nah nangappit hi north. Hinggatut ta nalimay piyen kadukken di ikurtina yun mihableh silber an kawit ya silber an pangihablayan an mikapya da nadah duwampulun giniling an tukud an mipab-un hi duwampulun giniling an pangipab-unan. ");
INSERT INTO ifk_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ya hanah nangappit hi kalin-oban di algoh indoggan nan Tabernacle ya napitut limay kadukken nan mikurtina. Himpuluy tukud nan mipataddog hi himpulun pangipataddogan. ");
INSERT INTO ifk_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Athidi bo nah hogpan nah Tabernacle nah nangappit hi timilan di algon makurtinaan hi napitut liman piyey kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Kediyen hogpan ya ikapya yuy duwan kurtina, ohan kurtinah kannawan ya oha bon kurtinah kannigid. Hindudwampulut duwat kagodwan piyey lukud di oha ya hintutluy tukud an mipataddog hi tulun nakapyan pangipataddogan di kihablayan datuwen kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hana ken gawwan nan hogpan nah dolan nan Tabernacle an tulumpulun piyey kabilog na ya kurtinaan yuh makaphod an luput ya inip-iphod yun binordaan hi blue, purple ya maka-ingit an tinulid. Mihableh tuwen kurtinah opat an tukud an mipab-un hi opat an makapyan pangipab-unan. ");
INSERT INTO ifk_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Am-in nadan tukud nah dolan nan Tabernacle ya makapyaan hi silber an kawit ya pangihablayan, ya mipab-un dah namahman giniling an pangipab-unan. ");
INSERT INTO ifk_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kinali, hay lukud di dolan nan Tabernacle ya hinggatut ta naliman piyey kadukkena ya napitut liman piyey kabilog na ya pitut kagodwan piyey katag-ena. Hanan kurtinan mausal ya mahapul an makapyah makaphod an luput. Hanadan pangipab-unan hanadah tukud an mangdon hanadah kurtina ya makapyah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Am-in nadan mausal nah Tabernacle, nadan paghok na ya paghok nan dolana ya makapya dah giniling.” ");
INSERT INTO ifk_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Imandal mu nadah ibbam an holag Israel ta umiali dah kapkaphodan an lanan di oliban mausal nadah kingken miha-ad nah Tabernacle ta mundadalang dat nangamung. ");
INSERT INTO ifk_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Hanan kipattukan di kingke ya miha-ad hi binnah-el nan kurtinah kuwartun APU DIOS. Hi Aaron ya nadan imbabalenan linalakiy mumpaptok ke dadiyen kingke ya mahapul an mundadalang dat nangamung nah hilong inggana biggatnah dih APU DIOS. Munnananong hituwen olden an aton di holag Israel ya nadan imbabale da.” ");
INSERT INTO ifk_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kanan bon APU DIOS ke Moses di “Hi Aaron an ibam ya nadan imbabalenan linalakin hi Nadab, hi Abihu, hi Eleasar ya hi Itamar di natuddun mumpadin munhilbin ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mumpakugut kah bulwatin di padin ibulwatin Aaron ta midayaw ya ta maphod di ang-ang na nah pangatanah ngunu na ya ta kitib-anan hiya ke ya niong-ong ke ha-on an Dios. ");
INSERT INTO ifk_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kalyom hanadah nalaing an mungkugut ta kuguton day bulwatin Aaron ta matibon hiya ke ya niong-ong an mumpadi ta munhilbin ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Datuwe nadan makugut an usalon di padi: Hay luput an mitakap hi pago, hay ephod, hay mioddah bulwati, hay nabordaan an bulwati, hay mipngot hi ulu ya hay miawako. Mumpakugut ka boh makaphod an ibulwatin nadan linalakin imbabalen Aaron hi pangatan da nah ngunu dan padi ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mahapul an makaphod an luput di makugut ke datuwe ya mabordaan dah balituk an tinulid, hay blue, hay purple, ya hay maka-ingit. ");
INSERT INTO ifk_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Hay makaphod an luput di kapyaon yun ephod ya mabordaan hi balituk an tinulid, hay blue, hay purple ya hay maka-ingit. ");
INSERT INTO ifk_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hituwen ephod ya duwan luput an nun-appil an ohah hinangngab ya ohah odog an odnan di duwa bon luput an mihableh pukol. ");
INSERT INTO ifk_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mahapul damdaman hay makaphod an klasen luput di mausal ketuwen duwan luput an mangdon nah ephod ya mipmiphod an mabordaan hi balituk an tinulid, hay blue, hay purple ya hay maka-ingit. ");
INSERT INTO ifk_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Umala kayuh duwan batun onyx ta ikul-it yuh diy ngadan nadan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Onom an ngadan di mikul-it hi ohan batu ya onom bo nah oha ta mikul-it am-in di ngadan nadan holag Israel mipuun hi nunhahaynodan dan nitungo, mipalpuh panguluwan ingganah udidiyan. ");
INSERT INTO ifk_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ikul-it mu datuwen ngadan di holag Israel umat hi pangat nan nalaing an mangikul-it hi sinyal nah nanginan batu. Itakap mu datuwen duwan batu nah balituk an kiha-adan da. ");
INSERT INTO ifk_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Itakap mu datuwe nah duwan luput an nunha-ob an mihableh pukol an nikugut nah ephod ta panginomnomnoman hanadah himpulut duwan holag Israel. Ahi ihablen Aaron hi pukol na dadiyen nikul-itan di ngadan dat nomnomnomok ta nangamung di tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Itakap mu nimpe nadan duwan batu nah balituk. ");
INSERT INTO ifk_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Mangapya kah duwan kay linubid an nakapyah namahman balituk ta igakod mu nadah duwan batu. ");
INSERT INTO ifk_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Mangapya kayuh mitakap nah pagon nan padit usalonan manginilah pinhod APU DIOS an maat. Miingngoy usalon yu ketuwe nah kapyaon yu nah ephod ya ip-iphod yu damdaman bordaan. ");
INSERT INTO ifk_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kuwadladuh tuwen luput ya makuppin an hiyam an pulgaday kadukkena ya kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Itakap yu ketuwey opat an linyan nunhihinnatkon an nabalol an batu. Hanah mamangulun linya ya itakap yuy ruby, topaz ya garnet. ");
INSERT INTO ifk_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Hanah mikadwan linya ya emerald, saphire ya diamond. ");
INSERT INTO ifk_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Hanah mikatlun linya ya turquoise, agate, ya amethyst. ");
INSERT INTO ifk_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ya hanah mikap-at an linya ya beryl, onyx ya jasper. Mitakap datuwen am-in an nanginan batu hi balituk. ");
INSERT INTO ifk_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Mip-ong di ngadan nadan himpulut duwan imbabalen Jacob an mitudok nadah nanginan batut itakdog day himpulut duwan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ikapyaan yuh tuwen luput an mitakap hi pagoh kay nalubid an banggol an namahman balituk, ");
INSERT INTO ifk_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ya mangapya kayuh duwan natuligonggong an balituk ta mikugut nah duwan nuntap-on duguna, ");
INSERT INTO ifk_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ya inggakod yu nan duwan kay nalubid an balituk ke datuwen natuligonggong. ");
INSERT INTO ifk_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Igakod mu boy udun datuwen duwan linubid an balituk nah duwan batun onyx an mitakap nah luput an mihableh pukol. ");
INSERT INTO ifk_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Mangapya kayu boh duwan natuligonggong an balituk ya ingkugut yu nah duwan dugun nan puun nan luput an mitakap hi pago. Mikugut datuweh ballin nan luput ta midapot da nah ephod. ");
INSERT INTO ifk_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Mangapya kayu boh duwan natuligonggong an balituk ya ingkugut yuh hinangngab nan luput an mihableh pukol nah tap-on nan balikit nan ephod. ");
INSERT INTO ifk_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Usalon yuy blue an linubid an mangitakod nadah natuligonggong an mikugut nah luput an mitakap hi pago ya nah ephod ta mihak-ot nan luput nah tap-on nan balikit nan ephod ta adi maunu. ");
INSERT INTO ifk_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Deket humgop hi Aaron nah Nasantun Kuwartu nah Tabernacle ya iusal nah diyen luput an mitakap hi pagon waday ngadan nadan imbabalen Israel an mipottok nah puhu na ta mipanomnom kayun tataguk ke ha-on ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ihudu yu nan Urim ya Tummim nah bulsan diyen luput an mitakap hi pago ta mihakmoh pottok di puhun Aaron ten ibulwati nah pangayanah kuwartuk. Athidi nimpen wadat nangamung ke Aaron dadiyen panginilaan hi pinhod kun aton yun tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Kumugut kayu boh bulwatin blue an miodda nah ephod. ");
INSERT INTO ifk_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ha-adan yuh uwang nat kihukluban di ulu ya kinugutan yuh luput di pingngit diyen uwang umat hi udum an bulwati ta adi mabik-i. ");
INSERT INTO ifk_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Mangapya kayu boh ing-ingon di bungan di pomegranates an usalon yuy blue, purple ya maka-ingit an tinulid ya intayun yu didah nunlinikkod hi lupit tuwen bulwati an mibanattan di kingking an balituk. ");
INSERT INTO ifk_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Intayun yu key ohan kingking on intun-ud yuy ohan pomegranate inggana malikkod nan udun nan bulwati. ");
INSERT INTO ifk_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ibulwatin Aaron hituweh hogpanah Nasantun Kuwartu nah Tabernacle an munhilbin ha-on an AP-APU. Ya datuwen i-itay an kingking ya munggangogangoh humgopana ya lumah-unanat adi mate. ");
INSERT INTO ifk_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Mangapya kayu boh medal an namahman balituk ta itudok yuh tuwe: ‘Niong-ong ke APU DIOS.’ ");
INSERT INTO ifk_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Gakodam hituwen medal hi blue an takod ya intakap muh hinangngab nan kapyaon yun mipngot ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Mipottok hituwen medal hi tuktuk nat paddungnay iagtu nay bahul ten waday kibahhawan nadan holag Israel mipanggep hi iappit da. Mahapul an iusal nat nangamung hituwen pongot ta ha-oy an AP-APU ya abulutok am-in di iappit nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Hay makaphod an luput di ipakugut yuh oddan di bulwatin Aaron. Athidi bon makaphod an luput di ipakugut yuh pongot na. Ya mumpakugut kah nipniphod an nabordaan an miawakoh gitang na. ");
INSERT INTO ifk_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Kumugut kayuh mioddan bulwatin damdaman nadan imbabalen Aaron, hay miawakoh gitang da ya hay pongot dat maphod di ang-ang da ya midayaw da ketuwen ngunu da. ");
INSERT INTO ifk_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ipabulwatim nah tulang mun hi Aaron hidiyen ipakugut mun bulwatina ya ipabulwatim damdama nadah imbabalena nadan ipakugut mun bulwati da. Ne dinuyagam di ulu dah lanan di oliba ta kitib-anan natuddu dan mumpadin munhilbi ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Kumugut kayu boh andukken mundallom an bulwati dan mipalpuh gitang da ingganah ulpu da. ");
INSERT INTO ifk_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Mahapul an iusal da Aaron ya nadan imbabalena datuwe nah hogpan da nah Tabernacle ya ten ume da nah altar hidi nah Nasantun Kuwartun mangat hi ngunu da. Ta deket athituy aton da ya adida mabahulan ta adida mate. Hituwen olden kun un-unudon Aaron ya nadan holag nan mahanhanot an mumpadi ya munnananong ta nangamung.” ");
INSERT INTO ifk_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kanan APU DIOS ke Moses di “Athituy atom hi pangiong-ongam ke Aaron ya nadan imbabalenan mumpadit munhilbi dan ha-on. Umala kah ka-ongal nan lakin baka ya duwan lakin kalneron maid di dipekto da, ");
INSERT INTO ifk_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ya mangapya kah tinapay an usalom di kapkaphodan an alina ya adim kammohan hi mumpalbag. Mangapya ka boh maingpin tinapay ya makayyam-oy udum an naha-adan hi mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Iha-ad mu datuweh hukup ta iappit mun ha-on an iunnud mu nah ka-ongal nan lakin baka ya duwan lakin kalnero nah hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Atom nan ine-en di mun-ong-ong ke Aaron ya nadan imbabalena nah hogpan nah Tabernacle ya ulaham didah danum. ");
INSERT INTO ifk_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ipausal mun Aaron nan mioddan bulwatina, nan mabordaan an mioddah ephod, nan ephod, nan luput an mitakap hi pago ya nan miawako. ");
INSERT INTO ifk_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ipapngot mu bon hiya nan pongot nan natakapan hi balituk an medal. ");
INSERT INTO ifk_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ya ha-adam di ulunah lanan di oliba ta kitib-anan natuddu hiyan mumpadi. ");
INSERT INTO ifk_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Nagibbu keh Aaron ya iong-ong mu damdama nadan imbabalenan ipabulwatim nadan oddan di bulwati da. ");
INSERT INTO ifk_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ya ipausal mun dida nadan naabol an miawakoh gitang da ya ipapngot mun dida nadan pongot da. Athituy atom an mangiong-ong ke Aaron ya nadan imbabalenan linalaki ta diday mumpadit nangamung. ");
INSERT INTO ifk_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ialim di ka-ongal nan lakin baka nah hinangngab nan Tabernacle ta ihakmon da Aaron ya nadan imbabalenay takle dah ulun diyen baka. ");
INSERT INTO ifk_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ne kinlong mu nah kad-ak nah hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ya umala kah dala nat itdok muy taklem ya hina-adam nadan kay hakgud nan altar ya iduyag mu nan udum an dala nah puun diyen altar. ");
INSERT INTO ifk_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kaanom am-in di tabanan nikuyaput nadah wadah putun nan baka takon nan ong-ongal an altena, nan duwan palina ya nan tabanat gobhom nah altar. ");
INSERT INTO ifk_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Hanan adol na, nan bolat na ya kinana ya iem nah e-elen nan boblet iappit mun gobhom gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","16","Ne alam di oha nadah lakin kalnero ta kolngom yaden ihakmon da Aaron ya nadan imbabalenay takle dah uluna. Ya tayaom di dala na ne inwaghik mu nah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tanogtogom hidiyen kalnero ya ulaham di putuna ya hukina, ya inhakmom nah kawad-an nan uluna ya nan udum an parten di adol na, ");
INSERT INTO ifk_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ya ginhob mu nah altar. Hay hamuy tuwen maghob an miappit ya pun-amlongak. ");
INSERT INTO ifk_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Alam bo nan mikadwan kalnero ya kalyom ke Aaron ya nadan imbabalenat ihakmo day takle dah ulunat ");
INSERT INTO ifk_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","kolngom. Tayaom di dalana ya indan-im hi wawwan an ingan Aaron ya nadan imbabalena. Ha-adam boh dalay wawwan an am-ama-an di takle da ya huki da. Ya inwaghik mu nan matdaan an dala nah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Umala ka boh dala nah altar ya kinammoham hi lanan di oliba ya winaghikam hi Aaron ya nadan imbabalena takon di bulwati dat miong-ong da ya nadan bulwati dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Alam boy taban nan lakin kalneron kolngom, takon nadan putuna, nan ong-ongal an altena, hay palina ya nadan taban nikuyaput, nan mataban iwit na, nan wawwan an ulpu na. Hituwen lakin kalneron kinlong mu ya miappit hi pumpadiyan Aaron ya nadan imbabalena. ");
INSERT INTO ifk_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ya umala ka nadah tinapay an niappit ke ha-on an niha-ad hi basket an ugge naha-adan hi mumpalbag. Alam di ohan tinapay an naha-adan hi mantekan di oliba, ohan ugge, ya ohan maingpin tinapay ya ");
INSERT INTO ifk_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","impad-on mu datuwen tinapay ke Aaron ya nadan linalakin imbabalenat itagge dan ipresentan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Alam ta gobhom takon nan kalnero nah altar ta umamlongak hi hamuy na. ");
INSERT INTO ifk_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Hanan pagon nan kinlong mun kalnero ya itaggem an ipresentam an iappit ke ha-on. Deket nagibbun in-appit mu ya inalam te hidiyey bingay mu. ");
INSERT INTO ifk_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Appilom nan pago ya ulpun nan kalneron maklong an miappit hi pumpadiyan Aaron ya nadan imbabalenan nipresentan ha-on ta idat mun dida. ");
INSERT INTO ifk_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ta hi udum hi algo ya deket mun-appit nadan holag Israel hi pakihayyupan weno pumpasalamatan dan ha-on an AP-APU ya midat ke didat nangamung datuwe. ");
INSERT INTO ifk_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Deket mateh Aaron ya mipaboltan nadan nangilinan an bulwati nah oha nadah imbabalenan piliyon yun mihannot ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ya hidiyen mihannot an natag-en padi ya ibulwatina datuwen bulwatih pitun algon kiong-ongana ya ahina inlappun munhilbi nah Tabernacle ya nah Nasantun Kuwartuk. ");
INSERT INTO ifk_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Hanan pago ya ulpun nan kalnero ya iha-ang mu nah nangilinan an lugar. ");
INSERT INTO ifk_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kanon Aaron ya nadan imbabalena dadiye takon nan tinapay an niha-ad nah basket nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Dida ya abun padiy damanan mangan kediyen niappit hi kakaanan di liwat da. Adi kanon di kumpulmin tagu dadiye te niong-ong dadiyen dotag. ");
INSERT INTO ifk_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ya deket waday tindaan da nah dotag weno tinapay hi kabigatana ya mahapul an gobhon. Maid di mabalin an mangan kediye te niong-ong. ");
INSERT INTO ifk_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Athidiy aton yun mangat nah ine-en di pumpadiyan da Aaron ya nadan imbabalena. Aton yuh tuweh pitun algo. ");
INSERT INTO ifk_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kabigabigat ya kolngon yuy ohan ka-ongal nan lakin baka ta miappit hi kakaanan di liwat. Ya mun-appit kayuh pangatan yu nah ine-en di punlini nah altar ya dinuyagan yu boh lanan di oliba ta mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pitun algoy pangatan yun diye. Nagibbu ke ya daydayuna mon pun-appitan hidiyen altar ta am-in di midatum hidi ya miong-ong ke APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Kanan APU DIOS ke Moses di “Hay iappit yu nah altar hi kabigabigat ya duwan hintoonan kalnero ");
INSERT INTO ifk_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","an ohah biggatna ya ohah mahmahdom. ");
INSERT INTO ifk_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Hanan iappit yuh biggatnan ohan kalnero ya unnudan yuh umeh ohan kilon alinan nakammohan hi ohan butilyan manteka. Umiappit kayu boh ohan butilyan mainum. ");
INSERT INTO ifk_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ya nan iappit yuh mahmahdom an ohan kalnero ya unnudan yu damdamah nun-ingngon kadakol an alina, mantekan di oliba ya mainum. Datuwen miappit ya maghob dat umamlong hi APU DIOS hi hamuy da. ");
INSERT INTO ifk_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mipalpud uwani ya mun-appit kayun tataguk hi kabigabigat, takon nadan holag yuh udum hi algo nah hogpan hi Tabernacle an kawad-ak ta makihummanganak ke dakayuh di. ");
INSERT INTO ifk_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Makidammuwak hi tataguk hidi nah Tabernacle te miong-ong hidiye ke ha-on te wadaak hidi. ");
INSERT INTO ifk_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Om, miong-ong ke ha-on nan Tabernacle, nan altar ya hi Aaron ya nadan imbabalena ta munhilbi dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Makiha-adak nadah holag Israel an tataguk ta ha-oy di Dios da. ");
INSERT INTO ifk_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ya inilaon dan ha-oy di AP-APU an Dios dan nangipakaan ke didad Egypt. Om, makih-adak ke dida te ha-oy tuwaliy AP-APU an Dios da.” ");
INSERT INTO ifk_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Kanan bon APU DIOS ke Moses di “Umala kah kaiw an akasia ta mangapya kah altar an pangighobam hi bangbanglun iappit mun ha-oy. ");
INSERT INTO ifk_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kuwadladuh tuwen hay kadukkena ya kabilog na ya himpulut walun pulgada, ya tulun piyey katag-ena. Kapyaom di midongdong an kay hakgud nah tap-on nadan opat an dugunan miohhay kapyana nah altar. ");
INSERT INTO ifk_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Takapam hituwen altar hi balituk, nan tap-ona, nadan nidongdong an kay hakgud, nan linikkod na ya titigil na. ");
INSERT INTO ifk_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Mangapya kah duwan natuligonggong an balituk ta ikapyam nah da-ul nan tigil nat kidudukan nan duwan pun-attang ta pangid-onan di mangiattang ketuwen pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ya mangapya kah akasian pun-attang an takapam hi balituk. ");
INSERT INTO ifk_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Iha-ad mu datuweh binnah-el nan kuwartun kiha-adan nan kahon an niha-adan nadan nitudokan di Tugun kun dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ya hi kabiggabiggatnah e pangipaptokan Aaron hanadah kingket odpona ya gobhona nan bangbanglu ketuwen altar. ");
INSERT INTO ifk_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Athidi bo nah hilong hi puntologana nadah kingke an gobhona bo nan bangbanglu. Mahapul an aton yuh tuwe ta nangamung takon nadan holag yuh udum hi algo. ");
INSERT INTO ifk_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Adim iappit ketuwen altar di adi mibilang an malinin bangbanglu weno kumpulmin maghob an miappit umat hi page weno mainum. ");
INSERT INTO ifk_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aton Aaron di ine-en di punlini ketuwen altar hi maminghan hi hintoon an ha-adana nadan opat an dugunan kay hakgud hi dalan nan aggayam an miappit gapuh liwat di tatagu. Mahapul an aton yuh tuwe ta nangamung. Te hituwen altar ya miong-ong ke ha-on an AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Deket bilangom nadan ibbam an holag Israel ya mahapul an waday oha on umidat hi pihhun bayad di adol na ke ha-on kediyen nabilangana ta maid di ligat an umalin dida kediyen pumbilangam. ");
INSERT INTO ifk_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Hay ibayad di ohan tagu ya mipuun nah maunud an olden mipanggep hi Tabernacle. Hidiyen pihhu ya iappit dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Makibilang nadan muntoon hi duway pulu weno nahawwal. ");
INSERT INTO ifk_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Hituwen bayad di adol yun idat yun ha-on ya mun-iingngo, kadangyan weno nawotwot. ");
INSERT INTO ifk_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Dawatom datuwen ibayad nadan ibbam an holag Israel ta usalom hituwen pihhun mangipaptok nah Tabernacle an kiha-adak. Hituwen ibayad da ya kay mibayad hi biyag da ya mangipanomnom ke ha-on ta ipaptok ku dida.” ");
INSERT INTO ifk_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Mangapya kah gombang an palanggana ya gombang an kipattukana. Iha-ad muh tuweh numbattanan nan Tabernacle ya nan altar. Ha-adam hi danum ");
INSERT INTO ifk_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","21","ta pun-ulahan da Aaron ya nadan imbabalenah takle da ya huki da ta ahida ume nah Tabernacle hi kad-ak ya ten eda munggohob hi miappit nah altar. Mahapul an un-unudon dah tuwe ta adida mate. Hituwen olden ya mahapul an munnananong an un-unudon nadan holag Israel ta nangamung.” ");
INSERT INTO ifk_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Umala kah kapkaphodan an pumpabanglu: Hay myrrh an umeh onom an kilo, hay tulun kilon cinnamon, hay tulun kilon una, ");
INSERT INTO ifk_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","hay onom ta godwan kilon cassia ya ohan galon nah lanan di oliba. ");
INSERT INTO ifk_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Pungkakammohom datuwe ta mangapya kah lanan usalon hi kumpulmin kanan APU DIOS an pangusalan. ");
INSERT INTO ifk_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Usalom hituwen pangiong-ongam nah Tabernacle, nan kahon APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","nan lamesaan ya nadan ngunut an wadah di, nan pangipattukan hi dilag, ya nadan ngunut an mausal hidi ya nan altar an punggohoban hi bangbanglu. ");
INSERT INTO ifk_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Athidi bo nah altar an pangighobam hi miappit, nadan mausal hidi nan palanggana ya nan kipattukana. ");
INSERT INTO ifk_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ha-adam hi lana datuwet miong-ong dan ha-on. Ya am-in nadan midatum ke datuwe ya miong-ong dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hituwey iduyag muh ulun da Aaron ya nadan imbabalenah pumpadiyan dat munhilbi dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kalyom hanadah ibbam an holag Israel an itultuluy dan mangapya ketuwen lana ta usalon yuh pundayawan yun ha-on ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Adi mabalin an em iduyag hi ulun di kumpulmin tagu ya adi mabalin an em un-unudon di templanat kumapya kat usalom hi pinhod mun pangiusalan. Te hituwe ya niong-ong hi pinhod kun kiusalana kinali adi nalgom di pangiusalam. ");
INSERT INTO ifk_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hanan tagun mangapyah athitun templo weno iduyag nah kumpulnan tagu takon di bokon padi ya adik mo ibilang an taguk.” ");
INSERT INTO ifk_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kanan APU DIOS ke Moses di “Umala ka nadah bangbanglu umat hi raisin, mollusk, galbanum ya namahman insenso an mun-iingngoy kadakol nat ");
INSERT INTO ifk_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","mangapya kah nabanglun insensoh umat nah pangapya dah bangbanglu. Udmam hi ahin ta mamahma ya adi nalgom di pangiusalon yu. ");
INSERT INTO ifk_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Gilingom di udum ta mapinu ya iha-ad mu nah hinangngab nan kahon kun niha-adan nadan Tugun kun nah Tabernacle an pakidammuwak ke he-a. Hituwen bangbanglu ya niong-ong ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Adi naala on eka kimmapya ta usalom hi pinhod mun pangiusalam. ");
INSERT INTO ifk_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hanan tagun mangapyah athitut usalonah pinhod nan pangiusalan ya adik mo ibilang an taguk.” ");
INSERT INTO ifk_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Pinilik di ohan holag Judah an hi Besalel an imbabalen Uri ya inap-apun Hur. ");
INSERT INTO ifk_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Winadak ke hiya nan Espirituk ot mawaday laing nan mangapyah nganneh diyen naal-alkusan. ");
INSERT INTO ifk_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Nalaing an mangapyah mungkaphod an ngunut an usalonay balituk, silber ya giniling an pun-alkus na ");
INSERT INTO ifk_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","takon nadan maalkusan hi nanginan batu. Nalaing bon mumpanday ya mumpaot hi kumpulmin maphod di ang-ang na. ");
INSERT INTO ifk_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Pinilik boh Oholiab an imbabalen Ahisamak an nahlag ke Dan an bumaddang ke hiya. Wadada boy udum hi pinilik ot wadaok ke diday ongal an kabaelan dan mangat am-in ke datuwen kinalik an pakapyam: ");
INSERT INTO ifk_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Hanan Tabernacle, nan Kahon kun niha-adan nadan Tugun ku, nan hukap na ya am-in nadan ngunut an wada nah Tabernacle ");
INSERT INTO ifk_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","umat hi lamesaan ya nadan ngunut hidi, nan balituk an kipattukan di kingke ya nadan mausal hidi, ");
INSERT INTO ifk_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","nan altar an pun-appitan yuh kolngon yu ya am-in nadan ngunut an mausal hidi, ya nan palangganan pun-ulahan ya nan kipattukana. ");
INSERT INTO ifk_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Dida boy mangugut nadah bulwatin di padin usalon da Aaron ya nadan imbabalenah pumpadiyan da. ");
INSERT INTO ifk_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ya diday mangapyah lana ya nan bangbanglun insenso nah Nasantun Kuwartu. Deket kapyaon da datuwe ya mahapul an paka-un-unudon da nan kinalik ke he-an pangapya yu.” ");
INSERT INTO ifk_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Kalyom hanadah ibbam an holag Israel ta aton da nan ine-en di Sabadun Tungo an adida mungngunu te hidiyey panginomnomnoman yu ta nangamung hi nakitobbalan yun ha-oy an AP-APU yu ot pumbalinon dakayun tataguk. ");
INSERT INTO ifk_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Om, maid di mungngunu kediyen algo te niong-ong ke ha-on. Deket waday mungngohen tuwen tugun ta mungngunu kediyen algo ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Te waday onom an algon pangatan yun am-in hi ngunu yu, mu nan mikapitun algon Sabadun tungo ya pun-iyatuwan yu. Ipidwak an kalyon: Gapu te hituwen algo ya niong-ong ke ha-on ya wada key kahing ta mungngunu kediyen algo ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Aton yun holag Israel hituwen ine-en di Sabadun Tungo ta panginomnomnoman yu ta nangamung nah nakitobbalak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Hituwey panginomnomnoman yun ha-on te lintuk di kabunyan ya lutah onom an algo ot mun-iyatuwak handih mikapitun algo.” ");
INSERT INTO ifk_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ginibbun Apu Dios di kinalinan Moses nah Bilid an Sinai ot idat nan hiya nan duwan batun nitudkan am-in datuwen Tugun, an hay taklena mismuy nangitudok. ");
INSERT INTO ifk_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Handih nabaybayag hi Moses nah bilid ya naamung nadan tatagu ot kanan dan Aaron di “Agam! Mangapya ka ot kayah dios takun mangipangpangulun ditaku, te hi ke Moses an nangipangulun ditakun tumayan ad Egypt ya ugge taku inilay naat ke hiya nah nangayana.” ");
INSERT INTO ifk_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ya kanan Aaron ke diday “Deket athina ya pun-iali yun ha-on nadan balituk an hihingat nadan inayan yu ya iimbabale yu.” ");
INSERT INTO ifk_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ot pungkaan nadan tataguy hihingat da ot idat dan Aaron. ");
INSERT INTO ifk_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Inayug Aaron dadiye ot mangapyah balituk an baka. Tinibon nadan tatagu ya kanan day “Ditakun holag Israel, hituwen dios di nangipangulun ditaku ot tumayan takud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Handih matibon Aaron an immamlong nadan tatagu ya nangapyah pun-appitan nah hinangngab nan balituk an baka ot kananan diday “Hi bigat ya mumpiyesta takut dayawon takuh APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Indanit nabigat ya nun-ihalaman nadan tatagun in-ali nadan aggayam an iappit dan maghob ya nadan aggayam an iappit dan pakihayyupan ke APU DIOS. Nunhahamul nadan tatagu ya nangnanginnum da ot manmannayo da ya loktat ya at-atton day oggan aton nadan adi mangulug ke APU DIOS ten mundaydayaw dah dios da. ");
INSERT INTO ifk_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Indani ya kanan APU DIOS ke Moses di “Gal-am ta mundayyu ka te inwalongak nadah tatagun impangulum an timmayan ad Egypt ot deyan at-atton day punliwatan. ");
INSERT INTO ifk_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kinahing dan am-in nadan tugun kun dida ot mangapya dah balituk an bakan dayawon da ot iappitan da. Kanan day hidiyey dios dan nangipangulun didan timmayan ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Namahig di ngohen datuwen tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Adim haniyan didat ma-idok dida gapuh boh-ol ku. Ta he-a ya abu Moses, di pangadduwok ta dumakkodakkol di holag mu.” ");
INSERT INTO ifk_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mu numpahpahmok hi Moses ke APU DIOS an kananay “Apu, tipe bo anhan ta namahig di bungot mu hantudah tatagum an inihwang mu ot pakaanom didad Egypt hi nangipatib-am hi ongal an kabaelam? ");
INSERT INTO ifk_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Atom ke bo nan kanam an ma-idom dida ya pangalin nadan iEgypt di hay gapunah nangipanguluwam ke dida ya ta patayom didat maid di matdaan ke dida. Itikod mu anhan an bumoh-ol ya adim anhan ma-idon dida. ");
INSERT INTO ifk_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nomnomom nan nakitobbalam handidah muttatyum an hi Abraham, hi Isaac ya hi Jacob. Hinamad mun kinalin dida handi an kanam di padakkolom di holag dat umat da nadah bittuwon hi kabunyan an adi mabilang. Nomnomom bon kanam ke diday datuwen holag day pangidatam nah boblen kanam an pumboblayan dat nangamung.” ");
INSERT INTO ifk_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kay anhan ya dingngol APU DIOS hidiye ot uggena mina-id nadan tataguna. ");
INSERT INTO ifk_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nagibbun nakihummangan hi Moses ke APU DIOS ot mundayyuh kad-an nadan ibbanan inodnana nadan duwan batun nitudok hi numbinah-el nadan Tugun. ");
INSERT INTO ifk_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kinapyan Apu Dios dadiyen batu ya hiyay nangitudok ke dadiyen Tugun. ");
INSERT INTO ifk_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Manatong da Moses ke Joshua ya dingngol Joshuay ngalan nadan tatagu ot kananan Moses di “Tipet kay da munggugubat nah nungkampuwan taku?” ");
INSERT INTO ifk_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kanan Moses di “Hay pangngol ku ya bokon ngalan di mangap-apput weno palak di mungkaapput, mu kay da mun-an-anla.” ");
INSERT INTO ifk_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Handih nih-up da Moses nah kampu da nah puun di bilid ya tinibona nan balituk an bakan kinapyan nadan tatagun itaytayyawan da. Bimmubbungot ot itongba na nadan duwan nadampilag an batun kikiwolona ot mapani-ang da. ");
INSERT INTO ifk_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ya inalanah diyen balituk an baka ot gobhona. Impumbalinan kay dap-ul ot ikammonah danum ot ipainum na nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kananan Aaron di “Nganney inat datuwen tatagun he-a ta em in-abulut an aton dah tuwen himpappangen liwat?” ");
INSERT INTO ifk_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kanan Aaron di “Adika bumoh-ol ke ha-on te inilam an hay gaga-ihoy pinhod dan abun aton. ");
INSERT INTO ifk_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kanan dan ha-oy di ‘Agam! Mangapya ka ot kayah dios takun mangipangpangulun ditaku, te hi ke Moses an nangipangulun ditakun tumayan ad Egypt ya ugge taku inilay naat ke hiya nah nangayana.’ ");
INSERT INTO ifk_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ot kalyok mon diday iali dan ha-on di balituk an hingat da ot pun-iwelek nah apuy ya naukat tun balituk an baka!” ");
INSERT INTO ifk_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ininnilan Moses an in-abulut Aaron hidiyen himpappangen pinhod nadan tatagun aton ta gapun diye ya katataw-an di buhul da dida ");
INSERT INTO ifk_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ot e tumaddog hi Moses nah hoob nan kampu ot itkuk nan kananay “Dakayun naminhod an mundayaw ke APU DIOS, maappil kayuh tu.” Ya ammuna nadan holag Libay an immeh kad-ana. ");
INSERT INTO ifk_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kananan diday “Kanan nan AP-APU an Dios takun holag Israel di alan yuy ispada yu ta pumpate yu datuwen ibbayun ipalpu yuh tu inggana dih bah-el na. Pumpate yu nadan tutulang yu, nadan gagayyum yu ya nadan hinag-on yu.” ");
INSERT INTO ifk_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Inun-unud dah tuwen kinalin Moses ot eda pumpate dida ya tulun libuy pinate da kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Indani ya kanan Moses ke dadiyen holag Libay di “Ad uwanin algo ya maappil kayu nadah udum an tatagu te numbalin kayun padin munhilbi ke APU DIOS te inun-unud yuy kinalinan aton yu ot pumpate yu takon di tulang yu ya imbabale yu, ot bendisyonan dakayun APU DIOS gapun diye.” ");
INSERT INTO ifk_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Handih nabigat ya kanan Moses nadah tataguy “Himpappangen punliwatan di inat yu. Mu tumikidak bo nah bilid an kad-an APU DIOS ta eyak makihummangan ke hiya ta kal-ina ot ya pakawanan dakayu.” ");
INSERT INTO ifk_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nibangngad boh Moses hi kad-an APU DIOS ot kananan hiyay “Ongal di nunliwatan datuwen tatagu te immala dah balituk ot mangapya dah kanan dan dios dan dayawon da. ");
INSERT INTO ifk_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mu ibagak anhan ke he-a ta kal-iwam di numbahulan da te deket adim ya kudukdul nay kaanom di ngadan ku nah nangitudokam hi ngadan di tatagum.” ");
INSERT INTO ifk_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mu kanan APU DIOS di “Adi mabalin, ammuna nadan nunliwat ke ha-on di kaanok di ngadan da nah nangitudokak. ");
INSERT INTO ifk_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Eka ot ya abu ta ipangpangulum didat ume kayu nah boblen kinalik handin pangayan yu ot wada nan anghel kun mangipaptok ke dakayu. Mu kastiguwok danaen tatagu gapuh liwat da.” ");
INSERT INTO ifk_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Indani tut-uwa ya impaalin APU DIOS di dogo ke datuwen tatagu gapu kediyen nunliwatan dan pinilit dah Aaron an mangapyah balituk an bakan dayawon da. ");
INSERT INTO ifk_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kanan bon APU DIOS ke Moses di “Tumayan kayuh tu hantudah tatagun impangulum an timmayan ad Egypt ta ume kayu nah boblen insapatak ke da Abraham, hi Isaac ya hi Jacob an ipaboltan kuh holag da. ");
INSERT INTO ifk_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Umitud-akak hi anghel an mangipangpangulun dakayu ta dog-alona nadan Kanaanite, Amorite, Hittite, Perisite, Hibite ya nadan Jebusite an numbobleh di ta dakayuy mihannot. ");
INSERT INTO ifk_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Wadan am-in di mahapul yu kediyen boblen mahawwahawwal di gatas ya iyyukan. Mu adiyak maki-en dakayu te makangohhe kayu. Kal-ina ya paboh-olonak ta pumpate dakayu bo nah dalan.” ");
INSERT INTO ifk_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Handih dingngol nadan tataguh tuwen kinalin APU DIOS ya u-umyungan da ya adida pinhod an usalon nadan gamgam da. ");
INSERT INTO ifk_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Te kanan APU DIOS ke Moses di “Kalyom hanadah tataguh tuwe: ‘Mangohe kayu! Ta hidiye nan takon nin di hingkatang di paki-ayak ke dakayu ya dadagon dakayu. Kaanon yu nadan in-usal yun gamgam yu, umat hi hingat ya balituk an banggol, ta nomnomok hin nganney atok ke dakayu.’” ");
INSERT INTO ifk_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ot mipalpu handih timmayan da kediyen Bilid an Sinai ya uggeda mo nun-usal nadah gamgam da. ");
INSERT INTO ifk_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Deke on ingkapyan Moses nan Tabernacle hi e-elen nan pungkampuwan dat deket waday naminhod an makihummangan ke APU DIOS ya umeh di. Hituwen Tabernacle nan kiha-adan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Deket immeh Moses hidi nah Tabernacle on tumaddog nadan tataguh panton di kampu dat ang-ang-angon dah Moses inggana humgop. ");
INSERT INTO ifk_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mungkohop nan kay tukud an kulabut nah panton nan Tabernacle ten hinumgop hi Moses an makihummangan ke APU DIOS an wadah kulabut. ");
INSERT INTO ifk_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Deket tinibon nadan tataguh tuwen kulabut an nungkohop nah panton nan Tabernacle ya tumaddog dah panton di kampu dat munyuung da. ");
INSERT INTO ifk_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Makihinnangngab hi APU DIOS an makihummanganan ke Moses umat hi punhummanganan di duwan tagun munggayyum. Nagibbu da ken munhummangan on nibangngad hi Moses nah nungkampuwan da, mu nan kat-agun imbabalen Nun an hi Joshua an bumbummaddang ke hiya nah Tabernacle ya adi tumayan hidi. ");
INSERT INTO ifk_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kanan Moses ke APU DIOS di “Kanalyom ke ha-on an ipanguluk datuwen tatagut ume kami nah boblen kanam an pangayan mi, mu uggem kinali hin dahdi day maki-en ha-on. Kinalim bon impakainnilaak ke he-a ya maka-am-amlong kah at-attok. ");
INSERT INTO ifk_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Deket makulug datuwen kinalim ya ipainilam boh mon ha-on am-in di planum ta maawatan daka ya ta atok di pinhod mu. Ya nomnomom an pinilim datuwen tatagum.” ");
INSERT INTO ifk_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ya kanan APU DIOS ke Moses di “Ha-oy mismuy maki-en he-a ta mun-iyatu ka ya ta maphod am-in di maat ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kanan Moses di “Man-uke ya deket adika maki-en dakami ya kudukdul nay mihtu kami, adi kami tumayan hitu. ");
INSERT INTO ifk_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nganney innun di udum an tatagun manginilan pinpinhod mu datuwen tatagum ya pinpinhodak ke he-a hin adika maki-en dakami? Te deket maki-e kan dakami ya hidiyey kitib-anan hinnatkon kami nadah udum an tatagu tuh luta.” ");
INSERT INTO ifk_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ya kanan APU DIOS ke Moses di “Tobalok hinaen ibagam te maka-am-amlongak nah at-attom ya maphod di pakihayyupam ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Indani ya wada pay di ohan imbagan Moses ke APU DIOS. Kananay “Daan mo anhan ta ipatibom ke ha-on di dayaw mu?” ");
INSERT INTO ifk_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ya himmumang hi APU DIOS an kananay “Ipatibok ke he-ay kaphod ku ya ipainilak ke he-a an ha-oy di AP-APU. Ipatibok boy ulek ya homok ku nah tagun pinhod ku. ");
INSERT INTO ifk_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mu adi mabalin an ang-angom di angak te mate day mangang-ang hi angak. ");
INSERT INTO ifk_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tumaddog ka tuh batun pinaldang ku ");
INSERT INTO ifk_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ta iha-ad daka ni-an tuh dohak di batu ne haniyan dakah taklek inggana mala-uwak, ");
INSERT INTO ifk_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ya ahik kinaan di taklek ta tibom di odog ku, mu adim tibon di angak.” ");
INSERT INTO ifk_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kanan APU DIOS ke Moses di “Pumahok kah duwan nadampilag an batun umat dih namangulu ta ipidwak an itudok nadan intudok ku nah namangulun batun pina-im. ");
INSERT INTO ifk_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ne hi bigat hi biggatna ya tumikid ka bo tuh Bilid an Sinai ta mundammu ta nah tuktuk na. ");
INSERT INTO ifk_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Maid di maki-alin he-a ya maid di e mundallanan nah puun di bilid. Takon di kalnero ya baka ya maid umen e mangan hidi.” ");
INSERT INTO ifk_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Inun-unud Moses ot pumahok hi duwan nadampilag an batu ot humalaman an timmikid nah tuktuk nan Bilid an Sinai an inal-alana dadiyen batu. ");
INSERT INTO ifk_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Indani ya dimma-ul on kulabut an wadah dih APU DIOS ot kananan hiyay hay ngadana ya “nan AP-APU” ya dehdih Moses an timmaddog hi kad-ana. ");
INSERT INTO ifk_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nala-uh APU DIOS hi hinangngab Moses ot kananan hiyay “Ha-oy di AP-APU an makaulle ya huhhummok an Dios. Adiyak kabinnungot ya adi malumman di pamhod ku ya adik ibahhon aton di kinalik. ");
INSERT INTO ifk_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Punnanongok di pamhod kuh kalibulibun munhahaynod an holag ya pakawanak am-in di liwat da, takon nadan mungngohen ha-on, mu adik ibahhon mangastiguh nunliwat nadan imbabale da, inap-apu da ya nadan imbabalen di inap-apu da.” ");
INSERT INTO ifk_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ya nunlukbub hi Moses nah luta ot dayawonah APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ot kananan Apu Dios di “Apu, deket makulug an maka-am-amlong kan ha-on ya maki-e ka anhan ke dakami. Ya takon di makangohhe datuwen tatagu ya kal-iwam anhan di gaga-ihon inat dat abuluton dakamin tatagum.” ");
INSERT INTO ifk_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hinumang APU DIOS hi Moses ot kananay “Takombo. Makitobbalanak mod uwani ke dakayun holag Israel. Ahiyu tibon datuwen atok hi kiphodan yun umipamodwong an maid di ena naatan hi udum an boble tuh luta. Ahi tibon am-in di tataguh nunlinikkod datuwen atok an AP-APU yu. ");
INSERT INTO ifk_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mahapul an un-unudon yun holag Israel nadan tugun kun idat kun he-ad uwani. Ya kalyok ke he-a an hantuh dandanin dumatong kayu nah boblen kinalik an pangayan yu ya dog-alok nadan numbobleh din Amorite, Kanaanite, Hittite, Perisite, Hibite ya Jebusite. ");
INSERT INTO ifk_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Tibon yu ta adi kayu makihayyup nadah numbobleh pangayan yu te mumbalin dan kay bitun kaknaan yu. ");
INSERT INTO ifk_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pumpa-i yu ot ya abu nadan pun-appitan da, takon nadan batun niong-ong hi dios da ya nadan tukud an panginomnomnoman da nah babain dios an hi Asherah. ");
INSERT INTO ifk_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Adiyu dayawon di udum an dios te ha-oy an AP-APU ya adik pinhod an waday udum an dayawon yun dios hin bokon ha-on ya abu. ");
INSERT INTO ifk_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Adi kayu nimpe makihayyup nadah tatagun numboble nadah pangayan yu. Mialig dadiye nadah pabayad day adol da ya munliwat da te mun-appit da nadah adi makulug an dios. Deket makihayyup kayun dida ya awison dakayun mundayaw nadah dios da, ya loktat ya naawis kayu. ");
INSERT INTO ifk_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ya loktat bo ya nun-iahawan di imbabale yun linalakiy binabai da ta diday humlun hi pangiwalongan dan ha-on ta hay udum an dios di dayawon da. ");
INSERT INTO ifk_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Adi mabalin an ekayu mangapyah dios yun dayawon yu. ");
INSERT INTO ifk_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Mahapul an itultuluy yun aton nan pitun algon Piyestan di Tinapay an ugge naha-adan hi mumpalbag nah mamangulun bulan hi katootoon te ketuwen bulan di timmayanan yud Egypt. ");
INSERT INTO ifk_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Am-in di namangulun lalakin impan di aaggayam yu umat hi baka ya kalnero ya bagik. ");
INSERT INTO ifk_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mabalin bon ihannot yuy impan di kalnero nah namangulun impan di kabayu ta hidiyey miappit, mu deket adiyu pinhod an hannotan ya gi-uwon yuy bagang diyen kabayu. Hanada ke bon panguluwan an linalakin imbabale yu ya mahapul an gattangon yu ta mibangngad dan dakayu. Ya mahapul an am-in kayu ya mun-appit ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Mahapul an onom an algo ya ammunay pungngunuwan yuh ohan linggu. Adi kayu mungngunu nah mikapitun algo takon di ahigaud weno ahiani ta mun-iyatu kayu. ");
INSERT INTO ifk_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Mahapul bon aton yu nan Piyestan di Ani nah kagibbuwan di ahiani. Ya aton yu nan Piyestan di Kampu nah ahi polagan di bungan di intanom yu. ");
INSERT INTO ifk_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Hi katootoon ya mahapul an mumpitlu dan umalin am-in di linalakin holag Israel an mumpresentan ha-on an AP-APU an Dios di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Deket un-unudon yuh naen mumpitlu kayun umalih kad-ak ya maid di mangubat ke dakayu ya maid di mamloh boble yu. Dog-alok bo nadan numboble nadah boblen pangayan yu ta umambilog di boble yu. ");
INSERT INTO ifk_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Adiyu iappit di tinapay an nakammohan hi mumpalbag nah pun-appitan yuh aggayam. Deket mun-appit kayun ha-on hi impan di kalnero nah Piyestan di Nala-uwan di Anghel Apu Dios ya mahapul an maid di tod-an yuh dotag kediyen hilong. ");
INSERT INTO ifk_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ya mahapul an ie yuh balek an AP-APU an Dios yuy kapkaphodan hanadah mamangulun bungan di intanom yu ta miappit ke ha-on. Ya adiyu iha-ang di impan di kalnero weno gulding nah gatas inana.” ");
INSERT INTO ifk_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kanan bon APU DIOS ke Moses di “Itudok mun am-in danaen kinalik te danaey pangipuunak hi pakitobbalak ke he-a ya nadan ibbam an holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Niha-ad hi Moses nah Bilid an Sinai hi nap-at an algo ya hilong an ibba nah APU DIOS. Kediyen niha-adanah di ya ug-ugge nangan ya ug-ugge imminum. Kediyen tiempoy nangitudokana nah duwan nadampilag an batu nadah himpulun Tugun APU DIOS an datuwey nipuunan nan nakitobbalana. ");
INSERT INTO ifk_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Handih dimmayyuh Moses nah Bilid an Sinai an inodnana nadan nadampilag an batun nitudkan nan Himpulun Tugun APU DIOS ya humiliy angana te nakihumhummangan ke APU DIOS, mu uggena inila. ");
INSERT INTO ifk_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tinibon da Aaron ya nadan tataguh diyen humilin angan Moses ya tumakut dan mih-up ke hiya. ");
INSERT INTO ifk_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mu inayagan Moses dida ya nadan aap-apu ta munhuhummangan da. ");
INSERT INTO ifk_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Immali da ot kalyon Moses ke didan am-in nadan Tugun an indat APU DIOS ke hiya nah Bilid an Sinai. ");
INSERT INTO ifk_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Handih nagibbun kimmalih Moses ya nunhukyung ot mahaniyan di angana. ");
INSERT INTO ifk_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mu deket hinumgop nah Tabernacle an e makihummangan ke APU DIOS on kinaana nan inhukyung na. Limmah-un ke ta kalyona nadah tataguy intugun APU DIOS ke dida ");
INSERT INTO ifk_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","on tinibon nadan tatagu nan humilin angana. Deke bo on nunhukyung inggana madatngan nan ena pakihummanganan ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Inamung bon Moses am-in nadan ibbanan holag Israel ot kalyonan didah tuwe: “Mahapul an un-unudon yu datuwen intugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Hi hinlingguwan ya onom an algoy pungngunuwan yu ya nun-iyatu kayu nah mikapitun algon Sabadun Tungo te hidiyen algoy niong-ong ke APU DIOS. Hanadan adi mangun-unud ta mungngunu da kediyen algo ya mate da. ");
INSERT INTO ifk_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Adi bo miabulut an ekayu mun-apuy hi nunhituwan yu.” ");
INSERT INTO ifk_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kanan Moses nadah tataguy. “Hituwey kanan APU DIOS: Mun-appit kayun ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Deket mun-appit kayu ya datuwey mabalin an iappit yu: Hay balituk, silber ya giniling, ");
INSERT INTO ifk_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","hay tinulid an blue, purple ya maka-ingit, hay makaphod an luput ya hay udum an luput an nakapyah dutdut di gulding, ");
INSERT INTO ifk_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","hay lalat di lakin kalneron numbalin hi maingit, hay lalat di matagun wadah baybay, hay kaiw di akasia, ");
INSERT INTO ifk_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","hay lanan di oliban miha-ad hi kingke, nadan makapyah lanan miduyag hi ulu, hay bangbanglun insenso, ");
INSERT INTO ifk_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","hay onyx ya nadan udum an nungkanginan batun mitakap hi ephod nan padi ya nah luput an mitakap hi pagona. ");
INSERT INTO ifk_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Dakayu ken nalaing an mangiat hi ngannen ngunu ya umali kayu ta aton yu datuwen ipangunun APU DIOS: ");
INSERT INTO ifk_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","nan Tabernacle, nan tuldan mihophop, nadan mikurtina, nadan pun-ipit ke datuwen kurtina, nadan kalkalimangngana ya nadan miballabag, nadan tukud ya nadan nipataddogan datuwen tukud, ");
INSERT INTO ifk_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","nan kahon APU DIOS, nadan pun-attang, nan hukap na, nan kurtinah bohongnan mangodwah kuwartun APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","nan lamesaan, nadan pun-attang ya am-in nan mausal nah lamesaan, nan tinapay an mihaad nah kuwartun APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nan kipattukan di kingke ya am-in nadan mausal kediye, nadan kingken mihaad hidi ya nan lanan miha-ad ke datuwen kingke, ");
INSERT INTO ifk_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","nan pun-appitan an pangighoban hi bangbanglun miappit, nadan pun-attang, nan lanan miduyag hi ulu, nan bangbanglun insenso, nan kurtinah hogpan nah Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","nan altar an pangighoban hi miappit an aggayam, nan nalaggan giniling an pangihakmowan nah maghob an aggayam, nadan pun-attang, nadan ngunut an mausal kediyen pun-appitan, nan ongal an palangganan pun-ulahan, nan kipattukana, ");
INSERT INTO ifk_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","nadan mikurtinah nunlinikkod nan Tabernacle, nadan tukud, nadan nipataddogan datuwen tukud, nan kurtinah hogpan nah dolan nan Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","nadan paghok an pangigakodan hi gakod nan Tabernacle, nan dolana, nadan gakod, ");
INSERT INTO ifk_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nadan makaphod an bulwatin di padin iusal nah pangatanah ngununa nah kuwartun APU DIOS ya nadan nangilinan an bulwatin Aaron ya nadan imbabalena.” ");
INSERT INTO ifk_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Immanamut am-in nadan tataguh kampu dan tinaynan dah Moses ot eda idadaan di iappit da. ");
INSERT INTO ifk_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ot am-in nadan naminhod an mun-appit ya in-ali day iappit dan APU DIOS an mikapya nah Tabernacle ya nadan ngunut hidi takon di hay ibulwatin nadan padi. ");
INSERT INTO ifk_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ya nadan linalaki ya binabain naminhod an umialih iappit da ya in-ali day mungkakaphod an iappit dan umat hi balituk an hingat, singsing ya banggol da. Am-in an klasen di balituk an odon da ya in-appit dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","In-alin di udum di blue, purple ya maka-ingit an luput, hay makaphod an luput an nakapyah linen, dutdut di gulding, hay lalat di lakin kalneron nitam-ol hi maingit ya hay maphod an lalat. ");
INSERT INTO ifk_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Hay udum ya in-ali day giniling weno silber an iappit dan APU DIOS. In-alin damdaman di udum di kaiw an akasia. ");
INSERT INTO ifk_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nun-ialin damdaman nadan binabain nalaing an mumpudun di makaphod an tinulid an blue, purple ya maka-ingit ya makaphod an luput. ");
INSERT INTO ifk_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ya nadan binabain nalaing an mun-abol ya immiali dah inabol dan dutdut di gulding. ");
INSERT INTO ifk_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Hanadan aap-apun di holag Israel ya in-ali day onyx ya nadan udum an nanginan batun mitakap nah ephod ya nan luput an mitakap hi pagon di padi. ");
INSERT INTO ifk_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","In-ali da pay di pumpabangluh makan, lanan di oliban miha-ad nadah kingke, lanan miduyag hi ulu ya bangbanglun insenso. ");
INSERT INTO ifk_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Am-in nadan holag Israel, binabai ya linalakin naminhod an mun-appit ke APU DIOS ya in-ali day kahapulan kediyen ipangununan didan in-oldenan Moses. ");
INSERT INTO ifk_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kanan Moses nadah tataguy “Hi APU DIOS ya pinili nan midatan di ohan holag Judah an hi Besalel an imbabalen Uri ya inap-apun Hur ");
INSERT INTO ifk_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","hi laing an mangapyah nganneh diye, ");
INSERT INTO ifk_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","umat hi mumplanun mun-al-alkus ya mangapyah ngunut an usalonay balituk, silber weno giniling. ");
INSERT INTO ifk_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Nalaing bon mumpanday ya mumpaot hi batu ya kaiw ya nalaing an mangapyah kumpulmin maphod di ang-ang na. ");
INSERT INTO ifk_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hay pinilin APU DIOS an pun-ibban Besalel ya hi Oholiab an imbabalen Ahisamak an nahlag ke Dan. Indatan APU DIOS didah kabaelan dan mangituttuduh inila dah ibbada. ");
INSERT INTO ifk_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ya indatan APU DIOS didah laing dan mangapyah mungkakaphod an banggol, hingat, singsing, hay nunhihinnatkon an pangugut hi bulwati, hay pun-abol, hay pumbordah blue, purple ya maka-ingit hi makaphod an luput. Indatana bo didah laing dan mangiplanuh pangapya dan dadiyet mapmaphod di ang-ang na. ");
INSERT INTO ifk_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kinali hi Besalel, hi Oholiab ya nadan udum an indatan APU DIOS hi laing di mangikapya nah Tabernacle mipuun hi olden nan AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Impaayag Moses da Besalel ke Oholiab ot kalyonan ilappu dan mungngunun ibbada nadan udum an indatan APU DIOS hi laing an mangat nah ipangununa. ");
INSERT INTO ifk_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Indat Moses ke dida nadan in-alin nadan tatagun usalon dan mangapyan nah Tabernacle. Ya kabiggabiggatna ya pun-ialin nadan tataguy udum an idat da. ");
INSERT INTO ifk_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Loktat ya imme datuwen mungngunu ");
INSERT INTO ifk_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ke Moses ot kanan dan hiyay. “Nahawwal bo kaya nadan mausal nah ipakapyan APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ot mangapyah Moses hi olden an impaena nadah tatagu. Kanana nah oldenay “Maid moy umialih iappit nan mikapya nah Tabernacle te nakahhawwal moy indat yu.” Ot itikod mon nadan tatagun mangieh iappit dan mikapya nah Tabernacle ");
INSERT INTO ifk_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","te nahawwal bo kayay in-ali dan mausal nah ipangunun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Nangapya nadan nalaing an mun-abol hi himpulun kurtinan inusal day makaphod an tinayyum ot bordaan di ohan didah blue, purple ya maka-ingit an ing-ingon di anghel. ");
INSERT INTO ifk_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Am-in datuwen kurtina ya nun-iingngo dan umeh nap-at ta duwan piyey kadukke da ya onom an piyey kabilog da. ");
INSERT INTO ifk_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Impundada-it day lima ke datuwen kurtina ta miohha da. Athidi boy inat da nah liman kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Tinuligonggong day linubid an blue ot ikugut da datuwe nadah pingngit nadan duwan namingngit an kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ot ikapya day hinnanaliman natuligonggong nah pingngit dadiyen duwan kurtinan numpopottokon da dida. ");
INSERT INTO ifk_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Nangapya da boh naliman balituk an ipit ta pangipit dah pingngit nan duwan nundada-it an kurtina ta miohha nan dingding nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Immala dah dutdut di gulding ot kapyaon dah himpulut ohan kurtinan pun-odda da nadah luput an kurtinan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Nun-iingngohon da dadiyen kurtinan inodda dan hay kadukken di oha ya nap-at ta liman piye ya onom an piyey kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Impundada-it day lima ke datuwen kurtina ot miohha da. Athidi boy inat da nah onom an kurtinan nundada-iton da dida. ");
INSERT INTO ifk_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ingkapya day hinnanaliman natuligonggong nadah nundammuwan dadiyen lima ya onom an kurtinan nundada-it. ");
INSERT INTO ifk_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ya nangapya dah naliman giniling an ipit ot pangipit dah nundammuwan datuwen kurtina ot miohha da. ");
INSERT INTO ifk_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nangapya da pay hi duwan tuldan lalat di lakin kalnero ya lalat di gulding ta miodda. Athidiy inat dan nangatop nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ingkapya da boy akasian kaiw nah kalkalimangngan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Hay katag-en nadan nikapyan frames ya himpulut liman piye ya hay kabilog da ya duwampulut pitun pulgada. ");
INSERT INTO ifk_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Hina-adan dan am-in datuwen frames hi nun-ingngon hindudwan nidongdong an kaiw ot munhuhu-up da. ");
INSERT INTO ifk_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","26","Impataddog day hindudwampulun datuwen frames hi nangappit hi south ya hi north nan Tabernacle. Ya ingkapya day nawalun silber an pangipab-unan ke datuwen frames an hindudway nikapyah puun di oha. ");
INSERT INTO ifk_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Hanan awidan nan Tabernacle an nangappit hi kalin-oban di algo ya impataddog day onom an frames na ");
INSERT INTO ifk_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ya impataddog da boy hin-oh-an hanadah duwan pikdol na. ");
INSERT INTO ifk_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Datuwen duwan frames an nikapyah dugu ya nidokkop da mipalpuh puuna inggana tap-onan nihuklub di natuligonggong ta niohha da. Athidiy inat da nadah duwan dugu. ");
INSERT INTO ifk_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kinali, walun am-in di frames an ingkapya da kediyen indoggan nan Tabernacle ya inha-ad da boy himpulut onom an silber an nangipab-unan da ke dadiyen frames ta hindudwah ohan frame. ");
INSERT INTO ifk_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Nangapya dah himpulut liman kaiw an akasian miballabag nadah frames nan Tabernacle ot ikapya day hinlilmah nangappit hi north, hi south ya hi awidan an nangappit hi kalin-oban di algo. ");
INSERT INTO ifk_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Hana ken nigawwan niballabag nah gawwan nadan nipataddog an frame ya nikapyah ohan pangngelna ot munlikkod nah ha-ob na. ");
INSERT INTO ifk_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Inamo dah balituk datuwen frames an nipataddog ya nadan niballabag an kaiw ot mangapya da boh natuligonggong an balituk an mangdon hanadah niballabag an kaiw. ");
INSERT INTO ifk_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Hanan kurtinah bohongnan nan Tabernacle ya nakapyah makaphod an luput an blue, purple ya maka-ingit an tinulid ya niborday ing-ingon di anghel. ");
INSERT INTO ifk_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ingkapyaan dah tuwen kurtinah opat an akasian tukud na an naamoh balituk ya opat an silber an pangipataddogan ke dadiyen tukud ya opat bon kawit an balituk an pangihablayan nah kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nangapya da boh ohan kurtinah hogpan nah Tabernacle. Hay kinapya da ya makaphod an luput an blue, purple ya maka-ingit an inip-iphod dan binordaan. ");
INSERT INTO ifk_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ingkapyaan dah tuwen kurtinah balituk an kawit na ya liman tukud an naamoh balituk di tap-o da ya al-alkus dan nipab-un dah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Nangapyah Besalel hi Kahon APU DIOS an inusal nay kaiw di akasia. Nap-at ta liman pulgaday kadukkena, duwampulut pitun pulgaday kabilog na ya duwampulut pitun pulgaday katag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Tinakapanah diyen Kahon hi namahman balituk, takon nan dallomna ya tinakapana boh balituk di nunlinikkod an nilibod ketuwen Kahon. ");
INSERT INTO ifk_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kinapyanah opat an natuligonggong an balituk hidiyen kahon an hindudwah numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ya nangapyah pun-attang hi kaiw an akasia an tinakapana boh balituk ");
INSERT INTO ifk_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ot iduduk na ke dadiyen natuligonggong hi numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hay hukap diyen Kahon ya nakapyah namahman balituk. Nap-at ta liman pulgaday kadukkena ya duwampulut pitun pulgaday kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Namahma bon balituk di kinapya na nah duwan ing-ingon di anghel. ");
INSERT INTO ifk_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Inha-ad na didah numbinongwa nah udun nan hukap nan kahon. Hay inat nan nangikapya ya niohhay kapyana nah hukap. ");
INSERT INTO ifk_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nunhinnangngab dadiyen anghel an nabokyag di payak dan kinaluban day hukap diyen kahon. ");
INSERT INTO ifk_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nagibbuh diye ot mangapya boh lamesaan hi kaiw an akasia an tulun piyey kadukkena, ohat kagodwan piyey kabilog na ya nahawwal an duwan piyey katag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Linibodanah namahman balituk di nunlinikkod diyen lamesaan, ");
INSERT INTO ifk_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ya nan nida-it kediyen pingngit di lamesaan an kaiw an tulun pulgaday kabilog na ya linibodana boh balituk nan tigil na. ");
INSERT INTO ifk_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Inha-ad nay opat an natuligonggong an balituk nadah hukin nan lamesaan ya ");
INSERT INTO ifk_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","nah da-ul di pingngit na. Dadiyen opat an natuligonggong di kidudukan nan kaiw an pun-attang. ");
INSERT INTO ifk_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Dadiyen pun-attang ya nakapyah akasia ot amohonah balituk. ");
INSERT INTO ifk_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hay nihaynod an kinapya na ya nadan miha-ad nah lamesaan an duyu, basu, buwod ya malukung an pangiduyagan hi mainum an miappit. Namahman balituk di kinapya nan datuwe. ");
INSERT INTO ifk_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nangapya boh Besalel nah pangipattukan hi dilag an inusal nay namahman balituk. Pinanday nay puuna ya palat na. Niohhay kapkapya da nadah basun kiha-adan nadan dilag ya nadan palawer an al-alkus na. ");
INSERT INTO ifk_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Hidiyen pangipattukan hi dilag ya onom di hapang nan hintutluh numbinah-el. ");
INSERT INTO ifk_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Nip-ong ke dadiyen onom an hapang di basun kay habung di almond di pormana. ");
INSERT INTO ifk_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hanan adol nan pangipattukan hi dilag ya naalkusan hi opat an kay damdama habung di almond di pormana, ");
INSERT INTO ifk_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ya nip-ong di hin-oh-an habung an ugge nabokyag an nikapya nah da-ul di nundammuwan nadan hindudwan hapang nan pangipattukan hi dilag. ");
INSERT INTO ifk_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Datuwen habung an ugge nabokyag ya nadan hapang ya niohhan nakapya nah kipattukan di dilag. Namahman balituk di nakapyan am-in ke datuwe. ");
INSERT INTO ifk_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Namahman balituk damdamay nakapya nadah ipit ya ambilog an duyun pangiha-adan hi bala. ");
INSERT INTO ifk_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hay ingkapyana nah pangipataddogan kediyen dilag ya am-in nadan partena ya umeh nahawwal hi tulun pulut liman kilon balituk. ");
INSERT INTO ifk_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hana ke bon altar an pangighoban hi insenso ya nakapyah kaiw an akasia. Kuwadladuy pormanan himpulut walun pulgaday kabilog na ya himpulu bot walun pulgaday kadukkena ya tulun piyey katag-ena. Hanadan opat an dugunan nidongdong an kay hakgud ya niohhay kapyana nah altar an ugge nida-it. ");
INSERT INTO ifk_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Natakapan di tap-on diyen altar hi balituk, takon nadan dingding na ya nadan nidongdong an kay hakgud. Nilibod boy balituk hi nunlinikkod diyen altar. ");
INSERT INTO ifk_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ingkapya nay hindudwan natuligonggong an balituk hi numbinah-el diyen altar nah da-ul nan pingngit nat kidudukan nadan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Dadiyen pun-attang ya nakapyah akasia ya naamoh balituk. ");
INSERT INTO ifk_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nangapya boh lanan niong-ong an punlanah padi ya namahman insenson bangbanglu umat hi pangapyan di nalaing an mangapyah insenso. ");
INSERT INTO ifk_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Nangapya bo da Besalel ya nadan ibba nah altar an pun-appitan hi maghob an inusal day akasian kaiw. Hidiyen altar ya kuwadladun pitut kagodwan piyey kadukkena ya kabilog na, ya opat ta kagodwan piyey katag-ena. ");
INSERT INTO ifk_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ingkapya da boy kay hakgud nadah tap-on nan opat an dugunan niohhay kapyana nah altar. Nagibbun kinapya da ot amhon dah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nangapya da bo nadah mahapul hi pun-appitan umat hi baldin pangiamungan hi dap-ul, hay pala, hay palanggana, hay tobong di dotag an miappit ya hay palhun pangaan dah balan di nun-apuyan da. Am-in datuwe ya nakapyah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Nangapya dah giniling an nalagga ot iha-ad dah dallom nan altar an nihak-ot nah gawwana. ");
INSERT INTO ifk_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ingkapya da boy opat an natuligonggong nah opat an dugun diyen altar an kidudukan nadan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Nangapya dah akasian kaiw an pun-attang ot amhon dah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Induduk da dadiyen pun-attang nadah nakapyan natuligonggong an nikapya nah duwan pinigging nan altar ta pangid-onan nadan mangiattang. Nakapyah tabla nan altar, mu ugge nadulungan. ");
INSERT INTO ifk_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kinapya da nan giniling an palangganan pun-ulahan ya nan giniling an nipattukanan inusal da nadan pundiggalan an indat nadan binabain munhilbi nah hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kinapya da nan dolan nan Tabernacle ot kurtinaan dah makaphod an luput. Hanah nangappit hi south ya hinggatut ta naliman piyey kadukken di nikurtina. ");
INSERT INTO ifk_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Duwampulun tukud an giniling an nipab-un hi duwampulun pangipab-unan an giniling di nangdon nah kurtina. Silber di nakapyah kawit da ya punhablayan. ");
INSERT INTO ifk_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Athidi bo nah ha-ob nah kannawan hi nangappit hi north an hinggatut ta naliman piyey kadukken nan kurtinan ingkapya dan inodnan di duwampulun giniling an tukud an nipataddog hi giniling ya silber an kawit ya punhablayan. ");
INSERT INTO ifk_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Hanah awidan an nangappit hi kalin-oban di algo ya napitut liman piyey kadukken nan kurtinan nikapyan inodnan di himpulun tukud ya himpulu bon nipab-unan da. Silber di nakapyah kawit ya punhablayan. ");
INSERT INTO ifk_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hana ken hogpan nan Tabernacle nah nangappit hi timilan di algo ya napitut liman piyey kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Kediyen hogpan ya nikapyay ohan kurtinah kannawan ya oha boh kannigid an hindudwampulut duwat kagodwan piyey lukud da. Hintutlun tukud an nikapyah pangipab-unan di nangdon ke dadiyen kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Am-in nadan kurtinan nihableh nunlinikkod nan dolan nan Tabernacle ya nakapyah makaphod an luput. ");
INSERT INTO ifk_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ya am-in nadan nipab-unan nadan tukud ya nakapyah giniling, mu hanada ken kawit ya punhablayan hi kurtina ya nakapyah silber. Takon nadan udun di tukud ya naamoh silber. Am-in nadan tukud ya nakapyaan hi silber an punhablayan. ");
INSERT INTO ifk_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hanan kurtinan nihani nah hogpan ya tulumpulun piyey kadukkena ya pitut godwan piyey katag-ena, umat nadah kurtinan nidingding an nakapyah makaphod an luput ya nabordaan hi tinulid an blue, purple ya maka-ingit. ");
INSERT INTO ifk_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Opat di tukud na ya nipab-un hi giniling an pangipab-unan. Naha-adan damdamah silber di udun da ya takon nadan nilibod ya nadan punhablayan hi kurtina ya nakapyah silber. ");
INSERT INTO ifk_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ya am-in nadan paghok an nausal nah Tabernacle, takon nadan nunlinikkod hi dolana ya nakapya dah giniling. ");
INSERT INTO ifk_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hay bilang di balituk, silber ya giniling an nausal nah Tabernacle ya nitudok mipuun hi olden Moses. Intudok nadan holag Libay an hay ap-apu da ya hi Itamar an imbabalen Aaron an padi. ");
INSERT INTO ifk_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Hi Besalel an imbabalen Uri ya inap-apun Hur an nahlag ke Judah di ingkalgadun am-in ke datuwen in-olden APU DIOS ke Moses an maat. ");
INSERT INTO ifk_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bimmaddang ke hiyah Oholiab an imbabalen Ahisamak an nahlag ke Dan. Hiya ya nalaing an mun-alkus ya mangibordah blue, purple ya maka-ingit an tinulid hi makaphod an luput. ");
INSERT INTO ifk_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Datuwey bilang da: Immeh hinlibun kilon balituk di in-alin nadan holag Israel an nausal nah Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ya hay naamung an silber an indat nadan tatagu handih nabilangan da ya immeh tuluy libut opat di gatut ta tulumpulut duwan kilo. ");
INSERT INTO ifk_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hay nangidat ke datuwen silber ya nadan linalakin muntoon hi duwampulu weno nahawwal an ume dah onom di gatut ta tuluy libu ta limay gatut ta nalima. ");
INSERT INTO ifk_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tuluy libut opat di gatut an kiloy nausal nadah hinggatut an nipataddogan nadan tukud di Tabernacle ya nadan nipataddogan di tukud an punhablayan hanadah kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Hanan nahawwal an silber an umeh duwampulun kilo ya nakapyah kawit ya nadan nibaddong an punhablayan nadan kurtina ya nuntakap dah tap-on nadan tukud. ");
INSERT INTO ifk_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hay naamung an giniling an indat nadan tatagu ya umeh duway libut opat di gatut an kilo. ");
INSERT INTO ifk_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Nakapya datuweh nipataddogan nadan tukud nah hogpan nah Tabernacle, nan altar, nan nalaggan niha-ad nah dallomna ya nadan ngunut an mausal hidin nah altar. ");
INSERT INTO ifk_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Niusal boy giniling nah nipataddogan nadan tukud an nangdon hanadah kurtinah nunlinikkod nah dolan nan Tabernacle, nah hogpan ya nadan paghok an kigakodan dadiyen kurtina. ");
INSERT INTO ifk_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hanadan nalaing an mungkugut ya nangapya dah makaphod an luput an blue, purple ya maka-ingit ot kuguton dah ibulwatin nadan padih pangatan dah ipangunun APU DIOS. Hituwe damdaman luput di kinugut dah bulwatin Aaron mipuun hi olden APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nangapya dah ephod an nakapyah makaphod an luput ya nabordaan hi balituk, blue, purple ya maka-ingit an tinulid. ");
INSERT INTO ifk_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nangapya da boh balituk an tinulid an hay inat da ya minanantilyu da nan balituk ot umingpi ot ahida kanaltibon hi nakappinu. Inip-iphod dan imbordah tuwen balituk an tinulid nadah blue, purple ya maka-ingit an tinulid nah makaphod an luput. ");
INSERT INTO ifk_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ingkapyaan da nan ephod hi duwan luput an mihableh pukol ta mangdon nah duwan pingngit na. ");
INSERT INTO ifk_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ya hituwen duwan luput an nangdon nah ephod ya makaphod an luput di nausal ya nipniphod an nabordaan hi balituk, blue, purple, ya maka-ingit an tinulid, mipuun hi intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Inipkot da nadan batun onyx hi balituk ot ip-iphod dan ikul-it nadan ngadan di holag Israel ke dadiyen batun umat nah aton dan mangikul-it hi sinyal. ");
INSERT INTO ifk_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Intakap da datuwe nadah duwan luput an munha-ob an nihableh pukol an nikugut nah ephod. Datuwen batuy mumbalin an panginomnomnoman APU DIOS nadah holag Israel. Naat datuwen am-in mipuun hi olden APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Nangapya da boh luput an mitakap hi pagon nan padin nun-ingngoy inusal da nah kinapya dan ephod ya inip-iphod da damdaman binordaan. ");
INSERT INTO ifk_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kuwadladuh tuwen luput ya makuppin an hiyam an pulgaday kadukkena ya kabilog na. ");
INSERT INTO ifk_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Intakap da ketuwen luput di opat an linyan nunhihinnatkon an nabalol an batu. Hanah namangulun linya ya intakap day ruby, topaz ya garnet. ");
INSERT INTO ifk_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Hanah mikadwan linya ya emerald, saphire ya diamond. ");
INSERT INTO ifk_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Hanah mikatlun linya ya turquoise, agate ya amethyst, ");
INSERT INTO ifk_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ya hanah mikap-at an linya ya beryl, onyx ya jasper. Nipkot am-in datuwen nanginan batuh balituk. ");
INSERT INTO ifk_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Nip-ong di ngadan nadan himpulut duwan imbabalen Jacob an nitudok nadah nanginan batut itakdog day himpulut duwan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ingkapyaan dah diyen luput an mitakap hi pagoh kay nalubid an banggol an namahman balituk, ");
INSERT INTO ifk_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ya nangapya dah duwan balituk an natuligonggong ot ikugut da nah duwan dugun nan luput. ");
INSERT INTO ifk_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Inggakod da nan duwan nalubid an balituk ke datuwen natuligonggong, ");
INSERT INTO ifk_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ya inggakod da boy udun datuwen linubid nah duwan batun onyx an nitakap nah luput an mihableh pukol. ");
INSERT INTO ifk_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Nangapya da boh duwan natuligonggong an balituk ot ikugut da nah duwan dugun nan puun nan luput an mitakap hi pago. Ingkugut da nah dallom nan luput ta nidapot da nah ephod. ");
INSERT INTO ifk_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nangapya da boh duwan natuligonggong an balituk ot ikugut dah hinangngab nan luput an mihableh pukol nah tap-on nan balikit nan ephod. ");
INSERT INTO ifk_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Inusal day blue an linubid ot itakod da nadah natuligonggong an nikugut nah luput an mitakap hi pago ya nah ephod ta mihak-ot hidiyen luput nah tap-on nan balikit nan ephod an adi maunu, mipuun hi intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Numpakugut dah blue an bulwatin miodda nah ephod. ");
INSERT INTO ifk_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Hanan bagang tuwen bulwati an pangihukluban hi ulu ya naoddahan hi naabol an luput ta adi nalakan mabik-i. ");
INSERT INTO ifk_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kinapyan dah diyen bulwatih ing-ingon di bubungan di pomegranates an inusal day blue ya purple ya maka-ingit an tinulid ya makaphod an luput. ");
INSERT INTO ifk_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nangapya da boh namahman balituk an kingking ot ibanattan da nadah ing-ingon di bungan di pomegranate an intayun dah nunlinikkod nan udun nan bulwati. ");
INSERT INTO ifk_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Intayun day ohan kingking on intun-ud day ohan pomegranate inggana nalikkod nan udun nan bulwati mipuun hi intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ingkugutan dah Aaron ya nadan linalakin imbabalenah kamahhita, ");
INSERT INTO ifk_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","pongot, taddung, antikken pantalon ");
INSERT INTO ifk_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ya nan miawakon inusal day makaphod an luput an nabordaan hi blue, purple, ya maka-ingit an tinulid an inun-unud day kinalin APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Hay nanguddidih kinapya da ya nan namahman balituk an ongal an medal an nigakod hi hinangngab nan pongot. Nikul-it hidiy “Niong-ong ke APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Inusal day blue an tinulid an nangigakod kediyen medal nah tap-on nan pongot. Inat da datuwe mipuun hi olden APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Hituwe moy nagibbuwan nan Tabernacle. Ya inat nadan holag Israel am-in nadan in-olden APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","In-e dan Moses am-in nadan makapyah Tabernacle an datuwe ya: nadan kawit, nadan tukud na, nadan kaiw an miballabag, nadan pangipab-unan, ");
INSERT INTO ifk_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","nadan bolat di lakin kalneron numbalinon dah maingit, nan makaphod an lalat, nan kurtinah bohong nah kuwartun APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","nan Kahon APU DIOS ya nadan kaiw an pun-attang, ya nan hukap diyen Kahon, ");
INSERT INTO ifk_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nan lamesaan ya nadan ngunut an miusal hidi, nan tinapay an miappit ke APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","nan balituk an pangipattukan hi dilag, nadan kingke, nadan miusal kediye, nan lanan mihudu nadah kingke, ");
INSERT INTO ifk_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","nan altar an nakapyah balituk, nan lanan miduyag hi ulun di padi, nan insenso, nan kurtinan mihanih hogpan nah Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nan altar an nakapyah giniling, takon nan nalaggan giniling an miha-ad nah dallom na, nadan kaiw an pun-attang, ya am-in nadan ngunut an miusal hidi, nan palanggana, ya nan pangipattukan kediyen palanggana, ");
INSERT INTO ifk_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","nadan kurtinan midingding ya nadan tukud na ya nadan nipab-unan da, nan kurtinan nihanih hogpan nah dolan nan Tabernacle ya nadan gakod, nadan paghok, ya am-in nadan udum an ngunut an miusal nah Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","nadan makaphod an bulwatin di padin iusal dan mungngunu nah Tabernacle, nadan bulwatin Aaron ya nadan imbabalenan linalaki. ");
INSERT INTO ifk_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Datuwey inat nadan holag Israel an inun-unud dan am-in di in-olden APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Tinibon Moses am-in datuwen kinapya da ya inun-unud day in-olden APU DIOS an pangapya da ot bendisyonana. ");
INSERT INTO ifk_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kanan mon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Hanah mamangulun algo nah mamangulun bulan di pangikapyaan yu nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ipaghop yu nan Kahon hidi ya ingkapya yu nan kurtina ta mahaniyan. ");
INSERT INTO ifk_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ie yu boh di nan lamesaan ya inhaad yu nadan miha-ad hidi. Ya ipaghop yu nan pangipattukan hi dilag ta ipattuk yu nadan kingkeh di. ");
INSERT INTO ifk_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Hanan altar an punggohoban yuh bangbanglu ya iha-ad yu nah ha-ob nan Kahon ku. Ya iha-ad yu nan kurtinah panton nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hana ken altar an punggohoban hi miappit ya iha-ad yu nah hinangngab nan panton nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ya punuwon yuh danum nan palanggana ya iha-ad yu nah numbattanan tuwen altar ya nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ikapya yuy dolan nan Tabernacle ya hina-adan yuh kurtinay hogpan hidi. ");
INSERT INTO ifk_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Deket nagibbu ya waghikam nan Tabernacle hi lana ya am-in nadan wadah di ta miong-ong dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Waghikam damdamah lana nan altar an pun-appitan hi maghob, nadan ngunut an mausal hidi ta miong-ong dan ha-on ");
INSERT INTO ifk_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","takon nan palanggana ya nan kipattukana. ");
INSERT INTO ifk_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ie yu da Aaron ya nadan imbabalenat ulahan yu dida nah hogpan hi Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ya ipabulwatim Aaron nan bulwatin di padi ya duyagam hi lanay ulunat kitib-anan hiya ke ya niong-ong an padin munhilbin ha-on. ");
INSERT INTO ifk_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ipabulwatim damdama nadah imbabalena nadan kinalik an ibulwati da ");
INSERT INTO ifk_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ya duyagam hi lanay uluda, umat hi atom ama da ta miong-ong dan padin munhilbin ha-on. Hituwen pangiduyagam hi lana ke Aaron ya nadan imbabalenay kitib-anan ammunay holag dan mahanhanot an mumpadit nangamung nadah holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Inun-unud Moses am-in datuwen kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Handih namangulun algo nah namangulun bulan hi mikadwan toon nipalpuh nanayanan dad Egypt ya nakapya nan Tabernacle an kiha-adan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Impataddog Moses nadan tukud nadah kipataddogan da ot ahina pun-ikapya nadan kalkalimangngana. ");
INSERT INTO ifk_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Inatopanah na-oddan tuldan inun-unud na nan kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Inha-ad na nadan duwan batun nitudkan di Tugun APU DIOS nah Kahon ot iduduk na nan duwan kaiw an pun-attang nadah natuligonggong an nitakap nah Kahon ot hukapona. ");
INSERT INTO ifk_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Impaghop nah tuwen Kahon nah Tabernacle ot itayuna nan kurtinan mihani nah Kahon. Inat na datuwe mipuun nah kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Impaghop na bo nan lamesaan nah bohongnan di Tabernacle ot iha-ad nah bah-el nan kurtinah nangappit hi kannawan. ");
INSERT INTO ifk_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Inha-ad nah di nan tinapay an niappit ke APU DIOS an inun-unud na nan kinalinan atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Inhaad na nan pangipattukan hi dilag nah dommang nan lamesaan ");
INSERT INTO ifk_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ot ipattuk na nadan kingken hidi kad-an APU DIOS an inun-unud nay in-oldenan atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Inha-ad na nan altar an punggohoban hi insenso nah hinangngab nan kurtinah bohongnan nan Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ot gobhonah di nan nabanglun insenson miappit ke APU DIOS an inun-unud na bo nan in-oldenan atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nagibbuh diye ot kurtinaana nan hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inhaad na nan altar an punggohoban hi miappit nah nih-up nah panton nan Tabernacle. Ginhob nah di nadan aggayam an miappit ke APU DIOS takon nan pagen miappit an inun-unud nay in-oldenan atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inhaad nan palangganah nah numbattanan nan panton di Tabernacle ya nan altar an punggohoban hi miappit ot punuwonah danum. ");
INSERT INTO ifk_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Hidiy pun-ulahan da Aaron ya nadan imbabalenah hukida ya takle da ");
INSERT INTO ifk_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ten humgop da nah Tabernacle. Inat nah tuwe mipuun nah in-olden APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Hay nanguddidin inat Moses ya kinurtinaanay nunlinikkod nan dolan di Tabernacle ya nan hogpan kediyen dola ot hidiyey ginibbun di ngunu nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Indani ya hinophopan di kulabut nan Tabernacle ya humihhili te wadah APU DIOS hidi. ");
INSERT INTO ifk_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ot adi mo pakahgop hi Moses te hinophopan diyen kulabut ya humiliy dayaw APU DIOS hidi. ");
INSERT INTO ifk_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Deket timmap-o nan kulabut ta mange on ahida inumga nadan holag Israel an umeh pangayan dan miun-unnud da. ");
INSERT INTO ifk_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mu deket nuntikod on nuntikod da damdama. Deket nadlig on nadlig da damdama. ");
INSERT INTO ifk_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Deket mapat-al on nuntikod nan kulabut an mipottok nah tap-on nan Tabernacle ya deket nah hilong on numbalin hi kay apuy ta panilag nadan holag Israel ta pakatibo da. Hidiyen kulabut ya wadat nangamung kediyen nundanallanan da.");
INSERT INTO ifk_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Hi APU DIOS an wada nah Tabernacle ya inayaganah Moses ot kalyonan am-in ke hiyay ");
INSERT INTO ifk_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","un-unudon nadan holag Israel ten mun-appit dah aggayam da, umat hi baka, kalnero ya gulding. ");
INSERT INTO ifk_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kananan hiyay “Hituwey kalyom ke dida: ‘Deket hay iappit nan tagu ya maghob an baka, mahapul an hidiye ya laki ya maphod an maid di dipektona. Iali nah diyet idawat na nah padi nah hogpan hi Tabernacle ta abuluton APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ihakmon diyen taguy takle na nah ulun nan baka ta abulutonah diyen iappit nat makaan di liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kolngon diyen tagu nan bakah di ne alan nadan padin imbabalen Aaron di dalan diyet iwaghik da nah altar nah hinangngab nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ne latlatona nan bolat diyen baka ta ahina tanogtogona ");
INSERT INTO ifk_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","yaden punha-adan nadan padin imbabalen Aaron hi kaiw nan altar ta mun-apuy da. ");
INSERT INTO ifk_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ne itap-o da nadan natanogtog an dotag nan baka takon nan uluna ya tabana nah mumbabalan kaiw. ");
INSERT INTO ifk_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Mu nadan putuna, altena ya balana, takon nadan hukina ya ulahan nan tagu ta id-um nan padin gobhon nah altar ta iappit nah APU DIOS ya hay hamuy tuwen miappit ya umipaamlong ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Deket hay iappit nan tagu ya kalnero weno gulding, mahapul an hidiyen iappit na ya laki ya maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kolngona nah nangappit hi kannawan nan altar hi hinangngab APU DIOS. Ya iwaghik nadan padiy dalana nadah dingding diyen altar. ");
INSERT INTO ifk_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Tanogtogon nan taguy dotag diyen kalnero weno gulding ne alan nan padit itap-o na nah mumbabalan kaiw nah altar takon di uluna ya tabana. ");
INSERT INTO ifk_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ya mahapul an ulahan nan taguy putuna diye, hay altena ya balana takon nadan hukinat id-um nan padin gobhon nah altar ta iappit nan APU DIOS ya hay hamuy tuwen miappit ya umipaamlong ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Deket hay miappit an maghob ya hamuti, mahapul an hidiye ya paloma weno balug. ");
INSERT INTO ifk_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","16","Ien nan padi nan hamuti nah altar ta tilononay bagang na ya kaanonay bintuul na ya nan kinanat iwele na nah pangiha-adan dah dap-ul nah e-elen nan altar nah nangappit hi timilan di algo. Ya itodtod nay dalan diyen hamuti nah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ne hoklaonah diyen hamuti mu tibonat adi malahla nan payak na ne ginhob na nah altar ya hay hamuy tuwen miappit ya umipaamlong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Deket hay miappit ya boga, mahapul an magiling ta mumbalin an alinah. Ya ha-adanah mantekan di oliba ya bangbanglun insenso ");
INSERT INTO ifk_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ya iena nadah padin imbabalen Aaron. Gumamal nan padi kediyen alinan naha-adan hi mantekan di oliba ya bangbanglun insenso ne ginhob na nah altar ta kitib-anan niappit ke APU DIOS hidiyen alina ya hay hamuy tuwen miappit ya umipaamlong ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Hay udum kediyen alinan niappit ya midat nadah padi an hi Aaron ya nadan imbabalena. Hidiyen alina ya niong-ong ke APU DIOS te niappit ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Deket hay miappit ya tinapay, mahapul an nakapyah makaphod an alinan naha-adan hi mantekan di oliba ya naha-adan hi bangbanglun insenso, mu adi makammohan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ya deket nan iappit yun alina ya miha-ang hi palyuk ya mahapul an hidiye ya makaphod an alinah ya maha-adan hi mantekan di oliba, mu adi makammohan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mabuklih diyen tinapay ya maduyagan hi mantekan di oliba ta hidiyey miappit an alina. ");
INSERT INTO ifk_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Deket hay miappit ya tinapay umat hi milutuh palhu, mahapul an hidiye ya makakkaphod an alinah ya maha-adan hi mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ien nan tagu nah padih diyen iappit nan APU DIOS ta ien nan padi nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ne umala nan padih ittay ta gobhona nah altar ta kitib-anan niappit hidiyen APU DIOS ya hay hamuy tuwen miappit ya umipaamlong ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Hay udum kediyen miappit an tinapay ya midat nadah padi te niong-ong dadiyen niappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Mahapul an adi makammohan hidiyen miappit ke APU DIOS hi mumpalbag weno iyyukan te adinadaman maghob di mumpalbag hi tinapay ya hay iyyukan ten hay miappit ya maghob. ");
INSERT INTO ifk_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Deket hay miappit ya nan makamangngulun naani ya damanan makammohan hi mumpalbag weno iyyukan, mu adi mabalin an maghob hidiyen miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Maha-adan hi ahin nadan bogan miappit ke APU DIOS ta mangipanomnom ke dakayu nah nakitobbalan yun hiya. Ipidwak an kalyon, mahapul nimpen adiyu kal-iwan an udman hi ahin nadan iappit yu. ");
INSERT INTO ifk_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ihanglag nan taguh diyen mamangulun aniyonan iappit nan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ya ha-adanah mantekan di oliba ya bangbanglun insenso. ");
INSERT INTO ifk_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Umala nan padih ittay kediyen iappit nan nihanglag an nakammohan hi mantekan di oliba ya bangbanglun insenso ne ginhob na nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Deket mun-appit di ohan taguh pakihayyupanan APU DIOS ya mahapul an bulug weno kaba-yan an bakan maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ihakmo nay taklenah ulun nan bakan iappit na ya kolngona nah nih-up hi hogpan nah Tabernacle. Ne iwaghik nadan padin imbabalen Aaron di dalan diyen baka nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ya am-in nadan taban wadah dalom di adol na, ");
INSERT INTO ifk_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nadan duwan batin ya nan tabana, nan alte ya nan nikuyaput an taba ya miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Itap-on nadan imbabalen Aaron datuwe nadah dotag an miappit ke APU DIOS ta gobhon da ya hay hamuy tuwen miappit ya umipaamlong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Deket hay miappit ya kalnero weno gulding, mabalin di laba weno laki ya mahapul an maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","8","Ihakmon nan taguy taklenah ulun nan kalneron iappit na ne kolngona nah nih-up hi hogpan nah Tabernacle. Ne iwaghik nadan padiy dalan nan kalnero nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Hanan iwit na ya nan tabana, nadan taban di puhu ya putu, ");
INSERT INTO ifk_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","nadan duwan batin ya nan tabana ya nan taban nikuyaput nah alte ya miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ya gobhon nadan padi datuwen makan an miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Deket gulding di iappit nan tagun APU DIOS ");
INSERT INTO ifk_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ya ihakmo nay taklenah ulun diyen gulding ne kolongona nah nih-up hi hogpan nah Tabernacle. Ne iwaghik nadan padin imbabalen Aaron di dalana nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Hanan taban di puhu ya putuna, ");
INSERT INTO ifk_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nadan duwan batin takon nan tabana ya nan taban nikuyaput nah alte ya kaanon ");
INSERT INTO ifk_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","nadan padi ne ginhob da nah altar ta miappit ke APU DIOS ya hay hamuy tuwe ya umipaamlong ke hiya. Am-in di taba ya niong-ong an miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Adi mabalin an eyu kanon di taba ya dala. Hituwen tugun ya munnananong ta nangamung ya mahapul an un-unudon nadan holag yu takon di daanay pumboblayan da.’” ");
INSERT INTO ifk_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Kalyom hituwe nadah holag Israel: ‘Deket ugge inun-unud di ohan taguy tugun an APU DIOS ot munliwat, mu uggena ingnguddan ya datuwey mahapul an aton na. ");
INSERT INTO ifk_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Deket hanan natag-en padiy nunliwat ot milagat nadan tatagu nah liwat na ya mahapul an iappit nan APU DIOS on lakin kilaw an bakan maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ie na nah nih-up hi hogpan nah Tabernacle an pundayawan ta ihakmo nay takle na kediyen aggayam ne kolngona nah hinangngab APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hanan padin natuddun munhilbi kediyen algo ya umala nah dalat ihgop na nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ne itdok nay gamat na kediyen dala ta iwaghik nah mamimpituh hinangngab nan kurtina ya hinangngab APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ya ha-adanah dala nadan opat an nidongdong an dugun nan altar an punggohoban hi bangbanglun insenso nah kawad-ana. Hanan udum an dala ya ena iduyag nah puun nan altar an punggohoban hi miappit an wada nah nih-up hi hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Mahapul an kaanon nan padin am-in di taban diyen baka, takon nadan tabah putuna. ");
INSERT INTO ifk_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Pakikaana nadan batin takon nan tabana ya nan alte na ");
INSERT INTO ifk_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ne ginhob na nah altar an pangighoban hi miappit. Athidi damdamay atona nah taban di lakin bakan kolngonan miappit hi pakihayyupanan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mu nan udum an parten nan baka umat hi bolat na, hay lamana, hay uluna, hay hukina ya hay putuna ya alan nan padi ");
INSERT INTO ifk_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ta ie na nah e-elen nan boblen mibilang an malini ne ginhob nah di nah punwelleyan dah dap-ul. ");
INSERT INTO ifk_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ya deket nunliwat am-in nadan bimmoblen holag Israel te imbahho day Tugun APU DIOS, mu uggeda ingngudan ya mibilang an naliwat dan am-in. ");
INSERT INTO ifk_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Deket nainnilaan dan nunliwat da ya umala nadan aap-apuh kilaw an lakin bakan miappit gapuh liwat ta ipresenta da nah nih-up hi hogpan nah Tabernacle ");
INSERT INTO ifk_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ne ihakmo day takle da nah ulun diyen lakin baka ta kolngon dah dih hinangngab APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ya alan nan padiy udum an dala nat ihgop na nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ne itdok nay gamat na nah dala ta iwaghik na nah mamimpituh hinangngab nan kurtina ya hinangngab APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Alan bon nan padi nan udum an dala ta iha-ad na nah nidongdong an dugun nan altar an punggohoban hi insenso nah bohongnan nan Tabernacle an hinangngab APU DIOS. Ya nan natdaan an dala ya iduyag na nah puun nan altar an wada nah hogpan nah Tabernacle an punggohoban hi miappit. ");
INSERT INTO ifk_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mahapul an kaanon nan padin am-in di tabanat gobhona kediyen altar, ");
INSERT INTO ifk_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ya atonay umat hi pangat na nah iappit na gapuh liwat na, ta makaan di liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ya ie na nadan udum an parten nan baka nah e-elen nan boblet gobhonah di, umat hi inat na nah in-appit na gapuh liwat na. Hituwen miappit di mangaan hi liwat nadan bimmoblen holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Deket nunliwat di ap-apu te uggena inun-unud di Tugun APU DIOS, takon di uggena ingnguddan ya mibilang an naliwat. ");
INSERT INTO ifk_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Deket nainnilaana ya mahapul an iali nay lakin gulding an maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ne ihakmonay taklenah ulun diyen gulding ta kolngonah di nah altar nah hogpan nah Tabernacle an pangiklongan dah maghob an miappit ke APU DIOS ta makaan di liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Itdok nan padiy gamat na nah dalan diyen gulding ta itottod na nadah nidongdong an dugun diyen altar an punggohoban hi miappit. Ya nan natdaan an dala ya iduyag na nah puun diyen altar. ");
INSERT INTO ifk_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Hanada ken taba ya gobhonan am-in nah altar, umat hi atona nah taban nan miappit an pakihayyupan ke APU DIOS. Aton nan padih diyet makaan di liwat diyen ap-apu. ");
INSERT INTO ifk_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Deket kumpulmi nadah tataguy ugge nangun-unud hi Tugun APU DIOS ya maliwat da takon di uggeda ingnguddan. ");
INSERT INTO ifk_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Deket nipainilan hiyah diyen nunliwatana ya ialinay ohan gulding an laba an maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ne ihakmonay takle na nah ulun diye ya kolngona nah altar an pangiklongan hi miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hanan padi ya itdok nay gamat na nah dalat itottod na nadah nidongdong an dugun diyen altar. Ne iduyag na nan natdaan an dala nah puuna. ");
INSERT INTO ifk_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ya kaanonay taban nan gulding, umat nah miappit hi pakihayyupan ke APU DIOS ne ginhob na nah altar ta umamlong hi panamuyana nah nabanglun hamuy diye. Gapu ketuwen aton nan padi ya makaan di liwat nan tagun nun-appit. ");
INSERT INTO ifk_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Deket ka-ongal nan kalneroy in-alin nan tagun iappit na ya mahapul an laba an maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ihakmo nay takle nah ulun diyen kalnero ne kolongona nah altar an pangiklongan hi miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Itdok nan padiy gamat na nah dalan nan kalnero ta itottod na nadah nidongdong an dugun nan altar an pun-appitan hi maghob. Ya nan natdaan an dala ya iduyag na nah puun diyen altar. ");
INSERT INTO ifk_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kaanonan am-in di tabana umat nah ka-ongal nan kalneron miappit hi pakihayyupan ke APU DIOS, ne ginhob nan itap-ona nadah udum an maghob an miappit. Aton nan padih diye ta makaan di liwat nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Deket nipaayag di ohan tagut muntistigu mipanggep hi tinibona weno dingngol na, mu adi kumalin pamganay op-opya ya munliwat ta mahapul an makastigu. ");
INSERT INTO ifk_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Deket ugge ingnguddan nan tagun dinapa on panion aggayam te mibilang an adi malini, hay naten aggayam an mailom weno adi ya nadan mungkaddapan ya mibilang an nunliwat hidiyen tagu te hidiye ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ya deket nidatum nan taguh nganneh diyen panio yaden uggena inila ya mibilang an nunliwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Deke bot nunsapatay ohan tagu yaden uggena ipakannomnom hin hidiyen insapata na ya maphod weno adi ya mibilang an nunliwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Deket inat nan tagu datuwe ya mahapul an kalyonan inat na. ");
INSERT INTO ifk_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ya mahapul an iappit nan APU DIOS di ohan laba an kalnero weno gulding ta makaan di liwat na. Hanan padiy mangiappit kediye gapuh liwat diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Deket adi gol-an nan taguy kalnero weno gulding ya umialih duwan paloma weno balug ta hidiyey iappit na gapuh liwat na. Hay oha ke dadiyen hamuti ya miappit gapuh liwat ya nan oha ya miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ie na dadiyen hamuti nah padit mamangulun iappit na nan miappit gapuh liwat. Tilononay bagang diyen hamuti mu adi maputul di uluna. ");
INSERT INTO ifk_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ya iwaghik nay dalan diyen hamuti nah dingding nan altar ya iduyag na nan udum an dalan diyen hamuti nah puun diyen altar. Hituwe ya miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hanan mikadwan hamuti ya iappit nan padi mu miohhan maghob mipuun hi ine-en di miappit an maghob. Iappit nah tuwe ta makaan di liwat nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Deket adi gol-an nan taguy duwan paloma weno balug, mahapul an umialih duwan kilon makaphod an alinah ta iappit na gapuh liwat na. Adina ha-adan hi mantekan di oliba weno ngannen mumpabanglu te hidiye ya miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ie na nah padi ta gumamal ta kitib-anan miappit ke APU DIOS ta gobhonan itap-ona nadah udum an miappit an maghob nah altar. Hituwe ya miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Hanan padiy mangiappit kediye gapuh liwat diyen tagu ta makaan di liwat na. Alan nan padi nan udum an alina te bagina, umat hi atona nah alina an miappit.’” ");
INSERT INTO ifk_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Datuwey kinalin APU DIOS ke Moses an mahapul an maunud. ");
INSERT INTO ifk_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Deket waday ohan tagun nunliwat te inat nay adina lebbeng an aton hi nganneh diyen niong-ong ke APU DIOS, mu uggena ingnguddan ya mahapul an iappit nay ohan lakin kalnero weno lakin gulding an maid di dipektona. Hidiyey makalin miappit gapuh liwat na. Hay pumbalol dan diye ya mipuun nah kinalin nadan aap-apun maunud. Hituwe ya miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mahapul an mumbayad nan tagu gapun diyen inat na ya udmanay ibayad nah duwampulun porsiento ta hidiyey moltana. Idat na nah padih diyen ibayad na ya nan padiy mangiappit kediye takon nan aggayam ta makaan di liwat diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Deket nunliwat di ohan tagu te uggena inun-unud di Tugun APU DIOS ya mahapul an mumbayad hi moltana takon di uggena inilan inat nah diye. ");
INSERT INTO ifk_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ya mahapul an iena nah padiy ohan lakin kalnero ta iappit nan padi gapuh liwat nan tagu. Mahapul an maid di dipekton diyen iappit na ya ustuy balol na. Miappit hidiyen kalnero ta makaan di liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hidiyen miappit ya gapuh nunliwatan diyen tagu ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Deket nunliwat di ohan tagun ha-on an APU DIOS te nunlangkak an kananay natalak weno naako nan impatalun di ibbanan hiya, weno kinuluk na weno naakoh diyen nipadulin ke hiya, ");
INSERT INTO ifk_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","weno hin kananat hinamak na on natalak yaden isapata nan kananay maid di hinamak na, weno waday inat nah udum hi athidin pumbahulan ya mahapul an atona datuwe: ");
INSERT INTO ifk_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Mahapul an ipabangngad nay inalana gapuh langkak na weno inako na takon di dadiye ya nipadulin weno nidinol ke hiya, weno hidiye ya natalak ot hamakona ");
INSERT INTO ifk_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","weno ingnguddanan inalana ot munlangkak. Mahapul an ibangngad nah diye ya mumbayad pay hi duwampulun porsiento nah tagun nangatana kediyen pumbahulan kediyen algon pun-appitana gapuh liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Mahapul an iena nah padi on lakin kalneron maid di dipektona ta iappit nan padin ha-on an APU DIOS. Bokon ke ya hay balol nah pihhuy iena, mipuun nah maunud an balol na ");
INSERT INTO ifk_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ta hidiyey iappit nan padit makaan di liwat diyen tagu.” ");
INSERT INTO ifk_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Itugun mun Aaron ya nadan linalakin imbabalena datuwen maunud hi pun-appitan hi maghob: Hanan miappit an maghob ya mahapul an miha-ad nah altar hi ohan hilong inggana biggatna ya mahapul an munnanong nan apuy an adi mad-op. ");
INSERT INTO ifk_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ne ibulwatin nan padi nan makaphod an bulwatin di padi takon nan bulwatin mioddah nundallom ta linihana nan altar an kaanona nan dap-ul nan niappit an maghob ta iha-ad na nah paldang diyen altar. ");
INSERT INTO ifk_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ne deket nagibbu ya kaanona bo nan makaphod an imbulwatinat ihannot na nan datin imbulwatinat iena nan dap-ul nah e-elen di kampu ta ena iwele nah mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Hanan apuy nah altar ya mahapul nimpen adi mad-op. Kinali mahapul an ha-adan nan padih itungu nan altar hi kabigabigat ya iphod nan iha-ad hidi nan miappit an maghob ta gobhonay taban diyen miappit hi pakihayyupan ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Nomnomon yun mahapul nimpen munnanong nan apuy nah altar an adi mad-op. ");
INSERT INTO ifk_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Datuwey maunud hi pun-appitan hi makaphod an alina. Alan di ohan padin imbabalen Aaron nan alinat ipresentanan APU DIOS nah hinangngab nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Umalah hinggamal kediyen alina an naha-adan hi mantekan di oliba ya bangbanglun insenso ta gobhonah diyen niappit ke APU DIOS nah altar ta umamlong hi hamuy na. ");
INSERT INTO ifk_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Hanan natdaan kediyen alinah ya midat ke Aaron ya nadan imbabalena ta kanon da. Kapyaon dah tinapay an adida ha-adan hi mumpalbag ta kanon da nah dolan nan Tabernacle. Hidiye ya bingay nadan padi kediyen niappit an makan ke APU DIOS. Ya nangilinan hidiye umat nah miappit gapuh liwat ya bahul. ");
INSERT INTO ifk_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Midatan am-in di linalakin holag Aaron takon di hay holag nah udum hi algo te hidiyey bingay da. Ya am-in di nganneh diyen midatum kediye ya mumbalin an niong-ong ke APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Datuwe boy kinalin APU DIOS ke Moses an maunud: ");
INSERT INTO ifk_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Hanah algon miong-ong di holag Aaron an mumpadi ya iappit dan APU DIOS di hin-oh-an kilon alinah, umat nah miappit hi kabigabigat. Miappit di godwan tuwe nah biggatna ya miappit bo nah mungkahilong di godwana. ");
INSERT INTO ifk_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Mahapul an maka-ikkammo nan alina ya mantekan di oliba ya milutuh palhu ya maganodwa. Hituwen miappit ya umipaamlong di hamuy na ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Am-in di mahanhanot an holag Aaron ya iappit dat nangamung hidiye ke APU DIOS nah algon miong-ong dan mumpadi. Hidiyen miappit ya maghob. ");
INSERT INTO ifk_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ya adi mabalin an makan hidiyen iappit dadiyen padi te mahapul an maghob am-in.” ");
INSERT INTO ifk_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Kinalin bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Itugun mun Aaron ya nadan linalakin imbabalena datuwen maunud hi pun-appitan da gapuh liwat. Hanan aggayam an miappit gapuh liwat ya niong-ong ke APU DIOS ta hidiye nan mahapul an kolngon dah hinangngab na nah altar an pangiklongan hi maghob an miappit. ");
INSERT INTO ifk_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Hanan padin mangiappit kediye ya damanan kanonay bingay na nah dolan nan Tabernacle an niong-ong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ya nan manapa weno midatum ketuwen niappit ya mumbalin an miong-ong ke APU DIOS. Ya nan bulwatin napawaghikan nah dala ya mahapul an maulahan nah natuddun pun-ulahan. ");
INSERT INTO ifk_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Deket pulan bangay kiha-angan nan niappit ya mahapul an mabuwe. Deket giniling nan banga ya mahapul an maad-adan ya makaullahan. ");
INSERT INTO ifk_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ammunay linalakin imbabalen di padiy mabalin an mangan kediyen miappit. ");
INSERT INTO ifk_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mu nan miappit gapuh liwat an mipaghop di dalana nah Tabernacle ta makaan di liwat nadan tatagu ya mahapul an maghob. Te adi mabalin an mihday dotag diye.” ");
INSERT INTO ifk_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Datuwe nadan maunud hi pun-appitan gapuh liwat: Hidiyen miappit ya miong-ong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mahapul an kolngon dah diyen miappit nah pangiklongan hi miappit an maghob. Ya miwaghik di dalana nadah opat an dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ya iappit nan padin am-in di tabana, umat nah taban di iwit na, taban di wadah dalom di adol na, ");
INSERT INTO ifk_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nadan duwan batin, ya nan tabana, ya nan nikuyaput hi altenan milaggat an makikaan hanadah batin. ");
INSERT INTO ifk_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Iappit nan padi ke APU DIOS datuwen gobhona nah altar gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ammuna nadan linalakin imbabalen di padiy mangan kediyen niappit an aggayam nah Tabernacle an niong-ong ke APU DIOS te hidiye ya niappit ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Nun-ingngoy maunud hi pun-appitan gapuh bahul ya liwat. Hanan padin mangiappit ya alanay dotag nadan aggayam an niappit hi kakaanan di liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mu nan padin mangiappit nah maghob ya nan bolat diyen aggayam di alana. ");
INSERT INTO ifk_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ya am-in nadan miappit an boga an kumpulmiy niha-angana ya alan nan padin nangiappit kediye. ");
INSERT INTO ifk_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mu am-in nan boga an miappit takon nan alinah an nakammohan hi mantekan di oliba weno ugge ya midat nadah papadin imbabalen Aaron. ");
INSERT INTO ifk_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Datuwey kinalin APU DIOS ke Moses an maunud hi pun-appitan di taguh pakihayyupanan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Deket iappit nan taguh diyeh pumpasalamatanan Apu Dios ya id-um nan iappit di mahdol ya maingpin tinapay an naha-adan hi mantekan di oliba ya ugge nakammohan hi mumpalbag ya id-um nay tinapay an nakapyah makaphod an alinan naha-adan hi mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ya damanan id-um nan iappit di tinapay an nakammohan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Hin-oh-a ke datuwen tinapay di iappit nan APU DIOS. Ya midat datuwe nah padin nangiwaghik nah dala nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ya mahapul an makan kediyen algon am-in di dotag nan aggayam an niappit an maid di matdaan. ");
INSERT INTO ifk_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Mu deket mun-appit di ohan taguh pangipatib-an impaannung nay insapatana weno ingnguddanan mun-appit ya adi mahapul an makan am-in nan dotag kediyen algo. Deket waday natdaan ya takon di kanon dah kabiggatana. ");
INSERT INTO ifk_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mu deket waday matdaan an adi makan kediyen mikadwan algo ya mahapul mon maghob. ");
INSERT INTO ifk_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ya deket kanon da nan matdaan nah mikatlun algo ya adi mo abuluton Apu Dios di in-appit nan tagu ta maid moy hilbin diye te mibilang an adi malini. Hanan tagun mangan kediyen matdaan ya holtaponay maat ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Deket waday kidattuman nan dotag hi kumpulmin mibilang an adi malini ya adi mabalin an makan hidiyen dotag te panio, kinali mahapul an maghob. Mu nan udum an dotag diyen niappit ya damanan kanon nan tagun mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ya deket kanon nan tagun adi mibilang an malinih diyen niappit ya adi mo makid-um hidiyen tagu nadah tatagun Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Hanan tagun dinapana weno nidatum hanadah mibilang an adi malinin tagu weno aggayam weno nganneh diye yaden kinanay dotag nan aggayam an niappit ya adi mo makid-um hanadah tatagun Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kalyom hanadah holag Israel an adida kanon di taban di baka, kalnero ya gulding. ");
INSERT INTO ifk_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ya adida kanon di taban nan aggayam an nate weno pinaten di mailom an aggayam, mu damanan miusal nan tabah udum an kiusalana. ");
INSERT INTO ifk_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Hanan tagun mangan hi taban nan maghob an aggayam an miappit ke APU DIOS ya adi mo makid-um hanadah tatagun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Dida an holag Israel ya adi mabalin an eda kanon di dalan di aggayam ya hamuti takon di daanay pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Hanan adi mangun-unud ketuwe ya adi mo makid-um hanadah tatagun Apu Dios.” ");
INSERT INTO ifk_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kinalin bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Itugun mu nadah holag Israel hituwe: Hanan tagun mun-appit hi pakihayyupan ya idat nay udum ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Odnan nan taguh diyen maghob an iappit nan taba ya pagon nan aggayam ta itagge nan ipresenta ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ne gobhon nan padih diyen taba nah altar mu hanan pago ya midat nadah padin hi Aaron ya nadah imbabalena. ");
INSERT INTO ifk_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Takon nan wawwan an ulpun nan aggayam ");
INSERT INTO ifk_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ya midat nah padin nangiwaghik nah dala ya nunggohob nah taba nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Te hay pago ya hay wawwan an ulpu ya idat APU DIOS nadah papadi. Hidiyey lebbengnan midat an ibingay nadan holag Israel ke didan papadi nah iappit dan pakihayyupan ke APU DIOS. Hituwe ya mahapul an maunud ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hituwey midat an bingay nadan papadin imbabalen Aaron takon nadan holag dah udum hi algo. Natuddun bingay dah tuwe nipalpu handih natuddu dan mumpadi ta munhilbi dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Kediyen algon natudduwan dan mumpadi ya in-olden APU DIOS nadah holag Israel an idat dah tuwen bingay nadan papadi ya nadan holag dah udum hi algo. Ya mahapul an maunud ta nangamung hituwe. ");
INSERT INTO ifk_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Danaey maunud hi pun-appitan hi maghob, pun-appitan hi page, pun-appitan gapuh liwat, pun-appitan gapuh bahul, pun-appitan hi pumpadiyan, ya pun-appitan hi pakihahayyupan ke APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Intugun APU DIOS datuwe ke Moses nah adi maboblayan nah Bilid an Sinai handih in-oldena nadah tatagunan mun-appit dan hiyah di nah adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Handi ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Iem hi Aaron ya nadan linalakin imbabalena nah hogpan hi Tabernacle. Itabin day bulwati dan bulwatin di padi, hay lana, kilaw an lakin bakan miappit gapuh liwat, hay duwan lakin kalnero ya hay tinapay an ugge naha-adan hi mumpalbag an niha-ad hi hukup. ");
INSERT INTO ifk_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ayagam am-in nadan bimmoblet umali dah di nah hogpan hi Tabernacle.” ");
INSERT INTO ifk_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Inun-unud Moses ot handih naamung nadan tatagu ya ");
INSERT INTO ifk_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","kananan diday “Deyan atok di kinalin APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ot ienah Aaron ya nadan linalakin imbabalenah hinangngab nadan tatagu ot ipaat nan dida nan ine-en di pun-amo. ");
INSERT INTO ifk_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Impabulwati nan Aaron nan bulwatin di padi ya impumbalkona. Impabulwati na bo nan ephod an hidiye nan mioddan muntap-on bulwatin di padi ot ipabalko na nan balkon naabol ta mangdon nah ephod. ");
INSERT INTO ifk_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ya intakap na nan luput an mitakap nah pagon nan ephod ot ihudu nah di nan Urim ya Tummim. ");
INSERT INTO ifk_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Impapngot nan Aaron nan pongot ot itakap na nan balituk an medal nah hinanggan diyen pongot. Athidiy kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Inalan bon Moses nan lana ot waghikana nan Tabernacle ya am-in nadan wadah di ta miong-ong dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Inwaghik na nan lanah namimpitu nah altar takon nadan ngunut an mausal hidi, nan palanggana ya nan nipattukana ta miong-ong da. ");
INSERT INTO ifk_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ot duyaganay ulun Aaron hi lanat miong-ong damdaman APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Hanada ke bon linalakin imbabalen Aaron ya in-e na didah hinangngab di Tabernacle ot ipabulwatina nan bulwati da, impabalkona nan balko da ya impapongot nay pongot da. Inun-unud nay kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Nagibbuh diye ot iappit na on lakin baka gapuh liwat. Inhakmon Aaron ya nadan linalakin imbabalenay takle da nah ulun diyen baka ");
INSERT INTO ifk_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ot kolngona. Immala boh Moses hi dalan diyen baka ot itdok nay gamat na ot itodtod na nadah opat an nidongdong an dugun nan altar ta atonay ine-en di punlini. Ya induyag na nan natdaan an dala nah puun diyen altar ta miong-ong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Hanada ken taban di puhu, taban di putu, nan taban nikuyaput hi alte, nadan batin ya nadan taba ya ginhob nan am-in nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ya nan natdaan an dotag diyen baka an dadiye ya bolat, laman ya silit ya ena ginhob nah e-elen di kampu. Hidiyey kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Impresentan bon Moses on lakin kalneron iappit nan maghob. Ot ihakmon da Aaron ya nadan linalakin imbabalenay takle da ");
INSERT INTO ifk_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ot kolngon Moses. Inalanan nan dalan diye ot iwaghik na nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ya tinanogtog nah diyen lakin kalnero ta gobhona takon di uluna ya tabana. ");
INSERT INTO ifk_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Inulahana nan putu takon nan huki ot pakighob na nah altar. Hanan nabanglun hamuy diyen in-appit nan maghob ya umipaamlong ke APU DIOS. Hidiyey inat Moses mipuun hi kinali APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Indani ya impresentan bon Moses ke APU DIOS nan mikadwan lakin kalneron maklong hi pumpadiyan da Aaron ya nadan linalakin imbabalena. Inhakmo day takle dah ulun diyen kalnero ");
INSERT INTO ifk_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ot kolngon Moses. Immalah dalana ot ha-adanay wawwan an ingan Aaron, hay wawwan an am-ama-an di taklena ya hukina. ");
INSERT INTO ifk_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ya hina-adanay wawwan an ingan damdaman nadan linalakin imbabalen Aaron, hay wawwan an am-ama-an di takle da ya hukida. Inwaghik na nan udum an dala nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Inalanay taban nan iwit, am-in di taban nadan puhu, putu, alte, nadan batin ya nan wawwan an ulpuh. ");
INSERT INTO ifk_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ya immalah ohan tinapay an ugge naha-adan hi mumpalbag, hay ohan tinapay an naha-adan hi mantekan di oliba ya ohan maingpin tinapay, ot itap-o na ke dadiyen taba ya wawwan an ulpuh. ");
INSERT INTO ifk_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Impad-onan am-in datuwe ke da Aaron ya nadan linalakin imbabalena ot itagge dan impresentan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Inalan bon Moses dadiye ot itap-ona nadah miappit an maghob nah altar ot gobhona. Hidiye ya miappit hi pumpadiyan da Aaron ya nadan linalakin imbabalena. Hay hamuy dadiye ya umipaamlong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Inalan bon Moses nan pago ot itagge nan impresentan APU DIOS. Hidiyey bingay na kediyen lakin kalneron niappit hi pumpadiyan nadan padi. Hidiyey inat na mipuun hi kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Immala boh Moses hi lana ya nan dala nah altar ot iwaghik nan da Aaron, nadan imbabalena ya hi bulwati da. Athituy inat nat miong-ong dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kanan Moses ke da Aaron ya nan imbabalenay “Ie yu nan dotag nah hogpan hi Tabernacle ta iha-ang yu ta kanon yuh di. Ya kanon yu damdama nadan tinapay nah basket an niappit hi numpadiyan yu mipuun hi tugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ya gobhon yun am-in di matdaan an dotag ya tinapay. ");
INSERT INTO ifk_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Adi kayu tumayan hituh pitun algo inggana magibbuy ine-en di pumpadiyan yu. ");
INSERT INTO ifk_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hituwen inat takud uwani ya mipuun hi tugun APU DIOS ta makaan di liwat yu. ");
INSERT INTO ifk_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mahapul nimpen miha-ad kayu nah Tabernacle hi pitun algo ya pitun hilong ta aton yuy tugunat adi kayu mate. Hituwey intugun APU DIOS an kalyok ke dakayun aton yu.” ");
INSERT INTO ifk_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Inun-unud Aaron ya nadan imbabalenan am-in dadiyen tugun APU DIOS an kinalin Moses. ");
INSERT INTO ifk_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Handih nabiggatanah nagibbuwan di natudduwan da Aaron ya nadan linalakin imbabalenan mumpadi ya inayagan Moses dida ya nadan mangipangpanguluh holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Kananan Aaron di “Umala kah hintoon an lakin baka ya hay lakin kalneron maid di dipektonat iappit mun APU DIOS. Hanan hintoonan lakin baka ya miappit gapuh liwat ya nan lakin kalnero ya miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ya kalyom hanadah tatagun mun-appit dah lakin gulding gapuh liwat da, hay hintoon an baka ya kalneron maid di dipekto dat iappit dan maghob, ");
INSERT INTO ifk_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","hay bulug an baka ya hay lakin kalnero ta iappit dah pakihayyupan dan APU DIOS. Ya unnudan da datuwen iappit da hi alinah an naha-adan hi mantekan di oliba. Mahapul an aton nadan tatagu datuwe te mumpatiboh APU DIOS ke didad uwani.” ");
INSERT INTO ifk_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","In-en nadan tatagun nah hinangngab nan Tabernacle dadiyen kinalin Moses ot maamung dan mundayaw ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kanan Moses di “Hituwey kinalin APU DIOS an aton yu ta mumpatibon dakayu nan humilin dayaw na.” ");
INSERT INTO ifk_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kanan Moses ke Aaron di “Eka nah altar ta mun-appit ka gapuh liwat ya mun-appit kah maghob ta makaan di liwat mu ya hay liwat nadan tatagu. Atom hituwe mipuun hi tugun APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ot umeh Aaron nah altar ot kolngona nan hintoonan bakan miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Indawat nadan linalakin imbabalena nan dala ot itdok nay gamat na ot itodtod na nadah nidongdong an dugun nan altar ya induyag nay udum nah puuna. ");
INSERT INTO ifk_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ginhob na kediyen altar nan taba, nadan batin ya kuyaput di alten nan niappit gapuh liwat an inun-unud na nan intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mu nadan dotag ya bolat ya ena ginhob nah e-elen nan kampu. ");
INSERT INTO ifk_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Indani ya kinlong bon Aaron nan aggayam an iappit nan maghob ot idawat nadan linalakin imbabalena nan dalan diyen aggayam ot iwaghik na nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Inohhaohha dan indawat ke hiya nadan dotag an maghob nah altar takon nan ulu. ");
INSERT INTO ifk_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Inulahana nan putu ya nadan huki ot itap-o na nadah maghob ot gobhona nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Nagibbuh diye ot ipresenta na nan gulding an miappit gapuh liwat nadan tatagu ot kolngona, umat hi inat na nah niappit gapuh liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","In-appit nah diyen maghob an inun-unud na nadan maunud hi pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ot ahina ipresenta nan iappit nan pagen gimmamal ot pakighob na nah altar an inid-um na nadah udum an miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Kinlong na nan bulug an baka ya nan lakin kalneron iappit nadan tataguh pakihayyupan dan APU DIOS ot idawat nadan linalakin imbabalena nan dalan dadiye ot iwaghik na nadah dingding nan altar. ");
INSERT INTO ifk_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","21","Intaggena nadan pago ya ulpu ot ipresenta nan APU DIOS, mipuun hi kinalin Moses an atona. Intap-o na ke dadiyen pago nadan taban nan bulug an baka ya lakin kalnero, hay taban di iwit da ya putu da, nadan batin da ya kuyaput di alte da ta maghob nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Nagibbuh diye ot idongdong nay taklena nadah tatagu ot bendisyonana dida ot ahi duma-ul an nalpu nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ot humgop da Aaron ke Moses nah Tabernacle. Limmah-un da ot bendisyonan da nadan tatagu ya numpatiboy humilin dayaw APU DIOS ke didan am-in. ");
INSERT INTO ifk_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Pinghanadi bo ya impaalin APU DIOS di mundadalang an apuy ot gobhonan am-in nadan niappit an maghob ya nadan taba. Handih tinibon nadan tataguh diye ya muntukuk da gapuh anla da ya nunlukbub da nah luta. ");
INSERT INTO ifk_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hanadan duwan linalakin imbabalen Aaron an da Nadab ke Abihu ya inha-ad day bala nah duyun pangighoban hi bangbanglu ot waghikan dah insenso. Uggeda inun-unud di kinalin APU DIOS hi aton dan munggohob hi insenso. ");
INSERT INTO ifk_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kinali maid maptok ya impaalin APU DIOS di apuy ot mate dah hinangngab na. ");
INSERT INTO ifk_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kanan Moses ke Aaron di “Hituwey pinhod APU DIOS an kalyon nah kananay ‘Mahapul an am-in nadan munhilbin ha-on ya inilaon dan ha-oy ya makakkaphodak ya midayawak nadah tataguk.’” Mu pamgan Aaron di op-opya. ");
INSERT INTO ifk_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ot ayagan Moses da Mishael ke Elsaphan an imbabalen Ussiel an amaon Aaron ot kananan diday “Kaanon yuy adol datuwen iiba yu tuh pundayawan ta ie yu dida nah e-elen di kampu.” ");
INSERT INTO ifk_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Immali da ot id-on da nah imbulwati dan bulwatin di padi ot ie da dida nah e-elen di kampun inun-unud day kinalin Moses ke dida. ");
INSERT INTO ifk_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Indani ya kanan Moses ke Aaron ya nadan imbabalenan da Eleasar ke Itamar di “Hugudon yuy buuk yu ya adiyu bik-iyon di bulwati yu ta adiyu ipatibon u-umyung kayu. Te deket ipatibo yun u-umyungan kayu ya mate kayu ya ilagat APU DIOS am-in di holag Israel gapuh boh-ol na. Mu nadan ibba takun holag Israel ya damanan ipatibo dan u-umyung da gapuh natayan datuwen pinaten APU DIOS hi apuy. ");
INSERT INTO ifk_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ya dakayu ke ya adi kayu tumayan hitu te niong-ong kayun pungngunuwon APU DIOS nipalpu handih naha-adan hi lanay ulu yu.” Ot un-unudon dah diyen kinalin Moses. ");
INSERT INTO ifk_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kanan APU DIOS ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Adika mabalin an humgop nah Tabernacle an kawad-ak, takon nadan linalakin imbabalem ten imminum kayuh mainum an bumutong te deket humgop kayu ya mate kayu. Mahapul an un-unudon di holag mut nangamung hituwen olden. ");
INSERT INTO ifk_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mahapul bon inilaon yu hin nganne nadan niong-ong ke ha-on ya hin nganney kiusalan da. Ya mahapul an inilaon yu nadan panio te mibilang dan adi malini ya nadan adi panio ten mibilang dan malini. ");
INSERT INTO ifk_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ya mahapul an ituttudu yun am-in hi holag Israel nadan Tugun kun kinalik ke Moses.” ");
INSERT INTO ifk_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Kanan Moses ke Aaron ya nadah duwan linalakin imbabalenan da Eleasar ke Itamar di “Alan yu nan natdaan an nagiling an bogan niappit ke APU DIOS ta kapyaon yuh tinapay an adi makamhan hi mumpalbag ta kanon yuh paldang nan altar, te niong-ong ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kanon yu datuweh kawad-ana te datuwen makan an niappit ke hiyay bingay yun nadah holag mu. Hituwey tugunan kalyok ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mu damanan kanon yu nadan pago ya ulpun nipresentan APU DIOS nah lugar an mibilang an malini. Dadiyen iappit di ibba yun holag Israel hi pakihayyupan dan APU DIOS ya bingay yun nadah imbabalem. ");
INSERT INTO ifk_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Dadiyen ulpu ya pago ya id-um yu nah taban maghob an miappit ta itagge yun ipresentan APU DIOS. Datuwe ya mibingay ta nangamung ke dakayun nadah holag yu mipuun hi tugun APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Minahmahan Moses di mipanggep nah gulding an miappit gapuh liwat ot inilaonan naghob ya binoh-olana da Eleasar ke Itamar an nabatin imbabalen Aaron. ");
INSERT INTO ifk_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Kananan diday “Tipet uggeyu kinan nah dolan nan Tabernacle hidiyen niappit gapuh liwat? Indat APU DIOS ke dakayu ta iappit yu ta makaan di liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Gulat na ot kuma te uggeyu in-ey dalan nan niappit nah Tabernacle ya kinan yu ot kumah di nah dola. Kon uggek kinalin athidiy aton yu?” ");
INSERT INTO ifk_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Hinumang Aaron hi Moses an kananay “Om, nun-appit nadan linalakin imbabalek ad uwani ke APU DIOS gapuh liwat ya nun-appit dah maghob, mu kon abuluton nin APU DIOS ten kinan mih diyen niappit gapuh liwat? Man-uket uggemi kinan te umagol kami mipanggep nah naat nadah duwan imbabalek.” ");
INSERT INTO ifk_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ya inabulut Moses hidiyen in-esplikar Aaron. ");
INSERT INTO ifk_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kanan APU DIOS ke da Moses ke Aaron di “Kalyon yu ");
INSERT INTO ifk_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","nadah ibbayun holag Israel an datuwen aggayam di mabalin an mihda. ");
INSERT INTO ifk_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hanadan nagodway kukub nan panidwaon dan galgalon di kanon da. ");
INSERT INTO ifk_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Mu adi mabalin an kanon yu nadan kamel, badger ya rabbit. Te man-ut panidwaon dan galgalon di kinan da mu ugge nagodway kukub da. Kinali adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ya adiyu ihday babuy. Te man-ut nagodway kukub da, mu adida panidwaon an galgalon di kanon da. Kinali adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Adiyu ihda ya adiyu dapaon di adol am-in dadiyen aggayam ten nate da te adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ya hi am-in hanadah mataguh danum ya ammuna nadan waday hiphip na ya ipenay mabalin an kanon yu. ");
INSERT INTO ifk_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mu nadan maid di hiphip na ya ipe na ya adiyu kanon. ");
INSERT INTO ifk_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Adi mibilang an malini dadiye. Ya adiyu kanon weno dapaon di naten adol da. ");
INSERT INTO ifk_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ipidwak an kalyon, adi mabalin an kanon yu nadan matagun wadah danum an maid di hiphip na ya ipe na. ");
INSERT INTO ifk_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Datuwe nadan klasen hamutin adiyu kanon: tuldu, akup, gawwang, falcon, kukkuk, hamutin mangan hi nate, butbut, ostrich, seagull, stork, heron, pelican, cormorant, hoopoe, hay panniki ya littalit. ");
INSERT INTO ifk_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Hanadan napayakan umat hi insect an opat di hukinan mungkaddapan ya adiyu kanon te adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mu nadan udum an napayakan an insect an mungkaddapan an nahu-up di huki nat pumaytuk ya damanan kanon yu. ");
INSERT INTO ifk_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Datuwe ya dudun, cricket weno ba-atong. ");
INSERT INTO ifk_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ya nadan udum an man-ut napayakan da mu kumadap da ya adiyu kanon te adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Hay tagu ya mibilang an adi malini inggana hilong ten dapaonay naten adol datuwe. ");
INSERT INTO ifk_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Deket duligon nan taguy adol datuwen naten aggayam ya mahapul an gal-anan balbalan di bulwati na mu munnanong an mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Hanadan naten aggayam an ugge nagodway kukub na ya mibilang dan adi malinit nan tagun manapah adol datuwe ya mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Hanadan naten aggayam an opat di huki dan waday komong da ya mibilang dan adi malinit nan tagun manapah adol datuwe ya mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Deket pinidit nan tagu weno dinlig nay naten adol di aggayam ya mahapul an gal-anan balbalan di bulwatina mu munnanong an mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Am-in di klasen moles, utut, kallulu ya banniya ya mibilang dan adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ya nan tagun manapan dadiye, matagu weno nate ya mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Mibilang bon adi maliniy nganneh diyen kag-ahan di naten adol da, umat hi kaiw, luput, lalat, saku, weno ngannen ngunut an waday kiusalana. Ya kal-ina ket mag-ahan dadiye ya mahapul an mitam-ol dah danum mu mibilang metlaing an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kal-ina ket nag-ay naten adol dah pula an banga ya mibilang an adi malini takon nan nihuduh dit hidiye nan mahapul an puhikon yuh diyen banga. ");
INSERT INTO ifk_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Hanadan makan an naduyagan hi danum an niha-ad kediyen banga ya adiyu kanon te mibilang da mon adi malini. Ya adi mabalin an inumon yu nan danum an niha-ad kediyen banga te mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Takon di pugun an pangapyaan hi tinapay weno banga ya deket nag-ahan hi naten adol dadiye ya mibilang dan adi malini, ta hidiye nan mahapul an pa-iyon yu. ");
INSERT INTO ifk_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mu deket ob-ob weno bubun di nag-ahan di naten adol dadiye ya nanongnan mibilang an malini nan danum mu nan tagun e mangaan ke dadiye ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Mu deket buwan mitanom di nag-ahan hi naten adol dadiye ya nanongnan mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mu deket nitam-ol nan buwa ya nag-ahan hi naten adol dadiye ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Hanan aggayam an mabalin an kanon ya mibilang an adi malini ten nate ta nan tagun manapah naten adol na ya mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Hanan tagun mangan weno mangdon kediye ya mahapul an balbalanay bulwatina mu nanongnan mibilang an adi malini inggana mahilong. ");
INSERT INTO ifk_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","Adi mabalin an kanon yu nadan mumbulluhan weno mungkaddapan nah lutan opat weno dakol di hukina te adida mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Adiyu kanon dadiye ta adi kayu mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Te ha-oy an AP-APU an Dios yu ya makakkaphodak, kinali mahapul an makaphod kayun un-unudon yun am-in dadiyen mipanggep hi malini. ");
INSERT INTO ifk_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ha-oy di AP-APU yun nangipangulun dakayun timmayan ad Egypt ta ha-oy di dayawon yun Dios yu. Ta hidiye nan mahapul an makaphod kayun maid di aton yuh gaga-iho te ha-oy an AP-APU an Dios yu ya makaphodak an abu. ");
INSERT INTO ifk_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Danaey maunud mipanggep hi aggayam, hamuti, nadan matagun wadah danum ya nadan matagun mungkaddapan, mumbulluhan ya mundallanan hi luta. ");
INSERT INTO ifk_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Mahapul an pakatibbon yu hin nganne nadan makan an mibilang an malini ya nadan adi mibilang an malini.” ");
INSERT INTO ifk_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kinalin bon APU DIOS ke Moses di maunud hi puntungawan di babai an kananay ");
INSERT INTO ifk_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Deket numbutyug di babai ya nuntungoh lalaki ya mibilang an adi malinih pitun algo umat nah umaliyan di malpuh adol nah kabulabulan. ");
INSERT INTO ifk_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hanan golang ya mahapul an makugit nah mikawalun algo na. ");
INSERT INTO ifk_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ne mibilang bon adi malinih inana inggana mala-uy himbulan ta tuluy algo gapu nah dalan impakawana nah nuntungawana. Kediye ya adi mabalin an dapaona nadan mausal hi pundayawan ya adi mabalin an humgop hidi inggana magibbuy pangatana nah ine-en di punlini. ");
INSERT INTO ifk_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Deket babaiy intungona ya mibilang an adi malinih duwan lingguwan umat nah umaliyan di malpuh adol na. Ya had-onay duway bulan ta onom di algo ta ahina aton nan ine-en di punlini nah dalan gapuh nuntungawana. ");
INSERT INTO ifk_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Deket nagibbun inat nan babaiy ine-en di punlini nah intungonan babai weno lalaki ya mahapul an ie na on hintoon an kalnero nah padi nah hogpan di Tabernacle ta gobhon dan iappit ke APU DIOS. Ya ie na boy ohan paloma weno balug ta iappit na gapuh liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Alan nan padih diyet iappit nat mibilang mon malini nan babain nuntungo. Datuwey mahapul an un-unudon di nuntungo. ");
INSERT INTO ifk_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mu kal-ina ket nawotwot nan babai ya adina kabaelan di kalnero ya mabalin di duwan balug weno paloma. Hanan oha ya miappit an maghob ya miappit nan oha gapuh liwat na. Deket nagibbun inat nan padih diye ya mibilang mon malini nan babai.” ");
INSERT INTO ifk_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kanan APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Hanan tagun waday mit-an an katatakut an gulidnan linumbag weno mumbobbola ya ie yu nadah padi an hi Aaron ya nadan imbabalena. ");
INSERT INTO ifk_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mahapul an tibon nan padi nan gulid ta deket binumla nan buuk nah bolat an nagulid ya himmalom ya katatakut hidiyen dogo te mit-an ya mahapul an kalyon nan padin mibilang an adi malinih diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mu deket ugge himmalom nan gulid ya ugge binumla nan buuk ya abunay appilon nan padi nan taguh pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Hanah mikapitun algo ya tibon bon nan padih diyen tagut deket ugge nihinap nan gulid na ya appilona pay hi pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ne ahi bo tibon nan padi nah mikapitun algot deket napoy-an ya kalyon nan padin mibilang an malinih diyen tagu te gulid ya abuh diye. Mu mahapul an ibalbal nan taguy bulwati nat ahi mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mu kal-ina ket mibangngad bo nan gulid nat mihinap ya mahapul an mumpatibo bo nah padi. ");
INSERT INTO ifk_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ne tibon bon nan padit deket nihinap ya kalyonan mibilang an adi malini nan tagu ya kalyonan katatakut nan dogona te mit-an. ");
INSERT INTO ifk_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Am-in di tagun waday dogonan gulid an mit-an ya e mumpatibo nah padit ");
INSERT INTO ifk_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","deket tibonat linumbag ya nababla ya binumlay buuk kediye ");
INSERT INTO ifk_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ya hidiyey kitib-anan mit-an hidiyen gulid ta hidiye nan kalyon nan padin mibilang an adi malinih diyen tagu. Adi mahapul an appilonat obserbalona te nunna-ud an mibilang an adi malinih diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Deket tibon nan padin nagoggonnol am-in di adol nan tagu mipalpuh hukina ingganah uluna ");
INSERT INTO ifk_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ya kalyon nan padin mibilang an malinih diyen tagu te nibangngad nan datin ang-ang di bolat na. ");
INSERT INTO ifk_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mu deket waday nabablah bolat nan tagu ya kalyon nan padin mibilang an adi malinih diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mahapul an pinghanadi ya kalyonan adi malini nan taguh panib-anan nababla adol na te hay nababla kitib-anan mit-an hidiyen gulid. ");
INSERT INTO ifk_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mu deket napoy-an nan nababla ot mibangngad nan datin ang-ang nan bolat na ya mahapul an ume nah padi ");
INSERT INTO ifk_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ta tibona bot deket siguladun pinumhod mo nan bolat na ya kalyonan mibilang an malini nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Deket waday tagun napoy-an di poghana ");
INSERT INTO ifk_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mu indani bo ya linumbag ya immingit an waday mabla kediyen tinummolan di poghana ya mahapul an ume bon mumpatibo nah padi. ");
INSERT INTO ifk_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ne tibon nan padit deket himmalom ya binumla nan buuk kediye ya kalyonan mibilang an adi malinih diyen tagu. Te hidiyen dogona ya mit-an. ");
INSERT INTO ifk_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mu deket ugge himmalom nan poghana ot loktat ya nauma ya ugge binumla nan buuk kediye ya mahapul an appilon nan padi nan taguh pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mu deket kediyen pitun algo ya nihinap nan nabablah adol na ya mahapul an kalyon nan padin mibilang an adi malini nan tagu te mit-an nan dogona. ");
INSERT INTO ifk_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mu deket napoy-an ya ugge nihinap ta abunay napiklatan ya kalyon nan padin mibilang an malini mo nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Hanan tagun naatungan an immingit weno binumlay pottok nan naatungan ");
INSERT INTO ifk_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ya mahapul an tibon nan padit binumla key buuk kediyen naatungan ya himmalom ya mibilang an adi malinih diyen tagu te mit-an nan dogona. ");
INSERT INTO ifk_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mu deket ugge himmalom ya ugge binumlay buuk kediye ya mungkibangngad nan datin ang-ang di bolat na ya appilon metlaing nan padih diyen taguh pitun algo ta obserbalona. ");
INSERT INTO ifk_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ne pidwaona bon tibon nah mikapitun algo ta deket mungkihinap bo nan nabablah adol diyen tagu ya kalyonan mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mu deket maid moy nababla, mu abunay piklat nan naatungan an bolat na, hidiyey kitib-anan adi mit-an hidiyen dogo. Ta hidiye nan kalyon nan padin mibilang an malini nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Hanan lalaki weno babain waday nabablah uluna weno pangal na ");
INSERT INTO ifk_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ya mahapul an tibon nan padit deket himmalom ya numbaliw di ang-ang nan buuk kediye ya kalyon nan padin mibilang an adi malini nan tagu te mit-an nan dogona. ");
INSERT INTO ifk_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mu deket tibon nan padi ya adi athidi ya appilonah pitun algot obserbalona. ");
INSERT INTO ifk_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ne tibon bon nan padi nah mikapitun algot deket ugge nihinap ya ugge himmalom ya deket numbaliw di ang-ang di buuk kediye ya ");
INSERT INTO ifk_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","mahapul an mamukmukan nan tagu mu adina labahaon nan buuk nah nababla. Ne appilon nan padih pitu pay an algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ne tibon bon nan padi nah mikapitun algo ta deket ugge nihinap ya ugge himmalom ya kalyonan mibilang an malinih diyen tagu. Ya mahapul an balbalan nan taguy bulwati nat malini. ");
INSERT INTO ifk_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mu kal-ina ket nibangngad bo nan dogonat nihinap ");
INSERT INTO ifk_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ya mahapul an tibon bon nan padi ta kalyonan mibilang an adi malinih diyen tagu ten nihinap nan nababla takon di ugge numbaliw di ang-ang nan buuk kediye. ");
INSERT INTO ifk_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mu deket tibon nan padi ya ugge nihinap te napoy-an ya mammol di buuk kediye ya kalyon nan padin mibilang an malini nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Deket wada day mablah adol di tagu, babai weno lalaki ");
INSERT INTO ifk_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ya mahapul an tibon nan padi ta deket adi umat hi ang-ang di kamanaw ya kalyonan mibilang an malini nan tagu te adi mit-an hidiyen dogo. ");
INSERT INTO ifk_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Deket namukmukan on tagu te naplag di buuk na ya mibilang an malinih diyen tagu. ");
INSERT INTO ifk_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mu deket nawaday ma-maingit ya mablan gulid kediyen naplagan di buuk hi uluna ya mit-an hidiyen dogona. ");
INSERT INTO ifk_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","44","Ne mahapul an tibon nan padih diyen tagut deket waday ma-maingit ya mablan gulid hi uluna ya kalyon nan padin mibilang an adi malinih diyen tagu gapu kediyen mit-an an dogona. ");
INSERT INTO ifk_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Hanan tagun waday dogonan mit-an ya mumbulwatih nabik-i ya adi munhugud ya haniyanay godwan di anganat abunay matana ya tuktuk nan matibo. Ne itkuitkuk nay “Adi malini. Adi malini.” ");
INSERT INTO ifk_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Hanan tagu ya mibilang an adi malini inggana makaan nan mit-an an dogona. Ya mahapul an maappil ta e miha-ad nah e-elen di kampu. ");
INSERT INTO ifk_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","Deket waday tinummol an buut hi bulwatin nakapyah linen weno dutdut di kalnero weno kumpulmin nakapyah lalat ya deket dadiye ya ma-maingit da weno green di kolor da ya dadiye nan mihinap. Kinali mahapul an mipatibo nah padi. ");
INSERT INTO ifk_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Tibon nan padih diye ne indulinah pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Deket nadatngan nan mikapitun algo ya tibona bot deket nihinap dadiye ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ne am-in nadan luput weno lalat an waday athidin nihinap an buut ya mahapul an gobhon nan padi. ");
INSERT INTO ifk_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mu deket tibon nan padi ya ugge nihinap, ");
INSERT INTO ifk_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ipabalbal na nan luput ne indulinah pitu bon algo. ");
INSERT INTO ifk_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ne tibona bot deket ugge numbaliw di kolor na ya takon di ugge nihinap ya mibilang metlaing an adi malini ta hidiye nan mahapul an maghob takon hin kananat hidiyen buut ya wadah indoggan weno hinangngab nan bulwati. ");
INSERT INTO ifk_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mu deket tibon nan padi ya mungkakaan hidiye te nabalbalan ya bik-iyonat kaanonah diye. ");
INSERT INTO ifk_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Mu deket mawada bot mihinap ya mahapul mon gobhon nan kon bulwatin diye. ");
INSERT INTO ifk_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mu deket binalbalan nan tagu ya nakaan nan mangmangitit ya mahapul an ipidwanan ibalbal ta mibilang bon malini. ");
INSERT INTO ifk_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Datuwey mahapul an aton hin buut nan bulwatin nakapyah luput, weno dutdut di kalnero weno kumpulmin nakapyah lalat ta ahi makalin mibilang an malini weno adi.” ");
INSERT INTO ifk_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","2","Kanan APU DIOS ke Moses di “Datuwey un-unudon nan mangat hi ine-en di punlini ten nakaan di dogon di bolat na: Mahapul an mie nah padi nan tagun nakaan hidiyen dogo na. ");
INSERT INTO ifk_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ta ien nan padih diyen tagu nah e-elen di boblet ena pakatibbon hin hiya peman an nakaan nan dogo na. ");
INSERT INTO ifk_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Ne kalyon nan padi nah tagut umialih duwan hamutin miappit, hay kaiw an sedar, hay maka-ingit an tinulid ya nan haping di hissop. ");
INSERT INTO ifk_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ya iolden nan padin kolngon day ohan hamuti nah pulan malukung an naha-adan hi ka-hagob an danum hi ob-ob. ");
INSERT INTO ifk_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ne nan ohan hamuti ya itam-ol nan padi nah dalan nan hamutin naklong ya pakitam-ol nah di nan maka-ingit an tinulid ya nan kaiw an sedar. ");
INSERT INTO ifk_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Hanan dala ya iwaghik na nah mamimpitu nah tagun nakaan di dogona. Ya kalyonan mibilang mon malinih diyen tagu. Ne ipatayap na nan ohan hamuti nah e-elen di boble. ");
INSERT INTO ifk_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ibalbal diyen taguy bulwatina ya labahaonan am-in di buuk hi adol na, takon di emeng na ya buuk nat ahi mun-amo ta mibilang an malini. Ta humgop mo nah kampu mu adi humgop hi bale dah pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Hanah mikapitun algo ya mahapul nimpen labahaonay buuk hi uluna, emeng na, kidena ya am-in di buuk hi adol na ya ibalbal nay bulwatina ya mun-amo ta mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ne hi mikawalun algo ya umiali nan tagu hi duwan hintoon an laki ya laba an impan di kalneron maid di dipektona, hay nahawwal an duwan kilon nagiling an bogan nakamhan hi mantekan di oliba ya hay himbasun namahman mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ne ien nan padi nan tagu ya nadan iappit na nah hogpan nah Tabernacle an kawad-ak an APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Alan nan padiy oha nadah ka-ongal nan lakin kalnero ya himbasun mantekat itagge nat ipresenta nan ha-on ta miappit gapuh bahul. ");
INSERT INTO ifk_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kolngonah diyen aggayam nah pangiklongan hi miappit gapuh liwat ya miappit an maghob. Hidiyen aggayam an miappit gapuh bahul, umat nah miappit gapuh liwat ya midat nadah padi. Hidiyen miappit ya nangilinan. ");
INSERT INTO ifk_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ne umala nan padih dalan diyen aggayam ta ha-adanay wawwan an inga ya am-ama-an di wawwan an takle ya hukin diyen tagut mibilang mon malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Umala bo nan padi nah lanan di olibat iduyag nah iggid an tapayanat ");
INSERT INTO ifk_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","itdok nay wawwan an lodlodongngana ta iwaghik nah mamimpitu nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ya iha-ad nan padi nan natdaan an lanan di oliba ke dadiyen naha-adan hi dalan wawwan an inga, wawwan an am-ama-an di takle ya hukinan tagut mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ya iha-ad bon nan padiy udum kediyen lanan di olibah ulun nan tagut makaan di liwat nat mibilang mon malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Iappit bon nan padi nan miappit gapuh liwat ya atona nan ine-en di punlini nah tagun nakaan di dogona. Deket nagibbu ne kolngona nan miappit an maghob ");
INSERT INTO ifk_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ya id-um na nah bogan miappit nah altar. Atonah diyen ine-en di punlini nah tagu ta mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nawotwot ke nan tagut adina gol-an di duwan lakin ka-ongal nan kalnero ya takon di ohay iali nan miappit gapuh bahul, hay duwan kilon makaphod an alinan naha-adan hi mantekan di oliba ya hay himbasun namahman mantekan di oliba. Hidiyen miappit an kakaanan di liwat nan tagu ya itaggen nan padit ipresentana. ");
INSERT INTO ifk_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Umiali boh diyen tagu hi duwan paloma weno duwan balug ta miappit di oha gapuh liwat na ya nan oha ya miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ya hanah mikawalun algo ya ialin diyen tagu nah padi nadan miappit ta aton da nan ine-en di punlini nah kad-ak an APU DIOS nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ne alan nan padi nan ka-ongal nan kalneron miappit gapuh bahul ya nan mantekan di olibat itagge nan ipresentan ha-on. ");
INSERT INTO ifk_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kolngonah diyen ka-ongal nan kalnero ya umalah dala nat ha-adanay wawwan an ingan nan tagu ya hay am-ama-an di wawwan an taklena ya hukina. ");
INSERT INTO ifk_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Umiduyag bo nan padih lanan di oliba nah iggid an tapayana ");
INSERT INTO ifk_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ne itdok nay wawwan an lodlodongnganat iwaghik nah mamimpituh kawad-ak an APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ne ha-adan nan padih lanan di oliba dadiyen naha-adan hi dalan wawwan an inga, wawwan an am-ama-an di takle ya hukin nan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ne iduyag na nan natdaan an lanah ulun diyen tagut atonay mangat hi ine-en di punlini ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","31","Ne iappit bon nan padiy oha nadah duwan paloma weno balug gapuh liwat nan tagu hin hidiyey kabaelan diyen tagu. Ya naken oha ya miappit an maghob an id-um nan padi nah miappit an boga. Hituwe boy aton nan padih pangatana nah ine-en di punlini nah tagu. ");
INSERT INTO ifk_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Datuwey maunud hi pangatana nah ine-en di punlini nadah nawotwot an waday dogo dan mit-an.” ");
INSERT INTO ifk_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Indani ya kanan bon APU DIOS ke da Moses ke Aaron di, ");
INSERT INTO ifk_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Deket dumatong kayud Kanaan an indat kun pumboblayan yu ya wadaok hi udum an babaley lumuy an mihinap, ");
INSERT INTO ifk_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ta mahapul an ahi ume nan kon bale nah padit kananay ‘Waday lumuy hi balek.’ ");
INSERT INTO ifk_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ahi iolden nan padin milah-un am-in di ngannen wada nah bale ta ahi umen e manibo te mibilang an adi malini nadan nganneh diyen akhupanah din ugge nilah-un. Deket nilah-un am-in ne ahi humgop nan padi nah bale ");
INSERT INTO ifk_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ta tibonah diyen lumuy. Deket waday tibonah ma-maingit weno green an manged dalom hanadah dingding, ");
INSERT INTO ifk_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","lumah-un nan padit idakkig na nan baleh pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ahi mibangngad nah baleh mikapitun algot tibona. Deket mungkihinap hidiyen lumuy ");
INSERT INTO ifk_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ya ioldenan mapokwal nan batun nidingding an waday lumuy nat ena iwele nah e-elen di boblen mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Iolden nan padin gadgadan da nadan dingding ya alan da nadan ginadgad dat eda iwele nah e-elen di boblen mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ya hannotan da nadan napokwal an batu takon nadan nakaan an pumpokot nadah dingding. ");
INSERT INTO ifk_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Deket bumudal bo nan lumuy yaden nagibbun nalinihan ot mahannotan nadan batu ya nan pumpokot ya ");
INSERT INTO ifk_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","e bo tibon nan padi. Deket nihinap nan lumuy ya kalyonan mibilang an adi malini nan bale ");
INSERT INTO ifk_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ta mahapul an pa-iyon da ta ie da nah e-elen nan boblen mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Hanan tagun humgop nah balen nidakkig te mibilang an adi malini ya mibilang bon adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ya nan mibakilang weno mangan hidi nah bale ya mahapul an ibalbal nay bulwatina. ");
INSERT INTO ifk_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mu deket tibon nan padin ugge mo bimmudal di lumuy nah bale ya kalyonan malini nan bale te nakakkaan nan lumuy. ");
INSERT INTO ifk_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mahapul an aton nan kon baley ine-en di punlinin umalah duwan hamuti, hay sedar an kaiw, hay maka-ingit an tinulid ya hay haping di hissop. ");
INSERT INTO ifk_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ya kolngonay oha nadah hamuti nah nitayan pula an malukung an naha-adan hi danum an ka-hagob hi ob-ob. ");
INSERT INTO ifk_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","Ne alana nan sedar an kaiw, nan haping di hissop, nan maka-ingit an tinulid ya nan ohan hamutit itam-ol na dida nah dalan nan naklong an hamutin nakammohan hi danum ta waghikana nan baleh mamimpitu. Deket nagibbun inat nah tuwen ine-en di punlini nah bale ");
INSERT INTO ifk_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ya ipatayap na nan matagun hamuti nah e-elen di boble. Atonah tuwet mibilang bon malini nan bale. ");
INSERT INTO ifk_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Danaey maunud an aton ten mipanggep hi mihinap an buut hi bulwati ya lumuy hi bale, ya mipanggep hi mit-an an dogon di bolat. ");
INSERT INTO ifk_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Mahapul an maunud danae ten mipanggep hi mit-an an dogon di bolat weno lumuy hi bale. Danaey panginilaan nadan tatagu hin mibilang an maliniy nganneh diyen ngunut weno adi.” ");
INSERT INTO ifk_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kanan bon APU DIOS ke da Moses ken Aaron di ");
INSERT INTO ifk_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Kalyon yu nadah ibba yun holag Israel datuwe: Hanan lalakin waday malpuh adol na ya mibilang an adi malini ");
INSERT INTO ifk_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","takon hin kananat mamuddal weno natikod ya mibilang metlaing an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Mibilang bon adi malini nan inumbunana weno nahuyopana. ");
INSERT INTO ifk_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ya nan tagun midatum kediyen kahuyopana ya mahapul an ibalbal nay bulwatina mu mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Hanan tagun umbun nah inumbunan nan lalakin waday malpuh adol na ya mahapul an ibalbal nay bulwatina ya mun-amo, mu nanongnan mibilang an adi malini ingganah hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Athidi bo nah tagun manapa nah lalakin waday malpuh adol nan mahapul an ibalbal nay bulwatina, mu mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Deket tinuppaan nan lalakin waday malpuh adol nay ohan tagu, mahapul an ibalbal diyen taguy bulwatina, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ya nan ubunan diyen lalaki, takon nan ulon miap-ap hi odog di kabayun ubunanan muntakke ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Takon nan tagun manapah inumbunan diyen lalaki ya mahapul an ibalbal nay bulwati na, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Hanan lalakin waday malpuh adol nan uggena inulahan di taklena ya dinapana on tagu ya mahapul an ibalbal nan taguy bulwatina ya mun-amo, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Hanan pulan bangan dapaon diyen lalaki ya mahapul an maphik ya nan kaiw an malukung an dapaona ya mahapul an maulahan. ");
INSERT INTO ifk_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Deket natikod moy malpuh adol diyen lalaki ya pala-uwon nay pitun algot ahina aton nan ine-en di punlini an ibalbal nay bulwatina ya e mun-amo nah ob-ob ta mibilang mon malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Hanah mikawalun algo ya mahapul an umalah duwan paloma weno duwan balug ta ume nah hogpan nah Tabernacle ta idat na nah padi. ");
INSERT INTO ifk_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ne iappit nan padiy oha gapuh liwat ya nan oha ya miappit an maghob. Aton nan padih diyet mibilang an malinih diyen lalaki hi hinangngab ku an AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Deke bot waday malpuh adol nan lalaki ya mahapul an mun-amo, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Takon di ngannen luput weno lalat di naha-adan kediye ya mahapul an mabalbalan, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Deket nunhuyop di lalaki ya babai, mahapul an mun-amo da, mu nanongnan mibilang dan adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Ya deket immaliy binulan an malpuh adol di babai ya mibilang an adi malinih pitun algo. Hanan tagun manapan hiya ya mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ya am-in di kahuyopan nan babai weno ubunana ke dadiyen algo ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Hanan tagun manapah nahuyopan diyen babai ya mahapul an ibalbal nay bulwatina ya mun-amoh mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ya nan manapah ngannen inumbunan diyen babai ya mahapul an ibalbal nay bulwatina ya mun-amo, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Takon hin kananat ubunan weno nahuyopan diyen babaiy dinapan nan tagu ya mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Hanan lalakin makihuyop kediyen babait midatum nah malpuh adol na ya mibilang an adi malinih pitun algo. Takon nan kahuyopan diyen lalaki ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Hanan babain waday malpuh adol nah kaatnan algo, mu bokon hidiye nan binulan ya mibilang an adi malini inggana matikod hidiyen malpuh adol na. ");
INSERT INTO ifk_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Hanan kahuyopana weno inumbunana ya mibilang an adi malini, umat hin waday malpuh adol nah binulan. ");
INSERT INTO ifk_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Hanan tagun manapa kediyen kahuyopana weno inumbunana ya mahapul an ibalbal nay bulwatina ya mun-amo, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Deket natikod nan malpuh adol diyen babai ya bilangonay pitun algot ahi mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Hanah mikawalun algo ya umalah duwan paloma weno duwan ka-ongal nan balug ta iena nah padi nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Miappit nan oha gapuh liwat ya nan oha ya miappit an maghob. Atonah diyet mibilang an malini nan babai hi hinangngab ku an DIOS.” ");
INSERT INTO ifk_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kanan APU DIOS ke Moses di “Datuwey ituttudum ta adi pumbalinon nadan holag Israel di adol dan adi malinit adida hibiton nan Tabernacle an dehdih kad-an dat adida mate. ");
INSERT INTO ifk_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Datuwey ituttudum an un-unudon di lalakin mibilang an adi malini gaput te waday bimmudal an nalpuh adol na, ");
INSERT INTO ifk_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ya hay un-unudon di babaih umaliyan nan binulan an malpuh adol na, hay un-unudon di lalaki weno babain waday malpuh adol da, ya hay un-unudon di lalakin nangihuyop hi babain waday binulan an malpuh adol na.” ");
INSERT INTO ifk_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Handih nate nadan duwan imbabalen Aaron gapuh hinnatkon an ine-en nun-appit da ");
INSERT INTO ifk_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ya kanan APU DIOS ke Moses di “Kalyom ke tulang mun hi Aaron ta adi naala on hinumgop nah Nakassantun Kuwartuk an nahaniyan hi kurtina nah hinangngab nan nahukapan an kahon te mate hin athidiy atona. Man-uke ya wadaak nah kulabut hi tap-on diyen kahon. ");
INSERT INTO ifk_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Kinali, deket humgop hi Aaron hidi ya hay mamangulun atona ya mahapul an waday iappit nah hintoon an bakan miappit gapuh liwat ya ohan lakin kalneron miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Mahapul an mun-amo ya ibulwatinay bulwatin di padi ya nan miodda. Ya mahapul an balkowanay gitang na ya mumpongot. Danae nadan niong-ong an bulwatina. ");
INSERT INTO ifk_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ne hanada ken holag Israel ya iali dan hiyay duwan lakin gulding ta miappit gapuh liwat ya hay ohan lakin kalneron miappit an maghob. ");
INSERT INTO ifk_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Iappit Aaron hidiyen lakin baka gapuh liwat na ya liwat di pamilyana. ");
INSERT INTO ifk_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ya iali nay duwan gulding ta ipresentanan ha-on an APU DIOS nah hogpan nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ne ibunut na ten ngannen dadiyen duwan gulding di iappit na weno ipaena. ");
INSERT INTO ifk_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Iappit Aaron ke ha-on an APU DIOS nan mabunut an miappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ya nan gulding an mabunut an mipae ya ipresentanan ha-on an APU DIOS ne ipaena nah adi maboblayan ta kitib-anan nakaan di liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Iappit Aaron nan lakin baka gapuh liwat na ya liwat di pamilyana. ");
INSERT INTO ifk_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ya alana nan punggohoban hi bangbanglun naha-adan hi balan nalpu nah altar hi hinangngab ku an DIOS, ne umalah duwan gamal nah nagudun bangbanglu ya hinumgop nah nakurtinaan an kuwartun kawad-ak ");
INSERT INTO ifk_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ne iha-ad nah diyen bangbanglun insenso nah bala. Ya nan tumap-on ahuk ya haniyana nan hukap nan kahon. Deket un-unudon Aaron datuwe ten humgop ya adi mate. ");
INSERT INTO ifk_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Hay oha bon atona ya itdok nay gamat na nah dalan nan lakin bakat iwaghik na kediyen hukap ya nah kahon hi mamimpitu. ");
INSERT INTO ifk_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ne kolngona nan gulding an miappit gapuh liwat nadan tatagu. Ya ihgop nay dalan diye nah kuwartun nakurtinaan ta waghikana nan hukap nan kahon ya hay hinangngab diyen kahon hi mamimpitu, umat hi inat nah dalan nan baka. ");
INSERT INTO ifk_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Aton nan padin hi Aaron hidiye nah Nakassantun Kuwartuk an APU DIOS ya nan Tabernacle ta atona nan ine-en di punlini. Man-uket aton Aaron hidiye ya gapuh liwat ya ngohen nadan holag Israel ke APU DIOS ");
INSERT INTO ifk_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Deket hinumgop hi Aaron nah Tabernacle an mun-appit nah Kuwartuk ta makaan di liwat na, hay liwat di pamilya na ya hay liwat nadan holag Israel ya adi mabalin an waday humgop hidi. ");
INSERT INTO ifk_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ne lumah-un hi Aaron ta ena aton di ine-en di punlini nah altar an umalah dalan nan lakin baka ya gulding ta ha-adana nadan nidongdong an dugun diyen pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ya itam-ol nay gamat na nah dalan dadiyen aggayam ta waghikanah diyen pun-appitan hi mamimpitu ta makaan di liwat nadan holag Israel ta mibilang an malinih diyen altar an umat handi. ");
INSERT INTO ifk_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Nagibbu ken inat nah diye nah Kuwartuk an APU DIOS, nan Tabernacle ya nan pun-appitan ya ihgop na nan matagun gulding. ");
INSERT INTO ifk_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","22","Ne ihakmo nay duwan takle nah ulun diyen gulding ya kalyonan am-in di nunliwatan nadan holag Israel ta kay na it-an kediyen gulding. Ne idawat na nah natuddun tagun mangipae nah adi maboblayan ta ien diyen gulding am-in di liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Hanah hogpan bon Aaron nah Tabernacle ya kaanona nan imbulwatinan hinumgop nah Kuwartuk an APU DIOS ta iha-ad nah di. ");
INSERT INTO ifk_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Mahapul an mun-amo nah nangilinan an pun-amohan, ne imbulwatina nan datin bulwati nat lumah-un, ta mun-appit hi maghob an dadiye nan iappit na ya iappit nadan tatagu. Ketuwen atona ya makaan di liwat na ya hay liwat nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ne gobhona nah altar am-in di taban dadiyen aggayam an niappit gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Hanan tagun nangipae nah gulding nah adi maboblayan ya mahapul an ibalbal nay bulwatina ya mun-amoh nangilinan an danum ta ahi mibangngad nah kampu. ");
INSERT INTO ifk_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Hanan lakin baka ya gulding an niappit gapuh liwat an kon dala nah ihgop Aaron nah Kuwartuk an APU DIOS ta makaan di liwat nadan holag Israel ya milah-un dah e-elen di kampu da ta maghob hidi. Makighob di bolat da diyen aggayam, hay laman da ya putu da. ");
INSERT INTO ifk_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ya nan tagun munggohob ke dadiye ya mahapul an ibalbal nay bulwatina ya mun-amo nah nangilinan an danum ta ahi mibangngad nah kampu. ");
INSERT INTO ifk_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hituwey tugun an maunud ta nangamung: Am-in kayun holag Israel, takon nadan nakiboblen dakayu ya tumungo kayun adi kayu mungngunu ya muntopol kayun adi kayu mangan nah mikapulun algoh mikapitun bulan. ");
INSERT INTO ifk_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Kediyen algoy pangatan yu nah ine-en di kakaanan di liwat yu ta malini kayuh hinangngab ku an AP-APU ");
INSERT INTO ifk_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hidiyen algoy makalin Sabadun Tungon pun-iyatuwan yu ya puntopolan yun adi kayu mangan. Mahapul an maunud ta nangamung hituwen Tugun. ");
INSERT INTO ifk_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Hay ahi mangiat ketuwen ine-en di kakaanan di liwat yu ya nan holag Aaron an natuddun katagtag-ayan an padi. Ibulwati na nan bulwatin di padit ");
INSERT INTO ifk_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","atona nan ine-en di punlini nah Kuwartuk an APU DIOS, nan Tabernacle ya nan altar. Ya atona nan ine-en di kakaanan di liwat nadan padi ya am-in kayun holag Israel takon nadan nakiboblen dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Maunud ta nangamung hituwen tugun mipanggep hi ine-en di kakaanan di liwat yun holag Israel. Maminghan an maat hituwe hintoon.” Inun-unud Moses am-in datuwen tugun an kinalin APU DIOS ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Kalyom ke Aaron, nadah imbabalena ya nadah holag Israel hituwen mahapul an un-unudon da. ");
INSERT INTO ifk_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","‘Deket mun-appit di holag Israel hi lakin baka, hay impan di kalnero weno hay gulding nah kampu weno hi e-elena ya mibilang an nunliwat hidiyen tagu ten bokon nah hogpan hi Tabernacle di pun-appitanat ipresentanan iappit ke APU DIOS. Ta gapun diye ya adi mo makid-um hi tatagun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Man-uket wadah tuwen tugun ya ta ialin nadan holag Israel ke APU DIOS nadan eda ianappit hi kumpulnan lugar. Mahapul nimpen iali da dadiyen iappit nan APU DIOS nah padi nah hogpan hi Tabernacle ta iappit nan pakihayyupan dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Iwaghik nan padiy dalan nan aggayam nah altar ya gobhona nan taba te pinpinhod APU DIOS di hamuy na. ");
INSERT INTO ifk_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Mahapul an itikod nadan holag Israel an mun-appit nadah dimonyo ta iohha dan APU DIOS di pundayaw da. Ya mahapul an un-unudon dat nangamung hituwen tuguna.’” ");
INSERT INTO ifk_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kalyom bon didah tuwe: “Hanan holag Israel weno hintaguwan an nakiboblen man-ut mun-appit ke APU DIOS hi maghob, ");
INSERT INTO ifk_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mu adina iali nah hogpan nah Tabernacle ya adi mo makid-um hi tatagun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ya deket kanon nan holag Israel weno dahdin nakiboble nan aggayam an ugge nakaan di dalana ya adi mo mibilang an tagun APU DIOS ya adi mo makid-um hanadah tataguna. ");
INSERT INTO ifk_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Te hay dalay kawad-an di biyag, kinali iolden APU DIOS an mie nah altar nan dala ta makaan di liwat di tagu. ");
INSERT INTO ifk_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kinali intugun APU DIOS an adi mabalin an ihdan di holag Israel ya nadan nakiboblen diday dotag di aggayam an ugge nakaan di dalana. ");
INSERT INTO ifk_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Hanan tagun mampap hi aggayam weno hamutin mabalin an mihda ya mahapul an ipatodtod nay dalana ne tinab-unanah luta. ");
INSERT INTO ifk_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Hay biyag di aggayam ya wadah dalana. Kinali intugun nimpen APU DIOS nadah holag Israel an adida kanon weno inumon di dalan di aggayam ya hamuti. Ta hidiye nan deket adi un-unudon nan tagu ya adi makid-um hi tatagun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Hanan tagun mangan hi dotag di aggayam an nate weno pinaten di mailom an aggayam ya mahapul an ibalbal nay bulwatina ya mun-amo, mu nanongnan mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Deket adina un-unudon hituwe ya makastigu.” ");
INSERT INTO ifk_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","2","Kanan APU DIOS ke Moses di “Kalyom hanadah holag Israel hituwe: Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Adiyu iun-unud hi pangi-en nadan tatagud Egypt an numboblayan yu handi. Ya adiyu iun-unud hi pangi-en nadan iKanaan an numboble nah boblen pangiayak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Aton yuy pinhod ku ya un-unudon yuy tugun ku. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Deket un-unudon yuy tugun ku ya maphod di kitaguwan yu gapuh pangatan yun dadiye. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Datuwey tugun kun maunud. Adiyu ihuyop di iiba yu. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Adiyu ihuyop hi inayu ta eyu babainon hi amayu. Nomnomon yu an hi inayuh diye. ");
INSERT INTO ifk_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ya adiyu ihuyop di dahdin inayan amayu. ");
INSERT INTO ifk_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Adiyu ihuyop di tulang yun babain imbabalen amayuh hinnatkon an babai weno imbabalen inayuh hinnatkon an lalaki takon hin ugge nitungoh nunhituwan yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Adiyu ihuyop di inap-apuyun babai, te kibabainan yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Adiyu ihuyop di imbintan amayu te tulang yuh diye. ");
INSERT INTO ifk_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Adiyu ihuyop di babain tulang amayu weno tulang inayu te iban amayu ke inayu dida. ");
INSERT INTO ifk_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Adiyu ihuyop di inayan di tulang amayu ya tulang inayu ta adiyu babainon dida te ammodon yu dida. ");
INSERT INTO ifk_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Adiyu ihuyop di inapu yun babai, te inayan di imbabale yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Adiyu ihuyop di inayan di tulang yu ta adiyu babainon di tulang yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Adiyu ihuyop di hin-ina. Ya adiyu ihuyop di inap-apuna te gaga-iho. ");
INSERT INTO ifk_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Adiyu iiney tulang di inayan yu ten matagu nan inayan yu. ");
INSERT INTO ifk_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Adiyu ihuyop di babain waday malpuh adol na te hiya ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Adiyu ihuyop di inayan di hinag-on yu te mibilang kayun adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ya adiyu iabulut an miappit di imbabale yu ke Molek te babainon yuy ngadan ku. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Adi mabalin an ihuyop di lalakiy ibbanan lalaki te gaga-ihon abuh diye. ");
INSERT INTO ifk_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Adi mabalin an ihuyop di babai weno lalakiy aggayam te mibilang an adi maliniy ohan tagun mangat hi athidi ya himpappangeh tuwen aton di ohan tagu. ");
INSERT INTO ifk_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Adiyu aton dadiye ta adi kayu mibilang an adi malini te athidiy inainat nadan tatagu nadah boblen pangiayak ke dakayu. Nibilang dan adi malini, kinali dog-alok dida. ");
INSERT INTO ifk_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ta gapun dadiyen inat da ya numbalin an adi malini nan boble dat hidiye nan kastiguwok didat makaan dahdi. ");
INSERT INTO ifk_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mu dakayu, takon nadan nakiboblen dakayu ya mahapul an un-unudon yuy tugun kut adiyu aton datuwen gaga-iho. ");
INSERT INTO ifk_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Handidan numbobleh di ya inat da nimpen am-in dadiyen umipaboh-ol ot mumbalin di boble dan adi malini. Mu dakayu ya nadan nakiboblen dakayu ya adinadaman eyu aton dadiye. Mahapul an un-unudon yuy tugun ku. ");
INSERT INTO ifk_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Deket aton yu damdama dadiye ya balawon dakayu nah luta umat nadah numbobleh din balawon nan numboblayan da dida. ");
INSERT INTO ifk_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Deket wadan dakayun holag Israel di mangat hi athidi ya adi mo makid-um hi tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Un-unudon yuy tugun ku ya adiyu un-unudon di aton nadan tatagun numboble nah pangayan yun eyu pumboblayan ta adi kayu mibilang an adi malini. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Kanan bon APU DIOS ke Moses di “Kalyom hituwen itugun ku nadah ibbam an holag Israel: Mahapul an makaphod kayun maid di aton yuh gaga-iho te ha-oy an AP-APU an Dios yu ya makaphodak an abu. ");
INSERT INTO ifk_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Mahapul an lispituwon yuy ama yu ya ina yu. Mahapul an un-unudon yuy ine-en di Sabadun Tungo. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Adiyu dayawon di udum an dios. Ya adi kayu mangapyah gumok an dayawon yun dios. Ha-oy di AP-APU an Dios yu! ");
INSERT INTO ifk_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Deket mun-appit kayuh aggayam an pakihayyupan yun ha-on an Dios ya mahapul an un-unudon yuy intugun kun aton yu mipanggep kediye ta abulutok. ");
INSERT INTO ifk_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ya mahapul an kanon yuy dotag na kediyen algon naklongana weno hi kabigatana. Deket waday matdaan nah mikatlun algo ya gobhon yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Deket waday mangan kediye nah mikatlun algo ya adik mo abuluton hidiyen miappit te mibilang an adi mo malini. ");
INSERT INTO ifk_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ya nan tagun mangan kediye ya munliwat ke ha-on te uggena linispitu nan niong-ong ke ha-on. Ta adi mo makid-um hanadah tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Deket mun-ani kayu ya adiyu pakiani nadan nungkipingngit ya adi kayu mibangngad ta eyu pakaanniyon di uggeyu inani. ");
INSERT INTO ifk_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Athidi bo nah grapes an adi kayu mibangngad ta eyu alimahmahon di uggeyu pinlag. Ibati yu dadiye ta waday alan nadan nawotwot ya nadan nakiboblen dakayu. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Adi kayu mangako. Adi kayu humaul. Adiyu kalyon di adi makulug. ");
INSERT INTO ifk_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Adiyu isapatah ngadan ku hin nomnomnomon yun adiyu paannungon hidiyen insapata yu te mibabain di ngadan ku. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Adiyu pangal-an di ibba yun tagu ya adiyu pulhon di limmun di hintaguwan an immalih boble yu. Adiyu bo nguddanon an adi idat am-in di tinangdan di impungngunu yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Adiyu kalyon di gaga-iho nah nalulok an tagu ya adiyu e iha-ad di kahalapdungan nan nakulap an tagut mihubag. Hidiyey pangipatibo yun lispituwonak an Dios yu. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Mahapul an limpiyuy pangipanu yuh kasu ta adiyu ipahhig di bahul hi nawotwot weno hi kadangyan. ");
INSERT INTO ifk_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Adiyu ihinap di langkak an istorya mipanggep hi ohan tagu. Adiyu aton di humlun an katayan di ohan tagu. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Adiyu punnanongon di hingit yuh dahdin ibayu. Deket waday nunhallaan yu ya ihummangan yu ta adi kayu munliwat gapun diye. ");
INSERT INTO ifk_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Adiyu nomnomon an ibalo hin waday ad-adih inat di ohan tagun dakayu, weno eyu punnanongon di hingit yu nah tagun nangat hi ad-adin dakayu, mu pinhodon yuh diyen tagu umat hi pamhod yuh adol yu. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Un-unudon yuy tugun ku. Adiyu ipamayay ohan aggayam hi hinnatkon an klasen aggayam. Adiyu itanom hi payo yuy duwan klasen nitanom. Ya adiyu ibulwatiy nakapyah duwan klase. ");
INSERT INTO ifk_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Hanan himbut an iinen di ohan lalaki mu ugge naliblih kinahimbut na te ugge nabayadan ya deket waday ohan lalakin mangihuyop ke hiya ya makastigu dan duwa, mu adida mipipate te ugge naliblih diyen babaih kinahimbut na. ");
INSERT INTO ifk_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hanan lalakin nangihuyop ke hiya ya mahapul an umieh moltanan lakin kalnero nah hogpan hi Tabernacle ta iappit nan ha-on. ");
INSERT INTO ifk_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ya hidiyey pangiatan nan padih ine-en di kakaanan di liwat diyen tagu ta kal-iwak di liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Deket ume kayud Kanaan ta muntanom kayuh bungbunga-an ya adiyu kanon di bunga dah tulun toon te panio. ");
INSERT INTO ifk_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ya iappit yun ha-on am-in di bunga da nah mikap-at an toon ta pangipatibo yuh pundayaw yun ha-on an AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Hanah mikaliman toon ya damanan kanon yu. Deket un-unudon yu datuwe ya dumakkol an dumakkol di ibungan di intanom yu. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Adiyu kanon di dotag an ugge nakaan di dalana. Adi kayu mun-agba weno mun-ayak. ");
INSERT INTO ifk_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Adiyu pu-litan di buuk hi numbinah-el di uluyu ya adiyu pututan di emeng yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Adiyu batokan di adol yu weno eyu liputan ta pangipatibo yun u-umyung kayu gapu nah nate. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Adiyu iabulut di binabain imbabale yun mumpabayad hi adol dah linalaki te kediye ya ibabain yu dida. Te loktat ta dumakol di mumpabayad hi adol dat mumbalin nan boble yuh gaga-ihon pumboblayan. ");
INSERT INTO ifk_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Aton yuy ine-en di Sabadun Tungo ya lispituwon yu nan balek an pundayawan ke ha-on. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Adi kayu mumpabaddang hi kumpulnan tagun hay kalpuwan di kabaelan da ya bokon hi APU DIOS, mu nadan udum an linnawa. Te deket aton yuy athidi ya mibilang kayun adi malini. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Lispituwon yuy aam-ama ya iin-ina! Ya un-unudonak ke dakayu. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Adiyu aton di gaga-iho nadah tatagun nakiboblen dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Aton yun diday umat hi aton yuh ibbayun holag Israel. Nomnomon yun nakiboble kayu damdamad Egypt handi. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Adiyu talamon di ibba yuh eyu pangusalan hi adi ustun pungkilo, hay punlukud ya hay pumbilang. ");
INSERT INTO ifk_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hay ustun pungkiloy usalon yu, hay ustun punlukud ya hay ustun pumbilang di usalon yu. Ha-oy di AP-APU an Dios yun nangipangulun dakayun timmayan ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Un-unudon yun am-in di tugun ku ya olden ku. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Itugun mu nadah holag Israel an kanam di: ‘Hituwey kanan APU DIOS: Mahapul an matugmilan ta mate nan holag Israel weno hintaguwan an nakiboblen dakayu ten idat nay imbabalenan maghob an miappit nah dios an hi Molek. ");
INSERT INTO ifk_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Iwalong kuy tagun mangat ketuwe ya adi mo mibilang an makid-um hanadah tataguk te pumbalinonan adi maliniy balek ya ibabainay ngadan ku. ");
INSERT INTO ifk_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ya deket baybay-an nadan bimmobleh diyen inat nat adida patayon ");
INSERT INTO ifk_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ya ha-oy mismuy mangiwalong kediyen tagu, nadan pamilyana ya nadan ibbanan mundaydayaw ke Molek ta adida mo makid-um hanadah tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Deket waday ohan tagun mumpabaddang ya mangun-unud hi kalyon nadan tatagun makihummangan hi linnawan di nate ya iwalong kut adi mo makid-um hanadah tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Tatagu dakayun ha-on, kinali tibon yu ta hay maphod di aton yu, ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Un-unudon yuy tugun ku, te ha-oy di APU DIOS ya pumbalinon dakayun makaphod. ");
INSERT INTO ifk_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Hanan tagun idutanay ammod na ya makastiguh kate te hidiyey kastigun di bahul na. ");
INSERT INTO ifk_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Deket ihuyop di ohan lalakiy inayan di ohan tagu ya hay kastigun diyen lalaki, takon nan babain inhuyop na, ya kate. ");
INSERT INTO ifk_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Hanan lalakin inhuyop nay inayan amana ya imbabainah amana. Hay kastigu dan duwa nah babain inhuyop na ya kate. Dida pey kon bahul hi katayan da. ");
INSERT INTO ifk_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Hay kastigun di ohan lalakin mangihuyop hi inayan di imbabalena ya kate. Takon nan babain inhuyop na ya mate damdama. Gaga-ihon abuy inat dan hidiyey gapunan mahapul an mate da. ");
INSERT INTO ifk_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Hay kastigun di lalakin ihuyop nay ibbanan lalaki ya kate. Athidi damdamay kastigun nan lalakin inhuyop na. Himpappangeh diyen inat da, kinali dida pey kon bahul hi katayan da. ");
INSERT INTO ifk_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Deket inahawan di lalakiy hin-ina ya makastigu dan tuluh kate ta maghob da gapun diyen kababain an inat da. Adi mabalin an waday mangat hi athidi ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Hanan lalakin ihuyop nay aggayam ya mahapul an makastiguh kate. Takon nan aggayam ya mahapul damdaman patayon yu. ");
INSERT INTO ifk_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Deket ihuyop di ohan babaiy ohan aggayam ya mahapul an patayon yu didan duwa. Hanan babai pey kon bahul hi katayan da. ");
INSERT INTO ifk_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Hanan lalakin iine nay tulang na weno imbintan amana weno hi inana ya ba-inan yu didah kadaklan di tagu ya dog-alon yu didat adida makiboblen dakayu. Holtapon day kastigu da te inhuyop day tulang da. ");
INSERT INTO ifk_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Hanan lalakin ihuyop nay babain waday malpuh adol na ya madog-al dan duwat adida makiboblen dakayu te uggeda inun-unud nan ine-en di punlini. ");
INSERT INTO ifk_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Hanan lalakin ihuyop nay tulang inana weno tulang amana ya makastigu takon nan babai te imbahho day tugun an maunud mipanggep hi ine-en di punhintutulangan. ");
INSERT INTO ifk_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Hanan lalakin ihuyop nay inayan nan tulang amana ya numbahul nah tulang amana. Ya makastigu nan lalaki takon nan babai ta mate dan maid di imbabale da te diday pey kon bahul. ");
INSERT INTO ifk_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Hanan lalakin pulhonay inayan di tulang na ya mibilang an adi malinih diyen inat na te uggena linispituh tulang na. Kinali maidutan dat adida pakaimbabale. ");
INSERT INTO ifk_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Un-unudon yun am-in di tugun ku ya olden ku te deket adiyu un-unudon ya madog-al kayu nah boblen pangipaayak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ya adiyu iun-unud hi pangi-en nadan numbobleh di. Man-uket dog-alok dida ya at-atton da nadan himpappangen gaga-iho ot paboh-olonak ke dida. ");
INSERT INTO ifk_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mu dakayu ke ya kinalik tuwali handin idat kun dakayuh tuwen lutan maluwab di mitanom ta pumboblayan yu. Ha-oy di AP-APU an Dios yu ya dakayuy pinilik an tataguk hi am-in an tagu tuh luta. ");
INSERT INTO ifk_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kinali, mahapul an pakatibbon yu hin nganne nadah aggayam weno hamutiy mibilang an malini weno adi malini. Adiyu nimpe kanon di aggayam weno hamutin mibilang an adi malini. Ha-oy di nangalin adi malini dadiye. Ta hidiye nan deket kanon yu dadiye ya mibilang kayu bon adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mahapul an makaphod kayu te ha-oy an hi APU DIOS ya makaphodak an abu. Ha-oy di namili ke dakayun tataguk hi am-in an tatagu tuh luta. ");
INSERT INTO ifk_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Hanan lalaki weno babain makihummangan hi linnawan di nate ya matugmilan ta mate te hiya pey kon bahul.’” ");
INSERT INTO ifk_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kanan APU DIOS ke Moses di “Kalyom hanadah padin imbabalen Aaron hituwe: Adida nadaman maki-at di padi nah pangat hi naten iiba ta adida mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Mu deket natey inana, amana, imbabalenan lalaki weno babai, tulang nan lalaki weno ");
INSERT INTO ifk_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hay ugge nalahin an tulang nan babain makiha-ad ke hiyah balena ya damanan maki-at nah pangat hi nate. ");
INSERT INTO ifk_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Mu adi maki-at hi pangat hi nate hin nakiapu nah nate te mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Adinadaman mukmukan di padiy uluna weno ena puttutan di emeng na weno ena liputan di adol na. ");
INSERT INTO ifk_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mahapul an makaphod di padi ta adina ibabain di ngadan APU DIOS te iappit nay maghob an makan ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ya adi mabalin an iinen di padiy babain mumpabayad hi adol nah linalaki weno babain inhuyop di lalaki weno nakibolhe. Man-uke ya mahapul an hanada ken padi ya makaphod da. ");
INSERT INTO ifk_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mahapul an makaphod di pangibilang di tatagu nadah padi te hiyay mangiappit hi makan ke APU DIOS. Hi APU DIOS ya makaphod an abu, pumbalinonay tatagunan makaphod. ");
INSERT INTO ifk_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Deket pabayad nan babain imbabalen di padiy adol nah linalaki ya mahapul an gobhon dan matagu te ibabainah amana. ");
INSERT INTO ifk_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Hanan katagtag-ayan an padi ya naduyagan di ulunah lana handih numpadiyana ot miong-ong ke APU DIOS ot ibulwatinay bulwatin di padi. Hiya ya takon di u-umyungan ya hugudonay buuk na ya adina bik-iyon di bulwatina. ");
INSERT INTO ifk_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","Hiya ya niong-ong ke APU DIOS, ta hidiye nan adi mabalin an taynana nan Tabernacle an kawad-ana ta umeh kad-an di naten tagu, takon hin kananat hi amana weno inana te gapun diye ya hibitona nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Mahapul nimpen hay iinen di padi ya nan babain maid di nangihuyop ke hiya ");
INSERT INTO ifk_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ya ohan puun di nahlagan da. Adi mabalin an iine nay nabalu, nibolhe, ya nan babain pabayad nay adol nah linalaki. ");
INSERT INTO ifk_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Man-uke ya mahapul an mibilang an maliniy iimbabalena. Kanan APU DIOS di ‘Ha-oy di AP-APU an namili ke hiyan miong-ong an makaphod.’” ");
INSERT INTO ifk_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Kalyom ke Aaron hituwe: Maid nadah imbabalem an waday dipekton di adol day ahi mumpadin mangiappit hi makan ke APU DIOS. Hituwen tugun ya mahapul an maunud ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Adi mabalin an mih-up ke APU DIOS nadan tatagun waday dipekton di adol da, umat hi nakulap, napilay, nadahuy, ");
INSERT INTO ifk_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","naik-ik di taklena weno hukina, ");
INSERT INTO ifk_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","nabakug, ittaittay di kataguna, waday dipekton di matana, waday nabablah adol na ya nadadag di batbatuna. ");
INSERT INTO ifk_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Maid nimpe nadah holag Aaron an waday dipektonay mun-appit ke APU DIOS hi makan. ");
INSERT INTO ifk_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mu damanan kanona nadan makan an niappit ya nadan makan an mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Muden adi mabalin an e mih-up nah nakurtinaan weno e mih-up nah altar te hibitona dadiyen ngunut, te kanan APU DIOS di ‘Ha-oy di nangiong-ong ke dadiye ot mumbalin dan makaphod.’” ");
INSERT INTO ifk_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Danaey kinalin Moses ke Aaron, nadan imbabalena ya am-in hanadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Kalyom ke Aaron ya nadan linalakin imbabalenah tuwe: Lispituwon yu nadan iappit di holag Israel ke ha-on ta adiyu ibabain di ngadan ku an DIOS. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Deket wada nadah holag muy mibilang an adi malini yaden e nih-up nadah in-appit di ibbayun holag Israel ke ha-on ya adi mo mabalin an e munhilbi nah altar gapun diye. Hituwen tugun ya maunud ta nangamung. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Maid bo nadah holag Aaron an waday dogon di bolat dan mit-an weno waday malpuh adol day mabalin an mangan hanadah miappit ke ha-on inggana mibilang dan malini. Mibilang an adi malini nan padi ten dapaonay adol di naten tagun waday bimmuddal an malpuh adol na, ");
INSERT INTO ifk_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","waday dinapanan aggayam weno tagun mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ya mibilang an adi malini nan padi inggana hilong ya adi mabalin an kuman hanadah niappit ke ha-on inggana mun-amo. ");
INSERT INTO ifk_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Deket nalimuy algo ya mibilang mon malini ta mabalin an mangan hanadah niappit ke ha-on an dadiye tuwaliy kanon da. ");
INSERT INTO ifk_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Adi mabalin an kanon day dotag di naten aggayam weno pinaten di mailom an aggayam te mibilang an adi malini dadiye. ");
INSERT INTO ifk_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Mahapul an un-unudon am-in di padi nadan tugun ku te makastigu dat mate da hin adida un-unudon. Ha-oy di AP-APU an namili ke didan miong-ong an makaphod. ");
INSERT INTO ifk_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Abuna nadan pamilyan di padin mangan hanadah niappit ke ha-on, maid di udum. Takon nadan makiha-ad ke dida ya adi mabalin an kanon da dadiye. ");
INSERT INTO ifk_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mu nan muttatyun ginatang nan padin pihhunay nangatang na weno nan muttatyun nitungoh nunhituwana ya damanan makikan dan diye. ");
INSERT INTO ifk_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Hanan babain imbabalen di padin in-inenay bokon padi ya adi mabalin an makikan kediye. ");
INSERT INTO ifk_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mu deket nabalu nan babain imbabalen di padi weno nibolhe ya maid di imbabalena ot mibangngad an miha-ad hi balen amana ya damanan makikan nah midat ke amanan makan. Adi mabalin an kumpulmin taguy mangan kediye, abuna nimpey pamilyan di padi. ");
INSERT INTO ifk_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Hanan tagun ugge nibilang hi pamilyan di padi yaden kinanah diye, mu uggena ingnguddan ya mahapul an bayadana ya udmanah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Adi mabalin an ibabain di padiy iappit nadan holag Israel ");
INSERT INTO ifk_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","hi pangiabulutanan kanon di kumpulmin taguh diye. Maliwat hidiyen tagu, ta hidiye nan mahapul an makastigu. Ha-oy di AP-APU an mangalin niong-ong nan makan ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Kalyom ke Aaron ya nadah linalakin imbabalena ya am-in hanadah holag Israel hituwe: Deket mun-appit hi maghob nan holag Israel weno bokon holag Israel an nakiboblen dida hi pangipaannunganah insapatana weno ingnguddana pen mun-appit ");
INSERT INTO ifk_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ya mahapul an maid di dipekton nan lakin baka, kalnero weno gulding an iappit na. Abulutok nan iappit na hin laki ya maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Adik abuluton di iappit nan tagu hin waday dipekton nan aggayam. ");
INSERT INTO ifk_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Athidi bo nah miappit hi pakihayyupana ke ha-on weno miappit hi pangipaannunganah insapata weno minguddan an miappit an mahapul an maid di dipekton nan aggayam ta abulutok. ");
INSERT INTO ifk_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Adiyu iappit ke ha-on an Dios di aggayam an nakulap, napilay, naliputan weno waday gudgud weno nabablay adol na. Ya adiyu iabulut an miappit di athidi ke ha-on an Dios nah altar. ");
INSERT INTO ifk_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Mabalin an abulutok di aggayam an nahuti weno waday dipektona hin minguddan an miappit. Mu adi mabalin an miappit hi pangipaannungan hi nisapatan aton. ");
INSERT INTO ifk_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Adi bo mabalin an iappit yun ha-on di aggayam an nakapun, napdit weno naliputan weno nagogod ot makaan di batbatuna. Adi miabulut di athidih tuh boble yu. ");
INSERT INTO ifk_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ya adiyu iappit di athidin aggayam an ginatang yuh hintaguwan. Adik abuluton di athidin aggayam te mibilang an waday dipektona. ");
INSERT INTO ifk_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Deket niimpay baka, kalnero, weno gulding, ya adi mabalin an appilon nah inana inggana mala-uy pitun algo. Nala-u key pitun algo ya damanan miappit an maghob hidiyen impana. ");
INSERT INTO ifk_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Adi mabalin an iappit yuy hin-inan baka weno kalneroh ohan algo. ");
INSERT INTO ifk_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Deket mun-appit kayuh pumpasalamatan yun ha-on ya mahapul an un-unudon yu nadan intugun kun maunud ta abulutok di iappit yu ");
INSERT INTO ifk_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ne kinan yun am-in kediyen algo. Adi mabalin an waday tod-an yu. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Un-unudon yuy tugun ku. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Adiyu ibabain di makaphod an abun ngadan ku. Mahapul an am-in di tatagud Israel ya abuluton dan makaphodak. Ha-oy di Dios ya numbalinon dakayun makaphod. ");
INSERT INTO ifk_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Man-uket impangulu dakayun ha-on an timmayan ad Egypt ya ta ha-oy an Dios yuy dayawon yu. Ha-oy di AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Kanan bon APU DIOS ke Moses di “Kalyom hanadah holag Israel hituwe: Datuwe nadan piyestan maat ta maamung nadan holag Israel an mundayaw. ");
INSERT INTO ifk_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Miabulut kayun mungngunuh onom an algo ta ingunu yu nadan ngunu yu. Mu nah mikapitun algon Sabadun Tungo ya mahapul an mun-iyatu kayu te niong-ong ke ha-on hidiyen algo ta maamung kayun mundayaw ke ha-on, takon di daanay pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Datuwe nadan piyestan aton yu nah nagtud an algo. ");
INSERT INTO ifk_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Mahapul an aton yuy Piyestan di Nala-uwan di Anghel. Ya hay pangatan yun tuwe ya ilappu yu nah mahmahdom di mikahimpulut opat an algo nah mamangulun bulan. ");
INSERT INTO ifk_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ne nah mikahimpulut liman algo ya adi kayu mangan hi tinapay an ugge naha-adan hi mumpalbag hi pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ya hanah mamangulun algo kediyen pumpiyestaan yu ya abunay maamung kayu ta mundayaw kayun ha-on. Maid nimpey mungngunu kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mun-appit kayuh maghob hi kabigabigat ke dadiyen pitun algo. Ya maamung kayu bo nah mikapitun algo ta mundayaw kayun ha-on ya adi kayu mungngunu. ");
INSERT INTO ifk_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Deket ume kayu nah boblen idat kun dakayu ta mun-ani kayu ya ie yu nah padi nan mamangulun ohan botok an inani yu. ");
INSERT INTO ifk_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ne itaggen nan padih diye ta ipresentanan ha-on an Dios nah algon mitun-ud hi Sabadun Tungo ta abuluton dakayun ha-oy. ");
INSERT INTO ifk_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kediyen algo ya iappit yun ha-on di hintoonan lakin impan di kalneron maid di dipektona ta gobhon yu. ");
INSERT INTO ifk_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Pakighob yuy umeh duwan kilon miappit an alinan naha-adan hi mantekan di oliba. Umipaamlong ke ha-on di hamuy dadiyen iappit yun maghob. Id-um yun iappit di ohan litron mainum. ");
INSERT INTO ifk_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Deket uggeyu ni-an in-appit hidiye ya adi mabalin an kanon yu nan ka-ani yu, takon nan maata, nihanglag, weno nakapyah tinapay. Mahapul an munnanong an un-unudon di holag yu ta nangamung hituwen Tugun, takon di daanay kawad-an da. ");
INSERT INTO ifk_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Bilangon yuy pitun linggu mipalpu nah kabigatan di Sabadun Tungoh nangieyan yu nah padih ohan botok an page ot iappit nan ha-on an Dios. ");
INSERT INTO ifk_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ne mun-appit kayu boh page nah algon kabigatan di mikapitun Sabadun Tungo. ");
INSERT INTO ifk_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ohan pamilya on iappit nan ha-on an Dios di duwan tinapay an umeh duwan kilon nakammohan hi mumpalbag. Hidiyen iappit nan mamangulun inani nan page ya idat nan ha-on an Dios. ");
INSERT INTO ifk_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Id-um yu kediyen iappit yun ha-on an Dios di pitun hintoonan lakin impan di kalnero, ohan bulug an baka, duwan lakin kalneron maid di dipekto dat iappit dan maghob. Ya id-um yun iappit di page ya mainum. Hay hamuy datuwe ya umipaamlong ke ha-on an Dios. ");
INSERT INTO ifk_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ya mun-appit kayuh ohan lakin gulding gapuh liwat ya duwan hintoonan lakin impan di kalneron pakihayyupan yu ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Itaggen nan padin ipresentan ha-on an Dios dadiyen duwan lakin impan di kalnero ya nadan tinapay an nakapyah ka-anin page ta iappit nan ha-on. Ya midat ke didan padih diye. ");
INSERT INTO ifk_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Adi kayu nimpe mungngunu ketuwen algo, abunay maamung kayu ta mundayaw kayun ha-on. Munnananong hituwen tugun ya mahapul an un-unudon nadan holag yu, takon di daanay pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Deket mun-ani kayu ya adiyu pakaallan nadan page an nungkipingngit ya adi kayu mibangngad ta eyu pakaallan nadan lina-uwan yu. Bay-an yu dadiyet waday aniyon nadan nawotwot ya nadan nakiboblen dakayu. Ha-oy an AP-APU an Dios yuy nangitugun ketuwe.” ");
INSERT INTO ifk_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Kanan APU DIOS ke Moses di “Kalyom hanadah holag Israel hituwe: Hanah mamangulun algoh mikapitun bulan ya mahapul an mun-iyatu kayu. Ya ipagango yuy tangguyub ta maamung kayun am-in an mundayaw. ");
INSERT INTO ifk_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Adi kayu nimpe mungngunu, abunay mun-appit kayuh maghob ke ha-on an Dios. ");
INSERT INTO ifk_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Ya aton yu nan ine-en di kakaanan di liwat di tatagu nah hintoon hanah mikapulun algo kediyen mikapitun bulan. Ya muntopol kayun adi kayu mangan kediyen algo. Abunay maamung kayun mundayaw ya mun-appit hi maghob ke ha-on an DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Adi kayu nimpe mungngunu kediyen algo te kediyey pangatan yu nah ine-en di kakaanan di liwat. ");
INSERT INTO ifk_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Hanan tagun mangan an adi muntopol kediyen algo ya adi mo makid-um hanadah tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Hanan tagun mangibahho ta mungngunu kediyen algo ya mate. ");
INSERT INTO ifk_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Maid nimpey mungngunu kediyen algo. Munnanong hituwen Tugun ya mahapul an un-unudon am-in di holag Israel takon di daanay pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hituwen algon pun-iyatuwan ya mipalpuh nalin-ob di algo nah mikahiyam an algo inggana malin-ob di algoh kabiggatanan hidiyey mikahimpulun algo kediyen mikapitun bulan. Ya kediyen algo ya miadi nimpey mangan.” ");
INSERT INTO ifk_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Kanan bon APU DIOS ke Moses di “Kalyom hanadah holag Israel hituwe: Hay Piyestan di Kampu ya aton yuh pitun algo, mipalpu nah mikahimpulut liman algo kediyen mikapitun bulan. ");
INSERT INTO ifk_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Hanah mamangulun algo ya maamung kayun mundayaw ke ha-on. Ya maid di mungngunu. ");
INSERT INTO ifk_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mun-appit kayuh maghob hi kabigabigat kediyen pitun algo. Ne hanah mikawalun algo ya maamung kayu bo ta mundayaw kayu ya mun-appit kayuh maghob. Ya maid nimpe ke dakayuy mungngunu. ");
INSERT INTO ifk_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Aton yu dadiyen piyesta ya mun-appit kayuh maghob, hay page, hay makan ya hay mainum ta pundayaw kayun ha-on an Dios yu. Mahapul an aton yu datuwe nadah natuddun tiempon kaatana. ");
INSERT INTO ifk_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Datuwen piyestan aton yu ya mid-um nah pangun-unudan yuh ine-en di Sabadun Tungo ya nadah pun-appitan yuh insapata yu ya nadan inguddan yun idat ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Athidi nimpey aton yun deket mun-ani kayu ya mumpiyesta kayuh pitun algo. Ilappu yu nah mikahimpulut liman algo nah mikapitun bulan. Hanah mamangulu ya nah mikawalun algo ya mun-iyatu kayu. ");
INSERT INTO ifk_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kediyen mamangulun algo ya umala kayu nadah kapkaphodan an bungan di intanom yun kaiw, hay tubun di palma ya hay makattubun hapang di kaiw ta ilappu yu nan piyestan pundayaw yun ha-on an DIOS hi pitun algo. ");
INSERT INTO ifk_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Dakayu ya nadan holag yu ya mahapul an aton yuh tuwen piyestah pitun algo nah mikapitun bulan hi katootoon. ");
INSERT INTO ifk_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ya mahapul an miha-ad kayuh kampuh pitun algo, ");
INSERT INTO ifk_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ta panginilaan di holag yuh udum hi algo an ha-on an DIOS ya impungkampuk handidan aammod yu handih nangipanguluwak ke didan timmayan ad Egypt. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Danaey piyestan kinalin Moses an aton nadan holag Israel hi pundayaw dan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Kalyom hanadah holag Israel ta umiali dah namahman lanan di oliba ta iha-ad yu nadah kingke nah Tabernacle ta munnananong an adi mad-op di dilag hidi. ");
INSERT INTO ifk_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Tolgan Aaron dadiyen dilag hi kahilohilong ya tibonat munnananong dan mundidilag inggana mabigat nah binnah-el nan kurtinan kawad-ak an DIOS. Hituwen olden ya munnanong an maunud ta nangamung. ");
INSERT INTO ifk_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Mahapul an mipaptok ta nangamung dadiyen dilag an nipattuk nadah balituk an pangipattukan nah kawad-ak an DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Usalon yuy himpulut duwan kilon alinat mangapya kayuh himpulut duwan tinapay. ");
INSERT INTO ifk_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Iha-ad yu dadiyen tinapay an munduwan matuntun-ud di hin-on-om nah naamoh balituk an lamesaan hidi nah kawad-ak. ");
INSERT INTO ifk_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Waghikan yu didah bangbanglun insenso ya in-appit yun maghob ke ha-on an DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mahapul an iha-ad yuy athidin tinapay nah kawad-ak an DIOS hi kasabasabadun Tungon iappit yu ta nangamung dadiyen tinapay ke ha-on ta munnanong di nakitobbalak ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Midat dadiyen tinapay ke Aaron ya nadan linalakin imbabalenat kanon da nah kawad-ak te hidiyey bingay da nah makan an niappit ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Wada on tagun iEgypt hi amana ya holag Israel hi inana. Nakiawwit hi ohan holag Israel ");
INSERT INTO ifk_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","an imbabalen Selomit an imbabalen Dibri an holag Dan. Kediyen nun-awwitan da ya gaga-ihoy kinalin diyen imbabalen di iEgypt ke APU DIOS. Ot mieh diyen tagu ke Moses ta kalyona hin nganney maat ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ya ginuwalyaan da ot had-on da hin nganney pinhod APU DIOS an aton da ke hiya.” ");
INSERT INTO ifk_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Indani ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ie yuh naen tagu nah e-elen tun kampu. Ne am-in nadan nangngol nah gaga-ihon kinalina ya ihakmo day takle dah ulunat tistiguwan dan nunliwat ta tugmilan yun am-in an bimmoblet mate. ");
INSERT INTO ifk_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Hituwey kalyom hanadah holag Israel: Hanan tagun gaga-ihoy kalyonan ha-on an APU DIOS ya holtaponay kastiguna gapu kediyen liwat na. ");
INSERT INTO ifk_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ya hay kastigun di tagun munliwat hi athidi ya tugmilan nadan bimmoblen holag Israel ta mate. ");
INSERT INTO ifk_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Hanan pumate ya mahapul an mate. ");
INSERT INTO ifk_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Hanan mamateh aggayam di udum an tagu ya mahapul an hannotana. Ya mahapul an hay matagun aggayam di ihannot nah pinatena. ");
INSERT INTO ifk_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Hanan tagun liniputanay ibbana ya mahapul an maat damdaman hiyah diyen inat na. ");
INSERT INTO ifk_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Deket gini-unay gunit di ohan tagu ya mahapul an magi-u damdamay gunit nan numbahul. Deket kinulap di ohan taguy ohan matan di ohan tagu ya mahapul an makulap damdamay ohan matan nan numbahul. Deke bot pinlag di ohan taguy ohan bab-an di ohan tagu ya mahapul an maplag damdamay ohan bab-an nan numbahul. Mahapul an maat damdama nah taguy inat nah ibbana. ");
INSERT INTO ifk_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Deket pinaten di ohan tagu on aggayam ya mahapul an hannotana. Mu deket pimmatey ohan tagu ya mahapul an mate damdama. ");
INSERT INTO ifk_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Datuwen olden ya mahapul an un-unudon am-in di holag Israel ya nadan tatagun nalpuh udum an boblen nakiboble dakayu, te ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nagibbun kinalin Moses dadiye nadah holag Israel ot ie dah diyen nunliwat nah e-elen di boble ot tugmilan da ot mate an inun-unud day kinalin APU DIOS ke Moses an aton da. ");
INSERT INTO ifk_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Handih kawadan Moses nah Bilid an Sinai ya kinalin APU DIOS datuwen tuguna nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Kananan Moses di “Athituy itugun mu nadah holag Israel: Deket ume kayu nah boblen idat kun dakayu ya adiyu liyakon di payo yu nah mikapitun toon ta pangipatibo yun dayawonak. ");
INSERT INTO ifk_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Onom an toon di punliyakan yuh payo yu, pangaanan yuh haping di intanom yun grapes, pun-aniyan yu ya pamlagan yuh bungan di intanom yun bungbunga-an. ");
INSERT INTO ifk_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mu nah mikapitun toon ya mahapul an pun-iyatuwon yuy luta yu te niong-ong di luta ke ha-on an AP-APU. Adiyu nimpe tanoman di payo yu ya adiyu kaanon di haping di intanom yun grapes kediyen toon. ");
INSERT INTO ifk_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ya adinadaman ekayu muntanom ya mun-ani ya eyu alan di bungan nadan pamga ot tummol takon di bungan nadan intanom yun grapes an uggeyu kinaan di haping na. Te hidiyen toon di pun-iyatuwan damdaman di luta yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Takon di ugge naliyak nan payo yuh hintoon ya adi kayu makudangan hi kanon yu nadah pamilya yu, nadan muttatyu yu, nadan matangdanan an pungngunuwon yu ya nadan hintaguwan an nakiboblen dakayu, nadan ");
INSERT INTO ifk_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","aggayam yu ya nadan mailom an aggayam an wada nah luta yu. Damanan kanon yuy bungan nadan malpuh payo yu ya lagunta yun uggeyu impaptok. ");
INSERT INTO ifk_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Bilangom di nap-at ta hiyam an toon an hidiye ya mamimpituy pitun toon. ");
INSERT INTO ifk_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ne hanah mikapulun algo nah mikapitun bulan nah mikanaliman toon an hidiyey algon kakaanan di liwat di tatagu ya mipagangoy tangguyub am-in hanadah boble. ");
INSERT INTO ifk_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Hituwen mikanaliman toon ya miong-ong ke ha-on. Mun-am-amlong kayu ketuwen toon te takon nadan nigattang an himbut ya mibangngad da nah datin pamilya da. Ya am-in nadan lutan nigattang ya mibangngad nah datin kon bagi. ");
INSERT INTO ifk_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kediyen mikanaliman toon ya adi kayu nimpe muntanom ya adi kayu mun-ani ya adiyu alan di bungan nadan impamganay tomol takon nadan bungan di grapes nah lagunta yun uggeyu impaptok. ");
INSERT INTO ifk_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mu damanan kanon yuy bungan di nganneh diyen malpuh payo yu ya lagunta yun uggeyu impaptok. Hidiyen hintoon ya niong-ong ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ya mibangngad nimpe kediyen toon am-in nadan nigattang nah datin kon bagi. ");
INSERT INTO ifk_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kinali deket waday igattang yu weno gatangon yuh luta hi ibba yun holag Israel ya adiyu talamon. ");
INSERT INTO ifk_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Hay pumbalol yu ya mipuun hi kaatnay maala yuh bungana ya hin kaatnay toon ta ahi madatngan nan toon an pangibangngadan. ");
INSERT INTO ifk_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Deket mabaybayag ta ahi madatngan hidiyen toon ya nangingina, mu deket gagalan madatngan ya nalaklaka, te hay magatang ya nan kadakol di maani kediyen luta. ");
INSERT INTO ifk_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Adi kayu munhintatallam, te hidiyey pangipatibo yun mangun-unud kayun ha-on. Ha-oy an AP-APU di Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Un-unudon yun am-in di tugun ya olden ku ta malinggop di kiha-adan yu nah boble yu ");
INSERT INTO ifk_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ya pumhod di iliyak yun adi kayu makudangan hi kanon yu ya luminggop kayu kediyen pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kal-ina ket kalyon yuy ‘Nganney kanon mo nah mikapitun toon hin adi kami muntanom ta maid di emi aniyon?’ ");
INSERT INTO ifk_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Hay humang nae ya athitu: ‘Ahik bendisyonan di iliyak yu nah mikan-om an toon ta dakol di aniyon yu ta umustun kanon yuh tulun toon. ");
INSERT INTO ifk_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Deket muntanom kayu mo nah mikawalun toon ya nanongnan wada pay nan inani yu nah mikan-om an toon an ta waday kanon yu inggana madatong hidiyen inliyak yu.’ ");
INSERT INTO ifk_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Hanan luta yun igattang yu ya adina lebbeng an munnanong an migattang te bagik hidiyen luta, bokon yu bagi. Makibobboble kayu ya makipaypayyo kayu ya abu tuh boblek. ");
INSERT INTO ifk_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Deket nigattang di luta ya waday kalebbengan nan kon lutan mamangngad. ");
INSERT INTO ifk_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Deket numbalin an nawotwot di ohan holag Israel ta kapilitan an igattang nay lutana ya damanan hay kaih-upan an iibanay mamangngad kediyen luta. ");
INSERT INTO ifk_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Deket maid di iibanan kabaelanan mamangngad mu kay anhan ya waday pamangngad nan nangigattang ya damanan hiya mismuy mamangngad. ");
INSERT INTO ifk_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Mahapul an ibangngad nay pihhun nan nangatang an mipuun di balol na hin namingkaat an nun-ani kediyen luta inggana nah nagtud an toon an pangibangngadan hi ginatang. ");
INSERT INTO ifk_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mu deket makudang di pihhun diyen tagun pamangngad na nah lutana ya munnanong di kalebbengan nan nangatang inggana madatngan nan toon an pangipabangngadan hi ginatang. Kediyen toon di pangipabangngadan am-in hi ginatang nah datin kon bagi. ");
INSERT INTO ifk_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Deket nan balen nigattang ya wada nah nahamad an naaladan an boble ya waday kalebbengan nan kon balen mamangngad ten nala-uy hintoon mipalpu nah algon nigattangana. ");
INSERT INTO ifk_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mu deket adi bangngadon nan nangigattang kediyen toon ya mumbalin mon permanenten balen nan nangatang. Adi mo mabalin an mibangngad nah nangigattang takon di madatngan nan toon an pangipabangngadan hi ginatang. ");
INSERT INTO ifk_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mu hana ken bale nah ugge naaladan ya mibilang an kay payon waday kalebbengan nan kon balen mamangngad kediyen bale nah kumpulmin tiempo ya mahapul an mibangngad nah nangigattang nah nagtud an toon an pangipabangngadan hi ginatang. ");
INSERT INTO ifk_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Mu nada ken holag Libay ya waday kalebbengan dan mamangngad hi nigattang an bale dan wada nah boble dah kumpulmin tiempo. ");
INSERT INTO ifk_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Deket waday balen inggattang dan wada nah boble dan ugge nabangngad ya mahapul an mibangngad kediyen nagtud an toon an kibangngadan di ginatang, te nada ken baleda nadah numboblayan da ya bale da tuwalit nangamung. ");
INSERT INTO ifk_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mu nadan pumpattolan hanadah nunlinikkod nah boble da ya adi mabalin an igattang da, te bagidat nangamung. ");
INSERT INTO ifk_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Deket wada nadah hinag-on yun holag Israel di numbalin an nawotwot ta adi pakatanud hi adol na ya mahapul an idatan yuh kahapulana umat hi pangat yu nah tangdanan yun pungngunuwon yu ta nanongnan makiboble ke dakayuh diyen ibba yun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Adiyu ipaporsientoy ipautang yun hiya, mu un-unudon yuh APU DIOS ta ibilang yun iba yu ya pakiboblayon yu nah numboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Adiyu nimpe ipaporsientoy ipautang yun hiya ya adiyu pungganansyaan di makan an igattang yun hiya. ");
INSERT INTO ifk_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hituwey in-olden ku an AP-APU an Dios yun nangipangulun dakayun timmayan ad Egypt ot idat kuy Kanaan an pumboblayan yu ta dayawonak an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Deket waday holag Israel an nakawwotwot ta mahapul an ihbut nay adol nan dakayu ya adiyu pungngunuwon an kay himbut. ");
INSERT INTO ifk_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Makiha-ad ke dakayun umat nah matangdanan an pungngunuwon yu inggana madatngan nan nagtud an mikanaliman toon an kalibliyana. ");
INSERT INTO ifk_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ta kediyen toon, hiya ya nan pamilyana ya mibangngad dah pamilya da nah boblen di nahlagan da. ");
INSERT INTO ifk_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Dakayun holag Israel ya muttatyu dakayun ha-on an DIOS an nangipangulun dakayun timmayan ad Egypt. Kinali, adi mabalin an mihbut kayu. ");
INSERT INTO ifk_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Adi kayu makabbungot ke dida, mu un-unudonak an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Deket mahapul yuy himbut, gumatang kayu nadah bobleh nunlinikkod ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mabalin bon gumatang kayuh imbabalen nadan hintaguwan an nakiboblen dakayu. Damanan punhimbut yu nadan imbabalen nadan hintaguwan an nitungo nah boble yu. ");
INSERT INTO ifk_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ya mabalin an ipatawid yu didah imbabale yu ta punhimbut da dida inggana mate da. Mu nada ken ibba yun holag Israel ya adi mabalin an athidiy pangat yun dida. ");
INSERT INTO ifk_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Deket wada on hintaguwan an nakiboblen dakayun kimmadangyan ya waday ibba yun holag Israel an numbalin an nawotwot ot ena inggattang di adol na kediyen tagu weno nadah iimbabalenat munhimbut ");
INSERT INTO ifk_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ya waday kalebbenganan mabangngad. Damanan hay linalakin tutulang na, ");
INSERT INTO ifk_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","hay linalakin tutulang di ammod na, hay naka-ih-up an iibana weno hiya mismuy mamayad hi kalibliyana ten waday inamung nah pihhuna. ");
INSERT INTO ifk_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Mahapul an kalyona nah nangatang ke hiya ta bilangon day toon mipalpuh nigattangana inggana kadatngan diyen nagtud an toon an kibangngadan di ginatang. Ta ihummangan day mibayad hi kalibliyanan mipuun hi tangdanon di matangdanan an pungngunuwon. ");
INSERT INTO ifk_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Deket mabayag di kadatngan nan toon an pangibangngadan hi ginatang ya mahapul an ong-ongal an pihhuy pabangngadona nah nangatang ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Deket gagalan madatngan hidiyen toon, mahapul an kuwentaon dat hanan lebbeng nan pamangngad nay bayadana, ");
INSERT INTO ifk_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ta kay natangdanan hi katootoon. Mahapul an tibon yu ta adi palohanan nan nangatang ke hiya. ");
INSERT INTO ifk_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Deket ugge naliblih kumpulmi ke datuwen toon ya mahapul an malibli nah kadatngan nan mikanaliman toon an pangipabangngadan hi ginatang. ");
INSERT INTO ifk_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Hay holag Israel ya adi mabalin an munhimbut ta nangamung te himbut dakayun ha-on. Te ha-on an Dios yu ya impangulu dakayun timmayan ad Egypt. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Kanan bon APU DIOS di “Adi kayu mangapyah dayawon yu umat hi tinattaggu, nadan pinaot an kaiw weno batu te ha-on ya abuy dayawon yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Punnanongon yun aton di ine-en di Sabadun Tungo ya lispituwon yu nan balek an pundayawan yun ha-on. Ha-oy di AP-APU an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Deket un-unudon yuy tugun kut miunnud nah pinhod kuy pumbiyag yu ");
INSERT INTO ifk_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ya ipaalik di udan nah tiempon panapulan yu ta pumhod di iliyak yu ya bumunga nadan bungbunga-an an intanom yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ya dumakol di aniyon yu ta adi mapoppog di pun-aniyan yuh inliyak yu yaden madatngan boy pumpugahan yuh grapes. Adi bo magibbuy pumpugahan yuh grapes yaden madatngan boy puntunodan yu. Ahi wadan am-in nadan makan an pinhod yun kanon ya malinggop kayuh boble yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Wadaok an DIOS di din-ong hi boble yu ta malinggop kayun makahhuyop an maid di takutan yu. Iadawwik bo nadan katatakut an aggayam an pumaten dakayu ya maid di iabulut kun gumubat ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ya dakayuy pangapputok hin waday gumubat ke dakayu, ");
INSERT INTO ifk_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ta ammunay liman dakayu ya apputon yuy hinggatut. Ya takon di ammunay hinggatut ke dakayu ya apputon yuy himpulun libu. ");
INSERT INTO ifk_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Bendisyonan dakayu bon ha-on ta mahlag kayuh dakol ta umannung di kinalik ke dakayu handi. ");
INSERT INTO ifk_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Bendisyonak bo nadan iliyak yu ta mahawwahawwal di kanon yu. Ya gapu te athidi ya mahapul an iwele yuy baak an page yu ta waday pangiha-adan yuh pakaani yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Makiha-adak ke dakayun adi dakayu iwalong. ");
INSERT INTO ifk_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Om, makiha-ad ke dakayu ta nangamung, ta ha-oy di dayawon yun Dios yu ya dakayuy tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ha-oy di AP-APU an Dios yu. Impakaan dakayud Egypt ta adi kayu munnanong an munhimbut nadah tataguh di. Ya kinaan kuy kabaelan dan mangipaholholtap ke dakayu ta malibli kayun adi kayu mo mibabain.” ");
INSERT INTO ifk_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Mu deket adiyak un-unudon ke dakayu ");
INSERT INTO ifk_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ya deket iwalong yuy tugun ku an adiyu aton di kalyok an aton yu ya deket ibahho yuy nakitobbalak ke dakayu ya ");
INSERT INTO ifk_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","kastiguwon dakayun ha-on. Ta ipaalik di ligat ke dakayu, umat hi dogon adi maagahan, namahig an atung di adol an kumulap ya hay dogon mangpuy adol. Deke bot muntanom kayu ya maid di maala yu te hogpon dakayuh buhul yu ta diday mangan hi intanom yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Iwalong dakayun ha-on ta maapput kayuh gubat ya nadan mangihihhingit ke dakayuy pun-ap-apu yu. Ya ahi namahig di takut yu ta takon di maid di mamdug ke dakayu ya mamtik kayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ya deket takon di maat datuwe ke dakayu, mu kapyanan adiyak un-unudon ya udmak moy ligat yun pumbalinok an mamimpituy kinaligat na. ");
INSERT INTO ifk_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Adik ipaaliy udan ta kumukkulhi nan lutan puntanoman yun kay gumok ta pamoppog kuh pumpahhiya yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ya takon di kaatnay pangat yun munliyak ya maid di hilbina te maid di ibungan di itanom yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Deket punnanongon yun mungngohen ha-on ta adiyak un-unudon ya kastiguwon dakayu bo ya mamimpitu pay kinaligat di pangastiguk ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ipaalik di katatakut an aggayam ta pumpate day imbabale yu, pa-iyon day aggayam yu ya o-ohay tod-an dan dakayu ta matoan di kakalata yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ya deket ugge kayu pay nagilat ke datuwen pangastiguk ke dakayu ta nanongnan ngohayonak an adiyak donglon ya ");
INSERT INTO ifk_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","kastiguwon dakayu bon ha-on hi mamimpitu pay di kinaligat na, mu nan impala-u yun nangastiguk ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta ipaalik di mangubat ke dakayu gapuh nangibahhowan yuh nakitobbalan yun ha-on. Ta deket naamung kayun mihikug nadah o-ongal an boble yu ya ipaalik di adi maagahan an dogo ta mapilit kayun munsuku nadah buhul yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Dadagok di pangal-an yuh kanon yu ta umustuy ohan punha-angan hi tinapay an usalon yun mangiha-ang nah natdaan an alina yu. Ya iatal yu dadiye. Ya takon di kinan yu ya nanongnan naagangan kayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Mu deket ugge kayu pay nagilat ta nanongnan mungngohe kayun adiyak un-unudon ");
INSERT INTO ifk_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ya gapuh boh-ol ku ya kastiguwon dakayu boh mamimpitu pay di kinaligat na mu nan impala-u yun nangastiguk ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ahi namahig di inagang yun adi kayu pakaippol ta kanon yu moy imbabale yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Dadagok bo nadan pundayawan yu nadah tap-on di duntug takon nadan punggohoban yuh bangbanglun insenso ya iwelek di naten adol yuh kad-an nadan kinapyan di tagun dios yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Dadagok di boble yu ya nadan pundayawan yu ya adik abuluton di iappit yun ha-on ya hingngitan dakayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Om, pakadadaggok di boble yu ta nadan buhul yun umalin mumbobleh di ya mahngang dah pangang-angan dan nakadaddag. ");
INSERT INTO ifk_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ipaalik di mangubat ke dakayu ta iwahit dakayuh kabobboble. Ta matoan di luluta yu ya munnanong an nadadag di boble yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Ta nadan luta yu ya kay da umamlong an mun-iyatu te uggeyu impun-iyatu nadah natuddun toon an kinalik an adiyu liyakon. Ya ke dadiyen toon an kiha-adan yuh boblen nadan buhul yu ya matoan nadan luta yu ta mun-iyatu da. ");
INSERT INTO ifk_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ya dakayu ken matdaan ya pumbalinon dakayun makattakut hidi nadah boblen di buhul yun kiayan yu ta takon di gangon di tubun di kaiw an midibdib ya bumtik kayu gapuh takut yun kay dakayu pumpudug hi buhul yuh gubat. Ya takon di maid di mih-up an buhul yu ya matu-i kayu. ");
INSERT INTO ifk_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ahi kayu mungkatutu-i takon di maid di mamdug ke dakayu. Maid boy kabaelan yun makihanggah buhul yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ahi kayu bo mate nadah boblen kiayan yu an kay dakayu inukmun ke dadiyen boblen di buhul yu. ");
INSERT INTO ifk_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ya nadan o-ohan ahi matdaan ke dakayu ya map-u da nah boblen di buhul da, gapuh liwat da ya gapuh liwat di ammod da. ");
INSERT INTO ifk_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Mu kay anhan ya ahi mumpakumbaba nadan tataguk ta muntutuyu dat kalyon day liwat da ya hay liwat di aammod dan nungngohen ha-on. ");
INSERT INTO ifk_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Hantuh namahig an pangastiguwak ke didan ipaek didah boblen di buhul da. ");
INSERT INTO ifk_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Ya gapun diye ya nomnomok bo nan nakitobbalak ke da Jacob, hi Isaac ya hi Abraham ta ipaannung ku nan kinalik handin idat ku nan boble ke didan tataguk. ");
INSERT INTO ifk_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Hidiyen pangipaeyak ke didah udum an bobley kastigu da gapuh liwat da te uggeda inun-unud nadan tugun ku, mu pinihul da. Ta kediyen panayanan dah boble da ya mun-iyatu nan luta. ");
INSERT INTO ifk_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mu takon di athidi ya adik ma-idon di nakitobbalak ke didat adik dadagon didan am-in. Ha-oy di AP-APU an Dios da. ");
INSERT INTO ifk_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ahik bo nomnomon nan nakitobbalak handidah aammod dah nangipanguluwak ke didan timmayan ad Egypt ot ang-angon am-in di tataguh kabobbobley ongal an kabaelak. Ha-oy di AP-APU.” ");
INSERT INTO ifk_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Danaen am-in di kinalik ke Moses nah Bilid an Sinai ta intuguna damdaman dakayun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Kalyom hanadah holag Israel di ‘Deket munsapata on tagut iong-ong nay ohan tagu ke APU DIOS ya bayadan nay balol na. ");
INSERT INTO ifk_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","Datuwey maunud an ibayad: Hay lalakin muntoon hi duwampulu inggana nan-om ya naliman kalang di mibayad. Hay kat-agun babai ya tulumpulun kalang. Hay lalakin muntoon hi lima inggana duwampulu ya duwampulun kalang. Hay ungan babai ya himpulun kalang. Hay golang an lalakin himbulana inggana limay toona ya liman kalang. Hay bayad di babain athidiy toona ya tulun kalang. Hay lalakin nahawwal hi nan-om di toona ya himpulut liman kalang. Mu hay babain nahawwal hi nan-om di toona ya himpulun kalang. ");
INSERT INTO ifk_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Deket nawotwot nan tagut adina gol-an nan nakalin mibayad ya ienah diyen niong-ong an taguh kad-an nan padi ta nangamung nan padin mangalih kabaelan diyen nawotwot hi pamayad na. ");
INSERT INTO ifk_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Deket hay insapatana ya aggayam an mibilang an malinin abuluton APU DIOS an miappit ke hiya, hidiyen aggayam ya mumbalin an nangilinan ");
INSERT INTO ifk_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ya adi mabalin an mahannotan. Deket hannotan nan tagu ya ibagin APU DIOS hidiyen nakalin aggayam ya nan ihannot na. ");
INSERT INTO ifk_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mu deket hay in-ong-ong nan tagu ya nan aggayam an adi mibilang an malinin adi abuluton APU DIOS an miappit ke hiya, mahapul an ien nan tagu nah padi. ");
INSERT INTO ifk_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ta nan padiy mangali hin maphod weno ad-adi ne nangamung nan padin mangalih bayad na ya hidiyen nakalin bayad na ya adi mabalin an mahannotan. ");
INSERT INTO ifk_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Deket pinhod nan tagun bangngadon ya mahapul an bayadana ya udmana pay nan imbayad nah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Deket in-ong-ong di ohan taguy balena, hay padiy mangalih bayad na mipuun hi klasen nan bale ya hidiyen nakalin bayad na ya adi mabalin an mahannotan. ");
INSERT INTO ifk_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mu deket pinhod diyen tagun bangngadon hidiyen bale, mahapul an bayadana ya udmana pay nan imbayad nah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Deket hay in-ong-ong di ohan tagu ke APU DIOS ya hay lutana, hay bayad na ya mipuun hi kadakol di mitanom hidi. Hay bayad di ohan bushel ya himpulun kalang. ");
INSERT INTO ifk_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Deket niong-ong nan luta nah mikanaliman toon an kibangngadan di nigattang ya munnanong di balol na. ");
INSERT INTO ifk_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Deket nabaybayag di niong-ongana ya kuwentaon nan padiy bayad na mipuun hi bilang di toon inggana madatngan nan nagtud an toon an kibangngadan am-in di nigattang, ta hiyay mangalih balol na. ");
INSERT INTO ifk_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Deket pinhod nan tagun bangngadon hidiyen luta, mahapul an bayadana ya udmanah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mu deket inggattang nah diyen lutah udum an tatagu yaden uggena binayadan hi APU DIOS handih nangiong-ongana ya mama-id moy kalebbenganan mamangngad kediyen lutana. ");
INSERT INTO ifk_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ta hidiye nan deket madatngan nan mikanaliman toon an pamangngadan hi nigattang ya mibangngad mo nadah padi te numbalin mon niong-ong ke APU DIOS hidiyen luta. ");
INSERT INTO ifk_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Deket in-ong-ong di tagu ke APU DIOS nan payon ginatang na, ");
INSERT INTO ifk_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ya kuwentaon nan padiy balol na mipuun hi bilang di toon inggana madatngan hidiyen mikanaliman toon an pangipabangngadan hi nigattang ta bayadan diyen tagu kediyen algo. Hanan pihhun ibayad na ya miong-ong ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ya kediyen nagtud an toon ya mibangngad nan payo nah datin kon payo weno nadah holag na. ");
INSERT INTO ifk_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Hay pumbalol am-in di nganneh diye ya mipuun hi maunud an pamayad. ");
INSERT INTO ifk_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Am-in boy namangulun impan di aggayam umat hi impan di baka, kalnero ya gulding ya niong-ong ke APU DIOS. Ta hidiye nan adi mabalin an inguddan di ohan tagun iong-ong dadiye ke hiya te niong-ong tuwali dadiye. ");
INSERT INTO ifk_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mu nan namangulun impan nadan adi mibilang an malinin aggayam an niong-ong ya damanan bangngadon nan tagu ten bayadana mipuun nah maunud an pamayad ya udmanah duwampulun porsiento. Deket adina bangngadon hidiyen aggayam ya migattang hidiye mipuun hi maunud an pamayad. ");
INSERT INTO ifk_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Mu am-in nadan niappit pe tuwali ke APU DIOS te niong-ong dadiye ke hiya umat hi aggayam, tagu ya luta ya adi mabalin an mabangngad weno migattang te niong-ong ta nangamung dadiye ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hanan tagun tinuddun APU DIOS an madadag ya adi mabalin an mabayadan ta bangngadon te mahapul an mipipate. ");
INSERT INTO ifk_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Am-in di bungan di mitanom ya miong-ong ke APU DIOS di mikapulu. ");
INSERT INTO ifk_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Deket pinhod nan tagun bangngadon dadiye ya mahapul an bayadana mipuun nah maunud an pamayad ya udmanah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ya am-in di mikapulun aggayam ya miong-ong ke APU DIOS. Deket numbilang di taguh aggayam na ya miong-ong ke APU DIOS nimpey mikapulu. ");
INSERT INTO ifk_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Adi mabalin an e potpotkon nan tagu nadan aggayam an waday dipektonat kananay dadiyey mikapulu. Ya adi bo mabalin an ena hannotan nan naptok an mikapulu. Deket hannotana nan naptok an mikapulu ya miong-ong ke APU DIOS hidiye, takon nan ena ot ihannot. Ya adi mabalin an e bayadan nan tagu dadiyet bangngadona.’” ");
INSERT INTO ifk_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Danaey kinalin APU DIOS ke Moses nah Bilid an Sinai an ituguna nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Handih namangulun algoh mikadwan bulan hi mikadwan toon nipalpuh timmayanan nadan holag Israel ad Egypt ya nanongnan wadadah did Sinai ya kimmalih APU DIOS ke Moses hidi nah pundayawan da ot kananay ");
INSERT INTO ifk_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“Kalyom ke Aaron ta bilangon yu nadan ibba yun holag Israel an mipuun hi puun da ya pamilya da ya ilista yuy ngadan nadan linalaki. Ya bilangon yu nadan damanan makigubat an muntoon hi duwampulu weno nahawwal. ");
INSERT INTO ifk_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ibagam hanadah aap-apun di hin-oh-an puun ta baddangan dakan mumbilang. ");
INSERT INTO ifk_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Datuwe nadan natuddun mun-ap-apu nadah hin-oh-an puun: Hanah holag Reuben ya hi Elisur an imbabalen Sedeur. ");
INSERT INTO ifk_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Hanah holag Simeon ya hi Selumiel an imbabalen Surishaddai. ");
INSERT INTO ifk_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Hanah holag Judah ya hi Nashon an imbabalen Amminadab. ");
INSERT INTO ifk_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Hanah holag Issakar ya hi Nethanel an imbabalen Suar. ");
INSERT INTO ifk_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Hanah holag Sebulun ya hi Eliab an imbabalen Helon. ");
INSERT INTO ifk_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Hanah holag Eplaim an imbabalen Joseph ya hi Elishama an imbabalen Ammihud, ya hanah holag Manasseh an imbabalen Joseph ya hi Gamaliel an imbabalen Pedahsur. ");
INSERT INTO ifk_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Hanah holag Benjamin ya hi Abidan an imbabalen Gideoni. ");
INSERT INTO ifk_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Hanah holag Dan ya hi Ahieser an imbabalen Ammisaddai. ");
INSERT INTO ifk_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Hanah holag Asher ya hi Pagiel an imbabalen Okran. ");
INSERT INTO ifk_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Hanah holag Gad ya hi Eliasap an imbabalen Deuel. ");
INSERT INTO ifk_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Hanah holag Naptali ya hi Ahira an imbabalen Enan.” ");
INSERT INTO ifk_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Datuwe nadan natuddun mangipangpangulu nadah hin-oh-an puun di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Da Aaron ke Moses ya datuwen himpulut duwan natuddun mangipangpangulu ");
INSERT INTO ifk_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ya impaayag dan am-in nadan holag Israel kediyen algo ot ilista da bon am-in di ngadan nadan linalakin muntoon hi duwampulu weno nahawwal mipuun hi nahlagan da ya pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ot bilangon Moses didah di nah adi maboblayan ad Sinai. Man-uke ya in-olden nan AP-APU an hidiyey maat. ");
INSERT INTO ifk_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Mipalpu nah panguluwan an imbabalen Israel an hi Reuben ya inlista da nadan damanan muntindalun muntoon hi duwampulu weno nahawwal mipuun hi puun da ya pamilya da. Datuwey bilang da: Hay nahlagan da Hay bilang da Hi Reuben 46,500 Hi Simeon 59,300 Hi Gad 45,650 Hi Judah 74,600 Hi Issakar 54,400 Hi Sebulun 57,400 Hanadan duwan imbabalen Joseph an da Eplaim ke Manasseh ya nibilang dan imbabalen Israel. Hi holag Eplaim 40,500 Hi holag Manasseh 32,200 Datuwe nadan udum an holag Israel: hi Benjamin 35,400 Hi Dan 62,700 Hi Asher 41,500 Hi Naptali 53,400. Hay bilang dan am-in ya 603,550. ");
INSERT INTO ifk_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Hanadan holag Libay ya uggeda nid-um an nilista ");
INSERT INTO ifk_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","te kinalin APU DIOS ke Moses an kananay “Adim ");
INSERT INTO ifk_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","id-um an ilista didan muntindalu. ");
INSERT INTO ifk_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Hay ingunu da ya mumpaptok da nah Tabernacle ya nadan ngunut hidi. Ya diday mangipah-on nah Tabernacle ya nadan ngunut hidi ten tumayan kayu ta mit-an kayu. Ya mahapul bon mungkampu kayuh nunlinikkod kediye. ");
INSERT INTO ifk_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ta deket mit-an kayu ya paluhon nadan holag Libay nan Tabernacle ne ahida bo inha-ad nah kit-anan yu. Hanada ken udum an ibba yun holag Israel ya adinadaman eda mih-up hidi te mate da. ");
INSERT INTO ifk_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ya waday oha nadah ibba yun holag Israel ya maanappil dan mungkampu mipuun hi puun da ya waday oha nadah mangipangpangulu on itakdog nay puuna ya waday bandela da. ");
INSERT INTO ifk_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mu nada ken holag Libay ya mungkampu dah nunlinikkod nah Tabernacle ta mungguwalya da. Ta maid nadah holag Israel di umalin mih-up hidit adik kastiguwon dida gapuh boh-ol ku.” ");
INSERT INTO ifk_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ot aton nadan holag Israel dadiyen kinalin Moses an intugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Kanan APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Am-in nadan puun di holag Israel ya matudduy pungkampuwan da ya mahapul an waday oha on waday bandela da. Mungkampu dah nunlinikkod ya migawwa nan Tabernacle.” ");
INSERT INTO ifk_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Hanah nangappit hi timilan di algo ya hidiy pungkampuwan di holag Judah ya nadan nakid-um hi bandela da. Hay mangipangpanguluh holag Judah ya hi Nashon an imbabalen Amminadab. ");
INSERT INTO ifk_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Hay bilang da ya 74,600. ");
INSERT INTO ifk_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Mihaynod di holag Issakar an hay mangipangpangulun dida ya hi Nethanel an imbabalen Suar. ");
INSERT INTO ifk_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Hay bilang da ya 54,400. ");
INSERT INTO ifk_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Mihaynod boy holag Sebulun an hay mangipangpangulun dida ya hi Eliab an imbabalen Helon. ");
INSERT INTO ifk_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Hay bilang da ya 57,400. ");
INSERT INTO ifk_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Hay bilang di holag Judah an nid-um danaen udum an holag Israel ya 186,400. Diday mangipangpanguluh holag Israel nah pangayan dan eda kit-anan an pungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Hanah nangappit hi south ya hidiy pungkampuwan di holag Reuben ya nadan nakid-um hi bandelada. Hay mangipangpanguluh holag Reuben ya hi Elisur an imbabalen Sedeur. ");
INSERT INTO ifk_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Hay bilang da ya 46,500. ");
INSERT INTO ifk_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Mihaynod di holag Simeon an hay mangipangpangulun dida ya hi Selumiel an imbabalen Surishaddai. ");
INSERT INTO ifk_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Hay bilang da ya 59,300. ");
INSERT INTO ifk_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Mihaynod di holag Gad an hay mangipangpangulun dida ya hi Eliasap an imbabalen Deuel. ");
INSERT INTO ifk_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Hay bilang da ya 45,650. ");
INSERT INTO ifk_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Hay bilang di holag Reuben an nid-um danaen udum an holag Israel ya 151,450. Diday mihaynod nah puntutun-udan dah pangayan da. ");
INSERT INTO ifk_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hanan Tabernacle ya nan kampun di holag Libay di migawwa nah pungkampuwan am-in nadan holag Israel. Didan holag Libay ya umga dan malpu da nah gawwanan itabin da nan Tabernacle, ne am-in nadan ibba dan holag Israel ya muntutun-ud dan ume, mipuun nah nuntutun-udan di kampu da. Ya waday oha on mipottok hi bandelan di holag da. ");
INSERT INTO ifk_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Hanah nangappit hi kalin-oban di algo ya hidiy pungkampuwan di holag Eplaim ya nadan nakid-um hi bandela da: Hay mangipangpanguluh holag Eplaim ya hi Elishama an imbabalen Ammihud. Hay bilang da ya 40,500. Mihaynod di holag Manasseh an hay mangipangpangulun dida ya hi Gamaliel an imbabalen Pedahsur. Hay bilang da ya 32,200. Mihaynod di holag Benjamin an hay mangipangpangulun dida ya hi Abidan an imbabalen Gideoni. Hay bilang da ya 35,400. Hay bilang di holag Eplaim an nid-um danaen udum an holag Israel ya 108,100. Diday nitun-ud nah holag Libay. ");
INSERT INTO ifk_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Hanah nangappit hi north ya hidiy pungkampuwan di holag Dan ya nadan nakid-um hi bandela da. Hay mangipangpanguluh holag Dan ya hi Ahieser an imbabalen Ammisaddai. Hay bilang da ya 62,700. Mihaynod di holag Asher an hay mangipangpangulun dida ya hi Pagiel an imbabalen Okran. Hay bilang da ya 41,500. Mihaynod di holag Naptali an hay mangipangpangulun dida ya hi Ahira an imbabalen Enan. Hay bilang da ya 53,400. Ot hay bilang di holag Dan an nid-um danaen udum an holag Israel ya 157,600. Diday manguddidin ume hanah eda kit-anan hi pungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hay bilang am-in di tindalun di holag Israel an nitudok ya 603,550. ");
INSERT INTO ifk_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ugge nid-um nadan holag Libay an nilista te hidiyey intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Hanadan holag Israel ya inat dan am-in di intugun APU DIOS ke Moses an aton da. Ingkapya day kampu dah pottok di bandela da. Ya deke bot mit-an da ya mun-uunnud da an waday ohan grupu on waday bandela da te hidiyey kinalin APU DIOS an aton da. ");
INSERT INTO ifk_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Datuwe nadan pamilyan da Aaron ke Moses an nitudok handih kimmaliyan APU DIOS ke Moses nah Bilid an Sinai. ");
INSERT INTO ifk_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Hanadan linalakin imbabalen Aaron ya hi Nadab an panguluwan, hi Abihu, hi Eleasar, ya hi Itamar. ");
INSERT INTO ifk_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Natuddu da ya niong-ong dan mumpadi, ");
INSERT INTO ifk_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","mu nate da Nadab ke Abihu hi hinangngab APU DIOS handih nun-appit dan hiyah ugge nangilinan an apuy nah adi maboblayan ad Sinai. Maid di linalakin imbabale da ot ammuna mo da Eleasar ke Itamar an numpadi an didan am-in ke da ama dan hi Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ayagam hitu nadan holag Libay ta tudduwom didan bumaddang ke Aaron an padi. ");
INSERT INTO ifk_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Diday mangiat nadah mahapul an mingunu nah Tabernacle an kawad-ak ta munhilbi da nadah padi ya nadan ibba dan bimmoble. ");
INSERT INTO ifk_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Mahapul bon ipaptok da nadan ngunut nah Tabernacle ya munhilbi dah din itakdog da nadan ibba dan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tudduwom nimpe didan bumaddang ke da Aaron an hin-am-a. ");
INSERT INTO ifk_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ammunah Aaron ya nadan linalakin imbabalenay tudduwom an mumpadi. Deket waday kumpulmin tagun e mih-up nah Tabernacle ta ena aton di ngunun di padi ya mipipate.” ");
INSERT INTO ifk_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Hanadan holag Libay di pinilik nadah holag Israel an miong-ong ke ha-on ta diday mihannot hi am-in hanadah linalakin panguluwan an imbabalen di holag Israel te bagik am-in di linalakin panguluwan an imbabalen di holag Israel. Handih pinatek nadan panguluwan an linalakin imbabalen nadan iEgypt ya niong-ong ke ha-on nadan panguluwan an linalakin imbabalen di holag Israel takon nadan namangulun impan di aggayam da. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Kanan bon APU DIOS ke Moses hidi nah adi maboblayan ad Sinai di ");
INSERT INTO ifk_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bilangom nadan linalakin holag Libay mipuun hi puun da ya pamilya da an ohay bulana ya nahawwal.” ");
INSERT INTO ifk_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ot bilangon Moses didan inun-unud nay intugun APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Datuwey ngadan nadan linalakin imbabalen Libay: hi Gershon, hi Kohat ya hi Merari. ");
INSERT INTO ifk_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Hi Gershon ya duway linalakin imbabalena: hi Libni ya hi Simei. ");
INSERT INTO ifk_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Hi Kohat ya opat di linalakin imbabalena: hi Amram, hi Ishar, hi Hebron ya hi Ussiel. ");
INSERT INTO ifk_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Hi Merari ya duwa boy linalakin imbabalena: da Mahli ke Mushi. Datuwey nahlag ke Libay an nitudok mipuun hi pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Hanadan nahlag ke Gershon ya dadiye nadan pamilyan Libni ya pamilyan Simei. ");
INSERT INTO ifk_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Hay bilang am-in di linalakin holag dan nilista an ohay bulana ya nahawwal ya 7,500. ");
INSERT INTO ifk_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Dadiyen nahlag ke Gershon di mungkampuh indoggan nan Tabernacle hi nangappit hi kalin-oban di algo. ");
INSERT INTO ifk_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Hay mangipangpangulun dida ya hi Eliasap an imbabalen Lael. ");
INSERT INTO ifk_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","26","Diday nangamung an mangipaptok nah Tabernacle takon nadan ngunut ya nadan kurtinan mihanih hogpan hi bohongna ya nah dola ya nah nunlinikkod hi Tabernacle takon nan altar. Ya diday nangamung an mangipaptok nadah linubid ya nadan udum an ngunut an mausal hidi. ");
INSERT INTO ifk_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Hanadan nahlag ke Kohat ya dadiye nadan holag Amram, hi Ishar, hi Hebron ya hi Ussiel. ");
INSERT INTO ifk_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Hay bilang am-in di linalakin holag dan nilista an ohay bulana ya nahawwal ya 8,600. Diday mangipaptok nadah nangilinan an ngunut ");
INSERT INTO ifk_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ya mungkampu dah nangappit hi south. ");
INSERT INTO ifk_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Hay mangipangpangulun dida ya hi Elisaphan an imbabalen Ussiel. ");
INSERT INTO ifk_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Datuwe nadan ipaptok da: nan Kahon APU DIOS, nan lamesaan, nan pangipattukan hi dilag, nadan altar, nadan udum an ngunut an usalon di padi nah bohongnan di Tabernacle ya nan kurtinan nihanih hogpan nah kawad-an APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hi Eleasar an padin imbabalen Aaron di mangipangpangulun am-in hanadah holag Libay. Ya hiyay ingkalgadun hanadah mungngunu nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Hanadan nahlag ke Merari ya dadiye nadan pamilyan da Mahli ke Mushi. ");
INSERT INTO ifk_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Hay bilang am-in di linalakin holag dan nilistan ohay bulana ya nahawwal ya 6,200. ");
INSERT INTO ifk_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Diday mungkampu nah north nan Tabernacle. Ya hi Suriel an imbabalen Abihail di mangipangpangulun dida. ");
INSERT INTO ifk_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Diday nangamung an mangipaptok nah kalkalimangngan nan Tabernacle: nadan miballabag, nadan tukud, nadan pangipataddogan da nadah tukud, ya am-in nadan mausal hi pangipataddogan. ");
INSERT INTO ifk_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Dida boy nangamung an mangipaptok nadan wadah dolan nan Tabernacle: nadan tukud, nadan pangipataddogan hi tukud, nadan paghok ya nadan mahapul an linubid. ");
INSERT INTO ifk_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ya hay mungkampu nah hinangngab nan Tabernacle nah nangappit hi timilan di algo ya nituddu ke da Moses ke Aaron ya nadan imbabalena. Diday mangingunu nadah nganneh diyen miat hidi nah Tabernacle ta munhilbi da nadah holag Israel. Hanan kumpulmin tagun mangipatnan mangiat ke dadiye ya mipipate. ");
INSERT INTO ifk_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Hay bilang am-in nadan linalakin holag Libay an nilistan ohay bulana ya nahawwal ya 22,000. Inat da Aaron ke Moses hinae mipuun hi intugun APU DIOS an aton da. ");
INSERT INTO ifk_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","Kanan APU DIOS ke Moses di “Am-in di linalakin panguluwan an holag Israel ya miong-ong ke ha-on. Kinali mahapul an ilista yuy ngadan nadan ohay bulan da ya nahawwal. Muden hay mangitakdog ke didan miong-ong ke ha-on ya nadan holag Libay. Ha-oy di AP-APU. Kalyok an miong-ong pay ke ha-on am-in di aggayam di holag Libay ta mihannot nadah mamangulun iimpan di aggayam di holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Inun-unud Moses ot bilangonan am-in nadan panguluwan an linalakin holag Israel mipuun hi tugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ya hay bilang dan am-in an panguluwan an linalakin holag Israel ya 22,273. ");
INSERT INTO ifk_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Iong-ong mun ha-on nadan holag Libay ta mihannot dan am-in hanadah panguluwan an linalakin holag Israel. Ya iong-ong mun ha-on am-in di aggayam dat mihannot nadah mamangulun iimpan di aggayam di holag Israel. Ha-oy di AP-APU. ");
INSERT INTO ifk_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ya nadan duwan gatut ta napitut tulun panguluwan an linalakin holag Israel an nahawwal hi bilang nadan holag Libay ya mahapul an mabayadan da. ");
INSERT INTO ifk_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Hay bayad di oha mipuun nah maunud an pumbayad ya liman kalang. ");
INSERT INTO ifk_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Hidiyen pihhun bayad da ya midat ke Aaron ya nadan imbabalena.” ");
INSERT INTO ifk_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ot amungon Moses di bayad dadiyen nahawwal an nihannotan nadan holag Libay ");
INSERT INTO ifk_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ya 1,365 kalang. ");
INSERT INTO ifk_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ot idat nan Aaron ya nadan linalakin imbabalena mipuun hi tugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Kinalin bon APU DIOS ke Moses ya hi Aaron ");
INSERT INTO ifk_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","an ilista dan am-in di holag Kohat mipuun hi nahlagan da ya pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ot bilangon dan am-in nadan linalakin damanan mungngunu nah Tabernacle an muntoon hi tulumpulu inggana nalima. ");
INSERT INTO ifk_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Hay ngunuwon da nah Tabernacle ya ipaptok da nadan nangilinan an ngunut. ");
INSERT INTO ifk_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Hanah pun-ottanan nadan holag Israel hi pungkampuwan da ya mahapul an humgop ni-an da Aaron ya nadan imbabalenat paluhon da nan kurtinan nihanih Kuwartun APU DIOS ta hophopan da nan Kahona. ");
INSERT INTO ifk_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ne ihophop da boy makaphod an lalat ne ahida intak-op di blue an luput ne induduk da nadan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ya nan lamesaan ya ap-apan dah blue an luput ne inha-ad dah di nadan duyu, nadan malukung an kiha-adan di miappit, nadan buhin kiha-adan nadan mainum miappit ya nadan tinapay an niha-ha-ad hidin miappit ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hophopan da dadiyeh maka-ingit an luput ne intak-op dan ihophop nan makaphod an lalat ne induduk da nadan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ya hophopan dah blue an luput nan pangipattukan hi dilag, nadan kingke, nadan pun-ipit, nadan ambilog an duyu ya nadan pangiha-adan hi lanan di oliba. ");
INSERT INTO ifk_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ne libbutan da datuweh makaphod an lalat ta iha-ad da nah pun-attangan. ");
INSERT INTO ifk_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ya mahapul an hophopan da damdamah blue an luput nan balituk an altar ya itak-op da kediyey makaphod an lalat, ne induduk da nan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Libbutan da boh blue an luput nadan ngunut nah Tabernacle ne inhophop da kediyey makaphod an lalat, ne inha-ad da nah pun-attangan. ");
INSERT INTO ifk_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Mahapul bon kaanon da nah altar nan dap-ul ya hophopan dah luput an purple. ");
INSERT INTO ifk_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Iha-ad dah di nadan ngunut an mausal nah altar umat hi pundalukduk hi bala, nadan tobong, nadan pala ya nadan palanggana. Ne inhophop dan dadiyey makaphod an lalat, ne induduk da nadan pun-attang. ");
INSERT INTO ifk_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ta hidiye nan kediyen pun-ottanan yun mungkampu ya mahapul an nagibbun hinophopan Aaron ya nadan imbabalena dadiyen am-in an nangilinan an ngunut ta ahi attangan nadan holag Kohat. Man-uke ya adinadaman eda dapaon dadiye, takon di oha, te mate da hin dapaon da. ");
INSERT INTO ifk_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hi Eleasar an imbabalen Aaron an padiy nangamung an mangipaptok am-in nah Tabernacle ya nadan nangilinan an mausal hidi, umat hi lanan di oliban miha-ad nadah kingke, nadan bangbanglu, nadan pagen miappit ya lanan di oliba. ");
INSERT INTO ifk_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Kinalin bon APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Hituwe boy ohan mahapul an maat ta adi mate nadan holag Kohat takon di mih-up da nah nangilinan an ngunut. ");
INSERT INTO ifk_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Makighop hi Aaron ya nadan linalakin imbabalena ke dida nah Tabernacle ta ituddu dan diday ngunuwon da ya hin nganney attangan da. ");
INSERT INTO ifk_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Te deket adida iathidi ya adinadaman humgop nadan holag Kohat nah Tabernacle te mate da hin tibon da nadan nangilinan an ngunut, takon di hingkatang.” ");
INSERT INTO ifk_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Ilistam am-in di holag Gershon an imbabalen Libay mipuun hi puun da ya pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ya bilangom am-in di linalakin damanan mungngunu nah Tabernacle an muntoon hi tulumpulu inggana nalima. ");
INSERT INTO ifk_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Diday mangdon ke datuwe: ");
INSERT INTO ifk_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","hanan Tabernacle, nan niatop an luput ya nan nitak-op an makaphod an lalat, nan kurtinah hogpan hi Tabernacle, ");
INSERT INTO ifk_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","nadan kurtina ya linubid nah dolan nan Tabernacle ya nan altar, nan kurtinah hogpan nah dola ya am-in nadan mausal hi pangitayunan hanadah kurtina. Dida boy mangiat nadah mahapul hi pangipaptok ke datuwe ten mit-an nadan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Hi Aaron ya nadan linalakin imbabalenay manibo hin at-atton nadan holag Gershon am-in di niukod ke didan aton da, umat nadan maat ten mun-ottan da weno nadan udum an ngunu. Ya ituddu dan dida hin nganney odnan da. ");
INSERT INTO ifk_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Danaey nitudduh ngunun nadan holag Gershon nah Tabernacle. Ya hi Itamar an imbabalen Aaron di ukod an mangitudduh ngunu da.” ");
INSERT INTO ifk_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Kanan bon APU DIOS ke Moses di “Ilistam am-in di holag Merari mipuun hi puun da ya pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ya bilangom am-in di linalakin damanan mungngunu nah Tabernacle an muntoon hi tulumpulu inggana nalima. ");
INSERT INTO ifk_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Diday mangdon hanadah kalkalimangngan nan Tabernacle umat nadah miballabag, ");
INSERT INTO ifk_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nadan tukud, nadan pangipataddogan hanadah tukud, nadan paghok, nadan linubid hi nunlinikkod nan Tabernacle ya am-in nadan mausal hi pangikapyaan ke dadiye. Waday ohan dida on nangamung nan mangiat nah nituddun ngununa. ");
INSERT INTO ifk_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Danaey natuddun ngunun nadan holag Merari nah Tabernacle. Hi Itamar an imbabalen Aaron di mangitudduh aton da.” ");
INSERT INTO ifk_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Da Moses ke Aaron ya nadan mangipangpangulu nadah holag Israel ya inun-unud day olden APU DIOS ot ilista dan am-in di linalakin holag Kohat, hi Gershon ya hi Merari an imbabalen Libay mipuun hi puun da ya pamilya da. Binilang dan am-in nadan damanan mungngunu nah Tabernacle an muntoon hi tulumpulu inggana nalima. Datuwey bilang di holag da: hi Kohat ya 2,750, hi Gershon ya 2,630, hi Merari ya 3,200. Hay bilang dan am-in ya 8,580. ");
INSERT INTO ifk_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Nilista dan am-in mipuun hi kinalin APU DIOS ke Moses an atona. Ya intuddu nah hin-oh-an diday ngunuwon da weno odnan da. ");
INSERT INTO ifk_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Itugun mu nadah holag Israel an pakaanon dah kampu da nadan tatagun waday katatakut an dogon di bolat dan mit-an ya nadan tatagun waday malpuh adol da ya nadan adi mibilang an malini te dinapa da weno nidatum dah nate. ");
INSERT INTO ifk_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mun-ingngon maat hituweh linalaki ya binabai an pakaanon yu dida nah kampu yu te adik pinhod an adi malini tun boblen pakiboblayak ke dakayun tataguk.” ");
INSERT INTO ifk_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Inun-unud nadan holag Israel di intugun APU DIOS ke Moses ot pakaanon da nah kampu da nadan mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Itugun mu datuwe nadah holag Israel: Hanan tagu, lalaki weno babain adina un-unudon hi APU DIOS ta atonay adi maphod hi ibbanan tagu ya mumbahul. ");
INSERT INTO ifk_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Mahapul an abulutonan numbahul ta bayadanay moltana nah tagun numbahulana ya udmanah duwampulun porsiento. ");
INSERT INTO ifk_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mu deket nate nan tagu ya maid di nih-up an iibanan pangidatan da nah bayad ya bagi mon APU DIOS hidiye, ta midat mo nadah papadi. Ya miunnud hituwen mibayad nah lakin kalneron maklong hi pangatan nan numbahul hi ine-en di punlini. ");
INSERT INTO ifk_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ya am-in di ialin nadan holag Israel an ibagin APU DIOS ya ibagin nan padin eda pangidatan. ");
INSERT INTO ifk_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ya am-in di midat nah padi ya ibagi na.” ");
INSERT INTO ifk_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Datuwey kinalin APU DIOS ke Moses ");
INSERT INTO ifk_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","an ituguna nadah holag Israel: Deket e nanibo nan babai hi udum an lalaki ");
INSERT INTO ifk_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ot ihuyop da, mu maid di tistigu te maid di nangakhup ke hiya ");
INSERT INTO ifk_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ya deket mun-annil nan inayan diyen babai weno mun-olom di ohan lalaki takon di maid di inat di inayanah gaga-iho ");
INSERT INTO ifk_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ya mahapul an ien nan lalaki nan inayana nah padi. Ya mahapul an umieh hingkilon alina, mu adina ha-adan hi mantekan di oliba weno bangbanglu te hidiye ya miappit hi punmahmahan di mun-annil an lalaki ta mainila hin numbahul nan inayana. ");
INSERT INTO ifk_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Hanan padi ya ena pataddogon nan babaih hinangngab nan altar. ");
INSERT INTO ifk_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ne umalah danum nah pula an buhi ya umala boh luta nah dulung nan Tabernacle ta pungkammohona. ");
INSERT INTO ifk_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Deket impresentan nan padi nan babai ke APU DIOS, ibukanay buuk diyen babai ne iha-ad na nan niappit an alinan in-appit nan lalakin mun-annil nah taklen diyen babai ta mainila hin makulug nan humlun an pun-annilan nan lalaki. Hanan padi ya tumaddog hi hinangngab nan babai ya odnanah diyen pula an buhi an niha-adan nan mumpait an danum an mangidut hi nabahulan. ");
INSERT INTO ifk_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Punsapataon nan padi nan babai ya kalyonan hiyay “Deket uggeka nakihuyop hi udum an lalaki ya maid di inat muh malalaon humlun hi eka mibilang an adi malini ya adi maat ke he-a tun idut. ");
INSERT INTO ifk_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mu deket nakihuyop kah udum an lalaki ya ");
INSERT INTO ifk_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","hana ot ta hituwen danum an umeh putum an umidut ya pumbalinon dakan adi pakaimbabale ta tibon di tatagun maat ke he-ay idut APU DIOS ta mapihul ka.” Ne humangon nan babaih diyen kananay “Abulutok hinaen maat.” ");
INSERT INTO ifk_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Itudok nan padih tuwen idut nah lalat, ne ahina bo inula nan nitudok nah mumpait an danum nah buhi. ");
INSERT INTO ifk_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ta ipainum nah babaih diyen danum an umidut ta munholholtap hin numbahul. ");
INSERT INTO ifk_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ne alan bon nan padi nan inodnan nan babain alinan niappit gapuh annil ta itagge nan ipresentana ke APU DIOS ta ahina ie nah altar. ");
INSERT INTO ifk_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ne gumamal nan padi kediyen alinat gobhonah di. Ne impainum na bo nah babai nan danum. ");
INSERT INTO ifk_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Deket nakihuyop nan babaih udum an lalaki ya holholtapona nan namahig an ligat an idat nan naidutan an danum ya mumbalin an adi pakaimbabale. Hay ngadana ya mumbalin an gaga-ihon kalin usalon di tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mu deket uggena inat di athidi ya mahlag te adi maat ke hiya nan idut. ");
INSERT INTO ifk_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Hinaey tugun mipanggep hi annil. Deket nakihuyop nan babaih udum an lalaki, ");
INSERT INTO ifk_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","weno mun-olom nan lalakin hay punnomnom na ya waday udum an lalakin nan inayana ya ie nat pataddogon nan padih hinangngab APU DIOS ta atonah tuwen tugun kediyen babai. ");
INSERT INTO ifk_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mibilang an maid di bahul nan lalaki, mu nan babai ya holtaponay kastiguna hin numbahul. ");
INSERT INTO ifk_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Datuwe boy kinalin APU DIOS an itugun Moses ");
INSERT INTO ifk_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","nadah holag Israel: Hanan lalaki weno babain mangisapatan pinhod nan mumbalin an Nasirite ta iong-ong nay adol nan APU DIOS ");
INSERT INTO ifk_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ya adi uminum an bumutong. Adi uminum hi ngannen mainum an nakapyah grapes ya adi mangan hi grapes ya raisins. ");
INSERT INTO ifk_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Maid nimpey inumona weno kanona hi ngannen nakapyah grapes, takon di buwana weno ukina. ");
INSERT INTO ifk_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Kediyen tiempon numbalin hidiyen taguh Nasirite, adinadaman paputul nay buuk na ya adina labahaon di emeng na mu padukkayona. Ya mahapul an punnanongonan aton nan insapatana ta mibilang an malini inggana mala-uh diyen tiempon insapatanan munhilbi ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ya kediyen punhilbiyanan APU DIOS ya adinadaman e mih-up hi naten tagu. ");
INSERT INTO ifk_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Takon hin kananat hi amana, hi inana ya tutulang nay mate ya adinadaman ena hibiton di adol na gapun dida. Te niong-ong ke Apu Dios ya hay kitib-ana ya nan buuk na. ");
INSERT INTO ifk_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Te deket insapatan di tagun mumbalin an Nasirite ya niong-ong ke APU DIOS ta mahapul an atona nan nitugun ke hiya. ");
INSERT INTO ifk_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Deket nahibit di buuk nan Nasirite te nipaldang nah tagun nabiglan nate, mahapul an labahaonay buuk na nah mikapitun algon pangiatanah ine-en di punlini ta ahi mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Hanah mikawalun algo ya iena nah padiy duwan paloma weno duwan balug nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ta iappit nan padiy oha gapuh liwat diyen tagu ya gobhona nan oha nah altar ta makaan di liwat nah nidattumanah nate. Ne kediyen algo ya ipidwana bon munsapata ke APU DIOS ya padukkayona boy buuk na. ");
INSERT INTO ifk_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ta ipidwanan iong-ong di adol nan APU DIOS ta mumbalin bon Nasirite. Man-uke ya maid di hilbin nan inat na handi te numbalin an adi malini. Ta hay mo atona ya umiappit hi hintoonan lakin kalnero gapuh bahul na. ");
INSERT INTO ifk_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Deket nagibbun inat nan Nasirite di insapatana, ume nah hogpan nah Tabernacle ");
INSERT INTO ifk_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ta ipresentanan iappit ke APU DIOS di ohan hintoonan lakin kalneron miappit an maghob, hay ohan hintoonan laban kalneron miappit gapuh liwat ya hay ohan lakin kalneron miappit an pakihayyupan ke APU DIOS. Dadiyen aggayam ya mahapul an maid di dipekto da. ");
INSERT INTO ifk_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Umiappit boh himbasket an tinapay an ugge naha-adan hi mumpalbag. Hanan mahdol ya makammohan hi mantekan di oliba ya nan maingpi ya maha-adan hi mantekan di olibah. Mahapul bon umiappit hi page ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ipresentan nan padi datuwen miappit ke APU DIOS ya mun-appit gapuh liwat ya mun-appit hi maghob. ");
INSERT INTO ifk_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ne ahina impresenta ke APU DIOS nan miappit hi pakihayyupan ke hiya an datuwe ya lakin kalnero, himbasket an tinapay ya nan page ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Labahaon diyen Nasirite di buuk na nah hogpan kediyen Tabernacle ta gobhona nah apuy hi da-ul nah punggohoban hi aggayam an miappit hi pakihayyupan ke APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ne iha-ad nan padiy ohan nalutun lapan di lakin kalnero ya nadan mahdol ya maingpin tinapay an ugge naha-adan hi mumpalbag hi takle na. ");
INSERT INTO ifk_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Itaggen nan padin ipresenta ke APU DIOS dadiyen midat an ibagin nan padi ta mid-um nah pago ya lapan nan kalnero. Deket nagibbuh diye ya uminum uppe nan Nasirite hi mainum. ");
INSERT INTO ifk_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Danaey tugun mipanggep hi miappit an un-unudon di Nasirite. Deket wada pay di kalyonah iappit nan mid-um ya damana. Mu mahapul an ipaannung na nan insapatana. ");
INSERT INTO ifk_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Kalyom ke da Aaron ya nadan imbabalenan athituy pumbendisyon da nadah holag Israel: ");
INSERT INTO ifk_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Hana ot ta bendisyonan dakayu ya ipaptok dakayun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ya ulayan dakayun hiya. ");
INSERT INTO ifk_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ya hana ot ta umamlong hi APU DIOS ke dakayu ya palinggopon dakayu.’ ");
INSERT INTO ifk_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Kanan bon APU DIOS di ‘Deket ngadanonak hi pumbendisyonan nadan padi nadah holag Israel ya bendisyonak dida.’” ");
INSERT INTO ifk_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ginibbun Moses an hina-ad nan Tabernacle ot atona nan ine-en di pangiong-ongan ke APU DIOS kediyen Tabernacle, nadan ngunut an mausal hidi, nan altar ya nadan mausal kediye. ");
INSERT INTO ifk_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hanadan aap-apun di holag Israel an munlista nadah tatagu ya ");
INSERT INTO ifk_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","in-ali day idat dan APU DIOS. Dadiye ya onom an kuliton ya himpulut duwan bulug an baka. Ohan kuliton di indat di duwan ap-apu ya hin-oh-an bulug an bakay indat di ohan ap-apu. Ot ipresenta da dadiye nah AP-APU nah hinangngab di Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Indani ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Abulutom datuwen indat da ta miusal hi ngannen ngunu tuh Tabernacle. Idat mu nadah holag Libay ta usalon dah ngunu da.” ");
INSERT INTO ifk_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ot idat Moses nadan kuliton ya nadan bulug an baka nadah holag Libay. ");
INSERT INTO ifk_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Indat nay duwan kuliton ya opat an bulug an baka nadah holag Gershon an mahapul dah ngunuda, ");
INSERT INTO ifk_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","opat an kuliton ya walun bulug an baka nadah holag Merari an mahapul dah ngunuda. Hay ap-apu dan mangitudduh ngunu da ya hi Itamar an imbabalen Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mu nada keh holag Kohat ya maid di indat Moses ke didah kuliton te adida mausal hi ngunu da. Man-uke ya diday mumpaptok nadah nangilinan an ngunut an mahapul an mipah-on. ");
INSERT INTO ifk_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Handih nidawatan nan altar ya in-alin nadan aap-apu dadiyen midat ot ipresenta dan inha-ad dah hinangngab nan altar. ");
INSERT INTO ifk_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Te kinalin tuwalin APU DIOS ke Moses di “Kalyom hanadah holag Israel an kabigabigat hi himpulut duwan algo ya ialin di ohan ap-apuy idat nan mausal hi pangiong-ongan nah altar.” ");
INSERT INTO ifk_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Hay nangialih idat na nah namangulun algo ya hi Nashon an imbabalen Amminadab hi holag Judah. Hanah mikadwan algo ya hi Nethanel an imbabalen Suar hi holag Issakar. Hanah mikatlun algo ya hi Eliab an imbabalen Helon hi holag Sebulun. Hanah mikap-at an algo ya hi Elisur an imbabalen Sedeur hi holag Reuben. Hanah mikaliman algo ya hi Selumiel an imbabalen Surishaddai hi holag Simeon. Hanah mikan-om an algo ya hi Eliasap an imbabalen Deuel hi holag Gad. Hanah mikapitun algo ya hi Elishama an imbabalen Ammihud hi holag Eplaim. Hanah mikawalun algo ya hi Gamaliel an imbabalen Pedahsur hi holag Manasseh. Hanah mikahiyam an algo ya hi Abidan an imbabalen Gideoni hi holag Benjamin. Hanah mikapulun algo ya hi Ahieser an imbabalen Ammisaddai hi holag Dan. Hanah mikahimpulut ohan algo ya hi Pagiel an imbabalen Okran hi holag Asher. Hanah mikahimpulut duwan algo ya hi Ahira an imbabalen Enan hi holag Naptali. Am-in da ya indat day hin-oh-an duyun silber an umeh hingkilot kagodway dam-ot na, ya hin-oh-an malukung an silber an umeh hingkiloy dam-ot na, mipuun hi maunud an pungkilo da. Napnu dadiyeh makaphod an alinan nakammohan hi mantekan di oliba. Hidiyey iappit dan page. Indat da boy hin-oh-an ittay an malukung an balituk an umeh 1/8 kiloy dam-ot na an naha-adan hi bangbanglun insenso, hay hin-oh-an ka-ongal nan lakin baka, hay ohan lakin kalnero, hin-oh-an hintoonan impan di kalneron miappit an maghob, ya hin-oh-an gulding an miappit gapuh liwat. Ya datuwe boy indat dah miappit hi pakihayyupan: hindudwan bulug an baka, hinlilman lakin kalnero, hinlilman gulding ya hinlilman hintoonan impan di kalnero. ");
INSERT INTO ifk_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Ot datuwey bilang am-in di indat nadan himpulut duwan aap-apun di holag Israel an miusal hi kiong-ongan nan altar. Himpulut duwan silber an duyu ya himpulut duwan silber an malukung an hay dam-ot da ya umeh tuluy pulun kilo. Himpulut duwan ittay an malukung an balituk an pangiha-adan hi bangbanglun insenso an hay ngam-ut di dam-ot da ya umeh hingkilot kagodwa. Ya hay in-ali dah miappit gapuh liwat ya himpulut duwan lakin baka, himpulut duwan lakin kalnero, himpulut duwan hintoonan impan di kalnero, nan alinan iappit dan pagen miunnud ke dadiyet maghob da, ya hay himpulut duwan gulding an miappit gapuh liwat. Hay in-ali dah boh miappit hi pakihayyupan ke APU DIOS ya duwampulut opat an lakin baka, nan-om an lakin kalnero, nan-om an lakin gulding, ya nan-om an hintoonan impan di kalnero. Dadiyey niappit hi nagibbuwan di niong-ongan nan altar. ");
INSERT INTO ifk_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Handih hinumgop hi Moses nah Tabernacle ta makihummangan ke APU DIOS ya dingngol nay kalina nah numbattanan nan duwan napaot an anghel nah tap-on nan kalub nan kahona. ");
INSERT INTO ifk_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Kanan nan AP-APU an Dios ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kalyom ke Aaron ta deket ipattuk na nadan dilag nah pangipattukan ya iphod nat madilagan di hinangngab na.” ");
INSERT INTO ifk_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Inun-unud Aaron ot ipahangngab na nadan dilag nah hinangngab nan pangipattukan da. ");
INSERT INTO ifk_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hidiyen pangipattukan hi dilag mipalpuh uduna ingganah puuna ya nakapyah balituk an naun-unud nan impatibon APU DIOS ke Moses an pangiun-unudana. ");
INSERT INTO ifk_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Appilom nadan holag Libay nadah ibba dan holag Israel ta atom di ine-en di punlini ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Waghikam didah danum an punlini ya ipalabaham di buuk hi ulu da ya adol da ya ipabalbal mun diday bulwati dat mibilang dan malini. ");
INSERT INTO ifk_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kalyom bon didan umiali dah ka-ongal nan lakin baka ya alinan nakamhan hi mantekan di oliba an miappit. Ya kalyom ke didan umiali dah kilaw an lakin baka ta iappit mu gapuh liwat. ");
INSERT INTO ifk_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ayagam am-in nadan holag Israel ne pataddogom nadan holag Libay nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ta ihakmon nadan holag Israel di takle dah ulun dadiyen holag Libay. ");
INSERT INTO ifk_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ne ipresentan Aaron didan mibilang an iong-ong nadan holag Israel ke ha-on ta diday mangat nadah ipangunuk. ");
INSERT INTO ifk_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ya dadiyen holag Libay ya ihakmo day takle dah ulun nadan duwan bulug an baka. Miappit di oha gapuh liwat ya miappit an maghob nan oha. Hidiyey ine-en di punlini nadah holag Libay. ");
INSERT INTO ifk_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Pataddogom didah hinangngab Aaron ya nadan imbabalenat miong-ong dan ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Athidiy atom an mangiong-ong nadah holag Libay te diday pinilik nadah ibba dan holag Israel ta bagik didan mangiat hi ngunuk. ");
INSERT INTO ifk_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Deket nagibbun inat muh diyen ine-en di punlini ke dida ya ipresentam didat damana mon humgop da nah Tabernacle ta aton da nadan ipangunuk ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Niong-ong nadan holag Libay ke ha-on te diday nihannot am-in hi panguluwan an lalakin imbabalen di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Man-uke ya bagik am-in di panguluwan an lalakin imbabalen di holag Israel takon nadan namangulun impan di aggayam da. Tinudduk tuwali didan bagik kediyen hilong an namatayak am-in hi panguluwan an lalakin imbabalen nadan iEgypt. ");
INSERT INTO ifk_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kinali nadan holag Libay di tudduwok an bagik ta mihannot da nadah panguluwan an lalakin imbabalen di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ya diday tinudduk hi am-in hi holag Israel an mangiat nah ituddun Aaron ya nadan imbabalenan ngunuwon da nah Tabernacle ta itakdog da nadan ibba dan holag Israel. Ya aton da nan ine-en di punlini ke didat maid di maat ke dida ten mih-up da nah Tabernacle.” ");
INSERT INTO ifk_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Inun-unud da Moses, hi Aaron ya nadan holag Israel nan intugun APU DIOS an aton da nadah holag Libay. ");
INSERT INTO ifk_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Hanadan holag Libay ya inat da nan ine-en di punlinih adol ya imbalbal day bulwati da. Ot ipresentan Aaron dida ke APU DIOS. Ot ahina aton nan ine-en di kakaanan di liwat dat mibilang dan malini. ");
INSERT INTO ifk_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Nipalpun diye ya umeume mo nadan holag Libay an mungngunu nah Tabernacle ta baddangan dah Aaron ya nadan linalakin imbabalena. Inun-unud dan am-in di intugun APU DIOS ke Moses an aton da. ");
INSERT INTO ifk_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Datuwe boy mahapul an un-unudon nadan holag Libay: Deket muntoon nadan linalakih duwampulut lima ya ilappu dan mungngunu nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ya itikod dan mungngunuh di ten muntoon dah nalima. ");
INSERT INTO ifk_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Deket dinatngan dah diyen toon ya bumaddang da mo ya abu nadah ibba dan holag Libay ta mungguwalya da nah Tabernacle, mu bokon diday mangiat nadah ngunu nah Tabernacle. Datuwey ituttudum an ingunun nadan holag Libay.” ");
INSERT INTO ifk_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Handih namangulun bulan hi mikadwan toon nipalpuh timmayanan nadan holag Israel ad Egypt ya kimmalih APU DIOS ke Moses nah adi maboblayan ad Sinai. ");
INSERT INTO ifk_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Kananay “Kalyom hanadah holag Israel ta aton day Piyestan di Nala-uwan di Anghel nah nagtud an tiempo. ");
INSERT INTO ifk_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Aton yuh nae mipalpuh mungkahilong hi mikahimpulut opat an algo kediyen bulan. Mahapul an paka-un-unudon yu nadan intugun kun aton yu mipanggep kediyen Piyesta.” ");
INSERT INTO ifk_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ot kalyon Moses nadah tatagun aton dah diyen Piyesta ");
INSERT INTO ifk_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","hi mahmahdom di mikahimpulut opat an algoh namangulun bulan hidi nah adi maboblayan ad Sinai. Ot aton nadan tataguh diye an inun-unud da nan intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mu wada day ugge naki-at kediye te dinapa day naten tagu ot mibilang dan adi malini ot ume dan Moses ke Aaron kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Kanan dan Moses di “Adi kami mibilang an malini te dinapa miy naten tagu, mu takon di athidi ya tipe anhan ta edakami iadin mun-appit ke APU DIOS ketuwen natuddun tiempo yaden man-u nadan ibbamin holag Israel te nun-appit da?” ");
INSERT INTO ifk_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Kanan Moses ke diday “Had-on yu inggana inilaok hin nganney kalyon APU DIOS hi mipanggep ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Indani ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Kalyom hanadah holag Israel an deket wada ke didad uwani weno hi udum hi algoy mibilang an adi malini nah tiempon di Piyestan di Nala-uwan di Anghel te dinapanay nate weno waday nangayan dat maid da kediyen nagtud an tiempo ya damanan aton dah diyen Piyesta ");
INSERT INTO ifk_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","nah mahmahdom di mikahimpulut opat an algo nah mihaynod an bulan. Ihda day dotag nan ka-ongal nan kalnero ya nan mumpait an nateng nah tinapay an ugge naha-adan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Mahapul an kanon dan am-in an maid di tod-an dan ihda dah kabiggatana. Maid di gi-uwon dah gunit nan aggayam an niappit ya un-unudon dan am-in nadan maunud ten aton dah diyen Piyesta. ");
INSERT INTO ifk_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mu nan tagun adi mangat kediye, takon di malini weno takon di maid di nangayana ya adi mo makid-um hanadah tataguk te uggeyak in-appitan kediyen natuddun tiempo. Ta hidiye nan holtaponay kastiguna gapun diyen liwat na. ");
INSERT INTO ifk_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Hanan hintaguwan an nakiboblen dakayun naminhod an mangat kediyen Piyesta ya damanan atona, ya mahapul an paka-un-unudona nan maunud an pangat. Takon di hintaguwan weno tonok an holag Israel ya mahapul an un-unudon dah diyen maunud an pangat.” ");
INSERT INTO ifk_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Handih nikapyaan nan Tabernacle ya dimma-ul nan kulabut ot hophopana nah mapat-al. Ya deket hilong on numbalin hidiyen kulabut hi kay apuy. ");
INSERT INTO ifk_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Athidiy oggan maat an deket mapat-al ya dimma-ul nan kulabut ya deket hilong on numbalin hi kay apuy. ");
INSERT INTO ifk_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","18","Ya deket timmap-o nan kulabut ya inilan nadan holag Israel an pinhod APU DIOS an mit-an da. Ta hidiye nan paluhon da nan kampu dat mit-an da ne ikapya da bo ten muntikod ya duma-ul nan kulabut. Mu deket munnananong nan kulabut nah Tabernacle ya inila dan pinhod APU DIOS an mihdi da nah nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Takon di mabayag di kiha-adan nan kulabut nah Tabernacle ya miha-ad dah din adida mit-an hi pungkampuwan dan un-unudon day pinhod APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Hin-udum on mabilang ya abuy algon kiha-adan nan kulabut nah Tabernacle. Ya deket in-olden APU DIOS an munnanong da nah nungkampuwan da on nunnanong dahdi mu deket in-oldenan mit-an da on inun-unud dat mit-an da. ");
INSERT INTO ifk_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Hin-uddum bo ya ohan hilong di kiha-adan nan kulabut nah Tabernacle on nit-an dah kabiggatana hin timmap-o. Takon di mapat-al weno hilong ya umga dat mit-an da ten timmap-o nan kulabut. ");
INSERT INTO ifk_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Mu adida mit-an takon di duwan algo, himbulan weno hintoon weno nahawwal hi hintoon hin adi tumap-o nan kulabut. Mu deke nimpet timmap-o on pinalu day kampu dat mit-an da. ");
INSERT INTO ifk_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Gapuh pangun-unud dan APU DIOS ya deke on pinalu day kampu da ya deke bo on ingkapya da ten hidiyey kinalin APU DIOS ke Moses an aton da. ");
INSERT INTO ifk_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kumapya kah duwan silber an tangguyub an pun-ayag hi tatagut maamung da ya hidiye boy usalon dan mangipainilan paluhon day kampu da. ");
INSERT INTO ifk_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Deket nipagangoh nal-ot dadiyen duwan tangguyub ya maamung am-in nadan tataguh kad-am nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mu deket ohan tangguyub ya abuy nipagango ya ammuna nadan mangipangpanguluh tataguy maamung hi kad-am. ");
INSERT INTO ifk_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ya deket muntikkotikkod di gangon nan tangguyub ya paluhon nadan nungkampuh nangappit hi timilan di algoy kampu dat mit-an da. ");
INSERT INTO ifk_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Hanah pidwanan kipagangowanan muntikkotikkod ya paluhon damdaman nadan nungkampuh nangappit hi south di kampu dat mit-an da. ");
INSERT INTO ifk_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mu deket maayagan am-in nadan tatagut maamung da ya dukdukkayyon dan pagangohan nan tangguyub. ");
INSERT INTO ifk_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Hanadan padin imbabalen Aaron ya abuy miabulut an mangipagango nah tangguyub. Ya mahapul an munnanong an un-unudon nadan mitun-ud an holag dah tuwe. ");
INSERT INTO ifk_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ya ipagango yu bo datuwen tangguyub ta pangipainila yun waday gubat ten waday buhul yun manggop hi boble yu ta mahapul an makigubat kayuh pundipendal yu. Baddangan dakayun ha-oy an AP-APU an Dios yu ta mihwang kayuh buhul yu. ");
INSERT INTO ifk_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ipagango yu bo nadan tangguyub yu nah tiempon pun-an-anlaan yu umat hi Piyestan di Natalak di Bulan weno nadah udum an piyesta. Ya ipagango yu boy tangguyub yu nah pun-appitan yuh maghob ya pakihayyupan ke APU DIOS. Hidiyen gangon di tangguyub di mangipanomnom ke dakayun APU DIOS. Ha-oy an AP-APU di Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Handih mikaduwampulun algoh mikadwan bulan hi mikadwan toon nipalpuh timmayanan nadan holag Israel ad Egypt ya timmap-o nan kulabut an wada nah Tabernacle ");
INSERT INTO ifk_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ot umga nadan holag Israel ta tumayan da nah adi maboblayan ad Sinai ot ituluy dan mange inggana nuntikod nan kulabut nah adi maboblayan ad Paran. ");
INSERT INTO ifk_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nit-an da te kinalin APU DIOS ke Moses an mit-an da. ");
INSERT INTO ifk_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Handih nit-an da ya nuntutun-ud dan immen namangulu nadan holag Judah ya nadan ibbada an impangulun Nashon an imbabalen Amminadab. ");
INSERT INTO ifk_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nitun-ud ke dida nadan holag Issakar an impangulun Nethanel an imbabalen Suar, ta ahi ");
INSERT INTO ifk_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","nadan holag Sebulun an impangulun Eliab an imbabalen Helon. ");
INSERT INTO ifk_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ot mitun-ud nadan holag Gershon ya holag Merari an nangdon nah pinalu dan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Nitun-ud nadan holag Reuben an impangulun Elisur an imbabalen Sedeur ya nadan ibba da. ");
INSERT INTO ifk_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Nitun-ud nadan holag Simeon an impangulun Selumiel an imbabalen Surishaddai ");
INSERT INTO ifk_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ot ahi nadan holag Gad an impangulun Eliasap an imbabalen Deuel ");
INSERT INTO ifk_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ot mitun-ud nadan holag Kohat an nahlag ke Libay an diday nangdon hanadah nangilinan an ngunut nah Tabernacle. Handih dimmatong da nah eda kit-anan an pungkampuwan da ya nikapya mo nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Nitun-ud damdama nadan holag Eplaim an impangulun Elishama an imbabalen Ammihud. ");
INSERT INTO ifk_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Nitun-ud bo nadan holag Manasseh an impangulun Gemaliel an imbabalen Pedahsur. ");
INSERT INTO ifk_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Nitun-ud bo nadan holag Benjamin an impangulun Abidan an imbabalen Gideoni. ");
INSERT INTO ifk_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ya hay nanguddidi ya datuwen guwalyan di holag Israel hi indoggan an impangulun di holag Dan an impangulun Ahieser an imbabalen Ammisaddai. ");
INSERT INTO ifk_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ot mitun-ud nadan holag Asher an impangulun Pagiel an imbabalen Okran. ");
INSERT INTO ifk_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ot nada uppen holag Naptali an impangulun Ahira an imbabalen Enan. ");
INSERT INTO ifk_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Athinay ine-en di naganodwaan nadan holag Israel nah nuntutun-udan dah nangayan dah eda nit-anan. ");
INSERT INTO ifk_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ohan algo ya kanan Moses nah aydunan hi Hobab an imbabalen Jethro an iMidian di “Ume kami nah boblen kinalin nan AP-APU min idat nan dakamin holag Israel. Maki-ali kan dakami ta idatan dakah kiphodam te kinalin APU DIOS an idat nay kiphodan min tataguna.” ");
INSERT INTO ifk_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Mu kanan Hobab di “Adiyak maki-alin dakayu. Mahapul an mibangngadak nah pamilyak hi boble mi.” ");
INSERT INTO ifk_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kanan bon Moses ke hiyay “Daan mo anhan ta adim iathina. Maki-ali ka ot ya abu, ta he-ay mangipangpangulun dakamih emi pungkampuwan nah adi maboblayan, ");
INSERT INTO ifk_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ta idatan daka nadah dakol an kiphodan min idat APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ot mundallan dah tulun algo mipalpu nah Bilid an Sinai. Namangulu nan Kahon APU DIOS ta deket nuntikod ya hidiy pungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Deket mangmangnge da nah mapat-al on mipottok ke dida nan kulabut. ");
INSERT INTO ifk_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ya deke bot inumga dat eda umen in-attang da nan Kahon APU DIOS on kanan Moses di “APU DIOS, deyan umga taku bo. Em pabtikon ya em iwahit nadan buhul mun humingit ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Deket dimmatong da nah pungkampuwan dat inha-ad day kampu da on kanan Moses di “APU DIOS, mibangngad ka bon dakamin kalibulibun holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Indani ya inlappun nadan holag Israel an mundiklamu ke APU DIOS gapu nadah punligatan da. Dingngol APU DIOS di diklamu da ya bimmoh-ol ot paaliyonay apuy ot malgab di pangngel di nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Muntukod nadan tatagu ke Moses ta baddangana dida ot mundasal ke APU DIOS ot mad-op nan apuy. ");
INSERT INTO ifk_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Hidiyen nungkampuwan da ya nginadanan dah Taberah. Hay kibalinana ya “Mun-aapuy an boble” te immaliy apuy APU DIOS ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Indani ya hapulon nadan udum an tatagun naki-e nadah holag Israel nadan maphod an makan an wadad Egypt, umat hi dotag. Ya takon nadan holag Israel ya mundiklamu da damdaman kanan day “Wada kumay dotag an ihda taku. ");
INSERT INTO ifk_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Hidid Egypt ya pinhod taku key dolog on wada ya libli pay. Dakol pay di bihu-ut, melon, nunhihinnatkon an danggu, ya amput! ");
INSERT INTO ifk_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mu ad uwani ya immi-ingle taku mo anhan hi manna. Abunay manna an kanokanon takuh kabigabigat!” ");
INSERT INTO ifk_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Hanan manna ya kay ittay an buwa an adi makabbayak. ");
INSERT INTO ifk_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Mag-a dadiye nah hilong nah nungkampuwan nadan holag Israel ta deket nabigat on inamung da. Ne bayuwon dat mumbalin an kay naubud an boga ne inha-ang da weno kapyaon dah tinapay. Ya hay tamtam na ya kay naha-adan hi mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Dongdonglon Moses an kahididiklamu nadan tatagun naamung nah hogpan hi kampu da ya mabulun te bimmobboh-ol hi APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ot kananan APU DIOS di “Tipet athituy pangat mun ha-on an muttatyum an paligatonak? Ya nganney inat kun balawom ta ha-oy di em nangiukodan hantudah dakol an tatagun athitu? ");
INSERT INTO ifk_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bokon ha-oy di nunlutun dida ya bokon ha-oy di ammod da! Tipet eyak mumbalin hi kay mun-abban didat iek dida nah boblen kinalim an idat mu handidah aammod mi? ");
INSERT INTO ifk_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Daanay ek pangal-an hi dakol an dotag an ipahidak ke datuwen dakol an tatagu? Takon anhan ot dumaniklamu dan bumagabaga dah dotag. ");
INSERT INTO ifk_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Adik kabaelan an ohhaan an mangipaptok ke dida. Makaliggatanak an abu! ");
INSERT INTO ifk_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Deket athituy pangat mun ha-on ya kudukdul nay patayonak ke he-a ta adiyak munholholtap hi umat hitu. Ya deket umipaamlongak ke he-a ya adiyak anhan paligligaton.” ");
INSERT INTO ifk_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Kimmalih APU DIOS ke Moses an kananay “Umayag kah napitun mangipangpangulu nadah holag Israel ta maamung da nah Tabernacle hi kad-am. ");
INSERT INTO ifk_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Umaliyak ta kumaliyak ke he-ah di. Ya wadaok ke dida nan Espiritun umat hi winadak ke he-a ta baddangan dakan didan mangipaptok nadah tatagu ta adim ohhaan. ");
INSERT INTO ifk_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Kalyom hanadah tatagun mahapul an aton da nan ine-en di punlini te ha-oy an AP-APU ya dingngol kuy diklamu dan kanan day ‘Wada kumay dotag an ihda taku ya kudukdul di biyag takud Egypt.’ Kinali wadaok hi bigat di dotag ya mahapul an kanon da. ");
INSERT INTO ifk_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Bokon ya abu hin-algo weno duwan algo weno lima weno himpulu, weno duwampulun algo mu mahapul ");
INSERT INTO ifk_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","an kanon dah kabigabigat hi himbulan inggana makahhingla dat kay da mo umuta. Man-uke ya dehtuwak bo tuwali yaden iwalongak ta deyan mundiklamu dan ha-on an kanan day ‘Tipe tuwalit etaku timmayan ad Egypt?’” ");
INSERT INTO ifk_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mu kanan Moses ke APU DIOS di “Hay bilang am-in hantudan tatagu ya onom an gatut di libu ya em kanan di idatam didah dotag hi himbulan. ");
INSERT INTO ifk_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Takon hin kananat kolngon min am-in di aggayam mi, kon umustu ke didan am-in? Ya takon hin dopapon min am-in di dolog nah baybay, kon e umustun dida?” ");
INSERT INTO ifk_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ot kanan APU DIOS ke Moses di “Kon malkud di kabaelak? Ad uwaniy panib-am hin umannung di kalyok weno adi!” ");
INSERT INTO ifk_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ot e kalyon Moses nadah tatagu nan kinalin APU DIOS. Inayaganay napitun mangipangpangulu nadah holag Israel ot ena pataddogon didah nunlinikkod nah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ya immalih APU DIOS nah kulabut ot kumalin Moses. Winada na ke dadiyen napitun tatagu nan Espiritun umat hi winadana ke Moses. Indani ya umat da nadah profetas, mu kediye ya abuy nangatan dah athidi. ");
INSERT INTO ifk_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Hanadan duwa an da Eldad ke Medad an nakilista nadah napitun tatagu ya wadadah kampu da te uggeda imme nah Tabernacle mu nun-abig da damdamah di nah kampu da handih nawadan dida nan Espiritu. ");
INSERT INTO ifk_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Wada on kat-agun bintik na ot ena kalyon ke Moses an da Eldad ke Medad ya dehdi dah kampu dan mun-abig da. ");
INSERT INTO ifk_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Hanan imbabalen Nun an hi Joshua an kabaddang Moses nipalpu handih kaungana ya kananan Moses di “Ipatikod mu dida, apu!” ");
INSERT INTO ifk_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mu kanan Moses di “Adika kumakkagu ke ha-on. Kon adi ot kuma maphod hin wadaon APU DIOS am-in hi tatagunay Espiritunat mumbalin dan am-in hi profetas?” ");
INSERT INTO ifk_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ot mibangngad hi Moses ya nadan napitun mangipangpanguluh kakampu da. ");
INSERT INTO ifk_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Indani ya impaalin APU DIOS di dibdib an nangialih dakkodakkol an hamutin nalpu nah baybay. Ot umpa da nah luta ya nipu-ul dah tulun piyey katag-ena ya naap-apan di ambilog nah nungkampuwan nadan holag Israel umat hi kabilog di dallanon hi hin-algo. ");
INSERT INTO ifk_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ot ito-ol nadan tataguy alan in-al-algo da ya inhilhilong da ot ial-algo da boh kabiggatana. Ta hay inalan di hin-oh-an dida ya umeh naliman bushel. Ot eda pun-iha-ad nah nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mu indanit pun-ihda da nadan hamuti ya impaalin APU DIOS ke diday himpappangen dogo te bimmobboh-ol ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ot matey dakol ke dida ot ngadanan dah diyen nungkampuwan da hi “Kibrot Hattaabah.” Hay kibalinana ya “Kilubukan nadan nahpuh dotag” te inlubuk dah di nadan tatagun nundiklamu mipanggep nah makan an idaidat APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Indani ya timmayan nadan holag Israel hidi ot ume dad Haserot ot mungkampu dah dih nabayag. ");
INSERT INTO ifk_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Da Miriam ke Aaron ya imbaag dah Moses handih wada dad Haserot te Kushite di inayana. ");
INSERT INTO ifk_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Indani ya kanan day “Kon hi Moses ya abuy kumaliyan APU DIOS? Kon ugge damdama kimmalih APU DIOS ke dita?” Ya dingngol APU DIOS hidiyen kinali da. ");
INSERT INTO ifk_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Hi am-in an tagu tuh luta ya maid di umat ke Moses an napakumbaba.) ");
INSERT INTO ifk_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Pinghana di dingngol APU DIOS hidiye ya impaayag nah Moses, hi Aaron ya hi Miriam ot kananan diday “Ekayun tulu nah Tabernacle!” Ot ume dan tulu. ");
INSERT INTO ifk_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Indani ya dimma-ul hi APU DIOS nah kulabut an kay tukud nah hogpan hi Tabernacle. Ot ayagana da Aaron ke Miriam. Inun-unud da ot ume dan duwah kad-ana. ");
INSERT INTO ifk_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kanan APU DIOS ke diday “Donglon yu tun kalyok! Deket waday pinhod kun kalyon hanadah profetas ya ipainilak ke didah in-inop. ");
INSERT INTO ifk_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mu hi ke Moses an muttatyuk ya adi athidi te in-ukod kun hiyan am-in di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Kinali makihinnangngabak an makihummangan ya idilitsuk di pinhod kun kalyon ke hiya. Ta kayak tinibon hiya. Tipet adi kayu tumakut an mangibaag ke hiya?” ");
INSERT INTO ifk_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ot taynan APU DIOS didan bimmoh-ol. ");
INSERT INTO ifk_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Indani ya nawaday leprosy ke Miriam an numbalin an mabayak di bolat na handih timmayan nan kulabut nah tap-on nan Tabernacle. Tinibon Aaron an waday himpappangen dogon di bolat Miriam ");
INSERT INTO ifk_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ya kananan Moses di “Apu, adi dakami anhan kastiguwon gapu ketuwen numbahulan min uggemi impakannomnom ot aton mi. ");
INSERT INTO ifk_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Tibom anhan ta adi mumbalin hi Miriam an umat nah nitungon golang an naten mungkabuluk mo tuwalih naukatana.” ");
INSERT INTO ifk_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ot mundasal hi Moses ke APU DIOS an kananay “Paphodom, anhan Apu Dios hi Miriam!” ");
INSERT INTO ifk_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ya himmumang hi APU DIOS an kananan Moses di “Kon kanana ket tinuppaan amanay angana ya kon adina itpolan di ba-inah pitun algo? Kinali idawwi yu nah kampuh pitun algo. Nala-u keh diyen hinlingguwan ya damanan mibangngad nah kampu.” ");
INSERT INTO ifk_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Indawwi dah Miriam nah nungkampuwan dah pitun algo ot uggeda nadlig inggana imbangngad dah Miriam nah kampu da. ");
INSERT INTO ifk_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Timmayan dah did Haserot ot ume da nah adi maboblayan ad Paran ot mungkampu da boh di. ");
INSERT INTO ifk_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Piliyom di hin-oh-a nadah himpulut duwan holag Israel ta diday ipaem an e munsiim nah bobled Kanaan an idat kun dakayu.” ");
INSERT INTO ifk_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ot aton Moses di kinalin APU DIOS. Intud-ak nay himpulut duwan linalakin mangipangpangulu nadah holag Israel an inumga dah did Paran an nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Datuwey ngadan da: hi Sammua an imbabalen Sakkur hi holag Reuben, ");
INSERT INTO ifk_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","hi Saphat an imbabalen Hori hi holag Simeon, ");
INSERT INTO ifk_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","hi Kaleb an imbabalen Jephunneh hi holag Judah, ");
INSERT INTO ifk_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","hi Igal an imbabalen Joseph hi holag Issakar, ");
INSERT INTO ifk_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","hi Hoshea an imbabalen Nun hi holag Eplaim, ");
INSERT INTO ifk_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","hi Palti an imbabalen Raphu hi holag Benjamin, ");
INSERT INTO ifk_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","hi Gaddiel an imbabalen Sodi hi holag Sebelun, ");
INSERT INTO ifk_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","hi Gaddi an imbabalen Susi hi holag Manasseh an imbabalen Joseph, ");
INSERT INTO ifk_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","hi Ammiel an imbabalen Gemalli hi holag Dan, ");
INSERT INTO ifk_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","hi Sethur an imbabalen Michael hi holag Asher, ");
INSERT INTO ifk_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","hi Nahbi an imbabalen Bopsi hi holag Naptali, ");
INSERT INTO ifk_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ya hi Geuel an imbabalen Maki hi holag Gad. ");
INSERT INTO ifk_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Danae nadan intud-ak Moses an e nunsiim nah boblen pangayan da. Ketuwen tiempo ya hinannotan Moses di ngadan Hoshea an imbabalen Nun hi Joshua. ");
INSERT INTO ifk_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Handih nangitud-akan Moses ke dida ya kananan diday “Ume kayuh nangappit hi north an mundalan kayud Negeb inggana nah nangappit hi south di Kanaan ya madagga kayu nah mabilid an boble. ");
INSERT INTO ifk_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ta tibon yuy ine-en diyen boble ya nadan bimmoble hin dakol weno oh-ohha da ya hin nal-ot da weno adi. ");
INSERT INTO ifk_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","20","Tibon yu boy ine-en nan boble hin maphod weno adi. Ya tibon yu hin naalad weno ugge. Tibon yu bo nan luta hin maluwab di mitanom weno adi ya hin dakol di kaiw. Ya deket mibangngad kayu ya adiyu ilah-on umianamut hi bungan di bungbunga-an hidi.” (Kediyen tiempo ya nalappuwan an mal-um di grapes.) ");
INSERT INTO ifk_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Imme dadiyen linalaki ot impalpu dan nun-ang-ang nah adi maboblayan ad Sin hidid Kanaan ingganad Rehob an nih-up ad Hamat. ");
INSERT INTO ifk_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Numpae da ni-an nah nangappit hi north ot mundalan dad Negeb ot ahida umed Hebron an numboblayan da Ahiman, hi Seshai ya hi Talmai an holag di o-ongal an tatagun kanan dan Anakim. (Hay Hebron di namangpangulun nakapyan boble hi pitun toon ot ahiy Soan an bobled Egypt.) ");
INSERT INTO ifk_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Handih imme da nah nundotal an kanan dan Eskol ya immala dah himpulngut an grapes ya makaddam-ot ta mahapul an iattang di duwan tagu. Ya immala da boh pomegrenate ya fig ot ianamut da. ");
INSERT INTO ifk_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Nginadanan dadiyen holag Israel hidiyen nundotal hi Eskol an hay kibalinana ya napulngut, te hidiy nangal-an da nah himpulngut an grapes. ");
INSERT INTO ifk_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Nala-uy nap-at an algon nunsiiman da ot mibangngad ");
INSERT INTO ifk_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","dad Kades ad Paran an kawad-an da Moses ke Aaron ya nadan ibbadan holag Israel. Kinali da nadan inanang-ang da ya impatibo da nadan bungan in-anamut da. ");
INSERT INTO ifk_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kanan dan Moses di “Imme kami nah boblen nangitud-akam ke dakami ya tinibo min makaphod ya makatmol ya maluwab di mitanom hidi ya dakol di iyyukan, ya dehtu day in-anamut min bungan inilpu mihdi. ");
INSERT INTO ifk_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mu nadan tatagun numbobleh di ya nungkal-ot da ya ambilog di boble da ya nahamad di alad na. Ya katatakut te wada day o-ongal an tataguh din holag Anak. ");
INSERT INTO ifk_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Hanadan iAmalek ya numboble dad Negeb. Ya nadan Hittite, Jebusite ya Amorite ya numboble da nah mabilid hidi. Ya nadan iKanaan ya numboble dah pingngit di baybay ya nadah pingngit di Wangwang an Jordan.” ");
INSERT INTO ifk_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mundiklamu nadan holag Israel ke Moses mu impadin-ong Kaleb didan kananay “Etaku ot ta etaku gubaton dida ta ditakuy mumbobleh di ot nunna-ud an apputon taku dida.” ");
INSERT INTO ifk_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mu nadan ibbanan e nunsiim ya kanan day “Adi taku man anhan pakaapput ke dida te matibon ongal di kabaelan da mu ditaku.” ");
INSERT INTO ifk_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ot ihinap da nan adi makulug mipanggep nah boble nadah ibba dan holag Israel. Kanan day “Adi maphod nan luta te kumudang di ibungan di mitanom hi kanon am-in di mumbobleh di. Ya o-ongal nadan tatagun numbobleh di. ");
INSERT INTO ifk_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Dehdi da bo udot nadan giant an holag Anak. Ta hay panibo mih adol mi ya kay kami ba-atong an i-itay ya nunna-ud an athidi damdamay panibo dan dakami.” ");
INSERT INTO ifk_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Kinali kediyen hilong ya namahig di kogan nadan holag Israel te maid moy namnama da. ");
INSERT INTO ifk_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ot mundiklamu dan Moses ya hi Aaron an kanan day “Kudukdulnay nate kamid Egypt weno hituh adi maboblayan! ");
INSERT INTO ifk_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Tipe e ditaku in-alin APU DIOS tuh boblet ekami mateh gubat ta alan day iinayan mi ya iimbabale mi ta pumbalinon da didan himbut? Kudukdul nay mibangngad takud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Indani ya waday oha on kananay “Mumpili takuh mangipangulun ditakut mibangngad takud Egypt.” ");
INSERT INTO ifk_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ot mundukkun da Moses ke Aaron hi hinangngab nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ya hi Joshua an imbabalen Nun ya hi Kaleb an imbabalen Jephunneh an naki-en e nunsiim ya binik-i day bulwati da gapuh hakit di nomnom da. ");
INSERT INTO ifk_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Kanan da nadah tataguy “Makakkaphod nan boblen emi tinibo. ");
INSERT INTO ifk_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Deket paamlongon takuh APU DIOS ya ie ditakun malinggop nah boblen idat nan ditakun makatmol ya maluwab di mitanom ya dakol di makan ya iyyukan. ");
INSERT INTO ifk_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Adi taku ot e ngohayon hi APU DIOS. Adi taku tumakut nadah tataguh di te nunna-ud an apputon taku dida. Dida ke ya maid di mangihwang ke dida, mu ditaku ke ya wadah APU DIOS an mamaddang ke ditaku kinali adi taku tumakut.” ");
INSERT INTO ifk_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Indani ya e tugmilan ot nadan tatagu dida mu kal-inadi ya numpatiboh APU DIOS ke didan am-in an humihhiliy hiyona nah Tabernacle an pundayawan da. ");
INSERT INTO ifk_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Indani ya kimmalih APU DIOS ke Moses an kananay “Antipe anhan ta nanongnan ngohayonak hantudah tatagu? Ya tipe anhan ta maid di dinol dan ha-on takon di tinibotibo day inainat kun milagro. ");
INSERT INTO ifk_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ad uwani ya ipaalik di dogo ta madadag datuwen tatagu ta he-ay punholagok hi dakkodakkol ya idatan dakah ongal an kabaelan mu dida!” ");
INSERT INTO ifk_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mu nakihummangan hi Moses ke hiya an kananay “APU DIOS, inilan nadan iEgypt an impakaan mu datuwen tataguh boble da gapuh ongal an kabaelam. Ya deket atom di athinat donglon da ya diday mangipainila ");
INSERT INTO ifk_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","nadah numbobleh tu kenaen atom. Dingngol dan he-a APU DIOS ya numpatibo kan dakami ya wada ka nah kulabut an mipottok ke dakami nah mapat-al ta ipangpangulu dakami ya deket hilong on mumbalin hidiyen kulabut hi apuy ta panilag mi. ");
INSERT INTO ifk_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Muden deket athinay atom an dadagom am-in hantudan tatagum ya pangalin nadan tataguh udum an boblen nangngol hi mipanggep ke he-a ya nan ongal an kabaelam an hay ");
INSERT INTO ifk_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","gapunan pinatem nadan tatagum nah adi maboblayan ya adim kabaelan an padatngon dida nah boblen kinalim an idat mun dida. ");
INSERT INTO ifk_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Kinali idasal ku APU DIOS an ipatibom anhan di pangi-em an hidiye handin kinalim an kanam di: ");
INSERT INTO ifk_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ha-oy an Dios ya adiyak nalakan bumoh-ol ya ongal di pamhod kun dakayu ya kal-iwan di liwat yu ya ngohe yu. Mu adik kal-iwan di liwat yu ta ahik kastiguwon di imbabale yu, hay inap-apu yu, ya hay imbabale da inggana nah inap-apu da.’ ");
INSERT INTO ifk_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kinali gapu nah ongal an pamhod mu, APU DIOS, ya idasal kun kal-iwam di liwat datuwen tatagu umat hi inat mun dida nipalpu handih nanayanan mid Egypt.” ");
INSERT INTO ifk_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Hinumang APU DIOS an kananay “Takombo, kal-iwak di liwat da teden imbagam ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mu ha-oy an wadat nangamung ya madayaw an Dios ya isapatak an ");
INSERT INTO ifk_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","maid ke diday matagun e dumatong kediyen boble. Te takon di tinibo dad Egypt ya nah adi maboblayan di dayaw ku ya nadan inat kun adi kabaelan di tagu ya kapyanan adida un-unudon di tugun kut patnaan day anus kun dida. ");
INSERT INTO ifk_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Kinali adinadaman e wadan diday dumatong nah boblen kinalik an idat ku handidah aammod da. Te adinadaman e makidatong nadan tatagun adi mangun-unud ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mu hi Kaleb an muttatyuk an nanongnan ongal di dinol nan ha-on ya hiya ya abuy makidatong hidi nah boblen ena siniim ta mumboble nadan holag nah di. ");
INSERT INTO ifk_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Adi kayu mumpae nah nundotal an numboblayan nadan iAmalek ya iKanaan te hi bigat ke ya mumpae kayu nah adi maboblayan nah nangappit hi Maingit an Baybay.” ");
INSERT INTO ifk_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kanan bon APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Maid di poppog nay diklamun datuwen tatagu ke ha-on ta deyan immingleyak mo anhan. ");
INSERT INTO ifk_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Kalyon yun didah tuwe: ‘Nunna-ud an atok ke dakayu nadan dingngol kun kinali yun maat ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ta mate kayun am-in an nabilang handih numbilangan yun muntoon hi duwampulu ya nahawwal hituh adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Man-u te kinalik handi an hidiy eda pumboblayan mu adi mo nadama. Ammunah Kaleb an imbabalen Jephunneh ya hi Joshua an imbabalen Nun di makidatong hidi. ");
INSERT INTO ifk_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ya nadan imbabale yun kanan yuy alan di buhul yu ya diday ipadatong ku kediyen boblen pinihul yu ta diday mumbobleh din mun-am-amlong da. ");
INSERT INTO ifk_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mu dakayun aammod da ya mate kayuh tuh adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Didan imbabale yuy munholholtap hituh adi maboblayan hi nap-at an toon ta humanawwangan da gapuh uggeyu nangun-unudan hi tugun ku inggana maid di matdaan ke dakayu takon di oha. ");
INSERT INTO ifk_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Hanan nap-at an algon eyu nunsiiman ad Kanaan ya pumbalinok hi nap-at an toon an punligatan yu gapuh liwat yu ta hiktaman yuy boh-ol kun dakayu.’ ");
INSERT INTO ifk_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Makulug an athidiy atok nadah gaga-ihon tatagun nungngohen ha-on ta mate dan am-in tuh adi maboblayan. Ha-oy an AP-APU di nangalin tuwe.” ");
INSERT INTO ifk_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Hanadan intud-ak Moses an e nunsiim ot idatdatong day adi makulug ot humlun hi nundiklamuwan nadan tatagu ya impundogon APU DIOS dida ot mate da. ");
INSERT INTO ifk_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ot ammuna da Joshua an imbabalen Nun ya hi Kaleb an imbabalen Jephunneh di nanongnan matagu nadah himpulut duwan e nunsiim. ");
INSERT INTO ifk_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Indani ya kinalin Moses nadah tatagu nan kinalin APU DIOS ya namahig an u-umyung da. ");
INSERT INTO ifk_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kanan day “Om, abuluton min numbahul kami. Kinali nundadaan kamin ume nah boblen insapatan APU DIOS an idat nan ditaku.” Ot mungkabigat ya inumga dan ume da nah mabilid an bobled Kanaan. ");
INSERT INTO ifk_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mu kanan Moses ke diday “Kon inat yu keh nae ya kon inun-unud yuh APU DIOS nah kananan mibangngad kayu nah adi maboblayan? Maid di hilbina! ");
INSERT INTO ifk_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Adi kayu ot ume! Te adi dakayu baddangan ke hiya. Nunna-ud an maapput kayuh ");
INSERT INTO ifk_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","eyu pakigubatan hanadah iAmalek ya iKanaan ta pumpate dakayun dida. Man-uket adi dakayu baddangan ke APU DIOS ya te uggeyu inun-unud.” ");
INSERT INTO ifk_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mu impilit nadan tatagun ume da nah mabilid an boble yaden uggeda intabin nan Kahon APU DIOS ya ugge naki-eh Moses. ");
INSERT INTO ifk_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Indani ya immali nadan iAmalek ya iKanaan an numbobleh di ot apputon da dida ya numpudug da dida ingganad Hormah. ");
INSERT INTO ifk_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Kalyom hituwe nadah ibbam an holag Israel: Deket dumatong kayud Kanaan an idat kun pumboblayan yu ");
INSERT INTO ifk_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ta mun-appit kayun ha-on hi maghob an umipaamlong ke ha-on an AP-APU ya mahapul an dadiye ya aggayam yun kalnero, gulding ya baka. Mu deket mun-appit kayuh maghob gapuh insapata yu, weno ingnguddan yun mun-appit weno nan iappit yuh katootoon nah piyesta ya ");
INSERT INTO ifk_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","mahapul an maunnudan hi duwan kilon makaphod an alinan naha-adan hi ohan litron mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Hay miunnud hi ohan ka-ongal nan kalneron miappit an maghob ya ohan litron mainum. ");
INSERT INTO ifk_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Deket lakin kalneroy miappit an maghob ya maunnudan hi duwan kilon alinan nad-uman hi dandanin ohat kagodwan litron mantekan di oliba ");
INSERT INTO ifk_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ya dandanin ohat kagodwan litron baya an miappit an mainum. Ta ha-oy an AP-APU ya umamlongak gapu nah nabanglun hamuy da. ");
INSERT INTO ifk_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Deket kilaw an lakin bakay miappit an maghob gapuh insapata weno gapuh pakihayyupan ke APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","mahapul an maunnudan hi tulun kilon alinan nakammohan hi opat an litron mantekan di oliba ");
INSERT INTO ifk_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ya hay duwan litron mainum. Ta umamlongak gapuh hamuy da. ");
INSERT INTO ifk_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Datuwey mahapul an maunud nah pun-appitan hi kilaw an lakin baka weno lakin kalnero ya ka-ongal nan kalnero weno gulding. ");
INSERT INTO ifk_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Athidiy aton yuh hin-oh-a ke dadiyen aggayam an iappit yu. ");
INSERT INTO ifk_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mahapul an am-in kayun holag Israel ya un-unudon yu datuwe hi am-in nah pun-appitan yun ha-oy an AP-APU ya umamlongak gapu nah nabanglun hamuy na. ");
INSERT INTO ifk_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Takon nadan nalpuh udum an boblen nakiboblen dakayu ya mahapul an un-unudon da datuwen maunud nah pun-appitan dah maghob ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Dakayun tonok an holag Israel ya nadan tataguh nalpuh udum an boblen nakiboblen dakayu ya mahapul an un-unudon yu datuwen tugun an maun-unud ta nangamung. Man-uke ya nun-iingngo kayuh pangibilang ku. ");
INSERT INTO ifk_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mun-ingngoy tugun an un-unudon yun holag Israel takon nadan nakiboblen dakayu.” ");
INSERT INTO ifk_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Kalyom datuwe nadah holag Israel: Deket wada kayu mo kediyen boblen pangieyak ke dakayu ");
INSERT INTO ifk_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ya mahapul an waday appilon yuh iappit yun ha-on an Dios yu nadah makan an bungan di nitanom hidi. ");
INSERT INTO ifk_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Deke bot mangapya kayuh tinapay an malpu nah pakaani yu ya mahapul an umappil kayuh miappit umat hi aton yu nadah mamangulun maanin intanom yu. ");
INSERT INTO ifk_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mahapul an mun-appit kayuh katootoon ke dadiyen tinapay an kapyaon yu nah namangulun inani yu. ");
INSERT INTO ifk_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Deket waday ugge nangun-unud nadah Tugun kun indat kun Moses, ");
INSERT INTO ifk_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ya hin kananat wadadah holag yuh udum hi algoy adi mangun-unud ke datuwen Tugun, ");
INSERT INTO ifk_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","mu uggeda ingnguddan ya ugge ininnilan am-in nadan holag Israel hidiye ya mahapul an iappit dan maghob di ohan kilaw an lakin baka. Ya unnudan dah alina ya mainum ta umamlongak gapuh nabanglun hamuy na. Ya mahapul bon mun-appit dah ohan lakin gulding gapuh liwat da. ");
INSERT INTO ifk_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Iappit nan padi dadiyeh pangatana nah ine-en di punlini ta pakawanak di nunliwatan dan am-in an bimmoble te uggeda ingnguddan ya te nun-appit dan ha-on hi maghob ya nun-appit da gapuh liwat da. ");
INSERT INTO ifk_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Takon nadan nakiboblen dida ya nilagat dan am-in nah uggeda ingnguddan an nunliwatan da mu kal-iwak di liwat da gapu ke dadiyen miappit. ");
INSERT INTO ifk_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kal-ina ket oha nan nunliwat an uggena ingnguddan ya hay iappit na gapuh liwat na ya ohan hintoonan gulding an laba. ");
INSERT INTO ifk_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Iappit nan padi ke ha-on an AP-APU hidiyen iappit nan tagu ta kal-iwak di liwat na. ");
INSERT INTO ifk_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Hinaen tugun ya mahapul an un-unudon am-in di holag Israel ya nadan nakiboblen dida te nilagat dan am-in kediyen ugge ningnguddan an liwat. ");
INSERT INTO ifk_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Deket ingnguddan nan holag Israel weno nan nakiboblen didan nunliwat ya hidiyey kitib-anan ngohayonak ta hidiye nan adida makid-um hanadah tataguk ");
INSERT INTO ifk_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","te imbilang nan maid di hilbinay tugun ku ot ingnguddanan ugge inun-unud. Kinali hiya pey kombahul hi kakastiguwana.” ");
INSERT INTO ifk_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Handih kawad-an nadan holag Israel nah adi maboblayan ya wada on naakhupan an e nangaiw yaden Sabadun Tungo. ");
INSERT INTO ifk_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ot alan da ot ie dah kad-an da Moses ke Aaron ya nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Impaguwalya da ni-an ta nangamung di ipainilan APU DIOS hi aton dan hiya. ");
INSERT INTO ifk_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Indani ya kanan APU DIOS ke Moses di “Mahapul an mateh diyen nunliwat. Ta hidiye nan ie yuh diyen taguh e-elen di nungkampuwan yu ta tugmilan yuh dit mate.” ");
INSERT INTO ifk_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Inun-unud nadan holag Israel di intugun APU DIOS ot ie dah diyen tagu nah e-elen nan nungkampuwan da ot tugmilan da ot mate. ");
INSERT INTO ifk_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Kanan bon APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Kalyom bo nadah tatagu ta ha-adan day bulwati dah baluybuy an nabobod hi tinulid an blue. Mahapul an munnanong an athidiy ahi aton di holag yuh udum hi algo. ");
INSERT INTO ifk_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mangipanomnom ke dakayu nadah tugun ku ten in-ang-ang yu ke datuwen baluybuy di bulwati yu. Ta un-unudon yu ta bokon nadan pinpinhod yuy aton yu, dadiye bo udot nadan daydayunan aton yu. ");
INSERT INTO ifk_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ta nomnomon yun un-unudon datuwen Tugun ku ta adiyu kal-iwan an dakayuy tataguk. ");
INSERT INTO ifk_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ha-oy di AP-APU an Dios yu! Impakaan dakayun ha-on ad Egypt ta dayawonak. Ha-oy di AP-APU an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ohan algo ya nuntutuggun da Korah an imbabalen Ishar an holag Kohat an imbabalen Libay, ya nadan holag Reuben an da Dathan ke Abiram an imbabalen Eliab ya hi On an imbabalen Peleth ");
INSERT INTO ifk_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","an ngohayon dah Moses. Indani ya nid-um ke diday duwan gatut ta naliman mangipangpangulu nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Imme dah kad-an da Moses ke Aaron ot kanan dan diday “Hogla bo kayah naen at-atton yu. Inila taku met an wadah APU DIOS ke ditakun am-in. Ya tipet hay punnomnom yuh adol yu ya natagtag-e kayu mu hantudan tatagun APU DIOS?” ");
INSERT INTO ifk_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Handih dingngol Moses ya nunlukbub nah luta ot mundasal. ");
INSERT INTO ifk_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ot ahina kanan ke Korah ya nadan ibbanay “Ipainilan APU DIOS hi biggatnah bigat hin dahdi ke ditakuy tinuddunan muttatyu na ya hin dahdin ditakuy makaphod hi hinangngab na. Ta nan piliyonan ditaku ya ipaenah kad-ana. ");
INSERT INTO ifk_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Kinali he-a Korah ya mahapul an athituy aton yu nadah ibbam. Hi biggatna ya umala kayun am-in hi pangighoban hi insenson iappit yun APU DIOS. Ya ha-adan yuh insenson gobhon yu ta ie yu nah pun-appitan ke APU DIOS. Ta tibon taku hin dahdiy piliyonan makaphod. Hay kakulugana ya dakayun holag Libay di hoglan mumpahhiya!” ");
INSERT INTO ifk_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kanan bon Moses ke Korah di “Donglom hituwe, dakayun holag Libay! ");
INSERT INTO ifk_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kon kulangon yuy inat APU DIOS an hi am-in hanadah holag Israel ya dakayun holag Libay di tinuddunan mih-up ke hiya nah pangatan yu nadah ngunu yuh Tabernacle ya ekayu tumaddog hi hinangngab nadan tataguh pangatan yu nadah kiphodan da? ");
INSERT INTO ifk_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Dakayu ya abu ya nadan ibbam an holag Libay di nangidatana kenaen ngunu, mu pinhod yun dakayu pay di mumpadi. ");
INSERT INTO ifk_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hi APU DIOS di nginohe yun nadah ibbam te kon dahdih Aaron ta hiyay pundiklamuwan yu?” ");
INSERT INTO ifk_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Impaayag Moses da Dathan ke Abiram an imbabalen Eliab mu kanan day: “Adimi pinhod an umali! ");
INSERT INTO ifk_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tipe Moses, kon kudang nan inat mun impakaan dakamid Egypt an makatmol ya matabay mitanom ya dakol di makan ya iyyukan ot iali dakamih tuh adi maboblayan ta patayon dakami? Ag-agam, pinhod mu pay an he-ay mun-ap-apun dakami. ");
INSERT INTO ifk_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hay oha bo ya ugge dakami in-e nah boblen makatmol di nitanom ya dakol di makan ya iyyukan. Ya daan bo nan kinalim an idat mun dakamin luta ya payo? Kon tuwali ot inlangkakan dakami. Adi kami man umali!” ");
INSERT INTO ifk_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Indani ya bimmoh-ol hi Moses ot mundasal ke APU DIOS an kananay “APU DIOS, idasal kun adim anhan abuluton di iappit datuwen tatagu ke he-a. Maid di gaga-ihon inat kun dida ya maid di inalak hi aggayam da yaden athituy aton dan ha-on.” ");
INSERT INTO ifk_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kanana bon Korah di “Mahapul an umali kayun am-in hanadah ibbam nah pundayawan hi bigat. Takon hi Aaron ya umali. ");
INSERT INTO ifk_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Umiali kayu nimpen am-in hi pangighoban hi insenson duwan gatut ta nalima ya ha-adan yuh insenso ta iappit yu nah AP-APU nah pun-appitan. Takon hi Aaron ya umiali damdamah iappit na.” ");
INSERT INTO ifk_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ot umiali dan am-in hi pangighoban an hina-adan dah bala ya insenso ot makitaddog dan da Moses ke Aaron nah hogpan hi Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hi Korah di nanuttudu nadah ibbanan ngohayon dah Moses ya hi Aaron. Handih naamung dan am-in ot tumaddog da nah hogpan nah Tabernacle ya kal-ina di ya numpatiboy dayaw APU DIOS ke didan am-in. ");
INSERT INTO ifk_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Kimmalih APU DIOS an kanana ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mibata-an kayun dida ta dadagok didad uwani.” ");
INSERT INTO ifk_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mu nunyuung da Moses ke Aaron ot mundasal dan hiyan kanan day “Apu Dios an kalpuwan di biyag, kon deket numbahul di ohan tagu ya ilagat mun boh-olan am-in hantudan ibbada?” ");
INSERT INTO ifk_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Kalyom hanadah tatagut mibata-an dah kampun da Korah, hi Dathan ya hi Abiram.” ");
INSERT INTO ifk_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ginalgal-an Moses an immeh kampun da Dathan ke Abiram ya niunud nadan aap-apun di holag Israel ke hiya. ");
INSERT INTO ifk_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kananan diday “Ume-ele kayu ta mibata-an kayuh kampun datuwen gaga-ihon tatagu ya tibon yu ta maid di dapaon yuh ngunut da. Ta adi kayu milagat an makikaten dida gapuh nunliwatan da.” ");
INSERT INTO ifk_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ot mibata-an nadan tataguh kampun da Korah, hi Dathan ya Abiram. Limmah-un da Dathan ke Abiram, nadan inayan da, nadan iimbabale da takon nadan goggolang an imbabale da ot tumaddog dah pottok di hogpan hi kampu da. ");
INSERT INTO ifk_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kanan Moses di “Hituwey panginilaan yun hi APU DIOS di nanuddun ha-oy an mangiat ke datuwe, bokon ha-oy di kon nomnom. ");
INSERT INTO ifk_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Deket mate datuwen tatagun bokon gapuh kastigun APU DIOS ke dida ya hidiyey kitib-anan uggeyak tinuddun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mu deket maat ke dida on umipamodwong an naala ya naunug da nah luta takon nadan ngunut dat ume dad dalom nah lubuk ya hidiyey panginilaan yun inwalong dah APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Nagibbun kimmalih Moses ya pinghanadi ya nadhak nan lutan timmaddogan da ");
INSERT INTO ifk_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ot maunug da takon nadan pamilya da ya iiba da. Athidiy naat an naunug nadan ibban Korah ya nadan pamilya da takon nadan nganneh diyen wadan dida. ");
INSERT INTO ifk_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Matagu dan naunug hi kad-an di nungkakate. Nakiunug am-in di wadan dida ot ahi bo mundammu nan luta ot mama-id da. ");
INSERT INTO ifk_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Hanadan holag Israel an wadah din nangngol hi pokaw da ya namtik da. Pun-itkuk day “Bumtik taku te indani ya milagat taku.” Indani ya impaalin APU DIOS di apuy ot maghob ");
INSERT INTO ifk_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","nadan duwanggatut ta naliman nun-appit hi insenso. ");
INSERT INTO ifk_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kalyom ke Eleasar an imbabalen Aaron an padi ta ena amungon nadan punggohoban hi insenson inusal nadan naten linalaki. Ya kalyom ta ena iwahit nadan mumbabalan insensoh e-elen nan kampu te nangilinan dadiyen punggohoban hi insenso ");
INSERT INTO ifk_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","an inusal dadiyen linalakin nate gapuh liwat da. Ya kalyom ta kapyaona dadiyen punggohoban hi maingpin mitakap nah pun-appitan ta mumbalin an warning nadah holag Israel. Dadiyen punggohoban hi insenso ya nangilinan te nipresenta dan ha-on an Dios.” ");
INSERT INTO ifk_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ot amungon Eleasar an padi nadan duwanggatut ta naliman punggohoban hi insenso ot kapyaonah mitakap nah pun-appitan an inun-unud nay kinalin APU DIOS ot kalyon Moses ke hiya. ");
INSERT INTO ifk_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hidiyey mangipanomnom hanadah holag Israel an maid di udum, ammuna nadan holag Aaron di mabalin an munggohob hi insenson miappit ke APU DIOS. Te deket nalgom an taguy umeh din munggohob hi insenso ya madadag umat ke Korah ya nadan ibbana. ");
INSERT INTO ifk_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mu handih nabigatana ya mundiklamu bo nadan tatagu ke da Moses ke Aaron an kanan day “Pinate yu nadan udum an tatagun APU DIOS.” ");
INSERT INTO ifk_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Kediyen naamungan dah pundiklamuwan da ke da Moses ke Aaron ya tinibo da nah pundayawan nan humihhilin hiyon APU DIOS nah kulabut an nihophop hidi. ");
INSERT INTO ifk_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","E timmaddog da Moses ke Aaron nah hogpan hi Tabernacle ");
INSERT INTO ifk_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ya kimmalih APU DIOS ke Moses an kananay ");
INSERT INTO ifk_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Mibata-an kayu hantudah tatagu ta dadagok dida!” Mu nunlukbub da Moses ke Aaron nah luta ta pangipatibo dan tumakut dan APU DIOS te pakallispituwon da. ");
INSERT INTO ifk_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ot kanan Moses ke Aaron di “Gal-am ta em alan nan pangighoban hi insenso ya ha-adam hi bala nah altar ya hay insenso ta ume kah kad-an nadan tatagut iappit mun APU DIOS gapuh liwat da. Bimmoh-ol mo anhan hi APU DIOS ke dida ot ipaalinay dogo ta deyan nilappun mungkakate da.” ");
INSERT INTO ifk_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Inun-unud Aaron ot ena alan nan pangighoban hi insenso ot butikanan immeh gawwan nadan tatagu. Tinibo nan nilappuy dogo nadah tatagu mu nun-appit hi maghob an insenso ke APU DIOS gapuh liwat da. ");
INSERT INTO ifk_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ot matikod nan dogo ta ena imama-uwan ya dehdin timmaddog hi numbattanan nadan matagu ya nadan nungkakate. ");
INSERT INTO ifk_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Hay bilang nadan tatagun nate ya himpulut opat di libu ta pituy gatut mu ugge nakibilang nadan naten ibban Korah. ");
INSERT INTO ifk_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ot mibangngad hi Aaron hi kad-an Moses nah hogpan hi Tabernacle te natikod mo nan dogo. ");
INSERT INTO ifk_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Indani ya kimmali boh APU DIOS ke Moses an kananay ");
INSERT INTO ifk_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kalyom hanadah himpulut duwan mangipangpanguluh holag Israel ta umidat dah hin-oh-ah patanong ke he-a. Ya itudok muy ngadan da nah patanong da. ");
INSERT INTO ifk_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Hana keh patanong nan mangipangpanguluh holag Libay ya itudok muy ngadan Aaron. Mahapul an wadan am-in di patanong nadan aap-apun di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ipaghop mu dadiyen patanong nah Tabernacle nah kuwartun kawad-ak an oggan ta pundammuwan ta iha-ad muh hinangngab nan Kahon an niha-adan nan nitudok an Tugun ku. ");
INSERT INTO ifk_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ahi humaping di patanong nan tagun piliyok ta matikod di pundiklamuwan nadan ibbam an holag Israel ke he-a gapu kediyen ahik aton.” ");
INSERT INTO ifk_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ot kalyon Moses nadah tatagu ot umidat nadan himpulut duwan mangipangpanguluh holag Israel hi hin-oh-an patanong ke Moses takon hi Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Inha-ad Moses am-in dadiyen patanong hi bohongnan di Tabernacle nah hinangngab nan Kahon an niha-adan nan nitudok an Tugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Handih nabigat ot humgop hi Moses nah Tabernacle ya tinibonan himmaping nan patanong Aaron an nangitakdog hi holag Libay ya waday bunganan almond an nal-um. ");
INSERT INTO ifk_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Inalanan am-in nadan patanong ot ena ipatibo nadah ibbanan holag Israel ot tibon da nan naat nah patanong Aaron. Ot ibangngad na dadiyen patanong nadah mangipangpangulu. ");
INSERT INTO ifk_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Kanan APU DIOS ke Moses di “Ibangngad muy patanong Aaron hi hinangngab nan Kahon an niha-adan nan nitudok an Tugun kut mangipanomnom hanadah mungngohen tatagun deket adida itikod an mundiklamu ya mate da.” ");
INSERT INTO ifk_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ot aton Moses hidiyen kinalin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Kanan nadan tatagu ke Moses di “Kay kami metlaing nate! Te nunna-ud an mate kami ");
INSERT INTO ifk_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ten mih-up kami nah Tabernacle. Kinali kay kami metlaing nate!” ");
INSERT INTO ifk_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Kanan APU DIOS ke Aaron di “He-a ya nadan imbabalem ya nadan iibam an holag Libay di mabahulan hi ngannen maat tuh Tabernacle. Mu deket mipanggep hi mihallah punhilbiyan yun papadi ya dakayun nadah imbabalem ya abuy mabahulan. ");
INSERT INTO ifk_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Damanan ayagan yu nadan iiba yun holag Libay an bumaddang ke he-a ya nadan imbabalem hi pangatan yu nadah maat hituh hinangngab nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Mu tibon yu ta adida dapaon nadan ngunut an nangilinan takon nan pun-appitan nah pangatan dah ngunu da te deket dapaon da ya mate kayun am-in. ");
INSERT INTO ifk_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mahapul bon makid-um dan dakayuh pangatan da nadah ngunu dan mangipaptok tuh Tabernacle, mu adinadaman waday bokon holag Libay an e makid-um ke dakayun mungngunu. ");
INSERT INTO ifk_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Hay ngunu yu nadah imbabalem ya ipaptok yu nan Tabernacle ya nan altar. Deket un-unudon yu datuwen tugun ku ya adiyak mo bumoh-ol ke dakayun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ha-oy mismuy numpili nadah ibba yun holag Libay hi am-in hanadah holag Israel ta bumaddang dan dakayu. Niong-ong dan ha-on an AP-APU ta mungngunu dah tuh Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mu mahapul an he-a ya nadan imbabalem mismuy mangiat nadah ngunun di padi nah altar ya nah kawad-ak. Hanan ngunun di padi ya indat kun regalok ke dakayu. Mu nadan udum an tatagun umalin mih-up tuh kad-ak ya mate da.” ");
INSERT INTO ifk_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Datuwe boy intugun APU DIOS ke Aaron: “Dakayun papadiy pinilik an mangiappit nadah iappit nadan holag Israel ke ha-on ya idatan dakayu ta nangamung hi bingay yu ke dadiyen iappit da. ");
INSERT INTO ifk_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Midatan kayu nadah miappit an adi maghob, nadah miappit an page, nadah miappit gapuh liwat ya nadah miappit gapuh bahul. ");
INSERT INTO ifk_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Deket kanon yu danae ya nomnomon yun niong-ong ke ha-on. Ya ammunay linalakin mangan ke danae. ");
INSERT INTO ifk_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ya midatan pay bo nadah udum an iappit nadan holag Israel an itagge dan ipresenta ke ha-on. Damanan kanon nadan imbabalem an linalaki ya binabai. Mu ammuna nadan mibilang an maliniy mabalin an mangan ke dadiye. ");
INSERT INTO ifk_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Idat ku bon dakayu nan kapkaphodan an mantekan di oliba, kapkaphodan an mainum, kapkaphodan an page ya nadan mamangulun bungan di intanom da. ");
INSERT INTO ifk_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Am-in dadiyen ialin nadan ibba yun holag Israel ke ha-on ya bagi yu. Mu ammuna nadan mibilang an maliniy mangan kediye. ");
INSERT INTO ifk_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ya am-in di inguddan dan iappit ke ha-on ya bagi yu. ");
INSERT INTO ifk_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Am-in boy panguluwan an linalakin imbabalen nadan ibba yun holag Israel takon nadan mamangulun impan di aggayam dan in-ong-ong dan ha-on ya bagi yu. Ta hidiye nan dakayuy mangala nah ibayad dah pamangngadan da nadah panguluwan an linalakin imbabale da ya nadan ibayad da nadah namangulun lakin impan di aggayam dan adi malini. ");
INSERT INTO ifk_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Hay golang an himbulana ya liman kalang di mibayad hi pamangngadan dan hiya, mipuun nah maunud an mibayad. ");
INSERT INTO ifk_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mu adinadaman mabangngad nadan namangulun impan di baka, kalnero ya gulding. Te bagik dadiyen nangilinan an miappit ke ha-on. Iwaghik yuy dala da nah pun-appitan ya gobhon yuy taba dat miappit dan maghob ke ha-on ta umamlongak hi hamuy da. ");
INSERT INTO ifk_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Bagi yuy dotag dadiye umat hi pago ya kannawan an lapan dadiyen mipresentan miappit ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Idat ku nimpen he-a ya nadan holag mun linalaki ya binabain am-in di niong-ong an iappit nadan ibba yun holag Israel ke ha-on. Hituwen kinalik ya munnanong an adinadaman mibabawi weno e mabaliwan.” ");
INSERT INTO ifk_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ot kanan bon APU DIOS ke Aaron di “Man-uke ya adi dakayu idatan an papadi hi lutan tawidon yu te ha-oy an AP-APU di mialig an tawid yu. ");
INSERT INTO ifk_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hanada ken ibbam an holag Libay ya idat kun dida nan mikapulun lumuwon am-in di holag Israel an iappit dan ha-on ta hidiyey tangdan dah pungngunuwan dah tuh Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ya mipalpud uwani ya adinadaman maka-ih-up nah Tabernacle nadan ibba yun holag Israel an bokon holag Libay ya bokon padi te makastigu dat mate da. ");
INSERT INTO ifk_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Dida ya abuy mungngunuh tu ta deke pet waday nihallah inat da ya diday kon bahul. Hituwey olden an munnanong ta nangamung an adi mabaliwan. Ya maid di midat ke didah tawidon dah luta da. ");
INSERT INTO ifk_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Te hay idat kun dida ya nan mikapulun iappit am-in di holag Israel. Kinali maid di tawidon dah luta da.” ");
INSERT INTO ifk_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Kinalin APU DIOS damdama ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Itugun muh tuwe nadah holag Libay an deket dawaton day mikapulun limmun nadan ibba dan holag Israel an dadiyey idat kun tawid da ya mahapul an iappit dan ha-on damdamay mikapulun dadiyen dawaton da. ");
INSERT INTO ifk_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hidiyen iappit dan ha-on ya paddungna nan mamangulun page weno mainum an iappit nadan ibba dan holag Israel ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Hidiyen iappit da damdaman ha-on an mikapulu nadah dawaton dah mikapulun limmun nadan ibba yun holag Israel ya idat dan Aaron an padi. ");
INSERT INTO ifk_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mahapul an iappit dan ha-on nadan kapkaphodan an dawaton da. ");
INSERT INTO ifk_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Hanadan kapkaphodan an iappit dan ha-on ya paddungna nan mamangulun page weno mainum an iappit nadan ibba dan holag Israel ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Hanadan udum an dawaton da ya damanan kanon da nadah pamilya dah kumpulmin lugar te binokla da dadiyeh pungngunuwan dah Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Adida mabahulan hi panganan dan dadiye ten in-appit dan ha-on di kapkaphodan. Mu mahapul an adida hibiton dadiyen iappit di ibba dan holag Israel ke ha-on. Te deket nalgom di pangat da ya mate da.” ");
INSERT INTO ifk_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Kanan bon APU DIOS ke da Moses ke Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Kalyon yu nadah holag Israel hituwen Tugun kun dida: Mahapul an umiali dah maingit an bakan laba an maid di dipektona ya uggena ni-an pinatnaan an nungngunu ");
INSERT INTO ifk_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ta idat dan Eleasar an padi. Mahapul an mieh e-elen nan nungkampuwan dat kolngon dah hinangngab na. ");
INSERT INTO ifk_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ne umalah Eleasar hi dalan diyen bakat itdok nay gamat nat iwaghik nah mamimpituh nangappit hi hinangngab nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Miappit an maghob hidiyen bakah hinangngab Eleasar an adi madaut ta makighob di bolat na, hay lamana, dalana, ya putuna. ");
INSERT INTO ifk_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ne umalah Eleasar hi kaiw an sedar, hay hapang di hissop ya hay maka-ingit an tinulid ta pakighob na nah baka. ");
INSERT INTO ifk_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Deket nagibbuh diye ya balbalanay bulwatina ya mun-amo ta ahi mabalin an humgop nah kampu, mu munnanong an mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mahapul an balbalan damdaman nan tagun nunggohob nah bakay bulwatina ya mun-amo, mu munnanong an mibilang an adi malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ne alan nan tagun mibilang an malini nan dap-ul nan bakan naghob ta ena iha-ad nah mibilang an malini nah e-elen di kampu. Ta usalon di holag Israel hi pangatan da nah ine-en di punlinin ikamo dah danum. Hidiyen aton dan ine-en di punliniy mangaan hi liwat da. ");
INSERT INTO ifk_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Hanan tagun mangala nah dap-ul ya mahapul an balbalanay bulwatina, mu munnanong an adi mibilang an malini inggana hilong. Munnanong an maunud ta nangamung hinaen tugun hanadah holag Israel ya nadah udum an tatagun nakiboblen dida. ");
INSERT INTO ifk_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Hanan tagun manapah adol di naten tagu ya mibilang an adi malinih pitun algo. ");
INSERT INTO ifk_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ta mahapul an atona nan ine-en di punlini nah mikatlu ya nah mikapitun algo ta mibilang bon malini. Mu deket adina aton ya adi mo mibilang an malini takon di nala-uy pitun algo. ");
INSERT INTO ifk_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Hanan tagun adina aton di ine-en di punlini yaden dinapanay adol di nate ya hibitona na nan Tabernacle ta hidiye nan adi mo makid-um hanadah tataguk. Ta munnanong an adi malinih diyen tagun ugge niduyag ke hiya nan danum an punlini. ");
INSERT INTO ifk_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Deket waday mate nah ohan abung nah kampu ya mibilang an adi malini nan tagun wadah di hi pitun algo, takon nan tagun humgop hidi. ");
INSERT INTO ifk_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Am-in di buhi weno bangan ugge nahukapan an wadah di ya mibilang an adi malini. ");
INSERT INTO ifk_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Hanan tagun manapah napate weno nate nah e-elen di boble ya mibilang an adi malini, takon nan tagun mundapah gunit di nate weno lubuk ya mibilang damdaman adi malinih pitun algo. ");
INSERT INTO ifk_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Deket wada on tagun mibilang an adi malinin mangat hi ine-en di punlini ya alan nan tagun mibilang an malini nan dap-ul nan naghob an bakat iha-ad nah buhi ya duyaganah danum. ");
INSERT INTO ifk_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ne hidiyen tagu ya umalah hapang di hissop ta itam-ol na nah danum ta iwaghik na nah abung nan tagun adi malini ya am-in nadan nganneh diyen wadah di takon di tatagu. Ya waghikan nan tagun dinapanay gunit di nate, hay napate weno nate ya hay lubuk. ");
INSERT INTO ifk_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Dadiyen mibilang an adi malini ya mawaghikan da nah mikatlu ya mikapitun algo. Ya nan tagun nawaghikan ya balbalanay bulwatina ya mun-amo nah mikapitun algo ta hi kahilongana ya mibilang an malini. ");
INSERT INTO ifk_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mu nan tagun mibilang an adi malini yaden adina aton di ine-en di punlini ya adi mo makid-um hanadah tataguk te hinibit na nan Tabernacle ya munnanong an adi mo malini te uggena dinuyagan di adol nah danum an punlini. ");
INSERT INTO ifk_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Mahapul an maat ta nangamung hituwen ine-en di punlini. Hanan tagun mangiwaghik nah danum an punlini ya mahapul an ibalbal na damdamay bulwati na. Ya nan tagun manapa nah danum an punlini ya adi mibilang an malini inggana hilong. ");
INSERT INTO ifk_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ya am-in di dapaon nan tagun mibilang an adi malini ya adi mo mibilang an malini ya nan tagun manapan dadiye ya mibilang an adi malini inggana hilong.” ");
INSERT INTO ifk_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Handih namangulun bulan ya dimmatong nadan holag Israel ad Sin an adi maboblayan ot mungkampu dad Kades. Kediyen wada dah di ya nateh Miriam ot milubuk hidi. ");
INSERT INTO ifk_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Maid di danum hidi ot hanggaon nadan tatagu da Moses ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Mundiklamu dan Moses an kanan day “Kudukdul nay nakikate kami nadah ibba takun pinaten APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Tipet edakami ingkuyug hituh adi maboblayan ta ekami maten am-in, takon di hay aggayam mi? ");
INSERT INTO ifk_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ya tipe tuwalit edakami impangulun tumayan ad Egypt ta etaku umali tuh boblen maid di tummol hi mitanom? Daan hituy pangal-an hi boga, nateng ya bungbunga-an? Ya maid boy danum an inumon!” ");
INSERT INTO ifk_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tinaynan da Moses ke Aaron nadan tatagu ot eda tumaddog nah hogpan hi Tabernacle, ot munlukbub da nah luta. Indani ya numpatibo nan humihhilin hiyon APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Alam nan patanong nah hinangngab nan Kahon ta amungon yun Aaron am-in nadan tatagu. Deket naamung kayu ya kimmali ka nah batu ta bumudal di danum. Ta waday inumon nadan tatagu ya nadan aggayam da.” ");
INSERT INTO ifk_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Inun-unud Moses hidiye ot ena alan nan patanong an niha-ad nah kad-an APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ot amungon dan Aaron nadan tataguh kad-an nan batu. Kanan Moses di “Donglon yu ke, dakayun mangohen tatagu. Kon ipilit yun pabudalon di danum ketuwen batu?” ");
INSERT INTO ifk_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ot ihoplat na nan patanong hi numpidwa nah batu ya mamuddal di dakol an danum ot uminum nadan tatagu, takon nadan aggayam da. ");
INSERT INTO ifk_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mu bimmoh-ol hi APU DIOS ke da Moses ke Aaron. Ot kananan diday “Gapu te uggeyak inun-unud ot uggeyak impadayaw kediyen inat yu ya bokon dakayuy mangidatong nadah ibba yun holag Israel nah boblen kinalik an idat kun dida.” ");
INSERT INTO ifk_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Hidiy nundiklamuwan nadan tatagu ke APU DIOS ot mangadanan hi Meribah. Hidi boy nangipatib-an APU DIOS an hiya ya limpiyu ya maandong di pangat na. ");
INSERT INTO ifk_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Handih wada da Moses ad Kades ya immitud-ak hi e makihummangan nah patul di Edom. Kanan day “Hituwey kinalin nadan iibam an holag Israel: Inilam anhan ot namahig di nunholholtapan mi. ");
INSERT INTO ifk_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Numboble handidan aammod mid Egypt hi nabayag ya impunholholtap di iEgypt dida takon di dakami. ");
INSERT INTO ifk_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ot mumpahpahmok kamin APU DIOS ya dingngol nay numpahpahmokan mi ot itud-ak na on anghel an nangimpangulun dakamin timmayan hidi. Ot dehdi kamid Kades an poppog tun bobleyu. ");
INSERT INTO ifk_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ad uwani ya ibaga mi anhan ta iabulut mun mundalan kamin nadah aggayam mi tuh boble yu. Iun-unud mih kalata ta adi kami mundalan hanadah payo yu weno habal yu ya adi kami uminum hi danum nah bubun yu. Hay kalata ya abuy un-unudon mi inggana mala-u kami tuh boble yu.” ");
INSERT INTO ifk_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mu kanan nan patul di Edom di “Adi kayu mundalan tuh boble mi te deket mundalan kayuh tuh ya gubaton dakayu!” ");
INSERT INTO ifk_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Kanan bon nadan holag Israel di “Daan mo anhan ta iabulut mu ot deyan kanan miy iun-unud mih kalata. Deket kal-inat uminum kamin nadah aggayam mih danum yu ya takon kattog di bayadan mi, mu ta mundalan kami anhan tuh boble yu.” ");
INSERT INTO ifk_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mu kanan nan patul di Edom di “Adinadama! Adi kayu mundalan tuh boble mi.” Kediye ya indadaan di iEdom di dakol an tindalu dan mangubat nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ot hinnatkon moy nangidalanan da te in-adin nadan iEdom di pangidalanan da nah boble da. ");
INSERT INTO ifk_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Handih timmayan nadan holag Israel ad Kades ya numpae da nah mabilid an Hor nah poppog di Edom. ");
INSERT INTO ifk_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Kediyen wadadah di ya kimmali boh APU DIOS ke da Moses ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Kananay “He-a ke Aaron ya adika makidatong nah boblen idat kun dakayun holag Israel te mate ka. Man-uke ya uggeyak inun-unud ke dakayun Moses ad Meribah. ");
INSERT INTO ifk_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ya he-a ke Moses ya ikuyug muh Aaron ya nan imbabalenan hi Eleasar ta tumikid kayu nah Bilid an Hor ");
INSERT INTO ifk_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ta kaanom nan bulwatin di padin imbulwatin Aaron ta ipabulwatim ke Eleasar. Te mateh Aaron hidi.” ");
INSERT INTO ifk_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ot un-unudon Moses hidiyen kinalin APU DIOS. Handih timmikid dan tulu ya tibtibbon nadan tatagu dida. ");
INSERT INTO ifk_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Dimmatong da nah tap-on nan bilid ot kaanon Moses nan bulwatin di padin imbulwatin Aaron ot ipabulwatinan Eleasar. Indani ya nateh Aaron hidi nah tap-on nan bilid ot dumayyu da Moses ke Eleasar. ");
INSERT INTO ifk_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ot u-umyung nadan holag Israel hi tulumpulun algo gapuh natayan Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Hanan patul di Kanaan an hi Arad an numbobled Negeb ya dingngol nan mangali nadan holag Israel an wada da nah kalatad Atharim. Ot ena gubaton didan dimpap nay udum ot pumbalinona didan balud. ");
INSERT INTO ifk_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Nunsapata nadan holag Israel ke APU DIOS an kanan day “Deket baddangan dakamit apputon mi datuwen tatagu ya pakadadaggon miy boble da.” ");
INSERT INTO ifk_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Dingngol APU DIOS di dasal da ot baddangana didan nangapput ke dadiyen iKanaan. Ot pakadadaggon da dida ya nadan boble da ot ngadanan dah Hormah. ");
INSERT INTO ifk_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Tinaynan nadan holag Israel nan Bilid an Hor an indalan da nah kalatan mumpae nah Maingit an Baybay ot malikkod dad Edom. Mu handih mange da ya mundiklamu da. ");
INSERT INTO ifk_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ad-adiy kalyon dan APU DIOS ya ke Moses an kanan day “Tipet edakami impangulun tumayan ad Egypt ta edakami iali tuh adi maboblayan an maid di danum an inumon ya maid di kanon ta deyan mate kami ot ya abuh tu. Oha bo ya immingle kami mo anhan tuh himpappangen makan.” ");
INSERT INTO ifk_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Indani ya impaalin APU DIOS di katatakut an nagitaan an ulog. Ot pungkalat day dakol nadah holag Israel ot mungkakate da. ");
INSERT INTO ifk_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Imme nadan tatagu ke Moses ot kanan day “Abuluton min nunliwat kami gapuh ad-adin kinali min APU DIOS ya ke he-a. Idasalan dakami anhan ta makaan hantudan ulog.” Ot idasalan Moses nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Indani ya kanan APU DIOS ke Moses di “Kumapya kah ing-ingon tudan ulog. Ya ipalat muh udun di patanong ta deket itangad nan tagun kinalat di ulog kediye ya adi mate.” ");
INSERT INTO ifk_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Inun-unud Moses ot kumapyah gombang an ulog ot ipalat nah patanong ta deket iang-ang nadan nakalat kediye ya pumhod dat adida mate. ");
INSERT INTO ifk_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Indani ya numpae bo nadan holag Israel ad Obot ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Timmayan dad Obot ot ume dad Iye Abarim nah adi maboblayan an poppog di Moab nah nangappit hi timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Indani ya eda nungkampu nah nundotal ad Sered. ");
INSERT INTO ifk_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Timmayan da boh di ot ume da nah binnah-el nan Wangwang an Arnon nah adi maboblayan an nipaldang nah boblen di Amorite. Hay Arnon di numpoppogan di Moab ya nan boblen di Amorite. ");
INSERT INTO ifk_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Wada on Liblun Mipanggep hi Gubat APU DIOS an nitudok hidiy “Waheb ad Suphah, nadan dopla ya nan Wangwang an Arnon, ");
INSERT INTO ifk_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nadan doplah udun nan naboblayan ad Ar nah poppog di Moab.” ");
INSERT INTO ifk_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Timmayan dah di ot ume dad Beer an kad-an nan bubun ot kumalih APU DIOS ke Moses an kananay “Amungom nadan tatagut idatak didah danum.” ");
INSERT INTO ifk_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ot ikantan nadan holag Israel hituwe: “Bumudal kan danum tuh bubun ta ikankanta miy mipanggep ke he-a. ");
INSERT INTO ifk_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ikanta mih tuwen bubun an kina-utan di imbabalen di patul, kina-utan di aap-apun inusal day patanong da.” Timmayan bo nadan holag Israel kediyen adi maboblayan ot ume dan lina-uwan day Mattanah ");
INSERT INTO ifk_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ot dumatong dad Nahaliel. Limma-u da boh di ot ume dad Bamot. ");
INSERT INTO ifk_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Limma-u dah di ot ume da nah nundotal ad Moab nah da-ul di Pisgah an bilid an mauhdungan nan adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Indani ya immitud-ak nadan holag Israel hi e makihummangan ke Sihon an patul di Amorite. Hituwey eda kalyon ke hiya: ");
INSERT INTO ifk_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Iabulut mu anhan ta idalan mi tuh boble yu. Iun-unud mih kalata inggana lumma-u kami. Ya tibon mit maid ke dakami ya nadan aggayam miy mangigatin hi intanom yuh payo yu ya lagunta yu. Ya adi kami uminum hi bubun yu.” ");
INSERT INTO ifk_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mu hi Sihon an patul hidi ya adina iabulut an mundalan nadan holag Israel hi boble da. Inamung na ot ya abuy tindaluna ot eda gubaton nadan holag Israel nah adi maboblayan ad Jahas. ");
INSERT INTO ifk_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mu numpaten nadan holag Israel dadiyen Amorite an buhul da ot diday miha-ad ke dadiyen boble mipalpu nah Wangwang an Arnon inggana nah Wangwang an Jabbok. Mu hay Ammon ya adida kabaelan an hogpon te namahig an nakahammad di alad na. ");
INSERT INTO ifk_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Sinakup di holag Israel am-in di boblen nadan Amorite, takon di Hesbon ya nadan nunlinikkod an bobleh di ot mumboble da ke dadiyen boble. ");
INSERT INTO ifk_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hay Hesbon an ongal an bobley numboblayan nan patul an hi Sihon. Handi ya inapput Sihon nan patul di Moab ot sakuponay Hesbon ya am-in nadan boble inggana nah Wangwang an Arnon. ");
INSERT INTO ifk_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Wada on kantan nitudok an athitu: “Umali kayud Hesbon an ongal an boblen Sihon. Ta iphod yuh tuwen boble nat mibangngad nan dati. ");
INSERT INTO ifk_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Handi ya mialig an nalpuy apuy ad Hesbon an boblen Sihon ot malgab di Ar an ongal an bobled Moab takon nadan bilid nah tap-on di Arnon. ");
INSERT INTO ifk_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mahmok kayun iMoab, dakayun mundaydayaw ke Kemos te nadadag kayu. Impumbalin dakayu nah dios yun hi Kemos an balud nan patul di Amorite an hi Sihon. ");
INSERT INTO ifk_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mu ad uwani ya nakadaddag di Amorite takon di boble da mipalpud Hesbon ingganad Dibon ya mipalpud Nophah ingganad Medeba.” ");
INSERT INTO ifk_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hanadan holag Israel ya numboble da nadah boblen di Amorite. ");
INSERT INTO ifk_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Indani ya intud-ak Moses di e munsiim ad Jaser an ongal an boble. Ot eda gubaton nadan bobleh nunlinikkod hidi. Sinakup da dadiyen boble ot dog-alon dan am-in nadan Amorite an numbobleh di. ");
INSERT INTO ifk_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Indani ya inunud da nan kalata ot mumpae dad Bashan. Hi Og an patul kediyen boble ya impangulunay tindaluna ot eda gubaton nadan holag Israel ad Edrei. ");
INSERT INTO ifk_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mu kanan APU DIOS ke Moses di “Adika tumakut ke hiya. Te baddangan dakat apputom takon nadan tindalunat sakupom di boble da. Atom ke hiyay umat hi inat mu nah patul di Amorite an hi Sihon ad Hesbon.” ");
INSERT INTO ifk_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ya nangapput bo nadan holag Israel kediyen gubat. Pinate dah Og, nadan imbabalena ya nadan bimmoblen maid di natdaan ot sakupon day boble da. ");
INSERT INTO ifk_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Intuluy nadan holag Israel an nangnangnge ot dumatong da nah nundotal ad Moab an nih-up nah Wangwang an Jordan ya dommang di Jericho. ");
INSERT INTO ifk_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Hanan patul di Moab an hi Balak an imbabalen Sippor ya dingngol nan dakkodakkol nadan holag Israel ya dingngol na bon inapput da nadan Amorite. ");
INSERT INTO ifk_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ot gapun diye, hiya ya nadan tataguna ya namahig di takut da. ");
INSERT INTO ifk_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kanan nadan aap-apud Moab nadah aap-apud Midian di “Mangali nadan dakkodakkol an holag Israel. Nunna-ud an dadagon dan am-in di nganne tuh boble taku, umat hi pangat di bakan mangan hi holok nah kudal.” Hi Balak an patul di Moab ");
INSERT INTO ifk_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ya immitud-ak hi e makihummangan ke Balaam an imbabalen Beor ad Pethor an boblen nih-up nah Wangwang an Euphrates. Athituy kinalinan idatong dan Balaam ta umalit baddangana: “Immaliy dakkodakkol an tatagun nalpud Egypt ya namahig an mungkihinap dah kabobboble tuh luta ya dehtu dan numboble dah nih-up hi boble mi. Kinali tumakutak te kal-ina ya pulhon day boble mi. ");
INSERT INTO ifk_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Maid di kabaelak an makihanggan dida, kinali umali ka anhan ta idutam didat kal-ina ot ya apputon mi didat bumtik da. Man-uke ya inilak an mabendisyonan nadan tatagun bendisyonam ya inilak bon maidutan nadan idutam.” ");
INSERT INTO ifk_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Hanadan binaal Balak an aap-apun di Moab ya Midian ya eda nakihummangan ke Balaam an immal-ala dah eda ibayad ke hiyah pangidutana nadah holag Israel. Ot pakakkalyon dan Balaam di pinhod Balak an maat. ");
INSERT INTO ifk_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Kanan Balaam di “Mun-iyan kayu ta nangamung di ipainilan APU DIOS ke ha-on hi kalyok ke dakayu.” Ot mun-iyan nadan iMoab an intud-ak Balak hi kad-an Balaam. ");
INSERT INTO ifk_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Kediyen hilong ya kanan Apu Dios ke Balaam di “Dahdi danaen ibbam?” ");
INSERT INTO ifk_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kanan Balaam di “Datuwe nadan intud-ak Balak an patul di Moab an mangipainilan ha-on an ");
INSERT INTO ifk_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","nihinap kanu nadan dakkodakkol an tatagun nalpud Egypt. Ot hay ibagan diyen patul ya idutak kanu didat deket gubatona dida ya apputona dida ta dog-alona dida.” ");
INSERT INTO ifk_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kanan Apu Dios ke Balaam di “Adika maki-en dida ya adim idutan nadan holag Israel te binendisyonak dida.” ");
INSERT INTO ifk_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ot handih kabigatana ya kanan Balaam hanadah tataguy “Ekayu ot, te adi iabulut APU DIOS an maki-eyak ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nibangngad da ot kalyon dan Balak an adi umalih Balaam. ");
INSERT INTO ifk_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Mu adi manghop hi Balak ot umitud-ak boh dakdakol ya natagtag-ey saad da mu nadan namangulun intud-ak na. ");
INSERT INTO ifk_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Imme da ot kanan dan Balaam di “Hituwey kanan Balak an imbabalen Sippor: ‘Umali ka anhan ta baddangan dakami. Hana ot ta maid di humlun hi em adi aliyan. ");
INSERT INTO ifk_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Tangdanan dakah ustu ya atok di ngannen ibagam, mu ta maki-ali kat idutam nadan holag Israel.’” ");
INSERT INTO ifk_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mu kanan Balaam di “Takon anhan di idat Balak ke ha-on di balenan balen di patul ya am-in di wadah di, umat hi balituk ya pihhu ya adinadaman ek ngohayon di intugun APU DIOS ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mu takon di athidi ya mun-iyan kayu, umat hi inat nadan namangulun immalit inilaok hin kal-ina waday pinhod APU DIOS an ipainilan ha-on.” ");
INSERT INTO ifk_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Kediyen hilong ya kanan Apu Dios ke Balaam di “Deket hay gapunah immaliyan datuwen tatagu ya edaka ikuyug, aga, mundadaan kat maki-e ka. Mu atom ya abu nan kalyok ke he-an atom.” ");
INSERT INTO ifk_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ot handih nabigat ya nuntakkeh Balaam nah kabayuna ot maki-e nadah aap-apun iMoab. ");
INSERT INTO ifk_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Bimmoh-ol hi Apu Dios hi naki-ayan Balaam. Ot handih mange da Balaam an ibbana nan duwan muttatyuna ya nunhood on anghel Apu Dios nah dalan an nihanih dalanona. ");
INSERT INTO ifk_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Handih tinibon nan kabayun Balaam nan anghel an muntattaddog an intagge nay ispadana ya inhingngi nan indalana nah payo. Ot hupliton Balaam nan kabayu ot ibangngad na nah kalata. ");
INSERT INTO ifk_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Indani ya e bo timmaddog nan anghel nah kalatan nahkit an numbattanan di duwan laguntan naaladan hi binattu. ");
INSERT INTO ifk_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Handih tinibo bon nan kabayu nan anghel an timmaddog ya impilit nan immukip nah binattun alad ot migadgad di hukin Balaam te naipit ot huplitona bo nan kabayuna. ");
INSERT INTO ifk_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Indani ya dimmayyu bo nan anghel nah nakakkahkit an dalan an maid di innun nan kabayun umukip an mala-u. ");
INSERT INTO ifk_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Tinibo bon nan kabayu nan anghel ya nunlukbub mo anhan. Ot pun-ihoplat Balaam nan patanong na nah kabayu te bimmobboh-ol. ");
INSERT INTO ifk_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ot pakalyon APU DIOS nan kabayun kanana ke Balaam di “Nganney inat kun he-at eyak hinuplit hi namintulu?” ");
INSERT INTO ifk_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Hinumang Balaam an initkuk nan kananay “Te impatibom an kay makudang di nomnom ku. Konna ket waday ispadak, nunna-ud an patayon daka.” ");
INSERT INTO ifk_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kimmali bo nan kabayun kananay “Mu kon bokon ha-oy nan kabayum an nuntanakkayam? Kon waday nangiathituwak ke he-a handi?” Kanan Balaam di “Maid!” ");
INSERT INTO ifk_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Indani ya kay diniyat APU DIOS di matan Balaam ot tibona nan timmaddog an anghel an inodnanay ispadana ya nunlukbub hi Balaam nah luta. ");
INSERT INTO ifk_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kanan nan anghel ke hiyay “Tipet em hinuplit nan kabayum hi numpitlu? Man immaliyak ta haniyak di dalanom te ipilit mun ume te ngohayonak. ");
INSERT INTO ifk_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Tinibowak nah kabayum ot mamintulun adina pinhod an ume. Gulatna ya pinate daka ot ke ha-on.” ");
INSERT INTO ifk_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Himmumang hi Balaam an kananay “Abulutok an numbahulak. Uggek inilan timmaddog kah tut haniyam di dalanok. Takon di mibangngadak ten adim pinhod an maki-eyak.” ");
INSERT INTO ifk_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Kanan nan anghel APU DIOS ke hiyay “Mabalin an maki-e ka ke datuwen aap-apun intud-ak Balak, mu mahapul an nan kalyok ke he-ay kalyom ya abu.” Ot ituluy Balaam an naki-en dida. ");
INSERT INTO ifk_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Dingngol Balak an mangali da Balaam ya ena dinammu didad Ar an ongal an boble nah pingngit di Wangwang an Arnon nah poppog di Moab. ");
INSERT INTO ifk_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Kanan Balak ke hiyay “Tipet uggeka immali handih pinghanah nangipaayagak ke he-a? Kon pangalim on adi daka bayadan hi ustu?” ");
INSERT INTO ifk_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Kanan Balaam di “Deya bon immaliyak mu maid di kabaelak an mangalih nganneh diye. Ammunay kalyon Apu Dios di kalyok.” ");
INSERT INTO ifk_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ot maki-e Balaam ke Balak ad Kiriat Husot. ");
INSERT INTO ifk_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nun-appit hi Balak hi babaka ya kakalnero ot idatanah Balaam ya nadan aap-apun ingkuyug na. ");
INSERT INTO ifk_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kabiggatana ya impangulun Balak hi Balaam ad Bamot Baal an mauhdungan di udum hanadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Kanan Balaam ke Balak an patul di “Ikapyaanak hi pitun pun-appitan hitu ya indadaan muy pitun ka-ongal nan lakin baka ya pitun lakin kalneron miappit.” ");
INSERT INTO ifk_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Inun-unud Balak hidiyen kinalin Balaam ot iappit nay hin-oh-an lakin baka ya hin-oh-an lakin kalnero nadah pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kanan Balaam ke Balak di “Tumaddog kah kad-an hantudan in-appit mun maghob ta ume-eleyak ta tibok hin humangonak ke APU DIOS. Ne ahik kalyon ke he-a hin nganney ipainilanan ha-on.” Ot ohah Balaam an imme nah tap-on nan bilid ");
INSERT INTO ifk_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ot dammuwon Apu Dios hidi. Kanan Balaam di “Nangapyaak hi pitun pun-appitan ot mun-appitak hi hin-oh-an lakin baka ya hin-oh-an lakin kalnero nadah pun-appitan.” ");
INSERT INTO ifk_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Kinalin APU DIOS ke Balaam di kalyona ke Balak ot ahina kanan ke hiyay “Ekah kad-an Balak ta kalyom ke hiya nan kinalik ke he-a.” ");
INSERT INTO ifk_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Nibangngad hi Balaam ya dehdi pay hi Balak an muntattaddog nah kad-an nadan niappit an maghob an ibbana nadan aap-apun di Moab. ");
INSERT INTO ifk_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Kimmalih Balaam an kananay “Eyak impaayag ke Balak an patul di Moab nah boblek nah bilid hi nangappit nah timilan di algod Aram, ta idutak kanu nadan holag Israel an kalyok di ad-adin maat ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Muden tipet ek idutan nadan ugge naidutan ya adi idutan APU DIOS hi udum hi algo? ");
INSERT INTO ifk_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Timmaddogak hi tap-on di bilid ya nadah duntug ya tinibok an dakol da yaden niohha da ya adida umat hi udum an tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Dakkodakkol dan holag Israel an kay da hupuk an adi mabilang. Dahdi udot di mamilang hi takon di adi umeh godwan di bilang da? Hana ot ta mateyak an malinggop umat ke dadiyen tatagun APU DIOS an ibilang nan maphod.” ");
INSERT INTO ifk_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kanan Balak ke Balaam di “Tipe bot kanak di idutam dadiyen buhul ku yaden binendisyonam ot ya abu dida.” ");
INSERT INTO ifk_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Kanan Balaam di “Om, te ammuna nan kinalin APU DIOS ke ha-on an kalyok.” ");
INSERT INTO ifk_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Indani ya kanan Balak ke Balaam di “Makat ume ta boh di nah matibom di udum hanadah holag Israel ta idutam dida te hidiyey pinhod kun atom.” ");
INSERT INTO ifk_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ot ie nah Balaam ad Sophim nah tuktuk nan Bilid an Pisgah. Ingkapya nay pitun pun-appitan hidi ot mun-appit hi hin-oh-an bulug an baka ya hin-oh-an lakin kalnero nadah pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Kanan Balaam ke Balak di “Tumaddog kah tuh kad-an di in-appit mun maghob ta ek damuwon hi Apu Dios hidih e-elena.” ");
INSERT INTO ifk_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Dinammun APU DIOS hi Balaam ot kalyonay ena kalyon ke Balak. ");
INSERT INTO ifk_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ot mibangngad hi Balaam hi kad-an Balak ya nadan ibbanan ap-apun di Moab ya dehdin muntadtaddog nah kad-an nan in-appit nan maghob. Ya kahanhahanhan hin nganney kinalin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kanan Balaam di “Donglom Balak an imbabalen Sippor hituwen kalyok. ");
INSERT INTO ifk_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Hi Apu Dios ya adi umat hi tagun munlangkak ya mumbaliw di nomnom na. Atonan am-in di kalyonan kimmali on naat. ");
INSERT INTO ifk_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nimandal ke ha-on an bendisyonak di nabendisyonan ya adinadaman ek ibabawi. ");
INSERT INTO ifk_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Maid di ad-adin maat nadah holag Israel ya maid di eda kabulubulunan te wadah APU DIOS ke dida ya hiyay kinali dan patul da. ");
INSERT INTO ifk_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ya hiyay nangihwang ke didad Egypt. Hiya ya mialig nah mailom an bulug an nakal-ot an ihangga da. ");
INSERT INTO ifk_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Maid di maat di magic ya mun-ayak nadah holag Israel. Athitu moy ahi kalyon di tatagu mipanggep ke dida: Tibon yuy inat Apu Dios nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mialig da nah layon an nakal-ot ya adi mun-iyatu inggana banik-iyonat kanona ya inumonay dalan di pinatena.” ");
INSERT INTO ifk_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Indani ya kanan Balak ke Balaam di “Deket adim idutan dida ya adim ni-mo anhan bendisyonan dida.” ");
INSERT INTO ifk_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Kanan Balaam di “Kon uggek kinalin he-an atok ya abuy kalyon APU DIOS ke ha-on?” ");
INSERT INTO ifk_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kanan Balak di “Maki-e kan ha-on ta ie daka nah ohan boble. Kal-ina ya mabalin an iabulut Apu Dios an idutam didah di.” ");
INSERT INTO ifk_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ot ienah Balaam nah tuktuk nan Bilid an Peor an mauhdungan nan adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Kanan Balaam ke hiyay “Ikapyaanak hi pitun pun-appitan hitu ya ialim di pitun bulug an baka ya pitun lakin kalneron miappit.” ");
INSERT INTO ifk_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Inun-unud Balak ot mun-appit hi hin-oh-an bulug an baka ya hin-oh-an lakin kalnero nadah pitun pun-appitan. ");
INSERT INTO ifk_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kediye ya ininnilan Balaam an umamlong hi APU DIOS an mabendisyonan nadan holag Israel, ot uggena inayak dida umat hi oggana aton hi hin-uddum. Inliggu na ot iang-ang na ot ya abu nah adi maboblayan ");
INSERT INTO ifk_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ya tinibona nadan holag Israel an nungkampu, mipuun hi nahlagan da. Indani ya immaliy Espiritun Apu Dios ke hiya ");
INSERT INTO ifk_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ot kalyonah tuwe: “Ha-oy an imbabalen Beor an hi Balaam an makatnong di panibok ya ");
INSERT INTO ifk_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","dongdonglok di kalyon Apu Dios an Kabaelanan am-in ya tibtibbok di ipatibona ke ha-on. Ot munlukbubak hi hinangngab na. Hituwey abigok: ");
INSERT INTO ifk_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‘Makakkaphod nadan kampun di holag Israel ya makaphod di nunhituwan da, ");
INSERT INTO ifk_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","umat da nadah natuntun-ud an palma, umat da nadah garden hi pingngit di wangwang, umat da bo nadah mumpabangluh makan an intanom Apu Dios ya umat da nadah sedar hi pingngit di lobong. ");
INSERT INTO ifk_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ahi dakol di danum ta takon nadan intanom da ya adi makudangan. Ahi ongal di kabaelan di patul da mu hi Agag. Ya sakupon day pun-ap-apuwan hi dakol an boble. ");
INSERT INTO ifk_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Impangulun Apu Dios didan timmayan ad Egypt ya nakal-ot dan umat da nah mailom an bulug an baka. Paka-apputon day makibuhul ke didan punggi-u day gunit da ya pumpana da dida. ");
INSERT INTO ifk_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Mialig da nah layon an munho-ho-od hi dopapona ya mialig da bo nah babain layon an katatakut an madistulbu.’ Hanan mumbendisyon ke dakayun holag Israel ya mabendisyonan ya nan mangidut ke dakayu ya maidutan.” ");
INSERT INTO ifk_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Namahig di boh-ol Balak ke Balaam an ginomgom nay taklena ot itkuk nan kinalin hiyay “Inayagan dakat idutam dadiyen buhul ku, yaden binendisyonam ot ya abu didah namintulu. ");
INSERT INTO ifk_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Umanamut kah boble yu. Man-ut kinalik an idatan dakah gun-udom mu ugge in-abulut APU DIOS an alam di ginun-ud mu.” ");
INSERT INTO ifk_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Himmumang hi Balaam an kananay “Kinalik tuwali nadah intud-ak mun mangayag ke ha-on ");
INSERT INTO ifk_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","an takon di idat mun ha-on am-in di silber ya balituk nah balem ya adinadaman ek ngohayon hi APU DIOS ta ek aton di pinhod ku. Ya kinalik bon he-an ammunay kalyon APU DIOS an kalyok. ");
INSERT INTO ifk_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Mibangngadak moh boble mi mu kalyok ni-an ke he-ay ahi aton nadan holag Israel hi tatagum hi udum hi algo.” ");
INSERT INTO ifk_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Athituy kinalin Balaam: “Ha-oy an imbabalen Beor an hi Balaam an makatnong di panibok ya ");
INSERT INTO ifk_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","dongdonglok di kalyon Apu Dios an Katagtag-ayan an Ap-apu ya tibtibbok di ipatibona ke ha-on. Ot munlukbubak hi hinangngab na. ");
INSERT INTO ifk_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Matibok an hi udum hi algo ya mawada nadah holag Israel di ohan patul an mialig nah makahhiyon bittuwon. Ahina punggumik di ulun di iMoab ya nadan bimmobled Seth. ");
INSERT INTO ifk_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ya ahina apputon nadan buhul nad Edom ya Seir ta sakuponay boble da. Ya mawaday ongal an kabaelan nadan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Hidiyen patul an ahi malpuh holag Israel ya dadagona nadan ahi matdaan an matagu.” ");
INSERT INTO ifk_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","In-uhdung bon Balaam hanadah iAmalek ot abigonah tuwe: “Man-u te hay Amalek di kaongngalan di kabaelanan am-in hi boble mu ahi makadaddag ta mama-id ta inggana.” ");
INSERT INTO ifk_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","In-uhdung na bo nadah Kenite ot abigonah tuwe: “Man-ut malinggop kayu nah boble yun mialig nah buyah tap-on di mabatu, ");
INSERT INTO ifk_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","mu ahi kayu madadag hantuh umaliyan di iAssyria ta alan dakayu ta mumbalin kayun balud hi boble da.” ");
INSERT INTO ifk_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hituwe boy inabig Balaam: “Dahdiy munnanong an matagu ten aton Apu Dios di athitu? ");
INSERT INTO ifk_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ahi mangaliy bapor an malpu nah pingngit di baybay ad Cyprus. Punholholtapon day iAssyria ya iEber, mu takon di dida ya makadaddag da.” ");
INSERT INTO ifk_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Nagibbun nun-abig hi Balaam ot umanamut hi boble da ya immanamut damdamah Balak. ");
INSERT INTO ifk_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Handih nungkampu nadan holag Israel ad Akasia ya inhuyop di udum an linalaki day binabain iMoab. ");
INSERT INTO ifk_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ot ayagan dadiyen binabai dida nah eda pun-appitan hanadah dios dan iMoab. Indani ya nakihamul dan dida ya dinayaw da mo dadiyen dios di Moab. ");
INSERT INTO ifk_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ya nakid-um da bon nundayaw ke Baal ad Peor. Ot bumoh-ol hi APU DIOS ke didan tataguna. ");
INSERT INTO ifk_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ot itugunan Moses datuwen atonan kananay “Ayagam am-in nadan nangipangpangulun nangat kediye ta pipatem didah hinangngab am-in nadan holag Israel ta adiyak mo bumoh-ol ke didan holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kanan Moses nadah huwes di Israel di “Tibon yun am-in hanadah puun yuy mundayaw ke Baal ad Peor ta pipate yu.” ");
INSERT INTO ifk_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Indani ya waday ohan holag Israel an inihgop na on babain iMidian hi kampu da yaden ang-ang-angon Moses ya nadan tatagu kediyen naamungan dan mungkoga da ya mun-iyo da nah hogpan nan Tabernacle. ");
INSERT INTO ifk_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Hi Pinehas an padin imbabalen Eleasar ya inap-apun Aaron ya tinibo na damdamah diye ot ena alan di pahul na. ");
INSERT INTO ifk_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ot unudonah diyen lalaki nah kampuna. Imbawok na nan pahul na nah lalaki ot matuduk takon nan babai. Ot matikod nan dogon nihinap nadah holag Israel ");
INSERT INTO ifk_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","muden nil-un natey duwan pulut opat an libu ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Gapu kediyen inat Pinehas ya adiyak mo bumobboh-ol ke dakayun holag Israel. Matibok an adina pinhod an waday udum an dios mu ha-oy ya abu, kinali adik mo ituluy nan planuk an dadagon dakayu gapuh boh-ol ku. ");
INSERT INTO ifk_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ta hidiye nan kalyom ke hiyan isapatak an wadat nangamung di linggop na. ");
INSERT INTO ifk_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ya hiya ya nadan holag na ya munnanong dat nangamung an mumpadi te uggena in-abulut an waday udum an dios mu ha-oy ya abu ot kal-iwak di liwat nadan tatagu.” ");
INSERT INTO ifk_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Hay ngadan nan lalakin holag Israel an naten ibba na nan babain iMidian ya hi Simri an imbabalen Salu an nahlag ke Simeon. ");
INSERT INTO ifk_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Hay ngadan nan babai ya hi Kosbi an imbabalen Sur an oha nadah mangipangpanguluh iMidian. ");
INSERT INTO ifk_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Indani ya kinalin APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Gubaton yu nadan iMidian ta dadagon yu dida ");
INSERT INTO ifk_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","te gaga-iho dan hinaul dakayu ot dayawon yuh Baal ad Peor ya gapu nah imbabalen di mangipangpanguluh iMidian an hi Kosbi an napate handih nihinap di dogod Peor.” ");
INSERT INTO ifk_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Handih natikod hidiyen dogon nangastigun APU DIOS ke dida ya kananan da Moses ke Eleasar an imbabalen Aaron di ");
INSERT INTO ifk_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Bilangon yu bo nadan linalakin muntoon hi duwampulu weno nahawwal ta mainilay kaatnah ohan pamilyay mabalin an muntindalu.” ");
INSERT INTO ifk_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Kediye ya nungkampu nadan holag Israel nah nundotal ad Moab nah pingngit nan Wangwang an Jordan ya dommang di Jericho. Inun-unud da Moses ke Eleasar hidiye ot iolden da nadah aap-apun holag Israel di aton dan mumbilang nadah linalaki. ");
INSERT INTO ifk_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Kanan day “Bilangon yun am-in di linalakin holag Israel an muntoon hi duwampulu weno nahawwal mipuun hi kinalin APU DIOS an maat. Datuwe nadan holag Israel an timmayan ad Egypt.” ");
INSERT INTO ifk_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Datuwey nahlag ke Reuben an panguluwan an imbabalen Jacob an Israel di ohan ngadana: nadan holag Hanok, nadan holag Pallu, ");
INSERT INTO ifk_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","nadan holag Hesron, ya nadan holag Karmi. ");
INSERT INTO ifk_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hay bilang am-in dadiyen linalakin holag Reuben ya 43,730. ");
INSERT INTO ifk_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Hi Pallu di nahlagan Eliab ");
INSERT INTO ifk_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","an aman Nemuel, hi Dathan ya hi Abiram. Da Dathan ke Abiram handin nangipangpanguluh holag Israel an nakibaddang ke Korah an nungngohe da Moses, hi Aaron ya hi APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mu nadhak nan luta ot maunug dad dalom takon hi Korah. Ya pinaten di apuy nadan nangun-unud ke didan 250. Hidiyen naat ke diday pangitib-an di udum an tatagut tumakut dan mangat hi umat hi inat da. ");
INSERT INTO ifk_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mu nadan imbabalen Korah ya uggeda nate kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Datuwey nahlag hi imbabalen Simeon: nadan holag Nemuel, nadan holag Jamin, nadan holag Jakin, ");
INSERT INTO ifk_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","nadan holag Serah ya nadan holag Saul. ");
INSERT INTO ifk_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hay bilang am-in dadiyen linalakin holag Simeon ya 22,200. ");
INSERT INTO ifk_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Datuwey nahlag ke Gad: nadan holag Sephon, nadan holag Haggi, nadan holag Suni, ");
INSERT INTO ifk_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","nadan holag Osni, nadan holag Eri, ");
INSERT INTO ifk_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","nadan holag Arodi ya nadan holag Areli. ");
INSERT INTO ifk_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hay bilang am-in dadiyen linalakin holag Gad ya 40,500. ");
INSERT INTO ifk_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Da Er ke Onan an imbabalen Judah ya nate dad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Hanadan nahlag ke Judah ya nadan holag Selah, nadan holag Peres ya nadan holag Serah. ");
INSERT INTO ifk_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Hanadan nahlag ke Peres ya nadan holag Hesron ya nadan holag Hamul. ");
INSERT INTO ifk_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hay bilang am-in dadiyen linalakin holag Judah ya 76,500. ");
INSERT INTO ifk_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Hanadan nahlag ke Issakar: nadan holag Tola, nadan holag Puah, ");
INSERT INTO ifk_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","nadan holag Jashub ya nadan holag Simron. ");
INSERT INTO ifk_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hay bilang am-in dadiyen linalakin holag Issakar ya 64,300. ");
INSERT INTO ifk_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Hanadan nahlag ke Sebulun: nadan holag Sered, nadan holag Elon ya nadan holag Jahleel. ");
INSERT INTO ifk_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hay bilang am-in dadiyen linalakin holag Sebulun ya 60,500. ");
INSERT INTO ifk_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Hanadan nahlag ke Joseph: nadan holag da Manasseh ke Eplaim. ");
INSERT INTO ifk_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Hanadan nahlag ke Manasseh: nadan holag Makir ya nadan holag Gilead. (Hi Gilead ya imbabalen Makir.) ");
INSERT INTO ifk_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Hanadan nahlag ke Gilead: nadan holag Ieser, nadan holag Helek, ");
INSERT INTO ifk_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","nadan holag Asriel, nadan holag Sekem, ");
INSERT INTO ifk_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","nadan holag Semida ya nadan holag Hepher. ");
INSERT INTO ifk_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Hi Selophehad an imbabalen Hepher ya maid di linalakin imbabalena. Binabai ya abuy imbabalena an hi Mahlah, Noah, Hoglah, Milkah ya hi Tirsah.) ");
INSERT INTO ifk_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hay bilang am-in dadiyen linalakin holag Manasseh ya 52,700. ");
INSERT INTO ifk_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Hanadan nahlag ke Eplaim: nadan holag Suthelah, nadan holag Beker ya nadan holag Tahan. ");
INSERT INTO ifk_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Nahlag hi Suthelah ot nadan holag Eran. ");
INSERT INTO ifk_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hay bilang am-in dadiyen linalakin holag Eplaim ya 32,500. ");
INSERT INTO ifk_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Hanadan nahlag ke Benjamin: nadan holag Bela, nadan holag Asbel, nadan holag Ahiram, ");
INSERT INTO ifk_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","nadan holag Supham ya nadan holag Hupham. ");
INSERT INTO ifk_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Hanadan nahlag ke Bela: nadan holag Ard ya nadan holag Naaman. ");
INSERT INTO ifk_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hay bilang am-in dadiyen linalakin holag Benjamin ya 45,600. ");
INSERT INTO ifk_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","Nahlag hi Dan ot nadan holag Suham. Hay bilang am-in dadiyen linalakin holag da Dan ya 64,400. ");
INSERT INTO ifk_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Hanadan nahlag ke Asher: nadan holag Imnah, nadan holag Isbi ya nadan holag Beriah. ");
INSERT INTO ifk_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Hanadan nahlag ke Beriah: nadan holag Heber ya nadan holag Malkiel. ");
INSERT INTO ifk_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Hi Asher ya waday imbabalenah babain hi Serah.) ");
INSERT INTO ifk_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hay bilang am-in dadiyen linalakin holag Asher ya 53,400. ");
INSERT INTO ifk_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Hanadan nahlag ke Naptali: nadan holag Jahseel, nadan holag Guni, ");
INSERT INTO ifk_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","nadan holag Jeser ya nadan holag Sillem. ");
INSERT INTO ifk_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hay bilang am-in dadiyen linalakin holag Naptali ya 45,400. ");
INSERT INTO ifk_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Hay bilang am-in di linalakin holag Israel an nitudok ya 601,730. ");
INSERT INTO ifk_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ganodwaom nan luta mipuun hi kadakol nadan holag Israel ta ikap-ong mun dida. ");
INSERT INTO ifk_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Idat muy bilbilog an luta nah dakdakol ya idat muy it-itay nah o-oha. Matiboy kadakol nan ohan puun nah kabilog di lutan midat ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Tibom ta ibunut muy atom an mangikap-ong nah luta ya mipuun nah nitudok an bilang nadan nahlag hi imbabalen Israel. ");
INSERT INTO ifk_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Mahapul nimpen mibunut di atom an mangikap-ong nah luta ta deket dakdakol da nah ohan puun ya bilbilog di midat ke dida ya deket o-oha dah ohan puun ya it-itay boy midat ke dida.” ");
INSERT INTO ifk_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hanadan nahlag ke Libay: nadan holag Gershon, nadan holag Kohat ya nadan holag Merari. ");
INSERT INTO ifk_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Datuwey udum an nahlag ke Libay: nadan holag Libni, nadan holag Hebron, nadan holag Mahli, nadan holag Mushi ya nadan holag Korah. Hi Kohat di aman Amram ");
INSERT INTO ifk_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","an nangiinen Jokebed. Hi Jokebed an nitungod Egypt ya nahlag metlaing ke Libay. Nun-imbabale dah duwan lalaki ot da Aaron ke Moses ya ohan babai an hi Miriam. ");
INSERT INTO ifk_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Hi Aaron ya opat di linalakin imbabalena: hi Nadab, hi Abihu, hi Eleasar ya hi Itamar. ");
INSERT INTO ifk_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nate da Nadab ke Abihu handih nun-appitan dan APU DIOS yaden uggeda inun-unud di kinalin APU DIOS hi aton dan munggohob hi insenso. ");
INSERT INTO ifk_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Hay bilang nadan linalakin nahlag ke Libay an himbulana ya nahawwal ya 23,000. Naappil pey listaan di bilang da te adida midattan hi tawidon dan lutad Israel. ");
INSERT INTO ifk_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Danaey binilang da Moses ke Eleasar handih numbilangan dan am-in hi holag Israel nah nundotal ad Moab nah pingngit di Jordan an Wangwang ya dommang di Jericho. ");
INSERT INTO ifk_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Uggeda nakibilang handih namangulun numbilangan Moses nadah holag Israel handih kawada dad Sinai an adi maboblayan. Dadiyen nabilang handi ya maid ke diday natdaan an matagu. ");
INSERT INTO ifk_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Te kinali tuwalin APU DIOS handi an mate dan am-in nah adi maboblayan. Mu ammunah Kaleb an imbabalen Jephunneh ya hi Joshua an imbabalen Nun an matdaan an matagu. ");
INSERT INTO ifk_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","4","Ohan algo ya datuwen binabain imbabalen Selophehad an hi Mahlah, hi Noah, hi Hoglah, hi Milkah ya hi Tirsah ya imme da nah hogpan hi Tabernacle hi kad-an da Moses, hi Eleasar an padi, nadan mangipangpangulu ya nadan ibba dan bimmoble ot kanan day “Nateh amami nah adi maboblayan yaden maid di tulang mih lalaki. Mu hiya ya nate pe gapuh liwat na, bokon gapuh nakid-umana nadah naki-unnud ke Korah an nungngohe ke APU DIOS. Yaden tipet nakaan di ngadana nah listaan di nahlagana gapu te maid di imbabalenah lalaki? Daan mo anhan ta pakidat dakami nah lutan indat yu nadah iiban amami?” Hi Selophehad ya imbabalen Hepher an imbabalen Gilead an imbabalen Makir an imbabalen Manasseh an imbabalen Joseph. ");
INSERT INTO ifk_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Nakihummangan hi Moses ke APU DIOS mipanggep kediye ya ");
INSERT INTO ifk_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","kanan APU DIOS ke hiyay ");
INSERT INTO ifk_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Ustu peman hidiyen ibagan nadan imbabalen Selophehad an waday kalebbengan da, kinali idatam dida nah lutan nidat hi iiban amada. Ta nan tawid amada ya hidiyey idat mun dida. ");
INSERT INTO ifk_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Kalyom hanadah holag Israel an deket natey ohan lalaki yaden maid di lalakin imbabalena ya midat di tawid na nadah binabain imbabalena. ");
INSERT INTO ifk_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Deket maid di imbabalena ya midat di tawid na nah lalakin tulang na. ");
INSERT INTO ifk_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Deket maid di lalakin tulang na ya midat di tawid na nadah linalakin tulang amana. ");
INSERT INTO ifk_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Deket maid di linalakin tulang amana ya midat moy tawid nah kumpulmin naka-ih-up an iibanat ibagi da. Mahapul an un-unudon nadan holag Israel hituwe mipuun nah Tugun APU DIOS an indat nan Moses.” ");
INSERT INTO ifk_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ohan algo ya kanan APU DIOS ke Moses di “Tumikid ka nah tap-on nan Bilid an Abarim nah nangappit hi timilan di algot tibom nan boblen idat ku nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Nagibbu ken tinibom ya mate ka, umat ke tulang mun hi Aaron ");
INSERT INTO ifk_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","te nginohe yu damdamay tugun ku handih nundiklamu nadan tatagu ke ha-on handih wada kayud Meriba nah adi maboblayan ad Sin. Man-uke ya uggem impatibo ke diday ongal an kabaelak.” (Hay Meribah ya hidiye nan ob-ob ad Kades.) ");
INSERT INTO ifk_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Nundasal hi Moses ke APU DIOS an kananah dasal nay ");
INSERT INTO ifk_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","“Daan anhan APU DIOS an kalpuwan di biyag, ta tudduwom di ohan kabaelanan mangipangulu hantudah tatagum ta adida umat nadah kalneron maid di mumpattol ke dida ya kabaelanan mangipangulun didan makigubat.” ");
INSERT INTO ifk_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kanan APU DIOS ke Moses di “Hi Joshua an imbabalen Nun di waday kabaelana. Ayagam ta ihakmom di taklem hi uluna. ");
INSERT INTO ifk_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ipataddog muh hinangngab Eleasar an padi ya am-in nadan ibba yun holag Israel ta kalyom ke didan hiyay mihannot ke he-an mangipangulun dida. ");
INSERT INTO ifk_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ya ipaboltan mun hiyay kabaelam ta mangun-unud am-in nadan tatagun Israel ke hiya. ");
INSERT INTO ifk_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Deket waday pinhod dan ibagan ha-on ya tumaddog hi Joshua hi hinangngab Eleasar an padi ta inilaona hin nganney inhumang ku mipuun nah bunut an Urim ya Tummim. Athituy panginilaan Eleasar hi kalyonan Joshua ya nadan tatagu ten nganney aton da.” ");
INSERT INTO ifk_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Inun-unud Moses hituwen intugun APU DIOS ot pataddogonah Joshuah hinangngab Eleasar an padi ya am-in nadan tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ot ihakmon Moses di taklenah ulun Joshua ot kalyonan hiyay mihannot ke hiya. Inat Moses hituwen inun-unud nay kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Kinalin bon APU DIOS ke Moses an ");
INSERT INTO ifk_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","ituguna nadah holag Israel hituwe: “Mahapul an ipresenta yun ha-on nah nagtud an tiempo nadan umipaamlong ke ha-on an makan an maghob. ");
INSERT INTO ifk_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Hay iappit yun maghob an makan hi kabigabigat ya duwan hintoonan lakin kalneron maid di dipektona. ");
INSERT INTO ifk_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Iappit yuy oha nah biggatna ya oha nah mungkahilong. ");
INSERT INTO ifk_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","7","Ya unnudan yuh pagen iappit yun hidiye ya dandani hingkilon alinan maha-adan hi ohan litron mantekan di oliba ya ipresenta yun ha-on nan ohan litron mainum miduyag nah altar ta iappit yun miunnud nah ohan hintoon nan kalnero. Gobhon yu datuwen iappit yun ha-on hi kabigabigat ta umamlongak hi hamuy na. Hituwen aton yu ya nilappu tuwalin niappit nah bilid ad Sinai. ");
INSERT INTO ifk_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Athidiy aton yu nah iappit yuh biggatna ya nah mungkahilong. Hituwen iappit yun makan an maghob ya umipaamlong ke ha-on di hamuy na. ");
INSERT INTO ifk_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Hana keh Sabadun Tungo ya iappit yuy duwan hintoonan lakin kalneron maid di dipektona, hay dandani duwan kilon alinan miappit an page an waday mantekan oliba ya hay miappit an mainum. ");
INSERT INTO ifk_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Miohhan maghob datuwen iappit yu nah Sabadun Tungo ya mid-um nah iappit yu pe tuwalin maghob hi kabigabigat an maunnudan hi miappit an baya. ");
INSERT INTO ifk_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Ipresenta yuy maghob an iappit yun ha-on nah mamangulun algo nah kabulabulan an duwan ka-ongal nan lakin baka, ohan lakin kalnero ya pitun hintoonan lakin kalnero. Mahapul an am-in datuwen aggayam ya maid di dipekto da. ");
INSERT INTO ifk_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Unnudan yu nan ohan lakin baka hi pagen iappit yun umeh tulun kilon alinan naha-adan hi mantekan di oliba ya unnudan yu nan lakin kalnero hi pagen iappit yun umeh duwan kilo alinan naha-adan hi mantekan di oliba. ");
INSERT INTO ifk_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Ya nan hin-oh-an hintoonan lakin impan di kalnero ya unnudan yuh pagen iappit yun umeh ohan kilon alinan naha-adan hi mantekan di oliba. Hituwen miappit an maghob ya miappit an makan ya umipaamlong ke ha-on di hamuy na. ");
INSERT INTO ifk_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Mahapul bon umiappit kayun ha-on hi bayan umeh opat an litron miunnud hi ohan baka. Hay ohan lakin kalnero ya nahawwal hi ohan litron mainum ya hay ohan lakin impan di kalnero ya ohan litro ya abun mainum. Datuwey miappit nah mamangulun algoh kabulabulan. ");
INSERT INTO ifk_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ya iappit yu boy ohan lakin gulding an miappit gapuh liwat an id-um yu nah iappit yuh kabigabigat an unnudan yu boh mainum iappit yu. ");
INSERT INTO ifk_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Hanah mikahimpulut opat an algo nah mamangulun bulan di pangatan yu nah Piyestan di Nala-uwan di Anghel Apu Dios. ");
INSERT INTO ifk_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ya nah mikahimpulut liman algo ya milappu nan pitun algon piyesta yun adi kayu mangan hi tinapay an naha-adan hi mumpalbag. ");
INSERT INTO ifk_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Hanah mamangulun algo kediyen piyesta yu ya maamung kayu ta mundayaw kayu ya adi kayu mungngunu. ");
INSERT INTO ifk_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mun-appit kayuh maghob ta hidiyey makan an iappit yun APU DIOS. Datuwey iappit yu: duwan ka-ongal nan lakin baka, ohan lakin kalnero ya pitun hintoonan lakin kalnero. Mahapul an am-in datuwen aggayam ya maid di dipekto da. ");
INSERT INTO ifk_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Hay hin-oh-an danae ya unnudan yuh miappit an page an hidiye ya alinan naha-adan hi mantekan di oliba: hay ohan baka ya maunnudan hi umeh tulun kilon alina, hay ohan lakin kalnero ya maunnudan hi umeh duwan kilon alina, ");
INSERT INTO ifk_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ya hay ohan ka-ongal nan lakin kalnero ya maunnudan hi umeh ohan kilon alina. ");
INSERT INTO ifk_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. ");
INSERT INTO ifk_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ipresenta yun am-in datuwen iappit yun maghob an hinnatkon pe tuwali nan iappit yuh kabiggabiggatna. ");
INSERT INTO ifk_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Hidiye nimpey aton yuh kabigabigat ke dadiyen pitun algon piyesta an mun-appit kayun ha-on hi makan an gobhon yu ta umamlongak hi hamuy na. Hinnatkon nimpe nadan iappit yun maghob ya iappit yun mainum hi kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Hanah mikapitun algo ya maamung kayu bo ta mundayaw kayun ha-on ya adi kayu mungngunu. ");
INSERT INTO ifk_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Hanah mamangulu bon algoh piyestan di ani ya maamung kayu ta mundayaw kayun ha-on ya adi kayu mungngunu. ");
INSERT INTO ifk_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mun-appit kayuh maghob ta umamlongak hi hamuy na. Datuwey iappit yu: duwan ka-ongal nan lakin baka, ohan lakin kalnero ya pitun hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Mun-appit kayu boh pagen iappit yuy alinan naha-adan hi mantekan di oliba: hay ohan baka ya maunnudan hi umeh tulun kilon alina, hay ohan lakin kalnero ya maunnudan hi umeh duwan kilon alina ");
INSERT INTO ifk_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ya hay ohan ka-ongal nan lakin kalnero ya maunnudan hi umeh ohan kilon alina. ");
INSERT INTO ifk_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Mun-appit kayu boh ohan lakin gulding gapuh liwat ta makaan di liwat yu. Hidiyen pun-appitan yuy pangatan yuh ine-en di punlini nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Datuwen iappit yun maghob ya unnudan yuh miappit an mainum an hinnatkon pe tuwali nan iappit yun maghob ya alinah kabiggabiggatna. Mahapul an am-in nadan iappit yun aggayam ya maid di dipekto da.” ");
INSERT INTO ifk_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Maamung kayu bon am-in ta mundayaw kayun ha-on nah mamangulun algo nah mikapitun bulan. Adi kayu mungngunu kediyen algo ya ipagango yuy tangguyub yu. ");
INSERT INTO ifk_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ya mun-appit kayun ha-on hi maghob ta umamlongak hi hamuy na. Datuwey iappit yu: ohan lakin baka, ohan lakin kalnero ya pitun hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Hay hin-oh-an danae ya unnudan yuh miappit an page an hidiye ya alinan naha-adan hi mantekan di oliba: hay ohan baka ya maunnudan hi umeh tulun kilon alina, hay ohan lakin kalnero ya maunnudan hi umeh duwan kilon alina ");
INSERT INTO ifk_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ya hay ohan ka-ongal nan lakin kalnero ya maunnudan hi umeh ohan kilon alina. ");
INSERT INTO ifk_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. ");
INSERT INTO ifk_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Hinnatkon datuwe nadah iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. Hay hamuy datuwen maghob an iappit yu ya umipaamlong ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Maamung kayun mundayaw ke ha-on nah mikapulun algo nah mikapitun bulan. Muntopol kayun adi kayu mangan ya adi kayu mungngunu. ");
INSERT INTO ifk_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mun-appit kayuh maghob ke ha-on ta umamlongak hi hamuy na. Datuwey iappit yu: ohan ka-ongal nan lakin baka, ohan lakin kalnero ya pitun hintoon an lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Hay hin-oh-an danae ya unnudan yuh miappit an page an hidiye ya alinan naha-adan hi mantekan di oliba: hay ohan baka ya maunnudan hi umeh tulun kilon alina, hay ohan lakin kalnero ya maunnudan hi umeh duwan kilon alina ");
INSERT INTO ifk_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ya hay ohan ka-ongal nan lakin kalnero ya maunnudan hi umeh ohan kilon alina. ");
INSERT INTO ifk_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yun mid-um nah iappit yuh kakaanan di liwat. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Maamung kayu bot mundayaw kayun ha-on nah mikahimpulut liman algo nah mikapitun bulan. Adi kayu mungngunu kediyen pitun algo. ");
INSERT INTO ifk_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Hanah mamangulun algo ya mun-appit kayuh maghob an hidiyey iappit yun makan ke ha-on ta umamlongak hi hamuy na. Datuwey iappit yu: himpulut tulun ka-ongal nan lakin baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Hay hin-oh-an danae ya unnudan yuh miappit an page an hidiye ya alinan naha-adan hi mantekan di oliba: hay ohan baka ya maunnudan hi umeh tulun kilon alina, hay ohan lakin kalnero ya maunnudan hi umeh duwan kilon alina ");
INSERT INTO ifk_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ya hay ohan ka-ongal nan lakin kalnero ya maunnudan hi umeh ohan kilon alina. ");
INSERT INTO ifk_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Hanah mikadwan algo ya iappit yuy himpulut duwan ka-ongal nan lakin baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Hanah mikatlun algo ya iappit yuy himpulut ohan ka-ongal nan lakin baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Hanah mikap-at an algo ya iappit yuy himpulun ka-ongal nan lakin baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Hanah mikaliman algo ya mun-appit kayuh hiyam an ka-ongal nan baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Hanah mikan-om an algo ya mun-appit kayuh walun ka-ongal nan lakin baka, duwan lakin kalnero ya himpulut opat an hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Hanah mikapitun algo ya mun-appit kayuh pitun ka-ongalnan lakin baka, duwan lakin kalnero ya himpulut opat an hintoon an lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ya hanah mikawalun algo ya amungom am-in nadan tatagu ya adi kayu mungngunu kediyen algo. ");
INSERT INTO ifk_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Datuwey iappit yun maghob an umipaamlong ke ha-on: ohan ka-ongalnan lakin baka, ohan lakin kalnero ya pitun hintoonan lakin kalnero. Mahapul an maid di dipekton am-in datuwen aggayam. ");
INSERT INTO ifk_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Dadiyen aggayam ya maunnudan hi iappit yun boga ya mainum. ");
INSERT INTO ifk_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mun-appit kayu boh lakin gulding gapuh liwat ta makaan di liwat yu. Hinnatkon pe tuwali danaen iappit yun maghob an maunnudan hi boga ya mainum nah mamangulun algoh kabulabulan ya kabigabigat. ");
INSERT INTO ifk_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Am-in dadiyen miappit ke dadiyen piyesta ya hinnatkon hanadah miappit an maghob, hay page, hay mainum ya nan iappit yun pakihayyupan ke APU DIOS ya hinnatkon bo nan isapata yu ya inguddan yun iappit.” ");
INSERT INTO ifk_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Intugun Moses am-in danaen tugun APU DIOS nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Hituwey Tugun APU DIOS an kinalinan Moses an kalyona nadah mangipangpanguluh holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“Deket insapatan di ohan tagun idat nay nganneh diye ke ha-on ya mahapul an ipaannung nay insapatanan adina ibahho. ");
INSERT INTO ifk_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Hanan babain makiha-ad ke amanan nunsapatan ha-on hi nganneh diye ya mahapul an ipaannung nah diyen insapatana. ");
INSERT INTO ifk_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Takon hin kananat ininnilan amanah diye mu maid di kalyonan hiyah pangadina ya mahapul an munnanong hidiyen insapatana. ");
INSERT INTO ifk_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mu kal-ina ket dingngol amanay mipanggep kediye ya adina pinhod ya damanan adina paannungon an aton hidiyen insapatana. Pakawanan APU DIOS hidiyen babai te in-adin amanay pangatanan diyen insapatana. ");
INSERT INTO ifk_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Deket nan ugge nangahawan babaiy nunsapata takon hin kananat ninomnom nan ustu weno uggena impakannomnom ot munsapata yaden indani ya nalahin, ");
INSERT INTO ifk_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ya takon di dingngol nan inayanay mipanggep kediye mu adi iadiy pangatanan diye. Ya munnanong nan insapatanat mahapul atona. ");
INSERT INTO ifk_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mu deket mun-adi nan inayana ya damanan adina aton hidiyen insapatana ya adi ibilang APU DIOS an numbahul. ");
INSERT INTO ifk_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Hay nabalu weno nibolhen babai ya mahapul an atonay insapatanan APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Deket nunsapata nan nalahin an babain nun-addum dah nah inayana, ");
INSERT INTO ifk_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","mahapul an atona nan insapatana hin maid di kalyon nan inayanah pangadina. ");
INSERT INTO ifk_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mu deket ininnilan nan inayana ya iadina, damanan adina aton hidiyen insapatana ya adi ibilang APU DIOS an numbahul. ");
INSERT INTO ifk_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Waday kalebbengan nan inayanan mangiadi weno mangiabulut hi pangatanah kediyen insapatana. ");
INSERT INTO ifk_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mu deket ininnilan nan inayana ya maid di kalyonah pangadina ya mahapul an atonah diyen insapatana. Ya hay kitib-anan inabulut na ya ten ugge nun-adi kediyen algon nangngolana. ");
INSERT INTO ifk_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mu deket nabaybayag ot ahi mun-adi, hiyay makastiguh ugge nangatan nan inayanah insapatana.” ");
INSERT INTO ifk_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Datuwey kinalin APU DIOS ke Moses mipanggep hi punhimbaleyan di babai ya lalaki ya hay aton di ohan ama nah imbabalenan babain ugge nalahin an makiha-ad hi balena. ");
INSERT INTO ifk_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Indani kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Kastiguwom nadan tatagud Midian gapuh inat da nadah ibbam an holag Israel. Deket nagibbun inat muh diye ya mate ka mo.” ");
INSERT INTO ifk_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ot kanan Moses nadah tataguy “Mundadaan kayun makigubat ta itakdog yuh APU DIOS ta mibaloy inat di iMidian. ");
INSERT INTO ifk_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mahapul an hinlilibuy malpu ke dakayun holag di imbabalen Israel.” ");
INSERT INTO ifk_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ot pumili nadan holag di imbabalen Israel hi hinlilibu. Ot hay bilang dan am-in an makigubat ya himpulut duwan libu. ");
INSERT INTO ifk_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Intud-ak Moses dadiyen tindalun makigubat an impangulun Pinehas an imbabalen Eleasar an padi. Hiyay ukod nadah nangilinan an ngunut, takon nan tangguyub an usalonan mangipainila ten waday gubat. ");
INSERT INTO ifk_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ginubat day Midian mipuun hi kinalin APU DIOS ke Moses an aton da ot patayon dan am-in di linalaki, ");
INSERT INTO ifk_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","takon nadan liman patul hidin hi Ebi, hi Rekem, hi Sur, hi Hur, ya hi Reba. Ya impakipate dah Balaam an imbabalen Beor. ");
INSERT INTO ifk_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Inala da nadan binabai kediyen boble takon di u-unga, hay baka da, hay kalnero da ya am-in di kinadangyan da ");
INSERT INTO ifk_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ot logabon da nadan boble, takon di kampu da. ");
INSERT INTO ifk_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Inamung dan am-in nadan inala da kediyen boble, nadan tatagu ya aggayam ");
INSERT INTO ifk_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ot ianamut dah kad-an da Moses ke Eleasar an padi ya nadan ibba dan holag Israel nah nungkampuwan da nah nundotal ad Moab an pingngit nan Wangwang an Jordan ya dommang di Jericho. ");
INSERT INTO ifk_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","E dinamun da Moses, hi Eleasar an padi ya nadan mangipangpanguluh holag Israel dida nah e-elen di nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ya bimmoh-ol hi Moses nadah opisyal ya nadah aap-apun nadan tindalun nibangngad an nakigubat. ");
INSERT INTO ifk_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Kananan diday “Tipet uggeyu pinaten am-in nadan binabai? ");
INSERT INTO ifk_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Diday nangilul-uh ibba taku ot ngohayon dah APU DIOS nah Bilid an Peor te inun-unud day intugun Balaam. Ta gapun diye ya impaalin APU DIOS di dogo ke ditakun tataguna. ");
INSERT INTO ifk_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Pumpate yun am-in di u-ungan linalaki, takon nadan binabain inhuyop di lalaki. ");
INSERT INTO ifk_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mu adiyu nadan u-ungan binabai ya nadan binabain ugge inhuyop di lalaki ta alan yu dida. ");
INSERT INTO ifk_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Dakayun waday pinatena weno inodnanah adol di nate, miha-ad kayuh e-elen di kampu takuh pitun algo. Mahapul an aton yuy ine-en di punlini takon nadan balud yu nah mikatlu ya mikapitun algo. ");
INSERT INTO ifk_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Mahapul bon aton yuy ine-en di punlini nadah bulwati yu weno kumpulmin nakapyah lalat, buuk di gulding, ya nadan nakapyah kaiw.” ");
INSERT INTO ifk_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Indani ya kinalin Eleasar an padi nadah linalakin nakigubat an kananay “Datuwe nadan kinalin APU DIOS ke Moses an maunud: ");
INSERT INTO ifk_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","am-in nadan adi maghob, umat hi balituk, silber, giniling, gumok, lata weno lubay ");
INSERT INTO ifk_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ya mahapul an ipadalan yuh apuy ta mibilang dan malini. Ya mahapul pay an maduyagan datuwe nah danum an punlinit mibilang dan malini. Mu nada ken maghob ya mahapul an hay danum ya abuy usalon an punlini. ");
INSERT INTO ifk_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ya hay aton yu nah mikapitun algo ya ibalbal yuy bulwati yu ta mibilang kayun malini ta mabalin an humgop kayuh kampu taku.” ");
INSERT INTO ifk_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Mahapul an bilangon yun da Eleasar ya nadan mangipangpanguluh tatagun am-in nadan naalah gubat takon nadan balud ya aaggayam. ");
INSERT INTO ifk_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Godwaom ta idat muy godwana nadah tindalu ya nan godwana ya idat mu nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Mu hay mamangulun atom ya umala kah hin-oh-ah hinlilimanggatut an balud, baka, kabayu, kalnero ya gulding ta idat mun ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Idat mun Eleasar an padit iappit nan ha-on. ");
INSERT INTO ifk_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ya nan midat nadah tatagu ya bagik di hin-oh-ah hinnanaliman balud, baka, kabayu, kalnero ya gulding. Dadiye ya idat mu nadah holag Libay an mumpaptok tuh Tabernacle.” ");
INSERT INTO ifk_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ot un-unudon da Moses ke Eleasar hidiyen kinalin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Datuwey bilang di inalan nadan tindalu: hay lakin kalnero ya 675,000, ");
INSERT INTO ifk_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","hay bulug an baka ya 72,000, ");
INSERT INTO ifk_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","hay lakin kabayu ya 61,000 ");
INSERT INTO ifk_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ya hay binabain balud an ugge inhuyop di lalaki ya 32,000. ");
INSERT INTO ifk_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Hay kagodwan diyen natdaan an nidat nadah tindalun nakigubat ya 337,500 an kalnero ");
INSERT INTO ifk_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ya niappit ke APU DIOS di 675, ");
INSERT INTO ifk_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","hay baka ya 36,000 ya niappit ke APU DIOS di 72, ");
INSERT INTO ifk_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","hay kabayu ya 30,500 ya niappit ke APU DIOS di 61, ");
INSERT INTO ifk_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","hay balud an binabain ugge inhuyop di lalaki ya 16,000 ya niappit ke APU DIOS di 32. ");
INSERT INTO ifk_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ot idat Moses ke Eleasar an padiy bingay APU DIOS mipuun hi intuguna. ");
INSERT INTO ifk_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Hanan inappil Moses an nidat nadah tatagu ");
INSERT INTO ifk_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ya 337,500 an kalnero, ");
INSERT INTO ifk_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 an baka, ");
INSERT INTO ifk_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 an kabayu ");
INSERT INTO ifk_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ya 16,000 an binabain ugge inhuyop di lalaki. ");
INSERT INTO ifk_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ya in-appit Moses ke APU DIOS di hin-oh-a hi hinnanaliman balud ya aggayam ot idat na datuwe nadah holag Libay an mumpaptok nah Tabernacle. Inat Moses am-in datuwe te hidiyey kinalin APU DIOS an atona. ");
INSERT INTO ifk_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Hanadan opisyal ya ap-apun di tindalu ya imme dan Moses ");
INSERT INTO ifk_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ot kanan day “Apu, binilang min am-in nadan tindalu mi ya wada dan am-in. Maid di nama-id takon di oha. ");
INSERT INTO ifk_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Kinali in-ali min iappit ke APU DIOS datuwen balituk an padang, mihuklub hi takle, hay singsing, hay hingat ya banggol an inala mih gubat ta pangipatibo mih pumpasalamat min maid ke dakamiy nate takon di oha.” ");
INSERT INTO ifk_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ot dawaton da Moses ke Eleasar an padi dadiye nadah aap-apun di tindalu. ");
INSERT INTO ifk_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Hay dam-ot dadiyen balituk an in-appit dadiyen aap-apu ke APU DIOS ya nahawwal hi duwan gatut an kilo. ");
INSERT INTO ifk_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Am-in nadan tindalu ya inala day bingay da nadah inala dah gubat. ");
INSERT INTO ifk_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Dinawat da Moses ke Eleasar nadan balituk an indat nadan aap-apun di tindalu ot ie da nah Tabernacle ta panginomnoman APU DIOS nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Hanadan holag Reuben ke Gad ya dakkodakkol di aggayam da. Handih tinibo dan maphod di Jaser ya Gilead an pumpattolan dah aggayam da ");
INSERT INTO ifk_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ya imme dan Moses ke Eleasar an padi ya nadan udum an mangipangpanguluh holag Israel ot kanan dan diday ");
INSERT INTO ifk_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Dakamin muttatyu yu ya dakol di aggayam mi ya maphod an pumpattolan datuwen boble an Atarot, Dibon, Jaser, Nimrah, Hesbon, Elealeh, Sebam, Nebo ya Beon an sinakup taku gapuh baddang APU DIOS ta pumboblayan takun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Daan mot idat yun dakamit mumboble kamih tu ta takon di adi kami umagwat nah Jordan.” ");
INSERT INTO ifk_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Kanan Moses di “Kon hay pinhod yun kalyon ya miha-ad kayuh tu ta nadan ibba yun holag Israel ya abuy e makigubat? ");
INSERT INTO ifk_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kon pinhod yun dismayaon nadan ibba yun umagwat nah Jordan ta ume da nah boblen indat APU DIOS ke dida? ");
INSERT INTO ifk_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Athinay inat handidan aammod yu handih intud-ak ku didad Kades Barnea ta eda tibon hidiyen boble. ");
INSERT INTO ifk_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Imme da ot mipoppog da nah nundotal ad Eskol, mu handih nibangngad da ya dinismaya day ibba dan holag Israel an ume nah boblen indat APU DIOS ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Gapu kediyen inat da ya bimmoh-ol hi APU DIOS ke dida ot isapatanan ");
INSERT INTO ifk_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","kananay ‘Isapatak an maid nadah muntoon hi duwampulu weno nahawwal an timmayan ad Egypt di dumatong nah boblen kinalik ke Abraham, hi Isaac ya hi Jacob an idat kun dida. ");
INSERT INTO ifk_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ammunah Kaleb an imbabalen Jephunneh an Kenissite ya hi Joshua an imbabalen Nun di dumatong hidi te impaka-un-unudak an hi APU DIOS.’ ");
INSERT INTO ifk_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Bimmobboh-ol hi APU DIOS ot punhanawwangona dida nah adi maboblayan hi nap-at an toon inggana nate dan am-in nan nunliwat ke hiya. ");
INSERT INTO ifk_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Yaden de kayu boh nan nakaliwwat an tatagun aton yu ot ya abuy umat hi inat handidan aammod yu. Mam-ahon yu ot ya abuy boh-ol APU DIOS ke ditakun holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Deket adiyu bo un-unudon hi APU DIOS, dakayun holag Reuben ya holag Gad, ta bumoh-ol ta iwalong ditaku bon holag Israel hituh adi maboblayan ya dakayuy kon bahul hi kadadagan taku.” ");
INSERT INTO ifk_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Hinumang dah Moses an kanan day “Hay pinhod mi kuman aton ya mangapya kamih pukungan di kalnero mi ya hammadon min aladan di boble mit kiha-adan di inayan mi ya nadan imbabale mi. ");
INSERT INTO ifk_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ta deket nagibbu ya alan miy almas mit maki-e kami nadah ibba mit impangulu min didan e makigubat inggana mumboble da nadah boblen nidat ke dida. Yaden nada ken pamilya mi ya malinggop da tuh boblen kapyaon mi te maid nadah tataguh tuy e mangubat ke dida nah naaladan an boble mi. ");
INSERT INTO ifk_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Adi kami umanamut inggana maala da nadan boblen nidat ke dida. ");
INSERT INTO ifk_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Takomboy maid di emi ibagi nadah punggogodwaan dan luta nah bah-el tun Wangwang an Jordan te hitu moh nangappit hi timilan di algod Jordan di bingay mi.” ");
INSERT INTO ifk_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Ot kanan Moses di “Deket makulug hinaen kinali yun gagaid kayun e makigubat ta itakdog yuh APU DIOS, ");
INSERT INTO ifk_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ya deket umagwat nadan tindalu yu ta ipangulun APU DIOS didan e mangubat nadah buhul taku inggana dog-alona didat ");
INSERT INTO ifk_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ibagi taku nadan boble, damanan mibangngad kayu te inat yuy lebbengnan aton yuh pangun-unudan yun APU DIOS ya inat yuy lebbengnan ibaddang yu nadah ibba yun holag Israel. Ta mumboble kayu ketuwen bobleh nangappit hi timilan di algod Jordan an idat APU DIOS ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Mu deket adiyu paannungon hinaen kinali yu ya kalyok ke dakayun munliwat kayun APU DIOS. Kinali tibon yu ot ta adi kayu munliwat te makastigu kayu. ");
INSERT INTO ifk_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Aga, damanan ikapya yuy babale yu ya pukungan di aggayam yu mu adiyu ibahhon aton nan kinali yu.” ");
INSERT INTO ifk_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Kanan dadiyen holag Reuben ya holag Gad di “Dakamin muttatyum ya un-unudon miy kinalim. ");
INSERT INTO ifk_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Mihtu day inayan mi, hay imbabalemi ya aggayam mih tud Gilead, ");
INSERT INTO ifk_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","mu dakamin linalaki ya nundadaan kamin makigubat an hi Apu Dios di AP-APU mi. Un-unudon miy kinalim an agwaton miy Jordan ta ekami makigubat.” ");
INSERT INTO ifk_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Intugun Moses ke da Eleasar, hi Joshua ya nadan mangipangpanguluh tatagun kananay ");
INSERT INTO ifk_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Deket umagwat nadan holag Gad ya holag Reuben nah Jordan ta maki-e dan dakayun e makigubat an ipangulu dakayun APU DIOS ya deket sinakup yun am-in nan boble ya idat yun diday Gilead ta pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mu deket adida pinhod an maki-en dakayun e makigubat ya nah bobled Kanaan di pakibingayan dah pumboblayan da.” ");
INSERT INTO ifk_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kanan nadan holag Gad ya holag Reuben di “Apu, un-unudon miy intugun APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ihamad min mun-almas an umagwat nah Jordan ta ume kamid Kanaan ta ekami makigubat an hi Apu Dios di AP-APU mi, mu hay tawidon mi ya hituh bah-el di Jordan.” ");
INSERT INTO ifk_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ot idat Moses nadah holag Reuben, holag Gad ya godwan di holag Manasseh an imbabalen Joseph di boblen Sihon an patul di Amorite, hay boblen Og an patul di Bashan ya am-in nadan nunlinikkod an bobleh di. ");
INSERT INTO ifk_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Iniphod di holag Gad nadan boble an Dibon, Atarot, Aroer, ");
INSERT INTO ifk_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Sophan, Jaser, Jogbehah, ");
INSERT INTO ifk_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimrah ya Bet Haran. Nahamad an naaladan hi binattu datuwen boble ya wada da boh diy pangipukungan dah aggayam da. ");
INSERT INTO ifk_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Hanadan holag Reuben ya iniphod da nadan boble an Hesbon, Elealeh, Kiriatim, ");
INSERT INTO ifk_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon ya Sibmah. Hinannotan day ngadan nadan udum an boblen sinakup da ot iphod da. ");
INSERT INTO ifk_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ya nadan holag Makir an imbabalen Manasseh ya sinakup day Gilead ot dog-alon da nadan Amorite an numbobleh di. ");
INSERT INTO ifk_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ot idat Moses di Gilead nadah holag Makir an imbabalen Manasseh ot mumboble dah di. ");
INSERT INTO ifk_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Hanadan udum an bobled Gilead ya sinakup di holag Jair an holag damdaman Manasseh ot hannotan day ngadan da ot ngadanan dah Boblen Jair. ");
INSERT INTO ifk_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Hi Nobah ya ginubat nay Kenat ya nadan udum an bobleh di ot sakupona ot ingadanay Nobah an ngadana. ");
INSERT INTO ifk_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Datuwey nitudok an ngadan nadan nungkampuwan nadan holag Israel handih nalpuwan dad Egypt an impangpangulun da Moses ke Aaron. ");
INSERT INTO ifk_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Intudok Moses di ngadan dadiyen nungkampuwan da te hidiyey kinalin APU DIOS an atona. Datuwey dinaladalan dan mainila nadah nungkampuwan da. ");
INSERT INTO ifk_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Timmayan nadan holag Israel handih mikahimpulut liman algoh namangulun bulan hi nabigatan di nala-uwan di anghel APU DIOS. Inadugan APU DIOS didan timmayan nah ongal an boblen ningadanan Rameses yaden ang-angon nadan tatagud Egypt dida. ");
INSERT INTO ifk_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Kediye ya pun-ilubuk dadiyen iEgypt nadan panguluwan an imbabale dan pinaten APU DIOS. Ketuwen inat APU DIOS ya impatibonan ongal di kabaelana mu nadan dios di Egypt. ");
INSERT INTO ifk_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Timmayan nadan holag Israel ad Rameses ot umali dad Sukkot ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Indani ya imme dad Etham nah pingngit nan adi maboblayan ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Tinaynan day Etham ot ibangbangngad da ot mumpalikkod dad Pi Hahirot an dommang di Baal-Sephon ot mungkampu dad Migdol. ");
INSERT INTO ifk_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Tinaynan day Pi Hahirot ot umagwat da nah Maingit an Baybay ot mumpae da nah adi maboblayan. Nundalan dah tulun algo ot dumatong dad Marah ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Timmayan dah di ot ume dad Elim ot mungkampu da boh di te waday himpulut duwan ob-ob ya napitun palmah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Timmayan da boh di ot eda mungkampu nah pingngit di Maingit an Baybay. ");
INSERT INTO ifk_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Timmayan dah di ot ume da nah adi maboblayan an Sin ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Indani ya imme dad Dopkah ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Tinaynan day Dopkah ot eda mungkampud Alus. ");
INSERT INTO ifk_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Indani ya timmayan da boh di ot eda mungkampud Repidim an maid di uminuman da. ");
INSERT INTO ifk_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Indani ya imme da nah adi maboblayan an Sinai ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Timmayan dah di ot eda mungkampud Kibrot Hattaabah. ");
INSERT INTO ifk_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Indani ya imme dad Haserot ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Tinaynan day Haserot ot eda mungkampud Ritmah. ");
INSERT INTO ifk_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Timmayan dah di ot eda mungkampud Rimmon Peres. ");
INSERT INTO ifk_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Indani ya imme dad Libnah ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Imme dad Rissah ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Tinaynan day Rissah ot eda mungkampud Kehelathah. ");
INSERT INTO ifk_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Tinaynan day Kehelathah ot mungkampu dad Sepher an Bilid. ");
INSERT INTO ifk_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Timmayan dah di ot eda mungkampud Haradah. ");
INSERT INTO ifk_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Indani ya imme dad Makhelot ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Tinaynan day Makhelot ot mungkampu dad Tahat. ");
INSERT INTO ifk_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Timmayan dad Tahat ot eda mungkampud Terah. ");
INSERT INTO ifk_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Timmayan dad Terah ot eda mungkampud Mitkah. ");
INSERT INTO ifk_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Indani ya imme dad Hasmonah ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Timmayan dah di ot eda mungkampud Moserot. ");
INSERT INTO ifk_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Timmayan dad Moserot ot eda mungkampud Bene Jaakan. ");
INSERT INTO ifk_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Indani ya imme dad Hor Haggidgad ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Timmayan dah di ot eda mungkampud Jotbathah. ");
INSERT INTO ifk_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Timmayan dah di ot eda mungkampud Abronah. ");
INSERT INTO ifk_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Indani ya imme dad Esion Geber ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Tinaynan dah diye ot eda mungkampud Kades nah adi maboblayan an Sin. ");
INSERT INTO ifk_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Tinaynan day Kades ot eda mungkampu nah Bilid an Hor nah poppog di Edom. ");
INSERT INTO ifk_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kediyen wada dah di nah puun nan bilid ya kinalin APU DIOS ke Aaron an tumikid nah tap-on diyen bilid ot mateh di. Naat hituwe handih nungginawway tialgo handih mikap-at an pulun toon nipalpuh timmayanan dan holag Israel ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Kediyen natayan Aaron ya hinggatut ta duwampulut tuluy toona. ");
INSERT INTO ifk_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Kediye boy nangngolan Arad an patul di Kanaan an mangali nadan holag Israel an mungkih-up da nah boblena. ");
INSERT INTO ifk_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Tinaynan day Bilid an Hor ot eda mungkampud Salmonah. ");
INSERT INTO ifk_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Timmayan dad Salmonah ot eda mungkampud Punon. ");
INSERT INTO ifk_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Tinaynan day Punon ot eda mungkampud Obot. ");
INSERT INTO ifk_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Indani ya imme dad Iye Abarim nah poppog di Moab ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Tinaynan day Iye Abarim ot eda mungkampud Dibon Gad. ");
INSERT INTO ifk_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Timmayan dad Dibon Gad ot eda mungkampud Almon Diblatim. ");
INSERT INTO ifk_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Indani ya imme da nadah bilid ad Abarim an nih-up nah Bilid an Nebo ot mungkampu dah di. ");
INSERT INTO ifk_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Timmayan dah di ot eda mungkampu nah nundotal ad Moab an pingngit nan Wangwang an Jordan ya dommang di Jericho. ");
INSERT INTO ifk_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Hidi nah nundotal ad Moab ya numpapaldang di kampu da nah pingngit di Wangwang an Jordan nipalpud Bet Jeshimot ingganad Abel Sittim. ");
INSERT INTO ifk_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Kimmalih APU DIOS ke Moses hidi an kananay ");
INSERT INTO ifk_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Kalyom hanadah holag Israel an deket umagwat da tuh Wangwang an Jordan ta ume dad Kanaan ya ");
INSERT INTO ifk_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","mahapul an dog-alon dan am-in nadan numbobleh di. Ya mahapul an dadagon dan am-in nadan dios dan kinapyan di tagu takon nadan balen dadiyen dios. ");
INSERT INTO ifk_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Sakupon dat mumboble dah di te indat kun didah diyen boble. ");
INSERT INTO ifk_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Hay atom an mangikap-ong nah luta ya ibunut yu ya hay kabilog di lutan idat mu ya mipuun hi kadakol nadan pangidatam. Deket ittay nan luta ya midat nadah ittay di bilang da. Ya hana ken midat hi hin-oh-an dida mipuun hi binunut ya adinadaman mahannotan. Hinaey aton yun holag Israel an mangikap-ong nah luta. ");
INSERT INTO ifk_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Mu deket adiyu pakaanon nadan tatagun numbobleh di ya ahida mumbalin an kay butah mata yu weno kay pagit. Ahi dakayu paligaton hidi nah pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ya kastiguwon dakayun ha-on umat nah implanuk an atok ke dida.” ");
INSERT INTO ifk_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Datuwey kinalin APU DIOS an itugun Moses nadah holag Israel ");
INSERT INTO ifk_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Gagala mo ya ume kayud Kanaan an boblen indat kun dakayu ya datuwey popoppog na: ");
INSERT INTO ifk_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","hay poppog nah nangappit hi south ya mipalpu nah adi maboblayan an Sin nah poppog di Edom. Ya hay poppog nah nangappit hi timilan di algo ya mipalpu nah Naten Baybay. ");
INSERT INTO ifk_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Numpalikkod nah south an mala-uwan di Scorpion Pass ta mumpaed Sin ingganad Kades Barnea, ya mumpaed Hasar Addar ingganad Asmon. ");
INSERT INTO ifk_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Mipalpud Asmon ot mumpalikkod nah wa-el di Egypt ot mipoppog nah Baybay an Mediterranean. ");
INSERT INTO ifk_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Hay poppog nah nangappit hi kalin-oban di algo ya nan pingngit di Baybay an Mediterranean. ");
INSERT INTO ifk_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Hay poppog nah nangappit hi north ya mipalpu nah Baybay an Mediterranean ta mumpaeh nangappit hi timilan di algo nah Bilid an Hor ");
INSERT INTO ifk_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ingganad Lebo Hamat ta mumpaed Sedad ya ");
INSERT INTO ifk_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Sipron ingganad Hasar Enan. Danaey poppog nan boble yuh nangappit hi north. ");
INSERT INTO ifk_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Hay poppog nah nangappit hi timilan di algo ya mipalpud Hasar Enan ta mumpaeh nangappit hi south ad Sepham ");
INSERT INTO ifk_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ya mumpadayyud Riblah nah nangappit hi timilan di algod Ain. Mipalpu boh di ot mumpadayyu nah pingngit di Baybay an Galilee nah nangappit hi timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Ya in-un-unud na nah Wangwang an Jordan inggana nah Naten Baybay. Danaen am-in di poppog nan boble yu.” ");
INSERT INTO ifk_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Kanan bon Moses nadah holag Israel di “Hituwen bobley punggogodwaan yun ibunut yu. Hay mangikap-ong ketuwe ya nadan hiyam ta godwan di holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Hanada ken holag Reuben ya holag Gad ya godwan di holag Manasseh ya nidatan da mo tuwalih luta da ot ganodwaon da mipuun hi pamilya da. ");
INSERT INTO ifk_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Hidiyen boblen nunggogodwaan da ya pingngit nan Wangwang an Jordan nah nangappit hi timilan di algo ya dommang di Jericho.” ");
INSERT INTO ifk_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Indani ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Datuwe nadan tatagun mangodwa nah luta, hi Eleasar an padi ya hi Joshua an imbabalen Nun. ");
INSERT INTO ifk_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ya ayagan yuy hin-oh-a nadah holag Israel an bumaddang. ");
INSERT INTO ifk_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Datuwey ngadan da: hi Kaleb an imbabalen Jephunneh hi holag Judah, ");
INSERT INTO ifk_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","hi Semuel an imbabalen Ammihud hi holag Simeon, ");
INSERT INTO ifk_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","hi Elidad an imbabalen Kislon hi holag Benjamin, ");
INSERT INTO ifk_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","hi Bukki an imbabalen Jogli hi holag Dan, ");
INSERT INTO ifk_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","hi Hanniel an imbabalen Ephod hi holag Manasseh an imbabalen Joseph, ");
INSERT INTO ifk_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","hi Kemuel an imbabalen Siptan hi holag Eplaim an imbabalen Joseph, ");
INSERT INTO ifk_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","hi Elisaphan an imbabalen Parnak hi holag Sebulun, ");
INSERT INTO ifk_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","hi Paltiel an imbabalen Assan hi holag Issakar, ");
INSERT INTO ifk_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","hi Ahihud an imbabalen Selomi hi holag Asher ");
INSERT INTO ifk_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ya hi Pedahel an imbabalen Ammihud hi holag Naptali.” ");
INSERT INTO ifk_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Datuwe nadan tatagun pinilin APU DIOS an maniboh kaganodwaan di Kanaan ta mikap-ong nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Handih nanongnan dehdi da ni-an nah nundotal ad Moab an pingngit di Jordan ya dommang di Jericho ya kanan APU DIOS ke Moses di ");
INSERT INTO ifk_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Kalyom hanadah holag Israel an idatan da nadan holag Libay hi pumboblayan dan maunnudan hi kudal. ");
INSERT INTO ifk_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ibagi da dadiyen boblet pumboblayan da ya pumpattolan dah baka da, kalnero da ya hay udum an aggayam da. ");
INSERT INTO ifk_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Hay kabilog di pumpattolan da mipalpu nah alad hi nunlinikkod hi hin-oh-a nadah boblen midat ke dida ya umeh liman gatut an metro. ");
INSERT INTO ifk_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Hay kabilog nan kuwadladuh numbinbinah-el ya umeh hinlibun metro. Ya migawwah diy ongal an boble. ");
INSERT INTO ifk_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Hay bilang di boblen idat yun didan holag Libay ya nap-at ta duwa. Ya idat yu pay di onom an boblen kihikugan di tagun pimmaten uggena ingnguddan. ");
INSERT INTO ifk_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Hay mo bilang am-in di boblen idat yun dida ya nap-at ta walun maunnudan hi kudal. ");
INSERT INTO ifk_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Hay bilang di boblen idat di hin-oh-a nadah holag Israel nadah iiba dan holag Libay ya mipuun hi kabilog di lutan nidat ke dida.” ");
INSERT INTO ifk_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Hituwe boy kinalin APU DIOS ke Moses an ");
INSERT INTO ifk_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","ituguna nadah holag Israel: “Deket umagwat kayu nah Wangwang an Jordan ta ume kayud Kanaan ");
INSERT INTO ifk_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","pumili kayuh boblen kihikugan an butikan di tagu ten pimmaten uggena ingnguddan. ");
INSERT INTO ifk_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ta maid di innun nadan iiban nan pinatenan mangibalo. Hay tagun pimmate ya adinadaman mipipate ten ugge nihuhummangan hi hinangngab nadan bimmoble. ");
INSERT INTO ifk_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Tudduwom di onom an ongngal an boblen kihikugan, ");
INSERT INTO ifk_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","tuluh nangappit hi timilan di algo nah Wangwang an Jordan ya tulu ad Kanaan nah nangappit hi kalin-oban di algo. ");
INSERT INTO ifk_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Dadiyen bobley kihikugan di holag Israel, nadan hintaguwan an nakiboble ya takon di dahdin pimmaten uggena ingnguddan. ");
INSERT INTO ifk_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","Mu deket waday in-usal nan taguh namatena, umat hi gumok, batu weno kaiw ya makalin pimmate ta hidiye nan mahapul mon mipipate. ");
INSERT INTO ifk_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Nangamung di iiban nan naten mangibalon mamate kediyen pimmate. Ta deket akhupan da ya patayon da. ");
INSERT INTO ifk_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Deket nan ohan tagu ya pakahingngitanay ibbana ot itulud na weno tinongbana ");
INSERT INTO ifk_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","weno dinuntuk na ot mate ya mibilang an pimmate, ta hidiye nan mahapul an mipipate. Hanan nih-up an iiban nan natey mamate nah pimmate. ");
INSERT INTO ifk_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Mu hin kananat intulud di ohan tagu nan ohan tagu weno intongba na on batu ot matugmilan nan tagu ");
INSERT INTO ifk_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","weno inggahanah batu ot mate mu uggena ingnguddan ya adi mabahulan nan pimmate. ");
INSERT INTO ifk_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Deket waday athidi ya adi kanan nadan bimmoblen munhuwes di nabahulan nan pimmate ya adida kanan di lebbengnan ibalon nadan iiban nan nate. ");
INSERT INTO ifk_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Hanadan bimmoble ya tibon dat adi patayon nadan iiban nan nate ya ibangngad dah diyen tagu nah boblen kihikuganan niha-adana ni-an. Ya mahapul an mumboble moh di inggana mate nan katagtag-ayan an padi. ");
INSERT INTO ifk_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Mu deket timmayan nan pimmate nah boblen kihikugan ");
INSERT INTO ifk_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ot akhupan di iiban nan pinatena ot patayon da, adida makastigu kediyen inat da. ");
INSERT INTO ifk_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Hanan tagun pimmaten uggena ingnguddan ya mahapul tuwalin munnanong an mumboble nah boblen kihikugan inggana mate nan katagtag-ayan an padi. Ne damana mon mibangngad hi boble da. ");
INSERT INTO ifk_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Datuwen tugun ya mahapul an un-unudon yun nadah holag yu ta nangamung takon di daanay pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Hanan tagun pimmate te pinhod nan pumate weno gapuh bungot na ya makastigu ta mipipate hin waday duwa weno dakdakol an tistigun mangiuh-u nah inat na. Deket ohay tistigu ya adi umustuh diyen mangidat hi ebidensiya. ");
INSERT INTO ifk_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Hay tagun pimmate gapu te pinhod na weno gapuh bungot na ya mahapul nimpen mipipate. Adinadaman mumbayad ta malibli kediyen kastiguna. ");
INSERT INTO ifk_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Deket hay athidin pimmate ya binumtik an imme nah boblen kihikugan, adiyu iabulut an mumbayad ta damanan mibangngad hi boble da yaden ugge ni-an nate nan katagtag-ayan an padi. ");
INSERT INTO ifk_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Deket inat yuy athidi ya mabahulan kayu te hinibit yuy boble yu. Hay athidin pumatayan ya hibitonay boble ta hidiye nan mahapul an pipate yu nan pimmate ta hidiyey mibilang an punlini nah boble. ");
INSERT INTO ifk_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Kinali adiyu hibiton nan boblen eyu pumboblayan te makibobleyak ke dakayun holag Israel.” ");
INSERT INTO ifk_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Hanadan mangipangpanguluh pamilyan nadan holag Gilead an imbabalen Makir an imbabalen Manasseh an imbabalen Joseph ya imme da ke Moses ya nadan udum an mangipangpangulu ot ");
INSERT INTO ifk_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","kanan day “Kinalin APU DIOS an ipabinnunut muy panganodwaam nah lutat ikap-ong min holag Israel. Kinalinan idat muy lutan Selophehad an tulang mi nadah binabain imbabalena. ");
INSERT INTO ifk_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Mu deket hay iine da ya malpuh udum an puun ya ume mo nan lutan nidat ke dida nadah nangapun dida. Deket athidiy maat ya umittay mo nan lutan nidat ke dakami. ");
INSERT INTO ifk_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ya deket nadatngan nan toon an pangibangngadan hi ngannen ginatang ya mibangngad nah datin kon bagi, ta nan lutan Selophehad an binoltan di imbabalena ya mid-um hi lutan nadan nakiahawaan dat ibagi dat nangamung ya makaan moh luta mi.” ");
INSERT INTO ifk_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ot itugun Moses di kinalin APU DIOS nadah tatagu. Kananay “Niptok di kinalin nadan holag Manasseh. ");
INSERT INTO ifk_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Kanan APU DIOS di damanan kumpulmiy pinhod nadan binabain holag Manasseh an iine mu mahapul an hay ibba yun holag Manasseh di iine da. ");
INSERT INTO ifk_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ta nan binoltan di hin-oh-an holag Israel ya munnanong ke didan ohan puun. ");
INSERT INTO ifk_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Ta hidiye nan am-in di binabain holag Israel an waday binoltana ya iine nay lalaki nah puun da ta munnanong nan boltanon da ke didan ohan puun. ");
INSERT INTO ifk_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ta adi umeh udum an puun di nganneh diyen boltanon da mu munnanong ke dida.” ");
INSERT INTO ifk_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Ot un-unudon nadan binabain imbabalen Selophehad hidiyen intugun APU DIOS ke Moses. ");
INSERT INTO ifk_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Hi Mahlah, hi Tirsah, hi Hoglah, hi Milkah ya hi Noah ya in-ine day iiba dan imbabalen di tulang amadan ");
INSERT INTO ifk_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","holag Manasseh an imbabalen Joseph. Ot munnanong ke dida ohan puun nan lutan binoltan da. ");
INSERT INTO ifk_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Danaey intugun APU DIOS ke Moses. Ot ituguna damdama nadah ibbanan holag Israel handih nungkampuwan da nah nundotal ad Moab nah pingngit di Jordan ya dommang di Jericho. ");
INSERT INTO ifk_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Hituwen libluy nitudokan nadan kinalin Moses nadah holag Israel handih wada da nah adi maboblayan nah nangappit hi timilan di algo nah Wangwang an Jordan. Nungkampu dah di nah nundotal an nih-up ad Sup ya numbattanan di Paran ya nadan boble an Topel, Laban, Haserot ya Disahab. ");
INSERT INTO ifk_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Hay ustuh bilang di algon pundalanan an malpu nah Bilid an Sinai ingganad Kades Barnea ten idalan da nah Bilid an Seir ya himpulut ohan algo. ");
INSERT INTO ifk_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Handih namangulun algoh mikahimpulut ohan bulan nah mikanap-at an toon nipalpuh nalpuwan dad Egypt ya kinalin Moses am-in di intugun APU DIOS nadah ibbanan holag Israel. ");
INSERT INTO ifk_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Kediye ya nagibbun inapput APU DIOS hi Sihon an patul di Amorite an nun-ap-apud Hesbon ya hi Og an patul di Bashan an nun-ap-apud Astarot ya Edrei. ");
INSERT INTO ifk_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","In-esplikar Moses di mipanggep nadah tugun ya nadan tuttudun Apu Dios handih wada dad Moab nah nangappit hi timilan di algo nah Wangwang an Jordan. ");
INSERT INTO ifk_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Kananay “Handih wada taku nah Bilid an Sinai ya kanan nan AP-APU an Dios takuy ‘Nabayag kayu mon niha-ad hitu. ");
INSERT INTO ifk_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Paluhon yuy kampu yu ta ume kayu nah mabilid an boblen nadan Amorite, nadah nunlinikkod an bobleh di, nah nundotal ad Jordan, nadah boblen nah mabilid ya nah nundotal an boblen nangappit hi kalin-oban di algo ad Negeb ya nadah bobleh pingngit di Baybay an Mediteranean. Ya ume kayud Kanaan ya la-uwan yu nadan bilid ad Lebanon inggana nah Wangwang an Euphrates. ");
INSERT INTO ifk_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Datuwe nadan boblen kinalik an idat kun Abraham, hi Isaac, hi Jacob ya nadah holag dat pumboblayan da.’” ");
INSERT INTO ifk_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Kanan Moses nadah tataguy “Handih wada taku ni-an nah Bilid an Sinai ya kinalik ke dakayun adik kabaelan an mangipaptok ke dakayun am-in. ");
INSERT INTO ifk_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Te impadakkodakkol dakayun nan AP-APU an Dios yuh umat hi kinadakol nadan bittuwon hi kabunyan. ");
INSERT INTO ifk_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Man-uke ya kinalik tuwalin hana ot ta paannungon nan AP-APU an Dios handidan aammod takuy kinalinan dida handi an padakkolon dakayu pay hi maminhinlibu, ya pakadangyanon dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Muden nganney innuk an mangipanu nadah punhahallaan yu ya pun-aawwitan yu ten ohaak an mangiat? ");
INSERT INTO ifk_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Manomnom yun kinalik an pumili kayuh hin-oh-a nadah holag Israel hi nalaing, nalakan mun-awat ya maphod di pangi-enat tudduwok didan mangipangpangulun dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ya timbal yun maphod hidiyen ninomnom kun aton taku. ");
INSERT INTO ifk_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ot dadiyen pinili yu ya impumbalin ku didan huwes ya opisyal. Ya hay udum ya tinudduk an mun-ap-apuh hinlibun tatagu, hay udum ya mun-ap-apuh hinggatut, hay udum ya mun-ap-apuh nalima ya hay udum ya mun-ap-apuh himpulu. ");
INSERT INTO ifk_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Intugun kun dadiyen huwes an kanak ke diday ‘Mahapul an maandong ta nangamung di pangat yu, bokon ya abu nadah holag Israel mu takon hanadah nakiboblen dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Iphod yuy punhahallaan di ibba yun holag Israel. Adiyu paboran nan tagu gapu te kadangyan. Mahapul an mun-iingngoy pangat yu nadah nawotwot ya kakadangyan. Adi kayu tumakut hi ngannen aton da te itakdog yuh Apu Dios hi pangipanuhan yu nadah kasu. Hanadan kasun naligat yun ipanu ya iali yun ha-on.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Kediye bo ya kinalik ke dakayun am-in nadan mahapul an aton yu.” ");
INSERT INTO ifk_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Indani ya timmayan taku nah Bilid an Sinai te hidiyey kinalin APU DIOS an Dios takun aton taku ot mundalan taku nah adi maboblayan an ambilog ya katatakut an tinibo yu mismu. Ot ahi taku mumpae nah mabilid an boblen di Amorite. Ya handih dimmatong takud Kades Barnea ya ");
INSERT INTO ifk_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","kanak ke dakayuy “Dimmatong taku mo nah boblen indat AP-APU an Dios ke ditaku. ");
INSERT INTO ifk_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Deya! Ekayu mumbobleh di! Adi kayu munhalinduwa ya adi kayu tumakut. Te kinalin AP-APU an Dios handidan aammod takun idat nah tuwen boble. ");
INSERT INTO ifk_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Mu kanan yuy ‘Umitud-ak takuh e munsiim ya ta panginilaan taku hin daan di maphod an dalanon ya hin ngannen bobley etaku hogpon.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ya hay punnomnom ku ya maphod hidiye ot pumiliyak hi himpulut duwan linalakin nalpuh hin-oh-a ke dakayun nahlag nadah holag Israel. ");
INSERT INTO ifk_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Imme dan lina-uwan da nadan bibilid ot ume da nah nundotal ad Eskol ot eda hinapon an tiniboh diyen boble. ");
INSERT INTO ifk_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ya handih nibangngad da ya waday in-anamut dah bungan di nitanom an inilpu dah di. Ya kinali dan maluwab di mitanom kediyen boblen indat AP-APU an Dios ke ditaku. ");
INSERT INTO ifk_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Mu nginohe yuy kinalin AP-APU an Dios yun aton yu te adiyu pinhod an umeh di. ");
INSERT INTO ifk_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Mungngudu kayu ya mundiklamu kayun kanan yuy ‘Kahingngitan ditaku nin ke APU DIOS te impangulu ditakun tumayan ad Egypt ta iali ditakuh tu ta patayon ditaku nadah Amorite. ");
INSERT INTO ifk_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kinali adi taku kaya umeh di. Te kinalin nadan intud-ak takun e nunsiim an natagtag-e ya nalnal-ot nadan tataguh di mu ditaku. Ya nakattag-ey binattun alad dan datnganay kabunyan. Ya tinibo da pay kanuy o-ongal an tatagun holag Anak.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Mu kinalik ke dakayun adi kayu tumakut ke dadiyen tatagu ");
INSERT INTO ifk_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","te ipangulu dakayun AP-APU an Dios yu ya hiyay makigubat ta itakdog dakayu, umat nah tinibo yun inat nad Egypt ");
INSERT INTO ifk_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ya nah adi maboblayan. Takon di dakayu ya tinibo yuy numpanaptok APU DIOS an Dios yu ke ditaku tuh adi maboblayan, umat hi pamaptok di ohan ama hi imbabalena. Ot deyan iali ditakuh tu. ");
INSERT INTO ifk_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Mu takon di inainat AP-APU an Dios yu dadiye ya adi kayu metlaing madinol ke hiyan ");
INSERT INTO ifk_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","nangipangulun ditaku nadah maphod an etaku pungkampuwan an mumbalin hiyan apuy nah hilong ya mumbalin an kulabut nah mapat-al. ");
INSERT INTO ifk_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kinali handih dingngol nay diklamu yu ya namahig di boh-ol na. Ot isapata nan kananay ");
INSERT INTO ifk_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Maid ke dakayun gaga-ihon tatagud uwaniy tumagun umeh din e manibo nah maphod an boblen insapatak an idat ku handidah aammod yu. ");
INSERT INTO ifk_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Ammunah Kaleb an imbabalen Jephunneh di umeh di. Idat kun hiya ya nadan holag na nadan boblen hininap na. Te hiya ya abuy nanongnan mangun-unud ke ha-on.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Gapun dakayu ya bimmoh-ol hi APU DIOS damdaman ha-on ot kananay ‘Takon di he-a Moses ya adika umeh di. ");
INSERT INTO ifk_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Mu patulidom nan bumadbaddang ke he-an hi Joshua an imbabalen Nun ta hiyay mangipangulu nadah tatagun e mumbobleh di. ");
INSERT INTO ifk_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Hanadan iimbabale yun ugge pay ni-an nanginilah maphod ya ad-adin itattakut yun madpap ta mikalabut di umen e mumbobleh di. ");
INSERT INTO ifk_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Mu dakayu ke ya mibangngad kayun idalan yu nah adi maboblayan ta mumpae kayu nah Maingit an Baybay.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Indani ya kanan yun ha-on di ‘Nunliwat kamin APU DIOS an Dios mi, mu ume kami ta ekami makigubat ta mumboble kami nah boble mi te hidiyey kinalina.’ Ot pun-ihakbat yuy almas yu te pangali yu on nalakay panggopan yun diyen mabilid an boble. ");
INSERT INTO ifk_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Mu kanan APU DIOS ke ha-on di ‘Kalyom ke didah tuwe: Adi kayu umen e mangubat ke diyen boble te adiyak maki-en dakayu. Deket ume kayu ya nunna-ud an apputon dakayuh buhul yu.’ ");
INSERT INTO ifk_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ot kalyok ke dakayu, mu adiyak donglon. Ot kay kayu hiyyahiyyan e nangubat kediyen mabilid an boble te nginohe yuh APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Bimmudal nadan dakkodakkol an Amorite an kay da iyyukan an nangubat ke dakayu. Ot pumpudug dakayu mipalpud Seir ingganad Hormah ot apputon dakayu nah mabilid an bobled Edom. ");
INSERT INTO ifk_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Indandani ya nibangangad kayu ot mumpahpahmok kayun mumpabaddang ke APU DIOS, mu adina donglon di dasal yu ya adi dakayu hangudon ke hiya. ");
INSERT INTO ifk_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ot mabayag takun nungkampud Kades Barnea.” ");
INSERT INTO ifk_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Nibangngad taku ot mumpae taku nah adi maboblayan hi nangappit nah Maingit an Baybay te hidiyey kinalin APU DIOS ke ha-on an aton taku. Ot humanawwangan takuh nabayag nah mabilid ad Edom. ");
INSERT INTO ifk_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Indani ya kinali bon APU DIOS ke ha-on di ");
INSERT INTO ifk_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Mumpae kayuh nangappit hi north te nabayag kayun himmanawwangan tuh mabilid an boble. ");
INSERT INTO ifk_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ya itugun mu datuwe nadah tatagu: ‘La-uwan yuy boblen nadan Edomite an iiba yun holag Esau an numbobled Seir. Ahida tumakut ke dakayu, mu tibon yu ot di aton yu. ");
INSERT INTO ifk_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Adi kayu makigubat ke dida te indat kun dida nadan boblen nunlinikkod nah Bilid an Seir. Maid ke dadiyen bobley ek idat ke dakayu takon di ittay. ");
INSERT INTO ifk_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Mu damanan gumatang kayuh makan ya danum ke dida.’ ");
INSERT INTO ifk_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Nomnomon yun binendisyonan ditakun APU DIOS an Dios taku hi am-in hanadah inat taku. Ya impaptok ditakun hiyah niha-ha-adan taku tuh ambilog an adi maboblayan ya nikuyukuyug ke ditaku hantuh nala-un nap-at di toon ya indat nan am-in di mahapul taku.” ");
INSERT INTO ifk_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Nangnangnge taku ot la-uwan takuy numboblayan nadan iiba takun holag Esau ad Seir. Ya ugge taku indalan nah kalatan Arabah an numpatikid an nalpud Elat ya Esion Geber. Ya handih intuluy takun nangen numpae takuh nangappit hi north an indalan taku nah adi maboblayan ad Moab ");
INSERT INTO ifk_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ya kimmalih APU DIOS an kananay “Tibon yu ta maid di eyu aton hi humlun hi pakigubatan nadan iMoab an holag Lot ke dakayu. Te indat kuy Ar an boble ke dida ya maid kediyen bobley ek idat ke dakayu.” ");
INSERT INTO ifk_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Hay numbobled Ar handi ya nadan o-ongal ya nungkatatag-en tatagun holag Emim. Nun-iingngo da nadah holag Anakim an o-ongal an tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Dida ya nadan Anakim ya nangadanan dah Repaim, mu hay pungngadan di iMoab ke dida ya Emim. ");
INSERT INTO ifk_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Handi ya nadan Horite di numboble nah Bilid an Seir, mu dinog-al di holag Esau dida. Dinadag dadiyen holag Esau hi diyen boble ot diday mihannot an numbobleh di, umat hi inat nadan holag Israel an dinog-al day buhul dan numbobled Kanaan an indat APU DIOS ke dida. ");
INSERT INTO ifk_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Ot agwaton taku nan Wa-el an Sered te hidiye tuwaliy kinalin APU DIOS an aton taku. ");
INSERT INTO ifk_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Kediye ya nala-uy tulumpulut walun toon nipalpu handih dimmatongan takud Kades Barnea inggana immagwat taku kediyen Wa-el an Sered. Man-uket nabayag takuh di ya insapatan APU DIOS an mahapul an maten am-in nadan mabalin an makigubat. ");
INSERT INTO ifk_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Namahig di inat APU DIOS ke dida inggana nate dan am-in. ");
INSERT INTO ifk_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Handih naten am-in dadiyen aammod yu ");
INSERT INTO ifk_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ya kanan APU DIOS ke ha-on di ");
INSERT INTO ifk_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Tumayan kayud Moab ad uwanin algo an idalan yud Ar an poppog na ");
INSERT INTO ifk_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ta ume kayud Ammon an numboblayan nadan Ammonite an holag Lot. Mu adiyu gubaton dida te maid di idat kun dakayu kediyen luta, man-uke ya indat kun didah diye.” ");
INSERT INTO ifk_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Hidiyen boble ya Repaim ni-an di ngadana an hidiyey ngadan nadan numbobleh di handi. Ya hay pungngadan di Ammonite ke dida ya Samsummim. ");
INSERT INTO ifk_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Natag-e dan umat hi kinatag-en nadan Anakim ya dakol da ya nakal-ot da bo udot. Mu dinadag APU DIOS dida ot mihannot nadan Ammonite an numbobleh di. ");
INSERT INTO ifk_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Athidi boy inat APU DIOS nadah Horite an numboble nah Bilid an Seir an dinadag na dida ta mumboble nadan Edomite an nahlag ke Esau nah boble da. Ot diday numbobleh di ingganad uwani. ");
INSERT INTO ifk_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Athidi boy inat nadan tatagun nalpud Crete an ginubat da nadan Abbite ot dadagon da dida ot didan tatagud Crete di mihannot an numbobled Gaza an boble da. ");
INSERT INTO ifk_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Handih lina-uwan takud Moab ya kanan APU DIOS di “Agwaton yu nan Wangwang an Arnon ta eyu gubaton hi Sihon an Amorite an patul di Hesbon ot pangapputon dakayun ha-oy ta dakayuy mumboble nah numboblayan da.” ");
INSERT INTO ifk_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Kanana boy “Mipalpud uwani ya wadaok di takut am-in hanadah mangngol hi mipanggep ke dakayun holag Israel ta takon di ammunay ngadanon day ngadan yu ya gumayonggong dah takut da.” ");
INSERT INTO ifk_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Ya handih wada taku nah adi maboblayan ad Kedemot ya immitud-akak hi e makihummangan ke Sihon an patul di Hesbon ta maphod di punhahayyupan taku. ");
INSERT INTO ifk_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Kanak di ‘Daan mot iabulut mun mundalan kami tuh boble yu. Takombo ot ammunay iun-unud mih kalatay dalanon min adi kami humingngi nadah papayoh numbinnah-el. ");
INSERT INTO ifk_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Bayadan min am-in di kanon ya inumon min alan min dakayu. Hay ya abu pinhod mi ya iabulut mu anhan an dumalan kami tuh boble yu ");
INSERT INTO ifk_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","umat hi inat nadan holag Esau an numbobled Seir ya nadan iMoab an numbobled Ar an in-abulut dan mundalan kamih boble da, inggana immagwat kamid Jordan ta ume kami nah boblen idat APU DIOS an Dios ke dakami.’ ");
INSERT INTO ifk_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Mu ugge in-abulut Sihon an patul di Hesbon an etaku mundalan hi boble da. Man-uke ya hi APU DIOS an Dios taku ya impumbalina didan mangohe ya kahing ta waday humlun an munggugubat takut pangapputon ditaku ot deyan inat nad uwani. ");
INSERT INTO ifk_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Indani ya kanan bon APU DIOS ke ha-on di ‘Ipaapput ku nan patul an hi Sihon ya idat kuy boble dan dakayu. Kinali eyu gubaton ta mumboble kayuh boble da.’ ");
INSERT INTO ifk_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Ot handih wada takud Jahas ya immalih Sihon ya nadan titindalu na ot gubaton ditaku. ");
INSERT INTO ifk_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Mu impaapput APU DIOS an Dios taku dida ot patayon taku nan patul da, nadan iimbabalenan linalaki ya nadan titindaluna. ");
INSERT INTO ifk_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Dinadag taku boy boble da ya numpate taku nadan bimmoble, linalaki, binabai ya u-ungnga ot maid di natdaan takon di oha. ");
INSERT INTO ifk_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Ya inala takuy aaggayam da ya am-in di nabalol an wadah boble da. ");
INSERT INTO ifk_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Binaddangan ditaku bon APU DIOS an Dios taku ot sakupon takuy Aroer an pingngit di nundotal ad Arnon, ya nan boblen nigawwah di takon nadan bobled Gilead. Maid ke dadiyen naaladan an bobley etaku ugge kinabaelan an hinggop. ");
INSERT INTO ifk_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Mu ugge taku numpae nah numboblayan nadan Ammonite, takon hanadah bobleh pingngit di Wangwang an Jabbok, nadan bobleh mabilid ya am-in nadan boblen kinalin APU DIOS an Dios takun adi taku pangayan.” ");
INSERT INTO ifk_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“Indani ya numpae takud Bashan ya nan patul an hi Og ya impangulunay tindaluna ot gubaton ditakuh di nah nih-up ad Edrei. ");
INSERT INTO ifk_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Mu kanan APU DIOS ke ha-on di ‘Adika tumakut ke hiya, ipaboltan kun dakayuy tataguna ya boblena. Aton yun hiyay umat hi inat yun Sihon an patul di Amorite ad Hesbon.’ ");
INSERT INTO ifk_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Ot paapput APU DIOS an Dios takuh Og ya nadan tindaluna ot patayon taku didan am-in. ");
INSERT INTO ifk_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ot hogpon taku nadan nan-om an bobled Argob ad Bashan an numpatulana. ");
INSERT INTO ifk_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Yaden nungkatag-e ya nahamad di binattun alad dadiyen o-ongal an boble ya waday hoob da. Ya hinggop taku bo nadan ugge naaladan an bobleh di. ");
INSERT INTO ifk_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Ot dadagon taku dadiyen boble ya numpate taku nadan bimmoble, linalaki, binabai ya u-unga umat hi inat taku nadah bobleh pun-ap-apuwan Sihon an patul ad Hesbon. ");
INSERT INTO ifk_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ya nun-ala takuy aaggayam da ya nadan nganneh diyen wada ke dadiyen boble. ");
INSERT INTO ifk_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Ot kediyen tiempo ya sinakup takuy boblen dadiyen duwan patul di Amorite nah nangappit hi timilan di algo nah Wangwang an Jordan mipalpu nah Wangwang an Arnon inggana nah Bilid an Hermon. ");
INSERT INTO ifk_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Hay pungngadan di iSidon kediyen Bilid ya Sirion ya nadan Amorite ya pungngadan da ya Senir.) ");
INSERT INTO ifk_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Sinakup takun am-in di boblen Og an patul di Bashan an dadiye ya nadan o-ongal an bobleh tap-on di bilid, am-in nadan bobled Gilead ya hay Bashan inggana nadah bobled Salekah ya Edrei. ");
INSERT INTO ifk_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Hi Og an patul di Bashan ya abuy natdaan hanadah o-ongal an tagun holag Repaim. Hay lunguna ya nakapyah gumok an onom an piyey kabilog na ya dandanin himpulut opat an piyey kadukkena mipuun nah maunud an punlukud. Dehdi pay ad uwanih diyen lungunad Rabbah an ongal an bobled Ammon.) ");
INSERT INTO ifk_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Kediyen sinakup takuh diyen boble ya indat ku nadah holag Reuben ya holag Gad di north di Aroer an nih-up nah Wangwang an Arnon, hay godwan di Gilead ya nadan i-itay an bobleh di. ");
INSERT INTO ifk_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Indat kuh godwan di holag Manasseh nan udum an bobled Gilead, am-in di bobled Bashan an boblen Og an dadiyen am-in nadan bobled Argob. (Hanadan bobled Argob ad Bashan ya boblen di holag Repaim handi. ");
INSERT INTO ifk_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Ya hi Jair an oha nadah mangipangpanguluh holag Manasseh di nidatan am-in dadiyen bobled Argob inggana nah poppog di Geshur ya Maakah. Ningadan di ngadana ke dadiyen boble ot hay ngadana ingganad uwani ya ‘Boblen Jair’.) ");
INSERT INTO ifk_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Indat kuy Gilead nadah holag Makir. ");
INSERT INTO ifk_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Mu nada keh holag Reuben ya holag Gad ya indat kun dida nadan boble mipalpuh poppog di Gilead inggana nah Wangwang an Arnon. Ya hay poppog diyen boble dah nangappit hi south ya nan gawwan nan wangwang. Hay poppog nah nangappit hi north ya nan Wangwang an Jabbok an hidiyey poppog di Ammon. ");
INSERT INTO ifk_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Hay poppog nah nangappit hi kalin-oban di algo ya nan Wangwang an Jordan, mipalpu nah Baybay an Galilee hi nangappit hi north inggana nah Naten Baybay hi nangappit hi south ya inggana nah puun nan Bilid an Pisgah nah nangappit hi timilan di algo. ");
INSERT INTO ifk_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Kediye bo ya intugun ku nadah holag Israel an mumboble nah nangappit hi timilan di algod Jordan an kanak di ‘Man-ut indat APU DIOS an Dios yu ke dakayuh tuwen boble ta pumboblayan yu, mu mahapul an mundadaan nadan mabalin an makigubat an mun-almas dat umagwat da nah wangwang ta baddangan da nadan ibba dan holag Israel an e munsakup nah nituddun pumboblayan da. ");
INSERT INTO ifk_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mu nadan inayan yu, iimbabale yu ya nadan dakkodakkol an aggayam yu ya mihtu dah tuh boblen idat kun pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Man-uke ya mahapul an baddangan yu nadan ibba yun holag Israel an munsakup nadah bobleh nangappit hi kalin-oban di algo nah Wangwang an Jordan an idat APU DIOS an Dios yu ke dida. Ta deket malinggop dan mumbobleh di, umat ke dakayun impalinggop dakayun APU DIOS hitu ya ahi kayu uppe nibangngad boble yun indat kun dakayu.’ ");
INSERT INTO ifk_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Kediye bo ya intugun kun Joshua an kanak di ‘Tinibom nadan inat APU DIOS an Dios mu nadah duwan patul an hi Og ya hi Sihon. Athidi boy ahina aton hi aap-apun nadan boblen eyu sakupon. ");
INSERT INTO ifk_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Adika tumakut ke dida te itakdog dakan APU DIOS an Dios mu ta hiyay makihanggan dida.’ ");
INSERT INTO ifk_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Kediye ya namahig di dasal kun kanak di ");
INSERT INTO ifk_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘APU DIOS an Nakattag-e, inilak an nadan na-na-at an impatibom ke ha-on an muttatyum di lappun nan dakol an ahim aton an kitib-an di ongal an kabaelam. Maid di udum an dios hi kabunyan ya hituh lutan kabaelanan mangat hi umat nadah inat mun umipamodwong. ");
INSERT INTO ifk_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Daan mo anhan APU DIOS ta iabulut mun umagwatak nah Wangwang an Jordan ta tibok di bah-el tun wangwang an maluwab di mitanom, nadan makakkaphod an boble nah mabilid ya nadan bibilid ad Lebanon.’ ");
INSERT INTO ifk_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Mu gapun dakayu ya bimmoh-ol hi APU DIOS ke ha-on ya adina mo donglon di dasal kut kanana ot ya abuy ‘Abu! Itikod mun mundasal ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Adik iabulut an agwatom nan Wangwang an Jordan. Muntikid ka nah tap-on nan Bilid an Pisgah ta mun-uhdung kat tibom am-in nadan bobleh nunlinikkod ad Kanaan. ");
INSERT INTO ifk_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ya kalyam ya patulidom ot ya abuh Joshua te hiyay mangipangulu nadah tatagun umagwat nah Wangwang an Jordan ta eda sakupon dadiyen boblen tinibom ta mumboble dah di.’ ");
INSERT INTO ifk_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ot miha-ad takuh di nah nadayyukung an dommang di Bet Peor.” Danaey kinalin Moses nadah tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Kanan Moses nadah tataguy “Pakaddonglon yu hantudan Tugun an kalyok ke dakayu. Ya un-unudon yu ta adi kayu mate ya ta ekayu mumboble nah kinalin APU DIOS an Dios handidan aammod takun idat nan dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Adinadaman eyu kaanan weno udman hantudan kinalik an Tugun APU DIOS an Dios taku. Un-unudon yun am-in datuwen Tuguna. ");
INSERT INTO ifk_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Dakayu ya impakattibo yuy inat APU DIOS nah bilid ad Baal Peor an pinaten APU DIOS an Dios taku nadan ibba takun holag Israel an nundayaw ke Baal. ");
INSERT INTO ifk_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Mu dakayun impunnanong nan nangun-unud ke APU DIOS an Dios yu ya nanongnan matagu kayu. ");
INSERT INTO ifk_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Intuttuduk ke dakayu nadan Tugun APU DIOS an Dios ku an un-unudon yu nah boblen eyu hogpon ta pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Deket paka-un-unudon yu datuwen Tugun ya hidiyey pangitib-an di tataguh udum an boblen nalaing kayu ya nanomnoman kayu. Ne kanan day ‘Anakkayang peman, kon waday umat ke datuwen himpamoblen nakala-ing da ya nanomnoman da?’ ");
INSERT INTO ifk_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Maid di udum an boblen takon di nundingngol ya e waday dios dan umat ke APU DIOS an Dios takun wadat nangamung ke ditaku ya humangonay dasal takuh pumpabaddangan takun hiya. ");
INSERT INTO ifk_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ya kon waday ohan nundingngol an boblen waday tugun dan makaphod an umat nadah Tugun an un-unudon taku? ");
INSERT INTO ifk_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Mu halipat-an yu ta pakappohdanan yun adiyu kal-iwan nadan tinibo yun inat APU DIOS an kiphodan yu. Ya mahapul an pakannomnomon yu bon kalkalyon hanadah imbabale yu ya inap-apu yuy mipanggep ke dadiye. ");
INSERT INTO ifk_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Adiyu bo kal-iwan handih timmaddog kayud Sinai hi hinangngab APU DIOS an Dios yu. Man-uke ya kinalinan ha-on di ‘Ayagam am-in nadan tatagu ta maamung dah hinangngab ku ta kalyok ke diday pinhod kun aton da. Ta adalon dan tumakut ya mangun-unud ya mundayaw ke ha-on ya ta ituttudu da damdama dadiyeh iimbabale dah udum hi algo.’ ");
INSERT INTO ifk_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ot kediye ya ekayu nimpe timmaddog nah nih-up hi puun diyen bilid an mundadalang an mumpatap-oy ahuk na ya nihophop di mahdol an kulabut ya mangitit an ahuk kediyen bilid. ");
INSERT INTO ifk_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Kimmalih APU DIOS ke dakayun nalpuy kalina nah apuy. Ya man-ut dingngol yuy kalina, mu uggeyu tiniboy angana. ");
INSERT INTO ifk_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Kinalinah nakitobbalanan dakayu an mahapul an un-unudon yu nadan Himpulun Tugun an intudok nah duwan nadampilag an batu. ");
INSERT INTO ifk_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Kediyen tiempoy nangalyanan ha-on an ituttuduk ke dakayun am-in nadan Tugun an un-unudon yu nah boblen eyu sakupon ta pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Mu halipat-an yu! Uggeyu tiniboy ang-ang APU DIOS handih nalpuy kalina nah apuy ad Sinai an Bilid, kinali tibon yu ot ");
INSERT INTO ifk_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ta adi kayu e mangapyah dayawon yun ing-ingon di nganne, lalaki weno babai, ");
INSERT INTO ifk_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","aggayam weno hamuti, ");
INSERT INTO ifk_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","hay mungkaddapan, weno hay dolog. ");
INSERT INTO ifk_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ya deket itangad yuh kabunyan ta tibon yu nan algo, bulan ya bittuwon ya am-in nadan wadah di, ya adi kayu e mahaul ta eyu dayawon dadiyen inha-ad APU DIOS an Dios yuh di takon di dayawon pen di udum an tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Mu nomnomon yun dakayu ke ya impangulu dakayun APU DIOS an tumayan ad Egypt an boblen nunholholtapan yun kay punlodangan hi gumok. Man-uke ya dakayuy pinilinan tatagunan nabalol ot deyan ingganad uwani ya tatagu dakayun hiya. ");
INSERT INTO ifk_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Mu gapun dakayu ya bimmoh-ol hi APU DIOS ke ha-on ot isapatanan adi mabalin an eyak umagwat nah Wangwang an Jordan ta umeyak nah makaphod an boblen idat APU DIOS an Dios yu ke dakayun pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Man-ut mun-agwat kayu tuh wangwang ta ume kayu nah eyu pumboblayan yu, mu ha-oy ke ya mihtuwak ta mateyak hituh bah-el na. ");
INSERT INTO ifk_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Kinali nomnomon yu ta adiyu ibahhoy nakitobbalan yun APU DIOS an Dios yu hanah eyu pangapyaan hi ing-ingon di ngannen eyu dayawon. Man-uke ya adina pippinhodan di athidi. ");
INSERT INTO ifk_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Hi APU DIOS an Dios yu ya kay apuy an gumhob. Ya hiya an Dios ya umamo ten mundayaw kayuh udum an dios. ");
INSERT INTO ifk_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Deket udum hi algo ta nabayag kayu mon numbobleh din wada moy iimbabale yu ya inap-apu yu, adi kayu mangapyah ing-ingon di ngannen dayawon yu ta ekayu munliwat. Gaga-ihoh diye ya umipaboh-ol ke APU DIOS an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Puntistiguwok di kabunyan ya lutad uwani ta deket adiyu un-unudon nadan intugun kun dakayu ya gagala kayun mama-id nah boblen eyu pumboblayan hi pangagwatan yu tuh Wangwang an Jordan. Ya nakatang di pumboblayan yuh di yaden kastiguwon dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ta iwahit dakayun APU DIOS hi kabobboblet loktat ya o-ohay matdaan ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ya hidi nadah boblen kiayan yu ya dayawon yu nadan kinapyan di tagun dios an kaiw ya batun adi pakatibo, adi pakaddongol, adi mangan ya adi pakahamuy. ");
INSERT INTO ifk_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","30","Deket munholholtap kayuh udum hi algo ya hapulon yu uppe hi APU DIOS an Dios yu. Ya deket makulug an hapulon yuh APU DIOS an Dios yu hi puhu yu ya hi nomnom yu ya hamakon yu. Ta ibangngad yu mon mundayaw ya mangun-unud ke hiya. ");
INSERT INTO ifk_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Te hi APU DIOS an Dios yu ya huhhummok, adi dakayu iwalong weno e dakayu dadagon. Ya adina ibahhon ipaannung nan nakitobbalana handidah aammod yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ekayu munhanhan hi kabobboble hin waday athitun na-na-at nipalpu handih nunlutuwan Apu Dios hi tagu ingganad uwani. Takon di daana tuh lutan da-ul di kabunyan ya maid di umat hitun umipamodwong an naat. ");
INSERT INTO ifk_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Kon waday udum an tatagun nangngol ke Apu Dios an kimmali nah apuy umat ke dakayu yaden timmagu da? ");
INSERT INTO ifk_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Kon kinabaelan di udum an dios an kinaan di dakkodakkol an tataguh ohan boblen nahlag hi ohan puun ot pumbalinona didan tataguna, umat hi inat APU DIOS an Dios yu ke dakayud Egypt? Tinibo yu mismun gapuh ongal an kabaelana ya olot na ya impaalinay ligat ya gubat ya inat nay umipamodwong ya nadan nganneh diyen katatakut. ");
INSERT INTO ifk_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Man-uket impatibon APU DIOS an Dios dadiyen dakayu ya ta inilaon yun hiya ya abuy Dios, maid di udum. ");
INSERT INTO ifk_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ya man-uket impadngol nan dakayuy kalinan nalpuh langit ya ta kalyonan dakayuy pinhod nan aton yu. Impatibona boy apuy na tuh luta ta waday innunan kumalin dakayu kediyen apuy. ");
INSERT INTO ifk_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Ya gapuh ongal an naminhod na handidah aammod yu ya binendisyonan dakayun holag da ot ipangulu dakayu mismun hiyan tumayan ad Egypt gapuh ongal an kabaelana. ");
INSERT INTO ifk_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Handi boh mangali kayu ya dinog-al nay tatagun dakdakol ya ongngal di kabaelan da mu dakayu ta ie dakayu nah boble dat pumboblayan yu. ");
INSERT INTO ifk_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ta hidiye nan iha-ad yuh nomnom yu an hi APU DIOS ya Dios hi kabunyan ya hi luta. Ya hiya ya abuy Dios, maid di udum. ");
INSERT INTO ifk_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Deket un-unudon yun am-in di tugunan kalyok ke dakayud uwani ya maphod am-in di maat ke dakayu ya nadan holag yun mitun-ud ke dakayu. Ya munnananong kayun mumboble tuh boblen idat APU DIOS an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Indani ya tinuddun Moses di tulun o-ongal an boblen kihikugan nah nangappit hi timilan di algo nah Wangwang an Jordan. ");
INSERT INTO ifk_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Ta nan tagun pimmaten uggena ingnguddan ya bokon gapuh bungot na ya bumtik hidit ihwang nay adol na. ");
INSERT INTO ifk_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Datuwe nadan boblen tinuddu na: Hay Beser nah tap-on nan bilid an adi maboblayan di nituddu nadah holag Reuben. Hanan Ramot ad Gilead di nituddu nadah holag Gad, ya hay Golan ad Bashan di nituddu nadah holag Manasseh. ");
INSERT INTO ifk_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Indat Moses nan Tugun APU DIOS Moses nadah holag Israel: ");
INSERT INTO ifk_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Datuwe nadan kinalinan mahapul an maunud an Tugun ya nadan mahapul an aton nadan holag Israel handi timmayan dad Egypt ot ");
INSERT INTO ifk_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","mungkampu da nah nundotal nah nangappit hi timilan di algo nah Wangwang an Jordan. Hidiye ya Bet Peor an numboblayan handin hi Sihon an Amorite an patul ad Hesbon an inapput da Moses ya nadan ibbanan holag Israel handih nalpuwan dad Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Sinakup dah diyen boble takon nan numboblayan Og an patul di Bashan. Diday patul ke dadiyen bobleh nangappit hi timilan di algod Jordan. ");
INSERT INTO ifk_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Hanadan boblen sinakup da ya mipalpud Aroer nah pingngit nan Wangwang an Arnon inggana nah Bilid an Sirion an Hermon di ohan ngadana. ");
INSERT INTO ifk_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Ya nid-um am-in di Arabah nah nangappit hi timilan di algod Jordan inggana nah Naten Baybay di Arabah an da-ul di Pisgah. ");
INSERT INTO ifk_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Inamung Moses nadan tatagu ot kananan diday “Pakaddonglon yu hantudan Tugun APU DIOS an kalyok ad uwanin dakayu ta inilaon yu ya un-unudon yu. ");
INSERT INTO ifk_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Te handih kawada taku nah Bilid an Sinai ya nakitobbalan hi APU DIOS an Dios taku ");
INSERT INTO ifk_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","bokon handidah aammod taku dih done, mu ditakun matagud uwani. ");
INSERT INTO ifk_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Kediyey kimmaliyan APU DIOS ya numpatib-anan ditaku nah apuy. ");
INSERT INTO ifk_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ot gapu te tumakut kayu kediyen apuy ya ugge kayu timmikid nah bilid ot itakdog dakayun ha-oy an makihummangan ke APU DIOS. Ya nan ituguna ya hidiyey itugun kun dakayu.” ");
INSERT INTO ifk_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Kananay “Ha-oy hi APU DIOS an Dios yun nangihwang ke dakayuh nihbutan yud Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Ha-oy ya abuy Dios an dayawon yu, maid di udum. ");
INSERT INTO ifk_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Adi mabalin an ekayu mangapyah ing-ingon di nganneh diyen wadah kabunyan ya luta weno kumpulnan wadah danum ta dayawon yu. ");
INSERT INTO ifk_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Adinadaman ekayu munyuung ke dida ya eyu dayawon didan dios yu. Te ha-oy an AP-APU an Dios yu ya namahig di boh-ol ku hin waday udum an ibilang yun dios yun bokon ha-oy ya abu. Kastiguwok nadan mangihihhingit ke ha-on takon nadan imbabale da ya hay inap-apu da ya nadan imbabalen datuwen inap-apu da. ");
INSERT INTO ifk_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Mu adi mapoppog di naminhod ku nadah naminhod ke ha-on ya mangun-unud hi tugun ku. ");
INSERT INTO ifk_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Adi bo nalgom di pangiusalan yuh ngadan kun APU DIOS an Dios yu te nan tagun mangiathidi ya adik homkon, mu kastiguwok. ");
INSERT INTO ifk_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Un-unudon yuy ine-en di Sabadun Tungo ta aton yu nadan lebbeng nan maat mipuun hi tugun ku an APU DIOS an Dios yu. ");
INSERT INTO ifk_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Hanan onom an algo nah hinlingguwan di pangingunuwan yu nadah ngunu yu. ");
INSERT INTO ifk_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Mu hana ken mikapitun algo an Sabadu ya niong-ong ke ha-on an AP-APU an Dios yu. Kediyen algoy pun-iyatuwan yun am-in, kinali maid di mungngunun dakayu, nadan imbabale yun linalaki ya binabai, nadan muttatyu yun linalaki ya binabai, takon nadan aggayam yun baka ya kabayu ya nadan udum an aggayam yu, ya nadan hintaguwan an nakiboblen dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Nomnomon yun nihbut kayud Egypt handi ot ipangulu dakayun ha-on an APU DIOS an Dios yun tumayan gapuh umipamodwong an kabaelak ya gapu nadah inat ku. Kinali itugun kun aton yuy ine-en di Sabadun Tungo. ");
INSERT INTO ifk_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Un-unudon yu da amayun inayu ta mabayag di kiha-adan yu nah boblen kinalik an idat kun dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Adi kayu pumate. ");
INSERT INTO ifk_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Adiyu ihuyop di bokon yu inayan. ");
INSERT INTO ifk_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Adi kayu mangako. ");
INSERT INTO ifk_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Adiyu kalyon di adi makulug mipanggep hi ibbayu. ");
INSERT INTO ifk_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Hay manguddidin Tugun ku ya adiyu omnawan ta eyu alan nan ngannen wadah ibba yun tagu umat hi inayana, balena, payona, hay muttatyuna, bakana, kabayuna weno kumpulnan odona.” ");
INSERT INTO ifk_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Danaey intugun APU DIOS ke ditakun am-in an holag Israel handih inlot nan kimmalin ditaku nah apuy an linikkub di kulabut ya tapol. Ot itudok nah duwan nadampilag an batu ot idat nan ha-on. ");
INSERT INTO ifk_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Mu handih dingngol yuh tuwen kinalina nah tapol yaden mundadalang nan apuy ya immali nadan ap-apu yu ke ha-on. ");
INSERT INTO ifk_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ot kanan day “Impatibon nan AP-APU an Dios takuy dayaw na ya kinatag-ena ya dingngol takuy kalinan nalpu nah apuy. Deyan dingngol takun kimmalih Apu Dios yaden nanongnan matagu taku. ");
INSERT INTO ifk_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Mu ad uwani ya tipet etaku mate? Nunna-ud an deket kumali boh APU DIOS an Dios taku ke ditaku ya mate taku ya gobhon ditaku nah namahig an apuy. ");
INSERT INTO ifk_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Kon waday tagun nanongnan matagu takon di dingngol nay kalina nah apuy? ");
INSERT INTO ifk_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Eka Moses ta em donglon di kalyon APU DIOS an Dios taku. Ne mibangngad kat kalyom ke dakamiy kinalinan he-a ta un-unudon mi.” ");
INSERT INTO ifk_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Dingngol APU DIOS hidiye ya kananan ha-on di “Dingngol kuy kinalin datuwen tatagu ya om, niptok da peman. ");
INSERT INTO ifk_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Deke ot ta athidiy punnomnom da ya wada nin an dayawonak ya un-unudon day Tugun kut nangamung. Deket athidiy aton da ya maphod ta nangamung di maat hi biyag da ya nadan holag da. ");
INSERT INTO ifk_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ekat em kalyon ke didan mibangngad dah kampu da. ");
INSERT INTO ifk_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Mu he-a ke Moses ya mihtu kat kalyok ke he-an am-in nadan tugun kut ituttudum ke didat un-unudon da nah idat kun didan pumboblayan da.” ");
INSERT INTO ifk_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Ta hidiye nan, dakayun holag Israel tibon yu ta un-unudon yun am-in di intugun APU DIOS an Dios yu. Maid di eyu adi un-unudon takon di oha nadah tuguna. ");
INSERT INTO ifk_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Paka-un-unudon yu nan kinalin APU DIOS an Dios yu ta maphod am-in di maat ke dakayu ya ta munnanong kayun mumboble nah pumboblayan yu.” ");
INSERT INTO ifk_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Nagibbun kinalin Moses am-in datuwen tugun APU DIOS ot kananay “Danaen am-in di Tugun APU DIOS an Dios yun kinalinan ituttuduk ke dakayun un-unudon yu nah eyu pumboblayan. ");
INSERT INTO ifk_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ta dakayu ya nadan imbabale yu, nadan imbabale da ya dayawon yuh APU DIOS an Dios yu ta nangamung. Ya deket un-unudon yu dadiyen Tuguna ya andukkey biyag yu. ");
INSERT INTO ifk_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Pakaddonglon yun holag Israel am-in datuwen kalyok ke dakayu: Tibon yu ta makangngun-unud kayun hiya ta maphod di nitaguwan yu, ta dumakol di holag yu, ta dakayuy mumbalin an nal-ot ya ta nanongnan mumboble kayu nah makaphod an boble ya maluwab di mitanom te hidiyey kinalin APU DIOS an Dios handidan aammod taku. ");
INSERT INTO ifk_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Donglon yuh tuwe! Deyan ipidwak an kalyon ke dakayu! Ammunah APU DIOS an Dios. ");
INSERT INTO ifk_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Pohdon yuh APU DIOS an Dios yu hi puhu yu, hi nomnom yu ya am-in hi aton yu. ");
INSERT INTO ifk_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Adiyu kal-iwan datuwen itugun kun dakayud uwani. ");
INSERT INTO ifk_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ya ituttudu yu damdama datuwen Tugun hanadah imbabale yu. Ipanidwa yun kalyon ke dida nah nunhituwan yu takon nah eyu pundaldallanan, nah mahmahdom ya nah biggatna. ");
INSERT INTO ifk_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Itudok yu datuwen tugun ta ilipot yuh takle yu ya ibobod yuh tuktuk yu ta mipanomnom ta nangamung ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ya itudok yu takon hi pamadingan di bale yu ya hi hoob yu. ");
INSERT INTO ifk_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Gagala ya ie dakayun APU DIOS an Dios yu nah boblen kinalinan idat na handidah aammod takun hi Abraham, hi Isaac ya hi Jacob. O-ongal ya makaphod dadiyen boblen idat nan pumboblayan yu, takon di bokon dakayuy nangiphod. ");
INSERT INTO ifk_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Hanada ke bon babalen eyu kiha-adan ya napnuh mahapul yun uggeyu inlingotan. Ya dehdi day humagoban yun bubun an bokon dakayuy nungka-ut ya dehdiy kanon yun bungbunga-an umat hi grapes ya oliba an bokon dakayuy nangitanom. Takon di wadan am-in di mahapul yu nah eyu pumboblayan ");
INSERT INTO ifk_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ya tibon yu ta adiyu kal-iwan hi APU DIOS an nangihwang ke dakayuh nihbutan yud Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Hi APU DIOS an Dios yu ya abuy un-unudon yu ya dayawon yu. Ya deket munsapata kayu ya isapata yu ya abuh ngadana. ");
INSERT INTO ifk_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Adiyu dayawon nadan dios an dayawon nadan numbobleh nunlinikkod ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Te hi APU DIOS an Dios yun makiha-ad ke dakayu ya adina pinhod an waday udum an dios an dayawon yu. Te deket waday udum an dios an dayawon yu ya namahig di bungot nat dadagon dakayu ta mama-id kayu tuh tap-on di luta. ");
INSERT INTO ifk_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Adiyu patpatnaan hi APU DIOS an Dios yu, umat hi inat yu handih nundiklamu kayud Massah. ");
INSERT INTO ifk_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Paka-un-unudon yu nadan intugun APU DIOS an Dios yu ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ya aton yu nadan kanan APU DIOS an niptok ya maphod ta maphod am-in di maat ke dakayu. Ta ume kayun e mumboble nah maphod an boblen insapatan APU DIOS an idat na handidah aammod yu. ");
INSERT INTO ifk_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Nunna-ud an dog-alon yu nadan buhul yun numboble nah eyu pumboblayan te hidiyey kinalin APU DIOS an aton yu. ");
INSERT INTO ifk_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Deket hanhanan di iimbabale yuh udum hi algon kanan day ‘Nganne datuwen Tugun APU DIOS an Dios taku an etaku un-unudon?’ ");
INSERT INTO ifk_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Ya kanan yun diday ‘Man-uke ya gapuh ongal an kabaelan APU DIOS ya inihwang dakamin hiyah nihbutan mi nah patul ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Tinibo miy inat APU DIOS an umipamodwong ya nan katatakut an inat nad Egypt, takon nah patul da ya nadah opisyal da. ");
INSERT INTO ifk_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Impangulu dakamin timmayan ad Egypt ta idat nan dakami tun boblen insapatanan idat handidah aammod taku. ");
INSERT INTO ifk_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ot iolden APU DIOS an Dios takun un-unudon min am-in datuwen Tuguna ya hiyay dayawon mi ta paphodon dakami ya tibonat matagu kami ot deya peman an athidiy naat ingganad uwani. ");
INSERT INTO ifk_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Te ibilang dakamin maphod hin paka-un-unudon min am-in di Tuguna.’ ");
INSERT INTO ifk_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Hantuh pangiayan APU DIOS an Dios yu ke dakayu nah boblen eyu pumboblayan ya dog-alona nadan dakol an numpumbobleh di. Dida nadan Hibite, Girgashite, Amorite, Kanaanite, Perisite, Jebusite ya Hittite. Datuwen tatagu ya nalnal-ot da ya dakdakol da mu dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ya deket paapput APU DIOS an Dios yu didat mumboble kayuh boble da ya mahapul an patayon yu didan am-in ya maid di eyu pakitobbalan ke dida ta eyu homkon an eyu adi patayon. ");
INSERT INTO ifk_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Adi kayu bo makihayyup ke dida weno makiapun dida. ");
INSERT INTO ifk_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Te deket aton yu dadiye ya awison da nadan iimbabale yun mangiwalong ke APU DIOS ta dayawon day udum an dios. Ta gapun diye ya dadagon dakayun APU DIOS gapuh namahig an boh-ol na. ");
INSERT INTO ifk_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ya hay aton yu ya pa-iyon yun am-in di pun-appitan da, nadan nangilinan an batu ya nadan miusal hi pundayawan dan Assera. Ya gobhon yu nadan kinapya dan dios da. ");
INSERT INTO ifk_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Te tatagu dakayun APU DIOS an Dios yu. Man-uke ya hi am-in an tatagu tuh luta, ya dakayuy pinilinan nabalol ke hiya. ");
INSERT INTO ifk_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Pinili dakayun APU DIOS an pakappinhod na, mu bokon gapuh kinadakol yu weno gapuh olot yu, te hay kakulugana ya o-oha kayu mu hay udum an tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Mu man-uke ya pinhod dakayun APU DIOS ya pinhod nan dakayuy pangipaannungana nah hinamad nan kinali handidah aammod taku. Kinali inihwang dakayun APU DIOS gapuh ongal an kabaelana ot poppogonay nihbutan yu nah patul ad Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Ta hidiye nan mahapul an maawatan yu an hi APU DIOS an Dios yu ya makulug an Dios. Hiya nan Dios an pundinolan an adina ibahhon aton di kinalinan atona, takon di mala-uy kalibulibun munhahaynod an holag di tatagu. Ya adi malumman di pamhod na nadah naminhod ke hiya ya mangun-unud hi tuguna. ");
INSERT INTO ifk_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Mu adi bo munhalinduwan mangastigu ya manadag nadah humingit ke hiya. ");
INSERT INTO ifk_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ta hidiye nan mahapul an un-unudon yu nadan nituttudun dakayu ya nadan Tugunan kinalik ke dakayud uwani. ");
INSERT INTO ifk_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Deket donglon yu ya paka-un-unudon yu datuwen Tuguna ya punnanongon APU DIOS an Dios yuy nakitobbalanan dakayu ya adi malumman di pamhod na te hidiyey kinalina handidah aammod taku. ");
INSERT INTO ifk_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Pohdon dakayu ya bendisyonan dakayu ta munholag kayuh dakol. Bendisyonana boy iliyak yu ta adi kayu makudangan hi page ya mainum ya adi kayu makudangan hi mantekan di oliba. Bendisyonan dakayu bo ta padakkolonay baka yu ya kalnero yu. Idat nan am-in datuwen bendisyon ke dakayu nah boblen kinalina handidah aammod yun idat nan dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Maid di udum an tatagu tuh lutan makabbendisyonan hin bokon dakayu ya abu. Ahi maid ke dakayu ya nadan aggayam yuy e adi pakaimbabale. ");
INSERT INTO ifk_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Ya ipaptok dakayun APU DIOS ta maid di katatakut an dogon umalin dakayu, umat nadah tinibo yud Egypt, mu hanada keh buhul yun humihhingit ke dakayu ya ipaalinan diday dogo. ");
INSERT INTO ifk_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Mahapul an dadagon yu nadan boblen ipaapput APU DIOS an Dios yu ke dakayu. Adiyu homkon nadan numbobleh di ya adiyu dayawon nadan dios da te mialig dan kaknaan yu. ");
INSERT INTO ifk_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Kal-ina ya kanan yuh nomnom yuy ‘Nganney innun takun mangapput nadah numbobleh din ongal di kabaelan da mu ditaku?’ ");
INSERT INTO ifk_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Adi kayu tumakut ke dida. Nomnomon yuy inat APU DIOS an Dios yu nah patul di Egypt ya am-in nadan tataguna. ");
INSERT INTO ifk_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Nomnomon yu bo handidan himpappangen ligat an tinibo yun impaalin APU DIOS an Dios yu ke dida, nadan milagron inat na ya hay nangihwanganan dakayuh nihbutan yu gapuh ongal an kabaelana ya olot na. Ya ihwang dakayu nah AP-APU an Dios yu nadah buhul yu umat hi nangihwangan dakayu nadah iEgypt. ");
INSERT INTO ifk_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Ya wadaon APU DIOS an Dios yuy takut ke dida ya dadagona nadan mangipatnan bumtik. ");
INSERT INTO ifk_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Kinali adi kayu tumakut ke dadiyen tatagu. Te baddangan dakayun APU DIOS an Dios yu an ongal di kabaelana ya umipamodwong an Dios. ");
INSERT INTO ifk_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Handi tuwalih mangali kayu ya hin-ittay an dinog-al APU DIOS an Dios yu nadan bimmoble. Adina pinhod an paminghanon yun dadagon dida te mangindadakkol nadan mailom an aggayam. ");
INSERT INTO ifk_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Mu ipaapput APU DIOS an Dios yu dida ke dakayun wadaonay takut da inggana dadagon yu dida. ");
INSERT INTO ifk_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Ipaapput na bon dakayu nadan patul dat mama-id ya makal-iwan dah tu tap-on di luta. Maid di mabalin an makihanggan dakayu te dakayu mah-udot di manadag hi dahdin buhul yu. ");
INSERT INTO ifk_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Mahapul an gobhon yu nadan kinapya dan dios da ya adiyu gamgaman ta eyu alan nadan silber ya balituk an nikapya ke dadiye. Te deket alan yu ya mumbalin dan kaknaan yu te kahingngitan APU DIOS an Dios yu dadiye. ");
INSERT INTO ifk_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Adiyu ianamut dadiyen kinapyan di tagun dios te milaggat kayun makidadag ke dadiye. Mahapul an hihingngitan yu dadiyen kinapyan di tagun dios te nunna-ud an madadag da. ");
INSERT INTO ifk_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Punnanongon yun un-unudon am-in nadan tugun an indat kun dakayud uwani ta tumagu kayu ya dumakol kayu ya ta ekayu mumboble nah insapatan APU DIOS an idat na handidah aammod yu. ");
INSERT INTO ifk_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Nomnomon yuy inat APU DIOS an Dios yun nangipangulun dakayu nah adi maboblayan hi nap-at an toon ot tudduwan dakayun mumpakumbaban idatan ditakuh dakol an ligat ta pamatna na hin un-unudon takuy tuguna weno adi. ");
INSERT INTO ifk_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Kinali in-abulut nan maagangan taku, mu indani ot ipaali nay kanon takun mana an ugge taku inila ya ug-ugge taku tinamtaman takon handidan aammod taku. Mu man-uket inat nah diye ya ta panuddunan ditakun adi taku idinol ya abuh makan di kitaguwan taku, mu mahapul an mundinol takuh kalin APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Tibon yun ug-ugge nadunut di bulwati taku ya ugge linumbag di huki takun e dimmanallanan hi nap-at an toon nah adi maboblayan. ");
INSERT INTO ifk_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Nomnomon takun mahapul an disiplinaon ditakun APU DIOS an Dios taku, umat nah ama an mahapul an disiplinaonay imbabalena. ");
INSERT INTO ifk_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Un-unudon yuy Tugun APU DIOS an Dios yu ya ipuun yuy pumbiyag yu nah pinhod na ya hiyay daydayawon yu. ");
INSERT INTO ifk_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Te hiya an APU DIOS an Dios yu ya ie dakayu nah boblen maluwab di mitanom an waday wawa-el, lolobong, ya oob-ob an malpu nadah duntug ta mumpae nadah nundotal. ");
INSERT INTO ifk_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Maluwab di mitanom hidin wheat, barley, grapes, figs, pomegrenate, oliba ya waday iyyukan hidi. ");
INSERT INTO ifk_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Adi kayu maagangan ya adi kayu makudangan hi mahapul hidi. Hay kadakol di gumok kediyen boble ya umat hi kadakol di batu ya hay gombang ya umat hi kadakol nadan duntug. ");
INSERT INTO ifk_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Wada bon am-in hidiy pinhod yun kanon. Kinali mumpasalamat kayun APU DIOS an Dios yu gapu ke danaen boblen idat nan dakayun maluwab di mitanom. ");
INSERT INTO ifk_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Mu kediyen tiempo ya mahapul an halipat-an yu! Papohdanan yu ta nah tiempon di dakol ya adiyu iwalong hi APU DIOS ya adiyu ibahhon un-unudon datuwen tugunan intugun kun dakayud uwani. ");
INSERT INTO ifk_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Deket hi udum hi algo ya wadan am-in di kahapulan yu ya mungkaphod di babale yu, ");
INSERT INTO ifk_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","dimmakol di baka yu ya kalnero yu ya kimmadangyan kayun dakol di silber yu ya balituk yu ya dakol di ngunut yu, ");
INSERT INTO ifk_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ya ketuwen tiempoy punhalipat-anan yu. Adi kayu e mumpahhiyat kal-iwan yu moh APU DIOS an Dios yun nangihwang ke dakayu handih nihbutan yud Egypt. ");
INSERT INTO ifk_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Nomnomon yun impaptok dakayun hiya nah ambilog ya katatakut an adi maboblayan an wada day katatakut an ulog ya ip-ipit. Makamaggah diyen boblen adi maboblayan, mu impabudal nay danum nah makulhin batu ot waday ininum yu. ");
INSERT INTO ifk_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Indatan dakayu pay hi manah di an makan an ugge inilan handidan aammod yu. Ya impaaliyan dakayuh ligat hi pamatna na, mu hi udidina ya bendisyonan dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Inat nah diye ta adiyu e nomnomon an hay gapunan kimmadangyan kayu ya gapuh ongal an kabaelan yu ya gapuh olot yu. ");
INSERT INTO ifk_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Mu mahapul an nomnomon yu ta nangamung an hi APU DIOS an Dios yuy mangidat hi kabaelan yun kumadangyan. Man-uket atonah di ya ta ipaannung nay nakitobbalana handidah aammod yu. ");
INSERT INTO ifk_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Deket iwalong yuh APU DIOS an Dios yu ta hay udum an dios di un-unudon yu ya dayawon yu ya munyuung kayun dadiye ya tistiguwak an nunna-ud an madadag kayu. ");
INSERT INTO ifk_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Dadagon dakayun APU DIOS, umat nadah numpumbobleh dalanon yu ten adiyu un-unudon hi APU DIOS an Dios yu.” ");
INSERT INTO ifk_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Kimmalih Moses nadah ibbanan holag Israel an kananay “Donglon yu, dakayun iibbak an holag Israel! Ad uwani ya dandanin agwaton yu nan Wangwang an Jordan ta ekayu mumbobleh numboblayan nadan tatagun dakdakol ya nalnal-ot mu ditaku. Numboble dah o-ongal an boblen nungkatag-ey binattun alad dah nunlinikkod an datnganay kabunyan. ");
INSERT INTO ifk_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Ya natatag-e, o-ongal ya nakal-ot nadan tatagun numpumbobleh di te dida nadan kanan dan giant an holag Anak an dingngol takun maid di pakaapput ke dida. ");
INSERT INTO ifk_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Mu ad uwaniy panginilaan yun ipangulu dakayun APU DIOS an Dios yun kay apuy di atonan manadag ke dida. Ta hantuh pangayan yuh di ya dog-alon yu ya patayon yu dida te hidiyey kinalin APU DIOS an maat. ");
INSERT INTO ifk_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","5","Ya deket impakaan APU DIOS an Dios yu dida ya adiyu kanan hi nomnom yuy man-uket inhannot dakayun APU DIOS an mumbobleh di ya maphod kayu ya maphod di at-atton yu ta dakayuy lebbeng nan mumbobleh di. Mu man-uke ya gaga-iho da. Oha bo ya pinhod APU DIOS an Dios yun ipaannung di kinalina handidah aammod takun hi Abraham, hi Isaac ya hi Jacob. ");
INSERT INTO ifk_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Mahapul nimpen nomnomon yun man-uket idat APU DIOS an Dios yuh diyen pumboblayan yun maluwab di mitanom ya ta ipaannung na nan kinalina handi, adi gapu te kalebbengan yu, te hay kakulugana ya makangohhe kayun tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Nomnomon yu handin nangipaboh-olan yun APU DIOS an Dios yu nah adi maboblayan. Nipalpu tuwali handih timmayanan yud Egypt inggana handih dimmatongan yuh tu ya nginohe yuh APU DIOS. ");
INSERT INTO ifk_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Takon hidi nah Bilid an Sinai ya impaboh-ol yuh APU DIOS, kinali nidadaan ot an manadag ke dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Kediyey timmikidak nah bilid an nanawat nah duwan nadampilag an batun nitudokan di nakitobbalan APU DIOS ke dakayu. Ot miha-adak hidi hi nap-at an algo ya nap-at an hilong an ug-uggeyak nangan ya ug-uggeyak imminum hi danum. ");
INSERT INTO ifk_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Indat APU DIOS ke ha-on dadiyen duwan nadampilag an batun nangitudokana nadah Tugunan kinalinan dakayu nah apuy nah bilid. ");
INSERT INTO ifk_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Handih nala-u nan mikanap-at an algo ya hilong ya indat APU DIOS nan duwan nadampilag an batun nitudokan nan nakitobbalanan dakayu. ");
INSERT INTO ifk_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Indani ya kanan APU DIOS ke ha-on di ‘Gal-am ta dumayyu ka te bimmongang nadan tatagun impangulum an timmayan ad Egypt ot aton day gaga-iho. Inwalong da bo udot di intugun kun aton da ot mangapya dah balituk an dios an dayawon da. ");
INSERT INTO ifk_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Inilak di kinangohen datuwen tatagu. ");
INSERT INTO ifk_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Adiyak patikodon, ta dadagok didat munnanong dan makal-iwan. Ta nadan holag muh udum hi algoy pumbalinok hi ongal ya nakakkal-ot mu dida.’ ");
INSERT INTO ifk_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Ot dumayyuwak an nalpuwak nah mundadalang an bilid an inodnak nadan duwan nadampilag an batun nitudkan nan nakitobbalana. ");
INSERT INTO ifk_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Handih dimmayyuwak ya tinibok an nunliwat kayun APU DIOS an Dios yu hi nangapyaan yuh balituk an ing-ingon di impan di baka. Ot kanak di ‘Tipe anhan ta gagala bo udot ya inwalong yuy kinalin APU DIOS an aton yu.’ ");
INSERT INTO ifk_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Gapun diye ya intongbak dadiyen nadampilag an batuh hinangngab yu ot mabukli da. ");
INSERT INTO ifk_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Ot munlukbubak ta mumpahpahmokak boh nap-at an algo ya nap-at an hilong ke APU DIOS an ug-uggeyak nangan ya ug-uggeyak imminum hi danum. Man-uket inat kuh diye ya nunliwat kayun APU DIOS ot paboh-olon yu. ");
INSERT INTO ifk_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Timmakutak te gapuh namahig an boh-ol APU DIOS ya dadagon dakayun hiya, mu kay anhan ya dingngol nay dasal ku ot ugge dakayu dinadag. ");
INSERT INTO ifk_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Bimmobboh-ol damdamah APU DIOS ke Aaron ot innang an patayona, mu indasalak bo ot uggena pinate. ");
INSERT INTO ifk_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Inalak hidiyen kinapya yun ing-ingon di baka ot gobhok nah apuy. Ot banukliyok hidiye inggana numbalin an kay dap-ul ot ek iwele nah wa-el an nu