﻿USE sofia;
DROP TABLE IF EXISTS sofia.ifb_vpl;
CREATE TABLE ifb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ifb_vpl WRITE;
INSERT INTO ifb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hidin te\"an an amin di logom ya limmun Apo Dios ad abuniyan ya tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hay te\"an di nunlumuwana ya agguy napanuh di aat tun luta, ya mi'id ah nihina ti namahig an danum ya pa'ahhelong. At nan Na'abuniyanan an Lennawa di gun munle\"odan hinan bagtun di danum. ");
INSERT INTO ifb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ya inalin Apo Dios di, “Malmuy patal.” Ya na'at an nalmu. ");
INSERT INTO ifb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ya maphod hi nanniganan den patal, at uhigonay patal ya nan helong. ");
INSERT INTO ifb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ya nginadnanay patal ta algaw, ya nginadnanay helong ta mahdom. Ya unat goh naluh heden algaw ya nahdom ta nawa'ah ya hiyah de hopap di algaw. ");
INSERT INTO ifb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ya inalin Apo Dios di, “Malmuy umat hi atap ta battan di danum.” ");
INSERT INTO ifb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","At inuhig Apo Dios nan danum ta nan oha ya wah nan bagtun nan ay atap, ya nan oha ya wah ampana. ");
INSERT INTO ifb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ya ngadnan Apo Dios heden ay atap ta ad daya ta naluh heden algaw ya nahdom ta nawa'ah ya hiyah de miyadwah algaw. ");
INSERT INTO ifb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ya inalin goh Apo Dios di, “Ya milahhin nan danum an wah ampan nan ay atap ta way aton tun lutan mabunhian.” Ya na'at. ");
INSERT INTO ifb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","At ngadnana nan mamaga ta luta, ya ngadnana nan na'amungan di danum ta baybay. Ya tinnig Apo Dios, ya maphod. ");
INSERT INTO ifb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Ya inalin goh Apo Dios di, “Humangaw an amin di numbino'ob'on hi holo', ya nan numbino'ob'on an mitanom an mihda, ya nan mitanud di bungana, ya an amin nan numbino'ob'on an bumunga ta nan bugwan di bungada ya gun humangaw goh ta minaynayun di aatdah tun luta.” At na'at an amin hadin inalina. At maphod hi nannigan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ya naluh heden algaw ya nahdom ta nawa'ah ya hiyah de miyatluh algaw. ");
INSERT INTO ifb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ya inalin goh Apo Dios di, “Malmuy dumilag ad daya ta ma'uhig an waday mahdom, ya gun mihukat di mapatal ta way panginnilaan hi bilang di bulan, ya algaw, ya tawon, ya panginnilaan goh hi na'na'at an umat hi punhabalan ya pundayawan di udum. ");
INSERT INTO ifb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ya bumnangdad daya ta madilagan tun luta.” At hiyah ne na'at. ");
INSERT INTO ifb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ya limmun goh Apo Dios nan duwan o\"ongol an dilag ta nan ong'ongngol ya algaw ta hiyay ad poto' hitun lutah nan mawa'ah, ya nan bulan ad poto' an mangipapatal hinan mahdom. Ya limmuna goh nan do'ol ahan an bittuan. ");
INSERT INTO ifb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","At inhamadnan inhina didah ad daya ta ipapatalda tun luta ");
INSERT INTO ifb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ya ta diday okod an ad poto' hinan mapatal ya nan mahdom ta ma'uhig nan patal hi helong. Ya tinnig Apo Dios, ya maphod. ");
INSERT INTO ifb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ya naluh heden algaw ya na'ahom ta nawa'ah ya hiyah de miyapat hi algaw. ");
INSERT INTO ifb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ya inalin goh Apo Dios di, “Malmun amin nan do'ol ahan hi numbino'ob'on an munhituh nan danum ya hay do'ol ahan goh an numbino'ob'on an hamuti ta muntadyapandah tun bagtun di luta.” ");
INSERT INTO ifb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","At limmun Apo Dios nan numbino'ob'on an kalahin di matagun umiwiy udumna an wah nan baybay, ya limmuna goh nan hamuti. At umamlong hi Apo Dios ti maphod di panniganah aatda. ");
INSERT INTO ifb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","At winagahan Apo Dios didan amin an nunhituh danum an inalinay, “Munholag ayu ta miwa'at ayuh nan baybay.” Ya winagahana goh din hamuti ta dumo'oldah tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ya naluh heden algaw ya na'ahom ta nawa'ah ya hiyah de miyalemah algaw. ");
INSERT INTO ifb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ya inalin goh Apo Dios di, “Malmuh tun lutay numbino'ob'on an kalahin di matagun umiwi ti nalmuy nahalimunan an a'animal, ya nan a'animal an wah inalahan, ya nan mun'ada'adap hitun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","At limmun Apo Dios nan numbino'ob'on an kalahin di umiwi ta nalmuy nahahalimunan an a'animal, ya nan a'animal an wah inalahan, ya nan mun'ada'adap hitun luta. ");
INSERT INTO ifb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ya inalina goh di, “Lumuwon tu'uy tagu ta umat hi aat tu'uy aatda ta diday pange'kodan tu'un amin hinan wah baybay, ya nan hamuti, ya an amin nan a'animal an wah tun luta, ya nan numbino'ob'on an umadap hitun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","At limmun Apo Dios di tagu an umat ay Hiyay aatda. Nan limmuna ya lala'iy oha ya babaiy oha. ");
INSERT INTO ifb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","At wagahan Apo Dios didan inalinay, “Munholag ayu ta dumo'ol ayu ta la'tot ya niwa'at ayun amin hitun luta ta da'yuy okod an amin hinan wah nan baybay, ya an amin nan hamuti, ya an amin nan matagun umiwih tun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","At inayun Apo Dios an inalinay, “Idat'un da'yu an amin nan himmangaw an ma'an di bungada, ya hiyay pangngalanyuh ononyu. Ya umat goh hi bungbungaan an ayiw an hiyay ononyu. ");
INSERT INTO ifb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ya nan holo' ya nan udumna an himmangaw ya idat'un da'yu ta way onon an amin nan matagun umiwi an nan numbino'ob'on an a'animal, ya nan hamuti, ya nan numbino'ob'on an umadap.” Ya an amin hanan inalin Apo Dios ya na'at. ");
INSERT INTO ifb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ya tinnignan amin di limmuna, ya mun'aphod di aatda. Ya naluh heden algaw ya nahdom ta nawa'ah ya hiyah de miyonom hi algaw. ");
INSERT INTO ifb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","At gintud Apo Dios an amin nan limmunan ad daya, ya tun luta, ya an amin nan wada. ");
INSERT INTO ifb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ya heden miyapitun algaw ya lempahnay tamuna ta nun'eblay ti nalpah an amin di nunlumuwana. ");
INSERT INTO ifb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","At nginilinah den algaw, ya winagahana an inalinay me'gonan ti hiyah ne algaw hi nun'eblayana ti nalpah an amin nan inatnan nunlumun amin hi logom. ");
INSERT INTO ifb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","At umat hituy aat di nalmuwan tun luta ya ad dayah din nunlumuwan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ya tun luta ya mi'id pay ah himmangaw unu nitanom, ya agguy pay impa'udan Apo Dios, at mi'id di muntanom. ");
INSERT INTO ifb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mu waday danum an bumuhu' an malpuh nan lutah mangpot hinan tu'yapna. ");
INSERT INTO ifb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","At hi Apo Dios ya innalna nan pito', ya pen'olna ta inyammanah tagu, ya hinodohdaanay olongna, ya nalmuy hodohdana, at na'amman an mataguh Adam. ");
INSERT INTO ifb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ya tinamman Apo Dios ad Eden an wah appit di buhu'an nan algaw ta hiyay nangihinanah nan lala'in limmuna. ");
INSERT INTO ifb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","At limmunan amin di numbino'ob'on an ayiw an mun'aphod di tigawda ya maphod an ma'an di bungada. Ya limmuna goh hinan gagwana han ayiw an mangidat hi itaguan ya nan ayiw an mangidat hi la'eng ta mabalin an innilaon nan maphod an ma'at unu nan nappuhi. ");
INSERT INTO ifb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ya waday wangwang an nalpud Eden ta way nanebnah nan himmangaw. Mu hay aat nan wangwang an nange'wan de han Galden ad Eden ya nun'opat di nunhappangana. ");
INSERT INTO ifb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hay ngadan nan nahhun an oha an happang di wangwang ya ad Pishon an nange'wah ad Havilah an wadan di balitu'. ");
INSERT INTO ifb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Nan balitu' hidi ya nahamad an namahmah. Ya wada goh di ma'ah'upan hidi an lotan di ayiw an ma\"aphod di hunghungna ya nan na'angnginan batu.) ");
INSERT INTO ifb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya hay ngadan nan miyadwan happang di wangwang ya ad Gihon an nange'wah ad Cush. ");
INSERT INTO ifb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ya hay ngadan nan miyatlu ya ad Tigris an nange'wah appit di buhu'an di algaw ad Ashur. Ya hay ngadan di miyapat ya ad Euphrates. ");
INSERT INTO ifb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","At hi Apo Dios ya inhinanah de han lala'ih nan Galden an Eden ta hiyay manamun mangipapto' hinan wah di. ");
INSERT INTO ifb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ya inalinan hiyay, “An amin di bungan tun ayiw hitun galden ya mabalin an onom. ");
INSERT INTO ifb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mu adim ahan onon nan bungan nan ayiw an mangidat hi la'eng an dumalat hi pangimmatunan hinan maphod unu nappuhi.” Ya impidwan Apo Dios an nangalin hiyan inalinay, “Mahapul ahan an adim onon nan bungan den ohan ayiw. Ti onom ay ya matoy'an ne han algaw an panganam.” ");
INSERT INTO ifb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ya inalin goh Apo Dios di, “Adi maphod hi un oh'ohhah ten lala'i. At lumuwo' di oha ta waday pi'yibbanah bumadang ay hiya.” ");
INSERT INTO ifb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","At innalna nan luta, ya inyammanah numbino'ob'on an a'animal ya hamuti. Ya inyuynan de han lala'i an ipattig ta ngadnana dida. At nan nangalinan dida ya hiyay ngadanda. ");
INSERT INTO ifb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","At nginadnan han lala'i nan do'ol an hamuti ya nan a'animal, mu mi'id ah ohan didah mabalin hi ibbana ta way bumadang ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","At hay inat Apo Dios ya impalo'na nan lala'i ta nimogmog di enlo'na, ya innalnay ohah taglang de han lala'i, ya impabangngadna an nun'addumon nan lamoh. ");
INSERT INTO ifb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","At iyammanah den tungal an taglang di lala'ih babai ta nalpah ya inyuynan de han lala'i. ");
INSERT INTO ifb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ya inalin han lala'iy, “Maphod ta nan tungal ya nalpuh nan tungal'u, ya nan lamohna ya nalpuh nan lamoh'u! At mangadnan hiyah babai ti hay nalpuwana ya nan lala'i.” ");
INSERT INTO ifb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ya hiyaat un wa ay ta malhin nan lala'i ya taynana nan o'ommodna ta miyaddum hinan babain ahawana ta paddungnay unda ohan odol. ");
INSERT INTO ifb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ya nan lala'i ya han ahawanan babai ya ta\"on unda numbobollad mu adida bumain. ");
INSERT INTO ifb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nan ulog di na'alla'eng an bumalbali ya un an amin di udumnan limmun Apo Dios. At inalin nan ulog hinan babaiy, “Undan inalin Apo Dios di adiyu onon di bungan nan malgom an ayiw hitun galden?” ");
INSERT INTO ifb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ya tembal nan babai, ya inalinay, “Mabalin an mangan amih bungan nan ayiw. ");
INSERT INTO ifb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mu nan bungan di ayiw an wadah gagwan di galden ya inalin Apo Dios di, Adiyu onon, ya adiyu goh dinihon. Ti atonyu ay ya matoy ayu.” ");
INSERT INTO ifb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ya inalin nan ulog di, “Adi ayu ahan matoy! ");
INSERT INTO ifb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ya manu ay inalin Apo Dios di adiyu onon ti luma'eng ayu, at mipaddung ayun Hiyan manginnilah maphod ya nappuhi!” ");
INSERT INTO ifb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","At unat goh tinnig han babaih den bungan nan ayiw, ya maphod di tigawna, ya maphod hi onon, ya luma'eng di mangan, at innalna, ya inana. Ya indatna goh ay ahawana, ya inana goh. ");
INSERT INTO ifb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ya unat goh inanda ya ay paddungnay nadiat di matada, at iniladan numbobolladda. At dina\"ida\"itday tubun di ayiw an fig ta nanophopdah odolda. ");
INSERT INTO ifb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ya wan mapuyaw ya dengngolday demog Apo Dios an umali, at immuyda nipo\"oy. ");
INSERT INTO ifb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mu inayagan Apo Dios nan lala'in inalinay, “Hay wadam?” ");
INSERT INTO ifb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ya tembalnan inalinay, “Dengngol'uy umaliam, ya timma'ota' ya ten numbobollada', at nipo\"oya'.” ");
INSERT INTO ifb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ya tembal Apo Dios, ya inalinay, “Hay nangalin he\"ah un'a numbobollad? Unmu dan inan nan bungan nen ayiw an inali' hi adiyu onon?” ");
INSERT INTO ifb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ya tembal nan lala'i, ya inalinay, “Nan babain indatmuh ibba' di nangidat hi bungan nen ayiw! At inan'u.” ");
INSERT INTO ifb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ya inalin Apo Dios hinan babaiy, “Anaad ta umat hinay inatmu?” Ya inalin nan babaiy, “Oo ti nan ulog di namalbalin ha\"in, at hiyanan inan'u!” ");
INSERT INTO ifb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ya inalin Apo Dios hinan ulog di, “Dumalat nan inatmu ya he\"ay nidugdugah an ma'idutan an animal, at mete\"ad ugwan ya mihagad di putum hi un'a umadap, ya hay hupu' di itanudmuh engganay apogpogam. ");
INSERT INTO ifb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ya dumalat nan inatmu ya pumbohholo' da'yuh nan babai, ya pumbohholo' goh nan holagyu. At igatinay ulum ta magmi', ya hobatom di mu'udna.” ");
INSERT INTO ifb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ya inalin Apo Dios hinan babaiy, “He\"a ya udma' ta nidugah di holtapom hinan punhabiyam ya nan puntungawam. Ya ta\"on un umat hinay holtapom ya amnawam mahkay nan ahawam, ya munnanong damdamay ahawam an mangipapto' ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ya inyewel Apo Dios hinan lala'i, ya inalinay, “Dumalat nan agguymu nangunudan hinan inali' an adiyu onon nan bungan di ayiw ta hi ahawam di inunudmu ta inanyu nan bungan di ayiw ya ma'idutan tun luta. At munligat'an muntamuh tanudmuh pi'taguam hitun luta. ");
INSERT INTO ifb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ya humangaw di holo' ya nan udumnan humangaw an waday hubitna. ");
INSERT INTO ifb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ya gahin un'a malengot hi puntamuam hitun luta ya un waday malmuh itanudyuh engganay un'a mumbangngad hi luta ti hay pito' di nalpuwam, at mumbangngad'a damdamah pito'.” ");
INSERT INTO ifb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ya nginadnan Adam nan ahawana ta hi Eve ta hiyay hi inan an amin di matagu an umat ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ya hay inyamman Apo Dios hi lubung da Adam ay Eve ya nan up'up di animal ta indatnan dida ta inlubungda. ");
INSERT INTO ifb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ya nalpah hene ya inalin Apo Dios di, “Nan tagu ya umat ay ditu'u ti inilada mahkay di maphod ya nappuhi. Ya gulat ta alana goh di ohah nan bungan nan ayiw an mangidat hi pi'taguan hi mid pogpogna, ya inana, at mabalin nan nabaholan hi mi'taguh munnanannong!” ");
INSERT INTO ifb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","At hay inat Apo Dios ya pinakakna didah nan Galden an Eden ta umuyda muntamuh nan lutan nalmuwanda. ");
INSERT INTO ifb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ya nalpah an pinakak Apo Dios dida at pungguwalyaona nan anghel an ma'alih cherubim hinan way owon hinan appit di buhu'an di algaw. Ya wada goh di adu\"oy an hanggap an umela'elat ya timmelotelon an mihawan hinan way owon an umuy hinan ayiw an mangidat hi pi'taguan. ");
INSERT INTO ifb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ya enelo' Adam hi Eve an ahawana, at nunhabi ta nuntungaw, ya lala'i an nginadnana ta hi Cain. At inalin Eve di, “Binadangana' ay Apo Dios hi nangidatanah nan lala'in imbaluy'un nitungaw!” ");
INSERT INTO ifb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ya palpaliwanda ya nunholag goh ta hi Abel. Ya unat goh immilog ya hay tamuna ya un mumpahtul hi kalnilu. Mu hi Cain ya un munhabal. ");
INSERT INTO ifb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ya unat goh palpaliwan ya enelgom Cain di innalnah bungan di inhabalna ta e'nongnan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mu hi Abel ya innalnay hopap di imbaluy di kalnilunan mi'id ganitna, ya ene'nongna goh ay Apo Dios. At inabulut Apo Dios nan ene'nong Abel, ");
INSERT INTO ifb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mu agguyna nan ene'nong Cain. At ma'abbungot hi Cain an pinumlang. ");
INSERT INTO ifb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ya inalin Apo Dios ay Cain di, “Anaad ta ma'abbungot'an pumlang? ");
INSERT INTO ifb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Undan adi' he\"a abuluton hi unmu aton di maphod? Mu wa ay ta atom di nappuhi at hiyay nidadaan hi mamalbalin he\"a. At mahapul an du'gom ta abakom nan na\"appuhi.” ");
INSERT INTO ifb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ya wa han ohan algaw ya inalin Cain ay aginan hi Abel di, “Umuytah payaw.” At immuyda. Ya hidin awadandah payaw ya pinatoy Cain hi Abel. ");
INSERT INTO ifb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ya inalin Apo Dios ay Cain di, “Hay wadan agim?” Ya tembalnan inalinay, “Tagwan! Agguy'u inila! Undan ha\"in mangipapto' ay agi'?” ");
INSERT INTO ifb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ya inalin Apo Dios di, “Anaad ta inatmuy nappuhi? Nan dalan agim an netmog hitun luta ya paddungnay mun'alin Ha\"in ta way ato' an mangibolloh. ");
INSERT INTO ifb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","At ad ugwan ya ma'idutan'a, at adi mahkay mabalin an munhabal'ah tun luta ti enetmogna nan dalan agim. ");
INSERT INTO ifb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ti wa ay ta munhabal'a ya adi malmuy ihabalmu. At mi'id poto' di punhituwam ta un'a buminna'el an lumane'le'od.” ");
INSERT INTO ifb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ya inalin Cain ay Apo Dios di, “Nidugah ahan di molta' an adia' pa\"edpol! ");
INSERT INTO ifb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ad ugwan ya pakakona' ta adia' punhabalon ay He\"a, ya ma'aana' udot ay He\"a ta unna' buminna'el an lumane'le'od! Ya wada ay di mangah'up ay ha\"in ya patayona'!” ");
INSERT INTO ifb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mu inalin Apo Dios ay Cain di, “Mi'id mamatoy ay he\"a ti nan mamatoy ay he\"a ya miyawit hi mumpapitu.” Ya minalkaan Apo Dios hi Cain ta adi patayon nan mangah'up ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","At nakak hi Cain hi awadan Apo Dios, ya immuy nunhitud Nod an immapit hi buhu'an di algaw hidih ad Eden. ");
INSERT INTO ifb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ya palpaliwan ya nalhin hi Cain ta nunhabih ahawana, ya nuntungaw, ya lala'i, ya ngadnanda ta hi Enoch. Nan babluy an nunhituwanda ya numbalin hi siudad, at nginadnan Cain ta ad Enoch an ngadan nan imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ya nalhin hi Enoch, at nunholag ta hi Irad. At nunholag hi Irad ta hi Mehujael. Ya nunholag hi Mehujael ta hi Methushael. Ya nunholag hi Methushael ta hi Lamech. ");
INSERT INTO ifb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ya hi Lamech ya inahawana nan duwan binabain da Adah ay Zillah. ");
INSERT INTO ifb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","At nunholag hi Adah ta hi Jabal an hiyay ad holag hinan numpunhituh nan tuldan abung an diday mumpumpahtul hinan a'animal. ");
INSERT INTO ifb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ya hay ngadan agin Jabal ya hi Jubal an hiyay ommod di nala'eng an mumpagangoh hi alpa ya tungngali. ");
INSERT INTO ifb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ya nunholag goh hi Zillah ta hi Tubal-Cain an hiyay ad holag hinan mumpumbohal. Ya hay ngadan han aginan babai ya hi Naamah. ");
INSERT INTO ifb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ya inalin Lamech hinan duwan ahawanan da Adah ay Zillah di, “Donglonyuh ten alyo': Wada han pinatoy'u an ungan lala'i, ya manu ay inat'u ti nahhun an hinugatana'. ");
INSERT INTO ifb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ya gulat ta pituy awit Cain at ha\"in ya napitu ta pituy awit'u!” ");
INSERT INTO ifb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ya nunholag goh da Adam ay Eve ta nginadnanda ta hi Seth ti inalin Eve di, “Indat Apo Dios han imbaluy'u ta hukat Abel an pinatoy Cain.” ");
INSERT INTO ifb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ya nunholag hi Seth hi ohah lala'i ta hi Enosh. At hiyah ne nete\"an di nundayawan nan tatagun Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hiyah te napatad hi holag Adam. Hidin nunlumuwan Apo Dios hi tagu ya inyengngohnah nan aatna. ");
INSERT INTO ifb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ya limmunay lala'i ya babai, ya winagahana dida ya unna ngadnan didah tagu. ");
INSERT INTO ifb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ya unat goh nuntawon hi Adam hi hinggahut ta tulumpulu ya waday imbaluynan lala'i an hiyay inanungna, ya ngadnana ta hi Seth. ");
INSERT INTO ifb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ya ni'tagu an gun nunholag damdama ta nangamung waluy gahut di tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","At hay uyap di tawonah engganan den natayana ya hiyam di gahut ta han tulumpulu. ");
INSERT INTO ifb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ya hi Seth ya hinggahut ta lemay tawona ya un mawada han imbaluynan hi Enosh. ");
INSERT INTO ifb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","At nituluy an ni'tagu an gun nunholag ta nangamung waluy gahut ta han pituy tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","At hi Seth ya hiyam di gahut ta han himpulu ta duway tawona ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ya hi Enosh ya nahiyam di tawona ya un mawada han imbaluynan hi Kenan. ");
INSERT INTO ifb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ya nituluy goh an ni'tagu an gun nunholag ta nangamung waluy gahut ta han himpulu ta lemay tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","At hi Enosh ya natoy hidin nunhiyam di gahut ta han lemay tawona. ");
INSERT INTO ifb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ya hi Kenan ya napituy tawona ya un mawaday imbaluynan hi Mahalalel. ");
INSERT INTO ifb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","At nituluy an ni'tagu an gun nunholag ta nangamung waluy gahut ta han napat, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ya hi Kenan ya natoy hidin nuntawon hi hiyam di gahut ta han himpulu. ");
INSERT INTO ifb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ya hi Mahalalel ya nuntawon hi nanom ta han lema ya un mawada han imbaluynan hi Jared. ");
INSERT INTO ifb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","At nituluy an ni'tagu an gun nunholag ta nangamung waluy gahut ta tulumpuluy tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ya hidin waluy gahut ya han nahiyam ta han lemay tawon Mahalalel ya natoy. ");
INSERT INTO ifb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ya hi Jared ya hinggahut ya han nanom ta duway tawona ya un mawaday imbaluynan hi Enoch. ");
INSERT INTO ifb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","At nituluy an ni'tagu an gun nunholag ta nangamung waluy gahut di tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ya hidin nuntawon hi Jared hi hiyam di gahut ya han nanom ta han duwa ya natoy. ");
INSERT INTO ifb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ya hi Enoch ya un nanom ta han lemay tawona ya nawaday imbaluynan hi Methuselah. ");
INSERT INTO ifb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","At nete\"an de ya na'na'unnud hi Enoch ay Apo Dios, at mituluy an ni'tagu ta nangamung tuluy gahut di tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ya hidin tuluy gahut ya han nanom ta lemay tawona ");
INSERT INTO ifb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ya hin'alina ya na'utaw an mi'id. Ti hiya ya un'unnud ay Apo Dios, at nonong di odolna ya ni'yuy ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ya hi Methuselah ya hinggahut ya han nawalu ta pituy tawona ya un mawada han imbaluynan hi Lamech. ");
INSERT INTO ifb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","At nituluy an ni'tagu an gun nunholag ta nangamung hi pituy gahut ta han nawalu ta duway tawona, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ya hidin nuntawon hi Methuselah hi hiyam di gahut ya han nanom ta hiyam ya natoy. ");
INSERT INTO ifb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ya hi Lamech ya hinggahut ya han nawalu ta duway tawona ya un mawada han imbaluynan lala'i. ");
INSERT INTO ifb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ya nginadnana ta hi Noah, ya inalinay, “Maphod ta ta\"on hi un at hitun numbalin hi adi maphod tun lutan dumalat nan nangidutan Apo Dios ya heten ung'ungngay umipa'amlong hi nomnom hitun naligat an tamu.” ");
INSERT INTO ifb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","At ni'tagu an gun nunholag ta nangamung hi lemay gahut ta han nahiyam ta lema, ya nawadaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ya nuntawon hi Lamech hi pituy gahut ya han napitu ta pitu ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ya hi Noah ya nuntawon hi lemay gahut ya unda mawada nan tulun linala'in imbabaluynan da Shem, ya hi Ham, ya hi Japheth. ");
INSERT INTO ifb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ya unat goh gun dimmo'ol nan tatagu ta nun'iwa'atdah tun luta ya numpunholagdah babalahang an mumpangilog. ");
INSERT INTO ifb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ya unat goh tinnig nan tatagun Apo Dios dida an mun'a'apgohanda at immuyday udumna ta iyahawada nan penhodda. ");
INSERT INTO ifb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ya inalin Apo Dios di, “Nan Na'abuniyanan an Lennawa ya adi mabalin an minaynayun di iddumanah nan tatagu ti waday apogpogan di odolda. At hiyaat un hinggahut ta han duwampuluy tawon hi idat'uh pi'taguanda.” ");
INSERT INTO ifb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Heden gutudna ya la'tot goh ya waday o\"ongol an tatagun nunhituh tun luta, ya hay ngadanda ya Nephilim. Ya inahawan nan linala'in tatagun Apo Dios nan holagdan binabai, ya nunholagda goh ta malmuy imbabaluyda. Ya diday ma'abbi'ah, at nundongol di aatdah din penghana. ");
INSERT INTO ifb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ya ininnilan Apo Dios an gun iyal'allan nan tatagun mangamangat hinan do'ol an pumbaholan hitun luta. Ya hay mun'onan hi wah nomnomda ya nan pangatandah nan adi maphod. ");
INSERT INTO ifb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ya hi Apo Dios ya nunheglan munha'it hi punnomnomanah puntutuyuanah ayna nunlumuwan hinan tataguh tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ya inalin Apo Dios di, “Ubaho' an amin tun tatagun limmu' an ta\"on an amin nan a'animal, ya nan umadap, ya nun'apaya'an ti muntutuyua' hi nunlumuwa' ay dida.” ");
INSERT INTO ifb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mu mun'am'amlong hi Apo Dios ay Noah ti anggay hiyah maphod di pangatna. ");
INSERT INTO ifb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hi Noah ya nahamad di atona an mi'id pamahal nan tatagun hiya ti un'unnud ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ya waday tuluh linala'in imbabaluynan da Shem, ya hi Ham, ya hi Japheth. ");
INSERT INTO ifb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Mu hay panigaw Apo Dios an amin hinan tataguh tun luta ya nappuhiy gunda aton, ya nunheglay pangatdah nan i'ibbadan tatagu. ");
INSERT INTO ifb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ya inalin Apo Dios ay Noah di, “Ninomnom'un pa\"ion tun luta ta ma'ubah an amin nan tatagu ti nunnaud nan ato'atondan gunda pumatoy. ");
INSERT INTO ifb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","At iyammam di pupul. Hay iyammam ya nan cypress an ayiw, ya hinoldaholda'muy bunolna. Ya lempahmu ay an inyamma ya inhamadmun litaon hi longah an amin nan muntigaw, ya umat goh hinay atom hi bunolna.” ");
INSERT INTO ifb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","At intuluy Apo Dios an inalinay, “Hay lukudna ya opat di gahut ya han nabongley umpih inadu\"oyna, ya napitu ta lemay umpih inabellogna. Ya hay inata'nangna ya napat ta han lemay umpi. ");
INSERT INTO ifb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ya tigom ta nan dedeng ya adi mitumu' hinan bubung ta madi'angan hi ohay umpi ya han godwa. Ya pinantawam hinan way bane'lengna, ya nuntuluwom di galadu. ");
INSERT INTO ifb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ti hay ato' ya lobngo' tun luta ta ma'ubah an amin nan wah tun luta ta mun'atoydan amin nan malgom an waday hodohdana an ta\"on hi unda tagu unu animal. ");
INSERT INTO ifb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mu ten itulag'un he\"a an da'yun hina\"ama, ya nan a'ahawayu ya humgop ayuh nan pupul ta mabaliwan ayu. ");
INSERT INTO ifb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ya mahapul an pe'ehgoponyuh nan pupul di mahindudwah an amin hinan matagun nalmun buta'al ya tenna ta mi'tagudan da'yu. ");
INSERT INTO ifb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","An mahindudwah nan numbino'ob'on an hamuti, ya nan numbino'ob'on an kalahin di a'animal, ya nan numbino'ob'on an kalahin di umadap hinan luta ta mi'tagudan da'yu. ");
INSERT INTO ifb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ya idadaanyun ehgop an amin nan mun'olog hi ononyun amin ya hay onon goh nan numbino'ob'on an pe'ehgoponyu.” Hiyah ne inalin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","At inat Noah an amin hanan immandal Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ya nadatngan goh nan humgopan da Noah hinan pupul ya inalin Apo Dios ay Noah di, “Humgop ayu mahkay an hina\"amah nan pupul ti da'yu ya anggay di tinnig'uh nahamad di pangatna. ");
INSERT INTO ifb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","At ipahgopmuy pituh nan numpunhimbaluy hinan a'animal an abuluton Apo Dios hi ma'an ya me'nong ay Hiya, ya ipahgopmuy duwah nan numpunhimbaluy an a'animal an adi abuluton Apo Dios hi ma'an ya me'nong ay Hiya, ");
INSERT INTO ifb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ya nan himpiptuh nan mumpunhimbaluy an nun'apaya'an ta waday mahlag hitun luta. ");
INSERT INTO ifb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ti maluh di pituy algaw at ipa'udan'uh napat hi algaw, ya napat hi labi ta mapa\"in amin di mataguh tun lutan limmu'.” ");
INSERT INTO ifb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","At inat Noah an amin di inalin Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ya hay tawona ya onom di gahut eden albongan tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","At hinumgop mahkay da Noah an hina\"ama ya nan a'ahawadah nan pupul ta mabaliwandah albongan tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ya ne'ehgop ay Noah hinan pupul hana nan nahindudwan a'animal an mibilang hi maleneh ya nan adi maleneh, ya nan numbino'ob'on an hamuti, ya an amin nan nalmun umadap hi luta ti hiyah ne inalin Apo Dios ay Noah hi atona. ");
INSERT INTO ifb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ya naluh di pituy algaw ya ente\"an tun lutan malbong. ");
INSERT INTO ifb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ya hay aat di nalbongan tun luta ya nuntawon hi Noah hi onom di gahut eden miyapulu ta pituh algaw hi miyadwah bulan di nibo'tanan di a'obo'obob ya niguwang ad daya. ");
INSERT INTO ifb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","At immuda'udan hi napat di algaw ya napat di labi. ");
INSERT INTO ifb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mu da Noah an himbaluy, ya nan imbabaluyda an da Shem, ya hi Ham, ya hi Japheth, ya nan a'ahawada ya hinuhhumgopdan amin hinan pupul tuwali ya un mihipun di udan. ");
INSERT INTO ifb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Ya ne'yehgopda nan numbino'ob'on an a'animal, ya nan umadap, ya nan nun'apaya'an hinan pupul ");
INSERT INTO ifb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","an nan numpunhimbaluy ti hiyay inalin Apo Dios ay Noah. Ya unat goh nalpah an himmigupda ya intangob Apo Dios nan pantaw di pupul. ");
INSERT INTO ifb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Heden immuda'udananah napat di algaw ya gun malbong tun luta. At gun muntaptapaw nan pupul an immadagwih nan luta. ");
INSERT INTO ifb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ya gunna iyal'allan malbong tun luta, at muntaptapaw mahkay nan pupul. ");
INSERT INTO ifb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ya gun bumi'ah an malbong tun luta, ya nunhe'nobnan amin nan aduntuduntug an ta\"on nan atata'nang. ");
INSERT INTO ifb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ya la'tot ya naluh di duwampuluh umpiy nahe'noban nan atata'nang an aduntuduntug. ");
INSERT INTO ifb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ya an amin nan mataguh tun luta ya nun'atoyda an umat hinan nun'apaya'an, ya nan numbino'ob'on an a'animal, ya nan umadap, ya nan tatagu ");
INSERT INTO ifb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","an diday hinodohdaan Apo Dios ta timmaguda. ");
INSERT INTO ifb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","At na'ubah an amin nan wah tun lutan tatagu, ya nan a'animal, ya nan umadap, ya nan nun'apaya'an. Ya anggay da Noah an hina\"ama ya an amin nan wah nan pupul di matagu. ");
INSERT INTO ifb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ya nunnonong di danum hitun lutah hinggahut ta han nabongle an algaw. ");
INSERT INTO ifb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ya ninomnom Apo Dios da Noah ya an amin nan wah nan pupul, at impatuyupnay tuyup ta way aton nan danum an ma'bah ");
INSERT INTO ifb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ta nun'atdu' nan a'obo'obob, ya inugawna nan udan an nalpud daya. ");
INSERT INTO ifb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ya mun'ul'ullay an na'bah nan danum hi lemay bulan. ");
INSERT INTO ifb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hidin miyapulu ta pituh algaw hi miyapitun bulan ya nipattu' heden pupul hinan Duntug an Ararat. ");
INSERT INTO ifb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ya nitultuluy an ma'bah nan danum ta engganah miyapuluh bulan. At hidin hopap di algaw di miyapulun bulan ya mattig mahkay di tulid nan aduntuduntug. ");
INSERT INTO ifb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ya naluh di napat hi algaw ya imbughul Noah din tawah nan pupul. ");
INSERT INTO ifb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","At impatayapna nan gayang ta timmayap an numbinangngadan ta nangamung un namaganan tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ya impatayapna goh nan balug ta panginnilaanah un namaganan di luta. ");
INSERT INTO ifb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mu mi'id ah namaganan hi pun'ohpana, at numbangngad hinan pupul. Ya dempap Noah, at ipahigupna. ");
INSERT INTO ifb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ya innaynayundan nihinah nan pupul hi pituy algaw ya unna ipidwan ipatayap nan balug. ");
INSERT INTO ifb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ya wan ma'ahom ya numbangngad nan balug, ya ihnay hembatnan tubun di ayiw an olibo. At inilan Noah mahkay an na'uy an mamaganan di luta. ");
INSERT INTO ifb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mu nihihinnada ni' hinan pupul hi pituy algaw, ya impatayapna goh nan balug, mu agguy mahkay numbangbangngad. ");
INSERT INTO ifb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Hidin onom di gahut ta ohay tawon Noah eden hopap di algaw hi hopap di bulan ya imbughulna nan tawan di pupul ta muntiggatiggaw, ya tinnignan namaganan di luta. ");
INSERT INTO ifb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","At heden duwampulu ta pituy algaw hi miyadwan bulan ya namaganan mahkay an amin di luta. ");
INSERT INTO ifb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ya inalin Apo Dios ay Noah di, ");
INSERT INTO ifb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pumitaw ayun ahawam, ya nan imbabaluyyu, ya nan a'ahawada. ");
INSERT INTO ifb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ya pi'lahunom an amin nan nun'apaya'an, ya nan a'animal, ya an amin nan umadap ta munholagda ta dummo'olda goh hitun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ya pimmitaw mahkay da Noah an himbaluy, ya nan imbabaluyda, ya nan a'ahawada. ");
INSERT INTO ifb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ya umat goh hi an amin hinan a'animal, ya nan umadap, ya nan nun'apaya'an an pimmitawdan numpunhina\"ama. ");
INSERT INTO ifb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","At nun'ammah Noah hi pun'onngan ay Apo Dios, at inummal hi me'nong an animal ya nan me'nong an hamuti, at ene'nongnan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ya inabulut Apo Dios nan ene'nong da Noah, at inalinah nomnomnay, “Dumalat nan tatagu ya adi' mahkay ipidpidwan idutan tun luta an ta\"on hi nappuhiy nomnomda an mete\"ah a'ungada, ya adi' mahkay ipidpidwan ubahon nan matagun umat hinan inat'u. ");
INSERT INTO ifb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","At minaynayun ay di awadan tun luta ya mitutuluy goh di punhabalan ya pumbot'an di tatagu, ya waday tungnin ya mun'ohab. Ya umat goh an mitutuluy di tiyalgaw ya lawang, ya ta\"on di helong ya patal.” ");
INSERT INTO ifb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","At winagahan Apo Dios hi Noah ya nan imbabaluynan inalinay, “Hay maphod ya munholag ayu ta dumo'ol ayu ta la'tot ya nun'onan nan holagyuh tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ya an amin nan a'animal, ya nan nun'apaya'an, ya nan umadap, ya nan wah nan baybay ya da'yuy ita'otda ta da'yuy okod ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","At hana ya mabalin an ihdayu ya ta\"on nan nitanom an munlangta. Ya limmu' hana ta way tanudyu. ");
INSERT INTO ifb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mu hay mahapul ya ma'aan nan dalah odolnan paltionyu ya unyu ihda ti nan dala ya hiyay dumalat hi ataguan. ");
INSERT INTO ifb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ya nan pumatoy hinan ibbanan tagu ya mahapul an mapatoy goh ti hapulo' di awitna. Ya ta\"on nan animal ya wa ay di pinatoynah tagu ya mahapul an mapatoy goh ");
INSERT INTO ifb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ti hay tagu ya limmu' ta niyengngoh ay Ha\"in. At nan tagun pumatoy hi ibbanan tagu ya mahapul an patayon goh nan tagu hiya. ");
INSERT INTO ifb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","At da'yu ya munholag ayu ta dumo'ol ayu ta nangamung unyu lonapan tun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ya inalin Apo Dios ay Noah ya nan imbabaluynay, ");
INSERT INTO ifb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ha\"in ya mi'tulaga' ay da'yu, ya ta\"on un nan malmun holagyuh udum hi algaw, ");
INSERT INTO ifb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ya ta\"on an amin nan nun'apaya'an, ya nan a'animal, ya nan udum an ni'pitaw hinan pupul. ");
INSERT INTO ifb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ya hay itulag'un da'yu ya adi' mahkay ipidwan ubahon nan wah tun luta an dumalat nan lobong ti adi mipidwan malbong. ");
INSERT INTO ifb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ya hay pangimmatunanyuh un immannung heten itulag'uh ato' ay da'yu, ya an amin nan holagyu, ya nan udum an matagu ya hay abungalngal an lumuwo' ad daya. ");
INSERT INTO ifb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ti wa ay ta mundonyag ya mawada nan abungalngal an mipattig. ");
INSERT INTO ifb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ha\"in ya adi' ahan aliwan nan intulag'un da'yu ya an amin nan udum an matagu an adi' mahkay ubahon nan wah tun lutan dumalat nan lobong ti adi mipidwan malbong tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ya wa ay ta mumpattig nan abungalngal hi ad daya ya hiyay mangipanomnom ay Ha\"in an minaynayun heden ni'tulaga' hinan tatagu ya an amin nan udum an matagun wah tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","At hiyah ne pangimmatunan hinan intulag'uh ato' ay da'yu ya an amin nan udum an matagu.” ");
INSERT INTO ifb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ya hay imbabaluy Noah an limmahun an nalpuh nan pupul ya da Shem, ya hi Ham, ya hi Japheth. (Hi Ham ya hiyay ommod Canaan.) ");
INSERT INTO ifb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Date an tulun imbabaluy Noah ya diday napu'agan an amin di tataguh tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hay tamun amadan hi Noah ya un munhabal, at hiyay nahhun an nuntanom hinan galden hi greyp. ");
INSERT INTO ifb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","At nan bungan nan greyp ya inyammanah bayah. At imminum, ya nabutong, at numbolad an nolo' hinan abungnan tulda. ");
INSERT INTO ifb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ya unat goh tinnig Ham nan numbobolladan amana ya immuyna inyulgud hinan duwan a'agina. ");
INSERT INTO ifb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","At innal mah da Shem ay Japheth din uloh, ya inhabe'lagdah pu'olda ya unda didin'ug an nangihunohunod an umuy manguloh ay amada ta agguyda tinnig di numbobolladana. ");
INSERT INTO ifb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ya unat goh nayahyah nan binutong Noah ta ininnilana nan inat han udidian an imbaluyna ");
INSERT INTO ifb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ya inalinay, “Ma'idutan hi Canaan ta mumbalin hi na'ampan baalnan i'ibana!” ");
INSERT INTO ifb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","At inalin goh Noah di, “Hay maphod ya wagahan Apo Dios hi Shem, mu hi Canaan ya mumbalin hi baalna! ");
INSERT INTO ifb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ya idawat'un Apo Dios ta idatnay do'ol an holag Japheth ta middumdah nan holag Shem. Mu hi Canaan ya numbalin hi baal goh Japheth.” ");
INSERT INTO ifb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hay tawon hi ni'taguan Noah an nete\"ah din nalpahan din lobong ya tuluy gahut ta nabongle. ");
INSERT INTO ifb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","At hay tawona ya un matoy ya hiyam di gahut ta han nabongle. ");
INSERT INTO ifb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hiyatuy holag nan tulun linala'in imbabaluy Noah an diday nunholag hidin nalpahan di lobong. ");
INSERT INTO ifb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Hay holag Japheth ya da Gomer, ya hi Magog, ya hi Madai, ya hi Javan, ya hi Tubal, ya hi Meshek, ya hi Tiras. ");
INSERT INTO ifb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ya hi Gomer ya nunholag ta da Ashkenaz ay Riphath, ya hi Togarmah. ");
INSERT INTO ifb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Hi Javan ya nunholag ta da Elishah, ya hi Tarshish, ya nan tatagun numpunhitud Cyprus, ya nan tatagun numpunhitud Rhodes. ");
INSERT INTO ifb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ya nan holag Japheth di o'ommod nan numpunholag an numbino'ob'on di hapitda an numpunhituh nan abablubabluy hinan pingit di baybay. ");
INSERT INTO ifb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nan linala'in holag Ham ya da Cush, ya hi Mizraim, ya hi Put, ya hi Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ya hay holag Cush ya da Seba, ya hi Havilah, ya hi Sabtah, ya hi Raamah, ya hi Sabteka. Ya nan holag Raamah ya da Sheba ay Dedan. ");
INSERT INTO ifb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Hi Cush ya wada han ohan imbaluynan lala'i an hi Nimrod an hiyay hopap di nangameh an amin hinan abablubabluy hitun luta. ");
INSERT INTO ifb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ya nala'eng an manganup ti hi Apo Dios di namadang ay hiya. At hiyanan inalin nan tataguy, “Maphod ahan un'a umat ay Nimrod an manganup an binadangan Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hay hopap di babluy hi numpapto'ana ya ad Babylon, ya ad Uruk, ya ad Akkad, ya ad Kalneh an hakup di ad Shinar. ");
INSERT INTO ifb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ya ilagatna nan babluy ad Assyria ta hidiy numpangipaphodanah nan siudad an umat ad Nineveh, ya ad Rehoboth Ir, ya ad Calah, ");
INSERT INTO ifb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ya ad Resen an numbattanan ad Calah ya ad Nineveh ya nundongol an siudad. ");
INSERT INTO ifb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hi Mizraim an imbaluy Ham ya nunholag ta nan tatagud Lydia, ya ad Anam, ya ad Lehab, ya ad Naphtuh, ");
INSERT INTO ifb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ya ad Pathrus, ya ad Casluh (an nalpuwan nan iPhilistia), ya nan iCrete. ");
INSERT INTO ifb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Hi Canaan an imbaluy Ham ya nunholag ta hi Sidon an pangpangullu ya un hi Heth. ");
INSERT INTO ifb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ya nunholag goh hi Canaan ta nan himpampun an holag Jebus, ya nan holag Amor, ya nan holag Girgas, ");
INSERT INTO ifb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ya nan himpampun an holag Hiv, ya nan holag Ark, ya nan holag Sin, ");
INSERT INTO ifb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ya nan holag Arvad, ya nan holag Zemar, ya nan iHamath. Ya hanan holag Canaan ya diday niwa'at an nepongdah nan udumnan babluy ");
INSERT INTO ifb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","an nete\"ah ad Sidon ta numpa'uy ad Gerar ta nangamung ad Gaza. Ya inipluy di udumnan immuy ad Sodom, ya ad Gomorrah, ya ad Admah, ya ad Zeboyim ta nangamung ad Lasha. ");
INSERT INTO ifb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hiya hanay holag Ham hi nun'epong hinan do'ol an abablubabluy ya numbino'ob'on di hapitda. ");
INSERT INTO ifb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nunholag goh hi Shem an pangpangullu ya un hi Japheth, ya hiyay ad holag hinan dana' Eber. ");
INSERT INTO ifb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Hiyatuy holag Shem an da Elam, ya hi Ashur, ya hi Arphaxad, ya hi Lud, ya hi Aram. ");
INSERT INTO ifb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Hay holag Aram ya da Uz, ya hi Hul, ya hi Gether, ya hi Meshek. ");
INSERT INTO ifb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Hi Arphaxad ya nunholag ta hi Shelah an ad imbaluy ay Eber. ");
INSERT INTO ifb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hi Eber ya duwaday linala'ih holagna. Nan oha ya nginadnanda ta hi Peleg ti hidin ataguna ya na'uhi'uhig nan tataguh tun luta. Ya nan oha ya hi Joktan. ");
INSERT INTO ifb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ya hay holag Joktan ya hi Almodad, ya hi Sheleph, ya hi Hazarmaveth, ya hi Jerah, ");
INSERT INTO ifb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ya hi Hadoram, ya hi Uzal, ya hi Diklah, ");
INSERT INTO ifb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ya hi Obal, ya hi Abimael, ya hi Sheba, ");
INSERT INTO ifb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ya hi Ophir, ya hi Havilah, ya hi Jobab. Hiyanay holag Joktan. ");
INSERT INTO ifb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ya hay babluy hi nunhituwanda ya nete\"ah ad Mesha ta nangamung ad Sephar hidih nan dudunduntug an niyappit hi buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Didanay ahimpahimpangapu an holag Shem an numbino'ob'on di numbabluyanda ya ta\"on nan hapitda. ");
INSERT INTO ifb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","An amin dane an tatagu ya hi Noah di napu'aganda ti ma'alah nan patad. Ti hidin nalpahan di lobong ya anggay nan imbabaluy Noah di numpunholag ya unda dumo'ol an niwa'awa'at hitun luta. ");
INSERT INTO ifb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hidin hopapna ya un ohay hapit hi pun'i'innawatan di tatagu. ");
INSERT INTO ifb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ya heden umayandah appit di buhu'an di algaw ya inah'upanda han nundotal an lutan ad Shinar, at hidiy bimmabluyanda. ");
INSERT INTO ifb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ya nunhahapitdan inaliday, “Malammung tu'u ta munduwin tu'uh mapeleng ta hay iyamma tu'u ya nan naduwin, ya linita tu'u ta way mida\"it.” Ya ente\"adan mun'amma ta bo'on hay batu unu panag an way apulnay usalonda. ");
INSERT INTO ifb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ya inalida goh di, “Maphod hi un tu'u ipaphod heten babluy, at mun'amma tu'uh ata'nang an binattu ta nangamung umatam ad daya, ya manu ay aton tu'u ta mundongol di aat tu'u ta adi tu'u munhihiyan.” ");
INSERT INTO ifb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mu tinnig Apo Dios nan babluy ya nan ata'nang an binattun iyam'ammada. ");
INSERT INTO ifb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ya inalinay, “Nan tatagu ya na'ohhada, ya un ohay hapitda. At ten ente\"adan nun'ammah umat hitu at undan adida abalinan an aton di penhoddah ma'at. At udum di algaw ya ini ya atondan amin di pohdondah ma'at! ");
INSERT INTO ifb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","At umuy tu'u ta lummanon tu'uy hapitda ta numbino'ob'on ta adida mun'i'innawatan.” ");
INSERT INTO ifb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","At inwa'at Apo Dios didah tun alutaluta, at agguy natuluy nan pangipaphodandah nan babluy. ");
INSERT INTO ifb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","At hiyah ne dimmalat hi nangadnanah Babel ti ginulun Apo Dios di hapitda ta numbino'ob'on. At inwa'atna didah tun alutaluta. ");
INSERT INTO ifb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ya hiyatuy napatad hi holag Shem. Ya naluh di duway tawon hi nalbongan tun luta ya nuntawon hi Shem hi hinggahut, ya nunholag ta hi Arphaxad. ");
INSERT INTO ifb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ya nete\"ah nitungawan Arphaxad ta nangamung lemay gahut di tawon Shem ya gun nawaday udumnah holagnan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ya hidin nuntawon hi Arphaxad hi tulumpulu ta lema ya nunholag ta hi Shelah. ");
INSERT INTO ifb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ya nete\"ah nitungawan Selah ta nangamung naluh di opat di gahut ya han tuluy tawon Arphaxad ya gun nawaday udumnah holagnan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ya hidin nuntawon hi Shelah hi tulumpulu ya nunholag ta hi Eber. ");
INSERT INTO ifb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ya nete\"ah nitungawan Eber ya opat di gahut ya tuluy tawon Shelah ya gun nawaday udumnah holagnan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ya hidin nuntawon hi Eber hi tulumpulu ta opat ya nunholag ta hi Peleg. ");
INSERT INTO ifb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ya nituluy an ni'taguh opat di gahut ya han tulumpuluy tawona, ya gun nawaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ya unat goh nuntawon hi Peleg hi tulumpulu ya nunholag ta hi Reu. ");
INSERT INTO ifb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ya nituluy an ni'tagu ta nangamung duway gahut ya han hiyam di tawona, ya gun nawaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ya unat goh nuntawon hi Reu hi tulumpulu ta duwa ya nunholag ta hi Serug. ");
INSERT INTO ifb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ya nituluy an ni'tagu ta nangamung duway gahut ya han pituy tawona, ya gun nawaday udumnah imbabaluynan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ya unat goh nuntawon hi Serug hi tulumpulu ya nunholag ta hi Nahor. ");
INSERT INTO ifb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ya nituluy an ni'tagu ta nangamung duway gahut di tawona, ya gun nawaday linala'i ya binabain imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ya unat goh nuntawon hi Nahor hi duwampulu ta hiyam ya nunholag ta hi Terah. ");
INSERT INTO ifb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ya nituluy an ni'tagu ta nangamung hinggahut ya han himpulu ta hiyam di tawona, ya gun nawaday linala'i ya binabaih imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ya unat goh napituy tawon Terah ya nunholag ta da Abram, ya hi Nahor, ya hi Haran. ");
INSERT INTO ifb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ya hiyatuy holag Terah. Nunholag hi Terah ta hi Abram, ya hi Nahor, ya hi Haran an ad holag ay Lot. ");
INSERT INTO ifb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ya nahhun an natoy hi Haran ya un hi amana an hi Terah hidih nan nitungawanah ad Ur hidid Babylon. ");
INSERT INTO ifb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ya da Abram ay Nahor ya nangahawadan hin'agi, at inahawan Abram hi Sarai, ya hi Nahor ay Milkah an hina' Haran. Ya wada goh di holag Haran an da Milkah ay Iskah. ");
INSERT INTO ifb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mu hi Sarai ya bahig. ");
INSERT INTO ifb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ya unat goh nakak da Terah ad Ur hinan babluy ad Babylon ta umuydad Canaan ya initnudna da Abram an imbaluyna, ya nan ap'apunan hi Lot an hina' Haran, ya hi Sarai an inapuna. Ya palpaliwan ya immatamdad Haran, ya hidiy nunhituwanda, ");
INSERT INTO ifb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ya nunhitudah di ta nangamung natoy hi Terah hidin nuntawon hi duway gahut ya han lema. ");
INSERT INTO ifb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ya waday inalin Apo Dios ay Abram hidin penghanan inalinay, “Taynam nan babluyyun hina\"ama ya nan tutulangmu ta umuy'ah nan babluy an ipattig'un he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","At punhologo' he\"a ta dumo'ol di holagmu ta diday mundongol, ya wagaha' he\"a ta mundongol di ngadanmu, ya he\"ay dumalat hi awagahan di tatagu. ");
INSERT INTO ifb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","At wagaha' goh nan munwagah ay he\"a, mu nan mangidut ay he\"a ya iduta' goh dida. Ya nan tataguh tun luta ya pi'wagah'u dida an he\"ay dumalat.” ");
INSERT INTO ifb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","At inunud Abram nan inalin Apo Dios, at nakakda, ya initnuddah Lot, ya hay tawon Abram hidin nakakandad Haran ya napitu ta lema. ");
INSERT INTO ifb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ya hidin nakakandah ayandan amin ay da Sarai an ahawana, ya hi Lot an amuna'ona, ya nan baaldah ad Canaan ya inta'indan amin nan gina'uda. Ya unat goh nidatongdah ad Canaan ");
INSERT INTO ifb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ya innaynayundan immuy ta nangamung hi unda immatam hinan nundotal an lutad Moreh hidid Shechem an babluy ad Canaan damdama. Ya nan tatagun nunhituh di ya holag Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ya numpattig hi Apo Dios ay Abram, at inalinay, “Heten babluy ya idat'uh nan holagmu.” At mun'ammah Abram hi pun'onngan ay Apo Dios an din numpattig ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ya unat goh nalpah hene ya immuy hidin awadan di dudunduntug an appit di buhu'an di algaw ad Bethel hinan appit ad Ay an buhu'an di algaw. At hidiy nangiha\"adanah nan abung an tuldana, ya inyammanah di nan pun'onngan ay Apo Dios ta way atondan mundayaw ay Hiya. ");
INSERT INTO ifb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mu agguyda nunnanong hidi ti unda numbinna'el hi ayda immapalan hinan mipluy ad Negev hidih ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ya unda palpaliwan ya waday batel eden babluy ad Canaan. At immuy da Abram ad Egypt ta ni'hitudah di ti dimmalat nan nunheglan batel. ");
INSERT INTO ifb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mu hidin magadyuh an umatamdah ad Egypt ya inalin Abram ay Sarai an ahawanay, “Inila' an ma'apgohan'a an babai. ");
INSERT INTO ifb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","At gulat ta tigon da'ah nan i'Egypt ya inaliday, Hiyah te ahawana! at patayona' ay dida, ya he\"ay adida. ");
INSERT INTO ifb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","At alyom ay diday he\"ah agi' ta he\"ay dumalat hi pangatandan ha\"in hi maphod, at adia' patayon ay dida.” ");
INSERT INTO ifb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ya unat goh immatamdah ad Egypt ya tinnig nan i'Egypt hi Sarai an ma'ap'aphod an babai. ");
INSERT INTO ifb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ya tinnig goh nan u'upihyal den ali, at imbaagdan hiyay ama'apgohana. At impa'ayagnah Sarai ta iyuydan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ya dimmalat hi Sarai ya maphod di inat nan Alin hi Pharaoh ay Abram ti impa'dawnan Abram di do'ol an kalnilu, ya baka, ya kamilu, ya manilhig ya obay an dongki, ya nan baalnan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mu dimmalat nan nangipa'ayagan nan ali ay Sarai an ahawan Abram ya nundoghon Apo Dios hiya ya nan tataguh abungnah nidugah an ligat. ");
INSERT INTO ifb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","At impa'ayag nan Alin hi Pharaoh hi Abram, ya inalinay, “Anaad ta binalbaliyana' ay he\"a? Ya anaad ta alyom di hi agim ta omod hi un'u impa'ayag ");
INSERT INTO ifb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ya ta alyo' hi ahawao'? At tayah ahawam! Awitom ta makak ayu!” ");
INSERT INTO ifb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","At minandal nan ali nan tataguna ta ituluddan enekak da Abram, ya nan ahawana, ya an amin nan wadan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","At nakak da Abram an himbaluy ad Egypt ta mumbangngaddad Negev hi ad Canaan, ya inta'indan amin nan wadan dida. Ya hi Lot ya nitnud ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Hi Abram ya pa\"adangyan hi a'animal, ya balitu', ya silver. ");
INSERT INTO ifb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ya unat goh numbangngaddah ad Negev ya unda bimminna'el hinan babluy an mipluy ad Bethel. Ya la'tot ya unda mah numbangngad hidin nuntuldaandah hopapnah ad Bethel hi appit ad Ay ");
INSERT INTO ifb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","an hiyah de din nangiyammanah nan pun'onngan hidin hopapna, at impidwana goh an mundayaw ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Hi Lot an nitnud ay Abram ya do'ol goh di a'animalna, ya wada goh di pamilyana ya baalna. ");
INSERT INTO ifb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ya la'tot ya adi umda nan pahtuda ti nahlag an dimmo'ol ahan nan a'animaldan duwa. ");
INSERT INTO ifb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","At hiyay dumalat hi punhahannuan nan pumpahtulon da Lot ay Abram. Ya manu ya un adi umda nan pahtuda ti wagwah diday nunhituh di an holag Canaan ya nan holag Periz. ");
INSERT INTO ifb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","At inalin mah Abram ay Lot di, “Adi maphod hi un hin'umu'udduman nunhahannuda nan pumpahtulonta ti hin'amata. ");
INSERT INTO ifb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","At hay maphod ya mumbattaanta, at amangom tun nunlene'woh an luta ta pot'om di pohdom hi ihinanyu ta nan angangom ya hiyay pangipluyanmi.” ");
INSERT INTO ifb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","At nunle'wohon mah Lot an inamang nan nunlene'woh an luta, ya inamangna nan nundotal an babluy an neheggon hinan Wangwang an Jordan ta nangamung ad Zoar. Ya ma\"aphod hi nannigana ti do'ol di danum hidi an umat hinan galden Apo Dios, ya wada goh di niyengngohanah ad Egypt. (Ya heden gutudna ya agguy ni' pina\"in Apo Dios ad Sodom ya ad Gomorrah.) ");
INSERT INTO ifb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","At hakupon Lot an amin nan niyappit hinan buhu'an di algaw ya an amin nan nundotal an lutah di ad Jordan, at hidiy nangipluyandan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","At da Abram di nataynan ta diday nihinah ad Canaan, ya da Lot di immuy an ni'babluy hinan nundotal an siudad hinan neheggon ad Sodom. ");
INSERT INTO ifb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mu nan tatagud Sodom ya nidugah an na\"appuhiy ato'atondan nun'abaholandan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ya unat goh nalpah an nakak da Lot ya inalin Apo Dios ay Abram di, “Hamadom an amangon nan nunlene'woh. ");
INSERT INTO ifb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ti an amin heten lutan ipogpogan di tigom ya idat'un he\"a ya nan holagmu ta da'yuy ad lutah enggana. ");
INSERT INTO ifb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ya hay idat'uh holagmu ya do'ol ahan an umat hi hupu' hitun lutan adi mabilang. ");
INSERT INTO ifb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","At umuy'a ta eka le'don ta tigom heten lutan idat'un he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","At ibunag mah Abram nan abung an tulda ta inyuynah nan neheggon hinan awadan di o\"ongol an ayiw an bagin Mamre hidid Hebron, ya inyammana goh hidi nan pun'onngan ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ya heden gutudna ya wada han opat an a'ali an da Amraphel an alid Shinar, ya hi Arioch an alid Ellasar, ya hi Kedorlaomer an alid Elam, ya hi Tidal an alid Goyim. ");
INSERT INTO ifb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ya dida ya nan titindaluda ya immuyda ginubat nan titindalun di leman a'alih nan udumnan babluy an da Bera an alid Sodom, ya hi Birsha an alid Gomorrah, ya hi Shinab an alid Admah, ya hi Shemeber an alid Zeboyim, ya nan alid Bela (unu Zoar). ");
INSERT INTO ifb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ya daten leman a'ali ya nan titindaluda ya nunlalammungdah ad Siddim hinan way nundotal an lutan neheggon hinan mungngadan hi Natoy an Lobong ta munggubatdah nan opat an a'ali ya nan titindaluda. ");
INSERT INTO ifb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ya danen leman a'ali ya himpulu ta duway tawon di nangun'unudandah nan Alin hi Kedorlaomer, mu heden miyapulu ta tuluy tawon ya ginubatda hiya ya nan titindaluna ti agguyda penhod an unudon mahkay. ");
INSERT INTO ifb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ya heden miyapulu ta opat an tawon ya hi Kedorlaomer ya nan i'ibbanan a'ali ya nan titindaluda ya immuyda ta ginubatda nan leman a'ali ya nan titindaluda. Ya heden nange'wandan babluy ya ginubatda nan holag Repha hi ad Ashteroth Karnaim, ya nan ma'alih Zuzim hi ad Ham, ya nan holag Em hi ad Shaveh Kiriathaim, ");
INSERT INTO ifb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ya nan holag Hor hinan babluy ad Seir, ya numpudugda dida ta nangamung ad El Paran hinan pingit di mapulun. ");
INSERT INTO ifb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ya unat goh nalpah ya numbangngadda, ya nidatongdah ad En Mishpat (an hay ohan ngadana ya ad Kadesh), ya na'abakdan amin nan holag Amalek ya nan holag Amor hi ad Hazezon Tamar. ");
INSERT INTO ifb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ya nan titindalun di leman a'ali an nan alih ad Sodom, ya ad Gomorrah, ya ad Admah, ya ad Seboiim, ya ad Bela (an hay ohan ngadana ya ad Zoar) ya immuydah nan nundotal an lutah ad Siddim ta hidiy nanodandah gubatonda ");
INSERT INTO ifb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","an nan titindalun di opat an a'ali an da Kedorlaomer, ya hi Tidal, ya hi Amraphel, ya hi Arioch ta munggugubatda. ");
INSERT INTO ifb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ya heden nundotal an ad Siddim ya do'ol di naba\"ungan an lutan napnuh ispaltu. Ya unat goh wan ma'abak daden leman a'ali ya nan titindaluda ya limmayawda. Ya nan udumnan tindalun nan a'alid Sodom ya ad Gomorrah ya inyogpahdah nan naba\"ungan an luta ta nipo\"oyda, ya immuydah nan dudunduntug di udumnan mipo\"oy. ");
INSERT INTO ifb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ya nan nangabak an opat an a'ali ya nun'aladan amin nan gina'un nan iSodom ya iGomorrah an ta\"on nan ma'an ya nun'alada ya unda makak. ");
INSERT INTO ifb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ya kinaphulda goh hi Lot an amona'on Abram, ya ni'yaladan amin di gina'unah dih nan nunhituwanah ad Sodom. ");
INSERT INTO ifb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mu wada han ohan lala'in nunligud, ya immuy ay Abram an ma'alih Hebrew an nangibaag hinan na'at ay Lot. Ya hi Abram ya nunhituh nan neheggon hinan o\"ongol an ayiw an bagin Mamre an nan holag Amor an agin da Eshkol ay Aner, ya liligwan Abram dida. ");
INSERT INTO ifb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ya unat goh dengngol Abram an enekakda nan tulangna at inayagana din tatagun nun'ala'eng an mi'gubat an tuluy gahut ya han himpulu ta walu ta inunudda din titindalun di a'ali an nangekak ay da Lot hi engganah ad Dan. ");
INSERT INTO ifb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ya unat goh wan nahdom ya ginodwan Abram nan tataguna ta duwam pamulog ta umuyda li'ubon an gubaton nan binuhulna. Ya unat goh ginubatda ya inamehda dida, ya numpudugda ta nangamung ad Hobah hi appit hi iggid hi un hagangon di buhu'an di algaw ad Damascus. ");
INSERT INTO ifb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","At bangngadon da Abram an amin din gina'un hinamhamda, ya hi Lot an amona'ona, ya ta\"on nan binabai, ya nan udumnan tatagun nakaphul. ");
INSERT INTO ifb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ya heden numbangngadan da Abram hidin nalpahan di nangamehandan da Kedorlaomer, ya nan i'ibbanan a'ali, ya nan alih ad Sodom ya immuy ta damuwona didah nan Hadog an Shaveh an ma'alih Hadog di Ali. ");
INSERT INTO ifb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ya hi Melchizedek an alih ad Salem ya hiya goh di padin Apo Dios an na'abbagbagtu. Ya inyuynay tinapay ya bayah ay Abram. ");
INSERT INTO ifb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","At winagahana hiyan inalinay, “Hi Apo Dios an na'abbagbagtu an Hiyay nunlumuh ad daya ya tun luta ya Hiyay munwagah ay he\"a, Abram. ");
INSERT INTO ifb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","At madayaw hi Apo Dios ti Hiyay bimmadang ta way inatmun nangammeh hinan binuhulmu!” At hay inat Abram ya indatnan Melchizedek nan mun'iyapuluh nan binangngadna. ");
INSERT INTO ifb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ya nan alih ad Sodom ya inalinan Abram di, “Nan tatagu' di ipabangngadmu ya ammuna, ya bagim an amin nan gina'u.” ");
INSERT INTO ifb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mu tembal Abram, ya inalinay, “Adi umat hinay ato' ti intulag'un Apo Dios an na'abbagbagtun nunlumud abuniyan ya tun luta ");
INSERT INTO ifb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","an adi mabalin hi un way ala' hinan nabangngad an ta\"on ah putlung an hinulid unu nan go'od di tsinelas ta mid alyom hi udum di algaw hi unna' impa'adangyan ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","At mi'id ah ala' an ammuna nan inanmih tun initnud'u an tatagu' ya nan idatmuh nan liligwa' an da Aner, ya hi Eshkol, ya hi Mamre an bimmadang.” ");
INSERT INTO ifb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ya unat goh nalpah hana ya numpa'ilah Apo Dios ay Abram, ya inalinay, “Abram, adi'a tuma'ot hinan ma'ma'at ti baliwa' he\"a, ya idat'uy ongol hi awagaham.” ");
INSERT INTO ifb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ya inalin Abram di, “Apo Dios an nabagbagtu, mu hay pangi'ata' hinan idatmun ha\"in ti mi'id ah imbaluy'uh pangipaboltana'? Ti un anggay hi Eliezer an iDamascus hi mamnoh hi odon'u, ");
INSERT INTO ifb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ya ten mid ah indatmuh imbaluy'u, at nan ohan baal'uy mamnoh hinan odon'u!” ");
INSERT INTO ifb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ya inalin goh Apo Dios ay Abram di, “Bo'on nan baalmuy mamnoh hinan odonmu ti nan iyimbaluymu.” ");
INSERT INTO ifb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ya impapitaw Apo Dios hi Abram, ya inalinay, “Tangadom ad daya ta tigom nan do'ol an bittuan an adi'a pa'abbilang. At hi awniat umat hinay ado'ol di holagmu.” ");
INSERT INTO ifb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ya kinulug Abram hi Apo Dios, at imbilang Apo Dios an nahamad di ugalina. ");
INSERT INTO ifb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ya inalin goh Apo Dios ay hiyay, “Ha\"in nan Dios an nangipakak ay he\"ah nan babluy ad Ur hi ad Babylon ta he\"ay pangipabnoha' eten luta ta bagim.” ");
INSERT INTO ifb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mu inalin Abram di, “Apo Dios an nabagbagtu, hay atom ta way panginnilaa' hi unmu ipabnoh ay ha\"in?” ");
INSERT INTO ifb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ya inalin Apo Dios ay hiyay, “Eka ummal hi baka, ya gandeng, ya nan buta'al an kalnilun hintutluy tawonda, ya ni'yalam'ah ohah putta ya balug.” ");
INSERT INTO ifb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ya innal Abram hadin amin, ya innayunan genlot, ya ginodwana ta nunhiyanona, mu agguyna ginodwa nan putta ya balug. ");
INSERT INTO ifb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ya natapanganday bannug ta umuyda ihda nan dotag, mu inabul Abram dida. ");
INSERT INTO ifb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ya unat goh nahilip ya ma\"aliy enlo' Abram, at nolo'. Ya hin'alina ya tinnigna han pa'ahhelong an atata'ot. ");
INSERT INTO ifb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ya inalin Apo Dios ay hiyay, “Nan holagmuh udum hi algaw ya bunagdah nan udum an babluy ta mumbalindah himbut hi opat di gahut an tawon, ya nunheglay ipaligligatanda. ");
INSERT INTO ifb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mu la'tot ya moltao' nan tatagun nen babluy an mangipaligligat ay dida, at hay angunuhna ya makakda, ya pi'yalada nan do'ol an gina'u. ");
INSERT INTO ifb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ya he\"a ya matubayan'a, ya malenggop'ah atayam. ");
INSERT INTO ifb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ya maluh di miyapat an holag ya mumbangngadda nan holagmun ten babluy. Mu adi' ni' pakakon nan holag Amor an mangamangat hi nappuhi ta nangamung unda iyal'allan mangat hi nappuhi, at hiyay gutud di pummoltaa' ay dida.” ");
INSERT INTO ifb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ya unat goh na'unug nan algaw an mun'a'ahom ya tinnig Abram han kawalin napnuh balan mun'ahu' ya nan mundalang an ayiw an naluh hinan numbattanan di nagogod an dotag. ");
INSERT INTO ifb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ya heden algaw ya ni'tulag hi Apo Dios ay Abram, ya inalinay, “Heten lutan mete\"ah nan nipogpogan di ad Egypt ta malbih nan Wangwang an Euphrates ya ipabnoh'uh nan holagmu. ");
INSERT INTO ifb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ya ipabnoh'u goh ay da'yu nan lutan numbabluyan nan holag Ken, ya nan holag Keniz, ya nan holag Kadmon, ");
INSERT INTO ifb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ya nan holag Heth, ya nan holag Periz, ya nan holag Repha, ");
INSERT INTO ifb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ya nan himpampun an holag Amor, ya nan iCanaan, ya nan holag Girgas, ya nan iJebus.” ");
INSERT INTO ifb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hi Sarai an ahawan Abram ya bahig, mu waday tagalanan i'Egypt an nungngadan hi Hagar. ");
INSERT INTO ifb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","At inalin Sarai ay Abram an ahawanay, “Hi Apo Dios ya agguyna inabulut an waday imbaluyta. At eka me'yelo' hinan tagala' ta wada ay di imbaluyyu ya hiyay imbaluyta.” At inabulut Abram nan inalin ahawana. ");
INSERT INTO ifb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Heden miyapulun tawon da Abram ad Canaan ya hiyay nangidatan Sarai ay Hagar an tagalana ta miyadwan ahawan Abram. ");
INSERT INTO ifb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","At ne'yelo' hi Abram ay Hagar, at nunhabi. Ya unat goh nunhabi ya pihulonah Sarai an ad tagalan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ya inalin Sarai ay Abram di, “He\"ay ad bahol hinan pamihupihulan nan tagala' ay ha\"in ti ha\"in nangabulut an me'yelo\"an hiya! Ya ad ugwan an inilanan nunhabi ya pihulona' ay hiya! At hi Apo Dios di mangipanuh ay dita nu hay ad bahol.” ");
INSERT INTO ifb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mu inalin Abram ay ahawanay, “He\"ay ad tagala, at okod'ah pohdom hi atom ay hiya.” Ya nunheglay inat Sarai an namaligat hinan tagalana, at la'tot ya limmayaw ta taynanah Sarai an apuna. ");
INSERT INTO ifb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","At nan Anghel Apo Dios ya inah'upanah Hagar hinan awadan di obob hinan mapulun an owon an umuy ad Shur. ");
INSERT INTO ifb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ya inalin nan Anghel ay hiyay, “Hagar an tagalan Sarai, hay nalpuwam, ya hay umayam?” “Ya tembalnan inalinay, Lumayawa' ta tayna' hi Sarai an apu'.” ");
INSERT INTO ifb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ya inalin nan Anghel Apo Dios ay hiyay, “Mumbangngad'aat ta inaynayunmun muntagalan hiya, ");
INSERT INTO ifb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","at idat'uy do'ol an holagmun adi mabilang.” ");
INSERT INTO ifb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ya inalina goh di, “Nan inhabim ya lala'i, at itungawmu ay ya ngadanam ta hi Ishmael ti immannung an dengngol Apo Dios di pumpahpahmo'am. ");
INSERT INTO ifb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mu henen iyimbaluymu ya umat hinan atata'ot an animal an mi'id mapto' hi ihinana ti buhulonan amin di tatagu, ya buhulon goh di tatagu hiya. Ya hay pi'taguana ya mi'laban hinan tutulangna.” ");
INSERT INTO ifb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ya mete\"an de ya hay punnomnom Hagar ya hi Apo Dios di manalimun ay hiya. At inalinay, “Maphod ta heten atagu' ya tinnig'uh Apo Dios, ya ten matagua' ta way ato' an mangulgud hi nanniga' ay Hiya!” ");
INSERT INTO ifb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","At heden bubun ya nangadnan hi Beer Lahai Roi an wadah nan numbattanan ad Kadesh ya ad Bered, ya ihna goh hidid ugwan pay. ");
INSERT INTO ifb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","At nuntungaw hi Hagar, ya nginadnan Abram han ung'ungngan nitungaw ta hi Ishmael. ");
INSERT INTO ifb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ya hay tawon Abram ya nawalu ta onom hidin nangitungawan Hagar ay Ishmael. ");
INSERT INTO ifb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Hidin nuntawon hi Abram hi nahiyam ta hiyam ya numpattig hi Apo Dios ay hiya, ya inalinay, “Ha\"in hi El-Shaddai an nan Dios an abalinanan amin di logom, at unudona' ta ihamadmuy pangatmu. ");
INSERT INTO ifb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","At itulag'un he\"a ta do'lo' ahan di holagmu.” ");
INSERT INTO ifb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ya nunluung hinan lutah Abram an mange'gon ay Hiya. Ya impidwan Apo Dios an inalinay, ");
INSERT INTO ifb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Hay itulag'un he\"a ya do'lo' ahan di holagmu ta he\"ay ommod nan do'ol an tataguh nan abablubabluy. ");
INSERT INTO ifb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ya mete\"ad ugwan ya bo'on mahkay Abram di ngadanmu ta he\"ah Abraham ti pumbalino' he\"ah ommod an amin nan mumpunhituh numbino'ob'on an babluy. ");
INSERT INTO ifb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ti do'lo' ahan di holagmu ta miwa'atdah tun abablubabluy, ya mumpun'aliy udumnan dida. ");
INSERT INTO ifb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nan intulag'un he\"a ya minaynayun an ma'at an ta\"on nan a'apum hi enggana. At Ha\"in di dayawom, ya umat goh hinan mihukat ay he\"an holagmu ta Ha\"in di dayawonda. ");
INSERT INTO ifb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","An amin nan babluy ad Canaan an ni'hituwam ad ugwan ya idat'un amin ay he\"a ya nan holagmu ta da'yuy ad luta. Ya nan holagmu ya mahapul an Ha\"in an Dios di dayawondah mi'id pogpogna.” ");
INSERT INTO ifb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ya inalin goh Apo Dios ay Abraham di, “Nonomnomom nan intulag'un he\"a, at mahapul an atom, ya ta\"on nan holagmu ya nan holagda goh ya mitutuluy an unudonda ta adida aliwan. ");
INSERT INTO ifb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","At hay panginnilaan hi pangunudam ya mahapul an makugit an amin nan linala'i ya ta\"on nan holagda. ");
INSERT INTO ifb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","At makugit ayun amin ta panginnilaan hinan intulag'un he\"ah mahapul an unudom. ");
INSERT INTO ifb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mete\"ad ugwan ya mahapul an makugit an amin di linala'in ung'ungungngah nan miyawaluy algawda, ya ta\"on nan himbut an mitungaw hi babluyyu, ya nan mipallog an himbut an malpuh nan udumnan babluy. ");
INSERT INTO ifb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","At an amin di linala'i ya mahapul an makugitda ta hiyay malkan di odolda ta panginnilaan an adi mapogpog nan intulag'un he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","At nan linala'in agguy nakugit ya agguy nibilang hi tagu' ti agguyna inunud di ni'tulaga' ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ya inalin goh Apo Dios ay Abraham di, “Hi Sarai an ahawam ya bo'on mahkay hi Sarai di ngadana ta hi Sarah. ");
INSERT INTO ifb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ya wagaha' hiya ta umimbaluy hi lala'i, ya hiyay ommod di do'ol an tatagun mumpunhituh nan numbino'ob'on an babluy. Ya waday mumpun'alih malpuh nan holagna.” ");
INSERT INTO ifb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ya nunluung hinan lutah Abraham ta dayawonah Apo Dios. Mu hiya ya kumikih punnomnomanan inalinay, “Undan mabalin an munholag di hinggahut di tawona? Ya undan mabalin an umimbaluy hi Sarah an nahiyam di tawona?” ");
INSERT INTO ifb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ya inalin Abraham ay Apo Dios di, “Undan ahan adi mabalin hi un nan holag'un hi Ishmael di mamnoh hinan tawid'u?” ");
INSERT INTO ifb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ya inalin Apo Dios di, “Bo'on, ti hi Sarah an ahawam ya umimbaluy hi lala'i, ya ngadnam ta hi Isaac. At hi Isaac di pi'tulaga' goh hinan mid pogpognan tulag'u ta nan holagnay pangipa'annunga' hinan intulag'un he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ya nan inalim an hi Ishmael ya wagaha' ta idat'uy do'ol an holagna. At hiyay ommod di himpulu ta duwan a'ap'apun di tatagu, ya umat goh hinan holagdan mundongol di aatda. ");
INSERT INTO ifb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mu hay ipa'annungan nan intulag'un he\"a ya han imbaluymun hi Isaac an itungaw Sarah hi tawon hinan umat hitun gutudna.” ");
INSERT INTO ifb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Unat goh nalpah an ni'hapit hi Apo Dios ay Abraham ya tinaynana. ");
INSERT INTO ifb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Heden algaw ya inunud Abraham nan inalin Apo Dios ay hiya, at kinugitnah Ishmael an imbaluyna. Ya inatna goh an amin hinan linala'in nan himbut an nitungaw hi babluyda ya nan nipallog an himbut an nalpuh nan udumnan babluy. ");
INSERT INTO ifb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Hi Abraham ya nuntawon hi nahiyam ta hiyam ya un makugit, ");
INSERT INTO ifb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ya hi Ishmael an imbaluyna ya nuntawon hi himpulu ta tulu ya un makugit. ");
INSERT INTO ifb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ya heden algaw ya nundehhan da Abraham ay Ishmael an nakugit. ");
INSERT INTO ifb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ya inatna goh an amin hinan linala'in nan himbut an nitungaw hi babluyda ya nan mipallog an himbut an malpuh nan udumnan babluy. ");
INSERT INTO ifb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ya wada han hin'algaw hi nuntonga ya numpatigaw hi Apo Dios ay Abraham hi wadanah nan neheggon hinan o\"ongol an ayiw an bagin Mamre. Hidin inu'umbunan Abraham hinan pantaw di abungnan tulda ");
INSERT INTO ifb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ya inta'wadna, ya tinnigna han tulun linala'in timmata'dogdan neheggon ay hiya, at mala\"uy ta ayna damuwon dida. Ya unat goh immatam ay dida ya innayunan nunluung ta apngaona dida. ");
INSERT INTO ifb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ya inalinan diday, “Apu, mahapul ni' ahan an mun'awa ayuh abung'uh na'amtang! ");
INSERT INTO ifb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","At mun'eblay ayun ten puun di ayiw ta umuy'u alan nan danum ta pangihuyuh nan hu'iyu ");
INSERT INTO ifb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ya ta damunah pangidadaana' hi ononyu ta way i'ilogyun mangituluy an umuy hinan ayanyu.” Ya tembalda, ya alyonday, “Oo, ta\"on ya henodmi.” ");
INSERT INTO ifb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","At nunnaudon Abraham an immuy hinan abungdan tulda, ya inalinan Sarah di, “Punnaudom ta alam nan ma\"aphod an alena, ya inyammam di udum hi tinapay.” ");
INSERT INTO ifb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","At immuy hinan pahtuda, ya pento'na nan ma\"aphod an mataban uyaw, ya impaguyudnah nan baalna ta ayda paltion ta ihaangda, at nunnaudondan inat. ");
INSERT INTO ifb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ya unat nidadaan ya innal Abraham nan udumnan mahapul an umat hi gatas ya nan udumnan mahapulda, ya nun'iddumnah din dotag ya nan ma'an, ya indadaana ta manganda nan linala'in mangilinah nan way puun di ayiw. Ya hi Abraham ya timmata'dog hinan way neheggon ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ya inalidan hiyay, “Hay wadan nan ahawam an hi Sarah?” Ya inalinay, “Wah dih nan abung an tulda.” ");
INSERT INTO ifb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ya inalin nan ohan hi Apo Dios di, “Hay pumbangngada' hi un maluh di umat hitun gutud hi mehnod an tawon ya waday itungaw ahawam an hi Sarah an lala'i.” Ya hi Sarah ya wah nan way pantaw di abung an tulda, ya ta\"on hi un nipo\"oy mu dengngolnah den inalina. ");
INSERT INTO ifb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ya heden gutudna ya ma'ma\"ilog hi Abraham ya na'in'innah Sarah an natdu' di matyamna. ");
INSERT INTO ifb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ya kimmikih Sarah hi nomnomna, ya inalina goh hinan nomnomnay, “Un mah mabalin an umimbaluya' an ten na'in'innaa' ya ma'ma\"ilog nan apu' an mumpapto' ay ha\"in? Ya un mah mabalin an waday umipa'amlong ay ha\"in ti ten namogpoga'?” ");
INSERT INTO ifb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ya inalin Apo Dios ay Abraham di, “Anaad ta ma'akikkih Sarah an inalinay, Un mah awni ta ma'in'innata ya unta mahkay umimbaluy? ");
INSERT INTO ifb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Undan way adi abalinan Apo Dios an aton? Ya ten alyo' an hay pumbangngada' hi umat hitun gutud eten mehnod an tawon ya itungaw Sarah han lala'in imbaluyna.” ");
INSERT INTO ifb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ya gapuh ta'ot Sarah ya inhautnan inalinay, “Agguya' kimmiki.” Ya tembal Apo Dios, ya inalinay, “Immannung an kimmiki'a.” ");
INSERT INTO ifb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ya unat goh nalpah di nunhahapitanda ya makak daden linala'i. Ya nitnud hi Abraham ta ipangulunay owondan ma'uhdungan ad Sodom. ");
INSERT INTO ifb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ya inalin Apo Dios goh di, “Munduwaduwaa' ti tagwan hi un'u ipa'innilan Abraham nan ninomnom'uh ato' unu adi'. ");
INSERT INTO ifb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Immannung an nan holagna ya munholagda ta dumo'olda ta diday mundongol di abalinandah nan abablubabluy, ya dumalat hiya ya wagaha' an amin nan tataguh abablubabluy. ");
INSERT INTO ifb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ti hiyay pento\"u ta tugunona nan holagna ya nan holagda ta Ha\"in di unudonda ta maphod an nahamad di atonda. Ya atonda ay ya mipa'annung an amin nan intulag'un Abraham hi ato'.” ");
INSERT INTO ifb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ya inalin Apo Dios ay Abraham di, “Nan tataguh ad Sodom ya ad Gomorrah ya nidugah an na\"appuhi nan ato'atondan pumbaholan. ");
INSERT INTO ifb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","At mahapul an umuya' hidi ta umuy'u hamadon hi un immannung unu agguy.” ");
INSERT INTO ifb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","At intuluy din duwan linala'in umuy ad Sodom, mu nataynan hi Abraham an gun mi'hapit ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","At inalin Abraham di, “Undan ta\"on un nan nahamad di pangatna ya iniddummun pumpi'patoy? ");
INSERT INTO ifb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mu gulat ta waday nabongleh nahamad di pangatda eden siudad ya pi'yubahmu damdama didan himpamabluy unu adim an dumalat dane han nabonglen nahamad di pangatda? ");
INSERT INTO ifb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mu He\"a ya inila' an nahamad di pamanuhmu, at adi mabalin an pi'yubahmu nan nahamad di pangatna! Ti atom ay ya undan adida mi'yubah hinan nun'abaholan?” ");
INSERT INTO ifb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ya tembal Apo Dios, ya inalinay, “Oo aga, gulat ta wadada ah nabongleh tatagun nahamad di pangatda at diday dumalat hi adi' pangubahan ay didan himpamabluy.” ");
INSERT INTO ifb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ya inalin goh Abraham di, “Apu, iyabulutmu ni' ahan ta ibaga' nan pohdo' an ta\"on unna' tagu ya anggay an un hay hupu' di nalpuwa'. ");
INSERT INTO ifb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mu gulat ta waday unda napat ya han lema ya anggay nan nahamad di pangatda ya adim ubahon heden babluy?” Ya inalin Apo Dios di, “Ta\"on unda napat ya han lema mu ta wadada at adi' ubahon.” ");
INSERT INTO ifb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ya inalin goh Abraham di, “Oo, mu gulat ta unda napat ya anggay?” Ya inalin Apo Dios di, “Adi' ubahon an ta\"on unda napat.” ");
INSERT INTO ifb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ya inalin Abraham ay Apo Dios di, “Adi'a ni' ahan bumungot ta wada goh han ibaga'. Ya gulat mah ta unda wada ah tulumpulu?” Ya tembal Apo Dios, ya inalinay, “Adi' an dumalat nan tulumpulu.” ");
INSERT INTO ifb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ya inalin goh Abraham di, “Apo Dios, iyabulutmu ni' ta ituluy'un ibaga tun wah nomnom'u. Mu gulat ta unda duwampulu ya anggay?” Ya inalinay, “Adi' ubahon heden babluy hi unda wada ah duwampulu.” ");
INSERT INTO ifb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ya inalin Abraham di, “Apo Dios, hiyah te angunuh di ibaga', at adi'a ni' ahan bumungot. Mu gulat ta unda himpulu ya anggay?” Ya inalin Apo Dios di, “Adi' ubahon heden babluy hi unda wada ah himpulu.” ");
INSERT INTO ifb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ya unat goh nalpah heden nunhapitandan Abraham ya nakak hi Apo Dios, ya nakak goh hi Abraham an immuy hidin abungnan tulda. ");
INSERT INTO ifb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ya wan munhinag ya dimmatongda nan duwan anghel hi ad Sodom. Ya wah dih Lot an inu'umbun hinan ubunan an neheggon hinan buhu'an den babluy. Ya unat goh tinnigna dida ya nala\"uy ta umuyna damuwon dida. Ya unat goh immatam an manamun dida ya nunluung ta apngaona dida. ");
INSERT INTO ifb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ya inalinay, “Ha\"in di ohah baalyu, at umuy tu'uh abungmi ta ihuanyu nan hu'iyu, ya immiyan ayu ta awni ta maweet ya unyu ituluy an umuy hinan ayanyu.” Mu tembalda, ya alyonday, “Adi ami! Hitu man hi ubunan, ya immiyan ami.” ");
INSERT INTO ifb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mu hi Lot ya pimagmagoh an mangal'alu' ay dida, ya la'tot ya inabulutda, ya nitnuddan hiya ta immuydah abungna. Ya nunhaang hi Lot hi tinapay an adi mabino'bo'an, ya numpaltida ta way ihdan nan mangili. Ya unat goh nalutu ya nanganda. ");
INSERT INTO ifb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ya uwani an agguyda immuy nolo' daden mangili ya immuydan amin nan linala'in iSodom an mumpangilog ya nan nun'ala'ay ta lini'ubda nan abung Lot. ");
INSERT INTO ifb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ya mun'alidan Lot an alyonday, “Hay wadan din linala'in impa'iyanmu? Mahapul an ipapitawmu dida ta umalidan da'mi ta way atonmin mangelo' ay dida!” ");
INSERT INTO ifb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ya limmahun hi Lot ta way atonan mi'hapit ay dida, ya intangobna nan pantaw. ");
INSERT INTO ifb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ya inalinah nan iSodom di, “I'ibba, adi ni' ahan nginin di nappuhih atonyu! ");
INSERT INTO ifb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","At tun duwan binabain imbaluy'u an agguy nalhin di ipalahun'u ta okod ayuh nan pohdonyun aton ay dida. Mu ta bo'on tun mangili' ti mahapul an ipapto\"u dida.” ");
INSERT INTO ifb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mu alyonday, “Un'a udot bunag ya he\"ay mummandal ay da'mi? Miwa'lin'a at hina ti la'tot ya immipabohol'a, ya nunnaud di atonmin he\"a ya un danen linala'i!” At nadhudan nangituldun ay Lot ta way atondan umuy mama\"ih tangob. ");
INSERT INTO ifb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mu na'ibboggon nan duwan mangilin nunlapdu' ay Lot hinan pantaw, ya impahigupdah baluy, ya intangobda nan pantaw. ");
INSERT INTO ifb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ya binulawdan amin din linala'in wah dola an iSodom, at mid ologdan mangah'up hinan pantaw. ");
INSERT INTO ifb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ya inalin din duwan linala'in Lot di, “Undan mi'id a'agim, ya imbabaluymu, ya inapum, ya hay way tutulangmuh ni'hitun ten babluy? Ya gulat ta wadada ya eka inalin dida ta mi'yekakdan da'yu ta taynanyuh ten babluy ");
INSERT INTO ifb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ti ten ubahonmih ten babluy! Ya manu ay atonmi oo ti ininnilan Apo Dios nan nidugah an na\"appuhin ato'atonda, at hiyaat un da'mi hennag ta ubahonmih ten babluy an ad Sodom.” ");
INSERT INTO ifb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","At immuy hi Lot hidin linala'in apuwona an niyalih din imbabaluynan binabai, ya inalinan diday, “Punnaudon tu'un makak hitu ti hi Apo Dios ya ubahonah ten babluy tu'u!” Mu hay ninomnomda ya alyondah un nin munhanul. ");
INSERT INTO ifb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ya wan na'uy an mawa'ah ya din duwan anghel ya numbangondah Lot an alyonday, “Punnaudom an bumangon, ya inawitmuy ahawam ya nan duwan binabain imbabaluymu ta lumayaw ayu ta adi ayu mi'lagat hi amoltaan ten babluy!” ");
INSERT INTO ifb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mu palunlunot hi Lot an makak. Mu nidugah di nammo' Apo Dios ay dida, at din duwan linala'i ya inodnanday ngamaydan hina\"ama, ya enekakda dida ta nangamung unda binataanan heden babluy. ");
INSERT INTO ifb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ya inalin den ohan anghel ay diday, “Ekayu mahkay ta punnaudonyun lumayaw! Ya adiyu man ahan wingwingiyon nan babluy an tinaynanyu! Ya adiyu ita'dog eden nundotal an pange'wanyu ta nangamung un ayu umatam hinan aduntuduntug ta mabaliwan ayu ta adi da'yu ilagat hinan apuy!” ");
INSERT INTO ifb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ya hi Lot ya inalinay, “Bo'on ni' nan adagwiy ayanmi, Apu! ");
INSERT INTO ifb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ya inila' an nidugah di nammo'mun ha\"in ti binaliwana'. Mu mid olog'un lumayaw an umuy eden aduntuduntug, at la'tot ya inlagat da'mih nan dalan, ya natoy ami, ya mid umatam hidi. ");
INSERT INTO ifb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Undan ahan adi mabalin un heden neheggon an it'ittang an babluy di ayanmi ta mabaliwan ami?” ");
INSERT INTO ifb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ya inalin nan anghel di, “Abuluto' nan pohdom ta hidiy ayanyu, at adi' mah pi'yubah hede han it'ittang an munisipyu. ");
INSERT INTO ifb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","At punnaudonyun umuy hidi ta awni ta umatam ayu ya un'u ete\"a nan ato'!” (Ya heden munisipyu ya nginadnanda ta ad Zoar ti hay nangalyan Lot hi un it'ittang an babluy.) ");
INSERT INTO ifb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ya heden dimmatngan da Lot ad Zoar ya bimmuhu' nan potang. ");
INSERT INTO ifb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ya hin'alina ya nun'ogah Apo Dios nan ahigegeladaw an apuy an nalpud dayan nun'agah ad Sodom ya ad Gomorrah. ");
INSERT INTO ifb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","At nun'oghob an amin di logom hidih nan babluy, ya an amin di tatagu, ya nan numbino'ob'on an himmangaw hinan luta. ");
INSERT INTO ifb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mu hi ahawan Lot ya nunligguh ta tigona nan nalpuwanda, at hiya ya numbalin hi ahin an immodhol an timmata'dog an ay tu'ud. ");
INSERT INTO ifb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ya unat goh nabiggat hi helhelong ya immuy hi Abraham hidin timma'doganah din ni'hapitanan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ya unat goh inuhdunganad Sodom, ya ad Gomorrah, ya nan nundotal an luta ya tinnigna nan umu'utyu' an ahu' an nalpun den lutan umat hi ahu' an malpuh nan pun'apuyan. ");
INSERT INTO ifb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mu heden nangubahan Apo Dios eden siudad an ni'hituwan Lot ya ninomnom Apo Dios hi Abraham ta inyabulutnay lumayawan da Lot ta agguyda nilagat. ");
INSERT INTO ifb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ya dimmalat nan ta'ot Lot an mihinah ad Zoar ya initnudna nan duwan binabain imbabaluyna ta nunti'iddah nan aduntuduntug an wadan di liyang ta hiyay nunhituwanda. ");
INSERT INTO ifb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ya wa han ohay algaw ya heden pangpangullun babai ya inalinah nan aginay, “Ten gun mala'ay hi amata, ya ten mi'id ah linala'ih tun wadan tu'uh mangahawan dita ta way ahlagantan umat hinan ma'ma'at hitun alutaluta. ");
INSERT INTO ifb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","At butngontah amata ta way atontan mangelo' ay hiya ta way ahlagantah hanat amata.” ");
INSERT INTO ifb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","At heden nahdom ya binutongdah amada, ya enelo' den pangpangullu. Mu hi amada ya na'abbutong, at agguyna enelan di na'at. ");
INSERT INTO ifb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ya heden nabiggat hi nahdom ya inalin han pangpangulluh nan aginay, “Enelo\"u hiyad a\"u, at butngonta hiya goh ad ugwan an nahdom ta elo'mu hiya ta ditan duwa ya mawaday imbaluytan dumalat hi amata.” ");
INSERT INTO ifb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","At heden nahdom ya binutongda goh hiya, at enelo' goh de han udidian. Mu na'abbutong hi amada, at agguyna enelan goh nan na'at. ");
INSERT INTO ifb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ya daten duwan imbabaluy Lot ya nunhabidan dimmalat hi amada. ");
INSERT INTO ifb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ya unat goh nuntungaw heden pangpangullu ya lala'i, at nginadnana ta hi Moab, ya hiyay napu'agan nan iMoab ad ugwan. ");
INSERT INTO ifb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ya unat goh nuntungaw heden netob ya lala'i goh, at nginadnana ta hi Ben-Ammi, ya hiyay napu'agan nan holag Ammon ad ugwan. ");
INSERT INTO ifb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","At la'tot ya tinaynan da Abraham ad Mamre ta umuydah nan numbattanan di ad Kadesh ya ad Shur hinan babluy ad Canaan. At mumbunagda goh ta nunhitudah na'amtang hi ad Gerar. ");
INSERT INTO ifb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hidin awadandah ad Gerar ya hiyay nangalyan Abraham un hi aginah Sarah an ahawana. At hi Abimelek an alih ad Gerar ya impa'awitnah Sarah ta ahawaona. ");
INSERT INTO ifb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mu wada han ohan labi ya numpa'enap hi Apo Dios ay Abimelek, ya inalinay, “He\"a ya matoy'a ti hi Sarah an impa'awitmu ya waday ahawana.” ");
INSERT INTO ifb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mu agguy enelo' Abimelek hi Sarah, at hiyanan inalinay, “Apo Dios, mi'id ah inat'uh nappuhi! Ya moltaona' mah ya ta\"on nan tatagu ya pi'moltam? ");
INSERT INTO ifb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Heten inat'u ya maphod hi punnomnoma', at mi'id bahol'u ti inalin Abraham di un hi aginah Sarah! Ta\"on hi Sarah ya inalina goh di unda hin'agi!” ");
INSERT INTO ifb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ya intuluy Apo Dios an numpa'enap ay Abimelek, ya inalinay, “Oo, inila' an bo'on baholmu. Hiyaat un'u agguy inyabulut an me'yelo\"an hiya ta adi'a mumbahol ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","At ibangngadmu nan babai ay ahawana ti propeta hiya, at iluwaluan da'a ta du'du\"oy di pi'taguam. Mu adim ay ibangngad hiya ya matoy'a ya nan tatagum goh.” ");
INSERT INTO ifb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ya hidin nabiggat ya bimmangon hi Abimelek, at inayaganan amin nan u'upihyalna ta ibaagnan dida nan na'at ay hiya. Ya nidugah di ta'otda. ");
INSERT INTO ifb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ya inayagan Abimelek hi Abraham, ya inalinay, “Ngadan nan inatmun da'mi? Ngadan di nappuhih inat'un he\"ah dimmalat hi aymi atayan? Adi ahan maphod nan inatmun ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ya anaad ta inatmuy umat hitu?” ");
INSERT INTO ifb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ya tembal Abraham an inalinay, “Oo ti hay ninomnom'u ya mi'id ay da'yuy tuma'ot ay Apo Dios, at patayona' an dumalat hi ahawa'. ");
INSERT INTO ifb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ya hiya ya immannung an hi agi' ti benentan ama, mu hiyay inahawa'. ");
INSERT INTO ifb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Hidin nangalyan Apo Dios hi tayna' nan nunhituwanmin da ama ta umuya' hinan udum an babluy ya inali' ay ahawa' di, Ipattigmuy pamhodmun ha\"in hinan gunmu pangalyan hi unta hin'agih nan gunta ayan hinan malgom an babluy ta way adida pamatayan ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ya imbangngad Abimelek hi Sarah ay Abraham, ya indatana didah kalnilu, ya baka, ya tagala. ");
INSERT INTO ifb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","At inalin Abimelek di, “Luta' an amin hatu, at mumpili'ah punhituwam.” ");
INSERT INTO ifb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ya inalina goh ay Sarah di, “Idat'uy hinlibuh pihhun Abraham an agim ta gapgapa' nan mi'id immannung hi inat'un he\"a ta panginnilaan nan tatagu.” ");
INSERT INTO ifb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","At nunluwaluh Abraham ta impa'adaog Apo Dios da Abimelek an himbaluy ya nan tagalada ta way atondan mahlag. ");
INSERT INTO ifb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ti hi Apo Dios ya nun'umutonay putun nan ahawan Abimelek ya nan tagalan binabai ta way atondan adi mahlag an dumalat hi Sarah an ahawan Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Hi Apo Dios ya hemmo'nah Sarah ta impa'annungna nan inalina. ");
INSERT INTO ifb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","At nunhabih Sarah. At heden gutudnah inalin Apo Dios hi puntungawana ya nuntungaw, at lala'iy imbaluyda ay Abraham eden nala'ayana. ");
INSERT INTO ifb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","At nginadnan Abraham nan imbaluynan intungaw Sarah ta hi Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","At kinugit Abraham hi Isaac eden miyawalun algawna ti hiyah ne intulag Apo Dios hi atona. ");
INSERT INTO ifb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Hi Abraham ya hinggahut di tawonah din nitungawan Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ya hi Sarah ya inalinay, “Kimmikia' an dumalat nan inat Apo Dios! At an amin nan mangngol eten na'at ya mi'kikidan ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ya inalina goh di, “Mi'id nin ahan di mangalin Abraham hi un mumpa'inum hi Sarah hi ung'ungnga! Mu ta\"on hi un nala'ay ya waday inyimbaluynan ha\"in hi lala'i!” ");
INSERT INTO ifb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ya heden algaw hi naphuwan den ung'ungnga ya impaltian Abraham hi nun'am'amlonganda. ");
INSERT INTO ifb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Mu tinnig Sarah hi Ishmael an imbaluy Hagar an i'Egypt ay Abraham an daladalatonah Isaac an imbaluydan Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ya inalinan Abraham di, “Pakakom nan tagalan babai ya nan imbaluyna! Ti nan imbaluyna ya adi me'ebnoh hinan banoh Isaac an imbaluy'u!” ");
INSERT INTO ifb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ya nidugah di punlungdayaan Abraham ti hi Ishmael ya imbaluyna damdama. ");
INSERT INTO ifb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mu inalin Apo Dios ay Abraham di, “Adi'a munlungdaya an dumalat nan ung'ungnga ya nan babain tagalam. Unudom an amin di inalin Sarah ay he\"a ti hi Isaac di ipa'annungan nan intulag'un dumo'ol di holagmu. ");
INSERT INTO ifb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","At do'lo' goh ahan di holag nan imbaluy di tagalam an babai ti hiya ya holagmu damdama.” ");
INSERT INTO ifb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ya heden nabiggat hi helhelong ya bimmangon hi Abraham ta indadaanay ma'an ya danum an impabalunan da Hagar an hin'ina. At ipiyabban Abraham ay Hagar heden unga ta honogona dida. At nakak da Hagar ta himminulngungawdah nan mapulun hi ad Beersheba. ");
INSERT INTO ifb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Unat goh napuh nan danum an impabalun Abraham ya inyuyna inhugo' nan ung'ungngah nan puun di ohah nan i\"itang an ayiw. ");
INSERT INTO ifb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ya impadehna ta bimmataan hi itang, ya inumbun, ya inalinay, “Adia' pa\"edpol an mannig hi atayan nen ung'ungnga!” At ma'allugwah Hagar. ");
INSERT INTO ifb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mu hi Apo Dios ya dengngolnay kilan han ung'ungnga. At nan Anghelnad abuniyan ya himmapit ay Hagar an inalinay, “Ngadan nan numanomnomam? Adi'a tuma'ot ti dengngol Apo Dios nan kilan han imbaluymu. ");
INSERT INTO ifb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","At ekaat ya hinalimunam ti hiya ya do'lo' di holagna ta mundongol!” ");
INSERT INTO ifb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ya impattig Apo Dios ay Hagar han pugun an humaguban, at immuy himmagub, ya impa'inumanah den imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","At hi Apo Dios ya impapto'na han ung'ungnga ta nangamung immilog. Ya hidih nan way mapulun nihinanda, at numbalin hiyah nala'eng an manganup. ");
INSERT INTO ifb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ya heden nihihinnandah nan way mapulun hi ad Paran ya immawit hi inanah babain i'Egypt ta ipa'ahawanan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ya nihippul eden inayan da Abimelek ay Phicol an ap'apun di tindalunan Abraham, ya inaliday, “Wagwadah Apo Dios an bumadang ay he\"ah an amin hinan atom! ");
INSERT INTO ifb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ad ugwan ya ihapatam ay Apo Dios an adia' balbaliyan ay he\"a ya nan holag'u. Ya atom di maphod ay da'min ten babluy an ni'hituwam an umat hi nangatmin he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ya inalin Abraham di, “Immannung an ato'.” ");
INSERT INTO ifb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","At impa'innilan Abraham ay Abimelek an nan baalna ya penlohda nan bubun an impiyamman Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ya inalin Abimelek di, “Agguy'u inilay nangat ti agguyyu inal'alin ha\"in! An ad ugwan ya un'u innilaon!” ");
INSERT INTO ifb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","At idatan Abraham hi Abimelek hi kalnilu ya baka ta way mangipa'innilan maphod di nunhappitananda. ");
INSERT INTO ifb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","At ilahhin Abraham di pituh tetentennan kalnilu. ");
INSERT INTO ifb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ya inalin Abimelek ay Abraham di, “Anaad ta ilahhinmuy pituh kalnilu?” ");
INSERT INTO ifb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ya inalin Abraham di, “Hatun pitun kalnilu ya alam ta he\"ay mun'ihtigu an ha\"in di nangiyamma eten bubun.” ");
INSERT INTO ifb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","At hiyay dimmalat hi nungngadanandan den babluy hi ad Beersheba ti heden lugal di nunhapitanda. ");
INSERT INTO ifb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Unat goh nalpah di nunhapitanda ya numbangngad da Abimelek ay Phicol hinan babluydah ad Philistia. ");
INSERT INTO ifb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","At intanom Abraham di ayiw an tamarisk, ya dinayawnah Apo Dios an mi'id te\"ana ya mid pogpogna. ");
INSERT INTO ifb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","At hi Abraham ya nadnoy di nihihinnanah ad Philistia. ");
INSERT INTO ifb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ya unat goh palpaliwan ya tinapngan goh Apo Dios di pangulug Abraham. Ya inalinay, “Abraham!” Ya tembalnan inalinay, “Ngadan ne, Apu?” ");
INSERT INTO ifb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ya inalin Apo Dios ay hiyay, “Awitom han oh'ohhan imbaluymun hi Isaac an pa'appohpohdom, ya immuy ayuh nan Duntug an Moriah ta e'nongmu hiyan Ha\"in hinan aduntuduntug an itudu'.” ");
INSERT INTO ifb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ya unat goh nabiggat hi helhelong ya nunggihan Abraham din ayiw an mahapulnah nan pun'onngan, ya indadaana nan dongkin pangitakayandah nan kalgada, ya inawitnah Isaac ya nan duwan baalna, ya impadehdan umuy hinan inalin Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ya heden atlun di algaw hi nundallananda ya inamang mahkay Abraham heden lugal an ayanda. ");
INSERT INTO ifb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ya inalin Abraham hinan baalnay, “Mihina ayuh tuh tun dongki ta da'mi an hin'amay mada'puh hidi ta umuy ami mundayaw ay Apo Dios ya un ami mumbangngad hitu.” ");
INSERT INTO ifb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","At impapi'ug Abraham ay Isaac nan ayiw ta hiyay nangdon hinan apuy ya uwah, at muntunudda. ");
INSERT INTO ifb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ya inalin Isaac di, “Ama, anaad udot ta inodnam nan apuy ya ayiw, ya mi'id di uyaw an kalniluh me'nong?” ");
INSERT INTO ifb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ya tembal Abraham ya inalinay, “Okod hi Apo Dios an mangidat hi uyaw an kalniluh me'nong!” At intuluydan hin'aman umuy. ");
INSERT INTO ifb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ya unat goh dimmatongdah nan inalin Apo Dios ya inyamman Abraham di pun'onngan, ya impaphodnan timpun din ayiw hinan pun'onngan. Ya hinawidna han imbaluynan hi Isaac, ya inyuhunah nan natpun an ayiw hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ya inong'alna din uwah an panglotnan hiya, ");
INSERT INTO ifb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","mu waday himmapit an nan Anghel Apo Dios ad abuniyan an inalinay, “Abraham! Abraham!” Ya tembal Abraham, ya inalinay, “Hay alyom, Apu?” ");
INSERT INTO ifb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ya inalin han Anghel ay hiyay, “Adim hugatan henen ung'ungnga, ya adi nginin di atom ay hiya! At ten inila' an hi Apo Dios di ipabagtum hi unudom ti ta\"on un oh'ohha nan imbaluymu ya adim ukuhan an e'nong ay Hiya!” ");
INSERT INTO ifb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ya hin'alina ya nungwingih Abraham, ya wada han buta'al an kalnilun nihahabut di ha'gudnah nan ayiw an neheggon ay hiya. At hiyay ayna innal ta hiyay genhobnah ne'nong ay Apo Dios hi hukat han imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","At nginadnan Abraham heden lugal an inayandan inalinay, “Hay ngadan te ya Hi Apo Dios di Mangidat hi Mahapul.” At engganad ugwan ya hiyay pungngadan nan tatagun den duntug an alyonday, “Duntug an Nangidatan Apo Dios hi Mahapul.” ");
INSERT INTO ifb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ya impidwan nan Anghel Apo Dios ad abuniyan an himmapit, ya inalinan Abraham di, ");
INSERT INTO ifb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ha\"in an Dios ya ihapata' hinan odol'un dumalat nan inatmun agguymu inukuhan nan imbaluymun ay e'nong ay Ha\"in, ");
INSERT INTO ifb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ya alyo' an makulug ahan an wagaha' he\"a, ya idat'uy do'ol hi holagmun umatdah nan ado'ol nan bittuan ad daya unu nan panag hinan pingit di baybay. Ya dida ya hakuponda nan siudad di binuhulda. ");
INSERT INTO ifb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ya nan holagmuy dumalat hi awagahan nan tataguh tun luta ti dumalat nan a'un'unnudmuh nan inalina.” ");
INSERT INTO ifb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","At numbangngad da Abraham hidin wadan din duwan baalna ta didan amin an numbangngad ad Beersheba an nunhituwan Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ya palpaliwanda ya waday nangalin Abraham an hi aginan hi Nahor ya waluy imbaluyda ay ahawanan hi Milkah. ");
INSERT INTO ifb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Hay pangpangullu ya hi Uz, ya otob hi Buz, ya atluh Kemuel (an ad holag ay Aram). ");
INSERT INTO ifb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ya unda goh mawada nan udum an da Kesed ay Hazo, ya hi Pildash, ya hi Jidlaph, ya hi Bethuel ");
INSERT INTO ifb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(an hi aman Rebekah). Danen walun linala'i ya diday holag da Milkah ay Nahor an hi agin Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ya wadada goh di udumnah holag Nahor hinan oha goh an ahawanan hi Reumah. Hay ngadan hana nan imbabaluyna ya da Tebah, ya hi Gaham, ya hi Tahash, ya hi Maakah. ");
INSERT INTO ifb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Hi Sarah ya hinggahut ya han duwampulu ta pituy tawona ");
INSERT INTO ifb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ya un matoy hi awadandad Kiriath Arba (unu ad Hebron) hidid Canaan, at binalun Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ya tinaynan Abraham heden natoy an ahawanan hi Sarah ta immuy hinan tatagun holag Heth, ");
INSERT INTO ifb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ya ni'hapit ay didan inalinay, “Ha\"in ya unna' bunag hitu, at mi'id di ay'u pangilubu'an hinan ahawa' an natoy. At mannig ayu ni' ah la'uwa' hi luta ta pangilubu'a' hinan ahawa'.” ");
INSERT INTO ifb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ya alyonday, ");
INSERT INTO ifb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Da'mi ya ibilang da'ah nabagtun ap'apu. At mabalin an piliom nan ma\"aphod an lubu'mi ta hiyay pangilubu'am ay ahawam ta bagim an mi'id ah mun'ad'adi.” ");
INSERT INTO ifb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","At nunluung hi Abraham an mange'gon ay dida, ");
INSERT INTO ifb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ya inalinay, “Gulat ta pohdonyu ay an ilubu\"uh ahawa' hitu at ibagayu ni' ay Ephron an hina' Zohar ");
INSERT INTO ifb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ta nan liyang hi ad Machpelah an neheggon hinan da'geng di payawnay pangilubu'a'. Mu alyonyun hiya ta ila'unan ha\"in, ya hinamadyu ta ibaagnay immannung an pola'na ta hiyay idat'u ta pangintitiganyun henen luta ya penla'u ta way punlubu'a'.” ");
INSERT INTO ifb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mu hi Ephron ya wah di an ni'yi'ibbun hinan way ubunan di tatagun neheggon hinan buhu'an eden babluy. Ya himmapit, ");
INSERT INTO ifb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ya inalinay, “Idat'un he\"ah den liyang an ta\"on un middum nan payaw, ya adi' ipapla' ay he\"a ta way pangilubu'am hinan ahawam. At ten dengngol tun i'ibba' di pangidata' ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ya nunluung hi Abraham hinan holag Heth, ");
INSERT INTO ifb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ya inalinan Ephron di, “Hay maphod ya polo'o' heden payaw, at abulutom ni' ta bayada' ya un mabalin an ay'u ilubu' hidi han ahawa'.” Heden inalina ya dengngol an amin nan tatagun na'amung hidi. ");
INSERT INTO ifb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","At inalin mah Ephron di, ");
INSERT INTO ifb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Hay pola' den payaw ya opat di gahut hi silver an pihhu. Mu undan henen pola' di ma'ahhapul? Ekaat ilubu' hidih ahawam!” ");
INSERT INTO ifb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ya inabulut Abraham heden inalin Ephron an opat di gahut an pihhun nipaddung di damotnah nan niyuldin an pumbayad hinan mala'uwan, at indatna, at tinnig nan tataguh nangngalan Ephron. ");
INSERT INTO ifb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","At lutan mahkay Abraham heden lutan Ephron ad Machpelah an niddum nan payaw an nedelloh hinan liyang, ya ta\"on nan nun'itanom hidi eden luta, ya neheggon hi ad Mamre hi appit di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ya an amin din wah di an holag Heth an nannig ya iniladan hi Abraham mahkay di ad lutan de. ");
INSERT INTO ifb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","At ayna inlubu' nan ahawanan hi Sarah ede han liyang ad Machpelah an neheggon ad Mamre (unu ad Hebron) hidih ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","At nan penla'nah nan holag Heth an liyang ya nan payaw ya bagin mahkay Abraham ta way pangilubu'ana. ");
INSERT INTO ifb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ya la'tot ya nala'ay hi Abraham. Ya an amin nan inatna ya winagahan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ya wa han hin'algaw ya inalin Abraham hinan mangipangpanguluh nan baalnay, “Ipahdum di ngamaymuh nan numbattanan di ulpu' ");
INSERT INTO ifb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ta ihapatam ay Apo Dios an nan mumpapto' ad abuniyan ya tun luta an he\"a ya bo'on hitud Canaan di pamto'am hinan ahawaon han imbaluy'u. ");
INSERT INTO ifb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hay mahapul ya umuy'ah nan babluy an nitungawa' ta nan tutulang'uy awitom hi ahawaon Isaac.” ");
INSERT INTO ifb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mu inalin den baal ay hiyay, “Oo, mu gulatna ta adi mi'yalih den babaih tu ya mabalin an mumbangngada' ta awito' hi Isaac ta iyuy'uh di?” ");
INSERT INTO ifb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ya inalin Abraham di, “Adi ahan mabalin hi unmu ibangngad han imbaluy'uh di. ");
INSERT INTO ifb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ti hi Apo Dios ad abuniyan di nangalih tayna' heden babluymin da ama ya nan tutulang'uh di ti intulagna an ipaboltanah ten lutan ha\"in ya nan holag'u. At mundenola' ti honogona nan anghelna ta hiyay bumadang ay he\"ah ayam, at madadawoh an waday awitom hi ahawaon han imbaluy'u. ");
INSERT INTO ifb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mu gulat ta heden babai ya adi mi'yalin he\"a ya ta\"on ya inunudmu nan inhapatam ay ha\"in. Mu hay mahapul ahan ya adim ibangngad an iyuy han imbaluy'uh di.” ");
INSERT INTO ifb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","At impahdun mah de han baal hi ulpun Abraham ta ihapatanay pangunudanah nan inalin Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","At idadaana mah di himpuluh nan kamilun Abraham ta way pungkalgaonah nan numbino'ob'on an mun'aphod an gina'un Abraham. Ya unat goh nalpah an nidadaan ya impadehdan mumbaat an umuy hi ad Aram Naharaim hinan babluy ad Mesopotamia hinan babluy hi ad Nahor. ");
INSERT INTO ifb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ya unat goh dimmatongdan den bataan di bubun an hogbon at impadinongda nan kamilu ta mun'eblayda an numpunhippida. Mu wan na'uy an mapuyaw at gutud di umalian nan binabain humagub. ");
INSERT INTO ifb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","At nunluwalun Apo Dios an inalinay, “He\"a Apo Dios an nan dayawon Abraham an ad baal ay ha\"in ya badangana' ni' ta mipa'annung nan dimmalat hi immalia' hitu, ya ipattigmuy homo'muh nan ad baal ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ti wah tua' eten neheggon hitun bubun ad ugwan, ya umalida nan binabain malpuh nan babluy an humagub eten hogbon. ");
INSERT INTO ifb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","At hay ibaga' hi pangimmatuna' hinan babain pohdom hi ahawaon Isaac ya nan pumbaga' hi inumo' hinan hinagubna. Ta ipa'inumna ay ya ipa'inumana goh tun kamilu ya hiyanan pohdom, ya hiya goh di panginnilaa' hinan homo'muh nan ad baal ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ya agguyna impada'puh heden luwaluna ya nidatong hi Rebekah an inya'agtunay pannuman hi ihagubna. Ya hay ad imbaluy ay hiya ya hi Bethuel an holag da Milkah ay Nahor an hi agin Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Hi Rebekah ya ma\"aphod an balahang an mid ah nangelo' ay hiya. Ya inyuyna inhagub din pannuman hinan bubun, ya inyagtuna ta umeet. ");
INSERT INTO ifb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","At immuy din baal an ay mi'dammu, ya inalinay, “Iyalim ni' ta uminuma'.” ");
INSERT INTO ifb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ya inalinay, “Kan oo.” At ohpon Rebekah din pannuman ta uminum. ");
INSERT INTO ifb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ya unat goh nalpah an imminum ya inalin Rebekah ay hiyay, “Awni ta ay'u pa'inuman nan kamilum ta ma'aan di inuwawda!” ");
INSERT INTO ifb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","At immuy, ya inhiitna din danum an hinagubnah nan inyammadan pun'inuman di kamilu, ya numbangngad goh hinan bubun an humagub ta nangamung unda na'inuman an amin din kamilu. ");
INSERT INTO ifb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ya nan baal ya un didindinong ta titiggonah un hiya nan pohdon Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ya unat goh nalpah an impa'inumanan amin din kamilu ya inukat den baal din balitu' an hingat an mapla'an ya nan duwan balitu' an ganeleng, ya inhu'lubnah ngamay Rebekah, ya impihingatna din hingat. ");
INSERT INTO ifb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ya inalinan hiyay, “Hay ngadan mah amam? Ta un ay ni' mabalin ya ta umiyan amih ad ugwan an nahdom ay daten i'ibba' an linala'ih abung amam.” ");
INSERT INTO ifb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ya inalinay, “Hay ngadan ama ya hi Bethuel an holag da Nahor ay Milkah. ");
INSERT INTO ifb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ya hay umiyananyu ay ya mabalin an umuy tu'uh abungmi ti hidi ya do'ol di dagamih onon nan kamilu, ya ihna goh di olo'anyu.” ");
INSERT INTO ifb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","At heden baal ya nunluung ta dayawonah Apo Dios ");
INSERT INTO ifb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","an inalinay, “Munyamana' ay He\"a, Apo Dios an nan dayawon Abraham an ad baal ay ha\"in, hi nangipattigam hinan homo'mun hiya ti nipa'annung din inalim ay hiya! Ya munyamana' goh ta impangulua' ay He\"ah nan wadan nan tutulangna!” ");
INSERT INTO ifb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","At nunnaudon Rebekah an immuy hi abungda ta ayna ihudhud ay inana hadi nan na'at. ");
INSERT INTO ifb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Hi Rebekah ya wada han aginan lala'in hay ngadana ya hi Laban. Ya unat goh tinnigna din hingat ya ganeleng an nihu'lub hi ngamay Rebekah ya dengngolna goh nan inulgud Rebekah ya nunnaudonan limmahun, ya timmagtag an immuy hinan way bubun an hogbon. Ya unat goh dimmatong ya tinnigna an wah din timmata'dog heden baal Abraham hinan way kamiluna. ");
INSERT INTO ifb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ya inalinan hiyay, “He\"an iba an winagahan Apo Dios ya anaad ta un'a tumata'dog hitu? Ma'a ta umuytah abungmi ti wah di nan nidadaan hi ihinan nan kamilu, ya wada goh di olo'anyu.” At mitnudda mah ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ya unat goh nidatongdah abungda ya nun'aan Laban din nun'itakay hinan kamilu, ya pinangana dida. Ya inyuyna nan danum hinan baal Abraham ya nan ni'yibbana ta pangihudah hu'ida. ");
INSERT INTO ifb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ya unat goh wan nidadaan di ma'an ya inalin din baal di, “Adia' ni' mangan ta awni ta ulgudo' nan gapunah immalia' hitu.” Ya inalin Laban di, “Oot aga ta ite\"am an mangulgud.” ");
INSERT INTO ifb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","At inalinay, “Ha\"in di baal Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Hi Apo Dios ya nidugah di wagahnah nan ad baal ay ha\"in ti impa'adangyana. Ti ad ugwan ya do'ol di kalniluna, ya gandengna, ya bakana, ya dongkina. Ya do'ol goh di pihhuna, ya balitu'na, ya hay baalnan tagalanan binabai ya linala'i. ");
INSERT INTO ifb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ya hi ahawanan hi Sarah ya na'in'inna ya un mawada han imbaluynan lala'i, at hiyay nangipaboltanan nan ad baal ay ha\"in an amin hinan inadangyana. ");
INSERT INTO ifb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ya nunhapataona' an mahapul an bo'on nan binabain iCanaan an ni'hituwanah di pamto'a' hi ahawan han imbaluynan hi Isaac ");
INSERT INTO ifb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ta da'yun tulangnan wah tu. ");
INSERT INTO ifb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mu imbaga' ay hiyay, Mu gulat ta adi mitnud ya hay ato' mah? ");
INSERT INTO ifb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mu inalinay, Mi'yali ti nan nabagtun Dios an unudo' ya honogona nan anghelna ta mitnud ay he\"a, at adi mibahhaw an waday awitom hi malpuh holag ama ta hiyay ahawaon han imbaluy'u. ");
INSERT INTO ifb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","At atom nan inali' ta un ay adi pi'yalion nan tulang'u nan babain pento'mu, ya ta\"omman mu inatmu nan inhapatam ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","At hiyaat un din dimmatnga' hinan bubun an hogbon ad uwanindi ya nunluwalua' an inali' di, He\"a Apo Dios an nan dayawon Abraham an ad baal ay ha\"in ya badangana' ni' ta ma'at an amin nan dimmalat hi immalia' hitu. ");
INSERT INTO ifb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ya wah tua' an tumata'dog hitun way hogbon, ya wada ni' ah balahang an umalin humagub ta mumbagaa' hi inumo' hinan hinagubna ");
INSERT INTO ifb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ta inalina ay di uminuma' ya pa'inumana goh nan kamilu at ma'innila an hiyay pohdom Apo Dios hi ahawaon nan imbaluy nan ad baal ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ya agguy'u impada'puh nan luwalu' ya wadaat goh hi Rebekah an inya'agtunay pannuman an ihagubna. Ya unat goh nalpah an inhagubna ya inali' ay hiyay, Uminuma' ni' hinan hinagubmu. ");
INSERT INTO ifb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ya ay manghop hinan pannuman ya inalinay, Aga uminum'a ya un'u ay ipa'inum nan kamilu. ");
INSERT INTO ifb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","At mahmaha' di ngadan amana, ya inalinay, Hi Bethuel an imbaluy da Nahor ay Milkah. At inayun'u mah an ipihingat ay hiya nan hingat, ya impihu'lub'u goh nan ganeleng hi ngamayna. ");
INSERT INTO ifb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ya nunluunga' ta dayawo' nan Dios Abraham an ad baal ay ha\"in. Ti ongol di punyamana' hi nangipanguluanan ha\"in ta indatonga' ay da'yun tulang nan ad baal ay ha\"in an hi Abraham ta pento\"u nan pohdonah ipa'ahawah nan imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","At ad ugwan ya ibagayuh unyu abuluton nan inalin nan ad baal ay ha\"in, mu adya adiyu ya inaliyu ta hiyay alyo' ay hiya.” ");
INSERT INTO ifb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ya inalin da Laban ay Bethuel di, “Hene ya na'i'innilan hiyay pohdon Apo Dios hi ma'at! At undan da'miy mangibahhaw? ");
INSERT INTO ifb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","At ta\"on ya inawitmuh Rebekah ta ahawaon nan imbaluy nan ad baal ay he\"a ta miyunnud hinan pohdon Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ya unat goh dengngol nan baal Abraham heden inalida ya nunluung ta dayawonah Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","At ayna mahkay ukaton nan inta'ina an balitu' ya pihhu, ya nan mun'aphod an lubung ya indatnan Rebekah. Ya indatana goh hi aginan hi Laban ya hi inanah nan udumnan gina'un mapla'an. ");
INSERT INTO ifb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ya unat nalpah hana ya unda mahkay mangan an amin hinan ni'yibbanan linala'i, at umiyandah di. Ya unat goh bimmangondah din nabiggat hi helhelong ya inalin den baal di, “Okod ayu mah ta mumbangngad ami.” ");
INSERT INTO ifb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mu inalin da Laban an hin'inay, “Awni mah ni' ta maluh di himpuluy algaw hi ihinan Rebekah ay da'mi ya un da'mi taynan!” ");
INSERT INTO ifb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ya inalin nan baal di, “Adi da'mi pala'udon ti maphod ta impa'annung Apo Dios di aat nan inalia' hitu, at mumbangngada' hinan ad baal ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ya alyonday, “Awni mah ta ayaganmi han unga ta mapto' di alyona.” ");
INSERT INTO ifb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","At inayaganda mah hi Rebekah, ya inalidan hiyay, “At pohdom an mi'yuy eten lala'i?” Ya inalinay, “Oo, pohdo'.” ");
INSERT INTO ifb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","At inyabulutda mah an mi'yuy hinan baal ya nan ni'yibbana, at pi'yoyonda din tagalan nanalimun ay hiyah nete\"ah a'ung'ungngana. ");
INSERT INTO ifb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","At wagahandah Rebekah an alyonday, “Adaogna ni' ta munholag'a ta he\"ay hi inan an amin di do'ol ahan an tatagu! Ya maphod goh hi un nan holagmu ya mabi'ahda ta amehondan amin nan mi'buhul ay dida!” ");
INSERT INTO ifb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ya wan nalpah nan nunhahapitanda ya umuy mahkay mitakay da Rebekah ya nan tagalanah nan kamilu ta mi'yuydah nan baal Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hi Isaac an nunhituh ad Negev ya immalin nalpuh ad Beer Lahai Roi. ");
INSERT INTO ifb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ya unat goh napuyaw ya pimmitaw ta umuy munle'le'od hinan payaw, ya inamangna nan nabulog an kamilu. ");
INSERT INTO ifb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ya unat goh tinnig Rebekah hi Isaac ya limmahun hinan nuntakayana, ");
INSERT INTO ifb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ya inalinah nan baal Abraham di, “Ngadan de han taguh nan way payaw an umalin manamun ditu'u?” Ya inalinay, “Hiyah de imbaluy nan ad baal ay ha\"in.” At innal mah Rebekah nan veil, ya hinophopanay uluna. ");
INSERT INTO ifb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ya unat goh nundittumda ya inulgud nan baal an amin nan na'at. ");
INSERT INTO ifb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","At inawit mah Isaac hi Rebekah ta iyuynah tuldan abung inanan hi Sarah, at nun'ahawada. Ya penpenhod Isaac hiya, ya hiyay pinumhodan di punnomnomanah natayan inana. ");
INSERT INTO ifb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Hi Abraham ya numbentan hinan ohan babain hay ngadana ya hi Keturah. ");
INSERT INTO ifb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ya nunholagda ta da Zimram, ya hi Jokshan, ya hi Medan, ya hi Midian, ya hi Ishbak, ya hi Shuah. ");
INSERT INTO ifb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ya hi Jokshan ya nunholag ta da Sheba ay Dedan. Ya nunholag hi Dedan ta da Ashur ay Letush, ya hi Leum. ");
INSERT INTO ifb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ya hay holag Midian ya da Ephah ay Epher, ya hi Hanok, ya hi Abida, ya hi Eldaah. Didanay holag Keturah. ");
INSERT INTO ifb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ya impaboltan Abraham an amin nan odona ay Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mu nan linala'in benentana ya un hini\"itang di indatnah homo'nan dida, ya hennagna dida ta immuydah nan adagwin babluy an potto' di buhu'an di algaw ta bataanandah Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ya hay uyap di tawon hi ni'taguan Abraham ya hinggahut ta han napitu ta lema. ");
INSERT INTO ifb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ya hi Abraham ya na'alla'ay ya un matoy, at immuy hi wadan din o'ommodna. ");
INSERT INTO ifb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ya da Isaac ay Ishmael di immuy nangilubu' hinan liyang hi ad Machpelah hinan way payaw Ephron an hina' Zohar an holag Heth an neheggon ad Mamre. ");
INSERT INTO ifb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ya heden payaw an ngininaan Abraham hinan holag Heth ya hiyay nilubu'andan himbaluy. ");
INSERT INTO ifb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ya unat goh nalpah an natoy hi Abraham ya winagahan Apo Dios hi Isaac an imbaluynan nunhituh nan neheggon ad Beer Lahai Roi. ");
INSERT INTO ifb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ya didatuy napatad an holag Ishmael an imbaluy da Abraham ay Hagar an i'Egypt an tagalan Sarah, ");
INSERT INTO ifb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ya hiyatuy ngadanda: hay pangpangullu ya hi Nebaioth, ya un hi Kedar, ya un hi Adbeel, ya un hi Mibsam, ");
INSERT INTO ifb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ya un hi Misma ya un hi Dumah, ya un hi Massa, ");
INSERT INTO ifb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ya un hi Hadad, ya un hi Tema, ya un hi Jetur, ya un hi Naphish, ya un hi Kedemah. ");
INSERT INTO ifb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Danen holag Ishmael ya ningadan di ngadandah nan himpulu ta duwan babluy an nihinanda. ");
INSERT INTO ifb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ya nuntawon hi Ishmael hi hinggahut ta han tulumpulu ta pitu ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ya hay nunhituwan nan holagna ya nan numbattanan di ad Havilah ya ad Shur an niyappit hinan igad ad Egypt an nan owon an umuy ad Assyria ta miyadagwidah nan udumnan a'agida ti gunda mi'hohongngel. ");
INSERT INTO ifb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hiyah te ulgud hi aat di nunholagan Isaac an hina' Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Hi Isaac ya nuntawon hi napat ya unda mun'ahawa ay Rebekah. Hi Rebekah ya hi agin Laban an dana' Bethuel an i'Aram hi ad Mesopotamia. ");
INSERT INTO ifb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Mu bahig hi Rebekah, at nan ahawanan hi Isaac ya nunluwalun Apo Dios ta mun'adaw hi imbaluyna. At dengngol Apo Dios, ya nawadaan hi Rebekah. ");
INSERT INTO ifb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mu hiya ya nunduppel nan inhabina an gunda mun'awit hi putun inada. At inalin Rebekah di, “Anaad ta way umat hituh ma'ma'at ay ha\"in?” At ni'hapit hi Rebekah ay Apo Dios ta ibaganan Hiyay aatna. ");
INSERT INTO ifb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ya inalin Apo Dios ay hiyay, “Nan inhabim ya nunduppel, ya manu ay umatdah na ti nan holagda ya mumbuhuldah awni. Mu mabi'bi'ah nan oha ya un nan agina, at nan pangpangullu ya hiyay babbaalon nan udidian.” ");
INSERT INTO ifb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ya unat goh nagtud di puntungawana ya duway intungawnan lala'i. ");
INSERT INTO ifb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ya nan nahhun an bimmuhu' ya mumbobollah di aatna, ya nadutdutan, at nginadnanda ta hi Esau. ");
INSERT INTO ifb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ya netob goh heden agina an bimmuhu' an eyedonah mu'ud Esau, at nginadnanda ta hi Jacob. Ya nanom di tawon Isaac hidin nitungawan nan imbabaluyda. ");
INSERT INTO ifb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ya unat goh immilogda ya nala'eng hi Esau an manganup ti emmenghah inalahan hi gunna umayan. Mu hi Jacob ya ma'ma'ullay, at hay abungday nihihinnana. ");
INSERT INTO ifb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ya pohpohdon Isaac hi Esau ti dumalat nan anuponan iyanamutna, mu hi Rebekah ya hi Jacob di pohpohdona. ");
INSERT INTO ifb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ya wa han ohan algaw hidin nunhaangon Jacob hi dotag ya immeet hi Esau an nalpuh inalahan, ya hiya ya ma'ahhinaang. ");
INSERT INTO ifb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ya alyon Esau ay Jacob di, “Mabalin ay ni' ya ibanawmuh nen inhaangmu an mumbolah ta mangana' ti ten ma'ahhinaanga'!” (Ya hiyah te dimmalat hi nungngadnandan Esau ta hi Edom ti mumbolah di odowona.) ");
INSERT INTO ifb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ya tembal Jacob an inalinay, “Idat'un he\"ah unmu ihukat ay ha\"in nan biyangmun pangpangullu.” ");
INSERT INTO ifb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ya inalin Esau di, “Kan oo, ya indat'u ta bagim, ya inyalim han inhaangmu. Undan way hulbin nen biyang'u ti ten matoya' hi hinaang'u?” ");
INSERT INTO ifb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ya inalin Jacob di, “Mahapul an ihapatam hi mahhun an idatmud ugwan nan biyangmu ta bagi'!” At inhapatan Esau, at indatna nan biyangnan Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ya indat mahkay Jacob di tinapay ya nan mihda ta nangan ya imminum. Ya unat goh nalpah an nangan ya immuy hinan pohdonan umayan. Ya henen inatnay nangipa'innila an adina nomnomon nan biyangnan pangpangullu. ");
INSERT INTO ifb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ya wada goh di batel eden babluy an nehnod hi batel hidin atagun Abraham. At hi Isaac ya immuy ay Abimelek an alin di iPhilistia hi ad Gerar. ");
INSERT INTO ifb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ya numpa'ilah Apo Dios ay Isaac, ya inalinay, “Adi'a umuy ad Egypt ta mihihinna'ah nan babluy an alyo' an ihinam. ");
INSERT INTO ifb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mihina'an ten babluy, at wagwadaa' an mungwagah ay he\"a ti he\"a ya nan holagmuy pangidata' hi an amin eten luta ta ipa'annung'u nan intulag'un amam an hi Abraham. ");
INSERT INTO ifb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ya do'lo' ahan di holagmun umat hi bilang di bittuan ad daya ta diday pangidata' eten luta. Ya dumalat nan holagmu ya mawagahan nan tataguh abablubabluy ");
INSERT INTO ifb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ti hi Abraham ya inunudna nan Tugun'u ya Uldin'u.” ");
INSERT INTO ifb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","At hi Isaac ya nihinad Gerar. ");
INSERT INTO ifb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ya nan linala'in den babluy ya minahmahanday ni'atana ay Rebekah, ya inalinay, “Hi agi'.” Ti tuma'ot an mangalih un hiyah ahawana ti alyonah nomnomnay, “Mid mapto' ya patayona' ay dida ta way atondan mangngal ay Rebekah ti ma\"aphod an babai!” ");
INSERT INTO ifb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Hidin nihihinnandan den babluy ya wada han ohan algaw ya hi Abimelek an alid Philistia ya indungawnah nan tawa, ya inamangnah Isaac an mun'aw'agwalandan Rebekah an ahawana. ");
INSERT INTO ifb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ya impa'ayag Abimelek hi Isaac, ya inalinay, “Henen babai ya immannung an hiyay ahawam! Ya anaad ta alyom un hiyah agim?” Ya inalin Isaac ay hiyay, “Oo, ti tuma'ota' ti alyo' un waday mamatoy ay ha\"in hi un'u alyon di ahawa'.” ");
INSERT INTO ifb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ya inalin Abimelek ay hiyay, “Ngadan te han inatmun da'mi? Gulat ta way ne'yelo' hi ohah tagu' hinan ahawam at he\"ay dimmalat hi numbaholanmi!” ");
INSERT INTO ifb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","At inalin Abimelek hinan tatagunay, “Nan mangat hi nappuhin nen tagu unu hi ahawana ya mapatoy.” ");
INSERT INTO ifb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ya hay inat Isaac ya nunhabal eden babluy. At heden tawon ya winagahan Apo Dios nan inhabalna ta pinumhod an dimmo'ol. ");
INSERT INTO ifb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ya gun ma'ud'udman di inadangyana, ya la'tot ya numbalin hi pa\"adangyan. ");
INSERT INTO ifb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ya dimmo'ol di animalna ya nan baalna, at inamhan nan iPhilistia, ");
INSERT INTO ifb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","at immuyda nuntabab an amin di bubun an linhu'an amanan hi Abraham hidin ataguna. ");
INSERT INTO ifb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ya inalin Abimelek ay Isaac di, “Makak'ah tun babluymi ti ten un at goh he\"ay ong'ongngol di abalinana ya un da'mi!” ");
INSERT INTO ifb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","At nakak da Isaac ta immuydah nan nundotal ad Gerar, at hidiy nihinanda. ");
INSERT INTO ifb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","At immuy linhu'an Isaac nan obob an linhu'an da Abraham hidin amataguna an din tinabab di iPhilistia hidin natayan Abraham, ya impingadana nan ngadan an din impingadan amana. ");
INSERT INTO ifb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Hidin awadandad Gerar ya nunluhu' nan baal Isaac hi bubun, ya waday inah'upandah obob. ");
INSERT INTO ifb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mu nan mumpahpahtul an nunhituh ad Gerar ya ni'hohongngeldah nan pumpahpahtulon Isaac, ya alyonday, “Da'miy ad bagin nen obob!” At nginadnan Isaac nan bubun ta ad Esek. ");
INSERT INTO ifb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","At nunluhu' nan pumpahpahtulon Isaac hi nob'on an bubun, mu umat hidin hopapna an ni'bohhol nan mumpahpahtul an iGerar. At nginadnan Isaac nan bubun ta ad Sitnah. ");
INSERT INTO ifb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","At nahligda ta immuyda nunluhu' hi nob'on goh an bubun, at mi'id mahkay di al'ali. At nginadnan Isaac heden bubun ta ad Rehoboth ti inalinay, “Ad ugwan ya indatan ditu'un Apo Dios hi punhituwan tu'u ta umda ahan, at hituy pumhodan tu'u!” ");
INSERT INTO ifb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","At nakak ta numbotandan immuy ad Beersheba. ");
INSERT INTO ifb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ya unat goh nahdom ya numpa'ilah Apo Dios ay hiya, ya inalinay, “Ha\"in di Dios Abraham an hi amam. Adi'a tuma'ot ti wadaa' ay he\"a. At wagaha' he\"a, ya do'lo' ahan di holagmun dumalat hi Abraham an baal'u.” ");
INSERT INTO ifb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ya inyamman Isaac di pun'onngan ta nundayaw ay Apo Dios, at hidiy nun'ammaandah abung an tulda ta nunhituwanda, ya nan baalna ya nunluhu'dah bubun. ");
INSERT INTO ifb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nalpud Gerar da Abimelek, ya nan ibbanan hi Ahuzzath an muntugun ay hiya, ya hi Phicol an ap'apun di tindaluna ta umuyda tigon hi Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ya inalin Isaac ay diday, “Anaad ta umali ayuh tun mannig ay ha\"in? Inabohlana' ay da'yu, at pinakaka' hinan numbabluyanyu!” ");
INSERT INTO ifb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ya inaliday, “Oo, inilami an hi Apo Dios di wadan he\"a! At hiyanan penhodmin mi'hapit ay he\"a ta way aton tu'un ");
INSERT INTO ifb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","adi mumbobohhol ti mi'id inatmih nappuhin he\"a, at mi'id ni' goh di atom hi nappuhin da'mi. At ten ad ugwan ya gun da'a wagahan ay Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","At indadaanan Isaac didah do'ol an ma'an ya ma'inum ta nanganda. ");
INSERT INTO ifb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ya unat goh nabiggat ya an amindan hinohha ya numpunhapatada ta ipa'annungda nan hinahapitda. Ya unat goh nalpah ya mundenol mahkay da Abimelek ya nan i'ibbanan umanamut hi abungda. ");
INSERT INTO ifb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Heden algaw ya numbangngad nan baal Isaac, at inulgudda nan aat di bubun an linhu'anda. Ya inaliday, “Inah'upanmi mahkay di danum hinan linhu'anmin obob!” ");
INSERT INTO ifb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","At nginadnana ta ad Shibah ti hiyay na'alan nan ngadan den babluy an ad Beersheba. ");
INSERT INTO ifb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ya unat goh nuntawon hi Esau hi napat ya inahawana han duwan binabain holag Heth an hay ngadan di oha ya hi Judith an imbaluy Beeri, ya nan miyadwan ahawana ya hi Basemath an imbaluy Elon. ");
INSERT INTO ifb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mu hanan inahawan Esau ya diday dimmalat hi punlungdayaan da Isaac ay Rebekah. ");
INSERT INTO ifb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ya unat goh palpaliwan ya na'alla'ay hi Isaac, at adi mittig di matana. At inayagana han pangpangullun imbaluynan hi Esau, ya inalinan hiyay, “Imbaluy'u, hay wadam?” Ya tembal Esau an inalinay, “Wah tu'a'.” ");
INSERT INTO ifb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ya inalinay, “Ad ugwan an ten nala'aya' an hi amam, at agguy'u inilay algaw hi ataya'. ");
INSERT INTO ifb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ya pohdo' an umuy'a manganup, at alam nan panam, ya immuy'a ta wa ay di anupam ya inyanamutmu, ");
INSERT INTO ifb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ya ihaangmu nan mapolhat an pohdo' hi mihda ta malutu ay ya inyalim ta mangana'. Ya hiyah ne atom ya un'u wagahan he\"a ti agguy'u inilay ataya'.” ");
INSERT INTO ifb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ya hi Rebekah ya dengngolnah den inalin Isaac ay Esau. At unat goh nakak hi Esau an immuy nanganup hi inalahan ");
INSERT INTO ifb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ya immuy an ni'hapit ay Jacob, ya inalinan hiyay, “Imbaluy'u, dengngol'un hennag amam hi Esau an inalinay, ");
INSERT INTO ifb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Umuy anu manganup, ya inyanamutna ta ihaangna, ya impihdanan hiya, ta malpah ay anun nangan ya winagahana hiyah nan ngadan Apo Dios ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","At hay atom ad ugwan ya unudom nan alyo', ");
INSERT INTO ifb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","at umuy'ad ugwan hinan wadan di nalammungan di gandeng, ya innalmuy duwah mun'ataba, ya inyalim ta paltionta ta nan pohdon amam an mapolhat di hiyay ato' an mangihaang. ");
INSERT INTO ifb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ya inyuymun amam ta onona, ta malpah ay ya he\"ay wagahana ya un matoy!” ");
INSERT INTO ifb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ya inalin Jacob ay inanay, “Oo, mu nadutdutan hi Esau, mu ha\"in ya mi'id, at ma'immatunan! ");
INSERT INTO ifb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","At hiya damdaman dapoona' ay ama, ya adi munggonehal di odol'u, at innilaonan un'u balbaliyan hiya! At bo'on wagah di midat ti un hay a'iduta'!” ");
INSERT INTO ifb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ya tembal inana, ya alyonan hiyay, “Adim nomnomon hene. Ya ta\"ongkay un ha\"in di ma'idutan, at umuy'aat ta eka alan nan gandeng.” ");
INSERT INTO ifb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","At immuy hi Jacob an nangngal hinan inalin inana, ya inyanamutna ta inhaang Rebekah nan pohdon Isaac an mumpolhat. ");
INSERT INTO ifb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ya unat goh nalpah ya immuy innal Rebekah din ma\"aphod an lubung Esau an impo\"oynah nan abungda ta impilubungnan Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ya impihu'lubnah ngamay Jacob nan up'up di gandeng, ya immat goh hinan bagangna. ");
INSERT INTO ifb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ya indatnan Jacob din tinapay ya heden mapolhat an mihda. ");
INSERT INTO ifb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ya inyuynan amana, ya inalinay, “Ama.” Ya inalin amanay, “Hay ngadanmu?” ");
INSERT INTO ifb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ya inalin Jacob di, “Ha\"in hi Esau an pangpangullun imbaluymu. Ya ten inat'un amin nan inalim an ato', at bumangon'a ta mangan'a ti tayan inyali' tun ma'an ta mangan'ah mahhun. Ta malpah ay ya winagahana' ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ya inalin amanay, “Hay inatmu, la'ay, ta ag'aga udot ya nun'iyalim di inanupam?” Ya inalinay, “Manu ay ya hi Apo Dios di namadang ay ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ya inalin Isaac ay Jacob di, “At meheggon'an ha\"in ta dapoo' he\"ah un he\"ah Esau unu bo'on.” ");
INSERT INTO ifb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","At neheggon hi Jacob, ya inap'apluh amanay odolna. Ya inalinay, “Hay alim ya alin Jacob, mu hay dutdut di ngamaymu ya dutdut di ngamay Esau!” ");
INSERT INTO ifb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ti manu ay adina immatunan ya nan ngamay Jacob ya umat hi ngamay Esau, at magadyuh an wagahana. ");
INSERT INTO ifb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mu binagana goh hiyan inalinay, “An immannung an he\"ah Esau?” Ya inalinay, “Oo, ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ya inalin Isaac di, “Iyalim nan inhaangmu ta mangana' ta malpah ay ya winagaha' he\"a.” Ya induul Jacob nan ma'an ya bayah, at nangan, ya imminum. ");
INSERT INTO ifb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ya inalin Isaac di, “Meheggon'a ta ungnguona'.” ");
INSERT INTO ifb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","At neheggon hi Jacob ta inungngunah amana, ya hinunghungna nan lubung Esau, at winagahana hiyan inalinay, “Hay panunghung'un ten imbaluy'u ya umat hi hunghung nan payaw an winagahan Apo Dios! ");
INSERT INTO ifb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ya ipa'alin ni' Apo Dios nan dulnun malpud abuniyan ta ipalumongna nan payawmu, ya wagahan da'a ta pumhod di ihabalmu ta dumo'ol di ma'an ya ma'inum! ");
INSERT INTO ifb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya an amin di tatagu ya mumbalindah baalmu ta he\"ay e'gonanda, ya ta\"on nan tutulangmu ya nan holag inam ya he\"ay ibilangdah apuda. Ya an aminda nan mangidut ay he\"a ya ma'idutanda goh, mu nan mungwagah ay he\"a ya mawagahanda goh.” ");
INSERT INTO ifb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ya unat goh nalpah an winagahan Isaac hi Jacob ya itadunan makak. Ya heden akakana ya dimmatong hi Esau an nalpuh nan inalahan an ay nanganup. ");
INSERT INTO ifb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ya inhaangna nan inanupanah nan punhaang an pohpohdon amana. Ya unat goh nalutu ya inyuynan amana, ya inalinay, “Ama, bumangon'a ta ihdam heten dotag an inyali' ya unna' wagahan!” ");
INSERT INTO ifb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ya inalin amanay, “Hay ngadanmu?” Ya tembalnan inalinay, “Ha\"in kan hi Esau an pangpangullun imbaluymu!” ");
INSERT INTO ifb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ya wimmogwog hi Isaac, ya inalinay, “Hay ngadan mah din nangiyalin den dotag an inihda' ad uwanindi ti hiyay winagaha', at hiyay nawagahan hi enggana?” ");
INSERT INTO ifb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ya unat goh dengngol Esau nan inalin amana ya enlotnan kimmila, ya munha'it hi punle'nana, ya inalinay, “Ama, ta\"on ni' ahan ya winagahana'!” ");
INSERT INTO ifb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ya inalin Isaac di, “Un nangihtima han ibam ti unna' binaliyan ta omodnay unna penloh di wagah an midat ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ya inalin Esau di, “Pidwana mah ahan hete hi nunlayahanan ha\"in! Un hiya tuwaliat un hi Jacob di ngadana ti nen un mammamloh hi biyang'un pangpangullu? Ya ten ad ugwan ya inyangunuhnan polhon tun wagah aman ha\"in! At undan ahan mi'id na'angang hi iwagahmun ha\"in?” ");
INSERT INTO ifb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ya tembal Isaac an inalinay, “Imbaluy'u, mi'id mah ti han ibam di nabagbagtu ya un he\"a, at an amin di tutulangna ya diday mumbalin hi baalna, at indat'un hiya nan paguy ya bayah, at mi'id mah di idat'un he\"a ti nalpah!” ");
INSERT INTO ifb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ya inalin Esau ay amanay, “Undan ahan adi mabalin hi unna' pi'wagah ay he\"a, ama? Wagahana' ni' ahan!” Ya innayunan kumila. ");
INSERT INTO ifb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ya tembal amana, ya alyonan hiyay, “Nan lutan ihinam ya manghan an adi tummol di mihabal ya adi dumulnu. ");
INSERT INTO ifb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ya hay umabakam hinan pi'gubatam di hiyay pangngalam hi tanudmu, ya henen agim di mamaal ay he\"a, mu la'tot ya nginayam ta adi minaynayun di pamaalanan he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","At hiyah de dimmalat hi pamoholan Esau ay Jacob ti hay ninomnomnah atona ya patayonah Jacob hi un malpah an matoy hi amada. ");
INSERT INTO ifb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mu waday nangibaag ay Rebekah, at impa'ayagnah Jacob ta imbaagnah den ninomnom Esau. ");
INSERT INTO ifb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ya inalina goh di, “Imbaluy'u, unudom tun alyo' ta umuy'ad ugwan ay Laban an han agi' hidid Haran ");
INSERT INTO ifb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ta hidiy ihinam ta engganay un ma'uyah di bungot han agim! ");
INSERT INTO ifb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ya awni ta aliwana nan inatmun hiya ya un'u honogon di umalin mangawit ay he\"ah di. Ti undan maphod hi un ayu mundehhan an mami'id ay ha\"in eden ohay algaw?” ");
INSERT INTO ifb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","At hinimung Rebekah an immuy hinan awadan Isaac, ya inalinay, “Impahigaa' hinan iwah tu! At gulat ta han holag Heth an iCanaan goh di ahawaon Jacob at odolnah unna' matoy!” ");
INSERT INTO ifb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","At inayagan mah Isaac hi Jacob, ya winagahana, ya pinadanan inalinay, “Adi'a ahan mangahawah nan binabain iCanaan! ");
INSERT INTO ifb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hay atom ya mundadaan'a ta umuy'ah ad Paddan Aram hinan babluy hi ad Mesopotamia hi abung apum an hi Bethuel, ya umuy'a ay hidi ya nan ohah nan babain imbaluy ulitaom an hi Laban ahawaom. ");
INSERT INTO ifb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","At hi El-Shaddai an hi Apo Dios an abalinanan amin di logom ya wagahan da'a ni' ta dumo'ol di holagmu ta mumbalin'ah ommod di do'ol an tataguh tun luta. ");
INSERT INTO ifb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ya nan wagah Apo Dios ay Abraham ya mipa'annung ni' ay he\"a an ta\"on goh hinan holagmu ta da'yuy mamoltan eten lutan nihinam an mumbunag an indat Apo Dios ay Abraham.” ");
INSERT INTO ifb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","At wan nalpah an tinugun Isaac hi Jacob ya hennagnah Jacob ta immuy hi ad Paddan Aram an nihinan Laban an imbaluy Bethuel an i'Aram. Ya hi Laban ya hin'agidan Rebekah an hi inan da Jacob ay Esau. ");
INSERT INTO ifb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Wan nalpah hede ya inilan mahkay Esau an winagahan amanan hi Isaac hi Jacob, ya inilana goh an hennag Isaac hi Jacob ta immuy ad Paddan Aram ta hidiy pangahawaana ta bo'on nan iCanaan, ");
INSERT INTO ifb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ya inilana goh an inunud Jacob di inalin da amanan inana ta immuy hi ad Paddan Aram, ");
INSERT INTO ifb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","at na'awatana mahkay an adi ahan pohdon amadan hi Isaac nan inapuna an iCanaan. ");
INSERT INTO ifb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","At hay inat mah Esau ya immuy hi wadan Ishmael ta inahawanah Mahalath an agin Nebaioth an imbaluy damdama Ishmael an imbaluy Abraham, at na'udman mah di ahawana. ");
INSERT INTO ifb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ya nanakkak hi Jacob hi ad Beersheba ta immuy hi ad Haran, ");
INSERT INTO ifb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ya heden dimmatnganan lugal ya hiyay immiyanana ti nahdom. Ya hay nolo'ana ya innalnay batu ta impungana. ");
INSERT INTO ifb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ya heden nolo'ana ya nun'enap, ya tinnigna han toytoy an niho'gad eden lutan wadana, ya nitumu' ad abuniyan. Ya tinnignay a'anghel Apo Dios an mumbinangngadan an mange'wan den toytoy. ");
INSERT INTO ifb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ya hinan bagtun di toytoy ya tinnignah Apo Dios an timmata'dog. Ya inalinay, “Ha\"in hi Apo Dios an nan dayawon apum an hi Abraham ya hi amam an hi Isaac. At heten lutan awadam ya idat'un he\"a ya nan holagmu goh. ");
INSERT INTO ifb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ya hay holagmu ya umatdah ado'ol di hupu' an adi ma'yap, ya miwa'atdah tun alutaluta. Ya he\"a ya nan holagmuy dumalat hi awagahan an amin di tataguh tun alutaluta. ");
INSERT INTO ifb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","At Ha\"in ya wagwadaa' ay he\"a ta ibaliw'u he\"ah nan malgom an ayam, ya Ha\"in goh di mangibangngad ay he\"a eten babluy. Ya adi' he\"a inganuy ta engganay mipa'annung an amin daden inali' ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Wan nalpah heden enenap Jacob ya bimmangon, ya inalinay, “Makulug ahan an wadah Apo Dios eten nun'eblaya', mu agguy'u ahan inila!” ");
INSERT INTO ifb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ya ma'atta'ot hi Jacob an inalinay, “Ma\"aphod heten lugal an hiyay punhituwan Apo Dios an nan pantaw ad abuniyan!” ");
INSERT INTO ifb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ya unat goh nabiggat hi helhelong ya ag'agan bimmangon hi Jacob, at innalnah den batun impunganah nolo'ana ta hina\"adna ta panginomnomanan den na'at. At innalnay lana, ya inhiitnah nan batu ta numbalin hi me'gonan heden lugal. ");
INSERT INTO ifb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ya nginadnanah den luta ta ad Bethel an nan punhituwan Apo Dios. (Mu hay ngadan den babluy hidin hopapna ya ad Luz.) ");
INSERT INTO ifb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","At hi Jacob ya inhapatanan Apo Dios an inalinay, “Apo Dios, gulat ta inaynayunmun mimiddum ay ha\"in ta He\"ay mamaliw ay ha\"in hinan malgom an umaya', ya gulat goh ta idatmuy mahapul'un umat hi ono' ya lubung'u ");
INSERT INTO ifb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ta engganay pumbangngada' hi wadan ama an mi'id al'ali at He\"a ahan di Dios hi dayawo'! ");
INSERT INTO ifb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ya heten batun hina\"ad'uy panginomnoma' hinan tinnig'u, ya hituy adayawam, at an amin di idatmun ha\"in ya ipabangngad'uy miyapulun He\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ya hi Jacob ya intuluynan umuy hinan appit di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ya unna palpaliwan ya nidatong hinan abu\"ul an obob hi uminuman nan kalnilu, ya wah diday do'ol an kalnilun tulumpampun an nanallo'. Ya heden obob an abu\"ul ya waday ongol an batun niyalub hinan pantawna. ");
INSERT INTO ifb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ya awni ta ma'amungdan amin nan kalnilu ya un anon nan mumpahtul nan batun niyalub ta uminumdan amin. Ya wa ay ta nalpah an imminumda ya inyalubda goh nan batuh nan pantaw di abu\"ul. ");
INSERT INTO ifb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","At hi Jacob ya immuy an ni'hapit hinan mumpahtul an inalinay, “I'ibba', hay ngadan nan babluy an nalpuwanyu?” Ya alyonday, “Nalpu amih ad Haran.” ");
INSERT INTO ifb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ya inalina goh di, “At inilayuh Laban an hina' Nahor?” Ya alyonday, “Inilami.” ");
INSERT INTO ifb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ya inalinay, “Olom ni' ya mid al'alin hiya.” Ya alyonday, “Hiya ya mapmaphod an mid al'ali. At dayah Rachel an imbaluynan na'uy an initnudna nan kalniludan ipahtulna!” ");
INSERT INTO ifb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ya inalin goh Jacob di, “Ya ten ata'nang di algaw an bo'on gutudnah pangipahigupan hinan kalnilu ya anaad ta adiyu ipa'inuman dida ta ibangngadyu goh hinan pahtu?” ");
INSERT INTO ifb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ya alyonday, “Adi umat hinay atonmi! An awni ta umalidan amin nan kalnilu ya unmi anon nan batun niyalub ta uminumdan amin.” ");
INSERT INTO ifb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ya heden gun pi'hapitan Jacob ay dida ya nidatong hi Rachel an initnudna nan kalnilun ipahtulna. ");
INSERT INTO ifb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ya unat goh tinnig Jacob hi Rachel an do'ol di initnudnah kalnilun amanan hi Laban an hi ulitaon Jacob (ti hin'agida ay inana) ya immuy hinan abu\"ul, ya inulina nan niyalub an batu ta imminumda din kalnilu. ");
INSERT INTO ifb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Ya inulgudnan hiyan inalinay, “Ha\"in hi Jacob, ya ulitao' hi amam ti holaga' ay Rebekah an hi agina!” At inungngunah Rachel, ya kimmilah amlongna. At timmagtag hi Rachel an numbangngad ta ayna ibagan amana. ");
INSERT INTO ifb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ya unat goh dengngol Laban nan inulgud Rachel ya timmagtag ta umuyna damuwon han amuna'ona. Ya unat goh dinamuna ya len'omna hiya, ya inungnguna, ya initnudna ta umuydah abungda. At inulgud Jacob ay Laban an amin nan na'na'at. ");
INSERT INTO ifb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ya inalin Laban di, “Immannung an ay ha\"in damdamay ad imbaluy ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","At hi Jacob ya nihinan didah himbulan. Ya wa han ohay algaw ya inalin Laban ay Jacob di, “Adi maphod hi un dumalat ta amuna'o' he\"a ya un'u he\"a puntamuon ya ammuna! At hay maphod ya ibaagmuy pohdom hi idat'uh bo'laom.” ");
INSERT INTO ifb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ya hi Laban ya waday duwah binabaih imbabaluyna an hay ngadan nan pangpangullu ya hi Leah, ya nan udidian ya hi Rachel. ");
INSERT INTO ifb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ya hi Leah ya nakapuy di matana, mu hi Rachel ya ma'apgohan an madikit. ");
INSERT INTO ifb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ya hay popohdon Jacob ya hi Rachel. At inalinay, “Ta\"on hi unna' muntamuh pituy tawon ta badanga' he\"a mu ta iyabulutmun ahawao' hi Rachel!” ");
INSERT INTO ifb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ya tembal Laban an inalinay, “Od'odolnah un he\"ay pangipa'ahawaa' ay hiya ta bo'on hay udumna! At mihina'an da'mi.” ");
INSERT INTO ifb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","At intuluy mah Jacob an ni'tamun Laban hi pituy tawon. Mu heden nuntamuana ya paddungnay un nahnot di algaw an dumalat nan ongol an namhodnan Rachel. ");
INSERT INTO ifb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ya unat goh nagtud heden pituy tawon hi ni'tamuan Jacob ay Laban ya inalinay, “Nagtud di nuntamua', at mun'ahawa ami mahkay hinan imbaluymu.” ");
INSERT INTO ifb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","At idadaan Laban mah di pungkasalanda, at nun'ayaganan amin nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mu heden nahdom ya hay hennag Laban hi umuy me'yelo' ay Jacob ya hi Leah, at hi Leah mah di enelo' Jacob! ");
INSERT INTO ifb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ya hay pento' Laban hi bumadang ay Leah ya nan tagaladan hi Zilpah. ");
INSERT INTO ifb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mu heden nabiggat hi helhelong ya un innilaon Jacob an hi Leah nan enelo'na! At immuy ay Laban, ya inhingalnan inalinay, “Anaad ta umat hinay inatmu? Undan bo'on hi Rachel di imbo'la' hi nuntamua'? Ya unna' linayahan ay he\"a?” ");
INSERT INTO ifb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ya tembalnan inalinay, “Hay ugalih tu ya adi mabalin hi un mahhun nan udidian an malhin ya un hay pangpangullu. ");
INSERT INTO ifb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mu ta\"omman ya hodom ta malpah heten hindumingguan an kasal ya un'u iyabulut hi Rachel hi unmu ibo'la goh ay ha\"in hi pituy tawon.” ");
INSERT INTO ifb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","At inabulut Jacob ta engganah un nalpah heden hindumingguan ya un mahkay iyabulut Laban hi Rachel ta hiyay ahawaona goh. ");
INSERT INTO ifb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ya nan tagaladan hi Bilhah di inyabulut Laban ta hiyay tagalan Rachel. ");
INSERT INTO ifb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","At enelo' Jacob goh hi Rachel, ya hiyay pa'appohpohdona ya un hi Leah. At ituluynan muntamun Laban hi pituy tawon goh. ");
INSERT INTO ifb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ya hi Apo Dios ya ininnilanan manghan di pamhod Jacob ay Leah an adi umat hi namhodnan Rachel, at hi Leah mah di nunholagona ya mi'id ay Rachel. ");
INSERT INTO ifb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","At nunhabih Leah ta nuntungaw, ya lala'i, at nginadnana ta hi Reuben ti alyon Leah hi nomnomnay, “Maphod ta ininnilan Apo Dios nan aligata', at ad ugwan ya mabalin an pohdona' mahkay hinan ahawa'!” ");
INSERT INTO ifb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ya palpaliwan ya nunhabi goh ta nuntungaw, ya lala'i, at ngadnana goh ta hi Simeon ti alyonah nan nomnomnay, “Inilan Apo Dios an agguya' penhod, mu immannung an dengngolnay luwalu', at na'udman di holag'u!” ");
INSERT INTO ifb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ya palpaliwan ya nunhabi goh ta nuntungaw, ya lala'i, at ngadnana ta hi Levi. Ya inalinay, “Pohdona' nin mahkay ay ahawa' ti ten tuluda tun imbabaluymin linala'i!” ");
INSERT INTO ifb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ya palpaliwan ya nunhabi goh ta nuntungaw, ya lala'i, at ngadnana ta hi Judah. Ya inalinay, “Ad ugwan ya hi Apo Dios di ipabagtu'.” Ya nete\"an de ya adi mahkay munhabhabi. ");
INSERT INTO ifb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mu hi Rachel ya mi'id ah imbaluyna, at la'tot ya umamoh eden agina. Ya inalinan Jacob di, “Idatana' hi holag'u ti adim ay ya hiyay lummuh ataya'!” ");
INSERT INTO ifb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ya bimmungot hi Jacob ay Rachel, ya inalinay, “Undan ha\"in hi Apo Dios an mangiyadih punholagam? Hiyay adi mamhod hi punholagam!” ");
INSERT INTO ifb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ya inalin Rachel ay hiyay, “Wah tu nan tagala', at hiyay eka elo' ta wada ay di imbaluyyu ya ta imbaluyta ta hiyay alpuwan di holag'u.” ");
INSERT INTO ifb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","At inyabulutna ta ay ne'yelo' hi Jacob hinan tagalanan hi Bilhah. ");
INSERT INTO ifb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ya palpaliwan ya nawadaan hi Bilhah ta nuntungaw, ya lala'i, ");
INSERT INTO ifb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","at ngadnan Rachel ta hi Dan ti alyonah nan nomnomnay, “Maphod ta impanuh Apo Dios nan aat'u ta mipattig di amaphoda' ti indatna han lala'in imbaluy'u!” ");
INSERT INTO ifb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ya palpaliwan ya nunhabi goh hi Bilhah hi miyadwa. Ya nuntungaw, ya lala'i goh, ");
INSERT INTO ifb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","at ngadnan Rachel ta hi Naphtali ti alyonah nan nomnomnay, “Hidin hopapna ya hi agi' di nangabak, mu ad ugwan ya ha\"in di nangabak ti ten indatana' hi imbaluy'u!” ");
INSERT INTO ifb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mu unat goh inilan Leah an adi munholag ya inyabulutna ta immuy ne'yelo' hi Jacob hinan tagalanan hi Zilpah. ");
INSERT INTO ifb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ya palpaliwan ya nalmu han imbaluydan lala'i, ");
INSERT INTO ifb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","at ngadnan Leah ta hi Gad, ya inalinay, “Himmimo' ta nawadah te goh an imbaluy'u!” ");
INSERT INTO ifb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ya palpaliwan ya na'adwaan, ya lala'i goh. ");
INSERT INTO ifb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ya inalin Leah di, “Ma'am'amlonga' ahan ti nan binabai ya ngadnana' hi ma'am'amlong!” At ngadnana nan ung'ungnga ta hi Asher. ");
INSERT INTO ifb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ya wa han algaw eden iwang an ahiboto' ya immuy hi Reuben an munle'le'od hi payaw, ya inah'upana han himmangaw an ma'usal hi imud, at innalna, ya inyanamutna, ya indatnan inanan hi Leah. Ya nun'adaw hi Rachel ay hiyan inalinay, “Idatana' ni' hinan imud an inyanamut han imbaluymu!” ");
INSERT INTO ifb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ya inalin Leah di, “Undan alyom goh ta polhom tun indat han imbaluy'un umat hinan namloham hinan ahawa'?” Ya inalin Rachel di, “Adya idatmu ay nan holo' an imud an innal han imbaluymu at mabalin an he\"ay me'yelo' ay Jacob hi mahdom.” ");
INSERT INTO ifb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ya wan na'uy an mahdom hi umanamutan Jacob ya immuy hi Leah ta ayna damuwon hiya, ya inalinan hiyay, “Ha\"in di pe'yelo'am hi ad ugwan an mahdom ti binayada' he\"ah nan holo' an imud an indat han imbaluy'un ha\"in!” At hiya mah di ne'yelo'an Jacob eden nahdom. ");
INSERT INTO ifb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ya hi Apo Dios ya inyabulutna ta nawadaan hi Leah hi miyalemah holagna. Ya unat goh nuntungaw ya lala'i, ");
INSERT INTO ifb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","at ngadnana ta hi Issachar ti alyonah nomnomnay, “Hi Apo Dios di nangidat hi lagbu' an ten ung'ungnga ti hay nangabuluta' hi ne'yelo'an nan ahawa' hinan tagala'!” ");
INSERT INTO ifb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ya palpaliwan ya nunhabi goh hi Leah hi miyonom an lala'i, ");
INSERT INTO ifb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ya nuntungaw, ya lala'i goh, at ngadnanad hi Zebulun ti alyonah nomnomnay, “Hi Apo Dios ya indatana' hi maphod an adaw'u, at mabalin an e'gonana' mahkay hinan ahawa' ti ten onomda tun imbabaluymi!” ");
INSERT INTO ifb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ya palpaliwan ya nawadaan goh hi imbaluynan babai, at ngadnana ta hi Dinah. ");
INSERT INTO ifb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ya la'tot ya ninomnom Apo Dios hi Rachel ya nan inluwalunan Hiya, at inyabulutnan nunholag. ");
INSERT INTO ifb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","Ya palpaliwan ya nunhabi ta nuntungaw, ya lala'i, at nginadnana ta hi Joseph ti alyonah nomnomnay, “Maphod ta indat Apo Dios di holag'u ta adia' mahkay gun pihulon hinan tatagu! Ya olom man ni' ya adwaan Apo Dios ah oha goh hi imbaluy'u!” ");
INSERT INTO ifb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ya unat goh nawadah Joseph ya inalin Jacob ay Laban di, “Ad ugwan ya pohdo' an mumbangngad hi babluymi. At iyabulutmu ni', ");
INSERT INTO ifb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","at awito' nan a'ahawa' ya nan imbabaluymi ti imbo'la' dida, ya inilam di inat'un nuntamuh nan impatamum ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ya inalin Laban ay hiyay, “Adi'aat ni' makak! Ti hay inulgud nan mun'immatun hi ma'at ya alyonay he\"ay dimmalat hinan do'ol an wagah Apo Dios ay ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","At ta\"on ya imbaagmu nan pohdom hi bo'laom ta idat'u.” ");
INSERT INTO ifb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ya inalin Jacob ay hiyay, “Ininnilam nan inat'un nuntamuh nan impatamum ay ha\"in hitun atnay tawon ya aat di nahlagan nan impahtulmun baka ya nan udum. ");
INSERT INTO ifb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ti din hopap di immalia' ya adida umat hina ti nahnotda, mu maphod ad ugwan ti nen dimmo'olda ti winagahan da'an Apo Dios an ha\"in dimmalat. At ad ugwan ya mahapul'u goh an nomnomon di mabalin hi pangngala' hi pananud'uh nan pamilya'.” ");
INSERT INTO ifb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ya impidwan Laban an nangalin hiyay, “Hay pohdom hi bino'lam ta idat'u?” Ya tembal Jacob an inalinay, “Adia' mumbagah bino'la', mu unudom ay han penhod'un ibaga ya ituluy'un mumpahtul hinan pahtum. ");
INSERT INTO ifb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","At hay pohdo' ya iyabulutmu ta ay'u ilahhin an amin nan mangmangitit ya nan obang an kalnilu ya obang an gandeng ta hiyay bino'la'. ");
INSERT INTO ifb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ta udum hi algaw hi aymu pannigan hinan bino'la' ta wada ay di mumpaha' hinan nilahhin an gandeng'u ya kalnilu' ya ma'innila an hay inakaw'uh nan pahtum.” ");
INSERT INTO ifb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ya tembal Laban ya inalinay, “Abuluto', at atonta nan inalim.” ");
INSERT INTO ifb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","At hay inat Laban eden algaw ya immuy hinan pahtuna ta ayna inlahhin an amin nan mangmangitit an kalnilu, ya nan na'obangan ya nan nun'awalitan an buta'al an gandeng, ya nan nun'a'obangan hi tennan gandeng, ya ene'kodnah nan linala'in imbabaluyna ta diday manalimun. ");
INSERT INTO ifb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ya adagwiy nangiyayanda ti tuluy algaw hi dimmaladalananda ya unda idinong, ya nan inangangda ya hiyay ituluy Jacob an ipahtul. ");
INSERT INTO ifb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Hi Jacob ya inummal hinan numbino'ob'on an ma'atan ayiw, ya inol'olebangnan ginudahan ta mun'attig di mumpaha'. ");
INSERT INTO ifb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ya hiyay nun'ihagangnah nan wadan di uminuman nan a'animal ti hiyah ne emmenghah pangundulanda. ");
INSERT INTO ifb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ya wa ay ta mangundul nan a'animal ta tigonda nan nihagang an nun'ahe'lapan at waday imbaluyda, ya nun'a'obangan ya nun'agalitan. ");
INSERT INTO ifb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ya inuhigna nan kalniluh nan gandeng ya unna ipahagang didah nan mangmangitit ya na'obangan an a'animal Laban. Umat hinay inatna ta hanan obay ya ta umimbaluyda an na'obangan, ya nilahhindah nan pahtun Laban. ");
INSERT INTO ifb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ya wa ay ta mangundulda nan mun'ahdol an a'animal ya inyuy Jacob din hapang an nun'ahe'lapan hinan hinagangdah nan pun'inumanda ta gunda tigon ta hiyay anungonda, ");
INSERT INTO ifb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","mu agguyna inat hinan nun'a'ung'ung an nakapuy. At la'tot ya nan mun'ataban mun'a'odhol an amin di a'animal Jacob, ya nan nun'a'ung'ung an nakapuy di bagin Laban. ");
INSERT INTO ifb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","At la'tot ya immadangyan hi Jacob ti dimmo'ol di tagalanan linala'i ya binabai, ya dimmo'ol goh di a'animalnan gandeng, ya kalnilu, ya kamilu, ya dongki. ");
INSERT INTO ifb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hin'alina ya dengngol Jacob di hapit nan linala'in imbabaluy Laban an alyonday, “Inamin Jacob an nun'ala nan a'animal ama tu'u ta hiyay inyadangyana!” ");
INSERT INTO ifb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ya inolman Jacob goh an naluman di aat Laban ti manghan di apnganan hiyan adi umat hidin hopapna. ");
INSERT INTO ifb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ya inalin Apo Dios ay Jacob di, “Mumbangngad'ah nan numbabluyan nan o'ommodmu ya nan tutulangmu, at wadaa' an mangitnud ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","At impa'ayag mah Jacob da Rachel ay Leah ta umuydah dih nan pahtuda. ");
INSERT INTO ifb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ya unat goh immuyda ya inalinan diday, “Inolma' an hi amayu ya naluman an manghan di apnganan ha\"in an adi umat hidin hopapna, mu maphod ta nan Dios an dayawon ama ya umannung an wadan ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Da'yun duwa ya inilayuy nangihamada' an nuntamun amayu, ");
INSERT INTO ifb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","mu ta\"on damdama ya gunna' linayahan ay hiya ti nitugtugan gunna linuman di nitulag hi bino'la'. Mu maphod ta binadangana' ay Apo Dios ta mi'id inatnan ha\"in hi nappuhi. ");
INSERT INTO ifb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ti wa ay ta inalin amayu an nan nun'a'obangan an a'animal di bo'lao' ya umannung an miyunnudan an hiyay pun'iyimbaluy an amin nan a'animal. Ya hinukatana ay goh ta inalinay nan nun'awalitan hi mangmangitit ya hiya goh di pun'iyimbaluyda. ");
INSERT INTO ifb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","At hi Apo Dios di paddungnay nangalah nan a'animal amayu ta indatnan ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ya din pangundulan nan a'animal ya nun'enapa', ya tinnig'u nan buta'al an gandeng, ya nun'a'obanganda, ya nun'awalitan hi mangmangitit di udumnan gunda mangundul. ");
INSERT INTO ifb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ya numpatigaw nan anghel Apo Dios eden nun'enapa', at bugwaonay ngadan'u. At tembal'un inali' di, Ngadan ne, Apu? ");
INSERT INTO ifb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ya inalinay, Tigom ti an amin nan buta'al an mangundul hinan gandeng ya nun'a'obangan ya nun'awalitan di udum hi mangmangitit. Manu ay at hinay ma'ma'at ya titiggo' nan ato'aton Laban ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ha\"in nan Dios an numpatigaw ay he\"ah di ad Bethel hinan nangiha\"adam hidin batu, ya hiniitam hi lana ta panginomnomam hi nannigam, ya hay nunhapataam ay Ha\"in hidi. At ad ugwan ya mundadaan'a ta mumbangngad'a mahkay hinan babluy an nitungawam.” ");
INSERT INTO ifb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ya inalin da Rachel ay Leah di, “Mi'id ahan ah inangang amamih ipaboltanan da'mi! ");
INSERT INTO ifb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","An ay ami bo'on iwah tuh nangatna ti ay paddungnay un da'mi inihbut, at umahonay hubutmin amin. ");
INSERT INTO ifb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mu an amin nan inadangyan an innal Apo Dios ay hiya ya bagi tu'un amin hitun ung'ungungnga. At atom nan pohdon Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","At makak da Jacob, ya nun'itakayna nan a'ahawana ya nan imbabaluynah nan kamilu. ");
INSERT INTO ifb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ya enekakdan amin nan a'animalda ya an amin nan wadan dida an inamungdah awadandad Paddan Aram hinan babluy hi ad Mesopotamia ta ipluydah ad Canaan an awadan amanan hi Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ya ta\"on nan bulul an bagin amanan hi Laban ya ni'yalan Rachel, ya hidin nakakanda ya impadehdah ami'idan da Laban an ayda mun'eh'eh hinan dutdut di kalniluda. ");
INSERT INTO ifb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ya agguy impa'in'innilan da Jacob ay Laban, ya limmayawda. ");
INSERT INTO ifb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","At inta'indan amin nan wan dida, ya binad'angda nan Wangwang an Euphrates, ya inayundan dalanon nan dudunduntug ad Gilead. ");
INSERT INTO ifb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ya heden miyatluh algaw hi nakakan da Jacob ya waday nangipa'innilan Laban, ");
INSERT INTO ifb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","at pun'ayagana mah nan linala'in tutulangna ta unudonda dida. Ya nan miyapituh algaw ya unda ah'upan didah nan dudunduntug hi ad Gilead. ");
INSERT INTO ifb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mu heden nahdom ya numpa'enap hi Apo Dios ay Laban, at inalinan hiyay, “Nomnomnomom nan hapitom ay Jacob ta adim idugah.” ");
INSERT INTO ifb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ya da Jacob ya immapaldah tulid nan dudunduntug ad Gilead, ya immapal goh da Laban. ");
INSERT INTO ifb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","At immuy hi Laban, ya inalinay, “Anaad ta umat hinay inatmu, Jacob? An ay paddungnay unmu kinaphul tun imbabaluy'uh nan gubat, ya inlayawmu dida! ");
INSERT INTO ifb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Anaad ta unna' inli\"udan ya nakak ayu? Ya gulat ta impa'innilayun ha\"in at indadaan'u ah pun'am'amlongan tu'un amin ya un ayu makak! ");
INSERT INTO ifb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Anaad ahan ta agguya' binagan ta way inat'un ni'hahapit hitun a'apu' ya tun imbabaluy'u ta pohod ya un tu'u munhihiyan? Nappuhi ahan henen inatmu! ");
INSERT INTO ifb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mabalin an waday ato' hi nappuhin he\"ah ad ugwan hi un agguy numpa'enap hi ad a\"u nan Dios an dayawon amam an inalinay nomnomnomo' di hapito' ay he\"a ta adi midugah! ");
INSERT INTO ifb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mu ta\"omman un umat hinay inatmu ta way atom an mumbangngad hi abung da amam, mu ta agguyyu ni' ahan ni'yala din bulul'uh abungmi!” ");
INSERT INTO ifb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ya inalin Jacob di, “Manu ay inat'uy umat hina ti unna' tuma'ot ti alyo' di ini ya ipawam nan imbabaluymu! ");
INSERT INTO ifb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mu nan alyom an bulul ya anaponyu, ta wa ay di ah'upanyu ya ta\"on un mipapatoy nan nangala. Ya wada ay di udumnah bagim hi ah'upanyu ya intudum ta pangintitigan tun tatagun ni'yibba tu'u.” (Ya manu ay inalin Jacob di umat hina ti agguyna inilah un hi Rachel di nangalah nan bulul.) ");
INSERT INTO ifb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","At inte\"an Laban an nun'anap hinan nuntuldaan Jacob ya unna eyewel ay Leah ya nan duwan tagalana, mu mi'id ah inah'upana. At iyewelna mahkay hinan nuntuldaan Rachel, ");
INSERT INTO ifb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","mu mi'id damdamay inah'upana ti hi Rachel an nangala ya inhinanah nan ubunan an muntakay hinan kamilu, ya inumbunana. ");
INSERT INTO ifb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ya inalinan amanay, “Adi'a bumungot hi adi' tuma'dogan hitun inumbuna' ti numpa'ahwanga'.” At mi'id mah ah inah'upan Laban an ta\"on unna impadah di abalinanan immana'anap. ");
INSERT INTO ifb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","At bimmungot mah hi Jacob, at pun'ibaganan Laban an inalinay, “Undan way numbahola' ay he\"a ta anaad ta nun'unuda'? ");
INSERT INTO ifb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","At nen nalpah an mi'id ah agguymu inanap hinan bagimi at ipattigmu mahkay un way inah'upam hi bagim ta tun ni'yibbata ya diday okod an mangihtiguh numbahol ay ditan duwa!” ");
INSERT INTO ifb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ya inalina goh di, “Duwampuluy tawon hi nuntamua' ay he\"a, at gun'u impapto' nan a'animalmu ta nahlagdan dimmo'ol, ya mi'id ah pinalti' ta inihda'! ");
INSERT INTO ifb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ya ta\"on nan pinatoy di layon ya agguy'u imbilang hi bagim an ha\"in di niyaanana! Ya umat goh hinan na'utaw an ta\"on un bo'on bahol'u ya impahukatmun ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ya nunheglay nange'edpola' hinan potang ya tungnin hinan mahdom, ya niddum hinan timmu'ala'! ");
INSERT INTO ifb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ya at hinay na'at ay ha\"in hitun nalpah an duwampuluy tawon ti himpulu ta opat di tawon hi namo'laa' hitun duwan imbabaluymu, ya onom di tawon hitun a'animal! Ya gunna' goh linayahan ay he\"ah namimpulu ti gunmu imbahhabahhaw nan intulagta an bo'lao'! ");
INSERT INTO ifb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ya gulat un bo'on hi Apo Dios an dayawon ya ta'tan nan o'ommod'un da Abraham ay Isaac di namadang ay ha\"in at pinakaka', ya mi'id ah am'amungit hi indatmun ha\"in! Mu maphod ta titinnig Apo Dios nan numpalpaligata' ya nan inat'un nuntamu, at hiyaat un da'a pinadanan ad a\"u ta adim idugah di hapitom ay ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ya inalin Laban di, “Tun binabai ya imbabaluy'u dida, ya a'apu' nan imbabaluyda, ya ta\"on un tun a'animal ya bagi'. At adi mabalin hi un waday ato' hi nappuhih tun imbabaluy'u ya tun a'apu'! ");
INSERT INTO ifb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","At hiyanan mahapul an muntulagta ta nan abulutontan duway mahapul hi ma'at, at hi Apo Dios di mangihtigun dita.” ");
INSERT INTO ifb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","At innal Jacob han batu, ya hina\"adna ta panginomnomandan den na'at. ");
INSERT INTO ifb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ya inalinah nan linala'in i'ibbana ta umuyda mangubuh batu ta upunonda. At mangandan duwa ay Laban hinan heggon den na'upun an batu. ");
INSERT INTO ifb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","At ngadnan Laban ta ad Jegar Sahadutha hinan hapitnan Aramaic, mu nginadnan Jacob ta ad Galeed hinan hapitnan Hebrew. ");
INSERT INTO ifb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ya inalin Laban di, “Heten na'upun di panginomnomantan duwa.” (At hiyah ne dimmalat hi nungngadanandan den lutah ad Galeed.) ");
INSERT INTO ifb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ya nginadnanda goh ta ad Mizpah ti hay nangalyan Laban hi, “Hi Apo Dios di manalimun ay ditan duwa ta umannung an nan nunhapitantay ma'at an ta\"on unta mumbattaan.” ");
INSERT INTO ifb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","At intuluy Laban an inalinay, “Gulat ta aboholam tun imbabaluy'u, ya gulat goh ta mangahawa'ah udum an ta\"on hi adi' innilaon ya nomnomnomom an hi Apo Dios di mamannig ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ya inalin goh Laban ay Jacob di, “Heten na'upun ya nan hina\"ad'un batuy panginomnomantan duwa. ");
INSERT INTO ifb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ya panginnilaanta an adi mabalin hi un'u lauhan ta umalia' an mi'pattoy ay he\"a, ya umat goh ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","At nan Dios an dayawon da Abraham ay Nahor ya hi amada goh di okod an mummoltah nan mangibahhaw eten nuntulaganta!” At hiyay inabulut Jacob hi ihapatanah nan me'gonan an Dios an unudon amanan hi Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","At e'nong Jacob han animal ay Apo Dios hidih nan tulid di dudunduntug, ya inayaganay i'ibbana ta mangandan amin. At innayundan mihinan den immiyananda. ");
INSERT INTO ifb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ya unat goh nabiggat hi helhelong ya bimmangon hi Laban, at ungnguwona nan imbabaluyna ya nan a'apuna, ya winagahana dida. Ya unat goh nalpah ya mumbangngad da Laban hinan babluyda. ");
INSERT INTO ifb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ya unat goh impadeh da Jacob ta umuydah nan ayanda ya hin'alina ya dinamun nan a'anghel Apo Dios hiya. ");
INSERT INTO ifb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ya unat wan tinnigna dida ya inalin Jacob di, “Hiyah te goh di nungkampuan nan titindalun Apo Dios!” At ngadnanah den luta ta ad Mahanaim. ");
INSERT INTO ifb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ya munhonag hi Jacob hinan baalna ta iyun'unnadan umuy hi awadan aginan hi Esau hidih nan dudunduntug an mungngadan hi Seir hidih nan babluy hi ad Edom. ");
INSERT INTO ifb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ya inalinan diday, “At hituy ulgudonyun Esau an alyonyuy, Nan baalmun hi Jacob ya pohdonan ipa'innilan he\"a an hay abung da Laban di hiyay nihihinnana, at hiyaat un nataktak di pumbangngadanah engganad ugwan. ");
INSERT INTO ifb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","At ten do'ol di a'animalna an kalnilu, ya baka, ya dongki, ya gandeng, ya dimmo'ol goh nan baalnan linala'i ya binabai. Ya manu ay impangun'unna da'mi ta ipa'innilamin he\"ay umalianda ta logom ya abulutom.” At impadehdan nakak. ");
INSERT INTO ifb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ya heden numbangngadan daden nahnag ya inalidan Jacob di, “Impa'innilamin agim, at nen na'uydan manamun ditu'u an initnudnay opat di gahut an linala'i.” ");
INSERT INTO ifb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ya ma'atta'ot hi Jacob hi nangngolanan de han inalida, at hay inatna ya ginodwana nan ni'yibbana ya nan a'animal ta duwam pamulog. ");
INSERT INTO ifb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ti hay ninomnomna ya inalinay, “Ini ya umalida, ya pinatoyda nan ohan pamulog, ya ta way aton di namingngit an lumayaw!” ");
INSERT INTO ifb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","At munluwaluh Jacob an inalinay, “He\"an Dios an dayawon apun hi Abraham ya hi aman hi Isaac, ya He\"ay nangalih unna' mumbangngad hinan numbabluya' ya nan wadan di i'ibba', at okod'an mangipapto' ay ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","At immannung an hiyay inatmu ti ten intuluymun nangipattig hi ulaymun ha\"in an baalmu an ta\"on un at hituy aat'u an na'ampaa'! Hidin nakaka' hinan babluymih nange'wa' hinan Wangwang an Jordan ya ammuna nan hul'ud'uh inta'in'u. Mu ten nunholaga', at ten ad ugwan ya nunduwa amin nabulog. ");
INSERT INTO ifb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","At dawato', Apu, ta ehwang da'mi ni' ahan hinan malgom an nappuhin ma'at hi ninomnom nan agi' an hi Esau hi atona ti ten nidugah di tuma'ta', ti ini ya umali, ya numpatoy da'min amin an ta\"on tun a'ahawa' ya tun imbabaluy'u! ");
INSERT INTO ifb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mu intulagmun alyom hi ipapto'a', ya wagaham nan holag'u ta dumo'oldan umat hi panag hinan pingit di baybay an adi ma'uyap.” ");
INSERT INTO ifb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","At ita'dogdah di eden nahdom ta umiyanda. Ya unat goh naweet ya ninomnomnay mahapul an waday idatnan aginan hi Esau. ");
INSERT INTO ifb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","At inlahhinay duway gahut an tennah gandeng, ya duwampuluh buta'al an gandeng, ya duway gahut di tennah kalnilu, ya duwampuluh manilhig an kalnilu, ");
INSERT INTO ifb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ya tulumpuluy kamilu ya nan uyaw an imbabaluyda, ya napat di baka, ya himpuluy manilhig hi baka, ya duwampuluh tennan dongki, ya himpuluy manilhig hi dongki. ");
INSERT INTO ifb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ya hanan midat di namanguluona an na'uhi'uhigda ya impitnudnan danen baalna, ya numpumbattaandan ahimpahimpamulog. ");
INSERT INTO ifb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ya inalinah nan namangulun baal di, “Damuwom ay hi Esau ta ibaganay ad animal ay date, ya hay ad baal ay he\"a, ya hay umayanyu ");
INSERT INTO ifb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ya alyom ay hiyay, Hatu ya bagin nan baalmun hi Jacob, mu hay idatnan he\"a. Dida ya na'uydan mangunud ti unda namingngit.” ");
INSERT INTO ifb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ya at hinan amin di nangalinah nan baalnan nahayhaynod ");
INSERT INTO ifb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ti hay ninomnom Jacob ya inalinay, “Ta ammunah panamua' ya na'uyah di bohol agi' ay ha\"in an dumalat heten idat'u.” ");
INSERT INTO ifb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","At impangun'unnana nan baalna ta da Jacob di nanginayun an immiyan hidi eden nahdom. ");
INSERT INTO ifb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ya heden nahdom ya ekak Jacob nan duwan ahawana, ya nan tagalada, ya nan himpulu ta ohan imbabaluyda, at bad'angonda nan ginnaw an Jabbok, ");
INSERT INTO ifb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","mu numbangngad ta ayna ipabad'ang an amin nan a'animalna ya nan baalna. ");
INSERT INTO ifb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","At un oh'ohha hiyan de an immiyan. Ya hin'alina ya wada han immuy an lala'i ta immawi'awitdan den nahdom ta nangamung un nawa'ah. ");
INSERT INTO ifb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mu unat goh wan ininnilan den lala'i an adi umabak ya gempa'nay nun'ummuman di alakan Jacob, at napuh'uh nan niyummumana. ");
INSERT INTO ifb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ya inalin nan lala'iy, “Payona' ti den na'uy an mawa'ah!” Ya inalin Jacob di, “Adi' he\"a payon ta engganah unna' wagahan ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ya inalin den lala'iy, “At hay ngadanmu mah?” Ya inalinay, “Ha\"in hi Jacob.” ");
INSERT INTO ifb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ya tembalnan inalinay, “Mete\"ad ugwan ya bo'on mahkay he\"ah Jacob ta he\"ah Israel ti mabi'ah'ah ni'yawitam ay Apo Dios ya nan tatagu, ya he\"ay nangabak.” ");
INSERT INTO ifb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ya mahmahan Jacob an alyonay, “Ibaagmu ni' di ngadanmu!” Mu inalin nen lala'iy, “Adi mahapul un'u ibaag di ngadan'u.” At inayuna an wagahan hi Jacob hidi. ");
INSERT INTO ifb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","At ngadnan Jacob heden babluy ta ad Peniel ti inalinay, “Tinnig'u nan angah Apo Dios, mu maphod ta agguya' natoy.” ");
INSERT INTO ifb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ya wan na'uy an bumuhu' nan algaw at makak hi Jacob hidih ad Peniel, ya munha'ha'illu ti napuh'uy alakana. ");
INSERT INTO ifb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","At hiyanan engganah ad ugwan ya adi ihdan nan holag Israel nan nun'ummuman nan alakan nan malgom an mapalti ti hiyah ne din nagpa' an ulpun Jacob, at nun'ohon. ");
INSERT INTO ifb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Inamang Jacob ya na'uy hi Esau ya nan ni'yibbanan opat di gahut an linala'i, at inuhigna nan imbabaluynah nan opat an binabai an da Leah ay Rachel ya nan duwan tagalada ");
INSERT INTO ifb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ta impipangpang'una nan duwan binabain tagalada ya nan imbabaluyda, ya netob da Leah ya nan imbabaluyna ya un mehnod ay da Rachel ay Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ya hi Jacob di nangipang'un umuy an mi'dammun aginan hi Esau, at gun nunluung hi numpapitu ta nangamung neheggon ay agina. ");
INSERT INTO ifb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ya timmagtag hi Esau an manamun Jacob, ya inawalna hiya, ya enedonah pu'olna, ya inungnguna hiya, ya kimmiladan duwan dumalat nan amlongda. ");
INSERT INTO ifb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ya unat goh tinnig Esau nan binabai ya nan ung'ungungnga ya inalinan Jacob di, “Ngadan hatun ni'yibbam?” Ya inalinay, “Didatuy pamilya' an indat Apo Dios an dumalat di pamhod ya homo'na.” ");
INSERT INTO ifb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ya neheggonda nan duwan tagala ya nan imbabaluyda ta nunluungdah hinagang Esau, ");
INSERT INTO ifb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ya umat goh hinay nangat da Leah ya nan imbabaluyna, ya da Rachel ay Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ya mahmahan Esau an inalinay, “Hay aat nin dade han dinamu', ya hay pohdonan ipa'innila?” Ya inalin Jacob ay hiyay, “Didanay ninomnom'uh idat'un he\"a ta way atom an mangabulut hi umalianmi.” ");
INSERT INTO ifb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ya inalin Esau di, “Agi', adi' mahapul dane ti do'ol goh di animal'u, at bagim hana!” ");
INSERT INTO ifb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ya inalinay, “Abulutom ni' ahan hanan idat'un he\"a ti ad ugwan an nanniga' hi angahmu ya paddungnay tinnig'uh Apo Dios ti nan nangipattigam hi amlongmun ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","At abulutom ni' ahan ti do'ol tun animal'un dumalat nan nammo'an Apo Dios ay ha\"in.” At gapu ta impapilitna at na'al'alu' hi Esau, ya inabulutna. ");
INSERT INTO ifb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ya unat goh nalpah di nunhapitanda ya inalin Esau di, “Umuy tu'u mah ta ipangpang'u' di owon tu'u.” ");
INSERT INTO ifb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ya inalin Jacob di, “Inilam an mamannogda tun ung'ungungnga an adida umdan dumalan, ya ta\"on un tun animal ya honanon ay dida ya mabmablayda, ya matoyda. ");
INSERT INTO ifb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","At ta\"ongkay ya inyunna'unnayun umuy ta un ami mangun'unud ta nangamung di dumatnganmid Seir.” ");
INSERT INTO ifb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ya inalin goh Esau di, “Hay pohdo' ya mataynan tun udum an ni'yibba' ta way bumadang ay da'yu.” Ya inalin Jacob di, “Adi mahapul hene ti ammuna nan nangipattigam hinan nahamad an amlongmun ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","At impadeh da Esau ya nan ni'yibbanan numbangngad ad Edom eden algaw. ");
INSERT INTO ifb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ya da Jacob ya immuydad Sukkoth, ya hidiy nangiyammanah apalda ya nan a'al'allung an nihi'ugan nan animalna ta hiyah te dimmalat hi nangadananah Sukkoth. ");
INSERT INTO ifb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ya nakakdad Sukkoth ta dimmatongdad Shechem an siudad hidid Canaan. Ya mid al'alih dimmatngandah di an mete\"ah nalpuwandad Paddan Aram. Ya immiyandah dih nan payaw an neheggon hinan siudad. ");
INSERT INTO ifb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ya ngininaanah den lutan immiyanandah nan holag Hamor an hi aman Shechem hi hinggahut di silver an pihhu. ");
INSERT INTO ifb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ya inyammanay pun'onngan ay Apo Dios, ya nginadnanah El Elohe Israel. ");
INSERT INTO ifb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Wa han ohay algaw ya hi Dinah an imbaluy da Jacob ay Leah ya immuy ni'ligwah nan i'ibbanan binabain iCanaan. ");
INSERT INTO ifb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mu unat goh tinnig Shechem an hina' Hamor an holag Hiv ya dempapna, ya enelo'na. (Hi Hamor di ap'apun den babluy.) ");
INSERT INTO ifb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mu nalmuy nidugah hi namhod Shechem ay Dinah, at ihaphapitana ta mun'ahawada. ");
INSERT INTO ifb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","At inalinan amanan hi Hamor di, “Umuy'ah nan o'ommodna ta ibagam an penhod'un ahawaon hiya!” ");
INSERT INTO ifb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mu unat goh dengngol Jacob heden nappuhin na'at eden babain imbaluyna ya un dindinong ta unna enehod hi umanamutan nan linala'in imbabaluynan immuy numpahtul. ");
INSERT INTO ifb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ya hin'alina ya immuy hi Hamor an hi aman Shechem ta ay mi'hapit ay Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ya immanamutda nan linala'in imbabaluy Jacob an nalpuh payaw hidin nangngolandah nan na'at, ya nidugah di bimmungtanda ti nunheglay namainan Shechem ay didan Hudyun dumalat heden nampapanah nan babain agida ya enelo'na. ");
INSERT INTO ifb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mu inalin Hamor ay diday, “Hay umatana mah ti han imbaluy'un hi Shechem ya nunheglay namhodnah nan imbaluymun hi Dinah? At ta\"on ni' ahan ya inyabulutyu ta mun'ahawada. ");
INSERT INTO ifb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ya maphod goh hi un ayu mi'yapun da'mi, at mabalin goh an mi'yahawada nan linala'in imbabaluymuh nan binabain imbabaluymi. ");
INSERT INTO ifb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","At hituy pi'hituwanyu, ya okod ayuh nan pohdonyuh ihinanyun te han babluy. Ya nan luta goh ya mi'id ah mangipawah ayyu puntamuan, ya mabalin goh an mungkumildu ayu ta way umadangyananyu.” ");
INSERT INTO ifb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ya inalin Shechem ay Jacob ya nan i'ibban Dinah di, “Mumpahmo'a' ay da'yu ta iyabulutyu ni' ta ahawao' hi Dinah! At ibagayuy idat'uh pamnung'u an ta\"on un ngadan ne pohdonyu ya idat'u. ");
INSERT INTO ifb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Adi ayu mun'ogon an mangibaga ti idat'u an ta\"on hi un atnay alyonyu ya abuluto', mu ta iyabulutyu an ahawao' hi Dinah!” ");
INSERT INTO ifb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ya tembal nan imbabaluy Jacob an binalbaliyanda da Shechem an hin'ama ti dimmalat nan inat Shechem ");
INSERT INTO ifb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","an alyonday, “Adi mabalin hi un mi'yahawa nan agimin babaih nan agguy nakugit ti adi maphod di umat hinan da'mi! ");
INSERT INTO ifb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mu mabalin an iyabulutmih unyu pohdon ta mumpakugit an amin nan linala'i ta umat ay da'mi, ");
INSERT INTO ifb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ta way atonmin mangiyapuh nan binabain da'yu, ya mangahawa amih nan iwah tun binabai. At umannung an hituy pi'hituwanmih tun babluyyu ta ma'ohha tu'un himpampun. ");
INSERT INTO ifb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mu adiyu ay unudon henen imbagami ta adi ayu mumpakugit an linala'i ya onaynah unmi awiton han agimin babai, ya nakak amih tu.” ");
INSERT INTO ifb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ya inabulut da Shechem an hina\"amah den imbagada ti maphod hi nangngolanda. ");
INSERT INTO ifb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","At hi Shechem an hiya ahan di ipabagtudah nan nunhituwanda, ya pohdona an mumpakugit an adi mataktak an dumalat nan nidugah an namhodnah nan imbaluy Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","At immuy da Hamor an hin'amah nan way ubunan di tataguh nan way buhu'an hinan babluy ta pun'ibagadah nan linala'in alyonday, ");
INSERT INTO ifb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Nan linala'in immali ya mapmaphod di pi'yibbaandan ditu'u! At maphod hi unda mi'hitun ditu'uh tun babluy tu'u ti ongol an damunan babluy, at okoddah nan atondan umat hinan pungkumilduanda. Ya maphod hi un ahawaon tun linala'i nan binabain imbabaluymi, ya umat goh hinan binabaih tu an mabalin hi ahawaon nan linala'ida ta mumpun'apu tu'u. ");
INSERT INTO ifb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","At danen linala'i ya penhoddan middum ay ditu'u, mu hay inalida ya gahin ahan un tu'u mumpakugit an amin an linala'i ta umat tu'u ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","At undan adiyu pohdon hene ta mi'hitudah tu ta an amin nan a'animalda ya nan wan dida ya bagi tu'un amin?” ");
INSERT INTO ifb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","At an amin daden linala'in ni'yamung ya inabulutda nan inalin da Hamor ay Shechem. At mumpakugitda mah an didan amin ay da Hamor an hin'ama. ");
INSERT INTO ifb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ya unat goh naluh di tuluy algaw hi numpangalum'a'an nan kugitda ya nan duwan linala'in imbabaluy Jacob an da Simeon ay Levi an nan a'agin Dinah ya innalday hinalungda, ya immuydah nan babluy, at numpatoydan amin nan linala'i. ");
INSERT INTO ifb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ya ta\"on hi Hamor ya han imbaluynan hi Shechem ya ni'patoyda. Ya wan nalpah at awitondah Dinah, ya enekakda. ");
INSERT INTO ifb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ya heden nalpahan di numpamatayanda ya nihukatda din udumnan linala'in imbabaluy Jacob an immuy hinan babluy ta ayda hinamham an amin nan wah di. Ya manu ay umat hina oo ti dimmalat nan nappuhin na'at ay Dinah. ");
INSERT INTO ifb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","At nun'aladan amin nan malgom hi inah'upanda an umat hinan animal, ya nan wan den babluy, ya ta\"on nan wah payaw. ");
INSERT INTO ifb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ya ta\"on nan mun'apla'an an gina'udah nan abungda, ya nan ung'ungungnga, ya binabai, ya nun'ilagatdan hinamham. ");
INSERT INTO ifb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ya unat goh ininnilan Jacob nan inat da Simeon ay Levi ya ma'ahhingal an inalinay, “Anaad ta ayyu inat di umat hinah lummuh bumoholan nan tataguh tun ha\"in? Ya gulat ta munlalammungda nan iCanaan ya nan holag Periz ya immalidan mi'pattoy, at amehon ditu'u ti un tu'u itang, at hiyay a'ubahan tu'un amin!” ");
INSERT INTO ifb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ya himmapitda, ya inaliday, “Baholda tuwali ti anaad udot ta umat hi putay nangatdah nan agimin babai?” ");
INSERT INTO ifb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ya la'tot ya inalin Apo Dios ay Jacob di, “Makak ayuh tu ta umuy ayuh ad Bethel ta hidiy ihinanyu. Ya iyammam hidi ah pun'onnganyu ay Ha\"in an Dios an din numpattig ay he\"ah din limmayawam hi bimmungtan han agim an hi Esau.” ");
INSERT INTO ifb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ya nun'alih Jacob ay didan hina\"ama ya an amin hinan ni'yibbadan inalinay, “Pumpa\"iyuy numbino'ob'on an bulul an hinamhamyu an inta'inyu, ya numpun'amoh ayu, ya nunlubung ayuh nan maleneh ta panginnilaan hi un tu'u maleneh an mundayaw ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ti ad ugwan ya makak tu'uh tu ta umuy tu'uh ad Bethel, ta hidiy pangiyamma' hi pun'onngan ay Apo Dios an din namadang ay ha\"in hidin nunligata', ya Hiyay nangipangpanguluh an amin hinan immaya'.” ");
INSERT INTO ifb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","At pun'idatda mah ay Jacob an amin nan bulul an wan dida ya ta\"on nan hingatda, at pun'ilubu' Jacob hinan way puun di ayiw an ma'alih oak hi ad Shechem. ");
INSERT INTO ifb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ya heden nakakan da Jacob ya hi Apo Dios di nangipata'ot hinan tataguh nan babluy hinan enengwada, at mi'id di inatdah nappuhin da Jacob ");
INSERT INTO ifb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ta nangamung unda dimmatong hi ad Luz an ma'alih ad Bethel hi ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","At hidiy nangiyammaan Jacob hi pun'onngan, at ngadnana ta ad El Bethel ti hidiy numpa'innilaan Apo Dios hi aatnan hiyah din limmayawanah din bimmungtan aginan hi Esau. ");
INSERT INTO ifb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ya palpaliwan ya natoy han na'in'innan hi Deborah an din nangipapto' ay Rebekah. At inyuyda inlubu' hinan way puun di ayiw an ma'alih oak hinan ampan di ad Bethel, ya ngadnanah deh ad Allon Bakuth. ");
INSERT INTO ifb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ya hidin awadan da Jacob hi ad Bethel hi nalpuwanah ad Paddan Aram ya hin'alina ya numpattig goh hi Apo Dios ay hiya, at wagahana hiyan ");
INSERT INTO ifb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","inalinay, “Ad ugwan ya bo'on mahkay hi Jacob di ngadanmu ta he\"ah Israel.” At hiya mah di ingngadana. ");
INSERT INTO ifb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ya inalin goh Apo Dios di, “Ha\"in hi El-Shaddai an nan Dios an abalina' an amin di logom, ya punhologo' he\"a ta dumo'ol di holagmu ta he\"ay ommod an amin nan numbino'ob'on an holag, ya hay udumnah nan holagmu ya diday mumpun'ali. ");
INSERT INTO ifb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ya heten lutan indat'uh nan o'ommodmun da Abraham ay Isaac ya ipaboltan'un he\"a, ya boltanon goh nan holagmu.” ");
INSERT INTO ifb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ya unat nalpah an inalin Apo Dios hana ya immolegoy. ");
INSERT INTO ifb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","At ay inummal hi Jacob hi batu, at ha\"adonan de han potto' nan nanniganan Apo Dios ta panginomnomanan den na'at, ya hiniitanah bayah an me'nong ay Apo Dios ya lana. ");
INSERT INTO ifb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ya ipidwan Jacob an ngadnan heden lugal ta ad Bethel. ");
INSERT INTO ifb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ya palpaliwan ya inhi'al da Jacob an taynan ad Bethel ta umuydah ad Ephrath. Mu agguyda dimmatong hi ad Ephrath ya hin'alina ya nidugah an dinumgoh nan inhabin Rachel, ");
INSERT INTO ifb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ya mumpaligat an muntungaw. Ya unat goh bimmuhu' ya inalin nan babain nanawat di, “Maphod ta lala'i goh tun intungawmu!” ");
INSERT INTO ifb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mu hi Rachel ya mun'aguguyud di hodohdanan matoy, at iyab'abu'abnan hay ngadan nan ung'ungnga ya hi Ben-Oni. Mu hay nungngadan Jacob ya hi Benjamin. ");
INSERT INTO ifb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ya unat goh natoy hi Rachel ya inlubu'dah nan pingit di owon an umuy ad Ephrath (an ad Bethlehem ad ugwan). ");
INSERT INTO ifb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","At inha\"ad Jacob goh han batuh nan nilubu'ana ta way panginomnomana. Ya engganah ad ugwan ya wah dih den batu. ");
INSERT INTO ifb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ya wan nalpah ya intuluy da Jacob an mungngadan goh hi Israel nan pumbaatanda. Ya nidatongdah ad Migdal Eder an linauhanda nan ata'nang an binattu ta hidiy nangiyamman Jacob hi tuldan abung hi nihinanda. ");
INSERT INTO ifb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ya hidin nihinandan den babluy ya hiyay nangelo'an Reuben ay Bilhah an ohah nan ahawan amana. Ya waday nangibaag ay Israel. Hi Israel ya himpulu ta duway imbabaluyna mahkay. ");
INSERT INTO ifb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ti hay imbaluyda ay Leah ya hi Reuben an pangpangullu, ya hi Simeon, ya hi Levi, ya hi Judah, ya hi Issachar, ya hi Zebulun. ");
INSERT INTO ifb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ya hay imbaluyda ay Rachel ya da Joseph ay Benjamin. ");
INSERT INTO ifb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ya hay imbaluyda ay Bilhah an tagalan Rachel ya da Dan ay Naphtali. ");
INSERT INTO ifb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ya hay imbaluyda ay Zilpah an tagalan Leah ya da Gad ay Asher. An aminda hanan imbabaluynan linala'i ya ad Paddan Aram hinan babluy hi ad Mesopotamia di nitungawanda. ");
INSERT INTO ifb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ya la'tot ya dinatngan da Israel hi amanan hi Isaac an nihihinnah din nunhituwan amanan hi Abraham hi ad Mamre an neheggon hi ad Kiriath Arba (unu ad Hebron). ");
INSERT INTO ifb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Hay tawon hi ni'taguan Isaac hi engganah natayana ya hinggahut ta han nawaluy tawona. ");
INSERT INTO ifb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Hiya ya na'alla'ay ya un matoy, at niddum hinan o'ommodna. Ya nan imbabaluynan da Esau ay Jacob di nangilubu' ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hi Esau an mungngadan hi Edom ya hiyatuy holagna: ");
INSERT INTO ifb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Hi Esau ya inahawana nan binabain iCanaan an da Adah an imbaluy Elon an holag Heth, ya hi Oholibamah an imbaluy Anah an hina' Zibeon an holag Heth goh, ");
INSERT INTO ifb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ya hi Basemath an agin Nebaioth an holag Ishmael. ");
INSERT INTO ifb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ya nunholag da Adah ay Esau ta hi Eliphaz. Ya nunholag da Basemath ay Esau ta hi Reuel. ");
INSERT INTO ifb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ya nunholag hi Oholibamah ta da Jeush, ya hi Jalam, ya hi Korah. Didanay holag Esau hidin awadandah ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ya initnud Esau nan a'ahawana, ya nan imbabaluyda, ya an amin nan tataguna, ya nan animalna, ya an amin nan gina'unan wadan hiya ta numbaatdah nan babluy an nidagwin Jacob an agina ");
INSERT INTO ifb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ti do'ol di animaldan hin'agi, at adi umda nan lutadad Canaan hi ihinanda ya pumpahtulanda. ");
INSERT INTO ifb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","At immuy da Esau an mungngadan hi Edom an nunhituh nan dudunduntug ad Seir. ");
INSERT INTO ifb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ya hay nihinandah di ya hiyatuy holag Esau an ommod di i'Edom hidid Seir: ");
INSERT INTO ifb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hay oha ya hi Eliphaz an imbaluyda ay Adah, ya hi Reuel an imbaluydan Basemath. ");
INSERT INTO ifb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ya hay imbabaluy Eliphaz an linala'i ya da Teman, ya hi Omar, ya hi Zepho, ya hi Gatam, ya hi Kenaz. ");
INSERT INTO ifb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Hi Eliphaz an hina' Esau ya inimbaluyanah Timna ta lala'i an hi Amalek. Ya diday a'apun nan ahawan Esau an hi Adah. ");
INSERT INTO ifb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ya hay holag Reuel ya hi Nahath, ya hi Zerah, ya hi Shammah, ya hi Mizzah. Dida nan a'apun da Esau ay Basemath. ");
INSERT INTO ifb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Hay udum hi holag Esau ya da Jeush, ya hi Jalam, ya hi Korah. Hiyanay imbabaluy Esau ay Oholibamah an hina' Anah an hina' Zibeon. ");
INSERT INTO ifb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hiyatuy numpun'ap'apu an holag Esau: Nan pangpangullun hi Eliphaz ya hiyatuy numpun'ap'apun holagnan da Teman, ya hi Omar, ya hi Zepho, ya hi Kenaz, ");
INSERT INTO ifb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ya hi Korah, ya hi Gatam, ya hi Amalek. Didanay a'apun da Esau ay Adah. ");
INSERT INTO ifb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Didatuy numpun'ap'apun holag Reuel hidid Edom an da Nahath, ya hi Zerah, ya hi Sammah, ya hi Mizzah. Ya dida nan a'apun da Esau ay Basemath. ");
INSERT INTO ifb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Hiyanay numpun'ap'apun holag da Oholibamah ay Esau an da Jeush, ya hi Jalam, ya hi Korah. Hiyanay imbabaluy Esau ay Oholibamah an hina' Anah. ");
INSERT INTO ifb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","At dida hanay numpun'ap'apun holag Esau an hi Edom di ohah ngadana. ");
INSERT INTO ifb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Didatu nan holag Seir an holag goh Hor an nunhituh nan babluy ad Seir: Da Lotan, ya hi Shobal, ya hi Zibeon, ya hi Anah, ");
INSERT INTO ifb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ya hi Dishon, ya hi Ezer, ya hi Dishan. Didanay numpun'ap'apuh nan babluy an ad Edom. ");
INSERT INTO ifb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Nan holag Lotan ya da Hori ya hi Homam. Ya hi Timna ya babain pogtang Lotan. ");
INSERT INTO ifb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Nan holag Shobal ya da Alvan, ya hi Manahath, ya hi Ebal, ya hi Shepho, ya hi Onam. ");
INSERT INTO ifb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Nan holag Zibeon ya da Aiah, ya hi Anah an hiyay nangah'up hinan lumahun obob hinan mapulun hidin pumpahpahtulanah nan dongkin amanan hi Zibeon. ");
INSERT INTO ifb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Hay holag Anah ya da Dishon ya han babain hi Oholibamah. ");
INSERT INTO ifb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ya hay holag Dishon ya da Hemdan, ya hi Eshban, ya hi Ithran, ya hi Keran. ");
INSERT INTO ifb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ya hay holag Ezer ya da Bilhan, ya hi Zaavan, ya hi Akan. ");
INSERT INTO ifb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ya hay holag Dishan ya da Uz ay Aran. ");
INSERT INTO ifb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","At didatuy numpun'ap'apun holag Hor an da Lotan, ya hi Shobal, ya hi Zibeon, ya hi Anah, ");
INSERT INTO ifb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ya hi Dishon, ya hi Ezer, ya hi Dishan. ");
INSERT INTO ifb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hiyatuy numpun'alid Edom ya un waday mun'alih nan holag Israel: ");
INSERT INTO ifb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Hi Bela an holag Beor ya nun'alih nan siudad an ad Dinhabah hi ad Edom. ");
INSERT INTO ifb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ya unat goh natoy hi Bela at nihukat hi Jobab an holag Zerah an iBozrah. ");
INSERT INTO ifb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ya unat goh natoy hi Jobab at nihukat hi Husham an iTeman. ");
INSERT INTO ifb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ya unat goh natoy hi Husham at nihukat hi Hadad an holag Bedad an nangabak hinan iMoab ta hiyay nun'ali, at nginadnana nan babluy ta ad Avith. ");
INSERT INTO ifb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ya unat goh natoy hi Hadad at nihukat hi Samlah an iMasrekah. ");
INSERT INTO ifb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ya unat goh natoy hi Samlah at nihukat hi Shaul an iRehoboth an nunhituh neheggon hinan wangwang ta hiyay nun'ali. ");
INSERT INTO ifb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ya unat goh natoy hi Shaul at nihukat hi Ba'al-Hanan an holag Acbor. ");
INSERT INTO ifb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ya unat goh natoy hi Ba'al-Hanan at nihukat hi Hadad. Hay babluyna ya ad Pau, ya hay ngadan ahawana ya hi Mehetabel an holag Matred an hina' Me-Zahab. ");
INSERT INTO ifb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hiyatuy ngadan nan numpun'ap'apun holag Esau an hay ngadanday ningadan hinan babluy an numpun'ap'apuanda: hi Timnah, ya hi Alvah, ya hi Jetheth, ");
INSERT INTO ifb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ya hi Oholibamah, ya hi Elah, ya hi Pinon, ");
INSERT INTO ifb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ya hi Kenaz, ya hi Teman, ya hi Mibzar, ");
INSERT INTO ifb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ya hi Magdiel, ya hi Iram. Didanay numpun'ap'apuh ad Edom an holag Esau. ");
INSERT INTO ifb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ya hi Jacob ya nunhituh nan nunhituwan amanah dih ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ya umat hituy na'na'at hinan holag Jacob. Hi Joseph ya unga an himpulu ta pituy tawona, ya gun mitnud hinan a'aginan inyimbaluy amanan da Bilhah ay Zilpah hinan ayda pumpahtulan hinan animal amana. Mu hiya ya gunna ihudhudol ay amana nan nappuhin ato'aton nan a'agina. ");
INSERT INTO ifb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ya hi Jacob ya pa'appohpohdonah Joseph ya un nan udumnan a'agina ti hiyay udidian hi inyimbaluynah nala'ayana. At impiyammanay ma\"ap'aphod an magayad ya nagullitan hi lubungna. ");
INSERT INTO ifb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ya unat goh ininnilan nan a'aginan hiyay pohpohdon amada ya un dida at nidugah di pangaboholandan Joseph an mid pohod di pi'hapitandan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ya wada han ohan nahdom ya nun'enap hi Joseph, ya inul'ulgudnah nan a'agina nan enenapna, mu undaat goh inyal'allan nangabohol ay hiya ");
INSERT INTO ifb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ti inalinan diday, “Donglonyu ta ulgudo' han enenap'u! ");
INSERT INTO ifb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Hay enenap'u ya mumboto' tu'uh payaw, ya tinnig'un naha\"ad din bento\"u. Ya din bento'yu ya na'amungda, ya lene'wohda din bento\"u, ya nun'iluungdan de han bento\"u!” ");
INSERT INTO ifb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ya inalin nan a'aginay, “Un mah udot he\"ay mun'alin mangipapto' ay da'mi?” At inyal'alladan nangabohol ay hiyan dumalat nan inulgudnan aat nan enenapna. ");
INSERT INTO ifb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ya hi Joseph ya nun'enap goh, ya inalina goh hinan a'aginay, “Wada goh han ohan enenap'u, at donglonyu ta ulgudo' di aatna! Hay enenap'u ya tinnig'u han algaw, ya bulan, ya han himpulu ta ohan bittuan, ya inluungdan ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mu unat goh inulgudna nan enenapnan da amana ya nan a'agina goh ya inhingal amanan inalinay, “Ngadan ne han enenapmun umat hina? Umat ay mah hina ya da'min inam ya nan a'agim ya iluungmin he\"a?” ");
INSERT INTO ifb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ya nan a'agin Joseph ya umapaldan hiya, mu hi amada ya adina al'alliwan heden enenap Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wa han ohan algaw ya immuy nan a'agin Joseph an mumpahtul hi kalnilun amadah ad Shechem. ");
INSERT INTO ifb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ya inalin Jacob ay Joseph di, “Inilam an immuy nan a'agim an mumpahtul hi ad Shechem, at honogo' he\"a ta umuy'ah nan wadanda.” Ya inalin Joseph ay hiyay, “Oo mah, umuya'.” ");
INSERT INTO ifb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ya inalin Jacob ay hiyay, “Tigom nan a'agim ya nan kalniluh un mi'id al'alin dida, ya numbangngad'a ta ipa'innilam ay ha\"in di aatda.” At nakak hi ad Hebron an immuy hi ad Shechem. Ya unat goh dimmatong ad Shechem ");
INSERT INTO ifb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ya mun'annapan an mannig hi awadan nan a'agina. Ya wada han tagun nannig ay hiya, ya inalinay, “Ngadan ne han anapom?” ");
INSERT INTO ifb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ya tembalnan inalinay, “Hay anapo' ya hay wadan nan a'agi' an mumpahtul hinan pahtumi. At un ay ni' inilam di wadanda ya itudum.” ");
INSERT INTO ifb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ya tembal han tagun inalinay, “Nakakdah tu, mu hay dengngol'u ya alyonday unda umuy ad Dothan.” At inunud Joseph nan a'agina, ya inah'upana didah ad Dothan. ");
INSERT INTO ifb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ya unat goh inamang nan a'agin Joseph hiya ya nunhahapitdah atondan mamatoy ay hiya, ");
INSERT INTO ifb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ya alyonday, “Na'uy din emmena'enap! ");
INSERT INTO ifb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","At ma ayu ta patayon tu'u, ya inuhbung tu'uh nan mamagan bitu, ya inali tu'uy un inan di layon. At tigon tu'uy ma'at hinan enenapna!” ");
INSERT INTO ifb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mu unat goh dengngol Reuben ya pohdonan baliwan hi Joseph an inalinay, “Adi tu'u patayon! ");
INSERT INTO ifb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","An hay aton tu'u ya nonong ya inuhbung tu'un te han bitu, mu adi tu'u hugatan!” Ya manu ay inalinay umat hina ta way atonan mamaliw ay Joseph ta iyanamutnan amada. ");
INSERT INTO ifb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ya unat goh nidatong hi Joseph ya impa'udda, ya inaanda nan lubungnan ma\"ap'aphod an magayad, ");
INSERT INTO ifb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ya inyuyda inuhbung hinan bitun mamaga. ");
INSERT INTO ifb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ya unat goh nalpah heden inatda ya inumbundan mangan, ya inamangda han na'uy an nabulog an holag Ishmael an nalpud Gilead ta umuydah ad Egypt. Ya nan kamiluda ya waday nun'itakay an nan mangipapolhat hi mihda ya nan maphod di hunghungnan umat hi myrrh ya lana. ");
INSERT INTO ifb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","At inalin Judah hinan a'aginay, “Undan way pumbalinanah pumhodan tu'uh un tu'u patayon hiya ya inhaut tu'u? ");
INSERT INTO ifb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Un tu'uat ila'u hiyan date han holag Ishmael ta adi tu'u patayon! Ti undan bo'on hi agi tu'u?” At inyabulut nan a'agina. ");
INSERT INTO ifb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ya ginuyuddah nan bitu, ya inihbutdah nan holag Ishmael an ni'bulog hinan mungkumildun iMidian. Ya hay hubutna ya duwampuluh silver, at enekakda ta inyuydah ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ya unat goh numbangngad hi Reuben hinan bitu ya tinnigna, ya mi'id hi Joseph, at pini\"inay lubungna. ");
INSERT INTO ifb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ya numbangngad hinan a'agina, ya inalinay, “Goh ya mi'id han unga? At hay ato' nin?” ");
INSERT INTO ifb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","At genlotday ohah buta'al an gandeng, ya inhawhawda din lubung Joseph hinan dalana, ");
INSERT INTO ifb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ya inyuydan amada, ya inaliday, “Te han inah'upanmin lubung! Tigom ti ini ya lubung han imbaluymu!” ");
INSERT INTO ifb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","At inimmatunana, ya inalinay, “Immannung an lubung Joseph! Adyu'an pinatoy nan layon, ya pinhitnay odol Joseph!” ");
INSERT INTO ifb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","At pini\"in Jacob di lubungnan dumalat di lungdayana, at inlubungnay langgut, ya nabayag di nungnguhuanan de han imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ya an amin din imbabaluy Jacob ya nan inapuna ya numpapanguyda ta pa'amlongonda hiya, mu adi ma'al'alu' an inalinay, “Adia' ma'al'alu'! Munlungdayaa' ta nangamung unna' matoy!” At intultuluynan ngulngungulngulan di aid Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ya unat goh inyuy nan holag Ishmael hi Joseph ad Egypt ya inihbutdan Potiphar an ohah nan upihyal nan ali an ap'apun di mungguwalya. ");
INSERT INTO ifb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Eden gutudna goh di nanaynan Judah nan a'agina ta immuy ni'hituh nan lala'in hi Hirah an i'Adullam. ");
INSERT INTO ifb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ya hidiy nangah'upana han babain imbaluy Shua an iCanaan, ya inahawana. ");
INSERT INTO ifb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","At palpaliwan ya nunhabi, ya nuntungaw, ya lala'i, at nginadnan Judah ta hi Er. ");
INSERT INTO ifb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ya palpaliwan ya nunhabi goh, ya nuntungaw, ya lala'i, at nginadnana ta hi Onan. ");
INSERT INTO ifb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ya nalmu goh di ohah imbaluynah lala'ih din awadandad Kezib, ya nginadnana ta hi Shelah. ");
INSERT INTO ifb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ya impalhin Judah han pangpangullun imbaluynan hi Er ay Tamar. ");
INSERT INTO ifb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mu hi Er ya na\"appuhi ahan hi pannigan Apo Dios hi ugalina, at pinatoyna hiya. ");
INSERT INTO ifb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ya inalin Judah ay Onan di, “Me'yelo\"a ta paddungnay ahawaom din umu'utun an ahawan din agim an hi Er ta wada ay di iyimbaluymu ya ta hanat agim an din natoy ti hiyah ne ugali tu'u tuwali.” At inabulutna. ");
INSERT INTO ifb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mu hi Onan ya inilana an nan iyimbaluyna ya adi mibilang hi holagna, at wa adya ta elo'na nan ahawan Er ya gunna itapal di ipabuhu'nah nan luta ta omod un mi'id malmuh hanat agina. ");
INSERT INTO ifb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ya hene han inatna ya agaga\"ihaw ahan hi pannigan Apo Dios, at pinatoyna hiya goh. ");
INSERT INTO ifb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","At inalin Judah ay Tamar an inapunay, “Mumbangngad'ah abung amam, ya adi'a mumbentan ta hodom ta umel'ellog hi Shelah ta hiyay pumbentanam.” Ya manu ay umat hinay inalina ya un tuma'ot ti mi'id mapto' ya umat hinan a'agina goh! At immanamut mah hi Tamar hi abung da amana. ");
INSERT INTO ifb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Unat goh palpaliwan ya natoy han ahawan Judah an hina' Shua, at nabalu. Ya unat goh nalpah di nabaluana ya immuy hi ad Timnah nan ligwanan hi Hirah an i'Adullam hinan pun'oltandah nan kalniluna. ");
INSERT INTO ifb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ya waday nangalin Tamar hi umuy hi amanah ad Timnah ta umuyna ipa'lot nan kalniluna. ");
INSERT INTO ifb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ya nunhukat hi Tamar ta inaana din inlubungnan balu. Ya nunhu'yung ta adi ma'immatunan, at immuy inumbun hinan way ubunan hinan buhu'an ad Enaim hinan pingit di kalatan mipluy ad Timnah ta hodonah Judah an maluh. Ya manu ay umat hinay inatna ya inilanan immilog hi Shelah, mu agguyda impa'ahawan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ya unat goh tinnig Judah ya alyonah un puta ti nunhu'yung. ");
INSERT INTO ifb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","At immuy ay hiya, ya inalinay, “Ma'a ta molo'ta!” Ti agguyna inilay un hiya din ahawan din imbaluynan natoy. At inalin han babaiy, “Mahapul an waday idatmun ha\"in ya unta malo'.” ");
INSERT INTO ifb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ya inalinay, “Ipiyali' di ukkon an gandeng.” Ya inalin Tamar di, “Abuluto' hene, mu mahapul an waday ipatangmu ta engganay ipiyalim nan ukkon an gandeng.” ");
INSERT INTO ifb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Ya inalin Judah di, “Ngadan ne mah di ipatang'u?” At inalinay, “Ipatangmu nan buungmun natayunan hi hengheng an puntembre ya nan hul'udmu.” At indat Judah nan imbagan Tamar, ya enelo'na hiya. Ya unat goh immanamut hi Tamar ya inaana din inhu'yungna, ya inhu'lubna goh din baluna. Ya palpaliwan ya nunhabih Tamar. ");
INSERT INTO ifb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ya hi Judah ya impiyuynan Hirah an ligwanan i'Adullam din ukkon an gandeng ta alana din impatangna, mu adi pa\"anap hi wadan den babai. ");
INSERT INTO ifb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","At imbagabaganah nan linala'iy wadan din putan muntamtamuh nan timplun di bululdah di an munhohhood hinan pingit di owon ad Enaim. Ya alyonday, “Mi'id di inilamih putah tun muntamuh nan timplun di bulul!” ");
INSERT INTO ifb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ya numbangngad ay Judah, at inalinay, “Adia' pa\"anap hi wadana, ya inalin nan tataguh dih mi'id anuy putah di!” ");
INSERT INTO ifb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ya inalin Judah di, “Bayada' mu mi'id, at ta\"on ya bagina din impatang'u! At maphod ta adi tu'u ituluy an anapon ti abatlan ditu'uh nan tatagu!” ");
INSERT INTO ifb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ya unat goh naluh di tuluy bulan ya waday nangalin Judah di, “Nan inapum an hi Tamar ya numputa, at nunhabi.” At inalin Judah di, “Ekakyu hiyah nan babluy ta gohbonyu ta matoy!” ");
INSERT INTO ifb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ya heden pangekakanda ya impiyuynay hapitnan amanan hi Judah an inalinay, “Nunhabiyona' hinan lala'in ad gina'un te han buung an natayunan hi hengheng an puntembre ya nan hul'ud, at immatunam di ad gina'u.” ");
INSERT INTO ifb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ya unat goh tinnig Judah ya inimmatunana, at inalinay, “Hiyay nepto' di inatna ya un ha\"in ti agguy'u impa'ahawan hiya han imbaluy'un hi Shelah!” At agguy mah impidpidwan Judah an nangelo' ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ya unat goh wan magadyuh an muntungaw hi Tamar ya ma'immatunan an nadugwa han inhabina. ");
INSERT INTO ifb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ya hede han puntungawana ya nahhun an bimmuhu' han ohan ngamay, ya nan mundawat ya gino'danah linubid an mumbolah, ya inalinay, “Hiyah te pangpangulluh nitungaw.” ");
INSERT INTO ifb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mu ininatna han ngamayna, at nihukat an bimmuhu' han ohan duppelna. At inalin han mundawat di, “Impilitmu ta nahhun'an bimmuhu'!” At nangadnan ta hi Perez. ");
INSERT INTO ifb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ya bimmuhu' goh han duppelnan nago'dan di ngamaynah mumbolah an linubid, at nangadnan ta hi Zerah. ");
INSERT INTO ifb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ya hi Joseph ya inyuy nan holag Ishmael hi ad Egypt, ya inla'udan Potiphar an ap'apun di mungguwalyah abung nan Alin hi Pharaoh. ");
INSERT INTO ifb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ya nan abung Potiphar an i'Egypt di hiyay ni'hituwan Joseph. At hi Apo Dios ya impapto'nah Joseph, at hiyaat un pinumhod. ");
INSERT INTO ifb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ya unat goh tinnig Potiphar an hi Joseph ya ipapto' Apo Dios an amin di itamuna ");
INSERT INTO ifb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","at penpenhodna hiya, at nuntagalaonah abungna ta hiyay mangipapto' hinan mumpuntamuh abungna ya an amin nan gina'una. ");
INSERT INTO ifb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ya nete\"an de han nuntamuan Joseph hi abung Potiphar ya winagahan Apo Dios an amin nan wah dih nan abung ya nan wah punhabalanan dumalat hi Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ya hi Potiphar ya ene'kodnan amin nan gina'unan Joseph ta adi mi'bibiyang, an anggay nan ononah nomnomona. Ya hi Joseph ya maphod di pangod'odolna an maphod di alala'ina. ");
INSERT INTO ifb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","At unat goh palpaliwan ya han ahawan Potiphar ya a'amnawanah Joseph, at inalinan hiyay, “Pohdo' hi un'a me'yelo' ay ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mu agguyna inabulut, at inalinay, “Inilam an han ahawam an puntamua' ya ene'kodnan amin di baalna ya gina'unan ha\"in ta ipapto\"u. ");
INSERT INTO ifb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ya nabagtuy biyang'un te han abungyun umat ay hiya, ya mi'id ah agguyna ene'kod ay ha\"in an anggay he\"ah agguy'u ni'biyangan. Ya anaad ta he\"ay dumalat hi pumbahola' hi ongol ay Apo Dios?” ");
INSERT INTO ifb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ya ta\"on hi un itugtugan han ahawan Potiphar hi abigabigat an mangalih molo'da mu himpu'pu'iton damdama Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mu wa han ohan algaw ya hinumgop hi Joseph ta muntamu, ya mi'id ah udumnan baal hi wah di. ");
INSERT INTO ifb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ya impa'ud han ahawan Potiphar hi Joseph an enyedonah lubungna, ya inalinay, “Umali'a ta molo'ta!” Mu limmayaw hi Joseph ta nataynan nan lubungnan ino'odnan han babai. ");
INSERT INTO ifb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ya unat goh ininnilan han ahawan Potiphar an nataynan di lubung Joseph ya timmagtag an pimmitaw, ");
INSERT INTO ifb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ya inayaganay udumnan baalna, ya inalinan diday, “Tigonyuh te han Hudyun inyalin han ahawa' hitu ta bainon ditu'u! Hinumgop ta elo'a' ay hiya, mu numbugawa', ");
INSERT INTO ifb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ya timma'ot, at limmayaw, ya ten nataynan di lubungnah tun wada'!” ");
INSERT INTO ifb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","At intalepona din lubung hi engganay immanamut han ahawana, ");
INSERT INTO ifb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ya inhudhudolnah nan ahawanan inalinay, “Han puntamuom an Hudyun inyalim hitu ya hinumgop hi kuwaltu' ta dapopona'! ");
INSERT INTO ifb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mu unat goh numbugawa' ya timma'ot, ya limmayaw, ya nataynan di lubungnan ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ya unat goh inulgud ahawana ya ma'abbungot hi Potiphar. ");
INSERT INTO ifb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ya impadpapnah Joseph ta impibaludna hiyah nan pangibaludan di alih nan way mumbahol, at hidiy nihihinnana. ");
INSERT INTO ifb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mu hi Apo Dios ya wagwadan Joseph, at nan ap'apuh nan baludan ya ma'ma'ullay ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","At nun'ap'apuwona hiya ta hiyay okod hinan wah baludan. ");
INSERT INTO ifb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","At nan ap'apuh nan baludan ya adina mahapul an tigon nan tamun Joseph ti hi Apo Dios ya wagwadan hiya, ya an amin di inatna ya pinumhod. ");
INSERT INTO ifb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ya unat goh palpaliwan ya han ap'apun di mangidat hi inumon han ali ya han munhaang hi tinapay hi onona ya numbaholda ede han alih ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","At ma'abbungot han alin didan duwa, ");
INSERT INTO ifb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","at imbaludna didah nan baludan an wadan Joseph hinan wadan di abung han ap'apun di baludan. ");
INSERT INTO ifb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ya ene'kod nan ap'apun di baludan didan Joseph, ya intamuana dida. Ya nabayagdah dih baludan. ");
INSERT INTO ifb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ya wada han ohan nahdom ya nundehhandan de han mangidat hi inumon nan ali ya han munhaang hi tinapay an nun'enap. Ya agguy numpaddung di enenapda, ya agguy goh numpaddung di penhodnan ipa'innila. ");
INSERT INTO ifb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ya unat goh nahoyang ya immuy hi Joseph hi wadanda, ya tinnigna didan munlungdayadah punnomnomnomandah nan enenapda, ");
INSERT INTO ifb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","at inalin Joseph di, “Anaad ta umat ayuh na ti paddungnay munlungdaya ayun duwa?” ");
INSERT INTO ifb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ya tembaldan alyonday, “Ihna han enenapmin duwa, mu mi'id ah nanginnilah tuh penhodnan ipa'innila.” At inalin Joseph di, “Hi Apo Dios di mangidat hi abalinan an mangibaag hinan penhod nan enap an ipa'innila! At ngadan ne mah han enenapyu?” ");
INSERT INTO ifb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","At inalin han mangidat hi inumon han ali ay hiyay, “Han enenap'u ya tinnig'u han greyp ");
INSERT INTO ifb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","an tuluy hapangna. Ya tinnig'u, ya bimmuhu' di tubuna, ya bimmunga, ya nalum. ");
INSERT INTO ifb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ya ino'odna' di bahun han ali, at innal'uh de han bungan di greyp, ya penehpeh'u ta timmuduy danumnan de han bahu ta napnu, ya indat'un de han ali.” ");
INSERT INTO ifb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ya inalin Joseph ay hiyay, “Hiyah te penhodnan ipa'innila. Nan tulun hapang ya tuluy algaw di ipa'innilana. ");
INSERT INTO ifb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","At maluh di tuluy algaw at bumuhu\"ah tuh baludan, ya ma'aliwan di baholmu. Ya ibangngad da'ah tamum tuwalin mangidat hi inumon di ali. ");
INSERT INTO ifb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mu pumhod'a ay ya nomnomona' ni', ya inggohgohana' ni' ta ibagam ni' di ngadan'uh nan ali ta badangana' an bumuhu' ete han baludan ");
INSERT INTO ifb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ti unna' inlayaw hidih nan lutan di Hudyu, ya te an imbaluda' hituh ad Egypt hi mi'id bahol'u.” ");
INSERT INTO ifb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ya unat goh dengngol han munhaang hi tinapay an maphod di ipa'innilan han enenap han mangidat hi inumon di ali ya inalinan Joseph di, “Ihna goh han enenap'un inyagtu' han tuluy bahkit an nun'apnuh tinapay, ");
INSERT INTO ifb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ya nan niyuhun an nuntu'yap an bahkit ya hiyay wadan an amin di nihaang hi onon di ali. Mu inan di hamuti nan nittu.” ");
INSERT INTO ifb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ya tembal Joseph an inalinay, “Umat hituy aatna. Nan tulun bahkit ya tuluy algaw di ipa'innilana. ");
INSERT INTO ifb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","At maluh di tuluy algaw at ipabuhu' da'ah nan ali ete han baludan, ya ipaputulnay ulum, ya inha'mangday odolmuh nan ayiw, at onon di hamutiy lamohmu.” ");
INSERT INTO ifb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ya hede han miyatlun algaw ya hiyah de algaw hi punnomnomandah nitungawan han ali, at mahayupda nan u'upihyalna ta mumpaltida. Ya impabuhu'na nan ap'apun di mangidat hi inumona ya nan ap'apun di munhaang hi tinapay. ");
INSERT INTO ifb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ya imbangngadnah de han mangidat hi inumonah nan tamuna tuwali, ");
INSERT INTO ifb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ya impaputulnah de han munhaang hi tinapay. At an amin din inalin Joseph ya na'at. ");
INSERT INTO ifb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mu din mangidat hi inumon han ali ya agguyna ninomnom hi Joseph ti naliwana. ");
INSERT INTO ifb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ya naluh di duway tawon ya nun'enap han Alin hi Pharaoh ad Egypt. Ya hay enenapna ya timmata'dog hinan pingit di Wangwang an Nile. ");
INSERT INTO ifb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ya tinnignan bimmuhu' hinan wangwang han pitun bakan mun'ataba ya mun'aphod di tigawda an mummungmung hinan holo'. ");
INSERT INTO ifb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ya bimmuhu' goh han pitun bakan nun'a'ung'ung an mattig di talagatagda. Ya ne'dellohdah nan mun'ataban bakah nan pingit di wangwang. ");
INSERT INTO ifb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ya nan nun'a'ung'ung an baka ya nun'a'anda nan pitun mun'ataban baka. Ya nalpah hede ya inggibo' han ali. ");
INSERT INTO ifb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ya nolo' goh, ya nun'enap goh. Ya tinnigna han oh'ohhan paguy an pituy lugoynan mun'ataludoy an bobogah ya natong. ");
INSERT INTO ifb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ya timmubu goh han pituy lugoynan nun'a'upoh ti napuo', ");
INSERT INTO ifb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ya nun'a'andah de han pitun bobogah. Ya inggibo' nan Alin hi Pharaoh, ya lene'nanan un nun'enap. ");
INSERT INTO ifb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ya unat goh nawa'ah ya numanomnom han ali, at impa'ayagna nan mummadyik ya nan nun'ala'eng hi ad Egypt. Ya inulgudnan dida din enenapna, mu mi'id nanginnilah aatna. ");
INSERT INTO ifb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","At immuy hinan ali nan mangidat hi inumona, ya inalinay, “Ad ugwan ya ninomnom'uy nibahhawa'! Immannung an agguy'u imbaag nan na'at ay ha\"in ");
INSERT INTO ifb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","an din bimmungtam ay da'min de han munhaang hi tinapay ya impibalud da'mih nan way abung nan ap'apun di baludan. ");
INSERT INTO ifb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ya wa han ohan nahdom ya nun'enap amin duwa. Ya agguy numpaddung di enenapmi, ya agguy goh numpaddung di aatda. ");
INSERT INTO ifb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ya wada han ibbamin ungan Hudyun puntamuon han ap'apun di guwalya ya inulgudmin hiyay aat di enenapmi, at imbaagnay aatda. ");
INSERT INTO ifb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ya nan imbaganan da'mi ya na'at an imbangngada' hi tamu' tuwali, ya impiha'mangmu din munhaang hi tinapay!” ");
INSERT INTO ifb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","At impa'ayag mah han Alin hi Pharaoh hi Joseph, at nunnaudondan nangipabuhu' ay hiyah nan baludan. At ginidgidanay hamayna, ya nunhukat hi lubungna, ya immuy hinan wadan di ali. ");
INSERT INTO ifb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ya inalin han alin hiyay, “Wada han enenap'u, mu mi'id nanginnilah aatna. Ya dengngol'un alyondah un he\"ay way abalinanan mangibaag hi aat di enap.” ");
INSERT INTO ifb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ya tembal Joseph an inalinay, “Apu Ali, mi'id abalina', mu hi Apo Dios di way abalinanan mangibaag hi ipa'innilan nan enenapmu!” ");
INSERT INTO ifb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","At inalin nan Alin hi Pharaoh di, “Nun'enapa', ya timma'doga' hinan pingit di Wangwang an Nile, ");
INSERT INTO ifb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ya tinnig'u, ya bimmuhu' han pitun mun'ataba ya mun'aphod di tigawdan bakah nan wangwang, ya mangmangandah nan holo'. ");
INSERT INTO ifb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ya bimmuhu' goh han pitun bakan nun'a'ung'ung an mattig di talagatagda. Ya mi'id ahan ah umat hinan na\"appuhih tinnig'uh tud Egypt! ");
INSERT INTO ifb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ya nan nun'a'ung'ung an baka ya inanda din mun'ataban baka, ");
INSERT INTO ifb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","mu nundoda damdama din odolda an nappuhiy tigawda. Ya nalpah hede ya inggibo\"u. ");
INSERT INTO ifb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ya nun'enapa' goh, ya tinnig'u han paguy an pituy lugoynan nun'ataludoy an bobogah, ya natong, ya un ohay puunah timmubuanda. ");
INSERT INTO ifb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ya timmubu goh han pituy lugoynan nun'a'upoh ti napuo'. ");
INSERT INTO ifb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ya hanan nun'a'upoh ya nun'a'anda dade han bobogah. Ya imbaga' date han enenap'uh nan mummadyik, mu mi'id ah nanginnilah aat nan enenap'u.” ");
INSERT INTO ifb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ya inalin Joseph hinan aliy, “Nan duwan enenapmu ya un ohay ipa'innilana. Ya manu ay ya ta ipa'innilan Apo Dios ay he\"ay atonah udum hi algaw. ");
INSERT INTO ifb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nan ipa'innilan han pitun mun'ataban baka ya nan pituy lugoynan bobogah ya pituh tawon di pumhodan di mihabal. Dane ya numpaddung di ipa'innilada. ");
INSERT INTO ifb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nan ipa'innilan han pitun nun'a'ung'ung an bakan niyangunuh an bimmuhu' ya nan pituy lugoynan nun'a'upoh ti napuo' ya ipa'innilanay pituh tawon an batel. ");
INSERT INTO ifb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","At hiyah te din inali' an un impattig Apo Dios ay he\"ay atonah udum hi algaw ");
INSERT INTO ifb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ti waday pituh tawon an do'ol di ma'an an amin hitun abablubabluy ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mu unat goh malpah hene ya waday pitu goh hi tawon an batel. At ma'aliwan nan pituy tawon an ado'ol di ma'an hi ad Egypt ti nidugah ahan di aton nan batel hinan abablubabluy. ");
INSERT INTO ifb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","At mi'id ah panginnilaan hinan ado'ol di ma'an ti han batel ya nunhegla. ");
INSERT INTO ifb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ya manu ay numpidwa'an nun'enap oo ti hi Apo Dios di ad planu, at immannung an ma'at an adi madnoy! ");
INSERT INTO ifb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","At hay atom, Apu Ali, ya mumpili'ah tagun nala'eng ya nanomnoman ta hiyay mangipapto' hinan ma'an hitud Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ya piliom goh di udumnah tatagu ta amungonday mun'iyalemah nan mabto' hinan abablubabluy hituh ad Egypt ete han pituy tawon an ado'ol di ma'an ");
INSERT INTO ifb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ta na'amung ay nan ma'an ya nun'iyalangdah nan abablubabluy ya impaguwalyada. ");
INSERT INTO ifb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ya manu ay hiyah ne maphod hi aton tu'u oo ta waday ma'an hi un umali han pitun tawon an batel hituh ad Egypt, ya ta adi tu'u mun'atoy an dumalat nan batel.” ");
INSERT INTO ifb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ya inabulut nan ali ya an amin nan udumnan a'ap'apunay inalin Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","At inalin nan alin diday, “Mi'id inila' hi udumnah umat ay Joseph hi nanomnoman an waday Na'abuniyanan an Lennawan hiya!” ");
INSERT INTO ifb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","At inalin nan alin Joseph di, “He\"ay nangipa'innilaan Apo Dios ete, at na'innilan mi'id di udum hi umat ay he\"ay nanomnomana. ");
INSERT INTO ifb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","At he\"ay pange'koda' hi mumpapto' ete han babluy an pumpapto'a' ta an amin di tatagu ya unudondan amin nan imandalmu. At nan haadmu ya na'abbagtu, ya ha\"in ya anggay di nabagbagtu ya un he\"a ti ha\"in di ali. ");
INSERT INTO ifb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","At mete\"ad ugwan ya he\"ay munggobelnadol hituh ad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","At linuh'ub nan Alin hi Pharaoh di henghengnan puntembre, ya inhu'lubnah galaygay Joseph ta hiyay mangipa'innilah anabagtun di haadna, ya impilubungnay ma\"aphod ya magayad an lubung, ya impibuungnay balitu' ay hiya, ");
INSERT INTO ifb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ya indatna nan kalesan punluganan di mi'gubat ta hiyay mehnod hinan ali ta lugana. At nunlugan hi Joseph, at pun'it'u' nan nangipangpangulun alyonday, “Ipattigyuy pange'gonanyun Joseph!” At hi Joseph mah di pento' nan alih gobelnadol hi ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","At inalin goh han alin hiyay, “Ta\"on un ha\"in di ali mu adim ay iyabulut di pangatan nan tataguh pohdondan aton hitud Egypt, ya adi mabalin an atonda.” ");
INSERT INTO ifb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ya nginadnanah Joseph hi ngadan di i'Egypt ta hi Zaphenath-Paneah, ya impalhina ay Asenath an han imbaluy Potiphera an padid On. At hi Joseph ya lene'odnan amin nan abablubabluy hi ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ya tulumpuluy tawonah din nangete\"anan nuntamuh nan pumpapto'an nan alid Egypt. Ya hiya ya empongna nan abablubabluy an lene'od. ");
INSERT INTO ifb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ya hede han pitun tawon ya immannung an hiyay nido'lan di ma'an. ");
INSERT INTO ifb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","At impa'amung Joseph nan udumnah nan ma'an ta impiyalangnah nan impiyamman di gubilnu an alang hinan gagwan di abablubabluy. ");
INSERT INTO ifb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ya do'ol ahan nan ma'an an impiyalang Joseph an adida pa'abbilang ti umat hi ado'ol nan panag hi pingit di baybay. ");
INSERT INTO ifb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ya hi Joseph ya duway imbabaluyna ay Asenath an hina' Potiphar an padid On ya un madatngan di batel, ");
INSERT INTO ifb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ya nginadnana nan pangpangullu ta hi Manasseh ti inalinay, “Hi Apo Dios ya impa'aliwnay ligat'u ya nan numanomnoma' ay da aman hina\"ama!” ");
INSERT INTO ifb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya nginadnana nan miyadwan imbaluyna ta hi Ephraim ti inalina goh di, “Hi Apo Dios ya indatnay netob an holag'uh nan lutan nunholtapa' hi ligat!” ");
INSERT INTO ifb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ya hede han pitun tawon an ado'ol di ma'an hi ad Egypt ya napogpog, ");
INSERT INTO ifb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","at nete\"a nan pitun tawon an batel an din inalin Joseph. At waday batel hinan numbino'ob'on an abablubabluy, mu nan abablubabluy hi ad Egypt ya mun'olog di ma'an ti do'ol di niyalang. ");
INSERT INTO ifb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mu unat goh napuhan nan tataguh ad Egypt hi ma'an ya immuyda mumbagah nan Alin hi Pharaoh hi ononda, mu inalin nan ali ay diday, “Umuy ayun Joseph ta nan inalina ya hiyay unudonyu!” ");
INSERT INTO ifb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ya unat goh nunhi'mut din batel hi ad Egypt ya impibughul Joseph nan a'ala'alang ta inla'uda nan paguy hinan i'Egypt ti nunhegla din batel. ");
INSERT INTO ifb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ya nan tataguh nan alutaluta ya immuydan luma'uh ma'an hi ad Egypt ti dumalat din batel hi an amin hi alutaluta. ");
INSERT INTO ifb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ya unat goh dengngol Jacob an waday ma'an hi ad Egypt ya inalinah nan imbabaluynay, “Anaad ta un ayu muntoto\"olan hi atonyu? ");
INSERT INTO ifb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Dengngol'un waday bogah hi ad Egypt, at umuy ayu ta ekayu luma'uh onon tu'u ta adi tu'u matoy hi hinaang tu'u!” ");
INSERT INTO ifb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","At nan himpulun a'agin Joseph ya immuydah dih ad Egypt ta luma'uhdah bogah. ");
INSERT INTO ifb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mu hi Jacob ya agguyna impitnud han agin Joseph an hi Benjamin ay dida ti tuma'ot ti ini ya waday nappuhi goh hi ma'at ay hiya! ");
INSERT INTO ifb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ya nan imbabaluy Jacob ya ni'yuydah nan udumnan umuy luma'uh ma'an ti nabtel ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ya hi Joseph di gobelnadol hi ad Egypt, at hiyay luma'uan an amin di tataguh nan abablubabluy. Ya unat goh dimmatong nan a'agin Joseph ya inluungdah nan hinagangna ta ipattigday pange'gonandan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ya unat goh tinnig Joseph nan a'agina ya inimmatunana dida, mu ay ihuna kud di agguyna inila dida. At enlotnan mangalin diday, “Hay nalpuwanyu?” At tembaldan inaliday, “Nalpu amid Canaan, ya immali amih tu ta luma'u amih ma'an.” ");
INSERT INTO ifb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ya ta\"on hi un inimmatunan Joseph nan a'agina mu agguyda inimmatunan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ya ninomnom Joseph din enenapnah ma'at ay dida, at inalinan diday, “Un ayu man nin munhi'im ta innilaonyuy atonyun mangabak ay da'mi!” ");
INSERT INTO ifb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ya tembaldan alyonday, “Adi umat hina, Apu Gobelnadol! Da'mi an mibilang hi baalmu, ya immali amin luma'uh ma'an! ");
INSERT INTO ifb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","At adim alyon hi un ami munhi'im ti da'mi ya hina\"agi ami an un ohay hi amami, ya adi ami munlayah!” ");
INSERT INTO ifb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ya inalin Joseph goh ay diday, “Layahyu ti immannung an un ayu immali munhi'im!” ");
INSERT INTO ifb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","At alyonday, “Da'mi, Apu, ya himpulu ta duwa amin imbabaluy di ohah taguh ad Canaan hidin hopapna. Nan udidianmi ya wah di ay amami, mu nan ohan agimi ya nami'id.” ");
INSERT INTO ifb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ya tembal Joseph an inalinay, “Immannung nan inali' an un ayu munhi'im! ");
INSERT INTO ifb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","At hiyah te panginnilaa' hi un immannung nan inaliyu: ihapata' hinan ngadan nan Alin hi Pharaoh an adi ayu ahan umanamut ta engganay un umali nan udidianyuh tu! ");
INSERT INTO ifb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","At nan ohan da'yu ya mahapul an umuy ta awitona nan udidianyu. Ya da'yun udumna ya mibalud ayuh engganay innilao' hi un immannung nan inaliyu. Ti adiyu ay ya immannung an un ayu munhi'im! At heten alyo' ya immannung an ihapata' hinan ngadan nan Ali tu'un hi Pharaoh!” ");
INSERT INTO ifb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","At impibaludna didah tuluy algaw. ");
INSERT INTO ifb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ya heden miyatlun algaw ya inalin Joseph ay diday, “Ha\"in ya e'gona' hi Apo Dios, at matagu ayuh unyu unudon han alyo' ");
INSERT INTO ifb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ti ma'ahhapul an innilao' hi un ayu adi munlayah an tatagu. At mahapul an waday ohan da'yuh mataynan hinan baludan, ya nan udumnan da'yuy umuy ta iyanamutyu nan ma'an an lina'uanyu ta adi ma'ulat nan tinaynanyu. ");
INSERT INTO ifb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mu mahapul di iyaliyuh tu nan udidianyu ta panginnilaa' hi un immannung nan imbagayu ta adi da'yu ipapatoy.” At inabulutda. ");
INSERT INTO ifb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ya nunhahapitdan hina\"agin alyonday, “Hiyah te amoltaan tu'u ti dimmalat din inat tu'uh din agi tu'un hi Joseph ti tinnig tu'uy punligligatana, ya pumpahpahmo'anan ditu'u, mu un tu'u ay napu'it an agguy tu'u enehmo'an hiya! At hiyanan umat hituy punligatan tu'u!” ");
INSERT INTO ifb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ya inalin Reuben ay diday, “Inali' tuwalin da'yuy adi ayu mange'el hi atonyun hiya, mu adia' tuwali dongdonglon ay da'yu! At hiyanan ad ugwan ya miballoh mah ay ditu'uy nami'idana!” ");
INSERT INTO ifb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mu agguyda inilay un na'awatan Joseph nan nunhahapitanda ti hidin ni'hapitandan hiya ya waday nangibalin hi hinapitda. ");
INSERT INTO ifb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ya tinaynan Joseph dida an umuy kumila ya un goh mumbangngad an mi'hapit ay dida, ya impabobodnah Simeon ta titiggon nan a'agina. ");
INSERT INTO ifb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","At munhonag hi Joseph ta umuy nan baalnan mangittuh bogah hinan langgutda, ya inalina ta ibangngadda nan pihhun nunla'uda ta pun'itu'yapdah nan langgutda, ya indadaananda didah balundah nan owon. At hiyah ne inatda, ");
INSERT INTO ifb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","at nun'itakayda nan ma'an an lina'uandah nan dongkida, at nakakda. ");
INSERT INTO ifb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ya hidih immiyananda ya teneb'ag din ohay langgutna ta alanay ipa'anah dongkina, ya tinnigna din pihhunan nitu'yap hinan langgutna, ");
INSERT INTO ifb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","at inalinah nan a'aginay, “Imbangngadda man nan pihhu' an tayan nitu'yap hi langgut'u!” At ma'ama'atta'otda, ya munwigwigdah ta'otdan alyonday, “Ngadan te han inat Apo Dios ay ditu'u?” ");
INSERT INTO ifb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ya unat goh immatamdad Canaan ya inulguddan amadan amin di na'at ay didan alyonday, ");
INSERT INTO ifb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nappuhi nan panaphapit nan gobelnadol ay da'mi an alyonah un ami anu munhi'im ede han babluy! ");
INSERT INTO ifb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mu inalimin hiya an adi ami munhi'im, ya adi ami munlayah an tatagu! ");
INSERT INTO ifb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ti da'mi ya himpulu ta duwa amin hina\"agi, mu nami'id di ohan da'mi, ya nan udidianmi ya wah di ay amamih ad Canaan! ");
INSERT INTO ifb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ya inalin nan gobelnadol ay da'miy, Hiyah te panginnilaa' hi un ayu adi munlayah an tagu: mahapul an mataynan di ohan da'yu ta nan udumnan da'yuy umuy ta iyanamutyu nan ma'an an lina'uanyu ta adi ma'ulat nan tinaynanyu. ");
INSERT INTO ifb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ya iyaliyuy udidianyun ha\"in ta innilao' an adi ayu munhi'im an da'yu ya nahamad di aatyun tatagu. Ya ibo'tan'u han agiyun nibalud, ya mabalin an gun ayu umalin luma'uh ononyu.” ");
INSERT INTO ifb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Unat goh inubaddan amin di bobod di langgutda ya tinnigda din pihhudan punla'udan nun'itu'yap! At ma'ama'atta'otda, ya immat goh ay amada. ");
INSERT INTO ifb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ya inalin amadan hi Jacob di, “Unyu mah pohdon hi un mami'id an amin nan imbabaluy'u? Hi Joseph di nahhun hi nami'id, ya ten mi'id goh hi Simeon, ya ten alyonyu goh di itnudyuh Benjamin! Un ha\"in ahan di agogohgoh an uminguhu!” ");
INSERT INTO ifb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ya inalin Reuben ay amanay, “Gulat ta mi'id ibangngad'un hiya ya nan duwan linala'in imbabaluy'uy pangibalham, at patayom dida! At e'kodmun ha\"in, at ibangngad'un he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mu inalin Jacob di, “Adi mi'yalin da'yud Egypt! Ti han ibana ya nami'id, ya anggay hiyah na'angang ti unda duwan inyimbaluy'un Rachel! Ya ten nala'aya', at gulat ta way ma'at ay hiyah nan owon at un man ammunan ne, ya inyatoy'uh numanomnoma'!” ");
INSERT INTO ifb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nunhegla ahan din batel hidid Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","At unat goh impuh da Jacob an hina\"ama din ma'an an lina'uandah ad Egypt ya inalin Jacob hinan imbabaluynay, “Mumbangngad ayu ta umuy ayu luma'u goh hi onon tu'u.” ");
INSERT INTO ifb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ya inalin Judah ay hiyay, “Ama, nan lala'ih di ya inhamhamadnan nangalin da'mi an adi ami mumpattig ay hiyah unmi adi itnud han udidianmi! ");
INSERT INTO ifb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","At iyabulutmu ay an mi'yali han udidianmin da'mi ya un mabalin an umuy ami luma'uh ma'an. ");
INSERT INTO ifb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mu adim ay iyabulut ya adi ami umuy ti inalin han lala'ih diy adi ami mipattig ay hiyah unmi adi itnud han udidianmi!” ");
INSERT INTO ifb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ya inalin Jacob di, “Anaad tuwali ta inaliyuy un waday udidianyu ta omodnah un ha\"in di panomnonomnomonyu?” ");
INSERT INTO ifb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ya tembaldan alyonday, “Oo ti nan lala'i ya gunna hanhanan ditu'un hina\"ama an ibaganay un'a matagu! Ya ibagana goh hi un ihnay udumnah a'agimi! Ya immannung an mahapul an tobolonmi nan ibagana! Ya unmi dan inilah unna alyon di mahapul an itnudmi han udidianmi?” ");
INSERT INTO ifb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ya inalin Judah ay amanay, “Pi'yaliom hi Benjamin ta ipadehmi ta adi tu'u matoy hi hinaang tu'u an ta\"on nan imbabaluymi! ");
INSERT INTO ifb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ya ha\"in di okod ay hiyah engganah iyanamut'un mi'id ma'at ay hiya! Ya gulat ay ta way ma'at ay hiya ya ha\"in di pangipabaholam hi enggana! ");
INSERT INTO ifb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ya gulat ta agguy ami nataktak at numpidwa ami nin an numbangngad!” ");
INSERT INTO ifb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ya inalin amadan diday, “Un ay gahin ahan un mi'yali han agiyu at umidagah ayuh nan mun'aphod an bungah tun numbabluyan tu'u ta odnanyu ta idatyuh nan gobelnadol! Ya umdon ayu goh hi danum di alig, ya nan mapolhat di tamtamna an ma'alih pistachio ya almonds. ");
INSERT INTO ifb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ya dublionyuy pihhuh odnanyu ta ibangngadyu din pihhu ti mid napto' ya unda nahemong, ");
INSERT INTO ifb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ya itnudyu han udidianyu, ya nabanangngad ayu. ");
INSERT INTO ifb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","At okod hi El-Shaddai an hi Apo Dios an abalinanan amin di logom an mangdat hi homo'nan da'yu ta pi'yanamutona da Simeon ay Benjamin! Ya gulat ta way ma'at ay dida ya undan way ma'amuyuan an mid abalinan!” ");
INSERT INTO ifb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","At nan hina\"agi ya inodnanda nan midat hinan gobelnadol ya nan pihhun dinubliday bilangna, ya immuydan amin hi ad Egypt, ya nitnud goh hi Benjamin. Ya wan dimmatongdah di ya immuydan mi'hapit ay Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ya unat goh tinnig Joseph hi Benjamin an nitnud ay dida ya impa'ayagna nan tagalan mangipapto' hi abungna, ya inalinay, “Itnudmu daten linala'ih abung'u ta mumpalti'a, ya indadaanmu ta me\"andan ha\"in hi munggawa.” ");
INSERT INTO ifb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ya inat nan tagalay inalinan hiya, at initnudna nan hina\"agih abung Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Heden umayandah abung Joseph ya ma'ama'atta'otda ti alyondah nomnomday, “Iyuy ditu'uh abungna ti dumalat nin din pihhun nibangngad hi langgut tu'uh din hopapna! Ya hiyay pangiga'idandan mangat hi nappuhin ditu'u, at alanda nan dongki tu'u, ya numbalinon ditu'uh baal!” ");
INSERT INTO ifb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ya unat nidatongdah nan pantaw di abung Joseph ya inalidah nan baal an mumpapto' di, ");
INSERT INTO ifb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Apu, immali amih din hopapnan limma'uh ma'an, ");
INSERT INTO ifb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","mu unat goh impadehmi ta immuy amih nan dalan hinan immiyananmi ya teneb'agmi din langgutmi, ya way ohaon tinnigna din pihhunan nun'itu'yap! At te an inodnanmi ta ibangngadmin he\"a! ");
INSERT INTO ifb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ya inodnanmi goh di pihhuh punla'umih ma'an, ya agguymi inilay nangibangngad an nangittuh nan pihhuh nan langgutmi!” ");
INSERT INTO ifb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ya inalin de han tagalay, “Adi ayu numanomnom, ya adi ayu tuma'ot ti nan Dios an dayawonyu an Dios goh nan o'ommodyuy nangittuh pihhuh nan langgutyu ti nan numbayadyuh bogah ya innal'uh de.” Ya unat goh nalpah hede han inalina ya inyuynah Simeon ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ya impahigupna dida, ya indatnay danum ta pangihudah hu'ida, ya immuyna pinangan di dongkida. ");
INSERT INTO ifb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ya nan a'agin Joseph ya indadaanda nan midat ay hiya ta idatdah un umalih munggawa ti nipa'innilan me\"andan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ya unat goh immanamut hi Joseph ya indatda nan midat ay hiya, ya inluungda ta ipattigday pange'gonandan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","At ibaganan diday, “Kumusta ayu? Ya hay aat ta'wa amayun ma'ma'ilog an din inulgudyun ha\"in? Olom ni' ya adaogna!” ");
INSERT INTO ifb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ya tembaldan alyonday, “Maphod hi amami, ya wah di an matagu.” At nunhippidah nan hinagangna ta e'gonanda hiya. ");
INSERT INTO ifb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ya unat goh tinnig Joseph han aginan hi Benjamin ya inalinan diday, “Hiyah te mah di udidianyun din inulgudyun ha\"in?” Ya alyonday, “Oo.” At intuluy Joseph an inalinay, “Hi Apo Dios di mangipapto' ay he\"an unga!” ");
INSERT INTO ifb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Unat goh inalinah de ya ma\"aliy lugwanah punnomnomnah nanniganah nan agina, at immuy hi kuwaltunan lumugwa. ");
INSERT INTO ifb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ya unat goh nalpah an inihuanay angahna ya bimmuhu', at pintutnay kilana, ya inalinay, “Ibanawyu ta mangan tu'u.” ");
INSERT INTO ifb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ya hi Joseph ya nilahhin an nangan hinan ohan lamehaan, ya nilahhin goh nan a'aginan nangan hinan ohan lamehaan, ya nan i'Egypt an me\"an ya nilahhinda goh ti hay nomnomonda ya mipa'ampay adayawandah unda me\"an hinan Hudyu. ");
INSERT INTO ifb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ya nan hina\"agi ya inumbundan ni'haggangandan Joseph, ya nahayhaynoddan inumbun an nete\"ah pangpangulluh engganah udidian. At unat goh tinnigday inatdan nangipabun ay dida ya nuntitiggawanda ti manoh'ada. ");
INSERT INTO ifb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ya inilpudah nan lamehaan Joseph nan ma'an ta indatanda didan amin, mu hi Benjamin ya numpalemay ado'ol nan ma'an an nidat ay hiya ya un nan a'agina. Ya unat goh nagibuhda ya intuluy da Joseph an hina\"agin mangin'inum hi pun'am'amlonganda. ");
INSERT INTO ifb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hi Joseph ya immandalnah nan mumpapto' hi abungnan inalinay, “Ittuwam nan langgutdah ma'an hinan mun'olog hi odnanda, ya imbangngadmuy pihhun pun'itu'yap hinan ma'an hinan langgutda, ");
INSERT INTO ifb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ya intu'yapmu nan silver an bahu' hinan bogah nan udidian ta middum nan pihhunan nunla'una.” At inatna nan inalin Joseph ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ya unat goh nabiggat hi helhelong ya nun'itakayda din ma'an an lina'uandah nan dongkida, ya impadehdan makak. ");
INSERT INTO ifb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ya agguyda immadagwih nan siudad ya inalin Joseph hinan mumpapto' hi abungnay, “Unudom nan linala'i ta ah'upam ay dida ya alyom di, Anaad ta un maphod di nangat nan gobelnadol ay da'yu ya atonyuy nappuhi? ");
INSERT INTO ifb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Anaad ta inakawyu nan silver an bahun pun'inumana an mumbuyun? Hete han inatyu ya ongol hi numbaholanyu!” ");
INSERT INTO ifb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ya unat goh inah'upana dida ya imbagana nan inalin Joseph ay dida. ");
INSERT INTO ifb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ya tembaldan alyonday, “Apu, anaad ta umat hinay panapitmun da'mi? Mi'id man ahan di inatmih umat hina! ");
INSERT INTO ifb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Inilam ahan an imbangngadmi nan pihhun inah'upanmin nun'itu'yap hinan langgutmin inilpumid Canaan! At anaad mah ta mangakaw amih nan silver unu balitu' hinan abung nan gobelnadol? ");
INSERT INTO ifb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Gulat ta waday ohan da'mih ma'ah'upan hi nangngal ya mipapatoy, ya maphod goh ta pumbalinom hi baalmu da'min udum!” ");
INSERT INTO ifb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ya inalinay, “Oo mah, abuluto' hene, mu nan ma'ah'upan hi nangngal di mumbalin hi baal, ya da'yun udum ya umanamut ayu.” ");
INSERT INTO ifb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","At an aminda ya nunnaudondan nun'ohop din langgutda, ya tenep'agna. ");
INSERT INTO ifb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","At nan pumpapto'on Joseph hi abungna ya inhamhamadnan anapon an ente\"anah nan langgut nan pangpangulluh engganah nan langgut nan udidian. At nan bahu ya na'ah'upan hi langgut Benjamin. ");
INSERT INTO ifb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ya nan hina\"agi ya nunhekhekday lubungdah lungdayada, at pun'ikalgada din inodnandah nan dongkida ta ibangngaddah nan siudad. ");
INSERT INTO ifb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ya unat goh dimmatong da Judah ya nan a'aginah abung Joseph ya wah dih Joseph pay an agguy nakak, at munhippidah nan hinagangna. ");
INSERT INTO ifb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ya inhingal Joseph didan inalinay, “Hay inatyu? Dan agguyyu inilan nan tagun umat ay ha\"in ya abalinanan mumbuyun ta innilaonay nangakaw?” ");
INSERT INTO ifb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ya tembal Judah an inalinay, “Apu Gobelnadol! Agguymi inilay alyonmin he\"ah panginnilaam an agguymi inat! Mu ten hi Apo Dios di nangipattig hi numbaholanmin baalmu, at da'min amin ya mumbalin amih baalmu an bo'on nan na'ah'upan nan bahu ya anggay!” ");
INSERT INTO ifb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ya inalin Joseph di, “Adi umat hina! Nan nangngal hi bahu' ya anggay di baal'u, ya da'yun udum ya umanamut ayun amayun mi'id al'alin da'yu!” ");
INSERT INTO ifb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ya nahlig an neheggon hi Judah ay Joseph, ya inalinay, “Apu Gobelnadol! He\"a ya umat'a ay Pharaoh an ali, mu iyabulutmu ni' ta pahapitona', ya adi'a ni' bumungot! ");
INSERT INTO ifb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ti hay imbagam ay da'mi, Apu, ya inalim di, Wada mah hi amayu unu nan a'agiyu? ");
INSERT INTO ifb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ya inalimiy, Ihnah amamin nala'ay ya nan ohan udidianmin inyimbaluynah nala'ayana. Han agin ne han udidianmi ya nami'id, at anggay hiyah na'angang hi holag inada. Ya hi amami ya pa'appohdona ahan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ya inalim ay da'mih iyalimi hiyah tu ta tigom. ");
INSERT INTO ifb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ya inalimin he\"ay, Henen udidianmi ya adi mabalin hi unna taynan hi amami ti gulat ta taynana at ammunan ne, ya inyatoy amami! ");
INSERT INTO ifb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ya inalim ay da'min baalmuy, Adi ayu mipattig ay ha\"in hi engganay itnudyu nan udidianyu! ");
INSERT INTO ifb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","At immanamut ami, ya inulgudmin amami nan inalim. ");
INSERT INTO ifb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mu unat goh napuh din lina'uanmin ma'an ya inalina goh di, Mumbangngad ayun umuy luma'uh onon tu'u. ");
INSERT INTO ifb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mu alyonmin hiyay, Adi ami umuy ti adi mabalin hi mipattig amin de han lala'ih engganay mitnud han udidianmi! ");
INSERT INTO ifb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ya inalin amamiy, Inilayun un duddugway inyimbaluy'uh nan ohan ahawa', ");
INSERT INTO ifb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","mu nan oha ya tinaynana', ya alyo' di un nin inan di layon ti mi'id mumbangbangngad. ");
INSERT INTO ifb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","At gulat ta mitnud heten ohan da'yu ta waday ma'at ay hiyaat unyu udman di punlungdayaa'! Ya undan adi la'tot ya natoya' ti ten nala'aya'? ");
INSERT INTO ifb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ya gulat ta mumbangngada' ay ama ya mi'id nitnud hinan udidianmi ");
INSERT INTO ifb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ta tigona ta mi'id at hiyay dumalat hi punlungdayaanah iyatoyna! ");
INSERT INTO ifb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ti inali' ay amay, Ha\"in di okod ete han udidianmi. Ya gulat ta mi'id mi'bangngad ay hiya ya ha\"in di pabaholom hi enggana. ");
INSERT INTO ifb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","At Apu, ha\"in ni' di mataynan hi mumbalin hi baalmu ta mihukata' hinan udidianmi ta hiyay pi'yanamutom hinan a'agi'! ");
INSERT INTO ifb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ti hay ato' an umanamut hi un adi mitnud han udidianmin ha\"in? Immannung an adi' ma'anuhan an tigon di ma'at ay ama an dumalat hi aid nan udidianmi!” ");
INSERT INTO ifb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ya adi pa\"edpol hi Joseph hi le'nana, at nunhonagna nan baalnan i'Egypt ta pumitawda ta unda ang'anggay an hina\"agih na'angang, at impa'innilanay niyatanan dida. ");
INSERT INTO ifb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ya ma'ama'akidyol, at dengngol nan i'Egypt, at immuyda impa'innilah nan ali. ");
INSERT INTO ifb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ya inalin Joseph hinan a'aginay, “Ha\"in hi Joseph! At wah na mah hi ama tu'un matagu?” Ya unat goh dengngol nan a'aginah de han inalina ya namoldah ta'otda! ");
INSERT INTO ifb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ya inalin Joseph ay diday, “Mahmahlig ayu ta meheggon ayun ha\"in!” At wan nahligda ya inalin Joseph di, “Immannung an ha\"in hi agiyun hi Joseph an din inihbutyu ta inyalia' hitud Egypt! ");
INSERT INTO ifb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mu adiyu pabaholon di odolyuh nangihbutanyun ha\"in ti hi Apo Dios di nangipiyun'unnan ha\"in ta ibaliw'u nan tatagu ta matagudan te han batel ");
INSERT INTO ifb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ti un miyadwah tawon ya anggay ad ugwan an batel, ya ihna pay di lemay tawon hi agguy hi adi tummolan di mitanom, at mi'id ma'an. ");
INSERT INTO ifb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","At hi Apo Dios di nangipiyun'unnan ha\"in hitu ta way ato' an mangibaliw ay da'yu ya nan holagyu! ");
INSERT INTO ifb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","At bo'on da'yuy nangipiyalin ha\"in hitu ti hi Apo Dios! Hiyay nangidat hi nabagtuh haad'un miyadwah nan ali ta ha\"in di mangipapto' hinan nunhituwana, ya ha\"in goh di gobelnadol an amin hitud Egypt! ");
INSERT INTO ifb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","At mumbangngad ayun ama, ya alyonyun hiyay, Hiyah te inalin han imbaluymun hi Joseph an inalinay, Hi Apo Dios ya nun'ap'apuwona' hi ad Egypt, at punnaudom an umalih tun ha\"in! ");
INSERT INTO ifb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ta hidih ad Goshen di punhituwanyu ta meheggon'an ha\"in, ya umat goh hinan imbabaluymu, ya nan a'ap'apum, ya nan animalmu, ya an amin nan wadan he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ya ta hidiy ihinam ta way ato' an manalimun ay he\"a ti ihna pay di umalih lemay tawon hi batel, ya adi' pohdon an mahinaangan'a, ya nan pamilyam, ya nan animalmu!” ");
INSERT INTO ifb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ya intultuluynan inalinay, “Ad ugwan ya an amin ayu an ta\"on he\"a goh, Benjamin, ya immatunana' an ha\"in hi Joseph! ");
INSERT INTO ifb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","At ipa'innilayun amay anabagtun di haad'uh tud Egypt ya an amin nan tinnigyu, at punnaudonyun mangiyalin hiyah tu!” ");
INSERT INTO ifb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ya unat goh nalpah an himmapit ya nun'agwalandan Benjamin, ya kimmiladan duwa. ");
INSERT INTO ifb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ya heden lumanulugwaana ya immuyna empong nan a'aginan inawal ta nalpah ya ni'hahapitda nan a'aginan hiya. ");
INSERT INTO ifb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ya unat goh dengngol nan ali ya nan udum an a'ap'apu an immali nan a'agin Joseph ya ma\"am'amlongda. ");
INSERT INTO ifb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","At inalin nan Alin hi Pharaoh ay Joseph di, “Alyom hinan a'agim ta pun'iluganda nan bogah hinan dongkida ya unda ipadeh an umuy ad Canaan ");
INSERT INTO ifb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ta awitondah amayu ya nan pamilyada ta mumbangngaddah tu. Ya idat'un dida nan ma\"ap'aphod an lutah tud Egypt, at adida mapuhan hi ononda. ");
INSERT INTO ifb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ya alyom goh ay dida ta ummaldah lugan hitud Egypt ta pangiluganandah nan a'ahawada, ya nan ung'ungungnga, ya hi amayu. ");
INSERT INTO ifb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ya maphod hi unda adi nomnomnomon nan gina'udan taynanda ti nan ma\"aphod an lutah tud Egypt ya bagida.” ");
INSERT INTO ifb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","At inat nan imbabaluy Jacob nan inalin han ali ti indat Joseph ay diday luganda ya balundah nan owon. ");
INSERT INTO ifb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ya indatana goh didan hinohhah punhukatan hi lubung, mu hi Benjamin ya indatnay lemay lubung ya han tuluy gahut hi silver an pihhu. ");
INSERT INTO ifb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ya impiyuynay bagin amadah himpuluy manilhig an dongkih nungkalgah nan do'ol an mun'aphod hidid Egypt, ya himpulu goh an obay hi nungkalgah nan do'ol an ma'an an umat hi wheat, ya tinapay, ya nan udumna goh ta balun da Jacob hi ayandah ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","At honagona nan a'agina ta umuyda, ya inalinan diday, “Adi ayu humanohongngel hinan owon!” ");
INSERT INTO ifb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","At tinaynandad Egypt ta umanamutdah wadan amadad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ya unat goh nidatongda ya inalidan amaday, “Matagu pay hi Joseph! An hiyay gobelnadol hi ad Egypt!” Mu hi Jacob ya agguyna ahan kinulug, ya paddungnay nakapuy di punle'nana. ");
INSERT INTO ifb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mu unat goh inulguddan amin din inalin Joseph ay dida ya tinnigna nan lugan an impadon Joseph ta punlugananan umuy ad Egypt ya unna mahkay kulugon nan inulgudda. ");
INSERT INTO ifb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ya inalinay, “Hene ni' ta han imbaluy'un hi Joseph ya matagu gayam, at mahapul ahan an umuy'u tigon hiya ya unna' matoy!” ");
INSERT INTO ifb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ya indadaan da Israel an amin nan odnanda, ya impadehda ta negpongdad Beersheba, ya ene'nongnay onongnan Apo Dios an dayawon goh amanan hi Isaac. ");
INSERT INTO ifb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","At heden nahdom ya paddungnay nun'enap hi Israel hidin ni'hapitan Apo Dios an inalinay, “Jacob! Jacob!” Ya tembalna an inalinay, “Wah tua', Apu.” ");
INSERT INTO ifb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","At inalin Apo Dios di, “Ha\"in hi Apo Dios an dayawon amam. Adi'a tuma'ot an umuy ad Egypt ti pa'ongolo' nan holagmuh di, ");
INSERT INTO ifb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ya wagwadaa' ay da'yuh umayanyuh di, ya Ha\"in goh di mangibangngad hinan holagmuh tuh udum hi algaw. Ya hi Joseph di mannig ay he\"ah un'a matoy.” ");
INSERT INTO ifb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ya unat goh nakak hi Jacob ad Beersheba ya inlugan nan imbabaluy Jacob hi amada, ya inyuyda hiya, ya nan ung'ungungnga, ya nan a'ahawada. ");
INSERT INTO ifb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ya ni'bunagda nan animalda, ya nan gina'udan inaladad Canaan ya inyuydad Egypt. At immuydan amin da Jacob ");
INSERT INTO ifb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ya nan holagnan linala'i ya binabai. ");
INSERT INTO ifb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","At hiyatuy ngadan di holag Israel an immuy hi ad Egypt: Hi Reuben an pangpangullu, ");
INSERT INTO ifb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ya nan imbabaluynan da Hanok, ya hi Pallu, ya hi Hezron, ya hi Calmi. ");
INSERT INTO ifb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ya hi Simeon, ya nan imbabaluynan da Jemuel, ya hi Jamin, ya hi Ohad, ya hi Jakin, ya hi Zohar, ya hi Shaul an imbaluynah nan babain iCanaan. ");
INSERT INTO ifb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ya hi Levi, ya nan imbabaluynan da Gershon, ya hi Kohath, ya hi Merari. ");
INSERT INTO ifb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ya hi Judah, ya nan imbabaluynan da Er, ya hi Onan, ya hi Shelah, ya hi Perez, ya hi Zerah. (Mu da Er ay Onan ya natoydad Canaan ya un umuy da Jacob ad Egypt.) Ya nan imbabaluy Perez an da Hezron ya hi Hamul. ");
INSERT INTO ifb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ya hi Issachar, ya nan imbabaluynan da Tola, ya hi Puah, ya hi Jashub, ya hi Shimron. ");
INSERT INTO ifb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ya hi Zebulun ya nan imbabaluynan da Sered, ya hi Elon, ya hi Jahleel. ");
INSERT INTO ifb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hiyatuy imbabaluy Jacob ay Leah hi ad Paddan Aram an agguy ni'bilang han babain imbaluydan hi Dinah. Ya tulumpulu ta tuludan amin di holagdan Leah. ");
INSERT INTO ifb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ya hi Gad, ya nan imbabaluynan da Zephon, ya hi Haggi, ya hi Shuni, ya hi Ezbon, ya hi Eri, ya hi Arodi, ya hi Areli. ");
INSERT INTO ifb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ya hi Asher ya nan imbabaluynan da Imnah, ya hi Ishvah, ya hi Ishvi, ya hi Beriah, ya han babain hi Serah. Ya nan imbabaluy Beriah an da Heber ay Malkiel. ");
INSERT INTO ifb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hiyatuy holag Jacob ay Zilpah an din tagalan indat Laban ay Leah an imbaluyna, ya himpulu ta onomdan amin. ");
INSERT INTO ifb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ya han duwan linala'in imbabaluy da Jacob ay Rachel an da Joseph ay Benjamin. ");
INSERT INTO ifb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ya hi ad Egypt ya duway imbaluy Joseph ay Asenath an han imbaluy Potiphera an padid On an da Manasseh ay Ephraim. ");
INSERT INTO ifb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ya nan imbabaluy Benjamin an da Bela, ya hi Beker, ya hi Ashbel, ya hi Gera, ya hi Naaman, ya hi Ehi, ya hi Rosh, ya hi Muppim, ya hi Huppim, ya hi Ard. ");
INSERT INTO ifb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Date nan himpulu ta opat an holag da Jacob ay Rachel. ");
INSERT INTO ifb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ya hi Dan, ya han imbaluynan hi Hushim. ");
INSERT INTO ifb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ya hi Naphtali ya nan imbabaluynan da Jahziel, ya hi Guni, ya hi Jezer, ya hi Shillem. ");
INSERT INTO ifb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Datey pitun holag Jacob ay Bilhah an din tagalan indat Laban ay Rachel an imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","At hay bilang an amin di holag Jacob an immuy hi ad Egypt ya nanomda ta onom an agguy ni'bilang nan binabain a'ahawan nan imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ya gulat ta middum da Joseph an hina\"ama ya napitudan amin. ");
INSERT INTO ifb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ya unat goh wan magadyuhdah ad Goshen ya impangun'unnan Jacob hi Judah ta ibaganan Joseph ta itudunay umayandad Goshen. ");
INSERT INTO ifb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ya nilugan hi Joseph hinan kalesana ta immuyna dinamuh amanah ad Goshen. Ya unat goh dinamuna dida ya inyawal Joseph ay amana, ya kimmilakila. ");
INSERT INTO ifb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","At inalin Jacob ay Joseph di, “Mabalin hi matoya' mahkay ad ugwan ti tinnig'u he\"a, ya matagu'a!” ");
INSERT INTO ifb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ya inalin Joseph hinan a'agina ya didan hina\"amay, “Mahapul an umuya' ta alyo' hinan Alin hi Pharaoh an immali nan a'agi' ya an amindan hina\"aman wad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ya ipa'innila' goh ay hiyan da'yu ya waday ipahtulyu, at inyaliyuy animalyu ya an amin goh di gina'uyu. ");
INSERT INTO ifb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ya wa adya ta ayagan da'yuh nan Alin hi Pharaoh ta ibagana ay di tamuyu ");
INSERT INTO ifb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ya mahapul hi alyonyuy, Un ami mumpahtul an nete\"ah a'ung'ungungngami an ta\"on din a'apumi. Ya manu ay alyonyuh ne ta way atonan mangiyabulut ta munhitu ayud Goshen ti dida an i'Egypt ya ongol di agguyda namenhodan hinan mumpahtul.” ");
INSERT INTO ifb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","At hi Joseph ya initnudnay lemah nan a'agina ta immuydah nan Alin hi Pharaoh. Ya nahhun hi Joseph an hinumgop, ya inalinay, “Hi ama ya nan a'agi' ya immalidan nalpudah ad Canaan, ya inta'inda nan animalda ya an amin di gina'uda, at ihnadah ad Goshen.” At inayagana nan a'agina ta impa'innilana didah nan ali. ");
INSERT INTO ifb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ya inalin nan aliy, “Ngadan ne tamuyu?” Ya tembaldan alyonday, “Apu Ali, da'min baalmu ya un ami mumpahpahtul an umat hidin a'apumi. ");
INSERT INTO ifb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ya immali amih tun babluyyu ta mi'hitu ami ni' ti hidih ad Canaan ya nunheglay batel, at mi'id ahan di pangipahtulanmih animalmi. At un ay ni' mabalin ya iyabulutmu ahan ta munhitu amih ad Goshen.” ");
INSERT INTO ifb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ya inalin han Alin hi Pharaoh ay Joseph di, “Maphod ta dimmatong hi amam ya nan a'agim! ");
INSERT INTO ifb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","At nan lutah tud Egypt ya ene'kod'un he\"a, at punhituwom hi amam ya nan a'agim hinan ma\"ap'aphod an lutah did Goshen. Ya wadada ay di abalinanan mumpahtul ya e'kodmun dida nan animal'u.” ");
INSERT INTO ifb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","At inawit goh Joseph hi amanan hi Jacob, ya inyuynah nan Alin hi Pharaoh ta impa'innilana. Ya winagahan Jacob han ali. ");
INSERT INTO ifb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ya inalin nan Alin hi Pharaoh ay hiyay, “Atnay tawonmu?” ");
INSERT INTO ifb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ya tembal Jacob an inalinay, “Ha\"in ya hinggahut ya han tulumpuluy tawon'ud ugwan. Ya nunhegla ahan di impaluh'uh ligat. Hete han tawon'u ya nahnot an adi umat hidin a'apu' an adu\"oy di tawon hi ni'taguanda.” ");
INSERT INTO ifb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ya winagahan goh Jacob han ali ya un makak. ");
INSERT INTO ifb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","At nunhituwon Joseph hi amana ya nan a'aginah ad Egypt, ya indatna nan ma\"ap'aphod an lutah nan munisipyuh ad Rameses an din inalin han ali. ");
INSERT INTO ifb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","At hi Joseph di nangidat hi mun'olog hi onondan amin an hina\"ama, ya nidatandah ma'an hi mahapulda. ");
INSERT INTO ifb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ya nan batel ya nunhegla ahan ti mi'id ah ma'an, at la'tot ya na'ulat nan tatagud Egypt ya ad Canaan. ");
INSERT INTO ifb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","At hinayup Joseph an amin nan pihhun nunla'un nan i'Egypt ya nan iCanaan hi ma'an, ya inyuynah abung han ali. ");
INSERT INTO ifb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ya unat goh napuh di pihhun nan i'Egypt ya nan iCanaan ya immuyda damdaman Joseph, ya inalidan hiyay, “Idatan da'mi ni' ahan hi ononmi! Ti undan adi da'mi igohgohan an ten matoy amih hinaangmi ti mi'id ahan an napuh di pihhumih ila'umi?” ");
INSERT INTO ifb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","At tembal Joseph an inalinay, “Iyaliyuy animalyuh un napuh di pihhuyu ta hiyay ihukatyuh ononyu.” ");
INSERT INTO ifb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","At inyuydan Joseph nan animalda, at indatnan diday onondan hukat nan kabayuda, ya kalniluda, ya gandengda, ya bakada, ya dongkida, at heden tawon ya indat Joseph di ma'an an inhukatnah nan animalda. ");
INSERT INTO ifb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ya heden nitawonana ya immuyda goh nan tatagun hiya, ya inaliday, “Apu Gobelnadol, at hay atonmi mah an mi'id ahan pihhumi ya animalmi ti napuh an inla'umin he\"a? At mi'id ahan na'angang an anggay di odolmi ya nan lutami! ");
INSERT INTO ifb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","At igohgohan da'mi ni' ta adi ami matoy hi hinaangmi! Adim ni' hintigtiggon nan lutamin mi'id nitanom! Onaynah un da'miy hubuton ta mumbalin amih himbut nan ali! At pola'om nan lutami ta lutan nan ali ta idatan da'mih ononmi ni' ta mi'tagu ami! Ya indatan da'mi goh hinan mitanom ta lia'onmi nan luta ta adi matawan.” ");
INSERT INTO ifb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","At lina'uan Joseph an amin nan lutad Egypt ti an amin nan tatagu ya nun'ila'uda nan lutada ti nunhegla din batel. At an amin di alutalutad Egypt ya bagin mah nan Alin hi Pharaoh, ");
INSERT INTO ifb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ya an amin nan tatagud Egypt ya numbalinon goh Joseph hi himbut nan alida. ");
INSERT INTO ifb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ya anggay nan lutan di papadidah agguyna lina'uan, ya manu ay agguyda inla'u ti gun indat nan aliy ononda. ");
INSERT INTO ifb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","At inalin Joseph hinan tataguy, “Tigonyu an ad ugwan ya himbut'u da'yu, ya penla\"u nan lutayu ta bagin nan ali. At hay meho' ya idat'u, at umuyyu lia'on nan luta, ");
INSERT INTO ifb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","mu madatong ay ya mahapul an idatyuy miyalemah dagwan nan ali, ya nan ma'angang ya hiyay pangngalanyuh itanomyu ya hay ononyun hina\"ama.” ");
INSERT INTO ifb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ya inaliday, “Apu Gobelnadol, tinagu da'mi! At mun'amlong amin mumbalin hi himbut nan ali!” ");
INSERT INTO ifb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","At inyamman Joseph di uldin an wa adya ta na'ala nan nihabal ya indat nan tatagud Egypt nan miyalemah nan bento'da ta dagwan nan ali. At engganad ugwan ya heten uldin ya atondad Egypt, mu anggay nan lutan han papadida di agguy numbalin hi lutan nan ali. ");
INSERT INTO ifb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ya nan holag Israel ya nunhitudad Egypt hidid Goshen, ya immadangyanda, ya dimmo'ol di holagda. ");
INSERT INTO ifb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","At hi Jacob ya himpulu ta pituy tawon hi ni'hituwanad Egypt, ya hay tawona ya un matoy ya hinggahut ya han napat ta pitu. ");
INSERT INTO ifb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ya unat goh wan magadyuh an matoy hi Israel ya impa'ayagna han imbaluynan hi Joseph, ya inalinan hiyay, “Hay ibaga' ay he\"an imbaluy'u ya eh'am hi ulpu', ya ihapatam an ipattigmuy pamhodmu ya nan gohgohmun ha\"in hi unna' matoy ta adia' ilubu' hituh ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Matoya' ay ya enekaka' hitud Egypt ta ilubu'a' hinan nilubu'an nan o'ommod'u.” Ya tembal Joseph an inalinay, “Oo, ato' nan inalim, ama.” ");
INSERT INTO ifb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ya inalin Jacob di, “Ihapatam an atom!” At inhapatan Joseph. Ya hi Jacob ya inyungyungnah nan ullugwan di olo'ana, ya dinayawnah Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Agguy nadnoy di naluh ya waday nangipa'innilan Joseph an hi amana ya nundogoh. At initnudna nan duwan imbabaluynan da Manasseh ay Ephraim ta immuyda indungaw hi Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ya unat goh dengngol Jacob an immali da Joseph ya intulidnan bimmangon, ya inumbun hinan olo'ana. ");
INSERT INTO ifb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ya inalin Jacob ay Joseph di, “Hi El-Shaddai an hi Apo Dios an abalinanan amin di logom ya numpattig ay ha\"in hi ad Luz hidid Canaan, ya winagahana', ");
INSERT INTO ifb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ya inalinay, Ha\"in ya do'lo' ahan di holagmu ta diday mumbalin hi do'ol an numbino'ob'on an ahimpahimpangapu, ya dida goh di pangidata' ete han luta ta lutadah enggana. ");
INSERT INTO ifb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","At he\"a, Joseph, nan duwan imbaluymun da Ephraim ay Manasseh an nitungaw hitud Egypt ya unna' umali ya ibilang'u didah imbabaluy'u ta boltanonda nan tawid'un umat ay da Reuben ay Simeon. ");
INSERT INTO ifb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mu wada ay di udumnah metob ay didah imbabaluymu ya hay pangngalandah boltanonda ya malpun da Ephraim ay Manasseh. ");
INSERT INTO ifb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ya manu ay ato' hitu ti dumalat hi nunlungdayaa' ay inam an hi Rachel an natoy hidid Canaan hidin magadyuh tu'ud Bethlehem hi nalpuwanmid Paddan Aram. At inlubu\"u hiyah nan pingit di owon an miyuy hi ad Ephrath (unu ad Bethlehem), ya diday paddungnay mipallog ay hiya.” ");
INSERT INTO ifb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ya unat goh tinnig Jacob nan duwan imbabaluy Joseph ya inalinay, “Ngadan date han linala'i?” ");
INSERT INTO ifb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ya tembal Joseph an inalinay, “Didatuy imbabaluy'un indat Apo Dios ay ha\"in hitud Egypt.” At inalin Jacob di, “Iyalim hitu ta wagaha' dida.” ");
INSERT INTO ifb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mu adi umday pannig Jacob ti nala'ay. At inheggon mah Joseph nan imbabaluynan hiya, ya inawalna dida, ya inungnguna. ");
INSERT INTO ifb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ya inalin Jacob ay Joseph di, “Agguy'u inilah un at hituy ma'at an tigon da'a! Mu maphod ta ad ugwan ya inyabulut Apo Dios, at ta\"on nan a'apu' an imbabaluymu ya te an tigo'!” ");
INSERT INTO ifb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ya nan duwan imbabaluy Joseph an wah ulpun apuda ya innal Joseph, ya inluungnan nundayaw ay hiyah luta. ");
INSERT INTO ifb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ya inhinan Joseph hi Ephraim hinan way wadhong Jacob, ya inhinanah Manasseh hinan way agwana, ya inheggon Joseph didan amana. ");
INSERT INTO ifb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mu numpa'telon Jacob di ngamayna ta enyeh'anah ulun han udidian an hi Ephraim di agwana, ya enyeh'anah ulun nan pangpangullun hi Manasseh di wadhongna. ");
INSERT INTO ifb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","At winagahanah Joseph an inalinay, “Hi Apo Dios an dayawon nan o'ommod'un da Abraham ay Isaac an nanalimun ay ha\"in hi engganad ugwan ");
INSERT INTO ifb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","an nan Anghel an namaliw ay ha\"in hi an amin hinan nappuhin na'at ay ha\"in di Hiyay munwagah ay date han ung'ungungnga. At diday manginaynayun hinan ngadan'u ya ngadan nan o'ommod'un da Abraham ay Isaac. Ya munholagda ta dumo'ol di holagdah tun luta.” ");
INSERT INTO ifb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ya unat goh tinnig Joseph an hay ulun Ephraim di nangeh'aanah agwana ya agguyna penhod. At lina\"uynay ngamay amanah ulun Ephraim ta ipeh'anah ulun Manasseh, ");
INSERT INTO ifb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ya inalinan amanay, “Ama, adi umat hina ni' di atom ti hiyah te di pangpangullu, at hiyay pangeh'aam hi agwanmu!” ");
INSERT INTO ifb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mu inyadin amanan inalinay, “Inila', la'ay. Hi Manasseh ya dumo'ol di holagnan ammunah himpamabluy, mu hi Ephraim ya nabagbagtu, ya do'do\"ol di holagna ya un hiya.” ");
INSERT INTO ifb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","At winagahan Jacob dida eden algaw an inalinay, “Nan holag Israel ya bugwaonday ngadanyuh unda munwagah an alyonday, Hi Apo Dios ya wagahan da'yun umat ay da Ephraim ya hi Manasseh.” At hinunnanan binugway ngadan Ephraim ya un hi Manasseh. ");
INSERT INTO ifb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ya inalin Jacob ay Joseph di, “Tigom ten magadyuh an matoya', mu hi Apo Dios ya wagwadan da'yu, at Hiyay mangibangngad ay da'yuh nan lutan di a'apuyu. ");
INSERT INTO ifb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","At nan malumong an lutan ad Shechem an hay pana ya hanggap di namuhul'uh nan himpampun an holag Amor ya he\"ay pangidata' ta bo'on nan a'agim ti immannung an he\"ay mumpapto' ay dida.” ");
INSERT INTO ifb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hi Jacob ya impa'ayagna an amin nan imbabaluyna ta ibaganay ma'at ay didah udum hi algaw. ");
INSERT INTO ifb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ya unat goh na'amungda ya inalin Jacob ay diday, “Da'yun imbabaluy'u, donglonyuy ibaga' an hi amayun hi Israel! ");
INSERT INTO ifb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","He\"a, Reuben an pangpangngullu, he\"ay nahhun hi nalmuh din amabi'ah'u, ya he\"ay nabagbagtuy haadna, ya ongol di abalinanan da'yun hina\"agi. ");
INSERT INTO ifb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mu adi'a matugun an umat hinan humibun luwag di danum, at adi minaynayun di anabagtum ti enelo'muy ohah nan ahawa' ta binaina'. ");
INSERT INTO ifb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ya da'yu, Simeon ay Levi, ya numpaddung di aatyu ti da'yu ya impa'enghayun un hay matadom di o'odnanyun un ayu dumaladalat. ");
INSERT INTO ifb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","At ha\"in an hi amayu ya adi' ahan iyunnud hinan ato'atonyun dumalat hinan amabmabbungotyu, ya pimmatoy ayu, ya ta\"on un nan bakan ma'usal hi bangkag an mun'aladu ya pinilayyu. ");
INSERT INTO ifb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","At da'yu ya ma'idutan ayun dumalat nan bungotyun atata'ot ti mi'id homo'yu! At iwa'at'u nan holagyuh nan lutan di Israel ta miwa'at ayun himpangapu. ");
INSERT INTO ifb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","He\"a, Judah, ya nan a'agim ya ipabagtu da'a ta he\"ay e'gonanda, ya abakom an amin nan binuhulmu, ya munhippi nan a'agim ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ya umat'ah nan ma'abbi'ah an layon an abakom nan binuhulmu, ya malenggop'an umat hinan layon an nalpah ay an pinatoyna nan binuhulna ya numbangngad an malenggop hinan ipo\"oyana. Ya umanina'inat ya un mali'uh ya tuma'otdan mamangon ay hiya. ");
INSERT INTO ifb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","At he\"a, Judah, ya nan holagmuy munnononnong an mun'alih engganah umali nan Ap'apu ta Hiyay unudon di atagutagu. ");
INSERT INTO ifb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ya ta\"on unmu eg'od nan dongkim hinan ma\"ap'aphod an wa'al nan greyp ta pun'a'anay udumna ya do'do\"ol damdamay greyp hi ononyu, ya ta\"on unmu pumba'ba'an di danum di greyp ya do'do\"ol damdamay greyp hi inumonyu. ");
INSERT INTO ifb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ya nan matam ya bubumlah hi ado'ol di inumom an bayah, ya nan babam ya pumahapaha' an dumalat nan ado'ol di inumom an gatas. ");
INSERT INTO ifb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","He\"a, Zebulun, ya munhitu'ah nan pingit di baybay ta da'yuy ad lutah nan way duma'alan di pupul an hay igad ya engganah dih ad Sidon. ");
INSERT INTO ifb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ya he\"a, Issachar, ya umat'ah nan mabi'bi'ah hi dongkin mali'uh hinan gagwan di pungkalgaan ");
INSERT INTO ifb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ti he\"a ya malia\"a an wa ay ta tigom ta malumong nan luta ya maphod hi pun'eblayan, ya intutulidmun muntamu, ya na'na'unnud'a ti penhodmuy mid al'ali. ");
INSERT INTO ifb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ya he\"a, Dan, ya he\"ay mumpanuh ay da'yun himpangapun umat hinan udum an holag Israel ta mipattig hi un way amaphodanda unu bo'on. ");
INSERT INTO ifb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ya umat'ah nan atata'ot an ulog hinan pingit di owon an wa adyay maluh an kabayu ya himbumagga ya inalatnay hu'ina ta magah nan nitakay.” ");
INSERT INTO ifb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ya inalin Jacob di, “Apo Dios, hohoddo' di pannagam hinan bumaliw!” ");
INSERT INTO ifb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ya intuluy Jacob an himmapit an inalinay, “He\"a, Gad, ya mi'id di ta'otmuh nan ohan battalion di tindalu ti wa adyay tumalupa ya numpudugmu dida. ");
INSERT INTO ifb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ya he\"a, Asher, ya malmuy do'ol hi mun'aphod an ma'an hinan ihabalmu an mabalin hi onon di aliy udumna ti malumong nan lutayu. ");
INSERT INTO ifb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ya he\"a, Naphtali, ya umat'ah nan nibo'tan an ulhan nawaya, ya mun'aphod di aat nan imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ya he\"a, Joseph, ya umat'ah nan mamungan nitanom an manaphapang hinan way obob. ");
INSERT INTO ifb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ya ta\"on un nunheglay pangat nan binuhulmun he\"an pun'ipdugday panadan he\"a ");
INSERT INTO ifb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","mu nala'la'eng'an mamanan dida ti ipabi'ah da'ah nan ongol di abalinanan Dios an dayawon Jacob, ya hiyah ne Dios an manalimun hinan holag Israel, ");
INSERT INTO ifb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ya nan mabi'ah an Dios din o'ommodmuy bumadang ya mungwagah ay he\"ah wagah an malpud abuniyan, ya nan bunol di lutan umat hi danum, ya nan do'ol an binabain malpuh nan holagmu. ");
INSERT INTO ifb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ya hatun wagah'un he\"an middum nan wagah nan o'ommod'u, ya nahamhamad ya un nan maphod an malpuh nan aduntuduntug. At pumhod'a, ya malmun amin di mahapulmu, ya he\"ay mawagahan hi umat hina an dumalat nan anabagtum hinan a'agim. ");
INSERT INTO ifb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ya he\"a, Benjamin, ya umat ah nan ahuh inalahan an gahin ahan unna patayon nan pi'pattoyna, ya nun'a'anah nan mahoyang, ya ginogodwanah nan mapuyaw.” ");
INSERT INTO ifb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hiya hanay nunwagah Jacob ay didan himpulu ta duwan holagna an miyunnudan hi aatda. ");
INSERT INTO ifb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ya hi Jacob ya inalina goh ay diday, “Magadyuh di umaya' an middum hinan o'ommod'u. At matoya' ay ya ilubu'a' hinan lubu' ama hinan lingab hidih nan lutan Ephron an holag Heth ");
INSERT INTO ifb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","hi ad Machpelah hi potto' di buhu'an di algaw hi ad Mamre hidid Canaan. Ya hete han luta ya hay lina'uan apun hi Abraham ay Ephron ta ilubu'andan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ya hiyah de di nangilubu'andan Abraham ya din ahawanan hi Sarah, ya hiyah de goh di nangilubu'andan Isaac ya din ahawanan hi Rebekah, ya ta\"on hi Leah ya hidi goh di nangilubu'a'. ");
INSERT INTO ifb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","At nan luta ya nan lubu' ya napla' ay Ephron an holag Heth.” ");
INSERT INTO ifb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ya unat goh nalpah hi Jacob an ni'hapit hinan imbabaluyna ya nundopag hinan nolo'ana, ya natoy. ");
INSERT INTO ifb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ya hi Joseph ya len'omnah amana, ya inungnguna, ya kimmila. ");
INSERT INTO ifb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ya inalin Joseph hinan mun'agah ta imbalsamalonday odolna. At inatda, ");
INSERT INTO ifb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ya napat di algaw hi nun'imbalsamalandan hiya ti hiyah ne mahapul ya un ma'imbalsama nan odol. Ya inya'adamal nan i'Egypt hi napituy algaw. ");
INSERT INTO ifb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ya unat goh nagtud di nangiya'adamalanda ya inalin Joseph hinan puntamuon han aliy, “Umuy ayu ni' hinan Alin hi Pharaoh, ya inaliyuy, ");
INSERT INTO ifb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Hidin magadyuh matoy hi ama ya impihapatanan ha\"in ta ilubu\"u hiyah nan lubu' an indadaanah ad Canaan, ya inhapata' di ato'. At ibagayu ta iyabulutna ni' ta umuy'u ilubu' hi ama ya unna' mumbangngad.” ");
INSERT INTO ifb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ya inyabulut han alin inalinay, “Umuy'a ta ilubu'muh amam ta unudom nan impihapatanan he\"a.” ");
INSERT INTO ifb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","At immuy da Joseph ta ayda ilubu' hi amana, ya nitnuddan hiya nan puntamuon nan alih abungna, ya nan a'ap'apun nan abablubabluy hi ad Egypt, ");
INSERT INTO ifb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ya nitnud goh nan pamilyana, ya nan i'ibana, ya nan pamilyan amana, ta anggay nan ung'ungungnga ya nan do'ol an animalday nataynan hi ad Goshen. ");
INSERT INTO ifb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ya nun'itnudda nan titindalu an numpunlugan hi kalesa ya nan numpungkabayu, at do'oldan immuy. ");
INSERT INTO ifb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ya unat goh immatamdah nan pun'elekandah ad Atad an potto' di buhu'an di algaw hinan Wangwang an Jordan ya enlotdan nun'ebel ay Jacob, ya pinungpungdah pituy algaw ti hiyah ne ugalida. ");
INSERT INTO ifb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ya unat goh tinnig nan tatagun nunhituh dih ad Canaan nan tatagun mun'ebel ya inaliday, “Anakkayah an nidugah di pangat tun i'Egypt an mun'ebel!” At hiyanan nginadnanda hede han lugal ta Abel Mizraim. ");
INSERT INTO ifb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","At inat nan imbabaluy Jacob din inalin amada ");
INSERT INTO ifb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","an inyuydah ad Canaan ta inlubu'dah nan lingab hidid Machpelah an potto' ad Mamre an lutan lina'uan Abraham ay Ephron an holag Heth. ");
INSERT INTO ifb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ya unat goh inlubu' da Joseph hi amada ya numbangngad hi ad Egypt an didan amin hidin a'agina ya din nitnud an mangilubu' ay Jacob. ");
INSERT INTO ifb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ya unat goh nalpah an inlubu'dah amada ya inalin nan a'agin Joseph di, “Mid napto' ya abohlan ditu'un Joseph ta iballohna din nappuhin inat tu'un hiya!” ");
INSERT INTO ifb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","At nunhonagdah mangalin Joseph hi, “Hidin atagun ama tu'u ya alyonan ");
INSERT INTO ifb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","da'miy, Alyonmin he\"a ta aliwam ni' di numbaholan nan a'agim ay he\"a, at ad ugwan ya aliwam ni' di numbaholanmin baal Apo Dios an dayawon amam!” Ya unat goh dengngol Joseph hene ya munlulugwa. ");
INSERT INTO ifb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","At immuy nan a'aginan hiya, ya inyungyungdah nan way hinagangna, ya inaliday, “Ihtu ami ta mumbalin amih baalmu!” ");
INSERT INTO ifb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mu inalin Joseph ay diday, “Adi ayu tuma'ot! Ti undan ha\"in di Dios ta moltao' da'yu? ");
INSERT INTO ifb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ta\"on hi inatyuy nappuhin ha\"in mu hi Apo Dios ya numbalinonah maphod ta do'olday nabaliwan hi batel! ");
INSERT INTO ifb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","At adi ayu tuma'ot ti halimuna' da'yu ya nan imbabaluyyu!” Ya inhapihapitan Joseph dida, at munlenot di punnomnomda. ");
INSERT INTO ifb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Da Joseph ya nan pamilyan amana ya innaynayundan ni'hituh ad Egypt, ya nuntawon hi hinggahut ya han himpulu ya un matoy hi Joseph. ");
INSERT INTO ifb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ya natubayan ta tinnignay imbabaluy Ephraim, ya nan ap'apun Ephraim, ya nan imbabaluy goh Makir an imbaluy Manasseh ya hina'liha'lina didah din pa\"itungawanda. ");
INSERT INTO ifb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ya inalinah nan a'aginay, “Magadyuh matoya', mu hi Apo Dios di manalimun an mangekak ay da'yu ete han luta ta iyuy da'yuh nan lutan intulagnan da Abraham, ya hi Isaac, ya hi aman hi Jacob!” ");
INSERT INTO ifb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ya nunhapataon Joseph nan imbabaluy Israel an inalinay, “Ihapatayun ha\"in di wa adya ta iyuy da'yun Apo Dios ede han luta ya pi'yodonyu nan tungal'u.” ");
INSERT INTO ifb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","At natoy hi Joseph hi ad Egypt hidin nuntawon hi hinggahut ya han himpulu, ya inimbalsamada hiya, ya inlungunda.");
INSERT INTO ifb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Hiyatuy ngadan nan imbabaluy Jacob (an hay oha goh hi ngadana ya hi Israel), ya didan amin an himpangapu di immuy hi ad Egypt: ");
INSERT INTO ifb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","hi Reuben, ya hi Simeon, ya hi Levi, ya hi Judah, ");
INSERT INTO ifb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ya hi Issachar, ya hi Zebulun, ya hi Benjamin, ");
INSERT INTO ifb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ya hi Dan, ya hi Naphtali, ya hi Gad, ya hi Asher. ");
INSERT INTO ifb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ya hay uyap an amin di holag ya ap'apun Jacob ya napitudah lammungna. Mu agguy niddum hi Joseph ti nahhun tuwalin immuy ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ya gun naluh di tawon hi ni'hituwandah di, ya natoy hi Joseph, ya umat goh hinan a'agina, ya nan udum an tatagun himpangapun immuy hidi an nun'atoyda goh. ");
INSERT INTO ifb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mu din imbabaluy Israel ya diday nanginaynayun an nunholag, at na'udma'udmanda ta do'olda ahan eden luta. ");
INSERT INTO ifb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ya la'tot ya nun'alid Egypt han agguy nanginnilah aat Joseph ya nan ina'inatna. ");
INSERT INTO ifb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ya inalinah nan tatagunan i'Egypt di, “Tigonyu an uya'adanah nan holag Israel an nidugah an do'olda ahan, ya mabi'bi'ahda ya un ditu'u! ");
INSERT INTO ifb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","At mahapul an waday aton tu'u ta way atondan adi gun ma'ud'udman ti ini ya udum hi algaw ya waday gubat, ya mid mapto' ya milammungdah nan mangubat ay ditu'u, ya innayundan makak!” Anggaynanah inalin Pharaoh ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","At nan a'ap'apu ya pento'day mumpummandal hinan holag Israel hinan tamuda ta way mangidoldol ay didah nan na'alligat an tamuanda, at diday nangipiyammah nan holag Israel hinan duwan siudad an ad Pithom ya ad Rameses ta danen siudad di awadan di pangipiyamungan nan alih nan mahapuldan amin eden babluy. ");
INSERT INTO ifb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mu ta\"on un umat hinay nangipaligligatandah nan holag Israel ya undaat goh gun mahlag, at gunda dumo'ol hi ad Egypt. At nunheglay ta'ot nan i'Egypt ay dida, ");
INSERT INTO ifb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","at gunda iyal'allay pangipaligligatandah nan holag Israel an mi'id ahan ah homo'da. ");
INSERT INTO ifb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ti impiyammadan diday mapeleng an umat hi halublak ta miyammah abung, ya ta\"on nan payaw nan i'Egypt ya impitamudan dida ta diday nangitamu. ");
INSERT INTO ifb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ya impa'ayag goh han ali nan duwan binabain Hudyu an da Shiprah ay Puah an hay tamuda ya bumadangdah nan way muntungaw hinan binabain Hudyu, ya inalinan diday, ");
INSERT INTO ifb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Wada ay di badanganyuh nan binabain Hudyuh muntungaw ta tigonyu ay ta lala'i nan dawatonyun itungawda ya patayonyu. Mu wa ay ta babai ya adiyu patayon.” ");
INSERT INTO ifb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mu agguyda inunud nan inalin nan alih atonda ti hi Apo Dios di e'gonanda, at agguyda pinatoy nan linala'in dinawatda. ");
INSERT INTO ifb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","At impa'ayag goh nan ali dida, ya inalinay, “Anaad ta agguyyu inunud nan inali' ay da'yu an agguyyu pinatoy nan linala'in pumpa'ittungaw?” ");
INSERT INTO ifb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ya inaliday, “Oo ti nan Hudyu ya madadawoh di atondan muntungaw, at adimi ataman di puntungawandaan nalpah an adi umat hinan i'Egypt an mumpaligatdan muntungaw!” ");
INSERT INTO ifb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","At winagahan Apo Dios daden bumadbadang hinan way muntungaw, at na'ud'udmanda nan tatagun Hudyu, at gunda dumo'do\"ol. ");
INSERT INTO ifb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ya dumalat nan nange'gonandan Apo Dios ya winagahana danen bumadbadang hinan way muntungaw ta nahlagda. ");
INSERT INTO ifb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ya immandal nan alih nan tatagunan inalinay, “An amin nan pa'ittungaw an linala'in imbabaluy nan Hudyu ya umuyyu anudon hinan wangwang, mu adiyu nan binabai!” ");
INSERT INTO ifb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ya wada han lala'in nalpuh holag Levi an inahawana han nalpu goh hinan holag Levi. ");
INSERT INTO ifb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ya nunhabih den babai ta nuntungaw, ya lala'i. Ya unat goh tinnig inana an ma'apgohan di a'ung'ungngana ya impo\"oynah tuluy bulan. ");
INSERT INTO ifb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mu la'tot ya mid olognan mangipo\"oy, at innalna han bahkit an hay niyamma ya tubun di ga'ad, ya inhamadnan linita ta adi luhton di danum. Ya unat goh nalpah ya innalnah den ung'ungnga, ya inittuna, ya inyuynah nan pingit di Wangwang an Nile, ya impatabla'nah nan wadan di adudu\"oy an holo'. ");
INSERT INTO ifb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ya impiyadugnah nan ungan babai an agin den ung'ungnga ta tigonay ma'at ay hiya, mu nibataan di awadana. ");
INSERT INTO ifb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ya heden algaw ya immuy din babain imbaluy nan alid Egypt an umuy mun'amoh hinan wangwang. Ya nan tatagalana ya nundaldallanandah nan pingit di wangwang. Ya unat goh inamang nan imbaluy di alih de han bahkit hinan way adudu\"oy an holo' ya hennagnay ohah nan tatagalana ta immuyna innal. ");
INSERT INTO ifb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ya unat goh linuptin din imbaluy di ali nan hanin di bahkit ya tinnignah den ung'ungngan kumilakila, at inggohgohana. Ya inalinay, “Hiyah te ohah nan imbaluy di Hudyu!” ");
INSERT INTO ifb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ya han babai an agin den ung'ungnga ya immuy hinan imbaluy di ali, ya inalinay, “Pohdom ay ya umuy'u ayagan di ohah nan babain Hudyu ta hiyay manalimun enen ung'ungnga.” ");
INSERT INTO ifb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ya tembal nan imbaluy di alin inalinay, “Oo, eka mun'ayag.” At immuy heden unga, ya inayaganah inan den ung'ungnga. ");
INSERT INTO ifb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ya unat goh inyuynah den babai ya inalin den imbaluy di alin hiyay, “Awitom heten ung'ungnga ta halimunam, at idat'uy bo'laom.” At inawitna nan ung'ungnga, ya hinalimunana. ");
INSERT INTO ifb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ya unat goh immong'ongngol heden ung'ungnga ya inyuy den babaih nan imbaluy di ali an hiyay nangekkop hi ad imbaluy. Ya nginadnana ta hi Moses ti inalinay, “Nan danum di nangagawa' ay hiya.” ");
INSERT INTO ifb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ya unat goh immilog hi Moses at immuy an nannig hinan i'ibbanan Hudyu, ya tinnignay aat di nunnaud hi pumpaligligatandan muntamu. Ya tinnigna goh han ohan i'Egypt an punhuplitna nan ohan Hudyu. ");
INSERT INTO ifb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ya muntiggatiggaw hi Moses an mi'id ah taguh mannig, at pinatoynah de han i'Egypt, ya inlubu'nah nan panag heden natoy. ");
INSERT INTO ifb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ya nabiggat goh ya numbangngad hi Moses, ya inah'upana han duwan Hudyun mumpattoyda. At inalinah nan numbahol di, “Anaad ta punhudpa'mu han ibbam an Hudyu?” ");
INSERT INTO ifb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ya tembal den lala'in inalinay, “Undan he\"ay pento'dah ap'apuh mangipanuh ay da'mi? Undan alyom ta patayona' an umat hinan namatayam hinan i'Egypt?” Ya ma'atta'ot hi Moses ti ininnilanan waday nanginnilah nan inatna. ");
INSERT INTO ifb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ya unat goh dengngol nan alih den na'at ya penhodnan ipapatoy hi Moses. Mu limmayaw hi Moses ta immuy hi ad Midian, ya hidiy ni'hituwana. Mu heden dimmatngana ya inum'umbun hinan way bubun. ");
INSERT INTO ifb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ya hidid Midian ya wada han padi an pituy binabaih imbabaluyna. Ya daden binabai ya immuydah nan way bubun ta ipa'inumanda nan initnuddan kalnilun amada. ");
INSERT INTO ifb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ya immuyda goh nan udum an mumpahtul, ya hinu'witda daden binabai. At immuy mah hi Moses ta binaliwana dida, ya nun'ipa'inumana din kalnilun nan binabai. ");
INSERT INTO ifb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ya unat goh immanamut daden hina\"agi an imbabaluy Reuel ya inalin amaday, “Anaad ta ag'aga ayun umanamut ad ugwan?” ");
INSERT INTO ifb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ya inaliday, “Manu ay ya wada han lala'in i'Egypt an bimmadang ay da'mih din panu'witan nan udum an mumpahtul ay da'mih nan bubun, ya hiya goh nangngal hinan danum, ya nun'ipa'inumana nan kalnilu tu'u.” ");
INSERT INTO ifb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ya inalin amaday, “At hay wadan mah nen lala'i? Anaad ta tinaynanyu? Ekayu ayagan ta me\"an ay ditu'u!” ");
INSERT INTO ifb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","At ni'hituh Moses ay Reuel. Ya la'tot ya inyabulut Reuel an ahawaon Moses han imbaluyna an hi Zipporah. ");
INSERT INTO ifb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","At nalmuy imbaluydan lala'i, ya hay impingadan Moses ya hi Gershom ti inalinay, “Ha\"in ya unna' atog bunag eten babluy.” ");
INSERT INTO ifb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ya naluh di do'ol hi tawon ya natoy din alid Egypt. Mu nan holag Israel ya gun miyal'allay ipaligligatanda an dumalat nan tamuda, ya la'tot ya ahibabagadah badang ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","At dengngol Apo Dios nan pumpahmo'anda, ya ninomnomna din intulagnah nan o'ommodda an da Abraham, ya hi Isaac, ya hi Jacob. ");
INSERT INTO ifb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","At nidugah di homo'nan didah nan papanniganah nan ipaligligatanda. ");
INSERT INTO ifb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ya wa han ohay algaw an ay pumpahtulan Moses hinan kalnilun Jethro an hi aman ahawana an nan padid Midian, ya initnudna nan kalnilu ta ene'wadah nan mapulun ta engganah unda dimmatong hinan Duntug an Horeb an ma'alih Duntug Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ya hidiy numpattigan nan Anghel Apo Dios ay hiya an ay apuy an mundalang hinan gagwan di namo'gong an ayiw, ya inhahammad Moses heden mundalang an ayiw, mu immi'inut an agguy noghob. ");
INSERT INTO ifb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ya alyon Moses hi nomnomnay, “Umipanoh'ah te ahan! At umuy'u pa'ihhamhamadon heden dumaladalang ta anaad ta adi mogmoghob!” ");
INSERT INTO ifb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mu unat goh tinnig Apo Dios an gun meheggon hi Moses ya mun'ali an alyonay, “Moses! Moses!” Ya tembal Moses an inalinay, “Tayaa', Apu!” ");
INSERT INTO ifb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ya inalin Apo Dios di, “Tuma'dog'an ne, ya adi'a gun meheggon hitu, ya anom nan hapatusmu ti heten timma'dogam ya me'gonan ti wah tua'.” ");
INSERT INTO ifb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ya inalina goh di, “Ha\"in di Dios an dayawon din o'ommodyu an hi Abraham, ya hi Isaac, ya hi Jacob.” At hi Moses ya punhanianay angahna ti tuma'ot an mannig ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ya inalin goh Apo Dios ay hiyay, “Titinnig'u nan nidugah an ipaligligatan nan tatagu' an wah did Egypt. Ya dengngol'uy pumbagandah badang'u an dumalat nan nidugah an pangipaligligatan nan mumpummandal hinan tamuda, at hohom'o' didah nan punligligatanda. ");
INSERT INTO ifb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","At hiyanan immalia' ta baliwa' didah nan ato'aton di i'Egypt, ta ekak'u dida ta umuydah nan damunan luta an malumong, ya ma\"almuy mihabal, at do'ol ahan di ma'an an hidiy nunhituwan nan ahimpahimpampun an nan holag Heth, ya holag Amor, ya holag Periz, ya holag Hiv, ya nan iCanaan, ya nan iJebus. ");
INSERT INTO ifb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ti dodonglo' di pumpabadangan nan tatagun holag Israel ay Ha\"in, ya titinnig'u goh nan nidugah an pangipaligligatan nan i'Egypt ay didah nan tamuda. ");
INSERT INTO ifb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","At ad ugwan ya honogo' he\"a ta umuy'ah nan alid Egypt ta he\"ay mangitnud hinan tatagu' an nan holag Israel ta ekakmu dida.” ");
INSERT INTO ifb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mu inalin Moses ay Apo Dios di, “Apu, anaad ahan ta ha\"in di honogom an umuy mi'hapit hinan ali ta ekak'u nan holag Israel ad Egypt?” ");
INSERT INTO ifb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ya inalin Apo Dios ay hiyay, “Adi'a mun'od'od ti wagwadaa' ay he\"a. At wa ay ta makak ayud Egypt ya umali ayu ete han duntug ta dayawona' ta henen atonyuy mangipa'annung an Ha\"in di nannag ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ya inalin goh Moses ay Hiyay, “Gulat ta umuya' hinan wadan nan holag Israel ya inali' ay diday, Nan Dios an dayawon din o'ommod tu'uy nannag ay ha\"in ta umalia' ay da'yu. Mu gulat ta mahmahanday ngadanmu ya hay pambal'u mah ay dida?” ");
INSERT INTO ifb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ya inalin Apo Dios ay hiyay, “Ha\"in nan Mi'id di Te\"ana ya Mi'id Pogpogna an Wagwadaa' Tuwali. Hiyah ne ngadan'u an mannag ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ya inalin goh Apo Dios ay Moses di, “Hiyah te alyom hinan holag Israel an Ha\"in hi Apo Dios an dayawon din o'ommodyun da Abraham, ya hi Isaac, ya hi Jacob di nannag ay he\"a. Ya hiyah ne tuwaliy ngadan'uh enggana, at an amin nan holagyuh pidwa ya hiyay ingadandan Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","At umuy'a, ya impa'ayagmu nan mumpumpapto' hinan numbino'ob'on an holag Israel ta ma'amungda, ya inalim ay diday, Hi Apo Dios an dayawon din o'ommod tu'un da Abraham, ya hi Isaac, ya hi Jacob ya numpattig ay ha\"in ya inalinay, Ha\"in di nanalimun ay da'yu, ya titinnig'u nan nangipaligligatandan da'yud Egypt! ");
INSERT INTO ifb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","At ten alyo' ad ugwan an ekak'u da'yuh nan ipaligligatanyud Egypt ta iyuy'u da'yuh nan damunan luta an malumong, ya ma\"almuy mihabal, ya do'ol ahan di ma'an. An henen lutay nunhituwan nan ahimpahimpampun an holag Heth, ya holag Amor, ya holag Periz, ya holag Hiv, ya nan iCanaan, ya nan iJebus. ");
INSERT INTO ifb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","At donglon nan mumpumpapto' di alyom ay dida. At malammung ayuh nan mumpumpapto' hinan holag Israel ta umuy ayu mi'hapit hinan alid Egypt, ya alyonyun hiyay, Hi Apo Dios an dayawonmin Hudyu ya ni'hapit ay da'mi. At iyabulutmu ni' nan tuluy algaw hi pumbaatanmi ta umuy amih dih nan mapulun ta hidiy umuymi pun'onngan hinan Dios an dayawonmi!” ");
INSERT INTO ifb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ya inalin goh Apo Dios di, “Inila' an heden alid Egypt ya adina abuluton di akakanyu ta engganah un nan na'abbagbagtun way abalinanay mamilit ay hiya ");
INSERT INTO ifb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ti dumalat nan pangata' hinan do'ol an atata'ot hi pummolta' hinan i'Egypt. At la'tot ya abuluton nan ali mahkay di akakanyu. ");
INSERT INTO ifb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","At lumono' di punnomnoman di i'Egypt ta atonday maphod ay da'yu, at pun'idatday gina'uda ta adi ayu mangiw'iwadyah akakanyu. ");
INSERT INTO ifb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ya wa ay ta magadyuh an makak ayu ya an amin nan binabain holag Israel ya hay odowondah nan gina'un nan binabain i'Egypt an heneggonda ya nan ni'hitun dida ya lubung, ya balitu', ya silver, ya hingat, ya hengheng. Ya nun'ipadondah nan imbabaluydan linala'i ya binabai, ya umat hinay atondan mamnoh hinan gina'un di i'Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ya inalin goh Moses ay Apo Dios di, “Gulat ta umuya' ya adia' kulugon hinan tatagu ya adida unudon nan alyo' ti alyonday, Hi Apo Dios ya agguy numpattig ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ya inalin Apo Dios ay hiyay, “Hay ngadan ne han inodnam?” Ya tembal Moses an inalinay, “Hul'ud, Apu.” ");
INSERT INTO ifb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ya inalin Apo Dios di, “Ipa'wahmuh nan luta.” At impa'wah mah Moses, ya numbalin hi ulog, at bimmataan hiya. ");
INSERT INTO ifb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ya inalin goh Apo Dios ay Moses di, “Edonmuh nan iwitna, ya inta'nangmu.” At inta'nang Moses din ulog, ya numbalin goh hi hul'ud. ");
INSERT INTO ifb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ya inalin goh Apo Dios di, “Hiyah ne atom hi un'a umuy hidi, at kulugondan Ha\"in an hi Apo Dios an dayawon din o'ommoddan da Abraham, ya hi Isaac, ya hi Jacob di immannung an numpattig ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ya inalin goh Apo Dios ay Moses di, “Ipahwobmuy ngamaymuh nan bunol di lubungmu.” At inunud Moses an impahwobna. Ya unat goh ginuyudna ya nalipuh hi palla'. ");
INSERT INTO ifb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ya inalin goh Apo Dios ay Moses di, “Ipahwobmu goh nan ngamaymuh nan lubungmu.” At hiya goh di inat Moses an impahwobna ya unna guyudon, ya mapmaphod mahkay an nipaddung hinan up'up di odolna. ");
INSERT INTO ifb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ya inalin goh Apo Dios di, “Mu gulat ta inatmun dida nan nahhun an impattig'un he\"a ta adida kulugon ya atom henen miyadwa, at kulugonda. ");
INSERT INTO ifb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ya gulat ta inatmu danen duwan umipanoh'a ya hiya damdaman adi da'a kulugon ya immuy'ah nan Wangwang an Nile ta ummal'ah nan danum, ya inhiitmuh nan luta. At nan danum ya mumbalin hi dala.” ");
INSERT INTO ifb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ya inalin Moses di, “Apu, bo'on ha\"in di honogom ti adia' nala'eng an humapit an unna' tuwali na'u'umud, ya tigom an ta\"on ad ugwan an numpattigam ay ha\"in an ten unna' muntohtoh'a!” ");
INSERT INTO ifb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ya inalin Apo Dios ay hiyay, “Hay ngadan di nunlumuh timid di tagu? Ya hay mamu'it ya mangumud ay hiya? Ya ngadan di way abalinanan mamulaw hi mata, unu hay mangidat hi panigaw? Undan bo'on Ha\"in an hi Apo Dios di mangat? ");
INSERT INTO ifb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","At makak'ad ugwan ta umuy'a, at badanga' he\"an humapit ti Ha\"in di okod an mangitudun he\"ah hapitom!” ");
INSERT INTO ifb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ya inalin Moses di, “Hay udum ni' ahan, Apu, di honogom hi mangat!” ");
INSERT INTO ifb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","At ma'ahhingal mah hi Apo Dios ay Moses, ya inalinay, “Undan bo'on agim hi Aaron an holag Levi? Inila' an olognan umal'alu', ya nahamad di panapitna! Ya ad ugwan ya wah nan dalan an ipluynah tu ta damuwon da'a. Ya awni ta mundammu ayu at ongol di pun'am'amlonganan mannig ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ya munhapit ayun duwa ta nan alyom di hapitonah nan tatagu. At badanga' da'yu ta Ha\"in di okod an mangipanomnom ay da'yuh nan hapitonyu ya hay atonyu. ");
INSERT INTO ifb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ya hi Aaron di pahapitom hinan tatagu ta hiyay mangibagah nan alyom ay hiya, ya he\"ay paddungnay Apo Dios hi gun mangipa'innilan hiyah nan hapitona. ");
INSERT INTO ifb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ya itata'inmu nan hul'udmu ta hiyay usalom an mangat hinan do'ol an umipanoh'ah nan tatagu.” ");
INSERT INTO ifb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ya unat goh nalpah henen na'at ya immanamut hi Moses. Ya inalinan Jethro an ommod ahawanay, “Iyabulutmu ni' di umaya' ad Egypt ta umuy'u tigon nan tutulang'uh di ta puuto' di ma'ma'at ay dida.” At inyabulut Jethro, ya inalinay, “Mid ni' al'alih nan owonyu.” ");
INSERT INTO ifb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Hidin awadan Moses ad Midian ya ni'hapit hi Apo Dios ay hiyan inalinay, “Mumbangngad'ad Egypt ti an aminda din mamhod an mamatoy ay he\"a ya nun'atoyda.” ");
INSERT INTO ifb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ya hidin akakanda ya nuntakayon Moses hi ahawana ya nan duwan linala'in imbabaluynah nan dongki, ya nakakda ta umuydad Egypt. Ya inta'ina din hul'ud an din inalin Apo Dios hi odnana. ");
INSERT INTO ifb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ya inalin goh Apo Dios ay Moses di, “Hay pumbangngadanyud Egypt ya ipattigmuh nan alin amin nan umipanoh'a. Mu ipa'odhol'uy nomnom nan ali ta ta\"on unna gun tigon nan umipanoh'a ya adina damdama iyabulut an pakakon nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ya alyom hinan aliy, Hiyah te inalin Apo Dios: Nan holag Israel di paddungnay pangpangulluh lala'in imbaluy'u, ");
INSERT INTO ifb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","at iyabulutmuy akakanda ta umuyda mundayaw ay Ha\"in. Mu inila' an iyadim, at hiyanan patayo' nan pangpangullun lala'in imbaluymu.” ");
INSERT INTO ifb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ya hidih nan immiyanan da Moses hinan dalan hi ayandad Egypt ya hi'itangan patayon Apo Dios hiya. ");
INSERT INTO ifb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mu nan ahawanan hi Zipporah ya innalnay nangalaban an batu ta nangugitnah nan imbaluyda, at impa'wahnah hu'in Moses nan up'up an ginogodna ta way pinumhodana, ya inalinay, “Umipabahol ay ha\"in nan inat'u ta adi'a mapatoy!” ");
INSERT INTO ifb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","At binataanan Apo Dios hiya. Ya manu ay inalin Zipporah hene ti dumalat nan nakugitanda. ");
INSERT INTO ifb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ya hi Apo Dios ya ni'hapit ay Aaron hidid Egypt an inalinay, “Umuy'ah nan mapulun ta damuwom hi Moses.” At immuy ta dinamunah Moses hinan ma'alih Duntug Apo Dios, ya inungnguna. ");
INSERT INTO ifb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","At inulgud Moses ay Aaron an amin nan inalin Apo Dios an nannag ay hiya, ya ta\"on nan inalinan atondan umipanoh'a. ");
INSERT INTO ifb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ya unat goh nidatong da Moses ay Aaron ad Egypt ya impa'ayagdan amin nan mumpumpapto' hinan holag Israel ta na'amungda. ");
INSERT INTO ifb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","At hi Aaron di nangipa'innilan amin hinan tataguh nan inalin Apo Dios ay Moses ya un mahkay ipattig Moses ay dida nan umipanoh'ah nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ya nan mumpumpapto' ya kinulugdan hi Apo Dios di nannag ay dida, at inayundan nunluung ta dayawondah Apo Dios ti dengngoldan hohom'ona didah nan ipaligligatanda. ");
INSERT INTO ifb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ya unat goh nalpah an nunhahapitda ya immuy da Moses ay Aaron hinan alid Egypt. Ya inaliday, “Hiyah te inalin Apo Dios an dayawon nan holag Israel an inalinay, Iyabulutmuy akakan nan tatagu' ta umuydah nan mapulun an mundayaw ya mun'onong ay Ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ya han ali ya inalinay, “Hay ngadan ne han Apo Dios? Ya anaad udot ta unudo' di inalina ta pakako' nan holag Israel? Agguy'u inilah Apo Dios, ya adi' pakakon nan holag Israel eten babluy!” ");
INSERT INTO ifb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mu inalin da Moses ay Aaron di, “Oo, mu hi Apo Dios an dayawonmin Hudyu ya numpatigaw ay da'mi, at abulutom ni' ta mumbaat amih tuluy algaw hinan mapulun ta hidiy pun'onnganmin Hiya. Ti gulat ta adimi unudon ya hay dogoh di dumalat hi atayanmi unu hay matadom di pumpamatoynan da'mi.” ");
INSERT INTO ifb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ya inalin han ali ay da Moses ay Aaron di, “Unyu pohdon an haliwaon nan tataguh nan puntamuanda! Mumbangngad ayuat hinan tamuyu! ");
INSERT INTO ifb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ya tigonyun ad ugwan ya da'yun holag Israel di do'do'ol ya un da'min i'Egypt, ya anaad goh ta pohdonyu goh an duminongdan muntamu?” ");
INSERT INTO ifb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ya heden algaw ya immandal nan alih nan mumpummandal an i'Egypt ya nan mumpumpapto' hinan holag Israel hinan tamudan ");
INSERT INTO ifb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","inalinay, “Adiyu mahkay idat ay dida nan dagamin iddumdah nan pito' an miyammah nan mapeleng an halublak ta okoddan umuy an manganap! ");
INSERT INTO ifb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mu alyonyun dida ta mahapul an heden uyap di halublak an iyammadah ohay algaw tuwali ya adi makudangan! Ya mid mapto' ya manghan di tamuda, at hiyaat unda gun ibagan ha\"in ta iyabulut'uy umuyda pundayawan hinan Diosda! ");
INSERT INTO ifb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ya gunyu udman di tamun danen holag Israel ta way atondan tumamutamu, at mid atondan umuy mundongol hinan hapiton danen mumpunlayah!” ");
INSERT INTO ifb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","At immuyda mah nan mumpummandal hinan tatagu ya nan mumpumpapto' hinan tamu, ya inalidah nan tatagu di, “Hay inalin nan ali ya adi da'yu mahkay idatan hi dagami! ");
INSERT INTO ifb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","At okod ayun umuy manganap hi dagami, mu mahapul an hede damdaman bilang di halublak an iyammayu tuwalih ohay algaw di miyamma!” ");
INSERT INTO ifb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","At nan holag Israel ya way ohaan umuyda manganap hi dagamih ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ya daden mumpummandal ay dida ya nidugah di atondan mangidoldol hinan tamu an inaliday, “Mahapul an nan bilang di halublak hi iyammadah ohay algaw hidin awadan di dagamih midat di iyammayu damdama!” ");
INSERT INTO ifb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","At nan holag Israel an napilin mumpangipapto' hinan tamu ya diday nangiboholan nan mumpummandal ta nunhaplatda dida, ya inaliday, “Anaad ta nahnot ad ugwan ya ad uggay impiyammayuh halublak an adi umat hidin hopapna?” ");
INSERT INTO ifb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","At daden holag Israel an mumpangipapto' hinan tamu ya immuydah nan ali, ya inaliday, “Uya'ana ahan tatagwah atom ay da'min baalmu! ");
INSERT INTO ifb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ti adi da'mi idatan hi dagami, mu alyondan da'miy, Mun'amma ayuh halublak! At nan tatagum di ad bahol, ya anaad ta punhaplat da'mi?” ");
INSERT INTO ifb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ya inalin nan alin diday, “Un ayu ahan tuwali napayad an adiyu pohdon an muntamu, hiyanan hay pangiyabuluta' hi umuyyu pundayawan ay Apo Dios di gunyu ibagabagan ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","At mumbangngad ayuh nan tamuyu! Ti ta\"on un mi'id ah dagamih midat ay da'yu ya mahapul damdama an nan bilang di halublak an iyammayuh ohay algaw hidin hopapnay iyammayu!” ");
INSERT INTO ifb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ya daden mumpangipapto' hinan holag Israel ya iniladan gun miyal'allay punligatanda ti henen nangalin nan alin didan mahapul an din iyammada tuwalih bilang di halublak hi ohay algaw di iyammada. ");
INSERT INTO ifb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ya unat goh limmahunda ya wada da Moses ay Aaron an mamannod ay dida, ");
INSERT INTO ifb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","at inalidan da Moses ay Aaron di, “Olom man ya hi Apo Dios di nanannig hinan inatyu, at Hiyay mummoltan da'yu! Ti nan inatyuy dumalat hi pamoholan nan ali ya nan tatagunan da'mi, at hiyay nangidalatandan mangipaligligat ay da'mi!” ");
INSERT INTO ifb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","At ni'hapit goh hi Moses ay Apo Dios an inalinay, “Apu, anaad ta unna' hennag ay He\"ah tu ya ten munligligatda damdama tun tatagum? ");
INSERT INTO ifb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ti nete\"ah din ni'hapita' hinan ali ta imbaga' din inalim ya unnaat goh inyal'allay pangipaligligatanah nan tatagum, ya agguymu goh dida ahan binadangan!” ");
INSERT INTO ifb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ya inalin Apo Dios ay Moses di, “Ad ugwan ya tigom di ato' hinan ali ti mapilitan, at pakakona nan tatagu', ya punnaudonday akakanda ta taynanda nan babluy.” ");
INSERT INTO ifb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","At inalin goh Apo Dios di, “Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ya Ha\"in din numpattig ay da Abraham, ya hi Isaac, ya hi Jacob, ya impa'innila' ay didan Ha\"in nan Dios an Ongol di Abalinana. Mu nan ngadan'u an hi Apo Dios ya agguy'u ni' impa'innilan dida. ");
INSERT INTO ifb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ya inhamad'un intulag ay didan idat'u nan babluy an ad Canaan ta hidiy punhituwanda, ya nibilangdah bunag. ");
INSERT INTO ifb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","At ninomnom'u nan intulag'un dida, at hiyanan hom'o' nan tatagu' an holag Israel hinan pumpahpahmo'andan Ha\"in ti dumalat nan aatdan umat hi himbut. ");
INSERT INTO ifb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","At hiyanan ibagam hinan holag Israel an alyom di, Ha\"in hi Apo Dios, ya Ha\"in di mamadang ay da'yuh nan pangipaligligatan nan i'Egypt ay da'yu ta pogpogo' di aatyun umat hi himbut. Ya ipattig'uy abalina' an mummoltah nan i'Egypt ta pakakon da'yun ne han babluy. ");
INSERT INTO ifb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ya da'yuy pento\"uh tatagu' ta Ha\"in an Dios di dayawonyu. Ya hay panginnilaanyuh un Ha\"in hi Apo Dios an dayawonyu ya nan pamogpoga' hinan aatyun umat hi himbut ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ta ipangulu' da'yuh nan babluy an din inhapata' hi idat'un da Abraham, ya hi Isaac, ya hi Jacob ta da'yun holagday mamnoh hinan luta. Ya ten ipidwa' an alyon di, Ha\"in hi Apo Dios an dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Hiyah ne goh di inulgud Moses hinan holag Israel, mu agguyda dengngol nan inalina ti dumalat nan nidugah an punnomnomandah nan ipaligligatanda. ");
INSERT INTO ifb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ya ni'hapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Umuy'a goh hinan ali, ya imbagam ay hiya ta iyabulutnay akakan nan holag Israel enen babluy.” ");
INSERT INTO ifb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ya inalin Moses ay Apo Dios di, “Tigom adya an ta\"on nan holag Israel ya adia' donglon, at iyal'allanah nan ali ti ten unna' muntohtoh'an humapit!” ");
INSERT INTO ifb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ya inalin goh Apo Dios ay da Moses ay Aaron di, “Ibagayuh nan holag Israel ya nan alid Egypt an Ha\"in di namto' ay da'yun duwa ta ipanguluyu nan holag Israel ta ekakyu didad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hiyatuy holag Israel ya nan imbabaluyda: Nan pangpangullun hi Reuben ya opatday linala'ih imbabaluyna an da Hanok, ya hi Pallu, ya hi Hezron, ya hi Karmi. Didanay nalpuh holag Reuben. ");
INSERT INTO ifb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Hi Simeon ya onomday linala'ih imbabaluyna an da Jemuel, ya hi Jamin, ya hi Ohad, ya hi Jakin, ya hi Zohar, ya hi Shaul (an hi inana ya iCanaan). Didanay nalpuh holag Simeon. ");
INSERT INTO ifb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Hi Levi ya tuluday linala'ih imbabaluynan da Gershon, ya hi Kohath, ya hi Merari an hiyah ne napatadandan himpangapu. Hi Levi ya hinggahut ta han tulumpulu ta pituy tawona ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ya hi Gershon ya duwaday linala'ih imbabaluyna an da Libni ay Shimei an diday ommod nan duwan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Hi Kohath ya opatday linala'ih imbabaluynan da Amram, ya hi Izhar, ya hi Hebron, ya hi Uzziel. Ya hi Kohath ya hinggahut ya han tulumpulu ta tuluy tawona ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ya hi Merari ya duwaday linala'ih imbabaluyna an da Mahli ay Mushi. Didanay himpangapu an nalpuh holag Levi hi napatad. ");
INSERT INTO ifb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ya hi Amram ya inahawanah Jochebed an hi agin amana, at nunholagda ta da Aaron ay Moses. Hi amadan hi Amram ya hinggahut ta han tulumpulu ta pituy tawona ya un matoy. ");
INSERT INTO ifb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ya hay imbabaluy Izhar hi linala'i ya da Korah, ya hi Nepheg, ya hi Zikri. ");
INSERT INTO ifb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ya hi Uzziel ya tuluday linala'ih imbabaluynan da Mishael, ya hi Elzaphan, ya hi Sithri. ");
INSERT INTO ifb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ya hi Aaron ya inahawanah Elisheba an imbaluy Amminadab an hi agin Nahshon. Ya opatday imbabaluyna an da Nadab, ya hi Abihu, ya hi Eleazar, ya hi Ithamar. ");
INSERT INTO ifb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Hi Korah ya tuluday imbabaluynah linala'i an da Assir, ya hi Elkanah, ya hi Abiasap. Ya didanay a'apun holag Korah. ");
INSERT INTO ifb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ya hi Eleazar an imbaluy Aaron ya inahawana han imbaluy Putiel, ya nunholagda ta hi Phinehas. At didan amin di numbalin hi a'ap'apun nan numbino'ob'on an himpangapun nalpuh holag Levi. ");
INSERT INTO ifb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ya da Aaron ay Moses di nangalyan Apo Dios hi mumpangipapto' hinan holag Israel ta makakdad Egypt, ");
INSERT INTO ifb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ya diday immuy hinan Alin hi Pharaoh ta al'alu'onday pangiyabulutanah akakan nan holag Israel ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ya heden algaw hi ni'hapitan Apo Dios ay da Moses ay Aaron ad Egypt ");
INSERT INTO ifb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ya inalinay, “Ha\"in hi Apo Dios an dayawonyu, at umuy ayuh nan alid Egypt ta ulgudonyun amin nan inali' ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ya inalin Moses di, “Apu, inilam an ha\"in ya adia' nala'eng an humapit, at hiya dan hi unna' donglon hinan ali?” ");
INSERT INTO ifb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ya inalin goh Apo Dios ay Moses di, “Donglom heten alyo' ay he\"a ti pumbalinon da'ah paddungnay Dios hinan umayam hinan ali, ya hi agim an hi Aaron di pun'alunom ta hiyay pahapitom hinan ali. ");
INSERT INTO ifb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","At ulgudom ay Aaron an amin nan inali' ay he\"a ta hiyay ibaagnah nan ali, ya mahapul an ibaganah nan ali ta iyabulutnay akakan nan holag Israel enen babluyda. ");
INSERT INTO ifb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mu ipa'odhol'uy nomnom nan ali ta way a'ud'udman di ipattig'un umipanoh'ah tud Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mu ta\"on unna tigon hana ya adi da'a damdama kulugon. At hiyanan idat'uy numbino'ob'on an punligatan nan i'Egypt ta hiyanay pummolta' ay dida ya un'u ekak nan tatagu' an holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","At hiyah ne panginnilaan nan i'Egypt an Ha\"in hi Apo Dios ti dumalat nan idat'un ipaligligatanda, at la'tot ya enekak'u nan holag Israel hinan babluyda.” ");
INSERT INTO ifb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ya an amin nan immandal Apo Dios ay da Moses ay Aaron ya inatda. ");
INSERT INTO ifb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ya heden gutud di umuyda pi'hapitan hinan ali ya nawaluy tawon Moses, ya nawalu ta han tuluy tawon Aaron. ");
INSERT INTO ifb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ya inalin Apo Dios ay da Moses ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Umuy ayu ay hinan ali ta alyonan da'yuy mahapul ipattigyuy umipanoh'a ta pangimmatuna' ya alyom ay Aaron ta ipa'wahna nan hul'ud hinan hinagang nan ali, at mumbalin hi ulog.” ");
INSERT INTO ifb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","At immuy da Moses ay Aaron hinan ali ta atonda nan inalin Apo Dios ay dida. At impa'wah Aaron din hul'ud hidin hinagang nan ali ya nan u'upihyalna, ya numbalin heden hul'ud hi ulog. ");
INSERT INTO ifb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mu heden ali ya impa'ayagna nan nun'alala'eng an mangat hi madyik an i'Egypt ta ipa'atna goh heden inat da Moses ay Aaron. ");
INSERT INTO ifb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","At nun'ipa'wahday hul'udda, ya umat goh an numbalindah ulog. Mu nan hul'ud Aaron an numbalin hi ulog ya nun'u'muna daden ulog. ");
INSERT INTO ifb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mu impahelot nan aliy nomnomna, at agguyna inat nan inalin da Moses ay Aaron ti hiyah ne inalin tuwali Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ya inalin goh Apo Dios ay Moses di, “Nen un ngumayah nen alin adina iyabulut di akakan nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","At hi ma'et ya inta'inmu din hul'ud an din numbalin hi ulog, ya immuy'ah nan Wangwang an Nile ti umuy hidi nan ali, at hodom hiyah di. ");
INSERT INTO ifb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ta immali ay ya inalim ay hiyay, Hi Apo Dios an dayawon nan Hudyu ya hennaga' ta ibaga' ay he\"a an alyonay, Iyabulutmuy akakan nan tatagu' eten babluy ta umuydah nan mapulun ta hidiy umuyda pundayawan ay Ha\"in! Mu engganad ugwan ya iya'adim damdama. ");
INSERT INTO ifb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","At hiyaat un inalin Apo Dios di, Heten ato' di hiyay panginnilaam an Ha\"in hi Apo Dios. At tigom ta ihaplat'uh ten hul'ud hinan danum hitun Wangwang an Nile, at nan danum ya mumbalin hi dala. ");
INSERT INTO ifb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ta mun'atoydan amin nan wah nan danum an ekan, ya umagub nan danum, at adi mabalin hi inumon nan i'Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ya inalin Apo Dios goh ay Moses di, “Honogom hi Aaron ta umuyna pun'eldong din hul'ud hi an amin hinan wangwang, ya ginnaw, ya unit, ya ala', ya obob, ya nan way bannaw ta mumbalin hi dala an amin nan danum ad Egypt an ta\"on nan wah nan pannumanda.” ");
INSERT INTO ifb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ya inat da Moses ay Aaron nan immandal Apo Dios hi atonda. At heden wawaddan nan ali ya nan tatagalanah nan Wangwang an Nile ya inhaplat mah Aaron nan hul'ud hinan way danum, ya numbalin nan danum hi wangwang hi dala. ");
INSERT INTO ifb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ya nun'atoydan amin nan e'ekan, ya nidugah an mun'agub nan danum, at adi mabalin hi inumon nan i'Egypt. Ya an amin nan danum eden babluy ya numbalindah dala. ");
INSERT INTO ifb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mu eneng'engoh nan mummadyik ad Egypt an dumalat nan la'engda, at inyal'allan nan ali an mangiya'addi ti adina dongdonglon din alyon da Moses ay Aaron ti hiyah ne tuwaliy ina'allin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","At nan ali ya immanamut hi palasyunan agguyna ahan hinaghaggung nan na'at. ");
INSERT INTO ifb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ya an amin nan i'Egypt ya nunluhu'dah nan pingit di wangwang ta manganapdah inumondah danum ti adi ahan mabalin hi ma'inum nan danum an malpuh wangwang. ");
INSERT INTO ifb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ya pituy algaw di naluh hi namuhian Apo Dios hinan wangwang. ");
INSERT INTO ifb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ya inalin goh Apo Dios ay Moses di, “Umuy'ah nan ali, ya inalim di, Inalin Apo Dios di iyabulutmuy akakan nan tatagu' ta way atondan umuy mundayaw ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mu gulat ta adim iyabulut ya lumuwo' di nidugah an do'ol an tu'a' hitun abablubabluy ");
INSERT INTO ifb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","an mun'alpudah nan Wangwang an Nile. Ya la'tot ya umuydah nan punhituwam ta mun'ihinadah nan kuwaltum, ya nan olo'am, ya umuyda goh hinan a'abung nan u'upihyalmu, ya nan tatagum, ya nan o\"ongol an duyun pungkiwalanyuh nan tatagum, ya nan punhaangam hi tinapay. ");
INSERT INTO ifb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ya ahilatlattu'dah odolmu, ya nan tatagum, ya nan u'upihyalmu.” ");
INSERT INTO ifb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","At alyon goh Apo Dios ay Moses di, “Alyom ay Aaron ta umuyna eldong nan hul'ud hinan ginnaw, ya wangwang, ya ala', ya bannaw ta mun'almudah di nan do'ol ahan an tu'a' ta lonapanda tun lutad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","At eneldong mah Aaron din hul'ud hinan way danum, ya hin'alina ya nalmuday nidugah an do'ol hi tu'a', at lenonapanda nan lutad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mu nan mumpummadyik an i'Egypt ya enengngohda goh din na'at ti dumalat nan abalinanda, ya impadahdan lumuwon. ");
INSERT INTO ifb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","At impa'ayag nan ali da Moses ay Aaron, ya inalinay, “Munluwalu ayu ni' ay Apo Dios ta ubahona tun tu'a' hitun nunhituwanmi, at iyabulut'uy akakanyun holag Israel ta umuy ayu mun'onong ay Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ya inalin Moses hinan aliy, “Penhod'un iluwaluan da'a, ya nan u'upihyalmu, ya nan tatagum. Mu maphod hi un he\"ay mamto' hi algaw hi pohdom hi pangata', at anonan amin nan tu'a' ta ammuna tuwali nan tu'a' hi wangwang di ma'angang.” ");
INSERT INTO ifb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ya inalin nan aliy, “Atom hi ma'et.” Ya inalin Moses di, “Ato' hi un hiyay pohdom ta way panginnilaam an hi Apo Dios an dayawonmi ya na'abbagbagtun mi'id nipaddung ay Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","At immannung an anona nan tu'a' hinan abungmu ya abung nan u'upihyalmu ta ammuna nan wah Wangwang an Nile di ma'angang.” ");
INSERT INTO ifb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ya unat goh nalpah di nunhahappitanda ya tinaynan da Moses ay Aaron nan ali. Ya nunluwaluh Moses ay Apo Dios ta ubahona din do'ol an tu'a'. ");
INSERT INTO ifb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ya inat Apo Dios nan inluwalun Moses hi ma'at ti himbumagga ya nun'atoydan amin nan tu'a' hinan abalubaluy, ya nan gettaw, ya nan apayapayaw. ");
INSERT INTO ifb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","At inamung nan i'Egypt, ya nidugah an ahi'a'agubda. ");
INSERT INTO ifb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mu unat goh tinnig nan alin mi'id mahkay nan tu'a' ya hihidya damdaman impahehelotnay nomnomna ti agguyna inat din inalin da Moses ay Aaron. At nipa'annung din inalin tuwali Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ya inalin goh Apo Dios ay Moses di, “Alyom ay Aaron ta idolta'na nan hul'ud hinan luta ta mumbalin nan hupu' hi imu' hinan abablubabluy ad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","At hiya mah goh di inat da Moses ay Aaron ta an amin nan hupu' hinan abablubabluy ya numbalin hi imu'. At nan imu' ya ahi'a'alukayatdah nan i'Egypt ya an amin hinan a'animalda. ");
INSERT INTO ifb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ya impadah goh nan udumnan i'Egypt an mumpummadyik nan inat da Moses, mu agguyda inabalinan. ");
INSERT INTO ifb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","At inalidah nan aliy, “Hi Apo Dios ya anggay di way abalinanan mangat hi umat hina!” Mu heden ali ya unnaat goh impahelot di nomnomnan ay agguyna dengngol da Moses ay Aaron. At nipa'annung din inalin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ya inalin goh Apo Dios ay Moses di, “Hi maweet ya bumuwah'a goh ta eka damuwon nan alih ayanah nan wangwang ta alyom ay hiyay, Hiyah te inalin Apo Dios, Iyabulutmuy akakan nan tatagu' ta umuyda mundayaw ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ti adim ay iyabulut ya lumuwo' goh di lalog ta amomolan da'yun amin an i'Egypt an ta\"on nan numpunhituwanyu ya nan lutayu ");
INSERT INTO ifb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ta ammunah ad Goshen an awadan nan tatagu' an holag Israel di mi'idan di lalog. At hiyay panginnilaanyun Ha\"in hi Apo Dios hinan abablubabluy hitun luta. ");
INSERT INTO ifb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","At hiyay pangimmatunan nan tatagum ya nan tatagu', ya hay a'atan ne ya hi ma'et.” ");
INSERT INTO ifb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ya heden nabiggat ya impa'annung Apo Dios an nalmuy do'ol ahan hi lalog ta nunhinap ad Egypt an ta\"on un nan nunhituwan nan ali ya nan u'upihyalna. At nan lalog di namuhih ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","At impa'ayag mah nan ali da Moses ay Aaron, ya inalinay, “Umuy ayu ta umuyyu onngan nan Dios an dayawonyu, mu ta hitun babluy di pangatanyu.” ");
INSERT INTO ifb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ya inalin Moses ay hiyay, “Adi mabalin hene ti nan i'Egypt ya i'innila' an nidugah di adida pamhodan hinan e'nongmin Apo Dios! At gulat ta hituy pangatanmi ta tigonda at puntapa da'mi! ");
INSERT INTO ifb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","At hiyaat unmi pohdon an mumbaat hi tuluy algaw hinan mapulun ta hidiy umuymi pun'onngan ay Apo Dios ta atonmi nan immandalnan da'mi.” ");
INSERT INTO ifb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ya inalin nan aliy, “Iyabulut'un umuy ayu mun'onong ay Apo Dios an dayawonyuh nan mapulun, mu ta adi ayu umuy hi adagwi. At iluwaluana' ni' ay Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ya inalin Moses di, “Heten akaka' ya iluwalu' ay Apo Dios ta hi ma'et ya ma'ubahda nan do'ol an lalog hinan nunhituwam, ya nan awadan nan u'upihyalmu, ya nan tatagum. Mu adi da'mi ilayahan goh ta adim ipaway akakanmih umuymi pun'onngan ay Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ya unat goh nakak hi Moses hinan awadan di ali ya innayuna, ya nunluwalun Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ya dengngol Apo Dios heden inluwalun Moses, at inubahnan amin nan nidugah an do'ol an lalog, at mi'id ah ohah na'angang. ");
INSERT INTO ifb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mu un hihidya damdaman un impahehelot den aliy nomnomnan adina iyabulut di akakan nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ya inalin Apo Dios ay Moses di, “Umuy'ah nan ali, ya alyom ay hiyay, Hiyah te inalin Apo Dios an dayawonmin Hudyu: Iyabulutmuy akakan nan tatagu' ta way atondan mundayaw ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mu adim ay iyabulut ta pohdom unda mihihinnah tu ");
INSERT INTO ifb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ya ipa'alinay atata'ot hi pihtin di a'animalyu an nan kabayu, ya dongki, ya baka, ya kalnilu, ya nan gandeng, ya kamilu. ");
INSERT INTO ifb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mu nan a'animal di holag Israel ya adi middum an mi'pihti an ta\"on ah oha, ta ammuna nan a'animalyun i'Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","At hay inalin Apo Dios hi gutud di a'atana ya hi ma'et. ");
INSERT INTO ifb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ya heden nabiggat ya impa'annung Apo Dios din inalina. At an amin nan a'animal nan i'Egypt ya nun'atoyda, mu mi'id ah ohah natoy hinan a'animal di holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ya nan ali ya hennagna nan linala'in immuy nanamad hinan a'animal nan holag Israel, ya tinnigdan mi'id ah ohah natoy. Mu hihidya damdaman heden ali ya unna impa'odhol di nomnomna ti agguyna inyabulut di akakan nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ya inalin goh Apo Dios ay da Moses ay Aaron di, “Umakup ayuh dapul hinan pun'apuyan, ya impatu\"ug Moses an ihabuag ta titiggon nan ali. ");
INSERT INTO ifb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ta iwa'at di tuyup hinan abablubabluy ad Egypt ta hiyay dumalat hi almuwan nan i\"itang an mun'abdu' hinan up'up di tatagu ya a'animal ta mumbalin hi pogha.” ");
INSERT INTO ifb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","At immuy mah immakup da Moses ay Aaron hinan dapul, ya immuydah nan awadan di ali, ya impatu\"ug Moses an inhabuag heden dapul ta immalihbu', ya nawaday i\"itang hi nun'abdu' hinan up'up di tatagu ya nan a'animal, ya nun'apoghaanda. ");
INSERT INTO ifb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ya nan i'Egypt an way abalinandan mummadyik ya mid ologdan umuy ay Moses ti nun'apoghaandan amin an i'Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mu impahelot Apo Dios di nomnom nan ali, at agguyna inunud nan inalida ti hiyah ne tuwali din inalin Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ya inalin goh Apo Dios ay Moses di, “Hi ma'et hinan helhelong ya umuymu damuwon nan ali, ya alyom ay hiyay, Hiyah te inalin Apo Dios an dayawon nan Hudyu an inalinay, Iyabulutmuy akakan nan tatagu' ta umuyda mundayaw ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ti adim ay ya moltao' he\"a, ya nan u'upihyalmu, ya nan tatagum ta way panginnilaanyun mi'id ah nipaddungan di anabagbagtu' hitun luta! ");
INSERT INTO ifb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ti gulat ta penhod'un mamatoy ay he\"a ya nan tatagum at ipa'ali' nan mabi'ah an dogoh, at mun'atoy ayu ta mapogpog ayuh tun luta. ");
INSERT INTO ifb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mu manu ay agguy'u inat di umat hina ya ta matagu'a, ta ipattig'un he\"a nan abalina', ya ta mipa'innilan amin hinan tataguh tun luta. ");
INSERT INTO ifb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Mu he\"a ya unmu ipangangattuy aatmu, hiyaat unmu adi iyabulut di akakan nan tatagu'. ");
INSERT INTO ifb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","At innilaom an hi ma'et hinan at hitu ya ipa'ali' di nunnaud an dalallu an mi'id ah nipaddunganah nan dalallu an gun impaluh nan i'Egypt an nete\"ah din hopapna ta nangamung ad ugwan. ");
INSERT INTO ifb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ya alyom ta ipahi'ugdan amin nan a'animal an wah nan payaw, ya ta\"on nan tatagu ya ta mihi'ugda goh, ti adida ay ya mun'e'na nan dalallun dida, at mun'atoyda.” ");
INSERT INTO ifb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ya nan udumnan i'Egypt an u'upihyal ya timma'otda ti nan inalin Apo Dios, at ayda nun'ipahi'ug nan a'animalda ya nan baalda. ");
INSERT INTO ifb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mu nan udumna ya nidugah di ngohoydah nan inalin Apo Dios hi ma'at, at agguyda impahi'ug nan himbut ya nan a'animalda. ");
INSERT INTO ifb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ya inalin Apo Dios ay Moses di, “Ita'nangmuy ngamaymud daya ta mun'agah nan dalalluh nan abablubabluy ad Egypt, ya nun'e'nah nan tatagu, ya nan a'animal, ya an amin hinan nitanom hi payaw ya uma.” ");
INSERT INTO ifb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","At inta'nang Moses din hul'udna, ya impa'idul Apo Dios, ya gun mun'ilat an pumahad hitun luta ya manalallu. ");
INSERT INTO ifb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ya nidugah an gun mun'apalin manalallu ya gun mun'ilat. Hiyah ne nidugah ahan an dalallun mi'id ah umat hinah impaluh nan i'Egypt hi nete\"ah penghana. ");
INSERT INTO ifb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ya nun'ipuhit nan dalalluh an amin hinan agguy nipahi'ug hi ad Egypt an wah nan payawda, at nun'apa\"i ya nun'atoyda nan tatagu ya nan a'animal. Ya an amin di nun'itanom hinan uma, ya payaw, ya ta\"on nan ayiw ya nun'a'ipungda. ");
INSERT INTO ifb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mu ad Goshen an nihinan nan holag Israel ya mi'id ah dalalluh di. ");
INSERT INTO ifb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","At impa'ayag goh nan ali da Moses ay Aaron, ya inalinan diday, “Immannung an numbahola', ya hi Apo Dios ya makulug di aatna, at ha\"in ya nan tatagu' di nibahhaw! ");
INSERT INTO ifb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","At munluwalu ayu ni' ahan ay Apo Dios ta ipadinongna nan atata'ot an idul ya nan dalallu ti iyabulut'uy akakanyun ten babluy ta adi ayu mahkay mihinah tu!” ");
INSERT INTO ifb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ya inalin Moses di, “Awni ta makak amin ten siudad ya nunluwalu amin Apo Dios, at duminong nan idul ya nan dalallu, ta way panginnilaam an tun luta ya bagin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mu i'innila' an he\"a ya nan u'upihyalmu ya adiyu damdama ta'tan hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ya nan intanom nan i'Egypt an barle ya bimmungada, ya nan flax an ay apoh ya munhabung, at hiyaat unda nun'apa\"i. ");
INSERT INTO ifb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mu nan wheat an paddungnay habug ya agguy napa\"i ti pa'ahhangawda. ");
INSERT INTO ifb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","At hi Moses ya nakak hinan awadan nan ali ta tinaynana nan babluy. Ya inta'nangnay ngamayna, ya nunluwalun Apo Dios, at dimminong din idul ya dalallu, ya inugawnay udan. ");
INSERT INTO ifb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ya unat goh tinnig nan ali ya nan u'upihyalna an dimminong nan idul ya dalallu ya impahehelotda damdamay nomnomdan umat hidin hopapna. ");
INSERT INTO ifb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","At impahehelot nan aliy nomnomna, at agguyna goh inyabulut di akakan nan holag Israel ti hiyah ne tuwali inalin Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ya inalin goh Apo Dios ay Moses di, “Umuy'ah nan ali ta mi'hapit'a ti impahelot'uy nomnomna ya nan u'upihyalna ta way ato' an mangipattig ay didah nan pangat'un umipanoh'a. ");
INSERT INTO ifb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ta hanan ma'at ya hiyay ulgudonyuh udum di algaw hinan imbabaluyyu ya nan a'apuyu an nan nangipaligligata' hinan i'Egypt ya nan nangata' ay didah nan umipanoh'a ya ma'at ta way panginnilaanyu an Ha\"in hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","At immuy da Moses ay Aaron hinan ali, ya inalidan hiyay, “Hi Apo Dios an dayawonmin Hudyu ya inalinay, Anuud nin di pangipa'ampaam hi odolmun Ha\"in? At iyabulutmuy akakan nan tatagu' ta umuydan mundayaw ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ti gulat ta iya'addim ya ipa'ali' di do'ol hi dudun hinan babluyyuh ma'et ");
INSERT INTO ifb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ta ho'napandan amin tun luta ta mi'id ahan mattig. Ya onondan amin hay way na'angang hi agguy pina\"in nan dalallu, ya ta\"on un nan ayiw an na'angang hinan payawyu. ");
INSERT INTO ifb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ya mun'apnudah nan abungmu, ya ta\"on nan abung di u'upihyalmu, ya nan abung di tatagum. Ya nidugah an atata'ot di aatdan mi'id ah umat hinah impaluh din a'apuyuh ene'damda.” Ya unat goh nalpah hanan inalin Moses ya nakak. ");
INSERT INTO ifb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ya inalin nan u'upihyal hinan aliy, “Anuud nin di pangidinngan ten lala'in mangipaligligat ay ditu'u? Mahapul an iyabulutmuy akakanda ta umuyda dayawon hi Apo Dios an Diosda! Undan adim tigon an ten pumuhi tun ad Egypt?” ");
INSERT INTO ifb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","At impa'ayag goh nan ali da Moses ay Aaron, ya inalina goh ay diday, “Mabalin an umuy ayu mundayaw ay Apo Dios an dayawonyu! Mu hay mahapul nin hi umuy?” ");
INSERT INTO ifb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ya tembal Moses, ya inalinay, “Mahapul an makak amin middum nan imbabaluymi an nan ung'ungungnga, ya nan nun'a'in'inna, ya nan nun'ala'ay. Ya pun'itnudmi goh an amin nan kalnilu, ya gandeng, ya nan bakami ti mahapul an munggotad amih pun'onnganmin Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ya inalin nan alin diday, “Hi Apo Dios di manalimun ay da'yuh un'u abuluton an makak ayu. Mu adi' ahan abuluton hi un mitnud nan binabai ya ung'ungungnga ti ma'innilan waday nomnomnomonyuh nappuhin aton! ");
INSERT INTO ifb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Adi' iyabulut! Ammuna ayun linala'ih umuy an mundayaw ay Apo Dios ti hiyah ne gunyu lupiton!” At numpakakna da Moses ay Aaron hinan wadana. ");
INSERT INTO ifb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ya inalin goh Apo Dios ay Moses di, “Ita'nangmuy ngamaymuh tun babluy ad Egypt ta malmuy dudun ta ho'napanda tun luta, ta pun'a'andan amin nan nihabal ya nan himmangaw an inang'ang di dalallu.” ");
INSERT INTO ifb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","At inta'nang goh Moses nan hul'udna, ya limmun Apo Dios di puo' an nalpuh appit di buhu'an nan algaw ta inyal'algawna, ya inlablabinan himmubuhubuud ad Egypt. Ya unat goh nabiggat hi helhelong ya niddum di dudun hinan puo'. ");
INSERT INTO ifb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ya linonapandan amin nan abablubabluy ad Egypt, ya nunheglan do'olda ahan ya un anggay heneh nidugah an do'ol hi tinnig nan i'Egypt ti mi'id ah umat hinah impaluhdah din penghana, ya adi goh mapidpidwah enggana. ");
INSERT INTO ifb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ya lenonapanda tun luta ta engganah un ngimmitit, at nun'a'andan amin din nihabal, ya nan himmangaw an inang'ang di dalallu, ya ta\"on nan bungan di ayiw, ya nan nitanom hi payaw ad Egypt, at mid ah ohah na'angang hi tubuda. ");
INSERT INTO ifb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ya nunnaudon nan alin nangipa'ayag ay da Moses ay Aaron, ya inalinay, “Numbahola' ay Apo Dios an dayawonyu, ya numbahola' goh ay da'yu! ");
INSERT INTO ifb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","At aliwanyu ni' heten numbahola' goh, ya nunluwalu ayun Apo Dios ta ipadinongna ni' ahan hatun nunheglan pummoltanan ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","At tinaynan Moses nan ali, ya nunluwalun Apo Dios ta mumbagah badang. ");
INSERT INTO ifb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","At binalliyang Apo Dios nan puo' ta hay appit hi a'unugan di algaw di nangipluyana ta iyaddibnan amin din dudun hinan Mumbolah an Baybay, at mi'id ah ohah na'angang hi dudun ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mu impahelot Apo Dios goh di nomnom nan ali ta omod unna agguy inyabulut di akakan nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ya inalin Apo Dios ay Moses di, “Ita'nangmu nan ngamaymud daya ta humelong an ay tipot hinad Egypt ta ahi'ap'apu'ap nan tatagu.” ");
INSERT INTO ifb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","At inta'nang Moses di hul'udna, ya hemmelong ahan an amin nan abablubabluy ad Egypt hi tuluy algaw. ");
INSERT INTO ifb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","At nan tataguh ad Egypt ya agguyda nuntitiggawan, ya agguyda goh limmahlahun hinan numpunhituwanda ti pa'ahhelong ahan. Mu nan awadan di nunhituwan nan holag Israel ya mapatal. ");
INSERT INTO ifb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","At ipa'ayag goh han alih Moses, ya inalinay, “Umuy ayu mahkay an mundayaw ay Apo Dios an ta\"on unyu itnud nan binabai ya nan imbabaluyyu! Mu adiyu itnud nan baka, ya kalnilu, ya gandeng ta diday mataynan hitu.” ");
INSERT INTO ifb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ya inalin Moses ay hiyay, “Mahapul ahan an waday e'nongmih Onong an Moghob ta e'nongmin Apo Dios hinan pundayawanmin Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","At an amin nan a'animalmi an mi'id ahan ah ma'ang'ang ta way e'nongmih nan pundayawanmin Apo Dios, ya agguymi ahan inilay e'nongmin Apo Dios ta nangamung hi un ami umatam hidi.” ");
INSERT INTO ifb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mu impahehelot Apo Dios nan nomnom din ali, at hiyaat unna adi iyabulut di akakanda. ");
INSERT INTO ifb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","At inalinan Moses di, “Makak'a ta taynana'! Ya adi'a ahan mahkay mumpatpatigaw ay ha\"in! Ti gulat ta mipattig'an ha\"in ya ipapatoy da'a!” ");
INSERT INTO ifb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ya inalin Moses di, “At umat ay hinay panapitmu at adia' mipatpattig ay he\"ah enggana!” ");
INSERT INTO ifb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ya waday impanomnom Apo Dios ay Moses an inalinay, “Hiyah te mahkay di angunuhnah pummolta' hinan ali ya nan tataguna. At malpah ay henen ma'at at iyabulutnay akakanyu, ya hay atonan mamakak ay da'yu ya punhunihun da'yu ta punnaudonay akakanyun ten babluy. ");
INSERT INTO ifb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","At ad ugwan ya alyom hinan linala'i ya binabain holag Israel ta mun'adawdah nan gina'un nan heneggonda an nan gina'un di odol an balitu' ya silver.” ");
INSERT INTO ifb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Hi Apo Dios ya indatnay pange'gonan nan i'Egypt hinan holag Israel ti ta\"on un nan u'upihyal ya nan tatagu ya ibilangdan hi Moses ya ongol di abalinana. ");
INSERT INTO ifb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","At intuluy Moses an ni'hapit hinan ali ya un mahkay makak an inalinay, “Hiyah te inalin Apo Dios an inalinay, Hi lumabi ya le'do' an amin tun ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ya an amin nan papangpangullun linala'in imbabaluy nan i'Egypt ya mun'atoydan mete\"ah nan pangpangullun lala'in imbaluymun mamnoh hi haadmu ta nangamung hinan pangpangullun imbaluy nan tatagalam an binabain hay tamuda ya un munggelgeleng hi bogah. Ya mun'atoy goh an amin nan nun'ahhun an imbabaluy nan a'animalyu. ");
INSERT INTO ifb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ya an amin nan abablubabluy hitud Egypt ya ma\"adngol di ahingungulngul an mid ah at hinah na'at hidin penghana ya hi awnih udum di algaw goh. ");
INSERT INTO ifb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mu nan holag Israel ya mi'id al'alin ta\"on nan ahu, ya mi'id ah mun'aluul ta way panginnilaanyun Ha\"in an hi Apo Dios ya agguy numpaddung di pangat'uh nan holag Israel ya nan i'Egypt. Hiyah ne inalin Apo Dios.” Ya intuluy Moses an himmapit, ya inalinay, “Inila' nan ma'at ti ");
INSERT INTO ifb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","an amin nan u'upihyalmu ya umalidan munluung an mangal'alu' ay ha\"in an alyonday, Ekakmun amin nan tatagum! Ta nalpah ay an inalida ya unna' mahkay makak.” Ya nidugah di bimmubungtan Moses hidin nanaynanah nan ali. ");
INSERT INTO ifb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ya gun tuwali alyon Apo Dios ay Moses di, “Manu ay adi da'a dongdonglon hinan ali ya ta way inat'un nangat hinan do'ol an umipanoh'ad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ya da Moses ay Aaron ya gunda inat an amin hanan umipanoh'ah nan wadan nan ali, mu impahehelot damdaman Apo Dios di nomnomna ta omod unna agguy inyabulut di akakan nan holag Israel hinan babluyda. ");
INSERT INTO ifb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ya ni'hapit goh hi Apo Dios ay da Moses ay Aaron hidid Egypt an alyonay, ");
INSERT INTO ifb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mete\"ad ugwan ya heten bulan di ibilangyuh hopap di bulan di hintawon hinan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","At mahapul an pun'ibagayun amin hinan holag Israel ta nan miyapulun algaw ad ugwan an bulan ya an amin nan linala'in o'ommod nan ohan pamilya ya way ohaan pilionay ohah nan uyaw an kalnilu. ");
INSERT INTO ifb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ya gulat ta nan nahnot an pamilya ta iniladan mi'id ologdan mangihdan amin hinan paltionda ya mahapul an mi'hapitdah nan ohan pamilyan heneggonda ta milammungdan didan mangihdan de han ohan mapalti. At mabalin an aminondan ihda ta mi'id ah ma'angang. ");
INSERT INTO ifb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Hay pilionda ya nan uyaw an kalnilu unu gandeng an ohay tawona an buta'al an mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ya ilahhinda nan uyaw ta engganah nan mahdom eden miyapulu ta opat an algaw nen bulan, ya daden hinohhan pamilyan holag Israel ya dedehhonondan golton nan kalniluda. ");
INSERT INTO ifb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ya alanda nan dalan nan mapalti, ya inlamuhdah nan gaub hinan numpinangngel an paneddeng, ya nan alegeng di pantaw, ya nan bagtun di pantaw nan abung eden wadan di pangihdandah nan napalti. ");
INSERT INTO ifb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ya henen mahdom ya mahapul an mihdan amin nan mipagan dotag nan mapalti, ya hay onondah pangihidaandah nan nipagan dotag ya nan tinapay an agguy nabino'bo'an ya nan halawhaw an mumpait. ");
INSERT INTO ifb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ya adiyu ihda nan ma'ata unu nan mihaang an nonong nan na'imul, ya impagayun middum nan uluna, ya hu'ina, ya an amin nan minalutuna. ");
INSERT INTO ifb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ya mahapul an mi'id ahan ah ma'angang hinan mabiggat, ta wada ay di ma'angang hi adiyu ihda ya mahapul an gohbonyu ya un mawa'ah. ");
INSERT INTO ifb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ya alyom ay dida ta mundadaanda, ya egtomday gina'uda, ya numbalikisda, ya idadaanday hul'udda, ya nunhapatusda ta midadaandan mumbaat, ya punnaudondan mangan ti hiyah ne gutud di pamaliwan Apo Dios ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ya inalin goh Apo Dios di, “Ya henen mahdom ya le'do' an amin nan abablubabluy ad Egypt ta pumpatoy'un amin nan pangpangullun imbabaluy nan i'Egypt ya ta\"on nan a'animalda. Ya pa\"io' an amin nan bulul an dayawon nan i'Egypt ta ipattig'un Ha\"in nan immannung an Dios. ");
INSERT INTO ifb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ya nan dalan nilamuh hinan abalubaluy ya hiyay pangimmatuna' hinan numpunhituwanyu, ya tigo' ay nan dala ya linauha' da'yu ta adi ayu mitagam hinan pummoltaa' hinan i'Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ya heden algaw di panginomnomanyuh nan namaliwa' ay da'yu, at Ha\"in an Dios di ibehtaanyuh atawotawon ta nangamung.” ");
INSERT INTO ifb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ya inalin goh Apo Dios ay da Moses di, “Adiyu onon nan nabino'bo'an an tinapay hi pituy algaw. Ya henen hopap di algaw ya mahapul an itapalyun amin nan bino'bo' an wah nan numpunhituwanyu. Mu gulat ta henen gutud di pituy algaw ya waday ohan da'yuh mangan hinan nabino'bo'an an tinapay ya mahapul an mapogpog di ibilanganah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ya nan hopap di algaw ya ma'amung ayu ta mundayaw ayun Ha\"in, ya umat goh hinay atonyuh nan miyapituh algaw. Ya henen algaw ya adi ayu muntamu an ammunay ononyuh ihaangyu ya anggay. ");
INSERT INTO ifb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","At gunyu ngilinon an egtadan heten algaw an agguyyu nanganan hi agguy nabino'bo'an an tinapay ti hiyah ne gutud di nangekaka' ay da'yud Egypt. At gunyu aton heteh atawotawon hi enggana, ya ipaboltanyuh nan holagyu. ");
INSERT INTO ifb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ya mete\"ah munhinag hinan miyapulu ta opat di algaw eden hopap di bulan ta engganah nan munhinag hinan miyaba'inti ta han ohay algaw di adiyu ahan panganan hinan tinapay an nabino'bo'an. ");
INSERT INTO ifb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","At henen pituy algaw ya mahapul an mi'id ah mipatpatang hi bino'bo' hinan numpunhituwanyu, ya umat goh hinan bunag. Mu gulat ta wadan da'yuy mangan hinan tinapay an nabino'bo'an ya mahapul an mapogpog di ibilanganah holag Israel an ta\"on un hiya ya bunag unu nitungaw eden babluy. ");
INSERT INTO ifb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ya adiyu onon di nabino'bo'an ta hay ononyuh nan a'abungyu ya nan agguy nabino'bo'an an tinapay.” ");
INSERT INTO ifb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","At impa'ayag Moses an amin nan a'ap'apun nan holag Israel, ya inalinan diday, “An amin ayu ya punnaudonyun pilion nan uyaw an kalnilu unu uyaw an gandeng an mun'olog ay da'yun hina\"ama, ya paltionyu ta way ihdayuh nan pamaliwan Apo Dios ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ya tayaonyuy dalanah nan duyu, ya innalyu nan holo' an hyssop an ay hanganga, ya bento'yu, ya intamolyuh nan dala, ya inlamuhyuh nan numpinangngel an paneddeng, ya nan alegeng hinan bagtun di pantaw nan a'abungyu. Mu an amin ayu ya mi'id ahan ah pumitaw ta nangamung mawa'ah hinan helhelong. ");
INSERT INTO ifb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ya gulat ta maluh hi Apo Dios hinan umuyna pumpamatayan hinan papangpangullun linala'in imbabaluy nan i'Egypt ya tigona ay ta waday dalah nilamuh hinan bagtun di pantaw ya nan paneddeng di a'abungyu ya hiyay pangimmatunan Apo Dios at lauhanay a'abungyu ta adi da'yu pi'tagam an pi'patoy. ");
INSERT INTO ifb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","At hiyah ne atonyuh atawotawon, ya mahapul an itugunyuh nan imbabaluyyu ta gunda aton heteh un madatngan nan gutud di a'atana. ");
INSERT INTO ifb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ya ta\"on un ayu dumatong hinan lutan ipaboltan Apo Dios ay da'yuh pumbabluyanyu ya mahapul an inaynayunyun gun ngilinon an egtadan heten algaw hi enggana. ");
INSERT INTO ifb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ya wa ay ta hanhanan nan imbabaluyyun alyonday, Anaad heten ngilin? ");
INSERT INTO ifb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ya hay pambalyu ya alyonyuy, Manu ay ngilinon an egtadan heten algaw ti hiyah te panginomnoman tu'uh nan nangiwangan Apo Dios hinan numpunhituwanmin holag Israel hi awadanmid Egypt ti numpatoynay i'Egypt, mu agguy da'mi.” At numpunhippi nan holag Israel, ya inyungyungda ta dayawondah Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","At nabu'alda ta immuyda inat nan inalin da Moses ay Aaron hi immandal Apo Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ya heden limmabi ya numpatoy Apo Dios nan papangpangullun linala'in imbabaluy nan i'Egypt an nihipun hinan imbaluy nan ali an mamoltan hinan haadna ta engganah nan imbabaluy nan nibalud hinan na'uhu' an lutan baludan, ya ta\"on nan nun'ahhun an imbabaluy nan a'animal. ");
INSERT INTO ifb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","At bimmangon nan ali, ya nan u'upihyalna, ya nan i'Egypt an ahikikilada ti an amin hinan numpunhituwanda ya waday natoy hi imbaluydah lala'in pangpangullu. ");
INSERT INTO ifb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","At heden nahdom ya impa'ayag nan ali da Moses ay Aaron, ya inalinay, “Makak ayu! Makak ayu! Ya itnudyun amin nan holag Israel ta umuy ayu mundayaw ay Apo Dios an hiyay ilupityun gun ibaga! ");
INSERT INTO ifb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ya pun'alayun amin nan animalyun baka, ya gandeng, ya kalnilu, ya impadehyu! Ya pi'luwaluyu ni' ahan ay Apo Dios ta wagahana'!” ");
INSERT INTO ifb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","At numpakak nan i'Egypt nan holag Israel ta punnaudondan makak hinan babluyda ti alyonday, “Ma'amin amin mun'atoy hi un ayu adi makak!” ");
INSERT INTO ifb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","At nun'alan nan holag Israel an amin nan na'angang an miyammah tinapay an agguy nabino'bo'an, ya inittudah nan duyun pungkiwalan hi tinapay, ya nunteplagandah lubungda, ya nun'ipi'ugda. ");
INSERT INTO ifb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ya inunud nan holag Israel an amin din inalin Moses an mahapul hi atonda. At nun'adawdah nan i'Egypt hi gina'un buung an silver, ya balitu', ya lubung ");
INSERT INTO ifb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ti hi Apo Dios ya indatnay pange'gonan nan i'Egypt hinan tatagun holag Israel, at nun'idatda nan penhoddah odowon. At binoltanda nan gina'un di i'Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","At hidid Rameses di nala\"uyan nan holag Israel ta ipluydad Sukkoth. Nan linala'i ya nahuluk hi onom di gahut di libu, ya agguy ni'bilang nan binabai ya nan ung'ungungnga. ");
INSERT INTO ifb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ya do'olday udumnah tatagun niddum an nitnud ay dida, ya nan do'ol an kalnilu, ya gandeng, ya baka. ");
INSERT INTO ifb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ya hay gutud di gunda anganan ya inhaangda din inodnandan balunda an agguy nabino'bo'an an din innaldad Egypt. Manu ay agguy nabino'bo'an ya unda napakak ti mi'id inatdan nanod hi bumladan nan nakiwal an alena. ");
INSERT INTO ifb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ya hay uyap di tawon hi ni'hituwan nan holag Israel ad Egypt ya opat di gahut ya han tulumpulu. ");
INSERT INTO ifb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ya heden immannung an angunuh di algaw den opat di gahut ta han tulumpulun tawon ya an amin nan tatagun Apo Dios ya nun'akakdad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ya heden nahdom di pento' Apo Dios hi pamakakanah nan tatagunad Egypt, at mahapul an gunda ibehtaan hi atawotawon ta panginomnomandah namaliwan Apo Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ya inalin Apo Dios ay da Moses ay Aaron di, “Hiya hatuy uldin hi ma'at hinan pumbehtaanyu. Mahapul an mi'id ah bunag hi me\"an ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","(Mu wada ay di himbutyu an bunag ya mahapul an kugitonyuh mahhun ya un me\"an.) ");
INSERT INTO ifb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Mu nan timpolary an bunag an ni'hitun da'yu ya nan timpolary goh an tagalayu ya adida me\"an. ");
INSERT INTO ifb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ya mahapul an hay baluy di pangananyun amin hinan ma'an, ya mi'id milahun hinan ihdayu, ya adiyu ahan ipungon nan tungal di dotag. ");
INSERT INTO ifb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ya an amin nan holag Israel ya mahapul an ibehtaandah ten algaw. ");
INSERT INTO ifb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ya gulat ta waday bunag an mangilih immiyan ta pohdonda ay an middum ay da'yun nen atonyu ya mahapul an kugitonyun amin nan linala'i ta mibilangdan umat hinan holag Israel. Ya mahapul an nan tagun agguy nakugit ya adida me\"an. ");
INSERT INTO ifb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hay punhulbian ten uldin ya nan holag Israel ya ta\"on nan bunag an ni'hitun da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","At inunud nan holag Israel an amin nan inalin Apo Dios ay da Moses ay Aaron hi atonda. ");
INSERT INTO ifb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","At henen algaw ya enekak Apo Dios an amin nan holag Israel ad Egypt an na'uhi'uhigdan ahimpahimpangapu. ");
INSERT INTO ifb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Idawatyun amin ay Ha\"in nan pangpangullun mitungaw an lala'ih nan holag Israel an tagu unu animal ta bagi'.” ");
INSERT INTO ifb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ya inalin Moses mah hinan tataguy, “Adiyu al'aliwan heten algaw ti hiyay nakakan tu'ud Egypt hi nangipaligligatandan ditu'u, ya nakak tu'un dumalat nan nidugah an abalinan Apo Dios. Ya mi'id mangan hinan tinapay an nabino'bo'an. ");
INSERT INTO ifb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","At ad ugwan an bulan di Aviv di akakanyu ");
INSERT INTO ifb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","an hiyay pumbehtaanyuh tinawon ti hiyah te algaw hi pangiyayan Apo Dios ay da'yuh nan lutan di iCanaan, ya iJebus, ya nan himpampun an holag Heth, ya holag Amor, ya holag Hiv. Henen luta an din intulag Apo Dios hidin o'ommod tu'uh din penghanan idatnan da'yu ya lo'eh an luta, at ma'almuy do'ol hi mitanom. ");
INSERT INTO ifb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ya hay onon tu'uh nan pituy algaw ya nan tinapay an agguy nabino'bo'an, ya henen miyapitun algaw di pumbehtaan tu'uh pundayawan tu'un Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ya henen pituy algaw ya adi tu'u ahan onon nan tinapay an nabino'bo'an, ya mahapul an mi'id ahan ah bino'bo' hi miwalwallang hinan abungyu. ");
INSERT INTO ifb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ya gulat ta mete\"a nan behta ya ulgudonyuh nan linala'in imbabaluyyun alyonyuy, Manu ay ma'at hatu ti dumalat nan abalinan Apo Dios, ya enekak da'mid Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ya henen behta ya hiyay mangipanomnom ya pangitigan an umat hi malkah ngamayyu ya uluyu ta nan Uldin Apo Dios di unudonyu ya hapitonyu. Ti dumalat nan nidugah an abalinan Apo Dios ya enekak da'mid Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","At gunyu aton heten behtah atawotawon hi un madatngan nan gutudna. ");
INSERT INTO ifb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ya gulat ta idatong da'yun Apo Dios hinan lutan di iCanaan an din intulagnan ditu'u ya nan a'apu tu'u ");
INSERT INTO ifb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ya mahapul an ilahhinyu nan pangpangullun imbaluyyun lala'i ta bagin Apo Dios. Ya ta\"on nan mahhun an buta'al unu manilhig an i'lum nan animal ya milahhin goh. ");
INSERT INTO ifb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mu mahapul an huwalonyuh uyaw an buta'al an kalnilu nan mahhun hi mi'lum an uyaw an manilhig an dongki, mu adiyu ay huwalon ya mahapul an ipungonyuy bagangna. Ya mahapul an huwalonyu goh an amin nan pangpangullun imbaluyyun lala'i. ");
INSERT INTO ifb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ya udum di algaw hi un way pangibagan nan imbabaluyyun linala'in alyonday, Hay itudun te nin han behta? ya alyonyun diday, Manu ay ya dumalat nan nidugah an abalinan Apo Dios, ya enekak da'mid Egypt hidin nipaligligatanmi! ");
INSERT INTO ifb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ti hidin pangiyadiyan nan alih akakanmi ya numpatoy Apo Dios an amin nan papangpangullun linala'in holag nan i'Egypt an ta\"on nan a'animalda. At hiyaat un mahapul an midawat an amin nan mahhun an mi'lum an animal ay Apo Dios ta bagina, mu mahapul an waday huwal nan pangpangullun mitungaw an lala'i. ");
INSERT INTO ifb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ya heten behta ya hiyay mangipanomnom ya pangitigan an umat hi malkah nan ngamayyu ya uluyu ta nan Uldin Apo Dios di unudonyu ya hapitonyu. Ti dumalat nan nidugah an abalinana ya enekak da'yud Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ya unat goh inyabulut nan ali an makakda nan holag Israel ad Egypt ya agguy inipluy Apo Dios didah nan lugal di iPhilistia an ta\"on un balah'at an dalan. Ti alyonay, “Gulat ta waday pi'gubatanda at mun'innomnom nan tatagu, at mumbangngaddad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","At hay nangipluyanah nange'wanda ya nan nalikaw an dalan hinan mapulun an midoo' hinan Mumbolah an Baybay. At nan holag Israel ya nakakdad Egypt an na'uhi'uhigdan mundaldalan, ya enegtomday almasdan hinohha. ");
INSERT INTO ifb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ya inta'in Moses din tungal Joseph ti hiyah ne inalin Joseph ay didan holag Israel. Ti inalinay, “Hi awnih pangekakan Apo Dios ay da'yud Egypt ya pi'yekakyu nan tungal'un ten babluy.” ");
INSERT INTO ifb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","At hidin nakakandad Sukkoth ya inipluydad Etham ta hidiy immiyanandah nan pingit nan mapulun. ");
INSERT INTO ifb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ya hi Apo Dios di nangipangpangulun dida, at wa ay ta nan mapatal ya linidumana dida, at waday damunan bunut an pa\"ongol an ay tu'ud an mamahhun ta hiyay unudonda. Ya wa ay ta nan mahdom ya mundalang heden bunut ta waday pundilagda, at ta\"on un nan mahdom ya mumbaatda. ");
INSERT INTO ifb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ya nunnonngon Apo Dios heden bunut an ay tu'ud hinan pumbaatandah nan mapatal ya mahdom. ");
INSERT INTO ifb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Alyom hinan holag Israel ta mumbangngad ayu ta hidiy umapalanyuh nan neheggon ad Pi Hahiroth an numbattanan ad Migdol ya nan baybay an neheggon ad Ba'al Zephon. ");
INSERT INTO ifb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ta hay ninomnom nan ali atog ya alyonay, Nan holag Israel ya matengtengawda ti napogpog nan dalan, at mi'id pange'wandah nan mapulun! ");
INSERT INTO ifb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ya ipa'odhol'u goh di nomnom nan ali, at ipapdug da'yu ta way aton nan ali ya nan titindalun mangipabagtun Ha\"in. Ya hiyay panginnilaan nan i'Egypt an immannung an Ha\"in di Ap'apun nan holag Israel.” Henen imbagan Apo Dios di inunud nan holag Israel hi pange'wanda. ");
INSERT INTO ifb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ya unat goh impa'inniladah nan alid Egypt nan nakakan nan holag Israel ya muntutuyu an ta\"on un nan u'upihyalnah nan nangiyabulutandan akakan nan tatagu. Ya inaliday, “Anaad tuwali ta pinakak tu'u dida? Tigonyu an mi'id mah di babbaalon tu'u!” ");
INSERT INTO ifb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","At impidadaan nan ali nan kalesanan punluganan di mi'gubat ta hiyay mangipangpanguluh nan akakanda, ya imbaganah nan tindaluna ta mundadaanda ");
INSERT INTO ifb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ta mitnuddan munlugan nan u'upihyal di tindalu an mepongdan milugan hinan onom di gahut an ma\"aphod an lugan, ya nan udum an punluganan. ");
INSERT INTO ifb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ti hi Apo Dios ya immannung an impa'odholnay nomnom nan ali, at pindugda nan holag Israel an natuliddan nunlinggo. ");
INSERT INTO ifb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","At do'ol nan kabayun nan Alin hi Pharaoh, ya nan lugana, ya nan u'upihyalna an namdug hinan holag Israel, ya inah'upanda nan holag Israel hinan immapalandah nan pingit di baybay an neheggon hi ad Pi Hahiroth an dammang ad Ba'al Zephon. ");
INSERT INTO ifb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ya unat goh na'uy an ataman nan i'Egypt dida ya inamang nan holag Israel daden tindalun mamdug ay dida, ya ma'atta'otda ahan, at ahipopokawdan mumpabadang ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ya inalidan Moses di, “Undan dumalat di ami'idan di lubu' hi ad Egypt at hiyaat un da'miy inyalih tun mapulun ta hiyay atayanmi? Tigom adyay ma'ma'at hinan nangekakam ay da'mid Egypt! ");
INSERT INTO ifb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Unmi dan agguy inalin he\"ah din awadan tu'ud Egypt hi onaynah un da'mi taynan an ta\"on un ami munnononnong hi baal nan i'Egypt? Ti odolnah un da'mi baalon hinan i'Egypt ya un han matoy hituh tun mapulun!” ");
INSERT INTO ifb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ya tembal Moses an inalinah nan tataguy, “Adi ayu tuma'ot ta un ayuat duminong ta tigonyuy aton Apo Dios an mamaliw ay ditu'ud ugwan an algaw! Ti danen i'Egypt an titiggonyud ugwan ya adiyu dida mahkay tigon! ");
INSERT INTO ifb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","At okod hi Apo Dios an mangubat ay dida, at hay maphod hi atonyu ya un nonong ya dimminong ayu!” ");
INSERT INTO ifb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ya inalin Apo Dios ay Moses di, “Anaad ta pumkaw'an mumpabadang ay Ha\"in? Alyom hinan tatagu ta inaynayundan umuy. ");
INSERT INTO ifb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ya eldongmu nan hul'udmuh nan appit di baybay, at munhiyan an matob'a' nan danum ta nan mamagan lutay dalanon nan holag Israel an bumad'ang. ");
INSERT INTO ifb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mu ipa'odhol'uy nomnom nan i'Egypt ta way atondan mangilulud an mangunud ay da'yuh nan gagwan di baybay ta hiyay a'innilaan di anabagbagtu' an dumalat nan pangabaka' hinan ali, ya nan titindaluna, ya nan u'upihyalna, ya nan pama\"ia' hinan kalesan numpunlugananda. ");
INSERT INTO ifb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ya nan pangabaka' ay diday panginnilaan nan i'Egypt an Ha\"in hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ya nan Anghel Apo Dios an din gun mangipanguluh nan holag Israel ya nahlig an nebnog ay dida, ya ta\"on goh nan ma'ugtul an bunut an nangipangpangulun dida ya nahlig an nebnog ay dida ");
INSERT INTO ifb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ta nibattan hinan immapalan nan holag Israel ya nan immapalan nan titindalun di i'Egypt. At helong hinan wadan di i'Egypt, ya mapatal hinan wadan di holag Israel, at hiyanan agguy inataman nan titindalu dida. ");
INSERT INTO ifb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ya inta'nang Moses an eneldong din hul'udnah nan way baybay, ya impatuyup Apo Dios nan mabi'ah an tuyup an nalpuh nan buhu'an di algaw, at inlablabinan hinubuhubuudan nan danum. Ya natob'a' nan danum, at mattig nan luta. ");
INSERT INTO ifb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","At ene'wan nan holag Israel hinan mamagan lutah nan way natob'a'an di danum an ay nida'lig hi numpinangngel. ");
INSERT INTO ifb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ya din titindalun di i'Egypt, ya nan do'ol an kabayun di ali, ya nan kalesan lugan goh di ali, ya nan udumnan numpungkabayu ya nangun'unudda an pudugonda didah nan gagwan di baybay. ");
INSERT INTO ifb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ya unat goh wan mun'awawa'ah ya inuhdungan Apo Dios nan titindalun di i'Egypt ti wagwah dih nan way bunut an ay apuy, ya hinaliwana dida. ");
INSERT INTO ifb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","At nungkumhunay pilid di nunlugananda, at adida mahlig. Ya inalin nan i'Egypt di, “Un tu'uat mumbangngad ti ini an hi Apo Dios di mi'gubat ay ditu'uh mangibaliw hinan holag Israel!” ");
INSERT INTO ifb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ya unat goh wan dimmammang nan holag Israel hinan baybay ya inalin goh Apo Dios ay Moses di, “Ita'nangmuy hul'udmu, ya eneldongmuh nan baybay ta mun'addum nan danum ta mun'alnongda nan kalesan nunluganan di i'Egypt, ya nan nunluganan di u'upihyal, ya nan numpungkabayu.” ");
INSERT INTO ifb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","At inta'nang Moses di hul'udna, ya eneldongnah nan baybay, at unat goh wan mawa'ah ya nun'addum din danum an numbangngad hidin aatna tuwali. At nan i'Egypt ya numbangngadda an limmayaw, mu hi Apo Dios ya nunlonongona didah nan gagwan di baybay. ");
INSERT INTO ifb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","At nun'addum nan danum, ya nun'ahe'nob an amin din numpungkabayu, ya an amin din titindalun di i'Egypt an namdug hinan holag Israel hinan baybay, ya mi'id ah ohah matagun dida. ");
INSERT INTO ifb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mu nan holag Israel ya dinalanda nan mamagan lutah nan gagwan di baybay an nada'ligan hi danum di numpinangngel. ");
INSERT INTO ifb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","At heden algaw ya binaliwan Apo Dios nan holag Israel hi namdugan nan i'Egypt. Ya tinnigdan nun'atoy nan i'Egypt an nun'ihaba'lagdah nan pingit di baybay. ");
INSERT INTO ifb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","At tinnig nan holag Israel nan nidugah an abalinan Apo Dios hi nangabakanah nan i'Egypt at ta'tanda mahkay hi Apo Dios, ya wada mahkay di pangulugdan Hiya, ya unudonda goh hi Moses an baalna. ");
INSERT INTO ifb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ya ingkantan da Moses ya nan holag Israel nan kantah nundayawdan Apo Dios an inalinay, “Ikantaa' hi Apo Dios an Hiyay nabagbagtun me'gonan ti nan kabayu ya nan numpuntakay ya nun'ipalnongna didah nan baybay! ");
INSERT INTO ifb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hi Apo Dios di nangidat hi bi'ah'u ya nan abalina', at Hiyay ikantaa', ya Hiya goh di namaliw ay ha\"in, ya Hiyay Dios an ipabagtu' ya dayawo' an dinayaw din o'ommod'u! ");
INSERT INTO ifb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hi Apo Dios di ngadan nan mangab'abak hinan gubat, ");
INSERT INTO ifb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ya inubahna nan tindalu ya nan kalesan punluganan di alid Egypt hinan baybay, ya ta\"on nan nabagbagtun u'upihyal di tindalu ya nun'alnongdah nan Mumbolah an Baybay. ");
INSERT INTO ifb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Hene'nob nan maluhung an baybay dida, at ayda batun numpunlonong hi bunolna. ");
INSERT INTO ifb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Nan agwan an ngamaymu, Apo Dios, ya nidugah di abalinanan mangam'ameh ti numpuhitmuy binuhulmu. ");
INSERT INTO ifb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Dumalat nan nidugah an abalinam ya inabakmu nan binuhulmu. Nan bungotmu ya ay apuy, at gohbona dida an ay ulut. ");
INSERT INTO ifb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ya unmu hinodohdaan ya natob'a' nan danum hi baybay, ya nida'lig hinan numpinangngel an ay gaub. ");
INSERT INTO ifb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ya alyon nan mi'buhul di, Pudugo' ta ah'upa' dida, ya hinamham'un amin nan gina'uda, ya godwo' ta ala' nan pohdo', ya nan hanggap'uy pamatoy'un dida! ");
INSERT INTO ifb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mu hinapudan Apo Dios nan baybay, ya nun'he'nob nan atata'ot an danum nan i'Egypt hinan atata'ot an danum an umat hi batun di bungwit an nunlonong. ");
INSERT INTO ifb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ya mid hinan udumnan dios di nipaddung ay He\"a, Apo Dios, hinan aatmu! Ti He\"a ya anggay di ma\"aphod di anahamadna, ya He\"ay mangat hinan umipanoh'a, ya mata'tan'an dumalat nan anabagtum! ");
INSERT INTO ifb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ya unmu eneldong nan agwanmu, ya inubah tun lutay binuhulmi. ");
INSERT INTO ifb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dumalat nan adi mapogpog an pamhodmu ya impangulum nan binaliwam an tatagu, ya hinalimunam ta inyuymu didah nan maphod an luta. ");
INSERT INTO ifb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ya unat goh dengngol nan tataguh nan abablubabluy ya womogwogdah ta'otda, ya umat goh hinan iPhilistia. ");
INSERT INTO ifb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ya timma'otda goh nan a'ap'apud Edom, ya womogwog nan mumpumpapto' hinan iMoab, ya nan tatagud Canaan ya limmungtuydah ta'otda. ");
INSERT INTO ifb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ya nidugah di ta'otda, at nun'ahemongda, ya dumalat nan nidugah an abalinam, Apo Dios, an tinnigda ya namolda an paddungnay umatdah batu ta engganah un naluh nan tatagum an pento'mu. ");
INSERT INTO ifb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ta iyuymu didah nan duntug an idatmun dida ta banohda, ya hidiy pangiyammaam hinan Timplu an punhituwam. ");
INSERT INTO ifb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Immannung an hi Apo Dios di mun'alih mid pogpogna!” ");
INSERT INTO ifb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nan holag Israel ya linauhanda nan baybay an nan mamagay nange'wanda. Ya inunud nan u'upihyal an numpunlugan hinan kabayu ya nan udum an titindalu, mu nun'addumon Apo Dios nan danum, at nun'alnongda. ");
INSERT INTO ifb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ya nan babain propetan hi Miriam an agin Aaron ya innalna din tambourine ta impagangohna, ya nangunud an amin nan binabain numpangdon goh hi tambourine, ya nanayawda. ");
INSERT INTO ifb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ya ingkantaan Miriam didan inalinay, “Ikantaanyuh Apo Dios an Hiyay nabagbagtun me'gonan ti nan kabayu ya nan numpuntakay ya nun'ipalnongna didah nan baybay!” ");
INSERT INTO ifb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ya impang'un goh Moses nan holag Israel ta tinaynanda nan Mumbolah an Baybay ta immuydah nan mapulun hi ad Shur. Ya tuluy algaw di dimmanallanandah nan mapulun, ya mi'id ah inah'upandah danum. ");
INSERT INTO ifb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ya la'tot ya nidatongdad Marah, mu adi mabalin an ma'inum nan danum hidi ti mumpait (at hiyanan nangadnan hi ad Marah). ");
INSERT INTO ifb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","At nan tatagu ya tayubtubandah Moses an alyonday, “Hay pangngalan tu'uh inumon mah?” ");
INSERT INTO ifb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","At init'u' Moses an nunluwalun numpabadang ay Apo Dios, ya intudun Apo Dios han penton ta ipa'wahnah nan obob, at numbalin heden danum hi maphod an ma'inum. Ya hidid Marah di nangidatan Apo Dios hi uldin an mahapul hi unudonda, ya hidi goh di nanapngan Apo Dios ay didan ");
INSERT INTO ifb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","inalinay, “Donglonyu ay an nahamad nan hapito', ya atonyu nan maphod, ya unudonyu nan maphod an intugun'u at adi' da'yu moltaon hinan dogoh an umat hinan nummolta' hinan i'Egypt ti Ha\"in hi Apo Dios an Mangiyadaog hinan Pundoghanyu.” ");
INSERT INTO ifb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ya impadehda goh ta nangamung unda nidatong ad Elim hi wadan nan himpulu ta duwan obob, ya wada goh di palma an napituy puu, at hidiy immapalandah nan way neheggon hinan obob. ");
INSERT INTO ifb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ya hidid Elim di nangila\"uyan nan holag Israel ta numbaatda, ya nidatongdah nan palantag an Mapulun an Sin an numbattanan ad Elim ya ad Sinai, ya heden dimmatngandah di ya miyapulu ta leman algaw eden miyadwan bulan hi nakakandad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ya hay wadandan de han mapulun ya tinayubtuban nan tatagu da Moses ay Aaron ");
INSERT INTO ifb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","an inaliday, “Onaynah un da'mi numpatoy ay Apo Dios hi awadanmid Egypt ti hidi ya waday dotag hi mihda, ya do'ol di ma'an, at ma\"abhug ami! Ya ten un da'miy inyalih tun mapulun ta hay hinaangmiy iyatoymin amin!” ");
INSERT INTO ifb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ya inalin Apo Dios ay Moses di, “Ad ugwan ya ipa'ali' di ma'an an malpud abuniyan an umat hi udan ta way ononyun amin. At alyom hinan tatagu ta binigat ya umuyda amungon di mun'olog hi onondan den algaw ya ammuna. Ya tapnga' dida ta panniga' hi unda unudon nan intugun'un dida. ");
INSERT INTO ifb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ya nan miyonom hi algaw ya mahapul an amungonyuy mun'olog hi ononyuh duway algaw.” ");
INSERT INTO ifb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","At inalin da Moses ay Aaron hinan tataguy, “Hi mapuyaw di panginnilaanyun hi Apo Dios di nangekak ay da'yud Egypt, ");
INSERT INTO ifb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ya hi helhelong ya tigonyuy na'abbagbagtun abalinan Apo Dios ti dengngolna din umamuyuanyun Hiya. Ti undan tuwaliy way abalinanmi ta da'miy umamuyuanyu?” ");
INSERT INTO ifb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","At inalin goh Moses di, “Hi mapuyaw ya lumuwon Apo Dios di dotag hi ihdayu, ya nan helhelong ya malmuy nidugah an do'ol an ma'an ta way ononyu ti dengngol Apo Dios nan pangamuyuanyun Hiya. Immannung an bo'on da'miy inamuyuanyu ti hi Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","At inalin Moses ay Aaron di, “Ayagam an amin nan holag Israel ta umalidan ma'amung hinan wadan Apo Dios ti dengngolna nan umamuyuanda.” ");
INSERT INTO ifb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","At heden na'amungan an amin nan holag Israel ya ni'hapit hi Aaron hinan tatagu ta hagangonday appit hi mapulun. Ya hin'alina ya waday humilin benang Apo Dios an nalpuh nan way bunut. ");
INSERT INTO ifb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ya himmapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Dengngol'u nan umamuyuan nan holag Israel. At alyom ay diday, Hi mapuyaw hinan munhinag ya mawaday dotag hi ihdayu, ya nan mabiggat hi helhelong ya mawaday do'ol hi ma'an hi ononyu ta nangamung un ayu ma\"abhug. Ya manu ay ato' di umat hina ya ta way panginnilaandan Ha\"in an hi Apo Dios di manalimun ay dida.” ");
INSERT INTO ifb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ya heden napuyaw ya nalmuy do'ol ahan an bagit ta lennapanda nan immapalanda. Ya unat goh nabiggat hi helhelong ya dimmulnun amin nan nunlene'woh hinan apal. ");
INSERT INTO ifb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ya unat goh namaganan din dulnu ya waday tinnigdah ahipapaha' an i\"itang hinan luta. ");
INSERT INTO ifb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ya unat goh tinnig nan holag Israel at mumbabaggaandan alyonday, “Hay ngadana?” Ya manu ay hiyah ne nangalida ti mi'id iniladah aatna. Ya inalin Moses ay diday, “Hiya hatuy ma'an hi indat Apo Dios hi ononyu! ");
INSERT INTO ifb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","At hiyah te immandal Apo Dios hi atonyu ta an amin ayu ya mahapul an hay mun'olog hi ononyun hina\"amah ohay algaw di amungonyu. At nan ohan tagu ya godwan di halub di bingayna.” ");
INSERT INTO ifb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","At hiyah ne inat nan holag Israel, at do'ol di inamung nan udumna ya un nan udumna. ");
INSERT INTO ifb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ya unat goh hinalubda ya nan nangngal hi do'do'ol ya nun'olog, ya nan nangngal hi itang ya nun'olog goh ti henen inamungda ya mun'olog hi onon di ohay taguh hin'algaw. ");
INSERT INTO ifb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","At padanan Moses didan inalinay, “Mi'id ah ang'angonyuh nan ma'an hi nomnomonyuh ononyuh ma'et!” ");
INSERT INTO ifb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mu nan udumna ya agguyda inat nan inalin Moses, ya inang'angday udumnah nan ma'an. Ya unat goh nabiggat hi helhelong ya tinnigdan nun'abigihan ya ahi'a'agub an nun'adogom, at ma'abbungot hi Moses ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ya binigat an way ohaan amungonay mun'olog hi onona. Mu nan agguy na'ala ya wa ay ta hum'it nan potang ya mun'a'ubahda. ");
INSERT INTO ifb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ya nan miyonom an algaw ya nun'udmanday amungondah nan ma'an an hinohhay halub ta mun'olog hi onon di hinohhah duway algaw. Ya immuy nan mangipangpanguluh nan himpampun an mangihudhudol ay Moses eden inatda. ");
INSERT INTO ifb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ya inalin Moses ay diday, “Hi Apo Dios di nangali an hi bigat an miyapituh algaw ya ngilin hi pun'eblayan tu'u ta dayawon tu'u Hiya. At ad ugwan an miyonom an algaw ya idadaanyuy ma'an, ya malgom di atonyun munhaang, mu ta do'lonyuy ihaangyu ta way ma'angang hi ononyuh nan mabiggat.” ");
INSERT INTO ifb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","At heden inalin Moses di inat nan tatagu ti intaleponday nahawal hinan nalutu ta way ononda. Ya unat goh nabiggat ya agguy nadogom, ya agguy goh nabigihan heden intaleponda. ");
INSERT INTO ifb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","At inalin Moses ay diday, “Ononyud ugwan ti hiyah te miyapituh algaw an ngilin ta hi Apo Dios di dayawon tu'u. At mi'id di amungonyuh ma'an ad ugwan an algaw. ");
INSERT INTO ifb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","At nan miyonom hi algaw di pangamunganyuh ma'an, mu nan miyapitun algaw ya hiyah ne algaw hi pun'eblayan, at mi'id ma'an hi midat.” ");
INSERT INTO ifb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mu heden miyapitun algaw ya wadada damdamay udumnah umuy an mantong hi ma'an, mu mi'id ah am'amungit hi inah'upanda. ");
INSERT INTO ifb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ya inalin Apo Dios ay Moses di, “Anuud mah nin di pangunudan nan tatagu ya pangatandah nan immandal'un dida? ");
INSERT INTO ifb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Adiyu aliwan an Ha\"in an hi Apo Dios ya inabulut'u an un ohay algaw hi pun'eblayanyu, at hiyaat un wa ay ta nan miyonom hi algaw ya idat'uy mun'olog hi ononyuh duway algaw ta nan miyapitun algaw ya mahapul an adi ayu malaa' hinan awadanyu!” ");
INSERT INTO ifb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","At hiyay inat nan tatagu an wa ay ta nadatngan nan miyapitun algaw ya mun'eblayda. ");
INSERT INTO ifb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ya hay nungngadan di holag Israel eden ma'an ya manna. Ya hay tigawna ya umat hinan mumpaha' an bugwa, ya hay tamtamna ya umat hinan mayapit an tinapay an nihaang hi nalamutan hi danum di alig. ");
INSERT INTO ifb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ya inalin Moses di, “Hiyah te immandal Apo Dios hi aton tu'u ti mahapul an italepon tu'uy ohay halub hinan manna ta way tigon di a'apu tu'uh pidwa ta innilaondan hiyah ne indat Apo Dios hi intanud tu'uh din awadan tu'uh nan mapulun hi nangekakanan ditu'ud Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","At inalin Moses ay Aaron di, “Alam ah it'ittang hi tibung, ya inittum di hinhalub hinan manna, ya inyuymun italepon hinan way pundayawan ay Apo Dios ta way tigon di a'apu tu'uh udum di algaw.” ");
INSERT INTO ifb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","At inat Aaron nan inalin Moses, at inittuna nan manna hinan it'ittang an tibung, ya intaleponah nan way hinagang nan Kahon an Nittuwan di Uldin hinan Nidugah an Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ya nan holag Israel ya hay mannay intanuddah awadandah nan mapulun hi napat di tawon ta nangamung unda nidatong ad Canaan ta hiyay nunhituwanda. ");
INSERT INTO ifb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ya hay nipaddungan di nanalubdah nan manna ya duwan litlo. ");
INSERT INTO ifb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ya tinaynan nan holag Israel nan Mapulun an Sin ta innaynayundan numbaat hinan abablubabluy hi pangipanguluan Apo Dios ay dida. Ya immapaldad Rephidim, mu mi'id danum hi inumon nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","At inamuyuandah Moses an inaliday, “Umidat'ah danum hi inumonmi!” Ya inalin Moses ay diday, “Anaad ta amuyuana'? Unyu dan tapngan hi Apo Dios?” ");
INSERT INTO ifb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mu nan tatagu ya nun'a'uwawda ahan, at gunda amuyuan hi Moses an alyonday, “Undan hiyah te nangekakam ay da'mid Egypt ta un da'miy patayon an middum an amin nan imbabaluymi, ya ta\"on nan a'animalmin dumalat di inuwawmi?” ");
INSERT INTO ifb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","At nunluwaluh Moses an inyal'alu'nan Apo Dios ta mumpabadang an alyonay, “Hay ato' mah nin ay daten tatagu? Ti ten niyayanah unna' puntapa!” ");
INSERT INTO ifb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ya inalin Apo Dios ay Moses di, “Itnudmu nan mumpumpapto' hinan holag Israel ta ipangpang'uyu ya unda mitnud nan tatagu, ya ita'inmu din hul'ud an din nanaplatmuh nan Wangwang an Nile. ");
INSERT INTO ifb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ya wagwadaa' an manod ay da'yuh nan way ongol an batud Horeb. Ya dolta'om nan batu, at bumuhu' di danum ta way inumon nan tatagu.” At inat Moses, ya teten'ol nan mumpumpapto' hinan holag Israel an ni'yibbana. ");
INSERT INTO ifb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ya nginadnanah den babluy ta hi Massah ya Meribah ti dumalat nan umamuyuan nan holag Israel ya nan nanapngandan Apo Dios an inaliday, “Halimunan ditu'u nin ay Apo Dios unu adi ditu'u?” ");
INSERT INTO ifb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ya hidih awadan nan holag Israel ad Rephidim ya immuy ginubat nan holag Amalek dida. ");
INSERT INTO ifb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ya inalin Moses ay Joshua di, “Pot'om di udum hinan linala'i ta da'yuy umuy an mi'gubat hinan holag Amalek hi ma'et, ya ha\"in ya umuya' hinan tulid di duntug, ya tuma'doga' ta ita'nang'u nan hul'ud an din inalin Apo Dios hi itata'in'u.” ");
INSERT INTO ifb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","At inat Joshua din inalin Moses ay hiyah atona, ya immuy ni'gubat hinan holag Amalek. Ya da Moses, ya hi Aaron, ya hi Hur ya immuydah nan tulid di duntug. ");
INSERT INTO ifb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ya hidin nunggugubatanda ya wa ay ta inta'nang Moses nan ngamayna ya nan holag Israel di mangab'abak, mu wa ay ta yo'nonay ngamayna ya nan holag Amalek di mangab'abak. ");
INSERT INTO ifb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mu unat goh na\"ablay hi Moses an nangitata'nang hidin hul'ud at inyuy da Aaron ay Hur han batu ta umbunana. Ya numpinangngeldan nanamdon hi ngamay Moses ta nitata'nang nan hul'ud ta nangamung na'unug nan algaw. ");
INSERT INTO ifb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","At hiyah de nangabakan da Joshua hinan holag Amalek. ");
INSERT INTO ifb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ya inalin goh Apo Dios ay Moses di, “Itudo'muh teh nan liblu ta panginomnoman ta adi ma'aliwan, ya ilupitmu an alyon ay Joshua an Ha\"in ya ubaho' an amin nan holag Amalek ta ma'aliwandah tun luta.” ");
INSERT INTO ifb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","At inyamman Moses han pun'onngan, ya nginadnana ta Hi Apo Dios di ay Bantila. ");
INSERT INTO ifb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ya manu ay nginadnanah ne ti intata'nang Moses nan hul'ud an ay bantila ta way atonan mumpabadang ay Apo Dios. Ya inalina goh di, “Immannung an hi Apo Dios di okod an bumadang hinan a'ap'apu tu'u, at Hiya goh di mananggah nan holag Amalek hi udum di algaw.” ");
INSERT INTO ifb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ya hi Jethro an padid Midian an hi aman ahawan Moses ya dengngolnan amin nan namadangan Apo Dios ay da Moses ya nan tataguna an holag Israel an nete\"ah din nangekakanan didad Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ya initnud Jethro hi Zipporah an ahawan Moses ti numbangngad hi abung da amana, ");
INSERT INTO ifb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ya ni'bangngad goh nan duwan linala'in imbabaluyna. Ya hay ngadan di nahhun ya hi Gershom ti hi Moses ya imbilangnay odolnah un mangilin bunag eden babluy, ");
INSERT INTO ifb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ya hay ngadan di miyadwa ya hi Eliezer ti inalinay, “Hi Apo Dios an dinayaw din o'ommod'uy bimmadang ay ha\"in ta agguya' pinatoy hinan alid Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ya hi Jethro an hi aman ahawan Moses ya nitnud ay Zipporah ya hinan duwan imbabaluynah nan immapalan da Moses hinan duntug ta immuydah nan duntug hi mapulun an wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Mu impaadna tuwalih nahhun ay Moses an inalinay, “Umalia' an mumbihhitan he\"a, ya itnud'u nan ahawam ya nan duwan imbabaluymun linala'i.” ");
INSERT INTO ifb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","At hiyaat un immuy hi Moses ta damuwonah aman ahawanan hi Jethro, ya nunluung hi hinagangna ta e'gonana hiya, ya nun'apngada, ya innayundan umuy hinan tuldan Moses. ");
INSERT INTO ifb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ya inulgud Moses ay Jethro an amin di ina'inat Apo Dios hinan ali ya nan i'Egypt ta way inatnan namaliw hinan holag Israel, ya inulgudna goh di aat nan hinoltapdah nan enengwada ya hay inat Apo Dios an namadang ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ya unat goh dengngol Jethro an amin hanan maphod an inat Apo Dios hinan holag Israel ya ma\"am'amlong, ");
INSERT INTO ifb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ya inalinay, “Mipabagbagtuh Apo Dios an namaliw ay da'yuh nan ina'inat di ali ya nan tatagunah ad Egypt, ya mipabagbagtu goh hi Apo Dios ti enekak da'yuh nan nipaligligatanyu! ");
INSERT INTO ifb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","At ad ugwan mahkay ya inila' an hi Apo Dios di na'abbagbagtu ya un nan udum an dios ti binaliwan da'yuh nan ina'inat di i'Egypt ya nan nangipaligligatandan da'yu!” ");
INSERT INTO ifb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ya inyuy Jethro nan e'nongnan Apo Dios an Onong an Moghob ya nan udum goh an e'nongnan Hiya. Ya nitnud da Aaron ya nan mumpumpapto' hinan holag Israel ta umuydan mi'dayaw ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ya heden nabiggat ya inumbun hi Moses hinan umbunan di munhumalya ta ipanuhna nan pumbobohholan nan tatagu, ya timmata'dog nan tataguh hinagangnan nete\"ah helhelong ta engganah nahdom. ");
INSERT INTO ifb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ya unat goh tinnig Jethro nan inat Moses ya inalinay, “Hay umatan nen inatmuh nan tatagu? Anaad ta he\"a ya anggay di inumbun an mangipanuh hinan diklamun nan tatagu, ya ten unda tumata'dog an mete\"ah helhelong ta engganay mahdom?” ");
INSERT INTO ifb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ya tembal Moses an inalinay, “Mahapul an ato' hina ti nan tatagu ya ha\"in di umaliandan mummahmah hinan aton Apo Dios hinan diklamuda. ");
INSERT INTO ifb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ti gulat ta han duwan tagu ta mumbohholda ya umalidan ha\"in ta ha\"in di okod an mangipanuh ta ma'innilay numbahol ay dida. Ya inayun'un ipa'innilan dida nan Tugun ya Uldin Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ya inalin Jethro ay hiyay, “Henen atom ya adi maphod ");
INSERT INTO ifb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ti un hay odolmuy boloyom ya nan nitnud ay he\"a! Ti henen tamum ya na'alligat, at adim abalinan an ohhaan an aton. ");
INSERT INTO ifb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Hay maphod ya donglom tun itugun'u, at hi Apo Dios di bumadang ay he\"a. Ti he\"ay mangihapit hinan tatagun Apo Dios, at an amin nan pumbobohholan nan tatagu ya ipa'innilam ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ya itudum ay dida nan Tugun Apo Dios, ya nan Uldina, ya nan atondan mangunud, at pumhod di ugalida. ");
INSERT INTO ifb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mu mahapul an piliom nan nanomnoman an linala'in mangita'ot ay Apo Dios an adi munlayah ya adi ummal hi bayad an mili\"ud ta diday mumbalin hi mumpapto' hinan himpampun an tatagu an hinlilibuy bilangda, unu hinggagahut, unu hinnanabongle, unu himpupulu ");
INSERT INTO ifb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ta diday mumpanuh hinan way pumbobohholan nan tatagu. Mu wada ay di naligat an adida abalinan an mangipanuh ya hiyay iyalidan he\"a ta nan madadawoh ya mabalin an okoddan mangipanuh. Ya umat ay hinay atom at adi'a maligatan ti mahngan di tamum ti mumbabaddangan ayu. ");
INSERT INTO ifb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ya unudom ay henen intugun'uh atom ya iyabulut goh Apo Dios henen atom at manghan di ablayam, ya umat goh hinan tatagun malenggopdan umanamut.” ");
INSERT INTO ifb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","At inunud Moses an amin nan intugun Jethro an ommod ahawana. ");
INSERT INTO ifb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","At pento'nay udum hinan linala'in holag Israel an waday abalinandan mumpanuh hi diklamu ta diday mumpapto' hinan hinlilibun tatagu, unu hinggagahut, unu hinnanabongle, unu himpupulun tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ta diday okod an gun mangipanuh hinan madadawoh an diklamun di tatagu, ta nan naligat an adida abalinan di hiyay iyuydan Moses. ");
INSERT INTO ifb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ya intulud Moses hi Jethro an hi aman ahawanah nan owon hi pumbangngadanah babluyda. ");
INSERT INTO ifb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ya heden hopap di algaw eden miyatlun bulan hi nakakan nan holag Israel ad Egypt ya nidatongdah nan Mapulun an Sinai, ");
INSERT INTO ifb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ya nalpudad Rephidim ta nidatongdah dih nan Mapulun an Sinai. Ya hidiy immapalan nan holag Israel hinan way hinagang di Duntug an Sinai. ");
INSERT INTO ifb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ya nunti'id hi Moses ta umuy mi'hapit ay Apo Dios. Ya nun'alih Apo Dios ay hiya an wah nan duntug, ya inalinay, “Hiyah te alyom hinan himpampun an holag Israel an nan tatagun holag Jacob: ");
INSERT INTO ifb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Da'yu ya tinnitinnigyu nan ina'inat'uh nan i'Egypt, ya hay inat'un nanalimun ay da'yun umat hinan aton nan agila an manalimun hinan pangitayapanah nan buyana, ya umat hinay inat'un da'yu ta engganah nidatong ayuh tu. ");
INSERT INTO ifb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","At gulat ta ihamadyun unudon nan Uldin'u ya nan intulag'u at da'yuy pot'o' hi ilahhin'uh nabalul an tatagu' ti Ha\"in ya bagi' tuwalin amin tun luta. ");
INSERT INTO ifb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ya da'yuy pento\"uh tagu' an me'gonan an himpamabluy, ya umat ayuh nan papadi ta Ha\"in itamuanyu. Hiyatuy hapitom hinan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","At nundadyuh Moses, ya inayagana nan a'ap'apun mumpapto' hinan tatagu ta ma'amungda, ya inulgudnan amin din immandal Apo Dios hi alyonan dida. ");
INSERT INTO ifb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ya an amin nan tatagu ya nundedehhandan nambal an alyonday, “Atonmin amin nan immandal Apo Dios!” At nunti'id goh hi Moses ta immuyna imbaag nan nambal nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ya inalin Apo Dios ay Moses di, “Umalia' ay he\"a, mu midduma' hinan ma'ugtul an bunut ta way aton nan tatagun mangngol hi pi'hapita' ay he\"a, ya ta kulugon da'ah enggana.” At hi Moses ya imbagana goh ay Apo Dios nan nambal nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ya inalin goh Apo Dios ay Moses di, “Umuy'ah nan tatagu ta ibagam ay didaan idadaanday odolda ta itutuyudan amin di baholda, ya idawatday odolda, ya alyom goh an mahapul an iloba'day lubungda ");
INSERT INTO ifb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ta midadaandah ohhandi, ti henen algaw di umalia' hinan Duntug an Sinai ta an amin di tatagu ya tigona'. ");
INSERT INTO ifb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","At mahapul an ulihonyuy igad hi nunlene'woh eten duntug, ya padanam nan tatagu ta mi'id ah bumahhel hinan igad an munti'id an umuy hinan duntug, ya adida goh ahan meheggon hinan igad ti nan umuy meheggon eten duntug ya mahapul an patayonyu. ");
INSERT INTO ifb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ya adiyu goh dapoon hinan pamatayanyu ti unyu puntapa unu unyu panaon, mu adi ammuna nan taguh mapatoy ti ta\"on nan animal hi unda bumahhel hinan igad. Mu awni ta donglonyun gumangoh nan tangguyub an umat hi talampet ya un mabalin an umuy nan tataguh nan puun di duntug.” ");
INSERT INTO ifb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","At nundadyuh Moses, ya inalinah nan tatagu ta itutuyuda nan baholda ta malenehda, ya nun'iloba'day lubungda. ");
INSERT INTO ifb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ya inalin goh Moses ay diday, “Mahapul an midadaan ayu enen miyatlun algaw, at adiyu elo' nan ahawayu.” ");
INSERT INTO ifb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ya heden helhelong eden miyatluh algaw ya mun'idul an gun mun'ilat, ya waday ma'ugtul hi bunut an niho'nap hinan duntug, ya waday ma'aggangoh hi talampet. At nan tatagun wah nan immapalanda ya wimmogwogdah ta'otda. ");
INSERT INTO ifb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","At initnud Moses nan tatagu an nalpudah nan immapalanda ta damuwondah Apo Dios, mu inta'dogdah nan aluhahad di duntug. ");
INSERT INTO ifb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ya heden Duntug an Sinai ya naho'napan hi ahu' ti hidiy nun'ohpan Apo Dios an ay apuy. At nunheglay ahu' an umu'utyu' an tumuluh nan duntug. ");
INSERT INTO ifb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ya nan ma'aggangoh an talampet ya gunna iyal'allay gangohna. Ya himmapit hi Moses, ya immidul ta hiyay tembal Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","At nun'ohop hi Apo Dios hinan tulid di duntug, ya inalina ta munti'id hi Moses hi wadana. At nunti'id hi Moses ta umuy. ");
INSERT INTO ifb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ya inalin Apo Dios ay hiyay, “Mundadyu'a ta eka padanan nan tatagu ta adida ahan ilulud an munti'id an umalin mannig ay Ha\"in an hi Apo Dios ti ini ya do'ol di mun'atoy ay dida! ");
INSERT INTO ifb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ya nan papadi an umalin meheggon ay Ha\"in ya ma'ahhapul an hamadonday aatdah un maleneh, ti adida ay ya nunheglay pummoltanan dida!” ");
INSERT INTO ifb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ya inalin Moses ay Apo Dios di, “Adi umalih tu nan tatagu ti ina'allim tuwalih din hopapnay, Ulihonyu nan nunlene'woh ta hiyay igadna ti henen duntug ya me'gonan!” ");
INSERT INTO ifb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ya inalin Apo Dios di, “Ginalom, ya nundadyu'a ta eka ayagan hi Aaron, ya numbangngad ayuh tu. Mu nan tatagu ya nan papadi ya alyom ta adida ahan bumahhel hinan igad an umalin mannig ay Ha\"in, ti atonda ay ya mapatoyda!” ");
INSERT INTO ifb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","At nundadyu mah hi Moses hinan awadan nan tatagu, ya imbaganah den inalin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hiya hatuy hinapit Apo Dios an inalinay, ");
INSERT INTO ifb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ha\"in hi Apo Dios an Dios an dayawonyu an nangekak ay da'yuh ad Egypt hidin abaalyu an ay ihunay un ayu himbut. ");
INSERT INTO ifb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ya mi'id ah udum hi dayawonyu an dios an anggay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ya adi ayu mun'ammah bululyu an meyengngoh di tigawdah nan wad abuniyan, unu nan wah tun luta, unu nan wah nan danum an wad dolom. ");
INSERT INTO ifb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ya mahapul an adiyu dayawon ya itamuan nan malgom an bulul ti Ha\"in an hi Apo Dios ya nidugah an mun'annela' hi un waday udum hi dayawonyuh miyengngoh ay Ha\"in, ya moltao' nan adi mangunud ay Ha\"in. Ya pi'molta' goh nan holag nan mamohol ay Ha\"in ta engganah nan miyapat hi a'apuda. ");
INSERT INTO ifb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ya ipattig'uy homo\"uh nan do'ol an tatagun mamhod ay Ha\"in ya nan mangunud hi Uldin'u ta engganah nan miyahinlibuh a'apuda. ");
INSERT INTO ifb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ya adi malgom di panapitanyuh ngadan'u an hi Apo Dios ti moltao' nan mangelgom an manapit hi ngadan'u. ");
INSERT INTO ifb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ya adiyu aliwan an ngilinon an egtadan nan miyapituh algaw ta pun'eblayanyu. ");
INSERT INTO ifb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ya onom di algaw hi panamuanyuh nan tamuyu, ");
INSERT INTO ifb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","mu nan miyapitun algaw ya hiyah ne pun'eblayanyu ta pundayawanyun Ha\"in an hi Apo Dios. At mahapul an mi'id ah muntamun da'yu an ta\"on nan imbabaluyyu, ya nan baalyun bumo'la, ya nan a'animalyu, ya nan mangiliyu. ");
INSERT INTO ifb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ti Ha\"in ya onom di algaw hi nunlumuwa' hitun luta, ya ad daya, ya nan baybay, ya an amin nan wah tun luta, mu nan miyapitun algaw ya nun'eblaya'. At pento\"uh nen algaw ta mangilin an bagi'. ");
INSERT INTO ifb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ya e'gonanyuh amayu ya hi inayu ta ud'udma' di pi'taguanyuh tun lutan indat'un da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Adi ayu pumatoy. ");
INSERT INTO ifb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Adi ayu umilugtap. ");
INSERT INTO ifb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Adi ayu mangakaw. ");
INSERT INTO ifb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Adiyu ipabahol nan agguy immannung hinan ibbayuh nan pun'ihtiguanyu. ");
INSERT INTO ifb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Adiyu amnawan nan gina'un wah nan abung nan heneggonyu, ya adiyu goh amnawan di a'ahawada unu baalda, ya adi ayu goh uma'amoh hinan baka, ya dongki, ya nan numbino'ob'on an udumnan gina'uda.” ");
INSERT INTO ifb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ya unat goh dengngol nan tatagu an mun'idul, ya mun'ilat, ya magangoh nan talampet, ya tinnigda goh an umu'utyu' nan ahu' hinan duntug at wimmogwogdah ta'otda, ya bimmataandan timma'dog. ");
INSERT INTO ifb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ya inalidan Moses di, “He\"a ay di humapit, ya donglonmi! Mu adim ni' pahapiton hi Apo Dios ay da'mi ti ini ya mun'atoy ami!” ");
INSERT INTO ifb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ya tembal Moses an inalinay, “Adi ayu tuma'ot ti manu ay umalih Apo Dios ya un da'yu tapngan ta Hiyay ita'otyu ta adi ayu mumbahol.” ");
INSERT INTO ifb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ya timmata'dogda nan tatagu ta hi Moses di immuy neheggon hinan way munhehellong ya ma'ugtul an bunut hinan wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ya inalin Apo Dios ay Moses di, “Alyom hinan holag Israel di, Tinnigyuy inat'un hi Apo Dios an nalpud abuniyan an himmapit ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ya adi ayu mun'ammah bulul an silver unu balitu' hi pangdumyuh nan pundayawanyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ya nan lutay iyammayuh pun'onnganyun Ha\"in ta hiyay pange'nonganyuh nan kalniluyu, ya gandengyu, ya bakayu ta Onong an Moghob ya Onong di Pi'lenggopanyu. Ya an amin di lugal hi pohdo' hi pundayawanyun Ha\"in ya umalia' ta wagaha' da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mu gulat ta nan batuy iyammayuh pun'onnganyun Ha\"in ya adiyu iyamma nan nahilhilan an batu ti nan nanelhelyu ya hiyay namuhih nan batu. ");
INSERT INTO ifb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ya adiyu ata'nangon di iyammayuh pun'onngan ta adi ayu huma'yab an umuy mun'onong ti tangadonda, at tigonday nitaguanyu.” ");
INSERT INTO ifb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ya inalin goh Apo Dios ay Moses di, “Ipa'innilam goh hatun Uldin hinan holag Israel: ");
INSERT INTO ifb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Gulat ta waday mambut hinan Hudyu, ya henen himbut ya mahapul an muntamuh onom di tawon ay hiya, mu nan miyapitun tawon ya mabalin an makak an mi'id ah bayadana. ");
INSERT INTO ifb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ya gulat ta agguy nangahawah din nahbutana ya hay akakana ya mi'id goh ahawana. Mu gulat ta nangahawah din nahbutana ya itnudnan ekak nan ahawana. ");
INSERT INTO ifb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mu gulat ta ipalhin han nambut ay hiya ta nahlag ya lala'i unu babai, ya nan babain ahawana ya nan imbabaluyda ya mumbalinda goh hi himbut nan nambut ay hiya, at nan lala'in nahbut di makak ya anggay. ");
INSERT INTO ifb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mu gulat ta henen himbut ta alyonay, Ongol di namhod'uh nan nambut ay ha\"in, ya nan ahawa', ya nan imbabaluy'u, at adi' pohdon an makak! at mabalin. ");
INSERT INTO ifb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","At iyuy nan nambut ay hiyah nan munhumalya, ya iyuyna goh hiyah pantaw unu nan delloh di tu'ud nan pantaw di lugal an pundayawan, ya usalonay lu'ulu' ta tol'onay ohah nan ingana. Ya dumalat henen ma'at ya mahapul an itamuana nan nambut ay hiya ta engganah un matoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ya gulat ta han babai ya ihbut amana ta mumbalin hi baal ya adi mabalin hi un nonong ya nakak an umat hinan lala'in himbut. ");
INSERT INTO ifb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Mu gulat ta mi'id pamhod nan lala'in nambut ay hiya an mangalih ahawaona ya iyabulutnan bangngadon amana. Ti adi mabalin an ihbutnah nan mangili, ti atona ay ya ibahhawna din ni'hapitanan den babai. ");
INSERT INTO ifb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Mu gulat ta han lala'i ta hubutonay babai ta ipa'ahawanah nan imbaluyna ya mahapul an ibilangna goh heden babaih imbaluyna. ");
INSERT INTO ifb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ya gulat ta han lala'i ta mangahawa goh hi ohah miyadwa ya mahapul an adina idinong an mangidat hi onon ya gina'un din nahhun an ahawana ya nan mahapulna ti ahawana. ");
INSERT INTO ifb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ya gulat ta adina unudon an idat nan mahapul nen babai ya mabalin hiyan makak an mi'id ah midat hi pihhuh bayadna.” ");
INSERT INTO ifb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ya inalin goh Apo Dios ay Moses di, “Nan mamang'ul hi ibbanan tagu ta matoy ya mahapul an mapatoy goh hiya. ");
INSERT INTO ifb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mu agguyna ay ginulat ya pimmatoy hi tagu ti hi Apo Dios di nangabulut ta ma'at ya mabalin an lumayaw hiya ta umuy hinan lugal an pento' Apo Dios hi ipo\"oyana. ");
INSERT INTO ifb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mu gulat ta han tagu ya pinatoynay ibbanah tagu ti dumalat nan planu ya ta\"on un umuy mipo\"oy hinan way pun'onnganyun Ha\"in ya umuyyu dapopon ta patayonyu. ");
INSERT INTO ifb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ya nan manudpa' ay amana ya hi inana ya mahapul an mapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ya wada ay di mangilayaw hi tagu ta umuyna ihbut unu pumbalinonah baalna ya mahapul an ipapatoyyu. ");
INSERT INTO ifb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ya nan mangidut ay amana ya hi inana ya mahapul an ipapatoyyu. ");
INSERT INTO ifb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ya gulat ta waday munhongngel ta nan oha ya tempanah den pi'hongngelna unu unna hinudpa', mu agguy natoy an un malili'uh hinan olo'ana, ");
INSERT INTO ifb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mu gulat ta henen nahugatan ya bumangon, ya munhuhul'ud an munle'le'od hinan gettaw, ya nan tagun nanudpa' ay hiya ya adi mamolta, mu bayadanay algaw hi adi puntamuan den hinudpa'na, ya halimunana goh ta nangamung un pumhod. ");
INSERT INTO ifb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ya gulat ta han tagu ya haplatonay tagalanan lala'i unu babai ta matoy ya mahapul an mamolta. ");
INSERT INTO ifb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mu gulat ta heden tagala ya tumaguh oha unu duway algaw ya adi mamoltah den apuna ti hiyay ad himbut. ");
INSERT INTO ifb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ya gulat ta waday duwah linala'in mumpattoy, ya nitagam an nahudpa' han babai an nunhabi, ya hiyay dimmalat hi nuntungawana mu maphod damdama nan ung'ungnga, ya henen nanudpa' ay hiya ya mamolta, mu hay pohdon nan iyahawan den babai ya bayadanah un malpah an iyabulut nan huwis. ");
INSERT INTO ifb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mu gulat ta natoy heden babai ya hay moltan nan nanudpa' ya mapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Nan pumilok ya miballoh ta mapilok, ya nan pumengaw ya mapengawan, ya nan pumungud hi ngamay ya mapungudan, ya nan pumungud hi hu'i ya mapungudan goh, ");
INSERT INTO ifb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ya nan gumhob ya mahapul gohbon, ya nan humugat ya hugaton goh, ya nan duminul ya dinulon goh. ");
INSERT INTO ifb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ya gulat ta han tagu ta hudpa'onay himbutnah lala'i unu babai ta napilok di matana ya iyabulutnay akakan nan himbut ta hukat nan napilokana. ");
INSERT INTO ifb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ya gulat ta hudpa'ona nan himbut an lala'i unu babai ta mapengawan ya iyabulutnay akakana ta hiyay pallog nan na'aanan di babana. ");
INSERT INTO ifb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ya gulat ta way ha'gion nan buta'al an bakah tagu an babai unu lala'i ta matoy ya mahapul an madotnay hi batu nan baka ta nangamung un matoy, mu adi mihday lamohna. Mu nan ad baka ya adi mamolta. ");
INSERT INTO ifb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mu gulat ta henen baka ya waday hina'ginah tagu, ya binaganda nan ad bakah nan na'at, mu agguyna inluhudan, ya la'tot ya waday oha goh an taguh hina'gina ta natoy ya mahapul an pundotnay hi batuh nen baka ta nangamung un matoy, ya pi'patoyda goh nan ad baka. ");
INSERT INTO ifb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mu gulat ta miyabulut an un bayadan nan ad bakah pihhuh den natoy ya mahapul an ma'unud nan na'alih midat hi bayadna, at bayadana ay an amin at adida hiya pi'patoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Gulat ta hay ung'ungngan lala'i unu babai patayon nan baka ya numpaddung di uldin hi ma'at. ");
INSERT INTO ifb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ya gulat ta nan lala'i unu babai an himbut di patayon nan baka at bayadan nan ad baka nan ad himbut hinan natoy hi tulumpuluh palatan pihhu, ya nundotnayda nan baka ta nangamung un matoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ya gulat ta han tagu ya anonay alub nan nalu\"ungan unu un munlut'u', ya gulat goh ta na'aliwanan aluban ta waday nakuhbung hi baka unu dongki ");
INSERT INTO ifb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ya mahapul an bayadana nan nakuhbung, ya idatnay bayad hinan ad baka, ya bagina nan natoy. ");
INSERT INTO ifb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ya gulat ta nan bakan buta'al ya pinatoynay buta'al an bakan di ohan tagu ya danen duwan tagu ya unda ila'uh nen matagun baka, ya ginodwaday la'unah pihhu, ya ginodwada goh nan natoy an baka. ");
INSERT INTO ifb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mu gulat ta nundongol an un mahanhana'gih nen baka ya adi ipapto' nan ad baka ya mahapul an huwolonay ohah bakah matagu, ya bagina nan natoy an baka.” ");
INSERT INTO ifb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ya inalin goh Apo Dios ay Moses di, “Ya gulat ta nan tagu ya inakawnay ohah baka unu kalnilu ta pinaltina unu unna inla'u ya mahapul an hukatanah lemay baka nan ohah baka ya opat hi kalniluy hukat nan ohan kalnilu. ");
INSERT INTO ifb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ya gulat ta nan mangakaw ya hinumgop hinan baluy, ya na'ah'upan an unda pinang'ulan ta pinatoyda, ya han namatoy ay hiya ya mid baholna, at adida hiya patayon. ");
INSERT INTO ifb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mu gulat ta nan mapatal di nangakawana ta pinatoyna ya mabaholan nan pimmatoy, at mipapatoy goh ti maphod hi unna agguy pinatoy ta unna moltaon. Ya gulat ta mid pamayad nan mangakaw ya mihbut hiya ta nan hubutnay pumbayadnah nan moltana. ");
INSERT INTO ifb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ya gulat ta nan tagu ya inakawna nan baka, unu dongki, unu kalnilu ta ma'ah'upan ay hinan nunhituwana, ya agguy natoy henen baka, unu dongki, unu kalnilu ya mahapul an ma'okpan di huwalna. ");
INSERT INTO ifb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ya gulat ta han tagu ta ibo'tanay animalnah nan payawna ta panganona, mu wa ay ta bumahheldah nan payaw unu galden di udumnah tatagu ta pun'a'anday nihabal ya mahapul an hukatanah nan ma\"aphod an inhabalna an na'alah payawna unu galdena. ");
INSERT INTO ifb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ya gulat ta nan tagu ya numpuul hi umana, ya nun'ehelat nan apuy nan uman di udumna ta nun'oghob di nihabal at mahapul an bayadanan amin nan noghob an nihabal. ");
INSERT INTO ifb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ya gulat ta way taguh nangipitalepon hi pihhuna unu nan mapla'an an gina'unah nan heneggona, ya gulat goh ta ma'akaw enen abung an nitalepnana, ya gulat ta na'ah'upan henen nangakaw ya mahapul an okpana nan ibangngadnan inakawna. ");
INSERT INTO ifb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mu gulat ta adi ma'ah'upan nan nangakaw ya heden ad abung an nangitalepon ya mahapul an umuy hinan punhumalyaan ta munhapatan Apo Dios ta ipa'innilana an bo'on hiyay nangngal hinan nipitalepon ay hiya, at okod nan huwis an mumpanuh hi ma'at. ");
INSERT INTO ifb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","An amin nan midiklamu an hay aat di umam'am hi baka, unu dongki, unu kalnilu, unu lubung, ya nan udum an gina'u ta alyonay un hiyay ad bagi ya mahapul an umuydan duwah nan huwis ta nan alyon nan huwis hi numbahol di mumbayad, mu okpanay idatnah nan ad bagi. ");
INSERT INTO ifb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ya gulat ta nan tagu ya iyuyna ipahalimun hinan heneggona nan animalnan dongki, unu baka, unu kalnilu, unu nan udum an animalna, mu matoy ay, unu mahugatan, unu ma'akaw, ya mi'id ah mun'ihtiguh nan na'at, ");
INSERT INTO ifb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ya henen na'at ya mahapul an umuydan duwah nan lugal an hinagang di awadan Apo Dios ta ihapatan nan nanalimun hinan animal an mi'id baholna, at nan ad bagi ya abulutonan un na'utaw, at adina pabayad. ");
INSERT INTO ifb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mu gulat ta immannung an nan animal ya na'akaw at bayadan nen nanalimun hinan animal. ");
INSERT INTO ifb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Mu gulat ta un pinatoy nan animal hi inalahan ya mahapul an iyuyna nan lamoh nan natoy ta way panginnilaandan immannung, at adi mumbayad hi moltana. ");
INSERT INTO ifb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Gulat ta han tagu ta bonhona nan animal di heneggona ta mahugatan unu matoy ya mi'id nan ad bagi an agguyna tinnig di na'at, ya mahapul an bayadanah nen animal. ");
INSERT INTO ifb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mu gulat ta wagwada nan ad animal ta titinnignay na'at hi natayan unu nahugatan nan nabnoh an animal ya adi mahapul an mumbayad nan binumnoh. Mu na'abangan ay nan nabnoh an animal ya mun'olog henen abangnah bayadana.” ");
INSERT INTO ifb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ya inalin goh Apo Dios ay Moses di, “Ya gulat ta nan lala'i ta ihaphapitana han babai an agguy niyali ta elo'na hiya ya mahapul an ukatonan amin di madawat, ya inahawana hiya. ");
INSERT INTO ifb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mu gulat ta adi ahan iyabulut nan ommod nan babai an ipiyahawa nan imbaluyna ya mahapul an mumbayad damdama nan lala'i, at idatnan amin di uyap nan madawatna. ");
INSERT INTO ifb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ya nan way te'omna, ya buyun, unu duhongna ya mahapul an mipapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ya wa ay goh di tagun mangundul hinan animal ya mahapul an mipapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ya nan mun'onong hinan udumnan dios an bo'on hi Apo Dios di pun'onngana ya mahapul an mipapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ya adiyu paligaton nan bunag ti nomnomonyu adya an un ayu goh bunag hidin wadanyud Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ya umat goh hinan umu'utun ya nan nguhu an adiyu paligaton. ");
INSERT INTO ifb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ya gulat ta paligatonyu dida ta donglo' didan mumpabadang ay Ha\"in ");
INSERT INTO ifb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ya bumungota' ahan, at nan hanggap di pamatoy'un da'yu, at mun'abaluy a'ahawayu, ya nun'anguhu nan imbabaluyyu. ");
INSERT INTO ifb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ya gulat ta pa'utanganyuh pihhu nan nun'awotwot an nangabulut ay Ha\"in ya adiyu ipatakap ta adiyu iyunnud hinan aton nan udumnan mumpatakap. ");
INSERT INTO ifb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ya gulat ta alanyu nan lubung di ibbayu ta pangedonanyu ya mahapul an ibangngadyuh mahhun ya un malimuh nan potang ");
INSERT INTO ifb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ti un anggaynah ne ay hi lubungna at hay ilubungna mah hi un molo'? Mu gulat ta adiyu ibangngad ta way donglo' hi mumpabadang ay Ha\"in ya badanga' hiya ti ma'ahhimo'a'. ");
INSERT INTO ifb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ya adiyu hapiton di nappuhih aat Apo Dios ta adiyu bainon Hiya. Ya adiyu idutan nan mumpapto' ay da'yun tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ya mahapul an idatyun Ha\"in nan mun'ahhun an bungan di intamuyu ya nan bungan di greyp ya oliboh unyu pugahon. Ya idawatyu nan pangpangullun imbabaluyyun lala'i ta Ha\"in ad bagi. ");
INSERT INTO ifb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ya umat hinay atonyu goh hinan bakayu ya nan kalniluyu. Ya iddumyun inanah pituy algaw, ya nan miyawaluy algaw ya idawatyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ya da'yuy nahamad hi nilahhin an tatagu', at mahapul an adiyu ihday animal an patayon nan animal hi inalahan. Mu idatyuh nan ahu ta diday mangihda.” ");
INSERT INTO ifb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ya inalin goh Apo Dios ay Moses di, “Adiyu umuy ulgu'ulgudon nan agguy immannung an ulgud, ya adiyu goh badangan nan tagun numbahol hinan pun'ihtiguanyuh pangulgudanah nan agguy immannung. ");
INSERT INTO ifb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ya adiyu iyunnud hinan aton di tatagun nibahhaw an ta\"on hi unda do'ol, ya adi ayu goh mun'ihtiguh nan agguy immannung an diklamu ta adi mahunni nan mihumalya. ");
INSERT INTO ifb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ya adiyu ipangngel di pangatyuh nan tagun nawotwot hinan diklamuna. ");
INSERT INTO ifb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ya gulat ta way tigonyuh limmayaw hi baka unu dongkin bagin nan pi'bohholyu ya innalyu ta iyuyyun hiya. ");
INSERT INTO ifb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ya wa ay ta tigonyu nan dongkin nan mamohol ay da'yu ta nidupig ti dumalat nan madamot an kalgana ya mahapul an adiyu taynan ta badanganyu ta tuma'dog. ");
INSERT INTO ifb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ya adiyu ipangngel nan panumalyayuh nan tagun nawotwot hinan diklamuna. ");
INSERT INTO ifb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ya adiyu ipabahol nan agguy immannung, ya adiyu ipapatoy nan tagun mi'id baholna ti moltao' nan tagun mangat hi umat hinah nappuhi. ");
INSERT INTO ifb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ya adiyu alan nan mili\"ud an lagbu ti hiyay paddungnay mamulaw hinan tatagun nala'eng ta omod unna hunnion nan nepto' an hapiton nan maphod di nomnomnan tagu. ");
INSERT INTO ifb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ya adiyu paligaton nan bunag ti da'yu ya ene'damyuy aat di bunag hi wadanyud Egypt.” ");
INSERT INTO ifb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ya inalin goh Apo Dios ay Moses di, “Ya onom di tawon di pangihabalanyuh nan lutayu ya pangamunganyun amin hinan ma'alah nan inhabalyu. ");
INSERT INTO ifb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mu nan miyapitun tawon ya adiyu tamman ta mabattanan. Ya wa ay di humangaw an ma'an di bungana ya adiyu ahan alan ta nan nun'awotwot di mangngal ta way ononda, ya wa ay goh di ma'angang ya ta way onon nan a'animal hi inalahan. Ya umat hina goh di atonyuh nan lutan puntammanyuh nan greyp ya nan olibo. ");
INSERT INTO ifb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ya onom hi algaw di puntamuanyu, mu nan miyapitun algaw ya mun'eblay ayu. Ya ta\"on nan himbutyu, ya nan bunag an puntamuonyu, ya nan a'animalyu ya mun'eblayda goh ta pumpumhod di aatda. ");
INSERT INTO ifb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ya ihamadyun donglon an amin nan alyo' ay da'yu. Adi ayu ahan munluwaluh nan udumnan dios hitun luta, ya adiyu ahan bugwaon di ngadanda.” ");
INSERT INTO ifb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ya inalin goh Apo Dios di, “Ya mumpitluh hintawon an munggotad ayu ta way pange'gonanyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ya nan bulan di Aviv an hiyay bulan hi nakakanyud Egypt, ya egtadanyu nan Behtan di Agguy Nabino'bo'an an Tinapay ta pituy algaw di pangananyuh nan agguy nabino'bo'an an tinapay ti hiyah ne din immandal'un da'yuh atonyu. Ya nan umalianyun mundayaw ya mahapul an waday e'nongyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ya ibehtaanyu goh nan Behtan di Udol hinan pangudlanyuh nan bungan di intanomyuh nan payawyu, ya nan Behtan di Pugah hi angunuh di tawon hinan pamugahanyuh nan bungan di intanomyun greyp ya nan udum an bunga. ");
INSERT INTO ifb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ya mumpitluh hintawon di gun umalian an amin nan linala'in mundayaw ay Ha\"in an na'abbagtun Dios. ");
INSERT INTO ifb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ya adiyu iddum nan nabino'bo'an an tinapay hinan pange'nonganyuh animal ay Ha\"in. Ya nan taban di animal an e'nongyu ya mi'id ah ma'angang ta engganah helhelong. ");
INSERT INTO ifb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ya nan ma\"aphod an bot'onyuh nan mahhun an bungan di intanomyuh nan lutayuy iyuyyuh nan Abung Apo Dios an dayawonyu. Ya wa ay ta ihaangyu nan uyaw an gandeng ya adiyu pananum nan gatas an malpun inana.” ");
INSERT INTO ifb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ya inalin goh Apo Dios ay Moses di, “Tigonyu ta innilaonyun honogo' nan Anghel'u ta hiyay mangipangulu ya manalimun ay da'yuh nan pumbaatanyu ta engganah un da'yu idatong hinan babluy an indadaan'uh ihinanyu. ");
INSERT INTO ifb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","At mahapul an ihamadyun donglon ya unudonyun amin nan alyonan da'yu. Ya adiyu ngohoyon ti adina aliwan nan adiyu pangunudan ay Hiya ti wagwadaa' ay Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ya gulat ta ihamadyun donglon di alyona ya inunudyu goh an amin nan immandal'u at Ha\"in mananggah nan mi'buhul ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ti nan Anghel'u ya ipang'u da'yu ta engganay un da'yu idatong hinan lutan nan himpampun an holag Amor, ya holag Heth, ya holag Periz, ya holag Hiv, ya nan iJebus, ya iCanaan, ya ubaho' didan amin. ");
INSERT INTO ifb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mu adiyu ahan dayawon unu itamuan nan diosda, ya adiyu enghon nan atondan mundayaw. Ya pumpa\"iyun amin an pumpuhit nan bululda ");
INSERT INTO ifb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ta Ha\"in an hi Apo Dios di dayawonyu, at wagaha' da'yuh ma'an ya ma'inum. Ya ipa'adaog'un amin nan dogohyu, ");
INSERT INTO ifb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ya mi'id di mamolwang ya mabahig hinan lutan ihinanyu, ya udma' di pi'taguanyu ta du'du\"oy. ");
INSERT INTO ifb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ya pata'to' hi mahhun an amin nan pi'buhulyu, at an amin di ah'upanyu ya manongngo'da, ya an amin nan mi'buhul ay da'yu ya pumbangngado' ta mumpangalayawda. ");
INSERT INTO ifb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ya ipa'ali' nan Iyu'an ta diday mumpamakak hinan himpampun an nan holag Hiv, ya nan holag Heth, ya nan iCanaan an buhulyu. ");
INSERT INTO ifb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mu adi' punnaudon didan pakakon eden hintawon ta adi mabukawan nan luta ti ini ya dumo'ol nan a'animal hi inalahan ya un da'yu! ");
INSERT INTO ifb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mu un'u ahinuton an mamakak ay dida ta engganah un dumo'ol di holagyu ta da'yuy munhituh mamoltan enen luta. ");
INSERT INTO ifb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ya uliho' nan igad hinan lutayun mipalpuh nan Mumbolah an Baybay ta nangamung hinan Baybay an Mediterranean an wah nan pingit di babluy nan iPhilistia, ya mete\"ah nan mapulun ta nangamung hinan Wangwang an Euphrates. Ya idat'uy abalinanyu ta ologyun manu'wit hinan nunhitun nen luta ta makakda. ");
INSERT INTO ifb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ya adi ayu ahan mi'tulag ay dida unu nan diosda. ");
INSERT INTO ifb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ya adiyu abuluton ta mi'hitudah nan lutayu ta bo'on diday dumalat hi pumbaholanyun Ha\"in ti gulat ta middum ayun mi'dayaw hinan diosda at hiyay dumalat hi pumuhianyu.” ");
INSERT INTO ifb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ya inalin Apo Dios ay Moses di, “Awitom da Aaron ay Nadab ya hi Abihu, ya nan napitun a'ap'apun nan holag Israel ta umali ayun mundayaw ay Ha\"in, mu mahapul an mibataan ayun mundayaw. ");
INSERT INTO ifb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mu he\"a, Moses, ya anggay di meheggon ay Ha\"in, mu nan udum ya adida ahan umalin meheggon. Ya tigom ta nan tatagu ya adida munti'id an mitnud ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ya immuy hi Moses hinan tatagu ta imbaganan amin nan Uldin hi unudonda an inalin Apo Dios ay hiya. Ya inabulutdan amin an inaliday, “Oo, atonmin amin nan inalin Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","At intudo' Moses an amin nan inalin Apo Dios. Ya heden nabiggat hi helhelong ya inyamman Moses di pun'onngan hidih nan puun di duntug, ya nunle'wohonan inammaan hi himpulu ta duwan batu an mangipattig hinan himpulu ta duwan tribon holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ya hennagna nan ungungan linala'in holag Israel ta umuyda e'nong nan Onong an Moghob ay Apo Dios, ya ene'nongda goh di uyaw an buta'al an baka ta Onong di Pi'lenggopan nan tatagun Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","At ginodwan Moses nan dala an ne'nong ta inittunay godwanah nan ohan malukung an duyu, ya inyuyna inwalhi nan godwanah nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ya innalna din Liblun Nitud'an di Ni'tulagan nan Hudyun Apo Dios, ya enlotnan nangibahah din tatagu. Ya unat goh nalpah an imbahana ya inalin din tataguy, “Oo, atonmin amin nan inalin Apo Dios, ya unudonmi Hiya.” ");
INSERT INTO ifb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","At innal goh Moses din godwan di dala, ya nun'iwalhinah nan tatagu, ya inalinay, “Hiyah te dala an mangipa'innilah nan pi'tulagan Apo Dios ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ya nunti'id da Moses, ya hi Aaron, ya hi Nadab, ya hi Abihu, ya nan napitun a'ap'apun di holag Israel hinan duntug. ");
INSERT INTO ifb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","At hidiy nannigandan Apo Dios an dayawon nan holag Israel an hay timma'dogana ya nan ay batun sapphire an umat ad dayay tigawna an mumpugagaw ya ma'apattal. ");
INSERT INTO ifb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ya ta\"on un tinnig nan a'ap'apun nan holag Israel hi Apo Dios ya agguyna dida pinatoy, at ne\"anda ya ni'yinumdan Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ya inalin Apo Dios ay Moses di, “Munti'id'ah tun duntug an awada', ya hodom ta idat'u tun duwan ikab an batun nangitud'a' an amin hinan Uldin ya nan udumnan Uldin hi ma'at ta itudum hinan tatagu.” ");
INSERT INTO ifb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","At nundadaan mah da Moses ay Joshua an bumadang ay hiya ta umuydah nan duntug an awadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ya inalin Moses hinan a'ap'apu di, “Hodon da'mih tu ta nangamung un ami mumbangngad. Ya wah tu da Aaron ay Hur an mannig ay da'yu. At wada ay di pumbobohholanyu ya diday pangiyayanyu ta ipanuhda.” ");
INSERT INTO ifb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ya unat goh nunti'id da Moses hinan Duntug an Sinai ya hino'napan di bunut nan duntug, ");
INSERT INTO ifb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ya nan benang Apo Dios di nanophop hinan Duntug an Sinai. Ya onom di algaw hi nahoho'napan nan duntug hi bunut, ya nan miyapitun algaw ya mun'alih Apo Dios an wah nan bunut ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ya hay nannig nan holag Israel hinan benang Apo Dios ya umat hi apuy an gumelageladaw hinan tulid di duntug. ");
INSERT INTO ifb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","At inayun Moses an nunti'id ta immuy hinan naho'napan hi bunut. At nihinah dih napat di algaw ya napat di nahdom. ");
INSERT INTO ifb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Alyom hinan holag Israel ta iyaliday e'nongdan Ha\"in, ya malgom hinan mipanomnom hi pohdondan idat di hiyay amungonyu. ");
INSERT INTO ifb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ya datey midat hi e'nong nan tatagu an hay balitu', ya silver, ya nan gambang, ");
INSERT INTO ifb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ya nan linen an munggudla, ya mumpugagaw, ya mumbolah, ya mumpaha' an napinun hinulid, ya nan dutdut di gandeng, ");
INSERT INTO ifb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ya nan up'up di buta'al an kalnilu an nelbog ta mumbolah, ya nan up'up di ongol an animal hinan baybay an ma'alih dugong, ya nan ayiw an akasya, ");
INSERT INTO ifb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ya nan lanan di olibon mittuh nan punhilaw, ya nan middum an holo' hinan lana an ma'usal hinan way midawat, ya nan maphod di hunghungnan incense, ");
INSERT INTO ifb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ya nan nanginan batu an ma'alih onyx, ya nan udumnan nanginan batu an miyammah al'altin di lubung nan padin an ephod ya nan hophop di palagpag an lubung di padi. ");
INSERT INTO ifb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ya ipiyammam hinan tatagu nan Tuldan Abung ta way ihina' hi idduma' ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ya alyo' an amin ay he\"ay aat di lukud nan iyammayu an Tuldan Abung ya nan lukud di alimatungna, at hiya ahan di unudonyuh un ayu munha\"ad.” ");
INSERT INTO ifb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ya inalin goh Apo Dios ay Moses di, “Ya ipiyammam ay dida nan kahon an hay miyamma ya nan ayiw an akasya. Ya hay inadu\"oyna ya napat ta han lemay pulgada. Ya hay inabellogna ya ba'inti ta pituy pulgada, ya hay inata'nangna ya ba'inti ta pituy pulgada. ");
INSERT INTO ifb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ya hay namahmah an balitu' di miyamyud hinan tu'yapna ya nan bunolna, ya hay namahmah goh an balitu' di miyammah nan nunlene'woh hi pingit den kahon ta ay balina. ");
INSERT INTO ifb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ya hay balitu' goh di miyammah nan opat an natalegonggong hi pangipahduan hinan attang an mepong an miyammah nan duguna ta mahindudwah nan numpinangngel. ");
INSERT INTO ifb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ya mangamma ayuh attang an akasya, ya inamyudanyuh balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ya impahduyu nan attang hinan natalegonggong an wah nan numpinangngel di kahon ta way pangedonan nan mangiyattang. ");
INSERT INTO ifb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ya henen attang ya mahapul an adi ma'ma'aan hinan nipapahduanan natalegonggong hinan kahon. ");
INSERT INTO ifb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ya ittum hinan kahon nan duwan ikab an nitud'an nan Uldin an idat'un he\"a. ");
INSERT INTO ifb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ya mun'amma ayuh alub di kahon hi namahmah an balitu' an napat ta han lemay pulgadah inadu\"oyna ya ba'inti ta pituh pulgaday inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ya iyammayu goh di duwah cherubim an hay namahmah an balitu' di mahibug hi miyamma ta mumbinnohwahdah nan alub. ");
INSERT INTO ifb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","At ihinayuy ohah cherubim hinan bongwah nan alub di kahon, ta nan oha ya ihinayuh nan bongwahna goh. ");
INSERT INTO ifb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ya nan duwan cherubim ya papayadonday paya'da ta hophopanda nan alub di kahon an nunhaggangandan mangu'uhdung hinan alub di kahon. ");
INSERT INTO ifb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ya ittum nan idat'un he\"an Uldin hinan kahon, ya inyalubyu nan kahon. ");
INSERT INTO ifb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ya hinan numbattanan di duwan cherubim hinan way alub di kahon di umbunan nan Ma'ahhimo', at hiyay awada' hi pi'hapita' ay he\"a ta ipa'innila' an amin nan Uldin'uh nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ya inalin goh Apo Dios di, “Ya iyammayu goh nan ayiw an akasya hi lamehaan. Ya hay lukudna ya tulumpulu ta onom di pulgaday inadu\"oyna, ya himpulu ta waluy pulgadah inabellogna, ya ba'inti ta pituy pulgadah inata'nangna, ");
INSERT INTO ifb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ya inamyudanyuh nan namahmah an balitu', ya hay iyammayuh balinah nan nunlene'woh ya nan namahmah an balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ya hay miyammah nan pingit di lamehaan ya balitu' an tuluy pulgadah inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ya balitu' goh di iyammayuh nan opat an natalegonggong ta mepong hinan opat an dugunah nan way tu'ud. ");
INSERT INTO ifb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ya meheggon hinan ampan di bali ta hiyay pangipahduan hinan attang. ");
INSERT INTO ifb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ya hay akasya di iyammayuh attang, ya inamyudanyuh balitu' ta hiyay pangattang hinan lamehaan. ");
INSERT INTO ifb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ya mangamma ayuh duyu, ya ha'lung, ya tibung, ya malukung, ya alub an hay miyamma ya nan namahmah an balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ya nan tinapay an mangipa'innilan wagwadaa' ay da'yu ya ipattu'yuh nan lamehaan hinan hinagang'u ta munnonong hidi.” ");
INSERT INTO ifb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ya inalin goh Apo Dios ay Moses di, “Ya mun'amma ayu goh hi ipattu'an di hilaw an hay namahmah an balitu' di hibugonyuh miyamma an waday ipabunana ya nan maha\"ad an odolna. Ya ma'al'altian hi paddungnay habhabung, ya waday umat hi malukung hinan tu'yapna an ittuwan di hilaw. Ya nan odolna ya na'ungta'ungtan. ");
INSERT INTO ifb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ya nan odolna ya waday onom hi hapangna an numpopotto'dan nun'ahintutluh numpinangngel. ");
INSERT INTO ifb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ya danen onom an hapang an mahintutluh mumpinangngel ya ma'al'altian hi umat hi bungan di almond, ya nan pumbattananda ya waday umat hi nabe'lag an habhabung. ");
INSERT INTO ifb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ya nan odol di ipattu'an di hilaw ya ma'al'altian hi opat an umat hi bungan di almond an waday habhabungnah nan numpumbattananda. ");
INSERT INTO ifb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ya mepong di habhabung hinan onom an hapang di odol an ipattu'an di hilaw. ");
INSERT INTO ifb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ya nan habhabung ya nan hapangna ya un ma'ohha an hay namahmah an balitu' di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ya miyammay pituh umat hi malukung hinan tu'yap di hinohhan hapang ya nan odolna ta pangittuwan hi punhilaw ta ipapatalnan amin nan hinagangna. ");
INSERT INTO ifb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ya miyamma goh di pangipit hi olhang ya nan ittuwan di dapul, ya nan namahmah an balitu' di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hay damot di miyammah nan ipattu'an di hilaw ya an amin nan alimatungna ya tulumpulu ta opat di kiluh nan namahmah an balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ya ihamadmu ta ma'unud an amin din aat nan impattig'un he\"ah wadan tu'uh nan duntug.” ");
INSERT INTO ifb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ya inalin goh Apo Dios ay Moses di, “Ya hay miyammah nan Tuldan Abung'u an Dios ya nan himpulun kultina an napinuy abolnan linen an lo'ob. Ya nan numbino'ob'on di kololda an munggudla, ya mumpugagaw, ya mumbolah di iboldan nan nala'eng an mumbolda ta iboldanay cherubim hinan kultina. ");
INSERT INTO ifb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ya nan kultina ya mumpapaddung di lukudda an himpulu ta opat di yaldah inadu\"oyda, ya duway yaldah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ya nan leman kultina ya pundada\"ugonyu ta ma'ohha, ya umat goh hinay atonyuh nan leman miyadwah mada\"ug. ");
INSERT INTO ifb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ya nan munggudlay miyammah punggo'dan hinan pingit nan hinohhan mada\"ug an lo'ob ta way pangigo'dan hinan punda\"uganda. ");
INSERT INTO ifb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ya miyammay nabongleh punggo'dan hinan mahhun an mada\"ug, ya miyamma goh di nabongleh punggo'dan hinan miyadwan da\"ug, ya munggogoppong di iyammaanda. ");
INSERT INTO ifb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ya miyammay nabonglen kawit an balitu' ta hiyay pana\"ug an mikawit hinan duwan mada\"ug an lo'ob ta ma'ohha an miyammah Tuldan Abung'u an Dios. ");
INSERT INTO ifb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ya hay miyamma goh hi atap di Tuldan Abung'u an Dios ya himpulu ta ohay lo'ob hi madada\"ug an nalpuh dutdut di gandeng. ");
INSERT INTO ifb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ya hay lukudda ya mumpapaddung an himpulu ta lemay yaldan di inadu\"oyda, ya duway yaldah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ya pundada\"ugonyu nan lema ta ma'ohha, at umat goh hinay atonyuh nan onom ta ma'ohha goh. Ya nan miyonom an lo'ob hinan miyadwan mada\"ug ya mikupin ta manophop hinan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ya miyamma goh di nabongleh punggo'dan hi pingit nan ohan mada\"ug, ya nabongle goh hinan miyadwan mada\"ug. ");
INSERT INTO ifb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ya miyamma goh di nabongleh kawit an gambang ta mepong an mikawit hinan punggo'dan hinan duwan nada\"ug ta ma'ohhah atap. ");
INSERT INTO ifb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ya nan mahawal hinan miyatap ya ma'uy'uy hinan agwid di Tuldan Abung ta hophopna. ");
INSERT INTO ifb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ya hinggogodway yaldah inadu\"oy di mahawal ta ma'uy'uy hinan numpinangngel ta mida'lig hinan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ya miyamma goh di duwah migottap hinan atap an nan oha ya malpuh up'up di kalnilu an niyupol ta mumbolah, ya nan oha ya nan ma\"aphod an lalat di ma'alih dugong an nan ma'alah baybay ta hiyay muntu'yap hi migottap hinan atap. ");
INSERT INTO ifb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ya hay maha\"ad hi tabla an miyammah nan Tuldan Abung ya nan ayiw an akasya. ");
INSERT INTO ifb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ya hay inadu\"oy di ohah tabla ya himpulu ta lemay umpi, ya ba'inti ta pituy pulgadah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ya ma'aitan nan puun di tabla ta ma'amman di duwah mipatlo' ta maphod an migtim. ");
INSERT INTO ifb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ya midadaan di ba'intih tabla ta way miyammah appit hi agwan hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ya miyamma goh di napat hi ipabunan nan tabla an hay silver di miyamma, ya mahindudway miyammah umbunan di ohah tabla. ");
INSERT INTO ifb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ya midadaan goh di ba'intih tabla ta way miyammah appit hi iggid hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ya napat di ipabunan nan tabla an hay silver di miyamma, ya muntu'un di duwan na'aitan ta mahindudway silver ta ipabunan nan hinohhan tabla. ");
INSERT INTO ifb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ya midadaan goh di onom an tablah miyammah nan appit hi alimuhan di algaw, ");
INSERT INTO ifb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ya idadaanyu goh di duwah tablah miyammah nan duguna. ");
INSERT INTO ifb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ya hay pangiyammanyun ne han duwan tablah nan dugun di Tuldan Abung ya punda\"itonyuh puuna ta nangamung hi uddu'na. At hiyah ne goh atonyuh nan ohan duguna. ");
INSERT INTO ifb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","At walun tablay idadaanyuh miyammah nan duguna, ya himpulu ta onom di ipabunandan hay silver di miyamma ta mahindudwah nan ohan tabla. ");
INSERT INTO ifb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ya idadaanyuy himpulu ta lemah mibalangon an ayiw an akasya an umat hituy aatda: lemay mibalangon hinan ohan haba' di Tuldan Abung, ");
INSERT INTO ifb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ya lema goh di mibalangon hinan pangngelna, ya umat goh hinan ohan haba'nah appit di alimuhan di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ya nan migagwan mibalangon an tabla ya da'puhonay numpiningit. ");
INSERT INTO ifb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ya ma'amyudan hi balitu' nan tabla, ya nan balitu' di miyammah ipahduan nan mibalangon. Ya amyudanyu goh hi balitu' nan mibalangon. ");
INSERT INTO ifb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Nan Tuldan Abung an iyammayu ya miyunnudan hidin aat din impattig'un he\"ah din wadantah nan duntug. ");
INSERT INTO ifb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","An hay miyammah kultina ya nan lo'ob an munggudla, ya mumpugagaw, ya mumbolah, ya nan ma\"aphod di abolna, ya ipaboldam di cherubim hinan na'alla'eng an mumbolda. ");
INSERT INTO ifb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ya miyammay opat an kawit an balitu', ya opat an tu'ud an akasya an ma'amyudan hi balitu' ta pangitayunan hi kultina. Ya nan ipabunan nan tu'ud ya silver. ");
INSERT INTO ifb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ya mitayun nan kultinah nan kawit hinan tu'ud. Ya henen kultina ya hiyay pumbattanan di Me'gonan an Kuwaltuh nan Nidugah an Me'gonan an Kuwaltu. Ya ihinam nan Kahon an Nittuwan di Uldin hinan delloh di kultinan nan Nidugah an Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ya eh'apmu nan alub di Kahon an Nittuwan di Uldin. ");
INSERT INTO ifb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ya nan lamehaan ya ihinam hinan pangngel di kultinan nan Me'gonan an Kuwaltuh appit hi iggid hi un hagangon di buhu'an di algaw, ya nan ipattu'an di hilaw ya ihinam hinan appit hi agwan hi un hagangon di buhu'an di algaw hi potto' di lamehaan. ");
INSERT INTO ifb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ya hay miyammah kultinan di pantaw nan Tuldan Abung ya nan mundongngol an lo'ob an nan munggudla, ya mumpugagaw, ya mumbolah, ya nan ma\"aphod di abolnan linen ya maboldaan. ");
INSERT INTO ifb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ya miyammay kawit ta pangitayunan hinan kultina, ya miyammay lemah tu'ud an akasya an ma'amyudan hi balitu', ya hay gambang di miyammah ipabunan nan tu'ud.” ");
INSERT INTO ifb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ya inalin goh Apo Dios di, “Ya mun'amma ayuh pun'onngan an nan ayiw an akasya di miyamma. Ya pitu ya han godway umpih inadu\"oyna, ya umat goh hinay inabellogna an pitu ya han godway umpi. Ya hay inata'nangna ya opat ta han godway umpi. ");
INSERT INTO ifb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ya mun'amma ayuh umat hi ha'gud ta mepongdah nan opat an duguna, ya hanan ha'gud ya mihahalamung hinan pun'onngan. Ya ma'amyudan nan pun'onngan hi gambang. ");
INSERT INTO ifb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ya gambang goh di miyammah nan alimatung di pun'onngan an nan duyun ittuwan di dapul, ya daludun di dapul, ya nan malukung, ya nan nunhappang an tuwi', ya nan bangan ittuwan di bala. ");
INSERT INTO ifb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ya miyamma goh di gambang hi pun'apuyan an natalaggang di ammana, ya miyamma goh di opat hi nun'atalegonggong hi pangipahduan hinan attang an gambang ta mepong an miyammah nan opat an dugun nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ya mipa'ayudu' hinan pun'onngan, ya mipatulu ta umatam hinan gagwana. ");
INSERT INTO ifb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ya miyamma goh di attang an akasya, ya ma'amyudan hi gambang, ");
INSERT INTO ifb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ya mipahdu nan attang hinan nun'atalegonggong hinan numpinangngel an dugun di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ya henen pun'onngan ya hay ayiw di miyamma ta malu'angan di bunolna an umat hidin impattig'un he\"ah aatnah dih nan Duntug an Sinai.” ");
INSERT INTO ifb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ya inalin goh Apo Dios ay Moses di, “Ya iyammayuy gettaw di Tuldan Abung, ya nabongley yaldah inadu\"oy di mikultinah appit hi agwan hi un hagangon di buhu'an di algaw an nan napinun linen. ");
INSERT INTO ifb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ya hay gambang di miyammah ba'inti an tu'udna, ya ba'inti goh di ipabunanda, ya nan pana'ul, ya nan mundilig, ya silver di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ya mipaddung di atonyuh nan tu'ud hi pangngelnah appit hi iggid hi un hagangon di buhu'an di algaw an hay mikultina ya nabongley yaldah inadu\"oyna, ya ba'intiy tu'udna, ya ba'inti goh di ipabunanda. Ya nan pana'ul an wah nan tu'ud ya nan itayunan di kultina ya silver di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ya hay kultinah appit di alimuhan di algaw ya ba'inti ta lemay yaldah inadu\"oyna, ya waday himpuluh tu'udna, ya himpulu goh di ipabunanda, ");
INSERT INTO ifb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ya hay appit di buhu'an di algaw hinan wadan di pantaw ya hay mikultina goh ya ba'inti ta lemay yaldah inadu\"oyna. ");
INSERT INTO ifb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","At nan pangngel di pantaw hinan agwan ya pitu ya han godway yaldah inadu\"oy nan mikultina ya tuluy tu'ud, ya tulu goh di ipabunanda. ");
INSERT INTO ifb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ya umat goh hinan pangngel di pantaw an pitu ya han godway yaldah inadu\"oy nan mitayun an kultina, ya tuluy tu'ud, ya tulu goh di ipabunanda. ");
INSERT INTO ifb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ya nan pantaw nan gettaw ya himpuluy yalday inadu\"oy nan mitayun an kultina an nan napinuy abolnan linen ya mundongngol an lo'ob an hay kololda ya munggudla, ya mumpugagaw, ya mumbolah, ya mibolday al'altina. Ya wada goh di opat an tu'udna, ya opat goh hi ipabunanda. ");
INSERT INTO ifb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ya an amin nan tu'udnah nan nunlene'woh ya hay silver di miyammah tulidda an ta\"on nan pana'ulda ya silver goh. Ya nan ipatlo'an di tu'udda ya gambang di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","At hay inadu\"oy nan luhud ya nabongle di mitlus, ya ba'inti ta lemay mitlus hi inabellogna, ya duwa ta han godway mitlus hi inata'nangna. Ya umat goh hinay lukud di mikultina an nan mundongngol an lo'ob. Ya hay gambang di ipattu'an nan tu'udda. ");
INSERT INTO ifb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ya an amin di alimatung hi miyammah nan Tuldan Abung ya nan luhudna ya gambang.” ");
INSERT INTO ifb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ya inalin goh Apo Dios di, “Ya mandalom nan holag Israel ta idatan da'ah nan ma\"aphod an lanan di olibon ma'usal hi hilaw ta hiyay punhilawyu ta adi maddang an un bubumnang. ");
INSERT INTO ifb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ya hi Aaron ya nan imbabaluynay manalimun hinan hilaw an wah nan pangngel nan kultina an awadan nan Kahon an Nittuwan di Uldin Apo Dios. Ya henen hilaw ya mahapul an bubumnang hi abigabigat ya amahdomahdom. Ya hiyatuy mandal hinan holag Israel ya nan holagda ta gunda inaynayun an ato'aton ta nangamung.” ");
INSERT INTO ifb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Inalin goh Apo Dios ay Moses di, “Ipa'ayagmuh Aaron an hi agim, ya nan imbabaluyna an da Nadab, ya hi Abihu, ya hi Eleazar, ya hi Ithamar ta inlahhinmu didah nan holag Israel ta diday mumpadin munhulbin Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ya ipiyammam di nob'on an lubung agim an hi Aaron an nan ma\"aphod di tigawnan lubung ta me'gonan hiya. ");
INSERT INTO ifb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ya alyom hinan nun'ala'eng an indata' di abalinanda ta iyammaday lubung Aaron ta hiyay ilubungnah nan idawatanan mumpadi ta Ha\"in di itamuana. ");
INSERT INTO ifb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ya umat hituy aat di miyammah lubung di padi: nan mihophop hi palagpag, ya nan ephod, ya nan lubung an mi'id ngamayna, ya nan lubung an adu\"oy di ngamayna, ya magayad an maboldaan, ya nan mibalikis, ya nan miyuklup an ma'alih turban. At hiyanay miyammah me'gonan an lubung agim an hi Aaron ya nan imbabaluyna ta hiyay ilubungdah nan pangitamuandan Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ya hay miyammah lubungda ya nan muntitiba an umat hi balitu', ya nan lo'ob an munggudla, ya mumpugagaw, ya mumbolah, ya nan napinun linen.” ");
INSERT INTO ifb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ya inalin goh Apo Dios di, “Ya hay iyammayuh nan ephod ya hay muntitiba an umat hi balitu', ya nan munggudla, ya mumpugagaw, ya mumbolah an lo'ob, ya nan napinu an linen, ya ipaboldam hinan nala'eng ta maphod di al'altina. ");
INSERT INTO ifb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ya miyammay duwah go'od hinan numpinangngel ta way mihi'gut hi pundittumanda. ");
INSERT INTO ifb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ya nan balikis di ephod ya umat goh hinan niyamman niboldah nan ephod. ");
INSERT INTO ifb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ya ummal'ah duwan batu an onyx ta ihelhelmu nan ngadan nan linala'in imbabaluy Israel. ");
INSERT INTO ifb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ya onom an ngadan di ihelhelmuh nan ohan batu, ya onom goh hinan miyadwan batu, ya mahapul mete\"ah nan pangpangullu ta engganah nan udidian di mihelhel. ");
INSERT INTO ifb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ya ihelhelmu nan himpulu ta duwan ngadan nan imbabaluy Israel hinan duwan batu an umat hinan aton di mangammah malka, ya punle'wohom an ihelhel nan balitu' hinan duwan batu. ");
INSERT INTO ifb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ya ihinayuh nan way pu'ol di ephod ta way panginomnoman hinan imbabaluy Israel. Ya hay pangilubungan Aaron hinan ephod ya paddungnay unna intata'in di ngadanda ta way panginomnoman Apo Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ya ipiyammam di duwah balitu' hi pangigo'dan, ");
INSERT INTO ifb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ya ipiyammam goh di duwan kanhel an balitu', ya eneg'odmuh nan duwan pangigo'dan.” ");
INSERT INTO ifb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ya inalin goh Apo Dios ay Moses di, “Ya mumpa'amma'a goh hi hophop di palagpag ta way miyammah palagpag hi panginnilaan hinan ipa'innila'. Ya nan nala'eng di mangiyamma an umat hi amman nan ma\"aphod an amman di ephod, ya hay miyamma ya balitu', ya nan munggudla, ya mumpugagaw, ya mumbolah, ya nan napinuy abolnan linen. ");
INSERT INTO ifb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Hete an mihophop ya mikupin ta mapapaddung di inabellogna ya inadu\"oyna an hinhihyam hi pulgada. ");
INSERT INTO ifb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ya nan opat an linya ya hintutluy nun'anginan batuh mi'al'alti. Ya hay mahhun an linya ya hay mi'al'alti ya nan ruby, ya topaz, ya beryl. ");
INSERT INTO ifb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ya nan miyadwan linya ya hay mi'al'alti ya nan turquoise, ya sapphire, ya emerald. ");
INSERT INTO ifb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ya nan miyatlun linya ya nan opal, ya agate, ya amethyst. ");
INSERT INTO ifb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ya nan miyapat an linya ya chrysolite, ya onyx, ya jasper. Ya hanan nun'anginan batu ya waday balitu' hi al'altin ipatlo'anda. ");
INSERT INTO ifb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ya danen hinohhan nun'anginan batu ya miyunnud an mahayhaynod an mihelhel nan ngadan di himpulu ta duwan tribon hihakup di i'Israel. ");
INSERT INTO ifb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ya iyammayu goh di balitu' an kanhel ta meg'od hinan pingit di lubung an nan hophop di palagpag hinan way pu'ol. ");
INSERT INTO ifb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ya iyammayu goh di duwah natalegonggong hi punggo'dan hinan way numpiningngit hinan hophop di palagpag an kanhel. ");
INSERT INTO ifb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","At meg'od nan balitu' an kanhel hinan natalegonggong an punggo'dan hinan hophop di palagpag, ");
INSERT INTO ifb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ya meg'od goh nan bongwah di kanhel hinan way punggo'dan hi pu'ol di ephod. ");
INSERT INTO ifb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ya mangamma ayu goh hi duwah natalegonggong an punggo'dan an balitu' ta miyammah nan pingit nan nundalinat an hophop di palagpag an nida\"op hinan ephod. ");
INSERT INTO ifb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ya mangamma ayu goh hi duwah natalegonggong an punggo'dan an balitu' ta miyammah nan nundalinat an pingit di ephod hinan bagtun di balikisna. ");
INSERT INTO ifb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ya nan munggudlan go'od di meg'od hinan niyamman punggo'dan di hophop nan palagpag, ya meg'od goh hinan punggo'dan di ephod ta way mamdon hinan mihophop hi palagpag an mida\"op hinan ephod. ");
INSERT INTO ifb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","At wa ay ta humgop hi Aaron hinan Me'gonan an Kuwaltu ya ilubungna nan hophop di palagpag an nihelhelan di ngadan nan linala'in imbabaluy Israel an hiyay panginomnom ay didah enggana. ");
INSERT INTO ifb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ya ihinam nan hanin di palagpag nan Urim ya Thummim ta mipotto' hinan puhun Aaron ya un humigup an mi'hapit ay Ha\"in. At nan umayanan mi'hapit ya ilubungnah nen hophop di palagpag ta way atonan manginnilah nan pohdo' an ipa'innilah nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ya inalin goh Apo Dios di, “Ya mumpa'amma'a goh hi namahig an munggudla an magayad an lubung an milubung hi mahhun ya un nan ephod. ");
INSERT INTO ifb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ya miyammay pangihu'luban hi ulu, ya mahapul an miyadyugu nan pingitna ta adi mahekhek. ");
INSERT INTO ifb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ya nan lupit di lubung ya matayunan hi umat hi bungan di ayiw an pomegranate an hay kololda ya munggudla, ya mumpugagaw, ya mumbolah. Ya nan numpumbattananda ya matayunan hi balitu' an kengkeng. ");
INSERT INTO ifb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ya mibattabattan di kengkeng an balitu' an umat hi bungan di pomegranate ta munle'woh hinan lupit di lubung an magayad. ");
INSERT INTO ifb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ya hiyay ilubung Aaron hinan humgopanah nan Me'gonan an Kuwaltu ta Ha\"in itamuana. At wa ay ta humigup unu pumitaw hi Aaron ya kumeleng nan balitu' an kengkeng ta adi hiya matoy. ");
INSERT INTO ifb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ya ipiyammam di namahmah an balitu' an pangitud'an ya inhelhelmu nan hapit an alyonay, MEꞋGONAN HI APO DIOS. ");
INSERT INTO ifb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ya go'dam hi munggudlan hinulid ta mitayun hinan turban an mipotto' hinan tu'paw Aaron. ");
INSERT INTO ifb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ya e'epngot Aaron hi tu'pawna ta Ha\"in an Dios ya abuluto' an amin nan e'nongnan malpuh nan holag Israel an ta\"on un nan e'nongdan dumalat hi ibahhawanda. Ya memepngot hi uluna ta abuluton Apo Dios dida. ");
INSERT INTO ifb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ya ipiyammam nan lubung Aaron an magayad, ya adu\"oy di ngamayna an hay miyamma ya nan ma\"aphod an linen. Ya umat goh hinay miyammah nan turban. Ya nan mibalikis ya ma'al'altian. ");
INSERT INTO ifb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ya mun'amma ayu goh hi magayad ya adu\"oy di ngamayna an lubung nan linala'in imbabaluy Aaron, ya nan balikisda, ya headband ta maphod di tigawda, at me'gonanda. ");
INSERT INTO ifb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ya ipilubungmun da Aaron an hi agim ya nan linala'in imbabaluyna hanan lubung. Ya nalpah ay ya hiitam di uludah nan lanan olibo, ya indawatmu dida ta milahhinda ta midat di haaddan mumpadi ta Ha\"in di itamuanda. ");
INSERT INTO ifb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ya miyamma goh di putut an pantelondan meppong hi gitangda ta engganah ulpuda. ");
INSERT INTO ifb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ya hiyay ipantalon Aaron ya nan linala'in imbabaluynah unda humigup hinan Tuldan Abung ta muntamudah nan pun'onnganyun Ha\"in, ta way atondan adi mumbahol, at adida matoy. Hiyah te Uldin hi unudon da Aaron hi enggana ya ta\"on nan holagda.” ");
INSERT INTO ifb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ya inalin goh Apo Dios ay Moses di, “Hiyah te atom ay da Aaron ya nan linala'in imbabaluynah unmu idawat dida ta midat di haaddan padi ta Ha\"in itamuanda. At ummal'ah me'nong an ohah manilhig an baka ya duwan buta'al hi kalnilu an mi'id ganitna. ");
INSERT INTO ifb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ya nan mapmaphod an alena an agguy nabino'bo'an di milamut hi mantika ta mihaang an miyammah tinapay, ya cake, ya wafer an tinapay an namantikaan goh di tu'yapna. ");
INSERT INTO ifb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ya ittum danen tinapay hinan bahkit ta iddummun e'nong ay Ha\"in hi unmu e'nong nan manilhig an baka ya nan duwan buta'al an kalnilu. ");
INSERT INTO ifb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ya iyuymu da Aaron ya nan linala'in imbabaluynah nan pantaw di Tuldan Abung, ya inihuam didah danum. ");
INSERT INTO ifb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ya ipilubungmun Aaron nan magayad an adu\"oy di ngamayna, ya nan magayad an lubung an ipa'pa'an di ephod, ya nan ephod, ya nan mihophop hi palagpag, ya inhamadmu nan balikis di ephod. ");
INSERT INTO ifb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ya ipiyuklupmu nan turban, ya epepngotmu nan balitu' an nitud'an di hapit an alyonay, MEꞋGONAN HI APO DIOS. ");
INSERT INTO ifb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ya innalmu nan lana, ya inhiitmuh uluna, ya indawatmu hiya. ");
INSERT INTO ifb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ta nalpah ay an nidawat hi Aaron ya initnudmu goh nan linala'in imbabaluyna, ya impilubungmun dida nan magayad an adu\"oy di ngamayna. ");
INSERT INTO ifb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ya ipiyuklupmun dida nan headband di padi, ya pumbalikisom dida. At umat hinay atom an mangidawat ay da Aaron ya nan linala'in imbabaluyna ta dida ya nan a'apuday manginaynayun hinan Uldin di aton an mumpadi.” ");
INSERT INTO ifb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ya inalin goh Apo Dios di, “Ya ipiyuymu nan manilhig an bakah nan pantaw di Tuldan Abung'u an Dios, ya inalim ay da Aaron ya nan linala'in imbabaluyna ta eh'adah nan ulun nen baka. ");
INSERT INTO ifb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ya genlotmu nan manilhig an bakah nan hinagang'u an Dios hinan way pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ya alam di udumnah nan dalan di baka ta ilamuh nan galaygaymuh nan ha'gud di pun'onngan, ya nan udumnan dala ya ihiitmuh nan puun di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ya anom an amin nan taban nida\"op hinan minalutu, ya ta\"on nan taban niyunanit hinan oltay, ya nan duwan batin ya genhobmuh nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mu an amin nan lamoh, ya up'up, ya nan putu, ya nan galutna ya ekakdah nan immapalanda ya unda gohbon ti hiyah ne Onong di Bahol.” ");
INSERT INTO ifb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ya inalin goh Apo Dios ay Moses di, “Ya alam goh di ohah nan buta'al an kalnilu, ya inalim ay da Aaron ya nan linala'in imbabaluyna ta eh'adah nan uluna. ");
INSERT INTO ifb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ya genlotmu, ya innalmuy dalana, ya inwalhim hinan nunlene'woh hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ya pinhitmu nan kalnilu, ya ginogodmu, ya dinaluham nan putu, ya inulaham nan hu'ina, ya inyuhunmuh nan ulu ya nan udumnan nagogod ta malammung. ");
INSERT INTO ifb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ya genhobmun amin nan dotag di buta'al an kalniluh nan pun'onngan ta Onong an Moghob an me'nong ay Apo Dios ta maphod hi hunghungo' ti hiyay onong an mipagah nan apuy. ");
INSERT INTO ifb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ya innalmu goh nan ohan buta'al an kalnilu, ya inalim ay da Aaron ya nan linala'in imbabaluyna ta eh'adah uluna. ");
INSERT INTO ifb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ya genlotmuh nen kalnilu, ya inummal'ah dalana ta edenehmuh nan agwan di tamuy di ingan da Aaron ya nan linala'in imbabaluyna, ya deneham goh nan am'ama\"ah agwan di ngamayda, ya nan am'ama\"ah agwan di hu'ida. Ya nan udumnan dala ya inwalhim hinan nunlene'woh hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ya alam di udumnah nan dalah nan pun'onngan, ya inudmam hinan lana, ya inwalhim ay Aaron, ya nan lubungna, ya nan linala'in imbabaluyna, ya nan lubungda goh. At hiyah ne mangipa'innila an da Aaron, ya nan linala'in imbabaluyna, ya nan lubungda an nidawatdan Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ya anom an amin nan taban di kalnilu an wah nan way iwitna, ya nan nida\"op hinan putuna, ya nan niyunanit hinan oltayna, ya anom nan duwan batina ya nan wah nan agwan an ulpuna. Ma'innila an hiyah ne kalnilun me'nong. ");
INSERT INTO ifb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ya innalmuy hinohhan tinapay an wah nan bahkit an din ne'nong ay Ha\"in, ");
INSERT INTO ifb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ya ipadonmun da Aaron ya nan linala'in imbabaluyna ta ilayatda an e'nong ta hiyay Milayat an Onong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ya wa ay ta nalpah ya innalmu nan inodnanda, ya genhobmuh nan pun'onngan ta middum hinan Onong an Moghob, ta nan maphod an hunghungnay mangipadenol ay Ha\"in ti hiyah ne Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ya innalmu nan boga' nan kalnilun din ne'nong hi nidawatan Aaron, ya inlayatmun mange'nong ay Ha\"in an Dios, ya henen nilahhin ya bagim. ");
INSERT INTO ifb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ya midawat nan boga' an milayat, ya umat goh hinan ulpun din ne'nong an kalnilun bagin da Aaron ya nan linala'in imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ya hiyah ne bagin da Aaron ya nan linala'in imbabaluynah munnononnong an malpuh nan gun ipe'nong nan holag Israel ay Ha\"in an hi Apo Dios hi Onong di Pi'lenggopan hi i'ibba. ");
INSERT INTO ifb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","At nan me'gonan an lubung Aaron ya miboltan hinan linala'in imbabaluynah un matoy ta diday mangilubung ya mahiitandah lana ta midawatdan mumpadi. ");
INSERT INTO ifb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ya nan mihukat ay hiya ta mumpadi ya ilubungnah nen lubung hi pituy algaw hinan humgopanah nan Tuldan Abung an pundayawan ta muntamuh nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ya nan dotag di ne'nong hi nidawatan Aaron ya nan linala'in imbabaluyna ya alam ta ihaangmuh nan wadan di lugal an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ya hidih nan way pantaw di Tuldan Abung di panganan da Aaron ya nan linala'in imbabaluyna ta ihdada nan lamoh nan kalnilu, ya ononda nan tinapay an nan mittuh bahkit. ");
INSERT INTO ifb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ya da Aaron ya nan linala'in imbabaluyna ya anggay di mangan hinan ne'nong an mananih baholdah din nahiitandah lana ta midawatda, ya mi'id udum hi me\"an ti me'gonan an nidawat ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ya gulat ta way ma'angang hinan dotag di ne'nong an kalnilu ya nan tinapay ta engganah mabiggat ya gohbonyu. Ya adiyu onon ti paniaw an ne'nong ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","At hiyah te atom an mangidawat ay da Aaron ya nan linala'in imbabaluyna, an hiyah ne tuwali din immandal'un he\"ah atom. Ya pituy algaw di pangatam hi pangidawatam ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ya heden pituy algaw ya abigabigat ya e'nongmuy ohah manilhig an baka ta Onong an Baholda. Ya henen onong di munleneh hinan pun'onngan ya hiitam hi lanan di olibo ta me'gonan. ");
INSERT INTO ifb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ya onngam hi pituy algaw nan pun'onngan ta me'gonan ahan, at nan manapah nan pun'onngan ya me'gonan goh.” ");
INSERT INTO ifb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ya inalin goh Apo Dios di, “Hay mahapul hi e'nongmuh nan pun'onngan hi binigat ya duway kalnilun hinohhay tawonda. ");
INSERT INTO ifb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Nan oha ya e'nongmuh nan helhelong, ya nan oha ya nan mapuyaw. ");
INSERT INTO ifb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","At heden mahhun an kalnilu an me'nong ya iddummun e'nong nan oha ya han godwan bahuh nan ma'adyamu' an alenan ma'udman hi ohay bahuh nan mantikan di olibo, ya nan ohah bahuh bayah ta Onong an Ma'inum. ");
INSERT INTO ifb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ya heden miyadwan kalnilu ya e'nongmuh nan mapuyaw, ya umat goh hinay atonyuh din nahhun an waday alenah middum, ya wada goh di bayah an Onong an Ma'inum. Ya manu ay atonyu ta nan angilitday mangipa'amlong ay Ha\"in an hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya heten Onong an Moghob an gunyu ato'aton hinan way pantaw di Tuldan Abung ya minaynayun ta nangamung nan a'apuyuh pidwa. Ya henen lugal an awada' di pi'dammuwa' ay he\"a ta mi'hapita' ay he\"a, ");
INSERT INTO ifb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ya hidi goh di panamuwa' hinan holag Israel. At henen lugal ya malenehan ta me'gonan ti dumalat nan benang'u. ");
INSERT INTO ifb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ya pumbalino' hi maleneh nan Tuldan Abung ya nan pun'onngan, at me'gonan. Ya da Aaron ya nan linala'in imbabaluyna ya midawatda ta way atondan me'gonan, ta diday mumpadi, ta Ha\"in di itamuanda. ");
INSERT INTO ifb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ya mimidduma' hinan holag Israel ta Ha\"in di Dios hi dayawonda. ");
INSERT INTO ifb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ya hiyah ne panginnilaanyun Ha\"in an hi Apo Dios di nangiyabulut hi nakakanyud Egypt, at mimidduma' ay da'yu ti immannung an Ha\"in hi Apo Dios an dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ya inalin goh Apo Dios ay Moses di, “Ya hay iyammayuh nan pun'onngan ya nan ayiw an akasya ta way panghobanyuh nan incense. ");
INSERT INTO ifb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ya hay lukud di inabellogna ya nan inadu\"oyna ya mumpapaddung an hinohha ya han godway umpi, ya hay lukud di inata'nangna ya tuluy umpi. Ya iyammayuy opat an ha'gud hinan opat an duguna. ");
INSERT INTO ifb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ya ma'amyudan hi namahmah an balitu' nan tu'yapna, ya nan opat an ha'gudna ya nan opat an numpinangngel ya ma'al'altian hi namahmah an balitu' hi nunlene'woh. ");
INSERT INTO ifb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ya mahindudway miyammah natalegonggong an balitu' hinan way numpinangngel hinan pun'onngan an meheggon hinan ampan di lehton ta way ipahduan di attang. ");
INSERT INTO ifb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ya hay iyammayuh attang ya nan ayiw an akasya, ya ma'amyudan hi balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ya ipabunyu nan pun'onngan hinan way hinagang di kultina an wah potto' di Kahon an Nittuwan di Himpulun Uldin ti hidiy awada' hi panamuwa' ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ya mahapul an gohbon Aaron nan incense hinan way pun'onngan hi ahelhehelhelong hinan ayanan manalimun hinan hilaw. ");
INSERT INTO ifb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","At wa ay ta tolgan Aaron nan hilaw hinan munhinag ya gohbona goh nan incense. Ya mahapul an hiyah ne minaynayun hi enggana an gunyu ato'aton, ya ta\"on nan holagyuh awni. ");
INSERT INTO ifb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ya adiyu e'nong nan nat'on an incense, unu nan nat'on an animal hi me'nong an moghob, unu nan nat'on an alena, ya adiyu ihiit hidi nan nat'on an bayah hi me'nong. ");
INSERT INTO ifb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ya mamenghan hi ohay tawon di pangiyamyudan Aaron hinan dalan di Onong di Bahol hinan ha'gud di pun'onngan ta malenehan an me'gonan. Ya mahapul an minaynayun an gun aton nan holagyuh enggana ti heten pun'onngan ya me'gonan ahan.” ");
INSERT INTO ifb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Wa ay ta uyapom nan holag Israel ta panginnilaan hi unda atna ya way oha ay didaan idatday bayad nan pi'taguandah nan aluhandah pamilangam ay dida ta adi' moltaon dida. ");
INSERT INTO ifb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ya hiyah te idat di hinohhah a'yapanda an onom di gramos an silver an umat hinan silver me'nong hinan Tuldan Abung. Ya henen onom di gramos di hiyay onongdan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","At an amin di ma'yap an mete\"ah ba'intiy tawona unu nahuluk ya mahapul an idatda nan onongdan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","At nan adangyan ya adida udman, ya nan nawotwot ya adida kudangan nan onom di gramos hinan pangidatandah nan onongdan Ha\"in ta way bayad di pi'taguanda. ");
INSERT INTO ifb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","At amungom nan bayad di pi'taguan an idat nan holag Israel ta way ma'usal hinan Tuldan Abung, at henen bayadda ya hiyay panginomnoma' an Dios hinan holag Israel an nabayadan di pi'taguanda.” ");
INSERT INTO ifb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Iyammayuy pamahan, ya gambang goh di tu'ud di ipattu'ana ta hiyay pun'ihuan. Ya ihinayuh nan numbattanan di Me'gonan an Kuwaltu ya nan pun'onngan, ya inittuwanyuh danum. ");
INSERT INTO ifb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ta hiyay pun'ihuan da Aaron ya nan linala'in imbabaluynah ngamayda ya hu'ida. ");
INSERT INTO ifb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","At wa ay ta humgopdah nan Me'gonan an Kuwaltu unu umuyda mun'onong hinan onong an mipaga ta me'nong ay Apo Dios ya mahapul an mun'ihudan nen danum ta adida matoy. ");
INSERT INTO ifb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","At ihuanday ngamayda ya hu'ida ta adida matoy. Ya hiyah te Uldin ay didah minaynayun ta nangamung di holagdah awni.” ");
INSERT INTO ifb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ummal'ah nan ma\"aphod an miyammah bangbanglu an hay alam ya tuluh kiluh nan myrrh, ya hinohha ya han godwah kiluh nan cinnamon, ya nan kanela an mapmaphod di hunghungda, ");
INSERT INTO ifb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ya tuluy kiluh nan cassia an miyunnudan hinan kilun nan me'nong hinan Tuldan Abung. Ya inudmam hi opat di litloh lanan di olibo. ");
INSERT INTO ifb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","At hiyanay ipiyammam hinan nala'eng an mun'ammah lana ta ma'amman hi me'gonan an lana ta ma'usal hinan way midawat ");
INSERT INTO ifb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ta hiyay ihiitmuh nan Tuldan Abung an pi'dammuwa' ay he\"a, ya nan Kahon an Nittuwan di Uldin, ");
INSERT INTO ifb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ya nan lamehaan ya nan alimatungna, ya nan pangipattu'an hi hilaw ya nan alimatungna goh, ya nan pun'onngan hi incense, ");
INSERT INTO ifb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ya nan pun'onngan hi moghob ya nan alimatungna, ya nan pamahan, ya nan tu'udna. ");
INSERT INTO ifb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ya idawatmu dane ta ma\"e'gonanda, at nan manapa ya me'gonanda goh. ");
INSERT INTO ifb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","At hiitam hi Aaron ya nan linala'in imbabaluynah nan lana, ya indawatmu dida ta mumpadida ta Ha\"in itamuanda. ");
INSERT INTO ifb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ya alyom hinan holag Israel di, Me'gonan heten lana an ma'usal hinan way midawat, ya hiyay usalonyuh enggana an ta\"on nan holagyu. ");
INSERT INTO ifb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ya adi mihiit hinan malgom an tagu, ya adiyu goh enghon an iyammay paddungna ti ma\"e'gonan, at e'gonanyu goh. ");
INSERT INTO ifb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ya wada ay di mangiyengngoh an mangiyamma eten lana unu mangihiit hinan malgom an tagu ya mahapul an pakakon nan tatagun niddumana.” ");
INSERT INTO ifb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ya inalin Apo Dios ay Moses di, “Ummal'ah nan numbino'ob'on an mapmaphod di hunghungda, ya mapapaddung di damotda an nan stacte, ya onycha, ya galbanum, ya nan frankincense. ");
INSERT INTO ifb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ya lammungom an amin, ya inyammam hi bangbanglun incense an umat hi aton nan mun'ammah bangbanglu. Ya ahinam hi itang ta henen incense ya namahmah, at me'gonan. ");
INSERT INTO ifb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ya gimu'om di udumna ta mapinu, ya inhinam hinan hinagang nan Kahon an Nittuwan di Uldin hinan Me'gonan an Kuwaltu an pi'dammuwa' ay he\"a. Ya henen bangbanglu ya na'ahhamad an incense, at e'gonanyu. ");
INSERT INTO ifb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ya adiyu enghon an iyammah ten incense hi un ayu mun'ammah usalonyu ti me'gonan ahan an Ha\"in an Dios ya anggay di ad bagi. ");
INSERT INTO ifb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ti nan mangiyammah umat hina ta usalondah odolda ya pakakonyu ta mapogpog di iddumanan da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ipa'innila' ay he\"a an pento\"uh Bezalel an imbaluy Uri ya ap'apun Hur an holag Judah, ");
INSERT INTO ifb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ya impiyodol'un hiya nan Na'abuniyanan an Lennawa, at nanomnoman ya nala'eng an abalinanan mangat hi an amin hinan mipiyamma, ");
INSERT INTO ifb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ya nala'eng goh an mangiyal'altih nan iyammanan balitu', ya silver, ya gambang. ");
INSERT INTO ifb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ya abalinana goh an manabat hinan nanginan batu, ya helhilana an tud'an nan batu, ya mumpa'ot hi ayiw, ya abalinanan amin nan naligat an miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ya pento\"u goh hi Oholiab an imbaluy Ahisamak an holag Dan ta bumadang ay Bezalel. Ya nan tatagun way abalinana ya nanomnoman di pangidata' hi la'eng ta abalinandan iyamman amin nan immandal'un he\"an ipiyammam. ");
INSERT INTO ifb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","At diday mangiyammah nan Tuldan Abung an a'amungan nan tatagu, ya nan Kahon an Ittuwan nan Himpulun Uldin, ya nan alubnan ihinan nan Ma'ahhimo', ");
INSERT INTO ifb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ya nan lamehaan ya nan alimatungna, ya nan balitu' an ipattu'an di hilaw ya nan alimatungna, ya nan pun'onngan hinan incense, ");
INSERT INTO ifb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ya nan pun'onngan hinan Onong an Moghob ya nan alimatungna, ya nan pamahan ya nan tu'udna, ");
INSERT INTO ifb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ya nan lo'ob an pami'lug hinan gina'u, ya nan me'gonan an numbino'ob'on an lubung nan Nabagtun Padin hi Aaron ya nan linala'in imbabaluynah unda itamu nan tamun di padi, ");
INSERT INTO ifb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ya nan lanan mihiit hinan way midawat, ya nan incense an maphod di hunghungnan ma'usal hinan Me'gonan an Kuwaltu. Ya mahapul an unudondan amin nan immandal'un he\"ah atondan mangiyamma.” ");
INSERT INTO ifb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Alyom hinan holag Israel an mahapul an ngilinonda nan miyapitun algaw an nun'eblaya' ti hiyah ne pangimmatunanyu ya nan holagyun Ha\"in an nan nuntulaganta ya hiyay panginnilaanyun Ha\"in an hi Apo Dios di nangilahhin ay da'yu ta tagu'. ");
INSERT INTO ifb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","At ngilinonyu nan miyapitun algaw ti hiyah ne inlahhin'un algaw hi pun'eblayanyu. At nan tagun manewa'el hinan ngilin ya mapatoy, ya nan tagun muntamun den algaw ya mapogpog di pi'taguanah nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ya onom di algaw hi puntamuanyu, mu nan miyapitun algaw ya mun'eblay ayu ti hiyay me'gonan an algaw an bagi' an hi Apo Dios. At nan muntamuh nan miyapitun algaw ya mahapul an mapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","At da'yun holag Israel ya mahapul an ngilinonyu nan miyapitun algaw, ya ato'aton goh nan holagyuh enggana ta mangipanomnom hinan nitulag. ");
INSERT INTO ifb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ti hiyah te pangimmatunanyuh ni'tulaga' hinan holag Israel hi mid pogpogna ti onom di algaw hi nunlumuwa' ad daya ya tun luta, ya nan miyapitun algaw ya indinong'un muntamu ta nun'eblaya'.” ");
INSERT INTO ifb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ya unat goh nalpah an ni'hapit hi Apo Dios ay Moses hinan Duntug an Sinai ya indatnan hiya han duwan mun'ayapit an batun nangitud'an Apo Dios hinan Himpulun Uldina an hay tudtudunay nuntudo'na. ");
INSERT INTO ifb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ya nabayag hi Moses hidih nan duntug an agguy nundaddadyu, ya iyahupan nan tatagu. At immuydan Aaron, ya inaliday, “Iyammam di dios ta waday mangipangpangulun ditu'u ti henen hi Moses an nangekak ay ditu'ud Egypt ya agguy tu'u inilay na'at ay hiya!” ");
INSERT INTO ifb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ya inalin Aaron ay diday, “Anonyu nan balitu' an inhihingat nan a'ahawayu ya nan imbabaluyyu, ya inyaliyun ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","At an amin din tatagu ya nun'aanday hingatda, ya inyuydan Aaron. ");
INSERT INTO ifb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ya innalna nan indatda ta hinibugnah bulul an umat hi bu'tot an baka. Ya la'tot ya inaliday, “Hiyah te dios tu'u an holag Israel an nangekak ay ditu'ud Egypt!” ");
INSERT INTO ifb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ya unat goh tinnig Aaron an amlo'amlongan nan tatagu ya inyammanay pun'onngan hinan way hinagang nan bulul, ya inalinay, “Hi ma'et ya ibehtaan tu'uh Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","At nabiggat ya ag'aga ya bimmangonda nan tatagu, ya inyuyda nan a'animal ta nun'onongdah nan Onong an Moghob an midat hinan dios, ya nan udumna goh an a'animal an Onong di Pi'lenggopan hi pi'pohhodan. Ya nalpah hede ya inumbunda ta manganda, ya nanginumda ta nun'abutongda, ya umipabain di atonda. ");
INSERT INTO ifb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ya inalin Apo Dios ay Moses di, “Mundadyu'a ti nan tatagun enekakmud Egypt ya numbaholda! ");
INSERT INTO ifb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ti himbumagga ya din'ugda din intugun'un dida! Ti nunhibugdah bulul an ay baka, ya dinayawda, ya inyuyday e'nongda, ya inonngandan inaliday, Tayay dios nan holag Israel an nangekak ay ditu'ud Egypt!” ");
INSERT INTO ifb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ya inalin goh Apo Dios di, “Tinnig'u daden tatagu, ya nunheglan adida ahan matugun, ");
INSERT INTO ifb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","at nunheglay bungot'un didan pohdo' an ma'ubahda! At okoda' an mangat ene an adim ipagol ta he\"ay pumbalino' hi do'ol di holagna ta ohay himpamabluy!” ");
INSERT INTO ifb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mu inal'alu' Moses hi Apo Dios an inalinay, “Anaad ahan ta ubahon di bungotmu nan tatagum an enekakmud Egypt an dumalat nan nidugah an abalinam? ");
INSERT INTO ifb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ya undan adi alyon nan i'Egypt hi unmu enekak ta iyalim an patayon didah tuh tun duntug ta ma'ubahdah tun luta? Aliwam ni' ahan nan nidugah an bungotmu, ya adim ni' ahan idat di ligat nan tatagum! ");
INSERT INTO ifb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ya nomnomom ni' ahan nan baalmun da Abraham, ya hi Isaac, ya hi Jacob an nangitulagam an pumbalinom nan holagda ta nidugah an do'ol an umat hi bilang nan bittuan hi ad daya, ya idatmuh nan holagdan amin heten lutan intulagmun dida ta banohdah enggana!” ");
INSERT INTO ifb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","At inaliwan Apo Dios ta agguyna inat din alyonah atonan na\"appuhin ligat nan tataguna. ");
INSERT INTO ifb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ya nundadyuh Moses eden duntug, ya inodnana nan duwan mun'ayapit an batun nitud'an di Uldin an nitudo' hi numbinallin. ");
INSERT INTO ifb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ya nan mun'ayapit an batu ya hi Apo Dios di nangiyamma ya nangitudo' hinan Uldin an nihelhel hinan batu. ");
INSERT INTO ifb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ya unat goh dengngol Joshua nan tatagun tumungog ya bumanugaw ya inalinan Moses di, “Ay paddungnay donglo' an waday munggugubat hinan way apal!” ");
INSERT INTO ifb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ya inalin Moses di, “Han donglo' ya bo'on hay mangabak ya na'abak ti nan donglo' ya unda mungkanta.” ");
INSERT INTO ifb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ya unat goh wan umatam da Moses hinan way kampu ya tinnigna han niyamman bulul an ay uyaw an baka ya nan manayaw at ma'abbungot, ya impuhitna din ino'odnanan mayapit an batu ta nun'agimu' ede han puun den duntug. ");
INSERT INTO ifb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ya innalnah de han bulul, ya inapuyana, ya nunggimu'na ta napinu', ya ingkiwalnah nan danum, ya impa'inumnah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ya inalin Moses ay Aaron di, “Hay ngadan di inat nan tatagun he\"a ta omod hi unmu intudtuduy ongol hi numbaholanda?” ");
INSERT INTO ifb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ya inalin Aaron di, “Adi'a ni' bumungot, apu', ti ta\"on he\"a ya i'innilam an gunda mumbahol nan tatagu! ");
INSERT INTO ifb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ti inalidan ha\"in di, Mahapul an iyammam di dios tu'u ta waday mangipangpangulun ditu'u ti hi Moses an nangekak ay ditu'ud Egypt ya agguy tu'u inilay na'at ay hiya! ");
INSERT INTO ifb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","At inali' ay diday, Nan waday gina'unah balitu' ya iyaliyun ha\"in, ya intapal'uh nan apuy, at hiyah te an bakay na'ammaana!” ");
INSERT INTO ifb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ya tinnig Moses nan nunheglan umipabain an mid poto' di ato'aton nan tatagu ti inabulut Aaron nan ato'atonda, at gulat ta gubaton nan binuhulda dida at ma'abakda! ");
INSERT INTO ifb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","At timma'dog hi Moses hinan way pantaw di immapalanda, ya inalinay, “Da'yun mangunud ay Apo Dios ya umali ayuh appit ay ha\"in!” Ya an amin din holag Levi ya numpapanguydan hiya. ");
INSERT INTO ifb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ya inalinan diday, “Hiyah te inalin Apo Dios an dayawon nan holag Israel: An amin ayun hinohha ya pun'eh'otyu nan hanggapyu ta le'donyun amin nan apal ta pumpatoyyu nan linala'in a'agiyu, ya nan liligwayu, ya nan heneggonyu an wah di!” ");
INSERT INTO ifb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ya inat nan holag Levi nan inalin Moses, at hede han algaw ya hi'itangan tuluy libuy linala'ih nun'atoy. ");
INSERT INTO ifb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ya inalin Moses di, “Paddungnay ilahhinyun idawat nan odolyu ta bagin Apo Dios ad ugwan an algaw hi numpamatayanyuh nan imbabaluyyu ya a'agiyu. At mete\"ad ugwan ya wagahan da'yun Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ya unat goh nabiggat ya inalin Moses hinan tataguy, “Ongol di numbaholanyu, mu umuya' ad ugwan ay Apo Dios ta ibaga' ay Hiya ta olom ya iyabulutnay a'aliwan nan numbaholanyu.” ");
INSERT INTO ifb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","At numbangngad hi Moses ay Apo Dios, ya inalinay, “Ongol di numbaholan nan tatagu ti inyammaday balitu' hi dios ta dayawonda! ");
INSERT INTO ifb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mu aliwam ni' di numbaholanda. Ti adim ay ya nan ngadan'u an nitudo' hinan liblum di hiyay anom!” ");
INSERT INTO ifb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ya tembal Apo Dios, ya inalinay, “Nan tagun numbahol di hiyay ano' di ngadanah nan liblu'! ");
INSERT INTO ifb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","At mumbangngad'a ta ipangpangulum nan tatagu ta umuy ayuh nan lugal an din inali' ay he\"a ya nan anghel'uy mangitnud ay da'yu. Mu nan gutud di pummoltaa' ya umannung an moltao' dida an dumalat nan numbaholanda!” ");
INSERT INTO ifb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ya minoltan Apo Dios didah ligat ti dumalat nan impiyammadan bulul an ay bu'tot an bakan hinibug Aaron. ");
INSERT INTO ifb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ya inalin Apo Dios ay Moses di, “Itnudmu nan tatagun enekakmud Egypt ta taynanyuh te han lugal ta umuy ayuh nan lutan intulag'un da Abraham, ya hi Isaac, ya hi Jacob an inali' ay diday, Idat'uh nan holagyu. ");
INSERT INTO ifb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ya honogo' nan anghel ta ipangulu da'yu ta pakakona nan ahimpahimpangapun holag Amor, ya holag Heth, ya holag Periz, ya holag Hiv, ya nan iJebus, ya nan iCanaan. ");
INSERT INTO ifb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ya henen luta ya malumong ya damuna an ma\"almuy mihabal, at nidugah an do'ol di ma'an. Ya adia' mi'yalin da'yu ti nunhegla ahan di adiyu umunudan, at la'tot ya inubah'u da'yuh nan dalan!” ");
INSERT INTO ifb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ya unat goh dengngol nan tatagu nan na\"appuhin hinapit Apo Dios ya nunheglay kilada, at ingnganuydan nangigina'uh nan mun'apla'an an gina'uda. ");
INSERT INTO ifb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ti inalin Apo Dios ay Moses di, “Alyom hinan holag Israel di, Nunhegla ahan an adi ayu umunud an tatagu! Ti gulat nin ta mimitnuda' ay da'yu at la'tot ya inubah'u da'yu! At anonyu nan mun'apla'an an gina'uyu ta nomnomo' di ato' ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","At nan holag Israel ya nun'aandan amin nan gina'uda ede han Duntug an Sinai. ");
INSERT INTO ifb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ya hin'umu'udduman impiha\"ad Moses nan tulda ta ibataanah nan immapalanda, ya nginadnana ta Me'gonan an Kuwaltun Pi'dammuwan. Ta wa ay di mamhod an mi'hapit ay Apo Dios ya umuy ede han tuldan abung. ");
INSERT INTO ifb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ya wa ay ta umuy hi Moses ede han tuldan abung ya numpangata'dogda nan tataguh nan way pantaw di a'abungdan tulda ta amangondah Moses ta nangamung un humigup. ");
INSERT INTO ifb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ya wa ay ta hinumgop hi Moses ya nan bunut an ay ongol an tu'ud ya mun'ohop an naha\"ad hinan pantaw den tuldan abung hi un mi'hapit hi Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ya unat goh tinnig nan tatagu han bunut hinan pantaw di tuldan abung ya way ohaan timma'dogdah nan pantaw di nuntuldaanda, ya inyungyungdan nundayaw ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ya hi Apo Dios ya ni'haggangan an ni'hapit ay Moses an umat hinan pi'hapitan nan tagun ligwana. Ta nalpah ya numbangngad hi Moses hinan immapalanda, mu nan bumadbadang ay hiyan hi Joshua an imbaluy Nun ya na'angang hinan tuldan abung. ");
INSERT INTO ifb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ya inalin Moses ay Apo Dios di, “Inalim di ha\"in di mangipangpangulun date han tatagu, mu engganad ugwan ya agguymu impa'innilay ngadan di honogom hi bumadang ay ha\"in. Ya inalim goh di hinamadmuy aat'u, ya umamlong'ah nan inat'u. ");
INSERT INTO ifb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ya gulat ta impa'amlong'u He\"a ya itudum nan pohdom hi ato' ta innilao' ta hiyay unudo', ta minaynayun di ato' an mangipa'amlong ay He\"a. Ya nomnomom an date han himpampun ya tatagum.” ");
INSERT INTO ifb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ya tembal Apo Dios ya inalinay, “Wagwadaa' an mimitnud ay he\"a, ya idat'uy lumenggopam.” ");
INSERT INTO ifb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ya inalin Moses ay Hiyay, “Gulat ta adi'a mitnud ay da'mi ya adi da'mi pala\"uyon hitu ");
INSERT INTO ifb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ti hay pangimmatunan mah nan tataguh un'a mundenol hinan inatmih un'a adi mitnud ay da'mi? Ti nan itnudam ay da'miy pangimmatunan an waday nun'abhiwanmih nan tataguh tun luta.” ");
INSERT INTO ifb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ya inalin Apo Dios ay Moses di, “Unudo' nan alyom hi ato' ti impa'amlonga' ay he\"a, ya hinamad'uy aatmu.” ");
INSERT INTO ifb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ya inalin Moses di, “Akkay ni' mumpattig'an ha\"in!” ");
INSERT INTO ifb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ya tembal Apo Dios hi Moses an inalinay, “Ipattig'un amin di amaphod'un he\"a, ya ipa'innila' goh di aat'u an Ha\"in di na'ahhamad an Dios. Ya ma'ulaya' hinan tagun pohdo', ya igohgoha' nan pohdo' an igohgohan. ");
INSERT INTO ifb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mu adi mabalin an tigom di angah'u ti nan mannig ay Ha\"in ya matoyda!” ");
INSERT INTO ifb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ya inalin goh Apo Dios di, “Wada han batun neheggon hinan wada' an mabalin hi tuma'dogam. ");
INSERT INTO ifb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta wa ay ta maluha' ya impo\"oy'u he\"an de han lingab hinan batu, ya hinania' he\"ah ngamay'u ta engganay maluha'. ");
INSERT INTO ifb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ya un'u mahkay anon di ngamay'u ta hay bonog'uy tigom ta adim tigon di angah'u.” ");
INSERT INTO ifb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ya inalin goh Apo Dios ay Moses di, “Habatam di duwah mun'ayapit an batun umat hidin nahhun ta pangitud'a' hinan Uldin an din nitudo' hidin impolahmun nagimu' an Uldin'u. ");
INSERT INTO ifb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ya mundadaan'a ta hi ma'et hinan helhelong ya nunti'id'ah dih nan Duntug an Sinai ta mundammuta. ");
INSERT INTO ifb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ya mahapul an mi'id ah mi'ti'id ay he\"a, ya mahapul goh an mi'id ah munle'le'od eden duntug an ta\"on nan a'animal, ya mi'id ah mipahtul eden aluhadhad di duntug.” ");
INSERT INTO ifb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","At hi Moses ya hinabatanay duwah mayapit an batun umat hidin nahhun. Ya unat goh nabiggat hi helhelong ya inodnanah den duwan batu ta iti'idnah nan Duntug an Sinai an hiyah ne din immandal Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ya nun'ohop hi Apo Dios an niddum hinan bunut, ya ni'ta'dog ay hiyah di. Ya imbaagnay ngadanan Hiyah Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ya naluh hinan way hinagang Moses ya inalinay, “Ha\"in hi Apo Dios an ma'ahhimo' ya ma'aggohgoh, ya adia' mabanbannungot, ya nahamad nan pamhod'u, ya makulug nan hapito', ");
INSERT INTO ifb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ya mid pogpog di homo\"uh nan linibun tatagu, ya aliwa' nan nibahhawanda, ya nan numbaholanda, ya nan na\"appuhin ina'inatda. Mu moltao' damdama nan mumbahol an imbabaluyyu, ya minaynayun ta nangamung hinan miyatlu unu miyapat an holagda.” ");
INSERT INTO ifb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ya himbumagga ya nunhippih Moses hinan luta, ya inyungyungna ta dayawona Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ya inalinay, “Immannung ay an ipa'amlong'u He\"a, Apo Dios, at He\"ay mi'yali ni' an ta\"on hi un ngumhay nan tatagun umunud ay He\"a! Ya aliwam ni' ahan di numbaholanmi, ya abuluton da'mi ni' hi tatagum!” ");
INSERT INTO ifb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ya inalin Apo Dios ay Moses di, “Ad ugwan ya mi'tulaga' ay he\"a ta ipattig'uh nan holag Israel nan umipanoh'a an ato' an mi'id ahan na'atanah tun luta. At an amin nan tatagun initnudmu ya tigonda nan nidugah an umipanoh'an atata'ot an ato' an hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","At mahapul an unudonyu nan imandal'un da'yud ugwan, at Ha\"in mahkay di okod an mamakak hinan himpampun an holag Amor, ya holag Heth, ya holag Periz, ya holag Hiv, ya nan iCanaan, ya nan iJebus hinan babluy an dumatnganyu. ");
INSERT INTO ifb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","At padana' da'yu ta emayaanyu ta adi ayu mi'tulag hinan tataguh nan lutan umayanyu ti atonyu ay at ini ya mabalbaliyan ayu. ");
INSERT INTO ifb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mu unyuat pumpa\"in amin nan pun'onnganda, ya nan dayawondan bulul an umat ay Asherah, ya nan udum an dayawonda. ");
INSERT INTO ifb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ya mahapul an mi'id ahan udum hi dios an dayawonyu ti Ha\"in an hi Apo Dios ya ma\"annela', at adi' ahan pohdon hi un waday udumnah dios an dayawonyu. ");
INSERT INTO ifb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ya emayaanyu ta adi ayu mi'tulag hinan tataguh nan babluy an umayanyu. Ti wa ay ta mundayawdah nan bulul ya onnganda ya umannung an ayagan da'yu ta me\"an ayun didah nan ene'nongdah nan bulul. ");
INSERT INTO ifb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ya adiyu abuluton nan imbabaluyyun linala'in mi'yahawah nan binabain den babluy ti ini ya al'alu'on nan binabai nan imbabaluyyun linala'i, ya niddumdan mi'dayaw hinan bululda. ");
INSERT INTO ifb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ya adi ayu munhibug hinan gumo' hi iyammayuh bululyu. ");
INSERT INTO ifb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ya nonomnomonyu ta adiyu aliwan an ibehtaan nan algaw an Adiyu Panganan hi Agguy Nabino'bo'an an Tinapay. An hiyah ne din intugun'un da'yu an hay ononyuh nan pituy algaw hinan bulan di Aviv ya nan agguy nabino'bo'an an tinapay. Ti hiyah ne gutud di bulan hi nakakanyud Egypt. ");
INSERT INTO ifb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ya an amin nan mahhun an lala'in mitungaw ya bagi', ya bagi' goh nan mahhun an i'lum nan baka, ya dongki, ya kalniluh un buta'al. ");
INSERT INTO ifb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ya huwalonyu nan mahhun an mitungaw an dongki ya nan uyaw an kalnilu, mu adiyu ay pohdon an huwalon ya genlotyu. Ya huwalonyuh animal an amin nan papangpangullun linala'in imbabaluyyu. Ya mi'id umalih nan wada' hi un mi'id iyalinah e'nongnan Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ya onom di algaw hi puntamuanyu. Ya nan miyapitun algaw ya mun'eblay ayun ta\"on hi un gutud di ahitamu unu gutud di boto'. ");
INSERT INTO ifb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ya gunyu ibehtaan di iwang an ma'alih Behtan di aDumiduminggu hi unyu ete\"an bot'on nan nahhun an enebgayyu. Ya ibehtaanyu goh di pamugahanyuh nan bungbungaan hinan angunuh di tawon. ");
INSERT INTO ifb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ya mahapul an mumpitluh ohay tawon di umalian an amin nan linala'in holag Israel ta dayawona' an hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ya pakako' nan tatagun nunhituh nan lutan heneggonyu ta ma'udman an dumamuna nan lutayu, ya mi'id ah mangubat ya mangipatna an mamloh hinan lutayuh nan mumpitlu an gunyu umalian an mundayaw ay Ha\"in hi hintawon. ");
INSERT INTO ifb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ya mun'onong ayu ay hi animal ay Ha\"in ya adiyu iddum nan nabino'bo'an an tinapay. Ya nan Behtan di Panginomnomanyuh Nangekaka' ay Da'yud Egypt ya mi'id ahan ma'angang hi mipatang ta nangamung hi helhelong. ");
INSERT INTO ifb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ya nan ma\"aphod an mahhun an bot'onyuh nan intanomyuh nan lutayuh hintawon ya mahapul an iyuyyuh nan Tuldan Abung'u an Dios an dayawonyu. Ya wa ay ta ihaangyu nan uyaw an gandeng ya adiyu pananum nan gatas an malpuh huhun inana.” ");
INSERT INTO ifb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ya inalin goh Apo Dios ay Moses di, “Itudo'mu hatu nan hapito' ti hiyay mangipa'innilah ni'tulaga' ay he\"a ya nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","At hi Moses ya ni'yi'ibbanah Apo Dios hi napat di algaw ya labi an agguy nangnangan ya immin'inum hi danum. Ya hi Apo Dios di nangitudo' hinan Himpulun Uldinah nan duwan mayapit an batu an hiyah ne nan Himpulun Uldina. ");
INSERT INTO ifb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ya unat goh nundadyuh Moses an nalpuh nan Duntug an Sinai an ino'odnana nan duwan mun'ayapit an batun nitud'an nan Himpulun Uldin ya agguyna inila an hay angahna ya humili ti han ni'hapitanan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ya unat goh tinnig Aaron ya nan holag Israel nan humilin angah Moses ya timma'otdan meheggon ay hiya. ");
INSERT INTO ifb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mu inayagan Moses dida. At hi Aaron ya nan a'ap'apun mangipapto' hinan holag Israel ya numbangngaddan hiya ta donglonda nan alyon Moses ay dida. ");
INSERT INTO ifb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ya unat goh wan neheggondan Moses ya imbaagnan dida an amin nan Uldin Apo Dios an din imbaganan hiyah din awadanah nan Duntug an Sinai. ");
INSERT INTO ifb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ya unat goh nalpah an ni'hapit hi Moses ay dida ya hinophopanay angahna, ");
INSERT INTO ifb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","mu wa ay ta humgop hinan Me'gonan an Kuwaltun Pi'dammuwan ta mi'hapit ay Apo Dios ya inaanay hophop di angahna ta engganay bumuhu' an umuy mangibaag hinan holag Israel hinan inalin Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ya tinnig nan holag Israel nan angah Moses an humili, ya hinophopana mah goh nan angahna ta awni ta nan umuyna pi'hapitan ay Apo Dios ya unna anon. ");
INSERT INTO ifb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ya impa'ayag Moses an amin nan holag Israel ta na'amungda, ya inalinan diday, “Hiyatuy Uldin Apo Dios hi immandalna an mahapul hi unudon tu'u. ");
INSERT INTO ifb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Muntamu tu'uh onom hi algaw, ya hay miyapitun algaw ya ngilinon tu'u ti hiyah ne me'gonan hi algaw Apo Dios hi pun'eblayan tu'u. At nan muntamun de han miyapitun algaw ya mahapul an mapatoy. ");
INSERT INTO ifb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ya mahapul an adi ayu mun'apuy hinan nunhituwanyuh nan ngilin an Habadu.” ");
INSERT INTO ifb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ya inalin goh Moses hinan holag Israel di, “Hiyah te goh di immandal Apo Dios: ");
INSERT INTO ifb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","An amin ayu ya mahapul an waday iyuyyuh e'nongyun Apo Dios. At nan way pamhodnan umidat ya idatnay e'nongna an balitu', ya silver, ya gambang, ");
INSERT INTO ifb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ya nan lo'ob an mumpugagaw, ya munggudla, ya mumbolah, ya nan napinuy abolna an linen, ya nan dutdut di gandeng an niyammah lo'ob, ");
INSERT INTO ifb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ya nan niyupol an up'up di buta'al an kalnilu, ya nan lalat di ma'alih dugong an nalpuh nan ma'alah baybay, ya nan ayiw an akasya, ");
INSERT INTO ifb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ya nan lanan olibon ma'usal hi hilaw, ya nan maphod di hunghungnan middum hinan niyammah lanan ma'usal hinan way midawat, ya nan ma\"aphod di hunghungnan incense, ");
INSERT INTO ifb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ya hay onyx an batu, ya nan udum an mapla'an an batun miyal'altih nan ephod an lubung di padi an mihophop hi palagpagna.” ");
INSERT INTO ifb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ya intuluy Moses an inalinay, “Ya an amin ayun waday la'engnan inilanan muntamu ya umali ayu ta tamuan tu'u nan immandal Apo Dios ");
INSERT INTO ifb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","hi aat nan Tuldan Abung an waday duwan kuwaltunah bunolna an nan Me'gonan an Kuwaltu ya nan Nidugah an Me'gonan an Kuwaltu, ya nan da'ligna, ya miyammay pana'ul, ya nan mibalangon, ya nan tu'udna, ya nan ipatlo'an di tu'ud. ");
INSERT INTO ifb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ya miyamma goh nan Kahon an Nittuwan di Uldin, ya nan attangna, ya nan alubna an awadan nan Ma'ahhimo', ya nan kultinan mibolda' ta adi mattig heden Kahon, ");
INSERT INTO ifb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ya nan lamehaan, ya nan alimatungna, ya nan attangna, ya nan tinapay an me'nong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ya miyamma goh nan ipattu'an di hilaw, ya nan alimatungna, ya nan panul, ya nan lanan mittuh nan panul ta humilaw. ");
INSERT INTO ifb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ya miyamma goh nan pun'onngan hinan panghoban hi incense, ya nan attangna, ya nan lanan ma'usal hinan way midawat, ya nan maphod di hunghungnan incense, ya nan kultinah nan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ya miyamma goh nan pun'onngan hinan moghob an me'nong an hay gambang di miyammah pangiyapuyan an nadala\"ang di ammana, ya nan attangna, ya an amin di alimatungna, ya nan pamahan an pun'ihuan, ya nan ipabunana. ");
INSERT INTO ifb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ya dida goh di mangiyammah kultinan nan nunlene'woh an luhud di Tuldan Abung, ya nan itayunan di kultina, ya nan tu'udna, ya nan ipabunan di tu'ud, ya nan kultinan di pantaw hinan luhud, ");
INSERT INTO ifb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ya nan palo' di Tuldan Abung, ya palo' di luhud, ya nan talin an go'od. ");
INSERT INTO ifb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ya miyamma nan lubung di papadi ta way ilubungdah unda humigup hi panamuandah nan ipatamun Apo Dios an nan me'gonan an lubung Aaron an Nabagtun Padi ya nan lubung nan linala'in imbabaluyna ta way ilubungdah nan panamuandah tamun di padi.” ");
INSERT INTO ifb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ya unat goh nalpah an dengngol nan holag Israel nan inalin Moses ya numpanga'anamutdah nan tuldada. ");
INSERT INTO ifb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ya an amin nan namhod an bumadang ya inyaliday gina'uh badangdan Apo Dios an nan miyammah Tuldan Abung, ya nan alimatungna, ya nan miyammah me'gonan an lubung di padi. ");
INSERT INTO ifb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ya an amin nan linala'i ya binabai ya nun'iyaliday numbino'ob'on an gina'uda an balitu' an umat hi hengheng, ya hingat, ya nan buung ta midat hi bagin Apo Dios ta hay balitu' di Milayat an Onong ay Hiya. ");
INSERT INTO ifb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ya nan waday mumbolah, ya mumpugagaw, ya gadyang an lo'ob, ya nan linen, ya nan lo'ob an nalpuh dutdut di gandeng, ya nan nipabolah an up'up di buta'al an kalnilu, ya nan lalat di ma'alih dugong an nalpuh nan ma'alah baybay ya nun'iyalida. ");
INSERT INTO ifb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ya nun'iyalida goh nan silver, ya nan gambang, ya nan ayiw an akasya ta midat an bagin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ya nan binabain nanginnilan mun'abol ya nun'iyaliday inaboldan mumpugagaw, ya gadyang, ya mumbolah, ya nan linen. ");
INSERT INTO ifb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ya nan binabain nanginnilan mun'abol ya inabulutda ta diday mangiyabol hinan dutdut di gandeng. ");
INSERT INTO ifb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ya nan a'ap'apu ya nun'iyaliday nun'anginan batun umat hi onyx ya nan udum an batu an nangina ta way nun'iyal'altidah nan lubung an ephod an hophop di palagpag nan Nabagtun Padi. ");
INSERT INTO ifb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ya nun'iyalida goh nan numbino'ob'on an maphod di hunghungnan middum hinan incense, ya nan lana an panilaw, ya nan lanan ma'usal hinan way midawat. ");
INSERT INTO ifb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","At an amin nan holag Israel an namhod an umidat ay Apo Dios ya nun'iyaliday mahapul hinan ipatamun Apo Dios ay Moses hi immandalnah aton nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ya inalin goh Moses hinan holag Israel di, “Hi Apo Dios ya pento'nah Bezalel an imbaluy Uri an han ap'apun Hur an holag Judah ");
INSERT INTO ifb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ta niyodol ay hiya nan Na'abuniyanan an Lennawa, at nala'eng hiya, ya nanginnila, ya abalinanan mangat hinan way ma'al'altian. ");
INSERT INTO ifb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ya nala'eng goh hiyan mun'al'altih nan miyamma an balitu', ya silver, ya nan gambang, ");
INSERT INTO ifb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ya abalinana goh an manabat hinan nanginan batu, ya nan ayiw, ya do'ol di udum hi inilanah tamu. ");
INSERT INTO ifb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ya indatan goh Apo Dios dida ay Oholiab an hina' Ahisamak an nalpuh holag Dan hi abalinandan muntudu ta itududah nan udumna nan inilada. ");
INSERT INTO ifb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ya indat Apo Dios di la'engdan mangat hinan numbino'ob'on an tamu an umat hinan mun'al'alti, ya nan munhibug hinan numbino'ob'on an miyamma, ya mun'abol hinan lo'ob an mumpugagaw, ya gadyang, ya mumbolah, ya nan linen, ya nan mumbolda. At nala'engdan munnomnom an mangat hinan numbino'ob'on an tamu.” ");
INSERT INTO ifb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ya intuluy Moses an inalinay, “At da Bezalel ay Oholiab ya nan udum an indatan Apo Dios hi abalinanda ya la'engdan manginnilan mun'amman amin hinan matamuan hinan Tuldan Abung ya diday mangiyammah nan imandal Apo Dios hi iyammada.” ");
INSERT INTO ifb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ya impa'ayag Moses da Bezalel, ya hi Oholiab, ya nan udum an indatan Apo Dios hi la'eng, ya nan udum an mamhod an bumadang hinan tamu ");
INSERT INTO ifb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ta indatnan dida nan numbino'ob'on an nun'iyuy nan holag Israel ta miyammah Tuldan Abung. Ya nan holag Israel ya innaynayundan gun mangidat ay Moses hi abigabigat hinan e'nongda an idatdah miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ya an amin din nun'ala'eng an muntamuh nan Tuldan Abung ya immuyda, ");
INSERT INTO ifb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ya inalidan Moses di, “Do'ol ahan di inyalin nan tatagu an mahawal hi miyammah nan imbagan Apo Dios hi ipatamuna!” ");
INSERT INTO ifb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","At pinaadan Moses an amin nan tatagun wah nan immapalanda ta idinongdan mun'idat hinan onongdan miyammah nan Tuldan Abung. At nan tatagu ya indinongdan gun mangiyuy hinan miyamma ");
INSERT INTO ifb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ti nan nun'iyuyda ya do'ol an mahawal hi miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ya wadaday nun'ala'eng an linala'i ay daden nangiyammah nan Tuldan Abung ta diday nangiyammah nan himpulun kultina, an hay inyammada ya nan napinuy abolnan lo'ob an mumpugagaw, ya gadyang, ya mumbolah, ya inyammada goh di nun'apaya'an an cherubim an maphod di ammana ta al'altina. ");
INSERT INTO ifb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ya an amin nan kultina ya napapaddung di lukuddan himpulu ta opat di yaldah inadu\"oyda, ya duway yaldah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ya nundada\"ugonda nan leman kultina ta na'ohha, ya umat goh hinay inatdah nan leman kultina. ");
INSERT INTO ifb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ya inyammaday munggudlan lo'ob hi punggo'dan an natalegonggong ta way pangeg'odan an miyammah nan pingit nan hinohhan nada\"ug an kultina, ya umat goh hinay na'at hidin miyadwan nada\"ug an kultina. ");
INSERT INTO ifb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ya nabongley punggo'dan di inyammada goh hinan nahhun an nada\"ug an kultina, ya nabongle goh di punggo'dan hinan pingit nan miyadwan nada\"ug an kultina, ya nunggogoppongonda nan punggo'dan. ");
INSERT INTO ifb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ya inyammada goh di nabonglen balitu' an kawit ta mikawit hinan punggo'dan ede han duwan haba' an kultina ta ma'ohha an miyammah Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ya iyammada goh di himpulu ta ohah kultina an nalpuh dutdut di gandeng ta miyammah atap nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ya napapaddungda an himpulu ta lemay yaldah inadu\"oyda, ya duway yaldah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ya nundada\"ugonda nan leman kultina ta ma'ohha, ya umat goh hinay inatdah nan onom an kultina. ");
INSERT INTO ifb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ya inyammada goh di nabonglen natalegonggong an punggo'dan hinan pingit di nada\"ug, ya nabongle goh hinan pingit nan miyadwan nada\"ug. ");
INSERT INTO ifb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ya inyammaday nabonglen kawit an gambang ta way pana\"it ta ma'ohhah miyatap. ");
INSERT INTO ifb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ya inyammada goh di migottap an miyatap hinan Tuldan Abung an nan up'up di buta'al an kalnilu an nakololan hi mumbolah, ya ginottapanda goh hinan lalat di ma'alih dugong an nalpuh nan na'alah baybay. ");
INSERT INTO ifb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ya inyammaday tabla an akasya ta way mida'lig hinan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ya an amin nan tabla ya himpulu ta lemay umpih inadu\"oyda, ya ba'inti ta pituy pulgadah inabellogda. ");
INSERT INTO ifb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ya nan ohan tabla ya inyammaday duwah numbattan hi natulidan hinan pingitna ta way mipahduh nan oha goh an tabla, ya ta way atondan madada\"it. Ya an amin nan tabla ya miyammay umat hina. ");
INSERT INTO ifb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ya ba'intiy tablah miyammah appit hi agwan hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ya silver di inyammadah napat an ipattu'an nan ba'intin tabla, at duway ipattu'an di ohan tabla ta duway natulidan hinan tablan mipado' hinan ipattu'ana. ");
INSERT INTO ifb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ya ba'intin tabla goh di miyammah inyammada ta mida'lig hi appit di iggid hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ya napat goh an silver di inyammadah ipabunanda an mahindudwah hinohhan tabla. ");
INSERT INTO ifb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ya onom hi tablay niyamma ta mida'lig hinan appit hi a'unugan di algaw, ");
INSERT INTO ifb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ya hindudway niyammah tablah nan duwan dugun nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","At nun'akkuponda nan duwan tabla ta hidih nan puun nan duwan tabla ya inhu'lubda nan mun'olog an natalegonggong ta way mangdon, ya umat goh hinay inatdah nan uddu'na. Ya hiyah ne goh di inatdah nan ohan duguna. ");
INSERT INTO ifb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ya waluy tablah inyammada, ya himpulu ta onom di ipabunanda an silver ta hindudway ipabunan di ohan tabla. ");
INSERT INTO ifb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ya inyammada goh di akasya an tabla ta way mibalangon, at lemay mibalangon hinan ohan haba' nan Tuldan Abung, ");
INSERT INTO ifb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ya lema goh di mibalangon hinan pangngelna, ya lema goh hi appit di alimuhan di algaw. ");
INSERT INTO ifb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ya nan mun'ibalangon ya mipahduh bangwahna ta nangamung unna da'puhon hi engganah nan pangngelna. ");
INSERT INTO ifb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ya inamyudandah balitu' nan tabla ya nan tablan nibalangon, ya hay balitu' di inyammadah pangihu'luban hinan mibalangon ta way mamdon. ");
INSERT INTO ifb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ya hay inyammadah kultina an holda' di kuwaltu ya nan napinun hinulid an mumpugagaw, ya gadyang, ya nan mumbolah di na'abol, ya naboldaan hi cherubim. ");
INSERT INTO ifb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ya inyammaday opat an tu'ud an akasya ta way mamdon hinan kultina, ya inamyudandah balitu'. Ya inyammaday opat an balitu' an pana'ul, ya nipatlo' hinan tu'ud. Ya nan silver di inyammadah ipabunan nan tu'ud. ");
INSERT INTO ifb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ya nan pantaw di Tuldan Abung ya inyammaday napinuy abolnan lo'ob an mumpugagaw, ya gadyang, ya mumbolah hi kultina, ya binolda'anda ta way mikultinah nan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ya inyammaday lemay tu'ud an waday pana'ulna ta mangdon hinan kultina, ya inamyudanday ngamngamnah balitu', ya umat goh hinan itayunan nan kultina. Ya nan ipabunanda ya nan gambang di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ya nan tablan akasyay inyamman Bezalel hi kahon an napat ta lemay pulgadah inadu\"oyna, ya ba'inti ta pituy pulgadah inabellogna, ya ba'inti ta pituy pulgadah inata'nangna. ");
INSERT INTO ifb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ya inamyudanah nan namahmah an balitu' di tu'yapna, ya balitu' goh di lehton nan kahon hinan nunliniblib, ya inaltianah ay bali an balitu' di nunlene'woh hinan kahon. ");
INSERT INTO ifb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ya nan namahmah an balitu' di hinibugnah opat an natalegonggong ta mepong hinan opat an dugun nan kahon, at mahindudway miyammah nan numpinangngel ta ipahduan di attang. ");
INSERT INTO ifb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ya nan tablan akasyay inyammana goh hi duwan attang, ya inamyudanah balitu', ");
INSERT INTO ifb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ya impahdunah nan nun'atalegonggong hinan numpinangngel an wah nan kahon ta pangiyattangan. ");
INSERT INTO ifb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ya hinibugda goh di namahmah an balitu' hi alubnan ihinan nan Ma'ahhimo' an napat ta han lemay pulgadah inadu\"oyna, ya ba'inti ta pituy pulgadah inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ya hinibugday balitu' ta inyammanay duwan anghel an cherubim, ");
INSERT INTO ifb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ya nipata'dog hinan numbinnongwah hinan alub di kahon. ");
INSERT INTO ifb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ya nan duwan anghel ya pinapayadday paya'da ta nahophopan nan alub di kahon an nunhahagganganda an mangu'uhdung hinan alub. ");
INSERT INTO ifb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ya nan tablan akasyay inyamman goh da Bezalel hi lamehaan an tulumpulu ta onom di pulgadah inadu\"oyna, ya himpulu ta waluy pulgadah inabellogna, ya ba'inti ta pituy pulgadah inata'nangna. ");
INSERT INTO ifb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ya inamyudandah namahmah an balitu', ya inaltiandah ay bali an balitu' di nunlene'woh nan lamehaan. ");
INSERT INTO ifb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ya inyammada goh di tuluy pulgadah inabellogna an balitu', ya nunlene'wohondah nan lamehaan ta al'altina, ya inammaanda goh hi balinah balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ya balitu' di hinibugdah opat an natalegonggong ta nipatlo' hinan opat an dugun nan lamehaan hinan awadan nan hu'ina. ");
INSERT INTO ifb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ya heden nun'atalegonggong an ipahduan di attang di lamehaan ya nan ampan di balina. ");
INSERT INTO ifb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ya nan akasyay inyammada goh hi attang nan lamehaan, ya inamyudandah balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ya nan namahmah an balitu' di inyammada goh hi gina'un nan lamehaan an nan duyu, ya iduh, ya nan alubda an hay balitu' di miyamma. ");
INSERT INTO ifb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ya hinibugda goh nan namahmah an balitu' ta inyammaday ipattu'an di hilaw an nihahalamung hinan ipabunana, ya nan odolna, ya nan ay hapangnan na'al'altian hi habhabung an ay malukung, ya agguy nabe'lag, ya nan na'abbe'lag. ");
INSERT INTO ifb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ya onom di niyammah hapangna ta hintutluy numpopotto' hinan numpinangngel an odolna. ");
INSERT INTO ifb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ya nan ohan hapang ya tuluy habhabung an natogwa' an umat hi habung nan almond, ya tulu goh di namahmah an natallundug, ya tulu goh di na'abbe'lag an habhabung. Ya an amin nan onom an hapang ya umat hinan amin di al'altida. ");
INSERT INTO ifb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ya nan odolnan nigagwa ya opat di malukung an ay habhabung, ya nan natallundug, ya nan nabe'lag an habhabung. ");
INSERT INTO ifb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ya nan na'imul an natallundug di nundittuman nan nahhun an hapang, ya umat goh hinay nundittuman nan duwan nunhappang. ");
INSERT INTO ifb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","At an amin nan al'altin nan ipattu'an di hilaw ya un nihahalamung nan namahmah an balitu' an nahibug. ");
INSERT INTO ifb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ya inyammada goh nan pitun punhilawan an nipattu', ya nan pangdop, ya nan daludu, ya nan pangittuwan hi dapul, ya ammunay namahmah an balitu' di inusalda. ");
INSERT INTO ifb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ya hay damot nan nahibug an namahmah an balitu' an niyammah ipattu'an di hilaw ya tulumpulu ta opat di kilu. ");
INSERT INTO ifb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ya nan akasyay inyammada goh hi pun'onngan ta panghoban hinan maphod di hunghungna an incense. Ya hay lukud di inadu\"oyna ya inabellogna ya numpapaddung an hinohha ya han godway umpi, ya hay lukud di inata'nangna ya tuluy umpi. Ya inyammada goh di opat an ha'gudna ta mahinohha nan opat an duguna. ");
INSERT INTO ifb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ya inamyudadah namahmah an balitu' nan tu'yapna, ya nan nunlene'woh, ya nan opat an ha'gudna. Ya inal'altiandah ay balih namahmah an balitu' nan nunlene'woh. ");
INSERT INTO ifb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ya hinibugda goh di duwah natalegonggong an pangipahduan hinan attang ta nahindudwah nan numbinnongwah an duguna an numpumpotto' an neheggon hi ampan nan balina ta way ipahduan di attangna. ");
INSERT INTO ifb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ya nan akasyay inyammadah attang, ya inamyudandah balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ya inyammada goh nan me'gonan an lanan milanah nan way midawat, ya nan namahmah an maphod di hunghungnan incense an umat hi aton nan nala'eng an mun'ammah bangbanglu. ");
INSERT INTO ifb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ya nan akasyay inyamman goh da Bezalel hi pun'onngan hinan Onong an Moghob. Ya hay lukudna ya numpapaddung an pitu ta han godwan umpiy inadu\"oyna, ya umat goh hinay inabellogna an opat ta han godway umpi, ya nan inata'nangna goh. ");
INSERT INTO ifb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ya nun'inayundan inyammay nun'atulidan hinan duguna, ya inamyudandah gambang nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ya inyammada goh di alimatung nan pun'onngan an nan duyu an ittuwan di dapul, ya nan daludun di dapul, ya nan malukung an duyu, ya nan nunhappang an tuwi', ya nan ittuwan di bala, ya an amin date ya gambang di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ya inyammada goh di holda' nan pun'onngan an hay nitutub an niha\"ad hinan bunol di pun'onngan an gambang di niyamma, ya nadala\"ang di ammana. ");
INSERT INTO ifb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ya enepongdan inyammah nan opat an duguna nan nahibug an nun'atalegonggong an gambang ta pangipahduan hinan attang. ");
INSERT INTO ifb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ya nan tablan akasyay inyammadah attang, ya inamyudandah gambang. ");
INSERT INTO ifb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ya impahduda nan attang an akasyah nan nun'atalegonggong an wah nan numpinangngel hinan pun'onngan. Nan pun'onngan ya hay ayiw di niyamma, ya nalu'angan di bunolna. ");
INSERT INTO ifb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ya hinibugda nan gambang ta niyammay pamahan ya nan ipabunana, ya henen hinibugda ya nalpuh nan daggal di binabain muntamuh nan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ya inyamman goh da Bezalel nan kultina ta luhud di gettaw nan Tuldan Abung, ya hay niyamma ya nan napinuy abolna an lo'ob. Ya hay mikultinah nan appit hi agwan hi un hagangon di buhu'an di algaw ya nabongley yaldah inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ya ba'intiy niyammah tu'udna, ya ba'inti goh di ipato'ana an gambang, ya nan kawit unu pana'ul hinan tu'ud ya nan pangipattu'an hinan nitayunan di kultinana ya silver. ");
INSERT INTO ifb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ya hidih appit hi agwan hi un hagangon di buhu'an di algaw ya hay niyammah kultina ya nabongley yalda, ya ba'intiy tu'udna, ya ba'inti goh di nipato'ana. Ya nan pana'ul hinan tu'ud ya nan pangipattu'an hinan nitayunan di kultina ya silver. ");
INSERT INTO ifb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ya hay kultinan di appit hi alimuhan di algaw ya ba'inti ta lemay yaldah inadu\"oyna, ya waday himpuluh tu'udna, ya nan ipatlo'ana ya nepong di pana'ul an silver hinan tu'udna. Ya nan pana'ul unu kawit ya nan pangipattu'an hinan nitayunan nan kultina ya silver goh di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ya nan appit di buhu'an di algaw an pantawna ya hay lukud di mikultina ya ba'inti ta lemay yaldah inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","At hay kultinan di pangngelna ya pitu ya han godway yalda, ya tuluy tu'udna, ya tulu goh di ipatlo'ana. ");
INSERT INTO ifb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ya pitu ta han godway yaldah inadu\"oy di kultinah nan nundinammang, ya hintutlu goh nan tu'udda, ya hintutulu goh nan ipatlo'anda. ");
INSERT INTO ifb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","At an amin nan kultinah nan nunlene'woh den gettaw ya nan napinuy abolnay niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ya nan ipatlo'an di tu'ud ya gambang di niyamma, ya nan pana'ul an itayunan di kultina ya nan punggo'dan hinan ngamngam di tu'ud ya na'amyudan hi silver. Ya an amin nan tu'ud hinan nunlene'woh ya nahogwod hinan kablin silver di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ya hay kultinan nan pantaw di gettaw ya nan napinuy abolnan lo'ob, ya naboldaan hinan mumpugagaw, ya gadyang, ya mumbolah an hinulid. Ya hay inadu\"oyna ya himpuluy yalda, ya duwa ta han godway yaldan di inata'nangna an mipaddung hinan kultinan niluhud. ");
INSERT INTO ifb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ya opat di tu'ud ya opat goh nan ipatlo'anda an hay gambang di niyamma. Ya nan pana'ul ya nan puntayunan hi ngamngam nan tu'ud ya hay silver di niyamma, ya nan itayunanda ya silver goh. ");
INSERT INTO ifb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ya an amin nan o\"ongol an lanhan nan nunlene'woh hinan luhud ya gambang di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ya hiyah ten amin di na'yapan di niyammah nan Tuldan Abung an nihinan nan Uldin Apo Dios an immandal Moses ta itudo' nan holag Levi an impangpangulun Ithamar an imbaluy Aaron an padi. ");
INSERT INTO ifb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Hi Bezalel an imbaluy Uri an ap'apun Hur an nalpuh holag Judah ya inatnan amin nan immandal Apo Dios ay Moses hi ma'at. ");
INSERT INTO ifb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ya nan bimmadang ay hiya ya hi Oholiab an imbaluy Ahisamak an nalpuh holag Dan an nala'eng an mumpa'ot, ya mun'al'alti, ya mangiboldah nan hinulid an mumpugagaw, ya gadyang, ya mumbolah ya napinun hinulid.) ");
INSERT INTO ifb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ya an amin nan balitu' an nidat ay Apo Dios an niyammah nan Tuldan Abung ta Milayat an Onong ya hinlibu ta han opat di kiluh damotna an nikiluh nan kiluan hinan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ya hay damot nan silver an inamung nan tataguh din na'yapan nan tatagun holag Israel ya nikiluh nan kiluan hinan Tuldan Abung ya tuluy libu ya han opat di gahut ta han tulumpuluy kilu. ");
INSERT INTO ifb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ya hay bayad di ohay taguh din nangyapandah nan linala'in mete\"ah ba'intiy tawona ta han nahuluk ya onom di gramos an nikiluh nan kiluan hinan Tuldan Abung, ya onom di gahut ta han tuluy libu ya han lemay gahut ta nabongley bilangdan amin. ");
INSERT INTO ifb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ya tuluy libu ya han nabonglen kilun silver di niyammah ipatlo'an nan tu'ud di Tuldan Abung ya nan tu'ud di itayunan di kultina. Ya hinggahut di niyammah ipatlo'an di tu'ud, at hay ohan tu'ud ya tulumpulu ta pitu ya han godway kilu di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ya nan na'angang an silver an tulumpuluy kilu ya inyaman da Bezalel hi pana'ul, ya nan itayunan di kultina, ya inyamyuddah nan ngamngam di tu'ud. ");
INSERT INTO ifb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ya an amin nan gambang an nidawat ay Apo Dios hi Milayat an Onong ya duway libu ta han opat di gahut ya han ba'inti ta lemay kiluh damotna. ");
INSERT INTO ifb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","At hiyah ne inyammanah nan ipatlo'an nan tu'ud di pantaw nan Tuldan Abung, ya nan gambang an pun'onngan, ya nan holda' nan nibalangon, ya an amin nan alimatung nan pun'onngan, ");
INSERT INTO ifb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ya nan ipatlo'an an amin nan tu'ud di luhud hinan nunlene'woh, ya nan tu'ud di pantaw, ya an amin nan palo' nan kabli an namdon hi tu'ud nan nunlene'woh an luhud di gettaw nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ya nan mumpugagaw, ya gadyang, ya mumbolah an lo'ob di inyammadah lubung ta hiyay ilubung nan muntamuh nan Tuldan Abung. Ya inyammada goh nan me'gonan ta lubung Aaron ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ya inyammada goh di ephod an hay inyammada ya nan balitu', ya nan lo'ob an mumpugagaw, ya gadyang, ya mumbolah, ya nan napinun lo'ob an linen. ");
INSERT INTO ifb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ya hinibugda nan balitu' ta pinitpitda ta ma'adyapit, ya kinaltibda ta napinu an umat hi hinulid an linen, ya maphod di inatdan nangiyamma. ");
INSERT INTO ifb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ya waday duwah inyammadah go'odna ta way mihi'gut hinan potto' di pu'ol. ");
INSERT INTO ifb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ya nan mibalikis hinan ephod ya maphod goh di na'ablana an mipaddung hinan ephod di na'abol ti hiyah ne immandal Moses hi atonda. ");
INSERT INTO ifb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ya nun'ipatlo'da nan batu an onyx hinan balitu', ya inhelhelda nan ngadan nan himpulu ta duwan imbabaluy Israel ");
INSERT INTO ifb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ta miyammah nan bagtun di balikis hinan way palagpag, ya eneg'oddah nan go'od nan pu'ol di ephod ta mangipanomnom hinan himpulu ta duwan tribon Israel, ya hiyah ne immandal Apo Dios hi atonda. ");
INSERT INTO ifb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ya inyammaday hophop di palagpag an maphod di tigawna an umat hinan ephod di niyabol an niyamma an nan hinulid an balitu', ya nan mumpugagaw, ya nan mumbolah, ya nan munggudla, ya nan gadyang di niyamma. ");
INSERT INTO ifb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ya nakupin an hay lukudna ya numpaddung an hiyam di pulgadah inadu\"oyna ya inabellogna. ");
INSERT INTO ifb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ya nun'ipatlo'da nan nanginan batu ta opat an linya. Ya hay hopap di linya ya ruby, ya topaz, ya un nan beryl, ");
INSERT INTO ifb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ya nan miyadwan linya ya turquoise, ya sapphire, ya emerald, ");
INSERT INTO ifb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ya nan miyatlun linya ya jacinth, ya agate, ya amethyst, ");
INSERT INTO ifb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ya nan miyapat an linya ya chrysolite, ya onyx, ya jasper. Ya an amin hanan batu ya mun'ipatlo' hinan balitu'. ");
INSERT INTO ifb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ya hanan himpulu ta han duwan batu ya nihelhel nan ngadan nan hinohhan himpulu ta duwan imbabaluy Jacob ta mangipa'innilah nan himpulu ta duwan holagna. ");
INSERT INTO ifb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ya inyammaday namahmah hi balitu' an umat hi nalulug an buung ta go'od nan hophop di palagpag. ");
INSERT INTO ifb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ya inyammada goh di balitu' hi pangipatlo'an, ya nan duwan hengheng an balitu' ta punggo'dan hinan way dugun nan hophop di palagpag an neheggon hi way pu'ol. ");
INSERT INTO ifb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ya eneg'odda nan duwan umat hi nalulug an buung hinan duwan hengheng hinan way dugun nan hophop di palagpag an neheggon hi pu'ol. ");
INSERT INTO ifb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ya impatlo'da nan bangwah nan kawit hinan way neheggon hi pu'ol nan ephod hinan hinagangna. ");
INSERT INTO ifb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ya inyammaday duwa goh hi balitu' an punggo'dan, ya inhinadah nan duwan nangngampan dugun nan hophop di palagpag hinan way go'od di pu'ol an nihagang hinan ephod an bagtun di balikis. ");
INSERT INTO ifb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ya inyammada goh di balitu' hi duwah punggo'dan ta inyammadan den go'od di pu'ol nan lubung an ephod hinan nihagang an bagtun nan balikis. ");
INSERT INTO ifb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ya nan mumpugagaw ya eneg'oddah nan hengheng di hophop di palagpag ya hinan hengheng di ephod ta mida\"op hi nahamad, ya meg'od goh hinan balikis ta nan hophop di palagpag ya adi mayay hinan ephod. At inatdan amin nan immandal Apo Dios ay Moses hi atonda. ");
INSERT INTO ifb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ya nan lubung an mundalinat hinan ephod ya hay niyamma ya nan namahmah an mumpugagaw. ");
INSERT INTO ifb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ya niyammay ihu'luban di ulu, ya niyadyugu nan pingitna ta adi mahekhek. ");
INSERT INTO ifb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ya nan lupit di lubung ya natayunan hi umat hi bungan di ayiw an pomegranate an hay niyamma ya nan munggudla, ya mumpugagaw, ya mumbolah, ya nan linen, ya natayunan hi balitu' an kengkeng nan numpumbattananda. ");
INSERT INTO ifb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ya inyammaday namahmah an balitu' hi kengkeng ta way nibetabeta' hinan umat hi bungan di ayiw an pomegranates hinan lupit di lubung. ");
INSERT INTO ifb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","At nibetabeta' nan kengkeng hinan umat hi bungan di promegranate hinan nunlene'woh hinan lupit di lubung di padi an ilubungdah unda itamuan hi Apo Dios ti hiyah ne immandalnan Moses. ");
INSERT INTO ifb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ya inyammada goh nan napinun nilubid an linen hi magayad ya adu\"oy di ngamayna an lubung da Aaron ya nan linala'in imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ya linen goh di niyammah nan uklupda an turban, ya headband, ya nan putut an pantalonda. ");
INSERT INTO ifb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ya nan linen goh di niyammah balikisda an nan mumpugagaw, ya gadyang, ya mumbolah di nibolda an hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ya inyammada nan namahmah an balitu' hinan mepngot, ya inhelhelda nan hapit an alyonay, MEꞋGONAN HI APO DIOS. ");
INSERT INTO ifb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ya enepngotda nan munggudlan lo'ob ta nihamad an nipaut hinan turban an uklup. Hiyah ne immandal Apo Dios ay Moses hi ma'at. ");
INSERT INTO ifb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","At an amin nan tamun nan Tuldan Abung ya nalpah ti inatdan amin nan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","At inyuydan amin ay Moses nan niyammah nan Tuldan Abung ya nan alimatungna an umat hinan da'lig, ya pana'ul, ya nan mibalangon, ya nan tu'ud, ya nan ipatlo'an di tu'ud, ");
INSERT INTO ifb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ya nan miyatap an up'up di buta'al an kalnilu an mumbolah, ya nan lalat di ma'alih dugong an up'up, ya nan kultina, ");
INSERT INTO ifb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ya nan Kahon an Nittuwan di Himpulun Uldin, ya nan akasyan attang, ya nan alub di Kahon an ihinan nan Ma'ahhimo', ");
INSERT INTO ifb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ya nan lamehaan, ya an amin di alimatungna, ya nan tinapay an ne'nong ay Apo Dios, ");
INSERT INTO ifb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ya nan namahmah an balitu' an ipattu'an di hilaw, ya nan hilaw, ya an amin nan alimatungna, ya nan lanan panilaw, ");
INSERT INTO ifb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ya nan balitu' an pun'onngan, ya nan lanan ma'usal hinan way midawat, ya nan ma\"aphod di hunghungna an incense, ya nan kultinan di pantaw nan Tuldan Abung, ");
INSERT INTO ifb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ya nan gambang an pun'onngan, ya nan natalaggang an pun'apuyan, ya nan attangna, ya an amin nan alimatungna, ya nan pamahan, ya nan ipabunana, ");
INSERT INTO ifb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ya nan kultinan di luhud, ya nan tu'ud, ya nan ipatlo'anda, ya nan kultinan di pantaw di luhud, ya nan talin an hogwod, ya nan palo', ya an amin nan gina'un ma'usal hinan Tuldan Abung an a'amungan nan tatagu, ");
INSERT INTO ifb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ya nan ma\"aphod an igina'un di padih nan pangatandah tamudah nan Tuldan Abung, ya nan me'gonan an lubung Aaron an Nabagtun Padi, ya nan lubung nan linala'in imbabaluyna an mangitamuh tamun di padi. ");
INSERT INTO ifb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ya didan holag Israel ya intamudan amin nan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ya hi Moses ya hinamadnan amin nan inatda, ya tinnignan inunuddan inat an amin nan immandal Apo Dios hi atonda. At hi Moses ya winagahana. ");
INSERT INTO ifb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Nan hopap di algaw hinan hopap di bulan ya hiyah ne gutud di pangiyammanyuh nan Tuldan Abung an a'amungan nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ya inhinam hidi nan Kahon an Nittuwan di Uldin, ya inyammam di kultinah nan hinagangna. ");
INSERT INTO ifb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ya ehgopmu nan lamehaan, ya nun'ipattu'mun panuhon nan gina'una. Ya ehgopmu goh nan ipattu'an di hilaw, ya tinolgam nan hilaw. ");
INSERT INTO ifb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ya inhinam nan balitu' an pun'onngan hi panghoban hinan incense hinan way hinagang di Kahon, ya kinultinaam nan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ya inhinam nan pun'onngan hi moghob hinan hinagang di pantaw di Me'gonan an Kuwaltu an a'amungan nan tatagu, ");
INSERT INTO ifb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ya inhinam nan pamahan hinan numbattanan nan Me'gonan an Kuwaltu an a'amungan nan tatagu ya nan pun'onngan, ya inittuwam hi danum. ");
INSERT INTO ifb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ya iyammam nan kultinan luhud hi nunlene'woh, ya kinultinaam nan pantaw di luhud. ");
INSERT INTO ifb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ya alam nan lanan ma'usal hinan midawat ay Apo Dios ta iwalhim hinan Tuldan Abung ya an amin nan wadah di an alimatungna ta idawatmu ta me'gonan. ");
INSERT INTO ifb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ya hiitam goh hi lana nan pun'onngan hi moghob ya an amin nan alimatungna, ya indawatmu ta nidugah an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ya hiitam goh hi lana nan pamahan ya nan ipabunana, ya indawatmu goh. ");
INSERT INTO ifb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ya inyalim da Aaron ya nan linala'in imbabaluynah nan way pantaw di Tuldan Abung an a'amungan nan tatagu ta ihuam dida. ");
INSERT INTO ifb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ya nunlubungom hi Aaron hinan me'gonan an lubung, ya hiitam hi lana, ya indawatmu ta midat di haadnan mumpadi ta Ha\"in di itamuana. ");
INSERT INTO ifb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ya iyalim goh nan linala'in imbabaluyna, ya nunlubungom didah nan lubung di padi, ");
INSERT INTO ifb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ya hiitam didah lana, ya indawatmu dida an umat hi inatmun amada ta midat di haaddan mumpadi, ta Ha\"in itamuandah engganah nan holagda.” ");
INSERT INTO ifb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","At hi Moses ya inatnan amin nan immandal Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ya nan hopap di algaw hinan hopap di bulan hinan miyadwan tawon hi nalpahan di nakakandad Egypt ya nalpah an nipata'dog nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ya heden nangipata'dogan Moses eden Tuldan Abung ya nun'iyammana nan ipattu'ana, ya nan ipabunana, ya inhu'lubna nan tabla, ya binalangnana, ya hina\"adna nan tu'ud. ");
INSERT INTO ifb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ya bene'lagna nan lo'ob, ya inyatapnah nan duwan kuwaltu an nan Me'gonan an Kuwaltu ya nan Nidugah an Me'gonan an Kuwaltu. Ya inggottapna nan udumna an inyatap ta way muntu'yap an hiyah ne din immandal Apo Dios hi atona. ");
INSERT INTO ifb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ya innalna nan duwan batun nitud'an nan Himpulun Uldin, ya inittunah nan Kahon, ya impahduna nan attang hinan ingan di Kahon, ya inalubanah nan alub an ihinan nan Ma'ahhimo'. ");
INSERT INTO ifb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ya inhigupna nan Kahon hinan Nidugah an Me'gonan an Kuwaltu, ya kinultinaana ta haniana nan Kahon an Nittuwan di Himpulun Uldin an hiyah ne immandal Apo Dios ay hiyah atona. ");
INSERT INTO ifb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ya inhinan goh Moses nan lamehaan hinan Me'gonan an Kuwaltuh appit hi iggid hi un hagangon di buhu'an di algaw hinan pangngel nan niholda' an kultina. ");
INSERT INTO ifb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ya impattu'na nan tinapay an ne'nong ay Apo Dios hinan lamehaan an hiyah ne immandal Apo Dios ay hiyah atona. ");
INSERT INTO ifb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ya inhinana nan ipattu'an di hilaw hidi goh hinan appit hi agwan hi un hagangon di buhu'an di algaw an potto' di lamehaan. ");
INSERT INTO ifb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ya tinolgana nan hilaw hinan awadan Apo Dios an hiyah ne immandal Apo Dios ay hiyah atona. ");
INSERT INTO ifb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ya inhinan Moses nan balitu' an pun'onngan hinan way hinagang di kultina, ");
INSERT INTO ifb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ya inyapuyana nan maphod di hunghungna an incense an hiyah ne immandal Apo Dios ay hiyah atona. ");
INSERT INTO ifb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ya intayuna nan kultinah nan pantaw di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ya inhinana nan pun'onngan hi moghob hinan way pantaw di Tuldan Abung, ya ene'nongna nan Onong an Moghob ya Onong an Ma'an an hiyah ne din immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ya inhinana nan pamahan hinan numbattanan di pantaw di a'amungan nan tataguh nan pun'onngan, ya inittuwanah danum, ");
INSERT INTO ifb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","at hi Moses, ya hi Aaron, ya nan linala'in imbabaluyna ya nun'ihudah ngamayda ya hu'ida. ");
INSERT INTO ifb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ya wa ay ta humigupdah nan way Tuldan Abung an a'amungan nan tatagu unu umuydah nan pun'onngan ya mahapul an mun'ihuda ti hiyah ne immandal Apo Dios hi atonda. ");
INSERT INTO ifb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","At enelpah Moses an inyamma nan kultinan di luhud hinan nunlene'woh hinan Tuldan Abung an awadan di pun'onngan, ya kinultinaana nan pantaw di luhud. At lempah Moses nan tamuna. ");
INSERT INTO ifb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ya hin'alina ya hino'napan nan bunut hinan Tuldan Abung, ya nipattig nan humili an benang Apo Dios hidi. ");
INSERT INTO ifb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ya mi'id inat Moses an hinumgop ti nun'olog nan benang Apo Dios hidi. ");
INSERT INTO ifb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ya wa ay ta tumulu nan bunut an niho'nap hinan Tuldan Abung ya numbotan nan holag Israel an inta'inda nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ya wa ay ta adi tumulu nan bunut ya adi goh mumbotan danen holag Israel ta nangamung hi un tumulu nan bunut. ");
INSERT INTO ifb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ya an amin nan gun pumbotanan nan holag Israel ya gunda tigon nan bunut an miho'nap hinan Tuldan Abung hinan mapatal, ya bumnang hinan mahdom.");
INSERT INTO ifb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ya inayagan Apo Dios hi Moses an hidih nan Tuldan Abung di himmapitanan inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Gulat ta waday oha ay da'yuh mamhod an mangiyalih onongna ta e'nongnan Apo Dios ya hay iyalina ya ohah nan baka, unu nan kalnilu, unu gandeng.” ");
INSERT INTO ifb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ya inalina goh di, “Ya gulat ta e'nongnay Onong an Moghob ya mahapul an nan manilhig an bakan mi'id ah ganitna. Ya hiyay okod an mange'nong hinan way pantaw nan Me'gonan an Kuwaltu an a'amungan an awadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Hay atona ya eh'anah nan ulun di bakan Onong an Moghob, at ma'abulut henen e'nongna ta way a'aliwan di baholna. ");
INSERT INTO ifb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ya geneto'na nan uyaw an manilhig hinan way hinagang di wadan Apo Dios. Ya nan papadin imbabaluy Aaron di okod an mangiyuy hinan dala ta iwalhidah nan nunlene'woh di pun'onngan an wah nan hinagang di pantaw nan Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ya lalatona nan up'up di ne'nong, ya numpuhitna. ");
INSERT INTO ifb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","At nan papadin imbabaluy Aaron ya pinanuhda nan ayiw hinan pun'onngan, ya inapuyanda ta gumaba nan apuy. ");
INSERT INTO ifb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ya pinanuhdan ipulu' nan naphit an dotag an nan ulu ya tabah nan tu'yap di nitungu an ayiw hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Mu nan numbino'ob'on an minalutu ya nan hu'i ya ipaphod nan nange'nong an ulahan ya un alan nan padi ta pun'ipulu'nan amin hinan pun'onngan ta Onong an Moghob an mipulu' hinan apuy ta magbu ta nan maphod an hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ya gulat ta hay e'nongna ya hay kalnilu unu gandeng ta Onong an Moghob ya mahapul an nan buta'al an mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ya goltonah nan way delloh di pun'onngan ay Apo Dios hi appit hi iggid hi un hagangon di buhu'an di algaw hi awadan Apo Dios. At alan nan papadin imbabaluy Aaron nan dala ta iwalhidah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ya pumpuhitna an middum nan ulu ya taba ta alan nan padi, ya pinanuhnan pun'iyuhun an amin nan naphit an dotag hinan gimmaban niyapuy hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mu mahapul an daluhana nan minalutu, ya inulahana goh nan hu'i ya un alan nan padi ta gohbonah nan pun'onngan. Ti hiyah ne onong an nipulu' hi apuy ta moghob ta nan maphod an hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ya gulat ta han tagu ya nan hamutiy e'nongnan Apo Dios hi Onong an Moghob ya mahapul an nan balug unu nan bunun an putta di iyalina, ");
INSERT INTO ifb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ya alan nan padi nan me'nong, ya inyuynah nan pun'onngan, ya entelonay bagangna, ya impulu'nah nan pun'onngan ta moghob. Ya enepto'nan itidtid nan dalah nan bane'leng nan pun'onngan ta nangamung un matidtidan. ");
INSERT INTO ifb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ya anona nan bintuulna ya dutdutna, ya impa'wahnah nan pangngel di pun'onngan hinan appit hi buhu'an di algaw an nan puntapalan hinan dapul. ");
INSERT INTO ifb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ya hinokwa'na nan paya'na an agguyna nunhiyanon. Ya ipulu' nan padih nan gimmaban nitungun ayiw hinan pun'onngan. Hiyah ne Onong an Moghob an mipulu' hi apuy ta magbu ya nan maphod an hunghungnay mangipa'amlong ay Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ya inalin goh Apo Dios ay Moses di, “Ya wada ay di mangiyalih nan Onong an Ma'an hi e'nongnan Ha\"in an Dios ya nan ma\"aphod an alenay e'nongna, ya udmanah mantika ya nan incense. ");
INSERT INTO ifb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ya inyuynah nan papadin imbabaluy Aaron, ya oha ay diday ummal hi hinggamal hinan alena, ya itang an mantika, ya itang goh hinan incense, ya genhobnah de ta panginomnoman hinan pun'onngan ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ya nan na'angang hinan Onong an Ma'an ya bagin da Aaron ya nan linala'in imbabaluyna, ya me'gonan ahan hene ti uddum nan ne'nong ay Ha\"in an nipulu' hinan apuy.” ");
INSERT INTO ifb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ya inalin goh Apo Dios di, “Ya gulat ta waday mangiyalih e'nongnah ma'an an nan tinapay an agguy nabino'bo'an an nihaang ya mahapul an nan ma'adyamu' an alenay mihaang an namantikaan unu nan mayapit an tinapay an na'amyudan hi mantika, ya mi'id goh di bino'bo'na. ");
INSERT INTO ifb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ya gulat ta nan ma'an an e'nongyu ya hay kawaliy ihaangana ya hay miyamma ya nan ma'adyamu' an alena, ya malamutan hi mantika, ya mi'id di bino'bo'na. ");
INSERT INTO ifb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ya puhitonyu, ya hiniitanyuh mantika ta hiyah ne Onong an Ma'an. ");
INSERT INTO ifb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ya gulat ta hay e'nongyu ya nan ma'an an nihaang hinan kawali ya hay miyamma ya nan ma'adyamu' an alena, ya mamantikaan. ");
INSERT INTO ifb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ya iyuyyu nan Onong an Ma'an an umat hi ohan danen nihaang ta me'nong ay Ha\"in an Dios, ya idatyuh nan padi ta hiyay mangiyuy hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ya umala nan padih itang hinan ma'an an me'nong ta way panginomnoman, ya genhobnah nan pun'onngan ta Onong an Moghob an nipulu' hinan apuy ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ya nan ma'angang hinan Onong an Ma'an ya bagin da Aaron ya nan linala'in imbabaluyna. Ya me'gonan ahan henen onong an me'nong ay Ha\"in an Dios an nipulu' hinan apuy. ");
INSERT INTO ifb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ya an amin nan iyaliyu an Onong an Ma'an ay Ha\"in ya mahapul an hay agguy nabino'bo'an ti adi mabalin hi unyu gohbon nan waday bino'bo'na unu nan ma'udman hi alig. ");
INSERT INTO ifb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ya nan onongyu an malpuh nan hopap di bungan nan mihabal ya e'nongyun Ha\"in an Dios, mu adiyu ahan gohbon hinan pun'onngan ta ipahunghungyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ya an amin nan Onong an Ma'an ya ahinanyu, ya adiyu ahan ibahhaw an mangahin. Ti henen ahin ya hiyay mangipanomnom hinan ni'tulaganyun Ha\"in an Dios, at mahapul an amin di e'nongyu ta Onong an Ma'an ya ahinanyu. ");
INSERT INTO ifb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ya gulat ta iyaliyuy ma'an hi e'nongyun Ha\"in an nan hopap di bungan nan inhabalyu ya hay e'nongyu ya mahapul an nan pa\"ala an gahhilang, ya nahanglag, ya nabayu. ");
INSERT INTO ifb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ya mantikaanyu, ya udmanyu goh hinan incense ti hiyah te aat di Onong an Ma'an. ");
INSERT INTO ifb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ya umala nan padih itang hinan ma'an an nahanglag ta panginomnoman, ya gohbona an e'nong ay Ha\"in an Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ya inalin goh Apo Dios di, “Ya gulat ta han tagu ya hay baka di iyalina hi Onong di Pi'lenggopana ya hay bulug unu obay an mi'id ah ganitna di e'nongnan Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ya eh'anah ulun nan e'nongna, ya geneto'nah nan way pantaw di Me'gonan an Kuwaltun a'amungan. Ya alan nan imbabaluy Aaron an papadi nan dala ta iwalhidah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ya alan nan ad onong nan Onong di Pi'lenggopan ay Ha\"in nan taban niyunanit hinan putu ta moghob an me'nong ay Ha\"in an Dios ta Onong an Mipulu' hinan apuy. ");
INSERT INTO ifb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Ya iddumda goh an anon nan duwan batin an middum nan tabana, ya nan taban di inawa', ya nan taban niyunanit hi oltay. ");
INSERT INTO ifb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ya nan papadin imbabaluy Aaron di manghob hinan way pun'onngan an pun'iyuhundah nan Onong an Moghob an miyu'uhun hinan gimmagaban bala ta Onong an Mipulu' hi apuy ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ya gulat ta waday mangiyalih kalniluh Onong di Pi'lenggopan ay Ha\"in ya hay iyalina ya buta'al unu tenna an kalnilun mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ya gulat ta hay kalniluy iyalinah onongna ya hiyay mange'nong hinan awada' an Dios, ");
INSERT INTO ifb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","at ho\"onay ulun nan e'nongna, ya genlotnah nan way Me'gonan an Kuwaltun a'amungan. Ya nan linala'in imbabaluy Aaron di mangiwalhih nan dalah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ya alana nan tabana, ya nan taban di iwit an mehedpol hinan taligtigna, ya nan taban nanophop hinan putu, ya nan taban di putun nan Onong di Pi'lenggopan ta Onong an Mipulu' hinan apuy ta me'nong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ya nan duwan batin an middum di tabada, ya nan taban di inawa', ya nan taban niyunanit hi oltay ya ma'aan hanan taba ta middum hinan batin. ");
INSERT INTO ifb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","At alan nan padi ta gohbonah nan pun'onngan. Hene ya ma'an an mipulu' hinan apuy ta me'nong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ya gulat ta hay onongna ya gandeng di iyalina ya e'nongnah nan awada' an Dios, ");
INSERT INTO ifb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ya ho\"onay ulun nan e'nongna, ya genlotnah nan way hinagang di Me'gonan an Kuwaltun a'amungan, ya nan linala'in imbabaluy Aaron di mangiwalhih nan dalah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ya alana nan taban niyunanit hinan putu, ya hiyay mange'nong hinan Onong an Mipulu' hinan apuy ta me'nong ay Ha\"in an Dios, ");
INSERT INTO ifb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ya nan duwan batin an middum di tabada, ya nan taban di inawa', ya nan taban niyunanit hinan oltay, ya hanan taba ya ma'aan an middum hinan batin. ");
INSERT INTO ifb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ya alan nan padi ta gohbonah nan pun'onngan. An hene ya ma'an an mipulu' hinan apuy ta maphod hi mahunghung ti an amin nan taba ya bagi' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","At mahapul an adiyu ahan ihday taba unu dala. Ti hiyah te uldin an adi mapogpog ta minaynayun hi unudon nan holagyuh nan pi'hituwanyu.” ");
INSERT INTO ifb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Alyom hinan holag Israel di, Hiyatuy ma'at hinan ohan tagu mu agguyna inamtan an nangat hinan immandal'u an Dios hi adi ma'at, ya imbahhawnay oha: ");
INSERT INTO ifb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Gulat ta nan Nabagtun Padiy mumbahol ta omod hi un lummuh pumbaholan nan tatagu ya mahapul an iyalinay Onong di Baholna an hay manilhig an bakan mi'id ah ganitna ta Onong di Baholnan Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ya iyalinah nan way pantaw di Me'gonan an Kuwaltun a'amungan. Ya ho\"onay ulun nan baka, ya geneto'nah nan awada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ya alan nan Nabagtun Padi nan dalan nan baka, ya inyuynah nan Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ya ihiwhiwnay galaygaynah nan dala, ya inwalhinah mumpapituh nan hinagang di awada' an Dios ya nan kultinan nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ya ilamuhnay udum an dalah nan ha'gud di pun'onngan hinan incense an maphod di hunghungna an wah nan Me'gonan an Kuwaltun awada' an Dios. Ya nan udum an dala ya ihiitnah nan puun di pun'onngan hinan Onong an Moghob an wah nan hinagang din pantaw nan Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ya heden baka an Onong di Bahol ya nan taban niyunanit hinan putu ya anonan amin, ");
INSERT INTO ifb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ya nan duwan batin an middum di tabada, ya nan taban di inawa', ya nan taban niyunanit hinan oltay ta hanan taba ya ma'aan an middum hinan duwan batin. ");
INSERT INTO ifb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ya danen na'aan hinan baka an Onong di Pi'lenggopan di alan nan padi ta gohbonah nan pun'onngan ta Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mu nan up'up nan baka, ya nan lamohna, ya nan uluna, ya nan hu'ina, ya nan minalutuna, ya nan galutna, ");
INSERT INTO ifb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ya an amin nan alimatung nan bakan na'angang hinan Onong an Moghob ya ekaknah nan nungkampuanda ta iyuynah nan mibilang hi maleneh an lugal hinan puntaptapalandah dapul, ya nun'iyuhunah nan ayiw an gimmaba ta moghob. ");
INSERT INTO ifb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ya gulat ta an amin nan holag Israel ya numbahol ti inatda nan immandal'un Dios hi adi ma'at, mu agguyda inamtan, ya mi'id ah nanamad hinan inatda, mu numbaholda damdama. ");
INSERT INTO ifb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ya wa ay ta na'innila nan numbaholanda ya mahapul an iyaliday manilhig an baka ta Onong di Baholda, ya iyuydah nan hinagang di Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ya nan mangipangpanguluh nan ahimpahimpangapun holag Israel di mangeh'ah nan ulun nan baka, ya geneto'dah nan hinangang di awada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ya iyuy nan nahiitan an nidawat an padi nan udum an dala, ya enehgopnah nan Me'gonan an Kuwaltu an pi'hapitan ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ya inhiwhiwnay galaygaynah nan dala, ya inwalhinah mumpapituh nan hinagang di awada' an Dios ya ta\"on nan kultinan nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ya ilamuhnay udum an dalah nan ha'gud nan pun'onngan an wah nan hinagang di awada' an Dios hinan Me'gonan an Kuwaltun a'amungan. Ya nan udum an dala ya ihiitnah nan puun nan pun'onngan hinan Onong an Moghob an wah nan pantaw di Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ya anona goh an amin nan tabana, ya genhobnah nan pun'onngan, ");
INSERT INTO ifb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ya umat hi nangatna hinan nahhun an baka an Onong di Bahol di atona goh ete han onong, ya hiyah ne aton nan padin mange'nong ta way aton nan baholdan ma'aan ya ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ya ekakna nan baka ta iyuynah nan nibataan hinan nuntuldaanda ya unna gohbon an umat hinan inatnah din ohan nahhun. Ya hiyah ne aat di Onong di Bahol nan tatagun holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ya gulat ta hanan ap'apu di numbahol ti inatnay oha ay daten Uldin an immandal'un Dios hi adi aton, mu agguyna inamtan ya numbahol hiya damdama, ");
INSERT INTO ifb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","at wa ay di mangipa'innilan hiya an numbahol ya mahapul an waday iyalinah e'nongnah buta'al an gandeng an mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ya ho\"onay ulun nan gandeng, ya genlotnah nan way lugal hinan pamatayandah nan Onong an Moghob hinan way hinagang di awada' an Dios ti hiyah ne Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ya nan padi ya ihiwhiwnay galaygaynah nan dala, ya inlamuhnah nan ha'gud di pun'onngan hinan Onong an Moghob, ya inhiitna nan udum an dalah nan puun di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ya gohbonan amin nan tabanah nan pun'onngan an umat hi na'at hinan taban nan Onong di Pi'lenggopan ay Ha\"in an Dios. Ya henen aton di padiy mangaan hinan numbaholan nan ap'apu, at aliwa' an Dios di baholna ti inatna nan immandal'un Dios hi adi aton. ");
INSERT INTO ifb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ya wa ay ta han nawotwot an taguy numbahol mu agguyna inamtan ya inatna nan immandal'un Dios hi adi ma'at ya numbahol hiya damdama, ");
INSERT INTO ifb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","mu gulat ta nipa'innilan hiya nan bahol an inatna ya mahapul an iyalinay tennah gandeng an mi'id ah ganitna ta Onong di Baholna. ");
INSERT INTO ifb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ya ho\"onay ulun nan gandeng an Onong di Baholna, ya genlotnah nan way pun'onngan hinan Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ya alan nan padiy dalana ta ihiwhiwnay galaygaynah nan dala, ya inlamuhnah nan ha'gud nan pun'onngan hinan Onong an Moghob, ya inhiitna nan na'angang an dalah nan puun nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ya anona an amin nan taban nan gandeng an umat hi na'at hinan taban nan Onong di Pi'lenggopan, ya gohbon nan padih nan pun'onngan ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios, ya henen ene'nong nan padiy mangaan hi bahol nen tagu, at ma'aliwan nan baholna. ");
INSERT INTO ifb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ya gulat ta hay kalniluy iyalinah Onong di Baholna ya mahapul an hay tenna an mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ya ho\"onay ulun nan kalnilu an Onong di Baholna, ya genlotnah nan way pamatayandah nan Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ya nan padi ya ihiwhiwnay galaygaynah nan dalan nan Onong di Bahol, ya inlamuhnah nan ha'gud di pun'onngan hinan Onong an Moghob, ya inhiitna nan na'angang an dalah nan puun di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ya anonan amin nan taba an umat hi na'at hinan kalnilun Onong di Pi'lenggopan an na'aan an amin di tabana. Ya gohbon nan padih nan pun'onngan ta middum hinan onong an mipulu' ta me'nong ay Ha\"in an Dios. Ya henen ene'nong nan padiy mangaan hi bahol nen tagu, at ma'aliwan.” ");
INSERT INTO ifb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ya intuluy Apo Dios an inalinay, “Ya wa ay ta ma'ayagan nan tagu ta mun'ihtiguh nan inilana, unu dengngolna, unu tinnignan na'at ya adina ibaag di immannung at hiyay mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ya wa ay ta agguyna inamtan han tagu ya dinapana nan ma'alih adi maleneh an umat hinan odol nan natoy an animal unu nan odol di malgom an ahi'ada'adap hinan luta ya ma'ali hiya goh hi adi maleneh ya mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ya wa ay goh ta agguyna inamtan ya dinapana nan agaga\"ihaw an bumuhu' hi odol di tagu unu nan malgom an bumuhu' ay hiya ya nipa'innilan hiyah nen inatna at mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ya wa ay goh ta nan tagu ya agguyna inamtan an adina hamadon an nomnomon nan hapitona ya un nonong ya inhapatana an atona an ta\"on un maphod unu nappuhi mu unat goh nipa'innilan hiya nan hinapitna at mabaholan damdama. ");
INSERT INTO ifb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ya wa ay ta inamtanan hiya ya numbahol ay daten pumbaholan ya mahapul an nan inatna ya itutuyuna an hiya ya numbahol. ");
INSERT INTO ifb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ya hay moltana ya iyalinay ohan tennan kalnilu unu gandeng ta e'nongnan Ha\"in an Dios ta Onong di Baholna. Ya nan padiy mange'nong ta way mangaan eden baholna. ");
INSERT INTO ifb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ya wa ay ta mi'id pangngalanah uyaw an kalnilu ya mabalin an hay duwah balug unu duwah bunun an putta di iyalina ta me'nong ay Ha\"in an Dios, at nan oha ya Onong di Baholna, ya nan oha ya Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","At iyuynah nan padi ta hunnonan e'nong nan oha ta Onong di Bahol, at edonah nan ulun nan hamuti, ya entelonay bagangna, mu adina punhiyanon, ");
INSERT INTO ifb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ya inwalhinay udum an dalan nan Onong di Bahol hinan da'lig nan pun'onngan, ya nan udum an dala ya itidtidnah nan puun nan pun'onngan. Hiyah ne aat di Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ya la'tot ya e'nong goh nan padi nan miyadwan hamuti ta Onong an Moghob an umat hidin atona tuwali. Ya nan padiy mangat ta way aton nan baholnan mahanian, at ma'aliwan henen baholna. ");
INSERT INTO ifb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Mu wa ay ta mi'id pangngalan nan numbahol hinan duwan balug unu duwan bunun an putta ya hay iyalinah Onong di Baholna ya waluy bahuh nan na'adyamu' an alena. Ya adina mantikaan unu udman hinan incense ti hiyah ne Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ya iyuynah nan padi, at alan nan padiy hinggamal ta mangipanomnom an onong ay Ha\"in an Dios, ya genhobnah nan pun'onngan ta middum hinan onong an nipagah apuy ta me'nong ay Ha\"in an Dios. Hiyah ne Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ya nan padiy mange'nong hinan onongna ta way mangaan hinan bahol an inatna an date nan pumbaholan ay Ha\"in an Dios, at ma'aliwan di baholna. Ya nan ma'angang hinan alena ya bagin nan padi an umat hinan Onong an Ma'an.” ");
INSERT INTO ifb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ya ni'hapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Wa ay di ohan tagu an adina amtan ya numbahol hi agguyna nangidatan hinan niyali an midat ay Ha\"in an Dios ya mahapul an iyalinay buta'al an kalnilun mi'id ah ganitna ta me'nong ay Ha\"in ta hiyay moltana. Ya hay balul nan e'nongna ya mipaddung hinan damot nan palatan silver an wah nan Me'gonan an Kuwaltu ti hiyah ne aat di Onong di Nibahhawan. ");
INSERT INTO ifb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ya mahapul an bayadana nan imbahhawnan agguyna indat ay Ha\"in an Dios, ya inokpanah ba'intih porcento nan ibayadna, ya idatnah nan padi ta hiyay mange'nong hinan Onong an Nibahhawan ta ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ya gulat ta han ohan tagu ya numbahol ti inatna nan immandal'un Dios hi adi ma'at ya ta\"on unna agguy inamtan di nangatana mu numbahol, at mamolta damdama. ");
INSERT INTO ifb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","At mahapul an iyuynah nan padiy Onong di Nibahhawanah buta'al an kalnilun pinilinah nan pahtu, ya mi'id ah ganitna an hay balulna ya mun'olog hi Onong di Nibahhawan. Ya nan padiy mange'nong ta way mangaan hinan baholnan agguyna inamtan hi nangatana, at ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ya hiyah te Onong di Nibahhawan. Ti immannung an numbahol hiyan Ha\"in an Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ya ni'hapit goh hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Gulat ta mumbahol di ohan da'yu ti imbahhawna nan Uldin'un Dios an ilayahana nan heneggona an alyonay unda inakaw unu na'utaw nan impatalepondan hiya, unu nan impahalimundan hiya, unu balbaliyana nan heneggona, ");
INSERT INTO ifb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","unu way dotngonah nan gina'u ya adina ipa'innila unu ihapatanan agguyna tinnig, ya malgom ay date atona at hiya ya mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Ya wa ay ta numbahol di ohay tagu ay date ta nun'innomnom an ininnilanan numbahol ya mahapul an ibangngadna nan impatalepondan hiya, unu nan impahalimundan hiya, unu nan inakawna, unu nan penlohna, ya nan gina'un dentongna, ");
INSERT INTO ifb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","unu din gina'un inhapatanan inhaut. Ya mahapul an ibangngadnan amin nan innalna, ya inokpanah ba'intih porcento, ya indatnah nan ad bagi eden gutud di algaw an pange'nonganah Onong di Nibahhawana. ");
INSERT INTO ifb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","At mahapul an iyalinan Ha\"in an Dios nan Onong di Nibahhawana nan napilin buta'al an kalnilun mi'id ah ganitna, ya indatnah nan padi. Ya hay balulna ya mun'olog hi balul di Onong di Nibahhawan, ya e'nong nan padin Ha\"in an Dios ta way a'aliwan nan malgom an numbaholana. ");
INSERT INTO ifb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ya nan padiy mange'nong hinan onongnan Ha\"in an Dios ta way mangaan hinan nibahhawana ta ma'aliwan di baholna.” ");
INSERT INTO ifb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Imandalmu ay da Aaron ya nan linala'in imbabaluyna an alyom di, Hiyah te atonyuh nan uldin di Onong an Moghob. Manu ay Onong an Moghob ti mahapul an lumanablabin mipupulu' hinan pun'onngan ta nangamung mabiggat, ya nan apuy ya gumagaban dumaladalang hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ya nan mabiggat ya ilubung nan padi nan napinuy abolnan lubung, ya ipantalona nan putut an pantalon di padi ya unna anon nan dapul din Onong an Moghob hinan pun'onngan, ya impatangnah nan pangngel nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ta nalpah ay ya inaana nan inlubungna, ya nunlubung hi nat'on ya unna alan nan dapul, ya enekaknah nan immapalanda ta iyuynah nan nibataan hinan maleneh an lugal. ");
INSERT INTO ifb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ya nan apuy hinan pun'onngan ya mahapul an bubumnang an adi madmaddop, ya nan padi ya gunna tunguwan hinan ahelhehelhelong, ya panuhonan pun'iyuhun nan Onong an Moghob, ya gohbona goh nan taban di Onong di Pi'lenggopan. ");
INSERT INTO ifb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","At nan apuy hinan pun'onngan ya bubumnang an adi madmaddop.” ");
INSERT INTO ifb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ya inalin goh Apo Dios di, “Ya hiyatuy uldin hi ma'at hinan Onong an Ma'an. Nan linala'in imbabaluy Aaron di mange'nong hinan way pun'onngan an awada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ya alanday hinggamal hinan na'adyamu' an nangeleng an bogah, ya nan mantika, ya nan incense an niddum hinan Onong an Ma'an ta panginomnoman, ya genhobnah nan pun'onngan ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ya nan na'angang hinan Onong an Ma'an ya da Aaron ya nan linala'in imbabaluynay mangan. Mu adida udman hi bino'bo' nan tinapay an ononda, ya hidih nan me'gonan an lugal di panganandah nan way gettaw nan Me'gonan an Kuwaltun pi'hapitan ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ya mahapul an adida ahan udman hi bino'bo' nan tinapay an ihaangda ti hiyah ne idat'un didah bingaydah nan ne'nong ay Ha\"in an nipaga. Ya hene ya nidugah an me'gonan an umat hinan Onong di Bahol ya nan Onong di Nibahhawan. ");
INSERT INTO ifb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ya an amin nan linala'in holag Aaron ya diday mangan ene. Ya hiyah ne uldin hi ato'aton nan holagyuh minaynayun hi engganah nan onong an mipaga. At an amin nan manapa ene ya me'gonanda goh.” ");
INSERT INTO ifb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Hiyah te onong da Aaron ya nan linala'in imbabaluynah iyalidan e'nong ay Ha\"in an Dios eden algaw an idawatanah ihiitan nan lana. Hay ma'usal hinan Onong an Ma'an ya oha ya han godwan kiluh nan na'adyamu' an alena ta Ma'an an Onong, ya magodwa ta nan godwana ya me'nong hinan helhelong ya nan godwana ya hinan mahdom. Hiyah te gun na'at hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ya malamutan hi mantika ya un mihaang hinan nadapyag an kawali. Ta malutu ay ya unna mahkay ehgop, ya puhitona nan ma'an ya unna e'nong ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ya nan linala'in holag Aaron an midawat ta mipallog ay hiyan mumpadiy mange'nong hinan ma'an, ya gohbonan amin. Ya minaynayun heten ma'at hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ya an amin nan Onong an Ma'an an onon di padi ya mahapul an moghob an amin, ya adi mabalin hi onon.” ");
INSERT INTO ifb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Alyom goh ay da Aaron ya nan linala'in imbabaluynay, Hiyatuy uldin nan Onong di Bahol. Nan Onong di Bahol ya maglot hinan hinagang di awadan Apo Dios an aglotan nan Onong an Moghob, at hiyanan me'gonan ahan. ");
INSERT INTO ifb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ya nan padin mange'nong hi Onong di Bahol di mangihdah nan e'nongnah dih nan me'gonan an lugal hinan way gettaw hinan Me'gonan an Kuwaltun awadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ya an amin nan mideneh hinan dotag ya me'gonanda. Ya nan lubung an mapahi'an hinan dalan den me'nong ya mahapul an maloba'an hinan me'gonan an lugal an napahi'ana. ");
INSERT INTO ifb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ya nan lutan bangan ihaangan nan dotag ya mahapul an maphal. Mu wa ay ta nan gumo' an bangay ihaangana ya mahapul an magadgadan ta mihamad an ma'egwahan. ");
INSERT INTO ifb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ya an amin nan linala'in imbabaluy nan padi ya mabalin hi ihdada, ya hene ya me'gonan ahan. ");
INSERT INTO ifb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mu adi mabalin hi ihda nan Onong di Bahol an nehgop di dalanah nan kuwaltun me'gonan hinan Me'gonan an Kuwaltu ti ne'nong ta way a'aliwan di bahol. At henen animal ya mahapul an moghob an amin.” ");
INSERT INTO ifb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ya inalin goh Apo Dios ay Moses di, “Hiyah te uldin hi Onong di Nibahhawan an nidugah an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nan Onong di Nibahhawan ya maglot hinan way aglotan nan Onong an Moghob, ya nan dalana ya miwalhih nan nunlene'woh hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ya an amin nan tabana ya e'nongna an umat hi taban di iwit, ya nan taban di putu, ");
INSERT INTO ifb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ya ma'aan goh nan duwan batin an middum nan tabada, ya nan taban di inawa', ya nan taban niyunanit hi oltay. ");
INSERT INTO ifb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ya gohbon nan padih nan pun'onngan ta me'nong ay Ha\"in an Dios nan onong an mipagah apuy. Hiyah ne aat di Onong di Nibahhawan. ");
INSERT INTO ifb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ya an amin nan linala'in imbabaluy nan padi ya mabalin hi ihdada nan bingaydah nan me'nong. Mu mahapul an nan me'gonan an lugal di pangihdanda ti henen onong ya nidugah an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ya mumpaddung nan uldin hi ma'at hinan Onong di Bahol ya Onong di Nibahhawan ti nan dotag nan me'nong ya bagin nan padin mange'nong hi a'aanan di bahol. ");
INSERT INTO ifb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ya nan padin mange'nong hinan epe'nong di tagu an Onong an Moghob ya baginay up'up di ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ya an amin nan Onong an Ma'an an mihaang hinan punhaangan hi tinapay, unu mihaang hinan kawali, unu nan banga ya bagin goh nan padin nange'nong. ");
INSERT INTO ifb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mu an amin nan Onong an Ma'an an namantikaan unu agguy ya mapapaddung an punggogodwon nan linala'in imbabaluy Aaron.” ");
INSERT INTO ifb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ya inalin goh Apo Dios di, “Ya hiyatuy uldin hi ma'at hinan Onong di Pi'lenggopan ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ya gulat ta nan epe'nongna ya un hay punyamanana ya hay e'nongnah nan Onong di Punyamanan ya nan namantikaan an tinapay an mi'id bino'bo'na, ya tinapay an ma'amyudan, ya nahiitan hi mantikan mi'id bino'bo'na, ya nan tinapay an hay niyamma ya nan na'adyamu' an alena, ya namantikaan, ya nipulitu. ");
INSERT INTO ifb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ya iyalina goh nan tinapay an mabino'bo'an ta middum an me'nong hinan Onong di Punyamananah nan Onong di Pi'lenggopana. ");
INSERT INTO ifb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ya alanay hinohhah nan tinapay ta Milayat an Onong ay Ha\"in an Dios, ya hiyatuy bagin nan padin mangiwalhih nan dalan nan Onong di Pi'lenggopan ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ya nan dotag nan epe'nongnah Onong di Pi'lenggopanan Ha\"in ya mahapul an mihda an amin ede han algaw an e'nongana, ya mi'id ah ma'angang hi engganah mabiggat. ");
INSERT INTO ifb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Mu wa ay ta nan epe'nongna ya un hay onong an mangipa'annung hinan mihapata unu unna tuwali ninomnom an mun'onong ya mahapul an mihda an amin eden algaw an e'nongana, mu gulat ta waday ma'angang ya mabalin hi mihdah nan mabiggat. ");
INSERT INTO ifb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mu wada ay di ma'angang damdama ya adi mabalin hi mihdah nan atlun di algaw, at mahapul an mipulu' ta moghob. ");
INSERT INTO ifb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ya wa ay ta nan dotag nan Onong di Pi'lenggopan ya nan atlun di algaw di pangihdandah nan ma'angang ya adi ahan ma'abulut heden nangepe'nong, ya ta\"on nan impe'nongna. Ti henen ma'at ya agaga\"ihaw ahan, at nan mangihda di hiyay mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ya wa ay ta medeneh nan dotag hinan ma'alih adi maleneh ya adi mabalin hi mihda, at mahapul an mipulu' hi apuy ta moghob. Ya nan udum an dotag ya mabalin hi ihdan nan tagun ma'alih maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mu gulat ta waday tagun ma'alih adi maleneh an mangihdah nan dotag an me'nong ay Ha\"in an Dios an Onong di Pi'lenggopan ya mapogpog di iddumanah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ya wa ay goh di manapah nan ma'alih adi maleneh an nan nalugit an ipabuhu' di tagu, unu nan ma'alih adi maleneh an o\"ongol an animal, unu nan malgom an agaga\"ihaw an ma'alih adi maleneh ta ihdana nan dotag an Onong di Pi'lenggopan ya mapogpog di iddumanah nan tatagu.” ");
INSERT INTO ifb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Alyom hinan holag Israel di, Adiyu ihday taban nan baka, ya kalnilu, unu gandeng. ");
INSERT INTO ifb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ya ta\"on nan taban nan animal an mapihti unu nan taban di animal an pinatoy di ibbanan animal ya mabalin hi usalonyuh nan malgom an ma'at, mu adiyu ipadah an ihda. ");
INSERT INTO ifb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ti nan mangihdah nan taban nan animal an e'nong di taguh onong an mipagah apuy ta dumalang ya me'nong ay Apo Dios ya mapogpog di ibilanganah tagun Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ya ta\"on hinan nunhituwanyu ya mahapul an adiyu ahan ihday dalan nan hamuti unu animal. ");
INSERT INTO ifb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ti nan mangihdah dala ya mapogpog di iddumanah nan tagun Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Alyom hinan holag Israel di, Wa ay di nun'onong hinan Onong di Pi'lenggopanan Apo Dios ya mahapul an iyuynay e'nongna ta me'nong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ya hiyay manimung an mangiyuy an mange'nong ay Apo Dios hinan onong an mipagah nan apuy. Ya iyuyna nan taba an middum nan boga', ya ilayatna nan boga' ta Onong an Milayat ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ya nan padiy manghob hinan tabah nan pun'onngan, mu nan boga' ya bagin da Aaron ya nan linala'in imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ya nan agwan an ulpun di e'nongyuh Onong di Pi'lenggopan ya idatyuh nan padi ta bagina ");
INSERT INTO ifb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ta nan imbabaluy Aaron di mangngal hinan agwan an ulpu ta bagida ti diday mange'nong hinan dala ya nan taban di Onong di Pi'lenggopan. ");
INSERT INTO ifb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Nan boga' an nilayat ya nan ulpun nan ne'nong ya inaan'uh nan e'nong nan holag Israel hinan Onong di Pi'lenggopandan Apo Dios ta midat ay Aaron an padi ya nan linala'in imbabaluyna. Ya hiyah ne minaynayun hi aton nan holag Israel hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ya hiyah ne milalahhin an midat ta bagin da Aaron ya nan linala'in imbabaluyna an nalpuh nan ne'nong ay Apo Dios an mipadalang hi apuy eden algaw an nidawatanda. ");
INSERT INTO ifb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ti hi Apo Dios di nangimandal hinan holag Israel an hiyah ne midat ay dida eden algaw an ahiitandah nan lana ta mumpadida. Hiyah ne niyuldin hi ato'atondah minaynayun hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ya hiyatuy aat nan uldin di Onong an Moghob, ya Onong an Ma'an, ya Onong di Bahol, ya Onong di Nibahhawan, ya Onong hi Pangidawatan, ya Onong di Pi'lenggopan ay Apo Dios ");
INSERT INTO ifb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","an immandal Apo Dios ay Moses hi wadandah nan Duntug an Sinai hidin nummandalanah nan holag Israel ta iyuyday e'nongdan Apo Dios hinan mapulun.” ");
INSERT INTO ifb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Umuy ayu ay da Aaron ya nan linala'in imbabaluynah nan way pantaw di Me'gonan an Kuwaltun a'amungan, ya inodnanyu nan lubungda, ya nan lanan mihiit, ya ohay manilhig an bakan Onong di Bahol, ya duwan buta'al an kalnilu, ya ohay bahkit hi tinapay an mi'id bino'bo'na, ");
INSERT INTO ifb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ya alyonyu ta an amin nan tataguh di ya amungondah nan way pantaw di Me'gonan an Kuwaltu.” ");
INSERT INTO ifb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","At inunud da Moses nan immandal Apo Dios ay hiya. At nahayup nan tataguh nan way pantaw di Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ya inalin Moses hinan na'amung di, “Hiyah te immandal Apo Dios hi ma'at.” ");
INSERT INTO ifb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","At inayagana da Aaron ya nan linala'in imbabaluyna, ya innalnay danum, ya emmohna dida. ");
INSERT INTO ifb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ya impilubungnan Aaron nan lubung an magayad, ya impibol'ohna nan bol'oh, ya impilubungnan hiya nan lubung an ma\"aphod di abolna ya nan lubung di Nabagtun Padi an ephod, ya binol'ohana goh hinan bol'oh di ephod an napinuy abolna. ");
INSERT INTO ifb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ya inyammana nan hanin di palagpag, ya inhab'itna nan ma'alih Urim ya Thummim hinan hanin di palagpag. ");
INSERT INTO ifb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ya impiyuklupna nan uklup di padin ma'alih turban, ya empepngotna nan balitu' an nitud'an di hapit ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ya innal Moses nan lanan mihiit hinan way midawat, ya inwalhinah nan Me'gonan an Kuwaltu, ya an amin nan alimatungna ya indawatnan amin. ");
INSERT INTO ifb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ya winalhiana goh hi numpapitu nan pun'onngan, ya hiniitana goh nan pun'onngan ya nan alimatungna an pamahan ya nan ipabunana ta midawatda. ");
INSERT INTO ifb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ya inhiitna nan lanah ulun Aaron, ya indawatna ta malenehan an milahhin hiya. ");
INSERT INTO ifb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ya inayagana goh nan linala'in imbabaluy Aaron, ya impilubungnan dida nan lubung di padi an magayad, ya binalikisana didah nan bol'oh, ya inuklupana didah nan uklup di padi ti hiyah ne din immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ya ginuyud Moses nan manilhig an baka an Onong di Bahol, ya eneh'an da Aaron ya nan linala'in imbabaluynah nan uluna. ");
INSERT INTO ifb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ya genlot Moses, ya innalna nan dala, ya nunlene'wohonan ilamuh hinan ha'gud di pun'onngan ta malenehan nan pun'onngan. Ya inhiitna nan udum an dalah nan puun nan pun'onngan, ya indawatna ta me'gonan an ma'aan di lugitna. ");
INSERT INTO ifb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ya inaan Moses an amin nan taban di putu, ya nan taban niyunanit hinan oltay, ya nan duwan batin an niddum nan taba, ya genhobnah nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mu nan up'up di baka, ya nan lamohna, ya nan galutna ya ekakna ta mibataan hinan immapalanda ya unna gohbon ti hiyah ne immandal Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ya innal goh Moses nan ohan buta'al an kalnilu an Onong an Moghob, ya eneh'an da Aaron ya nan linala'in imbabaluynah nan uluna. ");
INSERT INTO ifb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ya genlot Moses, ya inwalhina nan dalah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ya binu'lina, ya numpuhitna nan kalnilu, ya genhob Moses nan naphit an niddum nan ulu ya nan taba. ");
INSERT INTO ifb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ya dinaluhana nan putu, ya inulahana nan hu'i, ya genhob Moses an amin heden kalniluh nan pun'onngan. Ti hiyah ne Onong an Moghob an maphod di hunghungna an onong an mipaga ta me'nong ay Apo Dios. Ti hiyah ne din immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ya innal goh Moses nan miyadwan buta'al an kalnilu an Onong di Pangidawatan, ya eneh'an da Aaron ya nan linala'in imbabaluynah nan ulun di kalnilu. ");
INSERT INTO ifb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ya genlot Moses nan kalnilu, ya tendo'na nan dalana, ya indenehnah agwan hi ingan Aaron, ya nan agwan an am'ama\"an di ngamayna, ya nan agwan an am'ama\"an di hu'ina goh. ");
INSERT INTO ifb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ya inayagana goh nan linala'in imbabaluy Aaron, ya indenehna goh nan dalah nan agwan di ingada, ya nan agwan an am'ama\"an di ngamayda, ya nan agwan an am'ama\"an di hu'ida. Ya inwalhin Moses nan udum an dalah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ya inaana goh nan taban nan wah iwitna, ya an amin nan taban di putu, ya nan taban niyunanit hinan oltay, ya nan duwan batin an niddum nan tabada, ya nan agwan an ulpu. ");
INSERT INTO ifb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ya innalnay ohah din tinapay an agguy nabino'bo'an an nittuh nan bahkit an wah nan hinagang di awadan Apo Dios, ya innalna goh din ohan tinapay an na'amyudan hi mantika ya ohah din muymuyammi an tinapay, ya nun'iyuhunah nan taba ya nan agwan an ulpu. ");
INSERT INTO ifb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ya impadonan amin hatu ay da Aaron ya nan linala'in imbabaluyna, ya inlayatna ta Onong an Milayat. ");
INSERT INTO ifb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ya nun'alan goh Moses nan nun'ipadonan dida, ya genhobnah nan pun'onngan an nun'iyuhunah nan Onong an Moghob ti hene ya Onong di Pangidawatan an mipadalang hi apuy ta nan hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ya innal goh Moses nan boga', ya inlayatna ta Onong an Milayat hi way hinagang Apo Dios. Ti hete ya datag Moses hinan Onong di Pangidawatan an hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ya innal goh Moses nan lanan mihiit hinan way midawat, ya nan dalah nan pun'onngan, ya inwalhina ay Aaron, ya nan lubungna, ya nan linala'in imbabaluyna, ya nan lubungda goh, ya indawatna goh hi Aaron, ya nan lubungna, ya nan linala'in imbabaluyna, ya nan lubungda goh ta maleneh di aatda. ");
INSERT INTO ifb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ya inalin Moses ay da Aaron ya nan linala'in imbabaluynay, “Ihaangyu nan dotag hinan way pantaw di Me'gonan an Kuwaltun a'amungan, ya hidi goh di pangihdaanyu ya pangananyuh nan tinapay an wah nan bahkit an Onong di Pangidawatan ti hiyah ne din immandal'un da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ya nan ma'angang hinan dotag ya tinapay ya gohbonyu. ");
INSERT INTO ifb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ya mahapul an adi ayu lumahlahun hinan pantaw di Me'gonan an Kuwaltun a'amungan hi pituy algaw ta engganay unyu pungpungon nan algaw an idawatanyu. Ti pituy algaw di bilang nan pangidawatan ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ya nan na'at ad ugwan ya hiyah ne immandal Apo Dios hi ma'at ta malenehan di aatyu. ");
INSERT INTO ifb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ya mahapul an nan pantaw di a'amungan ya anggay di ipogpoganyuh pituy algaw ya pituy mahdom, ya unudonyu nan pohdon Apo Dios hi ma'at ta way atonyun adi matoy ti hiyah ne immandalnan ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","At inat da Aaron ya nan linala'in imbabaluyna an amin nan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ya din awalun di algaw ya impa'ayag Moses da Aaron, ya nan linala'in imbabaluyna, ya nan mangipangpanguluh nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ya inalinan Aaron di, “Iyalim di ohan manmannilhig an baka ta Onong di Baholmu, ya nan ohan buta'al an kalnilun mi'id ganitna ta Onong an Moghob, ya ene'nongmuh nan way hinagang Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ya pun'iyalim hinan holag Israel, ya alyom ta iyaliday ohah buta'al an uyaw an gandeng ta Onong di Bahol, ya nan hinohhay tawona an baka ya kalnilun mid ganitda ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ya oha goh hi baka ya ohan buta'al an kalnilu ta Onong di Pi'lenggopan ta me'nong hinan way hinagang Apo Dios. Ya iddumda goh nan tinapay an ma'amyudan hi mantika ta Onong an Ma'an. Ti ad ugwan ya mumpattig hi Apo Dios ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ya inyuydan amin nan immandal Moses an miyuy hinan way hinagang di Me'gonan an Kuwaltun a'amungan, ya nahlig an amin nan na'amung an tatagu, ya numpangata'dogdah nan way hinagang Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ya inalin Moses di, “Hiyah te immandal Apo Dios hi atonyu ta way aton nan benang Apo Dios an mumpattig ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ya inalina goh ay Aaron di, “Umuy'ah nan pun'onngan ta e'nongmu nan Onong di Baholmu ya nan Onong an Moghob ta he\"ay mangipa'aan hi baholmu ya nan bahol di tatagu ta ma'aliwan nan baholmu. Ya e'nongmu goh nan onong di tatagu ta way a'aliwan di baholda ti hiyah ne din immandal Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","At immuy hi Aaron hinan way pun'onngan, ya genlotna din baka an Onong di Baholna. ");
INSERT INTO ifb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ya indat nan linala'in imbabaluynan hiya nan dala, ya inhiwhiwnay galaygaynah nan dala, ya inlamuhnah nan ha'gud di pun'onngan, ya inhiitna nan udum an dalah nan puun di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ya nan taba, ya nan batin, ya nan taban niyunanit hinan oltay den Onong di Bahol ya genhobnah nan pun'onngan an hiyah ne immandal Apo Dios ay Moses hi ma'at. ");
INSERT INTO ifb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mu nan lamoh ya nan up'up ya genhobnah nan way nibataan hi immapalanda. ");
INSERT INTO ifb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ya genlot goh Aaron nan Onong an Moghob, ya indat nan linala'in imbabaluynan hiya nan dala ta inwalhinah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ya inohha'ohhadan indawdaw ay hiya nan Onong an Moghob an nun'aphit an middum nan ulu, ya genhobnah nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ya dinaluhana nan putu, ya inulahana din hu'i, ya inyuhuna ta middum an moghob hinan Onong an Moghob hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ya enehod Aaron nan onong nan tatagu, at innalna din gandeng an Onong di Baholda, ya genlotna, ya ene'nongna an umat hidin inatnah din nahhun an Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ya ene'nongna goh din Onong an Moghob, ya inunudna nan uldin hi aton hinan Onong an Moghob ");
INSERT INTO ifb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ya unna goh e'nong nan Onong an Ma'an, ya innalnay hinggamal hinan ma'an, ya genhobnah nan pun'onngan an nedelloh hinan Onong an Moghob an me'nong hinan helhelong. ");
INSERT INTO ifb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ya genlotna goh nan baka ya nan buta'al an kalnilu an me'nong ta Onong di Pi'lenggopan nan tatagu. Ya indat nan linala'in imbabaluy Aaron nan dalan hiya ta inwalhinah nan nunlene'woh di pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ya nan taban nan baka ya nan kalnilun ma'alah nan way iwit, ya nan taban di putu, ya nan taban niyunanit hinan oltay, ya nan batin ");
INSERT INTO ifb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ya nun'iyuhunda nan tabah nan boga', ya genhob Aaron hana nan tabah nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mu inlayat Aaron din boga' ya nan agwan an ulpu ta Onong an Milayat hinan nihagang hi awadan Apo Dios. Ti hiyah ne immandal Moses. ");
INSERT INTO ifb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ya unat goh enelpah Aaron an ene'nong nan Onong di Bahol, ya Onong an Moghob, ya Onong di Pi'lenggopan ay Apo Dios ya inta'nangnay ngamayna an inhagangnah nan tatagu ta wagahana dida, ya limmuh'uh nan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ya hinumgop da Moses ay Aaron hinan Me'gonan an Kuwaltun awadan Apo Dios. Ya unat goh pimmitawda ya winagahanda goh nan tatagu. Ya numpattig nan benang Apo Dios hinan tatagu ");
INSERT INTO ifb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","an nalpuh nan awadan Apo Dios nan apuy ta genhobnan amin nan Onong an Moghob ya din taban wah nan pun'onngan. Ya unat goh tinnig an amin nan tatagu ya bimmugawdah amlongda, ya numpunhippidan nunluung ta niyatam di angahdan nan lutah pange'gonandan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nan linala'in imbabaluy Aaron an da Nadab ay Abihu ya way ohan didaan innalday duyu, ya inittuwandah nan bimmalan apuy ya nan incense, ya ene'nongdan Apo Dios, mu nan apuy an nanghobdah nan incense ya bo'on nan apuy an me'nong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","At waday apuy an nalpuh nan wadan Apo Dios an nanghob ay dida ta natoydah di. ");
INSERT INTO ifb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ya inalin Moses ay Aaron di, “Hiyah te din hinapit Apo Dios an inalinay, Ha\"in ya me'gonana' an dumalat nan umalian nan tatagun meheggon ay Ha\"in, ya hidih nan hinagang di tatagu ya mattig di benang'u.” Ya unat goh dengngol Aaron henen inalin Moses ya un didindinong an agguy himmapit. ");
INSERT INTO ifb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ya inayagan Moses da Mishael ay Elzaphan an linala'in imbabaluy han ulitaon Aaron an hi Uzziel, ya inalinan diday, “Umali ayuh tu ta ekayu alan nan nun'atoy an kasinsinyuh nan way hinagang nan Me'gonan an Kuwaltu ta ibataanyuh nan immapalanyu.” ");
INSERT INTO ifb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","At immuyda, ya nan lubung nan nun'atoy an magayad di nangedonandan nangekak ta imbataandah nan immapalanda ti hiyah ne immandal Moses ay dida. ");
INSERT INTO ifb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ya inalin Moses ay Aaron ya nan linala'in imbabaluynan da Eleazar ya hi Ithamar di, “Adiyu guguyabon, ya adiyu goh hekhekon di lubungyu, ti atonyu ay at matoy ayu, ya nunheglay bimmungtanah nan holag Israel. Mu an amin nan i'ibbayun holag Israel ya mabalin hi ilungdayaanda da Nadab ay Abihu an genhob Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ya adi ayu lumahlahun hinan pantaw nan Me'gonan an Kuwaltun a'amungan ta adi ayu goh matoy ti nan lanan nidawat ay Apo Dios ya nilanan da'yu.” At inunudda nan inalin Moses. ");
INSERT INTO ifb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ya inalin Apo Dios ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“He\"a ya nan imbabaluymun linala'i ya adi ayu uminum hi bayah unu nan malgom an napgot an ma'inum hi un ayu humgop hinan Me'gonan an Kuwaltun a'amungan ta adi ayu matoy. Ya hiyah te mandal an minaynayun hi gun ato'aton goh nan holagyuh enggana. ");
INSERT INTO ifb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ya mahapul an immatunanyuy nun'abhiwan nan me'gonan ya nan adi me'gonan, ya nan nun'abhiwan nan maleneh ya nan ma'alih adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ya mahapul an ituduyun amin nan Uldin an din immandal'un Moses hinan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ya inalin Moses ay Aaron ya nan na'angang an linala'in imbabaluynan da Eleazar ya hi Ithamar di, “Alanyu nan Onong an Ma'an an din na'angang hinan ne'nong ay Apo Dios an nipagah nan apuy, ya inyammayuh tinapay an adiyu udman hi bino'bo' ya unyu onon hinan pangngel di pun'onngan ti henen ma'an ya me'gonan ahan. ");
INSERT INTO ifb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","At hay me'gonan an lugal di pangananyu ti hiyah ne bagim ya bagin goh nan imbabaluymuh nan onong an ne'nong ay Apo Dios an mipagah nan apuy. Ti hiyah ne nimandal ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mu nan boga' an nilayat ya nan ulpu an nilayat ay Apo Dios ya mabalin an ihdayun hina\"aman middum nan binabain imbabaluymu, ya nan ma'alih maleneh an lugal di pangihdanyu ti hiyah ne nidat ay he\"a ya nan linala'in imbabaluymuh bagiyu an nalpuh nan Onong di Pi'lenggopan ay Apo Dios an impe'nong nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ya nan ulpu an nilayat ya nan boga' an Onong an Milayat ya mahapul an middum hinan na'aan an taba an nan Onong an Pi'lenggopan nan apuy ta milayat an me'nong ay Apo Dios. Ya hiyah ne midat ay he\"a ya nan linala'in imbabaluymuh enggana ti hiyah ne immandal Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ya inhamad Moses an minahmahan nan aat din gandeng an Onong di Bahol. Ya unat goh tinnigna an noghob ya ma'abbungot ay da Eleazar ya hi Ithamar an din na'angang hinan linala'in imbabaluy Aaron. Ya inalinan diday, ");
INSERT INTO ifb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Anaad ta agguyyu inihda nan bingayyu an nan Onong di Bahol hinan way me'gonan an lugal? Inilayu an hene ya me'gonan ahan an nidat ay da'yu ta way mangaan hinan bahol nan tatagu ta ma'aliwan! ");
INSERT INTO ifb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ya agguy nehgop nan dalanah nan Me'gonan an Kuwaltu, at hiyanan onaynah un hidiy nangihdanyuh nan me'gonan an lugal an umat hidin immandal'u!” ");
INSERT INTO ifb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ya tembal Aaron an inalinan Moses di, “Ad ugwan an algaw ya ene'nongda nan Onong di Baholda ya nan Onong an Moghob hinan way hinagang Apo Dios, ya anaad ta ma'at henen nappuhin ha\"in? Ya gulat ta waday na'at hi umat hina ta inihda' ad ugwan nan Onong di Bahol ya undan hiya dan un abuluton Apo Dios?” ");
INSERT INTO ifb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ya unat goh dengngol Moses henen inalin Aaron ya ma\"amlong, at dindinong. ");
INSERT INTO ifb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ya inalin goh Apo Dios ay da Moses ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Alyonyuh nan holag Israel di, Umat hituy aat di a'animal an wah tun lutah ihdayu: ");
INSERT INTO ifb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","nan animal an nadi\"ang di dapana ya nan mangag'al hi onona. ");
INSERT INTO ifb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mu waday udum an animal an mangag'al hi onona mu agguy nadi\"ang di dapada, unu ta\"on un nadi\"ang di dapanda mu adida gag'alon di ononda. Ya didanay mahapul hi adiyu ihda ti mibilangdah adi maleneh an umat hinan kamilu an gag'alonday ononda mu agguy nadi\"ang di dapanda. ");
INSERT INTO ifb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ya adiyu goh ihda nan buwoh an mangag'al hi anonda mu agguy nadi\"ang di dapanda. ");
INSERT INTO ifb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ya ta\"on nan kunihuh unda gag'alon di ononda mu agguy nadi\"ang di dapanda. ");
INSERT INTO ifb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ya nan babuy an ta\"on hi un nadi\"ang di dapanda mu adida gag'alon di ononda. ");
INSERT INTO ifb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ya mahapul an adiyu ihda nan lamohda, ya adiyu goh dapoon unda matoy ti didanay mapaniaw hi adi mihda. ");
INSERT INTO ifb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ya an amin nan nunhituh nan danum an wah nan baybay ya nan wangwang ya hay ihdayu ya nan way ipayna ya nalahipan. ");
INSERT INTO ifb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ya an amin nan wadah nan baybay ya nan wangwang an mi'id ipayna unu lahipna ya ta\"on nan mabuluh hinan danum ya nan malgom an wah nan danum ya adiyu ihda ti niyuldin an mapaniaw ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ya didanay mipawa an adi maleneh ay da'yu, at mahapul an adiyu ihda unu dapoon nan natoy an umat hina. ");
INSERT INTO ifb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","At an amin nan wah nan danum an mi'id di ipayna ya lahipna ya mapaniaw, at adiyu ihda. ");
INSERT INTO ifb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ya umat goh hinan hamuti an waday adiyu ihda an umat hinan agila, ya nan ti'gi, ya nan taptaplon, ");
INSERT INTO ifb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ya nan lawin, ya nan udum an taptaplon an nan numbino'ob'on di kololda. ");
INSERT INTO ifb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Ya nan numbino'ob'on goh an gayang, ");
INSERT INTO ifb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ya nan ongol an hamuti an bannug, ya nan guup, ya nan udum an umat hi bannug. ");
INSERT INTO ifb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Ya nan i\"itang an guup, ya nan akup, ya nan pa\"ongol an hulin, ");
INSERT INTO ifb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ya nan mumpaha' an tu'u'an, ya nan akup hinan inalahan, ya nan pelikan, ");
INSERT INTO ifb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ya nan kulung an adu\"oy di hu'ina ya hobatna, ya an amin di numbino'ob'on an kulung, ya nan dolwa', ya nan panni'i, ya littalit. ");
INSERT INTO ifb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ya adiyu goh ahan ihda nan i\"itang an tumayap ya nan umadap an opat di hu'ida ti niyuldin nan mapaniaw hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mu waday udumnah nan i\"itang an nun'apaya'an ya umadap an mabalin hi ihdayu an nan waday hu'ida ya lumattu'da. ");
INSERT INTO ifb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ya hiya hatuy ihdayu an nan numbino'ob'on an dudun, ya talimpugu, ya battat, ya pepellah. ");
INSERT INTO ifb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mu nan udum an tumayap ya nan umadap an opat di hu'ida ya adiyu ihda. ");
INSERT INTO ifb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ya didanay dumalat hi ibilanganyuh adi maleneh. At nan manapa ay danen natoy ya mibilang hi adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ya nan mangdon hinan natoy ay dane ya mahapul an iloba'nay lubungna, ya mibilang hiyah adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ya an amin nan nadi\"ang di dapanda ya nan adi mangag'al hi ononda ya mibilangdah mapaniaw ay da'yu. At nan manapah nan matoy ay dane ya mibilang goh hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ya an amin nan animal an opat di hu'ina mu waday u\"ulung di hu'ida an idalanda ya mibilang hi adi maleneh, ya nan manapah nan matoy ay dane ya mibilang hi adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ya wa ay di mangdon unu mami'ug hinan matoy an umat hina ya mahapul an iloba'nay lubungna, ya mibilang hiyah adi maleneh hi engganay mahdom. Ti immannung an didanay mibilang hi adi maleneh ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ya nan animal an ahi'ada'adap hinan luta ya mibilangda goh hi adi maleneh ay da'yu an umat hi buwoh, ya bu'at, ya nan o\"ongol an baniah, ");
INSERT INTO ifb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ya tecca, ya banbanaggaw, ya bulbula'ot, ya nan allugu. ");
INSERT INTO ifb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","An amin hanan ahi'ada'adap hinan luta ya mibilang hi adi maleneh ay da'yu. At nan manapah nan matoy ay dane ya mibilang goh hi adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ya wada ay di matoy hinan umat hina ta magah hinan malgom an gina'u an umat hi ayiw, unu lo'ob, unu lalat, unu langgut ya nan epto'ana ya mibilang hi adi maleneh. Mu hay atonyuh nan gina'un nagahana ya iyupolyuh nan danum ta engganay mahdom ya un mibilang hi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ya gulat goh ta way matoy ay dane ya nagah ya nepto' hinan lutan banga ya an amin nan nittuh nan banga ya mibilang hi adi maleneh, at mahapul an mapohla' nan banga. ");
INSERT INTO ifb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ya wa ay ta danum di mittun nen banga ta midanum hinan malgom an ma'an ya nan mangan ene ya mibilang goh hi adi maleneh, ya umat goh hinan manginum hinan mittun danum an mibilang goh hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ya an amin nan epto'an di agahan nan matoy an umat hina ya mibilang hi adi maleneh. At wa ay ta magah hinan punhaangan hi tinapay unu nan lutan banga ya mahapul an mapohla' ti mibilangdah adi maleneh. At immannung an hana ya mibilang hi adi maleneh ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ya wa ay ta nan obob unu abu\"ul an do'ol di danumna di hiyay agahan nan natoy an umat hina ya maleneh nan danum, mu nan manapah nan natoy di hiyay mibilang hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ya wa ay di magah an ta\"on un itang an lamoh hinan oho' an nan meho' ya mibilang hi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mu wa ay ta miyupol nan oho' ya un magah di lamoh nan natoy an umat hina ya mibilang hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ya wa ay ta nan animal an mihda di matoy ya wada ay di manapah nan natoy ya mibilang hi adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ya wa ay di mangihda ya mangdon hinan natoy ya mahapul an iloba'nay lubungna, ya mibilang hi adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ya an amin nan ahi'iwi'iwi ya ahi'ada'adap hitun luta ya mapaniaw, at adiyu ahan ihda. ");
INSERT INTO ifb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ya umat goh hinan mabuluh, unu nan opat di hu'ina, unu nan do'ol di hu'ina an umadap hinan luta ya didanay adiyu ihda ti mapaniaw. ");
INSERT INTO ifb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ya adiyu puhion di odolyu an dumalat hi pangihdanyun dane han ahi'ada'adap, ya adiyu abuluton an diday dumalat hi ibilanganyuh adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ti Ha\"in an nabagbagtun Apuyu an hi Apo Dios di nangali. At mahapul an maleneh di nitaguanyu ta me'gonan ti Ha\"in ya me'gonana'. At elanyu ta adi dumalat di panapaanyuh nan ahi'iwi'iwi ya ahi'ada'adap hitun lutay ibilanganyuh adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ti Ha\"in hi Apo Dios an nangekak ay da'yuh ad Egypt, at Ha\"in di dayawonyu. At mahapul an me'gonan ayu ti Ha\"in ya me'gonana'. ");
INSERT INTO ifb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ya hiyatuy uldin hi aat nan animal, ya hamuti, ya an amin nan mun'iwi'iwi an wah nan danum, ya nan mun'ad'adap an wah tun luta. ");
INSERT INTO ifb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ta way aton tu'un mangimmatun hinan niyuldin an mibilang hi maleneh ya nan adi maleneh, ya nan animal an mabalin hi mihda ya nan adi mihda.” ");
INSERT INTO ifb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Alyom hinan holag Israel di, Wa ay ta munhabi nan babai ta lala'iy intungawna ya mibilang hiyah adi maleneh hi pituy algaw an umat hinan pumpa'ahwanganah binulan. ");
INSERT INTO ifb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ya nan miyawalun algaw nan ung'ungnga ya mahapul an makugit. ");
INSERT INTO ifb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ya nan nuntungaw ya munhood hi tulumpulu ta tuluy algaw ya un mahkay mibilang hi naleneh nan dala an nalpuh odolnah din nuntungawana. At heden punhoodanah alenehana ya adi hiya mabalin hi mundapdapah nan malgom an me'gonan, ya adi goh umuy hinan Tuldan Abung ta engganay pungpungona nan algaw an alenehana. ");
INSERT INTO ifb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ya wa ay ta muntungaw, ya babai, ya un duway dumingguy ibilanganah adi maleneh an umat hinan pumpa'ahwanganah binulan an mibilang hiyah adi maleneh. Ya pungpungona ta magtud di nanom ta han onom di algaw ya un mahkay ma'ali hiyah maleneh hinan dala an nalpuh odolnah din nuntungawana. ");
INSERT INTO ifb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ya wa ay ta nagtud an napungpung nan algaw an ibilanganah maleneh hinan nangitungawanah nan babai unu lala'i ya mahapul an iyalinay ohah kalnilu an ohay tawona, ya indatnah nan padi ta me'nong hinan way hinagang di pantaw di Me'gonan an Kuwaltun a'amungan ta Onong an Moghob, ya iyalina goh di ohah bunun an putta unu balug ta Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ta e'nong nan padi ay Apo Dios ta onong an mangulah hinan adina alenehan hinan nuntungawana ta mibilang hi maleneh hinan bumuhu' an din dalan nalpuh odolna. Hiyatuy uldin hinan binabai an muntungaw hi lala'i unu babai. ");
INSERT INTO ifb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ya wa ay ta nan nuntungaw ya adina abalinan an mange'nong hi ohah uyaw an kalnilu ya mabalin di duwah putta unu duwah balug ta nan oha ya Onong an Moghob, ya nan oha ya Onong di Bahol. At nan padi ya e'nongna ta way atonan mibilang hi maleneh.” ");
INSERT INTO ifb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ya inalin Apo Dios ay da Moses ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Wa ay di nabdu', unu pogha, unu binumlah hinan up'up di tagu ta numbalin hi loghap unu palla' ya mahapul an miyuy hinan Nabagtun Padin hi Aaron unu nan ohah nan linala'in imbabaluynan padi. ");
INSERT INTO ifb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ya hamadon nan padiy aat nan poghan nan up'up. Ya gulat ta nan dutdut hinan way pogha ya pimmaha' ya mattig an linumnod nan pogha, at hene ya palla', at hamadon nan padi ya unna alyon an mibilang hiyah adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mu gulat ta nan dogoh di up'up ya mumpaha' an agguy linumnod ya nan dutdutna ya agguy pimmaha' ya un ilahhin nan padi nan tagun way dogohnah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ya nan apitun di algaw ya hamadon goh nan padiy aat nan poghah nan up'up nen tagu. Ya gulat ta hay pannig nan padih nan pogha ya un hihidya an agguy dimmala'da' ya ilahhina damdama hiya goh hi pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ya nan apitun goh di algaw ya hamadon goh nan padi nan dogohna. Ya gulat ta nan poghana ya na'giman an agguy dimmala'da' ya unna mahkay alyon di hiya ya mibilang hi maleneh. Ti nan dogohna ya un pogha ya anggay. At henen tagu ya mahapul an iloba'nay lubungna, at mibilang hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mu gulat ta nalpah an inalin nan padi an hiya ya maleneh mu dimmala'da' nan poghana ya mahapul an mumbangngad hinan padi. ");
INSERT INTO ifb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ta hamadon goh nan padi an biliyon nan dogoh, ya gulat ta dimmala'da' at alyon goh nan padi an henen tagu ya mibilang hi adi maleneh ti nan dogoh di up'upna ya umalin. ");
INSERT INTO ifb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ya gulat ta nan tagu ya nundogoh hi palla' ya mahapul an miyuy hinan padi ");
INSERT INTO ifb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ta nan padi ya hamadona nan dogohna. Ya gulat ta pimmaha' nan poghah nan up'upna, ya pimmaha' goh nan dutdut, ya waday mungngengelah nan pogha ");
INSERT INTO ifb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ya mattig an hene ya nabayag an palla' di up'up di odolna, at nan padi ya alyonay, He\"a ya mibilang hi adi maleneh. Mu adi hiya milahhin ti na'innilaan an waday palla'na. ");
INSERT INTO ifb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ya gulat ta dimmala'da' nan palla' hinan up'upna ta hay pannig nan padi ya nalipuh nan odolna an nete\"ah uluna ta engganay hu'ina ");
INSERT INTO ifb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ya mahapul an ihamad nan padi an biliyon hi un immannung an nan dogohna ya linipuhnay odolna ya unna alyon di ma'ali hiyah maleneh. Ti an amin nan odolna ya pimmaha' an na'giman nan poghana, at hiya ya mibilang hi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mu gulat ta waday limmutngingih mungngengelah nan lamoh ya mibilang hiyah adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","At tigon ay nan padi an waday mungngengelah nan lamoh ya alyonay mibilang hiyah adi maleneh. Ti nan mungngengela ya mibilang hi adi maleneh, at henen dogohna ya palla'. ");
INSERT INTO ifb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ya gulat ta napoyanan nan mungngengela an lamoh ta numbalin hi mumpaha' ya mahapul goh an umuy hinan padi ");
INSERT INTO ifb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ta nan padi ya hamadona goh nan poghana. Ya gulat ta nan poghah nan up'up ya pimmaha' at nan padi ya alyonay, Maleneh heten tagun way dogohna! Ya mibilang hi maleneh ti napoyanan di poghana. ");
INSERT INTO ifb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ya gulat ta waday poghan nan up'up, mu napoyanan, ");
INSERT INTO ifb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ya nan bilat an poyan nan pogha ya waday mabdu' an mumpaha' unu mumbolah ya mahapul an umuyna ipattig hinan padi. ");
INSERT INTO ifb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","At hamadon nan padiy aat nan pogha, ya gulat ta linumnod ya nan dutdut hinan pogha ya pimmaha' at alyon nan padih mibilang hiyah adi maleneh. Ti hene ya umalin an dogoh di up'up an nete\"ah nan bilat an poyan nan pogha. ");
INSERT INTO ifb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mu gulat ta nan padi ya hinamadna ta mi'id mumpaha' hi dutdut hinan pogha, ya agguy pimmaha', ya agguy goh linumnod, an un ma'giman ya ilahhin nan padi hiyah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mu gulat ta dumala'da' hinan up'up ya alyon nan padiy mibilang hiyah adi maleneh ti hene ya umalin an dogoh. ");
INSERT INTO ifb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mu gulat ta nan mumbolah an nabdu' ya agguy nalumluman di aatna an agguy dimmala'da' an un tuwali poghah nan bilat at alyon mahkay nan padiy mibilang hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ya gulat ta nan tagu ya waday timmubuh nabdu' hinan bilat hinan up'up ta pumaha' unu bumlah nan lamoh ");
INSERT INTO ifb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ya mahapul an hamadon nan padi an biliyon nan pogha. Ya gulat ta nan dutdut hinan pogha ya pimmaha' ya mattig goh an linumnod heden pogha ya umalin nan umat hinan dogoh an unna ingga'id hinan pimmoghaana. At nan padi ya alyonay mibilang hiyah adi maleneh ti umalin nan dogohna. ");
INSERT INTO ifb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mu gulat ta hinamad nan padi, ya mi'id di mumpaha' an dutdut hinan way pogha, ya agguy linumnod an na'uy an ma'giman ya un ilahhin nan padi hiyah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ya nan apitun di algaw ya hamadon goh nan padi nan poghana. Ya gulat ta dimmala'da' hinan up'up ya alyon nan padih mibilang hiyah adi maleneh. Ti hene ya umalin an dogoh. ");
INSERT INTO ifb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mu gulat ta un hihidyay aatna an agguy dimmala'da' hinan up'up an un na'giman at un tuwali hay pimmogha ya anggay, at nan padi ya alyonay ma'ali hiyah maleneh. Ti un tuwali poghah nan bilat di up'up. ");
INSERT INTO ifb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ya gulat ta nan lala'i unu babai ya waday poghah uluna unu pangalna ");
INSERT INTO ifb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ya hamadon nan padi an biliyon nan pogha. Ya gulat ta linumnod hinan up'up ya nan buu' ya muntittitilaw ya yimmapit at alyon nan padiy mibilang hiyah adi maleneh. Ti hene ya umalin an dogoh di ulu unu pangal. ");
INSERT INTO ifb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mu gulat ta hinamad nan padi nan umalin an dogoh hinan ulu ta agguy linumnod ya mi'id di mangmangitit hi buu' hinan pogha, ya un ilahhin nan padi hiyah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ya nan apitun di algaw ya hamadon goh nan padi an biliyon nan pimmogha. Ya gulat ta agguy dimmala'da', ya mi'id muntittitilaw hi buu' hinan pogha, ya agguy linumnod hinan up'up ");
INSERT INTO ifb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ya mahapul an gidgidanda hiya, mu adida nan awadan di poghah nan uluna, ya ilahhin goh nan padi hiyah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ya heden apitun di algaw ya hamadon goh nan padi nan poghana, ya gulat ta agguy dimmala'da' hinan up'up ya agguy linumnod ya alyon nan padin hiya ya mibilang hi maleneh. Ya mahapul an iloba'na nan lubungna, at malenehan hiya. ");
INSERT INTO ifb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mu gulat ta nan pogha ya dimmala'da' hi nalpahan di nangalyan nan padi an hiya ya maleneh ");
INSERT INTO ifb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ya hamadon goh nan padi an biliyon hiya. Ya gulat ta dimmala'da' hinan up'up ya adi mahapul hi un tigon nan padih un waday muntittitilaw hi buu' hinan pogha ti henen tagu ya adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ya gulat ta hay pannig nan padi ya agguy nalumluman di aatna ya waday timmubuh mangmangitit an buu' at nan pogha ya napoyanan. Ya alyon nan padiy ma'ali hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ya gulat ta nan lala'i unu babai ta waday ahipapaha' hinan up'upna ");
INSERT INTO ifb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ya hamadon nan padi. Ya gulat ay ta adi ma'appaha' an un mun'oldap at un tuwaliy kolol nan up'up, at maleneh hiya. ");
INSERT INTO ifb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Ya gulat ta nan lala'i ya nun'a'agah di buu'na ta matuga'an mu maleneh hiya. ");
INSERT INTO ifb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ya gulat ta nun'a'agah di buu' hinan tu'paw nan lala'in natuga'an mu ma'ali hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mu gulat ta bumlah an mumpahpaha' an nabdu' hinan natuga'an an uluna unu tu'tu'na ya hene ya umalin an dogoh an nalmuh uluna unu nan tu'pawna. ");
INSERT INTO ifb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","At nan padi ya hamadona nan nabdu'. Ya gulat ta henen nabdu' hinan uluna an natuga'an unu tu'pawna ya mumbolah an mumpahpaha' an umat hinan umalin an dogoh di up'up ");
INSERT INTO ifb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ya heden tagu ya napalla', at mibilang hiyah adi maleneh. At nan padi ya alyonay mibilang hiyah adi maleneh ti dumalat nan nabdu' hinan uluna unu tu'pawna. ");
INSERT INTO ifb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ya nan tagun waday palla'na ya umalin nan dogohna ya mahapul an hay nun'abi\"i an lubung di ilubungna. Ya adi munhugud, ya hophopanay godwan di angahna, ya it'u'nan mangalih, Adia' maleneh! Adia' maleneh! ");
INSERT INTO ifb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ya gulat ta hihidyay dogohna an adi ma'aan at adi hiya mibilang hi maleneh, at mahapul an mun'ohhan munhitu. Ya hay punhituwana ya nan nibataan hinan immapalanda ta engganay un umadaog nan umalin an dogohnan palla'.” ");
INSERT INTO ifb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ya himmapit hi Apo Dios goh ay da Moses ay Aaron an inalinay, “Gulat ta nabutan nan lubung an wool, unu linen, ");
INSERT INTO ifb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","unu nan na'abol, unu nan malgom an lalat di niyamma, ");
INSERT INTO ifb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ya gulat ta nan mabutan an lubung, unu lalat, unu nan na'abol, unu na'ekot ta munlangta unu mumbolbolah nan nabutan ya hiyah ne han dumala'da', at mahapul an mipattig hinan padi. ");
INSERT INTO ifb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","At nan padi ya hamadona nan nabutan, ya inlahhinah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ya nan apitun di algaw ya hamadona goh. Ya gulat ta dimmala'da' hinan lubung, unu na'abol, ya na'ekot, unu nan lalat an gina'u ya mibilang hi adi maleneh ti nan nabutan ya adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","At mahapul an gohbona nan nabutan an lubung, unu na'abol, unu nan na'ekot, unu nan wool, unu linen, unu lalat. Ti nan umat hinan buut ya puma\"i, at mahapul an ma'apuyan ta moghob. ");
INSERT INTO ifb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mu gulat ta hinamad ay nan padi an nan nabutan ya agguy dimmala'da' hinan lubung, unu nan na'abol, unu nan na'ekot, unu nan lalat ");
INSERT INTO ifb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ya ipaloba' nan padi nan gina'u, ya inlahhina goh hi pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ya ihamad nan padi an biliyon nan gina'u an naloba'an. Ya gulat ta nan nabutan ya agguy nalumluman di kololna ya agguy dimmala'da' ya mibilang hi adi maleneh. Ya mahapul an gohbonah apuy an ta\"on hi un hay tu'yapna unu hay balinay nabutan ya anggay. ");
INSERT INTO ifb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ya gulat ta hamadon nan padi ta nan nabutan ya immuphat hidin nalpahan di niloba'ana at pi\"ion nan padi nan nabutan hinan lubung ta ma'aan, unu nan lalat, unu nan inabol, unu nan na'ekot. ");
INSERT INTO ifb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Mu gulat ta mabutan goh ta dimmala'da' hinan lubung, unu nan lo'ob an na'abol, unu nan na'ekot, unu nan gina'un lalat ya mahapul an gohbon nan ad bagih nan apuy ta magbu. ");
INSERT INTO ifb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ya nan lubung, unu nan lo'ob, unu nan na'ekot, unu nan numbino'ob'on an gina'un lalat an niyamma ya gulat ta niloba' ta na'aan nan nabutan ya mahapul an mipidwan miloba' goh ya un mibilang hi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ya hiyatuy uldin hi ma'at hinan mabutan an wool, unu linen an lubung, ya nan na'abol, unu nan na'ekot, unu nan niyamman nalpuh lalat ya unda ma'alih mibilang hi maleneh unu adi maleneh.” ");
INSERT INTO ifb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Hiyatuy uldin hi ma'at hinan tagun napalla' hi gutud di alenehanah nan dogohna. Hiya ya mahapul an miyuy hinan padi. ");
INSERT INTO ifb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ya ibataan nan padi hiyah nan immapalanda ya unna hamadon an biliyon nan way dogohnah palla' hi un immannung an napoyanan, ");
INSERT INTO ifb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ya ipa'alan nan padiy duwah matagun hamuti an maleneh, ya hay ayiw an cedar, ya hay mumbolah an linubid, ya hay holo' an hanganga an ma'alih hyssop. ");
INSERT INTO ifb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ya imandal nan padi ta goltonda nan ohan hamutih nan lutan bangan nittuwan hi danum an nahagub hi obob. ");
INSERT INTO ifb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ya alana nan matagun hamuti, ya nan ayiw an cedar, ya nan mumbolah an linubid, ya nan holo' an hanganga an ma'alih hyssop, ya inhawhawna didah nan dalan nan hamutin naglot hinan bangan nittuwan hi danum an nahagub hi obob. ");
INSERT INTO ifb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ya impapituna an iwalhi nan dalah nan tagun malenehan hinan dogohnan palla' ya unna mahkay alyon an ma'ali hiyah maleneh. Ya innayuna an ipatayap din matagun hamuti hinan payaw. ");
INSERT INTO ifb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ya heden tagun nalenehan ya iloba'nay lubungna, ya ginidgidanan amin di buu'na, ya nun'amoh ya un ma'ali an hiya ya maleneh. Ya nalpah ay hene ya mabalin mahkay an umuy hinan immapalanda, mu adi humgop hinan abungna ta nan gettaw di ihihinnanah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ya nan apitun di algaw ya mahapul an gidgidana goh an amin di buu'na, ya hamayna, ya idoyna, ya nan udumnan buu' hi odolna. Ya inloba'nay lubungna, ya nun'amoh, at ma'ali an hiya ya maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ya nan awalun di algaw ya mahapul an iyalinay duwah bubuta'al an kalniluh mi'id ah ganitna ya ohah tennan ohay tawonan uyaw an kalnilun mi'id ah ganitna. Ya iyalina goh di onom ya han godway kiluh nan na'adyamu' an alenan mantikaana, ya godwah litron mantikan di olibo. ");
INSERT INTO ifb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ya nan padiy mangiyuy eden tagun malenehan ya nan e'nongnah nan way hinagang di pantaw nan Me'gonan an Kuwaltun awada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ya alan nan padiy ohah nan buta'al an kalnilu ta Onong di Nibahhawan ya unna alan nan godwan litron mantika, ya inlayatnan Ha\"in an Dios ta Onong an Milayat. ");
INSERT INTO ifb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ya genlotna nan kalniluh nan me'gonan an lugal an aglotan nan Onong di Bahol ya Onong an Moghob. Ti henen Onong di Nibahhawan ya bagin nan padi an umat hinan Onong di Bahol, ya me'gonan dane. ");
INSERT INTO ifb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ya alan goh nan padiy udum an dalan nan Onong di Nibahhawan, ya endenehnah agwan di ingan nan tagun ma'alih malenehan, ya edho'na goh hinan agwan di am'ama\"an di ngamayna ya nan agwan goh nan am'ama\"an di hu\"ina. ");
INSERT INTO ifb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ya alan nan padiy godwan di litron lana, ya inhiitnah iggid di ngamayna an tinapayana. ");
INSERT INTO ifb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ya inhiwhiw nan padi nan agwan an tudunah nan lana ta iwalhinah mumpapituh nan hinagang di awadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ya nan udum an lanan tinapayana ya endenehnah nan nangidenehanah dalan di Onong di Nibahhawan hinan ingan nan ma'alih malenehan, ya nan agwan di am'ama\"an di ngamayna, ya nan hu'ina. ");
INSERT INTO ifb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ya nan lanan tinapayana ya ihiitnah ulun nan tagun malenehan. At henen inat nan padiy hiyay munleneh eden taguh a'aliwan di numbaholana ta malenehan hinan numbaholanan Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ya e'nong nan padi nan Onong di Bahol, ya henen e'nong nan padiy mangaliw hi bahol nan ma'alin malenehan hinan dogohna. Ya malpah ay hene ya unna mahkay golton nan Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ya e'nong nan padih nan pun'onngan nan Onong di Bahol an middum nan Onong an Ma'an, at henen aton nan padiy a'aliwan di bahol nen tagu, at ma'ali hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mu gulat ta hay nawotwot an adina abalinan an mun'onong hi umat hinan nangina ya iyalina damdamay ohah buta'al an kalnilu ta Onong di Nibahhawan ta way a'aliwan di baholna. Ya middum goh nan duway kilun na'adyamu' an alena ya namantikaan ta Onong an Ma'an, ya nan godwah litron mantika. ");
INSERT INTO ifb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ya iyalina goh di abalinanan e'nong an duwah balug unu duwah bunun an putta. Ta nan oha ya Onong di Bahol, ya Onong an Moghob nan oha. ");
INSERT INTO ifb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ya nan awalun di algaw an ma'ali hiyah maleneh ya iyuyna hatuh nan padih nan way hinagang di pantaw nan Me'gonan an Kuwaltun pundayawan nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ta alan nan padi nan uyaw an kalnilu an Onong di Nibahhawana ya nan godwan di litron mantika, ya inlayatnan Ha\"in an Dios ta Onong an Milayat. ");
INSERT INTO ifb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ya golton nan padiy kalnilu, ya innalnay udumnan dalana ta edenehnah nan agwan an ingan nen ad onong, ya nan agwan di am'ama\"an di ngamayna, ya nan ongol an galaygay hinan agwan an hu'ina. ");
INSERT INTO ifb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ya alan nan padiy godwan di litron lana, ya inhiitnah iggid di ngamayna an tinapayana. ");
INSERT INTO ifb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ya inhiwhiw nan padi nan agwan an tudtudunah nan lana ta iwalhinah mumpapituh nan hinagang di wada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ya nan udum an lanan tinapayana ya endenehnah nan nangidenehanah nan dalan nan Onong di Nibahhawanah nan agwan an ingan nan ma'alih malenehan, ya nan agwan di am'ama\"an di ngamayna, ya nan ongol an galaygay hinan agwan an hu'ina. ");
INSERT INTO ifb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ya nan na'angang an lanan tinapayana ya ihiitnah ulun nan tagun malenehan. At henen inat nan padiy munleneh eden taguh numbaholana ta malenehan hinan numbaholanan Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ya ene'nongna nan balug unu nan bunun an putta an hiyah ne abalinanan iyalin e'nong ");
INSERT INTO ifb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ta nan oha ya Onong di Bahol, ya Onong an Moghob goh nan oha an middum hinan Onong an Ma'an. Ya henen e'nong nan padiy a'aliwan di numbaholanan Ha\"in an Dios, at malenehan goh di dogohna. ");
INSERT INTO ifb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ya hiyanay uldin hi aton nan nawotwot an way dogohnah palla' an mid pangngalanah e'nongnah nan onong di alenehan ta ma'ali hiyah maleneh.” ");
INSERT INTO ifb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ya ni'hapit hi Apo Dios ay da Moses ay Aaron an inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Wa adya ta dumatong ayuh nan lutad Canaan an idat'un da'yu ta lutayu, ya inyabulut'uy abuutan nan abung eden luta, ");
INSERT INTO ifb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ya nan nunhitu eden abung an nabuutan ya umuyna ibagah nan padi an alyonay, Waday tinnig'un ay ihunay buut hinan abung'u. ");
INSERT INTO ifb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ya mandalon nan padi dida ta ipalahundan amin nan gina'un wah nan abung ta adida mitagam an ma'alih adida mibilang hi adi maleneh ya unna umuy hamadon. Ya nalpah ay an nilahun an amin nan gina'u ya un mahkay humgop nan padi ta bilbiliyona nan abung. ");
INSERT INTO ifb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ta hamadonay aat nan nabuutan hinan dedeng ta gulat ay ta munlangta unu mumbobbobollah nan nete\"aana ya linumnod hinan dedeng ");
INSERT INTO ifb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ya bumuhu' nan padih nan abung, ya intangobna, ya mahapul an adi mibugbughul henen abung hi pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ya nan apitun di algaw ya mumbangngad nan padi ta hamadona goh nan abung. Ya gulat ta nan buut ya dimmala'da' hinan dedeng ");
INSERT INTO ifb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ya ipa'aan nan padi nan dedeng an nabuutan, ya ekakdah nan babluy ta ipitapalnah nan ma'alih adi maleneh an nibataan hinan babluy. ");
INSERT INTO ifb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ya mahapul an ipa'uh'uhnan amin di numpunliniblib nan dedeng hi bunol nan abung ya nan nun'a'uh'uhan an na'aan hinan dedeng, ya ipitapalnah nan ma'alih adi maleneh an lugal an nibataan hinan babluy. ");
INSERT INTO ifb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ya inummaldah udum an batu ta ihukatdah nan inaandan batu, ya innalda goh nan pa\"alan uklit, ya linitada nan dedeng nan abung. ");
INSERT INTO ifb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ya gulat ta malpah an nahukatan nan nabuutan an batu ya na'uh'uhan nan numpunliniblib an dedeng ya nalita goh mu numbangngad ay nan buut hinan baluy ");
INSERT INTO ifb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ya mahapul an mumbangngad goh nan padi ta hamadona nan abung. Ya gulat ta dimmala'da' nan nabuutan at ma'alih nen abung hi adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","At mahapul hi ipaba'ahna nan abung ta an amin nan niyammah alimatungna an nan batu, ya nan ayiw, ya an amin nan nilita ya mekak hinan babluy ta miyuy hinan ma'alih adi maleneh an lugal. ");
INSERT INTO ifb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ya an amin nan humgop enen abung hidin nangipitangoban nan padi ya ma'alidah adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ya nan mangan unu molo' enen abung ya mahapul an iloba'nay lubungna. ");
INSERT INTO ifb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mu gulat ta nalpah ay an nalita nan dedeng di abung ya mumbangngad nan padi ta hamadona ta agguy ay dimmala'da' nan buut ya alyonay, Maleneh nan abung ti mi'id mahkay nan buut! ");
INSERT INTO ifb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ya ta ma'alih maleneh heden abung ya mahapul an idat nan ad abung hinan padiy duwah hamuti ya hay penpenton an cedar, ya hay mumbolah an linubid, ya nan holo' an hanganga an ma'alih hyssop ta hiyay punlenehnah nan abung. ");
INSERT INTO ifb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ya golton nan padiy ohah nan hamutih nan tungul nan lutan bangan nittuwan nan pa'ahhagub an danum. ");
INSERT INTO ifb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ya innalna nan penpenton an cedar, ya nan holo' an hanganga an ma'alih hyssop, ya nan mumbolah an linubid, ya nan matagun hamuti, ya inhawhawna danen amin hinan dalan nan naglot an hamutih nan bangan nittuwan nan pa'ahhagup an danum, ya inwalhinah mumpapituh nan abung. ");
INSERT INTO ifb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ya lenehana nan abung hinan dalan di hamuti, ya nan pa'ahhagub an danum, ya nan matagun hamuti, ya nan penpenton an cedar, ya nan holo' an hanganga an ma'alih hyssop, ya nan mumbolah an linubid. ");
INSERT INTO ifb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ya impatayap nan padi din matagun hamuti ta ipluynah nan payaw ya nan ongol an babluy, ya henen atonay munleneh enen abung ta malenehan. ");
INSERT INTO ifb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ya hiyanay uldin hi ma'at hi un way umalin hi dogoh an palla', ya nan udum an dogoh, ");
INSERT INTO ifb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ya nan umat hinan nabuutan an lubung unu abung, ");
INSERT INTO ifb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ya umat hinan way nun'abdu' unu nan loghap, ");
INSERT INTO ifb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ta way pangimmatunan hinan maleneh ya adi maleneh. Hiyatuy uldin hi ma'at hinan dogoh an palla' di up'up ya nan mabuutan.” ");
INSERT INTO ifb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ya ni'hapit hi Apo Dios ay da Moses ay Aaron an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Alyonyuh nan holag Israel di, Wada ay di lala'i an waday nappuhin bumuhu' hi odolna ya henen bumuhu' hi odolna ya ma'ali an adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ya hiyah te aat nan gun bumuhu' hinan odol an ta\"on un dimminong unu minaynayun an gun bumuhubuhu', ya ma'ali an hiya ya adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ya an amin nan olo'an nan lala'in way nappuhin bumuhu' hi odolna ya heden nolo'ana ya ma'alih adi maleneh, ya an amin nan umbunana goh ya adi maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ya nan manapah nan nolo'ana ya mahapul an iloba'nay lubungna, ya mun'amoh, mu adi damdama hiya ma'alih maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ya nan umbun hinan malgom an inumbunan nan lala'in waday nappuhin bumuhu' hi odolna ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'alih maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ya nan manapah nan tagun waday nappuhin bumuhu' hi odolna ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'ali an maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ya gulat ta nan tagun way nappuhin bumuhu' hi odolna ya tinugpaana nan maleneh an tagu ya henen tagu an natukpaan ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'ali an maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ya nan inumbunan nan taguh nan puntakayana ya ma'ali an adi maleneh, ");
INSERT INTO ifb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ya nan manapah nan malgom an inumbunana ya ma'ali an hiya ya adi maleneh, ya nan mangdon ay danen inumbunana ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'alih maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ya nan tagun waday nappuhin bumuhu' hi odolna an agguyna inihuan di ngamayna ya dinapana han tagu ya heden dinapana ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'alih maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ya nan lutan bangan dapoon nan tagun waday bumuhu' hi odolna ya mahapul an mapohla', ya umat goh hinan malgom an ayiw di niyamma, ya mahapul an ma'ulahan hi danum. ");
INSERT INTO ifb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ya wa adya ta dimminong nan bumuhu' hi odolna ya mahapul an pungpungonay pituy algaw ya unna mahkay iloba' di lubungna, ya nun'amoh hinan pa'ahhagub an danum ya un ma'ali an hiya ya maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ya nan awalun di algaw ya mahapul an iyalinay duwah balug unu duwah bunun an putta, ya inyuynah nan way hinagang di awadan Apo Dios hinan pantaw nan Me'gonan an Kuwaltun a'am'amungan, ya idatnah nan padi. ");
INSERT INTO ifb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ta nan padiy mange'nong ta nan oha ya Onong di Bahol, ya nan oha ya Onong an Moghob. Ya henen e'nong nan padi ay Apo Dios di munleneh hinan tagu an waday nappuhin bumuhu' hi odolna. ");
INSERT INTO ifb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Ya gulat ta waday bumuhu' hinan bagin nan lala'i ya nan lala'i ya mahapul an mun'amoh, mu adi damdama hiya maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ya malgom nan lubung unu gina'un lalat an natidtidan eden bimmuhu' eden lala'i ya mahapul an miloba', ya ma'ali an adi damdamah maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ya wa adya ta elo' nan lala'i nan babai ta waday bumuhu' eden lala'i ya mahapul an mun'amohdan duwah nan danum, ya ma'ali an adida damdama maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Ya wa adya ta mumpa'ahwang nan babai ya ma'ali an adi hiya maleneh hi pituy algaw, ya wa adyay manapan hiya ya adi hiya maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ya nan malgom an olo'ana eden pumpa'ahwangana ya adi goh maleneh, ya nan malgom goh an umbunana ya adi goh maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ya nan manapah nan nolo'ana ya mahapul an iloba'nay lubungna ya nun'amoh, ya adi hiya damdama maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ya nan manapah nan malgom an umbunana ya mahapul an iloba'nay lubungna ya nun'amoh, ya adi hiya damdama maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ya malgom hinan nolo'ana unu inumbunana ta waday manapa ya ma'ali an hiya ya adi maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ya gulat ta elo' nan lala'i nan babai ta mideneh nan dala an impa'ahwangna ay hiya ya ma'alin adi goh maleneh heden lala'ih pituy algaw, ya amin nan olo'ana ya adi goh maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ya wada ay di babain waday bumuhu' hi dalah odolna, mu bo'on tuwali nan binulan an pumpa'ahwangana, unu mumpa'ahwang hinan binulan tuwali mu un adi dumindinong eden angunuh di pumpa'ahwangana ta un minaynayun ya heden babai ya ma'alin adi maleneh an umat hinan pumpa'ahwangana. ");
INSERT INTO ifb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ya an amin nan olo'ana ya ma'alih adi maleneh an umat hinan olo'anah nan gutud di binulan an pumpa'ahwangana tuwali, ya an amin goh nan umbunana ya ma'alih goh hi adi maleneh an umat goh hinan binulan an pumpa'ahwangana. ");
INSERT INTO ifb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ya nan manapah nan nolo'ana unu inumbunana ya mibilang hi adi maleneh, at mahapul an iloba'nay lubungna ya nun'amoh ya un mahkay ma'ali an hiya ya maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ya hay atdu'an nan bumuhu' hi odolna ya mahapul an pungpungonay pituy algaw ya un ma'ali hiyah maleneh. ");
INSERT INTO ifb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ya hinan awalun di algaw ya mahapul an alanay duwah balug unu duwah bunun an putta, ya inyuynah nan padih nan way pantaw nan Me'gonan an Kuwaltun a'am'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ta nan padi ya e'nongnay oha ta Onong di Bahol, ya nan oha ya Onong an Moghob. Ya henen ene'nong nan padin Apo Dios di munleneh eden babai ta malenehan nan bumuhu' hi odolna. ");
INSERT INTO ifb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ya mahapul an halimunanyu nan holag Israel hinan pangatandah nan ipawan di Uldin, ti adiyu ay aton ya matoydah unda puhion nan Me'gonan an Kuwaltu an wagwadan dida. ");
INSERT INTO ifb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","At hiyanay uldin hi mahapul an ma'at hinan lala'in waday nappuhin bumuhu' hi bagina, unu nan bumuhu' an nan mumpaha' hinan bagina, ");
INSERT INTO ifb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ya nan babain mundogoh an dumalat nan pumpa'ahwangana, ya nan lala'i unu babai an waday bumuhu' hi odolna, ya nan lala'in mangelo' hinan babain adi maleneh.” ");
INSERT INTO ifb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ya ni'hapit hi Apo Dios ay Moses hidin nalpahan di natayan nan duwan imbabaluy Aaron hidin himmigupandah nan awadan Apo Dios ya natoyda. ");
INSERT INTO ifb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ya inalin Apo Dios ay Moses di, “Alyom ay agim an hi Aaron ta adi un nonong ya himmigup hinan Nidugah an Me'gonan an Kuwaltuh nan pangngel di kultina an awadan nan Kahon an Nittuwan nan Himpulun Uldin ta adi hiya goh matoy. Ya manu ay umat hina ti wagwadaa' hinan bunut an nipopotto' hinan alub hi awadan nan Ma'ahhimo' an wah nan Kahon. ");
INSERT INTO ifb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","At heden algaw an humgopan Aaron hinan Nidugah an Me'gonan an Kuwaltu ya mahapul an iyuynay ohah manilhig an bakah Onong di Baholyu ya buta'al an kalnilu ta Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ya omhonan amin di odolnah mahhun ya unna ilubung nan me'gonan an lubungna an nan magayad, ya nan putut an pantalon, ya ibol'ohna nan napinuy abolna, ya iyuklupna goh nan napinuy abolna an uklup. ");
INSERT INTO ifb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ya idat nan holag Israel ay hiyay duwah buta'al an gandeng ta nan oha ya Onong di Baholna, ya nan ohan buta'al an kalnilu ya Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ya iyuy Aaron nan manilhig an baka ta Onong di Baholna, ya e'nongna ta way a'aliwan di baholna ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ya alana nan duwan gandeng ta iyuynah nan way hinagang di awada' an Dios hinan way pantaw nan Me'gonan an Kuwaltun a'amungan. ");
INSERT INTO ifb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ya iyamman Aaron di duwan ma'u'nuh ta panginnilaan hi un ngadan ay daden duwan gandeng di midat ay Ha\"in an Dios, ya hay ngadan ay diday mipalayaw. ");
INSERT INTO ifb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","At alan Aaron nan gandeng an na'u'nuh hi midat ay Ha\"in an Dios ta e'nongnah Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mu nan gandeng an mipalayaw ya nonong heden matagun gandeng ya inyalidah nan awadan di hinagang'u an Dios ta a'aliwan di baholda ya unda ipalayaw hinan mapulun. ");
INSERT INTO ifb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ya iyalin Aaron di manilhig an baka ta Onong di Baholna, ya geneto'na, ya ene'nongna ta ma'aliwan di baholna ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ya alana han duyun napnuh munggalangagang an balan nalpuh nan pun'onngan hinan way hinagang di wada' an Dios, ya inakupna nan nagimu' an incense an maphod di hunghungna, ya enehgopnah nan Nidugah an Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ya inittuna nan incense hinan munggalangagang an balah nan way hinagang'un Dios ta umahu' heden incense, at haniana nan alub hi awadan nan Ma'ahhimo' an wah nan Kahon an Nittuwan di Himpulun Uldin Apo Dios ta way atonan adi matoy. ");
INSERT INTO ifb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ya umalah nan dalan nan ene'nongnan manilhig an baka, ya inhiwhiwna nan galaygaynah nan dala, ya inwalhinah nan balitu' an alub hi awadan nan Ma'ahhimo' an wah nan Kahon ya unna walhian goh hi mumpapitu nan hinagang di Kahon an Nittuwan di Himpulun Uldin. ");
INSERT INTO ifb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ya goltona goh nan gandeng an Onong di Bahol di tatagu, ya inyuyna nan dalah nan Nidugah an Me'gonan an Kuwaltu an wada' an Dios, ya atona goh din inatnah din dalan nan manilhig an baka an iwalhinah nan balitu' an alub hi awadan nan Ma'ahhimo' an wah nan Kahon hinan way hinagang'u. ");
INSERT INTO ifb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ya mun'onong nan Nabagtun Padi ta munleneh hinan Nidugah an Me'gonan an Kuwaltu an awada' an Dios ti dumalat nan adi umunudan nan holag Israel an gunda pangipa'odholan hi nomnomda, at nabaholanda. Ya umat goh hinay atonah nan Me'gonan an Kuwaltun a'amungan an wagwadaa' ay didah nan immapalanda an ta\"on unda nabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ya mahapul an mi'id ahan ah tatagun humigup hinan Me'gonan an Kuwaltun a'amungan hinan humgopan Aaron an umuy mun'onong ta malenehan nan Nidugah an Me'gonan an Kuwaltu, ya engganay un lumahun hi pangelpahanan mun'onong ta a'aliwan di baholna, ya didan hina\"ama, ya an amin nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ya lumahun mahkay ta umuy goh hinan pun'onngan an wah nan hinagang di wada' an Dios, ya onngana goh nan pun'onngan ta malenehan. Ya umalah nan dalan nan baka ya dalan goh nan gandeng, ya inlamuhnah nan ha'gud ya nan nunlene'woh hinan pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ya ihiwhiwna nan galaygaynah nan dala, ya winalhiana nan pun'onngan hi mumpapitu ta malenehan an ma'aan nan bahol di tatagun holag Israel, at nan pun'onngan ya me'gonan mahkay. ");
INSERT INTO ifb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ya wa ay ta enelpah Aaron an lenenehan nan Nidugah an Me'gonan an Kuwaltu, ya nan Me'gonan an Kuwaltun a'amungan, ya nan pun'onngan ya unna iyuy nan matagun gandeng. ");
INSERT INTO ifb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ya eh'an Aaron nan duwan ngamaynah nan ulun nan matagun gandeng, ya intutuyunan amin di bahol ya nan adida umunudan an holag Israel ta ipabnohnah nan ulun nan gandeng nan bahol nan tatagu, ya impalayawna nan gandeng, at dulunon nan tagun ad tamu ta ipluynah nan mapulun. ");
INSERT INTO ifb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","At impalayaw nan tagu nan gandeng hinan mapulun ta inlayawna nan bahol nan tagu an nipaboltan ay hiya ta inyuynah nan pa\"adagwin babluy an mi'id ah nunhitu. ");
INSERT INTO ifb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ya humgop hi Aaron hinan Me'gonan an Kuwaltun a'amungan, ya inaana nan inlubungnah din hinumgopanah nan Nidugah an Me'gonan an Kuwaltu, ya impatangnah di. ");
INSERT INTO ifb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ya nun'amoh hinan pun'amhan hidih nan me'gonan an lugal, ya inlubungna din lubungna tuwali, ya limmahun ta e'nongna nan Onong an Moghob ta ma'aliwan di baholna, ya e'nongna goh nan ohan Onong an Moghob ta ma'aliwan di bahol di tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ya gohbona goh hinan pun'onngan an amin nan taban nan Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ya nan pento'dan tagun nangipalayaw hidin gandeng hinan mapulun ya mahapul an iloba'nay lubungna, ya nun'amoh ya un umuy hinan immapalanda. ");
INSERT INTO ifb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ya nan baka ya nan gandeng an Onong di Bahol an nan ad dalah nan nehgop hinan Nidugah an Me'gonan an Kuwaltu an ne'nong hi a'aliwan di bahol ya mahapul an mekak ta mibataan hinan immapalanda ta nan up'upda, ya lamohda, ya nan minalutuda ya mahapul an gohbondan amin. ");
INSERT INTO ifb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ya nan tagun manghob ya mahapul an iloba'nay lubungna ya nun'amoh ya un mumbangngad an humigup hinan immapalanda. ");
INSERT INTO ifb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ya heten uldin ya unudonyuh enggana ti nan apulun di algaw hi apitun di bulan ya mahapul an ilangduanyu, ya adi ayu muntamu. Ya an amin ayun holag Israel an ta\"on nan bo'on holag Israel an ni'hitun da'yu ya hiyay atonyu. ");
INSERT INTO ifb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ti hiyah ne algaw hi pun'onngan nan Nabagtun Padi ta way a'aliwan di baholyu ta maleneh an mi'id baholyuh nan way hinagang'u an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ya hiyah te algaw hi pun'eblayanyu, at mahapul an ilangduanyu ti hiyah te uldin hi gunyu aton hi mi'id pogpogna. ");
INSERT INTO ifb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ya nan padin nahiitan hi lana ya nidawat an mihukat ay amana an Nabagtun Padi ta hiyay mange'nong hinan Onong di Bahol, at hay atona ya ilubungna nan napinuy abolnan lubung, ya nan me'gonan an lubung, ");
INSERT INTO ifb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ya nun'onong ta malenehan nan Nidugah an Me'gonan an Kuwaltu, ya nan Me'gonan an Kuwaltun a'amungan, ya nan pun'onngan, ya onngana goh nan papadi ya an amin nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ya hiyah te inyuldin'uh inaynayunyun aton hi mamenghan hi hintawon ta way a'aliwan ya alenehan di baholyun holag Israel.” At inunuddan inat nan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ya ni'hapit hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Alyom ay da Aaron, ya nan linala'in imbabaluyna, ya an amin nan holag Israel di, Hiyah te immandal Apo Dios: ");
INSERT INTO ifb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Malgom hinan holag Israel an mangeto' hi baka, unu kalnilu, unu gandeng hinan immapalanda unu nibataan hinan immapalanda ");
INSERT INTO ifb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ta adina iyuy hinan way pantaw nan Me'gonan an Kuwaltun a'amungan ta e'nongnah nan way hinagang nan wadan Apo Dios ya hene han tagu ya mamolta an dumalat nan dalan nan nageto', ya mapogpog di iddumanah nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ya manu ay umat hinay ma'at ya ta way aton nan holag Israel an tuma'ot, at adi mahkay malgom di panglotandah nan gunda e'nong, ta iyuydah nan awadan Apo Dios, ya indatdah nan padih nan way pantaw nan Me'gonan an Kuwaltun a'amungan ta henen padiy mange'nong ay Apo Dios ta Onong hi Pi'lenggopan hi i'ibba. ");
INSERT INTO ifb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ya iwalhin nan padi nan dalah nan pun'onngan ay Apo Dios hinan way pantaw nan Me'gonan an Kuwaltun a'amungan, ya genhobna nan taba ta nan maphod an angilitnay mangipadenol ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ya manu ay umat hinay inyuldin Apo Dios ya ta way aton nan tatagun mangipogpog ta adida e'nong nan onongdah nan dimunyu an dayawonda ti paddungnay inlugtapandah Apo Dios an dumalat nan bululda an umat hi gandeng di tigawna. At nan holag Israel ya mahapul an henen niyuldin di unudonda, ya minaynayun an gun aton goh di holagdah udum di algaw hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ya alyom ay diday, Nan tagun niddum hinan holag Israel unu nan ni'hitun dida an bunag di mun'onong hi Onong an Moghob unu udumnan kalahin di onong ");
INSERT INTO ifb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ya adina iyuy hinan way pantaw nan Me'gonan an Kuwaltun a'amungan ta e'nongnan Apo Dios ya hene han tagu ya pogpogonyuy iddumanah nan tatagun Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ya nan holag Israel unu nan himpangilin bunag an ni'hitun dida an mangihdah dala ya du'gona ahan, ya pogpogonay iddumanah nan tataguna. ");
INSERT INTO ifb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ti immannung an nan dalay aptan hi ataguan, at hiyanan hay dalay a'aliwan di bahol. ");
INSERT INTO ifb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","At hiyah ne dumalat hi pangipawaan Apo Dios hi pangihdan nan holag Israel hinan dala, ya ta\"on nan himpangilin bunag an ni'hitun dida ya mipawa goh ta adida ihda. ");
INSERT INTO ifb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ya malgom goh hinan tagun holag Israel unu nan himpangilin bunag an ni'hitun dida an umuy manganup ya wada ay di inanupandah nan animal unu hamuti, ya gulat ta ihdada ya goltondah mahhun ta matidtidan di dalana, ya ginabunandah luta. ");
INSERT INTO ifb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ti manu ay matagu nan malgom an animal ya hamuti ya nan dalay dumalat hi ataguanda. At hiyah ne dumalat hi nangiyuldinan Apo Dios hinan holag Israel an adida ahan ihday dala ti nan dala ya hiyay mangidat hi pi'taguan, at hiyaat un nan mangihdah dala ya mahapul an mapogpog di iddumanah nan taguna. ");
INSERT INTO ifb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ya an amin nan mangihdah nan nanattoy an animal unu un pinatoy di animal hi inalahan ya mahapul an iloba'nay lubungna ya nun'amoh, mu adi damdama hiya ma'alih maleneh hi engganay mahdom. ");
INSERT INTO ifb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mu adina ay iloba' di lubungna ya adi goh mun'amoh ya hiyay okod an munholtap hi moltana.” ");
INSERT INTO ifb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ya ni'hapit hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Ha\"in hi Apo Dios an Diosyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ya adiyu enghon nan ato'atondad Egypt an din babluy an ni'hituwanyu, ya adiyu enghon nan ato'aton nan tatagud Canaan an babluy hi pangiyaya' ay da'yu. Ya adiyu unudon nan ato'atonda. ");
INSERT INTO ifb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","At mahapul an unudonyu nan imandal'uh atonyu, ya imayaanyu ta atonyu nan inyuldin'u ti Ha\"in hi Apo Dios an dayawonyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ya mahapul an unudonyu nan immandal'u ya nan Uldin'u ti nan tatagun mangat ya mangunud ya mid al'alin dida, at mataguda. Ti Ha\"in an hi Apo Dios di nangali. ");
INSERT INTO ifb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ya adiyu elo' nan babain neheggon di nitulanganan da'yu ti Ha\"in an hi Apo Dios di nangali. ");
INSERT INTO ifb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ya adiyu bainon hi amayuh nan pangelo'anyu ay inayu ti hiyah inayu, at adiyu elo'. ");
INSERT INTO ifb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ya adiyu goh elo' nan ahawan amayu ti hene mamain ay amayu. ");
INSERT INTO ifb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ya adiyu elo' nan babain pogtangyu an nan imbaluy amayu unu imbaluy inayu an ta\"on hi un nitungaw hi abungyu unu nan udum an babluy. ");
INSERT INTO ifb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ya adiyu elo' nan ap'apuyu an nan imbaluy nan lala'in imbaluyyu unu imbaluy nan babain imbaluyyu ti hene ya mabainan ayu. ");
INSERT INTO ifb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ya adiyu elo' nan babain imbaluy nan ahawan amayu ti imbaluy amayu, at hiya ya pogtangyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ya adiyu elo' nan antiyu ti pogtang amayu, at hiya ya tulangyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ya adiyu elo' nan babain pogtang inayu ti hiyah antiyu goh. ");
INSERT INTO ifb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ya adiyu bainon nan ulitaoyu an pogtang amayu, at adiyu elo' nan ahawana ti hiya ya hi antiyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ya adiyu elo' nan inapuyun babai ti hiya ya ahawan nan imbaluyyun lala'i, at adiyu elo' hiya. ");
INSERT INTO ifb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ya adiyu elo' nan ahawan nan pogtangyun lala'i ti henen atonyu ya mabainan nan pogtangyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ya adiyu elo' nan imbaluy unu binabain a'apun nan babain enelo'yu. Ti munhina\"agida, at hene ya na\"appuhi ahan. ");
INSERT INTO ifb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ya adiyu goh ahawaon nan pogtang di ahawayu ta iyadwayuh un mataguh ahawayu ti mumpattoyda. ");
INSERT INTO ifb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ya adiyu umuy elo' nan babaih nan awadan nan binulan an pumpa'ahwangana. ");
INSERT INTO ifb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ya adiyu elo' nan ahawan nan heneggonyu ti puhionyuy odolyu an dumalat nan inatyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ya adiyu iyabulut nan imbaluyyu an me'nong ay Molek ti bainona' ahan an Dios an dayawonyu. Ti Ha\"in an hi Apo Dios di nangali. ");
INSERT INTO ifb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ya adiyu elo' nan ibbayun lala'i an umat hinan atonyun mangelo' hinan babai ti hene ya agaga\"ihaw ahan an umipabain. ");
INSERT INTO ifb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ya adiyu undulon nan animal ti puhionyuy odolyu. Ya nan babai ya mahapul an adi umuy mumpa'undul hinan animal ti hene ya na\"appuhin ma'at an umipanoh'a. ");
INSERT INTO ifb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ya adiyu puhion di odolyuh nan malgom an umat hitun ma'at ti hiyatuy namuhih nan tatagun datnganyu an pinakak'u ");
INSERT INTO ifb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","an ta\"on nan luta ya pimmuhi. At moltao' an dumalat nan bahol, at mun'akak nan tatagu an paddungnay utaon nan luta nan numpunhituh di. ");
INSERT INTO ifb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ya mahapul an unudonyu nan imandal'u ya nan Uldin'u. At da'yun holag Israel ya nan himpangilin bunag an ni'hitun da'yu ya mahapul an adiyu aton nan agaga\"ihaw an umat hina ");
INSERT INTO ifb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ti an amin hatu ya hiyay ina'inat nan tatagun nunhituh nan lutan umayanyu, at nan luta ya nalugit an pimmuhi. ");
INSERT INTO ifb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","At gulat ta puhionyu nan luta at paddungnay utaon goh da'yu an umat hinan na'at hinan tatagun nunhituh nan lutan umayanyu. ");
INSERT INTO ifb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ya wa adyay mangat hinan umat hitun agaga\"ihaw ya henen tagu ya mahapul an mapogpog ta adi middum hinan tatagu'. ");
INSERT INTO ifb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","At unudonyu nan Uldin'u ta adiyu unudon nan agaga\"ihaw an ugalin nan tatagun nunhituh nan lutan umayanyu ta adiyu puhion di odolyuh nan pangatanyuh nan umat hina. Ti Ha\"in hi Apo Dios an dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ya ni'hapit goh hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Alyom an amin hinan tatagun holag Israel an na'amung di, Mahapul an me'gonan ayu ti Ha\"in an hi Apo Dios an dayawonyu ya me'gonana'. ");
INSERT INTO ifb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ya way ohan da'yu ya e'gonanah inana ya hi amana, ya ngilinonyu nan algaw an pun'eblayan. Ti Ha\"in hi Apo Dios an dayawonyu. ");
INSERT INTO ifb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ya adiyu dayawon nan bulul, ya adi ayu munhibug hi gumo' ta diosyu. Ti Ha\"in hi Apo Dios an na'abbagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ya wa adya ta mun'onong ayun Ha\"in an Dios hi Onong di Pi'lenggopanyu ya unudonyu nan aat di onong ta way aton nan e'nongyun ma'abulut. ");
INSERT INTO ifb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ya mihdan amin nan dotagna ede han algaw an ne'nongana unu hinan mabiggat, mu wa ay di ma'angang hinan miyatlun algaw ya ipulu'yu ta moghob. ");
INSERT INTO ifb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ya gulat ta waday mangihdah nan atlun di algaw ya ma'alih adi maleneh, at adi ma'abulut. ");
INSERT INTO ifb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ya nan mangihda ya hiyay ma'amuyuan, at mamolta ti agguyna ene'gonan nan ne'nong ay Ha\"in, at henen tagu ya mahapul hi mapogpog di iddumanah nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ya wa ay ta mumboto' ayu ya adiyu pi'yala nan wah nan numpumpiningit hinan payawyu, ya adiyu goh umuy bangngadon an bot'on nan nalauhan an paguy. ");
INSERT INTO ifb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ya pinugahyu ay nan greypyu ya adiyu goh bangngadon an umuy alan nan na'angang unu alan nan nagah, at taynanyu ta bagin nan nawotwot ya nan himpangilin ni'hitun da'yu. Ti Ha\"in hi Apo Dios an dayawonyuy ad mandal. ");
INSERT INTO ifb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ya adi ayu mangakaw. Ya adi ayu munlayah. Ya adi ayu bumalbalih ibbayu. ");
INSERT INTO ifb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ya adiyu ihapatah ngadan'u nan adiyu ipa'annung ti henen inatyu ya unyu adi e'gonan nan ngadan'u. Ti Ha\"in hi Apo Dios an na'abbagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ya adiyu paligaton nan heneggonyu unu polhon nan gina'uda. Ya idatyu nan bino'lan nan puntamuonyu, ya adiyu dida punhoodon hi engganah mabiggat. ");
INSERT INTO ifb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ya adiyu idutan nan napu'it unu iyammay ihalibdudan nan nabulaw hinan way pange'wanda, mu ta'tana' an Dios. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ya adiyu pikuwon di ma'andong ta adiyu ipangngel di pamanuhyuh nan nawotwot unu nan adadangyan. Mu hay maphod ya nan nahamad di pamanuhyuh nan heneggonyu. ");
INSERT INTO ifb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ya adiyu iwa'at an hapiton nan agguy immannung an pa'leh hinan tatagu. Ya adi malgom di atonyuh dumalat hi atayan nan ni'tunglubyu. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ya adiyu abohlan nan a'agiyu, mu unyuat tugunon didah nan nappuhin inatda. Ti ihingalmu ay at adi'a middum hinan numbaholanda. ");
INSERT INTO ifb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ya adiyu ibolloh unu nonomnomon nan boholyuh nan i'ibbayu, mu hay maphod ya pohpohdonyu nan heneggonyu an umat hinan pamhodyuh odolyu. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ya mahapul an unudonyu nan Uldin'u. Ya adiyu ipa'undul nan animal hinan nob'on an animal. Ya adiyu tamman nan payawyuh duwah numbino'ob'on an oho'. Ya adiyu ilubung nan duway numbino'ob'on an hinulid hi na'abol. ");
INSERT INTO ifb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ya gulat ta elo' han lala'i nan baalnan babain niyalih ohah lala'i ta ahawaona, mu agguy napalgan ya agguy nidatan hi biyangna ta ma'alin bo'on mahkay hiya himbut ya mahapul an mamoltada. Mu adida patayon didan duwa ti heden babai ya himbutna. ");
INSERT INTO ifb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mu nan lala'i ya mahapul an iyalinay buta'al an kalnilu ta iyuynah nan way pantaw nan Me'gonan an Kuwaltun a'amungan ta e'nongnan Ha\"in an Dios di Onong di Nibahhawana. ");
INSERT INTO ifb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ya e'nong nan padi nan buta'al an kalniluh nan way hinagang'un Dios ta Onong di Nibahhawana ta way a'aliwan di baholna, at ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ya hay dumatnganyuh nan lutad Canaan ya muntanom ayuh numbino'ob'on an ayiw an ma'an di bungada, ya wa ay ta bumungada ya hanan bungada ya mapaniaw. Ya ibilangyuh mapaniaw hi tuluy tawon, at mahapul an adiyu onon. ");
INSERT INTO ifb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ya nan miyapat an tawon hi bumungaanda ya me'gonan di bungada ta Onong di Pundayawanyun Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mu nan miyaleman tawon hi bumungaanda ya mabalin mahkay hi ononyu, ya hiyah te ma'at ta way aton nan bungadan dumo'do\"ol. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ya adiyu ihday dotag an agguy na'aan di dalana. Ya adi ayu mumbuyun unu mun'adal hi te'om. ");
INSERT INTO ifb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ya adiyu ipa'lot nan numpinangngel an buu' hi uluyu, ya adiyu goh ipaputol nan uddu' di hamayyu. ");
INSERT INTO ifb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ya adiyu gunihan di odolyu an gapuh nan punlungdayaanyuh un way natoy, ya adiyu ipabato' di odolyu. Ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ya adiyu puhion nan binabain imbabaluyyu ta ila'uday odoldah pihhu ta adida mabainan. Ti abulutonyu ay at hiyanan dumo'ol di munla'uh odoldah tun luta, at dumo'olda goh di mumbahol hitun luta. ");
INSERT INTO ifb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ya unudonyu nan Uldin hi ma'at hinan algaw an pun'eblayan, ya e'gonanyu goh nan Tuldan Abung an wada'. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ya adi ayu umuy mumpabadang hinan mammalad ya nan tagun mun'utung an hay lennawan di matoy di nihuhu'lung ti puhionday nitaguanyu. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ya tuma'dog ayuh un nan mina'ma'ilog di pi'hapitanyu ta ipattigyuy pange'gonanyun dida, ya ta'tana' an Dios. Ti Ha\"in an hi Apo Dios ya nabagbagtua'. ");
INSERT INTO ifb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ya wa ay di himpangilin bunag an ni'hitun da'yuh nan lutayu ya adiyu dida abohlan. ");
INSERT INTO ifb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ya hay atonyuh nan himpangilin bunag an ni'hitun da'yu ya ibilangyu didah paddungnay ibbayu. Ya pohdonyu dida an umat hinan pamhodyuh odolyu ti da'yu goh ya ni'hitu ayuh nan himpangilin babluy hi ad Egypt. Ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ya adi ayu munlayah hi un way ipalukuddan da'yu, unu ipakiludan da'yu, unu way ipagodwadan da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hay usalonyu ya nan nahamad an lukud, ya nahamad an kiluan, ya nan nahamad an hupa. Ti Ha\"in hi Apo Dios an nabagbagtuy nangekak ay da'yuh ad Egypt. ");
INSERT INTO ifb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ya unudonyun amin nan Mandal'u ya an amin nan Uldin'u ta hiyay atonyu. Ti Ha\"in hi Apo Dios an nabagbagtu.” ");
INSERT INTO ifb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Alyom hinan holag Israel di, Wa adyay holag Israel unu himpangilin bunag an ni'hituh ad Israel an mangidat hinan imbabaluyna ta me'nong ay Molek ya mahapul an patayonyu, at nan tataguh nan babluy ya puntapada hiya. ");
INSERT INTO ifb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ya ta\"on un Ha\"in ya bumungota' enen tagu, ya pogpogo' di iddumanah nan tatagu' ti han nangidatanah nan imbaluynan Molek ya pinuhina ahan nan Nidugah an Me'gonan an Kuwaltun awada', ya impa'ampana nan me'gonan an ngadan'u. ");
INSERT INTO ifb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ya gulat ta nan tatagun nan babluy ya unda hintigtigon nan tagun mangidat hinan imbaluynan Molek mu adida hiya patayon ");
INSERT INTO ifb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","at Ha\"in di bumungot enen tagu ya didan hina\"ama, ya pogpogo' dida ta adida middum hinan tatagu', ya iddum'u goh an amin nan mangunud ay hiyan numbahol hi nundayawandan Molek ti ay paddungnay inlugtapa'. ");
INSERT INTO ifb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ya bumungota' hinan tagun mumpabadang hinan lennawan nihu'lung ti paddungnay dayawondah nen lennawa, at pogpogo' di iddumandah nan tatagu'. ");
INSERT INTO ifb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ya ilahhinyuy odolyu ta mihamad di aatyu, at me'gonan ayu. Ti Ha\"in hi Apo Dios an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ya adiyu aliwan nan Mandal'u ta hiyay unudonyu. Ti Ha\"in an hi Apo Dios di nangilahhin ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ya wa adyay mangidut ay amana unu hi inana ya mahapul an mapatoy ti inidutanah amana ya hi inana, at awahna. ");
INSERT INTO ifb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ya gulat ta han lala'iy umilugtap ta elo'nay ahawan nan lala'in heneggona ya didan duwan immilugtap ya mahapul an mapatoyda. ");
INSERT INTO ifb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ya gulat ta nan lala'i ya elo'nay ahawan amana ya binainah amana, at didan duwa an nan lala'i ya nan babai ya mahapul an mapatoyda ta awahda. ");
INSERT INTO ifb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ya gulat ta nan lala'i ya elo'na nan inapunan babai ya mahapul an mapatoydan duwa ti nan inatda ya na\"appuhi. ");
INSERT INTO ifb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ya gulat ta nan lala'i ya elo'na goh di paddungnah lala'in umat hinan aton nan lala'in mangelo' hinan babai ya henen inatda ya agaga\"ihaw ahan, at mahapul an mapatoydan duwa. ");
INSERT INTO ifb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ya gulat ta nan lala'i ya ahawaonay nunhin'ina ya umipabain ahan hene, at mahapul an gohbon didan tulu ta mi'id ah mangipabain ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ya gulat ta waday lala'ih mangundul hinan animal ya mahapul an mapatoy hiya, ya mahapul goh an mapatoy nan animal. ");
INSERT INTO ifb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ya gulat ta waday babaih umuy mumpa'undul hinan animal ya mahapul an mapatoy nan babai ya nan animal. ");
INSERT INTO ifb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ya gulat ta nan lala'i ya elo'nay babain pogtang di imbaluy goh amana unu imbaluy goh inanah ohah tagu ya binaina nan agina, at mahapul an mapogpog di iddumanah nan tatagu' ti binaina nan pogtangna, at hiyay ma'amuyuan hi ad bahol. ");
INSERT INTO ifb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ya gulat ta elo' han lala'i nan awadan di binulan an pumpa'ahwangan nan babai at binaina nan babai an dumalat di awadan nan matyamna. Ya gapu ta henen babai ya inabulutnay lala'i at mahapul an mapogpogdan duwah nan tatagu'. ");
INSERT INTO ifb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ya adiyu elo' nan babain pogtang inayu unu hi amayu ti mabainan nan neheggon an tutulangna, at didan duway ma'amuyuan an mabaholan. ");
INSERT INTO ifb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ya gulat ta nan lala'i ya elo'nay ahawan nan agin amana ya binaina hi ulitaona, at didan duway ma'amuyuan, at matoyda an mi'id imbaluyda. ");
INSERT INTO ifb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ya gulat ta nan lala'i ya ahawaonay ahawan nan pogtangna ya nappuhi ahan henen ma'at ti binaina nan pogtangna, at mi'id ah holagda. ");
INSERT INTO ifb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ya hay mahapul ya adiyu aliwan nan Mandal'u ya nan Uldin'u, ya hiyay unudonyu ta way atonyun adi mapakak hinan lutan pangiyaya' ay da'yuh punhituwanyu. ");
INSERT INTO ifb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ya mahapul an adiyu eng'enghon nan ugalin nan tatagun pakako' hinan lutan umayanyu ti ina'inatdan amin hatun agaga\"ihaw, at hiyanan inabohla' dida. ");
INSERT INTO ifb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","At hay inali' ay da'yu ya boltanonyu nan lutada, ya idat'un da'yu ta lutayu, ya henen luta ya ma\"almuy mihabal, at do'ol ahan di ma'an. Ti Ha\"in hi Apo Dios an nabagbagtuy nangilahhin ay da'yuh nan tatagu ta adida middum ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","At mahapul an immatunanyu nan nun'abhiwan nan mapaniaw ya nan adi mapaniaw an animal ya nan hamuti. Ya puhionday itaguanyuh nan pangihdanyuh nan animal, ya nan hamuti, ya nan umadap hinan luta ti didanay inlahhin'uh mapaniaw hi adiyu ihda. ");
INSERT INTO ifb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ya mahapul an me'gonan di aatyu ti Ha\"in an hi Apo Dios ya me'gonan di aat'u, ya inlahhin'u da'yuh nan atagutagu ta mihakup ayun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ya nan linala'i unu binabain mun'utung ta mihu'lung nan nappuhin lennawa unu nan mumpalad ya mahapul an mapatoyda, at pundotnayyuh batu dida ta awahda.” ");
INSERT INTO ifb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ya inalin Apo Dios ay Moses di, “Mi'hapit'ah nan papadi an nan imbabaluy Aaron ta alyom ay diday, Nan padi ya mahapul an emayaana ta adina dapoon nan matoy an tutulangna ta adina puhion di itaguana. ");
INSERT INTO ifb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Mu dapoonah un didan hina\"ama an umat ay inana, ya hi amana, ya nan imbaluynan babai unu lala'i, unu nan lala'in pogtangna, ");
INSERT INTO ifb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","unu nan ungan agguy nangahawan babain pogtangna an hiyay manalimun, ya mabalin an dapoona hiya an ta\"on un pumuhiy nitaguana. ");
INSERT INTO ifb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Mu mahapul an emayaana ta adina puhion di nitaguanah nan pumbaholanah udum ti hiyay ap'apudan himpampun. ");
INSERT INTO ifb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ya nan papadi ya adida gidgidan di buu' di uluda unu gidgidan nan hamayda, unu odolda an dumalat di lungdayada. ");
INSERT INTO ifb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ya ihamadday ugalida ta adida ipa'ampay ngadan'un Dios ti didana nan gun mangiyuy hinan me'nong an ma'an an nan tinapay ya nan Onong an Moghob an me'nong ay Ha\"in an Dios, at mahapul an nahamad di ugalida. ");
INSERT INTO ifb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ya adida ahawaon nan babain waday lala'in nangelo' ay hiya unu nan ni'hiyan hinan ahawana ti hiyay padih mangitamuan hinan tatagu' an Dios, at mahapul an nahamad di ugalina ti Ha\"in an Dios di itamuana. ");
INSERT INTO ifb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ya ibilangyu didah me'gonan di aatda ti diday mange'nong hinan onong ay Ha\"in an Dios, ya ibilangyu didah nahamad di ugalida ti Ha\"in an hi Apo Dios di nangihamad hi ugalida ti na'ahhamad di aat'u. ");
INSERT INTO ifb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ya gulat ta nan babain imbaluy nan padi ya puhionay odolna ta mumputa at hi amanay bainona, at mahapul an gohbonyu hiyah nan apuy. ");
INSERT INTO ifb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ya nan Nabagtun Padin nahiitan hi lanay uluna ya nidawat ta ilubungna nan lubung di padi ya mahapul an adina inganuy an manugud hi buu'na unu adina pi\"ion di lubungnah punlungdayaana. ");
INSERT INTO ifb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ya mahapul an adina ahan umuy tigon nan malgom an natoy ta adina puhion di nitaguana an ta\"on un hi amana unu hi inanay natoy. ");
INSERT INTO ifb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ya adina ahan taynan nan Me'gonan an Kuwaltu ta umuyna dida tigon ti puhiona nan me'gonan an awada' an Dios ti hiya ya nidawat an nahiitan hinan lana' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ya mahapul an hay ahawaona ya babai an mi'id ahan nangelo'. ");
INSERT INTO ifb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ya adina ahan ahawaon nan nabalu, unu nan ni'hiyan an babai, unu nan do'ol di lala'in nangelo' ay hiya, mu hay ahawaona ya nan babaih nan ohan himpangapu an mi'id ahan ah nangelo' ay hiya ");
INSERT INTO ifb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ta maphod di a'al'alyan nan holagna an middum ay didan hina\"ama. Ti Ha\"in an hi Apo Dios di nangilahhin ay hiyah mumpadi.” ");
INSERT INTO ifb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Alyom ay Aaron ta nan holagnad ugwan hi enggana ta wada ay di ganitda ya adida ahan umuy mun'onong hinan ma'an ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ya adi ahan mabalin an umuy hinan awada' nan tatagun waday ganit di odolna an umat hinan linala'i an nabulaw, ya napilay, ya nan waday pa\"in di angahna, unu nakudangan di ni'atan di odolna, ");
INSERT INTO ifb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ya umat goh hinan napungudan di dapana unu nan ngamayna, ");
INSERT INTO ifb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","unu nan nabu\"ung, ya nan he'he'dod an tagu, unu na'ulab di matana, unu nan way loghap di up'upna, ya nan napnahan an lala'i. ");
INSERT INTO ifb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ya nan holag Aaron an padin waday ganitna ya adi ahan mabalin an umuy mun'onong hinan Onong an Moghob an me'nong ay Ha\"in an Dios ti nan waday ganitna ya paniaw hi un umalin mun'onong hinan ma'an an onong'un Dios. ");
INSERT INTO ifb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mu mabalin an onona nan ma'an an ne'nong ay Ha\"in an nan nidugah an me'gonan ya nan me'gonan an ma'an. ");
INSERT INTO ifb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mu adi hiya mabalin an umuy hinan way kultina, ya adi goh umuy hinan way pun'onngan ti waday ganitna, at puhiona nan me'gonan an ihina'. Ti Ha\"in an hi Apo Dios di nangilahhin ay dane ta me'gonanda.” ");
INSERT INTO ifb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","At inalin Moses an amin hatu ay Aaron, ya nan imbabaluyna, ya an amin nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Alyom ay da Aaron ya nan linala'in imbabaluyna ta e'gonanda nan onong an e'nong nan holag Israel an indawatda ta adida bainon di ngadan'u. Ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ya wada ay di ohah nan holagyu an nan nappuhiy ataguna ta umuyna hegnon nan me'gonan an e'nong nan holag Israel an indawatdan Ha\"in ya henen tagu ya mahapul an mapogpog di iddumanan Ha\"in. Ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ya gulat ta nan holag Aaron an waday palla'na unu waday nappuhin bumuhu' hi odolna ya adina onon unu ihda nan me'nong ay Ha\"in hi engganay un mapoyanan nan poghana ta maleneh hiya. Ya wada ay di medeneh hinan odol di natoy, unu nan lala'i an waday bumuhu' hinan bagina, ");
INSERT INTO ifb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","unu gulat ta way dapoonah nan malgom an mapaniaw an mun'ada'adap ya pumuhiy ataguna, unu nan tagun manapah nan way dogohna ya miyalin ay hiya, ");
INSERT INTO ifb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ya nan manapah nan umat hitu ya adi hiya maleneh hi engganay mahdom. Ya mahapul an adina ihda unu onon nan me'gonan an ne'nong hi engganay un mun'amoh ta malenehan hiya. ");
INSERT INTO ifb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ya wa ay ta na'unug nan algaw ya maleneh mahkay hiya, at mabalin an onona ya ihdana nan me'gonan an me'nong ti hiyah ne tuwaliy onona. ");
INSERT INTO ifb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ya mahapul an adina ihda nan natoy an animal unu nan animal an pinatoy di udum an animal ti ihdana ay at hiyay dumalat hi alugitan di ataguna. Ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ya nan papadi ya mahapul an unudondan amin nan imbaga' hi atonda ti adida ay at mumbaholda, ya matoyda an dumalat di adida pangunudan hinan mahapul hi atonda. Ti Ha\"in hi Apo Dios an nangilahhin ay dida ta mihamad di ugalida. ");
INSERT INTO ifb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ya hay mangihda unu mangan hinan me'gonan an dotag ya da Aaron ya nan pamilyana ya anggay ya mi'id ah udum, an ta\"on nan mangilin nan papadi unu nan tagalana ya adi mabalin. ");
INSERT INTO ifb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mu nan himbut nan padin penla'na ta baalna unu nan baal an nitungaw hi abung nan padiy hiyay mabalin hi me\"an unu mi'ihdah nan padi. ");
INSERT INTO ifb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ya gulat ta nan babain holag nan padi ta bo'on holag Levi di ahawaona ya adi hiya mabalin hi me\"an unu mi'ihdah nan ne'nong an me'gonan. ");
INSERT INTO ifb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mu gulat ta nan babain imbaluy nan padi ya nabalu unu ni'hiyan ya mi'id di imbaluyna ya numbangngad an mi'hituh abung amana an umat hidin abalahangna ya mabalin an me\"an unu mi'ihdah nan onon amana. Mu adi mabalin ahan an me\"an nan tagun mangali. ");
INSERT INTO ifb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Ya gulat ta waday nibahhaw an agguyna ginulat ya inana nan me'gonan an ne'nong ya mahapul an bayadanah den ne'nong, ya indatnah nan padi, ya inokpanah ba'intih porcento nan balulna. ");
INSERT INTO ifb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ya mi'id ah tagun mamuhih nan me'gonan an onong nan holag Israel an ene'nongdan Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","At nan pangiyabulutanda ta onon nan mangili nan me'gonan an onong di hiyay dumalat hi abaholanda. Ti Ha\"in an hi Apo Dios di mangihamad hi ugalida.” ");
INSERT INTO ifb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Mi'hapit'a ay da Aaron, ya nan linala'in imbabaluyna, ya an amin nan holag Israel ta alyom ay diday, Gulat ta wadan da'yun holag Israel unu nan himpangilin ni'hitun da'yuy mamhod an mangiyuy hi onongna ta mun'onong ay Apo Dios hinan Onong an Moghob ta mangipa'annung hinan inhapatana unu unna tuwali ninomnom an mun'on'onong ");
INSERT INTO ifb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ya hay ma'abulut hi iyaliyuh e'nongyu ya nan mi'id ah ganitnan manilhig an baka, unu buta'al an kalnilu, unu gandeng. ");
INSERT INTO ifb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ya adiyu iyaliy malgom hinan way ganitna ti adi ma'abulut nan e'nongyu. ");
INSERT INTO ifb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ya wa ay di mun'onong hi Onong di Pi'lenggopan hi i'ibba ta mangipa'annung hinan inhapatana unu unna tuwali ninomnom an mun'on'onong ya hay e'nongna ya hay baka unu kalnilun mi'id ah ganitna ta way atonan ma'abulut. ");
INSERT INTO ifb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ya adiyu ahan e'nong ay Apo Dios nan nabulaw, unu nan way na'ipung, unu napilay, unu nabilatan, unu nan waday poghana, unu nan way butigna, unu way nabdu'. Adiyu ahan iyuy hinan pun'onngan nan malgom an umat hina ta e'nongyuh Onong an Moghob hi me'nong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ya unyu ay tuwali ninomnom an mun'onong ya mabalin hi e'nongyu nan napilay unu nabilatan an baka unu kalnilu, mu adi ma'abulut hi un me'nong hi Onong di Ni'tulagan. ");
INSERT INTO ifb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ya mahapul an adiyu ahan e'nong ay Apo Dios nan animal an nahugatan, unu napnahan, unu napilayan, unu nagunihan. Mahapul an adiyu ahan e'nong di umat hituh nan babluyyu. ");
INSERT INTO ifb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ya adiyu ahan abuluton an alan nan animal an iyalin nan himpangili ta ay ma'an an hiyay e'nongyun Apo Dios. Ti adi ma'abulut nan e'nongyu ti nappuhi, ya waday ganitna.” ");
INSERT INTO ifb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Wada ay di mitungaw an baka, unu kalnilu, unu gandeng ya mahapul an mimiddum ay inanah pituy algaw. Ya mete\"ah awalun di algawna ya un mabalin hi ma'abulut an moghob an me'nong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ya adiyu pundehhonon an e'nong nan nunhin'ina an baka unu kalniluh ohay algaw. ");
INSERT INTO ifb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ya wa adya ta mun'onong ayuh Onong di Punyamananyun Ha\"in an Dios ya hamadonyu ta da'yuy ad nomnom hinan atonyu. ");
INSERT INTO ifb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ya ihdayun amin nan ene'nongyu eden algaw an nange'nonganyu ta mi'id ah ma'ang'angang hinan mabiggat ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Ya adiyu al'alliwan nan immandal'u, mu unyuat unudon ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ya adiyu aton nan umipabain ta adia' mabainan, ya da'yun holag Israel ya me'gonan di pannigyun Ha\"in. Ti Ha\"in hi Apo Dios an nangilahhin ay da'yu ta me'gonan ayu goh, ");
INSERT INTO ifb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ya Ha\"in di nangekak ay da'yuh ad Egypt ta Ha\"in an Dios di dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ipa'innilam hinan holag Israel di, Hatuy pento\"un algaw an pumbehtaandan Ha\"in, at ipa'innilayuh nan me'gonan an ahayhayupanyu.” ");
INSERT INTO ifb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ya intuluy Apo Dios an inalinay, “Ya onom di algaw hi puntamuanyu, mu nomnomonyu an nan miyapitun algaw ya hiyah ne algaw an pun'eblayan. At adi ayu muntamu ti hiyah ne algaw hi a'amunganyun mundayaw ay Ha\"in an Dios ti hiyah ne algaw hi pun'eblayanyuh nan malgom an wadan di numpunhituwanyu, ya hiyay atonyu.” ");
INSERT INTO ifb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ya inalina goh di, “Ya hiyatuy algaw hi pento\"un Dios hi pumbehtaanyu ta hiyay me'gonan an ahayhayupanyu, at gunyu ipa'innilah un madatngan nan gutudna. ");
INSERT INTO ifb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ya hay gutud di Punnomnoman hi Namaliwa' an Dios ya mete\"ah a'unugan di algaw eden miyapulu ta opat di algaw hinan hopap di bulan.” ");
INSERT INTO ifb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ya inalina goh di, “Ya nan mabiggat an miyapulu ta lemay algaw ya hiyay ete\"an di Pumbehtaanyun Ha\"in an Dios hinan Agguy Nabino'bo'an an Tinapay, ya pituy algaw di adiyu panganan hinan agguy nabino'bo'an an tinapay. ");
INSERT INTO ifb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ya nan hopap di algaw ya hiyah ne me'gonan, at hiyay ahayhayupanyu ta dayawona' an Dios, ya mahapul an mi'id ah muntamu. ");
INSERT INTO ifb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ya pituy algaw di pange'nonganyuh nan moghob an me'nong ay Ha\"in an Dios, ya nan apitun di algaw ya adi ayu goh muntamu ta mahayup ayu ta mundayaw ayu goh ay Ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Wa ay ta dumatong ayuh nan lutan idatna ay da'yu ya hay hopap di pumbot'anyu ya iyuyyuy himboto' hinan padi ");
INSERT INTO ifb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ta ilayatna nan himboto' ay Apo Dios, at umamlong, at abulutona. Ya hay algaw hi pangilayatan nan padi ya hay mabiggat an nan algaw an pun'eblayan. ");
INSERT INTO ifb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ya hede han algaw an ilayatan nan himboto' an paguy ya iddumyun e'nong nan uyaw an kalnilun ohay tawona an mi'id ah ganitna ta Onong an Moghob an me'nong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ya iddumyuy nahuluk hi opat di litroh nan ma'adyamu' an alenan nalamutan hi mantika ta moghob an me'nong ay Apo Dios ta nan angilitnay mangipa'amlong ay Hiya. Ya hay me'nong goh ta Onong an Ma'inum ya ohah litron bayah. ");
INSERT INTO ifb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ya ta\"on un nihanglag nan paguy, ya nalangu nan gahhilang, unu malgom an bungan nan intanomyu ya adiyu onon ta engganah unyu e'nong ay Apo Dios. Ya heten uldin ya mahapul an ato'aton nan holagyuh enggana an ta\"on un malgom di lugal hi numpunhituwanda.” ");
INSERT INTO ifb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ya inalin goh Apo Dios di, “Ya mete\"a eden mabiggat hi alpahan di Habadu ya heden algaw an nangiyayanyu ta nilayat an ne'nong nan nahhun an bento'yu ya ete\"ayun mumbilang ta engganay magtud di pituy duminggu. ");
INSERT INTO ifb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ya mete\"ah nan mabiggat hi alpahan di ngilin an algaw ya ete\"ayun mumbilang goh hi nabongley algaw, ya e'nongyu goh ay Ha\"in an Dios di pa\"alah paguy. ");
INSERT INTO ifb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ya da'yun amin an numbino'ob'on di numpunhituwanyu ya iyaliyuy hindudwah milayat an tinapay an hay niyamma ya nahuluk hi opat di litroh na'adyamu' an alena, ya ma'udman hi bino'bo', ya inhaangyu ta midat an Milayat an Onong'un Dios. Hiyah ne onong di hopap di bungan di mitanom. ");
INSERT INTO ifb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ya hay middum hinan tinapay an me'nong ya pituy bubuta'al an hinohhay tawonan kalnilun uyaw ya mi'id ganitda, ya oha goh hi manilhig an baka, ya duwah buta'al an kalnilu ta diday Onong an Moghob ay Ha\"in an Dios an middum nan tinapay ya nan bayah ta moghob an me'nong goh ay Ha\"in ta nan maphod an angilitnay mangipa'amlong ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ya e'nongyuy ohay hintawonah buta'al an gandeng hi Onong di Bahol ya duwan kalnilun uyaw an hinohhay tawonda ta Onong di Pi'lenggopan. ");
INSERT INTO ifb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ya ilayat nan padi an e'nong ay Ha\"in an Dios nan duwan uyaw an kalnilun middum nan tinapay an hopap di bungan nan nitanom. Hatun nidawat an Milayat an Onong ya bagin nan padi. ");
INSERT INTO ifb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ya hete an ahayhayupan ya me'gonan, at ngilinonyu, ya adi ayu umuy muntamu. Ya hete han uldin ya adi mapogpog an ta\"on un malgom di pi'hituwan nan holagyu, ya mahapul an ato'atondah enggana. ");
INSERT INTO ifb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ya wa adya ta mumboto' ayu ya adiyu bot'on nan paguy an wadah nan numpumpiningit, ya adiyu balluwon nan agguy na'ala ta waday alan nan tatagun nawotwot, ya nan himpangilin ni'hitun da'yu. Ti Ha\"in hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Nan hopap di algaw hi apitun di bulan ya ngilinonyu ta pun'eblayanyu. Ya ta panginomnomanyuh nan me'gonan hi ahayupanyu ya ipa'innilayuh nan pangipagangohanyuh nan talampet. ");
INSERT INTO ifb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ya adi ayu umuy muntamu, mu un ayu mun'onong hinan moghob an me'nong ay Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Nan miyapulun algaw hi apitun di bulan ya hiyay algaw hi pun'onngan ta a'aliwan di bahol. Ya henen a'amunganyu ya me'gonan, at mahayup ayu, ya impa'ampayuy odolyu, ya nun'onong ayun Ha\"in an Dios hinan moghob an me'nong. ");
INSERT INTO ifb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ya adi ayu muntamu eden algaw ti henen algaw di hiyay pun'onnganyun Ha\"in an Dios ta way a'aliwan di baholyu. ");
INSERT INTO ifb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","At wa ay di adi mangipa'ampah odolna eden algaw ya mahapul an mapogpog di iddumanah nan tataguna, ");
INSERT INTO ifb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ya wada ay goh di muntamu eden algaw ya ubaho' hiyah nan niddumanan tatagu. ");
INSERT INTO ifb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ya ta\"on un malgom an tamu ya hete han uldin ya minaynayun an ato'aton nan holagyuh enggana an ta\"on un malgom di pi'hituwanda. ");
INSERT INTO ifb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ti hete ya Habadu an pun'eblayanyu, at mahapul an ipa'ampayuy odolyu. Ya mete\"ah nan miyahiyam an algaw hinan bulan ta nangamung mahdom hinan mabiggat ya mahapul an ngilinonyu nan pun'eblayanyu.” ");
INSERT INTO ifb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ya ni'hapit goh hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Mi'hapit'ah nan holag Israel ta alyom ay dida an nan miyapulu ta lemay algaw hinan miyapitu an bulan ya hiyay gutud di behta an pun'ammanyuh nan a'al'allung, ya mahapul an mumbehta ayuh pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ya nan hopap di algaw ya me'gonan an ahayupanyu, at adi ayu muntamu. ");
INSERT INTO ifb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ya pituy algaw di umonnga'onnganyuh nan moghob an me'nong ay Apo Dios, ya nan awalun di algaw ya me'gonan an ahayupanyu, at mun'onong ayuh nan moghob an me'nong ay Apo Dios, at mahapul an mi'id ah umuy muntamu ti hiyay angunuh an ahayupanyu. ");
INSERT INTO ifb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ya hiyatuy behtah pento' Apo Dios hi ipa'innilayu an date ya me'gonan an ahayupanyu ta e'nongyu nan onongyu an moghob ay Apo Dios an nan Onong an Moghob, ya nan Onong an Ma'an, ya nan udum an goltonyuh e'nong, ya nan Onong an Ma'inum, ya atonyu daten amin eten ohan algaw. ");
INSERT INTO ifb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ya nat'on tuwali nan gunyu e'nong ay Apo Dios hinan algaw an pun'eblayanyu, ya nan udum an pohdonyun idat tuwali, ya nat'on goh tuwali nan inhapatayu, ya nat'on goh nan unyu tuwali ninomnom an mun'onong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ya hede goh an miyapulu ta leman algaw hi apitun di bulan hi alpahan di numbot'anyuh nan inhabalyuh nan lutayu ya nomnomonyu ta ibehtaanyuh Apo Dios hi pituy algaw, ya nan hopap di algaw ya hiyay pun'eblayanyu, ya nan awalun di algaw ya hiyay pun'eblayanyu goh. ");
INSERT INTO ifb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ya heden hopap di algaw ya alanyu nan mun'aphod an bungan nan ayiw an intanomyu, ya inummal ayu goh hinan tubun nan palma, ya nan hapang di ayiw an abebellog di tubuna, ya nan ayiw an poplar, at hiyanay inusaldan nundayaw ay Apo Dios hi pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ya gunyu aton heten behta an behtan Apo Dios hinan miyapituy algaw hi apitun di bulan hi atawotawon. Ya heten uldin ya adi mapogpog, at minaynayun an ato'aton nan holagyuh engganah un madatngan nan apitun di bulan. ");
INSERT INTO ifb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ya an amin nan mitungaw an holag Israel tuwali ya munhitu ayuh nan allung hi pituy algaw ");
INSERT INTO ifb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ta way panginnilaan nan holagyu an da'yun holag Israel ya nunhitu ayuh nan allung hidin nangekakana ay da'yuh ad Egypt.” ");
INSERT INTO ifb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","At impa'innilan Moses hinan tatagun amin din immandal Apo Dios hi atondan mumbehta. ");
INSERT INTO ifb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Mandalom nan tatagu ta iyalida nan namahmah an lana an malpuh nan olibon maphod di ammana ta way mittuh nan panul an panilaw, ta way aton nan apuy an adi madmaddop. ");
INSERT INTO ifb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","At amahdomahdom ya gun tolgan Aaron nan panul ta lumanablabi an bumenabenang hi engganay mapatal heden hilaw an wah dih nan pangngel nan kultinan di niha\"adan nan Kahon an Nittuwan di Himpulun Uldin hinan Me'gonan an Kuwaltu. Ya heten uldin ya minaynayun hi ato'aton nan holagyuh enggana. ");
INSERT INTO ifb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ya gun halimunan Aaron ta bumenabenang nan hilaw an nun'ipattu' hinan namahmah an balitu' hidih nan wada' an Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ya inalin goh Apo Dios di, “Ya alanyuy na'adyamu' an alena, ya inhaangyu ta ma'amman di himpulu ta duwah tinapay, ya opat ya han godway litro an miyammah ohay tinapay. ");
INSERT INTO ifb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ya pun'ipattu'yu nan tinapay an hin'o'nom hi numpinangngel hinan lamehaan an namahmah an balitu' hinan way hinagang di awada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ya ha\"adonyu nan duwan nalinyan tinapay hinan namahmah an maphod di hunghungnan incense hinan tinapay ta hiyay mangipanomnom hi unda e'nong ta moghob an onong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ya heden algaw an gunda pun'eblayan ya ep'ephod Aaron nan tinapay an gun idat nan holag Israel hinan way hinagang'un Dios, ya hiyah te ato'aton nan holag Israel hi enggana. ");
INSERT INTO ifb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ya nan tinapay ya bagin da Aaron ya nan linala'in holagna, ya nan me'gonan an lugal di pangananda ti henen ma'an ya me'gonan ti nalpuh bingayda an gunda alan nan ne'nong ay Ha\"in an Dios an moghob.” ");
INSERT INTO ifb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ya wada han lala'i an hi inana ya nalpuh holag Israel, ya hi amana ya holag di i'Egypt, ya hede han lala'i ya ni'pattoy hinan ohan lala'in holag Israel hidih nan immapalanda. ");
INSERT INTO ifb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ya heden lala'in imbaluy nan holag Israel an babai ya ente\"anan mangidut ya mamahiw ay Apo Dios, at inyuydan Moses. (Ya hi inan nen lala'i ya hi Shelomith an imbaluy Dibri an nalpuh holag Dan.) ");
INSERT INTO ifb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ya impaguwalyada hiya ta engganay henodday inalin Apo Dios hi atondan hiya. ");
INSERT INTO ifb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ya unat goh himmapit hi Apo Dios ay Moses, ya inalinay, ");
INSERT INTO ifb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ekakyuh ne han lala'in nun'idut hinan immapalanyu, ya da'yu an nangngol hi nun'idutana ya ho\"onyuy uluna ta ihtiguanyu an numbahol hiya, ya an amin ayun tatagu ya taponyu hiya ta engganay matoy. ");
INSERT INTO ifb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ya alyom hinan holag Israel di, Nan mamahiw ay Apo Dios ya hiyay ma'amuyuan hi mamolta. ");
INSERT INTO ifb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","At wa adyay tagu ta adina e'gonan hi Apo Dios ta idutana Hiya ya mahapul an mapatoy, ya an amindan na'amung ya mahapul an taponda hiya an ta\"on un nan himpangili unu holag Israel, ta wa adya ta agguyna ene'gonan hi Apo Dios ya mahapul hi mapatoy. ");
INSERT INTO ifb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ya gulat ta waday mamatoy hi ibbanah tagu ya mahapul an mapatoy goh, ");
INSERT INTO ifb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ya nan mamatoy hinan animal di ohah ibbanan tagu ya mahapul an hukatana goh hi animal. Ti hay aatna ya animal ay di pinatoyna ya animal goh di bayadna. ");
INSERT INTO ifb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ya gulat ta han tagu ya ginunihana nan heneggona ya henen inatnan ne han ibbanan tagu ya mahapul an hiya goh di ma'at ay hiya. ");
INSERT INTO ifb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ya gulat ta immipung hi hu'i ya ma'ipung goh di hu'ina, ya gulat ta pimmilok ya mapilok goh di matana, ya gulat ta pimmengaw hi baba ya mapengawan goh di ohah babana. Ti nan inatnah nan ibbana ya mahapul an hiya goh di ma'at ay hiya. ");
INSERT INTO ifb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ya wa adyay pumatoy hi animal ya mahapul an hukatana nan animal, mu wa adyay pumatoy hi tagu ya mahapul an mapatoy goh hiya. ");
INSERT INTO ifb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Nen un ohay uldin hi unudonyun amin, at ta\"on un nan himpangilin ni'hitun da'yu unu da'yun holag Israel ya mapapaddung di panugun nen uldin ay da'yu. Ti hi Apo Dios ya nabagbagtu.” ");
INSERT INTO ifb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ya unat goh inalin Moses hete hinan tatagu ya enekakda din lala'ih nan immapalanda, ya nuntapada hiya ta engganay un natoy. Ya hiyah te na'at ta way inat nan tatagun Israel an nangunud hinan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ya ni'hapit hi Apo Dios ay Moses hi wadanah nan Duntug an Sinai an alyonay, ");
INSERT INTO ifb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Mi'hapit'ah nan holag Israel ta alyom ay dida an wa ay ta dumatong ayuh nan lutan idat'un da'yu ya mahapul an pun'eblayonyu nan luta ta Ha\"in an hi Apo Dios di dayawonyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","At onom di tawon hi panammanyuh nan payawyu, ya onom goh di tawon di panalimunanyuh pangaananyuh nan nappuhin halepeng nan greypyu, ya pamugahanyuh nan bungada, ");
INSERT INTO ifb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","mu nan miyapitun tawon ya hiyah ne me'gonan an ngilin an pun'eblayan nan lutayu ta heden tawon ya midawat nan lutan Ha\"in an Dios. At adiyu tamman nan lutayu, ya adiyu halimunan nan greypyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ya adiyu alan nan bungan nan humangaw hinan lutayu, ya adiyu pugahon nan bungan nan nidawat an greypyun nidawat ay Ha\"in an Dios. Ti nan luta ya mahapul an pun'eblayonyuh hintawon. ");
INSERT INTO ifb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ya nan bungan nan humangaw hinan miyapitun tawon an pun'eblayan nan lutayu ya alanyu ta ononyu, mu mi'yala goh nan linala'i ya binabain baalyu, ya nan puntamuonyu, ya nan ni'hitun da'yu an mangiliyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ya ta\"on goh nan a'animalyu ya nan a'animal an wadah nan lutayu ya ononda nan bungan nan humangaw.” ");
INSERT INTO ifb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ya inalin goh Apo Dios di, “Ya bilangonyuy mumpapituy pituh tawon an pun'eblayan nan lutayu ta hay lammungnan amin ya napat ya han hiyam di tawon. ");
INSERT INTO ifb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ya nan apulun di algaw hi apitun di bulan an ma'alih Algaw an Pun'i'innaliwan ya paganghonyu nan talampet hinan abablubabluy hi ad Israel. ");
INSERT INTO ifb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","At e'gonanyu nan miyanabonglen tawon, ya ipa'innilayun amin hinan tatagun numpunhituh nan abablubabluy ta mun'amlongda. Ti heden tawon ya nan enepla'da an luta ya mibangngad ay didan hina\"aman ad luta tuwali. Ya nan himbut ya mumbangngaddah nan pamilyada tuwali. ");
INSERT INTO ifb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ya nan miyabonglen tawon ya hiyay tawon hi pumbehtaanyu, at adiyu tamman nan lutayu, ya adiyu goh alan nan bungan nan humangaw hinan lutayu unu pugahon nan bungan nan agguyyu hinalimunan an greypyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ti hiyay gutud di pumbehtaanyu, at ngilinonyu ti me'gonan, at hay ononyu ya nan bungan di inhabalyuh nan lutayu an din i'innalyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ya henen Tawon di Pumpangibangngadan hinan lutan lina'uanyuh nan ad luta tuwali. ");
INSERT INTO ifb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ya gulat ta ila'uyu nan lutayuh nan ohan ibbayu unu luma'u ayuh nan lutan di ibbayu ya adi ayu himbabalbali. ");
INSERT INTO ifb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Gulat ta munla'u ayu unu luma'u ayuh nan luta ya bilangonyuy atnay tawon ya un madatngan nan Tawon di Pangibangngadan, ya bilangonyu goh di atnay tawon hi bumungaan nan nitanom, ya hiyay balul di punla'uyu unu pangila'uyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ya gulat ta do'do\"ol di tawon hi punhabalan nan luma'u ya un madatngan nan Tawon di Pangibangngadan ya ong'ongngol di la'una, ya gulat ta un itang di na'angang hi tawon ya itang goh di bayadna. Ti hay mabayadan ya nan bilang di tawon hi punhabalan hinan luta. ");
INSERT INTO ifb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ya adi ayu himbabalbali, mu ta'tana' an Dios. Ti Ha\"in hi Apo Dios an nabagbagtu.” ");
INSERT INTO ifb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ya inalin goh Apo Dios di, “Ya unudonyu nan Uldin'u, ya emayaanyu ta atonyu nan immandal'u, at mid al'alih pi'hituwanyuh tun luta. ");
INSERT INTO ifb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ti nan luta ya pumhod an malmuy mihabal, at do'ol di ma'an hi ononyu, at malenggop ayun munhitu. ");
INSERT INTO ifb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ya gulat ta wadan da'yuy mangalih, Hay onon mah ede han miyapitun tawon? Ti adi tamman nan luta ya adi alan nan bungan nan nitanom! ");
INSERT INTO ifb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mu hede han miyonom an tawon ya wagaha' nan luta ta pumhod di bungana ta umanay hi ononyuh tuluy tawon. ");
INSERT INTO ifb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","At hede han miyawalun tawon an punhabalanyuh nan luta ya wada nan baa' hi ononyun munhabal an magi'od hi ononyuh engganay alanyuy bungan nan intanomyun de han miyahiyam an tawon.” ");
INSERT INTO ifb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ya inalin goh Apo Dios di, “Ya nan luta an la'uanyu ya bo'on bagiyuh enggana ti bo'on da'yuy immannung hi ad luta ti luta' an Dios, ti da'yu ya un ayu umat hinan bunag an un ayu ni'hithituh tun luta. ");
INSERT INTO ifb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","At wada ay di ad luta an pohdonan mamangngad hinan lutana an lina'uanyu ya mahapul an iyabulutyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ya gulat ta mumbalin hi nawotwot di ohah nan ibbayu ta mapilitan an mangila'uh nan lutana, ya umali ay nan nehegheggon di nitulanganan hiya ya mabalin an hiyay mamangngad hinan lutan inla'un nan agina. ");
INSERT INTO ifb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ya gulat ta mi'id di a'aginan mamangngad hinan lutana mu wada ay di pihhunah udum di tawon ya hiyay mamangngad. ");
INSERT INTO ifb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ya bilangonay atnay naluh hi tawon hi nangila'uana ta nan bayad di tawon an ma'angang di hiyay ibangngadana eden tagun nangila'uana, at nan luta ya bagina mahkay. ");
INSERT INTO ifb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mu mi'id ay di pamangngadna ya nan nunla'uh nan lutay okod hi engganay madatngan nan Tawon di Pangibangngadan hi luta ya un mahkay mibangngad ay hiya nan lutana tuwali. ");
INSERT INTO ifb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ya gulat ta waday lala'in mangila'uh abungna an nunlene'woh di allupna an wah nan siudad ya waday biyangnan mamangngad eden abungnah ohay tawon an nangila'uana. ");
INSERT INTO ifb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mu adina ay umuy bangngadon ta naluh di ohay tawon ya mid mahkay biyangnan mamangngad, at nan abung ya bagin mahkay nan nunla'u ya nan holagnah enggana, ya adi mibangngad hinan nangila'uh un madatngan nan Tawon an Pangibangngadana. ");
INSERT INTO ifb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mu nan abung an agguy na'allup ya uddum nan lutan di payaw at mabalin hi mabangngad an umat hinan lutan nila'u, ya mibangngad goh hi un madatngan nan Tawon an Pangibangngadan. ");
INSERT INTO ifb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Mu nan holag Levi ya waday biyangda ti ta\"on un malgom hi tawon ya mabalin an bangngadonda nan gina'udan nila'u ti diday ad babluy eden lutan nidat ay didah bagida. ");
INSERT INTO ifb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Mu gulat ta han tagu ya luma'uh abung di holag Levi ya heden Tawon an Pumpangibangngadan ya mibangngad ti nan abung ya munnononnong an gina'un nan holag Levi hinan ni'babluyandah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mu nan payaw hinan way pumpahtulanda an wah nan siudad ya adi mabalin hi ila'uda ti hiyah ne banohdah enggana, at umuy hinan udumna.” ");
INSERT INTO ifb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ya inalin goh Apo Dios di, “Ya gulat ta waday ibbayuh holag Israel an nawotwot ahan ta adina olog an mananud hi odolna ya mahapul an idatyuy mahapulna an umat hinan pangatyuh nan mangiliyu, ta way atonan adi makak. ");
INSERT INTO ifb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ya adiyu ipatakap nan malgom an imbadangyun hiya, mu e'gonana' an Dios ta way atonan adi makak, ta way tunglubonyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Adim ipatakap nan pihhun ipa'utangmun hiya, ya umat hinan ma'an an ila'uyun hiya. ");
INSERT INTO ifb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ti Ha\"in hi Apo Dios an dayawonyu an nangekak ay da'yuh ad Egypt, di nangidat ay da'yuh nan lutad Canaan ta Ha\"in di dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ya inalin goh Apo Dios di, “Ya gulat ta waday ibbayun holag Israel an nunhegla ahan an nawotwot ta ihbutdan da'yu ta mumbalin hi baalyu ya adiyu hiya puntamuon hi tamun di himbut. ");
INSERT INTO ifb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Mu hay atona ya mihinan da'yu an umat hinan bumo'la unu umat hinan mangiliyu ta engganay madatngan heden Tawon an Pangibangngadan. ");
INSERT INTO ifb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ya heden gutud di akakanan he\"a an ta\"on nan imbabaluyna ta mumbangngaddah nan pamilyada ya umuydah nan lutan bangngadonda an lutan nan o'ommodda. ");
INSERT INTO ifb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ti dida nan holag Israel an baal'u an enekak'ud Egypt, at adi mabalin hi mihbutda ta mumbalindah himbut. ");
INSERT INTO ifb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ya nan pamaalanyun dida ya adiyu dida paligaton, mu e'gonana' an Dios. ");
INSERT INTO ifb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ya pohdonyu ay an ummal hi linala'i ya binabai ta himbutyu ya hay hubutonyu ya nan tatagun nunhituh nan babluy an wah nan nunlene'woh hinan numbabluyanyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ya mabalin an humbut ayuh nan imbabaluy nan bunag an ni'hitun da'yu, ya nan holagdan nitungaw hinan numbabluyanyu di hiyay hubutonyu ta bagiyu. ");
INSERT INTO ifb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ya mabalin an ipaboltanyu didah nan imbabaluyyu ta boltanonda, at bagida ta baalonda didah enggana, mu nan pamaalanyuh nan ibbayun holag Israel ya mahapul an adiyu paligaton dida. ");
INSERT INTO ifb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ya gulat ta waday himpangilin ni'hitun da'yu, ya immadangyan, ya wada goh di holag Israel an numbalin hi nawotwot ta inihbutnay odolnah nan adangyan an himpangilin ni'hitun da'yu unu baal nan holagna ");
INSERT INTO ifb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ya ta\"on hi un nila'u mu wada damdamay biyangnan mabangngad ti bangngadon nan ohah nan tutulangna. ");
INSERT INTO ifb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mabalin an hi ulitaona, unu hay kasinsina, unu hay malgom an tulangna di mamangngad ay hiya, ya ta\"on un hiyah un way pihhuna ya hiyay mamangngad hi odolna. ");
INSERT INTO ifb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","At hay atona ya mi'hapit hinan nambut ay hiya ta bilangonday atnay tawon hi nambutanan hiya ya un madatngan heden tawon an alibliana. Ya hay bayadana ya nan tawon an punhulbianan hiya ya un madatnangan heden tawon. ");
INSERT INTO ifb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ya gulat ta do'do\"ol ay di bilang di tawon ya un madatngan nan alibliana ya do'do\"ol goh di bayad di abangngadana. ");
INSERT INTO ifb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ya gulat ta un itang ay di tawon hi na'angang ya itang goh di bayad di abangngadana. ");
INSERT INTO ifb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ya ibilangna hiyah umat hinan ohan baalna eden tawon an ihinanan hiya, ya adina paligaton hiyah nan tamuna. ");
INSERT INTO ifb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ya gulat ta mi'id abalinanan mamayad hi alibliana ya mehod hi engganay madatngan din tawon an alibliana ya nan imbabaluyna ");
INSERT INTO ifb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ti nan holag Israel ya baal'u. Dida ya baal'u an enekak'uh ad Egypt, ya Ha\"in hi Apo Dios an dayawonyu.” ");
INSERT INTO ifb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ya intuluy Apo Dios an ni'hapit ay Moses an inalinay, “Ya adi malgom di dayawonyu, ya adi ayu goh mangammah bulul unu munha\"ad hi bulul an batuh nan babluyyu ta way dayawonyu ti Ha\"in an hi Apo Dios di dayawonyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ya mahapul an ngilinonyu nan Habadu, ya e'gonanyu nan Tuldan Abung an awada' ti Ha\"in hi Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ya gulat ta unudonyu ya atonyu nan immandal'u ya nan Uldin'u ");
INSERT INTO ifb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","at ipa'udan'uh nan gutud di puntammanyu ta way aton nan intanomyuh nan lutan pumhod di bungana ya bumunga goh nan bungbungaan an ayiw. ");
INSERT INTO ifb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ya gun ayu mumboto' ta engganay madatngan di apugahan di greyp, ya gun ayu mumpugah hi greyp ta engganay ahitanom. At do'ol di ma'an hi pohdonyuh onon, at munlenot ayun munhitun den babluy. ");
INSERT INTO ifb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ya idat'uy lenggopyu eden luta ta malenggop ayuh nan olo'anyu, ya mi'id ah ta'tanyu. Ti ubaho' nan atata'ot an a'animal hinan lutayu, ya adi' iyabulut an waday mangubat ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","At pumpudugyu nan binuhulyu, ya numpatoy'u dida. ");
INSERT INTO ifb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ti ta\"on un ayu lema ya mabalin an gubatonyuy hinggahut, ya ta\"on un ayu hinggahut ya mabalin an gubatonyuy himpuluy libu, ya pumpatoyyu nan binuhulyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ya halimuna' da'yu, at munholag ayu ta dumo'ol di bilang di holagyu, ya ipa'annung'u goh nan intulag'un da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ya hay baa' an bento'yud tawonad di ono'ononyu, ya pun'ipabuhu'yuy udumna ta way pangiponponanyuh nan pa\"abto'. ");
INSERT INTO ifb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ya mi'hituwa' ay da'yuh nan Tuldan Abung, ya adi' da'yu pahiwon. ");
INSERT INTO ifb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ya mimidduma' ay da'yu ta Ha\"in di Diosyu, ya da'yuy tagu'. ");
INSERT INTO ifb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ya Ha\"in hi Apo Dios an dayawonyu an nangekak ay da'yuh ad Egypt ta bo'on ayu mahkay baal nan i'Egypt ti paddungnay inaan'u nan bahangalyu, at mi'id mahkay di abainanyuh nan pundaldallananyu.” ");
INSERT INTO ifb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ya inalin goh Apo Dios di, “Ya adiyu ay donglon nan alyo' ta ibahhawyun aton nan immandal'u, ");
INSERT INTO ifb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ya gulat ta du'gonyu nan inyuldin'u, ya adiyu pohdon nan panugun'u, ya adiyu unudon an amin nan immandal'u, at ibahhawyu ay nan intulag'un da'yu ");
INSERT INTO ifb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ya hiyah te ato' ay da'yu: Moltao' da'yuh nan atata'ot an dogoh, at mundogoh ayu ta engganay un mangpuh di odolyu, ya nunheglay lahun di odolyu ta bulawon da'yu, at maligatan ayu. Ya mid hulbiyun munhabal ti nan binuhulyuy mumpangan. ");
INSERT INTO ifb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ya du'go' da'yu ta way aton nan binuhulyun mangabak ay da'yu ta diyay mangipapto' ay da'yu, at lumayaw ayu an ta\"on un mid ah mamdug ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ya gulat ta ma'at an amin hatun da'yu ya adia' damdama unudon at udma' di moltayuh mumpapitu ");
INSERT INTO ifb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ta engganay ipa'ampayuy odolyuh nan nunheglan pumbagtuanyu, ya adi' iyabulut di udan ta nan ad dayan bagtun di wadanyu ya ay gumo', ya nan lutan gopa'onyu ya umat hinan gambang. ");
INSERT INTO ifb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ya mid hulbin di bi'ahyun muntamu ti adi tummol nan inhabalyu, ya adi bumunga nan intanomyun bungbungaan an ayiw. ");
INSERT INTO ifb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ya gulat ta du'gonyu nan panugun'u ya adiyu donglon nan hapito' at udma' nan moltayu ta mumpapituy ligat hi holtaponyu an dumalat nan baholyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ya honogo' nan atata'ot an a'animal hi inalahan ta patayonda nan imbabaluyyu ya nan a'animalyu, at umitang ayu, ya matawan nan dalanyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ya ta\"on un umat hituy ma'at ay da'yu mu adi ayu damdama magilat ti dudu'gonyu ");
INSERT INTO ifb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","at ta\"on Ha\"in ya bumungota', ya du'go' da'yu, at moltao' da'yu an dumalat nan baholyu, at iyal'alla' an udman hi mumpapituy aat di punligatanyu ya un din nahhun. ");
INSERT INTO ifb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ya iyabulut'un gubaton da'yu ta miballoh nan adiyu pangunudan hinan intulag'un da'yu. Ya gulat ta ihi'ugyun mumpo\"oy hinan na'allup an siudad ya ipiyali' di dogoh ta mumpundogoh ayu, at abakon da'yuh nan binuhulyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ya pa\"io' nan alpuwan di ononyu ta way aton nan himpulun binabain munlalammung hi ihaangdah tinapay ta un ohay punhaanganda. Ya kiluonday ipiyapongdan da'yuh ma'an, mu adi ayu damdama mabhug. ");
INSERT INTO ifb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ya ta\"on un ma'at an amin hatun da'yu mu adiyu damdama donglon nan alyo' ti unna' at goh du'gon ay da'yu, ");
INSERT INTO ifb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","at bumungota' hi nidugah, ya du'go' da'yu, at Ha\"in ya moltao' da'yuh ligat hi mumpapitu an dumalat nan baholyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","At nunheglay punhinaanganyu ta la'tot ya ihdayuy imbabaluyyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ya pumpa\"i' nan o\"ongol an abung an pundayawanyuh nan bulul, ya numpuhit'u nan bululyu, ya nun'iyuhun'u nan nun'atoy an odolyuh nan bululyu. Ya pahiwo' ahan da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ya pa\"io' nan siudadyu ta mun'akakda nan tatagu, ya umat goh hinan lugal an inlahhinyuh pundayawanyu ta mabau, ya adi' mahkay abuluton nan e'nongyun maphod di hunghungna. ");
INSERT INTO ifb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ya punhegloo' an pumpa\"i nan lutayu ta manoh'a nan binuhulyun nunhituh di an mannig hi apa\"iana. ");
INSERT INTO ifb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ya pun'iwa'at'u da'yuh nan numbino'ob'on an abablubabluy, ya ipangunud'uy ligatyu, at mataynan nan lutayu, ya nan nunhituwanyun siudad ya mun'apa\"i. ");
INSERT INTO ifb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ya ta way aton nan lutayun mun'a\"alenawan mun'eblay ti tinaynanyu, ya immuy ayuh nan lutan nan binuhulyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ya heden tawon an atawanan nan luta di hiyay pun'eblayana ti agguy nun'eblay hidin nunhituwanyuh di. ");
INSERT INTO ifb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ya da'yu an hinhinnohhan mataguh nan abablubabluy di binuhulyu ya pata'to' da'yu ta ammunah nan mun'al'alaha'ah an tubun di ayiw an matuyupan ya numpangalayaw ayu, ya tumagtag ayun paddungnay waday mamdug ay da'yuh pumatoy, ya munlu'bub ayu an ta\"on hi un mi'id mangunud ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ya munhuhuggit ayun lumayaw ta mun'igatin di udumnan da'yu an ta\"on un mi'id mamdug ay da'yu. Ya mid ologyun mi'gubat hinan binuhulyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ya nan babluy an iwa'atanyuy hiyay atayanyu an nan lutan di binuhulyu. At hidiy ilubu'anyu. ");
INSERT INTO ifb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ya da'yun ma'angang an adi matoy ya ma'inu'inut ayu damdaman ma'ubah hinan babluy di binuhulyu ti dumalat nan baholyu ya nan bahol goh nan o'ommodyu an mi'yubah goh ay dida. ");
INSERT INTO ifb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Mu gulat ta muntutuyu nan holagyuh nan numbaholanda ya umat goh hinan numbaholan nan o'ommodda (an nan agguyda nangunudan ay Ha\"in ti din'ugda nan Uldin'u ");
INSERT INTO ifb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ta omod un'u goh din'ug dida, ya inwa'at'u didah nan lutan nan binuhulda), mu ipa'ampada ay nan aatdan mumpabagtu, ya inabulutda nan moltadan dumalat di baholda ya din nan'ugandan Ha\"in ");
INSERT INTO ifb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ya un'u nomnomon din intulag'un da Jacob, ya hi Isaac, ya hi Abraham, ya pi'nomnom'u goh din intulag'un luta. ");
INSERT INTO ifb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ti heden luta ya taynanda, at ma\"alenawa nan luta ti mun'eblay eden tawon an natawanana. Ya hiyah te moltadah agguyda nangabulutan hinan Uldin'u ya nan nan'ugandah nan Mandal'u. ");
INSERT INTO ifb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ya ta\"on hi unda inat hatu ya hidih nan awadandah lutan nan binuhulda ya adi' ahan tagwa dida inganuy ya du'gon ta adida mun'a'ubah ti adi' pa\"ion din intulag'un dida. Ti Ha\"in hi Apo Dios an dayawonda. ");
INSERT INTO ifb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ya diday dumalat ya nomnomo' din intulag'uh nan o'ommodda an din enekak'ud Egypt an toto'lon nan tataguy nakakanda ta Ha\"in di dayawonda. Ti Ha\"in hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ya hiyanay Uldin ya Mandal an indat Apo Dios ay Moses hinan Duntug an Sinai hi ni'tulaganah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Alyom hinan holag Israel di, Wada ay di ohan da'yun mangilahhin hi ohay tagu ta idawatnan Apo Dios ya mabalin an hay pihhuy ipallognan idat. ");
INSERT INTO ifb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ya umat hituy bayadda: nan lala'in muntawon hi ba'intih engganay nanom ya hay balul di mibayad ya ba'intiy gramos hi silver, mu mipaddung di damotnah nan pungkilun di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ya gulat ta babai an umat hinay tawona ya un himpulu ta duway gramos hi silver. ");
INSERT INTO ifb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ya nan tagun muntawon hi lemah engganay ba'inti ya hay balul di bayadan di lala'i ya un waluy gramos hi silver, ya hay babai ya un opat hi gramos hi silver. ");
INSERT INTO ifb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ya nan tagun un himbulan ta engganay lemay tawona ya hay balul hi bayad di lala'i ya duway gramos hi silver, ya hay babai ya un ohay gramos hi silver. ");
INSERT INTO ifb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ya nan tagun nanom di tawona unu nahuluk ya hay balul hi bayad di lala'i ya onom hi gramos hi silver, ya hay babai ya un opat hi gramos hi silver. ");
INSERT INTO ifb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ya gulat ta nan tagu an nawotwot ta adina olog an mamayad hinan na'alih balul hi bayadana ya miyuy hinan padi ta oyhonay balul di bayadana ta miyunnudan hinan abalinana. ");
INSERT INTO ifb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ya gulat ta hay mitulag ya hay ongol an animal at hiyay me'nong ay Apo Dios, ya henen animal an nidat ya mumbalin hi me'gonan. ");
INSERT INTO ifb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ya adi mabalin hi unna hukatan nan indawatna an maphod an animal hinan nappuhin animal, unu hukatana nan nappuhin animal hinan maphod an animal. Mu gulat ta hukatana nan animal hi animal goh ya heden mahukatan ya nan nihukat ya me'gonandan duwa. ");
INSERT INTO ifb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ya gulat ta hay mitulag ya nan animal an ma'alih adi maleneh an adi mabalin hi me'nong ay Apo Dios ya mahapul an miyuy hinan hinagang di padi. ");
INSERT INTO ifb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ta nan padi ya tigonay aat nan animal hi un nappuhi unu maphod ya binalulana, ya nan pumbalul nan padi ya hiyay balulna. ");
INSERT INTO ifb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mu gulat ta pohdonan bangngadon ya takapanah ba'intih porcento nan balulna. ");
INSERT INTO ifb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ya itulag ay han tagu han abungnan Apo Dios ta me'gonan an adaw ya tigon nan padiy aat nan abung hi un nappuhi unu maphod, ya nan pumbalul nan padi ya hiyay ma'unud. ");
INSERT INTO ifb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ya gulat ta pohdon nan nangidawat hi abungnan Apo Dios an bangngadon nan impa'dawna ya takapanah ba'intih porcento nan ibayadna, at mibangngad nan abungnan hiya. ");
INSERT INTO ifb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ya gulat ta itulag nan tagun Apo Dios di itang hinan lutana ya hay pumbalulda ya hay bilang di oho' an mun'olog hi mitanom hinan luta, ya hay bayad di ohay kaban hi oho' ya himpuluy palatan silver. ");
INSERT INTO ifb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ya gulat ta itulag nan tagu nan lutana eden Tawon an Behtan di Pangibangngadan ya hay pumbalulda ya hay balul nan luta tuwali. ");
INSERT INTO ifb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mu gulat ta nalpah nan Tawon an Behtan di Pangibangngadan ya unna idawat nan luta ya hay aton nan padin mumbalul ya hay bayadana ya nan bilang di tawon ya un madatngan nan Tawon an Behtan di Pangibangngadan, at waday itang hi ma'aan hinan balulna. ");
INSERT INTO ifb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ya gulat ta nan mangitulag hinan luta ya pohdonan bangngadon ya bayadana nan balul nan luta, ya inokpanah ba'intih porcento. ");
INSERT INTO ifb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ya gulat ta agguyna binangngad nan lutana ya nila'uh udum an tagu ya mi'id mahkay di biyangnan mamangngad. ");
INSERT INTO ifb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","At madatngan ay heden Tawon an Behtan di Pangibangngadan ya nan payaw ya me'gonan an adaw Apo Dios, at nilahhin an payaw. At bagin nan papadih den luta. ");
INSERT INTO ifb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ya gulat ta waday mangidawat ay Apo Dios hinan lutan penla'na an bo'on lutadan hina\"ama tuwali ");
INSERT INTO ifb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ya nan padiy mangalih un atnay balul nan lutah bayadana ya un madatngan nan Tawon an Behtan di Pangibangngadan, ya idat de han tagu nan bayadna eden algaw ta nan pihhuy midat hi me'gonan an adaw Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","At madatngan ay nan Tawon an Behtan di Pangibangngadan ya mibangngad nan lutah nan ad luta tuwali. ");
INSERT INTO ifb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ya an amin nan balul nan pamangngadyu ya mahapul an miyunnudan hinan pungkiluan di Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ya an amin nan mun'ahhun an i'lum nan o\"ongol an animal ya babbagin Apo Dios tuwali ti an amin di mahhun ya bagina, at adi mabalin an idawat an ta\"on un nan uyaw an baka unu kalnilu. ");
INSERT INTO ifb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mu nan mahhun an i'lum nan ma'alih adi maleneh an animal ya mabalin hi mabangngad hi unna bayadan nan na'alih balulna, ya inokpanah ba'intih porcento. Mu adina ay bayadan ya mila'uh nan balulna an na'ali. ");
INSERT INTO ifb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ya an amin nan nilalahhin tuwali an nun'ahhun an gina'un di tagun Apo Dios an nan tagu, ya animal, ya nan nihabal hinan lutayu ya adi mabalin an mila'u ya mabangngad, ti an amin nan nidawat ya me'gonan ahan ti bagin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ya ta\"on hi un tagu an ni'tulag ya adi mabalin hi mabangngad, at hay atonda ya unda patayon. ");
INSERT INTO ifb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ya an amin nan bungan nan nihabal hinan luta an umat hi paguy ya nan ayiw an bungbungaan ya bagin Apo Dios, at mahapul an idatyu nan himpulun porcento ta bagina. ");
INSERT INTO ifb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ya wada adyay mamhod an mamangngad hinan indatna an bagin Apo Dios ya bayadanay balulna, ya inokpanah ba'intih porcento. ");
INSERT INTO ifb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ya nan miyamiyapuluh nan a'animal ya bagin Apo Dios, at mabilang ay nan baka, unu kalnilu, ya nan udum an pinanganyun animal, ya nan miyapulu ya bagin Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ya nan ad animal ya adina tigon heden idatnah un nappuhi nan animal ta ihukatna, mu gulat ta hukatanah den nahhun an animal ya heden nahukatan ya nan hukatna ya me'gonandan duwa, at adi mabalin hi mabangngad.” ");
INSERT INTO ifb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ya hiyatuy Uldin hi indat Apo Dios ay Moses hinan Duntug an Sinai an miyuldin hinan holag Israel.");
INSERT INTO ifb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ya nan hopap di algaw hinan miyadwan bulan hinan miyadwan tawon hi nakakan nan holag Israel ad Egypt ya ni'hapit hi Apo Dios ay Moses hinan wadanah dih nan Tuldan Abung hi wadan Apo Dios hinan Mapulun an Sinai an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Da'yu ay Aaron ya uyaponyuh unda atnay holag Israel an mete\"an didan himpangapu ta engganah nan papamilyada, ya itudo'yu nan ngadanda, ya lahhinonyun itudo' nan ngadan an amin nan linala'i. ");
INSERT INTO ifb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ya da'yun Aaron ya itudo'yun amin nan ahimpahimpangapun linala'in muntawon hi ba'inti ya han nahuluk an way olognan muntindaluh ad Israel. ");
INSERT INTO ifb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ya ta waday bumadang ay he\"a ya malpuy ohan lala'ih nan hinohhan himpangapu, ya mahapul an hiyay ap'apudan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","At hiyatuy ngadan danen linala'in bumadang ay he\"a: An hay holag Reuben hi middum ay da'yu, ya hi Elizur an hina' Shedeur, ");
INSERT INTO ifb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ya hay holag Simeon ya hi Shelumiel an hina' Zurishaddai, ");
INSERT INTO ifb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ya hay holag Judah ya hi Nahshon an hina' Amminadab, ");
INSERT INTO ifb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ya hay holag Issachar ya hi Nethanel an hina' Zuar, ");
INSERT INTO ifb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ya hay holag Zebulun ya hi Eliab an hina' Helon, ");
INSERT INTO ifb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ya hay holag Joseph an nalpun Ephraim ya hi Elishama an hina' Ammihud, ya hay holag Manasseh ya hi Gamaliel an hina' Pedahzur, ");
INSERT INTO ifb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ya hay holag Benjamin ya hi Abidan an hina' Gideoni, ");
INSERT INTO ifb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ya hay holag Dan ya hi Ahiezer an hina' Ammishaddai, ");
INSERT INTO ifb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ya hay holag Asher ya hi Pagiel an hina' Okran, ");
INSERT INTO ifb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ya hay holag Gad ya hi Eliasaph an hina' Deuel, ");
INSERT INTO ifb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ya hay holag Naphtali ya hi Ahira an hina' Enan.” ");
INSERT INTO ifb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Didanay linala'in hinohhah napto' hinan tatagun i'Israel an diday mumpapto' ay didan himpangapu, ya diday ap'apuh nan do'ol an holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ya inamung da Moses ay Aaron nan linala'in nitudo' di ngadanda, ");
INSERT INTO ifb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ya inamungdan amin nan tatagu, ya eden hopap di algaw hinan miyadwan bulan ya impitudo' di hinohhay ngadanda, ya hay ad holag ay dida, ya nan tutulangda, ya didan hina\"ama, ya na'ohha'ohhan nitudo' di ngadandan nilahhin nan linala'in nuntawon hi ba'inti ya han nahuluk. ");
INSERT INTO ifb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ti hiyah ne immandal Apo Dios ay Moses hi atona. At hidih nan Mapulun an Sinai di nangyapanah nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ya hiya hatuy holag Reuben an nan pangpangullun holag Israel: an amin nan linala'in muntawon hi ba'inti ya han nahuluk an olognan muntindalu ya na'yapda ya un na'ohha'ohhan nitudo' di ngadanda, ya hay ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ya hay uyap nan holag di a'apun Reuben ya napat ta onom di libu ya han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ya hiya hatuy holag Simeon: an amin nan linala'in nuntawon hi ba'inti ya han nahuluk di tawondan ologdan muntindalu ya inohha'ohhadan intudo' di ngadanda, ya hay ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ya hay uyap nan holag di a'apun Simeon ya nalema ta han hiyam di libu ta han tuluy gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ya hiya hatuy holag Gad: an amin nan linala'in mete\"ah ba'inti, ya han nahuluk di tawondan olognan muntindalu ya na'yapda, ya inohha'ohhadan intudo' di ngadanda, ya hay ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ya hay uyap nan holag di a'apun Gad ya napat ta han lemay libu ya han onom di gahut ta nabongle. ");
INSERT INTO ifb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ya hiya hatuy holag di a'apun Judah: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya na'yapda, ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ya hay uyap nan holag di a'apun Judah ya napitu ta opat di libu ya han onom di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ya dida hatuy holag ya a'apun Issachar: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ya danen na'yap ya nan udum an holag ya a'ap'apun Issachar ya nabongle ta opat di libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ya dida hatuy holag ya a'ap'apun Zebulun: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya na'yap, ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ya danen na'yap ya nan udum an holag di a'ap'apun Zebulun ya nabongle ta pituy libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ya dida hatuy holag ya a'ap'apun Joseph an nangadnan hi Ephraim: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya na'yapda, ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ya danen na'yap ya nan udum an holag ya a'ap'apun Ephraim ya napat di libu ya han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ya dida hatuy holag ya a'ap'apun Manasseh: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya na'yapda, ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ya danen na'yap ya nan udum an holag di a'ap'apun Manasseh ya tulumpulu ta duway libu ya han duway gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ya dida hatuy holag ya a'ap'apun Benjamin: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ya danen na'yap ya nan udum an holag ya a'ap'apun Benjamin ya tulumpulu ta lemay libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ya dida hatuy holag ya a'ap'apun Dan: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya na'yapda, ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ya danen na'yap ya nan udum an holag ya a'ap'apun Dan ya nanom ta han duway libu ya han pituy gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ya hay holag ya a'ap'apun Asher: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya inohha'ohhadan intudo' di ngadandan, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ya danen na'yap ya nan udum an holag ya a'ap'apun Asher ya napat ya han ohay libu ta han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ya hay holag ya a'ap'apun Naphtali: an amin nan linala'in mete\"ah ba'inti ya han nahuluk di tawondan ologdan muntindalu ya inohha'ohhadan intudo' di ngadanda, ya nan ad holag ay didan himpangapu, ya didan hina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ya danen na'yap ya nan udum an holag ya a'ap'apun Naphtali ya nabongle ta tuluy libu ta han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ya didanay enyap da Moses ay Aaron an intudo'da, ya nan himpulu ta duwan a'ap'apun mangipangpanguluh nan holag Israel ya way ohan didaan impapto'na didan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ya umat goh hinan linala'in ahimpahimpangapun holag Israel ti an amin nan way olognan muntindalu ya na'yapda goh. ");
INSERT INTO ifb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Ya hay lammung an amin di uyapda ya onom di gahut ta han tuluy libu ya han lemay gahut ta nabongle. ");
INSERT INTO ifb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mu an amin nan ahimpahimpangapu an holag Levi ya agguyda niddum an na'yap. ");
INSERT INTO ifb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ti inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ya hay mahapul ya adim pi'yuyap nan holag Levi unu iddum hinan na'yap an udumnan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mu hay atom ya pot'om nan holag Levi ta diday okod an manalimun hinan Tuldan Abung hi wada' an Dios an nihinan nan Uldin ya an amin nan alimatungna. Ya diday mami'ug hinan Tuldan Abung ya nan alimatungna, ya dida goh di manalimun an mangipapto'. At hay ihinan nan puntuldaanda ya nan nunlene'woh di Tuldan Abung hi wada' an Dios. ");
INSERT INTO ifb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ya wa ay ta mumbotan ayu ya mahapul an nan holag Levi di okod an mama'ah, ya dida goh di okod an mangipata'dog hinan Tuldan Abung hi wada' an Dios an puntuldaandah nan aha\"adana. Ya wa ay di umuy meheggon hinan Tuldan Abung an bo'on holag Levi ya mahapul an mapatoy. ");
INSERT INTO ifb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ya an amin nan holag Israel ya ma'uhi'uhig di umapalanda ti way ohah nan himpangapu ya waday bantiladah nan puntuldaanda. ");
INSERT INTO ifb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mu nan holag Levi ya umapaldah nan nunlene'woh nan Tuldan Abung hi wada' an Dios ta diday manalimun ya mungguwalya ta mi'id ah tagun umuy meheggon ta adi' moltaon nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","At an amin nan immandal Apo Dios ay Moses ya hiyay inunud nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ya ni'hapit hi Apo Dios ay da Moses ay Aaron an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ya way ohah nan holag Israel ya iyammaday tuldah ihinandah nan way bantilada ta pangimmatunan ay didan ohan himpangapu. Ya ibataanday pangiyammandah nan tuldada, mu punlene'wohondah nan Abung an Tuldan awada' an Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ya hidih nan appit hi buhu'an di algaw di nihinan nan bantilan di holag Judah, at hidiy puntuldaan nan titindaluna. Ya hay mangipangpanguluh nan tatagun Judah ya hi Nahshon an lala'in imbaluy Amminadab. ");
INSERT INTO ifb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ya hay lammung di uyap nan tatagu ya napitu ta opat di libu ya han onom di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ya hay mehnod ay dida an muntulda ya nan himpangapun holag Issachar, ya hay mangipangpangulun dida ya hi Nethanel an hina' Zuar. ");
INSERT INTO ifb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ya hay lammung di uyapda ya nabongle ta opat di libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ya hay mehnod ay Issachar an umapal ya nan a'apun Zebulun, ya hay mangipangpangulun dida an a'apun Zebulun ya hi Eliab an hina' Helon. ");
INSERT INTO ifb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ya hay lammung di uyapda ya nabongle ta pituy libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ya an amin hanan tatagun napto' an immapal an a'apun da Judah ya hay lammung di uyapdan amin ya hinggahut ta han nawalu ta han onom di libu ya han opat di gahut. Ya wa ay ta mumbotanda ya diday mahhun hi mangipangpang'uh nan akakanda. ");
INSERT INTO ifb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ya hidih nan appit hi agwan hi un hagangon di buhu'an di algaw di niha\"adan nan bantilan Reuben, at hidiy puntuldaan nan titindaluna. Ya hay mangipangpangulun dida ya hi Elizur an lala'in hina' Shedeur. ");
INSERT INTO ifb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ya hay lammung di uyapda ya napat ta han onom ya han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ya hay mun'apal hi mehnod ay Reuben ya nan a'apun Simeon, ya hay mangipangpangulun dida ya hi Shelumiel an hina' Zurishaddai. ");
INSERT INTO ifb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ya hay lammung di uyapda ya nabongle ta hiyam di libu ya han tuluy gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ya hay mehnod an muntulda ya nan himpangapu an dana' Gad. Ya hay mangipangpangulun dida ya hi Eliasaph an lala'in hina' Deuel. ");
INSERT INTO ifb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ya hay lammung di uyapda ya napat ta han lemay libu ya han onom di gahut ta han nabongle. ");
INSERT INTO ifb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ya hiyah te uyap an amin nan tindalun nalpuh nan appit di nuntuldaan da Reuben, ya hay lammung di uyap an amin nan tindalu ya hinggahut ta han nabongle ta ohay libu ya han opat di gahut ta nabongle. Ya wa ay ta mumbotanda ya diday mehnod an mi'bulog hinan a'apun Judah. ");
INSERT INTO ifb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ya wa ay ta mekak nan Tuldan Abung hi wadan Apo Dios ya nan holag Levi ya diday migagwah nan duwan himpampun hinan pumbotananda. Ya mipaddung hi aat di napanuhan di nuntuldaanday aat goh di panuh nan pumbotananda an way ohaan mihihinnadah nan wadan di bantilada. ");
INSERT INTO ifb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ya hidih appit di alimuhan di algaw di niha\"adan nan bantilan Ephraim, at hidiy nuntuldaanda. Ya hay mangipangpangulun dida ya hi Elishama an lala'in hina' Ammihud. ");
INSERT INTO ifb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ya hay lammung di uyapda ya napat di libu ta han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ya hay mehnod goh hi muntulda ya nan himpangapu an dana' Manasseh. Ya hay mangipangpangulun dida ya hi Gamaliel an lala'in hina' Pedahzur. ");
INSERT INTO ifb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ya hay lammung di uyapdan na'uhig ya tulumpulu ta duway libu ta han duway gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ya hay mehnod goh an muntulda ya dana' Benjamin. Ya hay mangipangpangulun dida ya hi Abidan an lala'in hina' Gideoni. ");
INSERT INTO ifb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ya hay lammung di uyapdan na'uhig ya tulumpulu ta han lemay libu ta han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ya hay na'yap hi lammung nan tatagun nuntuldah nan awadan dana' Ephraim ya hinggahut ta han waluy libu ya han hinggahut. Ya diday miyatluh mi'bulog an umuy mumbotan. ");
INSERT INTO ifb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ya hay muntuldah appit hi iggid hi un hagangon di buhu'an di algaw ya dana' Dan hinan wadan di bantilada. Ya hay mangipangpangulun dida ya hi Ahiezer an hina' Ammishaddai. ");
INSERT INTO ifb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ya hay uyapdan amin ya nanom ta han duway libu ya han pituy gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ya hay mehnod an umapal ya dana' Asher. Ya hay mangipangpangulun dida ya hi Pagiel an lala'in hina' Okran. ");
INSERT INTO ifb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ya hay lammung di uyapdan amin ya napat ta han ohay libu ya han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ya hay mehnod an muntulda ya dana' Naphtali. Ya hay mangipangpangulu ya hi Ahira an lala'in hina' Enan. ");
INSERT INTO ifb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ya hay lammung di uyapda ya nabongle ta tuluy libu ta han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ya hay uyap an amin nan immapal hinan awadan nan a'apun Dan ya hinggahut ta han nabongle ta pituy libu ya han onom di gahut. Ya diday miyangunuh an mi'bulog an ipangulun nan bantilada. ");
INSERT INTO ifb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hiyanay uyap an amin di holag Israel an nan nalpuh nan ahimpahimpangapu. Hay uyapdan amin ya onom di gahut ta han tuluy libu ya han lemay gahut ta nabongle. ");
INSERT INTO ifb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mu nan holag Levi ya agguyda niddum an ne'e'yap hinan holag Israel ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","At nan holag Israel ya inatdan amin nan immandal Apo Dios ay Moses. At hiyah ne inatda an way ohaan nuntuldah nan wadan di bantilada, ya umat goh hinay inatdan numbotan ti nalalammungda nan himpangapu an mabulog. ");
INSERT INTO ifb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ya hiya hatuy holag Aaron ya hi Moses hidin gutud di ni'hapitan Apo Dios ay Moses hinan Duntug an Sinai. ");
INSERT INTO ifb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ya hay ngadan nan linala'in imbabaluy Aaron ya hi Nadab an pangpangullu, ya un hi Abihu, ya un hi Eleazar, ya un hi Ithamar. ");
INSERT INTO ifb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hiya hanay ngadan nan linala'in imbabaluy Aaron an muntamuh tamun Apo Dios, ya nahiitandah nan lanan danum, ya nidawatda ta hi Apo Dios di itamuanda. ");
INSERT INTO ifb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mu da Nadab ay Abihu ya natoyda ti dimmalat nan nibahhaw an nun'onngandan apuy ay Apo Dios hi awadandah nan Mapulun an Sinai. Ya mi'id holagdan duwa. At da Eleazar ay Ithamar di nihukat an numpadih din gutud di atagun Aaron an hi amada. ");
INSERT INTO ifb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Iyuymu nan holag Levi, ya impa'innilam didah nan Nabagtun Padin hi Aaron ta bumadangdan hiya. ");
INSERT INTO ifb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ya badangandah Aaron ya nan tataguh nan way hinagang di Tuldan Abung hi wada' an Dios ta diday mangitamuh nan matamuan hinan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ya diday manalimun an amin hinan gina'un di Tuldan Abung hi wada' an Dios, ya diday mangitamuh nan matamuan hinan pundayawan nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ya nan holag Levi di bumadang ay Aaron ya nan linala'in imbabaluyna. ");
INSERT INTO ifb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ya pot'om hi Aaron ya nan linala'in imbabaluyna ta dida ya anggay di mangat hi tamun di papadi, ya wa ay di udumnah mangat eten tamu an bo'on holag Levi ya mahapul an mapatoy.” ");
INSERT INTO ifb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ha\"in ya pento\"uh Levi ya nan holagna ay didan holag Israel ta diday mipallog hinan linala'in papangpangullun itungaw nan binabain holag Israel, at hiyanan mihakup ay Ha\"in nan holag Levi. ");
INSERT INTO ifb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ti an amin di pangpangullun imbabaluyyu ya nilahhindah bagi'. Ti hidin numpamataya' hi an amin hinan papangpangullun linala'in imbabaluy di i'Egypt ya nan nahhun an ini'lum di a'animalda ya agguy'u ni'patoy di pangpangullun imbabaluy nan holag Israel ya nan nahhun an ini'lum nan a'animalda ti bagi' dida. Ti Ha\"in di na'abbagbagtun Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ya hidin awadan da Moses hinan Mapulun an Sinai ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Itudo'mun amin nan linala'in holag Levi an mete\"ah nan hinohinohhan pamilya ya didan himpangapu, ya uyapom an mete\"ah nan ohay bulana ya han nahuluk.” ");
INSERT INTO ifb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ya inat Moses nan inalin Apo Dios ay hiya, at enyapna dida. ");
INSERT INTO ifb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","At hiyatuy ngadan nan tulun linala'in imbaluy Levi an hi Gershon, ya hi Kohath, ya hi Merari. ");
INSERT INTO ifb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ya hiyatuy ngadan nan himpangapu an holag Gershon. At hay ngadan nan linala'in imbabaluy Gershon ya da Libni ay Shimei. ");
INSERT INTO ifb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ya hi Kohath ya opat di linala'in imbabaluyna an hi Amram, ya hi Izhar, ya hi Hebron, ya hi Uzziel. ");
INSERT INTO ifb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ya hi Merari ya duway linala'in imbabaluyna an da Mahli ay Mushi. Didanay holag di a'apun Levi an himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ya duway napu'agan nan a'apun Gershon an nan himpangapun holag Libni ya nan himpangapun holag Shimei. ");
INSERT INTO ifb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ya hay lammung di nitudo' hi uyap nan linala'in holag Gershon an mete\"ah ohay bulan ya han nahuluk ya pituy libu ta han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ya nan himpangapun holag Gershon di mungkampuh way agwid nan Tuldan Abung hi wada' an Dios hi appit di alimuhan di algaw. ");
INSERT INTO ifb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ya hay mangipangpanguluh nan tatagun holag di a'apun Gershon ya hi Eliasaph an hina' Lael. ");
INSERT INTO ifb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ya hay tamun nan linala'in holag Gershon ya diday okod an manalimun hinan atap di Tuldan Abung'u an Dios, ya nan kultina, ya nan kultinan di pantaw nan Tuldan Abung, ");
INSERT INTO ifb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ya nan kultinah nan luhud hi gettaw, ya nan kultinan di pantaw hinan luhud an nunlene'woh hinan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ya opat di himpangapuh napu'agan nan a'apun Kohath an dana' Amram, ya hi Izhar, ya hi Hebron, ya hi Uzziel. ");
INSERT INTO ifb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ya hay uyap an amin di linala'in mete\"ah ohay bulan ya han nahuluk ya waluy libu ta han onom di gahut. At diday okod an manalimun hinan Nidugah an Me'gonan an Kuwaltu ya nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ya hay ihinan di tuldan nan linala'in holag Kohath ya medelloh hinan Tuldan Abung'u an Dios hi appit hi agwan hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ya hay mangipangpanguluh nan holag di a'apun Kohath ya hi Elizaphan an lala'in imbaluy Uzziel. ");
INSERT INTO ifb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ya diday okod an manalimun hinan Kahon an Nittuwan di Himpulun Uldin, ya nan lamehaan, ya nan ipattu'an di hilaw, ya nan duwan pun'onngan, ya nan gina'uh nan Me'gonan an Kuwaltu, ya nan kultina, ya nan udum an matamuan. ");
INSERT INTO ifb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ya nan imbaluy Aaron an hi Eleazar di hiyay ap'apun an amin nan a'ap'apuh nan holag Levi, ya hiyay mangipapto' hinan muntamuh nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ya duwan himpangapuy napu'agan nan a'apun Merari an dana' Mahli ay Mushi. ");
INSERT INTO ifb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ya hay lammung di uyap nan linala'in holagda an mete\"ah ohay bulan ya han nahuluk ya onom di libu ya han duway gahut. ");
INSERT INTO ifb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ya hay ap'apun nan himpangapun dana' Merari ya hi Zuriel an hina' Abihail. Ya hay pangihinandah nan tuldan abungda ya nan pangngel di Tuldan Abung hi appit hi iggid hi un hagangon di buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ya hay itamun nan holag Merari ya diday okod hinan ayiw an niyammah nan da'lig di Tuldan Abung'u an Dios, ya nan tu'udna, ya nan modidi, ya nan ipattu'an di tu'ud, ya an amin nan alimatungna, at didan amin di okod ay danen tamuda. ");
INSERT INTO ifb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Ya dida goh di manalimun hinan tu'ud di nunlene'woh an luhud, ya nan ipabunanda an nan palo', ya nan talin an hogwod. ");
INSERT INTO ifb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ya da Moses ay Aaron ya nan linala'in imbabaluyday muntuldah appit di hinagang nan Tuldan Abung'u an Dios hi appit di buhu'an di algaw. Ya diday okod an manalimun hinan Me'gonan an Kuwaltu ya nan holag Israel. Ya wa ay di nat'on an tagun meheggon hinan Me'gonan an Kuwaltu ya mahapul an mapatoy. ");
INSERT INTO ifb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ya hay lammung di uyap an amin di linala'in mete\"ah ohay bulan ta han nahuluk hi enyap Moses ay didan na'uhi'uhig an ahimpahimpangapu ya ba'inti ta duway libu an hiyah ne immandal Apo Dios hi atonda. ");
INSERT INTO ifb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ya inalin Apo Dios ay Moses di, “Uyapom an amin nan papangpangullun linala'in holag Israel an mete\"ah ohay bulan ya han nahuluk, ya intudo'muy ngadanda. ");
INSERT INTO ifb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ya ilahhinmu nan holag Levi ta bagi' dida ta diday mihandih nan papangpangullun linala'in imbabaluy di holag Israel, ya nan a'animal di holag Levi ya diday mihandih nan mahhun an i'lum nan a'animal di holag Israel. Ha\"in hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","At intudo' Moses an amin nan papangpangullun linala'ih nan holag Israel ti hiyah ne immandal Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ya hay lammung di uyap an amin nan papangpangullun linala'in mete\"ah ohay bulan ya han nahuluk an nitudo' di ngadanda ya ba'inti ta han duway libu ya han duway gahut ya napitu ta tulu. ");
INSERT INTO ifb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ya ni'hapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“An amin nan holag Levi ya diday mihandih nan papangpangullun linala'in holag Israel, ya nan a'animal nan holag Levi di mihandih nan mahhun an i'lum nan a'animal di holag Israel. Ti Ha\"in ad bagih nan holag Levi ti Ha\"in hi Apo Dios an nabagbagtu. ");
INSERT INTO ifb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ya hay mahandian ya duway gahut ta han napitu ta tuluh nan linala'in papangpangullun imbabaluy di tatagun holag Israel ti do'do\"ol di uyapda ya un nan holag Levi ");
INSERT INTO ifb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","an hay bayad di ohah pangpangullu ya lemah silver an miyunnudan hinan kiluh nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ya idatmun da Aaron ya nan linala'in imbabaluyna nan pihhu an bayad nan mahandian.” ");
INSERT INTO ifb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ya inamung Moses nan pihhun mihandih nan nahawal an tatagun agguy hinandian Levi. ");
INSERT INTO ifb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ya hay lammung di kilun an amin nan inamungnan silver an handin nan papangpangullun imbabaluy di holag Israel ya hinlibu ta han tuluy gahut ta han nanom ta lema an miyunnudan hinan pungkilun nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","At indat Moses ay da Aaron ya nan linala'in imbabaluynah den silver an bayad daden linala'i ti hiyay inalin Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ya inalin Apo Dios ay da Moses ay Aaron di. ");
INSERT INTO ifb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Uhigonyun itudo' nan linala'in imbabaluy nan holag Kohath, ya uyaponyu didan hinohhan hinhomolag an mete\"ah nan himpangapu ta nangamung hinan nunhina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","At mete\"ah muntawon hi tulumpulu ta engganah nabongle an way abalinandan muntamuh nan Tuldan Abung'u an Dios. ");
INSERT INTO ifb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","At hay tamun nan linala'in holag Kohath ya dida goh manalimun hinan me'gonan an gina'un nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ya wa ay ta mitolman nan Tuldan Abung ya humgop da Aaron ya nan linala'in imbabaluynah nan Tuldan Abung ta anonda nan kultina an niholda' ya nan kultinan inhophopdah nan Kahon an Nittuwan di Himpulun Uldin. ");
INSERT INTO ifb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ya igottapdan ihophop nan ma\"aphod an lalat an nalpuh up'up di animal an dugong, ya enegtapda goh hinan tu'yapna nan mumpugagaw an lo'ob, ya impahduda nan attang hinan ipahduanda. ");
INSERT INTO ifb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ya ap'apandah lo'ob an mumpugagaw nan lamehaan an ipattu'an di munnononnong an tinapay, ya duyu, ya nan malukung, ya nan alubna, ya nan ittuwan di danum, ya nan tinapay an mahapul an munnonong an mipapattang. ");
INSERT INTO ifb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ya hinophopandan amin hinan lo'ob an mumbobollah, ya inggottapdan ihophop nan lalat an nalpuh up'up di dugong ta nalpah ay ya impahduda nan attang. ");
INSERT INTO ifb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ya alanda nan lo'ob an mumpugagaw ta hophopanda nan ipattu'an di hilaw, ya nan hilawna, ya nan ipit, ya nan ittuwan di dapul, ya nan ittuwan di lana an panilaw. ");
INSERT INTO ifb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ya teneplagandan amin hanan gina'una, ya imbi'lugdah nan lalat an up'up di dugong, ya inhinadah nan ipahduan di attang. ");
INSERT INTO ifb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ya hophopandah nan mumpugagaw an lo'ob nan balitu' an pun'onngan, ya ginottapandah nan lalat an nalpuh up'up di dugong, ya impahduday attangna. ");
INSERT INTO ifb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ya alandan amin nan gina'un ma'usal hinan Me'gonan an Kuwaltu, ya teneplagandah nan lo'ob an mumpugagaw, ya ginottapandah nan lalat an nalpuh up'up di dugong, ya inhinadah nan way ipahduan di attang. ");
INSERT INTO ifb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ya anondah mahhun nan dapul hinan pun'onngan ya unda hophopan hinan mumpugagaw an lo'ob. ");
INSERT INTO ifb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ya impattu'dan amin nan gina'uh nan pun'onngan an nan ittuwan di dapul, ya nan tuwi', ya nan daludun di dapul, ya nan batya. Ya imbi'lugdah nan lalat an up'up di dugong, ya impahduday attangna an ayiw. ");
INSERT INTO ifb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ya unat goh lempah da Aaron ya nan linala'in imbabaluynan nami'lug hinan mun'a'e'gonan an gina'u ta ipadehdan mumbotan ya immuyda nan holag Kohath ta diday mangiyattang. Mu mahapul an adida ahan dapoon nan me'gonan an gina'u ti matoyda. At nan linala'in imbabaluy Kohath di mangiyattang an amin hinan alimatung nan Tuldan Abung'un Dios. ");
INSERT INTO ifb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ya hay tamun Eleazar an lala'in imbaluy Aaron an Nabagtun Padi ya hiyay manalimun hinan lanan ma'usal hinan hilaw, ya nan ma\"aphod di hunghungnan incense, ya nan me'nong hi abigabigat an Onong an Ma'an, ya nan lanan ma'usal hinan way midawat. Ya hiyay okod an manalimun hinan Tuldan Abung'un Dios, ya an amin nan ma'usal an wah di, ya nan Nidugah an Me'gonan an Kuwaltu, ya nan gina'una.” ");
INSERT INTO ifb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ya inalin Apo Dios ay da Moses ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Adiyu pogpogon nan holag Kohath hi iddumandah nan holag Levi. ");
INSERT INTO ifb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ta adida matoy hinan eheggonandah nan me'gonan an alimatung ya umat hituy atonyun dida ta da Aaron ya nan imbabaluynan papadi ya umuydah nan Me'gonan an Kuwaltu, ya impiyapongday tamun di hinohhah mabalin hi odnanda. ");
INSERT INTO ifb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Mu nan holag Kohath ya mahapul an adida humgop an umuy tigon nan me'gonan an alimatung an ta\"on un na'amtang ti matoyda.” ");
INSERT INTO ifb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Uyapom nan linala'in imbabaluy Gershon an mete\"an didan himpangapu ta nangamung hinan hinohhan pamilya. ");
INSERT INTO ifb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ya mete\"ah muntawon hi tulumpulu ta engganah muntawon hi nabongle ya itudo'mu nan way olognan muntamu ta muntamudah nan Tuldan Abung'un Dios. ");
INSERT INTO ifb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","At hiyah ne aton nan holag di a'apun Gershon ti diday muntamu ya mumpi'ug. ");
INSERT INTO ifb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","At diday mami'ug hinan kultinan di Tuldan Abung'un Dios an migottap hinan atapna, an nan ma\"aphod an lalat an up'up di animal an dugong, ya nan kultinan di pantaw nan Tuldan Abung, ");
INSERT INTO ifb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ya nan kultinan di gettaw nan nunlene'woh hinan Tuldan Abung'un Dios, ya nan pun'onngan, ya nan talin, ya an amin nan udum an alimatungna an ma'usal. Ya nan holag Gershon di mangat an amin ay daten tamu. ");
INSERT INTO ifb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ya da Aaron ya nan linala'in imbabaluynay okod an mangimandal hinan holag Gershon hi atonda ta itududay pi'ugondah nan puntamuanda. At imandalmu ay didan hinohhay tamu ta hiyay atonda. ");
INSERT INTO ifb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ya hiya hatuy tamuan nan linala'in imbabaluy di holag Gershon hinan Tuldan Abung'un Dios. Ya hay mangimandal hinan tamuda ya hi Ithamar an lala'in imbaluy Aaron an Nabagtun Padi.” ");
INSERT INTO ifb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ya inalin goh Apo Dios di, “Ya uyapom nan na'uhi'uhig an holag di a'apun Merari, ");
INSERT INTO ifb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ya mete\"ah muntawon hi tulumpulu ta engganah muntawon hi nabongle ya itudo'mu nan way olognan muntamu ta diday muntamuh nan Tuldan Abung'un Dios an a'amungan. ");
INSERT INTO ifb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","At hiyah te tamudah nan Tuldan Abung an diday mami'ug hinan tablan nen abung, ya an amin nan modidina, ya nan tu'udna, ya nan palo', ya nan ipabunan di tu'ud. ");
INSERT INTO ifb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Ya nan tu'ud di luhud nan nunlene'woh, ya nan nipabunan di tu'ud, ya nan palo', ya nan talin an hogwod, ya an amin nan udum an ma'usal hi puntamuanda. Ya ipiyapongmuy odnan di hinohha. ");
INSERT INTO ifb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hiyanay tamun nan linala'in imbabaluy dana' Merari hinan Tuldan Abung'un Dios an ipapto' Ithamar an hina' Aaron an Nabagtun Padi.” ");
INSERT INTO ifb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ya da Moses ay Aaron ya nan a'ap'apun nan tatagu ya enyapda nan a'apun Kohath an na'uhi'uhig di nahlagandan pamilya. ");
INSERT INTO ifb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ya mete\"ah nan muntawon hi tulumpulu ta engganah nan muntawon hi nabongle an ologdan muntamu ta diday muntamuh nan Tuldan Abung hi wadan Apo Dios ");
INSERT INTO ifb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ya duway libu ya han pituy gahut ta nabongley uyapdan amin an himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hiyah te uyap an amin di holag Kohath an muntamuh nan Tuldan Abung hi wadan Apo Dios an enyap da Moses ay Aaron ti hiyah ne din immandal Apo Dios ay Moses hi atona. ");
INSERT INTO ifb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ya hiyah ne na'yap hinan linala'in imbabaluy Gershon an didan himpangapu ta engganah nan munhina\"ama. ");
INSERT INTO ifb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ya mete\"ah muntawon hi tulumpulu ta engganah nan muntawon hi nabongle an olognan muntamu ta muntamudah nan Tuldan Abung hi wadan Apo Dios ");
INSERT INTO ifb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ya hay lammung di uyapdan amin an himpangapu ya duway libu ya han onom di gahut ta han tulumpulu. ");
INSERT INTO ifb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hiyanay lammung di na'yap an linala'in holag di a'apun Gershon an muntamuh nan Tuldan Abung hi wadan Apo Dios. At enyap da Moses ay Aaron dida ti hiyah ne immandal Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ya hiyah te na'yap hinan holag di a'apun Merari an didan himpangapu ta engganah nan nunhina\"ama ");
INSERT INTO ifb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","an mete\"ah nan muntawon hi tulumpulu ta engganah muntawon hi nabongle an ologdan muntamu ta muntamudah nan Tuldan Abung hi wadan Apo Dios, ");
INSERT INTO ifb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ya hay lammung di uyapdan amin an himpangapu ya tuluy libu ta han duway gahut. ");
INSERT INTO ifb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hiyah te lammung di uyap di holag di a'apun Merari an enyap da Moses ay Aaron an hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ya hay lammung an amin nan holag Levi an enyap da Moses ay Aaron ya nan a'ap'apun di holag Israel an mete\"an didan himpangapu ta engganah nan munhina\"ama ");
INSERT INTO ifb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","an nan mete\"ah nan muntawon hi tulumpulu ta engganah nan muntawon hi nabongle an immuy muntamu ya mun'attang hinan Tuldan Abung hi wadan Apo Dios ");
INSERT INTO ifb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ya hay lammung di uyapdan amin an linala'i ya waluy libu ta han lemay gahut ya han nawalu. ");
INSERT INTO ifb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ya hiyah te immandal Apo Dios ay Moses, ya impiyapongnay tamun di hinohha ya nan pi'ugonda. At intudo' Moses didan amin ti hiyah ne immandal Apo Dios ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mandalom nan holag Israel ta pakakondah nan immapalanda nan nun'apalla', ya nan way bumuhu' an dalan nalpuh odolna, ya an amin nan alyon di Uldin an nappuhiy odolda an dumalat di nanapaandah nan natoy. ");
INSERT INTO ifb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ya pakakonyu danen linala'i unu binabai ta ibataanyu didah nan immapalanyu ta adida puhion nan numpunhituwanyu ti wadaa' an middum ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ya inunud nan holag Israel, at numpakakda didah nan immapalanda. At inatda ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Mi'hapit'ah nan holag Israel, ya alyom ay diday, Wa ay di lala'i unu babain mangat hi nappuhih nan ibbana ya agguyna inunud nan Uldin Apo Dios at henen tagu ya mabaholan. ");
INSERT INTO ifb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","At mahapul an itutuyuna nan numbaholana, ya bayadana nan moltan di baholna, ya inudmanah ba'intih porcento, ya indatnah nan tagun nangatanah nappuhi. ");
INSERT INTO ifb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mu gulat ta mi'id a'aginah pangidatanah nan bayad di baholna ya henen bayad ya bagi' an Dios, at midat hinan padi an middum hinan manilhig an kalnilu an me'nong ta Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ya an amin nan nilahhin an e'nong nan holag Israel ay Ha\"in an Dios an midat hinan padi ya henen padiy ad bagih nan midat. ");
INSERT INTO ifb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ya nan milahhin an e'nong di hinohhan tagu ya bagin nan padi.” ");
INSERT INTO ifb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Alyom hinan tatagun holag Israel di, Wa ay di babai an nangilugtap hi ahawana ");
INSERT INTO ifb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ti enelo' di ohan lala'i, mu agguy inilan nan ahawana, ");
INSERT INTO ifb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ya la'tot ya han ahawanan lala'i ya nipaddeh ya immilugtap unu nun'olom an ta\"on hi mi'id di inatnah nappuhi, ");
INSERT INTO ifb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ya iyuy nan lala'i han ahawanah nan padi, ya odnanay e'nongna an ohay halub an alenah barle, mu adina udman hi mantika unu nan incense ti hiyah ne Onong di Annel, ya me'nong ta panginnilaan hi un numbahol henen babai. ");
INSERT INTO ifb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","At iyuy nan padih nen babai, ya eheggonah nan awada'. ");
INSERT INTO ifb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ya alan nan padi nan me'gonan an danum an nittuh nan pannuman, ya inummal hi hupu' hinan dotal di Tuldan Abung hi wada', ya inittunah nan danum. ");
INSERT INTO ifb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ya iyuy nan padi nan babai, ya inhagangna hiyah nan awada' an Dios, ya enyaynay buu'na, ya impadonan hiya nan onong an mangipanomnom an hiyah ne Onong di Annel, ya nan padiy mangdon hinan mun'aklit an danum an mangidat hi moltana. ");
INSERT INTO ifb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ya nunhapataon nan padih nen babain alyonan hiyay, Gulat ta immannung an mi'id nangelo' ay he\"ah udumnan lala'i ya agguymu inlugtapan hi ahawam at mi'id di baholmu at heten danum an umidat hi idut ya mi'id di nappuhih ma'at ay he\"a! ");
INSERT INTO ifb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mu gulat ta inlugtapam hi ahawam an waday nangelo' ay he\"ah udumnah lala'i ");
INSERT INTO ifb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","at ma'idutan'a, at he\"ay pangipa'annunga' an Dios hinan idut ta pangitigan nan ni'babluyam hi un'a mabo'nan, ya adi'a umimbaluy! ");
INSERT INTO ifb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","At heten danum an mangidat hi molta ya umuy hi putum ta mabo'nan'a, ya hiyay dumalat hi adim pun'imbaluyan! Ya mahapul an tobalon han babain alyonay, Oo, mipa'annung. ");
INSERT INTO ifb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ya an amin hatun na'at an idut ya intudo' nan padih nan pepel, ya inulahanah nan mun'aklit an danum. ");
INSERT INTO ifb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ya mahapul an ipa'inumnan den babai nan danum an mun'aklit an umidat hi idut, at umuy hi putuna nan danum, ya malmuy nidugah an paddungnay holtapona. ");
INSERT INTO ifb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ya alan nan padi nan inodnan nan babai an bogah an Onong di Annel, ya inlayatnah den onong hinan hinagang'un Dios, ya inyuynah nan pun'onngan an e'nong. ");
INSERT INTO ifb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ya innal nan padiy hinggamal eden bogah an Onong an Ma'an ta mangipanomnom, ya genhobnah nan pun'onngan. Ya unat goh nalpah ya impa'inumnah nan babai nan danum. ");
INSERT INTO ifb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ya gulat ta immannung an numbahol heden babai ti inlugtapna han ahawana at heden danum an umidat hi idut an ininumna ya idatnay nunheglah munha'it. At heden putun den babai ya mabo'nan, ya adi mahlag. At innilaon nan ni'babluyana an hiya ya na'idutan. ");
INSERT INTO ifb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mu gulat ta nan babai ya agguy numbahol ti mi'id inatnah nappuhi at mi'id al'alin hiya, at dumo'ol di holagna. ");
INSERT INTO ifb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","At hiyah te uldin hi ma'at hi un way mun'annel ti wa ay ta nan babai ya inlugtapanah ahawana at mumbahol. ");
INSERT INTO ifb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Unu gulat ta mun'annel han lala'i an e'lomnay un way enelo' nan ahawana at iyuyna nan ahawanah nan awadan di hinagang'un Dios ta nan padiy mangat hinan uldin di annel eden babai. ");
INSERT INTO ifb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ya henen lala'in ahawana ya agguy ni'bahol, mu han babain ahawanay numbahol, ya hiyay munholtap hinan molta.” ");
INSERT INTO ifb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ya ni'hapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Gulat ta waday lala'i unu babaih mamhod an mangilahhin hi odolna ta midawat ay Apo Dios ta mibilang hi Nazirite ");
INSERT INTO ifb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ya mahapul an adi uminum hi bayah, ya adi goh ahan uminum hinan bumutong. Ya adi goh uminum hi danum di greyp an ta\"on un adi bumutong, ya adi goh uman hi bungana an ta\"on nan mamaganan. ");
INSERT INTO ifb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ya heden pangilahhinanah odolna ya adina goh onon di bungan nan greyp an ta\"on nan bugwana unu upa'na. ");
INSERT INTO ifb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ya henen nidawatanan Apo Dios ya adina ahan ipa'lot di buu'na ta engganah un magtud heden algaw an nangidawatanah odolnan Apo Dios. Ya heden nidawatana ya mahapul an me'gonan ya ipa'adu\"oyna nan buu'na. ");
INSERT INTO ifb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ya henen algaw an nidawatanan Apo Dios ya adina dapoon di odol di natoy an tagu. ");
INSERT INTO ifb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ya ta\"on un hi amanay natoy, unu hi inana, unu nan a'agina, ya adina dapoon ta adi malugitan ti agguy nagtud heden algaw an nidawatanan Apo Dios hi tamuna. ");
INSERT INTO ifb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","At henen algaw hi nidawatana ya milahhin hi pannig Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ya gulat ta himbumagga ya way matoy ya nedeneh ay hiya, ya dinapana, at nahewa'el heden nangidawatanah odolna. At mahapul an ipamukmuknay ulunah un magtud di pituy algaw an hiyah ne pangalyan di Uldin an pinumhod di odolna. ");
INSERT INTO ifb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ya nan miyawalun algaw ya mahapul an iyuynay duwah balug unu duwah bunun an putta ta idatnah nan padih nan pantaw di Tuldan Abung hi wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ya e'nong nan padiy ohan balug ta Onong di Bahol ya nan oha ya Onong an Moghob ta hiyay a'aliwan di bahol nen tagu an dumalat di nanapaanah nan natoy an tagu. Ya henen algaw ya mahapul an ipidwanan mangidawat ay Apo Dios hi odolna. ");
INSERT INTO ifb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ti din nangidawatanah odolnah din hopapna ya adi mibilang ti nilahulah an dumalat din natoy, at mahapul an ipidwana goh an mumbilang hi algaw an umat hi bilang din hopapna, at iyuynay kalniluh ohay tawona ta Onong di Nibahhawana. ");
INSERT INTO ifb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ya hiyah te uldin hinan nangidawat hi odolnan Apo Dios, ya wa ay ta nagtud heden algaw an nidawatana ya iyuy nan padi hiyah nan pantaw di Tuldan Abung hi wadan Apo Dios an a'amungan ");
INSERT INTO ifb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ta iyuyna e'nong daten tulun kalnilun mi'id ah ganitda, ya ohay tawonan manilhig an kalnilu ta hiyay Onong an Moghob, ya nan ohay tawonan tennan kalnilun mi'id ganitna ta hiyay Onong di Bahol, ya nan ohay tawonan manilhig an kalnilu ta hiyay Onong di Pi'lenggopan, ");
INSERT INTO ifb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ya iddumda goh di ohay bahkit an agguy nabino'bo'an an tinapay an nan ma'adyamu' an alenay niyamma an nalamutan hi mantika, ya nan ma'an, ya ma'inum an me'nong ta diday Onong an Ma'an ya Onong an Ma'inum. ");
INSERT INTO ifb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ya an amin hana ya iyuy nan padih nan awadan di hinagang Apo Dios, ya e'nongna nan Onong di Bahol ya nan Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ya e'nongna nan kalnilun Apo Dios ta Onong di Pi'lenggopan, ya iddumnan e'nong goh nan tinapay an nittuh nan bahkit. Ya e'nong goh nan padi nan ma'an ya ma'inum ta Onong an Ma'an ya Onong an Ma'inum. ");
INSERT INTO ifb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ya mukmukan den Nazirite nan nidawat an buu'nah nan pantaw di Tuldan Abung hi wadan Apo Dios, ya alana nan olot di buu'na an nidawat, ya impulu'nah nan nanghobandah nan Onong di Pi'lenggopan. ");
INSERT INTO ifb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ya nalpah ay an namukmukan henen Nazirite ya alan nan padi din nihaang an palpalang di kalnilu, ya inalna goh di ohan tinapay an agguy nabino'bo'an an nittuh bahkit, ya nan mayapit an tinapay an agguy nabino'bo'an ya impadonah nan nunhapata. ");
INSERT INTO ifb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ya inlayat nan padi ta e'nongnan Apo Dios ta Onong an Milayat. Ya daten nidawat ya midat hinan padi an middum nan nilayat an boga' ya nan ulpun di kalnilu. Ya nalpah ay ya mabalin an uminum hi bayah henen Nazirite. ");
INSERT INTO ifb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hiyanay uldin nan Nazirite an mangihapatan Apo Dios. Mu nan nunhapata an mun'onong hinan pangidawatanah odolna ya nan udum an intulagnah e'nongnan Apo Dios ya mahapul an ipa'annungna nan intulagna ta unudona nan uldin an ma'at hinan ilahhinana.” ");
INSERT INTO ifb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ya ni'hapit hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Mi'hapit'a ay da Aaron ya nan linala'in imbabaluyna ta alyom ay diday, Hiyah te atonyun munwagah hinan holag Israel, ya umat hituy hapitonyun dida: ");
INSERT INTO ifb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Wagahan da'yu, ya halimunan da'yun Apo Dios! ");
INSERT INTO ifb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ya hom'on da'yu, ya ipadutu' goh da'yu! ");
INSERT INTO ifb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ya maphod un da'yu halimunan, ya ipalenggop da'yu! ");
INSERT INTO ifb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ya umat hinay atonyun manapit hi ngadan'uh pungwagahyuh nan tatagun holag Israel, at wagaha' goh dida.” ");
INSERT INTO ifb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ya heden algaw an nangelpahan Moses an nangipata'dog hinan Tuldan Abung hi wadan Apo Dios ya linamuhanah lana, ya indawatnan Apo Dios, ya indawatna goh an amin nan me'gonan an gina'unah di, ya nan pun'onngan, ya nan gina'una goh. ");
INSERT INTO ifb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ya nan a'ap'apun nan mangipapto' ay didan himpangapu an dida din nangipanuh hidin na'yapandan nun'onong. ");
INSERT INTO ifb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ya idatday e'nongdan Apo Dios an onom hi punluganan an kalesa an waday hophopna, ya himpulu ta han duwan baka, ya daden hindudwan ap'apu ya ohay kalesa di indatda, ya ohay bakah indat nan hinohhan ap'apu, ya inyuydah nan way hinagang di awadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Abulutom nan e'nongda ta way ma'usal hinan Tuldan Abung'un Dios an a'amungan, ya indatmuh nan holag Levi ti hiyah ne mahapuldah nan tamuda.” ");
INSERT INTO ifb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","At inyabulut Moses, ya innalna nan punluganan ya baka, ya indatnah nan holag Levi. ");
INSERT INTO ifb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ya indatnay duwah nan punluganan, ya opat an bakah nan linala'in imbabaluy Gershon ti hiyah ne mahapuldah nan tamuda. ");
INSERT INTO ifb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ya indatnay opat an punluganan an kalesa ya walun bakah nan linala'in imbabaluy Merari ti mahapuldah nan tamuda. Ya hi Ithamar an hina' Aaron an Nabagtun Padiy mangipapto' ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mu nan holag Kohath ya mi'id di nidat ay dida ti hay tamuda ya diday manalimun hinan me'gonan an gina'u an diday gun mami'ug. ");
INSERT INTO ifb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ya heden algaw an nangidawatandah nan pun'onngan ya inyuy nan a'ap'apuy onongda, ya impatangdah nan way hinagang di pun'onngan ");
INSERT INTO ifb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ti inalin Apo Dios ay Moses di, “Abigabigat ya ma'ohha'ohha nan a'ap'apun mangiyalih nan e'nongdah nan idawatan nan pun'onngan.” ");
INSERT INTO ifb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ya hay mahhun an mangiyalih ene'nongnah nan hopap di algaw ya hi Nahshon an lala'in imbaluy Amminadab an holag di a'ap'apun Judah. ");
INSERT INTO ifb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. At hiyanay ene'nong Nahshon an lala'in imbaluy Amminadab. ");
INSERT INTO ifb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ya hay miyadwah algaw ya hi Nethanel an lala'in imbaluy Zuar an mangipapto' hinan holag Issachar di mangiyuy hi onong. ");
INSERT INTO ifb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. At hiyanay ene'nong Nathanel an lala'in imbaluy Zuar. ");
INSERT INTO ifb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ya hay miyatluh algaw ya hi Eliab an lala'in imbaluy Helon an mangipapto' hinan holag Zebulun di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Eliab an lala'in imbaluy Helon. ");
INSERT INTO ifb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ya hay miyapat hi algaw ya hi Elizur an lala'in imbaluy Shedeur an mangipapto' hinan holag Reuben di nangiyuy hinan ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotna an nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Elizur an lalal'in imbaluy Shedeur. ");
INSERT INTO ifb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ya nan miyalemah algaw ya hi Shelumiel an lala'in imbaluy Zurishaddai an mangipapto' hinan holag Simeon an didan himpangapuy nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotna an nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Shelumiel lala'in imbaluy Zurishaddai. ");
INSERT INTO ifb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ya hay miyonom hi algaw ya hi Eliasaph an imbaluy Deuel an mangipapto' hinan holag Gad di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotna an nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Ya hiyanay ene'nong Eliasaph an lala'in imbaluy Deuel. ");
INSERT INTO ifb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ya hay miyapituh algaw ya hi Elishama an imbaluy Ammihud an mangipapto' hinan holag Ephraim di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Elishama an lala'in imbaluy Ammihud. ");
INSERT INTO ifb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ya hay miyawalun algaw ya hi Gamaliel an lala'in imbaluy Pedahzur an mangipapto' hinan holag Manasseh di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotna an nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Gamaliel an imbaluy Pedazur. ");
INSERT INTO ifb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ya hay miyahiyam hi algaw ya hi Abidan an lala'in imbaluy Gideoni an mangipapto' hinan holag Benjamin ya hiyay nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Abidan an lala'in imbaluy Gideoni. ");
INSERT INTO ifb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ya hay miyapuluh algaw ya hi Ahiezer an lala'in imbaluy Ammishaddai an mangipapto' hinan holag Dan di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Ahiezer an lala'in imbaluy Ammishaddai. ");
INSERT INTO ifb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ya hay miyapulu ta ohay algaw ya hi Pagiel an lala'in imbaluy Okran an mangipapto' hinan holag Asher di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotna an nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Pagiel an lala'in imbaluy Okran. ");
INSERT INTO ifb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ya hay miyapulu ta duway algaw ya hi Ahira an lala'in imbaluy Enan an mangipapto' hinan holag Naphtali di nangiyuy hi ene'nongna. ");
INSERT INTO ifb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ya hay ene'nongna ya ohan silver an duyun hay damotna ya ohay kilu ya han godwa, ya nan silver an malukung an hay damotnan nikiluh nan me'gonan an kiluan ya godway kilu (ya danen duwa ya nun'apnuh alena, ya nalamutan hi mantika an hiyah ne Onong an Ma'an), ");
INSERT INTO ifb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ya ohan duyun balitu' an hay damotna ya hinggahut ta han himpuluy gramo (ya napnuh incense), ");
INSERT INTO ifb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ya ohay uyaw hi manilhig an baka, ya ohay manilhig an kalnilu, ya oha goh an manilhig an uyaw an kalnilun ohay tawona ta Onong an Moghob, ");
INSERT INTO ifb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ya oha goh hi buta'al an gandeng ta Onong di Bahol, ");
INSERT INTO ifb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ya hay Onong di Pi'lenggopan ya duwah manilhig an baka, ya lemay manilhig an kalnilu, ya lemah buta'al an gandeng, ya lema goh hi uyaw an buta'al hi kalnilun hinohhay tawonda. Hiyanay ene'nong Ahira an lala'in imbaluy Enan. ");
INSERT INTO ifb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ya hiya hanay ene'nong nan mumpumpapto' hinan holag Israel hidin nangidawatanda ya hiniitandah lana nan pun'onngan: an himpulu ta duwah silver an duyu, ya himpulu ta duwah silver an malukung, ya himpulu ta duwah balitu' an iduh. ");
INSERT INTO ifb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ya hay damot nan hinohhan silver an duyu ya ohay kilu ya han nahuluk hi godwa, ya hay damot nan hinohhan silver an malukung ya nahuluk hi godway kilu. Ya hay lammung di damot an amin nan silver an duyu ya himpulu ta onom di kilu. ");
INSERT INTO ifb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ya hay damot nan hinohhan himpulu ta duwan balitu' an duyu ya nahuluk hi ohay kilu, ya hay lammung di damotdan amin ya himpulu ta lemay kilu. ");
INSERT INTO ifb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ya hay lammung an amin nan a'animal ta Onong an Moghob ya himpulu ta duway manilhig an baka, ya himpulu ta duwan buta'al an kalnilu, ya himpulu ta duwan uyaw an kalnilun hinohhay tawonda (ya middum nan Onong an Ma'an). Ya hay lammung an amin nan a'animal ta Onong di Bahol ya himpulu ta duwan buta'al an gandeng. ");
INSERT INTO ifb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ya hay lammung an amin nan a'animal an Onong di Pi'lenggopan ya ba'inti ta opat hi manilhig an baka, ya nanom hi uyaw an kalnilu, ya nanom hi buta'al an kalnilun hinohhay tawonda. Hiya hanan amin di ne'nong hinan nangidawatandah nan pun'onngan hidin naniitandah lana. ");
INSERT INTO ifb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ya hinumgup hi Moses eden Tuldan Abung hi wadan Apo Dios an a'amungan ta ni'hapit ay Hiya, ya dengngolna nan himmapit an nalpuh nan numbattanan din duwan cherubim an wah nan alub nan Ma'ahhimo' an wadan nan Kahon an Nittuwan di Uldin, ya ni'hapit ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Mi'hapit'a ay Aaron ta alyom ay hiya ta tolgana nan pitu an hilaw, ya mahapul an mabnangan nan hinagang di ipattu'an nan hilaw.” ");
INSERT INTO ifb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","At hi Aaron ya tinolgana nan hilaw, ya inhagangna ta nabnangan henen hinagang nan ipattu'an di hilaw ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ya hiyah te aat di amman nan pangipattu'an hi hilaw an hay balitu' di nahibug hi niyamma an nete\"ah puuna ta engganah nan habhabung an niyunnud hinan aat di inalin Apo Dios ay Moses hi umatana. ");
INSERT INTO ifb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ilahhinmu nan holag Levi hinan holag Israel, ya leneham dida. ");
INSERT INTO ifb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ya umat hituy atom ay dida ta malenehanda: walhiam didah nan danum an a'aliwan di bahol, ya alyom ta ih'ihanday odolda, ya iloba'day lubungda ta way atondan malenehan. ");
INSERT INTO ifb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ya mun'odondah uyaw an baka, ya iniddumda nan Onong an Ma'an an nan alenan nalamutan hi mantika, ya nun'odonda goh hi ohah uyaw an baka ta Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ya itnudmu nan holag Levi ta iyuymu didah nan hinagang di Me'gonan an Kuwaltu, ya amungom an amin nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ya inyuyna didah nan way hinagang di awada' an Dios ta ho\"on nan holag Israel di uluda. ");
INSERT INTO ifb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ya indawat Aaron ay Ha\"in nan holag Levi an paddungnay Onong an Milayat ta midadaanda ta hay tamu' an Dios di itamuda. ");
INSERT INTO ifb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ya ho\"on nan holag Levi nan ulun di duwan manilhig an baka. Ta nalpah ay ya e'nongmun Ha\"in an Dios ta nan oha ya Onong di Bahol ya nan oha ya Onong an Moghob ta way a'aliwan di bahol di holag Levi ta ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ya ipata'dogmu nan holag Levi hinan way hinagang da Aaron ya nan linala'in imbabaluyna, ya paddungnay e'nongyu dida ta Onong an Milayat an me'nong ay Ha\"in an Dios. ");
INSERT INTO ifb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","At ilahhinmu nan holag Levi hinan udumnah nan holag Israel ta nan holag Levi ya mihakupdan Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ya nalpah ay an leneneham dida ya inlayatmun e'nong ay Ha\"in an Dios at humgopda mahkay an muntamuh nan Tuldan Abung an pundayawan. ");
INSERT INTO ifb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ti dida nan nilahhin hinan holag Israel ta nidawatdan Ha\"in, at bagi' dida ta diday mihukat hinan papangpangullun linala'in itungaw nan binabain holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ti hidin namataya' an amin hinan papangpangullun linala'in imbaluy di i'Egypt ya inlahhin'uh bagi' nan papangpangullun linala'in imbabaluy di holag Israel an ta\"on nan mahhun an i'lum nan a'animalda. ");
INSERT INTO ifb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","At hiyanan pento\"u nan holag Levi ta diday hukat nan papangpangullun linala'in itungaw di holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ti nan holag Levi nan pento\"uh nan holag Israel ta middumdan Aaron ya nan linala'in imbabaluyna ta bumadangdah nan matamuan hinan Tuldan Abung'un Dios an a'amungan, ya diday mange'nong hinan Onong di Bahol nan holag Israel ta ma'aliwan di baholda, ta umuyda ay meheggon hinan Me'gonan an Kuwaltu ya mi'id al'alin didan adida matoy.” ");
INSERT INTO ifb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","At indawat da Moses ay Aaron ya nan holag Israel da Levi an hina\"ama ti hiyah ne immandal Apo Dios hi atonda. ");
INSERT INTO ifb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","At lenenehan nan holag Levi nan odolda, ya inloba'day lubungda, at indawat Aaron dida ta diday Milayat an Onong ay Apo Dios. Ya ene'nongna goh nan Onong di Bahol ta a'aliwan di baholda. ");
INSERT INTO ifb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ya unat goh nalpah hanan na'at ya himmigup nan holag Levi hinan Tuldan Abung hi wadan Apo Dios ta muntamuda, at binadanganda da Aaron ya nan imbabaluynah nan matamuan. Ya inunud Moses nan immandal Apo Dios ay hiyah atonah nan holag Levi. ");
INSERT INTO ifb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Hiyah te aton nan linala'in holag Levi an muntawon hi ba'inti ta lema ya han nahuluk ya mabalin an umuyda bumadang hinan Tuldan Abung'un Dios. ");
INSERT INTO ifb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mu wa ay ta muntawondah nabongle ya idinongdan muntamu an mapogpog di puntamuanda. ");
INSERT INTO ifb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mu hay atonda ya unda bumadang ya ammunah nan tamun di i'ibbadan holag Levi ta atonda nan tamuda, mu adida mi'tamuh nan malgom an tamu. At hiyah ne uldin hi ma'at hi tamun nan holag Levi.” ");
INSERT INTO ifb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ya heden hopap di bulan hinan miyadwan tawon hi nakakan nan tatagud Egypt hidin awadandah nan Mapulun an Sinai ya ni'hapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Alyom hinan holag Israel an gunda nomnomon an ibehtaan heden algaw hi gutud di namaliwa' ay didah un madatngan. ");
INSERT INTO ifb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","At wa ay ta madatngan heden miyapulu ta opat an algaw eten bulan ya nan munhinag di hiyay pangatanyun amin hinan Uldin hi ma'at eden Punnomnomanyuh Namaliwa' ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","At inalin Moses hinan holag Israel ta ibehtaanda din namaliwan Apo Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","At inunudda ta numbehtadan de han magadyuh mahdom eden miyapulu ta opat an algaw hinan hopap di bulan hidih nan Mapulun an Sinai. Ya inatdan amin henen immandal Apo Dios ay Moses hi atonda. ");
INSERT INTO ifb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mu wadaday udumnan linala'in nanapah odol nan natoy, at alyon di Uldin an nappuhiy odolda, at agguyda ni'yamung hinan Behtan di Namaliwan Apo Dios ay dida, at immuydan da Moses ay Aaron ");
INSERT INTO ifb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","an inaliday, “Nappuhiy odolmi an alyon di Uldin ti nedeneh amih nan natoy an tagu. Mu anaad ta adi mabalin an umiyuy amih onongmin Apo Dios?” ");
INSERT INTO ifb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ya tembal Moses an alyonay, “Hodonyu ta umuy'u innilaon di imandal Apo Dios hi atonyu.” ");
INSERT INTO ifb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Alyom hinan holag Israel di malgom ay da'yu unu nan holagyu an nappuhiy odolna an alyon di Uldin an dumalat di nanapaanah nan natoy an tagu unu nan way nalpuh adagwi ya mabalin an middumdan mi'behtan da'yu. ");
INSERT INTO ifb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ya nan miyadwan bulan hinan miyapulu ta opat di algaw hinan munhinag di pangatanyu, ya iddumdan pe\"an nan agguy nabino'bo'an an tinapay ya nan mun'aklit an halawhaw. ");
INSERT INTO ifb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ya mi'id ang'angondah nan ma'an ya mihdah engganah mabiggat, ya adida ipungon nan tungal nan goltonda. Ya mahapul an unudondan amin nan ma'at hinan Punnomnomandah nan Namaliwan di Anghel'un Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mu nan tagun niyuldin an maphod di odolna ya nan agguy numbaat hi adagwi ya gulatonan adi umuy mi'behta ya henen tagu ya mahapul an mapogpog di ibilanganah tagu' ti mi'id di ene'nongnan Ha\"in hidin gutud di Punnomnomandah Namaliwan di Anghel'un Dios hinan Tatagu. At henen tagu ya mahapul an holtaponay ligat an dumalat di baholna. ");
INSERT INTO ifb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Mu wa ay di bunag hi ni'hitun da'yu ta pohdonan mangat hinan atonyuh Punnomnomanyuh Namaliwan di Anghel'un Dios hinan Tatagu ya mahapul an unudonan aton an amin di Uldin hi ma'at hinan pumbehtaan. Ta mumpapaddung nan Uldin hi unudonyun amin an ta\"on un nan bunag ya nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ya unat goh nalpah an nipata'dog nan Tuldan Abung hi wadan Apo Dios an a'amungan ya naho'napan hi bunut nan Me'gonan an Kuwaltu, ya unat goh nahdom ya binumnang an ay apuy nan bunut hinan tungul di Me'gonan an Kuwaltu ta engganah nabiggat. ");
INSERT INTO ifb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ya minaynayun heten ma'at an wa ay ta mapatal ya nihoho'nap nan bunut, ya wa ay ta mahdom ya binumnang an ay apuy. ");
INSERT INTO ifb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ya wa ay ta tumulu nan bunut ad daya ya inaynayun nan holag Israel an mumbaat, ya heden lugal an duminngan nen bunut ya hiyay umapalan nan holag Israel hi ihinanda. ");
INSERT INTO ifb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ya awni ta imandal Apo Dios ya un mumbotan nan holag Israel, ya awni ta imandal Apo Dios ya unda umapal. Ya wa ay ta adi ma'aan nan bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios ya adi goh makmakkak nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ya wa ay ta do'ol di algaw hi ihihinnan den bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios ya inunud nan holag Israel nan immandal Apo Dios, at agguyda naknakkak. ");
INSERT INTO ifb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mu hin'umu'uddum ya nahnot di algaw hi iho'napan nen bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios. At imandal ay Apo Dios an adida mumbotan ya mihihinnadah di, ya wa ay ta imandal Apo Dios an mumbotanda ya unda makak. ");
INSERT INTO ifb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ya hin'umu'uddum ya miho'nap nan bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios hinan mahdom, ya wa ay ta mabiggat ta timmulu nan bunut ad daya ya mumbotanda goh nan holag Israel. At ta\"on hi un mapatal unu labi ya mumbotandah un tumulu nan bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ya gulat ta mihoho'nap nan bunut hinan bagtun di Tuldan Abung hi wadan Apo Dios hi duway algaw, unu ohay bulan, unu hintawon ya mihihinna goh nan holag Israel hidi an adida makmakkak, mu wa ay ta tumuluh nen bunut ya hiyay pumbotananda. ");
INSERT INTO ifb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ya wa ay ta imandal Apo Dios an adida makmakkak ya nihihinnadah dih nan way tuldada, ya wa ay ta imandal Apo Dios ay dida ta mumbotanda ya unda makak. At inunuddan amin nan immandal Apo Dios ay Moses hi atonda. ");
INSERT INTO ifb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Mumpa'amma'ah duwan talampet an hay mahibug ya nan silver ta way ipagangohmuh pangayagmuh nan tatagu ta ma'amungda, ya way ipagangohmuh unda ba'ahon nan tuldada ta makakda. ");
INSERT INTO ifb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","At wa ay ta pundehhonondan ipagangoh nan duwan talampet ya umalidan ma'amung an amin nan tataguh nan way hinagangmuh nan way pantaw di Tuldan Abung hi wada' an Dios an a'amungan. ");
INSERT INTO ifb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ya wa ay ta un ohay talampet hi ipagangohda ya nan mumpumpapto' hinan ahimpahimpangapun holag Israel ya anggay di ma'amung hi umalin he\"a. ");
INSERT INTO ifb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ya wa ay ta un na'amtang di gumangohan di talampet ya nan numpunhituh appit hi buhu'an di algaw di mahhun an makak. ");
INSERT INTO ifb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Mu wa ay ta mipidwa nan ho'ho'dod an gangoh di talampet ya nan numpunhituh appit hi agwan hi un hagangon di buhu'an di algaw di makak. At hay pangimmatunandah pama'ahandah nan nungkampuanda ya he'he'dod nan gumanghan di talampet. ");
INSERT INTO ifb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mu hay panginnilaan hi un ma'ayagan an amin nan tatagu ta ma'amungda ya ipagangohda nan duwan talampet, mu adu\"oy di gangohda. ");
INSERT INTO ifb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ya nan linala'in imbabaluy Aaron an papadiy mangipagangoh hinan talampet. At hiyah te uldin hi unudonyu ta gun miboltan hinan a'apuyuh enggana. ");
INSERT INTO ifb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ya wa ay di umalih nan babluyyu nan mangubat ay da'yu ya impagangohyu nan talampet an panginnilaan hi un waday gumubat ay da'yu. At badanga' da'yu, at abakonyu nan mangubat ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ya umat goh hinan algaw an pun'am'amlonganyu, ya pumbehtaanyu, ya nan behtan di hopap di algaw hinan Akayangan di Bulan ya ipagangohyu nan talampet hinan pange'nonganyuh nan Onong an Moghob ya nan Onong di Pi'lenggopanyu ti henen atonyu ya badanga' da'yu. Ti Ha\"in di Ap'apuyun hi Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ya heden miyaba'intih algaw hi miyadwah bulan eden miyadwan tawon ya timmulu din bunut an wah nan bagtun di Tuldan Abung hi wadan Apo Dios an nihinan nan Uldin. ");
INSERT INTO ifb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","At nan holag Israel ya numbotanda ta nakakdah nan Mapulun an Sinai, ya innayunayundan dimmalan ta engganay un dimminong nan bunut hinan Mapulun an Paran. ");
INSERT INTO ifb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ya hiyah ne hopap di numbotanandah nalpahan di nangidatan Apo Dios ay Moses hinan Uldin hi unudondah nan pumbaatanda. ");
INSERT INTO ifb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","At hay nahhun an nangipangpangulun immuy ya nan holag Judah an na'uhi'uhigdan himpangapu, ya inodnanday bantilada. Ya hay nangipapto' ay didan himpangapu ya hi Nahshon an lala'in imbaluy Amminadab. ");
INSERT INTO ifb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ya hi Nathanel an lala'in imbaluy Zuar di mangipapto' hinan holag di a'apun Issachar, ");
INSERT INTO ifb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ya hi Eliab an lala'in imbaluy Helon di mangipapto' hinan holag di a'apun Zebulun. ");
INSERT INTO ifb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ya bina'ahda nan Tuldan Abung hi wadan Apo Dios, at heden nangila\"uyanda ya pini'ug nan linala'in imbabaluy da Gershon ay Merari. ");
INSERT INTO ifb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ya hay nehnod an nangipadeh ya nan holag Reuben an didan himpangapu, at hay ap'apudan himpampun ya hi Elizur an imbaluy Shedeur. Ya inodnanday bantilada. ");
INSERT INTO ifb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ya hi Shelumiel an imbaluy Zurishaddai di ap'apun nan holag Simeon an didan himpangapu, ");
INSERT INTO ifb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ya hi Eliasaph an imbaluy Deuel di ap'apun nan holag Gad an didan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","At nan a'apun Levi an holag Kohath di nangipi'ug hinan me'gonan an gina'u, at mahapul an nan Tuldan Abung hi wadan Apo Dios ya mipata'dog hi mahhun ya un umatam danen nangdon hi me'gonan an gina'u. ");
INSERT INTO ifb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ya hay mehnod an mumbotan ya nan himpampun an awadan di bantilan Ephraim an didan himpangapu. Ya hay ap'apudan himpampun ya hi Elishama an imbaluy Ammihud. ");
INSERT INTO ifb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ya hi Gamaliel an imbaluy Pedahzur di ap'apun nan holag Manasseh an didan himpangapu, ");
INSERT INTO ifb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ya hi Abidan an imbaluy Gideoni di ap'apun nan holag Benjamin an didan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ya hay miyangunuh an mumbotan ya nan himpampun an awadan di bantilan Dan an didan himpangapu. Ya hay ap'apudan himpampun ya hi Ahiezer an imbaluy Ammishaddai. ");
INSERT INTO ifb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ya hi Pagiel an imbaluy Okran di ap'apun nan holag Asher an didan himpangapu, ");
INSERT INTO ifb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ya hi Ahira an imbaluy Enan di ap'apun nan holag Naphtali an didan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","At hiyah ne aat di apanuhan di pumbotanan nan holag Israel an mangipadeh ta ma'uhi'uhigdan himpampun. ");
INSERT INTO ifb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ya inalin Moses ay Hobab an imbaluy Reuel an iMidian an hi aman ahawan Moses di, “Na'uy an gun tu'u meheggon hinan babluy an din inalin Apo Dios an idatnan ditu'u, at mi'yali'an da'mi, at halimunan da'a ti intulag Apo Dios an ipaphodnay holag Israel!” ");
INSERT INTO ifb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ya tembal Hobab an alyonay, “Adia' mi'yali, at mumbangngada' hinan babluymi an wadan nan ni'babluya'.” ");
INSERT INTO ifb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ya inalin Moses di, “Adi da'mi ni' taynan ay he\"a ti maphod un'a mi'yali ti inilam di mabalin hi umapalan tu'uh nan mapulun, at he\"ay mangipangpang'un da'mi. ");
INSERT INTO ifb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ya gulat ta mi'yali'an da'mi at an amin nan mun'aphod an idat Apo Dios ay da'mi ya mipaddung an midatan'a goh!” ");
INSERT INTO ifb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ya tinaynanda nan Duntug an Sinai an me'gonan, ya tuluy algaw di dimmaladalananda. At danen nangiyattang hinan Kahon an Nittuwan di Himpulun Uldin ya inyun'unnada an umuy manganap hi pangiyammaandah nan tuldan a'ab'abbungda. ");
INSERT INTO ifb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ya nan bunut ya wagwadan munlidum ay didah nan mapatal hi unda mumbotan. ");
INSERT INTO ifb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ya an amin hinan pangipadehan nan nangiyattang eden Kahon an Nittuwan di Uldin ya alyon Moses di, “Ipapto'mu, Apu, ta punhihiyanom nan binuhul ya nan mamohol ay He\"a ta mun'akakdah nan wadam!” ");
INSERT INTO ifb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ya wa ay goh ta inta'dogda ya inalin Moses di, “Haggungom, Apo Dios, ta halimunam an ipapto' nan himpuluy libun holag Israel!” ");
INSERT INTO ifb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ya unat goh ente\"an nan holag Israel an amuyuan hi Apo Dios ya dengngolna, at nunheglay bungotnan dida. At minoltan Apo Dios dida, at genhobna nan wah nan namingngit an nuntuldaanda. ");
INSERT INTO ifb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ya ingkilan nan tatagun numpabadang ay Moses. Ya unat goh nunluwaluh Moses ay Apo Dios ya nadop henen apuy. ");
INSERT INTO ifb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","At nginadnanah nen babluy hi Taberah ti genhob nan apuy Apo Dios nan namingngit an nuntuldaanda. ");
INSERT INTO ifb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ya wadada han himpampun an bunag an nitnud ay dida, ya nundugudah nan nat'on an ma'an, ya natalam nan holag Israel, at inte\"adan umamuyun alyonday, “Anuud nin goh di panamtaman tu'uh dotag? ");
INSERT INTO ifb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ya adimi aliwan nan do'ol an ekan an inihdamih awadanmid Egypt an mid bayadna! Ya umat hinan do'ol an ma'an an ahimmun, ya pakwan, ya danggu, ya amput! ");
INSERT INTO ifb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mu ad ugwan ya mi'id bi'ah di odolmi ti mi'id di udum hi ma'an an anggay heten manna hi gunmi onon hi abigabigat!” ");
INSERT INTO ifb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Ya hay aat den manna ya umat hinan it'ittang an bugwa an hay kololna ya muntitiba. ");
INSERT INTO ifb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ya abigabigat ya umuy amungon nan tataguh den bugwa, ya genelengda unu unda ibayu ta magimu' an umat hi alena, ya inhaangda unu iyammaday udumnah tinapay, ya hay tamtamna ya umat hinan tinapay an na'udman hi mantikan di olibo. ");
INSERT INTO ifb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ya wa ay ta nahdom ya dimmulnuh nan nuntuldaanda ya middum nan manna an mi'yagah.) ");
INSERT INTO ifb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ya dengngol Moses nan kumilaan nan tatagu an numpangata'dogdah nan pantaw di a'abungda, ya ma'abbungot hi Apo Dios ay dida, ya binum'on goh hi Moses. ");
INSERT INTO ifb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ya inalin Moses ay Apo Dios di, “Anaad ta idatmun ha\"in di umat hitun naligat an tamu? Undan way numbahola' ay He\"a ta e'kodmun ha\"in an amin daten tatagu? ");
INSERT INTO ifb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Undan ha\"in di paddungnay nangihabin daten tatagu? Ya undan ha\"in di paddungnay nangitungaw ay dida ta alyom ay ha\"in di halimuna' dida an umat hi panalimun di ommod hinan ung'ungnga ta nangamung un'u iyatam dida eden lutan intulagmuh din o'ommodda? ");
INSERT INTO ifb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","At hay pangngala' mah hi dotag hi mun'olog hi ipihda' ay daten amin an tatagu? Ti lumugwadan mangitugtugan mangalih idata' didah dotag hi ihdada! ");
INSERT INTO ifb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mid olog'un mangipapto' ay daten tatagu ti unna' oh'ohha, ya ten nidugah an do'olda! ");
INSERT INTO ifb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","At gulat ta umat hituy atom ay ha\"in ya hom'ona' ta punnaudom ya pinatoya' ta adi' ni' ahan holtapon nan punligligata'!” ");
INSERT INTO ifb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ya tembal Apo Dios hi Moses an inalinay, “Pot'om di napitu an a'ap'apuh nan holag Israel an nan inilam an nanomnoman ay didan himpangapu, ya immali ayuh tuh nan Tuldan Abung'un Dios an a'amungan, ya inalim ay dida ta mi'ta'dogdan he\"a. ");
INSERT INTO ifb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","At mun'ohopa' ta mi'hapita' ay he\"ah di ta ano' nan udumnan abalinam an indat'un he\"a ta eyewel'un dida, ta way atondan mamadang ay he\"an mangipapto' hinan tatagu ta adim ohhaan. ");
INSERT INTO ifb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","At alyom hinan tatagu ta idadaanday odolda, at muntutuyuda ta pumhod di odolda ti hi ma'et ya waday dotag hi ihdada ti dengngol'un Dios nan pangikilaandan mumbagah dotag hi ihdada. Ti alyonyuy, Maphod di ononmih ad Egypt! At ad ugwan ya lumuwo' an hi Apo Dios di dotag hi ihdayu. ");
INSERT INTO ifb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ya bo'on un ohay algaw ya anggay, unu duwa, unu lema, unu himpulu, unu ba'intih algaw di pangihdanyu ");
INSERT INTO ifb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mu himbulan di pangihda'ihdanyu ta nangamung un ayu ma'ahhengla, at mumpangabuhu' hinan olongyu, ya manu ay ma'at hete ti din'uga' an Dios an wagwadan da'yu, ya amuyuana' an alyonyuy, Anaad tuwali ta ekak da'mid Egypt?” ");
INSERT INTO ifb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ya inalin Moses di, “An amin hatun tatagun i'ibba' an onom di gahut hi libun linala'i ya anaad ta alyom hi idata' didah ihdadah ohay bulan? ");
INSERT INTO ifb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ta\"on nin un maglot an amin nan do'ol an baka ya kalnilu ya undan mun'olog hi ihdadah abigabigat? Ya ta\"on un ma'ala nan ekan hi baybay ya undan mun'olog ay dida ti nidugah an do'olda?” ");
INSERT INTO ifb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ya tembal Apo Dios, ya inalinay, “Undan waday adi' abalinan hi aton? Ad ugwan ya tigom hi un ma'at unu adi nan inali' ay he\"a!” ");
INSERT INTO ifb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ya pimmitaw hi Moses, ya imbaagnah nan tatagu nan inalin Apo Dios ay hiya. At inayaganay napitun linala'in a'ap'apu an nanomnoman an mumpumpapto' hinan tatagu, ya impata'dogna dida ta lini'ubda nan Tuldan Abung. ");
INSERT INTO ifb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ya nun'ohop nan bunut an awadan Apo Dios, at ni'hapit ay Moses, ya inyewelnay udumnah nan nidat ay hiya an abalinana ta impiyodolnah nan napitun linala'in nun'anomnoman. Ya unat goh niyodol nan abalinandan indat Apo Dios ya way ohaan himmanapitdah nan impa'innilan Apo Dios hi hapitonda. Mu agguy nabayag di na'atana. ");
INSERT INTO ifb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ya waday duwah nan linala'in ne'e'yap hinan napitu an da Eldad ay Medad, mu nataynandah nan abungda ti agguyda nitnud an immuy hinan Tuldan Abung hi wadan Apo Dios, mu niddumdan nidatan hi abalinanda, ya himmapihapitdah nan impa'innilan Apo Dios ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ya dengngol han ungan lala'i, ya nunnaudonan immuy ay Moses, ya inalinay, “Da Eldad ay Medad ya himmapitdah nan impa'innilan Apo Dios ay didah di hi abungda!” ");
INSERT INTO ifb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ya hi Joshua an imbaluy Nun an bumadbadang ay Moses an nete\"ah din a'ung'ungngana di nambal an inalinay, “Apu' Moses, padinngom dida!” ");
INSERT INTO ifb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ya inalin Moses ay hiyay, “Umamoh'a ay ya adim ituduy ato' ti maphod hi un an amin nan tatagun Apo Dios ya umatdah nan propeta, at maphod hi un idatan Apo Dios didah abalinandan umat hinan propeta!” ");
INSERT INTO ifb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ya immanamut hi Moses ya nan napitun mumpumpapto' hinan holag Israel hinan immapalanda. ");
INSERT INTO ifb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ya himbumagga ya impiyalin Apo Dios di tuyup an nalpuh nan baybay, ya intuyupna nan do'ol ahan an hamuti an lallangeh, ya nun'agahdah nan way nuntuldaanda, ya paddungnay han ohan algaw an pundalanan di inadu\"oy di ado'oldah nan numpinangel hinan nuntuldaanda, ya tuluy umpiy inata'nang di natpunandah nan luta. ");
INSERT INTO ifb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ya inyal'algaw ya inlablabin nan tatagun nun'amung hinan lallangeh, ya hiya goh di inatdah din nabiggat. Ya nan nahnot di inamungna ya un hinlanggut ya anggay. Ya nun'ihapuydah nan udumnah nan nunlene'woh hinan abungda ta mapindang. ");
INSERT INTO ifb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mu alyon ta ihdada nan dotag, ya agguy napuh at ma'abbungot hi Apo Dios ay dida, at indatnay nidugah an nunligatanda. ");
INSERT INTO ifb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","At hiyanan nginadnanah den lugal ta ad Kibroth Hattaavah ti heden lugal di nangilubu'andah nan tatagu an ma'alom hi dotag. ");
INSERT INTO ifb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","At tinaynan nan tatagud Kibroth Hattaavah ta numbotandad Hazeroth ta hidiy immapalanda. ");
INSERT INTO ifb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ya unat goh inahawan Moses han babain i'Ethiopia ya pinahiw da Miriam ay Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ya inaliday, “Undan hi Moses ya anggay di pi'hapitan Apo Dios? Undan agguy goh ni'hapit ay dita?” Ya dengngol Apo Dios nan inalida. ");
INSERT INTO ifb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Hi Moses ya mumpa'ampan tagu, ya nidugdugah din nangipa'ampaanah odolna ya un an amin nan tataguh tun luta.) ");
INSERT INTO ifb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ya himbumagga ya ni'hapit hi Apo Dios ay da Moses, ya hi Aaron, ya hi Miriam an inalinay, “Da'yun tulu ya umuy ayuh nan way Tuldan Abung hi wada' an Dios!” At limmahundan tulu, ya immuyda. ");
INSERT INTO ifb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ya nun'ohop han bunut an awadan Apo Dios an ay tu'ud, ya nihinah nan pantaw di Me'gonan an Kuwaltu, ya inayagana da Aaron ay Miriam. At immuyda ta neheggondan duwa, ");
INSERT INTO ifb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ya inalinay, “Donglonyuh ten alyo'! Gulat ta honogo' nan propeta ta middum ay da'yu ya mumpa'innilaa' ay hiya ti nan pun'enapanday pi'hapita'. ");
INSERT INTO ifb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mu nat'on di ato' an mi'hapit ay Moses an baal'un na'na'unnud, at hiyay nange'koda' an amin hinan tatagu' an holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ti mi'hapita' ay ya mi'haggangana' ay hiya, ya ibaga' di pohdo' an alyon, ya innilaona ti bo'on hay nipa\"el di hapito' ay hiya. Ya anggay hiyah nannig hi aat'u. At anaad ta adi ayu tuma'ot ta hapitonyuy nappuhih aat Moses an baal'u?” ");
INSERT INTO ifb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ya ma'abbungot hi Apo Dios ay dida, ya tinaynana dida. ");
INSERT INTO ifb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ya unat goh na'ubah din bunut hidih nan pantaw di Me'gonan an Kuwaltu ya himbumagga ya napalla' hi Miriam an pimmaha' an ay dalallu. Ya unat goh tinnig Aaron hi Miriam an numbo'on di aatna ");
INSERT INTO ifb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ya inalin Aaron ay Moses di, “Apu, adim ni' ahan idat ay da'mih ten moltamin dumalat nan amanangpahmih numbaholanmi! ");
INSERT INTO ifb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","At adim ni' aton di umat hina ay hiyan matagu mu paddungnay nanattoy ti mi'id di pangngel di odolna!” ");
INSERT INTO ifb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ya numpahpahmo' hi Moses ay Apo Dios an inalinay, “Apu an nabagbagtu! Ipa'adaogmu ni' ahan hiya!” ");
INSERT INTO ifb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","At tembal Apo Dios hi Moses an inalinay, “Gulat ta binainan amana hiya ya undan adi mabainan at mipo\"oy hi pituy algaw? At okod hiyan milahhin hinan immapalanyuh pituy algaw ta malpah ay di pituy algaw ya unyu hiya pumbangngadon.” ");
INSERT INTO ifb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","At inlahhindah Miriam hi pituy algaw, ya agguyda nakak hinan immapalanda, at nan tatagu ya agguyda nakak ta engganah un numbangngad hi Miriam ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ya unat goh nalpah hene ya tinaynan nan tatagud Hazeroth ta impadehdan numbotan ta engganah unda dimmatong hinan Mapulun an Paran ta hidiy immapalanda. ");
INSERT INTO ifb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ya ni'hapit hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Honogom di linala'i ta umuyda hamadon an tigon nan lutad Canaan an idat'uh nan holag Israel. Ya an amin nan ahimpahimpangapu ya pot'om di ohah lala'in mangipapto' ay dida.” ");
INSERT INTO ifb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","At inunud Moses henen immandal Apo Dios ay hiya, at hidih nan awadandah nan Mapulun an Paran di nannaganah nan linala'in nalpuh nan hinohhan mumpapto' hinan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","At hiya hatuy ngadan nan nahnag: da Reuben an himpangapu ya hay napili ya hi Shammua an imbaluy Zakkur, ");
INSERT INTO ifb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ya da Simeon an himpangapu ya hay napili ya hi Shaphat an imbaluy Hori, ");
INSERT INTO ifb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ya da Judah an himpangapu ya hay napili ya hi Caleb an imbaluy Jephunneh, ");
INSERT INTO ifb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ya da Issachar an himpangapu ya hay napili ya hi Igal an imbaluy Joseph, ");
INSERT INTO ifb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ya da Ephraim an himpangapu ya hay napili ya hi Hoshea an imbaluy Nun, ");
INSERT INTO ifb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ya da Benjamin an himpangapu ya hay napili ya hi Palti an imbaluy Raphu, ");
INSERT INTO ifb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ya da Zebulun an himpangapu ya hay napili ya hi Gaddiel an imbaluy Sodi, ");
INSERT INTO ifb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ya da Joseph an himpangapu (ya nalpudah holag di a'apun Manasseh) ya hay napili ya hi Gaddi an imbaluy Susi, ");
INSERT INTO ifb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ya da Dan an himpangapu ya hay napili ya hi Ammiel an imbaluy Gemalli, ");
INSERT INTO ifb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ya da Asher an himpangapu ya hay napili ya hi Sethur an imbaluy Michael, ");
INSERT INTO ifb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ya da Naphtali an himpangapu ya hay napili ya hi Nahbi an imbaluy Vophsi, ");
INSERT INTO ifb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ya da Gad an himpangapu ya hay napili ya hi Geuel an imbaluy Maki. ");
INSERT INTO ifb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Hiyanay ngadan nan honogon Moses an umuy munhi'im an mangihamad hi aat nan luta. (Ya hinukatan Moses nan ngadan Hoshea an imbaluy Nun ta hi Joshua.) ");
INSERT INTO ifb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ya hidin nannagan Moses hinan linala'i ta umuyda hamadon henen lutad Canaan ya inalinan diday, “Ti'idonyu ta e'wayuh did Negev ta nangamung hinan tulid di dudunduntug. ");
INSERT INTO ifb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ya tigonyuy aat nen babluy, ya hay aat nan tatagun numpunhituh dih unda mun'abi'ah unu mi'id di bi'ahda, ya unda itang unu do'olda. ");
INSERT INTO ifb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ya tigonyu nan lutah un maphod unu nappuhi, ya nan babluy hi un agguy na'allup an nunhituwan nan tatagu unu maphod an waday allupna. ");
INSERT INTO ifb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ya tigonyu goh henen lutah un lo'eh unu adi, ya do'ol di ayiw unu mi'id. Ya adi ayu tuma'ot, at hay pumbangngadanyu ya ummal ayuh nan bungan nan ayiw an ma'an, ya inyaliyuh tu.” (Heden tawon an ayanda ya hiyay gutudnah aluman nan greyp). ");
INSERT INTO ifb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","At impadeh nan linala'in munti'id an umuy hi appit hi iggid hi un hagangon di buhu'an di algaw, ya hinamadda nan luta an inte\"adah nan Mapulun an Zin ta engganad Rehob an neheggon hi ad Lebo Hamath. ");
INSERT INTO ifb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ya nunti'iddad Negev ta engganay immatamdad Hebron an awadan da Ahiman, ya hi Sheshai, ya hi Talmai an holag Anak. (Ad Hebron ya nahhun an babluy hi pituy tawon ya un mawada nan babluy an Zoan hi ad Egypt.) ");
INSERT INTO ifb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ya unat goh immatamdah nan Hadog an Eschol ya hinobbatday ohan hapang nan greyp an nabungubungul di bungana, ya inyattang di duwan tagu, ya ni'yanamutda goh di bungan di ayiw an pomegranates ya figs. ");
INSERT INTO ifb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ya nginadnandah den lugal hi Hadog an Eschol ti dumalat nan nabungul an greyp an hinobbat nan holag Israel ta inyanamutda. ");
INSERT INTO ifb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ya napat hi algaw di nangihamadandan nannig hinan luta ya unda mumbangngad. ");
INSERT INTO ifb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ya immuyda ay Moses, ya hi Aaron, ya an amin hinan holag Israel an na'amung hidid Kadesh hinan Mapulun an Paran. At imbaagdan amin di tinnigda, ya impattigda nan bungan di nitanom an innaldan den babluy. ");
INSERT INTO ifb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ya inalidan Moses di, “Immuy amin den lutan nannagam ay da'mi, ya immannung an ma\"aphod an luta an malmuy mihabal, at do'ol di ma'an hidi, at hiyah te bungan di nitanom an innalmi. ");
INSERT INTO ifb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mu nan tatagun numpunhituh di ya mun'abi'ahda, ya nan numpunhituwanda ya o\"ongol ya nun'a'allup, ya tinnigmi goh nan holag Anak hidi. ");
INSERT INTO ifb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ya hidid Negev di nunhituwan nan holag Amalek, ya nan holag Heth, ya nan holag Amor, ya nan iJebus ya nunhitudah nan dudunduntug, ya nan iCanaan ya nunhitudah nan neheggon hi pingit di Baybay an Mediterranean ya nan Wangwang an Jordan.” ");
INSERT INTO ifb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ya impadinong Caleb danen tatagun tumayutayutub ay Moses, ya inalinay, “Munti'id tu'ud ugwan ta gubaton tu'u nan tatagu, at bagi tu'u nan luta ti abalinan tu'un abakon dida!” ");
INSERT INTO ifb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mu danen linala'in ni'yibban Caleb an immuy ya inaliday, “Adi tu'u gubaton danen tatagu ti mi'id olog tu'un dida ti mabi'ahda ya un ditu'u!” ");
INSERT INTO ifb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","At dida ya inulgudday agguy immannung hinan tatagun holag Israel hi aat nan lutan inaliday, “Henen lutan hinamadmin tinnig ya adi maphod ti nan tatagun nunhituh di ya o\"ongolda ya atata'nangda, at wa ay di umuy hidih tagu ya inu'mundan nonong di na'i'imulana! ");
INSERT INTO ifb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ya tinnigmi goh nan atata'nang an holag Anak! Ya mipaddung amih dudun hi pannigdan da'mi!” (Nan holag Anak ya holagda goh nan ma'alih Nephilim.) ");
INSERT INTO ifb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ya heden labi ya an amin nan tatagu ya enlotdan ahikikila an dumalat nan lungdayada. ");
INSERT INTO ifb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ya inamuyuanda da Moses ay Aaron an inalin din tataguy, “Onaynah un ami natoy hi ad Egypt, ya bo'on ay ya onaynah un ami matoy hinan mapulun! ");
INSERT INTO ifb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Anaad ta un da'mi inyalin Apo Dios eten babluy ta un da'mi ipapatoy hinan gubat? Ta omod unda polhon nan a'ahawami ya nan imbabaluymin ayda balud! Hay mabalin nin ya on'onaynah un ami mumbangngad hi ad Egypt!” ");
INSERT INTO ifb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ya nunhahapitdan alyonday, “Pot'on tu'uy ohah ap'apu tu'u ta way mangipapto' ay ditu'u ta un tu'uat mumbangngad hi ad Egypt!” ");
INSERT INTO ifb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ya nunlu'bub da Moses ay Aaron hinan hinagang nan tatagun na'amung hidi. ");
INSERT INTO ifb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ya da Joshua an imbaluy Nun ya hi Caleb an imbaluy Jephunneh an didan duwan ni'yuy nunhi'im an nanamad hinan luta ya pini\"iday lubungdah ha'it di punnomnomanda. ");
INSERT INTO ifb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ya inalidah nan tataguy, “Heden lutan immuymi tinnig ya ma\"aphod di alutana! ");
INSERT INTO ifb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ya gulat ta pohdon Apo Dios an iyuy ditu'un nen lutan malumong an ma\"almuy mitanom at umannung an idatnan ditu'u! ");
INSERT INTO ifb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","At adiyu du'gon hi Apo Dios, ya adi ayu goh tuma'ot hinan tatagun den babluy ti abakon tu'u dida an ayda ma'an ti aminon tu'u didan ubahon! Ti wadah Apo Dios an mamadang ay ditu'u, at ma'abakda ti ingnganuy nan ma'nongandan mamaliw ay dida! At adiyu ta'tan dida!” ");
INSERT INTO ifb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mu nunhahapit nan tatagu ta taponda dida. Himbumagga ya waday benang Apo Dios hinan way Tuldan Abung hi wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ya inalin Apo Dios ay Moses di, “Anuud nin di pangipogpogan nan tatagun man'ug ay Ha\"in? Ya anuud nin di pangulugandan Ha\"in ti ta\"on hi un do'ol di inat'uh umipanoh'an impattig'un dida? ");
INSERT INTO ifb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","At punligato' didah nidugah, ya adi' idat ay dida nan intulag'un didan tawidda! Mu nan holagmuy punholago' ta nidugah an do'olda ya un dida, ya mabi'bi'ahda goh ya un dida!” ");
INSERT INTO ifb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mu tembal Moses hi Apo Dios an inalinay, “He\"ay nangekak ay daten tataguh ad Egypt an dumalat nan abalinam! At gulat ay ta donglon nan i'Egypt nan atom an mumpamatoy ay dida ");
INSERT INTO ifb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","at alyondah nan tatagun numpunhitun ten lutay, Danen tatagu ya iniladan He\"a an Dios ya wagwada'an da'mi an gun'a numpattig ay da'mih un duminong nan bunut hi tungulmi, ya He\"ay nangipangpangulun da'mih wadam hinan ma'ugtul an bunut hinan mapatal, ya waday ay tu'ud an apuy hinan mahdom! ");
INSERT INTO ifb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ya gulat ay ta pundedehhonom an patayon an amin nan tatagum at alyon nan tataguh nan udum an babluy an nangngol hi anabagtum di, ");
INSERT INTO ifb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Manu ay numpatoyna didah nan mapulun ti adina abalinan an mangiyatam ay didah nan lutan intulagnan idat ay dida! ");
INSERT INTO ifb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","At ad ugwan, Apu, ya ihapita' ni' ahan He\"a ta ipattigmun da'mi nan nidugah an abalinam ta atom nan intulagmun da'mih din hopapna an alyom di, ");
INSERT INTO ifb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Ha\"in an Dios ya ma'ma'ullaya', ya gun'u ipattig nan nidugah an pamhod'u, ya gun'u aliwan di bahol nan numbahol ya nan adi mangunud hinan Uldin'u. Mu moltao' nan imbabaluyyu ya nan a'ap'apuyu ta nangamung nan miyapat an holagyu an dumalat nan numbaholan di o'ommodyu. ");
INSERT INTO ifb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","At aliwam ni' di numbaholan daten tatagu an dumalat nan nidugah an homo'mu an umat hi nangaliwam hi baholda an nete\"ah nakakandad Egypt ta nangamung ad ugwan!” ");
INSERT INTO ifb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ya tembal Apo Dios an inalinay, “Dumalat nan nangihapitam ay Ha\"in ya aliwa' di baholda. ");
INSERT INTO ifb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mu dumalat nan aat'u an wagwadaa' ya dumalat goh nan a'immannungan nan nun'onan an anabagbagtu' ya itulag'u ");
INSERT INTO ifb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ta an amin nan linala'in nannig hi anabagbagtu', ya nan nannig hi ina'inat'un umipanoh'an impattig'ud Egypt, ya nan nanapngan Ha\"in hi numpapuluh nan mapulun ");
INSERT INTO ifb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ya mid ah ohan didah umatam hinan lutan intulag'uh din o'ommodda. Ti adi' abuluton an nan nan'ug ay Ha\"in ya mabalin an umatamda! ");
INSERT INTO ifb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mu nan baal'un hi Caleb ya maphod di ugalina, at hiyay ipa'atam'uh nan lutan hinamadna ta ipatawidnah nan holagna ya banohdah nen luta ti inunud Caleb an amin di Tugun'u, ya agguya' din'ug ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ya nan nundotal an luta ya hiyay nunhituwan nan holag Amalek ya nan iCanaan, at hiyaat un hi ma'et ya mumbangngad ayu ta umuy ayuh nan mapulun ta ipluyyuh nan miyuy hinan Mumbolah an Baybay.” ");
INSERT INTO ifb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ya ni'hapit hi Apo Dios ay da Moses ay Aaron, ya inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Uya'a nin di pangipupulaha' hinan pangamuyuan daten nababaholan an tatagun Ha\"in? Ti dengngol'uy gun umamu'amuyuan nan holag Israel ay Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","At ipa'innilam ay didah ten pohdo' an hapiton ay dida: Ha\"in an hi Apo Dios ya wagwadaa', at dedengngol'u nan inaliyun Ha\"in, at hiya goh di ato' ay da'yu! ");
INSERT INTO ifb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","At mun'iwa'at di tungalyuh tun mapulun ta mun'atoy ayu an mete\"ah nan nitudo' di ngadanda an muntawon hi ba'inti ya han nahuluk ya an amin nan nangamuyun Ha\"in! ");
INSERT INTO ifb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ya mi'id ahan ah ohan da'yuh umatam eden lutan intulag'uh punhituwanyu an anggay hi Caleb an imbaluy Jephunneh ya hi Joshua an imbaluy Nun di umatam eden luta! ");
INSERT INTO ifb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mu danen imbabaluyyun ung'ungungnga an din inaliyuh polhon an amin di binuhulyu at nappuhiy ma'at ay dida, ya diday umatam enen intulag'un luta, at diday munhitun nen lutan din'ugyu. ");
INSERT INTO ifb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mu da'yu ya mun'atoy ayun ten mapulun! ");
INSERT INTO ifb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","At munhinagwangan nan imbabaluyyuh nan mapulun hi napat di tawon ta ibo'lada nan numbaholanyu ta engganah un ayu ma'unghiw an mun'atoy! ");
INSERT INTO ifb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","At hay uyap di algaw hi pundalananyun nen luta ya hay lammungna ya napat di tawon ti hay punholtapanyuh nan baholyuh ohay algaw ya ohay tawon di punligatanyu. Ya heden napat di tawon an punligatanyu ya hiyay panginnilaanyun din'ug'u da'yu! ");
INSERT INTO ifb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ti Ha\"in hi Apo Dios an nangali, at ipa'annung'un aton di umat hituh nan nunheglan nun'abaholan an tatagun na'amu'amung an namohol ay Ha\"in! At hituh tun mapulun di pun'atayanyu ta ma'ubah ayu!” ");
INSERT INTO ifb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","At danen linala'in hennag Moses an immuy nanamad an dumalat hinan aat den luta ya numbangngadda ta hay agguy immannung di inulguddah nan tatagu ta hiyay dumalat hi nangamuyuan nan tatagu ay Apo Dios ");
INSERT INTO ifb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ya nunligaton Apo Dios dida, at ni'yatoyda. ");
INSERT INTO ifb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ya danen himpulu ta duwan linala'in immuy nunhi'im hinan luta ya un anggay da Joshua an hina' Nun ya hi Caleb an hina' Jephunneh di na'angang an matagu. ");
INSERT INTO ifb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ya unat goh imbaag Moses hinan holag Israel nan impa'innilan Apo Dios ya nunheglan ma'allungdayada. ");
INSERT INTO ifb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","At numpangabangondan den pa'ahhelhelong eden nabiggat, ya nundadaanda ta umuydah nan dudunduntug hinan babluy ad Canaan. Ya inaliday, “Ipadeh tu'u! Da'mi ya ininnilami an numbahol ami, mu ad ugwan ya nidadaan amin umuy hinan lutan intulag Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mu inalin Moses di, “Undan engganad ugwan ya adiyu unudon nan immandal Apo Dios an inalinay, Mumbangngad ayuh nan mapulun? Mi'id hulbin nan ninomnomyun aton! ");
INSERT INTO ifb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Adi ayu ahan umuy ti abakon da'yuh nan binuhulyu ti adi da'yu badangan ay Apo Dios! ");
INSERT INTO ifb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ti wah di nan holag Amalek ya nan iCanaan an mamannod ay da'yu, at pumpatoy da'yu! Ya manu ay adi da'yu badangan ay Apo Dios ti nan agguyyu nangunudan ay Hiya!” ");
INSERT INTO ifb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mu nunti'idda damdamah nan dudunduntug an ta\"on hi un agguy nitnud hi Moses, ya agguyda inta'in din Kahon an Nittuwan di Uldin ti wah dih nan nuntuldaanda. ");
INSERT INTO ifb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","At nan holag Amalek ya iCanaan an numpunhituh nan dudunduntug ya dinamuda dida, at numpatoyday udumna, ya numpudugday udumna ta nangamung immatamdad Hormah. ");
INSERT INTO ifb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Mi'hapit'ah nan holag Israel ta alyom ay diday, Wa ay ta umatam ayuh nan lutan idat Apo Dios ay da'yu ");
INSERT INTO ifb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ya mun'onong ayuh nan onong an mipulu' ta ipa'amlongyuh Apo Dios ya hay e'nongyu ya nan baka, unu kalnilu, ya gandeng ta me'nong hi onong an mipulu', unu onong an mangipa'annung hinan way inhapatayu, unu nan pohdonyun e'nong, unu nan onong hi pumbehtaanyuh tinawon. ");
INSERT INTO ifb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Ya nan mangiyuy hi me'nong ay Apo Dios ya mahapul an okpanah Onong an Ma'an hi ohay kiluh nan na'adyamu' an alenan nalamutan hi ohay litron mantikan di olibo. ");
INSERT INTO ifb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ya udmanyuh duway litroh bayah ta Onong an Ma'inum ta middum hinan kalnilun Onong an Moghob. ");
INSERT INTO ifb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ya wa ay ta hay buta'al an kalniluy me'nong ya hay middum hi Onong an Ma'an ya duway kiluh alenan nalamutan hi ohay litron mantikan di olibo. ");
INSERT INTO ifb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ya nan Onong an Ma'inum ya ohay litro ta han godwah bayah di e'nongyu ta nan maphod an hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ya wa ay ta hay uyaw hi manilhig an bakay e'nongyuh Onong an Moghob, unu nan mangipa'annung hinan nitulag, unu hay Onong di Pi'lenggopan ay Apo Dios ");
INSERT INTO ifb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ya udmanyu nan e'nongyu an uyaw an manilhig an bakah Onong an Ma'an an tuluy kilun alenan nalamutan hi duway litron mantikan di olibo, ");
INSERT INTO ifb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ya udmanyuh Onong an Ma'inum an duway litron bayah ta Onong an Moghob ta nan hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ya hanay mahapul hi middum hinan onong an ohay manilhig an baka, unu ohay buta'al an kalnilu, unu ohah gandeng. ");
INSERT INTO ifb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Mahapul an da'yun hinohha ya hiyah ne atonyuh nan way e'nongyu, ya wa ay ta nahuluk hi ohah animal di e'nongyu ya ma'udman goh nan lukud di alena, ya bayah, ya mantika ta miyunnud hinan bilang nan animal an me'nong. ");
INSERT INTO ifb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","At an amin nan holag Israel ya mahapul an hiyah te atondah nan pun'onngandah nan onong an mipulu' ta nan maphod an hunghungnay mangipa'amlong ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ya gulat ta waday bunag an ni'hitun da'yu ta pohdonan mange'nong hinan Onong an Moghob ta nan maphod an hunghungna ya ma'abulut an umipa'amlong ay Apo Dios mu mahapul an unudona nan atonyu. ");
INSERT INTO ifb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","At an amin ayun tatagun na'amung ya un ohay Uldin ya Mandal hi unudonyu, ya hiya goh di unudon nan bunag an ni'hitun da'yu. Ti hay pannig Apo Dios ay da'yun amin ya nan bunag an ni'hitun da'yu ya numpapaddung. ");
INSERT INTO ifb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ti un ohay Uldin ya Mandal hi unudonyu, ya hiyah ne goh di unudon nan bunag an ni'hitun da'yu.” ");
INSERT INTO ifb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Alyom hinan holag Israel di, Wa ay ta umatam ayuh nan lutan pangiyaya' ay da'yu ");
INSERT INTO ifb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ya an amin di ma'an hi ma'alan nen luta ya ononyu, mu mahapul an waday milahhin ta midat hi onong Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ya e'nongyu nan iyammayun mihaang an tinapay an umat hi atonyun mange'nong hinan hopap di bento'yun ene'nong. ");
INSERT INTO ifb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ya gunyu e'nong ay Apo Dios henen hopap di iyammayun tinapay, ya ato'atonyu ta engganah nan a'apuyuh pidwa.” ");
INSERT INTO ifb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ya inalin goh Apo Dios di, “Mu gulat ta mumbahol ayu ti agguyyu inunud daten Uldin an intugun'un Dios ay Moses, ");
INSERT INTO ifb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ya gulat goh ta ibahhawyu ta adiyu unudon nan udum an immandal'un Dios ay Moses an mete\"ah din hopapna ta engganah nan holagyuh udum di algaw ");
INSERT INTO ifb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","mu agguyyu ay inatta an inat at inilan nan tatagu, ya mahapul an amindan himpamabluy ya e'nongday ohah uyaw an bakan manilhig ta Onong an Moghob, ya middum nan Onong an Ma'an ya Onong an Ma'inum ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in an Dios, ya e'nongda goh di ohah buta'al an gandeng ta Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ya nan padiy mange'nong eden Onong di Bahol nan tatagun holag Israel ta ma'aliwan di baholda an agguyda inamtan an inat ti dumalat nan inyuydan onongda ta Onong an Moghob ta me'nong ay Ha\"in an Dios, ya nan Onong di Baholda an ne'nong hinan way hinagang'u. ");
INSERT INTO ifb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","At an amin nan holag Israel an ta\"on nan bunag an ni'hitun dida ya ma'aliwan nan baholda ti na'innilan an amin nan tatagu ya agguyda ginulat heden numbaholanda. ");
INSERT INTO ifb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Mu gulat ta han ohan tagu ya agguyna ginulat ya numbahol ya mahapul an iyuynay e'nongnah ohah tennan gandeng an ohay tawonah Onong di Bahol. ");
INSERT INTO ifb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ya nan padiy mange'nong hinan Onong di Bahol nen tagun Ha\"in an Dios ta way aton nan baholnan agguyna ginulat an ma'aliwan. ");
INSERT INTO ifb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ya un ohay Uldin hi ma'unud hinan ohan tagun agguyna ginulat ya numbahol an ta\"on un holag Israel unu nan bunag an ni'babluy ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mu gulat ta way ohah tagu ya unna ginulat an nangat ya henen tagun numbahol ti unna' nginohoy an ta\"on un nan holag Israel unu nan bunag ya mahapul an mapogpog di iddumanah nan tataguna. ");
INSERT INTO ifb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ti din'ugna nan Uldin'un Dios, ya imbahhawnay Uldina, at henen tagu ya mapogpog ahan di iddumana ti hiyay ad bahol enen namatayandan hiya.” ");
INSERT INTO ifb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ya hidin awadan nan holag Israel hinan mapulun ya inah'upanday ohan lala'in mangam'amung hi ayiw hinan ngilin an Habadu. ");
INSERT INTO ifb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","At inyuy daden nangah'up ay hiya ay Moses, ya hi Aaron, ya nan na'amungan an amin nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","At imbaludda hiya ti mi'id nahahapit hi atondan hiya. ");
INSERT INTO ifb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ya la'tot ya inalin Apo Dios ay Moses di, “Henen lala'i ya mahapul an matoy, at iyuyyuh nan nibataan hinan nuntuldaanyu, ya an amin nan tatagu ya puntapayu ta engganah un matoy.” ");
INSERT INTO ifb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","At an amin nan tatagu ya imbataandah nen taguh nan way tuldada, ya nuntapada ta nangamung un natoy ti hiyah ne immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Alyom hinan holag Israel di, Tayunanyuh mangmangitit an balengbeng nan nayuy an pingit di lubungyu. Ya mahapul an minaynayun ta gunyu ato'aton ta nangamung hinan holagyuh pidwa. ");
INSERT INTO ifb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ya wa ay ta tigonyuh nen balengbeng hi pingit di lubungyu ya hiyay mangipanomnom hinan inyuldin Apo Dios ta hiyay atonyu, at adiyu mahkay unudon di pohpohdon nan odolyun aton. ");
INSERT INTO ifb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","At daney mangipanomnom ay da'yu ta atonyu nan immandalnan da'yuh unudonyu ta pumhod di ugaliyu, at mihakup ayun Hiya. ");
INSERT INTO ifb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ti hi Apo Dios an nangekak ay da'yud Egypt di dayawonyu, ti Hiyay Apuyu an Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ya wada han ohan algaw ya hi Korah (an imbaluy Izhar an holag Kohath an apun Levi), ya da Dathan ay Abiram (an imbabaluy Eliab an holag Reuben), ya hi On (an imbaluy Peleth an holag Reuben) ya immuyda numpahal ");
INSERT INTO ifb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","hi Moses, ya initnudday duway gahut ta nabonglen nabagtun linala'in a'ap'apun di holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ya inalidan da Moses ay Aaron di, “Unyu ahan ipabagbagtuy odolyu an ta\"on unyu tigon an amin daten tatagun na'amung ya agguyda nabaholan? Ti wagwada goh hi Apo Dios ay dida! At anaad ta ipabagbagtuyuy odolyu ya un nan udum an tatagun Apo Dios?” ");
INSERT INTO ifb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ya unat goh dengngol Moses hene ya nunlu'bub hinan luta, ");
INSERT INTO ifb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ya inalinan da Korah ya an amin hinan i'ibbanay, “Hi ma'et hinan helhelong ya ipa'innilan Apo Dios di immannung hi tataguna ya nan mi'id ah baholna. At nan pot'onah tataguna ya ayagana ta diday meheggon ay Hiya. ");
INSERT INTO ifb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","At he\"a, Korah, ya an amin danen i'ibbam ya mun'odon ayuh nan pangittuwan hi incense. ");
INSERT INTO ifb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Ta hi ma'et ya inittuwanyuh bala ya incense, ya inyuyyuh nan way hinagang di awadan Apo Dios. Ya nan pot'on Apo Dios ay ditu'u ya diday mi'id baholna. Ti da'yu an holag Levi ya nidugah an mumpabagtu ayu!” ");
INSERT INTO ifb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ya innaynayun Moses an inalin Korah di, “Donglonyuh te an da'yun holag Levi! ");
INSERT INTO ifb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Undan unguhanyuh nen nangilahhinan Apo Dios ay da'yuh nan tatagun holag Israel ta way atonyun miheheggon ay Hiya, ya ta da'yuy muntamuh nan Tuldan Abung hi wadan Apo Dios? Ya da'yu goh di bumadang ya ta itamuanyu goh nan tatagu! ");
INSERT INTO ifb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ya nomnomonyu an hi Apo Dios di nangilahhin ay da'yu ya an amin nan a'agiyun holag Levi ta muntamu ayun Hiya! At anaad ta unguhanyu ta ta\"on nan tamun di papadi ya pohdonyu goh un da'yuy mangitamu? ");
INSERT INTO ifb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","At hay binoholyu ya hi Apo Dios an dumalat nan nangamuyuanyun Aaron!” ");
INSERT INTO ifb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ya impa'ayag goh Moses da Dathan ay Abiram an linala'in imbabaluy Eliab. Mu impaaddan inaliday, “Adi ami umali! ");
INSERT INTO ifb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ya unmu dan unguhan di nangekakam ay da'mih nan ma\"aphod an babluy ya do'ol di ma'an ta iyali da'mih tun mapulun ta hituy pamatayam ay da'mi? Ya undan goh gahin hi un'a mumpapto' ay da'mi? ");
INSERT INTO ifb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ya hay oha goh ya engganad ugwan ya agguy goh da'mi inyatam hinan ma\"aphod an lutan ma\"almuy mihabal, at do'ol di ma'an, unu indatan hi payaw ya nan luta ta banohmi, ya nan nitamman di greyp ta banohmi! At undan alyom goh ta balbaliyam daten tatagu? Adi ami ahan umali!” ");
INSERT INTO ifb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ya ma'abbungot hi Moses, at inalinan Apo Dios di, “Adim ahan abuluton di e'nong daten tatagu ti mi'id ahan ah inat'uh nappuhin dida, ya mi'id ah ohah innal'uh dongkida!” ");
INSERT INTO ifb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","At inalin Moses ay Korah di, “He\"a ya nan i'ibbam ya umuy ayuh ma'et hinan Tuldan Abung hi wadan Apo Dios, ya mitnud goh nan duway gahut ta han nabongle, ya middum goh hi Aaron ay da'yu. ");
INSERT INTO ifb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ya an amin ayun hinohha ya mun'odon ayuh pangittuwan hi incense an duway gahut ta han nabonglen amin, ya inittuwanyuh bala, ya immuy ayuh nan wadan di hinagang Apo Dios. Ya ta\"on hi Aaron ya mi'yodon hinan ittuwan di incense.” ");
INSERT INTO ifb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","At hi na'et ya an amindan hinohha ya inodnanday pangittuwandah incense, ya nun'ittuwandah bala, ya inyuhunda nan incense, ya immuyda timma'dog hinan way pantaw di Me'gonan an Kuwaltu, ya ni'yuy goh da Moses ay Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ya unat goh inamung Korah din i'ibbana ya an amin nan holag Israel ya timma'dogdah nan pantaw di Me'gonan an Kuwaltu ta hawananda da Moses ay Aaron. Ya himbumagga ya numpattig di benang Apo Dios ay didan na'amung. ");
INSERT INTO ifb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ya himmapit hi Apo Dios ay da Moses ay Aaron, ya inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Bataananyu danen tatagu ti punnaudo' an ubahon dida!” ");
INSERT INTO ifb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ya nunlu'bub da Moses ay Aaron hinan luta, ya nunluwaludan inaliday, “He\"a, Apo Dios an alpuwan di ataguan, undan wa ay ta numbahol di ohah tagu ya ilagatmun pi'bohol an amin nan tataguh nan bumungtam?” ");
INSERT INTO ifb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","At inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Alyom hinan tatagu ta bataananda nan a'abung da Korah, ya hi Dathan, ya hi Abiram!” ");
INSERT INTO ifb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","At nala\"uy hi Moses, ya immuy hi awadan da Dathan ay Abiram, ya nitnud din a'ap'apun nan holag Israel ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ya inalinah nan tataguy, “Mahlig ayu ta adi ayu medelloh hinan a'abung daten nun'abaholan an tatagu! Ya adiyu dapoon nan malgom an gina'uda ti ini ya milagat ayun mi'yubah ay dida an dumalat nan baholda!” ");
INSERT INTO ifb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","At nun'ahlig an amin nan nidelloh hinan a'abung da Korah, ya hi Dathan, ya hi Abiram. Ya bimmuhu' da Dathan ay Abiram hinan a'abungda, ya timma'dogdah nan way pantawna, ya ni'ta'dog goh daden a'ahawada ya imbabaluyda. ");
INSERT INTO ifb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ya inalin Moses hinan tataguy, “Hiyah te panginnilaanyuh nannagan Apo Dios ay ha\"in an mangat an amin hi umat hitu ay dida an bo'on ha\"in ad nomnom eten ato'. ");
INSERT INTO ifb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ti gulat ta daten linala'i ya unda tuwali matoy hinan gutud di atayan di tagu unu matoyda an dumalat di pundoghanda ya immannung an bo'on ha\"in di hennag Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mu gulat ta ma'at ay dida nan umipanoh'a ti manga' nan luta, ya mun'a'unugdan amin an ta\"on unda matagu, ya mun'iddum an amin nan gina'uda ta mun'ilubu'da ya hiyay panginnilaanyu an danen linala'i ya din'ugdah Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ya unat goh nalpah henen himmapitana ya nanga' din lutan timmata'doganda. ");
INSERT INTO ifb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ya nun'a'unugdan amin an hina\"ama, ya ni'yunug da Korah, ya an amin din linala'in niniddum ay Korah, ya an amin din gina'uda, ya nan abungda. ");
INSERT INTO ifb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","At an aminda ya matattagudah na'unugandad dolom, ya mi'id mattig ay dida ti nundittum din nanga' an luta, at na'ubahda. ");
INSERT INTO ifb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","At timma'otda nan holag Israel an wadah nan nunlene'woh, ya way ohaan numpangalayawdan ahikikila, ya alyonday, “Lumayaw tu'u ti ini ya mi'yunug tu'un dida!” ");
INSERT INTO ifb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ya himbumagga ya waday apuy an nalpud daya, ya genhobna din duway gahut ta nabonglen linala'in nun'onong hi incense. ");
INSERT INTO ifb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Alyom ay Eleazar an imbaluy Aaron an Nabagtun Padi ta amungona nan pangittuwan hi incense an nun'iwallang hi awadan din linala'in nun'oghob ti danen pangittuwan ya me'gonanda, ya mitapal an miwa'at hinan adagwi nan bala. ");
INSERT INTO ifb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ya alam danen nangittuwandah incense an mumbalin hi me'gonan hidin nun'onngan nan linala'in nun'atoy an dumalat di baholda, ya ipabhalmu ta mun'ayapit ta way mihophop hinan pun'onngan an bagim ya ta way agilatan nan holag Israel hinan na'at ta ita'ota' an Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","At hi Eleazar an padi ya inamungna hadin gambang an pangittuwan hi incense, ya benhalna ta yumapit an miyammah hophop nan pun'onngan ");
INSERT INTO ifb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ta hiyay gun pangitigan nan holag Israel an adi miyabulut nan malgom an tagu ti mahapul an malpuh holag Aaron di umuy hinan pun'onngan an mange'nong hinan incense ay Apo Dios ta adi ma'at ay dida nan na'at ay da Korah ya nan i'ibbana. Ya inat Eleazar nan immandal Apo Dios ay Moses. ");
INSERT INTO ifb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ya heden nabiggat ya an amin nan tatagun holag Israel ya nunhahapitda, ya inamuyuanda da Moses ay Aaron an inaliday, “Pinatoyyu nan udumnan tatagun Apo Dios!” ");
INSERT INTO ifb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ya hidin na'amungan din tatagu ta amuyuanda da Moses ay Aaron ya intigawdah nan Me'gonan an Kuwaltun a'amungan, ya hin'alina ya naho'napan hi bunut, ya nipattig nan benang Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ya immuy da Moses ay Aaron, ya timma'dogdah nan way hinagang nan pantaw di Tuldan Abung hi wadan Apo Dios an a'amungan, ");
INSERT INTO ifb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ya himmapit hi Apo Dios ay Moses an alyonay, ");
INSERT INTO ifb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Taynanyu nan na'amung an tatagu ta ubaho' didad ugwan!” Ya inlu'bubdan duwah nan luta. ");
INSERT INTO ifb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ya inalin Moses ay Aaron di, “Punnaudom an alan nan pangittuwan hinan incense, ya inittuwam hi balan malpuh nan pun'onngan, ya inittuwam hi incense, ya nunnaudom an umuy hinan tatagu ta e'nongmun Apo Dios an dumalat hinan baholda ta mibangngad di maphod hi niyatandan Hiya! Ti hi Apo Dios ya nidugah di bimmungtanan dida, at na'uy an ipa'alinay pumatoy an dogoh!” ");
INSERT INTO ifb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","At inunud Aaron nan inalin Moses hi atona an innalna din duyun pangittuwan hi moghob an incense, ya nunnaudonan e'nong ay Apo Dios ta ma'aliwan di bahol nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ya timma'dog hi Aaron hinan numbattanan nan agguy natoy ya nan nun'atoy, at dimminong din pumatoy an dogoh. ");
INSERT INTO ifb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","At hay uyap di tatagu an nun'atoy ya himpulu ta opat di libu ta han pituy gahut, ya agguy ni'bilang din nun'atoy an i'ibban Korah enen ligat. ");
INSERT INTO ifb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","At numbangngad hi Aaron hi awadan Moses hinan way pantaw di Tuldan Abung hi wadan Apo Dios an a'amungan ti dimminong henen dogoh. ");
INSERT INTO ifb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ya himmapit hi Apo Dios ay Moses, ya inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Alyom hinan holag Israel ta idatdan he\"ay himpulu ta duwan hul'ud nan a'ap'apun di hinohhan ahimpangapangapu, ya itudo'muy ngadan nen taguh nan hul'udna. ");
INSERT INTO ifb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ya intudo'mu goh di ngadan Aaron hinan hul'ud nan holag Levi. Atom hana ti mahapul an waday ohan mumpapto' hinan ohan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ya innalmu ta iyuymun amin hinan Me'gonan an Kuwaltu, ya impatangmuh nan way hinagang di Kahon an Nittuwan nan Himpulun Uldin an gun'u pi'hapitan ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ya nan hul'ud di ohan tagun pot'o' ya humalepeng, at dumalat heten ato' ya padinngo' di umamuyuan nan i'ibbam an holag Israel ay he\"a.” ");
INSERT INTO ifb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","At ni'hapit hi Moses hinan holag Israel, at an amin nan a'ap'apu ya nun'idatday hinohhah hul'ud di ohay himpangapu, at himpulu ta duwan amin, ya niddum goh nan hul'ud Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","At inyuy Moses an amin din hul'ud, ya impatangnah nan awadan di hinagang Apo Dios an wadan nan nitudo' an Uldina. ");
INSERT INTO ifb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ya unat goh nabiggat ya himmigup hi Moses hinan Me'gonan an Kuwaltu, ya tinnignah den hul'ud Aaron an nangipangpanguluh nan holag Levi an himmalepeng, ya himmabung, ya bimmungah bungan di almond. ");
INSERT INTO ifb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ya innal Moses an amin din hul'ud, ya inlahuna ta impattignah nan holag Israel. At tinnigdan amin henen na'at, at innalda din hul'udda. ");
INSERT INTO ifb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ya inalin Apo Dios ay Moses di, “Ibangngadmuh nen hul'ud Aaron hinan hinagang di Kahon an Nittuwan di Uldin ta mihinah di ta way agilatan nan tatagun holag Israel ta ipogpogdan umamuyu ta adida matoy.” ");
INSERT INTO ifb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ya inat Moses nan inalin Apo Dios ay hiyah atona. ");
INSERT INTO ifb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ya inalin nan tatagun holag Israel ay Moses di, “At hiyah te atayanmi, ya a'ubahanmin amin! ");
INSERT INTO ifb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ti an amin nan meheggon hinan Me'gonan an Kuwaltu ya matoy! At an amin ami ya mun'atoy ami mah?” ");
INSERT INTO ifb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ya inalin Apo Dios ay Aaron di, “He\"a, ya nan linala'in imbabaluymu, ya nan i'ibbam an holag Levi di mabaholan hinan way mibahhaw hi ma'at hinan Tuldan Abung. Mu gulat ta nan mibahhaw hi ma'at hinan tamun di papadi ya he\"a ya nan imbabaluymu ya anggay di mabaholan. ");
INSERT INTO ifb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ya ayagam nan tutulangmun holag Levi ta badangan da'a, mu he\"a ya nan imbabaluymuy muntamuh nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ya atondan amin nan ipatamuyun dida ya nan way ipatamuyu goh hinan Tuldan Abung, mu mahapul an adida dinihon nan gina'un wadah nan Me'gonan an Kuwaltu ya nan pun'onngan ti matoyda, at mi'yatoy ayu goh ay dida. ");
INSERT INTO ifb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ya middumdan he\"a ta diday manamuh nan tamuh nan Me'gonan an Kuwaltu, mu mahapul an mi'id ah udumnan umalin meheggon ay he\"a. ");
INSERT INTO ifb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ya da'yu ya anggay di mangitamuh nan matamuan hinan Me'gonan an Kuwaltu ya nan pun'onngan. Ya gulat ta unudonyu hatun itugun'u ya adia' bumungot ta adi' mahkay moltaon nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ya Ha\"in di nanimung an namilih nan tutulangyun holag Levi hinan holag Israel ta badangan da'yuh nan tamuyu. Ya dida ya nidawatdan Ha\"in ta way atondan muntamuh nan Tuldan Abung an a'amungan. ");
INSERT INTO ifb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","At he\"a ya nan linala'in imbabaluymu ya anggay di mangitamuh nan tamun di papadih nan pun'onngan ya hinan Me'gonan an Kuwaltu. Ya henen haadyun papadi ya Ha\"in di nangidat ay da'yu, at nan udumnan tagun umalin middum ya mahapul ya mapatoy.” ");
INSERT INTO ifb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ya inalin goh Apo Dios ay Aaron di, “Da'yun papadiy pangiyokoda' an mangipapto' hi an amin hinan me'nong ay Ha\"in an epe'nong nan holag Israel. Ya mahapul an adiyu aliwan an Ha\"in ya idat'un amin ay he\"a ya nan holagmu nan me'nong ay Ha\"in an nan adi moghob ta bingayyuh enggana. ");
INSERT INTO ifb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ya an amin nan onong an adi moghob hinan pun'onngan an epe'nongdan Ha\"in an umat hinan Onong an Ma'an, ya nan Onong di Nibahhawan, ya nan Onong di Bahol, ya nan udum an me'nong ay Ha\"in ya bagim, ya bagin goh nan linala'in imbabaluymu ti hana ya ma\"e'gonan. ");
INSERT INTO ifb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ya daten me'gonan an onong ya hinan me'gonan an lugal goh di pangananyu, ya hay linala'i ya anggay di mangan, ya emayaanyu ti me'gonan. ");
INSERT INTO ifb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","At nan Milayat an Onong an e'nong nan holag Israel ay Ha\"in ya idat'un he\"a ya nan imbabaluymu, ya minaynayun an hiyah ne ma'at hi enggana. Ya ta\"on nan ni'hitun he\"ah nan abungyu an niyuldin an maleneh nan odolda ya mabalin an me\"anda enen ma'an. ");
INSERT INTO ifb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ya idat'u goh ay he\"a an amin nan hopap di ma'alah nan bungan di nitanom an umat hinan maphod an mantikan di olibo, ya nan bayah, ya nan paguy an e'nong nan tatagun holag Israel ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ya ta\"on un an amin nan hopap di bungan nan nitanom enen lutan nalum an idawatdan Ha\"in ya bagim. Ya an amin nan ni'hitun he\"a an niyuldin an maleneh di odolda ya mabalin an me\"anda enen ma'an. ");
INSERT INTO ifb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","At an amin nan milahhin ta midat ay Ha\"in ya idat'un he\"a ta bagim. ");
INSERT INTO ifb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ya an amin nan hopap di mitungaw an tagu ya mi'lum an animal an idawatdan Ha\"in ya bagim. Mu nan hopap di itungaw di tagu ya mahapul an bayadam, ya umat goh hinan hopap di i'lum nan animal an alyon di Uldin an mapaniaw hi me'nong ya bayadam goh. ");
INSERT INTO ifb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Hay bayad nan ung'ungunga an ohay bulana ya lemay pihhun silver an miyunnudan hinan kiluh dih nan Tuldan Abung ta panandidan dida. ");
INSERT INTO ifb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mu nan hopap di i'lum nan baka, ya kalnilu, unu gandeng ya adim handian ti hana ya me'nong ay Ha\"in, at me'gonanda. At miwalhi nan daladah nan pun'onngan, ya mipulu' nan tabada ta Onong an Moghob ta nan maphod an hunghungnay mangipa'amlong ay Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ya nan dotagda ya bagiyu an umat hinan boga' an Milayat an Onong, ya nan agwan an ulpu. ");
INSERT INTO ifb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","At an amin nan me'gonan an nilayat an epe'nong nan holag Israel ay Ha\"in ya idat'un he\"a ya nan imbabaluymun linala'i ya binabai. At heten inali' ya minaynayun hi ma'at hi enggana an paddungnay gunyu ahinan nan pi'tulaganyu ya nan e'nongyu.” ");
INSERT INTO ifb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ya inalin goh Apo Dios ay Aaron di, “He\"a ya mi'id midat hi banohmu an gina'u, ya mid goh di lutan mipabnoh hinan holag Israel. Ti Ha\"in an Dios di paddungnay banohyu.” ");
INSERT INTO ifb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ya inalin goh Apo Dios ay Aaron di, “Ya idat'uh nan holag Levi an amin nan himpulu an idat nan holag Israel hi enetbaldah bagi' ta hiyay banohda. Ya hiyah ne paddungnay lagbudah nan puntamuandan Ha\"in ya nan panalimunandah nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","At mahapul an mi'id ahan ah ohah nan holag Israel hi meheggon hinan Me'gonan an Kuwaltun pi'happitana' ti mabaholanda, at matoyda. ");
INSERT INTO ifb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mu anggay nan holag Levi di okod an muntamuh nan Me'gonan an Kuwaltu, ya diday okod an mamoltah un way ibahhawanda. At hiyah te minaynayun hi uldin an ma'at hi enggana. At nan holag Levi ya mi'id di banohda. ");
INSERT INTO ifb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ti nan mun'iyapulu an idat nan holag Israel an ilayatdan e'nong ay Ha\"in ya idat'uh nan holag Levi ta banohda ti dida ya anggay hinan holag Israel di mi'id ah banohna.” ");
INSERT INTO ifb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Alyom hinan holag Levi di, Wa ay ta alanyu nan mun'iyapulu an malpuh nan holag Israel an idat'un da'yuh banohyu ya anonyu goh nan mun'iyapulu ta e'nongyu. ");
INSERT INTO ifb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","At henen idawatdan Ha\"in ya paddungnay un hiyah ne inhabalyu an pa\"abto'yun paguy ya pa\"amma an bayah. ");
INSERT INTO ifb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","At mahapul an da'yu goh di mange'nong ay Ha\"in an Dios hi miyapulun midat ay da'yu an malpuh nan holag Israel. Ya henen idawatyun Ha\"in ya mahapul an idatyuh nan Nabagtun Padin hi Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","At an amin nan nidat ay da'yu ya pilionyu nan ma\"aphod ahan ta hiyay e'nongyun Ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","At alyom goh hinan holag Levi di, Nalpah ay an indawatyu nan ma\"aphod ya hiyah ne paddungnay nalpuh nan bento'yun paguy ya greyp an miyammah bayah. ");
INSERT INTO ifb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ya mabalin an malgom hinan lugal di pangananyun hina\"ama ti nidat ay da'yu ta lagbuyuh nan puntamuanyuh nan Me'gonan an Kuwaltu'. ");
INSERT INTO ifb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ya adi ayu mabaholan hi un hay pilionyu an onong ya nan ma\"aphod ahan an onong'un Dios. At adiyu puhion nan nidawat an indat nan holag Israel, at adi ayu matoy.” ");
INSERT INTO ifb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ya inalin Apo Dios ay da Moses ay Aaron di, ");
INSERT INTO ifb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Hiyah te aat di ohan uldin'uh minaynayun: Alyonyuh nan holag Israel ta iyalidan da'yuy ohah mumbolah an kilaw hi bakan mi'id ah ganitna ya agguy nitamu. ");
INSERT INTO ifb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ya idatyun Eleazar an padi ta ibataanah nan way nungkampuanyu, ya pinaltinah nan way hinagangna. ");
INSERT INTO ifb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ta malpah ya eneddo' Eleazar nan ga\"umutnah nan dalan nan kilaw, ya winalhiyanah mumpapitu nan hinagang nan Me'gonan an Kuwaltu. ");
INSERT INTO ifb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ya me'nong henen bakan ma'i'imul, ya mipulu' ta moghob an amin nan up'upna, ya lamohna, ya dalana, ya minalutunah nan awadan Eleazar. ");
INSERT INTO ifb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ya ummal hi Eleazar hinan ayiw an ceder, ya nan hapang di hyssop, ya nan mumbolah an linubid, ya ipa'wahnah nan way dumaladalang an apuy an wadan di nipulu' an baka. ");
INSERT INTO ifb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ya nalpah ay hana ya iloba'na nan lubungna ya nun'amoh ya un mahkay humgop hinan nungkampuanda, mu alyon di Uldin an nappuhiy odolna damdama ta nangamung hi mahdom. ");
INSERT INTO ifb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ya heden tagun nanghob hinan baka ya mahapul an iloba'na goh di lubungna ya nun'amoh, mu niyuldin an munnanong an nappuhiy odolna ta nangamung hi mahdom. ");
INSERT INTO ifb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","At nan tagun alyon di Uldin an maleneh di odolnay hiyay mangamung hinan dapul nan noghob an baka ta ibataanah nan nungkampuanda ta italeponah nan alyon di Uldin an maphod an lugal hi ipatangana. Ya mitalepon ta way iddum nan holag Israel hinan danum an ma'usal hinan pangaliwan hi bahol. ");
INSERT INTO ifb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ya nan tagun mangamung hinan dapul nan uyaw an baka ya mahapul an iloba'nay lubungna, mu alyon nan Uldin an adi maleneh di odolna damdama ta nangamung un mahdom. Ya heten Uldin ya mahapul an hiyay minaynayun hi unudon nan holag Israel ya nan bunag an ni'hitun dida.” ");
INSERT INTO ifb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ya inalin goh Apo Dios di, “Ya wada ay di manapah nan natoy an tagu ya alyon di Uldin an mituluy an adi maleneh di odolnah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","At mahapul an unudon nan niyuldin, at numpawalhih odolnah nan danum an umipaphod hi odolna, mu mahapul an atonah nan miyatlu ya nan miyapitun algaw. Mu gulat ta adina aton hinan miyatlu ya nan miyapitun algaw ya niyuldin an adi maleneh di odolna. ");
INSERT INTO ifb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","At an amin nan manapah nan odol di natoy an tagu ta agguy numpawalhih odolnah nan danum an umipaphod at niyuldin an mituluy an adi maleneh di odolna, ya puhiona nan Nidugah an Me'gonan an Kuwaltun Apo Dios. At henen tagu ya mapogpog di iddumanah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ya hiyah te Uldin hi ma'at hi un way matoy hinan abungnan tulda. An amin nan tatagun wah di ya ta\"on nan humgop eden abung ya alyon di Uldin an matuluy an adi maleneh di odolnah pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ya an amin nan bangan wah di an umat hinan tibung unu bahun mi'id alubna ya alyon di Uldin an mapaniaw hi ma'usal. ");
INSERT INTO ifb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ya gulat goh ta inah'upanyuh nan malgom an lugal an manghan di taguh nan tagun napatoy hi hanggap, unu nan natoy an dumalat hi dogoh, unu nan tungal di natoy, unu hay lubu' ya dinapayu at alyon di Uldin an matuluy an adi maleneh di odolyuh pituy algaw. ");
INSERT INTO ifb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","At hiyah te atonyuh nan tagun alyon di Uldin an agguy naleneh di odolna: Ummal ayuh dapul din noghob an baka, ya inittuyuh nan tibung, ya inittuwanyu goh hi pa'ahhagub an danum. ");
INSERT INTO ifb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ya nan tagun niyuldin an maleneh di odolnay hiyay ummal hinan holo' an hyssop an ay hanganga, ya itamolnah nan danum ta iwalhinah nan tulda, ya an amin goh hinan gina'un wah nan tulda, ya nan tatagun wah di, ya nan tagun nanapah nan pinatoydan tagu, unu tungal di tagu, unu un hay natoy an dumalat di dogoh, unu hay nanapah nan lubu'. ");
INSERT INTO ifb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","At nan miyatlu ya miyapitun algaw ya nan tagun maleneh di odolnan alyon di Uldin ya walhiana nan tagun alyon di Uldin an agguy naleneh di odolna. Ya nan miyapitun algaw ya henen tagun nawalhian ya iloba'nay lubungna, ya mun'amoh, at henen mahdom enen miyapituy algaw ya alyon di Uldin an maleneh di odolna mahkay. ");
INSERT INTO ifb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mu gulat ta nan tagun alyon di Uldin an agguy naleneh di odolna ya adina aton di mahapul ta pumhod di odolna ta maleneh an alyon di Uldin ya mapogpog di iddumanah nan tatagu' an Dios ti puhiona nan Nidugah an Me'gonan an Kuwaltu ti agguy numpawalhih odolnah nan danum an umipaphod. ");
INSERT INTO ifb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ya hiyah te Uldin hi mahapul an minaynayun hi atonyu. Nan tagun mangiwalhih nan danum an umipaphod ya mahapul goh an iloba'nay lubungna ti dumalat nan nanapaanah nan danum an mangipaphod enen tagu, ya mituluy an adi maleneh di odolna an alyon di Uldin hi engganah mahdom. ");
INSERT INTO ifb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ya an amin nan dapoon nan tagun alyon nan Uldin an agguy naleneh di odolna ya niyuldin an mapaniaw hi ma'usal. Ya an amin nan manapah nan dinapan den tagu ya niyuldin an adi maleneh di odolna ta nangamung un mahdom.” ");
INSERT INTO ifb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hidin hopap di bulan ya an amin nan holag Israel ya immatamdah nan Mapulun an Zin, ya nungkampudad Kadesh. Ya hidiy gutud di natayan Miriam, ya hidi goh di nilubu'ana. ");
INSERT INTO ifb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ya heden lugal an nungkampuanda ya mi'id ah danum hi inumonda. At na'amung nan tatagu ta amuyuanda goh da Moses ay Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ya immuydan Moses, ya ni'hongngeldan hiyan inaliday, “Un onaynah un ami ni'yatoy hidin i'ibba tu'un nun'atoy hinan hinagang Apo Dios! ");
INSERT INTO ifb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ya anaad tuwali ta itnud da'min iyalih tun mapulun ta hiyay atayanmin amin ya ta\"on tun a'animalmi? ");
INSERT INTO ifb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ya anaad tuwali ta enekak da'mih ad Egypt ta inyali da'mih tun nappuhin luta? Ti heten luta ya adi ahan tummol di mitanom an mi'id di pangngalan hi bogah, unu figs, unu greyp, unu ayiw an pomegranate, ya mi'id goh di danum hi inumon!” ");
INSERT INTO ifb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","At tinaynan da Moses ay Aaron nan tatagu ta immuydah nan way pantaw di Me'gonan an Kuwaltu ta nunlu'bubdah nan lutan nunluwalu. Ya numpattig ay dida nan benang Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Alam din hul'udmu, ya amungonyun Aaron an amin nan holag Israel. Ya wa ay ta na'amung ayun amin ya himmapit'ah nan batu ta malmuy danum ta way ipa'inumyuh nan tatagu ya nan a'animalda.” ");
INSERT INTO ifb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","At immuy innal Moses din hul'ud an nipatang hinan way Kahon an Nittuwan nan Uldin ti hiyah ne nimandal hi atona. ");
INSERT INTO ifb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ya la'tot ya inamung da Moses ay Aaron nan tataguh nan way hinagang di batu, ya inalin Moses ay diday, “Da'yun umamu'amuyu ya donglonyuh ten alyo'! Hay pohdonyu nin ya pabuhu'onmi nan danum an malpun ten batu?” ");
INSERT INTO ifb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","At inta'nang Moses nan hul'udna, ya impidwanan inhaplat hinan batu. Ya bimmuhu' di do'ol an danum, at imminum an amin din tatagu ya din a'animalda goh. ");
INSERT INTO ifb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mu bimmungot hi Apo Dios ay da Moses ay Aaron, ya inalinan diday, “Dumalat nan agguyyu nangunudan ay Ha\"in hinan agguyyu nangipattigan hinan nidugah an abalina' hinan holag Israel at bo'on da'yuy mangipangulun mangiyatam ay didah nan lutan din intulag'uh ipaboltan'un dida!” ");
INSERT INTO ifb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ya hiyah te obob ad Meribah ti hidiy nangamuyuan nan holag Israel ay Apo Dios, ya hidiy nangipattigan Apo Dios an Hiya ya me'gonan. ");
INSERT INTO ifb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ya heden awadan nan holag Israel hidid Kadesh ya nunhonag hi Moses hi udumna ta immuy hinan alid Edom, ya inalin nan nahnag di, “Hay nannag ay da'mi ya nan tutulangmun holag Israel. Ya inilam an amin di ligat an hinoltapmi ");
INSERT INTO ifb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ti inilam di aat nan immayan nan o'ommodmih ad Egypt, ya hidiy ni'hituwanmih do'ol hi tawon, ya pinaligligat da'mi ya nan a'apumih nan i'Egypt. ");
INSERT INTO ifb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ya unat goh nunluwalu amin Apo Dios ta numpabadang ami ya dengngolnay luwalumi, at hennagna han Anghelna ta enekak da'mih ad Egypt. At ad ugwan ya ihna amih tud Kadesh an neheggon hinan babluyyu. ");
INSERT INTO ifb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ya al'alu'onmi ni' he\"a ta iyabulutmu ni' di pange'wanmih nan babluyyu. Adimi ihingngi an e'wah nan payawyu unu nan nuntanomanyuh nan greyp, ya adimi goh inumon nan danum hinan bubunyu, mu hay pange'wanmi ya nan ma'alih Kulhan di Ali ta henen kulhay u'unudonmi ta nangamung unmi lauhan nan babluyyu.” ");
INSERT INTO ifb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mu nan alid Edom ya tembalnan inalinay, “Adimi abuluton an e'wayuh tu! Ti atonyu ay ya gubatonmi da'yu!” ");
INSERT INTO ifb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ya inalin nan holag Israel di, “E'wami ni', mu nan bagwaan an nadalanan an kulhay dalanonmi. Ya gulat ta way uminum ay da'mi unu nan a'animalmih nan danumyu ya bayadanmi. Hiyah ne ya anggay di ibagami, at iyabulutmu ni' di pange'wanmih nan igad di luta.” ");
INSERT INTO ifb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mu nan holag Edom ya inya'addidan inaliday, “Adi ahan miyabulut an e'wayu!” Ya bimmuhu'da nan nun'ala'eng an tindalun nan holag Edom ta gubatonda nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ya dumalat nan agguy namhodan nan holag Edom hi pange'wan nan holag Israel hinan hakupda at hay nat'on di nange'wan nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ya tinaynan nan holag Israel ad Kadesh, ya impadehda ta nangamung unda nidatong hinan Duntug an Hor. ");
INSERT INTO ifb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ya himmapit hi Apo Dios ay da Moses ay Aaron hi awadandah nan Duntug an Hor hinan igad hinan babluy ad Edom, ya inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“He\"a, Aaron, ya umuy'a middum hinan o'ommodmuh penghana, at hiyanan adi'a umatam hinan lutan intulag'uh idat'uh nan holag Israel. Ti da'yu ya numbahol ayu ti agguyyu inunud nan immandal'un da'yuh nan danum ad Meribah.” ");
INSERT INTO ifb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","At inalina goh di, “Ya he\"a, Moses, ya itnudmuh Aaron ya nan lala'in imbaluynan hi Eleazar ta munti'id ayuh tulid nan Duntug an Hor. ");
INSERT INTO ifb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ya anom nan magayad an inlubung Aaron ta ipilubungmun Eleazar ti hi Aaron ya hidiy atayana ta middum hidin nun'atoy an o'ommodyuh penghana.” ");
INSERT INTO ifb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","At inunud Moses henen immandal Apo Dios hi atona. At nunti'iddah nan Duntug an Hor an wan a'amangon nan tatagu didah punti'idanda. ");
INSERT INTO ifb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ya unat goh nidatongdah nan buludnah nan duntug ya nun'aan Moses din magayad an inlulubung Aaron, ya impilubungnan Eleazar an imbaluy Aaron. At natoy hi Aaron hidih nan buludnah nan duntug. Ya unat goh nalpah ya nundadyu da Moses ay Eleazar. ");
INSERT INTO ifb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ya unat goh dengngol an amin nan tatagun holag Israel an natoy hi Aaron ya nginuhuda hiyah himbulan. ");
INSERT INTO ifb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ya nan alid Arad an iCanaan hidid Negev ya dengngoldan na'uy nan holag Israel an wadadah nan kulhah ad Atharim ya immuy nan tindaluna ta ginubatda dida, at penlohday udum an holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ya ni'tulag nan holag Israel ay Apo Dios an inaliday, “Gulat ta ipa'abakmun da'mi daten tatagu at ubahonmi goh nan babluyda.” ");
INSERT INTO ifb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ya inabulut Apo Dios nan inalida, at binadangana dida ta inabakda nan i'Arad. At numpatoyda didan amin, ya numpa\"idan amin nan siudadda. Ya nginadnandah nen babluy ta ad Hormah. ");
INSERT INTO ifb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ya tinaynan nan holag Israel nan Duntug an Hor ta ene'wadah nan dalan an miyuy hinan Mumbolah an Baybay, mu inlikawdah nan lutad Edom. Mu la'tot ya himmigada nan tatagun dumanallanan, ya nunlilida. ");
INSERT INTO ifb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","At numpahalda da Apo Dios ay Moses an inaliday, “Anaad ta enekak da'mih ad Egypt ta inyali da'mih tu ta hitun mapulun di atayanmi? Ya ten mi'id goh di ma'an, ya danum, ya ten la'tot ya nahengla amih nan gunmi onon!” ");
INSERT INTO ifb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","At hennag Apo Dios di atata'ot an ulog hinan awadanda, at do'ol di nun'alatdah nan tatagun holag Israel, at do'ol di nun'atoy. ");
INSERT INTO ifb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ya immuy nan tatagun Moses, ya inaliday, “Numbahol ami ti nappuhiy hinapitmih aat Apo Dios ya umat goh ay he\"a! At ad ugwan ni' ya munluwalu'an Apo Dios ta pakakona nan do'ol an ulog!” At inluwaluan Moses nan tatagu. ");
INSERT INTO ifb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ya inalin Apo Dios ay Moses di, “Iyammam nan gambang hi umat hi ulog, ya impautmuh nan utdu' di hul'ud, ya inluhadmu ta wa ay ta itangad nan na'alat enen nipaut an ulog ya pumhodda an adida matoy.” ");
INSERT INTO ifb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","At inyamman Moses nan gambang hi umat hi ulog, ya impautnah nan utdu' di hul'ud ta wa ay ta itangad nan na'alat enen nipaut an ulog ya pumhodda an adida matoy. ");
INSERT INTO ifb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ya inaynayun nan holag Israel an numbaat ta nidatongdah ad Oboth, ya hidiy nungkampuanda. ");
INSERT INTO ifb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ya impadehda goh ta tinaynandad Oboth ta dimmatongdah nan mapulun hi ad Iye Abarim, ya hidi goh di nungkampuandah nan hinagang ad Moab hi immapit hi buhu'an di algaw. ");
INSERT INTO ifb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ya numbotanda goh ta immuyda nungkampuh nan Hadog an Zered. ");
INSERT INTO ifb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ya numbotanda goh ta immuyda nungkampuh nan way pangngel di pingit nan Wangwang an Arnon an wah nan mapulun an nida\"it hinan hakup di holag Amor. (Nan Wangwang an Arnon ya igad hi numbattanan di iMoab ya nan holag Amor. ");
INSERT INTO ifb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","At hiyah te nitudo' hinan Liblun di Ni'gubagubatan Apo Dios an inalinay, “Hidi ya wada nan Waheb ad Suphah an nan daplah, ya hidi goh hinan Wangwang an Arnon. ");
INSERT INTO ifb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ya minaynayun hi engganah nan lihad hinan nundotalana, ya niyatam hi ad Ar, ya niyatam goh hinan igad hi ad Moab.”) ");
INSERT INTO ifb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ya nakakdah di ta numbotanda ta immuydad Beer, ya hidiy awadan nan obob, at inalin Apo Dios ay Moses di, “Amungom nan tatagu ta idata' didah danum.” ");
INSERT INTO ifb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ya hidiy nangikantaan nan holag Israel eten kanta: “Bubun, pun'ibuhu'muy danummu, at apngaon da'ah kanta. ");
INSERT INTO ifb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ikantamiy aat ten bubun an linhu'an nan imbabaluy di ali ti linhu'an nan a'ap'apu an hay hul'udday nunluhu'da.” Ya la'tot ya nakakdah nan mapulun ta immuydad Mattanah. ");
INSERT INTO ifb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ya numbotanda ta immuydad Nahaliel. Ya nakakdad Nahaliel, ya immuydad Bamoth. ");
INSERT INTO ifb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Ya nakakdad Bamoth ta immuydah nan nundotalana an hakup ad Moab ta engganah nan buludnah nan Duntug an Pisgah an a'amangan din mapulun. ");
INSERT INTO ifb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ya nunhonag nan holag Israel hi umuy ay Sihon an alin di holag Amor, ya inaliday, ");
INSERT INTO ifb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Iyabulutmu ni' di pange'wanmih nan babluyyu. Ya adimi ibahhaw an e'wah nan way payawyu, unu nan nuntanomanyuh nan greyp. Ya adimi inumon di danum hinan bubunyu. Mu hay pange'wanmi ya nan Kulhan di Ali ta nangamung unmi lauhan nan babluyyu.” ");
INSERT INTO ifb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mu agguy ahan inyabulut Sihon di nange'wan nan holag Israel hinan babluyda. At inamungna nan tindaluna ta immuyda ginubat nan holag Israel hinan mapulun ad Jahaz. ");
INSERT INTO ifb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mu nangabak nan holag Israel, at numpatoyda dida, at hinakupda nan lutada an nete\"ah nan Wangwang an Arnon ta engganah nan Wangwang an Jabbok, mu adida pa\"ahgop hinan babluy di holag Ammon ti nihamad di allup nan igad di babluyda. ");
INSERT INTO ifb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","At hinakup nan holag Israel an amin nan siudad nan holag Amor, ya niddum ad Heshbon ya nan nun'eheggon hinan nunlene'woh an abablubabluy. ");
INSERT INTO ifb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ti ad Heshbon ya siudad an nunhituwan Sihon an alin di holag Amor an din nangubat hinan alin di iMoab, ya inabakna dida, at hinakupnan amin di lutada ta engganah nan Wangwang an Arnon. ");
INSERT INTO ifb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","At hiyaat un nan nangitudo' hi kanta ya alyonay, “Umali ayud Heshbon ta ipaphod tu'u nan napa\"in siudad Sihon! ");
INSERT INTO ifb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ti wada han apuy an nalpud Heshbon an dumaladalang hinan siudad Sihon, at immuy ta nunggohobna nan siudad ad Ar an hakup ad Moab an awadan nan atata'nang an duntug an ma'amang hinan Wangwang an Arnon. ");
INSERT INTO ifb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mahmo' nan iMoab ya da'yun tatagun mundayaw ay Chemosh ti inyabulutnan ipaploh nan linala'in limmayaw ya nan binabai ta himbut Sihon an alin di holag Amor! ");
INSERT INTO ifb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mu mabi'bi'ah ami ya un dida, at nun'a'ubahda ya ta\"on nan babluyda an nete\"ad Heshbon ta engganad Dibon! Ya nun'iwalitangmi didan mete\"ad Nophah ta engganah ad Medeba.” ");
INSERT INTO ifb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","At nunhitu nan holag Israel hinan lutan di holag Amor. ");
INSERT INTO ifb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ya unat goh numbangngad din hennag Moses an immuy nunhi'im eden babluy ad Jazer ya ni'gubatda nan nun'eheggon an babluy, at nangabakda nan holag Israel, at penlohdah den siudad, ya numpakakda nan holag Amor an numpunhituh di. ");
INSERT INTO ifb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ya imbaweng nan holag Israel di nange'wanda ta nan kulha an miyuy ad Bashan di enengwada. Mu nan alid Bashan an hi Og ya initnudna nan tindaluna ta umuyda damuwon nan holag Israel ta gubatonda didad Edrei. ");
INSERT INTO ifb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ya inalin Apo Dios ay Moses di, “Adim ta'tan hi Og ti baliwa' da'yu! At an amin nan tataguna ya nan lutana ya idat'un da'yu. At hay atonyu ya umat hinan inatyun Sihon an alin di holag Amor an nunhitud Heshbon.” ");
INSERT INTO ifb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","At pinatoyda nan Alin hi Og, ya ta\"on nan imbabaluyna, ya an amin nan tataguna. At mi'id ahan di na'angang hi ohah matagu. Ya hinakupdan amin an penloh nan numbabluyan Og. ");
INSERT INTO ifb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ya innaynayun nan holag Israel an numbotan ta nangamung unda nidatong ad Moab an neheggon hinan Wangwang an Jordan hinan dammang ad Jericho, ya nungkampudah dih nan nundotal an luta. ");
INSERT INTO ifb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ya tinnig Balak an lala'in imbaluy Zippor henen inat nan holag Israel hinan holag Amor, ");
INSERT INTO ifb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ya ma'atta'ot heden ali ya an amin nan tatagunan iMoab ti do'ol nan holag Israel an wah di. ");
INSERT INTO ifb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","At ni'hapit nan alin di iMoab hinan a'ap'apun di iMidian an inalinay, “Na'uydan umali nan do'ol ahan an tatagun holag Israel! At un na'amtang di atonda ya numpa\"idan amin di logom an wah tun babluy tu'u an umat hinan aton di bakan mangan hi holo' hinan pumpahtulan!” ");
INSERT INTO ifb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ya hennagnay udumnah nan tataguna ta umuyda ayagan hi Balaam an hina' Beor an nunhitud Pethor an neheggon hinan Wangwang an Euphrates an alyonay, “Wah tuda han do'ol ahan an tatagun nalpud Egypt! Ya hinakupdan amin tun lutan nunlene'woh hitun wada', ya ten pohdondan hakupon an amin tun luta'! ");
INSERT INTO ifb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ya do'do'ol daten tatagu ya un da'mi, at umali'a ni' ahan ta badangana' ta idutam daten tatagu ta olom ni' ya abakonmi dida ta lumayawda! Ti inila' an wa ay ta wagaham nan tatagu ya bumi'ahda, ya wa ay ta idutam dida ya mi'id bi'ahda.” ");
INSERT INTO ifb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ya inla\"uy nan a'ap'apun di iMoab ya nan iMidian ta umuyda, ya inodnanday pumbayaddah nan idut. Ya unat goh nidatongdan Balaam ya inulgudda nan inalin Balak. ");
INSERT INTO ifb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ya inalin Balaam ay diday, “Umiyan ayuh tu ta awni ta maweet ya un'u ibaag di ma'at hi itudun Apo Dios ay ha\"in.” At immiyan nan a'ap'apuh abung Balaam. ");
INSERT INTO ifb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ya inalin Apo Dios ay Balaam di, “Ngadan danen linala'in immiyan?” ");
INSERT INTO ifb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ya tembal Balaam an inalinay, “Nan alih ad Moab an hi Balak an hina' Zippor di nannag ay dane an alyondan ha\"in di, ");
INSERT INTO ifb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Wadada han tatagun nalpud Egypt an hinakupdan amin nan lutan nunlene'woh hinan babluy. At pohdo' ya umali'a ta idutam dida ta way ato' an mangabak ya numpakak'u dida.” ");
INSERT INTO ifb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mu inalin Apo Dios ay Balaam di, “Adi'a mi'yuy ay dida, ya adim idutan danen tatagu ti winagaha' dida!” ");
INSERT INTO ifb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ya unat goh nabiggat ya bimmangon hi Balaam, ya immuy hinan a'ap'apun hennag Balak, ya inalinay, “Mumbangngad ayuh babluyyu ti adi iyabulut Apo Dios an mi'yalia' ay da'yu.” ");
INSERT INTO ifb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","At numbangngad nan hennag Balak, ya inalidan hiyay, “Adi pohdon Balaam an mitnud ay da'mi.” ");
INSERT INTO ifb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Mu nunhonag goh hi Balak hi do'do'ol an a'ap'apu, ya nun'abagtuy haadda ya un din nahhun. ");
INSERT INTO ifb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ya unat goh immatamda ay Balaam ya inaliday, “Hiyah te pohdon Balak an imbaluy Zippor an ibagan he\"a ta adim abuluton nan mangipawah umaliam ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Mi'yali'a ni' ahan ta idutam daten tatagu! At do'ol di idat'un he\"ah lagbum, ya ato' an amin di alyom ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mu inalin Balaam ay danen baal Balak di, “Ta\"on un idat Balak nan palasyuna an napnuh balitu' ya silver ya adi mabalin hi un'u adi aton nan mandal Apo Dios! ");
INSERT INTO ifb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","At ta\"on ya umiyan ayuh tud ugwan an labi an umat hi inat din nahhun an immali ta innilao' goh di alyon Apo Dios ay ha\"in.” ");
INSERT INTO ifb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ya henen nahdom ya himmapit hi Apo Dios ay Balaam, ya inalinay, “Gulat ta he\"ay awiton danen linala'in immali at mabalin an mitnud'a. Mu nan inali' ay he\"a ya anggay di atom.” ");
INSERT INTO ifb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ya unat goh nabiggat ya nuntakay hi Balaam hinan tennan dongkina, at nitnud hinan a'ap'apun di iMoab. ");
INSERT INTO ifb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mu ma'abbungot hi Apo Dios an dumalat di itnudan Balaam, at heden gun pundaldallanan da Balaam ya nan duwan baalnan ni'yibbana ya hinawanan nan Anghel Apo Dios nan dalan an pange'wan da Balaam. ");
INSERT INTO ifb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ya tinnig nan dongkin Balaam din Anghel Apo Dios an timma'dog hinan dalan an ino'odnanay hanggap, ya imbawengna ta nan payaw di nange'wana. At hinuplit Balaam nan dongkina ta imbangngadnah nan kulha. ");
INSERT INTO ifb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mu immuy goh an timma'dog nan Anghel hinan na'ullipit an dalan an numbattanan di natamman hi greyp an na'allup di numpinnangngel. ");
INSERT INTO ifb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ya unat goh tinnig nan dongki nan Anghel ya nahlig ta nipaeng hinan tapeng, at nigadgad di hu'in Balaam, at hinuplitna goh nan dongkina. ");
INSERT INTO ifb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ya nahlig goh nan Anghel Apo Dios ta timma'dog hinan na'ullipit an dalan an mi'id di pangiyiwangan hi pange'wan hinan numpinangngel. ");
INSERT INTO ifb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ya unat goh tinnig nan dongki nan Anghel ya nunlu'bub. At ma'abbungot ahan hi Balaam, ya inhuplitna din hul'udnah nan dongki. ");
INSERT INTO ifb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ya impahapit Apo Dios heden dongki, ya inalinan Balaam di, “Hay inat'un he\"a ta hinuplita' hi numpitlu?” ");
INSERT INTO ifb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ya tembal Balaam an inalinay, “Manu ay ti gunna' linayahan ay he\"a! Ya gulat ta waday hanggap hi inodna' at patayo' he\"ad ugwan!” ");
INSERT INTO ifb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ya inalin goh nan dongki di, “Undan bo'on ha\"in nan dongkim an gunmu nuntakatakayan an nete\"ah awada' ay he\"a ta nangamung ad ugwan? Ya undan waday inat'un he\"ah umat hinah din hopapna?” Ya inalin Balaam di, “Mi'id.” ");
INSERT INTO ifb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","At indat Apo Dios di abalinan Balaam an mannig hinan Anghel an timmata'dog ya ino'odnanay hanggap. Ya unat goh tinnig Balaam ya nunhippi, ya inluungna ta nangamung immatam hinan lutay angahna. ");
INSERT INTO ifb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ya inalin nan Anghel Apo Dios ay hiyay, “Anaad ta hinuplitmuh ten dongkih numpitlu? Manu ay hinawana' he\"a ti adi' pohdon henen ninomnommun aton! ");
INSERT INTO ifb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mu tinniga' hinan dongkim, at hiyaat unna' iniwangan ay hiyah numpitlu. Mu gulat ta agguya' iniwangan at immannung an he\"ay pinatoy'u, at nan dongki di hiyay tinagu'!” ");
INSERT INTO ifb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ya inalin Balaam hinan Anghel Apo Dios di, “Numbahola' ahan ay Apo Dios! Ti agguy'u ahan inilah unna' gun hawanan ay he\"ah nan owon! At gulat ay ta adim pohdon an umuya' ya mumbangngada' hi abung'u.” ");
INSERT INTO ifb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ya tembal nan Anghel Apo Dios, ya inalinay, “Mabalin an mitnud'an daten linala'i, mu nan ibaga' ay he\"ay hapitom ya anggay.” At nitnud hi Balaam ay daden linala'in u'upihyal Balak. ");
INSERT INTO ifb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ya unat goh dengngol Balak an magadyuh dumatong hi Balaam ya immuy ta damuwona hiyah nan ohan siudad ad Moab an nan wah nan pingit di Wangwang an Arnon. ");
INSERT INTO ifb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ya hidin nundammuda ya inalin Balak ay Balaam di, “Undan ahan agguy numpidway nangipa'ayaga' ay he\"a ta umali'ah tu? Anaad ahan ta agguy'a ni'yalin dida? Undan hay ninomnommu ya mid olog'un mangidat hi pohdom hi lagbum?” ");
INSERT INTO ifb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ya tembal Balaam an inalinay, “Ten immalia' ad ugwan. Mu undan way abalina' ta nonong ya himmapita'? Ti ammuna nan alyon Apo Dios di hiyay hapito'.” ");
INSERT INTO ifb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","At nitnud hi Balaam ay Balak ta immuydad Kiriath Huzoth. ");
INSERT INTO ifb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ya nun'onong hi Balak hi baka ya kalnilu, ya indatanah dotag hi Balaam ya nan a'ap'apun nitnud ay hiya ta ihdada. ");
INSERT INTO ifb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ya unat goh nabiggat ya initnud Balak hi Balaam ta immuydah nan Duntug an Bamoth Ba'al. Ya hidiy nangamangan Balaam hinan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ya inalin Balaam ay Balak di, “Iyammam di pituh pun'onngan hitu, ya inyalim di pitun manilhig hi baka ya pitu goh an buta'al an kalnilu.” ");
INSERT INTO ifb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","At impiyamman Balak henen inalin Balaam hi atona. Ya enepong da Balak ay Balaam an ene'nong di hinohhah baka ya kalnilu eden pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ya inalin Balaam ay Balak di, “Tumata'dog'ah tun awadan di e'nongmu ta umuya' ta olom man ya umalih Apo Dios an mi'hapit ay ha\"in. Ya hay alyonan ha\"in di hiyay alyo' goh ay he\"a.” At immuy hinan ata'nang an duntug an mapulun. ");
INSERT INTO ifb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","At hidiy nanamuwan Apo Dios ay Balaam, at inalin Balaam di, “Indadaan'uy pitun pun'onngan, at ene'nong'uy hinohhah baka ya kalnilu.” ");
INSERT INTO ifb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ya intudun Apo Dios ay Balaam di hapitonan alyonay, “Mumbangngad'a ay Balak, ya hiyah te ibagam.” ");
INSERT INTO ifb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","At numbangngad hi Balaam, ya wagwah dih Balak an nunnanong an timmata'dog hinan awadan di ene'nongna. Ya ni'ta'dog goh ay hiya nan a'ap'apun di iMoab. ");
INSERT INTO ifb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ya himmapit hi Balaam an inalinay, “Hi Balak an alin di iMoab di nangipa'ayag ay ha\"in ad Aram hinan aduntuduntug hi appit di buhu'an di algaw an alyonay, Umali'a ta ipa'idut'un he\"a nan holag Israel, ya numpihulmu dida. ");
INSERT INTO ifb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mu hay ato' an mangidut ay didah un agguy inidutan Apo Dios, unu hay ato' an mamihul ay didah unda agguy napihul? ");
INSERT INTO ifb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ya hidih nan way tulid di duntug ya inuhdunga' dida, ya tinnig'u dida, ya hay pannig'un dida ya nilahhindan tatagun adida pohdon an middum hinan abablubabluy an hakup di Hentil. ");
INSERT INTO ifb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ya undan udot waday way olognan manguyap hinan holag Jacob? Ti ta\"on di godwan nan uyapda ya mi'id ologdan mangyap! Ya hay pohdo' hi unna' matoy ya umata' ay danen tatagun mi'id baholda, ya hay angunuh di itagua' hi ataya' ya maphod hi unna' umat ay dida!” ");
INSERT INTO ifb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ya inalin Balak ay Balaam di, “Anaad ta umat hinay inatmun ha\"in? Hay nangipa'ayaga' ay he\"ah tu ya ta idutam nan binuhul'u! Mu nat'on di inatmu ti unmuat goh winagahan dida!” ");
INSERT INTO ifb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ya tembalnan inalinay, “Ma'ahhapul ahan an emayaa' di hapito' ta ammuna nan inalin Apo Dios di hiyay alyo'.” ");
INSERT INTO ifb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ya inalin Balak ay Balaam di, “Mitnud'a ni' ay ha\"in ta umuytah nan ohan lugal ta hidiy pangamangam hinan holag Israel, mu adim tigon didan amin ti un anggay nan wah nan pingitna. Ya ta olom man ya hidiy pangidutam ay dida.” ");
INSERT INTO ifb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","At initnudnah Balaam ta immuydah nan payaw hi ad Zophim hidih nan way nundodottal hinan tulid di Duntug an Pisgah. Ya inyamman goh Balak di pitun pun'onngan, ya enepongna goh an ene'nong nan manilhig an baka ya buta'al an kalnilu. ");
INSERT INTO ifb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ya inalin goh Balaam ay Balak di, “Tuma'dog'ah tun awadan di ene'nongmu ta umuya' hidi an mi'hapit ay Apo Dios.” ");
INSERT INTO ifb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ya dinamun Apo Dios ay Balaam, ya inalinay, “Itudu' di hapitom, at mumbangngad'an Balak.” ");
INSERT INTO ifb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ya numbangngad hi Balaam, ya tinnignah Balak an wagwah din timmata'doganah nan awadan din ene'nongna. Ya ni'tata'dog goh ay hiya nan a'ap'apun di iMoab. Ya inalin Balak ay hiyay, “Hay inalin Apo Dios ay he\"a?” ");
INSERT INTO ifb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ya himmapit hi Balaam an inalinay, “Ihamadmu, Balak an imbaluy Zippor, ta donglom heten alyo'. ");
INSERT INTO ifb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Hi Apo Dios ya adi umat hi tagu ti Hiya ya adi munlayah, ya bo'on goh imbaluy di tagu, at adina hukatan di ninomnomna. Undan way intulagna ya agguyna impa'annung? Ya undan way inalina ya agguyna inat? ");
INSERT INTO ifb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ya hay intugunan ha\"in ya unna' munwagah, at winagahana ay ya adi' abalinan an lumonon! ");
INSERT INTO ifb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ya mi'id di tinnignah nappuhih aat Jacob, ya mi'id goh tinnignah numbaholan di holag Israel. Ya hi Apo Dios an dayawonda ya wagwadan dida, ya ibugawda an Hiyay alida. ");
INSERT INTO ifb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ya Hiyay nangekak ay didad Egypt, at nunheglay bi'ahdan mipaddung hinan atap an baka. ");
INSERT INTO ifb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ya mi'id di olog nan pumalliw an mamalliw ay Jacob unu mane'om ay hiya, ya mi'id goh olog nan halupe ya duhong an ba'in mama\"ih nan holag Israel. At hay alyondah aat Jacob ya nan holag Israel ya inaliday, Tigonyuy inat Apo Dios an mid al'alin dida! ");
INSERT INTO ifb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Emayaanyu ti mabi'ah daten tatagu an umatdah nan layon, ya atata'otdan umatdah nan layon an adi duminong ta engganah unna aminon an ihda nan dempapna, ya ininumnan amin di dalan nan pinatoyna!” ");
INSERT INTO ifb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ya inalin Balak ay Balaam di, “Adim ay dida idutan ya adim goh wagahan dida!” ");
INSERT INTO ifb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Mu tembal Balaam an inalinay, “Un'u dan agguy inalin he\"a an hay ibagan Apo Dios di hiyay ato' ya anggay?” ");
INSERT INTO ifb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ya inalin Balak ay Balaam di, “Umali'a ta itnud'u he\"a ta umuytah nan ohan lugal ta olom ya hidiy pangiyabulutan Apo Dios hi pangidutam ay dida!” ");
INSERT INTO ifb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","At initnud Balak hi Balaam ta inyuynah nan tulid di Duntug an Peor an hay ma'amang ya nan mapulun. ");
INSERT INTO ifb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ya inalin Balaam ay Balak di, “Ipiyammam goh hituy pituh pun'onngan, ya inyalim di pituh manilhig an baka ya pitu goh hi buta'al an kalnilu.” ");
INSERT INTO ifb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ya impiyamman Balak an amin nan inalin Balaam, at enepongnan ene'nong di hinohhan baka ya kalniluh nan pitun pun'onngan. ");
INSERT INTO ifb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Mu i'innilan Balaam an nan holag Israel di pohdon Apo Dios an wagahan, at agguy mahkay immuy an ni'hapit ay Apo Dios an adi umat hidin numpidwan numba'iana. At hay inatna ya nunligguh ta inamangna nan mapulun. ");
INSERT INTO ifb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ya unat goh inyamang Balaam ya tinnigna nan holag Israel an na'uhi'uhig di nungkampuan di hinohhan himpangapu, ya niyo'odol nan Na'abuniyanan an Lennawan hiya. ");
INSERT INTO ifb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","At impahapit goh Apo Dios hiya, ya inalinay, “Hiyah te ipa'innilan Balaam an imbaluy Beor, ya hiyah te ipa'innilan han tagun mapatal an mabi'ah di panigawna, ");
INSERT INTO ifb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ya hiyah te ipa'innilan han tagu an ay donglonay nolo'a', mu agguya' nalo' an dinidiat'u an titiggo' di ipa'innilan nan na'abbagbagtun Apo Dios ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Anakkayah an mun'aphod di numpunhituwan nan holag Jacob an hi Israel! ");
INSERT INTO ifb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ya hay punhituwanda ya umat hinan ambibilog an numpundotal, ya umatdah nan galden hinan pingit di wangwang! Ya umat goh hinan ayiw an nabangluy hunghungna an intanom Apo Dios, ya umat goh hinan atata'nang an ayiw an cedar hinan pingit di danum! ");
INSERT INTO ifb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ya mawaday do'ol an udan, at do'ol di pananumdah nan intanomdah nan payaw, ya adi makudangan hi danum di itanomda! Ya nabagbagtu nan alida ya un hi Agag, ya hay pumpapto'ana ya mipabagbagtu! ");
INSERT INTO ifb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ya hi Apo Dios di nangekak ay didad Egypt, ya hay bi'ahda ya umat hinan bi'ah di atap an baka ta abalinandan abakon di binuhulda, ya pun'ipungday tungal di buhulda, ya hay pamatoydah nan buhulda ya nan panada! ");
INSERT INTO ifb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ya nan holag Israel ya umatdah nan ma'abbi'ah an buta'al an layon an munlulu'bub an nidadaan hi buhul, ya umatda goh hinan tennan layon an mi'id ah mangitulid an umuy mamangon ay hiya! At nan mungwagah hinan holag Israel ya mawagahan goh, ya nan mangidut ay dida ya ma'idutan goh!” ");
INSERT INTO ifb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ya unat goh dengngol Balak an agguy damdama inidutan Balaam ya nunheglan ma'abbungot ahan ay Balaam, ya nunggomgomnay ngamaynah bungotna, ya init'u'nan inalinan Balaam di, “Impa'ayag da'a ta idutam danen binuhul'u! Ya unmuat goh tinuntunud an winagahan didah numpitlu! ");
INSERT INTO ifb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","At umanamut'aat hi nunhituwam! Alyo' at goh un da'a lagbuan hi ongol, mu agguy inyabulut Apo Dios di pangidata' hi lagbum!” ");
INSERT INTO ifb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ya tembal Balaam an inalinay, “Undan agguy'u tuwali inali ay danen hennagmun mangawit ay ha\"in di, ");
INSERT INTO ifb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ta\"on un idat Balak ay ha\"in an amin di silver an pihhuna ya an amin nan balitu' an wah nan palasyuna ya adi ahan mabalin hi un'u ibahhaw nan intugun Apo Dios hi ato' an dumalat nan pangata' hinan logom! At nan inalin Apo Dios di hapito' ya anggay. ");
INSERT INTO ifb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ad ugwan ya ten mumbangngada' hinan babluymi, mu padana' he\"a ta ipa'innila' di aton nan holag Israel hinan tatagum hi udum di algaw!” ");
INSERT INTO ifb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ya impahapit goh Apo Dios hiya, ya inalinay, “Hiyah te ipa'innilan Balaam an imbaluy Beor, ya hiyah te ipa'innilan han tagun mapatal an mabi'ah di panigawna, ");
INSERT INTO ifb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ya hiyah te ipa'innilan han tagu an ay donglonay nolo'a', mu agguya' nolo' an dinidiat'u an titiggo' di ipa'innilan nan na'abbagbagtun Dios ay ha\"in. ");
INSERT INTO ifb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ya innilao' an udum hi algaw ya waday malpuh nan holag Israel hi ohan ali an umat hi ma\"abnang an bittuan. At pun'abakna nan a'ap'apun di iMoab, ya punggumi'nay ulun nan tatagud Sheth. ");
INSERT INTO ifb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ya nan holag Israel ya abakonda nan binuhulda an holag Edom, ya hinakupda nan babluyda ta diday munhituh di, ya iddumdan hakupon ad Seir. At dida an holag Israel di mangab'abak. ");
INSERT INTO ifb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ya malpuh nan holag Israel di ohan mumpamatoy hi an amin an na'angang hinan siudad.” ");
INSERT INTO ifb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ya intigaw Balaam hinan holag Amalek, ya himmapit an inalinay, “Nan holag Amalek di hiyay ongol di abalinana ya un nan udum an babluy. Mu udum di algaw at mapogpog ti ma'ubahdah enggana.” ");
INSERT INTO ifb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ya intigawnah nan holag Ken, ya hinapitna han nipa\"el an inalinay, “Nan lugal an nunhituwanyu ya na'ihhamad an mi'id di al'ali, ya nan nipabunan di abungyu ya nan gungit. ");
INSERT INTO ifb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mu udum di algaw at mun'atoy ayun holag Ken ti umali nan holag Ashur, ya hinakup da'yu ta iyuy da'yuh nan babluyda, ya pumbalinon da'yuh himbutda.” ");
INSERT INTO ifb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hiyah te goh hinapit Balaam an nipa\"el an inalinay, “Undan nin way mataguh un ipa'annung Apo Dios di umat hina? ");
INSERT INTO ifb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mu wadaday umalin nunlugan hi pupul an malpuh Cyprus, at gubatonda nan holag da Ashur ay Eber, mu ta\"on un dida ya ma'ubahda goh.” ");
INSERT INTO ifb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ya unat goh nalpah nan hinapihapit Balaam ya numbangngad an umanamut hi babluyda, ya immanamut goh hi Balak. ");
INSERT INTO ifb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ya hidin awadandad Shittim ya ente\"an nan linala'in holag Israel an nangelo' hinan binabain iMoab. ");
INSERT INTO ifb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ti danen binabai ya inayaganda nan linala'in holag Israel hinan awadan di pun'onngandah bulul, ya ne\"andah nan ene'nongda, ya ni'dayawdah nan bulul an dayawon di iMoab. ");
INSERT INTO ifb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ya dumalat nan pi'dayawan nan holag Israel ay Ba'al hi ad Peor ya ma'abbungot hi Apo Dios ay didan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ya inalin Apo Dios ay Moses di, “Ayagam an amin nan a'ap'apun nan holag Israel ta pun'ipapatoymu danen linala'ih nan way hinagang di awada' hinan munggawa ta way ato' an mangidinong an bumungot hinan holag Israel!” ");
INSERT INTO ifb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ya inalin Moses hinan huhuwis hi ad Israel di, “Pumpatoyyu nan i'ibbayun linala'in immuy ni'dayaw hinan bulul an hi Ba'al hi ad Peor!” ");
INSERT INTO ifb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ya wada han ohan lala'in holag Israel an nangitnud hi ohah babain iMidian, ya inyuynah nan nungkampuanda, ya tinnig Moses ya an amin nan na'amung an holag Israel an ahikikilah nan pantaw di Tuldan Abung hi wadan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ya unat goh tinnig Phinehas an lala'in imbaluy nan Nabagtun Padin hi Eleazar an ap'apun Aaron ya timma'dog, ya tinaynana daden na'amung, ya immuyna innal di gayangna, ");
INSERT INTO ifb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ya inunudna din lala'ih nan abungna an hinumgupanda, ya ginayangna didan duwa. Ya nunhawang hi putun din babai, ya indohdohna ta nunta\"opdan natibi'. Ya henen na'at di hiyay nangidinngan Apo Dios an nummoltah nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","At hay uyap di natoy an minoltan Apo Dios ya ba'inti ta opat di libuy tatagun holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ya inalin Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Dumalat henen inat Phinehas an imbaluy nan Nabagtun Padin hi Eleazar an ap'apun Aaron ya adia' mahkay bumungot hinan holag Israel ti mattig'u hiya an adina pohdon an waday udum an dios an anggay Ha\"in. At hiyaat un'u mahkay adi ituluy nan planu' hi pangubaha' ay dida an dumalat hinan bungot'u. ");
INSERT INTO ifb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","At alyom ay Phinehas di, Itulag'un mi'id al'alin hiyah enggana. ");
INSERT INTO ifb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ya itulag'un mi'id al'alih nan holagna ta diday minaynayun an mumpadi ti agguyna inyabulut an waday udum an dios an anggay Ha\"in. Ya henen inatnay a'aliwan di bahol nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ya hay ngadan din lala'in holag Israel an ni'yatoy hidin babain iMidian ya hi Zimri an lala'in imbaluy Salu an holag Simeon. ");
INSERT INTO ifb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ya hay ngadan nen babain iMidian an napatoy ya hi Kozbi an imbaluy Zur an hiyay ohan mangipangpanguluh nan iMidian. ");
INSERT INTO ifb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ya himmapit goh hi Apo Dios ay Moses an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ibilangyu nan iMidian hi buhulyu, at gubatonyu, ya pumpatoyyu dida ");
INSERT INTO ifb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ti binalbaliyan da'yu, at dinayawyu nan bulul an hi Ba'al ad Peor an dimmalat hinan babain imbaluy han mangipangpanguluh nan iMidian an hi Kozbi an din napatoy hidin gutud di awadan nan nidugah an nunligatanyuh inatdad Peor.” ");
INSERT INTO ifb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ya unat goh nalpah henen nidugah an dogoh ya inalin Apo Dios ay da Moses ay Eleazar an Nabagtun Padin imbaluy din hi Aaron an nahhun an Nabagtun Padiy, ");
INSERT INTO ifb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Uyaponyun amin di hinohhan himpangapun holag Israel an muntawon hi ba'inti ya han nahuluk an olognan muntindalu ta way umuy mi'gubat.” ");
INSERT INTO ifb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","At heden awadandah nan nungkampuandah nan nundotal ad Moab hinan pingit di Wangwang an Jordan hinan dammang ad Jericho ya da Moses ay Eleazar an Nabagtun Padi ya intugundah nan a'ap'apun nan holag Israel di atondan mangyap hinan linala'in holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Ya inalin Eleazar di, “Uyaponyun amin nan linala'in holag Israel an muntawon hi ba'inti ta han nahuluk di tawonda ti hiyah ne immandal Apo Dios ay Moses hi aton tu'u.” At hiyatuy nitudo' an uyap an amin nan holag Israel an nalpud Egypt: ");
INSERT INTO ifb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Hi Reuben di pangpangulluh lala'in imbaluy Israel, ya hay imbabaluy Reuben ya hi Hanok (an hiyay napu'agan nan himpangapun an ma'alih Hanok), ya hi Pallu (an hiyay napu'agan nan himpangapun ma'alih Pallu), ");
INSERT INTO ifb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ya hi Hezron (an hiyay napu'agan nan himpangapun ma'alih Hezron), ya hi Karmi (an hiyay napu'agan nan himpangapun ma'alih Karmi). ");
INSERT INTO ifb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","At hiyanay napatadan nan holag Reuben an hay uyapdan amin ya napat ta han tuluy libu ya han pituy gahut ta han tulumpulu. ");
INSERT INTO ifb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ya hay imbaluy Pallu ya hi Eliab ");
INSERT INTO ifb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","an hi aman da Nemuel, ya hi Dathan, ya hi Abiram. Ya da Dathan ay Abiram di pento' nan tatagu ta mumpapto', mu inamuyuan da Moses ay Aaron, ya niddumdan da Korah hidin nungngohoyandan Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mu nanga' nan luta, at nun'a'unugdad dolom, ya niddum hi Korah, at natoydan amin din nangunud ay Korah an genhob di apuy di duway gahut ya han nabonglen linala'i. Ya heden na'at ay diday pangitigan nan tatagu ta way atondan adi mangat hinan inatda. ");
INSERT INTO ifb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mu nan imbabaluy Korah ya agguyda ni'yatoy. ");
INSERT INTO ifb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ya hiyatuy nahlagan nan imbabaluy Simeon an himpangapu an nan holag Nemuel (an hiyay napu'agan nan himpangapun ma'alih Nemuel), ya hi Jamin (an hiyay napu'agan nan himpangapun ma'alih Jamin), ya hi Jakin (an hiyay napu'agan nan himpangapun ma'alih Jakin), ");
INSERT INTO ifb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ya hi Zerah (an hiyay napu'agan nan himpangapun ma'alih Zerah), ya hi Shaul (an hiyay napu'agan nan himpangapun ma'alih Shaul). ");
INSERT INTO ifb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hay uyap an amin nan linala'in holag Simeon ya ba'inti ta duway libu ya han duway gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ya hiya hatuy linala'in himpangapu an holag Gad an hi Zephon (an hiyay napu'agan nan himpangapun ma'alih Zephon), ya hi Haggi (an hiyay napu'agan nan himpangapun ma'alih Haggi), ya hi Shuni (an hiyay napu'agan nan himpangapun ma'alih Shuni), ");
INSERT INTO ifb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ya hi Ozni (an hiyay napu'agan nan himpangapun ma'alih Ozni), ya hi Eri (an hiyay napu'agan nan himpangapun ma'alih Eri), ");
INSERT INTO ifb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ya hi Arodi (an hiyay napu'agan nan himpangapun ma'alih Arodi), ya hi Areli (an hiyay napu'agan nan himpangapun ma'alih Areli). ");
INSERT INTO ifb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ya hiyanay himpangapu an holag di a'apun Gad an hay uyapda ya napat di libu ya han lemay gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Hi Er ya hi Onan di holag Judah, mu daten duwa ya natoydad Canaan. ");
INSERT INTO ifb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ya hay udumnah holag Judah ya hi Shelah (an hiyay napu'agan nan himpangapun ma'alih Shelah), ya hi Perez (an hiyay napu'agan nan himpangapun ma'alih Perez), ya hi Zerah (an hiyay napu'agan nan himpangapun ma'alih Zerah). ");
INSERT INTO ifb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Hay holag Perez ya hi Hezron (an hiyay napu'agan nan himpangapun ma'alih Hezron), ya hi Hamul (an hiyay napu'agan nan himpangapun ma'alih Hamul). ");
INSERT INTO ifb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ya hay uyap daten himpangapu ya napitu ta onom di libu ya han lemay gahut an linala'i. ");
INSERT INTO ifb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ya hiyatuy holag Issachar an hi Tola (an hiyay napu'agan nan himpangapun ma'alih Tola), ya hi Puah (an hiyay napu'agan nan himpangapun ma'alih Puah), ");
INSERT INTO ifb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ya hi Jashub (an hiyay napu'agan nan himpangapun ma'alih Jashub), ya hi Shimron (an hiyay napu'agan nan himpangapun ma'alih Shimron). ");
INSERT INTO ifb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ya hay uyap daten himpangapu ya nanom ta opat di libu ya han tuluy gahut an linala'i. ");
INSERT INTO ifb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ya hiyatuy holag Zebulun an hi Sered (an hiyay napu'agan nan himpangapun ma'alih Sered), ya hi Elon (an hiyay napu'agan nan himpangapun ma'alih Elon), ya hi Jahleel (an hiyay napu'agan nan himpangapun ma'alih Jahleel). ");
INSERT INTO ifb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ya hay uyap daten himpangapu ya nanom di libu ya han lemay gahut an linala'i. ");
INSERT INTO ifb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ya hiyatuy holag Joseph an didana nan holag da Manasseh ay Ephraim. ");
INSERT INTO ifb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ya hay holag Manasseh ya hi Makir (an hiyay napu'agan nan himpangapun ma'alih Makir), ya hi Gilead (an hiyay napu'agan di himpangapun ma'alih Gilead). Hi Makir di hi aman Gilead. ");
INSERT INTO ifb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ya hay linala'ih holag Gilead ya hi Iezer (an hiyay napu'agan nan himpangapun ma'alih Iezer), ya hi Helek (an hiyay napu'agan nan himpangapun ma'alih Helek), ");
INSERT INTO ifb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ya hi Asriel (an hiyay napu'agan nan himpangapun ma'alih Asriel), ya hi Shechem (an hiyay napu'agan di himpangapun ma'alih Shechem), ");
INSERT INTO ifb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ya hi Shemida (an hiyay napu'agan nan himpangapun ma'alih Shemida), ya hi Hepher (an hiyay napu'agan nan himpangapun ma'alih Hepher). ");
INSERT INTO ifb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ya hi Zelophehad an holag Hepher ya mi'id holagnah linala'i an anggay di binabai an hay ngadanda ya hi Mahlah, ya hi Noah, ya hi Hoglah, ya hi Milkah, ya hi Tirzah. ");
INSERT INTO ifb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ya hay uyap daten himpangapu ya nabongle ta duway libu ya han pituy gahut an linala'i. ");
INSERT INTO ifb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ya hiyatuy linala'in holag Ephraim an hi Shuthelah (an hiyay napu'agan nan himpangapun ma'alih Shuthelah), ya hi Beker (an hiyay napu'agan nan himpangapun ma'alih Beker), ya hi Tahan (an hiyay napu'agan nan himpangapun ma'alih Tahan). ");
INSERT INTO ifb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ya waday holag Shuthelah an hi Eran (an hiyay napu'agan nan himpangapun ma'alih Eran). ");
INSERT INTO ifb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ya hay uyap daten himpangapu ya tulumpulu ta duway libu ya han lemay gahut an linala'i. Dida hanay holag Joseph. ");
INSERT INTO ifb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ya hiyatuy linala'in holag Benjamin an hi Bela (an hiyay napu'agan nan himpangapun ma'alih Bela), ya hi Ashbel (an hiyay napu'agan nan himpangapun ma'alih Ashbel), ya hi Ahiram (an hiyay napu'agan nan himpangapun ma'alih Ahiram), ");
INSERT INTO ifb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ya hi Shupham (an hiyay napu'agan nan himpangapun ma'alih Shupham), ya hi Hupham (an hiyay napu'agan nan himpangapun ma'alih Hupham). ");
INSERT INTO ifb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ya waday holag Bela an hi Ard (an hiyay napu'agan nan himpangapun ma'alih Ard), ya hi Naaman (an hiyay napu'agan nan himpangapun ma'alih Naaman). ");
INSERT INTO ifb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ya hay uyap daten himpangapu ya napat ta lemay libu ya han onom di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ya hiyatuy himpangapu an holag Dan an hi Shuham (an hiyay napu'agan nan himpangapun ma'alih Shuham). ");
INSERT INTO ifb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ya hay uyapda ya nanom ta opat di libu ta han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ya hiyatuy holag Asher an hi Imnah (an hiyay napu'agan nan himpangapun ma'alih Imnah), ya hi Ishvi (an hiyay napu'agan nan himpangapun ma'alih Ishvi), ya hi Beriah (an hiyay napu'agan nan himpangapun ma'alih Beriah). ");
INSERT INTO ifb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ya hay holag Beriah ya hi Heber (an hiyay napu'agan nan himpangapun ma'alih Heber), ya hi Malkiel (an napu'agan nan himpangapun ma'alih Malkiel). ");
INSERT INTO ifb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ya wada goh di holag Asher an babai an mungngadan hi Serah. ");
INSERT INTO ifb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ya hay uyap daten himpangapu ya nabongle ta tuluy libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ya hiyatuy holag Naphtali an hi Jahzeel (an hiyay napu'agan nan himpangapun ma'alih Jahzeel), ya hi Guni (an hiyay napu'agan nan himpangapun ma'alih Guni), ");
INSERT INTO ifb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ya hi Jezer (an hiyay napu'agan nan himpangapun ma'alih Jezer), ya hi Shillem (an hiyay napu'agan nan himpangapun ma'alih Shillem). ");
INSERT INTO ifb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ya hay uyap daten himpangapu ya napat ta han lemay libu ya han opat di gahut. ");
INSERT INTO ifb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ya hay uyap an amin di linala'i an holag Israel ya onom di gahut ta han ohay libu ya han pituy gahut ta tulumpulu. ");
INSERT INTO ifb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Punggogodwom nan luta ta ipiyapongmuh nan hinohhan himpangapun na'yap an miyunnudan hinan ado'do'ol di uyapda. ");
INSERT INTO ifb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","At nan do'do'ol di uyapda ya ambilog di idatmuh banohda, ya danen nahnot di uyapda ya nahnot goh di idatmuh banohda. At an amin nan hinohhan dida ya miyunnudan hinan uyapday midat an banohda. ");
INSERT INTO ifb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ya ihamadmu ta unyu iyu'nuh di atom hinan lutan mipiyapong an banohda, ya miyunnudan hinan nitudo' an uyapdan himpangapu. ");
INSERT INTO ifb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","At nan mipiyapong an banohda ya miyunnudan hinan ado'olda ya nan anahnotda.” ");
INSERT INTO ifb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ya hiyatuy na'yap an nalpuh holag Levi an hi Gershon (an hiyay napu'agan nan himpangapun ma'alih Gershon), ya hi Kohath (an hiyay napu'agan nan himpangapun ma'alih Kohath), ya hi Merari (an hiyay napu'agan nan himpangapun ma'alih Merari). ");
INSERT INTO ifb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ya hiyatuy holag Levi an nan himpangapun Libni, ya nan himpangapun ma'alih Hebron, ya nan himpangapun ma'alih Mahli, ya nan himpangapun ma'alih Mushi, ya nan himpangapun ma'alih Korah. (Ya hi Kohath di napu'agan nan ad holag ay Amram. ");
INSERT INTO ifb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ya hay ngadan nan ahawan Amram ya hi Jochebed an babain holag Levi an nitungaw hi ad Egypt. Ta nunholagda ya da Aaron ay Moses ya hi Miriam an babai. ");
INSERT INTO ifb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Hi Aaron di hi aman da Nadab ay Abihu, ya hi Eleazar, ya hi Ithamar. ");
INSERT INTO ifb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mu da Nadab ay Abihu ya natoyda an dumalat di nange'nongandah nan agguy niyabulut an apuy hinan pun'onngan ay Apo Dios.) ");
INSERT INTO ifb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ya an amin nan linala'in holag Levi hi na'yap an mete\"ah ohay bulana an ung'ungnga unu nahuluk ya hay lammungdan amin ya ba'inti ta tuluy libu. An dida ya agguyda iniddum hinan na'yap an holag Israel ti mi'id di banohdah nan luta. ");
INSERT INTO ifb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ya an amin hatun ahimpahimpangapu ya inuyap da Moses ay Eleazar an Nabagtun Padih din awadandah nan nundotal an lutad Moab an neheggon hinan Wangwang an Jordan hinan dammang ad Jericho. ");
INSERT INTO ifb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ya mi'id ah ohah lala'ih na'angang hi agguy inuyap da Moses ay Aaron an din Nabagtun Padih awadandah nan Mapulun an Sinai. ");
INSERT INTO ifb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ti inalin Apo Dios di matoydan amin hinan mapulun, at hiyanan mi'id ahan di ohah ma'angang ti anggay hi Caleb an imbaluy Jephunneh ya hi Joshua an imbaluy Nun di matagu. ");
INSERT INTO ifb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ya wada han ohay algaw ya nun'ulu' nan binabain da Mahlah, ya hi Noah, ya hi Hoglah, ya hi Milkah, ya hi Tirzah an hi amadah hi Zelophehad (an lala'in imbaluy Hepher, an lala'in imbaluy Gilead, an imbaluy Makir, an imbaluy Manasseh, an hina' Joseph). ");
INSERT INTO ifb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ya immuyda, ya timma'dogdah nan wadan da Moses ay Eleazar an Nabagtun Padi, ya nan a'ap'apu, ya amin nan tataguh nan pantaw di Tuldan Abung hi wadan Apo Dios, ya inaliday, ");
INSERT INTO ifb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Natoy hi amamih tuh nan mapulun an dimmalat nan numbaholana, ya mi'id ah tinaynanah lala'ih imbaluyna, mu agguy hiya niddum ay da Korah ya nan udum an ni'bohhol ay Apo Dios. ");
INSERT INTO ifb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ya anaad ta na'aan di ngadanah nan Nitud'an di Holag an nalpuwana an dumalat hi ami'id di holagnah lalai? At mi'bingay ami ni' hinan lutan banoh din a'agin amami!” ");
INSERT INTO ifb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","At hi Moses ya imbaganan Apo Dios henen pohdondan ma'at. ");
INSERT INTO ifb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","At inalin Apo Dios ay hiyay, ");
INSERT INTO ifb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Immannung henen inalin danen binabain holag Zelophehad. At mahapul an midatandah nan lutan banoh din a'agin amada ta diday mamanoh hi bagin amada. ");
INSERT INTO ifb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ya alyom hinan holag Israel di, Gulat ta matoy di ohah lala'i ya mi'id ah lala'ih imbaluyna ya mabalin an bonhon nan binabain imbabaluyna nan banohna. ");
INSERT INTO ifb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ya gulat ta mi'id holagnah binabai ya mipabnoh hinan linala'in a'aginah nen banohna. ");
INSERT INTO ifb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ya gulat ta mi'id lala'ih a'agina ya mipabnoh hinan lala'in agin amana. ");
INSERT INTO ifb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ya gulat ta mi'id a'agin nan ommodna ya mipabnoh hinan neheggon an tulangna. At hiyah te uldin hi aton nan holag Israel.” ");
INSERT INTO ifb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ya wada han ohay algaw ya inalin Apo Dios ay Moses di, “Ti'idom heten ohan duntug hinan aduntuduntug ad Abarim ta amangom henen lutan idat'uh nan holag Israel. ");
INSERT INTO ifb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ya nalpah ay an inamangmuh nen luta ya umuy'a mahkay an middum hinan o'ommodmuh penghana an nun'atoy an umat hi na'at ay agim an din hi Aaron. ");
INSERT INTO ifb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Ti da'yun duwa ya agguyyu inunud din immandal'uh atonyuh din awadanyuh nan Mapulun an Zin, ya hidin nangamuyuan nan tatagun Ha\"in hidih nan way danum ya agguyyu impattig ay dida an Ha\"in ya me'gonana' hidin gutud di umamuyuandah dih nan way danum.” (Hiyah ne danum hi ad Meribah Kadesh hinan Mapulun an Zin.) ");
INSERT INTO ifb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Ya ni'hapit hi Moses ay Apo Dios an inalinay, ");
INSERT INTO ifb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“He\"a, Apo Dios, di nangidat hi ataguan an amin di matagu, at pot'om ni' ahan di ohah taguh tun tatagu ");
INSERT INTO ifb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ta way mangipangpangullun didah nan pundalananda, ya wada goh di mangipangpangulun mangiyanamut ay dida, ya ta adida umat hinan kalnilun mi'id di mangipahtul ay dida!” ");
INSERT INTO ifb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","At inalin Apo Dios ay Moses di, “Pot'om hi Joshua an hina' Nun ti hiyay nangidata' hinan Na'abuniyanan an Lennawa, ya eneh'am di ngamaymuh nan uluna. ");
INSERT INTO ifb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ya itnudmu hiyah nan way hinagang nan Nabagtun Padin hi Eleazar ya an amin nan tatagun na'amung, ya ipa'innilam an hiyay mihukat ay he\"a ta donglon nan tatagun wah di. ");
INSERT INTO ifb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ya ipaboltanmu nan haadmun hiya ta way aton an amin nan tatagun mangunud ay hiya. ");
INSERT INTO ifb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ya hay tuma'doganah nan way hinagang Eleazar an Nabagtun Padi ya innilaon Eleazar di pohdon Apo Dios hi aton Joshua hinan Urim an wah nan way hinagang'u an Dios. At gulat ta alyonay makakda ya an amin nan tatagu ya mi'yekakdan Joshua, ya wa ay ta alyonay adida makak ya an amin nan holag Israel ya adida goh makak.” ");
INSERT INTO ifb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","At hi Moses ya inatnan amin nan immandal Apo Dios ay hiya. Ya initnudnah Joshua, ya impata'dognah nan way hinagang Eleazar an Nabagtun Padi ya nan way hinagang goh an amin nan na'amung an tatagu. ");
INSERT INTO ifb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","At eneh'an Moses hi ulun Joshua, ya impa'innilana an hiyay mihukat ay hiya ti hiyah ne immandal Apo Dios hi atona. ");
INSERT INTO ifb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ya inalin goh Apo Dios ay Moses di, ");
INSERT INTO ifb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Imandalmuh teh nan holag Israel, ya alyom di, Nan e'nongyun Apo Dios an nan Onong an Moghob ya nan udum an onong an umat hi Onong an Ma'an an mipulu' hi apuy ta maphod hi hunghungona ya adiyu ahan aliwan an mange'nong un madatngan nan gutud hi pangatanyu. ");
INSERT INTO ifb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ya alyom goh ay diday, Daten Onong an Moghob an me'nong ay Apo Dios hi abigabigat ya mahapul an minaynayun an umahu'ahu', at mahapul an duway manilhig an kalnilun kilaw an mi'id ah ganitna. ");
INSERT INTO ifb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ta henen oha ya me'nong hinan helhelong, ya nan oha ya me'nong hinan mapuyaw. ");
INSERT INTO ifb_vpl VALUES ("NU28_5","005