﻿USE sofia;
DROP TABLE IF EXISTS sofia.ifa_vpl;
CREATE TABLE ifa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ifa_vpl WRITE;
INSERT INTO ifa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hidin hopapna ya limmun Apu Dios di ad abunyan ya tun luta ");
INSERT INTO ifa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","mu ma''id ni' ha naputu' hi a'at tun luta. Te namaag ya on adallodallom an liting ta nunhiglan munhihillong. Ya nan Espiritun Apu Dios ya umanin'innabat hinan tu'yap di liting an umat hinan dibdib. ");
INSERT INTO ifa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ya alyon Apu Dios di, Mawaday patal. Ya nawada. ");
INSERT INTO ifa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ya maphod di nanigona i diyen patal. Ot punhiwwayona mohpe nan patal hinan hilong ");
INSERT INTO ifa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ta waday mapatal ya mahdom hinan hin'algawan. Ta hidiyey hopap di algo an mihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen nabiggat. ");
INSERT INTO ifa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ya alyon bon Apu Dios di, Mawada ha pumbattanan nan liting ta munduwa. ");
INSERT INTO ifa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ta wadah nan bugut an alpuwan di udan ya nan liting mo tuwalih tun luta. Ya hidiyey na'at. ");
INSERT INTO ifa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ot ngadanan Apu Dios hidiyen numbaktu hi ad lagud. Ta hidiyey mi'adwah algo an nihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen nabiggat. ");
INSERT INTO ifa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ya alyon bon Apu Dios di, Ad uwani ya pohdo' an ma'amung nan liting hinan nunda''ul ta mabudhan nan luta. Ya na'at. ");
INSERT INTO ifa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ot ngadanana nan mamaga hi luta ya nan na'amungan di liting hi baybay. Ya maphod di nanigon Apu Dios i diyen a'atna. ");
INSERT INTO ifa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ya alyon bon Apu Dios di, Humango ayuh tun lutay nat'onat'on an holo' ya mitanom an makan ya kayiw ya bungbunga\"an an waday buwada ta mabalin an minaynayun an waday humangoh tun luta. Ya hidiyey na'at. ");
INSERT INTO ifa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ta himmangoday nat'onat'on an nitanom an waday buwada ya nat'onat'on bon bungbunga\"an ta mabalin an minaynayun an waday humangoh tun luta. Ya maphod di nanigon Apu Dios i dadiyen himmangoh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ta hidiyey mi'atluh algo an nihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen nabiggat. ");
INSERT INTO ifa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ya alyon bon Apu Dios di, Mawadaday dilag hi ad lagud ta mapto' an waday hilong ya ahi nan mapatal ya ta panginnilaan bo hi bilang di algo ya bulan hinan hintawon. Ya panginnilaan boh nan ma'ma'at an umat hi ahiliya' ya nan algo an pundayawan ");
INSERT INTO ifa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ya ta buminang hi ad lagud ta madilagan tun luta. Ya hidiyey na'at. ");
INSERT INTO ifa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ta winadan Apu Dios nan duwan o''ongal an dilag an nan algo an manilag hitun lutah nan mapatal ya nan bulan an manilag hitun luta hinan mahdom. Ya winadana bo nadan bittuwon. ");
INSERT INTO ifa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ot iphodnan ipanuh dadiye hi ad lagud ta dilaganda tun luta ");
INSERT INTO ifa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ta nat'on nan manilag hinan mapatal ya nat'on boh nan mahdom. Ta nihiwwe nan hilong hinan mapatal. Ya tinigon Apu Dios dadiye ya maphod. ");
INSERT INTO ifa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ta hidiyey mi'apat hi algo an nihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen nabiggat. ");
INSERT INTO ifa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Alyon bon Apu Dios di, Mawadaday dakkodakkol ya nat'onat'on an munhituh nan nalitingan. Ya hay dakkodakkol bon nun'apaya'an ta ahitatayyapanday udum. ");
INSERT INTO ifa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ta limmun Apu Dios di nat'onat'on an wah nan baybay an o''ongalday udum. Ya atbohdin limmuna nadan nat'onat'on an nun'apaya'an. Ya tinigona ya maphod di a'atda. ");
INSERT INTO ifa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ot wagahana didan namin an alyonah nan wah nan nalitingan di, Hanat munholag ayu ta miwakat ayuh nadan nun'albong. Ya atbohdin winagahana nadan nun'apaya'an ta dumakoldah tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ta hidiyey nagibbuhan nan mi'alimah algo an nihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen nabiggat. ");
INSERT INTO ifa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Alyon bon Apu Dios di, Mawadadah tun lutay nat'onat'on an animal ya nadan udum an mungkaddapan. Ya na'at boh diye. ");
INSERT INTO ifa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ya maphod hi nanigon Apu Dios i dadiyen winadana. ");
INSERT INTO ifa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ya alyona boy, Ad uwani ya hay taguy lumuwon ta'u ta umatda i dita'u an ingohonday a'at ta'u. Ta diday ukod hi an namin nadan wah nan baybay ya nadan nun'apaya'an ya an namin nadan animal ya nadan mungkaddapan. ");
INSERT INTO ifa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ta athidi an limmun Apu Dios di tagu an impaddungnay a'atdah nan a'atna. Ta hay limmuna ya lala'i ya babai. ");
INSERT INTO ifa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ot wagahan Apu Dios didan alyonay, Hanat munholag ayu ta dumakol ayu ta lo'tat ya nipong ayuh tun luta ta da'yuy ukod hitun luta. Ya da'yu boy ukod hi an namin an wah nan baybay ya nadan nun'apaya'an ya nadan animal ya nadan mungkaddapan. ");
INSERT INTO ifa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ot inayun bon Apu Dios an alyon i diday, Nomnomnomonyu an indat'un da'yu nadan waday bunganan nun'itanom ya ta'on on nadan bungbunga\"an ya limmu' ta pangalanyuh anonyu. ");
INSERT INTO ifa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mu nadan holo' ya nadan udum an nitanom ya winada' ta anon nadan animal ya nadan nun'apaya'an ya nadan mungkaddapan. Ya an namin dadiyen inalin Apu Dios ya na'at. ");
INSERT INTO ifa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ya tinigon Apu Dios dadiyen namin an limmuna ya anakkaya an ma\"aphodda. Ta hidiyey nagibbuhan nan mi'anom hi algo an nihipun hinan mun'ahdom ta ingganah nan mun'ahdom bo i diyen ibiggatana. ");
INSERT INTO ifa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hidin nagibbuh an limmun Apu Dios di ad lagud ya tun luta ya an namin nadan wada ");
INSERT INTO ifa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ot tumungo i diyen mi'apituh algo ta hidiyey ayna nun'iblayan. ");
INSERT INTO ifa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ot wagahanah diyen mi'apituh algo an alyonay hidiyey na'anhan an algo te tinungonah din nalpahan an namin nan limmuna. ");
INSERT INTO ifa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ta datuwey na'at hidin nunlumuwan Apu Dios hitun luta ya hi ad lagud. ");
INSERT INTO ifa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Te ma''id ni' ha ta'on hi oha i ha nitanom onu ha namaaggot humango te aggena ni' impiyali ha udan hitun luta ya atbohdin ma''id ni' ha taguh muntanom. ");
INSERT INTO ifa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mu nanongnan waday liting an tumuluh nan luta ta hiyay munhanong hinan tu'yapna. ");
INSERT INTO ifa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ya indani ot alan Apu Dios nan pito' ot poklona i han adol di tagu ot hapudanay olong diyen limmuna ya numbalin hi tagu. ");
INSERT INTO ifa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ot iyamman Apu Dios han garden hi ad Eden an wah nangappit hi tuluwan di algo ot hidiy pangiha''adana i diyen lala'i an limmuna. ");
INSERT INTO ifa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ot ipahangonahdiy mun'a'aphod an bungbunga\"an. Ya hidih nan gawwana ya impahangona nan kayiw an mangdat hi itaguwan ya nan kayiw an mangdat hi abalinan an mamilih nan pohdon hi aton an ta'on on adi miyunnudan hinan pohdon Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ya i diyen garden hi ad Eden ya wada han wangwang an hidiyey mananum hinadan nitanom hidi. Ya hidiyen wangwang ya nagodwagodwa ta nun'opat di wangwang. ");
INSERT INTO ifa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hay ngadan nan oha ya hi Pison an nangi'wa hi ad Habilah an awadan di balitu'. ");
INSERT INTO ifa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ya nadan balitu' hidi ya dadiye nan namahmah di abalitu'na. Ya wada bohdiy umat hi dellium ya oniks. ");
INSERT INTO ifa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya na'en mi'adwan wangwang ya nungngadan hi Gihon an nangi'wa hi ad Kus. ");
INSERT INTO ifa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ya nan mi'atlun wangwang ya nungngadan hi Tigris an nangi'wa hi ad Assyria hi nangappit hi tuluwan di algo. Ya nan mi'apat ya nan wangwang an nungngadan hi Euprates. ");
INSERT INTO ifa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ta e inha''ad Apu Dios hidiyen lala'i hidih nan garden hi ad Eden ta wan hiyay mumpapto' hidi. ");
INSERT INTO ifa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ot alyona i hiyay, Mabalin an anom nadan bungbunga''an ");
INSERT INTO ifa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","an ammuna nan oha an adim anon di bungana. Te hidiye nan mangdat hi abalinan an mamilih nan pohdon an aton an ta'on on adi miyunnudan hinan pohdo' an Dios. Ot ipidwan Apu Dios an alyon i hiyay, Adi mabalin hi anon nan bungan diyen ohan bungbunga\"an te anom'e ya umannung an mate'a i diyen olas. ");
INSERT INTO ifa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Indani ya alyon bon Apu Dios di, Adi maphod an mun'ohhah tuwen lala'i. Ot aga ta apyo' ha nipto' hi pun'adwana ta bumoddang i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ya nadan nat'onat'on an animal ya hamuti an limmun Apu Dios ya ena impatigo i diyen lala'i ta ngadanana dida. ");
INSERT INTO ifa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ya an naminda ya nginadanan diyen lala'i ta hiyay ninaynayun hi ngadanda. Mu ma''id i dadiye ha nipto' hi pun'adwana. ");
INSERT INTO ifa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ta hay inat mon Apu Dios ya impalo'nah diyen lala'i. Ta on na'allo'an ot to'dangonay ohah nan tungal hi taglangna ot ahina pun'umuton nan lamoh. ");
INSERT INTO ifa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ot apyonah diyen tungal i han babai ot iyenah nan lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ya alyon nan lala'i di, Anakkaya! Maphod ta ad uwani ya wada ha pun'adwa' i ha paddung'u. Te hay tungalna ya nalpuh adol'u ya ta'on on hay lamohna. Ot hay ngadana ya babai te nalpuh lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ta hiya nan mangahawa'e nan lala'i ya taynana nan a'ammodna ta e middum hinan ahawana ta ayda na'ohhan adol. ");
INSERT INTO ifa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ya dadiyen lala'i ya babai ya adida bumain an ta'on on aggeda nunlubung. ");
INSERT INTO ifa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","An namin nadan animal ya nadan udum an limmun Apu Dios ya nan ulog ahan han nahalatom. Te han hin'algo ya inalinah nan babai di, Undan immannung an ipagol Apu Dios di eyu panganan hinan kumpulnan bungbunga\"an hitun garden? ");
INSERT INTO ifa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ya alyon nan babai di, Mabalin anun anonmi nadan bungbunga''an hitun garden. ");
INSERT INTO ifa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","An ammuna nan bungbunga\"an hi gawwan tuwen garden hi mipagol. Te imbagan Apu Dios an adimi anon onu dapaon te atonmi'e ya mate ami. ");
INSERT INTO ifa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ya alyon nan ulog hinan babai di, Adi ayu aya mate. ");
INSERT INTO ifa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Manu'eh ipagol Apu Dios ya innilanan anonyu'e ya ay madiyat di matayu ta abalinanyu mo an mamili hi pohdonyun aton an ta'on on adina pohdon ta mabalin an mipaddung ayu mon hiya. ");
INSERT INTO ifa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ya nidngolan nan babai i diye an namama ten tinigona an mapmaphod hidiyen kayiw ya maphod hi anon nan bungana. Ya pinhodna bon luma'ing. Ta imme mo ot alana dohah nan bungan diyen kayiw ot anona ot idatna doha i ahawana ta inana damdama. ");
INSERT INTO ifa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ta on hiyah inanda ya immannung peman an ay mohpe nadiyat di matada te immutalngandan aggeda nunlubung. Ta nundada''itonda nadan tubun di kayiw ot hiyay ilubungda. ");
INSERT INTO ifa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ya hidin tuwen malimuh nan algo ya dingngoldan wadah Apu Dios an mundaldallanan hinan way awadanda. Ya mamtikdan eda mun'ipa''eh nan way nakayiwan. ");
INSERT INTO ifa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mu pungkalyan Apu Dios nan lala'in alyonay, On daan'a? ");
INSERT INTO ifa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ya alyon nan lala'i di, Dingngol'un mangali'ahtu ya timmakuta' ta hiya nan eya' nipa''e te aggeya' nunlubung. ");
INSERT INTO ifa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ya alyon Apu Dios di, Nganney nangalin he''ah agge'a nunlubung? Undan inanmu tuwali nan bungan di kayiw an impagol'uh anonyu? ");
INSERT INTO ifa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ya alyon nan lala'i di, Tun babain indatmun pun'adwa' di nangdat i ha''on ot ano'. ");
INSERT INTO ifa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ya alyon Apu Dios hinan babai di, Tanganu on waha athinah inatmu? Ya alyon nan babai di, Binaliyana' othadih nan ulog ot ano'. ");
INSERT INTO ifa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ya alyon Apu Dios hinan ulog di, Gapu i naen inatmu ya nunhiglay em punholholtapan mu nadan udum an limmu' an animal ta mihipun hi ad uwani ya ibuluhmuy pangem. Ya atbohdi an hay hupu' di itanudmu ta ingganah atayam. ");
INSERT INTO ifa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ya pumbuhhulon da'yun duwah nan babai. Ya atbohdin mumbuhulda nan holagmu ya nan holagna. Ta nan holagna ya gumi'onay ulum an ta'on onmu hugatan di hukina. ");
INSERT INTO ifa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ot alyona boh nan babai di, He''a'e ya udma' di punligatam hinan em punholagan ta nunhiglay ligatmu on ahi'a nun'ayyam. Mu hiya damdaman nanongnay naminhodmun ahawam an ta'on on athidiy punligatam hinan pun'ayyamam. Ya hiyay ibilangmuh ap'apum. ");
INSERT INTO ifa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ya inalin Apu Dios hinan lala'i di, Ta'on on he''a ya dusaon da'a te inunudmu nan inalin ahawam ta inanmu nan bungan di kayiw an ipagol'u. Ot gapu i naen inatmu ya mumbalin tun lutah adi maphod. Ta ma''able'an tumamutamu ya ahi mabalin hi waday itanudyu. ");
INSERT INTO ifa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ya dakol boy humangoh pagat ya holo' mu hay anonyu ya nadan mitanom hinan puntanomanyu. ");
INSERT INTO ifa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ta gahin on'a lumingngotan an manamutamuh tun luta ya ahi waha bungan di itanommuh anonyu ta inggana hi mumbangngad'ah tun luta an nalpuwam. Te pito' di na'alaam ta hiya nan pito' bo damdamay pumbangngadam. ");
INSERT INTO ifa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hay nungngadan Adam i ahawana ya hi Eba te hiyay hi inan di an namin an tataguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ot idat Apu Dios nan lubung an up'up di animal di niphod ta inlubung da Adam i ahawana. ");
INSERT INTO ifa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Alyon Apu Dios di, Nomnomnomon ta'u an nipaddung moy tagun dita'u te innilana mo nadan nipto' ya ta'on on nadan agge. Te onha gawayona dohah nan bungan nan bungbunga\"an an mangdat hi itaguwan hi munnananong ya inana ot undan adi damdama mi'taguh munnananong? ");
INSERT INTO ifa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ta hiya nan impa'aan mon Apu Dios dida i diyen garden hi ad Eden. Ta eda mo nuntamuh nan lutan na'alaanda damdama. ");
INSERT INTO ifa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ot paguwalyan Apu Dios hinadan kerubim nan awon hi nangappit hi tuluwan di algo an umehdih nan garden hi ad Eden. Ot ihawana bohdi han mundalang an ispada an munhinnigi ta ma''id ha mabalin hi umeh awadan nan bungbunga\"an an mangdat hi itaguwan. ");
INSERT INTO ifa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Indani ya inilo' Adam hi ahawana ot mumbutyug ta nawada han lala'in imbabaleda. Ya alyon Eba di, Maphod ta gapuh boddang Apu Dios ya wadah tuwen imbabalemi. Ot ngadanana ta hi Cain. ");
INSERT INTO ifa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ya indani ya nawada bo han ni'odwang an lala'i ot ngadanana ta hi Abel. Hiya ya numbalin hi mumpastol hi kalnero ya hi Cain e ya e muntantannom. ");
INSERT INTO ifa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Indani ya namaaggot alan Cain dohah nadan intanomna ot ena idawat i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mu hi Abel ya hay inyena ya nan ap'aphodan an hopap di imbabalen nan kalnerona. Ya ma\"amlong hi Apu Dios i diyen indawat Abel i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mu aggena inabulut nan indawat Cain ta hiya nan nangimbubbungot hi Cain ta naluman di angahna ta atatakut. ");
INSERT INTO ifa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ot alyon Apu Dios i Cain di, Tanganu on'a bumungot ta adi maphod di angahmu? ");
INSERT INTO ifa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Onha nipto' di punnomnommu ot undan nganney adi' pangabulutan i he''a. Mu agge'e tuwali nipto' di atom ya paddungnay wah nan pantom hi Satanas an bota'on da'a ta hiyay ukod i he''a. Te pohdonan bumahubahul'a mu mahapul an du'gom nan pumbahulan. ");
INSERT INTO ifa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ta han hin'algo ya alyon Cain i Abel di, Umetandi anuh nan way natanoman. Ot umeda. Ta onda wahdih nan way natanoman ot patayon Cain hi ibbanan hi Abel. ");
INSERT INTO ifa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Indani ya himmapit hi Apu Dios i Cain an alyonay, Tanganu on daan hi ibbam an hi Abel? Ya alyonay, Ay towan. Ona' dan e mitnumitnud i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ot alyon Apu Dios i hiyay, Tanganu mahan onmu inathidi nan ibam? Umman paddungnay mungkali attog nan dalan nan ibam hinan luta i ha\"on ta iballoh'u. ");
INSERT INTO ifa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ot gapu i naen inatmu ya nunhiglay pundusa' i he''a ta adi mo mabalin an muntanom'ah tun luta te initmognay dalan ibbam hidin namatayam i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ta ta'on hi nganney itanommu ya adi tumagu te paddungnay din'ug da'ah tun luta. Ya atbohdin ma''id ha nadutu' hi em punhituwan ta on'a e humanawhawwangan. ");
INSERT INTO ifa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ya alyon Cain i Apu Dios di, Nunhigla bo aya nayya an adi' abalinan hinaen pundusam i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ngalngalam bahan ona' pa'aanon hitun puntanoma' ta midawwiya' i he''a. Ta namaag ya eya' humanawhawwangan hitun luta ta kumpulna moy mangakhup i ha''on ya patayona'. ");
INSERT INTO ifa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mu alyon Apu Dios di, Ma''id ha mamaten he''a te patayon da'a'e ya nunhiglay pangiballoh'u te mumpipituy ato' an mangiyawit i he\"a. Ot sinyalan Apu Dios hi Cain ta pangimatunan di kumpulnan mangakhup i hiya ta adida patayon. ");
INSERT INTO ifa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ot taynan Cain moh Apu Dios. Ot e munhituh ad Nod an nangappit hi tuluwan di algo hi'onta wah ad Eden. ");
INSERT INTO ifa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nangahawah Cain ta numbutyug nan ahawana ot mun'ayyam i han lala'i ot ngadananda ta hi Enok. Ot ibangon Cain hidiyen boble an eda nunhituwan ot ingadana i diyen boble nan ngadan nan imbabalena an hi Enok. ");
INSERT INTO ifa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ta nuntanud hi Enok ta hi Irad. Ot muntanud hi Irad ta hi Mehujael. Ot muntanud hi Mehujael ta hi Metusael. Ot muntanud hi Metusael ta hi Lamek. ");
INSERT INTO ifa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Hi Lamek ya duway inahawana an da Adah i Sillah. ");
INSERT INTO ifa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ta numbutyug hi Adah ot mun'ayyam ot ngadananda ta hi Jabal an hiyay hi apun nadan mumpumpastol an e umanal'allung. ");
INSERT INTO ifa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ot mawada boh ibbana an hi Jubal an hiyay nalpuwan nadan nanginnilan mangipagangoh harp ya ungngiyung. ");
INSERT INTO ifa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ya hi Sillah ya inyayyamnah Tubal-Cain an numbalin hi mun'udih. Ot ahi bo mawada nan babai an hi Naamah an hi ibban Tubal-Cain. ");
INSERT INTO ifa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ya indani ya alyon Lamek hinadan ahawanay, Da'yu Adah i Sillah ya donglonyu tun alyo'. Te ha\"on ya pinate' han lala'in nunhugat i ha\"on. Ya patayo' bo nan ta'on on mangilog an lala'i an munggundil i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ot hi'on pituy awit din hi apun hi Cain ya ha\"on'e ya napitu ta han pitu (77). ");
INSERT INTO ifa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Alina boh on nawada nan lala'in imbabalen da Adam i Eba. Ya alyon Eba di, Maphod ta waday indat bon Apu Dios an nihukkat i Abel an pinaten Cain. Ot ngadanana ta hi Set. ");
INSERT INTO ifa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ta kimmilog hi Set ta nawada han lala'in imbabalena an nginadananda ta hi Enos. Ta i diye mohpey nangihipunan nadan tatagu an mundayaw i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hiya datuwey tinanudan Adam. Hidin limmun Apu Dios di tagu ya impaddungna dida hi a'atna. ");
INSERT INTO ifa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ta limmunay lala'i ya babai ot wagahana dida ot ngadanana didah tagu. ");
INSERT INTO ifa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ta hidin hinggahut ta tulumpuluy (130) tawon Adam ya nuntanud i han nipaddung i hiya ot ngadanana ta hi Set. ");
INSERT INTO ifa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ya hidin niyayyam hi Set ya ni'tagu damdamah Adam hi waluy gahut (800) di tawon ta nawadaday udum an imbabalena an linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ta hay ngammut di tawonah din natayana ya hiyam di gahut ta han tulumpulu (930). ");
INSERT INTO ifa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ya hi Set ya hinggahut ta limay (105) tawona ot ahi mawada nan imbabalena an hi Enos. ");
INSERT INTO ifa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ot mi'tagu boh waluy gahut ta han pituy (807) tawon ta nawadada boy udum hi imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ta nuntawon hi hiyam di gahut ta han himpulut duwa (912) ot ahi mate. ");
INSERT INTO ifa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ya hi Enos ya nahiyam (90) di tawona ot ahi mawada nan imbabalena an hi Kenan. ");
INSERT INTO ifa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ot mi'tagu bo hi waluy gahut ta han himpulut limay (815) tawon ta nawadaday udum hi imbabalena ");
INSERT INTO ifa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ot ahi mateh din hiyam di gahut ta limay (905) tawona. ");
INSERT INTO ifa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Hi Kenan e ya napituy (70) tawona hidin nawada nan imbabalena an hi Mahalalel. ");
INSERT INTO ifa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ot mi'tagu boh waluy gahut ta han napat (840) di tawon ta nawadaday udum hi imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ot ahi mateh din hiyam di gahut ta han himpuluy (910) tawona. ");
INSERT INTO ifa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ya hi Mahalalel ya nanom ta limay (65) tawona ot ahi mawada nan imbabalena an hi Jared. ");
INSERT INTO ifa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ot mi'tagu boh waluy gahut ta han tulumpuluy (830) tawon ta nawadaday udum hi imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ta hay ngammut di tawona ot ahi mate ya waluy gahut ta han nahiyam ta lima (895). ");
INSERT INTO ifa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hi Jared ya hinggahut ta han nanom ta duway (162) tawona ot ahi mawada nan imbabalenan hi Enok. ");
INSERT INTO ifa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ot mi'tagu boh waluy gahut (800) di tawon ta nawadaday udum an imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ta hay ngammut di tawona ot ahi mate ya hiyam di gahut ta han nanom ta duwa (962). ");
INSERT INTO ifa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hi Enok e ya nanom ta limay (65) tawona hi nawadaan nan imbabalenan hi Metuselah. ");
INSERT INTO ifa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ot mi'tagu boh tuluy gahut (300) di tawon an hi Apu Dios di inun'unudna ya nawadaday udum hi imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ta hay ngammut di tawona ya tuluy gahut ta han nanom ta lima (365). ");
INSERT INTO ifa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ya innaynayun Enok an inun'unud hi Apu Dios ta ingganaot pamaag ya nama\"id. Te inawit Apu Dios hi awadana an ta'on on agge nate. ");
INSERT INTO ifa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ya hi Metuselah ya hinggahut ta han nawalut pituy (187) tawona ot ahi mawada nan imbabalenan hi Lamek. ");
INSERT INTO ifa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ot mi'tagu boh pituy gahut ta han nawalut duway (782) tawon ta nawadaday udum hi imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ta hay ngammut di tawona ot ahi mate ya hiyam di gahut ta han nanom ta hiyam (969). ");
INSERT INTO ifa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ya hi Lamek ya hinggahut ta han nawalut duway (182) tawona ot ahi mawada han lala'in imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ot ngadanana ta hi Noah te alyonay, Maphod ta wadah tuwen unga an mangipa'am'amlong i dita'u an ta'on on ta'u ma'aliggatan hitun puntamuwan ta'uh tun lutan numbalinon Apu Dios hi adi maphod. ");
INSERT INTO ifa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ot mi'itagu boh Lamek hi limay gahut ta han nahiyam ta limay (595) tawon ta nawadaday udum hi i'imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ta hay ngammut di tawona ot ahi mate ya pituy gahut ta han napitut pitu (777). ");
INSERT INTO ifa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Hi Noah e ya nuntawon hi limay gahut (500) ot ahi mawada nan tulun linala'in imbabalena an hi Sem ya hi Ham ya hi Japet. ");
INSERT INTO ifa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Hidi mon dumakolday tatagu ta mun'ipongdah tun luta ya nawadada boy mumpangilog an binabain i'imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ta hidin tinigon nadan wadah ad abunyan an a'apgohanda ya immalida ot ahawaonda nadan pinhodda. ");
INSERT INTO ifa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ta inalin Apu Dios di, Nan Espiritu' ya adi mabalin an minaynayun an middum i dida te waday apogpogan di adolda. Ta hiya nan mi'taguda mo hi inggana hi hinggahut ta baintiy (120) tawon ya abuh. ");
INSERT INTO ifa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ya wadaday o\"ongal di ataguda an holag nadan binabain ni'yahawah nadan nalpuh ad abunyan. Ya ongal di abalinandah tun luta ta diday madmadngol hidin nadne. ");
INSERT INTO ifa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ya lo'tat ya inyal'allan nadan tatagun mangmangngat hinadan dakol an pumbahulan. Te hay mun'onan hi nomnomda ya nan eda pangatan hinadan adi maphod. ");
INSERT INTO ifa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ta mahkit hi nomnom Apu Dios an gapu i datuwen a'at nadan tatagu. Ta ma'atuttuyuh ena nunlumuwan hi tagu. ");
INSERT INTO ifa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ot alyon Apu Dios di, On'uot dadagon an namin di tagu an limmu' ya ta'on on nadan hamuti ya nadan animal te ma'atuttuyuwa' hi e' nunlumuwan i dida. ");
INSERT INTO ifa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mu hi Noah ya maphod di pangatnan tagu ta mun'am'amlong hi Apu Dios i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hituwey na'at i Noah. Hi Noah ya maphod an tagu te hiya han nipto' di at'atona i diyen timpu te hi Apu Dios di inun'unudna. ");
INSERT INTO ifa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ya hay linala'ih imbabalena ya hi Sem ya hi Ham ya hi Japet. ");
INSERT INTO ifa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mu nadan udum an tataguh tun luta ya adi maphod di at'atonda an pumanapatteda. ");
INSERT INTO ifa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ta tinigon Apu Dios an ningamut an adi maphod di at'atonda te nunhiglay pangatdah nadan ibbadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ta hiya nan alyon Apu Dios i Noah di, Nomnomnomonyu an dadago' tun luta ta wan madadag an namin di tatagu te nunhiglan adi maphod di at'atonda an namaag onda pumanapatte. ");
INSERT INTO ifa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ot iphodmu ha papol an hanan mun'agangah an kayiw di usalom. Ya binoldabolda'muy dallomna ya iniphodmun inoddahan nadan dingdingna ya ta'on on hi dallomna. ");
INSERT INTO ifa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ot inayun Apu Dios an alyon di, Hay lukudna ya opat di gahut ta han nabongley (450) umpiy dinukkena ya napitut limay (75) umpi di binillogna. Ya hay tinagena ya napat ta limay (45) umpi. ");
INSERT INTO ifa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ya inatopam mu tigom ta mati'a'an hi ohay umpi ta han godwa. Ya pinantowam hi way bini\"ingna. Ya nuntuluwom di gladuna. ");
INSERT INTO ifa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nomnomnomom an lobngo' tun luta ta madadagdan namin di wah tun luta. Ta an namin nadan mataguh tun luta ya mate. ");
INSERT INTO ifa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mu ibaga' i he''a an da'yun hina'amma ya ta'on on nadan ahawayu an hunggop ituwen papol ya mihwang ayu. ");
INSERT INTO ifa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ot mahapul an pi'ipaghopyuh nan papol di hinohhay palis an animal ya nadan udum an matagu ta middumda i da'yun matagu. ");
INSERT INTO ifa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ta ipaghopyuy hinohhay palis hinadan nat'onat'on an hamuti ya animal ya ta'on on nadan nat'onat'on an limmu' an Dios an umat hinadan mungkaddapan hinan luta ta middumda i da'yun matagu. ");
INSERT INTO ifa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ya impaghopyu bo nadan mabalin an anonyu ya anon danaen nat'onat'on an impaghopyuh nan papol. ");
INSERT INTO ifa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ta an namin dadiyen imbagan Apu Dios ya inat Noah. ");
INSERT INTO ifa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hidin nadatngan di hunggopan da Noah hinan papol ya inalin Apu Dios i hiyay, Hunggop ayu mon hina'amma hinan papol te tinigo' an he''a ya abuh han nipto' di pangatna. ");
INSERT INTO ifa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ya impaghopyu boy himpipituy palis an tangbal ya tinna hinadan nat'onat'on an animal an ibilang'uh malinis ya atbohdin hinohhay palis hinadan adi' ibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ya atbohdin ipaghopyuy himpipituy palis hinadan nat'onat'on an hamuti ta wan minaynayun an waday nat'onat'on an matagun hamuti. ");
INSERT INTO ifa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Te mala\"uh di pituy algo ya ipali' di udan ta umuda'udan hi napat (40) di algo ya hilong ta wan madadagdan namin nadan limmu' hitun luta. ");
INSERT INTO ifa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ta inat Noah an namin nadan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ya hay tawona i diyen nalbongan tun luta ya onom di gahut (600). ");
INSERT INTO ifa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ta dida an hina'amma ya hinunggopdah nan papol ta mihwangda i diyen albongan tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ya atbohdin impaghopda nadan animal ya hamuti ya mungkaddapan an mibilang hi malinis ya ta'on on nadan adi ibilang Apu Dios hi malinis. ");
INSERT INTO ifa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ta hinohhay palis an tangbal ya tinna di impaghop da Noah hinan papol te hidiyey imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ta nala\"uh peman di pituy algoh hinunggopan da Noah ya inhipunan malbong tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ta hidin onom di gahut (600) di tawon Noah i diyen mi'ahimpulut pituy (17) algo i diyen mi'adwah bulan ya alinah on ay niguwang an namin nadan awon di liting an malpuh ad dalom ta namaag ya manuluy liting. Ya nunhiglay udan ta ay niguwang hi ad lagud. ");
INSERT INTO ifa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ot minaynayun hidiyen udan hi napat (40) di algo. ");
INSERT INTO ifa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mu hi Noah ya hi inayana ya nadan tulun imbabaleda an da Sem ya hi Ham ya hi Japet ya nadan ahawada ya hinunggopda mo tuwalih nan papol. ");
INSERT INTO ifa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ya atbohdin impaghopda nadan nat'onat'on an animal ya nadan mungkaddapan hinan luta ya nadan nat'onat'on an nun'apaya'an. ");
INSERT INTO ifa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ta hinohhay palis an tangbal ya tinna di impaghopdah nan papol. ");
INSERT INTO ifa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Te hidiyey imbagan Apu Dios hi aton Noah. Ta hidin hinunggopdan namin hinan papol ya ingkalob Apu Dios nan pantona. ");
INSERT INTO ifa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ta immudan nimpe hi napat (40) di algo ta mun'albong tun luta mu na'en papol ya timmapla'. ");
INSERT INTO ifa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ya lo'tat ya dimmallodallom nan liting mu na'en papol ya muntaptapla'. ");
INSERT INTO ifa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ta ta'on on nadan nun'atagen billid hitun luta on hininabna. ");
INSERT INTO ifa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ot la''uhan nan liting nadan uhhun dadiyen nun'atatagen billid. Ta hay dinallom nan liting hi ingganah nadan uhhun di billid ya baintiy (20) umpi. ");
INSERT INTO ifa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ta nun'altingdan namin di wadah tun luta an tatagu ya animal ya hamuti ya ta'on on nadan wah nan baybay. ");
INSERT INTO ifa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ta ma\"id ha ta'on on oha i ha agge ni'yate. ");
INSERT INTO ifa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ta athidin nadadag an namin di wadah tun luta. Ta ammuna da Noah an hina'amma ya nadan udum an wah nan papol an agge nadadag. ");
INSERT INTO ifa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ot munnanong an nalbong tun luta hi hinggahut ta nabongley (150) algo. ");
INSERT INTO ifa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hi Apu Dios ya aggena liniwwan da Noah ya an namin an wadah nan papol. Ta impatuyupna nan dibdib ta hiya nan nun'ul'ullen kimmittang nan liting. ");
INSERT INTO ifa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Te dimminong mo nadan manulu an liting an malpuh ad dalom ya ta'on on nan udan ya dimminong. ");
INSERT INTO ifa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ta nun'ul'ullen kimmittang nan liting hi hinggahut ta nabongley (150) algo. ");
INSERT INTO ifa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ya hidin mi'apulut pituy (17) algoh din mi'apituh bulan i diyen tawon ya niha'mo nan papol hinan billid hi ad Ararat. ");
INSERT INTO ifa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ya hidin nibaluy ohah din mi'apuluh (10) bulan ya mabalin mohpen matigoy uhhun nadan billid. ");
INSERT INTO ifa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ta on nala\"uh han napat (40) di algo ot iluwat Noah di ohah nan tawa ");
INSERT INTO ifa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ot ibu'anay ohan gayang. Ya hidiyen gayang ya e timmanaytayyapan ta ingganaot matdu' nan liting. ");
INSERT INTO ifa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ya imbu'an bon Noah han ohan palluma ta panginnilaanah on namaganan mo nan luta. ");
INSERT INTO ifa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mu ma\"id damdama ha e umpahan diyen palluma te hiyah diyen nalbong tun luta. Ot ibangngadnah nan papol ot paghopon Noah. ");
INSERT INTO ifa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ot haddonda boh pituy algo ot ahina bo ipatayap nan palluma. ");
INSERT INTO ifa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ya hidin mun'ahdom ya immamlongda te nibangngad nan palluma an himbatna han tubun di kayiw. Ta hidiyey nanginnilaan Noah an tuwen matdu' nan liting. ");
INSERT INTO ifa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ot ihodna boh pituy algo ot ahina ibu'an boh diyen palluma ya i diye mo ya agge numbangngad. ");
INSERT INTO ifa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ya i diyen mi'anom di gahut ta han ohay (601) tawon Noah i diyen namanguluh algo i diyen namanguluh bulan ot ibughulna nan papol ya maphod ta mun'amaganan mo tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ya hidin mi'abaintit pituy (27) algo hinan mi'adwah bulan ya namaganan mon namin tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ot alyon Apu Dios i Noah di, ");
INSERT INTO ifa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Mabalin mohpen lumah'un ayuh nan ahawam ya nadan imbabaleyu ya nadan ahawada. ");
INSERT INTO ifa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ya ta'on on nadan hamuti ya nadan animal ya nadan mungkaddapan hinan luta ta way atondan munholag ta mihinapdah nan luta. ");
INSERT INTO ifa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ot lumah'unda mo da Noah hinan ahawana ya nadan imbabaleda ya nadan ahawada hinan papol. ");
INSERT INTO ifa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ya atbohdin limmah'unda nadan animal ya hamuti ya nadan nat'onat'on an mungkaddapan hinan luta. ");
INSERT INTO ifa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ta onda limmah'un an namin ot apyon Noah han punggobhanda hi mi'nong i Apu Dios ot alanay hinohhah nadan nibilang hi malinis an animal ya hamuti ot i'nongna hi maghob an mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ya inabulut Apu Dios hidiyen ini'nongdan hiya. Ya alyon Apu Dios hi nomnomnay, Adi' mo ipidwan dadagon tun luta an gapuh a'at di tagu an ta'on on nihipun tuwalih a'ungana ya nan adi maphod di pohpohdonan aton. ");
INSERT INTO ifa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ot hiyah diyen wa'et minaynayun an adi madadag tun luta ya minaynayun bon waday timpun di puntanoman ya punggapasan di tatagu. Ya waday tiyalgo ya lowang ya kumog ya potang ya minaynayun an waday hilong ya mapatal. ");
INSERT INTO ifa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Winagahan Apu Dios hi Noah ya nadan imbabalenan alyonay, Hanat munholag ayu ta dumakol ayu ta boblayanyun namin tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ya an namin nadan animal ya hamuti ya nadan mungkaddapan hitun luta ya ta'on on nadan wah nan baybay ya da'yuy tumakutanda ta da'yuy ukod i dida. ");
INSERT INTO ifa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ya mabalin an ihdayu datuwe an umat hinadan indat'un da'yu an nitanom an munlangta. ");
INSERT INTO ifa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mu mahapul an adiyu anon nan dotag an nanongnan waday dalana te nan dala ya hiyay ataguwan. ");
INSERT INTO ifa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ot nan tagun patayonay ibbanan tagu ya mahapul bon mipapate. Ya ta'on on nan animal ya alina'e hi waha pinatenah tagu ya mahapul an mipapate damdama. ");
INSERT INTO ifa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Te ha\"on di nunlumuh tagu an nipaddung di a'atda i ha\"on. Ot nan tagun waday patayonah ibbanan tagu ya mahapul an patayon damdaman nadan ibbanan tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mu da'yu'e ya hanat munholag ayu ta dumakol ayu ta mihinap ayun mumbobleh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ya inalin bon Apu Dios i Noah ya nadan imbabalena di, ");
INSERT INTO ifa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Nomnomnomonyu an ipa'annung'u nan imbaga' i da'yu ya nadan tanudanyuh udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ya ipa'annung'u bo nan imbaga' hi ato' hinadan nabati an hamuti ya nadan animal ya nadan udum an niddum i da'yun limmah'un hinan papol. ");
INSERT INTO ifa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ot ibaga' i da'yu an adi' mo ipidwan lobngon tun luta ta adi ayu madadag an wah tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya hay pangimatunanyun immannung hituwen imbaga' hi ato' i da'yu ya an namin nadan tanudanyu ");
INSERT INTO ifa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ya nan tilag an pawadao' hi ad lagud. ");
INSERT INTO ifa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Te impahilong'u'eh ad lagud an gapuh nan bugut on wada bo nan tilag. ");
INSERT INTO ifa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ta hituwey mangipanomnom i ha\"on hinan imbaga' i da'yu ya hinadan nat'onat'on an limmu' an adi' mo ipidwan lobngon tun luta ta madadag an namin di wada. ");
INSERT INTO ifa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ta nipatigo'eh ad lagud nan tilag on ninomnom'u nimpe nan imbaga' i da'yu hi inggana an adi' mo ipidwan lobngon tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ta hiya nimpeh naey pangimatunanyun adi' dadagon di an namin an wahtun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nadan tulun imbabalen Noah an ni'ighop hinan papol ya da Sem ya hi Ham ya hi Japet. Hi Ham di ammod Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ya datuwen imbabalen Noah di nalpuwan di tataguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ya hay tamun amadan hi Noah ya muntantannom. Ta hiyay nangihipun an muntanom hi greyp. ");
INSERT INTO ifa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ta iniphodna nan bungan di greyp hi bayah. Ot inumona ot mabutong ot malo' hidih nan nuntoldaana an numbollad. ");
INSERT INTO ifa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ta hidin tinigon Ham an hi aman Kanaan ot ena ibagah nadan duwan i'ibana. ");
INSERT INTO ifa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ot ume da Sem i Japet ot eda ulohan an inhunoddan e nanguloh i hiya ta adida tigon hi amada an numbollad. ");
INSERT INTO ifa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Hidin na'aan di binutong Noah ya na'innilaana nan inat nan udidiyan an imbabalena ");
INSERT INTO ifa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ot alyonay, Nunhiglay adusaan Kanaan. Te mumbalin hi na'adda''ul an baal nadan i'ibana. ");
INSERT INTO ifa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ot alyona boy, Madayaw nan Dios an dayawon Sem. Mu hi Kanaan ya mumbalin hi baal Sem. ");
INSERT INTO ifa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ya hanat hi Apu Dios ya idatnay dakol an holag Japet ta mabalin an middumdah nan holag Sem. Mu hi Kanaan ya mumbalin hi baal damdaman Japet. ");
INSERT INTO ifa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ya ni'taguh Noah hi tuluy gahut ta han nabongley (350) tawon an nihipun hidin nalpah nan nalbongan tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ta hay tawona ot ahi mate ya hiyam di gahut ta han nabongle (950). ");
INSERT INTO ifa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Datuwey tinanudan nadan tulun linala'in imbabalen Noah an da Sem ya hi Ham ya hi Japet an dida nan nunholag hidin nalpah nan nalbongan tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ta hi Japet ya hay linala'ih imbabalena ya hi Gomer ya hi Magog ya hi Maday ya hi Jaban ya hi Tubal ya hi Mesek ya hi Tiras. ");
INSERT INTO ifa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ya hi Gomer ya hay linala'ih imbabalena ya hi Askenas ya hi Ripat ya hi Togarmah. ");
INSERT INTO ifa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ya hi Jaban e ya hay linala'ih imbabalena ya hi Elisah ya hi Tarsis ya hi Kittim ya hi Rodanim. ");
INSERT INTO ifa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ta datuwen tinanud Jepat ya dida nadan numpunhituh nadan nihaggon hinan baybay ya way ohaon nginadana nadan eda numpunhituwan an miyunnudan hinadan ngadanda mu agge numpapaddung di hapitda. ");
INSERT INTO ifa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hi Ham ya hay linala'ih imbabalena ya hi Kus ya hi Misraim ya hi Put ya hi Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ya hi Kus ya hay linala'ih imbabalena ya hi Seba ya hi Habilah ya hi Sabtah ya hi Raamah ya hi Sabteka. Ya hi Raamah ya hay linala'ih imbabalena ya da Seba i Dedan. ");
INSERT INTO ifa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ya wada boy oha an holag Kus an hi Nimrod an nundongol an ongal di abalinana an mi'gubat hi abobbobleh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ya nala'ing bo an e mun'anup te hi Apu Dios di bumodboddang i hiya. Ta hiya nan alyon di tatagu di, Hana ta umat'a i Nimrod an binoddangan Apu Dios ta ongal di abalinana an e manganup. ");
INSERT INTO ifa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ya hay hopapnah boble hi nun'ap'apuwan Nimrod ya hinadan boble hi ad Sinar an hi ad Babel ya hi ad Erek ya hi ad Akkad ya hi ad Kalneh. ");
INSERT INTO ifa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ot ahina ilagat dohah nadan bobleh ad Assyria. Ta immehdi ot iphodna hi ad Ninibeh ya hi ad Rehobot-Ir ya hi ad Kalah ");
INSERT INTO ifa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ya hi ad Resen an numbattanan di ad Ninibeh ya nan ongal an boble an hi ad Kalah. ");
INSERT INTO ifa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hi Misraim ya nuntanud ta nadan i Lud ya i Anam ya i Lehab ya i Naptuh ");
INSERT INTO ifa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ya i Patrus ya i Kaptor ya i Kasluh an nalpuwan nadan i Pilistia. ");
INSERT INTO ifa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ya hi Kanaan e ya hay imbabalena ya hi Sidon an panguluwan ya hi Hit ");
INSERT INTO ifa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ya hi Jebus ya hi Amor ya hi Girgas ");
INSERT INTO ifa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ya hi Hib ya hi Ark ya hi Sin ");
INSERT INTO ifa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ya hi Arbad ya hi Semar ya hi Hamat. Indani ya nipong datuwen tinanudan Kanaan hi abobboble ");
INSERT INTO ifa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","an nihipun hi ad Sidon ta ingganah ad Gera ya hi ad Gaza. Ot ipluyda boh nangappit hi ad Sodom ya hi ad Gomorah ya hi ad Admah ya hi ad Seboim ta ingganah ad Lasa. ");
INSERT INTO ifa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ta danae nadan tinanudan Ham an nun'ipongdah abobboble ya nat'onat'on di hapitda. ");
INSERT INTO ifa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Hi Sem an hiya nan namangpangullu mu hi Japet ya wadaday linala'ih imbabalena. Ya hiyay nalpuwan nadan tinanud Eber. ");
INSERT INTO ifa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ta hay linala'ih imbabalen Sem ya hi Elam ya hi Assur ya hi Arpaksad ya hi Lud ya hi Aram. ");
INSERT INTO ifa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ya hi Aram ya hay linala'ih imbabalena ya hi Us ya hi Hul ya hi Geter ya hi Mas. ");
INSERT INTO ifa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ya hi Arpaksad ya nuntanud ta hi Selah an nangimbabale i Eber. ");
INSERT INTO ifa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hi Eber ya duwaday linala'ih imbabalena. Nan oha ya nginadananda ta hi Peleg te hidin niyayyam ya nagodwa tun luta. Ya hi ibbana ya nginadananda ta hi Joktan. ");
INSERT INTO ifa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ya hi Joktan di hi aman da Almodad ya hi Selep ya hi Hasarmabet ya hi Jerah ");
INSERT INTO ifa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ya hi Hadoram ya hi Usal ya hi Diklah ");
INSERT INTO ifa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ya hi Obal ya hi Abimael ya hi Seba ");
INSERT INTO ifa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ya hi Opir ya hi Habilah ya hi Jobab. Ta datuwe nadan linala'in imbabalen Joktan. ");
INSERT INTO ifa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ya hay bobleh nunhituwanda ya nihipun hi ad Mesa ta ingganah ad Separ hinadan nun'abillid an boble hi nangappit hi tuluwan di algo. ");
INSERT INTO ifa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ta datuwe nadan tinanud Sem an nat'onat'on di pangiye''eda ya numboblayanda ya ta'on on hay hapitda. ");
INSERT INTO ifa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Mu an naminda ya nalpudah nan tinanud Noah. Te hidin nalpah din nalbongan tun luta ya ammuna nadan imbabalen Noah an nunholag ot ahida mawada tun tataguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hidin hopapna ya oha ya ammunay hapit di tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ya hidin mun'a'udmanda moy tagu ya nakakday udum ot umedah nangappit hi tuluwan di algo hi ad Sinar. Ta onda inakhupan hidi han nundotal ot mumbobledahdi. ");
INSERT INTO ifa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ya indani ya inhi'al nadan tatagun nunhituhdi ya alyonday, Aga'e ta iphod ta'un lutuwon tun pito' ya indadaan ta'u ha punlita ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ta on ta'uot ipappaphod hituwen boble ta mundongol ya ta adi ta'u mahihi\"an. Ya iniphod ta'u bo ha atagetageh binattun bale ta dumatong hi ad lagud. ");
INSERT INTO ifa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mu hidin immalih Apu Dios ya tinigonah diyen boble ya nan binattun bale an iphod nadan tatagu ");
INSERT INTO ifa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ya alyonay, Datuwen tatagu ya na'ohhada ya atbohdin ohay hapit di panapitda. At'ehtuy atondah ad uwani ya immannung an abalinanda bon aton di pinhoddan aton hi udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ta hiya nan eta'u ta e ta'u pumbalinon hi nat'onat'on di hapitda ta adida mun'i'innawatan. ");
INSERT INTO ifa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ta athidiy inat Apu Dios an nangiwakat i dida ta nun'ipongna dida hitun luta ta indinongda mon mangiphod hinan bobleda. ");
INSERT INTO ifa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ya hay ngadan diyen boble ya hi ad Babel te hidiy nanukkatan Apu Dios hi hapit nadan tatagu hi nat'onat'on an hapit ot iwakatna didah abobbobleh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hi Sem an imbabalen Noah ya datuwe nadan tinanudana. Hidin nala\"uh di duway tawon hi nalpahan di nalbongan tun luta an hinggahut (100) moy tawon Sem ya nawada nan imbabalena an hi Arpaksad. ");
INSERT INTO ifa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ta nihipun hi niyayyaman Arpaksad ya ni'tagu damdamah Sem hi limay gahut (500) di tawon ta nawadaday udum an imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ta kimmilog hi Arpaksad an nuntawon hi tulumpulut lima (35) ya nawada nan imbabalena an hi Selah. ");
INSERT INTO ifa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ot mi'tagu damdamah opat di gahut ta han tuluy (403) tawon ta nawadaday udum an imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ya hidin kimmilog hi Selah an tulumpuluy (30) tawona ya nawada nan imbabalena an hi Eber. ");
INSERT INTO ifa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ot mi'tagu boh Selah hi opat di gahut ta han tuluy (403) tawon ta nawadaday udum an imbabalenan linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ya hidin tulumpulut opat (34) di tawon Eber ya nawada nan imbabalenan hi Peleg. ");
INSERT INTO ifa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ya ni'tagu damdamah opat di gahut ta han tulumpuluy (430) tawon ta nawadaday udum an imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ya hidin tulumpuluy (30) tawon Peleg ya nawada nan imbabalena an hi Reu. ");
INSERT INTO ifa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ot mi'tagu damdamah duway gahut ta hiyam (209) di tawon ta nawadaday udum an imbabalenan linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ta on kimmilog hi Reu an tulumpulut duway (32) tawona ya nawadah Serug an imbabalena ");
INSERT INTO ifa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ot mi'tagu damdama boh duway gahut ta han pituy (207) tawon ta nawadaday udum an imbabalenan linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ya hidin tulumpuluy (30) tawon Serug ya nawada nan imbabalena an hi Nahor. ");
INSERT INTO ifa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ot mi'tagu boh duway gahut (200) di tawon ta nawadaday udum an i'imbabalenan linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ya hidin baintit hiyam (29) di tawon Nahor ya nawadah Terah an imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ot mi'tagu boh hinggahut ta han himpulut hiyam (119) di tawon ta nawadaday udum an imbabalenan linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ya hidin napituy (70) tawon Terah ya nawada nadan imbabalena an da Abram ya hi Nahor ya hi Haran. ");
INSERT INTO ifa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hiya datuwey tinanudan Terah an hi aman nimpen da Abram i Nahor ya hi Haran. Hi Haran ya nuntanud ta hi Lot. ");
INSERT INTO ifa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Mu nateh Haran hidin numbobleda ni' hi ad Ur hidih ad Babilon yaden matagu ni' hi amanan hi Terah. ");
INSERT INTO ifa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ya nangahawada mo bo da Abram i Nahor. Ta inahawan Nahor hi Milkah an imbabalen ibbanan hi Haran. Ya wada bo han ohan babain imbabalen Haran an hi Iskah. Ya hi Abram e ya inahawanah Sarai. ");
INSERT INTO ifa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mu hi Sarai ya adi mabalin an mun'imbabale. ");
INSERT INTO ifa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Indani ya uyugon Terah nan imbabalenan hi Abram ya nan inapuna an hi Sarai ya nan apapuna an hi Lot an imbabalen Haran ta taynandah ad Ur hidih ad Babilon. Ot ipluydah ad Kanaan. Mu hidin dimmatongdah ad Haran ot umohnongda ni' hidi. ");
INSERT INTO ifa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ot hidiy atayan Terah hidin duway gahut ta limay (205) tawona. ");
INSERT INTO ifa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Indani ya alyon Apu Dios i Abram di, Taynam nan numboblayanyun hina'amma ya nadan tulangmu ta ume'ah nan boblen ituddu' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ta idattan da'ah dakol an holagmu ta diday mundongol. Ya atbohdin wagahan da'a ta wan mundongol di ngadanmu ya he''a di lummuh awagahan di udum an tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ya wagaha' bo nadan tatagun munwagah i he''a. Mu nan mangidut i he''a ya nunhiglay pundusa' i dida. Ya gapun he''a ya wagaha' di atagutaguh abobbobleh tun luta. ");
INSERT INTO ifa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ot taynan mon Abram hi ad Haran hidin napitut limay (75) tawona an inunudna nan inalin Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ta in'uyugnah ahawanan hi Sarai ya nan amuna'onan hi Lot ya an namin nadan himbutda hi awadandah ad Haran ya an namin nadan nun'abalol an inamungdah awadandahdi hi ad Haran ya inodnanda ot ipluydah ad Kanaan. Ta onda dimmatong hi ad Kanaan ");
INSERT INTO ifa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ot inaynayunday eyeh ta inggana ot datnganda han kayiw hidih ad Moreh hidih ad Sekem an bobleh ad Kanaan. Ya i diye ya hay nunhitu i diyen boblen immayanda ya nadan tinanud Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ya numpatigoh Apu Dios i Abram ya alyonay, Hiyah tuwe nan boblen idat'uh nan holagmu. Ot iphod mon Abram hidi han punggobhan hi mi'nong hinan Dios an numpatigon hiya. ");
INSERT INTO ifa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ot inayundan umeh nadan nabillid an boble hi nangappit hi tuluwan di algo hi'onta wah ad Betel ot mun'allungdahdi. Hidiyen boble ya numbattanan di ad Betel ya hi ad Ai hidih ad Kanaan damdama. Ot iphodna bohdi han punggobhan hi mi'nong i Apu Dios ot hidiy pundayawandan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mu aggeda nunnanong hidi te onda e immaninnabat hi eda nun'allungan i diyen boble ot ipluydah nan negeb hidih ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Indani ya waday bitil hidih ad Kanaan ot ume da Abram hi ad Egypt ta hidiy eda ni' niha''adan. ");
INSERT INTO ifa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mu hidin adadatongdah ad Egypt ya alyon Abram i ahawanan hi Sarai di, Nomnomnomom an he''a ya apgohan'a. ");
INSERT INTO ifa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ot adi mibahhon tigon da'ah nadan i Egypt ya alyondah ahawa da'an ha''on. Ya patayona' ta ammuna'ah batiyonda. ");
INSERT INTO ifa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ot tigom bahan ta hay ibagam i dida ya he''ah ibba' ta adiya' patayon ya gapu i he\"a ya maphod di ipatigodan ha''on an adiya' patayon. ");
INSERT INTO ifa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ta hidin dimmatongdah ad Egypt ya tinigon tatawwan nadan i Egypt hi Sarai an immannung an apgohan. ");
INSERT INTO ifa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ya hidin tinigon nadan ap'apu an munhilbih nan patul ot eda ibagah nan patul di a'apgohna ot ipa'awit nan patul hi Sarai ot iyedah nan palasyu. ");
INSERT INTO ifa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ya gapun hiya ya mapmaphod di impatigon nan patul i Abram ta indattanah Abram hi kalnero ya baka ya dongki an tangbal ya tinna ya kemel ya himbutna an linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mu hi Apu Dios ya nundogohona nan patul ya nadan tatagun wahdih nan palasyuna an gapuh nangawitana i Sarai an ahawan Abram. ");
INSERT INTO ifa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ot ipa'ayag mon nan patul hi Abram ot alyonan hiyay, Tanganu on waha athinah nangatmun ha''on? Tanganu onmu inha''ut i ha\"on an hiya ya ahawam? ");
INSERT INTO ifa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta inalim an hi ibbam ta hiya nan ahawao\"ot. Awitom teeh ahawam ya imme ayu. ");
INSERT INTO ifa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ot ibagan nan patul hinadan tataguna ta pakakonda i diyen boble da Abram ya hi ahawana ya an namin nadan wadan dida. ");
INSERT INTO ifa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nakak da Abram an himbale hi ad Egypt ot mumbangngaddah nan negeb hi ad Kanaan an intakindan namin nadan wadan dida. Ya ni'yeh Lot i dida. ");
INSERT INTO ifa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ta kimmadangyan hi Abram te dakol di kalnerona ya guldingna ya bakana ya dakol boy balitu'na ya pihhuna. ");
INSERT INTO ifa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ta onda numbangngad hinan negeb ot eda umaninnabat hidih ad Kanaan an inipluydah ad Betel. Ot ibangngadda boh din immohnonganda ni' hidih nan numbattanan di ad Betel ya hi ad Ai. ");
INSERT INTO ifa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","An hidi din nangiphodanah nan punggobhan hi mi'nong ot dayawonah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Hi Lot ya wada damdamay pamilyana ya atbohdin wadaday kalnerona ya guldingna ya bakana ya himbutna. ");
INSERT INTO ifa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ta lo'tat ya adi umdah nan pumpastolanda te nahlag nadan halundan duwa. ");
INSERT INTO ifa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ta hiyay lummuh punhahannuwan nadan pumpastolon da Lot i Abram. Ya i diyen timpu ya nunhitudahdi damdama nadan tinanud Kanaan ya nadan tinanud Peris. ");
INSERT INTO ifa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ot alyon mon Abram i Lot di, Adi maphod on wa'e on mun'a''awit nadan pumpastolonta te hin'amata. ");
INSERT INTO ifa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Udu'dulna attog onta munhi\"an. Ot pot'om di pohdom hi eyu iha''adan ta ipluymu'eh nangappit hi winawwan ya inipluymi piboh nangappit hi iniggid. ");
INSERT INTO ifa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ot pa'al'alintataon Lot di matanah nunlini''odan ya minangmangna nan dapayah an boblen nihaggon hinan wangwang an nungngadan hi Jordan ta ingganah ad Soar. Ya ma''aphod te dakol di liting hidi an umat hidin e nangiha''adan Apu Dios hinan hopap di tagu ya umat boh nan bobleh ad Egypt. Hidiyen timpu ya agge ni' dinadag Apu Dios hi ad Sodom ya hi ad Gomorah. ");
INSERT INTO ifa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ta pinilin Lot nan luta an nundotal hinan way wangwang an nungngadan hi Jordan ot ipluyda mohdi hi nangappit hi tuluwan di algo. Ta nunhi\"andan hin'ama. ");
INSERT INTO ifa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ta da Abram ya nabatidah ad Kanaan yaden e ni'iboble da Lot hinan way nundotal an boble an nihaggon hi ad Sodom. ");
INSERT INTO ifa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mu nadan tataguhdi ya adi maphod di at'atonda ta nunhiglay bahulda i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Hidin nalpah an imme da Lot ya alyon Apu Dios i Abram di, Agam pibo ta mangmangom di nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Te an namin hituwen luta ya idat'un he''a ta pumboblayan nadan holagmuh inggana. ");
INSERT INTO ifa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Te pumbalino' nan holagmuh dakkodakkol an umat hi dinakol nan hupu' hitun luta an adi mabilang. ");
INSERT INTO ifa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ot eka ta em tigon hituwen luta an idat'un he''a. ");
INSERT INTO ifa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ot iyaldan mon da Abram nan allungda hinan nihaggon hinan oak an kayiw hi ad Mamre hidih ad Hebron ot apyon da Abram hidi han punggobhan hi mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Indani ya waday gubat te nan patul hi ad Sinar an hi Amrapel ya nan patul hi ad Ellasar an hi Aryok ya nan patul hi ad Elam an hi Kedorlaomer ya nan patul hi ad Goim an hi Tidal ");
INSERT INTO ifa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ya eda gubaton nan patul hi ad Sodom an hi Bera ya nan patul hi ad Gomorah an hi Birsa ya nan patul hi ad Admah an hi Sinab ya nan patul hi ad Seboim an hi Semeber ya nan patul hi ad Bera an hay ohah ngadana ya hi ad Soar. ");
INSERT INTO ifa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ta datuwen liman patul an eda gubaton ya mun'u'uddumda ta mumboboddangda te gubatonda dida hinan nundotal hi ad Siddim an nihaggon hinan nunhiglay ahinan lobong. ");
INSERT INTO ifa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Te nan patul an hi Kedorlaomer ya sinakupna datuwen liman patul hi himpulut duway (12) tawon. Mu hidin mi'apulut tuluh (13) tawon ya nginumhedan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ta hidin mi'apulut opat (14) di tawon ot i'uyug nan patul an hi Kedorlaomer nadan ibbanan patul ot eda gubaton dida ot abakonda nadan Repaet hi ad Asterot-Karnaim ya nadan tinanud Susim hi ad Ham ya nadan Emim hi ad Sabeh-Kiriatayim ");
INSERT INTO ifa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ya nadan tinanud Hor hinan nun'abillid hi ad Seir ta ingganah ad El-Paran an nihaggon hinan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ot ihunodda boh ad En-Mispat an hay ohah ngadana ya hi ad Kades ot abakondan namin nadan tinanud Amalek ya nadan tinanud Amor an nunhituh ad Hasason-Tamar. ");
INSERT INTO ifa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ta hidih ad Siddim di e nunhoodan nadan liman patul an nalpuh ad Sodom ya hi ad Gomorah ya hi ad Admah ya hi ad Seboim ya hi ad Bela ");
INSERT INTO ifa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ta gubatonda da Kedorlaomer an patul hi ad Elam ya hi Tidal an patul hi ad Goim ya hi Amrapel an patul hi ad Sinar ya hi Ariok an patul hi ad Ellasar. ");
INSERT INTO ifa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mu hidih nan nundadammuwandan punggugubatan ya dakol di bitu. Ta hidin eda bumtik nan duwan patul an i Sodom ya nan i Gomorah ya nabituda. Mu nadan tulun patul an ibbada ya binumtikdah nadan nabillid. ");
INSERT INTO ifa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ta nangabak nadan opat an patul ot eda pun'alan namin nadan wadah nadan i Sodom ya nadan i Gomorah an ta'on on nadan makan on nun'alada ot ahida taynan dadiyen boble. ");
INSERT INTO ifa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ya ta'on on da Lot an amuna'on Abram ya ni'yalada dida ya an namin nadan halunda ya nadan wadan dida te eda tuwali nunhituh ad Sodom. ");
INSERT INTO ifa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mu wada nan ohan binumtik ot ena ipa'innilah nan Hebrew an hi Abram hinan nun'allunganah nan nihaggon hi awadan nadan oak an kayiw an bagin Mamre an tinanud Amor. Hi Mamre ya i'ibana da Eskol i Aner an gagayyum Abram. ");
INSERT INTO ifa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ya hidin dingngol Abram hidiyen na'at ot ayaganan namin nadan tataguna an natudduwan an e mi'gubat an umedah tuluy gahut ta han himpulut walu (318). Ot makakda ta eda tundon nadan patul an nangiye''e i da Lot hi ad Dan. ");
INSERT INTO ifa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ta on nahdom i diye ot gogodwon Abram nadan tataguna ot eda gubaton dida. Ta numpudugda dida ta ingganah ad Hobah an nangappit hi muyyadna hi'onta wah ad Damaskus. ");
INSERT INTO ifa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ot bangngadon da Abram an namin nadan nun'abalol an inye''eda ot iyanamutda nan amuna'ona an hi Lot ya an namin nadan wadan dida ya ta'on on nadan binabai ya nadan udum an tatagun inibtikda. ");
INSERT INTO ifa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Hidin pumbangngadan da Abram hidin inabakda da Kedorlaomer ya nadan ibbanan patul ya imme nan patul hi ad Sodom ot ena damuwon didah ad Sabeh an hay ohah ngadana ya Nundotal an Lutan di Patul. ");
INSERT INTO ifa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ya ta'on on hi Melkisedek an patul hi ad Salem ya padin bon nan na'abbaktun Dios ya inyenan Abram di tinapay ya bayah. ");
INSERT INTO ifa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ot wagahanah Abram an alyonay, Hanat nan na'abbaktun Dios an nunlumuh ad lagud ya tun luta di munwagah i he\"a Abram. ");
INSERT INTO ifa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ot madayaw nan na'abbaktun Dios an nangihwang i he\"a ta nangabakon da'ah nadan binuhulmu. Ot idat Abram i Melkisedek nan mi'apuluh (10) nadan inabakdah eda ni'gubatan. ");
INSERT INTO ifa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Indani ya alyon nan patul hi ad Sodom i Abram di, Ta'omman ya ammuna nadan tatagu' di ipabangngadmu i ha\"on. Mu na'e an binangngadyun gina'umi ya ta'omman ya inalayu. ");
INSERT INTO ifa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mu alyon Abram di, Ha\"on'e ya imbaga' hinan na'abbaktun Dios an nunlumuh ad lagud ya tun luta ");
INSERT INTO ifa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","an adi mabalin hi ala' an ta'on on ha linubid onu ga'od di hapatutyu ta wan ma''id ha alyom hi udum hi algo hi impakadangyana' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ot ma''id ha ala' an ammuna nan inanmih tun tatagun in'uyug'u ya nadan idatmuh tun gagayyum'un bimmoddang i da'mi an da Aner ya hi Eskol ya hi Mamre. ");
INSERT INTO ifa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Indani ya waday impa'innilan Apu Dios i Abram an alyonay, Adi'a tumakut Abram te ha''on di paddungnay hapiyom ya atbohdin ongal di punwagah'un he''a. ");
INSERT INTO ifa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mu alyon Abram di, Apu Dios an na'abbaktu, undan nganne damdamay hilbin nan idatmun ha\"on an ma\"id ha imbabale'. Ammuna nan baal'un hi Elieser an i Damaskus di mamoltan hi an namin an wadan ha\"on ");
INSERT INTO ifa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","te undan adim tigon an ma\"id ha indatmuh imbabale' ta hiya nan hay oha moh nadan baal'uy pangipaboltana' hinadan wadan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ot alyon Apu Dios i hiya di, Bokon hinaen baalmun hi Elieser di mamoltan hinan wadan he''a te nan malpu i he\"a an imbabalem. ");
INSERT INTO ifa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ot ipalah'un Apu Dios hinan dola ot alyonan hiyay, Itangadmuh ad lagud ya binilangmu nadan bittuwon hi'on'a pa'abbilang. Ibaga' i he''a an athidiy dinakol di holagmu an adida mabilang. ");
INSERT INTO ifa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ya kinulug Abram hi Apu Dios ta hiya nan imbilang Apu Dios hiyah maphod an tagu. ");
INSERT INTO ifa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ya inalin bon Apu Dios i hiyay, Ha''on nan Dios an nangipakak i he''ah nan bobleh ad Ur hi ad Babilon ta wan idat'uh tuwen luta i he''a ta pumboblayanyu. ");
INSERT INTO ifa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mu alyon Abram di, He\"an na'abbaktun Dios, nganney panginnilaa' an idatmun ha''on hituwe? ");
INSERT INTO ifa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ya alyon Apu Dios di, Em alan ha baka ya ha tinna an gulding ya ha tangbal an kalnero hi hintutluy tawonda ya inyalim hitu. Ya ni'yalam ha ohah palluma ya ha balug. ");
INSERT INTO ifa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ot e alan Abram dadiyen namin an imbagan Apu Dios ot inayunan bongwahon dadiye ta numpunduwa on nunhiwwayona. Mu aggena inathidi nan palluma ya nan balug. ");
INSERT INTO ifa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ya indani ya natapanganday hamutin e mangan hinan dotag mu inabul Abram dida. ");
INSERT INTO ifa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ya hidin tuwen malimuh nan algo ya na'allo'an hi Abram. Ya nali'nana han atatakut ya nunhiglan munhihillong. ");
INSERT INTO ifa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ya alyon Apu Dios i hiyay, Hituwey innilaom an udum hi algo ya ume nadan holagmu i han nat'on an boble. Ya mumbalindah himbut hidih opat di gahut (400) di tawon an nunhiglay ipadildilahanda. ");
INSERT INTO ifa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mu ahi' dusaon nadan tatagu i diyen boble an numbalinandah himbut. Ta hay umudi ya makakda i diyen boble an pi'yaladay nun'abalol an odon nadan tataguhdi. ");
INSERT INTO ifa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mu he''a'e pibo ya ma'amamma'a ya ahi'a mate ta malinggop hi em atayan. ");
INSERT INTO ifa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ta ingganah nan mi'apat an tinanud ya ahida mumbangngad ituwen boble. Te damunahdi ya namamay pumbahbahulan nadan nunhitu ituwen boble an tinanud Amor ta hiya nan dusao' dida. ");
INSERT INTO ifa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Hidin nalimuh mo nan algo ta himmilong ya alinah on wada han banga an mun'ahuk ya han ma'adallang an apuy an ini'wanah nan numbattanan dadiyen nabongwah an animal. ");
INSERT INTO ifa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ya inhamad Apu Dios an nangibaga i Abram an alyonay, Hituwen luta an mihipun hinan pogpog di ad Egypt ta ingganah nan wangwang an nungngadan hi Euprates ya idat'uh nadan holagmu. ");
INSERT INTO ifa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ya idat'u bon dida nadan numboblayan nadan tinanud Ken ya tinanud Kenis ya tinanud Kadmon ");
INSERT INTO ifa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ya tinanud Hit ya tinanud Peris ya tinanud Repa ");
INSERT INTO ifa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ya tinanud Amor ya tinanud Girgas ya tinanud Jebus ya an namin nadan udum an numboblayan nadan tinanud Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hi Sarai an ahawan Abram ya adi mun'imbabale. Ot nan himbutnan hi Hagar an i Egypt ");
INSERT INTO ifa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","di ena ni'ilo'on i Abram an alyonay, Ma\"id tee damdama ha imbabaleta hi indat Apu Dios ot mabalin'e ya tun himbut di pi'ilo'am ta alina hi imbabalayam ya waha ha pun'imbabaleta. Ya inabulut Abram hidiyen inalin Sarai ta inilo'na. ");
INSERT INTO ifa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hay na'atan nae ya hidin nala''uh moy himpuluy (10) tawon hi e nunhituwan da Abram hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ya hidin inilo' Abram hi Hagar ya numbutyug. Ta hidin innilan Hagar an numbutyug ya mumbaktu an ongal di pamihulna i Sarai. ");
INSERT INTO ifa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ot alyon Sarai i Abram di, He''ay ud bahul hinan e pamihulan naen himbut i ha''on. Undan bokon ha''on di nangiyabulut hi pi'ilo'am i hiya. Mu tanganu on nihipun hidin na'innilaanan numbutyug ya pihulona'. Hanat hi Apu Dios di ukod an mangipanuh hi'on nganne i ditay nipto'. ");
INSERT INTO ifa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ya alyon Abram i hiyay, Nomnomnomom an he''ay ud himbut i hiya ot ukod'ah nan pohdom an aton i hiya. Ot palpaligaton mon Sarai hi Hagar ta lo'tat ya binumtik. ");
INSERT INTO ifa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ta inakhupan nan anghel Apu Dios i han bubun hidih nan agge naboblayan an mangipluy hi ad Sur. ");
INSERT INTO ifa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ot alyonan hiyay, Hagar an himbut Sarai, tanganu on'a nehna an danay nalpuwam ya idanay umayam? Ya alyonay, Bumtika' ta tayna' hi Sarai an ud himbut i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ot alyon nan anghel di, Ibangngadmuot i hiya ta nanongnan hiyay punhilbiyam. ");
INSERT INTO ifa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ot idat'uy dakkodakkol an holagmun adi mabilang. ");
INSERT INTO ifa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nomnomnomom an hinaen imbutyugmu ya lala'i ot miyayyam'e ya nginadanam ta hi Ismael. Te dingngol Apu Dios nan pumpahpahmo'am. ");
INSERT INTO ifa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mu hinaen imbabalem ya nunhigla an umat hinan atap an dongki an ma''id ha naputu' hi ena iha''adan. Ya ma''id ha adina ahiwawan hinadan tatagu ta hiya nan atbohdiy aton nadan tatagun hiya. Ya hay atona ya mihiwweh nadan tulangna ya a'ammodna. ");
INSERT INTO ifa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ta nihipun i diyen himmapitan nan anghel i hiya ya nginadananah Apu Dios hi, He\"a Nan Dios An Manmannigon Ha\"on. Te alyonay, Maphod ta ta'on on tinigo' hi Apu Dios ya nanongnan mataguwa'. ");
INSERT INTO ifa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ta hiya nan nangadanan hidiyen bubun hi Beer-Lahay-Roy. Ya nomnomnomonyu an hituwen bubun ya wadah nan numbattanan di ad Kades ya hi ad Bered. ");
INSERT INTO ifa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hidin nun'ayyam hi Hagar i han lala'in imbabaledan Abram ot ngadanan Abram ta hi Ismael. ");
INSERT INTO ifa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ya hay tawon Abram i diye ya nawalut onom (86). ");
INSERT INTO ifa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Hidin nahiyam ta hiyam (99) di tawon Abram ya numpatigo boh Apu Dios i hiya ot alyonay, Ha''on nan ongal di abalinanan Dios. Ot maphod on unudona' ya nanongnan nan nipto' di atom. ");
INSERT INTO ifa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Te pohdo' an ibaga i he\"a an mipa'annung nan imbaga' tuwali an idattan da'ah dakkodakkol an holagmu. ");
INSERT INTO ifa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ya hidin munhapihhapit hi Apu Dios ya nundu\"un hi Abram an inda\"omnay angahnah nan luta hi punlispituna i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ya alyon bon Apu Dios di, Nomnomnomom nan imbaga' i he\"a an mumbalin'a hi punhi'aman di dakol an mibangon an boble. ");
INSERT INTO ifa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ot mihipun hi ad uwani ya adi da'a mo ngadanan hi Abram ta he''ah Abraham. Te pumbalinon da'a nimpeh hi aman di dakol an mibangon an boble. ");
INSERT INTO ifa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ta punholagon da'ah dakkodakkol ta mumpatulday udum i dida hi dakol an boble. ");
INSERT INTO ifa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Hituwen imbaga' i he''a ya minaynayun an ma'at hinadan tanudam. Ta nanongnan ha''on an Dios di dayawom ya atbohdin ha''on di dayawon nadan tanudam. ");
INSERT INTO ifa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ya hituwen bobleh ad Kanaan an ni'iboblayam hi ad uwani ya idat'un namin i he''a ya hinadan holagmu ta da'yuy nanongnah mumboblehtu. Mu mahapul an ha\"on an Dios di dayawonyu ya nanongnah dayawon nadan holagmu. ");
INSERT INTO ifa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ot alyon bon Apu Dios i Abraham di, Mahapul an nanongnan un'unudom hituwen imbaga' i he\"a ya ta'on on nadan matanudam ya mahapul an hidiyey inaynayundan un'unudon. ");
INSERT INTO ifa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ot hay panginnilaan hi pangunudam ya ta'on on nadan tanudam ya mahapul an an namin nadan linala'i ya makugitda. ");
INSERT INTO ifa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ta mihipun hi ad uwani ya makugit ayu ta panginnilaan an un'unudonyu nadan imbaga'. ");
INSERT INTO ifa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ta an namin nadan tanudam an goggolang an linala'i ya makugitdah nan mi'awaluy algoda. Ya ta'on on nadan imbabalen nadan baalmu ya nadan himbutmun nalpuh udum hi boble ya makugitda. ");
INSERT INTO ifa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ta an namin nimpe nadan linala'i an wadah nan nunhituwam an ta'on on nadan baal onu himbut an ginattangmu ya mahapul an mipakugitda ta panginnilaan an minaynayun di pangun'unudanyu hinan imbaga' i he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ot nan lala'in agge nakugit ya mipapate ta adi mo midmiddum i da'yun tatagu' an gapuh aggena nangun'unudan hinan imbaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ya alyon bon Apu Dios i Abraham di, Nan ahawam an hi Sarai ya bokon mo Sarai di ngadana ta hi Sarah. ");
INSERT INTO ifa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Te wagaha' ta mun'imbabale ayu i han lala'i. Ya hiyay pumbalino' hi hi inan di dakkodakkol an tataguh abobboble ta mumbalindah patul di udum. ");
INSERT INTO ifa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ot mundu\"un boh Abraham an nida\"om di angahnah nan luta ta dayawonah Apu Dios. Mu adi mitpol di ngihilna te hay nomnomna ya alyonay, Undan nin mohpe mabalin an mun'imbabaleya' hi ad uwanin hinggahut (100) di tawon'u ya nahiyam (90) di tawon Sarah an namogpog mo. ");
INSERT INTO ifa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ot alyonan Apu Dios di, Daan mo ta hi Ismael di a'atan nan imbagam? ");
INSERT INTO ifa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ya alyon Apu Dios di, Adi te nan ahawam an hi Sarah ya mun'imbabale i han lala'i ta ngadananyu ta hi Isaac. Ta nadan tanudanay pangipa'annunga' hinan imbaga' i he\"a ta minaynayun an ma'at i dida. ");
INSERT INTO ifa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ya hi Ismael e ya dingngol'u nan imbagam ot nomnomnomom an wagaha' bo ta dumakkodakkol di holagna. Ta hiyay mumbalin hi punhi'aman di himpulut duwan (12) ap'apun di tatagu ya atbohdin mundongolda nadan tanudana. ");
INSERT INTO ifa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mu hay ipa'annungan nan imbaga' i he''a ya hinan imbabalem an hi Isaac an iyayyam nan ahawam an hi Sarah hinan athitu boh tawonana. ");
INSERT INTO ifa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ya hidin indappuh Apu Dios hidiyen inalina ot taynanah Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ta hidiyen algo ya inunud Abraham nan inalin Apu Dios ot kugitona nan imbabalenan hi Ismael ya an namin nadan linala'i an nunhituh nan nunhituwana ya nadan goggolang an imbabalen di baalna ya himbutna an ginattangna. ");
INSERT INTO ifa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ta'on on hiya an nahiyam ta hiyam (99) di tawona ya numpakugit. ");
INSERT INTO ifa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ya na'en imbabalenan hi Isma'el ya himpulut tuluy (13) tawona i diye. ");
INSERT INTO ifa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ta i diyen algo di numpakugitandan hin'ama ");
INSERT INTO ifa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ya niddumdan namin nadan linala'in baalna ya himbutna an ginattangnah udum hi boble. ");
INSERT INTO ifa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","I han tongan di algo an um'umbun hi Abraham hinan way panton nan nun'allunganda an nihaggon hinadan kayiw hidih ad Mamre ya numpatigoh Apu Dios i hiya ");
INSERT INTO ifa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ta nangitigana han tulun linala'in timma'dogdah nan way e''elena ot ena pundamu dida ot inayunan munyu''ung ta apngaona dida. ");
INSERT INTO ifa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ot alyonay, Apu mundagguh ayu bahan ta adiya' la''uhan an ohan baalyu. Te ongal di e' pun'am'amlongan hi eyu nangi'wan hitun nunhituwa'. ");
INSERT INTO ifa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ta mun'ible ayu ni' hitun pu''un tun kayiw ta e' alan ha liting ta pun'ulahyuh hukiyu ");
INSERT INTO ifa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ya ta damunah e' pangidadaanan i ha anonyu ta waha i'ilogyun madappuh hinan pangayanyu. Ya alyonday, Ta'omman ya hinnodmi. ");
INSERT INTO ifa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ot ma'anneh Abraham hinan nuntoldaanda ot alyonan Sarah di, Pun'iha''angmu dohah nan maphod an alina. ");
INSERT INTO ifa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ot ma'ibagan umeh nan awadan di halunda ot pot'ona nan ap'aphodan an kilaw an bakana ot ipaguyudnah nan baalna ta eda paltiyon ot iha''angda. ");
INSERT INTO ifa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ta on nidadaan ot alana nadan udum an mahapul an umat hi gatas ot pi'yenah nan dotag ya makan ot idadaana ta mangan nadan linala'in mangili hinan pu''un di kayiw. ");
INSERT INTO ifa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ya ibagadan hiyah ahawanan hi Sarah. Ot alyonay, Wahdih nan nuntoldaanmi. ");
INSERT INTO ifa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ya alyon nan ohay, Hitun pumbangngada' hinan athitu ya nomnomnomom an mun'ayyam hi ahawam an hi Sarah i han lala'i. Ya hi Sarah ya wahdih nan way panton di tolda ta dingngolnah diyen inalina. ");
INSERT INTO ifa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ya hi Abraham ya amamma mo ya atbohdin ininnah Sarah an namogpog. ");
INSERT INTO ifa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ta ngimmihil hi Sarah an alyonah nomnomnay, O man nee ihya ta namaag ya munggolanga' ya tee mon ininnaa' ya amamma moh ahawa'. ");
INSERT INTO ifa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ya alyon Apu Dios i Abraham di, Tanganu on ngimmihil hi Sarah an alyonay undan ininnaa' e anu mohpe ya ahiya' mun'imbabale? ");
INSERT INTO ifa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mu undan waha adi' abalinan an Dios. Ibaga' tee an hitun pumbangngada' an mala\"uh nimpe ha hiyam di bulan ya mun'ayyam hi ahawam an hi Sarah i han lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mu gapuh takut Sarah ya iha''utnay ngimmihilana. Mu alyon Apu Dios di, Immannung an ngimmihil'a. ");
INSERT INTO ifa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","On immat hidiy nunhapitanda ot makakda nan linala'i ot ibbaan Abraham didah nan ma'uhdungan hi ad Sodom. ");
INSERT INTO ifa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ya alyon Apu Dios hi nomnomnay, Adi' ipa''e i Abraham nan ninomnom'un aton. ");
INSERT INTO ifa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Te dumakol di tanudana ta mundongolda. Ya gapun hiya ya wagaha' di tataguh abobboble. ");
INSERT INTO ifa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Te hiyay pinto''u ta hiyay manugun hinadan holagna ta ha''on di un'unudonda ta nan nipto' ya maphod di atonda. Ta way ato' bon mangipa'annung i didah nan imbaga' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ot alyona i Abraham di, Nadan i Sodom ya i Gomorah ya dingngol'u nan nunhiglan at'atondan pumbahulan. ");
INSERT INTO ifa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ta hiya nan mahapul an umeya' hidi ta e' tigon hi'on immannung onu agge. ");
INSERT INTO ifa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ot inayun nadan linala'in ipluy hi ad Sodom yaden nabati hi Apu Dios an mi'haphappitan i Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ot alyon Abraham i hiyay, Undan ta'on on nadan nipto' di at'atondan tataguhdih ad Sodom ya pi'idadagmuh nadan adi maphod di pangatda? ");
INSERT INTO ifa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Onha ta wahdida ha nabongleh (50) tataguh nipto' di pangatda ya on hiya damdaman dadagom didan himpamoble onu adim an gapu i dadiyen nipto' di pangatda? ");
INSERT INTO ifa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","He''a ya nipto' di atom an mangipanuh hi tatagu ot hiya nan innila' an adi mabalin an pi'idadagmu nan nipto' di pangatda. Te atom'ehdi ya undan adida mi'idadag hinadan nun'abahulan. ");
INSERT INTO ifa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ya alyon Apu Dios di, Onha alinah wahdida ha ta'on on nabongleh (50) tatagu hi nipto' di pangatda ot gapu i dida ya adi' dadagon didan himpamoble. ");
INSERT INTO ifa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ya alyon bon Abraham i hiyay, Apu, iyabulutmu bahan ta ta'on ona' tagu ya ammuna an nalpuwa' hi hupu' ya idappuh'un ibagan he''a tun nomnomnomo'. ");
INSERT INTO ifa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ot onha ammunada ha napat ta lima (45) hi tataguhdi hi nipto' di pangatda ya on adim dadagon hidiyen boble? Ya alyon Apu Dios di, Hi'on wadada ha napat ta lima (45) hi nipto' di pangatda ot adi' dadagon didan himpamoble. ");
INSERT INTO ifa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ya alyon bon Abraham di, O mu onha ammunada ha napat (40) ya on dadagom? Ya alyon Apu Dios di, Adi' dadagon an ta'on on ammunada ha napat (40). ");
INSERT INTO ifa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ya alyon bon Abraham i hiyay, Adi'a bahan bumohol ta ibaga' an onha ammunada ha tulumpulu (30) ot nganney atom? Ya alyon Apu Dios di, Adi' dadagon dida hi'on wadada ha tulumpulu (30). ");
INSERT INTO ifa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ya alyon bon Abraham di, Apu, iyabulutmu bahan ta idappuh'un ibaga tun nomnomnomo' an onha ammunada ha bainti (20)? Ya alyonay, Adi' dadagon hidiyen boble hi'on wadada ha ta'on hi bainti (20). ");
INSERT INTO ifa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ya alyon bon Abraham di, Apu, hituwe mo di ma'udih ibaga' ot adi'a bahan bumohol. Onha ammunada ha himpulu (10) ya abuh ot nganney atom? Ya alyon Apu Dios di, Adi' dadagon hidiyen boble hi'on wahdida ha himpulu (10). ");
INSERT INTO ifa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ta on nalpah hidiyen nunhapitanda ot umaan hi Apu Dios hidi. Ot umanamut hi Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Hidin nahdom ya dimmatongda nan duwan anghel hi ad Sodom. Ya wahdih Lot an um'umbun hinan way geyt diyen boble. Ta ona tinigo dida ot e midamu ot mundu\"un an nida\"om di anganah nan luta ta apngaona dida ");
INSERT INTO ifa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ot alyonay, Ha''on di oha an baalyu ot ma'ayu ta ume ta'u bahan hi balemi ta eyu ulahan di hukiyu ya immiyan ayu. Ta nawi\"it'e ya ahi ayu madappuh hinan umayanyu. Mu alyonday, Adi ami mundagguh ta ta'on on hinan plasa di emi pun'iyanan. ");
INSERT INTO ifa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mu anhan di pun'ayag Lot ta ni'yeda moh baleda ot idadaanana didah makan an nunha\"angdah tinapay an agge nadduman hi yist ot manganda. ");
INSERT INTO ifa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mu hidin aggeda ni' e nalo' dadiyen mangili ya immedan namin nadan linala'in i Sodom an mumpangilog ya ta'on on nadan a'amamma. Ot li\"ubonday balen da Lot ");
INSERT INTO ifa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ot muntukukda i hiya an alyonday, Daanda nadan linala'in nun'iyanom? Ipalah'unmu dida ta ilo'mi dida. ");
INSERT INTO ifa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ya limmah'un hi Lot ot inayunan ikalob nan panto. ");
INSERT INTO ifa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ot alyonah nadan i Sodom di, I'iba, adiyu bahan aton di adi maphod i datuwen mangili. ");
INSERT INTO ifa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ta'on attog ya tun duwan binabain imbabale' an agge ni' nangahawa di ipalah'un'u ta ukod ayuh nan pohdonyun aton i dida. Mu ta bokon hantudan mangili' te mahapul an ipapto''u dida. ");
INSERT INTO ifa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mu alyonday, He\"a e an immalin ni'iboblehtu ya umaan'ahna ta adi da'mi itudduwan hi atonmi. Te alina man ya he\"ay nangiboholanmi ya namamay nangatmin he\"a. Ot adhuwandah Lot ot pun'ituldunda ta wan edaot pa''ihon nan panto. ");
INSERT INTO ifa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mu na'ibagon nan duwan mangilin ginuyud hi Lot hidih nan bale ot ikalobda. ");
INSERT INTO ifa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ot pumpilokda dadiyen i Sodom ta onda ahi anap'apu'ap an adida pa''apto' hinan panto. ");
INSERT INTO ifa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ya alyon nan duwan linala'i i Lot di, On wadaday udum hi imbabalem ya inapum ya tulangmun wahtu ituwen boble? Wadada'e ya em imbagan dida ta umaan ayuhtu ");
INSERT INTO ifa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","te dadagonmih tuwen boble. Te innilan Apu Dios an nunhiglan adi maphod di at'aton nadan tataguhtu ta hiya nan hinnag da'mi ta dadagonmi. ");
INSERT INTO ifa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ot umeh Lot ot ena ibagah nadan linala'in mangahawah nadan binabain imbabalena ot alyonan diday, Galaonyu ta makak ayu ta taynan ta'uh tuwen boble te dadagon anun Apu Dios. Mu namaag ya uggan itigon dadiyen linala'i i hiya te alyondah on laylayyahna. ");
INSERT INTO ifa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ta hidin hiyah mun'awiwi\"it ya pumbangon nan duwan anghel hi Lot an alyonday, Bumangon'a ya inawitmuh ahawam ya nadan duwan imbabalem ta adi ayu milagat hi adadagan tuwen boble. ");
INSERT INTO ifa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mu mun'og'ogon an makak hi Lot ot pun'idon mon nan duwan linala'ih ta'ledan hina'amma ot ipanguluda dida ta inggana hi nibata''andahdi i diyen boble. Ta athidiy inat Apu Dios i dida te gapuh homo'na i dida. ");
INSERT INTO ifa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ta onda nibata''an ot ahi alyon nan ohan anghel i diday, Ekayu mohpe ta awigingonyun bumtik. Ya adiyu wingiyon nan tinaynanyun boble ya adi ayu umohnong hinan nundotal ta ingganah on ayu dumatong hinan billid ta adi da'yu ilagat hinan apuy. ");
INSERT INTO ifa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mu alyon Lot i diday, Maphod ta himmo' da'mi ");
INSERT INTO ifa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ta nihwang amih ate. Mu bokon bahan hinan billid di alyonyuh bumtikanmi te adi' abalinan an bumtik hidi. Ya alinah nilagat amih nan awon ya ni'yate ami damdama. ");
INSERT INTO ifa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mabalin'e bahan ya hidih nan kittang an boblen nihaggon di bumtikanmi ta mihwang ami. ");
INSERT INTO ifa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ya alyon nan anghel di, Ta'omman mo ya hidiy immayanyu ta adi' pi'dadag hidiyen kittang an boble. ");
INSERT INTO ifa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ot awigingonyun bumtik hidi te gahin di dumatong ayuhdi ya ahi' ihipun nan ato'. Hidiyen boble ya nginadananda ta hi ad Soar. ");
INSERT INTO ifa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ta hidin dimmatong da Lot hidih ad Soar ya manulu nan algo. ");
INSERT INTO ifa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ya alinah on pun'ogah Apu Dios di mundalang an apuy hi ad Sodom ya hi ad Gomorah. ");
INSERT INTO ifa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ta nadadag an namin dadiyen boble ya nan nunlini''odan ya an namin nadan tatagun wahdi ya ta'on on nadan nun'itanom. ");
INSERT INTO ifa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mu nan ahawan Lot ya nunligguh ta alinah on numbalin hi ahin an kimmulhi ta ay pusti. ");
INSERT INTO ifa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ya hidin nawnawi\"it i diye ot mangeh Abraham hinan immohnongana ni' hi ni'happitanan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ot iyuhdungnah ad Sodom ya hi ad Gomorah ya hinan nunlini''odan dadiyen boble ya hay ahuk di matigohdi an ay hanan damunan pun'apuyan. ");
INSERT INTO ifa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mu i diyen nanadagan Apu Dios i dadiyen boble an e ni'iboblayan Lot ya ninomnomnah Abraham ta hiya nan inyabulutnan binumtik da Lot ta aggeda nilagat. ");
INSERT INTO ifa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Hi Lot ya nadan duwan binabain imbabalena ya tumakutdan miha''ad hi ad Soar ot umeda moh nan billid ot eda miha''ad i han liyang. ");
INSERT INTO ifa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ya han hin'algo ya alyon nan panguluwan i ibbana di, Hi amata ya amamma mo ya ma\"id ha udum hi lala'i hi mangiyahawan dita ta mawada ha imbabaleta. ");
INSERT INTO ifa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ot butongontah amata ta eta mi'lo' ta waday atontan mahlag ta adi mapogpog di holag ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ta i diyen hilong ya binutongdah amada ot e mi'ilo' nan panguluwan. Mu agge innilan amada te nabutong. ");
INSERT INTO ifa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ta nabigat ot alyon nan panguluwan i ibbana di, Din hilong ya eya' ni'ilo' i ama. Ot butongonta boh amata ta ilo'mu poo ta waday uddinnontan mahlag. ");
INSERT INTO ifa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ot butongonda boh amada i diyen hilong ot mi'ilo' damdama nan oha i amada. Mu agge bo innilan amada te nabutong. ");
INSERT INTO ifa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ta hituwey inat nadan duwan imbabalen Lot ot mawadaanda. ");
INSERT INTO ifa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ta hanan panguluwan an imbabalen Lot ya nun'imbabaleh lala'i ot ngadananah Moab. Ta hiyay nahlagan nadan i Moab hi ad uwani. ");
INSERT INTO ifa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ya hanan nihnod an imbabalen Lot ya nun'imbabale boh lala'i ot ngadananah Ben-Ammi. Ta hiyay nahlagan nadan i Ammon hi ad uwani. ");
INSERT INTO ifa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hi Abraham ya ninomnomnan mumbunag ta immedah nan way negeb hidih nan numbattanan di ad Kades ya hi ad Sur hidih ad Kanaan. Ot ahida bo umeh ad Gerar. ");
INSERT INTO ifa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ta hidiy nangalyan bon Abraham hi hi ibbanah ahawanan hi Sarah. Ta hiya nan hi Abimelek an patul hidi ya ena impa'awit hi Sarah. ");
INSERT INTO ifa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mu han nahdom ya numpa'inop hi Apu Dios i Abimelek ot alyonay, He''a ya mate'a te gapu i naen babain em impa'ala an waday ahawana. ");
INSERT INTO ifa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mu agge ni' ni'ilo' hi Abimelek i hiya ta hiya nan alyonay, Apu Dios, undan ta'on hi ma''id ha inat'un hiyah adi maphod ya on dadagona' an ilagatmu tun tatagu'? ");
INSERT INTO ifa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hinaen inat'u ya ma''id attog ha adi maphod hi ninomnom'u te alyon othadin Abraham di hi ibbana ya atbohdin hiya an alyonay hinagida. ");
INSERT INTO ifa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ya alyon Apu Dios i hiyay, Innila' an agge'a numbahul i nae ta hiya nan agge' inyabulut an ilo'mu hiya ta agge'a numbahul i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ot hiya nan mahapul an ibangngadmuh naen babaih nan ahawana te hidiyen ahawana ya propeta ta wan idasalan da'a i hiya ta adi'a mate. Te adim'e ya umannung an mate'a ya ta'on on nadan tatagum ya mi'yatedan he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ta on hiyah nawi\"it ot ipa'ayag Abimelek an namin nadan ap'apu an munhilbi i hiya ot ibaganan didah diyen ininopna ya nangintattakutda. ");
INSERT INTO ifa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ot ipa'ayagna boh Abraham ot alyonan hiyay, Nganneh tuwen inatmun da'mi? Undan waha bahul'un he''a hi lummuh em pangipadadagan i ha''on ya tun pun'ap'apuwa'? Adi maphod hinaen inatmun ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nganney ninomnommu ta athinay inatmu? ");
INSERT INTO ifa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ya alyon Abraham di, Manu'eh athinay inat'u ya alyo' on ma''id ha takutyu i Apu Dios ya alina hi ipapateya' ya pinlohyu tun ahawa'. ");
INSERT INTO ifa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ya hay oha ya immannung an ta'on hi ahawa' ya hinagi ami. Te ohay hi amami mu nat'on di hi inana. ");
INSERT INTO ifa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ta hiya nan nihipun hi nangalyan Apu Dios hi tayna' di boblen da ama ta umeya' hi udum an boble ot ibaga' i ahawa' ta an namin di bobleh datnganmi ya ibaganan hinagi ami ta hidiyey pangipatigonah homo'nan ha''on ta adiya' patayon. ");
INSERT INTO ifa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ot ibangngad mon Abimelek hi Sarah i Abraham ot idattanah kalnero ya baka ya baal an linala'i ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ot alyona bon Abraham di, An namin datuwen luta ya ha\"on di ud bagi ot pot'om nan pohdom an e iha''adan. ");
INSERT INTO ifa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ot alyonan Sarah di, Tigom teen idat'un ibbam di hinlibuy (1,000) gumo' an pihhu ta bayad nan inat'u ta panginnilaan ibbam ya nadan nun'ibbayu an ma''id ha inat'u i he\"a hi adi maphod. ");
INSERT INTO ifa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ot idasal mon Abraham i Apu Dios hi Abimelek ta na'aan nan dogohna. Ya atbohdin pinumhod hi ahawana ya an namin nadan binabain baalna ta mabalin an mun'imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Te impagol ni' Apu Dios di punggolangan nadan binabain wah balen Abimelek an gapuh nan na'at i Sarah an hi ahawan Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Hi Apu Dios ya impa'annungna nan imbaganan pammo'ana i Sarah ");
INSERT INTO ifa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ta numbutyug. Ya hidin nadatngan hidiyen inalin Apu Dios hi pun'ayyamana ya nun'ayyam i han lala'in imbabaledan Abraham hidin amamma mo. ");
INSERT INTO ifa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ot ngadanan Abraham ta hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ya hidin mi'awaluh algona ot kugiton Abraham te hiyah diyey imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ya hay tawon Abraham hidin niyayyam hi Isaac ya hinggahut (100). ");
INSERT INTO ifa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ya hi Sarah ya ma\"amlong an alyonay, Impa'amlonga' i Apu Dios ot an namin nadan mangngol ituwen nunggolanga' ya mi'yam'amlongdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Te ta'on hi nganneh diyen tagu ya inniladan adiya' mo mabalin an mun'imbabale. Mu ten ad uwani ya na'at ta inyayyam'uh tuwen lala'in imbabalemin Abraham hi ad uwani an amamma mo. ");
INSERT INTO ifa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ta hidin ong'ongngal hi Isaac an naphu mo i inana ya numpahamul hi Abraham ot ipa'ayagna nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Indani ya tinigon Sarah an amod on nganihngihilan Ismael an imbabalen Abraham hinan i Egypt an hi Hagar hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ot alyona i Abraham di, Ituda'mu nan babain himbut ya nan imbabalena te nan imbabalena ya ma\"id ha midat i hiya hinan boltanon tun imbabale' an hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ya adi maphod hi punnomnoman Abraham i diye te ta'on on hi Ismael ya imbabalena damdama. ");
INSERT INTO ifa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mu himmapit hi Apu Dios i Abraham ot alyonay, Adi'a minomnoman an gapuh nan unga ya nan himbutmun hi Hagar. Unudom nan alyon Sarah te hi Isaac damdamay ipa'annungan nan imbaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mu na'en imbabalem i diyen himbut ya idat'u boy dakol an holagna an gapu ta hiya ya imbabalem. ");
INSERT INTO ifa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ta on nawi\"it ot bumangon hi Abraham ot idadaanay makan ya liting ot ipabalunan da Hagar an hinina. Ot honagona dida. Ta onda imme ot eda humanawhawwangan hinan agge naboblayan hi ad Beerseba. ");
INSERT INTO ifa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ya hidin napuh nan liting an binalunda ot ipalo' Hagar nan imbabalena hinan pu''un han kaykayyiw. ");
INSERT INTO ifa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ot umeh nan e''elena ta e umbun hidi te alyonah nomnomnay, Adiya' pa''itpol an manigoh e atayan nan imbabale'. Ot inayunan kumga. ");
INSERT INTO ifa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ya dingngol Apu Dios an kumga bo nan unga ot humapit nan anghel Apu Dios hi ad abunyan ot alyona i Hagar di, Nganney inomnomam? Adi'a tumakut ot dingngol Apu Dios nan kogan nan ungah nan nangipalo'am. ");
INSERT INTO ifa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tuma'dog'aot ta em awiton nan unga. Te hiya ya pumbalino' nadan holagna hi ohan boble an ongal di abalinanda. ");
INSERT INTO ifa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ya ay diniyat Apu Dios di matan Hagar ta nangitigana han obob. Ot ena ihagub nan pun'inumanda ot ena pa'inuman nan unga. ");
INSERT INTO ifa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ya impappapto' Apu Dios nan unga hinan nihaha\"adanah nan agge naboblayan. Ta hidiy kimmilogana ya nala'ing an pumana. ");
INSERT INTO ifa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ya hidin immo'ohnongandahdi hinan agge naboblayan hi ad Paran ya e inawit inana han babai an i Egypt ot ipa'ahawana i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Waday immayan da Abimelek ya nan opisyal di tindaluna an hi Pikol hi awadan Abraham ot alyon Abimelek i hiyay, Innila' an an namin di atom ya hi Apu Dios di bumoddang. ");
INSERT INTO ifa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ta hiya nan ibaga' i he\"a ta isapatam hitun pundayawam i Apu Dios an adiya' kulukon i he\"a ya ta'on on nadan tanuda'. Ta nanongnan maphod di atom i da'mi ituwen ni'iboblayam ta umat hinan maphod an pangatmin he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ya alyon Abraham di, O isapata' an ato'. ");
INSERT INTO ifa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ot ibagan Abraham i Abimelek an nadan ba'baalona ya pinlohda nan bubun an iniphod da Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Mu alyon Abimelek di, Agge' attog innilah naen na'at an inggana nee ot ibagam. ");
INSERT INTO ifa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ot idattan Abraham hi Abimelek hi kalnero ya baka ta mangipa'innila an maphod nan nunhapitanda. ");
INSERT INTO ifa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ot hiwwayon Abraham di pitun tinna an imbabalen di kalnero. ");
INSERT INTO ifa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ya mahmahan Abimelek di gapunah pangatanahdi. ");
INSERT INTO ifa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ya alyon Abraham di, Danae ya alam ta wan he''ay muntistigu an hidiyen bubun ya ha''on di nangipiphod. ");
INSERT INTO ifa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ta hiya nan nginadanandah diyen boble hi Beerseba an gapu ta hidiy nunhapitandan duwa. ");
INSERT INTO ifa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ot umanamut mohpe da Abimelek i Pikol hi nunhituwanda. ");
INSERT INTO ifa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ot itanom Abraham han kayiw an tamaris hi ad Beerseba ot dayawona nan munnananong an Dios. ");
INSERT INTO ifa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ya nadney nihaha''adan da Abraham hidih nan boblen di i Pilistia. ");
INSERT INTO ifa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Indani ot patnaon Apu Dios di pangulug Abraham. Ta alyonan hiyay, Abraham! Ya alyon Abraham di, O tanganu? ");
INSERT INTO ifa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ya alyon Apu Dios i hiyay, Awitom nan oh'ohhan imbabalem an hi Isaac an pa'appohpohdom ya imme ayuh ad Moriah ta em i'nong hiya i ha''on hinan billid an tudduwo'. ");
INSERT INTO ifa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ta hidin nawi\"it ot gihaon Abraham nan kayiw an ma'usal hinan punggobhandah mi'nong ot idadaana nan dongkina ot inayundan makak an inawitnah Isaac ya nadan duwan baalna. Ot ipluydah nan inalin Apu Dios i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ta nangngenangngeda ya hidin mi'atluh algo ya minangmang mohpen Abraham nan umayanda. ");
INSERT INTO ifa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ot alyonah nadan baalnay, Umohnong ayu ni' hituh tun dongki ta madappuh amihdi an hin'ama ta e ami mundayaw i Apu Dios ya ahi ami mibangngad hitu. ");
INSERT INTO ifa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ot ipapahon Abraham nan kayiw hinan imbabalenan hi Isaac ot hiyay mangdon hinan uwah ya nan pangapuyda. Ya hidin mangmangngeda ");
INSERT INTO ifa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ya alyon Isaac di, Ama, tanganu on waday kayiw ya apuy ya daan nan kalneron maghob an mi'nong? ");
INSERT INTO ifa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ya alyon Abraham di, Imbabale', hi Apu Dios di ukod an mangdat hinan kalneron maghob an mi'nong. Ot inayundan mangmangngen hin'ama. ");
INSERT INTO ifa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Hidin dimmatongdah nan inalin Apu Dios ot iphod Abraham han punggobhan hi mi'nong hidi ot iphodnan palpagon nan kayiw hi uhhuna. Ot pawwidonah Isaac ot bobodona ot iyuhhunah nadan kayiw hidih nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ot ukatona nan uwah an pamatenah nan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mu himmapit nan anghel Apu Dios hi ad abunyan ot alyonay, Abraham! Ot alyonay, O tanganu? ");
INSERT INTO ifa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ya alyon diyen anghel i hiyay, Adim patayon nan unga. Ot innila' mo an hi Apu Dios di nabaktu hi unudom te ta'on on nan oh'ohhan imbabalem ya adim ukuhan an idawat i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ya nangitigan Abraham han tangbal an kalneron nihabut di ha'gudna i han kayiw hinan e''elena. Ot ume ot ena alan ot hiyay i'nongna hi nihukkat hinan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ta hay nungngadan Abraham i diyen immayanda ya alyonay, Hi Apu Dios Di Mangdat Hinan Mahapul. Ta ingganah ad uwani ya waday uggan alyon nadan tatagu an alyondah hidih nan billid an pundayawan i Apu Dios di pangidatanah nan mahapul. ");
INSERT INTO ifa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ya himmapit bo i Abraham nan anghel hi ad abunyan ");
INSERT INTO ifa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ot alyonay, Ha\"on an Dios ya adi' ibahho an wagahan da'a an gapu i naen impatigom hi aggem nangukuhan hinan oh'ohhan imbabalem an emmot i'nong i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ot ibaga' tee an wagahan da'a ta idattan da'ah dakkodakkol an holagmu ta umat hi dinakol di bittuwon hi ad lagud onu nadan panag hinan da'ging di baybay. Ta abakondan namin nadan binuhulda ya sinakupday bobleda. ");
INSERT INTO ifa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ya gapu i dida ya wagaha' an namin an tataguh tun luta an gapuh pangun'unudam i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ya hidin nagibbuh diye ot ibangngad da Abraham hinan immohnongan nan duwan baalna ta didan namin an immanamut hi ad Beerseba an nunhituwan da Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Indani ya na'innilaan Abraham an hi ibbanan hi Nahor ya waluday imbabaleda i ahawanan hi Milkah. ");
INSERT INTO ifa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ta hay panguluwan ya hi Us ot ahi nan lala'in hi Bus ot ahi hi Kemuel an hi aman Aram ");
INSERT INTO ifa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ot ahi hi Kesed ya hi Haso ya hi Pildas ya hi Jidlap ya hi Betuel. ");
INSERT INTO ifa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hi Betuel ya hiyay hi aman Rebekah. Ta waludan namin nadan linala'in imbabalen da Milkah i Nahor an hi ibban Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ya wadada boy udum an imbabalen Nahor hinan imbilangnah ahawana an hi Reumah. Ta hay imbabaleda i diye ya hi Tebah ya hi Gaham ya hi Tahas ya hi Maakah. ");
INSERT INTO ifa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Hi Sarah ya hinggahut ta han baintit pituy (127) tawona ");
INSERT INTO ifa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ot ahi mateh awadandah ad Hebron hidih ad Kanaan. Ot ibaluwan Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ya i diyen nateh ahawana ya e ni'hapit hinadan tinanud Hit an alyonay, ");
INSERT INTO ifa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ha''on ya bokona' iwahtu. Daan mo ta igattangyu doha hinan lutayu ta waha ilubu'an tun naten ahawa'. ");
INSERT INTO ifa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ya alyonday, ");
INSERT INTO ifa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Da'mi ya imbilang da'ah ohan nabaktu an ap'apu. Ot mabalin an pot'om nan pohdom hitun boblemi ta hidiy pangilubu'am hinan ahawam. ");
INSERT INTO ifa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ya nunyu\"ung hi Abraham hi punlispituna hinadan tinanud Hit ");
INSERT INTO ifa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ot alyonay, At'ehna an itbalyun ilubu''uhtuh ahawa' ya daan mo bahan ta ibagayu i Epron an hi na' Sohar ");
INSERT INTO ifa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ta igattangna i ha\"on nan lingab hi ad Makpelah an nihaggon hinan da'ging di puntanomana ta hidiy pangilubu'a'. Ya minahmahanyun hiyah on atnay pangigattangna ta bayada' ta pumbalino' hi lubu'an. ");
INSERT INTO ifa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mu hi Epron ya wahdin mi'ib'ibbun hinadan udum an tatagu i diyen boble an ni'yamung hinan way geyt an a'am'amunganda. Ot tobalonah diyen imbagan Abraham an dingngol nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","An alyonay, Namaag ya indat'un he''ah diyen lingab ya ta'on on nan puntanoman ta hidiy pangilubu'am i ahawam. Ot teen nunhindongolan tudan ibba' di pangdata' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ot munyu\"ung boh Abraham hi hinangngab nadan tatagu ");
INSERT INTO ifa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ot alyonan Epron di, Hanat donglom tun ibaga' te hay pohdo' ya bayada' hidiyen luta ta ahi mabalin an e' ilubu' hidih ahawa'. Ta hidiyen inalina ya nunhindongolan nadan tatagun na'amung. ");
INSERT INTO ifa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ot alyon mon Epron di, ");
INSERT INTO ifa_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Hay bayad diyen luta ya opat di gahut (400) di gumo' an silber. Mu adi mahapul an bayadam ot ditay ukod ya emmot inlubu' hidih ahawam. ");
INSERT INTO ifa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ya inabulut Abraham hidiyen inalin Epron an opat di gahut (400) an silber an miyunnudan di damotnah nan niyuldin an pumbayad di munggattang ot idatna ta tinigon nadan tataguh nangalan Epron. ");
INSERT INTO ifa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ta numbalin moh lutan Abraham hi ad Makpelah an inggattang Epron i hiya an nilaggat nan puntanoman an nihaggon hinan lingab ya ta'on on nadan bungbungnga\"an hidi. Ya hidiyen luta ya nihaggon hi ad Mamre. ");
INSERT INTO ifa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ta an namindan wahdin tinanud Hit an nanigo ya inniladan hi Abraham moy ud luta i diye. ");
INSERT INTO ifa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ot ena ilubu' hidi nan ahawanan hi Sarah i diyen lingab hi ad Makpelah hidih ad Hebron hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ta ginattang nimpen Abraham hidiyen puntanonam ya nan lingab hinan tinanud Hit ot pumbalinonah lubu'an. ");
INSERT INTO ifa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Hi Abraham ya na'amamma mo mu ongal di inat Apu Dios an nunwagah i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ya han hin'algo ya alyonah nan ap'apun di baalnay, Iyuhhunmuy ta'lem hi ulpu' ");
INSERT INTO ifa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","te pohdo' an isapatam hinan Dios hitun luta ya hi ad lagud an bokon hitun ad Kanaan di pamto'am i ha iyahawan nan imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ot mahapul an ume'ah nan boblen niyayyama' ta nan tulang'uy em pangawitan i ha iyahawan Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ya alyon diyen baal i hiyay, Mu nganney ato' hi'on adi pohdon nan babain mi'yali i ha\"on hitun awadan ta'u? On mabalin an mumbangngada' ta awito' hi Isaac ta ibangngad'uhdih nan nalpuwam? ");
INSERT INTO ifa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ya alyon Abraham di, Tigom ta adim ibangngad hidi nan imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Te nan Dios hi ad abunyan ya hiyay nangalih tayna' hidiyen boblen di a'ammod'u an ta'on on hidiy niyayyama'. Ot ihamadnan alyon i ha\"on di idatnah tuwen boble i ha\"on ya nadan tanuda'. Ot hiya nan madinola' an pamanguluwona nan anghelnahdi ta hitun umayam ya mabalin an waha awitom hi iyahawan nan imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mu hi'on adi pohdon nan babai an mi'yalin he''a ya ta'omman mu ta inunudmu nan imbaga' an atom. Mu ta tigom ta adim iyehdi tun imbabale' an ta'on hi nganney ma'at. ");
INSERT INTO ifa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ot iyuhhun mon diyen baal di ta'lenah ulpun Abraham ot isapatana an atona nan imbagan Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ot idadaanay himpuluh (10) nadan kemel Abraham ot pangipakalgaanah nadan nat'onat'on an mapmaphod an usal. Ot makak an umeh ad Mesopotamia an numboblayan Nahor. ");
INSERT INTO ifa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ta hidin adadatong i diyen boble ya tinigona han bubun ot pa'ohnongona nadan kemel hinan e''elena ta mun'ibleda. Ya i diye ya mun'ah'ahdom an hidiye nan e humaguban nadan binabaihdi. ");
INSERT INTO ifa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ot mundasal an alyonay, He''a Apu Dios an dayawon Abraham an ud baal i ha''on ya ipatigom bahan di homo'muh nan ud baal i ha\"on ta wan adi mibahho nan ipa'atnan ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nomnomnomom an wahtuwa' hi haggon tun bubun ya innilam an ad uwani ya umali nadan binabain malpuh boble an humagub. ");
INSERT INTO ifa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ot hanat nan babain pohdom an iyahawan Isaac ya nan pumbagaa' hi inumo' hinan hinagubna ya ipa'inumana''e ya atbohdin pa'inumana tudan kemel ya hidiyey panginnilaa' an nipa'annung nan imbagam hinan ud baal i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ya aggena impadappuh hidiyen dasalna ya wadah Rebekah an pinahonay pannuman an ihagubna. Hay nangimbabalen hiya ya hi Betuel an imbabalen da Milkah i Nahor an hi ibban Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ya hidiyen hi Rebekah ya apgohan di ababaina an agge ni' nangahawa. Ta on immeh nan bubun ot ihagubnay pannuman ta umanamut. ");
INSERT INTO ifa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ya mange nan baal an e nidamu ot alyonay, Iyam ni' bahan ta uminuma'. ");
INSERT INTO ifa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ya alyonay, O agam. Ot pa'ibagonan lo'ahon nan pinahona an inhagubna ot pa'inumana. ");
INSERT INTO ifa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","On na'inuman ot alyon Rebekah i hiyay, Aga ta e' bo pa'inuman nadan kemelmu ta ingganah onda ma'inuman. ");
INSERT INTO ifa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ot ume ot ikuyagna nan hinagubnah nadan pun'inuman di kemel ot tagtagona boh nan bubun ta ena bo ihagub ta ingganaot ma'inumandan namin nadan kemel. ");
INSERT INTO ifa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mu nan baal ya namaaggot dindinnongan an tigtiggonah on hiya nan pohdon Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ta hidin na'inumandan namin nadan kemel ya inukat diyen baal han balitu' an hingat di olong an na'angngina ya han duwan balitu' an mihu'lub hi ta'le ot idatna i Rebekah. ");
INSERT INTO ifa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ot alyonan hiyay, On nganney nangimbabalen he\"a? Undan adi mabalin bahan hi mun'iyan amih baleyu hi'on waha mabalin hi pun'iyananmi? ");
INSERT INTO ifa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ya alyonay, Ha\"on nan imbabalen Betuel an hi imbabalen da Nahor i Milkah. ");
INSERT INTO ifa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ot ha'ey eyu umiyanan ya ume ta'uh balemi ot dayyahdiy mabalin hi anon tudan kemel ya wahdi boy mabalin hi alo'anyu. ");
INSERT INTO ifa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ot mundu''un hidiyen baal ta dayawonah Apu Dios ");
INSERT INTO ifa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","an alyonay, Munhanaa' i he''a Apu Dios an dayawon Abraham an ud baal i ha''on te impatigom di homo'mu i hiya hinan nangipa'annungam hinan imbagam i hiya. Ya munhanaa' bo ta impanguluwa' i he''ah nadan tulangna. ");
INSERT INTO ifa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Yaden hi Rebekah e ya tagtagtagonan umanamut ta ena ibaga i inanah diyen na'at. ");
INSERT INTO ifa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ya wada han lala'in hi ibban Rebekah an hi Laban di ngadana an aw'awiggingonan mangeh awadan diyen lala'i hinan bubun. ");
INSERT INTO ifa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Te tinigona nan hingat hi olong nan ibana ya nan inhu'lubna ya dingngolna nan imbagan Rebekah ta hidiye nan immeh awadan diyen tagu ya tinigona an wahdin tumtumma'dog hi haggon nadan kemel hidih nan way bubun. ");
INSERT INTO ifa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ot alyonay, He''a an iba an winagahan Apu Dios, tanganu on ayu udot wahtu? Ma'a ta ume ta'uh balemi ot wahdiy nidadaan hi umohnonganyu ya ta'on on hantudan kemel. ");
INSERT INTO ifa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ot mi'yedah baleda. Ta hidin dimmatongda ot pun'aan Laban nadan kalgah nadan kemel ot iyeday dagami ta anon nadan kemel. Ot iyeda boy liting hinan baal Abraham ya nadan nun'ibbana ta ulahanday hukida. ");
INSERT INTO ifa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ya hidin indadaanday anonda ya alyon diyen baal di, Adiya' mangan ta ingganah on'u ibaga nan gapunah immaliyanmihtu. Ya alyon Laban di, Ot agam mo ta ibagam. ");
INSERT INTO ifa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ot alyonay, Ha''on nan baal Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Hi Apu Dios ya ongal di inatnan nunwagah hinan ud baal i ha\"on te kimmadangyan. Ta dakol di kalnerona ya bakana ya kemelna ya dongkina. Ya atbohdiy pihhunan silber ya balitu'na ya ta'on on hay baalna an binabai ya linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ya hi ahawanan hi Sarah ya ininna ot ahi mawada han imbabaledan lala'i ta hiyay nangipaboltanan Abraham hi an namin nadan kinadangyana. ");
INSERT INTO ifa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ot punsapataona' i Abraham an mahapul an bokon hanadan i Kanaan di pamto'a' i ha iyahawan nan imbabalenan hi Isaac ");
INSERT INTO ifa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","te da'yun tulangnahtu. ");
INSERT INTO ifa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ot alyo' di, Nganney ato' hi'on adi mi'yalin ha''on hidiyen babai? ");
INSERT INTO ifa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ya alyonay, Nan Dios an nanongnan inun'unud'u ya pi'yaliyona nan anghelna i he\"a ta boddangan da'a ta maphod di pumbalinan nan umayam hidi ta waha awitom hi iyahawan tun imbabale' hinadan tulang'u an holag ama. ");
INSERT INTO ifa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ot alyona bon ha''on di, Atom'e nan inali' hi atom ta ume'ah awadan nadan tulang'u mu ningamut'e an adi pi'yaliyon nadan tulang'u nan babain pinto'mu ya ta'omman mu ta inatmu nan insapatam i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ta hiya nan hidin dimmatonga' hinan bubun ya nundasala' an alyo' di, He''a Apu Dios an dayawon Abraham an ud baal i ha''on ya boddangana' bahan ta adi mibahho nan nun'iyali' hitu. ");
INSERT INTO ifa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ot teen wahtuwa' hitun haggon tuwen bubun ot nan mangilog an babain umalin humagub ya alyo\"e i hiyay, Iyam ni' ta uminuma' hinan hinagubmu ");
INSERT INTO ifa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ya alyona'ey o agam ta ahi' e pa'inuman nadan kemelmu ya hiyah diye nan pohdom an Dios an iyahawan nan imbabalen nan ud baal i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ya agge' impadappuh nan dasal'u ya wadah Rebekah an pinahonay ihagubnan pannuman. Ta on nalpah an inhagubna ot alyo' i hiyay, Iyam ni' bahan ta uminuma' hinan hinagubmu. ");
INSERT INTO ifa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ya na'ibagonan lina'ah nan pannuman ot alyonay, O agam ta uminum'a ta ahi' e pa'inuman nadan kemelmu. Ta imminuma' ot ena pa'inuman nadan kemel. ");
INSERT INTO ifa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ot mahmaha' di ngadan amana ya alyonay, Hi Betuel an imbabalen da Nahor i Milkah. Ot inayun'u mon ipihingat i hiya nan hingat hi olongna ot ipihu'lub'u mo bon hiya nan mihu'lub hi ta'le. ");
INSERT INTO ifa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ot mundu''una' ot dayawo' nan Dios an dayawon Abraham an ud baal i ha''on. Te ongal di punhanaa' hi ena nangipanguluwan i ha''on i da'yun tulang nan ud baal i ha''on an hi Abraham ta pinto''u nan pohdonan iyahawan nan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ot hanat ibagayuh on pinhodyun mi'yapuh nan ud baal i ha''on onu adiyu ta hiyay ibaga' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ya alyon da Laban i Betuel di, Hinae ya na'innilan hiyay pohdon Apu Dios hi ma'at ot undan da'miy mangibahho. ");
INSERT INTO ifa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ta'omman mo ya inawitmuh Rebekah ta iyahawan nan imbabalen nan ud baal i he''a ta miyunnudan hinan pohdon Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","On dingngol nan baal Abraham hidiyen inalida ya innayunan nundu\"un ot ida\"omnay anganah nan luta hi pundayawna i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ot ena mohpe ukaton nadan inodnanan balitu' ya silber ya nadan mun'aphod an lubung ot idatna i Rebekah. Ot idattana boh ibbanan hi Laban ya hi inanah nadan udum an nun'abalol. ");
INSERT INTO ifa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ot ahida mohpe e mangan hinadan nun'ibbanan linala'i ot umiyandahdi. Ta onda bimmangon hidin nawi\"it ot alyon diyen baal Abraham di, Aga ta umanamut ami mo. ");
INSERT INTO ifa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mu alyon da Laban an hininay, Indani ta mala\"uh ni'mo ha himpuluy (10) algoh umohnongan hitun Rebekah ya ahi da'mi taynan. ");
INSERT INTO ifa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mu alyon nan baal di, Adiyu bahan palodpodon di pumbangngada' hinan ud baal i ha''on te maphod ta impa'annung Apu Dios nan nun'iyali' hitu. ");
INSERT INTO ifa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ya alyonday, Ot indani mo ta ayagan ta'u nan unga ta hay alyona. ");
INSERT INTO ifa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ya hidin inayagandah Rebekah ot alyondan hiyay, On pohdom an mi'ye ituwen tagu? Ya alyonay, O pohdo'. ");
INSERT INTO ifa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ot iyabulutda mo an mi'yeh Rebekah hinan baal Abraham ya nadan nun'ibbana ot pi'yayonda i hiya nan ohan tagalan nangipappapto' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ot wagahandah Rebekah an alyonday, Hanat he\"a an iba ya mumbalin'ah hi inan di dakkodakkol an tatagu. Ya hanat nadan tanudam ya abakondan namin nadan binuhulda ya sinakupday bobleda. ");
INSERT INTO ifa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ot eda mohpe mitakke da Rebekah ya nan tagalanah nan kemel ot mi'yedah nan baal Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hi Isaac ya nalpuh ad Beer-Lahay-Roy te e nunhituh nan negeb. ");
INSERT INTO ifa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ta han mun'ahdom ya immeh nan way puntanoman ya nangimangmanganay nabulog an kemel. ");
INSERT INTO ifa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ya hidin tinigon Rebekah hi Isaac ot munlo'ah hinan nitakkayana ");
INSERT INTO ifa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ot alyonah nan baal Abraham di, Nganneh diyen taguh nan way puntanoman an tuwen manamu i dita'u? Ya alyonay, Hiyah diye nan imbabalen nan ud baal i ha''on. Ot alan mon Rebekah di hu'yungna ot munhu'yung ta pangipatigonah pumpada''ulana i Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ta onda nundadammu ot uhuhon nan baal i Isaac an namin nan na'at. ");
INSERT INTO ifa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ot awiton mon Isaac hi Rebekah ot iyenah nan natoldaan an allung din hi inana an hi Sarah ta hiyay inyahawana. Ya pohpohdon Isaac hiya. Ta hiyay nahiwan di nomnomnah ena umukayungan hi natayan inana. ");
INSERT INTO ifa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Hi Abraham ya numbintan i han hi Keturah. ");
INSERT INTO ifa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ta nawadada da Simran ya hi Joksan ya hi Medan ya hi Midian ya hi Isbak ya hi Suah. ");
INSERT INTO ifa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ya hi Joksan ya nuntanud ta da Seba i Dedan. Ot muntanud hi Dedan ta da Asuri i Letusim ya hi Leummim. ");
INSERT INTO ifa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ya hi Midian ya nuntanud ta da Epah ya hi Eper ya hi Hanok ya hi Abida ya hi Eldaah. Ta danaen namin di holag Keturah. ");
INSERT INTO ifa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Mu hay nangipaboltanan Abraham hi an namin an wadan hiya ya hi Isaac mu inggana ot mateh Abraham ot ahina boltanon. ");
INSERT INTO ifa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mu wada damdamay indatnah ligalunah nadan udum an imbabalenah din agge ni' nate. Ot ahina ituda' didah nangappit hi tuluwan di algo ta hidiy eda niha''adan ta nihiwweda i Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Hay ngammut di tawon Abraham ya hinggahut ta han napitut lima (175). ");
INSERT INTO ifa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ta na'amamma ot ahi mate. ");
INSERT INTO ifa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ot e ilubu' nadan imbabalenan da Isaac i Ismael hinan lingab hi ad Makpelah hidih nan way puntanoman Epron an hi na' Sohar an tinanud Hit. ");
INSERT INTO ifa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hidiyen puntanoman an ginattang Abraham ya nihaggon hi ad Mamre hi nangappit hi tuluwan di algo. Ta hidi boy nangilubu'anda i hiya hidih nan nilubu'an ahawanan hi Sarah. ");
INSERT INTO ifa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Hidin nalpah an nateh Abraham ya winagahan Apu Dios nan imbabalenan hi Isaac an nunhituh nan nihaggon hi ad Beer-Lahay-Roy. ");
INSERT INTO ifa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hi Ismael an imbabalen Abraham hinan i Egypt an hi Hagar an himbut Sarah ya wadaday tinanudana. ");
INSERT INTO ifa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ta datuwey ngadangadan nadan linala'in imbabalen Ismael an hay panguluwan ya hi Nebayot ot ahi hi Kedar ot ahi hi Adbeel ot ahi hi Mibsam ");
INSERT INTO ifa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ot ahi hi Misma ot ahi hi Dumah ot ahi hi Masa ");
INSERT INTO ifa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ot ahi hi Hadad ot ahi hi Tema ot ahi hi Jetur ot ahi hi Napis ot ahi mohpe hi Kedemah. ");
INSERT INTO ifa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ta datuwen linala'in tinanud Ismael ya diday ap'apun nadan himpulut duwan (12) tinanud an ningadan di ngadandah nan himpulut duwan (12) boblen imbangonda. ");
INSERT INTO ifa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ta hay ngammut di tawon Ismael ot ahi mate ya hinggahut ta han tulumpulut pitu (137). ");
INSERT INTO ifa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ya hay e nunhituwan nadan holagna ya nan numbattanan di ad Habilah ya hi ad Sur an nidommang hi ad Egypt hi nangappit hi tuluwan di algoh nan awon an umeh ad Assyria. Ta nihiwwedah nadan udum an tinanud Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hi Isaac e an imbabalen Abraham ");
INSERT INTO ifa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ya napat (40) di tawonah din nun'addumanda i Rebekah an hi ibban Laban an imbabalen nan i Aram an hi Betuel an nunhitudah ad Paddan-Aram. ");
INSERT INTO ifa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Mu hi Rebekah ya adi mun'imbabale. Ot mundasal hi Isaac ya timbal Apu Dios ta numbutyug. ");
INSERT INTO ifa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mu nan imbutyugna ya nundappel ta namaag onda ay umanawwit hi putuna. Ot alyon Rebekah di, Tanganu nin on tayya han at hitun ma'ma'at i ha''on? Ot mundasal i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ya alyon Apu Dios i hiyay, Nan imbutyugmu ya nundappel ta nan holagda ya munhi\"andah punhituwan. Ya nan udidiyan ya mabikbikah mu nan oha te nan panguluwan ya hiyay munhilbih hinan udidiyan. ");
INSERT INTO ifa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ta hidin nun'ayyam ya immannung an nundappel an linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ya nan namangulun bimmudduh ya mumbolah ya na'addutdutan. Ot ngadananda mo ta hi Esau. ");
INSERT INTO ifa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ot mitnud nan mi'adwa an inhamadnan inidon hi mu'ud Esau ta hiya nan nginadananda ta hi Jacob. Ya hidin inyayyam Rebekah dida ya nanom (60) di tawon Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Hidin kimmilogda ya nala'ing hi Esau an mun'anup ta nan muyung di imminghah umayana. Yaden hi Jacob e ya nan nunhituwanday umo'ohnongana. ");
INSERT INTO ifa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ya hay pinpinhod Isaac ya hi Esau te pohpohdonan ihda nan anupona. Mu hi Rebekah ya hi Jacob di pinpinhodna. ");
INSERT INTO ifa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ta han hin'algo an munha'ha''ang hi Jacob ya dimmatong hi Esau an nalpuh muyung an na'a'aggangan. ");
INSERT INTO ifa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ot alyonan Jacob di, Iyalim ni' ya hah nan mumbolah an inha''angmu ta ano' te tehtu tayya an na'a'aggangana'. Ta hiya nan tinolbanganda ta hi Edom te hidiyen odawona ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ya alyon Jacob i hiyay, O mu idatmu ni' i ha\"on nan kalebbengam an panguluwan. ");
INSERT INTO ifa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ya alyon Esau di, Undan nganney hilbin nae ya ten mateya' hi inagang'u. Ta'omman ya bagim. ");
INSERT INTO ifa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mu alyon Jacob di, Mu isapatam ni' an idatmun ha''on nan kalebbengam an panguluwan. Ta nunsapatah Esau an idatna i Jacob nan kalebbenganan panguluwan. ");
INSERT INTO ifa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ona inathidi ot idat mohpen Jacob dohah nan inha''angna ya nan tinapay ot anona. Ta on nabhug ot inayunan umaan hidi. Ta hinaey mangipa'innila an manghan di punnomnom Esau hinan kalebbenganan panguluwan. ");
INSERT INTO ifa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Indani ya wada bo han bitil i diyen boble an nat'on tuwali din bitil hi atagun Abraham. Ta imme da Isaac hinan boblen nan patul di i Pilistia an hi Abimelek hidih ad Gerar. ");
INSERT INTO ifa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mu numpatigoh Apu Dios i Isaac hidi ya alyonay, Adi'a umeh ad Egypt ta nan alyo' an em iha''adan ituwen boble di umohnongam. ");
INSERT INTO ifa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ot unudom'e tun alyo' ya boddangan da'a ya winagahan da'an ha''on. Ta idat'un he''a ya nadan tanudam hituwen luta ta ipa'annung'u din imbaga' i amam an hi Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ya atbohdin punholagon da'ah dakkodakkol ta umat hi dinakol nadan bittuwon ta diday pangdata' hi an namin ituwen luta. Ya gapun dida ya mawagahandan namin di tataguh tun luta ");
INSERT INTO ifa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","an gapuh nangun'unudan din hi amam an hi Abraham hi an namin nan imbaga' an mahapul an atonyu. ");
INSERT INTO ifa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ta e mo niha\"ad da Isaac hi ad Gerar. ");
INSERT INTO ifa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mu nadan linala'ihdi ya minahmahanda i Isaac hi'on nganney niyatana i Rebekah. Ya alyonay hi ibbana te tumakut hi pamatayandan hiya hi'ona ibaga an ahawana te apgohan bo udot. ");
INSERT INTO ifa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mu hidin nadney niha\"adandahdi ya wada han naminghan an inuhdungan nan patul an hi Abimelek hinan tawana an mun'aw'awwalan da Isaac i Rebekah. ");
INSERT INTO ifa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ot ipa'ayag mon Abimelek hi Isaac ot alyonan hiyay, Ot te mahan an ahawam ya tanganunmu alyon ni' di hi ibbam? Ya alyonay, O te alyo''ot on alina ya patayona' hi'on'u ibaga an ahawa'. ");
INSERT INTO ifa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ya alyon Abimelek di, Tanganu on waha athinah em inat? Onha wada otahan ha e ni'ilo' i hiyah nadan linala'ihtu ot namaag ya he''ay lummuh emi pumbahulan. ");
INSERT INTO ifa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ot ibagan mon Abimelek hinadan tatagu an mipapate nan tagun mangat hi adi maphod i Isaac onu nan ahawana. ");
INSERT INTO ifa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Hidiyen tawon an nuntanom hi Isaac hidi ya pinumhod di intanomna ta dakol di inapitna an paddungnay numpihinggahut (100) an binumti nan intanomna te winagahan Apu Dios hiya. ");
INSERT INTO ifa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ta na'udman an na'udman di kinadangyana ta lo'tat ya numbalin hi kakaddangyanan. ");
INSERT INTO ifa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Te dakkodakkol di kalnerona ya bakana ya baalna ta amohan nadan i Pilistia. ");
INSERT INTO ifa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ta immeda ot eda tababon an namin nadan bubun an impaka''ut din hi amanan hi Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ot alyon mon nan patul an hi Abimelek i Isaac di, Umaan'a attog hitun boblemi te namaag nee ya on he''ay ong'ongngal di abalinana mu da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ot makak mo da Isaac ot umedah nan nundotal hi ad Gerar ta hidiy eda niha''adan. ");
INSERT INTO ifa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ot ena ipaka''ut an namin nadan bubun an impiphod din hi amanan hi Abraham hidi. Te hidin nate ya e tinannabab nadan i Pilistia. Ot ingadana damdama i dadiyen bubun din nungngadan amana. ");
INSERT INTO ifa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ya wada bo han impaka''utnah nadan baal hinan nundotal hi ad Gerar an waday liting hi dallomna. ");
INSERT INTO ifa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mu indani ya immeda nadan mumpumpastol an i Gerar ya mi'hannudah nadan pumpastolon Isaac te alyonday nan liting ya litingda anu. Ot ngadanan mon Isaac hidiyen bubun hi Punhahannuwan. ");
INSERT INTO ifa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ot eda mo bo mungka''ut hi oha mu atbohdin pun'a'awwitanda. Ot ngadanan mo bon Isaac ta hi ad Pun'a'awwitan. ");
INSERT INTO ifa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ot madligda mo bo ot ahhinda mungka''ut boh oha. Ya ma''id mo ha e mamloh i diye. Ot ngadanana mo hi Luminggopan. Te alyon Isaac di, Maphod ta ad uwani ya inyabulut Apu Dios an munhitu ta'uhtu ta hitu mohpey pumhodan ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ta nihaha''addahdi ot ahida umeh ad Beerseba. ");
INSERT INTO ifa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mu hidin nahdom i diyen dimmatnganda ya numpatigo boh Apu Dios i Isaac ot alyonay, Ha''on nan Dios an dayawon amam an hi Abraham ot adi'a tumakut te wadaa' an bumoddang i he''a. Ta wagahan da'a ya punholagon da'a ta dakkodakkol di holagmu te hiyay imbaga' hinan baal'u an hi amam an hi Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ot iphod Isaac han punggobhan hi maghob hidi ot dayawonah Apu Dios. Ot iyammanahdi han nun'allunganda ot eda mungka''ut hidi nadan baalna i han bubun. ");
INSERT INTO ifa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","I han hin'algo ya imme da Abimelek an nalpudah ad Gerar ya hi Ahusat an hiya nan uggan muntugun i hiya ya hi Pikol an nabaktun opisyal di tindaluna ta eda tigon hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ot alyon Isaac i diday, Tanganu on ad uwani ya umali ayun manigo i ha''on yaden nunhigla ni' di hihiwoyu i da'mi ta impa'aan da'mih bobleyu. ");
INSERT INTO ifa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ya alyonday, O te ad uwani mo ya innilamin hi Apu Dios di bumodboddang i he''a. Ta hiya nan pinhodmin mi'hayyup i he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ta wan ibagam an ma\"id ha atom hi adi maphod i da'mi ta umat hidin awadan ta'un namin an ma''id ha inatmin he''a hi adi maphod ta ingganah din nangipa'aananmin da'yuhdi. Mu ad uwani ya mapto' an hi Apu Dios ya inaynayunan munwagah i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ot idadaan mon Isaac di makan ya ma'inum ta mun'am'amlongdan namin. ");
INSERT INTO ifa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Hidin bimmangondah din mun'abigat ot mumpunsapatada hi hinohha an adida mangat hi adi maphod hi hinohhan dida. Ta hidin nagibbuh ot ahida mohpe madinol da Abimelek ya nadan nun'ibbanan umanamut. ");
INSERT INTO ifa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ya i diyen algo ya immali nadan baal Isaac ya alyonday, Waday inakhupanmin liting hinan bubun an kina''utanmi. ");
INSERT INTO ifa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ot ngadanan Isaac hidiyen bubun hi Nunsapataan. Ta hidiyey na'alaan nan ngadan diyen boble an hi ad Beerseba. ");
INSERT INTO ifa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Hidin napat (40) di tawon Esau ya inyahawanay duwan binabain tinanud Hit an da Judith i Basemat. Hi Judith ya imbabalen Beeri ya hi Basemat ya imbabalen Elon. ");
INSERT INTO ifa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mu dadiyen inahawan Esau di gapunah e inomnoman da Isaac an himbale i Rebekah. ");
INSERT INTO ifa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Hi Isaac ya amamma mo ya adi tumigoy matana. Ya alinah ona pa'ayag nan panguluwan an imbabalenan hi Esau. Ta hidin immeh Esau ya alyonay, Imbabale'. Ya alyon Esau di, Tanganu ama? ");
INSERT INTO ifa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ya alyon Isaac di, Ten amammaa' mo ya adi mibahhon agagga moy ataya'. ");
INSERT INTO ifa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ot alam nan panam ya imme'ah muyung ta e'a manganup. ");
INSERT INTO ifa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ta wa'e ha inanupmu ya inha''angmundi anu hinan pohdo' an ihda ya inyalim ta hiyay ihda'. Ta nabhuga\"e ya ahi da'a winagahan hinan ma'udin punwagah'u ta ahiya' mate. ");
INSERT INTO ifa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mu hi Rebekah ya dingngolnah diyen imbagan Isaac i Esau. Ta hidin hiyah immeh Esau an e mun'anup ");
INSERT INTO ifa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ot alyonan Jacob di, Nomnomnomom te dingngol'un alyon amam i Esau ");
INSERT INTO ifa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","di ume anu ta e manganup ya inyanamutna ta iha''angna ya impihdanan hiya. Ta nabhug'e ya ahina winagahan hinan ma'udin punwagahna ta ahi mate. ");
INSERT INTO ifa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ot he''a an imbabale ya unudom tun alyo'. ");
INSERT INTO ifa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ta ma'anne'ah nan awadan di gulding ya pinto'muy duwah nadan mun'atataba an hiyah nahikon ya inyalim ta iha''ang'u nan pohpohdon amam. ");
INSERT INTO ifa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ta hiyay em ipihdan hiya ta he''ay wagahana ya ahi mate. ");
INSERT INTO ifa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mu alyon Jacob i inanay, O mu hi Esau ya nadutdutan an adi umat i ha''on an madangih di up'up'u. ");
INSERT INTO ifa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Alina ya dapaona' ya ma'innilaana an bokon ha''on hi Esau ya ummanot on ha idut di midat i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ya alyon inana boy, Onha waha athidi ot ta'on ya ha''on di ma'idutan ta bokon he''a. Ekaot ta em alan ha duwah nan gulding. ");
INSERT INTO ifa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ta imme moh Jacob ot ena alan nan duwan gulding. Ot paltiyonda ot iha''ang inana hinan pohpohdon amanan ihda. ");
INSERT INTO ifa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ot alana bo nan amapmaphodan an lubung Esau ot ipilubungna i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ot ipaklana nan lina'latnan up'up nan gulding hi ta'len Jacob ya hay bagangna. ");
INSERT INTO ifa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ot ahina idat i hiya nan mahongo an inha''angnan gulding ya nan tinapay. ");
INSERT INTO ifa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ta inyen Jacob i amana ot alyonay, Ama. Ya alyon amanay, O, on nganne'a i da'yu an imbabale'? ");
INSERT INTO ifa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ya alyon Jacob di, Ha''on nan panguluwan an hi Esau an inyali' tee nan alyom. Ot bumangon'a ta ihdam tun dotag ta ahiya' mohpe wagahan. ");
INSERT INTO ifa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ot alyon Isaac di, Nganney inatmu ta agagga ya waday inanupmu? Ya alyon Jacob di, Hi Apu Dios an dayawom di bimmoddang i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ot alyon Isaac di, Imbabale' mihaggon aya ta dapaon da'a hi'on immannung an he''ah Esau. ");
INSERT INTO ifa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ot mihaggon moh Jacob i amana ta ona dinapa ya alyonay, Hay hapitmu ya ay hapit Jacob mu hay ta'lem ya ay ta'len Esau. ");
INSERT INTO ifa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ta aggena immatunan an hi Jacob te nan ta'lena ya ay ta'len Esau. Ya on alyon di ta wagahana ");
INSERT INTO ifa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ya alyona boy, On immannung an he''ah Esau? Ya alyon Jacob di, O ha''on tee. ");
INSERT INTO ifa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ot alyon Isaac di, Iyalim mo doha ta ihda' hinan em inanup ta ahi da'a wagahan i ha''on. Ot idat Jacob doha ot anona ot idattana boh bayah hi inumona. ");
INSERT INTO ifa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ot ahi mohpe alyon Isaac i hiyay, Imbabale', ma'a ta awalona'. ");
INSERT INTO ifa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ot ume mo ot awalona ta hinunghung amana nan lubungna ot wagahanan alyonay, Mapto' tuwalin hay panunghung'uh tun imbabale' ya umat hinan hunghung nan puntanoman an winagahan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ot hanat hi Apu Dios ya ipiyalina nan dulnu an nalpuh ad abunyan ya ipalumongna nan lutan puntanomam ta dakol di makan ya ma'inum. ");
INSERT INTO ifa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya hanat nadan tataguh abobboble ya munhilbida i he\"a ta he\"ay mumbalin hi ap'apuda. Ya ta'on on hanadan tulangmu ya he''ay ibilangdah ap'apu. Ya an namin nadan mangidut i he''a ya dida otahan di ma'idutan. Mu nadan munwagah i he''a ya mawagahanda damdama. ");
INSERT INTO ifa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ta hidin nagibbuh an winagahan Isaac hi Jacob ot umaan hidi. Mu hidin hiyah immaan ya dimmatong hi ibbanan hi Esau an nalpuh nan ena nanganupan. ");
INSERT INTO ifa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ta inha''angna nan inanupnah nan punha''ang an pohpohdon amana. Ta hidin nalutu ot iyenan hiya ot alyonay, Ama anuham an bumangon ta umbun'a ta ihdam dohah tun dotag an inyali' ya ahiya' winagahan. ");
INSERT INTO ifa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ya alyon amanay, On ngadanmu? Ya alyon Esau di, Ot ten ha''on teeh Esau an panguluwan an imbabalem. ");
INSERT INTO ifa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ya munggagayonggong hi Isaac an alyonay, Ot nganne moh diyen nangiyalin ha''on hi niha''ang an dotag ot ihda' ta hiyay winagaha'. Ta hiya moy mawagahan hi inggana. ");
INSERT INTO ifa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ya adi mitpol di kogan Esau hi nangngolana i diye ot alyonay, Mu ta'on bahan on ha\"on ama ya wagahana'. ");
INSERT INTO ifa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ya alyon Isaac di, Binaliyana' nee hinan ibam ot alana nan wagah an midat ot i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ot alyon Esau di, Undan tuwalin na'innilaan di pangatnan miyunnudan hinan ngadanan Jacob te pidwana moh tuwe hi namaliyana i ha''on. Te binaliyana' bo ot alana nan kalebbenga' an panguluwan ya ten ad uwani mahan ya nan wagah an midat i ha''on. Ot undan ma''id ahan ha nabati i ha punwagahmun ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ya alyon Isaac di, Imbabale' ma''id mo te nalpah an hiyay winagaha' hi nabakbaktu i da'yun duwa ta an naminday tutulangna ya numbalino' didah baalna. Ya hiya boy nangdata' hi makan ya bayah. ");
INSERT INTO ifa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Mu hiya damdaman mumpahpahmo' hi Esau i amanan alyonay, Undan oha ya ammuna ha wagaham ama. Pi'wagaha' bahan. Ot inayunan mungkoga. ");
INSERT INTO ifa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mu alyon Isaac i hiyay, Nan lutan em iha''adan ya adi humangoy mitanom ya adi dumulnu. ");
INSERT INTO ifa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ta hay itanudmu ya hanadan alam hinan abakom hi gubat. Ya mumbalin'ah baal nan ibam. Mu lo'tat ya ngohayom ta adi minaynayun an he\"ay baalna. ");
INSERT INTO ifa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ta nihipun i diye ya ma'hihhiwoh Esau i Jacob an gapuh nan nunwagahan Isaac i Jacob. Ta hay ninomnomna ya patayonah ibbanah tun malpah an mateh amada. ");
INSERT INTO ifa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mu waday nangilmu i diyen ninomnomna ot ipa'innilada i Rebekah. Ta impa'ayagna moh Jacob ot ibagana i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ot alyonan hiyay, Imbabale' bumtik'a attog hi balen da ulitaum an hi Laban hi ad Haran. ");
INSERT INTO ifa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ta hidiy em ni' iha''adan ta ingganah on ma'ubayah di bungot nan ibam. ");
INSERT INTO ifa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ta lininglingna'e nan inatmun hiya ya ahi nangamung ha honago' hi umalih mangawit i he''ahdi. Te undan ni'nong ha alina ya namaag ya nama''id ayun duwa. ");
INSERT INTO ifa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ot alyon bon Rebekah i Isaac di, Impa'engleya' mo ahan hinadan ahawan Esau an i wahtu. Ya onha mangahawa'e bo hi Jacob hinan tinanud Hit ot udulna attog di mateya'. ");
INSERT INTO ifa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ot ipa'ayag Isaac hi Jacob ot tugunonan alyonay, Adi'a mangahawah i Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mundadaan'a ta ume'ah ad Paddan-Aram hi boblen aman inam an hi Betuel ta nan imbabalen ulitaum an hi Laban di ahawaom. Hi Laban ya hi ibban inam. ");
INSERT INTO ifa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ot hanat nan ongal di abalinanan Dios di munwagah i he''a ta dumakkodakkol di holagmu. Ta mumbalin'ah hi aman di dakol an tinanud. ");
INSERT INTO ifa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ta wan he\"ay idatan nan nunwagah Apu Dios i din hi apum an hi Abraham ta he\"ay ipa'annungana ta ta'on on ta'u mangili ituwen boble mu lo'tat ya da'yuy munhitu ituwen boble. Te hituwen boble ya indat Apu Dios i din hi apum an hi Abraham. ");
INSERT INTO ifa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ot honagon Isaac hi Jacob hi ad Paddan-Aram ta umeh balen ulitaunan hi Laban an hi ibban Rebekah an hi inada i Esau. Ya hay hi aman da Laban i Rebekah ya hi Betuel an i Aram. ");
INSERT INTO ifa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Hi Esau ya na'innilaanan winagahan Isaac hi Jacob ot tugunona ta bokon ha i Kanaan di ahawaona ot ituda'nah ad Paddan-Aram ta hidiy ena pangahawaan. ");
INSERT INTO ifa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ot un'unudon Jacob da amada i inada ta immeh ad Paddan-Aram. ");
INSERT INTO ifa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Te inilmun Esau hi agge naminhodan amanah nadan binabain i Kanaan an inahawana te gapuh nan pangatda. ");
INSERT INTO ifa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ot ume moh balen ulitaunan hi Ismael an imbabalen Abraham ot ahawaonah Mahalat an hi ibban Nebayot an imbabalen Ismael ta niddum hinadan udum an ahawana. ");
INSERT INTO ifa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hi Jacob ya tinaynanah ad Beerseba ot ipluynah ad Haran. ");
INSERT INTO ifa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ya hidin nahdoman hinan awon ot umohnong ta mun'ible. Ot alana han batu ta hiyay nangippinganan nalo'. ");
INSERT INTO ifa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ya ininopna an wada anu han agdan an nigoh'ad hinan luta ot mitu'dul hi ad lagud. Ya wadaday anghel Apu Dios an tumikidda on dimmayyuda i diyen agdan. ");
INSERT INTO ifa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ya inoy an wahdih Apu Dios an timma'dog hi baktun diyen agdan. Ya alyonay, Ha''on hi Apu Dios an dayawon apum an hi Abraham ya hi amam an hi Isaac. Hituwen lutan nalo'am ya idat'un he''a ya nadan tanudam. ");
INSERT INTO ifa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ya hay dinakol di tanudam ya umat hi dinakol di hupu'. Ta mumpapangeday udum hi nangappit hi alimuhan di algo ya hi nangappit hi tuluwan di algo ya hi nangappit hi huddo'na ya hi muyyadna. Ya an namin di tataguh abobbobleh tun luta ya mawagahandan gapun da'yu. ");
INSERT INTO ifa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ot wadaa' i he''a ta ipapto' da'a hi an namin di pangayam ta wan mumbangngad'a ta mumboble'a ituwen awadam. Ot adi da'a taynan ta mipa'annung nan imbaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ta hidin inggibo' Jacob ya alyonah nomnomnay, Agge' tee innila ya onnot on wadah Apu Dios ituwen immohnonga'. ");
INSERT INTO ifa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ya nangintatakut an alyonay, Te on hitu nan paddungnay panton di ad abunyan an nunhituwan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ta on nawi\"it ot maba''unut moh Jacob ot alana nan batun nangippinganah nalo'ana ot ha''adona ta mangipanomnom i hiya i diyen ininopna ot ahina hiitan hi lana. ");
INSERT INTO ifa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ot ngadananah diyen boble ta hi ad Betel mu hay ngadana ni' ya hi ad Lus. ");
INSERT INTO ifa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ot munsapata an alyonay, Wadawada'eh Apu Dios ta ipapto'a' i hiya hinan pangaya' ta idatna nan mahapul'u an umat hi ano' ya ilubung'u ");
INSERT INTO ifa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ta malinggop hi pumbangngada' hi balen ama ya hiyay Dios hi dayawo'. ");
INSERT INTO ifa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ya hituwen batun hina''ad'uy panginomnomnoma' hinan nipatigon ha\"on ta hituy pundayawa' i Apu Dios. Ya an namin di idatnan ha''on ya ipabangngad'u nan mi'apulu (10). ");
INSERT INTO ifa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hi Jacob ya innayunah nan pangayana an inipluynah nangappit hi tuluwan di algo. ");
INSERT INTO ifa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ya inakhupana han bubun. Ya wahdiday malmallo' an dakol an kalneron nun'atluy immohnonganda. Ya hidih nan bubun ya wahdi han ongal an batu hinan ngowabna. ");
INSERT INTO ifa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ta na'amungda'en namin nadan kalnero ya ahi mohpe aanon nadan mumpastol nan batuh nan ngowabna ta uminumda. Ya nalpah'en imminumda on impabangngaddah diyen batuh nan ngowabna. ");
INSERT INTO ifa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ta hi Jacob ya e ni'hapit hinadan mumpastol an alyonay, I'iba, danay bobleh nalpuwanyu? Ya alyonday, Nalpu amih ad Haran. ");
INSERT INTO ifa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ot alyonay, On innilayuh Laban an apapun Nahor? Ya alyonday, O, innilami. ");
INSERT INTO ifa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ot alyon Jacob di, On nganney a'atna? Ya alyonday, Mapmaphod. Ya dayya nan imbabalenan hi Rachel an tuwe an impanguluna nadan kalneroda. ");
INSERT INTO ifa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ya alyon Jacob di, Ot ten agge ni' tee nahdom. Ot adiyu ni' e iyapun tudan kalnero ta pa'inumanyu ni' dida ya imbangngadyuh nan pumpastolanyu. ");
INSERT INTO ifa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ya alyonday, Adi athinay pangatmi te ingganah onda umalin namin nadan kalnero ya ahimi aanon nan batuh nan ngowab nan bubun ta uminumdan namin. ");
INSERT INTO ifa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ya hidin humanahhahapitda ya dimmatong hi Rachel ya nadan ipastolnan kalneron amana. ");
INSERT INTO ifa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ya hidin tinigon Jacob hi Rachel an imbabalen Laban an hi ibban inana ot ume ot ena aanon nan batuh nan ngowab di bubun ta uminumda nan kalneron impanguluna. ");
INSERT INTO ifa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ot umeh awadan Rachel ot awalona ot inayunan kumga an gapuh amlongna. ");
INSERT INTO ifa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ot alyona i Rachel di, Ha\"on ya amuna'ona' i amam an imbabaleya' i Rebekah. Ya muntinnagtaggot hi Rachel ot ena ibaga i amana. ");
INSERT INTO ifa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ya hidin dingngol Laban an hi aman Rachel hidiyen immaliyan nan imbabalen ibbana ot awigingona an e manamun hiya. Ta imme ot awalona ot awitonah baleda. Ot uhuhon mon Jacob an namin nadan na'na'at. ");
INSERT INTO ifa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ya alyon Laban di, Ay da'a damdama nee imbabalen ha\"on. Ot miha\"ad hi Jacob hi baleda hi himbulan. ");
INSERT INTO ifa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ta alyon Laban i Jacob di, Adi gapu ta amuna'on da'a ya namaag ya on da'a puntamtammuwon on ammuna. Ot hiya nan maphod onmu ibaga nan pohdom hi idat'uh bo'laom. ");
INSERT INTO ifa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hi Laban ya waday duwan binabain imbabalena an hay ngadan nan panguluwan ya hi Leah ya hi Rachel nan mi'adwa. ");
INSERT INTO ifa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Hi Leah ya mapmaphod di matana. Mu hi Rachel ya apgohan an maphod di nangadolna. ");
INSERT INTO ifa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ta hay pinpinhod Jacob ya hi Rachel. Ta hiya nan inalinan Laban di, Ta'omman ya nuntamuwa' i he''a hi pituy tawon mu ta iyabulutmun ahawao' hi Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ya inabulut Laban an alyonay, Ot udu'dulnay he''ay pangipa'ahawaa' i hiya mu nadan udum. Ot mihtu ta'u mohtu. ");
INSERT INTO ifa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ta innayun mon Jacob an nuntamu i Laban hi pituy tawon. Mu hidiye ya ay ha atnay algo an gapuh nan ongal an naminhodna i Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ya hidin nalpah nan pituy tawon ot ibagan Jacob i Laban an pohdonan mun'ahawada mo i Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ot ipa'ayag Laban nadan tatagu i diyen boble ot mumpahamul. ");
INSERT INTO ifa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mu i diyen nahdom ya hay e ni'ilo'on Laban i Jacob ya hi Leah. Ta hi Leah di inilo' Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ot idat Laban hi Silpah i Leah ta hiyay tagalana. ");
INSERT INTO ifa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ta hidin nawi\"it ya na'innilaan Jacob an hay inilo'na ya hi Leah. Ot ume i Laban ot alyonay, Tanganu mahan on waha athinah inatmu? Hay intamuwa' ya hi Rachel ya tanganu ona' e inlaylayahhan i he''a? ");
INSERT INTO ifa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ya alyon Laban i hiyay, O te hay pangiye\"emihtu ya mahapul an nan panguluwan di mamangulun mangahawa. ");
INSERT INTO ifa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mu ta'omman ya haddom ta malpah hituwen hindumingguwan an pungkasalanyu i Leah ya ahi' iyabulut hi Rachel. Mu mahapul bon muntamu'an ha''on hi pituy tawon. ");
INSERT INTO ifa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ot iyabulut mon Jacob an malpah hidiyen hindumingguwan ya iyabulut Laban hi Rachel ta ahawaona damdama. ");
INSERT INTO ifa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ot idat Laban hi Bilhah i Rachel ta hiyay tagalana. ");
INSERT INTO ifa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ot mi'ilo' mo boh Jacob i Rachel ya hiyay pohpohdona mu hi Leah. Ot inayunan muntamu i Laban hi pitu boy tawon. ");
INSERT INTO ifa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Hidin tinigon Apu Dios an manghan di naminhod Jacob i Leah an adi umat hi naminhodna i Rachel ya inyabulutna an ma'imbabalayan hi Leah mu ma''id ha imbabalen Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ta numbutyug hi Leah ot mun'ayyam ya lala'i. Ya alyon Leah di, Maphod ta tinigon Apu Dios hituwen ma'ma'at i ha''on ta ad uwani ya mabalin an pohdona' i ahawa'. Ot ngadanana ta hi Ruben. ");
INSERT INTO ifa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Indani bo ya numbutyug ot mun'ayyam bo i han lala'i. Ot alyonay, Maphod ta indat bon Apu Dios hituwen imbabale' te innilanan adiya' pohdon i ahawa'. Ot ngadanana ta hi Simeon. ");
INSERT INTO ifa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ya indani ya numbutyug bo ta nun'ayyam ya lala'i bo. Ot ngadanana ta hi Libay. Ot alyonay, Pinhoda' mahan mo i ahawa' te tulu moy imbabalemin linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ya indani ya numbutyug bo ta nun'ayyam ya lala'i. Ot ngadanana ta hi Judah te alyonay, Ad uwani ya hi Apu Dios di dayawo'. Ya nihipun i diye ya agge mo numbutyug. ");
INSERT INTO ifa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hi Rachel ya ma''id ha imbabalena. Ta lo'tat ya umamoh i ibbana. Ot alyonan Jacob di, Idattana' pibo i ha imbabale'. Te ma\"id'e ya udu'dulna attog di mateya'. ");
INSERT INTO ifa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ya bimmungot hi Jacob i Rachel ot alyonay, Undan ha''on hi Apu Dios? Bokon ha\"on di mangipagol hi em pun'imbabalayan te hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ya alyon Rachel i hiyay, Tehtu tee nan tagala' an hi Bilhah ot e'a mi'ilo' i hiya ta wada'e ha imbabaleyu ya hiyay pun'imbabaleta. ");
INSERT INTO ifa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ta inyabulutna an e mi'ilo' hi Jacob hinan tagalanan hi Bilhah. ");
INSERT INTO ifa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ya nawadaan hi Bilhah ta hidin inyayyamna ya lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ot ngadanan Rachel ta hi Dan. Te alyonay, Maphod ta dingngol Apu Dios nan imbaga' i hiya ta indatna han lala'in pun'imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ya numbutyug boh Bilhah hinan mi'adwa. Ta inyayyamna ya lala'i bo. ");
INSERT INTO ifa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ot ngadanan Rachel ta hi Naptali te alyonay, Handi ya nunhiglay amoh'u i ibba' an gapu ta waday imbabalena mu ad uwani ya indattana' i Apu Dios hi imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mu hidin magibo' Leah an namogpog di punggolangana ya inyabulutnan e mi'ilo' hi Jacob hinan tagalanan hi Silpah. ");
INSERT INTO ifa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ya nawada han imbabaledah nan tagalan Leah an hi Silpah. ");
INSERT INTO ifa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ot ngadanan Leah ta hi Gad te alyonay, Maphod ta nawada boh tuwen imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ya indani ya na'adwa''an ya lala'i bo. ");
INSERT INTO ifa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ot ngadanan Leah ta hi Aser te alyonay, Ongal di pun'am'amlonga' te hay punnomnom mon nadan binabai i ha''on ya ma''am'amlonga'. ");
INSERT INTO ifa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ya i han ahigapas ya immeh Ruben hinan puntanoman ya inakhupana han bungan di mandragora ot alana ta ena idat i inanan hi Leah. Ya hidin mun'odoh Rachel i hiya ");
INSERT INTO ifa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ya alyon Leah di, Undan alyom bo on ta pulhom tun indat nan imbabale' ta umat hi namloham hinan ahawa'. Mu inalin Rachel di, Idattana\"e ya ta'omman ya he''ay pi'ilo'an Jacob hi mahdom. ");
INSERT INTO ifa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ta hidiyen mun'ahdom an hiyah manganamut hi Jacob ot e damuwon Leah. Ot alyonan hiyay, Ha''on di pi'ilo'am hi mahdom te binayadan da'ah nan mandragora an indat nan imbabale'. Ot hiya moy pi'ilo'an Jacob i diyen nahdom. ");
INSERT INTO ifa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ya inabulut Apu Dios nan indasal Leah ta nawadaan hinan mi'alima. Ta hidin inyayyamna ya lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ot ngadanana ta hi Issakar te alyonay, Hi Apu Dios di nangdat hi gungguna' te inyabulut'u an mi'ilo' nan ahawa' hinan tagala'. ");
INSERT INTO ifa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ya indani bo ya numbutyug hi Leah hinan mi'anom. ");
INSERT INTO ifa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ya inyayyamna ya lala'i bo ot ngadanana ta hi Sebulun. Te alyonay, Hanan diyot ta indat Apu Dios ha imbabalemi. Ot pohdona' nin mo i ahawa' te onom mo tayyay imbabalemi. ");
INSERT INTO ifa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ya indani ya nawada han ohan babai ot ngadanana ta hi Dinah. ");
INSERT INTO ifa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ya lo'tat mahan ya ninomnom Apu Dios hi Rachel ya nan indasadasalnan hiya ot iyabulutnan mun'imbabale. ");
INSERT INTO ifa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ta numbutyug ot mun'ayyam ya lala'i. Ot alyonay, Maphod ta indat Apu Dios han imbabale' ta adiya' mo pihulon hinadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ot ngadanana ta hi Joseph ot alyonay, Hanaot ni' ta alina ya adwa''an Apu Dios i ha oha boh lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Hidin wada moh Joseph ya alyon Jacob i Laban di, Ad uwani ya pohdo' an mumbangngad hi boblemi. ");
INSERT INTO ifa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ya awito' tudan ahawa' ya nadan imbabalemi ot na'abbo'lao' mahan dida te innilam di inat'un nuntamuh nan impatamum i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ya alyon Laban i hiyay, Hi'on mabalin ya umohnong ayuhtu. Te hay na'innilaa' hinan mumbuyun ya manu'e anu hi winagahana' i Apu Dios ya gapuh nan awahtum. ");
INSERT INTO ifa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ot ta'on ya imbagam nan pohdom hi bino'lam ta idat'u. ");
INSERT INTO ifa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ya alyon Jacob i hiyay, Innilam di inat'un nuntamuh nan impatamum i ha''on hitun atnay tawon. Ya hay e nahlagan nadan halunmun baka ya nadan udum. ");
INSERT INTO ifa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Te adi athinay dinakoldah din pa\"ali'. Mu maphod ta neen dimmakolda mo te winagahan da'an Apu Dios an gapun ha''on. Ot ad uwani ya mahapul pibon nomnomnomo' ha mabalin hi ato' an mananud hitudan pamilya'. ");
INSERT INTO ifa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ya impidwan Laban an inaliy, Ot ibagam nimpey pohdom an idat'un he\"a hi bino'lam? Ya alyon Jacob di, Adiya' mumbagah bino'la' mu unnudam'e tun alyo' ya ta'omman ya innayun'u an mumpapto' hinadan halunmu. ");
INSERT INTO ifa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mu hay pohdo' ya mabalin'e ya iyabulutmu ta ihiwwe' an namin nadan o\"ongal di bato'da an kalnero ya gulding ya ta'on on nadan kikkitang di bato'dan kalnero ya gulding ta hiyay ay'u bino'la. ");
INSERT INTO ifa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ta hay pidwanah panigam hinan ay'u bino'la ya wada'e ha akhupam hi agge nabato'an hinadan nahiwwen gulding'u ya kalnero' ya na'innilan inala' hinan halunmu. ");
INSERT INTO ifa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ya inabulut Laban hidiyen imbagan Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mu hay inat Laban i diyen algo ya immeh awadan di haluna ot ena ihiwwen namin nadan waday bato'na an gulding ya kalnero ot iyukodnah nadan imbabalenan linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ot iyedah nan nibata\"an ta eda indanallanan dadiyen kalnero ya gulding hi tuluy algo ta adi tigon Jacob. Ta nan binatida ya dadiyey innaynayun Jacob an impapto'. ");
INSERT INTO ifa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ta hay inat Jacob ya wa'et nadatngan di e uminuman nan haluna ya nangalah hapang di nat'onat'on an kayiw on inuplakanay hingkikittang ta pulaw di matigo. ");
INSERT INTO ifa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ya hiyay impahangngabnah nadan way uminumanda te hidiy imminghah punhintatangbalanda. ");
INSERT INTO ifa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ya inatna'ehdi on nabato'andah mangmangitit onu pulaw nadan imbabaleda ");
INSERT INTO ifa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","on inhiwwena dida. Ya nada'en udum an nabato'an ya ena impahangngab hinadan mangitit an bagin Laban ta wan mabato'an nadan imbabaleda. On inhiwwena nadan haluna hinan halun Laban. ");
INSERT INTO ifa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ya hay inatna bo ya munhintatangbalda'e nadan mun'ahdol on inhanggana nan na'uplakan an kayiw hi hinangngabda hinan pun'inumanda ta mun'ahdol bo nadan imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mu adina aton hidih nadan nun'akapuy. Ta lo'tat ya mun'ahdol an namin di halun Jacob ya nadan nun'akapuy i Laban. ");
INSERT INTO ifa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ta lo'tat ya kimmadangyan hi Jacob te dimmakol di haluna ya kemelna ya dongkina ya ta'on on nadan baalna an binabai ya linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hi Jacob ya na'innilaana nan imbagan nadan linala'in imbabalen Laban an alyonday, Namaag udot ya inalan Jacob an namin nadan halun ama ta'u ta hiyay kimmadangyan. ");
INSERT INTO ifa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ya inilmun Jacob an ta'on on hi Laban ya naluman hi adi maphod di pangatna i hiya an adi umat hidin hopapna. ");
INSERT INTO ifa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ta alyon Apu Dios i Jacob di, Mumbangngad'ah nan numboblayan nadan a'ammodmu ya nadan i'ibam ot wadaa' an bumoddang i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ot ipa'ayag mon Jacob da Rachel i Leah ta umedahdi hinan pumpastolana. ");
INSERT INTO ifa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ot alyona i diday, Inilmu' an naluman hi adi maphod nan pangat amayu i ha\"on an adi umat hidin hopapna. Mu maphod ta nan Dios an dayawon ama ya nanongnan wadan bumoddang i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ot da'yu ya innilayun inat'uy abalina' an nangat hi an namin an impatamun amayu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mu hiya damdaman agagga on tinukunga' te imbanahhona nan nunhapitanmin bo'lao'. Mu maphod ta agge inyabulut Apu Dios an eya' dadagon i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ot hay itigana an hi Apu Dios di bimmoddang i ha\"on ya wa'et hay inalin amayu hi bo'lao' ya nadan kikkitang di bato'na an gulding on indani tatawwa ta nun'imbabale nadan gulding on kikkitang di bato'nay imbabaleda. Ya inalina'e bo hi nadan o\"ongal di bato'na on athidi bon o\"ongal di bato'day imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ta paddungnay inalan Apu Dios nan halun amayu ot idatnan ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Te i han pumpatangbalanmi hinadan halun ya anakkaya an ininop'u an waday nun'abato'an hi kikkitang ya o\"ongal an tangbal an gulding ya nun'abato'an bo nadan imbabaleda hi o\"ongal ya kikkitang. ");
INSERT INTO ifa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ya numpatigo nan anghel Apu Dios i diyen nun'inopa' ot ngadanonay ngadan'u. Ot alyo' di, Tanganu Apu Dios? ");
INSERT INTO ifa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ya alyonay, Tigom an namin nadan tangbal an gulding an nadan nun'abato'an hi o\"ongal ya atbohdiy bato' nadan imbabaleda. Ya nada'e bon nun'abato'an hi kikkitang ya athidi boy bato' nadan imbabaleda. Manu'eh athinay ma'ma'at ya tinigo' nan at'aton Laban i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ya alyona boy, Ha''on nan Dios an numpatigon he''ah ad Betel hinan nunha''adam hidin batu ot hiitam hi lana ta panginomnomnomam hinan tinigom ya nan imbagam i ha''on hidi. Ot ad uwani ya mundadaan'a ta ibangngadmu mohpeh nan boblen niyayyamam. ");
INSERT INTO ifa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ya alyon da Rachel i Leah di, Ma''id ahan tatawwa ha ipaboltan amami i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Namaag ya ay da'mi bokon imbabale. Ta ay da'mi inihbut ot umahonan namin nan namayadda i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mu ta'on ot an namin nadan kinadangyan an inalan Apu Dios i hiya ya bagi ta'un namin hitudan imbabale ta'u. Ot agam ta atom nan imbagan Apu Dios an atom. ");
INSERT INTO ifa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ta nun'itakken Jacob nadan imbabaleda ya nadan ahawana hinan kemel. ");
INSERT INTO ifa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ot makakdan umeh ad Kanaan an boblen amana an impipanguluna nadan haluna ya nadan indadaana an mahapulda an inamungnah awadanahdi hi ad Paddan-Aram. ");
INSERT INTO ifa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mu hi Rachel ya ni'yalana nan bulul amanah din eda numpukis hi kalnero. ");
INSERT INTO ifa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ya de bo udot an agge impa'in'innilan Jacob i Laban nan bumtikanda ");
INSERT INTO ifa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","an inodnandan namin nadan wadan dida. Ta hidin inagwatda nan wangwang an nungngadan hi Euprates ot inayundah nan nun'abillid an bobleh ad Gilead. ");
INSERT INTO ifa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hidin mi'atluh algoh nakakan da Jacob ya waday nangipa'innilan Laban i diyen binumtikanda. ");
INSERT INTO ifa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ot pun'ayagana mo nadan tulangna ot tundonda da Jacob. Ta hidin mi'apituh algo ya inakhupanda didah nan nun'abillid an bobleh ad Gilead. ");
INSERT INTO ifa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mu hidiyen nahdom ya numpa'inop hi Apu Dios i Laban ot alyonan hiyay, Tigom ta ma\"id ha ibagam hi adi maphod i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ta nun'allung da Jacob hinan nun'abillid an boble hi ad Gilead hidin ni'akhup da Laban ot mun'allungda damdama i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ot umeh Laban hi awadan Jacob ot alyonay, Tanganu on waha athinah inatmu ta namaag ya inlaylayahhana' ot ibtikmu tudan imbabale' ta aymu binalud didah gubat? ");
INSERT INTO ifa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tanganu onmu agge imbagbaga ta binumtik ayu? Onha imbagayu ot wan indadaan'u ha pun'am'amlongan ta'un namin ya ahi da'mi taynan. ");
INSERT INTO ifa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Namaag ya aggeya' indattan hi waya' an ni'hahhahapit hitudan apapu' ya tudan imbabale' ta ahi ta'u munhihi''an. Adi maphod hinaen inatmu. ");
INSERT INTO ifa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Undan aggem innilan abalina' an mangat hi adi maphod i he''a onha agge numpa'inop hidin nahdom hi Apu Dios an dayawon amam ot alyonay tigom ta ma\"id ha ibagam hi adi maphod i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mu ta'onot boh on athinay inatmu an lummuh aptum an umanamut hi awadan da amam mu ta aggeyu ni'yako nadan bulul hi balemi. ");
INSERT INTO ifa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ya alyon Jacob i hiyay, Manu'eh inat'uhtu ya tumakuta' hi pangipagolam hitudan imbabalem. ");
INSERT INTO ifa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mu nan alyom an bubulbullul ya hama'om ta alina'e hi inakhupanyu ya ta'on attog on mipapate nan nangako. Ya wada'ey udum hi bagim hi akhupam ya tinuddum ta punhintiggan tudan ibba ta'u. Mu hi Jacob ya aggena innilan hi Rachel di nangalah nadan bulul. ");
INSERT INTO ifa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ta inhipun Laban an nunlikiha hinan nun'allungan Jacob ot ahi hi Leah ya nan duwan tagala mu ma''id ha inakhupana. Ot ihiwna mohpeh nan nun'allungan Rachel ");
INSERT INTO ifa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","mu ma''id damdama ha inakhupana. Te hi Rachel an hiya nan nangala ya inuhbungnah nan inumbunanah nan nitakkayanah nan kemel. ");
INSERT INTO ifa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ot alyona i amanay, Hanat adi'a bumungot i ha\"on ama hi'on adiya' tuma'dog hitun inumbuna' te wada othadiy ma'iho. Ta hiya nan ma''id ha inakhupan Laban. ");
INSERT INTO ifa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ta bimmungot moh Jacob ot alyona i Laban di, Undan nganney bahul'u i he\"a ta tinnuda'? ");
INSERT INTO ifa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ot nen nalpah an ma\"id ha aggem linikihah nadan bagimi ya agam mohpe ta ipatigom nan inakhupam an bagim ta punhintiggan ta'uh nadan nun'ibbam ya nadan tulangmu ta diday ukod an mangibaga hi'on nganne i ditan duway numbahul. ");
INSERT INTO ifa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ot alyona boy, Nuntamuwa' i he\"a hi baintiy (20) tawon ot ipanapto''u nadan halunmu ta dimmakolda. Mu ma\"id ha pinalti' ni'mo hi inihda'. ");
INSERT INTO ifa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ya ta'on on nan pinaten di layon ya agge' inyalin he''a te ha\"on di numbayad. Ya atbohdin an namin di natala' an ta'on on bokon'u bahul on impahukkatmun ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ya nunhiglay nangitpo'itpola' hinan potang ya kotol hi'on nahdom ya niddum di timmukatukala'. ");
INSERT INTO ifa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ta athi'athinay na'at i ha''on hitun immen baintiy (20) tawon te himpulut opat (14) di tawon di namo'laa' hitudan duwan imbabalem ya onom di tawon hitudan halunmu. Ya numpihimpuluy (10) nanukungam i ha\"on ta imbanahhom nadan nunhapitantan bo'lao'. ");
INSERT INTO ifa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ot onha bokon hi Apu Dios an dayawon nadan a'ammod'u an hi Abraham ya hi Isaac di bimmoddang i ha\"on ot wan intuda'a' an ma''id ha indatmun ha''on. Mu maphod ta tinigon Apu Dios nan napalpaligata' ya nan inat'un nuntamu ta hiya nan pinadananan he''ah din nahdom ta ma\"id ha adi maphod hi ibagam. ");
INSERT INTO ifa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Alyon Laban di, Tun binabai ya i'imbabale' ya a'apapu' tudan imbabaleda. Ya ta'on on tun halun ya bagi'. Ot adi mabalin hi waday ato' hi adi maphod hitun i'imbabale' ya tudan a'apapu'. ");
INSERT INTO ifa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ta hiya nan mahapul di munhapittah maphod ta nan abulutontan duwa di hiyay ma'at. Ot amungonta dohah nadan batu ta mangipanomnom an adita ibahho nan punhapitanta. ");
INSERT INTO ifa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ot alan Jacob han batu ot ha''adona ta panginomnomana i diyen na'at. ");
INSERT INTO ifa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ot ibaganah nadan ibbana ta eda mangalah batu ot amungonda. Ot ahida mangan da Laban i Jacob hinan haggon diyen na'amung an batu. ");
INSERT INTO ifa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ot ngadanan Laban hidiyen na'amung an batu hinan hapitda ta hi ad Jegar-Sahaduta ot ngadanan bon Jacob ta hi ad Galeed. ");
INSERT INTO ifa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ya alyon Laban di, Hituwen na'amung an batu di panginomnomnomantan duwa. Ta hidiyey gapunah nangadanan hidiyen luta hi Galeed. ");
INSERT INTO ifa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ya nangadanan bo ta hi ad Mispah te hay nangalyan Laban di, Hi Apu Dios di manmannigon ditan duwa ta wan nan nunhapitantay ma'at an ta'on onta mundawwiyan. ");
INSERT INTO ifa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ya alina'eh paligatom tudan i'imbabale' ya nangahawa'ah udum an ta'on on adi' innilaon ya nomnomnomom an hi Apu Dios di manmannigon he''a. ");
INSERT INTO ifa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ot nomnomnomonta ta hituwen inamung ta'un batu ya nan naha\"ad an batu hitun numbattananta ");
INSERT INTO ifa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","di tistiguta an adi mabalin hi la\"uha' hituwe ta waha ato' i he\"a hi adi maphod. Ya atbohdin he\"a an adi mabalin hi la\"uham ta waha atom i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ot hanat nan Dios an dayawon da Abraham i Nahor di ukod an mundusah nan mangibahho ituwen nunhapitanta. Ot abuluton Jacob ot munsapatah nan Dios an un'unudon amanan hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ot i'nong Jacob han animal i Apu Dios hidih nan nabillid ot ayagana nadan ibbana ta mangandan namin. Ot hidiy umohnonganda i diyen nahdom. ");
INSERT INTO ifa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ta on nawi\"it ot bumangon hi Laban ot awalona nadan imbabalena ya nadan apapuna ot wagahana dida ot ahi umanamut. ");
INSERT INTO ifa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ot inayun da Jacob an umeh nan pangayanda ya alinah on wadaday anghel Apu Dios an nidamun dida. ");
INSERT INTO ifa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ta hidin tinigon Jacob dida ya alyonay, Datuwe nadan titindalun Apu Dios. Ot ngadananah diyen lutah ad Mahanaim. ");
INSERT INTO ifa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ya hidiy nangipamanguluwan Jacob hinadan umeh awadan ibbanan hi Esau hi ad Edom ");
INSERT INTO ifa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","an alyonay, Ume ayu ya inaliyu i Esau di, Nan baalmun hi Jacob ya pohdonan ipa'innilan he''a an hay balen da ulitauyun hi Laban di ena nihaha''adan ta hiya nan agge numbangngad ta ingganah ad uwani. ");
INSERT INTO ifa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ot ten ad uwani ya dakol di halunan kalnero ya baka ya kabayu ya gulding ya atbohdin dimmakolday baalnah linala'i ya binabai. Ya impamangulu da'mi ta ipa'innilamin he''ay umaliyanda hi'on abulutom. Ta ona imbagah diye ot ahida ume. ");
INSERT INTO ifa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ya hidin numbangngad dadiyen hinnagna ya alyondan Jacob di, Impa'innilamin ibbam ot ten tuwedan damuwon dita'u an in'uyugnay opat di gahut (400) an linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ya timmakut hi Jacob hi nangngolana i diye. Ta hay inatna ya ginodwana nadan nun'ibbana ya nadan haluna ta nunduway grupu. ");
INSERT INTO ifa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Te hay nomnomna ya alyonay, Alina'eh umalida ya pumateda ya mabalin an bumtikda ni'mo nadan na'udin grupu. ");
INSERT INTO ifa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ot mundasal an alyonay, He''a Apu Dios an dinayaw apu an hi Abraham ya hi ama an hi Isaac ya he''ay nangali an mumbangngada' hinan numboblayan nadan a'ammod'u ya nadan i'iba' ta ukod'an mangipapto' i ha''on. ");
INSERT INTO ifa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ot ten hiyay inatmu te innaynayunmun nangipatigoh ulem i ha''on an baalmu an ta'on ona' na'adda''ul. Ya hidin nakaka' hi balemi an ini'wa' hinan wangwang an nungngadan hi Jordan ya ammunay hu''ud'u an inodna'. Mu nunholagona' ta teen ad uwani ya numbalin ami hi duway grupu. ");
INSERT INTO ifa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ot hanat ihwang da'mi bahan hi'on waday adi maphod an ninomnom ibba' an hi Esau hi atona. Te nunhigla tayyay e' tumakutan te alinah umali ya numpate da'min namin an ta'on on tudan ahawa' ya i'imbabale'. ");
INSERT INTO ifa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mu hay imbagam ya alyom hi ipapto'a' ya wagaham nadan holag'u ta dumakoldan umat hi dinakol di panag hinan da'ging di baybay an adi mabilang. ");
INSERT INTO ifa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ot umohnongdahdi i diyen nahdom. Ya ninomnomnan wada ha idatnan ibbanan hi Esau ot ihiwwena dohah nadan haluna ta idatna i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ta hay inhiwwena ya duway gahut (200) di tinnan gulding ya baintiy (20) tangbal ya duway gahut (200) di tinnan kalnero ya baintiy (20) tangbal ");
INSERT INTO ifa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ya tulumpuluy (30) tinnan kemel ya nan inlumda ya napat (40) di baka ya himpuluy (10) bulug an baka ya baintiy (20) tinnan dongki ya himpuluy (10) tangbal. ");
INSERT INTO ifa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ta danaen midat di impamangulunah nadan baalna an nahiwwehiwweda. Ot alyonah nadan baalnay, Mamangulu ayu ya tigonyu ta mahohonnod ayu muta waday pumbabattanan ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ot alyonah nan namangulun baal di, Damuwom'eh Esau ta ibaganay ud halun i datuwe ya hay ud baal i he''a ya danay pangayam ");
INSERT INTO ifa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ya alyom i hiyay, Datuwe ya halun nan baalmun hi Jacob an idatnan he''a. Ot ten tuweda an na'udida. ");
INSERT INTO ifa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ta athidiy imbaganah an namin nadan baalnan impamanguluna. ");
INSERT INTO ifa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ot ipidwanan alyon i diday, Adiyu bahan linglingon an alyon i hiyay, Tuweda an na'udida. Te hay ninomnom Jacob ya alyonay ta damunah pundammuwanda ya alina hi ma'ubayah di bungot ibbanan hiya an lummu i dadiyen idatna. ");
INSERT INTO ifa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ta impamanguluna dida yaden immappaldahdi i diyen nahdom. ");
INSERT INTO ifa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ta on nahdom ot pamanguluwona nan duwan ahawana ya nan hinohhan tagalada ya nan himpulut ohan (11) imbabalena ot agwatonda nan wangwang an nungngadan hi Jabbok. ");
INSERT INTO ifa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ot ahi mohpe mumbangngad hinan immappalanda ot ipa'agwatnan namin nadan gina'uda. ");
INSERT INTO ifa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ta hiya ya abuh di nabati. Ya alinah on immali han lala'i ot bumanultungda ta ingganah din mun'abigat. ");
INSERT INTO ifa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mu hidin inilmun diyen lala'in adi damdama pa'a''abak i Jacob ot gopakona nan nun'ummuman di kalakan Jacob ta na'umpuh nan tungal. ");
INSERT INTO ifa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ot alyonay, Ipa'eya' mohpe te tuwen mawi\"it. Ya alyon Jacob di, Adi da'a ipa'e ta ingganah ona' wagahan i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ya alyon diyen lala'i di, Nganney ngadanmu? Ya alyonay, Ha''on hi Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ya alyon diyen lala'i di, Mihipun hi ad uwani ya bokon mo he''ah Jacob ta he''ah Israel. Te paddungnay ni'bultung'a i Apu Dios ya nadan tatagu ot mangabak'a. ");
INSERT INTO ifa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ya mahmahan Jacob di ngadana mu alyonay, Adi mahapul an ibaga' di ngadan'u. Ot inayunan wagahan hi Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ot ngadanan Jacob hidiyen boble ta hi ad Peniel. Te alyonay, Tinigo' di angah Apu Dios mu maphod ta aggeya' nate. ");
INSERT INTO ifa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ta on manulu nan algo ot makak hi Jacob hidih ad Peniel ya munggi'yagi'yad te nan na'umpuh an kalakana. ");
INSERT INTO ifa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ta hiya nan ingganah ad uwani ya adi ihdan nadan tinanud Israel nan nun'ummunan di kalakan nan kumpulnan mapalti te hidiyey nagpak i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Indani ya nangimangmangan Jacob hi Esau an didah nadan opat di gahut (400) an linala'in in'uyugna. Ot pun'u'uyyugona nadan imbabalena hinadan hi inada an umat i Leah ya hi Rachel ya nadan duwan tagala. ");
INSERT INTO ifa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ot ipamanguluna nadan duwan tagala an in'uyugda nadan imbabaleda ot ahi da Leah ya nadan imbabalena ot ahi mohpe da Rachel i Joseph an in'udina. ");
INSERT INTO ifa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ot hiyay mamangulun midamu i ibbanan hi Esau ot munyu''ung hi numpipitu. ");
INSERT INTO ifa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mu tinagtag Esau an ena pundamu ot inayunan awalon hi ibbanan hi Jacob an mungkogada. ");
INSERT INTO ifa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ya hidin intangad Esau ta tinigona nadan binabai ya nadan u''unga ya alyonay, Nganne datuwen nun'ibbam? Ya alyon Jacob di, Datuwe nadan i'imbabale' an indat Apu Dios an gapuh homo'na. ");
INSERT INTO ifa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ot umeda nadan duwan tagala ya nadan imbabaleda an eda nihaggon ot munyu''ungdah hinangngab Esau. ");
INSERT INTO ifa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ya nitnudda bo da Leah an hini'inna ot munyu''ungda bo ot ahi mohpe da Rachel an hinina i Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ya mahmahan bon Esau an alyonay, Ya nadan dinamumi'e an halun ya nganney pohdom an ibaga i diye? Ya alyon Jacob di, O dadiye nan ninomnom'un idat i he''a ta wan abulutom di umaliyanmi. ");
INSERT INTO ifa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mu alyon Esau i hiyay, Ibba' adi' mahapul dadiye te dakol damdamay halun'u ot bangngadommot. ");
INSERT INTO ifa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ya alyon Jacob di, Hi'on abulutom di immanamutanmi ya hanat abulutom damdama dadiyen idat'u. Te ad uwanin naniga' hi angahmu ya paddungnay tinigo' hi Apu Dios an namamah nan nangipatigam hi apngam i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ta hiya nan pohdo' an alam dadiyen idat'un he\"a te dakol tun halun'u an gapu ta himmo'a' i Apu Dios. Ya lo'tat ya nihapitan hi Esau ot abulutona. ");
INSERT INTO ifa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ot alyon Esau di, Ume ta'u mon namin ta ipangulumi nan pangi'wanyu. ");
INSERT INTO ifa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mu alyon Jacob di, Mammanogda ni' tun u''unga an adida kummu. Ya ta'on on tudan halun ya honanon'e dida ya mun'a'ateda. ");
INSERT INTO ifa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ot udu'dulna attog on ayu mahhun ta ta'on on ami mun'ul'ulle ta nangamung hinah dumatnganmih ad Edom. ");
INSERT INTO ifa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ya alyon bon Esau di, Ot mabatida mo dohah tun ibba' an linala'i ta bumoddangdan da'yu. Mu alyon Jacob di, Adi mahapul hinae mu ta athinan inapngaa'. ");
INSERT INTO ifa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ot ibangngad mon da Esau hi ad Edom i diyen algo. ");
INSERT INTO ifa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaden imme da Jacob hi ad Sukkot ot hidiy pangiphodandah allungda ya ha punhiduman nadan haluna. Ta hiya nan nginadananda hi ad Sukkot. ");
INSERT INTO ifa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ot ahida inayun bon um'umme ta ingganaot dumatongdah ad Sekem hidih ad Kanaan. Ta nihipun hi nakakandah ad Paddan-Aram ya mapmaphodda ta ingganah dimmatongdah ad Sekem. Ot umappaldah nan nihaggon i han boble. ");
INSERT INTO ifa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ya hidiyen luta an immappalanda ya ginattangnah hinggahut (100) di gumo' an pihhu hinan holag Hamor an hi aman Sekem. ");
INSERT INTO ifa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ot iphodna han punggobhan hi mi'nong i Apu Dios ot ngadananah El-Elohe-Israel an hay ibalinana ya nan Dios an dayawon Israel. ");
INSERT INTO ifa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Han hin'algo ya imme nan babain imbabalen da Jacob i Leah an hi Dinah an e ni'yay'ayyam hinadan binabai i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mu hidin tinigon Sekem an hi na' Hamor an tinanud Hib ya imme ot dopapona ot pilitonan ilo'. Hi Hamor ya hiyay ibilangdah ap'apu i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Hi Sekem ya na'appinhodnah Dinah ot ihaphapitana ta mun'ahawada. ");
INSERT INTO ifa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ot ibagana bo i amanan hi Hamor an alyonay, Eya' di anu ihapit hinan a'ammodna te pinhod'un ahawaon hiya. ");
INSERT INTO ifa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mu hidin dingngol Jacob hidiyen adi maphod an na'at hinan imbabalena ya namaag ni' ot dindinnongan an ihodnah umanamutan nadan linala'in imbabalenan e numpastol. ");
INSERT INTO ifa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ya e ni'hapit hi aman Sekem an hi Hamor i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ya dimmatong nadan linala'in imbabalen Jacob an nalpuh nan puntanoman. Ta dingngoldah diyen na'at ya nangimbubbungotda hinan inat Sekem hinan hi ibbadan hi Dinah an pinilitnan inilo'. ");
INSERT INTO ifa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mu alyon Hamor i Jacob di, Mu nan imbabale' an hi Sekem ya nunhiglay naminhodnah nan imbabalem an hi Dinah. Daan mo bahan ta iyabulutmu ta mun'ahawada. ");
INSERT INTO ifa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ta mi'yapu ayun da'mi ta mabalin bon mi'yahawada nadan linala'iyuh nadan i wahtun binabai. ");
INSERT INTO ifa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ta hituy nanongnah punhituwanyu. Ya ukod ayun mamto' hinan pohdonyun e iha''adan ituwen boble. Ot ma''id ha mangipagol i da'yu hinan pohdonyun e puntamuwan ta way atonyun kumadangyan. ");
INSERT INTO ifa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ya hi Sekem ya inibbaanah amanan immehdi ot alyona i Jacob ya nadan i'iban Dinah di, Mumpahpahmo'a' i da'yu ta wan iyabulutyu bahan an ahawao' hi Dinah. Ya ibagayu nan pohdonyun idat'u i da'yu ta idat'u. ");
INSERT INTO ifa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ya adi ayu mun'og'ogon an mangibaga te idat'u an ta'on hi atnay alyonyu mu ta iyabulutyun ahawao' hi Dinah. ");
INSERT INTO ifa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ya gapuh nan inat Sekem i Dinah ya inambun nadan imbabalen Jacob didan hin'ama. ");
INSERT INTO ifa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Te alyonday, O mu adi mabalin hi mi'yahawa nan ibamin babai i ha agge nakugit te adi maphod i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mu onha abulutonyu ta mumpakugit ayun namin an linala'i ta umat ayu i da'mi ot mabalin an iyabulutmi. ");
INSERT INTO ifa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ta wan mi'yapu amin da'yu ya nangahawa amih nadan i wahtun binabai ta nanongnan hituy pi'hituwanmih tun bobleyu. ");
INSERT INTO ifa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mu adiyu'e tuwali unnudan hinaen imbagami ta adi ayu mumpakugit an linala'i ya udu'dulnay awitonmi nan ibamin babai ya immaan ami attog hitu. ");
INSERT INTO ifa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ya inabulut da Sekem an hin'ama hidiyen imbagada te maphod hi nangngolanda. ");
INSERT INTO ifa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ta hi Sekem an hiya ahan di lispituwondah nan nunhituwanda ya pohdonan e mumpakugit an gapuh nan ongal an naminhodnah nan imbabalen Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ot ma'anneda mon hin'ama i Hamor hinan a'am'amungan nadan tataguh nan way hawwangon i diyen boble ot ibagadah nadan linala'in alyonday, ");
INSERT INTO ifa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Datuwen immalihtun linala'i ya mapmaphod di pi'hayyupandan dita'u. Ot maphod onda mi'hitun dita'uh tun numboblayan ta'u te abillog tun boble ta'u ot ukoddah nan atondan umat hi pungkumilhuwanda. Ya maphod bo on ahawaon tun linala'i nadan binabain imbabaleda ya atbohdih nadan binabaihtu an mabalin hi ahawaon nadan linala'ida ta mi'yapu ta'un dida ya ta'on on dida ya mi'yapuda i dita'u. ");
INSERT INTO ifa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mu hay imbagada ya gahin anuh on mumpakugit ta'un namin an linala'i ta umat i dida ya ahida abuluton hinae. ");
INSERT INTO ifa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ot undan adiyu pohdon hinae ta munhitudahtu ta wan an namin nadan halunda ya nadan udum an wada i dida ya bagi ta'un namin. ");
INSERT INTO ifa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ya an naminda i diyen boble ya inabulutdah diyen imbagan da Hamor i Sekem ot mumpakugitdan namin nadan linala'i. ");
INSERT INTO ifa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mu hidin mi'atluh algo an linum'a' nan kugitda ya inikak da Simeon i Libay an i'iban Dinah di hinalungda ot umedah nan boble ot pumpatedan namin nadan linala'i ");
INSERT INTO ifa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","an ni'pateda da Sekem i Hamor an hin'ama. Ta on nalpah ot awitondah Dinah ot makakda. ");
INSERT INTO ifa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ot mihukkatda mo bo nadan udum an imbabalen Jacob i dida ");
INSERT INTO ifa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ot eda pun'ala nadan akhupandahdi an umat hi halun ya an namin nadan wada i diyen boble ta pangiballohdah nan na'at hinan hi ibbadan babai. ");
INSERT INTO ifa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ta nun'alada nadan kinadangyandah nadan numpunhituwanda ya ta'on on nadan u''unga ya binabai. ");
INSERT INTO ifa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ot alyon Jacob i da Simeon i Libay di, Namaag nee ya eyu inat ha athinah gumalat hi humihiwawan nadan tataguh tun ha''on. Ta onha mun'u'uddum nadan tinanud Kanaan ya nadan tinanud Peris ya immalida ta gubaton dita'u ot undan mahan adi dita'u abakon an oh'ohha ta'u. Ya nganne moy adi ta'u adadagan an namin. ");
INSERT INTO ifa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mu alyonday, Bahulda te tanganu tuwalih on ay e mumpabpabbayad hi adolnah ibbami ta athidiy nangatda i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Indani ya alyon Apu Dios i Jacob di, Makak ayu ta ume ayuh ad Betel ta hidiy eyu iha''adan. Ta iphodmuhdi ha punggobhanyuh mi'nong i ha''on an Dios an ha\"on din numpatigon he''a hidin binumtikam hi bimmungotan ibbam an hi Esau i he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ot pun'ibagan Jacob mo i didan hina'amma ya an namin nadan nun'ibbada an alyonay, Pumpa''ihyu nadan bulul an inodnanyu ya inatyu nan mahapul an atonyu ta mibilang ayuh malinis ya hinukkatanyu nadan lubungyu. ");
INSERT INTO ifa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Te mahapul an ume ta'uh ad Betel ta e ta'u iphod ha punggobhan hi mi'nong i Apu Dios an namoddaboddang i ha\"on hinadan numpalpaligata' ya nangipanapto' i ha\"on hi an namin an nangaya'. ");
INSERT INTO ifa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ot idatda i Jacob an namin nadan bulul an wadan dida ya ta'on on nadan hingatda ot ika''utnah nan way pu''un di kayiw an oak hi ad Sekem. ");
INSERT INTO ifa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ya hidin nakakanda ya hi Apu Dios di nangipatakut hinadan tataguh nan nun'ihaggon an boblen inwada. Ta ma''id ha inatda i da Jacob hi adi maphod ");
INSERT INTO ifa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ta inggana ot dumatongdah ad Lus an hay ohah ngadana ya hi ad Betel hidih ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ot iphod Jacob han punggobhan hi mi'nong i Apu Dios ot ngadanana ta ad El-Betel te hidiy nangipa'innilaan Apu Dios hi a'atna i hiyah din binumtikana an gapuh bungot ibbanan hi Esau. ");
INSERT INTO ifa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Indani ya nate nan nangipanapto' i Rebekah an hi Deborah ot eda ilubu' hinan pu''un nan kayiw an oak hi da''ul di ad Betel. Ot ngadanandah diye hi Pungngulngulan. ");
INSERT INTO ifa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Hidin nibangngadan Jacob hi nalpuwanah ad Paddan-Aram ya alina boh on numpatigoh Apu Dios i hiya ot wagahana ");
INSERT INTO ifa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","an alyonay, Hay ngadanmu ya hi Jacob mu ngadanan da'a ta he''ah Israel. Ta hiya moy ngadana. ");
INSERT INTO ifa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ya alyon bon Apu Dios di, Ha''on nan ongal di abalinanan Dios ot punholagon da'ah dakol. Ta dumakolda ta mumbalindah boble ya patul di udum i dida. ");
INSERT INTO ifa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ya hituwen boblen indat'uh nadan a'ammodmun da Abraham i Isaac ya ipaboltan'un he''a ya nadan tanudam. ");
INSERT INTO ifa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ta hidin nalpah an inalin Apu Dios hidiye ot ahi umaan hidi. ");
INSERT INTO ifa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ot e mangalah Jacob hi batu ot ha''adonahdih nan potto' di nanigana i Apu Dios ta panginomnomnomana i diyen na'at ot kuyaganah bayah ya lana. ");
INSERT INTO ifa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ot ngadanana nimpe ta hi ad Betel. ");
INSERT INTO ifa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Indani ya inhi'al da Jacob an taynan hi ad Betel ot ipluydah ad Eprat. Mu hidin aggeda ni' dimmatong hi ad Eprat ya nadatngan di pun'ayyaman Rachel mu ma'aliggatan. ");
INSERT INTO ifa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ya ta'on on ma'aliggatan an mun'ayyam ya bimmuduh nan golang ot alyon nan babain nundawat i hiyay, Maphod ta lala'i bo tun inyayyammu. ");
INSERT INTO ifa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mu hi Rachel ya mun'aguyud di yahyahna an mate ot ikutyamna an hay pungngadandah nan golang ya hi Ben-Oni. Mu hay nungngadan Jacob ya hi Benjamin. ");
INSERT INTO ifa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ta nateh Rachel hidih nan way awon an umeh ad Eprat an hay ngadanah ad uwani ya hi ad Bethlehem. ");
INSERT INTO ifa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ot ha''adon Jacob han batu hinan nilubu'ana ta panginomnomnomana ta ingganah ad uwani ya wahdih diyen batu. ");
INSERT INTO ifa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hidin nalpah ot inayun da Jacob an hay ohah ngadana ya hi Israel an numbaat. Ot eda umappal hi daggah di ad Migdal-Eder. ");
INSERT INTO ifa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ta hidiy nangilo'an Ruben hinan ohan imbilang amana hi ahawana an hi Bilhah. Ya na'innilaan Jacob hidiyen inatna. Hi Jacob ya himpuludat duway (12) linala'in imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Te hay imbabaleda i Leah ya hi Ruben an panguluwan ot ahi hi Simeon ot ahi hi Libay ot ahi hi Judah ot ahi hi Issakar ot ahi hi Sebulun. ");
INSERT INTO ifa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ya hay imbabaleda i Rachel ya da Joseph i Benjamin. ");
INSERT INTO ifa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ya hay imbabaledah nan tagalan Rachel an hi Bilhah ya da Dan i Naptali. ");
INSERT INTO ifa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ya hay imbabaledah nan tagalan Leah an hi Silpah ya da Gad i Aser. An namin danae ya niyayyamdah ad Paddan-Aram an ammunah Benjamin an niyayyam hinan awon. ");
INSERT INTO ifa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Immanamut da Jacob hi awadan da amanan hi Isaac an nunnanong hidin nunhituwan amanan hi Abraham hi ad Mamre an hay ohah ngadana ya hi ad Hebron. ");
INSERT INTO ifa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ta hi Isaac ya hinggahut ta nawaluy (180) tawona ");
INSERT INTO ifa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ot ahi mate an na'a\"am'amma mo. Ot e ilubu' nadan imbabalenan da Esau i Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hi Esau an hay ohah ngadana ya hi Edom ya datuwe nadan holagna. ");
INSERT INTO ifa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Hay inahawana ya nadan binabain i Kanaan an hi Adah an hi na' Elon an tinanud Hit ya hi Oholibamah an hi na' Anah an apapun han hi Sibeon an tinanud Hib ");
INSERT INTO ifa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ya hi Basemat ya hi ibban Nebayot an imbabalen ulitaunan hi Ismael. ");
INSERT INTO ifa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Hay imbabaleda i Adah ya hi Elipas. Ya hay imbabaleda i Basemat ya hi Rewel. ");
INSERT INTO ifa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ya hay imbabaleda i Oholibamah ya da Jeuh ya hi Jalam ya hi Korah. Ta datuwey linala'in imbabalen Esau an niyayyam hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Indani ya inawit Esau nadan ahawana ya nadan imbabalenan linala'i ya binabai ya an namin nadan nunhituh balena ya ta'on on nadan animalda ya an namin nadan wada i dida ot makakdahdi ot umeda i han nat'on an boble an nidawwih awadan ibbanan hi Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Te adi mo umdah ad Kanaan hi pumpastolanda te dimmakol moy halundan hinagi. ");
INSERT INTO ifa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ta e nunhitu da Esau hinan nun'abillid an boble hi ad Seir. ");
INSERT INTO ifa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ta hi Esau an ammod nadan i Edom hinan nun'abillid hi ad Seir ya datuwey holagna. ");
INSERT INTO ifa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hay lala'ih imbabalen da Esau i Adah ya hi Elipas. Ya hay lala'ih imbabalen da Esau i Basemat ya hi Rewel. ");
INSERT INTO ifa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ya hay linala'ih imbabalen Elipas ya hi Teman ya hi Omar ya hi Sepo ya hi Gatam ya hi Kenas. ");
INSERT INTO ifa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Mu hi Elipas ya waday imbilangnah ahawana an hi Timma ta wadah Amalek an imbabaleda. Ta datuwey apapun da Esau i Adah. ");
INSERT INTO ifa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ya hi Rewel ya nunholag bo ta nawadaday linala'in imbabalena an da Nahat ya hi Serah ya hi Sammah ya hi Missah. Ta diday apapun da Esau i Basemat. ");
INSERT INTO ifa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ya hi Oholibamah an imbabalen Anah an apapun Sibeon ya hay linala'in imbabaleda i Esau ya da Jeus ya hi Jalam ya hi Korah. ");
INSERT INTO ifa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ta datuwe nadan ap'apu an tinanudan Esau. Hay a'ap'apu hinan panguluwan an imbabalen Esau an hi Elipas ya hi Teman ya hi Omar ya hi Sepo ya hi Kenas ");
INSERT INTO ifa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ya hi Korah ya hi Gatam ya hi Amalek. Datuwe ya apapun da Edom i Adah. ");
INSERT INTO ifa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ya hay a'ap'apu an imbabalen Rewel an imbabalen Esau ya hi Nahat ya hi Serah ya hi Sammah ya hi Missah. ");
INSERT INTO ifa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ya hay a'ap'apu an imbabalen da Esau i Oholibamah an imbabalen Anah ya hi Jeus ya hi Jalam ya hi Korah. ");
INSERT INTO ifa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","An namin datuwen ap'apu ya imbabalen Esau an hay ohah ngadana ya hi Edom. ");
INSERT INTO ifa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hanadan tatagun nunhitu tuwalih nan boblen immayan da Edom ya nadan tinanud Seir an imbabalen Hor. Ya hay linala'ih imbabalen Seir ya hi Lotan ya hi Sobal ya hi Sibeon ya hi Anah ");
INSERT INTO ifa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ya hi Dison ya hi Eser ya hi Disan. Ta diday ap'apu hinadan tinanud Hor. ");
INSERT INTO ifa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ya hi Lotan ya hay linala'ih imbabalena ya da Hori i Homan. Ya waday babai an hi ibban Lotan an hi Timna. ");
INSERT INTO ifa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ya hay linala'ih imbabalen Sobal ya hi Alban ya hi Manahat ya hi Ebal ya hi Sepo ya hi Onam. ");
INSERT INTO ifa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ya hi Sibeon ya hay linala'ih imbabalena ya da Ayah i Anah. Ya hituwen hi Anah ya hiyay nanama' hinan mun'utbul an ma\"atung an danum hidin ena impastol nadan dongkin amanah nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Hay imbabalen Anah ya hi Dison ya nan babai an hi Oholibamah. ");
INSERT INTO ifa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ya hi Dison ya hay linala'ih imbabalena ya hi Hemdan ya hi Esban ya hi Itran ya hi Keran. ");
INSERT INTO ifa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ya hi Eser ya hay linala'ih imbabalena ya hi Bilhan ya hi Saaban ya hi Akan. ");
INSERT INTO ifa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ya hay linala'ih imbabalen Disan ya hi Us ya hi Aran. ");
INSERT INTO ifa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ta hay a'ap'apun nadan tinanud Hor ya hi Lotan ya hi Sobal ya hi Sibeon ya hi Anah ");
INSERT INTO ifa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ya hi Dison ya hi Eser ya hi Disan. Ta diday nun'ap'apu hi ad Seir. ");
INSERT INTO ifa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hidin ma\"id ni' ha patul nadan tinanud Israel ya wadada mo tuwaliy numpatul hi ad Edom. ");
INSERT INTO ifa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ta hay patul hi ad Edom ya hi Bela an imbabalen Beor an hay nunhituwana ya hi ad Dinhabah hidih ad Edom. ");
INSERT INTO ifa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ya hidin nateh Bela ya nihukkat an numpatul hi Jobab an imbabalen Serah an i Bosrah hidih ad Edom. ");
INSERT INTO ifa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ya hidin nate boh Jobab ya nihukkat an numpatul hi Husam an i Teman. ");
INSERT INTO ifa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ya hidin nateh Husam ya nihukkat an numpatul hi Hadad an imbabalen Bedad. Hi Hadad ya inabakna nadan i Midian hidin nunggugubatandah ad Moab. Ya hay nunhituwana ya hi ad Abit hidih ad Edom. ");
INSERT INTO ifa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hidin nateh Hadad ya nihukkat an numpatul hi Samlah an i Masrekah. ");
INSERT INTO ifa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ya hidin nate boh Samlah ya nihukkat an numpatul hi Saul an i Rehobot an nihaggon hinan wangwang an nungngadan hi Euprates. ");
INSERT INTO ifa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ya hidi bon nateh Saul ya hay nihukkat hi numpatul ya hi Baal-Hanan an imbabalen Akbor. ");
INSERT INTO ifa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ya hidin nateh Baal-Hanan an imbabalen Akbor ya nihukkat an numpatul hi Hadar. Ya hay ngadan nan boblen ena nunhituwan ya hi ad Pau hidih ad Edom. Hay ngadan nan ahawana ya hi Mehetabel an imbabalen Matred an hi na' Me-Sahab. ");
INSERT INTO ifa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hay ngadan nadan tinanud Esau an nun'ap'apu hinadan boble hi ad Edom ya hi Timna ya hi Albah ya hi Jetet ");
INSERT INTO ifa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ya hi Oholibamah ya hi Elah ya hi Pinon ");
INSERT INTO ifa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ya hi Kenas ya hi Teman ya hi Mibsar ");
INSERT INTO ifa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ya hi Magdiel ya hi Iram. Ya way oha i datuwe on diday ap'apu hinadan boble an eda nunhituwan. Ta hay ammod nadan i Edom ya hi Esau. ");
INSERT INTO ifa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Hi Jacob ya hay eda nunhituwan ya hinan nunhituwan amana hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ta athituy na'na'at i da Jacob an hina'amma. Hi imbabalenan hi Joseph ya hidin mangmangngilog an himpulut pituy (17) tawona ya ni'ni''uyug hinadan i'ibanan linala'i an imbabalen amana i da Bilhah i Silpah ta eda ipastol nadan halunda. Mu indani on waday ibagbaganan amana an adi maphod an at'aton nadan i'ibana. ");
INSERT INTO ifa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Mu hi Joseph ya hiyay pa'appohpohdon amana i didan namin an hina'aggi an gapu ta hiya ya niyayyam hidin amamma moh amana. Ta impiyammaanah Joseph i han adukken mapmaphod an lubung. ");
INSERT INTO ifa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ya inilmun nadan i'iban Joseph an hiyay pa'appohpohdon amada mu dida ya nunhiglay hihiwodan Joseph ta an namin di ibagadan hiya on nan adi maphod. ");
INSERT INTO ifa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ya indani ya wada han ininop Joseph ot ibaganah nadan i'ibana ya inyal'alanaot di hihiwodan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Te inalinan diday, Ininop'un ");
INSERT INTO ifa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","imme ta'u anu nunggapas an hina'aggi. Ya tinigo' an nan nabto' an ginapas'u ya naha''ad ot eda anu mili'wohdi nadan nabto' an ginapasyu ot munyu''ungdah nan nabto' an ginapas'u. ");
INSERT INTO ifa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ya namamay bungot nadan i'ibanan hiya an alyonday, Ot he''a mo nayyay mumpatul i da'mi hi'on athina. Ta namamay hihiwodan hiya an gapu i diyen ininopna ya nadan imbagana an a'at nadan i'ibana. ");
INSERT INTO ifa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Indani ya wada boy ininopna ot ibagana boh nadan i'ibana an alyonay, Wada bo han ininop'u an tinigo' bo anu an nunyu''ung i ha''on nan algo ya nan bulan ya nadan himpulut ohan (11) bittuwon. ");
INSERT INTO ifa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ta hidin imbaganah diye i amana ya nadan i'ibana ya inhingal amanan alyonay, Tanganu piboh on waha athinah ininopmu? Undan ta'on on hi inam ya ha\"on ya tudan i'ibam ya munyu\"ung amin he\"a? ");
INSERT INTO ifa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ta umamohda nadan i'ibana i hiya mu hi amana ya nonomnomonah diye. ");
INSERT INTO ifa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nadan i'iban Joseph ya eda impastol nadan halun amada hinan nihaggon hi ad Sekem. ");
INSERT INTO ifa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ta inalin Jacob i Joseph di, Nadan i'ibam ya eda numpastol hinan nihaggon hi ad Sekem ot agam ta mundadaan'a ta em papto'anan dida. Ya inabulut Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ot alyon amana i hiya di, Ume'a ta em papto'anan hi'on mapmaphodda nadan i'ibam ya nadan halun ta'u ya ahi'a mumbangngad ta ipa'innilam i ha''on. Ot makak hi Joseph hidih ad Hebron ot umeh ad Sekem. ");
INSERT INTO ifa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ya hidin dimmatong hi ad Sekem ya ma''id ha adina e hawangon hinan pumpastolan ya inakhupana han tagun ibaganah on nganne nan ena ana'anapon. ");
INSERT INTO ifa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ya alyon Joseph di, Nadan i'iba' an e numpastol mu ten ma''id ha mapto' hi nangipluyanda. ");
INSERT INTO ifa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ya alyon nan lala'i di, Immeda man nee. Ya hay dingngol'uh alyondah umayanda ya hi ad Dotan. Ot miyunud mo boh Joseph hidi ot akhupana didah ad Dotan. ");
INSERT INTO ifa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mu hidin minangmang nadan i'ibanah Joseph ot hahapitonda ta patayonda ");
INSERT INTO ifa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","te alyonday, Tuwe tayya nan ma'a'innop. ");
INSERT INTO ifa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ma'ayu ta eta'u patayon ya inibkah ta'uh nan bitu. Ta ibagan'en ama ta'u ya alyon ta'u hi inan di layon. Ta wan tigon ta'undi anu hi'on nganney pumbalinan nadan inino'inopna. ");
INSERT INTO ifa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mu hidin dingngol Ruben hidiyen imbagada ya impatnanan panohon didan alyonay, Udu'dulnay adiyu patayon. ");
INSERT INTO ifa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ta namaag ya eyu inuhbung hinan bituh tun agge naboblayan mu adiyu hugatan. Manu'eh athidiy inalin Ruben ya ninomnomna an ahina e awiton ya inyanamutna i amada. ");
INSERT INTO ifa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ta hidin nidatong hi Joseph ot ipudongda ot aanonda nan mapmaphod an adukken inlubungna ");
INSERT INTO ifa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ot eda uhbungon i han bitu. Nan bitu ya ma\"id ha litingna. ");
INSERT INTO ifa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ot ahida mohpe e mangan. Ya hidin mangmangnganda ya nangimangmanganda han nabulog an dadiye nadan mungkumilhu an tinanud Ismael an nalpudah ad Gilead. Ya dakol di kinalgan nadan kemelda an umat hinadan middum hi ihda ya nadan maphod di hunghungna an eda igattang hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Hi Ruben ya ma\"id hidih din pangalyan Judah hinadan i'ibanay, Undan nganne damdamay gun'udon ta'u hi'on patayon ta'uh ibba ta'u an ta'on on adi ta'u ipa'in'innila? ");
INSERT INTO ifa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Udu'dulnah on ta'u ihbut i datuwen mala\"uh an tinanud Ismael ta adi ta'u patayon te hi ibba ta'u ahan tatawwa. Ya inunnudan nadan udum hidiye. ");
INSERT INTO ifa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ot eda mo guyudon hi Joseph hinan bitu ot ihbutdah baintiy (20) silber an pihhu hinadan tinanud Ismael ot iyedah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ta hidin nibangngad hi Ruben ta ena tigon hi Joseph hinan bitu ya ma''id hidi. Ya nunhiglan mahkit hi nomnomna ta nunhethetnay lubungna. ");
INSERT INTO ifa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ot umeh awadan nadan i'ibana ot alyonay, Ma''id man hidi nan unga. Nganne nin di ato'? ");
INSERT INTO ifa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ot patayonda moy ohah nan gulding ot itamolda nan lubung Joseph hinan dalana. ");
INSERT INTO ifa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ot ipatigoda i amada hidin immanamutanda. Ot alyonda i hiyay, Inakhupanmih tuweh nan inwami ot imatunam ya hi'on hituwe nan lubung Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ya hidin tinigona ya immatunana an hiyah diye ot alyonay, O hiyah nae nan lubung nan imbabale'. Te on pinaten di mabungot an animal ot ma''id ha bahhonan ginudugududa attog di tungalna. ");
INSERT INTO ifa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ot punhethet Jacob di lubungnah ena umukayungan ot munlubung hi langgut ot umukayungan hi atnay algo an gapuh nan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ya ta'on hi na'amungdan namin nadan imbabalena ya nadan binabain inapuna ta eda ip'iphodan hi hapit on adi mihapitan. Ya alyonay, Ingganah ona' mate ya ahi mabalin an mapogpog di e' umukayungan an gapuh nan imbabale'. Ta kinogakogaana nan imbabalena an hi Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mu hay na'at i Joseph ya hidin indatong nadan mungkumilhu an i Midian hi ad Egypt ot igattangda i Potipar an ap'apun di mungguwalyah nan palasyun nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hi Judah ya tinaynana nadan i'ibana ot e mi'hitu i han lala'i hi ad Adullam an hay ngadana ya hi Hirah. ");
INSERT INTO ifa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ta hidiy nanamuwanah nan babain imbabalen Sua an i Kanaan ot ahawaona. ");
INSERT INTO ifa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ta numbutyug ot iyayyamna han lala'i ot ngadanan Judah ta hi Er. ");
INSERT INTO ifa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ot mumbutyug bo ot iyayyamna bo han lala'i ot ngadanan Judah ta hi Onan. ");
INSERT INTO ifa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ya indani ya nawada bo han lala'i ot ngadanana ta hi Selah. Ya hay nangiyayyamana i Selah ya hidih din awadandah ad Aksib. ");
INSERT INTO ifa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Hidin kimmilog nan panguluwan an hi Er ot ipa'ahawan amana i han hi Tamar. ");
INSERT INTO ifa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mu hi Er ya nadan adi maphod di at'atona an adi miyunnudan hinan pohdon Apu Dios ta hiya nan pinatena. ");
INSERT INTO ifa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ot alyon Judah hinan mi'adwan imbabalena an hi Onan di, Ahawaom hi Tamar te hiyah diyey pangat ta'u ta wada'e ha imbabaleyu ya waha hanat nan naten hi ibbam. ");
INSERT INTO ifa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mu innilanan ta'on on waday imbabaleda ya bokon hiyay mibilang hi nangimbabale ta hiya nan inwanilihna nan malpun hiya ta aggeda na'imbabalayan i Tamar. ");
INSERT INTO ifa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ya ongal di agge naminhodan Apu Dios i diyen adi maphod an ina'inat Onan ta hiya nan pinatena mo bo. ");
INSERT INTO ifa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ot alyon mon Judah i Tamar di, Mumbangngad'a attog hi balen da amam ta kimmilog'eh Selah ya ahi ayu mun'ahawa. Manu'eh inalinah diye ya iyaguhna te alina ya ma'at bo i Selah nan na'at hinan duwan i'ibana. Ot mumbangngad moh Tamar hi balen da amana. ");
INSERT INTO ifa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Immey atnay tawon ya mate nan ahawan Judah an hi na' Sua. Ya hidin napogpog di umukayungan Judah ot makakdah nan gayyumnan hi Hirah an i Adullam ta eda mumpukis hinadan kalneron Judah hi ad Timnah. ");
INSERT INTO ifa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mu waday nangipa'innilah nan inapunan hi Tamar hinan umayandah ad Timnah. ");
INSERT INTO ifa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ta hidin dingngol Tamar hidiye ot hukkatana nan lubungnan lubung di nabalu ot munhu'yung ta adi mimatunan di angahna ot e um'umbun hinan way geyt hi ad Enaim an awon an umeh ad Timnah. Manu'eh inatnahdi ya inilmunan adi mipa'annung di pangahawaana i Selah te makilog mo mu aggeda nun'addum. ");
INSERT INTO ifa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ta hidin mala''uh da Judah ya alyonah on mumpabpabbayad hi adolna te hinu'yunganay angahna. ");
INSERT INTO ifa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ot umeh awadana ot ibaganah on atnay pamayadna te pohdonan ilo' te aggena innilah on hidiye nan inapuna. Ya alyon Tamar i hiyay, Mu nganne ni' di idatmun ha''on ta ahiya' ilo' i he\"a? ");
INSERT INTO ifa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ya alyon Judah di, Ahi' ipiyalin he''a ha ohah nan gulding'u. Ya alyon Tamar di, Mabalin mu mahapul an waha idatmuh ad uwani ta impiyalim'eh diyen gulding ya ahim bangngadon. ");
INSERT INTO ifa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ya alyon Judah di, Nganney pohdom hi idat'un he''a. Ya alyonay, Ta'omman ya inyalim nan imbanggolmu ya nan hu''udmu. Ot idat Judah dadiye ot ahina ilo'. Ya indani ya numbutyug hi Tamar. ");
INSERT INTO ifa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ta on immanamut ot ibangngadna nan lubungna tuwalin lubung di nabalu ot aanona nan hu'yungna. ");
INSERT INTO ifa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ta hidin imme nan hinnag Judah an gayyumnan hi Hirah ta iyena nan gulding hinan babai ta bangngadona nan bagin Judah ya ma''id ha inakhupana i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ot ena pun'ibagah nadan linala'i di awadan diyen babain mumpabayad hi adolnah nan way temploda an e immohnong ni' hinan way geyt hi ad Enaim. Ya alyonday, Ma''id ha innilamih mumpabpabbayad hi adolnah nan templohtu. ");
INSERT INTO ifa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ot mumbangngad mo ot ibagana i Judah an aggena inakhupan. Ya imbagana bo i hiya nan inalin nadan linala'in nummahmahana. ");
INSERT INTO ifa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ya alyon Judah di, Ta'omman attog ya bagina nadan indat'un hiya. Te ummannot on eta pangihngihil hi'on ibangngad bo ta e hama'on. ");
INSERT INTO ifa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Hidin nala''uh han tuluy bulan ya wada han nangibaga i Judah an nan inapunan hi Tamar ya numbutyug. Ya bimmungot hi Judah an alyonay, Mahapul an eyu ipalah'un ya pinu'ulanyu. ");
INSERT INTO ifa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mu hidin immeday e mangawit i hiya ta patayonda ya alyonay, Eyu ni' ipatigo tun hu''ud ya tun banggol i Judah ya inaliyun hiya an hay hi aman tun imbutyug'u ya nan ud bagin datuwe. ");
INSERT INTO ifa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ya hidin eda impatigo i Judah ya immatunana ot alyonay, Hi Tamar di nipto' di inatna te agge' peman impa'annung an impa'ahawan hiya nan imbabale' an hi Selah. Mu hi Judah ya aggena impidpidwan e ni'ilo' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hidin nadatngan di pun'ayyaman Tamar ya na'innilaan an nundappel nan inyayyamna. ");
INSERT INTO ifa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ya hidin pun'ayyamana ya namangulun himmawwang nan ta'len nan oha. Ta namaag nan mundawat ot iga'odna han mumbolah an linubid ot alyonay, Hituwey namangulu. ");
INSERT INTO ifa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mu indani ya ginuyud diyen golang di ta'lena ya nan ohan lala'i di niploh hi bimmudduh. Ta mano\"ol nan mundawat an alyonah nan golang di, Undan athituy atom an bumudduh. Ta hiya nan nginadananda ta hi Peres. ");
INSERT INTO ifa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ya nada'dani ya bimmudduh mohpe nan naga'odan di ta'lenah linubid an lala'i ot ngadananda ta hi Serah. ");
INSERT INTO ifa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Hi Joseph ya hidin indatong nan mungkumilhun tinanud Ismael hi ad Egypt ot igattangda i han hi Potipar an ap'apun di mungguwalyah nan palasyun nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ya hi Apu Dios di bimmoddang i Joseph ta maphod an namin di numbalinan nadan tinamuwana hinan niha''adanah balen Potipar. ");
INSERT INTO ifa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ta nan ud himbut i hiya an hi Potipar ya innilanan hi Apu Dios di bimmoddang i Joseph te pinumhod an namin nadan tinamuwanahdi. ");
INSERT INTO ifa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ya ongal di pun'am'amlongan Potipar i hiya ta hiyay nangiyukodanah mumpapto' hi an namin nadan himbutna ya ta'on on nadan wadan gina'una. ");
INSERT INTO ifa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ya nihipun i diye ya winagahan Apu Dios di nunhituwan diyen i Egypt an gapu i Joseph. Ot wagahan bon Apu Dios nadan intanomda. ");
INSERT INTO ifa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ta inyukodnan namin i Joseph nadan wadan hiya an ammuna nan anon Potipar an agge niyukod i hiya. Hi Joseph ya maphod di nangadolna. ");
INSERT INTO ifa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ta hidin nadnadnehdi ya nawaday naminhod nan ahawan Potipar i hiya. Ta lo'tat ot ayaganah Joseph ta e mi'ilo' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mu alyon Joseph i hiyay, Nan ud himbut i ha\"on ya inyukodnan namin i ha\"on di ma'ma'at hitun nunhituwanyu ya ta'on on nadan wadan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ya ma\"id ha udum hi nabakbaktuy sa'adnah tun nunhituwanyu hi'on bokon ha\"on. Mu he\"a ya abuh han aggena inyukod i ha\"on. Ta hiya nan adi ahan mabalin hi e' aton ha ababain ta mumbahula' i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ya ta'on on abigabigat on hiyay imbagan diyen babai i Joseph ya aggena damdama e inilo' hidiyen babai. ");
INSERT INTO ifa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mu han hin'algo an hinunggop hi Joseph an e muntamu ya hidin tinigon nan babai an ma''id ha ohah nadan himbut hi wahdi ");
INSERT INTO ifa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ya inidon diyen babai i hiya ta pilitonan eda malo'. Mu binumtik hi Joseph hi dola mu naguyud nan lubungna an nangidonan diyen babai ot mabati i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ya hidin tinigona an binumtik hi Joseph an ammunah diyen lubung an nangidonanay nabati ");
INSERT INTO ifa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ya namaaggot muntukuk hinadan himbutda. Ta hidin immeda ya alyonan diday, Tigonyu teey inat nan Hebrew an inyanamut ahawa' an on dita'u e bainon te hinunggop hinan alo'a' ta pilitonan ilo'a'. Mu hidin muntukuka' ");
INSERT INTO ifa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ya binumtik mohpe an aggena hinangut tun lubungna. ");
INSERT INTO ifa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ot ena ipa''eh diyen lubung ta ingganaot umanamut hi ahawana i diyen nahdom. ");
INSERT INTO ifa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ot uhuhonan alyonay, Nayya mahan han inyanamutmun Hebrew an namaag ya hinggopa' hinan alo'a' ta eya' piliton an ilo'. ");
INSERT INTO ifa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mu nuntukuka' ot bumtik ta hiya nan aggena hinangut tun lubungna. ");
INSERT INTO ifa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ya nunhiglay bungot Potipar. ");
INSERT INTO ifa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ot ena mo ipibalud hi Joseph. Ta e niddum hinadan udum an impibalud nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mu hi Apu Dios damdamay bimmoddang i hiya ta ma'ulen hiya nan mumpapto' hinadan nun'ibalud. ");
INSERT INTO ifa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ot iyukod nan mumpapto' hinan baludan i Joseph nadan ibbanan nibalud ya an namin nadan ma'ma'at hidih nan baludan. ");
INSERT INTO ifa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ya an namin nadan niyukod i Joseph ya maphod di numbalinana te hi Apu Dios di bimmoddang i hiya. Ta hiya nan madinol nan mumpapto' hinan baludan hi nangiyukodana i diyen tamu i Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Indani ya nan punha''angon nan patul hi tinapay ya nan niyukodan nan inumon nan patul hi ad Egypt ya waday numbahulandah nan patul ");
INSERT INTO ifa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ta hiya nan bimmungot nan patul i dadiyen duwan ap'apu. ");
INSERT INTO ifa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ot ena ipibalud didah nan way nibaludan Joseph hi way balen nan ap'apun di mungguwalya. ");
INSERT INTO ifa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ot iyukod nan ap'apun di mungguwalya dida i Joseph ta nadnadnedahdi an hi Joseph di mangipadutu' i dida. ");
INSERT INTO ifa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ya i han nahdom ya nun'inop nan niyukodan nan inumon nan patul ya nan punha''angonah tinapay. Ta nundihhandan nun'inop i diyen ohan nahdom. Mu nan ininopda ya agge numpaddung di ibalinana. ");
INSERT INTO ifa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ta hidin nawi\"it an e tinigon Joseph dida ya tinigonan minomnomanda. ");
INSERT INTO ifa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ot mahmahana hi'on nganney gapunah eda minomnoman. ");
INSERT INTO ifa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ya alyonday, O te waday ininopmi mu ma''id ha mabalin hi mangibagah nan ibalinana. Ya alyon Joseph di, Hay alpuwan nan abalinan an mangibaga hi ibalinan di inop ya hi Apu Dios. Ot uhuhonyuya nan ininopyu. ");
INSERT INTO ifa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ya inhipun nan niyukodan di inumon nan patul an ibaga nan ininopna an alyonay, Hay ininop'u ya han nitanom an greyp hinan way hinangngab'u ");
INSERT INTO ifa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","an tuluy hapangna. Ya indani ya timmulu nan tubuda ot humabungda. Ta lo'tat ya natong ot malumda nan bungana. ");
INSERT INTO ifa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ta namaag nan inodna' an basun di patul ot e' pangipoghan hinan danum di bungana ot iye' hinan patul ta inumona. ");
INSERT INTO ifa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ya alyon Joseph di, Hay ibalinan nan tuluy hapang an ininopmu ya tuluy algo. ");
INSERT INTO ifa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Te mala''uh di tuluy algo ya umaan'ah tun baludan te pumbangngadon da'ah nan patul hidin tamum tuwali. Ta minaynayun nan tamum an he''ay iyukodan nan inumon nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ot hanat hitun pumbangngadam hinan tamum ya nomnomnomona' bahan ta ihapita' hinan patul ta alina ya ilubusa' hitun baludan. ");
INSERT INTO ifa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Te ha''on ya ona' attog inibtik hinan numboblayanmin Hebrew. Ot teen ad uwani bo ya waa' hitun baludan an ta'on on ma''id ha bahul'u. ");
INSERT INTO ifa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Hidin dingngol nan munha''ang hi tinapay an maphod di ibalinan nan ininop nan ibbana ya alyonan Joseph di, Hay ininop'u'e pibo ya han tulun bahket an inaktu'. ");
INSERT INTO ifa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ya hay nittuh nan niyuhhun an bahket ya mun'aphod an tinapay an anon nan patul mu inan nadan hamuti an ta'on on nunnanongdah nan bahket an inaktu'. ");
INSERT INTO ifa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ya alyon Joseph i hiyay, Hay ibalinan naen tulun bahket ya tuluy algo. ");
INSERT INTO ifa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Te mala''uh di tuluy algo ya umaan'ah tun baludan ta ipaputul nan patul di ulum. Ya ena mohpe impitattayun di adolmu ta hay hamutiy mangan hi lamohmu. ");
INSERT INTO ifa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ya hidin nala''uh di tuluy algo ya nadatngan nan punnomnomandah niyayyaman nan patul ta inamungnan namin nadan ap'apu ot ipaltiyana dida. Ot ipalah'una dadiyen duwan nibalud an nan punha''angonah tinapay ya nan niyukodan di inumona. ");
INSERT INTO ifa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ot pumbangngadona nan niyukodan di inumonah nan tamuna tuwali. ");
INSERT INTO ifa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mu nan punha''angonah tinapay ya impapatena. Ta nipa'annung an namin nan imbagan Joseph an a'at nan ininopda. ");
INSERT INTO ifa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mu ta'on on athidi ya liningling nan niyukodan nan inumon nan patul hi Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hidin nala''uh di duway tawon ya ininop nan patul an wahdi anu hinan da'ging di wangwang an nungngadan hi Nayl an tumtumma'dog. ");
INSERT INTO ifa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ya alinah on tinigonay pitun mun'atataban baka ya nun'apdih di up'updan limmotwa'dah nan wangwang ot inayundan mangmangngan hinan holo'. ");
INSERT INTO ifa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ya indani ya nitnuddan limmotwa' di pitu bon nun'apipigut an baka ot eda mihaggon hinadan mun'atataban baka ");
INSERT INTO ifa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ot pun'a'anda dida. Ta nipogpog i diye ya inggibo' nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mu hidin na'uyung ya ininopna bo han ohay pu\"una an gahhilang mu pituy maphod an bungana an na'attongda. ");
INSERT INTO ifa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ya indani ya tinigonan timmuluda boy pitu an bungana mu ma\"id ha lamohda te gapuh nan dibdib. ");
INSERT INTO ifa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ya alinah onda pun'a'an nadan pitun maphod an bungana. Ya inggibo' bon nan patul ot alyonah nomnomnay, Tee on'u ininop. ");
INSERT INTO ifa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ta i diyen nawi\"it ya minomnoman an gapu i diyen ininopna. Ot ipa'ayagnan namin nadan nanginnilah ibalinan di inop ya nadan udum an ibilangdah nun'anomnoman hidih ad Egypt. Ta na'amungda ot uhuhonan dida nan ininopna mu ma''id ha nanginnilan didah ibalinana. ");
INSERT INTO ifa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ya alina mohpe on immeh awadan nan patul hidiyen niyukodan nan inumona ot alyonay, Nipanomnom ta'wa tee i ha\"on an handin numbahulanmi ");
INSERT INTO ifa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","i he\"a an patul an da'min duwah nan punha\"angom hi tinapay ta bimmungot'a ot ipibalud da'mihdih nan baludan hi way balen nan ap'apun di mungguwalya. ");
INSERT INTO ifa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ya han ohan nahdom ya waday ininopmin duwa an hinnat'on di ibalinana. ");
INSERT INTO ifa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ya wahdi han nibalud an mangmangngilog an Hebrew an hiyay numbalinon nan ap'apun di mungguwalya hi baalna ta hiyay nangibagaanmih nan ininopmi ot ibaganay ibalinana. ");
INSERT INTO ifa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ya nan na'at i da'mi ya niyunnudan hinan imbaganan niyatan nan ininopmi te numbangngadona' hinan tamu' ya nan munha''ang hi tinapay di impapatem. ");
INSERT INTO ifa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ya hidin dingngol nan patul hidiye ot pi'ibagonan ipa'ayag hi Joseph. Ta hidin limmah'un hi baludan ot e ni' mumpapukis ot hukkatanay lubungna ot umeh awadan nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ya alyon nan patul i hiyay, Wada han ininop'u mu ma''id ha mabalin hi mangibagah nan ibalinana. Mu dingngol'un he''a ya abalinam anun mangibaga hi ibalinan di inop. ");
INSERT INTO ifa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ya alyon Joseph i hiyay, Apu patul ha''on ya adi' abalinan mu hi Apu Dios di mangipa'innilah ibalinan nan ininopmu. ");
INSERT INTO ifa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ot alyon nan patul di, Ininop'un waa' hinan da'ging di wangwang an nungngadan hi Nayl an tumtumma'doga'. ");
INSERT INTO ifa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ya alinah onda limmotwa' hinan nalitingan han pitun mun'atataban baka ya nun'apdih di up'upda ot inayundan mangmangngan hinan holo'. ");
INSERT INTO ifa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ya indani ya tinigo' bon nitnuddan limmotwa' di pitun nun'apipigut an baka. Ya ma\"id ha tinigo' hi bakah tun ad Egypt hi athidiy napigutanda te nunhiglan adi maphod di tigoda. ");
INSERT INTO ifa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ya alinah onda nun'a'an nadan namangulun mun'atataban baka. ");
INSERT INTO ifa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Mu ma\"id ha itiganah nangananda i dadiyen mun'atataban baka te hiyah diyen na'appigutda damdama an adi maphod di tigoda. Ya nipogpog i diye ot igibo''u. ");
INSERT INTO ifa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Indani ya ininop'u bo han ohay pu'un an gahhilang an pituy bungana an mapmaphodda ya na'attongda. ");
INSERT INTO ifa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ya indani ya timmulu boy pitun bungana mu ma\"id ha lamohda te gapuh nan dibdib ya naklingda. ");
INSERT INTO ifa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ya alina boh onda pun'a'an nadan namangulun mapmaphod an bungana. Ta inuhuh'u danaen namin hinadan nanginnilan mangibalin hi inop mu ma''id ha nanginnilah ibalinana. ");
INSERT INTO ifa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ya alyon Joseph i hiyay, Nan duwan ininopmu ya numpaddung di ibalinanda. Te hi Apu Dios ya impa'innilanan he''a nan ma'at hi udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ot nan pitun mun'atataban baka ya nan pitu bon mun'a'aphod an bungan nan gahhilang ya numpaddung di ipa'innilada an dadiye ya pituy tawon an mahawwalan di makan. ");
INSERT INTO ifa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ya nan na'udin pitun nun'apipigut an baka ya nan pitu bon nakupoh di bungada ya pitu boy tawon an bitil. ");
INSERT INTO ifa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ta hiyah tuwe nan hi Apu Dios ya impa'innilana i he\"a nan atona. ");
INSERT INTO ifa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Te hitun ad Egypt ya waday pituy tawon an mahawwalan di makan. ");
INSERT INTO ifa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mu indani ya mihukkat han pituy tawon an nunhiglay bitil. Ta hidiyey ");
INSERT INTO ifa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ay munlingling hi pinumhodan ni' tuwen boble te nunhiglay aton diyen bitil. ");
INSERT INTO ifa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ya manu'e hi numpidwan nipa'inop i he\"a ya hidiyey aton Apu Dios an mangipa'innilan adi mibahhoy ena a'atan. Ya atbohdin agagga ya ma'at. ");
INSERT INTO ifa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ta hiya nan hay ibaga' i he\"a apu patul ya maphod onmu pot'on ha nanomnoman ya innilanay nipto' hi atona ta hiyay ukod an mangipadutu' hinadan makan hitun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ya pot'om bo doha ta diday ukod an mangamung hinan mi'alimah (⅕) nadan ma'apit an nitanom hi abobbobleh tun ad Egypt i diyen pituy tawon ");
INSERT INTO ifa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","an dakol di ma'apit ya inamungdah nan pangi'amungan hi makan hi abobboble. ");
INSERT INTO ifa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ta wada ha midadaan hi makan hitun madatngan nan pituy tawon an bitil. Ta mabalin an adi iyaten nadan tataguy inagangda. ");
INSERT INTO ifa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ya inunnudan nan patul ya nadan ap'apu hidiyen imbagan Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ot alyon nan patul hinadan ap'apu di, Hay punnomnom'u ya ma''id ha udum hi nanomnomnoman mu hi Joseph an hiya nan nidduman nan Espiritun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ya alyon nan patul i Joseph di, Ten he''ay nangipa'innilaan Apu Dios i nae ya na'innilan ma''id ha umat i he''a an nanomnoman ya innilanay nipto' hi atona. ");
INSERT INTO ifa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ot he''ay pot'o' hi pangiyukoda' hi an namin nadan ma'ma'at hitun boblen pumpapto'a'. Ot an naminda tun tatagu' ya nan ibagam di unudonda. Ta nabakbaktuwa' ya abuh an gapuh nan sa'ad'u. ");
INSERT INTO ifa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ot ad uwani ya he''a moy munggobelnador hitun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ya inaan nan patul nan singsingna ot ipihu'lubnah gamat Joseph. Ya hidiyen singsing di mangipa'innila an pinto' nan patul hi Joseph ta hiyay gobelnador. Ot lubunganah nan maphod an linen ot ipibanggolnay balitu' i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ot idatna i Joseph nan lugana ta hiya moy mi'adwah nan patul hi sa'adna ta nan pangipluyana on pun'itkuk nadan nangipangulu ta ipatigon nadan tataguy punlispitudan hiya. Ta athidiy na'at hidin pinto' nan patul hi Joseph hi gobelnador hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ot alyon bon nan patul i hiyay, Ta'on on ha''on di patul hitun ad Egypt mu wada'ey adim iyabulut ya adi mabalin an ma'at. ");
INSERT INTO ifa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ot ngadananah Joseph ta hi Sapenat-Paneah an ngadan di i Egypt. Ot ipa'ahawanah Joseph i Asenat an imbabalen Potipera an padi hi ad On. ");
INSERT INTO ifa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ta e impong Joseph an e tinigo nadan bobleh ad Egypt. Ya hay tawonah din inhipunan nuntamuh nan patul hi ad Egypt ya tulumpulu (30). ");
INSERT INTO ifa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ya immannung an hidin namangulun pituy tawon ya mun'ahawwalan di makan hi abobboblehdi. ");
INSERT INTO ifa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ta impa'amung Joseph nadan makan i diyen pituy tawon on ena impiha''ad hinadan pangi'amunganda hinadan makan hinadan boble te an namin an bobleh ad Egypt on waday pangi'amunganda. ");
INSERT INTO ifa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ya dakkodakkol di inamungda an makan an umat hi dinakol di panag hinan baybay. Ta lo'tat ya adida mo pa'abbilang ot idinongda mon mangitudo' hi bilangna. ");
INSERT INTO ifa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Hi Joseph ya nawadaday duwan imbabaleda i Asenat hidin agge ni' nadatngan di bitil. ");
INSERT INTO ifa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ta hay nungngadanah nan panguluwan ya hi Manasseh te alyonay, Hi Apu Dios di namoddang i ha\"on ta liningling'un namin nadan napalpaligata' ya hay e' nihi''anan i da ama. ");
INSERT INTO ifa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya nan mi'adwa ya nginadanana ta hi Epraim te alyonay, Hi Apu Dios di nangdat hi holag'uh tun boblen napalpaligata'. ");
INSERT INTO ifa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Indani tatawwa ya napogpog nan pituy tawon an mahawwalan di makan hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ya nihipun mo nan pituy tawon an bitil an miyunnudan hinan inalin Joseph. Ta an namin nadan nun'ihaggon an boble ya makulangandah makan mu hi ad Egypt e ya waday makan hi nun'iyalangda. ");
INSERT INTO ifa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ta hidin mun'apuhanda mo nadan i Egypt hi anonda ya eda mo mumpumbagah nan patul. Mu alyon nan patul di, Eyu ibagan Joseph ta nangamung nan alyona ya hiyay inunudyu. ");
INSERT INTO ifa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ya hidi mon nun'ihinap nan bitil hi abobbobleh ad Egypt ya impibughul Joseph an namin nadan eda nangi'amungan hi makan ta pun'igattangdah nadan i Egypt te nunhigla mo nan bitil. ");
INSERT INTO ifa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mu nihinap hidiyen bitil hi abobbobleh tun luta ta umeda moy atagutaguh ad Egypt ta eda gumattang hi makan i Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Hi Jacob ya dingngolnan waday makan hi ad Egypt ot alyonah nadan imbabalenay, Undan namaag ya nuntoto\"olan ayu ya abuh ");
INSERT INTO ifa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","yaden dingngol'un wada anuy makan hi ad Egypt. Makak ayu ta e ayu gumattang hidi i ha anon ta'u ta adi ta'u ni' mateh inagang ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ta nakakda mo nan himpulun (10) imbabalen Jacob ot ipluydah ad Egypt ta eda gumattang hi makan. ");
INSERT INTO ifa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mu agge ni'yayon Jacob hi Benjamin an hi ibban Joseph te iyaguhnay ma'at bon hiya. ");
INSERT INTO ifa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ta ni'ye dadiyen imbabalen Jacob hinadan umeh ad Egypt an e gumattang hi makan te ta'on on hi ad Kanaan ya waday bitil. ");
INSERT INTO ifa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ta hi Joseph an hiya nan gobelnador hi ad Egypt ya hiyay e gumattangan di tatagun nalpuh abobboble. Ya hidin imme nadan i'ibana ot munyu''ungdah hinangngabna ta ipatigodan bainanda. ");
INSERT INTO ifa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ya hidin tinigon Joseph nadan i'ibana ya immatunana dida. Mu hay impatigona i dida ya aggena in'innila dida ta nunhiglay panapitna i dida an alyonay, Danay bobleh nalpuwanyu? Ya alyonday, Hi ad Kanaan mu immali amin gumattang hi makan. ");
INSERT INTO ifa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Hi Joseph ya immatunana nimpe an dida nadan i'ibana mu dadiyen i'ibana ya aggeda immatunan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ya nipanomnom i hiya din ininopnan niyatanda ot alyonan diday, Umman on ayu nee immalin munsi'im an alyonyu on ta tigonyuy a'at tun boblemi ta innilaonyuy atonyun mangabak i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ya alyonday, Apu Gobelnador, ma\"id attog ha athinah ninomnommi te da'min baalmu ya immali amin gumattang hi makan ya abuh. ");
INSERT INTO ifa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ya agge ami attog immalin munsi'im te adi ami ma'layyah. Te da'mi ya hina'aggi amin ohay hi amami. ");
INSERT INTO ifa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ya ipapilit Joseph an alyonay, Layahyu te innila' ot immali ayun munsi'im hitun boblemi. ");
INSERT INTO ifa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ya alyonday, Apu Gobelnador, da'min baalmu ya himpulu amit duwah (12) an imbabalen di ohan taguh ad Kanaan. Nan udidiyanmi ya nabati i amami ya nama''id nan oha. ");
INSERT INTO ifa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ya alyon bon Joseph di, Ot hiya tatawwa neen immali ayun munsi'im. ");
INSERT INTO ifa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ot hay pamatna' i da'yu ta panginnilaa' an adi ayu munlayah ya adi mabalin hi umanamut ayu ta ingganah on umalihtu nan udidiyan an hi ibbayu. Hinaen inali' ya ay damdama nan patul di ud mandal. ");
INSERT INTO ifa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ot mahapul an ume ha oha i da'yu ta ena awiton nan udidiyanyu. Ya da'yun udum ya mibalud ayu ta ingganah innilao' an immannung nan imbagayu. Te adi'e ya immannung an immali ayu nimpen munsi'im. ");
INSERT INTO ifa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ya hidin inalinah diye ot ena ipibalud didah tuluy algo. ");
INSERT INTO ifa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ya hidin mi'atluh algo ya alyon Joseph i diday, Ha''on ya hi Apu Dios di un'unudo' ta hiya nan adi da'yu ipapate mu gahin di atonyu tun ibaga'. ");
INSERT INTO ifa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ot ta'omman ya oha i da'yu ha mabatih tun baludan ya imme ayun udum ta iyeyu nan ginattangyu ta adida ma'agangan nadan tinaynanyuh nadan numpunhituwanyu. ");
INSERT INTO ifa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mu mahapul nimpe an awitonyuhtu nan udidiyanyu ta panginnilaa' an adi ayu munlayah ta adi da'yu ipapate. Ya inabulutdah diyen inalina. ");
INSERT INTO ifa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ya humanahapitdan alyonday, Immannung mahan an din inat ta'u i Joseph di gapunah athituy ma'ma'at i dita'uh ad uwani. Mumpahpahmo' peman tuwali i dita'u mu ay ta'u napukit. Ta hiya mo nan ad uwani ya athituy pumpaligatan ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ya alyon Ruben di, Undan tuwali agge' pinadanan an alyo' i da'yuy adi nginin di atonyu mu adiyu donglon. Ta hiyah tuwe nan ad uwani tee ya miballoh i dita'u nan ena nama''idan. ");
INSERT INTO ifa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mu dida ya aggeda innilan na'awatan Joseph hidiyen punhahapitanda te hidin ni'hapitdan hiya ya waday nangibalin. ");
INSERT INTO ifa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ot taynan Joseph dida ot e kumga ot ahi mumbangngad ot hi Simeon di ipabaludna yaden tigtiggondan namin. ");
INSERT INTO ifa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ot honagona mohpey e mangikalgah nan alandan makan ot ibagana boh nadan nangittu ta pun'ipongdah nadan uhhun di sakuda nan pihhun namayadda ya ta idadaananda didah balundah nan awon. ");
INSERT INTO ifa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ot pun'ikalgadah nadan dongki nan ginattangda ot makakda. ");
INSERT INTO ifa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mu hidih nan immiyananda i diyen nahdom ya inubad di ohay sakuna ta alana ha ipa'anah nan dongki ya tinigonan wahdi nan pihhun imbayadna hi uhhun nan saku. ");
INSERT INTO ifa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ya mungkalih nadan i'ibanan alyonay, Wahtu man tee nan numbayad'un impabangngaddah tun uhhun nan nisaku. Ya nginumhopda ta munggagayonggongdah takutda te alyonday, Tanganu nin on waha athituh pangat Apu Dios i dita'u. ");
INSERT INTO ifa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ta immanamutdah ad Kanaan ot uhuhondan amadan namin nadan na'na'at i dida, ");
INSERT INTO ifa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","an alyonday, Umman ma'abbungot nan gobelnador i da'mi te ipapilitna an e ami anu munsi'im hi bobleda. ");
INSERT INTO ifa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ot alyonmin hiyay, Agge ami attog immalihtun e munsi'im te da'mi ya adi ami munlayah an tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ya himpulu amit duwan (12) hina'aggi an ohay hi amami. Mu nama\"id di oha ya nan udidiyanmi ya nabati i amami. ");
INSERT INTO ifa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ya alyonaot di, Hay panginnilaa' an adi ayu munlayah ya mataynan di oha i da'yuhtu ya imme ayun udum ta iyanamutyu nadan makan an ginattangyu ta adida ma'ulat nadan tinaynanyu. ");
INSERT INTO ifa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mu mumbangngad ayuhtu an i'uyugyu nan udidiyanyu ta panginnilaa' nimpe an adi ayu munlayah ya agge ayu immalin munsi'im hitun boblemi. Ta ahi' mohpe ilubus tun ibayu ya mabalin bon umali ayun gumattang hitu. ");
INSERT INTO ifa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Hidin inubaddan namin nan bobod di sakuda ya tinigodan nipnipong an nun'iyuhhun nadan pihhun imbayadda. Ya timmakutdan namin an ta'on on hi amada. ");
INSERT INTO ifa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ya alyon Jacob i diday, Te on lo'tat ya napuhdan namin hantudan imbabale'. Te nama\"id hi Joseph ya ma''id hi Simeon ya ad uwani bo ya iyeyuh Benjamin. At'ehna ya te on ammunaa' hi e munligligat an e numanomnom. ");
INSERT INTO ifa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ya alyon Ruben i hiyay, Ta'on ya indinolmun ha''on hi Benjamin ta alina'eh on ma''id ha iyanamut'un hiya ya nan duwa attog an imbabale' an linala'i di pangiballoham. ");
INSERT INTO ifa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mu alyon Jacob di, Hi imbabale' e damdaman hi Benjamin ya adi mabalin hi mi'yalin da'yuh ad Egypt. Te innilayun hiya mo ya abuh han nabati hinan holagmi i inanan hi Rachel te on nimpe nate nan ibana. Ya alina mahan bo ya waday ma'at i hiyah adi maphod hinan awon ya undan adi' iyate te teen amammaa' mahan mo. ");
INSERT INTO ifa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nan bitil hi ad Kanaan ya nunhigla mahan mo. ");
INSERT INTO ifa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ta hidin napuh nan makan an na'alah ad Egypt ya alyon Jacob hinadan imbabalenay, Ume ayu bo ta e ayu gumattang hi anon ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ya alyon Judah di, O mu nganney atonmin pinadanan nan gobelnador an adimi anu ipidpidwan e mumpatigon hiya hi'on adimi i'uyug nan udidiyanmi. ");
INSERT INTO ifa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mu iyabulutmu'e ta mi'yali ya mabalin. ");
INSERT INTO ifa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mu adim'e pi'yaliyon ya adimi goton an ume te hiyah diyey inalinan ma''id'e nimpe ha i'uyugmi ya udu'dulnay adi ami mumpatigon hiya. ");
INSERT INTO ifa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ya alyon Jacob i diday, Tanganu onyu tuwali imbagan wahtuy ohan hi ibbayu? Tanganu onyu mamaon di e' inomnoman? ");
INSERT INTO ifa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ya alyonday, Manu'eh imbagami ya manahmahanay a'at ta'u an umat i he''a hi'on agge'a ni' anu nate ya hay awadan di udum hi i'ibami. Ya undan innilamih on imbagami'e ya mahapul bon tigonah Benjamin. ");
INSERT INTO ifa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ot alyon Judah i amaday, Pi'yaliyommot hi Benjamin ta wan makak ami te undan adi lo'tat ya inyate ta'uy inagang ta'un namin an namamah nadan u\"unga. ");
INSERT INTO ifa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ot ibaga' teen hi Benjamin ya tigo' ta ma''id ha ma'at i hiya. Mu alina'eh on waha ma'at i hiya ya ha''on di nangipabahulam hi inggana. ");
INSERT INTO ifa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Te onha otahan ha agge natanaktak di akakanmi ot wan numpidwa amin numbangngad hi ad uwani. ");
INSERT INTO ifa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ya alyon amaday, At'e damdamah nan gahin on mi'yali ya aga ta piliyonyu dohah nadan maphod an wahtun boble ta'u ta idatyu i diyen gobelnador. Ot mangalada i dohah nan danum di iyukan ya nadan middum hi makan ya nadan udum an bungan di nitanom. ");
INSERT INTO ifa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ya alyon bon Jacob i diday, Mahapul an munduway bilang di pihhun ikakyu ta ipabangngadyu nan bayad nan namangulun ginattangyu te alina hi nalinglingdah din nangikalgaanda. ");
INSERT INTO ifa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ta'omman mo ya inawityu tun ibayu ta mi'baga ayun ume. ");
INSERT INTO ifa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ot hanat nan ongal di abalinanan Dios ya hom'on da'yu ta mabalin an ilubusna nan ibayun hi Simeon ya ni'ibangngadonah Benjamin hitun umanamutanyu. Ya apyana'e tuwalin waday ma'at i dida ya ma\"id ha mabalin ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hidin indadaandan namin nadan midat hinan gobelnador ya nan pihhun nadubliy bilangna ot umeda an ni'yeh Benjamin. Ta hidin dimmatongdah ad Egypt ot eda tigon nan gobelnador. ");
INSERT INTO ifa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ya hidin tinigon Joseph hi Benjamin ot alyonah nan baalnan mumpapto' hi balena di, I'uyugmu datuwen linala'ih balemi ya pinaltim ha ihdami ya inha\"angmu ta mi''andan ha''on hi mawod. ");
INSERT INTO ifa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ta inunud nan baal nan inalin Joseph. ");
INSERT INTO ifa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ya hidin mangmangngedan hina'aggi ya way ohaon kimmobaal te hay ninomnomda ya alyonday, Manu'e nin hi inyali dita'uhtu ya gapuh din pihhun numbayad ta'uh hopapna an nipabangngad i dita'u. Ma''id ha mapto' on nganney atondan dita'u ya numbalinon dita'uh baalna ya ni'yalana tudan dongki ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ta hidin hiyah dimmatongdah nan way panto ot alyondah nan baal di, ");
INSERT INTO ifa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ibba', da'mi din immali boh tun gimmattang hi makan. ");
INSERT INTO ifa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mu hidin immanamut ami ya tinigomin nipnipong hi uhhun nadan sakumi nan pihhun numbayadmi. Ot wahtun inodnanmi ta ipabangngadmin he''a. ");
INSERT INTO ifa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ya indonanmi boy pihhu ta igattangmih makan. Te aggemi attog innila an nipabangngad nan pihhuh nadan sakumi. ");
INSERT INTO ifa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ya alyon nan baal i diday, Adi ayu minomnoman i nae ya adi ayu tumakut te nan Dios an dayawon amayu di nangiha''ad hidi ta pihhuyu. Te din imbayadyu'e ya nalpah tuwali an inala' i da'yu. Ot ena ilubus hi Simeon ot iyenah awadanda ");
INSERT INTO ifa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ot inayunan paghopon didah balen Joseph. Ot idatnay liting hi pun'ulahdah nan hupu' hi hukida ot ena panganon nadan dongkida. ");
INSERT INTO ifa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nadan i'iban Joseph ya indadaanda nan idatda i hiyah umanamutana i diyen mawod te nipa'innilan didan mi''andan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ta hidin immanamut hi Joseph ot eda idat nan inodnandan idatdan hiya ot munyu''ungdah hinangngabna. ");
INSERT INTO ifa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ya mahmahana an alyonay, Nganney a'at din alyonyun amamman hi amayu? On hiyah diye an matagu ni'? ");
INSERT INTO ifa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ya alyonday, O matagu nan baalmun hi amami ya mapmaphod an adi mundogoh. Ot munyu''ungda bo hi punlispitudan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ya hidin indodonganah Benjamin ya alyonay, On hiyah tuwe nan udidiyan an alyonyuh hi ibbayu? Ot alyonan hiyay, Hi Apu Dios di munwagah i he''an imbabale. ");
INSERT INTO ifa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Hidin inalinah diye ya innayunan immaan hidi te adi mitpol di luwanah nanigana i ibbanan hi Benjamin. Ot mahanoggop hi kuwartuna ot kumgahdi. ");
INSERT INTO ifa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ya hidin immudu'dul di punli'nana ot apuwanay angahna ot lumah'un ta ibaganah nan baalna ta manganda. ");
INSERT INTO ifa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hidin manganda ya e nahiwwen inumbun i han ohan lamehaan hi Joseph. Ya nadan i'ibana ya tinuppugda dida i han oha bon lamehaan. Ya nahiwweda bo nadan i Egypt te adida pohdon an midmiddum an mi''an hinadan Hebrew te nunhiglay pamihuldan dida. ");
INSERT INTO ifa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ya hay nangipabunandah nadan i'ibana ya hi way hinangngab Joseph. Ya nahohonnodda an inumbun an namangulu nan panguluwan ta ingganah nan udidiyan. Ta masda'awda an ugganda muntoto\"olan. ");
INSERT INTO ifa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ya nan midat an anonda ya ma'alan namin hinan lamehaan an panganan Joseph. Ya hi Benjamin di dakdakkol di indatdah anona te numpilimay dinakol di nidat i hiya mu nan nidat hinadan i'ibana. Ta mun'am'amlongdan ni\"an i Joseph ot inayundan uminum hi bayah. ");
INSERT INTO ifa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hidin makak nadan i'iban Joseph ya imbaganah nan baalnan mumpapto' ta kalgaana nan sakuda ya imbangngadna nan pihhudah nan uhhun di sakuda. ");
INSERT INTO ifa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ot ibagana bo ta iha''adna nan silber an basunah uhhun nan sakun Benjamin ta middum hinan pihhuna. Ot hidiyey aton nan baal. ");
INSERT INTO ifa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ta hidin hiyah nawi\"it ot makakdan hina'aggi an nun'itakkedah nadan dongkida. ");
INSERT INTO ifa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ya hidin hiyah aggeda immadawwi ya alyon Joseph hinan baalnan mumpapto' hi balenay, Eka ta tundom dida. Ta ni'akhup'a'e ya impa'ohnongmu dida ya inalim di, Tanganu mahan on mapmaphod di impatigon nan gobelnador i da'yu ya athinay pangatyun hiya? ");
INSERT INTO ifa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tanganu mahan on inye''eyu nan silber an basuna an hidiye nan pun'inumana ya usalonan mumbuyun? Adi ahan maphod hinaen inatyu. ");
INSERT INTO ifa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ta hidin ni'akhup hidiyen baal ot ibagana nan imbagan Joseph i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ya alyonday, Ibba', tanganu boh on athinay panapitmu? Ma''id man attog ha inatmih athina. ");
INSERT INTO ifa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","He\"a ya innilam di nangibangngadanmih din pihhun tinigomih nan uhhun nadan sakumi an numbayadmih hopapna an inilpumih ad Kanaan. Ya tanganu boh onmi iye''e ha silber onu balitu' hi balen nan ud baal i he\"a? ");
INSERT INTO ifa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tigomdih tudan kalgami ta inakhupam'e ya ta'on on mate nan nangala ya numbalinon da'min udum hi himbut nan ud baal i he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ya alyonay, Mabalin mu hay pinhod'u ya ammuna nan ohan nangala hi mumbalin hi himbut'u ya immanamut ayun udum. ");
INSERT INTO ifa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ta way oha mo i dida on nunlo'ahnay kalganah nan nangitakkayana on inubadnay sakuna. ");
INSERT INTO ifa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ta inhipun nan baal Joseph hinan sakun nan panguluwan di tigotigo ta ingganah nan sakun nan udidiyan an hi Benjamin. Ya hinan sakun Benjamin di nangakhupanah nan basu. ");
INSERT INTO ifa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ta punhethet nadan i'ibanay lubungda hi eda inomnoman. Ot pun'ittuda mo boy kalgadah nan dongkida ot ibangngaddan namin hi boble. ");
INSERT INTO ifa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ya hidin nidatongdah balen da Joseph ya wahdi ni' an agge nakak ot munyu''ungdah hinangngabna. ");
INSERT INTO ifa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ya alyon Joseph i diday, Tanganu mahan tuwalih on waha athinah inatyu? Undan aggeyu innila an nan tagun umat i ha''on ya waday atonan manginnilah nan mangako? ");
INSERT INTO ifa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ya alyon Judah di, Aggemi innilay ibagami i he''a Apu Gobelnador. Te ta'on onmi ibaga an ma\"id ha bahulmi ya ma\"id ha hilbina te hituwey pundusan Apu Dios i da'min baalmu hinan emi numbahulan. Ot hiya nan numbangngad ami ta ta'omman attog ya numbalin amin namin hi himbutmu ta adi ammuna nan ud saku hinan na'alaan nan basum. ");
INSERT INTO ifa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mu alyon Joseph di, Adi mabalin an e' aton hinae. Te ha\"on ya ammuna nan nangalah nan basu' di mumbalin hi himbut'u. Ot da'yun udum ya mabalin an umanamut ayu i amayu. ");
INSERT INTO ifa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ot e mihaggon hi Judah i Joseph ot alyonay, Apu Gobelnador innila' an he''a ya nipaddung di abalinam hinan patul mu adi'a bahan bumungot ta anusam an donglon hituwen ibaga'. ");
INSERT INTO ifa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Te hidin hopapna ya minahmaham hi'on waday hi amami onu ha udum hi hi ibbamih lala'i. ");
INSERT INTO ifa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ot alyonmiy wadah amami an amamma mo. Ya wada bo nan udidiyanmin lala'in nawadah din amamma moh amami. Ot ibagami bon wada han ohan hi ibbana mu nate ta oha nan udidiyan an nabati i didan holag amami i inana. Ta hiya nan hiya ahan di pohpohdon amami. ");
INSERT INTO ifa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ya hay imbagam i da'mih din nanguhuhanmi ya alyom hi i'uyugmi ta tigom. ");
INSERT INTO ifa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ot ibagami bon he''a an hiya ya adi mabalin hi taynanah amami te alinah hiyay iyaten amami. ");
INSERT INTO ifa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ya alyom hi adimi ipidpidwan mumpatpatigon he''a hi'on adimi i'uyug. ");
INSERT INTO ifa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ta hidin immanamut ami ot uhuhonmi nan inalim i amami. ");
INSERT INTO ifa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mu hidin napuh din inalamih tun makan ya alyon bon amamiy umali amin gumattang. ");
INSERT INTO ifa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mu imbagamin hiya an adi'e mi'yalih Benjamin ya adi mabalin hi mumbangngad amihtuh ad Egypt. Mu mi'yali'e ya mabalin te ninonomnommi nimpe din imbagam i da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ya alyon amamiy, Innilayun duwaday holagmi i ahawa' an hi Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mu tinaynana' hinan oha ta hay punnomnom'u ya inan di layon te ma''id ha numbangngad i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ot alyonyu'e boh tun hi ibbanay pangihiwanyu ta alina boh waha athidih ma'at i hiya ya onyu e pun'udman di e' inomnoman hi ad uwanin amammaa' ta alinah on hiyay inyate'. ");
INSERT INTO ifa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ot inayun Judah an alyon i hiyay, Hiya nan onha mumbangngada' ya tigonan ma''id ha inyanamut'u i Benjamin ");
INSERT INTO ifa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ot ay da'miy lummuh atayana. Te nunhiglay punnomnomna ituwen udidiyanmi. ");
INSERT INTO ifa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ya namama mahan teen imbaga' i hiya an alina'eh on waha athidih ma'at ya ha''on di ud bahul hi inggana. ");
INSERT INTO ifa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Undan bahan adi mabalin an ta'on attog ya ha''on di nihukkat i ibba' hi pumbalinom hi himbutmu ta hiyay mi'ibangngad hitudan i'iba'. ");
INSERT INTO ifa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Te ha''on ya ma''id damdama ha ato' an umanamut hi'on ma''id hituwen hi ibbami te adi' abalinan an tigon hi amami an nunhiglay ena inomnoman hi'on ma''id hi Benjamin. ");
INSERT INTO ifa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Lo'tat mo ahan ya adi pa''itpol hi Joseph hi li'nanah hinangngab nadan baalna. Ot palah'unona mo dida ta ammunadah nadan i'ibanan nabati. ");
INSERT INTO ifa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ya nunhiglay kogana ta dingngol nadan i Egypt ot eda ipa'innilah nadan wahdih nan palasyun nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ot alyon Joseph hinadan i'ibana di, Umman tatawwa ha''on hi Joseph. On immannung an matagu ni' hi ama? Mu nadan i'ibana ya namaag ya mano\"olda hi nangngolanda i diye an gapuh takutda. ");
INSERT INTO ifa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ot ayagana dida ta mihaggondan hiya. Ot ipidwan Joseph an alyon di, Ha''on nimpe hi ibbayun hi Joseph an inihbutyuh nadan immalihtu hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mu adi ayu minomnoman i diyen inatyun ha''on ya adi ayu bumungot hi adolyu an gapuh nangigattanganyun ha\"on. Te hay nangipiyalih tun ha''on ya hi Apu Dios ta wan ha''on di usalona ta way aton di tatagun mihwang ituwen bitil. ");
INSERT INTO ifa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Te duway tawon mo teeh tuwen bitil ya minaynayun hituwe hi limay tawon ta mamama mon adi tummol di mitanom. ");
INSERT INTO ifa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ta hiyah tuwe nan impamanguluwa' hitu i Apu Dios ta mipatigo nan ongal an abalinanan mangihwang i dita'u ituwen bitil. ");
INSERT INTO ifa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ta hiya nan hay immannung ya bokon da'yuy nangipiyalih tun ha\"on te hi Apu Dios. Ta ha''on di nuntugun hinan patul ta inyukodnan ha\"on nan pun'ap'apuwana ya an namin an ma'ma'at hi abobbobleh tun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ot aga ta umanamut ayu ta eyu ibagan ama an alyonyuy, Hi imbabalem an hi Joseph ya hiyay numbalinon Apu Dios hi gobelnador hi ad Egypt. Ya imbagana an mi'baga ta'u anun umehdin namin. ");
INSERT INTO ifa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ta e ta'u munhituh ad Gosen hidih ad Egypt ta wan mihaggon ta'un hiya ta hidi ta'un namin an he\"a ya da'min imbabalem ya nadan apapum ya nadan kalnerom ya bakam ya an namin an wadan he''a. ");
INSERT INTO ifa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Te hiya anuy ukod hinan mahapul ta'u te minaynayun anuh tuwen bitil hi limay tawon. Ya aggena pinhod an ma'ulat ta'u ya ma'agangan nadan halun ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ot inayun bon Joseph an alyon di, Tigonyu ot ha\"on mahan hituwen munhapihhapit i da'yu. Ya namama i he''a ibba' Benjamin ya imatunana' mahan i he\"a. ");
INSERT INTO ifa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ot ipa'innilayu i ama di anabaktun di sa'ad'u ituwen boble ya nadan udum an tintinnigoyuhtu. Ta umanamut ayu ta eyu awiton hi ama ya immali ayuhtu. ");
INSERT INTO ifa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ta imbaganah diye ot awalonah ibbanan hi Benjamin an mungkoga. Ya ta'on on hi Benjamin ya inawalna damdama an mungkoga. ");
INSERT INTO ifa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ta hiyah diyen mungkogah Joseph on ena pun'awal nadan i'ibana ta inggana ot opngona didan namin. Ot mi'hapitda mohpe nadan i'ibana i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ya hidin na'innilaan nan patul ya nadan ap'apuh nan palasyu hidiyen immaliyan nadan i'iban Joseph ya ta'on on dida ya ma\"amlongda. ");
INSERT INTO ifa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ot alyon nan patul i Joseph di, Ibagam hinadan i'ibam ta pungkalgaanda nadan dongki hi makan ta ahida umanamut hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ta eda awiton hi amam ya an namin nadan pamilyadan tinaynandahdi. Ta umalidahtu ta idat'un dida nan ma'allumong an lutahtu hi ad Egypt ta hidiy eda iha''adan ta adida makulangan hi mahapulda. ");
INSERT INTO ifa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ya imbagam bo i dida ta alandahtu ha ahida pangiluganan hinadan binabai ya nadan mammanog an imbabaleda ya hi amayu ta umalidahtu. ");
INSERT INTO ifa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ya adida minomnoman hi panaynandah nadan numpunhituwanda ot ten idat'un dida nan ap'aphodan an lutah tun ad Egypt ta pumboblayanda. ");
INSERT INTO ifa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ot aton nadan imbabalen Jacob hidiyen imbagan nan patul. Ta indat Joseph di punlugananda ya hay anonda hinan awon hi umayanda ya hay pumbangngadanda. ");
INSERT INTO ifa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ot idattan bon Joseph didan namin hi lubung. Mu hi Benjamin ya limay indatnan hiya ya han tuluy gahut (300) di silber an pihhu. ");
INSERT INTO ifa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ya hay impadonah midat i amana ya himpuluy (10) dongki an nangikalgaandah dakol an mun'aphod an ma'alah ad Egypt. Ya himpulu (10) boy tinna an dongki an nun'akalgaan hi boga ya tinapay ya nadan udum an mahapul amadah nan awon hi umaliyanda. ");
INSERT INTO ifa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ta hidin nidadaan an namin nadan kalgada ot honagona mohpe dida an alyonay, Ekayu mohpe ya adi ayu munhahannuh nan awon. ");
INSERT INTO ifa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ta nakakdah ad Egypt ot umanamutdah ad Kanaan hi awadan amadan hi Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ta hidin dimmatongda ot alyondan amaday, Umman eh'a mataguh Joseph an hiyay gobelnador hi ad Egypt. Mu namaag ya nano''ol hi Jacob i diyen inalida an adina patiyon. ");
INSERT INTO ifa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mu hidin inuhuhdan namin nan imbagabagan Joseph i dida ya hidin tinigona nadan impadona i dida an iluganana hi umayandahdi ya immamlong hi amadan hi Jacob ya numbangngad nan bikahna. ");
INSERT INTO ifa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ot alyonay, Maphod ta athinan mataguh imbabale' an hi Joseph. Mahapul mahan an umeya' ta e' tigon ta ahiya' mate. ");
INSERT INTO ifa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Hi Jacob ya nun'idadaanan namin nadan mabalin an odnanda ot ahida makak. Ya hidin dimmatongdah ad Beerseba ot umohnongda ni' ta idawat Jacob nadan i'nongnah nan Dios an dayawon amanan hi Isaac. ");
INSERT INTO ifa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ya waday nipatigo i hiya i diyen nahdom an himmapit hi Apu Dios i hiya ot alyonay, Jacob! Jacob! Ot tobalona an alyonay, O wahtuwa'. ");
INSERT INTO ifa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ya alyon Apu Dios di, Ha\"on nan Dios an dayawon amam ot adi'a tumakut an umeh ad Egypt te ha''on di ukod i da'yu ta pumbalino' hi dakkodakkol nadan holagmuhdi. ");
INSERT INTO ifa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Te wadaa' an bumoddang i da'yu hi umayanyuh ad Egypt ya ha\"on boy ahi mangibangngad hinadan tanudam ituwen bobleh udum hi algo. Mu he''a ya hidih ad Egypt di atayam. Ta hi a'unguham ya wadah Joseph an mihahaggon i he''a. ");
INSERT INTO ifa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ta hidin nabiggat ot milugan da Jacob ya nadan mammanog an apapuna ya nadan binabai hinan indat nan patul an ilugananda ot makakdahdih ad Beerseba. ");
INSERT INTO ifa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","An ta'on on nadan halunda ya nadan udum an inilpudah nan nunhituwandah ad Kanaan ya intakinda. Ta imme da Jacob hi ad Egypt an dida nimpen namin hinadan holagna ");
INSERT INTO ifa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","an imbabalena ya apapuna. ");
INSERT INTO ifa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Hay ngadan nadan linala'in imbabalen Jacob an hay ohah ngadana ya hi Israel ya nadan apapuna an immeh ad Egypt ya hi Ruben an panguluwan ");
INSERT INTO ifa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ya nadan imbabalenan da Hanok ya hi Pallu ya hi Hesron ya hi Karmi. ");
INSERT INTO ifa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ya nan imbabalena bon hi Simeon ya nadan tinanudana an hi Jemuel ya hi Jamin ya hi Ohad ya hi Jakin ya hi Sohar ya hi Saul. Hi Saul ya imbabalen Simeon i han i Kanaan. ");
INSERT INTO ifa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ya nan imbabalena bon hi Libay ya nadan imbabalena an da Gerson ya hi Kohat ya hi Merari. ");
INSERT INTO ifa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ya nan imbabalena bon hi Judah ya nadan imbabalenan hi Er ya hi Onan ya hi Selah ya hi Peres ya hi Serah mu da Er i Onan ya nateda tuwalih ad Kanaan. Ya hay imbabalen Peres ya da Hesron i Hamul. ");
INSERT INTO ifa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ya nan imbabalena bon hi Issakar ya nadan imbabalenan hi Tola ya hi Puah ya hi Jasub ya hi Simron. ");
INSERT INTO ifa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ya nan imbabalena bon hi Sebulun ya nadan imbabalenan da Sered ya hi Elon ya hi Jahleel. ");
INSERT INTO ifa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ta danae nadan imbabalen Jacob i Leah an agge niddum nan babain imbabaledan hi Dinah. Ya danaen imbabaleda ya nawadadah din awadandah ad Paddan-Aram. Ya hay bilangdan namin ya tulumpulut tulu (33). ");
INSERT INTO ifa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ya nan imbabalena bon hi Gad ya nadan imbabalenan hi Sepon ya hi Haggi ya hi Suni ya hi Esbon ya hi Eri ya hi Arodi ya hi Areli. ");
INSERT INTO ifa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ya nan imbababalena bon hi Aser ya nadan imbabalenan hi Imnah ya hi Isbah ya hi Isbi ya hi Beriah ya nan babain hi Serah. Ya hi Beriah ya wadaday linala'in imbabalenan da Heber i Malkiel. ");
INSERT INTO ifa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ta danae nadan imbabalen da Jacob hinan indat Laban an tagalan Leah an hi Silpah. Ta an naminda ya himpulut onom (16). ");
INSERT INTO ifa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ya hay imbabalen da Jacob i Rachel ya da Joseph i Benjamin. ");
INSERT INTO ifa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ya nadan imbabalen Joseph hi ad Egypt ya da Manasseh i Epraim. Hay hi inada ya hi Asenat an imbabalen nan padi hi ad On an hi Potipera. ");
INSERT INTO ifa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ya hay imbabalen Benjamin ya hi Bela ya hi Beker ya hi Asbel ya hi Gera ya hi Naaman ya hi Ehi ya hi Ros ya hi Muppim ya hi Huppim ya hi Ard. ");
INSERT INTO ifa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ta himpulut opatdan (14) namin di tinanud da Jacob i Rachel. ");
INSERT INTO ifa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Hi Dan ya imbabalenah Husim. ");
INSERT INTO ifa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ya hi Naptali e ya hay linala'ih imbabalena ya hi Jahsiel ya hi Guni ya hi Jeser ya hi Sillem. ");
INSERT INTO ifa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dida damdama nadan imbabalen da Jacob hinan tagalan indat Laban i Rachel an hi Bilhah. Ta hay bilangdan namin ya pitu. ");
INSERT INTO ifa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ta an naminda an tinanud Jacob an aggeda ni'bilang nadan binabain ahawan nadan imbabalena ya nanomdat onom (66) an immeh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ya middumda'e nadan duwan imbabalen Joseph an niyayyam hi ad Egypt ya napitudah (70) ngammutna an tinanudan Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Hidin dimmatongdah ad Egypt ya impamangulun Jacob hi Judah ta ena ibaga i Joseph ta ena damuwon didah ad Gosen. ");
INSERT INTO ifa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ot e mo milugan hi Joseph hinan punluganana ot umeh ad Gosen ta ena damuwon hi amana an hay ohah ngadana ya hi Israel. Ta hidin nundammuda ot pi'bagonan iyawal i amana ot aganah kogakoga. Ta nadnenadne ot ahi duminong. ");
INSERT INTO ifa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ya alyon Jacob i hiyay, Ad uwani ya nundadaana' mohpen mate mu ta athitun tinigo da'a an matagu'a aya. ");
INSERT INTO ifa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ot alyon mohpen Joseph hinadan i'ibana ya nadan udum an wadah nunhituwan amana di, Aga mo ta umeya' ta e' ipa'innilah nan patul an dimmatong ayu mohtu hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ya imbaga' bon hiya an hay tamuyu ya on ayu munhalun ta in'uyugyun namin nadan halunyu ya an namin nadan gina'uyu. ");
INSERT INTO ifa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ot ipa'ayag da'yu'en hiya ta ibaganah on nganney tamuyu ya mahapul an alyonyuy, ");
INSERT INTO ifa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Da'mi an baalmu ya hay tamumi hi nihipun tuwalih a'u''ungami ya mumpapto' hinadan halunmi an umat damdamah nadan a'ammodmi. Athidi'ey ibagayu ya mabalin an hituh ad Gosen di iyabulutnah punhituwanyu. Te nadan tataguh tun ad Egypt ya nunhiglay pamihuldah nadan mumpapto' hi kalnero. ");
INSERT INTO ifa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hi Joseph ya immeh awadan nan patul ot alyonay, Dimmatongda mo da ama ya nadan i'iba' an nalpuh ad Kanaan an inaladan namin nadan halunda ya nadan gina'uda ot wahdidan immohnongdah ad Gosen. ");
INSERT INTO ifa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ot ipa'innilanah nan patul nadan liman i'ibanan in'uyugna. ");
INSERT INTO ifa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ya alyon nan patul i diday, Nganney tamuyu? Ya alyonday, Da'min baalmu apu patul ya hay tamumi ya mumpapto' hi kalnero an umat hi tamun handidan a'ammodmi. ");
INSERT INTO ifa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mu ten immali amih tun bobleyuh ad uwani te nunhigla nan bitil hi ad Kanaan ta ma''id ha anon nadan halunmi. Ot mabalin'e bahan ya inyabulutmu ta ad Gosen di iha''adanmi. ");
INSERT INTO ifa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ya alyon nan patul i Joseph di, Ad uwani ya immali da amam ya nadan i'ibam ");
INSERT INTO ifa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ot ukod'an mangdat hinan ap'aphodan an lutah tun ad Egypt. Punhituwom didah ad Gosen ta hidiy iha\"adanda. Ya wadada'en diday abalinanan e mumpastol hinadan halun'u ya inyukodmun dida. ");
INSERT INTO ifa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ot e awiton Joseph hi amana ot ena ipa'in'innilah nan patul. Ot wagahan Jacob hidiyen patul. ");
INSERT INTO ifa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ya mahmahan nan patul di tawona ");
INSERT INTO ifa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ya alyon Jacob di, Hinggahut ta tulumpulu (130) moh ad uwani. Ya nunhiglay impala\"uh'uh ligat. Mu ho'dod hituwen tawon'u an adi umat hinadan a'ammod'u. ");
INSERT INTO ifa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ta hidin nalpah an himmanappitanda ot ipidwan Jacob an wagahan nan patul ot ahida taynan. ");
INSERT INTO ifa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ot aton Joseph nan imbagan nan patul ta inyena da amana ya nadan i'ibanah nan ap'aphodan an boble an ad Rameses hidih ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ot idat Joseph di mahapuldan namin an miyunnudan hinan bilangdan hina'ammay inatnan nangipiyappong. ");
INSERT INTO ifa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Namammama nan bitil ta lo'tat ya ma\"id ha anon nadan i Kanaan ya ta'on on nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ya nan inamung Joseph an pihhun nadan i Egypt ya i Kanaan an inggattangdah makan ya inyenah nan palasyun nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ya hidin ma''id mo ha nabatih pihhun nadan tataguh ad Egypt ya ad Kanaan ya immeda i Joseph ot alyonday, Ma''id mo ha pihhumi mu mahapul damdaman idattan da'mih anonmi te undan adi ami mun'a'aten namin. ");
INSERT INTO ifa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ya alyon Joseph i diday, Ma''id'e mo ha pihhuyu ya inyaliyu nadan halunyu ta hiyay ihukkatyuh anonyu. ");
INSERT INTO ifa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ta hiyay inatda an nun'iyeday kabayu ya kalnero ya gulding ya baka ya dongki ta dadiyey inhukkatdah anonda. ");
INSERT INTO ifa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mu hidin itawonnana ya mumpapangeda bo nadan tatagu i Joseph ot alyonday, Nganney mabalin i ha athitun ma''id mo ha pihhumi ya napuhda mo bo nadan halunmi te inhukkatmin namin i he''a. Ta ma''id mo ha nabati hi mabalin hi idatmi an ammunay adolmi ya nadan lutami. ");
INSERT INTO ifa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Undan bahan adi da'mi hom'on ta ta'on attog ya hay adolmi ya nadan lutamiy inggattangmih makan ta wan adi ami mate. Ta ta'on attog on ami numbalin hi baal nan patul ta hiya moy mangilutah nadan lutami. Ot idattan da'mi bahan hi anonmi ya ha itanommi. ");
INSERT INTO ifa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ta ginattang mon Joseph an namin nadan lutah ad Egypt ta lutan nan patul. Te an namin nadan i Egypt ya napilitandan nangigattang hinadan lutada an gapuh nan nunhiglan bitil. Ta an namin mo nadan lutah ad Egypt ya nan patul moy ud luta. ");
INSERT INTO ifa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ya atbohdin numbalindah baalnan namin nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mu nan lutan nadan padi ya nunnanong an agge nigattang te waday idat nan patul tuwalih anonda ta hiya nan adi mahapul an ihukkatda nadan lutadah makan. ");
INSERT INTO ifa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ot alyon Joseph hinadan tataguy, Ad uwanin ginattang'u nadan lutayu ya ta'on on da'yu ta mibilang ayu moh baal nan patul ya aga ta idat'uy eyu itanom. ");
INSERT INTO ifa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mu nadatongda'e tuwali nadan intanomyu on inaanyu ha dowwan nan patul ta hinan limay nabto' on waha midat hi ohay nabto'. Ta nan mabati ya hidiyey pangalanyuh ahiyu bo itanom ya inanyu mohpen hina'amma nan nabati. ");
INSERT INTO ifa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ya alyon nadan tataguy, Munhana ami ta himmo' da'mi i he\"a. Ot gapu ta maphod di inatmu i da'mi ya munhilbi ami hinan patul. ");
INSERT INTO ifa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ta numbalinon Joseph hi uldin hidiye an ahigapas'e on mahapul an idat nadan tataguh nan patul nan dowwana. Ta ingganah ad uwani ya hidiyen uldin di unudondah ad Egypt. Ta ammuna nan lutan nadan padi di bokon lutan nan patul. ");
INSERT INTO ifa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mu nadan tinanud Israel an immohnong hi ad Gosen ya lo'tat ya kimmadangyanda ya dimmakkodakkolday imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ya hi Jacob ya himpulut pituy (17) tawon damdamay niha''adanahdi hi ad Egypt te immeh hinggahut ta han napat ta pituy (147) tawona ot ahi mate. ");
INSERT INTO ifa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ya hidin agagga mo ya mate ya inayaganah Joseph ot alyonan hiyay, Hay ma'udih dawato' i he''an imbabale' ta ahiya' mate ya iyuhhunmuy ta'lem hi ulpu' ta isapatam an adiya' ilubu' hitun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Te pinhod'un mateya\"e ya inyanamuta' ta eya' ilubu' hinan nilubu'an nadan a'ammod'u. Ya inabulut Joseph hidiyen inalin amana. ");
INSERT INTO ifa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ot alyon Jacob i hiyay, Mahapul an isapatam an atom. Ot isapatan Joseph an atona nan inalin amana. Ot mumballin hi Jacob hinan nalo'ana ot munlu'bub ta dayawonah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Indani ya nipa'innila i Joseph an mundogoh hi amana. Ot uyugona mo nan duwan imbabalena an da Manasseh i Epraim ot eda tigon. ");
INSERT INTO ifa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ya hidin dingngol Jacob an dimmatong da Joseph ya intulidnan bimmangon ot umbun hinan alo'ana. ");
INSERT INTO ifa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ot alyonan Joseph di, Ipa'innila' i he''a an hidin awadanmih ad Lus hi ad Kanaan ya numpatigo nan ongal di abalinanan Dios i ha''on ot wagahana'. ");
INSERT INTO ifa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ot alyonan ha''on di, Nomnomnomom an pumbalino' hi dakkodakkol di holagmu ta diday pangidata' ituwen boblen ad Kanaan ta wan diday mangiluta hi inggana. ");
INSERT INTO ifa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ot inayun Jacob an alyon i hiyay, Nan duwan imbabalem an da Manasseh i Epraim an niyayyamdah tun ad Egypt ot ahiya' umali ya pohdo' an ibilang didah imbabale' ta umat i da Ruben i Simeon an waday boltanondan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mu nadan udum mon imbabalem ya bokon athidi ta hay mangidat hi boltanonda ya da Manasseh i Epraim. ");
INSERT INTO ifa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Manu'e hi ibilang'u da Manasseh i Epraim ya gapuh natayan inam an hi Rachel hi ad Kanaan hidin adadatong ta'uh ad Eprat hi nalpuwan ta'uh ad Paddan-Aram. An nunhiglay hakit di nomnom'u ot ilubu''uh nan way kalatah ad Eprat an hay ohah ngadana ya hi ad Bethlehem. ");
INSERT INTO ifa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ya hidin tinigon Jacob nadan duwan imbabalen Joseph ya alyonay, Nganne datuwen linala'i? ");
INSERT INTO ifa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ya alyon Joseph di, Datuwe nadan imbabale' an indat Apu Dios i ha''on hitun ad Egypt. Ya alyon Jacob i hiyay, Iyalim didahtu ta wagaha' dida. ");
INSERT INTO ifa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ya i diye ya adi mo pa'attigoh Jacob te amamma mo. Ta e inhaggon mon Joseph nadan imbabalena i hiya ot awalon Jacob dida. ");
INSERT INTO ifa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ot alyon Jacob i Joseph di, Alyo\"ot on adi da'a mo tigon mu maphod ta ad uwani ya inyabulut Apu Dios an ta'on on tun imbabalem ya tinigo' dida. ");
INSERT INTO ifa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ot padligon Joseph nadan imbabalena ot e mundu''un hi hinangngab amana an nida\"om di angahna hinan dotal. ");
INSERT INTO ifa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ot ahina iyeh Manasseh hi nangappit hi winawwan apuna ya hi Epraim hi way iniggidna. ");
INSERT INTO ifa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mu numpa'telon Jacob di ta'lena ta hay ulun Manasseh di nangiha'mawanah iniggidna ya hay winawwana i Epraim an ta'on on hiyay manmannog. ");
INSERT INTO ifa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ot wagahanan alyonay, Hi Apu Dios an nunhilbiyan handidan a'ammod'un da Abraham i Isaac ya hiya boy numpapto' i ha''on hi ingganah ad uwani. ");
INSERT INTO ifa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ya nan anghel an namoddang i ha''on hi an namin an punligatan ya hanat wagahana datuwen u''unga. Ya hanat gapun dida ya mundingngol di ngadan'u ya hay ngadan handidan a'ammod'un da Abraham i Isaac. Ya hana bo ta munholagda ta dumakkodakkolda. ");
INSERT INTO ifa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ya hidin tinigon Joseph an hay ulun nan mi'adwa di nangiha'mawan Jacob hi winawwana ya aggena pinhod hi nanigana. Ot odnana moy winawwan amana ta enaot iyaldan hi ulun Manasseh ");
INSERT INTO ifa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","an alyonan amanay, Bokon hinae te tun panguluwan di pangiha'mawam hi winawwanmu. ");
INSERT INTO ifa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mu iyadin amanan alyonay, O innila' tun at'atto' imbabale'. Hi Manasseh ya dumakol damdama boy holagna. Mu tun manmannog an ibana ya nabakbaktu ya dakdakkol di holagna. ");
INSERT INTO ifa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ta winagahana dida i diyen algo an alyonay, Pohdo' an hay ngadanyuy ngadanon nadan holag'un hi Israel hi'on ayu munhinwawagah ta alyonyuy, Hanat wagahan da'yun Apu Dios ta umat ayu i da Epraim ya hi Manasseh. Ta namangulun nginadan Jacob di ngadan Epraim ot ahi hi Manasseh. ");
INSERT INTO ifa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ot alyon Jacob i Joseph di, Innila' an adi mo madne ya mateya'. Mu hi Apu Dios di bumoddang i da'yu ta hiya nan ibangngad da'yuh nan boblen nadan a'ammod ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ot he''a Joseph an bokon nadan i'ibam di pangdata' hinan ma'allumong an bobleh ad Sekem. Hiyah diye din inabak'uh nadan tinanud Amor hinan ispada' ya pana'. ");
INSERT INTO ifa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Impa'ayag Jacob nadan imbabalena te pinhodnan ibaga nadan ahi ma'at i didah udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ta na'amungda ot alyonan diday, Aga ta ma'amung ayun imbabale' ta donglonyu tun ibaga' an hi amayu. ");
INSERT INTO ifa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","He''a Ruben an panguluwan ya niyayyam'ah din mangiloga' an ongal di abalina'. Ta he''ay nabakbaktu ya ong'ongngal di abalinana i da'yun hina'aggi. ");
INSERT INTO ifa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mu umat'ah nan liting an hi kittang on nat'on di nangipluyana ta hiya nan adi minaynayun di ipabaktuwam te nunhiglay inatmun ha''on an hi amam hi em nangilo'an hinan ohan ahawa'. ");
INSERT INTO ifa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ya da'yu'e Simeon i Libay ya numpaddung di nomnomyu an hay pangiyusalanyuh ispadayu ya pamateyu. ");
INSERT INTO ifa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mu ha''on an hi amayu ya adi' ahan unnudan hinaen at'atonyu an gapuh bungotyu ya pumate ayu. Ya bokon'e bo ya nan akhupanyun halun di bahbahonyu. ");
INSERT INTO ifa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ot hiya nan hay dusayu ya miwakat nadan holagyu. ");
INSERT INTO ifa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","He''a'e Judah ya ipabaktu da'ah tudan i'ibam ta he''ay tangadonda. Ya abakom di binuhulmu te mabikah'a ");
INSERT INTO ifa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ya mi'alig'ah nan layon an nalpah'en inana nan pinatena ya imbangngadnah nan niha''adana ta e mohpe malmallo'. Ya ma''id ha mangipatnan e mamangon i hiya. ");
INSERT INTO ifa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ot he''a ya nadan tanudam di nanongnah nabakbaktu hi ma'unud ta ingganah umali nan ohan pinto' tuwalin Apu Dios hi mun'ap'apu ta hiyay unudon di tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ya an namin di mahapulna ya wada. Te nan itanomnan greyp ya ma'abbungada ta ta'on ona e iga'od nan dongkinahdi ta pungkalatna nadan greyp ya mahawwalan damdamay apitona an miyammah bayah. Ta onha mabalin ot hiyay pangilaba'anah lubungna. ");
INSERT INTO ifa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ya gapu ta dakol di inumondan bayah ya bumabbatag di matada. Ya pulaw di bobada te nan dakol an gatas an inu'inumonda. ");
INSERT INTO ifa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","He''a'e Sebulun ya nan da'ging di baybay di em punhituwan an duma\"alan di papol. Ya hay pumboblayanyu ya ingganah ad Sidon. ");
INSERT INTO ifa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","He''a'e Issakar ya mipaddung'ah nan dongki an ta'on on mabikah ");
INSERT INTO ifa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","mu tigona'e nan maphod an pumpastolan ya immet e malo' hidi. Ya gapu ta hidiy pohdonan umohnongan ya lo'tat ya pumbalinon nan ud lutan diye hi himbut. ");
INSERT INTO ifa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ya he''a'e Dan ya minaynayun an ma'ohha ayun himpamu'un an umat hinadan udum an i'ibam. Ya atbohdin da'yuy ukod an mumpapto' hinadan tanudanyu an bokon hay udum an tatagu. ");
INSERT INTO ifa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Te umat'ah nan ulog hinan da'ging di awon an wa'e ha mala''uh kabayu ya ingkalatnah hukinat magah nan nitakke. ");
INSERT INTO ifa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ot inayun Jacob an mundasal an alyonay, He''a Apu Dios di pangidinla' hi managun da'mi. ");
INSERT INTO ifa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ot ahina bo alyon di, He''a'e Gad ya pudugon da'ah mangako mu wa'e ta munligguh'a ya diday pumpudugmu. ");
INSERT INTO ifa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ya he''a'e pibo Aser ya maphod di puntanomam te dakol di apitom hi mun'aphod an makan an ay anon di patul. ");
INSERT INTO ifa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","He''a'e Naptali ya umat'ah nan nibu'an an ulha an mun'ap'aphodday imbabalem. ");
INSERT INTO ifa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ya he''a'e Joseph ya mipaddung'ah nan ma'abbungan greyp an nitanom hinan way wa\"el an nanaphapang ta kumayatdah nan binattun alad ");
INSERT INTO ifa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","an ta'on on nunnaud di hinoltapmuh nan inatdan he''a an ay da'a nunhimpapanaan. ");
INSERT INTO ifa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mu gapuh boddang nan ongal di abalinanan Dios an dayawon ta'u ya agge'a na'abak. Te hi Apu Dios an nanongnan mumpapto' i dita'u di ihi\"ugan ta'u. ");
INSERT INTO ifa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ot hi Apu Dios an ongal di abalinanan namoddang i ha''on an hi amayu di mangidat hi an namin an mahapulmu an umat hi udan ya potang ya ta'on on nan liting an malpuh nan luta. Ta dumakol di halunmu ya holagmu ya bungan di iliya'mu. ");
INSERT INTO ifa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ot danaey punwagah'un hi amam i he\"a hi ipaphodam an ma\"id ha nipaddungana. Ta midat i he''an namin danae ta he\"a Joseph di mun'ap'apuh nadan ibbam te ongal di abalinam. ");
INSERT INTO ifa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ya he''a'e Benjamin ya natulid'an umat'ah nan kahuh nan inalahan an mabalin an abakona nan binuhulna ta waday iyanamutna. ");
INSERT INTO ifa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ta danaey imbagan Jacob hinadan himpulut duwan imbabalena an niyunnudan hinan nat'onat'on an a'atda. ");
INSERT INTO ifa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ya alyon bon Jacob i diday, Innila' an agagga moy ataya' ta eya' middum hinadan a'ammod'u. Ot hay pohdo' hi eyu pangilubu'an i ha''on ya hidih nan lingab hinan lutan nan tinanud Hit an hi Epron ");
INSERT INTO ifa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","hidih ad Makpelah an dommang di ad Mamre hi ad Kanaan. Te hiyah diye din ginattang din hi apu an hi Abraham hinan tinanud Hit an hi Epron ot pumbalinonah lubu'an. ");
INSERT INTO ifa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ta hidiy nilubu'andan himbale i Sarah ya ta'on on da Isaac i Rebekah. Ya hidi boy nangilubu'a' i Leah. ");
INSERT INTO ifa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ya adi ammuna nan lingab hi ginatangan apu an hi Abraham hinan tinanud Hit te ta'on on nan puntanoman hidih nan haggona. ");
INSERT INTO ifa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ya hidin nalpah an imbagan Jacob danaeh nadan imbabalena ot buma'tad hinan alo'ana ot inayunan ma'unguh. ");
INSERT INTO ifa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ya na'ibagan immeh Joseph ot awalonah amana on mungkoga. ");
INSERT INTO ifa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ot ibaganah nadan mumbalsamal ta balsamalondah amana. ");
INSERT INTO ifa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ta napat (40) di algo ot ahida igibbuh an numbalsamal te athidiy pangatdan i Egypt. Ot umukayungandah napituy (70) algo. ");
INSERT INTO ifa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ya hidin nagibbuh an imbaluwanda ot alyon Joseph hinadan ap'apu an puntamuwon nan patul di, Ibagayu bahan hinan patul tun alyo'. ");
INSERT INTO ifa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Te hi ama ya nunsapataona' ot ahi mate an mahapul an ad Kanaan hinan iniphodnan lubu'an di e' pangilubu'an i hiya. Ot hiyay ibagayu bahan hinan patul ta wan iyabulutnay umaya' ta e' ilubu' hi amahdi ya ahiya' mumbangngad. ");
INSERT INTO ifa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ya hidin imbagadah diyeh nan patul ya inyabulutnan alyonay, O ta'omman ya imme'a ta unudom nan insapatam i amam. ");
INSERT INTO ifa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ot makak mo da Joseph an ni'ikakdan namin nadan mi'tamuh nan patul ya an namin nadan ap'apuh abobboble hi ad Egypt ");
INSERT INTO ifa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ya da Joseph mohpe an hina'amma ya nadan i'ibana an dida damdaman hina'amma. Ta hay nabatih ad Gosen ya ammuna nadan mammanog an imbabaleda ya nadan halundan gulding ya kalnero ya baka. ");
INSERT INTO ifa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ya wadada boy ni'ye an nungkabayuday udum ya numpunluganday udum hinadan kalesa ta dakkodakkoldan imme. ");
INSERT INTO ifa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ya hidin nipto'dah nan pun'ilikan hi ad Atad an nihaggon hinan wangwang an nungngadan hi Jordan ot umohnongda ni' hidi ot oltondan kumgah hakit di nomnomda. Ot ipangpangulun Joseph han pundayawanda i diyen pumbaluwanda hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ya nadan i Kanaan an nanigo i diyen immukayungan nadan i Egypt ya alyonday, Immannung an nahamad di immukayunganda an gapuh nan nate. Ta hiya nan nginadanandah diyen boble ta ad Abel-Misraim. ");
INSERT INTO ifa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ta nadan imbabalen Jacob ya inatda nan imbagan amadah atonda. ");
INSERT INTO ifa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","An inyanamutday adolnah ad Kanaan ot eda ilubu' hinan lingab hi ad Makpelah an ginattang Abraham hinan tinanud Hit an hi Epron. Hidiyen lingab ya nihaggon hi ad Mamre. ");
INSERT INTO ifa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ta hidin nagibbuh an inlubu' da Joseph hi amana ot mumbangngaddah ad Egypt an didan namin hinadan i'ibana ya an namin nadan i Egypt an ni'ye i dida. ");
INSERT INTO ifa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nadan i'iban Joseph ya nawada moy olomda i Joseph hidin nateh amada te alyonday ma''id ha mapto' ya iballohna mon dida din inatdan hiya. ");
INSERT INTO ifa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ta hiya nan hinnagda han e nangipa'innilan hiya an alyonday, Hidin atagun ama ta'u ");
INSERT INTO ifa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ya inalinan da'mi ta ibagamin he''ay em punlinglingan hidin adi ahan maphod an inatmi an da'min baal nan Dios an dayawon ama ta'u. Ta hi Joseph ya namaag ya kumgah din nangibagaan nan hinnagda. ");
INSERT INTO ifa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ot ume nadan i'ibanah awadana ot munyu''ungdah way hinangngabna ot alyonday, Da'mi ya nundadaan amin mumbalin hi baalmu. ");
INSERT INTO ifa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mu alyon Joseph i diday, Adi ayu tumakut i ha''on te bokon ha''on hi Apu Dios an hiya nan munhumalya ya mundusah tagu. ");
INSERT INTO ifa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Da'yu ya manu te adi maphod di inatyun ha''on. Mu hi Apu Dios ya numbalinonah maphod ta mabalin an ad uwani ya adida mate nadan tatagu an gapu ituwen bitil. ");
INSERT INTO ifa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ot hiya nan adi ayu tumakut ot ha''on di ukod an mangdat hi mahapul nadan imbabaleyu ya ta'on on da'yu. Ta nipa'amlongda mohpe an gapuh nan ma'ulen hapitna i dida. ");
INSERT INTO ifa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hi Joseph ya ninayun an hidih ad Egypt di nunhituwana an didan namin hinadan i'ibanan holag amana ta inggana ot mateh din hinggahut ta han himpuluy (110) tawona. ");
INSERT INTO ifa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ta tinigonay apapun Epraim ya ta'on on nadan imbabalen Makir an imbabalen Manasseh te ibilangna didan pitlun di apapuna. ");
INSERT INTO ifa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hidin agagga ya mateh Joseph ya imbaganah nadan i'ibanan alyonay, Adi madne ya mateya' mu hi Apu Dios di ukod an mangibangngad i da'yuh nan boblen inalinah idatnah nadan holag Abraham ya hi Isaac ya hi Jacob. ");
INSERT INTO ifa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ot hamadonan didan alyonay, Hitun ibangngadanyuh ad Kanaan ya tigonyu bahan ta odnanyu nadan tungal'u. Ot isapatadan atonda. ");
INSERT INTO ifa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ta hi Joseph ya nateh din hinggahut ta himpuluy (110) tawona ot balsamalonda ot iha''adda i han lungun.");
INSERT INTO ifa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Hi Jacob an nginadanan Apu Dios hi Israel ya immedah nadan linala'in imbabalena hi ad Egypt. Ya hay ngadan nadan imbabalena ");
INSERT INTO ifa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ya hi Ruben ya hi Simeon ya hi Libay ya hi Judah ");
INSERT INTO ifa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ya hi Issakar ya hi Sebulun ya hi Benjamin ");
INSERT INTO ifa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ya hi Dan ya hi Naptali ya hi Gad ya hi Aser. ");
INSERT INTO ifa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ta hay bilangdan namin an tinanud Israel i diyen immayandah ad Egypt ya napitu (70). Mu hi Joseph e ya namangulu mo tuwalih ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ya hidin immey atnay tawon ya nateh Joseph ya nadan i'ibana ya an namin nadan papaddungda i didan tinanud. ");
INSERT INTO ifa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mu nadan tinanudanda ya nun'a'ahlagda ta dimmakkodakkolda ta niwakatdah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Indani ya nihukkat han patul hi ad Egypt an aggena innilay a'at handin hi Joseph. ");
INSERT INTO ifa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ya alyonah nadan tatagunay, Inoy an dimmakkodakkol nadan tinanud Israel hitun boble ta'u ta dida bo udot moy dakdakkol mu dita'u. ");
INSERT INTO ifa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ot mahapul an waha aton ta'u i dida ta way atondan adi ma'udman an ma'udman te onha udum hi algo ya waday gubat ot ma''id ha mapto' ya middumdah nadan mangubat i dita'u ya innayundan binumtik. ");
INSERT INTO ifa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ot pumbalinonda nadan tinanud Israel hi himbut ot pot'onda doha ta diday ap'apuda ta diday mummandal i dida an muntamu. Ta impiyammada nadan boble hi ad Pitom ya hi ad Rameses. Ta datuwen boble di pangi'amungan nan patul hinadan makan. ");
INSERT INTO ifa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mu ta'on on athidiy inatdan namalpaligat hinadan tinanud Israel ya namaman dimmakolda ta niwakatdah ad Egypt. Ta namamay pangiyaguh nadan i Egypt i dida. ");
INSERT INTO ifa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ot iyal'alada mo bon nangigalid i dida. ");
INSERT INTO ifa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ta nunhiglay nangatdan namalpaligat i dida an ma\"id ha homo'da te adi ammuna nadan ipiyammadan pito' an hamintu an miyammah nadan balen di i Egypt te ta'on on nadan nat'onat'on an tamuh nadan puntanomanda. ");
INSERT INTO ifa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ya indani bo ya imbagan nan patul hinadan Hebrew an mundawat hi golang an da Siprah i Puah ");
INSERT INTO ifa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","an alyonay, Tigonyu ta lala'i'e nan dawatonyun iyayyam nadan ibbayun Hebrew on pinateyu. Mu babai'e ya aggeyu. ");
INSERT INTO ifa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mu aggeda inunud te hi Apu Dios di taktanda ta ma''id ha pinatedah nadan dinawatdan goggolang an ta'on on lala'i. ");
INSERT INTO ifa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ta impa'ayag mo bon nan patul dida ot mahmahanay gapunah aggeda nangunudan hinan imbaganan dida. ");
INSERT INTO ifa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ya alyonday, Te nadan Hebrew ya agaggay eda pun'ayyaman an adida umat hinan i Egypt te adi ami dumatong on nun'ayyamda. ");
INSERT INTO ifa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ta dimmakkodakkolda ta ongal di abalinanda. Ya dadiyen mundawat hi golang ya winagahan Apu Dios dida. ");
INSERT INTO ifa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ta indattana didah holagda an gapu nimpe ta hi Apu Dios di taktanda. ");
INSERT INTO ifa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ya lo'tat mahan ya imbagan nan patul hi an namin hinadan i Egypt an alyonay, An namin nadan goggolang an linala'i an imbabalen di tinanud Israel ya eyu pun'ibkah dida hinan wangwang an nungngadan hi Nayl mu ta'omman ya imbatiyu nadan binabai. ");
INSERT INTO ifa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Indani ya wada han lala'in tinanud Libay an inahawana han ibbana damdaman tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ta numbutyug nan babai ot mun'ayyam ya lala'i. Ya hidin tinigon inana an mapmaphod di agolangna ot ipapa''enah tuluy bulan. ");
INSERT INTO ifa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mu hidin ma''id mo ha atonan mangipa''e ot mangala i han bahket an hay niyamma ya nan katlubung ot bitolona ta adi hunggop di liting hi dallomna. Ot iha''adnahdi nan golang ot ena patapla'on hinan nun'ahlo'an hinan way da'ging di wangwang an nungngadan hi Nayl. ");
INSERT INTO ifa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ot ipa'adugnah nan babai an imbabalena ta tigonay ma'at hinan golang. ");
INSERT INTO ifa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ya indani ya wada nan babain imbabalen nan patul hi ad Egypt an e mun'amoh hinan wangwang. Yaden nadan tatagalana ya dumanaldallanandah nan da'ging di wangwang. Ya nangimangmangan nan imbabalen di patul han bahket hinan nahlo'an ot honagonay ohah nadan tagalana ta ena alan. ");
INSERT INTO ifa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ta inyenan hiya ot bukatana ya tinigona nan golang an mungkoga ta himmo'na. Ya alyonay, Imbabalen mahan teen di Hebrew. ");
INSERT INTO ifa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ya imme nan unga an hi ibban nan golang hi awadan diyen babai ot alyonay, Pohdomdan ta e' ayagan ha babai an Hebrew ta hiyay mangipapto' hinan golang? ");
INSERT INTO ifa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ya alyonay, O, eka. Ot ma'anne mo nan unga ot ena awiton hi inada. ");
INSERT INTO ifa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ta immali ot alyon nan imbabalen di patul i hiyay, Awitom ta ipapto'mu ta ukoda' hinan bo'laom. Ot hidiyey atona. ");
INSERT INTO ifa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ta hidin immong'ongngal nan unga ot ahina iyeh nan imbabalen nan patul ta hiya moy ay nangimbabale. Ot ngadanana ta hi Moses te alyonay, Hay nangala' i hiya ya hinan nalitingan. ");
INSERT INTO ifa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Hidin kimmilog hi Moses ot umen ena ipadutu'an di ma'ma'at hinadan ibbanan Hebrew. Ya tinigonan nunhiglay eda pumpalpaligatan. Ya indani ya tinigona han i Egypt an pumpaluwana han ohan Hebrew. ");
INSERT INTO ifa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ya hidin munligguligguh hi Moses ya tinigonan ma''id ha manmannigon hiya ot patayonah diyen i Egypt ot ika\"utnah nan awadan di panag. ");
INSERT INTO ifa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ya hidin nabiggat bo ya inakhupana han duwan ibbanan Hebrew an mun'awwitda. Ot alyonah nan bimmahul di, Tanganu onmu punhuntuk nan ibam? ");
INSERT INTO ifa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ya alyon diyen lala'i di, Undan pinto' da'ah ap'apu hi mangipanuh hi tatagu? Wan alyom bo on ta patayona' ta umat hinan inatmuh nan i Egypt hi ad ugaban. Ya timmakut hi Moses ot inayunan bumtik te alyonah nomnomnay, Te on waday nanginnilah nan inat'u. ");
INSERT INTO ifa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Hidin na'innilaan nan patul ya pinhodnan ipapateh Moses mu ma''id ha mabalina te niluh an binumtik hi ad Midian ot hidiy ena iha''adan. Ta han hin'algo an um'umbun hi Moses hinan way obob hidih ad Midian ");
INSERT INTO ifa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ya immaliday pitun binabai an imbabalen nan padihdi hi ad Midian an humagub ot talwanda nadan pun'inuman nadan halun amada an eda impastol. ");
INSERT INTO ifa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Indani ya wadaday udum an mumpastol ot hukwitonda dadiyen binabai. Mu immeh Moses ot ena boddangan dida ot pa'inumana nadan halunda. ");
INSERT INTO ifa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ta na'inumanda nadan halunda ot umanamut dadiyen hina'aggi. Ya alyon amadan hi Rewel di, Tanganu mohpe on ad uwani ya agagga ya immanamut ayu? ");
INSERT INTO ifa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ya alyonday, O te wada han lala'in i Egypt an bimmoddang i da'mih din hukwiton da'mih nadan udum an mumpastol hidih nan obob. Ta hiya eh'ay himmagub ot pa'inumana nadan halun ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ya alyonay, Ot daan? Tanganu onyu tinaynan hidi? Ekayu ayagan ta mi''an i dita'u. ");
INSERT INTO ifa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ot eda mo ayagan. Ya inabulut Moses ot mi'hituhdi i da Rewel. Ya indani ya impa'ahawana i Moses nan imbabalenan hi Sipporah. ");
INSERT INTO ifa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ta nawada han imbabaleda an lala'i. Ot alyon Moses di, Ha''on ya ona' ni'iboblehtu ot ngadana' ta hi Gersom. ");
INSERT INTO ifa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ya hidin nala''uh di atnay tawon ya nate nan patul hi ad Egypt. Mu nadan tinanud Israel ya hiyah diye an nunhiglay holholtapondah nadan ipatamuda i dida ta hiya nan mumpahpahmo'da i Apu Dios ta boddangana dida. ");
INSERT INTO ifa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ya dingngol Apu Dios nan pumpaboddangandan hiya te aggena liningling nan imbaganah din a'ammodda an da Abraham ya hi Isaac ya hi Jacob an atona i dida. ");
INSERT INTO ifa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ta tinigon Apu Dios nan punholholtapan nadan tinanud Israel ya ongal di homo'nan dida ta pohdonan boddangan dida. ");
INSERT INTO ifa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Hi Moses ya hiyay mumpapto' hinadan halun nan padi hi ad Midian an hi Jetro an hi aman ahawana. Ta han hin'algo ya ena impastol nadan halun hinan agge naboblayan ta dimmatong hinan niyappit i Apu Dios an billid an nungngadan hi Horeb. ");
INSERT INTO ifa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ya numpatigo nan anghel Apu Dios i Moses an ay mundaldallang an apuy hinan kaykayyiw. Ya tinigon Moses an mundaldallang nan kaykayyiw mu munnanannong an adi magmagbu. ");
INSERT INTO ifa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ot alyon Moses hi nomnomnay, Agandi anu ta e' idodongan te tanganu on waha athidih dumaladalang on adi magmagbu. ");
INSERT INTO ifa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mu hidin tinigon Apu Dios an mun'ihaghaggon hi Moses ya mungkalih nan way mundalang an kaykayyiw an alyonay, Moses! Moses! Ya alyon Moses di, Tanganu, Apu Dios? ");
INSERT INTO ifa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ya alyon Apu Dios i hiyay, Mipogpog'ahna ta adi'a mi''ihnup hitu. Ya aanom di hapatutmu ta ipatigom di pangipabaktum i ha''on te hituwen awadam ");
INSERT INTO ifa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ya wahtuwa' an Dios an dayawon din a'ammodmu an da Abraham ya hi Isaac ya hi Jacob. Ya punhawanan mohpen Moses di angahna te tumakut an mangitigo i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ot inayun Apu Dios an alyon i hiyay, Tinigo' an nunhiglay ipaligligatan nadan ibbam an tatagu' an tinanud Israel hi ad Egypt. Ya dingngol'u nan pumpahpahmo'andan ha''on te nunhiglay pangigalid nadan mummandal i didah nan tamu. ");
INSERT INTO ifa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ya hiya nan immaliya' ta e' okakon didahdi hi ad Egypt ta ipangulu' didah nan boblen malumong ya damuna ya makadangyan an nunhituwan nadan tinanud Kanaan an dida nadan tinanud Hit ya tinanud Amor ya tinanud Peris ya tinanud Hib ya tinanud Jebus. ");
INSERT INTO ifa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Te dingngol'u nimpe nan pumpahpahmo'an nadan tatagu' ya atbohdin tinigo' nan nunhiglan pamalpaligat nadan i Egypt i dida. ");
INSERT INTO ifa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ot hiya nan ad uwani ya honagon da'an ha''on hinan patul hi ad Egypt ta he''ay e mangipanguluh nadan tatagu' ta umaandahdi. ");
INSERT INTO ifa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mu alyon Moses di, Apu Dios, undan ihya nganneya' ta namaag ya eya' mi'hapit hinan patul ya e' okakon hidi nadan ibba' an tinanud Israel? ");
INSERT INTO ifa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ya alyon Apu Dios di, Adi'a minomnoman ot ha''on di mangitnud i he''a. Ta nalpah'en immaan ayuh ad Egypt i dadiyen ipangulum an tatagu' ya immali ayu ta dayawona' ituwen billid. Ta hinaey panginnilaam an ha''on di nannag i he''a. ");
INSERT INTO ifa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ya alyon bon Moses di, Hitun umaya' ya manu te ibaga' hinadan ibba' an tinanud Israel an he''a an Dios an dinayaw nadan a'ammodmi di nannag i ha''on. Mu mahmahanda'ey ngadanmu ya nganney ibaga'? ");
INSERT INTO ifa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ya alyon Apu Dios di, Ha''on. ");
INSERT INTO ifa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ya ibagam bon dida an ha''on nan Ap'apu an un'unudon nadan a'ammodyun da Abraham ya hi Isaac ya hi Jacob di nannag i he''a. Ya hiyah nae boy ngadan'uh inggana. Ot an naminday matanudan ya mahapul an hiyay pungngadanda i ha''on. ");
INSERT INTO ifa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ot ume'a ya impa'ayagmu nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ta ma'amungda. Ya imbagam i dida an ha''on nan Dios an un'unudon nadan a'ammodyu ya numpatigowa' i he''a. Ya impa'innilam bon dida an ha''on ya tigtiggo' nan pamalpaligat nadan i Egypt i dida. ");
INSERT INTO ifa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ta hiya nan ninomnom'un pakakon didahdi i diyen eda pumpalpaligatan ta iye' dida i han boblen makadangyan ya malumong an boblen nadan tinanud Kanaan an dida nadan tinanud Hit ya tinanud Amor ya tinanud Peris ya tinanud Hib ya tinanud Jebus. ");
INSERT INTO ifa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ot innila' an donglonda nan ibagam. Ya nalpah'en imbagam i dida ya nun'u'uyyug ayuh nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ta e ayu mi'ihapit hinan patul. Ta imme ayu'e ya alyonyuh nan patul di, Hi Apu Dios an dayawonmin Hebrew ya numpatigo i da'mi. Ot iyabulutmu ni' ta mumbaat amih tuluy algoh nan agge naboblayan ta hidiy emi pangidawatan hinadan mi'nong i Apu Dios an dayawonmi. ");
INSERT INTO ifa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ya alyon bon Apu Dios di, Innila' an hidiyen patul ya adi da'yu pakakon ta ingganah on mapilit. ");
INSERT INTO ifa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ta hiya nan gapuh nan abalina' ya ato' di dakol an atatakut ta pundusa' hinadan i Egypt ta lo'tat ya iyabulutnay akakanyu. ");
INSERT INTO ifa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ya atbohdin wadao' di pamiyal nadan i Egypt i da'yu ta hitun akakanyu ya pun'idatdan da'yu nadan nun'abalol an odonda ta makak ayun waday odnanyu. ");
INSERT INTO ifa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ta wa'e ta agagga moy akakanyu ya an namin ayun binabain tinanud Israel ya e ayu mumbagah nadan hinaggonyu an binabain i Egypt hi lubung ya silber ya balitu' ta waday usalon nadan imbabaleyu. Ta alanyu nadan kinadangyan nadan i Egypt ya ahi ayu makak. ");
INSERT INTO ifa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ya alyon Moses i Apu Dios di, Mu nganney ato' hi'on adiya' patiyon hinadan ibba' an Hebrew ta adida unudon nan ibaga' i dida te alina ya alyonday agge immannung an numpatigo'a i ha''on? ");
INSERT INTO ifa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ya alyon Apu Dios i hiyay, Nganneh naen inodnam? Ya alyon Moses di, Han hu''ud. ");
INSERT INTO ifa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ya alyon Apu Dios di, Ibkahmuh nan luta. Ot ibkah Moses ya numbalin hi ulog ta mamtik hi Moses. ");
INSERT INTO ifa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mu alyon bon Apu Dios i hiyay, Odnam di iwitna ya intaggem. Ot ipudong Moses nan ulog ot itaggena ya numbalin boh hu''ud. ");
INSERT INTO ifa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ot alyon Apu Dios di, Atom hinah umayam hidi ta pamatiyan nadan ibbam an tinanud Israel an ha''on an Dios an dayawon nadan a'ammodyun da Abraham ya hi Isaac ya hi Jacob ya numpatigowa' i he''a. ");
INSERT INTO ifa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ya alyon bon Apu Dios di, Ihwongmuy ta'lem hi dallom di lubungmu. Ot aton Moses ot ahina ukaton ya nunhiglay gulidna an pimmulaw moy ta'lena. ");
INSERT INTO ifa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ot ibagan Apu Dios bo ta ipidwan Moses an ihwong di ta'lenah dallom di lubungna. Ot aton Moses ot ahina ukaton ya numbangngad mohpe an maphod mo nan up'up di ta'lena. ");
INSERT INTO ifa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ot alyon bon Apu Dios di, Wa'e ta adida patiyon nan mamangulun milagro an atom ya inatmu bo nan mi'adwa ta alina ya patiyonda mahan mo. ");
INSERT INTO ifa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mu hi'on atom danaen duwa ya hiya damdaman adi da'a patiyon ya imme'ah nan wangwang an nungngadan hi Nayl ya em pinau' dohah nan liting ya inhiitmuh nan luta. Ot nan liting ya mumbalin hi dala. ");
INSERT INTO ifa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ya alyon Moses di, Apu Dios mu ha''on ya adiya' mahapit an ta'on on hi ad uwanin numpatigam i ha''on ya hiyah tuwen agge immudu'dul di panapit'u an ona' umanen'en'en damdama. ");
INSERT INTO ifa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ya alyon Apu Dios di, Undan nganney nangiphod hi to'on di tagu? Ya undan nganney mabalin an mamukit hi tagu ya mangipabugol i hiya? Ya undan nganney waday abalinanan mamilok hi mata onu hay mabalin hi maniyat ta tumigo? Undan bokon ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Agam otya ta ume'a ta boddangan da'an humapit te ha''on di ukod an mangibagan he''ah nadan ibagam. ");
INSERT INTO ifa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ya alyon damdaman Moses di, Apu Dios, hay udum bahan di honagom. ");
INSERT INTO ifa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ya bimmungot hi Apu Dios i Moses ot alyonay, Ot nan ibam mon hi Aaron di pun'ibbam an hiyay mahapit i da'yun tinanud Libay. Ot ad uwani ya wahnan awon an ipluynahtu ta damuwon da'a. Ya ma\"amlong an manigo i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ot munhapit ayu ta nan ibagam di hiyay ibaganah tun umayanyu. Ot boddangan da'yun ha\"on ta ipa'innila' i da'yu nan ibagayu ya nan atonyu. ");
INSERT INTO ifa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ta hi Aaron di pahapitom hinadan tatagu ta hiyay mangibagah nadan ibagam i hiya. Ya he''ay ay Dios hi mangipa'innilan hiyah nadan ibagana. ");
INSERT INTO ifa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ya odnam nan hu''udmu te hinaey usalom an mangat hi dakol an milagro hinadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ya hidin nalpah an na'at hidiye ot umanamut hi Moses. Ot alyona i Jetro an hi aman ahawanay, Aga ta munhapitta te ten umeya' hi ad Egypt ta e' padutu'an hi'on nganney ma'ma'at hinadan i'iba' hidi. Ya inyabulut Jetro. ");
INSERT INTO ifa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ya hidin wahdi ni' hi Moses hi ad Midian ya alyon Apu Dios i hiya di, Mumbangngad'ah ad Egypt ot an namin nadan naminhod ni' an mamaten he''a ya nun'a'ateda mo. ");
INSERT INTO ifa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ot makakda mo da Moses an nuntakkayonah ahawana ya nadan linala'in imbabaleda hinan dongki ot ipluydah ad Egypt an inodnana nan hu''ud an inalin Apu Dios hi odnana. ");
INSERT INTO ifa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ya inalin bon Apu Dios i Moses di, Hitun dumatnganyuh ad Egypt ya ipatigom hinan patul an namin nadan milagro an ipa'at'un he''a ot ha''on ya idat'uy abalinam an mangat i dadiyen namin. Mu ipakodhol'uy nomnom nan patul ta ta'on hi tigona ya adina damdama ipakak nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ya gapu i diyen ena pangipagolan i dida ya ibagam i hiya ta alyom di, Hi Apu Dios ya alyonay pinto'na nadan tinanud Israel hi ay panguluwan an lala'in imbabalena. ");
INSERT INTO ifa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ta iyabulutmun makak nadan tataguna ta eda dayawon hiya mu ipagolmu. Ot hiya nan hay atona ya patayona nan panguluwan an lala'in imbabalem. ");
INSERT INTO ifa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ya hidin awadan da Moses hinan awon an umeh ad Egypt ya wada han nahdom an unhaot pinaten Apu Dios hi Moses an gapu ta aggena inunud nadan tugun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mu nan ahawanan hi Sipporah ya inalana han nahulitan an batu ot pungkugitnah nadan imbabaleda. Ot ida\"omnah hukin Moses nan ginogodnan up'up ot alyonay, Maphod ta timmagu'a an gapuh dalan nan imbabaleta. ");
INSERT INTO ifa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ta agge mo pinaten Apu Dios hi Moses an gapu i diyen inat Sipporah. ");
INSERT INTO ifa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ya hi Aaron ya hinnag tuwalin Apu Dios ta ena damuwon da Moses hinan agge naboblayan. Ta nundammudahdih nan way billid an niyappit i Apu Dios ot awalon Aaron hi ibbanan hi Moses. ");
INSERT INTO ifa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ot uhuhon Moses i Aaron nadan imbagan Apu Dios an nannag i hiya ya ta'on on nadan imbaganan atondan milagro. ");
INSERT INTO ifa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ot inayun mon da Moses i Aaron an umeh ad Egypt. Ot ayagandan namin nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ot ma'amungda. ");
INSERT INTO ifa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ot ipa'innilan Aaron an namin nadan imbagan Apu Dios i Moses. Ot ahi mohpe ipatigon Moses i dida nadan milagro an ipa'at Apu Dios i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ya nadan tatagun nanigo ya patiyondan hi Apu Dios di nannag i dida ot inayundan iyungyung ta dayawondah Apu Dios te inniladan ongal di homo'nan dida hinan eda punholhotapan. ");
INSERT INTO ifa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hidin nalpah an nunhahapit da Moses ya nadan mangipangpanguluh nadan tinanud Israel ot ume da Moses i Aaron hinan patul ot alyondan hiyay, Immali ami ta ibagamin he''a nadan inalin Apu Dios an dayawonmin tinanud Israel. Te hay inalina ya iyabulutmu anu ta ume amin tatagunah nan agge naboblayan ta wan e ami mundayaw i hiyahdi. ");
INSERT INTO ifa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mu alyon nan patul di, Nganneh naen Dios ta e' unudon ta iyabulut da'yun tinanud Israel an ume? Agge' innilah naen Dios ot adi' iyabulut an ume ayu. ");
INSERT INTO ifa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mu alyon da Moses i Aaron di, O mu hi Apu Dios an dayawonmin Hebrew ya numpatigon da'mi ot alyonay mahapul an mumbaat amih tuluy algo hinan agge naboblayan ta hidiy emi pangidawatan hinadan i'nongmin hiya. Te adi da'mi'e iyabulut ya patayon da'min hiya an bokon'e dogoh di pamatena ya gubat. ");
INSERT INTO ifa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mu alyon nan patul di, Undan nganne ayu ta eyu ni' taktakon nadan tataguh nan tamuda? Ibagayuot ta mumbangngaddah nadan puntamuwanda. ");
INSERT INTO ifa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tigonyuot da'yun tinanud Israel di dakdakkol hi ad uwani mu da'min i Egypt ya pohdonyu bon duminongdan muntamu. ");
INSERT INTO ifa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ya nihipun i diyen algo ya minandalot nan patul nadan i Egypt an mummandal ya nadan tinanud Israel an mangipangpanguluh nan tamu an alyonay, ");
INSERT INTO ifa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Adiyu mo idattan didah nadan dagamin iddumdah nan pito' an lutuwonda ta ukoddan e manama'. ");
INSERT INTO ifa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Te wan kulang nadan tamuwanda ta hiya nan imbagaday pangiyabuluta' ta eda anu mundayaw hinan Dios an dayawonda. Ya ibagayu bon didan mahapul damdaman hiyah diye nan bilang di miphod hinan ohay algo ta adi makulangan hi ta'on on oha. ");
INSERT INTO ifa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tigonyu ta wan ma'udman di tamun danaen tinanud Israel ta ma''id ha atondan e mundongol hinadan ibagabagan nadan mumpunlayah. ");
INSERT INTO ifa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ta imme dadiyen ap'apu an mummandal hinan mumpuntamu ot alyonday, Imbagan nan patul an adi da'yu mo anu idattan hi dagami ");
INSERT INTO ifa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ta ukod ayun e manama' mu mahapul an hiyah diye damdama nan bilang nan iphodyuh nan hin'algo. ");
INSERT INTO ifa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ta nadan tinanud Israel ya eda mo himmanawwangan an e manama' hi dagamih ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Yaden nunhiglay pangigalid nadan mummandal i dida te pinhoddan hiyah diye damdamay bilang di iphoddah nan hin'algo ta umat damdamah din waday dagami an midat i dida. ");
INSERT INTO ifa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ta nadan tinanud Israel an napilin mangipangpanguluh nan tamu ya diday nangiboholan nadan i Egypt an mangimandal i dida. Ta nunhoplatda didan alyonday, Tanganu on oh'ohha nadan iniphodyu an adi umat handi? ");
INSERT INTO ifa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ta dadiyen tinanud Israel an mangipangpanguluh nan tamu ya immedah nan patul ot munlilidan alyonday, Apu patul, ngalngalam bo ahan tatawway pangatmun da'mi? ");
INSERT INTO ifa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Undan bahulmih on immoh'ohhay bilang nadan iniphodmih ad uwani ta namaag on da'mi punhoplat? Manu'eh din hopapna ya da'yu othadiy nangidat hinadan dagamin usalonmi. ");
INSERT INTO ifa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ya alyon nan patul di, Bahulyu te humiga ayun aggeyu pinhod an muntamu ta on hay pangiyabuluta' hi eyu pundayawan i Apu Dios di ibagabagayu. ");
INSERT INTO ifa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ekayuot ta mumbangngad ayuh nadan puntamuwanyu. Ya ta'on hi ma''id ha dagamih midat i da'yu mu mahapul an hiyah diye damdama nimpe nan bilang di iphodyuh nan hin'algo. ");
INSERT INTO ifa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ta dadiyen e ni'ihapit an tinanud Israel ya inilmudan iyal'alanan adi maphod di ma'at i dida te hanan nangalin nan patul i dida. ");
INSERT INTO ifa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ya hidin limmah'unda ya wada da Moses i Aaron an manmannod i dida. ");
INSERT INTO ifa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ot diday pun'ipadngolandan alyonday, Hi Apu Dios an nanigoh nan inatyu ya hanat hiyay mundusa i da'yu te gapu i da'yu ya ma'ahihhiwo nan patul ya nadan ap'apu i da'mi. Ummannot eyu inat ha pangigadulandan mamate i da'mi. ");
INSERT INTO ifa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ot mi'ihappitan mo boh Moses i Apu Dios ot alyonay, Apu Dios, tanganu onmu punholholtapon hantudan tatagu? Undan hituwey gapunah em nannagan i ha\"on hitu? ");
INSERT INTO ifa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Te nihipun hi e' ni'ihapitan hinan patul ot ibaga' nadan inalim i ha\"on ya onnot on namamay pamalpaligatdah nadan tatagum. Yaden ma''id ahan ha impatigom hi boddangmun dida. ");
INSERT INTO ifa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Alyon Apu Dios i Moses di, Ad uwani ya tigom di ato' hinan patul. Te gapuh nan ongal an abalina' ya piliton da'yu mon pakakon i hiya ta mi'baga ayun umaan i naen boble. ");
INSERT INTO ifa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ot alyona boy, Ha''on hi Apu Dios ");
INSERT INTO ifa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","an numpatigo i da Abraham ya hi Isaac ya hi Jacob ta impa'innila' an ongal di abalina'. Mu agge' ni' impa'innila i dida nan ngadan'un hi Apu Dios an Ap'apu. ");
INSERT INTO ifa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ya ni'ihapita' tuwali i dida an hay imbaga' ya idat'un da'yu nadan bobleh ad Kanaan an eda ni'hituwan te bokon ni' diday ud boble. ");
INSERT INTO ifa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ot ad uwanin dingngol'uy pumpahpahmo'anyun tatagu' an numbalin hi himbut nadan i Egypt ya nipanomnom i ha''on hidiyen imbaga' i dida. ");
INSERT INTO ifa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ot hiya nan ibagayuh nadan ibbayun tinanud Israel an ha''on an hi Apu Dios ya boddangan da'yu ta pogpogo' nan nihbutanyu i dida. Ya ipatigo' nan ongal an abalina' ta dusao' nadan i Egypt ta wan ihwang da'yu i ha\"on hinan eyu punholholtapan. ");
INSERT INTO ifa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ya atbohdi an da'yu nadan ibilang'u hi tatagu' ta ha''on di Dios hi dayawonyu. Ya hay panginnilaanyun ha''on hi Apu Dios ya hitun umaananyu i naen nihbutanyu te pakakon da'yuh tun ad Egypt an ipalpaligatanyu. ");
INSERT INTO ifa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ta ipangulu da'yuh nan boble an imbaga' hi idat'u i da Abraham ya hi Isaac ya hi Jacob ta da'yun tinanudday e mumboblehdi te ha''on nimpeh Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ta hidiyey e imbagan Moses hinadan tinanud Israel mu adida donglon an gapuh nan nunhiglan punholholtapanda. ");
INSERT INTO ifa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ot alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ume'a boh nan patul ya imbagam i hiya ta iyabulutnay akakanyun tinanud Israel i naen boble. ");
INSERT INTO ifa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ya alyon Moses di, Apu Dios tinigom ot ta'on on tudan ibba' an tinanud Israel ya adiya' donglon ot namama mo ahan hinan patul. Ya manu'e nin ya adiya' othadi mahapit. ");
INSERT INTO ifa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Mu alyon Apu Dios i didan Aaron di, Ibagayuh nadan ibbayun tinanud Israel ya nan patul an hay imbaga' ya da'yuy mangipanguluh nadan ibbayun tinanud Israel ta makakdah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ot datuwe nadan ap'apu hinadan himpahimpamu'un an tinanud Israel. Nan panguluwan an hi Ruben ya hay linala'ih imbabalena ya hi Hanok ya hi Pallu ya hi Hesron ya hi Karmi. ");
INSERT INTO ifa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Hi Simeon ya hay linala'ih imbabalena ya hi Jemuel ya hi Jamin ya hi Ohad ya hi Jakin ya hi Sohar ya nan imbabalenah nan i Kanaan an hi Saul. ");
INSERT INTO ifa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Hi Libay ya hay linala'in imbabalena ya hi Gerson ya hi Kohat ya hi Merari. Ya hay tawon Libay ya hinggahut ta tulumpulut pitu (137) ot ahi mate. ");
INSERT INTO ifa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Nan imbabalen Libay an hi Gerson ya hay linala'ih imbabalena an nunholag ya hi Libni ya hi Simey. ");
INSERT INTO ifa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ya hi Kohat ya hay linala'ih imbabalena ya hi Amram ya hi Isar ya hi Hebron ya hi Usiel. Ya hay tawon Kohat ot ahi mate ya hinggahut ta tulumpulut tulu (133). ");
INSERT INTO ifa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ya hi Merari ya hay linala'ih imbabalena ya hi Mahli ya hi Musi. Ta danae nadan ap'apu hinadan himpahimpamu'un an tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ya hi Amram ya inahawanah Jokebed an hi ibban amana ta nawadada da Aaron i Moses. Ya hay tawon Amram ya hinggahut ta tulumpulut pitu (137) ot ahi mate. ");
INSERT INTO ifa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ya hi Isar ya hay imbabalenah linala'i ya hi Korah ya hi Nepeg ya hi Sikri. ");
INSERT INTO ifa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Hi Usiel ya hay linala'ih imbabalena ya hi Misael ya hi Elsapan ya hi Sitri. ");
INSERT INTO ifa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Hi Aaron ya inahawanah Eliseba an hi ibban Nason an hay hi amada ya hi Amminadab. Ta hay linala'ih imbabaleda ya hi Nadab ya hi Abihu ya hi Eleasar ya hi Itamar. ");
INSERT INTO ifa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Hay linala'ih imbabalen Korah ya hi Assir ya hi Elkanah ya hi Abiasap. Ta datuwe nadan ap'apuh nadan himpahimpamu'un an tinanud Korah. ");
INSERT INTO ifa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Hi Eleasar an imbabalen Aaron ya inahawana nan imbabalen Putiel ta nawadah Pinehas. Ta dida nadan ap'apuh nadan himpahimpamu'un an tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ya hay nangibagaan Apu Dios hi mangipanguluh nadan tinanud Israel ta umaandah ad Egypt ya da Aaron i Moses an tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ya diday immeh nan patul ot eda ibagay pangiyabulutanah akakan nadan tinanud Israel hidih ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ta hidin ni'ihapit hi Apu Dios i Moses hidih ad Egypt ");
INSERT INTO ifa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ya alyonay, Ha''on hi Apu Dios. Ot ume'ah nan patul ya imbagam an namin nadan imbaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mu hay nambal Moses ya alyonay, Apu Dios innilam ot ha''on ya adiya' mahapit ot undan ihya donglona' hinan patul. ");
INSERT INTO ifa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ya alyon Apu Dios i Moses di, Idat'uy abalinam ta hay umayanyuh nan patul ya he\"ay ay Dios ya hi ibbam an hi Aaron di pahapitom. ");
INSERT INTO ifa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ot ibagam i Aaron an namin nan ibaga' i he\"a ta hiyay ukod an mangibagah nan patul ta iyabulutnan makak ayun tinanud Israel hi bobleda. ");
INSERT INTO ifa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mu pumbalino' nan patul hi mungngohe ta ta'on on dakol di ato' an milagro hi ad Egypt ");
INSERT INTO ifa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ya adi da'yu damdama donglon i hiya. Ta hiya nan dusao' dida an i Egypt ta nunhiglay punligatanda. Ya ahi da'yu mohpe impangulu an dakkodakkol an tatagu' an tinanud Israel ta taynanyuh naen boble. ");
INSERT INTO ifa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ta panginnilaan nadan i Egypt an ha\"on nan Dios an nundusa i dida ya impangulu da'yu an tinanud Israel ta taynanyuy bobleda. ");
INSERT INTO ifa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ta inunud da Moses i Aaron nan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ya hay tawon Moses hidin eda ni'hapitan hinan patul ya nawalu (80) ya hi Aaron e ya nawalut tulu (83). ");
INSERT INTO ifa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Alyon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wa'e ta alyon nan patul i da'yu di mahapul an ipatigoyu ha milagro ya imbagam i Aaron ta bokahonah way hinangngab nan patul nan hu\"ud ot mumbalin hi ulog. ");
INSERT INTO ifa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ot ume da Moses i Aaron hinan patul ot atonda nan imbagan Apu Dios i dida. Ta hidin bingkah Aaron nan hu''ud hi hinangngab nan patul ya nadan ap'apun munhilbin hiya ya numbalin hi ulog. ");
INSERT INTO ifa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ot pun'ipa'ayag nan patul nadan nun'ala'ing hidih ad Egypt ya nadan abalinanan mangat hi majik ot ipa'atna boh diyen dida. ");
INSERT INTO ifa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ta nun'ibkahday hu''udda ya atbohdin numbalindah ulog. Mu nun'aminul nan hu''ud Aaron didan namin. ");
INSERT INTO ifa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mu mungngohe damdama nan patul an adina dongdonglon nan ibagan da Moses i Aaron te hiyah diyey imbagan tuwalin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Alyon mo bon Apu Dios i Moses di, Ot gapu ta adi mihapitan nan patul ");
INSERT INTO ifa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ya hay atom ya em damuwon hiyah mawi\"it hi umayanah nan wangwang an nungngadan hi Nayl. Odnam nan hu''ud an numbalin ni' hi ulog ya em hinhinnod hiyah nan da'ging di wangwang. ");
INSERT INTO ifa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ta immali'e ya inalim di, Hi Apu Dios an dayawonmin Hebrew ya hinnaga' ta ibaga' i he''a ta iyabulutmun makak ami ituwen boble ta wan ume amih nan agge naboblayan ta hidiy emi pundayawan i hiya. Mu ingganah ad uwani ya nen aymu agge dingngol. ");
INSERT INTO ifa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ya innayun bon Apu Dios an alyon i Moses di, Ya ibagam ta alyom i hiyay, He''an patul ya innilaom di abalinan Apu Dios an gapuh nan atona. Ot ihoplat'u nan hu''ud hinan liting hitun wangwang ta wan mumbalin hi dala. ");
INSERT INTO ifa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ta mun'a'atedan namin nadan ekan ta umagub nan wangwang ta adi mabalin hi inumonyun i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ot alyon bon Apu Dios i Moses di, Honagom hi Aaron ta ena idongdong nan hu''ud hi an namin nan nalitingan an umat hinan wa''el ya obob ya nan tabla' ta wan mumbalin hi dalan namin nadan liting hitun ad Egypt an ta'on on nadan nahagub an wah babaleda. ");
INSERT INTO ifa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ot aton da Moses i Aaron hidiyen inalin Apu Dios. Ta inhoplat Aaron nan hu\"udna hinan wangwang an nungngadan hi Nayl hidih hinangngab nan patul ya nadan ap'apun munhilbin hiya ya numbalin hi dalan namin nan liting ");
INSERT INTO ifa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ta nun'atedan namin nadan ekan hidi ya nunhiglan ma''agub nan liting ta adi mabalin hi inumon. Ya an namin nadan liting hi ad Egypt ya numbalin hi dala. ");
INSERT INTO ifa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mu nadan i Egypt an waday abalinandan mangat hi majik ya impatnada bon pumbalinon nan liting hi dala ya na'at. Ta hiya nan namamay ngohen nan patul ta adina donglon nan ibagan da Moses i Aaron te athidiy imbagan tuwalin Apu Dios hi ma'at. ");
INSERT INTO ifa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ta namaag ya nakak ot umeh nan palasyu an ay ma\"id ha na'at. ");
INSERT INTO ifa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ta nadan tataguh ad Egypt ya way ohaon e mungka''ut hinan da'ging di wangwang ta hidiy pangalandah liting hi inumonda te adi mabalin hi ma'inum nan liting hinan wangwang. ");
INSERT INTO ifa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ta hindumingguwan di nala\"uh on athidi nan liting an numbalin hi dala. ");
INSERT INTO ifa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Alyon bon Apu Dios i Moses di, Ume'a boh nan patul ya inalim i hiya di, Imbagan Apu Dios an pakakom nadan tataguna ta way atondan e mundayaw i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Te adim'e ya ipa'alinay dakkodakkol an bakbak hitun numboblayanyu ta paligligaton da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ta nan wangwang an nungngadan hi Nayl ya mapnuh bakbak ta malpudahdi on immedah nan palasyu ya hinan alo'am ya hinadan balen nadan ap'apun munhilbin he\"a ya nadan tatagum hitun ad Egypt. Ya umeda boh nadan pungkiwalanyuh alina ya hinan punha\"anganyuh tinapay. ");
INSERT INTO ifa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ya mumpaytu\"anday udum i he\"a ya hinadan ap'apu an munhilbi i he\"a ya hinadan tatagum. ");
INSERT INTO ifa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ot alyon bon Apu Dios i Moses di, Ibagam i Aaron ta ena idongdong nan hu''ud hi an namin nadan nalitingan hitun ad Egypt an umat hinan wa''el ya nadan nun'aphung ta wan bumudduhdahdiy dakkodakkol an bakbak ta umapnal di attog hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ot aton bon hidin Aaron ya alinah on dakkodakkol di bakbak an immapnaldah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mu atbohdin inabalinan nadan mummajik an i Egypt hidiye ta nawada boy bakbak hinan boble. ");
INSERT INTO ifa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ya indani ya impa'ayag nan patul da Moses i Aaron ot alyonan diday, Ibagayu ni' i Apu Dios ta ma''idona tun bakbak ta ta'omman ya inyabulut'uy eyu pundayawan an tinanud Israel i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ya alyon Moses hinan patul di, Apu patul, ibagam hi'on anuud di pangidasala' i he\"a ya nadan ap'apu an munhilbi i he\"a ya nadan tatagum ta hidiyey atayan nan bakbak ta ammunada nan wah nan wangwang hi mabati. ");
INSERT INTO ifa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ya alyon nan patul di, Atom hi bigat. Ot alyon Moses di, Mabalin hi'on hiyay pinhodmu ta wan panginnilaam an hi Apu Dios an dayawonmi ya ma''id ha nipadpaddung i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ot adi mibahhon mama\"idda nadan bakbak hi baleyu ya hinadan balen nadan ap'apu an munhilbi i he\"a ya hi balen nadan tatagum ta ammunada tuwali nan wah nan wangwang hi mabati. ");
INSERT INTO ifa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ta tinaynan da Moses i Aaron nan patul ot e mundasal hi Moses i Apu Dios ta aanona dadiyen bakbak an impawadana. ");
INSERT INTO ifa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ya hiyay inat Apu Dios te namaaggot mun'a'atedan namin nadan bakbak ta awagillangdah nadan babale ya hinadan lita''angan ya hinadan puntanomanda. ");
INSERT INTO ifa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ot pun'amung nadan i Egypt ta nunhiglan ahi'a'agubda. ");
INSERT INTO ifa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mu nan patul ya hidin tinigonan ma''id mon nun'a'ateda nadan bakbak ya hiyah diye damdaman mungngohe ta adina donglon nan ibagan da Moses i Aaron an miyunnudan hinan imbagan tuwalin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Alyon bon Apu Dios i Moses di, Ibagam i Aaron ta idoltakna nan hu''ud hinan luta ta wan mumbalin nan hupu' hi timol hi abobbobleh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ot hiya mo boy aton da Moses i Aaron ta hidin indoltak Aaron nan hu\"ud hinan hupu' ya numbalindan namin nan hupu' hi ad Egypt hi timol ta immedah nadan tatagu ya ta'on on nadan animalda. ");
INSERT INTO ifa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ya impatnan nadan udum an i Egypt an mangat bo i diyen inat da Moses mu aggeda inabalinan. ");
INSERT INTO ifa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ot alyondah nan patul di, Hi Apu Dios di immannung an nangat i nae. Mu hiyah diyen namamay ngohen nan patul an ayna agge dingngol da Moses i Aaron. Ta niyunnudan hinan imbagan tuwalin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ot alyon bon Apu Dios i Moses di, Bumuwah'a boh mawi\"it ta em damuwon nan patul hinan umayanah nan wangwang. Ta alyom i hiyay, Imbagan Apu Dios an iyabulutmu ta makak amin tataguna ta emi dayawon hiya. ");
INSERT INTO ifa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Te adim'e iyabulut ya dusaon da'yu bo ta pa'aliyonay dakkodakkol an lalog ta mihophopdan he\"a ya nadan ap'apu an munhilbi i he\"a ya an namin nadan i Egypt. Ta mapnuh lalog di babaleyu ya hinadan lita\"angan an awadanyu. ");
INSERT INTO ifa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mu i diye ya ammunah ad Gosen an awadanmi an adi athidi ta panginnilaanyun wadah Apu Dios hi abobbobleh tun luta. ");
INSERT INTO ifa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ya ta ma''apto' nadan tatagum hinadan tatagun Apu Dios. Ot hay a'atan tuwe ya hi bigat. ");
INSERT INTO ifa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ta nabiggat ot hidiyey aton Apu Dios ta namaag ya nunhiglay lalog hidi an ta'on on hinan niha''adan nan patul ya nadan ap'apun munhilbin hiya ya an namin hi ad Egypt. Ta binahbah di lalog hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ot pa'ibagon nan patul an pa'ayag da Moses i Aaron ot alyonay, Ta'omman ya e ayu nangi'nong i Apu Dios an dayawonyu mu ta hitu ituwen bobley pangatanyu ta adi ayu umadawwi. ");
INSERT INTO ifa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mu alyon Moses i hiyay, Adi mabalin hinae te nadan idawatmi i Apu Dios an dayawonmi ya nunhiglay agge naminhodan nadan ibbam an i Egypt. Ot hitu'ey pangidawatanmi ya tigon da'mi i dida ya undan adi da'mi puntopa ta ingganah mun'a'ate ami. ");
INSERT INTO ifa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ot hiya nan hay pohdonmi ya mumbaat ami i ha tuluy algoh nan agge naboblayan ta wan hidiy emi pundayawan i Apu Dios ta atonmi nan imbagana i da'mi. ");
INSERT INTO ifa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ya alyon nan patul di, Ta'omman ya imme ayu mu ta adi ayu umeh adawwi. Ot agam mohpe ta idasalana'. ");
INSERT INTO ifa_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ya alyon Moses i hiyay, O. Ume ami tee ya ni'ihapita' i Apu Dios ta damunah bigat ya ma\"idda tun mumbahhong an lalog hinan palasyu ya hi balen nadan ap'apun munhilbin he\"a ya nadan tatagu ituwen boble. Mu ta adi da'miyot layahan te alina bo damdama ya ipagolmuy akakanmi ta e ami mangidawat i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ot taynan da Moses nan patul ot inayunan mi'ihapit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ya dingngol bon Apu Dios hidiyen imbagan Moses ta mina''idnan namin nadan lalog ta ma''id ha ta'on hi ohah nabati. ");
INSERT INTO ifa_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mu onnot on hiyah diye damdama an mungngohe nan patul ta adina iyabulut an makak nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Alyon bon Apu Dios i Moses di, Mumbangngad'ah nan patul ta alyom i hiya di imbagan Apu Dios an dayawonmin Hebrew an iyabulutmu mo ta makak ami ta emi dayawon hiya. ");
INSERT INTO ifa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Te adim'e ");
INSERT INTO ifa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ya ipa'alinay pitti ot mun'a'atedan namin nadan halunyu an umat hi kabayu ya dongki ya kemel ya baka ya gulding. ");
INSERT INTO ifa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mu hay mapitti ya ammuna nadan halunyu an i Egypt an adi milaggat nadan halun nadan tinanud Israel an ta'on on oha. ");
INSERT INTO ifa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ot ibagan Apu Dios an hay a'atan nae ya hi bigat. ");
INSERT INTO ifa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ta i diyen nabiggat ya immannung an napittidan namin nadan halun nadan i Egypt. Mu ma''id ha nateh nadan halun nadan tinanud Israel an ta'on on oha. ");
INSERT INTO ifa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ta hinnag nan patul di e nanigo ya immannung peman an ma''id ha napittih nadan halun dadiyen tinanud Israel. Mu hiyah diye damdaman mungngohe nan patul ta adina pakakon dida. ");
INSERT INTO ifa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ot alyon bon Apu Dios i da Moses ya hi Aaron di, Ekayu umakup hinan dapul hinan pundapulan ta ipatu\"ug Moses an mangihabuwag hi hinangngab nan patul. ");
INSERT INTO ifa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ta iyaddib di dibdib hi abobbobleh ad Egypt ta mumbalin hi poghah nadan tatagu ya ta'on on hinadan halunda. ");
INSERT INTO ifa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ot eda mo bo umakup hi dapul ot ipatu''ug Moses an nangihabuwag hi hinangngab nan patul. Ya numbalin hi poghah nadan tatagu ya ta'on on hinadan halunda. ");
INSERT INTO ifa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ta nadan tatagun abalinanan mangat hi majik ya ma''id ha atondan umeh awadan Moses te ta'on on dida ya nun'apoghaanda. ");
INSERT INTO ifa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mu hiyah diye damdama an adi pakakon nan patul dida te minaman Apu Dios di ngohena ta namaag ya ayna agge dingngol nan imbagan da Moses i Aaron. Ya hiya tuwaliy imbagan Apu Dios hi aton nan patul. ");
INSERT INTO ifa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Alyon bon Apu Dios i Moses di, Bumuwa'ah bigat ta em damuwon nan patul ta alyom i hiya di, Hi Apu Dios an dayawonmin Hebrew ya alyonay iyabulut da'min tataguna ta wan e ami mundayaw i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Te ad uwani ya nunhiglay atonan mundusa i he\"a ya nadan ap'apun munhilbin he\"a ya nadan tatagum ta panginnilaam an hi Apu Dios ya ma''id ha nipaddungana. ");
INSERT INTO ifa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Te unhaot dinusa da'yu i ha nunhiglan dogoh ta nate ayun naminamin. ");
INSERT INTO ifa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mu manu'eh aggena inat hidi ya ta way atom an manginnilah nan abalinana ya ta mipatigo nan ongal an abalinana ta mipa'innilay a'atnah abobboble. ");
INSERT INTO ifa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Mu ta'on on athidi ya mungngohe'a damdama ta ipagolmuy akakanmin tataguna. ");
INSERT INTO ifa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ta hiya nan hi bigat hinan athitu ya ipa'alina han nunhiglay a'atna an dalallu an ma''id ha nipadpaddunganah nadan dalalluh tun ad Egypt hi nihipun hidin hopapna ta ingganah ad uwani. ");
INSERT INTO ifa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ot udu'dulnay eyu pun'ihidum nadan halunyu ya an namin nadan wah nan puntanoman te umannung an mun'a'atedan namin nadan wah nan puntanoman an tagu onu halun. ");
INSERT INTO ifa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ya hanadan udum an ap'apu an munhilbih nan patul an nangngol hinan hapit Apu Dios ya timmakutda ot eda pun'ihidum nadan halunda ya ta'on on nadan himbutda. ");
INSERT INTO ifa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mu nadan udum ya nunnanong an aggeda e inhidum nadan halunda ya nadan himbutda hinan puntanoman te ngohayonda nan hapit Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ot alyon Apu Dios i Moses di, Itaggem di ta'lem hi nangappit hi ad lagud ta mun'a'agah di dalallu hi abobbobleh ad Egypt ta miknah nadan tatagu ya nadan animalda ya an namin an intanomda. ");
INSERT INTO ifa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ot itaggen mon Moses nan hu''udna ot idongdongnah ad lagud ya impa'alin Apu Dios han nunhiglan dalallu. Ta mungkikidul ya mungkikilat on mun'udan hi dalalluh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ta athidin mun'a'agah di dalallu ya atbohdin mungkikilat ta nunhiglan atatakut hidiyen mama'at an ma''id ha nihippatanah nadan inamtan nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ya an namin nadan agge immeh nan nahiduman an umat hi halun ya ta'on on nadan tatagu ya nun'i'iknan dida nan dalallu. Ta nun'apa\"ih nadan nun'itanom ya ta'on on nadan kakayiw on nun'aphakda. ");
INSERT INTO ifa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mu hi ad Gosen an niha''adan nadan tinanud Israel ya ma''id ha dalalluhdi. ");
INSERT INTO ifa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ta impa'ayag nan patul da Moses i Aaron ot alyonay, Immannung an numbahula'. Hi Apu Dios di nipto' mu da'min tataguy nibahho. ");
INSERT INTO ifa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ta hiya nan ibagayu bahan i Apu Dios ta padinongonah tuwen kidul ya tun mun'a'agah an dalallu. Ot iyabulut'u moy akakanyu ituwen boble ta adi mahapul an hituy pi'iboblayanyu. ");
INSERT INTO ifa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ot alyon Moses di, Ot athina'e ya ta'omman ya hiyay indasal'u i Apu Dios hi umanamuta'. Ot duminong aya tuwen kidul ya mama\"idda mo nadan mun'a'agah an dalallu ta wan panginnilaam an tun luta ya bagin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mu innila' an he''a ya nadan ap'apun munhilbin he\"a ya adiyu damdama taktan hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ta nun'apapa\"ih nadan tuwen matong an barley ya nan kapoh an manabungda. ");
INSERT INTO ifa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mu nadan wit ya uwanida ta dadiye han nabati. ");
INSERT INTO ifa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ya immaan hi Moses hi awadan nan patul ya intaggenay ta'lenah nangappit hi ad lagud ot mumbagah boddang i Apu Dios. Ya na'ibagan dimminong nan kidul ya nan mun'a'agah an dalallu ya nan udan. ");
INSERT INTO ifa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ya hidin tinigon nan patul ya nadan ibbana an dimminong nan udan ya nan dalallu ya nan kidul ya numbahulda bo te ngimmohedan umat hidin hopapna. ");
INSERT INTO ifa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ta hiyah diyen mungngohe nan patul an adina iyabulut an makakda nadan tinanud Israel ta niyunnudan hinan imbagan tuwalin Apu Dios an imbagana i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ya alyon bon Apu Dios i Moses di, Ume'a ta em bo tigon nan patul an ta'on on numbalino' hi mungngohedan namin hinadan ap'apun munhilbin hiya. Ta way ato' an mangat i datuwen dakol an milagro. ");
INSERT INTO ifa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ta mabalin an ibagayuh nadan imbabaleyu ya apapuyu datuwen inat'un nundusah tudan i Egypt ta wan an namin ayu ya innilaonyun ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ta immeda bo da Moses i Aaron hi awadan nan patul. Ot alyondan hiyay, Hi Apu Dios an dayawonmin Hebrew ya alyonay undan hi anuud anu ya ahi'a mumpada\"ul i hiya ta iyabulutmun makak amin tataguna ta e ami mundayaw i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Te nanongna'en mungngohe'a ya ipa'alinah bigat di adakdaklan an dudun hitun numboblayanyu. ");
INSERT INTO ifa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ta mihophopdah nan luta ta adi matigo ya inupputdan inan nadan intanomyun agge dinadag nan dalallu ya ta'on on nadan kayiw. ");
INSERT INTO ifa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ya atbohdin mapnudah balem ya hay balen nadan ap'apun munhilbin he\"a ya an namin nadan balen tun tatagum. Ot hituwen ma'at ya ma\"id ha na'atanah din a'ammodyu an nihipun hi hopapna. Ot taynan da Moses nan patul. ");
INSERT INTO ifa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ya alyon nadan ap'apun munhilbih nan patul di, Apu patul ngalngalam boy e pamalpaligatan naen tagun dita'u. Udulnay iyabulutmu ta makakda ta wan eda mundayaw hinan Dios an dayawonda. Te undan adim tigon an nadadag tun boble ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ot ipa'ayag mo bon nan patul da Moses i Aaron ot alyonan diday, Ta'omman ya imme ayu ta eyu dayawon nan Dios an dayawonyu. Mu nganneday mi'ye i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ya alyon Moses di, Ume amin namin an ta'on on goggolang ya a'amamma ya i'ininna ya an namin nadan animalmi an umat hi kalnero ya gulding te mahapul an e ami mun'am'amlong an mundayaw i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ya alyon nan patul di, Adi' ahan abuluton di panguyuganyuh nadan binabai ya nadan u\"unga te ma'innilan adi maphod nan ninomnomyun aton. ");
INSERT INTO ifa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hay mabalin hi uyugonyu ya ammuna nadan linala'i ta wan eyundi dayawon hi Apu Dios te hiyay ibagabagayu. Ot pundolahdaot da Moses i Aaron hidih nan awadan di patul. ");
INSERT INTO ifa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ya alyon Apu Dios i Moses boy, Idongdongmuy ta'lem hi ad Egypt ta umapnal di dudun hi bobleda ta pun'a'anda nadan agge dinadag di dalallu. ");
INSERT INTO ifa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ot itaggen bon Moses nan hu''udna ya impatuyup Apu Dios nan dibdib an malpuh tuluwan di algo ta inyal'algona ot ilablabinay dibdib. Ta damunah nan nawi\"it ya impa'alinay dudun. ");
INSERT INTO ifa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ya nunnaud an dakkodakkolda ta nihinapdah abobbobleh ad Egypt. Ya hidiye ya ammunay nanigan nadan i Egypt hi dakkodakkol an dudun. ");
INSERT INTO ifa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ta hidin nungkohopdah nan luta ya namaag ya mangmangitit di matigo. Ta inupputdan inan nan agge dinadag di dalallu an ta'on on nadan bungan di kayiw. Ta ma''id mo ha matigoh munlangta. ");
INSERT INTO ifa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ta hidin tinigon nan patul hidiye ya pun'ipa'ayagna da Moses i Aaron. Ot alyonan diday, Numbahula' i Apu Dios an dayawonyu ya ta'on on da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ot hanat pakawanona' hinan numbahula' ya indasalyu i Apu Dios an dayawonyu ta aanonah tuwen pamalpaligatna i da'mi an lummuh atayanmi. ");
INSERT INTO ifa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ot taynan mo bon da Moses nan patul ot mundasal i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ya impa'alin Apu Dios han ma'abbikah an dibdib an nalpuh nangappit hi alimuhan di algo ot itayyapna nadan dudun ot iyena didah nan baybay an mumbolah ta ma''id ha nabatih ta'on on oha an dudun hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mu hiyah diyen numbalinon Apu Dios hi mungngohe nan patul ta adina iyabulut an makakda nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ot alyon Apu Dios i Moses di, Itaggem di ta'lem hi nangappit hi ad lagud ta humihillong hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ta hiya mo boy inat Moses. Ya himmihillong an namin di abobbobleh ad Egypt hi tuluy algo. ");
INSERT INTO ifa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ta nadan i Egypt ya namaaggot umohnongdah baleda te ma''id ahan ha matigo. Mu hidih awadan nadan tinanud Israel ya hiyah diye tuwalin mapatal. ");
INSERT INTO ifa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ot ipa'ayag bon nan patul hi Moses ot alyonay, Mabalin an ume ayu mundayaw i Apu Dios an ta'on onyu awiton nadan imbabaleyu ya nadan binabai. Mu gahin di angangonyun namin nadan halunyun baka ya kalnero ya gulding. ");
INSERT INTO ifa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ya alyon Moses i hiyay, Mahapul an iyabulutmu an waday i'nongmi hi maghob an mi'nong i Apu Dios hinan pundayawanmi. ");
INSERT INTO ifa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ta hiya nan mahapul an pi'yalamin namin nadan halunmi ta waday pumpiliyanmih nan i'nongmi i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mu hiyah diyen numbalinon Apu Dios nimpe hi mungngohe nan patul ta adina iyabulut an makakda. ");
INSERT INTO ifa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ya onaot pun'ituda' hi Moses an alyonay, Umaan'ah tun awada' Moses. Ya tigom ta adim ipidpidwan mumpatigon ha\"on. Te atom'e ya mate'a. ");
INSERT INTO ifa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ot alyon Moses i hiyay, Ta'omman ya aggeya' mo numpatpatigo i he\"ah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Alyon Apu Dios i Moses di, Oha mo han nabati an pundusa' hinan patul ya nadan tataguna. Ot malpah'e mon ma'at hinae ya iyabulutna mon makak ayu mu hay atona ya pundunidun da'yu ta wan ma'ibaga ayun umaan ituwen boble. ");
INSERT INTO ifa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ot hiya nan ibagam hinadan ibbam an tinanud Israel an linala'i ya binabai ta way ohaon e mumbagah nadan hinaggondan i Egypt hi usal an balitu' onu silber. ");
INSERT INTO ifa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ot ha\"on an Dios ya indat'uy ongal an punlispitun nadan i Egypt i da'yun tinanud Israel an namama i he\"a Moses te nabaktuy pangibilang nadan tatagu ya nadan ap'apun munhilbih nan patul i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ot ume boh Moses hinan patul ot alyonan hiyay, Imbagan Apu Dios an hay tongan di labi ya umeh abobbobleh tun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ta an namin nadan panguluwan an linala'in imbabaleyun i Egypt ya mun'a'ateda an ta'on on nan imbabalem ya nan imbabalen nan na'adda\"ul an baalmu. Ya ta'on on nan hopap di imbabalen di animalyu ya mun'a'ateda. ");
INSERT INTO ifa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ta nunhiglan ahikokogadan namin di tataguh tun ad Egypt. Te hinaen ma'at i da'yuh ad uwani ya nunnaud an ma\"id ha nipaddungana. ");
INSERT INTO ifa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mu hinan awadanmin tinanud Israel ya malinggop an ta'on on ha mun'aluul hi kahu ya ma\"id ha madngol. Ta hiyay panginnilaanyun hi Apu Dios ya nat'on di pangibilangnah nadan tinanud Israel hinadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ta na'at'eh diye ya umalida mohpen namin nadan ap'apun munhilbin he\"a ta munyu\"ungdah hinangngab'u ta mumpahpahmo'dan alyonday, Uyugom bahan nadan ibbam ta ume ayun naminamin. Ot umannung an ume ami. Ta on imbagan Moses hidiye ot inayunan umaan hidi an nunhiglay bungotna. ");
INSERT INTO ifa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ya imbagan tuwalin Apu Dios an alyonay, Nan patul ya adina donglon nan ibagayun hiya. Mu ta'on ta way ato' an mangat hitun ad Egypt hi dakol an milagro. ");
INSERT INTO ifa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ta da Moses i Aaron ya inatdan namin dadiyen milagro ta tinannigon nan patul. Mu numbalinon Apu Dios hi mungngohe nan patul ta hiyah diyen adina iyabulut an umaanda nadan tinanud Israel hi bobleda. ");
INSERT INTO ifa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Hidin aggeda ni' nakak da Moses i da Aaron hi ad Egypt ya alyon Apu Dios i diday, ");
INSERT INTO ifa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Mihipun hi ad uwani ya hituwe mon bulan di ibilangyuh ma''unan bulan hinan hintawon i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ot ibagayuh nadan ibbayun tinanud Israel ta hitun mala''uh di himpuluy (10) algoh ad uwanin bulan ya way ohah nadan linala'i ya piliyona ha ohah nan imbabalen di kalnero onu ha gulding ta i'nongdan hina'amma. ");
INSERT INTO ifa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ya ibagam i dida ta wa'et oh'ohhada an pamilya ta adida abalinan an anon nan ohan kalnero ya inayaganday oha bon pamilya ta mungngangammutdan mangan i diyen ohan kalnero. Ta ihdadan namin an ma''id ha mabati. ");
INSERT INTO ifa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ya hay piliyonda ya nan ohay tawonan tangbal an kalnero onu gulding an ma''id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ta ipapto'da datuwen animal ta ingganah nan mi'ahimpulut opat (14) di algo ituwen bulan ya ahida nundidihhanon an paltiyon hinan mun'ahdom. ");
INSERT INTO ifa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ya inalada nan dalana ya nun'ilamuhdah nan way panton di baleda an matigoh dola. Ta an namin nan panton di balen punhidanda ya waday milamuh hi dala. ");
INSERT INTO ifa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ya hay atonda i diyen mahdom ya igapada nan pinaltida ya inanda an iddumdah nan nating an mumpait ya nan tinapay an agge nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ya adiyu anon nan ma\"atan dotag onu nan niha\"ang. Mu igapayu an ta'on on nan ulu ya huki ya an namin nan minalutuna. ");
INSERT INTO ifa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ta nalutu'e ya inihdadan namin i diyen nahdom. Mu alina'e hi waday aggeda ya ginhobdah nan mawi\"it. ");
INSERT INTO ifa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ya ibagam i dida an hay atondan mangan ya nundadaanda mo tuwali an mumbaat an iniphoddan nunlubung ya nunhapatutda ya inodnanday hu''udda ya ginalaandan nangan. Te ha''on an hi Apu Dios ya hidiyey pangihwanga' i da'yu hi ate. ");
INSERT INTO ifa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Te i diyen nahdom ya hiyay umaliya' hinah ad Egypt. Ta an namin nadan panguluwan an imbabalen nadan i Egypt ya ta'on on nadan hopap di imbabalen di halunda ya mun'a'ateda. Ta i diye ya mipatigo an ma\"id ha abalinan nadan dios an dayawonda an mangihwang i didan i Egypt te ha''on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ot nan dalan ilamuhyuh nan way pantoyu ya hiyay pangimatuna' hinadan baleyu. Ta tigo''eh diyen dala ya lina\"uha' ta ma''id ha patayo' i da'yu an adi umat hinan pundusa' hinadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ya atawotawon ya nadatngan'eh diyen algo on hiyay inatyu an tungawonyu ta panginomnomnomanyu ya punhanaanyu ituwen pangihwanga' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ya adi ayu mangan hi tinapay an nadduman hi yist hi pituy algo. Ot maphod on hinan hopap di algo ya impadihyun inaan an namin nadan yist hinadan baleyu te wada'en da'yu ha mangan hinan nadduman hi yist ya mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ta hinan mamangulun algo ya hinan mi'apituh algo ya ma'amung ayu ta mundayaw ayun ha''on. Ya adi ayu muntamu i dadiyen algo. Mu mabalin an munha''ang ayuh anonyu. ");
INSERT INTO ifa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ngilinonyu nan pangananyuh tinapay an agge nadduman hi yist te i diyen algo di pangikaka' i da'yuhnah ad Egypt. Ta atawotawon on nginilinyu danaen algo ta punhanaanyun ha''on hi inggana. ");
INSERT INTO ifa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ta mihipun hinan mun'ahdom hinan mi'apulut opat (14) di algoy mibalu hinan mamangulun bulan ya ihipunyuh din mangan hinan agge nadduman hi yist an tinapay ta ingganah nan mun'ahdom hinan mi'abaintit ohay (21) algo. ");
INSERT INTO ifa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ya i diyen pituy algo ya tigonyu ta ma''id ha yist hinan numpunhituwanyu. Te hanan mangan hi nadduman hi yist an tinapay ya mipapate nimpe ta adi mo midmiddum i da'yun tinanud Israel an ta'on on ibbayu onu ohah nadan ni'iboblen da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ot adi ayu nimpe mangan hinadan nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ot ipa'ayag mon Moses nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ot alyonan diday, Way ohan da'yu ya piliyona ha hinohhah imbabalen di kalnero onu gulding ya pinaltiyu ta ihdayun hina'ammah tun pangihwangan Apu Dios i dita'u. ");
INSERT INTO ifa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ya tinayayuy dalana i ha malukung ta mabalin an itamolyuhdi nan nabto' an tubun nan ma'alih haysop on inlamuhyuh nan baktun di pantoyu ya hinan nundinommang hinan panton di baleyu. Ya tigonyu ta ma''id i da'yu ha lumah'un i diyen mahdom ta ingganah mawi\"it. ");
INSERT INTO ifa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Te hidiyey luma''uhan Apu Dios ituwen boble hi ena pamatayan hinadan panguluwan an linala'i an i Egypt. Mu tigona'en waday dalah nilamuh hinan way panton di baleyu ya la\"uhanah diyen bale ta adina iyabulut an waday patayonah nadan nunhituhdi. ");
INSERT INTO ifa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ot hinaey atonyuh ad uwani ya hi atawotawon ta inggana. Ya itugunyu boh nadan imbabaleyu ta adida ibahhon aton on nadatngan nan algon a'atana. ");
INSERT INTO ifa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ya ta'on on hitun dumatnganyuh nan boblen idat Apu Dios hi punhituwanyu ya inaynayunyun ngilinon hituwen algo ta inggana. ");
INSERT INTO ifa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ta mahmahan'en nadan imbabaleyuy niyatan tuwen ngilinonyu ");
INSERT INTO ifa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ya alyonyuy, Hituwey punnomnomnoman ta'uh nihwangan ta'un tinanud Israel hi ateh ad Egypt hinadan numpunhituwan ta'uhdi hidin numpatena nadan i Egypt. Hidin nalpah an imbagan Moses hidiye ot inayun nadan tinanud Israel an iyungyung ot dayawondah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ot aton nadan tinanud Israel nan imbagan Apu Dios i da Moses i Aaron. ");
INSERT INTO ifa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Hidi tatawwa an tongan di labi ya inhipun Apu Dios an numpate nadan panguluwan an linala'in i Egypt an mihipun hinan panguluwan an imbabalen nan patul an mihukkat'ot i amana an mumpatul ta ingganah nan panguluwan an imbabalen di balud. Ya ta'on boh on nan hopap di imbabalen di halunda on nun'a'atedan namin. ");
INSERT INTO ifa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ta bimmangon nan patul ya nadan ap'apu an munhilbin hiya ya an namin nadan i Egypt ot ahikokogada. Te nipong hi abalebaley nateh nadan linala'i i dida. ");
INSERT INTO ifa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ot e pun'ipa'ayag nan patul da Moses i Aaron i diyen labi. Ot alyonan diday, Alyonyuh nan ibbayun tinanud Israel ta an namin ayu ya umaan ayu ituwen boblemi ta eyu aton nan analyonyun eyu pundayawan i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ya nun'alayun namin nadan halunyun baka ya gulding ya kalnero ya imme ayu mu ta wagahana' bahan. ");
INSERT INTO ifa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ot pun'ituda' nadan i Egypt nadan tinanud Israel ta ma'ibagadan makak ta taynanday bobleda te alyonday, Lo'tat mahan tayya ya nate amin namin. ");
INSERT INTO ifa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ta nadan tinanud Israel ya pumpahonda nadan napalut an alinan iphoddah tinapay an dadiye nadan agge naha''adan hi yist an ningammut hinadan niha''adanda an nalibbutan hi luput. ");
INSERT INTO ifa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ot atonda bo nan imbagan Moses an way ohaon e numbagah nadan hinaggondan i Egypt hi usal an balitu' ya silber ya lubung. ");
INSERT INTO ifa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Te hidin eda numbaga nadan tinanud Israel ya numbalinon Apu Dios hi ongal di pamiyal nadan i Egypt hinadan tinanud Israel ta nun'idatda nadan imbagan nadan tinanud Israel. Ta nun'aladay kinadangyan nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ta dinallan nadan tinanud Israel an mihipun hi ad Rameses ta ingganah ad Sukkot. Ya hay bilangdan namin an nakak hi ad Egypt ya umeh onom di gahut di libu (600,000) mu aggeda ni'bilang nadan u\"unga ya binabai. ");
INSERT INTO ifa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ya dakolday tatagun ni'ye i dida an bokon tinanud Israel ya niddumda bo nadan dakkodakkol an animalda an umat hi kalnero ya gulding ya baka. ");
INSERT INTO ifa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ot iyammadah tinapay nadan pinalutdan alina an agge nadduman hi yist an namaaggot ikakdah ad Egypt te ma\"id ha inatdan nangidadaan hi anonda te nundunidunda didah nakakandah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ta hay bilang di tawon hi nihaha''adan nadan tinanud Israel hi ad Egypt ya opat di gahut ta han tulumpulu (430). ");
INSERT INTO ifa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ta hidin mi'a'opat di gahut ta tulumpuluy (430) tawon i diyen algo ya nakakda mahan moh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ot gapu ta paddungnay timmukal hi Apu Dios hi nangihwangana i didah ate ta nakakdah ad Egypt ya hiyah diye nan atawotawon on mahapul an ngilinondah diyen hilong ta ipabaktudah Apu Dios hi inggana. ");
INSERT INTO ifa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ya indani ya alyon Apu Dios i da Moses i Aaron di, Datuwe nadan mahapul an atonyu hi punnomnomnomanyuh nan nangihwanga' i da'yuh ate hi ad Egypt. Tigonyu ta ma\"id ha mi\"an i da'yu hi bokon tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mu nada'en ginattangyun himbutyu ya mabalin an mi\"anda i da'yu hi'on nakugitda. ");
INSERT INTO ifa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Mu nada'en immalin nalpuh udum hi boble an puntamuwonyu ya adi mabalin hi mi\"anda. ");
INSERT INTO ifa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ya mahapul an hinan baley pangananyu ya tigonyu ta ma\"id ha milah'un hinan lamoh nan pinaltiyu. Ya tigonyu bo ta ma''id ha maputung hinadan tungalna. ");
INSERT INTO ifa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ya mahapul an an namin ayun tinanud Israel ya atonyuh tuwen imbaga'. ");
INSERT INTO ifa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ya adi mabalin nimpe an mi\"an nadan ni'boble i da'yu mu onha pinhoddan middum ya mahapul an mumpakugitda ni' nadan linala'i ya ahi mabalin an middum i da'yuh nan punnomnomnomanyuh nihwanganyuh ate hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ta datuwey mahapul nimpe an atonyun tinanud Israel ya ta'on on nadan ni'hitu i da'yun nalpuh udum hi boble ya mahapul an atonda. ");
INSERT INTO ifa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ya inunud nadan tinanud Israel nan imbagan Apu Dios i da Moses i Aaron. ");
INSERT INTO ifa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ta hidiyen algoy nangikakan Apu Dios hinadan tinanud Israel ta tinaynandah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Idawatyun ha\"on an namin nadan panguluwan an linala'in imbabaleyun tinanud Israel ta midawatda i ha\"on. Ya athidi boh nadan hopap di tangbal an imbabalen di animalyu. ");
INSERT INTO ifa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ot alyon Moses hinadan tatagu di, Tigonyu ta ngilinon ta'uh tuwen namangulun algo ituwen namangulun bulan te hituwey nanaynan ta'uh ad Egypt an nihbutan ta'u. Te impakak dita'u i Apu Dios an gapuh nan ongal an abalinana. Ta hiya nan adi ta'u ni' mangan hi tinapay an nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ya adi ta'u nimpe linglingon hituwen algo ituwen bulan an ma'alih Ahib te nakak ta'u mo ayah tun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ya hitun pangidatongan Apu Dios i dita'u hi boblen nadan tinanud Kanaan an dida nadan tinanud Hit ya tinanud Amor ya tinanud Hib ya tinanud Jebus an hidiye nan boble an imbagan Apu Dios hinadan a'ammod ta'u an idatna i dita'u an makadangyan ya malumong an boble ya adi ta'u linglingon ta ngilinon ta'uh tuwe hi'on nadatngan nan mamangulun bulan. ");
INSERT INTO ifa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ta hinan pituy algo ya adi ta'u mangan hi tinapay an agge nadduman hi yist. Ya hinan mi'apitun algo ya na'amung ta'u ta dayawon ta'uh Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ya tigon ta'u nimpe ta adi ta'u anon nan tinapay an nadduman hi yist i diyen pituy algo ya ma\"id ha matigoh yist onu nadduman hi yist an makan hinan numpunhituwan ta'u ya an namin i diyen pumboblayan ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ya ipa'innila ta'uh nadan imbabale ta'u an manu'e hi ngilinon ta'uh diye ya ta punnomnomnoman ta'uh nan inat Apu Dios i dita'u ta immaan ta'uh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ot hituwen pungngilinan ta'u ya hiyay ay malkah ta'le ta'u onu hay ulu ta'u. Ta ipanomnomnan mahapul an nan tugun Apu Dios di nanongnah nomnomnomon ta'u ya haphapiton ta'u. Te gapuh nan ongal an abalinan Apu Dios ya impa'aan dita'uh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ot hiya nimpe nan atawotawon ya ngilinon ta'uh tuwen na'at hi'on nadatngan hituwen algo. ");
INSERT INTO ifa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ya alyon bon Moses di, Wa'e ta indat mon Apu Dios i dita'u nadan numboblayan nadan tinanud Kanaan te hidiyey imbaganah nadan a'ammod ta'u ");
INSERT INTO ifa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ya idawatyu i Apu Dios nadan panguluwan an linala'in imbabaleyu. Ya indawat ta'u bon namin nadan hopap di tangbal an imbabalen di animal ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mu mabalin an hukkatan ta'uh tangbal an imbabalen di kalnero nan hopap di tangbal an imbabalen di dongki ta'u ta hiyay i'nong ta'u i Apu Dios. Mu adiyu'e pohdon an hukkatan ya mahapul an putungonyuy bagangna ta mate. Mu na'en panguluwan an lala'in imbabaleyu ya mahapul an waday idawat ta'u i Apu Dios an kalnero ta hidiyey midawat ta bokon nan imbabale ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ya udum'eh algo ta mahmahan nadan imbabale ta'uy ibalinan tuwen at'aton ta'u ya alyon ta'un diday, Hituwey punnomnomnoman ta'uh nangikakan Apu Dios i da'mih ad Egypt ta pinogpogna nan ahimbutmihdi an gapuh nan ongal an abalinana. ");
INSERT INTO ifa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Te hidin ipagol nan patul hi ad Egypt di akakanmihdi ya pinaten Apu Dios an namin nadan panguluwan an linala'in imbabalen nadan i Egypt ya an namin nadan hopap di imbabalen di animalda. Ta hiya nan idawat ta'un Apu Dios an namin nadan panguluwan an linala'i ya an namin nan hopap di tangbal an imbabalen di animal ta'u. Mu hay panandih nadan linala'in panguluwan ya nan animal. ");
INSERT INTO ifa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ot hituwen aton ta'uh atawotawon ya umat hinan ihu'lub ta'uh ta'le ta'u onu nan ipongot ta'uh ulu ta'u an waday iyatana. Te ipanomnomna nimpe nan inat Apu Dios an nangikak i da'mih ad Egypt an gapuh nan ongal an abalinana. ");
INSERT INTO ifa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Hidin impakak nan patul nadan tinanud Israel hi ad Egypt ya agge impangulun Apu Dios dida hinan awon an miloh'at hinadan boblen di i Pilistia te alyon Apu Dios di, Alina ya naluman di punnomnomda hi'on waday mangubat i didah nan awonda ya imbangngaddah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ta hiya nan ta'on on waday almasdan mi'gubat ya impangulun Apu Dios didah nan na'alli'koh an awon hinan agge naboblayan ot ahi midongdong hinan baybay an mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ya da Moses ya inodnanda din ba'ag Joseph te hiyah diyey imbagan Joseph i dida an tinanud Israel. Te inalinay, Hitun pangipa'aanan Apu Dios i da'yuh tun ad Egypt ya mahapul an pi'yalayu nan tungal'u. ");
INSERT INTO ifa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Indani ya nakakdah ad Sukkot ot umedah ad Etam an da'ging nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ya hay inat Apu Dios an nangipangulun dida ya wa'e ta mapatal on wada han bugut an ay ha ongal hi tu\"ud ta hiyay mangipangpangulun dida ta nan pangipluyana di un'unudonda. Ya nahdom'e on ay mundalang hidiyen bugut an ay ongal an tu\"ud ta waday paniganda ta mabalin an ta'on on nahdom on mangeda. ");
INSERT INTO ifa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ta athidin hay nangipangpangulun dida ya mapatal'e on hidiyen bugut mu nahdom'e ya nan ay mundalang an apuy an ay tu\"ud hi hinangngab nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Indani ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Ibagam hinadan ibbam an tinanud Israel ta ibangngadyuh nan nihaggon hi ad Pi-Hahirot an numbattanan di ad Migdol ya nan baybay an mumbolah ya nun'allung ayuhdih nan nidommangan di ad Baal-Sepon. ");
INSERT INTO ifa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ta alyon nan patul on aggeyu innilay umayanyu an on ayu lumani'li\"odan hinan bobleda ta hay innilana ya nali\"ub ayuhdih nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ya hiyah diyen pumbalino' hi mungngohe nan patul ta umalin tundon da'yu. Mu gapuh nan ma'at i hiya ya nadan tindaluna ya mipabaktuwa' ta innilaon nadan i Egypt an ha\"on hi Apu Dios. Ta inunud nadan tinanud Israel hidiyen imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Hidin nipa'innilah nan patul an binumtikda nadan tinanud Israel ya ma'atuttuyuh nangipakakanan dida. Ya ta'on on nadan ap'apun nunhilbin hiya ya atbohdin nahukkatan di nomnomda. Ta alyonday, Tanganu tuwali on ta'u impakak dadiyen tinanud Israel ta ma\"id mo ha puntamuwon ta'u? ");
INSERT INTO ifa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ya e impidadaan nan patul nan iluganana hi'on e mi'gubat ot pun'ayagana nadan tindaluna. ");
INSERT INTO ifa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ta inikaknan namin nadan wadan punluganan an ta'on on nadan onom di gahut (600) an mun'aphod ot mipongda nadan a'ap'apu an milugan i dadiye ot ipanguluna. ");
INSERT INTO ifa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Te hi Apu Dios ya numbalinona nan patul hi mungngohe ta tinnudda nadan tinanud Israel an ma\"id ha takutdan mange. ");
INSERT INTO ifa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ya dadiyen in'uyug nan patul an numpungkabayu ya numpunlugan hi lugan di e mi'gubat ya tuwen mun'iyakhupdan didahdih nan nun'allungandah nan da'ging nan baybay an nihaggon hi ad Pi-Hahirot an dommang di ad Baal-Sepon. ");
INSERT INTO ifa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ya hidin minangmang nadan tinanud Israel dadiyen tindalun impangulun nan patul ya nangintatakutda ta mumpahpahmo'dan mumpaboddang i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ta alyondan Moses di, Nganne mahan hituwen inatmun da'mi? Undan ma''id ha lubu'an hi ad Egypt ta inyali da'mihtu ta wan hituy atayanmi? ");
INSERT INTO ifa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ya undan aggemi tuwali pinangulun inaliy, Udu'dulna attog di taynan da'min he''a ta uk'ukkod ami. Te udu'dulnah on ami himbut hitun ad Egypt mu hanan e ami mateh nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mu alyon Moses i diday, Adi ayu tumakut ya inhamadyun inyukod i Apu Dios ta tigonyuy atonan mangihwang i dita'uh ad uwanin algo. Ta danaen i Egypt an tigonyuh ad uwani ya adiyu mo pidwon an tigon dida. ");
INSERT INTO ifa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Te hi Apu Dios di ukod an mangubat i dida. Ot hay maphod ya namaag ya dimminong ayu. ");
INSERT INTO ifa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ya alyon bon Apu Dios i Moses di, Tanganu on'a mumpahpahmo' an mumpaboddang i ha\"on? Ibagam hinadan ibbam ta inaynayundan mange. ");
INSERT INTO ifa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ya indongdongmu nan hu''udmuh nangappit hinan baybay ta munhi''an nan liting ta pangi'wanyu. ");
INSERT INTO ifa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mu nada'e an i Egypt ya pumbalino' dida hi mungngohe ta wan ilaputdan mitnud i da'yuh nan gawwan di baybay. Ta mipatigoy anabaktu' hi pangabaka' hinan patul ya an namin nadan tindalunan nungkakabayu ya numpunlugan hi lugan di e mi'gubat. ");
INSERT INTO ifa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ta panginnilaan nadan i Egypt an ha''on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ya nan anghel Apu Dios an nangipangulu ya imme ot e umohnong hi indoggan nadan tinanud Israel. Ya atbohdi nan bugut an ay tu\"ud an imme boh indogganda. ");
INSERT INTO ifa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ta e nibattan hinadan tinanud Israel ya nadan i Egypt. Ta nanginhihilong nan way nipto' hinan i Egypt mu nan nangappit hinan tinanud Israel ya mapatal. Ta nadan i Egypt ya ma''id ha atondan mitnud i dida i diyen hin'ugab. ");
INSERT INTO ifa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ya hidin indongdong Moses di ta'lenah nan way baybay ya impatuyup Apu Dios han mabikah an tuyup an nalpuh nangappit hi tuluwan di algo ta inlablabinan numbudakan nan liting i diyen nahdom. Ya lo'tat ya nunhi''an nan liting hinan baybay ");
INSERT INTO ifa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ot i'wan nadan tinanud Israel hinan mamagan dopon di baybay. Te nunhi''an nan liting ot ay migaob hi nundinommang. ");
INSERT INTO ifa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ya hidin nungginawwadah nan baybay ya nitnudda nadan tindalun i Egypt an numpunnanong an numpunlugan di udum hinadan lugan di e mi'gubat ya numpungkabayuday udum. ");
INSERT INTO ifa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ya hidin tuwen mun'awiwi\"it ya inyuhdung Apu Dios i dida hinan way bugut an ay apuy ot ulawona nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ta pamaag nadan pilid nadan nilugananda ya naligat an madlig. Ot alyonda moy, Mumbangngad ta'uot ta taynan ta'u nadan tinanud Israel te umman hi Apu Dios di mangubat i dita'u. ");
INSERT INTO ifa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ya alyon bon Apu Dios i Moses di, Idongdongmu nan ta'lem hinan way baybay ta mundammu nan liting ta malnong nadan i Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ot hidiyey aton Moses ta hidin mun'awi\"it ya numbangngad nan liting hinan a'atna tuwali. Ta ta'on on impatnan nadan i Egypt an bumtik ya adi mabalin te hi Apu Dios di nangipalnong i didahdi ta nun'a'alnongda. ");
INSERT INTO ifa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ta on nundammu nan liting ta nalnong nadan luganda ya kabayuda ot mun'altingdan namin dadiyen i Egypt an titindalu an nipdug hinan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mu hidin diday nangi'wahdi ya mamaga nan nunhi''anan nan liting hinan baybay an ay nakalata ot migaob nan liting hi nundinommang. ");
INSERT INTO ifa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ta inihwang Apu Dios nadan tinanud Israel hinadan i Egypt an namdug i dida i diyen algo. Ya tinigoday adol nadan nun'a'aten tindalun nun'iha'lit hinan da'ging di baybay. ");
INSERT INTO ifa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ta hidin tinigon nadan tinanud Israel hidiyen ongal an abalinan Apu Dios an gapu i diyen inatnah nadan i Egypt ya wada mohpey takutda i Apu Dios. Ya kulugonda mohpeh Apu Dios ya nan baalna an hi Moses. ");
INSERT INTO ifa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Hi Moses ya nadan ibbanan tinanud Israel ya ingkantaday pundayawdan Apu Dios. Ta hituwe nan kinantadan alyonday, Ikantaan ta'uh Apu Dios te immannung an hiyay na'abbaktun madayaw. Te nun'ipakbonah nan baybay nadan kabayu ya nadan nun'itakken titindalu. ");
INSERT INTO ifa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ta hiyay nangdat hi bikah'u ya am'amlong'u te inihwanga' i hiya. Ya hiya nan Dios an dayawo' ya nan anabaktunay haphapito' ya ikankanta'. Ya hiya tuwaliy dinayaw handidan a'ammod'u. ");
INSERT INTO ifa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hay ngadana ya hi Apu Dios an hiya nan nala'ing an mi'gubat. ");
INSERT INTO ifa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Te nun'ipakbonah nan baybay an mumbolah nadan tindalun nan patul hi ad Egypt. Ta nun'a'alting dadiyen mapemanan an opisyal di tindalu. ");
INSERT INTO ifa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Te nun'iloblob nan liting dida ta ayda batun nalnong hinan dopon di baybay. ");
INSERT INTO ifa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ot he\"a Apu Dios di ipabaktumi te ma\"id ha nipaddungan di abalinam an paddungnay ginudum nadan binuhulmu. ");
INSERT INTO ifa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ya ma\"id ha nipaddungan nan anabaktum te dinadagmu nadan mi'buhul i he\"a. Ta nama\"iddan ayda nagbun dagamih nangat di bungotmun dida. ");
INSERT INTO ifa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Te hidin inhapudmuh nan baybay ya naptut nan liting ta ay nundinommang ha atagetagen dingding hinan gawwan di baybay. ");
INSERT INTO ifa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ya nan munlattuwag an binuhulmu ya alyonay, Mipduga\"e ay ta akhupa' dida ya nun'ala' nadan nun'abalol an gina'uda ta ipiyappong'u ya binagi' an namin nadan omnawa'. Ya numpate' didah tun hinalung'u. ");
INSERT INTO ifa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mu he\"a Apu Dios ya namaag ya inhapudmuh naminghan ya nun'a'altingda ot mun'alnongdah ad dalom an ayda gumo'. ");
INSERT INTO ifa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Te ma\"id tuwali ha nipaddung i he\"an Dios an na'abbaktu. Ya ma\"id ha nipadpaddungan nan amaphodmu ya nadan nakaskasda'aw an abalinam. ");
INSERT INTO ifa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Te namaag ya intaggem nan winawwan an ta'lem ya inukmun nan luta nadan binuhulmu. ");
INSERT INTO ifa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ya gapuh nan ongal an pamhodmu ya ipangulum nadan inihwangmun tatagum ta inggana hi idatongmu didah nan boble an niyappit i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ta nadan tataguh abobboble ya munggagayonggongdah takutdah pangngolandah nadan inatmu. Ya namama mahan di takut nadan i Pilistia. ");
INSERT INTO ifa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ya ta'on on nadan ap'apuh ad Edom ya ad Moab. Ya nadan tataguh ad Kanaan ya ayda na'alingonga ");
INSERT INTO ifa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","hi takutda. Ya gapuh nan tinigodan ongal an abalinam ya namaag ya ayda batu ta ingganah mala\"uh amin tatagum. ");
INSERT INTO ifa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ta iye da'mih nan billid an indatmun da'mi an hidiye nan inyamman an punhituwam an niyappit i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ot nanongnan he\"a Apu Dios di mumpatul hi inggana. ");
INSERT INTO ifa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Hidin nitnuddah nan baybay nadan tindalun nan patul an numpunlugandah nan iluganan di e mi'gubat ya nungkakabayuday udum ya nundammuwom Apu Dios nan liting ta nun'altingda. Mu da'min tinanud Israel ya inagwatmi nan baybay an indalanmih nan namaganan hi gawwan nan liting. ");
INSERT INTO ifa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ya nan propeta an hi ibban Aaron an hi Miriam ya inalanay tamburin ot ipanguluna nadan ibbanan binabai ta nuntamburinda on nannannayoda. ");
INSERT INTO ifa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ot mungkantadan namin ot inayun Miriam an ikanta an alyonay, Ikantaan ta'uh Apu Dios te hiya ya na'abbaktu. Ta nun'ipakbonah nan baybay nadan kabayu ya nadan nilugan an titindalu. ");
INSERT INTO ifa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ot makakda bo nadan tinanud Israel an impangulun Moses didah nan agge naboblayan hi ad Sur. Ta eda immaninnabat hidi hi tuluy algo on ma''id ha akhupanda i ha liting. ");
INSERT INTO ifa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ya hidin dimmatongdah ad Marah ya wahdiy liting mu adi mabalin hi inumonda te mumpait. Ta hiya nan nangadanan hi ad Marah. ");
INSERT INTO ifa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ya ahilililida nadan tatagu i Moses an alyonday, Ot nganne moy inumon ta'u? ");
INSERT INTO ifa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ot mumpaboddang hi Moses i Apu Dios. Ya indani ya intuddun Apu Dios i hiya han naputung an kayiw ot alana ot ibkahnah nan liting. Ya numbalin hi matnaad an liting. Ya hidin awadandahdi hi ad Marah ya imbagan Apu Dios nadan tugunan dida ta hidiyey un'unudonda. Ta pinatnana dida hi'onda un'unudon. ");
INSERT INTO ifa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ot alyonay, Ihamadyu'en donglon datuwen tugun'u ta un'unudonyu ta nan nipto' di atonyu ya adi ma'at i da'yu nadan dogoh an na'at hinadan i Egypt te ha''on an Dios di mangipaphod i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ot makakda bo ta dimmatongdah ad Elim. Ta hidiy nangakhupandah himpulut duwan (12) obob ya nadan bungbunga\"an an palma an napitun (70) namin di pu''una. Ot umapaldahdi hinan haggon dadiyen obob. ");
INSERT INTO ifa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nakakda boh ad Elim nadan tinanud Israel ot ipluydah nan agge naboblayan an nungngadan hi Sin an numbattanan di ad Elim ya hi ad Sinai. Hidin dimmatngandah ad Sin ya mi'adwa moh bulan an nibaluy himpulut lima (15) hi nihipun hi nakakandah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ya hidin awadandahdi ya ngimmododa bon namin nadan tatagu i da Moses i Aaron ");
INSERT INTO ifa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","an alyonday, Udu'dulnaot boh on dita'u numpate i Apu Dios hidin awadan ta'uh ad Egypt. Te hidi ya waday dotag hi ihda ya mabalin an anon ta'u nan pinhod ta'un anon. Mu tanganu on da'mi e impanguluh tun agge naboblayan ta lo'tat tee ya inyatemiy inagangmi. ");
INSERT INTO ifa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ya indani ya alyon Apu Dios i Moses di, Nomnomnomom an idattan da'yuh makan an malpuh ad abunyan ta mun'a'agah an ay udan. Ibagam hinadan tatagu ta amawmawi\"it on limmah'unda ta eda mumpanuh i ha ammunah anonda i diyen algo ya abuh. Ato' hitu ta patnao' didah on immannung an un'unudonda nan alyo'. ");
INSERT INTO ifa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mu hinan mi'anom hi algoh adumiduminggu ya dakdakollonday amungonda ta mumpidway dinakol nan ugganda amungon hinan hin'algo ta waday anondah nan mi'apituh algo. ");
INSERT INTO ifa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ot ibagan mon da Moses i Aaron hinadan tatagu an alyonday, Hinan mun'ahdom ya innilaonyun hi Apu Dios di immannung an mangikak i dita'uh tun ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ya hinan mawi\"it ya tigonyuy binang Apu Dios an humili. Te dingngolna nadan dakol an punliliyanyun hiya. Te hay nginodowanyu ya hiya an bokon da'mi te da'mi ya onmi attog un'unudon nadan alyona. ");
INSERT INTO ifa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ot inayun Moses an alyon i diday, Hinan mun'ahdom ya wadaon Apu Dios di ihdayu ya hinan mawi\"it ya nan tinapay ta wan ma''abhug ayu. Te dingngolna nan liliyun hiya te bokon da'miy nginodongodowanyu te hiyay nangatanyu. ");
INSERT INTO ifa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ot alyon Moses i Aaron di, Ibagam hinadan tatagu ta umalidah tun pundayawan ta'u i Apu Dios te dingngolna nadan punliliyanda. ");
INSERT INTO ifa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ya hidin pun'ayagan Aaron nadan tatagu ot munligguhdah nangappit hinan agge naboblayan ya anakkaya nan binang Apu Dios an numpatigoh nan bugut. ");
INSERT INTO ifa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Dingngol'uy punliliyan nadan tinanud Israel ot ibagam i dida an hinan mun'ahdom ya waday ihdada. Ya hinan mawi\"it ya waday tinapay hi anonda ta mabhugda. Ta hituwey panginnilaanyun ha''on nan Dios an mangipapto' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ta i diyen mun'ahdom ya alinah on waday dakkodakkol an hamutin nungkohop hidih nan way immapalanda ta immapnaldah nan luta. Ya hidi bon nawi\"it ya namaag ya dimmulnun namin di nunlini''odan. ");
INSERT INTO ifa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ya hidin namaganan nan dulnu ya nabatiy kikkitang an ay dalallu an nun'iwakat hinan luta. ");
INSERT INTO ifa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ya hidin tinigon nadan tatagun tinanud Israel ya aggeda innila ta alyonday, Nganne nin datuwe? Ya alyon Moses i diday, Hinae nan indat Apu Dios an anon ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ya hay inalin Apu Dios ya alyonay, Panuhonyu nan ammunah anonyun hina'amma hinan hin'algo. Ta mabalin an ohay tagu on hinhalub di mahapulna. ");
INSERT INTO ifa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ta athidiy inat nadan tatagu. Mu ta'on hi oh'ohhay pinanuh di udum ya dakol hi udum ya ");
INSERT INTO ifa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","hidin hinalubda ya nan dakol di pinanuhna ya hiyah diyen agge nahawwalan ya nan oh'ohhay pinanuhna ya agge nakulangan te way ohaon hanan ammunan anondan hina'ammay inamungda. ");
INSERT INTO ifa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ot ibagan bon Moses i dida ta wan ma''id ha ibatida hi ahida anon hinan mabiggat. ");
INSERT INTO ifa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mu wadada damdamay agge nangunud i diyen inalin Moses ta imbatida doha. Mu hidin nawi\"it ya tinigodan nabigihan ya munhamuy. Ta bimmungot mo boh Moses i dida. ");
INSERT INTO ifa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ta amawmawi\"it on way ohaon nan ammunah anondan hina'ammah nan hin'algo di panuhona. Mu nan mabatih nan luta ya inumlot'e nan potang on nalanatda. ");
INSERT INTO ifa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ya hidin nadatngan nan mi'anom hi algo ot dubliyonday dinakol nan inamungda ta ohay tagu on duway halub. Ot umeda nadan mangipangpangulu i dida ot eda ihudhud i Moses hidiyen inatda. ");
INSERT INTO ifa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ya alyon Moses i diday, Nipto' hidiyen inatda te hiyah diyey imbagan Apu Dios te nan mi'apituh algo ya pun'iblayan ta'u te pundayawan ta'un hiya. Ot idadaanyuh ad uwanin namin nadan anonyu ta nan mabati ya hiyay anonyuh bigat. ");
INSERT INTO ifa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ot hiyay aton nadan tatagu an impa''eda nan nahawwal ta anondah nan mabiggat an mi'apituh algo. Ya manuh diye te agge nabahbah ya atbohdin agge nabigihan hidin nabiggat. ");
INSERT INTO ifa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ot alyon Moses i diday, Hinaey anonyu te ad uwani ya mi'apituh algon pun'iblayan ta miyappit i Apu Dios. Ot ad uwanin algo ya ma''id ha mabalin hi akhupanyu hi makan hinan luta. ");
INSERT INTO ifa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ot hiya nan mahapul an mamanu ayuh nan onom di algo hi anonyu. Te hinan mi'apituh algo an pun'iblayan ta'u ya ma''id ha panuhonyu. ");
INSERT INTO ifa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mu wadada damdamay udum i didan immen e mamanuh nan mi'apituh algo mu ma''id ha ta'on hi ohah inakhupanda. ");
INSERT INTO ifa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ya alyon Apu Dios i Moses di, Hi anu mo ya ahiyu un'unudon nadan tugun'u i da'yu? ");
INSERT INTO ifa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nomnomonyun ha''on an Dios ya winada' nan Habadun tungo. Ta hiya nan mi'anom'eh algo ya indat'uy anonyuh nan duway algo. Ot hinan mi'apituh algo ya ma\"id ha mange''eh nan awadanyu. ");
INSERT INTO ifa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ta nihipun i diye ya timmungoda nadan tatagu hinan mi'apituh algo an aggeda e nuntamu. ");
INSERT INTO ifa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ya hay nungngadan nadan tinanud Israel i diyen makan ya mana. Ya hay tigona ya ay kittang an buwa an pulaw. Ya hay tamtamna ya umat hinan niha''ang an alina mu ay nadduman hi danum di iyukan. ");
INSERT INTO ifa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ot alyon Moses hinadan tataguy, Inalin Apu Dios an ipa''e ta'u anu doha ituwen tinapay ta mabalin an tigon di mun'atanudan hi pidwanay a'at tun tinapay an indat Apu Dios hi itanud ta'uh tun agge naboblayan hi nangikakana i dita'uh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ot alyon Moses i Aaron di, Alam ha dundunnug ya inittum hidi ha hinhalub hinan mana ya em impa''eh nan way pundayawan i Apu Dios ta ahi tigon nadan mun'atanudan hi udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ta hidiyey inat Aaron an inha''adna dohah nan tinapay i han dunug ot iyenah nan pundayawan i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ta dadiyen tinanud Israel ya hidiyen mana di intanuddah awadandah nan agge naboblayan hi napat (40) di tawon ta inggana ot dumatongdah ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Hay inusalda handi an nunlukud hinan mana ya nan omer an hinhalub. ");
INSERT INTO ifa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nadan tinanud Israel ya nakakdah nan agge naboblayan hi ad Sin ot eda umaninnabat hinan kumpulnan nangipanguluwan Apu Dios i dida. Ot ahida mohpe bo umapal hi ad Repidim mu ma''id ha liting hi inumondahdi. ");
INSERT INTO ifa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ya bumohbohol nadan tatagu i Moses an alyonday, Iyalim ha liting ta inumonmi. Ya alyon Moses i diday, Tanganu on ayu bumohbohol i ha\"on? Tanganu onyu amod on e patnaon hi Apu Dios? ");
INSERT INTO ifa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ya gapu ta nunhiglay inuwohda ya ahingongododa i Moses an alyonday, Tanganu tuwali on da'mi e ingkak hi ad Egypt. Undan alyom on ta hituy atayanmin namin hitudan imbabalemi ya halunmi an gapuh inuwohmi? ");
INSERT INTO ifa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ot mumpaboddang mo boh Moses i Apu Dios an alyonay, Nganney ato' i datuwen tatagu? Namaag tayya ya nundadaandan mamalnu i ha''on. ");
INSERT INTO ifa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ya alyon Apu Dios i hiyay, Awitom dohah nadan mangipangpangulu i dida ya impanguluyu ta mitnud nadan tatagu. Ya inodnam din hu''ud an nunhoplatmu ni' hinan wangwang an nungngadan hi Nayl. ");
INSERT INTO ifa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nomnomnomonyu an haddon da'yuhdi hinan doplah hi ad Horeb. Nipto' ayu'eh nan doplah ya inhoplatmu nan hu''udmuhdi ot bumudduh di liting ta inumon nadan tatagu. Ot hidiyey aton Moses ta tinigon nadan nun'ibbana an mangipangpanguluh nadan himpahimpamu'un an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ot ngadananah diyen awadanda hi ad Massah te pinatnadah Apu Dios an alyonday on boddangan dita'u nin i Apu Dios onu adi? Ot ngadanana bo ta ad Meribah an gapu ta bimmohbohol nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Hidin wahdida ad Repidim ya immalida nadan tinanud Amalek ot gubatonda dida. ");
INSERT INTO ifa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ot alyon Moses i Joshua di, Pot'om dohah nadan linala'i ta eyu gubaton nadan tinanud Amalek. Ta hi bigat ya immeya' hinan uhhun nan nabillid an odna' nan hu''ud an alyon Apu Dios hi ala'. ");
INSERT INTO ifa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ot unudon Joshua nan imbagan Moses ta eda ginubat nadan tinanud Amalek. Yaden imme da Moses ya hi Aaron ya hi Hur hinan uhhun nan nabillid. ");
INSERT INTO ifa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ya hidin punggugubatanda ya intaggen'en Moses di ta'lena on mangab'abak nadan tinanud Israel. Mu binyuna'ey ta'lena on nadan tinanud Amalek di mangab'abak. ");
INSERT INTO ifa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mu lo'tat ya nabley ta'len Moses an mangitatagge ot iyen da Aaron i Hur han batu ta umbunana. Ot mumbinahheldan hiya ta diday nandol hi ta'lena ta inggana ot malimuh nan algo. ");
INSERT INTO ifa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ta inabak da Joshua nadan tinanud Amalek. ");
INSERT INTO ifa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ot alyon Apu Dios i Moses di, Itudo'muy a'at naen eyu nangabakan ta adi malingling. Ya ibagam i Joshua an dadago' an namin nadan tinanud Amalek ta mama\"idda. ");
INSERT INTO ifa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ot iyamman Moses han punggobhan hi mi'nong i Apu Dios ot ngadanana hi, Hi Apu Dios Di Bandela'. ");
INSERT INTO ifa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ot alyonah nadan tataguy, Wa'et hi Apu Dios di nanongnah ipabaktu ta'u ya hiyay ukod an mangubat hinadan tinanud Amalek hi inggana. ");
INSERT INTO ifa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Hi Jetro an padih ad Midian an hi aman nan ahawan Moses ya dingngolna nadan ina'inat Apu Dios an mamoddang i da Moses ya nadan ibbanan tinanud Israel hi nihipun hi nangikakanan didah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ya hi Jetro di nangipanapto' hinan ahawan Moses an hi Sipporah hidin impa'anamut Moses ");
INSERT INTO ifa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","didah nan duwan linala'in imbabaleda. An hay ngadan nan ohan imbabaleda ya hi Gersom te alyon Moses di, Ha''on ya ona' e ni'ibobleh udum an boble. ");
INSERT INTO ifa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ya nan oha ya nginadana ta hi Elieser te alyonay, Hi Apu Dios an dinayaw din a'ammod'u ya binoddangana' ta aggeya' pinateh nan patul hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ta hidin nun'allungan da Moses hinan agge naboblayan an nihnup hinan billid an niyappit i Apu Dios ya immali da Jetro an hi aman ahawan Moses ya hi ahawan Moses ya nadan imbabaleda. ");
INSERT INTO ifa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Mu namangulu tuwalin impaad Jetro di umaliyanda ");
INSERT INTO ifa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ta hiya nan e dinamun Moses dida. Ta hidin nundammudan hinama ot munhin'a'apngada ot inayundan umeh nan nun'allungan Moses. ");
INSERT INTO ifa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ot ibagan Moses i Jetro an namin nadan ina'inat Apu Dios hinan patul hi ad Egypt ya nadan tataguhdi an gapuh nangipapto'nah nadan tinanud Israel. Ot ibagana bo nadan numpalpaligatanda ya hay inat Apu Dios an nangihwang i dida. ");
INSERT INTO ifa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ta mun'am'amlong hi Jetro hi nangngolana i dadiye ");
INSERT INTO ifa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ot alyonay, Madayaw hi Apu Dios te inihwang da'yuh nadan i Egypt ya ta'on on nan patulda ta pinogpognay numpaligatanyuhdi. ");
INSERT INTO ifa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ot ad uwani ya innila' an hi Apu Dios di na'abbaktu hi an namin an imbilang di udum an tatagu hi dios te imbaliw da'yun tatagunah nadan i Egypt an namalpaligat i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Indani ya waday inyen Jetro hi mi'nong hi maghob an mi'nong i Apu Dios ya nadan udum an i'nongna i Apu Dios ot umali da Aaron ya an namin nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ot eda mi''an i diyen ini'nongna ta pundayawda i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hidin nabiggat hinan nawi\"it ya inhipun bon Moses an mangipanuh hinadan dakol an lilin nadan tatagu ta ingganah nan mahdom. ");
INSERT INTO ifa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ya hidin tinigon Jetro dadiyen at'aton Moses ya inalinan hiya di, Tanganu on waha athinah pangatmuh nadan tatagu? Ngalngalam ta ohhaam an mangipanuh i dida yaden dakkodakkoldan mamannod i he\"a an ihipundah nan mawi\"it ta ingganah nan mahdom. ");
INSERT INTO ifa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ya alyon Moses di, Mahapul an ato' hina te ha''on di umaliyan nadan tatagu an mummahmah nan pinhod Apu Dios hi atonda. ");
INSERT INTO ifa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Te umat hinan waha adi pun'innawatan di duwa an wa'e ta immalida ta ha''on di ukod an mangipanuh hi'on nganney numbahul i dida ya innayun'u bon impa'innila i dida nadan tugun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ya alyon amanan hi Jetro i hiyay, Adi maphod hinaen atom. ");
INSERT INTO ifa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Te hinaen tamu ya nunhiglah on ohhaam an mangat te nunnaud di ablayam ya atbohdih nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ot maphod onmu donglon tun itugun'u i he\"a. Ya hanat hi Apu Dios di bumoddang i he''a. Te mabalin an he''ay ukod an mangibagan Apu Dios hinan adi pun'i'innawatan nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ya intuddum i dida nadan tugun Apu Dios ya nan nipto' hi atonda ta mipappaphod di pangiye''eda. ");
INSERT INTO ifa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mu mahapul bon pot'om dohah nadan linala'i an waday abalinandan mangipanuh hinadan tatagu ya hi Apu Dios di taktanda ya mabalin an madinol'ah nan a'atda ya adi mabalin hi mabayadanda ta atonday nibahho. Ta datuwey pot'om hi ukod an mangipanuh hinadan tatagun ita'dogda. Ta hinan hinlilibu (1,000) on waday ukod hi mangipanuh i dida ya hinan hinggagahut (100) on wada boy ukod an mangipanuh i dida ya hinan nabongle (50) on wada boy ukod an mangipanuh i dida ya hina mohpe an himpupulu (10) on waday ukod an mangipanuh i dida. ");
INSERT INTO ifa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ta diday ukod an mangipanuh hinadan tatagun niyukod i dida ta ingganah on waha ha naligat hi adida abalinan ya ahida mohpe iyalin he''a. Mu na'e bahan an mabgawan ya diday ukod an mangipanuh. Ot atom'ehtu ya adi'a ma'aliggatan te pumboboddanganyu. ");
INSERT INTO ifa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ya onha hinaen inali' an miyunnudan hinan pohdon Apu Dios di atom ot manghan di ablayam ya atbohdih nadan tatagu te mabalin an malpah an mipanuh hinadan lilida ya ahida umanamut. ");
INSERT INTO ifa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ot hidiye moy unudon Moses. ");
INSERT INTO ifa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ta pinto'na dohah nadan ibbanan linala'in abalinandan mangipangpangulu. Ta wadaday pinto'nah mangipanuh hinadan umeh hinlibu (1,000) ya hinggahut (100) ya nabongle (50) ya himpupulu (10). ");
INSERT INTO ifa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ta dadiyen pinto'nay ukod an mangipanuh hinadan lilin di tatagu. Ta nadan naligat an adida abalinan ya abuh di iyeda i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ta hidin nagibbuh diye ot ahi pa'anamuton Moses hi aman ahawanan hi Jetro hi bobleda. ");
INSERT INTO ifa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Hidin mi'atluh bulan hi nihipun hi nakakandah ad Egypt an dimmatongdah nan agge naboblayan hi ad Sinai ");
INSERT INTO ifa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","hi nalpuwandah ad Repidim ot eda umappal hinan agge naboblayan hi pu\"un nan billid. ");
INSERT INTO ifa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ot tumikid hi Moses hinan billid ya himmapit hi Apu Dios i hiya ot ibaganan hiya nan pinhodnan ibagah nadan tinanud Israel an alyonay, ");
INSERT INTO ifa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Da'yu ya tinannigoyuy inat'uh nadan i Egypt. Ya innilayu boy inat'un nangipanapto' i da'yu ta indatong da'yuhtu an paddungnay intayap da'yuh agila ot iyali da'yuhtuh awada'. ");
INSERT INTO ifa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ot donglonyu'e nadan tugun'u ta hiyay un'unudonyu ta adiyu ibahho nadan ibaga' ya da'yuy nahamad hi tatagu' hitun luta. Manu te an namin hitun luta ya bagi' ");
INSERT INTO ifa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mu da'yu ya pinto' da'yu hi padi an munhilbi i ha\"on te niyappit ayu i ha\"on. Ot danaey em ipa'innilah nadan ibbam an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ot mumbangngad hi Moses ot amungona nadan mangipangpanguluh nadan himpahimpamu'un an tinanud Israel ot ibaganan namin nadan imbagan Apu Dios i dida. ");
INSERT INTO ifa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ya alyon nadan tataguy, An namin nadan imbagan Apu Dios ya hiyay unudonmi. Ta hidiyen nambal nadan tataguy e imbagan Moses i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ya alyon bon Apu Dios i Moses di, Nomnomnomom an umaliya' hi awadam an mumpatigowa' i han ma\"uktul an bugut ta mabalin an donglon nadan tataguy pi'hapita' i he\"a ta wan nanongnan donglonday ibagam i dida. Ta imbagan nimpen Moses i Apu Dios nan nambal nadan tatagu hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ya alyon Apu Dios i hiyay, Dumayyu'a ta em ibagah nadan tatagu ta atonda hi ad uwanin algo ya hi bigat nan mahapul an atonda ta wan mibilangdah malinis ya imbagam bo ta laba'anda nadan lubungda. ");
INSERT INTO ifa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ta hinan mi'atluh algo ya mundadaanda te umaliya' boh tun billid hi ad Sinai ta mabalin an tigona' hinadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Mu mahapul an pogpogom hi nunlini''odan tuwen billid nan adi mabalin an umayanda. Ya pinadanam i dida ta ma''id ha bumahhel i diye onu ha e mihnup hinan pogpog te mahapul an mipapate nan mangipatnan bumahhel hinan pogpog tuwen billid. ");
INSERT INTO ifa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ya hay atonyun mamate ya puntopayu onu panaonyu mu ta adiyu dapaon. Ya adi ammuna nadan tatagu hi patayonyu te ta'on on nadan animal hi'onda bumahhel hinan pogpog. Ta inggana hi donglonyu nan mipagangoh an tangguyub an madnemadne ya ahi mabalin hi tumikid nadan tatagu ituwen billid. ");
INSERT INTO ifa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ta dimmayyuh Moses hi awadan nadan tatagu ot ibagana ta atonda nan mahapul an atonda ta mibilangdah malinis. Ta imbagana an eda pun'ilaba' nadan lubungda ");
INSERT INTO ifa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ya adida mi'ilo' hinadan ahawada ta ingganah malpah nan pundayawanda. Ta hi ohhandi ya nalpah an nundadaanda. ");
INSERT INTO ifa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ta hidin nawi\"it i diyen mi'atluh algo ya alinah on mungkikidul ya mungkikilat. Ya matigo han ma\"uktul an bugut hinan billid. Ya wada han ma'aggangoh an tangguyub. Ta munggagayonggongdah takutda nadan tatagun immapal hidi. ");
INSERT INTO ifa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ot ipangulun Moses dida ta eda mi'dammu i Apu Dios mu immohnongda ya abuh nan pu''un nan billid. ");
INSERT INTO ifa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ya tinigodan nali'mut hi ahuk nan billid te apuy di nungkohopan Apu Dios hidi. Ta nunhiglay ahuk ya nunhigla bo han alyog i diyen billid. ");
INSERT INTO ifa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ya pun'olotdan pun'olot nan gangoh nan tangguyub. Ot humapit hi Moses ya ay kidul di dongol nan nambal Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Te hidin nungkohop hi Apu Dios hinan uhhun nan billid hi ad Sinai ot ayaganah Moses ta umehdi. ");
INSERT INTO ifa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ya alyon Apu Dios i hiya di, Dumayyu'a ni' ta em ibagah nadan tatagu ta adida ipatnan tumikid hitu an manigo i ha''on te atonda'e ya mateday dakol i dida. ");
INSERT INTO ifa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ya ta'on on nadan padi an umalin mihaggon i ha''on ya gahin di atonda nadan nibaga hi atonda ta mibilangdah malinis te adida'e ya dusao' dida. ");
INSERT INTO ifa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ya alyon Moses i Apu Dios di, Innila' an adida umali nadan tatagu te imbagam tuwali an pogpogonmi nan umohnonganda te niyappit hituwen billid i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ya alyon Apu Dios di, Dumayyu'a mo ta em awiton hi Aaron. Mu nadan tatagu ya ta'on on nadan padi ya adi mabalin hi bumahhelda nimpeh nan pogpog ta adi' dusaon dida. ");
INSERT INTO ifa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ot dumayyu mo boh Moses hi awadan nadan tatagu ot ibaganah diyen inalin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Datuwe nadan imbagan Apu Dios an alyonay, ");
INSERT INTO ifa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ha''on an hi Apu Dios an dayawonyu an nangikak i da'yuh ad Egypt hidin nihbutanyu. ");
INSERT INTO ifa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ot mahapul an ma''id ha udum hi ibilangyuh dios hi dayawonyu ta ha''on ya abuh. ");
INSERT INTO ifa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ya adi ayu mangiyamma hi dayawonyu hi tinagtaggu onu ing'ingoh di kumpulnan wah ad lagud onu hitun luta onu hi dallom nan nalitingan. ");
INSERT INTO ifa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Adi mabalin an e ayu munyu\"ung ta dayawonyu dida. Te ha''on an hi Apu Dios ya adi' iyabulut an waday udum hi dayawonyu. Te dusao' nadan e mundayaw hi udum an ta'on on nadan tanudanda hi ingganah nan mi'apat an tinanud. ");
INSERT INTO ifa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mu hinadan naminhod i ha''on an un'unudonda nadan tugun'u ya ipatigo' boy pamhod'un dida ya hinadan tanudandah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ya mahapul an adi nalgom di pangiyusalanyuh ngadan'u an Dios an dayawonyu te ha\"on an Dios ya dusao' nan tagun mangathidi. ");
INSERT INTO ifa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tigonyu ta ngilinonyu nan Habadun tungo ta ibilangyuh niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Te onom di algoy mabalin hi puntamuwanyu. ");
INSERT INTO ifa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mu hinan mi'apitun algo ya pun'iblayanyu ta pundayawanyun ha''on an Dios. Ot mahapul an ma''id ha muntamu i da'yu an ta'on on nadan imbabaleyu ya baalyu ya halunyu onu nadan mangiliyu. ");
INSERT INTO ifa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Te ha''on an Dios ya athidiy inat'u an nuntamuwa' hi onom di algo hi nunlumuwa' hitun luta ya ad lagud ya nan baybay ya an namin di wadahdi. Mu hidin mi'apituh algo ya nginilin'uh diyen algo. ");
INSERT INTO ifa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Mumpada''ul ayuh nan hi amayu ya hi inayu ta wan madmadney pi'taguwanyuh nan boblen idat'u i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ya adi ayu pumate. ");
INSERT INTO ifa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ya adi ayu umiluktap. ");
INSERT INTO ifa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ya adi ayu mangako. ");
INSERT INTO ifa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ya muntistigu ayu'e ya bokon nan agge immannung di ibagayu hi inat nadan ibbayu. ");
INSERT INTO ifa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ya adiyu omnawan nan wadah nadan ibbayu an umat hi baleda onu ahawada onu himbutda onu bakada onu dongkida onu nadan udum an wadan dida. ");
INSERT INTO ifa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Hidin tinigon nadan tatagu nan kilat ya dingngolda nan kidul ya nan tangguyub ya minangmangda bo nan ahuk hi uhhun di billid ya munggagayonggongdah takutda. Ot eda mibata\"an. ");
INSERT INTO ifa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ya alyonda i Moses di, Ta'on attog on he''ay humapit i da'mi ot donglonmi mu ta bokon hi Apu Dios te hiya'ey humapit i da'mi ya tumakut ami te alina mo ahan ya nun'a'ate ami. ");
INSERT INTO ifa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ya alyon Moses i diday, Adi ayu tumakut te manu'eh immalih Apu Dios ya ta innilaonyuy a'atna ta wan hiyay unudonyu ta adi ayu mumbahul. ");
INSERT INTO ifa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mu ta'on hi athidiy imbagan Moses ya hiya damdaman bimmata''an nadan tatagu. Ta hi Moses mo ya ammuna di e nihaggon hinan way munhihillong an bugut an awadan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Alyon bon Apu Dios i Moses di, Ibagam hinadan ibbam an tinanud Israel ta alyom di, Alyon Apu Dios i da'yu di, Tinigoyuy inat'u an himmapit i da'yu hi awada' hi ad abunyan. ");
INSERT INTO ifa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ot ibaga' i da'yu an adi ayu mangiyamma hi udum an dayawonyu an balitu' onu silber. Ta ha\"on an Dios ya ammunay dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ya mangapya ayu i ha pito' an punggobhan hi mi'nong i ha\"on ta hidiy pangi'nonganyuh nadan kalnero ya gulding ya baka an mi'nong hi maghob an mi'nong ya mi'nong hi pi'hayyupanyun ha\"on. Ya an namin nadan ituddu' i da'yu an eyu pundayawan i ha\"on ya waa' hidi ta wagahan da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mu hi'on hay iyammayuh punggobhanyu hi mi'nong i ha\"on ya batu ya mahapul an nan agge nahabatan. Te ibilang'uh nabahbah hi'on waday usalonyu ta tommangonyu nan batun itpingyu. ");
INSERT INTO ifa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ya adi ayu mangapya hi punggobhan hi mi'nong an waday agdana te wa'et tumikid ayu ya matigoy tipayu on waday taguh nunda\"ul. ");
INSERT INTO ifa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Alyon bon Apu Dios i Moses di, Ipa'innilam bo datuwen tugun an alyonay, ");
INSERT INTO ifa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Gumattang ayu'e hi himbut an lala'i an ibbayun Hebrew ya onom di tawon ya abuh di punhilbiyana i da'yu. Ta hinan mi'apituh tawon ya inlubusyu ta umaan i da'yu an ma\"id ha bayadana. ");
INSERT INTO ifa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ya agge'e nangahawa ya hiyah diyen ohan umanamut. Mu nangahawa'e tuwali ya mahapul an mi'uyug i hiya nan ahawana. ");
INSERT INTO ifa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mu hi'on nan ud himbut di nunlahin i hiya ta nawaday imbabaleda ya paddungnay bagin nan ud himbut i hiyah diyen babai ya nadan imbabaleda. Ta hiya ya abuh di mabalin an umaan hidi. ");
INSERT INTO ifa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mu hi'on adi pohdon nan himbut an taynan nan pamilyana ya nan ud himbut i hiya te pohpohdona dida ");
INSERT INTO ifa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ya hay aton mon nan ud himbut i hiya ya uyugona ta umedah nan pundayawanda i Apu Dios ya ena impata'dog hinan way tu\"ud hinan panto ya tinlo'nay ingan diyen himbut i ha nahulitan hi gumo' ta pangimatunan an numbalin moh himbut ta ingganah mate. ");
INSERT INTO ifa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ya hi'on nan ama ya ihbutna nan babain imbabalena ya adi mabalin hi mapogpog di ahimbutna an adi umat hinan lala'in himbut. ");
INSERT INTO ifa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ya onha hidiyen tagun nihbutana ya waday aggena pinhod i diyen babai ya mahapul an nan hi aman diyen himbut di ena pangibagan ta bangngadona. Te adi mabalin hi inginanah kumpulnan tagu ta adi mibahho nan nunhapitanda. ");
INSERT INTO ifa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Mu onha hidiyen babain himbutna ya impa'ahawanah nan imbabalenan lala'i ya mahapul an ibilangna moh imbabalena ta bokon mo himbut. ");
INSERT INTO ifa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ya onha nan lala'in nalahin hinan himbut ya nalahin boh oha ya mahapul an adina idinong an mangdat hinan mahapul diyen namangulun ahawana hi itanudna ya ilubungna ya mahapul an adi maluman di pangibilangna i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ya hi'on adina aton dadiyen tulu ya liblih diyen babain umaan hidi an ma\"id ha bayadana. ");
INSERT INTO ifa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Alyon bon Apu Dios di, Nan waday hinuntukna ta nateh diyen tagu ya mahapul an mipapateh diyen pimmate. ");
INSERT INTO ifa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mu hi'on aggena ninomnom an patayon mu apyanan hidiyey inyabulut'uh ma'at ya mabalin an bumtik hinan boblen tudduwo' ta e mipa\"ehdi. ");
INSERT INTO ifa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mu hi'on tuwali ninomnom diyen tagun pumate ot ta'on hi alinah binumtik hinan way punggobhan hi mi'nong ya mahapul an eyu pa'aanon hidi ya pinateyu. ");
INSERT INTO ifa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ya nan tagun hinuntuknay hi amana onu hi inana ya mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ya nan tagun waday inibtiknah tagu ot ena ihbut ya ta'on on aggena ni' e inihbut hidin na'akhupan ya mipapate damdama. ");
INSERT INTO ifa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ya nan tagun idutanay hi amana onu hi inana ya mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ya onha mun'awwitday duwan tagu ya niknah oha nan batun imbalnun nan ni'yawwitna onu nunhuntukna mu agge nate ");
INSERT INTO ifa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ya indani ya mabalin an munhu\"ud on e nundaldallanan ya hay bayadan nan ni'yawwitna i hiya ya nan algon nataktakanah tamuna ya nan mahapulnan umat hi agah ta ingganah pumhod. ");
INSERT INTO ifa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ya onha pinang'ulan di ohan tagu nan himbutnan lala'i onu babai ya nipadih an nate ot mahapul an mamoltah diyen tagu. ");
INSERT INTO ifa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mu hi'on agge nate ta naluh ha oha onu duway algo ya pinumhod ot adi mamolta te hidiyen himbut ya mibilang hi bagina. ");
INSERT INTO ifa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ya onha waha linala'ih mun'awwit ya inlagatda ha numbutyug ta linummuh nanguluhanah nan imbutyugna mu ma\"id ha udum hi hugatna ot nan tagun nangilagat i hiya ya mahapul an ukatona nan ibagan nan ahawan diyen babai hi'on hidiyey inyabulut nan huwis. ");
INSERT INTO ifa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mu onha waday na'at hinan babai an umat hi ate ot hidiye mo boy ma'at hinan bimmahul. ");
INSERT INTO ifa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ya onha napilok ot mahapul an miballoh pibo ta mapilok bo. Ya onha ta hay bobanay na'aan ot athidi bon mahapul an maplag di bobana. Ya onha hay ta'lena onu hay hukinay nahugat ya atbohdin athidiy ma'at hinan bimmahul. ");
INSERT INTO ifa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ya limmandu\"e ya mahapul an malandu'an bo. Ya himmugat'e ya mahapul an mahugatan bo. Ya hi'on limmunggid ya mahapul an malunggidan bo. ");
INSERT INTO ifa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ya onha hay ohan tagu ya piniloknay matan nan himbutnan lala'i onu babai ot mahapul an ilubusnah diyen himbut ta hidiyey ay bayad nan napilok an matana. ");
INSERT INTO ifa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ya athidi boh on hay boban nan himbutnay pinanguwana an hay pumbayadna ya ilubusnah diyen himbut. ");
INSERT INTO ifa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Nan bulug an baka ya onha waday hina'gudnah tagu ya nate ot mahapul an puntopayu ta ingganah on mate mu adi mabalin hi mihda. Ya bokon bahul nan ud baka ot adi mamolta. ");
INSERT INTO ifa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mu hi'on nan baka ya on tuwali mabungot an pumdug hi tagu ta binagaanda nan ud baka mu aggena impukuk ta ingganah waday tagun pinatena ot hiyah diyen puntopayu ta ingganah mate. Ya ni'pateyu nan ud baka. ");
INSERT INTO ifa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mu abulutonda'en mumbayad nan ud baka ta adida patayon ya mahapul an bayadanan namin nan ibagadan moltana. ");
INSERT INTO ifa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ya hina'en nitugun damdamay ma'unud an ta'on on ungan lala'i onu babai nan pinaten nan baka. ");
INSERT INTO ifa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ya hi'on himbut nan pinatena ya nan ud baka di mumbayad hi tulumpuluy (30) silber an pihhu hinan ud himbut i diye ya ahida pumbalnu nan baka ta ingganah on mate. ");
INSERT INTO ifa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ya onha waha e nungka\"ut hi bubun ya aggena kinaluban onu inattanan inaan nan kalub ya indani ya nabituhdi ha baka onu dongki ");
INSERT INTO ifa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ot nan ud bubun ya bayadana nan ud bagih nan animal ya baginah diyen nate. ");
INSERT INTO ifa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ya onha nan bakan di ohan tagu ya pinatenay bakan di oha bon tagu ot hay atondan duwa ya inginada nan matagun baka ya ginodwada nan bayadna. Ya nunduwaonda bo nan naten baka ta mumpaddung di bingayda. ");
INSERT INTO ifa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mu onha innilan tuwalin nan ud baka an mabungot nan bakana mu aggena impukuk ot mahapul an hukkatanah matagu nan naten baka ya bagina nan nate. ");
INSERT INTO ifa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Nan tagun inakona ha baka ot paltiyona onu ingnginana ya mahapul an bayadana nan bakah limay baka. Ya hi'on kalnero ya bayadanah opat an kalnero. ");
INSERT INTO ifa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Onha nan mangako ya hinggopna ha baleh nan hilong ya pinaten nan ud bale ot agge numbahul nan namaten hiya. ");
INSERT INTO ifa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mu hi'on mapatal di namatayana ya mibilang hi pimmate. Nan nangako ya mahapul an bayadana nan inakona mu ningamut'en adi pa'abbayad ya mahapul an mihbut ta nan bayadna di mibayad hinan inakona. ");
INSERT INTO ifa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ya hi'on na'akhupan an matagu nan inakonan animal an umat hi baka ya dongki onu kalnero ya madubliy pumbayadna. ");
INSERT INTO ifa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ya onha nan animal ya nibu'an hinan puntanoman ta inlagatnan inan nan intanom di udum ot mahapul an hukkatan nan ud animal hinan ap'aphodan an bungan di intanomna. ");
INSERT INTO ifa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ya onha waha mumpu'ul ya indani ya inlagat nan apuy an pinu'ulan nan intanom di udum an tatagu onu nan na'amung an binto'da ot mahapul an bayadan diyen tagu nan napu'ulan. ");
INSERT INTO ifa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ya onha inabulut di ohan tagun ipa\"eh balena nan pihhu onu kumpulnan gina'un ipipa\"en nan hinaggona mu indani ya na'ako ot ma'akhupan'e nan nangako ya madubliy pumbayadna. ");
INSERT INTO ifa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mu ma\"id'e ha ma'akhupan ya iyukodda moh nan huwis an mangibagah on hidiyen niyukodanay munlayah. ");
INSERT INTO ifa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ya hi'on mun'addiyanday duwan tagu an way ohaon alyonay hiyay ud bagih nan umat hi baka onu kalnero ya dongki ya luput onu nganneh diye ya iyeyu didah nan pundayawan. Ta nan ipa'innilan Apu Dios an munlayah ya madubliy pumbayadnah nan ud bagi. ");
INSERT INTO ifa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ya onha waha taguh ipipapto'na nan umat hi dongki ya baka ya kalnero onu nadan udum an animal hinan hinaggona ya indani ya nate onu nahugatan onu na'akoh diyen animal ");
INSERT INTO ifa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ot hay atonyun mangipanuh ya ume ayuh nan pundayawan i Apu Dios ta isapatan diyen numpapto' an ma\"id ha inatnah adi maphod hinan animal. Ya nan ud bagih nan animal ya abulutonah diyen insapatana ta adina ipabayad. ");
INSERT INTO ifa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mu hi'on na'innilaan an inakodah nan niyukodana ya mahapul an mumbayad hidiyen niyukodanah nan ud bagi. ");
INSERT INTO ifa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Mu alina'e hi pinaten di atap an animal ya gahin di e ipatigon nan mumpapto' nan nabatih nan adolna hinan ud bagi ya ahi mabalin an adina bayadan. ");
INSERT INTO ifa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ya onha nan ohan tagu ya binanohna nan animal nan hinaggona ya indani ya nahugatan onu nateh din ma\"id nan ud bagi ya mahapul an bayadan nan numbanoh. ");
INSERT INTO ifa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mu onha wada nan ud bagih na'atana ya adi mahapul an bayadan nan numbanoh. Ya hi'on inabanganah diyen animal ya hidiye moy ayna bayad. ");
INSERT INTO ifa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ya onha ihaphapitan di ohan lala'i ha mangilog hi babaih agge nitbi ta nalo'da ot mahapul an ukaton diyen lala'i nan nitugun an mibayad hinan babain mungkasal ya ahi mibilang an ahawana. ");
INSERT INTO ifa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mu hi'on adi pohdon nan hi aman nan babai an ahawaon diyen lala'i ya mahapul damdaman bayadan nan lala'i nan balol di midat hinan mungkasal an babai. ");
INSERT INTO ifa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ya mahapul an patayonyu nan babain mun'ayak. ");
INSERT INTO ifa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ya hi'on wada ha taguh ilo'nay animal ya patayonyu. ");
INSERT INTO ifa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ya mahapul an mipapate nan tagun kumpulnay pangidawatanah i'nongna an bokon ha\"on an Dios ya abuh di pangidawatanah nan i'nongna. ");
INSERT INTO ifa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mahapul an adiyu paligaton nan mi'iboblen da'yu te da'yu ya e ayu ni' ni'ibobleh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ya adiyu lukuwon nadan nun'apuhig onu nadan nun'abalu. ");
INSERT INTO ifa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Te atonyu'ehdi ya mumpahpahmo'dan ha\"on ot umannung an boddanga' dida. ");
INSERT INTO ifa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ta gapuh bungot'uh nan pangatyu ya numpate da'yu ta mabaluda nadan binabain ahawayu ya napuhigda nadan imbabaleyu. ");
INSERT INTO ifa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ya wada'ey impagawatyuh nadan ibbayun tatagu' an nawotwot ya adiyu hingilon hi pulsintun nan pihhuyu ta adiyu iyunnud hinan aton di mumpagawat hi pihhu. ");
INSERT INTO ifa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ya wada'e ha nangipalendah nan oddah di lubungnan da'yu ya mahapul an ipabangngadyun hiya ya ahi mahdom. ");
INSERT INTO ifa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Te hidiye han panandinah kumog. Ot adiyu'e ipabangngad ya mumpahpahmo' i ha\"on ot umannung an boddanga' te ha\"on ya ongal di homo\"u. ");
INSERT INTO ifa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Mahapul an adiyu hapiton di adi maphod i ha\"on an Dios ya adiyu idutan nan mangipangpangulu i da'yun tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ya adiyu ukuhan an idat nadan lebbengnan midat i ha\"on an inapityuh nadan intanomyu ya nadan udum an umat hi bayah ya manteka. Ya mahapul bon iyaliyun ha\"on nan panguluwan an lala'in imbabaleyu te niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ya ta'on on nadan hopap di imbabalen di bakayu ya kalneroyu ya atbohdiy atonyu. Ta niyayyamda'e ya adiyu ni' ihiwweh nan hi inanah pituy algo ta nan mi'awaluh algo ya ahiyu idawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Da'yu ya niyappit ayun ha\"on. Ot mahapul an adiyu ihda nan animal an pinaten di atap an animal ta ipa'anyuh kahu. ");
INSERT INTO ifa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Alyon bon Apu Dios i Moses di, Adiyu e ibagabagah tataguy agge immannung an na'at. Ya muntistigu ayu'e ya adiyu ibagay layah ta panandiyuh nadan bimmahul. ");
INSERT INTO ifa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ta ta'on on dakol di mangat hi adi maphod ya adiyu iyunnud i dida. Ot nan immannung ya ammunay ibagayu an ta'on hi dakol nadan tatagun mangita'dog hinan nibahho. ");
INSERT INTO ifa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ya adi gapu ta nawotwot nan nidalom ya ihakityu an ta'on on bimmahul. ");
INSERT INTO ifa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ya wa'e ta akhupanyu nan binumtik an baka onu ha dongkin nan binuhulyu ya mahapul an alanyu ya inyeyun hiya. ");
INSERT INTO ifa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ya athidi bon tigonyu'e nan dongkin nan ma'ahihhiwo i da'yu an nihu'ob ta maligatan an tuma'dog an gapuh nan madamot an kinalgana ya tigonyu ta boddanganyu ta adi namaag ya tinaynanyu. ");
INSERT INTO ifa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ya mahapul an pumpapaddungonyuy atonyun mangipanuh hi mihahapit an adi gapu ta nawotwot nan waday dalomna ya adiyu boddangan. ");
INSERT INTO ifa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ya adiyu ipabahul di agge immannung hi kumpulnan tagu. Ya adiyu ipapate nan tagun ma\"id ha bahulna te ha\"on di mangiballoh hinan tagun mangathidi. ");
INSERT INTO ifa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ya hi'on nan tagun bimmahul ya bayadan da'a ta hiyay boddangam ya adim abuluton te nan ibayadna di ay mamilok i he\"a ta adi ma'at nan nipto' an ma'at hinan tagun ma\"id ha bahulna. ");
INSERT INTO ifa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ya adiyu paligaton nadan tatagun immalin mi'boblen da'yu te lini'nayuy a'atnah din eyu ni'iboblayan hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Nan lutayu ya tanotanomanyu on inapityuy bungadah nan onom di tawon. ");
INSERT INTO ifa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mu nan mi'apituh tawon ya adiyu tanoman ta ay mun'ible. Ot nan kumpulnan bumungahdi ya mabalin an apiton nadan ibbayun nun'awowotwot. Ya nan batiyonda ya anon nadan atap an animal. Ya athidi boy atonyuh nadan puntanomanyuh greyp ya nadan bungbunga\"an an olibo. ");
INSERT INTO ifa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ya muntamu ayuh onom di algo mu nan mi'apituh algo ya mun'ible ayun namin hinadan puntamuwonyun umat hi baka ya dongki ya nadan himbutyun niyayyam hinadan numpunhituwanyu ya ta'on on nadan tatagun ni'iboblen da'yu ta mun'ibleda. ");
INSERT INTO ifa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ot tigonyu ta wan un'unudonyun namin datuwen imbaga' i da'yu. Ya adiyu ipatnan mundasal hinadan dios di udum an tatagu ya ta'on on hay ngadanda ya adiyu uggan ngadanon. ");
INSERT INTO ifa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Hinan hintawon ya tuluy ngilinonyu ta pundayawyun ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ta ngilinonyu nan pangananyuh tinapay an agge nadduman hi yist. Ta nadatngan'e nan bulan di Abib an hidiye din nakakanyuh ad Egypt ya inun'unudyu nan tugun'un da'yu ta adi ayu mangan hi tinapay an nadduman hi yist hi pituy algo. Ya way ohaon indadaana tuwali nan idawatnan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ya ngilinonyu bo nan ahi'apit an pangidatanyun ha\"on an Dios hinan hopap di apitonyu. Ya ngilinonyu bo nan pun'apitanyuh bungan di intanomyun greyp ya nadan udum an bungbunga\"an. ");
INSERT INTO ifa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ta mumpitluh nan hintawon an an namin ayun linala'i ya umali ayuh nan pundayawanyu i ha\"on an na'abbaktun Dios. ");
INSERT INTO ifa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ya nan middum hinan i'nongyun animal i ha\"on ya nan tinapay an ma\"id ha niddum hi yist. Ya nan inaanyun taban nan ini'nongyu ya mahapul an maghob i diyen algo ta adi mabigatan. ");
INSERT INTO ifa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ya hay iyaliyuh nan pundayawanyu i ha\"on ya nan ap'aphodan hinan hopap di apitonyu. Ya adiyu pundanum hinan iha\"angyun ukkon an gulding nan gatas nan hi inana. ");
INSERT INTO ifa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Nomnomnomonyu an honago' han anghel ta hiyay mangipangulu ya mangipappapto' i da'yuh nan awon ta ingganah on da'yu idatong hinan boblen indadaan'un eyu punhituwan. ");
INSERT INTO ifa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ot donglonyun namin nadan ibagana ya inunudyu ta adiyu ngohayon te adi da'yu pakawanon hi'on adiyu un'unudon te ha\"on di nannag i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mu hi'on un'unudonyun namin nadan ibaganan nalpun ha\"on ya ha\"on di mi'buhul hinadan binuhulyu ta hanggao' an namin nadan mananggan da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ot ipangulu da'yu nimpe hinan anghel'u ta ingganah dumatong ayuh nan numpumboblayan nadan tinanud Kanaan an dida nadan tinanud Amor ya tinanud Hit ya tinanud Peris ya tinanud Hib ya tinanud Jebus ta dadago' didan namin. ");
INSERT INTO ifa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ot bagaan da'yu ta adiyu ipatnan iyunnud hinan pangiye\"eda ta adiyu taktan onu dayawon nadan dakol an diosda. Ot mahapul an pumpa\"ihyu nadan diosda ya ta'on on nadan inha\"addan batun dayawonda. ");
INSERT INTO ifa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ta ha\"on ya abuh an hi Apu Dios di nanongnah dayawonyu ta minaynayun an wagahan da'yun ha\"on ta waday anonyu ya inumonyu. Ya iyadawwi da'yu hi an namin an dogoh. ");
INSERT INTO ifa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ya ma\"id hinadan binabai ha manguluh nadan imbutyugda onu ha e mabutingo i da'yu. Ya iyabulut'un adukkey pi'taguwanyuh tun luta. ");
INSERT INTO ifa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ot hay ato' ya patakuto' nadan tataguh nadan boblen datnganyu. Ta nadan mangubat i da'yu ya pabtiko' didan namin. ");
INSERT INTO ifa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Te pamanguluwo' di kumalat i dida ta pabtikonda nadan tinanud Hib ya tinanud Hit ya an namin nadan tinanud Kanaan. Ta ma\"id ha humandi i da'yuh nan umayanyuhdi. ");
INSERT INTO ifa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mu adi' gulpiyon an pabtikon didan namin hinan hintawon ta adi minganuy nadan udum an naboblayan. Ya ta adi dumakol nadan atap an animal. ");
INSERT INTO ifa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ta ahinuto' didan pa'aanon ta damunahdi ya dimmakol ayu ta mabalin an mihinap ayu i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ot hay binillog nan pumboblayanyu ya mihipun hinan baybay an mumbolah ta ingganah nan baybay an nungngadan hi Mediterranean ot ipluynah nan agge naboblayan ta ingganah nan wangwang an nungngadan hi Euprates. Ya ipa'abak'un da'yu nadan tatagun nunhituhdi ta pa'aanonyu didahdi. ");
INSERT INTO ifa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ya adiyu ipatnan mi'itobbalan i dida onu e middum i dida an mundayaw hinadan diosda. ");
INSERT INTO ifa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ya adiyu iyabulut an mi'ibobledan da'yu te mi'ibobleda'e i da'yu ya lo'tat ya baliyan da'yun dida ta middum ayun mundayaw hinadan diosda ta mumbahul ayu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Alyon bon Apu Dios i Moses di, Awitom hi Aaron ya hi Nadab ya hi Abihu ya ha napituh (70) nadan ap'apun di himpahimpamu'un an tinanud Israel ya timmikid ayuh tun awada'. Mu umohnongdah nan nibata\"an ta dayawona' i dida ");
INSERT INTO ifa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ta he''a Moses ya abuh di umalin mihaggon i ha''on ta adida mi'yalin he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mu imme ni' hi Moses hi awadan nadan tatagu ot ibaganan namin nadan imbagan Apu Dios ya nadan tuguna. Ya hidin dingngol nadan tatagu ya alyonday, An namin nadan imbagan Apu Dios ya unudonmi. ");
INSERT INTO ifa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ot itudo' Moses an namin dadiyen tugun Apu Dios. Hidin mun'awiwi\"it i diyen nabiggat ot apyon Moses han pangigobhan hi mi'nong hidih nan pu''un di billid ot li'wohonan nun'ipabun hidiy himpulut duwan (12) batu ta nipong hinan himpulut duwan (12) tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ta hidin niphod ot alyonah nadan mangilog an linala'i ta eda i'nong nan maghob an mi'nong i Apu Dios ya nadan mi'nong hi pi'hayyupanda i Apu Dios an bubulug an baka. ");
INSERT INTO ifa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ot godwon Moses nan dalan di ni'nong an inittunay godwanah nadan malukung an duyu. Ya ena nun'iwalaghi' nan godwanah nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ot alana nan Nitudo' an Tugun Apu Dios ot oltonan ibahah nadan tatagu. Ya hidin imbahana ya alyon nadan tataguy, Pinhodmin aton an namin nadan ibagan Apu Dios ta nadan tugunay un'unudonmi. ");
INSERT INTO ifa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ot alan bon Moses nan dalan nittuh nadan malukung an duyu ot pun'iwalaghi'nah nadan tatagu. Ot alyonay, Hituwen dalay mangipa'innila an mipa'annung nadan imbagan Apu Dios hi atona i da'yuh din nangidatanah nadan tuguna. ");
INSERT INTO ifa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ot tumikiddah nan billid da Moses ya hi Aaron ya hi Nadab ya hi Abihu ya nadan napitun (70) ap'apun di himpahimpamu'un an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ya tinigodah Apu Dios an dayawondan tinanud Israel an hay nangigoppa'ana ya han ay natping an mapmaphod an batun sapira an umat hi tigon di ad lagud hinan ma\"id ha bugutna. ");
INSERT INTO ifa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mu ta'on hi tinigon dadiyen ap'apun di himpahimpamu'un an tinanud Israel hi Apu Dios ya aggeda nate. Ot manganda ot manginumda. ");
INSERT INTO ifa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Indani ya alyon Apu Dios i Moses di, Tumikid'ah tun billid ta umali'ah tun awada' ta idat'uy duwan batun nangitudo'a' hi an namin nadan tugun'u ta mitudduh nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ta hidin makak da Moses hinan pun'ibba'ibbanan hi Joshua ta tumikiddah nan billid ta umedah awadan Apu Dios ");
INSERT INTO ifa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ot alyon Moses i dadiyen ap'apu di, Umohnong ayu mohtu ta ingganah abangngada'. Ta'ommanot wahtu da Aaron i Hur ta wada'ey mihahapit ya diday nangiyayanyu. ");
INSERT INTO ifa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ot inayun Moses an tumikid hinan billid. Ya tinigonan nahophopan hi bugut. ");
INSERT INTO ifa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ya hidiyey itigana an wadah Apu Dios i diyen billid. Ta onom di algo an nahophopan hidiyen billid hi bugut. Ya hidin mi'apituh algo ya himmapit hi Apu Dios i Moses hinan way bugut. ");
INSERT INTO ifa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ta hay nanigon nadan tinanud Israel i diye ya ay mundalang ha apuy hi uhhun nan billid. ");
INSERT INTO ifa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ya hidin manikid hi Moses ya nahophopan hi bugut. Ot mihaha''ad hidi hi napat (40) di algo ya napat (40) di hilong. ");
INSERT INTO ifa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Ibagam hinadan tinanud Israel ta way oha i dida on inyalinan he\"a nan pinhodnan idawat i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ya hay mabalin hi idatda ya balitu' ya silber ya gombang ");
INSERT INTO ifa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ya asul ya bayulet ya mumbolah an hinulid ya napinun linen ya dutdut di gulding ");
INSERT INTO ifa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ya up'up di tangbal an kalnero an nakololan hi mumbolah ya nan up'up di animal hinan baybay ya kayiw an akasya ");
INSERT INTO ifa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ya nan lanan di olibo ta ma'usal hinan punhilawan ya nan middum hinan lanan mihiit hinadan miyappit i ha\"on an Dios ya nan middum hinan maphod di hunghungnan insenso. ");
INSERT INTO ifa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ya mabalin bo nadan oniks ya nadan udum an nun'abalol an batu ta miha\"ad hinan ephod ya nan miyoddah hinan ephod. ");
INSERT INTO ifa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","An namin danae ya ma'usal hinan ipiyamma' an pundayawanyun ha\"on ta mi'hituwa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ta iyammayu nan tabernakel ya nadan mahapul hidi an iyunnudyuh nan ipatigo' i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Alyon bon Apu Dios i Moses di, Ipiyammam ha kahun an hay iyammada ya nan kayiw an akasya an hay dinukkena ya napat ta limay (45) pulgada. Ya hay binillogna ya tinagena ya numpaddung an baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ya iniphodyun inoddahan hi namahmah an balitu' di dallomna ya nan muntigo. Ya inalkusanyu boh namahmah an balitu' nan nundina'ging hi uhhuna. ");
INSERT INTO ifa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ya inyammayuy opat di natuligonggong an balitu' ya inipongyun inyammah nan opat an hukin nan Kahun ta hindudwah numbinahhel. ");
INSERT INTO ifa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ya nangiyamma ayuh pangiyattangan an hay iyammayu ya nan kayiw an akasya ya inoddahanyuh balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ya numbinahhelonyun induul hinadan natuligonggong hinadan hukin nan Kahun ta pangiyattangan nadan mangdon. ");
INSERT INTO ifa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ya nunnanongonyuhdi ta adiyu aanon. ");
INSERT INTO ifa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ya iha\"adyuh nan Kahun nadan idat'un he\"a Moses an batun nitud'an nadan inabulutyun aton ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ya hay iyammayuh kalubna ya nan namahmah an balitu' an hay dinukkena ya napat ta limay (45) pulgada ya hay binillogna'e ya baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ya mingammut an miyammahdi nan duwan kerubim an hay miyamma ya nan balitu' an pandayonyu ");
INSERT INTO ifa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ta mipattuk hi numbinnongwah uhhun nan kalub nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","An nunhangngaban dadiyen kerubim mu iyuhdungdah nan kalub ya binitbityuy paya'da ta mahophopan nan uhhun nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ya niyamma'eh diyen Kahun ya inha''adyu nan duwan batun nitud'an nadan tugun'u ya kinalubanyu. ");
INSERT INTO ifa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ta hidih nan way numbattanan nan duwan kerubim di pi'hapita' i he''a ta ibaga' an namin nadan tugun'u ta ipa'innilam hinadan ibbam an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ya iyammayu bo ha akasya an lamehaan an hay dinukkena ya tuluy umpi. Ya hay binillogna'e ya ohay umpi ta han godwa ya hay tinagena'e bo ya duway umpi ta han godwa. ");
INSERT INTO ifa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ya inoddahanyuh namahmah an balitu' ya inalkusanyuh balitu' nan da'gingnah nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ya hina\"adanyu nan nundina'ging hi tuluy pulgaday binillog nan kayiw ya inalkusanyuh balitu' di nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ya inyammayuy opat di natuligonggong an balitu' ya inipongyun in'apyah nan way duggun nan lamehaan an awadan nan opat an hukina ");
INSERT INTO ifa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","hi da\"ul nan da'gingna ta iduulan nan pangiyattangan nadan mangdon. ");
INSERT INTO ifa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ya inyammayu bo ha duway kayiw an akasya ta pangiyattangan ya inoddahanyuh balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ya nangiyamma ayu boh balitu' an duyu ya basu ya malukung ya pannuman an ittuwan di ma'inum an midawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ya nan tinapay an midawat i ha\"on ya tigonyu ta nanongnan wadah nan lamehaan hidih nan pundayawanyun ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Pandayonyu bo nan namahmah an balitu' hi punhilawan. Ta ohan nangammut an balitu' nan mihipun hi pu\"una ya nan nigawwan ay adolna ya nan alkusnan umat hi habhabung ya nadan hapangna. ");
INSERT INTO ifa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ta onom nadan ay hapang te hintutluh numbinahhel. ");
INSERT INTO ifa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ya way ohah nan ay hapang ya na'alkusan hi tulun natuntunud an ay habung di almon. ");
INSERT INTO ifa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ya nan nigawwan ay adol nan punhilawan ya waday opat an natuntunud an ay habung di almon. ");
INSERT INTO ifa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ya hi da\"ul di ohan ay habung di almon ya waday ay nuwanin habung hinan nundammuwan di duwan ay hapang ta ingganah nan mi'atlun nundammuwan di duwan ay hapang. ");
INSERT INTO ifa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ta an namin nadan alkusnan ay habung ya nan tulun numpopotto'an an hapang ya oha nan nangammut an namahmah an balitu' hi pandayonyu. ");
INSERT INTO ifa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ya miyammay pitun hilawna ta matolganda'e ya madilagan nan akuyungna. ");
INSERT INTO ifa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ya hay iyammayuh pumputul hinan magbun mitsa ya nan pangi'amungan hi gubu ya nan namahmah an balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ta hay ngammut di ma'usal hinan punhilawan ya nadan udum an ma'usal ya umeh tulumpulut opat (34) di kilun namahmah an balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ot tigom ta an namin nadan iyammayu ya miyunnudan di a'atdah nan impatigo' i he''ah tun billid. ");
INSERT INTO ifa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Alyon bon Apu Dios di, Iyammayuy himpuluy (10) panid an luput ta hiyay mi'alad hinan nunlini\"odan nan lita\"angan nan tabernakel. Ya hay iyammayu ya nan linen an hinulid ya asul ya bayulet ya mumbolah an ipiyammayuh nan nala'ing an mumbolda di kerubim. ");
INSERT INTO ifa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ya mahapul an numpapaddungdan namin ta hay dinukken nan ohay panid ya napat (40) di umpi ya hay binillogda'e ya onom di umpi. ");
INSERT INTO ifa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ya nundada\"itonyuy hinlilimay panid. ");
INSERT INTO ifa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ya nangiphod ayuh nun'abali\"un luput an asul ya in'ugutyuh nan ohan da'ging nadan nadada\"it an limay panid an kultina. Ya athidi boy atonyuh nan da'ging nan mi'adwan nadada\"it an limay panid an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ta hay i'ugutyuh nan ohan da'ging nan nadada\"it an kultina ya nabonglen (50) nun'abali\"un luput mu tigonyu ta mumpopotto'andah nan mi'adwan nadada\"it an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ya nangiyamma ayu boh nabonglen (50) balitu' an ipit ta pundammuwonyu nan numpopotto'an an nun'abali\"un luput ta mangammut nan mikultinah nan nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ya nun'abol ayu boh himpulut ohay (11) panid hinan nalubid an dutdut di gulding ya inugutanyu ta mangammut an luput an miyoddah hinan mikultinah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ya mahapul an napapaddung di lukudda an hinnanapat ta limay (45) umpiy dinukkeda ya hin'o'onom di umpiy binillogda. ");
INSERT INTO ifa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ya nundada\"itonyuy limay panid ya ahiyu bo nundada\"iton di onom an panid. Ya nan mi'anom an panid ya hidiyey mipotto' hinan way panto ta makupin. ");
INSERT INTO ifa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ya in'ugutyu boy nabonglen (50) nun'abali\"uh an luput hinan ohan da'ging nan nundada\"it an limay panid. Ya athidi boy atonyuh nan da'ging nan mi'adwan nadada\"it an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ya inyammayuy nabonglen (50) gombang an ipit ta mangammut nan luput an miyoddah hinan kultinah nan nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ya nan godwan nan ohan luput ya mabyun hinan awidan. ");
INSERT INTO ifa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ya hay mabyun hi numbinahhel diyen tabernakel ya ohay umpi ta han godwa. ");
INSERT INTO ifa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ya inyammayu bo nan up'up di tangbal an kalnero an nakololan hi mumbolah ta miyoddah boh nan kultinah nunlini\"odan nan tabernakel. Ya inyammayu bo nan up'up di animal an malpuh nan baybay ta hidiyey muntu'yap an miyoddah hinadan kultinah nan nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ya nangiyamma ayuh nan kayiw an akasya ta mandol hinadan kultinah nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ya hay dinukken di ohan mandol hi kultina ya himpulut limay (15) umpi ya hay binillogna'e ya baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ya an namin nadan mandol hinadan kultina on waday duwan nidongdong hi pu\"una ta mabalin an mihu\"updah nan ipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ta hay iyammayuh mandol hinadan kultinah nangappit hi muyyadna ya bainti (20). ");
INSERT INTO ifa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ya inyammayu boy napat (40) an silber an ipabunan nadan hukin nadan mandol ta hindudwah nan ohan mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ya bainti (20) boy miyammah mandol hi nangappit hi huddo'na. ");
INSERT INTO ifa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ya napat (40) di silber an ipabunanda an hindudwah nan ohan mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ya hay nangappit hi alimuhan di algo ya onom di mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ya inyammayu boy hindudwan mandol hi kultinah nadan duwan duggun nan tabernakel hi nangappit hi alimuhan di algo. ");
INSERT INTO ifa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ya i dadiyen duwan mandol hi kultinah nan duggun nan tabernakel ya punda\"itonyuy mihipun hi pu\"una ta ingganah baktuna an mihu'lubdah nan nun'atuligonggong. ");
INSERT INTO ifa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ta walun namin di mandol hi kultinah nangappit hi alimuhan di algo an niddum nan duwah dugguna. Ya himpulut onom (16) di silber di ipabunanda te nan ohan mandol on duway ipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ya nangiyamma ayu boh tablan akasya ta miballabag di limah nan nunhuddo' an mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Ya lima boh nangappit hi muyyadna ya lima boh nangappit hi alimuhan di algo. ");
INSERT INTO ifa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ya hana'e an miballabag hi gawwan nadan mandol hi kultina ya minaynayun an mihipun hi pingngitna ta inggana boh nan pingngitna. ");
INSERT INTO ifa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ya inoddahanyuh balitu' an namin dadiyen mandol hi kultina ya nadan miballabag an kayiw. Ya nangiyamma ayu boh nun'atuligonggong an balitu' ta pangiduulanyuh nadan miballabag an kayiw. ");
INSERT INTO ifa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ot alyon bon Apu Dios i Moses di, Tigom ta nan iyammayun tabernakel ya miyunnudan di a'atnah nan nipatigon he\"ah tun billid. ");
INSERT INTO ifa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Mangiphod ayu boh nat'on an kultina an hay iyammayu ya nan napinun linen an hinulid ya asul ya bayulet ya mumbolah ya impiboldayuh nan nala'ing an mumbolda di kerubim. ");
INSERT INTO ifa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ya inhableyuh tuwen kultinah nadan niyamman punhablayan hinadan opat an akasyan tu\"ud an na'oddahan hi balitu'. Ya inyammayu boy opat di silber an ipabunan datuwen tu\"ud. ");
INSERT INTO ifa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ta nihable'eh tuwen kultinah dallom nan tabernakel ya ahiyu inha\"ad nan Kahun an nittuwan nadan tugun'u hinan kuwartun nahandiyan ituwen kultina. Ta nan kultina di mibattan hinan kuwartun niyappit i ha\"on ya nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ya ingkalubyuh nan Kahun nan mangipa'innilah a'aanan di bungot'un Dios an gapuh bahulyun tatagu. Ya hidiyen Kahun ya miha\"ad hinan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ya inha\"adyuh nan kuwartuh bahhelna nan lamehaan hidih nan huddo'na ya nan punhilawan hi nangappit hi muyyadna. ");
INSERT INTO ifa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ya ipiyammayu boh nadan nala'ing an mumbolda nan mikultinah nan panto hinan hinulid an napinun linen ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ya iniphodyu ha limah akasyan tu\"ud ya inoddahanyuh balitu' ya inha\"adanyuh balitu' an kawit di udduna ta pangihablayanyuh tun kultina. Ya inyammayuy lima an ipabunan datuwen tu\"ud an hay iyammayu ya nan gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Alyon bon Apu Dios i Moses di, Iyammayu bo ha punggobhan hi mi'nong an hay iyammayu ya nan kayiw an akasya. Ya pumpapaddungonyuy lukud nan opat an da'gingna an himpipituy umpi ta han godwa. Ya hay tinagena'e ya opat di umpi ta han godwa. ");
INSERT INTO ifa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ya hinan opat an dugguna ya iyammayuy ha'gud an mingammut hinan punggobhan hi mi'nong. Ta nalpah'e ya inoddahanyuh gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ya an namin nadan ma'usal hidi an umat hinadan punggaud hi gubu ya nadan malukung an iha\"adan di dala ya nadan tibi' di dotag ya nadan pangittuwan hi bala ya hay iyammayu ya nan gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ya inyammayu bo ha ay nalagan gombang ya hina\"adanyuh opat di gombang an nun'atuligonggong. ");
INSERT INTO ifa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ya inuhbungyuh dallom nan punggobhan hi mi'nong hidiyen ay nalagan gombang ta mipogpog hi gawwana. ");
INSERT INTO ifa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ya nangiyamma ayuh pangiyattangan an kayiw an akasya ya inoddahanyuh gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ya induulyuh nan nun'atuligonggong an gombang hinan numbinahhel nan punggobhan hi mi'nong hi'on iyattang nadan mangdon. ");
INSERT INTO ifa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ya hay dingding nan punggobhan hi mi'nong ya tabla mu mabaoy dallomna. Ya tigom ta miyunnudan di a'atnah nan nipatigon he\"ah tun billid. ");
INSERT INTO ifa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Alyon bon Apu Dios di, Iyammayu ha mi'alad an kultinah nan nunlini\"odan nan lita\"angan nan tabernakel. Ta hay nangappit hi muyyadna ya hinggahut ta nabongley (150) umpiy dinukken nan napinun linen an mihawan hidi. ");
INSERT INTO ifa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ya hay tu\"ud di mandol hi kultina ya bainti (20) an ipabunyuh baintin (20) gombang di niyamma. Ya hay iyammayuh baddong ya kawit ya nan silber. ");
INSERT INTO ifa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ya hay dinukken nan kultinah nangappit hi huddo'na ya numpaddung hinan kultinah nangappit hi muyyadna an hinggahut ta nabongley (150) umpi ya bainti (20) boy tu\"udna an ipabunyuh baintin (20) gombang. Ya hay iyammayu nimpeh kawit ya baddong ya nan silber. ");
INSERT INTO ifa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ya hay dinukken nan kultinah nangappit hi alimuhan di algo ya napitut limay (75) umpi. Ya hay mandol ya himpuluy (10) tu\"ud an himpuluy (10) nipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ya athidi bon napitut limay (75) umpiy dinukkenah nangappit hi tuluwan di algo. ");
INSERT INTO ifa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ya hinan way geyt ya mundinommang di kultina an hay dinukkena ya baintit duwa ta han godway (22 ½) umpi. Ta hi nangappit hi winawwan ya tuluy tu\"udna ya tulu boy niyamma hi ipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ya hi nangappit hi iniggid ya hay nikultina ya atbohdin baintit duwa ta han godway (22 ½) umpiy dinukkena. Ya tuluy tu\"udna ya tulu boy nipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ya iyammayu ha kultinan nan geyt hi tulumpuluy (30) umpiy dinukkena. Ya hay ipiyammayuh nan nala'ing an mumbolda ya nan napinun linen an hinulid ya asul ya bayulet ya mumbolah. Ya iyammayu ha opat an tu\"ud ya ha opat bo hi ipabunanda ta pangihablayanyuh nadan kultina. ");
INSERT INTO ifa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ya nan mibaddong hinadan tu\"ud ya nan kawit an ihablayan di kultina ya silber di miyamma mu nan ipabunan di tu\"ud ya gombang di miyamma. ");
INSERT INTO ifa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ya hay lukud nan lita\"angan nan tabernakel ya hinggahut ta nabongley (150) umpiy dinukkena ya napitut limay (75) umpi di binillogna. Ya hay tinagen nan napinun linen an kultinan mi'alad ya pitu ta han godway umpi. Ya hay iyammayu nimpeh ipabunan nadan tu\"udna ya nan gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ya an namin nadan udum an ma'usal hinan tabernakel ya nan nunlini\"odana an umat hi pahok ya hay iyammayu ya nan gombang. ");
INSERT INTO ifa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Alyon bon Apu Dios i Moses di, Ibagam hinadan ibbam an tinanud Israel ta mangiyalidah nan namahmah an lanan nalpuh nan tinoptopdan olibo ta ma'usal hinan punhilawan ta nanongnan dumanaldallang hi ahodohodom. ");
INSERT INTO ifa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ot da Aaron ya nadan linala'in imbabalena di muntolog hinan punhilawan hidih nan tabernakel hi hangngab nan kultinan nihawan hinan niha\"adan nan Kahun an nittuwan nan Hapit'un Dios. Ya tigonda ta nanongnan buminabinang nadan hilaw hinan mahdom ta ingganah nan mawi\"it. Ot hituwey ma'unud hi atonyuh inggana an ta'on on nadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Alyon bon Apu Dios i Moses di, Ibagam hinan ibam an hi Aaron ya nadan linala'in imbabalenan da Nadab ya hi Abihu ya hi Eleasar ya hi Itamar ta diday padin munhilbin ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ya numpa'iphod'ah lubung Aaron ta hiyay itigana an hiya ya niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ot ibagam hinadan indatta' hi la'ing an mangat i danae ta diday ukod an mangiphod hi lubung Aaron hitun pangiyappitam i hiya ta mibilang hi padin munhilbin ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ta hay iyammada ya nan ephod ya nan miyoddah hinan ephod hi palagpag nan padi ya nan adukken lubung ya nan mundallom an munggayyadan ya nan turban ya nan adukken miwakoh adolda. Ta iyammada datuwe ta ilubung nan ibam an hi Aaron ya nadan imbabalenan linala'i ta dida nimpey padi hi munhilbin ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ya hay iyammada ya nan napinun linen ya nan hinulid an balitu' ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Hay ipiyammayuh nan nala'ing an mumbolda hinan ephod ya nan hinulid an balitu' ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hituwen ephod ya duway panid an luput ta mibonog di oha ya mipalagpag di oha. Ya inha\"adanyuh pumpattitan nan mipu'ol ta pundammuwanda. ");
INSERT INTO ifa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ya nan balikisna ya mingammut hinan ephod ta numpaddung di tigoda an hay ipiyammayuh nan nala'ing an mumbolda ya nan napinun linen ya nan hinulid an balitu' ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ya imboldadahdiy duwah nan nabalol an batu an oniks ya intudo'yuhdi nadan ngadangadan nadan imbabalen Israel. ");
INSERT INTO ifa_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ta hinan ohan oniks on onom di ngadan hi mahohonnod an mihipun hinan namangulu ta ingganah nan udidiyan. ");
INSERT INTO ifa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ta nitudo'da'e nadan ngadan di imbabalen Israel ya impaklayuh balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ya ahiyu in'ugut hinadan mipu'ol nan ephod ta nanongnan mipapanomnom nadan imbabalen Israel. Ta an namin di pi'dammuwan Aaron i ha\"on on inlubungna nan ephod ta wan nanongnan adi' linglingon nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ot iyammayuy duwan balitu' an pangipaklaanyu i dadiyen duwan nun'abalol an batu ");
INSERT INTO ifa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ya ha duwa boh namahmah an balitu' hi ay na'apid ta hiyay puntayunyuh nan balitu' an nipaklaan nan nun'abalol an batu. ");
INSERT INTO ifa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Alyon bon Apu Dios i Moses di, Nan ipiyammam an miyoddah hinan ephod hi palagpag nan padi ya hidiyey panginnilaanah nan pohdo' an ma'at. Ya hay iyammada ya nan ibban nan niyammah ephod an napinun linen ya hinulid an balitu' ya asul ya bayulet ya mumbolah an iyamman di nala'ing an mumbolda. ");
INSERT INTO ifa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ya hay a'at na'en miyoddah hinan ephod hi palagpag nan padi ya ohay luput an nakupin an numpapaddung nan opat an da'gingna an hinhihiyam di pulgaday lukudda. ");
INSERT INTO ifa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ya ni'ugut hidiy opat di nalinlinyan nun'abalol an batu. Ya hinan mamangulun linya ya hay ni'ugut ya rubi ya topas ya beril ");
INSERT INTO ifa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ya hina'en mi'adwan linya ya torkois ya sapira ya emerald ");
INSERT INTO ifa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ya hina'en mi'atlun linya ya jasint ya agate ya ametis. ");
INSERT INTO ifa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ya hina'en mi'apat an linya ya hay ni'ugut ya nan krisolayt ya oniks ya jasper. Ta an namin danaen nun'abalol an batu ya ipaklayuh balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ya inipongyun intudo' i dadiyen himpulut duwan (12) batu di ngadan nadan himpulut duwan (12) tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ya inyammayu boy ay na'apid an namahmah an balitu' ta puntayunyuh nan miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ya inyammayuy duwan ay singsing hinan balitu' ya in'ugutyuh nan duwan numbaktun duggun naen miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ya intayunyu nan ay na'apid an namahmah an balitu' hinan duwan ay singsing. ");
INSERT INTO ifa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ya intayunyu nan bongwahna hinan oniks hinan ephod hinan mipu'ol. ");
INSERT INTO ifa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ya inyammayu boy duwan ay singsing an balitu' ya in'ugutyuh nan dallom nan duwan nunda\"ul an duggun diyen miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ya inyammayu boy duwan ay singsing an balitu' ya in'ugutyuh baktun nan balikis nan ephod. ");
INSERT INTO ifa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ya tinayunanyuh asul an hinulid nan numpotto'an nan duwan ay singsing hinan miyoddah hinan ephod hi palagpag nan padi hi way baktun di balikisna ta mihamad an midakop ta adi munlaplape. ");
INSERT INTO ifa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ta an namin di hunggopan Aaron hinan kuwartun niyappit i ha\"on ya nanongnan wahdi nan ngadan nadan himpulut duwan (12) imbabalen Israel an nitudo' di ngadanda hinan way puhuna ta nanongnan nomnomnomo' dida. ");
INSERT INTO ifa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ya wada bo nan Urim ya Tummim ta an namin di hunggopan Aaron hinan niyappit i ha\"on on inha\"adyu dadiyen Urim ya Tummim hinan miyoddah hinan ephod hi palagpagna ta nihaggon hi puhuna ta panginnilaanah nan pohdo' an mipa'innila i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Alyon bon Apu Dios di, Hay iyammayuh nan adukken lubung an iyoddahan nan ephod ya nan asul an luput. ");
INSERT INTO ifa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ya in'ugutyuh nan mibagang di na'abol ta adi mahethet. ");
INSERT INTO ifa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ya inyammayu boy ay bungan di pomegranet ya nun'i'ugutyuh nan migayadan ta ahitanattayunda. Ya hay iyammayu ya nan hinulid an asul ya bayulet ya mumbolah. Ya imbanattanyuy balitu' an kikkitang an batingting ");
INSERT INTO ifa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ta mili'woh nan gayadan. ");
INSERT INTO ifa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ya nanongnan ilubung Aaron hinaeh nan umayanah nan kuwartun niyappit i ha\"on ta madngol an ahigagangoh nadan kikkitang an batingting hinan hunggopana ya hinan lumah'unana ta adi mate. ");
INSERT INTO ifa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ya iyammayu bo hah nan namahmah an balitu' ya intudo'yuhdi di, Niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ya gina'odanyuh linubid an asul ya in'ugutyuh nan turban hi nangappit hi angah Aaron. ");
INSERT INTO ifa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ta wada'ey idawatyu i ha\"on ya hi Aaron di ukod an mangita'dog hi'on waday nibahhoh hinan inatyun nangi'nong ta mabalin an abuluto' an namin nadan idawatyun tinanud Israel i ha\"on. Ta hiya nan mahapul an nanongnan miha\"ad hidiyeh uluna. ");
INSERT INTO ifa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ya inabolyu bo nan miyammah nan munggayyadan an lubung Aaron ta nan napinun linen di ma'usal. Ya ta'on on nan turban ya nan napinun linen an luput di usalonyu. Ya impaboldayuh nan nala'ing an mumbolda nan adukken miwakoh adolna. ");
INSERT INTO ifa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ya inyammaanyu bo nadan linala'in imbabalenah lubungda ya pongotda ta mapmaphod di tigoda ya mabainanda. ");
INSERT INTO ifa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nagibbuh'en niyammadan namin danae ya impilubungmuh nan ibam an hi Aaron ya nadan imbabalenan linala'i. Ya impongmu didan hiniitan hi lanan di olibo ta miyappitdan ha\"on ta diday padin munhilbin ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ya numpa'amma'a boh mundallom an putut an pantalon an mihipun hi gitangda ta ingganah ulpuda. ");
INSERT INTO ifa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ta ilubungda ya ahida hunggop hinan pi'dammuwandan ha\"on ya ta'on on hinan way punggobhan hi insenso hinan kuwartun niyappit i ha\"on an Dios ta adi lummuh pumbahulanda ya atayanda. Ot hinaen tugun ya bokon dida ya ammunay iyatana te an namin nadan mahohonnod an tanudandah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Alyon bon Apu Dios i Moses di, Hay atom an mangidawat i Aaron ya nadan linala'in imbabalena ta miyappitda i ha\"on ta wan mibilangdah padin munhilbin ha\"on ya idadaanmu ha hiyah nahikon hi bulug an baka ya duwan tangbal an kalneroh ma''id ha bahbahda. ");
INSERT INTO ifa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ya numpaha''ang'ah tinapay an hay iyammada ya nan maphod an alinan di wit an adida ha\"adan hi yist. Ya nat'on bo nadan mun'a'ingpih an nadahidaan hi mantekan di olibo ya nadan tinapay an mamantekaan. ");
INSERT INTO ifa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ta nalutuda'e ya inha''admuh nan bahket ta iddumyuh nadan mi'nong an bulug an baka ya nadan duwan tangbal an kalnero. ");
INSERT INTO ifa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ya inyem da Aaron hinadan linala'in imbabalenah nan way panton nan tabernakel ya nun'amohom didahdi. ");
INSERT INTO ifa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ya impilubungmun Aaron nan munggayyadan an lubung ya nan adukken miyoddah ya nan ephod ya nan miyoddah nan ephod hi palagpag nan padi. Ya binalikisam hinan maphod di abolnan balikis an nihu\"up hinan ephod. ");
INSERT INTO ifa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ya inlipotmuh uluna nan turban an ipotto'muh way angahna nan ni'ugut hidi an balitu' an waday tudo'na an mangipa'innilah niyappit ta munhilbin ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ya inalam nan lana ya inhiitmuh uluna ta mibilang hi padi an munhilbin ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ya inawitmu bo nadan linala'in imbabalena ya impilubungmun dida nan adukken lubungda. ");
INSERT INTO ifa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ya impipongotmun dida nan pongot di padi ya impiwakohmu nan miwakoh adolda. Ya inyappitmu didan ha\"on ta dida ya nan tanudanda di mumbalin moh padi. ");
INSERT INTO ifa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ya inyem nan bulug an bakah nan way panton nan pi'dammuwanyun ha\"on ta iha'mon Aaron ya nadan imbabalenay ta'ledah uluna. ");
INSERT INTO ifa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ya pinaltim hidih nan way panton nan pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ya inalam dohah nan dalan diyen baka ya intamolmuy gamatmuh nan dalana ya inlamuhmuh nadan ha'gud hinan opat an duggun nan punggobhan hi mi'nong. Ya ingkuyagmu nan nabatihdih nan pu''una. ");
INSERT INTO ifa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ya inaanmun namin nadan tabah dallom nan putuna an umat hinan nili'mut hinan alte ya inaanmu bo nan duwan batin ya nan taban nili'mut i diye ya ginhobmun namin dadiyeh nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ya ginhobmu nan adolna ya nan up'upna ya an namin nan lugit an wah putunah nan bata\"an nan nun'allunganyu. Ta hinaey mi'nong an gapuh bahul. ");
INSERT INTO ifa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ya inalam boy ohah nan tangbal an kalnero ta iha'mon Aaron ya nadan imbabalenay ta'ledah uluna. ");
INSERT INTO ifa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ya pinaltim ya em nun'iwalaghi' di dalanah nan nunlini\"odan nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ya dinautmu ya inulaham nan putuna ya hukina ta nagogod'en namin nan adolna ya iniddummu nan uluna. ");
INSERT INTO ifa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ya ginhobmun namin hinan punggobhan hi mi'nong i ha\"on ta wan mipa'amlonga' hinan hunghungna. ");
INSERT INTO ifa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ya inalam bo nan mi'adwan tangbal an kalnero ta iha'mon bon da Aaron ya nadan imbabalenay ta'ledah uluna. ");
INSERT INTO ifa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ya pinaltim ya inalam dohah nan dalana ya em indanih hi winawwan an ingan Aaron ya nadan imbabalena. Ya inha\"adam nan winawwan an am'ama\"an di ta'leda ya hukida. Ya nun'iwalaghi'mu dohah nan dalah nan nunlini\"odan nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ya inalam dohah nan dalah nan punggobhan ya inudmam hinan lanan mihiit hi ulun nadan padi ya inwalaghi'mun Aaron ya hinan lubungna. Ya inatmu bohdi hinadan linala'in imbabalena ta wan hituwey mangipa'innilan niyappitda i ha\"on ya ta'on on nadan lubungda ya niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ya inaanmu i diyen napaltin kalnero nan taba an middum nan tabanah nan iwitna ya an namin nan tabah dallom nan putuna an umat hinan nili'mut hinan alte. Ya inaanmu bo nadan duwan batin ya nan tabana. Ya inaanmu bo nan winawwan an hukpitna. ");
INSERT INTO ifa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ya inalam nan bahket an niha\"adan di agge nadduman hi yist an tinapay ya inalam di hinohhah nadan tulun nat'onat'on an tinapay hidi. ");
INSERT INTO ifa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ya impadonmu i da Aaron ya nadan imbabalena danaen namin an taba ya tinapay ta itaggeda ta idawatdan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ya inalam hi ta'leda ya ginhobmuh nan punggobhan hi mi'nong ta mipa'amlonga' an Dios hinan hunghungna. ");
INSERT INTO ifa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ya inaanmu nan palagpag di kalnero ya intaggem ta midawat i ha\"on ya ahim mohpe inala ta pahingmu. ");
INSERT INTO ifa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ta nan palagpag ya nan hukpit nan tangbal an kalnero an nitagge ta midawat i ha\"on ya dadiyey midat i da Aaron ya nadan imbabalenah tun miyappitda i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ta danaey nanongnah midat i Aaron ya nadan linala'in imbabalenah nadan i'nong nadan tatagun tinanud Israel ta pi'hayyupandan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ya nan niyappit i ha\"on an lubung Aaron ya mipaboltan hinadan tanudana ta ilubungda ya ahi mihiit hi uluda nan lana ta miyappitdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ya nan imbabalenan mihukkat i hiyan mabalin an hunggop hinan kuwartun niyappit i ha\"on an Dios ya mahapul an ilubungnah nae hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ya na'e an dotag nan tangbal an kalnero an mapalti i diyen iyappitandan munhilbi i ha\"on ya eyu iha\"ang hinan niyappit i ha\"on an pangiha\"anganyu. ");
INSERT INTO ifa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ta nalutu'e ya e inan da Aaron hinan way panton nan tabernakel nan tinapay an agge nadduman hi yist ya inihdada nan dotag. ");
INSERT INTO ifa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Te danaen dotag ya tinapay ya nidawat hi napakawanan di bahulda i diyen niyappitdan ha\"on. Ta dida ya abuh di mabalin an mangan i danaen nidawat te mapaniyo. ");
INSERT INTO ifa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ya hi'on waday mabatih nan mawi\"it ya mahapul an gobhonyu te adi mo mabalin hi makan te mapaniyo. ");
INSERT INTO ifa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ot mahapul an hituwey atonyu ta unudonyun namin tun ibaga' ta pituy algo di pangiyappitanyu i Aaron ya nadan linala'in imbabalena. ");
INSERT INTO ifa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ya binigat on ini'nongyu ha ohah bulug an baka an pa'ahikkona ta mi'nong hi apakawanan di bahulda. Ya hiniitanyuh lana nan punggobhan hi mi'nong ta mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ot abigabigat hinan pituy algo ya atonyuh nae ta mibilang nimpeh malinis nan punggobhan hi mi'nong ya ahi mibilang hi niyappit i ha\"on ta an namin nadan mi'nong hidi ya niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hay i'nongyuh abigabigat hinan punggobhan hi mi'nong ya duway kalnero an ohay tawonda. ");
INSERT INTO ifa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ta i'nongyuh nan mawi\"it di oha ya hinan mun'ahdom di oha. ");
INSERT INTO ifa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ya hay mitakkop hinan maghob an mi'nong hinan mawi\"it ya ha hingkiluh napinun alinan nadduman hi ohay litro an lana an nalpuh nan tinoptopdan olibo. Ya wada bo ha ohay litro hi bayah ta midawat hi ma'inum. ");
INSERT INTO ifa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ya athidi boh nan mi'nong hinan mun'ahdom an numpaddung nan alina ya nan bayah an midawat an ma'inum. Ta danaey maghob an mi'nong i ha''on ta mipa'amlonga' hinan hunghungda. ");
INSERT INTO ifa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ta hinaen maghob an mi'nong hi abigabigat hi way panton nan pi'dammuwanyun ha\"on ya inaynayunyun aton hi inggana te hidiy humapita' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ya hidi boh nan panton nan pi'dammuwanyun ha\"on di humapita' i da'yun tinanud Israel ya hidi boy pi'dammuwa' i he\"a. Ta gapuh nan mumbinang an a'at'un ma'attigohdi ya miyappit hidiyen ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Athinay ato' an pumbalino' hi niyappit i ha\"on nan pi'dammuwanyu i ha\"on ya nan punggobhan hi mi'nong ya hi Aaron ya nadan linala'in imbabalena ta mumbalindah padi hi munhilbi i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ta way ato' an mi'hitu i da'yun tinanud Israel ta ha\"on di dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ya ta innilaonyun ha''on hi Apu Dios an nangikak i da'yuh ad Egypt ta way ato' an middum i da'yu. Ha\"on nan Ap'apu an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Alyon bon Apu Dios i Moses di, Iyammayu ha punggobhan hi insenso an hay iyammayu ya nan kayiw an akasya. ");
INSERT INTO ifa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ya hay lukud nan opat an nundina'ging ya mumpapaddung an hin'o'ohay umpi ta han godwa ya hay tinagena'e ya tuluy umpi. Ya hinan opat an dugguna ya iphodyuy ha'gud mu ta mingammut hidi. ");
INSERT INTO ifa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ya inoddahanyuh namahmah an balitu' nan uhhuna ya an namin nan muntigoh nunlini\"odan ya nan opat an ha'gud. Ya inalkusanyuh balitu' nan nundina'ging hi da\"ul nan uhhuna. ");
INSERT INTO ifa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ya inyammayuy opat di natuligonggong an balitu' ya in'apyayu dadiye hi da\"ul nan inalkusanyuh balitu' ta hindudwah nan numbinahhel. Ta hidiy pangiduulanyuh nan pangiyattanganda. ");
INSERT INTO ifa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Hay iyammayuh pangiyattangan ya nan kayiw an akasya ya inoddahanyuh balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ya eyu inha\"ad nan punggobhan hi insenso hi haggon nan kultinan nihawan hinan kuwartu' an Dios an awadan nan Kahun an nittuwan nan Hapit'un Dios ya nan kalubnan ma'alih a'aanan di bungot'un Dios an gapuh bahulyun tatagu' ya hidiy pi'dammuwa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ya ibagam i Aaron ta amawimawi''it ya e munggohob hi insenso i diyen niyamman punggobhan hi insenso ya hiya boy ukod hinadan hilaw. ");
INSERT INTO ifa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ya hinan mun'akpa an ena puntologan hinadan hilaw ya athidi bon munggohob hi insenso. Ot hituwen atonyu ya mahapul an hiyay minaynayun hi aton nadan tanudanyu. ");
INSERT INTO ifa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ot padana' ta ma\"id ha udum hi insenso hi gobhonyuhdi onu nadan maghob an mi'nong onu nadan midawat an makan ya adiyu iduyag hidi nadan idawatyun bayah. ");
INSERT INTO ifa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ya hinan hintawon ya maminghan di pangatan Aaron hinan atona ta mibilang hi malinis nan punggobhan hi insenso. Ta alana dohah nan dalan di mi'nong hi apakawanan di bahul nadan tatagu ya ena inha''ad hinan opat an ha'gud nan punggobhan hi insenso. Ot hituwe ya mahapul bon aton nadan matanudan hi inggana. Te hituwen punggobhan hi insenso ya niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Hitun pumbilanganyuh nadan ibbayun tinanud Israel ya mahapul an bayadanday nitaguwanda i ha\"on an Dios hi'on nabilangda. Mahapul an atondahtu ta wan midawwidah dogoh hinan pumbilanganyun dida. ");
INSERT INTO ifa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ya hay ibayad di ohan tagu ya ha godwan di ohan sekel an miyunnudan hinan balolna hinan sekel an na'usal hinan tabernakel. Ya hidiyen idatda ya midawatda i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ot mihipun hinan baintiy (20) tawona ta mahuluk ya waday idawatda i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ya ta'on hi kadangyan nan tagu ya nan idawatna i ha\"on an Dios ya numpaddung hinan ibayad di nawotwot ta punhandidah nitaguwanda. ");
INSERT INTO ifa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ot nan ma'amung an pihhu ya alam ta ma'usal hinan tabernakel. Ta mangipapanomnom i ha\"on hinadan tinanud Israel ta nanongnan ipappapto' da'yu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Ipiyammam ha ongal hi besin an gombang ta pun'ulahan ya ha ipattukanah gombang bo damdama. Ya inha\"admuh nan numbattanan nan tabernakel ya nan punggobhan hi mi'nong ya inittuwam hi liting. ");
INSERT INTO ifa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ta hidiy pun'ulahan da Aaron ya nadan linala'in imbabalenah ta'leda ya hukida ");
INSERT INTO ifa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ya ahida hunggop hinan pundayawan ta adida mate. Ya ta'on on hinan waha maghob hi i'nongdah nan punggobhan hi mi'nong ya ");
INSERT INTO ifa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","mun'ulahdah ta'leda ya hukida ta adida nimpe mate. Ot hituwey aton da Aaron ya nadan matanudandah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Mangala'ah onom di kiluh namahmah an mira ya hintutluy kiluh nan sinamon ya nan malumiih an danum di unah ");
INSERT INTO ifa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ya onom di kiluh nan kasia ya ohay galon an lanan di olibo. ");
INSERT INTO ifa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ya nun'u'uddumom an namin ta mumbalin hi lanan niyappit i ha\"on an maphod di hunghungna an usalon di padi an umat hi inyamman di nala'ing an mangiyammah maphod di hunghungnan lana. ");
INSERT INTO ifa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ta hinaen lana di em idahidah nan tabernakel ya nan Kahun an nittuwan nadan Hapit'u ");
INSERT INTO ifa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ya nan lamehaan ya nadan dakol an ma'usal hidi ya nan punhilawan ya nadan ma'usal hidi ya nan punggobhan hi insenso. ");
INSERT INTO ifa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ya indahidam boh nan punggobhan hi mi'nong ya nadan ma'usal hidi ya nan besin ya nan nipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Atom ta miyappit datuwen ha\"on ta ta'on on nan mida\"om i datuwe ya mibilangdah niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ya hidiyen lana di ihiitmuh ulun Aaron ya nadan imbabalenan linala'i ta mumbalindah padin munhilbin ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ya ibagam hinadan tatagu an hidiyen lana ya ha\"on ya abuh di niyappitanah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ot adiyu iduyag hi adol di kumpulnan tagu ya adiyu ipatnan mangiphod hi umat i naen lana ta usalonyu. Te hinae ya niyappit i ha\"on ot hanat hay pangiyusalanyu ya hinan imbaga' an pangiyusalanyu. ");
INSERT INTO ifa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ot nan tagun mangiphod hi umat i naen lana ya mipapate ta adi mo midmiddum i da'yun tatagu'. Ya atbohdiy ato' hinan tagun mangihiit i naen lana hi kumpulnan tagun ta'on on bokon padi an mipapate ta adi mo midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ya imbagan bon Apu Dios i Moses di atonan mangiphod hi insenso an alyonay, Mangala'ah nan mapmaphod di hunghungda an umat hi resin ya onika ya galbanum ya nan namahmah an frankinsens. Tigom ta numpapaddung di dinakolda. ");
INSERT INTO ifa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ya inyammam ha mapmaphod di hunghungnan insenso ta umat hinan aton di nala'ing an mangiyammah maphod di hunghungnan lana. Ya inahinam ta namahmah di a'atna ya adi kumpulnay iyatana. ");
INSERT INTO ifa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ya ginilingyu doha ta ay apul ya em inha\"ad hinan way Kahun an nittuwan nan Hapit'un Dios an hidi nan pi'dammuwa' i he\"a. Ot hituwen insenso ya mahapul an ibilangyuh niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ya adi namaaggon nun'amma ayuh athitu ta usalonyu te ha\"on an Dios ya abuh di mangibagah iyusalana. ");
INSERT INTO ifa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ot nan tagun mangiphod ituwen insenso ta usalona ya mipapate ta adi mo midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Hi Besalel an imbabalen Uri an imbabalen Hur an tinanud Judah ya hiyay pinto\"u ");
INSERT INTO ifa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ot pabikaho' nan Espiritu' i hiya ta nala'ing an ongal di abalinanan mangat hinadan mapmaphod di tigona. ");
INSERT INTO ifa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ta mabalin an iyammana nan balitu' ya silber ya gombang hi mapmaphod di tigona. ");
INSERT INTO ifa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ya ta'on on nadan nun'abalol an batu ya nadan kayiw ya nadan udum ya abalinanan iyamma i ha mapmaphod di tigona. ");
INSERT INTO ifa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ya hi Oholiab an imbabalen Ahisamak an tinanud Dan di pinto\"uh bumoddang i hiya. Ya an namin nadan nala'ing hi nat'onat'on an tamu an umat hi mumpa'ot ya munlutuh balitu' ya udma' di la'ingda ta abalinandan iyamman namin nan ibaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ta iyammada nan tabernakel ya nan Kahun an ittuwan nan Hapit'un Dios ya nan kalubna ya an namin nadan mahapul an umat ");
INSERT INTO ifa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","hinan lamehaan ya nadan ma'usal hidi. Ya iyammada bo nan punhilawan ta nan namahmah an balitu' di miyamma ya ta'on on nadan udum an mahapul hidi ya nan punggobhan hi insenso. ");
INSERT INTO ifa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ya iyammada bo nan punggobhan hi mi'nong ya nadan udum an mahapul hidi an umat hinan besin ya nan ipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ya inabolda nadan miyammah lubung nadan padin da Aaron ya nadan imbabalenan linala'i an munhilbin ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ya iniphodda bo nan lanan mihiit hinan miyappit i ha\"on an Dios ya nan insenson maphod di hunghungna an ma'usal hinan kuwartun niyappit i ha\"on an Dios. An namin datuwen ipiyamma' i da'yu ya mahapul an miyunnudan di a'atda hinan imbaga' i he''a. ");
INSERT INTO ifa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Ibagam hinadan ibbam an tinanud Israel ta ngilinonda nan Habadun tungo. Ta hiyay mangipa'innilan dida ya hinadan tanudandah inggana an niyappitdan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ot mahapul nimpen ngilinonyu nan Habadun tungo te niyappit i ha\"on. Ot nan tagun mangibahho ta e muntamu i diyen algo ya mipapate ta adi mo midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Te hinan hindumingguwan ya onom di algoy puntamuwanyu mu nan mi'apituh algo ya tungon pun'iblayanyu te ibilang'uh diyen algo hi niyappit i ha\"on. Ot nan tagun muntamu i diyen algo ya mipapate nimpe. ");
INSERT INTO ifa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ot an namin ayun tinanud Israel ya ta'on on nadan matanudan hi inggana ya mahapul an inaynayundan ngilinon nan Habadun tungo hi inggana. ");
INSERT INTO ifa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ta hiyay nanongnah pangimatunan hinan inyuldin'un didah inggana. Te ha\"on an Dios ya onom di algoy nuntamuwa' hi nunlumuwa' hitun luta ya ad abunyan. Mu nan mi'apituh algo ya nun'ibleya'. ");
INSERT INTO ifa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ya hidin nalpah an ni'ihapit hi Apu Dios i Moses hinan billid hi ad Sinai ot idatna nan duwan nadampillag an batu an nangitudo'anah nan uldina. ");
INSERT INTO ifa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Hidin madne on ma''id ha mumbangngad i Moses an immeh nan billid ya na'amungda nadan tatagu hi awadan Aaron. Ot alyondan hiyay, Ma''id ha mapto' ya waday na'at i Moses an e nangkak i dita'uh ad Egypt. Iphodmuwot ha mangipangpangulun dita'u. ");
INSERT INTO ifa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ya alyon Aaron i diday, Iyaliyu mo nadan balitu' an hingat nadan ahawayu ya imbabaleyu. ");
INSERT INTO ifa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ot pun'aan mon nadan tatagu nan balitu' an hingatda ot iyeda i Aaron. ");
INSERT INTO ifa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ta na'amung ot iyamman Aaron han ay kilaw an baka. Ya alyon nadan tataguy, Hiyah nae nan dios an dayawon ta'u an nangikak i dita'un tinanud Israel hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ot apyon bon Aaron han pun'onngandah way akuyung nan balitu' an kilaw an baka. Ot pun'iwalagawagnah nadan tatagun alyonay, Hi bigat ya ma'amung ta'u ta dayawon ta'uh Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ta hidin hiyah mun'abigat ot pun'iyeday eda idawat an maghob an mi'nong ya nadan mi'nong hi pi'hayyupan. Ta hidin nalpah nadan ini'nongda ot manganda mohpe nadan tatagu on immanin'innumda ta inggana ot mun'abubutongda ta nan umipabain an pumbahulan di in'innatda. ");
INSERT INTO ifa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ot alyon Apu Dios i Moses di, Mi'ibaga'an dumayyu ta em tigon nadan tatagum an inilpum hi ad Egypt an nan pumbahulan di at'attonda. ");
INSERT INTO ifa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Te na'ibagondan indinong an mangun'unud hinadan imbaga' i da'yu hi atonyu. Ta iniphodda han balitu' an kilaw an baka ot hidiyey dayawonda ot mangi'nongda bo udot i diye. Te alyonday hidiye anu nan dios an dayawondan nangikak i didah ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ot alyon bon Apu Dios i Moses di, Innila' di a'at dadiyen tatagu an nunhigla tuwaliy ngoheda. ");
INSERT INTO ifa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ot hiya nan adiya' padinongon ta ipahda' di bungot'un dida ta dadago' didan namin. Ta he''a mo ya abuh di padakolo' di holagna ta mundongol ayun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mu numpahpahmo' hi Moses i hiyan alyonay, Apu Dios, hanat adi'a bahan bumungot hinadan tatagum an em inawit hi ad Egypt an gapuh nan ongal an abalinam. ");
INSERT INTO ifa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Te onha atom hinaen inalim ot namaag ya alyon nan i Egypt di onmu impangulu nadan tatagum hitun agge naboblayan ta wan patayom dida ta matedan namin. Ot hiya nan linglingom bahan hinaen bimmoholam ta adim aton nan ninomnommuh atom i dida. ");
INSERT INTO ifa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nomnomnomom ahan handidan baalmun da Abraham ya hi Isaac ya hi Israel ya nan hinapitmu i dida. Te hay inalim ya idatmuy dakkodakkol an tinanudda ta umat hi dinakol di bittuwon hi ad lagud ot ibagam an idatmun dida nan boblen alyom hi pumboblayandah inggana. ");
INSERT INTO ifa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ta gapu i diyen numpahpahmo'an Moses ya agge inat Apu Dios nan ninomnomnan panadaganah nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ot dumayyu moh Moses hinan billid an indonana nan duwan nadampillag an batun natud'an di numbinahhel hinan tugun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Dadiyen batu ya hi Apu Dios di nangiphod ya hiya boy nangitudo' hidih nadan tuguna. ");
INSERT INTO ifa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ya hidin mundayyu da Moses i Joshua ya dingngol Joshua an ahi'i'ingal nadan tatagu ot alyonan Moses di, Umman ay waha munggugubat hinan nun'allungan ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ya alyon Moses di, Onha athidi ot wan bokon e hay nangabakanday pun'itkukda ya hay na'abakanda. Mu bokon te madngol an mungkantada. ");
INSERT INTO ifa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ya hidin mun'idatongdah nan way nun'allunganda ta tinigon Moses nan balitu' an kilaw an baka ya nan ahitatayon tatagu ya nangimbubbungot. Ot ipuhitna nan duwan nadampillag an batu an inodnana ot magudu. ");
INSERT INTO ifa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ot ume ot ena alan nan iniphoddan balitu' an kilaw an baka ot pu'ulana ot ahina guduguduwon ta numbalin hi ay dapul. Ot iddumnah nan liting ot ipa'inumna i dadiyen tatagun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ot alyon Moses i Aaron di, Undan nganney inat nadan tatagu i he''a ta em inyabulut hinaen nunhiglan eda numbahulan? ");
INSERT INTO ifa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ya alyon Aaron di, Adi'a bumungot i ha''on te innilam di a'at datuwen tatagu an nan pumbahulan di amod onda aton. ");
INSERT INTO ifa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Te immalidan ha''on ot alyonday, Ma''id ha mapto' hi na'at i he\"a an nangikak i da'mi hi ad Egypt ot alyonday onmuwot iyamma ha mangipangpangulun da'mi. ");
INSERT INTO ifa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ot ibaga' mon dida ta amungonda nadan balitu' an inusalda ot ibkah'uh nan apuy ta nawadah naen balitu' an baka. ");
INSERT INTO ifa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ya na'innilaan Moses an inyabulut Aaron an aton nadan tataguy kumpulnan ta'on on umipabain ta lummuh pungngohayan nadan udum an tatagun dida. ");
INSERT INTO ifa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ta immeh Moses hinan way geyt diyen nun'allunganda ot pun'itkuknan alyonay, Da'yun naminhod an hi Apu Dios di dayawona ya immali ayuh tun awada'. Ya immedan namin nadan linala'in tinanud Libay hi awadana. ");
INSERT INTO ifa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ot alyon Moses i diday, Hay inalin Apu Dios hi unudon ta'un tinanud Israel ya alyonay, An namin ayun linala'i ya ihikotyuy hinalungyu ya eyu numpate nadan ibbayu ya gayyumyu ya hinaggonyun wahtun nun'allungan ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ot aton dadiyen tinanud Libay hidiyen imbagan Moses i dida. Ya hay bilang di pinateda i diyen algo ya tuluy libun (3,000) linala'i. ");
INSERT INTO ifa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ot alyon Moses i didan tinanud Libay di, Ad uwanin algoy nangidawatanyuh nitaguwanyun Apu Dios an munhilbin hiya te inatyu nan inalina an hay namatayanyuh nan numbahul an ta'on onyu i'iba ya imbabale dida. Ot gapuh nangunudanyun Apu Dios ya wagahan da'yu i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Hidin nabiggat ya alyon Moses hinadan tataguy, Hinaen inatyu ya nunhiglan pumbahulan i Apu Dios. Ot ad uwani ya mumbangngada' hinan billid an awadan Apu Dios ta eya' mumpahpahmo' ta alina ya mabalin an linglingonah naen eyu numbahulan. ");
INSERT INTO ifa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ot tumikid mo boh Moses. Ta hidin immablat ot mi'ihapit i Apu Dios an alyonay, Apu Dios, nunhiglay numbahulan nadan tatagu te iniphodda nan balitu' i han baka ta hiyay dinayawda. ");
INSERT INTO ifa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ot hanat linglingom bahan hidiyen numbahulanda. Mu adim'e ya ta'on attog ya inaanmuy ngadan'uh nan liblun nangitud'am hi ngadan nadan imbabalem. ");
INSERT INTO ifa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ya alyon Apu Dios i hiyay, Nan tagun numbahul i ha''on ya hiyay aano' di ngadanah nan liblu'. ");
INSERT INTO ifa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ot ume'aot ta ipangulum didah nan boblen imbaga' i he''a. Ya nomnomnomom an nan anghel'u di ukod an mangipangulu i he''a. Mu ibaga' an adi madne ya dusao' didah nan numbahulanda. ");
INSERT INTO ifa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ya indani peman ya wada han dogoh an impadatong Apu Dios hinadan tatagu an gapuh nan inatdah nan inyamman Aaron an balitu' an kilaw an baka. ");
INSERT INTO ifa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Alyon bon Apu Dios i Moses di, Makak ayu mohtu an da'yuh nadan ibbam an inikakmuh ad Egypt ta ume ayuh nan boblen imbaga' hidin a'ammodyun da Abraham ya hi Isaac ya hi Jacob an idat'uh nadan tanudanda. ");
INSERT INTO ifa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ot pa'aliyo' han anghel ta ipangulu da'yu ya impa'aana i diyen boble nadan tinanud Kanaan ya tinanud Amor ya tinanud Hit ya tinanud Peris ya tinanud Hib ya tinanud Jebus. ");
INSERT INTO ifa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Te hidiyen boblen umayanyu ya malumong ya makadangyan. Mu adiya' mi'yalin da'yu te mi'yaliya\"e ya alinah on da'yu nundadag hinan awon an gapuh nan nunhiglan ngoheyu. ");
INSERT INTO ifa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ya hidin dingngol nadan tataguh diye ya umukayunganda ta ma\"id ha numpun'alkus hi adolda. ");
INSERT INTO ifa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Te alyon Apu Dios i Moses di, Ibagam hinadan ibbam an tinanud Israel an dida ya nunhiglay ngoheda. Ot alinah on pininghan'un dinadag dida. Ot ibagam ta pun'aanda nadan nun'i'alkusda adol ta ahi' nomnomnomon on nganney ato' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ya hay nun'allungan nadan tinanud Israel i diye ya hinan way billid hi ad Horeb an nun'aanda nadan in'alkusdah adolda an umat hi hingat ya nadan udum. ");
INSERT INTO ifa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Hi Moses ya wa'e ta immohnongda on e nuntolda i ha pi'dammuwanda i Apu Dios hinan bata\"an di pun'allunganda. Ta nan waday pohdonan ibagan Apu Dios ya hidiy pangipluyana. ");
INSERT INTO ifa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ya an namin di umayan Moses i diyen natoldaan ya way ohah nadan tatagu ya lumah'undah nan allungda ta umohnongdah nan way panto ta mangmangondah hunggopan Moses. ");
INSERT INTO ifa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ya an namin di hunggopan Moses i diyen natoldaan ta mi'hapit i Apu Dios ya mungkohop nan bugut hinan way panto. ");
INSERT INTO ifa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ya tinigon'en nadan tatagu nan bugut an nungkohop on nunnanongdan timma'dog hidih nan way panton di allungda ta dayawondah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ta hi Apu Dios ya mi'hangngaban an mi'hapit i Moses an umat hinan aton nan nunggayyum an munhappitan. Ta nalpah'e on ahi umanamut hi Moses mu nan mangilog an bumodboddang i hiyan hi Joshua an imbabalen Nun ya adina taynan nan natoldaan. ");
INSERT INTO ifa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Inalin Moses i Apu Dios di, Imbagabagam i ha\"on ta ipangulu' datuwen tatagu mu tanganu onmu agge impa'innilah on nganney pinto'muh pun'ibba'. Ya imbagam bon ha\"on an innilam di ngadan'u ya alyom boy umipa'amlonga' i he\"a. ");
INSERT INTO ifa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ot athina'en umipa'amlonga' i he\"a ya daan mo ta ipa'innilam nan pohdom hi ma'at ta hiyay unudo' ta nanongnan umipa'amlonga' i he\"a. Ya nomnomnomom ot bahan an da'mi nan pinto'muh tatagum. ");
INSERT INTO ifa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ya alyon Apu Dios di, Ha\"on ya mi'yaliya' i he\"a ta way atom an madinol hinan umayanyu. ");
INSERT INTO ifa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ot alyon Moses di, Maphod ta athina Apu Dios te onha adi'a mi'yalin da'mi ot udulnay adi da'mi attog pakakon hitu. ");
INSERT INTO ifa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Te nan pi'yaliyam i da'mi ya hiyay panginnilaan nadan udum an tatagu an umipa'amlonga' i he\"a ya tun ibba' an tatagum. Te onha ma\"id'an da'mi ot ma\"id ha nipahhiwanmih nadan udum an tataguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ot alyon Apu Dios di, Manu'eh ato' nan imbagam ya gapu ta umipa'amlong'a i ha\"on ya innila' di a'atmu. ");
INSERT INTO ifa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ot alyon Moses di, Ot athina'e ya hanat ipatigom i ha\"'on nan mumbinang an amaphodmu. ");
INSERT INTO ifa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ya alyon Apu Dios di, O, ipatigo' i he\"an namin nadan amaphod'u ya atbohdin ipa'innila' nan ngadan'u an Ap'apu. Te ha\"on ya mabalin an ipatigo' di ule' ya homo\"uh nan tagun pohdo' an pangipatigan. ");
INSERT INTO ifa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mu adim tigon di angah'u te ma''id ha taguh tigonay angah'u ya nanongnan matagu. ");
INSERT INTO ifa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ot inayun Apu Dios an alyon di, Mihnup'ah tun awada' ta wahtu han doplah an mabalin an umohnongam. ");
INSERT INTO ifa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta handiyan da'ah nan lingab i diyen numpingayan di doplah ya hinawanan da'ah ta'le' ta ingganah mipatigoy binang'uh ala\"uha'. ");
INSERT INTO ifa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ta nundu'uga\"e ya ahi' aanon di ta'le' ta mabalin an tigom di bonog'u mu adi mabalin hi tigom di angah'u. ");
INSERT INTO ifa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Alyon bon Apu Dios i Moses di, Iphodmu ha umat hidin duwan nadampillag an batu an pina''ihmu ta itudo''u bohdi nadan intudo\"uh nan namangulun batu. ");
INSERT INTO ifa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ya nundadaan'ah bigat hi mawi\"it ta tumikid'ah tun billid hi ad Sinai ta mi'dammu'an ha''on hidih uhhuna. ");
INSERT INTO ifa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mu gahin di oha'a an umali ya abuh. Ya ibagam hinadan tatagu ta ma''id ha e munwanwannatan hinan billid an ta'on on nadan baka onu kalnero ya adida e mangan hi holo' hidi. ");
INSERT INTO ifa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ot iphod Moses di duwan nadampillag an batu an umat hidin namangulu. Ta hidin hiyah mun'abigat ot tumikid hinan billid hi ad Sinai an inodnana nadan duwan batu an inunudna nan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Hidin immehdi ya nungkohop boh Apu Dios hinan bugut ot ipa'innilana nan ngadanan Ap'apu. ");
INSERT INTO ifa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ot munla''uh hi hinangngab Moses an alyonay, Ha''on nan Dios an ma'a'ulle ya ongal di homo'na. Ya ha\"on an Dios ya adi hi kittang on bimmungota'. Ya adi maluman di pamhod'u ya adi' ibahhon aton nadan ibaga'. ");
INSERT INTO ifa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Te nanongnay pamhod'uh linibu ya pakawano' di tataguh nan adi maphod an pangatda ya an namin an pumbahulanda. Mu adi mibahhoy pundusaa' hinadan numbahul an ingganah nan pidwan di apapuda. ");
INSERT INTO ifa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ot ma'ibagan munlu'bub hi Moses ot dayawona hiya. ");
INSERT INTO ifa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ot alyonay, Apu Dios, umipa'amlonga\"e i he\"a ya daan mo bahan ta ipangpangulu da'mi. Manu te immannung an naligat hi e umunudan nadan tatagu mu undan adi mabalin hi linglingom nadan numbahulanmi ya nadan adi maphod an pangatmi ta nanongnan ibilang da'mih tatagum. ");
INSERT INTO ifa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Alyon Apu Dios i Moses di, Ad uwani ya ibaga' an waday ato' hinadan tinanud Israel. Te dakol di ato' an mangipatigon didah nan abalina' an nakaskasda'aw. Ya datuwen ato' ya ma''id ni' ha na'atanah udum hi bobleh tun luta. Ta an namin di tagu ya innilaonda datuwen nakaskasda'aw an ato' an mamoddang i da'yu. ");
INSERT INTO ifa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mu gahin di unudonyu nadan ibaga' i da'yuh ad uwani tee. Ta hitun umayanyu ya ha''on di ukod an mangipa'aan hinadan tataguh nan awonyu an tinanud Kanaan an umat hinadan tinanud Amor ya tinanud Hit ya tinanud Peris ya tinanud Hib ya tinanud Jebus. ");
INSERT INTO ifa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ya tigonyu ta adi ayu mihapitan hi ibagan nadan tatagun nunhitu i dadiyen boble. Te atonyu'e ya hidiyey ayyu ahablutan. ");
INSERT INTO ifa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mu haot di atonyu ya pumpa''ihyun namin nadan pundayawandan umat hinadan inha\"addan batu ya numputulyu nadan pustin mangita'dog i Aserah. ");
INSERT INTO ifa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ya adiyu ipatnan e mundayaw hinadan dios an dayawonda. Te ha''on an Dios ya adi' pohdon an waday udum hi eyu dayawon an bokon ha\"on ya abuh. ");
INSERT INTO ifa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ot tigonyu nimpe ta adi ayu mihapitan hi alyon nadan numboblehdi. Te dida ya nat'onat'on di dayawonda ya onnganda. Ya ayagan da'yu'en dida ta middum ayuh nan at'atonda ya lo'tat ya mabaliyan ayu ya ni''an ayuh nadan i'nongda. ");
INSERT INTO ifa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ya hi'on pi'yahawaonyu nadan linala'in imbabaleyuh nadan binabain imbabaleda ya ipanguluda nadan linala'in imbabaleyuh nadan dayawonda ta du'gona'. ");
INSERT INTO ifa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ya alyon bon Apu Dios di, Adi ayu mangiyammah binulubbulul ta hiyay dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ya inaynayunyun ngilinon nan pangananyuh nan tinapay an agge nadduman hi yist. Ta nadatngan'e nan bulan di Abib an hidiye din nakakanyuh ad Egypt ya inunudyu nan imbaga' ta adi ayu mangan hi tinapay an nadduman hi yist hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ya idawatyun ha\"on nadan panguluwan an linala'in imbabaleyu ya ta'on on nadan hopap di tangbal an imbabalen di animalyun umat hi baka onu kalnero. ");
INSERT INTO ifa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ta nan hopap di tangbal an imbabalen di dongki ya mabalin an hukkatanyu i ha imbabalen di kalnero ta hiyay i'nongyun ha\"on an Dios. Mu adiyu'e pohdon an hukkatan ya mahapul an putungonyuy bagangna ta mate. Ya na'en panguluwan an lala'in imbabaleyu nimpe ya mahapul an waha pamangngadyun hiya. Ya mahapul an way ohaon indadaana tuwali nan idawatnan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ya mahapul an hinan mi'apituh algo ya mun'ible ayu. Te onom di algoy mabalin hi puntamuwanyu an ta'on on hinan ahingunuwan an pun'aladuwanyuh nadan puntanomanyu ya hinan ahi'apit ya mahapul an mun'ible ayu. ");
INSERT INTO ifa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ya ngilinonyu bo nan ahigapas an pangidawatanyun ha\"on an Dios hinan hopap di gapasonyu. Ya nginilinyu bo nan pun'apitanyuh nadan bungbunga\"an ta ahi mapogpog nan hintawon. ");
INSERT INTO ifa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ya atawotawon ya mahapul an da'yun linala'in tinanud Israel ya mumpitlu ayun ma'amung hinan pundayawanyun ha\"on an na'abbaktun Dios an dayawonyun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ya wa'e ta un'unudonyuh nae an mumpitluh hintawon an ma'amung ayuh nan pundayawan i ha\"on ya pakako' an namin nadan numbobleh nadan pumboblayanyu ta pabilbillogo' nan bobleyu. Ya atbohdin ma\"id ha mabalin hi mamlo i diyen eyu pumboblayan. ");
INSERT INTO ifa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ya adiyu idihhan an idawat nan tinapay an nadduman hi yist hinan i'nongyun animal. Ya hinan punnomnomnomanyuh nihwanganyuh ate hi ad Egypt ya tigonyu ta ma\"id ha mabati hinan ini'nongyu hi ingganah nan mawi\"it. ");
INSERT INTO ifa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ya hay iyaliyuh nan pundayawanyu i ha\"on ya nan ap'aphodan hinan mamangulun apitonyu. Ya adiyu pundanum hinan iha\"angyun ukkon an gulding nan gatas nan hi inana. ");
INSERT INTO ifa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ya alyon bon Apu Dios i Moses di, Itudo'mun namin danaen inali' te danaen imbagabaga' ya ato' i he\"a ya nadan ibbam an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ta napat (40) di algo ya hilong di nihaha''adan Moses hidih nan billid an agge nangnangngan ya agge im'imminnum. Ot itudo' bon Apu Dios nan Himpulun Tuguna i diyen duwan nadampillag an batu. ");
INSERT INTO ifa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ta on nalpah ot alan Moses ot dumayyuh nan billid hi ad Sinai an inodnanah diyen duwan batun nitud'an nadan Himpulun Tugun. Ya nunhiglan humiliy angahnan gapuh nan ni'happitana i Apu Dios. Mu hi Moses ya aggena innilan athidi. ");
INSERT INTO ifa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ta hidin tinigon da Aaron ya nadan ibbanan tatagu an humiliy angah Moses ya tumakutdan e mihaggon i hiya. ");
INSERT INTO ifa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mu inayagan Moses dida ot umeda mo da Aaron ya an namin nadan mangipangpanguluh nadan tinanud Israel ta eda donglon nan ibagana i dida. ");
INSERT INTO ifa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ta on nalpah an nunhahapitda ot ahida umen namin nadan tatagu ta eda himmalunghung i Moses. Ot ibaganan didan namin nadan tugun Apu Dios an imbaganan hiyah awadanah nan billid. ");
INSERT INTO ifa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ya hidin indappuh Moses an imbagan namin i dida ot hu'yunganay angahna. ");
INSERT INTO ifa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mu wa'e ta hunggop hinan pundayawan i Apu Dios ta mi'ihapit i hiya on inaana nan inhu'yungna. Ya wa'e ta limmah'un on imbaganah nadan tatagu nan inalin Apu Dios hi ipa'innilanan dida ");
INSERT INTO ifa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","on hiyah diyen humiliy angahna. Ta hiya nan nalpah'en imbagana on hinu'yunganay angahna ta inggana boh on umen e mi'ihapit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Hi Moses ya inamungnan namin nadan tinanud Israel ot alyonan diday, Datuwey imbagan Apu Dios hi unudon ta'u. ");
INSERT INTO ifa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Hinan onom di algo ya muntamu ta'u mu hinan mi'apituh algo an Habadun tungo ya pun'iblayan te niyappit i Apu Dios. Ot nan muntamu i diyen algo ya mipapate. ");
INSERT INTO ifa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ya ta'on on ha pun'apuyanyuh baleyu ya mipagol hinan Habadun tungo. ");
INSERT INTO ifa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Alyon bon Moses hinadan na'amung an tinanud Israel di, Hi Apu Dios ya imbagana bon alyonay, ");
INSERT INTO ifa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","An namin ta'u ya mahapul an waday idat ta'un Apu Dios. Ot hay mabalin hi idat ta'u ya balitu' ya silber ya gombang ");
INSERT INTO ifa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ya nan asul onu bayulet onu mumbolah an hinulid ya napinun linen ya nan dutdut di gulding ");
INSERT INTO ifa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ya nan up'up di tangbal an kalnero an nakololan hi mumbolah ya nan up'up di animal hinan baybay ya nan kayiw an akasya. ");
INSERT INTO ifa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Ya mabalin bo nan lanan di olibo ta ma'usal hinan punhilawan ya nadan middum hinan lanan mihiit hinadan miyappit i Apu Dios ya nan maphod di hunghungnan insenso. ");
INSERT INTO ifa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Ya mabalin bo nan oniks ya nadan udum an nun'abalol an batu ta miha\"ad hinan ephod ya nan miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Alyon bon Moses di, An namin ayun waday la'ingnan mangiyammah kumpulna ya umali ayu ta iyammayu nan imbagan Apu Dios ");
INSERT INTO ifa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","an tabernakel. Ta iyammayu nadan mikultina ya nadan pun'ipit ya nadan mandol hi kultina ya nadan miballabag ya nadan tu\"udna ya nadan ipabunan nadan tu\"udna. ");
INSERT INTO ifa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ya inyammayu nan Kahun an ittuwan nadan Hapit Apu Dios ya nan kalub an ma'alih a'aanan di bungot Apu Dios an gapuh bahul nadan tatagu ya nan pangiyattangan ya nan kultinan mihawan. ");
INSERT INTO ifa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ya inyammayu bo nan lamehaan an pangiha'mawan hinan tinapay an midawat i Apu Dios ya nadan udum an ma'usal i diye ya nan pangiyattangan nadan mangdon. ");
INSERT INTO ifa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ya inyammayu bo nan punhilawan ya nadan udum an ma'usal ya nan lanan olibo ta way atonan dumilag. ");
INSERT INTO ifa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ya inyammayu bo nan punggobhan hi insenso ya nadan pangiyattangan ya nan insenso ya nan lana ya nan kultinan mihawan hinan panto. ");
INSERT INTO ifa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ya inyammayu bo nan gombang an punggobhan hinan mi'nong i Apu Dios ya nan ay nalagan gombang an pangiha'mawan hi mi'nong ya nan duwan pangiyattangan ya nadan udum an mahapul hidi ya nan gombang an pun'ulahan ya nan ipattukana. ");
INSERT INTO ifa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ya inyammayu bo nadan kultinan mihawan hi nunlini''odan ya nadan tu\"udna ya nadan ipabunan dadiyen tu\"ud ya nadan mikultinah nan panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ya inyammayu bo nadan pahok ya nadan talin ma'usal hinan alad hi nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ya inabolyu nadan ilubung nadan padi hinan punhilbiyandan Apu Dios. Ta nat'on nan ilubung nan nabaktun padin hi Aaron hinan ilubung nadan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hidin indappuh Moses ot mumpapange nadan tataguh nan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ya an namin nadan waday pinhodnan idawat i Apu Dios ya nun'iyeda. Ta nawadan namin nadan miyammah nan tabernakel ya nan mahapul hidi ya nan miyammah lubung nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ta an namin nadan binabai ya linalain naminhod an mangdat ya nun'iyeda nadan idatda. Ta nadan udum ya indatday balitu' an umat hi hingat ya singsing ya nadan mibanggol ya nadan udum an balitu' di niyamma ta idawatdan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ya nadan udum ya inyeday napinun linen ya nan hinulid an asul ya bayulet ya mumbolah ya nadan na'abol an dutdut di gulding ya nan up'up di kalnero an nakololan hi mumbolah ya nan up'up di animal hinan baybay. ");
INSERT INTO ifa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ya nadan udum ya silber ya gombang ya kayiw an akasya. ");
INSERT INTO ifa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ya nadan binabain nala'ing an mumpudun ya nun'iyeday pinudundan napinun linen ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ya nadan udum an binabai ya nunlubiddah dutdut di gulding. ");
INSERT INTO ifa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ya hay inyen nadan ap'apun di himpahimpamu'un ya nan nun'abalol an batu an umat hi oniks ya nadan udum an mi'alkus hinan ephod ya nan miyoddah nan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ya nadan udum ya inyeday lanan di olibo ya nadan udum an middum hinan miyammah insenson maphod di hunghungna ya nan lanan mihiit hinadan miyappit i Apu Dios an usalon di padi. ");
INSERT INTO ifa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ta an namin nadan tinanud Israel an binabai ya linala'i ya nun'iyeda nan pinhoddan idawat ta ma'usal hinan imbagan Apu Dios i Moses hi iyammada. ");
INSERT INTO ifa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ya alyon Moses hinadan tataguy, Hi Apu Dios ya pinto'nah Besalel an imbabalen Uri an tinanud Hur an tinanud Judah ");
INSERT INTO ifa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ta pabikahona nan Espirituna i hiya ta nala'ing ya waday abalinanan mangat hinadan mapmaphod di tigona. ");
INSERT INTO ifa_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ta mabalin an iyammana nan balitu' ya silber ya gombang hi mapmaphod di tigona. ");
INSERT INTO ifa_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ya nala'ing bon munggutih nan nun'abalol an batu ya mumpa'ot hinan kayiw ya an namin nan mapmaphod an miyamma. ");
INSERT INTO ifa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ta didan duwah nan hi ibbanan hi Ahisamak an tinanud Dan ya indattan Apu Dios didah la'ingdan mangitudduh udum an tataguh nan abalinandan aton. ");
INSERT INTO ifa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ta dakol nan indat Apu Dios an abalinandan umat hi mun'ammah nan kumpulnan mun'a'aphod. Ya nadan udum ya nala'ingdan mun'abol ya mumboldah luput an nan hinulid an asul ya bayulet ya mumbolah di usalonda. Ta an naminda ya nun'alala'ingdan mangat hinan tamuda. ");
INSERT INTO ifa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Alyon bon Moses di, Da Besalel i Oholiab ya an namin nadan indattan Apu Dios hi la'ing ya abalinan ya diday mangiyammah nan tabernakel an iyunnuddah nan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Impa'ayag Moses da Besalel i Oholiab ya an namin nadan linala'i an waday abalinandan nalpun Apu Dios ya waday naminhoddan mi'itamu. ");
INSERT INTO ifa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ot iyukodnan dida nan na'amung an ma'usal an nalpuh nadan ibbadan tinanud Israel. Ya hiyah diyen amawimawi\"it on waday iyedan middum hinadan ma'usal. ");
INSERT INTO ifa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ya lo'tat ya an namin nadan muntamu ya immeda i Moses ");
INSERT INTO ifa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ot alyonday, Dakol bo aya nadan inyali'alin nadan tatagun usalonmih nan ipiyamman Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ot ibagan mon Moses hinadan tatagu ta idinongdan mangiyeh nadan iboddangdah nan miyammah nan pundayawanda i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Te nahawwalan nan inye'inyedan ma'usal. ");
INSERT INTO ifa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","An namin nadan waday punla'inganah nadan nat'onat'on an tamu ya diday nangiyammah nan tabernakel ya nadan himpulun (10) panid an luput ta mikultinah nan nunlini\"odan nan tabernakel. Ta hay inyammada ya nan linen an hinulid ya asul ya bayulet ya mumbolah ot ipi'ugutdah nan nala'ing an mumbolda di kerubim. ");
INSERT INTO ifa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ot pumpapaddungonday dinukken nadan kultina an napat (40) di umpi ya hay binillogda'e ya onom di umpi. ");
INSERT INTO ifa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ya nundada\"itonday hinlilimay panid. ");
INSERT INTO ifa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ya nangiphoddah nun'abali\"un luput an asul ot i'ugutdah nan ohan da'ging nan nadada\"it an kultina. Ya athidi boy inatdah nan da'ging nan mi'adwan nadada\"it an limay panid an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ta hay in'ugutdah nan ohan da'ging nan nadada\"it an kultina ya nabonglen (50) nun'abali\"un luput an numpopotto'ondah nan mi'adwan nadada\"it an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ya nangiyammada boh nabonglen (50) balitu' an ipit ta nundammuwonda nan numpopotto'an an nun'abali\"un luput ta nangammut nan mikultinah nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ot abolonda boy himpulut ohay (11) panid hinan nalubid an dutdut di gulding ya inugutanda ta mangammut an luput an miyoddah hinan mikultinah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ya mahapul an pumpapaddungonday lukudda ta hinnanapat ta limay (45) umpiy dinukkeda ya hin'o'onom di umpiy binillogda. ");
INSERT INTO ifa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ya nundada''itonday limay panid ya ahida bo nundada''iton di onom an panid. ");
INSERT INTO ifa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ya in'ugutda boy nabonglen (50) nun'abali\"uh an luput hinan ohan da'ging nan nadada\"it an limay panid. Ya athidi boy inatdah nan da'ging nan mi'adwan nadada\"it an kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ya inyammaday nabonglen (50) gombang an ipit ta mangammut nan luput an miyoddah nan kultinah nan nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ya inyammada bo nan up'up di tangbal an kalnero an nakololan hi mumbolah ta miyoddah boh nan kultinah nunlini\"odan nan tabernakel. Ya inyammada nan up'up di animal an malpuh nan baybay ta hidiyey muntu'yap an miyoddah hinadan kultinah nan nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ya nangiyammadah nan kayiw an akasya ta mandol hinadan kultinah nunlini\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ya hay dinukken di ohan mandol hi kultina ya himpulut limay (15) umpi ya hay binillogna ya baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ya an namin nadan mandol hinadan kultina on waday duwan nidongdong hi pu\"una ta mabalin an mihu\"updah nan ipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ta hay iyammadah mandol hinadan kultinah nangappit hi muyyadna ya bainti (20). ");
INSERT INTO ifa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ya iyammada boy napat (40) an silber an ipabunan nadan hukin nadan mandol ta hindudwah nan ohan mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ya bainti (20) boy miyammah mandol hi nangappit hi huddo'na. ");
INSERT INTO ifa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ya napat (40) di silber an ipabunanda an hindudwah nan ohan mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ya hay nangappit hi alimuhan di algo ya onom di mandol hi kultina. ");
INSERT INTO ifa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ot iyammada boy hindudwan mandol hi kultinah nadan duwan duggun nan tabernakel hi nangappit hi alimuhan di algo. ");
INSERT INTO ifa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ya dadiyen duwan mandol hi kultinah nan duggun nan tabernakel ya nunda\"itonday mihipun hi pu\"una ta ingganah baktuna an mihu'lubdah nan nun'atuligonggong. ");
INSERT INTO ifa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ta walun namin di mandol hi kultinah nangappit hi alimuhan di algo an niddum nan duwah dugguna. Ya himpulut onom (16) di silber di ipabunanda te nan ohan mandol on duway ipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ot iyammada boy liman kayiw an akasya ta mandol hinadan kultina hi nangappit hi huddo'na. ");
INSERT INTO ifa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ya lima boh nangappit hi muyyadna ya lima boh nangappit hi alimuhan di algo hi indoggan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ta hana'e an miballabag hi gawwan nadan mandol hi kultina ya minaynayun an mihipun hi pingngitna ta inggana boh nan pingngitna. ");
INSERT INTO ifa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ya inoddahandah balitu' an namin dadiyen mandol hi kultina ya nadan miballabag an kayiw. Ya inyammada boy balitu' an nun'atuligonggong ta pangiduulandah nadan miballabag an kayiw. ");
INSERT INTO ifa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ya nan inaboldan kultina an asul ya bayulet ya mumbolah ya napinun linen an hinulid ya imboldadahdiy inyammadan kerubim. ");
INSERT INTO ifa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ot iyammaday opat an tu\"ud an kayiw an akasya ot oddahandah balitu'. Ot iyammada boy kawit an balitu' ya nadan ipabunan di tu\"ud an silber. ");
INSERT INTO ifa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ot iyamman nadan nala'ing an mumbolda nan mikultinah nan panto hinan hinulid an napinun linen ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ot iyammada boy liman tu\"ud ya kawit ta ihablayan nan kultina. Ot oddahanda nadan uhhun nadan tu\"ud hi balitu' ot iyammada nadan gombang hi pangipabunan i dadiyen tu\"ud. ");
INSERT INTO ifa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Inyamman bon Besalel nan kayiw an akasya hi Kahun an hay dinukkena ya napat ta limay (45) pulgada. Ya numpaddung di binillogna ya tinagena an baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ot iphodnan oddahan hi namahmah an balitu' di dallomna ya nan muntigo ot alkusanah balitu' nan nundina'ging hi uhhun nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ot mun'ammah opat di natuligonggong an balitu' ot ipongnan iyammah nan opat an duggun nan Kahun ta hindudwah numbinahhel. ");
INSERT INTO ifa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ot mangiyammah pangiyattangan an hay inyammana ya nan kayiw an akasya ot oddahanah balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ot pumbinahhelonan iduul hinadan nun'atuligonggong hinadan duggun nan Kahun ta pangiyattangan nadan mangdon. ");
INSERT INTO ifa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ot iyammana bo nan kalub nan Kahun an hay iniphodna ya nan namahmah an balitu' an hay dinukkena ya napat ta limay (45) pulgada. Ya hay binillogna ya baintit pituy (27) pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ot ingammutnan iyammahdi nan duwan kerubim an hay inyammana ya nan balitu' an pinandayna ");
INSERT INTO ifa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ta nihamad an niha\"ad hi numbinnongwah nan uhhun nan kalub nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","An nunhangngabona dadiyen kerubim mu inyuhdungdah nan kalub ot bitbitonay paya'da ta nahophopan nan kalub. ");
INSERT INTO ifa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ot iyammana bo nan akasya hi lamehaan an hay dinukkena ya tuluy umpi ya hay binillogna ya ohay umpi ta han godwa. Ya hay tinagena ya duway umpi ta han godwa. ");
INSERT INTO ifa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ot oddahanah namahmah an balitu' ot alkusana boh balitu' an namin nan nundina'ging hi uhhuna. ");
INSERT INTO ifa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ot ha\"adana nan nundina'ging hi tuluy pulgaday binillogna an kayiw ot alkusanah balitu' di nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ot iyammana boy opat di natuligonggong an balitu' ot idikkitnah nan opat an hukin nan lamehaan ");
INSERT INTO ifa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","hi da\"ul nan da'gingna ta iduulan nan pangiyattangan. ");
INSERT INTO ifa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ya hay inyammanah nan pangiyattangan ya nan kayiw an akasya ot oddahanah balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ot iyammana bo nadan ma'usal hidin umat hi duyu ya basu ya malukung ya pannuman an ittuwan di ma'inum an midawat i Apu Dios. Ya an namin datuwen miha\"ad hinan lamehaan ya namahmah an balitu' di inyammada. ");
INSERT INTO ifa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ot pandayona nan namahmah an balitu' hi punhilawan. Ta ohan nangammut an balitu' nan mihipun hi pu\"una ya nan nigawwan ay adolna ya nan alkusnan umat hi habhabung ya nadan hapangna ya nadan hilawna. ");
INSERT INTO ifa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ta onom nadan ay hapang an hilaw te hintutluh numbinahhel. ");
INSERT INTO ifa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ya way ohah nan ay hapang ya na'alkusan hi tulun natuntunud an ay habung di almon. ");
INSERT INTO ifa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ya nan nigawwan ay adol nan punhilawan ya opat nan natuntunud an ay habung di almon. ");
INSERT INTO ifa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ta ohay ay nuwanin habung on numbinahhel hi baktunay duwan hilaw ta ingganah nan mi'atlun habung. Ta hintutluh numbinahhel nan numpopotto'an an hilaw. ");
INSERT INTO ifa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ta an namin nadan alkusnan ay habung ya nan tulun numpopotto'an an hapang ya oha nan nangammut an namahmah an balitu' an pinandayna. ");
INSERT INTO ifa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ot iyammana bo nan pitun ay basun punhilawan ya nan pumputul hi mitsa ya nan pangi'amungan hi gubu an hay inyammana ya nan namahmah an balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ta tulumpulut opat (34) di kilun namahmah an balitu' di na'usal ot ahi magibbuh nan punhilawan an niddum nan umat hi pangi'amungan hi gubu ya nadan udum. ");
INSERT INTO ifa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ot iyammana bo nan punggobhan hi insenso an kayiw an akasya. Ya hay dinukkena ya ohay umpi ta han godwa an numpaddung hinan binillogna an oha boy umpi ta han godwa. Ya hay tinagena ya tuluy umpi. Ya hinan opat an dugguna ya iniphodnahdiy ha'gud an ningammut hinan kayiw an akasya. ");
INSERT INTO ifa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ot oddahanah balitu' nan uhhuna ya an namin nan muntigoh nunlini\"odan ya nan opat an ha'gud. Ot alkusanah balitu' nan nundina'ging hi da\"ul nan uhhuna. ");
INSERT INTO ifa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ot iyammanay opat di natuligonggong an balitu' ot i'apyana dadiye ta hindudwah nan numbinahhel. Ta hidiy pangiduulandah nan pangiyattanganda. ");
INSERT INTO ifa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ya hay inyammana i dadiyen pangiyattangan ya kayiw an akasya ot oddahanah balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ot mangiyamma nadan nala'ing an mangiyammah lana hi lanan usalon di padi ya nan mapmaphod di hunghungnan insenso. ");
INSERT INTO ifa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Inyammada bo nan kayiw an akasya hi punggobhan hi mi'nong i Apu Dios. Ya hidiyen iniphodda ya numpapaddungonda nan opat an da'gingna an himpipituy umpi ta han godwa. Ya hay tinagena'e ya opat di umpi ta han godwa. ");
INSERT INTO ifa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ot iyammada bo nan ha'gud hinan opat an dugguna an ingngammutdah nan kayiw an akasya hi punggobhan hi mi'nong an na'oddahan hi gombang. ");
INSERT INTO ifa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ya an namin nadan ma'usal hidi an umat hinadan banga ya nadan punggaud hi gubu ya nadan malukung an duyu an iha\"adan di dala ya nadan tibi' di dotag ya nadan pangittuwan hi bala ya hay iyammada ya nan gombang. ");
INSERT INTO ifa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ot iyammada bo han ay nalagan gombang ot uhbungondah nan punggobhan ta nipogpog hinan gawwana. ");
INSERT INTO ifa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ot ha\"adandah opat di gombang an nun'atuligonggong nan punggobhan hi mi'nong ta pangiduulandah nan pangiyattangan. ");
INSERT INTO ifa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ta iniphodday duwan pangiyattangan an kayiw an akasya ot oddahandah gombang. ");
INSERT INTO ifa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ot iduuldah nan numbinahhel i diyen punggobhan hi mi'nong ta midadaan hi pangiyattanganda ya hidiyen punggobhan ya nadingding hi kayiw mu nabaoy dallomna. ");
INSERT INTO ifa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Inyammada bo nan gombang an besin ya nan gombang an ipabunana an hay inyammada ya nan indat nadan binabain muntamuh nan way panton di pundayawan an dadiye nan gombang an diggalda. ");
INSERT INTO ifa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Inyammada bo nan mi'alad an kultina hi nunlini''odan nan lita\"angan nan tabernakel an hay dinukken nan nummuyyad ya umeh hinggahut ta nabongley (150) umpi. Ya hay inyammada ya nan napinun linen. ");
INSERT INTO ifa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ya hay tu\"ud di mandol hi kultina ya bainti (20) an impabundah baintin (20) gombang. Ya hay inyammadah baddong ya kawit ya nan silber. ");
INSERT INTO ifa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ya hay dinukken'en nan kultinah nangappit hi huddo'na ya numpaddung hinan kultinah nangappit hi muyyadna an hinggahut ta nabongley (150) umpi ya bainti (20) boy tu\"udna an nipabundah baintin (20) gombang. Ya hay inyammada nimpeh kawit ya baddong ya nan silber. ");
INSERT INTO ifa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ya hay dinukken'en nan kultinah nangappit hi alimuhan di algo ya napitut limay (75) umpi. Ya himpuluy (10) tu\"ud di mandol hi kultina ya himpulu (10) boy nipabunanda. Ya atbohdin hay inyammadah kawit ya baddong ya nan silber. ");
INSERT INTO ifa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ya athidi bon napitut limay (75) umpiy dinukkenah nangappit hi tuluwan di algo. ");
INSERT INTO ifa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ya hinan way geyt ya nundinommang di kultina an hay dinukkena ya baintit duwa ta han godway (22 ½) umpi. Ya hi nangappit hi winawwan ya tuluy tu\"udna ya tulu boy ipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ya hay nangappit hi iniggid ya atbohdin hay nikultina ya baintit duwa ta han godway (22 ½) umpiy dinukkena. Ya tuluy tu\"udna ya tulu boy nipabunanda. ");
INSERT INTO ifa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ya an namin nadan kultinan mi'alad hi nunlini\"odan nan tabernakel ya napinun linen di niyamma. ");
INSERT INTO ifa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ya hay ipabunan nadan tu\"ud ya gombang. Ya hay inyammadah kawit ya baddong ya nan silber. Ta an namin nadan tu\"ud ya naha\"adan di uddudah silber an punhablayan. ");
INSERT INTO ifa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ya nan kultinan mihawan hinan geyt ya tulumpuluy (30) umpiy dinukkena. Ya hay impiyammadah nan nala'ing an mumbolda ya nan napinun linen an hinulid ya asul ya bayulet ya mumbolah. Ya hay tinagena'e ya pituy umpi ta han godwa an nipaddung hi tinagen nan nikultinah nunlini\"odan. ");
INSERT INTO ifa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ya hay inyammadah tu\"ud ya opat an nipongdan nipabun hi opat bon gombang. Ya hay inyammadah nan kawit ya baddong ya nan silber. Ot oddahanda bo nan uddun nan tu\"ud hi silber. ");
INSERT INTO ifa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ya an namin nadan pahok an ma'usal hinan tabernakel ya nan nunlini\"odana ya gombang di inyammada. ");
INSERT INTO ifa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hay bilang nadan balitu' ya silber ya gombang ya nadan udum an ma'usal hinan tabernakel ya intudo' nadan tinanud Libay te hiyay imbagan Moses. Ta nan padi an hi Itamar an imbabalen Aaron di mumpapto' i diyen tamu. ");
INSERT INTO ifa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ya nan apapun Hur an imbabalen Uri an nalpuh nan tinanud Judah an hi Besalel di nangiyammah nadan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ya hay bimmoddang i hiya ya hi Oholiab an imbabalen Ahisamak an tinanud Dan. Hiya ya nala'ing hi nat'onat'on an tamu an umat hi mumpa'ot ya nala'ing bon munnomnom hi maphod an iyamma ya nala'ing bon mumboldah luput an hay usalona ya hinulid an asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hay ngammut di indat nadan tataguh balitu' an na'usal hinan pundayawan ya hiyam di gahut ta nahiyam ta lima ta han mahuluk hi godway (995.6) kilu. ");
INSERT INTO ifa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ya hay indatdah silber ya tuluy libut opat di gahut ta han baintit opat ta han mahuluk hi godway (3,424.6) kilu. ");
INSERT INTO ifa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ya hay nangdat i datuwen silber ya nadan linala'in mihipun hi baintiy (20) tawonda ya nadan mahuluk hi baintiy (20) tawonda. Ya hay bilang di linala'in nangdat ya onom di gahut ta tuluy libu ta han limay gahut ta nabongle (603,550). ");
INSERT INTO ifa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ta nan tuluy libu ta han nanom (3,060) di kilun di silber ya inyammadah hinggahut (100) an ipabunan nadan mandol hi kultinan nan tabernakel ya nadan tu\"ud nan pangihablayan hinan kultinah dallom nan tabernakel. Ya hay na'usal hi silber hinan ohan ipabunan di mandol hi kultina ya umeh tulumpulu ta han godway (30.6) kilu. ");
INSERT INTO ifa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ya nan nahawwal an mahuluk hi godway kilun silber ya inyamman da Behalel hinan pangihablayan hi kultina ya kawit ot oddahandah silber di uddun nadan tu\"ud. ");
INSERT INTO ifa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ya hay inamung nadan tatagu hi gombang ya duway libut opat di gahut ta han walu ta han godway (2,408.5) kilu. ");
INSERT INTO ifa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ta hiyay inyammadah ipabunan nadan tu\"ud hinan panton nan tabernakel ot usalonda nadan udum an gombang hinan punggobhan hi mi'nong ya nan ay nalaga ya nadan udum an ma'usal hidi. ");
INSERT INTO ifa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ot iyammaday udum hinadan pangipabunan hinadan tu\"ud hi nunlini\"odan ya nadan pahok an ma'usal hinan tabernakel ya nadan alad hi nunlini\"odan nan lita\"angana. ");
INSERT INTO ifa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hay inaboldah lubung di padi hinan punhilbiyandah nan pundayawan i Apu Dios ya nan hinulid an asul ya bayulet ya mumbolah. Ya athidi boy inyammadah nan lubung nan nabaktun padin hi Aaron ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hay inyammadah nan ephod ya nan napinun linen ya nan hinulid an balitu' ya asul ya bayulet ya mumbolah. ");
INSERT INTO ifa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ya hay inatdan nangiphod hi hinulid an balitu' ya pinandayda nan balitu' ta ay papel di iningpihna ot ahida kaltikaltibon ot ahi iboldan di nun'ala'ing an mumbolda. ");
INSERT INTO ifa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ya nan ephod ya duway panid an luput ta mibonog di oha ya mipalagpag di oha ot ha\"adandah pumpattitan nan mipu'ol ta pundammuwanda. ");
INSERT INTO ifa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ya nan balikisna ya ningammut hinan ephod ta numpaddung di tigoda an hay ipiyammadah nan nala'ing an mumbolda ya nan napinun linen ya nan hinulid an balitu' ya asul ya bayulet ya mumbolah ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ot ipakladah nan balitu' nan duwan nabalol an batu an oniks. Ot itudo'dahdih nan oniks di ngadan nadan himpulut duwan (12) tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ot i'ugutdah nan mipu'ol hinan ephod ta nanongnan mipapanomnom nadan tinanud Israel ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ot iyammada bo nan miyoddah hinan ephod hi palagpag nan padi an hay inyammada ya nan ibban nan niyammah ephod an napinun linen ya hinulid an balitu' ya asul ya bayulet ya mumbolah an inyamman di nala'ing an mumbolda. ");
INSERT INTO ifa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ya hay a'atna ya luput an nakupin an numpapaddung nan opat an da'gingna an hinhihiyam di pulgada. ");
INSERT INTO ifa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ot i'ugutdahdiy opat di nalinlinyan nun'abalol an batu. Ta hinan namangulun linya ya in'ugutda nan rubi ya topas ya beril. ");
INSERT INTO ifa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ya hinan mi'adwan linya ya nan torkois ya sapira ya emerald. ");
INSERT INTO ifa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ya hinan mi'atlun linya ya nan jasint ya agate ya ametis. ");
INSERT INTO ifa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ya hinan mi'apat an linya ya nan krisolayt ya oniks ya jasper. Ya an namin danaen nun'abalol an batu ya impakladah balitu'. ");
INSERT INTO ifa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ot ipongdan itudo' i dadiyen himpulut duwan (12) batu di ngadan nadan himpulut duwan (12) tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ot iyammada nan ay na'apid an namahmah an balitu' ta puntayunda i diyen miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ot iyammada boy duwan ay singsing an balitu' ot i'ugutdah nan duwan numbaktun duggun diyen miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ot itayunda nan ay na'apid an namahmah an balitu' hinan duwan ay singsing. ");
INSERT INTO ifa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ot itayunda nan bongwahna hinan oniks hinan ephod hinan mipu'ol. ");
INSERT INTO ifa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ot ha\"adanda boh ay singsing an balitu' ya in'ugutdah nan dallom nan duwan nunda\"ul an duggun nan miyoddah hinan ephod hi palagpag nan padi. ");
INSERT INTO ifa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ot iyammada boy duwan ay singsing an balitu' ot i'ugutdah baktun nan balikis nan ephod. ");
INSERT INTO ifa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ot tayunandah asul an hinulid nan numpotto'an nan duwan ay singsing hinan miyoddah hinan ephod hi palagpag nan padi hi way baktun di balikisna ta mihamad an midakop ta adi munlaplape ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nan adukken lubung an iyoddahan nan ephod ya hay inabolda i diye ya nan hinulid an asul. ");
INSERT INTO ifa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ot i'ugutdah nan mibagang di na'abol ta adi mahethet. ");
INSERT INTO ifa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ot mun'ammada boh ay bungan di pomegranet an hay inyammada ya nan hinulid an napinun linen ya asul ya bayulet ya mumbolah. Ot i'ugutdah nan migayadan ta ahitanattayunda. ");
INSERT INTO ifa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ot mangiyammada boh nan namahmah an balitu' hi kikkitang an batingting ot ibattabattandan i'ugut hinadan pomegranet ");
INSERT INTO ifa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ta nali'li'woh nan gayadan ta hidiyey ilubung nan padi hinan punhilbiyandah nan tabernakel ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ot iyammaan bon nadan nala'ing an mun'abol hi napinun linen da Aaron ya nadan linala'in imbabalena hi munggayyadan an lubung ");
INSERT INTO ifa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ya turban ya pongot ya putut an pantalon. ");
INSERT INTO ifa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ya nan miwakoh adolda ya hay miyamma ya nan napinun hinulid an linen ya asul ya bayulet ya mumbolah an iyamman di nala'ing an mumbolda ta miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ot iyammada hah nan namahmah an balitu' ot itudo'dahdiy, Niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ot ga'odandah linubid an asul ot i'ugutdah nan turban ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ta hidiyey nagibbuhan nan tabernakel an pi'dammuwanda i Apu Dios an inunuddan namin nan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Te inyen nadan tatagu i Moses nadan miyammah nan tabernakel an umat hinadan kultina ya nadan pun'ipit ya nadan mandol hi kultina ya nadan miballabag ya nadan tu\"ud ya nadan ipabunan nadan tu\"ud. ");
INSERT INTO ifa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ot iyeda bo nadan kultina an hay niyamma ya nan up'up di tangbal an kalneron nakololan hi mumbolah ya nan miyoddah an up'up di animal hinan baybay ya nan kultinan mihawan hinan Kahun. ");
INSERT INTO ifa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ot eda iha\"ad nan Kahun an nittuwan nan Hapit Apu Dios ya nan kalubna an ma'alih a'aanan di bungot Apu Dios an gapuh bahul nadan tatagu ya nan pangiyattanganda i diye. ");
INSERT INTO ifa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ot iyeda bo nan lamehaan ya nadan mahapul hidi ya nan tinapay an midawat i Apu Dios ");
INSERT INTO ifa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ya nan balitu' an punhilawan ya nan lanan di olibo an ma'usal ta ahi dumilag ya nadan udum an ma'usal hidi. ");
INSERT INTO ifa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Ot iyeda bo nan balitu' an punggobhan hi insenso ya nan lana an mihiit hinadan miyappit i Apu Dios ya nan maphod di hunghungnan insenso ya nan mikultinah nan panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ot iyeda bo nan gombang an punggobhan hi mi'nong ya nan mi'apyahdin ay nalagan gombang ya nadan pangiyattangan an kayiw ya an namin nadan mahapul hidi. Ot iyeda bo nan besin ya nan ipattukana ");
INSERT INTO ifa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ya an namin nan kultinan mihandih nan lita\"anganah nan nunlini\"odan ya nan geytna ya nadan pahok ya tali ya an namin nadan mahapul hidi i diyen tabernakel an pi'dammuwan i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ot iyeda bo nan mun''aphod an lubung di padi an ilubung da Aaron ya nadan linala'in imbabalenah nan punhilbiyandan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ta inat nadan tinanud Israel an namin nan miyunnudan hinan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ya hidin tinigon Moses dadiyen namin ya immannung an niyunnudandah nan imbagan Apu Dios. Ot inayunan wagahan dida. ");
INSERT INTO ifa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Hay pangipata'doganyuh nan tabernakel an pi'dammuwanyun ha\"on ya hitun madatngan nan mamangulun algoh nan mamangulun bulan. ");
INSERT INTO ifa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ta ipaghopyuhdi nan Kahun an nittuwan nan Hapit'un Dios ya inha\"adyu nan kultinana ta mahawanan. ");
INSERT INTO ifa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ya impaghopyu bo nan lamehaan ya inha'moyuhdi nadan mahapul an miha'mohdi. Ya impaghopyu nan punhilawan ya tinolganyu nadan hilawna. ");
INSERT INTO ifa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ya impaghopyu bo nan balitu' an punggobhan hi insenso ya inha\"adyuh way potto' nan Kahun. Ya ahiyu mohpe inhable nan kultinan nan panto. ");
INSERT INTO ifa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ya inha''adyuh dommang nan panto nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ya inha\"adyu nan ongal an besin hi numbattanan nan tabernakel an pi'dammuwanyu i ha\"on ya nan punggobhan hi mi'nong ya inittuwanyuh liting. ");
INSERT INTO ifa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ya kinultinaanyu nan nunlini\"odan nan lita\"angan nan tabernakel ya kinultinaanyu bo nan geytna. ");
INSERT INTO ifa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ya inalam nan lana ya em nunwalaghi'an nan tabernakel ya an namin nadan gina'un wahdi ta wan miyappitda i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ya winalaghi'am bo nan punggobhan hi mi'nong ya an namin nan wahdin ma'usal ta miyappitdan ha\"on ");
INSERT INTO ifa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ya inatmu bohdi hinan ongal an besin ya nan nipabunana. ");
INSERT INTO ifa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ya inyem mohpe da Aaron ya nadan linala'in imbabalenah nan way panton nan tabernakel ya nun'ulahom didah liting. ");
INSERT INTO ifa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ya impilubungmun Aaron nan lubung di padi ya hiniitam di ulunah lana ta miyappit i ha\"on ta hiyay padin munhilbin ha''on. ");
INSERT INTO ifa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ya impilubungmuh nadan imbabalena nan napto' an ilubungda. ");
INSERT INTO ifa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ya hiniitam di uluda hi lana ta umat hinan inatmun amada ta diday padin munhilbin ha''on. Ya gapuh nan nangihiitam hi lana hi uluda ya mibilangdah padi ya ta'on on nadan tanudanda. ");
INSERT INTO ifa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Hi Moses ya inatnan namin nadan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ta hidin ohay algo han nibaluh din mamangulun bulan hidin mi'adwah tawon hi nakakandah ad Egypt ot ipata'dogda nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ya hay inatdan nangipata'dog ya indadaanda ni' nadan ipabunana ot ahida ipata'dog hidi nadan mandol hi kultina ot ballabagandah nadan tabla dadiyen mandol hi kultina. Ot ipata'dogda nadan tu\"ud. ");
INSERT INTO ifa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ot oddahanda nadan kultinan nan tabernakel ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ot alan Moses nan duwan batun nitud'an nadan Himpulun Tugun Apu Dios ot ena ittuh nan Kahun ot iduulnahdi nan kayiw an pangiyattangan nadan mangdon ot ahina kaluban hinan kalub an ma'alih a'aanan di bungot Apu Dios an gapuh bahul nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ot ipaghopdah diyen Kahun hinan tabernakel ot handiyanah nan kultina ta miyunnudan hinan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ot iyeda nan lamehaan hidih nan bahhel nan nakultinaan ot iha\"addah nangappit hi huddo'na. ");
INSERT INTO ifa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ot iha\"addah nan lamehaan nan tinapay an nidawat i Apu Dios ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ot iyena bo nan punhilawan ot iha''adnah dommang nan lamehaan hi nangappit hi muyyadna. ");
INSERT INTO ifa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ot tolgana dadiyen hilaw hidi ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ot ipaghopna bo nan balitu' an punggobhan hi insenso hi hinangngab nan nakultinaan. ");
INSERT INTO ifa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ot gobhonahdi nan mapmaphod di hunghungnan insenso ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ot kultinaanda mohpe nan panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ot eda iha\"ad nan punggobhan hi mi'nong hinan nihaggon hinan way panton nan tabernakel an pi'dammuwan i Apu Dios ot i'nongdahdi nadan maghob an mi'nong ya nadan miwadat i Apu Dios an makan ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ot ena bo iha\"ad nan besin hinan numbattanan nan tabernakel ya nan punggobhan hi mi'nong ot talwanah liting ta pun'ulahan nadan padi. ");
INSERT INTO ifa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ta hidiy e nun'ulahan da Moses ya hi Aaron ya nadan linala'in imbabalen Aaron hi ta'leda ya hukida ");
INSERT INTO ifa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","on ahida hunggop hinan pi'dammuwan i Apu Dios ya ta'on on hinan umayandah nan punggobhan hi mi'nong ta miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ot kultinaan da Moses nan nunlini''odan ta waday lita\"angan nan tabernakel ya nan punggobhan hi mi'nong ot kultinaanda bo nan geyt nan lita\"angan. Ta hidiyey nagibbuhan diyen inyammada. ");
INSERT INTO ifa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Indani ya nahophopan hi bugut hidiyen pi'dammuwan i Apu Dios ta napnu nan tabernakel hinan binang Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ta ma\"id ha aton Moses an hunggop hidi. ");
INSERT INTO ifa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ta nihipun i diye ya ingganah on tigon nadan tinanud Israel an tumage nan bugut hi baktun nan tabernakel on ahida palu'ahon hidiyen tabernakel ta inayundah nan pumbaatanda. ");
INSERT INTO ifa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mu agge'e ni' timmage nan bugut hinan tabernakel ya adida makak nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ta athi'athidiy na'at i diyen eda immaninnabatan. Te mapatal'e on wada nan bugut hi baktun nan tabernakel. Ya nahdom'e on ay mundalang an apuy ta mabalin an panigan nadan tatagu.");
INSERT INTO ifa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Han ohan algo ya inayagan Apu Dios hi Moses hinan tabernakel ot alyonay, ");
INSERT INTO ifa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Ibagam hinadan ibbam an tinanud Israel an datuwe nadan mahapul an ma'unud hi'on waday idawatyun ha\"on. Onha animal di midawat ya gahin di ohah nadan pinanganyun baka onu kalnero onu gulding. ");
INSERT INTO ifa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ta wada'ey i'nong nan ohan tagu hi maghob an mi'nong i ha\"on ya mahapul an ha tangbal hi baka an ma''id ha bahbahna. Ta iyenah nan way panton nan tabernakel ta wan abuluto' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ya inha'mon diyen taguh ulun nan maghob an mi'nong an animal ta wan abuluto' ta a'aanan di bungot'un Dios an gapuh bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ya pinaltinahdih diyen baka hinan pi'dammuwanyun ha\"on an Dios. Ya inalan nadan padin imbabalen Aaron nan dalana ta eda iwalaghi' hinadan dingding nan punggobhan hi mi'nong hi hangngab nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ya inaana nan up'up diyen pinaltina ya dinautna ya ahina tinogtog. ");
INSERT INTO ifa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Yaden pun'iphod nadan padin imbabalen Aaron an pumpalpag nadan itunguh nan punggobhan hi mi'nong ta apuyanda. ");
INSERT INTO ifa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ya inalada mohpe nan dotag an ta'on on nan uluna ya nadan tabana ta iphoddan palpagon hi uhhun nan mundalang an itungu hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ya inulahan diyen tagu nadan minalutuna ya an namin nadan wadah dallom di putuna ya nadan huki ta ahi e gobhon nan padi hinan punggobhan hi mi'nong i ha\"on. Ot nan hunghung datuwe ya umipa'amlong i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Mu onha hay iyalidan mi'nong ya kalnero onu gulding ya mahapul an ha tangbal an ma''id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ya hay ena pamatayan ya hidih nan nangappit hi huddo' nan punggobhan hi mi'nong an nihangngab hinan pi'dammuwan i ha\"on an Dios. Ya inalan nadan padin tinanud Aaron nan dalana ta eda iwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ya tinogtogna nan dotag ya ahi inalan nan padi ta iphodnan palpagon hi uhhun nan mundalang an itungu an middum nadan tabana ya nan uluna. ");
INSERT INTO ifa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mu mahapul an ulahan diyen tagu nan minalutu ya an namin nadan wadah dallom di putuna ya nadan huki ta pi'ighob nan padi ta maghob an mi'nong an namin i ha\"on. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Mu onha hamuti nan ipi'nong nan tagu ta maghob an mi'nong i ha\"on an Dios ya mahapul an ha palluma. ");
INSERT INTO ifa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ta iyen nan padi nan hamuti hinan punggobhan hi mi'nong ya intilonay bagangna ta ingganay mihiwwe nan ulu ya intunguna nan ulu ya inihihanay dalana hinan da'ging nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ya ahina inaan nan bintuulna ya intopalnah nan pangitopalandah dapul hi nangappit hi tuluwan di algo hi'onta wahnan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ya inidonah paya' nan hamuti ya binuklina ya intungunah nan apuy hinan punggobhan hi mi'nong. Ot hinaen maghob an mi'nong ya umipa'amlong di hunghungna i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Alyon bon Apu Dios i Moses di, Wa'et hay idawatyu ya malpuh nan ginapasyu ya mahapul an gilingonyu ta mumbalin hi napinun alina ya hiniitanyuh mantekan di olibo ya hina\"adanyuh insenso. ");
INSERT INTO ifa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ya inyeyuh nadan padin tinanud Aaron. Ta gamalon nan padi dohah nan alinan nadduman hi mantekan di olibo ya iniddumnan namin nadan insenso ya ginhobnah nan punggobhan hi mi'nong ta mipatigon nidawat i ha\"on an Dios. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ya nan nabati i diyen alina ya niyappit i ha\"on an Dios ta hiya nan nadan padi ya ammunay idatana. ");
INSERT INTO ifa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Mu wa'et hay iyaliyu ya tinapay an miha\"ang hi pugun ya mahapul an ha napinun alina di apyonyu an udmanyuh mantekan di olibo mu adiyu udman hi yist. Ya mabalin bo nan ma'ingpin tinapay an ma\"id nimpe ha niddum hi yist mu ihiityuh uhhuna nan mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ya hi'on hay pangiha\"anganyuh nan midawat an makan ya nan pinakawan ya mahapul an ha napinun alinay apyonyu an udmanyuh mantekan di olibo mu adiyu bo damdama udman hi yist. ");
INSERT INTO ifa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ya nalutu'e ya inupi'upingyu ya hiniitanyu boh mantekan di olibo ya ahiyu mohpe indawat. ");
INSERT INTO ifa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ya hi'on nan idawatyu ya miha\"ang hinan ma'ingpin pinakawan ya atbohdin mahapul an napinun alinay apyonyu an ha''adanyuh mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ta kumpulna i datuwey atonyun mangiha\"ang hinan midawat i ha\"on an Dios ya inyeyuh nan padi ta iyenah nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ta uppingona ha kittang ya ginhobna ta mipatigon nidawat i ha\"on an Dios. Ot nan hunghungna ya umipa'amlong i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ya nan nabatin tinapay ya bagin nadan padi te niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ya mahapul an na'en maghob an midawat i ha\"on an nalpuh nan ginapasyu ya adi madduman hi yist onu danum di iyukan te paniyon gobhon hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Manu te mabalin an iddumyu nan danum di iyukan onu nan yist hi'on nan pangiddumanyu ya nan idawatyun hopap di inapityu. Mu adi nimpe mabalin hi middum hinan maghob an mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ya adiyu linglingon an iddum hinan alinan idawatyu nan ahin an mangipanomnom hinan imbaga' an Dios i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ya wa'e ta nan idawatyu ya nan hopap di inapityu ya mabalin an nan nahanglag an agge napinuy gilingna. ");
INSERT INTO ifa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ya na'e an alina ya hiitanyuh mantekan di olibo ya iniddumyu nan insenso ta midawat i ha''on. ");
INSERT INTO ifa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ta gobhon nan padi ha kittang hinan punggobhan ta mipatigon nidawat i ha\"on. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Alyon bon Apu Dios i Moses di, Hi'on hay i'nong di ohan tagu hi pi'hayyupana i ha''on ya ha baka ya mahapul an ha ma''id ha bahbahnan tangbal onu tinna. ");
INSERT INTO ifa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ya inyenah nan panton nan tabernakel ya inha'monay ta'lenah ulun nan baka ya pinaltinahdi. Ya inalan nadan padin holag Aaron nan dalana ya eda inwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ya hidiyen mi'nong hi pi'hayyupana i ha\"on an Dios ya mahapul hi maghob an namin nadan taban wah dallom nan putuna ");
INSERT INTO ifa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ya nan duwan batin ya nan nili'mut hidin taba an nihaggon hinan ulpu ya nadan nili'mut hinan alte ta maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","An namin datuwe ya e gobhon nadan padin holag Aaron hinan mundalang an apuy hinan punggobhan hi mi'nong. Ot nan hunghung datuwe ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ya onha kalnero onu gulding di i'nong di ohan tagu hi pi'hayyupana i ha\"on an Dios ya mabalin an ha tangbal onu tinna an ma\"id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ya wa'et kalnero nan ena i'nong ya iyenah nan pi'dammuwanyun ha\"on an Dios ");
INSERT INTO ifa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","hinan way hunggopan hinan tabernakel ya inha'monay ta'lenah ulun nan kalnero ya pinaltinahdi. Ta alan nadan padi nan dalana ya eda inwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ya inaana nan mataban iwitna ya dinautna ta aanonan namin nadan tabah dallom di putuna. ");
INSERT INTO ifa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ya inaana bo nan duwan batin ya nan taban nili'mut hidi ya nan maphod an bongwah nan alte. ");
INSERT INTO ifa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ya inalan nan padi datuwen namin ya ena ginhob hinan punggobhan ta mi'nong an makan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ya hi'on gulding nan i'nong nan tagu ya athidi bon iyenah nan pi'dammuwanyun ha\"on ");
INSERT INTO ifa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","hinan way hunggopan hinan tabernakel ya inha'monay ta'lenah ulun diyen gulding ya pinaltina. Ya e nun'iwalaghi' nadan padi nan dala hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ya inaana nadan maghob an mi'nong an umat hinadan tabah dallom nan putu ");
INSERT INTO ifa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ya nan duwan batin ya nadan taban nili'mut hidi ya nadan nili'mut hinan alte. ");
INSERT INTO ifa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ta e gobhon nan padi dadiyen makan te niyappit dadiyen namin i ha\"on an Dios. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ta datuwey unudonyu an ta'on on idanay awadanyu ya ta'on on nadan mapalpalog an matanudan. Ya tigonyu ta adiyu anon nan taba ya dala. ");
INSERT INTO ifa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Ibagam hinadan ibbam an tinanud Israel an wa'et waday numbahul te waday aggena inunud hinadan tugun'u an ta'on on aggena inatta ya datuwey mahapul an atona. ");
INSERT INTO ifa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","An umat hinan nabaktun padi hi'on numbahul an aggena inatta ya milaggat ayun namin hinan bahulna. Ot mahapul an alana ha ma''id ha bahbahnan kilaw an baka ta mi'nong hi apakawanan di bahulnan aggena inatta. ");
INSERT INTO ifa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ya inyenah nan way panton nan tabernakel ya inha'monay ta'lenah nan ulun nan baka ya ahina pinaltihdi. ");
INSERT INTO ifa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ya inighopna dohah nan dalah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ya intamolnay ohah nan gamatnah nan dala ya nun'iwalaghi'nah mumpipituh nan kultinah nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ya inhiitna dohah nan dalah nadan ha'gud an nipong hinadan duggun nan punggobhan hi insensohdi hinan kuwartu' an Dios. Ya ahina mohpe e ingkuyag nan nabatin dalah way pu\"un nan punggobhan hi mi'nong hidih nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ya inaanan namin nadan tabah nan putuna ");
INSERT INTO ifa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ya nan duwan batin ya nadan taban nili'mut hidi ya nadan nili'mut hinan altena. ");
INSERT INTO ifa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ya ena ginhob datuweh nan punggobhan hi mi'nong an umat hi atonah nan taban nan mi'nong hi pi'hayyupanyun ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mu nan adol diyen baka an nilaggat di up'upna ya lamohna ya uluna ya hukina ya an namin nadan wah dallom di putuna ya nan lugit an wahdih putuna ");
INSERT INTO ifa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ya mahapul an iyeyuh nan nibata\"an hinan nun'allunganyu an nibilang hi malinis an puntopalan hi dapul ya ginhobyuhdi. ");
INSERT INTO ifa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Mu hi'on an namin ayun tinanud Israel ya numbahul ayu te waday aggeyu inunud hinadan tugun'u an ta'on on aggeyu inatta ");
INSERT INTO ifa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ta na'innilaanyu'e an numbahul ayu ya mahapul an eyu alan ha kilaw an baka ya inyeyuh nan way panton nan tabernakel. Ta hidiyey mi'nong hi apakawanan di bahulyu. ");
INSERT INTO ifa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ya inha'mon nadan ap'apun di himpahimpamu'un di ta'ledah ulun nan baka ya pinaltidahdih nan pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ya inihgop nan nabaktun padi dohah nan dalan diyen bakah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ya intamolnay lodlodongnah nan dala ya inwalaghi'nah mumpipituh nan kultinah nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ya ena bo inhiit dohah nan dalah nadan ha'gud hinan dugguh nan punggobhan hi insensohdi hinan kuwartu' an Dios. Ya ahina mohpe e ingkuyag nan nabatin dalah way pu\"un nan punggobhan hi mi'nong hidih nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ya inaana bon namin nadan tabana ya ena ginhob hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ya hay atonah nan baka ya umat hinan atonah nan baka an mi'nong hi apakawanan di bahul ta a'aanan di bungot'un Dios an gapuh bahulyun tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ya ahina mohpe e ginhob hidiyen baka hi bata\"an nan nun'allunganyu an umat hinan inatnan nunggohob hinan namangulun baka. Ta pakawano' di bahulyun namin an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ya hi'on numbahul di ohah nadan ap'apuyu te waday imbahhonah nadan tugun'un Dios an ta'on on aggena inatta ya hiyah diye damdaman numbahul. ");
INSERT INTO ifa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ot na'innilaana'e an numbahul ya mahapul an ena i'nong ha tangbal an gulding an ma''id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ya inha'monay ta'lenah ulun diyen gulding ya pinaltinahdih nan way punggobhan hi mi'nong hi hangngab nan tabernakel. Ta mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ya intamol nan padiy gamatnah nan dalan diyen ni'nong ya inlamuhnah nadan ha'gud hinan opat an duggun nan punggobhan hi mi'nong ya ahina ingkuyag nan nabatin dalah pu\"un diyen punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ya ginhob nan padi bon namin nadan taban diyen ni'nong hinan punggobhan hi mi'nong an umat hi atonah nan taban mi'nong hi pi'hayyupan i ha\"on an Dios. Ta a'aanan di bungot'un Dios an gapuh bahul diyen ap'apu ta way atonan mapakawan hinan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ya onha ha ohah nadan ibbayun tinanud Israel di waday imbahhonah nadan tugun'un Dios an ta'on on aggena inatta ya hiya damdaman numbahul. ");
INSERT INTO ifa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ot na'innilaana'en numbahul ya mahapul an hay i'nongna ya ha tinnah gulding an ma''id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ta iyenah nan way punggobhan hi mi'nong ya inha'monay ta'lenah ulun diyen gulding an mi'nong hi apakawanan di bahulna ya pinaltinahdi. ");
INSERT INTO ifa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ya intamol nan padiy lodlodongnah nan dala ya ena nun'itodtod hinadan ha'gud hinadan duggun nan punggobhan hi mi'nong. Ya ahina ingkuyag nan nabatin dalah pu\"un diyen punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ya inaanan namin nadan taban nan gulding an umat hi atondah nan taban di mi'nong hi pi'hayyupanyun ha\"on an Dios. Ya e ginhob nan padih nan punggobhan hi mi'nong. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. Athituy aton nan padi ta a'aanan di bungot'un Dios an gapuh bahul diyen tagu ya ta mapakawan hinan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Mu hi'on ha kalnero di iyalinan i'nong ya mahapul an ha tinna an ma\"id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ya inha'monay ta'lenah ulun diyen kalnero ya pinaltinahdi hi awadan nan punggobhan hi mi'nong ta mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ya inalan nan padi dohah nan dalana ya intamolnay lodlodongna ya ena nun'itodtod hinadan ha'gud hinan opat an duggun nan punggobhan hi mi'nong ya ingkuyagna nan nabatin dalah pu\"un diyen punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ya inaan diyen tagun namin nadan taban diyen kalnero an umat hi atonyuh nan mi'nong hi pi'hayyupanyu i ha''on. Ya e mohpe iniddum nan padi dadiyen taba hinadan maghob an mi'nong. Ta athituy aton nan padi ta a'aanan di bungot'un Dios an gapuh bahulna ya ta wan mapakawan hinan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Alyon bon Apu Dios di, Wa'et na'ayagan di ohan tagun muntistigu hinan punhumalyaan mu adina pohdon an ibaga nan tinigona onu innilanan na'at ya numbahul ot mahapul an madusa. ");
INSERT INTO ifa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ya wada'ey dinapan di ohan taguh mibilang hi nalugit an ta'on on aggena inatta an umat hi naten animal ya numbahul damdama te mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ya atbohdi hi'on waday dinapanah tagu an mibilang hi nalugit onu waday nida\"omanah mibilang hi nalugit an ta'on on aggena inatta ya na'innilaana'e ya numbahul damdama. ");
INSERT INTO ifa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ya onha bo waha taguh agge nunnomnomnom ot isapatanan waday atona an ta'on on maphod onu adi ya numbahul. ");
INSERT INTO ifa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ot wa'et waday inat di ohan tagu i danaen nibaga ya mahapul an ibaganan numbahul. ");
INSERT INTO ifa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ya hay moltana ya iyena ha tinnan gulding onu kalneroh nan pundayawan i Apu Dios. Ta hidiyey i'nong nan padi hi apakawanan di bahulna ya ta a'aanan di bungot'un Dios an gapuh bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ya adina'e abalinan nan kalnero ya mabalin an ha duwah palloma. Ta mi'nong di ohah apakawanan di bahulna ya ni'nong hi maghob an mi'nong nan oha. ");
INSERT INTO ifa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ta iyena dadiyeh nan padi ta i'nong nan padih apakawanan di bahulna nimpe nan oha an tilononay bagangna mu ta adi mihiwweh nan adolna. ");
INSERT INTO ifa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ya ena inwalaghi' di udum hinan dalah nan pangngel nan dingding nan punggobhan hi mi'nong. Ya ena mohpe inihih nan nabatin dalanah nan pu\"un nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ya ini'nong nan padi nan mi'adwan hamuti hi maghob an mi'nong ta miyunnudan hinan nibaga an ma'at ta a'aanan di bungot'un Dios an gapuh bahulna ta mapakawan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Mu alina'eh on adi abalinan diyen tagu nan duwan palluma ya mabalin an ha hingkilun napinun alina. Ot gapu ta midawat an gapuh bahulna ya mahapul an ma\"id ha iddumnah mantekan di olibo onu insenso. ");
INSERT INTO ifa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ta iyenah nan padi ta gamalon nan padi dohah nan alina ya ni'ighobnah nadan udum an maghob an mi'nong i ha\"on an Dios ta apakawanan di bahulna ya ta mipatigon nidawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Athidiy aton nan padi ta a'aanan di bungot'un Dios ya ta wan mapakawan hinan numbahulana. Ya nan nabatin alina ya bagin nan padi an umat hinan alinan midawat hi punhanaan. ");
INSERT INTO ifa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Hi'on waha taguh lininglingnan indat nan niyappit tuwali i ha\"on an Dios ya hay moltana ya iyalina ha tangbal hi kalnero an ma''id ha bahbahna. Ta nan balol nan kalnero ya miyunnudan hinan nibaga tuwali an balol di mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mu mahapul an bayadana damdamah diyen lininglingnan idat an niyappit tuwali i ha\"on an Dios mu udmanay bayadna ta hinggahut'ey balol nan aggena indat ya hay idatna ya hinggahut ta bainti (120). Ya hay pangdatana i diyen namin ya nan padi. Ta iyena nimpe ha tangbal an kalnero ta i'nong nan padi ta a'aanan di bungot'un hiya ya mapakawan hinan numbahulana i diyen aggena inatta. ");
INSERT INTO ifa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ya wa'e bo ta numbahul di ohan tagu te waday inatnan mipagol hinan tugun'un Dios an ta'on on aggena inatta ya mahapul an bayadana nan moltana. ");
INSERT INTO ifa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ya athidi bo an mahapul an iyenah nan padi ha tangbal an kalnero an ma\"id ha bahbahna an hay balolna ya miyunnudan hinan nibaga tuwali an pihhuh nan tabernakel. Ta i'nong nan padi ta a'aanan di bungot'un Dios i hiya ta mapakawan di bahulna an ta'on on aggena inatta. ");
INSERT INTO ifa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ta hituwen mi'nong ya gapuh numbahulan diyen tagu i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Alina'e hi waha inlayahanah nan hinaggona ta alyonay natala' nan impipa''enan hiya onu nan impipapto'na i hiya ta inakona onu kinulukna ya numbahul i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ya atbohdih nan waday hinama'nan natala' muden iha''utna ya insapatana bo udot an ma''id ");
INSERT INTO ifa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ya mahapul an ipabangngadna nan inakona onu pinlohna onu nan alyonay na'ako an impipapto'dan hiya onu nan hinama'nan bagin di udum. ");
INSERT INTO ifa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ta ibangngadna nan nganne man i datuwe an inatna ya inudmanah bainti (20) hi'on nan balol datuwen inatna ya hinggahut (100) ya indatnah nan ud bagi i diyen algon pangiyayanah nan mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ta binayadana'e ya inyena mohpeh nan padi ha tangbal an kalnero an ma\"id ha bahbahna ta i'nong nan padi i ha\"on an Dios ta apakawanan di bahulna. Ya nan balol nan kalnero ya miyunnudan hinan balolnah nan nibaga tuwali an balol di mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ta i'nong nan padi ta a'aanan di bungot'un Dios an gapuh nan bahulna ya ta wan mapakawan hinan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ibagam i Aaron ya nadan linala'in imbabalena nadan ma'unud hi'on waday maghob an mi'nong. Ta wada'ey i'nongda hi maghob an mi'nong ya mahapul an punnanongondah nan punggobhan ta ingganah mawi\"it. Ya mahapul bon tigonda ta adi madop nan apuy ta ingganay mabigat. ");
INSERT INTO ifa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ta nawi\"it'e ya inlubung nan padi nan linen an lubungna ya nan mundallom an lubungna ya ahina e aanon nan gubun nan naghob an ni'nong ya inha\"adnah haggon nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ya ena hinukkatan nan lubungna ya ahina e intopal nan dapul hinan mibilang hi malinis an pangitopalandah dapul an nibata\"an hinan nun'allunganyu. ");
INSERT INTO ifa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ya nan apuy hinan punggobhan hi mi'nong ya mahapul an adi madmaddop ta minaynayun an dumanaldallang. Ta hiya nan amawimawi\"it on inudman nan padi nan nitungun kayiw ya iniphodnan inyuhhun hidi nan maghob an mi'nong i diyen algo. Ya inyuhhuna bo nan taban nan mi'nong hi pi'hayyupan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ya tigonda nimpe ta nanongnan dumanaldallang nan apuy hinan punggobhan ta adi madmaddop. ");
INSERT INTO ifa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Alyon bon Apu Dios di, Datuwe boy ma'unud hi'on waday mangiyalih midawat hi alina. Ta idawat nan padi an imbabalen Aaron i ha\"on an Dios hidih nan way punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","An igamal nan padih nan alinan nadduman hi mantekan di olibo ya iniddumnan namin nan insenso an niyali ya ena ginhob hinan punggobhan hi mi'nong ta mipatigon naghob nan midawat i ha\"on. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ya nan nabatin alina ya bagin da Aaron ya nadan padin imbabalena. Mu adida udman hi yist ya hay eda panganan ya hidih nan lita\"angan nan tabernakel an pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ya iha\"angda'e ya adida nimpe udman hi yist te hinaey idat'un dida hi bingaydah nan maghob an midawat i ha\"on. Ya danae mahan ya niyappit i ha\"on an Dios an umat hinan mi'nong hi apakawanan di bahul ya mi'nong hi apakawanan di bahul an agge inatta. ");
INSERT INTO ifa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ya hay mabalin hi mangan i danae ya nadan linala'in holag Aaron ya nadan mapalpalog an tanudanah inggana. Te hidiyey midat i didah nadan maghob an mi'nong. Ta kumpulnan ida\"oman danae ya mumbalin hi niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","I diyen algon ihiitan di lana hi ulun nan mumpadi an holag Aaron ta miyappit an munhilbin ha\"on ya mahapul an inyalinay ohay kilun maphod an alina. Ta idawatnan ha\"on di godwanah nan mawi\"it ya nan godwana boh nan mun'ahdom. ");
INSERT INTO ifa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Mu hidiyen idawatna ya mahapul an udmanah mantekan di olibo ya iniphodnan ingkiwal ya inha\"angnah nan ma'uktul an pinakawan. Ta nalutu'e ya ginanodwana ya indawatnan ha''on ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ya nan mihukkat i hiya an mumpadi an mahiitan hi lanay uluna ya atbohdiy atona an gobhonan namin ta hidiyey idawatna i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ya adi mabalin hi anonda te gobhonda nimpen namin. ");
INSERT INTO ifa_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Ibagam i Aaron ya nadan linala'in imbabalena an datuwey mahapul hi unudonda hi'on nan tagun numbahul ya waday i'nongdah apakawanan di bahulda. Ta nan mi'nong ya mahapul an paltiyondah nan pumpaltiyan hi maghob an mi'nong hi hangngab nan pi'dammuwandan ha\"on an Dios te hidiye ya niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ya nan padin nangi'nong ya hiyay mabalin hi mangan mu gahin di hidih nan way lita\"angan nan tabernakel an niyappit i ha\"on an Dios di panganana. ");
INSERT INTO ifa_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ya nan ida\"oman diyen ni'nong ya mumbalin hi niyappit i ha\"on. Ya wada'ey napagi'an hi dalay lubungna ya mahapul an ena laba'an hinan pun'ulahan an niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ya hi'on inha\"angda hinan pito' an banga nan dotag an ni'nong ya mahapul an guduwonda nan banga. Mu hi'on hay nangiha\"anganda ya nan gombang an banga ya mahapul an ad'adanda ya inulahanda. ");
INSERT INTO ifa_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ya hay mabalin hi mangan i diyen ni'nong ya ammuna nadan padi ya nadan linala'in tinanudanda te niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mu hi'on nan mi'nong ya hidiye nan mi'nong hi apakawanan di bahul ta ipaghopda nan dalana hinan kuwartun niyappit i ha\"on an Dios ta a'aanan di bungot'u an gapuh bahul ya adi mabalin hi waha mangan hinan dotagna. Te mahapul an maghob an namin. ");
INSERT INTO ifa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Alyon bon Apu Dios di, Datuwey mahapul an unudonyu hi'on waday mi'nong hi apakawanan di bahul an agge inatta te hituwen mi'nong ya miyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ot paltiyonyu nan mi'nong hinan pumpaltiyan hi maghob an mi'nong. Ya nan dalana'e ya miwalaghi' hinan opat an dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ya an namin nadan tabana an ta'on on nan tabah dallom di putuna ya nan taban di iwitna ya mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ya ma'aan bo nan duwan batin ya nan tabana ya nan maphod an bongwah nan alte ya nan taban nili'mut hidi. ");
INSERT INTO ifa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ta e gobhon nan padi an namin dadiyeh nan punggobhan hi mi'nong. Ta maghob an mi'nong i ha\"on an Dios ta apakawanan di bahul an agge inatta. ");
INSERT INTO ifa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ya hay mabalin hi mangan i datuwe ya nadan padi ya nadan linala'in holagda mu hay eda panganan ya hidih nan niyappit i ha\"on. Te hidiyen makan ya niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ot hay atonda ya numpaddung damdamah nan mi'nong hi apakawanan di bahul. An midat nadan dotag an agge ni'ighob hinan padi an nangi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ya ta'on on nan up'up nan mi'nong ya midat hinan padi an mangi'nong hinan maghob an mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ya atbohdi nadan midawat an tinapay an miha\"ang hi pugun onu nan ma'uktul an pinakawan onu nan ma'ingpin pinakawan an midat hinan padin mangidawat. ");
INSERT INTO ifa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mu nadan midawat an alina an nadduman hi mantekan di olibo onu agge ya punggogodwa\"an nadan padin holag Aaron. ");
INSERT INTO ifa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Alyon bon Apu Dios di, Datuwe boy ma'unud hi'on waday mangiyalih midawat hi pi'hayyupan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Hi'on nan iyalidan mi'nong ya gapuh punhanaandan ha''on an Dios ya iddumda nan ma'uktul an tinapay ya nan tinapay an napinun alinay niphod mu agge nadduman hi yist an ammuna nan mantekan di olibo an niddum ya nan ma'ingpih an tinapay an nadanihan hi mantekan di olibo mu agge nadduman di yist. ");
INSERT INTO ifa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ya nat'on mohpe nan nadduman hi yist an tinapay an middum i dadiyen mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ta hinohha i dadiyen tinapay di idawatyun ha\"on an Dios. Ya nan nabati ya midat hinan padi an e nangiwalaghi' hinan dalan nan ni'nong hi pi'hayyupan i ha''on hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ya nan nabatin dotag hinan ni'nong hi pi'hayyupan i ha\"on ya mahapul an anonyu i diyen algon nidawatana ta ma\"id ha mabatih nan ibiggatana. ");
INSERT INTO ifa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Hi'on nan nidawat ya gapuh nangatanyuh nan imbagayun ha\"on an Dios hi atonyu onu nan ninomnomyu tuwalin i'nong ya mabalin an anonyu nan dotagna i diyen algo. Ya wada'ey nabati ya mabalin bon anonyuh nan ibiggatana. ");
INSERT INTO ifa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mu hi'on wada damdamay nabatih nan mi'atluh algo ya mahapul an gobhonyu. ");
INSERT INTO ifa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Te onha anonyu nan nabati i diyen mi'atluh algo ya hidiyey lummuh adi' pangabulutan i diyen ini'nongyu. Te mibilang moh nalugit ta ma\"id ha hilbina. Ya nan tagun mangan i diyen dotag ya madusa. ");
INSERT INTO ifa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ya hi'on waday ida''oman nan ni'nong an dotag an agge nibilang hi malinis ya mahapul an gobhonyu. Mu nan pangngelna ya mabalin an anon nadan tatagun mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ya hi'on nan tagu an agge nibilang hi nalinis ya ni''an hinan ni'nong hi pi'hayyupan i ha\"on ya mipapate ta adi mo midmiddum i da'yun tatagu' te hidiye ya niyappit i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ya atbohdih nan manapah nan nibilang hi nalugit an malpuh tagu onu nan nibilang hi nalugit an animal onu nan nunhiglan umipabungot i ha\"on an Dios ya e ni\"an hinan dotag an ni'nong hi pi'hayyupan i ha\"on. Hidiyen tagu ya mipapate ta adi midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Ibagam hinadan ibbam an tinanud Israel ta adiyu anon nan taban di baka ya gulding ya kalnero. ");
INSERT INTO ifa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ya atbohdih nan taban nan animal an namaaggot mate ya ta'on on nan animal an pinaten di atap an animal. Mu mabalin an mi'usal hi udum an iyusalana mu ta adiyu ihda. ");
INSERT INTO ifa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ot nan tagun mangan hinan taban maghob an mi'nong i ha\"on an Dios ya mipapapte ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ya atbohdin ta'on on idanay awadanyu ya hanat adiyu anon nan dalan di kumpulnan animal onu hamuti. ");
INSERT INTO ifa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Te nan tagun mangan hi dala ya mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Ibagam hinadan ibbam an tinanud Israel ta wa'e ha mangiyalih i'nongnah pi'hayyupan i ha\"on an Dios ya inaana ha kittang ta i'nongnan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ya inaana nan taba ya iniddumna nan palagpag ya intaggena nan palagpag ta idawatna i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ya e ginhob nan padi nan taba hinan punggobhan hi mi'nong mu na'en palagpag ya hidiye nan midat i da Aaron an hina'amma. ");
INSERT INTO ifa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ya ta'on on nan winawwan an hukpit nan ni'nong hi pi'hayyupan ");
INSERT INTO ifa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ya midat hinan padi an tinanud Aaron an nangi'nong hinan dala ya nan taban nan ni'nong. ");
INSERT INTO ifa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ta nan palagpag ya nan winawwan an hukpit nimpe ya midat i Aaron ya nadan padin holagna. ");
INSERT INTO ifa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Te diday niyappit hi munhilbin ha\"on an nihipun hi nihiitan di lana hi uluda. ");
INSERT INTO ifa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ta hituwey nitudduh midat hinadan padi an nahiitan di uludah lana an ma'unud hi inggana an ta'on on mapalpalogday matanudan. ");
INSERT INTO ifa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ot hiya danaey atonyuh nadan nat'onat'on an maghob an mi'nong ya nan midawat an alina ya nan mi'nong hi apakawanan di bahul ya nan mi'nong hi apakawanan di bahul an agge inatta ya nan mi'nong hi iyappitan nadan munhilbin padi ya nan mi'nong hi pi'hayyupanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ta danaey imbagan Apu Dios i Moses hi immayanah nan billid hidin awadandah nan na'appudut an boble hi ad Sinai ot ibagana bo ta ihipunda mon mangidawat i datuwe. ");
INSERT INTO ifa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Indani ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Uyugom hi Aaron ya nadan linala'in imbabalena ya inodnam nadan ilubungda ya nan lanan mihiit hi uluda ya ha bulug an baka ya ha duwah tangbal an kalnero ya ha bahket hi nattuwan hi tinapay an agge nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ya impa'ayagmun namin nadan tatagu ta ma'amung ayuh nan panton nan tabernakel an pi'dammuwanyun ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ta inunud Moses nan imbagan Apu Dios i hiya ta na'amungdan namin nadan tinanud Israel hidih nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ot alyon Moses hinadan na'amung di, Hituwey imbagan Apu Dios hi aton ta'uh ad uwani. ");
INSERT INTO ifa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ot ayagan Moses hi Aaron ya nadan linala'in imbabalena ta umedah awadana ot pun'amohona dida. ");
INSERT INTO ifa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ot ipilubungnan Aaron nan munggayyadan an lubung ot ipiwakohna nan miwakoh hi adolna ot ipilubungna bo nan adukken miyoddah. Ot ahina iyoddah nan ephod ot ihamadnan balikisan hinan balikis diyen ephod an mapmaphod di abolna. ");
INSERT INTO ifa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ot ipilubungna bo nan miyoddah hinan ephod hi palagpag nan padi ot iha''adnahdi nan Urim ya Tummim. ");
INSERT INTO ifa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ot ilipotnah ulun Aaron nan turban ot ipotto'nah way angahna nan ni'ugut an balitu' an waday tudo'na an mangipa'innilan niyappit ta munhilbi i Apu Dios. Ta inunudna nan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ot alan bon Moses nan lana ot ena walaghi'an nan tabernakel ya an namin nadan wahdi ta niyappit dadiyen Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ot ena bo walaghi'an hi lanah numpipitu nan punggobhan hi mi'nong ya an namin nadan wahdin usal ya nan ongal an besin an pun'ulahan ya ta'on on nan nipabunana ta niyappitdan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ot hiitanah lanay ulun Aaron ta niyappit damdama i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ot ayagana bo nadan linala'in imbabalen Aaron ot ipilubungnan dida nan adukken lubung di padi ot ipiwakohna nan miwakoh adolda ot ipipongotna nadan pongotda ta na'unud nadan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ot alan mohpen Moses nan bulug an baka ot iha'mon da Aaron an hina'ammay ta'ledah ulun diyen baka ta hidiyey mi'nong hi apakawanan di bahulda. ");
INSERT INTO ifa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ot paltiyon Moses hidiyen bulug an baka ot alana dohah nan dalana ot itamolnay gamatna ot ilamuhnah nadan ha'gud hinan opat an duggun nan punggobhan hi mi'nong ta wan mibilang hi malinis. Ot ena ikuyag nan nabatin dalah pu\"un nan punggobhan hi mi'nong. Ta niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ot aanon Moses an namin nan tabah dallom di putun nan pinaltina ya nadan nili'mut hinan alte ya nan duwan batin ya nan taban nili'mut hidi ot gobhonah nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mu an namin nan adol nan baka an niddum di up'upna ya lamohna ya putuna ya an namin nan lugit hi putuna ya imbata\"anah nan nun'allunganda ot hidiy pangigobhana te hidiyey imbagan Apu Dios i hiyah atona. ");
INSERT INTO ifa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ot alana bo nan tangbal an kalnero an mi'nong hi maghob ot iha'mon bon Aaron ya nadan imbabalenay ta'ledah ulun diyen kalnero. ");
INSERT INTO ifa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ot ahi bo paltiyon Moses ot ena iwalaghi' nan dalanah nan nunlini\"odan nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ot togtogona nan adol diyen kalnero ot gobhona an ta'on on nan uluna ya nadan tabana. ");
INSERT INTO ifa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ot ulahana nadan wadah dallom di putuna ya nan huki ot pi'ighobnahdih nan punggobhan hi mi'nong. Ta nan hunghungna ya umipa'amlong i Apu Dios. Ta inunud Moses nan imbagan Apu Dios i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ot alan bon Moses nan mi'adwan tangbal an kalnero an mi'nong hi pangiyappitanda i da Aaron an hina'amma. Ot iha'mon da Aaron di ta'ledah uluna ");
INSERT INTO ifa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ot paltiyon Moses. Ot alana bo dohah nan dala ot idanihna hinan winawwan an ingan Aaron ya nan winawwan an am'ama\"an di ta'lena ya ta'on on nan winawwan an am'ama\"an di hukina. ");
INSERT INTO ifa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ot ayagana bo nadan linala'in imbabalen Aaron ot alana bo dohah nan dala ot idanihnah nan winawwan an ingada ya nan winawwan an am'ama\"an di ta'leda ya hukida. Ot alana nan nabatin dala ot ena pun'iwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ot aanona nan tabah nan iwitna ya an namin nan tabah dallom nan putu an umat hinan nili'mut hinan alte. Ot aanona bo nadan duwan batin ya nan tabana. Ya inaana bo nan winawwan an hukpit. ");
INSERT INTO ifa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ot alanay hinohhah nadan nat'onat'on di ha\"angnan tinapay an agge nadduman hi yist. Ot iyuhhunah nadan taba ya nan winawwan an hukpit. ");
INSERT INTO ifa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ot ipadona i da Aaron an hina'amma dadiye ot itaggedan idawat i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ot ahi boltanon Moses i dida ot pi'ighobnah nan maghob an mi'nong i Apu Dios. Ta hidiyey mi'nong hi iyappitan nadan padin munhilbin Apu Dios. Ot nan hunghungna ya umipa'amlong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ot alan Moses nan palagpag di kalnero ot itaggena ta midawat i Apu Dios ot alanah diye ta pahingna. Ta inunud Moses an namin nan imbagan Apu Dios hi atona. ");
INSERT INTO ifa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ot alana dohah nan lana ya nan dalah nan punggobhan hi mi'nong ot iwalaghi'na i da Aaron an hina'amma ya hinan lubungda. Ta mangipa'innilan niyappitdan hina'amman munhilbin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ot alyon Moses i da Aaron an hina'ammay, Eyu iha''ang tun dotag hinan way panton nan tabernakel ya inanyuhdi hinadan tinapay an ni'nong hi niyappitanyun munhilbin Apu Dios. Te hiyay imbagan Apu Dios hi ma'at. ");
INSERT INTO ifa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ya wada'ey mabatih nan dotag ya tinapay ya ginhobyu. ");
INSERT INTO ifa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ya mahapul an hidih nan way panton nan tabernakel di umohnonganyu ta ingganah mapungpung nan pituy algo an iyappitanyun munhilbin Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ot nan inat ta'uh ad uwanin algo ya hiya datuwey imbagan Apu Dios hi ma'at ta a'aanan di bungotna an gapuh bahul. ");
INSERT INTO ifa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ot hiya nimpe nan umohnong ayu ni' hituh nan way panton nan tabernakel hi pituy algo an ta'on on hinan hilong ta atonyu nadan imbaganah atonyu. Ot mahapul an adiyu ibahho ta adi lummuh atayanyu te hituwey imbagan Apu Dios nimpeh ma'at. ");
INSERT INTO ifa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ta inun'unud Aaron ya nadan imbabalenan namin nadan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hidin mi'awaluh algo hi immohnongan da Aaron hinan way panton di tabernakel ya inayagan Moses hi Aaron ya nadan linala'in imbabalena ya nadan ap'apun di himpahimpamu'un an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ot alyon Moses i Aaron di, Em alan ha kilaw an baka an ma\"id ha bahbahna ta mi'nong hi apakawanan di bahul ya ha tangbal hi kalnero an ma\"id damdama ha bahbahna ta maghob an mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ya imbagam hinadan ibba ta'un tinanud Israel ta iyaliyu ha ma\"id ha bahbahnan tangbal an gulding ta i'nongyuh apakawanan di bahul ya ha kilaw an baka ya ha kalnero an hinohhay tawonda ya ma\"id ha bahbahda ta maghob an mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ya nat'on bo nan bulug an baka ya nan tangbal an kalnero ta mi'nong hi pi'hayyupan i Apu Dios. Ya ha alina an nadduman hi mantekan di olibo ta midawat i Apu Dios. Ta atonyun namin datuwe te ad uwanin algoy pumpatigan Apu Dios i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ta inyen nadan tatagun namin dadiyen imbagan Moses hinan way panton nan tabernakel ot ma'amungdan namin hidi ot dayawondah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ot alyon Moses i diday, Hi Apu Dios di nangibaga an aton ta'u datuwe ta wan mipatigoy anabaktunan dita'u. ");
INSERT INTO ifa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ot alyon Moses i Aaron di, Ume'ah nan way punggobhan hi mi'nong ta i'nongmu nan mi'nong hi apakawanan di bahulmu ya nan maghob an mi'nong ta a'aanan di bungot Apu Dios an gapuh bahulmu ya ahim mohpe i'nong nan mi'nong hi a'aanan di bungot Apu Dios an gapuh bahulmin tatagu. Ta ma'unud nan imbagan Apu Dios hi ma'at. ");
INSERT INTO ifa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ot umeh Aaron hinan way punggobhan hi mi'nong ot paltiyona nan kilaw an baka an mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ot idat nadan padin imbabalena nan dala i hiya ot itamolnay gamatnah nan dala ot ilamuhnah nadan ha'gud hinadan duggun nan punggobhan hi mi'nong. Ot ahina e ikuyag nan nabatin dalah nan pu\"un nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ot gobhona nadan taba ya nan duwan batin ya nan maphod an bongwah nan alten diyen mi'nong hi apakawanan di bahul hinan punggobhan hi mi'nong ta inunudna nan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ya an namin nan dotagna an nunnanong di up'upna ya imbata\"andah nan nun'allunganda ot ahi gobhon Aaron. ");
INSERT INTO ifa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ot paltiyon bon Aaron nan maghob an mi'nong. Ot idat nadan imbabalena nan dala ot ena iwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ot idatda bon hiya nadan natogtog an dotag ya nan ulu ot gobhonah nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ot ulahanan namin nan minalutun nan baka ya nadan hukina ot iyuhhunah nan maghob an mi'nong ta mi'ighob hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ot ena alan nan gulding an mi'nong hi apakawanan di bahul nadan tatagu ot paltiyona. Ot i'nongna an umat hinan inatnah nan namangulun ini'nongnah apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ot alana bo nan maghob an mi'nong ot i'nongnan inunudna nan nibagan atona. ");
INSERT INTO ifa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ot igamalnah nan midawat an alina ot pi'ighobnah nan maghob an mi'nong i diyen nawi\"it. ");
INSERT INTO ifa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ot paltiyona bo nan baka ya nan tangbal an kalneron mi'nong hi pi'hayyupan nadan tatagu i Apu Dios. Ot idat nadan imbabalena nan dala ot ena pun'iwalaghi' hinadan dingding nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mu nan taban'en nan baka ya nan kalnero ya nan iwitda ya nadan batin ya nan nihophop hinadan alte ");
INSERT INTO ifa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ya inyuhhun nadan imbabalen Aaron hinan palagpag ot ahi iyen Aaron nadan taba hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mu nada'en palagpag ya nadan winawwan an hukpit ya intaggena ot idawatnan Apu Dios ta miyunnudan hinan imbagan Apu Dios i Moses hi ma'at. ");
INSERT INTO ifa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ta hidin ini'nong Aaron an namin nadan mi'nong hi apakawanan di bahul ya nan maghob an mi'nong ya nan mi'nong hi pi'hayyupan i Apu Dios ot itaggenay ta'lena ot wagahana nadan tatagu ot duma\"ul mohpeh nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ot ahi hunggop da Moses i Aaron hinan tabernakel. Ta hidin limmah'unda ot wagahanda nadan tatagu ya nipatigon didan namin nan mumbinang an mangipa'innilah anabaktun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ya nalanggiyab han apuy an nalpun Apu Dios ot gobhonan namin nadan maghob an mi'nong i Apu Dios an wah nan punggobhan hi mi'nong. Ya hidin tinigon nadan tataguh diyen na'at ya ahitutukukdah amlongda ot inayundan munlu'bub ot dayawondah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nan duwan linala'in imbabalen Aaron an da Nadab i Abihu ya inalada nan punggobhandah insenso ot ittuwandah bala ot udmandah insenso ot idawatdan Apu Dios. Mu bokon athidiy inalin Apu Dios hi atonda ");
INSERT INTO ifa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ta nalanggiyab han apuy an impa'alin Apu Dios ot patayona didah nan way tabernakel an pi'dammuwan i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ot alyon Moses i Aaron di, Hiyah naey pohdon Apu Dios an ibagah din pangalyanay, Mahapul an an namin di munhilbin ha''on ya innilaonda nan a'at'un Dios. Ta an namin di tatagu ya ha\"on di ipabaktuda. Mu hi Aaron ya namaaggot dindinnongan. ");
INSERT INTO ifa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ot ayagan Moses da Misael i Elsapan an imbabalen Usiel an hi ulitaun Aaron ot alyonan diday, Eyu aanon dadiyen adol nadan amuna'onyu ta ibata\"anyuh tun nun'allungan ta'u ya tun pundayawan ta'u i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ot umeda mo ot eda ibata\"an dida an inidondah lubung dadiyen nate an inunudda nan imbagan Moses. ");
INSERT INTO ifa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ot alyon Moses i Aaron ya nadan nabatin imbabalenan da Eleasar i Itamar di, Adiyu gungalon di ibu'yu ya adiyu hetheton di lubungyu ta adi ayu umukayungan te atonyu'ehdi ya mate ayu ya milaggatda tudan tatagu an gapuh bungot Apu Dios. Mu nadan ibba ta'un tinanud Israel ya mabalin an ipatigoda an umukayungandah namatayan diyen apuy Apu Dios i dadiyen duwa. ");
INSERT INTO ifa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ya adi ayu umaan hitun panton tun pi'dammuwan ta'un Apu Dios te mate ayu. Te da'yu ya niyappit ayu an munhilbin Apu Dios an nihipun hi nihiitan di lanah uluyu. Ot unudondah diyen imbagan Moses. ");
INSERT INTO ifa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Alyon Apu Dios i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Adi ayu uminum hinadan imbabalem hi bayah ya nadan udum an bumutong hi'on ayu hunggop hinan tabernakel te atonyu'ehdi ya mate ayu. Ot mahapul an unudonyuh tuwe an ta'on on hanadan mun'atanudan an munhilbin padi. ");
INSERT INTO ifa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ta adi ayu nimpe uminum ta way atonyun mangimatun hinadan niyappit i ha\"on an Dios ya nadan agge ya ta'on on nadan mibilang hi malinis ya nadan mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ya mahapul an itudduyuh nadan ibbayun tinanud Israel an namin nadan tugun an imbaga' i Moses. ");
INSERT INTO ifa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ot alyon Moses i Aaron ya nadan agge ni'yaten linala'in imbabalenan da Eleasar i Itamar di, Alanyu nan nabatih nan nidawat i Apu Dios an agge naghob an alina ta apyonyuh tinapay an adi madduman hi yist ta anonyuh haggon nan punggobhan hi mi'nong te niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ta anonyuhdi te niyappit nimpe i Apu Dios. Ya hidiyey midat i da'yun hina'amma hinadan maghob an midawat an alina. Te datuwey inalin Apu Dios i ha\"on hi mahapul an ma'at. ");
INSERT INTO ifa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ya nan palagpag an mitaggen midawat ya nan hukpit nan mi'nong hi pi'hayyupan i Apu Dios ya mabalin an anonyun hina'amma te hidiyey midat i da'yun hina'amma an nalpuh nadan ini'nong nadan ibbayun tinanud Israel hi pi'hayyupandan Apu Dios. Mu gahin on anonyuhdi hinan mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ot mahapul an midat i da'yu nadan nitagge an nidawat an palagpag ya nan hukpit an agge niddum hinadan maghob an taba. Ta datuwey pahingyun hina'ammah inggana an ta'on on hanadan mun'atanudan. Te datuwey inalin Apu Dios hi mahapul an ma'unud. ");
INSERT INTO ifa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ot mahmahan Moses i Aaron di na'at hinan gulding an ni'nong hi apakawanan di bahul di tatagu. Ya hidin na'inilaanan nalpah an naghob ya nunhiglay boholna i da Eleasar i Itamar. ");
INSERT INTO ifa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ot alyonan diday, Tanganu onyu agge inan hidiyen ni'nong hi apakawanan di bahul hidih nan niyappit an pangananyu? Hidiye ya niyappit i Apu Dios an indatna i da'yu ta i'nongyu ta a'aanan di bungotna an gapuh bahul ta'un tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ya gapu ta agge niye nan dalanah nan kuwartun Apu Dios ya unhaot inihdayuhdi hinan pi'dammuwan i Apu Dios te hiya tuwaliy imbaga' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mu hay nambal Aaron ya alyona di, Nomnomnomom an nan duwan imbabale' ya manu te ini'nongdah ad uwani nan mi'nong hi apakawanan di bahul nadan tatagu ya nan maghob an mi'nong i Apu Dios mu teen naghobda. Ot undan nin mipa'amlong hi Apu Dios hi'on inan'uh ad uwani nan ni'nong hi apakawanan di bahul di tatagu? ");
INSERT INTO ifa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ya nipa'amlong hi Moses hi nangngolanan diye. ");
INSERT INTO ifa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Ibagayuh nadan ibbayun tinanud Israel an hay mabalin hi ihdayuh nadan animal an wahtun luta ya ");
INSERT INTO ifa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","nadan nagodway kukubda ya pidwondan taptapon di anonda. ");
INSERT INTO ifa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ya hay adiyu ihda ya nan kemel te ta'on hi pidwonan taptapon nan anona mu agge nagodway kukubna ta hiya nan mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ya atbohdi nan buwot ");
INSERT INTO ifa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ya nan kuneho an manu te pidwondan taptapon nan anonda mu agge nagodway kukubda ta hiya nan mibilangdah nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ya adiyu bo ihda nan babuy te ta'on hi nagodway kukubna mu mibilang hi nalugit te adina pidwon an taptapon nan anona. ");
INSERT INTO ifa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Danaen animal di adiyu ihda ya adiyu dapaon di adolda hi'onda nate te mibilangda nimpeh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ya an namin nadan ma'alah nan way liting an waday uhipna ya higalna ya mabalin an anonyu. ");
INSERT INTO ifa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mu an namin nadan ma\"id ha uhipna ya higalna ya adiyu ");
INSERT INTO ifa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","te dadiye nadan mibilang hi nalugit ot adiyu anon onu dapaon hi'onda nate. ");
INSERT INTO ifa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ot an namin nimpe nadan wadah nan nalitingan an ma\"id ha uhipna onu higalna ya mibilangdah nalugit ta adiyu anon. ");
INSERT INTO ifa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ya hanadan hamutin adiyu anon te paniyo ya nan agila ya nan halagma ya nan gayang ");
INSERT INTO ifa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ya nadan nat'onat'on an balug ");
INSERT INTO ifa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ya an namin nadan nat'o'nat'on an rabin ");
INSERT INTO ifa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ya nan ay naha'gudan an akup ya nan akup an mihaggon hinan boble ya nan gull ya nadan nat'o'nat'on an pippiwong ");
INSERT INTO ifa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ya nan kittang di a'akupna ya nan kormorant ya nan tukukan ");
INSERT INTO ifa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ya nan pulaw an akup ya nan akup hinan agge naboblayan ya nan gayang an mangan hi dolog ");
INSERT INTO ifa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ya nan hulin ya nadan nat'o'nat'on an dolwa' ya nan hoopoe ya nadan littalit ya panni'i. ");
INSERT INTO ifa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ya an namin nadan insekto an tumayap ya idallanday opat an hukida ya mibilangdah nalugit ta adiyu anon. ");
INSERT INTO ifa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mu mabalin an anonyu nadan napaya'an an nahu''up di hukida ya ipaytu'day pangeda ");
INSERT INTO ifa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","an datuwe nadan nat'onat'on an dudun ya nadan dulduli ya lellel ya nadan ba\"atong. ");
INSERT INTO ifa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mu nadan udum an napaya'an an ikadapday pangeda ya adiyu anon. ");
INSERT INTO ifa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ya nan tagun waday dinapanah nate i danae ya mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Mu niluh'en waday dinapayuh nate i danaen mibilang hi nalugit an animal ya pa'ibagonyun e laba'an nan inlubungyu. Mu hiyah diye damdaman mibilang ayuh nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ot nadan animal an nagodway kukubda mu adida pidwon an taptapon nan anonda ya mibilangdah nalugit. Ot hi'on waday dapaonyuh nan kumpulnan mate i danaen animal ya mibilang ayuh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ya an namin nadan opat di hukina an waday komongna ya adi mabalin hi anonyu te mibilangdah nalugit. Ot hanan manapah nan adol datuwe hi'onda nate ya mibilangdah nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ot nan waday dinapanah nate ya mahapul an ena laba'an nan inlubungna mu hiyah diye damdaman mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ya mibilangda boh nalugit nadan udum an mundallanan hitun luta an umat hinan buwot ya gelew ya nadan nat'o'nat'on an o\"ongal an banniya ");
INSERT INTO ifa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ya nan bambanaggo ya nan buwaya ya nan alibut ya nan banniyah nan awadan di panag ya nan kallulu. ");
INSERT INTO ifa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ot nan tagun manapa i danae hi'onda nate ya mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ya kumpulnan gina'un ida\"oman nan naten animal an umat hi luput onu lalat onu pina'ot an usal onu langgut ya mibilang hi nalugit. Ta gahin on ulahan ta malinisan mu mibilang damdamah nalugit hi ingganah mahdom ya ahi mohpe mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ya onha nan pito' an banga di nagahan nan nate i datuwe ot an namin nan niha\"ad hidi ya mibilangdah nalugit ta mahapul an guduwon nan banga. ");
INSERT INTO ifa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ya an namin nan makan onu liting an ma'inum an natodtodan hinan liting an nalpu i diyen banga ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ot kumpulnan gina'un pito' di niyamma an umat hi banga onu kumpulnan pugun an punha\"angan hi tinapay an waday nagah hidin nate an mibilang hi nalugit ya mahapul an mapa\"ih te mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mu nan obob onu nan pangi'amungan hi liting ya ta'on on waday nagah hidin nate an mibilang hi nalugit ya hiyah diyen mibilang hi malinis an ammuna nan tagun manapa i diyen nate di mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ya hi'on nan kumpulnan mitanom di nagahan nan nate ya adi mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mu hi'on ni'upol hi liting nan tanom ya hidiy nagahan nan naten animal ya mibilang moh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ya onha nan mibilang hi malinis an animal di nate ya nan adolna ya mibilang hi nalugit ot nan manapa i diyen nate ya mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ya nan tagun manapa onu mangan hinan lamoh diyen naten animal ya mahapul an ena laba'an di lubungna mu hiyah diye damdaman mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ya an namin nadan kikkitang an animal hitun luta ya adi makan te nibilangdah nalugit ");
INSERT INTO ifa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","an umat hinan ulog an ibuluhdan ume ya nadan udum an opat di hukida ya nadan umat hi palikutkut an dakol di hukida. ");
INSERT INTO ifa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ot tigonyu ta adi gumalat danaen animal hi ibilanganyu damdamah nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ha\"on an hi Apu Dios an dayawonyu ya nahamad di a'at'u ot mahapul an inghona' ta mipatigoy niddumanyun ha\"on. Ot halipodpodonyu ta adi gumalat danaen animal hi ibilanganyuh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ha\"on hi Apu Dios an nangikak i da'yuh ad Egypt ta wan ha\"on di dayawonyu ot mahapul an inghona' te ha\"on ya nahamad nimpey a'at'u. ");
INSERT INTO ifa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ot danaey mahapul an ma'at hinadan animal ya nadan hamuti ya an namin nadan munwannatan hitun luta ya atbohdih nadan wah nan liting. ");
INSERT INTO ifa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ta mahapul an innilaonyu hi'on nganne dadiyen matagun animal an mibilang hi nalugit an adi makan ya nadan makan te mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Ibagam hinadan ibbam an tinanud Israel an nan babain hiyah nun'ayyam ya mibilang hi nalugit hi pituy algo hi'on lala'i nan inyayyamna. Ya hinan pituy algo ya umat damdamah nan umaliyan di binulan an malpuh adolna an mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ya hinan mi'awaluh algo ya mahapul an makugit nan golang. ");
INSERT INTO ifa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ya inggana damdama boh on mala\"uy tulumpulut tuluy (33) algo ya ahi mabalin an mibilang mohpeh diyen nun'ayyam hi malinis hinan na'aan an dalah adolnah din nun'ayyamana. Ya i diyen himbulan ya mipagol hi ena panapaan hinadan niyappit i Apu Dios an usal. Ya adi mabalin hi umeh nan tabernakel te mipagol ta ingganah magibbuh nan nagtud an algon pumpalinisana. ");
INSERT INTO ifa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mu wa'et babai nan inyayyamna ya mibilang hi nalugit hi duway duminggu an umat damdamah nan umaliyan di malpuh adolna. Ta ingganah mala\"uh boy nanom ta han onom (66) di algo ya ahi mabalin an mibilang hi malinis an gapuh nun'ayyamana. ");
INSERT INTO ifa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ya wa'et nagibbuh nan nagtud an algon pangi'imohana ya inyena mohpe ha ohay tawonah kalnero hinan padi hinan way panton nan tabernakel. Ta i'nong nan padi hi maghob an mi'nong i ha''on an Dios ya ha palluma ta mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ta i'nong nan padi dadiye ta a'aanan di bungot'un Dios an gapuh bahulna. Ta nalpah'e ya mabalin mohpen mibilang hi malinis hidiyen nun'ayyam. ");
INSERT INTO ifa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mu alina'eh on adi abalinan diyen babai nan kalnero ya mabalin an ha duwah balug onu ha duwah palluma ta maghob an mi'nong nan oha ya mi'nong hi apakawanan di bahulna nan oha. Athidiy aton nan padi ta a'aanan di bungot'un Dios an gapuh bahulna ta mibilang mohpeh malinis hidiyen nun'ayyam. ");
INSERT INTO ifa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Hi'on namaag ya wada ha linum'a' hi up'up di ohan tagu onu ha pimmidaang ya ma\"id ha mapto' ya mumbalin hi gulid. Ot mahapul an ena ipatigoh nan padin hi Aaron onu ha ohah nadan padin holagna. ");
INSERT INTO ifa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ta tigonda'e an pimmulaw nan dutdut an nipto' hinan pimmidaang an dimmallom ya mabalin an hidiye nan gulid an mangal'aldan hi udum. Ot ibagan mon nan padi an hidiyen tagu ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mu onha tigon nan padi nan up'up ya pimmulaw mu agge dimmallom ya agge pimmulaw nan dutdut an nipto' hidi ot hay atona ya ibagana ta e mihiwweh diyen taguh pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ta hinan mi'apituh algo ya ahina bo e tigon ya hiya'eh diyen nunnanong an agge niwakat nan pimmidaang hi up'upna ya inaynayunan ihiwwe boh pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ya hinan mi'apitu boh algo ya ena tigon ta nama\"id'e ya ibagana mohpen hidiyen tagu ya ma\"id ha bahbahna an on pimmidaang ya abuh. Mu mahapul an e ilaba' diyen tagu nan lubungna ta ahi mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mu onha indani ya tinigon diyen tagun mun'abitbit nan pimmidaang hi up'upna ya mahapul an ena bo ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ta tinigon'en nan padi an mun'abitbit nan pimmidaang hi up'upna ya ibagana mon hidiyen tagu ya mibilang hi nalugit te hidiye nan gulid an mangal'aldan hi udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ot athidiy ma'at an nan tagun waday gulidnan mangal'aldan hi udum ya mahapul an ena ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ta tigon'en nimpen nan padi an waday pimmidaang hi up'upna ya pimmulaw nan dutdutna ");
INSERT INTO ifa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ya hidiyey itiganan waday gulidnan mangal'aldan hi udum ta hiya nan ibagan mon nan padi an hidiyen tagu ya mibilang hi nalugit. Ta adi mo gahin ona hadhaddon te na'innila mo an mibilang hi nalugit hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Mu hi'on tigon nan padi ya namaag ya niwakat nan pimmidaang hi an namin an up'upna an mihipun hi uluna ta ingganah dapana ");
INSERT INTO ifa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ya bokon hidiye nan gulid an mangal'aldan hi udum. Ot ibagan mon nan padi an adi mo mibilang hi nalugit hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mu hi'on nabtak nan up'up ta matigo nan lamoh ya mibilang hi nalugit hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ot nan padi ya ibaganan waday bahbah diyen tagu ta mibilang moh nalugit te mangal'aldan hi udum nan gulidna. ");
INSERT INTO ifa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mu hi'on alina ya pimmulaw nan lamoh ya mahapul an ena bo ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ta tigon'en nan padi an pimmulaw nan up'up ya ibaganan mibilang mo hi malinis hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ya onha waha taguh napoghaan ot mapoyanan ");
INSERT INTO ifa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ya alina'e boh on pimmidaang nan nipoyanana ya mahapul an ena bo ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ya onha tigon nan padi ya inoy an dimmallom nan pimmidaang hi nunlini\"odan nan napoyanan an pogha ya pimmulaw nan dutdut hidi ot ibagana mon hidiyen tagu ya mibilang hi nalugit te nan gulidna ya mangal'aldan hi udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mu tigon'en nan padi an agge pimmulaw nan nipto' hidin dutdut ya agge dimmallom nan pimmidaang mu on mun'apoyanan ya ibagan nan padi i hiya ta mihiwweh pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mu mala\"uh'ey pituy algo ya mun'abitbit nan pimmidaang ya ibagan nan padi an hidiyen tagu ya waday gulidnan mangal'aldan hi udum ta mibilang moh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mu hiya'eh diyen adi maluman ya adi mabitbit an on tuwali hidiye nan kilah di pogha ot nan padi ya ibaganan hidiyen tagu ya mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ya onha waha na'atungan ta pimmidaang nan up'upna ");
INSERT INTO ifa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ot mahapul an ena ipatigoh nan padi. Ta tigon'en nan padi an pimmulaw nan dutdut an nipto' hidi ya dimmallom nan pimmidaang ot hidiyen na'atungan ya numbalin hi gulid an mangal'aldan hi udum. Ot ibagan nan padi an hidiyen tagu ya mibilang hi nalugit te waday gulidnan mangal'aldan hi udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mu hi'on tigon nan padi ya agge pimmulaw nan dutdut an nipto' hidi ya agge dimmallom nan pimmidaang ya mahapul an ibagan nan padi ta e mihiwwe boh diyen tagu hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ya ahina bo e tigon hinan mi'apituh algo ta mun'ihinap'eh adolna ya ibagan mon nan padi an hidiyen tagu ya mibilang hi nalugit te waday gulidnan mangal'aldan hi udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mu hi'on ma\"id mo nan pimmidaang ta ammuna nan kilah nan na'atungan hinan up'upna ya hidiyey itiganan bokon gulid. Ta mabalin an ibagan nan padin mibilang hi malinis hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ya hi'on wada ha nagulidan di uluna onu hi pangalna ");
INSERT INTO ifa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ya ena ipatigoh nan padi ta tigon'en nan padi an dimmallom nan pimmidaang hinan up'upna ya nat'on nan ibu' an nipto' hidi an ay inunig ya kikkitang ya ibagan mon nan padi an hidiyen tagu ya mibilang hi nalugit te hidiyen gulid hi uluna onu hay pangalna ya mangal'aldan hi udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mu ma\"id'e ha mangitit an ibu' hinan awadan di gulidna ya agge dimmallom ya ibagan nan padi ta e mihiwweh diyen tagu hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ya ahina bo e tigon hinan mi'apituh algo ta agge'e nihinap ya agge naluman nan ibu' an nipto' hidi ya agge bo dimmallom nan gulidna ");
INSERT INTO ifa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ya mahapul an upuhan diyen taguy ibu'na ya balbasna ta ammuna nan nagulidan hi mabati. Ya e mihiwwe bo hi pitu boy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ta hinan mi'apituh algo ya ahina bo e tigon. Ta agge'e nihinap hi adol diyen tagu nan gulid ya ibaganan mibilang moh malinis hidiyen tagu. Ta e mohpe laba'an diyen tagu nan lubungna ta mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mu hi'on nalpah an imbagan nan padi an mibilang hidiyen taguh malinis ya indani ya nihinap nan gulidna ");
INSERT INTO ifa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ot adi mo gahin on tigonah on waday ay inunig an ibu' hinan nipto' hidi te na'innila mon hidiyen tagu ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mu hi'on tigon nan padi an agge nihinap ya mangmangitit nan ibu' an manuluh nan nipto' hidi ya mibilang moh malinis. Ot ibagan mohpen nan padi an hidiyen tagu ya mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ya onha waha lala'i onu babai hi matigo an waday pimmulaw hi up'upna ");
INSERT INTO ifa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ya mahapul an ena ipatigoh nan padi. Ta tigona'en adi ma'apullaw ya adi mitakut hidiye ot hidiyen tagu ya mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Nan lala'in nagah di ibu'na ta natuga'an ya mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ya ta'on on nan napultakan di ulunah nangappit hi angahna ya mibilang hi malinis te bokon bahbah hidiye. ");
INSERT INTO ifa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mu alina'eh on waday pimmidaang an gulid hinan tugga' diyen tagu an hidiye nan gulid an mangal'aldan hi udum ");
INSERT INTO ifa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ya tigon'en nan padi ta linum'a' hidiyen umat hi gulid an mangal'aldan hi udum ");
INSERT INTO ifa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ya mahapul an ibaganan hidiyen tagu ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ot nan tagun waday gulidnan mangal'aldan hi udum ya mahapul an munlubung hinan nun'ahethet an lubung ya aggena hinugud di ibu'na ya hinophopanay angahna ya initku'itkuknay, Mibilanga' hi nalugit! Mibilanga' hi nalugit! ");
INSERT INTO ifa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ta hidiyen tagu ya mibilang hi nalugit hi ingganah ma'agahan i diyen gulidna. Ta hiya nan mahapul an e mibata\"an hinan nun'allungan di tatagu ta e munhiwwe. ");
INSERT INTO ifa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Hi'on waday tigonyun bimmu\"ut hinan luput an nadutdutan onu nan agge ");
INSERT INTO ifa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ya ta'on on nan na'abol onu nan lalat an na'apyah lubung onu nadan udum an usal ");
INSERT INTO ifa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ya hi'on munlangta onu ay udungo onu mumbolah di tigona ya mahapul an eyu ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ta tigon'en nan padi an waday bu\"ut hinan luput ya ihiwwenah diyeh pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ta hinan mi'apituh algo ya ena bo tinigo ta nihinap'eh diyen bu\"ut ya mahapul an ibaganan mibilang hi nalugit hidiyen luput. ");
INSERT INTO ifa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ot mahapul an gobhonda ta adi midalhin hinadan udum. ");
INSERT INTO ifa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mu hi'on tigon nan padi an maphod te agge nihinap ");
INSERT INTO ifa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ya ena ipalaba' hinan ud luput ya impipa\"enan hiyah pitu boy algo. ");
INSERT INTO ifa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mu hi'on nalaba'an ta tigon nan padi ya agge na'aan nan bu\"ut ya mahapul an maghob an ta'on on agge nihinap nan bu\"utna. ");
INSERT INTO ifa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mu hi'on tigon nan padi ya mun'a'aan nan bu\"utna ya hethetona ta ma'aan nan nipto'ana. ");
INSERT INTO ifa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Mu alina'eh nawada bo damdama ya mahapul mon gobhon nan ud bagi hidiyen luput. ");
INSERT INTO ifa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mu hi'on inlaba'na ya na'aan ya pidwona damdaman laba'an ta ahi mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ot hiya danaey nan nitugun hi ma'unud hi'on waday luput an nadutdutan onu linen onu na'abol onu lalat an waday bu\"utna ta ma'innilaan hi'on nan luput ya mibilang hi malinis onu nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Nan tagun napoyanan nan gulidna ya mahapul an tigon ni' nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ta ume nan padi hi awadana an nibata\"an hinan nun'allungan nadan tatagu ta ena idodongan hi'on immannung an napoyanan nan gulidna. ");
INSERT INTO ifa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Ta napoyanan'e ya ena impa'ala ha duwan hamuti ya ha naptung an sedar ya ha linubid hi mumbolah ya nan ma'alih haysop. ");
INSERT INTO ifa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ta inyeda'e ya imbagan nan padi ta gogodonay ohah nan hamuti ya impa'ayuhna nan dalanah nan bangan nattuwan hi liting an pa'ahhagub. ");
INSERT INTO ifa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ya inalana bo nan ohan hamuti ya nan naptung an sedar ya nan linubid ya nan ma'alih haysop ya intamolna i diyen banga. ");
INSERT INTO ifa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ya ahina mohpe e inwalaghi' dadiyen intamolna hi mumpipituh nan tagun napoyanan nan gulidna ta hituwey ohah mahapul an ma'at ya ahi mabalin an mibilang hi malinis. Ya innayunan impatayap nan hamuti ta ume. ");
INSERT INTO ifa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ya e inlaba' diyen taguy lubungna ya inupuhanan namin nadan dutdut hi adolna ya e nun'amoh. Ta mabalin mohpen umeh nan nun'allunganda. Mu adi ni' damdama hunggop hinan allungna an umohnong hinan dola ta ingganah on mala''uh di pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ta hinan mi'apituh algo ya inupuhana nadan ibu' hi uluna ya balbasna ya kidena ya an namin nadan dutdut hi adolna ya e nun'amoh ta atona nan nibagan atona. ");
INSERT INTO ifa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ya hinan mi'awaluh algo ya inyena ha duwan tangbal an kalnero ya ha ohah tinna an ohay tawona an ma''id ha bahbahda. Ya ni'yalana ha umeh tuluy kilun napinun alina an nadduman hi lanan di olibo ya ha ohay basun lanan di olibo. ");
INSERT INTO ifa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ya inyen nan padih diyen tagu ya nadan i'nongnah nan way panton nan tabernakel an pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ya inalan nan padi di ohah nadan tangbal an kalnero ta mi'nong hi apakawanan di bahul diyen tagu ya iniddumna ha ohay basun lanan di olibo ya intaggena ta midawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ya pinaltinah diyen kalnero hinan niyappit i ha\"on an Dios an pumpaltiyandah nan mi'nong hi apakawanan di bahul ya nan maghob an mi'nong. Ya hay atonda ya umat hinan mi'nong hi apakawanan di bahul ya nan mi'nong hi apakawanan di bahul an agge inatta an nan padi ya ammunay idatana te hidiye ya nidawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ya inalan nan padi dohah nan dalan diyen kalneron ni'nong ya indanihnah nan winawwan an ingan diyen tagu ya nan winawwan an am'ama\"an di ta'lena ya hukina. ");
INSERT INTO ifa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ya inhiit nan padi dohah nan lanan di olibo hinan iniggid an paladna. ");
INSERT INTO ifa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ya initdo'na nan winawwan an lodlodongna ya inwalaghi'nah mumpipituh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ya impu'nahna dohah nan lanan nabatih paladna hi winawwan an ingan diyen tagu ya nan winawwan an am'ama\"an di ta'lena ya hukina. ");
INSERT INTO ifa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ya inlamuh nan padi hi ulun diyen tagu nan nabatin lanah ta'lena. ");
INSERT INTO ifa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ya ahina mohpe e i'nong nan mi'nong hi apakawanan di bahulna ta nagibbuh'eh diye ya ena mohpe pinalti nan maghob an mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ya iniddumna nan midawat an alina hinan punggobhan hi mi'nong ta atona nan nibagan atona ta wan mibilang hi malinis hidiyen tagu. ");
INSERT INTO ifa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mu hi'on adina abalinan nan duwa ya ta'on on ha ohah tangbal an kalnero ta mi'nong hi apakawanan di bahulnan aggena inatta ta mitaggen midawat i ha\"on an middum ha ohay kiluh nan napinun alina an nadduman hi mantekan di olibo ya ha ohay basun mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ya inudmanah duway palluma ta mi'nong hi apakawanan di bahulna nan oha ya maghob an mi'nong nan oha. ");
INSERT INTO ifa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ta hinan mi'awaluh algo ya iyen diyen tagu datuweh nan padi. Ta midawatda i ha\"on an Dios hidih nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ta alan nan padi nan kalnero ya nan mantekan di olibo ya intaggena ta mitaggen midawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ya innayunan pinalti nan kalnero ya inalana dohah nan dalana ya impu'nahnah nan winawwan an ingan nan tagun nipaphod ya hinan am'ama\"an nan winawwan an ta'lena ya hukina. ");
INSERT INTO ifa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ya inhiit bon nan padi dohah nan lanah iniggid an paladna. ");
INSERT INTO ifa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ya initdo'nahdiy lodlodongna ya inwalaghi'nah mumpipituh nan tabernakel an pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ya inlamuhna dohah nan lanah winawwan di ingan diyen tagu ya hay winawwan an am'ama\"an di ta'lena ya hukina. ");
INSERT INTO ifa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ya nan nabatin lanah palad nan padi ya ilamuhnah ulun diyen tagu ta a'aanan di bungot'un Dios an gapuh bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ya ahi mohpe i'nong nan padi nan duwan palluma. ");
INSERT INTO ifa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ta nan oha ya mi'nong hi apakawanan di bahul diyen tagu ya nan oha ya maghob an mi'nong i ha\"on an Dios an middum nan midawat an alina. Ta danaey aton nan padi ta a'aanan di bungot'un Dios an gapuh bahul diyen tagu ta ahi mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ta datuwey ma'unud hi aton nan tagun waday gulidna an mangal'aldan hi udum an adina abalinan nan nibaga tuwali an mi'nong ta ahi mohpe mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wa'et dumatong ayuh nan bobleh ad Kanaan an idat'un da'yu ta eyu punhituwan ya wada'ey iha\"ad'uh bu\"ut hi ohan balehdi an mabalin an mihinap i diyen pumboblayanyu ");
INSERT INTO ifa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ya mahapul an e ipa'innilan nan ud bale hinan padi ta ena tigon. ");
INSERT INTO ifa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ta ibagan nan padi hinadan nunhituhdi ta umaanda ni' hidi ya ta'on on nadan gina'uda ya inaanda ta mabao ya ahi e tigon nan padi ta ma\"id ha mibilang hi nalugit an mabatih nan bale. ");
INSERT INTO ifa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ya hi'on tigon nan padi nan dingding ya waday bu\"ut hi munlangta onu mumbolah di tigona an mangeh dallom nan dingding ");
INSERT INTO ifa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ya ikalobna ta mabao ni' hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ta hinan mi'apituh algo ya ahina bo e idodongan. Ta nihinap'e nan bu\"ut hinan dingding ");
INSERT INTO ifa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ya ibagana ta aanonda nan batun dingding an nipto'an nan bu\"ut. Ya eda intopal nadan inaandan waday bahbahna hinan nibilang hi nalugit an nidawwih nan boble. ");
INSERT INTO ifa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ya imbagana bo ta ad'adandan namin nan dingding nan bale ya eda bo intopal nan inad'addahdi hinan nibilang hi nalugit an eda nangitopalan hinadan batun inaanda. ");
INSERT INTO ifa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ya hinukkatanda nan batun na'aan hinadan dingding ya ahida bo pinalitadaan. ");
INSERT INTO ifa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Mu hi'on hidin nagibbuh an inatdahdi ya indani damdama ya numbangngad bo nan bu\"ut hinan niphod an dingding ");
INSERT INTO ifa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ya mahapul an e tigon bon nan padi. Ta hi'on tigonan nihinap hinan bale ya na'innilan nabahbah hidiyen bale ta mibilang moh nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ot mahapul an pa\"ihonda ya eda intopal an namin dadiyen na'usal hidi an batu ya kayiw ya nadan udum hinan nidawwih nan boble an nibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ya onha waha taguh hinunggop i diyen baleh din nikalob hi pituy algo an aggeda ni' pina\"ih ya mibilang hi nalugit hidiyen taguh ingganah nan mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ya nan tagun nangan onu nalo' hidi ya mahapul an ena laba'an nan inlubungna. ");
INSERT INTO ifa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mu onha hidin hinukkatanda nan na'aan an dingdingna ot palitadaanda ya tinigon nan padi ya agge numbangngad nan bu\"ut ya ibagana mohpen hidiyen bale ya mibilang hi malinis te na'aan nan bu\"utna. ");
INSERT INTO ifa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mu hay mahapul hi atonda ta mibilang hi malinis hidiyen bale ya e mangala nan ud bale i ha duwah hamuti ya ha nun'aptung hi kayiw an sedar ya ha mumbolah an linubid ya nan ma'alih haysop. ");
INSERT INTO ifa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ta gogodonay ohah nan hamuti an pa'ayuhonay dalanah nan banga an naha''adan hi pa'ahhagub an liting hinan obob. ");
INSERT INTO ifa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ya intamolna i diyen banga nadan sedar an kayiw ya nan ma'alih haysop ya nan mumbolah an linubid ya nan matagun hamuti. Ya inwalaghi'na dadiyen intamolna hi mumpipitu hinan bale. ");
INSERT INTO ifa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ta atona dadiyen namin ");
INSERT INTO ifa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ya ahina e ipatayap nan matagun hamuti hinan nibata\"an hinan boble. Athidiy atonda ta mibilang mohpeh malinis hidiyen bale. ");
INSERT INTO ifa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ot hiya danaey mahapul hi unudonyu hi'on waday gulid hi mangal'aldan hi udum ");
INSERT INTO ifa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ya hi'on waday bu\"ut hinadan luput onu nan bale ");
INSERT INTO ifa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ya nadan gulid an kumiyaki ya pogha ya nan lum'a' ");
INSERT INTO ifa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ta panginnilaan hi'on mibilang hi malinis onu mibilang hi nalugit nan tagu onu nan luput onu nan bale. ");
INSERT INTO ifa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Ibagayuh nadan ibbayun tinanud Israel ta wada'ey bumbummuddun malpuh adol nan lala'i ya mibilang hi nalugit hidiyen bumudduh i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ta hiya nan mibilang mo boh nalugit hidiyen tagu an ta'on on minaynayun nan bumbummudduh adolna onu dimminong. ");
INSERT INTO ifa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ta ta'on on nan nalo'ana onu nan inumbunana ya mibilangdah nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ya nan manapah nan nalo'ana ya mahapul an e mun'amoh ya inlaba'nay lubungna mu hiyah diye damdaman mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ya atbohdi nan tagun mihukkat an umbun hinan inumbunan diyen tagu an mahapul an e mun'amoh ya inlaba'nay lubungna mu hiya damdama bon mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ya ta'on on nan tagun manapa onu mida\"om i diyen tagun waday bumuddun malpuh adolna an mahapul an e mun'amoh ya inlaba'nay lubungna mu hiya damdamah diyen mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ya hi'on waday tinukpaan diyen tagun waday bumbummuddun malpuh adolna ya atbohdin mahapul an e mun'amoh hidiyen natukpaan ya inlaba'nay lubungna mu hiya damdaman mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ya an namin nan umbunan diyen lala'ih nan punluganana ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ya nan manapan diyen inumbunana ya mahapul an ena ilaba' nan lubungna ya nun'amoh. Mu hiya damdaman mibilang nimpeh nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ya onha agge inulahan nan tagun waday malpuh adolnay ta'lena ya indapanah ohan tagu ya mahapul an e mun'amoh diyen dinapana ya inlaba'nay lubungna. Mu hiya damdama nimpen mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ya kumpulnan pito' an bangan dapaon diyen tagu ya mahapul an pa\"ihonyu mu hi'on hay dinapana ya nan usal an kayiw ya mahapul an ulahanyu. ");
INSERT INTO ifa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ya wa'et pinumhod hidiyen tagu ta dimminong nan malpuh adolna ya haddona ta mala\"uh di pituy algo ya ahi e mun'amoh ya inlaba'nay lubungna ta mibilang moh malinis. ");
INSERT INTO ifa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ya hinan mi'awaluh algo ya inyena ha duway balug onu palluma hinan pi'dammuwanyun ha\"on an Dios hidih nan way panton nan tabernakel ya indatnah nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ta nan oha ya mi'nong hi apakawanan di bahul diyen tagu ya nan mi'adwa ya maghob an mi'nong i ha\"on an Dios. Athituy aton nan padi ta a'aanan di bungot'un Dios an gapuh bahul diyen tagun nipaphod hinan dogohna. ");
INSERT INTO ifa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Hay oha bo ya di'et waday bimmudduh malpuh adol di ohan lala'i ya mahapul an e mun'amoh mu hiya damdama nimpen mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ya kumpulnan lubung onu lalat an nida\"oman diyen bimmudduh nan lala'i ya gahin di ma'ulahan mu hiya damdaman mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ya wa'e ta inilo' nan lala'i nan babai ta bimmudduh di malpuh adolna ya mahapul an eda mun'amoh an duwa mu hiya damdamah diyen mibilangdah nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Ya atbohdi hinan bumudduhan nan binulan an malpuh adol nan babai an mibilang hi nalugit hi pituy algo. Ot nan manapa onu mida\"om i hiya ya mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ya an namin nan nalo'ana onu inumbunana ya mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ya nan manapa onu mida\"om hinan nalo'ana ya mahapul an e mun'amoh. Mu hiya damdaman mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ot nan manapa hinan kumpulnan inumbunan diyen babai ya mahapul an e mun'amoh ya inlaba'nay lubungna mu hiya damdamah diyen mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ta nan manapah nan umat hinan nalo'ana ya an namin nan inumbunana ya mahapul an e mun'amoh ya inlaba'nay lubungna mu hiya damdamah diye nimpen mibilang hi nalugit hi ingganah nan mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ya hi'on waday mangilo' i hiya ta nida\"om hinan lala'i nan binulan an malpuh adol nan babai ya mibilang hi nalugit hi pituy algo nan lala'i ya atbohdi an mibilang hi nalugit nan alo'ana. ");
INSERT INTO ifa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ya onha waday bumudduh dalah adol nan babai an ta'on on bokon hidiye nan binulan an malpuh adolna onu nan binulan an malpuh adolna mu adi dumduminnong ya mibilang hi nalugit ta ingganay duminong hidiyen malpuh adolna. ");
INSERT INTO ifa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ya atbohdin mibilang hi nalugit nadan alo'ana ya umbunana an umat hinan umaliyan di malpuh adolna. ");
INSERT INTO ifa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ya kumpulnan tagun manapa i dadiyen inusalna ya mahapul an e mun'amoh ya inlaba'nay lubungna. Mu hiya damdamah diyen mibilang hi nalugit hi ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ya wa'et dimminong hidiyen malpuh adolna ya hinnodnan mala\"uh di pituy algo ya ahi mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ya hinan mi'awaluh algo ya mahapul an iyenah nan padi hidih nan way panton nan tabernakel ha duway palluma. ");
INSERT INTO ifa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ta i'nong nan padi hi apakawanan di bahulna nan oha ya maghob an mi'nong nan oha. Athituy aton nan padi ta way aton nan babain mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ya alyon bon Apu Dios i Moses di, Datuwey ipa'innilam hinadan ibbam an tinanud Israel ta inniladay atonda hi'onda nibilang hi nalugit ta wan adi bo mi'inlulugit tun tabernakel ta bokon hiyay gumalat hi atayanda. ");
INSERT INTO ifa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ta danae nadan mahapul hi aton nan lala'i hi'on waday bumudduh malpuh adolna. ");
INSERT INTO ifa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Ya atbohdih nan babai hi'on waday bumudduh malpuh adolna ya hay aton nan lala'i an nangilo' hinan babain nibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Hidin nateda mo nadan duwan imbabalen Aaron hi eda nangidawatan hi i'nongda an gapuh aggeda nangunudan hinan inalin Apu Dios hi atonda ");
INSERT INTO ifa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ya alyon Apu Dios i Moses di, Ibagam i ibbam an hi Aaron ta adi namaaggon e hinunggop hinan kuwartu' an Dios an nabolda' hi kultina. Te hidih nan way bugut hi potto' nan kalub nan Kahun an nittuwan di Hapit'uy pumpatiga'. Te atona'ehdi ya mate. ");
INSERT INTO ifa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ta hiya nan madatngan'e nan ena hunggopan hidi ya iyena ha kilaw an baka ta mi'nong hi apakawanan di bahulna ya ha tangbal an kalnero ta maghob an mi'nong i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ya mahapul an ilubungna nan linen an adukken lubung ya nan putut an pantalon ya inwakohnah adolna nan adukken linen ya impongotna nan linen an turban. Mu mahapul an mun'amoh ni' ya ahina ilubung datuwen niyappit i ha\"on an lubung di padi. ");
INSERT INTO ifa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ya da'yu'en tinanud Israel ya mahapul an idatyu ha duwah tangbal hi gulding ta mi'nong hi apakawanan di bahulyu ya ha tangbal an kalnero ta maghob an mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ta i'nong Aaron hidiyen baka hi apakawanan di bahulna ta a'aanan di bungot'un Dios an gapuh bahulna ya nadan pamilyana. ");
INSERT INTO ifa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ya inyalina mohpe nan duwan gulding hidih nan panton nan tabernakel an pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ya imbunutna hi'on nganne i dadiyen duwan gulding di mi'nong i ha\"on an Dios ya nganney mibulus. ");
INSERT INTO ifa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ya inyen Aaron nan gulding an nabunut hi mi'nong ta i'nongnah apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ya nan nabunut an mibulus an gulding ya idawatna ni' an matagu i ha''on an Dios ya ahina imbulus hinan agge naboblayan ta miyappit hi a'aanan di bungot'un Dios an gapuh bahul nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ta alan Aaron nimpe nan baka ta mi'nong hi apakawanan di bahulna ta a'aanan di bungot'un Dios an gapuh bahulna ya didan hina'amma. Ya pinaltina ta mi'nong nimpe hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ya inalanah nan punggobhan hi insenso nan naha\"adan hi bala ya ha duway gamal hinan na'aggimu' an insenso ya inihgopnah nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ya inha\"adna nan ginamalnan insenso hinan bimmalan apuy ta umahuk ta hawanana nan kalub nan Kahun an nittuwan nan Hapit'un Dios. Ot atona'ehdi ya adi mate. ");
INSERT INTO ifa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ya inalana dohah nan dalan nan ini'nongnan baka ya intamolnay lodlodongna ya inwalaghi'nah nan balitu' an kalub nan Kahun ya ahina inwalaghi' hi mumpipituh nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ya nagibbuh'eh diye ya pinaltina bo nan gulding ta mi'nong hi apakawanan di bahulyun tatagu. Ya inalana bo dohah nan dala ya inihgopnah nan nakultinaan an kuwartu' an Dios ya intamolnay lodlodongna ya inwalaghi'na boh nan kalub nan Kahun ya ahina inwalaghi' hi mumpipituh nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ta athinay aton Aaron hinan kuwartu' an Dios an a'aanan di bungot'u an gapuh bahul ya ngohen nadan ibbam an tinanud Israel. Ya atbohdiy atona ta ahi mibilang hi malinis nan tabernakel an gapu nimpeh ngohen nadan ibbam an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ya mihipun hi hunggopan Aaron i diyen kuwartu' an Dios ta ena aton nan nibaga an atona ta a'aanan di bungot'un Dios an gapuh bahulna ya bahuldan hina'amma ya da'yun namin an tinanud Israel ya adi mabalin an waday hunggop hidih nan tabernakel an pi'dammuwanyu i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ta limmah'un'eh nan kuwartu' an Dios ya immeh nan punggobhan hi mi'nong hidih nan hangngab nan tabernakel ta ena aton nan nibaga an atona ta a'aanan di bungot'un Dios an gapuh bahul. Ya inalana dohah nan dalan nan baka ya gulding ya ena inhiit hinadan opat an ha'gud hinadan duggun nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ya intamolnay gamatna ya winalaghi'anah mumpipitu nan punggobhan hi mi'nong ta miyappit i ha\"on an Dios te nibilang hi nalugit an gapuh bahulyun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ya nalpah'en inatna nan nibagah atonah nan kuwartu' an Dios ya nan tabernakel ya nan punggobhan hi mi'nong ta mibilangdah malinis ya ena mohpe inala nan matagun gulding ta idawatna. ");
INSERT INTO ifa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ya inha'mona nan duwan ta'lenah ulun nan gulding ya imbagana nadan adi maphod an inatyu ya hay nungngohayanyu ya an namin an numbahulanyun tinanud Israel ta ayna impaboltan i diyen gulding. Ya ahina mohpe e impibulus hinan tagun niyukodana ta ipluynah nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ta paddungnay iyen diyen gulding an namin nadan numbahulanyuh nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ya ahi mohpe bo hunggop hi Aaron hinan tabernakel ta aanona nan inlubungnah din hinunggop hinan kuwartu' an Dios ya inha''adnahdi ");
INSERT INTO ifa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ya limmah'un hidi ta e mun'amoh hinan niyappit i ha\"on an pun'amhan hidih nan tabernakel ya inlubungna nan lubungna tuwali. Ya limmah'un bohdi ta ena i'nong nadan maghob an mi'nong ta a'aanan di bungot'un Dios an gapuh bahulna ya gapuh bahulyun tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ya ginhobna nadan taban dadiyen ni'nong hi apakawanan di bahul hinan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ya hana'e an e nangibulus hinan gulding hinan agge naboblayan ya mahapul an ena ilaba' di lubungna ya nun'amoh ya ahi mabalin an mumbangngad hinan nun'allunganyu. ");
INSERT INTO ifa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ya nan bulug an baka ya nan gulding an ni'nong ta a'aanan di bungot'un Dios an gapuh bahulyun tatagu ya ud dalah nan nihgop hinan kuwartu' an Dios ya mahapul an miyedah bata\"an nan nun'allunganyu ta eyu gobhon hidi an pi'ighobyu nadan up'upda ya lamohda ya putuda an middum nadan lugit hi putuda. ");
INSERT INTO ifa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ya nan tagun e munggohob i dadiye ya mahapul an ilaba'nay lubungna ya nun'amoh ya ahi mibangngad hinan nun'allunganyu. ");
INSERT INTO ifa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ya alyon bon Apu Dios di, Hituwey inaynayunyun unudon ta maminghan hinan hintawon hinan mi'apuluh algo hinan mi'apituh bulan ya mahapul an adi ayu e muntamu ya adiyu aton nan pohdon di adolyu an ta'on on nadan ni'iboblen da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Te i diyen algoy pangi'nonganyuh nan mi'nong ta a'aanan di bungot'un Dios an gapuh bahulyu. ");
INSERT INTO ifa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ta adi ayu nimpe muntamu ya adi ayu mangat hinan pohdon di adolyu i diyen algo. Ya mahapul an unudonyuh tuweh inggana. ");
INSERT INTO ifa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ya nan padin pinto\"u an mihukkat hinan ammodna an nabaktun padi ya mahapul an ilubungna nan lubung di padi ta atona nan nibaga an atona ta a'aanan di bungot'un Dios an gapuh bahul. ");
INSERT INTO ifa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ya ahina mohpe aton nadan ma'at ta mibilang hi malinis nan kuwartu' an Dios ya nan tabernakel ya nan punggobhan hi mi'nong ta ma'aan di bungot'un Dios an gapuh bahul nadan padi ya da'yun tinanud Israel ya ta'on on nadan ni'iboblen da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ta hituwey tugun'un da'yu hi inaynayunyun aton an tinanud Israel hi maminghan hi hintawon ta a'aanan di bungot'un Dios an gapuh nadan bahulyu. Ta inunud Moses nadan imbagan Apu Dios i hiyah atona. ");
INSERT INTO ifa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Ibagam i Aaron ya nadan imbabalena ya an namin nadan tinanud Israel ta unudonda nadan imbaga' hi atonda. ");
INSERT INTO ifa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ot hi'on wada i da'yun tinanud Israel ha ena i'nong nan baka onu kalnero hi kumpulna an umat hinan nun'allunganyu onu hinan bata\"an nan nun'allunganyu ");
INSERT INTO ifa_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","an bokon hinan way panton nan tabernakel an pi'dammuwanyun ha\"on di ena pangi'nongan ya hidiyen tagu ya mibilang hi pimmate. Ta hiya nan mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Manu'e hi nitugun hituwe ya ta wan adi mo kumpulnay eyu pangi'nongan an umat hinan puntanoman. Te gahin di iyeyuh nan padi ta hinan way panton nan tabernakel an pi'dammuwanyun ha\"on ta hidiy pamaltiyanyu ta mi'nong hi pi'hayyupanyun ha''on. ");
INSERT INTO ifa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ya nan dalan diyen pinaltiyu ya e iwalaghi' nan padih nan punggobhan hi mi'nong hinan way panton nan tabernakel an pi'dammuwanyun ha\"on an Dios. Ya ginhobna bo nan tabahdi ta nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ot mahapul an adi ayu mo e mangi'nong hinan gulding an inyamman di tagu ta dayawonyu. Te onha atonyuhdi ya umat ayuh nan babain inluktapnay ahawana. Ot datuwey itugun'uh unudonyuh inggana an ta'on on hanadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ya ibagam hinadan ibbam an tinanud Israel ya ta'on on nadan ni'iboblen da'yu ta wa'et waha mangiyalih maghob an mi'nong i ha\"on an Dios ");
INSERT INTO ifa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mu bokon hinan way panton nan tabernakel di pangiyaliyanda ya mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ya hi'on wada i da'yun tinanud Israel ya ta'on on nadan ni'iboblen da'yu ha mangihdah dala ya adi' mo ibilang hi tagu'. ");
INSERT INTO ifa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Te nan dala ya hiyay ataguwan ta hiya nan hiyay iyeyuh nan punggobhan hi mi'nong ta a'aanan di bungot'un Dios an gapuh bahul di tagu. ");
INSERT INTO ifa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ta hiya nan ibaga' i da'yu ya ta'on on nadan mi'iboblen da'yu an adiyu ihday dala. ");
INSERT INTO ifa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ya wada'ey kinnayun hamuti onu inanupyun mihdan animal ya mahapul an gogodonyu ta ihihonyu nan dalanah nan luta ya tinabbunanyuh pito' hidiyen dala. ");
INSERT INTO ifa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Te hay awadan di itaguwan nan animal ya nan dalana. Ot hiya nan adiyu nimpe anon nan dalan di kumpulnan animal te nan mangan ya mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ya hi'on wada i da'yun tinanud Israel onu ni'iboblen da'yu hi mangihda hinan animal an nate onu pinaten di udum an animal ya mahapul an e mun'amoh ya inlaba'na nan inlubungna. Mu mibilang damdamah nalugit ta ingganah mahdom ya ahi mabalin an mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mu hi'on adi e mun'amoh ya adina e ilaba' nan inlubungna ya madusa. ");
INSERT INTO ifa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Ibagam hinadan ibbam an tinanud Israel an ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ot mahapul an adiyu iyunnud hinan pangiye\"en nadan i Egypt an nalpuwanyu ya nan pangiye\"edah ad Kanaan an pangiyaya' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mahapul an unudonyu nadan tugun'u ya atonyu nadan imbaga' hi atonyu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ot nan tagun un'unudona nadan tugun'u ya maphod di pi'taguwana. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ta adiyu ilo' di i'ibayu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ya bainanyu mahan hi amayu ta adiyu ilo' hi inayu. Nomnomonyu an hi inayuh diye. ");
INSERT INTO ifa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ya ta'on on nan numbintanan amayu ya adiyu ilo' ta adi mibabain hi amayu. ");
INSERT INTO ifa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ya adiyu ilo' di hi ibbayun babai an ta'on on nat'on di hi inana onu hi amana an ta'on on nat'on an bobley kimmilogana onu numpaddung an baley kimmiloganyu. ");
INSERT INTO ifa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ya adiyu ilo' di apapuyu te da'yu damdamay mibabain. ");
INSERT INTO ifa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ya adiyu ilo' nan imbabalen nan numbintanan amayu te hi ibbayu damdama. ");
INSERT INTO ifa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ya adiyu ilo' di hi antiyu an hi ibban amayu ");
INSERT INTO ifa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","onu nan hi ibban inayu. ");
INSERT INTO ifa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ya adiyu ilo' nan ahawan nan hi ulitauyu te mibilang hi ammodyu. ");
INSERT INTO ifa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ya adiyu ilo' nan babain inapuyu te ahawan nan imbabaleyu. ");
INSERT INTO ifa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ya adiyu ilo' nan ahawan nan hi ibbayun lala'i. ");
INSERT INTO ifa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ya adiyu ilo' nan hinina onu nan apapun nan babai te nagaga\"iho. ");
INSERT INTO ifa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ya adiyu bo i'adwah nan ahawayu nan hi ibbana hi'on matagu nan ahawayu. ");
INSERT INTO ifa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ya adiyu ilo' nan babai an wada nan binulan an malpuh adolna te mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ya adiyu ilo' nan ahawan di hinaggonyu ta adi ayu mibilang hi nalugit an gapu i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ya inalin bon Apu Dios di, Adiyu i'nong hinan dios an hi Molek di kumpulnah nadan imbabaleyu te atonyu'e ya ha\"on an Dios an dayawonyuy binainyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ya adiyu ilo' di ibbayun lala'i te nunhiglan umipabungot i ha\"on an Dios hinaen pangat. ");
INSERT INTO ifa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ya adiyu ilo' di animal te mibilang ayuh nalugit te himpappange ahan hinaen aton di ohan tagu. ");
INSERT INTO ifa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ot padana' tee an adiyu aton danae ta adi ayu mibilang hi nalugit te danaey pangat nadan tataguh nadan boblen umayanyu ta hiya nan pa'aano' didahdi. ");
INSERT INTO ifa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Te ta'on on nan bobleda ya nibilang hi nalugit an gapuh bahulda ta hiya nan dusao' dida ta paddungnay ibugha' diyen boble dida. ");
INSERT INTO ifa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mu da'yu'e ya ta'on on nadan mi'iboblen da'yu ya tigonyu ta nadan tugun'u ya tudtudu' di unudonyu. Ta adiyu aton nadan nunhiglan umipabungot i ha\"on an Dios an pangatda. ");
INSERT INTO ifa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Te athidi nimpey inat nadan tatagun nunhituhdi ta hiya nan mibilang hi nalugit nan bobleda. ");
INSERT INTO ifa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ya wa'et atonyuhdi ya ma'at bon da'yu nan ato' i dida an paddungnay ibugha' da'yuh nan boble. ");
INSERT INTO ifa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ot nan mangat i danaen nunhiglan umipabungot i ha\"on an Dios an pumbahulan ya mipapate ta adi mo midmiddum i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ot mahapul nimpen nadan tugun'u di nanongnah un'unudonyu ta adiyu iyunnud hinadan nunhiglan umipabungot i ha\"on an Dios an pangat nadan tatagu i diyen boble ta adi ayu mibilang hi nalugit an umat i dida. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Ibagam hinadan ibbam an tinanud Israel an ha\"on an Dios an dayawonyu ya ma\"id ha adi maphod hi a'at'u ot hanat ha\"on di inghonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ot mahapul an lispituwonyuy a'ammodyu. Ya mahapul an tungawonyu nan Habadun tungo. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ya adiyu dayawon nadan bulul an dios di udum an tatagu ya adi ayu mangiyammah bulul ta dayawonyu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ya hi'on waday i'nongyuh pi'hayyupanyun ha\"on ya unudonyu nadan intugun'un atonyu ta wan abuluto' nan i'nongyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ya nan dotag nan ini'nongyu ya ihdayu i diyen algo ya nan mabiggat. Mu wada'ey mabati hinan mi'atluh algo ya mahapul an gobhonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Te wada'ey mangan i dadiyen nabatih nan mi'atluh algo ya adi' mo abuluton hidiyen ini'nongyu te mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ot nan tagun mangihda i diyen ni'nong i ha\"on ya mipapate ta adi mo midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ya wa'et munggapas ayu ya adiyu gapason nadan nundina'ging ya adiyu bo panuhon nadan nagah. ");
INSERT INTO ifa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ya atbohdih on ayu mun'apit hinan bungan di intanomyun greyp an adiyu pidwon an e polagon ya adiyu alan nadan nagah ta alan nadan nun'awotwot ya nadan udum an tatagun ni'iboblen da'yu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ya adi ayu mangako. Ya adi ayu munlayah. Ya adiyu ilaylayahhan di ibbayu. ");
INSERT INTO ifa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ya adiyu usalon di ngadan'un munsapatah linaylayyah ta adiya' bainon i da'yu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ya adiyu kulukon onu akawan di ibbayun tagu. Ya adiyu attaon an ipabigat di pangidatanyuh nan bino'lan nan nuntamuwonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ya adiyu idutan nan napukit ya athidi boh nan napilok an adiyu attaon an iha\"ad ha ihalapdungana. Adiyu aton datuwe ta atiganan ha\"on di un'unudonyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ya tigonyu ta nipto' di atonyun mangipanuh hinadan mihahapit ta ma\"id ha pangipangngelanyu an ta'on on kadangyan onu nawotwot. ");
INSERT INTO ifa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ya adiyu e ibagabagay layah an puma\"ih hinan ibbayu. Ya na'ayagan ayu'en muntistigu i ha kasu ya hanat ibagayu nan immannung an namamah on hidiyey gumalat hi atayan nan hinaggonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ya adi namaaggon humihihihiwo ayuh nan ibbayu. Udu'dulnay ihingalyu ta adi ayu mumbahul an gapuh humihiwawanyu i hiyah nan inatna. ");
INSERT INTO ifa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ya adi ayu numanomnom hi atonyun mangiballoh onu punnanongon di bungotyuh nadan ibbayu te hay maphodot ya ipatigoyuy pamhodyu an umat hi pamhodyuh adolyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ot hanat un'unudonyu nadan tugun'u. Ta adiyu ipatangbal nan animal an umat hi baka hinan nat'on an umat hi kabayu. Ya adiyu bo itanom nan duwan nat'on an mitanom hinan puntanomanyu. Ya adiyu ilubung nan lubung an duway nunhinnat'on an luput di niyamma. ");
INSERT INTO ifa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ya onha inilo' di ohan lala'i ha himbut an babai an nitbih nat'on an lala'i ya mahapul an mamoltada. Mu adida mipapate te agge nabayadan di ilibliyan diyen babai. ");
INSERT INTO ifa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mu nan lala'i ya mahapul an iyena ha tangbal hi kalneroh nan way panton nan tabernakel ta mi'nong hi apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ta i'nong nan padi ta a'aanan di bungot'un Dios an gapuh bahulna ta wan mapakawan. ");
INSERT INTO ifa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ya wa'et dimmatong ayuh nan bobleh ad Kanaan ta nuntanom ayuh bungbunga\"an ya mahapul an adiyu anon nan ibungadah nan tuluy tawon ta ibilangyun nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ya nan ibungadah nan mi'apat hi tawon ya miyappit i ha\"on ta punhanaanyu i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mu nan ibungadah nan mi'alimah tawon ya mabalin an anonyu. Ot hi'on unudonyu nadan nibaga ya umannung an dumakol di apitonyun ibungan di itanomyu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ya adiyu anon di kumpulnan dotag an agge na'aan di dalana. Ya adi ayu mumbuyun onu mun'ayak. ");
INSERT INTO ifa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ya adiyu ipapukis nan ibu' hi way ingayu ya adiyu bo putulan di uddun nan balbasyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ya adiyu attaon an hugaton di adolyu ta pangipatigoyuh umukayunganyu hi'on waday ibbayun nate. Ya adiyu ipabato' di adolyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ya adiyu bainon nadan binabain imbabaleyu hinan eyu pangiyabulutan ta eda mumpabpabbayad hi adolda. Te atonyu'ehdi ya lo'tat ya du'gona' ta e ayu mundayaw hinadan dios di udum an tatagu. Ta lo'tat ya mibilang hi nalugit di bobleyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ya unudonyu nadan intuddu' hi atonyuh nan Habadun tungo. Ya ipatigoyun na'anhan nan tabernakel. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ya adi ayu e mumpaboddang hinadan mumpumbaki onu nadan mama\"o te diday gumalat hi ibilanganyuh nalugit. Ha''on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ya ipatigoyuy punlispituyuh nadan ininna ya amamma. Te atonyu'ehdi ya atiganan ha\"on di un'unudonyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ya adiyu paligaton nadan mi'iboblen da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ta ibilangyu didah ibbayun tinanud Israel. Ya hanat pohpohdonyu didan umat hi pamhodyuh adolyu te da'yu ya pinatnayun e ni'ibobleh ad Egypt. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ya tigonyu ta bokon kuluk di pungkiluyu ya punlukudyu ya ta'on on nan pumbilangyu. ");
INSERT INTO ifa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ta nan nipto' an kiluwan ya punlukud di usalonyu. Ha\"on nan Dios an dayawonyu an nangipangulun da'yu hi nakakanyuh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ot mahapul an un'unudonyu nadan tugun'u ya nadan intudtudu' i da'yu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Ibagam hinadan ibbam an tinanud Israel an hay atonyuh nan ibbayun tinanud Israel onu nadan ni'iboblen da'yu an inyukodnay imbabalenah nan dios an hi Molek ya mahapul an adhuwanyu ta puntopayu ta ingganah mate. ");
INSERT INTO ifa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Te du'go' an adi' mo ibilang hi tagu' nan tagun iyukodnay imbabalenan Molek ta binahbahnay a'at nan tabernakel ta imbabainay a'at'u. ");
INSERT INTO ifa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ot hi'on namaag ya dimminong ayu ta adiyu patayon nan tagun mangi'nong hi imbabalena i Molek ");
INSERT INTO ifa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ya ha\"on di mamate i hiya ya nan pamilyana ya an namin nadan nangiyunnud i hiya. Ta adida mo midmiddum i da'yu. Te bokon ha\"on di dayawonda te hi Molek ta nipaddungdah nan babain tinaynanah ahawana ot e mumpabpabbayad hi adolnah udum. ");
INSERT INTO ifa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ya atbohdin iwalong'u nan tagun e mumpaboddang hinan mi'hapit hi linnawan di numpun'ate onu hinan mama\"o te bokon nimpe ha\"on di dayawona ta hiya nan ipapate' ta adi mo midmiddum i da'yun tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ot hanat ipaphodyuy pangatyu ta nan pohdo' di atonyu te ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ya mahapul an un'unudonyu nadan tugun'u te ha\"on nan Dios an mangipaphod hi a'atyu. ");
INSERT INTO ifa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ot nan tagun idutanay hi amana onu hi inana ya mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ya nan lala'in mangilo' hinan ahawan di udum ya mahapul an madusadah nan babai ta mipapatedan duwa. ");
INSERT INTO ifa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ya atbohdih nan lala'in mangilo' hinan ahawan amana ta aggena binain nan hi amana an mahapul an mipapatedan duwah nan babain gapu i diyen numbahulanda. ");
INSERT INTO ifa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ya nan mangilo' hinan ahawan di imbabalenan lala'i ya mahapul an mipapatedan duwah nan babai. Te hidiyen inatda ya umipabain ta hiya nan mahapul an matedan duwa. ");
INSERT INTO ifa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ya nan lala'in ilo'na nan paddungnan lala'i an ayda hin'ahawa ya nunhiglan umipabungot i ha\"on an Dios hidiyen inatda ta hiya nan mahapul an mipapatedan duwa. ");
INSERT INTO ifa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ya athidi bon adi ahan maphod hi'on ahawaon di ohan lala'i ha hinina. Ot mahapul an mapu'ulandan tulu ta adi ayu mibabain an himpamoble. ");
INSERT INTO ifa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ya hi'on waha lala'i hi ilo'nay animal an ayna ahawa ya mahapul an mipapate ya ta'on on nan animal ya mahapul damdama an patayonyu. ");
INSERT INTO ifa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ya atbohdih on nan babai di mi'ilo' hinan animal ta ayda himbale ya mahapul an mipapatedan duwa. ");
INSERT INTO ifa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ya hi'on waha lala'ih inahawana nan hi ibbanan babai an ta'on on nan binintan amana onu hi inana ya umipabain ahan. Ot mahapul an mipapatedah hinangngabyun ibbadan tatagu. Ta holtaponday dusada an gapu i diyen inatda. ");
INSERT INTO ifa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ya nan lala'in ilo'na nan babain waday binulan an malpuh adolna ya mahapul an mipapatedan duwa ta adida midmiddum i da'yun tinanud Israel Israel te aggeda inunud nan tugun'uh nan waday binulan an malpuh adolna. ");
INSERT INTO ifa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ya hi'on waha lala'ih ilo'na nan hi ibban amana onu hi inana ya binaina nadan a'ammodna ot madusadan duwa. ");
INSERT INTO ifa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ya nan lala'in ilo'nay ahawan di hi ulitauna ya binainah ulitauna. Ot hay dusadan duwah nan babai ya mabutingoda. ");
INSERT INTO ifa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ya nan lala'in pulhonay ahawan di hi ibbana ya nagaga\"iho mahan hidiyen atona te aggena binainan hi ibbana. Ta hiya nan mabutingodan duwah nan babai. ");
INSERT INTO ifa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ya alyon bon Apu Dios di, Mahapul an un'unudonyu nadan tugun'u ya tudtudu' ta adi da'yu pa'aanon hinan boblen pangiyaya' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ta adiyu iyunnudan hinan adi maphod an pangat nadan tataguh nan boblen pangiyaya' i da'yu. Te gapu i diyen pangatda ya nunhiglay bungot'u i dida. Ta hiya nan pa'aano' dida i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mu imbaga' tuwalin da'yu an eyu punhituwan hidiyen bobleda ta da'yuy pangdata' i diyen numboblayanda an malumong ya makadangyan an boble. Ha\"on an Dios an dayawonyu di namto' i da'yu ta niyappit ayun ha\"on an Dios ta adi ayu umat hinadan udum an tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ta hiya nan mahapul nimpen innilaonyu hi'on nganne nadan animal ya hamuti an mibilang hi malinis ya nalugit. Ot adiyu iyabulut an mibilang ayuh nalugit an gapu i dadiyen animal onu hamuti an mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ha''on nan nahamad an Dios an niyappitanyu. Ya ta'on on dakkodakkol di tataguh abobboble ya pinto' da'yu ta niyappit ayun ha\"on ta da'yuy tatagu'. ");
INSERT INTO ifa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ot hi'on wadada i da'yuy mi'hapit hinadan linnawan nadan numpun'ate onu mama\"o ya mahapul an adhuwanyu ya nuntopayu ta ingganah mateda ta hidiyey dusada. ");
INSERT INTO ifa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Alyon bon Apu Dios i Moses di, Ibagam hinadan padi an imbabalen Aaron an mahapul an adida umeh nan awadan di nate ta adida mida\"om hinan nate an ta'on on tulangda ta adida mibilang hi nalugit ");
INSERT INTO ifa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ta ingganah on nan didan pamilya an umat hinan hi inada onu hi amada ya imbabaleda ya nan lala'in hi ibbada ");
INSERT INTO ifa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ya nan hi ibbadan babain ma\"id ha ahawanah mumpapto' i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Mu mahapul nimpe an adida iyabulut an mibilangdah nalugit an gapuh nan umayandah awadan di nate an ta'on on nan waday niyatanda i dida an umat hinadan i'iban ahawada. ");
INSERT INTO ifa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ya mipagol boh nan padi an ipakalbunay uluna onu putulanay balbasna onu hugatonay adolna ta pangipatigonah umukayungana hi'on waday nate. ");
INSERT INTO ifa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Te nadan padi di pinto\"u hi mangi'nong hinadan maghob an mi'nong i ha\"on an Dios. Ta hiya nan mahapul an nan pohdo' di atonda ta adiya' mibabain an Dios an dayawonda. ");
INSERT INTO ifa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ya mipagol an ahawaonda nan babain imbolhen di ahawana onu nan mumpabpabbayad hi adolna te didan padi ya niyappitdan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ot hanat ibilangyu didah niyappit i ha\"on an Dios te diday mangi'nong hinadan makan i ha\"on. Ot ibilangyu nimpe didah niyappit i ha\"on te ha\"on an Dios an nahamad di a'atna ya pinto\"u dida ta niyappitdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ya hi'on nan babai an imbabalen di padi ya mumpabpabbayad hi adolna ya binahbahnay ngadan amana ta hiya nan mahapul an pu'ulanyu. ");
INSERT INTO ifa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Nan nabaktun padi an nahiitan di ulunah lana ya hiyay napto' hi mangilubung hinan lubung di padi. Ot mahapul an adina gungalon di ibu'na ya adina punhethet di lubungnah umukayungana. ");
INSERT INTO ifa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ya mipagol hi umayanah awadan di nate an ta'on on hi amana onu hi inana ta adi mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ya mahapul an adina taynan nan tabernakel ta umeh awadan di nate ta adi mibilang hi nalugit nan pundayawanyu i ha\"on an Dios. Te hiya ya niyappit i ha\"on an Dios an gapu ta nahiitan di ulunah lana. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ya hay mabalin hi ahawaon nan nabaktun padi ya nan ma\"id ha inilo'nah lala'i. ");
INSERT INTO ifa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ot adi mabalin nan nabalu onu nan ni'bolhe ya nan mumpabpabbayad hi adolna. Mu ammuna nimpe nan ma''id ha inilo'nah lala'i an nalpu i didan himpamu'un di mabalin hi ahawaona. ");
INSERT INTO ifa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ta wan adi mibilang hi nalugit nadan holagna te niyappitdan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Ibagam i Aaron an nadan imbabalenan linala'in waday bahbahna ya adi mabalin an diday mangidawat hi makan i ha\"on an Dios. Ot hituwey ma'unud an ta'on on hanadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ot nadan waday bahbah di adolda ya nadan umat hinadan napilok ya nadan napilay ya nadan waday pa\"ih di angahda ");
INSERT INTO ifa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ya nadan natakluy ");
INSERT INTO ifa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ya nadan nabakug ya nadan unano an tagu ya nadan waday bahbah di matada onu up'upda onu indonanda. ");
INSERT INTO ifa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ot nan wada nimpey bahbahna an holag Aaron ya adi mabalin an hiyay mangi'nong hinadan makan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mu mabalin an mi\"an hinadan nidawat an makan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mu ha\"on an Dios di mangali an gapu ta waday bahbah di adolna ya adi mabalin an hunggop hinan kuwartu' an Dios ya adi bo mabalin an e mihaggon hinan punggobhan hi mi'nong ta wan adi mibilang hi nalugit dadiye. ");
INSERT INTO ifa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ot hi Moses ya imbaganan namin danae i da Aaron ya nadan imbabalena ya an naminda an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Ibagam i Aaron ya nadan linala'in imbabalena ta lispituwonda nadan iyaliyun tinanud Israel an midawat i ha\"on ta atiganan bainana' an Dios. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ibagam i dida ta ibagadah nadan mun'atanudan an wada'e i didan padi ha mibilang hi nalugit ya adi mabalin an dapaona onu mihaggon hinadan i'nongyun tinanud Israel i ha\"on te atona'ehdi ya adi mo mabalin an munhilbi i ha\"on hinan pundayawanyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ya hi'on wadah nan holag Aaron di waday gulidna an mangal'aldan hi udum onu ha waday bumbummuddun malpuh adolna ya adi mabalin hi mi\"an hinan indawatyun tinanud Israel i ha\"on ta ingganah ibagan nan padi an mibilang moh malinis. Ya hay udum hi gapunah mibilang hi nalugit nan padi ya nan panapaanah nan nibilang hi nalugit an tagu an gapu ta nida\"om hinan nate ya nan ida\"omanah nan lala'in waday bumbummuddun malpuh adolna. ");
INSERT INTO ifa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ya mibilang boh nalugit nan padi hi'on nida\"om hinan kumpulnan mibilang hi nalugit an umat hinadan mungkaddapan hinan luta onu tagu. ");
INSERT INTO ifa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ya minaynayun an mibilang hi nalugit i diyen algo ta ingganah nan mahdom. Ta adi ni' mabalin an mi\"an hinadan nidawat i ha\"on te gahin di e mun'amoh. ");
INSERT INTO ifa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ta ingganah malimuh nan algo ya ahi mohpe mibilang hi malinis ta mabalin an anona nan nidawat i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ya adi mabalin an anon nan padi nan kumpulnan animal an pinaten di atap an animal onu nan namaaggot mate te anonda'e ya mibilangdah nalugit. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ot mahapul an un'unudon nadan padi danaen imbaga' hi atonda ta wan adida mumbahul ya natedan gapuh aggeda nangunudan. Ha\"on an hi Apu Dios di namto' i dida ta miyappitdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ya nan nidawat i ha\"on an Dios ya ammuna nan padi ya nan pamilyana di mabalin an mangan te mipagol hi kumpulna an ta'on on nan puntamuwona ya nan bihhitana. ");
INSERT INTO ifa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mu hi'on waday ginattang nan padih himbutna ya mabalin an pi\"anona ya wada'ey imbabalen diyen himbut an niyayyam hi balen nan ud himbut i dida ya mabalin bon mi\"anda. ");
INSERT INTO ifa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ya hi'on nan babain imbabalen di padi ya bokon padi nan ahawana ya adi mo mabalin hi mi\"an hinan makan an nidawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mu onha nabalu onu ni'ibolhe ya ma\"id ha imbabalena ot mabalin an ibangngadnah balen amana ta umat hidin amangilogna an mi'mi''an hidi. Ta athidin hay mabalin nimpeh mi\"an hinan anon di padi ya ammuna nan pamilyana. ");
INSERT INTO ifa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Mu onha agge innilan nan tagun nidawat i Apu Dios nan makan ya inana ot mahapul an bayadana nan inana ya iniddumna ha pulsintuna hi mi'alimah nan balol di inana. ");
INSERT INTO ifa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ot mahapul an tigon nadan padi ta adi milubit nan idawatyun tinanud Israel i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ya adida ipa'an hi kumpulnan tagu nadan makan an nidawat i ha\"on. Te atonda'ehdi ya madusada. Ha\"on hi Apu Dios an namto' i dida ta miyappitdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Ipa'innilam i da Aaron ya nadan imbabalena ya an namin ayun tinanud Israel ya ta'on on nadan ni'iboblen da'yu datuwen a'at di mi'nong. An wada'e ha mangidawat hi maghob an mi'nong an hidiyey pangipa'annunganah nan imbaganan i'nongnan ha\"on onu hidiye nan ninomnomna tuwalin i'nong i ha''on ");
INSERT INTO ifa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ya mahapul an ha ma\"id ha bahbahnan bulug an baka onu ha ma\"id ha bahbahnan tangbal an gulding onu kalnero. ");
INSERT INTO ifa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ta adiyu i'nong nan waday bahbahna te adi' abuluton. ");
INSERT INTO ifa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ya atbohdi nan mi'nong hi pi'hayyupanyun ha\"on onu nan mi'nong hi pangipa'annunganyuh nan imbagayun i'nongyu onu nan ninomnomyu tuwalin i'nong an mahapul an nan ma\"id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ta adiyu i'nong i ha''on nan animal an napilok onu napilay onu nahugatan onu nagulidan. Te adi' abuluton hi maghob an mi'nong danae. ");
INSERT INTO ifa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Mu mabalin nan tangbal onu tinnan baka onu kalnero an waday kittang hi bahbahna an i'nongyuh nan ninomnomyu tuwalin i'nong mu adi mabalin hi'on i'nongyu ta pangipa'annungyuh nan imbagayun i'nongyun ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ya adiyu ahan i'nong i ha\"on an Dios ha tangbal an animal an nakapun onu waday bahbah di indonana. ");
INSERT INTO ifa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ya adiyu i'nong di athidin animal an nalpuh udum an tatagun ni'iboblen da'yu te adi' abuluton te mibilang an waday bahbahna. ");
INSERT INTO ifa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Nan hiyah niyayyam an baka onu kalnero onu gulding ya mahapul an adiyu ihiwweh nan hi inanah pituy algo. Mu wa'et waluy algona ya mabalin mon maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mu nan baka onu kalnero ya nan imbabalenan pa'pa'innummana ya adi mabalin hi pundihhanon didan i'nong hinan ohay algo. ");
INSERT INTO ifa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ya wada'ey idawatyuh punhanaanyu ya tigonyu ta nan nibaga hi atonyu di ma'unud ta mabalin an abuluto'. ");
INSERT INTO ifa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ya mahapul an anonyun namin i diyen algo nan nidawat ta ma\"id ha mabatih nan ibiggatana. ");
INSERT INTO ifa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Ot tigonyu ta nadan tugun'u ya nadan tudtudu' di inaynayunyu nimpen un'unudon. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ot mahapul an adiyu ibabain nan nahamad an a'at'u. Ya hanat an namin ayun tinanud Israel ya nahamad di pangibilangyuh nan a'at'u. Te niyappit ayun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Te ha\"on di nangikak i da'yuh ad Egypt ta wan ha\"on an Dios di dayawonyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Ibagam hinadan ibbam an tinanud Israel an datuwe nadan nagtud an ngilin an ipa'innilayu i dida ta wan nadatngan'e on na'amung ayun namin ta dayawona'. ");
INSERT INTO ifa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ta hinan hindumingguwan ya onom di algo an mabalin an muntamu ayu. Mu nan mi'apituh algo ya Habadun tungo. Ot adi ayu muntamu i diyen algo ta ma'amung ayu ta mundayaw ayu. Ya ta'on on idanay eyu punhituwan ya hiyah diyen tungawonyu nan Habadu. ");
INSERT INTO ifa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ot datuwe nimpe nadan nagtud an ngilin an a'amunganyu an mundayaw i ha\"on ta ipa'innilayuh nadan ibbayu hi'on nadatngan. ");
INSERT INTO ifa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Hay oha ya nan pundayawanyun ha\"on hinan punnomnomnomanyuh nihwanganyuh ate hi ad Egypt. Hituwe ya mihipun hinan mun'ahdom hinan mi'apulut opat (14) di algoh nan mamangulun bulan. ");
INSERT INTO ifa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ya hinan mabiggat i diye ya ngilinonyu nan punnomnomnomanyuh nan tinapay an agge nadduman hi yist. Ta hay anonyu hinan pituy algo ya nan tinapay an agge nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ya hinan mamangulun algo ya ma\"id ha muntamu ta ma'amung ayun mundayaw i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ya binigat hinan pituy algo ya idawatyu nan maghob an mi'nong i ha\"on. Ya hinan ma'udin algo ya adi ayu bo muntamu ta ma'amung ayu ta mundayaw ayu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Ibagam hinadan ibbam an tinanud Israel an alyom di, Dimmatong ayu'eh nan boblen idat'un da'yu ya wa'et nalpah an nunggapas ayu ya inyeyuh nan padi ha ohay nabto' hinan hopap di ginapasyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ta nala\"uh'e nan Habadun tungo ya e intaggen nan padih diyen binto' ta midawat i ha\"on an Dios ta wan abuluto' hidiyen nalpun da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ya mahapul an i'nongyu i diyen algo ha tangbal hi kalnero hi ohay tawona ya ma\"id ha bahbahna ta maghob an mi'nong i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ya iniddumyuhdi ha duway kiluh nan maphod an alina an nadduman hi mantekan di olibo ot nan hunghungna ya umipa'amlong i ha\"on. Ya idawatyu bo i ha\"on ha ohay litro hi bayah. ");
INSERT INTO ifa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ya adiyu anon nan hiyah nagapas an umat hinan niyamma hi tinapay onu nan nihanglag ta inggana i diyen algo an iyaliyu nan i'nongyu i ha\"on an dayawonyun Dios. Ot hituwey ma'unud ta inggana an ta'on on idanay umayanyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ya mihipun hinan mabiggat i diyen Habadun tungo an hidiye nan nalpahan nan nitagge an nidawat an hopap di ginapasyu ya mumbilang ayuh pituy duminggu. ");
INSERT INTO ifa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ta nala\"uh'e nan mi'apituh Habadu ya inyeyuh nan mabiggat an mi'anabongleh (50) algo nan midawat an tinapay an malpuh nan hiyah ginapasyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ta ohay pamilya an ta'on on idanay awadanyu ya mahapul an iyaliyu ha duway naballambag an tinapay. An hay inyammayu ya umeh duway kilun maphod an alina an nadduman hi yist ta mitagge an midawat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ya hay idawatyu bo ta maghob an mi'nong an umipa'amlong i ha\"on nan hunghungna ya ha pituy tangbal hi kalnero an hinohhay tawonda ya ha kilaw an baka ya ha duwah tangbal an kalnero. Ya tigonyu ta an namin danae ya ma\"id ha bahbahda. ");
INSERT INTO ifa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ya ini'nongyu ha ohah tangbal hi gulding ta apakawanan di bahulyu. Ya indawatyu bo ha duwah tangbal hi kalnero hi hinohhay tawonda ta mi'nong hi pi'hayyupanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ta itaggen nan padi ta i'nongna i ha\"on an Dios dadiyen duwan kalnero an hinohhay tawonda ya indawatna i ha\"on nan tinapay an nalpuh nan hopap di ginapasyu. Ya datuwen itaggen nan padi ta midawat ya bagina. ");
INSERT INTO ifa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ya i diyen algo ya adi ayu e muntamu ta ma'amung ayu ta mundayaw ayun ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ya munggapas ayu'e ya batiyonyu nan nundina'ging ya adiyu panuhon nadan magah ta alan nadan nun'awotwot ya nadan ni'iboblen da'yu. Ha\"on hi Apu Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Ibagam hinadan tinanud Israel ta nan hopap di algoh nan mi'apituh bulan ya pun'iblayanyu. Ot ma'amung ayu ta mundayaw ayu i ha\"on ya nun'ipagangohyu nadan trampeta. ");
INSERT INTO ifa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ya adi ayu e muntamu i diyen algo ta iyaliyu ha maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Hinan mi'apituh bulan ya nadatngan'e nan mi'apuluh algo ya hidiye nan algo an a'aanan di bungot'u an gapuh bahul. Ot adi ayu mangan i diyen algo ta ma'amung ayun namin ta i'nongyu nan maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ot adi ayu e muntamu te hidiyen algo di pangatanyuh nan mi'nong hi a'aanan di bungot'un Dios an gapuh bahul. ");
INSERT INTO ifa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ot nan mangan i diyen algo an adina itpol di inagangna ya mipapate ta adi mo midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ya atbohdih nan muntamu i diyen algo an dadago'. ");
INSERT INTO ifa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ot mahapul an un'unudonyuh tuwen tugun i da'yu ya ta'on on nadan tanudanyu ta ma\"id ha muntamu i diyen algo an ta'on on idanay awadanyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ot hituwen tungo ya mihipun hinan mun'ahdom hinan mi'ahiyam hi algo i diyen bulan ta inggana boh nan mun'ahdom i diyen ibiggatana. ");
INSERT INTO ifa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Ibagam boh nadan ibbam an tinanud Israel ta nadatngan'e nan mi'ahimpulut limah (15) algo i diye damdaman mi'apituh bulan ya ihipunyun ngilinon nan punnomnomnomanyuh nan nun'anallunganyuh nan agge naboblayan hi nalpuwanyuh ad Egypt ta inggana hi mala\"uh di pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ta hinan mamangulun algo ya ma'amung ayu ta dayawona' an adi ayu e muntamu. ");
INSERT INTO ifa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ya binigat hinan pituy algo ya iyeyu nadan maghob an mi'nong i ha\"on. Ya hinan mi'awaluh algon agibbuhan diyen ngilin ya adi ayu bo e muntamu ta ma'amung ayun namin ta i'nongyu nan maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ta danae nadan ngilinonyu hinadan nadutu' an algo an pungngilinanyu. Ta nadatnganda'e on na'amung ayu ta mundayaw ayu ya indawatyu nadan nipto' an midawat i diyen algo an umat hinadan maghob an mi'nong ya nadan midawat an alina ya ma'inum. ");
INSERT INTO ifa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ya nat'on tuwali nadan midawat hinan Habadun tungo ya nadan pinhodyu tuwalin idat i ha\"on ya nadan midawat hi'on nagibbuh nan imbagayun ha\"on hi atonyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ta atonyuh nae hinan malpah an mun'apit ayu nimpeh nan mi'apituh bulan an ngilinonyu hi pituy algo an ihipunyuh nan mi'ahimpulut limah (15) algo i diyen bulan. Ya ma\"id ha e muntamu ta mun'ible ayuh nan hopap di algo ya nan mi'awaluh algo. ");
INSERT INTO ifa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ya hinan hopap di algo ya eyu inala dohah nan maphod an bungan nadan intanomyun bungbunga\"an ya nangala ayuh tubun di palma ya hapang nan ma'attubun kayiw ya nadan kakaykayyiw an himmangoh nan pingngit di wa\"el. Ta gapuh amlongyu ya dayawona' hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ot ngilinonyuh tuwe hinan mi'apitu nimpeh bulan hi atawotawon ya ta'on on nadan mun'atanudan ya inaynayundan aton hituwe. ");
INSERT INTO ifa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ta an namin ayun tinanud Israel ya e ayu mangapyah allung hi punhituwanyu i diyen pituy algo. ");
INSERT INTO ifa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ta panginnilaan nadan tanudanyuh udum hi algo an nunhituwon da'yuh allung hidin nangipanguluwa' i da'yuh nalpuwanyuh ad Egypt. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ta hi Moses ya impa'innilanah nadan ibbanan tinanud Israel an namin danaen intugun Apu Dios hi ngilinonda. ");
INSERT INTO ifa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Ibagam hinadan ibbam an tinanud Israel ta mangiyalidah nadan namahmah an lanan nalpuh nan tinoptopdan olibo ta waday mikalgah nadan punhilawan ta nanongnan dumanaldallangdah ahodohodom. ");
INSERT INTO ifa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ya hi Aaron di muntolog hinan mahdom hinan punhilawan hidih nan tabernakel an wah nan hangngab nan kultina an munhandih nan niha\"adan nan Kahun an nittuwan nan Hapit'un Dios. Ya tigonda ta nanongnan buminabinang nadan hilaw ta ingganah nan mawi\"it. Ot hituwey ma'unud hi atonyuh inggana an ta'on on nadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ya atbohdin tigonyu ta nanongnan mipapto' nan punhilawan hidih nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ya alyon bon Apu Dios i Moses di, Idadaanyu ha maphod an alina ta iphodyuy himpulut duwan (12) tinapay. Ya hinan ohan tinapay ya duway kilun alinay iphodyu. ");
INSERT INTO ifa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ya ginodwayu ta hinonnom ya pinalpagyuh uhhun nan namahmah an balitu' an lamehaan hidih nan kuwartu' an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ya inha\"adanyuh nan maphod di hunghungnan insenso nan napalpagan dadiyen tinapay ta mipatigon midawat dadiyen tinapay i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ya hanat hinan ahabahabadu ya athidiy atonyuh nan tinapay an eyu iha\"ad hidih nan kuwartu' an Dios. Ya inaynayunyun aton datuwe an da'yun tinanud Israel an ta'on on hanadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ya hay idatan datuwen tinapay ya hi Aaron ya nadan holagna. Ya hay pangananda i datuwen tinapay ya hinan niyappit i ha\"on an pangananda te datuwey midat i dida an nalpuh nadan maghob an mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Wada han lala'in hay hi inana ya tinanud Israel mu nan hi amana ya i Egypt an immeh nan awadan nadan tinanud Israel ot mi'yawwit i han tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ya hidiyen imbabalen di i Egypt ya namaag ya pumba'bainah Apu Dios ta hiya nan inyeda i Moses hidiyen tagu. Ya hay ngadan inana ya hi Selomit an imbabalen Dibni an tinanudan Dan. ");
INSERT INTO ifa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ot ipaguwalyada ni' ta panpannodandah ibagan Apu Dios hi atondan hiya. ");
INSERT INTO ifa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Ibata\"anyuh naen taguh tun nun'allunganyu ya an namin ayun nangngol hi namihulanan ha\"on an Dios ya iha'moyuy ta'leyuh uluna. Ya nuntopayu ta ingganah mate. ");
INSERT INTO ifa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ot alyon mon Apu Dios i Moses di, Ibagam hinadan ibbam an tinanud Israel an hanan mama'bain i ha\"on an Dios ya madusa. ");
INSERT INTO ifa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ta adhuwanyun topon ta ingganay mate an ta'on on tinanud Israel onu ni'iboble i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ya nan pimmate ya mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ya nan mamateh animal di udum an tatagu ya mahapul an nan matagun paddung diyen pinatenay ihukkatna. ");
INSERT INTO ifa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ya nan tagun himmugat ya mahapul bon hugatonyu ta miyunnudan hinan inatnay ma'at i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ya hi'on pinutungnay tungal di ohan tagu ya putungonyu piboy tungalna. Ya pimmilok'e ya pilokonyu bo damdama. Ya wada'ey pinanguwana ya panguwanyu bo damdama. Ta nan inatnan adi maphod ya hidiyey ma'at bon hiya. ");
INSERT INTO ifa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ya hi'on animal nimpe nan pinaten nan tagu ya mahapul an hukkatanah nan animal an paddung diyen pinatena. Mu hi'on tagu nan pinatena ya mahapul bo damdaman mate. ");
INSERT INTO ifa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ot datuwey nitugun hi unudonyun tinanud Israel ya ta'on on nadan mi'iboblen da'yu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ta hidin indappuh Moses dadiyen imbagabagana ot eda ibata\"an hidiyen nama'bain i Apu Dios ot puntopada ta ingganaot mate. Te athidiy imbagan Apu Dios i Moses hi atonda. ");
INSERT INTO ifa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Hidin awadan Moses hidih nan billid hi ad Sinai ya imbagan Apu Dios nadan tugunah nadan tinanud Israel. Ta inalina i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Ibagam hinadan ibbam an tinanud Israel an wa'et dimmatong ayuh nan boblen idat'un da'yu ya hinan mi'apituh tawon ya adiyu tanoman nan luta ta pun'iblayonyu ta pangipatigoyuh pundayawyu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ta'ommanot onom di tawon di puntanomanyu ya pumpapto'anyu ya pun'apitanyuh nadan greyp ya nadan udum an intanomyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mu hinan mi'apituh tawon ya pun'iblayonyu nan luta an adiyu nimpe tanoman ya adiyu putulan nadan intanomyun greyp. Te hidiyen mi'apituh tawon ya niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ta i diyen tawon an pun'iblayan nan luta ya adi ayu muntanom ya adi ayu mun'apit. Mu kumpulna i da'yun namin di mangalah nadan bungan nadan pamaaggot humango an umat hinadan greyp an aggeyu impapto'. ");
INSERT INTO ifa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mu ta'on on athidi ya umdah damdama nadan apitonyu hi itanudyu hinadan baalyu ya ta'on on nadan puntamuwonyun nalpuh udum hi boble. ");
INSERT INTO ifa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ya umda boh anon nadan animalyu ya ta'on on nadan atap an animal hi bobleyu. Ta an namin nadan pamaaggot humangon makan ya mabalin an anonyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ya nala\"uh'e boy pituy mumpipituy tawon an hay ngammutna ya napat ta hiyam (49) di tawon ");
INSERT INTO ifa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ya hinan mi'anabongleh (50) tawon ya nadatngan'e nan mi'apuluh algo hinan mi'apituh bulan ya hidiye nan apakawanan di bahulyu ya alinglingan di gawatyu. Ot ipagangohyu nan tangguyub ta madngol hi an namin an boblen di tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Te hidiyen tawon ya niyappit i ha\"on ta an namin di himbutyu an ibbayun tinanud Israel ya ibangngadyuh nadan pamilyada. Ya an namin di lutan hinubliyanyu ya ipabangngadyuh nadan ud luta onu nadan tinanudanda. Ta mun'am'amlong ayun namin. ");
INSERT INTO ifa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ta i diyen mi'anabongleh (50) tawon ya adi ayu nimpe muntanom ya adi ayu mun'apit ta kumpulna i da'yun namin di mangalah nadan bungan nadan pamaaggot humango an umat hinadan greyp an aggeyu impapto'. ");
INSERT INTO ifa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Te hidiyen tawon ya niyappit i ha\"on. Ot ta'on on adi ayu muntamu ya mun'am'amlong ayu ot umdah hi itanudyu nadan bungan nadan namaaggot humangoh an kumpulnay e mangala. ");
INSERT INTO ifa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ya gapu ta hidiye nan tawon an pun'am'amlongan ya an namin nimpey lutan nihubli ya mipabangngad hinan ud luta tuwali onu nadan tinanudana. ");
INSERT INTO ifa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ya hi'on waday ihubliyu onu hubliyanyuh lutah nadan ibbayu ya hanat adiyu kulukon dida. ");
INSERT INTO ifa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ya hay atonyun mumbayad hinan gattangonyun lutan di ibbayu ya bilangonyu hi'on atnay tawon di nabati hi pun'apitanyuh itanomyu ya ahi madatngan nan tawon an pun'am'amlongan. ");
INSERT INTO ifa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ta hi'on madne ya ahi madatngan di ipabangngadana ya ong'ongngal di bayadna. Mu agagga'e ya nalaklaka. Te hay mabayadan ya nan dinakol nan ma'apit. ");
INSERT INTO ifa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ot adiyu nimpe kulukon di ibbayu ta atiganan ha\"on an Dios di un'unudonyu. Te ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ot hi'on inaynayunyun un'unudon nadan tugun'u ya tudtudu' ya malinggop di eyu iha''adan i diyen boblen umayanyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ya dakol di ibungan di itanomyu ta mahawwalan di anonyu ya malinggop ayu nimpe. ");
INSERT INTO ifa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mu ma\"id ha mapto' ya alyonyuy, Dana ihyay pangalan hi anon hi'on adita muntanom i diyen mi'apituh tawon? ");
INSERT INTO ifa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ot hay pambal'u ya wagaha' nan itanomyuh nan mi'anom hi tawon ta nan apitonyu ya umdah anonyuh tuluy tawon. ");
INSERT INTO ifa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ot hinan mi'awaluh tawon an puntanomanyu ta ingganah on ayu mun'apit hinan mi'ahiyam hi tawon ya adi ayu makulangan hi anonyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ya nadan lutan nidat i da'yu ya adi mabalin hi ihubliyu ta bagin nan nangattang hi inggana te ha\"on an Dios di ud luta. Te ni'iboble ayu ot tantanommanyu ya abuh hituwen luta' an bokonyu bagi. ");
INSERT INTO ifa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ta hiya nan waday lebbeng nan ud lutan mamangngad hinan inhublinan lutana. ");
INSERT INTO ifa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ya hi'on wada i da'yu ha maligligatan ta mapilitan an mangihublih lutana ya mabalin an bangngadon nan nihaghaggon an tulangna. ");
INSERT INTO ifa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Mu hi'on adida abalinan ya inggana moh on nan nangihubli di waday pihhuna ya ahina bangngadon. ");
INSERT INTO ifa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ya nan pihhun pamangngadna ya mi'alah nan bilang di apit ya ahi madatngan nan tawon an pun'am'amlongan. ");
INSERT INTO ifa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mu adina'e abalinan an bangngadon ya inggana moh on madatngan nan tawon an pun'am'amlongan ya ahi mipabangngad i hiya nan lutana. ");
INSERT INTO ifa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ya wa'et ha balen naha'mut hinan boblen na'alad hi binattun alad di inggattang di ohan tagu ya mabalin an bangngadona mu ta adi mala\"uh di hintawon. ");
INSERT INTO ifa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mu hi'on nala\"uh nan hintawon ya aggena binangngad ya bagin mon nan nangattang ta mabalin an ipaboltanah nadan holagnah inggana. Ya adi mo mabalin hi mipabangngad hinan nangigattang hi'on madatngan nan tawon an pun'am'amlongan. ");
INSERT INTO ifa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mu hi'on nan balen nihubli ya agge naha'mut hinan boblen na'alad hi binattun alad ya mabalin an mabangngad an ta'on on nala\"uh di ohay tawon an umat hinan nihublin luta. Ya adi e pa'abbangngad ya inggana moh on madatngan nan tawon an pun'am'amlongan ya ahi mibangngad i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Mu hi'on nan tinanud Libay di waday inggattangnah bale hinan boblen nidat i hiya ya waday lebbengnan mamangngad hi kumpulnan algo. ");
INSERT INTO ifa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Mu adi'e pa'abbangngad ya mibangngad i hiya hi'on madatngan nan tawon an pun'am'amlongan te hidiye han nidat i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mu nada'en pastu an ningammut hinan boblen nidat i dida ya adi mabalin hi ihublida te hidiye ya bagidah inggana. ");
INSERT INTO ifa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ya hi'on waha ibbayun tinanud Israel hi maligatan ta adina ahan abalinan an tanudan di adolna ya mahapul an boddanganyu ta umat hinan atonyuh nadan ni'iboblen da'yu onu nadan puntamuwonyun nalpuh udum hi boble ta nanongnan munhitu ayuh din namin. ");
INSERT INTO ifa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ya adiyu hingilon di pulsintun nan ipabuludyun dida ta ha\"on an Dios an dayawonyuy taktanyu. Ta wan nanongnan mi'hitun da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ya atbohdin adiyu ipapulsintu nan ipabuludyun dida an pihhu ya adiyu pungganansiyaan dida hinan makan an igattangyun dida. ");
INSERT INTO ifa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ot hanat nomnomnomonyu datuwen tugun'un Dios an nangikak i da'yuh ad Egypt ot idat'un da'yu nan bobleh ad Kanaan ta wan ha\"on di Dios hi dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ya alina'eh on waha ohah nadan ibbayu hi nunhiglan maligatan ta mapilitan an mangigattang hi adolna i da'yu ya hanat adi umat hi atonyuh nan himbutyu di atonyun mumpatamu i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Hanat ibilangyun hiyay ohah nadan ipabo'laanyu an mi'hitu i da'yu ta puntamuwonyu ta ingganah madatngan nan tawon an pun'am'amlongan. ");
INSERT INTO ifa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ya i diyen tawon ya ipalubusyun umanamutdan hina'ammah nan pamilyanah nan boblen nidat i didan himpamu'un. ");
INSERT INTO ifa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Te ha\"on an Dios di nangipangulun da'yuh nanaynanyuh ad Egypt ta ha\"on moy ud baal i da'yun tinanud Israel. Ta hiya nan adi ayu mo mabalin an mihbut. ");
INSERT INTO ifa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ot tigonyu ta adiyu paligaton dida ta atiganan ha\"on an Dios di un'unudonyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ya hi'on mahapulyuy baal ya gumattang ayuh nadan malpuh udum hi boblen wah nunlini\"odanyu. ");
INSERT INTO ifa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ya mabalin bon gumattang ayuh nadan ni'iboblen da'yu onu nadan holagdan niyayyam hi bobleyu ta mabalin an diday himbutyuh inggana. ");
INSERT INTO ifa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ya mabalin bon ipaboltanyu didah nadan imbabaleyu ta munhilbidan da'yu hi ingganah atayanda. Mu adiyu aton hidi hinadan ibbayun tinanud Israel ya tigonyu ta adiyu paligaton dida. ");
INSERT INTO ifa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ya alina'eh on waha ni'iboblen da'yu hi kimmadangyan ya waha ohah nadan ibbayun tinanud Israel hi maligligatan ta mapilitan an mangigattang hi adolna onu nadan holagna hinan kimmadangyan an ni'iboblen da'yu ");
INSERT INTO ifa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ya wada damdamay lebbengnan mamangngad. Ta mabalin an ohah nadan i'ibanay mamangngad i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ya mabalin bo an hi ulitauna onu nadan nihaghaggon an tulangna onu hiya mismuy mamangngad hi adolna hi'on waday abalinana ta mapogpog di ahimbutna. ");
INSERT INTO ifa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ta eda bilangon hinan nangattang i hiya nan nabatin tawon ya ahi madatngan nan tawon an pun'am'amlongan. Ya binilangda nan mipabangngad an miyunnudan hinan bo'laon di ohan puntamuwon i dadiyen nabatin tawon. ");
INSERT INTO ifa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ot hi'on madne ya ahi madatngan nan tawon an pun'am'amlongan ya ongal di mipabangngad hinan nangattang i hiya. ");
INSERT INTO ifa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Mu hi'on agagga ya madatngan hidiyen tawon an pun'am'amlongan ya binilangda nan nabati ta wan nan lebbengnan mabayadan di bayadanda. ");
INSERT INTO ifa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ya tigonyu ta adi paligaton nan nangattang i hiya ta ibilangnan hiyay ohah nadan pabo'laanah atawotawon. ");
INSERT INTO ifa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Mu ta'on on agge nabangngad ya mahapul an ipalubus nan nangattang an umanamutdan hina'amma hi'on madatngan nan tawon an pun'am'amlongan. ");
INSERT INTO ifa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Te da'yun tinanud Israel ya adi mabalin an himbut da'yuh nan nangattang i da'yuh inggana te ha\"on an Dios di ud baal i da'yu. Te ha''on di nangkak i da'yu hi nanaynanyuh ad Egypt. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Alyon bon Apu Dios di, Adi ayu mangipata'dog hi batu ta dayawonyu. Ya adi ayu mangap'apyah pina'ot an tinagtaggun kayiw onu batu hi dayawonyu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ya mahapul an ngilinonyu nan Habadun tungo. Ya ipatigoyun bainanyu nan tabernakel. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ya wa'et nan pohdo' di atonyu ta un'unudonyu nadan tugun'u ");
INSERT INTO ifa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ya ipa'ali' di udan hinan timpun punhapulanyu ta pumhod di itanomyu ya bumungaday intanomyun bungbunga\"an. ");
INSERT INTO ifa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ta dakol di apitonyu ta damunah idappuhyun mun'ilik hinadan ginapasyu yaden nadatngan boy pun'apitanyuh greyp. Ya dakol di apitonyun greyp ta ahi ma'akhupan nan ahitanom hi ilik. Ta mahawwalan di anonyu ya malinggop di iha\"adanyuh nan numboblayanyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ta malinggop ayu nimpeh nan numboblayanyu ta maphod di eyu alo'an an ma''id ha itakutyu. Ya abulo' nadan atatakut an animal hinan potaal ta adida umalih nan numboblayanyu. Ya ma\"id ha umalih mangubat i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mu hi'on waday umalin mangubat i da'yu ya da'yuy pangabako' ta da'yuy mamaten dida. ");
INSERT INTO ifa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ta ta'on hi ammuna ayu ha lima ya abakonyuy hinggahut (100) an binuhul. Ya wa'e ha hinggahut (100) i da'yu ya abakonyuy himpuluy libu (10,000) ta pumpateyu didah gubat. ");
INSERT INTO ifa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ya ipapto' da'yun ha\"on ta pa'annungo' nan imbaga' an ato' i da'yu ta wagahan da'yu ya impadakol'uy holagyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ta dakol di apitonyu ta lo'tat ya ta'on on nadan an'annonyun ba'ak ya ipalah'unyuh nan alangyu ta waday pangiha''adanyuh nadan pa'aggapas. ");
INSERT INTO ifa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ya alyon bon Apu Dios di, Umaliya' an mi'hitu i da'yu ta adi da'yu iwalong i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ta nanongnan wadawadaa' i da'yu ta ha\"on di dayawonyu ya da'yuy ibilang'uh tatagu'. ");
INSERT INTO ifa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Te ha\"on nan Dios an dayawonyu an nangikak i da'yuh ad Egypt ta napogpog di ahimbutyuhdi te paddungnay pinutung'u nan panakul hi bagangyu ta libli ayu mohpe. ");
INSERT INTO ifa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Alyon bon Apu Dios di, Wa'et adiya' donglon i da'yu ta adiyu aton nadan imbaga' hi atonyu ");
INSERT INTO ifa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ta ngohayonyu nadan tudtudu' ya adiyu unudon nadan tugun'u ta ibahhoyu nadan imbaga' i da'yu ");
INSERT INTO ifa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ya dusaon da'yu. Ta ipa'ali' di nunhiglan punligatanyu an umat i ha dogoh an adi ma'agahan ya ha nunhiglan pudut di adolyu an pumilok ya ngimpunay adolyu. Ya ma\"id ha hilbin di itanomyu te hay binuhulyuy mangan. ");
INSERT INTO ifa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ya iwalong da'yun ha\"on ta abakon da'yuh nadan binuhulyu ta diday mun'ap'apu i da'yu. Ta gapuh takutyu ya pamaagyuh butik an ta'on on ma\"id ha mamdug i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ya innayun bon Apu Dios an alyon di, Mu hi'on ma'at datuwen da'yu ya apyanan adiya' damdama donglon i da'yu ya udma' hi mumpipituy pundusa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ta adi' pa'aliyon di udan ta mamaganan di attog nan luta ta lo'tat ya kimmulhin ay gumo' ta innilaonyun waday pogpog di abalinanyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ta ma\"id ha hilbin di hinluyu te ningamut an adi tumaguy itanomyu ya atbohdin adida bumunga nadan bungbunga\"an. ");
INSERT INTO ifa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Mu hi'on ma'at danae i da'yu ya hiyah diye damdaman mungngohe ayun ha\"on ya hiyah diye bon udma' hi mumpipituy punligatanyu ta miyunnudan hinan numbahulanyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ta ipa'ali' nadan atap an animal ta pumpateda nadan imbabaleyu ya ta'on on nadan halunyu ta ma\"id ha batiyonda. Ta ammuna ha oh'ohhah mabati i da'yu ta lo'tat ya matowan nadan awonyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Mu hi'on ma'at damdama danae i da'yu ya hiya damdamah diyen adi ayu manomnoman an onyu ot inaynayun an mungngohen ha\"on ");
INSERT INTO ifa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ya atbohdin udma' hi mumpipituy punligatanyu ta miyunnudan hinan pumbahulanyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Te ipa'ali' di mangubat i da'yu ta pangiballo' i da'yu hinan nangibahhawanyuh nadan imbaga' i da'yu. Ya ta'on on e ayu mipa\"eh nadan nahamad di aladnan boble ya ipa'ali' damdama han dogoh an adi ma'agahan ta ingganah on da'yu abakon hinadan binuhulyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ya ipa'ali' boy bitil ta ma\"id ha anonyu ta lo'tat ya ta'on on pun'u'uddumon di himpulun binabai nan hingkikittang an alinan wadan dida ya ammuna ha ohan pinakawan di iha\"angana. Ta ammunadi ya inupi'upingyu ta iya'appongyu mu undan mohpe bumhug ha athidi. ");
INSERT INTO ifa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Mu hi'on ma'at datuwe ya hiyah diye damdaman inaynayunyun mungngohe i ha\"on ");
INSERT INTO ifa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ya gapuh bungot'u ya iyal'ala' an mangdum ot ahan hi pundusa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ta punnanongo' nan bitil ta lo'tat ya adi ayu mo ahan pa\"itpol hi inagangyu ta ta'on on nadan imbabaleyu ya anonyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ya dadago' nadan pundayawanyu ya ta'on on nadan punggohobanyuh insenso. Ya imponpon'u nadan adolyu hi awadan nadan bululyun nangihukkatanyun ha\"on an Dios. Ya ahiwawan da'yu mon ha\"on ");
INSERT INTO ifa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ta hiya nan dadago' nadan numboblayanyu ya ta'on on nadan pundayawanyu. Ya adi umipa'amlong i ha\"on nadan hunghung nadan i'nongyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ya dadago' nimpe nan numboblayanyu ta ma\"id ha amagna ta ta'on on nadan binuhulyun ap'apuhdi ya masda'awdah ena adadagan. ");
INSERT INTO ifa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Te ipa'ali' di mangubat i da'yu ya inwakat da'yuh abobboble. Ta matowan nadan numboblayanyu ta munnanong hinan ena nadadagan. ");
INSERT INTO ifa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ta i diyen awadanyuh boblen nadan binuhul ya paddungnay mun'am'amlong nan lutayun mun'ible. ");
INSERT INTO ifa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Te aggeyu tuwali nun'iblayon hi awadanyuhdi an ta'on on nadatngan nan alyo' hi adiyu puntanoman hinan luta ta mun'ible on imbahhoyu. Ta i diyen ena adadagan ya mabalin mohpen mun'ible. ");
INSERT INTO ifa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ya nada'en mabatin da'yu ya pumbalino' hi ma'attakut ta ammuna ha gumiwol hi tubu hi'on dimmibdib on mamtik ayu. Ya pamaag bo on mamtik ayu ta mun'ihuhungbub ayu an ay waha mamdug i da'yuh binuhulyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ta mun'ihahali'dud ayuh nadan ibbayun nun'atutukkad te pamaagyu nimpey butik an ay waha tuweh mangubat i da'yu. Ta lo'tat ya adiyu abalinan an mangubat hinadan binuhulyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ta mun'a'ate ayuh nadan boblen di binuhulyu ya nilubu' ayuhdi ta paddungnay ukmunon da'yuh nan lutada. ");
INSERT INTO ifa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ya hanada'en mabati i da'yu an adi mate ya ma'ohha'ohhadan mate ta lo'tat ya napuh ayu an gapuh bahulyu ya bahul di a'ammodyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Mu abulutonyu'e tuwalin numbahul ayu ta iba\"agyuy numbahulanyu ya ta'on on hay numbahulan handidan a'ammodyu an gapuh aggeyu nangun'unudan hinadan tugun'u ya hay nungngohayanyun ha\"on ");
INSERT INTO ifa_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ta hiya nan inwalong da'yu i ha\"on ot ipa'e da'yuh boblen nadan binuhulyu ya mumpada\"ul ayu'e ta nalpah mon binayadanyuy bahulyu ");
INSERT INTO ifa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ya ahi mabalin an ato' nadan imbaga' i handidan a'ammodyun da Jacob ya hi Isaac ya hi Abraham. Ya adi' ibahhon aton nadan imbaga' hi aton hi bobleyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Te hay ma'at ya iwalongyuh diyen luta ta i diyen ama\"idyuhdi ya adi matanoman ta padungnay mun'ible nimpe nan luta. Ta ingganah malpah an holtaponyu nan numbahulanyun gapuh aggeyu nangunudan hinadan tugun'u. ");
INSERT INTO ifa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mu ta'on on athidi ya adi ahan tatawwa pamaag ya ingnganuy da'yuh nan boblen nadan binuhulyu ta ingganay mate ayun namin te ato\"ehdi ya undan bo adi' ibbaho nan imbaga' hi ato' i da'yu. Ha\"on nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ta hiya nan ihwang da'yu an gapuh nan imbaga' i handidan a'ammodyun impangulu' hi nakakandah ad Egypt ta mipatigoh atagutaguh abobboble nan ongal an abalina' ta wan ha\"on di dayawonyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ot hiya danae nadan tugun ya tudtudun Apu Dios hinadan tinanud Israel an imbaganan Moses hidih nan billid hi ad Sinai. ");
INSERT INTO ifa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Athituy ibagam hinadan ibbam an tinanud Israel. An wa'e ta ha idawatyun ha\"on ya tagu an gapu ta pohdonyun ipa'annung nan imbagayun aton ya athituy bayadanyu hi'on pohdonyun bangngadon. ");
INSERT INTO ifa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Nan lala'in nuntawon hi bainti (20) ta ingganah nanom (60) ya hay bayadanyu ya nabongley (50) silber an hay balol di ohan silber ya miyunnudan hinan ohan pihhun silber hidih nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Mu babai'e ya tulumpuluy (30) silber. ");
INSERT INTO ifa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ya nan ungan lala'i an nuntawon hi onom ta ingganah himpulut hiyam (19) ya baintiy (20) silber. Ya nan babain athidi damdamay tawona ya himpuluy (10) silber. ");
INSERT INTO ifa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ya nan lala'in golang ta ingganah limay tawona ya limay silber di bayadanyu. Ya tuluy silber hi'on golang an babai. ");
INSERT INTO ifa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Nan lala'in nuntawon hi nanom ta oha (61) onu mahuluk ya himpulut limay (15) silber ya himpuluh (10) nadan babain athidi boy tawona. ");
INSERT INTO ifa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Mu hi'on nan tagun mangidawat ya nawotwot ta adina abalinan an bayadan ya mahapul an iyenah diyen tagun midawat hinan padi ta hiyay ukod hinan ibaganan balolna an miyunnudan hinan abalinan nan mangidawat an bayadan. ");
INSERT INTO ifa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ya onha animal an mabalin an mi'nong i ha\"on an Dios di nidawat ot mibilang hidiyen animal hi niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ta adi mabalin hi hukkatana an ta'on on alyon hi impohpohod nan ihukkatna. Te hukkatana'e ya ta'on on hidiyen ihukkatna ya niyappit damdama i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mu hi'on nan imbaganah i'nongna ya nan animal an mibilang hi nalugit an adi mabalin hi mi'nong i ha\"on an Dios ya mahapul an ena ipatigoh nan padi. ");
INSERT INTO ifa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ta hiyay mangibaga hi'on maphod onu adi. Ya hi'on nganney ibagan nan padih balolna ya hiyah diyen adi maluman. ");
INSERT INTO ifa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ot pohdon'en nan ud bagin bayadan ta bangngadona ya mahapul an udmanay pumbayadna hi mi'alimah nan balol nan pamayadna. ");
INSERT INTO ifa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ya hi'on nan tagu ya nan balenay idawatna ta miyappit i ha\"on an Dios ya nan padi di mangibagah balolna an miyunnudan hinan a'atna. Ya nan pumbalol nan padi ya hiyah diyen adi maluman. ");
INSERT INTO ifa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ot pohdon'en diyen ud balen bayadan ta bangngadona ya mahapul an pi'bayadna nan pulsintuna an mi'alimah nan balol nan bayad nan bale. ");
INSERT INTO ifa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ya hi'on nan tagu ya hay indawatnan ha\"on an Dios ya ha kittang hinan binoltanan luta ya hay balol di pamangngadna ya miyunnudan hinan dinakol di mitanom hidi. Ot nan lutan baintiy (20) kiluy tanomna ya himpuluy (10) silber di bayadna. ");
INSERT INTO ifa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ya wa'e ta nan puntanoman di idawatna ta miyappit i ha\"on an Dios hinan tawon an pun'am'amlongan ya nan balolna tuwalin nibaga di bayadana. ");
INSERT INTO ifa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mu nalpah'e mo nan tawon an pun'am'amlongan ya ahina idawat hidiyen lutana ya balolan nan padi an miyunnudan hinan bilang di tawon ya ahi bo madatngan nan tawon an pun'am'amlongan. Ot nan balolna ya hiyah diyen adi mahukkatan. ");
INSERT INTO ifa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ot pohdona'en bangngadon ya mahapul an bayadana nan balolna ya inudmanah mi'alima nan balolna ta hidiyey pulsintuna. ");
INSERT INTO ifa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mu hi'on aggena binangngad ya inggattangnah ohan tagu ya adi mo mabalin hi bangngadonah inggana. ");
INSERT INTO ifa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ot madatngan'e nan tawon an pun'am'amlongan ta ibangngad nan nangattang ya mumbalin mo hi niyappit i Apu Dios. Ot mumbalin moh bagin nadan padi ta adi mo mabalin an mabangngad. ");
INSERT INTO ifa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ya hi'on hay idawat di ohan tagun ha\"on an Dios ya nan lutan hinubliyana ");
INSERT INTO ifa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ya nan padi di mangibagah nan balolna an miyunnudan hinan bilang di tawon ya ahi madatngan nan tawon an pun'am'amlongan. Ta nan pihhun ibayad diyen tagu ya mibilang hi niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ot madatngan'e nan tawon an pun'am'amlongan ya hay ipabangngadan diyen puntanoman ya nan ud bagi tuwali onu nan holagna. ");
INSERT INTO ifa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ta hay ma'unud hinan pumbalol hi kumpulna ya miyunnudan hinan pihhun silber hinan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Mu hay adi mabalin hi idawatyun ha\"on ya nadan hopap di imbabalen di bakayu onu kalneroyu te on tuwali bagi'. ");
INSERT INTO ifa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mu nan hopap di imbabalen di halunyu an mibilang hi nalugit ya mabalin an bayadanyu nan balolna ya inudmanyuh mi'alima hinan balol nan bayadanyu ta ahiyu bangngadon. Mu hi'on adi pohdon nan ud bagin bangngadon ya mabalin an inginan nan padih udum an tatagu. ");
INSERT INTO ifa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Mu an namin di niyappit tuwalin ha\"on an Dios an umat hi tagu onu animal onu binoltan an luta ya adi mabalin hi bayadan nan ud bagi ta bangngadona. Ya adi bo mabalin an inginana te niyappit tuwalin ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ot nan tagun ha\"on an Dios di mangalin hiya hi mun'appit hi madadag ya adi mabalin hi mabayadan ta mabangngad te mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ya an namin nadan mi'apuluh (10) nadan ma'apit an bungan di itanomyu ya ha''on di ud bagi te dadiye ya niyappit i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ot hi'on pohdon nan tagun bayadan ta bangngadona nan mi'apuluh (10) nan inapitna ya mahapul an udmana nan bayadna hi mi'alima hinan balol nan bayadana. ");
INSERT INTO ifa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ya atbohdih nadan bakayu ya kalneroyu an wa'et mumbilang ayuh nadan imbabalena ya an namin di mi'apulu ya niyappit i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ta mumbilang'e nan ud animal ya nan nipto'an nan mi'apulu ya hiyah diyen adi mabalin hi hukkatana. Mu hukkatana'e tuwali ya ta'on on nan ihukkatna ya niyappit i ha\"on ot adi mabalin hi bangngadona dadiyen duwa. ");
INSERT INTO ifa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ot hiya danae nadan tugun Apu Dios hinadan tinanud Israel an imbaganan Moses hidih nan billid hi ad Sinai.");
INSERT INTO ifa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Hidin mi'adwah tawon hi nakakan nadan tinanud Israel hi ad Egypt an ohay algo han nibaluh din mi'adwah bulan ya immeh Moses hinan tabernakel an pi'dammuwanda i Apu Dios hinan agge naboblayan hi ad Sinai. Ya alyon Apu Dios i hiyay, ");
INSERT INTO ifa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Eyu bilangon nadan ibbayun tinanud Israel an ihipunyuh nadan himpahimpamu'un ya inohha'ohhayun intudo' di ngadan nadan linala'i. ");
INSERT INTO ifa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ta itudo'yu i Aaron di ngadan nadan mabalin an e mi'gubat an nuntawon hi bainti (20) onu mahuluk. ");
INSERT INTO ifa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ya alyon bon Apu Dios di, Hanat hinan ohan tinanud on waha ohah ap'apuda ta bumoddang i da'yun mumbilang. ");
INSERT INTO ifa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ot datuwe nadan linala'in bumoddang i he\"a. Hinan tinanud Ruben ya hi Elisur an imbabalen Seduer. ");
INSERT INTO ifa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Ya hinan tinanud Simeon ya hi Selumiel an imbabalen Surisadday. ");
INSERT INTO ifa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Ya hinan tinanud Judah ya hi Nahson an imbabalen Amminadab. ");
INSERT INTO ifa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ya hinan tinanud Issakar ya hi Netanel an imbabalen Suar. ");
INSERT INTO ifa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Hinan tinanud Sebulun ya hi Eliab an imbabalen Helon. ");
INSERT INTO ifa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Ya hinan tinanud Joseph ya duwada an hay napilih nan tinanud Epraim ya hi Elisama an imbabalen Ammihud. Ya hinan tinanud Manasseh an imbabalen bon Joseph ya hi Gamaliel an imbabalen Pedasur. ");
INSERT INTO ifa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Ya hinan tinanud Benjamin ya hi Abidan an imbabalen Gideoni. ");
INSERT INTO ifa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ya hinan tinanud Dan ya hi Ahieser an imbabalen Ammisadday. ");
INSERT INTO ifa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ya hinan tinanud Aser ya hi Pagiel an imbabalen Okran. ");
INSERT INTO ifa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Ya hinan tinanud Gad ya hi Eliasap an imbabalen Dewel. ");
INSERT INTO ifa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ya hinan tinanud Naptali ya hi Ahira an imbabalen Enan. ");
INSERT INTO ifa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ta danae nadan linala'in napili an mangipangpanguluh nadan himpahimpamu'un an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ta inawit da Moses i Aaron danaen linala'in napili ");
INSERT INTO ifa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ot didan namin an nun'amung hinadan tataguh din ohay algoy nibaluh nan mi'adwan bulan ta bilangonda dida. Ot ibagan nadan tatagu nan pu'un an nalpuwanda ya nadan hi amada ot itudo'day ngadan nadan linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) ");
INSERT INTO ifa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ta inunudda nan imbagan Apu Dios i Moses. Ya hay nangatandan diye ya hidih nan agge naboblayan hi ad Sinai. ");
INSERT INTO ifa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ta hinan tinanud nan panguluwan an hi Ruben ya an namin nadan mabalin an mi'gubat an linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) ya nitudo' di ngadanda an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ya hay bilang nadan tinanud Ruben ya napat ta onom di libu ta han limay gahut (46,500). ");
INSERT INTO ifa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ya hinan tinanud Simeon ya nitudo' bon namin di ngadan nadan linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ya hay bilangdan tinanud Simeon ya nabonglet hiyam di libu ta han tuluy gahut (59,300). ");
INSERT INTO ifa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ya hinan tinanud Gad ya an namin bo nadan linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'da boy ngadanda an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ya hay bilangdan tinanud Gad ya napat ta limay libu ta onom di gahut ta han nabongle (45,650). ");
INSERT INTO ifa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ya hinan tinanud Judah ya an naminda bo an linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'day ngadanda an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ya hay bilangdan namin ya napitut opat di libu ta han onom di gahut (74,600). ");
INSERT INTO ifa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ya hinan tinanud Issakar ya an naminda bo nadan linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'day ngadanda an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ya hay bilangdan tinanud Issakar ya nabonglet opat di libu ta han opat di gahut (54,400). ");
INSERT INTO ifa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ya hinan tinanud Sebulun ya an namin bo nadan linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) ya intudo'day ngadanda an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ya hay bilangdan tinanud Sebulun ya nabonglet pituy libu ta han opat di gahut (57,400). ");
INSERT INTO ifa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ya hinan imbabalen Joseph an hi Epraim ya an naminda bo nadan tinanudna an linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya nitudo' boy ngadanda an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ya hay bilangdan tinanud Epraim ya napat di libu ta han limay gahut (40,500). ");
INSERT INTO ifa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ya hana'en oha bon imbabalen Joseph an hi Manasseh ya an namin nadan tinanudna an linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) ya nitudo' boy ngadan nadan mabalin an mi'gubat an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ya hay bilangdan tinanud Manasseh ya tulumpulut duway libu ta han duway gahut (32,200). ");
INSERT INTO ifa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ya hinan tinanud Benjamin ya an naminda bon linala'in nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'da boy ngadanda an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ya hay bilangdan tinanud Benjamin ya tulumpulut limay libu ta han opat di gahut (35,400). ");
INSERT INTO ifa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ya hinan tinanud Dan ya an namin bo nadan nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'da boy ngadanda an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ya hay bilangdan tinanud Dan ya nanom ta duway libu ta han pituy gahut (62,700). ");
INSERT INTO ifa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ya hinan tinanud Aser ya an namin bo nadan linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an mi'gubat ya intudo'da boy ngadanda an miyunnudan hinadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ya hay bilangdan tinanud Aser ya napat ta ohay libu ta han limay gahut (41,500). ");
INSERT INTO ifa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ya hinan tinanud Naptali ya an naminda bo an linala'i an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an mabalin an e mi'gubat ya intudo'da boy ngadanda an miyunnudan hinan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ya hay bilangdan tinanud Naptali ya nabonglet tuluy libu ta han opat di gahut (53,400). ");
INSERT INTO ifa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ta datuwe nadan linala'i an binilang da Moses ya hi Aaron ya nadan himpulut duwan (12) mangipangpangulun dida an nalpuh nadan himpulut duwan (12) tinanud Israel an niyukodan nadan pu'un an nalpuwanda. ");
INSERT INTO ifa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ya an namin nadan tinanud Israel an nuntawon hi bainti (20) ya nadan mahuluk hi bainti (20) an binilangda ya dida nimpe nadan mabalin an e mi'gubat. ");
INSERT INTO ifa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Ya hay bilangdan namin ya onom di gahut ta tuluy libu ta han limay gahut ta nabongle (603,550). ");
INSERT INTO ifa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mu aggeda ni'bilang nadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Te alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Adim pi'bilang nadan tinanud Libay hi pumbilangam hinadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mu hay ipa'atmu i dida ya diday mumpapto' hinan tabernakel ya an namin nadan gina'uhdi. Ta diday mangdon hinadan ma'usal hinan tabernakel hinan pumbaatanyu ya hinan ipata'dogana. Ya hay pun'allungan nadan tinanud Libay ya hinan nunli\"odan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ya an namin di akakanyu ya diday mamalu'ah ya atbohdin dida nimpey ukod an mangipata'dog. Ya wadada'ey udum an e mihaggon hidi ya mipapateda. ");
INSERT INTO ifa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ya nan umohnonganyun namin ya mahapul an waday panuhna ta hinan ohan pu'un on nadutu' nan eyu pun'allungan an hinan nangiha\"adanyuh nan bandelayu. ");
INSERT INTO ifa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mu nada'en tinanud Libay ya mun'allungda nimpeh nan way nunlini\"odan nan tabernakel ta guwalyaanda. Ta wan ma\"id ha lummuh bumungota' an Dios i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ta inunud nadan tinanud Israel an namin nadan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Ibagayuh nadan ibbayun tinanud Israel ta ohan grupu on waday bandelada ta nadutu' di eda pun'allungan. Ta li'wohonda nan tabernakel mu ta midawdawwida. ");
INSERT INTO ifa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ot hay mun'allung hi nangappit hi tuluwan di algo ya nadan grupun Judah hinan way bandelada. Ya hay mangipangpanguluh nadan tinanud Judah ya hi Nahson an imbabalen Amminadab. ");
INSERT INTO ifa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ya hay bilang nadan linala'in nabilang ya napitut opat di libu ta han onom di gahut (74,600). ");
INSERT INTO ifa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ya hay mihnod i dida ya nadan tinanud Issakar an hay mangipangpangulun dida ya hi Netanel an imbabalen Suar. ");
INSERT INTO ifa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ya hay bilang nadan linala'in nabilang ya nabonglet opat di libu ta han opat di gahut (54,400). ");
INSERT INTO ifa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ya nihnodda nadan tinanud Sebulun an hay mangipangpangulun dida ya hi Eliab an imbabalen Helon. ");
INSERT INTO ifa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ya hay bilang nadan linala'in nabilang ya nabonglet pituy libu ta han opat di gahut (57,400). ");
INSERT INTO ifa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ta hay bilang nadan linala'in nabilang hinadan grupun Judah ya hinggahut ta nawalut onom di libu ta han opat di gahut (186,400). Ta an namin di akakandan tinanud Israel on diday mamangulu. ");
INSERT INTO ifa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ya hay mun'allung hi nangappit hi muyyad nan tabernakel ya nadan grupun Ruben hinan way bandelada. Ya hay mangipangpanguluh nadan tinanud Ruben ya hi Elisur an imbabalen Sedeur. ");
INSERT INTO ifa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ya hay bilang nadan linala'in nabilang ya napat ta onom di libu ta han limay gahut (46,500). ");
INSERT INTO ifa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ya hay mihnod i dida ya nadan tinanud Simeon an hay mangipangpangulun dida ya hi Selumiel an imbabalen Surisadday. ");
INSERT INTO ifa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ta hay bilang nadan linala'in nabilang ya nabonglet hiyam di libu ta han tuluy gahut (59,300). ");
INSERT INTO ifa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ya hay mihnod ya nadan tinanud Gad an hay mangipangpangulun dida ya hi Eliasap an imbabalen Dewel. ");
INSERT INTO ifa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ya hay bilang nadan linala'in nabilang ya napat ta limay libut onom di gahut ta han nabongle (45,650). ");
INSERT INTO ifa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ta hay bilang nadan linala'in nabilang hinan grupun Ruben ya hinggahut ta nabonglet ohay libut opat di gahut ta han nabongle (151,450). Ta dida nan mihnod an makak. ");
INSERT INTO ifa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ya hay migawwah nan pumbaatanda ya nadan tinanud Libay an mangdon hinan agimangnun nan napalu'ah an pundayawan. Ta napanuh nan atondan mumbaat an umat damdamah nan panuh di pun'allunganda hinan way bandelada. ");
INSERT INTO ifa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ya hay mun'allung hi nangappit hi alimuhan di algo ya nadan grupun Epraim hinan way bandelada. Ya hay mangipangpanguluh nadan tinanud Epraim ya hi Elisama an imbabalen Ammihud. ");
INSERT INTO ifa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ya hay bilang nadan linala'in nabilang ya napat di libu ta han limay gahut (40,500). ");
INSERT INTO ifa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ya hay mihnod i dida ya nadan tinanud Manasseh an hay mangipangpangulun dida ya hi Gamaliel an imbabalen Pedahsur. ");
INSERT INTO ifa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ya hay bilang nadan linala'in nabilang ya tulumpulut duway libu ta han duway gahut (32,200). ");
INSERT INTO ifa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ya hay mihnod i dida ya nadan tinanud Benjamin an hay mangipangpangulun dida ya hi Abidan an imbabalen Gideoni. ");
INSERT INTO ifa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ya hay bilang nadan linala'in nabilang ya tulumpulut limay libu ta han opat di gahut (35,400). ");
INSERT INTO ifa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ta hay ngammutdan nabilang i diyen grupun Epraim ya hinggahut ta waluy libu ta han hinggahut (108,100). Ya dida nan mi'atlun grupu hi'onda mumbaat. ");
INSERT INTO ifa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ya hay nun'allung hi nangappit hi huddo' nan tabernakel ya nan grupun Dan hinan way bandelada. Ya hay mangipangpanguluh nadan tinanud Dan ya hi Ahieser an imbabalen Ammisadday. ");
INSERT INTO ifa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ya hay bilang nadan linala'in nabilang ya nanom ta duway libut pituy gahut (62,700). ");
INSERT INTO ifa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ya hay nihnod i dida ya nadan tinanud Aser an ipangpangulun Pagiel an imbabalen Okran. ");
INSERT INTO ifa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ya hay bilang nadan linala'in nabilang ya napat ta ohay libu ta han limay gahut (41,500). ");
INSERT INTO ifa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ya hay nihnod i dida ya nadan tinanud Naptali an hay mangipangpangulun dida ya hi Ahira an imbabalen Enan. ");
INSERT INTO ifa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ya hay bilang nadan linala'in nabilang ya nabonglet tuluy libu ta han opat di gahut (53,400). ");
INSERT INTO ifa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ta hay bilang nadan linala'in nabilang hinan grupun Dan ya hinggahut ta nabonglet pituy libu ta han onom di gahut (157,600). Ta diday ma'udih nan akakandah nan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ta hay bilangdan naminamin an linala'in nabilang hinan nun'allunganda ya onom di gahut ta tuluy libu ta han limay gahut ta nabongle (603,550). ");
INSERT INTO ifa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mu aggeda nimpe iniddum an ni'bilang nadan tinanud Libay te hidiyey imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ta datuwen tinanud Israel ya inunuddan namin nadan imbagan Apu Dios i Moses. Ta hiya nan ohan pamilya on eda nun'allung hinan nadutu' an pun'allunganda an awadan di bandelada. ");
INSERT INTO ifa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hidin himmapit hi Apu Dios i Moses hinan billid hi ad Sinai ya datuwe nadan imbabalen Aaron an hi ibban Moses. ");
INSERT INTO ifa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Hay ngadan nadan linala'in imbabalen Aaron ya hi Nadab an panguluwan ya hi Abihu ya hi Eleasar ya hi Itamar. ");
INSERT INTO ifa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ta dida nadan nahiitan hi lana di uluda ta munhilbida an padi. ");
INSERT INTO ifa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mu da Nadab i Abihu ya nateda hidin munggohobdah nan insenso an idawatda i Apu Dios te agge niyunnudan hinan pohdon Apu Dios nan inatda. Hay na'atan tuwe ya hidin nun'allungandah nan agge naboblayan hi ad Sinai. Ya ma\"id ha imbabaledan duwa ta ammuna mo da Eleasar i Itamar an ni'tamu i amadan hi Aaron hinan tamun di padi. ");
INSERT INTO ifa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Nadan linala'in tinanud Libay ya diday niyappit i ha\"on hi bumoddang hinan padi an hi Aaron. ");
INSERT INTO ifa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ta hinan puntamuwandah nan tabernakel ya bokon hi Aaron ya ammunay boddangandah nadan tamuh nan tabernakel mu da'yun namin an tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ta diday mumpapto' hinadan gina'uh nan tabernakel ta boddangan da'yu nimpen namin an tinanud Israel hinan punhilbiyandah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ta hay eda bumoddangan hinadan padi an da Aaron an hina'amma di pangiyohhaandah tamuda. ");
INSERT INTO ifa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Mu pot'om hi Aaron ya nadan linala'in imbabalena ta diday munhilbin padih nan tabernakel. Ya nadan bokon padi an e mangat hinan tamun di padi ya mipapateda. ");
INSERT INTO ifa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ya inalin bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Nadan tinanud Libay ya niyappitda i ha''on ta diday mihukkat hinadan panguluwan an lala'in imbabaleyun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Te an namin nadan panguluwan an linala'i ya niyappitdan ha\"on. Te hidin dinadag'un namin nadan panguluwan an linala'in i Egypt ya imbilang'uh niyappit i ha\"on an namin nadan panguluwan an linala'in tinanud Israel ya ta'on on nadan hopap di tangbal an imbabalen di animalyu. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Hidin wadada ni' hinan agge naboblayan hi ad Sinai ya inalin bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Bilangom an namin nadan i'ibam an tinanud Libay ta ma'innilah on atnadah nan ohan pu'un ya atnay pamilyah nan himpamu'un. Ya binilangmu nadan linala'i an mihipun hinan ohay bulana. ");
INSERT INTO ifa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ta hiyay inat Moses an inunudna nan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Hi Libay ya tuluy linala'in imbabalena an hi Gerson ya hi Kohat ya hi Merari. ");
INSERT INTO ifa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ya hay holag Gerson ya da Libni i Simey. ");
INSERT INTO ifa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ya hay holag Kohat ya nadan holag Amram ya holag Isar ya holag Hebron ya holag Ussiel. ");
INSERT INTO ifa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ya hay holag'en Merari ya da Mahli i Musi. Ta danaey tonton nan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Hay holag Gerson ya nadan holag Libni ya nadan holag Simey. ");
INSERT INTO ifa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ta hay bilang nadan linala'in mihipun hinan himbulana ya pituy libu ta han limay gahut (7,500). ");
INSERT INTO ifa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ya hay nituddun didah pun'allunganda ya hi nangappit hi alimuhan di algo an indoggan nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ya hay ap'apun nadan tinanud Gerson ya hi Eliasap an imbabalen Lael. ");
INSERT INTO ifa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ya hay niyukod hi tamun datuwen tinanud hinan tabernakel ya diday ukod hi an namin an ma'usal hinan tabernakel an umat hinadan kultina ya nadan miyoddah ya nan kultinah nan panto ");
INSERT INTO ifa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ya nadan kultinah nunlini\"odan hinan lita\"angan ya nan punggobhan hi mi'nong ya nan mikultinah nan hogpan hinan lita\"angan ya nadan ma'usal an tali ya nadan udum. ");
INSERT INTO ifa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ya nada'en holag Kohat ya nadan holag Amram ya nadan holag Isar ya nadan holag Hebron ya nadan holag Usiel. ");
INSERT INTO ifa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ya hay bilang nadan linala'in tinanuddan namin an mihipun hinan ohay bulana ya waluy libu ta han onom di gahut (8,600). Ya hay niyukod i dida ya ipapto'da nan tabernakel an niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ya hay natuddu hi pun'allunganda ya hi nangappit hi muyyad nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ya hay mangipangpangulun didan holag Kohat ya hi Elisapan an imbabalen Usiel. ");
INSERT INTO ifa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ya hay tamuda nimpe ya diday mumpapto' hinan Kahun an nittuwan nan Hapit Apu Dios ya nan lamehaan ya nan punhilawan ya nan punggobhan hi insenso ya nan punggobhan hi mi'nong ya nadan ma'usal hinan pundayawan ya nan kultina an nihawan hinan Kuwartun Apu Dios ya nadan udum an ma'usal hidi. ");
INSERT INTO ifa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ya hay ap'apudan namin an tinanud Libay an muntamuh nan tabernakel ya nan imbabalen Aaron an padi an hi Eleasar. ");
INSERT INTO ifa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ya hay holag'en Merari ya nadan holag Mahli ya nadan holag Musi. ");
INSERT INTO ifa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ta hay bilang nadan linala'in holag Merari an mihipun hinan ohay bulana ya onom di libu ta han duway gahut (6,200). ");
INSERT INTO ifa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ya hay mangipangpangulun didan tinanud Merari ya hi Suriel an imbabalen Abihail. Ya hay nituddun dida hi eda pun'allungan ya hi nangappit hi huddo' nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ya hay nidat hi tamuda ya diday mumpapto' hinadan niyammah nan tabernakel an umat hinadan mandol hi kultina ya nadan miballabag an tabla ya nadan tu\"ud ya nadan ipabunan nadan mandol hi kultina ya nadan udum ");
INSERT INTO ifa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","an umat hinadan mi'alad hi nunlini\"odan nan lita\"angan an umat hi tu\"ud ya nadan ipabunanda ya nadan pahok ya tali. ");
INSERT INTO ifa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ta hi Moses ya hi Aaron ya nadan imbabalenan linala'i ya hay pun'allunganda ya hi nangappit hi tuluwan di algo an nihangngab hinan panton nan tabernakel an pi'dammuwanda i Apu Dios. Ta diday ukod hinan pundayawandan tinanud Israel. Ot nan tagun mangipatnan mangat i diyen tamuda ya mipapate nimpe. ");
INSERT INTO ifa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ta hay binilang da Moses i Aaron ya nadan linala'in tinanud Libay an inunudda nan imbagan Apu Dios hi atonda ya baintit duway libu (22,000) an mihipun hinan ohay bulana. ");
INSERT INTO ifa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ya alyon bon Apu Dios i Moses di, Bilangom an namin nadan panguluwan an linala'in tinanud Israel ya intudo'muy ngadandan mihipun hinan ohay bulana. ");
INSERT INTO ifa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Te unhaot dida ya nadan hopap di imbabalen di animal an tangbal di niyappit i ha\"on mu hay mihukkat mo ya nadan linala'in tinanud Libay ya nadan animalda. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ta binilang Moses an namin nadan panguluwan an linala'in tinanud Israel an miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ya hay bilang di intudo'dah ngadan nadan panguluwan an linala'i an mihipun hinan ohay bulana ya baintit duway libu ta han duway gahut ta napitut tulu (22,273). ");
INSERT INTO ifa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Hay idawatmun ha\"on ya danaen i'ibam an tinanud Libay ya ta'on on nadan animalda ta diday mihukkat hinadan panguluwan an linala'in tinanud Israel ya nadan hopap di imbabalen di animalyu. Ta nadan tinanud Libay ya mibilangdah bagi'. Ha\"on hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ot hay atonyun mamangngad hinan duway gahut ya han napitut tulun (273) linala'in tinanud Israel an nahawwal hinan bilang di tinanud Libay ");
INSERT INTO ifa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ya bayadanyu dida. Ot hay bayad di ohan tagu ya limay gumo' an pihhu an miyunnudan hinan balol nan gumo' an pihhuh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ya hay pangdatanyuh nadan pihhun ibayad nadan tatagu ya hi Aaron ya nadan linala'in imbabalena. ");
INSERT INTO ifa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ot amungon mon Moses nan pihhun bayad nadan nahawwal an linala'in nihukkat hinadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ya hay nidat hi bayadda ya hinlibut tuluy gahut ta han nanom ta lima (1,365) di gumo' an miyunnudan hinan balol di gumo' an pihhuh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ot idat Moses i Aaron ya nadan linala'in imbabalena nan imbayadda an inunudna nan imbagan Apu Dios hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Bilangonyun namin nadan holag Kohat an imbabalen Libay ta ma'innilah on atnadah nan ohan pamilya ya hay bilang di pamilyah nan himpamu'un. ");
INSERT INTO ifa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ta bilangonyu nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an muntamuh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ta hay tamun nadan holag Kohat ya diday mumpapto' hi an namin an niyappit i ha\"on an ma'usal hinan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ta nadatngan'ey akakanyuh nan nun'allunganyu ya nadan padi an da Aaron an hina'amma ya hunggopdah nan tabernakel ya inaanda nan kultinan nibolda' hinan Kahun an nittuwan nan Hapit'un Dios ya inhophopdah nan Kahun. ");
INSERT INTO ifa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ya inoddahandah diyen kultina hi up'up di animal hinan baybay ya ahida bo hophopan hi asul an luput. Ya ahida mohpe iha\"ad nan duwan kayiw an pangiyattangan. ");
INSERT INTO ifa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ya hinophopanda bo nan lamehaan hi asul an luput. Ya inyuhhundahdi nadan duyu ya basu ya pannuman an nittuwan nan midawat an ma'inum ya nadan malukung ya nan nidawat an tinapay an wadahdi ta munnanong hidi. ");
INSERT INTO ifa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ya ahida bo hophopan hinan mumbolah an luput ya ahida inyoddah an ihophop nan up'up di animal an malpuh nan baybay. Ya induulda mohpe nadan pangiyattanganda. ");
INSERT INTO ifa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ya inalada bo ha asul an luput ya iniphoddan linibbutan nan punhilawan ya nan pumputul hinan nagbun mitsa ya nan pangi'amungan hi gubu ya nan nittuwan di lanan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ya inoddahanda bon linibbutan hinan up'up di animal an nalpuh nan baybay ya ahida imbobod hinan pangiyattanganda. ");
INSERT INTO ifa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ya hinophopan bon da Aaron nan balitu' an punggobhan hi insenso hi asul an luput. Ya inoddahandah nan up'up di animal an malpuh nan baybay ya ahida induul hinan numbinahhel an pangipohonan nadan mangiyattang. ");
INSERT INTO ifa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ya an namin nadan ma'usal hidih nan punggobhan hi insenso ya amungonda ya linibbutandah asul an luput. Ya inoddahandah nan up'up di animal an nalpuh nan baybay ya ahida e imbobod hinan pangiyattanganda. ");
INSERT INTO ifa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ya inaanda nan gubuh nan gombang an punggobhan hi mi'nong ya hinophopandah bayulet an luput. ");
INSERT INTO ifa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ya inamungdahdin namin nadan ma'usal hinan punggobhan hi mi'nong an umat hinadan ittuwan di bala ya nadan tibi' di dotag ya nadan punggaud hi gubu ya nadan malukung an duyun ittuwan di dalan miwalaghi'. Ya inoddahandah nan up'up di animal an nalpuh nan baybay ya ahida induul hi numbinahhel nan pangiyattangan. ");
INSERT INTO ifa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ta nalpah'en linibbutan da Aaron an hina'amman namin nadan niyappit i ha\"on an usal hinan tabernakel ya ahida mohpe ukod nadan holag Kohat an mungkalga hi'on makakda mo. Mu mahapul an adida dapaon nadan gina'un nun'alibbutan te dapaonda'e ya mateda. ");
INSERT INTO ifa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ya hay ukod hinan lana an mittuh nan punhilawan ya nan mapmaphod an insenso ya nadan midawat an alina ya nan lanan mihiit hinadan miyappit i ha\"on an Dios ya hi Eleasar an imbabalen nan padi an hi Aaron. Ya hiya boy ukod hinan tabernakel ya an namin nadan niyappit i ha\"on an usal hidi. ");
INSERT INTO ifa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ya alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Tigonyuot ta wan adida mate nadan holag Kohat. ");
INSERT INTO ifa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ot wa'et hunggopdah nan tabernakel ya maphod on wahdi nadan padi an da Aaron an hina'amma ta diday mangibaga hi'on nganney tamuwanda ya nan mabalin hi pahonondah nadan niyappit i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Mu adi mabalin hi mihaggon dadiyen tinanud Kohat ta idodonganda nadan niyappit i ha\"on an usal hidih nan tabernakel an ta'on on na'omtang te mateda. ");
INSERT INTO ifa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Ad uwani ya nan tinanud Gerson an imbabalen Libay moy bilangom. Ta ma'innila hi'on atnadah nan ohan pamilya ya hi'on atnay pamilyah nan himpamu'un. ");
INSERT INTO ifa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ta bilangonyu nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an muntamuh nan tabernakel an pi'dammuwan i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ya hay tamun miyukod hinadan holag Gerson ya diday mamahon ");
INSERT INTO ifa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","hinadan kultinah nan tabernakel ya nadan up'up di animal hinan baybay an niyoddah nadan kultina ya nan kultinah nan panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Ya pi'yodonda bo nadan kultinan ni'alad hi nunlini\"odan nan lita\"angan nan tabernakel ya nan punggobhan hi mi'nong ya nan kultinah nan way hogpan hinan lita\"angan ya nadan tali ya an namin nadan ma'usal hidi. ");
INSERT INTO ifa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ta an namin di tamuwanda an umat hinadan pahononda ya hay mangibaga i dida ya nadan padi an hi Aaron ya nadan imbabalena. ");
INSERT INTO ifa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ta danaey tamun nadan holag Gerson hinan tabernakel an pi'dammuwanyun ha\"on an Dios. Ya hay mangibagah nan atonda ya nan imbabalen Aaron an hi Itamar. ");
INSERT INTO ifa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ya alyon bon Apu Dios i Moses di, Bilangom nadan holag Merari ta ma'innila hi'on atnadan himpamu'un. ");
INSERT INTO ifa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ya atbohdin bilangom nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an munhilbih nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ya hay tamuda ya diday mamahon hinadan agimangnun nan tabernakel an umat hinadan mandol hi kultina ya nadan miballabag an tabla ya nadan tu\"ud ya nadan ipabunanda ");
INSERT INTO ifa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ya ta'on on nadan tu\"ud hinan nunlini\"odan nan lita\"angan nan tabernakel ya nadan ipabunanda ya nadan pahok ya tali ya nadan udum. Ya ukod'a bon mangipiyappong i dida hi'on nganney pahonon di hinohhan dida. ");
INSERT INTO ifa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ta danaey nidat hinadan holag Merari hi tamuda. Ya hi Itamar bo an imbabalen Aaron di ukod an mangibagah nan tamuda. ");
INSERT INTO ifa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ta binilang da Moses i Aaron ya nadan mangipangpanguluh nadan holag Kohat an inhipundah pu'unda ya nan pamilyada. ");
INSERT INTO ifa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ya hay bilang nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an munhilbih nan tabernakel ");
INSERT INTO ifa_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ya duway libut pituy gahut ta han nabongle (2,750). ");
INSERT INTO ifa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ta hinaey bilang nadan linala'in holag Kohat an munhilbih nan tabernakel. Ta binilang da Moses i Aaron dida an inunudda nan imbagan Apu Dios hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ya binilangda bo nadan holag Gerson an inhipundah nan pu'unda ya nadan pamilyada. ");
INSERT INTO ifa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ya hay bilang nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an e muntamuh nan tabernakel ya ");
INSERT INTO ifa_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","duway libut onom di gahut ta han tulumpulu (2,630). ");
INSERT INTO ifa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ta hinaey ngammut di bilang nadan linala'in tinanud Gerson an munhilbih nan tabernakel. Ta binilang da Moses i Aaron dida an inunudda nan imbagan Apu Dios hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ot bilangonda bo nadan tinanud Merari an inhipundah nan pu'unda ya nan pamilyada. ");
INSERT INTO ifa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Ya an namin nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an muntamuh nan tabernakel ");
INSERT INTO ifa_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ya tuluy libu ta han duway gahut (3,200). ");
INSERT INTO ifa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ta hinaey bilang nadan holag Merari. Ta binilang da Moses i Aaron dida an inunudda nan imbagan Apu Dios hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ta athinay inat da Moses i Aaron ya nadan mangipangpangulu an numbilang an inhipundah nan pu'unda ya nan pamilyada. ");
INSERT INTO ifa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ta an namin nadan linala'in muntawon hi tulumpulu (30) ta ingganah nabongle (50) an mabalin an muntamuh nan tabernakel ya ");
INSERT INTO ifa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","waluy libut limay gahut ta han nawalu (8,580). ");
INSERT INTO ifa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ya way ohah nadan linala'i ya nibagay tamuda ya nan kalgaonda an miyunnudan hinan imbagan Apu Dios i Moses. Ta hiyah naey imbagan Apu Dios i Moses hi atondan mumbilang hinadan ibbadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Ibagam hinadan ibbam an tinanud Israel ta ibata\"andah nan nun'allunganyu nan waday gulidna an mangal'aldan hi udum ya nan waday bumbummuddun malpuh adolna ya nadan udum an mibilang hi nalugit te waday nida\"omandah nate. ");
INSERT INTO ifa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ibagayu i dida an ta'on hi babai onu lala'i ta eda mihiwweh ta bumata\"andah tun awada' ta adi gumapuh ibilangan nan nun'allunganyuh nalugit. ");
INSERT INTO ifa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ot unudon nadan tataguh diyen imbagan Apu Dios ta nadan nibilang hi nalugit ya eda nunhiwweh nan nibata\"aan hinan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Ibagam boh nadan ibbam an tinanud Israel ta wada'e i da'yu ha babai onu lala'i hi waday adi maphod hi inatnah nan ibbana ta aggena inunud nan pohdo' an atonyu ya numbahul. ");
INSERT INTO ifa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ot mahapul an iba\"agna nan numbahulana ya binayadanah diyen numbahulana ya inudmanah bainti (20) hi'on nan balol nan numbahulana ya hinggahut (100) ya indatnah diyen namin hinan tagun numbahulana. ");
INSERT INTO ifa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mu hi'on nateh diyen tagu ya ma\"id ha nihaggon di nitulangana hi mangalah nan molta ya bagi' mon Dios ta midat hinan padi. Ya nat'on bo nan ukatonan tangbal an kalnero an mi'nong ta a'aanan di bungot'uh nan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ya an namin nadan niyappit i ha\"on an idat nadan tataguh nan oha an padi ya bagin diyen padi. ");
INSERT INTO ifa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ta an namin nadan niyappit i ha\"on an idatyu hi ohah nadan padi ya bagina mo tuwalih diye. ");
INSERT INTO ifa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Ibagam hinadan ibbam an tinanud Israel di atonda hi'on waha nalahin hi babai hi inluktapnah ahawana ");
INSERT INTO ifa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mu agge innilan ahawana ya ma\"id ha nanigoh mabalin hi muntistigu. ");
INSERT INTO ifa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ya mun'annel'e nan lala'i te waday inilmuna i ahawana mu aggena innila hi'on immannung an inluktap ahawana ya hay atona mo ");
INSERT INTO ifa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ya iyenah ahawanah nan padi ya indatna ha hingkiluh alina an agge nadduman hi manteka onu insenso te hidiyen alina ya niyappit hi mun'annel ta panginnilaan hi'on immannung an nunluktap nan babai onu agge. ");
INSERT INTO ifa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ot hay aton nan padi ya ena pata'dogon hidiyen babai hi hinangngab nan punggobhan hi mi'nong i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ya nangalah nan liting an niyappit i ha\"on ya inittunah nan pannuman an pito'. Ya nangalah pito' hinan dotal nan tabernakel ya iniddumnah nan liting. ");
INSERT INTO ifa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ya ginungal nan padi nan ibu' diyen babai ya impadonan hiya nan alinan nidawat hi'on waday mun'annel. ");
INSERT INTO ifa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ya alyon nan padi hinan babai di, Hi'on aggem inluktap hi ahawam ta aggem binahbah di niyatam i hiya ya hanat ma\"id ha ma'at i he\"a hi panginumam ituwen liting an mangdat hi dogoh. ");
INSERT INTO ifa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mu hi'on immannung an inluktapmuh ahawam ta binahbahmuy niyatam ");
INSERT INTO ifa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ya hanat iyabulut Apu Dios ta tigon nadan tatagu an na'idutan'a ta makling di indonam. ");
INSERT INTO ifa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ot hituwen liting an dumadag ya umeh dallom di adolmu ta makling nimpey indonam. Ya nunsapataon nan padi nan babai ta alyonay, Unnuda' nan imbagam. ");
INSERT INTO ifa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ya intudo' mon nan padi nan adadagan nan babai hinan nalu'ut an puntud'an ya ahina ulahan ta umeh diyen mumpait an liting. ");
INSERT INTO ifa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ya ahina impa'inum i diyen babai hidiyen liting an mangdat hi nunhiglan dogohna ta holtapona. ");
INSERT INTO ifa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ya inalan nan padi nan inodnan nan babain alina ya intaggena ta idawatnan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ya ginamalna doha ya ginhobnah nan punggobhan hi mi'nong. Ya impa'inumna mohpe nan mumpait an liting hinan babai. ");
INSERT INTO ifa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ya hi'on immannung an nunluktap ya gapuh panginumana ya malmuy nunhiglan dogohna ta umongal di putuna ya mun'ul'ullen makling di indonana ta pihulon nadan ibbanan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mu hi'on agge immannung an nunluktap ya ma\"id ha ma'at i hiya ya mabalin an mun'imbabale. ");
INSERT INTO ifa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ot hiyah naey nitugun hi atondah nan babai hi'on inluktapna nan ahawana ");
INSERT INTO ifa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","onu hi'on mun'annel nan lala'i te waday pangilmunah nan ahawana. Ot athidi'e nimpe ya e pata'dogon nan padi nan babaih nan pundayawanyun ha\"on ya inatnan namin nadan imbaga' hi atona. ");
INSERT INTO ifa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ot nan ahawanan lala'i ya ma\"id ha itakutnah nibahhawana mu nan babai ya hiyay munholholtap hinan dusan di numbahulana. ");
INSERT INTO ifa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Ibagam hinadan tinanud Israel an wa'e ha babai onu lala'i hi pinhodnan iyappit di adolna i ha\"on an Dios ta mumbalin hi Nasarayt ya hay atona ");
INSERT INTO ifa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ya mahapul an idinongnan uminum hi bayah ya kumpulnan bumutong ya ta'on on nan limmanun bayah onu nadan napgot an bayah. Ya adi uminum hi danum di greyp ya athidi bon adi mangan hi bungan di greyp onu nadan resin. ");
INSERT INTO ifa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ot nan namhod nimpe an mangiyappit hi adolna i ha\"on ya adi mangan hi greyp an ta'on on nan ukihna onu buwana. ");
INSERT INTO ifa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ya adi mumpapukis ta padukkayonay ibu'na ta ingganah on magibbuh nan imbaganan ha\"on hi atona. ");
INSERT INTO ifa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ya mahapul an adi umeh nan awadan di nate ");
INSERT INTO ifa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","an ta'on on alinah on hi amana onu hi inana onu hi ibbana ta ma\"id ha lummuh ena ibilangan hi nalugit. Ya ta adina ilubit nan insapatanan ha\"on an Dios hi atona an ma'innilah nan ibu'nan agge napukisan. ");
INSERT INTO ifa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ot mihipun hi pangisapataanan iyappitnay adolna i ha\"on an Dios ya mumbalin hi Nasarayt. ");
INSERT INTO ifa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Mu alina'eh on nipadih an waday mateh hinangngabna ya mibilang moh nalugit nan ibu'na. Ot mala\"uh'ey pituy algo ya mahapul an mumpakalbu. Ya atona nan nibaga an atona ta mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ya hinan mabiggat an mi'awaluh algo ya inyena ha duwah palluma onu duwah balug hinan padi hinan way panton nan tabernakel an pi'dammuwanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ta i'nong nan padiy oha ta mi'nong hi apakawanan di bahul ya maghob an mi'nong nan oha ta a'aanan di bungot'un Dios an gapuh bahul diyen tagun wada ni' hi awadan diyen nate. Ya idihhana bon iyappit di ibu'na i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ta mahapul bon ipidwanan idawat di adolna i ha\"on an Dios te adi mo mibilang nan namangulun nangiyappitanah adolna i ha\"on. Ta iyalina bo ha ohay tawonah tangbal an kalnero ta mi'nong hi apakawanan di bahul an agge inatta. ");
INSERT INTO ifa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ya nalpah'e mohpe nan nungngilinana an pangiyappitanah adolna i ha\"on an Dios ya umeh nan panton nan tabernakel ta unudona nan nibagah atona. ");
INSERT INTO ifa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ta iyena nan i'nongnan ha\"on an ohay tawonan kalnero an ma\"id ha bahbahna ta maghob an mi'nong ya ha ohay tawonah tinnan kalnero an ma\"id ha bahbahna ta mi'nong hi apakawanan di bahulna ya ha tangbal an kalnero an ma\"id bo ha bahbahna ta mi'nong hi pi'hayyupana i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ya iniddumnan indawat ha alina ya ha ma'inum ya ha ohay bahket hi tinapay an agge nadduman hi yist an hay niyamma ya nan maphod an alina an nadduman hi manteka ya ha ma'ingpih tinapay hi namantekaan. ");
INSERT INTO ifa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ta nan padi di mangidawat i dadiyen mi'nong hi apakawanan di bahul ya nan maghob an mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ya ini'nongna nan tangbal an kalnero an mi'nong hi pi'hayyupan i ha\"on an Dios an iddumnan idawat nan himbahket an tinapay an agge nadduman hi yist ya nan alina ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ya hidih nan panton nan tabernakel ya ipaputul diyen taguy ibu'na ya ena intunguh nan apuy an munggohob hinan mi'nong hi pi'hayyupanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ya nalutu'e nan dotag an niha\"ang ya inalan nan padi di ohah nan lapan nan tangbal an kalnero ya impadona i diyen tagu. Ya inalana boh nan bahket di ohah nan ma'uktul an tinapay ya ha ma'ingpih an tinapay an agge nadduman hi yist ya iniddumnan impadon i diyen tagu. ");
INSERT INTO ifa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ya impabangngad diyen taguh nan padi ta itaggenan idawatna i ha\"on an Dios. Ta dadiye nan midat hinan padi an middum hinan palagpag ya hukpit an nitaggen nidawat i ha\"on an Dios. Ya nagibbuh'en na'at dadiye ya mabalin mohpen uminum hi bayah nan tagu. ");
INSERT INTO ifa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ta danae nan nitugun hi idawat nan tagun nangiyappit hi adolna i ha\"on an Dios. Mu hi'on nahuluk mu nan nitugun di insapatanah idawatna ya mahapul an hidiyey ipa'annungna. ");
INSERT INTO ifa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Ibagam i Aaron ya nadan imbabalenan padi ta hay punwagahdah nadan tinanud Israel ya alyonday, ");
INSERT INTO ifa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Hanat hi Apu Dios di munwagah ya mumpapto' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ya hanat ipatigon Apu Dios di amlongna ya ulenan da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ya adi da'yu iwalong i hiya mu palinggopon da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ot alyon mohpen Apu Dios i Moses di, Athinay pohdo' hi atondan munwagah nadan tatagu' ta wan umannung an wagaha' dida. ");
INSERT INTO ifa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Hidin nagibbuh an impata'dog Moses nan tabernakel ot lamuhonah lana ta niyappit i Apu Dios an niddum nadan usal hidi. Ot lamuhona bo nan punggobhan hi mi'nong ya nadan ma'usal hidi. ");
INSERT INTO ifa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ot iyalin nadan ap'apun nadan himpahimpamu'un an tinanud Israel nadan i'nongda. Datuwen ap'apu ya dida nadan napilin nangipangpanguluh nadan tinanud Israel hi numbilanganda i didan namin. ");
INSERT INTO ifa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ta hay na'amung ya onom di kaliton an waday hophopda ya himpulut duway (12) baka te ohan ap'apu on oha boy baka ya ohay kaliton on duwada. Ta nun'iyedah nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Abulutom danaen inyalida ta ma'usal hinan tamuh nan tabernakel an pi'dammuwanyun ha\"on an Dios. Ta idatmuh nadan tinanud Libay ta usalondah nan tamuda. ");
INSERT INTO ifa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ot idat Moses nadan kaliton ya nadan baka hinadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ta indatnah nadan holag Gerson di duway kaliton ya opat di baka ta usalondah nan tamuda. ");
INSERT INTO ifa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ya indatna boy opat an kaliton ya walun bakah nadan tinanud Merari ta usalonda damdamah nan tamuda. Ya hay mangibagah nadan tamuwanda ya nan padi an imbabalen Aaron an hi Itamar. ");
INSERT INTO ifa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mu nadan tinanud Kohat ya ma\"id ha indat Moses i dida hi usalonda te hay niyukod i dida hi tamuda ya mumpahon hinadan niyappit i Apu Dios an usal hinan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ya hidin nahiitan hi lana nan punggobhan hi mi'nong ya nun'iyalin bon nadan ap'apu di idatda ta ma'usal hi pangiyappitandan Apu Dios i diyen punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Te alyon Apu Dios i Moses di, Ibagam hinadan tatagu ta ohay algo on ohan ap'apu di mangiyalih nan idatna ta mi'nong hitun iyappitan nan punggobhan hi mi'nong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ta hinan hopap di algo ya hay nangiyalih idatna ya hi Nahson an imbabalen Amminadab an tinanud Judah. ");
INSERT INTO ifa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ya hay indatna ya ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu dadiyen duwa hi napinun alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Ya inyalina boy ohan balitu' an duyu an umeh hinggahut ta han himpuluy (110) gramuy damotna an napnuh insenso. ");
INSERT INTO ifa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Ya wada boy inyalinan pa'ahikkonan bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona. Ta danae nadan maghob an mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Ya inyalina boy ohan tangbal an gulding ta mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Ya inyalina boy mi'nong hi pi'hayyupan i Apu Dios an duwan tangbal an baka ya liman tangbal an kalnero ya limay tangbal an gulding ya limay tangbal an kalneron ohay tawonda. Ta danae nadan indat Nahson an imbabalen Aminadab. ");
INSERT INTO ifa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ya hinan mi'adwah algo ya inyalin nan mangipangpanguluh nadan tinanud Issakar an hi Netanel an imbabalen Suar nan idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ya atbohdiy indatna an ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nadan wahnan tabernakel. Ya napnu dadiyen duyu hi maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Ya atbohdin inyalinay ohan balitu' an duyu an umeh hinggahut ta han himpuluy (110) gramuy damotna an napnuh insenso. ");
INSERT INTO ifa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Ya inyalina bo nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ya atbohdin inyalinay mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya liman tangbal an kalneron ohay tawonda. Ta danae nadan indat Netanel an imbabalen Suar. ");
INSERT INTO ifa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ya hinan mi'atluh algo ya atbohdiy indat nan mangipangpanguluh nadan tinanud Sebulun an hi Eliab an imbabalen Helon. ");
INSERT INTO ifa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ta indatna damdamay ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Ya atbohdin inyalinay ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso. ");
INSERT INTO ifa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Ya inyalina boy ohan pa'ahikkona an bulug an baka ya ohan tangbal an kalnero ya oha bon tangbal an kalneron ohay tawona ta maghob an mi'nong i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Ya inyalina boy mi'nong hi apakawanan di bahul an ohan tangbal an gulding. ");
INSERT INTO ifa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Ya inyalina bo nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya lima boy tangbal an kalneron ohay tawonda. Ta danae nadan indat Eliab an imbabalen Helon. ");
INSERT INTO ifa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ya hinan mi'apat hi algo ya atbohdiy inyalin nan mangipangpanguluh nadan tinanud Ruben an hi Elisur an imbabalen Sedeur. ");
INSERT INTO ifa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ta indatna boy ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu dadiyen duyuh maphod an alinan nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Ya inyalina boy ohan balitu' an duyun hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso. ");
INSERT INTO ifa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Ya inyalina boy maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Ya inyalina bo nadan mi'nong hi pi'hayyupan i Apu Dios an duwan baka ya limay tangbal an kalnero ya limay tangbal an gulding ya limay tangbal an kalneron ohay tawonda. Ta danaey indat Elisur an imbabalen Sedeur. ");
INSERT INTO ifa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ya hinan mi'alimah algo ya nan mangipangpanguluh nadan tinanud Simon an hi Selumiel an imbabalen Surisadday ya atbohdiy inyalinah idatna ");
INSERT INTO ifa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","an oha boy silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Ya inyalina boy ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Ya inyalina bo nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya lima bon tangbal an kalneron ohay tawonda. Ta danaey indat Selumiel an imbabalen Surisadday. ");
INSERT INTO ifa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ya hinan mi'anom hi algo ya nan mangipangpanguluh nadan tinanud Gad an hi Eliasap an imbabalen Dewel ya atbohdin inyalinay idatna ");
INSERT INTO ifa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","an oha damdaman silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyu hi maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Ya inyalina boy ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Ya inyalina bo nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya lima bon tangbal an kalneron ohay tawonda. Ta danaey indat Eliasap an imbabalen Dewel. ");
INSERT INTO ifa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ya hinan mi'apituh algo ya nan mangipangpanguluh nadan tinanud Epraim an hi Elisama an imbabalen Ammihud ya atbohdin inyalinay idatna ");
INSERT INTO ifa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","an oha damdamay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyu hi maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Ya inyalinay oha bon balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ya na bon maghob an mi'nong an ohan kilaw an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya liman tangbal an kalneron ohay tawonda. Ta danaey indat Elisama an imbabalen Ammihud. ");
INSERT INTO ifa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ya hinan mi'awaluh algo ya nan mangipangpanguluh nadan tinanud Manasseh an hi Gamaliel an imbabalen Pedahsur di nangiyalih idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ya atbohdin inyalinay ohan silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Ya inyalina damdamay ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya lima bon tangbal an kalneron ohay tawonda. Ta danaey indat Gamaliel an imbabalen Pedahsur. ");
INSERT INTO ifa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ya hinan mi'ahiyam hi algo ya nan mangipangpanguluh nadan tinanud Benjamin an hi Abidan an imbabalen Gideoni di nangiyalih idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ya atbohdin indatnay ohan silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Ya inyalina boy ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya liman tangbal an kalneron ohay tawonda. Ta danaey indat Abidan an imbabalen Gideoni. ");
INSERT INTO ifa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ya hinan mi'apuluh (10) algo ya nan mangipangpanguluh nadan tinanud Dan an hi Ahieser an imbabalen Ammisadday di nangiyalih idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ya atbohdin inyalinay ohay silber an duyun hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Ya inyalina damdamay ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya liman tangbal an kalneron ohay tawonda. Ta danaey indat Ahieser an imbabalen Ammisadday. ");
INSERT INTO ifa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ta hinan mi'apulut ohay (11) algo ya nan mangipangpanguluh nadan tinanud Aser an hi Pagiel an imbabalen Okran di nangiyalih idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ya atbohdin hay indatna ya ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Ya inyalina boy ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya limay tangbal an gulding ya liman tangbal an kalneron ohay tawonda. Ta danaey indat Pagiel an imbabalen Okran. ");
INSERT INTO ifa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ya hinan mi'apulut duwah (12) algo ya nan mangipangpanguluh nadan tinanud Naptali an hi Ahira an imbabalen Enan di nangiyalih idatna. ");
INSERT INTO ifa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ya atbohdin hay indatna ya ohay silber an duyu an hay damotna ya ohay kilu ta han godwa ya nan silber an malukung an umeh hingkiluy damotna an miyunnudan hinan pungkiludah nan tabernakel. Ya napnu bo dadiyen duyuh maphod an alina an nadduman hi manteka ta midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Ya inyalina boy ohan balitu' an duyu an hay damotna ya umeh hinggahut ta han himpuluy (110) gramu an napnuh insenso ");
INSERT INTO ifa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ya nan maghob an mi'nong an ohan pa'ahikkona an bulug an baka ya ohay tangbal an kalnero ya oha boy tangbal an kalneron ohay tawona ");
INSERT INTO ifa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ya oha bon tangbal an gulding ta mi'nong hi apakawanan di bahul ");
INSERT INTO ifa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ya nadan mi'nong hi pi'hayyupan i Apu Dios an duwan bulug an baka ya limay tangbal an kalnero ya lima boy tangbal an gulding ya lima boy tangbal an kalneron ohay tawonda. Ta danaey indat Ahira an imbabalen Enan. ");
INSERT INTO ifa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ta hay indat nadan mangipangpanguluh nadan tinanud Israel hi ma'usal hinan pangiyappitandah nan punggobhan hi mi'nong hitun magibbuh an mahiitan hi lana ya himpulut duway (12) silber an duyu ya himpulut duway (12) silber an malukung ya himpulut duwa (12) bon balitu' an duyu. ");
INSERT INTO ifa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ya hay damot nan hinohhan silber an duyu ya ohay kilu ta han godwa ya hay damot nan hinohhan silber an malukung ya umeh ohay kilu. Ta hay damot nadan silber an duyu ya baintit waluy (28) kilun namin ya hay damot nadan silber an malukung ya himpulut duway (12) kilu an miyunnudan hinan pungkiludah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ya hay damot nan himpulut duwan (12) balitu' an duyu ya oha ta han godway kilu an napnudan namin hi insenso. ");
INSERT INTO ifa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ya hay maghob an mi'nong ya himpulut duwan (12) pa'ahikkona an bulug an baka ya himpulut duwa (12) bon tangbal an kalnero ya himpulut duwa (12) bon tangbal an kalneron ohay tawonda ya niddum nadan alinan midawat. Ya niddum nan himpulut duwa (12) bon tangbal an gulding an mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ya hay bilang di inyalidan mi'nong hi pi'hayyupan i Apu Dios ya baintit opat (24) an baka ya nanom (60) an tangbal an kalnero ya nanom (60) bon tangbal an gulding ya nanom (60) bon tangbal an kalneron hinohhay tawonda. Ta danae nadan ma'usal hinan pangiyappitandah nan punggobhan hi mi'nong hi agibbuhanan mahiitan hi lana. ");
INSERT INTO ifa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ya hidin hinunggop hi Moses hinan tabernakel ta e mi'happitan i Apu Dios ya dingngolna han munhapit i hiya an nalpuh nan numbattanan nadan kerubim hi baktun nan kalub nan Kahun an nittuwan nan Hapit Apu Dios. Ot mi'hapit hi Moses i hiya. ");
INSERT INTO ifa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Ibagam i Aaron ta iphodna'e nan punhilawan an pituy hapangna ya tigona ta madilagan nan akuyung nan punhilawan. ");
INSERT INTO ifa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ta inunud Aaron hidiyen imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ya hay niyamma i diyen punhilawan an nihipun hi pu\"una ta ingganah nadan ayna habung ya balitu'. Ya nan impatigon Apu Dios i Moses an pangi'unnudanda ya hiyah diyey inatda. ");
INSERT INTO ifa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Awitom nadan tinanud Libay hinadan tinanud Israel ya inatmu nadan nibaga hi aton ta mibilangdah malinis. ");
INSERT INTO ifa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ot hay mamangulu ya walaghi'am didah nan liting an ma'usal hi punlinis. Ta nagibbuh'e ya inupuhandan namin nan dutdut hi adolda ya eda inlaba' nadan lubungda ta mibilangdah malinis. ");
INSERT INTO ifa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ya imbagam ta iyalida ha pa'ahikkona an bulug an baka ya ha maphod hi alina an nadduman hi manteka ya ha mi'adwa boh pa'ahikkona an bulug an baka ta mi'nong hi apakawanan di bahul. ");
INSERT INTO ifa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ya inayagam dida an tinanud Libay hinan tabernakel ta eda umohnong hi hinangngab diyen pundayawanyun ha\"on ya inamungyun namin nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ya imbagam hinadan ibbadan tinanud Israel ta umedah awadan nadan tinanud Libay ya inha'moday ta'ledan dida. ");
INSERT INTO ifa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ya innayun Aaron an inyappit dida i ha\"on an Dios ta diday paddungnay inyappityun tinanud Israel i ha\"on ta midadaandan mangat hinan ipatamu' i dida. ");
INSERT INTO ifa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ya e inha'mon nadan tinanud Libay di ta'ledah ulun nadan baka ta mi'nong hi apakawanan hi bahul nan oha ya ni'nong hi maghob an mi'nong nan oha ta a'aanan di bungot'un Dios an gapuh bahul nadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ya nagibbuh'en na'at danae ya em impata'dog nadan tinanud Libay hi hinangngab Aaron ya nadan imbabalena ya inyappitmu dida i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ta way atondan tinanud Libay an mumbalin hi odon'u ta miyappitda nimpen ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ya alyon bon Apu Dios di, Ot gapu ta mibilangda moh malinis nadan tinanud Libay te nidawatda mo i ha\"on ya mabalin mon hunggopdah nan tabernakel ta atonda mohpe nadan tamuda. ");
INSERT INTO ifa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ta nadan tinanud Libay ya diday pinto\"uh niyappit i ha\"on ta diday mihukkat hinadan panguluwan an linala'i an imbabaleyun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Te nihipun hi nanadaga' hi an namin nadan panguluwan an linala'i an imbabalen di i Egypt ya an naminda moy panguluwan an linala'i an imbabaleyun tinanud Israel ya ta'on on nadan hopap di imbabalen di animalyu ya niyappitdan ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mu ten ad uwani ya nadan linala'in tinanud Libay di pinto\"uh mihukkat i dadiyen panguluwan an linala'i an imbabaleyu. ");
INSERT INTO ifa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ta diday idat'u i Aaron ya nadan linala'i an imbabalena ta bumoddangda i dida hinadan tamudah nan tabernakel. Ta diday mangat hinadan tamunnot nadan tatagu ta diday ay mi'nong hi a'aanan di bungot'un Dios ta wan adi ma'at hinadan tatagu di nunhiglan dogoh hinan eda ihaggonan hinan tabernakel. Te nadan tinanud Libay ya mabalin an mihaggondah nan tabernakel mu nadan udum an tatagu ya adi mabalin. ");
INSERT INTO ifa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ta da Moses ya hi Aaron ya nadan tinanud Israel ya inunudda nan imbagan Apu Dios hi atondah nadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ya athidi boh nadan tinanud Libay an inatda nadan nibaga an atonda ta mibilangdah malinis ot eda pun'ilaba' di lubungda. Ot ahi iyappit Aaron dida i Apu Dios ot inayunan i'nong nan mi'nong hi' a'aanan di bungot Apu Dios an gapuh bahulda ta mibilangdah malinis. ");
INSERT INTO ifa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ta on nagibbuh an na'at an namin dadiye ot umedah nan tabernakel ta eda aton mohpe nadan tamuda. Ot da Aaron hinadan linala'in imbabalena di nangibagah nadan tamuwanda. Ta inunud nadan tinanud Libay nadan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ya inalin bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Hanadan tinanud Libay an linala'i an nuntawon hi baintit lima (25) ya nadan mahuluk hi baintit lima (25) ya mabalin an muntamudah nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mu wa'et nabongley (50) tawonda ya mahapul an mun'ibleda mo. ");
INSERT INTO ifa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mu mabalin damdaman bumoddangda ya ammuna hinadan ibbadan muntamuh nan tabernakel mu ma\"id ha niyukod i dida hinadan matamuwan. Ot danaey ituddum hi tamun nadan tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Hidin hopap di bulan hinan mi'adwah tawon hi nakakan nadan tinanud Israel hi ad Egypt ya himmapit hi Apu Dios i Moses hi awadandah nan agge naboblayan hi ad Sinai ");
INSERT INTO ifa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ot alyonay, Ibagam hinadan ibbam an tinanud Israel ta ngilinonyu nan punnomnomnomanyuh nihwanganyuh ateh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ta hitun mibaluy himpulut opat (14) di algo hi ad uwanin bulan ya ihipunyuh nan mun'ahdom an unudonyun namin nadan nibaga hi atonyu ta miyunnudan hinadan tugun'u. ");
INSERT INTO ifa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ta hidiyey imbagan Moses hinadan ibbanan tinanud Israel ta ngilinonda nan punnomnomnomandah nihwangandah ateh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ot hidiyey atonda ta nginilinda nan nun'allungandah nan agge naboblayan hi ad Sinai hidin mi'ahimpulut opat (14) di algo hinan mamangulun bulan an ihipundah nan mun'ahdom. Ta inunuddan namin nan imbagan Apu Dios i Moses hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mu wadaday udum an adi mabalin hi middum an mungngilin i diyen ngilinonda te mibilangdah nalugit te waday dinapadah naten tagu. Ta hiya nan immeda i Moses ya hi Aaron i diyen algo ");
INSERT INTO ifa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ot alyondan Moses di, Mibilang amih nalugit te waday dinapamih nate. Mu undan hidiyey humandih emi pangidawatan hinan i'nongmin Apu Dios hi ad uwani ta middum amih nadan ibba ta'un tinanud Israel an mungngilin? ");
INSERT INTO ifa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ya alyon Moses i diday, Haddonyu ta ingganah on innilaon ta'uy ibagan Apu Dios hi atonyu. ");
INSERT INTO ifa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Indani ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Ibagam hinadan ibbam an tinanud Israel ta wa'e ha mibilang hi nalugit an gapu ta nipadih an dinapana ha nate onu gapu ta nidawwiy nangayana ya mabalin an mapalodpod di pungngilinanah nan punnomnomnomanyuh nihwanganyuh ateh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ta haddonda ta ingganah madatngan nan mi'apulut opat (14) hi algo hinan mi'adwah bulan. Ta mun'ahdom'e ya ini'nongda ha kalnero ta panidadah nan tinapay an agge nadduman hi yist. Ya iniddumdan inan nan mumpait an holo'. ");
INSERT INTO ifa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ya mahapul an ma\"id ha angangondah nan dotag hinan mawi\"it ya gahin di ma\"id ha maputung hinan tungal nan kalneron ini'nongda. Ta mahapul an unudondan namin nan imbaga' hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mu na'en ma\"id ha nidawwih nangayana an mibilang hi malinis mu on attaona tuwalin adi ngilinon nan punnomnomnomanyuh nihwanganyuh ateh ad Egypt ya mahapul an mipapate ta adi midmiddum i da'yun tatagu' an gapuh aggena nungngilinan. Ta holtapona nan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ya nada'en bokon Judyu an ni'iboblen da'yu ya hi'on pohdondan middum hinan punnomnomnomanyuh nihwanganyuh ateh ad Egypt ya mahapul an unudonda nadan imbaga' hi atonyu an mungngilin. ");
INSERT INTO ifa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Hidin nipata'dog nan tabernakel ya nungkohop nan bugut ot mihophop hidi an nihipun i diyen nahdom ta ingganah nawi\"it ya ay apuy di tigon diyen bugut hi uhhun nan tabernakel an mangipanomnom an wadaa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ta athidiy uggan ma'at an hophopan diyen bugut ta nahdom'e on ay mundalang an apuy di tigona. ");
INSERT INTO ifa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ya timmage'e nan bugut hi baktun nan tabernakel on pinalu'ah nadan tataguy allungda ta unudonda nan bugut hinan pangipluyana. Ya immohnong'e on immohnongda bo ta iphodda nadan pun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ta athidin alyon'en Apu Dios di makakda on nakakda. Ya alyona'e hi mun'allungdahdi on hiyay inatda. Ya nanongna'en agge timmage nan bugut an nihophop hinan tabernakel on nunnanongdah nan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ya hi'on madne on adi tumage nan bugut an nihophop hinan tabernakel ya mahapul an unudonda nan imbagan Apu Dios ta haddonda nan ibagana an akakanda. ");
INSERT INTO ifa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mu hinuddum on mihophop nan bugut hinan tabernakel i ha atnay algo ya abuh on imbagan Apu Dios ta makakda nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ya hinuddum bo ya ohay hilong ya abuh di pungkohopan nan bugut on timmageh nan mawi\"it. Ta timmage'e nimpe on mahapul an makak nadan tatagu an ta'on on alinah hilong onu mapatal. ");
INSERT INTO ifa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ot hi'on nungkohop nan bugut hinan tabernakel hi duway algo onu himbulan onu hintawon ya munnanongdan umohnong hinan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ta ingganah on alyon Apu Dios di makakda ya ahida makak. Ta nan ibagan Apu Dios i Moses di hiyay inun'unud nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Iphodyuy duwah silber an trampeta ta pun'ayagyuh nadan tatagu hi'on mahapul an ma'amungda onu makakda. ");
INSERT INTO ifa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ot hi'on mundihhan nan duwan trampeta an mipagangoh ya hay ipa'innilana ya ma'amungdan namin nadan tatagu hinan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mu oha'e nan mipagangoh ya ammuna nadan ap'apuh nadan himpahimpamu'un an ma'amung hidih nan way tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ya hi'on na'omtang an ma\"adngol di gangoh nan trampeta ya makakda mo nadan tatagun nun'allung hi nangappit hi tuluwan di algo. ");
INSERT INTO ifa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ya hinan mi'adwan gangoh di trampeta ya nan nun'allung hi nangappit hi muyyad nan tabernakel di makak ta mitnudda. ");
INSERT INTO ifa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ya hi'on ayaganyu nadan tatagu ta ma'amungda ya dukdukkayonyun mangipagangoh nadan trampeta. ");
INSERT INTO ifa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ya hay mabalin hi mangipagangoh nadan trampeta ya nadan padi an imbabalen Aaron. Ot hanat hituwen imbaga' an atonyu di un'unudonyu ya ta'on on nadan mun'atanudan. ");
INSERT INTO ifa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ya hitun dumatnganyuh nan pumboblayanyu ya wa'et mi'gubat ayuh nadan binuhulyun mamalpaligat i da'yu ya ipagangohyuh na'omtang nadan tangguyub. Ta wan donglo' an Dios an dayawonyu ya ibaliw da'yun ha\"on hinadan binuhulyu. ");
INSERT INTO ifa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ya ta'on on hinadan nagtud an pungngilinanyuh nadan pun'am'amlonganyu an umat hinadan nakayangan nan bulan ya ipagangohyu nadan trampeta hi'on i'nongyu nadan maghob an mi'nong ya nadan mi'nong hi pi'hayyupanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Hidin nibaluy baintiy (20) algoh nan mi'adwan bulan hinan mi'adwan tawon hi nakakandah ad Egypt ya timmage nan bugut hi baktun nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ot makak mo nadan tinanud Israel hinan nun'allungandah nan agge naboblayan hi ad Sinai. ");
INSERT INTO ifa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ta hidiyey hopapnah nakakanda an hinnodda nan imbagan Apu Dios i Moses hi akakanda. ");
INSERT INTO ifa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ta hiyah diye an hay nangipanguluh nakakanda ya nadan grupun Judah an inodnanda nan bandelada. Ya hay mangipangpangulu i dida ya hi Nahson an imbabalen Amminadab. ");
INSERT INTO ifa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ya hi Netanel an imbabalen Suar di nangipangpanguluh nadan tinanud Issakar. ");
INSERT INTO ifa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ya hi Eliab an imbabalen Helon di nangipangpanguluh nadan tinanud Sebulun. ");
INSERT INTO ifa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ta pinalu'ahda nan tabernakel ot ipiyappongdah nadan holag Gerson nan natuddu an pahononda ya atbohdih nadan holag Merari an pinahonda nadan natuddu an pahononda ot inayundan makak. ");
INSERT INTO ifa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ot mitnud i dida nadan grupun Ruben an inodnanda damdama nan bandelada. Ya hay nangipangpangulun dida ya hi Elisur an imbabalen Sedeur. ");
INSERT INTO ifa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ya hi Selumiel an imbabalen Surisadday di nangipangpanguluh nadan tinanud Simon. ");
INSERT INTO ifa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ya hi Eliasap an imbabalen Dewel di nangipangpanguluh nadan tinanud Gad. ");
INSERT INTO ifa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ot mitnud nadan holag Kohat an tinanud Libay an nangdon hinadan niyappit i ha\"on an usal hinan tabernakel. Ta impanguluda nan tabernakel ta mipata'dog ya ahida dumatong nadan holag Kohat an nangdon hinadan niyappit i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ya mitnud i dida nadan grupun Epraim an inodnanda nan bandelada. Ya hay mangipangpangulu i dida ya hi Elihana an imbabalen Ammihud. ");
INSERT INTO ifa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ya hay mangipangpanguluh nadan tinanud Manasseh ya hi Gamaliel an imbabalen Pedahsur. ");
INSERT INTO ifa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ya hay mangipangpanguluh nadan tinanud Benjamin ya hi Abidan an imbabalen Gideoni. ");
INSERT INTO ifa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ya hay na'udih nitnud ya nadan grupun Dan an inodnanda nan bandelada. Ya hay mangipangpangulu i dida ya hi Ahieser an imbabalen Ammisadday. ");
INSERT INTO ifa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ya hi Pagiel an imbabalen Okran di mangipangpanguluh nadan tinanud Aser. ");
INSERT INTO ifa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ya hi Ahira an imbabalen Enan di mangipangpanguluh nadan tinanud Naptali. ");
INSERT INTO ifa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ta danaey mahohonnod hinan akakan nadan tinanud Israel hinan pumbaatanda. ");
INSERT INTO ifa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ya han hin'algo ya alyon Moses hinan hi ayduna an hi Hobab an imbabalen Rewel an i Midian di, Ume amih nan boble an imbagan Apu Dios hi idatnan da'mi. Ot mabalin'e ya ni'yali'a i da'mi ta ibilang da'a hi ibbami ot imbagan Apu Dios an maphod di atona i da'min tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ya alyon Hobab di, Adiya' mi'yali te ibangngad'uh boblemi ya hinadan ibba' an tataguhdi. ");
INSERT INTO ifa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mu alyon Moses di, Ot ta'omman mo mu ta adi da'mi ni' bahan taynan. Udu'dulnan he\"a te innilam di mabalin an pun'allunganmih tun agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ya hi'on mi'yali'a i da'mi ya idattan da'ah nadan maphod an ihmo' Apu Dios i da'mi. ");
INSERT INTO ifa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ta nakakdahdi hinan way billid an niyappit i Apu Dios ot eda dumanallanan hi tuluy algo. Ya hiyah diyen impangulun nadan nangdon hinan Kahun an nittuwan nan Hapit Apu Dios ta tigonda hi'on idanay umohnonganda ni'. ");
INSERT INTO ifa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ya mapatal'e ya nanongnan wada nan bugut an munhidum i didah nan pumbaatanda. ");
INSERT INTO ifa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ya an namin di pangikakandah nan Kahun on mundasal hi Moses an alyonay, Apu Dios, hanat he\"ay mangipangulu i da'mi ta way aton nadan binuhulmun ahibubuttikan ta mahihi\"anda. ");
INSERT INTO ifa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ya wa'et inha\"adda nan Kahun ta umohnongda ni' on alyon Moses di, Apu Dios, hanat adi da'mi taynan hitun awadanmin linibun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Nadan tatagu ya inhipundan munlilih nan pumpaligatanda. Ta hidin dingngol Apu Dios ya nangimbubbungot. Ot pa'aliyonay apuy ta napu'ulan di nundina'ging hinan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mu hidin numpahpahmo' nadan tatagu i Moses ot mundasal i Apu Dios ta nadop nan apuy. ");
INSERT INTO ifa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ta hiya nan nginadanandah diyen nun'allunganda hi ad Taberah an hay ibalinana ya awadan di apuy an gumhob te gapuh nan apuy an nalpun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nadan bokon Judyu an ni'uyug i dida ya manama'dah udum an makan. Ya ta'on mo boh on nadan tinanud Israel ya pun'ipadngoldan alyonday, Onhandi anu waha dotag i ha ihda. ");
INSERT INTO ifa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Te minonomnom tayya nadan liblin ekan hi ad Egypt ya nadan pipinu ya melon ya danggu ya amput. ");
INSERT INTO ifa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mu tanganu on ad uwani ya onta humigan mangan te namaag ya ma\"id ha udum hi makan an ammuna hantun manna. ");
INSERT INTO ifa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Nan manna ya umat hinan kittang an buwan di nitanom ya hay kololna ya ay resin. ");
INSERT INTO ifa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ta abigabigat on eda pinanuh nadan manna on ginilingda onu binayuda ta ay alina ya inha\"angdah tinapay. Ya hay tamtamna ya umat hinan tinapay an nadduman hi mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Te wa'e ta nahdom ta dimmulnu on mun'a'agah nadan manna hinan nunlini\"odan nan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ta dingngol Moses nadan tatagun ahikokogadah nan way panton di allungda. Ya nunhiglay bungot Apu Dios ta minomnoman hi Moses. ");
INSERT INTO ifa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ot alyonan Apu Dios di, Tanganu ona' paligaton i he\"a an ud baal i ha\"on? Undan attog nganney numbahula' i he\"a ta inyukodmu datuwen namin an tatagu i ha\"on? ");
INSERT INTO ifa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Undan ha\"on di ammod datuwen tatagu? Tanganu on ayda goggolang ya ay ha\"on di mangiyab'abba i dida ta iye' hinan boblen imbagam hinadan a'ammodda an idatmun dida? ");
INSERT INTO ifa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ta dana ihyay e' pangalan hi ipa'an'u i datuwen tatagun mumpumbagah dotag hi ihdada? ");
INSERT INTO ifa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Adi' mahan mo tayya abalinan an mumpapto' i datuwen tatagu, Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ta athi'athitu'e ya udu'dul attog ona' patayon hi ad uwani tee hi'on waday pangibilangmun ha\"on ta adim iyabulut an tigo' di adadaga'. ");
INSERT INTO ifa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Alyon Apu Dios i Moses di, Ayagam di napituh (70) nadan innilam an nanomnoman an ap'apun di himpahimpamu'un an tinanud Israel ya immali ayuh nan tabernakel ta mi'ita'dogdah din he\"a. ");
INSERT INTO ifa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ta umaliya' ta mi'hapita' i he\"a ta nan Espiritun niddum i he\"a ya ipiddum'u bo i dida. Ta boddangan da'a ta adim ohhaan an mangipanuh hinadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ya ibagam hinadan tatagu ta atonda nan nibaga hi atonda ta ahida mibilang hi malinis te hi bigat ya waday ihdada. Ot ibagam i dida an dingngol'u nan kogada hi nunliliyanda hi ama\"id ha ihdada ya nan ibagabagadan udu'dul anuh din awadandah ad Egypt. Ot ibagam an ha\"on an Dios ya idat'uy ihdada ta manganda. ");
INSERT INTO ifa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ya bokon ohay algo ya ammunay punhidaanda onu duwa onu baintiy (20) algo. ");
INSERT INTO ifa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Te waday ihdayuh himbulan ta ingganah mahingla ayu ta adiyu mo hanguton. Athinay ma'at te din'uga' an Dios an wadan midmiddum i da'yu ot mungkoga ayu bo udot an alyonyuy, Udu'dulnaot eh'ah on agge ta'u tinaynan hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mu alyon Moses di, Undan adim tigon tudan nun'ibba' an umedah onom di gahut di libu (600,000)? Ya alyom ihya an idatmuy ihdadah himbulan. ");
INSERT INTO ifa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ta'on nin on alyon hi paltiyon di atnay baka ya kalnero ya undan nin umdah? Onu e alan an namin nadan ekan hinan baybay ya undan nin damdama umdah? ");
INSERT INTO ifa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ya alyon Apu Dios di, Undan waha adi' abalinan an Dios? Indani ta tigom hi'on nan imbaga' ya umannung onu adi. ");
INSERT INTO ifa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ot lumah'un moh Moses ot ena ibagah nadan tatagu nan imbagan Apu Dios i hiya. Ot ayaganay napituh (70) nadan ap'apun di himpahimpamu'un ot eda mali'li'woh an tuma'dog hinan way tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ya indani ya nungkohop hi Apu Dios hinan bugut ot mi'happitan i Moses. Ot ipiddumna bo nan Espiritun wada i Moses i dadiyen napitun (70) ap'apu. Ya hidin niddum i dida nan Espiritun Apu Dios ya waday nun'ibagadan nalpun Apu Dios. Mu agge nipidwah diyen na'at. ");
INSERT INTO ifa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mu wadaday duwan linala'in da Eldad i Medad an nunnanongdah nan nun'allunganda an ta'on onda napili hi ap'apu. Mu e niddum damdaman dida nan Espiritun Apu Dios ot pun'ibagada nan impa'innilan Apu Dios i didahdih nan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ta tinagtag han mangilog an lala'ih awadan Moses ot alyonay, Umman wahdi da Eldad i Medad an pun'ibagaday impa'innilan Apu Dios i dida. ");
INSERT INTO ifa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ya hi Joshua an hi na' Nun an hiya nan bimmanoddang i Moses an nihipun hi a'ungana ya alyona i Moses di, Apu Moses, em padinongon dida. ");
INSERT INTO ifa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mu alyon Moses di, Undan adim pohdon on bokon ha\"on ya abuh di mangibagah nan ipa'innilan Apu Dios hinadan tatagu? Ha\"on ya pohdo\"ot on an namin nadan tatagun Apu Dios ya mumbalindah propeta ya ipiddum Apu Dios nan Espirituna i dida. ");
INSERT INTO ifa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ta on nagibbuh hidiyen na'at ot umanamutdah nan nun'allunganda da Moses ya nadan ibbanan ap'apu. ");
INSERT INTO ifa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Indani ya wada han mabikah an dibdib an nalpuh awadan Apu Dios ta pun'iyaddibna nadan puguh nan baybay. Ot iyenah nan way nun'allunganda ot mungkohkohopda. Ta kumpulnan pangipluyan nadan tatagu on wadada. ");
INSERT INTO ifa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ot iyal'algoda ya inlablabidan nundopap hi hamuti. Ot hiya boy atondah nan nabiggat. Ta way oha i dida on umeh hinlibuy (1,000) kiluy inamungdah hamuti. Ot paltiyonda ot eda pun'ihapeh nunlini\"odan nan nun'allunganda ta mapindang. ");
INSERT INTO ifa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mu hidin pun'a'anda nan inha\"angdan hamuti ya nangimbubbungot hi Apu Dios hinadan tatagu ta impa'alina han nunhiglan dogoh. ");
INSERT INTO ifa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ta hiya nan nginadanandah diyen awadanda hi Kibrot-Hataabah te hidiy nangilubu'andah nadan nun'ahuhupu. ");
INSERT INTO ifa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ya hidin nadatngan boy akakanda ot umedah ad Haserot ot mun'allungda bohdi. ");
INSERT INTO ifa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Indani ya ihipun da Miriam i Aaron an e tumtumbu'on hi ibbadan hi Moses an gapuh nangahawaanah nan i Kus ");
INSERT INTO ifa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","an alyonday, Undan ammunah Moses hi ni'hapitan Apu Dios? Ot ten ni'hapit bon dita. Ta hi Apu Dios ya dingngolnah diyen hinapitda. ");
INSERT INTO ifa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mu hi Moses ya na'innilan nunhiglay pumpada\"ulana mu nan kumpulnan taguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ot humapit hi Apu Dios i Moses ya hi Aaron ya hi Miriam ot alyonay, Ume ayun tuluh nan way tabernakel. Ot umedan tulu. ");
INSERT INTO ifa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Indani ya nungkohop nan bugut an awadan Apu Dios ot umeh way panton nan tabernakel. Ot ayaganah Aaron ya hi Miriam. Ta hidin eda nihaggon an duwa ");
INSERT INTO ifa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ya alyon Apu Dios di, Donglonyu tun ibaga'. Wada'ey propeta hi niddum i da'yu ya hay ato' an mangipa'innila i hiya hinan pohdo' an ipa'innilana ya ipatigo' onu ipa'inop'u i hiya. ");
INSERT INTO ifa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mu hinan baal'un hi Moses ya bokon athidiy inat'u te hiya ya na'na'unnud an nangipanapto' i da'yun tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ya mi'hapita\"en hiya ya munhangngaban ami. Ta mabalin an tigonay umata' ya naputu' nan ibaga' i hiya an adi' ipa\"el. Ya tanganu on ayu adi tumakut an mamihul hinan baal'un hi Moses. ");
INSERT INTO ifa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ta nunhiglay bungot Apu Dios i dida ot taynana dida. ");
INSERT INTO ifa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ya hidin timmulu nan bugut hi baktun nan tabernakel ya inoy an pimmulaw di up'up Miriam te na'gullidan. Ya hidin tinigon Aaron ");
INSERT INTO ifa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ot mumpahpahmo' i Moses an alyonay, Adi da'mi bahan dusaon an iba an gapuh nan numbahulanmin ay ami nawe'we'. ");
INSERT INTO ifa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Adim bahan iyabulut an mipaddung hi Miriam hinan golang an nateh putun inana an natano' ta mun'a'agah di lamohna. ");
INSERT INTO ifa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ot mumpahpahmo' moh Moses i Apu Dios an alyonay, Apu Dios hanat ipaphodmu bahan hi Miriam. ");
INSERT INTO ifa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ya alyon Apu Dios di, Hi'on tinukpaan amanay angahna ya ta'omman ta li'naonay ababain i ha pituy algo. Ot ipabata\"anyuh nan nun'allunganyu ta e munhiwwe i ha pituy algo ya ahiyu mohpe pumbangngadon. ");
INSERT INTO ifa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ot ibagada mo i Miriam ta e mihiwwe hi pituy algo. Ot adida mo makak nadan tatagu ta inggana ot mumbangngad. ");
INSERT INTO ifa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ot ahida mohpe makak nadan tataguh ad Haserot ot umedah nan agge naboblayan hi ad Paran ot mun'allungda bohdi. ");
INSERT INTO ifa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Pot'om di hinohhan ap'apun nadan himpahimpamu'un an tinanud Israel ta eda tigon di a'at nan bobleh ad Kanaan an idat'un da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ta hidiyey inat Moses an hinnagna nadan ap'apun di tinanud Israel hidin nun'allungandah nan agge naboblayan hi ad Paran. ");
INSERT INTO ifa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ta datuwey ngadan nadan ap'apu an hinnagna. Hinan tinanud Ruben ya hi Sammua an imbabalen Sakkur. ");
INSERT INTO ifa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Hina'en tinanud Simeon ya hi Sapat an imbabalen Hori. ");
INSERT INTO ifa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Ya hina'en tinanud Judah ya hi Kaleb an imbabalen Jepunneh. ");
INSERT INTO ifa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Ya hina'en tinanud Issakar ya hi Igal an imbabalen Joseph. ");
INSERT INTO ifa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hina'en tinanud Epraim ya hi Hosea an imbabalen Nun. ");
INSERT INTO ifa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Ya hina'en tinanud Benjamin ya hi Palti an imbabalen Rapu. ");
INSERT INTO ifa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Ya hina'en tinanud Sebulun ya hi Gaddiel an imbabalen Sodi. ");
INSERT INTO ifa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Ya hina'en tinanud Manasseh an imbabalen Joseph ya hi Gaddi an imbabalen Susi. ");
INSERT INTO ifa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Hina'en tinanud Dan ya hi Ammiel an imbabalen Gemalli. ");
INSERT INTO ifa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Ya hina'en tinanud Aser ya hi Setur an imbabalen Mikael. ");
INSERT INTO ifa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Hina'en tinanud Naptali ya hi Nahbi an imbabalen Bopsi. ");
INSERT INTO ifa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Ya hina'en tinanud Gad ya hi Gewel an imbabalen Maki. ");
INSERT INTO ifa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ta danaey ngadan nadan linala'in hinnag Moses ta eda tigon di a'at nan bobleh ad Kanaan. Ya hi Moses ya nginadananah Hosea an imbabalen Nun ta hi Joshua. ");
INSERT INTO ifa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ya hay imbagan Moses i dida ot ahida makak ya alyonay, Ume ayu ya innaynayunyuh nan negeb ta ingganah nan pogpog nan nun'abillid an bobleh ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ta tigonyu hi'on nganney umatan diyen boble ya hay a'at nadan tataguhdi hi'on dakolda onu oh'ohhada ya hi'on mun'abikahda onu adida. ");
INSERT INTO ifa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ya tigonyu hi'on nganney a'atna hi'on maphod nan lutahdi onu adi ya hi'on nadan nun'aboblayan hidi ya waday binattun aladda onu ma\"id. ");
INSERT INTO ifa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ya tigonyu bo hi'on malumong nan lutahdi onu adi. Ya on wahdiday kayiwna onu ma\"id. Ya hitun pumbangngadanyu ya mangala ayu i dohah nadan maphod an bungbunga''an an nitanom hidi. Ya i diye ya nun'alum nadan greyp. ");
INSERT INTO ifa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ta imme dadiyen linala'i an inhipundah nan agge naboblayan hi ad Sin hidih ad Kanaan ta ingganah ad Rehob an nihaggon hi ad Lebo-Hamat. ");
INSERT INTO ifa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ot i'wadah nan negeb ot umedah ad Hebron an numboblayan nadan tinanud Anak an da Ahiman ya hi Sesay ya hi Talmay. Hi ad Hebron ya pituy tawon an nibangon ot ahi mibangon hi ad Soan an ohan boble hi ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ya hidin dimmatongdah nan nundotal hi ad Eskol ot alanda han nangimbubbungan hapang di greyp. Ot iyattang di duwa i dida an iniddumdah nan bungan di fig ya pomegranet. ");
INSERT INTO ifa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Hay ngadan diyen boble ya hi ad Eskol an gapuh nan nabungubbungul an bungan di greyp an inalan dadiyen tinanud Israel hidi. ");
INSERT INTO ifa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Napat (40) di algoy e nunsi'iman dadiyen linala'i hi ad Kanaan ot ahida mibangngad ");
INSERT INTO ifa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","hi awadan da Moses i da Aaron ya nadan ibbadan tinanud Israel hidih nan nun'allunganda hi ad Kades hinan agge naboblayan hi ad Paran. Ot uhuhonda nadan tinigoda ot ipatigoda bo nan inaladan hapang di bungbunga''an an bimmunga. ");
INSERT INTO ifa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ya hay inuhuhda i Moses ya alyonday, Lini'odmih diyen boble ya immannung peman an makadangyan ya malumong. Ot wahtu tee nadan inalamin bungbunga''an. ");
INSERT INTO ifa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mu umman nada'en tataguhdi ya ongal di abalinanda ya o''ongal bo udot di numpumboblayanda an nun'a'alad hi binattu. Ya wahdida bo udot nadan ay kakabbakab an tinanud Anak. ");
INSERT INTO ifa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ya hanada'en tinanud Amalek ya nunhitudah nan negeb ya hanada'en tinanud Hit ya tinanud Jebus ya tinanud Amor ya hinadan nun'abillid an boble. Ya hanada'en tinanud Kanaan ya diday numpumbobleh nan way da'ging di baybay an nungngadan hi Mediterranean ya hinan da'ging di wangwang an nungngadan hi Jordan. Ta athidiy inuhuh nadan e nunsi'im hinan bobleh ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ya ahililili nadan tatagu i Moses mu impadinong Kaleb didan alyonay, Mahapul an ume ta'u ta dita'uy e mumboblehdi ot abalinan ta'un mangubat i dida. ");
INSERT INTO ifa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mu nadan udum an linala'in ni'ye i Kaleb ya alyonday, Adi ta'u mahdi pa\"abak i dadiyen tatagu te ma'attigon ongal di abalinanda mu dita'u. ");
INSERT INTO ifa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ot edaot ibagabagah nadan ibbadan tinanud Israel di agge immannung an a'at nan boble. An analyonday, Adi mahdi umdah diyen boble hi puntanoman nadan nunhituhdi. Ya an namin bo udot nadan tataguhdi ya o\"ongngalda. ");
INSERT INTO ifa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ya tinigomihdi nadan o''ongal nimpen tatagun ay kakabbakab an dadiye nadan tinanud Anak. Ta hiya nan hay nunli'namin immehdi ya ay ami ba''atong hi hinangngabda ot wan athidi boy panigodan da'mi. ");
INSERT INTO ifa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nadan tatagu ya nginumhopda ot ilablabidan kumogakoga ");
INSERT INTO ifa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","on pun'ililida i da Moses i Aaron an alyonday, Udu'dulna boy nate amih ad Egypt onu hitun agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mu tanganu on da'mi e inyalihtu i Apu Dios ya dee damdaman patayon da'mi hinadan tataguhdi ya nun'aladaot nadan ahawami ya imbabalemi? Udu'dulnaot boy mumbangngad ta'uh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ya munhahapit nadan tatagun alyonday, Pot'on ta'uot eh'a ha mangipangulu i dita'u ta mumbangngad ta'uh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ot mundu\"un da Moses i Aaron an nida\"om di angahdah nan luta hi hinangngab nadan tatagun na'amung. ");
INSERT INTO ifa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ya ta'on on hi Joshua an hi na' Nun ya hi Kaleb an hi na' Jepunneh an ni'yen e nanigoh ad Kanaan ya punhethetday lubungdah inomnomanda. ");
INSERT INTO ifa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ot alyondah nadan tataguy, Ibagamin da'yu an nan boble an emi tinigo ya immannung an maphod an boble. ");
INSERT INTO ifa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ot unudon ta'u'eh Apu Dios ta waday pun'amlongana i dita'u ya ipangulu dita'uhdi i hiya ta dita'uy pangidatana i diyen boble an malumong ya damuna ya makadangyan. ");
INSERT INTO ifa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ot maphod on adi ta'u ngohayon hi Apu Dios ya adi ta'u tumakut hinadan tataguhdi ot agge naligat hi e ta'u pangabakan i dida te wadah Apu Dios i dita'u mu dida ya ma\"id ha mangihwang i dida. Ot hanat adi ayu tumakut. ");
INSERT INTO ifa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mu nadan tatagu ya nunhahapitandan topon dida mu nipatigo i dida nan anabaktun Apu Dios hinan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Himmapit hi Apu Dios i Moses ot alyonay, Ngalngalam ha ngohen danaen tatagu i ha\"on. Anuud nin ya ahiya' kulugon i dida an ta'on on dakol nadan tinannigodan inat'un milagro. ");
INSERT INTO ifa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ad uwani ya ipa'ali' han dogoh ta madadagdan namin ta wan he''a ya abuh di punholago' hi dakkodakkol ta pumbalinon da'yu hi mundongol ya mabikah hitun luta an bokon danaen tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mu alyon Moses i Apu Dios di, Apu Dios, datuwen tatagu ya inikakmuh ad Egypt an gapuh nan ongal an abalinam. Ot undan nganne boy alyon nadan i Egypt hi'on donglondah naen atom? ");
INSERT INTO ifa_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Mabalin an dida mo boy mangipa'innilah nadan tataguh ad Kanaan. Yaden hay dingngolda ya he''an Dios di wadan da'mi te nanongnan numpatigo'an da'mi i han ay bugut. Ya dingngoldan hay atom an mangipangpangulun da'mi ya mapatal'e on wada nan bugut ya nahdom'e on wada nan apuy ta hiyay un'unuddonmi. ");
INSERT INTO ifa_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ot onha atomhidi ta pa'ibagom an patayon tudan tatagum ot undan adida alyon hi ");
INSERT INTO ifa_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","manu'eh numpatena nadan tatagunah nan agge naboblayan ya adina abalinan an idatong didah nan boblen inalinah idatna i dida. ");
INSERT INTO ifa_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ot hiya nan hanaot ta ipatigom bahan di abalinam i da'mi ta atom nan imbagam an alyom hi ");
INSERT INTO ifa_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","he''a an Dios ya adi hi kittang on bimmungot'a te nunnaud di pamhodmu ya pangipapto'mu ya atbohdiy em punlinglingan hi bahul ya ngohen di tatagu. Manu te imbagam bo an adim ibahhon dusaon nadan numbahul an ta'on on nadan imbabaleda ya apapuda ta ingganah nan pipat di tanudanda. ");
INSERT INTO ifa_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Mu hanat gapuh nan ongal an pamhodmu i da'mi ya pakawanom bahan tudan tatagu hinadan numbahulanda ta umat hi namakapakawanam hi bahulda an nihipun hi nakakanmih ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ya alyon Apu Dios i hiyay, Ot gapu ta hinaey imbagam ya pinakawan'u mo didah nan numbahulanda. ");
INSERT INTO ifa_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ot hinaen hinapit'u ya immannung an umat hi a'immannung di anabaktu' an matigoh tun luta. ");
INSERT INTO ifa_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ot ibaga' tee an danaen tatagu ya ma''id i dida ha mi'datong hinan boblen inali'. Te tinannigoda nan binang'u ya atbohdin tinannigoda nadan milagro an ina'inat'uh ad Egypt ya hinan agge naboblayan mu hiya damdaman inaynayundan mamatnapatnan ha\"on ta attaondan adi unudon nadan tugun'u. ");
INSERT INTO ifa_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ot hiya nan adi mabalin hi mi'datongdah nan boblen imbaga' i handidan a'ammodda. Te nan adi mangunud i ha''on ya adi mabalin hi dumatong hidi. ");
INSERT INTO ifa_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mu nan baal'un hi Kaleb ya hiya nan nanongnan waday dinolna i ha''on ot hiya ya abuh han mi'datong hinan boble an ena ni' tinigo ta nadan holagnay mangiluta. ");
INSERT INTO ifa_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Nadan tinanud Amalek ya nadan tinanud Kanaan ya numbobledah nan nundotal ta hiya nan hi bigat ya imbangngadyuh nan agge naboblayan hi nangappit hinan baybay an mumbolah. ");
INSERT INTO ifa_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Ma''id damdama nee ha dindinong danaen tatagun lumililili i ha''on ya ten impahigaa' mo. ");
INSERT INTO ifa_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ot ibagayu i dida an ha\"on an Dios ya ibaga' tee an nan imbagadah ma'at i dida ya hidiyey ato'. ");
INSERT INTO ifa_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ta an namin ayun mahuluk hi baintiy (20) tawona ya mate ayuh tun agge naboblayan ta miwakat di adolyuhtu an gapuh nan punlilililiyanyu i ha''on. ");
INSERT INTO ifa_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ta ma\"id i da'yu ha dumatong hinan imbaga' an eyu punhituwan an ammunah Kaleb an imbabalen Jepunneh ya hi Joshua an imbabalen Nun. ");
INSERT INTO ifa_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ya nada'en imbabaleyun alyonyuy alina hi pun'alan di binuhul ya diday idatong'u i diyen boblen pinihulyu ta diday munhituhdi. ");
INSERT INTO ifa_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mu da'yu'e ya hitun agge naboblayan di atayanyu. ");
INSERT INTO ifa_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ta datuwe attog an imbabaleyuy munholholtap hi napat (40) di tawon an gapuh adiyu pangun'unudan i ha\"on an Dios ta eda mi'yanin'innabat i da'yuh tun agge naboblayan ta ingganah on ayu ma'upput an mun'a'ate. ");
INSERT INTO ifa_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ta din napat (40) di algo an eyu nunsi'iman hi ad Kanaan ya mumbalin hi napat (40) di tawon an punligatanyu an gapuh bahulyu ta wan innilaonyuy a'atna hi'on ha''on di bumungot i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ot hiyay ato' i da'yun adi maphod di nomnomna ta wan an namin ayun mungngohe i ha''on ya hitun agge naboblayan di pun'a'atayanyu. Ha''on an Dios di mangalin tuwe. ");
INSERT INTO ifa_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ta hay gapunah nunliliyan nadan tatagu i Apu Dios ya nan layah an imbagabagan nadan linala'in hinnag Moses an e nunsi'im hi ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ta hiya nan nundogohon Apu Dios dadiyen munlayah an e nunsi'im ta nun'a'ateda. ");
INSERT INTO ifa_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ta ammuna da Joshua an hi na' Nun ya hi Kaleb an hi na' Jepunneh an nabatih nadan linala'in e nanigoh a'at di ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Hidin imbagan Moses hinadan tatagu nan inalin Apu Dios ya nunhiglay eda umukayungan. ");
INSERT INTO ifa_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ot alyonday abulutondan numbahulda ot mabalin mo anun umedah nan boblen imbagan Apu Dios hi idatna. Ta hidin mun'abigat ya nakakda mohpen ipluydah nadan nun'abillid an bobleh ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mu alyon Moses i diday, Tanganu onyu bo aton nan adi miyunnudan hinan pohdon Apu Dios. Ma\"id ha hilbin naen ninomnomyun aton. ");
INSERT INTO ifa_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Adi ayuot mange te adi da'yu damdama boddangan i Apu Dios ot ma\"id ha bahhonan abakon da'yuh ");
INSERT INTO ifa_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","nadan tinanud Amalek ya nadan tinanud Kanaan. Te din'ugyuh Apu Dios ta hiya nan adi da'yu mo boddangan i hiya ta pumpate da'yuh nadan tataguhdi. ");
INSERT INTO ifa_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mu ipapilitda damdaman umeh nan way nun'abillid an boble hi ad Kanaan an ta'on onda agge nakak da Moses ya ta'on on nan Kahun an nittuwan nan Hapit Apu Dios ya aggeda inikak. ");
INSERT INTO ifa_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ta immeda ot madana''ulda nadan tinanud Amalek ya nadan tinanud Kanaan ot gubatonda dida ta na'abakda ot pumpudugda dida ta ingganah ad Hormah. ");
INSERT INTO ifa_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Ibagam hinadan tinanud Israel ta dumatong ayu'eh nan boblen indat'u i da'yu ta mumboble ayu mohdi ");
INSERT INTO ifa_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ya wa'et waday i'nongyu hi maghob an mi'nong i ha\"on an Dios an umat hi baka onu kalnero onu gulding ta umipa'amlong di hunghungna i ha\"on onu nadan udum an i'nongyu an umat hinadan ninomnomyu tuwalin i'nong onu nadan i'nongyuh nadan nagtud an ngilin ");
INSERT INTO ifa_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ya tigonyu ta iddumyu ha duway basu an bayah ya ohay kilun alina an nadduman hi duway basun mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ya hinan ohan kalnero an mi'nong onu maghob an mi'nong ya hay midawat an ma'inum ya ha ohay litron bayah. ");
INSERT INTO ifa_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ya alina'e hi tangbal an kalnero nan mi'nong ya hay idadaanyu ya ha duway kilun maphod an alina an nadduman hi tuluy basuh mantekan di olibo ");
INSERT INTO ifa_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ya ha midawat an ma'inum an tuluy basun bayah. Ot ha''on an Dios ya mipa'amlonga' hinan hunghung danaen i'nongyun ha''on. ");
INSERT INTO ifa_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ya hi'on kilaw an baka nan maghob an mi'nong onu mi'nong an gapuh nan imbagayun i'nongyu i ha''on onu ha mi'nong hi pi'hayyupanyu i ha''on an Dios ya ");
INSERT INTO ifa_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","iddumyu ha tuluy kilu an alina an nadduman hi opat di basu an mantekan di olibo ");
INSERT INTO ifa_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ya ha duway butilyan bayah. Ot mipa'amlonga' hinan hunghung danaen i'nongyu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ta danaey middum hinan mi'nong an baka onu kalnero onu gulding. ");
INSERT INTO ifa_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ya alina'e hi mahuluk hi oha nan mi'nong ya atbohdi an madduman nan middum an midawat an alina ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ot hiya danaey mahapul hi unudonyun tinanud Israel hi'on waday iyaliyu hi maghob an mi'nong. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ya ta'on on nadan niddum i da'yu an bokon tinanud Israel an minaynayun di iddumanda i da'yu onu adi ya mahapul an wada'e ha maghob an i'nongda ta nan hunghungna ya umipa'amlong i ha\"on an Dios ya mahapul an unudonda nan atonyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ot hanat hinaey minaynayun hi atonyun mangi'nong an ta'on on nadan mi'iboblen da'yu. Te ha''on an Dios ya numpapaddung ayun ha\"on an ta'on on nadan ni'iboblen da'yun nalpuh udum hi boble. ");
INSERT INTO ifa_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ta hiya nan numpaddung di tugun hi un'unudonyun namin. ");
INSERT INTO ifa_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Ahim ibaga datuweh nadan ibbayun tinanud Israel an dumatong ayu'e i diyen boble ");
INSERT INTO ifa_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ta mabalin an anonyu moy bungan di intanomyu ya mahapul an waha idawatyun ha''on. ");
INSERT INTO ifa_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ta iha''angyu'e nan mamangulun ginilingyun alina ya hiwwayonyu nan mamangulun iha\"angyu ta midawat i ha''on ta umat hi nangidawatanyuh nan hiniwweyu bon na'ilik an pa'agapasyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ot datuwey inaynayunyun aton an idawatyu i ha''on nan mamangulun iyammayun tinapay hinan apitonyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Mu hi'on aggeyu inatta ya waday imbahhoyu i danaen imbaga' i Moses ");
INSERT INTO ifa_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","an un'unudonyu ya nadan tanudanyuh pidwana ");
INSERT INTO ifa_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ya athituy atonyu. Ot alina'eh on numbahul ayun namin an bimmoble an gapuh aggeyu nanginnilaan ya hay i'nongyu ya ha ohah kilaw hi baka ta maghob an mi'nong ot nan hunghungna ya umipa'amlong i ha\"on. Mu mahapul nimpen middum nadan nibaga an midawat an alina ya bayah ya ha oha mohpe i ha gulding ta mi'nong hi apakawanan di bahulyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ta hiya danaey i'nong nan padi ta a'aanan di bungot'un Dios an gapuh bahulyun tatagu ta mapakawan ayu an himpamoble hinan numbahulanyun aggeyu inatta. ");
INSERT INTO ifa_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ot ha''on an Dios ya linglingo' nan numbahulanyu ya ta'on on nadan ni'iboble i da'yu te nilaggat ayun namin an bimmoble. ");
INSERT INTO ifa_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Alina'eh oha nan numbahul mu aggena inatta ya hay i'nongna ya ha tinna an gulding an ohay tawona ta apakawanan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ta e i'nong nan padi ta a'aanan di bungot'un Dios an gapuh bahul diyen tagu an aggena inatta ta mapakawan hinan numbahulana. ");
INSERT INTO ifa_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Hinaen tugun'u i da'yu ya bokon da'yu ya ammunan tinanud Israel di mangun'unud i danae te ta'on on nadan ni'iboblen da'yun nalpuh udum hi boble. ");
INSERT INTO ifa_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mu alina'eh on inattan di ohan tagun numbahul an ta'on on tinanud Israel onu bokon ya ha''on di pinihulna ot mahapul an mipapate ta adi midmiddum i da'yun tatagu'. ");
INSERT INTO ifa_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Te hiya ya inattanan agge inunud nan tugun'u ta hiyah diyey dusan di bahulna. ");
INSERT INTO ifa_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Hidin awadan nadan tinanud Israel hinan agge naboblayan ya wada i dida han na'akhupan an e nangayiw i han Habadun tungo. ");
INSERT INTO ifa_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ot awitonda ot iyeda i da Moses i Aaron ya hinadan na'amung an tataguhdi ");
INSERT INTO ifa_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ot ipaguwalyada ni' ta nangamung di ipa'innilan Apu Dios hi atondan hiya. ");
INSERT INTO ifa_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Indani ya alyon Apu Dios i Moses di, Hinaen numbahul ya mahapul an mipapate. Ot hay atonyu ya ibata''anyuh nan way nun'allunganyu ya nunhintotopaanyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ta hiya moy inat nadan tatagun namate i hiya ta miyunnudan hinan imbagan Apu Dios i Moses hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Ibagam hinadan tinanud Israel ta baluybuyanda nan gayadan di lubungda hinan asul di kololna. Ot mahapul an hiya damdamay aton nadan mun'atanudan hi inggana. ");
INSERT INTO ifa_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ta tinigoyu'e nadan baluybuy di lubungda on mipanomnom i da'yu nadan tugun'u ta un'unudonyu ta bokon nadan pohpohdon di adolyuy atonyu. ");
INSERT INTO ifa_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ta nomnomnomonyu nimpe nadan tugun'u ta un'unudonyu ta nanongnan niyappit ayu i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Te ha''on an Dios an dayawonyu di nangikak i da'yuh ad Egypt ta wan ha''on di nanongnah unudonyu. Ha\"on nimpe nan Dios an dayawonyu. ");
INSERT INTO ifa_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Hi Korah an imbabalen Isar an hi na' Kohat an tinanud Libay ya nunhahapitdah nadan tinanud Ruben an da Datan i Abiram an imbabalen Eliab ya nan imbabalen Pelet an hi On te pohdondan ipatigoy pungngohayanda i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ya niddum i dida nadan inhapitandan duway gahut ta nabonglen (250) ap'apun pinto' nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ta nun'oh'ohhada ot umedah awadan da Moses i Aaron ot alyondan diday, Nunhigla bahan bo nayyay pangatyu. Innilamin an namin ta'un wahtu ya wadah Apu Dios an bumoddang i dita'u. Mu tanganu on hay punnomnomyuh adolyu ya nabakbaktu ayu mu da'min tatagu? ");
INSERT INTO ifa_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ya hidin dingngol Moses hidiyen imbagada ya namaaggot munlu'bub. ");
INSERT INTO ifa_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ot ahina mohpe alyon i Korah ya nadan ibbana di, Hi bigat ya ipa'innilan Apu Dios hi'on nganne i dita'u di niyappit i hiya. Ot nan pinto'nan puntamuwona ya diday iyabulutnah mihaggon i hiya hinan way punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ta way oha i da'yu on inodnana ha punggobhan hi insenso. ");
INSERT INTO ifa_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Ta hi bigat ya hina\"adanyuh bala ya insenso ta tigon ta'uh on nganne i dita'u di pinto' Apu Dios. Ot alyon bon Moses di, Nunhigla ayu otahan an tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ot inayun Moses an alyon i Korah di, Igongahanyuh tuwen da'yun tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Undan unguhanyu nan inat Apu Dios i da'yun tinanud Libay an da'yuy pinto'nah puntamuwonah nan tabernakel ta itamuyuy aphodan tun ibba ta'un tatagu? ");
INSERT INTO ifa_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ongal hinaen nangipabaktuwan Apu Dios i da'yu ya nadan i'iba ta'un tinanud Libay ya tanganunyu amohan ahan nan tamun nan padi? ");
INSERT INTO ifa_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hinaen punliliyanyu ya bokon hi Aaron di nginheyu te hi Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ot e ipa'ayag Moses nan ibban Korah an da Datan i Abiram an da na' Eliab mu adida te alyonday, ");
INSERT INTO ifa_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Undan unguham Moses nan inatmu i da'mi an e da'mi ingkak hi ad Egypt an boblen malumong ya damuna ya makadangyan ta hitun agge naboblayan di pamatayam i da'mi? Ya ngalngalam bo nayya ta gahin bahan boh on he''ay mun'ap'apu i da'mi. ");
INSERT INTO ifa_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ya alyonda boy, Daan ihyahtu ta inye da'min he''ah nan alyom an boblen malumong ya makadangyan ya damuna an alyom hi idatmun da'min puntanoman hi makan ya puntanoman hi greyp? Ya ad uwani ya ilayahan da'mi bo ta pa'aliyon da'mihna mu adi ami umali. ");
INSERT INTO ifa_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ya bimmungot hi Moses ot mundasal an alyona i Apu Dios di, Adim abuluton nan idawat danaen linala'i i he''a te ma''id attog ha inat'uh adi maphod i dida ya ma''id ha ta'on hi ohan dongki hi inako' i dida. ");
INSERT INTO ifa_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ot alyon Moses i Korah di, Bigat ya immali ayun namin hinan duway gahut ta nabonglen (250) ibbam ta ma'amung ayun namin i da Aaron hi hinangngab Apu Dios hinan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ta mapong ayuh punggobhan hi insenso ta iha''adanyuh bala ya insenso ya indawatyu i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ta on nabiggat ot hidiyey atonda ot eda umohnong hinan way panton nan tabernakel an didan namin i da Aaron i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ot umeda bo nadan tatagun inhaphapitan Korah ot eda mi'hangngaban i da Moses i Aaron. Ya alinah on na'ibagan nawada nan humilin binang Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ya himmapit hi Apu Dios i da Moses i Aaron ot alyonay, ");
INSERT INTO ifa_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Mibata''an ayu i datuwen tatagu ta wan pa'ibago' an dadagon dida. ");
INSERT INTO ifa_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mu nunlu'bub da Moses i Aaron an nida''om di angahdah nan luta ot alyonday, Apu Dios an nunlumuh an namin di tagu. Undan gapu ta wada ha ohah numbahul ya ilagatmun dusaon an namin tudan tatagu? ");
INSERT INTO ifa_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Ibagam hinadan tatagu ta mibata''anda i da Korah ya hi Datan ya hi Abiram. ");
INSERT INTO ifa_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ot mangeh Moses hi awadan da Datan ya hi Abiram ya nitnud nadan ap'apun di himpahimpamu'un an tinanud Israel i hiya. ");
INSERT INTO ifa_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ot alyon Moses hinadan na'amung an tataguy, Mibata''an ayuh nan nun'allungan datuwen adi maphod an tatagu ta adiyu dapaon di kumpulnah nadan gina'uda ta wan adi ayu milagat an madusa. ");
INSERT INTO ifa_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ot mibata''anda mohdi nadan tatagu yaden limmah'un da Datam an hina'amma ya atbohdi da Abiram an hina'amma an ta'on on nadan goggolang an imbabaleda ot tuma'dogdah nan way panton di allungda. ");
INSERT INTO ifa_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ya alyon Moses hinadan tatagu di, Ad uwaniy panginnilaanyun hi Apu Dios di nannag i ha''on ot ahi' aton nadan ina'inat'u te agge attog nalpun ha''on. ");
INSERT INTO ifa_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ot onha alinah hay iyaten datuwen tatagu ya gapuh dogoh onu nadan udum an bokon gapuh dusada ot mabalin an alyonyuy bokon hi Apu Dios di nannag i ha''on. ");
INSERT INTO ifa_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mu alina'e tuwalih aton Apu Dios ha nakaskasda'aw ta punhi''anona nan lutan nipto'anda ta ma'uhbungdah ad dalom an middum nadan gina'uda ya hiyay panginnilaanyun gapuh nungngohayandan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ya hidin impadappuhnan inalih diye ya nunhi''an nan lutah awadan da Datan i da Abiram ");
INSERT INTO ifa_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ot ma'uhbungdah din namin an niddum da Korah an hina'amma ya nadan udum an ni'ita'dog an nangiyunnud i dida ya ta'on on nadan gina'uda. ");
INSERT INTO ifa_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ta mataguda ot milubu'da an ta'on on nadan gina'uda ot ahi mohpe mun'umut nan luta ot mama\"idda. ");
INSERT INTO ifa_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ta dingngol nadan tatagu ot ahibubuttikanda an pun'itkukdan alyonday, Mange ta'u pe te alina ya nilagat ta'un na'uhbung. ");
INSERT INTO ifa_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ya impa'alin Apu Dios han apuy ot maghob nadan duway gahut ta nabonglen (250) linala'i an napong hi punggobhan hi insenso. ");
INSERT INTO ifa_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Ibagam hinan imbabalen nan padin hi Aaron an hi Eleasar ta ena guyudon ya inalana nadan duyun inusal dadiyen nun'aghob ya nun'ikuyagnah nan nibata\"an nadan balan nun'ittuhdi. Te dadiyen punggobhan hi insenso ya niyappitda i ha''on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ta alana dadiyen nunggobhan dadiyen nate an gapuh bahulda ta pumpitpitna ya nun'ipaklanah nan punggobhan hi mi'nong ta hiyay mangipanomnom hinadan tatagu i naen na'at. ");
INSERT INTO ifa_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ot hiyay aton Eleasar ta inamungna dadiyen gombang an punggobhan hi insenso an inusal dadiyen naghob an linala'i ot pumpitpitna ta ena ipaklah nan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ta hidiyey mangipanomnom hinadan tinanud Israel an nan bokon tinanud Aaron ya adi mabalin hi e munggohob hi insenso ta midawat i Apu Dios te alinah ma'at i dida bo nan na'at i da Korah ya nadan ibbana. Ta an namin nadan imbagan Apu Dios i Moses hi aton Eleasar ya hiyay na'at. ");
INSERT INTO ifa_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mu hidin nabiggat bo ya ahilililida damdama nadan tatagu i da Moses i Aaron an alyonday, Tanganu onyu pinatey udum hinadan ibba ta'un tatagun Apu Dios? ");
INSERT INTO ifa_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ya hidin na'amungda nadan tatagu an ahililili i da Moses i Aaron ya alinah on nihophop hinan way tabernakel nan bugut ya nunhiglan humiliy binang Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ot ume da Moses i Aaron hinan way panton nan tabernakel ");
INSERT INTO ifa_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Mibata''an ayuh nadan tatagu ta wan punnaudo' an dadagon dida. Ya innayun da Moses i Aaron an nunlu'bub. ");
INSERT INTO ifa_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ot alyon Moses i Aaron di, Tagtagom ta em alan nan punggobhan hi insenso ya inittuwam hi bala an alam hinan punggobhan hi mi'nong ya inittuwam hi insenso ya na'anne'ah awadan nadan na'amung an tatagu ta a'anan di bungot Apu Dios an gapuh bahulda. Te bimmungot moh Apu Dios ta impa'alina han dogoh an umiyate. ");
INSERT INTO ifa_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ta inat Aaron nan inalin Moses ta inyena nan punggobhan hi insenso hi awadan nadan na'amung an tatagu mu niluh an nihipun mon wadaday mundogoh hinadan tatagu mu nunggohob damdamah Aaron hi insenso ta a'aanan di bungot Apu Dios an gapuh bahul ");
INSERT INTO ifa_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ot ahi mohpe midinong nan pun'a'atayan nadan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ya hay bilang di nate i diye ya himpulut opat di libu ta han pituy gahut (14,700) an aggeda ni'bilang da Korah ya nadan ibbanan namangulun nate. ");
INSERT INTO ifa_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ta dimminong hidiyen dogoh ot ahi mohpe mabangngad hi Aaron hi awadan Moses hidih nan way panton nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Ibagam hinadan ibbam an tinanud Israel ta way ohah nadan himpulut duwan (12) ap'apun di himpahimpamu'un an tinanud Israel ya idatdan he''ay hinohhah hu''ud ya intudo'muy ngadandah nan hu''udda. ");
INSERT INTO ifa_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ya hay mitudo' hinan hu''udda an malpuh nan tinanud Libay ya hi Aaron. Ta an namin nadan himpulut duwan (12) ap'apu ya mapongdah hu''ud. ");
INSERT INTO ifa_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ya inalam'e dadiyen hu''ud ya inighopmuh nan Kuwartu' an Dios an uggan'u pi'dammuwan i he''a ya em inhaggon hinan Kahun an nittuwan nan Hapit'un Dios. ");
INSERT INTO ifa_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ot hay ma'at hinan hu''ud nan pinto''un mumpadi ya humaping ta hidiyey ato' an mangipadinong hinan lilin nadan tatagu i he''a. ");
INSERT INTO ifa_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ot hidiyey ibagan Moses hinadan ibbanan tinanud Israel ta way ohah nadan himpulut duwan (12) ap'apu on inyenay hu''udna i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ot iyen Moses dadiyen hu\"ud hinan kuwartun Apu Dios ot ihaggonah nan Kahun an nittuwan nan Hapit Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ta hidin nabiggat ya numbangngad hi Moses hinan kuwartun Apu Dios ya tinigonan himmaping nan hu''ud Aaron an nangita'dog hinadan tinanud Libay. Ya nan hapingna ya wadaday habungna ya bungana an almon. ");
INSERT INTO ifa_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ot alan Moses an namin nadan hu''ud ot ena ipatigoh nadan tatagu ta nunhintiggandah diyen na'at ot ahi bangngadon nadan ap'apu dadiyen hu''udda. ");
INSERT INTO ifa_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ya alyon Apu Dios i Moses di, Em ipabangngad nan hu''ud Aaron hidih nan way Kahun an nittuwan nan Hapit'u an Dios ta hidiyey mangipanpanomnom hinadan tatagu an adida'e idinong an lumililili ya pumpate' dida. ");
INSERT INTO ifa_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ot hiya mo boy aton Moses. ");
INSERT INTO ifa_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ya alyon nadan tatagu i Moses di, Ot hinae mo ahan di apogpoganmi ");
INSERT INTO ifa_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","hi'on an namin nadan umeh nan tabernakel on mateda ot an namin ami mo ya mate ami. ");
INSERT INTO ifa_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Alyon Apu Dios i Aaron di, Kumpulnan ma'at an pumbahulan hitun pundayawanyun ha\"on an Dios ya he\"a ya nadan padin imbabalem ya nadan i'ibayun tinanud Libay di munholtap hinan dusan di pumbahulan an ma'at hinan tabernakel. Mu hi'on he\"a onu nadan imbabalem an padi di mangat hinan pumbahulan ya da'yu ya abuh di munholtap hinan dusan di numbahulanyu. ");
INSERT INTO ifa_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ot awitom nadan i'ibam an tinanud Libay ta bumoddangdan da'yun hina'amma hinan punhilbiyanyuh nan tabernakel an mangipanomnom an wadaa' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ya ipadutu'yu dida ta wan atonda nadan tamuda. Mu mahapul an adida umeh awadan nadan usal hinan tabernakel ya hinan punggobhan hi mi'nong te atonda'ehdi ya mate ayun namin. ");
INSERT INTO ifa_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ot mahapul an bumoddangdan da'yu an mumpapto' hinan tabernakel an pi'dammuwanyun ha\"on ya an namin an tamuhdi. Mu ma\"id ha udum hi mabalin an bumoddang i da'yu hi'on bokon nadan i'ibayu an tinanud Libay. ");
INSERT INTO ifa_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ot he\"ay ukod an mumpapto' hinan tabernakel ya nan punggobhan hi mi'nong ta wan adi da'yu dusaon an tinanud Israel i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Te ha\"on ya pinto\"u nadan i'ibayun tinanud Libay ta diday ay'u ligalu i da'yu. Dida ya niyappitda i ha\"on an Dios ta atonda nadan tamuh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mu he\"a ya nadan linala'in imbabalem ya abuh di mibilang hi padi an mabalin an mangat hinan tamuh nan punggobhan hi mi'nong ya hinan kuwartu' an Dios an nahawanan hi kultina. Ot hinaen nibilanganyuh padin munhilbi i ha\"on ya hiyay ay'u ligalu nimpe i da'yu. Ot kumpulnan tagun mangat hinan tamuyu ya mahapul an mipapate. ");
INSERT INTO ifa_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Alyon bon Apu Dios i Aaron di, Nomnomnomonyu an da'yuy nangiyukoda' hi an namin an iyalin nadan ibbayun tinanud Israel an idawatda i ha\"on. Ya he\"a ya nadan padi an imbabalem di pangidata'. ");
INSERT INTO ifa_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ot nan idawatdan bokon maghob an mi'nong ya midat i da'yu an umat hinan mi'nong hi apakawanan di bahul onu bahul an agge inatta ya nan midawat an alina te bagiyu. ");
INSERT INTO ifa_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ya hinan pangananyu i danae ya nomnomnomonyun niyappitda i ha\"on an Dios ot nadan linala'i ya abuh di mabalin an mi\"an. Ya mahapul an nomnomonda nimpen niyappit danae i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ya an namin nadan mabatih nadan i'nong nadan ibbayun tinanud Israel i ha\"on ya nadan nitaggen nidawat ya idat'un da'yu ta bingayyun namin an hina'amma. Ot an namin ayu an ta'on on nadan binabai ya mabalin an mi\"anda mu ta mibilangdah malinis. ");
INSERT INTO ifa_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ya idat'u bon da'yu nan ap'aphodan an idawat nadan tatagun ha\"on an umat hinan mantekan di olibo ya an namin nadan pinahapah an bayah ya nadan alina an danae nan hopap di inapitda. ");
INSERT INTO ifa_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ya an namin nadan hopap di bungan di nitanom an idawatdan ha\"on an Dios ya bagiyu. Ya an namin nadan mibilang hi malinis hinan nunhituwanyu ya mabalin an mi\"anda. ");
INSERT INTO ifa_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ta an namin nadan niyappit i ha\"on an Dios ya bagiyu. ");
INSERT INTO ifa_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ya ta'on on nadan panguluwan an linala'in imbabalen nadan ibbayun tinanud Israel onu nadan hopap di imbabalen di animal ya bagiyu. Mu mahapul an waday iyalidah ipi'nongda ta pamangngaddah nadan panguluwan an lala'in imbabaleda ya nadan hopap di imbabalen nadan animalda an mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ya nala\"uh'e ha himbulan an mihipun hi niyayyaman nan golang ya mahapul an iyalida nan pamangngadda i diyen golang an limay silber an miyunnudan hinan pungkiluh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mu nan mamangulun tangbal an imbabalen di kalnero ya baka ya gulding ya adi mabalin hi bayadanda ta bangngadonda te niyappitda mo tuwali i ha\"on. Ot mahapul an mi'nongdan ha\"on an Dios ta miwalaghi' di daladah nan punggobhan hi mi'nong ya ginhobda nan tabana ot umipa'amlong i ha\"on nan hunghungna. ");
INSERT INTO ifa_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ya nan lamoh diyen ni'nong ya bagiyu ta middum hinan palagpag ya nan winawwan an hukpit. ");
INSERT INTO ifa_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ya nadan niyappit i ha\"on an iyalin nadan ibbayun tinanud Israel an i'nongda i ha\"on ya idat'un he\"a Aaron ta bingayyun hina'amma. Ta hituwen imbaga' i da'yu ya minaynayun i da'yu ya nadan tanudanyu. ");
INSERT INTO ifa_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ot alyon bon Apu Dios i Aaron di, Da'yun padi ya ma\"id ha midat i da'yuh luta ya ma\"id ha odonyu te ha\"on an Dios di paddungnay midat i da'yu hi odonyu. ");
INSERT INTO ifa_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ya hay idat'uh nadan ibbayun tinanud Libay an gapuh nan punhilbiyandah nan tabernakel an pi'dammuwanyun ha\"on ya an namin nadan mi'apulu an ipabangngad nadan ibbayun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ot mihipun hi ad uwani ya mipagol hi umayan nadan bokon tinanud Libay hinan tabernakel. Te umeda'ehdi ya mumbahulda ot hidiyey lummuh atayanda. ");
INSERT INTO ifa_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Te ammuna nadan tinanud Libay an mabalin an muntamuh nan tabernakel. Ot hi'on waday adi maphod hi ma'at hidi ya diday ukod. Ot hituwen ma'unud ya munnananong hinadan mahohonnod an mun'atanudan. Ya hiyah diyen ma\"id ha mipaboltan i dida hi lutada. ");
INSERT INTO ifa_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ta hay paddungnay idat'un dida hi boltanonda ya nan mi'apulu an ipabangngad nadan ibbayun tinanud Israel i ha\"on. Ta hiya nan imbaga' an ma\"id ha midat i dida hi luta. ");
INSERT INTO ifa_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Ibagam hinadan ibbam an tinanud Libay ta alyom di, Inalayu'e nan mi'apuluh nan ipabangngad nadan ibbayun tinanud Israel i Apu Dios ya indawatyu nan mi'apulu i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ot hidiyen idawatyu ya paddungnay na'alah nadan ginapasyu onu nan danum di greyp. ");
INSERT INTO ifa_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ta hiya nan mahapul pibon aanonyu nan mi'apuluh (10) nadan na'amung an nidat i da'yu ya indawatyu i Apu Dios ta midat hinan padi an hi Aaron. ");
INSERT INTO ifa_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mu tigonyu ta nan ap'aphodan an nidat i da'yu di pot'onyuh ipabangngadyun Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ya ibagam boh nadan tinanud Libay an nan idawatdan ap'aphodan ya paddungnay nalpuh nan pun'ilikanda onu hinan pungkopalandah greyp. ");
INSERT INTO ifa_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ya nan mabati ya hidiyey anondan hina'amma te hidiye nan bino'ladan nuntamuh nan tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ot atonda'ehdi an idatda nan ap'aphodan hinan padi ta adida mumbahul ya aggeda binahbah nan niyappit i ha\"on an Dios an indawat nadan ibbayun tinanud Israel ta ma\"id ha lummuh atayanda. ");
INSERT INTO ifa_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Alyon bon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ibagayuh nadan tinanud Israel ta iyalidan da'yu ha mumbolah an baka an ma\"id ha bahbahna ya aggeyu ni' nun'aladuwon. ");
INSERT INTO ifa_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ya inyalida'e ya indatyuh nan padi an hi Eleasar ta ibata\"anah nan nun'allunganyu ya ahina impapalti mu mahapul an wahdi ta tigona. ");
INSERT INTO ifa_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ta napalti'e ya intamolnay gamatnah nan dala ya inwalaghi'nah mumpipitu hi nangappit hinan panton di tabernakel. ");
INSERT INTO ifa_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ya tinigona ta gobhondan naminamin an middum nan up'upna ya adolna ya dalana ya lugitna. ");
INSERT INTO ifa_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ya inalan nan padi ha naptung an sedar ya nan ma'alih haysop ya ha mumbolah an luput hi nadutdutan ya inibkahnah nan mun'aghob an baka. ");
INSERT INTO ifa_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ta nalpah'e ya ahi e mun'amoh nan padi ya inlaba'na nan inlubungna. Ya ahina mohpe imbangngad hinan nun'allunganda. Mu mibilang damdamah nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ya ta'on on nan tagun numpu'ul hinan baka ya mahapul an e mun'amoh ya inlaba'na nan inlubungna. Mu athidi bon mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ya hay e mangalah nan gubun nan naghob an baka ya nan tagun mibilang hi malinis ta inalana'e ya ena inha\"ad hinan mibilang hi malinis an nibata\"an hinan nun'allunganda. Ta hidiyey iddum nadan tinanud Israel hinan liting an pun'ulahdah nan nibilang hi nalugit ta mibilang hi malinis. Ta hiyah diyey nibaga hi atonda ta wan linglingon Apu Dios nan numbahulanda. ");
INSERT INTO ifa_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ya nan tagun e nun'amung hinan gubun nan naghob an baka ya mahapul an ena ilaba' nan lubungna mu mibilang damdamah nalugit ta ingganah mahdom. Ot hituwen imbaga' hi atonyu ya hiyay minaynayun hi unudonyun tinanud Israel an ta'on on nadan ni'iboblen da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","An namin nadan nanapa i ha nateh tagu ya mibilangdah nalugit hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ot mahapul an hay usalona ya nan liting an punlinis hinan mi'atluh algo ya nan mi'apituh algo ya ahi mibilang hi malinis. Mu adina'e unudon hidiye ya adi mibilang hi malinis. ");
INSERT INTO ifa_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ot nan tagun waday nida\"omanah naten tagu mu aggena inunud nan nibagan atona ta mibilang hi malinis ya hiyay bumahbah hinan tabernakel. Ot mahapul an mipapate ta adi midmiddum i da'yun tinanud Israel te agge niwalaghi' i hiya nan liting an punlinis ta hiya nan nibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ya hi'on waha nateh nan nun'allunganyu ya an namin nadan naha'mut hidi ya nan hunggop hidi ya mibilangdah nalugit hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ya an namin nadan usal an wadahdi an umat hi banga ya pannuman an agge nakaluban ya mibilangdah nalugit. ");
INSERT INTO ifa_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ya onha bo waha taguh pinatedah nan dola onu ha namaaggot mate ya an namin nadan manapa ya mibilangdah nalugit. Ya ta'on on nan mida\"om hinan tungal di tagu onu ha lubu' ya mibilang hi nalugit hi pituy algo. ");
INSERT INTO ifa_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Ot hay aton nadan nibilang hi nalugit ya alanda dohah nan gubun di naghob an baka ya inha\"adda i ha pannuman ya kinuyagandah liting. ");
INSERT INTO ifa_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ya nan tagun mibilang hi malinis ya alana dohah nan ma'alih haysop ya intamolna i diyen liting. Ya nun'iwalaghi'nah nan allung ya an namin nadan gina'uhdi ya nadan tatagun wahdi. Ya athidi boy atonah nan tagun nida\"om hinan ba'ag onu nan lubu' onu nan nate an gapuh dogoh onu nan pinateda. ");
INSERT INTO ifa_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ta nan tagun mibilang hi malinis ya hiyay mabalin hi munwalaghi' hinan tagun mibilang hi nalugit hinan mi'atluh algo ya hinan mi'apituh algo. Ot hinan mi'apituh algo ya nan tagun mumpalinis ya mahapul an ena ilaba' nan lubungna ya nun'amoh ta i diyen mahdom ya mibilang moh malinis. ");
INSERT INTO ifa_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mu hi'on nan tagun mibilang hi nalugit ya attaonan adi aton nan nibaga an atona ta mibilang hi malinis ya mipapate ta adi midmiddum i da'yuh nan numboblayanyu. Te ni'inlulugitna nan tabernakel. Ot gapu ta agge nawalaghi'an hinan liting an punlinis ya nanongnan mibilang hi nalugit. ");
INSERT INTO ifa_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ot hituwen tugun'u ya mahapul an ma'unud hi inggana. Ta nan tagun mangiwalaghi' hinan liting hinadan nibilang hi nalugit ya mahapul bon ilaba'na nan lubungna. Ya nan tagun nanapah nan liting ya mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ya kumpulnay ida\"oman nan tagun nibilang hi nalugit ya mibilang hi nalugit ta ingganah mahdom. ");
INSERT INTO ifa_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hidin namangulun bulan ya dimmatong nadan tinanud Israel hinan agge naboblayan hi ad Sin ot mun'allungdahdih ad Kades. Ya hidiy natayan Miriam ot hidiy ilubu'ana. ");
INSERT INTO ifa_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ya ma''id ha liting hidi ta ahililili nadan tatagu i da Moses i Aaron ");
INSERT INTO ifa_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","an alyonday, Udu'dulna boy ni'yate amih nadan i'iba ta'un numpaten Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Tanganu on athi'athitu an undan in'uyug da'mih tun agge naboblayan ta hituy atayanmin namin ya ta'on on tudan animalmi? ");
INSERT INTO ifa_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Tanganu on da'mi e inikak hi ad Egypt ta e da'mi inyali i ha athituh luta hi adi tummol di nitanom? Ya daan ihyahtu nan boga ya fig ya greyp onu pomegranet? Ya ma\"id bo udot ha liting hi inumon. ");
INSERT INTO ifa_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mu da Moses i Aaron ya namaaggot umedah nan panton nan tabernakel ot munlu'bubda. Ya nipatigo bon dida nan binang Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Em alan nan hu''ud hinan way Kahun an nittuwan nan Hapit'un Dios ya inamungyu i Aaron nadan tatagu. Ta na'amungda'e ya himmapit'ah nan doplah ot bumudduh di liting ta inumonyun namin an ta'on on nadan animalyu. ");
INSERT INTO ifa_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ot e alan Moses nan hu''ud an inunudna nan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ot ahida umen duwa i Aaron ot eda amungon nadan tataguh nan way doplah. Ot alyon Moses i diday, Da'yun mumpungngohe, undan mahapul an pawadaonmiy liting hitun doplah ta inumonyu? ");
INSERT INTO ifa_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ot inayun Moses an itagge nan hu''ud ot ipidwanan idoltak hinan doplah ya mun'ungak di liting an manawang ta imminum nadan tatagu ya nadan animalda. ");
INSERT INTO ifa_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mu inhingal Apu Dios da Moses i Aaron an alyonay, Gapu ta aggeya' inunud i da'yu an aggeya' impabaktu ya bokon mo da'yuy mangidatong hinadan tataguh nan boblen alyo' hi idat'u i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Hay na'atan nae ya hi ad Meribah te hidiy nunliliyan nadan tatagu i Apu Dios ot hidiy nangipa'innilaan mo bon Apu Dios an hiya ya nahamad di a'atna. ");
INSERT INTO ifa_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Hidin awadan nadan tatagu hi ad Kades ya wadaday hinnag Moses ta immedah nan patul hi ad Edom. Ot alyondah nan patul di, Da'mi nadan tinanud Israel an nitulang i da'yu. Ot innilamin dingngolmu nadan numpalpaligatanmi. ");
INSERT INTO ifa_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Te hidin immayan didan a'ammodmih ad Egypt ya innayundan ni'hituhdi. Mu hidin immey atnay tawon ya nunhiglay pangpangat nadan i Egypt hinadan a'ammodmi ya ta'on on da'mi. ");
INSERT INTO ifa_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ot mumpahpahmo' ami i Apu Dios ya dingngolna ot honagona han anghel ta hiyay nangipangulun da'mih nihipun hi nakakanmih ad Egypt. Ot ten ad uwani ya wada ami hi ad Kades an pogpog tun numboblayanyu. ");
INSERT INTO ifa_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ot daan mo bahan ta iyabulutmu ta i'wamih tun bobleyu ot halipodpodonmi ta nan kalata ya ammunay pangi'wanmi an bokon hinan nuntanomanyuh makan onu hinadan nuntanomanyuh greyp. Ya adi ami bo uminum hinadan obobyu ta ingganah onmi la''uhan tun bobleyu. ");
INSERT INTO ifa_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mu alyon diyen patul di, Adiyu goton an i'wah tun boblemi te atonyu'e ya i'uyug'u tudan titindalu' ta gubaton da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ya alyon nadan tinanud Israel di, Tanganu bahan ya ten alyonmiy nan kalata ya ammunay awonmi ya alina'e hi waday inumon nadan animalmi onu da'mi hinan litingyu ya bayadanmi mu ta iyabulutmu bahan ta i'wamih bobleyu. ");
INSERT INTO ifa_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mu hiyah diyen adi iyabulut nan patul an onaot pun'ayagan nadan dakol an tindaluna ta eda gubaton nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ya gapu ta adina iyabulut an i'wan nadan tinanud Israel hi ad Edom ya inhunodda mo ta nat'on di inwada. ");
INSERT INTO ifa_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ot taynan mon nadan tinanud Israel hi ad Kades ot umedah nan billid an nungngadan hi Hor ");
INSERT INTO ifa_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","an nihaggon hinan da'ging di ad Edom. Ya alyon Apu Dios i da Moses i Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Hi Aaron ya adi mi'datong hinan boblen alyo' hi idat'u i da'yun tinanud Israel te mate an gapu ta nun'optonyun duwa an aggeyu inunud nan imbaga' hi atonyuh din awadanyuh ad Meribah. ");
INSERT INTO ifa_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ot inayunan alyon i Moses di, Awitom hi Aaron ya nan imbabalenan hi Eleasar ya tinikidyu tun billid. ");
INSERT INTO ifa_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ta dimmatong ayu'ehdi ya inaanmu nan inlubung Aaron an lubung di padi ya impilubungmu i Eleasar te hidiy atayan Aaron. ");
INSERT INTO ifa_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ta hi Moses ya inunudna nan imbagan Apu Dios ta tinigon nadan tataguh immayandah nan billid an nungngadan hi Hor. ");
INSERT INTO ifa_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ta onda immehdi ot aanon Moses nan lubung di padi an inlubung Aaron ot ipilubungna i Eleasar ot matehdih nan uhhun nan billid ta ammuna da Moses i Eleasar an dimmayyu. ");
INSERT INTO ifa_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ya hidin na'innilaan nadan tataguy natayan Aaron ot umukayungandah tulumpuluy (30) algo. ");
INSERT INTO ifa_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Nan patul hinan bobleh ad Arad an nunhituh nan negeb ya dingngolnan tuwe nadan tinanud Israel an ini'wadah ad Atarim. Ta hay inatdah nadan tindaluna ya eda binta' dida ot tiliwonday udum i dida. ");
INSERT INTO ifa_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ta nadan tinanud Israel ya insapatadan Apu Dios an alyonday, Hi'on ipa'abakmun da'mi datuwen tatagu ya dadagonmi didan namin ya ta'on on nan numboblayanda ta ma\"id ha batiyonmi. ");
INSERT INTO ifa_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ya dingngol Apu Dios hidiyen dasalda ta impa'abakna i dida nadan i Kanaan. Ot ipa'annungdan e dinadag didan namin ya nan numboblayanda. Ot ngadanandah diyen boble hi ad Hormah. ");
INSERT INTO ifa_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hidin nakak nadan tinanud Israel hinan billid an nungngadan hi Hor ya inipluydah nan mumbolah an baybay ot iligligdah ad Edom. Mu hidin wadadah nan awon ya na'aan di anus nadan tatagu ");
INSERT INTO ifa_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ta ahilililida bo i Apu Dios ya hi Moses an alyonday, Tanganu on da'mi e inikak hi ad Egypt ta e da'mi patayon hitun agge naboblayan an ma''id ha liting ya immengle ami moh tun himpappangen makan. ");
INSERT INTO ifa_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ta hay inat Apu Dios ya impa'alinay ulog hi awadan nadan tatagu ta dakolday nun'a'aten didah nan kinalat dadiyen ulog. ");
INSERT INTO ifa_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ta imme nadan tatagu i Moses ot alyondan hiyay, Abulutonmin numbahul ami an gapuh nadan adi maphod an hinapitmi i Apu Dios ya i he''a ot mundasal'a bahan ta wan aanon Apu Dios datuwen ulog. Ot hiyay aton Moses. ");
INSERT INTO ifa_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ot alyon Apu Dios i hiya ta iphodna ha ay ulog ya impa'ona ta na'en mangitangad i diyen nipa'o an ay ulog ya pumhod an adi mate. ");
INSERT INTO ifa_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ot apyon mon Moses nan gombang hi ay ulog ot ipa'ona ta wada'ey kinalat di ulog ta intangadna i diyen nipa'o an ay ulog on pinumhod an adi nate. ");
INSERT INTO ifa_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Indani ya nakakda bo nadan tinanud Israel ot ipluydah ad Obot ot mun'allungdahdi. ");
INSERT INTO ifa_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ot ahida bo ipluy hi ad Iye-Abarim ta hidih nan agge naboblayan an nidommang hi ad Moab di nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ot ahida bo makak ot ipluydah nan nundotal an nihaggon hinan wa\"el an nungngadan hi Sered ta hidiy nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ot ipluyda boh nan agge naboblayan ot eda mun'allung hinan agge naboblayan an nihaggon hinan wangwang an nungngadan hi Arnon an nihaggon hinan boblen nadan i Moab. Nan wangwang an nungngadan hi Arnon ya hidiyey numbattanan nan boblen nadan i Moab ya nan boblen di tinanud Amor. ");
INSERT INTO ifa_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ta hiya nan hinan Liblun Ni'gubagubatan Nan Ap'apu ya nangadanan hidiyen boble hi ad Waheb hinan probinsya hi ad Supa ya nan wangwang an nungngadan hi Arnon ");
INSERT INTO ifa_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ya nadan bihhang an nihaggon hi ad Ar an nihaggon hinan pogpog nan bobleh ad Moab. ");
INSERT INTO ifa_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ta nadan tinanud Israel ya nakakda ot ipluydah ad Beer an awadan han bubun. Ta hidiy nangibagaan Apu Dios i Moses an alyonay, Amungom nadan tatagu ta idat'uy liting hi inumonda. ");
INSERT INTO ifa_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ya hidi boy nangikantaan nadan tinanud Israel hinan kanta an alyonay, He\"an bubun ya ipahawwangmuy liting ta way atonmin mangikankantah ");
INSERT INTO ifa_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","nan a'atmu an bubun an kina\"utan di a'ap'apu an nangipangpanguluh tatagu. An hay nanudduda hi'on idanay pungka\"utanda ya nan hu\"udda. Indani ya taynan dadiyen tinanud Israel hidiyen agge naboblayan ot ipluydah ad Mattanah ");
INSERT INTO ifa_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ot ahida ipluy boh ad Nahaliel ot ahi hi ad Bamot. ");
INSERT INTO ifa_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Ot ahida mohpe ipluy hinan nundotal hi ad Moab an pu\"un nan billid an nungngadan hi Pisgah. Ya hidih nan uhhun nan billid ya ma'uhdungan nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hidin awadan nadan tinanud Israel hi ad Moab ya hinnagday e mi'hapit hinan patul di tinanud Amor an hi Sihon. ");
INSERT INTO ifa_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ta immeda ot alyondan hiyay, Apu patul, iyabulutmu bahan ta i'wamih tun bobleyu. Ot ibagamin he\"a tee an da'mi ya nadan animalmi ya adimi ihinghingngih nan nuntanomyuh makan onu hinan nuntanomanyuh greyp. Ya ta'on on nan liting hitun bobleyu ya adi ami uminum ta nan awon di pangi'wanmi ta ingganah onmi la\"uhan tun bobleyu. ");
INSERT INTO ifa_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mu adi iyabulut Sihon an i'wan nadan tinanud Israel hinan bobleda. Ya onaot in'uyug an namin nadan tindaluna ta eda gubaton nadan tinanud Israel hi ad Jahas. ");
INSERT INTO ifa_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mu numpaten nadan tinanud Israel dida ot diday mihukkat hinan numboblayanda an nihipun hinan wangwang an nungngadan hi Arnon ta ingganah nan wangwang an nungngadan hi Jabbok an nihaggon hinan boblen nadan tinanud Ammon mu aggeda immehdi te na'alad hi binattu. ");
INSERT INTO ifa_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ta nadan tinanud Israel ya inabakdan namin nadan boblen di tinanud Amor an ta'on on hi ad Hesbon ya an namin nadan kikkitang an bobleh nunlini\"odan di ad Hesbon ot diday mihukkat. ");
INSERT INTO ifa_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Nan bobleh ad Hesbon ya nunhituwan nan patul nadan tinanud Amor an hi Sihon. Hidiyen boble ya ibban nadan bobleh ad Moab ta ingganah nan wangwang an nungngadan hi Arnon an sinakup Sihon hidin inabakna nan patul hi ad Moab. ");
INSERT INTO ifa_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ta hiya nan wada nan intudo' nadan nun'ala'ing an alyonday, Umali ayuh ad Hesbon ta wan miphod hituwen boblen Sihon ta mumbangngad din a'atnah hopapna. ");
INSERT INTO ifa_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Te handi ya ad Hesbon di nalpuwan nadan ay apuy an titindalun e nanadag hi ad Ar an bobleh ad Moab ya ta'on on nadan numpunhituhdi ya nadan ap'apuda. ");
INSERT INTO ifa_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ot da'yun i Moab ya mahmo' ayu. Te da'yun mundayaw i Kemos ya nadadag ayu mo. Ta nan diosyun hi Kemos ya ingnganuy da'yun mibilang hi imbabalena ta numbalin ayu moh balud nan patul di tinanud Amor an hi Sihon. ");
INSERT INTO ifa_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mu ad uwani ya dinadagmi didan namin an nihipun hi ad Hesbon ta ingganah ad Dihon. Ta ma\"id ha ohah nabati i dida ta ingganah ad Nopa ya ad Medeba. ");
INSERT INTO ifa_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ta nadan tinanud Israel ya dida moy nihukkat an nunhitu hinan boblen di tinanud Amor. ");
INSERT INTO ifa_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ya hinnag Moses di e manigoh a'at nan boble hi ad Jaser. Ta sinakupdan namin nadan boblehdi ot ipa'aandahdi nadan tinanud Amor an inakhupandahdi. ");
INSERT INTO ifa_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ot ipluyda boh ad Basan mu nan patul hidin hi Og ya nadan tataguna ya eda ginubat didah ad Edrey. ");
INSERT INTO ifa_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ot alyon Apu Dios i Moses di, Adi ayu tumakut i Og te abakonyu dida ya an namin nadan tataguna ya nadan numpumboblayanda. Ot nan inatyuh nan patul hi ad Hesbon an hi Sihon an tinanud Amor ya athidi boy atonyu i Og. ");
INSERT INTO ifa_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ta athidiy na'at an nadan tinanud Israel ya sinakupdah diyen boble te pinatedah Og ya nadan linala'in imbabalena ya an namin nadan tindaluna ta ma\"id ha nabatih nadan tatagu i diyen boble. ");
INSERT INTO ifa_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nadan tinanud Israel ya innayundan mangmangnge ta ingganaot dumatongdah nan nundotal hi ad Moab an dommang di ad Jeriko an numbattananda nan wangwang an nungngadan hi Jordan ot mun'allungda bohdi. ");
INSERT INTO ifa_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ya hidin dingngol nan patul hi ad Moab an hi Balak an imbabalen Sippor di nangabakan nadan tinanud Israel hinadan tinanud Amor ");
INSERT INTO ifa_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ya nunhiglay timmakutandah nadan tataguna te dakkodakkol nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ot eda mi'hapit hinadan ap'apu hi ad Midian an alyonday, Tuweda man han dakkodakkol an tatagu ot undan ihya adi madne ya numbahbahdan namin tun nunlini''odan an numboblayan ta'u ta umat hi pangan di bakah nan holo' di atonda. ");
INSERT INTO ifa_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ot honagon mon Balak di e mangawit i Balaam an hi na' Beor hi ad Petor an nihaggon hinan wangwang an nungngadan hi Euprates hi ad Amaw. Ta hay imbagan Balak hi ibagada i Balaam ya alyonay, Umman tuweda tayyay dakkodakkol an tatagun nalpuh ad Egypt an mun'ihinapda hi abobboble ya ten wadada moh dommang tun boblemi. ");
INSERT INTO ifa_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ya ongal di abalinanda mu da'mi. Ta hiya nan umali'a bahan ta idutam dida ta alina ya abakonmi dida ta bumtikda. Te innila' an nadan tatagun wagaham ya umannung an maphod di ma'at i dida mu nada'en idutam ya atbohdin umannung an ma'at. ");
INSERT INTO ifa_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ta inalan nadan ap'apuh ad Moab ya hi ad Midian nan pumbayadda i Balaam hi pun'idutanah nadan tinanud Israel ot eda mi'hapit i hiya. ");
INSERT INTO ifa_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ya alyon Balaam di, Mun'iyan ayu ni' ta nangamung di ipa'innilan Apu Dios i ha''on ya imbaga' i da'yu hi bigat. Ot umiyanda mo nadan hinnag Balak. ");
INSERT INTO ifa_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ya i diyen nahdom ya alyon Apu Dios i Balaam di, Nganne danaen tatagun nun'ibbam? ");
INSERT INTO ifa_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ya alyon Balaam di, Datuwe nadan hinnag nan patul hi ad Moab an hi Balak ");
INSERT INTO ifa_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","te dayyada anuhdiy dakkodakkol an tatagun nalpuh ad Egypt an mun'ihinapdah abobboble ya pinhodnan e' idutan dida ta mabalin an gubatonda dida ta way atondan bumtik. ");
INSERT INTO ifa_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ya alyon Apu Dios i Balaam di, Adi'a mi'ye i dida ta adim e idutan nadan tinanud Israel te winagaha' dida. ");
INSERT INTO ifa_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ta hidin nawi\"it ot alyon mon Balaam hinadan ap'apu di, Umanamut ayuot te adi tee iyabulut Apu Dios an mi'yaliya' i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ot mumbangngadda mo dadiyen ap'apu ot ibagadan Balak an agge ni'yeh Balaam i dida. ");
INSERT INTO ifa_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Mu hi Balak ya adi mangmanghop ot honagona boy udum an ap'apu an indakdakolda ya nabakbaktuy sa'adda mu nadan namangulun hinnagna. ");
INSERT INTO ifa_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ta immeda ot alyondan Balaam di, Adim anu ibahhon mi'yali i da'mi ");
INSERT INTO ifa_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ot ongal di idat nan patulmi hi gunggunam ya kumpulnan ibagam ya atona mu ta wan mi'yali'a ta idutam dadiyen tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mu alyon Balaam di, Ta'on on idat Balak nan palasyuna an napnuh balitu' ya silber ya adi mabalin hi ibahho' nan imbagan Apu Dios i ha''on an ta'on on ha mabgawan. ");
INSERT INTO ifa_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mu ta'on hi athinay imbaga' ya umiyan ayuot ni' ta umat hidin inat nadan namangulun hinnagna ta alina hi waday udum hi ipa'innilan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ya hidin nahdom ya alyon Apu Dios i Balaam di, On'e immali danaen linala'in mangawit i he''a ya ta'on ya ni'ye'a mu mahapul an ammuna nan ibaga' hi atom. ");
INSERT INTO ifa_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ta nawi\"it mo ot e idadaan Balaam nan dongki an itakkayana ot mi'yeh nadan ap'apun i Moab. ");
INSERT INTO ifa_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mu bimmungot hi Apu Dios hi pi'yayan Balaam ta hidin nitakkeh nan dongki an nun'ibbana nadan duwan baalna ot e mihawan nan anghel Apu Dios hinan pangi'wana. ");
INSERT INTO ifa_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ya hidin tinigon nan dongki nan anghel Apu Dios an timma'dog hinan kalata an pingngolnay ispadana ya inhingngin nan dongki hinan natanoman hi greyp. Ot punhuplit Balaam ta wan ibangngadnah nan kalata. ");
INSERT INTO ifa_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ot e bo mihawan nan anghel hinan nakuhhipit an awon an numbattanan di duwan natanoman hi greyp an na'alad di numbinahhel. ");
INSERT INTO ifa_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ya hidin tinigon bon nan dongkih diyen anghel ot pun'ihunodna ta nidalit di hukin Balaam hinan alad. Ot punhuplit bon Balaam nan dongki. ");
INSERT INTO ifa_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ot mamangulun ume nan anghel ta nipto' i han na'akkuhhipit an ma\"id ha pangikiwwangan ot tuma'dog hidi. ");
INSERT INTO ifa_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ta hidin dimmatong hi Balaam hidi ya namaaggot umbun nan dongki yaden nunnanong an nitakkeh Balaam. Ya nunhiglay bungotna ot punhuplitnah nan hu\"udna. ");
INSERT INTO ifa_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ya lo'tat ya impahapit Apu Dios nan dongki ot alyonan Balaam di, Undan nganne attog di bahul'un he\"a ta namaag ya numpitlu moy nanuplitam i ha\"on? ");
INSERT INTO ifa_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ya alyon Balaam di, Te tanganu ona' numbalinon i he\"ah paddungnay ma\"id ha nomnomna. Onha waday inodna' hi matadom ot patayon da'ah ad uwani. ");
INSERT INTO ifa_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ya alyon bon nan dongki di, Apu Balaam, ha\"on nan imminghah itakkayam hi'on waday umayam. Ot undan waha athituh inat'u i he\"a handi? Ya alyon Balaam di, Manu te ma\"id. ");
INSERT INTO ifa_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ya indat mohpen Apu Dios di abalinan Balaam an mangimatun hinan anghel an timma'dog hinan awon an intaggena nan pingngolnan ispadana. Ot mundu\"un hi Balaam an nida\"om di angahnah nan luta. ");
INSERT INTO ifa_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ya alyon nan anghel i hiyay, Tanganu onmu pinitlun hinuplit tun dongki? Manu'eh immaliya' ya ta hawanan da'a te mipagol di umayam mu ipapilitmu. ");
INSERT INTO ifa_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Manu nan dongki te tinigowa' ta hiya nan numpitlun inhunodna. Ya onha aggena inhunod ta impilitnan imme ot wan pinate da'an ha\"on ya imbati' nan dongki. ");
INSERT INTO ifa_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ya alyon Balaam hinan anghel di, Abuluto' an numbahula'. Mu agge' attog innilan hinawanam nan awon. Ot adim'e pohdon an umeya' ya numbangngada' attog hi ad uwani. ");
INSERT INTO ifa_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mu alyon nan anghel di, Ta'omman ya ekat mi'ye'a mu ta ammuna nan ibaga' hi atom. Ot mi'ye moh Balaam hinadan ap'apun hinnag Balak. ");
INSERT INTO ifa_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Hidin dingngol Balak an tuweda Balaam ot mangen ena damuwon didah ad Ar an nihaggon hinan wangwang an nungngadan hi Arnon an pogpog nan bobleh ad Moab. ");
INSERT INTO ifa_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ta nundammuda ot alyon Balak i hiyay, Tanganu on'a agge ni'yalih din namangulun hinnag'u? Wan alyom on adi' abalinan an idat nan gunggunam. ");
INSERT INTO ifa_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ya alyon Balaam di, Ta'on hi immaliya' hi ad uwani mu nomnomnomom an adi kumpulnay hapito' te ammuna nan ibagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ot mi'uyug hi Balaam i Balak ta immedah ad Kiriat-Husot. ");
INSERT INTO ifa_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ot i'nong Balak hidi nadan baka ya kalnero ot pahinganah Balaam ya nadan ap'apun nun'ibbana. ");
INSERT INTO ifa_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ya i diyen nawi\"it ot uyugon bon Balak hi Balaam ot tikidondah ad Bamot-Baal ta mabalin an uhdunganday udum hinadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Alyon Balaam i Balak di, Ipiyammam hitu ha pituy punggobhan hi mi'nong ya indadaanmuy pitun bulug an baka ya pituy tangbal an kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ot hiyay aton Balak ta didan duwa ot i'nongday ohan bulug an baka ya ohan tangbal an kalnero hinan ohan punggobhan hi mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ot alyon Balaam i Balak di, Umohnong'ah tun way ni'nong ta mibata\"ana' ni' ta alinah waday ibagan Apu Dios i ha\"on. Ta wada'e ya impa'innila' i he\"a. ");
INSERT INTO ifa_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ya hidin immehdi ya immannung an nidamuh Apu Dios i hiya. Ot alyon Balaam i hiyay, Apu Dios, impiyamma' di pitun punggobhan hi mi'nong ot ipong'un i'nong di hinohhan bulug an baka ya kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ot ibagan Apu Dios i Balaam di ibagana i Balak an alyonay, Ibangngadmuh awadan Balak ya imbagam hinaen hiya. ");
INSERT INTO ifa_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ta hidin numbangngad hi Balaam ya wahdih Balak ya nadan nun'ibbanan ap'apun munhilbin hiya an tumtumma'dogdah nan haggon nan ini'nongna. ");
INSERT INTO ifa_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ot alyon Balaam di, He\"a an patul hi ad Moab an hi Balak ya impa'awita' hinan nunhituwa' hi ad Syria hidih nan billid an nangappit hi tuluwan di algo an alyom di umaliya' ta iduta' nadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mu adi mabalin hi iduta' nadan tatagun agge inidutan Apu Dios ya atbohdin adi mabalin an pihulo' nadan agge pinihul Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ya hitun immohnonga' an doplah ya mamangmang dadiyen himpamoble an tatagu. Ya inniladan diday nahamad hi nawagahan mu nadan udum an tataguh tun luta. ");
INSERT INTO ifa_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ya didan tinanud Israel ya ayda hupu' an adida mabilang. Ta hay pohdo' ya umata' i didan tatagun Apu Dios ta ma''id ha al'ali hi ingganah ataya' an umat i didan ibilang Apu Dios hi maphod di pangatda. ");
INSERT INTO ifa_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Hidin imbagan Balaam hidiye ya alyon Balak di, Tanganu on waha athinah inatmun ha''on an on'u alyon hi idutam nadan binuhul'u ya onnot on hay punwagahmun diday ibagbagam ya ammuna. ");
INSERT INTO ifa_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ya alyon Balaam di, O te hay ibaga' ya ammuna nan ibagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ot alyon Balak i Balaam di, Mitnud'an ha\"on ta umetah nan hay mamangmang ya ammuna ha oh'ohha i dida an bokon an naminda. Ta hidiy pangidutam i dida. ");
INSERT INTO ifa_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ot iyenah Balaam hinan nundotal hi ad Sopim an uhhun nan billid an nungngadan hi Pisga. Ta onda dimmatong hidi ot ipiyamman Balak di pitu bon punggobhan hi mi'nong. Ot ipongna bon i'nong di hinohhan bulug an baka ya tangbal an kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ya alyon bon Balaam di, Iyadugmu tun impi'nongmu ta eya' mi'dammun Apu Dios hi e\"elena. ");
INSERT INTO ifa_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ta hidin nibata\"an ya ni'dammu boh Apu Dios i hiya ot ipa'innilanay ibagan Balaam i Balak. Ot ahina alyon di, Ibangngadmuh awadan Balak ya imbagam nan impa'innila' i he\"a. ");
INSERT INTO ifa_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ta hidin numbangngad hinan way punggobhan hi mi'nong ya nanongnan wahdih Balak an tumtumma'dogdah nadan ap'apun munhilbin hiyah ad Moab. Ya alyon Balak di, Nganney imbagan Apu Dios? ");
INSERT INTO ifa_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ya pun'ibagan Balaam an alyonay, Donglom Balak an imbabalen Sippor tun ibaga'. ");
INSERT INTO ifa_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Hi Apu Dios ya adi umat hi tagu an mabalin an munlayah. Ya adi munlinumman di nomnomna an adi umat hi tagu. Ya an namin di ibagana ya ipa'annungna. ");
INSERT INTO ifa_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ya nomnomnomom an hay immandalnan ha\"on ya wagaha' nadan tatagun winagahana tuwali ot adi mabalin hi baliwa'. ");
INSERT INTO ifa_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ot dadiyen tinanud Israel ya ma\"id ha adi maphod hi ma'at i dida an umat hi nunhiglan punligatan. Te na'innilan hi Apu Dios di patulda an dayawonda. ");
INSERT INTO ifa_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ya hiyay nangikak i didah ad Egypt an gapuh nan ongal an abalinana. ");
INSERT INTO ifa_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ot wada'ey mun'ayak hinadan tinanud Israel ya adi ma'at. Ta ad uwani ya hay ibagan di tatagu ya alyonday, Tigonyuy inat Apu Dios hinadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Te dida ya ayda layon an adi duminong ta ingganah ona patayon nan mabalin hi anona ya ininumnay dalana. ");
INSERT INTO ifa_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ya hidin indappuhna ya alyon Balak di, Adim'e idutan dida ya ta'ombo mu ta adim bo wagahan dida. ");
INSERT INTO ifa_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ya alyon Balaam di, Undan tuwali agge' pinadanan i he\"a an hay mabalin hi hapito' ya ammuna ya nan ibagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ya alyon bon Balak i Balaam di, Mi'yali'a ta umeta boh ohan lugal. Ta alinah hidi'e ya iyabulut Apu Dios an idutam dadiyen tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ot uyugon bon Balak hi Balaam ot iyenah nan uhhun nan billid an nungngadan hi Peor an mamangmang nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ya hiyah diyen alyon Balaam i hiyay, Ipiyammam boy pitun punggobhan hi mi'nong ya indadaanmu boy pitun bulug an baka ya pitun tangbal an kalnero ta mi'nong hidi. ");
INSERT INTO ifa_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ot hiya mo boy aton Balak ta on niyamma ot opngondan i'nong i dadiyey hinohhan bulug an baka ya kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Hidin innilan mon Balaam an hay pinhod Apu Dios ya wagahana nadan tinanud Israel ya aggena mo minahmahan hi'on mabalin an idutana dida an umat hinan inatna ni'. Ta namaaggot ihangngutnah nan agge naboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ya hidin minangmangna nan nun'allungan nadan himpahimpamu'un an tinanud Israel ya niddum i hiya nan Espiritun Apu Dios ");
INSERT INTO ifa_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ta alyonay, Ha\"on an hi Balaam an imbabalen Beor ya immannung tun ibaga'. ");
INSERT INTO ifa_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Hidin nunlu'buba' ya waday dingngol'u an imbagan nan ongal di abalinanan Dios i ha\"on. Ya wada boy impatigonan ha\"on an ta'on on aggeya' nalo'. ");
INSERT INTO ifa_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Te impatigonan ha\"on nadan mapmaphod an nun'allungan nadan tinanud Jacob an nungngadan boh Israel. ");
INSERT INTO ifa_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ya hay pummangmang'u i dida ya umatdah nan damunan puntanoman an nihaggon i ha wangwang. Ya umatda boh nadan mumpabangluh makan an intanom Apu Dios. Ya umatda boh nadan kayiw an sedar hinan haggon di liting. ");
INSERT INTO ifa_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ot adida makulangan hi mahapulda te nanongnan madanuman di intanomda. Ya nan patulda ya ongal di abalinana mu hi Agag te mapemanan di pun'ap'apuwana. ");
INSERT INTO ifa_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ya hi Apu Dios di nangikak i didah ad Egypt. Ya ongal di abalinanda an umat hinan bikah di atap an bulug an baka. Ta an namin nadan tataguh abobboble an mi'buhul i dida ya pundadagda an pumpanada dida ya nunggududay tungalda. ");
INSERT INTO ifa_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ta umatdah nan layon an nalo\"e ya ma\"id ha natulid hi e mamangon i hiya. Ot hanat an namin nadan munwagah i dida ya mawagahanda bo damdama. Ya nadan mun'idut i dida ya mipabangngad i dida nan idutda. ");
INSERT INTO ifa_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ya nangimbubbungot hi Balak i Balaam. Ta nanginggagamal hi ta'lenah bungotna ot alyonay, Inayagan da'a ta idutam dadiyen binuhul'u mu onmuot bo winagahan didah numpitlu. ");
INSERT INTO ifa_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Makak'aot ta umanamut'a. Manu te imbaga' an idat'u nan gunggunam mu ma\"id te agge inyabulut Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ya alyon Balaam di, Pinadana' attog an imbagah nadan hinnagmu an alyo' di, ");
INSERT INTO ifa_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ta'on hi alinah alyom an patul di idatmu nan palasyum an napnuh balitu' ya silber ya adi mabalin hi ato' nan pohdo'. Te ammuna nan ibagan Apu Dios hi ibaga'. ");
INSERT INTO ifa_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ya innayuna bon alyon di, O, mumbangngada' hi boblemih ad uwani mu ta ahiya' ume ya donglom ta ipa'innila' nan aton danaen tinanud Israel hinan tatagum hi udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ot alyon Balaam boy, Ha\"on an hi Balaam an imbabalen Beor ya immannung tun ibaga' ");
INSERT INTO ifa_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","te ha\"on ya dongdonglo' nan ibagan Apu Dios ya innila' di a'atna an hiya nan na'abbaktu an Dios. Ya hidin nunlu'buba' ya waday impatigon nan ongal di abalinana i ha\"on. ");
INSERT INTO ifa_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ya hay nipatigon ha\"on ya agge ni' na'at. Mu udum hi algo ya humawwang han ay bittuwon an holag Jacob ta mumpatul hinadan ibbanan tinanud Israel. Ta dadagon da'yun i Moab an tinanud Set. ");
INSERT INTO ifa_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Mu nadan tinanud Israel ya mawaday ongal an abalinanda ta abakonda nadan binuhuldan i Edom ya sinakupday bobleda. ");
INSERT INTO ifa_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Te hidiyen patul nadan tinanud Israel ya dadagona bon namin nadan numboblehdi. ");
INSERT INTO ifa_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ya nipatigo bon Balaam di ma'at hinadan tinanud Amalek ot alyonay, Ta'on on ongal di abalinan nadan tinanud Amalek hi ad uwani mu lo'tat ya madadagdah udum hi algo. ");
INSERT INTO ifa_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ya tinigona boy ma'at hinadan tinanud Ken ot alyonay, Nadan tinanud Ken ya nun'ahamad nan numboblayanda an umat hinan balen di hamutih nan doplah. ");
INSERT INTO ifa_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mu lo'tat ya ma\"id ha mabati i dida hitun umaliyan nadan i Assyria an mangubat i dida. ");
INSERT INTO ifa_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ya hay na'udih hi imbagana ya alyonay, Hi Apu Dios di ud nomnom ituwen ma'at ot undan nin waha mabati? ");
INSERT INTO ifa_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ta wadaday munlugan hi papol an malpuh ad Cyprus ta eda dadagon hi ad Assyria ya hi ad Babilon. Mu hay umudi ya ta'on on nadan i Cyprus ya madadagda. ");
INSERT INTO ifa_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ya hidin indappuh Balaam ot munhi\"andan Balak an way ohaon immanamut. ");
INSERT INTO ifa_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Hidin nun'allung nadan tinanud Israel hi ad Sittim ya inhipun nadan udum an linala'in e mi'ilo' hinadan binabain i Moab. ");
INSERT INTO ifa_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ta dadiyen binabai ya inayaganda didah nan eda pangidawatan hi i'nongdah nadan diosda ot middum dadiyen linala'ih nadan tatagun mundayaw ya mangan hinan ini'nongda. ");
INSERT INTO ifa_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ta niddumdan dida an nundayaw hinan dios di i Peor an hi Baal. Ta hiya nan nunhiglay bungot Apu Dios i dida an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ot alyon Apu Dios i Moses di, Awitonyu nadan nangipangpangulu i datuwen e nundayaw i Baal ya numpateyu didah nan pundayawanyu i ha\"on hi ad uwanin mapatal ta tigonyun namin. Ta alina ya ma'aan di bungot'u i da'yun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ot alyon mon Moses hinadan mangipanuh hi mihahapit di, An namin ayu ya pumpateyu nadan linala'ih nadan pu'unyu an e niddum an nundayaw hinan dios di i Peor an hi Baal. ");
INSERT INTO ifa_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ya hidin na'amung nadan tinanud Israel hinan way panton nan tabernakel an ahikokogada ya waday oha an tinanud Israel an inyanamutna han babain i Midian ta tinigon Moses ya nadan tatagun na'amung. ");
INSERT INTO ifa_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ya hidin tinigon nan padi an hi Pinehas an hi na' Eleasar an imbabalen Aaron ya immaan hinan na'amungan nadan tatagu. Ot ena alan han pahul ");
INSERT INTO ifa_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ot tundona didah nan hinunggopandan allung ot patayona didan duwah nan pahul. Ta hidiyey dimminongan nan nunhiglan dogoh di tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mu hay bilang damdaman di nun'a'ate an gapuh nan nunhiglan dogoh ya umeh baintit opat di libu (24,000). ");
INSERT INTO ifa_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ya alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Hi Pinehas an imbabalen Eleasar an apapun nan padin hi Aaron ya impatigonan ongal di aggena naminhodan hi apihula' an Dios. Ta hiya nan gapuh nan inatna ya na'aan di bungot'un da'yun tinanud Israel ta agge da'yu dinadag an namin. ");
INSERT INTO ifa_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ot ibagam i hiya tun ibaga' an palinggopo' di nitaguwana. ");
INSERT INTO ifa_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ta wan didah nadan tanudana di mibilang hi padih inggana. Te hiya ya impatigonay pangita'dognah e' ipabaktuwan an Dios an dayawona. Ta gapuh nan inatna ya na'aan di bungot'un da'yun tinanud Israel an gapuh bahul nadan ibbayu. ");
INSERT INTO ifa_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Hay ngadan nan tinanud Israel an ni'yateh nan babain i Midian ya hi Simri an imbabalen Salu an ohan ap'apun di tinanud Simeon. ");
INSERT INTO ifa_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ya hay ngadan nan babain i Midian an nate ya hi Kosbi an imbabalen Sur an ohan ap'apun di i Midian. ");
INSERT INTO ifa_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ya alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Ibilangyu nadan i Midian hi binuhulyu ta eyu pumpate dida. ");
INSERT INTO ifa_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Te dida ya imbilang da'yu hi binuhulda ta hiya nan binaliyan da'yu ta niddum ayun dida an nundayaw hinan diosda an hi Baal hi ad Peor. Ta hiyay linummuh natayan nan ibbadan babai an hi Kosbi an imbabalen di ohan ap'apuda an i Midian hidin waday nunhiglan dogoh. ");
INSERT INTO ifa_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Hidin nun'a'ateday dakol hinadan tinanud Israel ya inalin bon Apu Dios i da Moses i Eleasar an imbabalen din padin hi Aaron di, ");
INSERT INTO ifa_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Bilangonyu bo nadan himpahimpamu'un an tinanud Israel an baintiy (20) tawonda ya nadan mahuluk hi bainti an mabalin an e mi'gubat. ");
INSERT INTO ifa_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ya i diye ya nun'allungdah nan nundotal hi ad Moab an dommang di ad Jeriko an haggon nan wangwang an nungngadan hi Jordan ot alyon da Moses ya nan padin hi Eleasar hinadan tatagu di, ");
INSERT INTO ifa_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Bilangonyu nadan linala'in bainti (20) ya nadan mahuluk hi baintiy (20) tawonda ta miyunnudan hinan imbagan Apu Dios. Ta datuwey bilang nadan linala'in holag nadan tinanud Israel an nalpuh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ta nan tinanud nan panguluwan an hi Ruben an imbabalen Jacob an hi Israel di ohah ngadana ya nadan holag Hanok ya nadan holag Pallu ");
INSERT INTO ifa_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ya nadan holag Hesron ya nadan holag Karmi. ");
INSERT INTO ifa_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ya hay bilangdan namin ya umeh napat ta tuluy libu ta han pituy gahut ta tulumpulu (43,730). ");
INSERT INTO ifa_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ya hay lala'in imbabalen Pallu ya hi Eliab. ");
INSERT INTO ifa_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Ya hi Eliab ya hay linala'ih imbabalena ya hi Nemuel ya hi Datan ya hi Abiram. Ya datuwen da Datan i Abiram din nangipangpanguluh nadan ap'apu an nungngohe i da Moses i Aaron an niddumdan da Korah ya nadan udum ot ngohayondah Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ot matommang nan luta ot ma'unugdah ad dalom da Korah ya natedah nan apuy nadan nangiyunnud i dida an duway gahut ta nabongley (250) linala'i. Ya hidiyen na'at i dida di pangitigan nadan tatagu ta way atondan adi mangiyunnud hinan inatda. ");
INSERT INTO ifa_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mu nadan tinanudan Korah ya aggeda ni'yate. ");
INSERT INTO ifa_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ya hinada'en tinanud Simeon ya nadan holag Nemuel ya nadan holag Jamin ya nadan holag Jakin ");
INSERT INTO ifa_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ya nadan holag Serah ya nadan holag Saul. ");
INSERT INTO ifa_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ta hay bilangdan namin an tinanud Simeon ya baintit duway libu ta han duway gahut (22,200) an linala'i. ");
INSERT INTO ifa_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ya hinada'en tinanud Gad ya nadan holag Sepon ya nadan holag Haggi ya nadan holag Suni ");
INSERT INTO ifa_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ya nadan holag Osni ya nadan holag Eri ");
INSERT INTO ifa_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ya nadan holag Arodi ya nadan holag Areli. ");
INSERT INTO ifa_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ta hay bilangdan namin an tinanud Gad ya napat di libu ta han limay gahut (40,500) an linala'i. ");
INSERT INTO ifa_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Ya hinada'e an tinanud Judah ya ma\"id ha holag nan duwan imbabalenan da Er i Onan an nateh ad Kanaan. ");
INSERT INTO ifa_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Mu nadan tinanud Judah an nahlag ya hi Selah an nangimbabale i Peres. Ya nada mohpe an holag Serah an hi ibban Selah. ");
INSERT INTO ifa_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ya hinada'en holag Peres ya nadan holag Hesron hinan imbabalenan hi Hamul. ");
INSERT INTO ifa_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ta hay bilangdan namin an tinanud Judah ya umedah napitut onom di libu ta han limay gahut (76,500) an linala'i. ");
INSERT INTO ifa_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ya hinada'e an tinanud Issakar ya nadan holag Tola ya nadan holag Puah ");
INSERT INTO ifa_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ya nadan holag Jasub ya nadan holag Simron. ");
INSERT INTO ifa_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ta hay bilangdan namin an tinanud Issakar ya nanom ta opat di libu ta han tuluy gahut (64,300). ");
INSERT INTO ifa_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ya hinada'en tinanud Sebulun ya nadan holag Sered ya nadan holag Elon ya nadan holag Jahleel. ");
INSERT INTO ifa_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ta hay bilangdan tinanud Sebulun ya nanom di libu ta han limay gahut (60,500). ");
INSERT INTO ifa_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ya hinada'en tinanud Joseph ya nadan imbabalenan da Manasseh i Epraim. ");
INSERT INTO ifa_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ta hinada'en tinanud Manasseh ya nan imbabalenan hi Makir an hi aman Gilead. ");
INSERT INTO ifa_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ta hinada'en tinanud Gilead ya nadan holag Ieser ya nadan holag Helek ");
INSERT INTO ifa_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ya nadan holag Asriel ya nadan holag Sekem ");
INSERT INTO ifa_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ya nadan holag Semida ya nadan holag Heper. ");
INSERT INTO ifa_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Mu nan imbabalen Heper an hi Selopehad ya ma\"id ha lala'ih imbabalena. Mu hay imbabalenah binabai ya hi Mahlah ya hi Noah ya hi Hoglah ya hi Milkah ya hi Tirsah. ");
INSERT INTO ifa_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ta hay bilangdan namin an linala'in tinanud Manasseh ya nabonglet duway libu ta han pituy gahut (52,700). ");
INSERT INTO ifa_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ya hinada'en tinanud Epraim ya nadan holag Sutela ya nadan holag Beker ya nadan holag Tahan. ");
INSERT INTO ifa_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ya hay tinanud Sutela ya nadan holag Eran. ");
INSERT INTO ifa_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ta hay bilangdan namin hinan tinanud Epraim ya tulumpulut duway libu ta han limay gahut (32,500). Ya hay nibilang hi tinanud Joseph ya nadan holag nadan hinagi an da Manasseh i Epraim. ");
INSERT INTO ifa_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ya hinada'en tinanud Benjamin ya nadan holag Bela ya nadan holag Asbel ya nadan holag Ahiram ");
INSERT INTO ifa_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ya nadan holag Supam ya nadan holag Hupam. ");
INSERT INTO ifa_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ya hinada'en tinanud Bela ya nadan holag Ard ya nadan holag Naaman. ");
INSERT INTO ifa_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ta hay bilangdan namin an tinanud Benjamin ya napat ta limay libu ta han onom di gahut (45,600). ");
INSERT INTO ifa_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ya hinada'en tinanud Dan ya nadan holag Suham. ");
INSERT INTO ifa_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ta hay bilangdan namin hinan tinanud Dan ya umeh nanom ta opat di libu ta han opat di gahut (64,400). ");
INSERT INTO ifa_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ya hinada'en tinanud Aser ya nadan holag Imnah ya nadan holag Isbi ya nadan holag Beriah. ");
INSERT INTO ifa_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ya hinada'en tinanud Beriah ya nadan holag Heber ya nadan holag Malkiel. ");
INSERT INTO ifa_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ya wada han babai an imbabalen Aser an hi Serah. ");
INSERT INTO ifa_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ta hay bilangdan namin an tinanud Aser ya nabonglet tuluy libu ta han opat di gahut (53,400). ");
INSERT INTO ifa_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ya hinada'en tinanud Naptali ya nadan holag Jahseel ya nadan holag Guni ");
INSERT INTO ifa_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ya nadan holag Jeser ya nadan holag Sillem. ");
INSERT INTO ifa_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ta hay bilangdan namin an tinanud Naptali ya napat ta limay libu ta han opat di gahut (45,400). ");
INSERT INTO ifa_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ta hay ngammutdan namin an linala'i an tinanud Israel ya onom di gahut ta ohay libu ta han pituy gahut ta tulumpulu (601,730). ");
INSERT INTO ifa_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ot alyon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Nan idat'un da'yu an eyu pumboblayan ya magodwagodwa ta miyunnudan hinan bilangyun himpamu'un. ");
INSERT INTO ifa_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ta nadan dakol an himpamu'un ya ong'ongngal di midat hi eda pumboblayan. Ya nan oh'ohha ya kittang nan midat i dida an eda pumboblayan. ");
INSERT INTO ifa_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ya hay atonyun mangipiyappong ya ibunutyu. ");
INSERT INTO ifa_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ta ma'innila nan midat hinadan dakdakkol an pu'un ya athidi boh nan oh'ohhay holagda. ");
INSERT INTO ifa_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hanada'en tinanud Libay ya dida nadan holag nadan imbabalenan hi Gerson ya hi Kohat ya hi Merari. ");
INSERT INTO ifa_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ya hay holagda ya nadan holag Libni ya nadan holag Hebron ya nadan holag Mahli ya nadan holag Musi ya nadan holag Korah. Hi Kohat ya hi apun Amram. ");
INSERT INTO ifa_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ya hay ngadan nan ahawan Amram ya hi Jokebed an nalpu damdamah nan tinanud Libay an hay niyayyamana ya hi ad Egypt. Ta hay imbabalen da Amram i Jokebed ya da Aaron i Moses ya hi Miriam. ");
INSERT INTO ifa_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Hi Aaron ya imbabalenah Nadab ya hi Abihu ya hi Eleasar ya hi Itamar. ");
INSERT INTO ifa_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mu da Nadab i Abihu ya dida din nate an gapu ta hay nunggohobdah nan ini'nongda ya bokon nan apuy an nalpu i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ta hay bilangdan linala'in tinanud Libay an mihipun hinan ohay bulanda ta mahuluk ya baintit tuluy libu (23,000). Mu adida midattan hi luta ta hiya nan aggeda niddum hinan bilang di ibbadan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ot datuwe nan binilang da Moses hinan padi an hi Eleasar hidin numbilangandah nadan tinanud Israel hi nun'allungandah nan nundotal hi ad Moab an dommang di ad Jeriko an nihaggon hinan wangwang an nungngadan hi Jordan. ");
INSERT INTO ifa_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mu ma\"id ha ohah niddum hinadan linala'in binilang da Moses i Aaron hinan agge naboblayan hi ad Sinai. ");
INSERT INTO ifa_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Te imbagan tuwalin Apu Dios an alyonay mun'a'atedahdih nan agge naboblayan ta ammuna da Kaleb an imbabalen Jepunneh ya hi Joshua an imbabalen Nun di mabati. ");
INSERT INTO ifa_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Nadan binabain imbabalen Selopehad ya hi Mahlah ya hi Noah ya hi Hoglah ya hi Milkah ya hi Tirsah. Ya hi amadan hi Selopehad ya imbabalen Heper an hi na' Gilead. Hi Gilead ya imbabalen Makir an hi na' Manasseh. Ya hi Manasseh ya imbabalen Joseph. ");
INSERT INTO ifa_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ya datuwen binabai ya immedah nan way panton nan tabernakel an na'amungan da Moses ya nan padin hi Eleasar ya nadan ap'apun di himpahimpamu'un ya nadan udum an na'amung an tatagu ot alyonday, ");
INSERT INTO ifa_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Hi amami ya nateh nan agge naboblayan an ma\"id ha lala'ih imbabalena. Mu bokon hiyay ohah nadan nangiyunnud i Korah an nungngohen Apu Dios mu nate damdaman gapuh bahulna. ");
INSERT INTO ifa_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Mu tanganu on ma\"id ha midat hi luta i da'mi an holagna? Undan gapu ta ma\"id ha lala'ih imbabalena ya namaag ya nama\"id di ngadana i didan hina'aggi? ");
INSERT INTO ifa_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ta hi Moses ya minahmahanan Apu Dios di madadawoh hi atonda. ");
INSERT INTO ifa_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ya alyon Apu Dios i hiya di, ");
INSERT INTO ifa_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Nipto' peman hinaen ibagan nadan binabain imbabalen Selopehad. Ot mahapul an idattam didan himpamu'un hi lutada. Ta midat i dida nan midat i amada. ");
INSERT INTO ifa_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ot ibagam hinadan tinanud Israel ta alyom di, Hi'on mate nan tagun ma\"id ha lala'ih imbabalena ya mipaboltan nan lutanah nan babain imbabalena. ");
INSERT INTO ifa_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ya hi'on ma\"id ha ta'on on babaih imbabalena ya hay idatana ya nadan i'ibanan linala'i. ");
INSERT INTO ifa_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Mu ma\"id'e ha lala'ih hi ibbana ya nadan linala'in i'iban amana di idatan nan lutana. ");
INSERT INTO ifa_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ya hi'on ma\"id ha lala'ih hi ibban amana ya midat hinan nihaghaggon di nitulangandah nan nate. Ta hiyah tuwey tugun'un he\"a Moses an mahapul an un'unudonyun tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Wada han nangalyan Apu Dios i Moses di, Tikidom nadan billid an nungngadan hi Abarim ta em mangmangon nan boble an idat'uh nadan ibbam an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ta nagibbuh'en minangmangmu ya ahi'a mohpe mate ta umat'a i ibbam an hi Aaron. ");
INSERT INTO ifa_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Te hidin nginumhe nadan tinanud Israel i ha\"on hidin awadanyuh nan agge naboblayan an nungngadan hi Sin ya aggeyu inunud nan imbaga' hi atonyu an pundayawyun ha\"on an Dios. Te imbahhoyun nangipatigoh nadan tataguh nan pangipabaktuyu i ha\"on hi awadanyuh nan obob hi ad Meribah hidih ad Kades. ");
INSERT INTO ifa_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Ya alyon Moses i Apu Dios di, ");
INSERT INTO ifa_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Hanat he\"a Apu Dios an nanginnilah nomnom di an namin an tatagu ya pot'om ha mangipangpanguluh tudan tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Ta ipapto'na dida ta adida umat hinan kalneron ma\"id ha mangipapto' i dida. ");
INSERT INTO ifa_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ya alyon Apu Dios i Moses di, Hi Joshua an imbabalen Nun ya abalinanan aton ot ayagam ya inha'mom di ta'lem i hiya ta ma'innilan hiyay mihukkat i he\"a. ");
INSERT INTO ifa_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ya imme ayun duwah awadan nan padin hi Eleasar ya nadan na'amung an tatagu ya impa'innilam i dida an hiya moy mangipangpangulun dida. ");
INSERT INTO ifa_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ya impaboltanmun hiyay udum hinan abalinam ta wan an namin nadan tinanud Israel ya hiya moy un'unudonda. ");
INSERT INTO ifa_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Mu mahapul an nan padi an hi Eleasar di pangiyukodana hi mummahma i ha\"on ta hiyay mumbunut hinan Urim. Ya ahi hi Joshua di mangibagah nadan tatagu hinan pohdo' an atonda. ");
INSERT INTO ifa_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ta inunud Moses nan imbagan Apu Dios ot i'uyugnah Joshua ot umedah awadan nan padi an hi Eleasar ya nadan na'amung an tatagu. ");
INSERT INTO ifa_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ot iha'monay ta'lenan hiya ot ibaganah nadan tatagu an hi Joshua di pinto' Apu Dios hi mihukkat i hiya an mangipangpangulun dida. ");
INSERT INTO ifa_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Hi Apu Dios ya alyona bon Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Ibagam hinadan ibbam an tinanud Israel ta madatngan'e nan nagtud an pangiyaliyandah i'nongda ya adida ibahhon mangiyalih nadan maghob an mi'nong ta mipa'amlonga' hinan hunghungna. ");
INSERT INTO ifa_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ot ibagam an hay iyalidah binigat an maghob an mi'nong ya duway kalnero an ohay tawonda ya ma\"id ha bahbahda. ");
INSERT INTO ifa_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ta mi'nong di ohah nan mawi\"it ya hinan mun'ahdom nan oha. ");
INSERT INTO ifa_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Ya hay mitakkop hi hinohhah nan kalnero ya ha hingkiluh napinun alinan nadduman hi ohay litro an manteka an nalpuh nadan tinoptopdan olibo. ");
INSERT INTO ifa_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hiya danaey imbaga' tuwalih din awadanyuh nan way billid hi ad Sinai hi un'unudonyu an maghob an mi'nong hi binigat. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ya hay middum hinan ohan kalnero ya ohay litro an bayah an mihiit hinan pundayawanyu i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ya nan kalneron mi'nong hinan mun'ahdom ya numpaddung di mitakkop hinan mi'nong hinan mawi\"it an wada nimpe nan alina ya bayah. Ot hiya danae nadan maghob an mi'nong. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ya hay mi'nong hinan Habadun tungo ya duway tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahda. Ya nan makan an mitakkop ya duway kilun alina an nadduman hi manteka ya nan bayah. ");
INSERT INTO ifa_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ot danae nadan mi'nong hi ahabahabadu. Ya nat'on tuwali nan maghob an mi'nong hi binigat. ");
INSERT INTO ifa_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Ya alyon bon Apu Dios di, Hinan hopap di algo hi abulabulan ya hay maghob an mi'nong ya duwan pa'ahikkonan bulug an baka ya ohan tangbal an kalnero ya pituy tangbal an kalneron hinohhay tawonda an ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ya ohay baka on hay mitakkop ya tuluy kilun maphod an alina an nadduman hi mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Ya oha boy kalnero on hay mitakkop ya ha hingkilun maphod an alina an nadduman hi mantekan di olibo. Ta danaey maghob an mi'nong an umipa'amlong di hunghungdan ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ya hay mitakkop hinan bulug an baka ya duway litron bayah. Ya hay mitakkop hinan tangbal an kalnero ya ohay litro ya han godwa an bayah. Ya hinan ohan tangbal an kalnero an ohay tawona ya ohay litro an bayah. Ta danaey maghob an mi'nong hinan makayang di bulan hi abulabulan. ");
INSERT INTO ifa_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ya nat'on bo nan mi'nong hi apakawanan di bahul an tangbal an gulding an middum hinan maghob an mi'nong an matakkopan hi bayah. ");
INSERT INTO ifa_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Alyon bon Apu Dios di, Hinan mi'ahimpulut opat (14) di algo hinan mamangulun bulan ya hidiye nan punnomnomnomanyun tinanud Israel hi nihwanganyuh ateh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ya hinan mabiggat an mi'ahimpulut limah (15) algo i diye damdaman bulan ya mihipun nan pituy algo an pungngilinanyuh nan adiyu panganan hi tinapay an nadduman hi yist. ");
INSERT INTO ifa_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ya hinan mamangulun algo ya ma'amung ayun namin ta mundayaw ayu an ma\"id ha e muntamu. ");
INSERT INTO ifa_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ya hay i'nongyun ha\"on an Dios hi maghob an mi'nong ya duway pa'ahikkonan bulug an baka ya ohay tangbal an kalnero ya pituy tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ya hay makan hi mitakkop hinan ohay baka ya tuluy kilu an maphod an alina an nadduman hi mantekan di olibo. Ya hinan ohan tangbal an kalnero ya duway kilu an alina. ");
INSERT INTO ifa_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ya hinan ohan kalneron ohay tawona ya oha boy kilun alina di mitakkop. ");
INSERT INTO ifa_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ya iniddumyu ha ohay tangbal hi gulding ta mi'nong hi apakawanan di bahulyu. ");
INSERT INTO ifa_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ta danaey mahapul hi i'nongyu ta middum hinan maghob an mi'nong hi amawmawi\"it. ");
INSERT INTO ifa_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ya abigabigat hinan pituy algo ya iyaliyu nan maghob an mi'nong ta mipa'amlonga' an Dios hinan hunghungna. Ya nat'on tuwali nan midat hi abigabigat an maghob an mi'nong ya nan mitakkop an bayah. ");
INSERT INTO ifa_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ya hinan mi'apituh algo ya ma'amung ayu bon namin ta ma\"id ha e muntamu. ");
INSERT INTO ifa_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Hinan mamangulun algoh nan ngilin di ahigapas ya ma'amung ayu bon namin an ma\"id ha e muntamu ta idawatyu i ha\"on nan midawat an makan. ");
INSERT INTO ifa_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ya hay iyaliyuh maghob an mi'nong ya duway pa'ahikkonan bulug an baka ya ohay tangbal an kalnero ya pituy tangbal an kalnero an hinohhay tawonda. Ta mipa'amlonga' an Dios hinan hunghungda. ");
INSERT INTO ifa_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ya hinan ohan bulug an baka on waday mitakkop an tuluy kilu an napinu an alina an nadduman hi mantekan di olibo. Ya hina'en ohan tangbal an kalnero ya duway kilun alina. ");
INSERT INTO ifa_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Ya nada'en pitun kalnero ya hay mitakkop hi hinohhan kalnero ya ohay kilun napinun alina. ");
INSERT INTO ifa_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ya wada bo nan ohan tangbal an gulding ta mi'nong hi a'aanan di bungot'un Dios i da'yu. ");
INSERT INTO ifa_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ta danae nadan mi'nong ya nadan midawat an ma'inum an middum hinan maghob an mi'nong hi binigat ya nan mitakkop an alina. Ot tigonyu ta hay i'nongyu ya nan animal an ma\"id ha bahbahna. ");
INSERT INTO ifa_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Hinan mamangulun algoh nan mi'apituh bulan ya ma'amung ayu bon namin an tinanud Israel ta mundayaw ayu i ha\"on an Dios ya ma\"id ha e muntamu. Ya hidiyen algo di pangipagangohanyuh nadan trampeta. ");
INSERT INTO ifa_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ya hay iyaliyuh maghob an mi'nong ya ha pa'ahikkonan bulug an baka ya ha tangbal an kalnero ya ha pituy tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ya hay mitakkop hinan baka ya tuluy kilu an napinun alina an nadduman hi mantekan di olibo. Ya duway kiluy napinun alinan nadduman hi mantekan di olibo di mitakkop boh nan tangbal an kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Ya hinan pitun kalnero ya hinohhay kiluy alina di mitakkop hi hinohhan kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ya iddumyu ha ohay tangbal hi gulding ta mi'nong hi apakawanan di bahulyu ta a'aanan di bungot'un Dios an gapuh bahulyu. ");
INSERT INTO ifa_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ot hiya danaey maghob an mi'nong ta middum hinan binulan an mi'nong ya nan mi'nong hi binigat an matakkopan hi alina ya bayah. Ot nan hunghungna ya umipa'amlong i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ya hinan mi'apuluh algo i diyen mi'apituh bulan ya ma'amung ayu bo ta mundayaw ayu i ha\"on. Ya mahapul an adiyu aton nan pohdon di adolyu ya adi ayu e muntamu i diyen algo. ");
INSERT INTO ifa_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Ya hay maghob an mi'nong ta umipa'amlong i ha\"on an Dios nan hunghungna ya ha ohay pa'ahikkonan bulug an baka ya ohay tangbal an kalnero ya pituy tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ya hay mitakkop hinan baka ya tuluy kilu an napinun alina an nadduman hi mantekan di olibo. Ya hay mitakkop bo hinan tangbal an kalnero ya duway kilun napinun alinan nadduman hi mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Ya hinada'en hinohhan kalneron ohay tawonda ya hinohhay kiluy alina an nadduman hi mantekan di olibo di mitakkop. ");
INSERT INTO ifa_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ya iddumyu ha ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyu ya a'aanan di bungot'un Dios. Ya nat'on mohpe tuwali nan maghob an mi'nong an matakkopan hi makan ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Hinan mi'ahimpulut limay (15) algo hinan mi'apituh bulan ya ma'amung ayu bo ta mundayaw ayu i ha\"on an Dios an ma\"id ha e muntamu. Ta ngilinonyuh diyen algo an ihipunan nan pituy algo ta punnomnomnomanyuh nan eyu nun'anallungan hinan inwayu hidin nalpuwanyuh ad Egypt. ");
INSERT INTO ifa_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ot hay iyaliyuh maghob an mi'nong i diyen algo ya himpulut tulun (13) pa'ahikkonan bulug an baka ya duwan tangbal an kalnero ya himpulut opat (14) an tangbal an kalneron ohay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ya hay makan hi mitakkop hi ohan baka ya tuluy kilun napinun alina an nadduman hi mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Ya hinohhah nan himpulut opat (14) an kalnero ya hay mitakkop ya hingkilun napinun alina an nadduman hi mantekan di olibo. ");
INSERT INTO ifa_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ya iddumyuy ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyu. Ya nanongna tuwali nan maghob an mi'nong hi binigat an matakkopan hi makan ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ya hinan mi'adwah algo ya atbohdiy idadaanyu an himpulut duwan (12) pa'ahikkonan bulug an baka ya duwan tangbal an kalnero ya himpulut opat (14) bo an tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahda. ");
INSERT INTO ifa_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ya idadaanyu bo nan midawat an makan ya bayah an mitakkop hinadan baka ya kalnero ta miyunnudan hinan bilang di mi'nong. ");
INSERT INTO ifa_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ya atbohdin iyaliyu ha ohah tangbal an gulding ta mi'nong hi apakawanan di bahulyu. ");
INSERT INTO ifa_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Ya hinan mi'atluh algo ya atbohdi an hay i'nongyu ya himpulut ohan (11) pa'ahikkonan bulug an baka ya duway tangbal an kalnero ya himpulut opat (14) an tangbal an kalneron hinohhay tawonda an ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ya dadiyen mi'nong an baka ya kalnero ya waday mitakkop an makan ya bayah an miyunnudan hinan nibaga an dinakolda. ");
INSERT INTO ifa_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ya mahapul bon waha ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyu. Ya nat'on tuwali nan maghob an mi'nong hi binigat. Ya hiyah diyen wada nan mitakkop an makan ya ma'inum an bayah an midawat. ");
INSERT INTO ifa_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Ya hinan mi'apat hi algo ya idadaanyuy himpulun bulug an baka ya duwan tangbal an kalnero ya himpulut opat (14) an tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ya hiyah diyen ohan baka onu kalneron mi'nong on wada ha mitakkop an makan ya ma'inum an bayah hi midawat. ");
INSERT INTO ifa_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ya wada bo nan ohan tangbal an gulding an mi'nong ta apakawanan di bahulyu. Ya nat'on tuwali nan maghob an mi'nong hi binigat ya nadan mitakkop an makan ya ma'inum. ");
INSERT INTO ifa_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ya hinan mi'alimah algo ya idadaanyuy hiyam an bulug an baka ya duwan tangbal an kalnero ya himpulut opat (14) an kalneron ohay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ya hiyah diyen ohan baka onu kalnero on waday mitakkop an makan ya ma'inum an bayah. ");
INSERT INTO ifa_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Ya wada bo nan ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyu. Ya nat'on bo nan maghob an mi'nong hi binigat ya nan makan ya bayah an midawat. ");
INSERT INTO ifa_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ya hinan mi'anom hi algo ya hay idadaanyu ya waluy bulug an baka ya duway tangbal an kalnero ya himpulut opat (14) an tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ya ohan mi'nong an baka ya kalnero on wada nan mitakkop an alina ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Ya iddumyu boy ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyun tatagu. Ya nat'on nimpe nan maghob an mi'nong hi binigat. Ya wada bo nan mitakkop an alina ya bayah. ");
INSERT INTO ifa_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ya hinan mi'apituh algo ya hay idadaanyu ya pituy bulug an baka ya duway tangbal an kalnero ya himpulut opat (14) an tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ya idadaanyu bo nadan mitakkop hinadan bulug an baka ya kalnero an makan ya ma'inum an bayah ta midawat an miyunnudan hinan nibaga an bilang di midawat. ");
INSERT INTO ifa_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Ya iddumyu boy ohan tangbal an gulding ta mi'nong hi apakawanan di bahulyu. ");
INSERT INTO ifa_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ya hinan mi'awaluh algo ya ma'amung ayu bon namin ta mundayaw ayun ha\"on an Dios an ma\"id ha e muntamu. ");
INSERT INTO ifa_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ya hay idadaanyu i diyen algo ya ha bulug an baka ta maghob an mi'nong ta mipa'amlonga' hinan hunghungna ya ha tangbal an kalnero ya ha pituy tangbal an kalnero an hinohhay tawonda ya ma\"id ha bahbahdan namin. ");
INSERT INTO ifa_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ya hinan ohan baka onu kalneron mi'nong on wada nan alina ya bayah an mitakkop. ");
INSERT INTO ifa_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ya iddumyu ha ohah tangbal hi gulding ta mi'nong hi apakawanan di bahulyu. Ya nat'on tuwali nan maghob an mi'nong hi abigabigat ya nan makan ya ma'inum an midawat. ");
INSERT INTO ifa_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ta danaey mahapul an mi'nong hi atawotawon hi'on nadatngan nadan nagtud an ngilin. Ya nat'on tuwali nan imbagayun i'nongyu ya nan ninomnomyun i'nong. Ya indadaanyu bo nadan maghob an mi'nong ya nadan midawat an makan ya nadan ma'inum an midawat ya nadan mi'nong hi pi'hayyupanyu i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ta hi Moses ya impa'innilanan namin danaen tugun Apu Dios i didan tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Hi Moses ya inamungnan namin nadan ap'apun di himpahimpamu'un an tinanud Israel ot alyonan diday, Datuwe nadan tugun Apu Dios i dita'u. ");
INSERT INTO ifa_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Hi'on waday insapatan di ohan tagu hi atona onu ha imbaganah mahapul an atona ya mahapul an ipa'annungna ta ma\"id ha ibahhona. ");
INSERT INTO ifa_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ya hi'on waha mangilog hi babai hi nanongnan niddum hinan ammodna ya waday insapatanan Apu Dios onu imbaganan mahapul an atona ");
INSERT INTO ifa_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ya hi'on dingngol amanah diyen insapatana ya adina ipagol ot mahapul an adina ibahho. ");
INSERT INTO ifa_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mu hi'on ipagol amanah diyen insapatana ya adi pabahulon Apu Dios hidiyen babai hi'on aggena inat nan insapatana. ");
INSERT INTO ifa_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ya hi'on hidiyen babai ya nagibbuh an waday insapatanah atona ya ahi mangahawa ");
INSERT INTO ifa_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ya hidin dingngol nan ahawanah diyen imbagana mu adina ipagol ya mahapul an ipa'annungnan namin nadan insapatana. ");
INSERT INTO ifa_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mu hi'on hidin dingngol ahawana ya ipagolna ya adi mahapul an ipa'annungna ot adi ibilang Apu Dios hi numbahul hi'on aggena impa'annung. ");
INSERT INTO ifa_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ya hi'on waday insapatan ha nabaluh babai onu ha ni'bolhe ya mahapul an ipa'annungna. ");
INSERT INTO ifa_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Ya onha nan nangahawa an babai ya waday insapatanah atona onu imbaganah mahapul an atona ");
INSERT INTO ifa_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ya dingngol ahawana mu adina ipagol ya mahapul an ipa'annungnan aton. ");
INSERT INTO ifa_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mu onha dingngol nan ahawana an wadaday insapatanah atona ya ipagolna ot adi mahapul an ipa'annungna ot hi Apu Dios ya adina pabahulon hidiyen babai. ");
INSERT INTO ifa_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Te nan lala'in ahawana di ma'unud hi'on iyabulutna onu adina. ");
INSERT INTO ifa_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mu hi'on nan lala'in ahawana ya dingngolna mu adina ipagol ot hidiyey panginnilaan an unnudanah ahawana. ");
INSERT INTO ifa_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mu hi'on hinnodna ta nala\"uh di atnay algo ya ahina ipagol ot hiya moy madusah agge nangatan ahawanah nan insapatana. ");
INSERT INTO ifa_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ta danae nadan tugun Apu Dios an imbagana i Moses an ma'at hinan waday ahawana ya hinan babain niddum hinan ammodna. ");
INSERT INTO ifa_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Hi Apu Dios ya alyonan Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Eyu iballoh nadan i Midian nan na'at hinadan tinanud Israel ta nagibbuh'e ya ahi'a mitnud hinadan a'ammodmun numpun'ate. ");
INSERT INTO ifa_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ot alyon Moses hinadan tatagu di, Pot'onyu dohah nadan linala'in mabalin an e mi'gubat hinadan i Midian ta pangiballoh Apu Dios hinan inatda i dita'un tataguna. ");
INSERT INTO ifa_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ot bilangonyu ha hinlilibuy (1,000) linala'i hi hinohha i da'yun himpahimpamu'un an tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ta hay ngammutyun namin ya himpulut duway libu (12,000) an tindalun nalpuh nadan himpulut duwan (12) tinanud Israel. ");
INSERT INTO ifa_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Ot honagon Moses dida ta eda mi'gubat an ta'on on nan padi an hi Pinehas an imbabalen Eleasar. Ta inodnanda nadan ma'usal hinan pundayawan ya nan tangguyub an ipagangohda ta mundadaan nadan tatagun e mi'gubat. ");
INSERT INTO ifa_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ta immeda ot eda gubaton nadan i Midian an inunudda nan imbagan Apu Dios i Moses. Ot patayondan namin nadan linala'in i Midian. ");
INSERT INTO ifa_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ya ni'pateda nadan liman patul di i Midian an hi Ebi ya hi Rekem ya hi Sur ya hi Hur ya hi Reba. Ot patayonda boh Balaam an imbabalen Peor. ");
INSERT INTO ifa_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ot awitondan namin nadan binabai ya u\"unga. Ot pun'alada nadan animal ya nadan gina'un nadan i Midian. ");
INSERT INTO ifa_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ot pu'ulandan namin nadan numboblayan nadan i Midian ya ta'on on nadan nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ta inaladan namin nadan gina'uda ya animalda ya ta'on on nadan nabatin tatagu ");
INSERT INTO ifa_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ot iyedah awadan da Moses ya nan padi an hi Eleasar ya nadan ibbadan tinanud Israel. Ya hay nun'allunganda i diye ya hinan nundotal hi ad Moab an nihaggon hinan wangwang an nungngadan hi Jordan an dommang di ad Jeriko. ");
INSERT INTO ifa_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mu hidin manganamut nadan tindalu ya e dinamun da Moses ya nan padi an hi Eleasar ya nadan ap'apun di himpahimpamu'un an tinanud Israel hinan bata\"an di nun'allunganda. ");
INSERT INTO ifa_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ya bimmungot hi Moses hinadan opisyal di hinlilibun (1,000) tindalu ya nadan opisyal di hinggagahut (100) an tindalu an e ni'gubat. ");
INSERT INTO ifa_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ta alyonan diday, Tanganu onyu agge ni'pate danaen binabai? ");
INSERT INTO ifa_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Undan aggeyu innila an dida nadan nangunud hinan intugun Balaam ot ipangpanguluda nadan ibba ta'un tinanud Israel hi ad Peor ta din'ugdah Apu Dios? Ta hiya nan nawada din nunhiglan dogoh an impa'alin Apu Dios hinadan tataguna. ");
INSERT INTO ifa_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ot hiya nan patayonyun namin nadan u\"ungan linala'i ya ta'on on nadan binabain waday inilo'nah lala'i. ");
INSERT INTO ifa_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mu adiyu patayon nadan binabain ma\"id ha inilo'dah lala'i ta iyanamutyu dida. ");
INSERT INTO ifa_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ya an namin ayu an waday pinatena onu dinapanah nate ya umohnong ayu ni' hitun nibata\"an hinan way nun'allungan ta'u ta ingganah mala\"uh di pituy algo. Ta hinan mi'atluh algo ya unudonyu nan nibaga an atonyu ta mibilang ayuh malinis ya athidi boh nan mi'apituh algo. Ya atonyu damdamah nadan u\"ungan binabai an inalayuh nadan eyu ginubat nan nibaga an aton ta mibilangdah malinis. ");
INSERT INTO ifa_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ya athidi boh nadan usalyun luput ya nadan lalat ya dutdut di gulding ya nadan kayiw. ");
INSERT INTO ifa_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ya alyon nan padi an hi Eleasar hinadan tindalun e ni'gubat di, Datuwe nadan imbagan Apu Dios i Moses an mahapul an unudon ta'u ");
INSERT INTO ifa_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ta nan balitu' ya silber ya gombang ya gumo' ya lata ya ta'on on nan lube ");
INSERT INTO ifa_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ya an namin an adi maghob ya mahapul an mundalan hi apuy ta malinisan. Mu mahapul damdama bon ma'ulahan hinan liting ta mibilangdah malinis. Ya na'e an usal an maghob ya mahapul an ulahanyuh liting ya abuh. ");
INSERT INTO ifa_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ya hinan mi'apituh algo ya inlaba'yu nadan lubungyu ta mibilang ayuh malinis ya ahi mabalin mohpen umanamut ayuh nan nun'allungan ta'u. ");
INSERT INTO ifa_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Alyon bon Apu Dios i Moses di, ");
INSERT INTO ifa_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","He\"a ya nan padi an hi Eleasar ya nadan ap'apun di himpahimpamu'un ya mahapul an bilangonyun namin nadan tatagu ya animal an inyanamut nadan e ni'gubat. ");
INSERT INTO ifa_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ya ginodwayu nadan inyanamutyu ta midat hinadan tindalun e ni'gubat di godwana ya hinadan tatagun agge e ni'gubat nan godwana. ");
INSERT INTO ifa_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ya hinan nidat hinadan tindalu ya aanonyu nan midat i ha\"on an Dios. Ta hinan limay gahut (500) an baka ya dongki ya kalnero ya gulding ya ta'on on nadan tatagun inyanamutdan e ni'gubat ya ma'aan di hinohha ta midat i ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ya danae'e an midat i ha\"on an Dios ya idatyuh nan padi an hi Eleasar. ");
INSERT INTO ifa_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ya hina'e an godwana an midat hinadan tatagu ya nabongle'e an tagu onu baka ya kalnero ya dongki ya gulding ya ma'aan di hinohha ta midat i ha\"on an Dios. Ya hay idatan danaen midat i ha\"on an Dios ya hinadan tinanud Libay an muntamuh nan tabernakel an pundayawanyun ha\"on an Dios. ");
INSERT INTO ifa_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ta hiyay inat da Moses ya nan padi an hi Eleasar an inunudda nan imbagan Apu Dios i Moses. ");
INSERT INTO ifa_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ya hay bilang nan nabatih nan inyanamut nadan e ni'gubat ya onom di gahut ta napitut limay libuy (675,000) kalnero ");
INSERT INTO ifa_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ya napitut duway libuy (72,000) baka ");
INSERT INTO ifa_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ya nanom ta ohay libuy (61,000) dongki ");
INSERT INTO ifa_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ya tulumpulut duway libuy (32,000) binabain ma\"id ha inilo'dah lala'i. ");
INSERT INTO ifa_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ta nan godwan diyen nidat hinadan tindalu ya tuluy gahut ta tulumpulut pituy libu ta han limay gahut (337,500) di kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Ya hay nidat i Apu Dios ya onom di gahut ta napitut limay (675) kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ya nada'e an baka ya tulumpulut onom di libu (36,000) ta hay midat i Apu Dios ya napitut duwa (72). ");
INSERT INTO ifa_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ya nada'en dongki ya tulumpuluy libu ta han limay gahut (30,500) ta hay midat i Apu Dios ya nanom ta oha (61). ");
INSERT INTO ifa_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ya hay tatagu'e ya himpulut onom di libu (16,000) ta hay midat'e i Apu Dios ya tulumpulut duwa (32). ");
INSERT INTO ifa_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ta hi Moses ya inunudna nan imbagan Apu Dios i hiya ot idatna i Eleasar nan midat i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ya na'en godwana an midat hinadan tatagun tinanud Israel an agge e ni'gubat ");
INSERT INTO ifa_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ya tuluy gahut ta tulumpulut pituy libu ta han limay gahut (337,500) di kalnero. ");
INSERT INTO ifa_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Ya tulumpulut onom di libuy (36,000) baka. ");
INSERT INTO ifa_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Ya tulumpuluy libu ta han limay gahut (30,500) di dongki. ");
INSERT INTO ifa_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Ya himpulut onom di libuy (16,000) binabain binatida. ");
INSERT INTO ifa_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ta hidiyen godwana an midat hinadan tatagu ya nabongle'en tatagu onu animal on ohay inaan Moses. Ot hidiyey idatnah nadan tinanud Libay an muntamuh nan tabernakel an miyunnudan hinan imbagan Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Mu immeda i Moses nadan opisyal di tindalun e ni'gubat ");
INSERT INTO ifa_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ot alyondan hiyay, Binilangmin namin nadan linala'in impangulumin e ni'gubat ya maphod ta wada amin namin. ");
INSERT INTO ifa_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ot hiya nan idawatmin Apu Dios nadan inalamin balitu' an mihu'lub hi ta'le ya mibangngol di udum ya misingsing di udum ya mihingat di udum. Ta pangipatigomih punhanaanmi hi nangipapto'anan da'mi ta nihwang ami. ");
INSERT INTO ifa_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ot alan da Moses i nan padi an hi Eleasar dadiye ot idawatdan namin i Apu Dios. ");
INSERT INTO ifa_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ya hay damot dadiyen indat nadan opisyal di hinlil