﻿USE sofia;
DROP TABLE IF EXISTS sofia.ibo_vpl;
CREATE TABLE ibo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ibo_vpl WRITE;
INSERT INTO ibo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Na mmalite Chineke kere eluigwe na ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ụwa bụ ihe na-enweghị ụdịdị ọbụla, bụrụkwa ihe tọgbọrọ nʼefu. Ọchịchịrị gbara nʼelu ogbu mmiri dị omimi. Mmụọ nke Chineke na-erugharị nʼelu ogbu mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mgbe ahụ Chineke kwuru sị, “Ka ìhè dị,” ìhè dịkwara. ");
INSERT INTO ibo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Chineke hụrụ na ìhè ahụ mara mma. Ọ kpara oke nʼetiti ìhè na ọchịchịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Chineke kpọrọ ìhè ahụ Ehihie, kpọọ ọchịchịrị ahụ Abalị. Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Chineke kwukwara sị, “Ka mbara pụta nke ga-ekewapụ mmiri dị nʼelu mbara ahụ site na mmiri nke dị nʼokpuru mbara ahụ” ");
INSERT INTO ibo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ya mere, Chineke mere mbara, kewapụ mmiri dị nʼokpuru mbara ahụ site na mmiri nke dị nʼelu mbara ahụ. O sikwa otu a dịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mbara ahụ ka Chineke kpọrọ mbara eluigwe. Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Chineke kwuru sị, “Ka mmiri dị nʼokpuru mbara eluigwe chịkọta onwe ha ọnụ nʼotu ebe, ka ala akọrọ pụta.” O sikwa otu a dịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Chineke kpọrọ ala akọrọ ahụ “ala,” kpọọ mmiri ahụ chịkọtara onwe ha ọnụ “osimiri.” Chineke lere anya hụ na ha dị mma. ");
INSERT INTO ibo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Chineke kwuru sị, “Ka ala pupụta ahịhịa ndụ dị iche iche: ahịhịa na-amịpụta mkpụrụ, na osisi dị nʼelu ala nke na-amịpụta mkpụrụ, nke mkpụrụ ọkụkụ ya dị nʼime ya, dịka ụdịdị ha dị iche iche si dị.” O sikwa otu a dịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ala puputara ahịhịa ndụ dị iche iche: ahịhịa na-amịpụta mkpụrụ dịka ụdịdị ha si dị, na osisi na-amịpụta mkpụrụ, nke mkpụrụ ọkụkụ ya dị nʼime ya, dịka ụdịdị ha si dị. Chineke lere anya hụ na ọ dị mma. ");
INSERT INTO ibo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke atọ. ");
INSERT INTO ibo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Chineke kwuru sị, “Ka ìhè nke na-enye ìhè dịrị na mbara eluigwe, ikewapụ ehihie site nʼabalị. Ka ha bụrụ ihe ama igosi oge dị iche iche, ụbọchị dị iche iche, na afọ dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ka ha bụrụ ìhè na mbara eluigwe inye ìhè nʼelu ụwa.” O si otu a dịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Chineke mere ìhè ukwu abụọ, nke kacha ịdị ukwu ka ọ bụrụ nke ga-achị ehihie, ma nke dị nta ka ọ bụrụ nke ga-achị abalị. O mekwara kpakpando dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Chineke debere ha na mbara eluigwe inye ìhè nʼụwa, ");
INSERT INTO ibo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ịchị ehihie na abalị na ịkpa oke nʼetiti ìhè na ọchịchịrị. Chineke lere anya hụ na ọ dị mma. ");
INSERT INTO ibo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke anọ. ");
INSERT INTO ibo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Chineke kwuru sị, “Ka mmiri jupụta nʼihe ndị na-eku ume, ka ụmụ anụ ufe fegharịkwa nʼelu ụwa, ma nʼelu mbara igwe.” ");
INSERT INTO ibo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ya mere Chineke kere anụ ukwu niile bi na mmiri, na anụ niile nwere ndụ bi na mmiri, na ụdị ihe ọbụla nwere ndụ na-akpụgharị akpụgharị ndị jupụtara na mmiri, dịka ụdịdị ha si dị, na anụ ufe niile dịka ụdịdị ha si dị. Chineke lere anya hụ na ọ dị mma. ");
INSERT INTO ibo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Chineke gọziri ha, sị ha, “Mụbaanụ, dịkwanụ ukwuu nʼọnụọgụgụ, jupụtanụ osimiri niile. Ka anụ ufe dịkwa ukwuu nʼọnụọgụgụ nʼelu ụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke ise. ");
INSERT INTO ibo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Chineke kwuru sị, “Ka ala wepụta ụmụ anụ dị iche iche nwere ndụ dịka ụdịdị ha si dị: anụ ụlọ, anụ na-akpụgharị nʼala, na anụ ọhịa, nke ọbụla dịka ụdịdị ya si dị.” O si otu a dịrị. ");
INSERT INTO ibo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Chineke mere ụmụ anụ ọhịa, dịka ụdịdị ha si dị, mee anụ ụlọ, dịka ụdịdị ha si dị, na anụ niile nwere ndụ nke na-akpụgharị nʼala dịka ụdịdị ha si dị. Chineke lere anya hụ na ọ dị mma. ");
INSERT INTO ibo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mgbe ahụ, Chineke kwuru sị, “Ka anyị mee mmadụ nʼoyiyi anyị, dịka ụdịdị anyị si dị, ka ha chịa azụ niile nke osimiri, na anụ ufe niile nke eluigwe, na anụ ụlọ niile, na anụ ọhịa niile, na ihe niile e kere eke nwere ndụ nke na-akpụ akpụ nʼala.” ");
INSERT INTO ibo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ya mere, Chineke kere mmadụ nʼoyiyi nke ya, nʼoyiyi Chineke ka o kere ha, nwoke na nwanyị ka o kere ha. ");
INSERT INTO ibo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Chineke gọziri ha sị ha, “Mịanụ mkpụrụ, mụbaanụ, jupụtanụ nʼụwa, meenụ ka ihe niile dịrị nʼokpuru unu. Chịanụ azụ niile nke osimiri na anụ ufe niile nke eluigwe na ihe niile e kere dị ndụ nke na-akpụgharị akpụgharị nʼala.” ");
INSERT INTO ibo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mgbe ahụ, Chineke sịrị “Enyela m unu ahịhịa ubi niile na-amị mkpụrụ dị nʼelu ụwa, na osisi ọbụla mịrị mkpụrụ, nke mkpụrụ ọkụkụ ya dị nʼime ha, ka ha bụrụ ihe oriri gị. ");
INSERT INTO ibo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma ụmụ anụmanụ niile na anụ ufe niile, na anụ niile e kere eke na-akpụgharị akpụgharị nʼala, anụ ọbụla nwere ndụ nʼime ha ka m na-enye ahịhịa ndụ niile ka ọ bụrụ ihe oriri ha.” ");
INSERT INTO ibo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Chineke legharịrị anya nʼihe o kere, hụ na ọ dị ezi mma. Uhuruchi dị, ụtụtụ dịkwa. Ọ bụrụ ụbọchị nke isii. ");
INSERT INTO ibo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Otu a ka e si rụzuo ọrụ ike eluigwe na ụwa na ihe niile dị nʼime ha. ");
INSERT INTO ibo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nʼụbọchị nke asaa, Chineke kwụsịrị ọrụ ya nke ọ na-arụ, o zukwara ike site nʼọrụ ya niile. ");
INSERT INTO ibo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Chineke gọziri ụbọchị nke asaa ahụ mee ya ka ọ bụrụ ụbọchị dị nsọ, nʼihi na ọ bụ nʼụbọchị ahụ ka ọ zuru ike site nʼọrụ nke ike ihe niile. ");
INSERT INTO ibo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nke a bụ akụkọ banyere usoro okike eluigwe na ụwa mgbe e kere ha, nʼụbọchị ahụ mgbe Onyenwe anyị Chineke kere eluigwe na ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ahịhịa ọbụla epupụtabeghị nʼọhịa, o nwekwaghị ihe ubi ọbụla sitere nʼala pupụta, nʼihi na Onyenwe anyị Chineke ezitebeghị mmiri ozuzo nʼelu ụwa, o nwekwaghị mmadụ ọbụla nọ na-arụ ọrụ ubi, ");
INSERT INTO ibo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ma mmiri si nʼala na-asọpụta na-asọ nʼelu ala niile. ");
INSERT INTO ibo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Onyenwe anyị Chineke kpụrụ mmadụ site nʼaja nke ala, kunye ya ume ndụ nʼimi ya, nke mere ka mmadụ ghọọ ihe dị ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Onyenwe anyị Chineke kụrụ ubi a gbara ogige nʼakụkụ ọwụwa anyanwụ, nʼIden. O tinyere mmadụ ahụ ọ kpụrụ nʼime ubi a. ");
INSERT INTO ibo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Onyenwe anyị Chineke mere ka osisi dị iche iche si nʼala pupụta, osisi ndị dị mma ile anya na nke dịkwa mma iri eri. Nʼetiti ogige a, e nwere osisi na-enye ndụ, na osisi nke ịmata ihe ọma na ihe ọjọọ. ");
INSERT INTO ibo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","E nwere iyi si nʼIden na-asọpụta na-asọbanye nʼime ogige ahụ ime ka ala ahụ nwee mmiri. Site nʼebe ahụ, iyi a kewara nwee ngalaba anọ. ");
INSERT INTO ibo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Aha ngalaba nke mbụ bụ Paịshọn. Ọ sọọrọ ogologo gafee ala niile nke Havila, ebe a na-enweta ọlaedo. ");
INSERT INTO ibo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Ọlaedo dị nʼala ahụ mara mma. Eso osisi na-esi isi ụtọ na nkume dị oke ọnụahịa a na-akpọ ọniks dịkwa nʼebe ahụ.) ");
INSERT INTO ibo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Aha ngalaba nke abụọ bụ Gaihọn. O sitere nʼala Kush gafee. ");
INSERT INTO ibo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Aha osimiri nke atọ bụ Taịgris. Ọ na-asọla nʼakụkụ ọwụwa anyanwụ nke ala Ashọ. Aha osimiri nke anọ bụ Yufretis. ");
INSERT INTO ibo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Onyenwe anyị Chineke weere mmadụ ahụ tinye ya nʼogige Iden, ka ọ na-akọ ya ma bụrụkwa onye na-elekọta ya. ");
INSERT INTO ibo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Onyenwe anyị Chineke nyere mmadụ ahụ iwu sị ya “I nwere ike iri mkpụrụ osisi niile dị nʼubi a, ");
INSERT INTO ibo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ma ị gaghị eri mkpụrụ si nʼosisi ịmata ihe ọma na ihe ọjọọ. Nʼihi na ụbọchị i riri ya ị ga-anwụrịrị.” ");
INSERT INTO ibo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Onyenwe anyị Chineke kwuru sị, “Ọ dịghị mma ka nwoke nọrọ naanị ya. Aga m emere ya onye inyeaka nke kwesiri ya.” ");
INSERT INTO ibo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Onyenwe anyị Chineke sitere nʼala kpụọ ụmụ anụmanụ niile nke ọhịa na ụmụ anụ ufe niile nke eluigwe. O dutere ha ka ọ mara ihe mmadụ ahụ ga-akpọ ha. Ihe ọbụla mmadụ ahụ kpọrọ ihe ọbụla ndị a nwere ndụ, nke ahụ bụkwa aha ya. ");
INSERT INTO ibo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ya mere, mmadụ ahụ nyere anụ ụlọ niile na anụ ufe niile na anụ ọhịa niile aha. Ma nʼebe Adam nọ, o nweghị onye inyeaka kwesiri ya. ");
INSERT INTO ibo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ya mere, Onyenwe anyị Chineke mere ka nwoke ahụ daa nʼụra. Mgbe ọ nọ na-arahụ ụra, o wepụtara otu ọgịrịga site na ngụ dị ya nʼahụ, mechikwaa ebe o si wepụta ya. ");
INSERT INTO ibo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mgbe ahụ, Onyenwe anyị Chineke ji otu ọgịrịga o si nʼahụ nwoke ahụ wepụta, mee nwanyị, dutere ya nwoke ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nwoke ahụ kwuru sị, “Nke a bụ ọkpụkpụ si nʼọkpụkpụ m, na anụ ahụ si nʼahụ m, a ga-akpọ ya ‘nwanyị,’ nʼihi na e si nʼime nwoke wepụta ya.” ");
INSERT INTO ibo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ọ bụ nke a mere nwoke ga-eji hapụ nne na nna ya, e jikọta ya na nwunye ya, ha ga-abụ otu anụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nwoke ahụ na nwunye ya gba ọtọ, ma ihere emeghị ha. ");
INSERT INTO ibo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Agwọ dị aghụghọ karịa ụmụ anụ ọhịa niile Onyenwe anyị Chineke kere. Ọ bịakwutere nwanyị ahụ sị ya, “Ọ bụ ezie na Chineke sị unu erila mkpụrụ si nʼosisi niile dị nʼogige a?” ");
INSERT INTO ibo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nwanyị ahụ zara sị ya, “Anyị nwere ike rie mkpụrụ si nʼosisi niile dị nʼogige a ");
INSERT INTO ibo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ma Chineke kwuru sị, ‘Unu erila mkpụrụ si nʼosisi dị nʼetiti ogige a, unu emetụkwala ya aka, ka unu ghara ịnwụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Agwọ gwara nwanyị ahụ sị, “Unu agaghị anwụ. ");
INSERT INTO ibo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nʼihi na Chineke maara na ọ bụrụ na unu erie ya, anya unu ga-emeghe, unu ga-amata ezi ihe na ajọ ihe.” ");
INSERT INTO ibo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nwanyị ahụ hụrụ na mkpụrụ si nʼosisi ahụ dị mma iri eri, na ọ dị mma nʼanya, na ọ bụ osisi mara mma e si enweta amamihe. Ọ ghọọrọ mkpụrụ ahụ rie, nyekwa di ya, onye nke na ya nọ, o rie. ");
INSERT INTO ibo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mgbe ahụ, anya ha abụọ meghere, ha chọpụtara na ha gba ọtọ. Ya mere, ha dụkọtara ahịhịa fiig, jiri ya mere onwe ha akwa. ");
INSERT INTO ibo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mgbe nwoke ahụ na nwunye ya nụrụ ụda njegharị Onyenwe anyị Chineke nʼogige ahụ nʼoge uhuruchi, ha zoro onwe ha site nʼebe Onyenwe anyị Chineke nọ nʼetiti osisi ndị dị nʼogige ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma Onyenwe anyị Chineke kpọrọ nwoke ahụ oku sị ya, “Ebee ka ị nọ?” ");
INSERT INTO ibo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ọ zara si, “Anụrụ m ụda ụkwụ gị nʼogige, nʼihi ya, atụrụ m ụjọ, ebe ọ bụ na m gba ọtọ. Ezokwara m onwe m.” ");
INSERT INTO ibo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Onyenwe anyị Chineke jụrụ ya sị, “Onye gwara gị na ị gba ọtọ? I riela mkpụrụ si nʼosisi ahụ m nyere gị iwu sị gị erila?” ");
INSERT INTO ibo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nwoke ahụ sịrị, “Nwanyị ahụ i mere ka mụ na ya nọdụ, ọ bụ ya nyere m mkpụrụ sitere nʼosisi ahụ, m rie.” ");
INSERT INTO ibo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mgbe ahụ, Onyenwe anyị Chineke sịrị nwanyị ahụ, “Gịnị bụ ihe a i mere?” Nwanyị ahụ zara sị, “Ọ bụ agwọ ghọgburu m, mee m ka m rie ya.” ");
INSERT INTO ibo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ya mere, Onyenwe anyị Chineke gwara agwọ ahụ sị, “Nʼihi ihe a i mere, “Ihe a bụrụ ọnụ ka ị bụ nʼetiti anụ ụlọ niile na nʼetiti anụ ọhịa niile. Afọ gị ka ị ga-eji na-aga ije, aja ka ị ga na-eri ogologo ụbọchị ndụ gị niile. ");
INSERT INTO ibo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aga m eme ka iro dịrị nʼetiti gị na nwanyị ahụ, nʼetiti mkpụrụ gị na mkpụrụ ya, mkpụrụ ya ga-etipịa gị isi, gị onwe gị ga-ata ya arụ nʼikiri ụkwụ.” ");
INSERT INTO ibo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ọ gwara nwanyị ahụ sị ya, “Aga m eme ka ihe mgbu nke ịmụ nwa gị baa ụba nke ukwuu, ọ bụ site nʼihe mgbu ka ị ga-eji mụpụta ụmụ gị. Ọchịchọ nke obi gị ga-adị nʼaka di gị, ọ bụ ya ga-achịkwa gị.” ");
INSERT INTO ibo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ọ gwara Adam sị, “Nʼihi na ị ṅara nwunye gị ntị, rie mkpụrụ site nʼosisi ahụ m nyere gị iwu sị, ‘Gị erila mkpụrụ sitere na ya,’ “Ala bụ ihe a bụrụ ọnụ nʼihi gị, site nʼoke ndọgbu nʼọrụ ka ị ga-eri ihe si na ya pụta ogologo ụbọchị ndụ gị niile. ");
INSERT INTO ibo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ọ ga-erupụtara gị ogwu na uke, ị ga-erikwa ahịhịa nke ubi. ");
INSERT INTO ibo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Site nʼọsụsọ nke ga-agbapụta gị nʼihu ka ị ga-eri nri gị tutu ruo mgbe ị lọghachiri nʼala ebe ọ bụ site nʼala ka e si mepụta gị nʼihi na aja ka ị bụ, nʼaja ka ị ga-alaghachikwa.” ");
INSERT INTO ibo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam gụrụ nwunye ya Iiv, nʼihi na ọ bụ nne mmadụ niile dị ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Emesịa, Onyenwe anyị Chineke weere akpụkpọ anụ meere Adam na nwunye ya uwe oyiyi. ");
INSERT INTO ibo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Onyenwe anyị Chineke sịrị, “Lee, mmadụ adịla ka onye ọbụla nʼime anyị site nʼịmata ihe ọma na ihe ọjọọ. Ugbu a, ka ọ gharakwa ị setịpụ aka ya ghọrọ mkpụrụ osisi ahụ na-enye ndụ rie, si otu a dịrị ndụ ruo mgbe ebighị ebi.” ");
INSERT INTO ibo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nʼihi nke a, Onyenwe anyị Chineke chụpụrụ ya site nʼogige Iden ka ọ gaa na-arụ ọrụ nʼala e si wepụta ya. ");
INSERT INTO ibo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mgbe ọ chụpụrụ mmadụ, o dochiri nʼọwụwa anyanwụ nke ogige Iden ndị mmụọ ozi dị ike a na-akpọ Cherubim, na mma agha na-acha ọkụ, ka ha na-eche ọnụ ụzọ e si aba nʼebe osisi ahụ na-enye ndụ dị nche. ");
INSERT INTO ibo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Emesịa, Adam na nwunye ya Iiv dinakọrọ dịka di na nwunye. Iiv tụụrụ ime mụọ nwa nwoke, onye ha gụrụ Ken. Iiv sịrị, “Site nʼinyeaka Onyenwe anyị, amụtala m nwa nwoke!” ");
INSERT INTO ibo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Emesịa Iiv mụtara nwanne ya nwoke Ebel. Ebel ghọrọ onye na-azụ igwe atụrụ. Ma Ken ghọrọ onye ọrụ ubi. ");
INSERT INTO ibo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mgbe ụfọdụ oge gasịrị, Ken wetaara Onyenwe anyị ụfọdụ ihe ubi ya dịka onyinye. ");
INSERT INTO ibo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Ebel, ya onwe ya nyekwara onyinye site nʼigwe ewu na atụrụ ya e bụ ụzọ mụọ, nke mara abụba. Onyenwe anyị nabatara Ebel na onyinye ya, ");
INSERT INTO ibo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ma ọ nabataghị Ken na onyinye ya. Nke a wutere Ken, mee ka o wee iwe dị ukwuu. Ihu ya agbarụọ. ");
INSERT INTO ibo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ma Onyenwe anyị jụrụ ya sị, “Gịnị mere i ji ewe iwe? Gịnị mere ihu gị ji gbarụọ? ");
INSERT INTO ibo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ọ bụrụ na i mee ihe ziri ezi, agaghị anabata gị? Ọ bụrụkwanụ na ị jụ ime ihe ziri ezi, mmehie nọ nʼọnụ ụzọ na-eche gị ịla gị nʼiyi. Lezie anya hụ na i meriri ya.” ");
INSERT INTO ibo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ken gwara nwanne ya Ebel sị, “Bịa soro m ka anyị banye ọhịa.” Mgbe ha nọ nʼebe ahụ, Ken jidere nwanne ya gbuo ya. ");
INSERT INTO ibo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Emesịa, Onyenwe anyị jụrụ Ken ajụjụ sị, “Ebee ka Ebel nwanne gị nwoke nọ?” Ọ zaghachiri, “Amaghị m. Abụ m onye nche nwanne m?” ");
INSERT INTO ibo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma Onyenwe anyị zara sị ya, “Gịnị ka i mere? Gee ntị, ọbara nwanne gị na-akpọku m site nʼala. ");
INSERT INTO ibo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Site ugbu a gaa nʼihu ị bụrụla onye a bụrụ ọnụ, na onye e si nʼala chụpụ, ala ahụ meghepụrụ ọnụ ya nabata ọbara nwanne gị, site nʼaka gị. ");
INSERT INTO ibo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mgbe ị kụrụ ihe ọbụla nʼime ya, ala agaghị enye gị mkpụrụ ya nʼuju. Site ugbu a gaa nʼihu, ị ga-abụ onye na-awagharị awagharị na onye na-abaghị nʼihe nʼụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ken zara Onyenwe anyị, “Ntaramahụhụ i nyere m dị ukwuu karịa nke m nwere ike ibu. ");
INSERT INTO ibo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ugbu a, abụ m onye i si nʼala ubi ya chụpụ. Abụkwa m onye i si nʼihu gị chụpụ. Bido taa aga m abụ onye na-awagharị awagharị nʼime ụwa. Onye ọbụla hụkwara m ga-egbu m.” ");
INSERT INTO ibo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Onyenwe anyị zara sị ya, “O nweghị onye ga-egbu gị, nʼihi na aga m atụkwasịrị onye ọbụla metụrụ gị aka ntaramahụhụ okpukpu asaa karịa nke m nyere gị.” Ya mere, Onyenwe anyị kara Ken akara iji gbochie onye ọbụla hụrụ ya igbu ya. ");
INSERT INTO ibo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ken sitere nʼihu Onyenwe anyị pụọ gaa biri nʼala Nọd, obodo dị nʼakụkụ ọwụwa anyanwụ Iden. ");
INSERT INTO ibo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ken na nwunye ya dinakọrọ, nwunye ya tụụrụ ime mụta nwa nwoke aha ya bụ Enọk. Nʼoge a, Ken nọ na-ewu otu obodo ọ gụrụ Enọk, nke bụ aha nwa ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enọk bụ nna Irad, Irad bụ nna Mehujael, Mehujael bụ nna Metusael, Metusael abụrụ nna Lamek. ");
INSERT INTO ibo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek lụrụ ụmụ nwanyị abụọ. Aha nwunye ya nke mbụ bụ Ada. Aha nke ọzọ bụ Zila. ");
INSERT INTO ibo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada mụtara Jabal, onye bụ nna ndị na-azụ anụ ụlọ, na ndị na-ebi nʼụlọ ikwu. ");
INSERT INTO ibo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Aha nwanne ya nwoke bụ Jubal, onye mbụ bụ nna ndị na-akpọ ụbọ akwara, na ndị na-afụ opi. ");
INSERT INTO ibo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila, mụtara otu nwa nwoke aha ya bụ Tubal Ken, onye bụ nna ndị niile na-akpụ ihe dị iche iche e ji bronz maọbụ igwe kpụọ. Aha nwanne nwanyị Tubal Ken bụ Naama. ");
INSERT INTO ibo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek kpọrọ ndị nwunye ya sị ha, “Geenụ m ntị, Ada na Zila, unu ndị nwunye Lamek, nụrụ okwu sị m nʼọnụ. Egbuola m otu nwoke nʼihi na ọ merụrụ m ahụ, otu nwokorobịa nʼihi na ọ mehịara m ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ọ bụrụ na a ga-abọtara Ken ọbọ ugboro asaa, mgbe ahụ, a ga-abọtara Lamek ọbọ iri ugboro asaa na asaa.” ");
INSERT INTO ibo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam na Iiv dinakọrọ ọzọ, Iiv tụụrụ ime mụta nwa nwoke ọ gụrụ Set. Nʼihi na Iiv kwuru sị, “Chineke enyela m nwa nwoke ọzọ nʼọnọdụ Ebel onye Ken gburu.” ");
INSERT INTO ibo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set mụtara nwa nwoke gụọ ya Enọsh. Nʼoge ahụ ka ụmụ mmadụ bidoro ịkpọku aha Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nke a bụ usoro ihe ndepụta banyere agbụrụ Adam. Mgbe Chineke kere mmadụ, o kere ya nʼoyiyi Chineke. ");
INSERT INTO ibo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","O kere ha nwoke na nwanyị, gọziekwa ha. Mgbe e kere ha, ọ kpọrọ ha mmadụ. ");
INSERT INTO ibo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mgbe Adam gbara narị afọ na iri afọ atọ, ọ mụrụ nwa ya nwoke nʼoyiyi nke ya, na nʼụdịdị nke ya. Ọ gụrụ ya Set. ");
INSERT INTO ibo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Site nʼoge a mụrụ Set, Adam dịrị ndụ narị afọ asatọ ọzọ, ọ mụrụ ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam nwụrụ mgbe ọ gbara narị afọ itoolu na iri afọ atọ. ");
INSERT INTO ibo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set gbara narị afọ na ise mgbe ọ ghọrọ nna Enọsh, ");
INSERT INTO ibo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Mgbe ọ ghọchara nna Enọsh, Set dịrị ndụ ruo narị afọ asatọ na asaa ọzọ, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set nwụrụ mgbe ọ gbara narị afọ itoolu na iri afọ na abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mgbe Enọsh gbara iri afọ itoolu, ọ ghọrọ nna Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mgbe ọ ghọchara nna Kenan, Enọsh dịrị ndụ narị afọ asatọ na iri afọ na ise, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enọsh nwụkwara mgbe ọ nọzuru narị afọ itoolu na afọ ise. ");
INSERT INTO ibo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mgbe Kenan gbara iri afọ asaa ka ọ ghọrọ nna Mahalalel. ");
INSERT INTO ibo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mgbe ọ ghọchara nna Mahalalel, Kenan dịrị ndụ narị afọ asatọ na iri afọ anọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan nwụrụ mgbe ọ gbara narị afọ itoolu na afọ iri. ");
INSERT INTO ibo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mgbe Mahalalel gbara iri afọ isii na afọ ise ka ọ ghọrọ nna Jared. ");
INSERT INTO ibo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mgbe ọ ghọchara nna Jared, Mahalalel dịrị ndụ narị afọ asatọ na iri afọ atọ, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel nwụrụ mgbe ọ gbara narị afọ asatọ na iri afọ itoolu na ise. ");
INSERT INTO ibo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mgbe Jared dị narị afọ na iri afọ isii na abụọ ka ọ ghọrọ nna Enọk. ");
INSERT INTO ibo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mgbe ọ ghọchara nna Enọk, Jared dịrị ndụ narị afọ asatọ ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared nwụrụ mgbe ọ gbara narị afọ itoolu na iri afọ isii na abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mgbe Enọk gbara iri afọ isii na afọ ise ka ọ ghọrọ nna Metusela. ");
INSERT INTO ibo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mgbe ọ ghọchara nna Metusela, Enọk soro ụzọ Chineke narị afọ atọ. Nʼoge a, ọ mụtara ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ọnụọgụgụ nke afọ niile Enọk biri ndụ, bụ narị afọ atọ na iri afọ isii na ise. ");
INSERT INTO ibo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enọk soro ụzọ Chineke ruo na a hụkwaghị ya nʼihi na Chineke kpọọrọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mgbe Metusela gbara narị afọ na iri afọ asatọ na asaa ka ọ ghọrọ nna Lamek. ");
INSERT INTO ibo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mgbe ọ ghọchara nna Lamek, Metusela dịrị ndụ narị afọ asaa na iri afọ asatọ na abụọ ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela nwụrụ mgbe ọ gbara narị afọ itoolu na iri afọ isii na itoolu. ");
INSERT INTO ibo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mgbe Lamek gbara narị afọ na iri afọ asatọ na abụọ ka ọ mụtara nwa nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek gụrụ ya Noa, nʼihi na ọ sịrị: “Ọ ga-akasị anyị obi nʼime oke ọrụ na ndọgbu anyị na-adọgbu onwe anyị nʼọrụ nʼala a Onyenwe anyị bụrụ ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mgbe a mụsịrị Noa, Lamek dịrị ndụ narị afọ ise na iri afọ itoolu na ise ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek nwụrụ mgbe ọ gbara narị afọ asaa na iri afọ asaa na asaa. ");
INSERT INTO ibo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mgbe Noa gbara narị afọ ise ọ ghọrọ nna Shem, Ham na Jafet. ");
INSERT INTO ibo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mgbe ndị mmadụ bidoro mụbaa nʼụwa, mgbe a mụtakwaara ha ọtụtụ ụmụ ndị inyom, ");
INSERT INTO ibo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ka ụmụ ndị ikom Chineke bidoro ilekwasị ụmụ ndị inyom ndị mmadụ anya, hụ na ha mara mma. Ha duuru ndị inyom ọbụla masịrị ha ka ha bụrụ nwunye ha. ");
INSERT INTO ibo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mgbe ahụ, Onyenwe anyị sịrị, “Mmụọ m na mmadụ agaghị anọgide nʼịgba mgba nʼime mmadụ ruo ebighị ebi, nʼihi na mmadụ efu ka ọ bụ. Ọnụọgụgụ ndụ ya ga-abụ narị afọ na iri afọ abụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ndị Nefilim nọ nʼụwa nʼoge ahụ, ma nʼoge sotere ya mgbe ahụ, ụmụ ndị ikom Chineke na-abakwuru ndị inyom ụmụ mmadụ, site na mmekọrịta dị otu a mụọ ụmụ. Ndị a bụ ndị dike mgbe ochie ahụ, ndị a ma ama. ");
INSERT INTO ibo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Onyenwe anyị hụrụ otu ịba ụba nke ajọ omume mmadụ si dị ukwuu, hụkwa na echiche uche nke obi ya niile dị naanị nʼime ihe ọjọọ, mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","O wutere Onyenwe anyị nke ukwuu na o kere mmadụ, mkpụrụobi ya jupụtakwara nʼihe mgbu. ");
INSERT INTO ibo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nʼihi ya, Onyenwe anyị sịrị, “Aga m esi nʼụwa kpochapụ mmadụ niile m kere eke. E e, mmadụ na anụmanụ niile, na ihe e kere eke na-akpụgharị nʼelu ala, na anụ ufe niile. Nʼihi na o wutere m na m kere ha.” ");
INSERT INTO ibo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma Noa nwetara ihuọma nʼanya Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nke a bụ akụkọ banyere usoro ndụ Noa na ezinaụlọ ya. Noa bụ onye ezi omume. Onye na-enweghị ịta ụta ọbụla nʼetiti ndị bi nʼoge ya. O mere ihe nʼụzọ Chineke chọrọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa mụtara ụmụ ndị ikom atọ aha ha bụ, Shem, Ham, na Jafet. ");
INSERT INTO ibo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ma nʼanya Chineke, ụwa bụ ihe rụrụ arụ, jupụtakwa nʼihe ike. ");
INSERT INTO ibo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Chineke hụrụ otu ụwa si jọgbuo onwe ya na njọ, hụkwa na ụmụ mmadụ bụ ndị ihe ọjọọ riri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Chineke sịrị Noa, “Aga m ebibi ihe niile bụ mmadụ, nʼihi na ụwa jupụtara nʼihe ike nʼihi omume mmadụ. E e, aga m ebibi ụwa na ndị niile nọ nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ya mere, jiri osisi gofa wuore onwe gị ụgbọ mmiri. Rụnye ọtụtụ ọnụụlọ nʼime ya. Jiri korota techie elu ya na ime ya. ");
INSERT INTO ibo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Otu a ka i ga-esi wuo ya: mee ka ogologo ụgbọ mmiri ahụ dịrị narị mita na iri mita anọ, obosara ya dịrị iri mita abụọ na atọ, ịdị elu ya dịrị mita iri na atọ na ọkara. ");
INSERT INTO ibo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Meere ụgbọ mmiri ahụ ihe e ji ekpuchi elu ya. Mekwa oghere ga-adị ọkara mita site nʼebe ihe mkpuchi elu ụgbọ mmiri ahụ gbadata. Tinye ọnụ ụzọ nʼakụkụ ụgbọ mmiri ahụ, ma rụọkwa okpukpu nkwasa atọ, nke ala ala, nke etiti na nke elu elu. ");
INSERT INTO ibo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nʼihi na aga m eweta uju mmiri nʼụwa, ibibi ihe niile nwere ndụ dị nʼokpuru eluigwe. Ihe niile e kere eke na-eku ume ndụ ga-anwụ. Ihe niile nọ nʼụwa ga-ala nʼiyi. ");
INSERT INTO ibo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma aga m eme ka ọgbụgba ndụ m dịrị gị. Ị ga-abanye nʼụgbọ mmiri ahụ, gị na ụmụ gị ndị ikom, na nwunye gị, na ndị nwunye ụmụ gị ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ị ga-ewebata ihe niile e kere eke dị ndụ, abụọ abụọ, oke na nwunye, ichebe ha ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ụdị nnụnụ dị iche iche, abụọ abụọ, na ụdị anụmanụ ọbụla dị iche iche, na ụdị anụ na-akpụ akpụ dị iche iche, ga-abịakwute gị ka i debe ha ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ị ga-ewebata ụdị nri dị iche iche a na-eri eri, chịkọtaa ha ka ọ bụrụ nri nke gị na nke ha.” ");
INSERT INTO ibo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa mere ihe niile dịka Chineke nyere ya iwu ime. ");
INSERT INTO ibo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mgbe ụbọchị ahụ zuru, Onyenwe anyị kpọrọ Noa sị ya, “Baa nʼime ụgbọ mmiri, gị na ezinaụlọ gị niile, nʼihi na nʼime ndị niile bi nʼọgbọ a, ọ bụ naanị gị bụ onye ezi omume m hụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kpọrọ ụmụ anụmanụ ndị a a gụrụ dịka ndị dị ọcha, dịka ụdị ha si dị asaa asaa, oke na nwunye. Otu a kwa, kpọrọkwa ụmụ anụmanụ ndị a gụrụ dịka ndị na-adịghị ọcha, dịka ụdị ha si dị, abụọ abụọ, oke na nwunye, ");
INSERT INTO ibo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","na ụmụ anụ ufe asaa asaa, dịka ụdị ha si dị, oke na nwunye, maka idebe ụdị ndị a niile ndụ nʼụwa. ");
INSERT INTO ibo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nʼihi na ụbọchị asaa site taa, aga m ezidata mmiri ozuzo nʼụwa. Mmiri a ga-ezo iri ụbọchị anọ, ehihie na abalị. Aga m ekpochapụ site nʼelu ụwa ihe niile nwere ndụ nke m kere.” ");
INSERT INTO ibo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ya mere, Noa mere ihe niile Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa gbara narị afọ isii mgbe mmiri ukwu a bidoro izo nʼelu ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa banyere nʼụgbọ mmiri ahụ, ya na ụmụ ya ndị ikom na nwunye ya, na ndị nwunye ụmụ ya ndị ikom ịgbanarị uju mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ụmụ anụmanụ ndị dị ọcha, na ndị na-adịghị ọcha, abụọ abụọ, tinyere anụ ufe na ihe niile e kere eke na-akpụgharị nʼala, abụọ abụọ kwa, ");
INSERT INTO ibo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","oke na nwunye, bịakwutere Noa soro ya banye nʼụgbọ mmiri ahụ, dịka Chineke nyere Noa nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mgbe abalị asaa gafere, uju mmiri ahụ bịakwasịrị ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nʼafọ narị isii nke ndụ Noa, nʼọnwa nke abụọ, nʼụbọchị nke iri na asaa, bụ ụbọchị isi iyi niile dị nʼime ime ala nupụtara nʼelu ala, mmiri niile dị na mbara eluigwe ka a hapụrụ ka ha wụdata nʼụwa. ");
INSERT INTO ibo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mmiri zogịdere na-esepụghị aka iri ụbọchị anọ, ehihie na abalị. ");
INSERT INTO ibo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nʼụbọchị ahụ kpomkwem, Noa banyere nʼụgbọ mmiri ahụ, ya na Shem, Ham na Jafet, bụ ụmụ Noa, na nwunye Noa, na ndị nwunye atọ nke ụmụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ha onwe ha, na anụ ọhịa ọbụla, nʼụdị ya, na anụ ụlọ ọbụla, nʼụdị ya na ihe ọbụla e kere eke na-akpụgharị nʼala, nʼụdị ya, na anụ ufe ọbụla nʼụdị ya, na aha nnụnụ ọbụla na ihe ọbụla nwere nku. ");
INSERT INTO ibo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ha bịakwutere Noa nʼime ụgbọ mmiri ahụ, abụọ abụọ site nʼihe niile ọbụla e kere eke, nke nwere ume ndụ nʼime ha. ");
INSERT INTO ibo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ma ndị banyerenụ bụ oke na nwunye, site na ihe niile nwere ndụ dịka Chineke nyere ya nʼiwu. Mgbe ahụ, Onyenwe anyị mechiri ọnụ ụzọ dị nʼụgbọ mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Uju mmiri nọgidere nʼụwa iri ụbọchị anọ. Mgbe mmiri ndị a na-aba ụba, ha buliri ụgbọ mmiri ahụ elu site nʼelu ala. ");
INSERT INTO ibo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mmiri ndị a toro na-ala elu na-abawanyekwa ụba nʼelu ụwa. Ụgbọ mmiri ahụ segooro nʼelu mmiri. ");
INSERT INTO ibo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mmiri ndị ahụ toro laa elu kpuchie ugwu ukwu niile dị nʼokpuru mbara eluigwe. ");
INSERT INTO ibo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mmiri ndị a toro kpuchiri ugwu niile, ruo na ịla elu mmiri ndị a site nʼelu ugwu ukwu niile ruru mita asaa. ");
INSERT INTO ibo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ihe niile nwere ndụ nke na-ejegharị nʼelu ụwa kubiri ume. Anụ ufe, na anụ ụlọ, na anụ ọhịa, na ihe niile e kere eke jupụtara nʼụwa, na ụmụ mmadụ niile. ");
INSERT INTO ibo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ee, ihe niile na-eku ume nke bi nʼelu ala nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ihe niile nwere ume ndụ nʼelu ụwa ka e kpochapụrụ. Mmadụ na anụmanụ, na anụ na-akpụgharị nʼala na nnụnụ niile. A lara ha niile nʼiyi. Ma ọ bụ naanị Noa na ndị niile so ya nọdụ nʼụgbọ mmiri ahụ ka a hapụrụ ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Narị ụbọchị na iri ụbọchị ise ka mmiri dọọrọ nʼelu ụwa dum. ");
INSERT INTO ibo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma Chineke chetara Noa na ụmụ anụ ọhịa niile, na ụmụ anụ ụlọ niile so ya nọdụ nʼụgbọ mmiri ahụ. O zitere ifufe, mee ka o fee nʼelu mmiri ahụ ime ka mmiri ahụ bido ịta. ");
INSERT INTO ibo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","A kpọchiri isi iyi mmiri niile dị nʼime ime ala, kpọchiekwa ọnụ ụzọ mmiri ozuzo nke mbara eluigwe. Mmiri kwụsịrị isi na mbara eluigwe na-ezokwasị ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mmiri ahụ dị nʼụwa ji nwayọọ na-ata. Mgbe narị ụbọchị na iri ụbọchị ise gafesịrị, mmiri ahụ atalatala. ");
INSERT INTO ibo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nʼụbọchị iri na asaa nke ọnwa asaa, ụgbọ mmiri ahụ gara nọkwasị nʼelu ugwu Ararat. ");
INSERT INTO ibo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mmiri a gara nʼihu na-ata ruo ọnwa nke iri. Nʼụbọchị nke mbụ nke ọnwa iri, e bidoro ịhụ elu ugwu ndị ọzọ anya. ");
INSERT INTO ibo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mgbe iri ụbọchị anọ gafere, Noa meghere oghereikuku ọ rụnyere nʼakụkụ ụgbọ mmiri ahụ, ");
INSERT INTO ibo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","site nʼebe ahụ zipụ otu ugolọma nke na-efepụ na-efebatakwa, tutu ruo mgbe mmiri kọrọ nʼelu ala. ");
INSERT INTO ibo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Emesịa, o zipụrụ otu nduru iji mata ma mmiri ọ kọọla nʼala, ");
INSERT INTO ibo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ma nduru ahụ achọtaghị ebe o nwere ike ibe, nʼihi na mmiri ka tojuru elu ụwa niile. Nʼihi ya, nduru ahụ lọghachikwutere Noa nʼime ụgbọ ahụ. Noa setịpụrụ aka ya nwụbata nduru ahụ nʼụgbọ. ");
INSERT INTO ibo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Mgbe abalị asaa gafere, Noa zipụrụ nduru ahụ ọzọ ");
INSERT INTO ibo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nʼoge anyasị, nduru a lọghachiri. Ọ kpụ akwụkwọ oliv ọhụrụ ọ kụbitere nʼọnụ ya. Nke a gosiri Noa na mmiri ahụ ataala nʼelu ala. ");
INSERT INTO ibo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mgbe abalị asaa gafere, Noa zipụkwara nduru ahụ ọzọ. Ma nʼoge a, ọ lọtakwaghị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nʼụbọchị mbụ nke ọnwa mbụ nʼafọ narị isii na otu nke ndụ Noa, mmiri ahụ atachaala nʼelu ala. Mgbe ahụ, Noa kpughepụrụ ihe mkpuchi nke ụgbọ mmiri ahụ, hụ na mmiri atachaala nʼelu ala. ");
INSERT INTO ibo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ma ọ bụ nʼụbọchị iri abụọ na asaa nke ọnwa abụọ ka mmiri ji takọrọchaa nʼelu ala. ");
INSERT INTO ibo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mgbe ahụ, Chineke gwara Noa okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Site nʼụgbọ mmiri pụta, gị na nwunye gị, na ụmụ gị ndị ikom, na ndị nwunye ụmụ gị ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kpọpụta anụ niile dị ndụ nke gị na ha nọ, anụ ufe, na ụmụ anụmanụ, na ihe e kere eke niile na-akpụgharị nʼala, ka ha gaa nʼụwa mụọ ọmụmụ, baa ụba, jupụta nʼelu ya.” ");
INSERT INTO ibo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ya mere, Noa si nʼụgbọ mmiri ahụ pụta, ya na ụmụ ya, na nwunye ya, na ndị nwunye ụmụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma anụmanụ niile ọbụla nke dị ndụ, na ihe niile na-akpụgharị nʼala, na anụ ufe niile, ihe niile na-ejegharị nʼụwa, ka ụdị ha si dị, sitere nʼụgbọ mmiri ahụ pụta. ");
INSERT INTO ibo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Mgbe ahụ, Noa wuru ebe ịchụ aja nye Onyenwe anyị. Ọ họọrọ site nʼanụ ụlọ ndị dị ọcha na anụ ufe ndị dị ọcha chụọ aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Onyenwe anyị nụrụ isisi ụtọ nke aja nsure ọkụ ahụ kwuo nʼobi ya sị, “Agaghị m abụ ala ọnụ ọzọ nʼihi mmadụ, ebe ọ bụ na izuzu obi mmadụ bụ ime ihe ọjọọ site na mgbe ọ bụ nwata, agakwaghị m ala ihe niile e kere eke na-eku ume ndụ iyi ọzọ, dịka m mere. ");
INSERT INTO ibo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ogologo oge niile ụwa ga-anọgide, oge ịkụ mkpụrụ na oge iwe ihe ubi, oge oyi na oge okpomọkụ, ọkọchị na udu mmiri, ehihie na abalị, agaghị ebi.” ");
INSERT INTO ibo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mgbe ihe ndị a gasịrị, Chineke gọziri Noa na ụmụ ya sị ha: “Mụọnụ, baanụ, jupụtanụ nʼụwa. ");
INSERT INTO ibo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Egwu unu na ụjọ unu ga-adakwasị anụmanụ niile nke ụwa nke dị ndụ, na anụ ufe niile nke eluigwe, na ihe e kere eke niile na-akpụgharị nʼala, na azụ niile dị nʼosimiri. Ewerela m ha niile nyefee unu nʼaka. ");
INSERT INTO ibo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ihe ọbụla dị ndụ nke na-ejegharị ejegharị ga-abụ nri unu. Enyela m unu ihe niile ugbu a dịka m si nye unu ahịhịa ndụ niile. ");
INSERT INTO ibo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ma unu agaghị eri anụ ọbụla nke ọbara ndụ ya dị ya nʼahụ. ");
INSERT INTO ibo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma gbasara ọbara ndụ unu, unu ga-asara ọnụ unu nʼihu m. Anụmanụ ọbụla ga-asara ọnụ ya nʼihu m. Mmadụ ọbụla kwa ga-asara ọnụ ya nʼihu m banyere ndụ mmadụ ibe ya. ");
INSERT INTO ibo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Onye ọbụla wufuru ọbara mmadụ, nʼaka mmadụ ka a ga-awụfu ọbara nke ya, nʼihi nʼoyiyi Chineke ka Chineke mere mmadụ. ");
INSERT INTO ibo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ma unu onwe unu, mịanụ mkpụrụ, mụbaanụ, jupụtanụ ụwa, baakwanụ ụba nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Chineke gwara Noa na ụmụ ya sị, ");
INSERT INTO ibo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ugbu a, ana m ehiwe ọgbụgba ndụ nʼetiti mụ na unu, na nʼetiti agbụrụ unu ndị ga-anọchi unu, ");
INSERT INTO ibo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na nʼetiti ihe niile nwere ndụ nke unu na ha so, ụmụ anụ ufe, na ụmụ anụ ụlọ, na ụmụ anụ ọhịa niile, ndị ahụ niile so unu si nʼụgbọ mmiri pụta, bụ ihe niile nwere ndụ nʼụwa. ");
INSERT INTO ibo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ebe ọ bụ na m ehiwela ọgbụgba ndụ m nʼetiti mụ na unu, ọ gaghị emekwa ọzọ na a ga-eji uju mmiri kpochapụ ihe niile e kere eke, ọ gaghị emekwa ọzọ na a ga-eji uju mmiri bibie ụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Chineke kwuru sị, “Nke a bụ ihe ama nke ọgbụgba ndụ nke m na-etinye nʼetiti mụ na unu, na nʼetiti ihe niile nwere ndụ so unu, ọgbụgba ndụ nke ga-adị nye ọgbọ niile na-abịa nʼihu. ");
INSERT INTO ibo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Etinyela m eke na egwurugwu m na mbara eluigwe, ka ọ bụrụ ihe ama nke ọgbụgba ndụ dị nʼetiti mụ na ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mgbe ọbụla m zitere igwe ojii nʼụwa, ọ bụrụ na eke na egwurugwu apụta ìhè na mbara eluigwe, ");
INSERT INTO ibo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","aga m echeta ọgbụgba ndụ m mere ka ọ dịrị nʼetiti mụ na unu, na nʼetiti mụ na ihe niile nwere ndụ site nʼihe niile e kere eke. Ọ gaghị emekwa ọzọ na mmiri ga-aghọ uju mmiri ibibi ihe niile nwere ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mgbe ọbụla eke na egwurugwu pụtara nʼigwe ojii, aga m ahụ ya cheta ọgbụgba ndụ ebighị ebi nke dị nʼetiti Chineke na ihe niile nwere ndụ site nʼihe niile e kere eke nọ nʼelu ụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Chineke gwara Noa sị, “Nke a bụ ihe ama ọgbụgba ndụ ahụ m hiwere nʼetiti mụ na ihe niile nwere ndụ nʼụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ụmụ ndị ikom Noa ndị si nʼụgbọ mmiri pụta bụ Shem, Ham na Jafet. (Ham bụ nna Kenan.) ");
INSERT INTO ibo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ndị a bụ ụmụ ndị ikom atọ Noa mụrụ. Ọ bụ site na ha ka ndị mmadụ niile gbasara nʼụwa niile si pụta. ");
INSERT INTO ibo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa, onye ọrụ ubi, bidoro ịkụ ubi vaịnị a gbara ogige. ");
INSERT INTO ibo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mgbe ọ ṅụrụ mmanya si nʼubi a, ṅụbiga ya oke, ọ gbaara ọtọ dinaa ala nʼime ụlọ ikwu ya. ");
INSERT INTO ibo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, nna Kenan, hụrụ ọtọ nna ya, gaa kọọrọ ụmụnne ya abụọ nọ nʼezi ihe ọ hụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma Shem na Jafet weere akwa tụkwasị nʼubu ha, were azụ jere ije ruo nʼebe nna ha nọ, hapụ akwa ahụ ka ọ dakwasị nna ha kpuchikwaa ọtọ ya. Ma ha chepuru ihu nʼebe ọzọ mgbe ha na-eme nke a, nʼihi ya, ha elekwasịghị ọtọ nna ha anya. ");
INSERT INTO ibo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mgbe Noa si nʼụra mmanya ya bilie, chọpụta ihe nwa ya nwoke nke nta mere, ");
INSERT INTO ibo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","o kwuru sị, “Onye a bụrụ ọnụ ka Kenan bụ! Ohu ndị ohu, ka ọ ga-abụrụ ụmụnne ya.” ");
INSERT INTO ibo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ọ sịkwara, “Ngọzị dịrị Onyenwe anyị Chineke Shem. Ka Kenan bụrụ ohu Shem. ");
INSERT INTO ibo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ka Chineke mee ka ebe obibi Jafet saa mbara, ka Jafet biri nʼụlọ ikwu Shem, meekwa ka Kenan bụrụ ohu ya.” ");
INSERT INTO ibo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mgbe uju mmiri ahụ gabigachara, Noa biri ndụ narị afọ atọ na iri afọ ise ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ọnụọgụgụ afọ Noa niile mgbe ọ nwụrụ, bụ narị afọ itoolu na iri afọ ise. ");
INSERT INTO ibo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ndị a bụ akụkọ banyere Shem, Ham na Jafet, ụmụ ndị ikom atọ Noa mụrụ. Ha onwe ha mụtara ụmụ nke aka ha, mgbe uju mmiri gafesịrị. ");
INSERT INTO ibo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ụmụ ndị ikom Jafet bụ: Goma, Magog, Madai, Javan, Tubal, Meshek na Tiras. ");
INSERT INTO ibo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ụmụ ndị ikom Goma bụ: Ashkenaz, Rifat na Togama. ");
INSERT INTO ibo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ụmụ ndị ikom Javan bụ: Elisha, Tashish, Kitim na Rodanim. ");
INSERT INTO ibo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Site nʼagbụrụ ndị a bi nʼakụkụ mmiri ka e nwetara mba dị iche iche, nʼagbụrụ ha nʼime obodo ha dị iche iche, ndị ọbụla nʼime ha nwekwara asụsụ nke ha.) ");
INSERT INTO ibo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ụmụ ndị ikom Ham bụ: Kush, Ijipt, Put na Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ụmụ ndị ikom Kush bụ: Seba, Havila, Sabta, Raama na Sabteka. Ụmụ ndị ikom Raama bụ: Sheba na Dedan. ");
INSERT INTO ibo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush bụ nna Nimrọd, onye mesịrị bụrụ dike nʼagha nʼụwa. ");
INSERT INTO ibo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ọ bụ dike nʼịchụ nta, nʼihu Onyenwe anyị. Ọ bụ nke a mere e ji na-ekwu okwu na-asị, “Ị dị ka Nimrọd, dike nʼịchụ nta, nʼihu Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Obodo ndị bụ mmalite alaeze ya bụ, Babel, Erek, Akad na Kalne, ndị dị nʼala Shaịna. ");
INSERT INTO ibo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Site nʼala ahụ ọ gara Asịrịa, ebe o wuru obodo Ninive na Rehobọt Ia, na Kala, ");
INSERT INTO ibo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Resin, nke dị nʼetiti Ninive na Kala, ya bụ obodo ukwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ijipt bụ nna ndị Lud, ndị Anam, ndị Lehab, ndị Naftuh, ");
INSERT INTO ibo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ndị Patrus, ndị Kasluh (onye ndị Filistia sitere na ya) na ndị Kafto. ");
INSERT INTO ibo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan bụ nna Saịdọn, ọkpara ya, na ndị Het, ");
INSERT INTO ibo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ndị Jebus, ndị Amọrait, ndị Gigash, ");
INSERT INTO ibo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ndị Hiv, ndị Aka, ndị Sini, ");
INSERT INTO ibo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ndị Avad, ndị Zema na ndị Hamat. Emesịa, ndị ikwu Kenan gbasara, ");
INSERT INTO ibo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","oke ala ndị Kenan sitere na Saịdọn ruo Gera, gbatịa ruo Gaza, ruokwa Sọdọm, Gọmọra, Adma na Zeboiim, nke dị nso Lasha. ");
INSERT INTO ibo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ndị a bụ ụmụ ndị ikom Ham, dịka ikwu ha na asụsụ ha si dị, nʼoke ala ebe ha bi, na obodo ha dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A mụụrụ Shem ụmụ ndị ikom, onye nwanne nwoke nke tọrọ ya bụ Jafet. Ọ bụkwa nna nna ochie ụmụ ndị ikom niile Eba mụtara. ");
INSERT INTO ibo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ụmụ ndị ikom Shem bụ Elam, Ashua, Apakshad, Lud na Aram. ");
INSERT INTO ibo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ụmụ ndị ikom Aram bụ, Uz, Hul, Geta na Meshek. ");
INSERT INTO ibo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakshad bụ nna Shela, Shela bụrụ nna Eba. ");
INSERT INTO ibo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba mụtara ụmụ ndị ikom abụọ: Aha otu nʼime ha bụ Peleg, nʼihi na ọ bụ nʼoge ndụ ya ka e kewara ụwa. Aha nwanne ya nwoke bụ Joktan. ");
INSERT INTO ibo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan bụ nna Almodad, Shelef, Hazamavet, Jera, ");
INSERT INTO ibo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Ụzal, Dikla, ");
INSERT INTO ibo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO ibo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ọfịa, Havila na Jobab. Ndị a niile bụ ụmụ ndị ikom Joktan. ");
INSERT INTO ibo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Akụkụ ala ha bi gbasapụrụ site na Mesha ruo Sefa nʼala ugwu ugwu nke ọwụwa anyanwụ. ");
INSERT INTO ibo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ndị a niile bụ ụmụ ndị ikom Shem, dịka ikwu ha na asụsụ ha si dị, nʼoke ala ebe ha dị, na obodo ha dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ndị a bụ ndị ikwu ụmụ Noa ndị ikom dịka usoro ọmụmụ ha si dị, dịka ha si biri na mba dị iche iche. Ọ bụ site na ndị a ka mba niile si gbasasịa ruo akụkụ niile nke ụwa mgbe uju mmiri ahụ gafechara. ");
INSERT INTO ibo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nʼoge ahụ, ụwa niile nwere naanị otu asụsụ, okwu niile bụkwa otu. ");
INSERT INTO ibo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mgbe ndị mmadụ gbasara nʼakụkụ ọwụwa anyanwụ ha chọtara ala dị larịị na Shaịna biri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ha gwarịtara onwe ha okwu sị, “Bịanụ ka anyị kpụọ brik, kpọọ ha ọkụ nke ọma.” Ya mere, ha kpụrụ brik kama nkume, jirikwa bitumen kama ụrọ. ");
INSERT INTO ibo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Mgbe ahụ, ha kwuru sị, “Bịanụ ka anyị wuore onwe anyị obodo na ụlọ elu, nke elu ya ga-eru nʼeluigwe, ka anyị si otu a meere onwe anyị aha, ka anyị ghara ịbụ ndị a ga-agbasa nʼụwa niile.” ");
INSERT INTO ibo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Onyenwe anyị rịdatara hụ obodo ahụ na ụlọ elu ahụ ndị mmadụ na-ewu. ");
INSERT INTO ibo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Onyenwe anyị sịrị, “Lee! Ọ bụrụ na ha malitere ime ihe dị otu a, ugbu a ha bụ otu ndị, nweekwa otu asụsụ, o nweghị ihe ha zubere ime nke ha na-apụghị ime. ");
INSERT INTO ibo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ngwa, ka anyị rịda gaa gbarụọ asụsụ ha, ka onye o bụla ghara ịghọta asụsụ ibe ya.” ");
INSERT INTO ibo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Onyenwe anyị mere ka ha gbasaa nʼelu ụwa niile. Ha kwụsịkwara iwu obodo ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ọ bụkwa nke a mere e ji kpọọ obodo ahụ Babel nʼihi na ọ bụ nʼebe ahụ ka Onyenwe anyị wetara ọgbaaghara nʼasụsụ ndị niile bi nʼụwa. Ọ bụkwa nʼebe ahụ ka Onyenwe anyị si gbasasịa ha nʼelu ụwa dum. ");
INSERT INTO ibo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nke a bụ akụkọ banyere usoro ezinaụlọ Shem. Mgbe afọ abụọ gafechara site nʼoge uju mmiri ahụ, nʼoge Shem gbara narị afọ, ọ mụtara Apakshad. ");
INSERT INTO ibo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem dịrị ndụ, mgbe ọ mụsịrị Apakshad, narị afọ ise ọzọ, mụtakwa ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mgbe Apakshad gbara iri afọ atọ na ise, ọ mụtara Shela. ");
INSERT INTO ibo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Mgbe ọ mụchara Shela, ọ dịrị ndụ narị afọ anọ na atọ ọzọ, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela gbara iri afọ atọ mgbe ọ mụrụ nwa ya nwoke Eba. ");
INSERT INTO ibo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Mgbe ọ ghọrọ nna Eba, ọ dịrị ndụ narị afọ anọ na atọ, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eba gbara iri afọ atọ na anọ mgbe ọ mụrụ Peleg. ");
INSERT INTO ibo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Mgbe ọ ghọrọ nna Peleg, ọ dịrị ndụ narị afọ anọ na iri atọ ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg gbara iri afọ atọ mgbe ọ mụrụ Reu. ");
INSERT INTO ibo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Emesịa, mgbe ọ ghọrọ nna Reu, ọ dịrị ndụ narị afọ abụọ na itoolu ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu gbara iri afọ atọ na abụọ mgbe ọ mụrụ Serug. ");
INSERT INTO ibo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Emesịa, ọ dịrị ndụ narị afọ abụọ na asaa ọzọ, mgbe ọ mụsịrị Serug, ọ mụtakwara ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug gbara iri afọ atọ mgbe ọ mụrụ Nahọ. ");
INSERT INTO ibo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Emesịa, mgbe ọ ghọrọ nna Nahọ, ọ dịrị ndụ narị afọ abụọ ọzọ mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahọ gbara iri afọ abụọ na itoolu mgbe ọ mụrụ Tera. ");
INSERT INTO ibo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Emesịa, mgbe ọ ghọrọ nna Tera, ọ dịrị ndụ narị afọ na afọ iri na itoolu ọzọ, mụta ụmụ ndị ikom na ụmụ ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mgbe Tera gbara iri afọ asaa, ọ ghọrọ nna Ebram, Nahọ na Haran. ");
INSERT INTO ibo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nke a bụ akụkọ gbasara usoro ezinaụlọ Tera. Tera ghọrọ nna Ebram, Nahọ na Haran. Haran ghọrọ nna Lọt. ");
INSERT INTO ibo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran nwụrụ nʼihu nna ya Tera nʼala ebe a nọ mụọ ya, nke bụ na Ụọ, obodo ndị Kaldịa. ");
INSERT INTO ibo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebram na Nahọ lụrụ nwunye. Aha nwunye Ebram bụ Serai ma aha nwunye Nahọ bụ Milka. Milka bụ nwa Haran, onye bụ nna Milka na Iska. ");
INSERT INTO ibo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma Serai bụ nwanyị aga, ọ mụtaghị nwa ọbụla. ");
INSERT INTO ibo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera kpọrọ nwa ya Ebram, na nwa nwa ya Lọt, onye bụ nwa Haran, na nwunye nwa ya Serai, bụ nwunye Ebram, duru ha hapụ Ụọ, obodo ndị Kaldịa, pụọ gawa nʼala Kenan. Ma mgbe ha bịarutere nʼobodo Haran, ha kwụsịrị biri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ọ bụ nʼobodo Haran ka Tera nọ nwụọ, mgbe ọ gbara narị afọ abụọ na ise. ");
INSERT INTO ibo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Onyenwe anyị gwara Ebram okwu sị, “Site nʼobodo gị, sikwa na ụmụnna gị na ezinaụlọ nna gị, gaa nʼala m ga-egosi gị. ");
INSERT INTO ibo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Aga m eme gị mba ukwu, aga m agọzi gị, aga m eme ka aha gị dị ukwuu, ị ga-abụ ngọzị. ");
INSERT INTO ibo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aga m agọzi ndị na-agọzi gị, ma onye ọbụla kọchara gị ka m ga-akọcha; a ga-agọzikwa agbụrụ niile nọ nʼụwa site na gị.” ");
INSERT INTO ibo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ya mere, Ebram hapụrụ gaa dịka Onyenwe anyị gwara ya. Lọt sokwa ya. Ebram agbaala iri afọ asaa na ise mgbe o si na Haran bulie ije. ");
INSERT INTO ibo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","O duru nwunye ya Serai na Lọt nwa nwanne ya, chịkọtakwa akụ niile ha kpakọbara, na ndị ohu niile ha nwetara nʼala Haran, chee ihu ịga nʼala Kenan. Emesịa ha rutere nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebram jere ije nʼime ala Kenan jeruo nʼebe osisi ukwu More, nke dị nʼobodo Shekem. Ndị Kenan bi nʼala ahụ nʼoge ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Onyenwe anyị mere ka Ebram hụ ya anya, ọ sịrị, “Aga m enye mkpụrụ gị ala a.” Ya mere, Ebram wuru ebe ịchụ aja nʼebe ahụ nye Onyenwe anyị onye gosiri ya onwe ya. ");
INSERT INTO ibo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Emesịa, Ebram hapụrụ ebe ahụ chee ihu nʼala ugwu dị nʼọwụwa anyanwụ Betel, maa ụlọ ikwu ya. Obodo Betel dị nʼakụkụ ọdịda anyanwụ, ma obodo Ai dị nʼakụkụ ọwụwa anyanwụ ebe ọ mara ụlọ ikwu ya. Nʼebe nsọ ahụ Ebram wuru ebe ịchụ aja, nọrọ nʼebe ahụ kpọkuo aha Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ọzọ, Ebram si nʼebe ahụ pụọ gaa ije rute Negev. ");
INSERT INTO ibo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nʼoge ahụ, oke ụnwụ dara nʼala ahụ. Nʼihi ya, Ebram hapụrụ ala ahụ gaa nʼala Ijipt, ebe o biri nwa oge. ");
INSERT INTO ibo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ma mgbe ha na-akwado ịbanye ala Ijipt, ọ gwara Serai nwunye ya sị, “Amaara m na ị bụ nwanyị mara mma. ");
INSERT INTO ibo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mgbe ndị Ijipt ga-ahụ gị, ha ga-asị, ‘Onye a bụ nwunye ya.’ Mgbe ahụ, ha ga-egbu m ma hapụ gị ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Gwa ha na ị bụ nwanne m nwanyị, ka ha meso m mmeso ọma nʼihi gị. Ha ga-echebekwa m ndụ nʼihi gị.” ");
INSERT INTO ibo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mgbe Ebram rutere Ijipt, ndị Ijipt hụrụ na nwunye ya bụ nwanyị mara mma. ");
INSERT INTO ibo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mgbe ndị ozi Fero hụrụ ya, ha toro ya nʼihu Fero. Nʼihi nke a, ha kpọbatara Serai nʼụlọeze Fero. ");
INSERT INTO ibo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero mesoro Ebram mmeso ọma nʼihi nwunye ya. Ebram nwetara igwe atụrụ, na ehi, na nne ịnyịnya ibu, oke na nwunye, na ndị ohu ndị nwoke na ndị nwanyị, na ịnyịnya kamel. ");
INSERT INTO ibo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma Onyenwe anyị jiri ajọọ ọrịa tie Fero na ndị ezinaụlọ ya ihe otiti nʼihi Serai nwunye Ebram. ");
INSERT INTO ibo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mgbe ahụ, Fero kpọrọ Ebram sị ya, “Gịnị bụ ihe a i mere? Gịnị mere ị gwaghị m na ọ bụ nwunye gị? ");
INSERT INTO ibo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Gịnị mere i ji sị na ọ bụ nwanne gị nwanyị, si otu a mee m ka m kpọrọ ya ka ọ bụrụ nwunye m? Ugbu a, lee nwunye gị, kpọrọ ya laa.” ");
INSERT INTO ibo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fero nyere iwu banyere Ebram na ndị ikom so ya. Ha zilagara ya, ya na nwunye ya, na ihe niile o nwere. ");
INSERT INTO ibo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ebram na nwunye, na ihe niile ha nwere hapụrụ ala Ijipt, gaa ije bịaruo Negev. Lọt sokwa ha. ");
INSERT INTO ibo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Nʼoge a, Ebram aghọọla ọgaranya dị ukwuu, onye nwere akụnụba nke ọtụtụ anụ ụlọ, na ọlaọcha, na ọlaedo. ");
INSERT INTO ibo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ha sitere na Negev pụọ ije site nʼotu ebe ruo nʼebe ọzọ tutu ha erute Betel, nʼebe dị nʼetiti Betel na Ai, ebe ọ mara ụlọ ikwu ya na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nʼebe nsọ o wukwara ebe ịchụ aja na mbụ, nʼebe ahụ Ebram kpọkuru aha Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ugbu a Lọt, onye ya na Ebram so na njem ya, bụkwa onye nwere akụnụba nke igwe ewu na atụrụ, na igwe ehi, na ọtụtụ ụlọ ikwu. ");
INSERT INTO ibo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ma ala ebe ha nọ ezurughị ha mgbe ha nọkọrọ ọnụ nʼihi na ihe onwunwe ha dị ukwuu ruo na ha enweghị ike ịnọkọ ọnụ. ");
INSERT INTO ibo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nke a mere esemokwu ji dapụta nʼetiti ndị ọzụzụ anụ ụlọ Ebram na ndị ọzụzụ anụ ụlọ Lọt. Ndị Kenan na ndị Periz bikwa nʼala ahụ nʼoge ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ya mere Ebram gwara Lọt sị, “Biko, ka esemokwu ghara ịdị nʼetiti mụ na gị, maọbụ nʼetiti ndị ọzụzụ anụ ụlọ m na ndị ọzụzụ anụ ụlọ gị, nʼihi na anyị bụ ụmụnne. ");
INSERT INTO ibo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lee, ọ bụ na ala a niile adịghị nʼihu gị? Ka anyị kewaa. Ọ bụrụ na ị gaa nʼakụkụ aka ekpe, aga m aga nʼakụkụ aka nri. Ma ọ bụrụ na i gaa nʼakụkụ aka nri gị, aga m aga nʼakụkụ aka ekpe.” ");
INSERT INTO ibo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lọt lelitere anya hụ na mbara ala Jọdan bụ ala mmiri na-ezokwasị nke ọma, ala dịka ubi a gbara ogige Onyenwe anyị, dịka ala ndị Ijipt nke dị na nso nso Zoa. (Ihe a mere tupu Onyenwe anyị ebibie obodo Sọdọm na Gọmọra.) ");
INSERT INTO ibo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ya mere, Lọt họọrọ nye onwe ya mbara ala Jọdan niile, chee ihu ịga nʼakụkụ ọwụwa anyanwụ. Ya na Ebram kewara. ");
INSERT INTO ibo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebram nọdụrụ nʼala Kenan, ma Lọt gara biri nʼetiti obodo ndị ahụ dị na mbara ala. Ọ mara ụlọ ikwu ya nso nso obodo Sọdọm. ");
INSERT INTO ibo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma ndị Sọdọm bụ ndị obi tara mmiri, ndị na-emehie nke ukwuu megide Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mgbe Lọt siri nʼebe ahụ pụọ, Onyenwe anyị gwara Ebram okwu sị ya, “Site nʼebe ahụ ị nọ lelie anya gị, lee anya nʼugwu na ndịda, nʼọwụwa anyanwụ na ọdịda anyanwụ. ");
INSERT INTO ibo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ala ahụ niile ị hụrụ ka m ga-enye gị na mkpụrụ gị ruo mgbe ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aga m eme ka mkpụrụ gị baa ụba dịka aja dị nʼala. Ọ bụrụ na mmadụ enwe ike ịgụta ọnụọgụgụ aja dị nʼala, ha ga-enwe ike gụta ọnụọgụgụ mkpụrụ gị. ");
INSERT INTO ibo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bilie jegharịa nʼala ahụ niile nʼakụkụ ya ọbụla, nʼihi na ana m enye gị ha niile.” ");
INSERT INTO ibo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ya mere, Ebram bugharịrị ụlọ ikwu ya, gaa biri nʼakụkụ osisi ukwu Mamre nke dị na Hebrọn. O wuru ebe ịchụ aja nye Onyenwe anyị nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nʼoge ahụ kwa, Amrafel, eze Shaịna, na Ariok, eze ndị Elasa, na Kedoloma eze Elam, na Tidal eze Goiim, ");
INSERT INTO ibo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","buru agha megide Bera eze Sọdọm, na Biasha eze Gọmọra, na Shịnab, eze Adma, na Shemeba eze Zeboiim, na eze obodo Bela (ya bụ Zoa). ");
INSERT INTO ibo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ndị eze obodo ndị a: Sọdọm, Gọmọra, Adma, Zeboiim na Bela, jikọtara ndị agha ha ọnụ na Ndagwurugwu Sidim (ya bụ, ndagwurugwu osimiri nnu ahụ). ");
INSERT INTO ibo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ha fere ofufe nʼokpuru ọchịchị eze Kedoloma afọ iri na abụọ, ma nʼafọ nke iri na atọ, ha nupuru isi. ");
INSERT INTO ibo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nʼafọ nke iri na anọ, eze Kedoloma na ndị eze ya na ha jikọrọ ọnụ buru agha megide ma merie ndị Refaim bi nʼAshterọt Kenaim na ndị Zuzim bi na Ham na ndị Emim bi Kiriatem na Shave, ");
INSERT INTO ibo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na ndị Hor nʼobodo ugwu Sia, ruo obodo El Paran, nke dị nʼakụkụ ọzara. ");
INSERT INTO ibo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Mgbe ahụ, ha chigharịrị azụ gaa En Mishpat (ya bụ Kadesh). Ha meriri ala niile nke ndị Amalek nakwa ndị Amọrait bi na Hazezọn Tama. ");
INSERT INTO ibo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mgbe ahụ kwa, ndị agha ndị eze obodo Sọdọm na eze Gọmọra, na eze Adma, na eze Zeboiim, na eze Bela (ya bụ Zoa) pụrụ doo onwe ha nʼusoro ibu agha na Ndagwurugwu Sidim, ");
INSERT INTO ibo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","imegide Kedoloma eze Elam, Tidal eze Goiim, Amrafel eze Shaịna na Ariok eze Elasa. Ya bụ eze ise buru agha megide eze anọ. ");
INSERT INTO ibo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ma Ndagwurugwu Sidim jupụtara nʼolulu apịtị. Mgbe ndị agha eze Sọdọm na Gọmọra bidoro ịgba ọsọ. Ụfọdụ nʼime ha dabanyere nʼime olulu ndị a, ma ndị fọdụrụ gbapụrụ ọsọ gbaga nʼugwu. ");
INSERT INTO ibo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ma eze anọ ndị a banyere nʼime obodo Sọdọm na Gọmọra bukọrọ akụ ha, na ihe oriri ha niile laa. ");
INSERT INTO ibo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ha buuru Lọt, nwa nwanne Ebram, onye bi na Sọdọm na ihe niile o nwere, buru ha na-ala ebe ha si bịa. ");
INSERT INTO ibo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma otu onye gbara ọsọ ndụ site nʼebe ahụ gara kọọrọ Ebram onye Hibru ihe mere. Nʼoge a, Ebram bi nʼebe dị nso nʼosisi ukwu nke Mamre, onye Amọrị, nwanne Eshkọl na Anea, ndị ha na Ebram gbara ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mgbe Ebram nụrụ na adọrọla Lọt nwa nwanne ya nʼagha, ọ kpọkọtara ndị ikom a zụrụ azụ na-ejere ya ozi, ndị a mụrụ nʼụlọ ya. Ọnụọgụgụ ha dị narị ndị ikom atọ na iri na asatọ, ha chụrụ ndị agha ahụ ọsọ tutu ha erute Dan. ");
INSERT INTO ibo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nʼabalị, Ebram kere ndị agha ya ibuso ndị ahụ agha. O meriri ha, chụọ ha ọsọ, chụruo ha Hoba, nke dị nʼakụkụ ugwu Damaskọs. ");
INSERT INTO ibo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ebram nwetaghachiri ihe niile ahụ ha dọtara nʼagha, dulata nwanne ya Lọt, na ihe onwunwe ya niile, tinyere ndị inyom, na ndị ọzọ niile a dọtara nʼagha. ");
INSERT INTO ibo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mgbe Ebram si na mmeri ahụ o meriri Kedoloma na eze ndị ọzọ ahụ na-alọta, eze Sọdọm bịara zute ya na Ndagwurugwu Shave (nke a na-akpọ Ndagwurugwu Eze). ");
INSERT INTO ibo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkizedek, eze Salem, onye nchụaja Chineke nke kachasị ihe niile elu, wepụtara achịcha na mmanya, ");
INSERT INTO ibo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ọ gọziri Ebram sị ya, “Ngọzị dịrị Ebram site nʼaka Chineke nke kachasị ihe niile elu, Onye kere eluigwe na ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ngọzị dịkwara Chineke nke kachasị ihe niile elu, onye weere ndị iro gị nyefee gị nʼaka.” Mgbe ahụ, Ebram nyere ya otu ụzọ nʼime ụzọ iri nke ihe niile. ");
INSERT INTO ibo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Eze Sọdọm gwara Ebram sị, “Nyeghachi m naanị ndị mmadụ, ma debere onwe gị ihe ndị ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Ebram zara eze Sọdọm sị, “Eweliri m aka m elu ṅụọ iyi nye Onyenwe anyị Chineke nke kachasị ihe niile elu, Onye kere eluigwe na ụwa, sị ");
INSERT INTO ibo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na agaghị m esi nʼaka gị were ihe ọbụla bụ nke gị, ọ bụladị eriri maọbụ eriri akpụkpọụkwụ. Ka ị ghara ị sị, ‘Ọ bụ m mere ka Ebram baa ọgaranya.’ ");
INSERT INTO ibo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Naanị ihe m ga-anara bụ ihe ụmụ okorobịa m ndị a riri, ya na oke ruuru Anea, na Eshkọl, na Mamre so m gaa. Nye ha oke ruuru ha.” ");
INSERT INTO ibo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mgbe nke a gasịrị, okwu Onyenwe anyị ruru Ebram site nʼọhụ, sị ya, “Atụla egwu, Ebram Abụ m ọta gị, ụgwọ ọrụ dị ukwu nke i nwere.” ");
INSERT INTO ibo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Ebram zara sị ya, “Gị, Onye kachasị ihe niile elu, bụ Onyenwe anyị, gịnị bụ ihe ị ga-enye m ebe ọ bụ na m amụtaghị nwa? Lee, ọ bụ Elieza, onye Damaskọs, ga-eketa akụ m niile.” ");
INSERT INTO ibo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ebram gara nʼihu kwuo sị, “Ebe ọ bụ na m amụtaghị ụmụ, ọ bụ ohu nọ nʼụlọ m ga-eketa akụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ma okwu Onyenwe anyị rutere ya, “Nwoke a agaghị eketa ihe i nwere, kama nwa nwoke nke ga-esi nʼahụ gị pụta ga-eketa ihe i nwere.” ");
INSERT INTO ibo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mgbe ahụ, Onyenwe anyị kpọpụtara Ebram nʼezi sị ya, “Lelie anya gị elu na mbara eluigwe, gụọ kpakpando niile ị hụrụ ọnụ, ma ị ga-enwe ike ịgụta ha.” Ọ gwara ya sị, “Otu a ka mkpụrụ gị ga-adị. A gaghị agụta ha ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebram kweere nʼihe Onyenwe anyị kwuru. Nʼihi nke a, a gụnyere ya okwukwe a dịka ezi omume. ");
INSERT INTO ibo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Onyenwe anyị gwakwara ya sị, “Mụ onwe m bụ Onyenwe anyị, onye si nʼala Ụọ nke ndị Kaldịa kpọpụta gị, inye gị ala a ka ọ bụrụ ihe nweta gị.” ");
INSERT INTO ibo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Ebram zara sị, “Biko, Onye kachasị ihe niile elu, bụ Onyenwe anyị olee otu m ga-esi mara na m ga-enweta ya?” ");
INSERT INTO ibo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Onyenwe anyị zara sị ya, “Wetara m nwa nne ehi gbara afọ atọ, na nne ewu gbara afọ atọ, na ebule gbara afọ atọ, na nduru, na nwa kpalakwukwu.” ");
INSERT INTO ibo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ebram wetaara ya ihe ndị a niile bọwaa ha ụzọ abụọ, doo ha nʼusoro ka otu akụkụ chee akụkụ nke ọzọ ihu. Ma ọ bọwaghị ụmụ nnụnụ ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mgbe anụ ufe fekwasịrị ozu anụ ndị ahụ, Ebram chụpụrụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mgbe anwụ bidoro ịda, Ebram dara nʼoke ụra, oke ụjọ na oke ọchịchịrị dakwasịrị ya. ");
INSERT INTO ibo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mgbe ahụ, Onyenwe anyị gwara ya sị, “Mata nke ọma na ụmụ ụmụ gị ga-anọ dịka ndị ọbịa nʼala na-abụghị nke ha. A ga-edo ha ọnọdụ dịka ndị ohu, mejọọ ha narị afọ anọ. ");
INSERT INTO ibo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ma aga m ata mba ahụ ha na-efe dịka ohu ahụhụ. Nʼikpeazụ, ha ga-eji ọtụtụ akụ si nʼebe ahụ pụta. ");
INSERT INTO ibo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma ị ga-anwụ nʼudo. A ga-eli gị mgbe ị kara ezi nka. ");
INSERT INTO ibo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mgbe ọgbọ anọ gasịrị, ụmụ ụmụ gị ga-alọtakwa nʼala a. Nʼihi na mmehie ndị Amọrait erubeghị nʼuju ya.” ");
INSERT INTO ibo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mgbe anwụ dara, mgbe ọchịchịrị gbachiri ebe niile, ite ọkụ na-akwụ anwụrụ ọkụ nke nwere ọwa na-enwu ọkụ si nʼetiti ibe anụ ndị ahụ gafee. ");
INSERT INTO ibo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nʼụbọchị ahụ ka Onyenwe anyị na Ebram gbara ndụ. Ọ sị, “Ndị agbụrụ gị ka m ga-enye ala ndị a, malite nʼiyi ndị Ijipt ruo nʼiyi ukwu Yufretis. ");
INSERT INTO ibo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ala ndị Ken, na nke ndị Keniz, na nke ndị Kadmọn, ");
INSERT INTO ibo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na ala ndị Het, na nke ndị Periz na nke ndị Refaim, ");
INSERT INTO ibo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na ala ndị Amọrait na nke ndị Kenan na nke ndị Gigash na nke ndị Jebus.” ");
INSERT INTO ibo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ma Serai nwunye Ebram, amụtaghị nwa. Serai nwere odibo nwanyị onye Ijipt, aha ya bụ Hega. ");
INSERT INTO ibo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ya mere ọ gwara Ebram sị, “Lee, ugbu a, Onyenwe anyị egbochiela m ịmụta ụmụ. Ugbu a, bakwuru nwanyị na-ejere m ozi. Ma eleghị anya, aga m esi na ya wulite ezinaụlọ m.” Ebram kweere ihe Serai kwuru. ");
INSERT INTO ibo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ya mere Serai nwunye Ebram, duuru Hega, odibo nwanyị ya, onye Ijipt, dunye Ebram ka ọ bụrụ nwunye ya. Ihe a mere na ngwụcha afọ iri site na mgbe Ebram bịara biri nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ebram na Hega dinara. Hega tụụrụ ime. Ma mgbe Hega matara na ọ dịrịla ime, ọ malitere ileda nne ya ukwu bụ Serai anya. ");
INSERT INTO ibo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mgbe ahụ, Serai gwara Ebram sị, “Ọ bụ gị butere ahụhụ a m nọ nʼime ya. Ọ bụ m were nwaodibo nwanyị m kunye gị nʼaka, ma ugbu a ọ hụrụ na ọ dị ime, abụrụla m onye ọ na-eleda anya. Ka Onyenwe anyị kpee ikpe a nʼetiti mụ na gị.” ");
INSERT INTO ibo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ebram zara Serai sị, “Lee, ohu gị nwanyị dị gị nʼaka. Jiri ya mee ihe ọbụla dị gị mma nʼanya.” Nʼihi nke a, Serai mesiri ya ihe ike, nke mere ka o si nʼebe Serai nọ gbapụ. ");
INSERT INTO ibo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma mmụọ ozi Onyenwe anyị hụrụ ya nʼakụkụ isi iyi mmiri dị nʼọzara, nʼakụkụ ụzọ Shua, ");
INSERT INTO ibo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","jụọ ya sị, “Hega, ohu nwanyị Serai, olee ebe i si bịa, olee ebe ka ị na-ejekwa?” Hega zara sị, “Ọ bụ site nʼihu nne m ukwu Serai ka m na-agba ọsọ.” ");
INSERT INTO ibo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mmụọ ozi Onyenwe anyị gwara ya sị, “Laghachikwuru nne gị ukwu. Doo onwe gị nʼokpuru ya.” ");
INSERT INTO ibo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mmụọ ozi Onyenwe anyị sịkwa ya, “Aga m amụba ụmụ gị, ka a hapụ inwe ike ịgụta ole ha dị.” ");
INSERT INTO ibo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mmụọ ozi Onyenwe anyị gwakwara ya sị, “Ị dị ime ugbu a, ị ga-amụ nwa nwoke. Aha ị ga-agụ ya bụ Ishmel nʼihi na Onyenwe anyị anụla maka nhụju anya gị. ");
INSERT INTO ibo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nwoke dịka ịnyịnya ibu a na-azụghị azụ ka ọ ga-abụ. Ọ ga-emegide onye ọbụla, onye ọbụla ga-emegidekwa ya. Ọ ga-ebi nʼime ibu iro, megide ụmụnna ya niile.” ");
INSERT INTO ibo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hega kpọkuru aha Onyenwe anyị, onye gwara ya okwu sị, “Ị bụ Chineke m na-ahụ m.” Nʼihi na Hega kwuru sị, “Ahụla m, ugbu a, onye ahụ na-ahụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ọ bụ ya mere e ji na-akpọ olulu mmiri ahụ, Bịa-Lahai-Rọị. Ọ ka dị ebe ahụ, nʼetiti Kadesh na Bered. ");
INSERT INTO ibo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Emesịa, Hega mụtaara Ebram nwa nwoke. Ebram kpọrọ nwa nwoke ahụ Hega mụtaara ya Ishmel. ");
INSERT INTO ibo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ebram gbara iri afọ asatọ na isii mgbe Hega mụtaara ya Ishmel. ");
INSERT INTO ibo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mgbe Ebram gbara iri afọ itoolu na itoolu, Onyenwe anyị gosiri ya onwe ya sị ya, “Abụ m Chineke Onye pụrụ ime ihe niile. Jegharịa ije nʼihu m, bụrụ onye na-enweghị ịta ụta ọbụla. ");
INSERT INTO ibo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Aga m eme ka ọgbụgba ndụ m dịrị nʼetiti mụ na gị, mekwa ka ị mụbaa nke ukwuu nʼọnụọgụgụ.” ");
INSERT INTO ibo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebram dara nʼala, kpudo ihu ya nʼala. Chineke gwara ya sị, ");
INSERT INTO ibo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Lee, nke a bụ ọgbụgba ndụ dị nʼetiti mụ na gị. Ị ga-abụ nna ọtụtụ mba. ");
INSERT INTO ibo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Aha gị agaghị abụkwa Ebram, kama ọ ga-abụ Ebraham, nʼihi na emeela m gị nna nke ọtụtụ mba. ");
INSERT INTO ibo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aga m eme gị ka ị mụbaa nke ukwuu. Aga m eme ka ị ghọọ ọtụtụ mba dị iche iche, ndị eze ga-esitekwa na gị pụta. ");
INSERT INTO ibo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Aga m eme ka ọgbụgba ndụ mụ na gị gbara guzosie ike, ka ọ dịkwara ụmụ ụmụ ndị ga-esote gị nʼọgbọ niile na-abịa. Ọ bụ ọgbụgba ndụ na-egosi na m bụ Chineke gị, na Chineke ụmụ ụmụ gị niile ga-eso gị. ");
INSERT INTO ibo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ala Kenan niile, ebe ị nọ ugbu a dịka ọbịa ka m ga-enye gị na ụmụ ụmụ gị ga-esote gị dịka ihe nketa ebighị ebi. Aga m abụ Chineke ha.” ");
INSERT INTO ibo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Chineke gwara Ebraham okwu sị ya, “Ma nʼebe ị nọ, ị ghaghị irube isi imezu ihe ọgbụgba ndụ m kwuru, gị onwe gị na ụmụ ụmụ gị ndị ga-esote gị, ruo ọgbọ niile. ");
INSERT INTO ibo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nke a bụ ọgbụgba ndụ dị nʼetiti mụ na gị na ụmụ ụmụ gị ndị ga-esote gị, ọgbụgba ndụ nke unu na-aghaghị idebe. A ga-ebi nwoke ọbụla nʼetiti unu ugwu. ");
INSERT INTO ibo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","A ga-ebi unu ugwu, bipụ elu ahụ nke anụ ahụ unu. Nke a ga-abụ ihe ama nke ọgbụgba ndụ dị nʼetiti mụ na unu. ");
INSERT INTO ibo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Nʼoge ọ gbara mkpụrụ ụbọchị asatọ, unu ga-ebi nwoke ọbụla nʼagbụrụ unu ugwu: ndị a mụrụ nʼụlọ, maọbụ ndị eji ego zụta site nʼaka ndị mba ọzọ, ndị na-esighị na mkpụrụ nke afọ gị. ");
INSERT INTO ibo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","A ga-ebi ha niile ugwu. Ma a mụrụ ha nʼezinaụlọ gị ma i ji ego zụta ha site nʼaka onye mba ọzọ. Ọgbụgba ndụ m nke ga-apụta ihe nʼanụ ahụ gị bụ ọgbụgba ndụ ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nwoke ọbụla a na-ebighị ugwu nke anụ ahụ ka a ga-ebipụ site nʼetiti ụmụnna ya. Nʼihi na o mehiela megide ọgbụgba ndụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Chineke gwakwara Ebraham sị, “Ma nʼebe Serai nwunye gị nọ, ị gaghị akpọkwa ya Serai ọzọ, kama aha ya ga-abụ Sera. ");
INSERT INTO ibo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aga m agọzi ya, sitekwa na ya nye gị nwa nwoke. Aga m agọzi ya ruo na ọ ga-abụ nne nke ọtụtụ mba. Ndị eze ga-achị ọtụtụ mmadụ ga-esite na ya pụta.” ");
INSERT INTO ibo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebraham dara kpuo ihu nʼala, chịakwa ọchị nʼobi ya sị, “Ọ bụ onye gbara narị afọ ka a ga-amụrụ nwa? Sera, onye gbara iri afọ itoolu ọ ga-amụ nwa?” ");
INSERT INTO ibo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ebraham gwara Chineke sị, “A sịkwa na ị ga-ekwe mee ka Ishmel bụrụ onye dị ndụ nʼihu gị.” ");
INSERT INTO ibo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma Chineke zara sị ya, “Ee, kama Sera nwunye gị ga-amụtara gị nwa nwoke. Ị ga-agụ ya Aịzik. Ọgbụgba ndụ m ga-adịkwara ya na agbụrụ ya ruo mgbe ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ma banyere Ishmel, anụla m ihe i kwuru. Aga m agọzi ya mee ya ka ọ baa ụba ma dịkwa ukwuu nʼọnụọgụgụ. Ọ ga-aghọ nna ndị eze iri na abụọ. Aga m eme ya ka ọ ghọọ mba dị ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma ọgbụgba ndụ m ka m ga-eme ka o guzosie ike nʼebe Aịzik nọ, onye Sera ga-amụtara gị nʼoge dịka ugbu a nʼafọ ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mgbe ọ gwasịrị Ebraham okwu, Chineke si nʼebe ọ nọ pụọ. ");
INSERT INTO ibo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nʼụbọchị ahụ, Ebraham duuru Ishmel nwa ya nwoke, na ndị ikom niile a mụrụ nʼezinaụlọ ya, tinyere ndị e ji ego zụta, ndị ikom niile nọ nʼezinaụlọ ya, bie ha ugwu dịka Chineke gwara ya ka ọ mee. ");
INSERT INTO ibo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebraham gbara iri afọ itoolu na itoolu mgbe e biri ya ugwu, ");
INSERT INTO ibo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmel nwa ya gbara afọ iri na atọ. ");
INSERT INTO ibo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","E biri Ebraham na nwa ya bụ Ishmel ugwu nʼotu ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ndị ikom niile nọ nʼezinaụlọ Ebraham, ndị a mụrụ nʼụlọ ya na ndị e si nʼaka ndị mba ọzọ zụta ka e biri ugwu nʼoge Ebraham biri ugwu. ");
INSERT INTO ibo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Onyenwe anyị gosiri Ebraham onwe ya nʼakụkụ osisi ukwu dị na Mamre, mgbe Ebraham nọdụrụ ala nʼihu ụlọ ikwu ya, nʼetiti ehihie. ");
INSERT INTO ibo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","O lelitere anya ya hụ ndị ikom atọ ka ha guzo ebe ọ nọ nso. Mgbe ọ hụrụ ha, o sitere nʼihu ụlọ ikwu ya gbakwuru ha izute ha, kpọọ isiala. ");
INSERT INTO ibo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ọ sịrị, “Onyenwe m, ọ bụrụ na m natara amara nʼihu gị, agabigala ohu gị. ");
INSERT INTO ibo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Biko, ka ekutere unu mmiri ntakịrị, ka unu sachaa ụkwụ unu, zurukwa ike nʼokpuru osisi a. ");
INSERT INTO ibo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ka m wetara unu nri ntakịrị unu ga-eri nke ga-agba unu ume tupu unu agawa nʼihu nʼije unu ugbu a unu bịara na nke ohu unu.” Ha zara sị ya, “Ọ dị mma. Mee dịka i kwuru.” ");
INSERT INTO ibo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ya mere, Ebraham mere ngwangwa banyekwuru Sera nʼụlọ ikwu ya sị ya, “Mee ngwa, mapụta ihe ọtụtụ sịa atọ site na ọka a kwọrọ nke ọma jiri meta achịcha.” ");
INSERT INTO ibo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mgbe ahụ, Ebraham gbagara nʼigwe ehi ya, họpụta otu nwa ehi na-akaghị aka nke ahụ ya dị mma, nye ya otu ohu ya onye mere ngwangwa gbuo ya, dozie ya maka oriri. ");
INSERT INTO ibo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Emesịa, Ebraham buuru mmiri ara ehi nke rahụrụ arahụ, na mmiri ara ehi, na anụ ahụ a kwadoro dozie ha nʼihu ndị ọbịa ahụ. O guzokwara nso nso ebe ha nọ nʼokpuru osisi ahụ mgbe ha na-eri nri. ");
INSERT INTO ibo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ha jụrụ ya sị, “Ebee ka Sera nwunye gị nọ?” Ọ zara sị, “Ọ nọ nʼime ụlọ ikwu.” ");
INSERT INTO ibo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ọ sịrị ya, “Nʼezie, mụ onwe m ga-alọghachikwute gị nʼoge a nʼafọ ọzọ, Sera nwunye gị ga-amụta nwa nwoke.” Sera guzo nʼime ụlọ ikwu ahụ nke dị nʼazụ Ebraham na-ege ntị nʼihe ha na-ekwu. ");
INSERT INTO ibo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nʼoge a, Ebraham na Sera emeela nnọọ agadi, gbaakwa isi awọ. Sera agafeela oge ịmụta nwa. ");
INSERT INTO ibo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ya mere, mgbe Sera nụrụ ihe Onyenwe anyị kwuru, ọ chịrị ọchị sị, “Agadi nwanyị dịka m o si aṅaa amụta nwa, ugbu a onyenwe m karala nka?” ");
INSERT INTO ibo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Onyenwe anyị jụrụ Ebraham ajụjụ sị, “Gịnị mere Sera ji achị ọchị? Gịnị mere o ji kwuo sị, ‘Olee otu agadi nwanyị dịka m ga-esi mụọ nwa?’ ");
INSERT INTO ibo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ọ dị ihe nyịrị Onyenwe anyị ime? Mụ onwe m ga-alọghachikwute gị nʼoge a kara aka, Sera nwunye gị ga-amụta nwa nwoke.” ");
INSERT INTO ibo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ma ụjọ tụrụ Sera. Nʼihi ya, ọ gọrọ agọ sị, “Achịghị m ọchị.” Ma Ọ zara sị, “Ọ bụ ezie, Sera, ị chịrị ọchị.” ");
INSERT INTO ibo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mgbe ndị ikom atọ ahụ biliri ibidokwa ije ha, ha chere ihu ịga obodo Sọdọm, Ebraham dupụkwara ha. ");
INSERT INTO ibo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mgbe ha na-aga nʼụzọ, Onyenwe anyị tulere sị, “O kwesiri ka m zochiere Ebraham ihe m chọrọ ime? ");
INSERT INTO ibo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ebraham aghaghị ịbụ mba dị ukwuu dịkwa ike. A ga-agọzikwa agbụrụ niile nọ nʼụwa site na ya. ");
INSERT INTO ibo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nʼihi na ahọpụtala m ya, ka ọ tụziere ụmụ ya na ụlọ ya ndị ga-esote ya ịgbaso ụzọ Onyenwe anyị site nʼime ihe dị mma na ihe ziri ezi, ka Onyenwe anyị mezuoro Ebraham ihe niile o kwere ya na nkwa.” ");
INSERT INTO ibo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mgbe ahụ, Onyenwe anyị kwuru sị, “Mkpu akwa m na-anụ site na Sọdọm na Gọmọra dị ukwuu, otu a kwa, mmehie ha jọbigara njọ oke. ");
INSERT INTO ibo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ugbu a, ana m aga ka m jiri anya m hụ ma ihe ha mere ọ dị njọ dịka mkpu akwa m na-anụ si dị. Ma o sighị otu ahụ dịrị, aga m amata.” ");
INSERT INTO ibo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mgbe ahụ, ndị ikom abụọ nʼime ha gawara Sọdọm. Ma Ebraham nọ na-eguzo nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ebraham jeruru Onyenwe anyị nso jụọ ya sị, “Uche gị ọ bụ ikpochapụ ndị ezi omume na ndị ajọ omume? ");
INSERT INTO ibo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ọ bụrụ na ị chọta iri ndị ezi omume ise nʼime obodo ahụ, ị ga-ekpochapụ obodo ahụ? Ị gaghị agbaghara ya nʼihi iri ndị ezi omume ise nọ nʼime ya? ");
INSERT INTO ibo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ọ bụghị ezi ihe na ị ga-ala ndị ezi omume na ndị ajọ omume nʼiyi. Nʼihi na ị gaghị emeso ndị ezi omume dịka i si mesoo ndị na-eme ajọ ihe. O kwesighị ka onye ga-ekpe ụwa niile ikpe, kpee ikpe ziri ezi?” ");
INSERT INTO ibo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mgbe ahụ, Onyenwe anyị zara sị ya, “Ọ bụrụ na m achọta iri ndị ezi omume ise nʼobodo Sọdọm, aga m agbaghara obodo ahụ niile nʼihi ha.” ");
INSERT INTO ibo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ebraham kwukwara ọzọ sị, “Ugbu a m nwere ike kwuwapụta okwu nʼihu Onyenwe anyị, mụ onye bụ naanị aja na ntụ. ");
INSERT INTO ibo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Eleghị anya ọ bụrụ na e nweta naanị iri ndị ezi omume anọ na ise, ị ga-emebi obodo ahụ?” Onyenwe anyị zara sị, “Agaghị m ebibi ya ma ọ bụrụ na m achọta iri mmadụ anọ na ise nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ọzọkwa, ọ sịrị ya, “Ọ bụrụkwanụ na a ga-achọta naanị iri mmadụ anọ?” Onyenwe anyị zara sị ya, “Nʼihi iri mmadụ anọ, agaghị m ebibi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Mgbe ahụ ọ sịrị, “Biko, ka iwe hapụ iwe Onyenwe anyị ma m kwuo okwu. Eleghị anya, achọta naanị iri mmadụ atọ nʼebe ahụ?” Onyenwe anyị zaghachiri sị ya, “Agaghị m emebi ya, ma ọ bụrụ na m achọta iri mmadụ atọ nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","O kwuru sị, “Ebe ọ bụ na m amalitela ịgwa gị, Onyenwe anyị okwu, biko kwere ka m gaa nʼihu. Ọ bụrụ na a ga-achọta naanị iri mmadụ abụọ?” Onyenwe anyị zara sị, “Nʼihi iri mmadụ abụọ ahụ agaghị m emebi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Nʼikpeazụ, Ebraham kwuru sị, “Ka iwe hapụ iwe Onyenwe anyị. Ka m kwuo naanị otu ugboro a. Ọ bụrụkwanụ na a chọta naanị mmadụ iri nʼebe ahụ?” Onyenwe anyị zara sị, “Nʼihi mmadụ iri ahụ, agaghị m ebibi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mgbe Onyenwe anyị gwachara Ebraham okwu, ọ hapụrụ ya gawa ebe ọ na-aga. Ebraham laghachiri azụ nʼụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nʼoge anyasị, ndị mmụọ ozi abụọ ahụ bịarutere Sọdọm. Lọt nọ ala nʼọnụ ụzọ ama obodo ahụ. Mgbe ọ hụrụ ha, o biliri jekwuru ha, hulata ihu ya nʼala. ");
INSERT INTO ibo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ọ sịrị, “Ndị nwe m, batanụ nʼụlọ ohu unu. Unu nwere ike saa ụkwụ unu, nọọkwa ọnọdụ abalị. Chi bọọ, unu nwere ike ibilikwa bido ịga nʼihu nʼije unu.” Ha zara sị, “Ee, anyị ga-edina nʼama.” ");
INSERT INTO ibo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma Lọt rịọsiri ha ike. Nʼikpeazụ ha sooro ya laa nʼụlọ ya. Ọ kwadooro ha ihe oriri, ya bụ achịcha na-ekoghị eko ka o ghere. Ha rikwara ya. ");
INSERT INTO ibo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tupu ha abanye ịrahụ ụra, ndị ikom obodo ahụ, ndị ikom Sọdọm, bịara gbaa ụlọ ahụ gburugburu, ma ụmụ okorobịa ma ndị agadi, ndị niile si nʼakụkụ obodo ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ha kpọrọ Lọt oku sị ya, “Olee ebe ha nọ, bụ ndị ikom ahụ bịara nʼụlọ gị nʼabalị a? Kpọpụtara anyị ha ka anyị na ha dinakọọ.” ");
INSERT INTO ibo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọt pụkwuru ha nʼezi, mechie ụzọ ụlọ ya, ");
INSERT INTO ibo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","sị ha, “Bikonu, ndị enyi m, unu emela ihe ọjọọ dị otu a. ");
INSERT INTO ibo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Leenụ, enwere m ụmụ nke aka m, ụmụ agbọghọ abụọ na-amaghị nwoke. Ka m kpọpụtara unu ha, ka unu mee ha ihe masịrị unu. Ma hapụnụ ndị ikom ndị a, nʼihi na ha bụ ndị batara izere ndụ nʼụlọ m.” ");
INSERT INTO ibo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ha zara sị ya, “Pụọra anyị nʼụzọ. Mbịarambịa ka ị bụ! Leenụ mbịarambịa a! Ọ chọrọ ịbụ onye ikpe. Anyị mee gị ihe, ọ ga-ajọrọ gị njọ karịa ihe anyị ga-eme ha.” Ha nuru Lọt aka nughachi ya azụ, malite itiwa ọnụ ụzọ ụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma ndị ikom ahụ nọ nʼụlọ Lọt, setịpụrụ aka ha dọbata ya nʼụlọ, ma mechie ụzọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ha tiri ndị ikom ndị ahụ nọ nʼọnụ ụzọ ihe otiti nke mere ka ha kpụọ ìsì, onye ukwu ha na onye nta ha. Nʼihi ya, ha enweghị ike ịchọta ọnụ ụzọ ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ndị ikom abụọ ahụ gwara Lọt sị, “O nwere onye ọbụla ọzọ i nwere nʼebe a? Ndị ọgọ nwoke, maọbụ ụmụ gị ndị ikom, maọbụ ụmụ gị ndị inyom, na ọ bụ onye ọbụla bụ nke gị nʼobodo a. Site nʼebe a kpọpụ ha! ");
INSERT INTO ibo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nʼihi na anyị na-aga imebi obodo a, mkpu akwa ruru Onyenwe anyị ntị megide ndị bi nʼobodo a adịla ukwuu, nke mere o ji zite anyị ibibi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ya mere, Lọt pụrụ gaa gwa ndị ọgọ ya nwoke, ndị na-akwado ịlụ ụmụ ya ndị inyom, sị ha, “Ọsọ, sinụ nʼobodo a pụọ. Nʼihi na Onyenwe anyị na-akwado ibibi ya.” Ma ndị ọgọ ya nwoke ndị a chere na ọ na-egwu egwu. ");
INSERT INTO ibo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nʼụtụtụ, mgbe chi na-abọta, ndị mmụọ ozi a kwagidere Lọt sị ya, “Ọsọ, kpọrọ nwunye gị na ụmụ gị ndị inyom abụọ ndị a site nʼebe a gbapụ, ma ọ bụghị ya, a ga-ekpochapụ unu nʼihi ajọ omume ndị obodo a.” ");
INSERT INTO ibo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mgbe Lọt ka nọ na-eche ihe ọ ga-eme, ndị ikom ahụ jidere ya nʼaka, jidekwa nwunye ya, na ụmụ ya ndị inyom abụọ duru ha pụọ nʼobodo ahụ, nʼihi na Onyenwe anyị nwere obi ebere nʼebe ha nọ. ");
INSERT INTO ibo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mgbe ha si nʼime obodo kpọpụta ha, otu onye nʼime ha gwara ha sị, “Gbalaganụ nʼihi ndụ unu. Unu elekwala anya nʼazụ. Unu akwụsịkwala ebe ọbụla na mbara ala. Gbaganụ nʼugwu, nʼihi na ọ bụrụ na unu emeghị otu a, a ga-ekpochapụ unu.” ");
INSERT INTO ibo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lọt sịrị ha, “Mba, ndị nwe m, bikonu, ");
INSERT INTO ibo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ohu unu achọtala amara nʼihu unu, unu egosila m obi ebere dị ukwuu site nʼichebe ndụ m. Ma agaghị m enwe ike gbalaga nʼugwu ka mbibi a ghara ịdakwasị m, m nwụọ. ");
INSERT INTO ibo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lee obodo dị nso nke m nwere ike ịgbaga. Ọ bụ obodo dị nta. Kwere ka m gbaga nʼebe ahụ. Obodo nta ka ọ bụ, ọ bụghị ya? Aga m echebekwa ndụ m na ya.” ");
INSERT INTO ibo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ọ zara sị ya, “Ọ dị mma, aga m emere gị dịka arịrịọ gị si dị. Agaghị m emebi obodo nta ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ma mee ngwangwa, nʼihi na o nweghị ihe ọbụla m ga-eme tutu ruo mgbe i ruru nʼebe ahụ.” (Ọ bụ nke a mere e ji akpọ aha obodo ahụ Zoa.) ");
INSERT INTO ibo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mgbe Lọt rutere obodo Zoa, anwụ awalitela nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mgbe ahụ Onyenwe anyị sitere nʼeluigwe zokwasị obodo Sọdọm na Gọmọra nkume ọkụ nke Onyenwe anyị mere ka o si nʼeluigwe zoo. ");
INSERT INTO ibo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Otu a ka o si kwatuo obodo ndị ahụ niile dị na mbara ala ahụ niile, na ndị niile bi nʼobodo ndị ahụ. O kwatukwara ihe niile na-epu nʼala. ");
INSERT INTO ibo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma mgbe nwunye Lọt lere anya nʼazụ, otu mgbe ahụ, ọ ghọrọ ogidi nnu. ");
INSERT INTO ibo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nʼụtụtụ echi ya, Ebraham biliri jeruo ebe ahụ o guzoro nʼihu Onyenwe anyị nʼụbọchị gara aga. ");
INSERT INTO ibo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ọ lepụrụ anya nʼebe obodo Sọdọm na Gọmọra dị, na nʼebe mbara ala ndị ahụ niile dị. Ọ hụrụ anwụrụ ọkụ dị ukwuu nke si nʼala ahụ na-alali elu. Anwụrụ ọkụ a dị ka anwụrụ ọkụ si nʼebe a kwanyere ọkụ na-enwusi ike. ");
INSERT INTO ibo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ya mere, mgbe Chineke bibiri obodo ndị ahụ dị na mbara ala, o chetara Ebraham, kpọpụta Lọt site nʼoke mbibi ahụ e bibiri obodo ndị ahụ Lọt bi nʼime ha. ");
INSERT INTO ibo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Emesịa, Lọt na ụmụ ya ndị inyom abụọ hapụrụ obodo Zoa, nʼihi na ọ tụrụ egwu ibi nʼime Zoa. Ọ gara biri nʼime ọgba nkume ya na ụmụ ya ndị inyom abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Otu ụbọchị, ada ya sịrị nke nta, “Nna anyị emeela agadi, ọ nwekwaghị nwoke ọbụla nọ nʼụwa a, onye ga-enye anyị ụmụ, dịka omenaala si dị nʼụwa niile. ");
INSERT INTO ibo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ka anyị mee ka nna anyị ṅụọ mmanya, ka anyị na ya dinakọọ, ka anyị chebe agbụrụ anyị site na nna anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nʼabalị ahụ, ha mere ka nna ha ṅụọ mmanya, nke ada banyere soro nna ya dina. Ha abụọ nwere mmekọ. Ma ọ amaghị mgbe ada ya dinara maọbụ mgbe o bilikwara. ");
INSERT INTO ibo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nʼechi ya, ada gwara nwanne ya nke nta, “Mụ na nna anyị dinara nʼabalị gara aga. Ka anyị mee ka ọ ṅụọkwa mmanya nʼabalị taa, ka ị gaakwa ka gị na ya dina. Ka anyị mee ka agbụrụ anyị dịgide site na nna anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ha mere ka nna ha ṅụọ mmanya nʼabalị ahụ, ada ya nke nta banyere ya na nna ya dinaa. Dịka ọ dịkwa na mbụ, nna ha amataghị mgbe o dinara ala maọbụ mgbe o bilitere. ");
INSERT INTO ibo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ya mere, ụmụ ndị inyom Lọt abụọ ndị a tụrụ ime site nʼaka nna ha. ");
INSERT INTO ibo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nke ada mụtara nwa nwoke onye ọ gụrụ Moab. Ọ bụ ya bụ nna nna ndị Moab ruo taa. ");
INSERT INTO ibo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nwa ya nke nta mụtakwara nwa nwoke onye ọ gụrụ Ben-Ammi. Ọ bụ ya bụ nna nna ndị Amọn ruo taa. ");
INSERT INTO ibo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ugbu a, Ebraham sitere nʼebe ahụ bilie gaa na mpaghara Negev biri nʼebe dị nʼagbata Kadesh na Shua. Ọ nọrọ nʼobodo Gera nwa oge nta. ");
INSERT INTO ibo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nʼebe ahụ, Ebraham kwuru maka Sera, nwunye ya, sị “Ọ bụ nwanne m nwanyị.” Abimelek, eze Gera, ziri ozi kpọrọ Sera. ");
INSERT INTO ibo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ma Chineke bịakwutere Abimelek na nrọ nʼanyasị, sị ya, “Onye nwụrụ anwụ ka ị bụ, nʼihi nwanyị nke ị kpọọrọ, nwanyị a bụ onye nwere di.” ");
INSERT INTO ibo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma Abimelek abịabeghị Sera nso, ya mere o ji sị, “Onyenwe m, ị ga-ebibi mba aka ya dị ọcha? ");
INSERT INTO ibo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ọ bụ na ya onwe ya agwaghị m sị, ‘ọ bụ nwanne m nwanyị,’ nke nwanyị nʼonwe ya, ekwuokwa sị, ‘Nwanne m nwoke ka ọ bụ?’ E ji m uche dị ọcha na aka dị ọcha mee ihe niile m mere.” ");
INSERT INTO ibo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Chineke zara ya sị, “Amaara m na i ji uche dị ọcha mee ihe i mere. Ọ bụ ya mere m ji gbochie gị imehie megide m. Ọ bụkwa ya mere m ji gbochie gị ịmetụ ya aka. ");
INSERT INTO ibo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ugbu a, nyeghachi nwoke a nwunye ya. Nʼihi na ọ bụ onye amụma. Ọ ga-ekpere gị ekpere, ka ị ghara ịnwụ. Ma ọ bụrụ na i dughachịghị nwanyị a nye di ya, unu ga-anwụ, gị na ndị gị niile.” ");
INSERT INTO ibo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ya mere, Abimelek biliri nʼisi ụtụtụ echi ya, kpọọ nzukọ nke ndịisi ozi ya niile, kọọrọ ha ihe mere. Ha tụrụ ụjọ nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Emesịa, Abimelek kpọbatara Ebraham sị ya, “Gịnị bụ ihe a i mere anyị? Gịnị bụ ihe ọjọọ m mere i ji butere mụ na alaeze m ihe oke ikpe ọmụma dị otu a? Ihe a i mere m bụ ihe na-ekwesighị ekwesi.” ");
INSERT INTO ibo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek jụrụ Ebraham sị, “Ọ bụ gịnị ka ị hụrụ i jiri mee omume dị otu a?” ");
INSERT INTO ibo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ebraham zara ya, “Nʼihi na asịrị m nʼobi m, ‘Nʼezie, ịtụ egwu Chineke adịghị nʼebe a. Ha ga-egbu m nʼihi nwunye m.’ ");
INSERT INTO ibo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ewezugakwa nke a, ọ bụ nwanna m nwanyị, nʼihi na otu nna mụrụ anyị, ma ọ bụghị otu nne, tupu ọ bụrụ nwunye m. ");
INSERT INTO ibo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mgbe Chineke sitere nʼezinaụlọ nna m zipụ m ije ebe dị anya, agwara m ya sị, ‘Otu a ka ị ga-esi gosi na ị hụrụ m nʼanya, ebe ọbụla anyị gara, kwuo gbasara m, “Onye a bụ nwanne m.” ’ ” ");
INSERT INTO ibo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Mgbe ahụ, Abimelek dupụtara atụrụ, na ehi, na ndị ohu ndị ikom, na ndị ohu ndị inyom, nye Ebraham. Ọ kpọnyekwara ya Sera nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek sịrị, “Lee nʼala m niile, birikwa nʼebe ọbụla masịrị gị.” ");
INSERT INTO ibo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Mgbe ahụ, ọ sịrị Sera, “Ana m enye nwanne gị puku shekel ọlaọcha, ka ọ bụrụ ihe m ji kwụọ ụgwọ mmeso ọjọọ m mesoro gị. Ejikwa m ya na-egosi na ị bụ onye aka ya dị ọcha.” ");
INSERT INTO ibo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Mgbe ahụ, Ebraham kpọkuru Chineke nʼekpere. Chineke gwọrọ Abimelek na nwunye ya, na ndị inyom ndị ohu ya niile, ka ha nwee ike ịmụta ụmụ ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Nʼihi na Onyenwe anyị mechiri akpanwa ndị inyom niile nọ nʼezinaụlọ Abimelek nʼihi Sera nwunye Ebraham. ");
INSERT INTO ibo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Onyenwe anyị jiri amara leta Sera dịka o kwuru na ọ ga-eme. Onyenwe anyị meere Sera ihe o kwere na nkwa. ");
INSERT INTO ibo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sera tụụrụ ime, mụọra Ebraham nwa nwoke nʼoge o merela agadi. Ọ mụrụ ya nʼoge ahụ a kara aka Chineke kwere ya na nkwa. ");
INSERT INTO ibo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ebraham gụrụ nwantakịrị ahụ Sera mụụrụ ya aha, kpọọ ya Aịzik. ");
INSERT INTO ibo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mgbe Aịzik nọrọ ụbọchị asatọ site nʼụbọchị a mụrụ ya, Ebraham biri ya ugwu dịka Chineke si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebraham agbaala narị afọ mgbe a mụrụ Aịzik nwa ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nʼoge ahụ, Sera kwuru sị, “Chineke ewetarala m ọchị. Ndị niile nụrụ akụkọ a ga-esoro m chịa ọchị.” ");
INSERT INTO ibo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","O kwukwara sị, “Onye gaara agwa Ebraham sị ya na Sera ga-azụlite ụmụntakịrị. Ma otu ọ dị, amụtarala m ya nwa nwoke ugbu a o merela agadi.” ");
INSERT INTO ibo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nwata ahụ tokwara, ruo mgbe a kwụsịrị ya ara. Nʼụbọchị ahụ a kwụsịrị ya ara, Ebraham kpọrọ oriri. ");
INSERT INTO ibo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma mgbe Sera hụrụ na nwa nwoke ahụ Hega onye Ijipt mụtaara Ebraham nọ na-akwa emo, ");
INSERT INTO ibo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ọ gwara Ebraham okwu sị ya, “Chụpụ ohu nwanyị a na nwa ya. Nʼihi na nwa nwoke ohu nwanyị agaghị eso nwa m nwoke Aịzik keta oke nʼihe nketa.” ");
INSERT INTO ibo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Okwu a wutere Ebraham nke ukwuu nʼihi na ihe banyere nwa ya nwoke Ishmel na-emetụ ya nʼobi. ");
INSERT INTO ibo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma Chineke gwara Ebraham sị, “Ekwela ka obi jọọ gị njọ nʼihi nwantakịrị a na ohu gị nwanyị. Gee ntị nʼihe ọbụla Sera gwara gị. Nʼihi na ọ bụ site nʼAịzik ka a ga-akpọ mkpụrụ gị aha. ");
INSERT INTO ibo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Aga m eme ka nwa gị nwoke nke ohu gị mụtara ghọọ mba dị ukwuu, nʼihi na mkpụrụ afọ gị ka ọ bụ.” ");
INSERT INTO ibo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ebraham biliri nʼisi ụtụtụ echi ya, kwadoo ihe oriri na mmiri ọṅụṅụ nke dị nʼime karama akpụkpọ, bunye ha Hega. O bukwasịrị ha nʼubu Hega, zipụ ya na nwa ya nwoke. Hega si nʼebe ahụ pụọ wagharịa nʼime ọzara Bịasheba. ");
INSERT INTO ibo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mgbe mmiri dị na karama akpụkpọ ahụ gwụsịrị, o nibere nwantakịrị ahụ nʼokpuru otu osisi ọhịa. ");
INSERT INTO ibo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Hapụ ya gaa nọdụ ala nʼebe dịtụ anya, ihe dịka narị nzọ ụkwụ, nʼihi na o kwuru nʼobi ya sị, “Achọghị m ịhụ nwantakịrị nwoke a anya mgbe ọ na-anwụ.” Mgbe ọ nọdụrụ ebe ahụ, o bidoro ịkwa akwa. ");
INSERT INTO ibo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ma Chineke nụrụ ịkwa akwa nwantakịrị nwoke ahụ. Mmụọ ozi Chineke sikwa na mbara eluigwe kpọọ Hega oku sị ya, “Hega, gịnị na-eme gị? Atụla egwu, nʼihi na Chineke anụla olu akwa nwantakịrị ahụ nʼebe ahụ o dina. ");
INSERT INTO ibo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Gaa kulite nwantakịrị ahụ kasịe ya obi, nʼihi na aga m eme ya ka ọ ghọọ mba dị ukwuu.” ");
INSERT INTO ibo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mgbe ahụ, Chineke meghere anya ya, mee ka ọ hụ olulu mmiri dị nʼebe ahụ. Ọ gara kujuo karama akpụkpọ ahụ mmiri, ma nye nwantakịrị ahụ mmiri ka ọ ṅụọ. ");
INSERT INTO ibo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Chineke nọnyeere nwantakịrị ahụ mgbe ọ na-eto. O biri nʼọzara ahụ ghọọ onye na-agba àkụ nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mgbe o bi nʼọzara Paran, nne ya chọtaara ya nwunye site nʼIjipt. ");
INSERT INTO ibo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nʼoge a, Abimelek na Fikọl onyeisi ndị agha ya, bịakwutere Ebraham sị ya, “Chineke nọnyeere gị nʼihe niile ị na-eme. ");
INSERT INTO ibo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ugbu a, ṅụọra m iyi nʼaha Chineke na ị gaghị aghọgbu m maọbụ ghọgbuo ụmụ m, maọbụ ụmụ ụmụ m. Gosi m nʼobodo a i bi nʼime ya dịka onye ọbịa ụdị obiọma m gosiri gị.” ");
INSERT INTO ibo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ebraham zara sị ya, “Ọ dị mma, aga m aṅụrụ gị iyi.” ");
INSERT INTO ibo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mgbe ahụ, Ebraham kọsaara Abimelek ihe banyere olulu mmiri nke ndị na-ejere ya ozi ji anya ike nara ndị na-ejere Ebraham ozi. ");
INSERT INTO ibo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek zara sị, “Amaghị m onye mere ihe dị otu a. Ị gwaghị m na ihe dị otu a mere, anụghị m ya ma ọ bụghị naanị taa.” ");
INSERT INTO ibo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mgbe ahụ, Ebraham kpụpụtara atụrụ, na ehi, nye Abimelek. Ha abụọ gbara ndụ nkwekọrịta. ");
INSERT INTO ibo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Mgbe Ebraham sitere nʼigwe atụrụ ya wepụta nne atụrụ asaa nupu ha ka ha nọpụ iche, ");
INSERT INTO ibo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek jụrụ Ebraham sị ya, “Gịnị ka i ji nne atụrụ asaa ndị a ị họpụtara iche eme?” ");
INSERT INTO ibo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ebraham zara sị, “Nabata ụmụ atụrụ asaa ndị a dịka ihe akaebe na-egosi na ọ bụ m gwuru olulu mmiri a.” ");
INSERT INTO ibo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ya mere, e bidoro ịkpọ ebe ahụ Bịasheba, nʼihi na nʼebe ahụ ka mmadụ abụọ a nọ ṅụrịtaara onwe ha iyi. ");
INSERT INTO ibo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mgbe ha gbachara ndụ nkwekọrịta na Bịasheba, Abimelek na Fikọl onyeisi agha ya laghachiri azụ nʼala ndị Filistia. ");
INSERT INTO ibo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ebraham kụrụ osisi tamarisk na Bịasheba. Ebe ahụ ka ọ nọ kpọkuo aha Onyenwe anyị, Chineke ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ebraham bigidere nʼala ndị Filistia ogologo oge. ");
INSERT INTO ibo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mgbe ihe ndị a gasịrị, Chineke nwara Ebraham. Ọ sịrị ya, “Ebraham.” Ebraham zara sị, “Lekwa m.” ");
INSERT INTO ibo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Chineke sịrị, “Duru nwa gị nwoke, naanị otu nwa gị nwoke, Aịzik onye ị hụrụ nʼanya, gaa nʼala Mọrịa. Jiri ya chụọrọ m aja nsure ọkụ nʼelu otu nʼime ugwu dị nʼebe m ga-egosi gị.” ");
INSERT INTO ibo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nʼisi ụtụtụ echi ya, Ebraham biliri kwadoo ịnyịnya ibu ya. O duuru ndị ikom abụọ na-ejere ya ozi, na nwa ya nwoke Aịzik. O gbutere nkụ ga-ezuru ya ịchụ aja nsure ọkụ, bilie gawa ebe ahụ Chineke gwara ya maka ya. ");
INSERT INTO ibo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nʼụbọchị nke atọ, Ebraham lepụrụ anya hụ ebe ahụ nʼebe dị anya. ");
INSERT INTO ibo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ọ gwara ndị na-ejere ya ozi sị, “Nọdụnụ nʼebe a, unu na ịnyịnya ibu anyị, ka mụ na nwokorobịa a gaa nʼebe ahụ. Anyị feecha ofufe, anyị ga-alọghachikwute unu ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebraham boro nwa ya nwoke Aịzik ukwu nkụ ahụ e ji achụ aja nsure ọkụ nʼisi, ma ya onwe ya jidere ọkụ na mma. ");
INSERT INTO ibo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aịzik gwara nna ya Ebraham sị, “Nna m.” Ebraham zara, “Ehee, nwa m.” Aịzik sịrị, “Ọkụ na nkụ dị nʼebe a, olee nwa atụrụ e ji achụ aja nsure ọkụ?” ");
INSERT INTO ibo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebraham zara, “Nwa m, Chineke nʼonwe ya ga-eweta nwa atụrụ e ji achụ aja nsure ọkụ.” Ha abụọ gakwara nʼihu nʼije ha. ");
INSERT INTO ibo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mgbe ha ruru ebe ahụ Chineke gwara ya maka ya, Ebraham wuru ebe ịchụ aja nʼebe ahụ, doo nkụ ndị ahụ niile nʼusoro nʼelu ya. O kere nwa ya Aịzik agbụ, tụkwasị ya nʼelu ebe ịchụ aja ahụ, na nʼelu nkụ ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Mgbe ahụ Ebraham setịpụrụ aka ya, welite mma ka o gbuo nwa ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma mmụọ ozi Onyenwe anyị si nʼeluigwe kpọọ ya oku sị ya, “Ebraham! Ebraham!” Ebraham zara, “Lekwa m nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ọ sịrị ya, “Emetụkwala nwokorobịa ahụ aka. Emekwala ya ihe ọbụla. Nʼihi na amatala m ugbu a na ị na-atụ egwu Chineke, ebe ọ bụ na i kwenyere iji nwa gị nwoke, naanị otu nwa nwoke i nwere chụọrọ m aja.” ");
INSERT INTO ibo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebraham leliri anya hụ otu ebule nke eriri ọhịa jidere na mpi ya. Ebraham gara jide ebule ahụ, were ya chụọ aja nsure ọkụ nʼọnọdụ nwa ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ya mere, Ebraham kpọrọ ebe ahụ, “Onyenwe anyị ga-arọpụta.” Ya mere ruo taa a na-asị, “Nʼugwu Onyenwe anyị, a ga-arọpụta.” ");
INSERT INTO ibo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mmụọ ozi Onyenwe anyị sitere nʼeluigwe kpọọ Ebraham oku nke ugboro abụọ, ");
INSERT INTO ibo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","sị, “Mụ onwe m, bụ Onyenwe anyị, ji onwe m na-aṅụ iyi na-ekwupụta sị, ebe ọ bụ na i mere ihe dị otu a, na i kwenyere iji nwa gị nwoke, naanị otu nwoke i nwere chụọrọ m aja, ");
INSERT INTO ibo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","aga m agọzi gị nʼezie, mekwa ka ụmụ ụmụ gị mụbaa nʼọnụọgụgụ dịka kpakpando nke mbara eluigwe na dịka aja dị nʼọnụ mmiri osimiri. Ụmụ ụmụ gị ga-enwetara onwe ha ọnụ ụzọ ama ndị iro ha. ");
INSERT INTO ibo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Sitekwa na mkpụrụ gị ka a ga-agọzikwa agbụrụ niile nọ nʼụwa, nʼihi na i rubeere m isi.” ");
INSERT INTO ibo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Emesịa, Ebraham laghachikwuru ndị na-ejere ya ozi. Ha niile laghachikwara Bịasheba. Ebraham birikwara na Bịasheba. ");
INSERT INTO ibo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mgbe ihe ndị a gasịrị, e ziri Ebraham ozi si ya, “Lee, Milka ya onwe ya amụkwaarala nwanne gị nwoke bụ Nahọ, ụmụ ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Aha ha bụ Uz, onye bụ ọkpara, na Buz nwanne ya, Kemuel bụ (nna Aram), ");
INSERT INTO ibo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazọ, Pildash, Jidlaf na Betuel.” ");
INSERT INTO ibo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel mụrụ Ribeka. Milka mụtaara Nahọ, nwanne Ebraham ụmụ ndị ikom asatọ ndị a. ");
INSERT INTO ibo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Iko ya nwanyị, onye aha ya bụ Reuma, mụkwaara ya ụmụ ndị ikom. Ha bụ Teba, Gaham, Tahash na Maaka. ");
INSERT INTO ibo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera dị ndụ ruo narị afọ na iri afọ abụọ na asaa. ");
INSERT INTO ibo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ọ nwụrụ na Kiriat Arba (nke bụ Hebrọn), nʼala Kenan. Ebraham ruru ụjụ nʼihi Sera, kwaa akwa nke ukwuu nʼihi ọnwụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ebraham sitere nʼebe ozu nwunye ya dị pụọ, jekwuru ụmụ Het gwa ha sị, ");
INSERT INTO ibo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Abụ m ọbịa na onye obodo ọzọ nʼetiti unu. Resinụ m ala m ji eme ebe olili nʼebe a, ka m nwee ike lie onye m nwụrụ anwụ.” ");
INSERT INTO ibo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ụmụ Het zara Ebraham sị, ");
INSERT INTO ibo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nna anyị ukwu, gee anyị ntị. Nwa eze dị ukwu ka ị bụ nʼetiti anyị, lie onye gị nwụrụ anwụ nʼili ahụ nke kachasị mma nʼime ili anyị nwere. O nweghị onye ọbụla nʼime anyị ga-ajụ inye gị ala olili ya maka ili onye gị nwụrụ anwụ.” ");
INSERT INTO ibo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mgbe ahụ, Ebraham biliri kpọọ isiala nʼihu ndị nwe ala, bụ ndị Het, ");
INSERT INTO ibo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","sị ha, “Ọ bụrụ ọchịchọ unu ka m lie onye m nwụrụ anwụ, geenụ m ntị ma rịọrọ m Efrọn nwa Zoha, ");
INSERT INTO ibo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ka o resi m ọgba Makipela, nke bụ nke ya, nke dị na ngwụsị ọhịa ya. Gwa ya ka o resi m ya nʼọnụ ahịa o ruru ka ọ bụrụ ebe olili m nwere nʼetiti unu.” ");
INSERT INTO ibo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrọn onye Het nʼonwe ya so nọdụ nʼebe ahụ nʼetiti ndị ya. Ọ zara Ebraham nʼihu ndị Het niile bịara nʼọnụ ụzọ ama obodo ");
INSERT INTO ibo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","sị ya, “Mba! Nna m ukwu, gee m ntị. Ana m enye gị ala ahụ na ọgba dị nʼime ya nʼihu ndị a niile bụ ndị m. Gaa lie onye gị nwụrụ anwụ nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ọzọ Ebraham kpọrọ isiala nye ndị nwe ala, ");
INSERT INTO ibo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ọ sịrị Efrọn, nʼihu ha niile, “Biko gee m ntị, aga m akwụ gị ọnụahịa iji zụọ ala ahụ. Nara m ya ka m nwee ike lie onye m nwụrụ anwụ nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrọn zara Ebraham, ");
INSERT INTO ibo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gee m ntị, nna m ukwu, ọ bụ ezie na ala ahụ ruru narị shekel ọlaọcha anọ, ma gịnị ka nke a bụ nʼetiti mụ na gị? Gaa lie onye gị nwụrụ anwụ nʼime ya.” ");
INSERT INTO ibo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ebraham kwenyere nʼego ole Efrọn chọrọ ka ọ kwụọ. O ji ihe ọtụtụ tụpụtara Efrọn ego ruru ọnụahịa ọ kpọrọ aha nʼihu ndị Het niile, narị shekel ọlaọcha anọ, dịka ihe ọtụtụ nke dị nʼoge ahụ nʼetiti ndị na-azụ ahịa. ");
INSERT INTO ibo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Site nʼoge ahụ, ala ahụ Efrọn nwere na Makipela, nke dị nso na Mamre, ala ahụ na ọgba dị nʼime ya, na osisi niile dị nʼime ala ahụ niile gburugburu, ");
INSERT INTO ibo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ghọrọ nke Ebraham dịka ihe nzụta ya nʼihu ụmụ Het, nʼihu ndị niile ndị bịara nʼọnụ ụzọ e si abata obodo ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Emesịa, Ebraham liri Sera nwunye ya nʼime ọgba ahụ dị nʼala dị na Makipela na nso Mamre (nke dị na Hebrọn) nʼala ndị Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ya mere, ala ahụ na ọgba dị nʼime ya ka ndị Het resiri Ebraham ka ọ bụrụ nke ya, ebe a na-eli ozu. ");
INSERT INTO ibo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ugbu a, Ebraham aghọọla agadi nʼahụ ya ma nʼọnụọgụgụ afọ ya. Onyenwe anyị agọziela ya nʼụzọ niile ");
INSERT INTO ibo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ọ gwara onyeisi ndị ozi nʼụlọ ya, onye nke na-elekọta ihe niile o nwere sị ya, “Tinye aka gị nʼokpuru apata m. ");
INSERT INTO ibo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Achọrọ m ka i jiri aha Onyenwe anyị Chineke nke eluigwe na ụwa, ṅụọra m iyi, na ị gaghị achọtara nwa m nwoke nwunye site nʼetiti ndị Kenan, ndị m bi nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kama na ị ga-aga nʼala nke m na ụmụnna m lụtara nwa m, bụ Aịzik, nwunye nʼetiti ụmụnna m.” ");
INSERT INTO ibo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ohu ahụ jụrụ ya, “Ọ bụrụkwanụ na nwaagbọghọ ahụ achọghị isoro m lọghachi nʼebe a, m ga-akpọrọ nwa gị nwoke laghachi nʼobodo i si bịa?” ");
INSERT INTO ibo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ebraham sịrị ya, “Lezie anya hụ na ị kpọghachighị nwa m nwoke nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Onyenwe anyị, Chineke nke eluigwe, bụ onye kpọpụtara m site nʼụlọ nna m nakwa obodo nke aka m, onye ahụ gwara m okwu ma kwem nkwa site nʼịṅụ iyi nye sị, ‘Aga m enye ụmụ ụmụ gị ala a.’ Ọ ga-ezipụ mmụọ ozi ya ka ọ gaa nʼihu gị ka i nwee ike inwetara nwa m nwoke nwunye site nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ma ọ bụrụ na nwanyị ahụ achọghị isoro gị lọghachi, mgbe ahụ, ị ga-abụ onye nwere onwe ya pụọ nʼiyi a ị ṅụrụ. Naanị na ị gaghị eme ka nwa m nwoke laghachi nʼebe ahụ.” ");
INSERT INTO ibo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ya mere, ohu ahụ tinyere aka ya nʼokpuru apata nna ya ukwu Ebraham, ṅụọ iyi banyere okwu ndị a. ");
INSERT INTO ibo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Emesịa, ohu a duuru ịnyịnya kamel iri nʼime ndị nna ya ukwu nwere pụọ. O sitekwara nʼaka nna ya ukwu were ihe ọma dị iche iche maka njem a, gawa Aram Naharaim, rute nʼobodo Nahọ. ");
INSERT INTO ibo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","O mere ka ịnyịnya kamel ndị ahụ makpuru ala nʼakụkụ olulu mmiri dị nʼazụ obodo ahụ. Ọ bụ nʼoge anyasị, oge ụmụ nwanyị ji apụta iseta mmiri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mgbe ahụ, o kpere ekpere sị, “Onyenwe anyị, Chineke nke nna m ukwu Ebraham, mee ka ihe gaara m nke ọma taa. Gosi nna m ukwu Ebraham obi ebere gị. ");
INSERT INTO ibo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lee, ana m eguzo nʼakụkụ isi iyi mmiri a, ụmụ nwanyị ndị obodo a na-abịa iseta mmiri. ");
INSERT INTO ibo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kwere ka o si otu a dịrị na nwaagbọghọ nke m ga-asị, ‘Biko, zie ite gị ka m ṅụrụ mmiri.’ Ọ bụrụ na onye ahụ asị m, ‘Ṅụọ, aga m ekutekwa mmiri nke ịnyịnya kamel gị ga-aṅụ,’ ka onye ahụ bụrụ onye ị họpụtara ohu gị Aịzik. Nʼụzọ dị otu a ka m ga-esi mata na i gosila nna m ukwu obi ebere.” ");
INSERT INTO ibo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tupu o kpechaa ekpere a, lekwa Ribeka ada Betuel, nwa nwoke Milka, onye bụ nwunye Nahọ, nwanne Ebraham. Ọ na-apụta bukwasị ite nʼubu ya. ");
INSERT INTO ibo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ọ bụ nwaagbọghọ mara mma nke ukwuu, onye na-amatabeghị nwoke, nke nwoke ọbụla na-edinabeghị. Ọ gara nʼolulu mmiri kujuo ite ya si nʼebe ahụ na-arịgopụta. ");
INSERT INTO ibo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ohu ahụ mere ngwangwa jekwuru ya sị ya, “Biko nyetụ m mmiri si nʼite mmiri gị.” ");
INSERT INTO ibo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ọ mere ngwangwa budata ite ahụ nʼaka ya, hulata ya si ya, “Ṅụọ, onyenwe m.” ");
INSERT INTO ibo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mgbe o nyechara ya mmiri, ọ sịrị, “Aga m ekutekwa mmiri nye ịnyịnya kamel gị ndị a ruo mgbe ha ṅụjuru afọ.” ");
INSERT INTO ibo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ngwangwa, ọ wụpụrụ mmiri dị nʼite ya nʼime ihe anụ ụlọ ji aṅụ mmiri, gbara ọsọ gaa kute mmiri ọzọ na-agbanye nʼime ihe ahụ. O kugidere mmiri tutu ruo mgbe ịnyịnya kamel ndị ahụ ṅụjuchara afọ. ");
INSERT INTO ibo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mgbe ihe ndị a na-eme, ohu ahụ gbara nkịtị na-ele ya anya ịchọpụta ma Onyenwe anyị emeela ka ije ya bụrụ ihe gara nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mgbe ịnyịnya kamel ndị ahụ ṅụsịrị mmiri, nwoke ahụ wepụtara mgbanimi ọlaedo nke ọtụtụ ya bụ otu beka, na mgbaaka ọlaedo abụọ nke ọtụtụ ha bụ shekel iri. ");
INSERT INTO ibo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ọ jụrụ ya sị, “Nwa onye ka ị bụ? Ohere ọ dị nʼụlọ nna gị ebe mụ na ịnyịnya kamel ndị a ga-anọ nʼabalị a?” ");
INSERT INTO ibo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ọ zara sị ya, “Abụ m nwa Betuel, nwa Milka nwunye Nahọ.” ");
INSERT INTO ibo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ọ sịkwara, “Anyị nwere nri anụ ụlọ, nweekwa ebe ị ga-edina nʼabalị a.” ");
INSERT INTO ibo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nwoke ahụ hulatara ala kpọọ isiala nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kwuo sị, “Ngọzị dịrị Onyenwe anyị, bụ Chineke nna m ukwu Ebraham, onye na-esitebeghị nʼebe nna m ukwu nọ wezuga ebere ya na ikwesi ntụkwasị obi ya. Ma banyere mụ onwe m, Onyenwe anyị e duola m nʼije a, kpọrọ m rute nʼụlọ ndị ikwu nna m ukwu.” ");
INSERT INTO ibo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nwaagbọghọ ahụ gbalara gaa kọọrọ ndị ezinaụlọ nne ya ihe ndị a. ");
INSERT INTO ibo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribeka nwere otu nwanne nwoke aha ya bụ Leban. Leban gbara ọsọ gbakwuje nwoke ahụ nʼisi iyi mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mgbe ọ hụrụ mgbanimi, na mgbaaka ndị ahụ nwanne ya nwanyị yi nʼaka ya, ma nụkwa ihe Ribeka kwuru banyere ihe nwoke ahụ gwara ya, o jekwuru nwoke ahụ, hụ ya ka ya na ịnyịnya kamel ya guzo nʼakụkụ olulu mmiri. ");
INSERT INTO ibo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ọ sịrị ya, “Bịa, gị onye Onyenwe anyị gọziri. Gịnị mere i ji guzo nʼebe a. Edozielara m gị ụlọ ebe ị ga-edina na ebe ịnyịnya kamel ndị a ga-anọ.” ");
INSERT INTO ibo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ya mere, nwoke ahụ gara nʼụlọ, ebe Leban nyere aka butukwaara ya ibu nke ịnyịnya kamel ndị ahụ bu. E wetara nri nye ịnyịnya kamel ndị ahụ, wetara ya mmiri nke ya na ndị ikom so ya ji saa ụkwụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","E doziri ya ihe oriri, ma ọ zara sị, “Agaghị m eri ihe ọbụla tutu ruo mgbe m kwuru ihe m ji bịa.” Leban sịrị, “Ngwa, kwuonụ.” ");
INSERT INTO ibo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ya mere, ọ sịrị, “Abụ m ohu Ebraham. ");
INSERT INTO ibo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Onyenwe anyị agọziela nna m ukwu, mee ya ka ọ bụrụ ọgaranya. O nyela ya igwe atụrụ, na igwe ehi, na ọlaọcha na ọlaedo, na ọtụtụ ndị ohu nwoke na nwanyị, na ịnyịnya kamel, na ịnyịnya ibu. ");
INSERT INTO ibo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sera nwunye nna m ukwu mụtaara ya otu nwa nwoke mgbe o merela agadi. Ihe niile nna m ukwu nwere ka o nyefere nwa ahụ nʼaka. ");
INSERT INTO ibo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nna m ukwu mere ka m ṅụọra ya iyi sị, ‘Ị gaghị esite nʼetiti ụmụ ndị inyom Kenan ndị anyị bi nʼala ha lụtara nwa m nwoke nwunye. ");
INSERT INTO ibo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kama ị ga-aga nʼezinaụlọ nna m, na nke ndị ikwu m chọtara nwa m nwoke nwunye.’ ");
INSERT INTO ibo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mgbe ahụ, ajụrụ m nna m ukwu, ‘Ọ bụrụkwanụ na nwanyị ahụ ekweghị iso m lọghachi?’ ");
INSERT INTO ibo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ọ sịrị, ‘Onyenwe anyị, onye m na-ejegharị nʼihu ya, ga-eziga mmụọ ozi ya ka o soro gị gaa ime ka ije gị nwee isi, ka i nwee ike chọtara nwa m nwoke nwanyị site nʼetiti ndị ikwu m na ezinaụlọ nna m. ");
INSERT INTO ibo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ị ga-abụ onye nwere onwe gị site nʼiyi ị ṅụrụ ma ọ bụrụ na mgbe i gakwuru ndị ikwu m, ha jụrụ ịkpọnye gị nwanyị ahụ. Ị ga-abụ onye nwere onwe gị site nʼiyi ị ṅụrụ m.’ ");
INSERT INTO ibo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mgbe m rutere nʼisi iyi mmiri taa, ekwuru m sị, ‘Onyenwe anyị Chineke nna m ukwu Ebraham, ọ bụrụ na ọ masị gị, biko mee ka ije a m bịara bụrụ nke ga-aga nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Lee, ka m na-eguzo nʼakụkụ isi iyi mmiri a, ka nwaagbọghọ ahụ bịara ikuru mmiri nke m ga-asị, “Biko kwere ka m si nʼite gị ṅụrụtụ ntakịrị mmiri,” ");
INSERT INTO ibo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ma ọ bụrụ na ọ sị m, “Ṅụọ, aga m ekutekwa mmiri nye ịnyịnya kamel gị ndị a,” ka onye dị otu a bụrụ nwanyị ahụ Onyenwe anyị chọtaara Aịzik nwa nna m ukwu.’ ");
INSERT INTO ibo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Tupu m kpesịa ekpere a nʼobi m, lekwa Ribeka ka o bụ ite mmiri ya nʼubu ya na-abịa. Ọ gbadara nʼisi iyi mmiri ahụ kute mmiri. Asịrị m ya, ‘Biko nye m mmiri ka m ṅụọ.’ ");
INSERT INTO ibo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ngwangwa, o sitere nʼubu ya budata ite, sị m, ‘Ṅụọ, aga m ekutekwa mmiri nke ịnyịnya kamel ndị a ga-aṅụ.’ Ya mere, aṅụrụ m, o nyekwara ịnyịnya kamel m ndị ahụ mmiri ha ṅụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mgbe ahụ, ajụrụ m ya, ‘Nwa onye ka ị bụ?’ “Ọ sịrị m, ‘Abụ m nwa Betuel onye bụ nwa Nahọ nke Milka mụtaara ya.’ “Mgbe ahụ etinyere m ya mgbanimi ahụ nʼimi ya, tinyekwa ọlaaka ahụ nʼaka ya abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ehulatara m ala kpọọ isiala nye Onyenwe anyị. Etoro m Onyenwe anyị, Chineke nke nna m ukwu Ebraham, onye duru m nʼezi ụzọ inweta nwa nwanne nna m ukwu dịka nwunye nwa ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ugbu a, ọ bụrụ na unu ga-egosi nna m ukwu obiọma na ikwesi ntụkwasị obi gwanụ m. Ọ bụrụkwanụ na ọ gaghị esi otu a dịrị, gwanụ m ka m mata ụzọ m ga-agbaso.” ");
INSERT INTO ibo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leban na Betuel zara sị ya, “Ihe niile si nʼaka Onyenwe anyị. Anyị enweghị ike ịgwa gị okwu ọjọọ maọbụ nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lee Ribeka, kpọrọ ya laa, ka ọ bụrụ nwunye nwa nna gị ukwu, dịka Onyenwe anyị kwuru.” ");
INSERT INTO ibo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mgbe ohu Ebraham nụrụ ihe ha kwuru, ọ dara nʼala kpọọ isiala nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mgbe ahụ kwa, ohu ahụ wepụtara ihe ịchọ mma ọlaedo, na ọlaọcha dị iche iche na uwe nye ha Ribeka. Ọ wepụtakwara onyinye ndị ọzọ dị oke ọnụahịa nye nwanne ya nwoke na nne ya. ");
INSERT INTO ibo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Emesịa, mgbe ihe ndị a gasịrị, ya na ndị ikom so ya riri, ṅụọ, dinaakwa nʼabalị ahụ. Mgbe ha si nʼụra teta, o kwuru sị, “Zilaga m ka m lakwuru nna m ukwu.” ");
INSERT INTO ibo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma Leban na nne ya zara sị ya, “Ka nwantakịrị nwanyị a nọnyere anyị ihe dịka ụbọchị iri tupu o soro gị laa.” ");
INSERT INTO ibo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ma ọ zara ha sị, “Unu egbochila anyị. Ebe ọ bụ na Onyenwe anyị emeela ka ije m bụrụ ihe gara nke ọma, zilaga m ka m laghachikwuru nna m ukwu.” ");
INSERT INTO ibo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ha zara sị ya, “Ka anyị kpọọ nwantakịrị nwanyị ahụ jụọ ya ihe bụ uche ya.” ");
INSERT INTO ibo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ya mere ha kpọrọ Ribeka jụọ ya sị, “Ị ga-eso nwoke a gaa?” Ọ zara sị, “E, aga m aga.” ");
INSERT INTO ibo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ya mere, ha zipụrụ nwanne ha nwanyị Ribeka, tinyere nwanyị lekọtara ya anya mgbe ọ dị na nwantakịrị, na ohu Ebraham na ndị ikom so ya. ");
INSERT INTO ibo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ha gọziri Ribeka sị ya, “Nwanne anyị nwanyị mụọ ọmụmụ, mụruo puku kwụrụ puku, ka mkpụrụ afọ gị nwetara onwe ha, ọnụ ụzọ ama ndị iro ha.” ");
INSERT INTO ibo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ribeka biliri, ya na ndị inyom na-ejere ya ozi, ha rigoro nʼelu ịnyịnya kamel ndị ahụ, soro nwoke ahụ. Ya mere, ohu ahụ duuru Ribeka laa. ");
INSERT INTO ibo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nʼoge a, Aịzik bịara nʼebe mbata obodo Bịa-Lahai-Rọị nʼihi na o bi na Negev. ");
INSERT INTO ibo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Aịzik pụtara ịtụgharị uche nʼọhịa nʼoge uhuruchi. Ọ lepụrụ anya hụ ọtụtụ ịnyịnya kamel na-abịanụ. ");
INSERT INTO ibo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribeka nʼonwe ya lepụkwara anya hụ Aịzik. O sitere nʼelu ịnyịnya kamel rịdata, ");
INSERT INTO ibo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","jụọ ohu ahụ sị, “Onye bụ nwoke a si nʼọhịa na-abịa izute anyị?” Ohu ahụ zara sị ya, “Ọ bụ nna m ukwu” Nʼihi nke a, Ribeka weere akwa mkpudo ya kpuchie ihu ya. ");
INSERT INTO ibo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ohu ahụ kọọrọ Aịzik akụkọ otu ije ya niile si gaa. ");
INSERT INTO ibo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aịzik kpọbatara Ribeka nʼụlọ ikwu Sera, nne ya. Ọ lụrụ Ribeka, onye ghọrọ nwunye ya. Aịzik hụrụ ya nʼanya, ma nweta nkasiobi nʼihi ọnwụ nne ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebraham lụrụ nwunye ọzọ, onye aha ya bụ Ketura. ");
INSERT INTO ibo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ọ mụụrụ ya Zimran, Jokshan, Medan, Midian, Ishbak na Shua. ");
INSERT INTO ibo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan bụ nna Sheba na Dedan. Ụmụ ndị ikom Dedan bụ Ashurim, Letushim, na Leumim. ");
INSERT INTO ibo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ụmụ ndị ikom Midian bụ Efaa, Efe, Hanok, Abida, na Eldaa. Ndị a niile bụ ụmụ Ketura. ");
INSERT INTO ibo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebraham nyere Aịzik ihe niile o nwere. ");
INSERT INTO ibo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ebraham nyere ụmụ ndị ikom ndị iko ya nwanyị mụtara onyinye dị iche iche, zipụ ha nʼala dị nʼebe ọwụwa anyanwụ, mgbe ọ ka nọ ndụ, ka ha ghara ịnọ nwa ya nwoke Aịzik nso. ");
INSERT INTO ibo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ebraham dị ndụ ruo narị afọ na iri afọ asaa na ise. ");
INSERT INTO ibo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ebraham kubiri ume ndụ nwụọ mgbe o mere nnọọ ezigbo agadi, agadi nwoke nke ndụ juru afọ, e mere ka ọ lakwuru ndị ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ụmụ ya, Aịzik na Ishmel, liri ya nʼọgba Makipela nʼakụkụ Mamre, nʼala ubi Efrọn nwa Zoha onye Het, ");
INSERT INTO ibo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ala ahụ Ebraham zụrụ site nʼaka ndị Het. Ebe ahụ ka e liri Ebraham ya na Sera nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mgbe Ebraham nwụrụ, Chineke gọziri nwa ya nwoke Aịzik onye bi nʼoge ahụ na nso nso Bịa-Lahai-Rọị. ");
INSERT INTO ibo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nke a bụ akụkọ banyere usoro ezinaụlọ Ishmel nwa Ebraham onye Hega, nwanyị Ijipt ahụ na-ejere Sera ozi mụụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ndị a bụ aha ụmụ ndị ikom Ishmel nʼusoro ọmụmụ ha. Nebaiot bụ nwa mbụ ya. Ndị ọzọ bụ Keda, Adbel, Mibsam, ");
INSERT INTO ibo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO ibo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetua, Nafish na Kedema. ");
INSERT INTO ibo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ndị a bụ ụmụ Ishmel, ndị a bụkwa aha ndịisi ikwu iri na abụọ ha, dịka ebe obibi ha si dị, na dịka ọmụma ụlọ ikwu ha si dị. ");
INSERT INTO ibo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmel biri ndụ ruo narị afọ na iri afọ na asaa. Ọ nwụrụ, e mere ka ọ lakwuru ndị ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ụmụ ụmụ ya bi nʼala dị site na Havila ruo Shua nso nso oke ala ndị Ijipt, nʼụzọ e si aga Ashọ. Ha na ụmụnna ha ndị ọzọ ebighị nʼudo. ");
INSERT INTO ibo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nke a bụ akụkọ banyere usoro agbụrụ Aịzik nwa Ebraham. Ebraham bụ nna Aịzik. ");
INSERT INTO ibo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aịzik gbara iri afọ anọ mgbe ọ lụrụ Ribeka, nwa Betuel, onye Aram si nʼobodo Padan Aram, nwanne Leban, onye Aram. ");
INSERT INTO ibo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aịzik kpere ekpere rịọọ Onyenwe anyị ka o nye nwunye ya nwa nʼihi na ọ bụ nwanyị aga. Onyenwe anyị zara ekpere ya. Nwunye ya, Ribeka dịịrị ime. ");
INSERT INTO ibo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ụmụ o bu nʼafọ bidoro na-alụ ọgụ nʼime afọ ya. Nʼihi nke a, o kwuru sị, “Gịnị mere ihe dị otu a ji eme m?” Ya mere, ọ gara jụta ase nʼaka Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Onyenwe anyị gwara ya sị, “Mba abụọ dị gị nʼafọ, ụzọ mba abụọ dị nʼime gị ka a ga-ekewa. Otu ụzọ ga-adị ike karịa nke ọzọ, nke okenye ga-ejere nke nta ozi.” ");
INSERT INTO ibo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mgbe oge ime ya zuru, ụmụ abụọ dị nʼakpanwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ahụ nwa nke mbụ buru ụzọ pụta na-acha uhie uhie, ahụ ya niile dịka uwe ajị. Nʼihi ya, ha kpọrọ aha ya Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Emesịa, nwanne ya pụtara, ma aka ya jidere ikiri ụkwụ Ịsọ. Nʼihi ya, a kpọrọ aha ya Jekọb. Aịzik gbara iri afọ isii mgbe Ribeka mụrụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ha abụọ toro, Ịsọ ghọrọ onye ọka nʼịchụ nta, onye na-epiogharị nʼọhịa, ebe Jekọb bụ nwoke dị nwayọọ, onye na-anọ nʼetiti ụlọ ikwu. ");
INSERT INTO ibo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aịzik hụrụ Ịsọ nʼanya nʼihi na ụtọ anụ Ịsọ na-egbute nʼọhịa na-adị ya mma, ma Ribeka hụrụ Jekọb nʼanya. ");
INSERT INTO ibo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Otu ụbọchị, Jekọb nọ na-esi ofe mgbe Ịsọ si nʼọhịa bata. Agụụ na-agụkwa ya nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ịsọ rịọrọ Jekọb sị, “Nyetụ m ụfọdụ nʼime nri a na-acha uhie uhie ị na-esi ka m rie, nʼihi na agụụ na-agụ m hie nne.” (Ọ bụ ihe a mere e ji na-akpọ ya Edọm.) ");
INSERT INTO ibo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Jekọb zara ya, “Buru ụzọ resi m ọnọdụ ịbụ ọkpara gị.” ");
INSERT INTO ibo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ịsọ sịrị, “Gịnị bụ uru ọnọdụ ịbụ ọkpara bara mgbe m na-anwụ nʼagụụ?” ");
INSERT INTO ibo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jekọb sịrị ya, “Buru ụzọ ṅụọrọ m iyi.” Ya mere, ọ ṅụụrụ ya iyi, sị otu a resi Jekọb ọnọdụ ọkpara ya. ");
INSERT INTO ibo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Mgbe ahụ, Jekọb nyere Ịsọ achịcha na ofe lentil o siri. O riri, ṅụọkwa, bilie ọtọ pụọ. Ya mere Ịsọ ledara ọnọdụ ịbụ ọkpara nna ya anya. ");
INSERT INTO ibo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nʼoge a, ụnwụ dara nʼala ahụ. Ụnwụ a dị iche nʼụnwụ mbụ nke dara nʼoge Ebraham dị ndụ. Aịzik jekwuru Abimelek eze ndị Filistia nʼobodo Gera. ");
INSERT INTO ibo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Onyenwe anyị gosiri Aịzik onwe ya, sị, “Agakwala Ijipt; biri nʼala ahụ m sị gị biri nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nọrọ nʼala a nwa oge nta, aga m anọnyere gị ma gọziekwa gị, nʼihi na gị na ụmụ ụmụ gị ka m ga-enye ala ndị a niile. Aga m emezukwa iyi ahụ m ṅụrụ nye Ebraham nna gị. ");
INSERT INTO ibo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aga m eme ka ụmụ ụmụ gị mụbaa, mee ka ha hie nne nʼọnụọgụgụ dịka kpakpando dị na mbara eluigwe. Ha ka m ga-enye ala ndị a niile. Aga m esite na mkpụrụ gị gọzie mba niile nke ụwa. ");
INSERT INTO ibo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ihe ndị a niile ka m ga-eme nʼihi na Ebraham rubere isi ime ihe m gwara ya, na idebe iwu m na ụkpụrụ m, na ịdọ aka na ntị m.” ");
INSERT INTO ibo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ya mere, Aịzik nọgidere nʼobodo Gera. ");
INSERT INTO ibo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mgbe ndị obodo ahụ jụrụ ya banyere nwunye ya, ọ gwara ha sị, “Ọ bụ nwanne m nwanyị.” Ọ tụrụ ụjọ ị sị ha, “Nwunye m ka ọ bụ,” O chere nʼobi ya sị, “Ndị ikom obodo a nwere ike gbuo m nʼihi Ribeka. Nʼihi na Ribeka nʼonwe ya mara mma ile anya.” ");
INSERT INTO ibo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mgbe Aịzik nọrọ ebe ahụ ogologo oge, Abimelek eze ndị Filistia, sitere na oghereikuku ya lepụ anya hụ Aịzik ka ọ nọ na-egwusa Ribeka nwunye ya egwu. ");
INSERT INTO ibo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ya mere, Abimelek kpọrọ Aịzik sị, “Nwunye gị ka ọ bụ nʼezie. Gịnị mere i ji gwa anyị na ọ bụ nwanne gị nwanyị?” Aịzik zara ya, “Ọ bụ nʼihi na m chere na-enwere ike igbu m nʼihi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek sịrị, “Gịnị bụ ihe a i mere anyị? Otu nwoke nʼetiti anyị gaara akpọrọ nwunye gị dinaa ya. Ị gaara esi otu a wetara anyị ikpe ọmụma.” ");
INSERT INTO ibo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ya mere, Abimelek nyere ndị niile ya iwu, sị ha, “Onye ọbụla metụrụ nwoke a maọbụ nwunye ya aka, aghaghị ime ka ọ nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aịzik kụrụ mkpụrụ ubi nʼala ahụ. Nʼotu afọ ahụ kwa, o si nʼala ahụ webata ihe ubi narị okpukpu karịa nke ọ kụrụ, nʼihi na Onyenwe anyị gọziri ya. ");
INSERT INTO ibo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nwoke a bara ụba, ghọọ ọgaranya. Akụnụba ya gara nʼihu na-amụba, tutu ruo mgbe ọ ghọrọ nnọọ onye ọgaranya a ma ama. ");
INSERT INTO ibo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","O nwere ọtụtụ igwe anụ ụlọ, na igwe ehi, na ndị ikom na-ejere ya ozi. Nʼihi ihe ndị a, ndị Filistia bidoro inwe anya ukwu megide ya. ");
INSERT INTO ibo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ndị Filistia wụjuru aja nʼolulu mmiri ndị ahụ niile ndị na-ejere nna ya ozi gwuru nʼoge nna ya Ebraham dị ndụ. ");
INSERT INTO ibo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek kpọrọ Aịzik sị ya, “Si nʼala a kwapụ gaa nʼebe ọzọ, nʼihi na ịba ụba gị na ịdị ike gị adịla ukwuu karịa nke anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ya mere Aịzik si nʼebe ahụ kwapụ, gaa maa ụlọ ikwu ya na Ndagwurugwu Gera, biri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","O gwugharịkwara olulu mmiri ndị ahụ e gwuru nʼoge nna ya Ebraham, nke ndị Filistia kpojuru aja mgbe Ebraham nwụrụ, kpọọ olulu mmiri ndị a otu aha ahụ nna ya kpọrọ ha na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ọzọ, ndị na-ejere Aịzik ozi gwuru olulu mmiri ọhụrụ na ndagwurugwu Gera ahụ, gwute mmiri nke si nʼala na-asọpụta. ");
INSERT INTO ibo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma ndị ọzụzụ anụ ụlọ obodo Gera sesịrị ndị ọzụzụ anụ ụlọ Aịzik okwu. Ha kwuru sị, “Mmiri a bụ nke anyị!” Nke a mere Aịzik ji kpọọ olulu mmiri ahụ Esek, nʼihi ise okwu nke ha sesịrị ya. ");
INSERT INTO ibo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ha gwuru olulu mmiri ọzọ, ma ndị ahụ bịakwara ọzọ bido ịzọ ya. Nʼihi ya Aịzik kpọrọ olulu mmiri ahụ Sitna. ");
INSERT INTO ibo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","O si nʼebe ahụ pụọ gaa nʼebe ọzọ gwuo olulu mmiri ọzọ. Ma o nweghị ndị bịara zọọ ya. Nʼihi ya ọ kpọrọ olulu mmiri ahụ Rehobọt. O kwuru sị, “Ugbu a, Onyenwe anyị enyela anyị ebe sara mbara, ebe ihe ga-anọ gaara anyị nke ọma.” ");
INSERT INTO ibo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","O sitere nʼebe ahụ kwapụ gaa Bịasheba. ");
INSERT INTO ibo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nʼabalị ahụ, Onyenwe anyị mere ka ọ hụ ya anya, sị ya, “Abụ m Chineke nna gị Ebraham. Atụla egwu, nʼihi na anọnyere m gị, aga m agọzi gị, mụbaa ọnụọgụgụ ụmụ ụmụ gị nʼihi ohu m Ebraham.” ");
INSERT INTO ibo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ya mere, o wuru ebe ịchụ aja nʼebe ahụ kpọkuo aha Onyenwe anyị. Ọ makwara ụlọ ikwu ya nʼebe ahụ. Ndị na-ejere ya ozi gwukwara olulu mmiri. ");
INSERT INTO ibo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek na Ahuzat, onye ndụmọdụ ya, na Fikọl onyeisi ndị agha ya sitere Gera jekwuru Aịzik. ");
INSERT INTO ibo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aịzik jụrụ ha sị, “Gịnị mere unu ji bịakwute m, ebe ọ bụ na unu kpọrọ m asị, chụpụkwa m site nʼetiti unu?” ");
INSERT INTO ibo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ha sị, “Anyị hụrụ nke ọma na Onyenwe anyị nọnyeere gị, ya mere anyị ji sị, ‘O kwesiri ka ịṅụ iyi dị nʼetiti anyị na gị,’ ka anyị na gị gbaakwa ndụ ");
INSERT INTO ibo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","na ị gaghị eme anyị ihe ọjọọ dịka anyị na-esighị mee gị ihe ọjọọ. I lezie anya nke ọma, ị ga-ahụ na anyị meere gị ihe ọma mgbe anyị hapụrụ gị ka ị laa nʼudo. Ugbu a, anyị maara na ị bụ onye Onyenwe anyị gọziri agọzi.” ");
INSERT INTO ibo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aịzik meere ha mmemme nri dị ukwuu; ha riri, ṅụọkwa. ");
INSERT INTO ibo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nʼisi ụtụtụ echi ya, ndị ikom ahụ niile ṅụrịtaara onwe ha iyi ịgba ndụ. Aịzik zilagara ha, ha hapụrụ ya laa nʼudo. ");
INSERT INTO ibo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nʼotu ụbọchị ahụ kwa, ndị ohu Aịzik bịakwutere ya gwa ya banyere olulu mmiri ha na-egwu, sị ya, “Anyị achọtala mmiri nʼolulu ahụ anyị na-egwu.” ");
INSERT INTO ibo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ọ kpọrọ ya Shiba. Ọ bụkwa nke a mere e ji akpọ obodo ahụ Bịasheba ruo taa. ");
INSERT INTO ibo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mgbe Ịsọ gbara iri afọ anọ, ọ lụrụ Judit nwa Beiri, onye Het. Ọ lụkwara Basemat nwa Elọn, onye Het. ");
INSERT INTO ibo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ha ghọrọ Aịzik na Ribeka ihe ọnọdụ obi ilu. ");
INSERT INTO ibo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Mgbe Aịzik ghọrọ agadi, nʼoge anya ya na-adịghị ahụzi ụzọ nke ọma, ọ kpọrọ Ịsọ ọkpara ya, sị ya, “Nwa m nwoke.” Ọ zara sị, “Lee m nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aịzik gwara ya sị, “Ugbu a, emeela m agadi, amakwaghị m ụbọchị ọnwụ m. ");
INSERT INTO ibo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ya mere, were ihe ịchụ nta gị, ụta gị na àkụ gị, gaa nʼọhịa, gbutere m anụ. ");
INSERT INTO ibo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Siere m nri ụtọ otu ahụ o si amasị m, butere m ya ka m rie, ka mụ onwe m gọzie gị tupu m nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma Ribeka nọ na-ege ntị mgbe Aịzik na-agwa nwa ya Ịsọ okwu. Nke mere na mgbe Ịsọ gawara nʼọhịa ịchụ nta, ");
INSERT INTO ibo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribeka gwara Jekọb nwa ya okwu sị ya, “Lee, anụrụ m ka nna gị na-agwa nwanne gị Ịsọ okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Gaa nʼọhịa gbute anụ, siere m nri ụtọ, ka m nọdụ nʼihu Onyenwe anyị nye gị ngọzị ikpeazụ tupu m nwụọ.’ ");
INSERT INTO ibo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ugbu a, nwa m nwoke, gee ntị nke ọma, mee ihe niile m gwara gị. ");
INSERT INTO ibo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gaa ugbu a nʼigwe anụ ụlọ wetara m ụmụ nwa ewu abụọ dị mma ka m jiri ha siere nna gị nri dị ụtọ, ụdị ahụ na-amasị ya. ");
INSERT INTO ibo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ị ga-eburu ya bujere nna gị ka o rie, ka ya onwe ya gọzie gị tupu ọ nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Jekọb gwara Ribeka nne ya okwu sị ya, “Nwanne m nwoke Ịsọ bụ onye gbara ajị. Ahụ nke m na-akwọ mụrụmụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Gịnị ga-eme ma nna m metụ m aka nʼahụ? Nʼihi ya, aga m abụ onye na-aghọ ya aghụghọ, aga m esi otu a wetara onwe m ịbụ ọnụ kama ngọzị.” ");
INSERT INTO ibo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nne ya gwara ya sị, “Nwa m nwoke ka ọbụbụ ọnụ gị dakwasị m. Naanị mee ihe m kwuru. Gaa wetara m ha.” ");
INSERT INTO ibo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ya mere, ọ gara weta ha nye nne ya. O ji ha sie nri dị ụtọ, ụdị nke na-amasị nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Emesịa, Ribeka chịpụtara uwe Ịsọ ọkpara ya, ndị dị mma, ndị ọ debere nʼụlọ ya, nye ya nwa ya nta bụ Jekọb. ");
INSERT INTO ibo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","O jikwa akpụkpọ anụ ụmụ ewu nwere ajị ajị kee Jekọb nʼaka na nʼakụkụ olu ya na-akwọ mụrụmụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","O bunyere nwa ya nwoke Jekọb nri ahụ na-atọ ụtọ, na achịcha o mere. ");
INSERT INTO ibo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","O jekwuuru nna ya sị ya, “Nna m.” Ọ zara sị, “Ahaa, nwa m, onye ka ị bụ?” ");
INSERT INTO ibo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jekọb zara nna ya sị ya, “Abụ m Ịsọ, ọkpara gị. Emeela m ihe ị sị m mee. Biko bilie ka i rie anụ m gbutere nʼọhịa, ka gị onwe gị gọzie m.” ");
INSERT INTO ibo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma Aịzik jụrụ nwa ya nwoke sị, “Olee otu i si chọta ya ngwangwa, nwa m?” Jekọb zara ya sị, “Ọ bụ Onyenwe anyị Chineke gị mere ka ihe gaara m nke ọma.” ");
INSERT INTO ibo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Mgbe ahụ Aịzik gwara Jekọb sị, “Bịa nso ka m metụ gị aka nwa m nwoke, ka m mata ma ị bụ Ịsọ nʼeziokwu.” ");
INSERT INTO ibo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jekọb jere nna ya Aịzik nso, onye metụrụ ya aka kwuo sị, “Olu bụ olu Jekọb ma aka gị bụ aka Ịsọ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ọ chọpụtaghị na ọ bụ Jekọb, nʼihi na aka ya dị ajị ajị dịka nke Ịsọ. Ya mere, ọ gọziri ya. ");
INSERT INTO ibo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ma ọ jụkwara ya ajụjụ ọzọ sị ya, “Ị bụ nwa m nwoke Ịsọ nʼeziokwu?” Jekọb zara sị ya, “E, abụ m ya.” ");
INSERT INTO ibo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mgbe ahụ, Aịzik zara sị ya, “Butere m ụfọdụ nʼime anụ ahụ i gbutere ka m rie, nye gị ngọzị m.” Jekọb butere ya bunye ya. O riri ya. ");
INSERT INTO ibo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mgbe ahụ, nna ya Aịzik sịrị ya, “Bịa nʼebe a nwa m nwoke, sutu m ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ya mere, o jekwuuru ya sutu ya ọnụ. Mgbe Aịzik nụrụ isisi uwe ya, ọ gọziri ya, sị, “Nʼezie, isisi nwa m nwoke dịka isisi ala ubi nke Onyenwe anyị gọziri. ");
INSERT INTO ibo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ka Chineke nye gị site nʼigirigi nke eluigwe, na mmanụ nke ala, ụba nke mkpụrụ ubi na mmanya ọhụrụ ");
INSERT INTO ibo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ka ọtụtụ mba jeere gị ozi, ka ndị mmadụ kpọọ isiala nye gị. Bụrụ onye ọchịchị nʼebe ụmụnna gị nọ, ka ụmụ nne gị mụrụ kpọọ isiala nye gị. Ka ndị niile na-abụ gị ọnụ bụrụ ndị a bụrụ ọnụ, ka ndị na-agọzi gị bụrụ ndị a gọziri agọzi.” ");
INSERT INTO ibo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mgbe Aịzik gọzichara Jekọb, ka Jekọb si nʼihu ya na-apụ, lee Ịsọ ka o si ịchụ nta na-alọbata. ");
INSERT INTO ibo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ya onwe ya sikwara nri na-atọ ụtọ butere nna ya. Mgbe ahụ, ọ gwara ya sị, “Ka nna m, bilie, rie anụ nwa ya si nʼọhịa gbute, ka gị onwe gị nye m ngọzị gị.” ");
INSERT INTO ibo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aịzik zara sị ya, “Ị bụ onye?” Ọ zara sị, “Abụ m nwa gị nwoke Ịsọ, ọkpara gị Ịsọ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Oke ahụ ọma jijiji mara Aịzik, ọ sị, “Onye kwanụ bụ onye ahụ gara gbute anụ butere m ya? Eriri m ya tupu ị bata. Agọziri m ya. Nʼezie, onye a gọziri agọzi ka ọ ga-abụ.” ");
INSERT INTO ibo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mgbe Ịsọ nụrụ okwu ndị a si nʼọnụ nna ya, o jiri oke olu kwaa akwa nke obi ilu gwa nna ya sị ya, “Gọzie m, mụ onwe m, nna m.” ");
INSERT INTO ibo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma ọ zara sị ya, “Nwanne gị ejirila ụzọ aghụghọ bịa nara ngọzị gị.” ");
INSERT INTO ibo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ịsọ kwuru sị, “E meziri kpọọ ya Jekọb, onye aghụghọ. Lee, ọ ghọgbuola m ugboro abụọ. Nke mbụ, ọ naara m ọnọdụ ịbụ ọkpara m, ugbu a ọ narakwala m ngọzị m.” Ọ jụrụ ajụjụ sị, “Ọ bụ na i nweghị ngọzị ọ bụla fọdụrụ nke ị ga-agọzi m?” ");
INSERT INTO ibo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aịzik zara sị ya, “Emeela m ya ka ọ bụrụ onyeisi nʼebe ị nọ, mee ụmụnna ya niile ndị na-ejere ya ozi. Enyela m ya mkpụrụ ubi niile na mmanya ọhụrụ. Gịnị ọzọ ka m nwere ike imere gị, nwa m nwoke?” ");
INSERT INTO ibo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ịsọ jụrụ nna ya sị, “Nna m, ọ bụ naanị otu ngọzị ka i nwere? Gọziekwa m nna m!” Ịsọ kwara akwa nʼoke olu. ");
INSERT INTO ibo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nna ya Aịzik zara sị ya, “Ebe obibi gị ga-adịpụ adịpụ, site nʼebe akụnụba nke ala dị, site nʼebe igirigi nke eluigwe dị. ");
INSERT INTO ibo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nriju afọ gị ga-abụ site na mma agha, ị ga-ejekwara nwanne gị ozi. Ma mgbe i mesịrị nwere onwe gị, ị ga-atọpụ agbụ ya, site nʼolu gị.” ");
INSERT INTO ibo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ịsọ buru iro nʼobi megide Jekọb nʼihi ngọzị ahụ nna ya nyere ya. O kwuru nʼime onwe ya sị, “Oge a ga-eru ụjụ nʼihi nna m na-abịa nso, nʼoge ahụ aga m egbu nwanne m Jekọb.” ");
INSERT INTO ibo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mgbe a gwara Ribeka ihe nwa ya nwoke nke okenye bụ Ịsọ kwuru, o ziri kpọọ nwa ya nwoke nke nta bụ Jekọb sị ya, “Lee, Ịsọ nwanne gị na-akasị onwe ya obi site nʼechiche ọ na-eche igbu gị. ");
INSERT INTO ibo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nʼihi nke a, nwa m nwoke, mee ihe m gwara gị, gbapụ ọsọ ngwangwa, gbakwuru nwanne m Leban na Haran, ");
INSERT INTO ibo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nọdụ nʼebe ahụ ruo mgbe iwe nwanne gị ga-adajụ. ");
INSERT INTO ibo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mgbe nwanne gị kwụsịrị iwe iwe megide gị, mgbe o chefuru ihe i mere ya, aga m ezitere gị ozi ka ị lọta. Nʼihi gịnị ka m ga-eji gbara aka unu abụọ nʼotu ụbọchị.” ");
INSERT INTO ibo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Mgbe ahụ Ribeka gara gwa Aịzik sị, “Ike ịdị ndụ agwụla m nʼihi ndị inyom Het ndị a. Ọ bụrụ na Jekọb esite nʼetiti ndị inyom ala a, site nʼetiti ndị inyom Het ndị a lụọ nwunye, mara na ọnwụ ga-akara m ịdị ndụ mma.” ");
INSERT INTO ibo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aịzik kpọrọ Jekọb gọzie ya, nye ya iwu sị ya, “Alụla nwunye site nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kama bilie gaa Padan Aram nʼụlọ nna nne gị, Betuel, lụrụ nwunye site nʼụmụ ndị inyom Leban. ");
INSERT INTO ibo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ka Chineke Onye pụrụ ime ihe niile, gọzie gị, mee ka ị mịa mkpụrụ, mụbaa, ghọọ ọtụtụ mba. ");
INSERT INTO ibo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ka Chineke nye gị na ụmụ ụmụ gị ngọzị ahụ o kwere nkwa inye Ebraham. Ka i nweta ala a, nke i bi nʼime ya ugbu a dịka ọbịa, bụ ala ahụ Chineke kwere Ebraham na nkwa inye ya.” ");
INSERT INTO ibo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mgbe ahụ Aịzik zipụrụ Jekọb nʼije ya, ọ gara Padan Aram, nʼụlọ Leban nwa Betuel onye Aram, nwanne Ribeka onye bụ nne Jekọb na Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ịsọ hụrụ ka Aịzik siri gọzie Jekọb, ziga ya Padan Aram ka ọ gaa lụọ nwunye nʼebe ahụ, nyekwa ya iwu mgbe ọ na-agọzi ya sị, “Alụla nwanyị na Kenan,” ");
INSERT INTO ibo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jekọb rubekwara nna ya na nne ya isi gawa Padan Aram. ");
INSERT INTO ibo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","O dokwara Ịsọ anya na ndị inyom Kenan dị njọ nʼanya nna ya Aịzik. ");
INSERT INTO ibo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nʼihi ya, Ịsọ gakwuru Ishmel lụrụ Mahalat, ada Ishmel, nwa Ebraham, onye bụ nwanyị Nebaiot, tinyekwara ndị nwunye ọ lụrụ na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jekọb hapụrụ Bịasheba gawa Haran. ");
INSERT INTO ibo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Mgbe chi na-eji, ọ kwụsịrị ebe ọ ga-anọ zuo ike abalị. Mgbe ọ chọrọ idina ala, o weere otu nʼime nkume ndị dị nʼebe ahụ hinye nʼisi ya, dinara ala ịrahụ ụra. ");
INSERT INTO ibo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nʼabalị ahụ, ọ rọrọ nrọ, hụ mbube e ji arị elu. E mere ka o guzo site nʼụwa ruo nʼeluigwe. Ọ hụkwara ndị mmụọ ozi Chineke ka ha si na ya na-arịgo na-arịdakwa. ");
INSERT INTO ibo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nʼelu ya, ọ hụrụ Onyenwe anyị ka o guzo, nụkwa ka ọ na-agwa ya okwu sị, “Mụ onwe m bụ Onyenwe anyị, Chineke nna gị Ebraham, na Chineke Aịzik. Aga m enye gị na ụmụ ụmụ gị ala ahụ nke i dina nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ụmụ gị ga-adị ukwuu, dị ka aja dị nʼala. Ha ga-ejupụta ala a, site nʼọwụwa anyanwụ ruo nʼọdịda anyanwụ, sitekwa nʼugwu ruo na ndịda. A ga-esitekwa na gị na mkpụrụ gị, gọzie mba niile nke ụwa a. ");
INSERT INTO ibo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Anọnyeere m gị. Aga m echebe gị ebe ọbụla ị na-aga. Aga m akpọghachite gị nʼala a. Agaghị m ahapụ gị tutu ruo mgbe m mezuoro gị ihe niile m kwere gị na nkwa.” ");
INSERT INTO ibo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jekọb tetara nʼụra sị, “Nʼezie Onyenwe anyị nọ nʼebe a. Ma amaghị m ya.” ");
INSERT INTO ibo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ọ tụrụ egwu sị, “Lee ka ebe a si dị oke egwu, o nweghị ihe ebe a bụ karịa ụlọ Chineke, nʼezie ọ bụ ọnụ ụzọ ama eluigwe.” ");
INSERT INTO ibo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nʼisi ụtụtụ echi ya, Jekọb weere nkume ahụ o hinyere nʼisi ya guzo ya dịka ogidi, wụsa mmanụ nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ọ kpọrọ ebe ahụ Betel, ọ bụ ezie na Luz bụ aha obodo ahụ na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Mgbe ahụ, Jekọb kwere nkwa sị, “Ọ bụrụ na Chineke ga-anọnyere m, chebe m nʼije m na-eje, ọ bụrụ na ọ ga-enye m ihe oriri m ga-eri na uwe m ga-eyi, ");
INSERT INTO ibo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","m lọghachi nʼụlọ nna m nʼudo, mgbe ahụ, Onyenwe anyị ga-abụ Chineke m. ");
INSERT INTO ibo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nkume a m doziri elu dịka ogidi ga-abụ ụlọ Chineke. Aga m eke ihe niile i nyere m ụzọ iri, nyeghachi gị otu ụzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jekọb gara nʼihu nʼije ya rute nʼala dị nʼọwụwa anyanwụ. ");
INSERT INTO ibo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","NʼEbe Nsọ a, ọ hụrụ otu olulu mmiri, hụkwa ụzọ igwe atụrụ atọ ndị nọ nʼakụkụ olulu mmiri nʼihi na ndị na-elekọta ha na-enye ha mmiri site nʼolulu mmiri ahụ. Nkume e ji mechie ọnụ olulu mmiri ahụ buru ibu. ");
INSERT INTO ibo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nʼihi na mgbe igwe atụrụ niile bịazukọtara nʼolulu mmiri ahụ, ndị ọzụzụ atụrụ na-emeghepụ nkume ahụ nye ha mmiri. Emesịa, ha na-ejikwa nkume ahụ mechie ọnụ olulu mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jekọb jekwuru ndị na-elekọta atụrụ ahụ jụọ ha sị, “Ụmụnna m, ebee ka unu si?” Ha zara sị ya, “Anyị si Haran.” ");
INSERT INTO ibo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ọ jụrụ ha sị, “Unu maara Leban, nwa Nahọ?” Ha zara sị, “Anyị ma ya.” ");
INSERT INTO ibo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ọzọ Jekọb jụrụ ha sị, “Ahụ ọ dịkwa ya mma?” Ha zara sị ya, “E, ahụ dị ya. Lee nwa ya nwanyị Rechel ka ọ chị atụrụ ya na-abịa.” ");
INSERT INTO ibo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jekọb kwuru sị, “Lee, anyanwụ ka na-acha. O rubeghị oge e ji achịbata igwe ụmụ anụ ụlọ. Nyenụ ha mmiri ka ha ṅụọ, ka ha laghachi gaa taa ahịhịa.” ");
INSERT INTO ibo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ha zara sị ya, “Anyị agaghị enye ha mmiri tutu ruo mgbe igwe atụrụ niile bịakọtara, mgbe e wepụrụ nkume e ji mechie ọnụ olulu mmiri, mgbe ahụ ka anyị ga-enye ha mmiri.” ");
INSERT INTO ibo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mgbe Jekọb na ndị ọzụzụ atụrụ ndị a kpụ okwu nʼọnụ, Rechel chịịrị atụrụ nna ya bịakwute ha, nʼihi na onye ọzụzụ atụrụ nwanyị ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mgbe Jekọb hụrụ Rechel nwa Leban nwanne nne ya, hụkwa igwe atụrụ Leban, ọ meghepụrụ nkume ahụ e ji mechie ọnụ olulu mmiri ahụ nye igwe atụrụ Leban, nwanne nne ya mmiri ka ha ṅụọ. ");
INSERT INTO ibo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Emesịa, Jekọb suturu Rechel ọnụ, kwaa akwa nʼoke olu. ");
INSERT INTO ibo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jekọb kọwaara Rechel na ọ bụ onye ikwu nna ya, bụrụkwa nwa Ribeka. Nʼihi ya Rechel ji ọsọ gbalaa nʼụlọ ha kọọrọ nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mgbe Leban nụrụ maka Jekọb nwa nwanne ya nwanyị, o mere ngwangwa pụọ izute ya. Ọ makụrụ ya, sutu ya ọnụ, kpọrọ ya laa nʼụlọ. Nʼebe ahụ, Jekọb kọọrọ ya ihe ndị a niile. ");
INSERT INTO ibo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Leban sịrị ya, “Nʼezie, ị bụ ọkpụkpụ m na anụ ahụ m.” Ọ nọnyeere ya otu ọnwa. ");
INSERT INTO ibo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Leban sịrị Jekọb, “Ọ bụ nʼihi na ị bụ onye ikwu m ka ị na-agbara m odibo nʼefu? Gwa m ego ole m ga-akwụ gị nʼihi ọrụ ị na-arụrụ m?” ");
INSERT INTO ibo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leban mụrụ ụmụ ndị inyom abụọ. Aha nke okenye bụ Lịa. Aha nke nta bụ Rechel. ");
INSERT INTO ibo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ịma mma Lịa dị ya nʼanya, ma Rechel mara mma nʼahụ, maakwa mma ile anya. ");
INSERT INTO ibo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ọ bụ Rechel ka Jekọb hụrụ nʼanya. Nʼihi ya Jekọb gwara Leban sị, “Aga m arụrụ gị ọrụ afọ asaa ma ọ bụrụ na ị ga-ekwe ka m lụọ Rechel.” ");
INSERT INTO ibo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leban zara Jekọb sị ya, “Ọ dị mma na ị lụrụ Rechel karịa na onye ọzọ ga-alụ ya. Soro m nọdụ nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ya mere Jekọb gbara odibo afọ asaa maka Rechel. Ma afọ asaa ndị a dịka abalị ole na ole nʼanya Jekọb nʼihi ịhụnanya o nwere nʼebe Rechel nọ. ");
INSERT INTO ibo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jekọb gwara Leban, okwu sị ya, “Kpọnye m nwunye m nʼihi nʼụbọchị m ezuola. Achọrọ m ịbakwuru ya.” ");
INSERT INTO ibo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Leban kpọkọtara ndị niile bi nʼebe ahụ mere ha nʼoke oriri. ");
INSERT INTO ibo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nʼanyasị ụbọchị ahụ, Leban kpọọrọ nwa ya nwanyị bụ Lịa kpọbara Jekọb, ọ bakwuuru ya. ");
INSERT INTO ibo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Leban nyekwara Lịa odibo ya, Zilpa, ka ọ bụrụ odibo nwanyị ya. ");
INSERT INTO ibo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mgbe chi bọrọ, Jekọb hụrụ na ọ bụ Lịa ka Leban kpọnyere ya. Jekọb sịrị Leban, “Gịnị bụ ihe a i mere m? Ọ bụghị nʼihi Rechel ka m ji gbaara gị odibo? Gịnị mere i ji ghọgbuo m?” ");
INSERT INTO ibo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Leban zara sị ya, “Ọ bụghị omenaala anyị ibu ụzọ kee nwantakịrị nwanyị nke nta di tupu nke ada. ");
INSERT INTO ibo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Otu ọ dị, chere ka mmemme izu ụka nke onye nke a gafee. Mgbe ahụ, aga m akpọnyekwa gị onye nke ọzọ a maka odibo ị ga-agbara m afọ asaa ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jekọb mere ka o si kwuo. O debezuru mmemme otu izu ụka onye nke a, Leban kpọnyere ya nwa ya Rechel ka ọ bụrụ nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Leban nyere nwa ya nwanyị, Rechel, odibo ya nwanyị bụ Bilha, ka ọ bụrụ odibo ya. ");
INSERT INTO ibo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jekọb bakwukwara Rechel. Ọ hụrụ Rechel nʼanya nke ukwuu karịa Lịa. Ọ gbakwaara Leban odibo afọ asaa ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mgbe Onyenwe anyị hụrụ na Lịa bụ nwanyị a kpọrọ asị, o meghere akpanwa ya, ma Rechel bụ nwanyị aga. ");
INSERT INTO ibo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lịa tụrụ ime mụọ nwa nwoke, kpọọ ya Ruben. Nʼihi na o kwuru sị, “Ọ bụ nʼihi na Onyenwe anyị ahụla nsogbu m, ugbu a di m ga-ahụ m nʼanya.” ");
INSERT INTO ibo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ọ tụụrụ ime ọzọ mụọkwa nwa nwoke. O kwuru sị, “Onyenwe anyị anụla na m bụ nwanyị a kpọrọ asị, ọ bụ ya mere o ji nye m nwa nwoke ọzọ.” Ya mere ọ kpọrọ aha ya Simiọn. ");
INSERT INTO ibo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lịa tụrụ ime ọzọ, mgbe ọ mụrụ nwa nwoke, o kwuru sị, “Nʼezie, ugbu a ka di m ga-arapara m nʼahụ, nʼihi na amụọrala m ya ụmụ ndị ikom atọ.” Ya mere ọ kpọrọ aha ya Livayị. ");
INSERT INTO ibo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ọ tụụrụ ime ọzọ mụọ nwa nwoke. O kwuru sị, “Ugbu a aga m eto Onyenwe anyị.” Ya mere, ọ kpọrọ aha ya Juda. Lịa mụsịrị nwa a kwụsị ịmụ ụmụ. ");
INSERT INTO ibo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rechel hụrụ na ya amụghị nwa ọbụla nye Jekọb, o kworo ekworo megide nwanne ya nwanyị. Ya mere, ọ sịrị Jekọb, “Nye m ụmụ. Ọ bụrụ na i meghị otu a, aga m anwụ.” ");
INSERT INTO ibo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jekọb were iwe megide Rechel, sị ya, “Abụ m Chineke onye gbochiri gị mkpụrụ nke afọ?” ");
INSERT INTO ibo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Mgbe ahụ Rechel gwara Jekọb sị ya, “Lee odibo m nwanyị Bilha, bakwuru ya ka ọ mụọ nwa nʼikpere m abụọ, ka mụ onwe m site na ya bụrụkwa onye mụtara ụmụ.” ");
INSERT INTO ibo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rechel nyere Jekọb Bilha, odibo nwanyị ya, Jekọb bakwuuru ya. ");
INSERT INTO ibo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha tụụrụ ime mụọra Jekọb nwa nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nke a mere ka Rechel kwuo sị, “Chineke ekpepụtala m. Ọ nụla arịrịọ m nye m nwa nwoke.” Nʼihi nke a, Rechel gụrụ nwa ahụ Dan. ");
INSERT INTO ibo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, odibo nwanyị Rechel, tụụrụ ime ọzọ mụtara Jekọb nwa nwoke nke abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rechel kwuru sị, “Mgba dị ukwuu ka mụ na nwanne m nwanyị gbara, m merie.” Ọ kpọọ ya Naftalị. ");
INSERT INTO ibo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lịa hụrụ na ya akwụsịla ịmụ nwa, ọ kpọọrọ Zilpa, odibo ya nwanyị kpọnye Jekọb ka ọ bụrụ nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, odibo nwanyị Lịa, mụtara Jekọb nwa nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Mgbe nke a mere, Lịa kwuru sị, “Nke a bụ ihuọma.” Ọ kpọrọ nwa ahụ Gad. ");
INSERT INTO ibo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, odibo nwanyị Lịa mụtaara Jekọb nwa nwoke nke abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Mgbe ahụ Lịa kwuru sị, “Ọṅụ ejula m obi, nʼihi na ụmụ nwanyị ibe m ga-akpọ m onye ihe na-agara nke ọma.” Lịa kpọrọ nwantakịrị nwoke ahụ Asha. ");
INSERT INTO ibo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Otu ụbọchị, nʼoge a na-aghọ ọka wiiti, Ruben nwa Lịa, gara nʼọhịa hụ ahịhịa a na-akpọ mandreki. Ọ kụtaara nne ya ụfọdụ nʼime ahịhịa a. Mgbe Rechel hụrụ ahịhịa a, ọ rịọrọ Lịa sị ya, “Biko nyetụ m ụfọdụ nʼime mandreki ndị a nwa gị nwoke kụtara.” ");
INSERT INTO ibo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma Lịa zara sị ya, “O zubeere gị na ị napụrụ m di m? Ị chọkwara ịnapụ m mandreki ndị a nwa m nwoke wetaara m?” Rechel zara Lịa sị, “Ọ dị mma, ka gị na ya dinaa nʼabalị a ka ọ bụrụ ihe mgbanwo maka mandreki nwa gị nwoke.” ");
INSERT INTO ibo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ya mere, mgbe Jekọb si nʼọhịa na-alọbata nʼuhuruchi ụbọchị ahụ, Lịa pụrụ izute ya, sị ya, “Ị ga-abakwute m nʼihi na m ejirila m ahịhịa mandreki nwa m nwoke m zụta gị.” Ha dinara nʼabalị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Chineke nụrụ olu Lịa, ọ tụụrụ ime mụtara Jekọb nwa nwoke nke ise. ");
INSERT INTO ibo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lịa sịrị, “Chineke akwụọla m ụgwọ maka odibo m nwanyị m nyere di m.” Ya mere ọ kpọrọ aha ya Isaka. ");
INSERT INTO ibo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lịa tụkwaara ime ọzọ mụtara Jekọb nwa nwoke nke isii. ");
INSERT INTO ibo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ugbu a Lịa kwuru sị, “Chineke enyela m ezi onyinye dị oke ọnụ. Ugbu a, di m ga-eji nkwanye ugwu leta m nʼihi na amụọrala m ya ụmụ ndị ikom isii.” Ọ kpọrọ aha ya Zebụlọn. ");
INSERT INTO ibo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Emesịa, Lịa mụrụ nwa nwanyị, kpọọ ya Daịna. ");
INSERT INTO ibo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Chineke chetara Rechel. Ọ nụrụ olu ya, meghee akpanwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nʼihi ya, Rechel tụụrụ ime mụta nwa nwoke. Ọ sịrị, “Chineke ewepụla nkọcha dịịrị m.” ");
INSERT INTO ibo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rechel kpọrọ aha ya Josef, dị ka ọ sịrị, “Ka Onyenwe anyị nyekwa m nwa nwoke ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mgbe Rechel mụsịrị Josef, Jekọb jekwuru Leban sị ya, “Zilaga m ka m laghachi nʼebe m na ala nke m. ");
INSERT INTO ibo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kpọnye m ndị nwunye m, ndị m ji nʼihi ha gbara gị odibo, ha na ụmụ m, ka m lakwaa. Ị maara otu m siri gbaara gị odibo. Kpọnye m ha ka m duru ha laghachi ebe m si bịa.” ");
INSERT INTO ibo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Leban sịrị Jekọb, “Ọ bụrụ na m achọtala amara nʼihu gị biko nọdụ, nʼihi na esi m nʼịgba afa chọpụta na Onyenwe anyị agọziela m nʼihi gị.” ");
INSERT INTO ibo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Leban sịrị, “Kwuo ego ole ị chọrọ ka m kwụọ gị, aga m akwụ ya.” ");
INSERT INTO ibo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jekọb zara sị Leban, “Gị onwe gị maara otu m si gbara gị odibo na ihe mere igwe anụ ụlọ gị ndị m lekọtara. ");
INSERT INTO ibo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nʼihi na ole na ole ka i nwere mgbe m bịara, ma ugbu a, ha abaala ụba nke ukwuu. Onyenwe anyị esitela nʼụkwụ m gọzie gị. Ugbu a, kedụ mgbe m ga-arụkwanụ ọrụ nke mụ onwe m maka ezinaụlọ m?” ");
INSERT INTO ibo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Leban jụrụ Jekọb sị, “Kedụ ihe m ga-enye gị?” Jekọb gwara ya sị, “Enyela m ihe ọbụla, kama o nwere otu ihe m chọrọ ka i mee. Ọ bụrụ na i mee ya, aga m alaghachi ilekọta igwe anụ ụlọ gị. ");
INSERT INTO ibo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kwere ka m jegharịa nʼetiti igwe anụ ụlọ gị, ka m họpụta site nʼetiti igwe atụrụ gị ndị niile tụrụ agwa agwa, na ụmụ atụrụ niile dị oji, na ewu niile tụrụ agwa agwa. Atụrụ na ewu ndị a niile m ga-ahọpụta ga-abụ ụgwọ ọrụ m. ");
INSERT INTO ibo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ezi omume m ga-azara nʼọdịnihu, mgbe ọbụla ị bịara nyochaa ụgwọ ọrụ ị kwụrụ m. Ewu ọbụla na-atụghị agwa agwa, maọbụ atụrụ ọbụla na-ejighị oji ị chọpụtara nʼetiti igwe ewu na atụrụ nke m ka a ga-agụ dị ka ihe e zuru nʼohi.” ");
INSERT INTO ibo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leban zara sị ya, “Ọ dị mma. Ya dịrị dịka i kwuru.” ");
INSERT INTO ibo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nʼotu ụbọchị ahụ, ọ họpụtachara mkpi niile tụrụ agwa maọbụ ntụpọ na nne ewu niile ndị nwere tụrụ agwa maọbụ ntụpọ na nke ọbụla nwere ajị ọcha nʼahụ ya. Ọ họpụtakwara atụrụ ojii niile, nyefee ha nʼaka ụmụ ya ka ha lekọtaa ha. ");
INSERT INTO ibo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Leban jere ije abalị atọ nke kewapụrụ ha site nʼebe Jekọb nọ. Ma Jekọb nọgidere na-elekọta igwe anụ ụlọ Leban ndị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mgbe ahụ Jekọb gara gbute ngalaba osisi pọpla, na osisi alụmọnd, na osisi plenụ, kpechapụ ahụ agbụgbọ osisi ndị a, si otu a mee ka ime ime ngalaba osisi ndị a dị ọcha pụta ìhè. ");
INSERT INTO ibo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ọ tọgbọrọ osisi ndị a o kpechapụtara nʼebe ewu na atụrụ ndị a na-aṅụ mmiri, ka ha cherịta ịhụ ebe igwe anụ ụlọ ndị a nọ mgbe ọbụla ha na-aṅụ mmiri. Nke a mere mgbe igwe anụ ụlọ ndị a na-enwe ekpomọkụ nke ịgba ibe ha, nʼoge ha bịara ịṅụ mmiri, ");
INSERT INTO ibo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ọ bụ nʼihu ngalaba osisi ndị a ka ha na-anọ na-agba onwe ha. Mgbe anụ ụlọ ndị a mụrụ ụmụ, ahụ ụmụ ha na-atụ agwa agwa maọbụ nwe ntụpọ. ");
INSERT INTO ibo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jekọb na-edo ụmụ igwe ewu na atụrụ ndị a nʼotu akụkụ, ma ọ na-eme ka anụ ụlọ ndị ọzọ chee ihu ha nʼanụ ụlọ Leban ndị tụrụ agwa agwa, maọbụ na-eji oji. Nʼụzọ dị otu a, ọ kewapụtaara onwe ya anụ ụlọ nke ya. O tinyekọtaghị ha nʼanụ ụlọ Leban. ");
INSERT INTO ibo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mgbe ọbụla nne anụ ụlọ ndị ahụ siri ike nọ nʼọnọdụ ịtụrụ ime, Jekọb na-edobe ngalaba osisi ndị ahụ nʼakụkụ ebe ha na-aṅụ mmiri nʼihu ha, ka ha nọrọ nʼebe ahụ gbaa onwe ha. ");
INSERT INTO ibo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma ọ bụrụ na anụ ụlọ ndị ahụ adịghị ike, Jekọb anaghị edebe osisi ndị a nʼihu ha. Ya mere, igwe ewu na atụrụ ndị na-esighị ike gaara Leban. Ma ndị siri ike gaara Jekọb. ");
INSERT INTO ibo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Site nʼụzọ dị otu a, Jekọb ghọrọ onye nwere akụ hie nne. O nwekwara ọtụtụ igwe anụ ụlọ na ọtụtụ ndị na-ejere ya ozi nwoke na nwanyị, na ọtụtụ ịnyịnya kamel, na ọtụtụ ịnyịnya ibu ndị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jekọb nụrụ na ụmụ ndị ikom Leban na-asị, “Jekọb ewerechaala ihe niile nna anyị nwere. O sitere nʼihe nna anyị nwere kpata akụnụba ya niile.” ");
INSERT INTO ibo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jekọb hụkwara na omume Leban nʼebe ọ nọ adịghịkwa otu ọ dị na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mgbe ahụ, Onyenwe anyị sịrị Jekọb, “Laghachi nʼala nna gị ha, lakwuru ụmụnna gị, aga m anọnyere gị.” ");
INSERT INTO ibo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ya mere, Jekọb ziri Rechel na Lịa ozi ka ha bịakwute ya nʼọhịa ebe ọ nọ na-elekọta igwe anụ ụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ọ sịrị ha, “Ahụla m na omume nna unu nʼebe m nọ adịghịkwa otu ọ dị na mbụ. Ma Chineke nna m ha nọnyeere m. ");
INSERT INTO ibo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Unu maara na eji m ike m niile rụọra nna unu ọrụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ma nna unu ghọgburu m, gbanwee ụgwọ ọrụ m ugboro iri. Otu ọ dị, Chineke ekweghị ka nna unu merụọ m ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ọ bụrụ na ọ sị, ‘Ndị tụrụ agwa agwa ga-abụ ụgwọ ọrụ gị,’ mgbe ahụ, igwe anụ ụlọ niile na-amụ ụmụ na-abụ ndị tụrụ agwa. Ma ọ bụrụ na ọ sị, ‘Ndị niile nwere ntụpọ ga-abụ ụgwọ ọrụ gị,’ mgbe ahụ, igwe anụ ụlọ niile na-amụ ụmụ na-enwe ntụpọ ọcha nʼahụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Chineke napụrụ nna unu anụ ụlọ ya ma nye m ha. ");
INSERT INTO ibo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Nʼoge ụmụ anụ ụlọ ji atụ ime, eweliri m anya hụ na nrọ na ụmụ mkpi niile na-agba igwe nne ewu bụ ụmụ mkpi ndị tụrụ agwa agwa, ndị nwere akara maọbụ ndị nwere ntụpọ ọcha nʼahụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mgbe ahụ, mmụọ ozi Chineke sịrị m na nrọ, ‘Jekọb.’ Azara m sị, ‘Lee m nʼebe a.’ ");
INSERT INTO ibo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ọ sịrị m, ‘Lelie anya gị elu, lee ka ị hụ na mkpi niile na-agba igwe nne ewu ndị a bụ mkpi ndị ahụ tụrụ agwa agwa, ndị nwere akara maọbụ ndị nwere ntụpọ ọcha. Nʼihi na ahụla m ihe niile Leban na-eme gị. ");
INSERT INTO ibo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mụ onwe m bụ Chineke nke Betel, ebe ị wụkwasịrị mmanụ nʼogidi nkume ahụ, ebe ị kwekwara m nkwa. Ugbu a, kulie, hapụ obodo a, laghachi nʼala a nọ mụọ gị.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rechel na Lịa zara sị ya, “Anyị ka nwere oke nʼihe nketa nʼụlọ nna anyị? ");
INSERT INTO ibo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ọ bụghị dịka ndị ọbịa ka ọ gụnyeziri anyị? Nʼihi na o reela anyị, ripịakwa ụgwọ isi anyị. ");
INSERT INTO ibo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nʼezie, akụ ndị ahụ Chineke napụrụ nna anyị bụ nke anyị na nke ụmụ anyị. Ya mere, mee ihe ọbụla Chineke sị gị mee.” ");
INSERT INTO ibo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jekọb biliri, kukwasị ụmụ ya na ndị nwunye ya nʼelu ịnyịnya kamel, ");
INSERT INTO ibo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","duru igwe anụ ụlọ ya niile, na ihe ọ kpatara na Padan Aram, lakwuru nna ya Aịzik nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ka Leban gara ịkpachapụ ajị ụmụ atụrụ ya, Rechel zuuru arụsị ezinaụlọ nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jekọb ghọkwara Leban onye Aram aghụghọ nʼihi na ọ gwaghị ya na ọ na-agbapụ ọsọ. ");
INSERT INTO ibo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ya mere, o buru ihe niile o nwere gbapụ ọsọ, gbafee iyi ukwu Yufretis, chee ihu nʼala ugwu ugwu Gilead. ");
INSERT INTO ibo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Abalị atọ agafeelarị tupu a gwa Leban na Jekọb agbalaala. ");
INSERT INTO ibo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","O duuru ndị ikwu ya chụọ Jekọb ọsọ abalị asaa tupu ọ chụkwute ya nʼala ugwu ugwu Gilead. ");
INSERT INTO ibo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ma Chineke bịakwutere Leban onye Aram na nrọ nʼabalị sị ya, “Kpachapụ anya gị, hụ na o nweghị ihe ị gwara Jekọb, maọbụ okwu dị mma, maọbụ nke dị njọ.” ");
INSERT INTO ibo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekọb amaala ụlọ ikwu ya nʼala ugwu Gilead mgbe Leban chụkwutere ya. Leban na ndị ikwu ya makwara ụlọ ikwu nke ha nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Leban sịrị Jekọb, “Gịnị bụ ihe a i mere? Ị ghọgbuola m. I burula ụmụ m ndị inyom dịka ndị a dọtara nʼagha? ");
INSERT INTO ibo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gịnị mere i ji ghọgbuo m, zoro ezo gbapụ? Gịnị mere ị gwaghị m ka m jiri ọṅụ na ịbụ abụ nke ya na ịkpọ ụbọ akwara na iti ịgba so, zilaga gị? ");
INSERT INTO ibo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Gịnị mere i nyeghị m ohere ka m sutu ụmụ ụmụ m na ụmụ m ndị inyom ọnụ sị ha laa nke ọma? Omume a i mere bụ omume nzuzu. ");
INSERT INTO ibo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Enwere m ike merụọ gị ahụ ugbu a, ma Chineke nke nna gị mere ka m hụ ya anya na nrọ nʼabalị gara aga. Ọ dọrọ m aka na ntị sị m, ‘Kpachapụ anya gị hụ na o nweghị ihe ị gwara Jekọb, maọbụ okwu dị mma, maọbụ nke dị njọ.’ ");
INSERT INTO ibo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ugbu a, ị na-ala nʼihi na ọ gụrụ gị agụụ ịlaghachi nʼụlọ nna gị, ma gịnị mere i ji zuru chi m?” ");
INSERT INTO ibo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jekọb zara sị Leban, “Nʼihi na m tụrụ egwu, nʼihi na m chere sị na ị ga-eji ike napụ m ụmụ gị ndị inyom a. ");
INSERT INTO ibo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma ọ bụrụ na ị chọta onye ọbụla ji chi gị ndị a, onye ahụ ga-anwụ. Nʼihu ndị ikwu gị ndị a, chọgharịa nʼonwe gị, lee ma ị ga-achọta ihe ọbụla bụ nke gị dị m nʼaka. Ọ bụrụ na ị chọta ya, were ya.” Ma Jekọb amaghị na Rechel zuuru chi ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ya mere, Leban bara nʼụlọ ikwu Jekọb, na nʼime ụlọ ikwu Lịa, na nʼime ụlọ ikwu ndị odibo nwanyị abụọ ya, ma o nweghị ihe ọ chọtara. O sitere nʼụlọ ikwu Lịa pụta baa nʼụlọ ikwu Rechel. ");
INSERT INTO ibo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nʼoge a, Rechel ewerela arụsị ezinaụlọ ndị ahụ tinye ha nʼime akwa e ji anọkwasị nʼelu ịnyịnya kamel nọdụ ọdụ nʼelu ya. Leban chọgharịrị ebe niile nʼime ụlọ ikwu ahụ ma ọ chọtaghị arụsị ezinaụlọ ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Mgbe ahụ, Rechel gwara nna ya Leban sị, “Biko, ewela iwe nna m ukwu, nʼihi na enweghị m ike ibili ọtọ nʼihu gị. Anọ m nʼọnọdụ ndị inyom na-anọ kwa ọnwa.” Leban chọgharịrị ebe niile, ma ọ hụghị arụsị ezinaụlọ ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iwe were Jekọb megide Leban. O ji iwe jụọ Leban sị, “Gịnị bụ njehie m? Gịnị bụ mmehie m mere i ji si otu a na-achụsi m ike? ");
INSERT INTO ibo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ugbu a, ị chọgharịala nʼibu m niile, gịnị ka ị chọtara bụ nke gị? Wepụta ya nʼihu ndị ikwu gị na nʼihu ndị nke m, ka ha kpeere mụ na gị ikpe. ");
INSERT INTO ibo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Iri afọ abụọ ka mụ na gị nọrọ. O nweghị mgbe ime pụrụ ụmụ ewu na atụrụ gị; o nwekwaghị mgbe m riri ebule si nʼigwe anụ ụlọ gị. ");
INSERT INTO ibo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","O nweghị mgbe m welataara gị anụ ụlọ nke anụ ọhịa dọgburu, kama akwụrụ m ụgwọ ha. I mekwara ka m kwụghachi gị anụ ụlọ ọbụla e zuru nʼohi, maọbụ nʼehihie, maọbụ nʼabalị. ");
INSERT INTO ibo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nʼime oke anwụ nke ehihie ka m rụụrụ gị ọrụ. Rụọkwara gị ọrụ nʼoge oyi na-atụ, nʼabalị ụra sikwa nʼanya m pụọ. ");
INSERT INTO ibo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Otu a ka ọ dịrị m iri afọ abụọ m jeere gị ozi. Arụrụ m gị ọrụ afọ iri na anọ maka ụmụ gị ndị inyom abụọ ndị a, afọ isii ka m lekọtara igwe ewu na atụrụ gị. Ị nọkwa nʼime ihe ndị a gbanwee ụgwọ ọrụ m ugboro iri. ");
INSERT INTO ibo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","A sị na Chineke m, Chineke Ebraham, onye ahụ a na-atụ egwu nke Aịzik, anọnyereghị m, ị gaara ezilaga m nʼaka efu, agaara m agbara aka laa. Ma Chineke ahụla ịrụsị ọrụ ike m, na nhụju anya m niile, ọ bụ ya mere o ji baara gị mba nʼabalị gara aga.” ");
INSERT INTO ibo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Mgbe ahụ Leban zaghachiri sị Jekọb, “Ndị inyom ndị a bụ ụmụ m. Ụmụaka ndị a bụ ụmụ m. Igwe anụ ụlọ ndị a bụ nke m. Ihe ndị a niile ị na-ahụ anya bụ nke m. Olee otu m ga-esi merụọ ụmụ m, na ụmụ ụmụ m ahụ? ");
INSERT INTO ibo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ugbu a, bịa ka anyị gbaa ndụ mụ na gị, ka ọ bụrụ ihe ama nʼetiti anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ya mere, Jekọb weere otu nkume guzo ya ọtọ dịka ogidi. ");
INSERT INTO ibo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jekọb gwakwara ndị so ya sị ha, “Tụtụkọta nkume.” Ha tụtụkọtara nkume wụsa ha nʼotu ebe mee ka ọ laa elu. Emesịa, ha nọdụrụ nʼakụkụ nkume ndị ahụ rie nri. ");
INSERT INTO ibo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leban kpọrọ nkume ndị ahụ Jega-Sahaduta, nʼasụsụ nke ya. Jekọb kpọrọ ya Galeed, nʼasụsụ nke ya. ");
INSERT INTO ibo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Emesịa, Leban sịrị, “Ka nkume ndị a bụrụ ihe ama nʼetiti mụ na gị taa.” Nke a mere e ji kpọọ ya Galeed. ");
INSERT INTO ibo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A kpọkwara ya Mizpa, nʼihi na Leban sịrị, “Ka Onyenwe anyị bụrụ onye ga-eche mụ na gị nche ịhụ na onye ọbụla nʼime anyị debere ọgbụgba ndụ a, mgbe anyị na-anọghị ibe anyị nso. ");
INSERT INTO ibo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ọ bụrụ na i mee ụmụ m ndị inyom ihe ọjọọ, maọbụ lụọ ndị inyom ndị ọzọ tinyere ha, o nweghị onye nʼime anyị ga-amata, ma cheta na Chineke ga-abụ onyeama nʼetiti mụ na gị.” ");
INSERT INTO ibo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Leban gwakwara Jekọb sị, “Lee nkume ndị a a wụsara nʼebe a na ogidi m mere ka o guzo nʼetiti mụ na gị. ");
INSERT INTO ibo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Nkume ndị a a wụsara bụ akaebe, ogidi a bụkwa ihe ama. Agaghị m agabiga nkume ndị a a wụsara gafeeta nʼakụkụ nke gị ime gị ihe ọjọọ. Gị onwe gị agaghị agabiga nkume ndị a a wụsara na ogidi a gafeeta nʼakụkụ nke m ime m ihe ọjọọ. ");
INSERT INTO ibo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ka Chineke Ebraham na Chineke Nahọ, Chineke nna ha, bụrụ onye ikpe nʼetiti mụ na gị.” Ya mere Jekọb ji onye ahụ a na-atụ egwu nke nna ya Aịzik ṅụọ iyi. ");
INSERT INTO ibo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ọ chụrụ aja nʼala ugwu ugwu ahụ, kpọọ ndị ikwu ya niile oriri. Mgbe ha richara nri, ha rahụrụ ụra nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nʼisi ụtụtụ echi ya, Leban biliri sutu ụmụ ya ndị inyom na ụmụ ụmụ ya ọnụ. Ọ gọziri ha, hapụ ha laghachi ụlọ ha. ");
INSERT INTO ibo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jekọb nʼonwe ya hapụrụ gawa nʼihu nʼije ya. Ndị mmụọ ozi Chineke zutere ya nʼụzọ. ");
INSERT INTO ibo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mgbe Jekọb hụrụ ha, o kwuru sị, “Ebe a bụ ụlọ ikwu Chineke!” Ọ kpọrọ ebe ahụ, Mahanaim. ");
INSERT INTO ibo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Mgbe ahụ, Jekọb zipụrụ ndị ozi ka ha jee hụ Ịsọ nwanne ya nwoke nʼala Sia, nʼobodo Edọm. ");
INSERT INTO ibo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","O ziri ha ozi sị, “Ihe a bụ ihe unu ga-agwa nna m ukwu Ịsọ, ‘Odibo gị Jekọb kwuru sị, Ọ bụ na nke Leban ka m jere kemgbe, ọ bụkwa ebe ahụ ka m nọ ruo ugbu a. ");
INSERT INTO ibo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Enwere m ọtụtụ ehi, na ịnyịnya ibu, na igwe atụrụ na ewu, na ndị odibo ndị nwoke na ndị nwanyị. Ana m ezigara onyenwe m ozi a ka m nata ihuọma nʼebe ọ nọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mgbe ndị ozi ahụ lọghachikwutere Jekọb, ha gwara ya sị ya, “Anyị jekwuru nwanne gị nwoke Ịsọ dị ka i ziri anyị. Ugbu a, ọ na-abịa. Ọ chị narị ndị ikom anọ na-abịa izute gị.” ");
INSERT INTO ibo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ụjọ tụrụ Jekọb nke ukwuu, obi ya jupụtakwara na nsogbu. Nʼihi nke a, o kewara ndị niile so ya ụzọ abụọ, tinyere anụ ụlọ ya, na igwe ehi ya na ịnyịnya kamel ya. ");
INSERT INTO ibo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","O chere nʼobi ya sị, “Ọ bụrụ na Ịsọ alụso otu nʼime ụzọ abụọ a ọgụ, otu ụzọ fọdụrụ ga-enwe ike gbalaga.” ");
INSERT INTO ibo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mgbe ahụ, Jekọb kpere ekpere sị, “Chineke nke nna m Ebraham, Chineke nke nna m Aịzik, Onyenwe anyị, gị onye gwara m sị, ‘Laghachi nʼala gị na nʼebe ụmụnna gị nọ, aga m eme ka ihe gaara gị nke ọma.’ ");
INSERT INTO ibo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ekwesighị m obi ebere na ikwesi ntụkwasị obi nke i gosiri ohu gị. Mgbe m gabigara Jọdan a, enweghị m ihe ọbụla karịa mkpanaka m, ma ugbu a, abụ m ọmụma ụlọ ikwu abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Zọpụta m, arịọ m gị, site nʼaka nwanne m Ịsọ, nʼihi na egwu na-atụ m na ọ ga-abịa lụso m agha, lụsokwa ndị nne a na ụmụntakịrị ha agha. ");
INSERT INTO ibo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ọ bụ gị kwuru sị, ‘Aga m eme ka ihe gaara gị nke ọma, meekwa ka ụmụ ụmụ gị dịrị ka aja nke dị nʼọnụ osimiri, nke mmadụ na-apụghị ịgụta ọnụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jekọb rahụrụ nʼebe ahụ nʼabalị ahụ. Site nʼihe niile o nwere, ọ họpụtara onyinye ọ ga-enye nwanne ya Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ọ kwadoro inye ya: narị nne ewu abụọ (200), iri mkpi abụọ (20), narị nne atụrụ abụọ (200), iri ebule abụọ (20) ");
INSERT INTO ibo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Iri nne ịnyịnya kamel atọ (30) na ụmụ ha, na iri nne ehi anọ (40), oke ehi iri (10), iri nne ịnyịnya ibu abụọ (20), oke ịnyịnya ibu iri (10). ");
INSERT INTO ibo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","O weere onyinye ndị a niile nyefee nʼaka ndị ozi ya nʼusoro dịka ụdị ha si dị. Ọ gwara ndị na-ejere ya ozi sị ha, “Burunu ụzọ na-aga, meenụ ka ohere dị nʼetiti igwe anụ na igwe ibe ya.” ");
INSERT INTO ibo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","O nyere onye mbụ iwu sị ha, “Mgbe Ịsọ nwanne m zutere unu jụọ unu ajụjụ sị, ‘Onye bụ nna unu ukwu? Ebee ka unu na-aga? Onye nwe anụ ụlọ ndị a niile unu chị na-aga?’ ");
INSERT INTO ibo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Unu ga-aza sị ya, ‘Anụ ụlọ ndị a bụ nke ohu gị Jekọb. Ha bụ onyinye e zitere onyenwe m Ịsọ, lee ka ọ na-abịa nʼazụ anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Otu ozi ahụ ka Jekọb ziri onye nke abụọ na onye nke atọ, na ndị ọzọ niile chị igwe anụ ụlọ, sị ha, “Unu ga-agwa Ịsọ otu ihe ahụ mgbe unu zutere ya. ");
INSERT INTO ibo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Hụkwanụ na unu gwara ya sị, ‘Ohu gị Jekọb nọ nʼazụ anyị.’ ” Echiche ya bụ, “Aga m eji onyinye ndị a niile m na-ezipụrụ ya mee ka obi ya dajụọ, nke ọ ga-abụ mgbe mụ na ya zutere, ma eleghị anya, ọ ga-anabata m.” ");
INSERT INTO ibo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mgbe o zipụchasịrị onyinye ndị ahụ niile, Jekọb rahụrụ ụra nʼụlọ ikwu ya nʼabalị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nʼabalị ahụ, Jekọb biliri duru ndị nwunye ya abụọ na ndị odibo nwanyị ya abụọ, na ụmụ ya iri na otu, site nʼebe na-adịghị omimi nke iyi Jabọk kpọfee ha. ");
INSERT INTO ibo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mgbe ọ kpọfechara ha, o bufekwara ihe niile o nwere. ");
INSERT INTO ibo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Emesịa, Jekọb lọghachiri nọdụ naanị ya. Mgbe ahụ, otu nwoke bịara gbaso ya mgba. Ha abụọ gbagidere mgba a tutu chi ebido ịbọ. ");
INSERT INTO ibo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mgbe nwoke ahụ hụrụ na ọ pụghị imeri Jekọb na mgba ahụ, o tiri Jekọb aka nʼọkpụ, mee ka ọkpụ ya hịkwapụ site nʼọnọdụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mgbe nke a mesịrị, nwoke ahụ gwara Jekọb sị ya: “Hapụ m aka ka m laa, nʼihi na chi ebidola ịbọ.” Ma Jekọb zara sị ya, “Ọ bụ naanị mgbe ị gọziri m ka m ga-ahapụ gị ka ị laa.” ");
INSERT INTO ibo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mgbe ahụ nwoke ahụ jụrụ Jekọb ajụjụ sị ya, “Gịnị bụ aha gị?” Ọ zara sị, “Aha m bụ Jekọb.” ");
INSERT INTO ibo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nwoke ahụ zara sị ya, “Aha gị agaghị abụkwa Jekọb, kama ọ ga-abụ Izrel, nʼihi na gị na Chineke na ndị mmadụ gbara mgba, ị mmeri.” ");
INSERT INTO ibo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jekọb sịrị, “Biko gwa m aha gị.” Ma ọ zaghachiri, “Gịnị mere ị ji ajụ aha m?” Mgbe ahụ, ọ gọziri ya nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jekọb kpọrọ aha ebe ahụ Peniel, nʼihi na ọ sịrị, “Ahụla m Chineke ihu na ihu, ma e chebere ndụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Anyanwụ awaala mgbe Jekọb si Peniel gafee. Ma nʼihi ihe mere ya nʼọkpụ, ọ naghị agazikwa ije. ");
INSERT INTO ibo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ọ bụ ihe a mere ụmụ Izrel adịghị eri akwara anụ jikọtara ukwu anụ na ọkpụ ya ruo taa. Nʼihi na ihe ahụ mere Jekọb metụtara akwara ukwu ya. ");
INSERT INTO ibo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jekọb lepụrụ anya nʼihu, hụ Ịsọ ka ọ na-abịa, ya na narị ndị ikom anọ ndị so ya. Nʼihi ya, o kesara ụmụntakịrị ndị ahụ, nʼetiti Lịa, na Rechel na ndị odibo nwanyị ya abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","O mere ka ndị odibo nwanyị ya abụọ ahụ na ụmụ ha buru ụzọ, Lịa na ụmụ ya esoro nʼazụ, ebe Rechel na Josef nọ nʼazụ azụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma ya onwe ya buru ụzọ na-aga nʼihu ha niile, na-akpọ isiala nye Ịsọ ugboro asaa, tutu ruo mgbe ọ bịarutere nwanne ya nwoke nso. ");
INSERT INTO ibo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Ịsọ gbaara ọsọ bịakwute ya, makụọ ya, jikụọ ya aka nʼolu, sutu ya ọnụ. Ha abụọ kwara akwa. ");
INSERT INTO ibo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mgbe Ịsọ lelitere anya hụ ndị inyom ndị a na ụmụntakịrị ndị ahụ. Ọ sịrị, “Ndị ole bụ ndị a gị na ha so?” Jekọb sịrị, “Ha bụ ụmụ Chineke sitere nʼamara ya nye ohu gị.” ");
INSERT INTO ibo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mgbe ahụ, ndị odibo nwanyị abụọ na ụmụ ha rutere nso, kpọọ isiala. ");
INSERT INTO ibo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lịa na ụmụ ya bịarutekwara kpọọ isiala, nʼikpeazụ Rechel na Josef bịara kpọọkwa isiala. ");
INSERT INTO ibo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ịsọ sịrị, “Igwe ewu na atụrụ ndị a niile m zutere nʼụzọ, gịnị ka ọ pụtara?” Jekọb zara, “Ha bụ maka ịnata ihuọma nʼaka gị, onyenwe m.” ");
INSERT INTO ibo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Ịsọ sịrị, “Nwanne m nwoke, debere onwe gị ihe i nwere, nʼihi na enwere m akụ hie nne.” ");
INSERT INTO ibo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jekọb sịrị, “E, biko, ọ bụrụ na m achọtala ihuọma nʼanya gị, nara m onyinye ndị a. Nʼihi na ịhụ gị anya dịka ilekwasị Chineke anya nʼihu, nke ka nke, otu a i ji ihu ọcha nabata m. ");
INSERT INTO ibo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Biko nara onyinye ndị ahụ e wetaara gị, nʼihi na Chineke emelara m amara. Enwekwara m ihe ga-ezuru m.” Jekọb kwagidere ya, ọ naara onyinye ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mgbe ahụ, Ịsọ sịrị, “Bilienụ ka anyị malite ije ịlaghachi. Aga m esonyere unu.” ");
INSERT INTO ibo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Jekọb sịrị ya, “Onyenwe m, ị maara na ụmụntakịrị ndị a adịghị ike, aga m ejikwa nwayọọ chịa ụmụ atụrụ ndị a na ehi ndị na-enye ụmụ ha ara. Ọ bụrụ na a chịa ha nʼike nʼime otu ụbọchị, ụmụ anụmanụ ndị a niile ga-anwụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ya mere, ka onyenwe m buru ohu ya ụzọ na-aga, ma ka m jiri nwayọọ nwayọọ na-abịa, dịka ike igwe anụ ndị a na ụmụaka ndị a si dị. Tutu ruo mgbe m ga-ezute onyenwe m na Sia.” ");
INSERT INTO ibo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ịsọ sịrị, “Ọ bụrụ otu a, ka m hapụrụ gị ụfọdụ ndị a mụ na ha so.” Ma Jekọb sịrị, “Nʼihi gịnị kwanụ? Ka m hụta naanị ihuọma nʼanya onyenwe m.” ");
INSERT INTO ibo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ịsọ laghachikwara azụ na Sia nʼotu ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Jekọb na ezinaụlọ ya jere Sukọt, ebe o wuuru onwe ya ụlọ obibi, wuokwara anụ ụlọ ya ụlọ obibi ha. Ọ bụ nke a mere e ji kpọọ ebe ahụ Sukọt. ");
INSERT INTO ibo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mgbe Jekọb si Padan Aram lọghachi, o rutere obodo Shekem nke dị nʼala Kenan nʼudo. O mara ụlọ ikwu ya nʼihu obodo ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ọ zụrụ ala ebe o mara ụlọ ikwu ya nʼaka ụmụ Hamọ, nna Shekem, ọ kwụrụ narị mkpụrụ ọlaọcha maka ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nʼebe ahụ, o wuru ebe ịchụ aja, kpọọ aha ya El Elohe Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ugbu a, Daịna nwa nwanyị Lịa mụụrụ Jekọb pụrụ ileta ndị inyom ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mgbe Shekem, nwa Hamọ onye Hiv, onye na-achị mpaghara ahụ, hụrụ ya, ọ kpọọrọ ya jiri ike ya na ya dinaa. ");
INSERT INTO ibo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mkpụrụobi ya gara nʼebe Daịna nwa Jekọb, ọ hụrụ nwantakịrị nwanyị ahụ nʼanya, gwakwa ya okwu dị nro. ");
INSERT INTO ibo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekem sịrị nna ya bụ Hamọ “Lụtara m nwaagbọghọ a, ka ọ bụrụ nwunye m.” ");
INSERT INTO ibo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mgbe Jekọb nụrụ na e merụrụ Daịna nwa ya nwanyị, nʼihi na ụmụ ya ndị ikom nọ nʼọhịa ebe ha na-azụ anụ ụlọ, ọ gbara nkịtị na-emeghị ihe ọbụla ruo mgbe ha lọtara. ");
INSERT INTO ibo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamọ bụ nna Shekem, pụkwuuru Jekọb ka ha kparịta ụka. ");
INSERT INTO ibo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ụmụ ndị ikom Jekọb si nʼọhịa na-alọta mgbe ha nụrụ ihe merenụ, iwe na ọnụma juputara ha obi nke ukwuu nʼihi na Shekem mere ihe na-eweta ihere nʼIzrel site nʼidinakwuru ada Jekọb, ihe a na-ekwesighị ime eme. ");
INSERT INTO ibo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma Hamọ sịrị ha, “Nwa m nwoke Shekem hụrụ nwa unu nwanyị nʼanya. Biko, kwerenụ ka ọ lụọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kwerenụ ka anyị na unu na-alụrịta. Ka anyị na-alụ ụmụ ndị inyom unu, ka unu na-alụkwa ụmụ ndị inyom anyị. ");
INSERT INTO ibo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Unu nwere ike biri nʼetiti anyị. Ala a ghere oghe nye unu. Birinụ nʼime ya, na-azụkwanụ ahịa nʼime ya, nwekwanụ akụ nʼime ya nye onwe unu.” ");
INSERT INTO ibo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekem gwara nna na ụmụnne Daịna ndị ikom sị, “Kwerenụ ka m chọta ihuọma nʼebe unu nọ, aga m enyekwa unu ihe ọbụla unu chọrọ ka m nye unu. ");
INSERT INTO ibo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ihe ọbụla unu sị m kwụọ dịka ego akụ ọlụlụ nwunye, ya na onyinye ọbụla unu si m nye aga m enye unu. Naanị kwerenụ ka nwaagbọghọ a bụrụ nwunye m.” ");
INSERT INTO ibo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma ụmụ Jekọb jiri aghụghọ zaa Shekem na Hamọ nna ya mgbe ha na-agwa ha okwu, nʼihi na e merụrụ Daịna nwanne ha nwanyị. ");
INSERT INTO ibo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ha sịrị ha, “Anyị enweghị ike ime ihe a, ị kpọrọ nwanne anyị nwanyị kpọnye nwoke a na-ebighị ugwu. Nke a ga-abụrụ anyị ihe ihere. ");
INSERT INTO ibo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Anyị nwere ike ikwenye ka ọ lụọ ya ma ọ bụrụ na unu ga-adị ka anyị, ka e bie ndị nwoke unu niile ugwu. ");
INSERT INTO ibo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mgbe ahụ anyị ga-edunye unu ụmụ ndị inyom anyị, ma kpọrọkwa ụmụ ndị inyom unu dịka ndị nwunye anyị. Anyị ga-ebi nʼetiti unu, soro unu bụrụ otu ndị. ");
INSERT INTO ibo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ọ bụrụ na unu agaghị ekwe ka e bie unu ugwu, anyị ga-akpọrọ nwanne anyị nwanyị laa.” ");
INSERT INTO ibo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Obi tọrọ Hamọ na Shekem nwa ya nwoke ụtọ nʼihi ihe ụmụ ndị ikom Jekọb kwuru. ");
INSERT INTO ibo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nwokorobịa ahụ bụ onye a na-asọpụrụ karịa onye ọbụla nʼụlọ nna ya egbughị oge ime ihe ha kwuru, nʼihi na ihe banyere nwa nwanyị Jekọb dị ya mma nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Emesịa, Hamọ na Shekem nwa ya nwoke gara nʼọnụ ụzọ ama nke obodo ha gwa ndị ikom obodo ha okwu, sị. ");
INSERT INTO ibo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ndị ikom ndị a nwere mmasị nʼebe anyị nọ. Kwerenụ ka ha biri nʼala anyị, ka ha na-agagharị kwa nʼime ya. Anyị nwere ala buru ibu nke ga-ezuru anyị na ha. Ha ga-alụ ụmụ nwanyị anyị, anyị ga-alụkwa ndị nke ha. ");
INSERT INTO ibo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ma ọ dị otu ihe ha chọrọ ka anyị mee tupu ha ekwere ibi nʼetiti anyị ka anyị na ha bụrụ otu ndị. Ọ bụ ibi ndị ikom anyị niile ugwu dịka e si bie ha ugwu. ");
INSERT INTO ibo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ọ bụrụ na unu chọrọ ka anụ ụlọ ha niile na akụ ha niile bụrụ nke anyị, ọ dị mma ka anyị kwenyere ha, ka ha binyere anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ndị ikom niile bịara nʼọnụ ụzọ ama obodo ahụ kwenyere nʼokwu Hamọ na nwa ya nwoke Shekem. E bikwara nwoke ọbụla nọ nʼobodo ahụ ugwu. ");
INSERT INTO ibo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","O ruo nʼụbọchị nke atọ, mgbe ọnya ugwu ha na-egbu ha mgbu, ụmụ ndị ikom Jekọb abụọ, Simiọn na Livayị, ụmụnne Daịna, jiri mma agha ha pụkwuru ndị bi nʼobodo ahụ na-atụghị anya na ihe dị otu a ga-eme, gbuo ndị ikom niile nọ nʼobodo ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ha gbukwara Hamọ na Shekem nwa ya nwoke, kpọpụta Daịna site nʼụlọ Shekem, laghachi nʼụlọ ha. ");
INSERT INTO ibo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mgbe ahụ ụmụ ndị ikom Jekọb niile bịakwasịrị ndị a e gburu egbu, kwakọọ ihe niile dị nʼobodo ahụ niile, nʼihi mmerụ e merụrụ nwanne ha nwanyị. ");
INSERT INTO ibo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ha kwakọọrọ ngwongwo niile dị nʼobodo ahụ, kpụrụkwa anụ ụlọ niile, igwe ewu na atụrụ, igwe ehi na igwe ịnyịnya ibu niile, na ihe niile dị nʼime obodo ahụ, na ihe niile dị nʼubi ndị ahụ obodo nwere. ");
INSERT INTO ibo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Akụ ha niile, na ndị inyom ha niile na ụmụntakịrị ha, na ihe niile dị nʼime ụlọ ha, ka ha weere dịka ihe a dọtara nʼagha. ");
INSERT INTO ibo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mgbe Jekọb hụrụ ihe ụmụ ya mere, ọ kpọrọ Simiọn na Livayị sị ha, “Unu ebuterela m nsogbu mee ka m bụrụ ihe na-esi isi ọjọọ nʼetiti ndị Kenan na ndị Periz nwe ala a. Ebe anyị dị ole na ole, ọ bụrụ na ha ejikọta onwe ha ọnụ lụso m agha, ha ga-ekpochapụ mụ na ezinaụlọ m.” ");
INSERT INTO ibo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ma ha zara sị ya, “O kwesiri ka o meso nwanne anyị nwanyị mmeso dịka ọ bụ akwụna?” ");
INSERT INTO ibo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Chineke sịrị Jekọb, “Bilie, gaa Betel, birikwa nʼebe ahụ. Wuo ebe ịchụ aja nye Chineke, onye mere ka ị hụ ya mgbe ị na-agbanarị Ịsọ nwanne gị nwoke.” ");
INSERT INTO ibo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ya mere, Jekọb gwara ndị ezinaụlọ ya na ndị niile so ya sị, “Wezuganụ chi ndị ala ọzọ dị nʼetiti unu. Doonụ onwe unu ọcha, gbanweekwanụ uwe unu. ");
INSERT INTO ibo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bilienụ, ka anyị gaa Betel, ebe m ga-ewu ebe ịchụ aja nye Chineke, onye zara m oku nʼụbọchị nsogbu m, ma nọnyekwara m na njem nke m gara.” ");
INSERT INTO ibo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ya mere, ha nyere Jekọb chi ndị ala ọzọ niile ha ji nʼaka, na ọla niile dị ha na ntị. Jekọb chịịrị ha niile lie ha nʼokpuru osisi ook dị na Shekem. ");
INSERT INTO ibo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ha biliri ije. Egwu Chineke dakwasịrị obodo niile gbara ha gburugburu. Ọ dịghị ndị chụsoro ha. ");
INSERT INTO ibo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jekọb na ndị niile so ya rutere Luz, nke a na-akpọkwa Betel nke dị na Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jekọb wuru ebe ịchụ aja nʼebe a, kpọọ aha ebe ahụ El Betel, nʼihi na ọ bụ nʼebe ahụ ka Chineke gosiri ya onwe ya mgbe ọ na-agbanarị Ịsọ nwanne ya nwoke. ");
INSERT INTO ibo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Mgbe nke a gasịrị, Debọra, nwanyị lekọtara Ribeka mgbe ọ bụ nwantakịrị, nwụrụ. E liri ya nʼokpuru osisi ook dị na Betel. A kpọkwara ebe ahụ, “Osisi ook ebe ịkwa akwa.” ");
INSERT INTO ibo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Chineke gosiri Jekọb onwe ya ọzọ, mgbe o sitere na Padan Aram pụta, gọziekwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Chineke sịrị ya, “Aha gị bụ Jekọb ma a gaghị akpọkwa gị Jekọb ọzọ, kama aha gị ga-abụ Izrel.” Ya mere ọ kpọrọ ya Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Chineke sịrị ya, “Abụ m Chineke onye pụrụ ime ihe niile. Mụọ ọmụmụ, baakwa ụba nʼọnụọgụgụ. Otu mba na igwe mba ga-esi na gị pụta. Ndị eze ga-esitekwa gị nʼahụ pụta. ");
INSERT INTO ibo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ala ahụ m nyere Ebraham na Aịzik ka m na-enyekwa gị. Aga m enyekwa ya ụmụ ụmụ gị ndị ga-esote gị.” ");
INSERT INTO ibo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Emesịa, Chineke si nʼebe ahụ ha nọ kparịtaa ụka pụọ. ");
INSERT INTO ibo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jekọb wuru ogidi nkume nʼebe ahụ Chineke nọ gwa ya okwu. Ọ wụsara onyinye ihe ọṅụṅụ wụkwasịkwa mmanụ nʼelu ogidi nkume ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jekọb kpọrọ ebe ahụ ya na Chineke nọ kparịtaa ụka Betel. ");
INSERT INTO ibo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ha biliri ije, site na Betel. Ma mgbe ha ka nọ ebe dị anya site nʼobodo Efrat, Rechel mụrụ nwa, ma o nwere ihe mgbu ka ọ na-amụ nwa. ");
INSERT INTO ibo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mgbe o sitere nʼoke ihe mgbu na-amụpụta nwa ahụ, nwanyị na-aghọ nwa gwara ya, “Atụla egwu, nʼihi na ọ bụ nwa nwoke ọzọ ka ị mụtara.” ");
INSERT INTO ibo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ma tupu Rechel ekuo ume ikpeazụ, nʼihi na ọ na-anwụ, ọ kpọrọ aha nwa ọhụrụ ahụ Ben-Oni, ma nna ya kpọrọ ya Benjamin. ");
INSERT INTO ibo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rechel nwụrụ, e lie ya nʼakụkụ ụzọ gara Efrat, nke a na-akpọkwa Betlehem. ");
INSERT INTO ibo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jekọb wuru ogidi nʼelu ili ya, nke na-eguzokwa ruo taa, igosi ebe e liri Rechel. ");
INSERT INTO ibo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Izrel malitere ije ya, tutu ruo ebe o wuru ebe izuike ya nʼala dị nʼofe ọzọ nke Migdal Eda. ");
INSERT INTO ibo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mgbe Izrel bi nʼala ahụ, Ruben gara dinakwuru Bilha, iko nwanyị nna ya. E mekwara ka Izrel nụ ihe a Ruben mere. Ụmụ ndị ikom Jekọb dị iri na abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ụmụ Lịa bụ, Ruben, ọkpara Jekọb. Simiọn, Livayị, Juda, Isaka na Zebụlọn. ");
INSERT INTO ibo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ụmụ Rechel bụ, Josef na Benjamin. ");
INSERT INTO ibo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ụmụ Bilha, odibo nwanyị Rechel bụ, Dan na Naftalị. ");
INSERT INTO ibo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ụmụ Zilpa, odibo nwanyị Lịa bụ, Gad na Asha. Ụmụ ndị ikom ndị a ka a mụụrụ Jekọb na Padan Aram. ");
INSERT INTO ibo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nʼikpeazụ, Jekọb bịakwutere nna ya Aịzik na Mamre nke dị nso na Kiriat Arba (ebe a na-akpọ Hebrọn). Ebe ahụ ka Ebraham na Aịzik biri na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nʼoge ahụ Aịzik gbara narị afọ na iri afọ asatọ. ");
INSERT INTO ibo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ọ dịkwaghị anya site nʼoge a, Aịzik nwụrụ, mgbe o mere nnọọ agadi. Ụmụ ya ndị ikom abụọ, Ịsọ na Jekọb, liri ya. ");
INSERT INTO ibo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nke a bụ akụkọ banyere usoro agbụrụ Ịsọ, onye a na-akpọ Edọm. ");
INSERT INTO ibo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ịsọ lụrụ ndị inyom a site nʼala Kenan. Onye nke mbụ bụ Ada nwa Elọn, onye Het. Nke abụọ bụ Oholibama, nwa Ana, nwa nwa Zibiọn, onye Hiv. ");
INSERT INTO ibo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Onye nke atọ bụ Basemat, nwa Ishmel, onye nwanne ya nwanyị bụ Nebaiot. ");
INSERT INTO ibo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada mụụrụ Ịsọ Elifaz, ebe Basemat mụrụ Reuel. ");
INSERT INTO ibo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama mụtaara Jeush na Jalam na Kora. Ndị a bụ ụmụ Ịsọ ndị a mụtara ya nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Emesịa, Ịsọ duuru ndị nwunye ya na ụmụ ya ndị ikom na ndị inyom, na ndị niile nọ nʼezinaụlọ ya. Ọ chịkọọrọ anụ ụlọ ya niile, na akụ niile ọ kpatara nʼala Kenan kwapụ gaa biri nʼala dị anya site nʼebe nwanne ya Jekọb nọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ebe ọ bụ na akụnụba ha nwere dịkarịrị ukwuu ha ibikọta ọnụ, tinyekwara na ala ebe ha bi enwezighị ike ibuli ha nʼihi anụ ụlọ niile ha nwere. ");
INSERT INTO ibo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ya mere, Ịsọ gara biri nʼala ugwu ugwu Sia, Ịsọ bụkwa Edọm. ");
INSERT INTO ibo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nke a bụ akụkọ banyere usoro agbụrụ Ịsọ, nna obodo Edọm, nʼala ugwu ugwu Sia. ");
INSERT INTO ibo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ndị a bụ aha ụmụ ndị ikom Ịsọ mụtara. Elifaz bụ ọkpara Ada, nwunye Ịsọ. Nwanne ya bụ Reuel, nwa Basemat, nwunye Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ụmụ Elifaz ndị ikom bụ, Teman, Ọmaa, Zefo, Gatam na Kenaz. ");
INSERT INTO ibo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz nwa Ịsọ nwere iko nwanyị aha ya bụ Timna, onye mụtaara ya Amalek. Ndị a niile bụ ụmụ ndị ikom Ada, nwunye Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ụmụ ndị ikom Reuel bụ, Nahat, Zera, Shama na Miza. Ndị a niile bụ ụmụ ụmụ Basemat, nwunye Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ndị a bụ ụmụ Oholibama, nwunye Ịsọ. Oholibama bụ nwa Ana na nwa nwa Zibiọn. Ọ mụtaara Ịsọ Jeush, Jalam na Kora. ");
INSERT INTO ibo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ndị a bụ ọnụmara si nʼetiti ụmụ ụmụ Ịsọ. Site nʼetiti ụmụ Elifaz, ọkpara Ịsọ, e nwere Ọnụmara Teman, ọnụmara Ọmaa, ọnụmara Zefo, ọnụmara Kenaz. ");
INSERT INTO ibo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Ọnụmara Kora, ọnụmara Gatam na ọnụmara Amalek. Ndị eze ndị a bụ ụmụ Elifaz nʼala Edọm. Ha bụ ụmụ ụmụ Ada. ");
INSERT INTO ibo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ndị bụ ụmụ Reuel, nwa Ịsọ, e nwere ọnụmara Nahat, ọnụmara Zera, ọnụmara Shama, ọnụmara Miza. Ọnụmara ndị a bụ ụmụ Reuel nʼala Edọm. Ha bụ ụmụ Basemat, nwunye Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ndị a bụ ụmụ Oholibama, nwunye Ịsọ, ọnụmara Jeush, ọnụmara Jalam, na ọnụmara Kora. Ndị a bụ ọnụmara ụmụ Oholibama nwa Ana, nwunye Ịsọ. ");
INSERT INTO ibo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ndị a niile bụ ụmụ ndị ikom Ịsọ (ya bụ, Edọm). Ndị a bụkwa ọnụmara ha. ");
INSERT INTO ibo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ndị a bụ ụmụ ndị ikom Sia onye Hor, ndị bi nʼakụkụ ala ahụ: Lotan, Shobal, Zibiọn, Ana, ");
INSERT INTO ibo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishọn, Eza na Dishan. Ụmụ ndị ikom Sia nʼala Edọm, ha bụ ndị ọnụmara Hor. ");
INSERT INTO ibo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ụmụ ndị ikom Lotan bụ, Hori na Homam. Timna bụkwa nwanne nwanyị Lotan. ");
INSERT INTO ibo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ụmụ ndị ikom Shobal bụ, Alvan, Manahat, Ebal, Shefo na Onam. ");
INSERT INTO ibo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ụmụ ndị ikom Zibiọn mụrụ bụ Aịa na Ana. Ana bụ nwoke ahụ chọpụtara isi iyi mmiri ime ala ahụ nke mmiri dị ọkụ si nʼime ya na-asọpụta nʼọzara, mgbe ọ na-elekọta ịnyịnya ibu nna ya Zibiọn. ");
INSERT INTO ibo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ụmụ Ana bụ, Dishọn na Oholibama nwa nwanyị Ana. ");
INSERT INTO ibo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ụmụ ndị ikom Dishọn bụ, Hemdan na Eshban na Itran na Keran. ");
INSERT INTO ibo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ụmụ ndị ikom Eza bụ, Bilhan na Zaavan na Akan. ");
INSERT INTO ibo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ụmụ ndị ikom Dishan bụ, Uz na Aran. ");
INSERT INTO ibo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ndị a bụ ndị ọnụmara Hor, ọnụmara Lotan, ọnụmara Shobal, ọnụmara Zibiọn, ọnụmara Ana, ");
INSERT INTO ibo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ọnụmara Dishọn, ọnụmara Eza na ọnụmara Dishan. Ndị a niile bụ ndị ọnụmara Hor dịka nkewa ha si dị nʼala Sia. ");
INSERT INTO ibo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ndị a bụ ndị eze chịrị nʼEdọm tupu ndị Izrel enwee eze mbụ ha. ");
INSERT INTO ibo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, nwa Beoa chịrị dịka eze nʼEdọm. Isi obodo ya bụ Dinhaba. ");
INSERT INTO ibo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mgbe Bela nwụrụ, Jobab nwa Zera onye Bozra nọchiri ya dịka eze. ");
INSERT INTO ibo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Mgbe Jobab nwụrụ, Husham onye si nʼala Teman nọchiri ya dịka eze. ");
INSERT INTO ibo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Mgbe Husham nwụrụ, Hadad nwa Bedad, onye meriri ndị Midia nʼagha nʼala Moab nọchiri dịka eze. Isi obodo ya bụ Avit. ");
INSERT INTO ibo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Mgbe Hadad nwụrụ, Samla onye Masrika nọchiri ya dịka eze. ");
INSERT INTO ibo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Mgbe Samla nwụrụ, Shaul onye sitere na Rehobọt dị nʼakụkụ osimiri nọchiri ya dịka eze. ");
INSERT INTO ibo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Mgbe Shaul nwụrụ, Baal-Hanan nwa Akboa nọchiri ya dịka eze. ");
INSERT INTO ibo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Mgbe Baal-Hanan nwa Akboa nwụrụ, Heda nọchiri ya dịka eze. Aha obodo ya bụ Pau. Aha nwunye ya bụ Mehetabel, nwa Matred nwa nwa Mezahab. ");
INSERT INTO ibo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ndị a bụ ndịisi ọnụmara Ịsọ, dịka aha ha si dị, dịka ikwu ha na akụkụ ebe ha bi si dị: Timna, Alva, Jetet, ");
INSERT INTO ibo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Elaa, Pinon, ");
INSERT INTO ibo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibza, ");
INSERT INTO ibo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel na Iram. Ndị a bụ ndịisi ọnụmara nʼEdọm, dịka ebe obibi ha na ala obi ha si dị. Nke a bụ ezinaụlọ Ịsọ bụkwa nna ndị Edọm. ");
INSERT INTO ibo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekọb bigidere nʼala Kenan, ala ahụ nna ya buru ụzọ biri nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nke a bụ usoro akụkọ banyere ezinaụlọ Jekọb. Josef, onye gbarala afọ iri na asaa, na-esonyere ụmụnne ya ndị ikom na-azụ igwe anụ ụlọ, ya onwe ya bụ naanị nwantakịrị na-enyere ụmụ Bilha na ụmụ Zilpa ndị nwunye nna ya aka. Ma Josef na-ewetara nna ha akụkọ maka ihe ọjọọ ha na-eme. ");
INSERT INTO ibo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma Izrel hụrụ Josef nʼanya karịa ụmụ ya ndị ikom ndị ọzọ niile nʼihi na Josef bụ nwa a mụụrụ ya nʼoge agadi ya. Ọ kwaara ya uwe mwụda nwere ọtụtụ agwa. ");
INSERT INTO ibo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mgbe ụmụnne ya chọpụtara na nna ha hụrụ ya nʼanya karịa onye ọbụla nʼime ha, ha kpọrọ ya asị, ha adịghị agwakwa ya okwu ọma. ");
INSERT INTO ibo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Otu oge, Josef rọrọ nrọ, mgbe ọ kọọrọ ụmụnne ya nrọ a ọ rọrọ, ha kpọrọ ya asị karịa. ");
INSERT INTO ibo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ọ gwara ha, “Geenụ ntị na nrọ a m rọrọ. ");
INSERT INTO ibo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Anyị niile nọ nʼubi na-achịkọta ọka, ngwangwa ukwu ọka nke m biliri guzoro ọtọ, ebe ukwu ọka nke unu niile gbara ukwu ọka nke m gburugburu, na-akpọ isiala nye ya.” ");
INSERT INTO ibo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ụmụnne ya jụrụ ya, “Ị na-akọwa na ọ bụ gị ga-abụ eze anyị? Na ọ bụ gị nʼezie ga-achị anyị?” Ha kpọrọ ya asị karịa nʼihi nrọ ya na okwu ya niile. ");
INSERT INTO ibo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Josef rọkwara nrọ ọzọ, kọkwara ụmụnne ya. Ọ sịrị, “Geenụ ntị, arọrọ m nrọ ọzọ. Ma na nrọ nke ugbu a, anyanwụ na ọnwa na kpakpando iri na otu na-akpọ isiala nye m.” ");
INSERT INTO ibo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ma mgbe ọ kọọrọ nna ya na ụmụnne ya nrọ a. Nna ya baara ya mba, sị, “Nrọ nke a ị rọrọ bụ nrọ gịnị? Ọ bụ ezie na anyị niile, mụ onwe m na nne gị na ụmụnne gị, ga-abịa na-akpọrọ gị isiala?” ");
INSERT INTO ibo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ụmụnne ya kwosiri ya ekworo nʼihi ya, ma nna ya debere ihe ndị a niile nʼobi ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ka ọ dị, ụmụnne ya gara ilekọta igwe anụ ụlọ nna ha na Shekem. ");
INSERT INTO ibo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izrel sịrị Josef, “Dịka ị maara, ụmụnne gị nọ na-eche anụ ụlọ na Shekem. Bịa, aga m eziga gị nʼebe ahụ.” Josef zara sị, “Ọ dị mma.” ");
INSERT INTO ibo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ya mere, ọ gwara ya, “Gaa ka ị chọpụta ma ihe ọ na-agazikwara ụmụnne gị na igwe anụ ụlọ ndị ahụ nke ọma, ma weghachiri m ozi.” O sitere na Ndagwurugwu Hebrọn zipụ ya. Ọ bịaruru Shekem, ");
INSERT INTO ibo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ma otu nwoke hụrụ ya ka ọ na-awagharị gburugburu nʼọhịa dị nʼebe ahụ, ọ jụrụ ya, “Gịnị ka ị na-achọ?” ");
INSERT INTO ibo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ọ sịrị, “Ana m achọ ụmụnne m. Biko, ị nwere ike ịgwa m ebe ha nọ na-azụ igwe anụ ụlọ ha?” ");
INSERT INTO ibo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nwoke ahụ zara sị, “Ha esitela nʼebe a pụọ. Anụrụ m ka ha na-asị, ‘Ka anyị gaa Dọtan.’ ” Ya mere, Josef gawara Dọtan ịchọ ụmụnne ya. Ọ hụkwara ha nʼebe dị nso na Dọtan. ");
INSERT INTO ibo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ma ha lepụrụ anya hụ ya ka ọ na-abịa, gbaa izu otu ha ga-esi gbuo ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ha sịrịtara onwe ha, “Lee eze nrọ ahụ ka ọ na-abịa! ");
INSERT INTO ibo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ugbu a, bịanụ, ka anyị gbuo ya, tụba ya nʼime otu olulu ndị a. Anyị ga-asịkwa na anụ ọhịa eriela ya. Mgbe ahụ, anyị ga-ahụkwa ihe nrọ ya niile ga-abụ.” ");
INSERT INTO ibo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben nụrụ ihe a, ma napụtakwa ya site nʼaka ha. Ọ sịrị, “Ka anyị hapụ igbu ya.” ");
INSERT INTO ibo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben sịrị ha, “Ka unu hapụ ịkwafu ọbara. Kama tụnyenụ ya nʼime olulu a dị nʼọzara. Ma unu akpatụkwala ya aka.” Ma nzube ya bụ ịnapụta ya site nʼaka ha, dulaara ya nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ya mere, mgbe Josef bịakwutere ụmụnne ya, ha yipụrụ ya uwe mwụda ya, uwe mwụda nwere ọtụtụ agwa o yi nʼahụ. ");
INSERT INTO ibo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ha duru ya tụnye ya nʼime olulu. Ọ bụ olulu tọgbọrọ nʼefu, nke mmiri na-adịghị nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mgbe ha nọdụrụ ala bido iri nri, ha leliri anya ha hụ igwe ndị ahịa Ishmel si Gilead. Ịnyịnya kamel ha bu ụda na mgbaa na máá. Ọ bụkwa Ijipt ka ha bu ihe ndị a na-aga. ");
INSERT INTO ibo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Mgbe ahụ, Juda jụrụ ụmụnne ya, “Uru gịnị ka ọ ga-abara anyị igbu nwanne anyị, ma kpuchie ọbara ya? ");
INSERT INTO ibo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bịanụ, ka anyị resi ya ndị Ishmel ndị a, ka aka anyị ghara nʼimetụ ya, nʼihi na nwanne anyị na otu anụ ahụ anyị ka ọ bụ.” Ụmụnne ya gere ya ntị. ");
INSERT INTO ibo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mgbe ndị ahịa Midia ahụ rutere, ha sitere nʼolulu dọpụta Josef resi ya ndị Ishmel ahụ, ndị kwụrụ ụmụnne Josef iri mkpụrụ shekel ọlaọcha abụọ. Ha duuru Josef gaa Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben mechara lọghachi gaa nʼolulu ahụ, ma ka ọ na-ahụghị Josef nʼime olulu a, ọ dọwara uwe ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","O jekwuru ụmụnne ya sị ha, “Nwata ahụ anọkwaghị ebe ahụ! Mụ onwe m, olee ebe m ga-ala?” ");
INSERT INTO ibo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ụmụnne ya gburu otu ewu were uwe Josef bịanye nʼime ọbara ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ha chịịrị uwe mwụda ahụ nwere ọtụtụ agwa jekwuru nna ha sị ya, “Anyị hụrụ uwe a nʼime ọhịa. Leruo ya anya ka ị mara maọbụ uwe mwụda nwa gị.” ");
INSERT INTO ibo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ọ matara na ọ bụ ya, sị, “E, nke a bụ uwe nwa m nwoke. Ajọ anụ eriela ya. Anụ ọhịa adọkasịala Josef nʼezie.” ");
INSERT INTO ibo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Mgbe ahụ, Jekọb dọwara uwe ya, yiri akwa mkpe, ruo ụjụ ọtụtụ ụbọchị nʼihi nwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ụmụ ya ndị ikom na ụmụ ya ndị inyom niile bịara ịkasị ya obi, ma ọ jụrụ ịnabata nkasiobi ọbụla. Ọ sịrị, “Aga m alakwuru nwa m nʼala mmụọ site nʼiru ụjụ.” Nna ya kwagidere akwa nʼihi ya. ");
INSERT INTO ibo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ugbu a, ndị Midia ahụ rere Josef nʼIjipt, resi ya Pọtifa, otu nʼime ndịisi na-ejere Fero ozi, onye bụ onyeisi ndị nche Fero, bụ eze Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nʼoge ahụ, Juda hapụrụ ụmụnne ya gaa binyere otu nwoke onye Adulam a na-akpọ Hira. ");
INSERT INTO ibo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nʼebe ahụ, Juda hụrụ otu nwaagbọghọ, nwa otu nwoke onye Kenan, aha ya bụ Shua. Ọ lụrụ ya ma bakwuru ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ọ tụụrụ ime mụọ nwa nwoke, onye Juda gụrụ aha Ịa ");
INSERT INTO ibo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nwunye ya dịkwara ime ọzọ mụta nwa nwoke nke ya bụ nwunye ya gụrụ Onan. ");
INSERT INTO ibo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ọ mụkwara nwa nwoke ọzọ, onye ọ kpọrọ Shela. Ọ bụ na Kezib ka ọ mụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda lụtaara Ịa, ọkpara ya, nwunye onye aha ya bụ Tama. ");
INSERT INTO ibo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma nʼihi na Ịa, ọkpara Juda, dị njọ nʼanya Onyenwe anyị. Onyenwe anyị gburu ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mgbe ahụ, Juda sịrị Onan, “Bakwuru nwunye nwanne gị ka ịkuchie ya, ka i si otu a wulite mkpụrụ maka nwanne gị.” ");
INSERT INTO ibo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan ma na mkpụrụ a agaghị abụ nke ya. Nʼihi ya, mgbe ọbụla ọ bakwuru nwunye nwanne ya, ọ na-anyụsa mkpụrụ nwa ya nʼala, ime ka ọ ghara inye nwanne ya nwoke nwa. ");
INSERT INTO ibo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma ihe a o mere jọrọ njọ nʼanya Onyenwe anyị. Nʼihi ya Onyenwe anyị gbukwara ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda sịrị nwunye nwa ya, bụ Tama, “Laa nʼụlọ nna gị nọrọ dịka nwanyị di ya nwụrụ tutu Shela nwa m nwoke etoo.” Ma echiche ya bụ, “ka ọ ghara ịnwụ dịka ụmụnne ya.” Tama lara gaa biri nʼụlọ nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mgbe ọtụtụ oge gasịrị, nwunye Juda nwa Shua nwụrụ. Mgbe oge nkasiobi ya gasịrị, Juda jere Timna, ya na enyi ya Hira, onye Adulam, ilekọta ndị na-akpụchapụ igwe ewu na atụrụ ya ajị. ");
INSERT INTO ibo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A gwara Tama sị ya, “Nna di gị na-aga Timna ịkpacha atụrụ ya ajị.” ");
INSERT INTO ibo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","O yipụrụ uwe mkpe ya, were akwa mkpuchi kpuchie onwe ya gaa nọdụ ala nʼọnụ ụzọ ama Enayim, nke dị nʼụzọ e si aga Timna. O mere otu a nʼihi na ọ matara na Shela etoola, ma enyeghị ya ka ọ bụrụ nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mgbe Juda hụrụ ya, o chere na ọ bụ otu nwanyị akwụna, ebe ọ bụ na o kpuchiri ihu ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ma ebe ọ mataghị na ọ bụ nwunye nwa ya, o jekwuru ya ebe ọ nọdụrụ ala nʼakụkụ ụzọ sị ya, “Bịa, kwere ka mụ na gị dinaa.” Tama jụrụ, “Gịnị ka ị ga-enye m ma ọ bụrụ na m kwere ka mụ na gị dinaa?” ");
INSERT INTO ibo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ọ zara, “Aga m ezitere gị otu nwa ewu site nʼigwe ewu na atụrụ m.” Ọ jụrụ, “Ị ga-enye m ihe akaebe ruo mgbe ị ga-ezite ya?” ");
INSERT INTO ibo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ọ sịrị, “Kedụ ihe akaebe m ga-enye gị?” Ọ zara, “Mgbaaka akara gị na eriri ya, na mkpanaka dị gị nʼaka.” O nyere ya ihe ndị a. Ọ bakwuru ya nke mere na ọ tụụrụ ime. ");
INSERT INTO ibo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mgbe o si nʼebe ahụ pụọ, o yipụrụ akwa ahụ o ji kpuchie ihu ya, yirikwa uwe mkpe ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mgbe Juda zigara enyi ya onye Adulam ka ọ gaa wegara ya nwa ewu ahụ, ma nataghachi ihe ibe ahụ, ọ hụghị ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ọ jụrụ ndị ikom bi nʼebe ahụ sị, “Olee nwanyị akwụna ụlọ arụsị ahụ na-anọdụ nʼọnụ ụzọ ama Enayim?” Ha sịrị, “O nweghị nwanyị akwụna ụlọ arụsị nọrọla nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ya mere, ọ laghachiri gaa gwa Juda, “Ahụghị m ya. Ọzọkwa, ndị ikom ndị bi nʼebe ahụ sịrị, ‘O nweghị nwanyị akwụna ụlọ arụsị nọrọla nʼebe a.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda zara, “Ka o jide ihe niile o ji, ma ọ bụghị otu a anyị ga-aghọ ihe ọchị. Lee, ezigarala m ya nwa ewu a, ma gị onwe gị achọtaghị ya.” ");
INSERT INTO ibo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mgbe ọnwa atọ gasịrị, ozi ruru Juda ntị sị, “Tama nwunye nwa gị gbara akwụna, bịa site nʼịgba akwụna dịrị ime.” Juda sịrị, “Kpọpụtanụ ya ka akpọọ ya ọkụ.” ");
INSERT INTO ibo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ma mgbe ha kpọ ya na-apụta, o zigara nna di ya ozi, sị, “Ọ bụ nwoke nwee ihe ndị a tụwara m ime. Ọ sịkwara, Leruo anya ma ị ga-amata onye nwe ihe ndị a: mgbaaka akara a na eriri ya, na mkpanaka a.” ");
INSERT INTO ibo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda ghọtara ha, sị, “Ọ bụ onye ezi omume karịa m, ebe ọ bụ na m jụrụ ịkpọrọ ya kpọnye nwa m nwoke Shela ka ọ bụrụ nwunye ya.” O dinakwaghị ya ọzọ. ");
INSERT INTO ibo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mgbe oge ọmụmụ nwa ya ruru, ejima ka ahụrụ nʼakpanwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mgbe ọ na-amụ ha, otu nʼime ha sepụtara aka ya. Nwanyị na-aghọ nwa weere eriri na-acha uhie uhie kee ya na nkwoji aka kwuo sị, “Ọ bụ nke a bụ ụzọ pụta.” ");
INSERT INTO ibo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma nwa ahụ mesịrị sekpuo aka ya, nwanne ya nke ọzọ eburu ya ụzọ pụta. Nwanyị ahụ sịrị, “Ọ bụ otu a ka ị si tikapụta?” A kpọrọ ya Perez. ");
INSERT INTO ibo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Emesịa, nwanne ya, nke bu eriri uhie uhie ahụ na nkwoji aka pụtakwara. A kpọrọ ya Zera. ");
INSERT INTO ibo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","A kpọọrọ Josef gaa nʼala Ijipt. Pọtifa, bụ nwoke Ijipt, otu nʼime ndịisi na-ejere Fero ozi, na onyeisi ndị agha na-eche nche zụụrụ ya site nʼaka ndị Ishmel, bụ ndị duuru ya gaa nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Onyenwe anyị nọnyeere Josef, nke mere na ihe gaara ya nke ọma nʼụlọ nna ya ukwu onye Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nna ya ukwu hụrụ na Onyenwe anyị nọnyeere Josef, hụkwa na Onyenwe anyị na-eme ka ihe niile o mere gaara ya nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josef hụtara amara nʼihu ya, ghọọ onyeozi nke aka ya. Pọtifa mere ya onye na-elekọta ezinaụlọ ya. Nyefee ya ihe niile o nwere ka ọ bụrụ onye na-elekọta ha. ");
INSERT INTO ibo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Site nʼoge a, o mere ka ọ bụrụ onye na-elekọta ezinaụlọ ya na ihe niile o nwere, Onyenwe anyị gọziri ezinaụlọ onye Ijipt ahụ nʼihi Josef. Ngọzị Onyenwe anyị dịkwasịrị nʼihe niile Pọtifa nwere, ma ihe o nwere nʼụlọ ma ndị o nwere nʼubi ya. ");
INSERT INTO ibo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ya mere, ọ hapụrụ ihe niile o nwere nʼaka Josef. Nke a mere na ọ mazighị ihe ọzọ na-eme, ma ọ bụghị nri nke ọ na-eri. Josef nʼonwe ya mara mma ahụ dịkwa mma ile anya. ");
INSERT INTO ibo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mgbe oge nta gasịrị, nwunye Pọtifa lere Josef anya sị ya, “Bịa ka anyị abụọ dinaa.” ");
INSERT INTO ibo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma Josef jụrụ. Ọ gwara nwunye nna ya ukwu sị, “Lee, nna m ukwu anaghị echegbu onwe ya banyere ihe ọbụla nʼụlọ a. O werela ihe niile o nwere nyefee m nʼaka ka m lekọta ha anya. ");
INSERT INTO ibo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","O nweghị onye ọnọdụ ya dị elu karịa nke m nʼụlọ a. O gbochighị m ihe ọbụla ma ọ bụghị gị, nʼihi na ị bụ nwunye ya. Olee otu m ga-esi mee oke ihe ọjọọ dị otu a, mee mmehie megide Chineke.” ");
INSERT INTO ibo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ọ bụ ezie na nwanyị a nọgidere na-enye Josef nsogbu site nʼụbọchị ruo ụbọchị ma Josef jụrụ iso ya dinaa, jụkwa ịnọnyere ya. ");
INSERT INTO ibo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Otu ụbọchị, Josef batara nʼime ụlọ ịrụ ọrụ ya. O nweghị ndị ọzọ na-eje ozi nọ nʼime ụlọ nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nwunye Pọtifa jidere Josef nʼuwe mwụda ya, rịọọ ya sị ya, “Bịa ka anyị dinaa.” Ma Josef si nʼime ụlọ ahụ gbapụ, hapụ uwe mwụda ya nʼaka nwunye Pọtifa. ");
INSERT INTO ibo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mgbe nwanyị a hụrụ na Josef agbapụla, hapụ uwe ya, ");
INSERT INTO ibo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ọ kpọrọ ndị na-eje ozi nʼezinaụlọ ya sị ha, “Lee, onye Hibru a di m kpọbatara nʼụlọ a chọrọ iji anyị gwurie egwu. Ọ bịakwutere m nʼime ụlọ chọọ ka mụ na ya dinaa. E tiri m mkpu nʼolu ike. ");
INSERT INTO ibo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mgbe ọ nụrụ ka m welitere olu m tie mkpu enyemaka m tiri, o sitere nʼime ụlọ a gbapụ, ma hapụrụ m uwe ya.” ");
INSERT INTO ibo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nwanyị a debere uwe ahụ nʼakụkụ ya ruo mgbe nna ya ukwu lọtara nʼụlọ. ");
INSERT INTO ibo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mgbe ahụ, ọ gwara di ya okwu ndị a sị, “Onye ohu Hibru a ị kpọbataara anyị bakwutere m iji m gwurie egwu. ");
INSERT INTO ibo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma mgbe m welitere olu tie mkpu enyemaka o sitere nʼụlọ gbapụ hapụrụ m uwe ya.” ");
INSERT INTO ibo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mgbe nna ya ukwu nụrụ ihe nwunye ya gwara ya sị, “Otu a ka ohu gị si meso m mmeso,” o were iwe dị ọkụ. ");
INSERT INTO ibo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nna ukwu Josef weere ya tụnye nʼụlọ mkpọrọ, nʼebe a na-etinye ndị mkpọrọ eze Ijipt. Ma ebe ahụ Josef nọ nʼụlọ mkpọrọ, ");
INSERT INTO ibo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Onyenwe anyị nọnyeere ya. O meere ya ebere, mekwa ka o nweta ihuọma nʼebe onyeisi ndị nche ụlọ mkpọrọ ahụ nọ. ");
INSERT INTO ibo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Onyeisi ndị na-eche ụlọ mkpọrọ mere Josef onyeisi ndị mkpọrọ niile nọ nʼime ụlọ mkpọrọ ahụ. Josef ghọrọ onye a na-ajụ otu ihe si aga nʼime ụlọ mkpọrọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Onyeisi ndị nche ụlọ mkpọrọ ahụ enyeghịkwa onwe ya nsogbu maka ihe ọbụla. Nʼihi na Onyenwe anyị nọnyeere Josef, mee ka ihe ọbụla ọ na-eme gaa nke ọma. ");
INSERT INTO ibo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mgbe ụfọdụ oge gasịrị, onye na-ebu iko ihe ọṅụṅụ eze Ijipt na onye na-esiri ya nri mehiere megide nna ha ukwu, eze Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nʼihi ya, Fero were iwe megide ndị ozi ya abụọ ndị a, onyeisi ndị na-ebu iko ya na onye na-esiri ya nri. ");
INSERT INTO ibo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","O tinyere ha na nga, nʼụlọ mkpọrọ dị nʼụlọ onyeisi ndị nche, ebe ahụ a tụbara Josef. ");
INSERT INTO ibo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Onyeisi ndị nche mere Josef onye na-elekọta ha. Ha nọrọ nʼụlọ mkpọrọ ọtụtụ ụbọchị. ");
INSERT INTO ibo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ha abụọ, onye ahụ na-esiri eze nri, na onye na-ebu iko eze Ijipt, rọrọ nrọ nʼotu abalị. Nrọ nke onye ọ bụla nwere nkọwa nke ya. ");
INSERT INTO ibo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mgbe chi bọrọ, Josef bịakwutere ha hụ na ihu ha gbarụrụ agbarụ. ");
INSERT INTO ibo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nʼihi ya, ọ jụrụ ndị ozi Fero ndị a ha na ya nọ nʼụlọ mkpọrọ dị nʼụlọ nna ya ukwu sị ha, “Gịnị mere ihu unu ji gbarụọ taa?” ");
INSERT INTO ibo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ha zara sị ya, “Anyị rọrọ nrọ ọjọọ, ma onye nkọwa ya adịghị.” Josef sịrị ha, “Ọ bụghị Chineke nwee ike ịkọwa nrọ? Kọọrọnụ m ha.” ");
INSERT INTO ibo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Onyeisi ndị na-ebu iko kọọrọ Josef nrọ ya. Ọ sịrị ya, “Arọrọ m nrọ hụ osisi vaịnị nʼihu m. ");
INSERT INTO ibo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Osisi vaịnị a nwere alaka atọ. Mgbe m nọ na-ele anya, osisi vaịnị ahụ mara ifuru, mịpụta mkpụrụ nʼụyọkọ nʼụyọkọ, ha chakwaa. ");
INSERT INTO ibo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ebe ọ bụ nʼiko Fero dị m nʼaka, a ghọọrọ m mkpụrụ vaịnị ndị a, pịpụta mmiri ha pịnye nʼime iko mmanya Fero, bunye ya ka ọ ṅụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef sịrị ya, “Nke a bụ ihe nrọ gị pụtara. Alaka atọ ahụ bụ abalị atọ. ");
INSERT INTO ibo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nʼime abalị atọ Fero ga-akpọpụta gị, mee ka i nwere onwe gị. Fero ga-enyeghachikwa gị ọrụ gị. Ị ga-etinyekwa Fero iko ya nʼaka dịka i si eme na mbụ mgbe ị bụ onye na-ebu iko ya. ");
INSERT INTO ibo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mgbe ihe gaara gị nke ọma, chetakwa m, ma gosi m obiọma, gwara m Fero ka o si nʼụlọ mkpọrọ a wepụta m. ");
INSERT INTO ibo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ọ bụ ntọrọ ka atọọrọ m site nʼala ndị Hibru. Nʼotu aka ahụ, nʼebe a ọ dịkwaghị ihe ọjọọ ọ bụla m mere nke kwesiri ka atụnye m nʼụlọ mkpọrọ a.” ");
INSERT INTO ibo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mgbe onyeisi ndị na-esiri Fero nri hụrụ na nkọwa nrọ ahụ dị mma, ọ sịrị Josef, “Mụ onwe m, na nrọ m nke m, ebu m nkata achịcha atọ nʼisi. ");
INSERT INTO ibo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nkata nke dị nʼelu jupụtara na achịcha dị iche iche e gheere eze, bụ Fero. Ma ụmụ nnụnụ bịara na-eri achịcha ndị ahụ dị na nkata m bụ nʼisi.” ");
INSERT INTO ibo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef zara sị ya, “Lee ihe nrọ gị pụtara. Nkata atọ ahụ bụ abalị atọ. ");
INSERT INTO ibo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nʼime abalị atọ ka Fero ga-esi nʼụlọ mkpọrọ kpọpụta gị, nye iwu ka e bepụ gị isi, kwụba gị nʼelu osisi. Ụmụ nnụnụ ga-erichapụ anụ ahụ gị.” ");
INSERT INTO ibo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nʼabalị nke atọ, site nʼụbọchị ndị a rọrọ nrọ ha, Fero mere mmemme ncheta ọmụmụ ya. Ọ kpọrọ ndị niile na-ejere ya ozi oriri. O ziri ozi ka a gaa nʼụlọ mkpọrọ kpọpụta onyeisi ndị na-ebunye ya iko ihe ọṅụṅụ na onyeisi ndị na-esiri ya nri. ");
INSERT INTO ibo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","O nyeghachiri onyeisi ndị na-ebu iko ya ọrụ ya, weghachi ya nʼọnọdụ ya. Nwoke a bunyekwara Fero iko ya dịka o si eme na mbụ. ");
INSERT INTO ibo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma ọ kwụgburu onyeisi ndị na-esiri ya nri, dịka Josef si kọwaa nrọ ha. ");
INSERT INTO ibo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ma onyeisi ndị ahụ na-ebu iko eze echetaghị Josef. O chefuru ya. ");
INSERT INTO ibo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","O ruo mgbe afọ abụọ gasịrị, Fero rọrọ nrọ hụ onwe ya ka o guzo nʼakụkụ mmiri Naịl. ");
INSERT INTO ibo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nʼebe ahụ, ọ hụrụ ehi asaa ndị si nʼosimiri Naịl na-apụta. Ehi ndị a buru ibu, maa mma. Ahụ ha na-akwọ mụrụmụrụ. Ha pụtara, bido ịta nri nʼetiti ahịhịa riidi. ");
INSERT INTO ibo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nʼatụfughị oge, ehi asaa ọzọ soro ha nʼazụ sikwa nʼosimiri Naịl na-apụta. Ma ehi ndị a tara ahụ nke ukwuu. Ha bụ nnọọ ọkpụkpụ ọkpụkpụ, jọọ njọ ile anya. Ha bịara guzo nʼakụkụ ehi ndị ahụ buru ibu. ");
INSERT INTO ibo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Mgbe ahụ, ehi ndị a bụ naanị ọkpụkpụ ọkpụkpụ bịara richapụ ehi ndị ahụ buru ibu. Mgbe nke a mere Fero kwolitere. ");
INSERT INTO ibo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Emesịa, Fero rahụkwara ụra ọzọ, rọọ nrọ nke ugboro abụọ, hụ ogbe ọka asaa ndị mịrị nʼotu ukwu ọka. Ogbe ọka ndị a buru ibu maa ezi mma. ");
INSERT INTO ibo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Emesịa, ọ hụkwara ogbe ọka asaa ọzọ ka ha mịkwara nʼotu ukwu ọka ahụ. Ma ndị a ọ hụrụ kpọnwụsịrị akpọnwụ, fịkpọkwa afịkpọ. Ọ bụ ikuku si nʼọwụwa anyanwụ mere ka ha kpọnwụọ. ");
INSERT INTO ibo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ogbe ọka ndị a fịkpọrọ afịkpọ loro ogbe ọka asaa ndị ahụ buru ibu. Fero kwolitere hụ na ihe ndị a bụ nrọ. ");
INSERT INTO ibo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mgbe chi bọrọ, o nweghị udo na mmụọ ya. O ziri ozi kpọkọta ndị majiki niile, na ndị ọkachamara niile nke Ijipt. Fero kọọrọ ha ihe ọ rọrọ na nrọ. Ma ọ dịghị onye nwere ike ịkọwara ya ihe nrọ ya pụtara. ");
INSERT INTO ibo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ma nʼoge ahụ, onyeisi ndị na-ebu iko jekwuuru Fero gwa ya sị, “Taa ka m chetara mmehie m. ");
INSERT INTO ibo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Oge ahụ Fero were iwe megide ndị na-ejere ya ozi, o tinyere mụ na onyeisi ndị na-esi nri nʼụlọ mkpọrọ nke dị nʼebe onyeisi ndị nche eze bi. ");
INSERT INTO ibo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Onye ọbụla nʼime anyị abụọ rọrọ nrọ nʼotu abalị, nrọ ọbụla nwekwara nkọwa nke ya. ");
INSERT INTO ibo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","O nwere nwokorobịa onye Hibru anyị na ya nọ nʼụlọ mkpọrọ nʼoge ahụ. Ọ bụ ohu onyeisi ndị nche eze. Anyị kọọrọ ya nrọ anyị rọrọ. Ọ kọwakwaara anyị ihe nrọ anyị pụtara nye onye ọbụla nkọwa nke nrọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ihe niile mere dịka o si kọwara anyị. E nyeghachiri m ọnọdụ m, ma kwụba onye nke ọzọ nʼosisi.” ");
INSERT INTO ibo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ya mere Fero ziri ozi ka a kpọọ Josef. E mere ngwangwa wepụta ya site nʼụlọ mkpọrọ ahụ. Mgbe ọ kpụchara afụọnụ ya, gbanwee uwe ya, ọ bịakwara nʼihu Fero. ");
INSERT INTO ibo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fero gwara Josef sị, “Arọrọ m nrọ ma o nweghị onye ọbụla nwere ike ịkọwara m ihe nrọ m rọrọ pụtara. Ma anụla m na a kọọrọ gị nrọ a rọrọ, i nwere ike ịkọwa ihe nrọ ahụ pụtara.” ");
INSERT INTO ibo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef zara sị ya, “Enweghị m ike ịkọwa nrọ nʼike aka m. Ma Chineke ga-enye Fero ọsịsa udo dịka ọ chọrọ.” ");
INSERT INTO ibo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mgbe ahụ, Fero malitere ịkọwara Josef nrọ ya. O kwuru sị, “Eguzoro m nʼakụkụ osimiri Naịl na nrọ m. ");
INSERT INTO ibo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mgbe ahụ, ahụrụ m ehi asaa si na mmiri ahụ pụta. Ehi ndị a mara abụba, ma gbaa agba. Ha bidokwara ịta nri nʼetiti ahịhịa riidi. ");
INSERT INTO ibo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Emesịa, a hụrụ m ehi asaa ọzọ ka ha sikwa nʼosimiri ahụ pụta. Ehi ndị a ejighị ahụ. Ha bụ ọkpụkpụ ọkpụkpụ, jọọ njọ ile anya. Nʼezie, ahụtụbeghị m ụdị ehi dị otu a nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ehi asaa ndị a jọrọ njọ riri ehi ndị ahụ buru ibu, bụ ndị bu ha ụzọ si nʼosimiri ahụ pụta. ");
INSERT INTO ibo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ma mgbe ha risiri ehi ndị a, nri ahụ emeghị ka ụdịdị ha gbanwee. Ha dịkwa otu ha dị. Mgbe m hụsịrị ihe a, etetara m nʼụra. ");
INSERT INTO ibo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mgbe m rọrọ nrọ ọzọ, a hụrụ m ogbe ọka asaa nke mịrị nʼotu ukwu ọka. Ọka asaa ndị a buru ibu, dị mma ile anya. ");
INSERT INTO ibo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ogbe ọka asaa ọzọ mịkwara nʼelu ukwu ọka ahụ, ma ndị a kpọnwụrụ akpọnwụ, fịkpọkwa afịkpọ nʼihi nʼikuku si nʼọwụwa anyanwụ chakpọrọ ha. ");
INSERT INTO ibo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma ọka ndị a fịkpọrọ afịkpọ lodara ọka asaa ndị ahụ mara mma. Akọọlara m ndị majiki ihe ndị a, ma ọ dịghị onye nʼime ha nwere ike ịkọwara m ihe nrọ ndị a pụtara.” ");
INSERT INTO ibo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Mgbe ahụ, Josef sịrị Fero, “Nrọ abụọ Fero rọrọ pụtara otu ihe. Chineke esitela na nrọ ndị a gwa Fero ihe ọ na-aga ime. ");
INSERT INTO ibo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ehi asaa ndị ahụ buru ibu bụ afọ asaa. Ogbe ọka asaa ndị ahụ buru ibu bụkwa afọ asaa. Ọ bụ otu nrọ ahụ, ọ bụ ezie na ị rọrọ ya ugboro abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ehi asaa ndị ọzọ ahụ dị ọkpụkpụ ọkpụkpụ ndị pụtara mgbe ndị nke mbụ pụtachara bụ afọ asaa. Otu a kwa ogbe ọka ndị ọzọ fịkpọrọ afịkpọ nke ikuku si nʼọwụwa anyanwụ mere ka ha fịkpọọ bụ afọ asaa. Ha na-egosi afọ asaa mgbe oke ụnwụ ga-adị. ");
INSERT INTO ibo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Dịka m gwara Fero na mbụ, Chineke egosila gị ihe ọ chọrọ ime. ");
INSERT INTO ibo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Afọ asaa na-abịa ga-abụ afọ asaa mgbe nri ga-adị ukwuu nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Emesịa afọ asaa oke ụnwụ ga-eso ha. Mgbe ahụ, a ga-echefu ụba niile nke ala Ijipt. Ụnwụ a ga-ala obodo nʼiyi. ");
INSERT INTO ibo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Agaghị echetakwa na e nwere oge ịba ụba ihe oriri nʼala a, nʼihi oke ụnwụ ahụ nke ga-eso ya ga-adị oke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ihe mere Fero ji rọọ nrọ a ugboro abụọ bụ nʼihi na Chineke ekpebiela na ihe ndị a ga-emezuriri. Chineke ga-emekwa ya nʼoge na-adịghị anya. ");
INSERT INTO ibo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ma ugbu a, ka Fero chọọ onye nwere ezi nghọta na amamihe. Ya mee ya onyeisi ọchịchị nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ka Fero mee nhọpụta ndị nlekọta ala Ijipt. Ka e debe otu ụzọ nʼime ụzọ ise nke nri niile a ga-enweta nʼoge ahụ nri ga-adị ukwuu nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ka ha kpokọtaa nri niile ga-adị nʼoge ịba ụba nke ihe oriri, nke ga-adị nʼafọ ndị a na-abịa. Ka ha kpokọta ha nʼụlọ ichebe nri nke ga-adị nʼokpuru ọchịchị Fero. Ka ọ bụrụ nri e debere nʼobodo dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","A ga-echebe nri ndị a nke ọma maka ndị bi nʼala a, ka ọ bụrụ nri a ga-eri nʼime afọ asaa ndị ahụ nke ụnwụ ga-adị nʼala Ijipt, ka ụnwụ ghara ibibi ala a.” ");
INSERT INTO ibo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ntụpụta ahụ dị mma nʼanya Fero na ndịisi ọchịchị ya. ");
INSERT INTO ibo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Fero jụrụ ndịisi ọchịchị ya, “Anyị ga-achọtali onye ọzọ dịka nwoke a, onye mmụọ nke Chineke dị nʼime ya?” ");
INSERT INTO ibo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ya mere Fero tụgharịrị sị Josef, “Ebe Chineke kpugheere gị ihe ndị a, o nweghị onye ọzọ nwere ezi nghọta na amamihe dịka gị. ");
INSERT INTO ibo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gị onwe gị ga-abụ onye na-elekọta ụlọeze m. Ndị m niile ga-erube isi nʼiwu ọbụla i nyere. Ọ bụ naanị nʼocheeze ka m ga-eji dị ukwuu karịa gị.” ");
INSERT INTO ibo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Fero gwara Josef, “Lee, emeela m gị onye nlekọta ala Ijipt niile.” ");
INSERT INTO ibo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mgbe ahụ, Fero gbapụtara mgbaaka eze ya gbanye ya Josef nʼaka. O yikwasịkwara Josef uwe e ji ezi akwa ọcha duo, nyanye ya ihe ịnya nʼolu nke e ji ọlaedo kpụọ. ");
INSERT INTO ibo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","O mere ka ọ nyaa ịnyịnya ụgbọ ya nke abụọ. Ndị oti mkpu na-etikwa nʼihu ya, “Gbuonụ ikpere nʼala.” Otu a ka Fero si mee Josef onye na-achị ala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fero gwakwara Josef sị, “Ọ bụ mụ onwe m bụ Fero! O nweghị onye ọbụla ga-ewelita aka maọbụ ụkwụ ya nʼala Ijipt niile ma ọ bụghị site nʼike i nyere ya.” ");
INSERT INTO ibo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fero gụrụ Josef aha Zafenat-Pania. Ọ kpọnyekwara ya, Asenat, nwa Pọtifera, onye nchụaja obodo a na-akpọ On, ka ọ bụrụ nwunye ya. Josef bịara gazuo ala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef gbara iri afọ atọ mgbe o bidoro iguzo nʼihu Fero eze Ijipt. O si nʼihu Fero pụọ, malite ijegharị ebe niile nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nʼafọ asaa ahụ nke a na-eriju afọ, ala mepụtara nri nʼebe ọ dị ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nʼime afọ asaa ndị a nke nri juru ebe niile nʼIjipt, Josef chịkọtara nri niile nke si nʼubi, ma chekwaa ha nʼụlọ e wuru maka iche nri nʼobodo niile ahụ. Nʼobodo ọbụla, ka ọ na-etinye ihe oriri nke si nʼubi gbara ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josef chekwara ọka dị ukwuu nʼọnụọgụgụ, dịka aja dị nʼakụkụ osimiri. A kwụsịrị ịgụ ha ọnụ nʼihi na ha hiri nne nke ukwuu nke na ha enweghị ọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tupu oge ụnwụ ahụ ebido, Asenat nwa nwanyị Pọtifera, onye nchụaja nke On, mụtara Josef ụmụ ndị ikom abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef gụrụ ọkpara ya Manase, nʼihi na ọ sịrị, “Chineke emeela ka m chefuo ahụhụ m niile, mekwa ka m chefuo ndị ezinaụlọ nna m.” ");
INSERT INTO ibo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Josef gụrụ nwa ya nke abụọ Ifrem. Ọ sịrị, “Nʼihi na Chineke emeela ka m mịa mkpụrụ nʼala nke ahụhụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Afọ asaa nke ụba nri nke dịrị nʼala Ijipt mechara gabiga. ");
INSERT INTO ibo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Afọ asaa nke ụnwụ bidoro bịawa dịka Josef kwuru. Ụnwụ nọ nʼobodo niile, ma nʼala Ijipt niile nri dị. ");
INSERT INTO ibo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ka agụ jidere ala Ijipt niile, ndị mmadụ tikuru Fero ka o nye ha nri. Ma Fero gwara ndị Ijipt niile, “Jekwurunụ Josef. Ihe ọbụla ọ gwara unu meenụ ya.” ");
INSERT INTO ibo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mgbe ụnwụ ahụ gbasara ruo nʼakụkụ niile nke ala ahụ, Josef meghepụrụ ụlọ ichebe nri niile bido iresi ndị Ijipt nri, nʼihi na ụnwụ ahụ dị njọ nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mba niile bịara Ijipt ịzụ nri site nʼaka Josef nʼihi na ụnwụ ahụ dị njọ nʼụwa niile. ");
INSERT INTO ibo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ugbu a, Jekọb nụrụ na ọka dị nʼIjipt. Ọ sịrị ụmụ ya, “Kedụ ihe anyị jiri nọrọ na-elerịta onwe anyị anya” ");
INSERT INTO ibo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ọ sịrị, “Lee anụrụ m na ọka dị nʼIjipt. Gbadatanụ nʼebe ahụ zụtara anyị ọka ka anyị dị ndụ ghara ịnwụ.” ");
INSERT INTO ibo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ụmụnne Josef iri ndị ahụ gbadara Ijipt ịzụta ọka. ");
INSERT INTO ibo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Jekọb ekweghị ka Benjamin nwanne nta Josef soro ha gaa, nʼihi na ọ tụrụ egwu na ihe ndaba ọjọọ nwere ike ịbịakwasị ya. ");
INSERT INTO ibo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Otu a, ụmụ Izrel so nʼọtụtụ ndị ọzọ ndị jekwara ịzụrụ nri nʼIjipt, nʼihi na ụnwụ ahụ dị njọ nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nʼoge a, Josef na-achị ala Ijipt, bụrụkwa onye iresi ndị obodo ọka dị nʼaka. Ya mere, mgbe ụmụnne Josef rutere, ha bịara hulata kpọọ isiala nye Josef. ");
INSERT INTO ibo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mgbe Josef hụrụ ụmụnne ya, ọ matara ndị ha bụ. Ma ọ kpara agwa dịka onye na-amaghị ha, gwa ha okwu nʼolu ike, sị ha, “Ebee ka unu si bịa?” Ha zara, “Anyị si ala Kenan bịa. Anyị bịara ịzụrụ nri.” ");
INSERT INTO ibo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josef matara ụmụnne ya, ma ha onwe ha amataghị onye ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Josef chetakwara nrọ ndị ahụ ọ rọrọ banyere ha. Ọ gwara ha okwu sị ha, “Unu bụ ndị nnyocha. Ịchọpụta adịghị ike ala anyị mere unu ji bịa.” ");
INSERT INTO ibo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ha zara sị, “Nna anyị ukwu, anyị bụ ndị ohu gị bịara ịzụrụ nri. ");
INSERT INTO ibo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Anyị niile bụ ụmụ otu nna. Ndị ohu gị bụ ndị kwesiri ntụkwasị obi. Anyị abụghị ndị nnyopụta.” ");
INSERT INTO ibo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma Josef gwara ha sị, “Mba! Unu bịara ịchọpụta akụkụ obodo anyị nke a na-echezighị nke ọma.” ");
INSERT INTO ibo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ha zara sị ya, “Ndị ohu gị dị ụmụnne iri na abụọ. Ọ bụkwa otu nna mụrụ anyị niile. Nna anyị na nwanne anyị nta, onye ikpeazụ ọ mụrụ nọ na Kenan ugbu a. Ma otu onye nʼime anyị anwụọla.” ");
INSERT INTO ibo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef sịrị, “Ihe unu na-akọ na-egosi na unu bụ ndị nnyopụta, dịka m gwara unu. ");
INSERT INTO ibo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nke a ka a ga-eji anwale unu. Nʼaha Fero dị ndụ, unu agaghị esi nʼebe a laa tutu nwanne unu nke nta ahụ abịa nʼebe a. ");
INSERT INTO ibo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Zipụnụ otu onye nʼime unu ka ọ gaa kpọta nwanne unu nwoke. Ma aga m etinye ndị fọdụrụ nʼụlọ mkpọrọ, tutu m chọpụta ma ihe unu kwuru ọ bụ eziokwu maọbụ ụgha. Ọ bụrụ ụgha nʼezie, dịka Fero na-adị ndụ, unu bụ ndị nnyopụta.” ");
INSERT INTO ibo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","O tinyere ha niile nʼụlọ mkpọrọ, hapụ ha nʼebe ahụ abalị atọ. ");
INSERT INTO ibo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Josef gwara ha, nʼụbọchị nke atọ, “Nke a bụ ihe unu ga-eme ma dị ndụ, nʼihi na abụ m onye na-atụ egwu Chineke. ");
INSERT INTO ibo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ọ bụrụ na unu bụ ndị ezi mmadụ, ka otu onye nʼime unu nọdụ nʼebe a, nʼụlọ mkpọrọ, ka ndị fọdụrụ buru ọka bulaara ndị ezinaụlọ unu nọ nʼagụụ. ");
INSERT INTO ibo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ma kpọtaranụ m nwanne unu nke nta nʼebe a, nke a ga-egosi na okwu unu bụ eziokwu, na unu agaghịkwa anwụ.” Ha mere otu a. ");
INSERT INTO ibo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ha gwarịtara onwe ha okwu sị, “Nʼezie, ọ bụ nʼihi nwanne anyị nwoke ka ahụhụ ndị a ji abịakwasị anyị. Anyị hụrụ obi mgbawa ya, mgbe ọ na-arịọ ka anyị chebe ndụ ya, ma anyị egeghị ya ntị. Ọ bụ nke a mere mmekpa ahụ ndị a ji bịakwasị anyị ugbu a.” ");
INSERT INTO ibo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben zara sị ha, “Ọ bụ na mụ agwaghị unu sị unu hapụ imejọ nwantakịrị ahụ, ma unu egeghị ntị? Ugbu a, anyị na-asa ajụjụ banyere ọbara ya.” ");
INSERT INTO ibo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ha amataghị na Josef na-anụ ihe ha na-ekwu, nʼihi na onye nsụgharị okwu nọ nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","O sitere nʼebe ha nọ tụgharịa gaa kwaa akwa. Ọ lọghachikwutere ha ọzọ gwakwa ha okwu. O si nʼetiti ha kpọpụta Simiọn kee ya agbụ ka ha na-ele ya anya. ");
INSERT INTO ibo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josef nyere iwu ka e kpojuo ọka nʼakpa ha, tinyekwara onye ọbụla ego ọ kwụrụ nʼakpa ya. Ọ nyere iwu ka e nye ha ihe ha ga-eri nʼụzọ. Mgbe e mesịrị ihe ndị a, ");
INSERT INTO ibo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ha bokwasịrị ịnyịnya ibu akpa ọka ha nʼotu nʼotu. Ha hapụrụ Ijipt lawa. ");
INSERT INTO ibo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mgbe ha ruru ebe ha nọrọ ọnọdụ abalị, otu nʼime ha meghere akpa ya ka o nye ịnyịnya ibu ya ọka, ọ hụrụ ego ya nʼọnụ akpa ya. ");
INSERT INTO ibo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ọ gwara ụmụnne ya sị, “Lee, e tighachiri ego m kwụrụ. Lee ya nʼakpa ọka m.” Ike gwụrụ onye ọbụla nʼime ha. Site nʼahụ ịma jijiji ha lerịtara onwe ha anya sị, “Gịnị bụ ihe a Chineke mere anyị?” ");
INSERT INTO ibo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mgbe ha lakwutere nna ha Jekọb nʼala Kenan, ha kọọrọ ya ihe niile dakwasịrị ha. Ha gwara ya sị, ");
INSERT INTO ibo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nwoke na-achị ala ahụ gwara anyị okwu nʼolu ike. O mesoro anyị mmeso dịka anyị bụ ndị bịara inyochapụta obodo ha. ");
INSERT INTO ibo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma anyị gwara ya sị, ‘Anyị bụ ndị kwesiri ntụkwasị obi, ndị na-abụghị ndị nnyopụta obodo. ");
INSERT INTO ibo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Anyị dị ụmụnne iri na abụọ ndị nwere otu nna. Otu nʼime anyị anọkwaghị, ma nke ntakịrị na nna anyị nọ na nʼala Kenan taa.’ ");
INSERT INTO ibo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Mgbe ahụ, nwoke a, onye na-achị ala ahụ, sịrị anyị, ‘Nke a ka m ga-eji mata ma unu bụ ndị ezi mmadụ. Hapụrụnụ m otu nwanne unu. Burunu ọka, bulaara ndị ezinaụlọ unu agụụ na-agụgbu. ");
INSERT INTO ibo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ma kpọtara m nwanne unu nke nta. Mgbe ahụ ka m ga-ama ihe unu bụ. Ma unu bụ ndị nnyopụta maọbụ ndị ezi mmadụ. Mgbe ahụ, aga m ahapụrụ unu nwanne unu. Unu ga na-azụkwa ahịa nʼala a.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mgbe ha bidoro ịwụpụtasị ọka dị nʼakpa ha, lee, nʼime akpa ọka onye ọbụla, a chọtara ego ọ kwụrụ nʼakpa ya. Mgbe ha na nna ha hụrụ ego ndị a, ha tụrụ egwu. ");
INSERT INTO ibo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ya mere, nna ha Jekọb gwara ha sị, “Unu agbawala m aka ụmụ. Josef anọghị, Simiọn anọkwaghị. Ma unu na-achọ iwezuga Benjamin. Naanị m ka ihe niile ndị a na-emegide!” ");
INSERT INTO ibo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mgbe ahụ, Ruben gwara nna ya sị, “I nwere ike gbuo ụmụ m ndị ikom abụọ ma ọ bụrụ na m akpọghachighị Benjamin. Tifee ya nʼaka m, aga m akpọghachikwara gị ya.” ");
INSERT INTO ibo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Jekọb sịrị, “Nwa m agaghị eso unu gaa. Nʼihi na nwanne ya anwụọla, ọ bụkwa naanị ya ka ọ fọdụrụ. Ọ bụrụ na nsogbu ezute ya nʼụzọ nʼije a, unu ga-eme ka m jiri isi awọ m laa nʼili nʼọnọdụ mwute.” ");
INSERT INTO ibo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ma ụnwụ a siri oke ike nʼala ahụ nʼoge a. ");
INSERT INTO ibo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","O ruo, mgbe ha richara nri ha zụtara nʼIjipt, nna ha gwara ha sị, “Jeghachinụ, zụtara anyị ntakịrị nri.” ");
INSERT INTO ibo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda gwara nna ya bụ Jekọb sị, “Nwoke ahụ dọsiri anyị aka na ntị ike sị, ‘Unu agaghị ahụ ihu m ma ọ bụrụ na nwanne unu esoghị unu bịa.’ ");
INSERT INTO ibo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ọ bụrụ na ị ga-edunyere anyị nwanne anyị, anyị ga-agbada gaa zụtara gị nri. ");
INSERT INTO ibo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ma ọ bụrụ na ị gaghị edunyere anyị ya, anyị agaghị agbada, nʼihi na nwoke a sịrị anyị, ‘Unu agaghị ahụ ihu m ma ọ bụrụ na nwanna unu esoghị unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Mgbe ahụ Izrel sịrị, “Gịnị mere unu ji wetara m nsogbu dị otu a, site nʼịgwa nwoke ahụ na unu nwere nwanne ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ha zara sị, “Nwoke a jụrụ anyị ajụjụ dị iche iche banyere onwe anyị, na ndị ezinaụlọ anyị. Ọ sị, ‘Nna unu, ọ dị ndụ ugbu a? Unu nwere nwanne ọzọ?’ Ya mere, anyị zara ajụjụ niile. O nweghị otu anyị siri mara na ọ ga-asị anyị kpọta nwanne anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Mgbe ahụ, Juda sịrị nna ya Izrel, “Dunye m nwantakịrị a ka anyị bilie gawa, ka anyị dị ndụ ghara ịnwụ, ma anyị onwe anyị, ma gị, ma ụmụntakịrị anyị. ");
INSERT INTO ibo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Aga m eji onwe m gbaa ebe nʼihi ya. I nwere ike itife ya nʼaka m. Ọ bụrụ na m akpọtaghachighị ya, kpọbata ya nʼihu gị, mgbe ahụ, ịta ụta bụrụ nke m nʼihu gị, nʼụbọchị ndụ m niile. ");
INSERT INTO ibo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","A sị nnọọ na anyị egbughị oge niile a, anyị gaara aga ma lọtakwarị ugboro abụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Mgbe ahụ nna ha Izrel gwara ha sị, “Ọ bụrụ na ọ ga-adịrịrị otu a, gịnị ọzọ ka anyị ga-eme. Kama mgbe unu na-aga, werenụ nʼakpa unu onyinye ịnata ihuọma nke bụ ihe niile kachasị mma nke si nʼala a welaara nwoke a. Werenụ nwantịntị mmanụ otite, na nwantịntị mmanụ aṅụ, ha na ụda dị iche iche, na eso osisi máá, na akụ, na alụmọnd. ");
INSERT INTO ibo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Werekwanụ ego okpukpu abụọ nʼaka unu. Weghachirinụ ya ego ahụ e tinyere nʼọnụ akpa unu, eleghị anya ọ bụ nʼohihie anya ka ha ji tinye ya. ");
INSERT INTO ibo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ngwa, kpọrọnụ nwanne unu nwoke bilienụ laghachikwurunụ nwoke ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ka Chineke Onye pụrụ ime ihe niile, mee ka nwoke ahụ nwee obi ebere nʼebe unu nọ. Ya meekwa ka o nwee ike ịhapụrụ unu nwanne unu Simiọn na Benjamin ka ha soro unu lọta. Ọ bụrụkwanụ uche Chineke na m ga-agbara aka ụmụ, ya mee dịka o si chọọ.” ");
INSERT INTO ibo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ya mere, ndị ikom ahụ weere onyinye ndị a, na okpukpu ego abụọ nʼaka, ma kpọrọkwa Benjamin. Ha biliri ije. Garuo Ijipt, ma guzo nʼihu Josef. ");
INSERT INTO ibo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mgbe Josef lepụrụ anya hụ Benjamin nʼetiti ha, ọ gwara onye na-elekọta ụlọ ya sị, “Duru ndị ikom ndị a gaa nʼụlọ. Gbuo anụ, kwadoo nri, nʼihi na ndị a ga-eso m rie nri ehihie.” ");
INSERT INTO ibo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Odibo a mere dịka Josef ziri ya. O duuru ndị ikom ndị ahụ gaa nʼụlọ Josef. ");
INSERT INTO ibo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nʼoge a, mgbe a kpọbatara ha nʼụlọ, ndị ikom ndị ahụ tụrụ ụjọ, nʼihi na a kpọbatara ha nʼime ụlọ Josef. Ha sịrị, “Ọ bụ nʼihi ego ahụ e tighachiri nʼakpa anyị nʼoge mbụ ka e ji kpọbata anyị, ka o nwee ike ịchọta ụzọ ọ ga-esi megide anyị, mesie anyị ike, si otu a were anyị na ịnyịnya ibu anyị dịka ndị ohu ya.” ");
INSERT INTO ibo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ha bịaruru odibo Josef ahụ nso gwa ya okwu nʼọnụ ụzọ ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ha sịrị ya, “Nna anyị ukwu, anyị bịara ebe a nʼoge mbụ ịzụ ihe oriri. ");
INSERT INTO ibo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ma, mgbe anyị rutere ebe anyị nọrọ ọnọdụ abalị, anyị meghere akpa anyị, chọpụta ego anyị kwụrụ nʼihi nri ahụ anyị zụrụ ka ọ dị nʼọnụ akpa anyị nʼotu na otu. E sepụkwaghị ya ihe ọ bụla. Ya mere, anyị weghachiri ya nʼoge a. ");
INSERT INTO ibo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Anyị jikwa ego ọzọ anyị ga-eji zụọ ihe oriri. Ma anyị amaghị onye tinyere ego ahụ nʼime akpa anyị.” ");
INSERT INTO ibo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Odibo ahụ zara sị ha, “Udo dịrị unu, unu atụla egwu, nʼihi na Chineke unu, na Chineke nna unu enyela unu akụ zoro ezo nʼime akpa unu. Ego unu kwụrụ ruru m aka.” Mgbe ahụ, ọ hapụrụ ha gaa kpọpụta Simiọn. ");
INSERT INTO ibo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nʼoge ahụ, odibo ahụ duuru ndị ikom ndị ahụ bata nʼụlọ Josef, nye ha mmiri ha ji saa ụkwụ ha. O nyekwara ịnyịnya ibu ha nri. ");
INSERT INTO ibo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mgbe ahụ, ụmụ Jekọb kwadoro onyinye ịnata ihuọma ha ji bịa, nke ha ga-enye Josef ma ọ bata nʼetiti ehihie, nʼihi na ha anụla na ha ga-eri nri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mgbe Josef lọtara ụlọ, ha wetaara ya onyinye dị nʼaka ha, daa nʼala, kpọọ isiala nye ya. ");
INSERT INTO ibo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Josef jụrụ ha ajụjụ banyere ọdịmma ha, jụọkwa ha sị, “Agadi nna unu, nke unu gwara m ihe banyere ya, ahụ ọ dịkwa ya? Ọ ka dịkwa ndụ.” ");
INSERT INTO ibo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ha zaghachiri sị ya, “Ahụ dị ohu gị bụ nna anyị. Ọ ka nọ ndụ.” Ha hulatara isi ha, kpọọ isiala nye ya. ");
INSERT INTO ibo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mgbe Josef welitere anya ya elu hụ nwanne ya Benjamin, onye bụ nwanne afọ ya, ọ jụrụ ha ajụjụ sị, “Onye a ọ bụ nwanne unu nke nta ahụ unu gwara m ihe banyere ya?” Tupu ha asaa ya ihe ọbụla, o lere Benjamin anya sị ya, “Ka amara Chineke dịrị gị, nwa m nwoke.” ");
INSERT INTO ibo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mgbe ahụ kwa Josef mere ọsịịsọ pụọ nʼezi ịchọ ebe ọ ga-akwa akwa nʼihi na ọhụhụ ọ hụrụ nwanne ya anya ọzọ metụrụ ya nnọọ nʼobi. Ọ pụrụ banye nʼime ụlọ ya kwaa akwa. ");
INSERT INTO ibo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Emesịa, ọ sara ihu ya, pụta, jisie onwe ya ike nye odibo ya iwu ka o bute nri ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ha doziiri ya nri nke ya iche, doziekwara ụmụnne ya nri nke ha iche. Otu a kwa, ha dozikwaara ndị Ijipt ya na ha na-erikọ nri, nri nke ha iche. Nʼihi na ọ bụ ihe arụ nʼanya ndị Ijipt na ha na ndị Hibru ga-erikọta nri ọnụ. ");
INSERT INTO ibo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma mgbe e nyere ha ọnọdụ nʼihu Josef, e mere ka ha nọdụ dịka ha si tọọ ibe ha. Nke ọkpara buru ụzọ nọdụ, onye na-eso ya anọdụkwa. Otu a ka ha niile siri nọdụ ruo nʼonye ikpeazụ nʼime ha. Ha lerịtara onwe ha anya nʼihi na o juru ha anya. ");
INSERT INTO ibo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","O sitekwara na nri e doziri ya nyebinye ha nri. Nri e nyere Benjamin dị ukwuu okpukpu ise karịa nri nke e nyere ha niile. Ha na ya riri, ṅụọkwa nʼuju. ");
INSERT INTO ibo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Mgbe ahụ Josef nyere odibo nọ nʼụlọ ya iwu sị, “Gbajuo akpa ndị ikom ndị a nri. Tinyere ha nri nke onye ọbụla nʼime ha nwere ike ibu, tinyekwa ego nke onye ọbụla nʼime ha kwụrụ nʼọnụ akpa ya. ");
INSERT INTO ibo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ma tinye iko ọlaọcha m nʼime ọnụ akpa onye nke nta nʼime ha. Tinyekwa ego ọ kwụrụ nʼihi nri ọ zụrụ nʼime akpa ya.” Odibo a mere dịka Josef gwara ya. ");
INSERT INTO ibo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mgbe chi bọrọ, ha zipụrụ ndị ikom ndị a, ha na ịnyịnya ibu ha. ");
INSERT INTO ibo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mgbe ha ji naanị ihe nta gafee obodo ahụ, Josef gwara odibo ya sị, “Bilie, chụso ndị ikom ndị ahụ ọsọ. I zute ha, sị ha, ‘Gịnị mere unu ji were ihe ọjọọ kwụghachi ihe ọma? ");
INSERT INTO ibo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Gịnị mere unu ji zuru iko ọlaọcha nna m ukwu, iko o ji aṅụ ihe ọṅụṅụ na nke o ji ajụ ase? Unu emeela ihe ọjọọ nʼihi ihe a unu mere.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mgbe odibo ahụ zutere ha, ọ gwara ha ihe ndị a. ");
INSERT INTO ibo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma ha zara sị ya, “Nna anyị ukwu, gịnị mere i ji ekwu ụdị okwu ndị a? Ihe arụ ka ọ bụ anyị ime ihe dị otu a. ");
INSERT INTO ibo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Lee, ego anyị chọtara nʼọnụ akpa anyị ka anyị sitere nʼala Kenan weghachi. Olee otu anyị ga-esi zuru ọlaedo maọbụ ọlaọcha site nʼụlọ nna gị ukwu? ");
INSERT INTO ibo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Onye ọbụla nʼime anyị a chọtara iko a nʼaka ya ga-anwụ. Anyị onwe anyị ga-aghọrọ nna anyị ukwu ndị ohu.” ");
INSERT INTO ibo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Odibo ahụ zara sị ha, “Ka ọ dịrị dịka unu kwuru. Onye ọbụla a chọtara ya nʼaka ga-abụ ohu m. Ma ndị a na-achọtaghị ya nʼaka ha enweghị ịta ụta ọbụla.” ");
INSERT INTO ibo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ha mere ngwangwa, onye ọbụla tọdatara akpa ya. Onye ọbụla kwa meghere akpa ya. ");
INSERT INTO ibo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Odibo ahụ malitere nʼonye ukwu nʼetiti ha chọọ rute nʼonye nta. Ọ bụ nʼakpa Benjamin ka a chọtara iko ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Mgbe ahụ, ha dọwara uwe ha nʼihi mwute. Onye ọbụla nʼime ha tighachiri ibu ya nʼelu ịnyịnya ibu ya. Ha niile bidokwara ịlaghachi azụ nʼobodo ha si pụta. ");
INSERT INTO ibo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mgbe Juda na ụmụnne ya lọghachiri nʼụlọ Josef, ha hụrụ Josef ka ọ nọ nʼebe ahụ. Ha dara nʼala nʼihu ya. ");
INSERT INTO ibo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma Josef jụrụ ha sị, “Gịnị bụ ihe a unu mere? Ọ bụ na unu amataghị na onye dịka m nwere ike ịmata onye zuru iko m?” ");
INSERT INTO ibo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ya mere Juda sị ya, “Gịnị ka anyị ga-ekwu? Olee otu anyị ga-esi gosi nʼaka anyị dị ọcha? Chineke ekpugheela ikpe ọmụma ndị ohu gị. Lee, anyị bụkwa ndị ohu onyenwe m. Anyị onwe anyị, tinyekwara onye a chọtara iko ahụ nʼaka ya.” ");
INSERT INTO ibo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Josef sịrị, “Ọ ga-abụrụ m ajọ omume ime ihe dị otu ahụ. Naanị nwoke ahụ a chọpụtara iko ahụ nʼakpa ya bụ onye ga-abụ ohu m. Ma unu onwe unu nwere ike laa nʼudo jekwuru nna unu nʼudo.” ");
INSERT INTO ibo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda jekwuuru ya, sị, “Biko, onyenwe m, kwere ka ohu gị gwa gị okwu. Ewesola mụ bụ ohu gị iwe nʼihi na ị nọ ọnọdụ dị ka Fero. ");
INSERT INTO ibo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Onyenwe m, ọ bụ gị jụrụ ndị ohu gị ajụjụ sị, ‘Unu nwere nna maọbụ nwanne?’ ");
INSERT INTO ibo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Anyị zara sị, ‘Anyị nwere nna onye bụ agadi, na otu nwa nwoke ọ mụtara nʼagadi ya. Nwanne nwantakịrị nwoke a anwụọla, ya mere naanị otu a fọdụrụ nʼime ụmụ nke nne ha mụtara. Nna ya hụkwara ya nʼanya.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Mgbe ahụ, ị sị ndị ohu gị, ‘Kpọta nwantakịrị a ka m hụ ya anya.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ma anyị gwara onyenwe m sị na ‘Nwata a apụghị ịhapụ nna ya, nʼihi na nna ya ga-anwụ ma ọ bụrụ na ọ hapụ ya.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma ị gwara ndị ohu gị sị, ‘Unu agaghị ahụ ihu m anya ọzọ, ma ọ bụrụ na nwanne unu a esoghị unu gbadata.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mgbe anyị lakwuuru ohu gị bụ nna anyị, anyị gwara ya okwu onyenwe m kwuru. ");
INSERT INTO ibo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Mgbe nna anyị gwara anyị sị, ‘Laghachi gaa zụta nri,’ ");
INSERT INTO ibo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","anyị gwara ya na, ‘Anyị agaghị agbada ma ọ bụrụ na nwanne anyị nta agaghị eso anyị. Nʼihi na anyị enweghị ike ịhụ nwoke ahụ anya, ma ọ bụrụ na nwanne anyị nta esoghị anyị.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Oge ahụ, ohu gị bụ nna anyị sịrị anyị, ‘Unu maara na nwunye m mụụrụ m ụmụ nwoke abụọ. ");
INSERT INTO ibo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Otu nʼime ha funarịrị m, mgbe anụ ọhịa dọkasịrị ya iperipe na iperipe. Ruo ugbu a, ahụbeghị m ya anya. ");
INSERT INTO ibo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ọ bụrụ na unu anapụkwa m onye nke a, si otu a mee ka ihe ọjọọ zute ya, ọ pụtara na unu ga-eme ka m jiri isi awọ m laa nʼili nʼọnọdụ obi ọjọọ?’ ");
INSERT INTO ibo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ya mere, ọ bụrụ na m alaghachikwute ohu gị, bụ nna anyị, ma nwantakịrị a esoghị anyị, ebe ọ bụ na e kekọtara ndụ nna anyị na ndụ nwantakịrị a, ");
INSERT INTO ibo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","mgbe ọ ga-ahụ na nwantakịrị a esoghị anyị, ọ ga-anwụ. Mgbe ahụ, anyị bụ ndị ohu gị, ga-eme ka nna anyị jiri isi awọ laa nʼili nʼọnọdụ obi ọjọọ. ");
INSERT INTO ibo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Biko, onyenwe m, eji m ndụ m zọọrọ nna m ebe na m ga-elezi nwantakịrị a anya. Asị m ya, ‘Ọ bụrụ na m akpọghachighị nwantakịrị a nye gị, ka ịta ụta bụrụ nke m nʼihu gị bụ nna m nʼụbọchị niile nke ndu m.’ ");
INSERT INTO ibo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ya mere ugbu a, biko, ka ohu gị nọdụ dịka ohu onyenwe m nʼọnọdụ nwantakịrị a, ka nwantakịrị a soro ụmụnne ya laghachikwuru nna anyị. ");
INSERT INTO ibo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Aga m esi aṅaa laghachikwuru nna m ma ọ bụrụ na mụ na nwantakịrị a esoghị? Enweghị m ike ilekwasị ihe ọjọọ ga-adakwasị nna m anya.” ");
INSERT INTO ibo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nʼoge a, Josef enwekwaghị ike ijite onwe ya aka nʼihu ndị na-ejere ya ozi. O welitara olu sị, “Zipụnụ onye ọbụla site nʼebe m nọ.” Ya mere, o nweghị onye ya na Josef nọ mgbe ọ kọọrọ ụmụnne ya onye ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","O tiri mkpu akwa nke ndị Ijipt nụrụ, na nke ndị ụlọ Fero nụkwara. ");
INSERT INTO ibo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josef gwara ụmụnne ya sị, “Mụ onwe m bụ Josef. Nna m ọ ka nọ ndụ ugbu a?” Ma ụmụnne ya enweghị ọnụ ha ji asa ya, nʼihi na oke egwu jidere ha nʼihu ya. ");
INSERT INTO ibo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mgbe ahụ, Josef sịrị ụmụnne ya, “Biko, bịanụ m nso.” Mgbe ha bịara ya nso, ọ sịrị ha, “Abụ m nwanne unu, Josef, onye unu rere ree gaa Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma otu ọ dị, ka ọ ghara iwute unu, unu atakwala onwe unu ụta nʼihi orure unu rere m. Nʼihi na ọ bụ nʼihi ichebe ndụ unu ka Chineke ji buru ụzọ zite m nʼebe a. ");
INSERT INTO ibo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Oge ụnwụ agwụchabeghị. Ọ bụ ezie na afọ abụọ nke oke ụnwụ agafeela, ma ọ fọdụrụ afọ ise ọzọ nʼihu, oge a na-agaghị akọ ihe ọbụla nʼala, maọbụ iwere ihe ọbụla nʼubi. ");
INSERT INTO ibo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Chineke zitere m ka m buru ụzọ bịa nʼebe a nʼihi ime ka ndụ fọdụrụ unu nʼụwa, na ịzọpụta ndụ unu site nʼụzọ nnapụta dị oke egwu. ");
INSERT INTO ibo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ya mere, ọ bụghị unu zitere m nʼebe a, kama ọ bụ Chineke. Ya onwe ya emeela ka m ghọọrọ Fero nna, na onyeisi ezinaụlọ ya niile, na onye na-achị ala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ugbu a, meenụ ngwa lakwuru nna m, sị ya, ‘Ihe ndị a ka Josef nwa gị nwoke kwuru, Chineke emeela m onye na-achị Ijipt niile. Egbula oge ịbịakwute m. ");
INSERT INTO ibo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ị ga-ebi nʼala Goshen, ka i nwee ike ịnọ m nso, gị na ụmụ gị, na ụmụ ụmụ gị, na igwe ewu na atụrụ gị, na igwe ehi gị, na ihe niile i nwere. ");
INSERT INTO ibo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nʼebe ahụ ka m ga-enyekwa gị ihe ị chọrọ, nʼihi na ụnwụ afọ ise ka dị nʼihu na-abịa. Ọ bụrụ na i meghị otu a, gị na ezinaụlọ gị na ihe niile bụ nke gị ga-ada ụkpa.’ ");
INSERT INTO ibo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nʼezie, anya unu na nʼanya nwanne m Benjamin, ahụla na mụ onwe m ji ọnụ m na-agwa unu okwu ndị a. ");
INSERT INTO ibo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Unu ga-akọrọ nna m maka nsọpụrụ niile a na-enye m nʼala Ijipt na ihe niile unu hụrụ. Kpọtakwanụ nna m ọsịịsọ ebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ugbu a, ọ dakwasịrị nʼolu Benjamin, nwanne ya, kwaa akwa. Benjamin jidekwara ya nʼolu kwaa akwa. ");
INSERT INTO ibo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Emesịa, o suturu ụmụnne ya niile ọnụ, bekwasịkwa ha akwa. Nʼikpeazụ, ụmụnne ya kpanyeere ya ụka. ");
INSERT INTO ibo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mgbe akụkọ a ruru ụlọ Fero na ụmụnne Josef bịara, ọ tọrọ Fero na ndịisi ozi niile ya ụtọ. ");
INSERT INTO ibo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fero gwara Josef sị ya, “Gwa ụmụnne gị, ka ha mee ihe otu a, ha bokwasị ịnyịnya ibu unu ibu laghachikwa nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ha ruo, ha kpọta nna gị, na ezinaụlọ ha, ka ha lọghachikwute m nʼala Ijipt. Nʼihi na aga m enye ha ala kachasị mma nʼIjipt. Ha onwe ha ga-erikwa uru ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Gwakwa ụmụnne gị okwu sị ha, ‘Sitenụ nʼala Ijipt were ụgbọala, nke unu ga-eji budata ndị nwunye unu na ụmụntakịrị unu. Dutekwanụ nna unu. ");
INSERT INTO ibo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Unu esogbula onwe unu banyere ngwa ụlọ unu, nʼihi na ihe niile dị mma nʼala Ijipt bụ nke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ya mere ụmụ Izrel mere ihe ndị a. Josef nyere ha ụgbọala dịka Fero nyere nʼiwu. O nyekwara ha nri ha ga-eri nʼụzọ. ");
INSERT INTO ibo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","O nyere onye ọ bụla nʼime ha uwe mgbanwe ọhụrụ, ma o nyere Benjamin narị shekel ọlaọcha atọ, na uwe mgbanwe ise. ");
INSERT INTO ibo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","O zipụụrụ nna ya ihe ndị a: ịnyịnya ibu iri ndị e bokwasịrị ihe mara mma niile si nʼala Ijipt, na nne ịnyịnya ibu iri ndị e bokwasịrị ọka na achịcha, na ihe ndị ọzọ dị iche iche, nʼihi ije ya. ");
INSERT INTO ibo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","O zipụrụ ụmụnne ya. Ma oge ha na-achọ ịhapụ ya, ọ gwara ha sị, “Unu esekwala okwu nʼụzọ.” ");
INSERT INTO ibo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mgbe ahụ, ha hapụrụ ala Ijipt mechaa rute ala Kenan, bịakwute Jekọb nna ha. ");
INSERT INTO ibo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ha gwara ya sị, “Josef ka nọ ndụ. Nʼezie, ọ bụ ya na-achị ala Ijipt niile.” Ma o siiri Jekọb ike ịnabata akụkọ a. O kwenyeghị na ọ bụ eziokwu. ");
INSERT INTO ibo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ma mgbe ha gwasịrị ya ihe niile Josef gwara ha, mgbe ọ hụkwara ụgbọala niile Josef zitere ka e jiri bute ya, mmụọ nna ha Jekọb lọghachiri. ");
INSERT INTO ibo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Mgbe ahụ Izrel kwuru sị, “Ekwetala m! Josef nwa m ka dị ndụ. Aga m aga hụ ya anya tupu m nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izrel biliri ije, ya na ihe niile o nwere rute Bịasheba. Ebe a, ọ chụrụ aja nye Chineke nke nna ya Aịzik. ");
INSERT INTO ibo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Chineke gwara Izrel okwu nʼọhụ nke abalị. Ọ sịrị, “Jekọb! Jekọb!” Ọ zara sị, “Lee m nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Chineke gwara ya sị, “Abụ m Chineke, Chineke nke nna gị. Atụla egwu ịgbada Ijipt nʼihi na aga m eme gị ka ị ghọọ mba dị ukwuu nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mụ onwe m ga-eso gị agbada nʼala Ijipt. Mụ onwe m ga-akpọlatakwa gị ọzọ. Josef nʼonwe ya ga-eji aka ya ekpuchikwa gị anya.” ");
INSERT INTO ibo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jekọb mechara si na Bịasheba pụta. Ụmụ Izrel kuuru Jekọb nna ha, na ụmụaka ha na ndị nwunye ha, kubanye nʼụgbọala ahụ Fero zitere ka ha ji bute ya. ");
INSERT INTO ibo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ha buuru anụ ụlọ ha niile, na ihe onwunwe ha niile, nke ha kpatara nʼala Kenan, gaa Ijipt. Jekọb na agbụrụ ya niile so. ");
INSERT INTO ibo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ụmụ ya ndị ikom niile, na ụmụ ụmụ ya ndị ikom niile, na ụmụ ya ndị inyom niile, na ụmụ ụmụ ya ndị inyom niile, na ndị niile bụ mkpụrụ afọ ya, ka ọ kpọrọ gaa Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ndị a bụ aha ụmụ ndị ikom Izrel, ya bụ Jekọb na ụmụ ụmụ ya, ndị sooro ya gaa Ijipt. Ruben, ọkpara Jekọb ");
INSERT INTO ibo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ụmụ ndị ikom Ruben bụ, Hanok, na Palu, na Hezrọn na Kami. ");
INSERT INTO ibo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ụmụ ndị ikom Simiọn bụ, Jemuel, na Jamin, na Ohad, na Jakin, na Zoha, na Shaul. Nne Shaul bụ nwanyị Kenan. ");
INSERT INTO ibo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ụmụ ndị ikom Livayị bụ, Geshọn, na Kohat, na Merari. ");
INSERT INTO ibo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ụmụ ndị ikom Juda bụ, Ịa, na Onan, na Shela, na Perez, na Zera. Ma Ịa na Onan nwụrụ nʼala Kenan. Ụmụ ndị ikom Perez bụ, Hezrọn na Hamul. ");
INSERT INTO ibo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ma ụmụ ndị ikom Isaka bụ, Tola, na Puva, na Jashub, na Shịmrọn. ");
INSERT INTO ibo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ụmụ ndị ikom Zebụlọn bụ, Sered, na Elọn, na Jaliil. ");
INSERT INTO ibo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ndị a bụ ụmụ ndị ikom Lịa mụụrụ Jekọb nʼala Padan Aram. Ọ mụtakwara otu nwanyị aha ya bụ Daịna. Ụmụ ndị ikom na ndị inyom ndị a dị iri atọ na atọ. ");
INSERT INTO ibo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ụmụ ndị ikom Gad bụ, Zefọn, na Hagi, na Shuni, na Ezbon, na Eri, na Arodi na Areli. ");
INSERT INTO ibo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ụmụ ndị ikom Asha bụ, Imna, Ishva, Ishvi na Beriya. Nwanne ha nwanyị bụ Sera. Ụmụ Beriya bụ, Heba na Malkiel. ");
INSERT INTO ibo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ndị a bụ ụmụ a mụụrụ Jekọb site na Zilpa, odibo nwanyị ahụ Leban kpọnyere Lịa nwa ya nwanyị. Ha dị iri na isii nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ụmụ ndị ikom Jekọb site na Rechel nwunye ya bụ, Josef na Benjamin. ");
INSERT INTO ibo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nʼala Ijipt, a mụụrụ Josef Manase na Ifrem, site na nwunye ya Asenat nwa nwanyị Pọtifera, onye nchụaja nke On. ");
INSERT INTO ibo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ụmụ ndị ikom Benjamin bụ, Bela, Beka, Ashbel, Gera, Neeman, Ehi, Rosh, Mupim, Hupim na Aad. ");
INSERT INTO ibo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ndị a bụ ndị ikom nke Rechel mụụrụ Jekọb. Ha dị iri na anọ. ");
INSERT INTO ibo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nwa nwoke nke Dan mụrụ bụ, Hushim. ");
INSERT INTO ibo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ụmụ ndị ikom Naftalị bụ, Jaziil, na Guni, na Jeza, na Shilem. ");
INSERT INTO ibo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ndị a bụ ụmụ ndị ikom a mụụrụ Jekọb site na Bilha, odibo nwanyị ahụ Leban kpọnyere nwa ya nwanyị Rechel. Ha niile dị asaa. ");
INSERT INTO ibo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ya mere, ndị niile so Jekọb gaa Ijipt, ndị bụ ụmụ ụmụ ya, na-agụghị ndị nwunye ụmụ Jekọb niile, dị iri mmadụ isii na isii. ");
INSERT INTO ibo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tinyere ụmụ ndị ikom abụọ amụtara nye Josef nʼIjipt, ndị si nʼezinaụlọ Jekọb gara Ijipt dị iri asaa. ");
INSERT INTO ibo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jekọb zipụrụ Juda ka jekwuru Josef ịjụta ya ụzọ Goshen. Mgbe ha rutere nʼala Goshen, ");
INSERT INTO ibo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef kwadoro ịnyịnya ụgbọ ya gawa Goshen izute nna ya Izrel. Mgbe Josef bịara nʼihu nna ya, ọ makụrụ ya, bee akwa ogologo oge. ");
INSERT INTO ibo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izrel gwara Josef sị, “Ugbu a ejikerela m ịnwụ, ebe m hụrụ ihu gị anya ọzọ, mata na ị ka dị ndụ.” ");
INSERT INTO ibo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mgbe ahụ, Josef gwara ụmụnne ya na ndị ezinaụlọ nna ya niile sị, “Ka m gaa kọọrọ Fero. Ka m gaa sị ya, ‘Ụmụnne m na ezinaụlọ nna m, ndị bi nʼala Kenan abịakwutela m. ");
INSERT INTO ibo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ha bụ ndị ọzụzụ atụrụ, ndị na-elekọta anụ ụlọ. Ha chị igwe ewu na atụrụ ha, na igwe ehi ha, na ihe niile ha ji biri.’ ");
INSERT INTO ibo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ya mere, ọ bụrụ na Fero akpọ unu jụọ unu ajụjụ sị, ‘Gịnị bụ ọrụ aka unu?’ ");
INSERT INTO ibo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Unu ga-asị ya, ‘Ndị ohu gị bụ ndị ọzụzụ anụ ụlọ site na mgbe anyị bụ ụmụnta, dịka nna nna anyị ha bụ.’ Mgbe ahụ, ọ ga-ekwe ka unu biri nʼala Goshen. Nʼihi na ndị niile na-azụ ewu na atụrụ bụ ndị akpọrọ asị nʼala Ijipt.” ");
INSERT INTO ibo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josef gara gwa Fero sị, “Nna m na ụmụnne m ejirila igwe ewu na atụrụ ha, igwe ehi ha na ihe niile ha nwere site nʼala Kenan bịa nʼebe a. Ha nọ nʼala Goshen.” ");
INSERT INTO ibo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Mgbe ọ gara ịgwa Fero okwu, o duuru mmadụ ise nʼetiti ụmụnne ya ndị ikom gosi ha Fero. ");
INSERT INTO ibo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fero jụrụ ụmụnne ya ajụjụ sị ha, “Gịnị bụ ọrụ aka unu?” Ha zara sị ya, “Ndị ohu gị bụ ndị ọzụzụ atụrụ dịka nna nna anyị ha.” ");
INSERT INTO ibo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ha kwukwara sị, “Anyị bịara ịnọ dịka ọbịa nʼala a nʼihi na ụnwụ a siri oke ike nʼala Kenan. O nweghị nri igwe ewu na atụrụ anyị nwere iri nʼala ahụ. Ya mere, anyị na-arịọ ka i nye ndị ohu gị ike ka ha biri nʼala Goshen.” ");
INSERT INTO ibo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fero gwara Josef sị, “Nna gị na ụmụnne gị abịakwutela gị. Ha biri nʼala Goshen. ");
INSERT INTO ibo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ala Ijipt dịkwa gị nʼihu. Họrọ ebe ọbụla masịrị gị nke dịkwa ezi mma nye nna gị na ụmụnne gị ka ha biri. Ka ha biri na Goshen. Ọ bụrụkwa na ị maara ndị ikom nʼetiti ha ndị nwere ike, mee ha ndị na-elekọta igwe anụ ụlọ m.” ");
INSERT INTO ibo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Josef kpọtara nna ya Jekọb, mee ka o guzo nʼihu Fero. Jekọb nọ nʼebe ahụ gọzie Fero. ");
INSERT INTO ibo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fero jụrụ Jekọb sị, “Ị gbaala afọ ole ugbu a?” ");
INSERT INTO ibo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jekọb zara Fero sị ya: “Ebiela m dịka onye ọbịa narị afọ na iri afọ atọ. Ọnụọgụgụ afọ ndị a ehighị nne, ma ha jupụtara nʼahụhụ na nsogbu. Ma a nọrubeghị m ọnụọgụgụ afọ nna m ha gbara mgbe ha biri nʼụwa dịka ọbịa.” ");
INSERT INTO ibo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jekọb gọziri Fero, site nʼihu ya pụọ. ");
INSERT INTO ibo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ya mere, Josef mere ka nna ya na ụmụnne ya biri nʼala Ijipt. O nyere ha ala kachasị mma nʼala ahụ na mpaghara Ramesis, dịka Fero nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josef nyere nna ya na ụmụnne ya na ezinaụlọ nna ya nri dịka ọnụọgụgụ nke ụmụ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ma nri adịghị nʼala ahụ niile nʼihi na ụnwụ ahụ dị nnọọ njọ. Ihe siri ike nʼala Ijipt ma nʼala Kenan nʼihi ụnwụ a. ");
INSERT INTO ibo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josef chịkọtara ego niile dị nʼala Ijipt, na nʼala Kenan, nke ndị mmadụ ji kwụọ ụgwọ nri ha zụrụ webata ha nʼụlọeze Fero. ");
INSERT INTO ibo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mgbe ego niile dị ndị mmadụ nʼaka gwụchara nʼala Ijipt ma nʼala Kenan, ndị Ijipt niile bịakwutere Josef sị ya, “Nye anyị nri, gịnị mere anyị ga-eji nwụọ nʼihu gị? Ego anyị agwụla.” ");
INSERT INTO ibo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Mgbe ahụ Josef zara sị ha: “Jirinụ anụ ụlọ unu kwụọ ụgwọ nri m ga-enye unu, ebe ọ bụ na ego unu agwụla.” ");
INSERT INTO ibo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ya mere, ha kpụtaara Josef anụ ụlọ ha. Josef nyere ha nri nʼọnọdụ ịnyịnya ha, na atụrụ ha, na ewu ha, na ehi, na ịnyịnya ibu ha. O were nri zụọ ha nʼafọ ahụ nʼọnọdụ anụ ụlọ ha niile. ");
INSERT INTO ibo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mgbe afọ ahụ gafesịrị, ha bịakwutekwara ya nʼafọ nke ọzọ sị ya, “Anyị agaghị ezoro onyenwe anyị na ego anyị agwụla, na igwe anụ ụlọ anyị bụkwa nke gị. O nweghị ihe ọzọ fọdụrụ anyị karịa ahụ anyị na ala anyị. ");
INSERT INTO ibo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Gịnị mere anyị ga-eji nọọ nʼagụụ nʼihu gị? Zụrụ anyị na ala anyị nʼọnọdụ ụgwọ anyị ga-akwụ maka nri ị ga-enye anyị. Ka anyị na ala anyị bụrụ ndị ohu Fero. Nye anyị mkpụrụ ubi ka anyị dịrị ndụ ghara ịnwụ, ka ala a ghara ịbụ ihe tọgbọrọ nʼefu.” ");
INSERT INTO ibo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ya mere, Josef zụtaara Fero ala Ijipt niile. Ndị Ijipt niile nʼotu nʼotu rere ala ha nʼihi oke ụnwụ ahụ dakwasịrị ha. Mgbe ahụ, ala ha niile ghọrọ nke Fero. ");
INSERT INTO ibo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ya mere, Josef si otu a mee ka ndị Ijipt niile ghọọ ndị ohu Fero, site nʼotu obodo nʼala ahụ ruo na nke ọzọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ala nke Josef na-azụtaghị nʼoge a bụ naanị ala ndị nchụaja. Nʼihi na ndị nchụaja si nʼaka Fero na-enweta nri ha site nʼoge ruo nʼoge. Ha nwekwara nri na-ezuru ha site na oke ahụ Fero na-enye ha. Ya mere ha ereghị ala ha. ");
INSERT INTO ibo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Mgbe ahụ, Josef gwara ndị mmadụ ahụ niile okwu sị, “Lee, azụọla unu taa, zụkwaa a ala unu nye Fero. ");
INSERT INTO ibo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nʼoge owuwe ihe ubi, otu ụzọ nʼime ụzọ ise nke ihe unu nwetara nʼubi unu bụ nke Fero. Deberenụ onwe unu ụzọ anọ fọdụrụ ka ọ bụrụ ihe unu ga-akụ nʼubi na ihe unu ga-eri na ihe ndị ezinaụlọ unu, na nke ụmụntakịrị unu ga-eri.” ");
INSERT INTO ibo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ha zara sị ya, “Ị zọpụtala ndụ anyị. Ka anyị hụta amara nʼihu nna anyị ukwu. Anyị ga-abụ ndị ohu Fero.” ");
INSERT INTO ibo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josef mere ka nke a bụrụ iwu nʼala Ijipt niile ruo taa, na Fero ga-ewe otu ụzọ nʼime ụzọ ise nke ihe ọbụla si nʼala. Naanị ihe si nʼala ndị nchụaja bụ nke na-esoghị nʼiwu a. ");
INSERT INTO ibo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izrel biri na Goshen nke dị nʼala Ijipt. Ha kpatara akụ hie nne, mụbaa nʼọmụmụ, ma nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekọb biri nʼala Ijipt afọ iri na asaa. Ya mere, afọ niile Jekọb gbara bụ narị afọ na iri afọ anọ na asaa. ");
INSERT INTO ibo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mgbe ụbọchị ọnwụ Izrel na-abịaru nso, ọ kpọrọ Josef nwa ya sị ya, “Ọ bụrụ na m ahụtala amara nʼihu gị, tinye aka gị nʼokpuru apata m, kwee m nkwa na ị ga-egosi m obi ebere na ezi ntụkwasị obi. Elila m nʼala nʼIjipt. ");
INSERT INTO ibo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kama, mgbe m nwụrụ, site nʼala Ijipt bupụ m. Buru ozu m gaa lie ya ebe e liri nna m ha.” Ọ zara, “Aga m eme dịka i kwuru.” ");
INSERT INTO ibo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ọ sịrị ya, “Ṅụọrọ m iyi na ị ga-eme ya.” Josef ṅụọrọ ya iyi. Izrel nʼonwe ya, kpọrọ isiala dịka ọ dabere nʼelu mkpanaka ya. ");
INSERT INTO ibo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mgbe ihe ndị a gasịrị, a gwara Josef sị, “Lee nna gị na-arịa ọrịa.” Josef biliri duru ụmụ ya ndị ikom abụọ bụ Manase na Ifrem gawa ileta ya. ");
INSERT INTO ibo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mgbe a gwara Jekọb okwu sị ya, “Nwa gị nwoke Josef abịala ileta gị.” Izrel chịkọtara ume ya, jisie ike, nọdụ ala nʼelu akwa ya. ");
INSERT INTO ibo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Mgbe ahụ, Jekọb sịrị Josef, “Chineke, Onye pụrụ ime ihe niile gosiri m onwe ya na Luz, nʼala Kenan, ma gọziekwa m. ");
INSERT INTO ibo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ọ sịrị m, ‘Lee, aga m eme ka ị mịa mkpụrụ, baakwa ụba nʼọnụọgụgụ. Aga m eme ka ị ghọọ ọgbakọ ọtụtụ mba. Aga m enye gị ala a ka ọ bụrụ ihe nketa ebighị ebi maka agbụrụ gị ndị ga-esote gị.’ ");
INSERT INTO ibo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ugbu a, ana m eme ụmụ gị ndị ikom abụọ ndị a, ndị a mụtaara gị nʼala Ijipt, ụmụ nke m. Ha abụọ, Ifrem na Manase, ga-abụ ụmụ m, dịka Ruben na Simiọn si bụrụ ụmụ m. ");
INSERT INTO ibo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma ụmụ ọzọ a ga-amụtara gị ga-abụ nke gị. Ọ bụ aha ụmụnne ha ndị a ka a ga-eji mara ha nʼala nketa nke ha. ");
INSERT INTO ibo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ana m eme nke a nʼihi na mgbe m si Padan Aram pụta, nne unu Rechel, nwụrụ nʼala Kenan mgbe anyị ka nọ nʼụzọ ije anyị nʼebe dịtụ anya site na Efrat. Nʼakụkụ ụzọ e si aga Efrat, ya bụ Betlehem, ka m likwara ya.” ");
INSERT INTO ibo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mgbe Izrel hụrụ ụmụ ndị ikom abụọ Josef kpọ bịa, ọ jụrụ Josef ajụjụ sị, “Ndị a, bụ ndị ole?” ");
INSERT INTO ibo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef zara nna ya sị, “Ha bụ ụmụ ndị ikom ndị Chineke nyere m nʼebe a.” Ya mere, Jekọb gwara ya sị, “Kpọtara m ha, ka m gọzie ha.” ");
INSERT INTO ibo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Nʼoge a, Izrel adịghị ahụzikwa ụzọ nke ọma nʼihi ime agadi ya. Ya mere, Josef duuru ụmụ ya ndị ikom ndị ahụ bịa nso ebe nna ya nọ. Mgbe ahụ, Jekọb suturu ha ọnụ, makụọ ha. ");
INSERT INTO ibo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izrel sịrị Josef, “O nweghị mgbe m lere anya na m ga-ahụ ihu gị ọzọ. Ma Chineke emeela ka m hụkwa ụmụ gị.” ");
INSERT INTO ibo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Josef sitere nʼikpere Jekọb kupu ụmụ ya, bịa hulata isi ala. O kpuru ihu ya nʼala mgbe o mere nke a. ");
INSERT INTO ibo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josef kpọọrọ ha abụọ, Ifrem nʼaka nri ya nke bụ aka ekpe Izrel, na Manase nʼaka ekpe ya nke bụ aka nri Izrel, kpọta ha bịa nna ya nso. ");
INSERT INTO ibo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma Izrel setịrị aka nri bikwasị ya nʼisi Ifrem, nwa nke nta. Ma aka ekpe ya ka o setịpụrụ bikwasị nʼisi Manase bụ ọkpara. ");
INSERT INTO ibo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Mgbe ahụ, ọ gọziri Josef sị ya. “Ka Chineke, onye nna m ha Ebraham na Aịzik jere ije nʼihu ya Chineke onye bụrịị Onye zụrụ m dịka atụrụ ogologo ndụ m niile ruo taa, ");
INSERT INTO ibo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mmụọ ozi ahụ napụtara m site nʼihe egwu niile, ya gọzie ụmụ ndị ikom ndị a. Ka ha bụrụ ndị a kpọkwasịrị aha m na aha nna m ha Ebraham na Aịzik, ka ha mụbaa hie nne nʼelu ụwa.” ");
INSERT INTO ibo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","O wutere Josef mgbe ọ hụrụ na nna ya bikwasịrị aka nri ya nʼisi Ifrem. O jidere aka nna ya iwepụ ya nʼisi Ifrem, ka ọ tụkwasị ya nʼisi Manase. ");
INSERT INTO ibo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Mgbe ahụ, Josef sịrị nna ya, “I bikwasịjọrọ aka gị. Onye a bụ ọkpara, bikwasị aka nri gị nʼisi ya.” ");
INSERT INTO ibo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma nna ya jụrụ, sị ya, “Amaara m ihe m na-eme nwa m, Manase ga-aghọ oke obodo, ma nwanne ya nke nta ga-akarị ya ịdị ukwuu, nʼihi na ụmụ ụmụ ya ga-aghọ ọtụtụ mba dị iche iche.” ");
INSERT INTO ibo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ọ gọziri ha nʼụbọchị ahụ sị, “Nʼaha gị ka Izrel ga-ekwupụta ngọzị a, ‘Ka Chineke mee gị dịka Ifrem na Manase.’ ” Ya mere o buru ụzọ kpọọ Ifrem tupu Manase. ");
INSERT INTO ibo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mgbe ahụ, Izrel gwara Josef okwu sị ya, “Lee, mụ onwe m na-aga ịnwụ. Ma Chineke ga-anọnyere unu, kpọghachikwa unu azụ nʼala nna unu ha. ");
INSERT INTO ibo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mụ onwe m na-enye gị otu akụkụ ugwu karịa nke ụmụnne gị, bụ ala ugwu ahụ m sitere na mma agha m na ụta m napụta ndị Amọrait ka ọ bụrụ nke gị.” ");
INSERT INTO ibo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Mgbe ahụ, Jekọb kpọkọtara ụmụ ya ndị ikom niile nʼotu sị ha, “Zukọọnụ ka m gwa unu ihe ga-adakwasị unu nʼụbọchị dị nʼihu. ");
INSERT INTO ibo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Zukọọnụ nụrụ, ụmụ ndị ikom Jekọb nụrụ okwu nna unu Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, ọkpara m ka ị bụ, ume m, ihe ngosi mbụ nke ike m, onye nsọpụrụ kwesiri, onye mbụ nʼịdị ike. ");
INSERT INTO ibo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Onye na-agbanwe agbanwe dịka mmiri dị nʼiyi, ị gaghị abụkwa onye mbụ, nʼihi na ị banyere nʼihe ndina nna gị, i dinara nʼihe ndina m, merụọ ya. ");
INSERT INTO ibo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simiọn na Livayị bụ ụmụnne. Mma agha ha bụ ngwa ihe ike. ");
INSERT INTO ibo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ka obi m ghara isonye nʼizuzu ha, ka m ghara isonye nʼọgbakọ ha, nʼihi na ha gburu mmadụ nʼoge iwe ha, bipụkwa nkwonkwo ụkwụ ụmụ ehi na-echeghị echiche. ");
INSERT INTO ibo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ihe a bụrụ ọnụ ka iwe ha bụ, nʼihi na ọ dị njọ. Ọnụma ha, ọ jọbigara njọ oke. Aga m ekesa ha nʼetiti ụmụ Jekọb Kpasaa ha nʼetiti ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Gị, Juda, ụmụnne gị ga-eto gị. Aka gị ga-adị nʼolu ndị iro gị. Ụmụ ndị ikom nna gị ga-akpọ isiala nye gị. ");
INSERT INTO ibo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ị bụ nwa ọdụm, gị, Juda, i si nʼịchụ nta lọta, nwa m. Dịka ọdụm, ọ na-amakpu, na-edina ala, dịka nne ọdụm, onye ga-anwa anwa kpọtee ya? ");
INSERT INTO ibo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mkpanaka eze agaghị esite nʼebe Juda nọ wezuga onwe ya, maọbụ mkpanaka onyendu esi nʼagbata ụkwụ ya pụọ, tutuu ruo mgbe eze ahụ nwe ya ga-abịa, irube isi nke mba niile ga-abụ nke ya. ");
INSERT INTO ibo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ọ ga-ekenye ịnyịnya ibu ya nʼosisi vaịnị, nʼalaka kachasị mma ka ọ ga-ekenye nwa ịnyịnya ibu ya. Ọ ga-asakwa uwe ya na mmanya. Uwe mwụda ya ka ọ ga-asụkwa nʼọbara mkpụrụ vaịnị. ");
INSERT INTO ibo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Anya ya ga-acha uhie uhie karịa mmanya vaịnị. Eze ya ga-enwupụkwa ọcha karịa mmiri ara ehi. ");
INSERT INTO ibo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebụlọn ga-ebi nʼakụkụ osimiri. Ọ ga-abụ ebe izuike nye ụgbọ mmiri. Oke ala ya ga-agbatịpụ ruo Saịdọn. ");
INSERT INTO ibo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaka dị ike dịka ịnyịnya ibu na-amakpu nʼetiti ọgba atụrụ. ");
INSERT INTO ibo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mgbe ọ hụrụ otu ebe izuike ya si dị mma, hụ otu ala ya si maa mma, ọ ga-ehudata isi ya ibu ibu arụ; were onwe ya nye ịrụ ọrụ ike. ");
INSERT INTO ibo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan ga-eme ka ikpe ziri ezi rute ndị ya aka dịka otu nʼime ebo Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ga-adị ka agwọ dị nʼakụkụ okporoụzọ, dịka ajụala dị nʼụzọ ọhịa, nke na-ata ịnyịnya nʼikiri ụkwụ, si otu a mee ka onye na-agba ịnyịnya dalaa azụ. ");
INSERT INTO ibo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Onyenwe anyị, ana m ele anya nnapụta gị. ");
INSERT INTO ibo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad bụ onye usuu ndị o-ji-egbe-aga ga-abịakwasị, ma ọ ga-alụso ha ọgụ, chụọkwa ha ọsọ. ");
INSERT INTO ibo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asha ga-esi nʼubi ya wepụta nri gbara abụba, nke na-adị ndị eze mma. ");
INSERT INTO ibo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftalị dịka nne ele a hapụrụ ahapụ, nke na-amụpụta ụmụ ele mara mma. ");
INSERT INTO ibo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Dịka osisi vaịnị a kụrụ nʼakụkụ iyi, nke alaka ya na-awasa rigoro nʼelu mgbidi, na nke na-amị ezi mkpụrụ, otu a ka Josef dị. ");
INSERT INTO ibo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ndị na-agbata ụta sitere nʼobi ilu lụso ya agha, ha gbara ya àkụ site nʼịkpọ asị. ");
INSERT INTO ibo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ma aka o ji jide ụta nke ya adaghị mba, ike agwụghị ogwe aka ya, nʼihi aka Onye dị ike nke Jekọb, nʼihi Onye ọzụzụ atụrụ, Oke Nkume Izrel, ");
INSERT INTO ibo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nʼihi Chineke nna gị, onye na-enyere gị aka, nʼihi Onye pụrụ ime ihe niile, ka ọ gọzie gị, site na ngọzị nke eluigwe site nʼelu, ngọzị nke osimiri dị nʼokpuru ala, ngọzị nke ara na akpanwa. ");
INSERT INTO ibo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ngọzị niile nke nna gị, dị ukwu karịa, ngọzị niile nke ugwu ukwu mgbe ochie, karịakwa ngọzị nke ugwu nta mgbe ochie, Ka ngọzị ndị a dị iche dịkwasị nʼisi Josef, dịkwasị nʼegedege ihu Josef, onye bụ onyendu nʼetiti ụmụnne ya. ");
INSERT INTO ibo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin dịka nkịta ọhịa nke na-adọgbu anụ. Nʼụtụtụ, ọ na-eri anụ ọ dọgburu. Nʼanyasị ọ na-ekesakwa ihe o gbutere.” ");
INSERT INTO ibo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ndị a bụ ebo iri na abụọ dị nʼIzrel. Ihe ndị a bụkwa ihe nna ha gwara ha mgbe ọ gọziri ha, nye onye ọbụla nʼime ha ngọzị nke ruuru ya. ");
INSERT INTO ibo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Emesịa, o nyere ha ndụmọdụ sị ha, “Nʼoge na-adịghị anya site ugbu a, aga m anwụ. Unu aghaghị ili m nʼebe e liri nna m ha, nʼala Kenan, nʼime ọgba ahụ dị nʼọhịa Efrọn, onye Het. ");
INSERT INTO ibo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Nʼime ọgba dị nʼọhịa Makipela, nke dị nso na Mamre, nʼala Kenan, ọhịa Ebraham zụtara site nʼaka Efrọn onye Het, maka ili ozu. ");
INSERT INTO ibo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nʼebe ahụ ka e liri Ebraham na Sera nwunye ya. Nʼebe ahụ kwa ka e liri Aịzik na Ribeka nwunye ya. Nʼebe ahụ ka m liri Lịa. ");
INSERT INTO ibo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ebraham nna nna m zụrụ ala ahụ na ọgba dị nʼime ya site nʼaka ụmụ Het.” ");
INSERT INTO ibo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mgbe Jekọb kwuchara okwu ndụmọdụ ikpeazụ ndị a nye ụmụ ya ndị ikom, ọ chịkọtara ụkwụ ya nʼelu akwa, kuo ume ikpeazụ. A chịkọtara ya na ndị ya. ");
INSERT INTO ibo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josef dakwasịrị nʼihu nna ya, kwaa akwa, sutukwa ya ọnụ. ");
INSERT INTO ibo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Josef nyere iwu, ka ndị dibịa na-ejere ya ozi gbasie ozu nna ya. Ya mere, ndị dibịa ahụ gbasikwara Izrel. ");
INSERT INTO ibo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","O were ha iri ụbọchị anọ ịgbasi ozu, nʼihi na nke a bụ oge o kwesiri iwe ha ime ya. Mgbe nke a gasịrị, a kwara ya nʼala Ijipt iri ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mgbe oge iru ụjụ gafesịrị, Josef gwara ndị ụlọ Fero sị ha, “Ọ bụrụ na m ahụtala amara nʼihu unu, biko, gwaranụ m Fero otu a, sị ya, ");
INSERT INTO ibo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Nna m mere ka m ṅụọra ya iyi mgbe ọ na-anwụ, sị, “Lee, agala m ịnwụ, ị ga-eli m nʼili m, nke m gwuuru onwe m nʼala Kenan.” Ugbu a, biko ka m gaa lie nna m, ma lọghachikwa.’ ” ");
INSERT INTO ibo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fero zara sị ya, “Gaa lie nna gị dịka o mere ka ị ṅụọ iyi na ị ga-eme.” ");
INSERT INTO ibo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ya mere, Josef gara ili nna ya. Ọtụtụ ndị mmadụ sokwa ya. Ndịisi ọchịchị Fero, na ndị okenye ụlọ ya, na ndị okenye a ma ama nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ndị ọzọ bụkwa ndị ụlọ Josef niile, ụmụnne ya, na ndị ụlọ nna ya. Naanị ụmụntakịrị, na igwe ewu na atụrụ ha, na igwe ehi ha, ka ha hapụrụ nʼala Goshen. ");
INSERT INTO ibo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ma ịnyịnya ụgbọ na ndị na-agba ịnyịnya, so ya gaa. Igwe mmadụ gara ije a buru ibu nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mgbe ha ruru ebe ịzọcha ọka nke Atad, nʼofe ọzọ nke Jọdan, ha weere iti aka nʼobi dị ukwuu tie aka nʼobi ha nʼebe ahụ. Josef ruru ụjụ ụbọchị asaa maka nna ya nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mgbe ndị bi nʼala Kenan hụrụ oke iru ụjụ nke ebe ịzọcha ọka nke Atad ahụ, ha sịrị, “Nke a bụụrụ ndị Ijipt iru ụjụ dị ukwuu.” Nʼihi nke a, ha kpọrọ ebe ahụ dị nso na Jọdan Ebel-Mizraim. ");
INSERT INTO ibo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ụmụ Jekọb mere dịka nna ha gwara ha. ");
INSERT INTO ibo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nʼihi na ha buuru ozu ya laa nʼala Kenan, lie ya nʼọgba ahụ dị nʼọhịa Makipela, nke bụ ala ubi Ebraham zụrụ dịka ala olili ozu, site nʼaka Efrọn, onye Het; nʼakụkụ Mamre. ");
INSERT INTO ibo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Emesịa, Josef laghachiri Ijipt ya na ụmụnne ya, na ndị niile sooro ya gaa olili ozu nna ya, ngwangwa elichara nna ya. ");
INSERT INTO ibo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mgbe ụmụnne Josef hụrụ na nna ha anwụọla, ha sịrị, “Eleghị anya Josef ga-akpọ anyị asị, kwụghachi anyị ụgwọ ihe ọjọọ niile anyị mere ya?” ");
INSERT INTO ibo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nʼihi nke a, ha zipụrụ Josef ozi sị, “Nna gị nyere iwu a tupu ọ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Gwa Josef sị ya, Arịọọ m gị, gbaghara ihe ọjọọ niile ụmụnne gị mere, na mmehie ha mere megide gị.’ Ugbu a, gbaghara mmehie anyị bụ ndị ohu Chineke nna gị.” Mgbe Josef nụrụ ihe ha kwuru, ọ kwara akwa. ");
INSERT INTO ibo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ụmụnne ya bịakwara daa nʼihu ya, sị, “Anyị bụ ndị ohu gị.” ");
INSERT INTO ibo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Josef sịrị ha, “Unu atụla egwu. Abụ m Chineke onye na-ekpe ikpe nke m ga-eji taa unu ahụhụ? ");
INSERT INTO ibo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ọ bụ ezie na unu chere ime m ihe ọjọọ, ma Chineke chere ya ka ọ bụrụ ezi ihe, iji debe ọtụtụ ndụ dịka ọ na-eme taa. ");
INSERT INTO ibo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ya mere, ụjọ atụla unu. Mụ onwe m ga-azụ unu na ụmụntakịrị unu.” Ọ kasịrị ha obi, gwa ha okwu bara ha nʼobi. ");
INSERT INTO ibo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef biri nʼIjipt, ya na ụmụnne ya, na ndị ụlọ ha. Josef gbara narị afọ na iri. ");
INSERT INTO ibo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josef hụrụ ụmụ Ifrem, na ụmụ ụmụ ya. Ọ nọkwa ndụ hụ ụmụ Makia nwa Manase, ndị e kukwasịrị nʼikpere ya. ");
INSERT INTO ibo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Mgbe ahụ, Josef sịrị ụmụnne ya, “Agala m ịnwụ, ma Chineke ga-abịa ileta unu. Ọ ga-esi nʼala a kpọpụta unu kpọgakwa unu nʼala ahụ ọ ṅụụrụ Ebraham na Aịzik na Jekọb iyi, na ọ ga-enye ha.” ");
INSERT INTO ibo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mgbe ahụ, Josef mere ka ụmụ Izrel ṅụọrọ ya iyi sị, “Mgbe Chineke bịara ileta unu, unu aghaghị ị site nʼebe a chịkọrọ ọkpụkpụ m.” ");
INSERT INTO ibo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josef nwụrụ mgbe ọ gbara narị afọ na iri. Ha gbasiri ozu ya, tinye ya nʼime igbe ozu, nʼala Ijipt.");
INSERT INTO ibo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ndị a bụ aha ụmụ ndị ikom Izrel, ndị sooro Jekọb gaa biri nʼala Ijipt, onye ọbụla nʼime ha kpọ ezinaụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simiọn, Livayị na Juda; ");
INSERT INTO ibo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zebụlọn na Benjamin; ");
INSERT INTO ibo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, na Naftalị; Gad na Asha. ");
INSERT INTO ibo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ọnụọgụgụ ụmụ Jekọb ndị sooro ya gaa biri nʼIjipt dị iri mmadụ asaa. Ma Josef nọrịị nʼIjipt. ");
INSERT INTO ibo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Emesịa, Josef na ụmụnne ya niile nwụrụ, ma ọgbọ ahụ niile nwụkwara. ");
INSERT INTO ibo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ma ihe gaara ụmụ ụmụ Izrel nke ọma, ha mụbara, dị ukwuu nʼọnụọgụgụ, jupụta ala ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ma mgbe eze ọhụrụ nke na-amaghị Josef malitere ịchị ọchịchị nʼala Ijipt, ");
INSERT INTO ibo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ọ sịrị ndị ya, “Lee, ndị Izrel abaala ụba nke ukwuu nʼọnụọgụgụ dịkwa ike karịa anyị. ");
INSERT INTO ibo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ngwanụ, ka anyị were amamihe meso ha mmeso ọjọọ, ma ọ bụghị otu a, ha ga-amụba karịa, mgbe agha ga-adapụta nʼetiti anyị na ndị iro anyị, ha ga-esoro ndị iro anyị lụso anyị agha, site nʼala a gbapụ.” ");
INSERT INTO ibo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nʼihi nke a, ha tinyere ndịisi ohu ga na eledo ha, bụ ndị ga-eji ọrụ mmanye kpagbuo ha. Ha wuuru Fero obodo Payitọm na Ramesis, ebe ọ na-echekwa ihe. ");
INSERT INTO ibo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ma dịka a na-ata ụmụ Izrel ahụhụ na-eleghị anya nʼazụ, otu a kwa ka ụmụ Izrel gara nʼihu na-amụba nʼọnụọgụgụ na-agbasakwa. Nke a mere ka ndị Ijipt tụọ ndị Izrel egwu. ");
INSERT INTO ibo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ha ji oke ọrụ mekpaa ụmụ Izrel ahụ nke ukwuu, ");
INSERT INTO ibo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","mee ka ndụ ụmụ Izrel bụrụ ndụ jupụtara nʼihe ilu. Ha nyere ha ọrụ ike nke ịkpụ brik na ụrọ, tinyere ọrụ dị iche iche nʼubi ha. Nʼime ọrụ niile ha na-arụ, ndị Ijipt mesiri ha ike nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mgbe ahụ kwa, eze Ijipt gwara ndị inyom Hibru na-aghọ nwa, ndị aha ha bụ Shifra na Pua sị, ");
INSERT INTO ibo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mgbe ọbụla unu na-aghọ nwa ndị inyom Hibru, unu lezie anya nʼokwute e ji amụ nwa, ọ bụrụ nwoke, gbuonụ ya, ma ọ bụrụkwanụ nwanyị, hapụnụ ya ka ọ dịrị ndụ.” ");
INSERT INTO ibo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ma ndị inyom ndị a na-aghọ nwa emeghị ihe eze Ijipt gwara ha, nʼihi na ha tụrụ egwu Chineke. Kama ha hapụrụ ụmụ ndị ikom ndị a ndụ. ");
INSERT INTO ibo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Emesịa, eze Ijipt kpọrọ ndị inyom abụọ ahụ jụọ ha sị, “Gịnị mere unu ji nupu isi nʼiwu m nyere unu site nʼịhapụ igbu ụmụntakịrị ndị ikom Hibru a mụrụ, dịka m gwara unu?” ");
INSERT INTO ibo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ndị inyom ahụ zara Fero sị, “Ndị inyom Hibru na-adị ike karịa ndị inyom Ijipt nʼịmụ nwa. Ha na-amụpụtacharị ụmụ ha tupu anyị erute.” ");
INSERT INTO ibo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ya mere, Chineke gọziri ndị inyom ndị ahụ na-aghọ nwa. Ụmụ Izrel gara nʼihu na-amụba, ghọọ mba dị ukwuu. ");
INSERT INTO ibo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Chineke nʼonwe ya, nyekwara ndị inyom ahụ na-aghọ nwa ezinaụlọ nke aka ha nʼihi na ha tụrụ egwu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mgbe ahụ, Fero nyere ndị ya niile iwu a, “A ga-atụnye ụmụntakịrị ndị ikom Hibru niile a mụrụ ọhụrụ nʼime osimiri Naịl, ma a ga-edebe ụmụntakịrị ọhụrụ bụ ndị inyom ndụ.” ");
INSERT INTO ibo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nʼoge a, otu nwoke onye Hibru si nʼebo Livayị, gakwara lụọ otu nwaada onye Livayị. ");
INSERT INTO ibo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nwanyị a tụụrụ ime, mụọ otu nwa nwoke. Mgbe ọ hụrụ na nwa ọhụrụ ahụ mara mma, o zoro ya nʼụlọ ọnwa atọ. ");
INSERT INTO ibo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mgbe ọ na-enweghịkwa ike izo nwantakịrị a gaa nʼihu, o jiri ahịhịa papịrọs kpaa nkata, were korota tee nʼahụ nkata ahụ niile igbochi mmiri ịbata nʼime ya. O kunyere nwantakịrị ahụ nʼime ya buru nkata ahụ debe ya nʼakụkụ osimiri Naịl ebe ahịhịa mmiri na-eto. ");
INSERT INTO ibo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nwanne nwantakịrị ahụ, nke nwanyị, gakwara guzo nʼebe dị anya na-eche nwantakịrị ahụ nche, ịhụ ihe ga-eme ya. ");
INSERT INTO ibo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ọ dịghị anya, ada Fero bịara nʼakụkụ osimiri Naịl ahụ ịsa ahụ. Mgbe ọ nọ na-asa ahụ, ụmụ agbọghọ na-ejere ya ozi malitere ịgagharị nʼakụkụ osimiri Naịl. Ma ada Fero lepụrụ anya hụ nkata ahụ nʼetiti riidi, zie otu nʼime ohu ya nwanyị ka ọ gaa bute ya. ");
INSERT INTO ibo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mgbe o bupụtara ya, meghee ya, ada Fero hụrụ nwantakịrị ahụ ka ọ na-akwa akwa. O nwere ọmịiko nʼebe nwantakịrị ahụ nọ. Ọ sịrị, “Nwatakịrị a ga-abụrịrị otu nʼime ụmụ ndị Hibru.” ");
INSERT INTO ibo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mgbe ahụ, nwanne nwanyị nwantakịrị a jụrụ ada Fero sị, “Ọ bụ m gaa chọọrọ gị otu nwanyị nʼime ndị inyom Hibru ka ọ na-elekọtaara gị nwantakịrị a anya?” ");
INSERT INTO ibo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ada Fero zaghachiri sị, “Ee, gaa mee otu ahụ.” Nwaagbọghọ ahụ gara ngwangwa nʼụlọ ha kpọọ nne nwantakịrị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mgbe ha bịaghachiri, ada Fero gwara nne nwantakịrị ahụ sị ya, “Kuru nwantakịrị a, gaa zụpụtara m ya. Aga m akwụ gị ụgwọ nke ọma.” Ya mere, nwanyị ahụ kuuru nwantakịrị ahụ, gaa zụọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mgbe nwantakịrị ahụ tolitere, nne ya kulaara ya ada Fero, ka ọ bụrụ nwa ada Fero. Aha ada Fero gụrụ ya bụ Mosis, nʼihi ọ sịrị, “Esi m na mmiri gụpụta ya.” ");
INSERT INTO ibo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Otu ụbọchị, mgbe Mosis toro, ọ pụrụ gaa nʼebe ụmụnna ya nọ, ilele ha mgbe ha nọ na-arụ ọrụ ike ha. Ọ hụrụ otu onye Ijipt ka ọ na-eti onye Hibru ihe, bụ otu nʼime ụmụnna ya. ");
INSERT INTO ibo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosis lere anya nʼakụkụ abụọ. Mgbe ọ hụrụ na ọ dịghị onye na-ele ya anya, o gburu onye Ijipt ahụ, lie ya nʼime aja. ");
INSERT INTO ibo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nʼechi ya, Mosis pụrụ hụ ndị Hibru abụọ ka ha na-alụ ọgụ. Mosis jụrụ onye nke ikpe mara ajụjụ sị ya, “Gịnị mere i ji si otu a na-eti nwanna gị ihe?” ");
INSERT INTO ibo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ma onye ahụ jụrụ Mosis ajụjụ sị, “Onye mere gị onyeisi na onye ikpe nʼetiti anyị? Ị na-achọ igbu m dị ka i si gbuo onye Ijipt ahụ?” Mgbe ahụ Mosis tụrụ ụjọ. O kwuru nʼime onwe ya sị, “Ndị mmadụ amatala banyere ihe ahụ m mere.” ");
INSERT INTO ibo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mgbe Fero nụrụ ihe Mosis mere, ọ gbalịrị igbu Mosis. Ma Mosis si nʼihu Fero gbapụ ọsọ gbaga ala Midia. Nʼebe ahụ ọ gara nọdụ ala nʼakụkụ olulu mmiri. ");
INSERT INTO ibo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ma o nwere otu onye nchụaja obodo Midia mụtara ụmụ agbọghọ asaa. Nʼoge a, ha bịara iseta mmiri na ịgbanye ya nʼime ihe ịgbanye mmiri anụ ụlọ maka inye igwe anụ ụlọ nna ha mmiri. ");
INSERT INTO ibo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ma ụfọdụ ndị na-azụ atụrụ bịara chụpụ ha. Mosis biliri ọtọ, bịa napụta ha, nyere ha aka nye igwe anụ ụlọ ha mmiri. ");
INSERT INTO ibo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ha lọghachikwutere nna ha, Reuel, onye jụrụ ha sị, “Gịnị mere unu ji lọta nʼoge taa?” ");
INSERT INTO ibo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ha zara nna ha sị, “Otu onye Ijipt napụtara anyị site nʼaka ndị ọzụzụ atụrụ. O setaara anyị mmiri, nyekwa igwe anụ ụlọ anyị mmiri.” ");
INSERT INTO ibo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nna ha jụrụ ha sị, “Olee ebe ọ nọ? Gịnị mere unu ji hapụ ya nʼebe ahụ? Gaanụ kpọọ ya ka o soro anyị rie nri.” ");
INSERT INTO ibo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mosis nabatara oku ahụ Reuel kpọrọ ya ka ha na ya biri. O sokwara ha biri. Reuel kpọnyere Mosis Zipọra, otu nwa ya nwanyị, ka ọ bụrụ nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipọra mụtara nwa nwoke, onye Mosis kpọrọ aha ya Geshọm. Nʼihi na Mosis sịrị, “Abụ m onye ọbịa nʼala ndị ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","O ruo, mgbe ọtụtụ ụbọchị gara, Fero eze Ijipt nwụrụ. Nʼoge a, ụmụ Izrel nọ na-asụ ude nʼime ọnọdụ ịbụ ohu ha. Ha kwara akwa nke ukwuu. Akwa ha kwara ka e nyere ha aka nʼihi ọnọdụ ịbụ ohu ha ruru Chineke ntị. ");
INSERT INTO ibo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Chineke nụrụ ịsụ ude ha. O chetara ọgbụgba ndụ ahụ ya na Ebraham, na Aịzik, na Jekọb gbara. ");
INSERT INTO ibo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Chineke hụrụ ụmụ Izrel, ihe banyere ha metukwara ya nʼobi. ");
INSERT INTO ibo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Nʼoge a, Mosis na-azụ igwe anụ ụlọ Jetro ọgọ ya nwoke, onye nchụaja na Midia. Otu ụbọchị, o duuru igwe anụ ụlọ ndị a gaa nʼakụkụ ọzara. Ọ batara Horeb, ugwu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nʼebe ahụ, mmụọ ozi nke Onyenwe anyị mere ka ọ hụ ya nʼọkụ na-ere nʼetiti ọhịa. Mosis hụrụ na ọ bụ ezie na ọhịa ahụ na-enwu ọkụ ma ọ naghị ere ọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nʼihi ya, Mosis chere nʼobi ya sị, “Aga m aga nso leruo ihe omimi a anya, otu ọkụ si enwu ma ọhịa anaghị ere ọkụ.” ");
INSERT INTO ibo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mgbe Onyenwe anyị hụrụ na ọ tụgharịrị ka ọ hụ ihe na-eme, Chineke kpọrọ ya oku site nʼime ọhịa ahụ, “Mosis! Mosis!” Ọ sị, “Lekwa m nʼebe a.” ");
INSERT INTO ibo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mgbe ahụ, ọ sịrị ya, “Abịakwala nso. Yipụ akpụkpọụkwụ gị, nʼihi na ebe i guzo bụ ala dị nsọ.” ");
INSERT INTO ibo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ọ sịrị, “Abụ m Chineke nke nna gị. Chineke nke Ebraham, Chineke nke Aịzik na Chineke nke Jekọb.” Mosis zoro ihu ya, nʼihi na ọ tụrụ egwu ilegide Chineke anya. ");
INSERT INTO ibo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mgbe ahụ Onyenwe anyị sịrị, “Nʼezie, ahụla m nhụju anya nke ndị m nọ nʼIjipt, anụkwala m mkpu akwa ha, nʼihi aka ike nke ndị na-achị ha dịka ndị ohu. Nʼihi na ama m ahụhụ ha na-agabiga. ");
INSERT INTO ibo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ya mere, agbadatala m ịnapụta ha site nʼaka ndị Ijipt na ịkpọpụta ha site nʼala ahụ, idubata ha nʼala ọma ahụ, nke sara mbara, ala mmiri ara ehi na mmanụ aṅụ na-eru na ya. Ala ebe ndị Kenan, na ndị Het, na ndị Amọrait, na ndị Periz, na ndị Hiv, na ndị Jebus bi. ");
INSERT INTO ibo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ugbu a, akwa ụmụ Izrel eruola m ntị, ahụkwala m otu ndị Ijipt si na-emegbu ha. ");
INSERT INTO ibo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ugbu a, aga m eziga gị ka i jekwuru Fero, ka i dupụta ndị m bụ ụmụ Izrel site nʼala Ijipt.” ");
INSERT INTO ibo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mosis sịrị Chineke, “Onye ka m bụ na m ga-ejekwuru Fero, meekwa ka ụmụ Izrel site nʼala Ijipt pụta?” ");
INSERT INTO ibo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Chineke gwara ya sị, “Aga m anọnyere gị. Nke a ga-abụ ihe ama nye gị na ọ bụ m na-eziga gị. Mgbe i sitere nʼala Ijipt kpọpụta ụmụ Izrel, unu niile ga-efe m ofufe nʼelu ugwu a.” ");
INSERT INTO ibo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ma Mosis jụrụ Chineke sị, “Ọ bụrụ na m agwa ụmụ Izrel sị, ‘Chineke nna nna unu zitere m izi unu ozi,’ ha ga-ajụ m sị, ‘Gịnị bụ aha ya?’ Gịnị ka m ga-aza ha?” ");
INSERT INTO ibo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Chineke sịrị Mosis, “ABỤ M ONYE M BỤ. Naanị gwa ụmụ Izrel na ‘ABỤ M zitere gị.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Chineke gakwara nʼihu gwa Mosis sị, Si otu a gwa ụmụ Izrel okwu. “Onyenwe anyị, Chineke nna nna unu, Chineke Ebraham, Chineke Aịzik na Chineke Jekọb, zitere m ịbịakwute unu.” Nke a bụ aha m ruo mgbe ebighị ebi, aha nke e ji echeta m site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Gaa, kpọkọta ndị okenye Izrel niile zie ha sị, ‘Onyenwe anyị Chineke nna nna unu, Chineke Ebraham, Chineke Aịzik, na Chineke Jekọb, egosila m onwe ya, sị m, Eleruola m ọnọdụ unu anya hụ ihe a na-eme unu nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ekweela m nkwa ịkpọpụta unu site nʼahụhụ unu na-ahụ nʼala Ijipt duru unu baa nʼala nke ndị Kenan, na ndị Het, na ndị Amọrait, na ndị Periz, na ndị Hiv, na ndị Jebus bi nʼime ya. Ala mmiri ara ehi na mmanụ aṅụ na-eru na ya.’ ");
INSERT INTO ibo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ndị okenye Izrel ga-anabata ozi gị. Mgbe ahụ gị na ha ga-eso gaa nʼihu eze Ijipt gwa ya sị, ‘Onyenwe anyị, Chineke ndị Hibru ezutela anyị. Kwere ka anyị gaa njem nʼime ọzara abalị atọ gaa chụọrọ Onyenwe anyị Chineke anyị aja.’ ");
INSERT INTO ibo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Amaara m rịị na eze Ijipt agaghị ekwe ka unu gaa, tutu ruo mgbe e ji aka ike kwagide ya. ");
INSERT INTO ibo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ma aga m esetipụ aka m tie Ijipt ihe otiti, site nʼihe ịrịbama dị iche iche nke m ga-eme nʼetiti ya. Mgbe nke a gasịrị, ọ ga-ahapụ unu ka unu laa. ");
INSERT INTO ibo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Aga m emekwa ka unu nweta amara nʼihu ndị Ijipt, ka unu ghara ịgba aka mgbe unu na-ala. ");
INSERT INTO ibo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nwanyị ọbụla ga-arịọ site nʼaka nwanyị Ijipt onye agbataobi ya na nwanyị ọbịa bi nʼụlọ ya, ihe niile e ji ọlaọcha na ọlaedo kpụọ, na akwa dị iche iche. Unu ga-eyikwasị ha ụmụ unu ndị ikom na ụmụ unu ndị inyom, bịa si otu a kwakọrọ ngwongwo ndị Ijipt.” ");
INSERT INTO ibo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosis zaghachiri ya sị, “Gịnị ga-eme ma ọ bụrụ na ha agaghị ekwenye ihe m kwuru maọbụ ajụ ige m ntị? Ọ bụrụ na ha asị, ‘Onyenwe anyị egosighị gị onwe ya.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ma Onyenwe anyị jụrụ Mosis ajụjụ sị ya, “Gịnị ka i ji nʼaka?” Mosis zara sị, “Ọ bụ mkpanaka.” ");
INSERT INTO ibo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Onyenwe anyị sịrị ya, “Tụpụ ya nʼala.” Mosis tụpụrụ ya nʼala. Ma otu mgbe ahụ, ọ ghọrọ agwọ. Mosis sitere nʼebe agwọ ahụ nọ gbapụ ọsọ. ");
INSERT INTO ibo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Onyenwe anyị gwara Mosis okwu ọzọ sị ya, “Jide agwọ ahụ aka nʼọdụdụ ya.” Mgbe Mosis mere nke a, agwọ ahụ ghọghachikwara mkpanaka. ");
INSERT INTO ibo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Onyenwe anyị gwara Mosis sị, “Ọ bụrụ na i mee ihe ịrịbama a, ha ga-ekwere ihe ị gwara ha. Ha ga-aghọta na Onyenwe anyị Chineke nna nna ha, Chineke Ebraham, Chineke Aịzik, na Chineke Jekọb gosiri gị onwe ya.” ");
INSERT INTO ibo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Onyenwe anyị gwara ya okwu ọzọ sị, “Tinye aka gị nʼime uwe i yi nʼime ahụ gị.” Mgbe Mosis tinyere aka ya wepụta ya, ọ chọpụtara na ekpenta jupụtara nʼaka ahụ nke na-enwu ezi ọcha. ");
INSERT INTO ibo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Tinyekwa aka gị nʼime uwe i yi nʼime ahụ gị.” Mosis mere otu a. Mgbe o wepụtara aka ya ọzọ, ọ hụrụ na ọ dịghachiri dịka akụkụ anụ ahụ ya ndị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mgbe ahụ Onyenwe anyị sịrị, “Ọ bụrụ na ụmụ Izrel ekweghị gị maọbụ nabata ihe ama nke mbụ, ha ga-ekwe ihe ịrịbama nke abụọ a. ");
INSERT INTO ibo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ma ọ bụrụ na ha ekwenyeghị nʼihe ịrịbama abụọ ndị a ma ọ bụkwanụ gee gị ntị; kute mmiri nʼosimiri Naịl, wụpụ ya nʼala akọrọ. Mmiri ahụ nke i kutere site nʼosimiri ga-agbanwe, ghọọ ọbara nʼala akọrọ.” ");
INSERT INTO ibo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mosis sịrị Onyenwe anyị, “Biko Onyenwe m, abụghị m onye mara ekwu okwu. Ọ nwebeghị oge m ji bụrụ onye ọka okwu, na mgbe gara aga maọbụ site na mgbe ị gwara ohu gị okwu. Lee, onye nwere ire na egbugbere ọnụ dị arọ ka m bụ.” ");
INSERT INTO ibo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Onyenwe anyị jụrụ Mosis ajụjụ sị, “Onye mere ọnụ mmadụ? Onye na-emekwa ka ntị mmadụ chie ya, maọbụ ka mmadụ daa ogbi? Onye na-eme ka mmadụ hụ ụzọ, maọbụ kpụọ ìsì? Ọ bụghị mụ onwe m bụ Onyenwe anyị? ");
INSERT INTO ibo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ugbu a, gaa mee ihe m gwara gị. Aga m enyere gị aka ikwu okwu nke ọma. Aga m agwakwa gị ihe ị ga-ekwu.” ");
INSERT INTO ibo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ma ọ rịọrọ, “Biko Onyenwe m, ziganụ onye ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Onyenwe anyị were iwe dị ọkụ megide Mosis sị ya, “Kedụ maka nwanne gị nwoke Erọn onye Livayị, amaara m na ọ bụ onye ọka okwu. Lee, ọ na-abịa izute gị. Ọ ga-aṅụrị ọṅụ mgbe ọ chọtara gị. ");
INSERT INTO ibo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ị ga-agwa ya okwu, tinye okwu gị nʼọnụ ya. Aga m enyere unu abụọ aka ikwu okwu nke ọma, aga m ezikwa unu abụọ ihe unu ga-eme. ");
INSERT INTO ibo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ọ ga-abụ onye na-ekwuchite ọnụ gị nʼebe ndị mmadụ nọ. Ị ga-anọ dịka Chineke nʼebe ọ nọ, nʼihi na ị ga-agwa ya ihe niile ọ ga-ekwu. ");
INSERT INTO ibo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ma ị ga-ejide mkpanaka a dị nʼaka gị ka i nwee ike jiri ya mee ihe ịrịbama.” ");
INSERT INTO ibo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Emesịa, Mosis lọghachiri nʼụlọ ebe o bi, jekwuru Jetro ọgọ ya nwoke rịọọ ya sị, “Biko kwere ka m laghachi nʼIjipt gaa chọpụta ma o nwere ndị ikwu m ka dị ndụ.” Jetro sịrị, “Gaa nʼudo.” ");
INSERT INTO ibo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ugbu a Onyenwe anyị gwara Mosis okwu nʼala Midia sị ya, “Laghachi Ijipt nʼihi na ndị niile chọrọ igbu gị anwụchaala.” ");
INSERT INTO ibo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mosis kpọọrọ nwunye ya, na ụmụ ya ndị ikom, nọkwasị nʼelu ịnyịnya ibu, laghachi nʼala Ijipt. O jikwa mkpanaka Chineke ahụ nʼaka ya. ");
INSERT INTO ibo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Onyenwe anyị gwara Mosis okwu sị ya, “Mgbe i ruru Ijipt, hụ na ị gara nʼihu Fero mee ihe ebube niile m nyere gị ike ime. Ma aga m eme ka obi ya sie ike, ka ọ ghara ikwe ka ndị m laa. ");
INSERT INTO ibo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ị ga-agwa Fero okwu sị ya, ‘Nke a bụ ihe Onyenwe anyị kwuru, Izrel bụ Ọkpara m. ");
INSERT INTO ibo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Agwara m gị okwu sị, “Hapụ nwa m nwoke ka o si nʼala Ijipt pụọ gaa ebe ọ ga-anọ fee m ofufe,” ma ị jụrụ ajụ. Ugbu a aga m egbu ọkpara gị.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mgbe Mosis na ezinaụlọ ya na-alaghachi Ijipt, ha rutere ebe ha ga-ezu ike abalị. Nʼebe ahụ, Onyenwe anyị bịakwutere Mosis chọọ igbu ya. ");
INSERT INTO ibo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ma Zipọra nwunye Mosis weere mma ntakịrị bie nwa ya ugwu. O were ihe o bipụtara nʼugwu a metụ nʼụkwụ Mosis, kwuo sị, “Nʼezie, ị bụ di ọbara nʼebe m nọ.” ");
INSERT INTO ibo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nʼihi ya, Onyenwe anyị hapụrụ Mosis. (Mgbe ahụ, Zipọra kwuru sị, “Ị bụ di ọbara,” nʼihi obibi ugwu ahụ.) ");
INSERT INTO ibo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ugbu a, Onyenwe anyị gwara Erọn okwu sị, “Gaa nʼime ọzara ka izute Mosis.” Erọn gara jekwuru Mosis nʼugwu Horeb, ugwu Chineke, sutu ya ọnụ. ");
INSERT INTO ibo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mgbe ahụ Mosis gwara Erọn ihe niile Onyenwe anyị ziri ya ka o kwuo, ya na ihe ịrịbama ndị ahụ niile o nyere nʼiwu ka o mee. ");
INSERT INTO ibo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mosis na Erọn jeruru Ijipt kpọọ nzukọ ndị okenye ụmụ Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Erọn gwara ha ihe niile Onyenwe anyị gwara Mosis. Mosis, nʼonwe ya mere ihe ịrịbama ahụ niile nʼihu anya ha. ");
INSERT INTO ibo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Mgbe ahụ, ha kwenyere; dịka ha nụrụ na Onyenwe anyị eletala ụmụ Izrel, ma hụkwa ahụhụ ha. Ha kpọrọ isiala fee ya ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Emesịa, Mosis na Erọn jekwuuru Fero guzo nʼihu ya gwa ya okwu sị, “Ihe a ka Onyenwe anyị, Chineke Izrel kwuru, ‘Hapụ ndị m ka ha gaa meere m mmemme dị nsọ nʼime ọzara.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fero zara sị, “Onye ka Onyenwe anyị bụ m ga-eji gee ntị nʼolu ya ịhapụ ụmụ Izrel ka ha si nʼebe a pụọ? Amaghị m onye ọ bụ, agaghị m ekwekwa ka Izrel gaa ebe ọbụla.” ");
INSERT INTO ibo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ha zara sị, “Chineke ndị Hibru zutere anyị. Biko kwere ka anyị gaa njem ụbọchị atọ nʼime ọzara nọọ nʼebe ahụ chụọrọ Onyenwe anyị Chineke anyị aja. Ọ bụrụ na anyị ajụ ige ntị nʼolu ya, ọ ga-eji ọrịa ọjọọ maọbụ mma agha kpochapụ anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Eze Ijipt zara ha sị, “Mosis na Erọn, gịnị mere unu ji na-ewepụ ụmụ Izrel aka site nʼọrụ ha? Laghachinụ nʼọrụ unu!” ");
INSERT INTO ibo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Fero gara nʼihu sị, “Lee, ka ndị obodo a si dị ọtụtụ ugbu a, ihe unu na-eme bụ naanị igbochi ha ịrụ ọrụ ha.” ");
INSERT INTO ibo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Nʼụbọchị ahụ kwa, Fero nyere ndị nlekọta ụmụ Izrel na ndị o mere ndịisi nʼebe ụmụ Izrel nọ iwu sị, ");
INSERT INTO ibo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Unu enyekwala ụmụ Izrel ahịhịa ha ga-eji kpụọ brik dịka unu na-eme nʼoge gara aga. Kama, ha ga-achọta ahịhịa ahụ nʼonwe ha. ");
INSERT INTO ibo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ọzọ, meenụ ka ọnụọgụgụ brik ha na-akpụ dịrị ka ọ dị na mbụ, unu emela ka ọ dịrị ala. Ha bụ ndị umengwụ. Ọ bụ ya mere ha ji na-eti mkpu, ‘Ka anyị gaa nʼọzara gaa chụọrọ Chineke anyị aja.’ ");
INSERT INTO ibo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nyenụ ha ọrụ dị ike, nke ga-ezi ha na ha ekwesighị ịṅa ntị nʼokwu ụgha Mosis na Erọn na-ekwuru ha.” ");
INSERT INTO ibo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ndị na-achị ndị ohu na ndị nlekọta jekwuuru ụmụ Izrel sị ha, “Ihe a ka Fero kwuru: ‘Agaghị m enyekwa unu ahịhịa ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gaanụ chọtara onwe unu okporo ahịhịa ebe ọbụla unu nwere ike ịchọta ya, ma nke a agaghị eme ka e gbubilata ọrụ unu kwesiri ịrụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ya mere ndị ha gbasasịrị nʼala Ijipt niile ịchịkọta okporo ahịhịa ha ji akpụ brik. ");
INSERT INTO ibo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ndị na-achị ha nọgidere na-akwagide ha sị ha, “Rụchaanụ ọrụ unu kwesiri ịrụ nʼụbọchị dịka unu si arụ ya mgbe a na-enye unu ahịhịa.” ");
INSERT INTO ibo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ndịisi ọrụ Fero malitere iti ndị Izrel ha họpụtara maka inyere ha aka ilekọta ndị ọrụ ihe, na-ajụ ha ajụjụ sị, “Gịnị mere unu akpụtaghị oke ọnụọgụgụ brik unu kwesiri ịkpụta ụnyaahụ maọbụ taa?” ");
INSERT INTO ibo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mgbe ahụ, ndịisi ọrụ ndị Izrel bịakwutere Fero kwaara ya akwa sị ya, “Gịnị mere i ji si otu a na-emeso ndị ohu gị mmeso? ");
INSERT INTO ibo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ọ dịghị okporo ahịhịa a na-enye ndị ohu gị, ma ha na-asị anyị, ‘Kpụọnụ brik!’ A na-etikwa ndị ohu gị ihe, ma ịta ụta ekwesighị ịdịrị anyị kama ịta ụta dịrị ndị gị.” ");
INSERT INTO ibo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fero zaghachiri ha sị, “Ndị umengwụ! Nʼezie ndị umengwụ ka unu bụ. Ọ bụ ya mere unu ji nọgide na-asị, ‘Ka anyị gaa chụọrọ Onyenwe anyị aja.’ ");
INSERT INTO ibo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Laghachinụ azụ ugbu a nʼọrụ unu. A gaghị enye unu okporo ahịhịa ọbụla. Ma unu ga-arụpụtarịrị ọnụọgụgụ brik dị ka a chọrọ nʼaka unu.” ");
INSERT INTO ibo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ndịisi ọrụ ụmụ Izrel ghọtara na ha nọ na nsogbu mgbe a gwara ha okwu sị ha, “Unu ga-akpụtarịrị ọnụọgụgụ brik unu kwesiri ịkpụ kwa ụbọchị.” ");
INSERT INTO ibo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mgbe ha si nʼihu Fero pụọ, ha zutere Mosis na Erọn ebe ha nọ na-eche ha. ");
INSERT INTO ibo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ndị nlekọta ọrụ ndị a gwara Mosis na Erọn okwu sị, “Ka Onyenwe anyị lee unu anya ma kpee unu ikpe. Unu emeela ka anyị bụrụ ihe na-esi ajọ isi nʼihu Fero na ndị na-ejere ya ozi. Unu etinyela mma agha nʼaka ha nke ha ga-eji gbuo anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mgbe ahụ Mosis laghachikwuru Onyenwe anyị jụọ ya sị, “Onyenwe anyị, gịnị mere i ji butere ndị a nsogbu? Gịnị mere i ji zite m? ");
INSERT INTO ibo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nʼihi na site na mgbe m jekwuuru Fero gwa ya okwu nʼaha gị, o meela ka nsogbu dakwasị ndị a, ma ị napụtabeghị ndị gị.” ");
INSERT INTO ibo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị, “Ugbu a, ị ga-ahụ ihe m ga-eme Fero. Nʼihi ike aka m, ọ ga-ezipụ ha. Nʼihi ike aka, ọ ga-achụpụ ha site nʼala ya.” ");
INSERT INTO ibo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Chineke gara nʼihu gwa Mosis sị, “Mụ onwe m bụ Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Egosiri m Ebraham na Aịzik na Jekọb onwe m dịka Chineke, Onye pụrụ ime ihe niile. Ma ọ dịghị mgbe m mere ka ha mata aha m dịka Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Emere m ka ọgbụgba ndụ m guzosie ike nʼetiti mụ na ha, ọgbụgba ndụ nke inye ha ala Kenan ebe ha biri dịka ndị ọbịa. ");
INSERT INTO ibo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ugbu a, anụla m ịsụ ude ụmụ Izrel, bụ ndị ahụ ndị Ijipt mere ka ha bụrụ ndị ohu. Echetakwala m ọgbụgba ndụ m. ");
INSERT INTO ibo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Ya mere, gwa ụmụ Izrel, ‘Abụ m Onyenwe anyị. Aga m akpọpụta unu site nʼọnọdụ ịbụ ohu ndị Ijipt. Aga m eme ka unu nwere onwe unu site nʼọnọdụ ịbụ ndị ohu nye ha. Aga m eji aka ike m nke m ga-esetipụ, ya na ihe ngosipụta dị ukwuu nke ikpe ikpe m, gbapụta unu. ");
INSERT INTO ibo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mgbe ahụ, aga m ewere unu ka unu bụrụ ndị m. Aga m abụ Chineke unu. Unu ga-amata na m bụ Onyenwe anyị, onye kpọpụtara unu site nʼaka ịbụ ohu nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aga m akpọbata unu nʼala ahụ m weliri aka m elu, ṅụọ nʼiyi, nye Ebraham, na Aịzik, na Jekọb, ime ka ọ bụrụ ihe nketa unu. Abụ m Onyenwe anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mosis gwara ụmụ Izrel ihe ndị a, ma ha egeghị ntị nʼihi ịda mba nke obi ha na ahụhụ sitere na ndọgbu nʼọrụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Onyenwe anyị gwara Mosis okwu ọzọ sị, ");
INSERT INTO ibo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Gaa gwa Fero eze Ijipt, ka ọ hapụ ụmụ Izrel ka ha pụọ nʼala ya.” ");
INSERT INTO ibo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mosis kwuru nʼihu Onyenwe anyị sị, “Mgbe ụmụ Izrel na-aṅaghị m ntị, olee otu Fero ga-esi ṅaa m ntị? Nke ka nke, enweghị m ike ikwu okwu nke ọma.” ");
INSERT INTO ibo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Onyenwe anyị gwara Mosis na Erọn okwu banyere ụmụ Izrel na banyere Fero eze Ijipt. O nyere ha iwu sị ha site nʼala Ijipt kpọpụta ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ndị a bụ aha ndịisi ebo Izrel niile. Ụmụ ndị ikom Ruben, ọkpara Izrel bụ, Hanok na Palu, Hezrọn na Kami. Ndị a bụ agbụrụ Ruben. ");
INSERT INTO ibo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ụmụ ndị ikom Simiọn bụ, Jemuel, Jamin, Ohad, Jakin, Zoha na Shaul (onye nne ya bụ onye Kenan). Ndị a bụ agbụrụ Simiọn. ");
INSERT INTO ibo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ndị a bụ ụmụ ndị ikom Livayị nʼusoro e si mụọ ha: Geshọn, Kohat na Merari. Livayị nʼonwe ya gbara narị afọ na iri afọ atọ na asaa mgbe ọ nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ụmụ ndị ikom Geshọn, nʼagbụrụ ha, bụ Libni na Shimei, nʼusoro ezinaụlọ ha. ");
INSERT INTO ibo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ụmụ ndị ikom Kohat bụ, Amram, Izha, Hebrọn na Uziel. Kohat gbara narị afọ na iri afọ atọ na atọ mgbe ọ nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ụmụ ndị ikom Merari bụ Mahali na Mushi. Ndị a niile si nʼagbụrụ Livayị, dịka ihe e dere banyere ha si dị. ");
INSERT INTO ibo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram lụrụ Jokebed, nwanne nna ya. Erọn na Mosis bụ ụmụ ha ndị ikom. Ma Amram gbara narị afọ na iri afọ atọ na asaa mgbe ọ nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ụmụ ndị ikom Izha bụ Kora, Nefeg na Zikri. ");
INSERT INTO ibo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ụmụ ndị ikom Uziel bụ, Mishael, Elzafan na Sitri. ");
INSERT INTO ibo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Erọn lụrụ Elisheba, nwa Aminadab, na nwanne nwanyị Nashọn. Ụmụ ha bụ, Nadab, na Abihu, Elieza na Itama. ");
INSERT INTO ibo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ụmụ ndị ikom Kora bụ, Asịa, Elkena na Abiasaf. Ndị a bụ ndị ikwu Kora. ");
INSERT INTO ibo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elieza, nwa Erọn lụrụ otu nʼime ụmụ Putiel, onye mụtaara ya Finehaz. Ndị a bụ aha ndịisi ezinaụlọ Livayị dịka ikwu ha si dị. ");
INSERT INTO ibo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ọ bụkwa Mosis na Erọn ka Onyenwe anyị gwara okwu sị, “Sitenụ nʼala Ijipt dupụta ụmụ Izrel dịka ọnụọgụgụ ha si dị.” ");
INSERT INTO ibo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ha bụ ndị gwara Fero, eze Ijipt okwu banyere ime ka ụmụ Izrel site nʼala Ijipt pụọ. Ọ bụkwa otu Mosis na Erọn ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Otu ụbọchị, Onyenwe anyị gwara Mosis okwu nʼIjipt, ");
INSERT INTO ibo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ọ sịrị ya, “Mụ onwe m bụ Onyenwe anyị, gaa gwa Fero eze Ijipt ihe niile m gwara gị.” ");
INSERT INTO ibo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mosis kwuru nʼihu Onyenwe anyị sị, “Lee, abụ m onye na-adịghị ekwuzi okwu nke ọma, gịnị mere Fero ga-eji gee ntị nʼihe m ga-agwa ya?” ");
INSERT INTO ibo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mgbe ahụ Onyenwe anyị gwara Mosis okwu sị, “Emeela m gị ka ị dịrị ka Chineke nʼebe Fero nọ. Nwanne gị Erọn ga-abụkwa onye amụma gị. ");
INSERT INTO ibo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ị ga-agwa Erọn ihe niile m gwara gị. Ọ ga-ekwukwa ha nʼihu Fero, rịọọ ya ka o kwere ka ụmụ Izrel hapụ ala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ma aga m eme ka obi Fero sie ike. Ọ bụ ezie na m ga-eme ọtụtụ ihe ịrịbama nʼihe ebube nʼala Ijipt, ");
INSERT INTO ibo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ma Fero agaghị ege unu ntị. Mgbe ahụ aga m eme ka aka m bịakwasị Ijipt. Aga m esite nʼoke ọrụ nke ikpe ọmụma dị oke egwu, mee ka ndị m, Izrel, dịka usuu ha niile si dị, site nʼala Ijipt pụọ. ");
INSERT INTO ibo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ndị Ijipt ga-amata nʼezie na m bụ Onyenwe anyị, mgbe m setịpụrụ aka nʼIjipt, ma site nʼetiti ha kpọpụta ụmụ Izrel.” ");
INSERT INTO ibo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mosis na Erọn mere dịka Onyenwe anyị nyere ha iwu. ");
INSERT INTO ibo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Nʼoge a, mgbe ha gwara Fero okwu, Mosis agbaala iri afọ asatọ. Ma Erọn agbaala iri afọ asatọ na atọ. ");
INSERT INTO ibo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mgbe ahụ, Onyenwe anyị gwara Mosis na Erọn sị, ");
INSERT INTO ibo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Mgbe Fero ga-agwa unu okwu sị, ‘Meenụ ihe ebube.’ Ị ga-agwa Erọn okwu sị ya, ‘Were mkpanaka gị tụpụ ya nʼala nʼihu Fero.’ Ọ ga-aghọ agwọ.” ");
INSERT INTO ibo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mgbe ahụ, Mosis na Erọn jekwuuru Fero mee dịka Onyenwe anyị nyere ha nʼiwu. Erọn tụpụrụ mkpanaka ya nʼala nʼihu Fero na ndị ozi ya. Ọ ghọrọ agwọ. ");
INSERT INTO ibo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ma Fero kpọkọtara ndị maara ihe, na ndị mgbaasị, na ndị majiki nọ nʼIjipt. Ha bịara mee ụdị ihe ịrịbama ahụ Mosis na Erọn mere site nʼihe nzuzo nke akaọrụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Onye ọbụla nʼime ha tụpụrụ mkpanaka ya, nke ghọkwara agwọ. Ma mkpanaka ahụ Erọn tụpụrụ, nke ghọrọ agwọ, loro mkpanaka ndị ahụ niile ndị Ijipt tụpụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Fero nyịchiri obi ya, mee ka o sie ike. O geghị Erọn na Mosis ntị dịka Onyenwe anyị kwuru. ");
INSERT INTO ibo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Onyenwe anyị gwara Mosis sị, “Obi Fero siri ike. Ọ bụ nke a mere o ji na-aga nʼihu na-ajụ ka ndị m laa. ");
INSERT INTO ibo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ma otu ọ dị; nʼisi ụtụtụ echi, jekwuru Fero tupu ọ gaa nʼosimiri. Guzoro nʼakụkụ osimiri Naịl, jidekwa mkpanaka ahụ ghọrọ agwọ nʼaka gị. ");
INSERT INTO ibo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ị ga-agwa Fero sị, ‘Onyenwe anyị, Chineke ndị Hibru, ezitela m ka m gwa gị sị, hapụ ndị m ka ha gaa nʼọzara fee m ofufe. Tutu ruo ugbu a, ị jụrụ ige ntị.’ ");
INSERT INTO ibo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ugbu a Onyenwe anyị kwuru nke a sị, ‘Ị ga-amata site na nke a na mụ onwe m bụ Onyenwe anyị. Aga m ewere mkpanaka a nke m ji nʼaka tie nʼosimiri Naịl. Ọ ga-agbanwe ghọọ ọbara. ");
INSERT INTO ibo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Azụ niile dị nʼime ya ga-anwụ. Osimiri ahụ ga-esikwa isi dịka ihe rere ure. Nke a ga-eme ka ọ bụrụ ihe rara ahụ nye ndị Ijipt ịṅụ mmiri site na ya.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mgbe ahụ, Onyenwe anyị gwara Mosis sị ya, “Gwa Erọn ka o setịpụ mkpanaka ya nʼelu mmiri niile dị nʼIjipt. Nke a metụtara osimiri ha niile, mmiri ntakịrị ha niile, ọdọ mmiri ha niile, na ebe niile ha na-echekọta mmiri. Ọbara ga-ejupụta ebe niile nʼIjipt, ite mmiri na ite aja na ite osisi niile.” ");
INSERT INTO ibo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mosis na Erọn mere dị ka Onyenwe anyị nyere ha nʼiwu ime. Nʼihu Fero na ndịisi ọrụ ya, Erọn weliri mkpanaka ya tie ya nʼelu mmiri dị nʼosimiri Naịl. Nʼotu ntabi anya, mmiri ahụ gbanwere ghọọ ọbara. ");
INSERT INTO ibo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ka azụ dị nʼime mmiri Naịl nwụsịrị, mmiri ahụ malitere na-esi isi ọjọọ, nke mere ka ndị Ijipt hapụ inwe ike ịṅụ mmiri sitere na ya. Ọbara jupụtakwara nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ma ndị majiki Ijipt jikwa ihe nzuzo ha mee ka mmiri chaa ọbara ọbara. Nke a mere ka Fero nyịchie obi ya. Ọ ṅaghị Mosis na Erọn ntị, dịka Onyenwe anyị gwara ha na ọ ga-eme. ");
INSERT INTO ibo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Fero tụgharịrị laghachi nʼụlọeze ya, na-echeghị echiche banyere ihe niile ahụ e mere. ");
INSERT INTO ibo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ya mere, ndị Ijipt niile gwuru olulu mmiri nʼakụkụ osimiri ahụ ịchọ mmiri ọṅụṅụ ebe ha na-enweghị ike ịṅụ mmiri sitere nʼosimiri Naịl. ");
INSERT INTO ibo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ụbọchị asaa gasịrị, site nʼụbọchị Onyenwe anyị tichara ihe otiti ahụ na Naịl. ");
INSERT INTO ibo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis sị, “Jekwuru Fero gwa ya, ‘Nke a bụ ihe Onyenwe anyị kwuru. Hapụ ndị m, ka ha gaa fee m ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ọ bụrụ na ị jụ ịhapụ ha ka ha gaa, aga m eme ka awọ jupụta nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Osimiri Naịl ga-ejupụta nʼawọ. Ha ga-abata nʼụlọeze gị na nʼime ọnụụlọ ndina gị, ma nʼelu ihe ndina gị, ma nʼụlọ ndị na-ejere gị ozi, ma nʼụlọ ndị gị niile, na nʼebe a na-esi nri, ma nʼime ihe e ji agwakọta ụtụ ọka. ");
INSERT INTO ibo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Awọ ndị a ga-arịgokwa nʼahụ gị, na nʼahụ ndị gị, na nʼahụ ndị na-ejere gị ozi.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mgbe ahụ, Onyenwe anyị gwara Mosis sị, “Gwa Erọn, ‘Setịpụ aka gị ya na mkpanaka gị nʼelu osimiri niile, na mmiri nta na ọdọ mmiri ndị Ijipt, mee ka awọ jupụta ala Ijipt niile.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Erọn setịpụrụ aka nʼelu mmiri niile nke Ijipt, awọ pụtara kpuchie ala ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ma ndị majiki Ijipt jikwa ihe nzuzo ha mee ihe ahụ Mosis na Erọn mere. Ha mekwara ka awọ jupụta ala ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fero kpọrọ Mosis na Erọn rịọọ ha sị, “Rịọọnụ Onyenwe anyị ka o wepụrụ mụ na ndị m awọ ndị a. Emesịa aga m ekwe ka ndị gị gaa chụọrọ Onyenwe anyị aja.” ");
INSERT INTO ibo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosis zaghachiri Fero sị, “Gị ka ọ dịrị ịgwa m mgbe m ga-arịọ arịrịọ a nʼisi gị na nʼisi ndị gị, ka e wezuga awọ ndị a site nʼụlọ unu, ma hapụ naanị ndị nọ nʼosimiri Naịl.” ");
INSERT INTO ibo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mgbe ahụ Fero sịrị Mosis, “Achọrọ m ka i mee ya echi.” Mosis zaghachiri Fero sị, “Ọ dị mma, ka ọ dịrị dịka i kwuru. Mgbe ahụ, ị ga-amata na o nweghị onye dịka Onyenwe anyị Chineke anyị. ");
INSERT INTO ibo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Awọ ndị a niile ga-apụ site nʼebe ị nọ, na site nʼụlọ gị na site nʼụlọ ndị na-ejere gị ozi na site nʼụlọ ndị Ijipt niile. Ọ bụ naanị nʼosimiri Naịl ka ha ga-anọ.” ");
INSERT INTO ibo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mgbe Mosis na Erọn sitere nʼụlọ Fero pụọ, Mosis kpọkuru Onyenwe anyị ka o wepụ awọ ndị a o mere ka ha bịakwasị Fero. ");
INSERT INTO ibo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Onyenwe anyị mere ihe Mosis rịọrọ. Awọ ndị ahụ niile nwụrụ nʼime ụlọ, na nʼama, na nʼọhịa. ");
INSERT INTO ibo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","E kpokọtara ozu awọ ndị a niile nʼebe dị iche iche. Isi ọjọọ ha wetara nʼala ahụ dị egwu. ");
INSERT INTO ibo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ma mgbe Fero hụrụ na awọ ndị a anwụchaala, o mechiri obi ya jụ ige Mosis na Erọn ntị, dịka Onyenwe anyị kwuru na ọ ga-eme. ");
INSERT INTO ibo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ya mere, Onyenwe anyị gwara Mosis sị ya, “Gwa Erọn, setịpụ mkpanaka gị, tie nʼaja nke ala nʼala Ijipt niile, aja ya ga-aghọ anwụ nta nke na-ata ata.” ");
INSERT INTO ibo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mosis na Erọn mere nke a. Mgbe Erọn setịpụrụ aka tie mkpanaka ya nʼelu ala, anwụ nta jupụtara nʼala Ijipt niile, nʼahụ ndị mmadụ, na nʼahụ anụmanụ ha. Ndanda ndị a jupụtakwara nʼuzuzu niile dị nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ndị Ijipt na-eme majiki gbalịrị iji ihe nzuzo ha mee otu ihe ahụ Erọn mere, ma ha enweghị ike ime ka anwụ nta ọbụla pụta. Ebe ọ bụ na anwụ nta ndị a jupụtara nʼahụ mmadụ na nʼahụ anụmanụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Naanị ihe ndị na-eme majiki gwara Fero bụ, “Nke a bụ akaọrụ Chineke.” Ma Fero mere ka obi ya sie ike. Ọ chọghị ige, ọ bụladị ndị majiki ya ntị, dịka Onyenwe anyị kwuru na ọ ga-eme. ");
INSERT INTO ibo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Onyenwe anyị gwara Mosis sị ya, “Bilie nʼisi ụtụtụ echi jekwuru Fero. Mgbe ọ ga-aga nʼosimiri, gwa ya okwu sị, ‘Nke a bụ ihe Onyenwe anyị kwuru, Hapụ ndị m ka ha gaa fee m ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ọ bụrụ na ị chọghị ime otu a, aga m eme ka igwe ijiji jupụta nʼala Ijipt niile. Ha ga-ejupụta gị nʼahụ na nʼahụ ndị na-ejere gị ozi, na nʼahụ ndị gị niile, na nʼime ụlọ unu niile. ");
INSERT INTO ibo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Nʼụbọchị ahụ, igwe ijiji ndị a agaghị emetụ ndị nọ na Goshen ebe ndị m bi. Mgbe ahụ ka ị ga-amata na mụ bụ Onyenwe anyị bịara ije nʼala a. ");
INSERT INTO ibo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Aga m emekwa ka ọ pụta ìhè na o nwere ihe dị iche nʼetiti ndị m na ndị gị. Ihe ịrịbama a ga-emezukwa echi.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Nʼechi ya, Onyenwe anyị mere dịka o kwuru. Igwe ijiji dị egwu nʼọnụọgụgụ bịara nʼala Ijipt, jupụta nʼụlọ Fero, na nʼụlọ ndị niile na-ejere ya ozi, na nʼala Ijipt niile. E mere ka ala Ijipt bụrụ ihe e ji ijiji mebie. ");
INSERT INTO ibo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mgbe ihe ndị a na-eme, Fero kpọrọ Mosis na Erọn gwa ha okwu sị, “Gaanụ chụọrọ Chineke unu aja, ma ka ọ bụrụ nʼala Ijipt.” ");
INSERT INTO ibo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mosis zaghachiri Fero sị, “Nke ahụ abụghị ihe ziri ezi, nʼihi na aja anyị na-aga ịchụrụ Onyenwe anyị Chineke anyị bụ ihe rụrụ arụ nʼanya ndị Ijipt. Ọ bụrụ na anyị achụọ aja a nʼihu ha, ha ga-eji nkume tugbuo anyị. ");
INSERT INTO ibo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Anyị ga-aga njem ụbọchị atọ nʼime ọzara gaa chụọrọ Onyenwe anyị Chineke anyị aja, dịka o nyere anyị iwu ka anyị mee.” ");
INSERT INTO ibo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fero zaghachiri ha sị, “Aga m ekwenye ka unu ga chụọrọ Onyenwe anyị Chineke unu aja nʼọzara, ma unu agaghị aga ebe dị anya. Ugbu a, kperenụ m ekpere.” ");
INSERT INTO ibo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosis zara Fero sị ya, “Ngwangwa m si nʼihu gị pụọ, aga m arịọ Onyenwe anyị arịrịọ. Echi, a ga-esite nʼụlọ Fero, na nʼụlọ ndị na-ejere ya ozi, na nʼụlọ ndị Ijipt niile wezuga ijiji ndị a. Ọ ga-adị mkpa na Fero ga-elezi anya hapụ ịghọ aghụghọ ọzọ site ịjụ ka ụmụ Izrel gaa chụọrọ Onyenwe anyị aja.” ");
INSERT INTO ibo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mgbe ahụ, Mosis sitere nʼihu Fero pụọ rịọọ Onyenwe anyị ka o mee ka ijiji ndị a gabiga. ");
INSERT INTO ibo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Onyenwe anyị mere dịka Mosis rịọrọ. Ijiji ndị a sitere nʼụlọ Fero na ụlọ ndị na-ejere ya ozi na ụlọ ndị Ijipt niile pụọ. O nwekwaghị ijiji ọ bụla fọdụrụ nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma nʼoge a, Fero gara nʼihu ime ka obi ya sie ike. O kweghị ka ụmụ Izrel laa. ");
INSERT INTO ibo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis sị ya, “Jekwuru Fero sị ya. ‘Nke a bụ ihe Onyenwe anyị Chineke ndị Hibru kwuru, “Hapụ ndị m ka ha gaa fee m.” ");
INSERT INTO ibo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ọ bụrụ na ị jụ, ma gaa nʼihu igbochi ha, ");
INSERT INTO ibo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","aka Onyenwe anyị ga-ewebata oke ọrịa na-efe efe nke ga-abịakwasị igwe anụ ụlọ unu niile dị nʼubi. Ya bụ, ịnyịnya unu, na ịnyịnya ibu unu, na ịnyịnya kamel unu, na ehi unu, na atụrụ unu na ewu unu. ");
INSERT INTO ibo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Onyenwe anyị ga-akpa oke nʼetiti anụ ụlọ ndị Ijipt na nke ndị Izrel. Nʼihi ya, o nweghị anụ ụlọ ọbụla si nʼetiti anụ ụlọ ndị Izrel ga-anwụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Onyenwe anyị ekwuola oge nke a ga-amalite sị, “Echi ka Onyenwe anyị ga-eme ihe dị otu a nʼala a.” ");
INSERT INTO ibo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nʼụtụtụ echi ya, Onyenwe anyị mere dịka o kwuru. Igwe anụ ụlọ niile dị nʼIjipt nwụrụ. Ma ọ dịghị otu nʼime anụ ụlọ ụmụ Izrel nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mgbe ahụ Fero zipụrụ ndị mmadụ ndị gara chọpụta na o nweghị otu nʼime anụ ụlọ ụmụ Izrel nwụrụ. Ma ọ bụladị mgbe ọ chọpụtara na nke a bụ eziokwu, ọ gbanweghị obi ya, ọ nọgidere jụ ikwe ka ndị Izrel laa. ");
INSERT INTO ibo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mgbe ahụ, Onyenwe anyị gwara Mosis na Erọn sị, “Sitenụ nʼekwu e ji esi nri kporo ntụ nke Mosis ga-awụli elu nʼihu Fero. ");
INSERT INTO ibo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ntụ ahụ ga-efesasị, dịka uzuzu nʼala Ijipt niile. Ọ ga-ebute etuto nke ga-aghọ ọnya nʼahụ ndị mmadụ na ụmụ anụmanụ dị iche iche dị nʼala ahụ niile.” ");
INSERT INTO ibo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mosis na Erọn kpooro ntụ gaa guzo nʼihu Fero. Mgbe Fero nọ na-ele anya Mosis wụliri ntụ ahụ elu. Ọ ghọrọ etuto, nke gbawara ghọọ ọnya nʼahụ ụmụ mmadụ na ụmụ anụmanụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ndị majiki Ijipt enweghị ike iguzo nʼihu Mosis, nʼihi etuto ndị jupụtara ha nʼahụ dịka ọ dị nʼahụ ndị Ijipt ndị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ma Onyenwe anyị mere ka obi Fero sie ike. Ọ jụrụ ige Mosis na Erọn ntị dịka Onyenwe anyị gwara Mosis na ọ ga-eme. ");
INSERT INTO ibo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Onyenwe anyị gwara Mosis ọzọ sị, “Bilie nʼisi ụtụtụ echi gaa gwa Fero okwu sị ya, ‘Nke a bụ ihe Onyenwe anyị Chineke ndị Hibru kwuru, Hapụ ndị m ka ha gaa fee m ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ma ọ bụghị ya, nʼoge a, aga m ezite ọrịa ọjọọ niile nke na-efe efe, ka ha bịakwasị gị, na ndị na-ejere gị ozi, na ndị Ijipt niile. Nke a ga-eme ka unu ghọta na ọ dịghị Onye ọzọ dịka m nʼelu ụwa niile. ");
INSERT INTO ibo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nʼihi na tupu oge a, agaara m esetipụ aka m, jiri ajọ ọrịa tie gị na ndị gị niile nke ga-egbuchapụ unu site nʼelu ụwa. ");
INSERT INTO ibo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma ọ bụ nʼihi nke a ka m ji guzobe gị, ka m gosipụta ike m nʼebe ịnọ, ka e nwe ike kwusaa aha m nʼụwa niile. ");
INSERT INTO ibo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ma ị nọ na-ebuli onwe gị elu megide ndị m, jụ na ha agaghị ala. ");
INSERT INTO ibo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ya mere, nʼoge dịka oge a echi, aga m ezipu oke ifufe nke ya na akụmmiri igwe so nʼala Ijipt niile. Ụdị ifufe a adịbeghị mbụ nʼala Ijipt, malite nʼoge a tọrọ ntọala ya rute ugbu a. ");
INSERT INTO ibo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ya mere, nye iwu ka a gaa ngwangwa nʼubi unu webata anụ ụlọ unu na ihe ndị ọzọ unu nwere nʼebe a ga-echebe ha, nʼihi na oke ifufe nke ya na mkpụrụ mmiri so ga-egbu mmadụ na anụ ụlọ ọbụla a hapụrụ nʼezi.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ụfọdụ ndị na-ejere Fero ozi, ndị na-atụ okwu Onyenwe anyị egwu mere ngwangwa gaa dulata anụ ụlọ ha, na ndị ohu ha. ");
INSERT INTO ibo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ma ndị ahụ na-enweghị nrube isi nye okwu Onyenwe anyị hapụrụ ndị ohu ha nakwa anụ ụlọ ha nʼọhịa. ");
INSERT INTO ibo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mgbe ahụ, Onyenwe anyị gwara Mosis, “Setịpụ aka gị nʼeluigwe. Nke a ga-eme ifufe nke ya na mkpụrụ mmiri so malite izokwasị ala Ijipt niile, na ụmụ mmadụ, na anụmanụ, na ihe niile a kụrụ nʼubi nʼIjipt.” ");
INSERT INTO ibo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mgbe Mosis setịpụrụ mkpanaka ya nʼihu eluigwe, Onyenwe anyị zidatara egbe eluigwe na oke ifufe nke ya na mkpụrụ mmiri so. Amụma egbe eluigwe chakwara nʼala. Ya mere, Onyenwe anyị zidatara oke ifufe nke ya na mkpụrụ mmiri so nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mkpụrụ mmiri dara, amụma gbukwara nʼihu nakwa nʼazụ. Nʼezie, ọ bụ oke ifufe dị njọ, ụdị nke a na-ahụtụbeghị nʼala Ijipt kemgbe ọ ghọrọ nnukwu mba. ");
INSERT INTO ibo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mkpụrụ mmiri ahụ tigburu ihe niile dị nʼọhịa, ma mmadụ ma anụmanụ niile dị nʼala Ijipt. O feturu ihe niile na-epu nʼubi, ma ahịhịa niile dị nʼosisi. ");
INSERT INTO ibo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ma akụkụ ebe mkpụrụ mmiri ndị a na-erughị bụ naanị Goshen, ebe ụmụ Izrel bi. ");
INSERT INTO ibo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mgbe ahụ Fero ziri ozi ka a kpọ Mosis na Erọn. O kwupụtara nʼihu ha sị, “Nʼoge a, emehiela m. Onyenwe anyị bụ onye ezi omume, mụ na ndị m bụ ndị mejọrọ. ");
INSERT INTO ibo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kpee ekpere rịọọ Onyenwe anyị nʼihi na oke mkpụrụ mmiri na egbe eluigwe a ezuola. Aga m ekwe ka unu gaa, unu agaghị atụfukwa mgbe.” ");
INSERT INTO ibo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mosis gwara Fero sị ya, “Mgbe m si nʼobodo a pụọ, aga m esetipụ aka m nʼebe Onyenwe anyị nọ, egbe eluigwe a, na ifufe a nke ya na mkpụrụ mmiri so ga-akwụsịkwa. Site na nke a, ị ga-amata na ụwa niile bụ nke Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ma amaara m na gị onwe gị na ndị na-ejere gị ozi adịghị atụ Onyenwe anyị Chineke egwu.” ");
INSERT INTO ibo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Oke ifufe ahụ nke ya na mkpụrụ mmiri so mebiri ihe a kụrụ nʼubi, dịka flakisi na ọka balị. Nʼihi na nʼoge a, ọka balị emenyela isi, flakisi etojuokwala maa ifuru. ");
INSERT INTO ibo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ma ifufe na mmiri ukwu ahụ emebighị ọka wiiti na spelti, nʼihi na ha achabeghị. ");
INSERT INTO ibo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosis hapụrụ Fero si nʼobodo ahụ pụọ. Ọ gbasapụrụ aka ya abụọ nʼihu Onyenwe anyị, egbe eluigwe na mkpụrụ mmiri ahụ kwụsịrị. Mmiri ozuzo kwụsịkwara izo nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mgbe Fero hụrụ na mmiri ozuzo na mkpụrụ mmiri na egbe eluigwe akwụsịla, o mehiere ọzọ. Ya na ndị na-ejere ya ozi gara nʼihu nyịchie obi ha. ");
INSERT INTO ibo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ya mere, Fero mere ka obi ya sie ike. Ọ jụrụ ikwere ka ụmụ Izrel pụọ, dịka Onyenwe anyị gwararịị Mosis. ");
INSERT INTO ibo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Jekwuru Fero nʼihi na emeela m ka obi ya, na obi ndị na-ejere ya ozi sie ike, ka m nwee ike rụọ ọrụ ịrịbama ndị a dị iche iche nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nke a ga-abụ akụkọ unu ga-akọrọ ụmụ unu, na ụmụ ụmụ unu, banyere otu m si mesie ndị Ijipt ike, na otu m si rụọ ọrụ ịrịbama m nʼetiti ha, ime ka unu mata na m bụ Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ọzọ, Mosis na Erọn jekwuuru Fero gwa ya sị, “Nke a bụ ihe Onyenwe anyị Chineke ndị Hibru kwuru, ‘Ọ bụ ruo olee mgbe ka ị ga-ajụ iwedata onwe gị ala nʼihu m? Hapụ ndị m ka ha gaa fee m ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ọ bụrụ na ị jụ ikwere ka ha gaa, nʼụtụtụ echi, aga m ezite igurube nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Igurube ndị a ga-ekpuchi ihu ala Ijipt niile, ka mmadụ ọbụla hapụ ịhụ ala anya. Ha ga-erichapụ ihe ndị fọdụrụ bụ nke ifufe na mkpụrụ mmiri ahụ na-emebighị, tinyere osisi niile na-eto eto nʼubi unu. ");
INSERT INTO ibo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ha ga-ejupụta nʼụlọ gị, na nʼụlọ ndị na-ejere gị ozi, na nʼụlọ ndị Ijipt niile. Ihe dị otu a bụ ụdị ihe na-emetụbeghị na mbụ, nke nna gị maọbụ nna nna gị ha na-ahụtụbeghị ụdị ya site na mgbe ha bidoro ibi nʼala a tutu ruo ugbu a.’ ” Mgbe ahụ, Mosis tụgharịrị hapụ Fero pụọ. ");
INSERT INTO ibo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ndị na-ejere Fero ozi bịakwutere ya, jụọ ya sị, “Ruo ole mgbe ka nwoke a ga-anọgide na-abụrụ anyị ihe ọnwụnwa? Hapụ ndị a ka ha laa, ka ha nwee ike ife Onyenwe anyị Chineke ha ofufe. Ọ bụ na ị ghọtabeghị na e bibiela Ijipt?” ");
INSERT INTO ibo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mgbe ahụ, a kpọghachiri Mosis na Erọn azụ nʼihu Fero. Ọ gwara ha sị, “Ọ dị mma, gaa feenụ Onyenwe anyị Chineke unu ofufe.” Fero jụkwara ha sị, “Olee ndị nʼetiti unu ga-eso unu jee?” ");
INSERT INTO ibo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosis zaghachiri sị, “Anyị niile na-aga, ụmụntakịrị na ndị okenye, ụmụ anyị ndị ikom na ndị inyom, igwe ehi anyị na igwe ewu na atụrụ anyị; nʼihi na anyị na-aga ime mmemme dị nsọ nye Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Fero sịrị, “Ka Onyenwe anyị nọnyere unu. Ma agaghị m ekwe ka unu na ndị inyom unu, na ụmụntakịrị unu gaa. O doro anya na unu na-atụ atụmatụ ọjọọ nʼime obi unu. ");
INSERT INTO ibo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ọ gaghị adị otu a! Jeenụ naanị unu bụ ndị ikom gaa fee Onyenwe anyị unu ofufe, nʼihi na nke a bụ ihe unu na-arịọ.” Mgbe ahụ a chụpụrụ Mosis na Erọn site nʼihu Fero. ");
INSERT INTO ibo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Onyenwe anyị gwara Mosis sị, “Setịpụ aka gị nʼala Ijipt ka igurube jupụta na ya, kpuchie ebe niile, richapụ ihe niile na-eto eto dị nʼala ahụ bụ nke ifufe na mkpụrụ mmiri ahụ hapụrụ.” ");
INSERT INTO ibo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ya mere, Mosis setịpụrụ mkpanaka ya nʼelu ala Ijipt, Onyenwe anyị mere ka ifufe nke si nʼebe anyanwụ si awa fee nʼụbọchị ahụ niile na abalị ahụ niile. Nʼụtụtụ ya, ifufe ahụ si nʼebe anyanwụ si awa bubatara igurube ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ha niile kpuchichara ala Ijipt niile, site nʼotu akụkụ ruo nʼakụkụ nke ọzọ. Nke a bụ mbata igurube kachasị ibe ya njọ nʼIjipt. Ijipt agaghị enwekwa nke dịka ya ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ha kpuchiri ala niile ruo mgbe ọchịchịrị gbachiri ya. Ha richapụrụ ihe niile na-eto nʼubi, na mkpụrụ niile na-amị nʼosisi, bụ nke ifufe na mkpụrụ mmiri ukwu ahụ hapụrụ. Nʼikpeazụ, ọ dịghị ahịhịa ndụ fọdụrụ nʼala ma nʼelu osisi nʼIjipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na-atụfughị oge, Fero ziri ozi ka a kpọọ Mosis na Erọn. Mgbe ha bịara, ọ gwara ha sị, “Emehiela m megide unu na Onyenwe anyị bụ Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Biko gbagharakwa m mmehie nke a, ma rịọọ Onyenwe anyị bụ Chineke unu ka o wepụrụ m ọnwụ nke a. Ekwere m nkwa na agaghị m ajụkwa ọzọ ka unu laa.” ");
INSERT INTO ibo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mosis hapụrụ Fero pụọ gaa kpeere Onyenwe anyị ekpere. ");
INSERT INTO ibo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ngwangwa, Onyenwe anyị zitere ikuku nke si nʼebe anyanwụ na-ada bịa, nke bupụrụ igurube ndị ahụ site nʼala Ijipt, buba ha nʼOsimiri Uhie. Ọ dịkwaghị otu igurube fọdụrụ nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma Onyenwe anyị mere ka obi Fero sie ike, o kweghị ka ụmụ Izrel gaa fee Chineke ofufe. ");
INSERT INTO ibo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mgbe ahụ, Onyenwe anyị gwara Mosis sị, “Setịpụ aka gị abụọ nʼeluigwe ka ọchịchịrị gbaa nʼala Ijipt niile.” ");
INSERT INTO ibo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mosis setịpụrụ aka ya nʼeluigwe. Oke ọchịchịrị gbara abalị atọ nʼala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ndị Ijipt ahụghị ihu ibe ha. Ha ahapụghịkwa ebe obibi ha abalị atọ ahụ. Ma ụmụ Izrel nwere ìhè nʼebe niile ha bi. ");
INSERT INTO ibo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mgbe ahụ, Fero kpọrọ Mosis sị ya, “Gaanụ fee Onyenwe anyị unu ofufe. Unu na ndị inyom na ụmụ unu nwere ike ịga, ma unu ga-ahapụ igwe ehi unu na igwe anụ ụlọ unu gaa.” ");
INSERT INTO ibo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mosis zara, “Ị ghaghị ịhapụ anyị ka anyị were ihe aja na aja nsure ọkụ, nke anyị chee nʼihu Onyenwe anyị Chineke anyị. ");
INSERT INTO ibo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Igwe anụ ụlọ anyị ga-esoro anyị. O nweghị ihe ọ bụla anyị ga-ahapụ nʼihi na anyị ga-eji ụfọdụ nʼime ha fee Onyenwe anyị Chineke anyị ofufe. Ọ bụkwa naanị mgbe anyị ruru nʼebe ahụ ka anyị nwere ike ịmata ihe anyị ga-eji fee Onyenwe anyị anyị ofufe.” ");
INSERT INTO ibo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma Onyenwe anyị mere ka obi Fero sie ike. O kweghị ka ha laa. ");
INSERT INTO ibo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fero gwara Mosis sị, “Si nʼihu m pụọ. Lezie anya hụ na ị bịaghị nʼihu m ọzọ. Ụbọchị ọbụla ị nwara bịa nʼihu m, onye nwụrụ anwụ ka ị ga-abụ.” ");
INSERT INTO ibo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosis zaghachiri Fero sị, “Ihe i kwuru dị mma, agaghị m abịakwa nʼihu gị ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Onyenwe anyị gwara Mosis, “Aga m ewetara Fero na Ijipt otu ihe otiti ọzọ. Mgbe nke a gasịrị, ọ ga-ekwe ka unu si nʼebe a pụọ. Nʼeziokwu, ọ ga-eji aka ya chụpụ unu nʼala ya. ");
INSERT INTO ibo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Gwa nwoke na nwanyị Izrel ọbụla ka ha jikere. Ha rịọọ ndị agbataobi ha bụ ndị Ijipt, ka ha nye ha ihe ọbụla e ji ọlaọcha na ọlaedo kpụọ.” ");
INSERT INTO ibo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Onyenwe anyị mere ka ụmụ Izrel nweta ihuọma nʼebe ndị Ijipt, na ndị agbataobi ha nọ. Nke ka nke, Mosis ghọrọ onye a na-asọpụrụ nʼetiti ndị ozi Fero na nʼihu ndị Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ya mere, Mosis sịrị, “Ihe a ka Onyenwe anyị kwuru, ‘Nʼihe dịka nʼetiti abalị taa, aga m agafe nʼime ala Ijipt niile. ");
INSERT INTO ibo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mgbe nke a na-eme, ndị ikom niile e bụ ụzọ mụọ nʼala Ijipt ga-anwụ, site nʼọkpara Fero, onye nọ ugbu a nʼocheeze ya, ruo nʼọkpara ohu onye nwanyị na-akwọ ihe na nkume ịkwọ nri, na ụmụ ehi niile e bụ ụzọ mụọ. ");
INSERT INTO ibo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mgbe nke a mere, iti mkpu akwa dị ukwuu ga-adị nʼala Ijipt, ụdị ga-ada nʼala Ijipt niile nke na-adịbeghị nʼala Ijipt, ụdị iti mkpu akwa nke na-agaghị adịkwa ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ma nʼebe ụmụ Izrel nọ, nkịta agaghị agbọ nwoke maọbụ nwanyị maọbụ anụmanụ ọbụla ụja.’ Site na nke a, ị ga-amata na Onyenwe anyị na-akpa oke nʼetiti ndị Izrel na ndị Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ndị ọchịchị gị ndị a ga-abịa gbuo ikpere rịọọ m sị m, ‘Biko kpọrọ ndị gị pụọ nʼobodo anyị.’ Mgbe ha mesịrị nke a, aga m apụ.” Iwe were Mosis mgbe o si nʼụlọ Fero na-apụta. ");
INSERT INTO ibo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Onyenwe anyị agwalarị Mosis sị ya, “Fero agaghị ege gị ntị. Nke a ga-enye m ohere ime ọtụtụ ihe ebube dị iche iche nʼIjipt.” ");
INSERT INTO ibo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ọ bụ ezie na Mosis na Erọn mere ihe ebube ndị a nʼihu Fero, ma Onyenwe anyị mere ka obi Fero sie ike, ka ọ hapụ ikwe ka ụmụ Izrel si nʼala ya pụọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Onyenwe anyị gwara Mosis na Erọn okwu nʼala Ijipt sị ha, ");
INSERT INTO ibo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ọnwa a ga-abụrụ unu isi ọnwa. Ọ ga-abụ ọnwa mbụ nke ọnwa niile nʼafọ unu. ");
INSERT INTO ibo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Gwa ọgbakọ ụmụ Izrel niile okwu sị ha, Nʼafọ ọbụla, nʼabalị iri nke ọnwa a, nwoke ọbụla ga-eweta nwa atụrụ nʼisi ezinaụlọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ezinaụlọ ọbụla nke dịkarịrị nta, nke na-enweghị ike iweta na iricha otu nwa atụrụ, ga-ejekwuru ezinaụlọ ọzọ dịkwa nta, ka ha jikọtaa onwe ha ọnụ weta nwa atụrụ. Ndị ga-ejikọta onwe ha ọnụ aghaghị ibu ụzọ pịa mmadụ ole ha ga-adị nwee ike richaa otu atụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nwa atụrụ a ga-eweta ga-abụ oke gbara naanị otu afọ, nke na-enweghị ntụpọ ọbụla nʼahụ ya. Unu nwere ike họrọ atụrụ maọbụ ewu. ");
INSERT INTO ibo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Unu ga-elekọta ya anya ruo nʼụbọchị nke iri na anọ nke ọnwa a. Nʼabalị ụbọchị ahụ ka ọgbakọ Izrel niile ga-egbu ya. ");
INSERT INTO ibo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ha ga-ewere ọbara ya tee nʼelu na nʼakụkụ ibo ọnụ ụzọ nke dị nʼezinaụlọ ha niile, ebe ha ga-anọ rie anụ atụrụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ha ga-eri anụ atụrụ a, nke a ga-ahụ nʼọkụ nʼabalị ahụ, ya na achịcha na-ekoghị eko, na ahịhịa ndụ na-elu ilu. ");
INSERT INTO ibo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","A gaghị eri nwa atụrụ ọbụla na ndụ, a gaghị esikwa ya esi, kama a ga-ahụ ya nʼọkụ. A ga-ahụ akụkụ ahụ nwa atụrụ ọbụla nʼọkụ, tinyere isi ya, ụkwụ ya na ihe dị nʼime afọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Unu agaghị erifọdụ ya ruo nʼụtụtụ echi ya. Nke ọbụla ga-afọdụ nʼabalị ahụ, a ga-akpọ ya ọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Otu a ka unu ga-esi rie ya: yirinụ uwe unu, na akpụkpọụkwụ unu. Jirikwanụ mkpara unu. Jikerenụ dịka ndị na-aga njem dị anya. Unu ga-eri anụ atụrụ a na achịcha na-ekoghị eko ngwangwa. A ga-akpọ oriri a Mmemme Ngabiga Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Aga m agafe nʼala Ijipt nʼabalị ahụ, igbu ndị ikom niile e bụ ụzọ mụọ nʼala Ijipt, ma mmadụ, ma anụmanụ. Aga m emekwa ka ikpe ọmụma bịakwasị chi ndị ọzọ ahụ niile Ijipt na-efe ofufe. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ọbara ahụ unu ga-ete nʼọnụ ibo ụlọ unu ga-abụ ihe ama igosi ebe unu bi, nʼihi na mgbe m hụrụ ọbara ahụ, aga m agafe unu. Ọ nwekwaghị ihe otiti ga-abịakwasị unu mgbe m ga-egbu ndị Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ụbọchị a ga-abụrụ unu ihe ncheta nye ọgbọ niile ndị na-eso nʼazụ. Unu ga-emekwa ya ka ọ bụrụ mmemme nye Onyenwe anyị. Ụkpụrụ nke na-adịgide adịgide site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ụbọchị asaa ka unu ga-eri achịcha na-ekoghị eko. Nʼụbọchị mbụ nke ụbọchị asaa ahụ, ka unu ga-esite nʼụlọ unu wezuga ihe iko achịcha niile, nʼihi na onye ọbụla riri nri nke ihe na-eko achịcha dị nʼime ya site nʼụbọchị mbụ ruo nʼụbọchị nke asaa, aghaghị ibipụ ya site nʼala Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Unu ga-ewere ụbọchị mbụ na ụbọchị nke asaa, nke mmemme ahụ, nwee mkpọkọta dị nsọ. Onye ọbụla agaghị arụ ọrụ ọbụla nʼụbọchị abụọ ndị a, karịakwa isi nri unu ga-eri. ");
INSERT INTO ibo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Unu ga-edobekwa mmemme achịcha na-ekoghị eko nʼihi na ọ bụ nʼime otu ụbọchị a ka m sitere nʼala Ijipt kpọpụta unu dịka usuu ndị agha. Unu ga-emekwa mmemme ụbọchị a ka ọ bụrụ ụkpụrụ nke na-adịgide adịgide site nʼọgbọ ruo nʼọgbọ ");
INSERT INTO ibo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Nʼọnwa mbụ, nʼanyasị nke ụbọchị nke iri na anọ, ka unu ga-eri achịcha a na-ejighị ihe na-eko achịcha mee ruo nʼanyasị nke ụbọchị iri abụọ na otu. ");
INSERT INTO ibo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Nʼime ụbọchị asaa ahụ, agaghị ahụ ihe na-eko achịcha nʼụlọ unu. A ga-esite nʼọgbakọ ndị Izrel bipụ onye ọbụla riri ihe ọbụla nke ihe na-eko achịcha dị nʼime ya. Iwu a dịrị ndị ọbịa niile nʼala Izrel, dịkwara ndị nwa afọ ala. ");
INSERT INTO ibo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Unu agaghị eri ihe ọbụla e ji ihe na-eko achịcha mee. Nʼebe obibi unu niile, ọ bụ naanị achịcha na-ekoghị eko ka unu ga-eri.” ");
INSERT INTO ibo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mgbe ahụ, Mosis kpọkọtara ndị okenye ụmụ Izrel niile gwa ha okwu sị, “Gaanụ họpụta ụmụ atụrụ nʼihi agbụrụ unu niile, gbuonụ atụrụ ngabiga ndị a. ");
INSERT INTO ibo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Were ahịhịa hisọp, denye ya nʼọbara si nʼatụrụ ndị a nke a ga-awụnye nʼefere, tee ya nʼelu ibo na nʼakụkụ abụọ nke ọnụ ụzọ ụlọ unu. Onye ọbụla nʼime unu agaghị apụ nʼezi tutu ruo ụtụtụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mgbe Onyenwe anyị ga-agafe igbu ndị Ijipt, ọ ga-ahụ ọbara ahụ nʼawara na mbudo ibo ọnụ ụzọ ụlọ unu. Ọ ga-agafe ụlọ unu, gharakwa ikwe ka onye mbibi bata nʼụlọ unu gbuo unu. ");
INSERT INTO ibo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Unu ga-edobe mmemme a dịka iwu ga-adịgide nye unu na ụmụ unu. ");
INSERT INTO ibo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mgbe unu batara nʼala ahụ Onyenwe anyị ga-enye unu dịka o kwere na nkwa, unu ga-edobe ofufe a. ");
INSERT INTO ibo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mgbe ụmụ unu ga-ajụ unu ajụjụ sị, ‘Gịnị ka ofufe a pụtara?’ ");
INSERT INTO ibo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Unu ga-azaghachi ha sị, ‘Ọ bụ aja ngabiga anyị na-achụrụ Onyenwe anyị nʼihi na ọ gafere ụlọ ụmụ Izrel nʼala Ijipt, mgbe o gburu ndị Ijipt, ma o nweghị onye ọbụla nʼime anyị o gburu.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ụmụ Izrel mezuru ihe niile Onyenwe anyị gwara ha site nʼọnụ Mosis na Erọn. ");
INSERT INTO ibo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nʼime etiti abalị ụbọchị ahụ, Onyenwe anyị gburu ndị ikom niile e bụ ụzọ mụọ nʼala Ijipt, malite nʼọkpara Fero onye nọ nʼocheeze ya, ruo nʼọkpara nke onye Ijipt nọ nʼụlọ mkpọrọ olulu. O gbukwara ụmụ anụ ụlọ niile e bụ ụzọ mụọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Nʼabalị ahụ kwa, Fero na ndị ozi ya, na ndị Ijipt niile biliri. Oke iti mkpu akwa dakwara nʼala Ijipt, nʼihi na ọ dịghị ezinaụlọ ọnwụ na-erughị. ");
INSERT INTO ibo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nʼotu abalị ahụ, Fero zipụrụ ozi ka a kpọ Mosis na Erọn. Mgbe ha bịara, ọ gwara ha sị, “Ngwa bilienụ, unu bụ ụmụ Izrel niile. Kewapụnụ onwe unu site nʼetiti anyị. Gaanụ, fee Onyenwe anyị unu ofufe dịka unu rịọrọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Durunụ igwe ehi na atụrụ unu mgbe unu na-aga. Gọziekwanụ m mgbe unu na-apụ.” ");
INSERT INTO ibo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ndị Ijipt gbalịrị ime ka ụmụ Izrel hapụ ha ngwangwa. Ha sịrịtara onwe ha, “Ọ bụrụ na ụmụ Izrel ahapụghị anyị ugbu a, anyị niile ga-anwụkwa.” ");
INSERT INTO ibo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ya mere, ụmụ Izrel buuru ụtụ ọka e ji eme achịcha na-ekoghị eko, nke ha tinyere nʼefere e ji agwakọta ya. Ha ji akwa kechie ha, bukwasị ha nʼubu ha. ");
INSERT INTO ibo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ha mekwara ihe ndị ọzọ dịka Mosis gwara ha. Ha rịọrọ ndị Ijipt ka ha nye ha ihe iji ngwa nke ọlaọcha na ọlaedo, na uwe. ");
INSERT INTO ibo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Onyenwe anyị nyere ndị ya amara nʼihu ndị Ijipt, ha nyere ha ihe niile ha rịọrọ. Site nʼụzọ dị otu a, ụmụ Izrel napụtara ndị Ijipt ihe niile ha ji biri nʼụlọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Mgbe nke a gasịrị, ụmụ Izrel malitere ije ha site na Ramesis. Mgbe ha hapụrụ Ramesis, na-eje Sukọt, ha dị narị puku ndị ikom isii, na-agụghị ndị inyom na ụmụntakịrị. ");
INSERT INTO ibo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ọtụtụ mmadụ dị iche iche sooro ha nʼije ha. Ha dukwa igwe anụ ụlọ, igwe ewu na atụrụ ha, nke dị ukwu nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ha ji ụtụ ọka ha si Ijipt buputa mee achịcha na-ekoghị eko. Nʼihi na a chụpụrụ ha achụpụ site nʼIjipt, ha enweghị ezi ohere kwadooro onwe ha ihe oriri. ");
INSERT INTO ibo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tupu ha ahapụ ala Ijipt, ụmụ Izrel ebiela nʼebe ahụ narị afọ anọ na iri afọ atọ. ");
INSERT INTO ibo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Mgbe narị afọ anọ na iri afọ atọ zuru, nʼụbọchị ahụ o zuru, usuu ndị Onyenwe anyị niile hapụrụ Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Onyenwe anyị chere nche nʼabalị ụbọchị ahụ maka ịkpọpụta ha site nʼala Ijipt. Nʼihi ya, abalị ụbọchị ahụ bụ mgbe pụrụ iche nye ụmụ Izrel maka iji iche nche sọpụrụ Onyenwe anyị nʼọgbọ ha niile. ");
INSERT INTO ibo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Onyenwe anyị kpọrọ Mosis na Erọn gwa ha sị, “Ndị a bụ usoro iwu metụtara Mmemme Ngabiga: “Onye mba ọzọ agaghị eri anụ nwa atụrụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ohu ọbụla a kwụrụ ụgwọ nʼisi ya ga-eri ya naanị ma e biri ya ugwu. ");
INSERT INTO ibo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ohu e goro ọrụ, maọbụ onye ọbịa ọbụla agaghị eri ya. ");
INSERT INTO ibo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“A ga-eri ya naanị nʼime otu ụlọ. Ọ gaghị apụ nʼezi. Unu agaghị atapịa ọkpụkpụ ọbụla nke nwa atụrụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nzukọ niile nke ụmụ Izrel ga-eme Mmemme Ngabiga a. ");
INSERT INTO ibo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Onye mba ọzọ bi nʼetiti unu chọrọ isoro unu na Mmemme Ngabiga Onyenwe anyị aghaghị ibi ndị ikom niile nọ nʼezinaụlọ ya ugwu. Mgbe ahụ, ọ ga-abịaru nso isoro na mmemme, nʼihi na a ga-agụ ya dịka nwa afọ ala. Ọ dịghị onye ikom a na-ebighị ugwu ga-eri nri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Otu iwu a dịrị nwa afọ ala na ndị ọbịa niile bi nʼala Izrel.” ");
INSERT INTO ibo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ụmụ Izrel mere ihe ndị a niile, dịka Onyenwe anyị nyere ha nʼiwu site nʼọnụ Mosis na Erọn. ");
INSERT INTO ibo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ọ bụkwa nʼotu ụbọchị ahụ ka Onyenwe anyị sitere nʼala Ijipt dupụta ụmụ Izrel, dịka usuu ha niile si dị. ");
INSERT INTO ibo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Dooro m nsọ onye ọbụla bụ ọkpara, onye ọbụla e bụ ụzọ mụọ nʼetiti ụmụ Izrel, na nʼetiti mmadụ ma nʼetiti anụ ụlọ, nke m ka ọ bụ.” ");
INSERT INTO ibo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosis gwara ndị Izrel sị, “Chetanụ ụbọchị taa, ụbọchị unu si nʼala Ijipt pụta, ala ebe unu bụ ndị ohu, nʼihi na Onyenwe anyị sitere nʼike aka ya dị ukwu kpọpụta unu site nʼebe ahụ. Unu erikwala achịcha ọbụla e ji ihe na-eko achịcha mee. ");
INSERT INTO ibo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Taa, nʼọnwa Abib, bụ ụbọchị unu na-ahapụ ala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mgbe Onyenwe anyị dubatara unu nʼala ndị Kenan, ndị Het, ndị Amọrait, ndị Hiv na ndị Jebus bi nʼime ya, bụ ala ahụ ọ ṅụrụ nʼiyi nye nna nna unu ha na ọ ga-enye unu, ala mmiri ara ehi na mmanụ aṅụ na-eru na ya, unu ga-eme ofufe mmemme a nʼọnwa a. ");
INSERT INTO ibo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Unu ga-eri achịcha na-ekoghị eko ụbọchị asaa ahụ. Nʼụbọchị nke ikpeazụ nʼime ụbọchị asaa ahụ, unu ga-eme mmemme oke oriri nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Rienụ achịcha na-ekoghị eko nʼime ụbọchị asaa ndị ahụ. Achịcha e ji ihe na-eko achịcha mee agaghị adị nʼụlọ unu. Achịcha e ji ihe na-eko achịcha mee agaghị adị nʼoke ala unu niile. ");
INSERT INTO ibo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Nʼoge ọbụla ị na-eme mmemme a, kọwaara nwa gị nwoke ihe kpatara i ji eme mmemme a, si ya, ‘Ana m eme mmemme a maka icheta ihe Onyenwe anyị meere m, mgbe m si nʼIjipt pụta.’ ");
INSERT INTO ibo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Imezu mmemme a ga-adịrị unu dịka ihe ịrịbama nʼala unu, dịrịkwa ka ihe ngosi nʼegedege ihu unu, ichetara unu na Onyenwe anyị ji aka ike ya dupụta anyị site nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Unu ga na-eme mmemme a nʼoge a kara aka nʼafọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mgbe Onyenwe anyị dubatara unu nʼala ndị Kenan, nyefee unu ala ahụ dịka ọ ṅụrụ nʼiyi nye nna nna unu ha, ");
INSERT INTO ibo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","unu ga-enyefe Onyenwe anyị ụmụ ndị ikom unu niile e bụ ụzọ mụọ. Ọzọ, ụmụ oke anụ ụlọ niile e bụ ụzọ mụọ bụ nke Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Jiri nwa atụrụ gbapụta nwa ịnyịnya ibu mbụ e bụ ụzọ mụọ. Ọ bụrụ na unu achọghị ịgbara nwa ịnyịnya ibu ahụ, unu aghaghị ịgbaji ya olu. Ma unu aghaghị ịgbara ụmụ ndị ikom niile e bụ ụzọ mụọ. ");
INSERT INTO ibo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Nʼoge dị nʼihu, mgbe nwa gị nwoke ga-ajụ gị sị, ‘Gịnị ka ihe ndị a pụtara?’ Ị ga-azaghachi ya sị, ‘Onyenwe anyị jiri aka ike dị ukwu dupụta anyị site nʼIjipt, site nʼala nke ohu. ");
INSERT INTO ibo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mgbe Fero mesiri obi ya ike, jụ ka anyị si nʼala ya pụọ, Onyenwe anyị gburu ụmụ ndị ikom niile e bụ ụzọ mụọ nʼala Ijipt, ma mmadụ ma anụ ụlọ. Nʼihi ya, ana m eji ụmụ oke anụ ụlọ niile e bụ ụzọ mụọ achụ aja nye Onyenwe anyị. Ma ụmụ m ndị ikom niile e bụ ụzọ mụọ ka m na-agbapụta.’ ");
INSERT INTO ibo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mmemme a ga-adị ka ihe ịrịbama nʼanya unu, dịrịkwa ka ihe ngosi nʼegedege ihu unu, ichetara unu na Onyenwe anyị ji aka ike ya dupụta anyị site nʼala Ijipt.” ");
INSERT INTO ibo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mgbe Fero mesịrị kwere ka ụmụ Izrel laa, Chineke edughị ha site nʼụzọ ahụ gafere ala ndị Filistia. Ọ bụ ezie na ụzọ ahụ dị nso karịa. Chineke mere nke a nʼihi na o chere nʼobi ya sị, “Ọ bụrụ na ndị a ezute agha, ha nwere ike ịgbanwe obi ha tụgharịa ịlaghachi azụ nʼIjipt.” ");
INSERT INTO ibo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ya mere, Chineke duuru ha ga nʼụzọ Osimiri Uhie, nke gara nʼụzọ nke ọzara. Ụmụ Izrel kwadokwara akwado ibu agha mgbe ha si nʼala Ijipt pụọ. ");
INSERT INTO ibo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mosis buuru ọkpụkpụ Josef mgbe ha na-ala. Nʼihi na o mere ka ụmụ Izrel ṅụọ iyi na ha ga-eme otu a, na-asị, “Chineke ga-eleta unu nʼezie, mgbe ahụ, unu aghaghị iburu ọkpụkpụ m si nʼebe a pụọ.” ");
INSERT INTO ibo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ha si Sukọt bilie ije, maa ụlọ ikwu ha na Etam, na nsọtụ ọzara. ");
INSERT INTO ibo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Onyenwe anyị ji ogidi igwe ojii na-eje nʼihu ha nʼehihie, idu ha nʼụzọ ha niile. Nʼabalị, o ji ogidi ọkụ, inye ha ìhè ka ha nwee ike ịga njem nʼehihie nakwa nʼabalị. ");
INSERT INTO ibo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ma ogidi igwe ojii nʼehihie na ogidi ọkụ ahụ nʼabalị, ọ dịghị nke hapụrụ ọnọdụ ya nʼihu ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis, ");
INSERT INTO ibo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Gwa ụmụ Izrel ka ha chigharịa azụ jee maa ụlọ ikwu ha na ncherita ihu Pi Hahirot, nke dị nʼetiti Migdol na osimiri. Ọ bụ nʼakụkụ osimiri, na ncherita ihu obodo Baal-Zefọn ka ha ga-ama ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fero ga-asị banyere ụmụ Izrel, ‘Ha na-awagharị gburugburu ala ahụ nʼọnọdụ mgbagwoju anya ebe ọzara riri ha.’ ");
INSERT INTO ibo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Aga m eme ka obi Fero sie ike ka ọ chụso unu ọsọ nʼazụ, ma m ga-ewetara onwe m otuto site na Fero na ndị agha ya niile. Ndị Ijipt niile ga-ama na mụ onwe m bụ Onyenwe anyị.” Ndị Izrel mekwara otu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mgbe a gwara eze Ijipt na ndị a agbaala ọsọ, obi Fero na ndị ozi ya gbanwere megide ndị Izrel. Ha sịrị, “Gịnị bụ ihe anyị mere, site na izipụ ndị Izrel nʼọrụ ife anyị?” ");
INSERT INTO ibo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Na-atụfughị oge, Fero rigoro nʼelu ụgbọ agha ya, duru ndị agha ya ịchụso ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ọ chịịrị ụgbọ agha dị narị isii e leziri anya họpụta, tinyere ụgbọ agha Ijipt niile. Ndịisi agha ndị Ijipt nọcha nʼelu ha niile. ");
INSERT INTO ibo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Onyenwe anyị mere ka obi Fero eze Ijipt sie ike. Ọ chụsoro ụmụ Izrel, ndị na-aga nʼihu nʼije ha, na-atụghị egwu maọbụ ịda mba. ");
INSERT INTO ibo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ndị Ijipt chụsoro ha ọsọ, ịnyịnya Fero na ụgbọ agha, na ndị na-agba ịnyịnya na ndị agha ndị ọzọ chụsoro ndị Izrel ọsọ chụkwute ha nʼebe ha na-ezu ike nʼakụkụ osimiri dị nso na Pi Hahirot na ncherita ihu Baal-Zefọn. ");
INSERT INTO ibo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mgbe ndị agha Fero na-abịa nso, ndị Izrel lere anya nʼazụ, hụ ndị Ijipt ka ha na-abịa nso. Ha tụrụ egwu, tie mkpu akwa, kpọkuo Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ha jụrụ Mosis sị, “Ọ bụ na o nweghị ili dị nʼala Ijipt, i ji kwagide anyị ka anyị niile bịa nwụọ nʼebe a nʼọzara? Gịnị mere i ji kwagide anyị ka anyị hapụ Ijipt? ");
INSERT INTO ibo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ọ bụ na anyị agwaghị gị nʼala Ijipt si gị, ‘Hapụ anyị ka anyị nọgide na-ejere ndị Ijipt ozi?’ Ọ gara akara anyị mma ị bụ ohu ndị Ijipt karịa ịnwụ nʼọzara.” ");
INSERT INTO ibo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mosis zaghachiri ha sị, “Unu atụla egwu. Guzosienụ ike. Unu ga-ahụ ụzọ dị ebube Onyenwe anyị ga-esi zọpụta unu taa. Ndị Ijipt a unu na-ahụ taa, unu agaghị ahụkwa ha ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nọrọnụ jii. Onyenwe anyị ga-alụrụ unu ọgụ.” ");
INSERT INTO ibo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Gịnị mere i ji na-akpọku m. Gwa ụmụ Izrel ka ha gaa nʼihu. ");
INSERT INTO ibo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Welie mkpanaka gị elu. Setịpụ ya nʼelu osimiri ahụ ka o kewaa abụọ. Ụzọ ga-adịkwa nʼetiti osimiri ahụ. Ụmụ Izrel ga-esitekwa nʼala akọrọ gafee. ");
INSERT INTO ibo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Aga m eme ka obi ndị Ijipt sie ike, ka ha sorokwa unu nʼazụ banye. Aga m ewetara onwe m otuto site na Fero, na ndị agha niile, na ụgbọ agha niile nakwa ndị na-agba ịnyịnya ya. ");
INSERT INTO ibo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nʼoge ahụ, ndị Ijipt ga-amata na mụ onwe m bụ Onyenwe anyị. M ga-enweta nsọpụrụ site na Fero, na ụgbọ agha ya niile, na ndị na-agba ịnyịnya ya.” ");
INSERT INTO ibo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mgbe ahụ, mmụọ ozi Chineke, onye na-aga nʼihu ndị agha Izrel, sitere nʼihu pụọ gaa nọdụ nʼazụ ha. Otu a kwa, ogidi igwe ojii ahụ sitere nʼihu gaa nʼazụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Nke a mere ka ogidi igwe ojii ahụ dịrị nʼetiti ụmụ Izrel na ndị Ijipt. Nʼabalị ụbọchị ahụ, Onyenwe anyị mere ka ogidi igwe ojii ahụ nye ụmụ Izrel ìhè, ma ndị Ijipt nọgidere nʼọchịchịrị. Otu a, ndị Ijipt enweghị ike bịarute nʼebe ụmụ Izrel nọ. ");
INSERT INTO ibo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mgbe ahụ, Mosis setịpụrụ aka ya nʼelu Osimiri Uhie ahụ. Onyenwe anyị ji oke ifufe si nʼọwụwa anyanwụ, nke fere nʼabalị ahụ niile, nughachi osimiri ahụ, mee ka osimiri ahụ kebie ụzọ abụọ, ka ụzọ pụta nʼala osimiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ụmụ Izrel sitere nʼetiti osimiri ahụ gafee. Mmiri osimiri ahụ ghọọrọ mgbidi nʼaka nri ha ma nʼaka ekpe ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mgbe ndị agha Ijipt na-achụ ha ọsọ hụrụ ha ka ha na-agafe, ha sogidere ha baa, ọ bụladị nʼetiti osimiri ahụ. Ndị agha Ijipt niile sooro ha, ya bụ, ụgbọ agha Fero, ndị agha ya na ndị na-agba ịnyịnya ya niile. ");
INSERT INTO ibo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nʼisi ụtụtụ echi ya, Onyenwe anyị ledatara anya site nʼogidi igwe ojii ahụ na-enye ihe. O legidere ndị agha Ijipt anya, tinyekwa ha ụjọ nʼobi nke mere na ha amakwaghị onwe ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","O mebiri ụkwụ ụgbọ agha ha mee ka o siere ịnyịnya ha ike ịdọkpụ ụgbọ agha ndị ahụ. Mgbe ahụ, ndị Ijipt kwuru sị, “Ka anyị sinụ nʼịchụ ndị Izrel gbapụ, nʼihi na Onyenwe anyị na-alụrụ ha ọgụ, na-emegidekwa anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Mgbe ụmụ Izrel gafesịrị ruo nʼakụkụ nke ọzọ nke osimiri ahụ, Onyenwe anyị gwara Mosis okwu sị, “Setịpụ aka gị ọzọ ka mmiri ahụ kpuchigide ndị Ijipt, na ụgbọ agha ha niile, na ndị na-agba ịnyịnya ya.” ");
INSERT INTO ibo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mosis setịpụrụ aka nʼelu osimiri ahụ. Nʼụtụtụ ya, mmiri osimiri ahụ sọghachiri gaa ebe ọ nọ na mbụ. Ndị Ijipt chọsịrị ụzọ ha si agbapụ ike, ma Onyenwe anyị mere ka osimiri ahụ kpuchie ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Osimiri ahụ kpuchigidere ụgbọ agha ha niile, na ndị na-agba ịnyịnya, na ndị agha Fero niile ndị chụụrụ ụmụ Izrel baa nʼime osimiri ahụ. O nweghị otu onye nʼime ha fọdụrụ ndụ. ");
INSERT INTO ibo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ma ụmụ Izrel esitelarị nʼala nke mmiri kọrọ gafee osimiri ahụ. Mgbe ha na-agafekwa, akụkụ abụọ nke osimiri ahụ guzoro ọtọ dịka mgbidi, nʼaka nri ha ma nʼaka ekpe ha. ");
INSERT INTO ibo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Site nʼụzọ dị otu a, Onyenwe anyị zọpụtara ụmụ Izrel site nʼaka ndị Ijipt. Ụmụ Izrel hụkwara ozu ndị Ijipt nʼikpere mmiri osimiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ụmụ Izrel tụrụ egwu Onyenwe anyị mgbe ha hụrụ ihe ịrịbama ndị a Onyenwe anyị ji zọpụta ha site nʼaka ndị Ijipt. Ha kwenyere na Onyenwe anyị, kwenyekwa na Mosis ohu ya. ");
INSERT INTO ibo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mgbe ahụ, Mosis na ụmụ Izrel bụkuru Onyenwe anyị abụ dị otu a sị, “Aga m abụku Onyenwe anyị abụ nʼihi na o buliela onwe ya elu nke ukwuu. Ọ tụnyela ịnyịnya na onye na-agba ya nʼosimiri. ");
INSERT INTO ibo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Onyenwe anyị bụ ike m na abụ m. Ọ ghọrọla m nzọpụta. Ọ bụ Chineke m, aga m etokwa ya, Chineke nke nna m, aga m ebulikwa ya elu. ");
INSERT INTO ibo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Onye na-ebu agha ka Onyenwe anyị bụ. Nʼezie, aha ya bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ụgbọ agha Fero na usuu ndị agha ya, ka ọ tụnyere nʼosimiri ahụ. Ndịisi agha Fero, ndị ahọrọ ahọ, ka o mere ka Osimiri Uhie rie. ");
INSERT INTO ibo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ogbu osimiri ahụ ekpuchiela ha. Nʼime mmiri ahụ dị omimi ka ha rịdaruru dịka nkume. ");
INSERT INTO ibo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Aka nri gị Onyenwe anyị, dị ike, dịkwa ebube. Aka nri gị, Onyenwe anyị na-etipịasị ndị iro. ");
INSERT INTO ibo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Nʼoke ike nke ịdị elu gị, Ị lụgbuola ndị niile na-ebili imegide gị. I zipụrụ iwe gị dị ọkụ, o repịara ha dịka igbugbo ọka. ");
INSERT INTO ibo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I sitere na nkuume nke oghere imi gị, mee ka mmiri osimiri guzoro ọtọ. Mmiri ahụ na-erugharị erugharị guzoro nʼotu ebe dịka mgbidi; ogbu mmiri kpụkọtara rahụ nʼala ala nsọtụ nke osimiri. ");
INSERT INTO ibo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Onye iro nyara isi sị, ‘Aga m achụso ha, gafee ha. Aga m ekesa ihe a kwatara nʼagha. Nyejuo onwe m afọ site na ha. Aga m amịpụta mma agha m. Jiri aka m laa ha nʼiyi.’ ");
INSERT INTO ibo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ma i kupụrụ ikuku si gị nʼimi pụta, osimiri riri ha, ha mikpuru nʼime osimiri ukwu ahụ dịka igwe. ");
INSERT INTO ibo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Onye dịka gị Onyenwe anyị, nʼetiti chi niile? Onye dịka gị? Onye dị ebube nʼịdị nsọ. Onye otuto ya na-eyi egwu. Onye na-arụ ọrụ dị ebube? ");
INSERT INTO ibo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“I setịpụrụ aka nri gị, ala meghere ọnụ ya loo ndị iro gị niile. ");
INSERT INTO ibo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Site nʼebere gị, i dupụtara ndị ị zọpụtara. Sitekwa nʼike gị dị ebube, i duru ha ruo nʼebe obibi gị dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ụwa niile nụrụ ya, maa jijiji. Ndị Filistia ka oke ihe mgbu bịakwasịrị. ");
INSERT INTO ibo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ndị eze Edọm ga-anọ nʼọnọdụ obi ịlọ mmiri. Ndị ndu Moab niile ga-abụ ndị ọma jijiji ga-ejidekwa, ndị Kenan niile nʼọnọdụ ịtụ egwu ga-agbaze; ");
INSERT INTO ibo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","oke egwu na oke ụjọ ejidela ha. Site nʼike nke aka gị, ha ga-anọ jụụ dịka nkume, tutu ruo mgbe ndị gị, Onyenwe anyị, gafechara, tutu ruo mgbe ndị gị, ndị ị zụtara nye onwe gị, gafechara. ");
INSERT INTO ibo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Gị onwe gị ga-akpọbata ha, kụọ ha dịka mkpụrụ, nʼelu ugwu nke ihe nketa gị. Nʼebe ahụ, Onyenwe anyị, i mere ka ọ bụrụ ebe obibi gị, ebe nsọ ahụ, Onyenwe anyị, nke i ji aka gị tọọ ntọala ya. ");
INSERT INTO ibo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Onyenwe anyị ga-abụ eze ruo mgbe niile ebighị ebi.” ");
INSERT INTO ibo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mgbe ịnyịnya Fero, na ụgbọ agha ya, na ndị na-agba ịnyịnya, gbabanyere nʼosimiri, Onyenwe anyị mere ka mgbidi mmiri ahụ dagbuo ha. Ma ụmụ Izrel sitere nʼala mmiri kọrọ gafee. ");
INSERT INTO ibo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nʼoge ahụ, Miriam onye amụma nwanyị, nwanne Erọn weere ịgba iti egwu nʼaka ya, duo ndị inyom ndị so ya, jiri ịgba egwu nke ha na-etekwa egwu. ");
INSERT INTO ibo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam bụrụ abụ sị ha, “Bụkuonụ Onyenwe anyị abụ, nʼihi na ọ bụ onye e buliri elu nke ukwu. Ịnyịnya na ndị na-agba ha, ka ọ tụnyere nʼime osimiri.” ");
INSERT INTO ibo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mgbe ihe ndị a mesịrị, Mosis nọgidere na-edu ụmụ Izrel. Ha sitere nʼOsimiri Uhie ahụ bilie ije, jeruo ọzara Shua. Ha jere ije nʼime ọzara abalị atọ, ma ha achọtaghị mmiri ọṅụṅụ ");
INSERT INTO ibo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mgbe ha ruru Mara, ha enweghị ike ịṅụ mmiri dị nʼebe ahụ, nʼihi na mmiri ahụ na-elu ilu. (Ọ bụ ilu ilu a mere e ji kpọọ ya Mara.) ");
INSERT INTO ibo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nʼebe a, ụmụ Izrel malitere itamu ntamu, megide Mosis sị, “Olee mmiri anyị ga-aṅụ?” ");
INSERT INTO ibo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mosis tikuru Onyenwe anyị mkpu akwa. Onyenwe anyị gosiri Mosis osisi ọ ga-atụnye nʼime mmiri ahụ. Mgbe Mosis mere otu a, mmiri ahụ malitere ịdị ụtọ ọṅụṅụ. Ọ bụkwa na Mara ka Onyenwe anyị nọ nye ha ụkpụrụ ya na iwu ya maka iji ya nwalee ha. ");
INSERT INTO ibo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ọ sịrị, “Ọ bụrụ na unu ga-ege ntị nke ọma nʼokwu Onyenwe anyị Chineke unu, mee ihe ziri ezi nʼanya ya, ọ bụrụkwa na unu eleruo anya idebe iwu ya na ụkpụrụ ya niile, ọ dịghị ọrịa nke m tinyere nʼahụ ndị Ijipt nke m ga-etinye nʼahụ unu. Nʼihi na mụ onwe m bụ Onyenwe anyị, onye na-agwọ unu ọrịa niile.” ");
INSERT INTO ibo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ha bịaruru nʼobodo Elim, ebe e nwere isi iyi mmiri ala na-asọpụta dị iri na abụọ, na iri osisi nkwụ asaa. Ụmụ Izrel mara ụlọ ikwu ha nʼakụkụ mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ọgbakọ ụmụ Izrel niile hapụrụ obodo Elim, jere ije bịarute nʼọzara Sin nke dị nʼetiti Saịnaị na Elim. Ha bịaruru nʼebe ahụ nʼabalị iri na ise nke ọnwa abụọ, site na mgbe ha hapụrụ Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nʼọzara ahụ, nzukọ ahụ niile tamuru ntamu megide Mosis na Erọn. ");
INSERT INTO ibo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ụmụ Izrel gwara ha sị, “Ọ gaara adị anyị mma ma a sị na Onyenwe anyị gburu anyị nʼala Ijipt. Nʼebe ahụ ite anụ dị iche iche na-adọ nʼihu anyị, anyị na-erikwa ụdị nri ọbụla anyị chọrọ. Ugbu a, i dubatala anyị nʼọzara ka anyị niile nwụọ nʼagụụ.” ");
INSERT INTO ibo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Onyenwe anyị gwara Mosis okwu sị, “Lee anya, aga m esi nʼeluigwe zitere unu achịcha. Onye ọbụla ga-aga tụtụkọtara onwe ya ihe oriri ụbọchị ọbụla dịka ọ chọrọ. Aga m eji nke a lee ha ule ịmata ma ha ga-eme ihe m nyere ha nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Gwa ha na nʼụbọchị nke isii, ha ga-ewere nri ha ga-ericha nʼụbọchị ahụ, ma nri ha ga-eri nʼụbọchị nke asaa, ka ha ga-achịkọta nʼụbọchị nke isii.” ");
INSERT INTO ibo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mosis na Erọn kpọkọtara ụmụ Izrel sị ha, “Nʼanyasị a ka unu ga-amata na ọ bụ Onyenwe anyị dupụtara unu site nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Unu ga-ahụkwa ebube Onyenwe anyị nʼụtụtụ echi, nʼihi na Onyenwe anyị anụla ntamu unu megide ya. Onye ka anyị bụ unu ga-eji na-atamu ntamu megide anyị?” ");
INSERT INTO ibo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosis kwukwara sị, “Mgbe Onyenwe anyị nyere unu anụ unu ga-eri nʼanyasị a, nyekwa unu achịcha ga-eju unu nʼụtụtụ, unu ga-amata na ọ bụ Onyenwe anyị, nʼihi ọ nụla ntamu unu megide ya. Onye ka anyị bụ? Ọ bụghị anyị ka unu na-atamu megide kama ọ bụ Onyenwe anyị ka unu na-atamu megide.” ");
INSERT INTO ibo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mgbe ahụ, Mosis gwara Erọn okwu sị ya, “Gwa nzukọ Izrel niile okwu sị ha, ‘Pụtanụ bịa nʼihu Onyenwe anyị, nʼihi na ọ nụla ntamu unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mgbe Erọn nọ na-agwa nzukọ Izrel okwu, ha lepụrụ anya nʼọzara hụ ebube Onyenwe anyị ka ọ pụtara ihe nʼigwe ojii. ");
INSERT INTO ibo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Anụla m ntamu nke ụmụ Izrel na-atamu. Gwa ha sị, ‘Nʼanyasị taa, unu ga-ata anụ, nʼụtụtụ echi unu ga-eri achịcha. Mgbe ahụ, unu ga-amata na abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nʼoge uhuruchi ụbọchị ahụ, nnụnụ kweel bịara kpuchie ọmụma ụlọ ikwu ahụ. Nʼisi ụtụtụ echi ya, igirigi dakwara gburugburu ọmụma ụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mgbe ala kọrọ mmiri igirigi ahụ, ihe dịka achịcha mbadamba nta jupụtara nʼala ọzara ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Mgbe ụmụ Izrel hụrụ ya, ha jụrịtara onwe ha ajụjụ sị, “Gịnị bụ nke a?” Mosis zaghachiri ha sị, “Ọ bụ achịcha Onyenwe anyị nyere unu ka unu rie. ");
INSERT INTO ibo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ihe ndị a bụ iwu Onyenwe anyị nyere, ‘Ka onye ọbụla chịkọta naanị nke ọ ga-ericha. Ihe ọtụtụ ọmaa maka otu onye dịka ọnụọgụgụ ha si dị nʼezinaụlọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ụmụ Izrel mere dịka a gwara ha, ụfọdụ chịkọtara nke hiri nne, ụfọdụ nke dị nta. ");
INSERT INTO ibo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mgbe ha ji ihe ọtụtụ ọmaa tụọ ya, ha chọpụtara na onye chịkọtara hie nne enweghị karịa nke zuru ya, onye chịkọtakwara nke nta, ọ dịghị ihe fọdụrụ ya inweta. Onye ọbụla chịkọtara dị ka ihe ga-ezuru ya si dị. ");
INSERT INTO ibo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mosis gwara ha sị, “Ka onye ọbụla hụ na o nweghị nke ga-afọdụ ruo ụtụtụ echi ya.” ");
INSERT INTO ibo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ma ụfọdụ nʼime ha egeghị Mosis ntị. Ha rifọrọ nri ahụ debe ya. Ma mgbe chi echi ya bọrọ, ha chọpụtara na ha ereela ure jupụta nʼikpuru, ma na-esikwa isi dị njọ. Mosis were iwe dị ukwuu megide ụmụ Izrel nʼihi ya. ");
INSERT INTO ibo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Site nʼụbọchị ahụ, gaa nʼihu, ezinaụlọ ọbụla na-ewebata nri nʼụtụtụ ọbụla, dịka mkpa ha siri dị. Mgbe anwụ wara, nri ahụ niile fọdụrụ na-agbaze. ");
INSERT INTO ibo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nʼụbọchị nke isii, ha na-ewere nri okpukpu abụọ karịa ka ha na-ewe nʼụbọchị ndị ọzọ. Mgbe ndịisi nzukọ Izrel hụrụ mgbanwe dị otu a, ha bịara kọọrọ Mosis. ");
INSERT INTO ibo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mosis zara sị ha, “Nke a bụ iwu Onyenwe anyị nyere: ‘Ụbọchị echi bụ ụbọchị izuike, ụbọchị nke asaa dị nsọ nye Onyenwe anyị. Ya mere, sienụ ihe niile unu nwere isi taa, nʼihi na unu agaghị esi ihe ọbụla echi. Nri ọbụla unu rifọrọ, hapụnụ ya ka ọ bụrụ nri unu ga-eri echi.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ha mere dịka Mosis gwara ha. Mgbe chi echi bọrọ, ha chọpụtara na nri ha dị mma dịkwa ụtọ, ikpuru adịghịkwa nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosis gwara ha sị, “Nke a ga-abụ ihe oriri unu taa, nʼihi na ọ bụ ụbọchị izuike nye Onyenwe anyị. Ọ dịghị nri unu ga-ahụ nke unu ga-achịkọta taa. ");
INSERT INTO ibo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Abalị isii ka unu ga-achịkọta nri unu ga-eri. Ma nʼabalị nke asaa bụ ụbọchị izuike, unu agaghị ahụ nri unu ga-achịkọta.” ");
INSERT INTO ibo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ụfọdụ lefuru ọkwa ahụ Mosis maara ha anya. Ha pụrụ nʼụbọchị izuike ahụ ịchọ nri, ma o nweghị nke ha nwetara. ");
INSERT INTO ibo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nʼihi nke a, Onyenwe anyị jụrụ Mosis ajụjụ sị ya, “Ruo ole mgbe ka unu ga-anọgide na-enupu isi nʼiwu m na ịdọ aka na ntị m? ");
INSERT INTO ibo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Lee, Onyenwe anyị enyela unu ụbọchị izuike. Ya mere, nʼụbọchị nke isii ọ na-enye unu nri ga-ezuru unu abalị abụọ. Onye ọbụla nʼime unu kwesiri ịnọgide nʼụlọ unu. Unu ekwesighị ịpụ apụ.” ");
INSERT INTO ibo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nʼihi nke a, ndị Izrel niile zuru ike nʼụbọchị nke asaa. ");
INSERT INTO ibo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ndị Izrel kpọkwara aha nri ahụ ha na-achịkọta mánà. Ọ dị ọcha dịka mkpụrụ kọrianda. Ọ na-atọkwa ụtọ dịka achịcha e ji mmanụ aṅụ mee. ");
INSERT INTO ibo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Emesịa, Mosis gara nʼihu gwa ha okwu sị, “Onyenwe anyị enyela iwu sị, ‘Na unu ga-eji ihe ọtụtụ ọmaa tụpụta mánà nke unu ga-edebe. Ọ ga-abụ ihe ncheta ga-adịrị ọgbọ ndị Izrel niile na-abịa nʼihu. Nʼụzọ dị otu a, ụmụ unu ga-ahụ ụdị achịcha m jiri zụọ unu nʼime ọzara mgbe m gbapụtara unu site nʼala ndị Ijipt.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nʼihi nke a, Mosis nyere Erọn iwu sị ya, “Tụrụ ọtụtụ ọmaa mánà tinye ya nʼime ite nta. Bute ya debe ya nʼihu Onyenwe anyị, ka ọ bụrụ ihe ga-adịgide nye ọgbọ dị nʼihu.” ");
INSERT INTO ibo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Emesịa, Erọn dọnyere mánà a nʼihu Ihe Ama e debere nʼime ụlọ ikwu, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ndị Izrel niile riri mánà ndị a iri afọ anọ tutu ruo mgbe ha batara nʼala ebe ndị mmadụ bi, tutu ruo mgbe ha bịarutere nʼoke ala Kenan. ");
INSERT INTO ibo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ihe ọtụtụ ọmaa bụ otu ọtụtụ nʼime ọtụtụ iri nke ga-eju ihe ọtụtụ efaf.) ");
INSERT INTO ibo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ọgbakọ ụmụ Izrel niile sitere nʼọzara Sin bilie ije ha, na-aga site nʼotu ebe ruo nʼebe ọzọ dịka Onyenwe anyị nyere nʼiwu. Ha mara ụlọ ikwu ha na Refidim, ma ọ dịghị mmiri dị nke ndị mmadụ ga-aṅụ. ");
INSERT INTO ibo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nʼihi nke a, ha sesịrị Mosis okwu, sị, “Nye anyị mmiri ka anyị ṅụọ.” Mosis zara, sị, “Gịnị mere unu ji esesị m okwu? Gịnị mere unu ji chọọ ịnwapụta ntachiobi Onyenwe anyị?” ");
INSERT INTO ibo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ma akpịrị mmiri kpọrọ ndị a nkụ nʼebe ahụ, nke a mere ka ha tamuo ntamu megide Mosis. Ha sịrị, “Ọ bụkwa nʼihi gịnị ka i ji site nʼobodo Ijipt kpọpụta anyị, ime ka anyị, ụmụntakịrị anyị na anụ ụlọ anyị nwụọ nʼihi akpịrị ịkpọ nkụ?” ");
INSERT INTO ibo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Nʼihi ya, Mosis tikuru Onyenwe anyị mkpu akwa sị, “Gịnị ka m ga-eme banyere ndị a. Lee, ha chọrọ itugbu m na nkume.” ");
INSERT INTO ibo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ma Onyenwe anyị zaghachiri Mosis, sị ya, “Gaa nʼihu ndị a, kpọrọ ụfọdụ nʼime ndị okenye Izrel. Jirikwa mkpanaka ahụ nʼaka gị, bụ nke i tiri nʼelu osimiri Naịl gaa. ");
INSERT INTO ibo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lee, Aga m eguzo nʼihu gị nʼakụkụ nkume dị na Horeb. Ị ga-akụ mkpara gị nʼelu nkume ahụ. Mmiri ga-asọpụtakwa site na ya, ka ndị mmadụ ṅụọ.” Ya mere, Mosis mere otu a nʼihu ndị okenye Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Nʼihi nke a, ọ kpọrọ aha ebe ahụ Masa na Meriba nʼihi esemokwu ụmụ Izrel na nʼihi nwale ha nwalere Onyenwe anyị, na-asị, “Onyenwe anyị ọ nọnyeere anyị, ka ọ bụ na ọ nọnyereghị anyị?” ");
INSERT INTO ibo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ndị Amalek bịara lụso ụmụ Izrel agha na Refidim. ");
INSERT INTO ibo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mosis gwara Joshua okwu sị ya, “Họpụta ụfọdụ ndị ikom ka ha gaa lụso ndị Amalek agha. Echi, mụ onwe m ga-eguzoro nʼelu ugwu, jidekwa mkpara Chineke nʼaka m.” ");
INSERT INTO ibo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ya mere, Joshua pụrụ gaa lụso ndị Amalek agha dịka Mosis gwara ya. Ma Mosis na Erọn na Hua, rigoro nʼelu ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ndị Izrel na-enwe mmeri mgbe ọbụla Mosis weliri aka ya elu, ma ndị Amalek na-emeri mgbe ọbụla Mosis wedatara aka ya. ");
INSERT INTO ibo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mgbe ike gwụrụ aka Mosis, ha butere nkume tinye nʼokpuru ya mee ka ọ nọkwasị nʼelu ya. Erọn na Hua jidere aka Mosis abụọ welie ya elu, otu onye nʼakụkụ a, onye nke ọzọ nʼakụkụ nke ọzọ. Ime ka aka Mosis guzosie ike tutu ruo mgbe anwụ dara. ");
INSERT INTO ibo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nʼihi nke a, Joshua na ndị agha ya meriri ndị agha Amalek site nʼiji mma agha gbuo ha. ");
INSERT INTO ibo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Emesịa, Onyenwe anyị sịrị Mosis, “Dee ihe niile ndị a nʼakwụkwọ, ka ọ bụrụ ihe ncheta. Gụgharịakwa ya na ntị Joshua. Nʼihi na aga m ehichapụ ihe niile a ga-eji cheta Amalek nʼelu ụwa.” ");
INSERT INTO ibo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mosis wuru ebe ịchụ aja nye Onyenwe anyị. Ọ kpọrọ ya Onyenwe anyị Nisi, nke pụtara, Onyenwe anyị bụ ọkọlọtọ m. ");
INSERT INTO ibo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mosis sịrị, “Nʼihi na-eweliri aka elu nʼebe ocheeze Onyenwe anyị dị. Onyenwe anyị ga na-ebuso ndị Amalek agha site nʼọgbọ ruo nʼọgbọ.” ");
INSERT INTO ibo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mgbe ihe ndị a gasịrị, Jetro, nna nwunye Mosis, onye bụkwa onye nchụaja Midia, nụrụ banyere ihe niile Chineke meere Mosis na Izrel ndị nke ya, na ụzọ Onyenwe anyị si napụta Izrel site nʼaka ndị Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jetro ọgọ nwoke Mosis kpọọrọ Zipọra, nwunye Mosis, mgbe Mosis chụlara ya ");
INSERT INTO ibo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","na ụmụ ya ndị ikom abụọ. Aha nwa ya nke mbụ bụ Geshọm, nke pụtara, abụ m ọbịa na mba ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Aha nwa nwoke nke abụọ bụ Elieza, nke bụ, Onyenwe anyị bụ onye inyeaka m. Nʼihi na mgbe Mosis mụrụ Elieza o kwuru sị, “Chineke nna m bụ onye inyeaka m, nʼihi na ọ napụtara m site na mma agha Fero.” ");
INSERT INTO ibo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, ọgọ nwoke Mosis, bịakwutere ha nʼime ọzara. O dutere ụmụ ndị ikom Mosis abụọ na nwunye Mosis. Nʼoge ahụ, Mosis na ụmụ Izrel mara ụlọ ikwu ha nʼakụkụ ugwu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","O ziri Mosis ozi sị, “Mụ bụ Jetro ọgọ gị nwoke bịakwutere gị, nwunye gị na ụmụ gị abụọ sokwa m.” ");
INSERT INTO ibo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Nʼihi ya, Mosis gara zute ọgọ ya nwoke, kpọọ isiala nye ọgọ ya, sutu ya ọnụ. Emesịa, ọ kpọbatara ha nʼime ụlọ ikwu ya. Jetro na ọgọ ya Mosis kwurịtara okwu, jụọ ihe banyere otu ihe si agara ibe ha. ");
INSERT INTO ibo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosis kọọrọ nna nwunye ya ihe niile Onyenwe anyị mere Fero na ndị Ijipt niile nʼihi ndị Izrel. Ọ kọkwaara ya banyere ihe ndakwasị niile dakwasịrị ha nʼime ọzara, na otu Onyenwe anyị si napụta ha. ");
INSERT INTO ibo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro soro Mosis ṅụrịa ọṅụ nke ukwuu nʼihi ihe niile Onyenwe anyị meere ndị Izrel, na otu o siri napụta ha site nʼaka ndị Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro kwuru sị, “Onye a gọziri agọzi ka Onyenwe anyị bụ. Onye napụtara unu site nʼaka ndị Ijipt na site nʼaka Fero. ");
INSERT INTO ibo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ugbu a, amaara m na Onyenwe anyị kachasị chi ndị ọzọ niile elu, nʼihi na ọ zọpụtara ndị ya site nʼaka ndị Ijipt ndị sitere na mpako ha meso Izrel mmeso.” ");
INSERT INTO ibo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetro, nna nwunye Mosis chụọrọ Chineke aja nsure ọkụ na aja ndị ọzọ. Emesịa, Erọn na ndị okenye Izrel bịara soro Mosis na ọgọ ya nwoke rie ihe nʼihu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nʼụbọchị nke ọzọ ya, Mosis bịara nọdụ ala ikpere ndị mmadụ ikpe. Igwe mmadụ nọgidere Mosis site nʼụtụtụ ruo nʼanyasị. ");
INSERT INTO ibo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ọgọ Mosis hụrụ ihe niile ọ na-emere ndị mmadụ, nke a mere na ọ jụrụ, “Gịnị bụ ihe nke a ị na-emere ndị a? Gịnị mere i ji nọdụ ala naanị gị, ndị a niile gbaa gị gburugburu malite nʼụtụtụ ruo nʼanyasị?” ");
INSERT INTO ibo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosis zara nna nwunye ya sị, “Nʼihi na ha bịara ịjụta m ihe si nʼaka Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ọ bụrụ na esemokwu adịrị nʼetiti mmadụ ọbụla na ibe ya, ha na-abịakwute m, ka m kpebie ihe dị nʼetiti mmadụ na ibe ya. Ana m eme ka ha mata iwu na ụkpụrụ Chineke.” ");
INSERT INTO ibo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mgbe Jetro, nna nwunye Mosis, nụrụ ihe ndị a niile, ọ sịrị Mosis, “Ihe ị na-eme adịghị mma. ");
INSERT INTO ibo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ike ga-agwụ gị, gwụkwa igwe mmadụ ndị a. Ọrụ a ị na-arụ dị ukwuu karịa gị. Naanị gị agaghị ebuli ya. ");
INSERT INTO ibo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ugbu a, gee m ntị. M ga-adụ gị ọdụ, ka Chineke nọnyekwara gị. Ọ ga-adị mma ma ọ bụrụ na ị bụ onye na-anọchi anya ndị a nʼihu Chineke. Nʼụzọ dị otu a, i nwere ike iweta nsogbu niile ha nwere nʼihu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ihe ọzọ ị ga-eme bụ nke a: ị ga-akụziri ha iwu na ụkpụrụ Chineke, gosikwa ha ụzọ ha ga-esi bie ndụ, na ọrụ ha kwesiri ịrụ. ");
INSERT INTO ibo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ma site nʼetiti ndị a họpụta ndị ikom tozuru, ndị ikom na-atụ egwu Chineke, ndị kwesiri ntụkwasị obi na ndị kpọrọ uru nʼezighị ezi asị. Mee ha ndịisi na-achị imerime puku ndị mmadụ, ndịisi narị mmadụ, ndịisi iri mmadụ ise na ndịisi mmadụ iri. ");
INSERT INTO ibo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mee ka ha bụrụ ndị ikpe nye ndị mmadụ oge niile. Nye iwu ka ha na-ewetara gị okwu dịkarịsịrị ike, ma na-ekpe ikpe gbasara okwu dị mfe na ndị ọzọ niile dị iche iche. Nʼụzọ dị otu a, ndị ikpe ndị ahụ ga-enyere gị aka ime ka ibu arọ gị dị mfe. ");
INSERT INTO ibo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ọ bụrụ na ị ga-eme ihe niile ndị a, ọ bụrụkwa na Chineke ekwenye, ị ga-enwe ike nagide nsogbu niile. Mmadụ niile ga-ewere udo na ọṅụ birikwa.” ");
INSERT INTO ibo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosis gere ntị nʼihe niile nna nwunye ya gwara ya. O mekwara ihe niile o kwuru. ");
INSERT INTO ibo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","O sitere nʼetiti ụmụ Izrel họpụta ndị kwesiri ekwesi mee ka ha bụrụ ndịisi. Ụfọdụ ka o mere ndịisi na-elekọta imerime puku mmadụ, ụfọdụ na-achị narị mmadụ, ụfọdụ, iri mmadụ ise, ụfọdụ, mmadụ iri. ");
INSERT INTO ibo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ha jere ozi dịka ndị ikpe nye ndị mmadụ nʼoge niile. Ha na-ewetara Mosis okwu niile siri ike, ma ha onwe ha na-ekpe ikpe banyere okwu nke dịkarịsịrị nta. ");
INSERT INTO ibo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mgbe ahụ, Mosis zilagara nna nwunye ya. Jetro laghachikwara nʼobodo nke aka ya. ");
INSERT INTO ibo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Nʼọnwa nke atọ, site nʼoge ndị Izrel hapụchara obodo Ijipt, nʼụbọchị ahụ, ha bịaruru ọzara Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ọ bụ site na Refidim ka ha sị bịaruo ọzara Saịnaị, mee ebe obibi ha nʼebe ahụ, nʼakụkụ ugwu Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mosis rigooro nʼelu ugwu ahụ izute Chineke. Mgbe ahụ, Onyenwe anyị sitere nʼelu ugwu ahụ kpọ Mosis oku sị ya, “Otu a ka ị ga-esi gwa ụlọ Jekọb okwu. Ị ga-akọrọ ụmụ Izrel: ");
INSERT INTO ibo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Unu onwe unu ahụla ihe m mere ndị Ijipt, hụkwa otu m siri buru unu na nku ugo, si otu a, dọtara unu onwe m. ");
INSERT INTO ibo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nʼihi nke a, ọ bụrụ na unu ga-erubere m isi nke ọma ma debe ọgbụgba ndụ m, unu ga-abụ ihe onwunwe nke m dị oke ọnụahịa. Nʼezie, ụwa niile bụ nke m, ");
INSERT INTO ibo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ma unu ga-abụrụ m alaeze ndị nchụaja, na mba dị nsọ.’ Okwu ndị a ka ị ga-agwa ụmụ Izrel.” ");
INSERT INTO ibo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mosis gara kpọkọta ndị okenye ndị Izrel, gwa ha okwu niile nke Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ndị mmadụ niile a jikwa otu olu zaghachi ya sị, “Ihe ọbụla Onyenwe anyị kwuru ka anyị ga-eme.” Mosis gwara Onyenwe anyị ihe niile ndị Izrel kwuru. ");
INSERT INTO ibo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Onyenwe anyị gwara Mosis okwu sị, “Lee, agaje m izute gị nʼime igwe ojii gbara ọchịchịrị. Achọrọ m ka ụmụ Izrel niile were ntị ha nụrụ mgbe m ga-agwa gị okwu, ọzọkwa, ka ha kwerekwa na gị ruo mgbe niile.” Mosis gwara ndị Izrel niile okwu nke Onyenwe anyị gwara ya. ");
INSERT INTO ibo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Onyenwe anyị gwara Mosis okwu ọzọ sị, “Rịdakwuru ndị m, doo ha nsọ taa na echi. Nʼihi na nke a ga-abụ nkwado ha izute m. Ka ha saa uwe ha mmiri, ");
INSERT INTO ibo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","jikerekwa nʼụbọchị nke atọ. Nʼihi na m ga-arịdata nʼelu ugwu Saịnaị nʼihu mmadụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ị ga-akpa oke nʼebe ha na-agaghị agafe. Nye ha iwu si ha, ‘Kpacharanụ anya ka unu ghara ịbịa ugwu ahụ nso, maọbụ metụ ala ugwu ahụ aka. Nʼihi na onye ọ bụla metụrụ ugwu ahụ aka aghaghị ịnwụ.’ ");
INSERT INTO ibo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Agaghị emetụ onye mmebi iwu ahụ aka, kama, a ga-eji nkume tugbuo ya, maọbụ e were àkụ gbagbuo ya, maọbụ mmadụ maọbụ anụmanụ, ọ gaghị adị ndụ. Mmadụ ọbụla agaghị abịaru ugwu ahụ nso, ruo mgbe ha nụrụ opi nke a ga-afụ. Mgbe ahụ, ha nwere ike bịa nso ugwu ahụ.” ");
INSERT INTO ibo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ya mere, Mosis si nʼugwu ahụ rịdakwuru ụmụ Izrel. O doo ndị mmadụ ahụ nsọ. Ha niile ji mmiri saa uwe ha. ");
INSERT INTO ibo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mosis dọrọ ha aka na ntị sị ha, “Jikerenụ nʼụbọchị nke atọ. Nwoke na nwanyị enwekwala mmekọrịta ọbụla.” ");
INSERT INTO ibo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mgbe o ruru nʼụtụtụ ụbọchị nke atọ ahụ, oke igwe ojii kpuchiri elu ugwu ahụ. Amụma malitere na-egbuke, egbe eluigwe malitekwara ịgba. Nʼikpeazụ, opi ike dara. Mmadụ niile tụrụ egwu, makwa jijiji. ");
INSERT INTO ibo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mosis duuru ndị mmadụ ahụ niile si nʼụlọ ikwu ha pụta gaa izute Chineke. Ha niile guzokwara nʼala ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mgbe ahụ, anwụrụ ọkụ kpuchiri ugwu Saịnaị. Ma lee! Onyenwe anyị rịdatara dịka ire ọkụ nʼelu ugwu ahụ. Anwụrụ ọkụ rigoro elu dịka anwụrụ ọkụ nke ọhịa na-ere ọkụ. Ala ọma jijiji dị ukwuu dakwasịkwara ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mgbe opi ike ahụ na-ada ike ike, Mosis malitere ịgwa Chineke okwu. Chineke zaghachiri Mosis okwu site nʼolu dara ụda dịka egbe eluigwe. ");
INSERT INTO ibo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Onyenwe anyị rịdatara bịaruo nʼelu ugwu Saịnaị. Ọ gwara Mosis ka ọ rịgota bịa zute ya. Mosis rigoro nʼelu ugwu ahụ ijekwuru Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Onyenwe anyị gwara Mosis okwu sị, “Rịda gaa dọọ ndị mmadụ ahụ aka na ntị ka ha ghara ịgafe oke ala ahụ bịaruo nso ịhụ Onyenwe anyị anya ka ha ghara ịla nʼiyi. ");
INSERT INTO ibo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ọ bụladị ndị nchụaja ndị chọrọ ịbịaru Onyenwe anyị nso aghaghị ido onwe ha nsọ. Ma ọ bụghị otu a, Onyenwe anyị ga-eme ka ha niile nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosis zaghachiri Onyenwe anyị sị, “Ndị mmadụ agaghị arịgota nʼugwu Saịnaị nʼihi na gị onwe gị adọọla anyị aka na ntị sị, ‘Kpaanụ oke gburugburu ugwu a, doo ya nsọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma Onyenwe anyị gwara Mosis okwu sị: “Gbada gaa kpọgota Erọn ka gị na ya soro rigota nʼelu ugwu a. Ma lezie anya ka ndị nchụaja na ndị Izrel ghara irigota nʼebe a ịbịakwute Onyenwe anyị, ma ọ bụghị otu a, ọ ga-eji ike laa ha nʼiyi.” ");
INSERT INTO ibo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ya mere, Mosis rịdakwuru ndị Izrel ga gwa ha. ");
INSERT INTO ibo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Chineke kwuru okwu ndị a niile sị: ");
INSERT INTO ibo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mụ onwe m bụ Onyenwe anyị Chineke unu, onye kpọpụtara unu site nʼIjipt, bụ ala nke ibu ohu. ");
INSERT INTO ibo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ị gaghị enwe chi ọzọ tinyere m. ");
INSERT INTO ibo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gị emerela onwe gị arụsị a pịrị apị, nʼoyiyi nke ụdị ọbụla nke yiri ihe dị nʼeluigwe maọbụ nke yiri ihe dị nʼụwa, nʼokpuru ya maọbụ nʼime mmiri, nʼokpuru ụwa. ");
INSERT INTO ibo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gị akpọla isiala nye ha, efekwala ha ofufe, nʼihi na Mụ onwe m bụ Onyenwe anyị Chineke gị, abụ m Chineke ekworo. Onye na-ata ụmụ na ụmụ ụmụ ahụhụ, nʼihi ajọ omume nke ndị mụrụ ha, ọ bụladị ruo nʼọgbọ nke atọ na nke anọ, nke ndị ahụ kpọrọ m asị. ");
INSERT INTO ibo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ma na egosi ịhụnanya nye puku ọgbọ niile nke ndị hụrụ m nʼanya, bụ ndị na-edebe ihe niile m nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Gị ejikwala aha Onyenwe anyị bụ Chineke gị eme ihe efu, nʼihi na Onyenwe anyị agaghị agụ onye ji aha ya eme ihe efu dịka onye ikpe na-amaghị. ");
INSERT INTO ibo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Cheta ụbọchị izuike site nʼido ya nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nʼime ụbọchị isii ka ị ga-eje ozi gị niile. Ọ bụkwa nʼime ha ka ị ga-arụzu ọrụ gị niile. ");
INSERT INTO ibo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ma ụbọchị nke asaa bụ ụbọchị izuike nke Onyenwe anyị Chineke gị. Ị gaghị arụ ọrụ ọbụla nʼụbọchị ahụ, gị onwe gị, nwa gị nwoke na nwa gị nwanyị, onye ọrụ gị nwoke, onye ọrụ gị nwanyị, maọbụ anụ ụlọ gị ọbụla, ọbụladị onye ọbịa bi nʼobodo gị. ");
INSERT INTO ibo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nʼihi na ọ bụ nʼime ụbọchị isii ka Onyenwe anyị kere eluigwe na ụwa, na oke osimiri, na ihe niile dị nʼime ha. O zuru ike nʼụbọchị nke asaa. Nʼihi nke a Onyenwe anyị gọziri ụbọchị nke asaa doo ya nsọ, ka ọ bụrụ ụbọchị izuike. ");
INSERT INTO ibo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Sọpụrụ nne gị na nna gị, dịka Onyenwe anyị Chineke gị nyere gị nʼiwu, ka ụbọchị ndụ gị dị ogologo nʼala ahụ nke Onyenwe anyị Chineke gị na-enye gị. ");
INSERT INTO ibo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gị egbula mmadụ. ");
INSERT INTO ibo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gị akwala iko. ");
INSERT INTO ibo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gị ezula ohi. ");
INSERT INTO ibo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Agbala ama ụgha megide onye agbataobi gị. ");
INSERT INTO ibo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gị enwela anya ukwu nʼebe ụlọ onye agbataobi gị dị. Gị enwekwala anya ukwu nʼebe nwunye onye agbataobi gị dị, maọbụ ohu ya nwoke maọbụ ohu ya nwanyị, ehi ya maọbụ ịnyịnya ibu ya, ma ọ bụkwanụ nʼihe ọbụla nke onye agbataobi gị nwere dị.” ");
INSERT INTO ibo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mgbe ndị Izrel hụrụ egbe eluigwe, na amụma ọkụ, na opi ike, hụkwa ugwu ahụ ka o jupụtakwara nʼanwụrụ ọkụ, ha mara jijiji nʼihi egwu. Ha guzoro nʼebe dị anya, ");
INSERT INTO ibo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","sị Mosis, “Biko ka gị onwe gị gwa anyị okwu, anyị ga-anụ ma ka Chineke gharakwa ịgwa anyị okwu, ma ọ bụghị ya, anyị ga-anwụ.” ");
INSERT INTO ibo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosis sịrị ndị Izrel, “Unu atụkwala ụjọ, nʼihi na Chineke bịara ịnwale unu ime ka unu na-atụ ya egwu mgbe ọbụla ka unu ghara imehie megide ya.” ");
INSERT INTO ibo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nʼihi nke a, mmadụ niile guzoro nʼebe dị anya site nʼugwu ahụ. Ma Mosis bara nʼime igwe ojii ahụ, ebe Chineke nʼonwe ya nọ. ");
INSERT INTO ibo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Onyenwe anyị gwara Mosis okwu sị ya, “Gwa ụmụ Izrel okwu sị, ‘Unu onwe unu ahụla na m si nʼeluigwe gwa unu okwu. ");
INSERT INTO ibo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Unu emerela onwe unu chi ọzọ tinyere m, chi ọlaọcha maọbụ chi ọlaedo. Unu emerela onwe unu ha. ");
INSERT INTO ibo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Ebe ịchụ aja unu ga-ewuru m ga-abụ nke unu ji naanị aja wuo. Nʼebe ahụ ka unu ga-achụrụ m aja nsure ọkụ na aja udo. Unu ga-ejikwa igwe ewu na atụrụ, na ehi chụọrọ m aja. Unu ga-ewuru m ebe ịchụ aja naanị ebe ọbụla m mere ka aha m bụrụ ihe a na-asọpụrụ, nʼebe ahụ ka m ga-abịa gọzie unu. ");
INSERT INTO ibo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ọ bụrụ na unu ewuo ebe ịchụ aja nkume, unu ejikwala nkume a wara awa, nʼihi na unu ga-eme ka ọ ghara ịdị nsọ ma ọ bụrụ na unu ejiri ngwa ọrụ wagharịa nkume ya. ");
INSERT INTO ibo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Unu ejila ihe nrigo gbagoro nʼebe ịchụ aja m, ka a ghara ikpughe ọtọ unu nʼelu ya.’ ");
INSERT INTO ibo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ndị a bụ iwu ị ga-edebe nʼihu ha. ");
INSERT INTO ibo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ọ bụrụ na ị goro ohu onye Hibru, ọ ga-agbara gị odibo afọ isii. Ma nʼafọ nke asaa, ọ ga-abụ onye nwere onwe ya laakwa nʼakwụghị ụgwọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ọ bụrụ na sọọsọ ya bịara, sọọsọ ya ga-ala, ma ọ bụrụ na o nwere nwunye tupu ọ bụrụ ohu, ya na nwunye ya ga-eso ala. ");
INSERT INTO ibo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ọ bụrụ na nna ya ukwu kpọnyere ya nwunye onye mụtaara ya ụmụ ndị ikom na ụmụ ndị inyom, nwanyị ahụ na ụmụ ya ga-abụ nke nna ya ukwu, naanị nwoke ahụ ga-enwere onwe ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Ma ọ bụrụ na ohu ahụ asị, nʼezie, ‘Ahụrụ m onyenwe m na nwunye m na ụmụ m nʼanya, achọghị m inwere onwe,’ ");
INSERT INTO ibo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mgbe ahụ, onyenwe ya ga-eduru ya bịakwute Chineke. Mgbe ọ kpọbatasịrị ya nʼọnụ ụzọ, onyenwe ya ga-eji agịga dupuo ntị ya. Malite nʼoge ahụ, ọ ga-abụkwa ohu ya ruo ọgwụgwụ ndụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“A sị na nwoke eree nwa ya nwanyị dịka ohu, agaghị ala otu ndị ohu nwoke si ala. ");
INSERT INTO ibo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ọ bụrụ na ihe nwanyị ahụ amasịkwaghị onyenwe ya, onye họọrọ ya nye onwe ya, onyenwe ya ga-ekwere ka a gbapụta ya. Ma ọ gaghị eresi ya ndị ọbịa. Nʼihi na onyenwe ya emeela nwanyị ahụ ihe ọjọọ mgbe ọ jụrụ na ọ gaghị alụkwa ya ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ọ bụrụ na ọ chọrọ ka nwa ya nwoke lụọ ya dịka nwunye ya, ọ ga-emeso ya dịka omenaala si kwado e si emeso ndị bụ nwaada. ");
INSERT INTO ibo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ọ bụrụkwa na ọ lụta ya dịka nwunye nke aka ya, mesịakwa lụta nwunye ọzọ, ọ gaghị akwụsị inye ya uwe maọbụ ihe oriri. Ọ gaghị agọnarịkwa ya ihe ọbụla kwesiri ya dịka nwunye. ");
INSERT INTO ibo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ọ bụrụ na o mereghị ohu nwanyị a ihe ndị a, nwanyị a pụrụ ịhapụ ya gaara onwe ya na-akwụghị ụgwọ ọbụla. Mgbe ahụ, ọ ga-enwerekwa onwe ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ọzọkwa, ọ bụrụ na mmadụ etigbuo mmadụ ibe ya, aghaghị ime ka onye dị otu a nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ma ọ bụrụ na o mere ya na-amaghị ama, ọ bụrụkwa na Chineke kwagidere omume dị otu a, mgbe ahụ, a ga-ahọpụtara ya ebe ọ ga-agbaga, jee zere ndụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ọ bụrụkwa na onye ọbụla akpachara anya jiri aghụghọ gbuo mmadụ ibe ya, a ga-adọpụta ya, ọ bụladị site nʼebe ịchụ aja m, gbuo ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ọ bụrụ na onye ọbụla etie nna ya maọbụ nne ya ihe, a ghaghị ime ka onye dị otu a nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Onye ọbụla tọọrọ mmadụ ibe ya, ma o rere ya nʼahịa, maọbụ na a chọpụtara ya nʼaka ya, a ga-eme ka onye dị otu a nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Aghaghị ime ka onye ọbụla ga-akpọ nna ya maọbụ nne ya iyi nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ọ bụrụ na mmadụ abụọ alụọ ọgụ ma otu nʼime ha ewere nkume maọbụ osisi tie onye nke ọzọ. Ọ bụrụ na ọ nwụghị, kama na o merụrụ ahụ, dinaakwa nʼihe ndina ya, ");
INSERT INTO ibo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ọ bụrụ na onye ahụ ebilie were mkpara ya na-ejegharị, ikpe agaghị ama onye ahụ tiri ya ihe, kama ọ ga-akwụ ụgwọ ihe onye ahụ ji gwọọ onwe ya, na oge onye ahụ o tiri ihe ji nọọ nʼihe ndina, ruo mgbe ahụ ya ga-adị mma. ");
INSERT INTO ibo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ọ bụrụ na ohu ọbụla anwụọ site nʼihe otiti nke onyenwe ya tiri ya, ma ohu ahụ ọ bụ nwoke maọbụ nwanyị, a ga-adọ onyenwe ya aka na ntị site nʼinye ya ntaramahụhụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Otu ọ dị, ọ bụrụ na ohu ahụ dị ndụ nʼụbọchị mbụ, maọbụ nʼụbọchị nke abụọ, a gaghị enye onyenwe ya ntaramahụhụ nʼihi na ohu ahụ bụ akụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ọ bụrụ na mmadụ abụọ esite nʼịlụ ọgụ ha merụọ nwanyị dị ime ahụ, mee ka ime ahụ pụọ, ma nwanyị ahụ emerụghị nnukwu ahụ, di nwanyị ahụ ga-anara site nʼaka onye ahụ merụrụ nwunye ya ahụ ihe niile ọbụla o kwuru na a ga-akwụ ya, bụkwa nke ndị na-ekpe ikpe kpebiri. ");
INSERT INTO ibo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ma ọ bụrụ na nwanyị ahụ a nwụọ nʼihi mmerụ ahụ ahụ e merụrụ ya, a ga-eme ka nwoke ahụ merụrụ ya ahụ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ọ bụrụ na ọ bụ anya ka a kụkpọrọ, anya nʼọnọdụ anya. Ọ bụrụkwa otu eze ka e tipụrụ, eze nʼọnọdụ eze. Otu ahụ kwa, aka nʼọnọdụ aka, ụkwụ nʼọnọdụ ụkwụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ịda ọkụ nʼọnọdụ ịda ọkụ, ọnya mma, nʼọnọdụ ọnya mma, ihe otiti nʼọnọdụ ihe otiti. ");
INSERT INTO ibo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ọ bụrụ na mmadụ ọbụla esite nʼihe otiti o tiri ohu ya kụkpọọ ya anya, a ga-eme ka ohu ahụ nwere onwe ya, maọbụ ohu nwoke maọbụ ohu nwanyị, nʼihi na o jirila anya ya gbara onwe ya. ");
INSERT INTO ibo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ọ bụrụ na mmadụ ọbụla etipụ eze ohu ya nwoke maọbụ ohu ya nwanyị, a ga-eme ka ohu ahụ nwere onwe ya nʼihi eze ya nke e tipụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ọ bụrụ na ehi ejiri mpi ya sọda mmadụ si otu a mee ka onye ahụ nwụọ, a ga-atụgbu ehi ahụ na nkume. Mmadụ ọbụla agaghị erikwa anụ ehi ahụ. Ma a ga-agụ onyenwe ehi ahụ dịka onye ikpe na-amaghị. ");
INSERT INTO ibo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ọ bụrụ na ehi ahụ na-asọkarị ndị mmadụ mpi mgbe niile, agaghị eri anụ ya. Kama, ọ bụrụ na adọọla onyenwe ya aka na ntị banyere ehi ahụ ọtụtụ oge, ma o meghị ihe ọbụla banyere ya, a ga-eme ka ehi ahụ na onyenwe ya nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ma ọ bụrụ na ndị nwe mmadụ achọọ ka a kwụọ ha ụgwọ kama igbu onyenwe ehi ahụ, ndị ikpe ga-ekpebi ego ole onyenwe ehi ga-akwụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Otu a ka a ga-esikwa kpee ikpe nke ga-apụta ma ọ bụrụ na ehi asọda nwokorobịa maọbụ nwaagbọghọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kama ọ bụrụ na ehi asọda ohu nwoke maọbụ ohu nwanyị, onyenwe ehi ahụ ga-akwụ onyenwe ohu ahụ iri mkpụrụ ọlaọcha atọ. Emesịa, a ga-eji nkume tugbuo ehi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ọ bụrụ onye ọbụla meghere olulu maọbụ gwuo olulu, ghara imechi ya, nke mere na ehi mmadụ maọbụ ịnyịnya ibu adaba nʼime ya, ");
INSERT INTO ibo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","onye ahụ gwuru olulu ahụ ga-akwụ onyenwe anụ ụlọ ahụ ọnụọgụgụ ego o jiri zụta ya. Mgbe ahụ ọ ga-eburu ozu anụ ahụ nwụrụ anwụ. ");
INSERT INTO ibo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ọ bụrụ na oke ehi mmadụ emerụọ oke ehi onye ọzọ ahụ, emesịa ehi dị otu a anwụọ, a ga-ere ehi nke dị ndụ, kewaa ego ya ụzọ abụọ. Otu a kwa, a ga-ekewa ehi nke nwụrụ anwụ, nye mmadụ abụọ ahụ otu ụzọ otu ụzọ. ");
INSERT INTO ibo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ọ bụrụ na amaara na oke ehi ahụ na-asọ mpi mgbe niile nʼoge gara aga, ma onyenwe ya emeghị ihe ọbụla banyere ya, ọ ga-akwụzu ụgwọ ehi ahụ nwụrụ anwụ. Emesịa ehi ahụ nwụrụ anwụ ga-abụrụ nke ya. ");
INSERT INTO ibo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ọ bụrụ na mmadụ ezuru ehi maọbụ atụrụ gbuo ya, maọbụ ree ya, ọ ga-akwụghachi ehi ise nʼọnọdụ ehi ahụ. Nʼọnọdụ otu atụrụ o zuuru, ọ ga-akwụghachi atụrụ anọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ọ bụrụ na e jide onye ohi mgbe ọ na-egbuka ụlọ onye ọzọ, ọ bụrụkwa na e tigbuo ya, mee ka ọ nwụọ, iwu ejideghị onye ahụ gburu ya. ");
INSERT INTO ibo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Kama ọ bụrụ na e tigburu onye ahụ mgbe chi bọcharala, ọmụma ikpe ga-adịrị onye ahụ tigburu ya. “Ọ bụrụ na e jide onye ohi, a ga-eme ka ọ kwụghachi ihe o zuru nʼohi. Ọ bụrụ na o nweghị ike kwụghachi, a ga-ere ya dịka ohu, jiri ego e retara kwụọ ụgwọ o ji. ");
INSERT INTO ibo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ọ bụrụ na a chọta ihe o zuru nʼaka ya, maọbụ ehi, maọbụ ịnyịnya ibu, maọbụ atụrụ, ọ ga-akwụghachi ọnụahịa ya okpukpu abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ọ bụrụ na mmadụ akpachara anya hapụ anụ ụlọ ya ka ọ gaa taa nri nʼubi maọbụ nʼubi vaịnị, maọbụ nʼubi onye ọzọ, onyenwe anụ ụlọ ahụ ga-akwụ ụgwọ ihe niile anụ ụlọ ya mebiri, ma ihe ọ ga-eji kwụọ ụgwọ ahụ aghaghị ịbụ ihe ọrụ ubi dị mma nke o si nʼubi ya maọbụ nʼubi vaịnị ya wepụta. ");
INSERT INTO ibo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ọ bụrụ na ọkụ na-agba banye nʼogwu, repịa ogbo ọka dị nʼubi mmadụ maọbụ ọka guzoro eguzo, ma ọ bụkwanụ ọhịa niile, onye ahụ tinyere ọkụ ahụ ga-akwụghachi ụgwọ ihe ahụ niile nke ọkụ repịara. ");
INSERT INTO ibo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ọ bụrụ na mmadụ enye enyi ya maọbụ onye agbataobi ya ego, maọbụ ihe ọbụla ka o debere ya, ma onye ohi agaa zuru ya site nʼụlọ ya, a si na e jide onye ohi dị otu a, ọ ga-akwụghachi ụgwọ ihe o zuru okpukpu abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ọ bụrụ na a chọpụtaghị onye ohi ahụ, onye nwe ụlọ ahụ aghaghị ịbịa nʼihu Chineke, ka a chọpụta maọbụ ya nʼonwe ya setịpụrụ aka were ihe ahụ, bụ akụ nke onye ọzọ kpatara. ");
INSERT INTO ibo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ọ bụrụ na onye ehi ya, maọbụ ịnyịnya ibu ya, maọbụ atụrụ ya, maọbụ uwe, maọbụ ihe ọbụla furu efu, nke mmadụ na-asị, ‘Nke a bụ ya.’ Mmadụ abụọ ndị a ga-aga nʼihu ndị ikpe. Onye ọbụla ndị ikpe a mara ikpe ga-akwụghachi ibe ya ụgwọ okpukpu abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ọ bụrụ na anụ ụlọ mmadụ nyere onye agbataobi ya nʼaka idebe anwụọ, maọbụ merụọ ahụ, maọbụ gbafuo, ma anụ ụlọ ahụ ọ bụ ịnyịnya ibu, maọbụ ehi, maọbụ atụrụ, maọbụ anụ ụlọ ọzọ, ọ bụrụ na ọ dịghị onye hụrụ mgbe ihe ndị a dakwasịrị anụ ụlọ ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","mgbe ahụ, onye agbataobi ahụ e nyere anụ ndị a nʼaka idebe ga-aṅụ iyi nʼihu Onyenwe anyị. Iyi ahụ ọ ṅụrụ ga-egosi onyenwe anụ ụlọ ahụ na o zughị ya nʼohi. Nʼihi nke a, ọ gaghị akwụghachi ụgwọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ma ọ bụrụ na o zuru anụ ụlọ ahụ nʼohi site na nke agbataobi ya, ọ ghaghị ịkwụghachi ụgwọ niile nye onyenwe ya. ");
INSERT INTO ibo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ọ bụrụ na anụ ọhịa gburu ya, ọ ga-eweta ụfọdụ nʼime anụ ahụ a dọgburu adọgbu, iji gosi na anụ ọhịa dọgburu ya. Ọ ga-esikwa otu a gbanarị ikpe ọmụma. Nʼihi nke a, ọ gaghị akwụkwa ụgwọ ọbụla nʼihi anụ ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ọ bụrụ na mmadụ agbaziri anụ ụlọ site nʼaka onye agbataobi ya, ọ bụrụ na anụ ụlọ ahụ anwụọ, maọbụ merụọ ahụ mgbe onyenwe ya na-anọghị nʼebe ahụ, onye ahụ a gbazinyere anụ ụlọ ahụ ga-akwụ ụgwọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ọ bụrụ na anụ ụlọ ahụ nọ na nke onyenwe ya, onye gbaziri ya agaghị akwụ ụgwọ ọbụla. Ọ bụrụ na a kwụrụ ego mgbazi ọbụla nʼisi anụmanụ a, onye gbaziri ya agaghị akwụghachi ego ọbụla, nʼihi na ego mgbazi ọ kwuru ka a ga-ewere dịka ụgwọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ọ bụrụ na nwoke arafuo nwaagbọghọ na-amaghị nwoke, site nʼime ka ha abụọ dinaa, nwoke ahụ ga-akwụ ụgwọ isi nwaagbọghọ ahụ. Ọ ga-alụkwa ya dịka nwunye ya. ");
INSERT INTO ibo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ọ bụrụ na nna nwaagbọghọ ahụ ekwenyeghị ka nwoke ahụ lụọ ya, nwoke ahụ aghaghị ịkwụ ụgwọ isi nwaagbọghọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“E kwesighị ịhapụ nwanyị mgbaasị ndụ. ");
INSERT INTO ibo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Onye ọbụla ya na anụ ọbụla dinakọrọ, e kwesiri ime ka ọ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Onye ọbụla chụrụ aja nye chi ọzọ ma ọ bụghị naanị Onyenwe anyị, a ga-eme ka ọ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ọ kwesighị ka mmadụ ọbụla mesie onye ọbịa ihe ike nʼụzọ ọbụla. Unu aghaghị icheta na unu bụ ndị ọbịa nʼala Ijipt. ");
INSERT INTO ibo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Unu emegbula nwanyị ọbụla di ya nwụrụ, maọbụ onye ọbụla na-enweghị nne na nna. ");
INSERT INTO ibo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Unu megbuo ha, mee ka ha tikuo m, aga m anụ mkpu akwa ha, nyere ha aka. ");
INSERT INTO ibo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mgbe ahụ, iwe m dị oke ọkụ ga-eripịa unu. Aga m ejikwa mma agha tigbuo unu. Ndị nwunye unu ga-aghọkwa ndị inyom na-enweghị di, ụmụ unu ga-abụkwa ndị na-enweghị nna. ");
INSERT INTO ibo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ọ bụrụ na ị gbazinyere onye Hibru ego, onye bụ nwa mgbei, ị gaghị anara ya ọmụrụnwa. ");
INSERT INTO ibo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ọ bụrụ na ị nara ya uwe ya nʼihi ego ahụ ị gbazinyere ya, ekwela ka uwe ahụ nọgide nʼaka gị ruo mgbe anwụ dara. ");
INSERT INTO ibo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Nʼihi na uwe ahụ nwere ike bụrụ naanị ihe o nwere, maọbụ uwe ọ ga-eji rahụ ụra. Ọ bụrụ na i zighachighị ya, o tikuo m site nʼịkwa akwa, aga m anụrụ mkpu akwa ya, nʼihi na abụ m onye obi ebere. ");
INSERT INTO ibo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ekwulula aha Chineke, abụkwala onye na-achị ndị gị ọnụ. ");
INSERT INTO ibo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Atụfukwala oge ọbụla nʼịkwụghachi onyinye unu kwesiri inye. Maọbụ nke mkpụrụ ala ubi gị, na nke mmanya vaịnị gị, na ụgwọ i kwesiri ịkwụ. “Ị ghaghị inye m nwa gị nwoke e buru ụzọ mụọ. ");
INSERT INTO ibo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Otu a ka ị ga-emekwa banyere mkpụrụ mbụ nke ehi gị na atụrụ gị. Ị ga-ewebata ya nye m nʼụbọchị nke asatọ site nʼoge a mụrụ ha, mgbe ị hapụsịrị ha nne ha ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Unu ga na-abụrụ m ndị dị nsọ. Nʼihi nke a, wezuganụ onwe unu nʼebe anụ a dọgburu adọgbu dị. Unu erikwala anụ dị otu a, kama tụpụrụnụ ya nkịta. ");
INSERT INTO ibo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ị gaghị agbasa akụkọ ụgha ọbụla. Esokwala mmadụ ọjọọ nwekọọ ihe ọbụla site nʼịgba ama ị maara na ọ bụghị eziokwu. ");
INSERT INTO ibo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ị gaghị eso igwe mmadụ mee ihe ọjọọ. Mgbe ị na-agba akaebe nʼụlọikpe, ị gaghị esonye igwe mmadụ ndị na-atụgharị ikpe ziri ezi. ");
INSERT INTO ibo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Nʼebe nwa ogbenye nọ, ị gaghị ekpelara ya nʼoge ikpe nʼihi na ọ bụ nwa ogbenye. ");
INSERT INTO ibo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ọ bụrụ na ị hụ ehi, maọbụ ịnyịnya ibu nke kpafuru akpafu, ọ bụrụkwa na ọ bụ nke onye iro gị, duru ya dulatara onye iro gị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ọ bụrụ na ị hụ onye kpọrọ gị asị ka ọ na-agbalị iwelite ịnyịnya ibu ya nke dara nʼihi ibu dị arọ o bu, elefula ya anya, kama gaa nyere ya aka bulite ịnyịnya ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ewezugala ikpe ziri ezi nʼebe ndị ogbenye nọ, nʼihi ọnọdụ ogbenye ha. ");
INSERT INTO ibo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ebola mmadụ ibe gị ebubo ụgha. Esonyekwala gbuo onye aka ya dị ọcha, maọbụ onye na-eme ihe ziri ezi. Nʼihi na mụ onwe m agaghị ahapụ onye na-emebi iwu na-ataghị ya ahụhụ kwesiri ya. ");
INSERT INTO ibo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Erikwala ngarị, nʼihi na iri ngarị na-eme ka ndị na-ahụ ụzọ kpuo ìsì, meekwa ka okwu onye aka ya dị ọcha gbagọọ agbagọ. ");
INSERT INTO ibo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Abụkwala onye na-emegbu ndị ọbịa, nʼihi na ị maara ihe banyere ọnọdụ ndị ọbịa nke ọma. Gị onwe gị bụrịị ọbịa nʼIjipt. ");
INSERT INTO ibo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Afọ isi ka ị ga-agha mkpụrụ nʼala ubi gị, ghọọkwa ihe omume ya. ");
INSERT INTO ibo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ma nʼafọ nke asaa, arụla ọrụ ọbụla nʼala ahụ ọzọ, hapụ ka ala ahụ zuru ike. Mgbe ahụ ndị ogbenye nʼetiti unu ga-aga nʼebe ahụ weta ihe oriri. Mkpụrụ ndị ọzọ fọdụrụ ga-adịrị ụmụ anụ ọhịa dị iche iche. Iwu ndị a ga-adịrị ubi vaịnị na ubi oliv unu niile. ");
INSERT INTO ibo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ị ga-arụ ọrụ gị niile nʼime ụbọchị isii. Ị ga-ezukwa ike nʼụbọchị nke asaa. Izuike a ga-adịkwara ehi gị na ịnyịnya ibu gị, na ndị ohu gị nọ nʼezinaụlọ gị na ndị ọbịa niile bi nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Kpachapụnụ anya hụ na unu mezuru ihe niile ndị a m gwara unu. Unu akpọkwala chi ndị ọzọ aha. Unu ekwupụtakwala ihe banyere ha nʼọnụ unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ugboro atọ nʼafọ ka unu ga-emere m mmemme a. ");
INSERT INTO ibo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Meenụ Mmemme Achịcha na-ekoghị eko, ụbọchị asaa ka unu ga-eri achịcha nke e jighị ihe na-eko achịcha mee. Unu ga-eri ya na mgbe a kara aka, nʼọnwa Abib. Nʼihi na ọ bụ nʼọnwa ahụ ka unu si nʼala Ijipt pụta. “Ọ dịghị onye ọbụla ga-agba aka efu bịa nʼihu m. ");
INSERT INTO ibo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mee Mmemme Owuwe Ihe ubi, bụ nke ị ga-eji mkpụrụ mbụ nke ihe niile ị kụrụ nʼubi unu. “Meekwanụ Mmemme Nchịkọta Ihe, nʼọgwụgwụ afọ ọbụla. Mgbe unu si nʼubi na-achịbata mkpụrụ ubi unu niile. ");
INSERT INTO ibo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ugbo atọ nʼafọ ka ndị ikom niile ga-abịa chee onwe ha nʼihu Onye kachasị ihe niile elu, bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Unu etinyekwala ihe ọbụla nke nwere ihe na-eko achịcha nʼime ya, mgbe unu na-achụ ọbara nke aja nʼihu m. “Maọbụ hapụ abụba nke aja mmemme m ka ọ dịgide ruo ụtụtụ. ");
INSERT INTO ibo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Wetanụ mkpụrụ mbụ niile nke ala ubi unu, bụ ndị kachasị mma, nʼụlọ Onyenwe anyị bụ Chineke unu. “Unu esikwala nwa ewu nʼime mmiri ara nne ya. ");
INSERT INTO ibo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Lee, ana m eziga mmụọ ozi nʼihu unu, ichebe unu nʼije unu nakwa ịkpọbatakwa unu nʼebe ahụ M doziri nye unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Geenụ ya ntị, nụrụkwa olu ya. Unu enupukwarala ya isi, nʼihi na ọ gaghị agbaghara njehie unu niile, nʼihi na Aha m dị nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ọ bụrụ na unu elezie anya nke ọma, gee ya ntị, mee ihe niile m nyere unu nʼiwu, mgbe ahụ, mụ onwe m ga-abụkwara ndị iro unu onye iro, megidekwa ndị na-emegide unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mmụọ ozi m ga-ejekwa nʼihu unu, ịkpọbatakwa unu nʼala ndị Amọrait, na ndị Het, na ndị Periz, na ndị Kenan, na ndị Hiv, na ndị Jebus. Aga m ehichapụ obodo ndị a niile. ");
INSERT INTO ibo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Unu agaghị akpọ isiala nye chi ha niile. Unu efekwala ha, maọbụ gbasoro omenaala ha. Kama, kwatuonụ ha. Tipịasịakwanụ ebe nkume nsọ niile nke chi ha. ");
INSERT INTO ibo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ma unu ga-efe Onyenwe anyị bụ Chineke unu. Mgbe ahụ, ngọzị ya ga-adịkwasị nri unu na mmiri ọṅụṅụ unu. Aga m ewezugakwa ọrịa nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nwanyị aga na nwanyị ime ya na-apụ agaghị adị nʼala unu. Aga m emekwa ka unu nwee ogologo ndụ. ");
INSERT INTO ibo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Aga m ezipu oke ụjọ m ka ọ nọrọ unu nʼihu tinye ọgbaaghara nʼime mba niile unu ga-ezute. Aga m eme ka ndị iro unu tụgharịa gbaa ọsọ. ");
INSERT INTO ibo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ọzọkwa, aga m eziga ebu ka ọ chụpụ ndị Hiv na ndị Kenan na ndị Het site nʼụzọ unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ma agaghị m achụpụ ha nʼotu afọ, nʼihi na nke a ga-eme ka ala ahụ niile tọgbọrọ nʼefu, ụmụ anụ ọhịa a baa ụba karịa unu. ");
INSERT INTO ibo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ma aga m achụpụ ha nwantịntị nwantịntị, tutu ruo oge unu ga-adị ọtụtụ, mgbe ọnụọgụgụ unu ga-akarị nke ha ukwuu, mgbe unu ga-ejupụta ala ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Aga m etinye oke ala unu site nʼOsimiri Uhie ruo nʼosimiri Mediterenịa, sitekwa nʼọzara ruo nʼosimiri Yufretis. Aga m enyefe ndị niile bi nʼala ahụ nʼaka unu. Unu ga-achụpụkwa ha. ");
INSERT INTO ibo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Unu na ha agbala ndụ ọbụla. Unu na chi ha enwekwala mmekọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Unu ekwela ka ha biri nʼala unu, ma ọ bụghị ya, ha ga-eme ka unu mehie megide m, nʼihi nʼife chi ha dị iche iche aghaghị ịbụrụ unu ihe ịma nʼọnya.” ");
INSERT INTO ibo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ọ gwara Mosis sị, “Rigokwute Onyenwe anyị, gị na Erọn, na Nadab, na Abihu, na mmadụ iri asaa site na ndị okenye Izrel. Ma unu ga-efe ofufe site nʼebe dị anya. ");
INSERT INTO ibo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Emesịa, ọ bụ naanị Mosis ga-abịarute Onyenwe anyị nso. Ndị nke ọzọ agaghị abịaru nso. Ndị mmadụ ndị ọzọ agaghịkwa eso ya rigota.” ");
INSERT INTO ibo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mgbe ahụ, Mosis bịara gwa ndị Izrel okwu niile na iwu niile Onyenwe anyị nyere. Ha niile zaghachiri ya nʼotu olu sị, “Anyị ga-emezu ihe niile Onyenwe anyị kwuru.” ");
INSERT INTO ibo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mosis deturu ihe niile Onyenwe anyị kwuru. Nʼisi ụtụtụ echi ya, o biliri wuo ebe ịchụ aja na ndịda ugwu ahụ. O gwunyere ogidi nkume iri na abụọ nke nọchiri anya ebo iri na abụọ ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mosis zipụtara ụmụ okorobịa Izrel, ndị chụrụ aja nsure ọkụ ma werekwa ụmụ oke ehi chụọ aja udo nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosis tinyere ọkara ọbara ehi ndị ahụ nʼime efere. Ma o fesara ọkara ọbara nke fọdụrụ nʼelu ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Emesịa, Mosis guzoro nʼebe ahụ gụpụta na ntị mmadụ niile, ihe dị nʼAkwụkwọ Ọgbụgba ndụ ahụ. Mgbe ụmụ Izrel nụrụ ya, ha weere otu olu kwuo sị, “Anyị anụla, anyị ga-eme ihe niile Onyenwe anyị kwuru. Anyị ga-erube isi.” ");
INSERT INTO ibo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mgbe ahụ, Mosis weere ọbara ahụ dị nʼime efere, fesaa ya nʼahụ ndị ahụ niile, sị, “Nke a bụ ọbara ọgbụgba ndụ ahụ nke dị nʼetiti unu na Onyenwe anyị, dịka okwu niile ndị a si dị.” ");
INSERT INTO ibo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mosis rigoro nʼelu ugwu, ya na Erọn, na Nadab na Abihu, na mmadụ iri asaa site na ndị okenye Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ha hụrụ Chineke nke Izrel. Nʼokpuru ụkwụ ya abụọ, e were ihe dịka ebe nzọkwasị ụkwụ nke e ji nkume safaia mee. Nkume ndị a na-enwukwa ezi onwunwu dịka mbara eluigwe. ");
INSERT INTO ibo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ọ bụ ezie na ndị okenye Izrel hụrụ Chineke anya ma ọ laghị ha nʼiyi. Kama o mere ka ha nọọ nʼihu ya rie, ṅụọ. ");
INSERT INTO ibo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mgbe nke a gasịrị, Onyenwe anyị gwara Mosis okwu sị, “Rigota, bịakwute m nʼelu ugwu, nọdụkwa ebe ahụ, maka na aga m enye gị mbadamba nkume nke iwu na ụkpụrụ dị na ya, nke m ji aka m dee maka i ji kuziere ha.” ");
INSERT INTO ibo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosis biliri, ya na Joshua onye na-agara ya ozi. Mosis nʼonwe ya rigokwara nʼelu ugwu Chineke. ");
INSERT INTO ibo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ọ gwara ndị okenye Izrel okwu sị, “Cherenụ anyị nʼebe a tutu ruo mgbe anyị ga-alaghachikwute unu. Unu na Erọn na Hua nọ, onye ọbụla nwere nsogbu jekwuru ha.” ");
INSERT INTO ibo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ngwangwa, Mosis rigoro nʼelu ugwu ahụ, oke igwe ojii kpuchiri ugwu ahụ niile, ");
INSERT INTO ibo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ebube Onyenwe anyị kpuchikwara elu ugwu ahụ. Ọ bụ ụbọchị isii ka igwe ojii kpuchiri ugwu ahụ. Nʼụbọchị nke asaa, Onyenwe anyị sitere nʼetiti igwe ojii ahụ kpọọ Mosis oku. ");
INSERT INTO ibo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ma nʼebe ndị Izrel nọ, ebube Onyenwe anyị na-enwu dịka ọkụ na-achọ irechapụ ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mosis banyere nʼime igwe ojii ahụ mgbe ọ na-arịgo ugwu ahụ. Ọ nọgidere nʼelu ugwu ahụ iri ụbọchị anọ, ehihie na abalị. ");
INSERT INTO ibo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Gwa ụmụ Izrel ka ha wetara m onyinye. Ị ga-anabatara m onyinye ahụ site nʼaka nwoke ọbụla onye o metụrụ nʼobi inye onyinye a. ");
INSERT INTO ibo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Ndị a bụ Onyinye ị ga-anata nʼaka ha: “ọlaọcha, ọlaedo na bronz. ");
INSERT INTO ibo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Ogho na-acha anụnụ anụnụ, nke odo odo, nke uhie uhie, nke ezi akwa ọcha, na nke ajị ewu; ");
INSERT INTO ibo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","akpụkpọ anụ ebule e sijiri uhie uhie, akpụkpọ ehi mmiri, na osisi akashia; ");
INSERT INTO ibo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mmanụ oliv nke a ga-etinye nʼiheọkụ, ụda isi ụtọ a na-etinye na mmanụ nsọ, na ụda na-eme ka aja nsure ọkụ na-esi isi ụtọ; ");
INSERT INTO ibo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","nkume ọma ọniks, na nkume ndị ọzọ a na-ahịọnye nʼefọọd, na nke a na-ahịọnyekwa nʼihe mgbochi obi. ");
INSERT INTO ibo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Mee ka ha wuoro m ebe nsọ. Mụ onwe m ga-ebikwa nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Wuo ụlọ nzute a na ihe ịchọ ya mma niile, ka ọ bụrụ otu ihe dịka oyiyi m ga-egosi gị. ");
INSERT INTO ibo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ha ga-eji osisi akashia wuo igbe ọgbụgba ndụ nke ịdị ogologo ya ga-abụ otu mita na sentimita iri. Obosara ya bụ sentimita iri isii na asatọ. Ịla elu ya ga-abụkwa sentimita iri isii na asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Machie ọlaedo a nụchara anụcha nʼime na azụ ya niile, jiri ọlaedo kpụọ ihe gburugburu akụkụ ya niile. ");
INSERT INTO ibo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kpụọ mgbaaka ọlaedo anọ maka ya, kwụnye ha nʼụkwụ anọ ya, ya bụ mgbaaka abụọ nʼotu akụkụ, mgbaaka abụọ nʼakụkụ nke ọzọ ya ");
INSERT INTO ibo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Jirikwa osisi akashia mee mkpara ogologo. Emesịa, were ọlaedo machie mkpara ndị a. ");
INSERT INTO ibo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ị ga-etinye mkpara ndị ahụ nʼime mgbaaka ahụ dị nʼakụkụ igbe ahụ, ka ọ bụrụ ihe iji na-ebu ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Nʼihi nke a, mkpara ọlaedo ndị ahụ ga-adịgide nʼime mgbaaka ọlaedo igbe a oge niile. ");
INSERT INTO ibo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ya mere, mgbe a rụsịrị igbe ọgbụgba ndụ ahụ, tinye Ihe Ama ahụ m nyere gị nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ị ga-ejikwa ọlaedo a nụchara anụcha mee ihe mkpuchi igbe ọgbụgba ndụ ahụ. Ogologo ya ga-adị nzọ ụkwụ anọ. Obosara ya ga-abụ nzọ ụkwụ abụọ na ọkara. ");
INSERT INTO ibo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ị ga-eji ọlaedo a nụchara anụcha, nke e tipịara etipịa kpụọ cherubim abụọ na nsọtụ abụọ nke ebe mkpuchi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Rụọ otu cherub nʼotu nsọtụ, otu cherub na nsọtụ nke ọzọ; mee ka cherubim ndị a na okwuchi igbe ahụ bụrụ otu na nsọtụ abụọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherubim ndị a ga-agbasa nku ha laa elu, were ha na-ekpuchi okwuchi ahụ. Cherubim ndị ahụ ga-eche onwe ha ihu, na-ele anya nʼebe okwuchi ahụ dị. ");
INSERT INTO ibo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tụkwasị ihe mkpuchi ahụ nʼelu igbe ọgbụgba ndụ ahụ. Tinyekwa Ihe Ama ahụ m nyere gị nʼime igbe ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nʼebe ahụ, nʼetiti cherubim abụọ ndị ahụ dị nʼelu ihe mkpuchi igbe ọgbụgba ndụ, ka m ga-ezute gị, nye gị iwu niile ị ga-enye ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Jiri osisi akashia mee tebul nke ogologo ya ga-adị iri sentimita itoolu. Obosara ya ga-abụ iri sentimita anọ na ise. Ịla elu ya ga-abụ iri sentimita isii na asaa. ");
INSERT INTO ibo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ị ga-eji ọlaedo a nụchara anụcha machie ya nke ọma, jirikwa ọlaedo kpụọ ọnụ ọnụ ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ị ga-etinye ihe njikọta a kpụrụ akpụ gburugburu ọnụ ọnụ ya, nke ga-aha ka otu ọbụ aka dimkpa. A ga-eji mpempe ọlaedo techie ihe njikọta ahụ gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kpụọ mgbaaka ọlaedo anọ maka tebul ahụ, kwụnye ha nʼakụkụ anọ ahụ nke ụkwụ anọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mgbaaka ndị ahụ ga-adị nso nso, ihe njikọ ahụ ka ha jide mkpara ndị ahụ, i ji ebu tebul ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Jiri osisi akashia mee mkpara a ga-eji na-ebu tebul ahụ. Jiri ọlaedo techie ha. ");
INSERT INTO ibo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ọzọkwa, jiri ọlaedo a nụchara anụcha kpụọ efere dị iche iche, na iko dị iche iche, na ọkwa dị iche iche, nke e ji awụpụ onyinye. ");
INSERT INTO ibo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Dọkwasị achịcha nke iche nʼIhu nʼelu tebul ahụ, nʼihu m, oge niile. ");
INSERT INTO ibo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Jiri ọlaedo a nụchara anụcha kpụọ ihe ịdọkwasị oriọna. Kpụọ ụkwụ ala ala ya, na alaka ya, mee ka iko ya niile yiri okoko osisi, na isi ya niile, na ifuru ya niile bụrụ otu ya na ahụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Alaka isii ga-esite nʼakụkụ abụọ nke ihe ịdọkwasị oriọna ahụ wapụta, alaka atọ nʼotu akụkụ ya, alaka atọ nʼakụkụ nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Iko atọ e mere dịka okoko osisi alụmọnd ya na ifuru, ya na okoko ya niile ga-adị nʼotu alaka, iko atọ nʼalaka nke ọzọ, otu a ka ọ ga-adị nʼalaka isii niile ahụ na-awapụta site nʼihe ịdọkwasị oriọna ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Nʼelu ihe ịdọba oriọna ahụ, ọ ga-adị iko anọ dịka ifuru osisi alụmọnd, ya na ebe o si awapụta na okoko ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Otu isi ga-adịkwa nʼokpuru alaka abụọ si nʼetiti ihe ịdọba oriọna ahụ pụta. Isi nke abụọ ga-adị nʼokpuru alaka abụọ nke ọzọ. Isi nke atọ ga-adị nʼokpuru alaka nke atọ, ya bụ ha niile alaka isii. ");
INSERT INTO ibo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Isi nwapụta ya na alaka ya niile ga-adịkọtakwa ọnụ, ha na ihe ịdọkwasị oriọna ahụ, nke e ji ọlaedo a nụchara anụcha rụọ. ");
INSERT INTO ibo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Ị ga-eme oriọna asaa, dọba ha nʼelu ihe ịdọkwasị iheọkụ ahụ, ka ha na-enye ìhè naanị nʼebe ihu ya. ");
INSERT INTO ibo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mkpa ya na ihe ịkpakepụ ọkụ ya niile, ga-abụ ọlaedo a nụchara anụcha. ");
INSERT INTO ibo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ọlaedo a nụchara anụcha nke dị iri kilogram atọ na anọ ka a ga-eji kpụọ ihe ịdọkwasị oriọna ahụ na ngwongwo ndị a niile. ");
INSERT INTO ibo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Lezie anya hụ na i mere ihe ndị a niile nʼusoro ihe atụ nke e gosiri gị nʼelu ugwu. ");
INSERT INTO ibo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Rụọ ụlọ nzute nke ga-enwe akwa mgbochi iri, nke e ji ezi ogho na-acha anụnụ anụnụ, na ngwakọta anụnụ na uhie, na uhie uhie kpaa akwa ndị a. Onye ọrụ aka na-eme ǹka kpanyekwara oyiyi cherubim nʼime ha. ");
INSERT INTO ibo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Akwa mgbochi ndị a ga-aha nʼotu. O nweghị nke ga-aka ibe ya. Ogologo akwa mgbochi ọbụla ga-abụ mita iri na abụọ na ọkara. Obosara ya bụ otu mita na sentimita asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Dụkọtaa akwa mgbochi ise nʼotu, dụkọtaakwa ise nke ọzọ nʼotu. ");
INSERT INTO ibo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Jiri akwa na-acha anụnụ anụnụ dụnye anya nko nʼelu ọnụ akwa mgbochi nke otu ụzọ, otu a ka ị ga-emekwa na nsọtụ ọnụ akwa mgbochi nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Dụnye iri anya nko ise nʼotu akwa mgbochi, dụnyekwa iri anya nko ise nʼọnụ akwa mgbochi nke ọzọ. Mee ka anya nko ndị a chee ibe ha ihu. ");
INSERT INTO ibo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ị ga-emekwa iri nko ọlaedo ise, nke ị ga-eji jikọta akwa mgbochi abụọ ahụ nʼotu, si otu a mee ka ụlọ nzute ahụ bụrụ otu. ");
INSERT INTO ibo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ị ga-eji akpụkpọ ajị ewu mee akwa mgbochi maka i ji kpuchie elu ụlọ nzute ahụ. Iri na otu ka ha ga-adị nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Akwa mgbochi iri na otu ndị a ga-aha nʼotu. Ọ ga-abụ mita iri na atọ na ọkara nʼogologo. Ebe obosara ya bụ otu mita na iri sentimita asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Dụkọtaa ise nʼime akwa mgbochi ahụ. Debe ya iche. Dụkọtakwa isii nke fọdụrụ debekwa ya iche. Pịajie akwa mgbochi nke isii ụzọ abụọ nʼihu ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Dụnyekwa iri anya nko ise nʼelu ọnụ otu akwa mgbochi ndị ahụ. Meekwa otu ihe ahụ nʼọnụ akwa mgbochi nke ọzọ e debere iche. ");
INSERT INTO ibo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Meekwa iri nko bronz ise, mee ka nko ahụ baa nʼanya nko nke ọzọ, i ji jikọta ụlọ nzute ahụ ka ọ bụrụ otu. ");
INSERT INTO ibo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ma banyere ogologo akwa mgbochi nke fọdụrụ maka ụlọ nzute, ya bụ ọkara akwa mgbochi nke mapụtara, nke a ga-akwụba nʼazụ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Akwa mgbochi ahụ ga-eji ihe ruru ọkara mita nʼogologo karịa nʼakụkụ abụọ. Ụma ndị a mapụtara ga-akwụdata nʼakụkụ abụọ nke ụlọ nzute ahụ ikpuchi ya. ");
INSERT INTO ibo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ị ga-eji akpụkpọ ebule e sijiri uhie uhie mee ihe mkpuchi maka ụlọ nzute ahụ, ya na akwa mkpuchi ọzọ nke e ji akpụkpọ ehi mmiri mee maka ikpukwasị nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ị ga-emere ụlọ nzute ahụ mbudo ibo osisi akashia, guzo ọtọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Mbudo ibo ọbụla ga-adị mita anọ na ọkara nʼogologo, dịrịkwa iri sentimita asaa nʼobosara. ");
INSERT INTO ibo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Mbudo ibo ndị a ga-enwe ihe nhịọnye abụọ nke ga-abanye nʼime ibe ya ijikọ ha nʼotu. Ị ga-arụ mbudo ibo ụlọ nzute ahụ niile otu a. ");
INSERT INTO ibo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ị ga-arụ mbudo ibo iri abụọ maka akụkụ ndịda nke ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Meekwa iri ụkwụ ọlaọcha anọ nʼokpuru ha. Otu mbudo ibo ga-enwe ụkwụ abụọ, otu ụkwụ nʼokpuru otu ihe nhịọnye, otu ụkwụ nʼokpuru ihe nhịọnye nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Nʼakụkụ nke ọzọ, bụ akụkụ ugwu nke ụlọ nzute ahụ, ị ga-arụkwa iri mbudo ibo abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Rụkwaa iri ụkwụ ọlaọcha anọ, ụkwụ abụọ nʼokpuru mbudo ibo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Nʼebe isi isi nsọtụ, ya bụ akụkụ ọdịda anyanwụ nke ụlọ nzute, ị ga-arụ mbudo ibo isii. ");
INSERT INTO ibo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Rụọ mbudo ibo abụọ, ga-adị na nkuku niile nke nsọtụ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nʼisi nkuku abụọ ndị a, ha ga-anọ iche iche site nʼokpuru ruo nʼelu ya, ma a ga-ejikọ ha ọnụ nʼime otu mgbaaka, ha abụọ ga-adị otu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ha niile ga-adị mbudo ibo asatọ na ụkwụ ọlaọcha dị iri na isii, ya bụ ụkwụ abụọ nʼokpuru mbudo ibo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Jiri osisi akashia mee osisi ntụbichi, ise maka mbudo ibo ndị dị nʼotu akụkụ nke ụlọ nzute, ");
INSERT INTO ibo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ise nke ọzọ maka ndị dị nʼakụkụ nke ọzọ, ise nke ọzọ maka mbudo ibo dị nʼakụkụ ọdịda anyanwụ, nʼebe ndịda ndịda nke ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Osisi ntụbichi nke dị nʼetiti ga-esite nʼotu isi ruo nʼisi nke ọzọ nke mbudo ibo ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Jiri ọlaedo machie mbudo ibo ndị ahụ niile, kpụọ mgbaaka ọlaedo ka ọ bụrụ ọnọdụ ịchịkọta osisi ntụbichi ndị a. Jirikwa ọlaedo machie osisi ntụbichi ndị a. ");
INSERT INTO ibo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Guzobe ụlọ nzute a nʼusoro dịka ụdịdị ihe ahụ m ziri gị nʼelu ugwu si dị. ");
INSERT INTO ibo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Meekwa akwa mgbochi nke e ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, uhie uhie na ezi akwa ọcha a kpara nke ọma, onye ǹka kpanyekwara oyiyi cherubim nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Were anya nko ọlaedo kwụba ya nʼelu ogidi osisi akashia anọ nke e ji ọlaedo machie, mee ka o guzoro nʼelu ụkwụ ọlaọcha anọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Konye akwa mgbochi ahụ na nko ndị ahụ, ma dọnye igbe ihe ama ahụ nʼazụ akwa mgbochi ahụ. Akwa mgbochi ahụ ga-ekewapụ Ebe Nsọ ahụ site nʼEbe Kachasị Nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tinye ihe mkpuchi mmehie ahụ nʼelu igbe ihe ama nʼime Ebe Kachasị Nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Dọnye tebul ahụ na mpụta nke akwa mgbochi ahụ, nʼakụkụ ugwu nke ụlọ nzute ahụ. Dọnyekwa ihe ịdọkwasị iheọkụ na ncherita ihu tebul ahụ, nʼakụkụ ndịda. ");
INSERT INTO ibo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Ị ga-eme akwa mgbochi maka ọnụ ụzọ mbata nke ụlọ ikwu ahụ nke eji ogho na-acha anụnụ anụnụ na ngwakọta anụnụ na uhie, na uhie uhie, na ezi akwa ọcha a kpara nke ọma, nke bụ akaọrụ onye ǹka. ");
INSERT INTO ibo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ị ga-arụrụ akwa mgbochi a anya nko ọlaedo na ogidi ise nke osisi akashia nke e ji ọlaedo machie. Ị ga-arụkwa ụkwụ bronz ise maka ha. ");
INSERT INTO ibo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ị ga-eji osisi akashia wuo ebe ịchụ aja. Ịdị elu ya ga-abụ otu mita na iri sentimita anọ. Ogologo ya na obosara ya ga-aha nʼotu, mita abụọ na iri sentimita atọ, mita abụọ na iri sentimita atọ. ");
INSERT INTO ibo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Rụnye mpi nʼakụkụ anọ nke ebe ịchụ aja ahụ nʼotu nʼotu. Mee ka mpi ndị a na ebe ịchụ aja ahụ bụrụ ihe e jikọtara nʼotu. Jiri bronz machie ebe ịchụ aja a. ");
INSERT INTO ibo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Jiri bronz kpụọ ngwongwo niile dị iche iche, ya bụ efere ikpofu ntụ, shọvel ya niile, efere ịkwọsa mmiri niile, ngaji eze ịdụta anụ na efere ndị e ji agụ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ị ga-eme ngịga mbadamba, ihe ọkpụkpa bronz, meekwa mgbaaka bronz nke ga-adị nʼakụkụ anọ nke ngịga ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tinye ya nʼokpuru oghere dị nʼebe ịchụ aja ahụ. Tinye ya ka ọ dịrị nʼetiti ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Jiri osisi akashia mee mkpara osisi maka ebe ịchụ aja ahụ, were bronz machie ha. ");
INSERT INTO ibo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A ga-eme ka mkpara ahụ baa nʼime mgbaaka ndị ahụ, ka ha dị nʼakụkụ abụọ nke ebe ịchụ aja ahụ mgbe ọbụla a na-ebu ya. ");
INSERT INTO ibo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Jiri obodobo osisi rụọ ebe ịchụ aja ahụ, ka o nwee oghere nʼime, dịka igbe. Ị ga-arụ ya dịka e gosiri gị nʼelu ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ị ga-arụkwa ogige maka ụlọ nzute ahụ. Nʼakụkụ ndịda ya ga-adị iri mita anọ na ise nʼogologo. Ọ ga-enwekwa akwa mgbochi nke e ji ezi akwa ọcha a kpara nke ọma mee. ");
INSERT INTO ibo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Iri ogidi abụọ ga-adị na iri ebe ndọkwasị abụọ nke e ji bronz kpụọ. Anya nko ogidi ndị ahụ ha na ihe ikegide ha ga-abụ ọlaọcha. ");
INSERT INTO ibo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Otu a kwa, akụkụ ugwu ga-adịkwa iri mita anọ na ise. Ọ ga-enwe akwa mgbochi, nwekwa iri ogidi abụọ na iri ebe ndọkwasị abụọ nke e ji bronz kpụọ, ya na anya nko nke ọlaọcha na ihe e ji ekegide ha nʼogidi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Akụkụ ọdịda anyanwụ nke ogige ahụ ga-adị iri mita abụọ na atọ nʼobosara. Ọ ga-enwe akwa mgbochi, na ogidi iri na ebe ndọkwasị iri. ");
INSERT INTO ibo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Nʼakụkụ ọwụwa anyanwụ, ebe anwụ na-awalite, akwa mgbochi ahụ ga-adịkwa iri mita abụọ na atọ nʼobosara. ");
INSERT INTO ibo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Akwa mgbochi nke ogologo ya dị mita isii na sentimita iri asatọ ga-adị nʼotu akụkụ nke ọnụ ụzọ mbata ahụ. O nwere ogidi atọ na ebe ndọkwasị atọ. ");
INSERT INTO ibo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Otu a kwa, akwa mgbochi nke ịdị ogologo ya dị mita asaa ga-adị nʼakụkụ nke ọzọ. Ọ ga-enwekwa ogidi atọ na ebe ndọkwasị atọ. ");
INSERT INTO ibo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Banyere ọnụ ụzọ mbata nke ogige ahụ, mee akwa mgbochi ga-adị mita itoolu nke e ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, uhie uhie na ezi akwa ọcha a kpara nke ọma, akaọrụ nke onye na-akpa ihe ịchọ mma. Ọ ga-enwe ogidi anọ na ihe ndọkwasị anọ. ");
INSERT INTO ibo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ogidi niile dị gburugburu ogige ahụ ga-enwe ihe njikọta ọlaọcha na nko, tinyere ebe ndọkwasị bronz. ");
INSERT INTO ibo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ogologo ogige ahụ ga-abụ iri mita anọ na ise. Ebe obosara ya ga-adị iri mita abụọ na atọ. Ọ ga-enwe akwa mgbochi nke ịdị elu ya dị iri mita abụọ na atọ, nke e ji ezi akwa ọcha a kpara nke ọma mee, nwekwa ebe ndọkwasị bronz. ");
INSERT INTO ibo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ngwongwo niile nke e ji eje ozi nʼụlọ nzute ahụ, ihe ọbụla bụ ọrụ ha, tinyere ǹtu ya niile na nke ogige ahụ, ga-abụ ihe e ji bronz rụọ. ");
INSERT INTO ibo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Nye ndị Izrel niile iwu ka ha wetara gị mmanụ oliv asụrụ asụ nke a na-agwaghị ihe maka itinye nʼiheọkụ ime ka ọkụ oriọna na-enwu mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Nʼime ụlọ nzute ahụ, na mpụta nke akwa mgbochi nke kpuchiri igbe Ihe Ama ahụ, Erọn na ụmụ ya ndị ikom ga-eme ka oriọna ndị ahụ dị nʼihu Onyenwe anyị, na-enwu ọkụ, site nʼuhuruchi ruo nʼụtụtụ. Nke a bụ ụkpụrụ ga-adịgide nʼetiti ndị Izrel nye ọgbọ niile dị nʼihu. ");
INSERT INTO ibo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ugbu a, site nʼetiti ụmụ Izrel kpọbata nwanne gị nwoke Erọn, ya na ụmụ ya ndị ikom, bụ Nadab, na Abihu, na Elieza na Itama. Ka ha jeere m ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Meere Erọn nwanne gị nwoke uwe nsọ, nke ga-enye ya ugwu na nsọpụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gwa ndị niile nwere onyinye ǹka nʼịdụ akwa, bụ ndị m nyere amamihe nʼihe ndị a, sị ha dụọrọ Erọn uwe pụrụ iche, nke e ji edo ya nsọ, ime ya onye na-ejere m ozi dịka onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Nke a bụ ụdị uwe ha ga-adụ: Ihe mgbochi obi, efọọd, uwe ime ahụ akpara akpa na-enweghị aka na uwe mwụda buru ibu, na uwe ime ahụ nke tụrụ agwa agwa na akwa a na-atụhị nʼisi na nke a na-eke nʼukwu. Ha ga-adụrụ Erọn nwanne gị nwoke na ụmụ ya ndị ikom uwe ndị a dị nsọ. Ka ha na-ejere m ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ka ha jiri ogho ọlaedo, nke na-acha anụnụ anụnụ, nke ngwakọta anụnụ na uhie, nke uhie uhie nakwa nke ezi akwa ọcha dụọ ha. ");
INSERT INTO ibo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Weere ogho ọlaedo, na nke na-acha anụnụ anụnụ, na ngwakọta anụnụ na uhie, na uhie uhie na ezi akwa ọcha a kpara nke ọma mee efọọd ahụ, nke bụ akaọrụ onye ǹka. ");
INSERT INTO ibo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ọ ga-enwe akwa nʼubu ya abụọ nke e ji ejikọta ọnụ nkuku ya abụọ, ka e nwe ike na-ekechisi ya ike. ");
INSERT INTO ibo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ihe okike nke ukwu ahụ nke onye ǹka kpaziri nke ọma ga-adị ka ya. Ya na efọọd ahụ bụ otu, nke e ji ogho na-acha edo edo, nke anụnụ anụnụ, na ngwakọta anụnụ na uhie na uhie uhie, nakwa nke ezi akwa ọcha a kpara nke ọma mee. ");
INSERT INTO ibo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Were nkume ọniks abụọ, gbunye aha ụmụ ndị nwoke Izrel nʼelu ya, ");
INSERT INTO ibo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","nʼusoro dịka e si mụọ ha, isii nʼelu otu nkume, isii fọdụrụ na nkume nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Gbunye aha ụmụ ndị nwoke Izrel nʼelu nkume abụọ ndị ahụ, dịka onye ǹka si egbunye akara na nkume. Mgbe ahụ, hịọnye nkume ndị ahụ nʼime ihe ọlaedo ahụ a kpara akpa, ");
INSERT INTO ibo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","jikọta ha nʼelu akwa ubu nke efọọd ahụ ka ọ bụrụ nkume ncheta mgbe ebighị ebi nye ụmụ Izrel. Erọn ga-ebukwa aha ndị a nʼelu ubu ya abụọ, dịka ihe ncheta nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ị ga-eji ọlaedo mee ihe ịchọ mma a tụrụ atụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Jirikwa ọlaedo a nụchara anụcha kpụọ eriri a tụhịkọtara dịka ụdọ, jikọta eriri ọlaedo ahụ na ihe ịchọ mma ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ị ga-adụ ihe mgbochi obi nke ikpe, nke bụ ọrụ aka onye ǹka. Mee ya dịka efọọd ahụ: jiri ogho edo edo, nke anụnụ anụnụ, na ngwakọta anụnụ na uhie, na nke uhie uhie nakwa ezi akwa ọcha a kpara nke ọma mee ya. ");
INSERT INTO ibo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Akụkụ anọ ya ga-aha nʼotu, iri sentimita abụọ na atọ nʼogologo, iri sentimita abụọ na atọ nʼobosara, nke apịajiri ụzọ abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Mgbe ahụ, hịọnye nʼelu ya ahịrị nkume anọ ndị dị oke ọnụahịa. Ụdị ga-adị nʼahịrị nke mbụ bụ, nkume kanelian, krisolaịt na beril, ");
INSERT INTO ibo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","nʼahịrị nke abụọ, ga-abụ nkume tọkwọisi, safaia na emeralụdụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Nʼahịrị nke atọ ga-abụ nkume jasint, ageeti na ametisiti. ");
INSERT INTO ibo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nʼahịrị nke anọ, ga-abụ nkume topaazi, ọniks na jaspa. Hịọnye ha nʼime ihe ọlaedo a kpara akpa. ");
INSERT INTO ibo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ha niile ga-adị nkume iri na abụọ, nke ọbụla na-anọchi anya aha ụmụ ndị ikom Izrel. Egbunyere aha ebo iri na abụọ ahụ, otu nʼotu, nke ọbụla dịka aha ya si dị. ");
INSERT INTO ibo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Jiri ọlaedo a nụchara anụcha mee eriri a kpara akpa dịka ụdọ, maka ihe mgbochi obi. ");
INSERT INTO ibo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kpụkwaa mgbaaka ọlaedo abụọ, dụnye ha na nkuku abụọ nke ihe mgbochi obi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Dụnye ụdọ ọlaedo abụọ ndị ahụ nʼelu mgbaaka ndị ahụ dị na nkuku ihe mgbochi obi ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","were isi ndị ọzọ nke ụdọ ahụ dụnye nʼihe ahụ a kpara akpa, konye ha nʼelu ubu efọọd ahụ, nʼebe ihu ya. ");
INSERT INTO ibo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ị ga-emekwa mgbaaka ọlaedo, konye ha na nkuku abụọ nke ihe mgbochi obi ahụ, nʼime ọnụ ọnụ ya ebe dị nso efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ị ga-akpụ mgbaaka ọlaedo abụọ ọzọ, konye ha nʼelu ubu abụọ nke efọọd ahụ, nʼokpuru nʼebe nʼihu ya, na nso nso ebe a dụkọtara ya, nʼelu ihe okike ukwu nke efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","A ga-eji eriri na-acha anụnụ kekọta mgbaaka ihe mgbochi obi ahụ na mgbaaka efọọd ahụ, jikọtaa ya na ihe okike ukwu ahụ, ime ka ihe mgbochi obi ahụ ghara ịtọghapụ site nʼefọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Nʼụzọ dị otu a, mgbe ọbụla Erọn banyere nʼEbe Nsọ, ọ ga-ebu aha ụmụ ndị ikom Izrel niile nʼelu obi ya, nʼelu ihe mgbochi obi nke ikpe ahụ, dịka ihe ncheta nʼihu Onyenwe anyị mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ị ga-etinyekwa nʼime ihe mgbochi obi ahụ ụmụ nkume abụọ e ji ajụta ase nke bụ Urim na Tumim. Ha ga-adị nʼelu obi Erọn mgbe ọbụla ọ gara nʼihu Onyenwe anyị. Otu a kwa, Erọn ga-ebukwa ihe e ji ajụta ase banyere ndị Izrel nʼelu obi ya mgbe niile, nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ọ bụ akwa nke na-acha anụnụ anụnụ, ka ị ga-eji dụọ uwe mwụda efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ọ ga-enwe oghere nʼetiti ya ebe a ga-esi na-etinye isi. A ga-enwe ihe ọkpụkpa gburugburu oghere a dịka nke olu uwe agha, ime ka o sie ike, ghara ịdọka. ");
INSERT INTO ibo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nʼọnụ ala ala uwe ahụ gburugburu, ị ga-akpanye ihe ọkpụkpa oyiyi mkpụrụ pomegranet. Ọ bụ ogho nke na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie na uhie uhie ka ị ga-eji. Ị ga-akpanyekwa ataṅụ ọlaedo nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Nʼọnụ ọnụ ala uwe mwụda ahụ, a ga-adụnye otu ataṅụ ọlaedo, otu oyiyi mkpụrụ pomegranet, gbaa gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Mgbe ọbụla Erọn na-eje ozi ya, ọ ghaghị iyi ya. Aga na anụ mgbịrịgba ataṅụ ahụ ka ọ na-akụ, mgbe ọ banyere nʼEbe Nsọ ahụ nʼihu Onyenwe anyị, na mgbe o si nʼebe ahụ na-apụta, ka ọ ghara ịnwụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ị ga-ejikwa ọlaedo a nụchara anụcha mee efere ntakịrị, gbunye akara dị otu a nʼelu ya: Ihe nsọ dịrị Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kenye eriri na-acha anụnụ anụnụ i ji jikọta ya na ihe ike nʼisi ahụ; ọ ga-adị nʼihu akwa ike nʼisi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ọ ga-adị nʼegedege ihu Erọn. Ọ ga-ebukwa ikpe ọmụma metụtara njehie gbasara ihe nsọ niile nke ụmụ Izrel doro nsọ, na onyinye ha niile. Ọ ga-adị nʼegedege ihu Erọn mgbe niile, ka ha bụrụ ndị Onyenwe anyị ga-anabata. ");
INSERT INTO ibo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Jiri ezi akwa ọcha kpaa uwe ime ahụ. Werekwa ezi akwa ọcha mee akwa ike nʼisi ahụ. Ihe ike nʼukwu ahụ ga-abụ ọrụ aka onye ǹka na-akpanye ihe ịchọ mma. ");
INSERT INTO ibo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Meekwara ụmụ ndị ikom Erọn uwe ime ahụ, ihe ike nʼukwu na akwa ike nʼisi, inye ha ugwu na nsọpụrụ. ");
INSERT INTO ibo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Mgbe i yinyekwasịrị Erọn nwanne gị na ụmụ ya ndị ikom uwe ndị a, tee ha mmanụ, doo ha nsọ. Chee ha nʼihu m ka ha bụrụ ndị na-ejere m ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Meekwara ha uwe ụkwụ nke eji akwa ọcha mee, maka ikpuchi anụ ahụ ha. Ọ ga-esite nʼukwu ruo nʼikpere. ");
INSERT INTO ibo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Erọn na ụmụ ya ndị ikom aghaghị iyi ha mgbe niile ha ga-aba nʼime ụlọ nzute, maọbụ mgbe ha na-abịa nso ebe ịchụ aja ije ozi nʼEbe Nsọ. Ka ha ghara imeta ihe ikpe ọmụma, ma nwụọ. “Nke a ga-abụ iwu na ụkpụrụ ebighị ebi, nke ga-adịrị Erọn na ụmụ ụmụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Nke a ga-abụ usoro mmemme nke ị ga-eme, iji doo Erọn na ụmụ ya ndị ikom nsọ, ka ha na-ejere m ozi dịka ndị nchụaja. Were nwa oke ehi na ebule abụọ nke na-enweghị ntụpọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Werekwa ọka wiiti a kwọrọ nke ọma, mee achịcha nke na-enweghị ihe na-eko achịcha e tinyere nʼime ha, achịcha mbadamba na-ekoghị eko nke e ji mmanụ oliv gwakọtaa, ya na achịcha mbadamba ọzọ dị nta na-ekoghị eko nke e tere mmanụ nʼahụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Mgbe ahụ, ị ga-etinye achịcha ndị a niile nʼime otu nkata, bute ha nʼime nkata ahụ, wetakwa nwa oke ehi, na ebule abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kpọpụta Erọn na ụmụ ya ndị ikom nʼọnụ ụzọ ụlọ nzute, jiri mmiri saa ha ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Yikwasị Erọn uwe ime ahụ, uwe mwụda nke efọọd, efọọd ahụ na ihe mgbochi obi. Were ihe okike efọọd ahụ nke akpaziri nke ọma kegide ya efọọd ahụ nʼahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tụhịakwa akwa ike nʼisi ahụ nʼisi ya. Tinye okpu nsọ ahụ nʼelu akwa ike nʼisi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Werekwa mmanụ nsọ ahụ, tee ya, site nʼịwụkwasị ya nʼisi ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kpọta ụmụ ya ndị ikom, yikwasị ha uwe ime ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kekwasịkwa ha ihe okike nʼisi. Keekwa Erọn na ụmụ ya ndị ikom ihe ike nʼukwu. Mgbe ahụ ọrụ ndị nchụaja ga-abụ nke ha site nʼụkpụrụ ebighị ebi. “Nʼụzọ dị otu a ka ị ga-esi doo Erọn na ụmụ ya ndị ikom nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Kpụta oke ehi ahụ nʼihu ụlọ nzute. Erọn na ụmụ ndị ikom ga-ebikwasị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Gbuo ya nʼihu Onyenwe anyị nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Jiri mkpịsịaka gị rụta ụfọdụ nʼime ọbara oke ehi ahụ tee ya na mpi dị nʼebe ịchụ aja ahụ. Wụpụ ọbara fọdụrụ nʼụkwụ ala ala ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Were abụba niile kpuchiri ihe ime ya, mba-umeju nke dị nʼumeju ya, akụrụ ya abụọ ya na abụba dị nʼelu ha, kpọọ ha ọkụ nʼelu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma anụ oke ehi ahụ, akpụkpọ ya na mgbịrị afọ ya, ka ị ga-akpọ ọkụ nʼazụ ọmụma ụlọ ikwu ahụ. Ọ bụ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Were otu nʼime ebule ndị ahụ, ka Erọn na ụmụ ya ndị ikom bikwasị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Gbuo ya. Werekwa ọbara ya fesaa nʼakụkụ ya niile nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Bọwasịa ebule ahụ ntakịrị ntakịrị, sachaa eriri afọ ya na ihe dị ya nʼime, ha na ụkwụ ya niile, tinyekọ ha na isi ya na akụkụ anụ ndị ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kpọọ ebule ahụ niile ọkụ nʼelu ebe ịchụ aja. Ọ bụ aja nsure ọkụ nye Onyenwe anyị, nke isisi ya dị ezi mma. Aja a chụrụ nye Onyenwe anyị site nʼọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Were ebule nke ọzọ, ka Erọn na ụmụ ya ndị ikom ga-ebikwasị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Gbuo ya. Were ụfọdụ nʼime ọbara ya tee Erọn na ụmụ ya nʼọnụ ntị aka nri ha, na isi mkpụrụ aka nke aka nri ha, ya na isi mkpụrụ ụkwụ nke ụkwụ aka nri ha. Werekwa ọbara nke fọdụrụ fesaa nʼakụkụ ya niile nke ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ị ga-esite nʼelu ebe ịchụ aja were ụfọdụ ọbara, ya na ụfọdụ mmanụ nsọ, fesa ya nʼahụ Erọn na nʼelu uwe ya, nʼahụ ụmụ ya ndị ikom, nakwa nʼelu uwe ha niile. Mgbe ahụ, ya na ụmụ ya ndị ikom ga-abụ ndị e doro nsọ nye Onyenwe anyị, ha na uwe ha. ");
INSERT INTO ibo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Were abụba ebule ahụ, na akụkụ ọdụdụ ya nwere abụba, na abụba nke kpuchiri ime ya, mba-umeju nke dị nʼumeju ya, akụrụ ya abụọ na abụba gbara ha gburugburu, na apata aka nri ya (nʼihi na ebule ahụ bụ ebule ido nsọ), ");
INSERT INTO ibo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","site na nkata achịcha ahụ a na-ejighị ihe na-eko achịcha mee, nke na-adị nʼihu Onyenwe anyị. Were otu achịcha dị gburugburu, otu ogbe achịcha a gwakọtara mmanụ oliv, na otu mbadamba ogbe achịcha, ");
INSERT INTO ibo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","tinye ihe ndị a niile nʼaka Erọn na ụmụ ya ndị ikom, mee ka ha fufee ha nʼihu Onyenwe anyị dịka aja mfufe. ");
INSERT INTO ibo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mgbe ahụ, nara ha site nʼaka ha. Kpọọ ha ọkụ nʼelu ebe ịchụ aja ha na aja nsure ọkụ, ka ọ bụrụ ihe isisi ya dị ezi mma nye Onyenwe anyị. Onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Mgbe i wepụtara obi ebule ahụ e ji doo Erọn nsọ, fufee ya nʼihu Onyenwe anyị dịka aja mfufe. Ọ ga-abụkwa oke nke gị. ");
INSERT INTO ibo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Doo akụkụ ebule ido nsọ ahụ nsọ, ndị nke bụ oke Erọn na ụmụ ya ndị ikom, ya bụ, obi ya e fufere efufe na apata ya e chere nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Nke a ga-abụ oke Erọn na ụmụ ụmụ ya ga-eketa dịka ụkpụrụ mgbe ebighị ebi nʼaka ndị Izrel. Mgbe niile ọbụla ha na-achụ aja udo maọbụ aja ekele, ka nke a bụrụ onyinye ụmụ Izrel na-enye Onyenwe anyị site nʼaja ha. ");
INSERT INTO ibo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Uwe nsọ Erọn ndị a niile ka a ga-edebe nʼihi mmemme ido nsọ. A ga-eji ha na-edo ụmụ ya nsọ bụ ndị ga-anọchi anya ya site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Nwa ya nwoke ọbụla nke nọchiri anya ya dịka onye nchụaja, nke bịara nʼụlọ nzute m ije ozi nʼEbe Nsọ ga-eyi uwe ndị a ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Were anụ ebule ido nsọ ahụ, sienụ anụ ahụ nʼebe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Erọn na ụmụ ya ndị ikom ga-eri anụ ebule ahụ, na achịcha ndị ahụ dị nʼime nkata nʼọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ha ga-eri ihe ndị aja niile ahụ nke e ji chụọ aja mkpuchi mmehie, nʼoge ido nsọ ha. Ọ dịghị onye ọbụla ọzọ ga-eso ha rie ya, nʼihi na ha bụ ihe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ọ bụrụ na ụfọdụ nʼime anụ na achịcha ido nsọ ndị ahụ afọdụ ruo ụtụtụ, a ga-akpọ ha ọkụ. A gaghị eri ya ọzọ, nʼihi na ọ bụ ihe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ọ bụ otu a ka a ga-esi doo Erọn na ụmụ ya ndị ikom nsọ, dịka ihe niile m nyere gị nʼiwu si dị. Ọ ga-ewe ụbọchị asaa iji doo ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ị ga-achụ aja oke ehi dịka aja mmehie maka ikpuchi mmehie kwa ụbọchị. Ị ga-emekwa ka ebe ịchụ aja m dị ọcha, site nʼịchụ aja mkpuchi mmehie nʼelu ya, na ite ya mmanụ nʼihi iji doo ya nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ụbọchị asaa ka ị ga-edo ebe ịchụ aja nsọ site nʼịchụ aja mkpuchi mmehie. Mgbe ahụ ebe ịchụ aja ga-abụ ebe dịkarịsịrị nsọ. Ihe ọbụla metụrụ ebe ịchụ aja ahụ ga-adị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ma nke a bụ ihe ị ga-achụ nʼelu ebe ịchụ aja kwa ụbọchị, ị ga-eji ụmụ atụrụ abụọ gbara otu afọ chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Chụọ otu nʼoge ụtụtụ; chụọkwa nke ọzọ nʼoge uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ị ga-ewere nwa atụrụ, tinyere lita ụtụ ọka abụọ a kwọziri akwọzi nke a gwọkọtara nʼotu lita mmanụ oliv asụrụ asụ, chụọ aja. Wetakwa otu lita mmanya dịka aja ihe ọṅụṅụ. ");
INSERT INTO ibo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Jirikwa nwa atụrụ nke ọzọ, ya na otu ụdị aja mkpụrụ ọka na aja ihe ọṅụṅụ ya dịka i mere nʼụtụtụ. Aja isisi ya dị ezi mma, nke e sitere nʼọkụ a na-achụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“A ga na-achụ aja nsure ọkụ a oge niile nʼọgbọ niile, nʼọnụ ụzọ ụlọ nzute m ka a ga-achụ ya, nʼihu Onyenwe anyị. Nʼihi nʼebe ahụ ka m ga-ezute gị gwa gị okwu. ");
INSERT INTO ibo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Nʼebe ahụ kwa ka m ga-ezute ndị Izrel niile. Nʼihi ya, aga m esite nʼịdị ebube m doo ebe ahụ nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“E, aga m edo ụlọ nzute ahụ nsọ, ya na ebe ịchụ aja, na Erọn na ụmụ ya ndị ikom, ka ha na-ejere m ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mgbe ahụ, aga m ebi nʼetiti ụmụ Izrel, bụrụkwa Chineke ha. ");
INSERT INTO ibo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ha ga-amata na m bụ Onyenwe anyị Chineke ha. Onye sitere nʼala Ijipt kpọpụta ha, ka m si otu a biri nʼetiti ha. Abụ m Onyenwe anyị Chineke ha. ");
INSERT INTO ibo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Jiri osisi akashia rụọ ebe ịchụ aja ihe nsure ọkụ na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Akụkụ anọ ya ga-aha nʼotu. Ogologo ya na obosara ya ga-adị iri sentimita anọ na ise. Ịdị elu ya ga-adị iri sentimita itoolu. Mpi ya niile ga-esi na ya pụta. ");
INSERT INTO ibo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Jiri ọlaedo a nụchara anụcha machie elu ya, akụkụ ya niile nakwa mpi ya niile. Ị ga-ejikwa ọlaedo kpụlite ọnụ ọnụ ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kpụnye mgbaaka ọlaedo abụọ nʼokpuru ihe ahụ akpụlitere akpụlite, abụọ na ncherita ihu akụkụ ọbụla, ebe ga na-ejide mkpara e ji ebu ya. ");
INSERT INTO ibo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ị ga-eji osisi akashia mee mkpara, jiri ọlaedo machie ha. ");
INSERT INTO ibo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ị ga-adọba ebe ịchụ aja ahụ nʼihu akwa mgbochi nke kpuchiri igbe iwu ọgbụgba ndụ ahụ, nʼihu oche ebere ahụ dị nʼelu igbe iwu ọgbụgba ndụ, nʼebe m ga-ezute gị. ");
INSERT INTO ibo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Ụtụtụ niile, mgbe Erọn doziri oriọna, ọ ga-esure ihe nsure ọkụ na-esi isi ụtọ nʼelu ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Nʼanyasị kwa, mgbe ọ na-amụnye ọkụ nʼoriọna ahụ, ọ ga-esurekwa ihe nsure ọkụ. Ihe nsure ọkụ na-esi isi ụtọ nke ga-adị nʼihu Onyenwe anyị site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Unu echekwala ihe nsure ọkụ na-esi isi ụtọ na-adịghị nsọ nʼelu ya, maọbụ aja nsure ọkụ, maọbụ aja ihe oriri, unu awụpụla onyinye ihe ọṅụṅụ nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Otu ugbo nʼafọ Erọn ga-ekpuchi mmehie nʼelu mpi ya. Mmemme mkpuchi mmehie a nke a na-eme otu ugbo nʼafọ, aghaghị ịbụ nke e ji ọbara nke si nʼaja a chụrụ nʼihi mkpuchi mmehie, nʼihi ọgbọ niile nke na-abịa. A ga na-edo ebe ịchụ aja nsọ otu a. Nke a bụ ebe dịkarịsịrị nsọ nye Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mgbe nke a gasịrị, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Mgbe ọbụla a gụrụ mmadụ ọnụ, onye Izrel ọbụla ga-akwụ Onyenwe anyị ụgwọ o ji gbara mkpụrụobi ya. Nke a dị mkpa, ka ihe otiti ọbụla ghara ịbịakwasị ha mgbe ị ga-agụ ha ọnụ. ");
INSERT INTO ibo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ihe onye a gụrụ ọnụ ga-akwụ bụ ọkara shekel, dịka shekel nke ebe nsọ si dị. Ọkara shekel bụ iri gera abụọ. Ọkara shekel a bụ onyinye nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ndị kwesiri inye onyinye a bụ ndị niile gbara iri afọ abụọ gbagoo. Ọ bụ ndị a kwesiri inye Onyenwe anyị onyinye a. ");
INSERT INTO ibo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ndị ọgaranya agaghị enye karịa ọkara shekel. Otu a kwa ndị ogbenye agaghị enye ihe dị ntakịrị karịa ọkara shekel. Nʼihi na onyinye a bụ onyinye unu na-enye Onyenwe anyị maka ikpuchiri mkpụrụobi unu mmehie. ");
INSERT INTO ibo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nabata ego niile ndị a site nʼaka ụmụ Izrel, ma jiri ya jee ozi dị nʼụlọ nzute. Ihe onyinye a ga-eme bụ ịkpọtụ uche Onyenwe anyị nʼebe unu nọ nʼihi mkpuchi mmehie maka ndụ unu.” ");
INSERT INTO ibo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ọzọkwa, Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Jiri bronz kpụọ efere ukwu na ihe ndọkwasị ya, maka ịsa ihe. Wụnye mmiri nʼime ya, dọsa ya nʼetiti ụlọ nzute na ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Erọn na ụmụ ya ndị ikom ga na-asa ụkwụ na aka ha site na ya. ");
INSERT INTO ibo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Mgbe ọbụla ha na-aba nʼụlọ nzute ahụ, ha ga-eji mmiri saa onwe ka ha ghara ịnwụ. Ọzọkwa, mgbe ha na-abịaru nso nʼebe ịchụ aja, maka ije ozi iche onyinye nʼihu Onyenwe anyị site nʼọkụ, ");
INSERT INTO ibo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ha ga-asa aka ha na ụkwụ ha, ka ha ghara ịnwụ. Nke a ga-abụ ụkpụrụ dịrị Erọn na ụmụ ya ndị ikom site nʼọgbọ ruo nʼọgbọ.” ");
INSERT INTO ibo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ọzọkwa, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Were eso osisi na-esi isi ụtọ ndị a dị iche iche: máá, nke ọtụtụ ya ruru kilo isii, na ihe ruru kilo sinamọn abụọ na ụma itoolu, na kilo kalamus atọ, ");
INSERT INTO ibo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kilo kashia isii, na lita anọ na ụma asatọ nke mmanụ oliv, dịka ọtụtụ shekel ebe nsọ ahụ si dị. ");
INSERT INTO ibo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ị ga-eji ya mepụta mmanụ nsọ, nke dị nsọ, nke a gwakọtara nke ọma dịka nke onye na-eme mmanụ na-esi isi ụtọ mere. Ọ ga-abụ mmanụ otite dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ị ga-ewere mmanụ ahụ tee ụlọ nzute ahụ niile na igbe iwu ọgbụgba ndụ ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na tebul ahụ, na ngwongwo ya niile, na nʼihe ịdọsa oriọna, na nʼihe niile dị ya nʼahụ, na nʼebe ịdọsa ihe nsure ọkụ na-esi isi ụtọ, ");
INSERT INTO ibo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na nʼebe ịchụ aja nke aja nsure ọkụ, na ngwongwo ya niile, na nʼite ịsa ụkwụ na aka, na nʼebe a na-adọba ya. ");
INSERT INTO ibo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ị ga-edo ha nsọ, ka ha bụrụ ihe dịkarịrị nsọ. Ihe ọbụla metụrụ ha ahụ ga-adịkwa nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ị ga-eji mmanụ otite a tee Erọn na ụmụ ya ndị ikom. Ha niile ga-adịkwa nsọ, bụrụ ndị na-ejere m ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Gwa ụmụ Izrel okwu sị ha, ‘Nke a bụ mmanụ nsọ m, nke dị nsọ site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Agaghị awụsa ya nʼahụ mmadụ. O nwekwaghị onye kwesiri imepụta mmanụ otite dị otu a. Ọ dị nsọ, unu kwesikwara ido ya nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","A ga-esite nʼetiti ndị m wezuga onye ọbụla mere ụdị mmanụ isi ọma a, maọbụ tee ya onye na-abụghị onye nchụaja m.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mgbe ahụ Onyenwe anyị gwara Mosis okwu sị, “Were ụda na-esi isi ụtọ, dịka eso osisi stakit, na ọnyịcha, na galbanọm, na ezigbo frankisens a na-agwaghị ihe, nke ọtụtụ ha niile ga-abụ otu ihe. ");
INSERT INTO ibo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mee ihe nsure ọkụ na-esi isi ụtọ, nke a gwakọtara nke ọma, bụ ọrụ onye na-eme mmanụ isi ụtọ. Tinyekwa ya nnu, ka ọ bụrụ ihe nsure ọkụ a nụchara anụcha, nke dịkwa nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Gwerie ụfọdụ nʼime ya ka ọ dịka uzuzu. Wụsa ya nʼihu igbe iwu ọgbụgba ndụ ahụ nʼime ụlọ nzute, ebe m ga-ezute gị. Ọ ga-abụ ihe dịkarịsịrị nsọ nye unu. ");
INSERT INTO ibo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Unu emerela onwe unu nke dịka ọtụtụ ụdị ihe nsure ọkụ a. Hụta ya ka ihe dị nsọ nʼebe Onyenwe anyị nọ. ");
INSERT INTO ibo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Onye ọbụla meere onwe ya ụdị ihe nsure ọkụ a, ịnụ isisi ya, a ga-ekewapụ onye ahụ site nʼetiti ụmụnna ya.” ");
INSERT INTO ibo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Lee, ahọpụtala m Bezalel nwa Uri, nwa Hua, onye si nʼebo Juda, ");
INSERT INTO ibo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","emejupụtakwala m ya na Mmụọ nke Chineke, nʼamamihe, nghọta, ihe ọmụma na ike ije ozi ọrụ ǹka dị iche iche, ");
INSERT INTO ibo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ichepụta ihe ǹka dị iche iche, nke metụtara ọlaọcha na ọlaedo na bronz, ");
INSERT INTO ibo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ịwa nkume na ido nkume, ịkwa ǹka osisi, na ịrụ ọrụ ǹka dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ọzọkwa, ahọpụtala m Oholiab, nwa Ahisamak, onye si nʼebo Dan, ka ọ bụrụ onye inyeaka Bezalel. “Enyekwala m ndị ǹka niile amara ịrụ ọrụ dị iche, nke ga-enyere ha aka ịrụ ihe ndị a niile m nyere gị iwu ịrụ: ");
INSERT INTO ibo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“ya bụ, ụlọ nzute ahụ, na igbe iwu ọgbụgba ndụ ahụ, na ebe mkpuchi mmehie dị ya nʼelu, na ngwongwo ndị ọzọ niile dị nʼụlọ ikwu ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","na tebul, na ngwongwo ya, ma ihe ịdọkwasị oriọna nke ọlaedo a nụchara anụcha, na ngwongwo ya, ");
INSERT INTO ibo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","na ebe ịchụ aja nke aja nsure ọkụ na-esi isi ụtọ, na ebe ịchụ aja nke aja nsure ọkụ, na ngwongwo ya, na ite mmiri ịsa ụkwụ na aka, na ụkwụ ite ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Na uwe ọma ahụ akpara akpa, ma uwe nsọ Erọn onye nchụaja na uwe nke ụmụ ya ndị ikom, mgbe ha na-eje ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ya na mmanụ nsọ ahụ, na ihe nsure ọkụ na-esi isi ụtọ e mere maka Ebe Nsọ. “Ha ga-arụzu ihe ndị a nʼusoro dịka m si nye gị ya nʼiwu.” ");
INSERT INTO ibo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mgbe ahụ, Onyenwe anyị sịrị Mosis, ");
INSERT INTO ibo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Gwa ndị Izrel, “Unu aghaghị ido ụbọchị izuike m nsọ. Nʼihi na nke a ga-abụ ihe ịrịbama nʼetiti mụ na unu ruo ọgbọ niile ga-abịa, ka unu maara na mụ onwe m bụ Onyenwe anyị, onye na-edo unu nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Ụbọchị izuike m dị nsọ nye unu. Nʼihi nke a, unu ga-edebe ya nsọ. Ọ bụrụ na onye ọbụla edebeghị ya nsọ, ọ ga-anwụ. Ọ bụrụkwa na onye ọbụla arụọ ọrụ ọbụla nʼụbọchị izuike m, a ga-ewezuga ya site nʼebe unu nọ. ");
INSERT INTO ibo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ụbọchị isii ka unu ga-arụ ọrụ unu niile. Ma ụbọchị nke asaa dị iche. Ọ bụ ụbọchị izuike. Ọ bụkwa ụbọchị dị nsọ nye Onyenwe anyị. Nʼihi nke a, onye ọbụla rụrụ ọrụ ọbụla nʼụbọchị Izuike ga-anwụ. ");
INSERT INTO ibo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ndị Izrel ga-edebe ụbọchị Izuike, na-eme mmemme ya nʼọgbọ niile, dịka ọgbụgba ndụ nke ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ọ ga-abụ ihe ịrịbama nke ga-adịgide nʼetiti mụ na ndị Izrel ruo mgbe ebighị ebi. Nʼihi na nʼụbọchị isii ka Onyenwe anyị kere eluigwe na ụwa. Ọ kwụsịrị ọrụ nʼụbọchị nke asaa, zuo ike, turu ndụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mgbe Onyenwe anyị gwasịrị Mosis okwu ndị a nʼelu ugwu Saịnaị, o nyere ya mbadamba nkume abụọ nke iwu ọgbụgba ndụ ahụ. Ọ bụkwa mbadamba nkume ndị ahụ nke mkpịsịaka Chineke dere ihe nʼelu ha. ");
INSERT INTO ibo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mgbe ndị mmadụ ahụ hụrụ na Mosis anọọla ọdụ ịrịdata site nʼelu ugwu Saịnaị, ha zukọtara, bịakwute Erọn, sị ya, “Bilie, meere anyị chi ndị ga-edu anyị, nʼihi na nwoke a bụ Mosis onye dupụtara anyị site nʼala Ijipt, anyị amaghị ihe mere ya.” ");
INSERT INTO ibo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Erọn zara sị ha, “Yipụtanụ ọlantị ọlaedo ndị nwunye unu, na ụmụ unu ndị ikom na ndị inyom yi. Wetara m ha.” ");
INSERT INTO ibo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ngwangwa, ha niile yipụrụ ọlantị ha weta ha nye Erọn. ");
INSERT INTO ibo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ọ naara ya nʼaka ha, were ngwa ọrụ e ji egbunye akara, kpụtara ha arụsị nwa oke ehi. Mgbe ahụ, ha kwuru sị, “Ndị Izrel, ndị a bụ chi unu, nke sitere nʼala Ijipt dupụta unu.” ");
INSERT INTO ibo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Mgbe Erọn hụrụ na ụmụ Izrel jupụtara nʼobi aṅụrị, nʼihi ihe ahụ ọ kpụrụ, o wuru ebe ịchụ aja nʼihu nwa ehi ahụ ọ kpụrụ, kwuo okwu sị, “Echi, a ga-enwe oke mmemme nye Onyenwe anyị!” ");
INSERT INTO ibo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ya mere na echi ya, ha biliri nʼoge, bido ịchụ aja nsure ọkụ, na aja udo, nye nwa ehi ahụ a kpụrụ akpụ. Mgbe nke a gasịrị, ha nọdụrụ ala iri ihe na ịṅụ ihe ọṅụṅụ, biliekwa ọtọ gwurie egwu ime onwe ha obi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nʼoge ahụ, Onyenwe anyị gwara Mosis okwu sị, “Gbada ọsịịsọ, nʼihi na ndị gị, ndị i dupụtara site nʼIjipt emerụọla onwe ha. ");
INSERT INTO ibo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nʼotu ntabi anya a, ha ahapụla ụzọ m niile. Ha akpụọlara onwe ha arụsị nwa oke ehi, nke ha na-efe ofufe, nke ha chụkwaara aja nye. Ha kwukwara sị, ‘Ndị Izrel, ndị a bụ chi unu, nke dupụtara unu site nʼala Ijipt.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mgbe ahụ, Onyenwe anyị sịrị Mosis, “Ahụla m na ndị a bụ ndị isiike, na ndị na-enupu isi. ");
INSERT INTO ibo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ugbu a, hapụ m ka iwe m bịakwasị ha, ka m laa ha nʼiyi. Aga m eme ka gị onwe gị bụ Mosis bụrụ mba ukwu nʼọnọdụ ha.” ");
INSERT INTO ibo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ma Mosis rịọrọ Onyenwe anyị Chineke ya arịrịọ sị ya, “Onye kachasị ihe niile elu, bụ Onyenwe anyị gịnị mere iwe gị ji dị ọkụ otu a nʼebe ndị gị nọ bụ ndị nke i ji ike ebube gị, na ọtụtụ ihe ịrịbama dị ịtụnanya, dupụta site nʼala Ijipt? ");
INSERT INTO ibo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nʼihi gịnị ka ndị Ijipt ga-ekwu sị, ‘Ọ bụghị ime ha ihe ọjọọ ka o ji dupụta ha, ka o nwee ike gbuo ha nʼugwu ndị a, ma kpochapụkwa ha site nʼelu ụwa a?’ Site nʼiwe gị dị ọkụ chigharịa, kwere ka ọ dajụọ. Chigharịakwaa site nʼatụmatụ ọjọọ a nʼebe ndị gị nọ. ");
INSERT INTO ibo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Cheta nkwa ahụ i kwere ndị ohu gị bụ Ebraham, Aịzik, na Izrel. Nʼihi na i ji onwe gị ṅụọ iyi nye ha sị, ‘Aga m eme ka mkpụrụ gị mụbaa dịka kpakpando nke eluigwe. Aga m enye ha ala m kwere ụmụ ụmụ gị na nkwa ka ọ bụrụ ihe nketa ha ruo mgbe ebighị ebi.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ya mere, Onyenwe anyị gbanwere obi ya. Ọ lakwaghị ha nʼiyi. ");
INSERT INTO ibo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mgbe ahụ, Mosis tụgharịrị site nʼugwu ahụ rịdata, mbadamba nkume abụọ nke iwu ọgbụgba ndụ ahụ dị ya nʼaka. E dere ha ihe nʼihu abụọ, nʼihu nakwa nʼazụ. ");
INSERT INTO ibo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mbadamba nkume ndị ahụ bụ akaọrụ Chineke, ihe e dere nʼelu ha bụ ihe Chineke nʼonwe ya dekwasịrị nʼelu mbadamba nkume ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Mgbe Joshua nụrụ ụzụ si na ndịda ugwu ahụ, nke ụmụ Izrel niile na-eme, ọ gwara Mosis okwu sị, “Ụzụ agha dị nʼọmụma ụlọ ikwu.” ");
INSERT INTO ibo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ma Mosis zara sị, “Mba, nke a abụghị ụzụ ndị meriri nʼagha, maọbụ ụzụ ndị e meriri nʼagha, kama ọ bụ olu abụ ka m na-anụ.” ");
INSERT INTO ibo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mgbe Mosis bịaruru nso ebe ahụ ha mara ụlọ ikwu ha, hụ nwa oke ehi ahụ a kpụrụ akpụ na egwu a na-ete, iwe were ya nke ukwuu. Ọ tụpụrụ mbadamba nkume ndị ahụ o ji nʼaka. Kụrie ha na ndịda ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mosis weere nwa oke ehi ahụ ha kpụrụ akpụ, kpọọ ya ọkụ. Mgbe ahụ, o gweriri ya dịka ntụ. Fesaa ya nʼelu mmiri mee ka ụmụ Izrel ṅụọ mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ọ gwara Erọn okwu sị, “Gịnị ka ndị a mere gị i ji bute ụdị mmehie ọjọọ dị otu a tụkwasị ha nʼisi?” ");
INSERT INTO ibo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“Erọn zara sị ya, ka iwe gị ghara ịdị ọkụ, onyenwe m. Gị onwe gị maara ndị a, mata otu ha si bụrụ ndị ọjọọ. ");
INSERT INTO ibo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ha sịrị m, ‘Meere anyị chi ndị ga-edu anyị, nʼihi na nwoke a bụ Mosis onye dupụtara anyị site nʼala Ijipt, anyị amaghị ihe mere ya.’ ");
INSERT INTO ibo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Asịrị m ha, ‘Onye ọbụla nke nwere ihe ịchọ ọma ọlaedo, ya yipu ya.’ Mgbe ahụ, ha wetara m ọlaedo ndị a, nke m tụbara nʼime ọkụ. Ihe si na ya pụta bụ nwa ehi a kpụrụ akpụ!” ");
INSERT INTO ibo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosis hụrụ na omume ndị a jọgbuziri onwe ya na njọ nʼihi na Erọn mere ka isi kopu ha. Nke mere ka ha bụrụzia ihe ọchị nʼebe ndị iro ha dị. ");
INSERT INTO ibo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","O guzoro nʼọnụ ụzọ ụlọ ikwu ahụ kwuo sị, “Onye ọbụla dịnyeere Onyenwe anyị ya bịakwute m.” Ndị Livayị niile bịakwutere ya. ");
INSERT INTO ibo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mgbe ahụ, ọ sịrị ha, “Ihe ndị a ka Onyenwe anyị, Chineke nke Izrel kwuru, ‘Nwoke ọbụla nyara mma agha ya nʼakụkụ ya, jegharịa nʼetiti ọmụma ụlọ ikwu ụmụ Izrel, site nʼotu isi ruo nʼisi nke ọzọ. Ya gbuo ọbụladị nwanne ya nwoke, maọbụ enyi ya, maọbụ onye agbataobi ya.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ndị Livayị mezuru ihe Mosis gwara ha. Ya mere ndị nwụrụ nʼụbọchị ahụ dị puku mmadụ atọ. ");
INSERT INTO ibo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mgbe ahụ, Mosis gwara ndị Livayị okwu sị, “Taa, unu ekewapụtala onwe unu nye Onyenwe anyị. Nʼihi na unu gburu ụmụ unu ndị ikom na ụmụnne unu ndị ikom. Ugbu a, ọ gọziela unu taa.” ");
INSERT INTO ibo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nʼechi ya, Mosis gwara ndị Izrel okwu sị ha, “Unu emeela mmehie dị ukwuu megide Onyenwe anyị. Ma aga m alaghachikwuru Onyenwe anyị nʼelu ugwu ahụ rịọọ ya. Ma eleghị anya, aga m arịọta maka ikpuchi mmehie unu.” ");
INSERT INTO ibo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ya mere, Mosis jekwuuru Onyenwe anyị sị ya, “Biko Onyenwe anyị, ndị a emeela mmehie dị ukwuu megide gị, nʼihi na ha akpụọlara onwe ha chi ọlaedo. ");
INSERT INTO ibo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ma ugbu a, biko, gbaghara mmehie ha. Ọ bụrụ na ị gaghị agbaghara ha, biko hichapụ aha m site nʼakwụkwọ ahụ i dere.” ");
INSERT INTO ibo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma Onyenwe anyị zara sị Mosis, “Onye ọbụla mehiere megide m ka a ga-ehichapụ aha ya site nʼakwụkwọ m. ");
INSERT INTO ibo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ma ugbu a, duru ndị a gaa ebe ahụ m gwara gị. Mmụọ ozi m ga-edu unu nʼije a. Ma otu ọ dị, mgbe m bịara ileta ndị a, aga m ata ha ahụhụ nʼihi mmehie ha.” ");
INSERT INTO ibo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ya mere, Onyenwe anyị mere ka ọrịa dị egwu bịakwasị ha, nʼihi ihe ha ji nwa ehi ahụ, bụ nke Erọn kpụrụ mee. ");
INSERT INTO ibo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Onyenwe anyị gwara Mosis okwu sị, “Duru ndị a i si nʼala Ijipt kpọpụta baa nʼala ahụ m kwere Ebraham, na Aịzik na Jekọb na nkwa, nʼihi na agwara m ha sị, ‘Aga m enye ụmụ ụmụ unu ala a, ka ọ bụrụ ihe nketa ha.’ ");
INSERT INTO ibo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aga m ezipu Mmụọ ozi m ka ọ gaa nʼihu unu chụpụrụ unu ndị Kenan, na ndị Amọrait, na ndị Het, na ndị Periz, na ndị Hiv, na ndị Jebus. ");
INSERT INTO ibo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Gbago nʼala mmiri ara ehi na mmanụ aṅụ na-eru na ya, ma agaghị m eso unu nʼije unu, nʼihi na unu bụ ndị isiike. Ọ bụrụ na m esoro unu, unu ga-anwa m ọnwụnwa, nke ga-eme ka m laa unu nʼiyi nʼụzọ.” ");
INSERT INTO ibo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mgbe ndị mmadụ ahụ nụrụ okwu olu ike ndị a, ha malitere iru ụjụ, ọ dịghịkwa onye ọbụla yinyere ihe ịchọ mma ya nʼahụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nʼihi na Onyenwe anyị agwala Mosis sị, “Gwa ụmụ Izrel, ‘Unu bụ ndị isiike. A sị na m nọ nʼetiti unu, otu ntabi anya ezuorola m ịla unu nʼiyi. Ugbu a, yipụnụ ihe ịchọ mma niile unu yi nʼahụ, aga m ekpebi ihe m ga-eme unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ya mere, ndị Izrel yipụrụ ihe ịchọ mma ha niile. Nʼugwu Horeb ka ha nọ mgbe ihe ndị a mere. ");
INSERT INTO ibo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nʼoge a, Mosis na-ewere ụlọ ikwu manye nʼazụ ọmụma ụlọ ikwu, ọ na-akpọ ya ụlọ nzute. Ọ na-amanye ya nʼebe dị anya site nʼebe ụmụ Izrel mara ụlọ ikwu ha. Onye ọ bụla nke chọrọ ịjụta Onyenwe anyị ase, na-apụ, gaa nʼụlọ nzute ahụ nke dị nʼazụ ọmụma ụlọ ikwu. ");
INSERT INTO ibo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mgbe ọbụla Mosis na-aga nʼụlọ ikwu nzute ahụ, ndị Izrel niile na-apụta guzoro nʼọnụ ụzọ ụlọ ha, na-ele ya anya tutu Mosis abanye nʼụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mgbe ọ banyere nʼụlọ ikwu ahụ; ogidi igwe ojii ahụ na-abịa guzochie nʼọnụ ụzọ mgbe Onyenwe anyị na Mosis na-akparị ụka. ");
INSERT INTO ibo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nʼoge ọbụla, ndị mmadụ hụrụ ogidi igwe ojii ahụ ka o guzo nʼọnụ ụzọ ụlọ ikwu nzute ahụ, ha onwe ha na-eguzokwa, onye ọbụla, nʼọnụ ụzọ ụlọ ikwu ha, kpọọ isiala. ");
INSERT INTO ibo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Nʼime ụlọ nzute ahụ, Onyenwe anyị na-agwa Mosis okwu ihu na ihu, dịka mmadụ sị agwa enyi ya okwu. Mgbe ha kparịchara ụka, Mosis na-alọghachi azụ nʼebe ụmụ Izrel mara ụlọ ikwu ha. Ma nwokorobịa ahụ na-enyere ya aka, bụ Joshua, nwa Nun, na-anọgide nʼụlọ ikwu nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mgbe Mosis na Onyenwe anyị nọ na-ekwurịta okwu, ihe Mosis gwara ya bụ nke a, “Ọ dịla anya kemgbe ị na-agwa m sị m, ‘Duru ndị m baa nʼala ahụ e kwere na nkwa inye ha.’ Ma matakwa na ị gwabeghị m onye ị ga-edunyere m ga-eduzi m ụzọ. I kwuola na ị maara aha m, kwukwaa na achọtala m ihuọma nʼebe ị nọ. ");
INSERT INTO ibo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Biko, ọ bụrụ na o si otu a dị, zi m ụzọ gị, nke ga-eme ka m mata gị, gaakwa nʼihu inweta ihuọma site nʼebe ị nọ. Chetakwa na mba a dị ukwu bụ ndị gị.” ");
INSERT INTO ibo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ọ zara sị, “Mụ onwe m ga-eso gị gaa, aga m enyekwa gị izuike.” ");
INSERT INTO ibo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mgbe ahụ Mosis sịrị ya, “Ọ bụrụ na ị gaghị eso anyị nʼije a, ekwela ka anyị si nʼebe a zọpụ ụkwụ. ");
INSERT INTO ibo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ọ bụrụ na i soghị anyị, olee otu a ga-esi mata na mụ onwe m, na ndị gị achọtala ihuọma gị? Olee otu ọ ga-esi pụta ìhè na mụ na ndị gị bụ mba dị iche site na mba ndị ọzọ dị nʼụwa?” ");
INSERT INTO ibo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ma Onyenwe anyị zara Mosis sị, “E, aga m eme ihe ị rịọrọ m, nʼihi na ị chọtala ihuọma m. Nʼezie, amara m onye ị bụ, marakwa aha gị.” ");
INSERT INTO ibo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mgbe ahụ, Mosis rịọrọ sị, “Gosi m ebube gị.” ");
INSERT INTO ibo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ma Onyenwe anyị zara sị, “Aga m eme ka ị hụ ịdị mma m, aga m akọwakwara gị ihe aha m bụ Onyenwe anyị pụtara. Onye m chọrọ imere ebere ka m ga-emere ebere, ọ bụkwa onye m chọrọ imere ọmịiko ka m ga-enwere ọmịiko. ");
INSERT INTO ibo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ma ị pụghị ịhụ ihu m nʼihi na mmadụ ọbụla enweghị ike ịhụ ihu m ma dịrịkwa ndụ.” ");
INSERT INTO ibo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mgbe ahụ, Onyenwe anyị sịrị, “Lee, e nwere ebe dị nso nʼakụkụ m, nʼelu nkume, ebe i nwere ike iguzo. ");
INSERT INTO ibo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mgbe ebube m ga-agafe, aga m ezo gị nʼokpuru nkume, werekwa aka m kpuchie gị, tutu ruo mgbe m gafechara. ");
INSERT INTO ibo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Emesịa, aga m eweli aka m, ka i nwee ike ịhụ azụ m anya, ma ị pụghị ịhụ ihu m.” ");
INSERT INTO ibo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Onyenwe anyị gwara Mosis, “Wapụta mbadamba nkume abụọ dịka nke mbụ, aga m edekwasị nʼelu ha okwu niile nke dị nʼelu mbadamba nkume ndị mbụ ahụ, bụ nke ị tụpịasịrị. ");
INSERT INTO ibo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Jikere nʼụtụtụ, rigoro ugwu Saịnaị ka i chee onwe gị nʼihu m nʼelu ugwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Onye ọbụla esokwala gị, ma ọ bụkwanụ nọdụ nso ugwu ahụ. Ekwekwala ka igwe ehi maọbụ igwe atụrụ kpaa nri nso nso ugwu ahụ.” ");
INSERT INTO ibo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mosis biliri nʼisi ụtụtụ, waa mbadamba nkume abụọ dịka ndị nke mbụ, rigoro ugwu Saịnaị dịka Onyenwe anyị gwara ya. Ọ jikwa nkume abụọ ahụ nʼaka ya. ");
INSERT INTO ibo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nʼoge ahụ, Onyenwe anyị rịdatara nʼime ogidi igwe ojii, guzo nʼihu Mosis, kwupụta aha ya bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","O si nʼihu Mosis gafee na-ekwu na-asị, “Onyenwe anyị, Onyenwe anyị, Chineke ọmịiko na onye amara, onye na-adịghị ewe iwe ọsịịsọ, na onye babigara ụba oke nʼịhụnanya na ikwesi ntụkwasị obi. ");
INSERT INTO ibo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Onye na-egosi ịhụnanya ya nye imerime puku, ma na-agbaghara ajọ omume na nnupu isi, na mmehie. Ma ọ dịghị ahapụ ka onye ikpe mara laa na-anataghị ahụhụ, ọ na-ata ụmụ na ụmụ ụmụ ha ahụhụ nʼihi mmehie nna nna ha ruo nʼọgbọ nke atọ na nke anọ.” ");
INSERT INTO ibo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Otu mgbe ahụ, Mosis hulatara kpọọ isiala, ");
INSERT INTO ibo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","sị ya, “Ọ bụrụ nʼezie na m achọtala ihuọma nʼanya gị, Onyenwe m, ka Onyenwe m, biko soro anyị gaa. Ọ bụ ezie na ndị a bụ ndị isiike, gbaghara anyị ajọ omume anyị, na mmehie anyị niile, ka ị nabatakwa anyị dịka ndị nke gị.” ");
INSERT INTO ibo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mgbe ahụ, Onyenwe anyị sịrị, “Mụ onwe m na gị na-agba ndụ. Nʼihu ndị gị niile, aga m arụ oke ọrụ ịtụnanya dị ukwu, ụdị nke a na-emetụbeghị mbụ nʼụwa, maọbụ na mba ọ bụla. Ndị niile unu bi nʼetiti ha ga-ahụ ọrụ Onyenwe anyị. Ọrụ ahụ dị oke egwu nke m ga-arụ nʼihi unu. ");
INSERT INTO ibo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Debe ihe niile m nyere gị nʼiwu taa. Aga m esite nʼihu unu chụpụ ndị Amọrait, ndị Kenan, ndị Het, ndị Periz, ndị Hiv na ndị Jebus. ");
INSERT INTO ibo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kpacharanụ anya ka unu na ndị bi nʼala ahụ unu na-aba nʼime ya ghara ịgba ndụ. Ka ha ghara ị bụ ihe ịma nʼọnya nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kama, tikpọọnụ ebe ịchụ aja ha niile. Kụrienụ ogidi arụsị ha niile. Gbutukwaanụ osisi Ashera ha jiri mere chi ha. ");
INSERT INTO ibo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Unu efela chi ọzọ, nʼihi na Onyenwe anyị, onye aha ya bụ Ekworo, bụ Chineke na-ekwo ekworo. ");
INSERT INTO ibo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Kpacharanụ anya ka unu na ndị bi nʼala ahụ ghara ịgba ndụ, nʼihi na mgbe ha na-akwaso chi ha iko, na-achụkwa aja nye chi ha, ha ga-akpọ unu oku nri, mgbe ahụ, unu ga-eri site nʼihe aja ha. ");
INSERT INTO ibo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Mgbe unu lụtara ụfọdụ ndị inyom ha dịka nwunye nye ụmụ unu ndị ikom, ndị inyom ndị a na-akwaso chi ha iko, ga-eme ka ụmụ unu ndị ikom soro ha nʼomume dị otu a. ");
INSERT INTO ibo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Unu akpụla chi ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Na-emenụ mmemme achịcha na-ekoghị eko. Rienụ achịcha na-ekoghị eko ụbọchị asaa, dịka m nyere nʼiwu na a ga-eme nʼụbọchị ndị ahụ a họpụtara, nʼọnwa Abib, nʼihi na ọ bụ nʼọnwa ahụ ka unu si nʼala Ijipt pụta. ");
INSERT INTO ibo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nwa nwoke ọbụla e bụ ụzọ mụọ bụ nke m, tinyere ụmụ anụ ụlọ, ma ehi, ma atụrụ, ma ewu. ");
INSERT INTO ibo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","E nwere ike ịgbapụta nwa oke ịnyịnya ibu site nʼiwere nwa atụrụ dochie nʼọnọdụ ya. Ọ bụrụ na i kpebie na ị gaghị agbapụta ya, mgbe ahụ, ị ga-agbaji olu ya. Ma ụmụ unu ndị ikom niile ka a ga-agbapụta. “O nweghị onye ọbụla nʼime unu ga-abịa guzo m nʼihu na-ejighị onyinye. ");
INSERT INTO ibo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Nʼoge ịkụ ihe nʼubi na nʼoge owuwe ihe ubi, rụọnụ ọrụ naanị ụbọchị isii. Zukwanụ ike nʼụbọchị nke asaa. ");
INSERT INTO ibo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mee Mmemme Izu Ụka asaa, bụ nke ị ga-eji mkpụrụ mbụ nke ọka wiiti mee, na Mmemme Nchịkọta Ihe nʼọgwụgwụ afọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ugboro atọ nʼafọ ka ndị ikom unu niile ga-abịa chee onwe ha nʼihu Onye kachasị ihe niile elu, bụ Onyenwe anyị nke Izrel. ");
INSERT INTO ibo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nʼihi na aga m esite nʼihu unu chụpụ mba dị iche iche. Meekwa ka ala unu saa mbara. Ọ dịghị onye ọbụla ga-enwe anya ukwu nʼebe ala unu dị, mgbe unu na-aga iche onwe unu nʼihu Onyenwe anyị bụ Chineke unu, ugbo atọ nʼafọ. ");
INSERT INTO ibo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Unu etinyekwala ihe ọbụla nke nwere ihe na-eko achịcha nʼime ya, mgbe unu na-achụ ọbara nke aja nye m. Unu ahapụkwala aja sitere na Mmemme Ngabiga ka ọ nọọ ruo ụtụtụ. ");
INSERT INTO ibo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Wetanụ mkpụrụ mbụ niile nke ala ubi unu, bụ ndị kachasị mma nʼụlọ Onyenwe anyị, bụ Chineke unu. “Unu esikwala nwa ewu nʼime mmiri ara nne ya.” ");
INSERT INTO ibo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị, “Dee iwu ndị a m nyere gị, nʼihi na dịka okwu ndị a si dị, ka ọgbụgba ndụ mụ na gị na ụmụ Izrel gbara si dị.” ");
INSERT INTO ibo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosis na Onyenwe anyị nọ nʼebe ahụ iri ụbọchị anọ, ehihie na abalị. Ma nʼoge ndị a niile o righị nri ọbụla. Ọ ṅụkwaghị ihe ọṅụṅụ ọbụla. O dere na mbadamba nkume abụọ ahụ okwu niile nke ọgbụgba ndụ ahụ, nke bụ iwu iri ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mgbe Mosis ji mbadamba nkume abụọ nke ihe ama ahụ na-arịdata site nʼelu ugwu ahụ, ọ mataghị na ihu ya na-egbuke egbuke, nʼihi ọnọdụ nke ọ nọrọ nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nʼihi mgbuke ahụ ihu Mosis na-egbuke, ụjọ ekweghị Erọn na ụmụ Izrel bịaruo ya nso. ");
INSERT INTO ibo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma Mosis kpọrọ ha ka ha bịakwute ya. Nʼihi ya, Erọn na ndị ndu nzukọ Izrel bịara ka ha na Mosis kparịtaa ụka. ");
INSERT INTO ibo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mgbe e mesịrị, ndị Izrel niile bịakwutere ya. O nyekwara ha iwu ndị ahụ Onyenwe anyị nyere ya nʼelu ugwu Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mgbe Mosis gwachara ha okwu, o weere akwa kpuchie ihu ya. ");
INSERT INTO ibo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ma mgbe ọbụla ọ na-abanye nʼihu Onyenwe anyị ka ha kparịtaa ụka nʼime ụlọ nzute ahụ, ọ na-ekepụ akwa ahụ o ji kpuchie ihu ya tutu ruo mgbe ọ nọchara pụta. Mgbe ọ pụtara, ọ na-agwa ndị Izrel ihe niile Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ha hụkwara na ihu ya na akpụkpọ ihu ya na-egbuke egbuke. Emesịa, Mosis na-ekpuchikwa ihu ya tutu ruo mgbe ọ ga-abanye nʼime ka ya na Onyenwe anyị kparịta ụka. ");
INSERT INTO ibo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Emesịa, Mosis kpọrọ nzukọ ụmụ Izrel niile gwa ha sị, “Ndị a bụ iwu Onyenwe anyị nyere nke unu na-aghaghị idebe. ");
INSERT INTO ibo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Rụọnụ ọrụ ụbọchị isii, ụbọchị nke asaa bụ ụbọchị izuike, ụbọchị dị nsọ nke izuike nye Onyenwe anyị. Onye ọbụla rụrụ ọrụ nʼụbọchị nke asaa ga-anwụ. ");
INSERT INTO ibo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Unu amụnyela ọkụ nʼebe obibi unu nʼụbọchị izuike ahụ.” ");
INSERT INTO ibo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mgbe ahụ Mosis gwara nzukọ Izrel niile sị, “Nke a bụ iwu Onyenwe anyị nyere, ");
INSERT INTO ibo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","sitenụ nʼihe unu nwere wetara Onyenwe anyị onyinye. Onye ọbụla nke ọ masịrị, ya wetara Onyenwe anyị onyinye nke ihe ndị a: “Ọlaọcha, ọlaedo na bronz, ");
INSERT INTO ibo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ogho na-acha anụnụ anụnụ, nke odo odo, nke uhie uhie na nke ezi akwa ọcha, na ajị ewu; ");
INSERT INTO ibo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","akpụkpọ ebule e sijiri uhie uhie, akpụkpọ ehi mmiri, na osisi akashia; ");
INSERT INTO ibo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mmanụ oliv nke a ga-etinye nʼiheọkụ, ụda a na-etinye na mmanụ nsọ, na ụda na-eme ka aja nsure ọkụ na-esi isi ụtọ; ");
INSERT INTO ibo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","nkume ọma ọniks, na nkume ndị ọzọ a na-ahịọnye nʼefọọd, na nke a na-ahịọnyekwa nʼihe mgbochi obi. ");
INSERT INTO ibo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Unu niile ndị nwere onyinye ịkwa ǹka, bịanụ rụọ ihe ahụ niile Onyenwe anyị nyere anyị nʼiwu ịrụ, nke bụ ihe ndị a: ");
INSERT INTO ibo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“ụlọ nzute ahụ, na ihe mkpuchi ya, na nko ya niile, na mbudo ibo ya, na mkpọrọ osisi ya, na ogidi ya, na ụkwụ ya niile. ");
INSERT INTO ibo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Rụkwanụ igbe ọgbụgba ndụ ahụ, na mkpara ahụ e ji ebu ya. Ya na oche ebere ahụ. Mekwaanụ akwa mgbochi nke ga-ekpuchi ebe nsọ ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","na tebul ahụ, na mkpara e ji ebu ya, na ngwongwo ya niile, na achịcha nke iche nʼIhu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Mekwaa ebe ịdọkwasị oriọna maka ìhè, ya na ngwongwo ya niile, iheọkụ na mmanụ maka ịmụ ọkụ; ");
INSERT INTO ibo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","nʼebe ịchụ aja ihe nsure ọkụ na mkpara ya. Mmanụ nsọ ahụ na ihe nsure ọkụ na-esi isi ụtọ nke e ji ụda mee; akwa mgbochi maka ọnụ ụzọ nke dị nʼebe mbata ụlọ nzute ahụ; ");
INSERT INTO ibo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ebe ịchụ aja nke aja nsure ọkụ ya na ihe ọkpụkpa bronz ya, mkpara e ji ebu ya na ngwongwo ya niile, efere ukwu ahụ na ihe ndọkwasị ya. ");
INSERT INTO ibo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Akwa mgbochi nke ogige ụlọ ahụ na ogidi ha, na ihe ndọkwasị ya, nakwa akwa mgbochi nke ọnụ ụzọ e si abanye nʼogige ahụ; ");
INSERT INTO ibo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ǹtu maka ịkpọgide ụlọ ikwu ahụ na nke ogige ahụ, na ụdọ ha, ");
INSERT INTO ibo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","uwe niile a kpara akpa nke a na-eyi eje ozi nʼebe nsọ ahụ, ma uwe nsọ nke Erọn, onye nchụaja na uwe nke ụmụ ya ndị ikom na-eyi mgbe ha na-eje ozi ha dịka ndị nchụaja.” ");
INSERT INTO ibo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ugbu a, ọgbakọ ụmụ Izrel niile siri nʼihu Mosis pụọ. ");
INSERT INTO ibo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Onye ọbụla chọrọnụ na onye nke mmụọ ya kwaliri laghachiri azụ bịa wetara Onyenwe anyị onyinye nʼihi ọrụ nke ụlọ nzute ahụ na nʼihi ije ozi dị nʼime ya na nʼihi uwe nsọ ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ndị niile ọ metụrụ nʼobi, ma ndị nwoke ma ndị nwanyị bịara weta onyinye ha. Ha wetaara Onyenwe anyị onyinye ihe ịchọ mma nke ọlaedo dị iche iche: ihe ịkpọchi uwe, ọlantị, ọlaaka na ihe ndị ọzọ e ji achọ mma dị iche iche, nke e ji ọlaedo kpụọ. Ha chere ha nʼihu Onyenwe anyị dịka aja mfufe. ");
INSERT INTO ibo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ụfọdụ mmadụ wetara akwa na-acha anụnụ anụnụ na ngwakọta anụnụ na uhie na nke uhie uhie maọbụ ezi akwa ọcha maọbụ akpụkpọ ajị ewu, akpụkpọ ebule e sijiri ọbara ọbara na akpụkpọ ehi mmiri. ");
INSERT INTO ibo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ndị ọzọ wetara ọlaọcha na bronz, dịka onyinye ha nyere Onyenwe anyị, ụfọdụ wetara osisi akashia nke a ga-eji wuo ụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ụmụ nwanyị ndị bụ ọka nʼịdụ akwa na ikwe akwa tụrụ eri na-acha anụnụ anụnụ, na ngwakọta anụnụ na uhie, nke na-acha uhie uhie na nke ezi akwa ọcha, webata ha dịka onyinye. ");
INSERT INTO ibo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ụfọdụ ụmụ nwanyị kwa ji onyinye ǹka pụrụ iche ha nwere kpaa ajị ewu dịka akwa pụrụ iche. ");
INSERT INTO ibo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ndị ndu niile wetakwara nkume ọniks na nkume ndị ọzọ nke ịhịọnye nʼihe a ga-eji dụọ efọọd na ihe mgbochi obi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ha wetakwara ụda dị iche iche, mmanụ oliv nke a ga-etinye nʼiheọkụ, nke a ga-eji mee mmanụ otite dị nsọ, mekwa ihe nsure ọkụ na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nʼụzọ dị otu a ka ụmụ Izrel niile, ma nwoke ma nwanyị, ndị chọrọ inyeaka nʼọrụ ahụ Onyenwe anyị nyere Mosis nʼiwu si weta onyinye ha. Onye ọbụla nʼime ha nyere Onyenwe anyị onyinye afọ ofufu. ");
INSERT INTO ibo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mgbe ahụ, Mosis gwara ndị Izrel, sị, “Lee, Onyenwe anyị ahọpụtala Bezalel, nwa Uri, nwa Hua, onye si nʼebo Juda. ");
INSERT INTO ibo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","O mejupụtala na Mmụọ nke Chineke, nʼamamihe, nghọta na ihe ọmụma na ike ije ozi ọrụ ǹka dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ichepụta ihe ǹka dị iche iche, nke metụtara ọlaọcha na ọlaedo na bronz, ");
INSERT INTO ibo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ịwa nkume na ido nkume, ịkwa ǹka osisi nakwa ọrụ ǹka niile dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ma o tinyela nʼime ya na Oholiab, nwa Ahisamak, onye si nʼebo Dan, amara ikuziri ndị ọzọ ihe. ");
INSERT INTO ibo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","O mejupụtala ha nʼike ije ozi ọrụ ǹka dị iche iche, dịka igbunye akara, ise ihe osise, ịkpanye ihe ịchọ mma nʼakwa dị iche iche, ya bụ iji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, uhie uhie nakwa nʼezi akwa ọcha na nke ndị ọkpa akwa. Ha niile bụkwa ndị ǹka na ndị nchepụta ihe ịchọ mma doro anya.” ");
INSERT INTO ibo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ya mere, Bezalel na Oholiab na ndị ǹka niile Onyenwe anyị nyere ike na nghọta ịmata otu ha ga-esi rụọ ọrụ iwu ebe nsọ ahụ ga-arụ ọrụ ahụ dịka Onyenwe anyị nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mgbe ahụ, Mosis kpọrọ Bezalel na Oholiab na ndị ǹka ndị ahụ Onyenwe anyị nyere ike na nghọta, ndị wepụtara obi ha ịbịa ịrụ ọrụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ha si nʼaka Mosis nara onyinye ndị ahụ niile ụmụ Izrel wetara maka ịrụ ọrụ ebe nsọ ahụ. Ndị mmadụ nọkwa na-eweta onyinye afọ ofufu ha ụtụtụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nʼihi ya, ndị ọrụ ǹka niile nọ na-arụ ọrụ nʼebe nsọ ahụ hapụrụ ọrụ ha na-arụ, ");
INSERT INTO ibo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","bịakwute Mosis, sị ya, “Lee, onyinye ndị mmadụ na-eweta adịla ukwuu karịa ihe a chọrọ maka ịrụ ọrụ a Onyenwe anyị nyere nʼiwu.” ");
INSERT INTO ibo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mgbe ahụ, Mosis nyere iwu, ha zisara ozi ahụ nʼọmụma ụlọ ikwu niile sị, “Ka nwoke maọbụ nwanyị ọbụla gharakwa inwe ihe ọbụla nke ọ ga-eweta dịka onyinye maka ọrụ ebe nsọ a.” Nʼihi nke a, ndị mmadụ kwụsịrị iweta ihe ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Nʼihi na onyinye e wetara adịla ukwuu karịa ihe a chọrọ maka ọrụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ndị niile mara ǹka nʼetiti ndị ọrụ ahụ ji ezi ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie na uhie uhie wuo ụlọ nzute ahụ. Onye ọka kpanyekwara oyiyi cherubim nʼime ha. ");
INSERT INTO ibo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Akwa mgbochi ndị a ha nʼotu. Ịdị ogologo ha nʼotu nʼotu bụ mita iri na abụọ na ọkara. Obosara ha bụ otu mita na sentimita asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","E jikọtara akwa mgbochi ise nʼotu, jikọtakwa akwa ise nke ọzọ nʼotu. ");
INSERT INTO ibo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ha ji akwa na-acha anụnụ anụnụ dụnye anya nko nʼelu ọnụ akwa mgbochi nke otu ụzọ, otu a ka emekwara menyekwa na nsọtụ ọnụ akwa mgbochi nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ha dụnyere iri anya nko ise nʼotu akwa mgbochi, dụnyekwa iri anya nko ise nʼọnụ akwa mgbochi nke ọzọ, mee ka anya nko ndị a chee ibe ha ihu. ");
INSERT INTO ibo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Emesịa, ha ji iri nko ọlaedo ise jikọta ụzọ akwa mgbochi abụọ ndị a, si otu a mee ka ụlọ nzute ahụ ghọọ otu. ");
INSERT INTO ibo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ha ji akpụkpọ ajị ewu mee akwa mgbochi maka i ji kpuchie elu ụlọ nzute ahụ. Iri na otu ka ha ga-adị nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Akwa mgbochi iri na otu ndị a ha nʼotu. Ọ ga-abụ mita iri na atọ na ọkara nʼogologo, ebe obosara ya bụ otu mita na iri sentimita asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ha dụkọtara ise nʼime akwa mgbochi ahụ, debe ya iche. Dụkọtakwa isii nke fọdụrụ debekwa ya iche. ");
INSERT INTO ibo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Mgbe ahụ, ha dụnyekwara iri anya nko ise nʼelu ọnụ otu akwa mgbochi ndị ahụ. Mekwaa otu ihe ahụ nʼọnụ akwa mgbochi nke ọzọ e debere iche. ");
INSERT INTO ibo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ha mekwara iri nko bronz ise, iji jikọta ụlọ nzute ahụ ka ọ bụrụ otu. ");
INSERT INTO ibo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mgbe ahụ, ha ji akpụkpọ ebule e sijiri uhie uhie mee ihe mkpuchi maka ụlọ nzute ahụ, ya na akwa mkpuchi ọzọ nke e ji akpụkpọ ehi mmiri mee maka ịkpụkwasị nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ha meere ụlọ nzute ahụ mbudo ibo osisi akashia, guzo ọtọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Mbudo ibo ọ bụla dị mita anọ na ọkara nʼogologo, dịrịkwa iri sentimita asaa nʼobosara, ");
INSERT INTO ibo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","nwee ihe nhịọnye abụọ nke ga-abanye nʼime ibe ya ijikọ ha nʼotu. Ha rụrụ mbudo ibo ụlọ nzute ahụ niile otu a. ");
INSERT INTO ibo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ha rụrụ mbudo ibo iri abụọ maka akụkụ ndịda nke ụlọ nzute ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ma mekwaa iri ụkwụ ọlaọcha anọ nʼokpuru ha. Otu mbudo ibo ga-enwe ụkwụ abụọ, otu ụkwụ nʼokpuru otu ihe nhịọnye, otu ụkwụ nʼokpuru ihe nhịọnye nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Nʼakụkụ nke ọzọ bụ akụkụ ugwu nke ụlọ nzute ahụ, ha rụkwara iri mbudo ibo abụọ, ");
INSERT INTO ibo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","rụkwaa iri ụkwụ ọlaọcha anọ, ụkwụ abụọ nʼokpuru mbudo ibo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Nʼebe isi isi nsọtụ ya bụ akụkụ ọdịda anyanwụ nke ụlọ nzute, ha rụrụ mbudo ibo isii. ");
INSERT INTO ibo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Mbudo ibo abụọ ka e mere maka nkuku niile nke nsọtụ ụlọ nzute ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Nʼisi nkuku abụọ ndị a, mbudo ibo ndị a nọ iche iche site nʼokpuru ruo nʼelu ya; ma e jikọrọ ha ọnụ nʼime otu mgbaaka. Emere ka ha abụọ yie ibe ya. ");
INSERT INTO ibo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ha niile dị mbudo ibo asatọ na ụkwụ ọlaọcha dị iri na isii, ya bụ ụkwụ abụọ nʼokpuru mbudo ibo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ha ji osisi akashia mekwaa osisi ntụbichi, ise maka mbudo ibo ndị dị nʼotu akụkụ nke ụlọ nzute ahụ, ");
INSERT INTO ibo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ise nke ọzọ maka ndị dị nʼakụkụ nke ọzọ, ise nke ọzọ maka mbudo ibo dị nʼakụkụ ọdịda anyanwụ, nʼebe ndịda ndịda nke ụlọ nzute ahụ ");
INSERT INTO ibo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ha mere osisi ntụbichi nke dị nʼetiti ka ọ gabiga site nʼotu isi ruo nʼisi nke ọzọ nke mbudo ibo ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ha ji ọlaedo machie mbudo ibo ndị ahụ niile. Kpụkwaa mgbaaka ọlaedo ka ọ bụrụ ọnọdụ ịchịkọta mkpọrọ osisi ahụ niile. Ha ji ọlaedo machiekwa mkpọrọ osisi ndị ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ha ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, uhie uhie na ezi akwa ọcha a kpara nke ọma mee akwa mgbochi. Onye ǹka kpanyekwara oyiyi cherubim nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ha mere ogidi osisi akashia anọ maka ya were ọlaedo machie ha. Ha meere ha anya nko; wukwara ha ụkwụ ọlaọcha anọ. ");
INSERT INTO ibo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ha mere akwa mgbochi maka ọnụ ụzọ mbata nke ụlọ ikwu ahụ, nke e ji ogho na-acha anụnụ anụnụ, na ngwakọta anụnụ na uhie, na uhie uhie, na ezi akwa ọcha a kpara nke ọma, nke bụ akaọrụ onye ǹka. ");
INSERT INTO ibo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ha rụrụ ogidi ise ya na anya nko ha. Ha ji ọlaedo machie isi ogidi ahụ na ihe mkpọrọ ha, were bronz rụọ ụkwụ ise ha. ");
INSERT INTO ibo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel ji osisi akashia wuo igbe ọgbụgba ndụ nke ịdị ogologo ya bụ otu mita na sentimita iri. Obosara ya ga-abụ sentimita iri isii na asatọ. Ịla elu ya ga-abụkwa sentimita iri isii na asatọ. ");
INSERT INTO ibo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","O ji ọlaedo a nụchara anụcha machie nʼime na azụ ya, jirikwa ọlaedo kpụọ ihe gburugburu akụkụ ya niile. ");
INSERT INTO ibo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ọ kpụrụ mgbaaka ọlaedo anọ maka ya, kwụnyekwa ha nʼụkwụ anọ ya, ya bụ mgbaaka abụọ nʼotu akụkụ, mgbaaka abụọ nʼakụkụ nke ọzọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","O jikwa osisi akashia ahụ mee okporo osisi, machiekwa ha ọlaedo. ");
INSERT INTO ibo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","O tinyekwara mkpara ndị ahụ nʼime mgbaaka ahụ dị nʼakụkụ igbe ahụ; ka ọ bụrụ ihe iji na-ebu ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Emesịa, o ji ọlaedo a nụchara anụcha mee ihe e ji ekwuchi igbe ahụ. Aha a na-akpọ okwuchi igbe a bụ Oche Ebere. Ịdị ogologo ya dị otu mita na sentimita iri, obosara ya dị iri sentimita asaa. ");
INSERT INTO ibo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Mgbe ahụ, o ji ọlaedo a nụchara anụcha, nke e tipịara etipịa, kpụọ cherubim abụọ na nsọtụ abụọ nke ebe mkpuchi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","A rụnyere otu cherub nʼotu nsọtụ, otu cherub na nsọtụ nke ọzọ; nʼisi nsọtụ abụọ ahụ, ka o jikọtara ha ọnụ ka ha na okwuchi igbe ahụ bụrụ otu. ");
INSERT INTO ibo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubim ndị a gbasara nku ha laa elu, were ha na-ekpuchi okwuchi ahụ. Cherubim ndị ahụ cherịtara onwe ha ihu, na-ele anya nʼebe okwuchi ahụ dị. ");
INSERT INTO ibo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Emesịa, o mere tebul nke ịdị ogologo ya bụ iri sentimita itoolu. Obosara ya bụ iri sentimita ise, ịla elu ya bụ iri sentimita asaa. Ọ bụ osisi akashia ka o ji mee ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ọ bụkwa ọlaedo a nụchara anụcha ka e ji machie ya. A kpụnyekwara ihe ọkpụkpụ ọlaedo gburugburu ọnụ ọnụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A rụnyere ihe nʼọnụ ọnụ tebul ahụ nke ịla elu ya ga-eru sentimita asatọ. Ihe a dị gburugburu ọnụ ọnụ tebul ahụ, ọ bụkwa ọlaedo a kpụrụ akpụ ka e ji rụọ ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ha kpụrụ mgbaaka ọlaedo anọ maka tebul ahụ; kwụnyekwa ha nʼakụkụ anọ ahụ nʼebe ụkwụ anọ ya dị. ");
INSERT INTO ibo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","E tinyere mgbaaka ndị ahụ nso nso ihe njikọ ahụ ka ha jide mkpara ndị ahụ, e ji ebu tebul ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","O jikwa osisi akashia mee okporo osisi ahụ e ji ebu tebul ahụ. Jirikwa ọlaedo machie ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","O mekwara ihe niile na-adị nʼelu tebul ahụ: efere, ngaji, ọkwa na iko, nke e ji awụpụ aja ihe ọṅụṅụ. Ọ bụkwa ọlaedo a nụchara anụcha ka o ji kpụọ ha. ");
INSERT INTO ibo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ha ji ọlaedo a nụchara anụcha kpụọ ihe ịdọkwasị oriọna. Ha kpụrụ ụkwụ ala ala ya, na alaka ya, mekwaa ka iko ya niile yiri okoko osisi, nʼisi ya niile, na ifuru ya niile bụrụ otu ya na ahụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Alaka isii sitere nʼakụkụ abụọ nke ihe ịdọkwasị oriọna ahụ wapụta, alaka atọ nʼotu akụkụ ya, alaka atọ nʼakụkụ nke ọzọ. ");
INSERT INTO ibo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Iko atọ e mere dịka okoko osisi alụmọnd ya na ifuru, ya na okoko ya niile dịkwa nʼotu alaka; iko atọ nʼalaka nke ọzọ, otu a ka ọ ga-adị nʼalaka isii niile ahụ na-awapụta site nʼihe ịdọkwasị oriọna ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Nʼelu ihe ịdọba oriọna ahụ, enwere iko anọ dịka ifuru osisi alụmọnd, ya na ebe o si awapụta na okoko ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Otu isi dị nʼokpuru alaka abụọ si nʼetiti ihe ịdọba oriọna ahụ pụta, isi nke abụọ ga-adị nʼokpuru alaka abụọ nke ọzọ, isi nke atọ ga-adị nʼokpuru alaka nke atọ, ya bụ ha niile alaka isii. ");
INSERT INTO ibo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Isi nwapụta ya na alaka ya niile dịkọtara ọnụ, ha na ihe ịdọkwasị oriọna ahụ, nke e ji ọlaedo a nụchara anụcha rụọ. ");
INSERT INTO ibo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ha mekwara oriọna asaa ya, ma mkpa ya na ihe ịkpakepụ ọkụ ya niile. Ha bụ ọlaedo a nụchara anụcha. ");
INSERT INTO ibo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ha sitere na iri kilogram atọ na anọ nke ọlaedo a nụchara anụcha kpụọ ihe ịdọkwasị oriọna ahụ na ngwongwo ya niile. ");
INSERT INTO ibo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ha ji osisi akashia wuo ebe ịchụ aja a na-anọ esure ihe nsure ọkụ na-esi isi ụtọ. Akụkụ anọ ya ha nʼotu. Ogologo ya na obosara ya bụ iri sentimita anọ na ise. Ịdị elu ya bụ iri sentimita itoolu. Mpi ya niile si na ya pụta. ");
INSERT INTO ibo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ha ji ọlaedo a nụchara anụcha machie elu ya; akụkụ ya niile nakwa mpi ya niile. Ha jikwa ọlaedo kpụlite ọnụ ọnụ ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ha kpụnyere mgbaaka ọlaedo abụọ nʼokpuru ihe ahụ akpụlitere akpụlite, abụọ na ncherita ihu akụkụ ọ bụla, ebe a ga na-ejide mkpara e ji ebu ya. ");
INSERT INTO ibo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ha ji osisi akashia mee mkpara ndị ahụ. Jirikwa ọlaedo machie ha. ");
INSERT INTO ibo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ha mekwara mmanụ otite dị nsọ, na ezigbo ihe nsure ọkụ na-esi isi ụtọ nke a na-agwaghị ihe; bụ ọrụ nke onye na-eme mmanụ isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ha ji osisi akashia wuo ebe ịchụ aja nke aja nsure ọkụ. Nke ịla elu ya dị otu mita na iri sentimita atọ. Ogologo ya na obosara ya ha nʼotu. Ha dị mita abụọ na iri sentimita atọ, mita abụọ na iri sentimita atọ. ");
INSERT INTO ibo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ha rụnyekwara mpi nʼakụkụ anọ nke ebe ịchụ aja ahụ nʼotu nʼotu. Mee ka mpi ndị a na ebe ịchụ aja ahụ ghọọ nke e jikọtara nʼotu. Ha jikwa bronz machie ebe ịchụ aja a. ");
INSERT INTO ibo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ha ji bronz kpụọ ngwongwo niile dị iche iche, ya bụ efere ikpofu ntụ, shọvel ya niile, efere ịkwọsa mmiri niile, ngaji eze ịdụta anụ na efere ndị e ji agụ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ha mere ngịga mbadamba maka ebe ịchụ aja ahụ, ihe ọkpụkpa bronz, nke ga-adị nʼokpuru oghere ọnụ ọnụ ya. ");
INSERT INTO ibo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ha kpụrụ mgbaka bronz ndị a ga-eji jide mkpara ndị ahụ maka akụkụ anọ nke ngịga bronz ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ha mere mkpara osisi akashia ndị a, were bronz machie ha. ");
INSERT INTO ibo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ha mere ka mkpara ndị ahụ baa nʼime mgbaaka ndị ahụ, ime ka ha dịrị nʼakụkụ abụọ nke ebe ịchụ aja ahụ maka iji nʼebu ya. Ha ji obodobo osisi rụọ ya dịka igbe. ");
INSERT INTO ibo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ha ji bronz kpụọ efere ukwu na ihe ndọkwasị ya. Ọ bụ enyo nke ndị inyom ahụ ndị na-eje ozi nʼọnụ ụzọ ụlọ nzute ka e ji kpụọ ha. ");
INSERT INTO ibo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ọzọ, ha mere ogige ahụ. Ịdị ogologo nke nʼakụkụ ndịda dị iri mita anọ na ise. O nwere akwa mgbochi nke e ji ezi akwa ọcha a kpara nke ọma mee. ");
INSERT INTO ibo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Iri ogidi abụọ ga-adị na iri ebe ndọkwasị abụọ nke e ji bronz kpụọ. Anya nko ogidi ndị ahụ ha na ihe ikegide ha ga-abụ ọlaọcha. ");
INSERT INTO ibo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Otu a kwa, akụkụ ugwu dịkwa iri mita anọ na ise. O nwere iri ogidi abụọ na iri ebe ndọkwasị abụọ nke e ji bronz kpụọ, na anya nko nke ọlaọcha na ihe e ji ekegide ha nʼogidi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Akụkụ ọdịda anyanwụ dị iri mita abụọ na atọ. Nwekwaa akwa mgbochi, nwere ogidi iri na ebe ndọkwasị iri, tinyere anya nko ọlaọcha na ihe e ji ekegide ha nʼogidi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Nʼakụkụ ọwụwa anyanwụ, ebe anwụ na-awalite dịkwa iri mita abụọ na atọ nʼobosara. ");
INSERT INTO ibo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Akwa mgbochi nke ogologo ya dị mita isii na sentimita iri asatọ bụ ihe dị nʼotu akụkụ nke ọnụ ụzọ mbata ahụ. O nwere ogidi atọ na ebe ndọkwasị atọ. ");
INSERT INTO ibo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Otu a kwa, akwa mgbochi nke ịdị ogologo ya dị mita asaa bụ ihe dị nʼakụkụ nke ọzọ nke ọnụ ụzọ mbata nke ogige ahụ. Ọ ga-enwekwa ogidi atọ na ebe ndọkwasị atọ ");
INSERT INTO ibo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Akwa mgbochi niile nke ogige ahụ gburugburu bụ ezi akwa ọcha a kpara nke ọma. ");
INSERT INTO ibo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ogidi ọbụla nwere ihe ndọkwasị bronz. Nko niile na ihe njikọta niile ka e jikwa ọlaọcha machie. Ọ bụkwa naanị ọlaọcha ka e ji mee okporo osisi ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Akwa mgbochi nke ọnụ ụzọ mbata nke ogige ahụ bụ ihe e ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, uhie uhie na nke ezi akwa ọcha a kpara nke ọma mee; akaọrụ nke onye na-akpa ihe ịchọ mma. Ọ dị mita itoolu nʼogologo, yikwaa akwa mgbochi nke ebe ogige ahụ, dị mita abụọ na iri sentimita atọ nʼịdị elu. ");
INSERT INTO ibo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ọ bụ ogidi anọ ka e ji jidesie ha ike na ihe ndọkwasị bronz anọ, nko na okporo osisi ha niile bụ ọlaọcha. E jikwa ọlaọcha machie isi ogidi ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ǹtu niile nke ụlọ nzute ahụ nakwa nʼogige ya gburugburu bụ bronz ka e ji kpụọ ha. ");
INSERT INTO ibo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ndị a bụ ngwongwo niile e ji wuo ụlọ nzute ahụ; ebe a ga-edebe Ihe Ama ahụ. Ọ bụ ndị Livayị depụtara ihe niile ndị a nʼusoro dịka Mosis si nye ha nʼiwu. Ọ bụkwa Itama, nwa Erọn onye nchụaja, lekọtara ndị niile rụrụ ọrụ idekọta ya. ");
INSERT INTO ibo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, nwa Uri, nwa Hua, onye si nʼebo Juda, rụzuru ihe niile dịka Onyenwe anyị si nye ya Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Onye na-enyere ya aka bụ Oholiab nwa Ahisamak, onye ebo Dan, bụ onye ọka a maara aha ya, ọ bụ onye ọka ihe ọtụtụ, na onye ọka ịdụnye ihe ịchọ mma dị iche iche nʼakwa na-acha anụnụ anụnụ, nke ngwakọta anụnụ na uhie, uhie uhie nakwa ezi akwa ọcha. ");
INSERT INTO ibo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ịdị arọ nke onyinye ọlaedo niile sitere nʼaja mfufe ahụ nke ndị mmadụ wetara maka ịrụ ebe nsọ ahụ, bụ otu puku na narị kilogram ise. ");
INSERT INTO ibo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ịdị arọ nke ọlaọcha enwetara nʼaka ọgbakọ ahụ, bụ puku kilogram anọ, na narị kilogram isii na iri ise dịka shekel ebe nsọ si dị. ");
INSERT INTO ibo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ha niile tụrụ otu beka, otu isi, dịka ụtụ mgbe e kere ụtụ ọkara shekel dịka ọtụtụ shekel ebe nsọ si dị, e nyere nʼisi onye ọbụla nke gabigara nʼebe ndị a gụrụ ọnụ nọ, bụ ndị gbara iri afọ abụọ rigoo. Ọnụọgụgụ ha dị narị isii, na puku atọ, na narị ise, na iri ise. ");
INSERT INTO ibo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ịdị arọ nke ọlaọcha niile e ji rụọ ụkwụ ibo niile nke ebe nsọ ahụ, na ụkwụ ogidi niile e ji jidesie akwa mgbochi ndị ahụ ike bụ puku kilogram atọ, na narị kilogram isii. Ịdị arọ nke ọlaọcha e ji wuo ụkwụ ọbụla bụ iri kilogram atọ na isii. ");
INSERT INTO ibo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ịdị arọ nke ọlaọcha e ji menye nko nʼibo osisi niile, na nke e ji machie okporo osisi niile, na nke e ji techie isi ogidi osisi niile, bụ iri kilogram abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ịdị arọ nke bronz niile ndị mmadụ wetara dịka onyinye aja mfufe bụ puku kilogram atọ, na narị kilogram atọ, na iri isii. ");
INSERT INTO ibo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E ji bronz ndị a wuo ụkwụ ogidi niile a manyere nʼihu ụzọ e si abata ogige ụlọ nzute ahụ. E jikwa ya wuo ebe ịchụ aja bronz ahụ, na ihe ọkpụkpụ bronz ahụ, na ngwongwo niile e ji eje ozi nʼebe ịchụ aja, ");
INSERT INTO ibo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","na ụkwụ ogidi a manyere nʼihu ụlọ nzute, na ǹtu niile e ji wuo ụlọ nzute ahụ, na ogige gbara ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ha sitekwara nʼogho akwa na-acha anụnụ anụnụ na nke na-acha ngwakọta anụnụ na uhie (odo odo), nke na-acha uhie uhie, meere ndị nchụaja uwe akpara akpa nke ọma iyi jee ozi nʼebe nsọ ahụ. Ha meekwara Erọn uwe nsọ, nʼusoro iwu Onyenwe anyị nyere Mosis. ");
INSERT INTO ibo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ha ji ogho ọlaedo, na nke na-acha anụnụ anụnụ, nke na-acha ngwakọta anụnụ na uhie, na nke na-acha uhie uhie, nakwa nke ezi akwa ọcha a kpara nke ọma mee efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ha tipịara mpempe ọlaedo ndị ahụ mee ka ọ dị mbadamba. Bipụtasịa ha ntakịrị ntakịrị dịka eriri maka i ji ha kpanye nʼetiti ogho ndị a na-acha anụnụ anụnụ; ngwakọta anụnụ na uhie, nke uhie uhie nakwa nke ezi akwa ọcha ahụ, nke bụ akaọrụ onye ǹka. ");
INSERT INTO ibo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ha dụrụ akwa na-adị nʼubu maka efọọd ahụ, nke e jikọtara na nkuku ya abụọ, maka i ji na-ekechisi ya ike. ");
INSERT INTO ibo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ihe okike nke ukwu ahụ, nke onye ǹka kpaziri nke ọma yiri ya, ya na efọọd ahụ bụ otu, nke e ji ogho na-acha edo edo, anụnụ anụnụ, ngwakọta anụnụ na uhie na uhie uhie nakwa nke ezi akwa ọcha a kpara nke ọma mee, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ha doziri nkume ọniks ndị ahụ nʼime ihe ọlaedo a kpara akpa; ma gbunye aha ụmụ ndị ikom Izrel niile nʼelu ya dịka onye ọka si egbunye aha mmadụ nʼelu mgbaaka akara. ");
INSERT INTO ibo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ha jikọtara ha nʼelu akwa ubu nke efọọd ahụ, ka ọ bụrụ nkume ncheta mgbe ebighị ebi nye ụmụ Izrel, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ha mekwara ihe mgbochi obi, nke bụ ọrụ aka onye ǹka. Ha mere ya dịka e si mee efọọd ahụ. Ọ bụ ogho edo edo, nke na-acha anụnụ anụnụ, nke ngwakọta anụnụ na uhie, nke uhie uhie na ezi akwa ọcha a kpara nke ọma ka e ji mee ya. ");
INSERT INTO ibo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ọ ha nʼotu, iri sentimita abụọ na atọ nʼogologo, iri sentimita abụọ na atọ nʼobosara; nke apịajiri ụzọ abụọ. ");
INSERT INTO ibo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mgbe ahụ, ha hịọnyere ahịrị nkume anọ ndị dị oke ọnụahịa nʼime ya. Ụdị dị nʼahịrị nke mbụ bụ: nkume kanelian, krisolaịt na beril, ");
INSERT INTO ibo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","nʼahịrị nke abụọ bụ: nkume tọkwọisi, safaia na emeralụdụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Nʼahịrị nke atọ bụ: nkume jasint, ageeti na ametisiti. ");
INSERT INTO ibo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Nʼahịrị nke anọ bụ: nkume topaazi, ọniks na jaspa. Ahịọnyere ha nʼime ihe ọlaedo a kpara akpa. ");
INSERT INTO ibo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ha dị nkume iri na abụọ, nke ọbụla na-anọchi anya aha ụmụ ndị ikom Izrel. Egbunyere aha ebo iri na abụọ ahụ, otu nʼotu, nke ọbụla dịka aha ya si dị. ");
INSERT INTO ibo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ha ji ọlaedo a nụchara anụcha mee eriri a kpara akpa dịka ụdọ, maka ihe mgbochi obi. ");
INSERT INTO ibo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ha mere ihe ọlaedo abụọ nke a kpara akpa, ya na mgbaaka ọlaedo abụọ. Dụnyekwa mgbaaka ndị ahụ na nkuku abụọ nke ihe mgbochi obi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ha dụnyere ụdọ ọlaedo abụọ ndị ahụ nʼelu mgbaaka ndị ahụ dị na nkuku ihe mgbochi obi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Were isi ndị ọzọ nke ụdọ ahụ dụnye nʼihe ahụ a kpara akpa. Konye ha nʼelu ubu efọọd ahụ, nʼebe ihu ya. ");
INSERT INTO ibo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ha mere mgbaaka ọlaedo. Konyekwa ha na nkuku abụọ nke ihe mgbochi obi ahụ, nʼime ọnụ ọnụ ya ebe dị nso efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mgbe ahụ, ha kpụrụ mgbaaka ọlaedo abụọ ọzọ, konyekwa ha nʼelu ubu abụọ nke efọọd ahụ, nʼokpuru nʼebe ihu ya, na nso nso ebe a dụkọtara, nʼelu ihe okike ukwu nke efọọd ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ha jikwa eriri na-acha anụnụ kekọta mgbaaka ihe mgbochi obi ahụ na mgbaaka efọọd ahụ, jikọta ya na ihe okike ukwu ahụ, ime ka ihe mgbochi obi ahụ hapụ ịtọghapụ site nʼefọọd ahụ, dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ọ bụ akwa nke na-acha anụnụ anụnụ, ka ha ji dụọ uwe mwụda efọọd ahụ, ọrụ onye okwe akwa. ");
INSERT INTO ibo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A ga-enwe oghere nʼetiti uwe mwụda ahụ, dịka oghere olu uwe agha, nwekwa akwa nta a dụnyere nʼokpuru oghere a, ime ka o sie ike gharakwa ịdọka. ");
INSERT INTO ibo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ha ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie, nke na-acha uhie uhie na ezi akwa ọcha a kpara nke ọma kpanye oyiyi mkpụrụ pomegranet, gburugburu nʼọnụ ala ala uwe mwụda ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ha dụnyekwara ataṅụ e ji ọlaedo a nụchara anụcha kpụọ, gburugburu nʼọnụ ọnụ ala ya nʼetiti pomegranet ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Otu ataṅụ, otu oyiyi mkpụrụ pomegranet, otu a ka a dụnyere ya gburugburu ọnụ ọnụ ala uwe mwụda ahụ, nke a ga-eyi mgbe a na-eje ozi, dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ha ji ezi akwa ọcha metara Erọn na ụmụ ya ndị ikom, uwe ime ahụ, akaọrụ nke onye ọkpa akwa, ");
INSERT INTO ibo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","jirikwa ezi akwa ọcha mee akwa ike nʼisi, okpu akwa ọcha, na uwe ukwu nke ezi akwa ọcha a kpara nke ọma. ");
INSERT INTO ibo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ihe ike nʼukwu bụ nke e ji ogho na-acha anụnụ anụnụ, ngwakọta anụnụ na uhie uhie, na uhie uhie, nke ezi akwa ọcha a kpara nke ọma, ọrụ aka onye ǹka na-akpanye ihe ịchọ mma, dịka Onyenwe anyị si nye Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ha mere efere, bụ okpu nsọ ahụ, site nʼọlaedo a nụchara anụcha, gbunyekwa akara nʼelu ya, dịka ihe e dere nʼelu mgbaaka akara: Ihe nsọ dịrị Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mgbe ahụ, ha kenyere ya eriri na-acha anụnụ anụnụ i ji jikọta ya na ihe ike nʼisi ahụ, dịka Onyenwe anyị nyere ya Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Otu a ka ha si rụchaa ọrụ iwu ụlọ nzute ahụ. Ndị Izrel mere ihe niile dịka Onyenwe anyị si nye Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Mgbe ahụ, ha buteere Mosis ụlọ nzute ahụ: ụlọ ikwu ahụ ya na ngwongwo ya niile, ya bụ nko ya niile, mbudo ibo ya niile, mkpọrọ osisi ya niile, ogidi ya niile na ụkwụ ya niile, ");
INSERT INTO ibo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na akpụkpọ ebule e sijiri uhie uhie, akpụkpọ ehi mmiri e ji emechi elu ụlọ nzute ahụ, na akwa mgbochi, ");
INSERT INTO ibo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na igbe iwu ọgbụgba ndụ ahụ, ya na mkpara e ji ebu ya, na oche ebere ya, ");
INSERT INTO ibo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na tebul ahụ, ya na ngwongwo ya niile na achịcha nke iche nʼIhu Onyenwe anyị, ");
INSERT INTO ibo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na ihe ịdọkwasị oriọna e ji ọlaedo a nụchara anụcha kpụọ, na iheọkụ ya niile na ngwongwo ya niile, na mmanụ oliv maka ịmụ ọkụ, ");
INSERT INTO ibo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na ebe ịchụ aja ọlaedo, mmanụ nsọ na ụda na-esi isi ụtọ na akwa mgbochi nke ọnụ ụzọ ụlọ nzute, ");
INSERT INTO ibo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na ebe ịchụ aja bronz ahụ, na ihe ọkpụkpa bronz ya, mkpara ya niile na ngwongwo ya niile, efere ukwu ahụ ya na ihe ndọkwasị ya, ");
INSERT INTO ibo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","akwa mgbochi nke ogige ụlọ ahụ, na ogidi ya na ihe ndọkwasị ya nakwa akwa mgbochi nke ọnụ ụzọ e si abanye nʼogige ahụ; ụdọ na ǹtu ịkpọgide ogige ahụ; ngwongwo niile nke ụlọ nzute ahụ, ụlọ ikwu nzute ahụ ");
INSERT INTO ibo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na uwe niile a kpara akpa, nke a na-eyi eje ozi nʼebe nsọ ahụ, ma uwe nsọ nke Erọn, onye nchụaja, na uwe nke ụmụ ya ndị ikom na-eyi mgbe ha na-eje ozi ha dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ndị Izrel niile rụzuru ọrụ ndị a niile dịka Onyenwe anyị si nye ya Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mosis nʼonwe ya hụkwara ọrụ ndị a niile, nabata ya ka nke e jere dịka iwu Onyenwe anyị nyere si dị. Nʼihi ya, Mosis gọziri ha. ");
INSERT INTO ibo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Guzobe ụlọ nzute ahụ nʼụbọchị mbụ nke ọnwa mbụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Dọnye igbe ọgbụgba ndụ nke Ihe Ama ahụ nʼime ya. Konyekwa akwa mgbochi nke ga-ezo ya. ");
INSERT INTO ibo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Webata tebul ahụ, na ngwongwo dị nʼelu ya, webatakwa ihe ịdọba oriọna ahụ. Mụnyekwa oriọna ndị ahụ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Doo ebe ịchụ aja ọlaedo ahụ nke e mere maka ịchụ aja ihe nsure ọkụ na-esi isi ụtọ nʼihu igbe iwu ọgbụgba ndụ ahụ. Konyekwa akwa mgbochi nke kwesiri ịdị nʼọnụ ụzọ e si abata nʼime ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Doo ebe ịchụ aja nke aja nsure ọkụ ahụ nʼihu ọnụ ụzọ ịbata nʼụlọ nzute bụ ụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Dọnye efere ukwu ịsa mmiri ahụ nʼetiti ụlọ nzute na ebe ịchụ aja ahụ. Gbajukwaa ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Guzobe ogige gburugburu ụlọ nzute ahụ. Konyekwa akwa mgbochi nʼọnụ ụzọ ogige ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Were mmanụ nsọ ahụ tee ụlọ nzute ahụ, ya na ihe niile dị nʼime ya, si otu a doo ha nsọ ma ngwongwo ịchọ mma ya niile. Ọ ga-abụ ebe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mgbe ahụ, tee ebe ịchụ aja nke aja nsure ọkụ ahụ mmanụ ya na ihe ya niile e ji eje ozi. Doo ebe ịchụ aja ahụ nsọ, ọ ga-abụkwa ebe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tekwaa efere ukwu ịsa mmiri ahụ na ụkwụ ya mmanụ. Doo ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Kpọbata Erọn na ụmụ ya ndị ikom nʼọnụ ụzọ ụlọ nzute. Jiri mmiri saa ha ahụ nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Yikwasị Erọn uwe nsọ ya. Tekwaa ya mmanụ, ido ya nsọ maka i jere m ozi dịka onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mekwaa ka ụmụ ya ndị ikom bịaruo nso, yikwasịkwa ha uwe ime ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tee ha mmanụ dịka i si tee nna ha, ime ka ha bụrụ ndị na-ejere m ozi dịka ndị nchụaja. Otite mmanụ ha ga-abụ nye ọrụ nchụaja ha nke ga-adịgide site nʼọgbọ ruo nʼọgbọ.” ");
INSERT INTO ibo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mosis mezuru ihe niile dịka Onyenwe anyị nyere ya nʼiwu ime. ");
INSERT INTO ibo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","O ruo, nʼụbọchị mbụ nke ọnwa mbụ, nʼafọ nke abụọ, e mere ka ụlọ nzute ahụ guzo ọtọ. ");
INSERT INTO ibo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosis mere ka ụlọ nzute ahụ guzo ọtọ site nʼitinye mbudo ibo ya niile, ụkwụ ya na mkpọrọ osisi ya niile nʼọnọdụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Emesịa, ọ gbasapụrụ ihe mkpuchi nʼelu ụlọ nzute ahụ, tụkwasịkwa okpukpu ihe mkpuchi nke abụọ nʼelu ya dịka Onyenwe anyị nyere ya iwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","O tinyere Ihe Ama nʼime igbe ọgbụgba ndụ ahụ. Emesịa, ọ tụkwasịkwara mkpara e ji ebu igbe ahụ nʼakụkụ igbe ahụ, were okwuchi igbe ahụ, nke bụ Oche Ebere ahụ, kpuchie igbe iwu ọgbụgba ndụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Emesịa, o bubatara igbe ahụ nʼime ụlọ nzute ahụ, kwụnyekwa akwa mgbochi nke mgbochi, kewapụ igbe iwu ọgbụgba ndụ ahụ, dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mosis dọnyere tebul ahụ nʼakụkụ ugwu nke ụlọ nzute ahụ, na mpụta nke akwa mgbochi ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ọ dọkwasịrị achịcha ahụ a na-edo nʼihu Onyenwe anyị nʼelu tebul ahụ, dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ọ dọkwasịrị ihe ịdọba oriọna ahụ nʼime ụlọ nzute nʼakụkụ tebul ahụ, nʼakụkụ ndịda nke ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ọ mụnyere oriọna ndị ahụ nʼihu Onyenwe anyị dịka Onyenwe anyị si nye nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mosis debere ebe ịchụ aja ọlaedo ahụ nʼime ụlọ nzute nso nso ebe akwa mgbochi ahụ dị, ");
INSERT INTO ibo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","surekwaa ihe nsure ọkụ na-esi isi ụtọ nʼelu ya, dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ọ kwụbara akwa mgbochi nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Debekwa ebe ịchụ aja nke aja nsure ọkụ ahụ nso ọnụ ụzọ ịba ụlọ nzute ahụ. O surekwara aja nsure ọkụ nʼelu ya, na aja onyinye mkpụrụ ọka dịka Onyenwe anyị si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ọ dọbara efere ịsa mmiri ahụ nʼetiti ụlọ nzute na ebe ịchụ aja, wụjuo ya mmiri, maka iji sachaa ihe. ");
INSERT INTO ibo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mosis, na Erọn, na ụmụ ya ndị ikom na-eji ya akwọcha aka ha, sakwaa ụkwụ ha. ");
INSERT INTO ibo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mgbe ọbụla ha na-abanye nʼụlọ nzute na mgbe ha na-abịa nso ebe ịchụ aja, ha na-asacha, dịka Onyenwe anyị nyere ya Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mosis guzobere ogige ahụ gburugburu ụlọ nzute ahụ na ebe ịchụ aja ahụ. O konyekwara akwa mgbochi nʼụzọ mbata nke ogige ụlọ nzute ahụ. Otu a, Mosis rụzuru ọrụ niile ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mgbe ahụ, igwe ojii kpuchiri ụlọ nzute ahụ, ebube Onyenwe anyị jupụtakwara nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mosis nʼonwe ya enweghị ike ịbanye nʼime ụlọ nzute ahụ nʼihi igwe ojii kpuchiri elu ya na ebube Onyenwe anyị jupụtara nʼụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Nʼime njegharị ha niile, mgbe ọbụla igwe ojii ahụ si nʼelu ụlọ nzute ahụ bilie, mgbe ahụ ka ụmụ Izrel na-ebuli njem. ");
INSERT INTO ibo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ma ọ bụrụ na igwe ojii ahụ ebilighị, ụmụ Izrel adịghị ebulikwa njem tutuu ruo mgbe o biliri. ");
INSERT INTO ibo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Igwe ojii Onyenwe anyị ahụ na-anọgide nʼelu ụlọ nzute ahụ nʼehihie ma nʼabalị, ọkụ na-esi nʼime ya na-enwupụta. Ndị Izrel niile na-ahụkwa ya anya ụbọchị niile nke ha jegharịrị nʼọzara.");
INSERT INTO ibo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Onyenwe anyị sitere nʼụlọ nzute ahụ kpọ Mosis oku, gwa ya sị, ");
INSERT INTO ibo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Gwa ụmụ Izrel sị, ‘Mgbe onye ọbụla nʼime unu wetaara Onyenwe anyị onyinye, ka onyinye ọ ga-eweta bụrụ anụ ụlọ si nʼetiti igwe ehi maọbụ igwe ewu na atụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Ọ bụrụ na ọ bụ onyinye aja nsure ọkụ e wetara site nʼigwe ehi, ọ bụ oke ehi nke na-enweghị ntụpọ ka ọ ga-eweta. Nʼọnụ ụzọ ụlọ nzute ka ọ ga-eweta ya, ka ọ bụrụ ihe Onyenwe anyị ga-anabata. ");
INSERT INTO ibo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Onye ahụ wetara ya ga-ebikwasị aka ya nʼisi anụ aja nsure ọkụ ahụ, a ga-anabata ya maka iji kpuchie mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Nwoke ahụ ga-egbu nwa oke ehi ahụ nʼihu Onyenwe anyị. Ụmụ ndị ikom Erọn, bụ ndị nchụaja ga-ewere ọbara ya fesa ya nʼakụkụ niile nke ebe ịchụ aja, nʼọnụ ụzọ e si abata ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ị ga-agba ehi aja nsure ọkụ ahụ akpụkpọ, bọkasịa ya ntakịrị ntakịrị. ");
INSERT INTO ibo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ụmụ Erọn, ndị nchụaja ga-etinye ọkụ nʼebe ịchụ aja ahụ, doo nkụ nʼusoro nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Mgbe ahụ, ụmụ Erọn ndị nchụaja ga-atụkwasị akụkụ ehi ahụ niile, na isi ya, na abụba ya, nʼelu nkụ ahụ na-enwu ọkụ nʼebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ma a ga-asacha ihe ndị dị nʼime afọ ya, na ụkwụ ya mmiri. Onye nchụaja ga-akpọ ha niile ọkụ nʼebe ịchụ aja ahụ. Ọ bụ onyinye aja nsure ọkụ, onyinye e nyere site nʼọkụ nke dị ezi ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Ọ bụrụ na onyinye aja nsure ọkụ ahụ si nʼigwe ewu na atụrụ, ọ ga-abụrịrị mkpi maọbụ ebule na-enweghị nkwarụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Onye wetara ya ga-egbu ya nʼihu Onyenwe anyị nʼakụkụ ebe ịchụ aja chere ihu nʼugwu. Ụmụ ndị ikom Erọn, bụ ndị nchụaja, ga-efesa ọbara ya nʼakụkụ niile nke ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Mgbe nke a gasịrị, onye ahụ wetara ya, ga-abọ ya. Onye nchụaja ga-ewere akụkụ ya niile, na isi ya, na abụba ya tụkwasị ha nʼelu nkụ ahụ na-enwu ọkụ dị nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ma ihe ndị dị nʼime afọ ya, na ụkwụ ya, ka onye ahụ ga-asa mmiri, tupu onye nchụaja eweta ha niile kpọọ ha ọkụ nʼebe ịchụ aja. Ọ bụ onyinye aja nsure ọkụ, onyinye e nyere site nʼọkụ, nke isisi ya dị ezi ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Ọ bụrụ na onyinye ọ na-enye Onyenwe anyị dịka aja nsure ọkụ bụ site nʼụmụ anụ ufe, ọ ghaghị ịbụ nduru, maọbụ nwa kpalakwukwu. ");
INSERT INTO ibo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Onye nchụaja ga-ewebata anụ ufe ahụ nʼebe ịchụ aja, tụbipụ isi ya, wụsa ọbara ya nʼakụkụ ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ọ ga-ewepụ akpa nri ya, na ihe dị ya nʼime, tụnye ha nʼakụkụ ọwụwa anyanwụ nke ebe ịchụ aja ahụ; ebe a na-ekposa ntụ. ");
INSERT INTO ibo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ọ ga-ejide nku ya abụọ nyawaa ha, ma ọ gaghị anyakapụcha ha. Mgbe ahụ, onye nchụaja ahụ ga-akpọ ya ọkụ nʼelu ebe ịchụ aja. Ọ bụ aja nsure ọkụ, onyinye e nyere site nʼọkụ, nke isisi ya dị Onyenwe anyị ezi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Mgbe onye ọbụla wetaara Onyenwe anyị onyinye mkpụrụ ọka, onyinye ya ga-abụ nke ezi ụtụ ọka a kwọrọ nke ọma. Ha ga-awụkwasị ya mmanụ oliv, tinyekwa ihe nsure ọkụ na-esi isi ụtọ nʼelu ya, ");
INSERT INTO ibo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ọ ga-ebutere ya ụmụ Erọn ndị nchụaja. Onye nchụaja ga-ekpoju ụtụ ọka na mmanụ ahụ nʼaka, tinyekwara ihe nsure ọkụ na-esi isi ụtọ niile ahụ, kpọọ ihe ndị a ọkụ dịka oke ncheta nʼelu ebe ịchụ aja. Ọ ga-abụkwa onyinye nsure ọkụ, nke na-esi isi ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ma nke fọdụrụ nʼonyinye ọka ahụ bụ nke Erọn na ụmụ ya. Ọ bụ oke dịkarịsịrị nsọ nke onyinye nsure ọkụ niile echere nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Ọ bụrụ na onyinye mmadụ wetara bụ achịcha eghere nʼite e ji eghe ihe, ọ ga-abụ nke e ji ezi ụtụ ọka a kwọrọ nke ọma mee. Ọ ga-abụ ogbe achịcha agwara mmanụ oliv nke a na-ejighị ihe na-eko achịcha mee, maọbụ achịcha mbadamba e tere mmanụ nke a na-ejighị ihe na-eko achịcha mee. ");
INSERT INTO ibo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ọ bụrụ na onyinye mmadụ wetara bụ achịcha e ghere eghe, achịcha ahụ aghaghị ịbụ nke e mere site nʼezi ụtụ ọka a kwọrọ nke ọma, nke a gwakọtara mmanụ, nke na-enweghị ihe na-eko achịcha nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Nyawasịa ya, wụkwasị ya mmanụ nʼelu, ọ bụkwa onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ọ bụrụ na onyinye mkpụrụ ọka gị bụ ihe e siri nʼite, ọ ghaghị ịbụ ezi ụtụ ọka a kwọrọ nke ọma, e tinyetụrụ mmanụ oliv. ");
INSERT INTO ibo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ị ga-ebute onyinye mkpụrụ ọka ahụ bunye ya onye nchụaja. Ọ ga-eche ya nʼihu Onyenwe anyị nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Onye nchụaja ga-ekporo ụfọdụ nʼaka dịka oke ncheta nʼime onyinye ọka ahụ, kpọọ ya ọkụ nʼelu ebe ịchụ aja dịka aja e surere nʼọkụ, nke isisi ya na-atọ Onyenwe anyị ezi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ma nke fọdụrụ nʼonyinye ọka ahụ bụ nke Erọn na ụmụ ya. Ọ bụ oke dịkarịsịrị nsọ nke onyinye nsure ọkụ niile echere nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Unu etinyela ihe na-eko ọka ọbụla nʼonyinye mkpụrụ ọka unu na-enye Onyenwe anyị, nʼihi na unu ekwesighị ịkpọ ihe na-eko achịcha maọbụ mmanụ aṅụ ọkụ nʼonyinye nsure ọkụ unu na-enye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unu nwere ike nye Onyenwe anyị achịcha e ji ihe na-eko achịcha na mmanụ aṅụ mee nʼoge onyinye owuwe ihe ubi, ma a gaghị eme otu a nʼoge onyinye ọchụchụ aja nsure ọkụ, nke na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Unu aghaghị itinye nnu nʼime onyinye mkpụrụ ọka ọbụla unu na-enye. Unu ahapụla ọgbụgba ndụ Chineke unu nʼonyinye mkpụrụ ọka unu. Tinyenụ nnu nʼonyinye unu niile. ");
INSERT INTO ibo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Ọ bụrụ na onyinye mkpụrụ ọka ị na-ewetara Onyenwe anyị bụ mkpụrụ mbụ nke ubi gị, site nʼọka ọhụrụ gị weta ọka a sụrụ asụ, maọbụ nke a hụrụ nʼọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tinye ya mmanụ na ụda na-esi isi ụtọ. Ọ ga-abụ onyinye ọka. ");
INSERT INTO ibo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Onye nchụaja ga-ewere oke ncheta nʼime ọka ahụ a sụrụ asụ, nke a gwara mmanụ na ụda na-esi isi ụtọ, dịka onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Ọ bụrụ na onye ọbụla achọọ inye onyinye aja udo, o nwere ike jiri anụ ụlọ si nʼigwe ehi, oke ehi maọbụ nwunye ehi. Ma anụ ahụ ọ ga-ewebata nʼihu Onyenwe anyị aghaghị ịbụ ehi na-enweghị nkwarụ. ");
INSERT INTO ibo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Onye ahụ wetara ya, ga-ebikwasị aka ya nʼisi anụ ahụ, gbuo ya nʼọnụ ụzọ ụlọ nzute. Mgbe ahụ ụmụ Erọn ndị ikom, bụ ndị nchụaja, ga-efesa ọbara ya nʼakụkụ niile nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Site nʼonyinye aja udo, ị ga-eweta onyinye nsure ọkụ nye Onyenwe anyị: abụba niile kpuchiri ihe dị nʼime afọ ya, na abụba niile nke metụtara ha, ");
INSERT INTO ibo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","akụrụ ya abụọ na abụba nke dị nʼelu ha ruo nʼakụkụ ukwu ya, na umeju ya na abụba kpuchiri umeju ya, nke ọ ga-ewepụ ya na akụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Mgbe ahụ, ụmụ Erọn ga-esunye ha ọkụ nʼelu aja nsure ọkụ a tụkwasịrị nʼosisi e sunyere ọkụ, ọ bụ onyinye nsure ọkụ, nke na-esi isi ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Ọ bụrụ na onyinye aja udo a na-achụrụ Onyenwe anyị bụ site nʼigwe ewu maọbụ atụrụ, ọ ghaghị ịbụ mkpi maọbụ nne ewu na-enweghị ntụpọ. ");
INSERT INTO ibo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ọ bụrụ onyinye atụrụ, onye ahụ ga-ewebata ya nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ọ ga-ebikwasị aka ya nʼisi atụrụ ahụ, gbuo ya nʼọnụ ụzọ ụlọ nzute. Ndị nchụaja, ụmụ Erọn, ga-efesa ọbara ya nʼakụkụ niile nke ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ị ga-esite nʼonyinye aja udo a, weta onyinye nsure ọkụ nye Onyenwe anyị: abụba ya, na abụba niile dị nʼọdụdụ ya nke a ga-esite nʼakụkụ ọkpụkpụ azụ ya bepụta, na abụba kpuchiri ihe dị nʼime afọ ya; na abụba niile nke metụtara ha, ");
INSERT INTO ibo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","na akụrụ ya abụọ, na abụba kpuchiri ha ruo nʼakụkụ ukwu ya, na umeju ya, na abụba kpuchiri ya; nke ọ ga-ewepụ ya na akụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Onye nchụaja ga-akpọ ha ọkụ nʼebe ịchụ aja dịka ihe oriri, onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ọ bụrụ na onye ọbụla eweta ewu dịka onyinye ọ na-eche nʼihu Onyenwe anyị, ");
INSERT INTO ibo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ọ ga-ebikwasị aka ya nʼisi ewu ahụ, gbuo ya nʼọnụ ụzọ ụlọ nzute. Ụmụ Erọn ndị ikom ga-efesa ọbara ya nʼakụkụ niile nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ọ bụ site nʼonyinye nke i wetara ka ị ga-esi chee onyinye nsure ọkụ nye Onyenwe anyị: abụba niile kpuchiri ihe dị nʼime afọ ya na abụba niile metụtara ha, ");
INSERT INTO ibo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","na akụrụ ya abụọ, na abụba kpuchiri ha ruo nʼakụkụ ukwu ya, na ihe kpuchiri umeju ya; nke ọ ga-ewepụ ya na akụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Onye nchụaja ga-akpọ ha ọkụ nʼelu ebe ịchụ aja dịka ihe oriri, onyinye nsure ọkụ, nke na-esi isi ụtọ. Abụba niile bụ nke Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Iwu ndị a ga-adịgide site nʼọgbọ ruo nʼọgbọ. Unu ga-edebezu ya nʼebe ọbụla unu bi. Unu agaghị eri abụba maọbụ ọbara ọbụla.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Gwa ụmụ Izrel okwu, sị ha, ‘Mgbe onye ọbụla mehiere na-amaghị ama, megide ihe ọbụla Onyenwe anyị nyere nʼiwu: ");
INSERT INTO ibo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ọ bụrụ na onye nchụaja e tere mmanụ emehie na-amaghị ama, si otu a weta ikpe ọmụma nʼisi ọha mmadụ. Ọ ga-ewetara Onyenwe anyị otu oke ehi na-enweghị ntụpọ dịka aja mmehie, nʼihi mmehie ahụ o mere. ");
INSERT INTO ibo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ọ ga-ewere oke ehi ahụ bịa nʼọnụ ụzọ ụlọ nzute, nʼihu Onyenwe anyị. Ọ ga-ebikwasị aka ya nʼisi ya, gbuo ya nʼebe ahụ nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mgbe ahụ, onye nchụaja e tere mmanụ ga-eburu ụfọdụ ọbara oke ehi ahụ baa nʼime ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ọ ga-edenye mkpịsịaka ya nʼime ọbara ahụ, fesa ya ugboro asaa nʼihu Onyenwe anyị, nʼihu akwa mgbochi nke ebe nsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Onye nchụaja ga-etekwasị ụfọdụ ọbara ahụ na mpi dị nʼebe ịchụ aja nke aja nsure ọkụ ihe na-esi isi ụtọ, nʼihu Onyenwe anyị nʼime ụlọ nzute. Ọbara fọdụrụ nʼoke ehi ahụ ka ọ ga-awụsa nʼụkwụ ebe ịchụ aja nke aja nsure ọkụ ahụ, nʼọnụ ụzọ ịba ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ọ ga-ewepụ abụba niile site nʼoke ehi aja mmehie, abụba niile kpuchiri ihe dị nʼime afọ ya na nke jikọtara ha, ");
INSERT INTO ibo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","na akụrụ ya abụọ na abụba kpuchiri ha ruo nʼakụkụ ukwu ya, na ihe kpuchiri umeju ya, nke ọ ga-ewepụ ya na akụrụ ya, ");
INSERT INTO ibo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","dịka e si ewepụ abụba oke ehi e ji chụọ aja udo. Mgbe ahụ, onye nchụaja ga-akpọ ha ọkụ nʼelu ebe ịchụ aja nke aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma akpụkpọ anụ oke ehi ahụ na ahụ ya niile, ma isi ya, na ụkwụ ya, na ihe dị nʼime afọ ya, na mgbịrị afọ ya, ");
INSERT INTO ibo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ihe niile fọdụrụ nʼoke ehi ahụ, ka a ga-ebupu nʼazụ ebe obibi ụmụ Izrel, ebe dị ọcha, ebe a na-ekpofu ntụ. Ebe ahụ ka a ga-anọ kpọọ ya ọkụ, nʼọkụ a kwanyere nʼebe a na-ekpofu ntụ. ");
INSERT INTO ibo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ọ bụrụ na nzukọ Izrel niile emehie na-amaghị ama, mee ihe ọbụla megidere ihe Onyenwe anyị nyere nʼiwu nke a na-adịghị eme eme, ọ bụ ezie na ndị obodo amaghị okwu a, mgbe ha ghọtara ikpe ọmụma ha ");
INSERT INTO ibo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","matakwa mmehie ha mehiere, nzukọ ahụ aghaghị iweta nwa oke ehi dịka aja mmehie, duru ya chee ya nʼihu ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ndị okenye nzukọ Izrel ga-ebikwasị aka ha nʼisi oke ehi ahụ nʼihu Onyenwe anyị. A ga-egbu ehi ahụ nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mgbe ahụ, onye nchụaja e tere mmanụ ga-ewere ụfọdụ nʼime ọbara ya baa nʼụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ọ ga-edenye mkpịsịaka ya nʼime ọbara ahụ fesa ya ugboro asaa nʼihu Onyenwe anyị, nʼihu akwa mgbochi ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ọ ga-ete ọbara ụfọdụ nʼelu mpi nke dị nʼebe ịchụ aja nke dị nʼihu Onyenwe anyị, nʼụlọ nzute. Ọ ga-awụ ọbara nke fọdụrụ nʼụkwụ ala ala, nʼebe ịchụ aja nke aja nsure ọkụ, nʼọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ọ ga-ewepụta abụba niile dị ya nʼahụ kpọọ ha ọkụ nʼelu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ọ ga-eme oke ehi ahụ ihe o mere oke ehi aja mmehie. Nʼụzọ dị otu a, onye nchụaja ga-ekpuchi mmehie ndị Izrel. A ga-agbagharakwa ha. ");
INSERT INTO ibo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Emesịa, onye nchụaja ga-eburu ozu oke ehi ahụ gaa nʼazụ obodo kpọọ ya ọkụ nʼebe ahụ, dịka o mere oke ehi nke mbụ. Nke a bụ aja mmehie nʼihi nzukọ Izrel. ");
INSERT INTO ibo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Mgbe otu nʼime ndịisi obodo mehiere na-amaghị ama, si otu a megide ihe Onyenwe anyị Chineke nyere nʼiwu banyere ihe a na-agaghị eme, mgbe ọ ghọtara ikpe ọmụma ya. ");
INSERT INTO ibo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ọ bụrụkwa na-eme ka ọ mata mmehie ya, ọ ghaghị iweta mkpi na-enweghị nkwarụ dịka onyinye nʼihi mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ọ ga-ebikwasị aka ya nʼisi mkpi ahụ. Gbuo ya nʼebe a na-egbu anụ aja nsure ọkụ, nʼihu Onyenwe anyị. Ọ bụ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mgbe ahụ, onye nchụaja ga-arụrụ ụfọdụ nʼime ọbara aja mmehie ahụ na mkpịsịaka ya tee ya nʼelu mpi ebe ịchụ aja nke aja nsure ọkụ. Nke fọdụrụ ka ọ ga-awụpụ nʼụkwụ ala ala ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ọ ga-akpọ abụba ya niile ọkụ nʼebe ịchụ aja dịka o si kpọọ abụba anụ e ji chụọ aja udo ọkụ. Nʼụzọ dị otu a, onye nchụaja ga-ekpuchiri onyeisi ahụ mmehie ya. A ga-agbaghara ya. ");
INSERT INTO ibo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Ọ bụrụ na otu onye nʼetiti ndị obodo ahụ emehie na-amaghị ama, mee ihe megidere ihe ọbụla Onyenwe anyị nyere nʼiwu nke a na-adịghị eme eme, mgbe ha ghọtara ikpe ọmụma ha, ");
INSERT INTO ibo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ọ bụrụkwa na-amata mmehie ha mere, ha ga-eweta nne ewu na-enweghị ntụpọ dịka onyinye nʼihi mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ọ ga-ebikwasị aka ya nʼelu isi aja mmehie ahụ, e gbuo ya nʼebe a na-achụ aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Onye nchụaja ga-ewere ụfọdụ ọbara ahụ na mkpịsịaka ya tee ya na mpi nke ebe ịchụ aja nke aja nsure ọkụ, ọ ga-awụ ọbara fọdụrụ nʼụkwụ ala ala ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ọ ga-ewepụ abụba ya niile dịka a na-eme nʼaja udo. Onye nchụaja ga-akpọ ha ọkụ nʼebe ịchụ aja, dịka ihe na-esi isi ụtọ nye Onyenwe anyị. Nʼụzọ dị otu a, onye nchụaja a ga-ekpuchikwara ha mmehie. A ga-agbagharakwa ha. ");
INSERT INTO ibo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Ma ọ bụrụ na mmadụ eweta otu atụrụ dịka onyinye nʼihi aja mmehie ya, ọ ghaghị ịbụ nne atụrụ na-enweghị ntụpọ. ");
INSERT INTO ibo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ọ ga-eweta ya nʼebe a na-egbu anụ aja nsure ọkụ. Ọ ga-ebikwasị ya aka nʼisi, gbuo ya nʼebe ahụ, ka ọ bụrụ aja mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Onye nchụaja ga-ewere ụfọdụ ọbara anụ aja mmehie ahụ na mkpịsịaka ya, tee ya na mpi dị nʼebe ịchụ aja nke aja nsure ọkụ. Ọ ga-awụ ọbara fọdụrụ nʼụkwụ ala ala nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ha ga-ewepụ abụba ya niile, dịka a na-eme nʼatụrụ aja udo. Onye nchụaja ga-akpọ abụba ahụ ọkụ nʼelu ebe ịchụ aja dịka onyinye nsure ọkụ a chụrụ nye Onyenwe anyị. Nʼụzọ dị otu a, onye nchụaja ga-ekpuchikwara ha mmehie nʼihi iwu ha dara. A ga-agbaghara ha mmehie ha. ");
INSERT INTO ibo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ọ bụrụ na mmadụ ọbụla emehie nʼihi na ọ jụrụ ikwupụta mgbe ọ nụrụ ọkwa amaara nʼọha maka ịgba ama banyere ihe ọ hụrụ maọbụ ihe ọ maara, ọ bụ onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Onye na-amaghị ama metụ ihe rụrụ arụ aka, dịka ozu anụ ọbụla iwu megidere, maọbụ anụ ụlọ, maọbụ anụ ọhịa, maọbụ anụ ọbụla na-akpụ akpụ nʼala. Ọ ghọọla onye rụrụ arụ, na onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ma ọ bụrụ na ha emetụ ihe ọbụla rụrụ arụ si nʼahụ mmadụ pụta aka, ihe ọbụla ga-eme ya ka ọ hapụ ịdị ọcha, ọ bụ ezie na ha amaghị na ọ bụ ihe rụrụ arụ, mgbe ọ matara ya, ọ ga-abụ onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ọ bụrụ na mmadụ a ṅụọ iyi nzuzu, nke ga-akwagide ya ime ihe ọbụla maọbụ ihe dị mma, maọbụ ihe dị njọ, mgbe onye ahụ ghọtara na ọ bụ iyi nzuzu ka ọ ṅụrụ, ọ bụrụla onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Onye ọbụla sitere nʼụzọ dị otu a bụrụ onye ikpe mara, ga-ekwupụta mmehie ya, dịka o si dị. ");
INSERT INTO ibo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ọ ga-ewetara Onyenwe anyị nne atụrụ, maọbụ nne ewu site nʼigwe ewu na atụrụ, dịka aja ikpe ọmụma maka mmehie ha mere. Onye nchụaja ga-achụrụ ha aja mkpuchi mmehie maka mmehie ha. ");
INSERT INTO ibo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Ọ bụrụ na o nweghị ike iweta atụrụ, ọ ga-ewetara Onyenwe anyị nduru abụọ, maọbụ kpalakwukwu abụọ, dịka ihe ikpe ọmụma mmehie ha. Otu nʼime nnụnụ ndị a ga-abụ maka aja mmehie, nke ọzọ ga-abụ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ọ ga-eweta ha nye onye nchụaja. Onye ga-ewere nnụnụ nke mbụ chụọ aja mmehie. Ọ ga-atụbipụ olu ya, kama ọ gaghị ekewapụcha isi nnụnụ ahụ site nʼahụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ọ ga-efesa ụfọdụ ọbara aja mmehie ahụ nʼakụkụ ebe ịchụ aja, ma ọbara fọdụrụ ka ọ ga-awụsa nʼụkwụ ala ala ebe ịchụ aja. Nke a ga-abụ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Onye nchụaja ga-eji nnụnụ nke ọzọ chụọ aja nsure ọkụ. Ọ ga-agbaso usoro e debere maka ịchụ aja nsure ọkụ. Ọ ga-ekpuchikwara ha mmehie ha mere. A ga-agbagharakwa ha. ");
INSERT INTO ibo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Ọ bụrụ na onye ahụ enweghị ike iweta nduru abụọ, maọbụ kpalakwukwu abụọ, ọ ga-eweta iko ọka asaa a kwọrọ nke ọma ka ọ bụrụ onyinye aja mmehie. Ọ gaghị etinye ya mmanụ oliv na ụda na-esi isi ụtọ, nʼihi na ọ bụ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ha ga-ewere ya bịakwute onye nchụaja, onye ga-ekporo nke ga-eju ya aka ya dịka oke ncheta. Kpọọ ya ọkụ nʼebe ịchụ aja nke onyinye nsure ọkụ e chere nʼihu Onyenwe anyị. Nke a ga-abụkwa aja mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nʼụzọ dị otu a, onye nchụaja ga-achụrụ ya aja ikpuchi mmehie ya niile. A ga-agbagharakwa ya. Ụtụ ọka fọdụrụ ga-abụ nke onye nchụaja, dịka e si mee ya nʼaja onyinye mkpụrụ ọka.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Mgbe onye ọbụla sitere na-amaghị ama mehie, merụọ ihe nsọ niile nke Onyenwe anyị, bụrụ onye nke nʼekwesighị ntụkwasị obi nye Onyenwe anyị. Ọ ga-ewetara Onyenwe anyị otu ebule na-enweghị ntụpọ site nʼigwe anụ, dịka ọnụahịa ya si dị nʼọlaọcha, nʼusoro shekel nke ebe nsọ. Ọ bụ aja ikpe ọmụma. ");
INSERT INTO ibo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ọ ga-akwụghachikwa ụgwọ ihe nsọ ndị ahụ niile nke ọ na-emezughị. Ọ ga-atụkwasị otu ụzọ nʼime ụzọ ise nke ọnụahịa ya nʼelu ya, were ha niile nye onye nchụaja. Onye nchụaja ahụ ga-ewere ebule ahụ na ihe ndị a chụọrọ ya aja mkpuchi mmehie, nʼihi ikpe ọmụma ya. A ga-agbagharakwa ya. ");
INSERT INTO ibo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ma ọ bụrụ na mmadụ ọbụla emehie, mee ihe ọbụla megidere iwu ọbụla Onyenwe anyị nyere, ọ bụ ezie na e mere mmehie a na-amaghị ama, ma ikpe mara ha, ọ ga-atakwa ahụhụ soo ya. ");
INSERT INTO ibo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ọ ga-ewetara onye nchụaja ihe aja ikpe ọmụma nke bụ otu ebule na-enweghị ntụpọ site nʼigwe anụ, nke ọnụahịa ga-abụ ihe o ruru. Nʼụzọ dị otu a, onye nchụaja ga-achụrụ ya aja mkpuchi mmehie nʼihi ihe ọjọọ o mere na-amaghị ama. A ga-agbaghara ya mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ọ bụ aja ikpe ọmụma, nʼihi na onye mehiere megide Onyenwe anyị ka ọ bụ.” ");
INSERT INTO ibo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ọ bụrụ na onye ọbụla emehie bụrụ onye na-ekwesighị ntụkwasị obi nye Onyenwe anyị, site nʼiduhie onye agbataobi ya banyere ihe e tinyere ya nʼaka idebe, maọbụ izunarị mmadụ ihe, maọbụ iji aghụghọ nara mmadụ ibe ya ihe; ");
INSERT INTO ibo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","maọbụ site nʼijide ihe furu efu nke ọ chọtara ghaa ụgha banyere ya. Ma ọ bụrụ na ha a ṅụọ iyi na ha ejighị ya, maọbụ gbasara ụdị mmehie mmadụ pụrụ ime. ");
INSERT INTO ibo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Mgbe ha mehiere nʼụzọ ọbụla nʼime ụzọ ndị a niile, ghọta na ikpe mara ha. Ha aghaghị inyeghachi onye nwe ihe ahụ ha zuru nʼohi, maọbụ ihe ha pụnara nʼike, maọbụ ihe e nyere ya idebe, ma ọ bụkwanụ ihe ahụ furu efu ọ chọtara, ");
INSERT INTO ibo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","maọbụ ihe ọbụla ọ ṅụrụ nʼiyi ụgha. Ọ ga-akwụghachi ihe ndị a niile nʼuju, tụkwasịkwa otu ụzọ nʼime ụzọ ise nke ọnụahịa ihe ahụ, nyeghachi ya onye nwe ya, nʼụbọchị ahụ ọ ga-eweta aja ikpe ọmụma ya. ");
INSERT INTO ibo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ọ ga-ewetara onye nchụaja nʼihu Onyenwe anyị, aja ikpe ọmụma ya nke bụ ebule na-enweghị ntụpọ site nʼigwe anụ, nke ọnụahịa ya ga-abụ ihe ahụ e gbubiri iji ịkwụ ụgwọ mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Nʼụzọ dị otu a, onye nchụaja ga-ekpuchikwara ya mmehie ya nʼihu Onyenwe anyị, a ga-agbaghakwara ha nʼihi ihe ọbụla ha mere nke ikpe ji maa ha.” ");
INSERT INTO ibo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Nye Erọn na ụmụ ya ndị ikom iwu sị: ‘Ndị a bụ usoro iwu metụtara aja nsure ọkụ. Aja nsure ọkụ ga-adịgide nʼekwu ahụ dị nʼebe ịchụ aja site nʼabalị ruo nʼụtụtụ. A ga-akwanyekwa ọkụ na-adị nʼebe ịchụ aja hapụ ya ka o nwuo abalị niile. ");
INSERT INTO ibo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mgbe chi bọrọ, onye nchụaja ga-eyiri uwe ime ahụ ya nke akwa ọcha, nakwa uwe elu ahụ ya, gaa kpopu ntụ dị nʼekwu nke ebe ịchụ aja nsure ọkụ ahụ, wụsa ha nʼakụkụ ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Mgbe o mesịrị nke a, ọ ga-agbanwe uwe ya, kporo ntụ ahụ, buru ya pụọ nʼazụ ogige ahụ gaa wufuo ya nʼebe ahụ e mere ka ọ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ọkụ dị nʼebe ịchụ aja ga na-enwu mgbe niile, a gaghị ekwe ka ọ nyụọ. Nʼụtụtụ niile onye nchụaja ga-akwanye ya nkụ ọhụrụ, tụkwasịkwa aja nsure ọkụ nʼelu ya surekwaa abụba aja udo nʼelu ya. ");
INSERT INTO ibo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ọkụ ga-enwugide nʼebe ịchụ aja mgbe niile. A gaghị ekwe ka ọ nyụọ mgbe ọbụla.’ ");
INSERT INTO ibo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Ndị a bụ usoro iwu gbasara onyinye mkpụrụ ọka. Ụmụ Erọn ndị ikom ga-eguzo nʼihu ebe ịchụ aja iche ya nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mgbe ahụ, onye nchụaja ga-ekpoju ọka ahụ a kwọrọ nke ọma, na ụfọdụ mmanụ oliv, tinyere ụda na-esi isi ụtọ nʼaka ya dịka oke ncheta. Kpọọ ya ọkụ nʼelu ebe ịchụ aja ka ọ nọchie anya onyinye ahụ niile, nke isisi ya dị Onyenwe anyị ezi mma. ");
INSERT INTO ibo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Erọn na ụmụ ya ndị ikom ga-eri nke fọdụrụnụ. Ma a ga-eri ya na-ejighị ihe na-eko achịcha, nʼime ebe nsọ, nʼogige ụlọ nzute ka a ga-anọ eri ya. ");
INSERT INTO ibo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Agaghị etinye ya ihe na-eko achịcha ma a na-eghe ya. Enyela ya ka ọ bụrụ oke ruuru ha site nʼonyinye nsure ọkụ e chere nʼihu m. Ha bụkwa ihe dịkarịsịrị nsọ, dịka aja ikpe ọmụma na aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nwoke ọbụla sitere nʼagbụrụ Erọn, onye nchụaja, nwere ike iri ya. Ọ bụ oke ọ ga na-eketa site nʼonyinye nsure ọkụ niile echere nʼihu Onyenwe anyị ruo nʼọgbọ niile na-abịa. Ihe ọbụla metụrụ ha ahụ ga-aghọ ihe dị nsọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Onyenwe anyị gwakwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Nke a bụ aja Erọn na ụmụ ya ndị ikom ga-achụrụ Onyenwe anyị nʼụbọchị a ga-ete ya mmanụ. Ọ ga-abụ ọtụtụ ruru lita abụọ nke ọka dị ezi mma dịka aja onyinye a na-achụ mgbe niile. Ha ga-enye otu ọkara ya nʼụtụtụ, nye nke ọzọ nʼuhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ha ga-etinye ya mmanụ, ghee ya nʼite. Ị ga-ebubata ya mgbe a gwọkọrọ ya nke ọma, chee ya dịka aja ọka a nyawasịrị anyawasị nke isisi ya dị Onyenwe anyị ezi mma. ");
INSERT INTO ibo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Nwa nwoke ahụ nke ga-anọchi ya dịka onye nchụaja e tere mmanụ bụ onye ga-akwado ya. Ọ bụ oke ruuru Onyenwe anyị ebighị ebi, bụrụkwa nke a ga-esure ọkụ kpamkpam. ");
INSERT INTO ibo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Onyinye mkpụrụ ọka ọbụla nke onye nchụaja nyere ka a ga-akpọ ọkụ kpamkpam. A gaghị eri ya eri.” ");
INSERT INTO ibo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Onyenwe anyị sịrị Mosis, ");
INSERT INTO ibo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Gwa Erọn na ụmụ ya ndị ikom, sị, ‘Ndị a bụ usoro iwu unu ga-edebe banyere aja mmehie. A ga-egbu anụ aja mmehie nʼihu Onyenwe anyị, nʼebe ahụ a na-egbu anụ aja nsure ọkụ. Ọ bụ ihe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Onye nchụaja chụrụ ya ga-eri anụ ya, ọ bụ nʼakụkụ ebe nsọ ahụ, ya bụ nʼogige ụlọ nzute ahụ ka a ga-anọ rie ya. ");
INSERT INTO ibo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ihe ọbụla metụrụ anụ nke ọbụla aka, ga-aghọ ihe dị nsọ. Ọ bụrụkwa na ọbara ya efesa nʼuwe ọbụla, ị ga-asụ uwe ahụ nʼakụkụ ebe nsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A ghaghị itiwa ite aja e ji sie anụ ahụ. Ọ bụrụkwanụ nʼite bronz ka e siri ya, a ga-asa ite ahụ mmiri nke ọma, saa ya ka ọ dị ezi ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Nwoke ọbụla a mụrụ nʼezinaụlọ ndị nchụaja nwere ike iri anụ ahụ, ọ bụ ihe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ma a gaghị eri anụ aja mmehie ọbụla, bụ nke e webatara ọbara ya nʼime ụlọ nzute maka ikpuchi mmehie nʼEbe nsọ ahụ. Aghaghị ịkpọ ya ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Ndị a bụ usoro iwu banyere aja ikpe ọmụma, bụ nke dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A ga-egbu anụ aja ikpe ọmụma ahụ nʼebe a na-egbu anụ aja nsure ọkụ, were ọbara ya fesaa nʼakụkụ niile nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Abụba ya niile ka a ga-enye dịka onyinye: abụba dị nʼọdụdụ ya, na abụba niile kpuchiri ihe dị nʼime afọ ya, ");
INSERT INTO ibo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","na akụrụ abụọ ya, na abụba nke dị nʼelu ha, ruo nʼakụkụ ukwu ya, na umeju ya, na abụba kpuchiri ya. ");
INSERT INTO ibo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Onye nchụaja ga-akpọ ha ọkụ nʼelu ebe ịchụ aja dịka onyinye nsure ọkụ nye Onyenwe anyị. Ọ bụ aja ikpe ọmụma. ");
INSERT INTO ibo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nwoke ọbụla a mụrụ nʼezinaụlọ ndị nchụaja nwere ike iri anụ fọdụrụ na ya, maọbụ nʼebe nsọ ka aghaghị ịnọ rie ya. Ọ bụ ihe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Otu iwu a metụtakwara aja ikpe ọmụma na aja mmehie. Anụ ọbụla fọdụrụ ga-abụ nke onye nchụaja ahụ nke ji ha chụọ aja mkpuchi mmehie. Oke ya ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Onye nchụaja nke chụrụ aja nsure ọkụ nʼisi onye ọbụla, ka ọ dịrị iwere akpụkpọ niile si nʼanụ ahụ o ji chụọ aja nye onwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","A ga-ebunye onye nchụaja chụrụ aja mkpụrụ ọka nke e ji ụtụ ọka chụọ, ụtụ ọka fọdụrụ. Otu a ka ọ ga-adịkwa nʼaja achịcha ọbụla a nụrụ anụ, maọbụ nke e siri esi, maọbụ nke e ghere eghe. Ihe ọbụla fọdụrụ ga-abụ nke onye nchụaja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Aja mkpụrụ ọka ọbụla, ma nke e tinyere mmanụ, ma nke a na-etinyeghị mmanụ, nke fọdụrụ ga-abụ nke ụmụ ndị ikom Erọn. ");
INSERT INTO ibo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Ndị a bụ usoro iwu gbasara aja udo nke mmadụ ọbụla nwere ike chụọrọ Onyenwe anyị nʼaja: ");
INSERT INTO ibo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Ọ bụrụ na ha enye ya dịka aja ekele, tinyere aja ekele a ha ga-eweta ogbe achịcha a na-ejighị ihe na-eko achịcha mee, nke a gwakọtara ya na mmanụ oliv, na mbadamba achịcha a na-ejighị ihe na-eko achịcha mee, nke e tere mmanụ nʼelu ya, nakwa achịcha e ji ọka a kwọrọ nke ọma a gwakọtara ya na mmanụ nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ọ ga-ewetakwa onyinye achịcha ọzọ nke e ji ihe na-eko achịcha, ya bụ, yiist mee, tinyere aja udo nke ekele ha. ");
INSERT INTO ibo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ha ga-esikwa na ya weta otu nʼime onyinye ọbụla, chee nʼihu Onyenwe anyị, dịka onyinye. Ọ bụ nke ndị nchụaja ahụ na-efesa ọbara anụ e ji chụọ aja udo nʼelu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ma anụ ahụ eji chụọ aja onyinye udo nke ekele, ka a ga-eri nʼotu ụbọchị ahụ e ji ha chụọ aja. O nweghị nke a ga-ahapụ ka ọ bọọ chi. ");
INSERT INTO ibo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Ma ọ bụrụ na onyinye mmadụ wetara bụ onyinye afọ ofufu, maọbụ onyinye o wetara nʼihi nkwa o kwere, a ga-eri anụ aja ahụ nʼụbọchị ahụ a chụrụ ya, nweekwa ike rie nke fọdụrụ ma chi bọọ. ");
INSERT INTO ibo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ma anụ ọbụla fọdụrụ nʼime anụ aja ahụ, nke a na-erichapụghị nʼụbọchị nke abụọ ahụ ka a ga-akpọ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ọ bụrụ na e rie anụ aja udo ahụ nʼụbọchị nke atọ, a gaghị anabata ya. A gaghị agụnyere ya onye ahụ wetara ya nʼihi na ihe rụrụ arụ ka ọ bụ. Onye ọbụla riri ya ga-abụ onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Anụ ọbụla nke metụrụ ihe rụrụ arụ aghọọla ihe na-adịghị ọcha. A gaghị eri ya. A ga-akpọ ya ọkụ. Ma nʼebe anụ ndị ọzọ dị, onye ọbụla e mere ka ọ dị ọcha nwere ike iri ya. ");
INSERT INTO ibo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","A ga-esite nʼetiti ndị m kewapụ onye ọbụla riri anụ e ji chụọ aja udo nye Onyenwe anyị mgbe onye ahụ nọ nʼọnọdụ adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Onye ọbụla metụrụ ihe ọbụla rụrụ arụ aka, ma ịrụ arụ ahụ o si na mmadụ, ma o si nʼanụ ọhịa, ma o si nʼihe ọbụla ọzọ, a ga-esite nʼetiti ndị ya kewapụ ya ma ọ bụrụ na onye ahụ anọrọ nʼọnọdụ ahụ rie anụ e ji chụọ aja udo nye Onyenwe anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mgbe ahụ, Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Gwa ụmụ Izrel okwu sị ha, ‘Unu erila abụba ehi, maọbụ nke ewu, maọbụ nke atụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Abụba anụ ọbụla nwụrụ anwụ maọbụ nke anụ ọhịa gburu adịghị mma oriri. E nwere ike jiri ha mee ihe ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","A ga-ekewapụ mmadụ ọbụla site nʼetiti ndị ya, bụ onye na-eri abụba anụmanụ nke a ga-esite na ya chee onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ọzọkwa, unu erila ọbara nnụnụ maọbụ nke anụmanụ nʼebe ọbụla unu bi. ");
INSERT INTO ibo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Onye ọbụla riri ọbara ka a ga-ekewapụ site nʼetiti ndị ya.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Onyenwe anyị gwakwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Gwa ụmụ Izrel okwu sị ha, ‘Onye ọbụla wetaara Onyenwe anyị onyinye aja udo aghaghị iweta ụfọdụ nʼime onyinye ahụ dịka onyinye pụrụ iche nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ha ga-eji aka ha chee onyinye nsure ọkụ ahụ nʼihu Onyenwe anyị. Ha ga-eweta abụba ahụ, ya na obi anụ, fufee obi anụ ahụ nʼihu Onyenwe anyị dịka aja mfufe. ");
INSERT INTO ibo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Onye nchụaja ga-akpọ abụba ahụ ọkụ nʼebe ịchụ aja, ma obi anụ ahụ ga-abụ nke Erọn na ụmụ ya ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Unu ga-enye onye nchụaja apata aka nri nke anụ aja udo ahụ, dịka onyinye. ");
INSERT INTO ibo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Nwa Erọn, onye ji ọbara na abụba chụọ aja udo ahụ ga-ewere apata aka nri ya dịka oke ruuru ya. ");
INSERT INTO ibo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Site nʼonyinye ụmụ Izrel na-enye nʼoge aja udo, ewerela m obi anụ ahụ a na-efufe efufe, na apata anụ a na-eche nʼihu m nye Erọn, onye nchụaja na ụmụ ya ndị ikom ka ha bụrụ oke ruuru ha mgbe ọbụla ụmụ Izrel na-achụ aja udo.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Nke a bụ akụkụ anụ ahụ e ji chụọ aja nsure ọkụ nye Onyenwe anyị, nke e nyekwara Erọn na ụmụ ya ndị ikom nʼụbọchị ahụ e chere ha nʼihu Onyenwe anyị ijere ya ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Nʼihi na nʼụbọchị ahụ e tere ha mmanụ ka Onyenwe anyị nyere ụmụ Izrel iwu sị ha nye Erọn na ụmụ ya ndị ikom oke ndị a oge niile, site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ndị a bụ usoro iwu metụtara aja nsure ọkụ, na aja mkpụrụ ọka, na aja mmehie, na aja ikpe ọmụma, na onyinye ido nsọ, na aja udo. ");
INSERT INTO ibo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Onyenwe anyị nyere Mosis iwu ndị a nʼugwu Saịnaị nʼụbọchị ahụ o nyere ụmụ Izrel iwu sị ha, wetara Onyenwe anyị onyinye nʼọzara Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kpọta Erọn na ụmụ ya ndị ikom, chịtakwa uwe ha, weta mmanụ nsọ, oke ehi nke aja mmehie na ebule abụọ ahụ, na nkata achịcha a na-ejighị ihe na-eko achịcha mee. ");
INSERT INTO ibo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kpọkọtaa ọgbakọ ụmụ Izrel niile ka ha bịa nʼọnụ ụzọ ụlọ nzute.” ");
INSERT INTO ibo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mosis mere ihe Onyenwe anyị gwara ya ka o mee. Ọgbakọ ụmụ Izrel zukọtara nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mosis gwara ọgbakọ ahụ sị, “Nke a bụ ihe Onyenwe anyị nyere nʼiwu ka e mee.” ");
INSERT INTO ibo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mgbe ahụ, Mosis kpọpụtara Erọn na ụmụ ya ndị ikom nʼihu, jiri mmiri saa ha ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","O yikwasịrị Erọn uwe ime ahụ, kee ya ihe okike a na-eke nʼukwu, yikwasịkwa ya uwe mwụda na efọọd ahụ, jiri ihe okike ahụ a chọrọ mma kegidesie efọọd ahụ ike nʼahụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","O tụkwasịrị ya ihe igbochi obi ahụ nʼahụ, tinye Urim na Tumim nʼime ihe igbochi obi ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ọ tụhịkwara akwa ike nʼisi ahụ nʼisi Erọn, tinye nʼihu akwa ike nʼisi ahụ, okpu nsọ e ji ọlaedo kpụọ, nke bụ akara ido nsọ, dịka Onyenwe anyị si nye Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mgbe ahụ, Mosis weere mmanụ nsọ ahụ tee nʼụlọ nzute ahụ, na nʼihe niile dị nʼime ya, ido ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ọ fesakwara ụfọdụ nʼime mmanụ ahụ ugboro asaa nʼebe ịchụ aja, fesakwa ya ugboro asaa nʼelu ngwongwo niile dị nʼebe ịchụ aja, na nʼefere e ji asa ihe, na ụkwụ ya, ido ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ọ wụsara Erọn ụfọdụ mmanụ nsọ ahụ nʼisi, tee ya mmanụ, nʼihi ido ya nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ọ kpọtara ụmụ ndị ikom Erọn nso, o yikwasịrị ha uwe ime ahụ, kee ha ihe okike nke ukwu, kekwasị ha ihe okike nʼisi, dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ọ kpụtara oke ehi e ji achụ aja mmehie, mee ka Erọn na ụmụ ya ndị ikom bikwasị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mosis gburu oke ehi ahụ, were ụfọdụ nʼime ọbara ahụ, jiri mkpịsịaka ya rụta ọbara tee na mpi niile dị nʼebe ịchụ aja, ido ebe ịchụ aja ahụ nsọ. Ọ wụpụrụ ọbara nke fọdụrụ nʼụkwụ ala ala nke ebe ịchụ aja ahụ. Otu a ka o si doo ya nsọ, ikpuchiri ya mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mosis wekwara abụba niile dị gburugburu ihe dị nʼime afọ ehi ahụ, mba-umeju nke umeju ya, akụrụ abụọ ya na abụba dị nʼelu ha, kpọọ ya ọkụ nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma oke ehi ahụ, akpụkpọ ya, anụ ya na mgbịrị afọ ya, ka ọ kpọrọ ọkụ nʼazụ ọmụma ụlọ ikwu ahụ dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","O weere ebule ahụ, chee nʼihu Onyenwe anyị, dịka aja nsure ọkụ. Erọn na ụmụ ya ndị ikom bikwasịrị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mgbe ahụ, Mosis gburu ebule ahụ, fesa ọbara ya nʼakụkụ niile nke ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ọ bọwasịrị ebule ahụ ntakịrị ntakịrị, kpọọ isi ya, iberibe anụ ya na abụba ya ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ọ sachara ihe dị nʼime afọ ya na ụkwụ ya niile mmiri, kpọọ ebule ahụ niile ọkụ nʼebe ịchụ aja. Nʼihi na ọ bụ aja nsure ọkụ nke isisi ya dị Onyenwe anyị ezi mma, nʼihi na ọ bụ dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","O kpụpụtara ebule nke ọzọ, bụ ebule nke ido nsọ, Erọn na ụmụ ya ndị ikom bikwasịrị aka ha nʼelu isi ya. ");
INSERT INTO ibo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mgbe ahụ, Mosis gburu ya, were ụfọdụ nʼime ọbara ya tee Erọn nʼọnụ ntị aka nri, na nʼisi mkpụrụ aka nke aka nri ya, na nʼisi mkpụrụ ụkwụ nke aka nri ya. ");
INSERT INTO ibo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mosis kpọtara ụmụ ndị ikom Erọn nso, weere ụfọdụ ọbara ahụ tee nʼọnụ ntị aka nri ha, na nʼisi mkpụrụ aka nke aka nri ha, na nʼisi mkpụrụ ụkwụ nke aka nri ha. O fesakwara ọbara nʼakụkụ niile nke ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","O weere abụba ya, akụkụ ọdụdụ ya nwere abụba, na abụba niile nke kpuchiri ihe dị nʼime afọ ya, na mba-umeju nke dị nʼumeju ya, akụrụ ya abụọ na abụba ha, na apata aka nri ya ");
INSERT INTO ibo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","O sitere na nkata achịcha ahụ a na-ejighị ihe na-eko achịcha mee, nke dị nʼihu Onyenwe anyị, wepụta otu ogbe achịcha, na otu ogbe achịcha a gwakọtara mmanụ oliv, na otu mbadamba ogbe achịcha, tụkwasị ha nʼelu abụba ndị ahụ, na nʼelu apata aka nri ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","O tinyere ihe ndị a niile nʼaka Erọn na ụmụ ya ndị ikom, ha fufere ha nʼihu Onyenwe anyị dịka aja mfufe. ");
INSERT INTO ibo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mosis naara ya site nʼaka ha, kpọọ ha ọkụ nʼelu ebe ịchụ aja, ya na aja nsure ọkụ, ka ọ bụrụ aja ido nsọ nke isisi ya dị ezi mma, onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mosis werekwara obi ebule ido nsọ ahụ, fufee ya nʼihu Onyenwe anyị, dịka aja mfufe, dịka Onyenwe anyị nyere nʼiwu. Nke a bụ oke Mosis. ");
INSERT INTO ibo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mgbe ahụ, Mosis weere ụfọdụ nʼime mmanụ nsọ ahụ, na ụfọdụ nʼime ọbara ahụ dị nʼebe ịchụ aja fesa ya Erọn na uwe ya, fesakwa ya ụmụ ndị ikom Erọn nʼuwe ha. Otu a ka o si doo Erọn na uwe ya, na ụmụ ya ndị ikom na uwe ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mgbe ahụ, Mosis gwara Erọn na ụmụ ya ndị ikom sị, “Sienụ anụ ahụ nʼọnụ ụzọ ụlọ nzute. Nọrọkwanụ nʼebe ahụ rie ya na achịcha ahụ dị nʼime nkata onyinye ido nsọ, dịka a gwara m, sị, ‘Erọn na ụmụ ya ndị ikom ga-eri ya.’ ");
INSERT INTO ibo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ihe ọbụla fọdụrụ na anụ ahụ na achịcha ahụ, ka unu ga-akpọ ọkụ.” ");
INSERT INTO ibo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ọ sịrị ha: “Unu esikwala nʼọnụ ụzọ ụlọ nzute a pụọ ruo ụbọchị asaa, tutu ruo mgbe ụbọchị ido nsọ unu zuruoke, nʼihi na ido nsọ unu ga-anọ ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ihe niile e mere nʼụbọchị taa bụ ihe Onyenwe anyị nyere nʼiwu, banyere ịchụ aja maka mkpuchi mmehie unu.” ");
INSERT INTO ibo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Unu aghaghị ịnọgide nʼọnụ ụzọ ụlọ nzute ehihie na abalị ụbọchị asaa, mezuokwa ihe Onyenwe anyị nyere nʼiwu, ka unu ghara ịnwụ. Nʼihi na nke a bụ iwu e nyere m. ");
INSERT INTO ibo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ya mere, Erọn na ụmụ ya ndị ikom mezuru ihe niile dịka Onyenwe anyị si nye nʼiwu site nʼọnụ Mosis. ");
INSERT INTO ibo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Nʼụbọchị nke asatọ, Mosis kpọrọ Erọn na ụmụ ya ndị ikom, na ndị okenye Izrel. ");
INSERT INTO ibo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ọ gwara Erọn sị, “Site nʼime igwe ehi were nwa oke ehi ị ga-eji chụọ aja mmehie. Werekwa ebule na-enweghị ntụpọ ị ga-eji chụọ aja nsure ọkụ, nke m ga-eche nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ọ gwakwara ụmụ Izrel sị ha, ‘Họrọnụ mkpi a ga-eji chụọ aja mmehie, na nwa ehi, na nwa atụrụ na-enweghị ntụpọ, ndị gbara naanị otu afọ, a ga-eji chụọ aja nsure ọkụ, ");
INSERT INTO ibo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na ehi, na ebule a ga-eji chụọ aja udo nʼihu Onyenwe anyị, tinyere mkpụrụ ọka a gwara mmanụ. Nʼihi na taa ka Onyenwe anyị ga-eme ka unu hụ ya anya.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ha wetara ihe ndị a niile bịa nʼọnụ ụzọ ụlọ nzute dịka Mosis nyere nʼiwu. Ọgbakọ ụmụ Izrel niile bịara nso guzo nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mgbe ahụ, Mosis sịrị ha, “Ihe ndị a bụ ihe Onyenwe anyị nyere unu nʼiwu idebe, ka ebube ya si otu a pụta ìhè nʼihu unu.” ");
INSERT INTO ibo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mosis sịrị Erọn, “Bịa nso nʼebe ịchụ aja. Chụọ aja mmehie, na aja nsure ọkụ nke a ga-eji kpuchie mmehie gị na mmehie ndị ahụ niile. Chụọ aja onyinye dịrị ndị ahụ, maka ikpuchiri ha mmehie ha, dịka Onyenwe anyị nyere nʼiwu.” ");
INSERT INTO ibo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Erọn bịara nso nʼebe ịchụ aja, gbuo nwa ehi ahụ ka ọ bụrụ aja mmehie nke ya. ");
INSERT INTO ibo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ụmụ Erọn buteere ya ọbara ehi ahụ. O tinyere mkpịsịaka ya nʼime ọbara ahụ tee ya na mpi dị nʼebe ịchụ aja. Ọ wụrụ ọbara fọdụrụ nʼụkwụ ala ala ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ọ kpọrọ abụba ya, na akụrụ ya abụọ, na ihe kpuchiri umeju si nʼaja mmehie ahụ ọkụ nʼebe ịchụ aja dịka Onyenwe anyị nyere Mosis iwu. ");
INSERT INTO ibo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ma anụ ahụ ya, na akpụkpọ ya, ka ọ kpọrọ ọkụ nʼazụ ebe obibi. ");
INSERT INTO ibo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Emesịa, o gburu anụ e wetara maka aja nsure ọkụ ahụ. Ụmụ ya ndị ikom nyere ya ọbara anụ ahụ, nke o fesara gburugburu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ha nyefere ya aja nsure ọkụ ahụ nʼaka nʼotu ha sị bọọ ya, tinyere isi ya. Ọ kpọrọ ihe niile ọkụ nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ọ sachara ihe dị nʼime afọ ya, na ụkwụ ya, kpọọ ha ọkụ, dịka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Emesịa, Erọn wetara onyinye nke dị maka ndị mmadụ, o were ewu ahụ bụ maka mmehie ndị mmadụ, gbuo ya, were chụọ aja mmehie, dịka o mere nke mbụ. ");
INSERT INTO ibo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ọ chụkwara aja nsure ọkụ nʼusoro dịka iwu e nyere si dị. ");
INSERT INTO ibo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","O webatakwara aja mkpụrụ ọka ahụ, kporo nke juru ya aka, kpọọ ya ọkụ nʼelu ebe ịchụ aja, tinyekwara aja nsure ọkụ nke ụtụtụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Nʼikpeazụ, o gburu ehi na ebule ahụ, nke bụ aja udo ndị Izrel. Ụmụ Erọn buteere ya ọbara nke o fesara gburugburu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ọ chịkọtara abụba niile dị ehi na ebule ndị ahụ nʼahụ, na ọdụdụ ha, na abụba kpuchiri ihe ime ha, ya na akụrụ ha, na abụba kpuchiri umeju ha, ");
INSERT INTO ibo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","tụkwasị ha nʼobi anụ ndị ahụ, kpọọ ha ọkụ nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mgbe ahụ, Erọn fufere, dịka onyinye mfufe, obi anụ ahụ, na apata aka nri ha nʼihu Onyenwe anyị dịka Mosis nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Erọn weliri aka ya elu nʼebe ụmụ Izrel nọ, gọzie ha. Emesịa, mgbe ọ chụchara aja mmehie, na aja nsure ọkụ na aja udo, o sitere nʼebe ịchụ aja ahụ rịdata. ");
INSERT INTO ibo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mosis na Erọn bara nʼime ụlọ nzute. Mgbe ha pụtara, ha gọziri ọha mmadụ ahụ. Mgbe ahụ kwa, ebube Onyenwe anyị pụtara ìhè nye mmadụ niile nʼọgbakọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ọkụ sitekwara nʼebe Onyenwe anyị nọ daa, rechapụ aja nsure ọkụ ahụ, na abụba ahụ dị nʼebe ịchụ aja. Mgbe ndị Izrel hụrụ ya, ha tiri mkpu ọṅụ. Daa, kpuo ihu nʼala. ");
INSERT INTO ibo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ma ụmụ Erọn, Nadab na Abihu, were ọkụ tinye nʼihe ịgụ ọkụ ha, tinyekwa ụda na-esi isi nʼọkụ ahụ, si otu a chee ọkụ na-adịghị nsọ nʼihu Onyenwe anyị, nʼụzọ megidere ihe e nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Nʼihi ya, ọkụ sitere nʼihu Onyenwe anyị daa rechapụ ha, ha nwụrụ nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mgbe ahụ, Mosis gwara Erọn sị, “Nke a bụ ihe Onyenwe anyị bu nʼobi mgbe o kwuru sị, “ ‘Nʼetiti ndị niile na-abịaru m nso ka a ga-edo m nsọ ọ bụkwa nʼihu ọha mmadụ, ka a ga-asọpụrụ m.’ ” Ma Erọn gbara nkịtị. ");
INSERT INTO ibo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mgbe ahụ, Mosis kpọrọ Mishael na Elzafan, ụmụ Uziel, nwanne nna Erọn sị ha, “Bịanụ nso. Gaanụ buputa ozu ụmụnne unu site nʼihu ebe nsọ, buru ha gaa nʼazụ ebe obibi.” ");
INSERT INTO ibo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ha bịara ghanye aka nʼuwe ime ahụ ha buru ha bupụ nʼazụ ọmụma ụlọ ikwu, dịka Mosis nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mosis tụgharịrị sị Erọn na ụmụ ya, Elieza na Itama, “Unu ekwekwala ka ntutu isi unu kpasaa akpasa izipụta na unu na-eru ụjụ. Unu adọwakwala uwe unu. Nʼihi na ọ bụrụ na unu emee otu a, unu ga-anwụ. Iwe Onyenwe anyị ga-abịakwasịkwa ọgbakọ Izrel niile. Ma ndị ikwu gị, ụmụ Izrel ndị ọzọ, nwere ike ruo ụjụ nʼihi Nadab na Abihu. ");
INSERT INTO ibo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ọzọ, unu ahapụla ọnụ ụzọ ụlọ nzute, ka unu ghara ịnwụ, nʼihi na mmanụ nsọ nke Onyenwe anyị dị nʼahụ unu.” Ha mere dịka Mosis gwara ha. ");
INSERT INTO ibo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mgbe ahụ, Onyenwe anyị gwara Erọn sị, ");
INSERT INTO ibo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Gị na ụmụ gị ndị ikom agaghị aṅụ mmanya, maọbụ ihe ọṅụṅụ ọbụla na-aba nʼanya mgbe unu na-aba nʼụlọ nzute ka unu ghara ịnwụ. Agbụrụ unu niile ga-esogide iwu a ruo ọgbọ niile na-abịa. ");
INSERT INTO ibo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ọrụ unu ka ọ bụ ịkpa oke nʼetiti ihe dị nsọ na ihe na-adịghị nsọ, na nʼetiti ihe dị ọcha na ihe na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ọrụ unu bụkwa izi ụmụ Izrel ụkpụrụ niile Onyenwe anyị nyere ha site nʼaka Mosis.” ");
INSERT INTO ibo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mosis sịrị Erọn na ụmụ ya ndị ikom fọdụrụ, bụ Elieza na Itama, “Werenụ onyinye mkpụrụ ọka nke fọdụrụ site na onyinye nsure ọkụ, nke a kwadoro na-etinyeghị ihe iko achịcha ọbụla, bụ nke e nyere Onyenwe anyị. Rienụ ya nʼakụkụ ebe ịchụ aja, nʼihi na ọ bụ ihe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Rienụ ya nʼime ebe nsọ ahụ, nʼihi na ọ bụ oke ruru unu na ụmụ unu ndị ikom site nʼonyinye nsure ọkụ e nyere Onyenwe anyị; nʼihi na nke a bụ ihe e nyere m nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ma unu na ụmụ unu ndị ikom na ndị inyom ka ọ dịkwara iri obi anụ na apata ya, nke e fufere nʼihu Onyenwe anyị. Kama, ọ bụ nʼebe dị ọcha ka unu ga-anọ rie ya. Nke a bụ oke enyere unu na ụmụ unu site nʼaja udo nke ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Apata ụkwụ anụ nke aja mbuli na obi anụ ahụ nke e fufere, ka a ga-eweta ya na abụba ya nye dịka onyinye sitere nʼọkụ. A ga-efufe ha nʼihu Onyenwe anyị dịka aja mfufe. Nke a ga-abụ oke ruuru unu na ụmụ unu mgbe niile, dịka Onyenwe anyị nyere nʼiwu.” ");
INSERT INTO ibo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mgbe Mosis jụrụ ajụjụ banyere mkpi ahụ e ji chụọ aja mmehie, ọ chọpụtara na a kpọọla ya ọkụ. O wesoro Elieza na Itama ụmụ ndị ikom Erọn iwe sị ha, ");
INSERT INTO ibo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Gịnị mere unu erighị anụ ahụ e ji chụọ aja mmehie nʼakụkụ ebe nsọ ahụ? Ọ bụ nke dịkarịsịrị nsọ; e nyere unu ya maka iwepụ ọmụma ikpe dịrị ọgbakọ Izrel, na ikpuchi mmehie ha nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ebe ọ bụ na e webataghị ọbara ya nʼime Ebe Nsọ ahụ, unu gaara anọ nʼakụkụ ebe nsọ ahụ rie anụ ewu ahụ, dịka m nyere unu nʼiwu.” ");
INSERT INTO ibo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ma Erọn zara Mosis sị ya, “Lee, taa ka ha chụrụ aja mmehie na aja nsure ọkụ ha nʼihu Onyenwe anyị. Ma lee ụdị ihe dakwasịrị m. Ọ gaara atọ Onyenwe anyị ụtọ ma a sị na m riri anụ aja mmehie ndị a nʼụbọchị dị otu a?” ");
INSERT INTO ibo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mgbe Mosis nụrụ nke a, o nwere afọ ojuju nʼihi ọsịsa Erọn nyere. ");
INSERT INTO ibo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Onyenwe anyị gwara Mosis na Erọn, sị, ");
INSERT INTO ibo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Gwanụ ụmụ Izrel, sị, ‘Nʼime anụmanụ niile dị nʼụwa, ndị a bụ anụmanụ unu ga-eri. ");
INSERT INTO ibo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Unu nwere ike iri anụmanụ ọbụla ụkwụ ya wara njakpa. nke na-atagharị ọnụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Ma ọ dị ụfọdụ ndị na-atagharị nri maọbụ ndị nwere naanị ụkwụ wara njakpa, unu agaghị eri anụ ha. Ha bụ ịnyịnya kamel, ọ bụ ezie na ọ na-atagharị nri, ma ụkwụ ya awaghị njakpa. Unu agaghị eri ha nʼihi na ọ bụ anụ na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ewi: Ọ na-atagharị nri ya, ma o nweghị ụkwụ wara njakpa. Ọ bụ anụ na-adịghị ọcha nye unu. ");
INSERT INTO ibo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ewi nkume: Ọ na-atagharị nri ya, ma o nweghị ụkwụ wara njakpa. Ọ bụ anụ na-adịghị ọcha nye unu. ");
INSERT INTO ibo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ezi: Ọ bụ nʼezie na ụkwụ ya wara njakpa ma ọ dịghị atagharị nri ya. Ọ bụ anụ na-adịghị ọcha nye unu. ");
INSERT INTO ibo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Unu emetụkwala ozu ha aka maọbụ rie anụ ha, nʼihi na ha bụ ihe na-adịghị ọcha nye unu. ");
INSERT INTO ibo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Nʼime ihe niile e kere eke dị ndụ biri na mmiri, maọbụ nʼiyi nta na nʼoke osimiri, unu nwere ike iri ụdị ọbụla nwere ntu na akpịrịkpa nʼahụ ha. ");
INSERT INTO ibo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ma unu ekwesighị iri ihe ọbụla nke na-enweghị ntu maọbụ akpịrịkpa, ma ha bụ anụ na-enupụta enupụta, maọbụ na ha so nʼanụ ndị ọzọ dị ndụ bi na mmiri, unu kwesiri ịsọ ha asọ. ");
INSERT INTO ibo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ebe ha bụ ihe na-asọ oyi nye unu, unu ekwesighị iri ha, unu ga-agụkwa ozu ha ka ihe na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ihe ọbụla bi nʼime mmiri nke na-enweghị ntu na akpịrịkpa nʼahụ ha, bụ nke unu ga-asọ asọ. ");
INSERT INTO ibo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Ndị a bụ nnụnụ ndị unu ga-asọ asọ, nke unu na-ekwesighị iri nʼihi na ha bụ ihe arụ a na-asọ oyi: ugo, udele na udele ojii, ");
INSERT INTO ibo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ndagbụ na ọgankwọ dị iche iche, ");
INSERT INTO ibo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ugolọma ọbụla dị iche iche, ");
INSERT INTO ibo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","enyi nnụnụ, egbe abalị, nnụnụ oke osimiri na egbe dị iche iche, ");
INSERT INTO ibo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","okwukwu nta, komorant na okwukwu ukwu, ");
INSERT INTO ibo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","okwukwu nwere mpi, okwolo na udele, ");
INSERT INTO ibo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ụgbala, utù dị iche iche, nnụnụ ọdụ nta na ụsụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Ụmụ ahụhụ niile na-efe efe nke na-aga ije nʼụkwụ anọ bụ ihe rụrụ arụ nye unu, unu agaghị eri ya. ");
INSERT INTO ibo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ma e nwere ụfọdụ ụmụ ahụhụ na-efe efe nke na-aga ije nʼụkwụ anọ ndị unu nwere ike iri: ndị a bụ ndị nwere ogwe ụkwụ nke ha ji na-awụ awụ nʼala, ");
INSERT INTO ibo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ndị a ka unu ga-eri nʼetiti ha, igurube dị iche iche, na akpankwụ dị iche iche, na abụzụ dị iche iche, na ụkpana dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ahụhụ ndị ọzọ niile na-efe efe, ndị nwere ụkwụ anọ, bụ ihe rụrụ arụ. Unu ekwesighị iri ha. ");
INSERT INTO ibo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Iri ha ga-eme ka unu rụọ arụọ. Onye ọbụla metụrụ ozu ha aka ga-abụ onye rụrụ arụ site nʼoge o bitụrụ ha aka tutu ruo nʼabalị nke ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Onye ọbụla metụrụ otu nʼime ozu ha aka ga-asakwa uwe ya, gụọkwa onwe ya dịka onye na-adịghị ọcha ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Anụmanụ ọbụla ụkwụ ya na-awasaghị abụọ, maọbụ nke na-adịghị atagharị nri ya ugboro abụọ, rụrụ arụ. Onye ọbụla metụrụ ozu ya aka ga-abụ onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nʼime anụmanụ niile na-aga ije nʼụkwụ anọ, anụmanụ ọbụla na-aga ije nʼọbụaka ya rụrụ arụ, unu agaghị eri ya. Onye ọbụla metụrụ ozu ya aka ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Onye ọbụla ga-ebu ozu ya ga-asa uwe ya, bụrụkwa onye rụrụ arụ ruo uhuruchi, nʼihi na ọ bụ ihe rụrụ arụ nʼebe unu nọ. ");
INSERT INTO ibo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Nʼime anụmanụ niile na-enupụta enupụta nʼala, anụmanụ ndị a bụ ndị rụrụ arụ: nkapi, na oke, na agụ iyi dịka ụdị ha si dị, ");
INSERT INTO ibo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","na ọba mmiri, na ngwere aghụ, na ngwere, na ngwere uzuzu, na ogumagala. ");
INSERT INTO ibo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Nʼime ihe niile na-enupụta enupụta nʼala ndị a rụrụ arụ nʼebe unu nọ. Onye metụrụ ozu ha aka ga-abụ onye rụrụ arụ tutu ruo uhuruchi ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ihe ọbụla nke ozu ha dakwasịrị ga-abụ ihe rụrụ arụ, maọbụ osisi, maọbụ akwa, maọbụ akpụkpọ a na-akwa nʼala, maọbụ akpa, ihe ọbụla nke eji ya eme. A ga-etinye ya na mmiri, ọ ga-adịgide nʼime mmiri tutu ruo uhuruchi, mgbe ahụ ka ọ ga-adị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ọ bụrụ na otu nʼime ihe ndị a adanye nʼite aja, a ga-etiwa ite ahụ. Ihe niile dị nʼite ahụ abụrụla ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ihe oriri ọbụla nke mmiri si nʼite a metụrụ abụrụla ihe rụrụ arụ. Mmiri ọṅụṅụ ọbụla dị nʼime ite ahụ rụkwara arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ihe ọbụla ozu anụmanụ dị otu a dakwasịrị, maọbụ ite ọkụ eji eghe ihe, maọbụ ekwu a ga-etiwa ha. Nʼihi na ha bụ ihe rụrụ arụ, unu ga-agụ ha dịka ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ọ bụrụkwa na ozu anụmanụ ahụ adaba nʼisi iyi, maọbụ nʼolulu mmiri, mmiri ahụ ga-adị ọcha, kama onye ga-emetụ anụ ahụ aka ga-abụ onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ọ bụrụ na ozu anụ ahụ adakwasị mkpụrụ ubi a na-aga ịkụ nʼubi, ọ gaghị emerụ ha. ");
INSERT INTO ibo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ma ọ bụrụ na e tinyere mmiri nʼelu mkpụrụ ọghịgha ndị ahụ, ozu adakwasị nʼelu ya, ha ga-abụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Ọ bụrụ na anụmanụ unu kwesiri iri eri anwụọ, onye ahụ metụrụ ya aka ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Onye ọbụla riri ozu anụ ahụ, maọbụ bufuo ozu ya, ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Anụmanụ ọbụla na-akpụgharị nʼala bụ ihe rụrụ arụ nye unu. Unu erikwala ha. ");
INSERT INTO ibo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Unu agaghị eri anụmanụ ọbụla na-akpụgharị nʼala, ma ha na-akpụgharị nʼafọ ha, ma ha na-agagharị nʼụkwụ anọ, ma ha nwere ụkwụ dị ọtụtụ. Ha bụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Unu emerụla onwe unu site nʼiri anụmanụ ndị a na-akpụgharị nʼala. Unu abụla ndị na-emerụ onwe unu site nʼanụmanụ ndị a, maọbụ mee ka unu bụrụ ndị e merụrụ site na ha. ");
INSERT INTO ibo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Abụ m Onyenwe anyị Chineke unu. Doonụ onwe unu nsọ, nʼihi na adị m nsọ. Unu emerụla onwe unu site nʼimetụ anụmanụ ndị a na-akpụgharị nʼala aka. ");
INSERT INTO ibo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Abụ m Onyenwe anyị, onye si nʼala Ijipt kpọpụta unu, ka m bụrụ Chineke unu. Unu aghaghị ịdị nsọ, nʼihi na adị m nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Ndị a bụ usoro iwu metụtara ụmụ anụmanụ, na anụ ufe, na anụ bi na mmiri, na anụ ndị na-arịgharị arịgharị nʼala. ");
INSERT INTO ibo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ka unu si otu a kpaa oke nʼetiti ndị rụrụ arụ na ndị dị ọcha, nʼetiti ihe e kere eke dị ndụ ndị unu nwere ike iri nʼihi na ha dị ọcha, na ndị unu na-ekwesighị iri nʼihi na ha rụrụ arụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Onyenwe anyị gwara Mosis sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Nye ụmụ Izrel iwu ndị a sị ha, ‘Mgbe nwanyị tụụrụ ime mesịa mụọ nwa nwoke, ọ ga-abụ onye na-adịghị ọcha ụbọchị asaa, dịka o si adị mgbe ọ nọ nʼadịghị ọcha nke nsọ ya nʼoge a kara aka. ");
INSERT INTO ibo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Nʼụbọchị nke asatọ site nʼoge a mụrụ ya, a ga-ebi nwa nwoke ahụ ugwu. ");
INSERT INTO ibo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Nʼime iri abalị atọ na atọ site nʼụbọchị nwanyị ahụ mụsịrị nwa ahụ, ọ ga-anọkwa na-adịghị ọcha nke ọbara gbara ya. Ọ gaghị emetụ ihe dị nsọ aka, maọbụ banye nʼime ebe nsọ, ruo mgbe ụbọchị ime ya ka ọ dị ọcha gasịrị. ");
INSERT INTO ibo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mgbe nwanyị dị ime mụrụ nwa nwanyị, ọ ga-abụ onye nʼadịghị ọcha iri ụbọchị na anọ, dịka o si adị mgbe ọ nọ na nsọ ya. Ọ ga-echere tutu iri ụbọchị isii agwụsịa, ime ya ka ọ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Mgbe ụbọchị ịdị ọcha ya zuru, ma ọ mụrụ nwa nwoke maọbụ nwa nwanyị, ọ ga-ewetara onye nchụaja nʼọnụ ụzọ ụlọ nzute otu nwa atụrụ gbara otu afọ maka onyinye aja nsure ọkụ, na otu nwa kpalakwukwu maọbụ otu nduru maka onyinye aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Onye nchụaja ga-anarakwa ha chee ha nʼihu Onyenwe anyị, chụọrọ ya aja ikpuchi mmehie. Mgbe ahụ ka ọ ga-adị ọcha site nʼịsọ ọbara ya. “ ‘Nke a bụ usoro iwu dịịrị nwanyị ọbụla mụrụ nwa nwoke, maọbụ nwa nwanyị. ");
INSERT INTO ibo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ọ bụrụ na aka erughị ya iweta nwa atụrụ, ọ ga-eweta ụmụ kpalakwukwu abụọ, maọbụ ụmụ nduru abụọ. Otu ga-abụ maka aja nsure ọkụ, nke ọzọ ga-abụ maka aja mmehie. Onye nchụaja ga-ewere ha chụọrọ ya aja ikpuchi mmehie, ka ọ dịkwa ọcha ọzọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Onyenwe anyị gwara Mosis na Erọn okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Mgbe mmadụ hụrụ etuto, maọbụ ọnya, maọbụ ntụpọ na-eko eko nʼakpụkpọ anụ ahụ ya nke dị ka ihe ọrịa ekpenta na-eweta, a ga-eduru onye ahụ bịa nʼihu Erọn onye nchụaja maọbụ ụmụ ya ndị ikom, bụ ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Onye nchụaja ga-eleru ọrịa ahụ dị ya nʼahụ anya. Ọ bụrụ na ajị dị gburugburu ebe ahụ ebidola ịcha ọcha, ọ bụrụkwa na ebe ahụ mibara ime, ọ bụ ọrịa ekpenta. Mgbe onye nchụaja leruchara ya anya, ọ ga-ekwupụta na onye ahụ bụ onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ọ bụrụkwanụ na ajị dị gburugburu ebe ahụ dị ọcha, ma na ebe ahụ emighị emi karịa akụkụ ahụ ya ndị ọzọ, onye nchụaja ga-edebe onye ahụ ebe ọ ga-anọ naanị ya abalị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mgbe ụbọchị asaa gasịrị, onye nchụaja ga-ele ya ahụ ọzọ. Ọ bụrụ na ọnya ahụ alabeghị, na ọ nwekwaghị mgbanwe ọbụla, a ga-edebekwa ya abalị asaa ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mgbe abalị asaa nke a gafekwara, onye nchụaja ga-elekwa ya ahụ ọzọ. Ọ bụrụ na ọ dịtụla ya mma, na ọnya ahụ agbasaghị nʼanụ ahụ ya, onye nchụaja ga-asị na ọ dị ọcha, nʼihi na ọ bụ naanị ọnya efu. Onye ahụ ga-asakwa uwe ya mmiri, mgbe ahụ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ma ọ bụrụ na ọnya ahụ agbasaa nʼahụ ya mgbe o gosicharala onye nchụaja onwe ya maka nsacha ịdị ọcha, ọ ga-alaghachikwa azụ ga hụ onye nchụaja ahụ ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Onye nchụaja ga-eleru ya anya, ọ bụrụ na onye nchụaja achọpụta na ọnya ahụ na-agbasa, ọ ga-agụ onye ahụ dịka onye rụrụ arụ, ọ bụ ọrịa na-efe efe. ");
INSERT INTO ibo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Mgbe ọbụla mmadụ nwere ihe dị ka ọrịa na-efe efe nʼahụ ya, a ghaghị ịkpọtara ya onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Onye nchụaja ga-ele anya nʼakụkụ anụ ahụ ya zara aza ịchọpụta ma ọ dị ọcha, ma ajị dị gburugburu ebe ahụ ọ na-acha ọcha, na ịhụkwa ma ọ nwere ọnya dị gburugburu ebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Ọ bụrụ na onye nchụaja ahụ ihe ndị a, ọ bụ ọrịa ekpenta nʼezie. Ọ ga-agụkwa onye ahụ dịka onye rụrụ arụ. A gaghị edebekwa ya ile ya ahụ, nʼihi na ọ bụrụlarị onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Ọ bụrụ na onye nchụaja elee onye ahụ anya hụ na ọrịa ọcha ahụ enupụtala nʼakụkụ ahụ ya niile, site nʼụkwụ ya ruo nʼisi ya, ");
INSERT INTO ibo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","onye nchụaja a ga-eleru ya anya, ọ bụrụ na ọrịa ahụ enupụtala nʼahụ ya niile, ọ ga-ekwupụta na onye ahụ dị ọcha, ebe ọ bụ na ọrịa ahụ enupụtala mee ka anụ ahụ ya chawa ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ma ọ bụrụ na e nwere akụkụ ahụ ya ọnya ọ hụrụ pụtara, ọ ga-agụ ya dịka onye na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Onye nchụaja ga-enyocha ọnya ahụ. Kwupụta na onye ahụ rụrụ arụ. Ọnya ahụ rụrụ arụ nʼihi na ọrịa ekpenta ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ọ bụrụ nʼọnya ahụ agbanwe na-acha ọcha, ha ga-agakwuru onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Onye nchụaja ga-ele ya ahụ. Ọ bụrụ na ọnya niile ahụ na-acha ezi ọcha, onye nchụaja ga-agụ ya dịka onye na-enweghị ntụpọ. Ndị dị ọcha ka ha ga-abụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Ọ bụrụ na etuto toro mmadụ nʼahụ alaa, ");
INSERT INTO ibo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ma akpụkpọ anụ ahụ ya anọgide na-acha ọcha, maọbụ na-acha ọbara ọbara, a ga-ejekwuru onye nchụaja ka o lee ya anya nʼahụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ọ bụrụ na onye nchụaja achọpụta na e nwere ọrịa dị nʼokpuru akpụkpọ ahụ ya, chọpụtakwa na ajị ya na-acha ọcha, onye nchụaja ga-agụ mmadụ ahụ dịka onye rụrụ arụ, nʼihi na ekpenta esitela nʼetuto ahụ pụta. ");
INSERT INTO ibo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ọ bụrụ na onye nchụaja achọpụta na ajị ọcha adịghị nʼakpụkpọ ahụ ya, chọpụtakwa na ọnya ahụ abanyeghị nʼime, onye nchụaja ga-edebe onye ahụ ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Nʼime ụbọchị asaa ahụ, ọ bụrụ na ọnya ahụ abaa ụba karịa ka ọ dị na mbụ, onye nchụaja ga-agụ mmadụ ahụ dịka onye na-adịghị ọcha. Ọ bụ ọrịa na-emerụ emerụ ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ma ọ bụrụ na ọ baghị ụba karịa, onye nchụaja ga-agụ mmadụ ahụ dịka onye dị ọcha, nʼihi na ihe a bụ etuto lara ala. ");
INSERT INTO ibo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ọ bụrụ na ọkụ agbaa mmadụ, mee ka ọnya pụta ya nʼahụ: ọ bụrụ na ọnya ahụ ebido na-acha ọbara ọbara, maọbụ na-acha ezigbo ọcha, ");
INSERT INTO ibo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","onye nchụaja ga-elezi onye dị otu a anya. Ọ bụrụ na ajị dị gburugburu ebe ọnya ahụ dị na-acha ọcha, maọbụ na ọnya ahụ mibara ime karịa, ọ ghọọla ekpenta nke si nʼọnya ahụ nupụta. Onye nchụaja ga-agụ mmadụ ahụ dịka onye na-adịghị ọcha. Ọ bụ ọrịa ekpenta. ");
INSERT INTO ibo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ma ọ bụrụ na onye nchụaja elee ya hụ na ajị dị gburugburu ebe ahụ adịghị ọcha, ọ bụrụkwa na ọ dịghị ala karịa akpụkpọ ahụ, na ọ na-aṅacha, mgbe ahụ onye nchụaja ga-edebe onye ahụ iche ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Nʼụbọchị nke asaa, onye nchụaja ga-elezi onye ahụ anya nke ọma. Ọ bụrụ na ọ chọpụtara na ọnya ahụ na-abasaa nʼakpụkpọ ahụ ya, onye nchụaja ga-agụ onye ahụ dịka onye na-adịghị ọcha. Ọrịa na-emerụ emerụ ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ma ọ bụrụ na ọ gbanweghị, bụrụkwa na ọ basaghị nʼakpụkpọ ahụ ma ọ na-aṅacha, ọ bụ ihe ọzịza sitere nʼọkụ rere onye ahụ, onye nchụaja ga-agụ ya dịka onye dị ọcha, nʼihi na ọ bụ apa ọnya lara ala. ");
INSERT INTO ibo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ọ bụrụ na nwoke maọbụ nwanyị ọbụla enwee ọnya nʼisi, maọbụ na nti ya, ");
INSERT INTO ibo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","onye nchụaja ga-elezi ọnya ahụ anya. Ọ bụrụ na ọ dị ala karịa akpụkpọ ahụ ya, ọ bụrụkwa na ajị dị na ya na-acha odo odo dị irighiri, onye nchụaja ga-agụ ha dịka ndị na-adịghị ọcha. Ọ bụ ọrịa na-emerụ emerụ nke dị nʼisi maọbụ nʼagba. ");
INSERT INTO ibo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ma ọ bụrụ na onye nchụaja achọpụta na ọnya ahụ adịghị abasa abasa, maọbụ na ajị dị nʼebe ahụ adịghị eji ojii, onye nchụaja ga-edebe onye ahụ ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Nʼụbọchị nke asaa onye nchụaja ga-elezi ọnya ahụ anya. Ọ bụrụ na ọnya ahụ abasaghị karịa, ọ bụrụ na o nweghị ajị na-acha edo edo, ọ bụrụkwa na o mibaghị emiba, ");
INSERT INTO ibo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ọ ga-akpụchapụ ajị niile dị nʼakụkụ ebe ahụ ọnya mere ya, ma ọ gaghị akpụchapụ ajị dị nʼọnya ahụ nʼonwe ya. Onye nchụaja ga-edebe onye ahụ ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Nʼụbọchị nke asaa, onye nchụaja ga-elezi ọnya ahụ anya. Ọ bụrụ na ọ basaghị karịa, maọbụ mibanye nʼime karịa anụ ahụ, a ga-agụ mmadụ ahụ dịka onye dị ọcha. Ọ ga-apụ sachaa uwe ya, bụrụ onye dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ma ọ bụrụ na mgbe a gụchara ya nʼonye dị ọcha ọnya ahụ emesịa basaa nʼahụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Onye nchụaja ga-ele ya anya. Ọ bụrụ na ọnya ahụ agbasaala nʼakpụkpọ ahụ ya, onye nchụaja a gaghị achọwa ajị na-acha edo edo. Onye ahụ rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ma ọ bụrụ nʼuche onye nchụaja na ọnya ahụ adịghị abasa abasa, ọ bụrụkwa na ajị ojii epupụtala nʼebe ahụ, ọnya ahụ alaala. Onye dị ọcha ka mmadụ ahụ bụ. Onye nchụaja ga-ekwupụta na ọ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Mgbe nwoke maọbụ nwanyị ọbụla nwere ntụpọ ọcha nʼanụ ahụ ya, ");
INSERT INTO ibo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","onye nchụaja ga-ele ya ahụ. Ọ bụrụ na ntụpọ ahụ adịghị achazi ezi ọcha, ọ bụ ọkọ nupụtara onye ahụ nʼahụ. Onye ahụ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Mgbe ajị na-adịghịkwa nwoke nʼisi, ọ bụ isi nkwọcha, onye ahụ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Otu aka ahụ, ọ bụrụ na isi ya esite nʼegedege ihu ya kwọchasịa, ọ bụghị ekpenta, onye dị ọcha ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kama ọ bụrụ na onye ahụ enwee etuto nʼisi ya maọbụ nʼegedege ihu ya nke na-acha ọbara ọbara, na ọcha ọcha, o nwere ike bụrụ ọrịa ekpenta na-enupụta ya nʼisi maọbụ nʼegedege ihu. ");
INSERT INTO ibo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Nʼihi ya, onye nchụaja ga-elezi ya anya. Ọ bụrụ na etuto ahụ toro ya nʼisi maọbụ nʼegedege ihu na-acha ọbara ọbara, na ọcha ọcha, ọ ga-abụ na ọ ghọọla ọrịa ekpenta. ");
INSERT INTO ibo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Onye nchụaja ga-agụ ya dịka onye ekpenta. Ọ bụkwa onye rụrụ arụ, nʼihi ọnya ahụ dị ya nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Onye ọbụla a chọpụtara na ọ bụ onye ekpenta ga-eyi uwe dọkara adọka, hapụ agịrị isi ya ka ọ dịka nke onye ara. Ọ ga-ekpuchi elu egbugbere ọnụ ya, na-eti mkpu na-asị, ‘Onye rụrụ arụ ka m bụ. Onye rụrụ arụ ka m bụ!’ ");
INSERT INTO ibo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ụbọchị niile nke ọ nọ nʼọrịa ahụ, ọ gaghị ebi nʼime obodo nʼetiti ụmụ mmadụ nʼihi na onye rụrụ arụ ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ọ bụrụ na a hụrụ ntụpọ yiri ntụpọ ọrịa na-efe efe nʼuwe ajị anụ maọbụ nʼuwe ogho ọcha, ");
INSERT INTO ibo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","maọbụ nʼakpụkpọ anụ ọbụla, maọbụ nʼihe ọbụla e ji akpụkpọ ajị anụ maọbụ uwe ogho ọcha, uwe a kpara akpa, maọbụ nke a tụrụ atụ mee. ");
INSERT INTO ibo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Ọ bụrụkwa na ntụpọ dị nʼuwe ahụ, maọbụ nʼakpụkpọ anụ ahụ, maọbụ nke a kpara akpa, maọbụ nke atụrụ atụ, maọbụ nʼihe akpụkpọ anụ ọbụla na-acha ahịhịa ndụ maọbụ uhie uhie, o nwere ike ịbụ ọrịa na-efe efe. A ga-ewegara onye nchụaja uwe ahụ ka o lezie ya anya. ");
INSERT INTO ibo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Onye nchụaja ga-ele ya anya, were ya debe ya iche ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Nʼụbọchị nke asaa, onye nchụaja ga-ele ya anya ọzọ. Ọ bụrụ na ntụpọ ahụ agbasaa nʼuwe ahụ maọbụ nʼihe ahụ a kpara akpa, maọbụ nʼihe ahụ a tụrụ atụ, maọbụ nʼihe akpụkpọ anụ ahụ, nʼime ụbọchị asaa ndị a, nʼagbanyeghị ihe e ji ha eme, ọ bụ ọrịa ọjọọ na-efe efe. Ihe ahụ bụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","A ga-akpọ uwe ahụ, maọbụ akwa ajị anụ ahụ, maọbụ akwa ajị anụ a kpara akpa, maọbụ akwa ogho ọcha ahụ, maọbụ ihe akpụkpọ anụ ọbụla ọkụ, nʼihi na ọrịa na-efe efe dị nʼime ya, nʼihi na ọrịa na-eweta mbibi ka ọ bụ. A ghakwaghị iji ọkụ rechapụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ma ọ bụrụ na onye nchụaja ahụ ele hụ na ntụpọ ahụ agbasaghị nʼuwe ahụ, maọbụ nʼakwa ahụ a kpara akpa, maọbụ akwa a tụrụ atụ, maọbụ nʼihe akpụkpọ anụ ahụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Ọ ga-enye iwu ka a saa ihe ndị ahụ niile mmiri, wezugakwa ya iche ruo ụbọchị asaa ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mgbe a sachara ihe ahụ mmiri, onye nchụaja ga-ele ya anya ọzọ. Ọ bụrụ na ntụpọ ahụ agbanwebeghị, ọ bụrụ na ọ na-achakwa dịka o si acha na mbụ, mgbe ụbọchị ndị a gasịrị, ọ bụ ezie na ọ gbasaghị, ọ bụ ihe rụrụ arụ. A ga-akpọ ya ọkụ, ma ntụpọ ahụ ọ dị nʼihu uwe ahụ maọbụ nʼazụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ma ọ bụrụ na onye nchụaja elee ya anya hụ na ụcha ntụpọ dị nʼihe ahụ adịghị ukwuu nʼihi nsacha a sachara ya na mmiri, ọ ga-achakapụ akụkụ uwe ahụ, maọbụ akwa ahụ a kpara akpa maọbụ nke a tụrụ atụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ọ bụrụ na ntụpọ ahụ emesịa pụta ọzọ nʼuwe ahụ, maọbụ nʼakwa ahụ a kpara akpa, maọbụ nke a tụrụ atụ, maọbụ nʼakpụkpọ anụ ahụ, o gosiri na ọ na-agbasa agbasa. Ihe ọbụla nwere ntụpọ ahụ ka a ga-akpọ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Uwe maọbụ ihe a kpara akpa, maọbụ ihe a tụrụ atụ, maọbụ ihe akpụkpọ anụ ọbụla a sara mmiri nke ntụpọ dị na ya pụrụ, a ga-asa ya mmiri ọzọ. Ọ ga-abụkwa ihe dị ọcha.” ");
INSERT INTO ibo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ndị a bụ usoro iwu metụtara ntụpọ dịka ntụpọ ọrịa na-efe efe nke dị nʼuwe ajị anụ maọbụ uwe ogho ọcha, maọbụ nʼihe a kpara akpa maọbụ nʼihe a tụrụ atụ, maọbụ nʼihe akpụkpọ anụ. Iwu ndị a ga-enye aka ịchọpụta ma ha rụrụ arụ, maọbụ na ha dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Onyenwe anyị gwara Mosis, sị, ");
INSERT INTO ibo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ndị a bụ usoro iwu gbasara onye ọrịa ekpenta nʼoge a na-eme mmemme ịdị ọcha ya, mgbe e dutere ya bịakwute onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Onye nchụaja ga-apụ gaa nʼazụ ebe obibi nọdụ nʼebe ahụ lee ya ahụ, ịchọpụta ma ọrịa ekpenta ya ọ laala nʼezie. Ọ bụrụ na ọrịa ya alaala, ");
INSERT INTO ibo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","onye nchụaja ga-enye iwu ka e weta nnụnụ abụọ dị ndụ, na ụfọdụ osisi sida, na eriri ogho uhie, na hisọp, maka onye ahụ a ga-emere mmemme ịdị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Onye nchụaja ga-enye iwu ka e gbuo otu nʼime nnụnụ abụọ ahụ nʼelu mmiri e si nʼọdọ mmiri na-asọ asọ kute nke dị nʼime ite aja. ");
INSERT INTO ibo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ọ ga-ewere nnụnụ nke ọzọ dị ndụ, ya na osisi sida ahụ, na ogho uhie ahụ, na hisọp ahụ, denye ha nʼime ọbara nnụnụ ahụ e gburu nʼelu mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mgbe ahụ, onye nchụaja ga-efe ọbara ahụ ugboro asaa nʼahụ onye ahụ a na-eme ka ọ dị ọcha site nʼọrịa ekpenta. Ọ ga-ekwupụtakwa na a gwọọla onye ahụ. Emesịa, ọ ga-ahapụ nnụnụ ahụ ka o felaa nʼọhịa. ");
INSERT INTO ibo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Onye ahụ e mere ka ọ dị ọcha ga-asacha uwe ya, kpụchaa ntutu isi ya, saakwa ahụ ya. Mgbe ahụ, ọ ga-adị ọcha. Emesịa, ọ ga-esoro ndị mmadụ biri nʼobodo. Ma ọ gaghị abanye nʼụlọ nke aka ya tutu ụbọchị asaa agafee. ");
INSERT INTO ibo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Nʼụbọchị nke asaa, ọ ga-akpụchapụ ntutu isi ya, na afụọnụ ya, na ikuanya ya, na ajị ndị ọzọ dị ya nʼahụ. Ọ ga-asa uwe ya na ahụ ya niile. Mgbe ahụ, a ga-agụ ya nʼonye dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Nʼụbọchị nke asatọ, ọ ga-ewere ebule abụọ na-enweghị ntụpọ, na otu nne atụrụ nke na-enweghị ntụpọ gbara otu afọ, ya na iri iko ọka a kwọrọ nke ọma a gwakọtara mmanụ oliv maka aja mkpụrụ ọka, na otu iko mmanụ. ");
INSERT INTO ibo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Onye nchụaja ahụ lere ya ahụ sị na ha dị ọcha, ga-ewere aja ndị a, ha na onye ahụ a na-aga ime ka ọ dị ọcha chee nʼihu Onyenwe anyị nʼọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Mgbe ahụ, onye nchụaja ahụ ga-ewere otu nʼime ụmụ ebule ahụ, na otu iko mmanụ chụọ ya dịka onyinye aja ikpe ọmụma. Ọ ga-efufe ha nʼihu Onyenwe anyị dịka aja mfufe. ");
INSERT INTO ibo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ọ ga-egbu nwa ebule ahụ nʼakụkụ ebe nsọ ahụ, nʼebe a na-anọ egbu anụ aja mmehie na aja nsure ọkụ. Ọ bụ onye nchụaja ga-ewere anụ aja ikpe ọmụma a, dịka o were nke aja mmehie. Ọ bụ ihe dịkarịsịrị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Onye nchụaja ahụ ga-ewere ụfọdụ nʼime ọbara aja ikpe ọmụma ahụ, tee nʼọnụ ntị aka nri nke onye ahụ a na-eme ka ọ dị ọcha. Ọ ga-etekwa ya nʼisi mkpụrụ aka nke aka nri ya, na nʼelu isi mkpụrụ ụkwụ nke ụkwụ aka nri ya. ");
INSERT INTO ibo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Emesịa onye nchụaja ga-awụnyetụ mmanụ oliv ahụ nʼọbụaka nke aka ekpe ya, ");
INSERT INTO ibo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ọ ga-arụnye otu mkpịsịaka nri ya nʼime mmanụ dị nʼọbụaka ya, ọ ga-ewere mkpịsịaka ya fesa ụfọdụ nʼime ya ugboro asaa nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Onye nchụaja ga-ewere mmanụ ahụ fọdụrụ nʼọbụaka ya tee ya onye ahụ nʼọnụ ntị aka nri nke onye ahụ a na-aga ime ka ọ dị ọcha, na nʼisi mkpụrụ aka nke aka nri ya, na nʼisi mkpụrụ ụkwụ nke aka nri ya, nʼelu ọbara aja ikpe ọmụma ahụ mee. ");
INSERT INTO ibo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ọ ga-ete mmanụ ahụ fọdụrụ nʼaka ya, nʼisi onye ahụ a na-eme ka ọ dị ọcha. Onye nchụaja ga-ekpuchikwara ha mmehie ya nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Mgbe ahụ, onye nchụaja ga-achụ aja mmehie, kpuchiere onye ahụ a ga-eme ka ọ dị ọcha site na-adịghị ọcha ha mmehie ya. Emesịa, onye nchụaja ga-egbu aja nsure ọkụ ahụ, ");
INSERT INTO ibo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","were ya na onyinye mkpụrụ ọka chụọrọ onye ahụ aja, maka ikpuchiri ya mmehie ya. Mgbe ahụ, a ga-agụ onye ahụ nʼonye dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ọ bụrụ na ọ bụ ogbenye onye na-enweghị ike iweta ihe ndị a, ha aghaghị iwere otu nwa ebule dịka aja ikpe ọmụma nke a ga-efufe nʼihi aja ikpuchi mmehie ha, Ọ ga-ewetakwa iko ọka a kwọrọ nke ọma asaa maọbụ ihe ọtụtụ efaa a gwara mmanụ oliv dịka aja mkpụrụ ọka, ya na otu iko mmanụ. ");
INSERT INTO ibo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ọ ga-ewetakwa nduru abụọ maọbụ kpalakwukwu abụọ, nke ọbụla o nwere ike iweta. Otu ga-abụ maka aja mmehie, nke ọzọ ga-abụ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Ọ ga-ewere ha nye onye nchụaja nʼọnụ ụzọ ụlọ nzute nʼihu Onyenwe anyị, nʼụbọchị nke asatọ ya, maka ime ka ha dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Onye nchụaja ga-ewerekwa nwa atụrụ aja ikpe ọmụma ahụ, ya na otu iko mmanụ oliv ahụ, fufee ha nʼihu ebe ịchụ aja nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ọ ga-egbu nwa atụrụ aja ikpe ọmụma ahụ, were ụfọdụ ọbara ya tee nʼọnụ ntị aka nri onye ahụ a na-aga ime ka ọ dị ọcha, na nʼisi mkpụrụ aka nke aka nri ya, na nʼisi mkpụrụ ụkwụ nke aka nri ya. ");
INSERT INTO ibo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Onye nchụaja ahụ ga-awụnye ụfọdụ mmanụ oliv ahụ nʼọbụaka nke aka ekpe ya, ");
INSERT INTO ibo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ọ ga-ewere mkpịsịaka nri ya fesa ụfọdụ mmanụ ahụ nke dị nʼọbụaka ya ugboro asaa nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ọ ga-etekwa ụfọdụ mmanụ ahụ dị nʼaka ya nʼebe ndị ahụ o tere ọbara ikpe ọmụma ahụ, nke bụ nʼọnụ ntị onye ahụ nke a na-eme ka ọ dị ọcha, na nʼisi mkpụrụ aka nke aka nri ya, na nʼisi mkpụrụ ụkwụ nke aka nri ya. ");
INSERT INTO ibo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mmanụ nke fọdụrụ nʼaka ya ka onye nchụaja ga-ete nʼisi onye ahụ a na-eme ka ọ dị ọcha, ikpuchi mmehie ha nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Emesịa, ọ ga-eji nduru abụọ ahụ maọbụ kpalakwukwu abụọ ahụ, nke ọbụla o nwere ike iweta, chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Otu ga-abụ maka aja mmehie, nke ọzọ ga-abụ maka aja nsure ọkụ, ha na aja mkpụrụ ọka. Nʼụzọ dị otu a, onye nchụaja ga-ekpuchiri ya mmehie ya nʼihu Onyenwe anyị, bụ onye ahụ a na-eme ka ọ dị ọcha.” ");
INSERT INTO ibo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ndị a bụ usoro iwu dịrị onye ọbụla e sitere nʼọrịa ekpenta mee ka ọ dị ọcha, onye aka ya na-erughị iweta ihe o kwesiri iweta, bụ nke e ji eme ka ọ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Onyenwe anyị gwara Mosis na Erọn okwu sị, ");
INSERT INTO ibo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Mgbe unu banyere ala Kenan, bụ ala ahụ m na-enye unu, ọ bụrụ na o nwee ụlọ ọbụla m webatara ọrịa na-efe efe, ");
INSERT INTO ibo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","onyenwe ụlọ ahụ ga-ejekwuru onye nchụaja sị ya, ‘Ahụla m ihe yiri ọrịa na-efe efe nʼụlọ m.’ ");
INSERT INTO ibo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Onye nchụaja ahụ ga-enye iwu ka a kwapụsịa ihe niile dị nʼụlọ ahụ tupu ọ gaa lezie ụlọ ahụ anya, ka ihe niile dị nʼụlọ ahụ ghara ịbụ ihe rụrụ arụ, ma ọ bụrụ na achọpụta ọrịa na-efe efe nʼụlọ ahụ. Mgbe a kwapụtasịrị ihe dị nʼụlọ ahụ, onye nchụaja ga-aga lee ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ọ ga-ele ntụpọ dị nʼahụ ụlọ ahụ. Ọ bụrụ na ntụpọ ahụ na-acha ahịhịa ndụ ahịhịa ndụ, maọbụ ọbara ọbara, ọ bụrụkwa na ha miri emi karịa aja ụlọ ahụ nʼile anya, ");
INSERT INTO ibo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","onye nchụaja ga-esi nʼọnụ ụzọ ụlọ ahụ pụọ, kpọchie ụlọ ahụ ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Nʼụbọchị nke asaa, onye nchụaja ga-alọghachi bịa lee ụlọ ahụ ọzọ. Ọ bụrụ na ntụpọ ahụ agbasaala nʼaja ụlọ ahụ, ");
INSERT INTO ibo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","onye nchụaja ga-enye iwu ka e tida akụkụ aja ụlọ ahụ bufuo ya nʼebe a na-ekpofu ihe rụrụ arụ nʼazụ obodo. ");
INSERT INTO ibo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ọ ga-enyekwa iwu ka a kpụchaa aja ụlọ niile dị nʼime ụlọ ahụ, bufukwaa aja niile a kpụchapụtara nʼebe a na-ekpofu ihe rụrụ arụ nʼazụ obodo. ");
INSERT INTO ibo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","A ga-ebute nkume ọzọ jiri ha dochie ndị ahụ e bupụsịrị. A ga-ejikwa ụrọ ọhụrụ tee ụlọ ahụ ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ma ọ bụrụ na ntụpọ ahụ apụta ọzọ, mgbe e bupụsịrị nkume ndị ahụ, ma mgbe a kpuchasịrị aja ụlọ ma techikwaa ya, ");
INSERT INTO ibo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","onye nchụaja ga-abịa lee ya. Ọ bụrụ na ọ hụ na ntụpọ ahụ agbasaala ọzọ, ọ ga-agụ ụlọ ahụ dịka ihe rụrụ arụ, nʼihi na ntụpọ ahụ bụ ọrịa na-efe efe. ");
INSERT INTO ibo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ọ ga-enye iwu ka a kwatuo ụlọ ahụ bufukwaa ihe niile e jiri rụọ ya, nkume niile, osisi niile na ụrọ niile, nʼebe a na-ekpofu ihe rụrụ arụ nʼazụ obodo. ");
INSERT INTO ibo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Onye ọbụla banyere nʼụlọ ahụ nʼoge e mechiri ya, ga-abụ onye rụrụ arụ ruo nʼoge uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Onye ọbụla dinara ala maọbụ rie nri nʼime ya, ga-asacha uwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ma ọ bụrụ na onye nchụaja abịa hụ na ntụpọ ahụ apụtaghị ọzọ, mgbe e techara ụlọ ahụ ụrọ nke ugboro abụọ, ọ ga-agụ ya nʼụlọ dị ọcha, nʼihi na ọrịa ahụ na-efe efe alaala. ");
INSERT INTO ibo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ọ ga-ejikwa nnụnụ abụọ, na osisi sida, na ogho uhie, na osisi hisọp mee mmemme ido ihe ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ọ ga-egbu otu nʼime nnụnụ ndị ahụ nʼelu mmiri e si nʼiyi na-asọ asọ kute, nke dị nʼime ite aja. ");
INSERT INTO ibo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ọ ga-edenye osisi sida ahụ, na ogho uhie ahụ, na osisi hisọp ahụ, nʼime ọbara nnụnụ ahụ na mmiri ahụ. Ọ ga-efesa ọbara ahụ nʼụlọ ahụ ugboro asaa. ");
INSERT INTO ibo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ọ bụ ọbara nnụnụ ahụ, na mmiri ahụ, na nnụnụ nke ọzọ ahụ dị ndụ, na osisi sida ahụ na hisọp ahụ, na ogho uhie ahụ ka ọ ga-eji mee ka ụlọ ahụ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ọ ga-ahapụ nnụnụ ahụ dị ndụ ka o fepụ felaa nʼọhịa dị nʼazụ obodo. Nke a ga-abụ otu e si kpuchiere ụlọ ahụ mmehie ya. Ọ ga-adịkwa ọcha.” ");
INSERT INTO ibo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ndị a bụ usoro iwu metụtara ọrịa ekpenta, na ọkọ, ");
INSERT INTO ibo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na ọrịa na-efe efe dị nʼuwe maọbụ nʼụlọ, ");
INSERT INTO ibo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","maọbụ etuto, maọbụ ntụpọ, maọbụ ọnya. ");
INSERT INTO ibo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Iwu ndị a ga-enye aka ịmata ihe rụrụ arụ maọbụ ihe na-adịghị ọcha. Ndị a bụ usoro iwu metụtara ọrịa ekpenta na ọrịa na-efe efe. ");
INSERT INTO ibo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Onyenwe anyị gwara Mosis na Erọn okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Gwa ụmụ Izrel okwu sị ha, ‘Nwoke ọbụla ihe nsọpụta si nʼahụ ya na-asọpụta, bụ onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Onye ahụ rụrụ arụ mgbe ihe ahụ si ya nʼahụ na-asọpụta, rụọkwa arụ mgbe ihe ahụ kwụsịrị ịsọ. Otu a ka ihe ọsụsọ ahụ si eme ka onye ahụ rụọ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Ihe ọbụla onye ahụ ji anọdụ ala, maọbụ nke o ji dinaa bụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Onye ọbụla metụrụ ihe ndina ya aka ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya, na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Onye ọbụla nọdụrụ ala nʼihe onye ahụ nọdụrụ ala nʼoge ahụ ọ bụ onye rụrụ arụ, ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya, na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Onye ọbụla metụrụ nwoke ahụ ihe si nʼahụ ya na-asọpụta aka ga-asa uwe ya na ahụ ya mmiri, bụrụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Onye ọbụla dị ọcha nke onye ahụ bụsara ọnụ mmiri ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Ihe ọbụla onye ahụ ji anọkwasị nʼelu anụmanụ ọ na-agba ga-abụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Onye ọbụla ga-eburu, maọbụ metụ ihe ọbụla o ji nọdụ ala aka ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Ọ bụrụ na nwoke ahụ rụrụ arụ ebughị ụzọ saa aka ya tupu o metụ mmadụ aka, onye ahụ o metụrụ aka ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ ga-asa uwe ya na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘A ga-etiwa ite aja ọbụla onye ahụ metụrụ aka, jiri mmiri ṅachaa ihe osisi ọbụla o metụrụ aka. ");
INSERT INTO ibo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Mgbe e mere ka onye ahụ bụrụ onye dị ọcha site nʼihe nsọpụta a, ọ ga-anọ ụbọchị asaa maka ịdị ọcha ya. Ọ ga-asa uwe ya na ahụ ya nʼime mmiri na-asọ asọ tupu ọ bụrụ onye dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Nʼụbọchị nke asatọ, ọ ga-ewere nduru abụọ maọbụ ụmụ kpalakwukwu abụọ bịa nʼihu Onyenwe anyị nʼọnụ ụzọ ụlọ nzute, were ha nye onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Onye nchụaja ga-eji ha chụọrọ ya aja nʼebe ahụ. Otu nʼime nnụnụ abụọ ahụ ga-abụ maka aja mmehie, nke ọzọ maka aja nsure ọkụ. Nʼụzọ dị otu a, ọ ga-ekpuchiri nwoke ahụ mmehie ya nʼihu Onyenwe anyị nʼihi ihe ọsụsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Nwoke ọbụla mkpụrụ nwa ya si ya nʼamụ pụọ, ga-asa ahụ ya nke ọma, bụrụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","A ga-asacha ihe ọbụla mkpụrụ nwa ahụ metụrụ, maọbụ akwa maọbụ akpụkpọ anụ. Ha ga-abụ ihe rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mgbe nwoke na nwanyị dinakọrọ, ma nwoke ahụ anyụpụta mkpụrụ nwa, ha abụọ ga-asa ahụ ha nke ọma, bụrụ ndị rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Mgbe ọbara si nwanyị nʼahụ pụọ dịka o kwesiri nʼoge a kara aka nʼọnwa ọbụla, nwanyị ahụ ga-abụ onye rụrụ arụ ụbọchị asaa. Onye ọbụla metụrụ ya aka nʼoge a ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Ihe ọbụla o dinara nʼelu ya nʼoge a, maọbụ ihe ọ nọkwasịrị nʼelu ya ga-arụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Onye ọbụla metụrụ ihe ndina ya aka, ga-asa uwe ya na ahụ ya. Ọ ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Onye metụrụ ihe o ji nọdụ ala aka ga-asa uwe ya na ahụ ya. Ọ ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ọ bụrụkwa na ọ bụ ihe ndina ya, maọbụ ihe ọzọ nke o ji nọdụ ala, onye ọbụla metụrụ ya aka ga-abụ onye rụrụ arụ ruo uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Nwoke dinakwuru nwanyị ọbara si nʼahụ ya na-apụta, ọ bụrụ na ọbara ahụ emetụ ya, ọ ga-abụ onye rụrụ arụ abalị asaa. Ihe ndina ọbụla o dinara nʼelu ya ga-abụ ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Ọ bụrụ na ọbara si nwanyị nʼahụ na-apụta agafee oge o kwesiri ịkwụsị maọbụ na ọ pụtara nʼoge ọ na-ekwesighị ịpụta, nwanyị ahụ ga-anọgide bụrụ onye rụrụ arụ ogologo ụbọchị ndị ahụ niile ọbara ahụ si ya nʼahụ na-apụta. ");
INSERT INTO ibo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ihe ọbụla o dinara nʼelu ya mgbe ọbara si ya nʼahụ na-apụta, maọbụ ihe ọbụla ọ nọdụrụ ala nʼelu ya, ga-abụ ihe rụrụ arụ, dịka mgbe ọbara nke oge a kara aka. ");
INSERT INTO ibo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Onye ọbụla metụrụ ihe ndina ya maọbụ ihe ọ nọdụrụ ala nʼelu ya aka, ga-arụ arụ ruo uhuruchi. Ọ ga-asakwa uwe ya na ahụ ya mmiri. ");
INSERT INTO ibo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Mgbe ọbara ahụ kwụsịrị, ọ ga-agụ ụbọchị asaa site nʼoge ọ kwụsịrị. Mgbe abalị asaa ahụ zuru, ọ ga-abụ onye dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Nʼụbọchị nke asatọ, ọ ga-ewere nduru abụọ maọbụ ụmụ kpalakwukwu abụọ, nye onye nchụaja nʼọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Onye nchụaja ahụ ga-eji otu chụọrọ ya aja mmehie, werekwa nke ọzọ chụọrọ ya aja nsure ọkụ. Nʼụzọ dị otu a, ọ ga-ekpuchiri ya mmehie ya nʼihu Onyenwe anyị, nʼihi adịghị ọcha nke ihe ọsụsọ ya. ");
INSERT INTO ibo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Unu ga-ekewapụ ụmụ Izrel site nʼihe ndị ahụ na-emerụ ha, ka ha ghara ịnwụ nʼọnọdụ adịghị ọcha ha nʼihi imerụ ụlọ nzute m, nke dị nʼetiti ha.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ndị a bụ usoro iwu gbasara ndị ikom ihe si nʼahụ ha na-asọpụta, na ndị ikom rụrụ arụ nʼihi mkpụrụ nwa si ha nʼahụ pụọ. ");
INSERT INTO ibo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Ọ bụkwa iwu dịrị nwanyị ọbara si nʼahụ ya pụọ nʼoge a kara aka, na nwoke maọbụ nwanyị ọbụla ihe si nʼahụ ya na-asọpụta, na nke dịrị nwoke ọbụla ya na nwanyị ga-edinakọ nʼoge nwanyị ahụ bụ onye rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Onyenwe anyị gwara Mosis okwu mgbe ụmụ ndị ikom Erọn abụọ ndị ahụ bịara nʼihu Onyenwe anyị nwụsịrị. ");
INSERT INTO ibo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Onyenwe anyị sịrị Mosis, “Gwa nwanne gị nwoke Erọn si ya ka ọ ghara ịbata mgbe ọbụla ọ chọrọ, nʼime Ebe ahụ Kachasị Nsọ nke dị nʼazụ akwa mgbochi, nke dị nʼihu ebe mkpuchi mmehie dị nʼelu igbe ọgbụgba ndụ ahụ, ma ọ bụghị ya ọ ga-anwụ. Nʼihi na aga m apụta ìhè nʼime igwe ojii dị nʼelu ebe mkpuchi ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Otu a ka Erọn ga-esi na-abata nʼEbe ahụ Kachasị Nsọ. Ọ ga-eweta nwa oke ehi nʼihi aja mmehie, na ebule ọ ga-eji chụọ aja nsure ọkụ, ");
INSERT INTO ibo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ọ ga-eyikwasị onwe ya uwe mwụda ọcha, ya na uwe ime ahụ dị ọcha. Ọ ga-eke gburugburu ukwu ya ihe ike nʼukwu akwa ọcha, keekwa akwa ọcha nʼisi ya. Ndị a bụ uwe dị nsọ, nʼihi ya, ọ ga-ebu ụzọ saa ahụ tupu ọ na-eyi ha. ");
INSERT INTO ibo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ọ ga-esi nʼaka ọgbakọ ụmụ Izrel nata mkpi abụọ nʼihi aja mmehie, na otu ebule nʼihi aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Erọn ga-eweta oke ehi nke ya, maka aja mmehie iji kpuchie mmehie nke ya na nke ezinaụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Emesịa, ọ ga-ewere mkpi abụọ ndị ahụ chee ha nʼihu Onyenwe anyị nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ọ ga-efe nza nʼisi mkpi abụọ ahụ, ịchọpụta nke dịrị Onyenwe anyị nke ọzọ abụrụ nke ọ ga-ahapụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Mkpi ahụ nza mara ga-abụ nke Onyenwe anyị, ya ka Erọn ga-egbu dịka aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma mkpi ahụ nke nza mara dịka ewu na-ewere ọnọdụ iburu mmehie ka a ga-eche na ndụ nʼihu Onyenwe anyị, nʼihi iji ya mee mmemme mkpuchi mmehie, a ga-ahapụ ya ka o buru mmehie niile kpafuo nʼọzara. ");
INSERT INTO ibo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Erọn ga-eweta oke ehi maka aja mmehie nke ya onwe ya, iji kpuchie mmehie ya na nke ezinaụlọ ya. Ọ ga-egbu oke ehi ahụ maka aja mmehie nke ya onwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ọ ga-esite nʼebe ịchụ aja dị nʼihu Onyenwe anyị were ihe ịgụ ọkụ jupụtara nʼicheku ọkụ. Ọ ga-ewerekwa ụda na-esi isi ụtọ ruru mkpoju aka abụọ, were ha bata nʼime akụkụ nke ọzọ nke akwa mgbochi ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Nʼebe ahụ ọ ga-awụnye ụda ndị ahụ na-esi isi ụtọ nʼelu icheku ọkụ ahụ nʼihu Onyenwe anyị, ka anwụrụ ọkụ nke ụda ndị a kpuchie ebe mkpuchi mmehie ahụ dị nʼelu Ihe Ama ahụ ka ọ ghara ịnwụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ọ ga-ewebatakwa ụfọdụ ọbara oke ehi ahụ, jiri mkpịsịaka ya fesa ya nʼihu ebe mkpuchi mmehie ahụ, nʼakụkụ ọwụwa anyanwụ, fesakwa ya ugboro asaa nʼihu ebe mkpuchi mmehie ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Emesịa, ọ ga-esi nʼebe ahụ pụọ gaa gbuo mkpi aja mmehie ụmụ Izrel, werekwa ọbara ya bata nʼazụ akwa mgbochi fesa ya nʼelu ebe mkpuchi mmehie ahụ, na nʼihu ya, dịka o jiri ọbara nwa oke ehi ahụ mee. ");
INSERT INTO ibo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nʼụzọ dị otu a, ọ ga-ekpuchiri Ebe ahụ Kachasị Nsọ mmehie ya, nʼihi mmehie na nnupu isi ụmụ Izrel, ihe ọbụla mmehie ndị ahụ bụ. Ọ ga-achụkwa ụdị aja a nʼihi ụlọ nzute ahụ, nʼihi na ọ dị nʼetiti ebe obibi rụrụ arụ nke ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","O nweghị onye ọbụla ọzọ ga-anọ nʼime ụlọ nzute ahụ, site nʼoge Erọn banyere nʼEbe ahụ Kachasị Nsọ ịchụ aja mkpuchi mmehie tutu ruo mgbe ọ pụtara, mgbe ọ chụchara aja mkpuchi mmehie maka onwe ya na ezinaụlọ ya, na maka ụmụ Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Mgbe o si nʼebe ahụ pụta, gaa nʼebe ịchụ aja dị nʼihu Onyenwe anyị kpuchiere ya mmehie ya. Ọ ga-ewere ụfọdụ ọbara nwa oke ehi ahụ na nke mkpi ahụ tee ya na mpi niile dị nʼebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ọ ga-eji mkpịsịaka ya fesa ụfọdụ ọbara ahụ nʼelu ebe ịchụ aja ahụ ugboro asaa iji hichapụ adịghị ọcha ya nʼihi ịrụ arụ ụmụ Izrel, na ido ya nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Mgbe Erọn chụchara aja mkpuchi mmehie maka Ebe ahụ Kachasị Nsọ, ụlọ nzute, nakwa ebe ịchụ aja, ọ ga-akpụbata mkpi ahụ e debere ndụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ọ ga-ebikwasị aka ya abụọ nʼisi ya, kwupụta ajọ omume na nnupu isi ụmụ Izrel niile, mmehie ha niile, bokwasị ha mkpi ahụ nʼisi. Ọ ga-ezipụ mkpi ahụ pụọ nʼime ọzara site nʼaka onye ahụ a họpụtara ime nke a. ");
INSERT INTO ibo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nʼụzọ dị otu a, mkpi ahụ ga-eburu mmehie ndị ahụ niile baa nʼebe mmadụ ọbụla na-ebighị. Nwoke ahụ ga-ahapụkwa ya nʼọzara. ");
INSERT INTO ibo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Mgbe ahụ, Erọn ga-aba nʼime ụlọ nzute ahụ, yipụ uwe akwa ọcha ndị nchụaja ahụ niile o yi nʼahụ ya tupu ọ banye nʼEbe ahụ Kachasị Nsọ. Ọ ga-awụsa ha nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ọ ga-eji mmiri saa ahụ ya nʼakụkụ ebe nsọ ahụ, yirikwa uwe efu ya. Mgbe ahụ, ọ ga-apụta bịa chụọ aja nsure ọkụ nke onwe ya, na aja nsure ọkụ nke ndị ahụ, maka ikpuchiri onwe ya, na ikpuchikwara ndị ahụ mmehie ha. ");
INSERT INTO ibo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ọ ga-akpọkwa abụba anụ e ji chụọ aja mmehie ahụ ọkụ nʼelu ebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Mgbe nwoke ahụ kpụgara mkpi ahụ nʼọzara hapụ ya, lọtara, ọ ga-asa ahụ ya na uwe ya tupu ọ laghachi nʼime obodo. ");
INSERT INTO ibo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Oke ehi nakwa mkpi maka ịchụ aja mmehie ahụ, bụ nke ewebatara ọbara ha nʼime Ebe ahụ Kachasị Nsọ, maka ikpuchi mmehie, ka aghaghị ibupụ nʼazụ ọmụma ụlọ ikwu; a ga-akpọ akpụkpọ ha, anụ ahụ ha na mgbịrị afọ ha niile ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Onye ga-akpọ ha ọkụ ga-asa uwe ya, saakwa ahụ ya tupu ọ laghachi nʼime obodo. ");
INSERT INTO ibo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Nke a ga-abụrụ unu ụkpụrụ ebighị ebi. Nʼafọ ọbụla, unu ga-ebu ọnụ, hapụ ịrụ ọrụ ọbụla, nʼụbọchị iri nke ọnwa asaa. Iwu a dịrị nwa afọ ala maọbụ onye ọbịa bi nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Nʼihi na nʼụbọchị a ka a na-ekpuchiri unu mmehie unu, ime ka unu dịrị ọcha. Mgbe ahụ, unu ga-abụ ndị dị ọcha site na mmehie unu niile nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ọ bụ ụbọchị izuike nye unu, bụrụkwa ụbọchị unu ga-ebu ọnụ. Iwu a enweghị mgbanwe! ");
INSERT INTO ibo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Onye nchụaja e tere mmanụ, nke e doro nsọ dịka onye nchụaja ịnọchi nna ya, ga-achụ aja mkpuchi mmehie ndị a, yirikwa akwa ọcha ahụ, bụ uwe nsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ọ ga-ekpuchiri Ebe ahụ Kachasị Nsọ na ụlọ nzute, ebe ịchụ aja na ndị nchụaja, na mkpokọta ndị obodo niile mmehie ha. ");
INSERT INTO ibo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Nke a ga-abụ iwu ebighị ebi nye unu. Otu ugboro nʼotu afọ ka a ga-ekpuchi mmehie maka mmehie ndị Izrel niile.” E mezuru ihe ndị a niile dịka Onyenwe anyị si nye ya Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Gwa Erọn, na ụmụ ya ndị ikom, na ụmụ Izrel niile okwu sị ha, ‘Ihe ndị a ka Onyenwe anyị nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Onye ọbụla bụ onye ụlọ Izrel gbuo ehi, maọbụ nwa atụrụ, maọbụ ewu nʼogige ebe obibi, maọbụ nʼazụ ebe obibi, ");
INSERT INTO ibo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ma o wetaghị ya nʼọnụ ụzọ ụlọ nzute iche ya dịka onyinye nʼihu Onyenwe anyị, nʼihu ụlọnsọ Onyenwe anyị, a ga-agụ onye ahụ dịka onye ikpe iwufu ọbara mara. Ọ wụfuola ọbara, nʼihi ya, a ga-esite nʼetiti ndị ya kewapụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ihe e ji nye iwu a bụ ka ụmụ Izrel wetara Onyenwe anyị aja niile ha na-achụ ugbu a na mbara ezi ọbụla. Ha kwesiri iwetara ya Onyenwe anyị site nʼaka onye nchụaja nʼọnụ ụzọ ụlọ nzute, ka o jiri ya chụọrọ ha aja udo. ");
INSERT INTO ibo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Nʼụzọ dị otu a, onye nchụaja ga-efesa ọbara ahụ nʼebe ịchụ aja dị nʼọnụ ụzọ ụlọ nzute, kpọọkwa abụba ya ọkụ, ka ọ bụrụ aja nsure ọkụ nke isisi ya dị Onyenwe anyị ezi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","O kwesikwaghị ka ndị Izrel chụọ aja ha ọzọ na mbara ezi nye arụsị ewu ndị ha na-akpọ isiala nye. Iwu a ga-adịgide nye ha na ụmụ ha niile, site nʼọgbọ ruo nʼọgbọ.’ ");
INSERT INTO ibo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Gwa ha, ‘Onye Izrel ọbụla, maọbụ onye ọbịa bi nʼetiti unu, nke ga-achụ aja nsure ọkụ maọbụ aja ọzọ, ");
INSERT INTO ibo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ma o webataghị ya nʼọnụ ụzọ ụlọ nzute, ebe a ga-achụrụ ya Onyenwe anyị, ka a ga-ewezuga site nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Onye Izrel ọbụla maọbụ onye ọbịa bi nʼetiti ha, nke riri ọbara ọbụla ka m ga-eche ihu m megide. A ga-ewezuga ya site nʼetiti ndị m. ");
INSERT INTO ibo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nʼihi na ndụ ihe nwere ndụ dị nʼọbara ya, ọ bụ nʼihi nke a ka m ji nye iwu na a ga-awụsa ọbara niile nʼelu ebe ịchụ aja, maka iji ya kpuchie mmehie unu. Ọ bụ ọbara na-ekpuchi mmehie maka ndụ mmadụ. ");
INSERT INTO ibo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nʼihi nke a, a sịrị ndị Izrel, “Ọ dịghị onye ọbụla nʼetiti unu, maọbụ onye ọbịa ọbụla nke bi nʼetiti unu ga-eri ọbara.” ");
INSERT INTO ibo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Onye Izrel ọbụla, na onye ọbịa ọbụla binyere unu nke gara ịchụ nta, gbuo anụ maọbụ nnụnụ ọbụla a na-eri eri, ga-awụfu ọbara ya were aja kpuchie ya. ");
INSERT INTO ibo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Nʼihi na ndụ ihe niile nwere ndụ dị nʼọbara. Ọ bụ ya mere m ji nye ụmụ Izrel iwu si unu erila ọbara anụmanụ ọbụla, nʼihi na ndụ ihe niile nwere ndụ dị nʼọbara ya. Nʼihi ya onye ọbụla riri ọbara, a ga-ekewapụ ya site nʼetiti ndị m. ");
INSERT INTO ibo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Mmadụ ọbụla, maọbụ nwa afọ ma ọ bụkwanụ onye ọbịa, nke riri anụ nwụrụ nʼonwe ya, maọbụ nke anụ ọhịa dọgburu, ga-eji mmiri saa uwe ya na ahụ ya, ọ ga-abụkwa onye rụrụ arụ ruo uhuruchi tupu ọ dị ọcha ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ma ọ bụrụ na ọ saghị uwe ya na ahụ ya, ikpe ọmụma dị ya nʼisi.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Gwa ụmụ Izrel okwu ndị a sị ha, ‘Mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ya mere, ọ bụ ezie na unu ebiela nʼetiti ndị Ijipt, ma unu ekwesighị ibi ndụ unu dịka ha si ebi. Unu ekwesịkwaghị ibi ndụ dịka ndị Kenan ebe m na-akpọbata unu. Unu agbasola omenaala ha. ");
INSERT INTO ibo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Unu ga-edebe iwu m niile, gbasookwa ụkpụrụ m niile nʼihi na abụ m Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Debenụ iwu m na ụkpụrụ m, nʼihi na onye na-edebe ha ga-adị ndụ site na ha. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Onye ọbụla ya na mmadụ bụ nwanne e jekwurukwala ya ka ha nwe mmekọ edina, i ji kpughee ọtọ ya. Mụ onwe m bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Ị gaghị eleda nna gị anya site na i jekwuru nne gị ka gị na ya nwe mmekọ edina. Nne gị ka ọ bụ; gị na ya agaghị enwe ụdị mmekọ dị otu a. ");
INSERT INTO ibo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Ị gaghị e jekwuru nwunye nna gị ka gị na ya nwe mmekọ edina. Nke a bụ ileda nna gị anya. ");
INSERT INTO ibo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Ị gaghị e jekwuru nwanne gị nwanyị ka gị na ya nwe mmekọ edina, maọbụ nwa nwanyị nke a mụụrụ nna gị, maọbụ nwa nwanyị nke nne gị mụrụ, ma a mụrụ ya nʼụlọ ma a mụrụ nʼama. ");
INSERT INTO ibo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ị gaghị e jekwuru nwa nwanyị nke nwa gị nwoke mụrụ, maọbụ nwa nwanyị nke nwa gị nwanyị mụrụ i nwe mmekọ edina; nʼihi na nke a ga-eweta nleda anya nye gị. ");
INSERT INTO ibo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ị gaghị e jekwuru nwa nwanyị nwunye nna gị mụrụ, ka gị na ya nwe mmekọ edina, nʼihi na ọ bụ nwa nna gị mụrụ; nwanne gị nwanyị ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Ị gaghị e jekwuru nwanne nwanyị nna gị ka gị na ya nwe mmekọ edina, nʼihi na ọbara jịkọrọ ya na nna gị, ha bụ otu ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Ị gaghị e jekwuru nwanne nne gị nke nwanyị, ka gị na ya nwe mmekọ edina, nʼihi na ọbara jịkọrọ ya na nne gị, ha bụ otu ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Ị gaghị eleda nwanne nna gị nke nwoke anya, site nʼijekwuru nwunye ya, ka gị na ya nwe mmekọ edina. Nʼihi na nwunye nwanna gị ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Ị gaghị e jekwuru nwunye nwa gị nwoke ka gị na ya nwe mmekọ edina; nwunye nwa gị nwoke ka ọ bụ; gị na ya agaghị enwe mmekọrịta ọbụla gosiri mkpughe ọtọ ya. ");
INSERT INTO ibo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Ị gaghị e jekwuru nwunye nwanne gị nwoke ka gị na ya nwe mmekọ edina, nʼihi na nke a bụ omume nleda anya nye nwanne gị nwoke. ");
INSERT INTO ibo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Ị gaghị e jekwuru nwanyị na nwa ya nwanyị ka gị na ha nwe mmekọ edina. Ị gaghị akpọrọ nwa nwanyị nwa ya nwoke, maọbụ nwa nwanyị nke nwa ya nwanyị mụrụ dinaa ya; nʼihi na otu ọbara ka ha bụ. Ihe dị otu a bụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Ị gaghị alụ nwanne nwanyị nwunye gị, dịka nwunye ọzọ gị, nʼihi ịkpagbu ya, gị na ya a na-enwe mmekọrịta edina, ị na-ekpughe ọtọ nwunye gị mgbe ọ ka dị ndụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘E jekwurukwala nwanyị ka gị na ya nwe mmekọ edina, mgbe ọ nọ nʼọnọdụ adịghị ọcha nke (ịsọ ụba) nsọ nwanyị ya nʼoge a kara aka. ");
INSERT INTO ibo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘A kpọrọkwala nwunye onye agbataobi gị idina ya, si otu a merụọ onwe gị nʼihi mmekọ dị otu a. ");
INSERT INTO ibo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Ị gaghị enye nwa gị ka e jiri ya chụọrọ Molek aja. Nʼihi na i kwesighị imerụ aha Chineke gị. Mụ onwe m bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Gị na nwoke edinala, dịka nwanyị na nwoke si edina. Ihe akpọrọ asị ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Gị na anụmanụ ọbụla edinakwala, site otu a merụọ onwe gị. Nwanyị agakwaghị ewere onwe ya nye ka ya na oke anụmanụ nwee mmekọrịta, arụ a na-adịghị eme eme ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Unu emerụkwala onwe unu site na-ime ihe ndị a, nʼihi na ihe ndị a bụ ihe mba ndị ahụ na-eme. Ọ bụkwa nʼihi ya ka m ga-eji chụpụ ha site nʼala ahụ m ga-enye unu. ");
INSERT INTO ibo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ọ bụladị ala ahụ niile ghọrọ ihe rụrụ arụ site nʼomume ndị a. Ọ bụ nke a mere m ji ata ndị bi nʼime ya ahụhụ nʼihi mmehie ha. Ala ahụ meghere ọnụ ya gbọpụta ndị bi nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Unu ga-edebe iwu m na ụkpụrụ m ndị a niile. Unu emekwala ihe arụ ndị a, ma ndị amụrụ nʼala ma ndị ọbịa niile bi nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ala m na-aga inye unu rụrụ arụ nʼihi na ndị bi nʼime ya na-eme omume ndị a rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Unu emekwala ihe arụ ndị a, nʼihi na ọ bụrụ na unu emee ha, ọ ga-emeghe ọnụ ya gbọpụta unu, dịka o si mee mba niile bụ ndị buru unu ụzọ biri nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Onye ọbụla nʼetiti unu mere ihe arụ ndị a, ka a ga-ekewapụ site nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nʼihi ya, lezienụ anya ka unu debe iwu m, ka unu ghara ime ihe arụ ndị a, nke ndị buru unu ụzọ biri nʼala ahụ mere. Ka unu gharakwa imerụ onwe unu site nʼomume arụ ndị a. Abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Gwa ọgbakọ ụmụ Izrel niile okwu sị ha: ‘Dịnụ nsọ, nʼihi na mụ onwe m bụ Onyenwe anyị bụ Chineke unu, dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Onye ọbụla nʼime unu aghaghị ịsọpụrụ nne na nna ya, debekwa iwu m nyere maka ụbọchị izuike, nʼihi na mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Unu akpọla isiala nye arụsị, unu emekwarala onwe unu chi ndị e ji ọla kpụọ. Mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Mgbe unu ga-achụrụ Onyenwe anyị aja udo, soronụ ụkpụrụ m nyere unu chụọ ya, ka m nabata ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Unu ga-eri ya nʼụbọchị ahụ unu chụrụ ya, maọbụ nʼụbọchị nke na-eso ụbọchị ahụ. Nke ọbụla fọdụrụ ruo ụbọchị nke atọ ka unu ga-esure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ọ bụrụ na unu erie ya nʼụbọchị nke atọ ihe arụ ka ọ bụ. A gaghị anabata aja ọbụla unu ga-eri nʼụbọchị nke atọ. ");
INSERT INTO ibo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ikpe ga-ama onye ga-eri ya nʼụbọchị nke atọ nʼihi na o meela ka ihe nsọ Onyenwe anyị bụrụ ihe arụ. A ga-ekewapụ onye ahụ site nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Mgbe unu na-ewe ihe ubi, unu ewechala ihe niile dị nʼakụkụ ubi niile, maọbụ chịkọtachaa irighiri ihe ubi niile fọdụrụ nʼala. ");
INSERT INTO ibo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","A ghọrọchakwala mkpụrụ vaịnị niile mịrị nʼelu vaịnị gị, maọbụ chịkọrọ mkpụrụ ndị dara nʼala. Hapụrụ ha ụmụ ogbenye na ndị ọbịa, nʼihi na mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Unu ezula ohi. “ ‘Unu aghala ụgha. “ ‘Unu aghọgbula ibe unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Unu aṅụla iyi ụgha, si otu a weta nkọcha nye aha Onyenwe anyị Chineke unu. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Unu ejila ike pụnara onye agbataobi unu ihe ya, maọbụ zuru ihe o nwere nʼohi. “ ‘Kwụọnụ onye ọbụla unu goro ọrụ ụgwọ ọrụ ya ọsịịsọ. Unu echela ka chi bọọ tupu unu akwụọ ya ụgwọ ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Akọchala onye ntị chiri, edochikwarala onye ìsì ihe nʼụzọ. Tụọ egwu Chineke. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Unu ekpela ikpe na-ezighị ezi, unu elela mmadụ anya nʼihu mgbe unu na-ekpe ikpe, ma onye unu na-ekpe ikpe ọ bụ ọgaranya maọbụ ogbenye. Kama kpeenụ ikpe kwụ ọtọ. ");
INSERT INTO ibo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Unu ejegharịla na-agbasa okwu nkwujọ nʼetiti ndị mmadụ. “ ‘Emela ihe ọbụla ga-ebutere onye agbataobi gị ọnwụ. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Akpọla nwanne gị asị nʼime obi gị. Tụọ onye agbataobi gị mmehie ya nʼihu ya, ka ị ghara iketa oke nʼikpe ọmụma dịrị ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Abọla ọbọ, ebukwala iro nʼobi megide onye ọbụla nʼetiti ndị gị. Kama hụ onye agbataobi gị nʼanya dịka i si hụ onwe gị nʼanya. Mụ onwe m bụ Onyenwe anyị unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Unu ga-edebe iwu m niile. “ ‘Unu ejila otu ụdị anụ ụlọ unu na-agba ụdị anụ ụlọ ọzọ dị iche. “ ‘Akụla ụdị mkpụrụ abụọ nʼubi. “ ‘Eyila uwe e ji ụzọ ihe abụọ, dịka ajị anụ na ogho dụọ. ");
INSERT INTO ibo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Ọ bụrụ na nwoke ọbụla akpọrọ nwaagbọghọ bụ ohu nwanyị nke a na-agbapụtabeghị, maọbụ nke na-enwerebeghị onwe ya, nke nwoke ọzọ chọrọ ịlụ, mee ka ha abụọ dinakọọ, a ga-ekpe ha abụọ ikpe nʼụlọikpe, ma a gaghị egbu ha, nʼihi na nwanyị ahụ abụghị onye nwe onwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ma nwoke ahụ ga-eweta aja ikpe ọmụma nye Onyenwe anyị nʼọnụ ụzọ ụlọ nzute. Ọ ga-abụkwa ebule ka ọ ga-eji chụọ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Onye nchụaja ga-eji ebule aja ikpe ọmụma ahụ chụọrọ nwoke ahụ aja mkpuchi mmehie ya nʼihu Onyenwe anyị, nʼihi mmehie o mere. A ga-agbaghakwara ya mmehie ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Mgbe unu batara nʼala ahụ kụọ mkpụrụ osisi dị iche iche, unu erila mkpụrụ osisi ahụ mịrị nʼafọ nke mbụ, ọ bụ ihe rụrụ arụ. Ruo nʼafọ nke atọ, ha bụ ihe rụrụ arụ. Unu agaghị eri ha. ");
INSERT INTO ibo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Nʼafọ nke anọ, mkpụrụ nke osisi ndị ahụ niile ga-amị dị nsọ. Unu ga-eji ya nye Onyenwe anyị onyinye otuto. ");
INSERT INTO ibo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Site nʼafọ nke ise, mkpụrụ ọbụla ga-abụ nke unu. Nʼụzọ dị otu a ihe ha ga-amịpụta ga-adị ukwuu. Mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Unu erila anụ ọbụla ọbara dị nʼime ya. “ ‘Unu agbala afa maọbụ jụta mmụọ ase. ");
INSERT INTO ibo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Unu akpụchala agịrị isi dị gburugburu akụkụ isi unu, maọbụ chabie ọnụ ọnụ afụọnụ unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Unu akala ihe ọbụla nʼahụ unu, nʼihi onye nwụrụ anwụ maọbụ jiri mma ọkụ dee ihe nʼahụ unu. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Emerụla nwa gị nwanyị site nʼịkwagide ya ka ọ bụrụ akwụna, ka ala unu ghara ijupụta nʼịgba akwụna na ihe ọjọọ dị iche iche. ");
INSERT INTO ibo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Debenụ iwu niile m nyere maka ụbọchị izuike m. Sọpụkwaranụ ebe nsọ m. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Unu ejekwurula ndị na-ajụ mmụọ ọjọọ ase maọbụ chọgaa ndị dibịa afa, nʼihi na unu ga-emerụ onwe site na ha. Mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Bilienụ ọtọ nʼihu okenye, sọpụrụnụ ndị okenye, ma tụọnụ egwu Chineke unu. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Mgbe onye ọbịa soro unu biri nʼala unu, unu emejọla ya. ");
INSERT INTO ibo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mesonụ onye ọbịa bi nʼetiti unu mmeso dịka ọ bụ otu nʼime ndị amụrụ nʼala. Hụnụ ha nʼanya dịka unu si hụ onwe unu, nʼihi na o nwere oge unu bụ ọbịa nʼala Ijipt. Abụ m Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Unu ejila ihe ọtụtụ aghụghọ mgbe unu na-atụ ihe dị ogologo, maọbụ ihe dị arọ, maọbụ ihe dị ukwuu, ");
INSERT INTO ibo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Jirinụ ezi ihe ọtụtụ tụọ ogologo, maọbụ ihe dị arọ, maọbụ ihe dị ukwuu. Abụ m Onyenwe anyị Chineke unu, onye si nʼala Ijipt kpọpụta unu. ");
INSERT INTO ibo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Debenụ ụkpụrụ m niile, na iwu m niile, gbasoonụ ha. Abụ m Onyenwe anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Onyenwe anyị sịrị Mosis, ");
INSERT INTO ibo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Gwa ụmụ Izrel, ‘Onye Izrel ọbụla maọbụ onye ọbịa ọbụla bi nʼetiti unu, nke weere nwa ya nye maka ịchụrụ Molek aja, aghaghị ime ka ọ nwụọ. Ndị mmadụ ga-ewere nkume tugbuo ya. ");
INSERT INTO ibo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mụ onwe m ga-emegide onye ahụ, bipụ ya site nʼetiti ndị ya, nʼihi na o merụọla ebe nsọ m, mee ka aha m gharakwa ịdị nsọ, site nʼiji ụmụ ya chụọrọ Molek aja. ");
INSERT INTO ibo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ọ bụrụ na ndị obodo elezie anya mee omume dịka a ga-asị na ha amaghị ihe onye ahụ mere, hapụkwa igbu ya, mgbe o were otu nʼime ụmụ ya nye Molek, ");
INSERT INTO ibo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mụ onwe m ga-emegide onye ahụ na ezinaụlọ ya bipụ ha site nʼetiti ndị ya. Otu a kwa ka m ga-eme ya na ndị niile so ya merụọ onwe ha site nʼife arụsị Molek. ");
INSERT INTO ibo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Aga m edo ihu m megide onye ọbụla gara jụọ ase site nʼaka mmụọ ọjọọ, maọbụ onye gara na dibịa afa gbaa afa, site nʼiso ha kwaa iko. Aga m ekewapụ onye ahụ site nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Doonụ onwe unu nsọ, ma dịkwanụ nsọ nʼihi na abụ m Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Debenụ ụkpụrụ m niile, ma gbasoonụ ha nʼihi na abụ m Onyenwe anyị onye na-edo unu nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Onye ọbụla kọchara nne ya maọbụ nna ya ka a ga-egbu nʼihi na ọ kọchara nne na nna ya. Ọbara onye dị otu a ga-adịkwa ya nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Ọ bụrụ na nwoke ọbụla edinakwuru nwunye nwoke ọzọ, ya bụ nwunye onye agbataobi ya, nwoke ahụ na nwanyị kwara iko ka a ga-egbu. ");
INSERT INTO ibo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Nwoke ọbụla ya na nwunye nna ya dinakọrọ nwe mmekọ, emerụọla nna ya. A ga-egbu nwoke ahụ na nwanyị ahụ. Ọbara ha ga-adị ha nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Ọ bụrụ na nwoke ọbụla edinakwuru nwunye nwa ya, wetara onwe ha ikpe ọmụma, a ga-egbu ha abụọ nʼihi na ọ bụ arụ ka ha mere. ");
INSERT INTO ibo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Ọ bụrụ nwoke na nwoke ibe ya edinakọọ nwee ụdị mmekọ edina nwoke na nwanyị, a ga-egbu ha abụọ nʼihi na ihe ha mere bụ ihe rụrụ arụ. Ọbara ha ga-adị ha nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Ọ bụrụ na nwoke alụọ nwanyị na nne mụrụ ya, ajọ ihe ka ọ bụ. Nwoke ahụ na ndị inyom ndị ahụ ka a ga-akpọ ọkụ, ka ihe ọjọọ dị otu a hapụ ịdị nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Ọ bụrụ na nwoke na anụmanụ enwee mmekọrịta, a ga-egbu nwoke ahụ gbukwaa anụmanụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Ọ bụrụ na nwanyị ọbụla abịaruo anụmanụ ọbụla nso dinakwuru ya inwe mmekọ, a ga-egbu nwanyị ahụ na anụmanụ ahụ, nʼihi na ha kwesiri ọnwụ. Ọbara ha ga-adị ha nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Nwoke ọbụla ya na nwanne ya nwanyị nwere mmekọ edina, maọbụ nwa afọ nne ya maọbụ nwa nwunye nna ya, a ga-ekpochapụ ha site nʼihu ọha mmadụ nʼihi na ọ bụ ihe ihere dị ukwuu ka ha mere. Ọ merụọla nwanne ya, nʼihi ya ikpe ọmụma dị ya nʼisi. ");
INSERT INTO ibo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Nwoke ọbụla nke ya na nwanyị nọ na nsọ nwanyị ya dinakọrọ nwee mmekọ ekpugheela adịghị ọcha nwanyị ahụ. Nwanyị ahụ nʼonwe ya ekpugheekwala adịghị ọcha nke ya. A ga-ebipụ ha abụọ site nʼetiti ndị ha. ");
INSERT INTO ibo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Ị gaghị enwe mmekọ edina nʼetiti gị na nwanne nwanyị nne gị maọbụ nwanne nwanyị nna gị, nʼihi na nke a bụ ihe nleda anya nye onye ọbara jịkọrọ gị na ya. Ikpe ọmụma ga-adịrị unu abụọ. ");
INSERT INTO ibo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Ọ bụrụ na nwoke ọbụla na nwunye nwanne nna ya edinaa, ọ bụ omume ileda anya nye nwanne nna ya. Ha ga-ebu mmehie ha. Ha ga-anwụ na-amụtaghị nwa. ");
INSERT INTO ibo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Ọ bụrụ na nwoke alụọ nwunye nwanne ya, ọ bụ omume rụrụ arụ, nʼihi na ọ bụ ihe nleda anya nye nwanne ya. Ha ga-agba aka nwa. ");
INSERT INTO ibo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Debenụ iwu ndị a na ụkpụrụ ndị a, ma gbasoonụ ha ka ala ahụ m na-eduba unu nʼime ya hapụ imeghe ọnụ ya gbụpụ unu. ");
INSERT INTO ibo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Unu agbasola omenaala ndị mba niile a m na-achụpụ site nʼala m na-enye unu, nʼihi na ha na-eme ihe ndị a niile m nyere unu nʼiwu emela. Ọ bụ nke a mere ihe banyere ha ji sọọ m oyi. ");
INSERT INTO ibo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ma agwala m unu sị, “Unu ga-eketa ala ha. Aga m enye ya unu ka ọ bụrụ ihe nketa unu. Ala mmiri ara ehi na mmanụ aṅụ na-eru na ya.” Abụ m Onyenwe anyị Chineke unu onye kewapụtara unu doo unu iche site na mba ndị ọzọ niile. ");
INSERT INTO ibo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Unu aghaghị ịkpa oke nʼetiti anụmanụ ndị dị ọcha iri eri, na anụmanụ ndị na-adịghị ọcha, na nʼetiti anụ ufe dị ọcha iri eri na ndị rụrụ arụ. Unu emerụla onwe unu site nʼiri anụmanụ maọbụ anụ ufe, maọbụ ihe ọzọ na-akpụgharị nʼala, ndị ahụ m kewapụrụ iche dịka ihe rụrụ arụ. ");
INSERT INTO ibo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Unu ga-adị nsọ nye m, nʼihi na mụ, bụ Onyenwe anyị, dị nsọ. Ekewapụtala m unu, doo unu iche, site nʼetiti ndị mba ọzọ niile, ka unu bụrụ nke m. ");
INSERT INTO ibo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘A ga-eji nkume tugbuo nwoke maọbụ nwanyị ọbụla nke na-ajụ mmụọ ọjọọ ase, maọbụ dibịa afa nọ nʼetiti unu ka ọ nwụọ. Ọbara ha ga-adịkwa ha nʼisi.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Onyenwe anyị gwara Mosis sị, “Gwa ndị nchụaja, ụmụ ndị ikom Erọn okwu sị ha, ‘Onye nchụaja ekwesighị imerụ onwe ya mgbe mmadụ nwụrụ nʼetiti ụmụnna ya. ");
INSERT INTO ibo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Karịakwa ma onye ahụ bụ onye dị ya nnọọ nso, dịka nne ya, maọbụ nna ya, maọbụ nwa ya nwoke, maọbụ nwa ya nwanyị, maọbụ nwanne ya nwoke, ");
INSERT INTO ibo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","maọbụ nwanne ya nwanyị na-alụbeghị di, onye ọ na-elekọta nʼihi na o nweghị di. Nʼihi ya, o nwere ike merụọ onwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ma ọ gakwaghị eme onwe ya ka ọ ghara ịdị ọcha nʼetiti ndị ọgọ ya, ma site otu a merụọ onwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Ndị nchụaja ekwesighị ịkpụcha isi ha, maọbụ kpụchapụ akụkụ afụọnụ ha, maọbụ kaa ihe ọbụla nʼakpụkpọ ahụ ha. ");
INSERT INTO ibo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ha ga-abụ ndị dị nsọ nye Chineke ha, ndị na-agaghị emekwa ka aha Chineke ha ghara ịdị nsọ. Nʼihi na ọ bụ ha na-eche nʼihu Onyenwe anyị onyinye aja nsure ọkụ, bụ nri Chineke ha. Nʼihi ya, ha aghaghị ịdị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Onye nchụaja agaghị alụ nwanyị e merụrụ site nʼịgba akwụna, maọbụ nwanyị lụtụrụla di nke kewapụrụ onwe ya site nʼahụ di ya, nʼihi na ndị nchụaja bụ ndị dị nsọ nye Chineke ha. ");
INSERT INTO ibo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Gụọ ha dịka ndị dị nsọ nʼihi na ọ bụ ha na-eche nri Chineke nʼihu ya. Gụọ ha dịka ndị dị nsọ nʼihi na mụ onwe m bụ Onyenwe anyị dị nsọ, mụ onwe m na-eme ka unu dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ọ bụrụ na nwa nwanyị onye nchụaja emerụọ onwe ya site nʼịghọ onye akwụna, o sitela na ndụ ọjọọ dị otu a wetara nna ya ihe ihere. A ga-akpọ ya ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Onyeisi nchụaja, onye ahụ sitere nʼetiti ụmụnna ya, onye awụsara mmanụ nsọ nʼisi ya, onye ahọrọ doo nsọ iyiri uwe onye nchụaja ahụ, agaghị ahapụ agịrị isi ya ka ọ kpasasịa, maọbụ dọwaa uwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ọ gaghị abanye ebe ozu dị. Ọ gaghị emerụ onwe ya, ọ bụladị ma ozu ahụ ọ bụ nke nne ya maọbụ nke nna ya. ");
INSERT INTO ibo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ọ gaghị esi nʼebe nsọ Chineke ya pụọ, maọbụ mee ya ka ọ ghara ịdị nsọ, nʼihi na e doola ya nsọ site na ite ya mmanụ nsọ nke Chineke ya. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Nwanyị onyeisi nchụaja ga-alụ ga-abụ nwanyị na-amaghị nwoke. ");
INSERT INTO ibo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ọ gaghị alụ nwanyị di ya nwụrụ, maọbụ nwanyị ya na di ya na-ebikwaghị, maọbụ nwanyị akwụna. Nwanyị ọ ga-alụ ga-abụ naanị nwanyị na-amaghị nwoke nke si nʼetiti ụmụnna ya, ");
INSERT INTO ibo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ka ọ ghara ime ka ụmụ ya ghara ịdị nsọ nʼetiti ụmụnna ya. Abụ m Onyenwe anyị onye na-edo ya nsọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Gwa Erọn, ‘Nʼọgbọ niile nke na-abịa, o nweghị onye ọbụla nʼime ụmụ ụmụ gị nke akụkụ ahụ ya na-ezughị oke ga-abịa nso iwetara Chineke ya ihe oriri. ");
INSERT INTO ibo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","O nweghị nwoke ọbụla nwere ọrụsị ọbụla ga-abịa nso, o nweghị nwoke kpuru ìsì, maọbụ onye ngwụrọ, maọbụ onye imi mpịa, maọbụ onye ụkwụ maọbụ aka ya na-ezughị oke, ");
INSERT INTO ibo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","maọbụ onye ọkpụkpụ ụkwụ ya maọbụ ọkpụkpụ aka ya gbajiri, ");
INSERT INTO ibo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","maọbụ onye mkpumkpu azụ dị, maọbụ nwa akakpọ, maọbụ onye na-adịghị ahụzi ụzọ, maọbụ onye agba na-ata, maọbụ onye akpụkpa dị nʼahụ, maọbụ onye mkpụrụ amụ ya chipịara echipịa. ");
INSERT INTO ibo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","O nweghị nwa nwa Erọn onye nchụaja ọbụla nwere ọrụsị ga-abịa iwetara Onyenwe anyị aja onyinye site nʼọkụ. Ebe ọ bụ na o nwere ọrụsị, ọ gaghị abịa nso iwetara Chineke ya nri. ");
INSERT INTO ibo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ma o nwere ike iri nri ahụ dịkarịsịrị nsọ nke sitere na nri Chineke ya, tinyekwara nri ahụ dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Kama ọ gaghị abịa nso akwa mgbochi ahụ maọbụ bịaruo ebe ịchụ aja nso, nʼihi ezughị oke ya. Ka ọ ghara imerụ ebe nsọ m, nʼihi na abụ m Onyenwe anyị onye na-edo ha nsọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ya mere Mosis nyere Erọn na ụmụ ya ndị ikom na ụmụ Izrel niile iwu ndị a. ");
INSERT INTO ibo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Gwa Erọn na ụmụ ya ndị ikom ka ha jiri nsọpụrụ nabata onyinye dị nsọ nke ụmụ Izrel na-edo nsọ nye m, ka ha ghara imerụ aha nsọ m. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Gwa ha sị, ‘Nʼọgbọ unu niile na-abịa, ọ bụrụ na enwee onye ọbụla nʼagbụrụ unu nke bịara nso nʼihe ndị ahụ dị nsọ ụmụ Izrel na-edo nsọ nye Onyenwe anyị, mgbe onye ahụ nọ ọnọdụ dịka onye rụrụ arụ, a ga-esi nʼihu m wezuga onye ahụ. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Onye ọbụla bụ nwa nwa Erọn nke ọrịa ekpenta na-arịa, maọbụ nke ihe si nʼahụ ya na-asọpụta agaghị eri aja dị nsọ tutu ruo mgbe e mere ka ọ dịrị ọcha. Ọ ga-abụkwa onye rụrụ arụ ma ọ bụrụ na o metụ ozu aka, maọbụ onye mkpụrụ nwa na-esite nʼahụ awụsị, ");
INSERT INTO ibo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","maọbụ na o metụrụ anụ na-akpụgharị akpụgharị nʼala aka, nke na-emerụ ya, maọbụ na ọ metụrụ mmadụ aka nke mere ka ọ bụrụ onye rụrụ arụ nʼagbanyeghị ihe ọ bụ na-emerụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Onye ahụ metụrụ ihe ndị a aka ga-abụ onye rụrụ arụ ruo uhuruchi. Ọ gaghị eri ihe nsọ ọbụla tutu ruo mgbe ọ sachara ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Mgbe anyanwụ dara ka ọ ga-adị ọcha, nweekwa ike iri ihe dị nsọ, nʼihi na ọ bụ nri ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ọ gaghị eri anụ nwụrụ anwụ, maọbụ nke anụ ọzọ dọgburu, nʼihi na ihe ndị a ga-emerụ ya. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Ndị nchụaja kwesiri idebe ụkpụrụ m, ka ha ghara ịbụ ndị ikpe mara si otu a nwụọ nʼihi na ha lelịrị ha anya. Abụ m Onyenwe anyị onye na-edo ha nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘O nweghị onye ọbụla na-esiteghị nʼezinaụlọ ndị nchụaja ga-eri aja nsọ ahụ. Onye bụ ọbịa na onye e goro ọrụ nọ nʼụlọ onye nchụaja agaghị eri ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Otu ọ dị, ọ bụrụ na onye nchụaja weere ego nke aka ya gbata ohu, maọbụ na a mụrụ ohu ahụ nʼụlọ ya, ohu ahụ nwere ike iri aja nsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ọ bụrụ na nwa nwanyị onye nchụaja alụọ onye na-abụghị onye nchụaja, ọ gaghị eri ihe ọbụla site nʼime aja nsọ a. ");
INSERT INTO ibo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ma nwa nwanyị onye nchụaja nke di ya nwụrụ, maọbụ na ya na di ya ebikwaghị, ọ bụrụkwa na ọ mụtaghị nwa ọbụla, ọ lọghachi bịa biri nʼụlọ nna ya dịka o mere mgbe ọ bụ agbọghọ, o nwere ike iri nri dị nʼụlọ nna ya. Ọ dịkwaghị onye na-ekwesighị iri ya, nke ga-eri ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Ọ bụrụ na onye ọbụla erie onyinye nsọ ahụ na-amaghị ama, ọ ga-eweghachiri onye nchụaja ihe niile o riri tụkwasịkwa ya otu ụzọ nʼụzọ ise ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ndị nchụaja ekwesighị imerụ onyinye nsọ ụmụ Izrel na-eche nʼihu Onyenwe anyị, ");
INSERT INTO ibo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","site nʼikwenye ka ndị mmadụ efu rie onyinye nsọ ahụ, si otu a wetara ndị riri ya ikpe ọmụma nke ya na nkwụghachi so. Abụ m Onyenwe anyị onye na-edo ha nsọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Gwa Erọn na ụmụ ya ndị ikom na ụmụ Izrel niile okwu sị ha, ‘Ọ bụrụ na onye ọbụla, onye Izrel maọbụ onye ọbịa nʼIzrel, eweta aja nsure ọkụ nye Onyenwe anyị imezu nkwa o kwere, maọbụ dịka onyinye afọ ofufu, ");
INSERT INTO ibo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ọ ga-eweta otu oke nke na-enweghị nkwarụ nke si nʼigwe ehi, maọbụ atụrụ, maọbụ ewu, ka a nabata ya nʼaha. ");
INSERT INTO ibo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ewebatala ihe ọbụla nke nwere nkwarụ, nʼihi na agaghị m anabata ya nʼaha gị. ");
INSERT INTO ibo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mgbe onye ọbụla wetara ehi maọbụ atụrụ maọbụ ewu site nʼigwe anụ, dịka onyinye aja udo ọ na-enye Onyenwe anyị maka imezu nkwa, maọbụ onyinye afọ ofufu, ọ ga-abụ nke na-enweghị ọrụsị maọbụ ntụpọ ọbụla tupu a nabata ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Anụmanụ ọbụla kpuru ìsì, maọbụ nke merụrụ ahụ, maọbụ nke ụkwụ maọbụ aka gbajiri, maọbụ nke akpụkpa dị nʼahụ ya, maọbụ ihe nwere ure, maọbụ nke ọnya dị nʼahụ, agaghị abụ ihe onyinye nye Onyenwe anyị. Unu atụkwasịkwala ha nʼebe ịchụ aja dịka onyinye nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Unu nwere ike jiri ehi maọbụ atụrụ nke akụkụ ahụ ya tara ata, maọbụ nke otu akụkụ ya buru ibu karịa ibe ya chụọ aja onyinye si nʼobi, ma a gaghị e ji ya chụọ aja imezu nkwa. ");
INSERT INTO ibo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Unu agaghị enye anụmanụ ọbụla nke mkpụrụ amụ ya chipịara echipịa, maọbụ nke pịara apịa, maọbụ nke a dọwapụrụ adọwapụ maọbụ nke a chakapụrụ achakapụ, dịka onyinye nʼihu Onyenwe anyị. Unu enyekwala ụdị onyinye a nʼala unu. ");
INSERT INTO ibo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Unu esitekwala nʼaka onye ọbịa nata ụdị onyinye a, ma webata ya dịka nri a na-enye Chineke unu. A gaghị anabata ha nʼọnọdụ unu, nʼihi na ha nwere nkwarụ, nwekwa ntụpọ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Onyenwe anyị sịrị Mosis, ");
INSERT INTO ibo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Mgbe a mụrụ nwa ehi, maọbụ nwa atụrụ, maọbụ ewu ọhụrụ, a ga-ahapụ ya na nne ya ụbọchị asaa. Site nʼụbọchị nke asatọ gaa nʼihu a ga-anabata ya dịka onyinye ihe oriri i ji chụọ aja nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Egbula nne anụ na nwa ya nʼotu ụbọchị, maọbụ ehi maọbụ atụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Mgbe unu na-achụrụ Onyenwe anyị aja ekele, chụọnụ ya nʼụzọ ahụ a ga-anabata ya. ");
INSERT INTO ibo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Riekwanụ anụ aja ahụ nʼotu ụbọchị ahụ, ka ọ hapụ ịfọdụ ruo echi ya. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Unu ga-edebe iwu m ndị a niile, mee ha nʼihi na abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Unu emekwala ka aha m ghara ịdị nsọ. A ga-edo aha m nsọ nʼetiti ụmụ Izrel, nʼihi na abụ m Onyenwe anyị onye na-edo unu nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ọ bụ m kpọpụtara unu site nʼala Ijipt ka m bụrụ Chineke unu. Abụ m Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Gwa ụmụ Izrel okwu sị ha, ‘Ndị a bụ mmemme a kara aka nye Onyenwe anyị, nke unu ga-ekwusa dịka mkpọkọta dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Ụbọchị isii ka unu ga-eji rụọ ọrụ. Ma ụbọchị nke asaa, bụ ụbọchị izuike, ụbọchị mkpọkọta dị nsọ. Unu agaghị arụ ọrụ ọbụla nʼụbọchị ahụ, nʼebe ọbụla unu bi. Ọ bụ ụbọchị izuike nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Ndị a bụ mmemme Onyenwe anyị a kara aka, mkpọkọta dị nsọ nke unu ga-ekwusa nʼoge a kara aka. ");
INSERT INTO ibo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Nʼọnwa mbụ, nʼụbọchị nke iri na anọ nke ọnwa ahụ, nʼoge uhuruchi, mgbe anwụ dara, ka Mmemme Ngabiga Onyenwe anyị ga-adị. ");
INSERT INTO ibo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Mmemme achịcha na-ekoghị eko Onyenwe anyị ka unu ga-ebido nʼụbọchị iri na ise nke ọnwa ahụ. Abalị asaa ka unu ga-eri achịcha a na-ejighị ihe na-eko achịcha mee. ");
INSERT INTO ibo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Nʼụbọchị mbụ nke mmemme a, unu ga-enwe mkpọkọta dị nsọ, ọ dịkwaghị onye ọbụla ga-arụ ọrụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Unu ga-eweta aja e sitere nʼọkụ chụọ nye Onyenwe anyị. Nʼụbọchị nke asaa nweenụ mkpọkọta dị nsọ, unu arụkwala ọrụ nke ụbọchị ahụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Onyenwe anyị gwara Mosis sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Gwa ụmụ Izrel sị ha, ‘Mgbe unu banyere nʼala ahụ m na-aga inye unu, ghọta mkpụrụ ihe ubi nke mbụ unu, unu ga-ewetara onye nchụaja otu ukwu ọka site nʼọka unu ghọtara nʼubi unu. ");
INSERT INTO ibo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ọ ga-anara unu ukwu ọka ahụ fufee ya nʼihu Onyenwe anyị, ka a nabata ya. Ọ bụ nʼụbọchị ahụ ga-esote ụbọchị izuike ka onye nchụaja ga-efufe ya. ");
INSERT INTO ibo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Nʼotu ụbọchị ahụ e fufere ukwu ọka ahụ, unu ga-ewere nwa ebule na-enweghị ntụpọ, nke gbara naanị otu afọ, chụọrọ Onyenwe anyị aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Aja mkpụrụ ọka ga-eso aja nsure ọkụ a. Ọ ga-eji iko ọka a kwọrọ nke ọma iri na abụọ a gwara mmanụ oliv, ka ọ bụrụ ihe e surere nʼọkụ na-esi ezi isi ọma nye Onyenwe anyị. A ga-enyekwa iko mmanya atọ dịka onyinye ihe ọṅụṅụ ");
INSERT INTO ibo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Unu agaghị eri achịcha, maọbụ ọka e ghere eghe, maọbụ ọka ọhụrụ tutu ruo mgbe unu buru ụzọ weta onyinye nye Chineke unu. Nʼebe ọbụla unu bi, ụkpụrụ a ga-adịgide ruo ọgbọ niile. ");
INSERT INTO ibo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Site nʼụbọchị ahụ sotere ụbọchị izuike, bụ ụbọchị ahụ unu wetara ukwu ọka nke onyinye mfufe, gụpụta izu asaa zuru ezu. ");
INSERT INTO ibo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Gụpụtakwa iri ụbọchị ise site nʼụbọchị izuike ahụ mezuru izu asaa ahụ ma wetara Onyenwe anyị onyinye ọka ọhụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Site nʼebe ọbụla unu bi, unu ga-ewetara Onyenwe anyị ogbe achịcha abụọ nke unu ji iko ọka a kwọrọ nke ọma iri na abụọ, nke e ji ihe na-eko achịcha mee, ya bụ yiist, dịka aja mfufe nke mkpụrụ mbụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tinyere achịcha a, unu ga-eweta ụmụ atụrụ asaa gbara otu afọ, ndị na-enweghị ntụpọ, na otu nwa oke ehi, na ebule abụọ. Ha ga-abụ aja nsure ọkụ nye Onyenwe anyị, ya na aja mkpụrụ ọka na aja ihe ọṅụṅụ, aja e sitere nʼọkụ chụọ, nke isisi ya dị ezi mma nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Unu ga-ejikwa otu mkpi chụọ aja mmehie. Werekwa ụmụ atụrụ abụọ gbara otu afọ, otu afọ, chụọ aja udo. ");
INSERT INTO ibo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Onye nchụaja ga-efufe ụmụ atụrụ abụọ ndị a, na achịcha ndị si na mkpụrụ mbụ ahụ nʼihu Onyenwe anyị dịka aja mfufe. Ha bụ aja dị nsọ nye Onyenwe anyị. Ọ bụkwa ndị nchụaja ga-ewere ha dịka nri ha. ");
INSERT INTO ibo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Nʼotu ụbọchị ahụ unu ga-akpọsakwa mkpọkọta dị nsọ, unu arụkwala ọrụ nke ụbọchị ahụ. Nke a ga-abụ ụkpụrụ ga-adịgide ebighị ebi site nʼọgbọ ruo nʼọgbọ niile, nʼebe ọbụla unu bi. ");
INSERT INTO ibo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Mgbe unu na-ewe ihe ubi, unu ewechala ihe niile dị nʼakụkụ niile nke ubi unu. Hapụrụnụ ha ụmụ ogbenye, na ndị ọbịa. Hapụkwara ha mkpụrụ ubi niile dara nʼala. Abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Gwa ụmụ Izrel sị, ‘Ụbọchị mbụ nke ọnwa nke asaa ga-abụ ụbọchị izuike, ụbọchị mkpọkọta dị nsọ nke a ga-eji opi na-ada oke ụda cheta. ");
INSERT INTO ibo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Unu arụla ọrụ ọbụla nʼụbọchị ahụ, kama unu ga-achụ aja nsure ọkụ nye Onyenwe anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ụbọchị nke iri nke ọnwa asaa a bụ ụbọchị Mkpuchi Mmehie. Ọ bụ ụbọchị mkpọkọta dị nsọ nye unu. Unu ga-ata onwe unu ahụhụ bịa wetara Onyenwe anyị onyinye site nʼọkụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Unu arụla ọrụ ọbụla nʼụbọchị ahụ nʼihi na ụbọchị ahụ bụ ụbọchị ịchụ aja mkpuchi mmehie unu nʼihu Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Onye ọbụla na-ejighị ụbọchị ahụ weda onwe ya nʼala ka a ga-ekewapụ site nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Aga m ebibikwa onye ọbụla rụrụ ọrụ nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Unu agaghị arụ ọrụ ọbụla. Nʼebe ọbụla unu bi, ụkpụrụ a ga-adịgide nye unu niile site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ọ ga-abụ ụbọchị izuike zuruoke nye unu, unu ga-ewedakwa onwe unu nʼala. Nʼụbọchị nke itoolu nke ọnwa ahụ, site nʼuhuruchi ruo nʼuhuruchi nke na-esote ya, unu ga-edebe izuike unu.” ");
INSERT INTO ibo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Gwa ụmụ Izrel, ‘Nʼụbọchị nke iri na ise, nʼọnwa nke asaa, ka unu ga-amalite mmemme Ụlọ Ikwu Onyenwe anyị. A ga-eme ya ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Nʼụbọchị nke mbụ bụ ụbọchị mkpọkọta dị nsọ. Onye ọbụla agaghị arụ ọrụ nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Nʼụbọchị ọbụla nʼime ụbọchị asaa ndị a niile ka a ga-ewetara Onyenwe anyị onyinye site nʼọkụ. Nʼụbọchị nke asatọ ka mkpọkọta dị nsọ ga-adị. A ga-achụ aja nsure ọkụ nye Onyenwe anyị, nʼụbọchị a. Ọ bụ mkpokọta mmechi, nʼihi ya, a gaghị arụ ọrụ ọbụla nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Ndị a bụ mmemme a kara aka, mgbe a ga-ekwusa mkpọkọta dị nsọ maka iwetara Onyenwe anyị onyinye nri, ya bụ, onyinye aja nsure ọkụ, na onyinye mkpụrụ ọka, na aja dị iche iche, na onyinye ihe ọṅụṅụ dịka e sị hazie na ọ ga na-adị kwa ụbọchị. ");
INSERT INTO ibo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Unu ga-enye onyinye ndị a, tinyere onyinye a na-enye Onyenwe anyị nʼụbọchị izuike, na tinyere onyinye ndị ọzọ unu na-enye na ihe ndị ọzọ unu kwere na nkwa, na onyinye afọ ofufu niile unu na-enye Onyenwe anyị.) ");
INSERT INTO ibo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Ya mere, malite nʼụbọchị nke iri na ise nke ọnwa asaa, mgbe unu webatasịrị ihe ubi unu, meerenụ Onyenwe anyị mmemme ụbọchị asaa, ụbọchị nke mbụ, na ụbọchị nke asatọ ga-abụ ụbọchị izuike. ");
INSERT INTO ibo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Nʼụbọchị nke mbụ, unu ga-ewere ụfọdụ mkpụrụ osisi dị mma nke si nʼosisi unu na-amị mkpụrụ, gbutekwa igu nkwụ, na alaka osisi nwere ahịhịa ndụ, na osisi pọpla, jiri ha mee mmemme obi ụtọ nʼihu Onyenwe anyị Chineke unu ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mmemme ụbọchị asaa a ga-adị nye Onyenwe anyị nʼafọ niile, site nʼọgbọ ruo nʼọgbọ unu niile. Ọ bụkwa nʼọnwa nke asaa ka unu ga-eme mmemme a. ");
INSERT INTO ibo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Nʼoge mmemme a, ụmụ Izrel niile ga-ebi nʼụlọ e ji alaka osisi na ahịhịa wuo ụbọchị asaa. Ụmụ afọ Izrel niile ga-ebi nʼụlọ dị otu a. ");
INSERT INTO ibo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nke a ga-echetara ọgbọ ụmụ Izrel niile na mgbe m kpọpụtara unu site nʼala Ijipt, unu biri nʼụlọ e ji osisi na ahịhịa wuo nʼọzara. Abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mosis gwara ụmụ Izrel ihe gbasara mmemme niile a kara aka nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Nye ndị Izrel niile iwu ka ha wetara gị mmanụ oliv asụrụ asụ, nke a na-agwaghị ihe, maka itinye nʼiheọkụ ime ka ọkụ oriọna na-enwu mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Na mpụta nke akwa mgbochi nke kpuchiri igbe Ihe Ama ahụ, nʼime ụlọ nzute, Erọn ga-amụnye oriọna ndị ahụ nʼihu Onyenwe anyị mgbe niile, site nʼuhuruchi ruo nʼụtụtụ. Nke a bụ ụkpụrụ ga-adịgide nye ọgbọ niile dị nʼihu. ");
INSERT INTO ibo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ihe ọkụ ọlaedo a nụchara anụcha ndị ahụ dọọ nʼelu ihe ịdọkwasị oriọna, nʼihu Onyenwe anyị ga na-enwu ọkụ mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Were ọka a kwọrọ nke ọma mee ogbe achịcha iri na abụọ. Jiri ihe ruru iko ọka asatọ mee otu ogbe achịcha ọbụla. ");
INSERT INTO ibo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Doo achịcha ndị a nʼahịrị abụọ nʼelu tebul ahụ e ji ọlaedo a nụchara anụcha kpụọ, nke dị nʼihu Onyenwe anyị. Ogbe achịcha isii ga-adị nʼotu ahịrị. ");
INSERT INTO ibo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nʼogologo ahịrị ọbụla tinye insensi a na-agwaghị ihe, ka ọ bụrụ ihe nọchiri achịcha ndị a dịka onyinye nsure ọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","A ga-edo achịcha ndị a nʼihu Onyenwe anyị oge niile, ụbọchị izuike niile, nʼọnọdụ ụmụ Izrel, dịka ọgbụgba ndụ ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ọ dịrị Erọn na ụmụ ya ndị ikom, bụ ndị ga-eri ya nʼime nʼebe nsọ ahụ, nʼihi na ọ bụ oke dịkarịsịrị nsọ, site nʼoke ha mgbe niile, nke sitere nʼonyinye nsure ọkụ e chere nye Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Otu nwokorobịa, nke nna ya bụ onye Ijipt ma nne ya bụ onye Izrel, sitere nʼetiti ụmụ Izrel pụta. O ruo na nwoke a nne ya bụ onye Izrel na otu nʼime ndị ikom Izrel malitere ịlụ ọgụ. ");
INSERT INTO ibo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mgbe ha na-alụ ọgụ ahụ nwoke ahụ nne ya bụ onye Izrel kwuluru Aha ahụ kọchaa ya. Nʼihi ya, a kpọrọ ya ikpe nʼihu Mosis. (Aha nne ya bụ Shelomit, nwa Dibri, onye ebo Dan.) ");
INSERT INTO ibo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ha tinyere nwoke ahụ nʼụlọ mkpọrọ na-eche ka ha nụ okwu Onyenwe anyị, ịmata ihe ha ga-eme ya. ");
INSERT INTO ibo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Mgbe ahụ, Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kpụrụ onye nkwulu ahụ gaa nʼazụ obodo. Ndị niile nụrụ okwu ahụ o kwuru ga-ebikwasị ya aka ha nʼisi. Mgbe ahụ, ọgbakọ Izrel niile ga-eji nkume tugbuo ya. ");
INSERT INTO ibo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Gwa ụmụ Izrel okwu sị ha, ‘Onye ọbụla kọchara Chineke ya ga-ebu mmehie ya nʼisi ya. ");
INSERT INTO ibo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Onye ọbụla kwuluru aha Onyenwe anyị ka a ga-egbu. Mmadụ niile ga-agbakọ jiri nkume tugbuo onye ahụ. Onye ọbụla kwuluru Aha ahụ, maọbụ ọbịa, maọbụ nwa afọ ala, ka a ga-egbu. ");
INSERT INTO ibo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Onye ọbụla gburu mmadụ ka a ga-egbu. ");
INSERT INTO ibo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Onye gburu anụ ụlọ na-abụghị nke ya, ga-akwụghachi ụgwọ ya. Ndụ ga-alara ndụ. ");
INSERT INTO ibo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Onye ọbụla merụrụ mmadụ ibe ya ahụ, a ga-emerụkwa onye ahụ ahụ nʼebe o merụrụ ibe ya ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Onye tijiri mmadụ ọkpụkpụ, a ga-etiji ọkpụkpụ nke ya. Anya ga-alara anya, eze ga-alakwara eze. Otu e si merụọ mmadụ ahụ, ka a ga-esi merụọkwa onye merụrụ ya ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Onye ọbụla gburu anụ ụlọ onye ọzọ, ga-akwụ ụgwọ ya. Ma a ga-egbu onye ọbụla gburu mmadụ. ");
INSERT INTO ibo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Unu ga-enwe otu iwu nke ga-adị nye ndị amụrụ nʼala, dịkwara ndị ọbịa niile. Abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mgbe ahụ, Mosis gwara ndị Izrel okwu, nʼihi ya ha dọkpụụrụ onye nkwulu ahụ pụọ nʼazụ obodo, jiri nkume tugbuo ya nʼebe ahụ, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Onyenwe anyị gwara Mosis okwu nʼugwu Saịnaị sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Gwa ụmụ Izrel sị ha, ‘Mgbe unu batara nʼala ahụ m ga-enye unu, unu ga-eme ka ala ahụ nwee afọ izuike nke ya nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Afọ isii ka unu ga-akụ ihe nʼubi, afọ isii ka unu ga-ewe ihe ubi, kwachaakwa alaka osisi vaịnị unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma mgbe o ruru afọ nke asaa, unu ga-ahapụ ala ubi unu ka o zuo ike, afọ izuike nye Onyenwe anyị. Unu akụla ihe ọbụla nʼubi unu maọbụ kwachaa osisi vaịnị unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Unu agaghị ewe ihe ubi ọbụla ga-epupụtara onwe ha nʼoge a, maọbụ tụtụọ mkpụrụ osisi vaịnị ndị ga-ada ada. Nʼihi na afọ ahụ bụ afọ ozuzu ike dịrị ala ubi niile. ");
INSERT INTO ibo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ihe ubi puputara nʼala ahụ niile nʼafọ izuike ahụ bụ nri dịrị unu onwe unu, na ndị odibo nwoke na nwanyị unu niile, na onye i goro ọrụ, na onye ọbịa bi nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ihe ubi ahụ dịkwara anụ ụlọ gị, na anụ ọhịa bi nʼala gị. Ihe ọbụla puputara nʼala bụ ihe unu ga-eri. ");
INSERT INTO ibo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Gụpụta afọ izuike asaa, afọ asaa, ụzọ asaa. Ngụkọ afọ izuike ndị a niile ga-enye iri afọ anọ na itoolu. ");
INSERT INTO ibo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Nʼụbọchị nke iri nke ọnwa asaa, zipụ onye ga-egbu opi ike, ya bụ, nʼụbọchị mkpuchi mmehie, a ga-egbu opi ike nʼala Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Doonụ afọ nke iri ise ahụ nsọ, kwusaakwa inwere onwe nye mmadụ niile nʼala ahụ niile. Afọ ahụ ga-abụ afọ inwere onwe nye unu. Onye ọbụla nʼime unu ga-alaghachi nʼihe onwunwe nke ezinaụlọ ya, onye ọbụla kwa ga-alaghachi nʼagbụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Afọ nke iri ise bụ afọ inwere onwe nye unu. A gaghị akụ ihe ọbụla nʼubi, a gakwaghị ewe ihe ubi ọbụla puputara nʼonwe ya, maọbụ mkpụrụ osisi vaịnị mịrị nʼonwe ya. ");
INSERT INTO ibo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ọ bụ afọ inwere onwe, bụrụkwa afọ dị nsọ nye unu, nke onye ọbụla ga-eri naanị ihe e wetara nʼubi. ");
INSERT INTO ibo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Onye ọbụla ga-alaghachi nʼihe onwunwe nke ya, nʼafọ inwere onwe a. ");
INSERT INTO ibo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Ọ bụrụ na i resiri onye agbataobi gị ala, maọbụ na o nwere nke ọ zụrụ site nʼaka gị, unu aghọgbula ibe unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ị ga-azụrụ ala site nʼaka onye agbataobi dịka ọnụọgụgụ afọ si dị site nʼafọ inwere onwe. Ha ga-eresi gị ya dịka ọnụọgụgụ afọ ole fọdụrụ maka ịkọ ihe nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ọ bụrụ na a zụrụ ala ahụ nso nso mmemme iri afọ ise a, ọnụahịa ala ahụ ga-adị ala, ọ bụrụkwanụ na ọ dị anya site na mmemme ahụ, ọnụahịa ya ga-adị elu, nʼihi na ụgwọ onye ahụ na-akwụ bụ ụgwọ ugboro ole ọ ga-akụ ihe nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Unu emegbula ibe unu kama tụọnụ egwu Chineke unu. Abụ m Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Gbasoonụ ụkpụrụ m, ma lezie anya imezu ihe m nyere nʼiwu, ka unu nwee ike ibi obi udo nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Mgbe ahụ, ala ga-amị mkpụrụ ya, unu ga-eriju afọ, birikwa nʼala ahụ nʼudo. ");
INSERT INTO ibo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Unu nwere ike jụọ ajụjụ sị, “Gịnị ka anyị ga-eri nʼafọ nke asaa ahụ ebe ọ bụ na anyị agaghị akụ ihe ọbụla, maọbụ wee ihe ubi ọbụla nʼafọ ahụ?” ");
INSERT INTO ibo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Aga m ezitere unu ngọzị dị ukwuu nʼafọ nke isii, nke ga-eme ka ala mee ihe omume nke ga-ezuru unu afọ atọ. ");
INSERT INTO ibo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mgbe unu ga-akụ ihe ubi nʼafọ nke asatọ unu ga na-eri site nʼowuwe ihe ubi ochie unu tutu ruo nʼafọ nke itoolu mgbe unu ga-ewebata ihe ubi ọhụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Chetanụ na ala bụ nke m, nʼihi nke a, o kwesighị ka unu ree ala ọbụla kpamkpam. Unu bụ naanị ndị ọbịa na ndị nlekọta nye m. ");
INSERT INTO ibo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nʼala obibi unu niile, unu ga-enye ohere maka mgbapụta ala erere ere. ");
INSERT INTO ibo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Ọ bụrụ na otu onye nʼime unu aghọọ onye ogbenye si otu a ree ala ya, nwanna ya dị ya nso ga-abịa gbapụta ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ọ bụrụ na-enweghị onye ga-agbapụta ala ahụ nye ha, ma ha mesịa ghọọ ndị bara ụba nwekwa ihe ga-ezu ịgbapụta ala ahụ nʼonwe ha. ");
INSERT INTO ibo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","A ga-agụ afọ ole gara site na mgbe o rere ala ahụ, nyeghachi ya ego ole o kwesiri inweta. Onye rere ala ga-alaghachikwa nʼala ya. ");
INSERT INTO ibo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ọ bụrụ na onyenwe ya enweghị ike ịchọta ego ọ ga-eji gbara ya, ala ahụ ga-adị nʼaka onye ahụ zụrụ ya tutu ruo nʼafọ inwere onwe. Mgbe ahụ ọ ga-ewerekwa ala ahụ nyeghachi ya onye resiri ya. ");
INSERT INTO ibo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Onye ọbụla rere ụlọ obibi dị nʼobodo e ji mgbidi gbaa gburugburu nwere ikike mgbapụta ya naanị mgbe otu afọ zuru site na mgbe e rere ya. Nʼoge ahụ ka onye rere ya nwere ike ịgbaghachi ya. ");
INSERT INTO ibo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ọ bụrụ na a gbapụtaghị ya tupu otu afọ agafee, ụlọ ahụ dị nʼime obodo nwere mgbidi ga-abụ nke onye ahụ zụrụ ya mgbe niile, bụrụkwa nke ụmụ ụmụ ya. A gaghị enyeghachikwa ya mgbe afọ inwere onwe ruru. ");
INSERT INTO ibo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ma ụlọ ndị dị nʼobodo nta na-enweghị mgbidi a ga-agụ ha dịka ihe dị nʼọhịa. E nwere ike ịgbapụta ha, ha bụkwa nke a ga-eweghachite mgbe afọ inwere onwe ruru. ");
INSERT INTO ibo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Ma banyere obodo niile nke ndị Livayị dị iche iche. Ha nwere ikike ịgbapụta ụlọ ha dị nʼime nketa ha mgbe ọbụla. ");
INSERT INTO ibo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ihe onwunwe ndị Livayị bụ nke e nwere ike ịgbapụta, bụ ndị a, ụlọ niile e rere nke dị nʼobodo ha nwere. Ọ ga-abụ nʼafọ inwere onwe ka aga enwetaghachi ha, nʼihi na ụlọ ndị ahụ dị nʼobodo ndị Livayị bụ naanị oke ha nwere nʼetiti ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ma a gaghị ere ala ebe ịta nri nke anụ ụlọ gbara obodo ha gburugburu ere, nʼihi ọ bụ ihe ha nwee nʼọha ruo ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Ọ bụrụ na nwanne gị adaa ogbenye ruo na o nweghị ike inyere onwe ya aka, ọ dị gị nʼaka inyere ya aka, kpọbata ya ka ọ bịa biri nʼụlọ gị dịka ị ga-esi kpọbata onye ọbịa. Nʼụzọ dị otu a, ọ ga-anọgide biri nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tụọ egwu Chineke, kwerekwa ka nwanna gị soro gị biri nʼala ahụ. A nakwala ụma maọbụ ọmụrụnwa ọbụla. ");
INSERT INTO ibo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ị gaghị ana ọmụrụnwa nʼego i gbazinyere ha, maọbụ rie uru site na nri i resiri ha. ");
INSERT INTO ibo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mụ onwe m bụ Onyenwe anyị Chineke unu, onye kpọpụtara unu site nʼala Ijipt, inye unu ala Kenan, na ị bụ Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Ọ bụrụ na onye Izrel ọbụla adaa ogbenye, resi gị onwe ya, emela ka o jere gị ozi dịka onye ohu. ");
INSERT INTO ibo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kama ị ga-emeso ya mmeso dịka ị ga-esi meso onye ọrụ e goro ego, maọbụ dịka onye ọbịa nọ nʼetiti unu. Ọ ga-ejere gị ozi tutu ruo afọ inwere onwe. ");
INSERT INTO ibo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Nʼafọ ahụ, ị ga-ahapụ ha na ụmụ ha ka ha laghachikwuru ndị ikwu ha, si otu a nwetaghachi ala ubi dị nʼezinaụlọ ha. ");
INSERT INTO ibo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Nʼihi na a kpọpụtara m ndị Izrel site nʼala Ijipt ka ha bụrụ ndị na-ejere m ozi. Ya mere, a gaghị ere ha mgbe ọbụla dịka ohu. ");
INSERT INTO ibo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","A gakwaghị emegbu ha nʼụzọ dị njọ. Tụọnụ egwu Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Ma unu nwere ike gbara ndị ohu nwoke maọbụ nwanyị site nʼetiti ndị mba ọzọ niile bi nʼakụkụ unu. Unu nwere ike site nʼebe ahụ zụta ndị ohu. ");
INSERT INTO ibo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Unu nwere ike ịzụ ndị ohu site nʼetiti ndị mbịarambịa bi nʼetiti unu, maọbụ site nʼetiti ndị agbụrụ ha a mụrụ nʼala Izrel. Ndị dị otu a ga-abụkwa ihe onwunwe unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Unu nwere ike kenye ha ụmụ unu dịka ihe nketa, ma mee ha ndị ohu unu ụbọchị ndụ ha niile. Ma unu agaghị eji aka ike chịa onye Izrel ibe unu. ");
INSERT INTO ibo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Ọ bụrụ na onye ọbịa bi nʼetiti unu aghọọ ọgaranya, ma otu nʼime ụmụnna unu adaa ogbenye were onwe ya resi onye ọbịa ahụ bi nʼetiti unu, maọbụ were onwe ya resi nwanna ndị ikwu onye ọbịa ahụ, ");
INSERT INTO ibo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ha nwere ikike ịgbapụta ya mgbe ha resiri onwe ha. Otu nʼime ụmụnna ya nwere ike gbapụta ha. ");
INSERT INTO ibo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Nwanne nne ya, maọbụ nwanne nna ya, maọbụ nwanna nʼikwu ha ọbụla nwere ike ịgbapụta ya. Ọ nwekwara ike ịgbapụta onwe ya ma ọ bụrụ na ọ kpata ego. ");
INSERT INTO ibo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ya na onye ahụ o resiri onwe ya ga-agụ afọ ole ọ bụ site na mgbe o rere onwe ya ruo nʼafọ inwere onwe. Ego a ga-akwụ nʼihi ịgbapụta ya ga-abụ ego ọ ga-efu ịkwụ ohu ọzọ ụgwọ ịrụ ọrụ ọnụọgụgụ afọ ndị ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ọ bụrụ nʼọtụtụ afọ fọdụrụ, ọ ga-esite nʼọnụ ego e rere ha kwụọ nke dị ukwu dịka ego mgbapụta ha. Naanị ihe ntakịrị ga-apụ nʼime ego ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ọ bụrụ naanị afọ ole na ole fọdụrụ tupu afọ inwere onwe eruo, ọ ga-agụkọ ihe ego ahụ pụtara, kwụọ ya maka ịgbara onwe ya dịka o kwesiri. ");
INSERT INTO ibo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A ga-emeso ha dịka ndị ọrụ e goro ego kwa afọ, ma ị ga-ahụ na onye ha nọ nʼokpuru ya agaghị eji aka ike chịa ha. ");
INSERT INTO ibo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Ma ọ bụrụ na e nweghị ike gbapụta ya site nʼụzọ ndị a niile, ya na ụmụ ya ga-enwere onwe ha mgbe afọ inwere onwe ahụ zuru. ");
INSERT INTO ibo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nʼihi na mụ ka ụmụ Izrel bụ ndị ohu nye. Ha bụ ndị ohu m, ndị m kpọpụtara site nʼala Ijipt. Mụ onwe m bụ Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Unu emerela onwe unu arụsị ọbụla, maọbụ guzobe oyiyi apịrị apị, maọbụ ogidi nkume ọbụla ọtọ, nye onwe unu. Unu edokwala nkume a pịrị apị ọbụla nʼala unu maka ịkpọ isiala nye ya. Abụ m Onyenwe anyị Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Debenụ iwu niile m nyere maka ụbọchị Izuike m, sọpụkwaranụ ebe nsọ m. Abụ m Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Ọ bụrụ na unu ejegharịa nʼụkpụrụ m, lezie anya debe iwu m niile, ");
INSERT INTO ibo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","aga m enye unu mmiri ozuzo nʼoge ya, nke ga-eme ka ala unu mịa ọtụtụ ihe ubi. Osisi unu niile ga-ejupụtakwa na mkpụrụ mgbe niile. ");
INSERT INTO ibo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Unu ga-anọgide na-azọcha ọka tutu ruo mgbe unu ga-aghọ mkpụrụ vaịnị unu, owuwe ihe ubi mkpụrụ vaịnị unu ga-adịgidekwa ruo oge ịkụ mkpụrụ nʼubi. Nʼụzọ dị otu a, unu ga-enwe nri ga-ezuru unu, unu ga-ebikwa nʼudo nʼala unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Aga m eme ka udo dịrị nʼala ahụ, unu ga-edina ala, ọ dịghịkwa onye ga-eme ka unu tụọ egwu ọbụla. Aga m ewezuga site nʼetiti unu ajọ anụ ọhịa, mma agha agaghị esitekwa nʼala unu bi nʼime ya gafee. ");
INSERT INTO ibo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Unu ga-achụ ndị iro unu ọsọ. Ha ga-ada nʼihu unu site na mma agha. ");
INSERT INTO ibo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Mmadụ ise nʼime unu ga-achụ narị mmadụ ọsọ. Narị mmadụ nʼetiti unu ga-achụkwa iri puku mmadụ ọsọ. Ndị iro unu ga-ada nʼihu unu site na mma agha. ");
INSERT INTO ibo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Aga m eji ihuọma leta unu, mee ka unu mụbaa ma jupụta nʼọnụọgụgụ. Aga m eme ka ọgbụgba ndụ m nʼebe unu nọ dịgide. ");
INSERT INTO ibo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Unu ga-enwebiga mkpụrụ ubi oke ruo na mgbe unu ka nọ na-eri ndị ochie unu ga-ewezuga ha nʼakụkụ maka inye ohere iwebata ihe ubi ọhụrụ. ");
INSERT INTO ibo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Aga m eme ka ebe obibi m dịrị nʼetiti unu. Agaghị m asọ unu oyi. ");
INSERT INTO ibo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Aga m ejegharị nʼetiti unu, bụrụ Chineke unu, unu ga-abụkwa ndị m. ");
INSERT INTO ibo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nʼihi na abụ m Onyenwe anyị Chineke unu onye kpọpụtara unu site nʼala Ijipt, ka unu ghara ịbụ ndị ohu ọzọ. Etijiela m mkpọrọ igwe nke ịbụ ohu unu, mee ka unu bụrụ ndị ji nganga ejegharị. ");
INSERT INTO ibo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Ma ọ bụrụ na unu ajụ ige m ntị, jụkwa imezu ihe ndị a m nyere unu iwu ya, ");
INSERT INTO ibo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ọ bụrụ na unu ajụ ịgbaso ụkpụrụ m, sọọ iwu m ndị a oyi, si otu a mebie ọgbụgba ndụ m, ");
INSERT INTO ibo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","mgbe ahụ, aga m eme ka oke ụjọ, na ọrịa na-ebibi ebibi, na ahụ ọkụ, bịakwasị unu. Ọrịa ndị a ga-eme ka anya unu daa mba, ọ ga-eripịakwa anụ ahụ unu. Unu ga-akụ mkpụrụ ubi nʼubi unu ma ndị iro unu ga-eri ha. ");
INSERT INTO ibo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Aga m eguzo megide unu nʼoge ibu agha, mee ka ndị iro unu merie unu nʼagha. Unu ga-agba ọsọ mgbe onye ọbụla na-adịghị achụ unu ọsọ. Ndị kpọrọ unu asị ga-achịkwa unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Ọ bụrụ na unu anọgidesie ike ju ige m ntị nʼagbanyeghị ihe ndị a, aga m enye unu ntaramahụhụ dị okpukpu asaa nʼihi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Aga m etiji ịnya isi nganga unu, mee ka mbara eluigwe dịịrị unu dịka igwe, elu ala unu na-azọkwasị ụkwụ ga-adịkwa dịka bronz. ");
INSERT INTO ibo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Unu ga-adọgbu onwe unu nʼọrụ nʼefu, nʼihi na ala unu agaghị emepụtara unu ihe omume ya, osisi nke ala unu agaghị amịkwa mkpụrụ ya. ");
INSERT INTO ibo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Ọ bụrụkwa na mgbe nke a mesịrị, unu anọgidekwa jụ ime ihe m nyere nʼiwu, aga m eme ka ntaramahụhụ unu dịrị ukwuu, ugboro asaa ọzọ, nʼihi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Aga m ezite anụ ọhịa megide unu. Ha ga-adọgbu ụmụ unu, bibie anụ ụlọ unu, meekwa ka unu dị nta nʼọnụọgụgụ, ruo na ndị a ga-ahụ nʼokporoụzọ unu ga-adị ole na ole. ");
INSERT INTO ibo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Ọ bụrụkwa na unu anọgide jụ ịdọ aka na ntị m, chie ntị nọgide na-ebu agha nnupu isi unu megide m, ");
INSERT INTO ibo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mụ onwe m ga-ebu agha megide unu. Aga m eti unu ugbo ihe otiti asaa, nʼihi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Aga m ewebata mma agha nʼebe unu nọ, ịbọ ọbọ nʼihi ọgbụgba ndụ m unu mebiri. Mgbe unu ga-agba ọsọ gbaba nʼobodo unu, aga m ezite ihe mbibi ga-ebibi unu nʼebe ahụ. Aga m enyefekwa unu nʼaka ndị iro unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Aga m eme ka unu hapụ inwe ihe oriri ga-ezuru unu. Otu ite nri naanị ka ndị inyom iri ga-eji sie nri ha nwere. Ha ga-eji ihe ọtụtụ tụọ ya mgbe ha na-eke ya. Unu ga-eri ya, ma afọ agaghị eju unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Ọ bụrụkwa na unu agaa nʼihu jụ ige m ntị nʼagbanyeghị ihe ndị a, nọgide na-emegide m, ");
INSERT INTO ibo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mgbe ahụ, aga m egosi unu oke iwe m, nye unu ntaramahụhụ dị okpukpu asaa nʼihi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Unu ga-eri anụ ụmụ unu ndị ikom, na anụ ụmụ unu ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Aga m ebibikwa ụlọ arụsị unu niile dị nʼelu ugwu, gbutuo ebe ịchụ aja niile unu na-esure ihe nsure ọkụ na-esi isi. Aga m atụkọta ozu unu nʼelu arụsị unu na-enweghị ume ndụ, ka unu bụrụ ihe m na-asọ oyi. ");
INSERT INTO ibo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Aga m eme ka obodo unu niile tọgbọrọ nʼefu, kụdasịakwa ebe nsọ unu niile. Agaghị m anabatakwa isisi ụtọ nke aja unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Aga m eme ka ala unu tọgbọrọ nʼefu, mee ka ọnọdụ ịdị ala unu bụrụ ihe ga-eju ndị iro unu ga-ebi nʼime ya anya. ");
INSERT INTO ibo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Aga m achụsa unu na mba niile, mịpụta mma agha m jiri ya chụso unu ọsọ. Ala unu ga-atọgbọrọ nʼefu, a ga-etikpọkwa obodo unu niile. ");
INSERT INTO ibo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Mgbe ahụ, ala ahụ ga-ezu ike, ogologo oge ndị ahụ niile ọ ga-atọgbọrọ nʼefu. Mgbe unu ga-anọ dịka ndị ohu nʼala ndị iro unu. Ala ahụ ga-ezu ike, imejupụta afọ izuike ya niile. ");
INSERT INTO ibo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ogologo oge niile ala ahụ tọgbọrọ nʼefu, ala ahụ ga-ezu ike, ụdị izuike ọ na-enweghị nʼafọ izuike ndị ahụ unu bi nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Ma ndị ahụ fọdụrụ ndụ nʼime unu, aga m etinye ịda mba nʼobi ha nʼala ndị iro ha. Mkpọtụ ahịhịa nke ifufe na-ebugharị ga-eme ka ha gbapụ ọsọ. Ha ga-agba ọsọ dịka ndị si nʼihu mma agha na-agba ọsọ. Ha ga-ada mgbe onye ọbụla na-adịghị achụ ha ọsọ. ");
INSERT INTO ibo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Nʼezie, ha ga-agba ọsọ mgbe onye ọbụla na-adịghị achụ ha ọsọ. Ha ga-adagide ibe ha mgbe ha na-agba ọsọ a, dịka ndị si nʼebe a na-alụ agha na-agbapụ ọsọ. Unu agaghị enwe ike iguzo nʼihu ndị iro unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Unu ga-ala nʼiyi nʼetiti ndị mba ọzọ, ala ndị iro unu ga-eri unu. ");
INSERT INTO ibo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ndị ahụ a hapụrụ na ndụ nʼetiti unu ga-ata ahụhụ nʼala ndị iro ha nʼihi mmehie ha. Ha ga-atakwa ahụhụ nʼihi mmehie nke nna nna ha. ");
INSERT INTO ibo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Ma ọ bụrụ na ha ekwupụta mmehie ha niile, na mmehie niile nke ndị nna nna na ha na ha mehiere megide m, mmehie ekwesighị ntụkwasị obi ha, na mmehie nnupu isi ha, nke ha mehiere megide m, ");
INSERT INTO ibo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","nke mere ka m doo onwe m imegide ha, na izipụ ha gaa nʼala ndị iro ha, ọ bụrụ na ha eweda onwe ha ala nabata ntaramahụhụ m nyere ha nʼihi mmehie ha ");
INSERT INTO ibo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","aga m echeta ọgbụgba ndụ mụ na Jekọb gbara, ọgbụgba ndụ mụ na Aịzik gbara, na ọgbụgba ndụ mụ na Ebraham gbara. Aga m echeta ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ma ala ahụ aghaghị ịtọgbọrọ nʼefu. Ọ ghakwaghị inwezu izuike ruuru ya, oge ndị ahụ ọ tọgbọrọ nʼefu, mgbe ha na-ebighị nʼime ya. Ha ga-anata ntaramahụhụ ruuru ha nʼihi na ha jụrụ iwu m, sọọkwa ụkpụrụ m oyi. ");
INSERT INTO ibo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ma ewezugakwa ihe ndị a niile, agaghị m ajụ ha, maọbụ sọọ ha oyi, ruo na ibibi ha kpamkpam mgbe ahụ ha nọ nʼala ndị iro ha. Agakwaghị m emebi ọgbụgba ndụ mụ na ha gbara nʼihi na abụ m Onyenwe anyị Chineke ha. ");
INSERT INTO ibo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kama nʼihi ha, aga m echeta ọgbụgba ndụ ahụ mụ na nna nna ha gbara, ịbụ Chineke ha, ndị ahụ m kpọpụtara site nʼala Ijipt nʼihu mba niile. Abụ m Onyenwe anyị.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ndị a bụ iwu, na ụkpụrụ na ndụmọdụ Onyenwe anyị guzobere nʼugwu Saịnaị, nʼetiti ya onwe ya, na ụmụ Izrel, site nʼaka Mosis. ");
INSERT INTO ibo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Gwa ụmụ Izrel sị ha, ‘Ọ bụrụ na mmadụ e kwee nkwa pụrụ iche iji mmadụ nye Onyenwe anyị onyinye, ihe ndị a ka ọ ga-eji gbara onye ahụ: ");
INSERT INTO ibo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","nʼisi nwoke ọbụla gbara iri afọ abụọ ruo iri afọ isii, ọ ga-akwụ iri ọlaọcha shekel ise, dịka ihe ọtụtụ ebe nsọ si dị. ");
INSERT INTO ibo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nʼisi nwanyị ọbụla gbara iri afọ abụọ ruo iri afọ isii ọ ga-enye iri ọlaọcha shekel atọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Nʼisi nwoke gbara afọ ise ruo iri afọ abụọ, ọ ga-enye iri ọlaọcha shekel abụọ. Nʼisi nwanyị gbara afọ ise ruo iri afọ abụọ, ọ ga-enye ọlaọcha shekel iri. ");
INSERT INTO ibo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A ga-akwụrụ nwantakịrị nwoke gbara site otu ọnwa ruo afọ ise, ọlaọcha shekel ise, kwụọra nwantakịrị nwanyị gbara otu ọnwa ruo afọ ise ọlaọcha shekel atọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Nʼisi nwoke gafere iri afọ isi, a ga-enye ọlaọcha shekel iri na ise. Nʼisi nwanyị gafere iri afọ isi a ga-enye ọlaọcha shekel iri. ");
INSERT INTO ibo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ọ bụrụ na e nwee onye ogbenye na-enweghị ego ọ ga-eji kwụọ ụgwọ ndị a, a ga-akpọtara ya onye nchụaja, onye ga-ekwubi ihe onye ahụ kwere nkwa ga-akwụ dịka ego o nwere ruru. ");
INSERT INTO ibo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Ọ bụrụ anụ ụlọ dị mma inye Onyenwe anyị dịka onyinye ka e kwere nkwa inye, anụ ụlọ e nyere Onyenwe anyị ga-aghọ ihe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Onye kwere nkwa inye ya enweghị ike iji anụ ụlọ nke ahụ ya na-ezughị oke gbanwere anụ ụlọ ahụ na-enweghị ntụpọ. O nwekwaghị ike iji anụ ụlọ ahụ na-enweghị ntụpọ gbanwere nke anụ ahụ ya na-ezughị oke. Ọ bụrụ na o mee otu a, anụ ụlọ nke mbụ, na nke abụọ, ga-abụ ihe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ọ bụrụ na anụ ụlọ o ji kwee nkwa bụ anụ ụlọ rụrụ arụ, ụdị anụ ụlọ ahụ a jụrụ ịnabata dịka onyinye maka iji ya chụọ aja nye Onyenwe anyị, a ga-akpụtara onye nchụaja anụ ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ọ bụ ya ka ọ dịrị ikpebi ma anụ ụlọ ahụ ọ dị mma, ma ọ jọrọ njọ. Ọnụ ego ọbụla onye nchụaja kpebiri, ka onye wetara anụ ụlọ ahụ ga-akwụ. ");
INSERT INTO ibo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ọ bụrụ na onye nwe anụ ụlọ ahụ achọọ ịgbara ya, ọ ga-akwụ ụgwọ anụ ụlọ ahụ, tụkwasịkwa nʼelu ya otu ụzọ nʼime ụzọ ise nke ọnụahịa anụ ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Ọ bụrụ na mmadụ enye ụlọ ya, dịka ihe ga-adị nsọ nye Onyenwe anyị, onye nchụaja ga-ekpebi maọbụ ụlọ dị mma, ma ọ bụkwanụ ụlọ jọrọ njọ. Ọ ga-ekwukwa ihe bụ ọnụahịa ụlọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ọ bụrụ na onye ahụ nke na-edo ụlọ ya nsọ achọọ ịgbara ya, ọ ga-akwụ ọnụahịa ụlọ ahụ, tụkwasịkwa nʼelu ya otu ụzọ nʼime ụzọ ise nke ọnụahịa ụlọ ahụ. Emesịa, ụlọ ahụ ga-abụkwa nke ya. ");
INSERT INTO ibo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Ọ bụrụ na mmadụ ewere mpaghara ala ubi ezinaụlọ ya nye Onyenwe anyị ka ihe ido nsọ, ihe a ga-eji mata ọnụahịa ala ahụ ga-abụ ụdị ihe ubi e nwere ike ịkụ nʼime ya. Ọnụahịa ala ubi e nwere ike ịkụnye ọka balị ruru otu ihe ọtụtụ homa, ga-abụ iri mkpụrụ ego ọlaọcha shekel ise. ");
INSERT INTO ibo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ọ bụrụ nʼime afọ inwere onwe ka o doro ala ahụ nsọ, agaghị agbanwe ọnụahịa ya. ");
INSERT INTO ibo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ma ọ bụrụ na o doro ala ahụ nsọ mgbe afọ inwe onwe ahụ gafere, onye nchụaja ga-agụkọrọ ya ọnụahịa ya dịka afọ ole ọ fọdụrụ mgbe mmemme afọ inwere onwe ọzọ ga-adị. A ga-ewebilatakwa ihe ọnụahịa ya ruru. ");
INSERT INTO ibo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ọ bụrụ na onye doro ala ahụ nsọ achọọ ịgbara ala ya, ọ ga-akwụ ọnụahịa ahụ onye nchụaja kpebiri, tụkwasị ya ego ruru otu ụzọ nʼime ụzọ ise nke ọnụahịa ala ahụ. Mgbe ahụ ala ahụ ga-abụkwa nke ya. ");
INSERT INTO ibo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ọ bụrụ na ọ gbapụtaghị ala ahụ, maọbụ na o resila ya onye ọzọ, a gaghị agbapụtakwa ala ahụ ọzọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mgbe mmemme afọ inwere onwe ruru, ala ahụ ga-aghọ ala dị nsọ, ala e doro nsọ nye Onyenwe anyị. Ndị nchụaja ga-ewere ya ka ọ bụrụ nke ha. ");
INSERT INTO ibo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Ọ bụrụ na mmadụ e doro Onyenwe anyị ala ubi ọ zụrụ azụ nsọ, nke na-abụghị ala ezinaụlọ ha, ");
INSERT INTO ibo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","onye nchụaja ga-agụ afọ ole ọ fọdụrụ ruo mmemme afọ inwere onwe. Ọ ga-agwa onye ahụ ego ole ọ ga-akwụ nʼihi ya. Ego ọbụla ọ kwụrụ nʼụbọchị ahụ ga-abụ ihe dị nsọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mgbe afọ inwere onwe ahụ zuru, onye nwe ala ahụ, ya bụ onye ahụ e si nʼaka ya zụọ ya, ga-ewerekwa ala ya. ");
INSERT INTO ibo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ọnụahịa ọbụla a ga-ekpebi ga-abụ nʼusoro dịka shekel ebe nsọ si dị. Iri gera abụọ ga-abụ otu shekel. ");
INSERT INTO ibo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘A gaghị edo nwa mbụ anụmanụ mụtara nsọ maọbụ ehi maọbụ atụrụ nʼihi na ha bụ nke Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ọ bụrụ otu nʼime anụ ndị ahụ rụrụ arụ, a ga-agbara ya nʼọnụ ego nke akara bụ ọṅụ ahịa ya, tụkwasịkwa nʼelu ya otu ụzọ nʼime ụzọ ise nke ọnụahịa ya. Ọ bụrụkwanụ na onye nwe anụ ụlọ ahụ achọghị ịgbarakwa ya, a ga-ere ya nʼọnụ ahịa dịka o ruru. ");
INSERT INTO ibo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘A gaghị ere, maọbụ gbara ihe ọbụla mmadụ nwere, nke o doro nsọ nye Onyenwe anyị, maọbụ mmadụ, maọbụ ala ezinaụlọ, maọbụ anụ ụlọ, nʼihi na ihe ọbụla nke e wezugara iche bụ ihe dịkarịsịrị nsọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Mgbapụta ọbụla adịghị nye onye ọbụla e doro nsọ nye mbibi. A ghaghị ime ka ọ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Otu ụzọ nʼime ụzọ iri nke ihe niile si nʼala, maọbụ mkpụrụ ọghịgha nke ubi, maọbụ mkpụrụ nke osisi mịrị, bụ nke Onyenwe anyị. Ha bụ ihe nsọ dịrị Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Onye ọbụla chọrọ ịgbara otu ụzọ nʼime ụzọ iri nke ihe ubi ya aghaghị ịkwụ ọnụahịa ya, tụkwasị ya otu ụzọ nʼime ụzọ ise nke ọnụahịa e kwesiri ire ya. ");
INSERT INTO ibo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Otu ụzọ nʼụzọ iri nke igwe ehi na atụrụ niile, anụ nke iri ọbụla nke na-agabiga nʼokpuru mkpanaka onye ọzụzụ atụrụ mgbe a na-agụ ha ọnụ, ga-abụ ihe dị nsọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","A gaghị ahọ anụ ụlọ a na-enye Onyenwe anyị ahọ, ile ma ha dị mma, maọbụ na ha dị njọ. A gaghị agbanwekwa ha. Ọ bụrụ na a gbanwee ha, ndị e ji gbanwee ha na ndị a na-achọ ịgbanwe ga-aghọ ihe dị nsọ, a gaghị agbarakwa ha.’ ” ");
INSERT INTO ibo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ndị a bụ iwu Onyenwe anyị nyere Mosis nʼugwu Saịnaị ka ọ nye ụmụ Izrel.");
INSERT INTO ibo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Onyenwe anyị gwara Mosis okwu nʼọzara Saịnaị, nʼime ụlọ nzute, nʼụbọchị nke mbụ, nʼọnwa nke abụọ nke afọ abụọ, mgbe ụmụ Izrel pụtachara site nʼobodo Ijipt. Ọ sịrị, ");
INSERT INTO ibo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Gaa gụọ ma chọpụta ọnụọgụgụ ndị ikom niile e nwere nʼetiti ọgbakọ Izrel, dịka ebo ha na agbụrụ ha si dị, na dịka ezinaụlọ ha si dịkwa. Depụta aha nwoke ọbụla nʼotu na otu. ");
INSERT INTO ibo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Gị na Erọn ga-agụkọta ndị ikom Izrel niile gbara iri afọ abụọ maọbụ karịa ọnụ, bụ ndị tozuru ije agha. Unu ga-edo ha nʼusuu, nʼusuu. ");
INSERT INTO ibo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Otu nwoke, site nʼebo Izrel ọbụla, onye bụ onyendu ezinaụlọ, ga-esonyere unu nʼọrụ a. ");
INSERT INTO ibo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Ndị a bụ aha ndị ikom ndị ahụ ga-enyere unu aka. “Site nʼebo Ruben, Elizọ na Shedeua, ");
INSERT INTO ibo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","site nʼebo Simiọn, Shelumiel nwa Zurishadai, ");
INSERT INTO ibo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","site nʼebo Juda, Nashọn nwa Aminadab, ");
INSERT INTO ibo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","site nʼebo Isaka, Netanel nwa Zua, ");
INSERT INTO ibo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","site nʼebo Zebụlọn, Eliab nwa Helọn, ");
INSERT INTO ibo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Site nʼụmụ Josef: site nʼebo Ifrem, Elishama nwa Amihud site nʼebo Manase, Gamaliel nwa Pedazo ");
INSERT INTO ibo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","site nʼebo Benjamin, Abidan nwa Gidiọn ");
INSERT INTO ibo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","site nʼebo Dan, Ahieza nwa Amishadai ");
INSERT INTO ibo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","site nʼebo Asha, Pagịel nwa Okran ");
INSERT INTO ibo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","site nʼebo Gad, Eliasaf nwa Deuel ");
INSERT INTO ibo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","site nʼebo Naftalị, Ahira nwa Enan.” ");
INSERT INTO ibo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ndị a bụ ndị ikom e si nʼọgbakọ ahụ họpụta, ndị bụ ndị ndu ebo dị iche iche nʼIzrel. Ha bụ ndị ndu ebo niile dị nʼIzrel. ");
INSERT INTO ibo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mosis na Erọn nabatara ndị ikom ndị a, bụ ndị e depụtara aha ha. ");
INSERT INTO ibo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Emesịa, ha kpọrọ nzukọ ndị Izrel niile ka ha zukọọ nʼụbọchị mbụ nke ọnwa abụọ. Ndị niile zukọrọ kọwara ikwu ha na ezinaụlọ ha si pụta nʼotu na otu. Ma ndị ikom niile gbara site nʼiri afọ abụọ gbagoo ka e denyere aha ha nʼakwụkwọ nʼotu na otu, ");
INSERT INTO ibo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","dịka Onyenwe anyị si nye Mosis nʼiwu. Otu a kwa ka Mosis si gụọ ha ọnụ nʼọzara Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ụmụ Ruben, bụ ọkpara Izrel: Ndị ikom niile gbara iri afọ abụọ gbagoo; ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ọnụọgụgụ ndị niile si nʼebo Ruben dị iri puku anọ, puku isii na narị ise (46,500). ");
INSERT INTO ibo_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Site nʼụmụ Simiọn, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ọnụọgụgụ ndị niile sị nʼebo Simiọn dị iri puku ise, puku itoolu na narị atọ (59,300). ");
INSERT INTO ibo_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Site nʼụmụ Gad, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ọnụọgụgụ ndị niile sị nʼebo Gad dị iri puku anọ, puku ise na narị isii na iri ise (45,650). ");
INSERT INTO ibo_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Site nʼụmụ Juda, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ọnụọgụgụ ndị niile sị nʼebo Juda dị iri puku asaa, puku anọ na narị isii (74,600). ");
INSERT INTO ibo_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Site nʼụmụ Isaka, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ọnụọgụgụ ndị niile sị nʼebo Isaka dị iri puku ise, puku anọ na narị anọ (54,400). ");
INSERT INTO ibo_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Site nʼụmụ Zebụlọn, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ọnụọgụgụ ndị niile sị nʼebo Zebụlọn dị iri puku ise, puku asaa na narị anọ (57,400). ");
INSERT INTO ibo_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Site nʼụmụ Josef, ya bụ ụmụ Ifrem, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ọnụọgụgụ ndị niile sị nʼebo Ifrem dị iri puku anọ na narị ise (40,500). ");
INSERT INTO ibo_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Site nʼụmụ Manase, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ọnụọgụgụ ndị niile sị nʼebo Manase dị iri puku atọ, puku abụọ na narị abụọ (32,200). ");
INSERT INTO ibo_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Site nʼụmụ Benjamin, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ọnụọgụgụ ndị niile sị nʼebo Benjamin dị iri puku atọ, puku ise na narị anọ (35,400). ");
INSERT INTO ibo_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Site nʼụmụ Dan, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ọnụọgụgụ ndị niile sị nʼebo Dan dị iri puku isii, puku abụọ na narị asaa (62,700). ");
INSERT INTO ibo_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Site nʼụmụ Asha, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ọnụọgụgụ ndị niile sị nʼebo Asha dị iri puku anọ, otu puku na narị ise (41,500). ");
INSERT INTO ibo_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Site nʼụmụ Naftalị, ndị ikom niile gbara iri afọ abụọ gbagoo, ndị tozuru ije agha ka e dere aha ha nʼusoro nʼotu nʼotu dị ka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ọnụọgụgụ ndị niile sị nʼebo Naftalị dị iri puku ise, puku atọ na narị anọ (53,400). ");
INSERT INTO ibo_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ndị a bụ ndị ikom Mosis na Erọn, na ndị ndu Izrel iri na abụọ ndị ahụ gụrụ ọnụ, onye ọbụla nʼime ha nọchitere anya ezinaụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ndị Izrel niile gbara iri afọ abụọ gbagoo, ndị nwere ike ije agha ka a gụrụ ọnụ dịka ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Mgbakọ ọnụọgụgụ ndị a niile dị, narị puku isii, puku atọ, narị ise na iri ise (603,550). ");
INSERT INTO ibo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","A gụnyekọtaghị ọnụọgụgụ ebo nna nna Livayị nʼịgụ ọnụ a, ");
INSERT INTO ibo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","nʼihi na Onyenwe anyị gwara Mosis, sị, ");
INSERT INTO ibo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ị gaghị agụ ndị ebo Livayị ọnụ. Ị gakwaghị agbakọnye ọnụọgụgụ ha nʼọnụọgụgụ ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kama, ị ga-ahọpụta ndị Livayị ka ha bụrụ ndị nlekọta ụlọ nzute Ihe Ama, na ngwongwo niile, na ihe niile dị nye ya. Ọ bụ ha ga-ebu ụlọ nzute ahụ na ngwongwo ya niile: ha ga na-elekọta ihe banyere ya, ọ bụkwa gburugburu ya ka ha ga-ama ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Mgbe ọbụla kwa a ga-ebugharị ya maka njem, ọ bụ ọrụ ha iweda ya. Mgbe ọbụla a ga-eguzo ya ọtọ, ọ bụkwa ọrụ ndị Livayị iguzobe ya ọtọ. Onye ọbụla ọzọ ga-abịa nso ka a ga-egbu. ");
INSERT INTO ibo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ebo Izrel ndị ọzọ ga-enwe ebe dị iche nye onwe ha, ebe ha ga-ewu ụlọ ikwu ha. Ha ga-akwụbakwa ọkọlọtọ nke ha, igosi aha ebo ha. ");
INSERT INTO ibo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ndị Livayị ga-ama ụlọ ikwu ha gburugburu ụlọ nzute Ihe Ama ahụ, ka iwe ọkụ m ghara ịbịakwasị nʼahụ nzukọ ụmụ Izrel. Ọ bụ ọrụ ndị Livayị ilekọta ụlọ nzute Ihe Ama ahụ.” ");
INSERT INTO ibo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ya mere, Izrel mere ihe ndị a niile Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Onyenwe anyị gwara Mosis na Erọn sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ụmụ Izrel ga-ama ụlọ ikwu ha gburugburu ụlọ nzute, nʼebe dịpụturu adịpụ site nʼụlọ nzute ahụ. Onye ọbụla ga-ama ụlọ ikwu ya nʼakụkụ ọkọlọtọ ebo ya, ha na ihe ịrịbama nke ụlọ ha.” ");
INSERT INTO ibo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Nʼakụkụ ọwụwa anyanwụ, usuu ndị agha ebo Juda, ga-ama ụlọ ikwu ha nʼakụkụ ọkọlọtọ ha. Onyendu ha ga-abụ Nashọn nwa Aminadab. ");
INSERT INTO ibo_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ọnụọgụgụ usuu ndị agha ya dị puku iri asaa na anọ, na narị isii (74,600) ");
INSERT INTO ibo_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Nʼakụkụ ha ka usuu ndị agha ebo Isaka ga-amanye ụlọ ikwu ha. Onyendu ha bụ Netanel nwa Zua. ");
INSERT INTO ibo_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ọnụọgụgụ usuu ndị agha ha dị iri puku ise, puku anọ na narị anọ (54,400). ");
INSERT INTO ibo_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Nʼakụkụ ha ka usuu ndị agha ebo Zebụlọn ga-amanye ụlọ ikwu ha. Onyendu ha bụ Eliab nwa Helọn. ");
INSERT INTO ibo_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ọnụọgụgụ usuu ndị agha ha dị iri puku ise, puku asaa na narị anọ (57,400). ");
INSERT INTO ibo_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ọnụọgụgụ ndị niile a gụkọtara ha na Juda nʼọwụwa anyanwụ nke ụlọ nzute ahụ dị narị puku, iri puku asatọ na puku isii na narị anọ (186,400). Ha ga-ebu ụzọ bulie ije. ");
INSERT INTO ibo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Nʼakụkụ ndịda ka usuu ndị agha ebo Ruben ga-ama ụlọ ikwu ha nʼakụkụ ọkọlọtọ ha. Onyendu ha bụ Elizọ nwa Shedeua. ");
INSERT INTO ibo_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ọnụọgụgụ usuu ndị agha ha dị iri puku anọ, puku isii na narị ise (46,500). ");
INSERT INTO ibo_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Nʼakụkụ ha ka ebo Simiọn ga-ama ụlọ ikwu ha. Onyendu ha bụ Shelumiel nwa Zurishadai. ");
INSERT INTO ibo_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ọnụọgụgụ usuu ndị agha ha dị iri puku ise, puku itoolu na narị atọ (59,300). ");
INSERT INTO ibo_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ebo Gad ga-esokwa ha. Onyendu ha bụ Eliasaf nwa Deuel. ");
INSERT INTO ibo_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ọnụọgụgụ usuu ndị agha ha dị iri puku anọ, puku ise na narị isii na iri ise (45,650). ");
INSERT INTO ibo_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ya mere ọnụọgụgụ ndị niile ha na Ruben bikọrọ na ndịda ụlọ nzute ahụ dị narị puku, iri puku ise na otu, na narị anọ na iri ise (151,450) dịka usuu ndị agha ha si dị. Ebo atọ a bụ ndị na-eso ebo atọ nke mbụ ahụ nʼoge ọbụla ụmụ Izrel nọ nʼije. ");
INSERT INTO ibo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ka ụlọ nzute na-azọli ije, ụlọ ikwu ndị Livayị ga-anọ nʼetiti ụlọ ikwu ndị ọzọ. Ha ga-ebili ije nʼusoro dịka ha si maa ụlọ ikwu ha. Ndị ọbụla nʼọnọdụ ha, nʼokpuru ọkọlọtọ nke na-akọwa ndị ha bụ. ");
INSERT INTO ibo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Nʼakụkụ ọdịda anyanwụ ka ebo Ifrem ga-ama ụlọ ikwu ha dịka ọkọlọtọ ha si dị. Onyendu ha bụ Elishama nwa Amihud. ");
INSERT INTO ibo_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ọnụọgụgụ usuu ndị agha ha dị iri puku anọ na narị ise (40,500). ");
INSERT INTO ibo_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ebo Manase ga-amakwa ụlọ ikwu nʼakụkụ ha. Onyendu ha bụ Gamaliel nwa Pedazo. ");
INSERT INTO ibo_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ọnụọgụgụ usuu ndị agha ha dị iri puku atọ, puku abụọ na narị abụọ (32,200). ");
INSERT INTO ibo_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Nʼakụkụ ha ka ebo Benjamin ga-ama ụlọ ikwu ha. Onyendu ha bụ Abidan nwa Gidiọn. ");
INSERT INTO ibo_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ọnụọgụgụ usuu ndị agha ha dị iri puku atọ, puku ise na narị anọ (35,400). ");
INSERT INTO ibo_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ya mere ọnụọgụgụ ndị niile ha na Ifrem bikọrọ nʼakụkụ ọdịda anyanwụ nke ụlọ nzute ahụ dị narị puku, puku asatọ na narị mmadụ (108,100). Ha niile na-esokwa nʼazụ ndị Livayị na ụlọ nzute ahụ. Ndị a bụ ndị na-eso nʼọnọdụ nke atọ nʼoge ọbụla ụmụ Izrel nọ nʼije. ");
INSERT INTO ibo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ebo Dan na usuu ndị agha ha ga-ama ụlọ ikwu ha nʼakụkụ elu elu nʼokpuru ọkọlọtọ ha. Onyendu ha bụ Ahieza nwa Amishadai ");
INSERT INTO ibo_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ọnụọgụgụ usuu ha dị iri puku isii, puku abụọ na narị asaa (62,700). ");
INSERT INTO ibo_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nʼakụkụ ha ka ebo Asha ga-ama ụlọ ikwu ha. Onyendu ha bụ Pagịel nwa Okran. ");
INSERT INTO ibo_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ọnụọgụgụ usuu ndị agha ha dị iri puku anọ, otu puku na narị ise (41,500). ");
INSERT INTO ibo_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Otu aka ahụ ka ebo Naftalị ga-ama ụlọ ikwu ha. Onyendu ha bụ Ahira nwa Enan. ");
INSERT INTO ibo_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ọnụọgụgụ usuu ndị agha ha dị iri puku ise, puku atọ na narị anọ (53,400). ");
INSERT INTO ibo_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ya mere ọnụọgụgụ ndị niile ha na Dan bikọrọ nʼakụkụ elu elu nke ụlọ nzute ahụ dị narị puku, iri puku ise na puku asaa na narị isii (157,600). Ha ga-abụ ndị ga-ekpe azụ bilie ije nʼokpuru ọkọlọtọ ha. ");
INSERT INTO ibo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ndị a bụ ndị Izrel, ndị a gụrụ ọnụ dịka ezinaụlọ ha si dị. Ndị ikom niile nọ nʼọmụma ụlọ ikwu, dịka usuu ha dị iche iche si dị, narị puku isii, puku atọ na narị ise na iri ise (603,550) nʼọnụọgụgụ. ");
INSERT INTO ibo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ma otu ọ dị, a gụnyeghị ebo Livayị nʼọnụọgụgụ ndị Izrel ndị ọzọ dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ya mere, ndị Izrel mere ihe niile dịka Onyenwe anyị nyere Mosis nʼiwu. Otu a ka ha si maa ụlọ ikwu ha nʼakụkụ ọkọlọtọ ha. Otu a kwa ka ha si ebuli ije. Onye ọbụla nʼime ha dịka ebo ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Nke a bụ akụkọ banyere usoro agbụrụ Erọn na Mosis nʼoge Onyenwe anyị gwara Mosis okwu nʼugwu Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ndị a bụ aha ụmụ ndị ikom Erọn, Nadab, ọkpara ya, Abihu, Elieza na Itama. ");
INSERT INTO ibo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ndị a bụ aha ụmụ ndị ikom Erọn, ndị e tere mmanụ ịbụ ndị nchụaja, ndị e doro nsọ nʼihi ije ozi dịka ndị nchụaja. ");
INSERT INTO ibo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ma Onyenwe anyị mere ka Nadab na Abihu nwụọ, nʼihu ya nʼime ọzara Saịnaị, mgbe ha ji ọkụ na-adịghị nsọ wetara ya onyinye. Ebe ọ bụ na ha amụtaghị ụmụ ndị ikom nke aka ha, ọ bụ naanị Elieza na Itama jere ozi dịka ndị nchụaja ogologo ụbọchị ndụ nna ha bụ Erọn. ");
INSERT INTO ibo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nʼoge ahụ, Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kpọkọtaa ebo Livayị niile were ha nyefee Erọn onye nchụaja nʼaka, ka ha bụrụ ndị inyeaka ya. ");
INSERT INTO ibo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ha ga-ejere ya na nzukọ Izrel niile ozi nʼụlọ nzute ahụ site na ịrụ ọrụ metụtara ebe obibi ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ha ga-elekọta ngwongwo ụlọ nzute, rụọ ọrụ metụtara ndị Izrel niile mgbe ha na-eje ozi ha nʼebe obibi ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Were ndị Livayị nyefee Erọn na ụmụ ya ndị ikom nʼaka. Ọ bụ ha ka a ga-esi nʼetiti ụmụ Izrel nyefee ha nʼaka kpamkpam. ");
INSERT INTO ibo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Họpụta Erọn na ụmụ ya ndị ikom ka ha bụrụ ndị na-eje ozi dịka ndị nchụaja. Onye ọbụla ọzọ bịara nso ebe nsọ ahụ ka a ga-egbu.” ");
INSERT INTO ibo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Anarala m ndị Livayị dịka ndị nọchitere anya ụmụ ndị ikom mbụ niile a mụrụ nʼetiti ndị Izrel. Ndị Livayị niile bụ nke m. ");
INSERT INTO ibo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Nʼihi na ihe niile meghere akpanwa bụ nke m. Site nʼụbọchị ahụ m gburu ụmụ ndị ikom niile e buru ụzọ mụọ nʼala Ijipt ka m doro ụmụ ndị ikom niile e buru ụzọ mụọ nʼetiti ndị Izrel nsọ nye onwe m, ma mmadụ, ma anụmanụ bụ nke m. Abụ m Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Onyenwe anyị gwara Mosis okwu nʼọzara Saịnaị sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Gụọ, chọpụta ihe ọnụọgụgụ ebo Livayị bụ. Gosi ikwu na ezinaụlọ onye ọbụla si nʼime ya pụta. Chọpụta ọnụọgụgụ ndị ikom niile site nʼonye dị otu ọnwa.” ");
INSERT INTO ibo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ya mere, Mosis gụrụ ha ọnụ dịka iwu ọ natara site nʼokwu Onyenwe anyị si dị. ");
INSERT INTO ibo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ndị a bụ aha ụmụ ndị ikom Livayị: Geshọn, Kohat na Merari. ");
INSERT INTO ibo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ndị a bụ aha ndị ikwu Geshọn dịka ezinaụlọ ha si dị: Libni na Shimei. ");
INSERT INTO ibo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ụmụ Kohat dịka ikwu ha si dị: Amram, Izha, Hebrọn na Uziel. ");
INSERT INTO ibo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ụmụ Merari dịka ikwu ha si dị: Mahali na Mushi. Ndị a bụ ndị agbụrụ Livayị, dịka ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ndị Geshọn bụ ndị ikwu Libni na Shimei. Ndị a bụ ndị ikwu Geshọn. ");
INSERT INTO ibo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ọnụọgụgụ ndị ikom dị otu ọnwa gbagoo dị puku asaa na narị ise (7,500). ");
INSERT INTO ibo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ndị ikwu Geshọn mara ụlọ ikwu ha nʼakụkụ ọdịda anyanwụ, nʼazụ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Onyendu ezinaụlọ ndị Geshọn bụ Eliasaf nwa Lael. ");
INSERT INTO ibo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ọrụ dịrị ụmụ Geshọn bụ ilekọta ụlọ nzute ahụ, na ụlọ ikwu ya, na ihe mkpuchi ya, na akwa mgbochi ọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Ọ dịkwa ha nʼaka ilekọta akwa mgbochi niile nke ogige gbara ya gburugburu, na akwa e ji gechie ọnụ ụzọ ogige ahụ. Ha nwekwara ọrụ ilekọta ebe ịchụ aja, na ụdọ niile, na ozi niile metụtara ihe ndị a. ");
INSERT INTO ibo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Nke Kohat bụ ikwu ndị Aram, ndị Izha, ndị Hebrọn na ndị Uziel. Ndị a bụ ndị ikwu Kohat. ");
INSERT INTO ibo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ọnụọgụgụ ndị ikom niile dị otu ọnwa gbagoo dị puku asatọ na narị isii (8,600). Ọrụ dịrị ndị Kohat bụ ilekọta ebe nsọ. ");
INSERT INTO ibo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ndị ikwu Kohat mara ụlọ ikwu ha nʼakụkụ ndịda nke ebe nsọ. ");
INSERT INTO ibo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Onyendu ezinaụlọ ndị ikwu Kohat bụ Elizafan nwa Uziel. ");
INSERT INTO ibo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ọrụ e tinyere ha nʼaka bụ ilekọta igbe ọgbụgba ndụ, tebul ahụ, ihe ịdọba oriọna ahụ na ebe ịchụ aja. Ihe ọzọ bụ ilekọta ngwongwo niile e ji eje ozi nʼebe nsọ ahụ, akwa mgbochi na ihe niile metụtara otu e si e ji ha eje ozi. ");
INSERT INTO ibo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Onyeisi ndị ndu nke ndị Livayị bụ Elieza nwa Erọn, onye nchụaja. Ọ bụ ya na-elekọta ndị ọrụ ha bụ ihu maka ihe niile metụtara ebe nsọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ndị Merari bụ ikwu Mahali na Mushi. Ndị a bụ ndị ikwu Merari. ");
INSERT INTO ibo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ọnụọgụgụ ndị ikom niile dị otu ọnwa gbagoo dị puku isii na narị abụọ (6,200). ");
INSERT INTO ibo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Onyendu ezinaụlọ ndị ikwu Merari bụ Zuniel nwa Abihail. Ha mara ụlọ ikwu ha nʼakụkụ ugwu nke ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ọrụ e tinyere nʼaka ndị ikwu Merari bụ ilekọta mbudo niile nke ụlọ nzute ahụ, na mkpọrọ ya niile, ụkwụ ya niile, na ngwongwo niile e kwesiri iji rụọ ọrụ metụtara ha. ");
INSERT INTO ibo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Ọrụ ndị ọzọ bụ ilekọta ogidi osisi niile dị gburugburu ogige ahụ ha na ụkwụ ha, ǹtu na ụdọ ha niile. ");
INSERT INTO ibo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mpaghara akụkụ ọwụwa anyanwụ nʼihu ụlọ nzute ahụ ka e debere maka ụlọ ikwu Mosis na Erọn, na nke ụmụ ya ndị ikom. Ọrụ ha bụ ilekọta ebe nsọ ahụ nʼaha ụmụ Izrel niile. Onye ọbụla ọzọ bịara ebe nsọ ahụ nso ka a ga-egbu. ");
INSERT INTO ibo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ya mere, ọnụọgụgụ ndị ikom Livayị niile Mosis na Erọn nwetara mgbe a gụrụ ha ọnụ nʼikwu nʼikwu dịka iwu Onyenwe anyị nyere ha si dị, bụ iri puku abụọ na puku abụọ (22,000). Nke a bụ ọnụọgụgụ ndị ikom niile dị site nʼotu ọnwa gaa nʼihu. ");
INSERT INTO ibo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mgbe ahụ, Onyenwe anyị sịrị Mosis, “Gụọ ndị ikom Izrel niile e buru ụzọ mụọ, ndị dị site nʼotu ọnwa gbagoo. Chọpụta ọnụọgụgụ ha, dee aha ha niile nʼakwụkwọ. ");
INSERT INTO ibo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nabata ndị Livayị ka ha bụrụ nke m nʼọnọdụ ndị ikom niile e bụrụ ụzọ mụọ nʼIzrel. Ọzọkwa, anụ ụlọ ndị Livayị niile bụ nke m, nʼọnọdụ ụmụ mbụ nke anụ ụlọ niile a mụrụ nʼetiti anụ ụlọ ndị Izrel niile. Abụ m Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ya mere, Mosis gụrụ ndị ikom niile e buru ụzọ mụọ nʼIzrel, dịka Onyenwe anyị nyere ya nʼiwu, ");
INSERT INTO ibo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","chọpụta na ọnụọgụgụ ndị ikom e buru ụzọ mụọ site nʼonye dị otu ọnwa ruo nʼokenye dị iri puku abụọ na puku abụọ na narị abụọ na iri asaa na atọ (22,273). ");
INSERT INTO ibo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị: ");
INSERT INTO ibo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Nye m ndị Livayị nʼọnọdụ ndị ikom niile e bụ ụzọ mụọ nʼIzrel. Nyekwa m anụ ụlọ ndị Livayị niile nʼọnọdụ anụ ụlọ niile e bụ ụzọ mụọ nʼIzrel. Ndị Livayị bụ nke m. Mụ onwe m bụ Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ihe a ga-eji gbara narị ụmụ ndị ikom Izrel abụọ na iri ndị ikom asaa, na atọ (273) ndị e buru ụzọ mụọ mapụtara nʼelu ọnụọgụgụ ndị Livayị ");
INSERT INTO ibo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","bụ ego ruru shekel ise, na isi onye ọbụla, ụdị shekel ebe nsọ, nke ọtụtụ ya bụ iri gera abụọ. ");
INSERT INTO ibo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Were ego mgbapụta a nye Erọn na ụmụ ndị ikom ya.” ");
INSERT INTO ibo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ya mere, Mosis natara ego mgbapụta ahụ nʼisi onye ọbụla dị nʼọnụọgụgụ ndị ahụ mara nʼelu ọnụọgụgụ ndị Livayị. ");
INSERT INTO ibo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ego niile ọ natara site nʼaka ndị ikom Izrel niile e bụ ụzọ mụọ bụ ọlaọcha ruru puku shekel na narị shekel atọ na iri isii na ise (1,365), dịka ihe ọtụtụ shekel ebe nsọ si dị. ");
INSERT INTO ibo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mosis nyere Erọn na ụmụ ya ego mgbapụta ndị a dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Onyenwe anyị gwara Mosis na Erọn okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Gụọ ọnụ chọpụta, ọnụọgụgụ ụmụ Kohat dị nʼebo Livayị dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Gụọ ndị ikom niile gbarala iri afọ atọ ruo iri afọ ise, ndị tozuru ije ozi nʼụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Nke a bụ ọrụ dịrị ndị Kohat nʼụlọ nzute, ilekọta ihe ndị ahụ kachasị ịdị nsọ. ");
INSERT INTO ibo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Mgbe ọmụma ụlọ ikwu ahụ ga-ebili ije ha, Erọn na ụmụ ya ndị ikom ga-eburu ụzọ banye nʼụlọ nzute ahụ wetuo akwa mgbochi ahụ, jiri ya kpuchie igbe iwu ọgbụgba ndụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Mgbe ahụ, ha ga-agbakwasị akpụkpọ anụ ehi mmiri nʼelu akwa mgbochi ahụ, sakwasịkwa akwa na-acha anụnụ anụnụ nʼelu ya, tinyekwa mkpọrọ osisi niile nʼoghere ha kwesiri ịdị. ");
INSERT INTO ibo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Nʼelu tebul ahụ na-adị nʼihu Onyenwe anyị, ha ga-agbasa akwa anụnụ anụnụ tụkwasịkwa efere niile, ngaji niile, ọkwa niile na iko aja ihe ọṅụṅụ. Achịcha ahụ na-adịgide nʼelu ya ga-adịkwa ebe ọ dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ha ga-agbasakwa akwa uhie nʼelu ya, jiri akpụkpọ anụ ehi mmiri gbokwasịkwa nʼelu akwa uhie ahụ. Mgbe ahụ, ha ga-etinyekwa mkpọrọ osisi e ji ebu tebul nʼime oghere o kwesiri ịdị. ");
INSERT INTO ibo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ọzọ, ha ga-eji akwa anụnụ anụnụ sachie ihe ịdọba oriọna ahụ nke na-enye ìhè, ya na oriọna ya niile, mkpa ya niile na ihe ịkpakepụ ọkụ ya niile na ite mmanụ ya niile, e ji awụnye ya mmanụ. ");
INSERT INTO ibo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Emesịa, ha ga-eji akpụkpọ anụ ehi mmiri sachie ya na ngwongwo ya niile, tụkwasị ya nʼelu ihe e ji ebu ya. ");
INSERT INTO ibo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ha ga-ejikwa akwa anụnụ anụnụ tụsaa nʼelu ebe ịchụ aja ahụ e jiri ọlaedo mee, werekwa akpụkpọ anụ ehi mmiri sachie ya, tinyekwa mkpọrọ osisi e ji ebu ya nʼoghere dị nʼakụkụ ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ihe ndị ọzọ niile e ji eje ozi nʼebe nsọ ahụ ka ha ga-eji akwa anụnụ anụnụ kekọtaa, jirikwa akpụkpọ anụ ehi mmiri sachie ha, tụkwasị ha nʼelu ihe e ji ebu ha. ");
INSERT INTO ibo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“A ga-ekpopụ ntụ dị nʼebe ịchụ aja bronz ahụ, jiri akwa na-acha ngwakọta anụnụ na uhie, sachie ebe ịchụ aja bronz ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Emesịa ha ga-atụkwasị ihe niile e ji eje ozi nʼebe ịchụ aja ahụ nʼelu akwa ahụ, ihe dịka ite ịgụ ọkụ, na ndụdụ, na ihe ikpofu ntụ, na efere ịkwọsa mmiri niile. Akpụkpọ anụ ehi mmiri ka a ga-eji sachie ha niile. Ma nʼikpeazụ, mkpọrọ osisi e ji ebu ya ka a ga-etinye nʼebe ha kwesiri ịdị. ");
INSERT INTO ibo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Mgbe Erọn na ụmụ ya kpuchisịrị ụlọnsọ ahụ na ngwongwo niile nke ebe nsọ ahụ, dịka ndị Izrel niile na-ejikere ibili ije, mgbe ahụ ka ndị Kohat ga-abata buru ihe ndị a. Ma ha agaghị emetụ ihe nsọ ndị a aka ka ha ghara ịnwụ. Ọrụ ibu ihe ndị a niile dị nʼime ụlọ nzute dịrị Ndị Kohat. ");
INSERT INTO ibo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Elieza nwa Erọn, onye nchụaja, ka ọrụ ndị a dị nʼaka: mmanụ e ji amụ ọkụ, na ihe nsure ọkụ e ji ụda dị iche iche na-esi isi ụtọ mee, na onyinye mkpụrụ ọka a na-enye ụbọchị niile, na mmanụ nsọ ahụ. Nʼaka ya ka ọrụ metụtara nlekọta ụlọ nzute ahụ niile, ihe niile dị nʼime ya na ngwongwo nsọ ya dị iche iche dị.” ");
INSERT INTO ibo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Onyenwe anyị gwara Mosis na Erọn sị, ");
INSERT INTO ibo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Unu ekwekwala ka agbụrụ Kohat bụrụ ndị e bipụrụ site nʼebo Livayị. ");
INSERT INTO ibo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Otu a ka unu ga-esi meso ha mmeso ime ka ha dịrị ndụ, ghara ịnwụ, mgbe ha bịara nso ihe ndị ahụ dịkarịsịrị nsọ, Erọn na ụmụ ya ga-esoro ha banye gosi onye ọ bụla nʼime ha ihe ha ga-ebu. ");
INSERT INTO ibo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ma ndị Kohat ekwesighị ịbanye ilekwasị ihe nsọ ndị ahụ anya, ka ha ghara ịnwụ.” ");
INSERT INTO ibo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mgbe ahụ Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gụọ ọnụ chọpụta ọnụọgụgụ ụmụ Geshọn, dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Mata ọnụọgụgụ ndị ikom ole ha dị, ndị kwesiri ịrụ ọrụ nʼụlọ nzute, ndị gbara iri afọ atọ ruo iri afọ ise. ");
INSERT INTO ibo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ihe ga-abụ ọrụ ndị ikwu Geshọn ga-abụ ije ozi na ibu ibu. ");
INSERT INTO ibo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ha ga-ebu akwa mgbochi ebe obibi ahụ na nke ụlọ nzute ahụ, tinyere akwa e ji sachie ya na akpụkpọ anụ ehi mmiri e ji mee elu ụlọ ya na akwa mgbochi dị nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Ha ga-ebukwa akwa mgbochi niile e ji gechie ogige ahụ, akwa e ji gechie ọnụ ụzọ ama ogige gbara ebe ịchụ aja na ụlọ nzute ahụ gburugburu, ụdọ ya niile na ngwongwo niile e ji eje ozi. ");
INSERT INTO ibo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ọrụ ha niile, maọbụ ibu ihe ma ọ bụkwanụ ịrụ ọrụ ọzọ, ga-abụ site na ntụziaka Erọn na ụmụ ya. Ị ga-ekenye ha ọrụ dịrị ha nʼihe niile bụ ihe ha ga-ebu. ");
INSERT INTO ibo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Nke a bụ ọrụ dịịrị ikwu Geshọn nʼụlọ nzute. Ha ga-anọ nʼokpuru Itama, nwa Erọn, onye nchụaja, onye bụ onyeisi ha. ");
INSERT INTO ibo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Gụọ, chọpụta ọnụọgụgụ ụmụ Merari dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Chọpụta ọnụọgụgụ ndị ikom ole ha dị, ndị gbara iri afọ atọ ruo iri afọ ise, ndị toruru ịrụ ọrụ nʼụlọ nzute Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ije ozi ha dịka o si metụta ọrụ ụlọ nzute bụ ibu mbudo ụlọ nzute ahụ niile, osisi ntụbichi ya niile, ogidi osisi na ụkwụ ya niile; ");
INSERT INTO ibo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","tinyere ogidi osisi niile dị ogige ahụ gburugburu na ụkwụ ha niile, ǹtu niile, ụdọ ha niile na ngwongwo ndị ọzọ e ji arụ ọrụ metụtara ihe ndị a ha ga-ebu. Kenye nwoke ọbụla ọrụ nke ya. Kpọ onye ahụ aha nye ya ọrụ nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Nke a bụ ọrụ dịịrị ndị agbụrụ Merari mgbe ha na-aga ozi ha nʼụlọ nzute. Ha ga-anọ nʼokpuru Itama, nwa Erọn, onye nchụaja, onye bụ onyeisi ha.” ");
INSERT INTO ibo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ya mere, Mosis na Erọn na ndị ndu nzukọ ụmụ Izrel gụrụ ma chọpụta ọnụọgụgụ ụmụ Kohat, dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ndị ikom niile gbara iri afọ atọ ruo iri afọ ise, ndị toruru ije ozi nʼụlọ nzute ahụ ");
INSERT INTO ibo_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","dịka ikwu ha si dị bụ puku abụọ na narị asaa na iri ise (2,750). ");
INSERT INTO ibo_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ndị a niile bụ ndị si nʼikwu Kohat ndị na-eje ozi nʼụlọ nzute. Mosis na Erọn gụrụ ha ọnụ dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","A gụrụ ụmụ Geshọn ọnụ dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ndị ikom niile gbara iri afọ atọ ruo iri afọ ise, ndị toruru ije ozi nʼụlọ nzute, ");
INSERT INTO ibo_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","dịka ikwu ha si dị bụ puku abụọ na narị isii na iri atọ (2,630). ");
INSERT INTO ibo_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ndị a niile bụ ndị si nʼikwu Geshọn ndị na-eje ozi nʼụlọ nzute. Mosis na Erọn gụrụ ha ọnụ dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","A gụrụ ụmụ Merari ọnụ dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Ndị ikom niile gbara iri afọ atọ ruo iri afọ ise ndị toruru ije ozi nʼụlọ nzute ");
INSERT INTO ibo_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","dịka ikwu ha si dị bụ puku atọ na narị abụọ (3,200). ");
INSERT INTO ibo_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ndị a niile bụ ndị si nʼikwu Merari ndị na-eje ozi nʼụlọ nzute. Mosis na Erọn gụrụ ha ọnụ dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Otu a ka Mosis na Erọn na ndị ndu ụmụ Izrel si gụọ ndị Livayị niile ọnụ dịka ikwu ha na ezinaụlọ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ndị ikom niile gbara iri afọ atọ ruo iri afọ ise, ndị toruru ije ozi na ibu ụlọ nzute ahụ ");
INSERT INTO ibo_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","dị puku asatọ na narị ise na iri asatọ (8,580). ");
INSERT INTO ibo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Dịka iwu Onyenwe anyị nyere site nʼaka Mosis si dị, e kenyere onye ọbụla ọrụ ya ma gwa ya ihe o kwesiri ibu. A gụrụ ha ọnụ dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Nye ndị Izrel iwu ka ha site nʼọmụma ụlọ ikwu ha kpọpụ onye ekpenta ọbụla maọbụ onye ihe si nʼahụ na-asọpụta, na ndị merụrụ onwe ha site nʼimetụ onye nwụrụ anwụ aka. ");
INSERT INTO ibo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Iwu a metụtara onye ọbụla, nwoke na nwanyị. Kpọpụ ha ka ha gaa nʼazụ ọmụma ụlọ ikwu, ka ha ghara imerụ ogige ụlọ ikwu ha bụ ebe ahụ m binyere unu.” ");
INSERT INTO ibo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ndị Izrel mezuru iwu a, site nʼetiti ha kpọpụ ndị dị otu a, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Gwa ụmụ Izrel okwu sị ha, ‘Mgbe onye ọbụla, nwoke maọbụ nwanyị, mejọrọ mmadụ ibe ya nʼụzọ ọbụla, si otu a bụrụ onye na-ekwesighị ntụkwasị obi nye Onyenwe anyị bụ onye ikpe mara. ");
INSERT INTO ibo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Onye dị otu a aghaghị ikwupụta mmehie ya, kwụghachi onye ahụ o mejọrọ ihe iwu kwuru na ọ ga-akwụ. Ọ ga-atụkwasị nʼelu ihe ọ na-akwụghachi onye ahụ o mejọrọ ego ọzọ ruru otu ụzọ nʼụzọ ise. ");
INSERT INTO ibo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ma ọ bụrụ na onye ahụ enweghị onye ikwu ya bụ onye a ga-akwụghachi ụgwọ nʼihi mejọọ ahụ, ihe ịkwụghachi ụgwọ ahụ ga-abụ nke Onyenwe anyị, aghaghị inye onye nchụaja. A ga-atụkwasịkwa ya ebule a ga-eji chụọ aja mkpuchi mmehie nʼihi onye ahụ mehiere. ");
INSERT INTO ibo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Onyinye niile dị nsọ ndị Izrel wetaara onye nchụaja bụ nke onye nchụaja ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Onyinye dị nsọ niile mmadụ na-eweta bụ nke onye na-eweta ya, ma onyinye e nyere onye nchụaja bụ nke onye nchụaja.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Gwa ụmụ Izrel okwu sị ha, Ọ bụrụ na nwunye mmadụ ejehie ụzọ bụrụ onye na-ekwesighị ntụkwasị obi nʼebe di ya nọ ");
INSERT INTO ibo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","site nʼidinakwuru nwoke ọzọ nʼụzọ zoro ezo nʼebe di ya nọ ruo na achọpụtaghị adịghị ọcha ya (ebe a na-enweghị onye ga-agba akaebe megide ya, maọbụ na e jidere ya mgbe ọ na-akwa iko ahụ), ");
INSERT INTO ibo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ọ bụrụ na mmụọ ekworo abịakwasị di ya, ọ bụrụkwa na di nwanyị ahụ na-enyo nwunye ya enyo, na-ele ya anya dịka onye merụrụ onwe ya, ma ọ bụkwanụ, ọ bụrụ na di ya esite nʼekworo nyoo nwunye ya, ọ bụ ezie na nwanyị ahụ bụ onye na-emerụghị onwe ya, ");
INSERT INTO ibo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","nwoke a ga-akpọrọ nwunye ya bịakwute onye nchụaja. Ọ ga-eweta onyinye iji ịbịaru nso nʼihi nwunye ya, nke bụ iko ụtụ ọka balị abụọ a na-awụkwasịghị mmanụ, maọbụ ụda na-esi isi ụtọ a gwakọrọ agwakọ, nʼihi na ọ bụ onyinye mkpụrụ ọka e sitere nʼobi jupụtara nʼekworo nye, onyinye ịkpọtụ uche nʼikpe ọmụma. ");
INSERT INTO ibo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Onye nchụaja ga-akpọbata nwanyị a mee ka o guzo nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ọ ga-ekunye mmiri nsọ nʼime ite aja, kporo aja nʼala site nʼụlọ nzute ahụ wụnye ya nʼime mmiri ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Dịka nwanyị ahụ guzo nʼihu Onyenwe anyị, onye nchụaja ahụ ga-atọsa agịrị isi ya, tinye onyinye mkpụrụ ọka ncheta ahụ, nke bụ onyinye mkpụrụ ọka ekworo ahụ nʼọbụaka nwanyị a. Onye nchụaja nʼonwe ya ga-eguzo nʼihu nwanyị a jide ite mmiri ilu ahụ na-eweta ọbụbụ ọnụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Mgbe ahụ, onye nchụaja ga-eme ka nwanyị a ṅụọ iyi, mgbe ọ na-agwa ya okwu sị, “Ọ bụrụ na o nweghị nwoke ọbụla gị na ya nwere mmekọ, ọ bụrụ na ị kpafughị ghọọ onye na-adịghị ọcha mgbe ị nọ nʼụlọ di gị, ka ihe ọjọọ ọbụla ghara izute gị site na mmiri ilu a na-eweta ọbụbụ ọnụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ma ọ bụrụ na ị kpafuola mgbe ị ka nọ nʼụlọ di gị, ọ bụrụ na i merụọla onwe gị site na idinakwuru nwoke ọzọ na-abụghị di gị,” ");
INSERT INTO ibo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(nʼoge a, onye nchụaja ga-eme ka nwanyị a ṅụọ iyi nke ya na ọbụbụ ọnụ a so, gwa nwanyị okwu sị ya) “ka Onyenwe anyị mee ka ndị ị nọ nʼetiti ha bụọ gị ọnụ ma kọchaa gị mgbe o mere ka apata gị ree ure, mgbe o mere ka afọ gị koo eko. ");
INSERT INTO ibo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ka mmiri ilu a, nke na-eweta ọbụbụ ọnụ banye gị nʼahụ ime ka afọ gị koo eko, imekwa ka akpanwa gị daa ada.” “ ‘Nwanyị ahụ ga-aza sị, “Amen, ya dịrị m otu a.” ");
INSERT INTO ibo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Mgbe ahụ onye nchụaja ahụ ga-ede ọbụbụ ọnụ ndị a nʼakwụkwọ, sanye ha nʼime mmiri ilu ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Mgbe ahụ, ọ ga-enye nwanyị a mmiri ilu ahụ na-eweta ọbụbụ ọnụ ka ọ ṅụọ, mmiri a ga-abanye ya nʼime ahụ, wetara ya ịta ahụhụ dị ilu. ");
INSERT INTO ibo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Emesịa, onye nchụaja ga-anara nwanyị ahụ onyinye mkpụrụ ọka ekworo ahụ o ji nʼọbụaka ya, fegharịa ya nʼihu Onyenwe anyị, buru ya gaa nʼebe ịchụ aja. ");
INSERT INTO ibo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Onye nchụaja ga-esite nʼonyinye mkpụrụ ahụ kporo nke ga-eju ya aka, nke na-anọchite anya ha niile, suo ha ọkụ nʼelu ebe ịchụ aja. Emesịa, ọ ga-enye nwanyị ahụ mmiri ahụ ka ọ ṅụọ. ");
INSERT INTO ibo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ọ bụrụ na nwanyị a emerụọla onwe ya, bụrụ onye na-ekwesighị ntụkwasị obi nye di ya, mgbe ọ ṅụrụ mmiri na-eweta ọbụbụ ọnụ, ọ ga-abanye nʼime ya wetara ya ahụhụ dị ilu. Afọ ya ga-eko, buo ibu, akpanwa ya a gaghị anagide nwa. Ọ ga-aghọ onye a bụrụ ọnụ nʼetiti ndị ya. ");
INSERT INTO ibo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ma ọ bụrụ na nwanyị emerụghị onwe ya, kama ọ bụ onye dị ọcha, ọ ga-abụ onye nwere onwe ya site nʼikpe ọmụma. Ọ ga-atụrụ ime mụta ụmụ. ");
INSERT INTO ibo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Nke a bụ iwu metụtara ikwo ekworo mgbe nwanyị bi nʼụlọ di ya kpafuru merụọ onwe ya. ");
INSERT INTO ibo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Maọbụ mgbe ekworo jupụtara nwoke nʼobi nʼihi na ọ gụrụ nwunye ya dịka onye na-ekwesighị ntụkwasị obi. Onye nchụaja ga-eme ka nwanyị a guzo nʼihu Onyenwe anyị, mezuokwa ihe niile nʼusoro dịka e si depụta ha nʼebe a. ");
INSERT INTO ibo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","A gaghị ama di nwanyị a ikpe dịka onye mere ihe ọjọọ, kama nwanyị a ga-ebu ahụhụ ya na mmehie ya naanị ya.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Gwa ndị Izrel sị ha, “Mgbe nwoke maọbụ nwanyị ṅụrụ iyi o ji kpebie ikwe nkwa pụrụ iche nke ikewapụ onwe ya nye Onyenwe anyị dịka onye Nazirait, ");
INSERT INTO ibo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ha ga-ekewapụ onwe ha site na ịṅụ mmanya, maọbụ detụ ihe ọṅụṅụ ọbụla na-aba nʼanya ire. Ha agaghị aṅụ mmiri mkpụrụ vaịnị, ọ gaghị ata mkpụrụ vaịnị ọhụrụ maọbụ nke a mịkpọrọ amịkpọ. ");
INSERT INTO ibo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Oge ahụ niile ọ bụ onye Nazirait, ọ gaghị eri ihe ọbụla sitere na mkpụrụ osisi vaịnị maọbụ mkpụrụ ya maọbụ okpokoro azụ ya. ");
INSERT INTO ibo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Nʼime oge niile nke imezu nkwa ikewapụ onwe ya nye Onyenwe anyị, agụba agaghị agabiga ya nʼisi. Ọ ga-anọgide bụrụ onye dị nsọ tutu ruo oge nkwa ikewapụ onwe ya nye Onyenwe anyị zuru. Nʼihi nke a, ọ ga-ahapụ agịrị isi ya ka o too. ");
INSERT INTO ibo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘Nʼime oge niile nke imezu nkwa ikewapụ onwe ya nye Onyenwe anyị, ọ gaghị aga nso mmadụ ọbụla nwụrụ anwụ, ");
INSERT INTO ibo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ọ bụladị na nna ya, maọbụ nne ya, maọbụ nwanne ya nwoke, maọbụ nwanne ya nwanyị anwụọ. Ọ gaghị emerụ onwe ya nʼihi ha, nʼihi na akara ikewapụ onwe ya iche nye Chineke dị ya nʼisi. ");
INSERT INTO ibo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Nʼoge niile nke ikewapụ onwe ya, onye e doro nsọ nye Onyenwe anyị ka ọ bụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Ọ bụrụ na mmadụ anwụọ na mberede nʼakụkụ onye nazirait, si otu a merụọ agịrị isi ya nke na-egosi ido nsọ ya, ọ ghaghị ịkpacha isi ya nʼụbọchị nke asaa bụ ụbọchị ime ka ọ dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Nʼụbọchị nke ọzọ ya, bụ nʼụbọchị nke asatọ. Ọ ghaghị iwetara onye nchụaja nduru abụọ maọbụ ụmụ kpalakwukwu abụọ, nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Onye nchụaja ahụ ga-ewere otu nʼime ha chụọrọ ya aja mmehie. Ọ ga-ewerekwa nnụnụ nke ọzọ chụọrọ ya aja nsure ọkụ maka ikpuchiri onye ahụ nwere akara ido nsọ mmehie ya, bụ nke o mere site nʼịnọ onye nwụrụ anwụ nso. Ọ ga-edokwa isi ya nsọ ọzọ nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ọ ga-ekewapụ onwe ya nye Onyenwe anyị dịka o mere na mmalite ụbọchị niile nke ido nsọ ya. Wetakwa otu nwa ebule gbara otu afọ maka aja ikpe ọmụma. A gaghị agụnyere ya ụbọchị ndị ahụ niile gafere tupu o merụọ onwe ya, nʼihi na o merụrụ onwe ya mgbe ọ nọ ọnọdụ imezu nkwa nkewapụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Nke a bụ iwu dịrị onye Nazirait mgbe oge ido onwe ya nsọ nye Onyenwe anyị zuru. A ga-eduru ya bịa nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Nʼebe ahụ ka ọ ga-anọ chee onyinye ya ndị a nʼihu Onyenwe anyị: nwa ebule na-enweghị ntụpọ, gbara otu afọ, maka aja nsure ọkụ na otu nwa nne atụrụ na-enweghị ntụpọ gbara otu afọ maka aja mmehie, na otu ebule ahụ zuruoke maka aja udo, ");
INSERT INTO ibo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","tinyere aja mkpụrụ ọka, na aja ihe ọṅụṅụ na otu nkata achịcha a na-ejighị ihe na-eko achịcha mee, na achịcha e ji ezi ụtụ ọka a gwara mmanụ oliv mee, na achịcha mbadamba na-ekoghị eko nke e tere mmanụ oliv. ");
INSERT INTO ibo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Onye nchụaja ahụ ga-eche ihe aja ndị a niile nʼihu Onyenwe anyị, chụọ aja mmehie na aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ọ ga-eji nwa ebule ahụ chụọ aja udo nye Onyenwe anyị, ya na nkata achịcha na-ekoghị eko ahụ. Ọ ga-achụkwa aja mkpụrụ ọka, na aja ihe ọṅụṅụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Mgbe ahụ, onye ahụ doro onwe ya nsọ nye Onyenwe anyị ga-akpụchapụ agịrị isi ya nke bụ ihe na-egosi ido nsọ ya. Ọ ga-eme nke a na mbata ọnụ ụzọ ụlọ nzute ahụ. Emesịa, ọ ga-etinye agịrị isi ahụ ọ kpụchapụtara nʼọkụ ahụ dị nʼokpuru aja udo ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Mgbe a kpụchasịrị onye ahụ agịrị isi ya, nke na-egosi ido nsọ ya, onye nchụaja ga-ewere ubu aka ebule ahụ e sịrị esi, otu ogbe achịcha na-ekoghị eko na otu mbadamba achịcha na-ekoghị eko site na nkata ahụ, tinye ha niile nʼaka onye ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Onye nchụaja ahụ nʼoge a, ga-ewere aja ndị a fufee ha nʼihu Onyenwe anyị dịka aja mfufe. Ha niile ga-abụ ihe nsọ nye onye nchụaja ahụ, tinyere obi anụ ahụ e fufere efufe, na apata anụ ahụ e chere nʼihu Onyenwe anyị. Mgbe nke a gasịrị, onye ahụ doro onwe ya nsọ nwere onwe ya ịṅụ mmanya. ");
INSERT INTO ibo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Nke a bụ iwu dịrị onye ọ bụla kpebiri ikewapụ onwe ya nye Onyenwe anyị dịka onye Nazirait. Onyinye onye ahụ ga-enye ga-abụ dịka nkwa ido nsọ ya si dị, tinyere ihe ndị ọzọ ha nwere ike inye. Onye dị otu a aghaghị imezu nkwa ọbụla o kwere dịka iwu metụtara onye Nazirait si dị.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Gwa Erọn na ụmụ ya ndị ikom sị, ‘Otu a ka unu ga-esi gọzie ndị Izrel. Unu ga-asị ha, ");
INSERT INTO ibo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Onyenwe anyị gọzie unu ma chebe unu, ");
INSERT INTO ibo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Onyenwe anyị mee ka ihu ya mụkwasị unu, ma meere unu amara, ");
INSERT INTO ibo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Onyenwe anyị chee ihu ya nʼebe unu nọ, nyekwa unu udo.” ’ ");
INSERT INTO ibo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Otu a ka ha ga-esi kwupụta aha m nye ụmụ Izrel. Mụ onwe m ga-agọzikwa ha.” ");
INSERT INTO ibo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mgbe Mosis guzobesiri ụlọ nzute ahụ ọtọ, o tere ya mmanụ. Doo ya na ihe niile e ji chọọ ya mma nsọ. O tekwara ebe ịchụ aja mmanụ, doo ya nsọ, ya na ngwongwo ya niile. ");
INSERT INTO ibo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Mgbe ahụ, ndị ndu Izrel, ndịisi ezinaụlọ niile, ndị bụ ndị ndu ebo niile e tinyere ọrụ ịgụ ndị ahụ niile ọnụ wetara onyinye ha. ");
INSERT INTO ibo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ha wetara dịka onyinye ha nye Onyenwe anyị ụgbọala isii ihe juputara nʼime ha, na ehi iri na abụọ. Ndị ndu abụọ ọbụla wetara otu ụgbọala, ma ha niile nʼotu na otu wetara otu ehi, otu ehi. Ha chere ihe ndị a niile nʼihu ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Nabata onyinye ndị a niile, ka e jiri ha rụọ ọrụ ụlọ nzute, were ha nyefee ndị Livayị nʼaka, onye ọbụla dịka mkpa ọrụ ya si dị.” ");
INSERT INTO ibo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ya mere, Mosis nabatara ụgbọala ndị ahụ na ehi ndị ahụ, nyefee ha ndị Livayị nʼaka. ");
INSERT INTO ibo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","O nyere ụmụ Geshọn ụgbọala abụọ na ehi anọ, dịka ọrụ ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Nye ụmụ Merari, ụgbọala anọ na ehi asatọ, dịka ọrụ ha si dị. Ha niile nọ nʼokpuru nlekọta Itama nwa Erọn, onye nchụaja. ");
INSERT INTO ibo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mosis enyeghị ụmụ Kohat ihe ọbụla nʼihi na ọ bụ nʼisi mbụ aka ha ka ha ji ebu ihe nsọ ndị ahụ ha ketara ibu. ");
INSERT INTO ibo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ndị ndu ụmụ Izrel niile wetara onyinye ido nsọ nʼụbọchị e tere ebe ịchụ aja ahụ mmanụ ido ya nsọ. Ha wetara ha, debe ha nʼihu ebe ịchụ aja ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nʼihi na Onyenwe anyị gwara Mosis okwu sị, “Ka onyendu ọbụla weta onyinye nʼụbọchị dị iche iche, otu onye, otu ụbọchị, maka ido nsọ nke ebe ịchụ aja ahụ.” ");
INSERT INTO ibo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ya mere, Nashọn nwa Aminadab onye si nʼebo Juda wetara onyinye nke ya nʼụbọchị nke mbụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Onyinye o wetara bụ: efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ nke ịdị arọ ya bụ iri shekel asaa, dịka ihe ọtụtụ shekel ebe nsọ si dị. A wụjuru efere abụọ ndị a ụtụ ọka a gwara mmanụ maka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","O wetakwara otu nwa oke ehi, otu ebule, otu nwa ebule nke gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","na ehi abụọ, na ebule ise, na mkpi ise, na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Nashọn nwa Aminadab nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nʼụbọchị nke abụọ, Netanel nwa Zua, onyendu ebo Isaka wetara onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","na ehi abụọ, na ebule ise, mkpi ise, na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Netanel nwa Zua. ");
INSERT INTO ibo_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Nʼụbọchị nke atọ Eliab nwa Helọn onyendu ebo Zebụlọn wetakwara onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","O wetara otu efere ọlaedo nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","O wetakwara otu nwa oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","na ehi abụọ, na ebule ise, mkpi ise, na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Eliab nwa Helọn wetara. ");
INSERT INTO ibo_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Nʼụbọchị nke anọ, Elizọ nwa Shedeua onyendu ebo Ruben wetara onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","na ehi abụọ, na ebule ise, mkpi ise, na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Elizọ nwa Shedeua nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Nʼụbọchị nke ise Shelumiel nwa Zurishadai, onyendu ebo Simiọn butere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","O wetara otu efere ọlaedo nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Shelumiel nwa Zurishadai nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Nʼụbọchị nke isii, Eliasaf nwa Deuel onyendu ebo Gad butere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","na ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Eliasaf nwa Deuel nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Nʼụbọchị nke asaa, Elishama, nwa Amihud, onyendu ebo Ifrem butere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","na ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Elishama nwa Amihud nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Nʼụbọchị nke asatọ, Gamaliel nwa Pedazo onyendu ebo Manase nyere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Gamaliel nwa Pedazo nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Nʼụbọchị nke itoolu, Abidan nwa Gidiọn onyendu ebo Benjamin nyere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","na ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Abidan nwa Gidiọni nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Nʼụbọchị nke iri, Ahieza nwa Amishadai, onyendu ebo Dan butere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Ahieza nwa Amishadai nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Nʼụbọchị nke iri na otu, Pagịel nwa Okran, onyendu ebo Asha butere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","O wetara otu efere ọlaedo, nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","na ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Pagịel nwa Okran nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Nʼụbọchị nke iri na abụọ, Ahira nwa Enan, onyendu ebo Naftalị nyere onyinye nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Onyinye o wetara bụ: otu efere ọlaọcha nke ịdị arọ ya bụ narị shekel na iri shekel atọ, na otu efere ịkwọsa mmiri e ji ọlaedo kpụọ, nke ịdị arọ ya bụ iri shekel asaa, efere abụọ ndị a bụ nʼusoro dịka shekel ebe nsọ si dị. A wụjuru efere ọbụla ezi ụtụ ọka a gwara mmanụ dịka onyinye mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","O wetara otu efere ọlaedo nke ịdị arọ ya bụ shekel iri. A wụjuru efere a ụda na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","O wetakwara otu oke ehi, otu ebule, otu nwa ebule gbara otu afọ maka aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","O wetakwara otu mkpi maka aja mmehie, ");
INSERT INTO ibo_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","na ehi abụọ, ebule ise, mkpi ise na ụmụ ebule ise gbara otu afọ, otu afọ, ka a chụọ maka aja udo. Nke a bụ onyinye Ahira nwa Enan nyere. ");
INSERT INTO ibo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ndị a bụ onyinye ndị ndu ụmụ Izrel wetara maka ido ebe ịchụ aja nsọ nʼoge e tere ya mmanụ: efere ọlaọcha iri na abụọ, na efere ọlaọcha ịkwọsa mmiri iri na abụọ, na efere ọlaedo iri na abụọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ịdị arọ nke efere ọlaọcha ọbụla dị otu narị shekel na iri shekel atọ. Ịdị arọ nke efere ịkwọsa mmiri ọbụla dị iri shekel asaa. Ịdị arọ efere ọlaọcha niile ha wetara bụ puku shekel abụọ na narị shekel anọ, dịka ihe ọtụtụ shekel ebe nsọ si dị. ");
INSERT INTO ibo_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ịdị arọ nke otu nʼime efere ọlaedo iri na abụọ ndị ahụ ụda nsure ọkụ na-esi isi ụtọ juru nʼime ha bụ iri shekel, dịka ihe ọtụtụ shekel ebe nsọ si dị. Ịdị arọ nke efere ọlaedo ndị ahụ niile bụ otu narị shekel na iri shekel abụọ. ");
INSERT INTO ibo_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ọnụọgụgụ anụ ụlọ niile e wetara maka aja nsure ọkụ bụ: oke ehi iri na abụọ, na ebule iri na abụọ, na ụmụ ebule iri na abụọ gbara otu afọ, otu afọ, tinyere ihe niile ha wetara maka aja mkpụrụ ọka. E ji mkpi iri na abụọ chụọ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Anụ ụlọ niile e ji chụọ aja udo bụ, iri oke ehi abụọ na anọ, na iri ebule isii, na iri mkpi isii, na ụmụ ebule iri isii ndị gbara naanị otu afọ, otu afọ. Ndị a niile bụ onyinye e nyere maka ido ebe ịchụ aja nsọ nʼoge e tere ya mmanụ. ");
INSERT INTO ibo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mgbe Mosis banyere nʼụlọ ikwu ahụ ka ya na Onyenwe anyị kparịa ụka, ọ nụrụ olu ahụ ka ọ na-agwa ya okwu site nʼetiti cherubim abụọ ndị ahụ nʼelu ebe mkpuchi mmehie dị nʼelu igbe iwu ọgbụgba ndụ gwa ya okwu. Nʼụzọ dị otu a ka Onyenwe anyị si gwa ya okwu. ");
INSERT INTO ibo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Gwa Erọn okwu sị ya, ‘Mgbe ọbụla ị mụnyere oriọna asaa nke iheọkụ, ị ga-edozi ha ka ìhè ha na-enwupụta naanị nʼihu iheọkụ ahụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Erọn mere otu a. O doziri oriọna ndị ahụ ka ha chee ihu nʼihe ịdọba oriọna, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Otu a ka esi mee ihe ịdọba oriọna ahụ. Ọ bụ naanị ọlaedo ka e ji kpụọ iheọkụ ahụ, site nʼụkwụ ya ruo nʼokooko niile e ji chọọ ya mma. A kpụrụ iheọkụ ahụ nʼusoro dịka oyiyi Onyenwe anyị gosiri Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mgbe ahụ Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ugbu a, site nʼetiti ụmụ Izrel, kpọpụta ụmụ Livayị, doo ha iche, mee ha ka ha dịrị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ime ka ha dị ọcha, lee ihe ị ga-eme. Fesa ha mmiri na-asachapụ mmehie. Hụkwa na ha kpụchapụrụ ajị niile dị ha nʼahụ, ma sachaa uwe ha. Si otu a mee ka ha bụrụ ndị dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Gwa ha ka ha weta nwa oke ehi na onyinye mkpụrụ ọka, bụ ụtụ ọka a gwara mmanụ. Ha ga-ewetakwa nwa oke ehi ọzọ; ka ọ bụrụ ihe ha ji achụ aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Emesịa, kpọbata ụmụ Livayị nʼọnụ ụzọ ụlọ nzute ahụ. Meekwa ka ọgbakọ ndị Izrel niile zukọọ nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kpọpụta ndị Livayị nʼihu Onyenwe anyị, ma mee ka ndị Izrel niile bikwasị ha aka ha. ");
INSERT INTO ibo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Mgbe ahụ, Erọn ga-ewere ndị Livayị chee Onyenwe anyị nʼihu dịka onyinye mfufe ndị Izrel niile na-enye ya. Nʼụzọ dị otu a, ụmụ Livayị niile ga-abụ ndị jikere ijere Onyenwe anyị ozi. ");
INSERT INTO ibo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Emesịa, ndị Livayị ga-abịa bikwasị aka ha nʼisi oke ehi abụọ ndị ahụ jiri otu nʼime oke ehi abụọ ndị ahụ chụọ aja mmehie nye Onyenwe anyị, jiri nke ọzọ chụọ aja nsure ọkụ, maka ikpuchi mmehie ndị Livayị. ");
INSERT INTO ibo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Mgbe ahụ, mee ka ndị Livayị guzo nʼihu Erọn na ụmụ ndị ikom, werekwa ha nyefee Onyenwe anyị nʼaka dịka a ga-asị na ha bụ onyinye mfufe a na-enye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Otu a ka ị ga-esi doo ndị Livayị nsọ ime ka ha dịrị iche site nʼigwe ụmụ Izrel ndị ọzọ. Ọ bụ m nwe ndị Livayị. ");
INSERT INTO ibo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Mgbe i dosiri ndị Livayị nsọ, cheekwa ha nʼihu Onyenwe anyị dịka aja mfufe, ha ga-abịa nʼime ụlọ nzute ahụ ije ozi dịrị ha. ");
INSERT INTO ibo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ha bụ nke m site nʼetiti ụmụ Izrel niile. Anarala m ha ka ha bụrụ nke m nʼọnọdụ ụmụ niile e bụ ụzọ mụọ, nwa nwoke nke nwanyị ọbụla nʼIzrel. ");
INSERT INTO ibo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nʼihi na nwa nwoke mbụ ọbụla a mụrụ nʼetiti ndị Izrel bụ nke m, ma mmadụ ma anụmanụ niile. Edoro m ha nsọ nye onwe m, site nʼabalị ụbọchị ahụ m tigbusiri ụmụ niile e bụ ụzọ mụọ nʼIjipt. ");
INSERT INTO ibo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ewerela m ndị Livayị nʼọnọdụ ụmụ nwoke mbụ niile a mụrụ nʼIzrel. ");
INSERT INTO ibo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Site nʼetiti ndị Izrel niile, ewerela m ndị Livayị nye Erọn na ụmụ ya ndị ikom dịka onyinye, ka ha rụọ ọrụ niile dị nʼime ụlọ nzute ahụ nʼọnọdụ ụmụ Izrel. Ka ha kpuchiere ha mmehie ha niile ka ihe otiti nke nrịa nrịa ghara ịbịakwasị ụmụ Izrel, mgbe ọbụla ha bịara nso ebe nsọ ahụ.” ");
INSERT INTO ibo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ya mere, Mosis na Erọn na nzukọ niile nke ụmụ Izrel chere ụmụ Livayị nʼihu Onyenwe anyị, nʼusoro dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ndị Livayị niile doro onwe ha ọcha, sachakwaa uwe ha niile. Erọn chere ha nʼihu Onyenwe anyị dịka onyinye aja mfufe, chụọrọ ha aja ikpuchi mmehie, ime ka ha dị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Nʼikpeazụ, ndị Livayị bịara ije ozi ha nʼụlọ nzute nʼokpuru Erọn na ụmụ ya ndị ikom. Ha nyekwara ndị Livayị ọrụ dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Iwu m ndị a metụtara ndị Livayị niile. Nwoke onye Livayị ọbụla ga-ebido ịrụ ọrụ nʼụlọ nzute m mgbe ọ gbara iri afọ abụọ na ise. ");
INSERT INTO ibo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ọ ga-akwụsịkwa ịrụ ọrụ nʼime ya mgbe ọ gbara iri afọ ise, mgbe oge ezumike ọrụ ya ga-amalite. ");
INSERT INTO ibo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ha nwere ike inyere ụmụnne ha aka nʼịrụ ọrụ ha nʼime ụlọ nzute, ma ha onwe ha agaghị arụ ọrụ ahụ. Otu a ka ị ga-esi dozie ọrụ ije ozi nke ndị Livayị.” ");
INSERT INTO ibo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Onyenwe anyị gwara Mosis okwu ndị a nʼọzara Saịnaị nʼọnwa mbụ nʼafọ nke abụọ site nʼoge ha hapụrụ ala Ijipt. Ọ sịrị ya, ");
INSERT INTO ibo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Gwa ụmụ Izrel ka ha mee Mmemme Ngabiga nʼoge a kara aka. ");
INSERT INTO ibo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ha mee ya nʼoge a kara aka, malite nʼuhuruchi abalị iri na anọ nke ọnwa a. Ha ga-eme ya nʼusoro dịka iwu na ụkpụrụ e ji eme ya si dị.” ");
INSERT INTO ibo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ya mere, Mosis gwara ndị Izrel sị ha mee Mmemme Ngabiga. ");
INSERT INTO ibo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ha mekwara ya nʼọzara Saịnaị malite nʼuhuruchi abalị iri na anọ nke ọnwa mbụ. Ndị Izrel mere ihe niile nʼusoro dịka iwu Onyenwe anyị nyere Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ma ụfọdụ nʼime ụmụ Izrel esoghị mee Mmemme Ngabiga ahụ nʼihi na ha rụrụ arụ site nʼịnọ ozu nso. Nʼihi ya, ha bịakwutere Mosis na Erọn nʼụbọchị ahụ, ");
INSERT INTO ibo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","sị Mosis, “Anyị ghọrọ ndị rụrụ arụ nʼihi ịnọ ozu mmadụ nso. Gịnị ga-egbochi anyị iso ndị Izrel ndị ọzọ iwetara Onyenwe anyị onyinye nʼoge a kara aka?” ");
INSERT INTO ibo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mosis zara sị ha, “Cherenụ ka m ga jụta Onyenwe anyị ihe bụ uche ya banyere mkpa unu.” ");
INSERT INTO ibo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Gwa ụmụ Izrel okwu sị ha, ‘Ọ bụrụ na e nwee onye Izrel ọbụla nke merụrụ onwe ya nʼoge Mmemme Ngabiga site nʼịnọ ozu mmadụ nso, maọbụ site nʼịnọ nʼije, ha nwekwara ike iso mee Mmemme Ngabiga Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Kama ha ga-eme ya nʼuhuruchi abalị iri na anọ nke ọnwa abụọ. Ha ga-eri nwa atụrụ ha, achịcha na-ekoghị eko, na ahịhịa ilu. ");
INSERT INTO ibo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ha agaghị erifọ ihe ọbụla nʼime ya ruo chi ọbụbọ ụbọchị so ya. Ha agaghị agbaji ọkpụkpụ ọbụla nke nwa atụrụ ahụ. Mgbe ha mere Mmemme Ngabiga, ha ga-esorokwa ụzọ niile e si eme mmemme ahụ mee nke ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ma ọbụla nọ nʼọnọdụ ịdị ọcha, onye nke na-anọghị nʼije nʼoge Mmemme Ngabiga ma kpachapụrụ anya hapụ isoro ndị ọzọ nʼoge mmemme a, a ga-ewezuga ya site nʼetiti ụmụ Izrel niile, nʼihi na ọ jụrụ iwetara Onyenwe anyị onyinye nʼoge a kara aka. Onye dị otu a ga-ebu ahụhụ mmehie ya nʼisi ya. ");
INSERT INTO ibo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Onye ọbịa bi nʼetiti unu chọrọ iso na Mmemme Ngabiga Onyenwe anyị, ọ ga-eme ya nʼusoro dịka iwu na ụkpụrụ e nyere si dị. Unu ga-enwe otu iwu ahụ nye onye amụrụ nʼala na mbịarambịa.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Nʼụbọchị ahụ e guzobere ụlọ nzute ahụ bụ ụlọ ikwu nke igbe iwu ọgbụgba ndụ ahụ, igwe ojii kpuchiri ya. Site nʼuhuruchi ruo nʼụtụtụ igwe ojii ahụ dị nʼelu ụlọ nzute ahụ dịka ọkụ nʼile anya. ");
INSERT INTO ibo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Otu a ka ọ dịgidere mgbe niile. Igwe ojii kpuchigidere ya, ma nʼabalị ọ na-acha dị ka ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mgbe ọ bụla igwe ojii ahụ si nʼelu ụlọ nzute ahụ bilie, ụmụ Izrel na-ebuli njem, ma mgbe ọbụla igwe ojii ahụ na-anọgide, ha na-anọgidekwa. ");
INSERT INTO ibo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Mgbe Onyenwe anyị nyekwara iwu, ha na-akwụsị, maa ụlọ ikwu ha. Oge niile igwe ojii nọgidere nʼelu ụlọ nzute ahụ ka ụmụ Izrel na-anọgidekwa nʼụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ọ bụrụ na igwe ojii ahụ anọọtee anya, ụmụ Izrel nʼonwe ha na-erube isi nʼiwu Onyenwe anyị hapụ ịga nʼihu nʼije ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Oge ụfọdụ, igwe ojii ahụ na-anọgide naanị abalị ole na ole. Dịka iwu Onyenwe anyị si dị, ha na-ama ụlọ ikwu ha, maọbụ bulie njem ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Oge ụfọdụ, igwe ojii ahụ na-anọgide naanị site nʼuhuruchi ruo nʼụtụtụ. Mgbe o si nʼelu ụlọ nzute ahụ bilie nʼụtụtụ, ụmụ Izrel na-ebuli njem ha. Ọ bụrụ nʼehihie, maọbụ nʼabalị, mgbe ọbụla igwe ojii ahụ biliri, ụmụ Izrel na-ebuli njem ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ọ bụrụ na igwe ojii ahụ anọdụ nʼelu ụlọ nzute ahụ abalị abụọ, maọbụ otu ọnwa, maọbụ otu afọ, ụmụ Izrel na-anọgide nʼụlọ ikwu ha. Ma ngwangwa igwe ojii ahụ biliri, ha onwe ha na-ebulikwa njem ha. ");
INSERT INTO ibo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Site nʼiwu Onyenwe anyị na-enye, ha na-ama ụlọ ikwu ha, sitekwa nʼiwu Onyenwe anyị nyere ha, ha na-ebili njem. Ha mere ihe niile Onyenwe anyị kwuru nʼusoro dịka iwu o nyere ha site nʼọnụ Mosis si dị. ");
INSERT INTO ibo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kpụọ opi ọlaọcha abụọ, jiri ha na-akpọ mkpọkọta nzukọ ụmụ Izrel na ime ka ha mara mgbe mbuli ije nke ọmụma ụlọ ikwu ruru. ");
INSERT INTO ibo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Mgbe a fụrụ opi abụọ ahụ, nzukọ Izrel niile ga-ezukọta nʼihu gị nʼọnụ ụzọ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ma ọ bụrụ naanị otu opi ka a fụrụ, ọ bụ ndị ndu, ndịisi ikwu Izrel niile ga-ezukọta bịakwute gị. ");
INSERT INTO ibo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Otu ụda opi ike ga-egosi na ebo Izrel niile mara ụlọ ikwu ha nʼakụkụ ọwụwa anyanwụ ga-ebuli ije. ");
INSERT INTO ibo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Opi ike ahụ daa ụda nke ugboro abụọ, ọ na-egosi na ndị mara ụlọ ikwu ha na ndịda ga-ebuli ije. Ịda ụda nke opi ike bụ ihe e ji amata na oge ibuli ije eruola. ");
INSERT INTO ibo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mgbe a ga-akpọkọta ndị Izrel niile a ga-egbu opi, kama ụda ya ga-adị iche. ");
INSERT INTO ibo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ọ bụ naanị ụmụ ndị ikom Erọn, ndị nchụaja ga-egbu opi ndị a. Nke a bụ iwu ga-adịgide nye unu site nʼọgbọ ruo nʼọgbọ niile. ");
INSERT INTO ibo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Mgbe unu gara ibu agha nʼala unu imegide onye iro na-akpagbu unu, fụọnụ opi ike. Nke a ga-eme ka Onyenwe anyị Chineke unu cheta unu, ma napụta unu site nʼaka ndị iro unu. ");
INSERT INTO ibo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Unu ga-egbukwa opi ndị a nʼoge aṅụrị, nʼoge mmemme unu a kara aka, na nʼoge mmemme ọnwa ọhụrụ niile. Gbukwaanụ opi mgbe unu na-achụ aja nsure ọkụ unu, na aja udo unu niile. Ka ọ bụrụ ihe a ga-eji na-echeta unu nʼihu Chineke unu. Mụ onwe m bụ Onyenwe anyị Chineke unu.” ");
INSERT INTO ibo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Nʼụbọchị iri abụọ, nʼime ọnwa nke abụọ, nʼafọ nke abụọ, igwe ojii ahụ biliri site nʼelu ụlọ nzute nke igbe iwu ọgbụgba ndụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Mgbe ahụ, ụmụ Izrel biliri ije site nʼọzara Saịnaị jegharịa site nʼotu ebe ruo nʼebe ọzọ tutu igwe ojii ahụ akwụsị nʼọzara Paran. ");
INSERT INTO ibo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nke a bụ njem mbụ ha mere dịka Onyenwe anyị si nye Mosis iwu banyere ije ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Usuu ọmụma ụlọ ikwu nke ebo Juda buru ụzọ bulie ije a, nʼokpuru ọkọlọtọ ha. Nashọn, nwa Aminadab, bụ onyendu ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanel nwa Zua bụ onyendu usuu ebo Isaka. ");
INSERT INTO ibo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab nwa Helọn bụ onyendu usuu ebo Zebụlọn ");
INSERT INTO ibo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Mgbe ahụ, e wedara ụlọ nzute ahụ. Ụmụ Geshọn na Merari buru ya, bilikwaa ije ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Usuu ọmụma ụlọ ikwu ebo Ruben biliri ije, nʼokpuru ọkọlọtọ ha. Elizọ nwa Shedeua bụ onyendu ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel nwa Zurishadai bụ onyendu usuu ebo Simiọn. ");
INSERT INTO ibo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaf nwa Deuel bụ onyendu usuu ebo Gad. ");
INSERT INTO ibo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Mgbe ahụ, ụmụ Kohat ndị bu ihe nsọ ndị ahụ niile, biliri ije ha. Tutu ha erute, e guzobere ụlọ nzute ahụ nʼebe o kwesiri ịdị. ");
INSERT INTO ibo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Usuu ọmụma ụlọ ikwu ebo Ifrem biliri ije nʼokpuru ọkọlọtọ ha. Elishama nwa Amihud bụ onyendu ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel nwa Pedazo bụ onyendu usuu ebo Manase. ");
INSERT INTO ibo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan nwa Gidiọni bụ onyendu usuu ebo Benjamin. ");
INSERT INTO ibo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Na ngwụsị usoro ahụ, usuu ọmụma ụlọ ikwu ebo Dan biliri ije nʼokpuru ọkọlọtọ ha. Onyendu ha bụ Ahieza nwa Amishadai. ");
INSERT INTO ibo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagịel nwa Okran bụ onyendu usuu ebo Asha. ");
INSERT INTO ibo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira nwa Enan bụ onyendu usuu ebo Naftalị. ");
INSERT INTO ibo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Nke a bụ usoro usuu ụmụ Izrel si bilie ije ha. ");
INSERT INTO ibo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mosis gwara Hobab nwa Reuel, nna nwunye ya onye Midia okwu sị, “Anyị ebiliela ije ịga ebe ahụ Onyenwe anyị gwara anyị sị, ‘Aga m enye unu.’ Bịa ka ị soro anyị. Anyị ga-emezi gị nke ọma nʼihi na Onyenwe anyị ekwela Izrel nkwa ọtụtụ ezi ihe.” ");
INSERT INTO ibo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ma ọ zara sị, “E e, agaghị m eso unu. Ana m alaghachi nʼala nke aka m ịlaghachikwuru ụmụnna m.” ");
INSERT INTO ibo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ma Mosis zara sị ya, “Biko ahapụla anyị nʼihi na ị maara ebe anyị nwere ike kwụsị zuo ike nʼọzara. Ị ga-abụrụ anyị anya anyị ji ahụ ụzọ. ");
INSERT INTO ibo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ọ bụrụ na i soro anyị, anyị ga-ekenye gị ihe ọma ọbụla Onyenwe anyị ga-enye anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ya mere ha sitere nʼugwu Onyenwe anyị bilie ije. Jeekwa ije abalị atọ. Igbe ọgbụgba ndụ Onyenwe anyị na-aga ha nʼihu ụbọchị atọ ndị ahụ niile ịchọtara ha ebe ha ga-akwụsị zuo ike. ");
INSERT INTO ibo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Igwe ojii Onyenwe anyị dị nʼelu ha nʼehihie mgbe ha si nʼọmụma ụlọ ikwu ha bilie ije. ");
INSERT INTO ibo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Mgbe ọbụla igbe ọgbụgba ndụ ahụ biliri ije, Mosis na-ekwu sị, “Bilie O Onyenwe anyị, ka ndị iro ya bụrụ ndị a chụsasịrị; ka ndị iro gị niile site nʼihu gị gbalaga.” ");
INSERT INTO ibo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ma mgbe ọbụla igbe ọgbụgba ndụ bịara ebe izuike, Mosis na-ekwukwa sị, “Lọghachi O Onyenwe anyị, bịakwute ọtụtụ mmadụ ndị a, bụ imerime puku ndị Izrel.” ");
INSERT INTO ibo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mgbe na-adịghị anya ụmụ Izrel bidoro itamu ntamu nʼihi ihe ike niile ha na-ezute nʼije ha. Ma ntamu a ruru Onyenwe anyị ntị. Nʼihi ya, Onyenwe anyị were iwe dị ukwuu megide ha. Ọkụ sitere nʼebe Onyenwe anyị nọ, ree nʼetiti ha, repịa ụfọdụ ndị bi nʼakụkụ ngwụsị ọmụma ụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mgbe nke a mere, ụmụ Izrel tikuru Mosis mkpu akwa. Mosis kpere ekpere nye Onyenwe anyị nʼihi ha, ọkụ ahụ kwụsịkwara. ");
INSERT INTO ibo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nʼihi ya, a kpọrọ ebe ahụ Tabera, nʼihi ọkụ ahụ si nʼebe Onyenwe anyị nọ ree nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ndị amakekwu so ụmụ Izrel nʼije a malitere itamu ntamu banyere nri ndị ọzọ na-agụ ha agụụ. Nke a mere ka ụmụ Izrel malite ịkwa akwa, na-asị, “A sịkwarị na anyị nwere anụ anyị ga-ata. ");
INSERT INTO ibo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Anyị chetara azụ anyị tara nʼIjipt, nke na-adịghị efu anyị ego, ya na kukumba, na melọn, na liik, na ayo na galiik. ");
INSERT INTO ibo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ma ugbu a, anyị enweghịkwa agụụ iri nri, nʼihi na site nʼụbọchị ruo nʼụbọchị, ọ bụ naanị mánà bụ ihe oriri anyị nwere.” ");
INSERT INTO ibo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mánà dịka mkpụrụ kọrianda, na-acha ka eso osisi kpọrọ nkụ. ");
INSERT INTO ibo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ndị Izrel na-ejegharị na-achịkọta ha. Emesịa, ha na-eji nkume e ji akwọ nri na-akwọri ha. Oge ụfọdụ, ha na-eji ikwe nri sụọ ya. Emesịa, ha na-esi ya esi, maọbụ ghee ya eghe. Ọ na-atọ dịka ihe e ji mmanụ oliv ghee. ");
INSERT INTO ibo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Mánà ndị a na-ada mgbe igirigi dara nʼọmụma ụlọ ikwu nʼabalị. ");
INSERT INTO ibo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mosis nụrụ mkpu akwa ụmụ Izrel niile, nke na-ada nʼezinaụlọ ọbụla nʼakụkụ ọnụ ụzọ ụlọ ikwu ha. Iwe were Onyenwe anyị nke ukwuu. Otu a kwa, obi jọrọ Mosis njọ nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mosis jụrụ Onyenwe anyị sị, “Gịnị mere i ji bokwasị ohu gị nsogbu dị otu a nʼisi? Gịnị ka m mere na m ahụtakwaghị amara nʼebe ị nọ, nke mere i ji bukwasị m ibu arọ nke ilekọta ndị a? ");
INSERT INTO ibo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ọ bụ m tụrụ ime ndị a niile? Ọ bụ m mụrụ ha? Gịnị mere i ji si m kuru ha nʼaka m gawa nʼala ahụ ị ṅụrụ nʼiyi inye nna nna ha, dịka m bụ nne nwa na-ekugharị nwantakịrị? ");
INSERT INTO ibo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ebee ka m ga-achọta anụ ga-ezuru igwe mmadụ ndị a? Lee na ha na-akwasa m akwa na-asị m, ‘Nye anyị anụ!’ ");
INSERT INTO ibo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Agaghị m ebulite ibu ịchịkọta ndị a niile nʼonwe m! Ibu a dị m arọ nke ukwuu. ");
INSERT INTO ibo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ọ bụrụ na ị ga-esi otu a meso m mmeso, biko napụ m ndụ m ugbu a, nʼihi na ọnwụ m ga-egosi na m natara amara nʼebe ị nọ. Site nʼọnọdụ a ga-ewetara m mbibi wezuga m.” ");
INSERT INTO ibo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Kpọkọta iri ndị okenye ụmụ Izrel asaa, ndị ị maara na ha bụ ndị ndu, na ndị nlekọta ije ozi nʼetiti ụmụ Izrel. Kpọta ha nʼụlọ nzute m ka ha soro gị guzoro. ");
INSERT INTO ibo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Aga m abịa nʼebe ahụ gwa gị okwu. Mgbe ahụ kwa, aga m ewere ụfọdụ nʼime Mmụọ m dị nʼime gị tinye nʼime iri ndị ndu asaa ahụ. Ha ga-enyere gị aka ibu ibu arọ nke ịchịkọta ụmụ Izrel. Nʼụzọ dị otu a, ọ gaghị abụkwa ibu dịrị naanị gị ibu. ");
INSERT INTO ibo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ugbu a, gwa ndị Izrel niile si ha, ‘Doonụ onwe unu nsọ, kwadoonụ maka echi, mgbe unu ga-ata anụ. Onyenwe anyị nụrụ mgbe unu kwara akwa sị, “A sịkwa na anyị nwere anụ anyị ga-ata. Ihe dịrị anyị mma nʼIjipt karịa otu ọ dị ugbu a.” ");
INSERT INTO ibo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Anụ unu ga-eri abụghị naanị nke otu ụbọchị, maọbụ ụbọchị abụọ, maọbụ ụbọchị ise, maọbụ iri, ma ọ bụkwanụ iri ụbọchị abụọ! ");
INSERT INTO ibo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Kama unu ga-eri ya otu ọnwa zuru ezu, ruo mgbe ọ ga-esi unu nʼimi sọpụta, ghọrọ unu ihe ịsọ oyi. Nʼihi na unu ajụla Onyenwe anyị, onye nọ nʼetiti unu, kwaa akwa nʼihu ya, sị, “Gịnị mere anyị ji site nʼala Ijipt pụta?” ’ ” ");
INSERT INTO ibo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ma Mosis sịrị Onyenwe anyị, “Ọnụọgụgụ ndị ikom dị narị puku isii ndị ji ụkwụ eje ka m nọ nʼetiti ha, ma ị na-asị, ‘Aga m enye ha anụ otu ọnwa.’ ");
INSERT INTO ibo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ọ ga-ezuru ha ma ọ bụrụ na e gbuoro ha igwe ehi na atụrụ? Ọ bụ azụ niile nke dị nʼoke osimiri ga-ezuru ha ma egbuo ha niile nye ha?” ");
INSERT INTO ibo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Onyenwe anyị sịrị Mosis, “Aka Onyenwe anyị ọ dị mkpụmkpụ? Ugbu a, ị ga-ahụ ma m ga-emezu okwu m, maọbụ na m agaghị emezu ya.” ");
INSERT INTO ibo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ya mere, Mosis pụrụ ga gwa ụmụ Izrel ihe Onyenwe anyị kwuru. Ọ chịkọtara iri ndị okenye asaa ahụ nye ha ọnọdụ gburugburu ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mgbe ahụ, Onyenwe anyị rịdatara nʼime igwe ojii. Ya na Mosis kparịtaa ụka. Onyenwe anyị weere ụfọdụ nʼime Mmụọ dị nʼime Mosis, tinye ya nʼime iri ndị okenye asaa ndị ahụ. Mgbe Mmụọ a batara nʼime ha, ha niile buru amụma. Ma ha ebughị amụma gaa nʼihu. ");
INSERT INTO ibo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ma mmadụ abụọ nʼime iri ndị okenye asaa ndị ahụ, Eldad na Medad nọgidere nʼọmụma ụlọ ikwu ha. Ọ bụ ezie na e depụtara aha ha dịka ndị ndu, ma ha esoghị ndị ọzọ gaa nʼụlọ nzute. Ma Mmụọ ahụ bịakwasịrị ha nʼebe ahụ ha nọ. Ha bukwara amụma. ");
INSERT INTO ibo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Otu okorobịa gbapụrụ ọsọ gaa kọọrọ Mosis sị ya, “Eldad na Medad na-ebu amụma nʼọmụma ụlọ ikwu ha.” ");
INSERT INTO ibo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua nwa Nun, onyeozi Mosis site na mgbe ọ bụ okorobịa, gwara Mosis okwu sị ya, “Onyenwe m Mosis, mee ka ndị a kwụsị ibu amụma.” ");
INSERT INTO ibo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Mosis zara sị, “Ọ bụ nʼihi ikwochitara m ekworo ka i ji chọọ ka m kwụsị ha? Ọ gaara atọ m ụtọ ma a sị na ndị Onyenwe anyị niile bụ ndị amụma, ndị Onyenwe anyị ga-etinye Mmụọ ya nʼime ha!” ");
INSERT INTO ibo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mgbe ahụ Mosis na ndị okenye Izrel ndị ahụ niile lọghachiri nʼebe ụlọ ikwu ha dị. ");
INSERT INTO ibo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Otu oke ifufe sitere nʼebe Onyenwe anyị nọ bịa si nʼosimiri bute ọtụtụ nnụnụ a na-akpọ kweel. O mere ka nnụnụ ndị a daa nʼebe ụmụ Izrel mara ụlọ ikwu ha, nʼime ogige ya niile. Nnụnụ ndị a fere ihe dịka otu mita site nʼelu ala, nʼakụkụ niile, ruo nʼebe mmadụ pụrụ iji ụkwụ jeruo nʼotu ụbọchị. Ha jupụtakwara ebe niile. ");
INSERT INTO ibo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ya mere ndị Izrel biliri ụbọchị ahụ niile, na nʼabalị ahụ niile, na echi ya niile pụọ ịchịkọta nnụnụ kweel ndị a! Onye gbutere nke nta gbutezuru ihe ọtụtụ homa iri. Ha gbasara ha akụkụ niile nke ogige ọmụma ụlọ ikwu ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ma mgbe anụ ndị a ka dị ha nʼọnụ, Onyenwe anyị were iwe dị ukwuu megide ha. O tiri ha nrịa nrịa na-efe efe. ");
INSERT INTO ibo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nʼihi nke a, a kpọrọ aha ebe ahụ Kibrọt Hataava, nʼihi na nʼebe ahụ ka e liri ndị Izrel nwụrụ nʼihi oke ọchịchọ nri. ");
INSERT INTO ibo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Site na Kibrọt Hataava, ndị Izrel biliri njem rute Hazerọt ebe ha nọrọ. ");
INSERT INTO ibo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam na Erọn malitere ikwu okwu megide Mosis, nʼihi na ọ lụrụ nwunye onye Kush. ");
INSERT INTO ibo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ha kwuru sị, “Ọ bụ naanị site nʼọnụ Mosis ka Onyenwe anyị si agwa ndị ya okwu? Ọ naghị esitekwa nʼọnụ anyị kwuo okwu?” Onyenwe anyị nụrụ ihe ndị a ha kwuru. ");
INSERT INTO ibo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Ma nwoke ahụ bụ Mosis dị umeala nʼobi nke ukwuu karịa onye ọbụla nọ nʼelu ala.) ");
INSERT INTO ibo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Na mberede, Onyenwe anyị sịrị Mosis, na Erọn, na Miriam, “Pụtanụ, bịa nʼụlọ nzute, unu mmadụ atọ” Ya mere ha atọ pụtara. ");
INSERT INTO ibo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mgbe ahụ, Onyenwe anyị rịdatara nʼime igwe ojii, guzoro na mbata ọnụ ụzọ ụlọ nzute ahụ, kpọpụta Erọn na Miriam. Mgbe ha abụọ bịara nso. ");
INSERT INTO ibo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Onyenwe anyị gwara ha sị, “Geenụ ntị nʼokwu m ndị a: “Mgbe onye amụma nọ nʼetiti unu, Mụ onwe m bụ Onyenwe anyị na-egosi ya onwe m site nʼọhụ. Ana m agwa ya okwu site na nrọ. ");
INSERT INTO ibo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ma nʼebe ohu m Mosis nọ, o sighị otu a dịrị, ọ bụ onye kwesiri ntụkwasị obi nʼụlọ m niile. ");
INSERT INTO ibo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nʼebe ọ nọ, ana m agwa ya okwu ihu na ihu nʼụzọ doro anya, ọ bụghị site nʼilu, ọ na-ahụkwa ụdịdị Onyenwe anyị. Gịnị mere ụjọ atụghị unu ikwu okwu megide ohu m Mosis?” ");
INSERT INTO ibo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mgbe ahụ, Onyenwe anyị were iwe dị ọkụ megide ha. O si nʼebe ha nọ pụọ. ");
INSERT INTO ibo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ma mgbe igwe ojii ahụ hapụrụ ụlọ nzute ahụ, lee Miriam ebe o guzo, ekpenta tiwapụtara ya nʼahụ dịka nzu ọcha. Mgbe Erọn tụgharịrị ebe ọ nọ hụ na ọ ghọọla onye ekpenta, ");
INSERT INTO ibo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ọ gwara Mosis okwu sị, “Biko, onyenwe m, atala anyị ahụhụ nʼihi mmehie anyị sitere na nzuzu mee. ");
INSERT INTO ibo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ekwela ka Miriam dịrị ka nwa ọhụrụ nwụrụ anwụ nke akpụkpọ ahụ ya rere ure nʼoge o si nʼakpanwa nne ya na-apụta.” ");
INSERT INTO ibo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ya mere Mosis tikuru Onyenwe anyị mkpu akwa sị ya, “Chineke, biko, gwọọ ya!” ");
INSERT INTO ibo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ma Onyenwe anyị zara Mosis sị ya, “Ọ bụrụ na nna ya gbụrụ ya asụ nʼihu, ọ gaghị abụ onye rụrụ arụ abalị asaa? Ya mere, hapụ ya ka ọ bụrụ onye e sitere nʼogige ọmụma ụlọ ikwu Izrel wezuga abalị asaa. Mgbe oge a gafesịrị, o nwere ike ịlọghachi.” ");
INSERT INTO ibo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ya mere e wezugara Miriam site nʼogige ọmụma ụlọ ikwu Izrel abalị asaa. Ndị Izrel niile nọdụrụ chere ya ruo mgbe ọ lọghachiri, tutu ha ebilie nʼije ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Mgbe ihe ndị a gasịrị, ha hapụrụ Hazerọt rute nʼọzara Paran ebe ha wuru ogige ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ziga ụfọdụ ndị ikom ka ha gaa legharịa anya nʼala Kenan, ala ahụ m na-enye Izrel. Ziga mmadụ iri na abụọ, otu onyendu site nʼebo Izrel ọbụla.” ");
INSERT INTO ibo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ya mere, dịka iwu Onyenwe anyị nyere ya si dị, Mosis zipụrụ ha site nʼọzara Paran. Ha niile bụ ndị ndu nʼetiti ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Nke a bụ aha ha: Site nʼebo Ruben, Shamua nwa Zakua, ");
INSERT INTO ibo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shafat nwa Hori, onye si nʼebo Simiọn. ");
INSERT INTO ibo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb nwa Jefune, onye si nʼebo Juda. ");
INSERT INTO ibo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal nwa Josef, onye si nʼebo Isaka. ");
INSERT INTO ibo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hoshea nwa Nun, onye si nʼebo Ifrem ");
INSERT INTO ibo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti nwa Rafu, onye si nʼebo Benjamin. ");
INSERT INTO ibo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel nwa Sodi, onye si nʼebo Zebụlọn. ");
INSERT INTO ibo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi nwa Susi, onye sitere nʼebo Manase (ya bụ ebo Josef). ");
INSERT INTO ibo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel nwa Gemali, onye si nʼebo Dan. ");
INSERT INTO ibo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setua nwa Maikel, onye si nʼebo Asha. ");
INSERT INTO ibo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nabi nwa Vofusi, onye si nʼebo Naftalị. ");
INSERT INTO ibo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel nwa Maki, onye si nʼebo Gad. ");
INSERT INTO ibo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ndị a bụ aha ndị ikom ndị ahụ Mosis zipụrụ inyocha ala ahụ. (Ọ bụ nʼoge a ka Mosis gbanwere aha Hoshea nwa Nun, ka ọ bụrụ Joshua.) ");
INSERT INTO ibo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mosis zipụrụ ha ịga ledoo ala Kenan, ọ sịrị, “Gbagoonụ site nʼụzọ Negev gakwanụ nʼala ugwu ugwu. ");
INSERT INTO ibo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Letanụ otu ala ahụ dị. Chọpụtanụ ụdị ndị bi nʼime ya, ma ha dị ike ma ha bụ ndị na-adịghị ike, ma ha dị ọtụtụ ma ha dị ole na ole. ");
INSERT INTO ibo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Letanụ ụdị ala ha bi nʼime ya, ma ọ dị mma ma ọ jọrọ njọ. Chọpụtanụ ụdị obodo dị nʼebe ahụ, ma ha bụ obodo mgbidi na-adịghị gburugburu ha, ma ha bụ obodo e wusiri ike. ");
INSERT INTO ibo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Letanụ otu ala ahụ dị. Ọ na-epupụta ihe ka ọ bụ ala ụkpa? Letanụ ma ha nwere ọtụtụ osisi ka ọ bụ na osisi adịghị nʼime ya. Gbalịanụ ka unu weta ụfọdụ nʼime mkpụrụ osisi dị nʼala ahụ.” (Ọ bụ oge mkpụrụ mbụ nke osisi vaịnị.) ");
INSERT INTO ibo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ya mere ndị a gara ledoo ala ahụ anya site nʼọzara Zin ruo na Rehob, nke dị nso na Lebo Hamat. ");
INSERT INTO ibo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ha gara site na Negev rute Hebrọn, ebe Ahiman na Sheshai na Talmai, ụmụ ụmụ Anak bi. (Ma ewuru Hebrọn afọ asaa tupu e wuo obodo Zoan dị nʼIjipt.) ");
INSERT INTO ibo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Mgbe ha rutere Ndagwurugwu Eshkọl, ha gbutere otu alaka osisi vaịnị nke nwere ụyọkọ mkpụrụ vaịnị. Mmadụ abụọ butere ya nʼosisi tinyere ụfọdụ mkpụrụ osisi pomegranet na fiig. ");
INSERT INTO ibo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","A kpọrọ ebe ahụ Ndagwurugwu Eshkọl, nʼihi ụyọkọ mkpụrụ osisi vaịnị ndị Izrel gbutere nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Mgbe iri abalị anọ gasịrị, ndị nledo a sitere nʼije ha lọghachi. ");
INSERT INTO ibo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ha lọtara bịakwute Mosis na Erọn na nzukọ niile nke ụmụ Izrel, na Kadesh nke dị nʼọzara Paran. Ndị nledo ahụ kọrọ akụkọ otu ha si gaa nʼọgbakọ ụmụ Izrel niile. Gosikwa mkpụrụ osisi si nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nke a bụ akụkọ ha kọọrọ Mosis, “Anyị ruru nʼala ahụ ị sị anyị gaa leta. Ọ bụkwa ala mmiri ara ehi na mmanụ aṅụ na-eru na ya. Ndị a bụ mkpụrụ osisi si nʼala ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ma ndị bi nʼobodo ahụ siri ike. Obodo ha buru ibu bụrụkwa nke e wusiri ike. Anyị hụkwara ụmụ ụmụ Anak nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ndị Amalek bi na Negev, ndị Het na ndị Jebus na ndị Amọrait bi nʼala ugwu ugwu. Ma nʼakụkụ osimiri Mediterenịan na ndagwurugwu mmiri Jọdan ka ndị Kenan bi.” ");
INSERT INTO ibo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ma Kaleb kwuru okwu mere ka obi sie ndị Izrel ike nʼoge a ha guzoro nʼihu Mosis sị ha, “Ka anyị gaanụ otu ihu nweta ala ahụ. Nʼihi na anyị nwere ike imeri ha.” ");
INSERT INTO ibo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ma ndị nledo ahụ soro ya gaa zara sị, “Anyị enweghị ike ibu agha megide ndị a; ha dị ike karịa anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ndị a gbasara akụkọ ọjọọ nʼetiti ụmụ Izrel banyere ala ahụ ha gara ledoo. Ha sịrị, “Ala ahụ anyị gara ledoo anya bụ ala na-eripịa ndị bi nʼime ya. Ndị niile anyị hụrụ nʼebe ahụ gbara nnọọ dimkpa ");
INSERT INTO ibo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Anyị hụrụ ndị Nefilim nʼebe ahụ (ndị bụ ụmụ ụmụ Anak, ndị sitere na ndị Nefilim). Nʼanya anyị, anyị dịka ụkpana nʼebe ha nọ, otu a ka anyị dịkwa nʼanya ha.” ");
INSERT INTO ibo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nʼabalị ahụ, ọgbakọ Izrel niile weliri olu ha bido iti mkpu akwa. Ha kwagidere akwa a abalị niile. ");
INSERT INTO ibo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ndị Izrel niile tamuru ntamu megide Mosis na Erọn. Ọgbakọ ahụ niile sị ha, “Ọ gaara aka mma ma a sị na anyị nwụrụ nʼala Ijipt maọbụ nʼọzara a. ");
INSERT INTO ibo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Gịnị mere Onyenwe anyị ji akpọbata anyị nʼala a ime ka anyị daa nʼihu mma agha. Ndị nwunye anyị na ụmụ anyị ga-aghọ ndị a dọtara nʼagha. Ọ garaghị akara anyị mma ịlaghachi azụ nʼIjipt?” ");
INSERT INTO ibo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ya mere ha kwekọrịtara nʼetiti onwe ha sị, “Ka anyị họpụtaranụ onwe anyị onyendu ga-edughachi anyị azụ nʼIjipt.” ");
INSERT INTO ibo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mgbe ahụ, Mosis na Erọn dara kpuo ihu nʼala nʼihu ọgbakọ ndị Izrel niile zukọtara nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Mmadụ abụọ nʼime ndị nledo ahụ, Joshua nwa Nun na Kaleb nwa Jefune, dọwara uwe ha. ");
INSERT INTO ibo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ha gwara nzukọ Izrel sị, “Ala ahụ anyị gara ledoo anya bụ ala mara mma. ");
INSERT INTO ibo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ọ bụrụ na ihe banyere anyị na-atọ Onyenwe anyị ụtọ, ọ ga-edu anyị bata nʼala ahụ, ala mmiri ara ehi na mmanụ aṅụ na-eru na ya. ");
INSERT INTO ibo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Unu enupukwala isi megide Onyenwe anyị. Unu atụkwala egwu ndị bi nʼime ala ahụ, nʼihi na anyị ga-emeri ha. Onyenwe anyị nọnyeere anyị. O wepụkwala aka nchebe ya nʼahụ ha. Unu atụla egwu ha.” ");
INSERT INTO ibo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ma naanị nzaghachi ọgbakọ ndị Izrel nyere nʼihi okwu nkasiobi ndị a bụ iche uche otu ha ga-esi jiri nkume tugbuo Joshua na Kaleb. Nʼoge a, ebube Onyenwe anyị pụtara ihe nʼụlọ nzute ahụ nye ndị Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Onyenwe anyị gwara Mosis okwu sị, “Ruo ole mgbe ka ndị a ga-anọgide na-eleda m anya? Ruo ole mgbe ka ha ga-anọ ju ikwenye na m, nʼagbanyeghị ọtụtụ ihe ịrịbama nke m mere nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Aga m eji nrịa nrịa nke na-efe efe tigbuo ha. Napụ ha ihe ha nwere. Ma aga m emekwa gị ka ị ghọọ mba dị ukwuu, nke ga-adị ukwuu, dịkwa ike karịa ha.” ");
INSERT INTO ibo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ma Mosis rịọrọ Onyenwe anyị sị ya, “Gịnị ka ndị Ijipt ga-eche banyere nke a, mgbe ha ga-anụ ya? Ha maara nke ọma otu ị sịrị jiri ike gị napụta ndị a site nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ha agwakwala ndị bi nʼobodo ndị a ihe banyere ya. Ndị obodo ndị a anụla ihe banyere gị Onyenwe anyị, matakwa na ị nọnyeere Izrel, na gị bụ Onyenwe anyị na ndị Izrel na-ekwurịta okwu ihu na ihu. Ha anụkwala na ogidi igwe ojii gị Onyenwe anyị na-eguzo nʼelu, nʼisi anyị. Ha matakwara na ị na-edu anyị nʼime ogidi igwe ojii nʼehihie, na nʼime ogidi na-enwu ọkụ nʼabalị. ");
INSERT INTO ibo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ma ugbu a, ọ bụrụ na i gbusie ndị gị a dum, mba niile nụrụla akụkọ ndị a banyere gị ga-asị, ");
INSERT INTO ibo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Onyenwe anyị enweghị ike ịkpọbata ndị a nʼala ahụ o kwere nkwa inye ha. Ọ bụ ya mere o ji gbuo ha nʼọzara.’ ");
INSERT INTO ibo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Ugbu a ka Onyenwe anyị gosi ike ya dị ukwuu, dịka i si kwuo. ");
INSERT INTO ibo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Onyenwe anyị bụ onye na-adịghị ewe iwe ọsịịsọ, onye jupụtara nʼịhụnanya, onye na-agbaghara mmehie na nnupu isi. Ma ọ dịghị ahapụ onye ikpe mara ka ọ laa na-anataghị ahụhụ, ọ na-ata ụmụ ahụhụ nʼihi mmehie nna nna ha ruo nʼọgbọ nke atọ na nke anọ. ");
INSERT INTO ibo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Dịka ịdị ukwuu nke ịhụnanya gị si dị; gbaghara mmehie nke ndị a mere, dịka i si agbaghara ha kemgbe ha hapụrụ Ijipt ruo ugbu a.” ");
INSERT INTO ibo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mgbe ahụ, Onyenwe anyị zaghachiri Mosis sị ya, “Agbagharala m ha dịka ị rịọrọ. ");
INSERT INTO ibo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ma dịka m na-adị ndụ na dịka ọ bụ eziokwu na ụwa niile ga-ejupụta nʼebube Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ọ dịghị otu onye nʼetiti ndị ikom niile hụrụla ebube m, na ọrụ ịrịbama niile m rụrụ nʼime Ijipt, na nʼime ọzara a, ma bụrụ onye nupuru isi nye m na onye nwaara m ugboro iri ndị a, ");
INSERT INTO ibo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","o nweghị onye ọbụla nʼime ha ga-ahụ ala ahụ m sitere nʼịṅụ iyi kwee nkwa inye nna nna ha. O nweghị onye ọbụla nʼime ndị a lelịrị m ga-ahụ ala ahụ anya. ");
INSERT INTO ibo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ma ohu m nwoke Kaleb bụ nwoke nwere mmụọ dị iche. O rubeere m isi nʼihe niile. Aga m akpọbata ya nʼala ahụ ọ banyere dịka onye nledo. Ụmụ ụmụ ya niile ga-eketa ya. ");
INSERT INTO ibo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ma ugbu a, ebe ndị Izrel na-atụ ndị Amalek na ndị Kenan bi nʼime ndagwurugwu ahụ egwu, echi, unu ga-atụgharịa laghachi azụ nʼọzara ahụ; chee ụzọ gaje Osimiri Uhie ahụ ihu.” ");
INSERT INTO ibo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Onyenwe anyị gwara Mosis na Erọn okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ruo ole mgbe ka ọgbakọ ọjọọ a ga-anọgide na-atamu ntamu megide m? Nʼihi na anụla m ntamu niile nke ndị Izrel a. ");
INSERT INTO ibo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Gwa ha si, ‘Dị ka m na-adị ndụ, ka Onyenwe anyị kwubiri, aga m emeso unu mmeso dịka unu kwunyere ya na ntị m. ");
INSERT INTO ibo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Unu niile ga-anwụpịa nʼime ọzara a! Onye ọbụla nʼime unu niile gbarala iri afọ abụọ maọbụ karịa, nke tamuru ntamu megide m. ");
INSERT INTO ibo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","O nweghị onye ọbụla nʼime unu ga-abanye nʼala ahụ, m sitere nʼaka m welie elu ṅụọ iyi ime ka ọ bụrụ ebe obibi unu, karịa Kaleb nwa Jefune na Joshua nwa Nun. ");
INSERT INTO ibo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ma ebe unu tụrụ egwu sị na ụmụ unu na-aga ibu ndị ohu nye ndị bi nʼala ahụ. Lee na aga m edubata ha nʼime ala ahụ. Ha ga-eketakwa ala ahụ unu jụrụ, nke unu ledara anya. ");
INSERT INTO ibo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ma unu onwe unu, ozu unu ga-ada aghara aghara nʼọzara a. ");
INSERT INTO ibo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ụmụ unu ga-abụkwa ndị ọzụzụ atụrụ nʼime ọzara a iri afọ anọ, na-ata ahụhụ nʼihi ekwesighị ntụkwasị obi, ruo mgbe ozu onye ikpeazụ nʼime unu ga-atọgbọrọ nʼime ọzara. ");
INSERT INTO ibo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Iri afọ anọ ka unu ga-ata ahụhụ nʼihi mmehie unu, matakwa ihe ọ pụtara bụ mụ iguzo megide unu, ya bụ otu afọ ga-anọchi otu ụbọchị nʼime iri ụbọchị anọ ahụ unu ji ledoo ala ahụ anya. ");
INSERT INTO ibo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mụ onwe m, bụ Onyenwe anyị, ekwuola ya. Nke a ka m na-aghaghị ime ka ọ dakwasị ajọ nzukọ ndị a, bụ ndị gbakọrọ megide m. Ha ga-ezute ọgwụgwụ ha nʼọzara, nʼebe a ka ha ga-anwụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ya mere ndị ahụ Mosis zipụrụ iledo ala ahụ, ndị ahụ lọtara mee ka ọgbakọ ụmụ Izrel tamuo ntamu nʼihi akụkọ ọjọọ ha gbasara. ");
INSERT INTO ibo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ndị ikom ndị ahụ e si nʼọnụ ha gbasaa akụkọ ọjọọ banyere ala ahụ, ka e ji nrịa nrịa na-efe efe tigbuo nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nʼime ndị ikom gara ledoo ala ahụ anya, ọ bụ naanị Joshua nwa Nun na Kaleb nwa Jefune fọdụrụ ndụ. ");
INSERT INTO ibo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mgbe Mosis gwara ụmụ Izrel okwu niile si nʼọnụ Onyenwe anyị, ha ruru ụjụ dị ilu. ");
INSERT INTO ibo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nʼisi ụtụtụ echi ya, ha biliri nʼoge bulie ije ịga nʼala ugwu ugwu ahụ. Ha sịrị, “Anyị emehiela. Ugbu a anyị ejikerela ije nʼala ahụ Onyenwe anyị kwere anyị nkwa.” ");
INSERT INTO ibo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ma Mosis zara sị ha, “Gịnị mere unu ji enupu isi nʼiwu Onyenwe anyị nyere? Nke a agaghị aga nke ọma. ");
INSERT INTO ibo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Unu arịgokwala, nʼihi na Onyenwe anyị anọghị nʼetiti unu. Ndị iro unu ga-emerikwa unu. ");
INSERT INTO ibo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nʼihi na ndị Amalek na ndị Kenan nọ na-eche unu nʼebe ahụ! Ebe ọ bụ na unu esitela nʼebe Onyenwe anyị nọ wezuga onwe unu, ọ gaghị anọnyere unu, unu ga-adakwa nʼihu mma agha.” ");
INSERT INTO ibo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nʼagbanyeghịkwa nke a, na ha enweghị nkwado. Ha rigooro ruo ebe kachasị elu nʼobodo ahụ dị nʼugwu, ọ bụ ezie na Mosis maọbụ igbe ọgbụgba ndụ Onyenwe anyị esighị nʼọmụma ụlọ ikwu ahụ pụọ. ");
INSERT INTO ibo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Mgbe ahụ, ndị Amalek na ndị Kenan bụ ndị bi nʼobodo ugwu ahụ, rịdatara lụso ha ọgụ. Tidaa ha nʼala ruo Homa. ");
INSERT INTO ibo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Gwa ụmụ Izrel okwu sị ha, ‘mgbe unu batara ala ahụ m na-enye unu dịka ụlọ unu, ");
INSERT INTO ibo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ọ bụrụ na unu echee nʼihu Onyenwe anyị aja nsure ọkụ nke isisi ya dị ụtọ nye Onyenwe anyị, maọbụ nke si nʼigwe ehi, maọbụ nke si nʼigwe ewu na atụrụ, maọbụ aja nsure ọkụ, maọbụ aja ndị ọzọ, maka imezu nkwa pụrụ iche maọbụ onyinye afọ ofufu, maọbụ aja mmemme. ");
INSERT INTO ibo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Onye wetara onyinye a aghaghị iweta nʼihu Onyenwe anyị aja mkpụrụ ọka nke bụ ezi ụtụ ọka ruru lita abụọ nke e ji mmanụ ruru otu lita gwakọtaa. ");
INSERT INTO ibo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ọ ga-eweta otu lita mmanya dịka onyinye ihe ọṅụṅụ maka nwa atụrụ ọbụla e ji chụọ aja nsure ọkụ maọbụ aja ụzọ. ");
INSERT INTO ibo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Ọ bụrụ nwa ebule ka e ji achụ aja ahụ, weta lita ezi ụtụ ọka anọ na ọkara, nke a gwakọtara ya na mmanụ jitụ ntakịrị karịa otu lita, ");
INSERT INTO ibo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","tinyekwa ya mmanya jitụ ihe nta karịa otu lita ka ọ bụrụ onyinye ihe ọṅụṅụ nye ha, dịka aja nke isisi ya dị ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Mgbe i ji nwa oke ehi chụọ aja nsure ọkụ, maọbụ aja imezu nkwa, maọbụ aja udo nye Onyenwe anyị, ");
INSERT INTO ibo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","tinyere oke ehi ahụ, ị ghaghị iji ezi ụtụ ọka ruru lita isii na ọkara, nke a gwakọtara ya na mmanụ ruru lita abụọ. ");
INSERT INTO ibo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Wetakwa lita mmanya abụọ nke ga-abụ onyinye ihe ọṅụṅụ. Ọ ga-abụ onyinye e sitere nʼọkụ nye, nke isisi ya dị ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Nke a bụ usoro a ga-agbaso nʼoge ọbụla e ji nwa oke ehi, maọbụ nwa ebule, maọbụ nwa atụrụ, maọbụ nwa ewu chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Meenụ ya maka anụ ụlọ ọbụla nʼoge niile ọbụla unu na-achụ aja. ");
INSERT INTO ibo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Onye ọbụla bụ nwa afọ ala aghaghị ime ihe ndị a mgbe ọbụla o wetara onyinye e sitere nʼọkụ nye dịka onyinye isisi ya dị ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nʼọgbọ niile na-abịa, mgbe ọbụla onye ọbịa, maọbụ onye ọzọ bi nʼetiti unu wetara onyinye e sitere nʼọkụ nye, nke isisi ya dị ụtọ nye Onyenwe anyị, ọ ghaghị ịgbaso ụzọ a nye onyinye ya. ");
INSERT INTO ibo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ọgbakọ ụmụ Izrel ga-enwe otu iwu ga-adịrị unu na ndị ọbịa bi nʼetiti unu. Nke a bụ ụkpụrụ ebighị ebi ga-adịrị ọgbọ niile na-abịa. Unu na ndị ọbịa ga-abụ otu nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Otu iwu na otu ụkpụrụ bụ ihe ga-adịrị onye ọbụla, diala na ndị ọbịa bi nʼetiti unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Gwa ndị Izrel okwu sị ha, ‘mgbe unu banyere nʼala ahụ m na-akpọbata unu nʼime ya, ");
INSERT INTO ibo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ọ bụrụ na unu erie nri dị nʼala ahụ, wetanụ ụfọdụ nʼime nri ahụ dịka onyinye nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Wetanụ ogbe achịcha site nʼọka mbụ unu ga-akwọ, chee ya nʼihu Onyenwe anyị dịka onyinye e wetara site nʼebe ịzọcha ọka. ");
INSERT INTO ibo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Unu aghaghị inye Onyenwe anyị onyinye a sitere nʼọka mbụ ọbụla unu kwọrọ, site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Ọ bụrụ na unu amaghị ama ghara idebe iwu ndị a niile Onyenwe anyị nyere site nʼaka Mosis, ");
INSERT INTO ibo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","bụ iwu ndị a niile Onyenwe anyị nyere unu site nʼaka Mosis, site nʼụbọchị ahụ Onyenwe anyị nyere ha ruo nʼọgbọ niile nke na-abịa. ");
INSERT INTO ibo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Ọ bụrụ na e mere ya na-amaghị ama, ọ bụrụ na ọgbakọ ụmụ Izrel amaghị ama mee ya, mgbe ahụ, ọgbakọ ụmụ Izrel ga-eji nwa oke ehi chụọ aja nsure ọkụ, aja na-esi isi ụtọ nke Onyenwe anyị na-anabata. Aghaghị iwetakwa mkpụrụ ọka, na onyinye ihe ọṅụṅụ nke ya na aja ahụ so, tinyere otu mkpi maka aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Onye nchụaja ga-ekpuchitere nzukọ Izrel niile mmehie ha. A ga-agbagharakwa ha mmehie ha niile, nʼihi na ọ bụ mmehie ha mere na-amaghị ama. Ha e cheela nʼihu Onyenwe anyị aja onyinye nri nʼihi amaghị ama ha ya na aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","A ga-agbaghara nzukọ Izrel niile na ndị ọbịa nọ nʼetiti ha mmehie ha, nʼihi na mmadụ ndị a niile akpachaghị anya mehie. ");
INSERT INTO ibo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Ọ bụrụ na ọ bụ naanị otu onye mehiere na-amaghị ama, ọ ga-eweta nwa nne ewu gbara otu afọ maka aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Onye nchụaja a ga-eji ya chụọ aja ikpuchitere onye ahụ na-amaghị ama mehie mmehie ya nʼihu Onyenwe anyị. Mgbe ekpuchichara mmehie ya, a ga-agbaghara onye ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ọ bụ otu iwu a dịrị onye ọbụla mehiere na-amaghị ama, maọbụ nwa afọ Izrel, maọbụ onye ọbịa nke bi nʼetiti unu. ");
INSERT INTO ibo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Ma onye ọbụla kpachapụrụ anya mehie, maọbụ nwa afọ maọbụ onye ọbịa, nke na-ekwulu Onyenwe anyị, a ga-ebipụ onye dị otu a site nʼetiti ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nʼihi na ha eledala okwu Onyenwe anyị anya, mebie ihe o nyere nʼiwu. A ghaghị ibipụ onye dị otu a, mmehie ha ga-adịkwa ha nʼisi.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Mgbe ụmụ Izrel nọ nʼọzara, e jidere otu onye nʼime ha ka ọ na-akpa nkụ nʼụbọchị izuike. ");
INSERT INTO ibo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ndị hụrụ ya ebe ọ na-akpa nkụ duuru ya jekwuru Mosis na Erọn na ọgbakọ ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ha tinyere ya nʼụlọ mkpọrọ nʼihi na o doghị anya ihe e kwesiri ime ya. ");
INSERT INTO ibo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Nwoke a ghaghị ịnwụ. Ọgbakọ Izrel niile ga-atụ ya nkume nʼazụ obodo.” ");
INSERT INTO ibo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ya mere, ọgbakọ ahụ kpọpụrụ ya nʼazụ obodo jiri nkume tugbuo ya, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Gwa ụmụ Izrel okwu sị ha, ‘Nʼọgbọ niile na-abịa unu ga-adụnye eriri akwa nʼọnụ ala ala uwe unu. Unu ga-eji eriri na-acha anụnụ anụnụ dụnye ya. ");
INSERT INTO ibo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Eriri akwa ndị a dị nʼọnụ ọnụ uwe unu ga-eme ka unu cheta iwu niile Onyenwe anyị nyere unu. Ka unu rube isi na ha hapụ imerụ onwe unu site na ịgbaso ihe ọjọọ niile na-agụ obi unu na anya unu. ");
INSERT INTO ibo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mgbe ahụ unu ga-echeta irube isi nʼiwu m niile, bụrụ ndị e doro nsọ nye Chineke unu. ");
INSERT INTO ibo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Abụ m Onyenwe anyị Chineke unu, onye si nʼala Ijipt kpọpụta unu ịbụ Chineke unu. Abụ m Onyenwe anyị Chineke unu.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ugbu a, Kora nwa Izha, nwa Kohat, nwa Livayị, na ụfọdụ ndị agbụrụ Ruben bụ Datan, na Abiram ụmụ Eliab, na On, nwa Pelet nupuru isi ");
INSERT INTO ibo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","bilie imegide Mosis. Ndị so ha bụ narị ndị ikom abụọ na iri ise, ndị ndu a maara nke ọma, ndị so nọdụ nʼụlọ nzukọ ukwuu ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ha kpọrọ ọgbakọ imegide Mosis na Erọn sị ha, “Omume unu agafeela oke! Ọgbakọ Izrel dị nsọ, onye ọbụla nʼime ha kwa. Onyenwe anyị nọnyeere ha. Gịnị mere unu ji ebuli onwe unu elu karịa ọgbakọ Onyenwe anyị?” ");
INSERT INTO ibo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mgbe Mosis nụrụ ihe ndị a ha kwuru, ọ dara nʼala kpuo ihu ya nʼala. ");
INSERT INTO ibo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Mgbe ahụ, ọ gwara Kora na ndị niile sonyeere ya, sị, “Nʼụtụtụ echi, Onyenwe anyị ga-eme ka amara ndị bụ ndị ya na onye dị nsọ. Ọ ga-eme ka onye ahụ bịaruo ya nso. Onye ọ ga-ahọpụta ka ọ ga-emekwa ka ọ bịaruo ya nso. ");
INSERT INTO ibo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Lee ihe ị ga-eme, Echi gị onwe gị Kora, na ndị niile nọnyeere gị, chịrịnụ ihe ịgụ ọkụ, ");
INSERT INTO ibo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","mụnye ha ọkụ. Tinyekwanụ ụda na-esi isi ụtọ nʼime ha, were ha bịa nʼihu Onyenwe anyị. Onye ahụ Onyenwe anyị họpụtara ga-abụ onye ahụ dị nsọ. O zuorola unu, unu ụmụ Livayị!” ");
INSERT INTO ibo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mgbe ahụ, Mosis gwakwara Kora okwu ọzọ sị ya, “Ugbu a, geenụ ntị, unu ndị Livayị! ");
INSERT INTO ibo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ọ bụ ihe dị nta nʼanya unu na Chineke nke Izrel kewapụtara unu site na nzukọ ndị Izrel niile, mee ka unu bịaruo ya nso, nʼihi ije ozi nʼụlọ nzute Onyenwe anyị, nakwa iguzo nʼihu nzukọ Izrel niile ijere ha ozi? ");
INSERT INTO ibo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ọ kpọbatala gị na ndị Livayị ibe gị nso ebe ọ nọ. Ugbu a, unu na-achọkwa ọrụ nchụaja? ");
INSERT INTO ibo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ọ bụ Onyenwe anyị ka gị na ndị sonyeere gị gbara izu megide. Onye ka Erọn bụ unu ji atamu ntamu megide ya?” ");
INSERT INTO ibo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mgbe ahụ, Mosis ziri ozi ka a kpọọ Datan na Abiram, ụmụ ndị ikom Eliab, ma ha sịrị, “Anyị agaghị abịa. ");
INSERT INTO ibo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ọ bụ na o zurughị gị na i si nʼala Ijipt ebe mmiri ara ehi na mmanụ aṅụ na-eru kpọpụta anyị igbuchapụ anyị nʼọzara a? Ugbu a ị chọkwara ime onwe gị onyenwe anyị? ");
INSERT INTO ibo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nke kachasị nke, ị kpọbatabeghị anyị nʼala mmiri ara ehi na mmanụ aṅụ na-eru na ya. I nyebeghị anyị ihe nketa ala ubi na ubi vaịnị. Ị chọrọ ịghụpụsị ndị ikom ndị a mkpụrụ anya? Anyị agaghị abịa!” ");
INSERT INTO ibo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mgbe ahụ, oke iwe were Mosis. Ọ kpọkuru Onyenwe anyị sị ya, “Anabatakwala aja ha niile! Ọ dịbeghị oge m naara ha ihe ọbụla, ọbụladị otu ịnyịnya ibu! O nwekwaghị onye ọbụla nʼime ha m mejọrọ.” ");
INSERT INTO ibo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mgbe ahụ, Mosis sịrị Kora, “Echi, gị na ndị na-esonyere gị ga-apụta bịa nʼihu Onyenwe anyị. Erọn ga-abịakwa. ");
INSERT INTO ibo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Nwoke ọbụla ga-eweta ihe ịgụ ọkụ nke ya, tinye ya ụda na-esi isi ụtọ, chee ha nʼihu Onyenwe anyị. Ha niile dị ihe ịgụ ọkụ narị abụọ na iri ise. Gị na Erọn ga-ejikwa nke unu bịa.” ");
INSERT INTO ibo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ya mere, nwoke ọbụla wetara ihe ịgụ ọkụ nke ya, mụnye ya ọkụ, ma tinye ya ụda na-esi isi ụtọ. Ha niile guzoro nʼọnụ ụzọ ụlọ nzute ahụ, ha na Mosis na Erọn. ");
INSERT INTO ibo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mgbe Kora kpọkọtara ndị na-eso ya imegide Mosis na Erọn nʼihu ọnụ ụzọ ụlọ nzute, ebube Onyenwe anyị pụtara ihe nye ọgbakọ Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Onyenwe anyị gwara Mosis na Erọn okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Sitenụ nʼetiti ọgbakọ ndị a pụọ, ka m bibie ha nʼotu ntabi anya.” ");
INSERT INTO ibo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ma Mosis na Erọn dara kpuo ihu nʼala nʼihu Onyenwe anyị rịọọ ya sị, “O Chineke, gị bụ Chineke nwe ndụ mmadụ niile, ị ga-ewe iwe megide nzukọ niile nʼihi mmehie otu onye?” ");
INSERT INTO ibo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ma Onyenwe anyị zara Mosis sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Gwa nzukọ Izrel niile sị ha, ‘Wezuganụ onwe unu site nʼụlọ ikwu Kora, Datan na Abiram.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mosis biliri jekwuru Datan na Abiram, ndị okenye Izrel sokwa Mosis. ");
INSERT INTO ibo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mgbe Mosis ruru nʼebe ahụ, ọ dọrọ nzukọ Izrel aka na ntị sị, “Ngwa, sinụ nʼụlọ ndị ọjọọ a wezuga onwe unu. Unu ebitụkwala ihe ọbụla bụ nke ha aka. Ma ọ bụghị otu a, a ga-agụnyekọ unu na mmehie ha, lakọọ unu na ha nʼiyi.” ");
INSERT INTO ibo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ya mere mmadụ niile wezugara onwe ha site nʼọmụma ụlọ ikwu Kora, na Datan na Abiram. Ma Datan na Abiram pụtara guzoro nʼọnụ ụzọ ụlọ ikwu ha, ha onwe ha na ndị nwunye ha niile, na ụmụ ha niile, na ụmụntakịrị ha niile. ");
INSERT INTO ibo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mgbe ahụ, Mosis kwuru sị, “Ugbu a ka unu ga-amata na ọ bụ Onyenwe anyị zitere m ime ihe ndị a niile m mere. Nʼihi na-emeghị m ha site nʼuche nke onwe m. ");
INSERT INTO ibo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ọ bụrụ na ndị ikom ndị a anwụọ ọnwụ chi ha, bụ ụdị nleta nke dịrị mmadụ ọbụla, mgbe ahụ, matanụ na ọ bụghị Onyenwe anyị zitere m. ");
INSERT INTO ibo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ma ọ bụrụ na Onyenwe anyị emee ihe ọhụrụ dị iche, mee ka ala meghee ọnụ ya, lodaa ndị a niile, na ihe niile bụ nke ha, si otu a mee ka ha rịda nʼala ili na ndụ, mgbe ahụ, unu ga-amata na ndị ikom ndị a eledala Onyenwe anyị anya.” ");
INSERT INTO ibo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mgbe Mosis kpụ okwu a nʼọnụ ya, lee ala ahụ Kora, na Datan, na Abiram, na ndị ezinaụlọ ha niile guzo nʼelu ya kewara abụọ nʼotu ntabi anya ahụ, ");
INSERT INTO ibo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ala ahụ meghere ọnụ ya, loo ha, na ezinaụlọ ha niile, na ndị ahụ niile so Kora, na ihe niile ha nwere. ");
INSERT INTO ibo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ha niile rịdaruru nʼala ndị nwụrụ anwụ na ndụ. Ala ahụ kpuchikwara ha niile, si otu a mee ka ha laa nʼiyi. ");
INSERT INTO ibo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ndị Izrel niile nọ ha gburugburu gbara ọsọ, mgbe ha tiri mkpu akwa, na-asị, “Ala na-agakwa iloda anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Mgbe ahụ, ọkụ si nʼebe Onyenwe anyị nọ dara, rechapụ narị mmadụ abụọ na iri ise ndị ahụ na-enye onyinye aja nsure ọkụ na-esi isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Gwa Elieza nwa Erọn, onye nchụaja, ka o site nʼọkụ ahụ wepụta ihe ịgụ ọkụ ndị ahụ niile nʼihi na ha dị nsọ. Ọ ga-ekposakwa icheku ọkụ niile nʼakụkụ niile. ");
INSERT INTO ibo_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ha bụ ihe ịgụ ọkụ nke ndị ikom sitere na mmehie ha tufuo ndụ ha. Ka etipịa ihe ịgụ ọkụ ndị ahụ. Mee ha ka ha ghọọ ihe sara mbara nke a ga-eji machite ebe ịchụ aja, nʼihi na e chere ha nʼihu Onyenwe anyị, ha aghọọla ihe dị nsọ. Ka ha bụrụ ihe ịrịbama nye ndị Izrel niile.” ");
INSERT INTO ibo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ya mere Elieza, onye nchụaja, chịkọtara ihe ịgụ ọkụ bronz ndị ahụ nke ndị ahụ a kpọrọ ọkụ wetara, tipịa ha, mee ka ha ghọọ ihe sara mbara e ji ekpuchi ebe ịchụ aja, ");
INSERT INTO ibo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","dịka Onyenwe anyị nyere ya nʼiwu site nʼọnụ Mosis. Ka ọ bụrụ ihe ncheta nye ndị Izrel niile na onye mba ọzọ a na-enyeghị ike, nke na-esiteghị nʼagbụrụ Erọn, ekwesighị ịbịaru Onyenwe anyị nso isure aja nsure ọkụ nye ya, ka ihe mere Kora na ndị sonyere ya ghara ime ha. ");
INSERT INTO ibo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ma nʼụtụtụ echi ya, nzukọ Izrel niile malitere itamu ntamu megide Mosis na Erọn sị, “Unu egbuchaala ndị nke Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ma mgbe ọgbakọ Izrel zukọtara imegide Mosis na Erọn, mgbe ha chere ihu nʼụlọ nzute, na mberede, igwe ojii kpuchiri ụlọ nzute ahụ, ebube Onyenwe anyị pụtakwara ihe. ");
INSERT INTO ibo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mgbe ahụ, Mosis na Erọn gara nʼihu ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ma Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Sinụ nʼetiti ọgbakọ a pụọ ka m bibie ha nʼotu ntabi anya.” Ha dara kpuo ihu nʼala. ");
INSERT INTO ibo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mgbe ahụ, Mosis sịrị Erọn, “Ngwa, were ihe ịgụ ọkụ ma site nʼebe ịchụ aja gụnye ya ọkụ. Tinye ya ụda na-esi isi ụtọ. Burukwa ya gaa ngwangwa nʼetiti nzukọ Izrel ka i kpuchiere ha mmehie ha, nʼihi na iwe ọkụ Onyenwe anyị adakwasịla ha. Nrịa nrịa na-efe efe amalitekwalarị ibibi ha.” ");
INSERT INTO ibo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Erọn mere dịka Mosis kwuru. O mere ngwangwa gbaba nʼetiti ndị Izrel nʼihi na nrịa nrịa ahụ ebidola nʼezie ịdakwasị ha. Erọn mụnyere ụda na-esi isi ụtọ ahụ ọkụ, si otu ahụ kpuchiere ha mmehie ha niile. ");
INSERT INTO ibo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","O guzokwara nʼetiti ndị dị ndụ na ndị nwụrụ anwụ tutu ihe otiti ahụ akwụsị. ");
INSERT INTO ibo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ma ihe otiti ahụ egbuolarị puku mmadụ iri, puku anọ na narị asaa (14,700). A gụnyeghị ndị niile ahụ so Kora nwụọ nʼụbọchị gara aga. ");
INSERT INTO ibo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Mgbe ahụ, Erọn laghachikwutere Mosis nʼọnụ ụzọ ụlọ nzute ahụ, nʼihi na nrịa nrịa ahụ na-efe efe akwụsịla. ");
INSERT INTO ibo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Gwa ụmụ Izrel okwu, sitekwa nʼaka ha nata mkpanaka iri na abụọ otu mkpanaka nʼisi onyendu nke ebo ọbụla. Dekwasị aha onyendu ọbụla nʼahụ mkpanaka nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ma nʼelu mkpanaka Livayị dekwasị aha Erọn. A ga-enwe otu mkpanaka maka onyendu ebo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tinye mkpanaka ndị a niile nʼime ụlọ nzute, nʼihu Ihe Ama ahụ, ebe m na-ezute gị. ");
INSERT INTO ibo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mkpanaka nke onye ahụ m họpụtara ga-ama ifuru ndụ. M ga-ewezugakwa ntamu niile nke ndị Izrel site nʼebe m nọ, bụ nke ha na-atamu megide unu.” ");
INSERT INTO ibo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ya mere, Mosis gwara ndị Izrel okwu ndị a. Ndị ndu ha nyere ya mkpanaka iri na abụọ, otu mkpanaka nʼisi otu onyeisi maka onyeisi ebo ha nʼotu nʼotu. Mkpanaka Erọn dịkwa nʼetiti nke ha. ");
INSERT INTO ibo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mosis chịịrị ha niile dozie ha nʼihu Onyenwe anyị nʼime ime ụlọ nzute Ihe Ama ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nʼechi ya, Mosis banyere nʼụlọ nzute Ihe Ama ahụ chọpụta na ọ bụghị naanị na mkpanaka Erọn, onye nọchitere anya ebo Livayị, amaala ifuru, kama na ọ waala okoko ma mịakwa mkpụrụ osisi chara acha a na-akpọ alụmọnd. ");
INSERT INTO ibo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mgbe ahụ, Mosis sitere nʼihu Onyenwe anyị wepụta mkpanaka ndị ahụ niile gosi ha ndị Izrel niile. Ha hụrụ ha, ma nwoke ọbụla weghachiri mkpara osisi nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Onyenwe anyị gwara Mosis sị, “Tinye mkpanaka Erọn nʼihu Ihe Ama ahụ, ka ọ dịgide nʼebe ahụ dịka ihe ama nye ndị nnupu isi. Nke a ga-eme ka ntamu ndị a megide m kwụsị, ka ha ghara ịnwụ.” ");
INSERT INTO ibo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ya mere, Mosis mezuru ihe niile dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ma ndị Izrel zara Mosis sị ya, “Ndị nwụrụ anwụ ka anyị bụ! Ofufu ka anyị furu. Nʼezie anyị bụ ndị furu efu. ");
INSERT INTO ibo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Onye ọbụla bịaruru nso ebe obibi Onyenwe anyị ga-anwụ. Anyị niile ga-anwụ?” ");
INSERT INTO ibo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Onyenwe anyị gwara Erọn sị, “Gị, na ụmụ gị ndị ikom gị, na ezinaụlọ nna gị ga-ebu ahụhụ ajọ omume metụtara ebe nsọ ahụ. Gị na ụmụ gị ndị ikom naanị ka ọ dị nʼaka ịsa ajụjụ ihe ọjọọ ọbụla banyere ọrụ nchụaja. ");
INSERT INTO ibo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Site nʼebo unu kpọbata ụmụnna gị ndị Livayị ka ha sonyere gị ma nyere gị aka mgbe gị na ụmụ gị ndị ikom na-eje ozi nʼụlọ nzute Ihe Ama. ");
INSERT INTO ibo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ha ga-anọ gị nʼokpuru ije ozi niile nʼụlọ nzute, ma ha agaghị abịaru nso ngwongwo e ji chọọ ebe nsọ ahụ mma, maọbụ nʼebe ịchụ aja. Ma ọ bụghị otu a, gị na ha ga-anwụ. ");
INSERT INTO ibo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ha ka ọ dịrị, isonye gị nʼilekọta ụlọ ikwu ahụ, ya bụ, ihe niile metụtara ụlọ ikwu anya. O nweghị onye ọzọ nke ga-abịa nso ebe ị nọ. ");
INSERT INTO ibo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Gị ka ọ dịrị ilekọta ihe niile metụtara ebe nsọ ahụ, na ebe ịchụ aja ahụ, ka oke iwe Onyenwe anyị ghara ịdakwasị onye ọbụla nʼala Izrel ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mụ onwe m ahọpụtala ụmụnna gị ndị Livayị site nʼetiti ndị Izrel, were ha nye gị dịka onyinye, ka ha bụrụ ndị e doro nsọ nye Onyenwe anyị maka ịrụ ọrụ ụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ma ọ bụ naanị gị, na ụmụ gị ndị ikom, ga-aga ozi dịka ndị nchụaja, ozi metụtara ebe ịchụ aja, na ihe niile dị nʼazụ akwa mgbochi ahụ. Ana m enye gị ọrụ nchụaja dịka onyinye. Onye ọbụla ọzọ bịara nso ebe nsọ ahụ ga-anwụ.” ");
INSERT INTO ibo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mgbe ahụ, Onyenwe anyị gwara Erọn okwu sị ya, “Mụ onwe m emeela gị onye nlekọta onyinye niile a na-eche nʼihu m, onyinye niile dị nsọ nke ụmụ Izrel wetara m ka m na-enye gị na ụmụ gị ndị ikom dịka oke ruuru unu site nʼụkpụrụ ebighị ebi. ");
INSERT INTO ibo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Unu ga-enwere akụkụ aja ahụ kachasị nsọ nke a na-edopụ iche site nʼọkụ. Site nʼonyinye niile nke a na-ewetara m, bụ onyinye mkpụrụ ọka maọbụ aja mmehie maọbụ aja ikpe ọmụma, ndị ahụ a na-edopụ iche dịka ihe kachasị nsọ, ha ga-abụ oke gị na ụmụ gị ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","A ga-eri ha dịka ihe dịkarịrị nsọ. Nwa nwoke ọbụla ga-eri ya. Unu ga-agụ ha dịka ihe dị nsọ. ");
INSERT INTO ibo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Nke a bụkwa nke gị: Ihe ọbụla nke ewezugara site nʼonyinye nke aja mfufe niile nke ndị Izrel wetara. Mụ onwe m na-ewere nke a nye gị na ụmụ gị ndị ikom, na ụmụ gị ndị inyom dịka oke unu nʼụkpụrụ ebighị ebi. Onye ọbụla nke dooro onwe ya ọcha nʼezinaụlọ nwere ike iri ya. ");
INSERT INTO ibo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ana m enye gị mmanụ oliv nke kachasị mma, na mmanya ọhụrụ nke kachasị mma na ọka, bụ mkpụrụ mbụ nke owuwe ihe ubi ha na-ewetara Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mkpụrụ mbụ nke ihe niile dị nʼala nke ha na-ewebatara Onyenwe anyị, ga-abụ nke gị. Onye ọbụla nke dị ọcha nʼezinaụlọ unu nwere ike iso rie ya. ");
INSERT INTO ibo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Ihe niile e doro nsọ nʼala Izrel niile nye Onyenwe anyị bụ nke gị. ");
INSERT INTO ibo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ihe niile e bụ ụzọ mụọ, ma mmadụ ma anụ ụlọ, nke e nyere Onyenwe anyị dịka onyinye, bụ nke gị. Ma unu aghaghị ịgbara ụmụ ndị ikom niile e bụ ụzọ mụọ, na ụmụ oke anụ ụlọ niile e bụ ụzọ mụọ ndị na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Mgbe ha dị otu ọnwa, a ga-eji shekel ọlaọcha ise, nʼusoro shekel ebe nsọ, nke bụ iri ihe ọtụtụ gera abụọ gbapụta ha. ");
INSERT INTO ibo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ma a gaghị agbara nwa ehi mbụ, maọbụ nwa atụrụ mbụ maọbụ nwa ewu mbụ. Ha dị nsọ. Fesa ọbara ha nʼelu ebe ịchụ aja ahụ, ma kpọọ abụba ha ọkụ dịka onyinye e nyere site nʼọkụ, nke na-esi isi ụtọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ozu anụ ndị a niile e gburu ga-abụ nke gị, dịka obi anụ na apata ụkwụ aka nri anụ nke aja mfufe a na-eche nʼihu Onyenwe anyị nʼebe ịchụ aja si bụrụ nke gị. ");
INSERT INTO ibo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ihe ọbụla e dopụrụ iche site nʼonyinye nsọ niile ụmụ Izrel chere nʼihu Onyenwe anyị ka m na-enye gị na ụmụ gị ndị ikom, na ụmụ gị ndị inyom dịka oke ruuru unu nʼụkpụrụ ebighị ebi. Ọ bụ ọgbụgba ndụ nnu ebighị ebi nʼihu Onyenwe anyị nye gị na ụmụ ụmụ gị.” ");
INSERT INTO ibo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Onyenwe anyị gwara Erọn okwu sị ya, “Unu agaghị enwe ihe nketa nke ala, a gaghị ekenyekwa unu ala ọbụla nʼala Izrel niile. Nʼihi na mụ onwe m bụ oke na ihe nketa unu nwere nʼetiti ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Enyela m ndị Livayị, onyinye otu ụzọ nʼụzọ iri ahụ ụmụ Izrel niile na-akwụbatara m. Nke a bụ ihe nketa ha nʼihi ọrụ ha na-arụ nʼụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Site ugbu a gaa nʼihu, o nweghị onye Izrel ọbụla kwesiri ịbịa nso ụlọ nzute ahụ, ka ha ghara iwetara onwe ha ikpe ọmụma, mmehie na ọnwụ. ");
INSERT INTO ibo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ọ bụ naanị ụmụ Livayị ga-arụ ọrụ nʼụlọ nzute ahụ. Ha ka ọ dịrị ibu ahụhụ ajọ omume ọbụla banyere ejezighị ozi nke ụlọ nzute. Ụkpụrụ a ga-adị ebighị ebi ruo ọgbọ niile dị nʼihu. Ndị Livayị agaghị enwe ihe nketa nke aka ha nʼetiti ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kama, enyela m ndị Livayị onyinye otu ụzọ nʼime ụzọ iri ahụ niile ndị Izrel na-ewetara Onyenwe anyị ka ọ bụrụ ihe nketa ha. Ọ bụ nke a mere m ji kwuo sị, ‘Ha agaghị enweta ihe nketa nʼetiti ụmụ Izrel.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Onyenwe anyị gwakwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Gwa ndị Livayị okwu sị, ‘Mgbe unu si nʼaka ụmụ Izrel nata onyinye otu ụzọ nʼime ụzọ iri ahụ m nyere unu dịka ihe nketa, unu aghaghị isite nʼonyinye ahụ nye otu ụzọ nʼime ụzọ iri dịka onyinye nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A ga-agụ onyinye unu wetara dịka ọ bụ onyinye ọka unu si nʼebe ịzọcha ọka weta, maọbụ dịka mmanya unu si nʼebe ịzọcha mmanya weta. ");
INSERT INTO ibo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nʼụzọ dị otu a, unu onwe unu ga-eche onyinye unu nʼihu Onyenwe anyị site nʼonyinye otu ụzọ nʼime ụzọ iri unu si nʼaka ụmụ Izrel nata. Site nʼonyinye ndị a unu natara, unu ga-enye Erọn onye nchụaja onyinye ahụ ruuru Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Onyinye unu ga-enye dịka nke ruuru Onyenwe anyị ga-abụ akụkụ onyinye ndị ahụ kachasị mma, na ndị kachasị ịdị nsọ.’ ");
INSERT INTO ibo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Gwa ndị Livayị okwu sị ha, ‘Mgbe unu wetara akụkụ onyinye ndị ahụ kachasị mma, a ga-agụnyere unu ya dịka a ga-asị na ọ bụ onyinye unu si nʼebe ịzọcha ọka, na nʼebe ịzọcha mmanya vaịnị unu weta. ");
INSERT INTO ibo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Unu na ezinaụlọ unu nwere ike iri ndị fọdụrụ nʼụlọ unu, maọbụ nʼebe ọbụla masịrị unu, nʼihi na ha bụ ụgwọ ọrụ unu nʼihi ozi niile unu jere nʼụlọ nzute. ");
INSERT INTO ibo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ikpe ọmụma agaghị adịrị unu mgbe unu na-eri ya ma ọ bụrụ na unu chere onyinye ndị ahụ kachasị mma nʼihu Onyenwe anyị. Ma kpachapụnụ anya hụ na unu e merụghị onyinye ndị a dị nsọ ụmụ Izrel webatara. Ọ bụrụ na unu emee nke a, unu ga-anwụ.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Onyenwe anyị gwara Mosis na Erọn okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ndị a bụ ụkpụrụ dị nʼiwu ahụ Onyenwe anyị nyere. Gwa ụmụ Izrel ka ha wetara gị nwa nne ehi na-acha uhie uhie nke na-enweghị ntụpọ, na nke ụdọ yoku na-agabeghị nʼolu ya. ");
INSERT INTO ibo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Nye ya Elieza onye nchụaja, ka ọ kpụrụ ya pụọ nʼazụ ogige, ebe otu onye ga-egbu ya mgbe ọ nọ na-ele ya anya. ");
INSERT INTO ibo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Elieza bụ onye nchụaja ga-arụrụ ụfọdụ nʼime ọbara ya na mkpịsịaka ya, fesa ya na ncherita ihu ụlọ nzute ahụ ugboro asaa. ");
INSERT INTO ibo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Mgbe ahụ, onye ọzọ ga-akpọ nwa nne ehi ahụ ọkụ mgbe Elieza nọkwa na-ele ya anya. Ọ ga-akpọ akpụkpọ ya, anụ ya, ọbara na mgbịrị afọ ya ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Onye nchụaja ga-ewere osisi sida, na osisi hisọp, na ogho uhie, tụba ha nʼetiti ebe ahụ a kpọrọ nwa nne ehi ahụ ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Emesịa, onye nchụaja ahụ ga-asacha uwe niile o yi; sakwaa ahụ ya. Ọ ga-alọghachikwa azụ nʼime ogige ahụ ebe ọ ga-anọ dịka onye na-adịghị ọcha ruo nʼuhuruchi. ");
INSERT INTO ibo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onye ahụ kpọrọ nwa ehi ahụ ọkụ aghaghị ịsa uwe ya niile, sakwaa ahụ ya. Ọ ga-anọkwa ọnọdụ onye na-adịghị ọcha ruo anyasị. ");
INSERT INTO ibo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Mgbe ahụ, onye nke dị ọcha, ga-ekpokọta ntụ ozu nwa nne ehi ahụ, wụnye ya nʼebe dị ọcha nʼazụ ogige ahụ. Ebe ahụ ka nzukọ Izrel ga-edebe ya maka ikporo wụnye na mmiri e ji asachapụ adịghị ọcha. Ọ bụ maka nsacha pụọ na mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ma onye ahụ ga-ekpokọta ntụ nsure ọkụ nwa nne ehi ahụ aghaghị ịsa uwe ya niile, sakwaa ahụ ya, nọkwaa dịka onye na-adịghị ọcha ruo nʼuhuruchi. Iwu a ga-adịgidere ndị Izrel na ndị ọbịa binyere ha site nʼọgbọ ruo nʼọgbọ. ");
INSERT INTO ibo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Onye ọbụla metụrụ ozu mmadụ aka ga-abụ onye na-adịghị ọcha ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ha aghaghị iji mmiri e ji asachapụ adịghị ọcha saa ahụ ha nʼụbọchị nke atọ na nʼụbọchị nke asaa. Mgbe ahụ, ha ga-adị ọcha. Ma ọ bụrụ na ha asaghị ahụ ha nʼụbọchị nke atọ nakwa nʼụbọchị nke asaa, ha ga-anọgide bụrụ ndị na-adịghị ọcha ọ bụladị mgbe ụbọchị asaa ahụ gafesịrị. ");
INSERT INTO ibo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Onye ọbụla metụrụ ozu mmadụ aka ma ọ saghị ahụ ya dịka usoro a si dị, o merụọla ebe nsọ Onyenwe anyị. A ga-ewezuga onye dị otu a site nʼetiti ndị Izrel. Ebe ọ bụ na a wụsaghị ya mmiri nsacha ahụ; ọ ga-anọgide bụrụ onye na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Mgbe mmadụ nwụrụ nʼụlọ ikwu, ndị a ga-abụ iwu unu ga-eso. Ndị nọ nʼime ụlọ ikwu ahụ mgbe ọ nwụrụ na onye ọbụla banyere nʼụlọ ikwu ahụ, ga-abụ ndị na-adịghị ọcha ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ihe ọbụla nke ghere oghe, nke na-enweghị ihe mkpuchi eriri e ji kechie elu ya, ga-abụ ihe na-adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Onye gara nʼọhịa metụ onye e gburu nʼagha aka, maọbụ onye nwụrụ nʼụzọ ọzọ dị iche, ma ọ bụkwanụ metụ ọkpụkpụ, maọbụ ili onye nwụrụ anwụ aka, ọ ga-abụ onye na-adịghị ọcha ụbọchị asaa. ");
INSERT INTO ibo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ma banyere onye ahụ na-adịghị ọcha, kporo ntụ site nʼime aja mmehie ahụ a kpọrọ ọkụ, tinye ya nʼime ite, wụkwasị ya mmiri e si nʼiyi na-eru eru kute. ");
INSERT INTO ibo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Mgbe ahụ, nwoke nke nọ nʼọnọdụ ịdị ọcha ga-ewere ụfọdụ hisọp, denye ya na mmiri ahụ fesaa ya nʼime ụlọ ikwu ahụ, na ngwongwo niile e ji dozie ụlọ ahụ, na ndị mmadụ nọ nʼebe ahụ. Ọ ga-efesakwa ya nʼahụ onye ọbụla metụrụ ọkpụkpụ, maọbụ onye e gburu egbu, maọbụ onye nwụrụ anwụ ma ọ bụkwanụ ili aka. ");
INSERT INTO ibo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Nwoke ahụ dị ọcha ga-efesakwa ndị ahụ rụrụ arụ nʼụbọchị nke atọ na nʼụbọchị nke asaa. Nʼụbọchị nke asaa ka ọ ga-eme ka ha dị ọcha. Ndị ahụ a na-edo ọcha ga-asa uwe ha mmiri, saa ahụ ha, nʼuhuruchi ụbọchị ahụ ka ha ga-adị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ma ọ bụrụ na ndị ahụ merụrụ onwe ha e doghị onwe ha ọcha, aghaghị iwepụ ha site nʼetiti ọgbakọ Izrel. Nʼihi na ha merụrụ ebe nsọ Onyenwe anyị. E fesakwaghị ha mmiri nke ịdị ọcha nʼahụ, nke mere na ha adịghị ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Nke a bụ ụkpụrụ ga-adịgide mgbe ebighị ebi. “Nwoke ahụ na-efesa mmiri ahụ e ji edo mmadụ ọcha, aghaghị ịsacha uwe ya niile. Onye ọbụla metụrụ mmiri nke ịdị ọcha ahụ aka, ga-abụ onye na-adịghị ọcha ruo nʼuhuruchi. ");
INSERT INTO ibo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ihe ọbụla kwa onye na-adịghị ọcha metụrụ aka, ga-aghọ ihe na-adịghị ọcha, onye ọbụla metụkwara ya aka ga-abụ onye na-adịghị ọcha ruo nʼuhuruchi.” ");
INSERT INTO ibo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ụmụ Izrel, bụ nzukọ ahụ niile rutere nʼọzara Zin nʼọnwa nke mbụ. Ha manyere ụlọ ha na Kadesh. Ọ bụkwa nʼebe ahụ ka Miriam nwụrụ. E lie ya. ");
INSERT INTO ibo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ma mmiri ọṅụṅụ adịghị nye ndị nzukọ ahụ. Ya mere na ha gbakọtara imegide Mosis na Erọn. ");
INSERT INTO ibo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ha sesịrị Mosis okwu sị, “Ọ gaara akara anyị mma ma a sị na anyị nwụrụ mgbe ụmụnna anyị nwụrụ nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Gịnị mere i ji kpọbata ọgbakọ nke Onyenwe anyị nʼime ọzara a, ime ka anyị na anụ ụlọ anyị niile nwụọ nʼebe a? ");
INSERT INTO ibo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Gịnị mere i ji si nʼala Ijipt kpọpụta anyị, kpọbata anyị nʼebe ọjọọ a? O nweghị mkpụrụ ọghịgha maọbụ fiig, enweghị mkpụrụ vaịnị maọbụ mkpụrụ pomegranet. Ọ dịghị mmiri dị nke ha ga-aṅụ.” ");
INSERT INTO ibo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosis na Erọn si nʼebe ọgbakọ ahụ nọ tụgharịa gaa nʼọnụ ụzọ ụlọ nzute, daa kpụọ ihu ha nʼala. E mee ka ha hụ ebube Onyenwe anyị anya. ");
INSERT INTO ibo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Onyenwe anyị gwara Mosis sị, ");
INSERT INTO ibo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Were mkpara ahụ, gị na nwanne gị Erọn kpọkọta nzukọ Izrel niile. Gwa nkume ahụ okwu nʼihu ha, ọ ga-asọpụta mmiri ya. Unu ga-eme ka mmiri si na nkume ahụ sọpụta nye ọgbakọ ahụ, ka ha na igwe anụ ụlọ ha, ṅụọ mmiri.” ");
INSERT INTO ibo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ya mere Mosis sitere nʼihu Onyenwe anyị weere mkpara ahụ dịka iwu Onyenwe anyị nyere ya si dị. ");
INSERT INTO ibo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Emesịa, Mosis na Erọn kpọkọtara ụmụ Izrel niile nʼihu nkume ahụ. Mgbe ha bịaruru nso, Mosis gwara ha okwu sị ha, “Geenụ ntị unu ndị nnupu isi! Ọ bụ site na nkume a ka anyị ga-enye unu mmiri?” ");
INSERT INTO ibo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mgbe ahụ Mosis weliri aka ya elu jiri mkpara ahụ tie nkume ahụ ugboro abụọ. Mmiri sitere na ya sọpụta. Ọgbakọ Izrel niile na igwe anụ ụlọ ha ṅụkwara mmiri. ");
INSERT INTO ibo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ma Onyenwe anyị gwara Mosis na Erọn okwu sị, “Ebe ọ bụ na unu jụrụ ikwenye nʼokwu m, jụkwa ido m nsọ nʼihu ndị Izrel niile, unu agaghị edubata ọgbakọ ndị a nʼala ahụ m na-aga inye ha.” ");
INSERT INTO ibo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","A kpọrọ ebe ahụ mmiri Meriba, nʼihi na ọ bụ nʼebe ahụ ka Izrel wesoro Onyenwe anyị iwe. O gosikwara ha ịdị nsọ ya. ");
INSERT INTO ibo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mosis sitere nʼọzara Kadesh, zipụ ndị ozi ka ha gakwuru eze Edọm, sị ya, “Otu a ka nwanne gị bụ Izrel na-ekwu: Ị nụla akụkọ ihe nhụju anya niile dakwasịrị anyị. ");
INSERT INTO ibo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nna anyị gara biri nʼala Ijipt. Anyị biri nʼebe ahụ ọtụtụ afọ. Ndị Ijipt mekpara anyị na nna nna anyị ha ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ma mgbe anyị tikuru Onyenwe anyị mkpu akwa, ọ nụrụ akwa anyị, zitere anyị mmụọ ozi ya, onye dupụtara anyị site nʼala Ijipt. “Ugbu a, anyị nọ na Kadesh obodo dị nso nʼoke ala gị. ");
INSERT INTO ibo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Biko kwere ka anyị si nʼala gị gafee. Anyị ga-akpachara anya hụ na anyị esiteghị nʼubi ihe ọkụkụ gị maọbụ nʼubi vaịnị gị gafee. Anyị agaghị aṅụ mmiri ọbụla site nʼolulu mmiri gị. Anyị ga-anọgide naanị nʼokporoụzọ eze. Anyị agaghị ahapụ ya, chee ihu akụkụ aka nri maọbụ aka ekpe, tutu ruo mgbe anyị gafechara oke ala gị.” ");
INSERT INTO ibo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ma eze Edọm zara sị, “Unu amanyela ụkwụ; ọ bụrụ na unu anwaa anwa bata nʼala m, aga m eji ndị agha m zute unu.” ");
INSERT INTO ibo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ma ndị Izrel zara ozi o ziri sị ya, “Ọ bụ naanị nʼokporoụzọ ka anyị ga-esi gafee. Ọ bụrụ na anyị maọbụ anụ ụlọ anyị a ṅụọ mmiri dị nʼala gị, anyị ga-akwụ ọnụahịa ya. Naanị mkpa anyị bụ ịgafe. Ọ dịghị ihe ọzọ anyị chọrọ.” ");
INSERT INTO ibo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ma eze Edọm aṅaghị ntị, ọ gwaghere ha ọnụ sị, “Unu agaghị esite nʼala gabiga.” Edọm chịkọtara ọtụtụ ndị agha dị ike duru ha pụọ ịga izute ha. ");
INSERT INTO ibo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ebe ọ bụ na ndị Edọm ekweghị ka ndị Izrel si nʼoke ala ha gafee, ndị Izrel tụgharịrị azụ hapụ isi ụzọ ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ọgbakọ Izrel niile sitere na Kadesh bulie ije gagide rute nʼugwu Hor. ");
INSERT INTO ibo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Nʼugwu Hor, nʼoke ala Edọm, Onyenwe anyị gwara Mosis na Erọn okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Oge eruola mgbe Erọn ga-anwụ. Ọ gaghị abanye nʼala ahụ m nyere ụmụ Izrel, nʼihi na unu abụọ nupuru isi nʼiwu m na mmiri Meriba. ");
INSERT INTO ibo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ugbu a, kpọrọ Erọn na nwa ya nwoke Elieza, duru ha gaa nʼugwu Hor. ");
INSERT INTO ibo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Nʼebe ahụ ka ị ga-eyipụ Erọn uwe onye nchụaja o yi, yikwasị ha Elieza nwa ya nwoke. Ọ bụkwa nʼebe ahụ ka Erọn ga-anọ nwụọ.” ");
INSERT INTO ibo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ya mere Mosis mere dịka Onyenwe anyị nyere ya iwu. Ha atọ rigoro nʼugwu Hor mgbe nzukọ Izrel niile nọ na-ele ha anya. ");
INSERT INTO ibo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mgbe ha ruru nʼelu ugwu ahụ, Mosis yipụrụ Erọn uwe onye nchụaja ya yikwasị ha nwa ya nwoke Elieza. Erọn nọkwa nʼebe ahụ, nʼelu ugwu ahụ nwụọ. Emesịa, Mosis na Elieza tụgharịrị site nʼugwu ahụ lọghachi. ");
INSERT INTO ibo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mgbe ọgbakọ Izrel nụrụ ihe banyere ọnwụ Erọn ha ruru ụjụ nʼihi ya iri ụbọchị atọ. ");
INSERT INTO ibo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mgbe eze Kenan, bụ Arad, onye bi na Negev nụrụ na ndị Izrel na-agbaso ụzọ ahụ na-aga obodo Atarim, ọ chịkọtara ndị agha ya, pụkwuru ndị Izrel, lụso ha agha. Ọ dọtara ụfọdụ nʼime ha nʼagha. ");
INSERT INTO ibo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mgbe ahụ, ndị Izrel kwere Onyenwe anyị nkwa sị, “Ọ bụrụ na ị ga-enyere anyị aka imeri eze Arad na ndị ya, anyị ga-ebibi obodo ha niile kpamkpam.” ");
INSERT INTO ibo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Onyenwe anyị ṅara ntị nʼarịrịọ ha, nyere ha aka imeri ndị Kenan ahụ. Mgbe ahụ, ụmụ Izrel bibiri obodo ha niile, na ndị niile bi nʼime ya. Ya mere, aha a kpọrọ ebe ahụ niile bụ Homa. ");
INSERT INTO ibo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mgbe ahụ, ụmụ Izrel sitere nʼugwu Hor bilie ije ha, si ụzọ gawara Osimiri Uhie, ka ha nwee ike gaa gburugburu ala ndị Edọm. Ma ndị Izrel enweghị ntachiobi oge niile ha nọ nʼije a. ");
INSERT INTO ibo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ha kwuru okwu megide Chineke na Mosis sị, “Gịnị mere i ji site nʼala Ijipt kpọpụta anyị ka anyị nwụsịa nʼọzara a? Lee na nri ọbụla adịghị nʼebe a, mmiri ọṅụṅụ adịghịkwa, ike iri mánà a na-enweghị isi agwụkwala anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ya mere, Onyenwe anyị zitere agwọ ọjọọ na-ata ata nʼetiti ha. Agwọ ndị a tagbukwara ọtụtụ nʼime ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mgbe ahụ, ndị Izrel bịakwutere Mosis sị ya, “Anyị emehiela, nʼihi na anyị ekwuluola Onyenwe anyị, kwulukwaa gị onwe gị. Biko rịọrọ anyị Onyenwe anyị ka o wezugara anyị agwọ ọjọọ ndị a.” Mosis rịọrọ arịrịọ nʼihi ha. ");
INSERT INTO ibo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, “Kpụọ otu agwọ yiri agwọ ndị a. Kwụba ya nʼọnụ ogologo osisi nke ị ga-amanye nʼala ebe mmadụ niile ga-ahụ ya anya. Onye ọbụla agwọ ọjọọ a tara ga-adị ndụ ma ọ bụrụ na ọ ga-ewelite anya ya elu lekwasị agwọ ahụ ị kwụbara nʼelu osisi ahụ.” ");
INSERT INTO ibo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ya mere, Mosis ji bronz kpụta agwọ yiri otu nʼime agwọ ndị ahụ, tinye ya nʼọnụ osisi dị ogologo. Onye ọbụla kwa agwọ ahụ tara nke welitere anya ya elu lee agwọ bronz ahụ anya, dịkwara ndụ. ");
INSERT INTO ibo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ụmụ Izrel biliri njem, manye ụlọ ikwu ha na Obot. ");
INSERT INTO ibo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ha sikwa nʼObot bilie njem, maa ụlọ ikwu ha na Iye Abarim, nʼọzara ahụ nke chere ihu nʼobodo Moab, nʼụzọ ọwụwa anyanwụ. ");
INSERT INTO ibo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ha si nʼebe ahụ bilie njem, manye ụlọ ikwu ha na Ndagwurugwu Zered. ");
INSERT INTO ibo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ha sitekwara nʼebe ahụ bilie njem, maa ụlọ ikwu ha nʼofe iyi Anọn nke dị nʼọzara ruru nʼoke ala ndị Amọrait. Iyi Anọn bụ oke ala Moab, nʼetiti ndị Moab na ndị Amọrait. ");
INSERT INTO ibo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Nʼihi nke a, nʼAkwụkwọ Agha dị iche iche nke Onyenwe anyị na-asị, “Waheb nʼime Sufa ya na ndagwurugwu niile Anọn ");
INSERT INTO ibo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na mgbadata ndagwurugwu ndị ahụ nke gbasapụrụ ruo nʼebe Ar dị, nke tọgbọrọ nʼoke ala Moab.” ");
INSERT INTO ibo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Mgbe ahụ, ụmụ Izrel niile biliri njem bịarute Bịa bụ nʼolulu mmiri ahụ Onyenwe anyị nyere Mosis iwu sị, “Kpọkọtaa ndị Izrel niile, nʼihi na m na-aga inye ha mmiri.” ");
INSERT INTO ibo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Mgbe ahụ, ụmụ Izrel bụrụ abụ a. “Sọpụta gị olulu mmiri! Bụọnụ abụ banyere mmiri a! ");
INSERT INTO ibo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Olulu mmiri ụmụ ndị eze gwuru nke ndị ndu anyị doziri. Mkpara eze ha na mkpara ha, ka ha ji gwuo ya.” Emesịa, ha hapụrụ ọzara ahụ, gaa nʼihu ruo nʼobodo Matana. ");
INSERT INTO ibo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ha si Matana jeruo Nahaliel, si Nahaliel jeruo Bamot. ");
INSERT INTO ibo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Sitekwa Bamot rute na ndagwurugwu ahụ dị nʼọhịa Moab, ruo nʼugwu Pisga, nke chere ihu nʼala ahụ tọgbọrọ nʼefu. ");
INSERT INTO ibo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ndị Izrel zipụrụ ndị ozi ka ha jekwuru Saịhọn, eze ndị Amọrait, sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Biko, kwere ka anyị site nʼobodo gị gafee. Anyị agaghị atụgharị banye nʼime ala ubi gị maọbụ nʼubi vaịnị, maọbụ ṅụọ mmiri site nʼolulu mmiri ọbụla dị nʼala gị. Anyị ga-eje nʼokporoụzọ eze tutu ruo mgbe anyị ga-agabiga oke ala gị.” ");
INSERT INTO ibo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ma Saịhọn ekweghị na ụmụ Izrel ga-esi nʼoke ala ya gafee. Ọ chịkọtara ndị agha ya niile, zọpụ ije ibu agha megide ndị Izrel nʼime ọzara ahụ. Mgbe o rutere Jehaz, ọ lụsoro Izrel agha. ");
INSERT INTO ibo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ma Izrel jiri mma agha gbuo ya. Nwetara onwe ha ala ya, site nʼiyi Anọn ruo nʼiyi Jabọk, gamiekwa rute nʼoke ala ha na ndị Amọn, ha kwụsịrị nʼihi nʼoke ala ndị Amọn siri ike karịa. ");
INSERT INTO ibo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ndị Izrel lụgburu obodo niile nke ndị Amọrait bichie nʼime ha, tinyere Heshbọn na obodo nta niile gbara ya gburugburu. ");
INSERT INTO ibo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbọn bụ isi obodo Saịhọn, eze ndị Amọrait onye busoro eze naara achị Moab agha dọta ala ya niile nʼagha ruo Anọn. ");
INSERT INTO ibo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ọ bụ nke a mere ndị na-arọ abụ ji kwuo sị, “Bịa na Heshbọn ka e wukwaa ya, ka e mee ka isi obodo eze Saịhọn guzosie ike. ");
INSERT INTO ibo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Nʼihi na ọkụ esitela na Heshbọn pụọ. Ire ọkụ esitela nʼobodo ukwu Saịhọn, rechapụ obodo Ar, nke dị na Moab, ndị nwe ebe niile dị elu nke Anọn. ");
INSERT INTO ibo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ahụhụ dịrị gị Moab! Ndị a lara nʼiyi ka unu bụ, unu ndị Kemosh. Ụmụ ya ndị ikom aghọọla ndị na-enweghị ebe obibi. A dọtala ụmụ ndị inyom nʼagha, nye Saịhọn eze ndị Amọrait. ");
INSERT INTO ibo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Ma anyị ebibiela ha, bibie Heshbọn ruo rịị na Dibọn, bibie ha ruo Nofa, ruokwa rịị Medeba.” ");
INSERT INTO ibo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ya mere, ụmụ Izrel bichiri nʼala ndị Amọrait. ");
INSERT INTO ibo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Emesịa, Mosis zipụrụ ndị nnyopụta ka ha ga nyochaa Jeza. Ụmụ Izrel tigburu obodo niile dị gburugburu ya chụpụkwa ndị Amọrait bi nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Mgbe ahụ, ha chigharịrị gbagoo nʼụzọ gawara Bashan. Ma Ọg, eze Bashan, na ndị agha ya niile biliri chịrị agha pụọ izute ha na Edrei. ");
INSERT INTO ibo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ma Onyenwe anyị gwara Mosis okwu, sị, “Atụla ya egwu nʼihi na ewerela m ya na ndị agha ya niile, na ala ya, nyefee gị nʼaka. Mee ya ihe i mere Saịhọn eze ndị Amọrait onyeisi obodo ya bụ Heshbọn.” ");
INSERT INTO ibo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ya mere, ha gburu ya, tinyere ụmụ ya na ndị agha ya niile, na-ahapụghị onye ọbụla ndụ nye ha. Ha nwetakwara ala ha, biri nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ndị Izrel biliri njem bịarute nʼobosara ala Moab. Manye ụlọ ikwu ha nʼakụkụ Jọdan ebe chere ihu nʼobodo Jeriko. ");
INSERT INTO ibo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ma Balak nwa Zipoa ahụlarị ihe niile Izrel mere ndị Amọrait. ");
INSERT INTO ibo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Oke ụjọ jidere ndị Moab nʼihi na ndị Izrel dị ọtụtụ. Nʼezie, oke ụjọ dị ukwuu jidere ndị Moab nʼihi ụmụ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ndị Moab jekwuru ndị okenye Midia sị ha, “Igwe mmadụ ndị a ga-erichapụ ihe niile gbara anyị gburugburu. Ha ga-eripịa ha dịka ehi si erichapụ ahịhịa ndụ dị nʼala.” Ya mere, Balak nwa Zipoa, onye bụ eze ndị Moab nʼoge ahụ, ");
INSERT INTO ibo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","zigara ndị ozi ya ka ha jekwuru Belam, nwa Beoa onye bi nʼobodo ya bụ Petoa, nke dị nso nʼiyi ukwu Yufretis. O ziri ya sị, “Lee otu ndị sitere nʼIjipt pụta. Lee ka ha si kpuchie elu ala a; ugbu a, ha bi nʼakụkụ m. ");
INSERT INTO ibo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ugbu a, bịa ka ị bụọrọ m ha ọnụ, nʼihi na ha dị ike karịa m. Ma eleghị anya aga m enwe ike merie ha, ma chụpụkwa ha site nʼala m. Nʼihi na amaara m na ndị ọbụla ị gọziri bụ ndị a gọziri agọzi, ndị ọbụla ị bụrụ ọnụ ga-anọgide bụrụ ndị a bụrụ ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ndị ozi o zigara bụ ndị okenye obodo Moab na Midia. Ha ji ego ịjụta ase nʼaka ha. Mgbe ha ruru, ha ziri Belam ozi Balak ziri. ");
INSERT INTO ibo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Belam gwara ha okwu sị, “Nọdụnụ nʼebe a nʼabalị a. Aga m ewetara unu ọsịsa ọbụla Onyenwe anyị nyere m.” Ya mere, ndị ozi ahụ si Moab nọnyeere ya. ");
INSERT INTO ibo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nʼabalị ahụ, Chineke bịakwutere Belam jụọ ya sị, “Ndị ikom ndị a bịara ileta gị, ha bụ ndị ole?” ");
INSERT INTO ibo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Belam sịrị Chineke, “Balak nwa Zipoa eze Moab zitere m ozi sị m, ");
INSERT INTO ibo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Otu ndị esitela nʼala Ijipt pụta, ndị dị ukwuu nʼọnụọgụgụ. Achọrọ m ka ị bịa bụọrọ m ha ọnụ. Ma eleghị anya aga m enwe ike lụso ha agha, ma chụpụkwa ha.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ma Chineke sịrị Belam, “Esola ha aga! Ị gaghị abụ ndị a ọnụ, nʼihi na ha bụ ndị a gọziri agọzi.” ");
INSERT INTO ibo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Mgbe chi bọrọ, Belam biliri gwa ndị ozi Balak sị ha, “Laghachinụ nʼobodo unu nʼihi na Onyenwe anyị ekweghị ka m soro unu.” ");
INSERT INTO ibo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ya mere, ndị ozi Moab laghachikwuru Balak gwa ya sị, “Belam jụrụ iso anyị lọghachi.” ");
INSERT INTO ibo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak nwara ike ya ọzọ. Nʼoge a, o zipụrụ ụmụ eze ndị dị ọtụtụ na ndị a maara aha ha karịa ndị mbụ. ");
INSERT INTO ibo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ha jiri ozi a bịakwute Belam sị ya, “Ihe a ka Balak nwa Zipoa sị anyị zie gị, Ọ sị gị ekwela ka ihe ọbụla gbochie gị ịbịakwute m. ");
INSERT INTO ibo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nʼihi na aghaghị ịsọpụrụ gị nʼebe ọ dị ukwuu m, mekwaa ihe ọbụla ị sị m mee. Naanị bịa ka ị bụọrọ m ndị a ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ma Belam zaghachiri sị, “Ọ bụrụ na Balak enye m ụlọeze ya nke juputara nʼọlaọcha na ọlaedo, apụghị m ime ihe ọbụla dị ukwuu maọbụ nke nta ịgabiga iwu Onyenwe anyị bụ Chineke m. ");
INSERT INTO ibo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ma otu ọ dị, nọọnụ ka chị bọọ dịka ndị ọzọ ahụ mere ka m nwee ike chọpụta ma ọ dị ihe Onyenwe anyị ga-atụkwasị nʼihe o kwuru na mbụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Nʼabalị ahụ, Chineke gwara Belam okwu sị ya, “Ebe ọ bụ na ndị a bịara ịkpọ gị oku, bilie soro ha gaa, kama jikere ikwu naanị okwu m ga-etinye gị nʼọnụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ya mere, mgbe chi echi ya bọrọ, Belam rigooro nʼelu ịnyịnya ibu ya soro ụmụ eze Moab gaa. ");
INSERT INTO ibo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ma iwe were Chineke nʼihi na ọ na-aga, ma mmụọ ozi Onyenwe anyị guzochiri ụzọ igbochi ya. Belam na ndị odibo ya abụọ nọ na-elu ịnyịnya ibu ya. ");
INSERT INTO ibo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mgbe ịnyịnya ibu ahụ hụrụ mmụọ ozi Onyenwe anyị ka o guzochiri nʼụzọ, jide mma a mịpụtara amịpụta nʼaka ya, ịnyịnya ibu ahụ chigharịrị onwe ya hapụ okporoụzọ, tinye isi nʼọhịa. Ma Belam tiri ya ihe ịchụghachi ya nʼụzọ. ");
INSERT INTO ibo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nʼoge a, mmụọ ozi Onyenwe anyị guzochiri nʼụzọ dị warawara, nke dị nʼetiti mgbidi ogige ubi vaịnị abụọ. ");
INSERT INTO ibo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Mgbe ịnyịnya ibu ahụ hụrụ mmụọ ozi Onyenwe anyị, o tinyere isi nʼahụ mgbidi ogige ubi ahụ, chọọ isite nʼebe ahụ gafee. Mgbe ọ na-eme nke a, o mere ka mgbidi ahụ chihịapụ Belam ụkwụ. Ya mere Belam tiri ịnyịnya ibu ahụ ihe ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Mgbe ahụ, mmụọ ozi Onyenwe anyị gakwara nʼihu nʼokporoụzọ ahụ nọchie ụzọ ahụ ebe dị nnọọ mkpakọta, ebe ịnyịnya ibu ahụ na-agaghị enwe ike gafee, maọbụ ichigharị aka nri maọbụ aka ekpe. ");
INSERT INTO ibo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nʼihi nke a, mgbe ịnyịnya ibu ahụ hụrụ mmụọ ozi Onyenwe anyị o dinara ala nʼokporoụzọ. Nʼoke iwe, Belam ji mkpara dị ya nʼaka tie ya ihe ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Mgbe ahụ, Onyenwe anyị mere ka ịnyịnya ibu ahụ kwuo okwu. Ọ jụrụ Belam ajụjụ sị, “Gịnị ka m mere gị i ji tie m ihe ugboro atọ?” ");
INSERT INTO ibo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Belam zara ịnyịnya ibu ahụ sị, “Ọ bụ nʼihi na i meela ka m dị ka onye nzuzu! Nʼezie, a sị na m ji mma agha nʼaka m, agaara m egbu gị.” ");
INSERT INTO ibo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ịnyịnya ibu ahụ gwara Balam okwu ọzọ sị ya, “Ọ bụ na mụ onwe m abụghị ịnyịnya ibu gị nke ị na-anọ nʼelu ya ogologo oge ndị a niile? Ọ dịla mgbe m si otu a meso gị omume nʼime ndụ m niile?” Belam zara sị ya, “Ee.” ");
INSERT INTO ibo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Mgbe ahụ ka Onyenwe anyị meghere anya Belam. Ọ hụrụ mmụọ ozi Onyenwe anyị ka o ji mma agha ya guzochie ụzọ. Belam dara nʼala, gbatịa onwe ya nʼala nʼihu ya. ");
INSERT INTO ibo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mmụọ ozi Onyenwe anyị ahụ jụrụ Belam ajụjụ sị, “Gịnị mere i ji tie ịnyịnya ibu gị ihe ugboro atọ? Abịara m igbochi gị ka ịla nʼiyi dị na-eche gị ghara irute gị. ");
INSERT INTO ibo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ugboro atọ ka ịnyịnya ibu a hụrụ m, ma site nʼihu m wezuga onwe ya. A sị na ọ bụghị ntụgharị ọ tụgharịrị site nʼebe m nọ, nʼezie, ugbu a, a gara m egbu gị ma hapụ ịnyịnya ibu gị ndụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Nʼoge a, Belam sịrị mmụọ ozi Onyenwe anyị, “Emehiela m. Amaghị m na i guzo nʼụzọ igbochi m. Ọ bụrụ iwe na-ewe gị, ejikeere m ịlaghachi azụ.” ");
INSERT INTO ibo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ma mmụọ ozi Onyenwe anyị sịrị Belam, “Soro ndị ikom a gaa, ma kwuo naanị ihe m sị gị kwuo.” Ya mere, Belam soro ndị ozi eze Balak gaa. ");
INSERT INTO ibo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Mgbe Balak nụrụ na Belam nọ nʼụzọ na-abịa, ọ pụrụ gaa izute Belam nʼotu obodo Moab nke dị nʼọnụ mmiri Anọn, nke dị na ngwụcha oke ala ya. ");
INSERT INTO ibo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Mgbe ọ bịarutere, Balak jụrụ Belam ajụjụ sị ya, “Eziri m gị ozi ka ị bịa ngwangwa, gịnị mere ị bịaghị? Ọ bụ na m enweghị ike ịsọpụrụ gị?” ");
INSERT INTO ibo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Belam zaghachiri, “Lee, Abịakwutelam gị ugbu a, ma enweghị m ike ikwu ihe ọbụla dị m mma. Ọ bụ naanị ihe Chineke tinyere m nʼọnụ ka m ga-ekwu.” ");
INSERT INTO ibo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Belam sooro Balak gaa Kiriat Huzot. ");
INSERT INTO ibo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak jiri ehi na atụrụ chụọ aja. O nyere Belam ụfọdụ, nyekwa ma ndị ozi eze ndị ya na ha nọ nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nʼụtụtụ echi ya, Balak kpọọrọ Belam, duru ya rigoo Bamot Baal. O sitere nʼebe ahụ hụ nsọtụ ọmụma ụlọ ikwu ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Belam sịrị, “Wuoro m ebe ịchụ aja asaa nʼebe a. Kwadokwaara m oke ehi asaa na ebule asaa.” ");
INSERT INTO ibo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak mezuru dịka Belam gwara ya. Ha abụọ gburu otu oke ehi na otu nwa ebule nʼebe ịchụ aja asaa ahụ nʼotu na otu. ");
INSERT INTO ibo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Mgbe ahụ, Belam gwara Balak sị, “Guzoro nʼebe a nʼakụkụ aja gị ka m gaa nʼihu chọpụta ma eleghị anya Onyenwe anyị ga-ezute m. Aga m agwa gị ihe ọbụla o kpughere m.” Ya mere, Belam rigooro nʼebe ọhịa na-adịghị. ");
INSERT INTO ibo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Chineke zutere ya nʼebe ahụ. Belam gwara ya sị, “Edoziela m ebe ịchụ aja asaa, gbukwaa otu oke ehi na otu ebule nʼelu ha niile nʼotu na otu.” ");
INSERT INTO ibo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nʼoge a, Onyenwe anyị tinyere Belam ozi nʼọnụ sị ya, “Laghachi gaa zie Balak ozi a.” ");
INSERT INTO ibo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Mgbe Belam lọghachiri ọ hụrụ ya ka o guzoro nʼakụkụ ihe aja ya ndị ahụ, ya na ndịisi Moab niile. ");
INSERT INTO ibo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nke a bụ ozi Belam ziri: “Balak esitela nʼobodo Aram kpọta m. Eze Moab esitela nʼọwụwa anyanwụ nke ugwu ahụ kpọta m. Ọ sịrị m, bịa bụọrọ m Jekọb ọnụ bịa kwutọọ Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","M ga-esi aṅaa bụọ onye Chineke na-abụghị ọnụ ọnụ? M ga-esi aṅaa kọchaa onye Onyenwe anyị na-akọchaghị? ");
INSERT INTO ibo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Esitela m nʼelu nkume ndị a hụ ha. Elegidere m ha anya site nʼugwu ahụ, hụ na ha bụ ndị biri onwe ha, ndị dị iche site nʼetiti mba niile ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Onye pụrụ ịgụta ole uzuzu Jekọb dị? Maọbụ gụta ole otu ụzọ nʼime nkewa anọ nke Izrel dị. Ọ ga-atọ m ụtọ ịnwụ ụdị ọnwụ ndị na-eme ezi omume. Ka ọgwụgwụ ndụ m bụrụ ihe nwere ike iyi nke ha!” ");
INSERT INTO ibo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak sịrị Belam, “Gịnị bụ ihe a i mere m? Akpọtara m gị ka ị bụọrọ m ndị iro m ọnụ, ma ugbu a, ọ dịghị ihe ọzọ i mere karịa naanị ịgọzi ha!” ");
INSERT INTO ibo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ma Belam zaghachiri sị ya, “Ọ bụghị ihe Onyenwe anyị tinyere m nʼọnụ ka m ga-ekwu?” ");
INSERT INTO ibo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Mgbe ahụ, Balak sịrị ya, “Soro m bịa nʼebe ọzọ ebe ị ga-ahụ ha; ọ bụ naanị nsọtụ ọmụma ụlọ ikwu ha ka ị ga-ahụ, ị gaghị ahụ ha niile. Site nʼebe ahụ bụọrọ m ha ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ya mere, eze Balak duuru Belam gaa nʼọhịa Zofim, nʼelu ugwu Pisga, wuo ebe ịchụ aja asaa nʼebe ahụ. O jikwa otu oke ehi, otu oke ehi, na otu ebule, otu ebule, chụọ aja nʼebe ịchụ aja ndị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Belam sịrị Balak, “Guzoro nʼebe a nʼakụkụ ihe aja gị, ebe mụ onwe m ga-ezute ya nʼofe nke ọzọ.” ");
INSERT INTO ibo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ma Onyenwe anyị zutere Belam gwa ya ihe ọ ga-ekwu sị ya, “Laghachikwuru Balak zie ya ozi a.” ");
INSERT INTO ibo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ya mere, ọ lọghachiri azụ nʼebe ahụ Balak na ụmụ eze Moab guzoro nʼakụkụ ihe aja ha. Balak jụrụ ya sị, “Gịnị ka Onyenwe anyị sịrị?” ");
INSERT INTO ibo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ma Belam zaghachiri sị ya: “Bilie ọtọ Balak, nụrụ ozi. Ṅaa ntị nʼokwu m, gị nwa Zipoa. ");
INSERT INTO ibo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Chineke agaghị agha ụgha, nʼihi na ọ bụghị mmadụ. Ọ gaghị agbanwe obi ya, nʼihi na ọ bụghị nwa mmadụ. O kwuola okwu, ma ghara ime ihe o kwuru? O kwela nkwa ma ghara imezu nkwa o kwere? ");
INSERT INTO ibo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Chineke enyela m iwu sị m gọzie ha. Ọ gọziela ha, a pụghịkwa ịgbanwe ya! ");
INSERT INTO ibo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“O nweghị ajọ ihe nke ahụrụ nʼime Jekọb, ahụghịkwa mwute ọbụla nʼIzrel. Onyenwe anyị Chineke ha nọnyeere ha. Iti mkpu nke Eze dịkwa nʼetiti ha. ");
INSERT INTO ibo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Chineke kpọpụtara ha site nʼIjipt. Ha dị ike dịka ehi ọhịa. ");
INSERT INTO ibo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ọ dịghị mgbaasị ga-emegide ha. Ọ dịkwaghị ịgba afa a pụrụ iji megide Izrel. Nʼihi na ugbu a, ihe dị otu a ka a ga-ekwu banyere Jekọb na Izrel. ‘Lee, ihe Chineke mere ha.’ ");
INSERT INTO ibo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ha na-ebili ọtọ dịka nne ọdụm, ha na-enugharị onwe ha dịka ọdụm, nke na-adịghị edina ala tutu o richaa ihe o gburu, ma ṅụọkwa ọbara ihe ahụ o tigburu!” ");
INSERT INTO ibo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Mgbe ahụ, Balak sịrị Belam, “Abụla ha ọnụ ma ọlị, ma ọ bụkwanụ gọzie ha ma ọlị.” ");
INSERT INTO ibo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ma Belam zaghachiri, “Ọ bụ na m agwaghị gị, ihe ọbụla nke Onyenwe anyị ga-ekwu ka m ga-eme?” ");
INSERT INTO ibo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Mgbe ahụ, Balak sịrị Belam, “Bịa, aga m akpọrọ gị gaa nʼebe ọzọ. Eleghị anya ọ ga-amasị Chineke ka i si nʼebe ahụ bụọrọ m ha ọnụ.” ");
INSERT INTO ibo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ya mere, Balak duuru Belam gaa nʼelu ugwu Peoa nke na-elegide ọzara ahụ anya. ");
INSERT INTO ibo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Belam gwara Balak okwu sị ya, “Wuoro m ebe ịchụ aja asaa ọzọ. Doziekwa ụmụ oke ehi asaa na ebule asaa e ji achụ aja.” ");
INSERT INTO ibo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak mere dịka Belam gwara ya. O ji otu oke ehi na otu ebule chụọ aja nʼebe ịchụ aja ahụ nʼotu na otu. ");
INSERT INTO ibo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Nʼoge a, Belam aghọtala nʼuche ya na ọ masịrị Onyenwe anyị ịgọzi Izrel. Ya mere, ọ họrọghị ịgba afa dịka o mere nʼoge ndị gara aga, kama o chere ihu ya nʼọzara. ");
INSERT INTO ibo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Mgbe Belam lepụrụ anya ọ hụrụ ụmụ Izrel dịka ha si maa ụlọ ikwu nʼebo nʼebo. Mgbe ahụ kwa, Mmụọ nke Chineke dakwasịrị ya. ");
INSERT INTO ibo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","O buru amụma ndị a sị, “Okwu si nʼọnụ Belam nwa Beoa pụta, okwu onye ahụ anya ya saghere asaghe. ");
INSERT INTO ibo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Okwu onye ahụ na-anụ okwu Chineke onye na-ahụ ọhụ site nʼaka onye pụrụ ime ihe niile. Onye na-ada nʼala ma anya ya na-eghe oghe. ");
INSERT INTO ibo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Lee ka ebe obibi gị si maa mma, gị Jekọb, ebe obibi gị niile, gị Izrel! ");
INSERT INTO ibo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Dịka ndagwurugwu dị iche iche ka ha gbasapụrụ, dịka ubi a gbara ogige dị nʼakụkụ osimiri, dịka osisi aloos nke Onyenwe anyị kụrụ, dịka osisi sida dị nʼakụkụ mmiri. ");
INSERT INTO ibo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mmiri ga-esi nʼite mmiri ha na-erupụta, mkpụrụ ha ga-enwekwa mmiri dị ukwuu. “Eze ha ga-adị ukwuu karịa Agag, a ga-ebulikwa alaeze ha elu. ");
INSERT INTO ibo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Chineke sitere nʼala Ijipt kpọpụta ha. Ha nwere ike dịka atụ. Ha ga-eripịa mba niile na-ebili imegide ha. Ha ga-anyajisi ọkpụkpụ ha niile, jirikwa ọtụtụ àkụ ha gbatuo ha. ");
INSERT INTO ibo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ha na-amakpuru, dinara ala dịka ọdụm, dịka nne ọdụm, onye pụrụ ịkpọte ha? “Ngọzị na-adịrị onye ọ bụla na-agọzi gị, ma ọbụbụ ọnụ na-adịrị onye ọbụla na-akọcha gị.” ");
INSERT INTO ibo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Iwe Balak dị ọkụ megide Belam nʼoge a. Ọ kụkọtara aka ya abụọ nʼiwe. Tie mkpu sị Belam, “Akpọrọ m gị ka ị bịa bụọrọ m ndị iro m ọnụ. Ma ị gọziela ha ugboro atọ a. ");
INSERT INTO ibo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Si nʼebe m nọ wezuga onwe gị! Laghachi nʼụlọ gị! Akwadobere m inye gị ọnọdụ dị elu, ma Onyenwe anyị e gbochiela gị inweta ụgwọ ọrụ a.” ");
INSERT INTO ibo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Belam zara Balak sị, “Ọ bụ na m agwaghị ndị ozi gị niile, bụ ndị ị zitere m, ");
INSERT INTO ibo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘na a sịkwarịị na Balak enye m ọlaọcha na ọlaedo niile nke dị nʼụlọeze ya, apụghị m ime ihe ọbụla nʼike aka, maọbụ ihe ọma maọbụ ihe ọjọọ, ị gabiga iwu Onyenwe anyị. Ọ bụkwa naanị ihe Onyenwe anyị na-ekwu ka m ga-ekwu’? ");
INSERT INTO ibo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ugbu a, ana m alakwuru ndị m, ma bịa, ka m dọọ gị aka na ntị banyere ihe ndị a ga-eme ndị gị nʼụbọchị ndị a na-abịa nʼihu.” ");
INSERT INTO ibo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ya mere Belam kwuru okwu ndị a: “Amụma Belam nwa Beoa, amụma nke onye ahụ anya ya nʼahụ ụzọ nke ọma, ");
INSERT INTO ibo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","amụma onye ahụ nke na-anụ okwu Chineke, onye ihe ọmụma ya si nʼebe Onye kachasị ihe niile elu na-abịa. Onye na-ahụ ọhụ site nʼaka Onye pụrụ ime ihe niile. Onye na-ada nʼala, ma anya ya abụọ ghekwa oghe. ");
INSERT INTO ibo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Ana m ahụ ya, ma ọ bụghị ugbu a, ana m ele ya anya, ma ọ nọghị nso. Otu kpakpando ga-esi nʼime Jekọb zolie. Mkpara eze ga-esi nʼetiti Izrel bilie. Ọ ga-etipịa egedege ihu ndị Moab, na okpokoro isi ndị ikom Shet niile. ");
INSERT INTO ibo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","A ga-emeri Edọm, Sia, onye iro ya, ka a ga-emeri nʼagha. Ma Izrel ga-eto, ghọọ onye dị ike. ");
INSERT INTO ibo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Otu onye ọchịchị ga-esi na Jekọb pụta. Bibie ndị niile fọdụrụ nʼobodo ahụ.” ");
INSERT INTO ibo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Mgbe ahụ, Belam lepụrụ anya legide ụlọ ndị Amalek niile, buo amụma banyere ha sị: “Amalek bụ mba mbụ nʼetiti mba niile, ma ikpeazụ ya bụ mbibi!” ");
INSERT INTO ibo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ọ hụrụ ndị Ken anya, kwuo okwu ya: “E, i bi ugbu a nʼebe e wusiri ike, akwụ gị dị nʼime oke nkume ahụ! ");
INSERT INTO ibo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ma, a ga-ebibi unu ndị Ken niile, mgbe Ashọ ga-adọta unu nʼagha.” ");
INSERT INTO ibo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ndị a bụ okwu o ji mechie amụma ya: “Onye ga-adị ndụ mgbe Chineke ga-eme ihe ndị a? ");
INSERT INTO ibo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ụgbọ mmiri ga-esi nʼọnụ mmiri Saiprọs bịa. Ha ga-eji ike dobe ndị Eba na ndị Ashọ nʼokpuru ha, ma a ga-ebibikwa ha onwe ha.” ");
INSERT INTO ibo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Emesịa, Belam biliri laghachi nʼụlọ ya, ma Balak gbasoro ụzọ nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Mgbe Izrel bi na Shitim, ndị ikom ha malitere isoro ndị inyom Moab na-akwa iko. ");
INSERT INTO ibo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ndị inyom a kpọrọ ha ka ha bịa soro na mmemme ịchụ aja nye chi ha niile. Ndị Izrel riri nri ihe aja ahụ, kpọọkwa isiala nye chi ndị a niile. ");
INSERT INTO ibo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ya mere, ndị Izrel sonyere na-akpọ isiala nye chi Baal nke Peoa. Nke a mere ka iwe Onyenwe anyị nwuru ọkụ megide ha. ");
INSERT INTO ibo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Onyenwe anyị gwara Mosis okwu sị ya, “Duru ndị ndu ebo niile nke Izrel gbuo ha ma kwụnye ha nʼosisi nʼihu Onyenwe anyị nʼetiti ehihie, ka oke iwe Onyenwe anyị dị ọkụ ghara ịbịakwasị ndị Izrel.” ");
INSERT INTO ibo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ya mere, Mosis sịrị ndị ọkaikpe Izrel, “Onye ọbụla nʼime unu aghaghị igbu ndị unu, bụ ndị jikọtara onwe ha na Baal nke Peoa.” ");
INSERT INTO ibo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mgbe ahụ, otu nwoke onye Izrel kpọbatara nʼime ụlọ ikwu otu nwanyị onye Midia, nʼihu Mosis na nzukọ Izrel niile, mgbe ha niile nọ na-akwa akwa nʼọnụ ụzọ ụlọ nzute ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Mgbe Finehaz na Elieza, nwa Erọn, onye nchụaja hụrụ ihe a, ọ hapụrụ ọgbakọ Izrel. O were ùbe nʼaka ya, ");
INSERT INTO ibo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","soro nwoke ahụ baa nʼime ụlọ, ebe ya na nwaagbọghọ ahụ dina. Ọ mara ha ùbe ahụ, nke si nʼahụ nwoke ahụ gafee mikpuo nʼafọ nwaagbọghọ ahụ. Nke a mere ka ihe otiti ahụ na-emegide ndị Izrel kwụsị. ");
INSERT INTO ibo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ma tupu ihe otiti ahụ akwụsị, ndị mmadụ ọnụọgụgụ ha ruru iri puku abụọ na anọ (24,000) anwụọlarị. ");
INSERT INTO ibo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Onyenwe anyị gwara Mosis okwu sị, ");
INSERT INTO ibo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehaz nwa Elieza, nwa Erọn, onye nchụaja, emeela ka iwe m megide Izrel dajụọ. Nʼihi na o nwere ịnụ ọkụ nʼobi dịka mụ onwe m banyere idebe nsọpụrụ m nsọ nʼetiti ha, ka m ghara isite nʼịnụ ọkụ nke obi m bibie ha. ");
INSERT INTO ibo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ya mere, gwa ya, na m na-eme ka ọgbụgba ndụ udo m dịrị ya. ");
INSERT INTO ibo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ya na ụmụ ụmụ ya ka ọgbụgba ndụ ebighị ebi nke ịrụ ọrụ nchụaja ga-adịrị, nʼihi na o nwere ịnụ ọkụ nʼobi banyere nsọpụrụ nke Chineke ya, si otu a chụọrọ ndị Izrel aja ikpuchi mmehie.” ");
INSERT INTO ibo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Aha nwoke Izrel ahụ e gburu ya na nwanyị onye Midia ahụ bụ Zimri, nwa Salu, onyendu otu ezinaụlọ nʼebo Simiọn. ");
INSERT INTO ibo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Aha nwanyị Midia ahụ e gburu bụ Kozbi, nwa nwanyị Zua, onye bụ otu nʼime ndịisi ezinaụlọ na Midia. ");
INSERT INTO ibo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Mesoo ndị Midia mmeso dịka ndị iro. Gbukwaa ha. ");
INSERT INTO ibo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Nʼihi na ha mesoro unu mmeso dịka ndị iro mgbe ha ji ụzọ aghụghọ ghọgbuo unu nʼokwu Peoa, na nʼokwu Kozbi nwanne ha nwanyị, bụ nwa nwanyị otu nʼime ndịisi Midia, onye e gburu mgbe ihe otiti ahụ bịara nʼihi okwu Peoa.” ");
INSERT INTO ibo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Mgbe ihe otiti ahụ niile gasịrị, Onyenwe anyị gwara Mosis na Elieza nwa Erọn, onye nchụaja okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Gaanụ gụọ, chọpụta ọnụọgụgụ nzukọ niile nke ụmụ Izrel dịka ezinaụlọ ha si dị; ndị niile gbara iri afọ abụọ gafee. Chọpụta ọnụọgụgụ ndị nwere ike ije agha.” ");
INSERT INTO ibo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ya mere, na mbara ala Moab, nʼakụkụ osimiri Jọdan, na ncherita ihu Jeriko, ka Mosis na Elieza onye nchụaja nọ gwa ha okwu sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Gụọnụ ndị ikom gbara iri afọ abụọ gafee ọnụ, dịka Onyenwe anyị nyere Mosis nʼiwu.” Ndị a bụ ndị Izrel si Ijipt pụta: ");
INSERT INTO ibo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ụmụ ụmụ Ruben, ọkpara Izrel, bụ ndị a: site na Hanok, ikwu Hanok, site na Palu, ikwu Palu, ");
INSERT INTO ibo_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","site na Hezrọn, ikwu Hezrọn site na Kami, ikwu Kami ");
INSERT INTO ibo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ndị a bụ agbụrụ Ruben. Ọnụọgụgụ ha dị iri puku anọ, puku atọ na narị asaa na iri atọ (43,730). ");
INSERT INTO ibo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Nwa Palu bụ Eliab, ");
INSERT INTO ibo_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ụmụ Eliab bụ Nemuel, Datan na Abiram. Datan na Abiram bụ ndị ndu ọgbakọ ahụ nupuru isi megide Mosis na Erọn. Ha sonyere ndị ahụ so Kora mgbe ha nupuru isi megide Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ala meghere ọnụ ya, loo ha na Kora, ma ọkụ rechapụrụ narị mmadụ abụọ na iri ise ndị ọzọ ahụ sonyere ha. Ọnwụ ha ghọrọ ihe ịdọ aka na ntị. ");
INSERT INTO ibo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Otu ọ dị, ndị niile si nʼezinaụlọ Kora anwụchaghị. ");
INSERT INTO ibo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ụmụ ụmụ Simiọn dịka ikwu ha si dị bụ, site na Nemuel, ikwu Nemuel, site na Jamin, ikwu Jamin, site na Jakin, ikwu Jakin, ");
INSERT INTO ibo_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Site na Zera, ikwu Zera, site na Shaul, ikwu Shaul. ");
INSERT INTO ibo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ndị a bụ ndị agbụrụ Simiọn. Ọnụọgụgụ ndị ikom ha dị iri puku abụọ, puku abụọ na narị abụọ (22,200). ");
INSERT INTO ibo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ụmụ ụmụ Gad dịka ikwu ha si dị bụ ndị a: ikwu Zefọn, site na Zefọn, ikwu Hagi, site na Hagi, ikwu Shuni, site na Shuni, ");
INSERT INTO ibo_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ikwu Ozni, site na Ozni, ikwu Eri, site na Eri, ");
INSERT INTO ibo_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ikwu Arodi, site na Arodi, ikwu Areli, site na Areli, ");
INSERT INTO ibo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ndị a bụ agbụrụ Gad. Ndị a gụrụ ọnụ dị iri puku anọ na narị ise (40,500). ");
INSERT INTO ibo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Ụmụ ndị ikom Juda abụọ, Ịa na Onan, nwụrụ nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ma ụmụ ụmụ Juda ndị ọzọ, dịka ikwu ha dị iche iche si dị bụ ndị a: ikwu Shela, site na Shela, ikwu Perez, site na Perez, ikwu Zera, site na Zera. ");
INSERT INTO ibo_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ikwu abụọ ọzọ si nʼagbụrụ Perez bụ ndị a: Ikwu Hezrọn, site na Hezrọn, Ikwu Hamul, site na Hamul. ");
INSERT INTO ibo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ndị a bụ agbụrụ Juda. Ndị a gụrụ ọnụ dị iri puku asaa, puku isii na narị ise (76,500). ");
INSERT INTO ibo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ụmụ ụmụ Isaka dịka ikwu ha si dị bụ ndị a: ikwu Tola, site na Tola, ikwu Pua, site na Pua ");
INSERT INTO ibo_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ikwu Jashub, site na Jashub, ikwu Shịmrọn, site na Shịmrọn. ");
INSERT INTO ibo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ndị a bụ agbụrụ Isaka. Ndị a gụrụ ọnụ dị iri puku isii, puku anọ na narị atọ (64,300). ");
INSERT INTO ibo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ụmụ ụmụ Zebụlọn dịka ikwu ha si dị bụ ndị a: ndị Sered, site nʼikwu Sered, ndị Elọn, site nʼikwu Elọn, ndị Jaliil, site nʼikwu Jaliil. ");
INSERT INTO ibo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ndị a bụ agbụrụ Zebụlọn. Ndị a gụrụ ọnụ dị iri puku isii na narị ise (60,500). ");
INSERT INTO ibo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ụmụ ụmụ Josef dịka ha si dị nʼagbụrụ Manase na Ifrem bụ ndị a: ");
INSERT INTO ibo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ụmụ ụmụ Manase bụ ndị a: ndị Makia, site nʼikwu Makia. Makia bụ nna Gilead. Ikwu Gilead, site na Gilead. ");
INSERT INTO ibo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ndị a bụ ụmụ ụmụ Gilead: ikwu Leza, site na Leza, ikwu Helek, site na Helek. ");
INSERT INTO ibo_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Ikwu Asriel, site na Asriel. Ikwu Shekem, site na Shekem. ");
INSERT INTO ibo_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Ikwu Shemida, site na Shemida, ikwu Hefa, site na Hefa. ");
INSERT INTO ibo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Hefa mụtara nwoke a na-akpọ Zelofehad. Ma Zelofehad amụtaghị nwoke ọbụla kama ndị inyom ndị a ka ọ mụtara, Mahla, na Noa, na Hogla, na Milka, na Tịaza.) ");
INSERT INTO ibo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ndị a bụ agbụrụ Manase. Ndị a gụrụ ọnụ dị iri puku ise, puku abụọ na narị asaa (52,700). ");
INSERT INTO ibo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ndị a bụ ụmụ ụmụ Ifrem dịka ikwu ha si dị: ikwu Shutela site na Shutela, ikwu Beka site na Beka, ikwu Tahan site na Tahan. ");
INSERT INTO ibo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ndị a bụ ụmụ ụmụ Shutela: ikwu Eran site na Eran. ");
INSERT INTO ibo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ndị a bụ agbụrụ Ifrem. Ndị a gụrụ ọnụ dị iri puku atọ, puku abụọ na narị ise (32,500). Ndị a bụ ụmụ ụmụ Josef dịka ikwu ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ndị a bụ ụmụ ụmụ Benjamin dịka ikwu ha si dị: ikwu Bela site na Bela, ikwu Ashbel site Ashbel, ikwu Ahiram site na Ahiram. ");
INSERT INTO ibo_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Ikwu Shufam site na Shufam, ikwu Hufam site na Hufam. ");
INSERT INTO ibo_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ụmụ ụmụ Bela site na Aad, na Naaman bụ, ikwu Aad site na Aad, ikwu Neeman site na Neeman. ");
INSERT INTO ibo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ndị a bụ agbụrụ Benjamin. Ndị a gụrụ ọnụ dị iri puku anọ, puku ise na narị isii (45,600). ");
INSERT INTO ibo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ụmụ ụmụ Dan dịka ikwu ha si dị bụ ndị a: ikwu Shuham, site na Shuham. Ndị a bụ naanị ikwu dị na Dan. ");
INSERT INTO ibo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ha niile si nʼagbụrụ Shuham. Ndị a gụrụ ọnụ dị iri puku isii, puku anọ na narị anọ (64,400). ");
INSERT INTO ibo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ụmụ ụmụ Asha dịka ikwu ha si dị bụ ndị a: ikwu Imna site na Imna, ikwu Ishvi, site na Ishvi, ikwu Beriya, site na Beriya. ");
INSERT INTO ibo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ikwu e nwere site nʼụmụ ụmụ Beriya bụ ndị a: ikwu Heba, site na Heba, ikwu Malkiel, site na Malkiel. ");
INSERT INTO ibo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asha mụtakwara otu nwa nwanyị aha ya bụ Sera. ");
INSERT INTO ibo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ndị a bụ agbụrụ Asha. Ndị a gụrụ ọnụ dị iri puku ise, puku atọ na narị anọ (53,400). ");
INSERT INTO ibo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ụmụ ụmụ Naftalị dịka ikwu ha si dị bụ ndị a: ikwu Jaziil, site na Jaziil, ikwu Guni, site na Guni, ");
INSERT INTO ibo_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ikwu Jeza, site na Jeza, ikwu Shilem, site na Shilem. ");
INSERT INTO ibo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ndị a si nʼagbụrụ Naftalị. Ndị a gụrụ ọnụ dị iri puku anọ, puku ise na narị anọ (45,400). ");
INSERT INTO ibo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ya mere, ọnụọgụgụ ndị ikom niile tozuru ije agha nʼIzrel dị narị puku isii, otu puku na narị asaa, na iri atọ (601,730). ");
INSERT INTO ibo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ị ga-ekenye ha ala ahụ ka ọ bụrụ ihe nketa ha dịka ọnụọgụgụ aha ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ndị dị ukwuu nʼọnụọgụgụ ga-eketa ala dị ukwuu, ma ndị dị nta ga-eketa ala dị nta. Ihe nketa nke onye ọbụla ga-enweta ga-adị ka ọnụọgụgụ ahụ e dere. ");
INSERT INTO ibo_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Lezie anya hụ na e kesara ala ahụ site nʼife nza. Ala ndị ọbụla ga-eketa ga-abụ dịka aha nna ochie ebo ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","A ga-esite nʼife nza kenye ndị ọbụla ihe nketa nke ha dịka ịdị ukwuu maọbụ ịdị nta ha si dị.” ");
INSERT INTO ibo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ndị a bụ ndị Livayị a gụrụ ọnụ dịka ikwu ha si dị, ikwu Geshọn, site na Geshọn, ikwu Kohat, site na Kohat, ikwu Merari, site na Merari. ");
INSERT INTO ibo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ndị a sikwa nʼagbụrụ Livayị: ikwu Libni, ikwu Hebrọn, ikwu Mahali, ikwu Mushi, na ikwu Kora. (Kohat bụ nna nna Amram. ");
INSERT INTO ibo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Aha nwunye Amram bụ Jekobed, nwa nwa Livayị, onye a mụrụ nʼagbụrụ ndị Livayị nʼIjipt. Ọ mụtaara Amram ụmụ ndị a: Erọn na Mosis, na Miriam, nwanne ha nwanyị. ");
INSERT INTO ibo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Erọn mụtara Nadab, na Abihu, na Elieza, na Itama. ");
INSERT INTO ibo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ma Nadab na Abihu nwụrụ mgbe ha chere ọkụ na-adịghị nsọ nʼihu Onyenwe anyị.) ");
INSERT INTO ibo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ọnụọgụgụ ụmụ ndị ikom Livayị niile dị otu ọnwa gaa nʼihu dị iri puku abụọ na puku atọ (23,000). Ma a gụnyekọghị ọnụọgụgụ agbụrụ Livayị nʼọnụọgụgụ ndị Izrel, nʼihi na agbụrụ Livayị enweghị oke ọbụla mgbe e kenyere agbụrụ Izrel niile ihe nketa ha. ");
INSERT INTO ibo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ya mere, ndị a bụ nchọpụta ọnụọgụgụ ụmụ Izrel, dịka Mosis na Elieza onye nchụaja kwadobere gụọ na mbara ala Moab, nʼakụkụ osimiri Jọdan, na ncherita ihu obodo Jeriko. ");
INSERT INTO ibo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ma nʼetiti ndị a, o nweghị otu onye ọbụla Mosis na Erọn onye nchụaja gụrụ nʼọnụọgụgụ mgbe ha gụrụ ndị Izrel ọnụ nʼọzara Saịnaị. ");
INSERT INTO ibo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Nʼihi na Onyenwe anyị gwara ndị Izrel ahụ na ha ga-anwụ nʼime ọzara ahụ. Naanị ndị a hapụrụ ndụ bụ Kaleb, nwa Jefune, na Joshua nwa Nun. ");
INSERT INTO ibo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ụmụ ndị inyom Zelofehad nwa Hefa, nwa Gilead, nwa Makia, nwa Manase bụ ndị si nʼagbụrụ Manase nwa Josef. Aha ndị inyom ndị a bụ: Mahla, Noa, Hogla, Milka na Tịaza. Ha bịara, ");
INSERT INTO ibo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","nʼọnụ ụzọ ụlọ nzute, guzo nʼihu Mosis, na Elieza onye nchụaja, na ndị ndu niile na ọgbakọ Izrel niile kwuo sị, ");
INSERT INTO ibo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nna anyị Zelofehad nwụrụ nʼọzara ma ọ bụghị otu nʼime ndị sonyere Kora, bụ ndị ahụ zukọtara megide Onyenwe anyị. Ọ nwụrụ ọnwụ nʼihi mmehie nke ya. Ma otu ọ dị, ọ mụtaghị nwoke. ");
INSERT INTO ibo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Gịnị ga-eme a ga-eji hichapụ aha nna anyị site nʼagbụrụ ya nʼihi na ọ mụtaghị nwoke? Ọ bụ uche anyị na e kwesiri ikenye anyị oke nʼoge a na-enye ụmụnne nna anyị oke.” ");
INSERT INTO ibo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ya mere, Mosis butere mkpa ha nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ma Onyenwe anyị zaghachiri Mosis sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Ihe ụmụ Zelofehad na-ekwu ziri ezi. Ị ghaghị ikenye ha oke nʼetiti ụmụnne nna ha, ma nyefeekwa ha oke ruru nna ha. ");
INSERT INTO ibo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Gwa ndị Izrel sị ha, ‘Ọ bụrụ na nwoke ọbụla anwụọ na-amụtaghị nwoke, oke niile ruru ya ga-alara nwa ya nwanyị. ");
INSERT INTO ibo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ma ọ bụrụ na ọ mụtaghị nwa nwanyị, oke ruru ya ga-alara ụmụnne ya ndị nwoke. ");
INSERT INTO ibo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","A sịkwa na o nweghị ụmụnne ndị nwoke, mgbe ahụ oke ya ga-alara ụmụnne nna ya ndị nwoke. ");
INSERT INTO ibo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ọ bụrụkwa na o nweghị ndị nwoke bụ ụmụnne nna ya, mgbe ahụ ihe nketa ya ga-alara onye dịkarịrị ya nso nʼikwu ya, ka ọ bụrụ nke ya. Nke a bụ iwu dịrị ndị Izrel niile dịka Onyenwe anyị si nye ya Mosis nʼiwu.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya: “Gaa rigoro nʼugwu Abarim site nʼebe ahụ lefee anya nʼofe mmiri Jọdan leruo ala ahụ nke m nyere ụmụ Izrel anya. ");
INSERT INTO ibo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Mgbe i lechasịrị ya, ị ga-anwụ dịka nwanne gị Erọn nwụrụ. ");
INSERT INTO ibo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Nʼihi na unu nupuru isi nye okwu m nʼọzara Zin, mgbe ọgbakọ ụmụ Izrel sesịrị m okwu. Unu abụọ nupuru isi nʼiwu m ido m nsọ nʼihu ha.” (Ndị a bụ mmiri Meriba Kadesh, nke dị nʼọzara Zin.) ");
INSERT INTO ibo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mosis zara Onyenwe anyị sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ka Onyenwe anyị, Chineke nwe mmụọ nke mmadụ niile, họpụta onyendu ga-elekọta ọgbakọ a. ");
INSERT INTO ibo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Onye ga na-apụ na-abatakwa nʼihu ha, onye ga na-edu ha pụọ, duru ha batakwa, ka ndị Onyenwe anyị ghara ịdị ka atụrụ na-enweghị onye ọzụzụ.” ");
INSERT INTO ibo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ya mere, Onyenwe anyị sịrị Mosis, “Kpọrọ Joshua, nwa Nun, onye nwere mmụọ Chineke nʼime ya, bikwasị ya aka gị. ");
INSERT INTO ibo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Mee ka o guzo nʼihu Elieza onye nchụaja, nakwa nʼihu ọgbakọ niile, nyefee ya ọrụ nke ịbụ onyendu nʼihu ha. ");
INSERT INTO ibo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Nyekwa ha ụfọdụ ikike gị, ka nzukọ niile nke ụmụ Izrel nwee ike rubere ya isi. ");
INSERT INTO ibo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ma ya onwe ya ga-eguzo nʼihu Elieza onye nchụaja, onye ga-ajụrụ ya ase site na mkpebi Urim nʼihu Onyenwe anyị. Ọ bụ site nʼokwu ọnụ ya ka ha ga-apụ, site nʼokwu ọnụ ya ka ha ga-ana abata. Ma ya onwe ya, ma ndị Izrel niile, tinyekwara nzukọ niile.” ");
INSERT INTO ibo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ya mere, Mosis mere dịka Onyenwe anyị nyere ya iwu. O duuru Joshua mee ka o guzo nʼihu Elieza onye nchụaja na ọgbakọ niile. ");
INSERT INTO ibo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mosis bikwasịrị aka ya abụọ nʼisi Joshua, rara ya nyefee maka ije ozi ahụ niile dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Nye ndị Izrel iwu a sị ha, ‘Lezienụ anya hụ na unu na-eche nʼihu m, nʼoge niile a kara aka, nri ahụ a na-enye maka onyinye m a na-enye site nʼọkụ, nke isisi ya na-adị m ezi mma.’ ");
INSERT INTO ibo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Sị ha, ‘Nke a bụ onyinye unu na-enye site nʼọkụ nke unu na-eche nʼihu Onyenwe anyị: ụmụ atụrụ abụọ gbara otu afọ, nke na-enweghị ntụpọ, ka e jiri ha chụọ aja nsure ọkụ kwa ụbọchị niile. ");
INSERT INTO ibo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Chụọ otu nwa atụrụ nʼoge ụtụtụ, chụọkwa nke ọzọ nʼoge uhuruchi. ");
INSERT INTO ibo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Ị ga-ejikwa lita ụtụ ọka abụọ a kwọziri akwọzi nke a gwọkọtara nʼotu lita mmanụ oliv asụrụ asụ, chụọ aja mkpụrụ ọka. ");
INSERT INTO ibo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Nke a bụ aja nsure ọkụ ahụ Onyenwe anyị nyere iwu ya nʼugwu Saịnaị na a ga na-achụrụ ya mgbe niile, dịka aja isisi ya dị ezi mma, aja nke a chụrụ site nʼọkụ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Mmanya ga-eso aja a ga-abụ otu lita mmanya gbara ụka nʼisi otu atụrụ ọbụla, ị ga-awụsa aja ihe ọṅụṅụ a nʼebe nsọ nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Nʼoge anyasị, ị ga-ewerekwa nwa atụrụ nke abụọ, ya na otu ụdị aja mkpụrụ ọka na aja ihe ọṅụṅụ dị ka i mere nʼụtụtụ, jiri chụọ aja. Nke a bụkwa aja e sitere nʼọkụ chụọ, nke isisi ya dị ezi mma nye Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Nʼụbọchị izuike, jiri ụmụ atụrụ abụọ gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ, ha na aja ihe ọṅụṅụ na aja mkpụrụ ọka e ji lita ụtụ ọka anọ na ọkara a kwọziri akwọzi, nke a gwaziri mmanụ mee. ");
INSERT INTO ibo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Nke a bụ aja nsure ọkụ nke Ụbọchị Izuike, tinyere aja nsure ọkụ na aja ihe ọṅụṅụ ndị ahụ a na-achụ nʼoge ha. ");
INSERT INTO ibo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Ọzọ, nʼụbọchị mbụ nke ọnwa ọbụla, a ga-achụrụ Onyenwe anyị aja nsure ọkụ dị iche, nke a ga-eji ụmụ oke ehi abụọ, na otu ebule, na ụmụ ebule asaa gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ chụọ. ");
INSERT INTO ibo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Tinyere oke ehi ọbụla, ị ga-eji lita ụtụ ọka isii na ọkara a kwọziri nke ọma, nke a gwara mmanụ chụọ aja. Ma lita ụtụ ọka anọ na ọkara a kwọziri nke ọma, nke a gwakọtakwara mmanụ ka a ga-eji chụọ aja mkpụrụ ọka maka otu ebule ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Ma nʼisi otu nwa atụrụ ọbụla, ọ bụ lita ụtụ ọka abụọ a kwọziri nke ọma, nke a gwakọtara ya na mmanụ ka a ga-eji chụọ aja mkpụrụ ọka. A ga-eji ha chụọ aja nsure ọkụ nke isisi ya ga-atọkwa Onyenwe anyị ezi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Aja ọbụla a chụrụ ga-enwe aja ihe ọṅụṅụ nke ga-eso ya, lita mmanya abụọ maka otu oke ehi, ihe ji ntakịrị karịa otu lita mmanya nʼisi otu ebule, na otu lita nʼisi otu nwa atụrụ. Nke a ga-abụ aja nsure ọkụ nke a ga-achụ nʼoge ọnwa ọhụrụ ọ bụla, nʼime afọ ọbụla, ");
INSERT INTO ibo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","nʼagbanyeghị aja nsure ọkụ na aja ihe ọṅụṅụ nke a na-achụ dịka mgbe ha si dị, a ga-eche otu mkpi nʼihu Onyenwe anyị dịka aja mmehie. ");
INSERT INTO ibo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Nʼụbọchị nke iri na anọ nke ọnwa mbụ, ka a ga-edebe Mmemme Ngabiga. Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Nʼụbọchị na-eso ya, bụ abalị iri na ise nke ọnwa ahụ ka a ga-eme mmemme. Nʼime abalị asaa ka a ga-eri achịcha a na-ejighị ihe na-eko achịcha mee. ");
INSERT INTO ibo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Nʼụbọchị mbụ mmemme a bidoro, a ga-akpọ nzukọ dị nsọ nke ndị Izrel niile. Ọ dịghị ọrụ siri ike a ga-arụ nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Unu ga-eji ụmụ oke ehi abụọ, na otu ebule, na ụmụ ebule asaa gbara naanị otu afọ, otu afọ, nke na-enweghị ntụpọ ọbụla chụọrọ Onyenwe anyị aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Nʼisi otu oke ehi ọbụla, a ga-achụ aja mkpụrụ ọka nke a ga-eji lita ụtụ ọka isii na ọkara a kwọziri nke ọma, a gwakọtara ya na mmanụ chụọ. Nʼisi ebule ọbụla, lita ụtụ ọka anọ na ọkara. ");
INSERT INTO ibo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ma nʼisi otu nwa atụrụ ọbụla, a ga-enye lita ụtụ ọka abụọ a kwọziri nke ọma. ");
INSERT INTO ibo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Tinye otu mkpi nʼihi ịchụ aja mmehie maka ikpuchiri unu mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","A ga-achụ aja ndị a, tinyere aja ndị ọzọ niile a na-achụ nʼụbọchị niile. ");
INSERT INTO ibo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","A ga-achụ aja ndị a ụbọchị niile nʼime ụbọchị asaa nke mmemme ahụ. Ha ga-abụ aja nke isisi ha dị Onyenwe anyị ezi ụtọ. A ga-achụ ha, chụkwaa aja nsure ọkụ na aja ihe ọṅụṅụ nke a na-achụ dịka mgbe ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Nʼụbọchị nke asaa nweenụ mkpọkọta dị nsọ, unu arụkwala ọrụ nke ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Nʼụbọchị mbụ nke mkpụrụ mbụ, mgbe unu na-eche onyinye ọka ọhụrụ unu nʼihu Onyenwe anyị nʼoge mmemme Izu Asaa, nweenụ mkpọkọta dị nsọ. Unu arụkwala ọrụ nke ụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Unu ga-achụ aja nsure ọkụ, nke isisi ya dị ezi mma nye Onyenwe anyị. Ọ bụ ụmụ oke ehi abụọ, na otu ebule, na ụmụ ebule asaa gbara otu afọ, otu afọ, ka a ga-eji chụọ aja a. ");
INSERT INTO ibo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ihe unu ga-etinye nʼihe ndị a bụ aja mkpụrụ ọka a ga-eji lita ụtụ ọka isii na ọkara a kwọziri akwọzi, nke a gwakọtara ya na mmanụ chụọ, nʼisi otu oke ehi. Lita ụtụ ọka anọ na ọkara, nʼisi otu ebule, ");
INSERT INTO ibo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na lita ụtụ ọka abụọ, nʼisi otu nwa atụrụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ọzọkwa, a ga-eji otu mkpi chụọ aja maka mkpuchi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Dozie aja ndị a tinyere aja ihe ọṅụṅụ ha, ya na aja nsure ọkụ na aja mkpụrụ ọka ya na aja ahụ so. Hụkwanụ na anụ ụlọ e ji chụọ aja ndị a bụ ndị na-enweghị ntụpọ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Ụbọchị unu ga-egbu opi ike ga-adị nʼabalị mbụ nke ọnwa asaa nʼafọ ọbụla. Nʼụbọchị ahụ, a ga-enwe mkpọkọta dị nsọ nke mmadụ niile. Unu agaghị arụ ọrụ ọbụla nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Nʼụbọchị ahụ, unu ga-achụ aja nsure ọkụ a ga-eji otu oke ehi, na ebule, na ụmụ atụrụ asaa gbara otu afọ, otu afọ ndị na-enweghị ntụpọ, chụọ. Nke a bụ aja na-adị Onyenwe anyị ezi mma, ma na-esi ya isi ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Aja mkpụrụ ọka ka a ga-eji lita ụtụ ọka isii na ọkara a gwakọtara ya na mmanụ chụọ, nʼisi oke ehi ahụ, lita anọ na ọkara, nʼisi ebule, ");
INSERT INTO ibo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na lita abụọ, nʼisi otu nwa atụrụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Tinyere otu mkpi a ga-eji chụọ aja maka mkpuchi mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Aja ndị a niile bụ nke a ga-etinye nye nʼaja nsure ọkụ a na-achụ kwa ọnwa, na aja nsure ọkụ a na-achụ ụbọchị niile, ha na aja mkpụrụ ọka, na aja ihe ọṅụṅụ dịka e depụtara. Ha bụ aja ihe oriri a na-achụrụ Onyenwe anyị, aja nwere isisi dị ụtọ. ");
INSERT INTO ibo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Nʼụbọchị nke iri nke ọnwa asaa ahụ, unu ga-enwekwa nzukọ dị nsọ. Unu ga-ebudata onwe unu nʼala. O nweghịkwa ụdị ọrụ ọbụla unu ga-arụ. ");
INSERT INTO ibo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nʼụbọchị ahụ, unu ga-achụrụ Onyenwe anyị aja nsure ọkụ, nke isisi ya na-atọ ya ụtọ. A ga-eji otu nwa oke ehi, na otu ebule, na ụmụ ebule asaa gbara otu afọ, otu afọ ndị na-enweghị ntụpọ chụọ aja a. ");
INSERT INTO ibo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Aja mkpụrụ ọka ga-eso ya. A ga-eji lita ụtụ ọka isii na ọkara a gwakọtara ya na mmanụ chụọ aja nwa oke ehi ahụ. Jiri lita ụtụ ọka anọ na ọkara chụọ aja ebule, ");
INSERT INTO ibo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","jirikwa lita ụtụ ọka abụọ chụọ aja nʼisi otu nʼime nwa atụrụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Tinyekwa otu mkpi a ga-eji chụọ aja mmehie. A ga-atụkwasị nke a nʼaja mkpuchi mmehie a na-achụ, tinyere aja nsure ọkụ a na-achụ ụbọchị niile, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ niile. ");
INSERT INTO ibo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Nʼụbọchị iri na ise nke ọnwa asaa, a ga-enwe mkpọkọta dị nsọ nke ụmụ Izrel niile. Nʼụbọchị ahụ, onye ọbụla agaghị arụ ọrụ ọbụla, nʼihi na ọ bụ mmalite mmemme abalị asaa nʼihu Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Cheenụ onyinye a na-enye site nʼọkụ nʼihu Onyenwe anyị nke isisi ya na-atọ ya ụtọ, jirinụ oke ehi iri na atọ, na ebule abụọ, na ụmụ ebule iri na anọ ndị na-enweghị ntụpọ, ndị gbara otu afọ, otu afọ, chụọ aja nsure ọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","A ga-atụkwasịkwa aja mkpụrụ ọka nke e ji lita ụtụ ọka isii na ọkara gwakọta ya na mmanụ, nʼisi otu nʼime oke ehi iri na atọ ndị ahụ niile. Lita anọ na ọkara nʼisi otu ebule nʼime ebule abụọ ndị ahụ, ");
INSERT INTO ibo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ma lita abụọ nʼisi otu nʼime nwa atụrụ ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Tinyekwa otu mkpi maka ịchụ aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, tinyere aja mkpụrụ ọka na aja onyinye ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Nʼụbọchị abụọ nke mmemme a, a ga-eji oke ehi iri na abụọ, ebule abụọ, na ụmụ ebule iri na anọ gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ihe ga-eso aja oke ehi, na ebule na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha, bụ aja mkpụrụ ọka, na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Tinyekwa otu mkpi maka aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Nʼụbọchị nke atọ nke mmemme ahụ, ị ga-ewere ụmụ oke ehi iri na otu, na ebule abụọ, na ụmụ ebule iri na anọ ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ, chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ihe ga-eso aja oke ehi na ebule na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha bụ aja mkpụrụ ọka na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Tinyekwa otu mkpi maka aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Nʼụbọchị nke anọ nke mmemme ahụ, ị ga-ewere ụmụ oke ehi iri, ebule abụọ, ụmụ ebule iri na anọ ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ, chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ihe ga-eso aja oke ehi, ebule na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha bụ aja mkpụrụ ọka, na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Tinyekwa otu mkpi maka ịchụ aja mmehie ya na aja nsure ọkụ a na-achụ nʼoge ha, tinyere aja mkpụrụ ọka, na aja onyinye ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Nʼụbọchị nke ise nke mmemme a, ị ga-ewere ụmụ oke ehi itoolu, ebule abụọ na ụmụ ebule iri na anọ ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ihe ga-eso aja oke ehi, ebule na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha bụ aja mkpụrụ ọka na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Tinyekwa otu mkpi maka aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Nʼụbọchị nke isii nke mmemme ahụ, ị ga-ewere ụmụ oke ehi asatọ, na ebule abụọ, na ụmụ ebule iri na anọ ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ, chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ihe ga-eso aja oke ehi, na ebule, na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha bụ aja mkpụrụ ọka, na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Tinyekwa otu mkpi maka aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Nʼụbọchị nke asaa nke mmemme ahụ, were ụmụ oke ehi asaa, ebule abụọ na ụmụ ebule iri na anọ, ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ, chụọ aja. ");
INSERT INTO ibo_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ihe ga-eso aja oke ehi, ebule na ụmụ atụrụ ndị ahụ nʼọnụọgụgụ ha bụ aja mkpụrụ ọka na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Tinyekwa otu mkpi maka aja mmehie, ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Nʼụbọchị nke asatọ ndị Izrel niile ga-enwe oke nzukọ. Ị gaghị arụ ọrụ ọbụla nʼụbọchị ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Chụọ aja nsure ọkụ, nke isisi ya dị Onyenwe anyị ezi ụtọ. Ị ga-eji otu nwa oke ehi, otu ebule na ụmụ ebule asaa ndị gbara otu afọ, otu afọ, ndị na-enweghị ntụpọ ọbụla, chụọ ya. ");
INSERT INTO ibo_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ihe ga-eso aja oke ehi, ebule na ụmụ atụrụ ndị ahụ bụ aja mkpụrụ ọka na aja ihe ọṅụṅụ dịka e si nye ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Tinyekwa otu mkpi maka aja mmehie ya na aja nsure ọkụ a na-achụ nʼoge ha, na aja mkpụrụ ọka, na aja ihe ọṅụṅụ so ha. ");
INSERT INTO ibo_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Tinyere onyinye a na-enye dịka nkwa e kwere si dị, na onyinye afọ ofufu unu, unu ga-akwadoro Onyenwe anyị onyinye ndị a nʼoge mmemme a kara aka unu: aja nsure ọkụ unu, onyinye mkpụrụ ọka na onyinye ihe ọṅụṅụ na aja udo.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ya mere Mosis gwara ụmụ Izrel ihe niile Onyenwe anyị nyere ya nʼiwu ịgwa ha. ");
INSERT INTO ibo_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mosis kpọkọtara ndị ndu ebo Izrel niile gwa ha sị: “Ihe ndị a ka Onyenwe anyị nyere nʼiwu: ");
INSERT INTO ibo_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mgbe nwoke ọbụla kwere Onyenwe anyị nkwa, maọbụ ṅụọ iyi ime ihe ọbụla, ọ gaghị emebi nkwa dị otu a. Kama ọ ga-emezu ihe niile dịka o kwuru ya. ");
INSERT INTO ibo_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Ọ bụrụ na nwaagbọghọ nọ nʼụlọ nna ya ekwe Onyenwe anyị nkwa maọbụ ṅụọ iyi ime ihe ọbụla, ");
INSERT INTO ibo_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ọ bụrụ na nna ya anụ mgbe ọ na-ekwe nkwa maọbụ ṅụọ iyi ime ihe ahụ, ma gba ya nkịtị, onye dị otu a aghaghị imezu nkwa niile ndị ahụ o kwere. ");
INSERT INTO ibo_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ma ọ bụrụ na nna ya ajụ mgbe ọ nụrụ banyere ya na ọ gaghị emezu nkwa dị otu ahụ, mgbe ahụ, nkwa ahụ maọbụ iyi ọ ṅụrụ ga-abụ ihe efu. Onyenwe anyị ga-agbaghakwara ya, nʼihi na nna ya jụrụ na ọ ga-emezu nkwa ya. ");
INSERT INTO ibo_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ọ bụrụ na o mesịa lụọ dị, mgbe ọ ṅụsịrị iyi, maọbụ kwee nkwa nzuzu o kwesiri imezu, ");
INSERT INTO ibo_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","di ya nụ banyere ya ma gba ya nkịtị nʼụbọchị ahụ ọ nụrụ ya, nkwa ahụ ga-eguzogide, ọ ga-emezu ya. ");
INSERT INTO ibo_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ma ọ bụrụ na di ya ajụ ịnabata nkwa ahụ, maọbụ ọṅụṅụ iyi nzuzu ahụ, ọjụjụ di ya jụrụ nkwa ahụ ga-eme ka iyi ahụ maọbụ nkwa ahụ ghara ịdị ire. Onyenwe anyị ga-agbaghakwara ya. ");
INSERT INTO ibo_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ma nkwa ọbụla nke nwanyị di ya nwụrụ maọbụ nwanyị ya na di ya kewara, ihe ọbụla nke o ji ọnụ ya kwuo ka ọ ghaghị imezu. ");
INSERT INTO ibo_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Ma ọ bụrụ na nwanyị ya na di ya bi e kwee nkwa maọbụ site na kwagide ṅụọ iyi, ");
INSERT INTO ibo_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","di ya nụ ihe banyere ya, ma gba nkịtị maọbụ ogbochighị ya, mgbe ahụ, ịṅụ iyi na nkwa ndị ahụ niile nke o kwere ga-eguzo. ");
INSERT INTO ibo_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ma ọ bụrụ na di ya jụrụ ikwenye ka nkwa ahụ dịgide nʼụbọchị mbụ ọ nụrụ ya, nkwa ahụ maọbụ ọṅụṅụ iyi ahụ aghọọla ihe efu. Onyenwe anyị ga-agbaghakwara ya. ");
INSERT INTO ibo_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ya mere, di ya nwere ike ịjụ, maọbụ mesie nkwa ahụ, maọbụ iyi ahụ ọ ṅụrụ ike. ");
INSERT INTO ibo_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ọ bụrụ na di ya ekwughị ihe ọbụla site nʼotu ụbọchị ruo nʼụbọchị ọzọ, mgbe ahụ, o gosiri na o kwenyere ka nwunye ya mezuo nkwa maọbụ iyi ndị ahụ niile. ");
INSERT INTO ibo_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ọ bụrụ na o mesịa jụ na nwunye ya agaghị emezu nkwa ahụ ọ kwere, ikpe ọmụma niile dị nʼihi emezughị nkwa ahụ dị ya nʼisi.” ");
INSERT INTO ibo_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ndị a bụ usoro iwu Onyenwe anyị nyere Mosis banyere mmekọrịta nke nwoke na nwunye ya. Ọ metụtakwara nna na nwa ya nwanyị onye bi nʼụlọ ya. ");
INSERT INTO ibo_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Taa ndị Midia ahụhụ, ka i si otu a bọọrọ ndị Izrel ọbọ ihe ọjọọ ndị Midia mere ha. Mgbe i mesịrị nke a, ị ga-anwụ.” ");
INSERT INTO ibo_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ya mere, Mosis gwara ndị Izrel okwu sị, “Kwadoonụ ndị ikom unu ibuso ndị Midia agha, maka ịbọtara Onyenwe anyị ọbọ. ");
INSERT INTO ibo_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Sinụ nʼebo ọbụla dị nʼIzrel gụpụta puku ndị ikom puku ndị ikom.” ");
INSERT INTO ibo_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ya mere, e sitere nʼigwe ndị ikom niile nọ nʼIzrel zipụ puku ndị ikom iri na abụọ, ka ha gaa buo agha. Ebo ọbụla zipụrụ otu puku ndị ikom. ");
INSERT INTO ibo_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mosis zipụrụ ha ibu agha, otu puku, otu puku site nʼebo ọbụla. Finehaz nwa Elieza, onye nchụaja, du ha gaa agha ahụ. O bu ngwongwo si nʼebe nsọ, tinyere opi ike nke a ga-afụ. ");
INSERT INTO ibo_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ha busoro ndị Midia agha dịka Onyenwe anyị nyere Mosis nʼiwu. Ha gburu onye ọbụla bụ nwoke. ");
INSERT INTO ibo_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Nʼime ndị ha gburu nʼagha ahụ bụ ndị eze Midia ise a na-akpọ Evi, Rekem, Zua, Hua na Reba. Ha jikwa mma agha gbuo Belam nwa Beoa. ");
INSERT INTO ibo_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ndị agha Izrel chịkọtara ndị inyom niile, na ụmụntakịrị niile nọ nʼala Midia dịka ndị ha dọtara nʼagha. Ha chịkọtara ngwongwo niile ndị Midia ji biri, tinyere igwe ehi, na igwe ewu na atụrụ ha niile, dịka ihe ha dọtara nʼagha. ");
INSERT INTO ibo_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Emesịa, ha mụnyere ọkụ nʼobodo ndị Midia niile na ebe ha mara ụlọ ikwu, rechapụ ha nʼọkụ. ");
INSERT INTO ibo_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ha chịkọtara ihe niile ha dọtara nʼagha, ma mmadụ ma anụ ụlọ. ");
INSERT INTO ibo_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ndị a niile ha dọtara nʼagha na ngwongwo niile ha lụtara nʼagha ka ha buteere Mosis, na Elieza onye nchụaja na ọgbakọ Izrel niile na mbara ala Moab, nʼakụkụ osimiri Jọdan na ncherita ihu Jeriko. ");
INSERT INTO ibo_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mosis na Elieza onye nchụaja na ndị ndu ọgbakọ Izrel niile pụrụ gaa zute ha nʼazụ ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ma Mosis were iwe megide ndịisi agha, ya bụ ndị ahụ na-achị imerime puku ndị agha, na ndị ọchịagha na-achị narị ndị agha, ndị si ibu agha lọta. ");
INSERT INTO ibo_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mosis jụrụ ha sị, “Gịnị mere unu ji debe ndị inyom niile ndị a ndụ? ");
INSERT INTO ibo_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ọ bụ ndị a bụ ndị gbasoro ndụmọdụ Belam, rafuo ndị Izrel mee ka ha ghọọ ndị na-ekwesighị ntụkwasị obi nye Onyenwe anyị nʼihe gbasara okwu Peoa. Ọ bụ nke a mere ka nrịa nrịa ọjọọ ahụ na-efe efe dakwasị ndị nke Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ugbu a, gbuonụ ụmụnta ndị nwoke niile, na ndị inyom niile matarala nwoke. ");
INSERT INTO ibo_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Naanị ụmụntakịrị ndị nwanyị ha nke nwoke na-edinabeghị ka unu ga-ahapụ ka ha dịrị ndụ. Unu nwere ike debere onwe unu ndị dị otu a. ");
INSERT INTO ibo_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ma ugbu a, unu niile bụ ndị soro gbuo mmadụ, maọbụ bitụ ozu ha aka, unu abatala nʼime ogige Izrel tutu ụbọchị asaa agafee. Nʼoge a, doonụ onwe unu ọcha, dokwaanụ ndị niile unu dọtara nʼagha ọcha, nʼụbọchị nke atọ na nʼụbọchị nke asaa. ");
INSERT INTO ibo_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Debekwanụ uwe niile ọcha, ya na ihe niile e ji akpụkpọ anụ na ajị ewu, maọbụ osisi, mee.” ");
INSERT INTO ibo_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mgbe ahụ, Elieza onye nchụaja gwara ndị ikom niile ahụ jere agha okwu sị ha, “Nke a bụ iwu Onyenwe anyị nyere Mosis. ");
INSERT INTO ibo_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Otu ọ dị ọlaedo, ọlaọcha, bronz, igwe, gbamgbam na opu, ");
INSERT INTO ibo_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na ihe ọ bụla ọzọ bụ nke ga-anagide ọkụ, ka a ga-eme ka ọ gabiga site nʼọkụ, mgbe ahụ ọ ga-adịkwa ọcha. Ma aghaghị ịga nʼihu ime ka ha dị ọcha site nʼịsacha ha nʼime mmiri nke nsacha. Ma ihe ọbụla nke na-agaghị anagide ọkụ ka a ga-eji mmiri sachaa, maka ido ya ọcha. ");
INSERT INTO ibo_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Nʼụbọchị nke asaa, unu aghaghị ịsacha uwe unu niile, bụrụ ndị dị ọcha. Mgbe ahụ, unu pụrụ ịlọghachi nʼọmụma ụlọ ikwu ndị Izrel.” ");
INSERT INTO ibo_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Ma Onyenwe anyị sịrị Mosis, ");
INSERT INTO ibo_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Gị na Elieza onye nchụaja, na ndịisi ezinaụlọ nke ọgbakọ Izrel niile, ga-agụkọ ihe niile unu dọtara nʼagha chọpụta ọnụọgụgụ mmadụ na anụmanụ. ");
INSERT INTO ibo_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mgbe ahụ, kee ihe ndị a niile ụzọ abụọ. Ọkara ya ga-abụ nke ndị ikom ahụ niile gara agha, ma ọkara nke ọzọ ka a ga-enye ọgbakọ Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ma Onyenwe anyị nwere oke site nʼoke ndị ahụ jere agha: mmadụ, na ehi niile, na ịnyịnya ibu niile, na atụrụ na ewu niile. Oke Onyenwe anyị bụ otu ụzọ nʼime narị ise ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Nye Elieza onye nchụaja oke sitere nʼaja a dịka ihe Onyenwe anyị ketara. ");
INSERT INTO ibo_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Otu aka ahụ kwa, site nʼoke ndị Izrel ga-eketa, kee ụtụ. Otu ụzọ nʼime iri ise, maọbụ mmadụ, maọbụ ehi, maọbụ ịnyịnya ibu, maọbụ atụrụ, maọbụ ewu, maọbụ igwe anụ ụlọ ụzọ. Were ha nye ndị Livayị, ndị ọ dị nʼaka ilekọta ụlọ nzute Onyenwe anyị, ka ọ bụrụ oke nke ha.” ");
INSERT INTO ibo_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ya mere, Mosis na Elieza onye nchụaja mere dịka Onyenwe anyị nyere ha nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ihe nweta bụ nke fọdụrụ nʼihe ndị agha lụtara nʼagha bụ ndị a, bụ atụrụ dị narị puku isii, iri puku asaa na puku ise (675,000), ");
INSERT INTO ibo_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Ehi dị iri puku asaa na puku abụọ (72,000), ");
INSERT INTO ibo_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ịnyịnya ibu dị iri puku isii na otu puku (61,000), ");
INSERT INTO ibo_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Ụmụ agbọghọ na-amatabeghị nwoke dị iri puku atọ na puku abụọ (32,000). ");
INSERT INTO ibo_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ya mere, ọkara e nyere ndị gara lụọ agha dị: Igwe ewu na atụrụ dị narị puku atọ na iri puku atọ na puku asaa na narị ise (337,500). ");
INSERT INTO ibo_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Nʼime ya, ụtụ e nyere Onyenwe anyị site nʼigwe atụrụ ahụ dị narị isii na iri asaa na ise (675). ");
INSERT INTO ibo_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Igwe ehi dị iri puku atọ na puku isii (36,000). Nʼime ya, ihe e nyere Onyenwe anyị bụ iri asaa na abụọ (72). ");
INSERT INTO ibo_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ịnyịnya ibu dị iri puku atọ na narị ise (30,500). Nke e nyere Onyenwe anyị bụ iri isii na otu (61). ");
INSERT INTO ibo_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ọnụọgụgụ ụmụ agbọghọ dị puku iri na isii (16,000). Ndị e nyere Onyenwe anyị dị iri atọ na abụọ (32). ");
INSERT INTO ibo_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mosis nyere Elieza bụ onye nchụaja Onyenwe anyị oke nʼihe ndị ahụ niile a tụrụ nʼụtụ, dịka Onyenwe anyị nyere Mosis nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ma ọkara nke ahụ dịrị ndị Izrel, nke Mosis kewapụtara site na nke ndị ikom lụrụ agha. ");
INSERT INTO ibo_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Ọkara nke nzukọ dị, igwe ewu na atụrụ, narị puku atọ, iri puku atọ, puku asaa na narị ise (337,500), ");
INSERT INTO ibo_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","igwe ehi, iri puku atọ na isii (36,000), ");
INSERT INTO ibo_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ịnyịnya ibu, iri puku atọ na narị ise (30,500), ");
INSERT INTO ibo_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ụmụ agbọghọ, puku iri na isii (16,000). ");
INSERT INTO ibo_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Site nʼoke ndị Izrel Mosis họpụtara otu ụzọ nʼime iri ise, ma mmadụ ma anụ ụlọ dịka Onyenwe anyị nyere nʼiwu. O nyere ha ndị Livayị na-elekọta ụlọ nzute Onyenwe anyị mmadụ na anụ ụlọ ndị a. ");
INSERT INTO ibo_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Mgbe ahụ, ndịisi agha niile na ndị ọchịagha na-achị imerime puku ndị agha, na ndị na-achị narị ndị agha bịakwutere Mosis, ");
INSERT INTO ibo_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","sị ya, “Ndị ohu gị agụọla ndị niile gara agha nọ nʼokpuru anyị, chọpụta na o nweghị onye ọbụla a na-achọ achọ. ");
INSERT INTO ibo_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ya mere, anyị wetaara Onyenwe anyị onyinye site nʼihe anyị kwatara nʼagha. Onyinye anyị bụ ihe onye ọbụla nwetara, ihe ọlaedo a na-agba nʼụkwụ na mgbaaka, na ọlaaka ikike, na ọlantị na ihe iyi nʼolu niile, i ji ha chụọ aja mkpuchi mmehie nʼihi onwe anyị nʼihu Onyenwe anyị.” ");
INSERT INTO ibo_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mosis na Elieza onye nchụaja natara onyinye ọlaedo ndị ahụ bụ ihe a kpụrụ akpụ site nʼaka ha. ");
INSERT INTO ibo_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ịdị arọ nke ihe ọlaedo niile nke ndị ọchịagha na-achị imerime puku ndị agha, na ndị na-achị narị ndị agha, nke Mosis na Elieza chere nʼihu Onyenwe anyị dịka onyinye, dị narị kilogram na iri itoolu. ");
INSERT INTO ibo_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Ndị ahụ lụrụ agha ahụ nwekwara ọtụtụ ihe ndị ọzọ ha debeere onwe ha. ");
INSERT INTO ibo_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mosis na Elieza onye nchụaja natara onyinye ọlaedo ndị a dị iche site nʼaka ndị ọchịagha na-achị ọtụtụ puku ndị agha na narị ndị agha. E webatara onyinye ndị a nʼụlọ nzute, debe ha nʼihu Onyenwe anyị ka ọ bụrụ ihe ncheta nye Onyenwe anyị nʼihi ndị Izrel niile. ");
INSERT INTO ibo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Mgbe ndị Izrel rutere ala Jeza na Gilead, ndị ebo Ruben na Gad ndị nwere ọtụtụ igwe ehi, na igwe ewu na atụrụ chọpụtara na ala ahụ dị mma nke ukwuu maka ịzụ anụ ụlọ. ");
INSERT INTO ibo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Ya mere, ha bịakwutere Mosis na Elieza onye nchụaja, na ndị ndu nzukọ Izrel, sị ha, ");
INSERT INTO ibo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ala ndị a: Atarọt, Dibọn, Jeza, Nimra, Heshbọn, Eleale, Sebam, Nebo, na Beon, ");
INSERT INTO ibo_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","bụ ala nke Onyenwe anyị meriri nʼagha nʼihu nzukọ Izrel, dị mma maka ịzụ anụ ụlọ. Anyị onwe anyị kwa nwere igwe ewu na atụrụ. ");
INSERT INTO ibo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ọ bụrụ na anyị achọtala amara nʼihu unu, biko, kwerenụ ka akụkụ ala a bụrụ ihe nketa nke anyị bụ ohu unu. Unu emekwala ka anyị soro ndị Izrel gafee nʼakụkụ nke ọzọ nke osimiri Jọdan.” ");
INSERT INTO ibo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mosis jụrụ ndị Gad na Ruben ajụjụ sị, “Unu na-ekwu na unu chọrọ ịnọ nʼebe a mgbe ụmụnna unu ndị ikom niile ga-agafe osimiri Jọdan ịlụ agha niile ahụ dị na-eche ha? ");
INSERT INTO ibo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ọ bụ nʼihi gịnị ka unu ji eme ka ndị Izrel daa mba ghara ịgafe banye nʼala ahụ Onyenwe anyị nyerela ha? ");
INSERT INTO ibo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Otu a ka nna unu ha mere mgbe m si Kadesh Banea zipụ ha inyocha ala ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Mgbe ha letasịrị ala ahụ si na Ndagwurugwu Eshkọl lọghachi, ha mere ka obi ndị Izrel niile daa mba ịbanye nʼala ahụ Onyenwe anyị nyere ha. ");
INSERT INTO ibo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Nʼihi nke a Onyenwe anyị were iwe dị ọkụ megide ha nʼụbọchị ahụ. Ọ ṅụrụ iyi kwuo sị, ");
INSERT INTO ibo_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nʼihi na unu jụrụ iji obi unu niile gbasoo m, o nweghị onye ọbụla nʼime ndị ahụ o si nʼala Ijipt kpọpụta, ndị gbara iri afọ abụọ rigoo, ga-ahụ ala ahụ m kwere Ebraham na Aịzik na Jekọb nkwa inye ha.’ ");
INSERT INTO ibo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Naanị ndị ọṅụṅụ iyi a na-emegideghị bụ Kaleb, nwa Jefune onye Keniz, na Joshua nwa Nun, nʼihi na ha jiri obi ha niile sogide Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Iwe Onyenwe anyị dịịrị ọkụ megide Izrel, o mere ka ha wagharịa nʼọzara iri afọ anọ, tutu ruo mgbe ọgbọ ahụ niile nke mere ihe ọjọọ nʼanya ya nwụchara. ");
INSERT INTO ibo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ma lee unu ugbu a, agbụrụ ndị mmehie, ọ bụkwa otu ihe ahụ ka unu na-eme! Unu na-achọ ime ka iwe dị ukwuu wee Onyenwe anyị megide ndị Izrel. ");
INSERT INTO ibo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ọ bụrụ na unu ajụ iso Onyenwe anyị ugbu a, Onyenwe anyị ga-emekwa ka ndị Izrel nọgide nʼọzara. Mbibi na ịla nʼiyi nke ga-abịakwasị ha ga-abụkwa nke unu ji aka unu kpatara ha.” ");
INSERT INTO ibo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ma ha zara sị ya, “Ọ gaghị adị otu a! Anyị ga-ewuru anụ ụlọ anyị ụlọ, tinye igwe ewu na atụrụ anyị nʼime ha. Anyị ga-ewukwara ndị nwunye anyị na ụmụntakịrị anyị obodo ebe ha ga-anọ. ");
INSERT INTO ibo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ma anyị onwe anyị ga-eburu ngwa agha anyị, buru ndị Izrel niile ọzọ ụzọ gaa nʼihu ịlụ ọgụ, tutu anyị edubata ha nʼala nke ha ga-eketa. Ma ndị nwunye anyị na ụmụntakịrị anyị ga-anọ nʼobodo e wusiri ike, ikpuchite ezinaụlọ anyị niile site nʼaka ndị iro bi anyị gburugburu. ");
INSERT INTO ibo_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Anyị agaghị alọta nʼụlọ anyị tutu onye Izrel ọbụla enweta ihe nketa nke ya. ");
INSERT INTO ibo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Anyị achọghị ihe nketa, nʼofe Jọdan nke ọzọ, nʼihi na anyị ewerela oke nke anyị nʼebe a, nʼakụkụ ọwụwa anyanwụ Jọdan.” ");
INSERT INTO ibo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mgbe ahụ, Mosis zara sị ha, “Ọ dị mma, ọ bụrụ na unu ga-eme dịka unu kwuru, jikere onwe unu, nʼihu Onyenwe anyị, ibu agha. ");
INSERT INTO ibo_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Ọ bụrụ na ndị agha unu ga-eso gafee nʼofe ọzọ nke osimiri Jọdan, soro ndị ọzọ buo agha tutu ruo mgbe Onyenwe anyị chụpụchara ndị iro ya niile, ");
INSERT INTO ibo_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","mgbe ahụ, e merichaa mba ndị ahụ niile nʼihu Onyenwe anyị, unu nwere ike ịlọghachi nʼebe a, bụrụ ndị ikpe na-amaghị nʼebe Onyenwe anyị na ndị Izrel nọ. Ala a dị nʼọwụwa anyanwụ, ga-abụ ihe nketa unu nwere site nʼaka Onyenwe anyị. ");
INSERT INTO ibo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Ọ bụrụkwanụ na unu ajụ ime dịka unu kwuru, mgbe ahụ, ọ bụ Onyenwe anyị ka unu na-emehie megide. Matakwanụ na unu ga-emesịa nata ụgwọ ọrụ mmehie unu. ");
INSERT INTO ibo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Wuonụ obodo ebe ndị inyom na ụmụ unu ga-ebi, wuokwanụ ụlọ anụ maka igwe ewu na atụrụ unu, ma mezuokwanụ ihe niile unu kweere na nkwa.” ");
INSERT INTO ibo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ndị ebo Gad na Ruben sịrị Mosis, “Anyị bụ ndị ohu gị ga-eme dịka onyenwe anyị nyere nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ụmụ anyị niile, na ndị inyom anyị niile, na igwe ewu na atụrụ anyị, na ehi anyị niile, ga-anọ nʼebe a, nʼobodo ndị a anyị wuru nʼala Gilead. ");
INSERT INTO ibo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ma anyị, ndị ohu gị, ndị niile tozuru ije agha, ga-agafe osimiri Jọdan ibu agha nʼihu Onyenwe anyị, dịka onyenwe anyị si kwuo.” ");
INSERT INTO ibo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Mgbe ahụ, Mosis nyere Elieza, bụ onye nchụaja, na Joshua nwa Nun, na ndịisi ezinaụlọ nke ebo Izrel niile iwu banyere ha, ");
INSERT INTO ibo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Ọ sịrị ha, “Ọ bụrụ na ndị ebo Gad na Ruben, onye ọbụla nke jikere ịga agha, ga-eso unu gafee Jọdan nʼihu Onyenwe anyị, mgbe ahụ, oge unu lụgburu ndị ala ahụ niile, unu aghaghị inye ha ala Gilead dịka ihe nketa ha. ");
INSERT INTO ibo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ma ọ bụrụ na ha ajụ iso unu, ha ga-eso ndị ọzọ keta oke nʼala Kenan.” ");
INSERT INTO ibo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ndị ebo Gad na Ruben zara sị, “Ihe ọbụla Onyenwe anyị nyere nʼiwu ka anyị ga-eme. ");
INSERT INTO ibo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Anyị ga-ejikere soro Onyenwe anyị jee agha nʼala Kenan. Ma ihe nketa anyị ga-adị nʼebe a, nʼakụkụ Jọdan.” ");
INSERT INTO ibo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mosis nyere ndị ebo Gad, na Ruben, na ọkara Manase nwa Josef, alaeze niile Saịhọn eze Amọrị nakwa alaeze niile nke Ọg, eze ndị Bashan na-achị. O nyere ha ala ahụ niile, na obodo niile dị nʼala ahụ gburugburu. ");
INSERT INTO ibo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Ndị ebo Gad wugharịrị ma wusiekwa obodo ndị a, Dibọn, Atarọt, Aroea ");
INSERT INTO ibo_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrọt-Shofan, Jeza, Jogbeha, ");
INSERT INTO ibo_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra na Bet-Haran bụ obodo e wusiri ike, wukwaara igwe ewu na atụrụ ha ụlọ anụ nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ma ndị ebo Ruben wugharịrị obodo ndị a: obodo Heshbọn, Eleale, Kiriatem, ");
INSERT INTO ibo_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo na Baal-Meon (ma a gbanwere aha ha) na Sibma. Ha gbanwere aha obodo niile ndị ahụ ha wugharịrị, gụọ ha aha ọhụrụ. ");
INSERT INTO ibo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ndị agbụrụ Makia, nwa Manase gara nʼobodo Gilead lụgbuo ya, chụpụ ndị Amọrait bi nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ya mere, Mosis were obodo Gilead nye Makia, ụmụ Manase ka ha biri nʼebe ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jia, onye sikwa nʼebo Manase gara buso ọtụtụ obodo nta ndị ọzọ agha, lụgbuo ha. Ọ gbanwere aha obodo nta ndị a, gụọ ha Havọt Jaịa. ");
INSERT INTO ibo_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nʼoge a kwa, otu nwoke a na-akpọ Nọba duuru ndị agha gaa nʼobodo Kenat, na nʼobodo nta ndị ọzọ gbara ya gburugburu, lụgbuo ha, bichie nʼime ha. Ọ gbanwere aha obodo ndị ahụ niile bido ịkpọ ha Nọba, nke bụ aha ya onwe ya. ");
INSERT INTO ibo_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ndị a bụ usoro mbili ije ụmụ Izrel, site nʼoge ha hapụrụ Ijipt dịka ha si nọọ nʼigwe nʼigwe. Ọ bụ Mosis na Erọn duuru ha nʼije ndị a. ");
INSERT INTO ibo_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mosis, nʼonwe ya, dere usoro ije ha ndị a nʼakwụkwọ dịka Onyenwe anyị nyere ya nʼiwu. ");
INSERT INTO ibo_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ha biliri njem site na Ramesis, nʼụbọchị nke iri na ise nʼọnwa nke mbụ, ụbọchị na-esota nke e mere Mmemme Ngabiga. Ha niile zọpụrụ ije nʼatụghị egwu nʼihu ndị Ijipt, ");
INSERT INTO ibo_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","mgbe ndị ha nọ na-eli ụmụ ha niile ndị e buru ụzọ mụọ, bụ ndị Onyenwe anyị tigburu nʼetiti ha nʼihi na Onyenwe anyị kpere chi ha niile ikpe. ");
INSERT INTO ibo_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Ndị Izrel hapụrụ Ramesis, bịa maa ụlọ ikwu ha na Sukọt. ");
INSERT INTO ibo_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ha hapụrụ Sukọt bịaruo Etam, nke dị nʼọnụ ọnụ ọzara ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ha hapụrụ Etam laghachi azụ gaa Pi Hahirot, nke dị nso nʼakụkụ ọwụwa anyanwụ Baal-Zefọn, ebe ha manyere ụlọ ikwu ha na ndịda ugwu Migdol. ");
INSERT INTO ibo_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Mgbe ha hapụrụ Pi Hahirot, ha sitere nʼetiti Osimiri Uhie gafee gaa ije ụbọchị atọ bata nʼọzara Etam. Ha manyere ụlọ ikwu ha na Mara. ");
INSERT INTO ibo_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Mgbe ha hapụrụ Mara, ha batara Elim, ebe e nwere mmiri iri na abụọ si nʼala na-asọpụta, na iri osisi nkwụ asaa. Ha nọrọ ọdụ dị ukwuu nʼebe a. ");
INSERT INTO ibo_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Mgbe ha hapụrụ Elim, ha wuru ụlọ ikwu ha nʼakụkụ Osimiri Uhie. ");
INSERT INTO ibo_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Emesịa, ha hapụrụ Osimiri Uhie gaa maa ụlọ ikwu ha nʼọzara a na-akpọ Sin. ");
INSERT INTO ibo_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ha hapụrụ ọzara Sin gaa maa ụlọ ikwu ha na Dofka. ");
INSERT INTO ibo_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Emesịa, ha hapụrụ Dofka bịaruo Alush maa ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Mgbe ha hapụrụ Alush, ha rutere Refidim, ebe ndị Izrel na-ahụghị mmiri ọṅụṅụ. ");
INSERT INTO ibo_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ha hapụrụ Refidim bịaruo nʼọzara Saịnaị ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Ha hapụrụ ọzara Saịnaị bịaruo Kibrọt Hataava ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ha hapụrụ Kibrọt Hataava bịaruo Hazerọt ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ha hapụrụ Hazerọt bịaruo Ritma ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ha hapụrụ Ritma bịaruo Rimon-Perez ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Ha hapụrụ Rimon-Perez bịaruo Libna ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ha hapụrụ Libna bịaruo Rissa ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ha hapụrụ Rissa bịaruo Kehelata ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ha hapụrụ Kehelata bịaruo nʼugwu Shefa ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Ha hapụrụ ugwu Shefa bịaruo Harada ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Ha hapụrụ Harada bịaruo Makhelot ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ha hapụrụ Makhelot bịaruo Tahat ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Ha hapụrụ Tahat bịaruo Tera ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Ha hapụrụ Tera bịaruo Mitka ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ha hapụrụ Mitka bịaruo Hashmona ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ha hapụrụ Hashmona bịaruo Moserot ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Ha hapụrụ Moserot bịaruo Bene Jaakan ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ha hapụrụ Bene Jaakan bịaruo Họ Hagịdgad ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Ha hapụrụ Họ Hagịdgad bịaruo Jotbata ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Ha hapụrụ Jotbata bịaruo Abrona ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ha hapụrụ Abrona bịaruo Eziọn Geba ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Ha hapụrụ Eziọn Geba bịa maa ụlọ ikwu ha na Kadesh, nke dị nʼọzara Zin. ");
INSERT INTO ibo_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ha hapụrụ Kadesh bịa maa ụlọ ikwu ha nʼugwu Hor nʼoke ala ndị Edọm. ");
INSERT INTO ibo_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Erọn, bụ onye nchụaja gbagoro nʼugwu Hor site nʼiwu Onyenwe anyị. Nʼebe ọ nọ nwụọ, nʼụbọchị mbụ nke ọnwa nke ise, nʼafọ nke iri anọ site na mgbe ụmụ Izrel si Ijipt pụta. ");
INSERT INTO ibo_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Erọn gbara narị afọ na iri afọ abụọ na atọ mgbe ọ nwụrụ nʼugwu Hor. ");
INSERT INTO ibo_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Onye Kenan bụ eze Arad, onye bi na Negev nʼime ala Kenan, nụrụ na ndị Izrel na-abịa. ");
INSERT INTO ibo_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ha hapụrụ ugwu Hor bịaruo Zalmona ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Ha hapụrụ Zalmona bịaruo Punon ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Ha hapụrụ Punon bịaruo Obot ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ha hapụrụ Obot bịaruo Iye Abarim, nʼoke ala ndị Moab. ");
INSERT INTO ibo_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Ha hapụrụ Iye Abarim bịaruo Dibọn Gad ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Ha hapụrụ Dibọn Gad bịaruo Almon Diblataim ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Ha hapụrụ Almon Diblataim bịaruo nʼugwu Abarim nke dị nso na Nebo ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ha hapụrụ ugwu Abarim bata nʼobosara ala Moab nʼakụkụ osimiri Jọdan, na ncherita ihu Jeriko, ebe ha mara ụlọ ikwu ha. ");
INSERT INTO ibo_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Mgbe ha nọ nʼebe a, ha manyere ụlọ ikwu ha nʼebe dị iche iche nʼakụkụ osimiri Jọdan, site na Bet-Jeshimọt rute rịị ebe a na-akpọ Ebel-Shitim, nʼobosara ala Moab. ");
INSERT INTO ibo_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Nʼobosara ala Moab, nʼakụkụ Jọdan, na ncherita ihu Jeriko ka Onyenwe anyị nọ gwa Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Gwa ụmụ Izrel okwu sị ha, ‘Mgbe unu gafere osimiri Jọdan banye nʼala Kenan, ");
INSERT INTO ibo_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","unu aghaghị ịchụpụ ndị niile bi nʼebe ahụ ma bibie chi niile ha na-efe, ndị ha ji nkume tụọ na ndị ha kpụrụ akpụ. Unu ga-ebibikwa ebe niile dị nʼelu ugwu niile, ebe ha na-anọ efe arụsị ha niile ofufe. ");
INSERT INTO ibo_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Nwetanụ ala ahụ, birikwa nʼime ya, nʼihi na enyela m unu ala ahụ ka unu nwere ya. ");
INSERT INTO ibo_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Unu ga-eke ala ahụ site nʼife nza, dịka agbụrụ unu niile si dị. Ndị bara ụba nye ha ihe nketa dị ukwuu, ndị dị ole na ole nye ha ihe nketa dị nta. Ihe ọ bụla ruuru agbụrụ ọbụla site nʼife nza ga-abụ nke ha. Kee ya dịka ebo nna nna unu ha si dị. ");
INSERT INTO ibo_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Ma ọ bụrụ na unu achụpụghị ndị niile bi nʼala ahụ, ndị unu hapụrụ ga-abụrụ unu iberibe unyi nʼanya unu. Ha ga-adịkwara unu ka ogwu nke ga-adụkasị unu ahụ. Ha ga-enye unu nsogbu nʼala ahụ unu na-aga ibi nʼime ya. ");
INSERT INTO ibo_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Mgbe ahụ kwa, aga m emeso unu ụdị mmeso ahụ m na-akwado imeso ha ugbu a.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Nye ndị Izrel iwu sị ha, ‘Mgbe unu banyere nʼala Kenan, ndị a bụ oke ala ndị ahụ unu ga-enweta dịka ihe nketa unu: ");
INSERT INTO ibo_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Oke ala unu nʼakụkụ ndịda ga-etinyetụ aka nʼọzara Zin. Ala unu na ala ndị Edọm ga-enwekọ oke ala. Nʼakụkụ ọwụwa anyanwụ, oke ala ndịda unu ga-ebido na ngwụcha Osimiri Nnu, ");
INSERT INTO ibo_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","gafee ndịda Akrabim, gabiga ruo ọzara Zin, gbada ndịda ruo Kadesh Banea. Site nʼebe ahụ ọ ga-aga ruo Haza Ada, gafee ruo Azmọn, ");
INSERT INTO ibo_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ebe ọ ga-echigharị gbasoro iyi Wadi nke Ijipt ma kwụsị nʼosimiri Mediterenịa. ");
INSERT INTO ibo_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Oke ala unu nʼakụkụ ọdịda anyanwụ ga-abụ ọnụ mmiri osimiri Mediterenịa. Nke a ga-abụ oke ala unu. ");
INSERT INTO ibo_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Oke ala unu nʼakụkụ ugwu ga-amalite nʼosimiri Mediterenịa ruo nʼugwu Hor. ");
INSERT INTO ibo_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Ọ ga-esitekwa nʼugwu Hor ruo Lebo Hamat, gbatịakwa ruo Zedad, ");
INSERT INTO ibo_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ruo Zifron tutu kwụsị na Haza Enan. Nke a ga-abụ oke ala unu nʼakụkụ ugwu. ");
INSERT INTO ibo_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Oke ala unu nʼakụkụ ọwụwa anyanwụ ga-ebido na Haza Enan ruo Shefam. ");
INSERT INTO ibo_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Oke ala ahụ ga-agbada site Shefam ruo Ribla nʼakụkụ ọwụwa anyanwụ Ain. Site nʼebe ahụ, ọ ga-agbasoro ndịda ọdịda anyanwụ Osimiri Galili. ");
INSERT INTO ibo_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Mgbe ahụ, ọ ga-aga ogologo ogologo, gbasoro osimiri Jọdan, tutu kwụsị nʼOsimiri Nnu. “ ‘Nke a bụ ala unu, na oke ala ya nʼakụkụ ọbụla.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mosis nyere ndị Izrel iwu sị, “Kesaanụ ala a dịka ihe nketa site nʼife nza. Onyenwe anyị enyela iwu ka enye ya ebo itoolu na ọkara ndị ahụ fọdụrụ. ");
INSERT INTO ibo_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Nʼihi na ebo Ruben na Gad tinyere ọkara ebo Manase, enwetalarị ala ihe nketa ha. ");
INSERT INTO ibo_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ebo abụọ nʼọkara ndị a enwetala ihe nketa nke ha nʼakụkụ ọwụwa anyanwụ osimiri Jọdan, na ncherita ihu obodo Jeriko.” ");
INSERT INTO ibo_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ndị a bụ aha ndị ikom m họpụtara ịhụ na e kenyere unu ala ahụ dịka ihe nketa unu. Elieza onye nchụaja, na Joshua nwa Nun. ");
INSERT INTO ibo_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Site nʼebo ọbụla họpụta otu onyendu ka ha nye aka ikesa ala nketa ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Ndị a bụ aha ndị a họpụtara: “Kaleb nwa Jefune, site nʼebo Juda. ");
INSERT INTO ibo_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shemuel nwa Amihud, site nʼebo Simiọn ");
INSERT INTO ibo_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad nwa Kislon, site nʼebo Benjamin. ");
INSERT INTO ibo_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki nwa Jogli, onyendu si nʼebo Dan. ");
INSERT INTO ibo_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Haniel nwa Efod, onyendu si nʼebo Manase, nwa Josef. ");
INSERT INTO ibo_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemuel nwa Shiftan, onyendu si nʼebo Ifrem, nwa Josef. ");
INSERT INTO ibo_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizafan nwa Panak, onyendu si nʼebo Zebụlọn. ");
INSERT INTO ibo_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltiel nwa Azan, onyendu si nʼebo Isaka. ");
INSERT INTO ibo_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Abihud nwa Shelomi, onyendu si nʼebo Asha. ");
INSERT INTO ibo_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedahel nwa Amihud, onyendu si nʼebo Naftalị.” ");
INSERT INTO ibo_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ndị a bụ ndị ikom Onyenwe anyị nyere iwu si ha kenye ndị Izrel ihe nketa ha nʼala Kenan. ");
INSERT INTO ibo_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Nʼoge a, mgbe ndị Izrel ka nọ nʼakụkụ osimiri Jọdan nʼobosara ala Moab, na ncherita ihu Jeriko, ka Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Nye ndị Izrel iwu ka ha nye ndị Livayị ụfọdụ obodo ebe ha ga-ebi. Obodo ndị a ga-abụ ndị si nʼihe nketa ndị Izrel ketara. Nyekwa ha ala ebe anụ ụlọ ha ga-anọ na-akpa nri, nke ga-agba obodo ndị a gburugburu. ");
INSERT INTO ibo_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Obodo ndị a ga-abụrụ ha ebe obibi, ma ala niile gbara ha gburugburu ga-abụ ebe ịta nri nke igwe ehi na atụrụ, na anụ ụlọ ha niile. ");
INSERT INTO ibo_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Ala ebe ịta nri nke obodo niile nke unu ga-enye ndị Livayị ga-adị narị mita anọ na ọkara nʼogologo site na mgbidi obodo ga gburugburu mgbidi obodo ọbụla. ");
INSERT INTO ibo_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ya mere nʼobodo ndị Livayị ọbụla, ala ịzụ anụ ụlọ ga-adị narị mita anọ na ọkara site na mgbidi ha ruo nʼoke ala ha. Ọ ga-adị narị mita anọ na ọkara nʼakụkụ ọwụwa anyanwụ, narị mita anọ na ọkara nʼakụkụ ọdịda anyanwụ, narị mita anọ na ọkara nʼakụkụ ugwu, narị mita anọ na ọkara nʼakụkụ ndịda. Obodo ha ga-adịkwa nʼetiti ala ịzụ anụ ụlọ ndị a. ");
INSERT INTO ibo_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Obodo isii nʼime obodo ndị ahụ unu na-enye ndị Livayị ga-abụ obodo mgbaba, ebe onye ọbụla gburu mmadụ na-amaghị ama nwere ike gbaga izere ndụ ya. Tinyere obodo ndị a unu ga-enyekwasị ha iri obodo anọ na abụọ ọzọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ya mere obodo niile a ga-enye ndị Livayị ga-adị iri obodo anọ na asatọ, tinyere obosara ala ịzụ igwe ewu na atụrụ nke gbara obodo ndị a gburugburu. ");
INSERT INTO ibo_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Obodo unu na-enye ndị Livayị site nʼihe nketa ndị Izrel ga-abụ dịka unu si keta oke unu. A ga-esite nʼaka ebo nwere ọtụtụ obodo wepụta ọtụtụ obodo, ma site nʼaka ebo obodo ha nwere na-ehighị nne wepụta ole na ole.” ");
INSERT INTO ibo_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Mgbe ahụ, Onyenwe anyị gwara Mosis okwu sị ya, ");
INSERT INTO ibo_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Gwa ndị Izrel sị ha, ‘mgbe unu gafere Jọdan banye nʼala Kenan, ");
INSERT INTO ibo_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","họpụtanụ ụfọdụ obodo ka ọ bụrụ obodo mgbaba ebe mmadụ nwere ike ịgbabanye ma ọ bụrụ na o gbuo mmadụ na-amaghị ama. ");
INSERT INTO ibo_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Obodo ndị a ga-abụ ebe mgbaba nye onye na-ezere ndụ site nʼaka onye ahụ chọrọ ịbọrọ ọbọ, ka a ghara igbu onye e boro ebubo igbu mmadụ tutu ruo mgbe e buru ụzọ kpee ya ikpe nʼihu ọgbakọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Obodo isii ndị a unu wepụtara ga-abụ obodo mgbaba. ");
INSERT INTO ibo_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Họpụta obodo mgbaba atọ nʼakụkụ ọzọ nke Jọdan. Ka atọ ndị ọzọ dịrị na Kenan. ");
INSERT INTO ibo_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Obodo ndị a agaghị abụ ebe izere ndụ maka naanị ndị Izrel, kama ọ dịkwara ndị ọbịa na ndị ọzọ bi nʼetiti unu, ka onye na-akpachaghị anya gbuo mmadụ gbaga ebe ahụ izere ndụ ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Ọ bụrụ na mmadụ e jiri mkpirisi igwe tigbuo mmadụ ibe ya, a ga-agụ onye dị otu a dịka ogbu mmadụ. A ga-egbukwa ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","A sịkwa na mmadụ ejide nʼaka ya nkume nke o nwere ike iji tugbuo mmadụ, ọ bụrụ na ọ tụọ mmadụ nkume ahụ tugbuo ya, ọ bụ ogbu mmadụ. Ogbu mmadụ ahụ aghakwaghị ịnwụ. ");
INSERT INTO ibo_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","A sikwa na mmadụ ji ihe e ji osisi tụọ nʼaka ya, nke o nwere ike i ji tigbuo mmadụ, ọ bụrụ na o tie mmadụ ihe osisi ahụ, tigbuo ya, ọ bụ ogbu mmadụ. A ghaghị ime ka ogbu mmadụ ahụ nwụọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Onye na-abọ ọbọ ọbara ga-egbu ogbu mmadụ ahụ nʼonwe ya mgbe ọbụla o zutere ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ọ bụrụ na mmadụ esite nʼekworo nuo onye ọzọ aka, maọbụ kpachara anya tụọ onye ahụ ihe nke mere ka ọ nwụọ, ");
INSERT INTO ibo_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","maọbụ na o sitere nʼobi ọnụma jiri aka ya tie mmadụ ihe nke mere ka ọ nwụọ, a ga-egbu onye ahụ, nʼihi na ogbu mmadụ ka ọ bụ. Onye na-agwachite ọchụ ga-egbu ogbu mmadụ ahụ mgbe ọbụla o zutere ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Ma ọ bụrụ na mmadụ ebughị iro nʼobi nutuo mmadụ ibe ya na mberede, maọbụ tụọ ya ihe, ");
INSERT INTO ibo_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","maọbụ tụtuo nkume nke datara dagbuo mmadụ ibe ya mgbe ọ na-ahụghị ya, bụ onye na-abụghị onye iro ya, onye ọ na-ebughị nʼobi imejọ, ");
INSERT INTO ibo_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","mgbe ahụ, ndị ọgbakọ ga-ekpe ikpe nʼetiti onye e boro ebubo na onye na-agwachite ọchụ dịka usoro iwu ndị a si dị. ");
INSERT INTO ibo_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Nzukọ aghaghị ichekwa onye e boro ebubo na o gburu mmadụ site nʼaka onye na-agwachite ọchụ, zilaga onye ahụ e boro ebubo nʼobodo mgbaba, bụ ebe ha gbalagara. Onye ahụ e boro ebubo ga-anọgide nʼobodo mgbaba ahụ tutu ruo mgbe onyeisi nchụaja nwụrụ, bụ onye ahụ e tere mmanụ nsọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Ma ọ bụrụ na ogbu mmadụ a ahapụ obodo mgbaba ahụ pụọ, ọ bụrụkwa, ");
INSERT INTO ibo_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","na onye ahụ na-abọ ọbọ ọbara achọta ya nʼazụ obodo mgbaba ahụ, o nwere ike igbu onye ahụ e boro ebubo, ikpe igbu mmadụ agaghị ama ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Onye ahụ e boro ebubo na o gburu mmadụ aghaghị ịnọ nʼime obodo mgbaba ahụ tutu ruo mgbe onyeisi nchụaja nwụrụ. Ọ bụ naanị mgbe onyeisi nchụaja nwụchara, ka ha nwere ike ịlaghachi nʼụlọ ya, nʼihe nketa ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Ndị a bụ usoro iwu ga-adịgide nye unu site nʼọgbọ ruo nʼọgbọ, nʼebe obibi unu niile. ");
INSERT INTO ibo_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Onye ọbụla gburu mmadụ ga-anwụ. A ga-ama ya ikpe ọnwụ naanị mgbe e nwere karịa otu onye akaebe. Ọ dịghị onye ọbụla a ga-egbu nʼihi akaebe nke otu onye gbara megide ya. ");
INSERT INTO ibo_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Unu a narakwala ihe ịgbara isi nʼọnọdụ ndụ nke onye gburu mmadụ, bụ onye nke ikpe ọnwụ mara. Aghaghị ime ka ha nwụọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Unu a narakwala ihe mgbapụta site nʼaka onye ọbụla nke gbagara nʼobodo mgbaba, site otu a kwere ka ha lọghachite azụ ga biri nʼala nke aka ha tupu onyeisi nchụaja anwụọ. ");
INSERT INTO ibo_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Unu emerụkwala ala ahụ nke unu bi nʼime ya. Ọbara igbu ọchụ na-emerụ ala. Ọ dịkwaghị mkpuchi mmehie a ga-eme banyere ala a wufuru ọbara nʼime ya, ma ọ bụghị naanị ọbara nke onye ahụ gburu ọchụ ahụ. ");
INSERT INTO ibo_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Unu emerụla ala ahụ unu na-aga ibi nʼime ya. Nʼihi na mụ onwe m bikwa nʼebe ahụ, mụ bụ Onyenwe anyị bi nʼetiti ụmụ Izrel.’ ” ");
INSERT INTO ibo_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Nʼoge ahụ, ndịisi ezi agbụrụ Gilead, nwa Makia, nwa Manase, otu nʼime ụmụ Josef, bịakwutere Mosis na ndị ndu, na ndịisi ezi ụmụ Izrel sị ha: ");
INSERT INTO ibo_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“Mgbe Onyenwe anyị nyere unu onyenwe m iwu inye ụmụ Izrel ala ahụ nʼihe nketa site nʼife nza, onye nyekwara gị iwu iwere ihe nketa nwanne anyị nwoke Zelofehad nyefee nʼaka ụmụ ya ndị inyom. ");
INSERT INTO ibo_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ugbu a, ọ bụrụ na ha alụọ ndị ikom Izrel si nʼebo ọzọ, mgbe ahụ, ihe nketa ha ga-abụ nke anapụrụ anyị, tụkwasị nʼihe nketa nke ebo ebe ha lụrụ di. Nʼụzọ dị otu a, ihe nketa anyị ga-abụ nke e wepụrụ ihe site na ya. ");
INSERT INTO ibo_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Mgbe afọ inwere onwe nye Izrel ruru, a ga-agụnye ihe nketa ha nʼebo ebe ha lụrụ dị. A ga-esi otu a wepụ ala ha site nʼihe nketa nke nna nna anyị ha ketara.” ");
INSERT INTO ibo_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mgbe ahụ, Mosis nyere ndị Izrel ntụziaka site nʼiwu Onyenwe anyị sị, “Ihe ndị ikom ebo Josef na-ekwu ziri ezi. ");
INSERT INTO ibo_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ma nke a bụ iwu Onyenwe anyị na-enye maka ụmụ ndị inyom Zelofehad. Ha nwere ike ịlụ onye ọbụla masịrị ha, ma onye ha ga-alụ ga-abụrịrị onye si nʼagbụrụ ebo nna ha. ");
INSERT INTO ibo_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","O nweghị ihe nketa ọbụla nʼIzrel ga-esi nʼaka otu ebo gafee nʼebo ọzọ. Nʼihi na ihe nketa nke ebo ọbụla ga-adịgidere ha dịka otu e siri kee