﻿USE sofia;
DROP TABLE IF EXISTS sofia.ibl_vpl;
CREATE TABLE ibl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ibl_vpl WRITE;
INSERT INTO ibl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Si Jesucristo, poli nen David tan si Abraham. Nem ẃara pay iray eshom, jet sajay iray ngarangaran sha: ");
INSERT INTO ibl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham, ama nen Isaac; jet si Isaac, ama nen Jacob; jet si Jacob, ama nen Joda, asan ẃara pay iray potot to ja agi nen Joda. ");
INSERT INTO ibl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jet si Joda nen Tamar, anak sha si Piris nen Sara. Jet si Piris, ama nen Isrom; si Isrom, ama nej Aram. ");
INSERT INTO ibl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram, potot tos Aminadab; si Aminadab, ama nen Naason; si Naason, ama nen Salmon. ");
INSERT INTO ibl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jet si Salmon nen Rahab, anak sha si Boos; jet si Boos, inesawa to si Ruth et anak sha si Obid; jet si Obid, ama nen Jesse. ");
INSERT INTO ibl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jesse, ama nen David ja nan‐ari, jet si David, inpotot tos Solomon. (Say ina nen Solomon sota istay aseẃa nen Orias.) ");
INSERT INTO ibl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon, ama nen Roboan; si Roboan, ama nen Abias; jet si Abias, potot to si Asa. ");
INSERT INTO ibl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa, ama nen Josapat; si Josapat, ama nen Joram; jet si Joram ama nen Osias. ");
INSERT INTO ibl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Potot ngo nen Osias ma si Joatam; si Joatam, ama nen Akas; jet si Akas, ama nen Isikias. ");
INSERT INTO ibl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jet si Isikias ama nen Manasis; si Manasis ama nen Amon, jet si Amon ama nen Josias. ");
INSERT INTO ibl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jet si Josias potot to si Jikonias, tan ẃara pay iray a‐aki nen Jikonias. Sajay iren a‐aki nen Jikonias, pati si‐kato, nay‐anak ira nonta timpon in‐ilaw sha sota toon i‐Israel ja maybedod shima dogad ja kowan sha ey Babilonia. ");
INSERT INTO ibl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Idi nonta ẃara ma ira shi Babilonia, ẃaray inpotot nen Jikonias ja inpanngaran to ni Salatiil, jet si Salatiil, inpotot to ngo si Sorobabil. ");
INSERT INTO ibl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Naytoltoloy ja naypolipoli ira jay jet si Sorobabil, ama nen Abiod. Si Abiod i ama nen Iliakim; si Iliakim, ama nen Asor; ");
INSERT INTO ibl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","si Asor, ama nen Sadok; si Sadok, ama nen Akim; si Akim, ama nen Iliod; ");
INSERT INTO ibl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","si Iliod, ama nen Eleazar et si Eleazar ama nen Matan. Si Matan ma i ama nen Jacob. ");
INSERT INTO ibl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jet si Jacob, potot to si Jose et si‐kato may maka‐aseẃa so nen Maria ja engi‐nak so nen Jesus, ja ineẃagan sha met laeng ja si Cristo. ");
INSERT INTO ibl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jet sajay iren nanpolipoli, manshoki so nen Abraham ingkato so nen David, sampolo tan epat ta apo. Jet manshoki mowan so nen David ingkato nonta timponindaw sha so nonta tood Israel shima dogad ja kowan sha ey Babilonia, sampolo tan epat mowan na apo. Manshoki mowan nonta ẃara ired Babilonia ingkato ngo nonta inkay‐anak nen Cristo, sampolo tan epat ta apo mowan. ");
INSERT INTO ibl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iyay i shoki‐an ni inkay‐anak nen Cristo. Nonta aneng pay laeng nga may‐enak si Cristo, si Maria ja mengi‐nak ali son si‐kato, naykari ja esaw‐en nen Jose. Jet si Maria, nonta eg ira pay laeng nan‐aseẃa nen Jose, na‐amta‐an ey malokon. Nem sotan na dokon to, in‐iyan gayam ni Ispirito Santo nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nem si Jose ja naykarin mengesawa so nen Maria ali, kowan to ey eg to itoloy ya esaw‐en si Maria. Nem piyan ton dibas i pesing ton mengisi‐jan, ta eg to koston mebebaingan si Maria. Si Jose, na‐anos sa daki, isonga sajay i kowan to ey pesing to. ");
INSERT INTO ibl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nem idi sajay i toka nemnemnema ja kowan to ey dag‐en to, nanpa‐sas i anghil nen Apo Shiyos shi kokokip to, ja kowan nonta anghil son si‐kato ey, “Jose ja poli nen Ari David, kareka manshanag ja mengesawa so nen Maria, ta sama dokon to, Ispirito Santo nen Apo Shiyos i engi‐jan so. ");
INSERT INTO ibl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Say i‐anak to ali, daki et say ingaran mo son si‐kato, Jesus (ja say olog to, mengisedakan), ta si‐kato diy mengisedakan ira nonta too to say eg ira meshosa pangkep ni basol sha.” ");
INSERT INTO ibl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sajay ya emin i epasemak say mayto‐to‐ẃa sota kowan ni para padto nonta bayag da ja esel nen Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ja kowan to ey, “Wara aliy balasang ja enshiy dakin en imaro‐arol so, nem on‐anak ali. Say i‐anak to ali, daki jet say ingaran sha so nontan na i‐anak to ali, si Emanuel.” (Say olog niyay ya ngaran shi esel ira ni Hodiyos, “Si Apo Shiyos, ẃara son si‐katejo.”) ");
INSERT INTO ibl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jet idi bimangon si Jose, pinati to sota inkowan ni anghil nen Apo Shiyos shi kokokip to et inesawa to si Maria. ");
INSERT INTO ibl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nem eg to ineshol si Maria nonta maramen malokon. Jet idi nay‐anak sota dokon nen Maria, inpanngaran nen Jose ni Jesus sota nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jet nontan na inkay‐anak nen Jesus shi Bitlihim, ja sakop ni Jodia, maramen si Hirodis i ari. Idi nontan, ẃaray mimotok shi Jerusalem ja toon nankedaing ni bisto ni talaw ja edapod bedalan. ");
INSERT INTO ibl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jet sha inbaga ey, “Towa sota nga‐ngen nay‐anak ja ari ali ni Hodiyos? Inon‐an miy inbo‐day nonta talaw shi bedalan et si‐katoy engamta‐an mi so ey nay‐anak. Dimaw kami di say kami manshedjaw so nontan na nay‐anak ka ari.” ");
INSERT INTO ibl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Idi inamta‐an nen Ari Hirodis iyay ya kowan sha, ngaaw i dekna to, jet angken pay sota ira emin na tood Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jet si Ari Hirodis, sina‐nop ton emin sota ira apo ni papashi tan sota emantosho ni dinteg ni Hodiyos et insho‐petan to ira ja kowan to ey, “Towa kariy koston kay‐enakan nonta naypadto nonta bayag da ey mengitoshay son si‐katejo, ja ibetkag kono ali nen Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jet inkowan sha son si‐kato ey, “Shi Bitlihim ja sakop ni Jodia i koston kay‐enakan to, ta si‐kato met i naysolat ja kowan nonta para padto nonta bayag da, ja esel met laeng nen Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ja kowan to ey, ‘Say Bitlihim, shima dogad ja sinekopan ni poli nen Joda, ootik nga agpayson siyodad no may‐inges shima emin na kait ton siyodad nodtan met laeng nga dogad. Nem maybidang ey epateg ta si‐kato aliy kedepo‐an nonta mengitoshay ni took ja i‐Israel.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jet nontan ma si Ari Hirodis, inpa‐odop to ira ngo sota nankedaing nga too ja edapod bedalan. Jet insho‐petan to iren pasiya nonta a‐abos sha no pigan i inbo‐day nonta talaw wa inon‐an sha. ");
INSERT INTO ibl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jet inbetkag to ira shi Bitlihim ja kowan to ey, “Eti, daw kayo ngarod, singpet joy anap nonta nga‐nga, jet no sepolen jo, ipa‐amtayo ali son si‐kak. Say ondawak ngo ja en manshedjaw son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Idi itenengan ira niya toon nankedaing iya kowan nen Ari Hirodis, dima‐jat iren ondaw shi Bitlihim. Jet sota talaw wa inon‐an sha alid bedalan ja edapo‐an sha, epangdo ey si‐kara shima dogad ja daẃan sha, jet nan‐akad ira ingkatod simalsheng sota talaw. Jet pintek ton kosto sota kawad‐an nonta nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Idi inon‐an shen simalsheng sota talaw, ebadeg i imdeng sha. ");
INSERT INTO ibl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Simekep ira nodta baley et inon‐an sha sota san‐ina. Jet sota ira toon nankedaing ja edapod bedalan, nantalimokod ira ja nanshayaw son si‐kato. Jet inbo‐day sha sota inta‐jon sha ja nankebanol ja i‐akan sha so nonta nga‐nga, ja balitok, tan sota emanseng‐ew wa kowan sha ey insinso, tan mira. ");
INSERT INTO ibl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Idi imakad ma ira, apil i shindan sha tep ẃaray inpa‐amta nen Apo Shiyos son si‐kara shi kokokip sha ey eg ira kari manshedan shi baley nen Ari Hirodis. ");
INSERT INTO ibl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Idi naksheng den dimaw ira jay ya too, sota anghil nen Apo Shiyos, nanparang so nen Jose shi kokokip to ja kowan to ey, “Bangon ka et ibtik mo ita nga‐nga tan si ineto shi Egypt. Jet pan‐iyan kayo nin shiman ingkatod ekak ikowan ey on‐etan kayo mowan. Ta si Hirodis piyan ton pa‐enap ali iya nga‐nga ja kowan to ey bono‐en to.” ");
INSERT INTO ibl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jet si Jose, idi bimangon, inda to sota nga‐nga tan si Maria nontan na dabi met laeng et inbakwit to ired Egypt. ");
INSERT INTO ibl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jet nan‐iyan ired man ingkatod etey si Hirodis. Wara si Jesus shi Egypt nin say metongpal sota kowan ni padto nonta bayag da, ja esel nen Apo Shiyos met laeng, ja kowan to ey, “Shi Egypt aliy edapo‐an ni anak ko, ja inedjaban ko so di.” ");
INSERT INTO ibl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Idi inamta‐an nen Hirodis ey nandibas ira sota nankedaing nga too, kowan tod nemnem to ey, “Endedamsis sha gayam sota inbilin ko nontan!” Jet ebadeg ga pasiya ma i bonget to. Inbetkag to ira sota solsharo to ja memono ni emin na nga‐ngen daleki shi Bitlihim ja mantaw‐en ni showa ono ekolang, ingkato nodta dogad ja nandi‐mot shi Bitlihim. Ta say kowan nonta nankedaing nga too, inon‐an sha sota talaw nonta showen tawen den edabas. ");
INSERT INTO ibl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sajay i kaytoshongan nonta padto nen Jeremias nonta bayag da ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Waray naytenengan ja makedsang i ngogngog to shi Rama. Si‐kato si Rakil, ja toka ira nengnengisi sota annak to. Eg to koston ma‐adok tep na‐enshi ira da sota annak to.” ");
INSERT INTO ibl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jet idi etey si Ari Hirodis, nanparang mowan sota anghil nen Apo Shiyos so nen Jose shi kokokip to nonta ẃara ired Egypt, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bangon ka et alam ita nga‐nga, tan si ineto, jet akad kayo ma shi Israel. Pesed ma niman tep sota kowan to ey memono so nita nga‐nga, etey da.” ");
INSERT INTO ibl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jet si Jose bimangon et inda to sota nga‐nga, tan si Maria et nay‐oli ira ma shi Israel. ");
INSERT INTO ibl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nem idi inamta‐an to ey si Arkilao ja anak nen Hirodis i naysa‐dat so nen ameto ja man‐eshi shi Jodia, timakot si Jose ja ondaw shiman. Binanshaanan mowan ni anghil shi kokokip to ey angken eg metodoy shiman no diket ondaw et shi ili ni Galilia. ");
INSERT INTO ibl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jet siya, dimaw ired man et nan‐iyan ired ma siyodad ja kowan sha ey Nasarit. Sajay i edaga say metongpal sota naypadto nonta bayag da ja kowan to ey, “Si‐kato, mayngadnan ey i‐Nasarit.” ");
INSERT INTO ibl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nontan na timpon ẃares Jesus shi Nasarit, ẃaray toon emantosho shima sakop ni Jodia ja nay‐araẃi shi kad‐an ni totoo. Jet say awag sha so nontan na too, si Juan ja para bonjag. ");
INSERT INTO ibl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Say kowan to so nonta ira totoo ja dimaw nodtan, kowan to ey, “Baliẃiyo i ngaaw wa ẃared nemnem jo, ta sota pantoshayan nen Apo Shiyos ja naypadto nonta bayag da, shanshani ma.” ");
INSERT INTO ibl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Saja si Juan, si‐katoy kaytoshongan nonta padto nen Isaias nonta bayag da ja kowan to ey ẃara aliy toon ikeljaw toy esel to shima dogad ja nay‐araẃi shi kad‐an ni totoo, ja ikowan to ey, “Pansagana kayo ta shanshani ma aliy imotok nen Apo! Singpet joy shalan na pan‐akshan to!” ");
INSERT INTO ibl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Say baro nen Juan, nagshengan: sota na‐abel la bowek ni animal ja kowan sha ey camel i toka osala bengat, ja ebalkesan ni kolti. Jet nagshengan ngoy toka kena, ja shoron tan shanom ni dinowan. ");
INSERT INTO ibl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sota ira tood Jerusalem, tan eshom ma toon nanbaley shi probinsiya ni Jodia, tan sota ira toon nanbaley ja nay‐esop shima ebadeg ga pa‐dok ja kowan sha ey Jordan, ireka mansisina‐dat ja ondaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inkowan shen emin i basol sha say pekawanan ira nen Apo Shiyos; isonga binonjagan ma ira nen Juan. ");
INSERT INTO ibl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nem idi inon‐an nen Juan ira sota Parisiyo, tan sota ira Sadosiyo, ja emandaw son si‐kato, ja kowan sha ey ira manpabonjag ngo son si‐kato, kowan nen Juan son si‐kara ey, “Si‐kayo, singa oleg i ogadiyo! Say kowan jo emo, mebedin na disi‐an joy penosa nen Apo Shiyos no manpabonjag kayo bengat? ");
INSERT INTO ibl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nem enshi! Mesepol la ma‐sas shi ogadiyo ey inbebawi jo sota basol jo. ");
INSERT INTO ibl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Karejo panshindan sota kowan jo ey si‐kayo ket poli shakejo nen Abraham. Enshi, eg on‐anay iyay! Tep si Apo Shiyos, mebedin ton osalen i bato ja palsowa‐en ni too jet ikowan to ey poli nen Abraham. ");
INSERT INTO ibl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jet niman, ẃaray naysagana ja may‐eshig ey ẃasay ja mayẃa‐tek nodta damot ni kakadasan na eg ondames ni mapteng. Sajay iren kakadasan, mebetang et maypool shi apoy.” ");
INSERT INTO ibl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jet kowan pay nen Juan ey, “Nem si‐kak, dimawak ali ja shanom i inpamonjag ko son si‐kayo, ni inpanbebawi jo, nem ẃaray ondaw alin maysa‐dat son si‐kak ja ebadbadeg i panakabalin to nem say si‐kak. Jet ekak pay maykeshi ja angken baga‐en to koma ja mengkal ni sapatos to. Sotan aliy onbonjag son si‐kayo ni Ispirito Santo nen Apo Shiyos, asan pay ya apoy.” ");
INSERT INTO ibl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jet si Juan, in‐arigan to ira, ja kowan to ey, “Sotan aliy may‐eshig ey mengita‐nil ni bekas shi taap. Sota bekas, isingpet tod tado‐an, nem sota taap, ipool tod apoy ya emanshedang ni olay ja eg ma‐ma‐shep.” ");
INSERT INTO ibl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nontan, edapo ngod Galilia si Jesus ja ondaw shima kawad‐an nen Juan, say en manpabonjag ngo son si‐kato shima pa‐dok ja kowan sha ey Jordan. ");
INSERT INTO ibl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nem si Juan, istay en‐asneng, ja kowan to so nen Jesus ey, “Si‐kak komay ondaw son si‐kam ja manpabonjag; aliẃen si‐kam et ngo mowan i ondaw alin manpabonjag son si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nem si Jesus, simongbat ja kowan to ey, “Eti, dagam et niman. Bonjagimak ma. Mapteng i itongpal ta so ni bilin nen Apo Shiyos maypangkep niyay.” Jet si Juan, timolok. ");
INSERT INTO ibl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Idi ebonjagan ma si Jesus, kima‐jat ta shagos nodta shanom et nay‐inshas ngon edo‐katan i dangit. Jet inon‐an toy Ispirito Santo nen Apo Shiyos ali ja singa inges toy itsora ni kalopati ja emandespag alin onsepa son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jet nontan met laeng, ẃara aliy esel nen Apo Shiyos ja edapod dangit ja kowan to ey, “Si‐kam i Anak ko jet ensemek taka, tan si‐kam i naka pandadsaki.” ");
INSERT INTO ibl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Idi naksheng ja ebonjagan si Jesus, intorong ni Ispirito Santo ja ondaw shima dogad ja araẃid kawad‐an ni too, say peshasen nen Satanas shiman ja panbesol koma si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jet nontan si Jesus, eg eng‐engan ni epat ta polon akew, tan epat ta polon dabi, tep epaladoy kepemeshas nen Satanas. Jet idi naksheng iyay, na‐agang si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jet si Satanas, dimaw ja kowan to so nen Jesus ey, “No agpayson anak toka nen Apo Shiyos, ikowan mo iren ja bato ey manbedin ira ni tinapay.” ");
INSERT INTO ibl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nem si Jesus, simongbat ja kowan to ey, “Enshi, tep say naysolat nonta bayag da ja bilin nen Moises, kowan to ey, ‘Aliẃen na mekan ni abos i panbiyag ni too, no diket manbiyag ni sanseskey ja esel nen Apo Shiyos ja ikowan to.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Idi naksheng iyay, indaw nen Satanas si Jesus shi Jerusalem, ja kaibilang nen Apo Shiyos ja dogad to, jet to inpa‐tok nodta Timplo. ");
INSERT INTO ibl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jet kowan to so nen Jesus ey, “No agpayson anak toka nen Apo Shiyos, pan‐ekas ka. Say kowan met ni naysolat nonta bayag da, kowan to ey, ‘Ibilin nen Apo Shiyos so nonta anghil to ey ajowanan shaka.’ Isonga eg ka mesekitan. Tan say kowan to pay, ‘Egni‐an shaka ni takday sha, say eg mesekitan i sedim ni bato.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Simongbat si Jesus et kowan to ey, “Enshi, ta say kowan mowan ni naysolat nonta bayag da, ‘Karam pedpeshasen si Apo Shiyos, ja kowan mo ey ma‐sas ka no agpayso i kowan to.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jet si Satanas indaw to mowan si Jesus shima kakedjangan na shontog et inpa‐sas ton emin i ilid ja dobong, tan sota kamapteng sha. ");
INSERT INTO ibl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jet si Satanas, kowan to pay so nen Jesus ey, “Emin ira jay, i‐akan ko son si‐kam no si‐kak i pantedimokoshan mo ja panshedjawan.” ");
INSERT INTO ibl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Simongbat ngo si Jesus, ja kowan to ey, “Ki‐nan ked jay Satanas! Say kowan ni esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey si‐kato bengat i panshedjawan mi tan pansilbi‐an mi.” ");
INSERT INTO ibl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Idi naksheng nga pineshas nen Satanas si Jesus ja istay piyan ton panbesol, indekjas to ma. Jet sota anghil, dimaw ira di son Jesus ja sha in‐aknan ni kompormin kasapolan to. ");
INSERT INTO ibl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nontan ngo ma, naybalod si Juan ja para bonjag. Idi inamta‐an nen Jesus, imoli ma shi Galilia. ");
INSERT INTO ibl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Indekjas toy Nasarit et nan‐iyan shi siyodad ni Kapirnaom ja naykilig shi baybay, ja istay sakop ni Sabolon tan Niptali. ");
INSERT INTO ibl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sajay i edaga say metongpal sota inpadto nen Isaias nonta bayag da ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Shima Galilia ja petek ni baybay tan shemang ni pa‐dok ja kowan sha ey Jordan, ja istay sinekopan ni poli nen Sabolon tan Niptali, si‐katoy naydaokan ira nonta aliẃen Hodiyos, ");
INSERT INTO ibl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jet shiman, sota ira too ja may‐eshig ey edabi‐an ja imekok shima embolinget ta shalan, singa ẃaray on‐an sha alin maniyal la silew ja menidew son si‐kara. Jet angken sota ira toon patey i istay toshongen sha, singa eẃa‐ẃa‐an ira.” ");
INSERT INTO ibl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jet manshoki ma nontan na timpo, nantoro ma si Jesus, ja kowan to ey, “Baliẃiyo i ngaaw wa ẃared nemnem jo, ta sota naypadton pantoshayan nen Apo Shiyos, shanshani may timpo to.” ");
INSERT INTO ibl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Idi sakey ya akew, eman‐ekad si Jesus shima kilig ni baybay shi Galilia et inon‐an to sota san‐agi ja si Andres nen Simon. (Si Simon, Pedro met laeng i shaka pengeẃag son si‐kato.) Shaka pan‐iteknal sota embanaw wa balshew shi shanom, tep nigay i shaka panbiyagi. ");
INSERT INTO ibl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jet si Jesus, kowan to son si‐kara ey, “Kay‐olop kayo son si‐kak et panbedin takejo ni took, jet mengolnong kayo ngo ni too ja itod‐an jo para son si‐kak. Aliẃa malen sota pengolnong ni nigay i obdayo.” ");
INSERT INTO ibl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jet idi inkowan nen Jesus iyay, indekjas nonta san‐agin shagos sota embanaw wa balshew sha et si Jesus i nay‐olopan sha. ");
INSERT INTO ibl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Intoloy shen nan‐akad et ẃara pay i inon‐an shen san‐agi ja anak nen Sibidi, ja si Santiago nen Juan. Wara ira nodta bangkara ja shaka pansingpeta sota balshew sha, jet ẃara ngo si Sibidi ja amesha nodtan. Jet si Jesus, tineẃal to ira sota showen san‐agi ja manbedin ni too to. ");
INSERT INTO ibl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jet nontan met laeng, indekjas sha shagos si amesha tan sota bangkara, jet eki‐odop ira son Jesus, jet nanbalin ma iren too to. ");
INSERT INTO ibl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Si Jesus, pinasiyal ton emin i sakop ni Galilia, jet nantoro pay shima sa‐nopan ira nonta Hodiyos nodta dinadaẃan to. Inpaleẃag tod man sota mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos. Jet angken sota ira toon ekalkalasiy sakit sha, inpamapteng to ira. ");
INSERT INTO ibl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Isonga nontan, eshamag iyay shi intiron sakop ni Siria, jet indaw sha ali son si‐kato sota ekalkalasiy sakit sha, pati sota ira emankelshas tan sota eg makakeykey i bakdang sha. Tan angken pay sota ira eman‐engaw ja kawad‐an ni dimonyo. Jet si Jesus, inpamapteng to ira jay ya emin. ");
INSERT INTO ibl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jet eshakel iray toon pasiya ja emay‐odo‐odop son Jesus: iman i edapod Galilia, Dikapolis, Jerusalem, Jodia, tan shima dogad ja baliw ni pa‐dok ka Jordan. ");
INSERT INTO ibl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jet nontan, idi inon‐an nen Jesus ira sota eshakel la too, eniyed nodta shontog. Idi timongaw ja esagana men mantosho, nay‐eshom ali ira sota too to. ");
INSERT INTO ibl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jet inshogi ton nantoro son si‐kara ja kowan to ey: ");
INSERT INTO ibl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Si‐kayon maka‐amta ey ebadeg i kasapolan jo son Apo Shiyos, bindisiyonan shakejo nen Apo Shiyos, tep mayda‐kam kayod pantoshayan to. ");
INSERT INTO ibl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Si‐kayon emandeshingit, bindisiyonan shakejo nen Apo Shiyos, tep si‐katoy mengkal ali ni daringit jo. ");
INSERT INTO ibl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Si‐kayon ekombaba, bindisiyonan shakejo nen Apo Shiyos, tep si‐kayoy onkon‐od niya dobong. ");
INSERT INTO ibl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Si‐kayon makapipiyan ja mandeka nonta ka‐aporbali nen Apo Shiyos, bindisiyonan shakejo nen Apo Shiyos, ja mepnek kayo di. ");
INSERT INTO ibl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Si‐kayon manangaasi, bindisiyonan shakejo nen Apo Shiyos, tep si‐katoy mismon mengaasi son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Si‐kayon poro mapteng i ẃared nemnem to, bindisiyonan shakejo nen Apo Shiyos, ta mismon asen jo ali si Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Si‐kayon emengi‐kan ni talna, bindisiyonan shakejo nen Apo Shiyos, ta si‐kayo sota maybidang ali ey annak nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Si‐kayon pinedigat ni kait jon too kabol ni dingka‐an jo so nonta ka‐aporbali nen Apo Shiyos, bindisiyonan shakejo nen Apo Shiyos, ta mayda‐kam kayo shi pantoshayan to. ");
INSERT INTO ibl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Si Apo Shiyos, bindisiyonan shakejo no somangen shakejo ni kait jon too, ja kompormiy ikokowan sha, angken enshiy basol jo, ono bebaingan shakejo, ono pedigaten shakejo tep too takejo. ");
INSERT INTO ibl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pan‐imdeng kayo no sajay i mepesamak son si‐kayo, ta ebadeg i naytalo shi dangit ja kon‐oren jo ali. May‐inges kayo nodta ira para padto nen Apo Shiyos nonta bayag da, ja pinedigat ngo ni too nontan da, jet may‐inges kayo nodta kon‐oren sha. ");
INSERT INTO ibl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“May‐eshig kayo ey asin ja emengi‐kan ni mapteng shiya dobong. Nem no ma‐omas i pait ni asin, ja entamnay ma, eg maymowan. Jet enshi may silbi to, may‐ibong sotan ja angken kegkegtinan ni too. ");
INSERT INTO ibl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“May‐eshig ey singa si‐kayo sota silew ja ondawag niya dobong. Jet sota ili ja naypa‐tok shima shontog, eg mebedin na mesa‐dinan, ema‐sas ni olay i itsora to. ");
INSERT INTO ibl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","No bilang ey ẃaray kingki ja inparedang ni too shi naydaem ni baley, simpri eg mesa‐keban, no diket maypa‐tok shi ekayang, say sota emin na ẃared baley, asen shay dag‐en sha. ");
INSERT INTO ibl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Inges niyay koma ngoy pesing jon menidew ni nemnem ni too shiya dobong. Isonga eg jo sa‐dinan i silew jo, no diket ipa‐sas joy mapteng nga ogadiyo, say asen ni totoo. Jet say ishayaw sha si Apo Shiyos ja Amejo ja ẃared dangit. ");
INSERT INTO ibl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aliẃen jo ipangkep koma ey dimawak ali ja en mena‐dat nonta dinteg ja para son si‐katejo, ja in‐awat nen Moises nonta bayag da, ono en mena‐dat nonta inkowan ira nonta para padto met laeng nontan da, no diket dimawak ali say amta‐an joy koston olog nonta inkowan sha nontan da. ");
INSERT INTO ibl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ikowan ko et i podno son si‐kayo. No ẃara pay laeng iya dangit tan dobong, eg mepokaw i angken sakey ya ko‐nit shima dinteg ja in‐awat nen Moises ingkatod metongpal la emin. ");
INSERT INTO ibl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Waray eshom ma in‐awat ton bilin ja kowan jo ey aliẃen pilit ta pati‐en, nem say podno, sota eg memati ni angken sakey so ira niyay ya bilin, tan mengitosho ni kait to say eg sha ngo pati‐en, si‐kato aliy ka‐otikan i shayaw to shi pantoshayan nen Apo Shiyos. Nem sota mengonod so ira nonta bilin ja in‐awat nen Moises, tan mengitosho so ni eshom, si‐katoy mandesin aliy shayaw to shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mesepol la may‐enam i ogadiyo shi bilin nen Apo Shiyos, ja aliẃen inges to ira sota Parisiyo tan mamaistoro ni dinteg. No eg mandesin i pengonod jo nontan na bilin nem say si‐kara, eg mebedin na mayda‐kam kayo shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Amtayo met sota kowan ni bilin nonta bayag da so nonta ira apo tayo da ey eg ira memono, ta sota onbono, meshosa met laeng. ");
INSERT INTO ibl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nem say kowan ko son si‐kayo, angken sota toon mengibonget bengat ni kait to, ẃaray ikaro to son Apo Shiyos. Jet sota toon memebaing ni kait to, mas embelbel‐at pay i ikaro to. Jet sota toon kowan to so ni kait to ey maypowisha koma son Apo Shiyos, dilikaroy kasesaad to, ta shi impiyarno i toshongen to. ");
INSERT INTO ibl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Isonga no bilang ey marama ja kaka mengileton shima Timplo para so nen Apo Shiyos, jet ẃaray nemnemen mon eg kosto ni kait mo son si‐kam, ");
INSERT INTO ibl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taynim nin sota moka pan‐idaton jet daw ka so nontan na too, mo tabtabal say man‐inawatan kayo. Asan kaka may‐oli et mo itodoy sota daton mo so nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“No bilang ey ẃaray mengireshom son si‐kam shi oskaro, pakikajem ka et ja shagos son si‐kato no maramen tokaka pan‐i‐ilaw shi oskaro, say eg toka i‐awat nodta kowis. Say sota kowis ngo, eg toka i‐awat ngo nodta kowadja ja mengibedod son si‐kam. ");
INSERT INTO ibl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Podno iyay ya ikowan ko son si‐kam. No ẃara ka ma shima badoran, eg ka onbo‐day ingkatod bayshan moy oltimon sintimos ja inotang mo. ");
INSERT INTO ibl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Amtayo met sota kowan ni bilin nonta bayag da ey, ‘Kareka memii.’ ");
INSERT INTO ibl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nem say kowan ko pay son si‐kayo, sota toon ngaaw i pangkep to so ni biin asen to bengat, nanbasol ja singa emii, ta say ẃared nemnem to, ngaaw. ");
INSERT INTO ibl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","No bilang ey sota kanawan na matam i mengi‐kan ni panbesolan mo, okit mo, et ibong mo. Mapmapteng ja ẃaray ma‐kal la parti ni bakdang mo ja emengi‐kan ni panbesolan mo, ey say sota ẃaren emin nem ondaw ka shima impiyarno ja meshosa. ");
INSERT INTO ibl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No sota kanawan na takday mo i mengi‐kan ni panbesolan mo, potol mo et ibong mo. Mapmapteng ja ẃaray ma‐kal la parti ni bakdang mo ja mengi‐kan ni panbesolan mo, ey say sota ẃaren emin nem ondaw ka shima impiyarno ja meshosa met laeng. ");
INSERT INTO ibl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Wara pay i naysolat ja dinteg ja kowan to ey, ‘Sota dakin mengisi‐jan ni aseẃa to, mesepol la mengemag ni solat ja isepa to so nonta aseẃa to, et si‐katoy pengamta‐an ey koston insi‐jan to sota bii.’ ");
INSERT INTO ibl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nem say ikowan ko pay son si‐kayo, sota dakin mengisi‐jan ni aseẃa to, ey eg ekileki sota bii, si‐katoy engi‐kan ni nanbasolan nonta aseẃa ton bii. Jet sota mengesawa ngo nontan na biin naysi‐jan, nanbasol ngo ja singa emii. ");
INSERT INTO ibl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Amtayo met sota naysolat ja dinteg nonta bayag da so nonta ira apo tayo da ey, ‘Kareka manki‐nat ni karim; isonga, no ẃara inkarim son Apo Shiyos, ja tinaksholan mo ni sangba, kenshat ta tongpalen mo.’ ");
INSERT INTO ibl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nem say ikowan ko pay son si‐kayo, aliẃen kayo mansangba so ni kompormi. Aliẃen kayo mansangba so ni dangit, ta say dangit, si‐katoy kawad‐an nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aliẃen kayo mansangba so niya dobong, ta si‐katoy kepanbagto‐i ni sedi nen Apo Shiyos. Aliẃen kayo pay mansangba so ni siyodad ni Jerusalem, ta si‐katoy inbilang nonta Kangeto‐an na ari, ja si Apo Shiyos ey siyodad to. ");
INSERT INTO ibl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tan aliẃen kayo mansangba so ni toktok jo shorog, ta angken na sakey ya bowek shi toktok jo, eg mebedin na panbedin jo ni oban, ono pa‐onong jo ni olay ya etoling. ");
INSERT INTO ibl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","No ẃaray mansedodsod son si‐kayo, karejo i‐eshom i sangba shi ‘Owen’ ono ‘Enshi’, ta sota songbat ja onsolok shi owen ono enshi, si Satanas i edapo‐an to. ");
INSERT INTO ibl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Amtayo met sota kowan sha ey, ‘No ngarantoy dingkara son si‐kam, ibedes mo ja inges to ngoy inpasing sha son si‐kam, nem karam debasen: no matam i sinekitan sha, shi matesha ngoy ibalesan mo so, kasta met no shi sangim.’ ");
INSERT INTO ibl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nem say ikowan ko son si‐kayo, no ẃaray makedsel, aliẃen kayo mekibekal son si‐kara. No bilang ey ẃaray menengpel ni kanawan na tamil mo, itodok mo pay ya angken pinshowa‐en tod piig. ");
INSERT INTO ibl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No bilang ey ẃaray mengodop son si‐kam ja ondaw shi oskaro say kowan to ey al‐en toy barom, itodok mo pay ya angken al‐en toy jakit mo. ");
INSERT INTO ibl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tan no bilang ey ẃaray memidit son si‐kam ja kowan to ey mo itolod shi showen kilomitro, angken pay ya onsolok i pengitodoran mo son si‐kato, ja epat ta kilomitro. ");
INSERT INTO ibl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No ẃaray manbeka son si‐kam, i‐kan mo son si‐kara i piyan sha. Tan no ẃaray kowan to ey memodod son si‐kam, pabodorim. ");
INSERT INTO ibl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Amtayo met sota kowan sha ey, ‘Semek moy kait mo et angken okesen mo sota makakontra son si‐kam.’ ");
INSERT INTO ibl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nem say kowan ko son si‐kayo, sota makakontra son si‐kayo, semek jo kari, tan ireẃati jo son Apo Shiyos sota ememedigat son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta no sajay i pesing jo, ingesen joy ogadi nen Apo Shiyos ja Amejo shi dangit. Ta si Apo Shiyos, nan‐i‐inges sa mapteng i toka pesing so ni angken sipen too, inges to no mapteng i aramid to ono ngaaw. Nan‐inges ja toka peskit i akew shi kad‐an sha, tan inges ton toka pa‐oshan. ");
INSERT INTO ibl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mesepol la ensemek joy makakontra son si‐kayo, ta no bilang ey say ensemek jo bengat ket sota toon ensemek shakejo ngo, enshiy jo kon‐oren son Apo Shiyos. Ta sotan met laeng i kepesing ira nonta para singil ni bowis ja kowan jo ey enshiy kenshat sha. ");
INSERT INTO ibl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jet no bilang ey say joka bengat tetbala ni kosto ket sota kagajem jo, enshi met laeng i jo kaydesinan so nonta ira karakdan na too. Ta sotan met laeng i kepesing ira nonta toon enshiy Shiyos sha. ");
INSERT INTO ibl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mesepol la enshiy pankodangan ni ogadiyo ja inges toy ogadi nen Apo Shiyos ja Amejon ẃared dangit. ");
INSERT INTO ibl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Eg mesepol la ipa‐sas joy mapteng nga aramid jod karakdan, ja kowan jo ey say i‐etek shakejo nonta mengesas son si‐kayo. No sotan i pesing jo, enshiy jo kon‐oren ja i‐akan ali nen Apo Shiyos ja Amejo shi dangit. ");
INSERT INTO ibl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Isonga si‐kayo, no bilang ey ẃaray tolong nga i‐akan jo shi eshom ma too, eg mesepol la pa‐amtayo shi karakdan, ja inges to sota kepesing ira nonta toon emengipa‐sas ni mapteng nga aramid sha say eg amta‐an ni karakdan ey ngaaw i nemnem sha, no ẃara ired sa‐nopan tayon Hodiyos ono angken shima kalsaren eshakel i too. Ta say ẃared nemnem sha, piyan shen ishayaw ira nonta toon mengesas son si‐kara. Nem podno iya ikowan ko son si‐kayo. Sota ira toon sajay i itsora ni aramid sha, enshiy isobadit nen Apo Shiyos son si‐kara, ta singa ineẃat sha lay konkona sha nonta in‐etek ira ni totoo. ");
INSERT INTO ibl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","No bilang ey mengi‐kan kayo ni tolong jo shi kakaasin too, eg mesepol la pa‐amtayo iyay ja joka dagdag‐a. No mebedin koma, angken sota kanigid ja takday jo, eg to amtay inpangi‐kan nonta kanawan na takday jo. ");
INSERT INTO ibl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mapteng no sotan na tolong jo shi eshom ma too ket eg amta‐an ni eshom, ta si Apo Shiyos ja Amejo, amta ton emin i joka dagdag‐a, jet si‐katoy mengi‐kan ni konkona jo. ");
INSERT INTO ibl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No mansheẃat kayo so nen Apo Shiyos, eg jo onoran sota kepesing ira nonta toon emengipa‐sas ni mapteng nga aramid sha say eg amta‐an ni karakdan ey ngaaw i nemnem sha. Say pipiyan sha ja pansheẃatan son Apo Shiyos, shima sa‐nopan, ono shima kalsara ja karakdan ni too say asen ira nonta eshakel la too. Nem podno iya ikowan ko son si‐kayo. Sotan iren too, enshiy isobadit nen Apo Shiyos son si‐kara, ta singa ineẃat sha lay konkona sha nonta in‐etek ni totoo ira. ");
INSERT INTO ibl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","No mansheẃat ka so nen Apo Shiyos, say pesing mo, daw ka shima kowadtom et pandekeb ka, asan ka manshawat so nen Apo Shiyos ja Amam. Jet si‐kato, ẃara nodtan na kowadtom ni moka pansheẃat ni abos mo, jet si‐katoy mengi‐kan ni konkonam. ");
INSERT INTO ibl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“No mansheẃat kayo so nen Apo Shiyos, aliẃen sota enshokey ya esel ja enshiy silbi to i jo ikokowan, ja inges toy kepesing ira nonta pagano no mansheẃat ira nodta sinan shiyos sha. Tep say ẃared nemnem sha, no ishokey shay shawat sha, itenengan kono nonta shiyos sha. ");
INSERT INTO ibl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Eg jo onoran sotan na shaka pesing, ta sota Amejod dangit, angken nonta eg jo pay laeng inkowan son si‐kato, amta to i emin na mesepol jo. ");
INSERT INTO ibl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Isonga no mansheẃat kayo, inges niyay i pesing jo: “ ‘Si‐kam ma Amemi ja ẃared dangit, si‐kam koma i mayshedjaw ni olay. ");
INSERT INTO ibl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“ ‘Sota pantoshayan mo, pasebim koma ali, jet sota piyan mo, si‐katoy medeka shiya dobong, ja inges to ngod dangit. ");
INSERT INTO ibl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","I‐kan mo koma sota kenen mi ni inakew. ");
INSERT INTO ibl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Si‐kam i memekawan son si‐kami ni nanbasolan mi, ja inges toy mika pemekawan ni kait min too ja ẃaray nanbasolan sha son si‐kami. ");
INSERT INTO ibl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Karam itolok koma ja manbesol kami, no diket si‐kam i mengiredan son si‐kami say eg kami manbesol.’ ");
INSERT INTO ibl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Agpayso iyay ya ikowan ko son si‐kayo. No pekawanan jo sota ira toon ẃaray nanbasolan sha son si‐kayo, si Apo Shiyos ja Amejo shi dangit, si‐katoy memekawan ngo son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nem no eg jo pekawanan ira sota toon ẃaray nanbasolan sha son si‐kayo, si Apo Shiyos ja Amejon ẃared dangit, eg shakejo ngo pekawanan shi basol jo. ");
INSERT INTO ibl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Jet, no ibiyang jo nin ja eg mengan pangkep ni pamatiyo, eg mesepol la pa‐amtayo shi eshom ma too, ja inges toy kepesing ira nonta toon mengipa‐sas ni mapteng nga aramid sha say eg amta‐an ni karakdan ey ngaaw gayam i nemnem sha. Emedew shi dopara ey si‐kara, inbiyang sha nin i pangan sha maypangkep ni pamatira. Nem podno iya ikowan ko son si‐kayo. Sota ira toon sajay i itsora ni aramid sha, enshiy isobadit nen Apo Shiyos son si‐kara, ta singa ineẃat sha lay konkona sha nonta in‐etek ira ni totoo. ");
INSERT INTO ibl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nem si‐kayo, no ibiyang jo nin i pangan maypangkep ni pamatiyo, sagaysay joy bowek jo, tan pansha‐dop kayo, say sota inpangibiyang jo so ni pangan maypangkep ni pamatiyo, eg medew. ");
INSERT INTO ibl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mapteng no say maka‐amta bengat ket si Apo Shiyos ja Amejon ẃared dangit. Ta si‐kato, ẃara met laeng shita kad‐an mo ni abos mo, jet si‐katoy mengi‐kan ni konkona jo. ");
INSERT INTO ibl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aliẃen sota kokowa shiya dobong i jo kamkamkaman na olnongen, ta sotan iren kokowa, kesheshala ni bigis, kesheshala ni dati, tan kaibetik ni emengibot. ");
INSERT INTO ibl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nem say nemnemen jo et, sota pesing nga mengolnong ni kokowayod dangit. Ta shiman, enshiy onsharal so ono onkibot so. ");
INSERT INTO ibl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Shi dangit komay ẃa‐ẃa‐shen pengolnongan jo ni kokowayo, ta sota kawad‐an ni kokowayo, si‐katoy ẃared nemnem jo ni olay. ");
INSERT INTO ibl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sota mata, si‐katoy may‐eshig ey silew ni bakdang. Jet no mapteng i moka pengesas ja pesing mo ni kokowam, may‐eshig ey napnoy bakdang mo ni dawag. ");
INSERT INTO ibl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nem no ngaaw i moka pengesas nontan na kokowa, ja piyan mon sinopen ja para son si‐kam bengat, may‐eshig ey emin na parti ni bakdang mo ket ẃared embolinget. Jet no ma‐enshiy istay dawag ni nemnem mo, may‐eshig ey embolinget ngon emin i kawad‐an mo. ");
INSERT INTO ibl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Say too, eg mebedin na showay pansilbi‐an to. No ensemek to sota sakey, okesen to sota maykadẃa; no ishayaw to sota sakey, bedawen to sota maykadẃa. Isonga eg kayo mebedin na mansilbi son Apo Shiyos no pilak i ẃa‐ẃa‐sha son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Isonga say ikowan ko son si‐kayo, aliẃen kayo meshanagan ni panbiyag jo: no ngarantoy kenen jo, ono inomen jo, ono ibaro jo. Ta say biyag tan bakdang, epateg nem say mekan tan baro. ");
INSERT INTO ibl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Idmang jo kari ira ja titit ja emantejatejab shi naykayang: eg ira manmoda ono mengepit, ono mengitdo ni apit shi sarosal. Nem si Apo Shiyos ja Amejon ẃared dangit, si‐katoy ememekan son si‐kara. Jet si‐kayo, mas epateg i biyag jo nem say sota ira titit. ");
INSERT INTO ibl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sota joka panshanshanag, eg to met peshokey i biyag jo ni angken ootik. ");
INSERT INTO ibl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Apay nga sota ibaro joy joka panshanshanagi? Asas jo kari ira sota sabsabong shima shontog; nemnem jo kari no toway toka pesing nga manbiyag. Eg met man‐obda ono mengebel ni baro, ");
INSERT INTO ibl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nem iyay i ikowan ko son si‐kayo. Angken si Ari Solomon ja kabaknangan nonta bayag da, emin sota osal ton nankemapteng, eg sha pay ingesen i kamapteng ira nima sabsabong. ");
INSERT INTO ibl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No si Apo Shiyos ket eg to i‐oway sota edet shima shontog ja ẃara niman et no kabasan ket maypool shi apoy, sinto pay kayo mangon too to ja i‐oway to. Isonga eg tokejo baybay‐an. Si‐kayo, ootik eshan i pamatiyo, isonga kayoka meshanagin pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Karekayo meshanagan ja kowan jo ey, ‘Towa emoy pengal‐an da ni i‐ala ni mekan?’ ono, ‘Towa emoy pengal‐an ni i‐ala ni ma‐inom, ono ibaro?’ ");
INSERT INTO ibl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tep si Amejon ẃared naykayang, amta ton emin i mesepol jo. Sota ira toon enshiy pamatira son Apo Shiyos, anam shen si‐karay manshanag ni panbiyangan sha, aliẃen si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Nem say epateg jen mesepol la nemnemen jo, sota pantoshayan nen Apo Shiyos, tan sota mapteng ja piyan ton dag‐en jo. Jet no sajay i pesing jo, emin na banag ja kasapolan jo, i‐akan to. ");
INSERT INTO ibl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Karekayo manshanag niman maypangkep ni ma‐onod alin timpo, ta shi ma‐onod alin timpo, si‐kato ngoy pannemnem jo ni mesepol jo no onmotok sotan ali ngon akew. Sota problima niman na akew, si‐katoy nemnemen jo bengat; eg jo i‐eshom i problima ja onsabi nem kabasan. ");
INSERT INTO ibl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Karejo nemnemen i nankamali‐an ni eshom ja si‐katoy pengikowanan jo ma ey ngaaw ira, say eg ngo ikowan nen Apo Shiyos ey ngaaw kayo. ");
INSERT INTO ibl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sota ẃared nemnem jo ja joka pesing nga mandokod ni kowan jo ey nankolangan ni eshom, si‐kato ngoy osalen nen Apo Shiyos ja pandokod to ngo ni nankolangan jo. ");
INSERT INTO ibl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Apay nga sota ootik ka naybosi shi mata ni kait mo i moka iningning, ey si‐kam ma mismo ket eg mo nemnemen ey ebadeg i naypadkal shi matam? ");
INSERT INTO ibl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na‐alas ja mo ikowan so ni kait mo ey a‐kalen mo sota naybosi shi mateto, ey si‐kam ket ebadeg i naypadkal shi matam ma shorog. ");
INSERT INTO ibl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngaaw ita moka pesing ja moka idibak i ngaaw wa nemnem mo! Ekal mo nin sota mismon naypadkal shi matam say kosto may pan‐esas mo, et say asen mo men pasiya ja a‐kalen sota naybosi shi mata ni kait mo. ");
INSERT INTO ibl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nem mesepol la asen jo nin i pengipiyalan jo so ni inbilin nen Apo Shiyos, ta aliẃen anam ni toon singa asoy ogadi to. No ipiyal jo son si‐kara sota inbilin nen Apo Shiyos, sekitan shakejo et bengat. Kasta met no ẃaray ensekig ga too ja singa keshel i itsora to, angken eg jo ngo ipiyal sota ebanol la maypangkep ni pantoshayan nen Apo Shiyos. Ta no sajay i pesing jo, singa joka pan‐i‐akan shi keshel sota ebanol la para alkos ni baro ni too. Jet sajay ya ebanol, kenshat ta damsisen mango ira nonta keshel iyay et pan‐ikatin sha bengat. ");
INSERT INTO ibl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“No ẃaray mesepol jo, si Apo Shiyos i panbeka‐an jo, jet i‐akan to. No eg kayo on‐ekdas ja mansheẃat son si‐kato, eẃaten joy mesepol jo. Panogtog kayo nin et idokatan tokejo. ");
INSERT INTO ibl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta emin ira sota manbeka, ono mansheẃat son Apo Shiyos, si‐kara ngoy mengeẃat ni medepo son Apo Shiyos. Jet emin ngo iray menogtog, si‐karay maydokatan. ");
INSERT INTO ibl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Arig toy san‐ama. Wara ayay inon‐an jon nga‐nga ja no manbeka so nen ameto ni tinapay ket bato i i‐akan nen ameto? ");
INSERT INTO ibl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ono kaspangarigan ey sota anak to ket manbeka ni piskaw, apay oleg i i‐akan to aya? Enshi, say i‐akan nonta ama so ni anak to, sota mapteng nga ibaga to. ");
INSERT INTO ibl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si‐kayo, angken ngaaw i aramid jo, amtayo met ja mengi‐kan ni mapteng nga ibaga ni anak jo. No satan i ẃara son si‐kayo, mas pay ya amta nen Apo Shiyos ja Amejod dangit ja mengi‐kan ni mapteng nga banag so nonta emengshaw son si‐kato ni kasapolan to. ");
INSERT INTO ibl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Sota piyan jon pesing ni kait jon too son si‐kayo, si‐kato ngoy pesing jo nonta eshom. Ta si‐katoy ẃared ma naysolat ta bilin nen Apo Shiyos, tan si‐katoy kowan ira nonta para padto nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“No sota maypangkep ni pengitoshong jo shi biyag ja enshiy to engintegan, may‐eshig shi sakepan ja edipit. Nem sota embanaw wa sakepan, inam‐ay ya panshalnan, isonga eshakel i kaonsekep nodtan. Nem sotan i mengitoshong shi kesheshalan. Sota sakepan na edipit, edigat ta panshalnan, nem sotan i mengitoshong shi biyag ja enshiy to engintegan. Aliẃen eshakel i kaonsekep shi edipit, nem si‐kato komay seskepen jo. ");
INSERT INTO ibl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tanshaaniyo sota kowan sha ey para padto kono ira nen Apo Shiyos nem o‐owap i shaka ikokowan. No ẃara di ira, singa maronong ira nem mareshal gayam ira ni pamatiyo. ");
INSERT INTO ibl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sajay ira, say pengamta‐an jo no to‐to‐ẃen para padto ira, asas jo nin i shaka dagdag‐a. Say kay‐eshigan ni pengamta‐an jo ni itsora sha, inges to sota mola. Aliẃen shi sebit i ka‐epitan ni kowan sha ey obas, ono sota kowan sha ey higos. Eg ondames i mola ni dames ni sakey ya kalasi ngon mola. ");
INSERT INTO ibl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sota molen mapteng, mapteng i dames to, nem sota molen ngaaw, ngaaw ngoy dames to. ");
INSERT INTO ibl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sota molen mapteng, eg ondames ni ngaaw; kasta met sota ngaaw wa mola, eg mebedin na ondames ni mapteng. ");
INSERT INTO ibl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jet emin na molen eg ondames ni mapteng, mebetang ira jay jet maypool shi apoy. ");
INSERT INTO ibl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sajay iray kay‐eshigan ni too. Ma‐amta‐an i itsora ni too no bidbiren i shaka dagdag‐a. ");
INSERT INTO ibl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Isonga aliẃen emin na too ja mengeẃag ey apo towak ket mayda‐kam shi pantoshayan nen Apo Shiyos. Nem say mayda‐kam, sota mengonod ni piyan nen Amak ja ẃared dangit. ");
INSERT INTO ibl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","No ka‐onoran alin akew, eshakel i mengikowan ey, ‘Pangaasim Apo, engitosho kami met ni esel nen Apo Shiyos et inkowan mi pay ey si‐kam i engibetkag son si‐kami. Inosal mi pay i ngaran mon engipabtik ni dimonyo so nonta ira toon eman‐engaw, tan eshakel pay i milagron kaskasshaaw ja dingka mi ni in‐osal mi so ni ngaran mo.’ Sajay i idason sha ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nem say isongbat ko son si‐kara, ‘Eg takejo am‐amta, ki‐nan kayod jay! Ta si‐kayo, ngaaw i aramid jo nontan.’ ");
INSERT INTO ibl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sota toon ontongpal niyay ya intenengan ton inkowan ko la, si‐kato sota may‐eshig ey toon ẃaray nemnem to. Sajay ya too, may‐eshig ey intowen toy baley tod naypilmin bato. ");
INSERT INTO ibl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jet idi imoran ali, nandayos, nem pesed ja eg na‐an‐ano. Angken shimagem ni makedsang, ja sini‐bok to sotan na baley, eg eto‐dang, ta naytowen i tokod to nodta bato. ");
INSERT INTO ibl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nem sota toon itenengan to bengat i inkowan ko, ja eg to pinati, may‐eshig ey toon enshiy am‐amta to. May‐eshig ey intowen toy baley tod ma sharat. ");
INSERT INTO ibl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jet idi imoran ali, et nandayos, shinepos to sotan na baley. Eshagem pay sotan na baley jet kolpin etowang.” Emin iyay, sajay i intoro nen Jesus so nonta ira too to nonta ẃara ired shontog. ");
INSERT INTO ibl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jet idi naksheng nga inkowan nen Jesus iyay, nasshaaw ira sota totoo nontan na inpangitoro to. ");
INSERT INTO ibl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ta say itsora ni toka pengitosho, ẃara et ngo mowan i kepengipateg ni too nonta toka pan‐itoro nem say sota toro nonta sigod ja emengitosho son si‐kara, ja maistoro ni dinteg ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Idi shimalong si Jesus nodta shontog, eshakel la pasiya ira sota toon imonod son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jet nontan, ẃaray toon dimaw ali son si‐kato ja ebayabayang i bakdang to. Sotan na too, nantalimokod shi sango‐an nen Jesus ja kowan to ey, “Apo, no piyan mo, pamapteng mo iya bakdang ko, say eg sha‐ak seskigen.” ");
INSERT INTO ibl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jet si Jesus, inojad toy takday to et pinishat to sotan na too. Jet kowan nen Jesus son si‐kato ey, “Siya piyan kon onmapteng ka.” Jet nontan met laeng, mimapteng nga shagos sota bakdang to. ");
INSERT INTO ibl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jet si Jesus, binidin to sotan na too ja kowan to ey, “Karam ikokowan iyay so ni eshom, no diket pandiritso ka et ja ondaw shima pari. Ipa‐sas mo ita bakdang mo son si‐kato, ja mimapteng ma. Jet pangidaton ka nonta kowan nen Moises shi dinteg ey maydeton son Apo Shiyos, say amta‐en ni karakdan ey si‐kam, enshi may bayang mo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Idi emanmotok si Jesus shi Kapirnaom, en inaspol nonta kapitan ni solsharo ni Roma, jet kowan nontan ey, “Pangpangaasim apo, emansekit sota baga‐en ko. Eg makakeykey i bakdang to jet emandikat ta pasiya. Imed baley ko niman.” ");
INSERT INTO ibl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jet si Jesus simongbat ja kowan to ey, “Ondawak da et nak pemapteng.” ");
INSERT INTO ibl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nem sota kapitan ni solsharo, simongbat ja kowan to ey, “Nem si‐kak, ekak maykeshi ja ondaw ka shi baley ko. Angken on‐anay sota esel la ikowan mo et onmapteng ma sota baga‐en ko. ");
INSERT INTO ibl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Amtak ta paras ko ey angken esel bengat, kaon‐anay. Ta si‐kak ẃaray apok, jet ẃara ngoy solsharo ja intorayan ko. No ikowan ko nonta sakey ey ondaw, pati‐en to, jet no teẃalen ko sota sakey, ondaw ali. Kasta met sota baga‐en ko, no ikowan ko son si‐kato ey, ‘Obdam iyay’, dag‐en to.” Kowan nonta kapitan ni solsharo. ");
INSERT INTO ibl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Idi intenengan nen Jesus iyay ya kowan nonta kapitan ey sota esel nen Jesus i on‐anay, nasshaaw wa pasiya si Jesus. Jet kowan to nonta ira eshakel la toon imonod son si‐kato ey, “Istay sota Hodiyos et koma i makedsang i pamatira son Apo Shiyos, nem enshiy nak inon‐an son si‐kara ja maka‐inges ni pamati niyay ya aliẃen Hodiyos et ngo mowan! ");
INSERT INTO ibl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ikowan ko son si‐kayo, eshakel aliy medepod emin na sakop niya dobong, ja angken aliẃen Hodiyos, jet si‐karay ontongaw wa mekilikob so nen Abraham, si Isaac, tan si Jacob shima pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nem sota ira Hodiyos ja istay inpata‐nil nen Apo Shiyos ja mayda‐kam shi pantoshayan to, si‐kara et ngo mowan sota pedaw to met laeng shima embolinget. Jet shiman, mannengnengis i ẃared man, tan panngedetnget shay sangi sha ni daringit sha.” ");
INSERT INTO ibl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jet si Jesus, kowan to so nonta kapitan ni solsharo ey, “Eti akad ka, medeka sota kowan mo ta emati ka.” Jet sota baga‐en nonta kapitan, mimapteng nga shagos nonta mismon inkowan nen Jesus iyay. ");
INSERT INTO ibl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jet si Jesus, dimaw shima baley nen Pedro jet simbi ton emansekit sota inepo nen Pedro ja bii. Epaladoy petang ni bakdang to. ");
INSERT INTO ibl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jet si Jesus, pinishat toy takday nonta emansekit jet na‐kal la shagos i sakit nonta bii. Jet nontan met laeng, bimangon na shagos et inkamakaman to ira. ");
INSERT INTO ibl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Idi mama‐shem mala, eshakel ira di sota eman‐engaw wa kawad‐an ni dimonyo, ja indaw ni kait sha son Jesus. Jet si Jesus, esel bengat i inosal ton engipabtik so nonta dimonyo so nontan iren too. Tan inpamapteng to pay ira sota emanpansekit. ");
INSERT INTO ibl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sajay i edaga ta say metongpal sota inpadto nen Isaias nonta bayag da ja kowan to ey, “Si‐kato aliy onsakbat so ni digat tayo, tan mengkal ali nonta sakit tayo.” ");
INSERT INTO ibl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Idi inon‐an nen Jesus sota eshakel la toon nandikmot son si‐kato, inkowan to so nonta too to ey, “Eti, ondaw kito shima piig ni baybay.” ");
INSERT INTO ibl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jet nontan, ẃaray dimaw ali ja maistoro ni dinteg ni Hodiyos, ja kowan to son Jesus ey, “Maistoro, angken toway daẃan mo, mekidawak son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jet si Jesus, simongbat ja kowan to son si‐kato ey, “Pannemnem ka nin, ta saja obdak, edigat. Onito pay sota atap pa animal, tan titit, ta ẃaray koston shaka pan‐ini. Nem si‐kak, enshiy koston baley ko ja pansalshengan ko.” ");
INSERT INTO ibl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jet ẃara ngoy sakey mowan na too nen Jesus ja kowan to ey, “May‐odopak ni olay son si‐kam Apo, nem nak nin isingpet si amak.” ");
INSERT INTO ibl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nem si Jesus, simongbat ja kowan to ey, “Kala et, olay ngo ira sota toon eg sha amtes Apo Shiyos ja mengisingpet nonta etey. Maybidang ey etey ira, jet anam shen mengibka ni etey ya too.” ");
INSERT INTO ibl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jet idi nandogan si Jesus nodta bangka, ja onda‐jat ma, nay‐olop met laeng sota too to. ");
INSERT INTO ibl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jet idi nonta ẃara ired ma baybay, ebiglen kimedsang i shagem nodta baybay, tan makedsang ngo i shadoyon shi baybay, isonga sota bangka, shanshanin sa‐neben ni shanom. Nem si Jesus, en‐amis i ogip to. ");
INSERT INTO ibl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sota ira too to, sha binengon si Jesus, ja kowan sha ey, “Apo! Isedakan jokami! Shanshani kiton metey!” ");
INSERT INTO ibl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jet si Jesus, kowan to son si‐kara ey, “Ngantoy! Apay entakot kayo? Ara kayon too! Ootik eshan i pamatiyo!” Si Jesus, imetan et inkowan to nonta shagem tan baybay ey onsalsheng ira et timalna men pasiya sota baybay. ");
INSERT INTO ibl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jet nasshaaw ira ja too to ja kowan sha ey, “Ngaranto emoy saad niyay ya too? Toka pesalsheng iray shagem tan shadoyon et shaka pati‐a!” ");
INSERT INTO ibl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Intoloy shen bimaliw et mimotok ira nodta dogad ja kowan sha ey Gadara. Jet ẃaray showen too ja en nay‐aspol so nen Jesus. Sajay iren too, ireka man‐engaw tep ẃaray dimonyon pimeket son si‐kara, jet say shaka pan‐i‐iyani, shima kamposanto. Isonga enshiy emanshedan nodtan tep ireka mengila‐kad. ");
INSERT INTO ibl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jet pimekis ira ja kowan sha ey, “Anak nen Apo Shiyos! Nganto may pesing mo son si‐kami? Apay dimaw ka din jokami shosa‐en, ey aneng nin i timpo to?” ");
INSERT INTO ibl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nontan met laeng, ẃara iray eshakel la keshel la naybolos ja nay‐esop nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Isonga sota ira dimonyo, ireka mekikaasi son Jesus ey, “No pebtik jokami shiya too, say piyan mi, on‐etan kami shima eshakel la keshel.” ");
INSERT INTO ibl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jet si Jesus inpalobos to ja kowan to ey, “Ti daw kayo.” Jet sota ira dimonyo, bimetik ira nodta too et pimeket ira nodta eshakel la keshel. Jet sota ira keshel, namtik iren nan‐ekas shima shepdas et dimened ira shi baybay. ");
INSERT INTO ibl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jet sota toon istay emanbantay ira niyay ya keshel, kinano‐an shen inshamag shi siyodad sota emin na epasemak, tan angken pay sota edaga so nonta showen istay kawad‐an ni dimonyo. ");
INSERT INTO ibl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jet sota ira toon engitneng niyay ya shamag, dimaw ira di ja sha inon‐an si Jesus. Idi simbira, ekikaasi ira son si‐kato, ja kowan sha ey, “Pangaasim, ki‐nan ked jay ya kad‐an mi.” ");
INSERT INTO ibl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Si Jesus, en nandogan nodta bangka et pati ira sota too to, jet dimaw ira shima siyodad ja ili to. ");
INSERT INTO ibl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jet nontan, ẃaray binangtal ali ni totoo jet sha in‐ilaw son Jesus. Sotan na toon in‐ilaw sha, eg makakeykey i bakdang to. Idi indasin nen Jesus ey ebadeg i pamatira, kowan to so nonta emansekit ey, “Pan‐imdeng ka kajem ko. Ta sota basol mo, epakaẃanan.” ");
INSERT INTO ibl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sota eshom so nonta ira mamaistoro ni dinteg ni Hodiyos, ja ẃara nodtan, kowan shed nemnem sha ey, “Sajay ya too, toka pa‐so‐i si Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nem si Jesus, amta toy ẃared nemnem sha et kowan to son si‐kara ey, “Apay nga ngaaw i joka nemnemnema? ");
INSERT INTO ibl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Say kowan jo, inba‐ngat kon memekawan ni emin na basol niyay ya too, ey ekak kabaalan? Nem iyay i dag‐en kon pati‐an jo so. Ikowan ko niyay ya too ey man‐ekad, ");
INSERT INTO ibl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","jet no man‐ekad, amta‐en jo ey si‐kak sota kowan nonta para padto nonta bayag da ey Anak ni Too. Amta‐en jo pay ey ẃaray kalintegan kod ja dabaw ni shaga ja memekawan ni basol ni too.” Jet si Jesus inkowan to nonta toon eg man‐ekad ey, “Alam ita amakam, jet akad ka.” ");
INSERT INTO ibl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sota too, bimangon et imakad shi baley to. ");
INSERT INTO ibl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Idi inon‐an ira nonta totoo sotan na edaga, naykel‐eẃan ira, nem inshayaw shes Apo Shiyos, tep ineẃatan sha ey panakabalin nen Apo Shiyos gayam sotan na inon‐an shen edaga ja inpiyal nen Apo Shiyos so ni kait shen too. ");
INSERT INTO ibl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Idi naksheng iyay, si Jesus, eman‐ekad say on‐etan nodtan na dogad, jet inon‐an to sota toon manngeshan ni Mateo ja para singil ni bowis ja eman‐obded opisina to. Jet kowan nen Jesus son si‐kato ey, “Kala, kay‐olop ka son si‐kak, et manbedin ka ni took.” Jet si Mateo, dimayat et imonod son si‐kato, ja nanbalin ni too to. ");
INSERT INTO ibl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jet nontan, engan si Jesus tan sota too to shi baley nen Mateo, jet dinikoban ira nonta kait nen Mateo ja para singil ni bowis, tan sota eshom ma kowan ni Hodiyos ey enshiy kenshat shen too. ");
INSERT INTO ibl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jet sota ira eshom ma Parisiyo, inon‐an sha iyay et kowan sha so nonta too nen Jesus ey, “Apay nga sama maistoro jo ket emekipengan so ira nima para singil ni bowis tan sama eshom ma toon enshiy kenshat sha, ja eshakel i basol sha?” ");
INSERT INTO ibl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Nem idi intenengan nen Jesus iyay ja kowan sha, simongbat son si‐kara ja kowan to ey, “Ekak ali dimaw ja mengeẃis ni toon maronong, nem dimawak ali ja mengeẃis ira nonta toon eshakel i basol sha. Mebedin na may‐eshigak shi doktor. Eg bisita‐en ni doktor i enshiy sakit to, no diket sota ẃaray sakit to. Daw kayo et ashal jo no ngantoy olog niya esel nen Apo Shiyos ja naysolat nonta bayag da ja kowan to ey, ‘Ekak kostoy animal la maydeton son si‐kak, nem eg say piyan ko, kaasi‐an joy eshom ma too.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nontan met laeng, dimaw ali son Jesus sota too nen Juan na para bonjag, jet kowan sha ey, “Si‐kami tan sama ira Parisiyo ket kanayon na mika ibiyang i pangan mi no manngidin kami, nem apay nga sama toom ket eg sha ibiyang i pangan sha?” ");
INSERT INTO ibl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jet si Jesus, say songbat to son si‐kara, in‐arig toy bakdang to shi dakin engaseẃa. Isonga kowan to ey, “Piyan jon ikowan ey sota ira bisita shi kasal, eg ira mengan angken ẃara sota dakin engaseẃa? Enshi, kenshat ta mengan ira. Nem ẃara et mangoy timpon onmotok ali ja ma‐enshi son si‐kara sota dakin engaseẃa, jet si‐katoy timpon ibiyang sha so ni pangan sha maypangkep ni daringit sha.” ");
INSERT INTO ibl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jet si Jesus inkowan to mowan i sakey ya arig son si‐kara ja kowan to ey, “Na‐alas no maysekab i badon abel shi shaan na baro. No maysekab sota bado, jey onkesen, a‐naten to sota nayshaitan ton shaan; nakol ni mema‐ma sota epi‐kat.” ");
INSERT INTO ibl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tan ẃara pay i sakey ya inkowan ton arig, ja kowan to ey, “Na‐alas no may‐iyan i badon adak shi na‐osal la inemag shen katat ja ijanan ni adak, ja kowan sha ey ‘wineskin’. No sotan i pesing jo, onpetjag sota nay‐iyanan to et onkawas sota adak. Tan angken pay sota nay‐iyanan to, mepilshi. Mesepol la no badon adak, bado ngoy kay‐inan to, say eg onkawas iyay ya showa.” ");
INSERT INTO ibl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Idi maramen eman‐a‐sel pay laeng si Jesus, ẃara ngoy mimotok alin too ja pangolo ni Hodiyos. Nantalimokod shi sango‐an nen Jesus ja kowan to ey, “No mebedin, kay‐olop ka son si‐kak shi baley ko, ta sota anak kon bii ket ena‐bosan nonta ekay. Isonga pangaasim, mo isakpal i takday mo son si‐kato. No sajay i dag‐en mo, manbiyag mowan.” ");
INSERT INTO ibl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Si Jesus, dima‐jat ja ekidaw, jet angken sota too nen Jesus, nay‐olop ngo ira. ");
INSERT INTO ibl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Eshakel i toon imonod son Jesus et ẃara ngoy sakey ya biin naydaok ja nanshala ni sampolo tan showen tawen. Ekisikil la imonod son Jesus et pinishat toy kajaran ni baro nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tep sota bii, kowan tod nemnem to ey, “No pishaten kos Jesus, angken sama baro to bengat, onmaptengak ma.” ");
INSERT INTO ibl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jet si Jesus, nanposipos et idi inon‐an to sota bii, kowan to ey, “Anak ko, say minaptengan mo, sota pamatim son si‐kak.” Jet nontan sota bii, nay‐inshas ja mimapteng. ");
INSERT INTO ibl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Idi mimotok si Jesus nodta baley nonta pangolo ja nay‐olopan to, ẃara ira sota para mosiko ni etey, tan eshakel pay iray toon kaonnanangis ni makedsang. ");
INSERT INTO ibl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jet si Jesus, kowan to son si‐kara ey, “Ki‐nan kayod jay, eg etey itan na nga‐nga, na‐ogip bengat.” Nem sota ira totoo, inbi‐ẃisan sha si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nem idi kimi‐nan ira sota eshakel la too, simekep si Jesus et inegni‐an to sota takday nonta biin nga‐nga, jet nanbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sajay ya dingka nen Jesus, eshamag shiman na kedogadogad. ");
INSERT INTO ibl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Idi eman‐ekad si Jesus ja edapo nodtan na dogad, ẃaray showen ekorab ja timened son si‐kato. Kimeljaw ira ja kowan sha ey, “Apo, kaasi‐i jokami! Waray namnama mi ey si‐kam i mengi‐odi nonta nantorayan da nen Ari David!” Kowan ira nonta ekorab. ");
INSERT INTO ibl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jet idi simekep si Jesus nodta baley, dimaw ira di sota ekorab son si‐kato. Jet kowan nen Jesus son si‐kara ey, “Jet kayoka memati ey mebedin na pan‐esas takejo?” Simongbat ira ja kowan sha ey, “Owen apo, kamika memati.” ");
INSERT INTO ibl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jet si Jesus, pinishat toy matesha, ja kowan to ey, “Emati kayo et metongpal sota shawat jo.” ");
INSERT INTO ibl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jet nontan, nan‐asas ma ira. Jet binidin ira nen Jesus ja pasiya, ja kowan to ey, “Eg jo pa‐am‐amta iyay shi eshom.” ");
INSERT INTO ibl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nem sajay iren too, sha et inkokowan shi eshom sota dingka nen Jesus son si‐kara; nakol ni inamta‐an ni totoon emin nodtan na dogad i maypangkep so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Idi dimaw da ira sota showen ekorab, ẃaray toon omel ja in‐ilaw ali ni kait to. Say kabol la eg pan‐a‐selan niyay, ẃaray dimonyo ja pimeket son si‐kato ni olay. ");
INSERT INTO ibl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Idi inpabtik nen Jesus sotan na dimonyo nodtan na too, nan‐esel ma sota istay na‐omel. Sota ira eshakel la toon engasas niyay ya edaga, nasshaw ira ja kowan sha ey, “Angken nonta bayag da ingkato niman, enshiy inges niyay ya edaga shiya ilin Israel.” ");
INSERT INTO ibl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nem sota ira Parisiyo, kowan sha ey, “Enshi kari! Sota apo ni dimonyo i toka osala ja mengipebtik so nonta ira dimonyo met laeng nga ẃared too.” ");
INSERT INTO ibl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jet si Jesus, pinasiyal ton emin sota siyodad tan eshom ma kawad‐an ni totoo. Nantoro pay shima sa‐nopan ira nonta Hodiyos, tan inpaleẃag to sota mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos. Inpamapteng to pay ira sota totoon ekalkalasiy sakit sha. ");
INSERT INTO ibl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Idi inon‐an nen Jesus ira sota eshakel la too, naysemekan, ta say inpangidmang to son si‐kara, singa na‐na‐josan ira ja enshi malay namnama shen pansigshan. Singa sota kalniron ebaybay‐an i kasesaad sha, ja enshiy emengajowan son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Isonga si Jesus, kowan to so nonta ira too to ey, “Eshakel iray toon may‐eshig ey ma‐epit nem kolang iray man‐obda. ");
INSERT INTO ibl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Si Apo Shiyos i mengibetkag ni toon mengepit, isonga si‐kato ngoy pengshawan jo say mengibetkag ali ni on‐atang.” ");
INSERT INTO ibl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Si Jesus, sina‐nop to ira sota pinidi ton too to ja sampolo tan showa. Jet kowan to son si‐kara ey, “Ipiyal ko son si‐kayo ey angken sama ira dimonyo ja pimeket shi totoo, mebedin na pebtik jo. Tan sota ira ẃaray sakit to, mebedin ngon pemapteng jo ira.” ");
INSERT INTO ibl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Say ngaran ira nonta apostol ton sampolo tan showa, sajay. Say epateg son si‐karen emin, si Simon ja say sakey ya ngaran to, si Pedro. Say eshom, si Andres ja agi nen Pedro, tan si Santiago nen Juan ja san‐agin anak nen Sibidi, ");
INSERT INTO ibl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe nen Bartolome; si Tomas, si Mateo ja istay para singil ni bowis; si Santiago ja anak nen Alpio, si Tadio, ");
INSERT INTO ibl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","sota si Simon ja bitarano, tan si Judas Iskariote ja mengileko ali so nen Jesus shi anongosto. ");
INSERT INTO ibl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sajay iren apostol to ja sampolo tan showa, inbetkag to ira, ja kowan to ey, “Karekayo ondaw shima angken towen kawad‐an ira nonta aliẃen kait tayon Hodiyos, ono shima angken towen ili ni i‐Samaria, ");
INSERT INTO ibl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","no diket say daẃan jo bengat, topog jon ondaw nodta kad‐an ni kait tayon Hodiyos ja singa may‐eshig ey kalniron imaraẃi. ");
INSERT INTO ibl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Emin na dawdaẃan jo, ikowan jo son si‐kara ey sota naypadton pantoshayan nen Apo Shiyos, shanshani may timpo to. ");
INSERT INTO ibl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jet angken sota ira emansekit nodtan, pamapteng jo ira, tan no ẃaray sebi‐en jon etey, panbiyag joy eshom. Pamapteng jo pay ira sota ebayabayang i bakdang sha. Sota ira toon eman‐engaw ja ẃaray dimonyon pimeket son si‐kara, pabtik jo son si‐kara sota dimonyon pimeket. Sajay ya panakabalin, ineẃat jon enshiy bayad to son si‐kak, isonga no i‐osal jod eshom ma too, eg kayo mengshaw ni bayad to. ");
INSERT INTO ibl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Karekayo manbedon ni pilak, angken sota manintimos. ");
INSERT INTO ibl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Eg mesepol la mengita‐jon kayo ni bayong, ja pengi‐iyanan jo ni mesepol jod shalan, ono baron pansa‐datan jo, ono sinilas sa pansa‐datan jo, ono sowan. Ta sota man‐obda, nebeng ton may‐aknan ni kompormin mesepol to. ");
INSERT INTO ibl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","No ẃaray motoken jon ili ono baryo, say enapen jo nodtan, sota toon emepiyal. Jet pan‐iyan kayo nin nodtan na baley to ingkatod eg jo pay laeng idekjas sotan na dogad. ");
INSERT INTO ibl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sotan na baley ja motoken jo, ikowan jo so nonta makabaley ey si Apo Shiyos, si‐katoy onbindisiyon son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jet no satan na too ket anam toy inkowan mon bindisiyon ta maronong, sota inkowan jon bindisiyon nen Apo Shiyos, ontoloy son si‐kato. Nem no eg to anam ta ngaaw wa too, bebawi jo sota bindisiyon nen Apo Shiyos ja inkowan jo son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jet no sotan iren too nodtan ket eg shakejo eẃaten, ono eg sha pati‐en i ikowan jo son si‐kara, sota depok ja naypeket shi sediyo, pokpok jo nin asan joka ilekjas sotan na baley ono ili. Ta si‐katoy pengamta‐an sha so ey enshi may biyang jo son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jet no timpo alin pengigsheng nen Apo Shiyos no sipay maysedakan, say podnon mepesamak so nonta too nodtan na dogad, mas embel‐at i keshosara nem say sota toon i‐Sodoma, tan i‐Gomora. ");
INSERT INTO ibl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tanshaaniyo ta ibetkag takejo ja singa kalniron naydaok shima atap pa aso. Isonga mesepol la mantanshaan kayo ja inges toy kepantanshaan ni oleg. Nem mesepol la say itsora ni ogadiyo met laeng, inges toy itsora ni kalopati ja eg meneshal. ");
INSERT INTO ibl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tanshaaniyo sotan na toon kaydaokan jo, ta sota eshom son si‐kara, si‐kara met laeng i mengidaw son si‐kayo shi oskaro. Tan angken shima sa‐nopan sha, sepsepdaten shakejod man pay. ");
INSERT INTO ibl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jet ikoyod shakejo pay shi sango‐an nonta ira gobinarol, tan sango‐an nonta ira ari, ta too takejo. Jet sotan i ẃaya jon mengiringan na mengikowan son si‐kara ni maypangkep son si‐kak. Tan angken sota ira aliẃen Hodiyos, ẃaray ẃaya jon mengikowan son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jet no i‐awat shakejod man, karekayo meshanagan no ngarantoy isongbat jo son si‐kara, ono ikowan jo, ta sota isongbat jo, maypa‐amta met laeng son si‐kayo nontan na oras ja shakejosoka pan‐ibag‐i. ");
INSERT INTO ibl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta aliẃen si‐kayon mismo i onsongbat so, no diket sota Ispirito nen Apo Shiyos ja Amejo, si‐katoy mengitoshong son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Jet sajay alin timpo, angken san‐agin daki, ibaag nonta sakey i agi to shi eshom, ey eg et meshanagan ey angken bono‐en sha. Inges niyay met laeng i pesing ni a‐ama shi annak sha. Jet angken sota ira a‐anak, kontra‐en shay maka‐anak son si‐kara et pebonora pay ira. ");
INSERT INTO ibl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jet angken si‐kayo, sota joka pemati son si‐kak, si‐katoy kabol la okesan shakejo so ni karakdan na too. Nem sota mengitoded ni angken nganton digat ja onsabi son si‐kato, si‐katoy maysedakan. ");
INSERT INTO ibl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No pedigaten shakejo shi sakey ya ili, betik kayo shi eshom ma ili. Podno iyay ya ikowan ko son si‐kayo. Mebedin na eg jo posposen na bebtikan na emin sota ili ni Israel ey onmotok ali sota kowan ni para padto ey Anak ni Too. ");
INSERT INTO ibl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Iyay i nemnemen jo: sota man‐ashal nin, eg ibaingan ni totoo nem say sota emengitosho son si‐kato. Inges to met laeng sota baga‐en, eg sha ibaingan nem say sota apo to. ");
INSERT INTO ibl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sota man‐ashal, mepnek koma no ingesen to sota emengitosho son si‐kato; jet angken ngo sota baga‐en, mepnek ngo koma no ingesen to sota apo to. Say olog niyay, no si‐kak ka apo jo ket eg sha ibaingan, ja kowan sha ey apo sha‐ak ni dimonyo, mas pay ya ngaaw i ikokowan sha maypangkep son si‐kayon took. ");
INSERT INTO ibl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nem say kowan ko, karekayo ontakot son si‐kara. Sota inkowan ko ni abos jo, ja singa esa‐dinan ono nay‐emot niman, mesepol la amta‐an ni eshom. ");
INSERT INTO ibl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sota inkowan ko son si‐kayo ja sikrito, si‐kato ngoy ikowan jo shima karakdan. Jet sota intenengan jon intetobok son si‐kayo, si‐kato ngoy ipaleẃag jod karakdan. ");
INSERT INTO ibl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Karekayo ontakot so nonta ira makakontra son si‐katejo, tep bakdang bengat i kabaalan shen bono‐en; eg sha mebedin na pilshi‐en i dinaẃayo. Nem say mesepol la metekotan koma, si Apo Shiyos, ta ẃaray kabedinan ton meneshal ni bakdang tan dinaẃa ni too shi impiyarno. ");
INSERT INTO ibl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nem ẃara ngoy ebadeg ga semek nen Apo Shiyos. Nemnem jo kari sota titit. Emaydeko i showa ni sakey ya sintimos nem angken sanseskey so nonta titit ja singa enshiy banol sha, eg ibiyang nen Apo Shiyos. No ẃaray ma‐kas sa angken sakey ya titit, amta nen Amejod dangit. ");
INSERT INTO ibl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Angken pay sota bowek ni toktok jo, amta nen Apo Shiyos i kabebilang to. ");
INSERT INTO ibl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Isonga karekayo ontakot tep mas ebadbadeg pay i semek to son si‐kayo nem say sota eshakel la titit. ");
INSERT INTO ibl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sota toon mengikowan so ni kait ton too ey si‐kato ket took, ikowan ko ngo son Amak shi dangit ey sotan na too ket took ka emepiyal. ");
INSERT INTO ibl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nem sota toon mengikowan so ni too ey eg towak amta, ibiyang ko ngo shi sango‐an nen Amak shi dangit. ");
INSERT INTO ibl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Aliẃen jo ipangkep ey dimawak alin mengi‐kan ni olnos shiya dobong. Aliẃen sota maypangkep ni olnos i dinaẃan ko di, no diket say panbenagan ali ni indaw ko, eg man‐i‐inawatan i totoo. ");
INSERT INTO ibl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Angken sota san‐ama, eg ira man‐inawatan, ono sota san‐ina, eg ngo ira man‐inawatan. Angken pay sota san‐inepon bii, eg ira man‐inawatan. ");
INSERT INTO ibl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jet say ẃa‐ẃa‐sha ja mengontra so ni too, sota ẃara met laeng nodta pamilja to. ");
INSERT INTO ibl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sota pipiyan toy ameto, ono ineto nem say si‐kak, eg maykeshin took. Angken sota makapipiyan ni anak ton bii ono daki nem say si‐kak, eg maykeshi ngo ey took. ");
INSERT INTO ibl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jet sota toon eg to enosan i kaybebaing to ono kebitay to maypangkep son si‐kak, eg maykeshin took, ta eg to onoran i inges ni pengenos ko. ");
INSERT INTO ibl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sota mengaẃan ni biyag to, mepokaw son si‐kato et ngo mowan. Nem sota mepokaw i biyag to maypangkep son si‐kak, odi‐en to met laeng sotan na biyag to ingkatod ingka. ");
INSERT INTO ibl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sota mengeẃat son si‐kayo, may‐eshig ey si‐kak i ineẃat sha. Jet sota mengeẃat son si‐kak, may‐eshig ey say ineẃat sha, si Apo Shiyos ja engibetkag ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sota menintil ni para padto nen Apo Shiyos ta amta to ey sotan i mengipedawag ni esel nen Apo Shiyos, may‐inges i kon‐oren to nodta kon‐oren nonta para padto ja i‐akan nen Apo Shiyos son si‐kato. Jet sota toon menintil ni toon maronong, ta amta to ey mapteng nga too, may‐inges i kon‐oren to nodta maronong nga too ja i‐akan nen Apo Shiyos son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jet agpayso iyay. Sota toon mengi‐kan ni angken shanom ma inomen nonta sakey ya kabeba‐an na took, ta amta to ey si‐kak i makatoo son si‐kato, sotan na toon mengi‐kan ni shanom, sigoradon ẃaray kon‐oren to ja i‐akan nen Apo Shiyos son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Idi naksheng nga intod‐an nen Jesus sota sampolo tan showa ja apostol to ja inbetkag ton en mengitosho, dimaw ngo nodta dogadogad ja nay‐esop nodtan ja en nantoro so nonta totoo nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jet nontan, si Juan ja para bonjag, ja naybalod, shinemag to sota maypangkep ni dingdingka nen Cristo, jet say inpasing to, engibetkag ni totoo to son Jesus ja en mengibeka son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","no si‐kato sota inkari nen Apo Shiyos nonta bayag da ey ibetkag to di ja mengisedakan. Jet inbaga sha pay ey, “Si‐kam sota naypadton ibetkag ali nen Apo Shiyos, ono ẃaray apil la seskeshen mi?” ");
INSERT INTO ibl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Simongbat si Jesus ja kowan to so nonta inbetkag nen Juan ey, “Kay‐oli kayo jet ikowan jo so nen Juan sota inon‐an jo tan intenengan jo ni kawasha jod jay. ");
INSERT INTO ibl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ikowan jo ey sota ira nankekorab nan‐asas ira, sota ira nankepilay nan‐akad ira, sota nankebayang i bakdang sha mimapteng ira, sota ira nanketoleng emantetneng, sota eshom ma nanketey nanpawil ira, tan sota ira nankebiteg naytoro son si‐kara i mapteng nga shamag maypangkep son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Si Apo Shiyos i onbindisiyon so nonta enshiy showashowa to son si‐kak.” Kowan nen Jesus so nonta ira inbetkag nen Juan. ");
INSERT INTO ibl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Idi dimaw da sota inbetkag nen Juan, inkowan ma nen Jesus so nonta ira totoo ey, “Nonta dimaw kayo so nen Juan shima dogad ja kad‐an ton nay‐araẃi shi ili, amtayo ey si‐kato ket para padto nen Apo Shiyos. Isonga dimaw kayod man ja en mengesas ni toon para padto nen Apo Shiyos, aliẃen say kayo mengesas ni toon ekapoy ja singa bolong ni edet ja enam‐ay ya iẃagas ni shagem. Aliẃa ngon say dinaẃan jod man ket say kayo mengesas ni toon nanbaro ni mapteng, ta say ka‐asan ira niyay ket shi siyodad ja engkakembaleg i baley sha. Dimaw kayon en mengesas ni para padto et siya, inon‐an joy toon engatngato pay nem say sota eshom ma para padto nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Ta si Juan sota kaytoshongan nonta esel nen Apo Shiyos ja naysolat nonta bayag da, ja kowan to ey, ‘Waray ibetkag ko ja mepangdo ey say si‐kam, jet to isagana ira sota totoo.’ Sajay i padto nonta bayag ja timorong son Juan. ");
INSERT INTO ibl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jet ikowan ko et son si‐kayo. Podno ey si Juan, enshiy to kay‐ingesan so ni emin na toon nay‐anak, andken sipa. Nem say sakey ya toon kabeba‐an shi pantoshayan nen Apo Shiyos, si‐katoy engatngato nem say si Juan. ");
INSERT INTO ibl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jet idi nonta inshogi nen Juan ja para bonjag i obda to, ingkato niman, sota pantoshayan nen Apo Shiyos, eshakel la pasiya i makapiyan. Jet sota ira eshom, ireka emekisikil, ta piyan shen mayda‐kam. ");
INSERT INTO ibl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta sota emin na ẃared bilin ja in‐awat nen Moises nonta bayag da, tan emin sota inkowan ira nonta para padto, inpadtora sota maypangkep ali nonta pantoshayan nen Apo Shiyos. Si Juan i sakey ya engipadto et si‐katoy ka‐onoran. ");
INSERT INTO ibl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Awatiyo koma iya naka pan‐ikowan, ey si Juan, si‐katoy tongpal nonta padto nonta bayag da ey si Elias, ja para padto nen Apo Shiyos nonta bayag da, ondaw mowan ali. ");
INSERT INTO ibl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga itnengi jon pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ara kayon too niman! Sota pemedaw bengat i amtayo. Ikowan koy joka kay‐eshigi. Singa a‐anak kayon ẃared ma malkaro, ja ensikshal la meki‐asil. ");
INSERT INTO ibl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kowan ira nonta eshom ma a‐anak ja ka‐asil jo ey, ‘Nanmosiko kami para son si‐kayo, nem eg kayo met edadsakan! Insa‐dat min nimangis, nem eg kayo met ekinengis!’ ");
INSERT INTO ibl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nonta timpon inpangitoro nen Juan, nagshengan i toka kena, eg menginom ni adak, jet kowan jo ey eman‐engaw. ");
INSERT INTO ibl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jet si‐kak niman na indaw ko di, enganak ni inges toy joka kena, tan enginomak, nem binedaw jowak met laeng, ja kowan jo ey, ‘Asas jo kari iman na too: makibel, ma‐inom ni adak, tan say kajem to pay, sota ira para singil ni bowis, tan angken pay sota ira eshom ma toon enshiy kenshat sha ja eshakel i basol sha.’ Sotan i kowan jo, nem sota ira emati son Juan, tan emati son si‐kak, si‐karay ka‐asan to ey say plano nen Apo Shiyos, podnon mapteng ni olay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jet nontan si Jesus, ẃaray inkowan to maypangkep nonta dogad ja dingka‐an to so ira nonta eshakel la milagro, jet inkowan toy basol ni totoo nodtan na dogad, ta eg sha inbebawi i basol sha. ");
INSERT INTO ibl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jet kowan to ey, “Kakaasi kayo di ja toon i‐Korasin, tan si‐kayon tood Bitsaida. Eshakel i dingkak ka milagro shi ili jo jet inon‐an jo, nem eg kayo nanbebawi. No sajay komen milagro ja inpa‐sas ko son si‐kayo ket inon‐an ni tood Tira tan tood Sidon, angken aliẃen too ira nen Apo Shiyos, sigoradon nanbebawi ira nonta mismon inon‐an sha sota milagro, tan ẃara pay i ka‐on‐anan to ey ireka mandeshingit maypangkep ni basol sha. ");
INSERT INTO ibl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nem ikowan ko son si‐kayo, no onsabi ali sota timpon pengigsheng nen Apo Shiyos no sipay maysedakan, mas embel‐at i keshosayo nem say sota tood Tira, tan tood Sidon. ");
INSERT INTO ibl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Tan si‐kayo ngon tood Kapirnaom, kowan jo ey ingato jon shorog i bakdang jo ingkatod dangit, nem ayshi, eg mebedin! Maybeba kayod impiyarno. Ta no sota milagro ja edaga shita kad‐an jo ket istay edaga koma shi Sodoma nonta bayag da, sigoradon nanbebawi komay tood man. Jet sotan na dogad, istay ẃara koma niman ja eg pinilshi nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nem iyay i ikowan kon podno son si‐kayo. No onmotok ali sota akew wa pengigsheng nen Apo Shiyos no sipay maysedakan, mas embel‐at i keshosayo nem say sota keshosa ni tood Sodoma.” ");
INSERT INTO ibl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nontan met laeng, si Jesus kowan to son Apo Shiyos ey, “Ama, apo ni dangit tan saja dobong, man‐iyamanak son si‐kam, tep say inpa‐amta‐an mo so maypangkep ni pantoshayan mo ket sota ira toon mapiyan na metod‐an. Nem sota ira toon kowan sha ey eshakel i amta to, eg mo ipalobos sa amta‐an shay maypangkep ni pantoshayan mo. ");
INSERT INTO ibl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Owen Ama, edaga iyay tep si‐katoy piyan mon medeka.” Sajay i iyaman nen Jesus son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jet inkowan to pay ey, “Si‐kak bengat i inpiyalan so nen Amak ni emin. Si‐kak bengat i maka‐amta ni emin na maypangkep son si‐kato, tan si‐kato ngo bengat i maka‐amta son si‐kak ka Anak to. Isonga sota piyan kon pengitosho‐an maypangkep ni pantoshayan nen Apo Shiyos, si‐katoy itoro‐an ko so.” ");
INSERT INTO ibl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jet kowan to pay ey, “Si‐kayon nayda‐karan ni toro ni eshom, daw kayo ali son si‐kak ja manbedin ni took. May‐eshig ey singa engaksiw kayo ni kalka ja eg jo posi‐en. Daw kayo ali son si‐kak et pan‐ibdey takejo ni digat jo. ");
INSERT INTO ibl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Si‐kak i mengitosho son si‐kayo et may‐eshig ey engka‐jas i kalken pa‐aksiw ko son si‐kayo, ja inam‐ay ya ma‐aksiw. Si‐kak, na‐anosak et no man‐ashal kayo son si‐kak, eg medikatan i nemnem jo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naytompong nontan ja nanshalan si Jesus nodta oma ja emola‐an, jet sota too nen Jesus, ematod ira nonta naymola jet kinotim shen kinan, ta na‐agang ira. Timpo ni ngilin ni Hodiyos nontan na akew, ");
INSERT INTO ibl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","isonga idi inon‐an ira nonta Parisiyo, kowan sha son Jesus ey, “Asas mo kari ira ma toom! Apay nga dingkara iman ey inparit ni dinteg tayon Hodiyos i mengetod no timpo ni akew wa ngilin?” ");
INSERT INTO ibl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Si Jesus, simongbat ja kowan to son si‐kara ey, “Arig to ngo sota inpasing nen Ari David nonta bayag da ni inka‐ekang to, tan sota ira too to. Apay eg jo aya amtay dingka to? ");
INSERT INTO ibl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dimaw shima tolshen baley ya inbilang sha ey para son Apo Shiyos et inda to sota tinapay ya naydaton son Apo Shiyos, jet kinan to. Jet in‐aknan to pay ira sota too to. Sajay i inpasing to anta nga nayparit son si‐kato tan sota ira kait to i pengan sha nontan na tinapay ya naydaton son Apo Shiyos. Ta sota pari bengat i palobos sa mengan nontan na tinapay. ");
INSERT INTO ibl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jet say sakey pay, apay eg jo aya amtay dinteg tayon Hodiyos ja no timpo ni akew wa ngilin, sota ira pari shima Timplo ket mebedin na man‐obda ira? Jet sotan na dag‐en sha no akew ni ngilin, aliẃen basol sha. ");
INSERT INTO ibl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Isonga angken saja ira took, aliẃen ngaaw sotan na dingkara, ta iyay niman na timpo shiya kad‐an jo i toon eshayshayaw nem say Timplo. ");
INSERT INTO ibl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bimaki itan na kowan jo, ta eg jo ineẃatan i olog nonta esel nen Apo Shiyos ja naysolat nonta bayag da, ja kowan to ey eg to kostoy pengileton ni animal son si‐kato, no diket say piyan to, sota pengaasi tayo ni kait tayon too. No istay ineẃatan jo iyay, eg jo inba‐ngat i kowan ey ẃaray basol ni enshiy basol to. ");
INSERT INTO ibl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Si‐kak ja kowan nonta para padto nonta bayag da ey Anak ni Too, si‐kak i mengikowan no ngantoy mebedin na dag‐en no akew ni ngilin.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nontan met laeng nga akew ni ngilin ni Hodiyos, dimaw si Jesus shima sa‐nopan ira nonta Hodiyos nodtan na dogad, ");
INSERT INTO ibl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","jet simbi tod man i too ja eki‐ngoy i sakey ya takday to. Jet ẃara ngoy too nodtan ja makakontra son Jesus ja nansalodsod son si‐kato ta piyan shen balang nem ẃaray isongbat to ja ibasalan sha so ey basol nen Jesus; isonga kowan sha ey, “Ngaaw aya i pemapteng so ni toon ẃaray sakit to no timpon akew ni ngilin tayon Hodiyos? Ngantoy moka pengi‐odog ni dinteg tayo?” ");
INSERT INTO ibl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Simongbat si Jesus ja kowan to ey, “No kaspangarigan ey ẃaray sakey ya too son si‐kayo ja sesakey bengat i kalniro to jet na‐kas shi pel‐og ni akew wa ngilin, apay baybay‐an to aya? Kenshat ta to met laeng al‐en nontan na akew shima pel‐og. ");
INSERT INTO ibl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jet say biyag ni too, mas pay ya epatpateg nem say sota kalniro. Isonga say kowan ko, eg maypeshit i pandeka ni mapteng no akew wa ngilin.” ");
INSERT INTO ibl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jet kowan to so nonta toon eki‐ngoy i takday to ey, “Oyad mo ita takday mo.” Pinati to sota kowan nen Jesus et mimapteng nga agpayso, ja may‐inges ma nodta sakey ya takday to. ");
INSERT INTO ibl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nem sota ira Parisiyo, bimo‐day ira jet nantatabal ira no ngarantoy pesing shen memono son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nem si Jesus, amta toy pangkep sha, isonga indekjas to sotan na dogad. Nem eshakel iray imonod son si‐kato, jet sota ira manpansekit, inpamapteng to iren emin. ");
INSERT INTO ibl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jet binidin to ira ey eg sha ikokowan i maypangkep son si‐kato so ni angken sipa. ");
INSERT INTO ibl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Saja eg kosto nen Jesus ey amta‐an ni emin i maypangkep son si‐kato, si‐katoy tongpal nonta padton Isaias nonta bayag da ey ekombaba ali sota ibetkag nen Apo Shiyos ja mengisedakan. Say kowan nonta padton Isaias, ja esel nen Apo Shiyos met laeng, kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Sajay sota mansilbi di son si‐kak ja pinidik; si‐katoy ensemek ko, ja emengi‐kan ni naka pan‐imdengi. Sota Ispiritok, si‐katoy mengitoshong son si‐kato. Jet sajay alin mansilbi son si‐kak i mengipa‐amta nonta kosto ja piyan ko so nonta ira toon eg maka‐amta son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sajay ali, eg mekibekal, ono onkeljaw, jet eg to ikedsang shi karakdan no ẃaray ikowan to. ");
INSERT INTO ibl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sota ira ekapoy, eg to ma‐ma‐en, no diket pekedsang to ira. Kaspangarigan ey sota singa silew ẃa emanko‐ko‐shep, eg to kolpi‐en na a‐shepen. Jet shi ka‐onoran, isaad toy toray to jet poro mapteng i maysa‐dat. ");
INSERT INTO ibl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Si‐kato pay i kawad‐an ni namnama ira nonta too ja eg nin maka‐amta son si‐kak.” Sajay i padto nen Isaias ja esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Waray toon ekorab tan eg maka‐esel pay ja nan‐inan ni dimonyo ja indaw sha son Jesus et inpamapteng to sotan na too et nan‐esel ma, tan nan‐asas. ");
INSERT INTO ibl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jet sota ira eshakel la totoo, nasshaaw iren pasiya, jet kowan sha ey, “Sajay emo sota inpadtoren Anak nen Ari David, ja ibetkag kono di nen Apo Shiyos son si‐katejo? Si‐kato emo, ono apil?” ");
INSERT INTO ibl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nem idi intenengan ira nonta Parisiyo sota kowan ira nonta totoo, dinamsis sha, ja kowan sha ey, “Say pan‐osala niyay ya too ja mengipebtik ni dimonyon pimeket shi totoo, sota apo met laeng ni dimonyo ja si Bilsibol.” ");
INSERT INTO ibl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Si Jesus, amta toy ẃared nemnem sha et kowan to son si‐kara ey, “Dokodoko tan na inkowan jo. Apay nga inkowan jo ey sota apo ni dimonyo i naka osala? Eg towak todongan na mengipebtik ni kait to met laeng ja dimonyo, ta amta to ey sajay, arig toy ilin manshowa. No manshowen shorog i sakey ya ili asan ireka mankobat, kenshat ta mepilshi sotan na ili. Kasta met sota siyodad, ono pamilja, ja manshowa, mansisi‐jan ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eg mebedin na si Satanas, pebtik to met laeng i kait to, tep amta to ey no dag‐en to iyay, eg onbayag i pansaad to. ");
INSERT INTO ibl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No kowan jo ey si‐kak ket say naka osala ni naka pebtik so ni dimonyo ket sota apo met laeng ni dimonyo, kowan jo ey si‐kato ngarod i ka‐osala ni too jo ni shaka pebtik so ni dimonyo? No sotan i kowan jo, angken sota ira too jo, bedawen sha ita kowan jo ey sota apo ni dimonyo i ema‐osal ni pebtik so ni kait ton dimonyo. ");
INSERT INTO ibl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nem enshi: say naka osalen pebtik so ni dimonyo, sota Ispirito Santo nen Apo Shiyos, jet sotan i amta‐an jo so ey say pantoshayan nen Apo Shiyos, ẃara ma son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Say agpayso, inebak ko nin sota apo ni dimonyo, jet arig to sota matekal la too. Eg kabaalan ni sakey ya toon onsekep shi baley ni matekal la too ja kowan to ey al‐en ton emin sota ẃara nodta naydaem ni baley. Ayshi, kenshat ta say pesing to nin, bedoren to sotan na too asan toka al‐en emin sota ẃara nodta baley. ");
INSERT INTO ibl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sota toon eg on‐onod son si‐kak, ẃara ira son Satanas ja makakontra son si‐kak. Jet sota eg ontolong son si‐kak ja mengolnong ni too, singa shaka pansisi‐jan ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Isonga ikowan ko son si‐kayo ey emin na basol ni too, ono sota ngaaw ja shaka ikokowan, mebedin na mepekawanan. Nem sota ngaaw ja shaka ikokowan maypangkep nonta Ispirito Santo nen Apo Shiyos, eg mebedin na mepekawanan. ");
INSERT INTO ibl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Angken sipen too ja ngaaw i toka ikokowan maypangkep nonta kowan sha ey Anak ni Too, mebedin na mepekawanan. Nem sota ngaaw i toka ikokowan maypangkep nonta Ispirito Santo nen Apo Shiyos, eg mebedin na mepekawanan niman, angken pay shi ma‐onod alin timpo ingkatod ingka. ");
INSERT INTO ibl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ngaran ni kowan jo ey naykaitan ko so nen Satanas? Na‐alas i joka ikowan ey maptengak nem sina‐shom jet kowan jo mowan ey ngaawak. Topog jon ikowan ey mapteng no mapteng; eg jo bedbediwan; jet no kowan jo ey ngaaw, topog jon ngaaw ngo ni olay. Arig toy mola: no mapteng nga mola, mapteng ngo ni olay i dames to, jet no ngaaw wa mola, ngaaw ngo ni olay i dames to. Say ka‐amta‐an ni itsora ni mola, no mapteng ono ngaaw ket, sota dames to. ");
INSERT INTO ibl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Si‐kayon singa oleg i ogadiyo, enshiy mapteng nga esel ja kaonbo‐day shi bongot jo ta ngaaw i ẃared nemnem jo. Ta sota ẃared nemnem ni too, si‐kato met laeng i kaonbo‐day shi bongot to no ẃaray ikowan to. ");
INSERT INTO ibl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sota toon mapteng i ẃared nemnem to, mapteng ngoy toka ikowan ta si‐katoy ẃara son si‐kato. Nem sota toon ngaaw i ẃared nemnem to, ngaaw ngoy toka ikowan ta si‐katoy ẃara son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ikowan ko son si‐kayo, no timpo alin pengigsheng nen Apo Shiyos no sipay maysedakan, emin sota esel la inba‐ngat ni toon inkowan ja enshiy silbi to, songbatan sha son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta sota esel ja inkokowan mo, no mapteng, si‐katoy kaybetayan to ey si‐kam, maronong ka ja paboran toka so nen Apo Shiyos. Nem sota esel met laeng nga inkokowan mo, no ngaaw, si‐katoy kaybetayan to ey si‐kam meshosa ka.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sota eshom so nonta ira mamaistoro ni dinteg ni Hodiyos, tan sota ira Parisiyo, kowan sha son Jesus ey, “Apo, piyan min ẃaray dag‐en mon milagro say asen mi.” ");
INSERT INTO ibl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nem si Jesus sinongbatan to ira ja kowan to son si‐kara ey, “Ngaaw iray aramid ni too ma niman, eg sha nemnemen si Apo Shiyos! Say shaka pan‐ibaga, sota milagro ta kowan sha ey si‐katoy asanan sha so no agpayson si Apo Shiyos i engibetkag son si‐kak. Nem enshiy milagro ja en maypa‐sas son si‐kara niman! Say pengamta‐an jo ey inbetkag towak ali nen Apo Shiyos, no onsabi son si‐kak sota inges toy epasemak so nen Jonas, ja para padto nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta si Jonas, tedon akew to, tan tedon dabi to shima ekes nonta ebadeg ga nigay shima baybay. Jet si‐kak ja kowan sha ey Anak ni Too, iso met laeng ja metdon akew tan dabi shima nayshalem ni bo‐day. ");
INSERT INTO ibl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","No timpo alin pengigsheng nen Apo Shiyos no sipay maysedakan, ondayat sota toon i‐Niniba ja intod‐an nen Jonas, jet si‐karay mengikowan ey si‐kayon too niman, kenshat ta meshosa kayo. Tep si‐kara, nanbebawi ira nonta intenengan shay esel nen Apo Shiyos ja inkowan nen Jonas son si‐kara. Nem ikowan ko son si‐kayo ey iyay shiyay niman i engatngato nem say si Jonas jet eg jo pinati. ");
INSERT INTO ibl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Say sakey mowan, sota arin bii ja edapod ma pesaw. Ondayat ali no timpon pengigsheng nen Apo Shiyos no sipay maysedakan jet ikowan to ey kenshat ta meshosa kayo. Tep si‐kato, edapod araẃin dogad ni indaw ton to itenengan i kalaing nen Ari Solomon ni toka pantosho. Jet niman, asas jo ta ẃared jay i engatngato ey say si Ari Solomon, jet eg jo mowan pinati.” ");
INSERT INTO ibl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jet kowan pay nen Jesus ey, “No sota dimonyo ket onbetik shi too, eman‐eka‐ekad shima kamag‐an ja eman‐ena‐enap ni pansalshengan to nem enshiy to sepolen. ");
INSERT INTO ibl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jet nemnemnemen to ey on‐oli mowan shima toon istay kawad‐an to. Jet no may‐odi, sebi‐en ton enshiy nan‐iyan et ikowan to ey, ‘Siya, mimapteng ma iya baley ko, edinisan.’ ");
INSERT INTO ibl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Say pesing to, ondaw ja en mengodop ali ni piton kait to ja nankekedsel ey say si‐kato, jet onsekep iren man‐iyan nodtan na too. Jet sotan na too, mema‐may kasesaad to nem say nonta pilmiro. Sajay i kay‐eshigan ni si‐kayon too niman ta nankekedsel kayo.” ");
INSERT INTO ibl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nonta marama ja eman‐a‐sel si Jesus so nonta ira totoo, sota ineto tan sota ira a‐aki to, dimaw ira di jet ẃara ira nodta bo‐dayan, ja kowan sha ey mekitbal ira kono son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Isonga ẃaray sakey so nonta ira too ja engikowan son si‐kato ey, “Wara si inam tan sota ira a‐akim shi bo‐dayan, ja piyan shen mekitbal kono son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nem si Jesus, kowan to so nonta too ja engikowan niyay ey, “Sipay ikarik ja inak, tan sipay ikarik ja a‐akik?” ");
INSERT INTO ibl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jet intoro nen Jesus sota too to, ja kowan to ey, “Sajay iray ikarik ja innak, tan ikarik ja a‐akik. ");
INSERT INTO ibl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tep say naka ikarin innak, tan a‐akik, sota ira mandeka ni piyan nen Amak ja ẃared dangit.” ");
INSERT INTO ibl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nontan met laeng nga akew, si Jesus, bimo‐day nodtan na baley, jet dimaw nodta kilig ni baybay ja en mantosho. ");
INSERT INTO ibl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eshakel ngo i toon imonod ja sha binongolan si Jesus, jet kasoreng si Jesus ma ey man‐a‐tan nodta bangka ja ẃara nodta shanom, jet timongaw nodtan. Sota ira too, ẃara iren esalpag nodta kilig ni shanom. ");
INSERT INTO ibl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eshakel i inkowan nen Jesus son si‐kara, nem poro arig i inpaspasing to. Say sakey ya arig ga inkowan to son si‐kara, sajay: “Waray too ja dimaw wa en nanbangkag shi oma. ");
INSERT INTO ibl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Idi toka pan‐iẃaris sota botil, sota eshom, nayponta shi shalan, jet kinan ira ni titit. ");
INSERT INTO ibl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sota eshom ma botil nayponta ired kabato‐an ja ma‐ingpis i bo‐day to, jet timemel la shagos, tep aliẃen masshel i bo‐day ja nayponta‐an to. ");
INSERT INTO ibl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nem idi simekal i sekit, nakkit sota timemel la botil ta eg shimalem sota damot to. ");
INSERT INTO ibl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sota eshom ngon botil, nayponta ira shima similja ni sebit, jet idi bimengis iren showa, na‐abak sota temel ni mola jet eg timoloy ya bima‐deg. ");
INSERT INTO ibl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sota eshom ngon botil, nayponta shima mapteng nga bo‐day. Jet sajay ira, ẃaray nandames ni sandasos, ẃaray nandames ni enem ma polo, tan ẃara pay i nandames ngo ni tedon polo. ");
INSERT INTO ibl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jet sota ira too met laeng nen Jesus, dimaw ira son si‐kato et inbag‐an sha, ja kowan sha ey, “Apay nga arig ga emin i moka pengitosho son si‐kara?” ");
INSERT INTO ibl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Simongbat si Jesus ja kowan to son si‐kara ey, “Si‐kayo nin i naypalobos ja on‐awat so ni maypangkep nonta pantoshayan nen Apo Shiyos, nem si‐kara, enshi nin. ");
INSERT INTO ibl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta sota ẃaray amta to, si‐kato pay i metod‐an, ingkatod eshakel i amta‐an to. Nem sota enshiy am‐amta to, angken sota ootik ja amta to, ma‐kal son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Isonga arig i naka pengitosho son si‐kara, ta angken isi‐ning sha, eg sha imatonan, tan angken itenengan sha, eg sha amtay olog to. ");
INSERT INTO ibl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Si‐karay kaytoshongan nonta padto nen Isaias nonta bayag da ja esel met laeng nen Apo Shiyos, ja kowan to ey, ‘Itenengan jo ali, nem eg jo eẃatan! Tan asen jo ali nem eg jo idasin. ");
INSERT INTO ibl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta say nemnem ira niyay ya too, timangken, nakol ni eg sha eẃatan. Angken matesha, singa ekimit, nakol ni eg sha idasin. Jet eg ira ma ontorong son si‐kak say pemapteng ko ira.’ Sajay i padto nen Isaias. ");
INSERT INTO ibl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nem si‐kayo, pan‐imdeng kayo, ta ineẃatan jo sota inon‐an jo tan intenengan jo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Agpayso iya ikowan ko son si‐kayo. Eshakel ira sota para padto tan sota eshom ma toon Apo Shiyos nonta bayag da, ja piyan shen on‐an koma iyay ya inon‐an jo niman na timpo, tan piyan shen itenengan koma iyay ya intenengan jo, nem eg sha sina‐kop. ");
INSERT INTO ibl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Itnengi jo ngarod i olog niya arig maypangkep nonta inkowan ko la ey en engiweshis ni botil shi oma. ");
INSERT INTO ibl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","No sota kompormin too ket itenengan to sota maypangkep ni pantoshayan nen Apo Shiyos, nem eg to eẃatan, ondaw ali si Satanas et dingdingen to sotan na intenengan to la. Sotan i kay‐eshigan nonta inkowan kon nayponta‐an ni botil ja shalan. ");
INSERT INTO ibl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Sota nayponta‐an ni botil la kabato‐an, si‐katoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos ja emati ni sanka‐atikan. No itenengan to, ẃaren shagos i imdeng ton mengeẃat, nem eg may‐a‐det shi nemnem to. Isonga magenon ibi‐jag to no onmotok ali sota digat to, ono okesen ni too maypangkep ni in‐awat to so ni esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sota nayponta‐an ni botil ja similja ni sebit, si‐katoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos met laeng, nem say toka nemnemnema, sota pesing ton manbiyag, tan sota ekanas sa biyag ni baknang. Jet anongosto ma ey medingding sota esel nen Apo Shiyos son si‐kato, jet enshi may mapteng nga pantongpalan to. ");
INSERT INTO ibl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sota nayponta‐an ni botil ja mapteng nga bo‐day, si‐kato ngoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos, ja imawat ni olog to. May‐eshig ma ey sajay ira, ẃaray dames sha: ẃaray nandames ni eshakel, ẃaray nandames ni kalaingan, tan ẃaray nandames ni otik.” ");
INSERT INTO ibl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wara pay i sakey ya arig ja inkowan to son si‐kara, ja kowan to ey, “Say kay‐eshigan nonta pantoshayan nen Apo Shiyos, inges to iyay. Waray too ja en nanmola shi payew to, jet tima‐nil la poron pagey i inmola to. ");
INSERT INTO ibl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nem idi kalebi‐an, nandibas ali sota makakontra son si‐kato, jet en engilaok ni botil ni edet nodta naymolen pagey, asan kabetik. ");
INSERT INTO ibl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Idi kimabay sota pagey, jet bimosbos ma, ẃara gayam i apil la naydaok. ");
INSERT INTO ibl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jet sota baga‐en to, dimaw ira ja sha inkowan so nonta apo sha ey, ‘Apo, kowan ko nem poron pagey sota botil la inpaimolam shima payew mo. Apay nga idi bimosbos ira, ẃaray edet gayam ma naydaok?’ ");
INSERT INTO ibl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kowan to son si‐kara ey, ‘Sota makakontra son si‐kak, si‐katoy dimaga so nontan.’ Jet sota baga‐en to, kowan sha so nonta apo sha ey, ‘Jet ngantoy kowan mo? Piyan mon mi demonen sota ira edet ja naydaok?’ ");
INSERT INTO ibl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nem sota apo sha, kowan to ey, ‘Enshi, bay‐iyo, ta no demonen jo sotan na edet, mekigebot da sota pagey. ");
INSERT INTO ibl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Isonga bay‐iyo nin ingkatod onsabi sota timpon pan‐eni. Jet ikowan ko so nonta man‐eni ey idasin sha nin sotan na edet ja bedbeshan shen para maypool. Nem sota pagey, sa‐nopen sha et italo sha shima sarosal ko.’ ” Sajay i in‐arig nen Jesus nonta pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wara pay i sakey ya arig ja inkowan nen Jesus son si‐kara ja kowan to ey, “Say pantoshayan nen Apo Shiyos, may‐eshig nodta botil ni sakey ya kalasin mola ja ootilik. ");
INSERT INTO ibl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sajay ya botil, si‐katoy ka‐otikan na botil so ni emin na botil, nem no i‐esek nonta too nodta gardin to, ey onba‐deg, si‐katoy kabalkan so ni emin na mola. Jet sota ira titit, mebedin na man‐obong ira shima pangpanga to.” ");
INSERT INTO ibl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wara pay i arig ja inkowan nen Jesus son si‐kara ja kowan to ey, “Say pantoshayan nen Apo Shiyos, may‐eshig pay nodta para debag ni tinapay ja inda ni bii, ja to indaok nodta eshakel la arina ingkatod inedinan ton emin.” ");
INSERT INTO ibl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nontan na timpo, emin na inpantoro nen Jesus so nonta ira totoo, arig ni olay i inpangitoro to. Enshiy eshom ma inkowan to son si‐kara, nem eg sajay. ");
INSERT INTO ibl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sajay i tongpal nonta inkowan nonta para padto nonta bayag da ey, “Say pengikowan ko so ni totoo, arig, jet ipa‐amtak son si‐kara sota sigod ja plano nen Apo Shiyos ja eg sha amta, ja plano to nonta eg pay laeng epalsowa iya dobong.” ");
INSERT INTO ibl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jet si Jesus, indekjas to ira sota totoo jet simekep nodta baley. Jet sota ira too nen Jesus, dimaw ira son si‐kato jet kowan sha ey, “I‐odog mo ga sota arig ja inkowan mo maypangkep nonta edet shi payew ja naydaok shi pagey.” ");
INSERT INTO ibl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Simongbat si Jesus ja kowan to ey, “Sajay i olog to: sota engimoda nonta tima‐nil la botil ni pagey, sotan sota kowan sha ey Anak ni Too. ");
INSERT INTO ibl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sota oma, si‐katoy kay‐eshigan niya dobong. Sota ira botil ni pagey, si‐kara sota kay‐eshigan ira nonta mayda‐kam shi pantoshayan nen Apo Shiyos. Sota ira botil ni edet, si‐kara sota kay‐eshigan ira nonta toon ẃara son Satanas. ");
INSERT INTO ibl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sota en engilaok nonta edet, si Satanas i kay‐eshigan to. Sota pan‐eni, say olog to, sota timpon pengigsheng nen Apo Shiyos no sipa shiya dobong i maysedakan. Sota ira man‐eni, si‐kara sota anghil nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sota edet, ma‐olnong jet mepoolan. Sotan i kay‐eshigan ni pesing nen Apo Shiyos no mengigsheng ey eg maysedakan sota nankekedsel. ");
INSERT INTO ibl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Si‐kak sota inpadtora nonta bayag da ey Anak ni Too, jet ibetkag ko ali sota anghil ko jet si‐karay mengkal ira nonta toon emengi‐kan ni panbesolan ni kait sha, tan angken pay sota ira ngaaw i aramid sha, say eg ira mayda‐kam nodta pantoshayan ko. ");
INSERT INTO ibl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jet say pesing ira nonta anghil, iteknal sha ira shima apoy ya empetang nga pasiya. Shiman, mannengnengis i totood man, tan panngedetnget shay sangi sha ni digat sha. ");
INSERT INTO ibl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jet sotan alin timpo, sota ira too nen Apo Shiyos, singa sekit iren menenili shima pantoshayan nen Apo Shiyos ja Amesha. Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan. ");
INSERT INTO ibl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Say pantoshayan nen Apo Shiyos, ebanol; isonga may‐eshig ey singa sota pilak ja pino‐jasan ni too shi payew. Say inpasing nonta too, tina‐bokan to mowan et ebadeg i imdeng to. To indako sota kokowa ton emin et tinongkal to sotan na payew, ta ebanol son si‐kato sota simpol ton pilak nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Say kay‐eshigan pay nonta pantoshayan nen Apo Shiyos, singa sota toon emanbiyaki ja say toka en‐enapa, sota ebanol la bato ja kowan sha ey pirlas. ");
INSERT INTO ibl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Waray simpol ton sakey so nonta pirlas ja ebanol la pasiya. Jet say inpasing to, to indakon emin sota kokowa to et tinongkal to ma sotan na pirlas. ");
INSERT INTO ibl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Say kay‐eshigan pay nonta pantoshayan nen Apo Shiyos, singa sota inpasing ira nonta toon nannigay. Inteknal sha shima baybay sota embanaw wa balshew sha say mengna ira ni eshakel la nigay ya ekalkalasi. ");
INSERT INTO ibl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jet idi enapno sotan na balshew sha, inkoyod ali nonta ira too shima naykilig. Pinispis sha sota mapteng, jet si‐katoy in‐iyan sha nodta ijanan. Nem sota ngaaw, in‐ibong sha. ");
INSERT INTO ibl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Inges niyay i medeka no timpon pengigsheng ali nen Apo Shiyos no sipay maysedakan. Sota ira anghil, si‐karay ondaw ali jet idasin sha sota ira toon ngaaw i aramid sha so nonta ira too nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sota ira toon ngaaw i aramid sha, iteknal sha ira shima apoy ya empetang nga pasiya. Shiman, mannengnengis i totood man, tan panngedetnget shay sangi sha ni digat sha.” Sajay iray arig ga inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jet kowan ma nen Jesus son si‐kara ey, “Jet ineẃatan jo ma i olog nonta arig ja inkowan ko la?” Simongbat ira sota too to ey, “Owen.” ");
INSERT INTO ibl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jet kowan pay nen Jesus son si‐kara ey, “No kasta, si‐kayon maka‐amta ni sigod ja bilin nen Apo Shiyos, no man‐ashal kayo nonta maypangkep ni pantoshayan nen Apo Shiyos, komplito may amtayo. Jet may‐eshig kayo so nonta toon ẃaray baley to ja amta ton mengosal nonta kompormin shaan tan bado ja naytalo nodtan.” ");
INSERT INTO ibl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jet si Jesus, idi naksheng nga inkowan to iyay ya arig, indekjas to sotan na dogad. ");
INSERT INTO ibl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dimaw shima ili to, ja en nantoro shima sa‐nopan ni si‐karen Hodiyos. Jet sota ira too nodtan, ireka messhaaw nonta maypangkep ni toro to ja kowan sha ey, “Towa emoy inamta‐an to so niman na daing to, tan towa emoy engal‐an to niman na panakabalin ton milagro? ");
INSERT INTO ibl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sajay emo met sota anak nonta kalapintiro! Aliẃa ayen si Maria i ineto? Amta tayo met sota ira a‐aki to ja si Santiago, Jose, Simon, tan si Judas. ");
INSERT INTO ibl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tan iyay pay ired jay sota bibiin a‐aki to. Towa ngatay inashalan to so niman na amta to?” ");
INSERT INTO ibl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jet sotan iren kaidiyan to, dinamsis sha si Jesus. Nem si‐kato, say kowan to son si‐kara, “Emin ira sota toon inbetkag ali nen Apo Shiyos, mebedin na mayshedjaw shi emin na ili. Nem shi mismon ili to bengat i eg to kayshedjawan, tan angken pay sota mismon pamilja to, eg sha ishayaw.” ");
INSERT INTO ibl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jet si Jesus, aliẃen eshakel i dingka tod man ja milagro, ta eg ira memati son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nontan na timpo, si Ari Hirodis ja engitoshay ni Galilia, shinemag to sota maypangkep ni dingdingka nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jet kowan to so nonta baga‐en to ey, “Sajay ya shinemag kon milagron toka dagdag‐a, sigosho si‐kato si Juan da ja para bonjag. Nanbiyag emo shi patey, isonga ẃaray panakabalin ton mandeka ni milagro.” ");
INSERT INTO ibl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Sajay i kowan nen Hirodis ta si‐katoy inpabono so nen Juan. Inpa‐shel to nontan et inpaibalod to ta inkowan nen Juan so nen Hirodis ey, “Parit shi bilin nen Apo Shiyos i pengesawam so nen Hirodiyas ja aseẃa nen Felipe ja agim!” Isonga inpa‐shel nen Hirodis si Juan ta pipiyan tos Hirodiyas. ");
INSERT INTO ibl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nontan ma, si Hirodis, piyan ton pebono si Juan, nem entakot so nonta ira totoo, ta si Juan, kaibilang ira nonta totoo ey para padto nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nem idi nonta birthday nen Hirodis, eshakel i bisita to ja ineẃis to, jet nontan, sota anak nen Hirodiyas ja marikit, nansada shi sango‐an shen emin et si Hirodis, eman‐imdeng nontan na dingka nonta marikit. ");
INSERT INTO ibl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Isonga inkari to ey no ngantoy kekshawen nontan na marikit ja anak nen Hirodiyas, i‐akan to. ");
INSERT INTO ibl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jet sotan na anak nen Hirodiyas, to inbaga so nen ineto no ngantoy kekshawen to so nen Hirodis. Jet inkowan nen ineto ey sota toktok nen Juan ja para bonjag i kekshawen to. Isonga kowan nonta marikit ey, “I‐ekan mo ali son si‐kak sota toktok nen Juan ja para bonjag et ipingkan mo di shi embanaw wa pingkan.” ");
INSERT INTO ibl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jet sota ari, naydaw‐an nonta inkowan to so nonta kari to so nonta marikit. Nem mesepol la tongpalen to ta nankari ja intenengan ira nonta bisita to. Isonga si Hirodis, inkowan to ey metongpal ja may‐ekan sota toktok nen Juan so nonta marikit. ");
INSERT INTO ibl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jet nontan ma, engibetkag si Hirodis ni en mengokdo so nen Juan ja ẃared badoran, ");
INSERT INTO ibl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","jet sota toktok nen Juan, inpingkan sha et in‐akan sha so nonta biin anak nen Hirodiyas et to ngo in‐akan so nen ineto. ");
INSERT INTO ibl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sota ngo ira too nen Juan, sha inday bakdang to jet sha inbeka. Jet dimaw ira so nen Jesus ja sha inkowan sotan na epasemak. ");
INSERT INTO ibl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Idi naksheng ja insodsod sha son Jesus iyay, en nandogan shi bangka et indekjas to sotan na dogad. Dimaw ma shima naydesin na dogad ja enshiy totoo. Nem idi inamta‐an ira nonta toon ẃared ka‐ili‐ili sota dinaẃan to, nan‐akad ira ngo ja imonod son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Idi ondisaag si Jesus nodta bangka, inon‐an to ira sota eshakel la toon nay‐aspol et naysemekan na pasiya son si‐kara. Isonga sota ira emanpansekit son si‐kara, inpamapteng to ira. ");
INSERT INTO ibl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nonta enasẃil malay akew, sota ira too nen Jesus, dimaw ira di son si‐kato jet kowan sha ey, “Apo, araẃi met iyay ya dogad shi kabalebaley, isonga pansisi‐jan mo ira jay ya totoo say ira di koma mengenap ni tongkalen shen kenen sha shima kad‐an ni totoo. Edabi met mala.” ");
INSERT INTO ibl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nem si Jesus, kowan to son si‐kara ey, “Angken eg ira ondaw. I‐akniyo et ira ni kenen sha.” ");
INSERT INTO ibl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nem kowan ira nonta too to ey, “Dimen boknol la tinapay met bengat iya ẃara, tan showen piskaw.” ");
INSERT INTO ibl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Si Jesus kowan to son si‐kara ey, “Alejo did jay.” ");
INSERT INTO ibl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jet nontan, inkowan to so nonta ira totoo ey ontongaw ira, tep mapteng i edet nodtan. Inda to sota tinapay tan sota showen piskaw, intangkak tod naykayang jet nan‐iyaman son Apo Shiyos. Idi naksheng nga nan‐iyaman, shinowashowa to asan toka i‐kan so nodta too to, ja si‐karay mengiweshis so nonta ira eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sota ira totoo, engan ira et napsel iren emin. Idi naksheng ira, inolnong ira nonta too nen Jesus sota ebay‐an ja eg kinan ira nonta totoo jet say na‐olnong, sampolo tan showen baskit, ja nankepno. ");
INSERT INTO ibl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jet say kabebilang ira nonta totoo ja engan, ondaw wa dimen dibo, powira ira sota bibii tan a‐anak, ja eg naybilang. ");
INSERT INTO ibl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Idi naksheng iyay, inkowan to so nonta ira too to ey, “Pandogan kayod ma bangka et angken mepangdo kayon ondaw shima shemang ni baybay. Jet si‐kak, pansisi‐jan ko nin ira ja eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jet idi naksheng nga inpansisi‐jan to sota totoo ja kowan to ey angken on‐akad ira, timiyed ngo shima shontog ni abos to say en mansheẃat so nen Apo Shiyos. Jet edabi‐an nodtan ja a‐abos to. ");
INSERT INTO ibl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nem sota bangka ja nandoganan ira nonta too to, imaraẃi ma nodta kilig ni baybay. Jet nontan ma, makedsang i shadoyon ni shanom ta emansheshagem ja nay‐aspol pay son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jet idi daem, dimaw alis Jesus son si‐kara ja nan‐akad shima tapew ni shanom. ");
INSERT INTO ibl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nem sota ira too to, inon‐an sha ali ja eman‐ekad shima tapew ni shanom, jet ireka mankel‐ew wa pasiya ja kowan sha ey banig i inon‐an sha. Jet kimeljaw ira ni takot sha. ");
INSERT INTO ibl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nem si Jesus, imesel la shagos son si‐kara ja kowan to ey, “Pesed! Karekayo ontakot, tep si‐kak iyay!” ");
INSERT INTO ibl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jet si Pedro, simongbat ja kowan to ey, “No agpayson si‐kam, ipedobos mon ondawak da son si‐kam!” ");
INSERT INTO ibl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Simongbat si Jesus ja kowan to ey, “Siya, kala.” Jet si Pedro, jimapas nodta bangka, jet nan‐akad nodta tapew ni shanom ja kowan to ey to sebi‐en si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nem idi dekna‐en nen Pedro ey makedsang i shagem, timakot jet istay ya emanka‐neng. Kimeljaw ja kowan to ey, “Apo atngimak!” ");
INSERT INTO ibl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Shineẃat shagos nen Jesus, ja kowan to ey, “Ootik eshan i pamatim. Apay nga ẃara eshan i showashowam?” ");
INSERT INTO ibl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jet idi nandogan iren showa nodta bangka, simalsheng ma sota shagem. ");
INSERT INTO ibl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jet nontan, sota ira too to nodta bangka, nantalimokod ira ja nanshayaw son si‐kato, jet kowan sha son si‐kato ey, “Agpayson si‐kam sota Anak nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jet nontan, intoloy shen bimaliw et simabi ira nodta nayshemang nga dogad ja kowan sha ey Ginisarit. ");
INSERT INTO ibl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jet idi inimatonan ira nonta totoo nodtan ey si Jesus, inshamag sha nodtan na dogad ja nay‐esop, jet emin ira sota emansekit, indaw sha ali son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jet sota ira totoo, kinshew sha son si‐kato ey no mebedin, angken sota kajaran bengat ni baro to i pishaten sha say onmapteng ira. Jet emin sota ira emirat ni baro to, mimapteng ira. ");
INSERT INTO ibl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sota ira Parisiyo tan sota mamaistoro ni dinteg ni Hodiyos ja edapod Jerusalem, dimaw ira so nen Jesus jet kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apay nga sama ira toom ket eg sha onoren sota sigod ja ogadi nonta bayag da? No mengan ira ket eg ira nin manbodo.” ");
INSERT INTO ibl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Si Jesus, sinongbatan to ira ja kowan to ey, “Si‐kayo, eg jo onoren sota bilin nen Apo Shiyos. Say joka et ngo mowan nemnemnema, sota ogadiyo. ");
INSERT INTO ibl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaspangarigan say sakey ya bilin nen Apo Shiyos ja joka ibiyang, sota kowan to ey, ‘Shayaw mo si amam tan si inam’, tan sota kowan to pay ey, ‘Sota toon ngaaw i toka ikowan so nen ameto, ono si ineto, kenshat ta mebono.’ ");
INSERT INTO ibl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nem si‐kayo, say joka itoro, kowan jo ey angken ibiyang ni too si ameto ono ineto, basta ikowan nonta too so nodta maka‐anak son si‐kato ey, ‘Sota istay i‐akan ko son si‐kayo ja panbiyag jo koma, indasin kon maytodong shi Timplo.’ ");
INSERT INTO ibl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Isonga sajay ya joka pengonod ni ogadiyon joka itoro, inpaskit jo nodta koston bilin nen Apo Shiyos, ja singa enshiy silbi to. ");
INSERT INTO ibl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sesi‐kayo ngon toon kowan to ey ẃara son Apo Shiyos ni emin na poso to nem ẃaray pangkep jon ngaaw! Agpayso ey si‐kayo sota kaytoshongan nonta padto nen Isaias nonta bayag da ja esel nen Apo Shiyos met laeng, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Sajay iren too, shi bongot bengat i engintegan ni shaka panshedjaw son si‐kak, nem shi nemnem sha, araẃi son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enshiy silbi ni shaka panshedjaw son si‐kak, tep say shaka itodtoro ni olay, sota edapo met laeng shi nemnem ni si‐karen too, asan sha mango ikowan ey bilin kono nen Apo Shiyos.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jet si Jesus, tina‐ẃal to ira sota totoo jey ondaw ira di son si‐kato jet kowan to son si‐kara ey, “Itnengi jo iyay ya ikowan ko son si‐kayo jet awatiyo. ");
INSERT INTO ibl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kowan ira nonta Parisiyo ey basol kono no eg kito manbodo asan mangan ja si‐katoy ondogit so ni nemnem. Nem aliẃen sota ikem‐ot jod bongot ja tetdenen jo i ondogit son si‐kayo, no diket sota kaonbo‐day ali shi bongot ja mandepod nemnem jo, si‐katoy kaondogit son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Idi naksheng ja inkowan nen Jesus iyay, sota ira too to, dimaw ira di son si‐kato jet kowan sha ey, “Amtam? Idi intenengan ira nonta Parisiyo sota inkowan mo, ngaaw i nemnem sha son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jet si Jesus simongbat ni arig ja kowan to ey, “Emin na too, may‐eshig ey singa mola jet sota aliẃen mola nen Apo Shiyos, a‐kalen to met laeng. ");
INSERT INTO ibl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Isonga baybay‐iyo ira ma Parisiyo; olay tos Apo Shiyos son si‐kara. Si‐kara sota may‐eshig ey ekorab ja emengiredan ni kait ton ekorab. No kowan nonta sakey ya ekorab ey to ibalnay sota kait ton ekorab, ma‐kas iren showa shi pel‐og.” ");
INSERT INTO ibl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jet nontan met laeng, si Pedro kowan to so nen Jesus ey, “Ileẃag mo ga i olog nita arig son si‐kami.” ");
INSERT INTO ibl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jet si Jesus simongbat ja kowan to ey, “Apay angken si‐kayo, eg kayo pay laeng maka‐aw‐awat? ");
INSERT INTO ibl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Apay eg jo amta ey sota maykem‐ot shi bongot ket say daẃan to, shi ekes, jet onbo‐day met laeng? Eg to dokiten i nemnem. ");
INSERT INTO ibl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nem sota onbo‐day ali shi bongot ja esel, si‐katoy mandepo shi nemnem. Jet sotan na ẃared nemnem, si‐katoy ondogit so ni too. ");
INSERT INTO ibl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta say kedepo‐i ni ngaaw wa pangkep ni too, shi nemnem to. Isonga ẃaray ememono, ẃaray ememii tan emekileki, ẃaray emengibot, ẃaray emengi‐owap, tan ẃaray emenomang ni kait ton too. ");
INSERT INTO ibl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sajay iray kaondogit so ni too. Kowan ni Parisiyo ey sota mengan ja eg nin manbodo, sotan i ondogit so ni too ja panbesolan to. Nem enshi kari.” ");
INSERT INTO ibl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nontan ma si Jesus indekjas to sotan na dogad jet dimaw shi nankinaw‐an ni Tira tan Sidon. ");
INSERT INTO ibl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jet idi nonta ẃares Jesus shiman, ẃaray biin dimaw ali son si‐kato ja too nodtan na dogad. Aliẃen Hodiyos tep poli nonta sigod ja too nodtan, nem kimeljaw ja kowan to ey, “Apo, naka memati ey si‐kam aliy mengibengon son Ari David nonta bayag da! Kaasimak, ta ẃaray anak kon bii nem angsan i kepesing nonta dimonyo ja pimeket son si‐kato, toka pedigaten pasiya!” ");
INSERT INTO ibl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nem si Jesus, eg to sinongsongbatan. Anongosto ma ey kowan nonta too nen Jesus son si‐kato ey, “Pagi‐nan mo ga et ita bii; aliẃen en ontentened ali ja onkelkeljaw.” ");
INSERT INTO ibl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Si Jesus simongbat ja kowan to ey, “Say inbetkagan towak so bengat nen Apo Shiyos, sota ira Hodiyos ja may‐eshig ey kalniron imaraẃi, jet enshiy biyang ko shiya tood jay ya aliẃen Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nem sota bii dimaw et ali ja en nantalimokod shi sango‐an nen Jesus ja kowan to ey, “Apo, kaasi‐imak.” ");
INSERT INTO ibl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jet si Jesus simongbat ja kowan to ey, “Aliẃen nebeng ja nak pekeẃas sota istay para a‐anak ja i‐akan ko so ni aso.” ");
INSERT INTO ibl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nem sota bii simongbat ja kowan to ey, “Owen apo, amtak ita kowan mo, nem angken sota ira aso, mebedin met ja manbiyag ira nonta ema‐kas shi damisaan nonta apo sha.” ");
INSERT INTO ibl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Simongbat si Jesus so nonta bii ja kowan to ey, “Agpayson ebadeg i pamatim! Isonga sota shawat mo, medeka.” Jet nontan met laeng, sota anak nontan na bii, mimapteng nga shagos, ja bimetik sota dimonyo son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Si Jesus, indekjas to mowan sotan na dogad, jet nanshalan shima kilig ni baybay shi Galilia, asan tomiyed shima shontog. Timongaw shiman ja mantosho, ");
INSERT INTO ibl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","jet eshakel la pasiyay totoon dimaw ali son si‐kato. Jet sota ira epilay, ekorab, omel, tan sota ira eshom pay ya ẃaray sakit to, indaw sha son si‐kato shima shontog a kawad‐an to, jet inparokol sha shi kad‐an ni sedi to. Jet si Jesus, inpamapteng to ira. ");
INSERT INTO ibl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jet sota ira eshakel la totoo, nasshaaw ira nonta in‐asas sha so ey nan‐esel ira sota istay eg maka‐esel, nan‐akad ira sota istay epilay, tan angken sota ira ekorab, nan‐asas ira. Jet kowan sha ey, “Agpayso gayam noman na manakabalin i Shiyos ni Hodiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Si Jesus, tina‐ẃal to ira sota too to jet kowan to son si‐kara ey, “Naka kaasi‐i ira ja totoo, ta tedon akew sha niman ja ẃared jay son si‐kak jet enshi may kenen sha. Ekak koston pa‐ekad ira ja eg nin engan, say eg ira onkapoy shi shalan.” ");
INSERT INTO ibl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jet sota ira too nen Jesus, kowan sha ey, “Toway pengal‐an tayod jay ni kenen sha ey enshiy baley shiyay? Eshakel met iren pasiya.” ");
INSERT INTO ibl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jet si Jesus, kowan to son si‐kara ey, “Pigen boknol la tinapay sota ẃara son si‐kayo?” Simongbat ira ja kowan sha ey, “Piton boknol la tinapay, tan ẃara pay i piskaw, nem aliẃen eshakel.” ");
INSERT INTO ibl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jet si Jesus, inkowan to so nonta ira totoo ey ontongaw ira nodta bo‐day. ");
INSERT INTO ibl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inda nen Jesus sota piton boknol la tinapay tan sota piskaw jet nan‐iyaman so nen Apo Shiyos asan toka showashowa‐a. In‐akan to so nonta ira too to ja si‐karay mengiweshis so nonta ira totoo, jet tinongpal sha. ");
INSERT INTO ibl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jet emin ira sota eshakel la totoo, engan ira jet napsel iren emin. Idi naksheng ira, sina‐nop sha sota ebay‐an ja eg sha kinan et ondaw wa piton baskit. ");
INSERT INTO ibl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sota engan niyay ya tinapay, epat ta dibo ja daleki, powisha sota bibii tan a‐anak, ja eg ekibidang. ");
INSERT INTO ibl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jet nontan ma, inpa‐ekad to ira sota totoo jet en nandogan nodta bangka jet dimaw shima dogad ja kowan sha ey Magadan. ");
INSERT INTO ibl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sota ira Parisiyo tan sota Sadosiyo, dimaw ira so nen Jesus ja sha peshasen ni dedamsis sha. Isonga kowan sha son si‐kato ey mandeka ni milagro ja kowan sha ey asanan sha so no podnon inbetkag ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nem si Jesus, sinongbatan to ira ni arig, ja kowan to ey, “No mama‐shem mala, ey asen jon nandangidang, kowan jo ey, ‘Siya, mapteng aliy timpo nem kabasan.’ ");
INSERT INTO ibl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jet no agsapa ey asen jon engolpot shi naykayang, kowan jo ey, ‘Ngaaw aliy timpo niman, on‐oran.’ Joka eẃati met shi naykayang no on‐oran ono enshi, nem apay nga eg jo eẃatan ey emin sota emepespesamak niman na timpon kawashak son si‐kayo ket asdeg to met i kay‐odogan to! ");
INSERT INTO ibl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ngaaw iray aramid ni too ma niman, eg sha nemnemen si Apo Shiyos! Say shaka pan‐ibaga et ngo mowan, sota kowan sha ey asanan sha so no si Apo Shiyos i podnon engibetkag son si‐kak ali. Nem enshiy milagro ja en maypa‐sas son si‐kara niman. Say pengamta‐an jo ey inbetkag towak ali nen Apo Shiyos, no onsabi son si‐kak sota inges toy epasemak so nen Jonas, ja para padto nonta bayag da.” Sajay i kowan nen Jesus asan toka ira ilekjas. ");
INSERT INTO ibl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Idi mimotok shi ira Jesus nodta piig ni baybay, dinibkan sha gayam ja engita‐jon ni balon sha. ");
INSERT INTO ibl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jet si Jesus, kowan to son si‐kara ey, “Tanshaaniyo sota singa para debag ni tinapay ja ẃara so nonta Parisiyo tan Sadosiyo ta baka ma‐edinan kayo.” ");
INSERT INTO ibl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nem sota ira too nen Jesus, ireka mansosongbat ni abos ja kowan sha ey, “Dinibkan tayo eshan ja engita‐jon ni balon tayon tinapay.” ");
INSERT INTO ibl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Si Jesus, indasin to ey sotan i shaka pansosongbati et kowan to son si‐kara ey, “Apay nga kayoka mansosongbat ni ka‐enshi ni balon jo? Ootik eshan i pamatiyo. ");
INSERT INTO ibl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Apay eg jo aya eẃatan? Dinibkan jo aya ey sota dimen boknol la tinapay i edapo‐an nonta kinan ni toon dimen dibo? Istay nemnemen jo koma ey eshakel la baskit i sina‐nop jon eg kinan ira nonta totoo. ");
INSERT INTO ibl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tan say sakey pay, sota piton boknol la tinapay, si‐katoy edapo‐an nonta kinan ira nonta epat ta dibon too. Jet eshakel mowan na baskit i inolnong jon eg sha kinan. ");
INSERT INTO ibl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Isonga eẃatan jo koma ey aliẃen sota maypangkep ni tinapay i naka pan‐ikowan nonta inkowan ko so ey mantanshaan kayo nonta singa para debag ni tinapay ja ẃara so nonta ira Parisiyo tan Sadosiyo.” ");
INSERT INTO ibl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jet nontan ma, sota ira too nen Jesus, ineẃatan sha ey aliẃen to‐to‐ẃen para debag ni tinapay i toka pan‐ikowan. No diket toka pan‐ibanshaan sota maypangkep ni o‐owap pa toro ira nonta Parisiyo, tan sota toro ni Sadosiyo ta maganon man‐a‐elbat ja inges toy para debag ni tinapay. ");
INSERT INTO ibl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Idi simabi si Jesus nodta sakop ni Sisaria Pilipos, inbag‐an to ira sota too to ja kowan to ey, “Ngarantoy kaikokowan ira ni totoo ni maypangkep so nonta naypadton Anak ni Too? Eg sha aya tabtabalen nem sipa‐ak?” ");
INSERT INTO ibl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jet sota ira too to, simongbat ira ja kowan sha ey, “Eg met nan‐i‐inges i shaka ikowan. Say kowan ni eshom, si‐kam kono si Juan ja para bonjag ja etey da, nem sota ira eshom, kowan sha ey si‐kam si Elias ono si Jirimias, ono sakey so nonta ira eshom ma para padto nen Apo Shiyos nonta bayag da ja nan‐ongal mowan ali.” ");
INSERT INTO ibl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jet si Jesus, inbag‐an to mowan ira ja kowan to ey, “Jet si‐kayo ngay? Ngaranto ngoy kowan jo ni maypangkep son si‐kak?” ");
INSERT INTO ibl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Si Simon Pedro, simongbat ja kowan to ey, “Si‐kam sota inpadtora nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan. Si Apo Shiyos, ẃaray biyag to ingkatod ingka jet si‐kam i Anak to.” ");
INSERT INTO ibl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jet si Jesus, kowan to so nen Pedro ey, “Si‐kam Simon ja anak nen Jonas, si Apo Shiyos i onbindisiyon son si‐kam tep si‐kato, ja Amak shi dangit, si‐kato i engipa‐amta niyay son si‐kam ja inkowan mo, aliẃen kait mon too i engikowan. ");
INSERT INTO ibl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jet niman, iyay i ikowan ko son si‐kam Pedro. Say olog ni ngaran mo, bato, jet sotan na bato, si‐katoy na‐det ja kaypilmi‐an ira nonta eshakel la totoon memati son si‐kak met laeng. Isonga angken ngantoy katekal ni patey, eg mebedin na ipeked to ni olay sota memati son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jet si‐kam i ipiyalan ko so nonta may‐eshig ey tolbek ni pantoshayan nen Apo Shiyos. No ngantoy iparit mo shiya dobong, ono ipalobos mo, itolok nen Apo Shiyos ja ẃared dangit ja si‐katoy medeka.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jet binidin to ira sota too to ey angken sipa, eg sha ikokowan ey si‐kato sota naypadto nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan. ");
INSERT INTO ibl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jet manshoki ma nontan, kaipinpinshowa nen Jesus so nonta ira too to ey mesepol la ondaw shi Jerusalem, jet kowan to ey manda‐kam shiman ni eshakel la digat, ta sota ira pangolo ni Hodiyos, tan sota ira apo ni papashi, tan mamaistoro ni dinteg, bedawen sha kono, et anongosto ma ey bono‐en sha. Nem kowan to ey no maykatdon akew, manbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jet nontan ma, si Pedro, to indasin si Jesus et sinelkag to ja kowan to ey, “Enshi! Eg medeka itan son si‐kam Apo! Eg itolok nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nem si Jesus ẃiningi to si Pedro jet kowan to ey, “Betawimak si‐kam ma Satanas! Karam tipeshen i mesepol la dag‐en ko. Say nemnem mo, aliẃen sota plano ja nemnem nen Apo Shiyos, no diket sota etoo‐an na nemnem.” ");
INSERT INTO ibl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inkowan pay nen Jesus so nonta too to ey, “No sipay makapiyan ja on‐onod son si‐kak ja took ni olay, mesepol la si‐kak bengat i nemnemnemen to ja ibiyang ton emin i kompormi. Tan mesepol la enosan to pay ya angken maybebaing ono mebono ja inges to sota toon emasan ni koros ja kaydansa‐an to. ");
INSERT INTO ibl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sota toon entapi toy biyag to ja kowan to ey ensikshal la metey maypangkep son si‐kak, si‐kato et ngo mowan i mepokaw i biyag to. Nem sota toon eg to kaẃanan i bakdang to maypangkep son si‐kak ja angken metey ni toka pansilbi, si‐kato et ngo mowan i i‐aknan nen Apo Shiyos ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","No kaspangarigan ey kinokowa ni sakey ya too i emin na ẃared ja dobong, enshiy silbi nontan na kinokowa to, no eg to kon‐oren sota biyag ja enshiy to engitegan. Enshiy silbi nontan na inpasing to, ta sotan na biyag i epateg ga pasiya, ja enshiy to kaysa‐datan na angken nganto. ");
INSERT INTO ibl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Epateg, ta no sakey alin timpo, emin sota aramid ni too, si‐kak met laeng i onsobadit son si‐kara. Agpayson si‐kak sota kowan nonta para padto nonta bayag da ey Anak ni Too, jet sota idaw ko ali mowan, say kasesaad ko, inges ko met laeng i kasesaad nen Apo Shiyos. Jet may‐odop ali sota anghil ko son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Agpayson ẃaray eshom son si‐kayod jay ja eg metey ingkatod asen sha sota kowan sha ey Anak ni Too ja isaad to sota pantoshayan to met laeng.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Idi ẃaray enem ma akew ja edabas da ni engikowanan nen Jesus niyay, inodop to si Pedro, tan si Santiago nen Juan ja san‐agi, jet timiyed ira ni a‐abos sha shima shontog ga ekayang. ");
INSERT INTO ibl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jet idi mimotok ira nodtan, inon‐an shen nanbaliw i itsora nen Jesus ja emenenili. Singa sekit i itsora ni dopa to jet sota baro to, empotin pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jet nontan met laeng, inon‐an sha si Moises nen Elias ja emekitbal so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jet si Pedro, kowan to so nen Jesus ey, “Apo, mapteng i kawasha tayod jay. No piyan mo, mengemagak ni tedon kampod jay: sota sakey para son si‐kam, sota sakey para son Moises, tan sota sakey para so nen Elias.” ");
INSERT INTO ibl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jet nonta marama pay laeng ja eman‐a‐sel si Pedro, ebiglen ẃaray kolpot ta emenenili ja dimespag ali son si‐kara ja dinikopan to ira. Jet ẃaray esel ja edapo nodtan ja intenengan sha ja kowan to ey, “Sajay i Anak ko jet ensemek ko. Si‐katoy naka kosto‐i, isonga patiyon emin i ikowan to.” Kowan nonta esel alid kolpot. ");
INSERT INTO ibl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jet idi intenengan ira nonta too nen Jesus iyay, nanshomog ira ja epaladoy takot sha. ");
INSERT INTO ibl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nem si Jesus, dimaw ali son si‐kara jet to ira pinishat ja kowan to ey, “Ekẃas kayo, karekayo ontakot.” ");
INSERT INTO ibl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jet idi onshemang ma ira, enshi met i eshom ma ẃara nodtan, no diket si Jesus bengat. ");
INSERT INTO ibl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jet idi ireka manshedong ja edapo nodta shontog, si Jesus binidin to ira sotan na too to ey eg sha ikokowan so ni eshom, ja angken sipa, sota inon‐an sha nonta ẃara ired ma shontog. Jet inkowan to ey asan shaka ikowan iyay nem man‐ongal ma ali sota kowan sha ey Anak ni Too. ");
INSERT INTO ibl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jet sota ira too to, inbag‐an sha si Jesus ja kowan sha ey, “Jet ngantoy kabol la kaikowani so ni mamaistoro ni dinteg ey mesepol la mepangdo alis Elias asan sota naypadto nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan?” ");
INSERT INTO ibl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Simongbat si Jesus ja kowan to ey, “Owen, agpayso ja si Elias nin aliy mepangdo jet si‐katoy mengi‐odi nonta kimapoy ya pamati ni totoo say onkedsang ma. ");
INSERT INTO ibl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nem iyay i kowan ko son si‐kayo. Si Elias, naksheng alin dimaw, nem eg indasin ni too ey si‐kato. Jet dingkara son si‐kato i kompormin kedsel la ninemnem sha. Jet iso met laeng nga sotan i dag‐en sha so nonta kowan ni para padto ey Anak ni Too.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jet sota ira too to, ineẃatan sha ey say toka pan‐i‐arig ja kowan to ey si Elias, si‐kato sota si Juan ja para bonjag. ");
INSERT INTO ibl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Idi simabi ira nodta kad‐an ni eshakel la totoo, ẃaray toon en nantalimokod shi sango‐an nen Jesus ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, kaasi‐im sota anak ko, ta say sakit to, emankelshas. Kakaasin pasiya, ta kanayon na kaonkaro, nakol ni emetowang ni olay shi apoy, tan kanayon na emay‐a‐neng shi shanom. ");
INSERT INTO ibl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Indaw ko so nonta ira toom nem eg sha met kabaalan.” ");
INSERT INTO ibl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jet si Jesus, kowan to ey, “Enshiy pamatiyo eshan, ap‐apil kayon too! Ebayagak met shiyay ja eman‐enos son si‐kayo, nem eg jo pay laeng pati‐en i panakabalin nen Apo Shiyos! Ilaw mo did jay son si‐kak sota nga‐nga.” ");
INSERT INTO ibl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Indaw sha ali nontan met laeng jet si Jesus, inkowan to so nonta dimonyon pimeket so nonta nga‐nga ey, “Betik ked ta nga‐nga!” Jet bimetik nga agpayso sota dimonyo. Jet mimapteng nontan met laeng nga shagos sota nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Idi abos sha, sota ira too nen Jesus, kowan sha ey, “Apay nga eg mi binaalan na inpabtik nontan sota dimonyo so nontan na nga‐nga?” ");
INSERT INTO ibl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Simongbat si Jesus ja kowan to son si‐kara ey, “Ekolang eshan i pamatiyo. Agpayso iya ikowan ko son si‐kayo. No ẃara koma i pamatiyo ja angken ootilik, ja inges toy kaba‐deg nonta botil nonta mola ja kowan sha ey mostasa, mebedin na ikowan jo so nima shontog ey on‐etan shi apil la dogad jet ma‐tan nga agpayso. Jet no inges nontan i pamatiyo, enshiy jo ikowan ey edigat son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nem sajay ya kalasin dimonyo, eg mebedin na pebtik bengat nem eg kita nin mengshaw ni tolong son Apo Shiyos tan mengibiyang ni pangan tayo.” ");
INSERT INTO ibl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Idi sakey ya akew, nan‐o‐odop ira shi Galilia, jet si Jesus kowan to so nonta ira too to ey, “Si‐kak sota kowan ni para padto nonta bayag da ey Anak ni Too, nem may‐eẃatak so nonta ira toon makakontra son si‐kak, ");
INSERT INTO ibl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","jet si‐karay memono son si‐kak. Nem no maykatdon akew, manbiyagak met laeng.” Sajay ya inkowan nen Jesus son si‐kara, ireka mandeshingit ta pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Idi dimaw ired Kapirnaom, sota para singil ni alos ni Timplo shi Jerusalem, dimaw ira so nen Pedro jet kowan sha ey, “Sigosho sota apom, eg man‐edos emo ni para so nonta Timplo shi Jerusalem?” ");
INSERT INTO ibl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Simongbat si Pedro ja kowan to ey, “Emengi‐kan ngo ni alos to.” Jet idi mimotok si Pedro nodta baley, si Jesus i epangdon imesel ja kowan to ey, “Simon, piyan kon amta‐an i moka pannemnem niya ikowan ko son si‐kam. Sipa iray kepansingili ira nonta a‐ashi? Sota ira annak sha, ono sota ira eshom ma totoo?” ");
INSERT INTO ibl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Simongbat si Pedro ja kowan to ey, “Sota ira eshom.” Jet si Jesus, kowan to ey, “No kasta, sota ira annak ni ari, dibshi mango ira. ");
INSERT INTO ibl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Isonga si‐kak, mebedin na dibshi‐ak ni alos ni Timplo nen Apo Shiyos ja Amak. Nem say kowan ko, say eg mesekitan i nemnem ira nonta totoo, daw ka shima baybay et mo ipekat sota bengẃit mo. Jet sota pilmiron nigay ya mekna, si‐katoy al‐en mo. Panga‐ẃab mo et ẃaray on‐an mon pilak nodta bongot to. Si‐katoy al‐en mo ja mo i‐akan ja alos ten showa.” ");
INSERT INTO ibl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Idi nontan met laeng, sota ira too nen Jesus, dimaw ira son si‐kato jet sha inbag‐an ja kowan sha son si‐kato ey, “Sipa emoy engato ali i saad to shi pantoshayan nen Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jet si Jesus, ena‐ẃal ni nga‐nga jet inpaledjat to nodta nankinaw‐an ira nonta too to, ");
INSERT INTO ibl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","jet kowan to son si‐kara ey, “Podno iya ikowan ko son si‐kayo. No eg jo i‐onod ja ingesen iya nga‐nga, eg kayo mayda‐kam shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sota mengibeba ni bakdang to shorog ja inges toy kepesing niya nga‐nga, si‐katoy engato et ngo mowan i saad to shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“No sipa ken too ja mapteng i pesing mo so ni inges niyay ya nga‐nga maypangkep ni semek mo son si‐kak, si‐kak met laeng i tinoshong nonta inpasing mo. ");
INSERT INTO ibl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nem sota istay mengi‐kan ni panbesolan ira niya nankebaben emati son si‐kak, say panmaptengan nontan na too ket ma‐ono‐an koma ni ebadeg ga bato jet en mayteb‐ok shima debeng nga baybay. Sotan i panmaptengan to ta engka‐jas sotan na keshosa to nem say sota penosa nen Apo Shiyos son si‐kato ja pengikesho to no istay itoloy ton panbesol sota kait to. ");
INSERT INTO ibl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ara, ngaaw i itsora ni tood ja dobong ja emengi‐kan ni panbesolan ni kait sha! Ẃaren kenshat i onsabin panbesolan ni too, nem kakaasi sota toon mengi‐kan ni panbesolan ni kait to. ");
INSERT INTO ibl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Isonga no bilang ey sota sakey ya takday mo, ono sota sakey ya sedim i mengi‐kan ni panbesolan mo, potol mo et ibong mo. Ta no pa‐onong mo, si‐katoy kayteknalan mo shima apoy ya shosa‐an ingkatod ingka. Mapmapteng sota ka‐enshi ni sakey ya takday mo ono sakey ya sedim, no sotan i kesalbaran mo. ");
INSERT INTO ibl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kasta met sota sakey ya matam: no si‐katoy mengi‐kan ni panbesolan mo, okit mo jet ibong mo. Ta no pa‐onong mo, si‐katoy kayteknalan mod impiyarno ja kad‐an ni apoy. Mapmapteng sota ka‐enshi ni sakey ya matam, no si‐katoy kesalbaran mo. ");
INSERT INTO ibl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Karejo damsisen ira ja toon nankebaba, ta si Apo Shiyos, eg to ira damsisen. Waray anghil iren jay ya nankebaba jet kepatki ira nen Amak shi dangit. ");
INSERT INTO ibl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ta si‐kak ja naypadton Anak ni Too, say kabol la dinaẃan ko alid ja dobong ket nak ira isalakan sota imaraẃi son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Piyan kon amta‐an i joka pannemnem niya ikowan ko. No bilang ey ẃaray toon nankalniro ni sandasos, nem sota sakey imaraẃi, aliẃa ngaten sotan na too ket idekjas to sota siyam ma polo tan siyam shima shontog jet pilit ta to enapen sota sakey ya imaraẃi? ");
INSERT INTO ibl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jet no sepolen to, man‐imdeng nga pasiya ni insapol to so nonta sakey ya istay imaraẃi, nem say sota siyam ma polo tan siyam ja eg imaraẃi ja ẃara ni olay. ");
INSERT INTO ibl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sajay i arig ni nemnem nen Amejo ja ẃared dangit, ta eg to ngo kosto ja ẃaray angken sakey so nonta ira took ja nankebaba ja on‐araẃi son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“No bilang ey ẃaray basol nonta kait mo son si‐kam, mo ikowan son si‐kato no abos jo. Jet no itenengan to sota ikowan mo son si‐kato, may‐odi mowan ma sota joka pesing nga singa san‐agi ja istay esharal nonta inpanbasol to son si‐kam. ");
INSERT INTO ibl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nem no eg toka itenengan, pangodop ka ni sakey ono showa ja kadẃam jet daw kayo son si‐kato, say emin na ikowan jon showa, ẃaray mengitneng. Ta say naysolat ja esel nen Apo Shiyos nonta bayag da, kowan to ey mesepol i showa ono tedo ja onpaneknek so. ");
INSERT INTO ibl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jet no eg to pay laeng itenengan ja eg memati son si‐kara, ikowan mo ma so nonta ira emati no mesa‐nop ira. No iso met laeng ja eg to itenengan sota ikowan sha son si‐kato, say pesing mo ma son si‐kato, aliẃen mo i‐inges so nonta ira eshom ma kait mod pamati, no diket pasing mo son si‐kato sota moka pesing so nonta ira eg maka‐amta son Apo Shiyos, ono sota para singil ni bowis ja nankekedsel. ");
INSERT INTO ibl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Agpayso iya inkowan ko son si‐kayo. No ngarantoy iparit jo ono ipalobos jo shiya dobong, itolok nen Apo Shiyos ja ẃared dangit ja si‐katoy medeka. ");
INSERT INTO ibl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Iyay pay i ikowan ko son si‐kayo. Sota showen too shiya dobong, no nan‐inges i nemnem sha maypangkep ni shaka pan‐ishawat so nen Apo Shiyos ja Amak shi dangit, sota kekshawen sha, si‐katoy medeka. ");
INSERT INTO ibl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta sota showa ono tedo ja esa‐nop pangkep son si‐kak, ẃara‐ak son si‐kara nontan na inkasa‐nop sha.” Sajay den emin, inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Si Pedro dimaw son Jesus et kowan to ey, “Apo, meminpiga ja pekawanan ko pay laeng sota kait ko no manbesol son si‐kak? Angken meminpito?” ");
INSERT INTO ibl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Simongbat si Jesus ja kowan to ey, “Aliẃen meminpito bengat, no diket meminshakel ja eg mebidang: meminpiton polon pito i pemekawan mo ni kait mo. ");
INSERT INTO ibl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ta say kay‐eshigan ni kaasi nen Apo Shiyos shi pantoshayan to, sajay ya istoriya. Nontan da, ẃaray ari ja piyan ton tabtabalen sota ira baga‐en to maypangkep nonta otang sha son si‐kato say man‐i‐inawatan ira. ");
INSERT INTO ibl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Isonga sota ira baga‐en to ja ẃaray otang sha son si‐kato, inpa‐odop to ira. Jet ẃaray sakey ali ja indaw sha son si‐kato ja diniboy otang to. ");
INSERT INTO ibl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nem sajay ya baga‐en, eg to posi‐en i bayad nonta otang to so nonta apo to. Isonga sota apo to, inkowan to ey maydeko iren san‐aseẃa, pati sota ira annak sha, tan angken pay sota kokowa sha, say bayshan sha sota otang sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nem sota baga‐en, nantalimokod shi sango‐an nonta apo to, ja ekikaasi son si‐kato, ja kowan to ey, ‘Kaasi‐imak apo! Emin sota otang ko son si‐kam, bayshan ko.’ ");
INSERT INTO ibl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jet nontan ma, kinaasi‐an nonta apo to sotan na baga‐en; isonga inkowan to ey angken ondaw ja angken eg to bayshan sotan na otang to. ");
INSERT INTO ibl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nem sotan na baga‐en, idi bimo‐day, inaspol to sota kait ton baga‐en ja engotang ngo son si‐kato ni otik ka pilak. Jet to inshel et sin‐el to, ja kowan to ey, ‘Bayshim niman sota inotang mo son si‐kak!’ ");
INSERT INTO ibl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jet sotan na kait ton baga‐en, nanshomog shi sango‐an to ja ekikaasi son si‐kato, ja kowan to ey, ‘Kaasi‐imak ta sota inotang ko son si‐kam, bayshan ko!’ ");
INSERT INTO ibl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nem sotan na baga‐en ja engotangan ni kait to, memasig, jet to et inbalod sota kait ton baga‐en ja ẃaray otang to son si‐kato ingkatod kowan to ey bayshan to sotan na otang to. ");
INSERT INTO ibl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Idi inon‐an ira nonta eshom ma baga‐en nonta ari iyay ya inpasing nontan, ngaaw i deknara jet sha inkowan so nonta apo sha. ");
INSERT INTO ibl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jet sota apo sha, to inpa‐odop sota baga‐en ja engibedod ni kait ton baga‐en jet kowan nonta apo to ey, ‘Si‐kam ma makedsel la baga‐en! Pinekawanan taka ni emin na otang mo son si‐kak ta ekikaasi ka son si‐kak, ");
INSERT INTO ibl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","jet istay pekawanan mo koma ngo sota kait mon baga‐en ja engotang son si‐kam, ja inges to ngoy inpasing ko son si‐kam!’ ");
INSERT INTO ibl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Isonga sota apo to, bimonget jet inkowan to so nonta emanbantay ni badoran ey ibalod sha sotan na baga‐en to ingkatod eg to bayshan na emin sota otang to. ");
INSERT INTO ibl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Sajay i arig ni kepesing nen Amak shi dangit son si‐kayo no eg jo pekawanan sota kait jo ja manbesol son si‐kayo. Jet mesepol pay ya podnoy pesing jon memekawan.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Idi naksheng ja inkowan nen Jesus iyay, indekjas toy Galilia jet dimaw nodta sakop ni Jodia ja ẃared baliw ni ebadeg ga pa‐dok ja kowan sha ey Jordan. ");
INSERT INTO ibl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jet nontan, eshakel la pasiyay too ja imonod son si‐kato, jet sota ẃaray sakit to, inpamapteng to ira nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Idi nontan, ẃara ngo aliy dimaw son si‐kato ja Parisiyo jet kowan sha ni dedamsis sha ey peshasen sha. Isonga kowan sha ey, “Ngantoy moka pengi‐odog ni dinteg tayon Hodiyos maypangkep ni pengisi‐jan ni aseẃa? Bolos aya i pengisi‐jan ni daki so ni aseẃa to, angken enshiy kabol?” ");
INSERT INTO ibl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Si Jesus, sinongbatan to ira ja kowan to ey, “Apay eg jo aya binasa sota esel nen Apo Shiyos ja naysolat nonta bayag da ja kowan to ey, ‘Manshoki nonta pilmiro, pinalsowa nen Apo Shiyos i daki tan bii.’ ");
INSERT INTO ibl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tan ẃaray inkowan to pay nonta bayag da ey ma‐alsa sota daki so nen ameto nen ineto et may‐a‐shom so nen aseẃa to. Jet sota showen bakdang, may‐eshig ma ey nansaksakey. ");
INSERT INTO ibl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Isonga aliẃen showa ma, no diket saksakey. Inpansaksakey nen Apo Shiyos i san‐aseẃa, isonga enshiy nebeng ni toon mengisi‐jan ni aseẃa to.” ");
INSERT INTO ibl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jet sota ira Parisiyo, kowan sha mowan so nen Jesus ey, “No kasta, apay nga ẃara ngarod i bilin nen Moises maypangkep ni pengisi‐jan? Kowan to ey sota mengisi‐jan ni aseẃa to, mesepol la i‐amagan to ni solat ja isepa to so nonta aseẃa to asan toka tayni.” ");
INSERT INTO ibl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Si Jesus, sinongbatan to mowan ira ja kowan to ey, “Say inpalobosan so nen Moises ey sotan i medeka ket kabol ni katangken ni nemnem jo. Nem nonta pinalsowa nen Apo Shiyos i too, enshiy to inkowan na satan. ");
INSERT INTO ibl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jet niman, ikowan ko son si‐kayo ey sota dakin mengisi‐jan ni aseẃa to, ey eg ekileki sota bii, nanbasol ja inges to sota emii no mengesawa mowan ni apil la bii.” ");
INSERT INTO ibl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jet sota too nen Jesus, kowan sha son si‐kato ey, “No sotan i itsora ni pengesawa, pansigshan ngarod ni daki ey eg mengesawa.” ");
INSERT INTO ibl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Simongbat si Jesus ja kowan to ey, “Aliẃen emin na too ket eẃatan sha iyay ya inkowan ko ja onoren sha. Nem ẃaray eshom ma toon intolok nen Apo Shiyos ja on‐awat so. ");
INSERT INTO ibl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta ẃara nga agpayso ira sota eshom ma eg mengesawa ta nay‐anak iren sotan. Wara ira sota eshom ja eg mengesawa ta ekaponan, tan ẃara ngo ira sota eshom ma eg mengesawa say metopog i pansilbira shi pantoshayan nen Apo Shiyos. Sota toon mebedin na onoren to iya kowan ko, si‐katoy dag‐en to koma.” ");
INSERT INTO ibl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jet sota ira a‐anak, indaw ira di nonta maka‐anak son si‐kara, ta kowan sha ey say isakpal nen Jesus i takday to son si‐kara ja ishawatan to ira son Apo Shiyos. Nem sota ira too nen Jesus, inseg‐ang sha ira sota engidaw ali nonta a‐anak. ");
INSERT INTO ibl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nem si Jesus, kowan to ey, “Baybay‐iyo ira di sota a‐anak ja ondaw ali son si‐kak, karejo iparit. Tep inges iren jay ya a‐anak ja ekombaba i mayda‐kam shi pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jet si Jesus, insakpal toy takday to so nonta ira a‐anak, asan toka ira ilekjas. ");
INSERT INTO ibl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jet nontan, ẃaray sakey ya toon dimaw ali son Jesus jet kowan to ey, “Maistoro, ngarantoy dag‐en ko ja mapteng say meẃad‐anak ni biyag ja enshiy to engintegan?” ");
INSERT INTO ibl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sinongbatan nen Jesus ja kowan to ey, “Apay nga mansedodsod ka son si‐kak ni maypangkep ni mapteng? Amtam met ta saksakey ja si Apo Shiyos bengat i mapteng. Isonga no piyan mon meẃad‐an ni biyag ja enshiy to engintegan, patim sota bilin to.” ");
INSERT INTO ibl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jet sotan na too, kowan to so nen Jesus ey, “Towa nodtan na bilin to i pati‐en ko?” Jet si Jesus, kowan to ey, “Say kowan ni bilin to, kareka memono, kareka memii, kareka mengibot, aliẃen mo ba‐ngaten ja man‐a‐sel ni aliẃen kosto. ");
INSERT INTO ibl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tan say bilin to pay, shayaw mos amam tan si inam, tan semek moy kait mo ja inges toy kasmek mo so ni bakdang mo.” ");
INSERT INTO ibl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jet sota balodaki, simongbat ja kowan to ey, “Emin itan na bilin to, inonod ko ni olay. Jet nganto pay laeng i kolang ko?” ");
INSERT INTO ibl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Simongbat si Jesus mowan ja kowan to ey, “No piyan mo ja enshiy mo pankodangan, ilekom ira sota kokowam jet sota dako to, i‐kan mo so nonta ira nankebiteg. No sajay i pesing mo, say kawad‐an ni kabaknang mo ma, naytalo shi dangit. Jet no meksheng nga sotan i pesing mo, kay‐eshom ka di so ira niya took!” ");
INSERT INTO ibl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nem idi intenengan nonta balodaki iyay ya inkowan nen Jesus, namtik ja ensakit i nemnem to, tep toka tepi‐en pasiya i kinabaknang to. ");
INSERT INTO ibl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jet si Jesus, kowan to so nonta ira too to ey, “Edigat so ni baknang ja onsekep shi pantoshayan nen Apo Shiyos! ");
INSERT INTO ibl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sota animal ja kowan sha ey camel, no kas‐anoy kalikat to ja on‐osok shi ebot ni shakom, mas edigdigat pay ya onsekep i bebaknang shi pantoshayan nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Idi intenengan ira nonta too nen Jesus iyay ya kowan to, nasshaaw iren pasiya jet kowan sha ey, “No kasta, enshi ngarod i maysedakan?” ");
INSERT INTO ibl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Simongbat si Jesus ja kowan to ey, “Agpayson eg kabaalan ni toon mengisedakan ni bakdang to shorog, nem si Apo Shiyos, mebedin to tep kabaalan ton emin.” ");
INSERT INTO ibl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Simongbat ngo si Pedro ja kowan to ey, “Karam ngo dibdibkan ey si‐kami, indekjas min emin i kokowa mi nonta nanbalinan mi ni toom. Jet ngaranto ngarod i konkona mi?” ");
INSERT INTO ibl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jet si Jesus, kowan to son si‐kara ey, “Podno iya ikowan ko son si‐kayo. No sota badon dobong ali ket sota kowan sha ey Anak ni Too, ipakat toy kina‐Shiyos ton mantoshay, jet si‐kayon took ja nay‐ol‐olop son si‐kak, mekitoshay kayo. Si‐kayoy mengigsheng ni panbenagan ni emin na Hodiyos ja poli nonta sampolo tan showa ja annak nen Israel. ");
INSERT INTO ibl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jet ikowan ko son si‐kayo, no sipay engilekjas ni baley to, a‐aki to, annak to, bo‐day to, ono sota maka‐anak son si‐kato, kabol ni inpamati to ni bilin ko, ebadbadeg ga pasiyay eẃaten to ja angken mansandasos, tan kon‐oren to pay i biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nem eshakel ira sota kowan sha ey si‐karay mandesin i eẃaten sha, nem ootik kari. Nem ẃara et ngo mowan i kowan ni karakdan ey ootik i eẃaten sha, nem eshakel kari. ");
INSERT INTO ibl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iyay mowan i kay‐eshigan ni pantoshayan nen Apo Shiyos. Sota pesing nen Apo Shiyos ja menobalit ni too to, may‐eshig so nonta toon emangardin ja engala ni obrantis to. Sotan na too, bimowas ja en mengenap ni toon dagbo‐an to ja man‐obda nodta gardin to. ");
INSERT INTO ibl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jet idi ẃaray simbi ton totoo, ekitodag son si‐kara ey dagbo‐an to ira ni kosto asan to ibetkag iren man‐obda nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Idi nonta alas nowibi ni agsapa, dimaw mowan et ẃaray inon‐an to ja emandaydayat shima malkaro ja enshiy obdara. ");
INSERT INTO ibl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jet kowan to son si‐kara ey, ‘Daw kayo ngo shima gardin ko jet kayo pan‐obda. Dagbo‐an takejo ni kosto.’ Jet sotan iren too, dimaw ira ja en nan‐obda. ");
INSERT INTO ibl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Idi alas dosi, tan alas tris mowan, dimaw mowan sota toon ẃaray gardin to, jet sotan met laeng i inpasing to. ");
INSERT INTO ibl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nonta shanshanin alas singko ni mama‐shem, dimaw mowan jet ẃara pay laeng i inon‐an to ja toon emandaydayat, jet kowan to son si‐kara ey, ‘Ngantoy? Wara kayod jay ni san‐akew? Apay, enshiy obdayo aya?’ ");
INSERT INTO ibl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Simongbat ira ja kowan sha ey, ‘Enshi met i mengeda son si‐kamin man‐obda.’ Isonga simongbat sota ẃaray gardin to ey, ‘Daw kayo ngarod shima gardin ko et kayo pan‐obda.’ ");
INSERT INTO ibl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Idi mama‐shem mala, sota makakokowa nonta gardin, inkowan to so nonta emengimanshal nonta ira man‐obda ey, ‘Ta‐ẃal mo di ira sota nan‐obda et dagbo‐im ira, manshoki nodta na‐onod ja mimotok ingkato nodta epangdo.’ ");
INSERT INTO ibl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Isonga say pilmiron tina‐ẃal to, sota ira engiroki ni obda ni alas singko ni mama‐shem. Jet say ineẃat ni sakey tan sakey son si‐kara, sota koston dagbo ni san‐akew. ");
INSERT INTO ibl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Idi tina‐ẃal to ngo ira di sota epangdon nan‐obda, say namnama sha, kowan sha nem mandesin ira. Nem iso met laeng nga say ineẃat ni sakey tan sakey son si‐kara, sota koston dagbo ni san‐akew. ");
INSERT INTO ibl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Idi ineẃat sha mala sota dagbora, pan‐ikotot nonta ira epangdon nan‐obda sota toon nan‐obda‐an sha, ");
INSERT INTO ibl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ja kowan sha ey ‘Apay nga saja ira na‐onod, ja nan‐obda bengat ni sakey ya oras ket in‐inges moy dagbora son si‐kami ja nan‐obda ni san‐akew? Inen‐enosan mi pay i embel‐at ta obda, tan sakit ni sekit!’ ");
INSERT INTO ibl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nem sota dimagbo son si‐kara, sinongbatan toy sakey son si‐kara ja kowan to ey, ‘Kajem, enshiy ngaaw wa nak dingka son si‐kayo. Timolok kayo met ey say idagbok son si‐kayo ket sota koston dagbo ni san‐akew. ");
INSERT INTO ibl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","I‐ekad jo et ita dagboyo, kosto itan; angken ondaw kayo. Sota ira na‐onod ja nay‐inges i dagbora son si‐kayo ja epangdon nan‐obda, nemnem ko ngon may‐inges ira son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sota piyan kon penobalit ni took, si‐kato, enshiy mengipeshit. Apay, kayoka aya ma‐epal ta ma‐ekanak so ni eshom?’ ” Sajay i arig ga inkowan nen Jesus so nonta ira too to. ");
INSERT INTO ibl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jet si Jesus, intoloy ton kowan to ey, “Isonga sota toon namnama ni karakdan ey ootik i kon‐oren to, si‐kato et ngo mowan i mandesin aliy kon‐oren to. Nem sota kowan ni karakdan ey ebadeg i eẃaten to, si‐kato et ngo mowan i ootik i kon‐oren to ali.” ");
INSERT INTO ibl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Idi nonta kepan‐ekad ira nen Jesus ja ondaw shi Jerusalem, inpata‐nil to ira sota sampolo tan showa ja apostol to et a‐abos sha ma. Nonta ẃara ired ma shalan, kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Itnengi jo iya ikowan ko son si‐kayo. Agpayson si‐kak sota kowan ira nonta para padto nonta bayag da ey Anak ni Too. Nem no onmotok kitod Jerusalem, may‐eẃatak ma so nonta ira apo ni papashi tan mamaistoro ni dinteg tayon Hodiyos ja makakontra son si‐kak. Jet sotan may timpo ja pengikowanan sha ey mebono‐ak koma. ");
INSERT INTO ibl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","I‐awat sha‐ak so nonta ira too ja aliẃen kait tayon Hodiyos say si‐karay memebaing son si‐kak. Sepsepdaten sha‐ak pay, asan sha‐ak ilansa ma shi koros. Nem no maykatdon akew, pan‐ongal towak met laeng nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jet nontan, sota aseẃa nen Sibidi, dimaw ali so nen Jesus et pati sota showen anak to. En nantalimokod shi sango‐an nen Jesus, ta ẃaray ibaga to. ");
INSERT INTO ibl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jet si Jesus, kowan to son si‐kato ey, “Ngantoy ibagam son si‐kak?” Simongbat sota bii ja kowan to ey, “Pangaasim, ikowan mo niman ey no mantoshay ka, mekitoshay ngo ira ja showen anak ko. Sota sakey, ontongaw shi petek ni kanawan mo et sota sakey, ontongaw shi petek ni kanigid mo.” ");
INSERT INTO ibl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Simongbat si Jesus ja kowan to ey, “Joka ba‐ngatay baga ey eg jo nin nemnemen. Wara aliy tasen napno ni digat jet mesepol la nak inomen. Kabaalan jo ayen mengenos ja meki‐inom nontan?” ");
INSERT INTO ibl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jet simongbat mowan si Jesus ja kowan to ey, “Agpayson mekila‐kam kayo nonta digat ja da‐kaman ko. Nem sota itongaw jo shi petek ni kanawan ko, tan kanigid ko, aliẃen si‐kak i mengigsheng so. Sajay, para so nonta ira sigod ja insagana‐an so nen Amak.” ");
INSERT INTO ibl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Idi intenengan ira nonta kait shen sampolo ja apostol nen Jesus iyay ya keshaw nonta san‐agi, ngaaw i deknara son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nem si Jesus, tina‐ẃal to ira jet kowan to son si‐kara ey, “Amtayo met i kepesing ira nonta mantoshay shima kompormin ili, tan sota eshom ma toon nankengatoy saad sha. Shaka ipakat i saad sha, ni shaka pengitoshay met laeng so ni sinekopan sha. ");
INSERT INTO ibl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nem no si‐kayo, aliẃen inges nontan i pesing jo so ni sakey tan sakey son si‐kayo. Sota kowan to ey si‐katoy kangeto‐an son si‐kayo, mesepol la si‐kato et ngo mowan i mengibeba ni bakdang to et si‐katoy man‐obda ni pansigshan ni kait to. ");
INSERT INTO ibl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jet sota piyan ton si‐katoy mandesin son si‐kayo, mesepol la panbedin toy bakdang to ni baga‐en jon emin. ");
INSERT INTO ibl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta angken si‐kak ja naypadto nonta bayag da ey Anak ni Too, ekak dimaw ali ja pansilbi‐an ni karakdan, no diket dimawak ali say mansilbi‐ak son si‐kara. Tan say sakey pay ya dinaẃan ko di, say itolok koy bakdang kon metey, tep si‐katoy kaysedakan ni eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nonta shaka pan‐idekjas i Jiriko, eshakel la pasiya ira sota toon imonod son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jet nodta kalsara, ẃaray showen toon ekorab ja timongaw nodta naykilig. Idi intenengan sha ey si Jesus i ondabas ali nodta kalsara, kimeljaw ira ja kowan sha ey, “Kaasi‐i jokami, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nem sota ira eshakel la too, sinelkag sha ira, ja kowan sha ey, “Eka‐eket kayo!” Nem mina‐mara et ja kimeljaw ja kowan sha ey, “Apo! Kaasi‐i jokami, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kimi‐neng si Jesus et tina‐ẃal to ira ja kowan to ey, “Ngarantoy piyan jon itolong ko son si‐kayo?” ");
INSERT INTO ibl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Simongbat ira ja kowan sha ey, “Apo, pan‐asas jokami, say man‐esas kami ngo.” ");
INSERT INTO ibl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jet si Jesus, toka ira kaasi‐i, isonga pinishat to i matesha. Jet mimapteng iren shagos ja nan‐asas. Jet nay‐eshom ira ma son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nonta nay‐esop ma shi Jesus shi Jerusalem ja ẃara ira shima dogad ja kowan sha ey Bitpag ja osshong ni shontog ja kowan sha ey Olibas, engibetkag ni showen too to, ");
INSERT INTO ibl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jet inbilin to son si‐kara ey, “Daw kayod ma dogad ja naysongbob et nodtan na dogad, ẃaren shagos i asen jon naypagod ja animal la donkey et ẃara ngoy kilaw to. Okasiyo et alejo did jay sotan iren animal. ");
INSERT INTO ibl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No ẃaray mengibeka son si‐kayo no ngantoy joka pan‐okasi so, ikowan jo ey, ‘Si Apo Jesus, mesepol to jet i‐oli to met laeng alin shagos.’ Satan day ikowan jo son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sajay ya inkowan nen Jesus, medeka say metongpal sota naypadto nonta bayag da, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ikowan mo so nonta ira tood Jerusalem ey eg ira koma ontakot tep sota ari sha, ondaw alin mengi‐kan ni talna. Isonga nankabajo ali shi kilaw ni donkey ja para obda.” ");
INSERT INTO ibl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jet sota ira too nen Jesus ja inbetkag to, dingkara sota inkowan to son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jet sota ta‐kep ni baro sha, in‐ap‐ap sha nodta beneg ni donkey et nankabajo si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sota ira ngo eshom ma totoo, in‐ap‐ap sha ngoy baro sha nodta kalsaren panshalnan nen Jesus. Sota ira eshom, ira engala ngo ni emolong nga panga ni kadasan et in‐ap‐ap sha nodta kalsara. ");
INSERT INTO ibl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sota ira totoo ja epangdo ey si Jesus, tan sota ira na‐onod, ireka onkaneljaw ja kowan sha ey, “Salamat son Apo Shiyos tep inbetkag to di iya mengibengon son Ari David nonta bayag da! Bindisiyonan to koma! Salamat son Apo Shiyos ja Kangeto‐an!” Kowan ira nonta totoo. ");
INSERT INTO ibl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Idi emanmotok ma si Jesus shi Jerusalem, emin ira sota too nodta siyodad, eg sha tongolan no ngantoy emankepasemak, isonga kowan sha ey, “Apay sipa aya itan na toon emanmotok?” ");
INSERT INTO ibl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jet sota ira totoo ja nay‐olop son si‐kato, kowan sha ey, “Sajay sota para padto nen Apo Shiyos ja si Jesus i ngaran to. Too did Nasarit ja sakop ni Galilia!” ");
INSERT INTO ibl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Idi mimotok ma si Jesus, simekep shi Timplo, jet emin ira sota emandeko nodtan, tan emenongkal, shinagshag to iren inpabo‐day. Jet tino‐to‐dang to pay ira sota damisaan ira nonta emena‐dat ni pilak, tan sota tongawan ira nonta emandeko ni kalopati. ");
INSERT INTO ibl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jet kowan to son si‐kara ey, “Say kowan ni esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey sajay ya baley nen Apo Shiyos, nayngadnan ey si‐katoy pansheẃatan ni totoo son si‐kato, nem inpanbalin jo ni singa amotan ni tolisan!” ");
INSERT INTO ibl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jet sota ira epilay, tan sota ira ekorab, dimaw ira son si‐kato shima Timplo jet inpamapteng to ira. ");
INSERT INTO ibl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nem inon‐an ira nonta apo ni papashi ni Hodiyos tan sota ira mamaistoro ni dinteg ni Hodiyos sota kaskasshaaw wa dingka nen Jesus, tan intenengan sha sota keljaw ira nonta a‐anak ja kowan sha ey, “Salamat son Apo Shiyos! Iyay ali sota mengibengon son Ari David!” Jet sotan na papashi tan mamaistoro ni dinteg, ngaaw i deknara. ");
INSERT INTO ibl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jet kowan sha so nen Jesus ey, “Apay nga eg mo selkagen ira ma a‐anak? Apay eg mo aya itenengan ima kowan sha?” Sinongbatan ira nen Jesus ja kowan to ey, “Owen, intenengan ko. Nem apay eg jo aya binasa sota esel nen Apo Shiyos ja naysolat nonta bayag da? Kowan to met ey, ‘Sota ira a‐anak tan sota ira koyat, si‐kara et ngo mowan i podno i shaka panshedjaw!’ ” ");
INSERT INTO ibl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nontan met laeng, indekjas to ira et dimaw ma shi Bitania, jet na‐ogip shiman. ");
INSERT INTO ibl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Idi agsapa, eman‐ekad si Jesus say on‐oli mowan shi siyodad ni Jerusalem et naytompong nga na‐agang nontan. ");
INSERT INTO ibl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jet nodta toka pan‐ekari, ẃaray inon‐an ton kadasan nodta kilig ni kalsara. To inon‐an tep namnama to ey ẃaray dames to, nem enshi gayam i dames to; bolong to bengat i ẃara. Jet si Jesus kowan to ey, “Si‐kam ma kadasan, eg ka ma ondames, manipod niman ingkatod ingka!” Jet nontan met laeng, sota kadasan, nakkit ta shagos. ");
INSERT INTO ibl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sota ira too to, idi inon‐an sha iyay ya epasemak so nonta kadasan, nasshaaw ira jet kowan sha ey, “Nganto emoy nakkitan nima kadasan na shagos?” ");
INSERT INTO ibl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kowan ma nen Jesus ey, “Agpayso iya ikowan ko son si‐kayo. No ẃaray pamatiyo ja enshiy showashowa to, aliẃen sota dingkak so niya kadasan bengat i mebedin jon dag‐en, no diket mebedin na ikowan jo pay niyay ya shontog ey ma‐tan shorog ja ondaw shima baybay, jet mayto‐to‐ẃen medeka. ");
INSERT INTO ibl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","No ngantoy ibaga jo so nen Apo Shiyos, eẃaten jo, no enshiy showashowa jo nonta panakabalin ton mengi‐kan.” ");
INSERT INTO ibl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Idi mimotok ma si Jesus shi Jerusalem, nantoro shima Timplo, jet sota ira apo ni papashi tan sota ira eshom ma pangolo ni Hodiyos, dimaw ira di son si‐kato jet kowan sha son si‐kato ey, “Sipay engikowan ey dag‐en mo ira ta moka dagdag‐a shiya Jerusalem? Sipay engibetkag son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Simongbat si Jesus ja kowan to ey, “Ibag‐an takejo ngo nin, jet no songbatan jo ni kosto iya salodsod ko, mebedin na ikowan ko son si‐kayo no sipay engibetkag ali son si‐kak ja mandeka niyay. ");
INSERT INTO ibl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jet sipa ngarod i engibetkag so nen Juan ja en memonjag nontan — nemnem to ngo shorog ono si Apo Shiyos?” Nem sota ira apo ni papashi tan sota eshom ma pangolo ni Hodiyos, nantatabtabal ira ja kowan sha ey, “No ikowan tayo ey si Apo Shiyos, mesampolo kito tep ikowan to ey, ‘No kasta, apay nga eg jo ngarod pinati si Juan?’ ");
INSERT INTO ibl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nem no isongbat tayo ey nemnem ngo nen Juan, katetakot i pesing ni karakdan son si‐katejo. Ta shaka pati‐a ey si Juan, podnon inbetkag ali nen Apo Shiyos ja para padto.” ");
INSERT INTO ibl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jet say songbat sha so nen Jesus, kowan sha ey, “Taẃey, eg mi amta no sipay engibetkag so nen Juan ja memonjag.” Jet kowan ma nen Jesus ngo son si‐kara ey, “Angken ngon si‐kak, ekak ikowan son si‐kayo no sipay engibetkag son si‐kak ja mandeka niya naka dagdag‐a niman.” ");
INSERT INTO ibl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jet ẃara pay i inkowan nen Jesus ja arig son si‐kara, ja kowan to ey, “Nemnem jo kari iyay ya istoriya. Waray toon showay anak to; dimaw so nonta pangodowan et kowan to ey, ‘Anak ko, ka pan‐obda shima gardin tayo niman.’ ");
INSERT INTO ibl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nem sotan na anak to, kowan to ey, ‘Ensikshalak.’ Nem idi nannemnemnem, dimaw met laeng ja en nan‐obda. ");
INSERT INTO ibl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dimaw mowan sota amesha so nonta maykadẃen anak to et iso met laeng i inkowan to. Jet say insongbat nontan na anak to, ‘Owen ama, ondawak.’ Nem enshi kari; eg dimaw. ");
INSERT INTO ibl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jet sipa so nonta ira showa i dimaga so nonta piyan nen amesha?” Simongbat ira ey, “Sota pangodowan.” Jet si Jesus, kowan to son si‐kara ey, “Ikowan ko son si‐kayo i podno. Sota ira para singil ni bowis ja makedsel, tan sota ira bibiin maleki, si‐karay epangdo et ngo mowan ja mayda‐kam shi pantoshayan nen Apo Shiyos nem say si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta dimaw alis Juan son si‐kayo ja engipa‐amta ni koston piyan nen Apo Shiyos ja dag‐en jo, nem eg jo pinati. Sota ira para singil ni bowis tan sota bibiin maleki, emati ira et ngo mowan. Nem si‐kayo, angken na inon‐an jon mismo, eg kayo nanbebawi ni basol jo, tan eg kayo pay memati.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wara pay i inkowan ton arig son si‐kara, ja kowan to ey, “Itnengi jo pay iyay ya arig ja ikowan ko. Waray toon nanmola ni obas shi embanaw wa gardin to; inedad to, tan engamag ni shapidan nonta obas, tan engitowen pay ni baley ya kowadja‐an. Inpa‐ajowan to so ni eshom et dimaw ma shi araẃin ili. ");
INSERT INTO ibl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Idi simabi sota timpon pekibingay to nonta obas, engibetkag ira nonta baga‐en to ja en mengeda ali nonta bingay to so nonta ira engajowan. ");
INSERT INTO ibl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nem sota ira inpangajowan to so nontan na bo‐day to, sinepsepdat sha et sota sakey ya baga‐en, jet sota sakey, binonora. Jet sota maykatdo, kineskespigan sha ni bato. ");
INSERT INTO ibl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sota makabo‐day, engibetkag mowan ni eshakel la baga‐en to jet iso met laeng i dingka ira nonta inpangajowan to nonta bo‐day. ");
INSERT INTO ibl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Idi nonta anongosto, inbetkag nonta makabo‐day sota anak ton mismo ja ondaw ta kowan to ey, ‘Mebedin emon ibaingan sha tep anak ko.’ ");
INSERT INTO ibl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nem idi inon‐an ira nonta engajowan sota mismon anak nonta makabo‐day, nantatabal ira ja kowan sha ey, ‘Sajay sota anak nonta makakokowa niya gardin na tayoka pan‐obda‐i. Bono‐en tayo et say saja bo‐day ya tawid to, kokowa‐en tayo ma.’ ");
INSERT INTO ibl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Indara nga agpayso sota anak nonta makabo‐day nontan et inkoyod shen inbo‐day nodta alad et binonora.” Kowan nen Jesus ni arig to. ");
INSERT INTO ibl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jet nontan ma, inbag‐an nen Jesus ira ja kowan to ey, “Jet no bilang ey ondaw ali sota makakokowa nontan na bo‐day, ngantoy pesing to so nonta ira toon inpangajowan to?” ");
INSERT INTO ibl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jet kowan sha ni songbat sha son si‐kato ey, “Simpri angja‐en to ngo iren bono‐en sotan na makedsel. Jet ipiyal to sota bo‐day so ni eshom ma mengajowan say ẃaray bingayen to no timpo ni apit.” ");
INSERT INTO ibl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jet si Jesus, inbag‐an to ira, ja kowan to ey, “Jet eg jo amten mengi‐odog ngarod nonta esel nen Apo Shiyos ja naysolat nonta bayag da? Kowan to met ey, ‘Sota baton binedaw ira nonta para amag ni baley, ja kowan sha ey enshiy silbi to, si‐kato et ngo mowan gayam i epateg ga bato so ni emin. Si Apo Shiyos i makabaal niyay ya edaga jet kaskasshaaw i tayosoka pengidmang.’ ");
INSERT INTO ibl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sajay i naysolat nonta bayag da, jet niman ma, sota pantoshayan nen Apo Shiyos ja istay ẃara son si‐kayo, ma‐kal son si‐kayo et may‐ekan so ni eshom. Jet mapteng may panbenagan to. ");
INSERT INTO ibl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jet angken sipen too ja maysokbab nodtan na bato, mekosot; tan no sipay tedteshan to, memisit.” ");
INSERT INTO ibl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Idi intenengan ira nonta apo ni papashi ni Hodiyos tan Parisiyo ira jay ya arig nen Jesus, ineẃatan sha ey si‐kara i kaytoshongan nontan na arig. ");
INSERT INTO ibl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kowan sha ey seskelen sha si Jesus nontan, nem entakot sha ira sota totoo, tep sota ira totoo, ireka memati ey si Jesus, kowan sha ey para padton inbetkag ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","In‐arigan nen Jesus mowan ira ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Say kay‐eshigan mowan nonta pantoshayan nen Apo Shiyos, may‐eshig so nonta ari ja nankastos ni ebadeg nonta inpangesawa nonta anak to. ");
INSERT INTO ibl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Inbetkag nonta ari ira sota baga‐en to ja sha odopen ira di sota ineẃis to nontan ja mekikan nodtan. Nem sota na‐awis, ensikshal ira din ondaw. ");
INSERT INTO ibl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Isonga engibetkag mowan ni eshom ma baga‐en to ja kowan to son si‐kara ey, ‘Ikowan jo so nonta ira ineẃis ko nontan ey naksheng nga insaganak sota mekan ni mama‐shem: sota bakak tan sota ira eshom ma animal la mateba, inpapaltik da. Esaganen emin, isonga mesepol la ondaw ira di koma.’ ");
INSERT INTO ibl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dimaw da ira sota baga‐en to ja sha inkowan sotan, nem sota ira toon na‐awis sa mekikan, endedamsis sha. Sota ira eshom, dimaw ira et shi payew, jet sota ira eshom, ira nanbiyaki. ");
INSERT INTO ibl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sota ira eshom ngo so nonta ira na‐awis, inshel sha et sota inbetkag nonta ari jet binebaingan sha ira, asan shaka ira bono‐a. ");
INSERT INTO ibl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Isonga sota ari, bimonget, jet engibetkag ni solsharo to jet sha ngo binono ira sota emono ni baga‐en to, tan pinoolan sha pay sota siyodad ira nontan na totoo. ");
INSERT INTO ibl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jet inkowan to mowan ira nonta eshom ma baga‐en to ey, ‘Emin na mesepol shiya pengesawa ni anak ko, esagana, nem sota ira na‐awis, ja istay mekikan koma, eg ira gayam maykeshi ja mekikan. ");
INSERT INTO ibl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Daw kayo mowan et angken kompormin aspolen jon too shi shalan, awis jo ira did jay.’ ");
INSERT INTO ibl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sota ira baga‐en to, dimaw ira nga agpayso, jet emin sota simbira, inodop sha ira — angken sota ira nankekedsel ono sota ira maronong. Jet nontan ma, sota baley nonta ari, enapno ni toon mekikan. ");
INSERT INTO ibl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nem idi simekep ali sota ari ja to koma asen ira sota dimaw alin bisita, ẃaray inon‐an ton toon ekiskep ali ja eg nanbaro ni para kasal. ");
INSERT INTO ibl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jet sota ari, kowan to son si‐kato ey, ‘Kajem, ita et mangon ẃara ked jay, ey eg ka nanbaro ni para kasal?’ Sotan na too, ebebaingan na imeg‐eket. ");
INSERT INTO ibl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jet sota ari, kowan to so nonta toon emenintil ni toon onsekep ali ey, ‘Balod joy takday nitan na too, pati sota sedi to, jet ipedaw jod ma embolinget. Shiman, mannengnengis i totoo, tan panngedetnget shay sangi sha ni digat sha.’ ” Sajay i arig ja inkowan nen Jesus, asan ẃaray inpan‐onod ton esel ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Eshakel i ineẃis nen Apo Shiyos, nem otik i mayda‐kam shi pantoshayan to.” ");
INSERT INTO ibl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nontan ma, sota ira Parisiyo, dimaw ira ja en nantatabtabal no ngarantoy pesing shen menaol son Jesus say ẃara ikowan ton esel ja ikowanan sha so ey ẃaray basol to. ");
INSERT INTO ibl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jet say inpasing sha, engibetkag ira ni too sha ja nay‐olopan ira nonta too nen Ari Hirodis, jet kowan sha so nen Jesus ey, “Maistoro, amta mi ey podnon emin sota kowan mo, tan sota torom ket si‐katoy piyan nen Apo Shiyos ja dag‐en ni totoo. Amta mi pay ey enshiy moka pabori, angken ngantoy katoo to. ");
INSERT INTO ibl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Isonga iyay i ibaga mi son si‐kam. Maypeshit aya shi dinteg tayon Hodiyos i panbedjad ni bowis so ni gobirnod Roma, ono enshi?” ");
INSERT INTO ibl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nem si Jesus, amta to ey ngaaw i pangkep sha jet kowan to son si‐kara ey, “Si‐kayon sinan maronong! Ngantoy jowaksoka pansaoli? ");
INSERT INTO ibl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipa‐sasi jowak ni pilak ka joka ibayad ni bowis.” Inpa‐sas sha son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","jet kowan to son si‐kara ey, “Sipay makadopa niyay ya naymalked ja pilak? Tan sipay makangaran niya naysolat?” ");
INSERT INTO ibl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Simongbat ira ja kowan sha son si‐kato ey, “Sota ari shi Roma.” Jet kowan ma nen Jesus son si‐kara ey, “No kasta, sota pilak ja joka osala, edapod gobirno ni Roma, isonga mesepol met laeng nga pa‐odiyo son si‐kara. Sota kowan ni gobirno ey may‐ekan son si‐kara, mesepol la maytongpal, jet sota kowan ngo nen Apo Shiyos ey may‐ekan son si‐kato, mesepol ngon mepati.” ");
INSERT INTO ibl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nem idi intenengan sha iyay ya songbat to son si‐kara, ireka messhaaw jet indekjas sha si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nontan met laeng nga akew, dimaw ira di sota Sadosiyo. Say pamatira, kowan sha ey eg kono manbiyag mowan i etey, isonga inparas shen inbag‐an si Jesus, ");
INSERT INTO ibl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ja kowan sha ey, “Maistoro, say insolat nen Moises nonta bayag da ja dinteg tayon Hodiyos, kowan to ey no sota dakin engaseẃa ket metey ja enshiy potot to nodta aseẃa to, sota agi nontan na dakin etey, si‐katoy mengelbat nonta istay aseẃa to say balang nem ẃaray enaken sha. Jet sota anak sha, maybidang ey singa potot nonta etey den agi to. ");
INSERT INTO ibl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iyay i piyan min ibaga. Nontan da kono, ẃaray piton san‐a‐aki shima kad‐an mi, jet sota pangodowan, engaseẃa nem etey ya enshiy to inpotot. Inelbat nonta maykadẃen agi to, ");
INSERT INTO ibl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","nem etey mowan kono sotan na daki. Nan‐i‐inelbat ira sotan na san‐a‐aki ma ja engaseẃa nontan na bii, ingkato nodta maykepito. ");
INSERT INTO ibl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jet shi ka‐onoran, etey kono ngo sota bii. ");
INSERT INTO ibl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sajay i piyan min ibaga son si‐kam, ta no bilang ey onsabi ali sota timpon pan‐ongal ira ni nanketey, sipa emoy koston maka‐aseẃa ali so nontan na bii? Ta nan‐i‐inelbat met ira sota piton san‐a‐aki ja engaseẃa son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Simongbat si Jesus ja kowan to son si‐kara ey, “Esama kayo, ta eg jo ineẃatan sota esel nen Apo Shiyos ja naysolat nonta bayag da, tan eg jo pay amta sota panakabalin to. ");
INSERT INTO ibl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta sota totoon pan‐ongal ali nen Apo Shiyos, eg ma ira mengesawa ta ingesen sha ira sota anghil. ");
INSERT INTO ibl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nem sigosho eg jo pati‐en ey manbiyag mowan i nanketey. Apay eg jo aya binasa sota kowan nen Apo Shiyos son si‐kayo ja naysolat nonta bayag da ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Si‐kak si Apo Shiyos ja Shiyos shi Abraham, Isaac, tan si Jacob!’ Say olog niyay, angken etey mangon bayag i bakdang shi Abraham, kowan nen Apo Shiyos ey mabiday ired sango‐an to. Ta no enshi koma, istay eg to inkowan ey si‐katoy Shiyos sha.” ");
INSERT INTO ibl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Idi intenengan ira nonta totoo iyay ya inkowan nen Jesus, ireka messhaaw nontan na toro to. ");
INSERT INTO ibl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nem idi inon‐an ira nonta Parisiyo ey na‐abak ira sota Sadosiyo ja enshiy isongbat sha ma so nen Jesus, nay‐eshom ira di. ");
INSERT INTO ibl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jet ẃaray sakey son si‐kara ja nan‐ashal ni dinteg ja nansalodsod so nen Jesus, say balang nem ẃaray apil la ikowan nen Jesus ja pebesolan sha so. Jet kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maistoro, towa nodta bilin nen Apo Shiyos i kapatkan so ni emin?” ");
INSERT INTO ibl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Si Jesus, simongbat ja kowan to ey, “Say kapatkan so ni emin na bilin, sajay: ‘Si Apo Shiyos i topogen mon sesmeken, ja si‐katoy pengitoshongan mo ni emin na nemnem mo tan posom.’ ");
INSERT INTO ibl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sajay i kapatkan na bilin ja mesepol la pasiya ja onoren. ");
INSERT INTO ibl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jet sota maykadẃa ja bilin, kait to met laeng, isonga kowan to ey, ‘Semek moy kait mon too ja inges toy moka penmek ni bakdang mo.’ ");
INSERT INTO ibl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sota emin na bilin ja naysolat nonta bayag da, tan sota kowan ira ni para padto nen Apo Shiyos, minongsan niya showen bilin ja si‐katoy singa naynadnaran to.” ");
INSERT INTO ibl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jet idi inon‐an ton esa‐nop ira di sota Parisiyo, inshingan ton nansalodsod ngo son si‐kara, ");
INSERT INTO ibl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ja kowan to ey, “Ngantoy joka pengi‐odog nonta kowan ni padto nonta bayag da maypangkep nonta inkari nen Apo Shiyos ey ibetkag to ali ja mengisedakan? Sipay makapoli son si‐kato?” Simongbat ira son si‐kato ja kowan sha ey, “Poli ali kono nen Ari David nonta bayag da.” ");
INSERT INTO ibl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kowan mowan nen Jesus son si‐kara ey, “No kasta, apay ngarod nga inkowan nen Ari David nonta bayag da ey sota naypadton mengisedakan ket apo to? Intorong met ni Ispirito Santo si David nonta engikowanan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Si Apo Shiyos, inkowan to so nonta pangolok ey ontongaw si‐kato shi apit ni kanawan to, ingkatod enshiy mebedin nonta kabakal to ja ẃara ma ired shalokap ni shapan to.’ ");
INSERT INTO ibl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jet no kowan nen Ari David ey pangolo to sota mengisedakan, toway inpasing to ja kowan jo ey poli ali nen Ari David?” ");
INSERT INTO ibl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jet angken sakey son si‐kara, enshiy makabaal la onsongbat son si‐kato. Jet manipod ma nontan na akew, polos malen eg sha intoled ja nansalodsod son si‐kato, ta ineẃatan sha ey eg sha kabaalan na ebaken. ");
INSERT INTO ibl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jet si Jesus, kowan to so nonta ira totoo ja naydaokan ni too to ey, ");
INSERT INTO ibl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sota ira mamaistoro ni dinteg tan sota ira Parisiyo, si‐karay naysaad ja mengi‐odog nonta dinteg ja in‐akan nen Moises nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Isonga sota kowan sha, si‐kato komay onoren jon pati‐en. Nem karejo onoran sota ogadira. Ta sotan na toro shen mismo, eg sha kari met laeng tongpalen. ");
INSERT INTO ibl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Shaka ida‐kariy too ni embel‐at ta bilin shen eg sha iposi. May‐eshig ey shaka ira bel‐ati ni kalka ja eg sha iposi, nem si‐karen mismo ket eg sha pay peshasen na angken sakey ya kalomot shay mandi‐bit. ");
INSERT INTO ibl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Emin na shaka dagdag‐a, piyan shen asen ni totoo say i‐etek sha ira. Singa agpayson epateg i pamatira son Apo Shiyos, ta ẃaray shaka itaktakin ni olay ja papil la naysolatan ni esel nen Apo Shiyos, nem shaka peba‐deg say on‐an ni totoo. Tan shaka arti‐i i kajaran ni baro sha say ikowan ni too ey sota bilin nen Apo Shiyos noman i pipiyan sha. ");
INSERT INTO ibl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jet no timpo ni piyasta, pipiyan sha pay ja ontongaw shima naysaganen tongawan say mebigbig ira, tan angken pay shima sa‐nopan, sotan i shaka pesing. ");
INSERT INTO ibl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pipiyan sha pay ya rispito‐en ni totoo ira ja semsemano‐an shima malkaro ja karakdan ni too, tan pipiyan shen eẃagan ira ni too ni ‘Maistoro’. ");
INSERT INTO ibl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nem si‐kayo, karejo itolok ja ‘Maistoro’ i awag sha son si‐kayo, ta sakey bengat i maistoro jo, tan sakey pay, san‐a‐aki kayo shi pamati. ");
INSERT INTO ibl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jet angken sipen too shiya dobong, enshi komay jo eẃagan ey amejo shi pamati ta sakey bengat i Amejod pamati, jet si‐kato, ẃared dangit. ");
INSERT INTO ibl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Karejo itolok ja ikowan ni too son si‐kayo ey apo shakejo, ta sakey bengat i apo jo: si‐kato si Cristo. ");
INSERT INTO ibl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Jet sota kangeto‐an son si‐kayo, si‐kato et ngo mowan i mansilbi son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sota mengingeto shorog ni bakdang to, maybeba et ngo mowan. Jet sota mengibeba ni bakdang to, si‐katoy mayngeto. ");
INSERT INTO ibl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nem kaasi kayo din mamaistoro ni dinteg, tan si‐kayon Parisiyo! Sinan maronong kayon too! Say keshosa‐an jo, si‐kayoy singa emengipeshit ni kait jon too ja mayda‐kam shi pantoshayan nen Apo Shiyos. Jet angken si‐kayon mismo, eg jo kosto. May‐eshig ey si‐kayoy mengilkeb ni sakepan ni pantoshayan nen Apo Shiyos so nonta ira makapiyan na onsekep koma. ");
INSERT INTO ibl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kakaasi kayo di, si‐kayon mamaistoro ni dinteg tan si‐kayon Parisiyo, ta sinan maronong kayo! Manpa‐otang kayo mango ira nonta bibiin nankebalo; jet no enshiy ibayad sha, piditen jon angken sota baley sha i ibayad sha. Jet no ondaw kayod sa‐nopan, say joka pesing nga mena‐din ni kakedsel jo, joka ishokey i shawat jo son Apo Shiyos, say ikowan ni too ey maronong kayo. Jet sotan i keshosa‐an jo ni ebadeg. ");
INSERT INTO ibl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kakaasi kayo di, si‐kayon mamaistoro ni dinteg tan si‐kayon Parisiyo! Sinan maronong kayo! Kaasi kayo di, ta epaladoy joka pesing: kayoka man‐eka‐ekad shi intiron dobong ja mengeẃis ni angken sakey ya too, nem no na‐awis ja too jo mala, joka panbedin ni mas makedsel nem say si‐kayo, isonga anam ton mandesin i shosa to shi impiyarno ey si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakaasi kayo di, ta si‐kayoy may‐eshig ey ekorab ba emengiredan ni kait ton ekorab. Say kowan jo, no sota Timplo i pansangba‐an ni too, enshiy silbi to, nem no sota balitok shima Timplo i pansangba‐an to, mesepol la tongpalen to sotan. ");
INSERT INTO ibl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Singa ekorab kayo mowan ta eg jo amten mengilesin ni mapteng. Toway epatpateg — sota balitok, ono sota Timplo? Sota balitok, no enshid ma Timplo, balitok bengat; sota Timploy engi‐kan ni pateg nontan ja pasiya, ta ẃara nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jet say kowan jo pay, no sota ẃared Timplo ja kowan sha ey altar i pansangba‐an ni too, enshiy silbi to. Nem no sota too ket mansangba so nonta ẃared ma altar ja naydaton, mesepol la tongpalen to sotan. ");
INSERT INTO ibl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Singa ekorab kayo! Ta say epatpateg, sota altar, aliẃen sota ẃara nodtan ja naydaton. Sota altar met i kabol la kapatkan nonta naydaton. ");
INSERT INTO ibl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isonga sota mansangba ja i‐esel to sota altar, sota altar i nankari‐an to, tan sota emin pay ya ẃara nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jet sota mansangba ja i‐esel to sota Timplo, sotan i nankari‐an to, tan angken pay si Apo Shiyos ja may‐eshig ey nanbaley nodtan. ");
INSERT INTO ibl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jet sota mansangba ja i‐esel toy dangit, say nansangba‐an to kari, sota tongawan nen Apo Shiyos, tan angken pay si Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kaasi kayo di, si‐kayon mamaistoro ni dinteg tan si‐kayon Parisiyo, ta sinan maronong kayo! Joka tongtongpala sota bilin na ootik i pateg to, nem joka et ngo mowan ibiyang sota bilin na epateg ga pasiya. Joka idaton so nen Apo Shiyos ja singa bingay to sota maykesampolo nonta emin na apit jo, angken pay sota molejo ja para seng‐ew ni sira. Nem joka diẃayi sota ẃa‐ẃa‐shen piyan nen Apo Shiyos, ta piyan ton mapteng i pesing jo ni kait jon too: piyan ton kaasi‐an jo ira, ja eg jo ira i‐owapan. Sajay ya joka pesing nga mengi‐kan ni singa bingay nen Apo Shiyos, mapteng, nem mesepol la eg jo diẃayan iya ẃa‐ẃa‐shen piyan to. ");
INSERT INTO ibl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Isonga may‐eshig ey joka sekatay imok shi inomen jo, nem sota animal la camel i joka tetdena. Apaw kayon Parisiyo! Singa ekorab kayon emengiredan ni kait ton ekorab! ");
INSERT INTO ibl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kaasi kayo di, si‐kayon mamaistoro ni dinteg, tan si‐kayon Parisiyo, ta sinan maronong kayo! Say itsora ni ogadiyo, singa sota tasa ono malokong ja showal to bengat i eki‐ẃanan, nem sota dikong to, edogit ta pasiya. Sotan i kay‐eshigan jo tep say joka ipa‐sas shi karakdan, singa maronong kayo, nem say joka dagdag‐a, sota penikap ni kokowa ni eshom, tan sota pingit jo bengat i joka nemnemnema. ");
INSERT INTO ibl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Si‐kayon Parisiyo, singa ekorab kayo, ta eg jo idasin sota mapteng. Say pilmiron dag‐en jo koma, dinisiyo nin sota dikong ni tasa ono pingkan, say sota showal ja asen ni too, medinisan ngo. ");
INSERT INTO ibl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kaasi kayo di, si‐kayon mamaistoro ni dinteg tan si‐kayon Parisiyo, ta sinan maronong kayo! Si‐kayo, may‐eshig ey say ogadiyo, singa sota naydiyangan ni toon etey, ja epintolan ni empoti, say mapteng i boya to. Nem shi naydaem to, napno ni ensekig, pati sota pokel ni toon etey. ");
INSERT INTO ibl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sajay i sakey mowan na kay‐eshigan jo, ta singa maronong i kepengidmang ni kait jon too son si‐kayo, nem shi nemnem jo, napno ni o‐owap, tan ngaaw wa pangkep. ");
INSERT INTO ibl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kaasi kayo di, si‐kayon mamaistoro ni dinteg tan si‐kayon Parisiyo, ta sinan maronong kayo! Si‐kayo i nandaga ni monyominto ira nonta para padto nonta bayag da, jet inalkosan jo pay sota naybeka‐an ira nonta eshom ma too nen Apo Shiyos nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jet say kowan jo pay, ‘No ẃara kami koma nonta timpo nen apo mi, araẃin kami may‐a‐shom son si‐kara ja memono ira nonta para padto nen Apo Shiyos.’ ");
INSERT INTO ibl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sajay den inkowan jo, si‐kayo met laeng i kaonpaneknek so ey annak shakejo nonta emono so ira nonta para padto, jet tineẃid jo may ogadira ngo. ");
INSERT INTO ibl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eti, itodoy jon dag‐en ja kekshengen sota dingka ira nonta apo jo la! ");
INSERT INTO ibl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Si‐kayo, singa oleg i ogadiyo! Isonga eg mebedin na disi‐an jon meshosa shi impiyarno! ");
INSERT INTO ibl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jet niman, mengibetkagak da ngo son si‐kayo ni toon mengikowan ni esel nen Apo Shiyos, tan mengibetkagak ni eshom ma toon edaing nga mantosho ja ondaw son si‐kayo. Nem bono‐en jo ira sota eshom ja idansa shi koros, jet sota eshom son si‐kara, sepsepdaten jo ira shima sa‐nopan jo. Jet emin sota mebay‐an ja eg jo bono‐en, osilen jo pay ira shi ka‐ili‐ili. ");
INSERT INTO ibl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isonga meshosa kayo di ja ikaro jo sota inkabono ira nonta emin na maronong nga too ja naybokbok i shalesha shi intiron dobong manshoki so nen Abel ja mapteng nga too, ingkato so nen Sakarias ja anak nen Barakias, ja binono ni too nonta bayag da ja kait jon Hodiyos shima naydaem ni Timplo, ja nay‐esop shima kowan sha ey altar. ");
INSERT INTO ibl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ikowan ko son si‐kayo ey emin iyay ya dingdingka ni apo jo nontan da, si‐kayon too niman i mengikesho. ");
INSERT INTO ibl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Si‐kayon tood Jerusalem! Manshoki nonta bayag da ingkato niman, joka bono‐a ni olay ja kespigan ni bato iray inbetkag nen Apo Shiyos son si‐kayo, pati sota ira para padto. Ara! Piga mangoy pesing ko son si‐kayo! Eminshakel la piyan kon i‐okong takejon i‐Jerusalem ja inges to sota kepengi‐okong ni manok ira ni kipkip to. Nem en‐asneng kayo! ");
INSERT INTO ibl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Niman ma, olay to kayo ngo, tep enshis Apo Shiyos shi Timployo ja mengibediw son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jet ikowan ko ey si‐kayon i‐Jerusalem, ẃaray timpon imotok ko son si‐kayo ja asen jowak et ikowan jo ey ‘Bindisiyonan koma nen Apo Shiyos iya toon inbetkag to di!’ ” ");
INSERT INTO ibl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Si Jesus, bimo‐day nodta Timplo jet nan‐akad ja idekjas to koma sota Timplo. Nem sota ira too to, dimaw ira di son si‐kato, jet intoro sha sota itsora ni ekalkalasin baley nodta kad‐an ni Timplo. ");
INSERT INTO ibl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nem si Jesus, simongbat son si‐kara ja kowan to ey, “Owen, bisnayo niman. Tep ikowan ko son si‐kayo ey ẃara aliy timpon onsabi ja sajay ya Timplon joka i‐et‐etek ey mapteng, mesheshal, jet angken sakey so ira nima baton mapteng i inkay‐amag to, enshiy en mebay‐an shima nay‐amagan to; mesheshal la emin.” ");
INSERT INTO ibl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Idi pinsak ja ẃares Jesus ja timongaw shima shontog ja kowan sha ey Olibas, jet dimaw ira di sota too to ni abos sha, jet kowan sha son si‐kato ey, “Piyan min amta‐an no pigan ali ita kowan mo. Jet nganto pay i amta‐an mi so nem pigan aliy idaw mo mowan ja mo pengisaad ni pantoshayan mo? Tan nganto pay i amta‐an mi so ey shanshanin mantepos i dobong?” ");
INSERT INTO ibl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Simongbat si Jesus ja kowan to son si‐kara ey, “Nemnemnemen jo koma iyay. Karekayo pa‐olbod so ni angken sipa, ");
INSERT INTO ibl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ta eshakel aliy toon mengosal ni ngaran ko, ja ikowan sha ey si‐kara si Cristo, jet eshakel noman i toon may‐owapan. ");
INSERT INTO ibl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jet ẃara pay i mismon mankokobat ja itenengan jo, tan ẃaray shemagen jon kobat shi eshom ma ili. Nem karekayo meshanagan. Tep kenshat ta mepesamak ira jay, nem aliẃen sotan i ka‐amta‐an to ey shanshani may pantepos ni dobong. ");
INSERT INTO ibl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Angken ili tan ili, mankobat ira, jet angken pay sota ka‐ili‐ilin intorayan ni a‐ashi, mankokobat ngo ira. Wara pay i epaladon bitil tan jegjeg shi kedogadogad. ");
INSERT INTO ibl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nem emin iyay ya mepesamak, sajay i panshoki‐an bengat ni digat. ");
INSERT INTO ibl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Jet si‐kayo, i‐awat shakejo shi toray jet pedigaten shakejo asan shakejo bono‐a. Karakdan ni tood ka‐ili‐ili, okesen shakejo maypangkep ni joka pemati son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jet eshakel ma i took ja mengi‐ibjag ni pamatira tan mengibaag ni kait sha so ni makakontra son si‐kara, tan asdeg to so ni took ja emati i mankokontra. ");
INSERT INTO ibl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wara pay iray ondaw ali ja kowan sha ey para padto ira nen Apo Shiyos, nem o‐owap kariy toro sha, jet eshakel noman i on‐onod son si‐kara ja may‐owapan. ");
INSERT INTO ibl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jet sajay alin timpon onmotok, mema‐ma may ogadi ni toon ngaaw, jet nakol ni ẃa‐ẃa‐sha so ira nonta took i ootik may semek sha so ni kait sha. ");
INSERT INTO ibl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nem sota mengitoded niyay ya digat ingkatod meksheng, si‐katoy maysedakan. ");
INSERT INTO ibl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Jet sota mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos, maypedawag nin shi intiron dobong, say amta‐an ni emin na tood ja ka‐ili‐ili, asan kesabi may pantepos ni dobong. ");
INSERT INTO ibl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Jet on‐an jon mepesamak sota inpadto nen Daniel nonta bayag da, ja ‘kataktakot alin ondogit’. Jet isaad toy toray to nodta Timplo. (Sota memasa niyay, eẃatan to komay kaytoshongan niya kowan nen Jesus.) ");
INSERT INTO ibl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","No on‐an jo iyay, say pesing sha koma nonta ira ẃared Jodia ket onbetik ira et ja manbakwit shi shonshontog. ");
INSERT INTO ibl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sota toon maytompong nga man‐adibay shi bo‐dayan, eg to koma nemnemen ja onsekep shima baley to ja en mengeda nonta kompormin ẃara nodta naydaem ni baley. ");
INSERT INTO ibl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kasta met sota ẃared payew, eg koma mesiẃat ni aleto nonta insepa ton baro to. ");
INSERT INTO ibl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sajay alin mepesamak, kakaasi ira din pasiya sota bibiin malokon, tan sota bibiin ẃaray anak shen emenoso. ");
INSERT INTO ibl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ireẃat jo son Apo Shiyos ey eg koma mepesamak iyay ni timpon powek, ono timpo ni akew ni ngilin, say mariẃes i pemtik jo. ");
INSERT INTO ibl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta sotan alin digat ja onsabi, enshiy to kay‐ingesan nodta ira digat ja epaspasemak, manipod nonta epalsowa iya dobong ingkato niman. Jet sajay ya digat ja mepesamak, enshiy kay‐ingesan to di. ");
INSERT INTO ibl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No eg ninemnem nen Apo Shiyos ey tikeyen to iyay alin digat, istay angken sipen too, enshiy mebay‐an na mebiyag. Nem si Apo Shiyos, tikeyen to iyay ya digat ta toka isakit ira sota too ton pinidi to. ");
INSERT INTO ibl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sotan alin akew, no ẃaray mengikowan son si‐kayo ey amtaray kad‐an nen Cristo, ja kowan sha ey jo asen, karejo patpati‐en. ");
INSERT INTO ibl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta eshakel aliy toon kowan sha ey si‐kara si Cristo, ono kowan sha ey si‐karay para padto nen Apo Shiyos, jet eshakel i dag‐en shen kaskasshaaw wa aramid ono milagro. Jet no mebedin, kowan sha pay ey i‐owapan sha ira sota too nen Apo Shiyos ja pinidi to. ");
INSERT INTO ibl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Naka pan‐isigod i banshaan son si‐kayo say amta‐en joy mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Isonga no ikowan sha son si‐kayo ey ẃara si Cristo shima dogad ja naybetaw shi ili, karekayo ondaw; ono no ikowan sha ey nan‐emot si Cristo shi naydaem ni baley, karejo kari patpati‐en. ");
INSERT INTO ibl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta say itsora ni idaw ali mowan nonta kowan ni padto ey Anak ni Too, inges toy bagidat ja silẃan to shagos i emin na naykayang. ");
INSERT INTO ibl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“No toway kad‐an ni etey ya bangkay, si‐kato ngoy kesa‐nopan ira ni kaẃang. ");
INSERT INTO ibl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Jet sotan alin timpo ja kekshengan nonta digat, ma‐shep shagos sota niyal ni sekit tan bolan, jet sama talaw, mepedaspas ira, jet sama naykayang, mebediwan i itsora to. ");
INSERT INTO ibl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sajay nin i mepesamak, asan ẃara ma ali sota amta‐an jo so ey emanmotok sota kowan sha ey Anak ni Too ja medepo alid dangit. Jet emin na kilasin too shiya dobong, mandeshingit ira, ta mismon asen sha‐ak ja ma‐odopan ali ni kolpot, tan asen sha pay i itsora ni bakdang kon emenenilin pasiya, tan asen sha ngo sota podnon panakabalin ko. ");
INSERT INTO ibl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jet sotan alin imotok ko, ẃaray makedsang nga janget ni trompita jet ibetkag ko iray anghil ko ja mengolnong ira nonta pinidik ja took shi emin na sakop niya dobong.” ");
INSERT INTO ibl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jet si Jesus, arig mowan i inpasing ton engileẃag nonta idaw to mowan ali, ja kowan to ey, “Nemnem jo kari sota kadasan na kowan sha ey higos. Shiya kad‐an tayo, no asen jon ondongkey sota panga to, asan somimit mowan i bolong to, amtayo ma ey shanshani sota timpo ni petang. ");
INSERT INTO ibl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Inges niyay aliy i‐olik. No asen jon emanketongpal ira ja inkowan ko la, amtayo ma ey sota timpon idaw ko ali, shanshani ma, ja singa ẃara‐ak nodta pasbol. ");
INSERT INTO ibl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Podno iyay ya ikowan ko son si‐kayo. Saja ira too niman, eg ira nin metey, no diket sa‐kopen shen emin ira jay ya mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sama naykayang tan saja dobong, mebedin na ma‐enshi, nem saja esel la inkowan ko, kenshat ta metongpal, ja eg ma‐enshi. ");
INSERT INTO ibl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nem si Apo Shiyos bengat i maka‐amta ni timpo ja ketongpal niyay ya inkowan ko. Angken sama anghil shi dangit, tan si‐kak ja Anak nen Apo Shiyos, eg mi ngo amta. ");
INSERT INTO ibl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Arig to sota timpo nen Noe. Ta sota aramid ni totoo nontan den timpo to, inges to met laeng i aramid ni too ni imotok mowan ali nonta kowan ni para padto nonta bayag da ey Anak ni Too, jet inges to mowan i idibag sha. ");
INSERT INTO ibl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta nonta aneng pay laeng sota dayos, enshiy shaka panshanagi ni inakew: ireka mengan, ireka menginom, ireka man‐a‐asawa — ingkato nonta simabi sota timpon simekep ma si Noe nodta barko to. ");
INSERT INTO ibl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jet sotan iren too, dimibag ira ni insabi ali nonta dayos, jet dinedjos to iren emin. Jet angken ngon sota idaw mowan ali nonta kowan ni para padto ey Anak ni Too, inges niyay ja palibdibag. ");
INSERT INTO ibl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jet sota timpon idaw ko ali, odopen koy eshom ma too, nem sota eshom, bay‐an ko. Et no kaspangarigan sota showen daki ja maytompong ja ẃared payew, sota sakey, may‐odop son si‐kak, nem sota sakey, mebay‐an. ");
INSERT INTO ibl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Angken ngon sota showen biin maytompong nga emengiding, sota sakey may‐odop son si‐kak, nem sota sakey, mebay‐an. ");
INSERT INTO ibl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Pansagana kayo, ta eg jo amta no nganton timpo i idaw ali nen Apo jo. ");
INSERT INTO ibl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sajay i nemnemen jo: say imotok ko ali, kompormin oras ja inges toy kaidaw ali nonta mengibot shi baley. Jet no sota makabaley ket amta to koma no nganton oras ni edabi i idaw ali nonta mengibot, kenshat ta mansekana, eg to itolok ka onsekep sota mengibot shi baley to. ");
INSERT INTO ibl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Isonga angken si‐kayo, mesepol la mansekana kayo, ta si‐kak ja kowan ni para padto ey Anak ni Too, ondawak alin palibdibag.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jet ẃara pay i arig ja inkowan to, ja kowan to ey, “Sota baga‐en ja mepiyal ja amta toy toka dagdag‐a, si‐katoy piyalen nonta apo ton mengimanshal ni kokowa to, tan no timpo ni pengi‐idaw ni balon ira nonta kait ton baga‐en, si‐katoy kaipiyal nen apo to. ");
INSERT INTO ibl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jet no sotan na baga‐en ket maramen eman‐obda ey onmotok ali sota apo to, mapteng i konkona ton i‐akan nonta apo to. ");
INSERT INTO ibl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Agpayso iya ikowan ko son si‐kayo. Sotan na baga‐en, no sebi‐en nen apo ton eman‐obda, si‐katoy piyalen nen apo to ja en mengimanshal nonta emin na kokowa to. ");
INSERT INTO ibl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nem apil i pesing to so nonta sakey ya baga‐en ja maledamsis, ja makakowan ey, ‘Angkena, ta sota apok, metaktak alin onmotok’, ");
INSERT INTO ibl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","isonga ishogi ton sepsepdaten ira sota kait ton baga‐en, tan mesiẃat ja mekiladdadsak so nonta ira nankeboteng. ");
INSERT INTO ibl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kakaasi sotan na baga‐en, ta sota apo to, on‐oli alin palibdibag, jet ondibag sota baga‐en tep eg to amta sotan na i‐oli ali nonta apo to. ");
INSERT INTO ibl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jet sotan na baga‐en, pekishosa to so nonta ira kait ton o‐owap i shaka pansilbi. Jet shiman, mannengnengis i totoo tan panngedetnget sha i sangi sha ni digat sha.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","In‐arig pay nen Jesus i timpon idaw to ali, ja kowan to ey, “Say arig ni pesing nen Apo Shiyos shi pantoshayan to, sajay ya istoriya. Wara konoy sampolon memeshikit ja engita‐jon ni kingkira ja sha seskeshen sota dakin mengesawa, say mekidaw ira son si‐kato shi kasal. ");
INSERT INTO ibl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sota dima so nonta ira memeshikit, ẃaray nemnem sha, isonga nansagana ira; nem sota dima, enshi. ");
INSERT INTO ibl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Sota ira nansagana, engita‐jon ira ni silew shen kingki jet engita‐jon ngo pay ira ni maykalka nodtan say eg ma‐shep. Nem sota eg nansagana, engita‐jon bengat ira ni kingkira. ");
INSERT INTO ibl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Idi etaktak sota daki ja eg dimaw alin shagos, jimo‐kew ira sota memeshikit jet na‐ogip ira. ");
INSERT INTO ibl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nem idi kawa ni dabi, ẃaray kimeljaw ja kowan to ey, ‘Bangon kayo! Ma‐ali sota daki! Jo aspol!’ ");
INSERT INTO ibl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jet emin ira sota memeshikit, bimangon ira, jet tinotongan sha sota kingkira. ");
INSERT INTO ibl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sota ira memeshikit ta eg nansagana, kowan sha so nonta ira kait sha ey, ‘Pangi‐kan kayo ka di ni maykalka shiya kingki mi tep emanka‐shep.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nem sota ira memeshikit ta nansagana, kowan sha ey, ‘Enshi, ta baka et ey eg on‐anay iyay ja para son si‐kami no i‐aknan mikejo. Daw kayo et shima kantina jet kayo panongkal ni osalen jo ngo.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nem idi dimaw da iren en menongkal, mimotok ali sota dakin mengesawa, jet sota ira memeshikit ta nansagana, si‐karay ekidaw so nonta daki shima pankasalan to. Jet idi simekep ma ira nodta baley, naydekeb ngo mala sota sakepan. ");
INSERT INTO ibl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Idi naksheng ma iyay, sota ira memeshikit ta eg nansagana, mimotok ngo ma ira di, jet kowan sha ey, ‘Apo! Apo! Ilo‐kati jokami!’ ");
INSERT INTO ibl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nem kowan nonta dakin mengesawa son si‐kara ey, ‘Say agpayso, enshiy biyang ko son si‐kayo.’ ” Sajay i arig ga inkowan nen Jesus jet intoloy ton kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Isonga say kowan ko son si‐kayo, mesepol la esagana kayo ni olay, ta eg jo amta sotan alin akew ja idaw ko di.” ");
INSERT INTO ibl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wara pay i inkowan ton arig say man‐edisto sota ira too to ni eg to pay laeng ali imotok, ja kowan to ey, “Waray sakey ya baknang ja ẃaray daẃan ton nay‐araẃin ili, isonga inpa‐odop to ira di sota baga‐en to jet inpiyal to sota ira kokowa to son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sota sakey, in‐aknan to ni dimen dibo, jet sota maykadẃa, in‐aknan to ni showen dibo, jet sota maykatdo, in‐aknan to ngo ni sandibo, ta say in‐akan to son si‐kara, sota mebedin na kabaalan shen ibiyaki, asan ka‐edaw shi daẃan to. ");
INSERT INTO ibl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jet sota in‐aknan to ni dimen dibo, dimaw wa shagos ja to inbiyaki, jet nandobli sotan na pilak. ");
INSERT INTO ibl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sota showen diboy ineẃat to, to inbiyaki ngo jet nandobli sotan na pilak. ");
INSERT INTO ibl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nem sota sandiboy ineẃat to, to in‐emot ja inbeka sotan na pilak ni apo to. ");
INSERT INTO ibl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Idi edabas day ebayag ga timpo, sota apo ira nonta baga‐en, mimotok ali jet to tinonton sota pilak ja inpiyal to so nonta ira baga‐en to. ");
INSERT INTO ibl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jet sota in‐awatan to so ni dimen dibo, dimaw ali ja inta‐jon to sota dimen dibo ja inbiyaki‐an to, jet kowan to so nonta apo to ey, ‘Apo, sota dimen dibo ja in‐awat mo son si‐kak, nak inbiyaki jet nandobli.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jet sota apo to, kowan to ey, ‘Siya, mapteng i dingkam; mebedin ken mepiyal la baga‐en ko. Kaka mepiyal la mengimanshal ni otik ka banag, isonga niman, ebadeg i ipiyal ko son si‐kam ma imanshal mo. Kala, mayda‐kam ka ja meki‐imdeng son si‐kak shi baley ko.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jet sota showen dibo i ineẃat to, dimaw ngo ali, jet kowan to son apo to ey, ‘Apo, sota in‐awat mo son si‐kak ja showen dibo, nak inbiyaki jet nandobli.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jet kowan nonta apo to ey, ‘Siya, mapteng i dingkam; mebedin ken mepiyal la baga‐en ko. Kaka mepiyal la mengimanshal ni otik ka banag, isonga niman, ebadeg i ipiyal ko son si‐kam ja imanshal mo. Kala, mayda‐kam ka ja meki‐imdeng son si‐kak shi baley ko.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sota sandibo ngoy ineẃat to, dimaw ngo ali jet kowan to son apo to ey, ‘Apo, amtak ey si‐kam ket palado ken too, ta angken sota aliẃen molam, moka pan‐epita, jet angken sota in‐obda‐an ni eshom, moka pay kepan‐al‐a. ");
INSERT INTO ibl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Isonga etakotak jet nak inbeka ja in‐emot sota pilak ka inpiyal mo son si‐kak. Iyay, jet alam ta kokowam.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nem sota apo to, sinongbatan to ja kowan to ey, ‘Si‐kam, enshiy am‐amtam, esarot ka! Amtam met gayam ey naka pan‐epita i angken aliẃen molak, tan naka pan‐al‐a i in‐obda‐an ni eshom. ");
INSERT INTO ibl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jet apay nga eg mo inbangko itan na pilak, say niman alin inmotok ko, ẃaray eẃaten kon patang to? ");
INSERT INTO ibl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Alejo ita pilak ka inpiyal ko son si‐kato, jet i‐kan jo so nonta toon kawad‐an ni dimen dibo! ");
INSERT INTO ibl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta sota ira ẃa‐ẃa‐sha‐anan, may‐aknan pay, say eshakel la pasiya i si‐kato. Nem sota ootik anan, angken sota oltimon ẃara son si‐kato, ma‐da pay. ");
INSERT INTO ibl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jet sotan na baga‐en ja enshiy silbi to, iteknal jo shima embolinget, jet shiman, mannengnengis i totoo, tan panngedetnget shay sangi sha ni digat sha!’ ” Sajay i arig ga inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kowan to pay ey, “Sota timpon idaw mowan ali nonta kowan ni para padto ey Anak ni Too, ondaw ali ja inges tos Apo Shiyos. Emin sota anghil, may‐odop ali son si‐kato, jet isaad toy pantoshay to ja enshiy to kay‐ingesan. ");
INSERT INTO ibl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sotan alin timpo, emin na totood ka‐ili‐ili, mesa‐nop ired sango‐an to, jet pandinasin to ira, ja inges toy kepesing nonta emanbantay ni kalniro, ja toka idasin ira sota kanshing so nonta ira kalniro to. ");
INSERT INTO ibl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jet say pesing nonta kowan ni para padto ey Anak ni Too, isingpet ton ipiig sota kalniro to shima petek ni kanawan to, nem sota kanshing, ibiyang ton idasin shima petek ni kanigid to. ");
INSERT INTO ibl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jet sota ari, ikowan to so nonta ira insingpet ton ẃara nodta petek ni kanawan to ey, ‘Kalejo, si‐kayon kinaasi‐an nen Amak! Si‐kayoy mayda‐kam ja mekiteẃid shima pantoshayan nen Apo Shiyos; naysagana ngo eshan para son si‐kayo nonta eg pay laeng epalsowa iya dobong. ");
INSERT INTO ibl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaasi‐an tokejo, ta nonta naka man‐ekang, pinekan jowak, tan nonta na‐keẃak ni shanom, inpan‐inom jowak; nonta dimawak shi ili jo ja enshiy amtak ja pan‐iyanan ko, sinintil jowak; ");
INSERT INTO ibl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","jet nonta enshiy barok, binesho‐an jowak; nonta nansakitak, jowak binisita, asan nonta naybaloshak, jowak inon‐an.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jet sotan iren ineẃat ni ari, onsongbat ira ja kowan sha son si‐kato ey, ‘Apo, enshi met i amta min mi dingka so ira niya kowan mo ey pinekan mika nonta na‐agang ka, ono inpan‐inom mika nonta na‐kew ka ni shanom. ");
INSERT INTO ibl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Enshi met i amta min misoka sinintilan, ono misoka binesho‐an. ");
INSERT INTO ibl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Enshi met i amta min misoka binisita‐an ni insakit mo ono inkabedod mo.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jet onsongbat sota ari ja kowan to ey, ‘Podno iya ikowan ko son si‐kayo. Sajay den inkowan ko, dingkayo so ira nonta kabeba‐an na kait ko, jet maybidang ey si‐kak i dingka‐an jo so nontan.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jet ikowan nonta ari ngo so nonta ira inbiyang ton ẃared petek ni kanigid to ey, ‘Ki‐nan kayod ja kad‐an ko! Meshosa kayo shima apoy ya shalang to ni olay ingkatod ingka! Sajay i naysagana para so nen Satanas, pati sota ira betkag ton anghil. ");
INSERT INTO ibl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sajay i pesing ko ta eg jowak kinaasi‐an. Nonta naka man‐ekang eg jowak pinekan, nonta na‐keẃak ni shanom eg jowak inpan‐inom, ");
INSERT INTO ibl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nonta dimawak shi ili jo, ja enshiy amtak ja nak pan‐iyanan eg jowak sinintil, nonta enshiy barok eg jowak binesho‐an, nonta naka mansekit tan nonta naybaloshak, eg jowak binisita.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jet onsongbat ngo ira ja kowan sha ey, ‘Apo, enshi met i amta min mi so in‐owayan son si‐kam ni inka‐akang mo, ono inka‐kew mo ni shanom, ono sota kowan mo ey enshiy amtam ma pan‐iyanan mo, ono enshiy barom, ono insakit mo, ono inkabedod mo!’ ");
INSERT INTO ibl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jet songbatan to ngo ira ja kowan to ey, ‘Agpayso iya ikowan ko son si‐kayo. Sota eg jo so insintil so ira niya kabeba‐an na kait ko, maybidang ey si‐kak i eg jo sinintil.’ ");
INSERT INTO ibl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jet sajay ira, meshosa ira shima shosa‐an ingkatod ingka. Nem sota ira ineẃat to, may‐aknan ira ni biyag ja enshiy to engintegan.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Idi enaksheng nga inkowan nen Jesus iyay ya emin, ẃaray inkowan to so nonta ira too to, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Amtayo, no ondabas i showen akew, medeka sota piyasta tayon Hodiyos ja kowan tayo ey Paskowa, jet si‐kak ja kowan ni para padto ey Anak ni Too, may‐eẃatak so ni toray say maydansa shi koros.” ");
INSERT INTO ibl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jet nontan met laeng nga akew, sota ira apo ni papashi, tan sota ira pangolo ni Hodiyos, esa‐nop ira shima ebadeg ga baley nonta kangeto‐an na pari, ja si Kaypas. ");
INSERT INTO ibl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jet nantatabal ira no ngantoy pesing shen memono son Jesus, jet ninemnem sha ey olboren sha kono say ma‐shel et mebono. ");
INSERT INTO ibl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nem say kowan sha, “Aliẃen tayo itompong no timpon piyasta, ta baka et ey mankodo ira sota eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jet nontan na akew, ẃares Jesus shi Bitania, shima baley nen Simon ja istay ebaybayang i bakdang to. ");
INSERT INTO ibl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wara ngoy biin dimaw ali son si‐kato nodtan na baley, ja engita‐jon ni palit ta danen emanseng‐ew, ja nay‐iyan shi botilja. Jet insho‐jag to iyay shi toktok nen Jesus nonta maramen emengan si Jesus nodta damisaan. ");
INSERT INTO ibl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nem idi inon‐an ira nonta too to, ireka mankotot ja kowan sha ey, “Ngantoy inpakeẃasan to so emo nima dana? ");
INSERT INTO ibl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","No istay indako to koma sotan na dana, istay asdeg to komay tongkal to jet mebedin na may‐ekan so ni nankebiteg.” ");
INSERT INTO ibl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nem si Jesus, amta toy ẃared nemnem sha jet kowan to ey, “Baybay‐iyo ita bii; karejo bedawen. Ta mapteng ita dingka to son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sota ira nankebiteg, ẃara ni olay son si‐kayo, isonga mebedin na todongan jo; nem si‐kak, eg mebedjag i pekikadẃak son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jet saja dana ja insho‐jag to son si‐kak, singa toka pan‐isagana i kaybebka niya bakdang ko. ");
INSERT INTO ibl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jet agpayso iya ikowan ko son si‐kayo. Shiya intiron dobong, no maytosho sota mapteng nga shamag maypangkep son si‐kak, sajay ya dingka niyay ya bii, pekipedawag sha jet eg medibdibkan.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sota sakey so nonta sampolo tan showen apostol nen Jesus, ja si Judas Iskariote i ngaran to, dimaw so nonta ira apo ni papashi ni Hodiyos, ");
INSERT INTO ibl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jet kowan to son si‐kara ey, “Ngarantoy i‐akan jo son si‐kak no itorok son si‐kayo i kad‐an nen Jesus?” Jet binayshan sha ni tedon polon palata. ");
INSERT INTO ibl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jet nontan ma, ẃara ni olay shi nemnem nen Judas Iskariote no toway pesing ton mengibaag so nen Jesus son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Idi shimanon sota pilmiron akew ni piyasta, ja shaka pengan nonta tinapay ya enshiy daok ton para debag, dimaw ira di sota apostol nen Jesus son si‐kato, jet kowan sha ey, “Toway piyan mon mi pansekana‐an ni penganan mo nem ma‐shem, tep Paskowa ma?” ");
INSERT INTO ibl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Simongbat si Jesus ja kowan to son si‐kara ey, “Daw kayo so nen iman na polano shi Jerusalem jet no sebi‐en jo, ikowan jo son si‐kato ey, ‘Kowan ali nen Maistoro ey mengan konod ja baley mo niman na piyasta, pati si‐kamin too to, tep shanshani kono sota timpo to.’ ” ");
INSERT INTO ibl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jet sota ira too to, pinatira sota kowan nen Jesus jet dimaw ira ja sha insagana sota kenen sha ni mama‐shem nontan na Paskowa. ");
INSERT INTO ibl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Idi mama‐shem mala, si Jesus tan sota sampolo tan showen apostol to, dimaw iren mengan nodtan, jet nansasango ired damisaan. ");
INSERT INTO ibl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Idi maramen ireka emengan, kowan nen Jesus ey, “Agpayso iya ikowan ko son si‐kayo. Waray sakey son si‐kayo ja mengibaag son si‐kak so nonta ira makakontra son si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jet sota ira too to, ensakit ta pasiya i nemnem sha, jet kowan ni sakey tan sakey son si‐kato ey, “Sipa apo? Aliẃen si‐kak emo?” ");
INSERT INTO ibl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Simongbat si Jesus ja kowan to ey, “Sota nay‐okob son si‐kak shi sakey ya pingkan, si‐katoy mengibaag son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Si‐kak sota kowan ni para padto ey Anak ni Too jet kenshat ta metongpal sota padto ja naysolat nonta bayag da ni maypangkep son si‐kak. Nem kaasi met laeng sotan na toon mengibaag son si‐kak, ta meshosen pasiya! No da‐kaman to sotan na shosa, ikowan to shorog shi bakdang to ey, ‘Agpos et nem ekak koma nay‐anak!’ ” ");
INSERT INTO ibl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jet si Judas Iskariote ja mengibaag ali so nen Jesus, kowan to ey, “Sipa apo? Aliẃen si‐kak emo?” Jet si Jesus, simongbat ja kowan to ey, “Siya, si‐kam. Si‐katoy inkowan mo.” ");
INSERT INTO ibl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nontan na maramen ireka ma emengan, inda nen Jesus sota tinapay et nan‐iyaman son Apo Shiyos, asan toka showashowa‐a. Jet in‐akan to nodta ira apostol to, ja kowan to ey, “Iya, kan jo iyay. Sajay i bakdang ko.” ");
INSERT INTO ibl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jet idi naksheng, inda to sota tasa et nan‐iyaman son Apo Shiyos, asan toka i‐kan mowan son si‐kara, ja kowan to ey, “Pan‐i‐inelbati jon inomen. ");
INSERT INTO ibl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta sajay i shalak ja on‐ayos ja pansigshan ni eshakel la totoo. Ta sota ketey ko di, si‐katoy kepekawanan ni basol ni totoo, tan si‐katoy panshoki‐an nonta badon bilin nen Apo Shiyos so ni totoo. ");
INSERT INTO ibl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iyay i ikowan ko son si‐kayo. Sajay i ka‐onoran na penginom ko ni shanom niya obas, jet ekak nin menginom ingkatod onsabi sota penginom ko nonta badon shanom ni obas shima pantoshayan nen Apo Shiyos ja Amak; jet meki‐inom kayo ngo.” ");
INSERT INTO ibl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nankansiyon ira ni maypangkep ni panshedjaw sha son Apo Shiyos, jet idi naksheng, bimo‐day ira nodtan na baley jet dimaw ired ma shontog ga kowan sha ey Olibas. ");
INSERT INTO ibl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jet si Jesus, kowan to so nonta ira too to ey, “Niman na dabi, ibaing jowak ka emin jet onbetik kayo, ta si‐katoy ketongpal nonta padton naysolat nonta bayag da, ja kowan to ey, ‘Bono‐en ko sota para bantay ni kalniro, jet sota eman‐o‐odop ja kalniro, mebodak ira.’ ");
INSERT INTO ibl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nem no meksheng i pan‐ongal ko, mepangdo‐ak ja ondaw shi Galilia ey si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nem si Pedro, kowan to ey, “Angken ibaing shaka ni emin na kait ko, eg taka mango ibaing.” ");
INSERT INTO ibl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Simongbat si Jesus ja kowan to ey, “Podno iya ikowan ko son si‐kam Pedro: niman na dabi, isaot mowak ni memintedo ja ikowan mo ey eg mowak am‐amta. Jet no meksheng iyay, ẃara ngoy ontekok ja kawitan.” ");
INSERT INTO ibl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nem si Pedro, kowan to ey, “Angken na pekibono sha‐ak son si‐kam, ekak ikowan ey eg taka am‐amta!” Jet sota ira kait to, sotan ngoy inonoran shen inkowan. ");
INSERT INTO ibl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jet si Jesus, inodop to sota ira apostol to shima dogad ja kowan sha ey Gitsimani jet kowan to son si‐kara ey, “Tongaw kayod jay, ta ondawak shima a‐adaw ja nak nin mansheẃat son Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inodop tos Pedro tan sota showen anak nen Sibidi, jet nontan ma, emankaikelkel‐eẃi. ");
INSERT INTO ibl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jet kowan to son si‐kara ey, “Singa meteyak ni daringit ko! Shiyay kayo nin, eg kito ma‐okip.” ");
INSERT INTO ibl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Idi naksheng nga inkowan to iyay, bintawan to ira ni ootik, jet nanshomog ja nanshawat son Apo Shiyos, ja kowan to ey, “Ama, no mebedin koma, karam ipalobos iyay ya pandikat ko di. Nem say kowan ko, sota piyan mo, si‐katoy metongpal; aliẃen sota kostok.” ");
INSERT INTO ibl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Idi imekẃas, dimaw ja to inon‐an sota too to jet simbi to iren na‐ogip. Jet kowan to so nen Pedro ey, “Ngantoy? Na‐ogip kayo. Apay, eg mebedin ja itoled joy jo‐kew jo ni angken sakey ya oras bengat, ja kadẃa‐an jowak? ");
INSERT INTO ibl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Panmolakat kayo jet panshawat kayo ngo so nen Apo Shiyos ni kedsang say eg shakejo ebaken ni ngaaw wa onsabi son si‐kayo. Sota nemnem jo, makedsang niman, nem baka et ey ma‐ebak kayo tep ekapoy i bakdang jon ontongpal nonta ẃared nemnem jo met laeng.” ");
INSERT INTO ibl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jet nonta maykepinshowa, dimaw mowan na en nanshawat son Apo Shiyos et kowan to ey, “Ama, no kenshat ta ipalobos mon mandikatak, i‐onod ko sota piyan mon dag‐en ko!” ");
INSERT INTO ibl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jet nay‐oli mowan ali jet simbi to ira sota too to ja na‐ogip, ta epaladoy jo‐kew sha. ");
INSERT INTO ibl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jet indekjas to mowan ira ja en nanshawat ni maykepintedo, jet iso met laeng i inkowan to ni shawat to son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Idi naksheng, dimaw mowan ali so nonta too to, jet kowan to son si‐kara ey, “Ngantoy? Piyan jon ma‐okip ni olay? Edabas mala sota oras ja pansheẃat jo koma. Simabi ma sota timpo, jet si‐kak ja kowan ni para padto ey Anak ni Too, may‐eẃatak ma so nonta ira toon nankekedsel. ");
INSERT INTO ibl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Eti, ondaw kito. Iyay ma ali sota mengibaag son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Idi maramen eman‐a‐sel si Jesus, si Judas Iskariote ja sakey so nonta ira sampolo tan showa ja apostol nen Jesus, engolop ali ni eshakel la too. Sota eshom, nan‐etak ira, tan sota ira eshom, ẃaray peg‐as sha. Sajay iren too, inbetkag ira nonta apo ni papashi tan pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Si Judas Iskariote, insigod ton inkowan so niya ira inodop to ey, “Say pengimatonan jo son Jesus, ongo‐an ko; jet tengel jo.” ");
INSERT INTO ibl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Isonga dimaw alin shagos si Judas so nen Jesus jet kowan to ey, “Apo, iyay ka gayam shiyay!” Jet inongo‐an to ja singa agpayson ensemek to noman. ");
INSERT INTO ibl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jet si Jesus, kowan to son Judas ey, “Kajem, ita et mangon ẃara ked jay?” Jet sota ira inodop ali nen Judas Iskariote, dimaw ira di jet tinngel shen shagos si Jesus ja a‐shelen sha ma. ");
INSERT INTO ibl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jet nontan, sota sakey so nonta ira too nen Jesus, inokbos ton shagos i kampilan to jet kinimpas toy tangida nonta baga‐en ni kangeto‐an na pari. ");
INSERT INTO ibl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jet si Jesus, kowan to so nonta engimpas ey, “I‐odim ita kampilan mo shita atip to, ta sota mengosal ni kampilan, kampilan met laeng i ipatey to. ");
INSERT INTO ibl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Say kowan mo emo, eg mebedin na mengshawak so nen Amak ni tolong? Say agpayso, no mengshawak son si‐kato, mengibetkag alin shagos ni dinibon anghil. ");
INSERT INTO ibl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nem no sotan i dag‐en ko, eg metongpal sota esel nen Apo Shiyos ja naysolat nonta bayag da ja naypadto. Isonga sajay niman i medeka.” ");
INSERT INTO ibl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jet nontan met laeng, kowan nen Jesus so nonta ira eshakel la totoo ey, “No si‐kak i kowan jo ey a‐shelen jo, apay nga nan‐etak kayo tan ẃaray peg‐as jo? Apay tolisanak? Inakew met ja ẃara‐ak shima Timplo ja emantosho, ket apay nga eg jowak inshel nontan? ");
INSERT INTO ibl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nem mesepol la sajay i medeka ta say metongpal sota insolat ni para padto nonta bayag da.” Kowan nen Jesus. Jet emin ira sota too to, namtik ira jet indekjas shes Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jet si Jesus, indaw sha shi baley nen Kaypas ja kangeto‐an na pari, tep shiman i na‐olnongan ira nonta mamaistoro ni dinteg tan sota ira pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jet si Pedro, tinned to ira nem bimetaw, ingkatod simabi nodta bo‐dayan ni kangeto‐an na pari jet simekep nodtan. Ekitongaw so nonta ira kowadja ta piyan ton asen no ngantoy pesing sha son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nontan, sota ira apo ni papashi tan sota ira esa‐nop pa toray, ireka mengenap ni ikowan shen basol nen Jesus, angken o‐owap koma, say ẃaray kabol la ikowanan sha so ey si‐katoy kebono‐an to. ");
INSERT INTO ibl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nem enshiy shaka sepolen koston basol to. Angken eshakel sota sistigon dimaw ali ja o‐owap i kowan sha, enshiy eki‐det kari. Nem shi ka‐onoran, ẃaray showen dimaw ali, ");
INSERT INTO ibl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jet kowan sha ey, “Sajay ya too, kowan to ey mebedin ton sheshalen kono ima Timplo nen Apo Shiyos jet i‐oli to kono mowan na dag‐en ni tedon akew.” ");
INSERT INTO ibl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jet sota kangeto‐an na pari, dimayat et kowan to son Jesus ey, “Jet enshiy isongbat mo? Sajay met i kowan ira niya too ey basol mo!” ");
INSERT INTO ibl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nem si Jesus, imeg‐eket. Jet sota kangeto‐an na pari, kowan to ey, “Ipodnom no agpayson si‐kam sota Anak nen Apo Shiyos ja inkari to nonta bayag da ey ibetkag to alin mengisedakan! Si Apo Shiyos, ẃara ni olay ingkatod ingka jet si‐katoy pansangba‐an mo!” ");
INSERT INTO ibl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Simongbat si Jesus ja kowan to ey, “Sota inkowan mo, si‐kato. Nem say kowan ko ngo, si‐kak sota kowan ni para padto ey Anak ni Too, jet no ekay ali, ontongaẃak shi apit ni kanawan nen Apo Shiyos ja Manakabalin, jet asen jowak ali mowan ja metaksholan ni kolpot.” ");
INSERT INTO ibl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jet sota kangeto‐an na pari, bini‐nik to sota baro to shorog ni bonget to, jet kowan to ey, “Eg mesepol la ẃara pay i sistigo! Intenengan jo met i inkowan to! Toka pa‐so‐is Apo Shiyos! ");
INSERT INTO ibl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jet ngarantoy piyan jon pesing son si‐kato?” Simongbat sota kait ton toray, ja kowan sha ey, “Anam ton mebono!” ");
INSERT INTO ibl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jet tinopsha‐an shay dopa to. Shinengpel sha, tan ẃara pay aliy eshom ma enedpak son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ja kowan sha ey, “Tiga, si‐kam ma inbebetkag kono nen Apo Shiyos ali, ikowan mo ga no moka idasin met laeng sota enengpel son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nontan met laeng, emantetongaw si Pedro nodta bo‐dayan ni baley nonta kangeto‐an na pari, jet ẃaray biin baga‐en nonta kangeto‐an na pari ja dimaw ali son Pedro, jet kowan to ey, “Angken si‐kam met, eki‐od‐odop ka son Jesus ja i‐Galilia.” ");
INSERT INTO ibl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nem si Pedro, indibak to son si‐karen emin, ja kowan to ey, “Enshiy am‐amtak shita moka pan‐ikowan!” ");
INSERT INTO ibl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jet idi dimaw si Pedro nodta pasbol, ẃara mowan i biin kowan to so nonta ira toon ẃara nodtan ey, “Sajay ya too, eki‐od‐odop met so nen Jesus ja i‐Nasarit!” ");
INSERT INTO ibl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nem insaot nen Pedro mowan ja tinaksholan to ni sangba ja kowan to ey, “Angken pansangba‐an ko, ekak am‐amta itan na too!” ");
INSERT INTO ibl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Idi ekay, sota ira toon ẃara nodtan, dimaw ira di son Pedro jet kowan sha ey, “Ayshiy showashowa! Kenshat ta si‐kam i sakey ya kait to did Galilia! Ma‐imaton shi moka pengibodikas ni esel!” ");
INSERT INTO ibl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nem si Pedro, nansangba mowan ja kowan to ey, “Angken shosa‐en towak nen Apo Shiyos, no o‐owap iyay ya inkowan ko la! Ekak am‐amta itan na too!” Jet nontan, timekok nga agpayso sota kawitan. ");
INSERT INTO ibl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jet idi intenengan nen Pedro, ninemnem to ma sota inkowan nen Jesus ey, “Isaot mowak ni memintedo, ja kowan mo ey eg mowak am‐amta, jet no meksheng, ẃara ngoy ontekok ja kawitan.” Jet si Pedro, dimaw shima powisha ja epaladoy nangis to tep naydaw‐an. ");
INSERT INTO ibl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Idi nonta emankeẃa‐ẃa ma, emin ira sota apo ni papashi tan sota ira pangolo ni Hodiyos, nantatabtabal ira ni pesing shen pebono so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jet say inpasing sha, binedod sha et inpaidaw sha so nen Pilato ja gobinarol. ");
INSERT INTO ibl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jet idi inamta‐an nen Judas Iskariote ey pebonora gayam si Jesus, emanbebawi ta naydaw‐an na pasiya, isonga to in‐oli sota pilak ka tedon polon palata so nonta ira toray ni Hodiyos, ");
INSERT INTO ibl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","jet kowan to ey, “Nanbasolak ka pasiya! Ta inbaag ko sota toon enshiy basol to son si‐kayo jet niman pebonoyo gayam!” Nem kowan sha son si‐kato ey, “Enshiy mi naybiyangan nitan; olay toka ngo.” ");
INSERT INTO ibl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jet inkespig to sota pilak ka palata shima naydaem ni Timplo jet bimo‐day. Jet say inpasing to, dimaw ja en nanposos. ");
INSERT INTO ibl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nem sota ira apo ni papashi, indara sota palata, jet kowan sha ey, “Ngantoy pesing tayo niyay ya pilak? Parit shi dinteg ja may‐a‐shom iyay ya pilak shima tado‐an ni alos, ta sajay, tongkal ni biyag ni too.” ");
INSERT INTO ibl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jet ninemnem sha ey sotan na pilak, itongkal sha nonta bo‐day ya sigod ja kepengeda‐i ni ma‐emag ni banga, jet inpanbalin shen kamposanto ja kaybebka‐an ni bisita shi Jerusalem ja metey shiman. ");
INSERT INTO ibl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Isonga sotan na bo‐day ja intongkalan sha so nonta pilak, inpanngaran ni totoo ma ni “Baley ni shala”, jet ingkato niman, si‐katoy ngaran to. ");
INSERT INTO ibl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sajay i tongpal nonta padto nen Jirimias nonta bayag da, ja kowan to ey, “Say kowan nonta totoshay ni Israel ey koston tongkal nontan na too, tedon polon palata. Jet idi al‐en sha, ");
INSERT INTO ibl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","inbayad sha nonta bo‐day ja kokowa nonta para amag ni banga, ta si‐katoy bilin nen Apo Shiyos son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jet nonta ẃares Jesus shima sango‐an nen Gobinarol Pilato, sota gobinarol, inbag‐an tos Jesus ja kowan to ey, “Jet agpayso ja si‐kam sota ari ni Hodiyos?” Simongbat si Jesus ja kowan to ey, “Sota inkowan mo, si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nem idi ẃaray inkowan ira nonta apo ni papashi, tan sota ira pangolo ni Hodiyos ja kowan sha ey basol to, eg simongsongbat. ");
INSERT INTO ibl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jet si Pilato, kowan to so nen Jesus ey, “Apay eg mo aya itenengan ima kowan sha ey eshakel la basol mo? Apay nga eg ka simongsongbat?” ");
INSERT INTO ibl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nem si Jesus, angken sakey so nonta kowan sha ey basol to, eg to sinongsongbatan. Jet sota gobinarol, emesshaaw wa pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Amta nen Gobinarol Pilato ey apal ira nonta pangolo ni Hodiyos son Jesus i in‐awatan sha son si‐kato, isonga piyan ton ibolos si Jesus. Tan sakey pay ya kabol la ibolosan to so koma, ẃaray inbetkag nonta aseẃa to ja en engikowan son si‐kato ey, “Si aseẃam, kowan to ey kareka kono mandeka ni kompormi so nitan na too, ta enshiy basol to. Nandigat pay kono si aseẃam nonta edabi ta asdeg toy kinokokip to ni maypangkep nitan na too, jet emankaikelkel‐eẃi kono pay.” Isonga ninemnem nen Pilato sotaapal ira nonta pangolo ni Hodiyos son Jesus i in‐awatan sha son si‐kato, isonga piyan ton ibolos si Jesus. Tan sakey pay ya kabol la ibolosan to so koma, ẃaray inbetkag nonta aseẃa to ja en engikowan son si toka pesing ni olay no timpon piyasta ni Paskowa, ja ẃaray sakey ya pirison toka ibolos ja piyan ira nonta totoon ibolos to. Isonga idi na‐olnong ira sota totoo, kowan nen Pilato son si‐kara ey, “Sipay piyan jon ibolos ko? Si Barabas, ono si Jesus ja inbetkag kono nen Apo Shiyos son si‐kayon Hodiyos?” (Jet saja si Barabas ja inngadnan nen Pilato ja panpidi‐an ni totoo, si‐katoy sakey ya kakedselan na balod nontan.) ");
INSERT INTO ibl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nem sota ira apo ngo ni papashi tan sota ira pangolo ira ni Hodiyos, intod‐an sha sota eshakel la totoo ey say ikowan sha so nen Pilato ja ibolos to, si Barabas; jet si Jesus, angken ikowan sha ey si‐katoy mebono kono. ");
INSERT INTO ibl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jet sota gobinarol, pininshowa ton inbag‐an ira mowan sota totoo, ja kowan to ey, “Jet sipa so ira niya showen too i piyan jon ibolos ko?” Simongbat ira sota totoo, ja kowan sha ey, “Si Barabas!” ");
INSERT INTO ibl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jet si Pilato, kowan to son si‐kara ey, “Jet no sotan i kowan jo, ngaranto ma i dag‐en ko so nen Jesus ja inbetkag kono nen Apo Shiyos son si‐kayo?” Jet emin ira sota totoo, kowan sha ey, “Paidansam shi koros!” ");
INSERT INTO ibl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kowan mowan nen Pilato son si‐kara ey, “Ngantoy? Ngaran ni dingka ton ngaaw aya?” Nem ema‐ma et i keljaw sha ja kowan sha ey, “Paidansam shi koros!” ");
INSERT INTO ibl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Idi indasin ma nen Pilato ey enshiy pesing ton mengibediw son Jesus, tan ninamnama to pay ey ẃara aliy kolo ja medeka, en nanbolo shi sango‐an ira nonta totoo, ta si‐katoy ogadira nontan da no piyan shen ipa‐sas ey enshi may kaybibiyangan sha shi dag‐en ni eshom ma too. Isonga inkowan to ey, “Enshiy basol ko no mebono iyay ya too; olay tokajo ngo!” ");
INSERT INTO ibl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jet emin ira sota totoo, kowan sha ey, “Owen, si‐kamiy maka‐amta, tan saja annak mi di!” ");
INSERT INTO ibl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jet nontan ma, si Pilato, say inbolos to, si Barabas. Jet inpasepdat to nin si Jesus asan toka i‐ẃat so nonta ira solsharo ja sha idansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sota ngo ira solsharo nen gobinarol, indara si Jesus jet indaw sha shima mismon baley nen gobinarol. Inolnong shen emin sota kait shen solsharo jet dini‐mot shes Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sina‐datan shay baro to ni singa baro ni ari ni Roma, ja say kolor to, sota kowan sha ey violet. ");
INSERT INTO ibl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tan say inpasing sha pay ni dedamsis sha, in‐inges sha ni singa ari. Isonga engosikos ira ni ẃakal la nasbitan ja inpaidnget sha son si‐kato, ja singa korona to. Engala pay ira ni pating, ja inpa‐egnira shi kanawan to, asan ma ira nantalimokod shi sango‐an to, ja kowan sha ey, “Onpalapalad ka koma, ari ni Hodiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tinopsha‐an sha pay jet indara sota pating ja inegshi‐an to et inpeg‐as shed toktok to. ");
INSERT INTO ibl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jet idi naksheng sota inpasing shen dedamsis, dinosora sota istay inpaibaro sha, jet in‐oli sha met laeng sota sigod ja baro to. Jet inbo‐day sha ma ja sha idansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Idi maramen ireka man‐ekad, naytompong nga inaspol sha sota toon si Simon i ngaran to, ja i‐Sirini, jet inpasakbat sha et son si‐kato sota koros ja kaydansa‐an nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jet nan‐akad ira ingkatod simbira sota dogad ja kowan sha ey Golgota. (Jet say olog niya Golgota shi esel sha, toktok.) ");
INSERT INTO ibl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Idi mimotok ired man, in‐aknan sha ni adak ja edaokan ni empait ta agas ja eg to so dekna‐an ni ensakit. Nem idi ninamtan to, eg to koston inomen. ");
INSERT INTO ibl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jet indansara ma shi koros. Idi indansara ma, nanbobonot ira sota solsharo no sipay ontompong so nonta baro nen Jesus, asan shaka panbibingayi. ");
INSERT INTO ibl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Idi naksheng ma, timongaw iren nanbantay son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nodta koros to ja petek ni toktok to, ẃaray naysolat ja kowan sha ey si‐katoy kabol ni naydansa‐an tod koros, jet say olog nonta naysolat, kowan to ey: “Sajay si Jesus ja ari ni Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jet ẃaray showen tolisan ja inpakibitay sha son si‐kato shi sanseskey ya koros. Sota sakey, ẃara nodta petek ni kanawan nen Jesus, jet sota sakey, ẃara nodta petek ngo ni kanigid to. ");
INSERT INTO ibl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sotan ngo ira toon emandebas ja man‐ekad nodtan, ngini‐ngi‐ngi‐an sha, tan inbi‐bi‐ẃisan sha pay, ");
INSERT INTO ibl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ja kowan sha ey, “Towa! Kowan mo ey Anak toka nen Apo Shiyos, tan kowan mo pay ey sheshalen moy Timplo jet bengonen mo mowan ni tedon akew! Apay nga eg mo isalakan i bakdang mo shorog ja ondespag alid ta koros mo?” ");
INSERT INTO ibl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jet angken sota ira apo ni papashi ni Hodiyos, tan sota ira mamaistoro ni dinteg, tan sota ira eshom ma pangolo ni Hodiyos, shaka sengsengkita, ");
INSERT INTO ibl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ja kowan sha ey, “Insalakan to konoy eshom nem eg to met isalakan i bakdang to shorog! Kowan to ey si‐kato kono sota ari ni Israel. Tiga, asen tayo noman no ondespag alid ma koros to say memati kito son si‐kato! ");
INSERT INTO ibl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Si Apo Shiyos konoy toka panshindi, jet asen tayo noman ka, no isalakan nen Apo Shiyos niman? Kowan to ey Anak nen Apo Shiyos, jet ma‐sas ka no ensemek nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jet sota kait ton naykoros, ja tolisan, sajay met laeng i kowan sha ni dedamsis sha. ");
INSERT INTO ibl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Idi nonta alas dosi ni ka‐akawan, nanbolinget nodtan na dogad ingkato nonta alas tris ni mama‐shem. ");
INSERT INTO ibl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jet idi nonta alas tris ni mama‐shem, si Jesus kimeljaw ni makedsang, ja kowan to ey, “Eli, Eli, lama sabaktani!” Say olog niya kowan to, “Shiyos ko, Shiyos ko, ngantoy in‐owayan mowak so?” ");
INSERT INTO ibl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nem sota eshom ma toon ẃara nodtan, idi intenengan sha sota kowan nen Jesus, kowan sha ey, “Toka emo panta‐ẃala ali si Elias shi dangit.” ");
INSERT INTO ibl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jet sota sakey so nonta ira toon ẃara nodtan, kinano‐an ton en engi‐neng nonta singa bonot ja masbet ni shanom nodta empait ta tapey asan toka ipi‐ket shi pating. Jet in‐awat tod sobil nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nem sota eshom, kowan sha ey, “Ekanin! Asen tayo ka no ondaw ali si Elias ja en mengisedakan son si‐kato!” ");
INSERT INTO ibl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jet si Jesus, inkedsang toy keljaw to mowan, asan ma ma‐bosi. ");
INSERT INTO ibl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jet nontan ma, sota masshel la kortina ja naysa‐din nodta Kapatkan na kowadto shima naydaem ni Timplo, epi‐kat ta nanshowa, manipod nodta naytapew ingkatod ma despag. Nanjegjeg pay jet angken sota engkakembaleg ga bato, nankepesjang ira, ");
INSERT INTO ibl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tan angken sota ira naydiyangan ni etey, edo‐katan ira. Jet nanbiyag ngo ira sota eshakel la too nen Apo Shiyos ja nanketey. ");
INSERT INTO ibl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Idi nan‐ongal ma ngo si Jesus ni maykatdon akew, bimo‐day ngo ira sotan shima naydiyangan sha, jet dimaw ired ma Jerusalem ja en nanpa‐sas so ira nonta eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sota kapitan ni solsharo, tan sota kait ton emanbantay son Jesus ja naykoros, dineknara sota jegjeg jet mismon inon‐an shay epasemak. Eta‐kot iren pasiya jet kowan sha ey, “Agpayso gayam ey sajay ya too ket anak ni Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eshakel ira sota bibiin ẃara nodta naybabetaw ja engikadmang niyay ya epasemak. Sajay iren bibii, tinodongan shes Jesus alid Galilia. ");
INSERT INTO ibl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jet say ngaran ira nonta eshom ma bibii ja ẃara nodtan, sajay: si Maria Magdalena, si Maria ja ina nen Santiago nen Jose, tan sota aseẃa nen Sibidi ja ina nen Santiago nen Juan. ");
INSERT INTO ibl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Idi mama‐shem mala, ẃaray dimaw alin baknang nga too ja manngeshan ni Jose ja edapod ili ni Jodia ja kowan sha ey Arimatia. Sajay ya too, emati met laeng so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dimaw so nen Pilato ja to kinshaw i bakdang nen Jesus, jet nontan si Pilato, inbilin to ey itolok ira nonta solsharo sota bakdang nen Jesus son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jet si Jose, impas toy bakdang nen Jesus nodta koros jet dinibotan to ni badon dopot ja empoti. ");
INSERT INTO ibl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Saja si Jose, ẃaray badon inpaliyang ton bato ja kowan to ey kaydiyangan to kono nem metey. Shiyay i in‐ilaẃan to so ni bakdang nen Jesus. Inodin to sota ebadeg ga baton tangeb nonta diyang, jet inpokit to nodta sakepan, asan toka ilekjas. ");
INSERT INTO ibl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jet si Maria Magdalena, tan sota sakey ya si Maria, timongaw ira nin nodta mamang ni diyang. ");
INSERT INTO ibl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Idi nonta maykadẃen akew, ja naksheng ma sota akew ni shaka pansekana ni piyasta ni Paskowa, sota ira apo ni papashi, tan sota ira Parisiyo, nan‐o‐odop iren dimaw so nen Pilato, ");
INSERT INTO ibl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","jet kowan sha ey, “Apo, eg mi dibkan sota inkowan niman na toon ma‐owap nonta mabiday pay laeng, ja kowan to ey no maykatdon akew, manbiyag mowan kono. ");
INSERT INTO ibl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isonga pabantay mon pasiya ima naydiyangan to ingkatod maykatdon akew, ta baka sota ira too to, ondaw iren sha ibetik ima bakdang to, asan sha ikowan mango ni totoo ey nan‐ongal. Nakol ni mema‐ma ja eshakel i may‐owapan ey say nonta pilmiro.” Kowan sha son Pilato. ");
INSERT INTO ibl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jet si Pilato, kowan to son si‐kara ey, “Eti, daw kayo, et pangodop kayo ni solsharo. Ipeshas joy kabaalan jon memantay ja pasiya.” ");
INSERT INTO ibl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jet dimaw ira nodta diyang et sha pinokit ja siningpetan na pasiya sota tangeb to, tan inpabantay sha pay ni solsharo sota diyang. ");
INSERT INTO ibl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nem idi agsapen pasiya ni Domingko, si Maria Magdalena tan sota sakey ya Maria, dimaw ira ja sha on‐an sota naydiyangan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jet nontan, ebigla ja ẃaray makedsang nga jegjeg, ta ẃaray anghil nen Apo Shiyos ja dimespag alid dangit, jet to pinodig sota baton naytangeb nodta diyang, jet si‐katoy tinongawan to. ");
INSERT INTO ibl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Say itsora ni dopa nonta anghil, singa bagidat, tan say baro to, empotin pasiya. ");
INSERT INTO ibl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Isonga sota solsharon emanbantay, ireka manbebayedbed ni takot sha et singa etey ira. ");
INSERT INTO ibl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nem sota anghil, kowan to so nonta bibii ey, “Karekayo ontakot; amtak ey say piyan jon on‐an, si Jesus ja naydansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nem enshid jay, nan‐ongal da! Nemnem jo kari: inkowan to met nontan da. Kalejo, jo asas sota istay inparokolan sha so. ");
INSERT INTO ibl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jet no asen jon enshi, daw kayon shagos, jet jo ikowan so nonta ira too to ey nanbiyag mowan da, jet niman, ondaw den mepangdo ey si‐kayo shi Galilia, jet shiman i asanan jo so! Karejo dibdibkan iyay ya inkowan ko son si‐kayo.” Kowan nonta anghil so nonta bibii. ");
INSERT INTO ibl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jet nontan met laeng, indekjas ira nonta bibiin shagos sota diyang, jet nanbetik iren sha ikowan so nonta ira too nen Jesus. Ireka mankel‐ew, nem ebadeg ngoy imdeng sha nonta ireka mandaw. ");
INSERT INTO ibl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Idi nonta ẃara ired shalan, ebiglen nay‐aspol si Jesus son si‐kara jet kowan to ey, “Siya, talna i meẃesha son si‐kayo!” Jet sota ira bibii, nanshomog ira ja inegshi‐an sha sota sedi to, jet nanshayaw ira son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jet kowan nen Jesus son si‐kara ey, “Karekayo ontakot. Daw kayo, jo ikowan so nonta ira took ja naka ikarin a‐akik ey ondaw ired Galilia, jet ikowan jo ey shiman i asanan sha‐ak so.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Idi nontan na emandaw ira jay ya bibii, sota eshom ma solsharo ja istay emanbantay nonta diyang, dimaw ira ngo shima siyodad jet sha inkowan so nonta ira apo ni papashi sota emin na epasemak. ");
INSERT INTO ibl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jet esa‐nop ira sota apo ni papashi, tan sota ira eshom ma pangolo ni Hodiyos, jet nantatabtabal ira ni pesing sha. Jet nontan ma, ninemnem sha ey i‐aknan sha ira sota solsharon nanbantay nonta diyang ni ebadeg ga pilak, ");
INSERT INTO ibl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asan shaka ira bilina, ja kowan sha ey, “Ikowan jo so ni totoo ey sota ira too nen Jesus, dimaw ira di nonta edabin nasjep kayo ni ogip, jet kinibot sha sota bakdang to. ");
INSERT INTO ibl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jet no bilang ey amta‐an nen gobinarol iyay, si‐kamiy mismon mekitbal son si‐kato; enshiy jo panshanagan.” ");
INSERT INTO ibl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jet sota ira solsharo, indara sota pilak jet pinatiren inkowan sotan na inbilin ni pangolo ni Hodiyos son si‐kara. Jet ingkato niman, sotan i kaikokowan ni eshom ma Hodiyos maypangkep ni inka‐enshi nen Jesus shima diyang. ");
INSERT INTO ibl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jet sota ira sampolo tan sakey ya apostol nen Jesus, dimaw ira nodta shontog shi Galilia ja inkowan nen Jesus son si‐kara ey daẃan sha. ");
INSERT INTO ibl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jet idi inon‐an sha si Jesus nodtan, nantalimokod iren emin ja nanshayaw son si‐kato, nem sota eshom, ẃaray showashowa sha. ");
INSERT INTO ibl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jet si Jesus, imesop son si‐kara, jet kowan to ey, “Say inkowan nen Apo Shiyos, si‐kak i mengitoshay ni emin na ẃared dangit tan shiya dobong. ");
INSERT INTO ibl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isonga ikowan ko son si‐kayo ey daw kayo shi emin na ili shiya dobong, jet itoshoyo i maypangkep son si‐kak say memati ira. Bonjagi jo ira shi ngaran nen Apo Shiyos ja Amak, shi ngaran ko ja Anak to, tan shi ngaran ni Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jet itod‐iyo pay ira say emin sota inbilin ko son si‐kayo, si‐kato ngoy pati‐en sha. Jet nemnemnem jo ey ẃara‐ak ni olay son si‐kayo, ingkatod pantepos niya dobong.” Kowan nen Jesus.");
INSERT INTO ibl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sota mapteng nga shamag maypangkep son Jesucristo ja Anak nen Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","nayshogi nonta engitosho si Juan ja para bonjag. Si‐katoy nantongpalan nonta padto nen Isaias nonta bayag da, ja esel nen Apo Shiyos met laeng so ni Anak to, ja kowan to ey, “Iyay sota ibetkag kon mepangdo ey say si‐kam, jet si‐katoy mengikowan nodta totoo ey mansekana ira ni imotok mo. ");
INSERT INTO ibl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Si‐kato ali sota toon ikeljaw toy esel to shima dogad ja nay‐araẃi shi kad‐an ni totoo, ja ikowan to ey, ‘Pansagana kayo ta shanshani ma aliy imotok nen Apo! Singpet joy shalan na pan‐akshan to!’ ” ");
INSERT INTO ibl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Siya, shima dogad ja nay‐araẃi shi kad‐an ni totoo i nantoro‐an nen Juan ja para bonjag. Say intoro to so ni totoo nontan, kowan to ey, “Mesepol la manbebawi kayo pangkep ni basbasol jo, asan kayoka manpabonjag, say pekawanan nen Apo Shiyos i basol jo!” ");
INSERT INTO ibl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sota ira tood Jerusalem tan eshom ma toon nanbaley shi probinsiya ni Jodia, ireka mansisina‐dat ja ondaw son si‐kato. Inkowan shen emin i basol sha say pekawanan ira nen Apo Shiyos; isonga binonjagan ma ira nen Juan. ");
INSERT INTO ibl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Say baro nen Juan, nagshengan: sota na‐abel la bowek ni animal ja kowan sha ey camel i toka osala bengat, ja ebalkesan ni kolti. Jet nagshengan ngoy toka kena, ja shoron tan shanom ni dinowan. ");
INSERT INTO ibl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Say intoro pay nen Juan nontan, kowan to ey, “Wara aliy maysa‐dat son si‐kak ja ebadbadeg i panakabalin to nem say si‐kak. Jet ekak pay maykeshi ja baga‐en to koma ja mengkal ni sapatos to. ");
INSERT INTO ibl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Dimawak ali ja shanom i inpamonjag ko son si‐kayo, nem sotan aliy onbonjag son si‐kayo ni Ispirito Santo nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nontan, edapo ngos Jesus shi Nasarit ja ili tod probinsiya ni Galilia ja ondaw shima kawad‐an nen Juan, jet nanpabonjag son Juan shima pa‐dok ni Jordan. ");
INSERT INTO ibl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Idi kima‐jat si Jesus nodta shanom, inon‐an ton shagos ja edo‐katan i dangit, tan inon‐an toy Ispirito Santo nen Apo Shiyos ali ja singa inges toy itsora ni kalopati ja emandespag alin onsepa son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jet si Apo Shiyos, imesel alid dangit ja kowan to ey, “Si‐kam i Anak ko et ensemek taka, tan si‐kam i naka pan‐imdengi.” ");
INSERT INTO ibl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jet nontan, inbetkag ni Ispirito Santo nen Apo Shiyos si Jesus ja ondaw shima dogad ja nay‐araẃid kawad‐an ni too. ");
INSERT INTO ibl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jet ẃares Jesus shiman ni epat ta polon akew, jet pineshas nen Satanas ja panbesol. Saja dogad ja kawad‐an nen Jesus nontan, eshakel i atap pa animal, nem nonta kawasha tod man, ẃara iray anghil ja emengajowan son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nontan ngo ma, naybalod si Juan ja para bonjag. Jet si Jesus, imoli shi Galilia, ja engitosho‐an to ma ni mapteng nga shamag ja edapo son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jet kowan to ey, “Niman sota naypadton timpo! Shanshani ma sota naypadton pantoshayan nen Apo Shiyos! Isonga baliẃiyo sota ngaaw wa ẃared nemnem jo jet patiyo iya mapteng nga shamag ja naka pan‐itoro!” ");
INSERT INTO ibl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Idi sakey ya akew, eman‐ekad si Jesus shima kilig ni baybay shi Galilia jet inon‐an to si Simon, tan si Andres ja agi nen Simon met laeng. Shaka pan‐iteknal sota embanaw wa balshew sha shi shanom, tep nigay i shaka panbiyagi. ");
INSERT INTO ibl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jet si Jesus, kowan to son si‐kara ey, “Kay‐olop kayo son si‐kak et panbedin takejo ni took, jet mengolnong kayo ngo ni too ja itod‐an jo para son si‐kak. Aliẃa malen sota pengolnong ni nigay i obdayo.” ");
INSERT INTO ibl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jet idi inkowan nen Jesus iyay, indekjas nonta san‐agin shagos sota embanaw wa balshew sha, jet si Jesus ma i nay‐olopan sha. ");
INSERT INTO ibl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Intoloy shen nan‐akad jet ẃara pay i inon‐an nen Jesus ja san‐agin anak nen Sibidi, ja si Santiago nen Juan. Wara ira nodta bangkara ja shaka pansingpeta sota balshew sha. ");
INSERT INTO ibl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jet si Jesus, tina‐ẃal to ira sota showen san‐agi ja manbedin ni too to. Jet nontan met laeng, indekjas sha shagos si amesha tan sama ira dinagbo‐an ton too nodta bangka, jet eki‐odop ira son Jesus, ja nanbalin iren too to. ");
INSERT INTO ibl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mimotok ira shi siyodad ja kowan sha ey Kapirnaom, jet idi shimanon sota akew wa ngilin ni Hodiyos, ekisa‐nop si Jesus nodta baley ya sa‐nopan ni Hodiyos, jet nantoro nodtan. ");
INSERT INTO ibl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Emesshaaw ira sota totood man ni itsora ni toka pengitosho, tep ẃara et ngo mowan i kepengipateg ni too nonta toka pan‐itoro nem say sota toro nonta ira mamaistoro ni dinteg ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jet nontan, nodtan na baley ya sa‐nopan, ẃaray toon eman‐engaw ja pingketan ni dimonyo. Jet inkedsang nontan i esel to, ");
INSERT INTO ibl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ja kowan to ey, “Ngantoy! Dimaw ka di ja en meneshal son si‐kami? Enshiy kaybiyangan mo son si‐kami, Jesus ja i‐Nasarit! Amtak nem sipa ka: si‐kam sota shinotokan nen Apo Shiyos ja inbetkag to di!” ");
INSERT INTO ibl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jet si Jesus, sinelkag to sota dimonyo, ja kowan to ey, “Eka‐eket ka! Et ilekjas mo ita too!” ");
INSERT INTO ibl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jet sota dimonyo, inpankenkenteg to sota toon pingketan to, jet kimeljaw sota dimonyo, asan kebetik nodta too. ");
INSERT INTO ibl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nasshaaw iren emin sota toon engasas; isonga nanbibinaga ira, ja kowan sha ey, “Ngaran emon jay? Emengipeteg gayam iyay ya toka pan‐itoro! No ikowan to ey onbetik i dimonyon pimeket shi too, shaka pati‐a nga agpayso!” ");
INSERT INTO ibl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jet sajay ya shamag pangkep son Jesus, nayẃaris shi emin na sakop ni Galilia ja nay‐esop nodtan na kawad‐an sha. ");
INSERT INTO ibl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Idi bimo‐day si Jesus nodta baley ya kesa‐nopi ni Hodiyos, dimaw wa shagos nodta baley nen Simon nen Andres ja san‐agi, jet nay‐olop ngo si Santiago nen Juan. ");
INSERT INTO ibl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simbira sota inepo nen Simon ja bii, ja emansekit, ja empetang nga pasiya i bakdang to. Jet inpa‐amtara son Jesus ey emansekit. ");
INSERT INTO ibl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Si Jesus, dimaw nodta shinokolan to jet inegni‐an toy takday nonta emansekit jet inatngan ton bimangon. Na‐kal sota sakit to jet inkamakaman to ira. ");
INSERT INTO ibl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Idi mama‐shem malen edimos i akew, in‐ilaw ni totood man son Jesus i totoon emanpansekit tan angken pay ira sota totoon eman‐engaw ja pingketan ni dimonyo. ");
INSERT INTO ibl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eshakel la pasiya i totoon i‐Kapirnaom ja esho‐kon nodta sakepan ni baley. ");
INSERT INTO ibl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jet si Jesus, inpamapteng toy eshakel la totoon emanpansekit ja ekalkalasiy sakit sha, jet eshakel pay i inpabtik ton dimonyo ja pimeket shi totoo. Nem si Jesus, eg to ipalobos ja on‐esel ira sota dimonyo tep amtaray katoo to. ");
INSERT INTO ibl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nonta daem mala, bimangon si Jesus et dimaw shi naydasin na dogad ja enshiy too, jet nanshawat son Apo Shiyos shiman. ");
INSERT INTO ibl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nem si Simon, tan sota ira kait to, sha inena‐enap, ");
INSERT INTO ibl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","jet idi simpol sha, kowan sha ey, “Shakaka en‐enapa ni eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nem simongbat si Jesus, ja kowan to ey, “Eti, ondaw kito et shima eshom ma kawad‐an ni totoo ja nay‐askang shiyay, say mengitosho‐ak ngod man ni mapteng nga shamag. Tep si‐katoy obdak ja kabol la dinaẃan ko did jay.” ");
INSERT INTO ibl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jet nan‐ak‐akad si Jesus shi ka‐ili‐ili ni Galilia, jet nantoro shi kebalbaley ya kesa‐nopi ni Hodiyos nodtan iren dogad ja dinaẃan to, jet inpabtik to pay i eshakel la dimonyon pimeket shi totoo. ");
INSERT INTO ibl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Idi pinsak, ẃaray toon dimaw ali son Jesus ja ebayabayang i bakdang to. Sotan na too, nantalimokod shi sango‐an nen Jesus ja emengshaw ni kaasi son si‐kato, ja kowan to ey, “No piyan mo, pamapteng mo iya bakdang ko, say eg sha‐ak seskigen ni totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jet si Jesus, naysemekan; isonga inojad toy takday to et pinishat to sotan na too. Jet kowan nen Jesus son si‐kato ey, “Siya, piyan kon onmapteng ka.” ");
INSERT INTO ibl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jet nay‐inshas ngon na‐omas sota ira bayang nonta too, jet pimeteng may bakdang to. ");
INSERT INTO ibl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jet si Jesus, binidin ton pasiya sotan na too, asan toka ibetkag, ");
INSERT INTO ibl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ja kowan to ey, “Karam ikokowan iyay so ni angken sipa, no diket pandiritso ka et ja ondaw shima pari. Ipa‐sas mo ita bakdang mo son si‐kato, ja mimapteng ma. Jet pangidaton ka nonta kowan nen Moises shi dinteg to ey maydeton son Apo Shiyos, say amta‐en ni karakdan ey si‐kam ket enshi malay bayang mo.” Kowan nen Jesus son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nem sota toon na‐kal i bayang to, inpaleẃag to ey inpamapteng nen Jesus i bayang to. Jet sajay ya shamag, asdeg ton nayẃaris pay shima angken araẃin dogad. Nakol ni si Jesus, eg mala maka‐edaw shi angken nganton siyodad. Nan‐iyan ni olay shi naybetaw iren dogad, nem angken ẃared naybetaw, eg ngoreshan ma‐enshiy eshakel la totoon kaondaw son si‐kato ja emedepod kompormin dogad. ");
INSERT INTO ibl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Idi edabas malay pigen akew, imoli si Jesus shi Kapirnaom. Jet shinemag ni eshakel la too ey ẃares Jesus shi baley to. ");
INSERT INTO ibl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Esinop i eshakel la totoo nodtan: eposek i naydaem et pati sota sakepan ni baley, epokit ni too. ");
INSERT INTO ibl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Idi maramen toka pan‐itoro son si‐kara sota mapteng nga shamag, binangtal ngo di ni epat ta too i sakey ya toon eg makakeykey i bakdang to, ja idaw sha ali son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nem eg mebedin na i‐esop sha son Jesus tep eshakel i too. Isonga ingkal shay atep nodta petek ni toktok nen Jesus, jet idi edo‐katan, inoy‐oy sha sota emansekit ja ka‐onong nga shimokol shi amaka. ");
INSERT INTO ibl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Idi indasin nen Jesus ey ebadeg i pamatira, kowan to so nonta emansekit ey, “Sota basol mo, epakaẃanan.” ");
INSERT INTO ibl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nem ẃara nodtan i eshom so nonta ira mamaistoro ni dinteg ni Hodiyos jet kowan shed nemnem sha ey, ");
INSERT INTO ibl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Apay nga saman i pan‐ikowan niyay ya too? Toka pa‐so‐i si Apo Shiyos! Kowan to ey ememekawan ni basol, ey enshi met i eshom ma memekawan ni basol nem eg si Apo Shiyos bengat!” ");
INSERT INTO ibl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nem si Jesus, amta to ey sajay i ẃared nemnem sha, isonga kowan to son si‐kara ey, “Apay nga joka sopngiled poso jo iyay ya kowan ko? ");
INSERT INTO ibl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Say kowan jo, inba‐ngat kon memekawan ni emin na basol niyay ya toon eg makakeykey i bakdang to, ey ekak kabaalan? Nem iyay i dag‐en kon pati‐an jo so. Ikowan ko so niyay ya too ey on‐etan, al‐en to ma shinokolan to, asan ma man‐akad. ");
INSERT INTO ibl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jet no man‐ekad, amta‐en jo ey si‐kak sota kowan nonta para padto nonta bayag da ey Anak ni Too, tan amta‐en jo pay ey ẃaray kalintegan kod ja dabaw ni shaga ja memekawan ni basol ni too.” Jet si Jesus, inkowan to nonta toon eg man‐ekad ey, ");
INSERT INTO ibl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ikowan ko son si‐kam, alam ita shokolan mo, jet akad ka!” ");
INSERT INTO ibl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jet siya, bimangon sota toon istay eg makakeykey i bakdang to et inda to sota amaka to, asan toka ira ilekjas. Jet inon‐an ira nonta eshakel la too iyay ya epasemak. Nasshaaw ira et inshayaw sha si Apo Shiyos, ja kowan sha ey, “Enshiy mi inon‐an na inges niyay nontan da ingkato niman!” ");
INSERT INTO ibl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dimaw mowan si Jesus shima kilig ni baybay et eshakel la pasiya i totoon emansisina‐dat ja en simabi son si‐kato. Jet intod‐an to ira. ");
INSERT INTO ibl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Idi naksheng iyay, nan‐akad si Jesus say ma‐tan nodtan na dogad, jet inon‐an to sota toon manngeshan ni Levi, ja anak nen Alpio, ja eman‐obded opisina to. Say obda to, para singil ni bowis. Kowan nen Jesus son si‐kato ey, “Kala, kay‐olop ka son si‐kak et manbedin ka ni took.” Jet si Levi, dimayat et imonod son si‐kato, ja nanbalin ni too to. ");
INSERT INTO ibl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jet nontan, engan si Jesus tan sota ira too to shi baley nen Levi, jet ekilikob ira so nonta kait nen Levi ja para singil ni bowis, tan sota eshom ma kowan ni Hodiyos ey enshiy kenshat shen too, ja mabesol kono. Tep eshakel iray inges niyay ja too ton emay‐odo‐odop son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nem sota eshom so nonta ira Parisiyo, ja mamaistoro met laeng ni dinteg, idi inon‐an sha ey emekipengan si Jesus so iren ja toon shaka ibilang ey enshiy kenkenshat sha, kowan sha so nonta ira too nen Jesus ey, “Ngantoy! Emekipengan ima apo jo so ira nima para singil ni bowis tan sama eshom ma toon enshiy kenshat sha, ja eshakel i basol sha!” ");
INSERT INTO ibl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nem idi intenengan nen Jesus iyay ya inkowan sha, simongbat son si‐kara ja kowan to ey, “Ekak ali dimaw ja mengeẃis ni toon maronong, nem dimawak ali ja mengeẃis ira nonta toon eshakel i basol sha. Mebedin na may‐eshigak shi doktor. Eg bisita‐en ni doktor i enshiy sakit to, no diket sota ira ẃaray sakit to.” ");
INSERT INTO ibl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Idi pinsak, sota ira Parisiyo tan sota ira too nen Juan ja para bomjag, inbiyang shay pangan sha tep ireka manngidin. Jet nontan, ẃara iray eshom ma toon dimaw son Jesus et kowan sha ey, “Sota ira too nen Juan tan too nonta ira Parisiyo, kanayon na shaka ibiyang i pangan sha no manngidin ira, nem apay nga sama toom ket eg sha ibiyang i pangan sha?” ");
INSERT INTO ibl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jet si Jesus, say songbat to son si‐kara, in‐arig toy bakdang to shi dakin engaseẃa. Isonga kowan to ey, “Piyan jon ikowan ey sota ira bisita shi kasal ket eg ira mengan angken ẃara sota dakin engaseẃa? Enshi a! Kenshat ta mengan ira. ");
INSERT INTO ibl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nem ẃara et mangoy timpon onmotok ali ja ma‐enshi son si‐kara sota dakin engaseẃa, jet si‐katoy timpon ibiyang sha so ni pangan sha maypangkep ni daringit sha.” ");
INSERT INTO ibl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jet si Jesus, inkowan to mowan i sakey ya arig son si‐kara ja kowan to ey, “Na‐alas no maysekab i badon abel shi shaan na baro. No maysekab sota bado, ey onkesen, binaten to sota nayshaitan ton shaan; nakol ni mema‐ma sota epi‐kat.” ");
INSERT INTO ibl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tan ẃara pay i sakey ya inkowan ton arig, ja kowan to ey, “Na‐alas no may‐iyan i badon adak shi na‐osal la inemag shen katat ja ijanan ni adak, ja kowan sha ey ‘wineskin’. No sotan i pesing jo, pepetjag nonta adak sota nay‐iyanan to, jet onkawas sota adak. Tan angken pay sota nay‐iyanan to, mepilshi. Mesepol ja no badon adak, bado ngoy kay‐inan to.” ");
INSERT INTO ibl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Idi sakey ya akew wa ngilin ni Hodiyos, nanshalan shi Jesus shi oma ja emola‐an, jet idi ireka man‐ekad, sota ira too nen Jesus, shaka pan‐ina‐jon i patod ni dames nonta mola. ");
INSERT INTO ibl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nem sota ira Parisiyo, kowan sha son Jesus ey, “Asas mo kari ira ma toom! Apay nga dingkara iman ey kaiparit ni dinteg tayon Hodiyos i mengetod no akew wa ngilin?” ");
INSERT INTO ibl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jet si Jesus, simongbat ja kowan to son si‐kara ey, “Arig to ngo sota inpasing nen Ari David nonta bayag da ni inka‐ekang to, tan sota ira too to, ta enshin polos i kenen sha. Apay eg jo aya amtay dingka to? ");
INSERT INTO ibl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dimaw si David shima tolshen baley ya inbilang sha ey para son Apo Shiyos nonta timpon inpanpari nen Abiatar ja kangeto‐an et kinan to sota tinapay ya naydaton son Apo Shiyos. Sajay i inpasing to anta nga nayparit so ni kompormin too i pengan sha nontan na tinapay. Ta sota pari bengat i palobos sa mengan nontan na tinapay. Jet in‐aknan to pay ira sota too to. ");
INSERT INTO ibl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iyay i nemnemen jo: epangdo i too ja eẃara asan mawasha i ngilin ja para pansigshan ni too; aliẃen eẃara i too say tongpalen to sota dinteg maypangkep ni ngilin. ");
INSERT INTO ibl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Isonga si‐kak ja naypadton Anak ni Too, ja apo ni emin, si‐kak met laeng i mengikowan no ngantoy mebedin na dag‐en no akew ni ngilin.” ");
INSERT INTO ibl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ekisa‐nop mowan si Jesus shi baley ya sa‐nopan ni Hodiyos et nontan, naytompong nga ẃara nodtan i toon eki‐ngoy i sakey ya takday to. ");
INSERT INTO ibl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wara ngoy eshom ma too nodtan ja emeni‐siim son Jesus no ẃaray ekasan to nontan na akew, tep kowan sha ey balang nem ẃaray dag‐en to ja ikowanan sha so ey nanbasolan to. Ta nayparit kono shi dinteg sha i pengekas no akew ni ngilin. ");
INSERT INTO ibl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jet si Jesus, kowan to so nonta toon eki‐ngoy i takday to ey, “Daw ka did ja sango.” ");
INSERT INTO ibl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jet kowan to so nonta ira emeniim son si‐kato ey, “Ngaaw aya i pandeka ni mapteng, ono pemiyag ni too, no timpon ngilin? Enshi: say ngaaw ja kaiparit ni dinteg tayo, sota pandeka ni ngaaw tan pemono ni too.” Nem enshiy shaka isongbat. ");
INSERT INTO ibl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Inbonget ira nen Jesus et emandeshingit pay ya pasiya tep shaka ipilit ni olay sota kostora. Sina‐sa‐key to iren insi‐ning, asan to ikowan so nonta toon eki‐ngoy i takday to ey, “Oyad mo ita takday mo.” Pinati nonta eki‐ngoy sota kowan nen Jesus et mimapteng mowan nga agpayso sota takday to. ");
INSERT INTO ibl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nem sota ira Parisiyo, bimo‐day ira et nantatabtabal ira so nonta ira too nen Ari Hirodis no ngarantoy pesing shen memono son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jesus tan sota ira too to, indekjas sha sotan na dogad et dimaw ired kilig ni baybay. Jet eshakel la pasiya iray toon imonod son si‐kato: iman i nankedapod Galilia, iman i nankedapod Jodia, ");
INSERT INTO ibl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","iman i nankedapod siyodad ni Jerusalem, iman i nankedapod Idomia, iman i nankedapod ma dogad ja baliw ni pa‐dok ka Jordan, tan iman pay i nankedapod ma dogadogad ja diked ni siyodad ni Tira tan Sidon. Saja ira eshakel la totoo, shinemag shay kaskasshaaw wa kedagdag‐a nen Jesus, isonga sha ali simbi. ");
INSERT INTO ibl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Inkowan nen Jesus so nonta ira too to ey mengisekana ira ni bangka ja pan‐iyanan to tep kowan to ey baka i‐ipit nonta eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta eshakel i inpamapteng ton toon emanpansekit et emansisikil i emin na toon kaonsanakit ja kowan sha ey pishaten shes Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jet nontan, ẃara ngo iray totoon pingketan ni dimonyo et idi inshemang nonta ira dimonyo si Jesus, ireka mantedimokod shi sango‐an to, ja shaka pan‐ikeljaw ey, “Si‐kam i Anak nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nem binidin to iren pasiya ey eg sha ikokowan i maypangkep son si‐kato so ni angken sipa. ");
INSERT INTO ibl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dimaw si Jesus shi shontog et sina‐nop to ali ira sota kinosto‐an to, jet dimaw ira son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","jet shinotokan toy sampolo tan showa son si‐kara. Saja ira sampolo tan showa, si‐karay ninemnem ton kaiten to ni olay tan si‐karay ibetkag ton en mengitosho. ");
INSERT INTO ibl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Si‐kara pay i piyalen ton angken pebtik sha iray dimonyo ja pimeket shi totoo. ");
INSERT INTO ibl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Say ngaran ira nonta sawal ni showa, sajay: si Simon ja inngadnan ton Pedro; ");
INSERT INTO ibl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago nen Juan ja san‐agin anak nen Sibidi (saja san‐agi, binshayan nen Jesus ni Boanijis, ja piyan ton a‐selen ey, “anak ira ni kirol”); ");
INSERT INTO ibl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, Felipe, Bartolome, Mateo, Tomas, Santiago ja anak nen Alpio, si Tadio, sota si Simon ja bitirano, ");
INSERT INTO ibl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tan si Judas Iskariote ja mengileko ali so nen Jesus shi anongosto. ");
INSERT INTO ibl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Idi naksheng nga shinotokan nen Jesus ira sota sawal ni showen apostol to, imakad shi baley ya toka pan‐iyani nontan. Jet esa‐nop mowan i eshakel la totoo nodtan na kadnan sha jet nakol ni ayshiy ẃaya shi ira Jesus ja mengan. ");
INSERT INTO ibl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Idi amta‐an nonta a‐aki nen Jesus, dimaw iren kowan sha ey i‐akad sha tep kowan sha ey na‐kal i nemnem to. ");
INSERT INTO ibl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wara ngo iray mamaistoro ni dinteg ni Hodiyos ja edapod Jerusalem ja kowan sha ey, “Pimeket si Bilsibob ja apo ni dimonyo son si‐kato.” Tan kowan sha ey, “Sota apo ni dimonyo i toka osala ja pebtik so ni dimonyon pimeket shi totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Isonga si Jesus, tina‐ẃal to ira et in‐aknan to ira ni arig, ja kowan to ey, “Dokodoko itan na kowan jo ey sota apo ni dimonyo i naka osala ja pebtik so ni dimonyo. Toway pesing nen Satanas ja mengipebtik so ni bakdang to shorog? ");
INSERT INTO ibl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ta amta to ey sajay, arig toy ilin manshowa. No manshowen shorog i sakey ya ili, kenshat ta mansisi‐jan ira sota totoo nontan na ili. ");
INSERT INTO ibl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kasta met sota sanpamilja ja manshowa, mansisi‐jan ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Isonga si Satanas, eg mebedin na pebtik to met laeng i kait to, tep amta to ey no bekalen toy bakdang to, tan manbabakal i too to, eg onbayag i pansaad to, no diket menginteg i kabedinan to. ");
INSERT INTO ibl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Say agpayso, inebak ko nin sota apo ni dimonyo. Arig to sota matekal la too. Eg kabaalan ni sakey ya toon onsekep shi baley ni matekal la too ja kowan to ey al‐en ton emin sota ẃara nodta naydaem ni baley. Ayshi, kenshat ta say pesing to nin ket bedoren to sotan na too asan toka al‐ala‐en emin sota ẃara nodta baley. ");
INSERT INTO ibl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Emin iray basol ni too, ono sota ngaaw wa shaka ikokowan, mebedin na mepekawanan, ");
INSERT INTO ibl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nem sota ngaaw wa shaka ikokowan maypangkep nonta Ispirito Santo nen Apo Shiyos, eg mebedin na mepekawanan, no diket may‐a‐det son si‐kato ni olay ingkatod ingka.” ");
INSERT INTO ibl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Inkowan nen Jesus iyay tep endedamsis ira nonta mamaistoro ni dinteg i Ispirito Santo nen Apo Shiyos, ja kowan sha ey, “Si‐kato, ẃaray dimonyon kaontolong son si‐kato.”) ");
INSERT INTO ibl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mimotok nontan si ina nen Jesus tan sota ira a‐aki ton daleki. Nanseked ired bo‐dayan et inpata‐ẃal sha di si Jesus say ondaw ali ja to di ira on‐an. ");
INSERT INTO ibl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eshakel iray totoon timongaw ja nandikmot son Jesus et kowan sha ey, “Wara si inam tan sota ira a‐akim shi bo‐dayan, jet piyan shaka konon on‐an.” ");
INSERT INTO ibl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nem si Jesus, kowan to son si‐kara ey, “Sipay ikarik ja inak, tan sipay ikarik ja a‐akik?” ");
INSERT INTO ibl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jet inshemang toy totoon timanongaw ja nandikmot son si‐kato et inkowan to ey, “Sajay iray ikarik ja innak, tan ikarik ja a‐akik! ");
INSERT INTO ibl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tep say naka ikarin innak tan a‐akik, sota ira mandeka ni piyan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dimaw mowan si Jesus ja en nantoro shi kilig ni baybay et esa‐nop i eshakel la totoo son si‐kato. Kesoreng si Jesus ey man‐a‐tan nodta bangka ja ẃara nodta shanom. Timongaw si Jesus nodtan, ey sota ira too, ẃara iren esalpag nodta kilig ni shanom. ");
INSERT INTO ibl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eshakel i intoro nen Jesus son si‐kara, nem poro arig i inpaspasing ton engikowan. Say sakey ya arig ga inkowan to son si‐kara, sajay: ");
INSERT INTO ibl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Itnengiyo iyay! Waray too ja dimaw wa en manbangkag shi oma. ");
INSERT INTO ibl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Idi toka pan‐iẃaris sota botil, ẃara iray nayponta shi shalan, jet kinan ira ni titit. ");
INSERT INTO ibl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sota eshom ma botil, nayponta ira nodta kabato‐an ja ma‐ingpis i bo‐day to, jet timemel la shagos, tep aliẃen masshel i bo‐day ja nayponta‐an to. ");
INSERT INTO ibl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nem idi simekal i sekit, nakkit sota ira timemel la botil ta eg shimalem sota damot sha. ");
INSERT INTO ibl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sota eshom ngon botil, nayponta ira shima similja ni sebit, jet idi bimengis iren showa, na‐abak sota temel ni mola jet eg timoloy ya dimames. ");
INSERT INTO ibl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sota eshom ngon botil, nayponta shima mapteng nga bo‐day jet simimit et kimabay. Idi dimames ma ira, ẃaray nandames ni tedon polo, ẃaray nandames ni enem ma polo, tan ẃara pay i nandames ngo ni sandasos.” ");
INSERT INTO ibl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jet intobtob nen Jesus ey, “Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan.” ");
INSERT INTO ibl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Idi a‐abos to, inbag‐an nonta sawal ni showen apostol to tan sota eshom pay si Jesus no ngarantoy olog nonta arig ja inkowan to. ");
INSERT INTO ibl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Simongbat si Jesus ja kowan to son si‐kara ey, “Si‐kayo nin i naypalobos ja on‐awat so ni maypangkep nonta pantoshayan nen Apo Shiyos. Nem sota eshom, arig bengat i pengitoshok son si‐kara, ");
INSERT INTO ibl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","say no angken isi‐ning sha, eg sha imatonan sota inon‐an sha, jet angken itenengan sha, eg sha amtay olog to. Ta baka man‐odi ira son Apo Shiyos et mepekawanan i basol sha. ");
INSERT INTO ibl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“I‐olog ko niman sota arig ga inkowan ko la. Nem nasshaawak tep eg jo shagos ineẃatan i olog to. No eg jo eẃatan iyay ya arig, toy pesing jo ngarod ja mengeẃat ni eshom ma arig? ");
INSERT INTO ibl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Say olog nonta arig ga inkowan ko la, sajay. Sota botil ja pan‐iẃaris nonta too shi oma, may‐eshig ey esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sota nayponta‐an ni botil ja shalan, si‐katoy kay‐eshigan nonta ira toon naykowanan ni esel nen Apo Shiyos, nem idi itenengan sha, ondaw alin shagos si Satanas ja to dingdingen sota esel la naytoro son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Sota nayponta‐an ni botil la kabato‐an, si‐katoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos ja emati ni sanka‐atikan. No itenengan to, ẃaren shagos i imdeng ton mengeẃat, nem eg may‐a‐det shi nemnem to. Isonga magenon ibi‐jag to no onmotok ali sota digat to, ono okesen ni too maypangkep ni in‐awat to so ni esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sota nayponta‐an ni botil ja similja ni sebit, si‐katoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos met laeng, ");
INSERT INTO ibl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nem say toka nemnemnema, sota pesing ton manbiyag, sota ekanas sa biyag ni baknang, tan sota kompormin toka kamkamkami. Jet anongosto ma ey medingding sota esel nen Apo Shiyos son si‐kato, jet enshi may mapteng nga pantongpalan to. ");
INSERT INTO ibl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sota nayponta‐an ni botil ja mapteng nga bo‐day, si‐kato ngoy kay‐eshigan nonta toon engitneng ni esel nen Apo Shiyos jet toka eẃata. May‐eshig ey sajay ira, ẃaray dames sha: ẃaray nandames ni otik, ẃaray nandames ni kalaingan, tan ẃaray nandames ni eshakel.” ");
INSERT INTO ibl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kowan pay nen Jesus ey, “Apay al‐en jo aya i kingki et sa‐keban jo ni timba ono idoong jo shi katiri? Ayshi met: ipa‐tok jod ekayang. ");
INSERT INTO ibl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","May‐a‐mot i sakey ya banag say ma‐okat met laeng nem sakey ya akew; sota eg ma‐amta‐an niman, sigoradon ma‐amta‐an ali. ");
INSERT INTO ibl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan.” ");
INSERT INTO ibl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Inkowan to pay ey, “Singpet jon itenengan iya naka pan‐ikowan, tep sota joka penokat, si‐kato ngoy penokat nen Apo Shiyos no mengi‐kan son si‐kayo, ono sodokan to pay. ");
INSERT INTO ibl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sota toon mengitneng tan memati, metod‐an pay. Nem sota toon endedamsis to, ja eg memati, angken sota ootik ka amta to, ma‐enshi pay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Inkowan mowan nen Jesus ey, “Say kay‐eshigan nonta pantoshayan nen Apo Shiyos, inges to iyay. May‐eshig shi toon engi‐sek ni botil shi bo‐day. ");
INSERT INTO ibl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sota too, ema‐okip nem medebi jet kaonbangon nem meẃa‐ẃa, jet sota botil la in‐esek to, simimit asan ma kekabay, ey eg dimbaotan nonta too i kepesing nonta botil la mandeka niyay. ");
INSERT INTO ibl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sota bo‐day, si‐katoy mengipedemes ni mola: emepangdo nin sota bolong to, asan kebosbos, jet medowem may dames to. ");
INSERT INTO ibl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nem angken eg to eẃatan na emin, no medowem sota dames to, eni‐en to tep simabi ma sota timpo ni pan‐eni.” ");
INSERT INTO ibl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Intoloy nen Jesus ey, “Itnengiyo iya ikowan kon kay‐eshigi ni pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","May‐eshig nodta botil ni sakey ya kalasin mola. Sajay ya botil, no may‐a‐sek shi bo‐day, ootilik ka pasiya, ja enshiy kay‐ingesan ni ka‐ootik to shiya dobong, ");
INSERT INTO ibl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","nem no onba‐deg, si‐katoy kabalkan so ni emin na mola. Say pangeto, ebadeg et mebedin na man‐obong iray titit, shima pangpangeto, ja sotan i pansishoman sha.” Sajay day inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","No mebedin ni totoon eẃatan, angken pigen arig i inkowan nen Jesus son si‐kara ja kait da iren ja arig ja inkokowan to la. ");
INSERT INTO ibl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enshiy eshom ma intoro to so ni karakdan na totoo nontan na timpo, nem eg arig ni olay. Nem idi abos sha so nonta ira too to, in‐olog ton emin son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Idi mama‐shem mala nontan met laeng nga akew, inkowan nen Jesus so nonta ira too to ey, “Eti, ondaw kitejo shima shemang niya baybay.” ");
INSERT INTO ibl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jet siya, indekjas sha ma sota eshakel la totoo. Si Jesus, ka‐onong nodta bangka ja tinongawan to nontan. Jet ẃara pay iray kait ton bangka ja nay‐olop son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Idi maramen eman‐ekad sota bangka ja ondaw nodta shemang, ebiglen kimedsang i shagem nodta baybay, nakol ni kepanshespega ni shadoyon sota bangka ingkatod eshogi‐an ja emankepno sota bangka ni shanom. ");
INSERT INTO ibl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Si Jesus, ẃara nodta obet ni bangka ja na‐ogip shi kotson, isonga sha binengon, ja kowan sha ey, “Apo! Ngantoy! Shanshani kito men metey, ey eg mokito sintilen!” ");
INSERT INTO ibl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bimangon si Jesus et inkowan to so nonta makedsang nga shagem ey onsalsheng, tan inkowan to so nonta shadoyon ey, “Enog! Salsheng ka!” Jet simalsheng nga agpayso sota shagem jet timalna men kosto sota baybay. ");
INSERT INTO ibl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Inkowan ma nen Jesus so nonta ira too to ey, “Ngantoy? Entakot kayo? Ayshi pay laeng aya i pamatiyo?” ");
INSERT INTO ibl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Etakot iren pasiya; kowan sha ni sakey tan sakey son si‐kara ey, “Sipa emo iyay ya too? Toka pesalsheng iray shagem tan shadoyon et shaka pati‐a!” ");
INSERT INTO ibl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Intoloy shen bimaliw et mimotok ira nodta dogad ja kowan sha ey Girgasa. ");
INSERT INTO ibl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Idi koston simekbit si Jesus ja edapo did ma bangka, inaspol ni sakey ya dakin eman‐engaw ja pingketan ni dimonyo. Sajay ya too, edapo did kamposanto, tep nodtan i toka pan‐i‐iyani. ");
INSERT INTO ibl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Istay ya shaka bedbedora iyay ya too nontan da, nem niman, angken kolkolong i pemedod sha, toka ketdanga ni olay. ");
INSERT INTO ibl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Eminshakel la binedod sha iyay ya too ni karina tan kolkolong, nem toka ketketdanga ni olay sota kolkolong ja shaka pemedod son si‐kato, tan toka sheshala sota karina. Enshiy toon maka‐inges son si‐kato ja on‐abak so. ");
INSERT INTO ibl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kalebi‐an man ono ka‐akawan, eman‐eka‐ekad ja kaonkelkeljaw shima kamposanto tan shima shonshontog, jet toka sogsokata i bakdang to shorog ni bato. ");
INSERT INTO ibl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Idi naybetaw pay laeng si Jesus son si‐kato, inon‐an nontan na toon eman‐engaw. Bintik toy kad‐an nen Jesus ja to simbi, jet nantalimokod shi sango‐an to. ");
INSERT INTO ibl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Si Jesus, kowan to ey, “Si‐kam ma dimonyo, ilekjas mo ita too!” Jet sota too, inkedsang toy keljaw to, ja kowan to ey, “Jesus! Si‐kam ma Anak nen Apo Shiyos ja Kangeto‐an! Ngantoy pesing mo ma son si‐kak? Pangaasim, karamak shosa‐en!” ");
INSERT INTO ibl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jet si Jesus, inbag‐an to, ja kowan to ey, “Sipay ngaran mo?” Kowan nonta too ey, “Say ngaran ko, si Dinibo, tep eshakel kamin pasiya.” ");
INSERT INTO ibl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","11","Nontan met laeng, ẃara iray eshakel la keshel la naybolos nodtan na shontog. Jet sota toon pingketan nonta dimonyo, emekika‐kaasi son Jesus ey eg to peki‐nan ira sota dimonyo shima kad‐an sha, ");
INSERT INTO ibl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","jet kowan sha ey, “Palobosim kami ka ja man‐a‐tan so nima keshel la naybolos, say onpeket kami son si‐kara!” ");
INSERT INTO ibl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jet inpalobos nen Jesus. Jet sota ira dimonyo, indekjas sha sota too et pimeket ira nodta eshakel la keshel. Jet sota ira keshel, namtik iren nan‐ekas shima shepdas et dimened ira shi baybay. (Say karakel ira nonta keshel, ondaw wa showen dibo.) ");
INSERT INTO ibl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sota ira toon istay emanbantay so ira niyay ya keshel, kinano‐an shen inparemag sota epasemak shi siyodad tan shima eshom ma kait sha. Jet sota toon engitneng niyay ya shamag, dimaw ira ali et sha inon‐an no ngarantoy epasemak. ");
INSERT INTO ibl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jet simbires Jesus, tan sota toon istay pingketan ni dinibon dimonyo, ja mimapteng may nemnem to. Timongaw ja nanbaro ma. Jet timakot iren emin. ");
INSERT INTO ibl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jet sota ira para bantay ni keshel ja engasas ni inpan‐etan ni dimonyo, inkowan shay inpasing nen Jesus ja inpabtik so ni dimonyo. ");
INSERT INTO ibl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jet sota ira too nodtan na dogad, kowan sha son Jesus ey no mebedin koma, idekjas to sotan na dogad sha. ");
INSERT INTO ibl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Isonga si Jesus, nandogan shi bangka et emanda‐da‐jat ma. Nem sota toon istay pingketan ni eshakel la dimonyo, inbag‐an tos Jesus nem mebedin na mekidaw son si‐kato nodta bangka. ");
INSERT INTO ibl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nem si Jesus, eg to intolok. Inkowan et nen Jesus son si‐kato ey, “Akad ka, mo ikowan so ni kagajem mo i mapteng nga inpasing nen Apo Shiyos, ja engi‐kan ni kaasi to son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jet sota toon mimapteng, imakad jet to insodsod so ni totood siyodad ni Dikapolis i kaskasshaaw wa dingka nen Jesus son si‐kato. Jet nasshaaw wa emin ira sota engikowanan to. ");
INSERT INTO ibl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nandogan si Jesus shi bangka et bimaliw shima naymamang nga kilig ni baybay. Jet sota eshakel la too, esa‐nop ira son Jesus nodta kilig ni baybay ja nandisaagan to. ");
INSERT INTO ibl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jet nontan, ẃara ngoy mimotok alin too ja si Jairo i ngaran to, ja pangolo ni baley ya sa‐nopan ni Hodiyos. Idi inon‐an tos Jesus, nantalimokod shi sango‐an nen Jesus, ");
INSERT INTO ibl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ja kowan to ey, “Pangpangaasim apo, kay‐olop ka son si‐kak shi baley ko, ta sota anak kon bebii, emanpatpatey. Isonga pangaasim, mo isakpal i takday mo son si‐kato, say onpeteng et mebiyag.” ");
INSERT INTO ibl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Timolok si Jesus et ekidaw son si‐kato. Jet eshakel la pasiya i toon nay‐olop son si‐kara, ja eman‐i‐inipit shi shalan, nakol ni pati si Jesus, emanka‐ipit. ");
INSERT INTO ibl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jet ẃara ngoy sakey ya biin naydaok ja nanshala ni sampolo tan showen tawen. ");
INSERT INTO ibl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ebayag ga nansasa‐dat i eshakel la doktor ja engagas son si‐kato et kinasto ton emin i ẃara son si‐kato, nem enshi met i to dinekna ja to na‐agasan; nem ema‐ma et ngo mowan. ");
INSERT INTO ibl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sigod ja shinemag to i mapteng nga kepesing nen Jesus, isonga ekisikil la imonod son Jesus et pinishat toy baro nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tep sota bii, kowan tod nemnem to ey, “No pishaten kos Jesus, angken sama baro to bengat, onmaptengak ma.” ");
INSERT INTO ibl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jet siya, idi pinishat toy baro nen Jesus, simalsheng nga shagos sota toka pansheda, jet dinekna to ma ey na‐kal sota sakit to. ");
INSERT INTO ibl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nem idi koston pinishat toy baro nen Jesus, dinekna ngo nen Jesus ey ẃaray na‐agasan ja emirat son si‐kato. Nanposipos nodta kawa ira nonta eshakel la too et kowan to ey, “Sipay emirat niya barok?” ");
INSERT INTO ibl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kowan ira nonta too to son si‐kato ey, “Eshakel met ira ja totoo ja nandikmot son si‐kam et shakaka pan‐ipita pay, ey apay nga moka pan‐ibaga no sipay emirat son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nem inshemang nen Jesus ira sota toon nandikmot son si‐kato, ta toka pan‐enapa sota toon pimirat son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sota bii, emanbebayedbed ni takot to tep amta to sota inka‐ekas to ni inpirat to so nonta baro nen Jesus. Isonga nantalimokod shi sango‐an nen Jesus jet insodsod ton emin i podno son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jet kowan ma nen Jesus son si‐kato ey, “Anak ko, say minaptengan mo, sota pamatim son si‐kak. Daw ka ja ẃara may talna son si‐kam. Na‐kal ma ita sakit mo.” ");
INSERT INTO ibl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nonta marama ja pan‐ikowan nen Jesus iyay, ẃara diy inbetkag shen edapo nodta baley nonta pangolo ja emansekit i anak to, jet kowan nonta naybetkag so nonta pangolo ey, “Kosto. Angken eg mo odopen ita maistoro. Enshi met laeng i silbi ni idaw to tep etey sota anak mo.” ");
INSERT INTO ibl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nem si Jesus, intenengan to sota inkowan nonta too ey naksheng nga etey sota nga‐nga, jet inkowan to son Jairo ey, “Kareka manshanag; pamati ka bengat.” ");
INSERT INTO ibl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Idi naksheng iyay, say inpalobos ton may‐odop son si‐kato bengat, si Pedro tan si Santiago nen Juan ja san‐agi. ");
INSERT INTO ibl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jet idi mimotok ira nodta baley nonta pangolo, inon‐an nen Jesus ira sota totoon kaonnganogngog; ireka mannoteng nga pasiya ni nangis sha. ");
INSERT INTO ibl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Simekep si Jesus et kowan to son si‐kara ey, “Ngantoy? Kayoka mannoteng ni nangis jo? Eg etey itan na nga‐nga; na‐ogip bengat.” ");
INSERT INTO ibl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nem sota ira totoo, inbi‐ẃisan sha bengat si Jesus. Inpabo‐day to iren emin et say ebay‐an bengat ja intolok to, sota tedon too ton inodop to, pati sota ama tan ina nonta nga‐nga. Jet dimaw ira nodta naydaem ma kad‐an nonta nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inegni‐an toy takday nonta nga‐nga et inkowan to son si‐kato ni esel sha ey, “Talita komi!” (Say olog nonta inkowan to, “Ikowan ko son si‐kam anak, bangon ka!”) ");
INSERT INTO ibl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jet bimangon na shagos sota nga‐nga et nan‐akad, tep say tawen to, sampolo tan showa. Jet nasshaaw iren pasiya sota engoney so. ");
INSERT INTO ibl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nem kowan nen Jesus son si‐kara ey, “Karejo ikokowan shi eshom iyay ya epasemak niman. Akniyo et mango iya anak jo ni kenen to.” ");
INSERT INTO ibl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Idi naksheng iyay, imakad si Jesus shi ili to, jet inodop to ira sota too to. ");
INSERT INTO ibl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Shimanon i akew wa ngilin ni Hodiyos et en nantoro si Jesus shima sa‐nopan ni si‐karen Hodiyos. Jet sota ira too nodtan, ireka messhaaw nonta maypangkep ni toro to, ja kowan sha ey, “Towa emoy inamta‐an to so nima toka pan‐itoro? Toway inashalan to so niman na daing to? Ngaranto emoy inpasing ton dimaga so nima kaskasshaaw wa toka dagdag‐a? ");
INSERT INTO ibl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sajay emo met sota anak nonta kalapintiro! Aliẃa ayen si‐kato sota anak nen Maria? Amta tayo met sota ira a‐aki to ja si Santiago, Jose, Judas, tan si Simon. Tan iyay pay ired jay sota bibiin a‐aki to!” Jet sotan iren kaidiyan to, dinamsis sha si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nem si Jesus, kowan to son si‐kara ey, “Emin ira sota toon inbetkag ali nen Apo Shiyos, mebedin na mayshedjaw shi emin na ili. Nem shi mismon ili to bengat i eg to kayshedjawan, tan angken pay shi mismon partidos to tan pamilja to.” ");
INSERT INTO ibl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jet shima ili ton mismo, eg bedinan nen Jesus ja mandeka ni eshakel la milagro. Sajay bengat i dingka tod ma mismon ili to: ẃara iray ingkal ton sakit ni too ni toka pengisakpal ni takday to son si‐kara, nem aliẃen eshakel. ");
INSERT INTO ibl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jet nasshaaw si Jesus tep eg ira memati son si‐kato. Jet pinasiyal to sota ira kawad‐an ni too nodtan na dogad jet intod‐an to ira. ");
INSERT INTO ibl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sina‐nop ma nen Jesus ira sota shinotokan ton sawal ni showen apostol to et inkowan to ey ondaw iren sansheshedẃa shi eshom ma dogad. Jet kowan to son si‐kara ey, “Ipiyal ko son si‐kayo ey angken sama ira dimonyo ja pimeket shi totoo, mebedin na pebtik jo.” ");
INSERT INTO ibl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jet inparit toy panbedon sha ni mekan ono pilak, ono pengegnira ni bayong. Say inpalobos to bengat ja mebedin na itakin sha ket sota pengegnira ni sowan. ");
INSERT INTO ibl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Binidin to ira ey mansinilas ira, nem eg sha kono itakin i baron pansa‐datan sha. ");
INSERT INTO ibl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kowan to pay ey, “No sipay mengeẃis son si‐kayo, si‐katoy pan‐inan jo ni olay ingkatod pan‐a‐tan jod eshom ma dogad. ");
INSERT INTO ibl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nem no sota dogad ja motoken jo ket eg shakejo eẃaten, ono eg sha pati‐en i itoro jo son si‐kara, sota depok ja naypeket shi sediyo, pokpok jo nin asan joka ilekjas sotan na dogad. Ta si‐katoy pengamta‐an sha so ey enshi may bibiyang jo son si‐kara.” Kowan nen Jesus so nonta ira apostol to. ");
INSERT INTO ibl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jet sota ira too to, dimaw ira et nantoro ira nodta emin na dinadaẃan sha, ja inkowan sha so ni totoo ey manbebawi ira maypangkep ni basol sha. ");
INSERT INTO ibl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jet eshakel i inpabtik shen dimonyo ja pimeket shi totoo, jet pinojokan sha pay ni dana i eshakel la toon emanpansekit, jet inpamapteng sha ira. ");
INSERT INTO ibl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nontan na timpo, si Ari Hirodis, shinemag to sota maypangkep ni dingdingka nen Jesus, tep pan‐i‐etek ni karakdan na too si Jesus, jet kowan to ey, “Sajay ya shinemag kon too, sigosho si‐kato emo si Juan da ja para bonjag. Nanbiyag emo shi patey, isonga ẃaray panakabalin ton mandeka ni milagro.” ");
INSERT INTO ibl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nem say kowan ngo ni eshom, si‐kato si Elias ja para padto nonta bayag da, tan sota ira eshom pay, say kowan sha, si‐kato konoy para padto nen Apo Shiyos ja inges nonta nankepangdo len para padto nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nem si Hirodis, idi shinemag to sota maypangkep son Jesus, kowan to ey, “Sajay ya too, si‐kato da si Juan. Pinotolan koy toktok to, nem iyay mowan na nan‐ongal.” ");
INSERT INTO ibl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sajay i pan‐inemnem nen Hirodis tep mismon si‐katoy inpabono so nen Juan. Inpa‐shel to nontan et inpaibalod to, ta idi inesawa nen Hirodis si Hirodiyas ja aseẃa nen Felipe ja agi to, inkowan nen Juan so nen Ari Hirodis ey, “Parit shi bilin nen Apo Shiyos i pengesawam so nen Hirodiyas.” Isonga inpa‐shel nen Hirodis si Juan, ta pipiyan to si Hirodiyas. ");
INSERT INTO ibl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Si Hirodiyas, en‐og‐oges to si Juan, jet piyan ton bono‐en. Nem enshiy mebedin to, ");
INSERT INTO ibl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tep si Ari Hirodis, entakot to si Juan et toka ibaliẃi ni olay. Amta nen Hirodis ey si Juan, eshiyosan na too ja in‐apil nen Apo Shiyos ja mansilbi son si‐kato. Idi itenengan nen Hirodis i pan‐ikowan nen Juan, emandikat i nemnem to, nem piyan to met laeng karin mengitneng ni kowan to. ");
INSERT INTO ibl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nem idi sakey ya akew, ẃaray pinekan nen Ari Hirodis ja eshakel la totoo ni inpanbirthday to. (Sotan ira ineẃis nen Hirodis nontan, sota ira nankengaton toray ni gobirno, sota ira apo ni solsharo to, tan sota ira eshom ma pangolo ni probinsiya ni Galilia.) Jet nontan, inshingan nen Hirodiyas ja engipabono son Juan. ");
INSERT INTO ibl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tep nontan, nansada sota anak nen Hirodiyas ja marikit, jet eman‐i‐imdeng si Ari Hirodis tan sota ira naydikob son si‐kato. Kowan nen Ari Hirodis so nonta marikit ey, “Ngantoy kekshawen mo son si‐kak? Ikowan mo say i‐akan ko.” ");
INSERT INTO ibl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nansangba pay ja kowan to ey, “Angken ngantoy kekshawen mo son si‐kak, i‐akan ko! Angken kagoshowa niya ilin intorayan ko, i‐akan ko son si‐kam no si‐katoy kekshawen mo!” ");
INSERT INTO ibl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bimo‐day sota marikit et to simbi si ineto, jet inbag‐an to ey, “Ngarantoy kekshawen ko?” Simongbat si Hirodiyas ja ineto, ja kowan to ey, “Keshaw moy toktok nen Juan ja para bonjag.” ");
INSERT INTO ibl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jet sota marikit, aliston dimaw so nen Ari Hirodis et inkowan to ey, “Piyan kon i‐akan mo ali son si‐kak sota toktok nen Juan ja para bonjag; ipingkan mo di shi embanaw wa pingkan!” ");
INSERT INTO ibl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jet sota ari, naydaw‐an na pasiya ni inkowanan to so nonta kari to so nonta marikit. Nem mesepol la tongpalen to ta nankari ja intenengan pay nonta ira bisita to. ");
INSERT INTO ibl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Isonga engibetkag si Ari Hirodis ni solsharo ton kowadja ja en mengeda ni toktok nen Juan. Sota solsharo, dimaw ja to inokdo‐an si Juan nodta kad‐an tod badoran. ");
INSERT INTO ibl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jet sota toktok nen Juan, inpingkan to et in‐akan to so nonta biin anak nen Hirodiyas et to ngo in‐akan so nen ineto. ");
INSERT INTO ibl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Idi inamta‐an ngo nonta ira too nen Juan, sha inday bakdang to et sha indiyang. ");
INSERT INTO ibl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sota ira apostol nen Jesus ja inbetkag to, imoli ira di et esa‐nop ira son si‐kato. Jet insodsod sha son si‐katon emin sota dingdingkara tan intoro sha nodta dinawdaẃan sha. ");
INSERT INTO ibl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jet inkowan nen Jesus son si‐kara ey, “Eti, ondaw kitod sakey ya dogad ja abos tayo say man‐ibdey kayo ni otik.” Tep emansisina‐dat i eshakel la totoon kaonmotok nodta kad‐an sha; isonga ayshiy ẃaya shen angken mengan. ");
INSERT INTO ibl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jet siya, nandogan ired bangka et dimaw ma ira shima naydasin na dogad ja enshiy totoo. ");
INSERT INTO ibl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nem eshakel i toon engasas ni indaw sha la, jet inimatonan sha ira. Jet say inpasing ira nonta toon nankedapo shi eshakel la dogad, kinano‐an sha ngon nan‐akad, jet epangdo iren mimotok nodta dogad ja daẃan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Idi mandisaag si Jesus nodta bangka, inon‐an to ira sota eshakel la toon nay‐aspol et naysemekan na pasiya son si‐kara, ta say inpangidmang to son si‐kara, singa na‐na‐josan ira ja enshi malay namnama shen pansigshan. Singa sota kalniro iren nay‐oway ja enshiy emengajowan son si‐kara. Jet eshakel i intoro to son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Idi enasẃil malay akew, sota ira too nen Jesus, dimaw ira di son si‐kato jet kowan sha ey, “Apo, araẃi met iyay ya dogad shi kebalbaley, isonga pansisi‐jan mo ira jay ya totoo say ira di koma mengenap ni tongkalen shen kenen sha shima kad‐an ni totoo. Edabi met mala.” ");
INSERT INTO ibl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nem simongbat si Jesus ja kowan to ey, “I‐akniyo et ira ni kenen sha.” Kowan ma nonta too to ey, “Apay si‐kami aya i en menongkal ni kenen sha? Adipay banol ni showen dasos emoy kasto‐en mi!” ");
INSERT INTO ibl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kowan nen Jesus ey, “Pigen boknol la tinapay i ẃara son si‐kayo? Jo on‐i.” Sha binidang et inkowan sha son Jesus ey, “Dima, tan ima pay i showen piskaw.” ");
INSERT INTO ibl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jet inkowan nen Jesus so nonta ira totoo ey ontongaw ira, ja mandinasin konod eshakel la gropo, tep mapteng i edet nodtan. ");
INSERT INTO ibl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jet siya, ekalbat iren timongaw, ja sandedasos i ẃared sakey ya kalbat, tan imay sandi‐men polo shi eshom ma kalbat. ");
INSERT INTO ibl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jet si Jesus, inda to sota tinapay tan sota showen piskaw, intangkak tod naykayang jet nan‐iyaman son Apo Shiyos. Idi naksheng nga nan‐iyaman, shinowashowa to sota tinapay asan toka i‐kan so nonta ira too to, ja si‐karay mengiweshis so nonta ira eshakel la totoo. Jet inpaiweshis to mowan sota showen piskaw so ira nonta totoo. ");
INSERT INTO ibl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sota ira totoo, engan iren emin et napsel ira. ");
INSERT INTO ibl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Idi naksheng iren engan, inolnong ira nonta too nen Jesus sota ebay‐an ja eg kinan ira nonta totoo ja tinapay tan piskaw, jet say na‐olnong, sampolo tan showen baskit, ja nankepno. ");
INSERT INTO ibl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jet say kabebilang ira nonta totoo ja engan, dimen dibon daki, powira ira sota bibii tan a‐anak, ja eg naybilang. ");
INSERT INTO ibl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Idi naksheng iyay, inkowan nen Jesus so nonta ira too to ey, “Pandogan kayod ma bangka et angken mepangdo kayon ondaw shima shemang niya baybay, shima siyodad ni Bitsaida. Jet si‐kak, pansisi‐jan ko nin ira ja eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jet idi indekjas to ira, timiyed shima shontog ja en mansheẃat so nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jet edabi‐an nodtan ja a‐abos to. Nem sota bangka ja nandoganan ira nonta too to, imaraẃi ma nodta kilig ni baybay. ");
INSERT INTO ibl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inon‐an nen Jesus ey ireka mandikat ni shaka pan‐ekad shi baybay tep emansheshagem et nay‐aspol pay son si‐kara i shagem. Isonga idi daem, dimaw si Jesus son si‐kara ja nan‐akad shima tapew ni shanom. Istay dabsan to ira, ");
INSERT INTO ibl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nem sota ira too to, inon‐an sha ali ja eman‐ekad shima tapew ni shanom, jet kowan sha ey banig i inon‐an sha. Isonga kimeljaw ira, ");
INSERT INTO ibl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tep emin ira, ireka mankel‐ew ni in‐asas sha so. Nem si Jesus, imesel la shagos son si‐kara, ja kowan to ey, “Pesed! Karekayo ontakot, tep si‐kak iyay!” ");
INSERT INTO ibl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jet idi ekilokan ma ngos Jesus nodta bangka, simalsheng ma sota shagem. Sota too to, nasshaaw ira, ");
INSERT INTO ibl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tep eg sha pay laeng ineẃatan ey eg nagshengan i kabedinan nen Jesus, angken inon‐an sha sota inparakelan nen Jesus so ni tinapay. Etangkan pay laeng i nemnem sha. ");
INSERT INTO ibl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jet nontan, intoloy shen bimaliw et simabi ira nodta nayshemang nga dogad ja kowan sha ey Ginisarit. Jet insinged sha sota bangka. ");
INSERT INTO ibl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Idi kima‐jat ira nodta kilig ni baybay, inimatonan ira nonta totoo nodtan na dogad ey si Jesus, ");
INSERT INTO ibl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","jet nansisi‐jan sota ira totoo ja dimaw nodta kedogadogad ja sha al‐en sota ira emanpansekit. Jet sota shemagen shen kad‐an nen Jesus, si‐katoy pengidawan sha ni toon emanpansekit. ");
INSERT INTO ibl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Angken toway daẃan nen Jesus nontan — shi siyodad, shi baryo, ono shi angken nganton kawad‐an ni too — ẃaren kenshat i emaysespa ja totoon emansekit, jet kinshaw sha ni olay son si‐kato ey no mebedin, angken sota kajaran ni baro to i pishaten sha say onmapteng ira. Jet emin sota ira emirat son si‐kato, mimapteng ira. ");
INSERT INTO ibl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sota ira Parisiyo tan sota eshom so nonta ira mamaistoro ni dinteg ni Hodiyos ja edapod Jerusalem, ira nay‐aspol son Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inon‐an sha sota eshom so nonta too nen Jesus ja ireka mengan ey eg ira nin nanbolo, jet shaka pan‐inemnem ey edogit mala iren too. ");
INSERT INTO ibl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tep emin na Hodiyos — agdalo iray Parisiyo — ampet manbodo ira nin asan ireka mangan, tep shaka patkin pasiya sota ogadin inbangon ni apo sha nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No mepeẃil ired malkaro, ampet odsan shay bakdang sha asan ireka mangan, ta shaka ibilang ey ẃaray edogit ta naypeket son si‐kara alid malkaro ja kawad‐an ni eshakel la totoo. Eshakel pay i shaka on‐onora ja ogadira: kaspangarigan sama ira maypangkep ni ki‐ẃan ni tasa, takori, tan kambang. ");
INSERT INTO ibl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Isonga inbag‐an ira nonta Parisiyo tan mamaistoro ni dinteg si Jesus, ja kowan sha ey, “Apay nga sama ira toom ket eg sha pati‐en sota sigod ja ogadi nonta bayag da? Ireka mengan ey eg ira nin manbodo.” ");
INSERT INTO ibl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Si Jesus, sinongbatan to ira ja kowan to ey, “Si‐kayo ngon toon kowan to ey ẃara son Apo Shiyos ni emin na poso to nem ẃaray pangkep jon ngaaw! Agpayso ey si‐kayo sota kaytoshongan nonta padto nen Isaias nonta bayag da ja esel nen Apo Shiyos met laeng, ja kowan to ey, ‘Sajay iren too, shi bongot bengat i engintegan ni shaka panshedjaw son si‐kak, nem shi nemnem sha, araẃi son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enshiy silbi ni shaka panshedjaw son si‐kak, tep say shaka itodtoro ni olay, sota edapo met laeng shi nemnem ni si‐karen too, asan sha mango ikowan ey bilin kono nen Apo Shiyos.’ Kowan ni esel nen Apo Shiyos ja naypadto. ");
INSERT INTO ibl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Jet si‐kayo, joka ibiyang sota koston bilin ja edapo son Apo Shiyos, ey joka et ngo mowan nemnemnema i ogadi ni too!” ");
INSERT INTO ibl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Inkowan pay nen Jesus son si‐kara ey, “Kayoka takal ja mengibiyang ni koston bilin ja edapo son Apo Shiyos, say kowan jo ey ki‐detan joy ogadiyo! ");
INSERT INTO ibl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kaspangarigan say sakey ya bilin nen Apo Shiyos ja joka ibiyang, sota kowan to ey, ‘Shayaw mo si amam tan si inam’, tan sota kowan to pay ey, ‘Sota toon ngaaw i toka ikokowan so nen ameto ono si ineto, kenshat ta mebono.’ ");
INSERT INTO ibl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nem si‐kayo, say joka itoro, kowan jo ey mesepol la ibiyang ni too si ameto ono ineto, no ikowan to ma son si‐kara ey, ‘Sota istay i‐akan ko son si‐kayo ja panbiyag jo koma, si‐kato ma niman sota kowan sha ey Korban, tep indasin kon maytodong shi Timplo.’ ");
INSERT INTO ibl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","No sotan i ikowan ni too son ameto ono si ineto, joka iparit i penodong to ma son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Isonga sajay ya joka pengonod ni ogadiyon joka itoro, inpaskit jo nodta koston bilin nen Apo Shiyos, ja singa enshiy silbi to. Jet aliẃen sajay bengat, no diket eshakel i kait niyay ya ngaaw wa joka dagdag‐a ni olay!” ");
INSERT INTO ibl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jet si Jesus, tina‐ẃal to ira sota totoo ey ondaw ira di son si‐kato jet kowan to son si‐kara ey, “Itnengi jon emin iyay ya ikowan ko son si‐kayo jet awatiyo. ");
INSERT INTO ibl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kowan ira nonta Parisiyo ey basol kono no eg kito manbodo asan mangan, ja si‐katoy ondogit so ni nemnem. Nem aliẃen sota ikem‐ot jod bongot ja tetdenen jo i ondogit son si‐kayo, no diket say ondogit so ni too, sota esel ton emedepo did poso to tan nemnem to. ");
INSERT INTO ibl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan.” ");
INSERT INTO ibl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Idi bintawan nen Jesus sota eshakel la totoo, ja simekep nodta baley, insho‐pet nonta ira too to no ngarantoy olog nonta arig ga inkowan to la. ");
INSERT INTO ibl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jet si Jesus simongbat ja kowan to ey, “Apay angken si‐kayo, eg kayo maka‐aw‐awat? Apay eg jo amta ey sota maykem‐ot shi bongot ket eg mebedin na si‐katoy ondogit so ni nemnem ni too? ");
INSERT INTO ibl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tep eg met manshedan shi poso, no diket say daẃan to, shi ekes, jet onbo‐day met laeng.” (Say sakey ya kaytoshongan niyay den inkowan nen Jesus, eg mesepol la mengidin i angken nganton mekan.) ");
INSERT INTO ibl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jet intoloy nen Jesus ey, “Say agpayson kaondogit ni too, sota esel ton emedepo did poso to tan nemnem to. ");
INSERT INTO ibl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta say kedepo‐i ni ngaaw wa pangkep ni too, shi nemnem to. Isonga ẃaray ememii tan emekileki, ");
INSERT INTO ibl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ẃaray emengibot, ẃaray ememono, ẃaray emengamkam ni kompormi, tan ẃaray toon maledamsis. Isonga ẃara pay iray emenaol ni kait to, ẃaray toon enshiy baing ton mandeka ni angken nganto, ẃaray ma‐epal, ẃaray emenomang ni kait to, ẃaray edastog, tan ẃara pay iray eshom ma mandeka ni ekalkalasin dokodokon aramid. ");
INSERT INTO ibl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Emin ira jay ya ngaaw, nankedapod nemnem ni too jet sotan iray kaondogit ni too ja mankebol ni panbesolan to.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nontan ma si Jesus, indekjas to sotan na dogad jet dimaw shi sakey ya dogad ja nay‐esop shi siyodad ni Tira. Kowan to ey manpokok nin shi sakey ya baley shiman, nem eg mebedin. Inamta‐an shagos ni totoo nodtan ey ẃares Jesus, ");
INSERT INTO ibl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","jet ẃaren shagos i simabi alin bii ja aliẃen Hodiyos ja poli nonta sigod ja too nodtan na dogad. Sajay ya bii, ẃaray anak ton bii ja pingketan ni dimonyo; isonga idi shinemag to ey ẃares Jesus, dimaw ali et nantalimokod shi sango‐an nen Jesus et ekika‐kaasi son Jesus ey pebtik to sota dimonyon pimeket nodta anak to. ");
INSERT INTO ibl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Say songbat nen Jesus son si‐kato, in‐aknan to ni arig, ja kowan to ey, “Mepekan koma nin i a‐anak. Aliẃen nebeng ja nak pekeẃas sota istay para a‐anak ja i‐akan ko so ni aso.” ");
INSERT INTO ibl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nem ineẃatan nonta bii sota arig to, jet kowan to ey, “Owen niti apo, amtak ita kowan mo. Nem angken sota ira aso shima naydoong ni damisaan, mebedin met ja manbiyag ira nonta ema‐kas shi damisaan na kepengani ni a‐anak!” ");
INSERT INTO ibl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Simongbat si Jesus so nonta bii ja kowan to ey, “Kostoy songbat mo. Angken on‐akad ka ma niman, tep bimetik mala sota dimonyo ja pimeket nodta anak mo.” ");
INSERT INTO ibl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jet idi mimotok sota bii shi baley to, simbi to sota anak ton emansheshokol shi katiri ja mimapteng ma. Namtik da sota dimonyon istay pimeket son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Idi nan‐oli si Jesus ja edapo did ma dogad ja kasekopan ni Tira, shindan toy Sidon asan ma manshalan nodta naykawa ni dogad ja kowan sha ey Dikapolis, ingkato nodta baybay shi Galilia. ");
INSERT INTO ibl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jet in‐ilaw ni too son si‐kato i sakey ya toon etoleng tan eg metongolan na polos i esel to. Jet shineẃat sha son Jesus ey pishaten to kono say onmapteng. ");
INSERT INTO ibl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Si Jesus, to indasin sota etoleng nga too, ja bintawan sha sota eshakel la too, jet idi showa bengat ira, indolot nen Jesus i kalomot to shi showen tangida nonta etoleng. Timopsha si Jesus et pinishat toy shila nonta etoleng, ");
INSERT INTO ibl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","asan ma ketangkak shi naykayang. Ngimed‐as si Jesus jet kowan to so nonta etoleng, ni esel shen Hodiyos ey, “Ipata!” (Say olog nonta inkowan nen Jesus, “Kalokati ka!”) ");
INSERT INTO ibl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sotan ey mebedin men mantetneng sota istay etoleng, jet kasta met sota toka pandikat ja on‐esel: mapoot may toka pan‐a‐sel. ");
INSERT INTO ibl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jet kowan ma nen Jesus so nonta ira totoo ey, “Karejo ikokowan iyay so ni angken sipa.” Nem angken intalengteng nen Jesus i bilin son si‐kara, ey eg sha pa‐amta shi eshom, mas pay et ja inshamashamag sha sota kaskasshaaw wa dingka to. ");
INSERT INTO ibl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jet nasshaaw wa pasiya sota ira totoo, jet kowan sha ey, “Emin na kedagdag‐a nen Jesus, mapteng. Angken sota ira nanketoleng, toka pantetneng, tan sota nanka‐omel, toka pa‐sel.” ");
INSERT INTO ibl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nontan na timpo, esinop mowan i eshakel la totoo, jet na‐bosan ira ni kenen sha. Tina‐ẃal nen Jesus ira sota too to jet kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naka kaasi‐i ira ja totoo, ta tedon akew sha niman ja ẃared jay son si‐kak jet enshi may kenen sha. ");
INSERT INTO ibl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jet no pa‐ekad ko ira ja eg nin mengan, baka onkapoy ira shi shalan.” ");
INSERT INTO ibl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jet sota ira too nen Jesus, kowan sha ey, “Toway en pengal‐an ni maypekan so iren ja eshakel la totoo? Enshi met i baley shiyay ya dogad.” ");
INSERT INTO ibl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jet si Jesus, kowan to son si‐kara ey, “Pigen boknol la tinapay sota ẃara son si‐kayo?” Simongbat ira ja kowan sha ey, “Pito.” ");
INSERT INTO ibl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jet si Jesus, inkowan to so nonta ira totoo ey ontongaw ira nodta bo‐day. Inda to sota piton boknol la tinapay et nan‐iyaman so nen Apo Shiyos asan toka showashowa‐a. In‐akan to so nonta ira too to say si‐karay mengiweshis so nonta ira totoo, jet tinongpal sha. ");
INSERT INTO ibl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jet ẃara pay i piskaw, nem aliẃen eshakel. Nan‐iyaman mowan si Jesus son Apo Shiyos, jet inkowan to so ira nonta too to ey iẃaris sha ngo sota piskaw so ira nonta eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jet emin ira sota eshakel la totoo, engan ira et napsel iren emin. Jet idi naksheng ira, sina‐nop sha sota ebay‐an ja eg sha kinan et ondaw wa piton baskit. ");
INSERT INTO ibl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sota engan nontan, ondaw wa epat ta dibo. Jet nontan ma, inpa‐ekad to ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jet si Jesus, pati sota ira too to, ira nandogan shagos nodta bangka jet dimaw ired ma dogad ja sakop ni Dalmanota. ");
INSERT INTO ibl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sota ira Parisiyo, dimaw ira so nen Jesus ja sha peshasen ni dedamsis sha. Isonga kowan sha son si‐kato ey mandeka ni milagro ja kowan sha ey asanan sha so no podnon inbetkag ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nem si Jesus, ngimed‐as sa pasiya, asan toka ikowan ey, “Apay nga sajay ira maramen too niman ket shaka pan‐ibaga sota kowan sha ey asanan sha so no si Apo Shiyos i podnon engibetkag son si‐kak ali? Agpayso iya ikowan ko son si‐kayo. Enshiy milagro ja en maypa‐sas son si‐kayo niman.” ");
INSERT INTO ibl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sajay i kowan nen Jesus asan toka ira ilekjas. Nandogan mowan shi bangka et dima‐jat iren ondaw nodta shemang ni baybay. ");
INSERT INTO ibl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nem dinibkan sha gayam ja engita‐jon ni balon sha. Say intakin sha bengat nodta bangka ket sakey ya boknol la tinapay. ");
INSERT INTO ibl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jet si Jesus, binidin to ira ja kowan to ey, “Tanshaaniyo sota singa para debag ni tinapay ja ẃara so nonta ira Parisiyo tan so nen Ari Hirodis.” ");
INSERT INTO ibl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nem sota ira too nen Jesus, ireka mansosongbat bengat, ja kowan sha ey, “Dinibkan tayo eshan ja engita‐jon ni balon tayon tinapay.” ");
INSERT INTO ibl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Si Jesus, indasin to ey sotan i shaka pansosongbati et kowan to son si‐kara ey, “Apay nga kayoka mansosongbat ni ka‐enshi ni balon jo? Apay eg jo pay laeng eẃatan aya? Apay etangken pay laeng i nemnem jo? ");
INSERT INTO ibl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Itan i matejo; apay nga eg jo asen? Itan i tangidayo; apay eg kayo aya onteneng? Dinibkan jo aya? ");
INSERT INTO ibl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nonta inosal ko sota dimen boknol la tinapay ni inpamakan ko nonta ira dimen dibon too, pigen baskit ja nankepno i sina‐nop jo ja binay‐an sha?” Kowan sha ey, “Sawal ni showa.” ");
INSERT INTO ibl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kowan pay nen Jesus ey, “Jet nonta inosal ko sota piton boknol la tinapay ni inpamakan ko nonta ira epat ta dibon too, pigen baskit ja nankepno i sina‐nop jo ja binay‐an sha?” Kowan sha ey, “Pito.” ");
INSERT INTO ibl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jet kowan nen Jesus ey, “Jet eg jo pay laeng eẃatan?” ");
INSERT INTO ibl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mimotok ira maled Bitsaida et shiman, in‐ilaw ni tood man i toon ekorab son Jesus jet inshawat sha son Jesus ey pishaten to kono say ma‐kal sota korab to. ");
INSERT INTO ibl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Shineẃat nen Jesus sota ekorab et inshalan to led naydasin nodtan na kawad‐an ni totoo. Tinopsha‐an toy mata nonta ekorab, asan toka isakpal i takday to so nonta ekorab. Jet inbag‐an to nem ẃaray toka ishemang. ");
INSERT INTO ibl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Idi bikaten nonta ekorab i mateto, kowan to ey, “Owen — ẃaray naka ishemang nga too, nem singa kiyew i naka pengesas son si‐kara. Nem eman‐ekad.” ");
INSERT INTO ibl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pinishat nen Jesus mowan i mata nonta ekorab, jet idi onmorag sota ekorab, na‐kal la pasiya sota korab to et mapoot i toka pengesas. ");
INSERT INTO ibl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jet inpa‐ekad nen Jesus sota istay ekorab, ja kowan to ey, “Eg ka nin on‐oli shima edapo‐an ta di.” ");
INSERT INTO ibl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Si Jesus tan sota ira too to, dimaw ira nodta sakop ni Sisaria Pilipos, jet idi ẃara ired shalan, inbag‐an to ira sota too to, ja kowan to ey, “Ngarantoy kaikowan ira ni totoo ni maypangkep son si‐kak? Eg sha aya pantatabalan nem sipa‐ak?” ");
INSERT INTO ibl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jet sota ira too to, simongbat ira ja kowan sha ey, “Eg met nan‐i‐inges i shaka ikowan. Say kowan ni eshom, si‐kam kono si Juan ja para bonjag ja etey da, nem sota ira eshom, kowan sha ey si‐kam si Elias ono sakey so nonta ira eshom ma para padto nonta bayag da ja nan‐ongal mowan ali.” ");
INSERT INTO ibl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jet si Jesus, inbag‐an to mowan ira ja kowan to ey, “Jet si‐kayo ngay? Ngaranto ngoy kowan jo ni maypangkep son si‐kak?” Simongbat si Pedro ja kowan to ey, “Si‐kam sota inpadtora nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan.” ");
INSERT INTO ibl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jet si Jesus, binidin to iren pasiya ey eg sha ikokowan ni angken sipa ey si‐kato sota naypadto nonta bayag da ja mengisedakan. ");
INSERT INTO ibl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jet manshoki ma nontan, kaipinpinshowa nen Jesus so nonta ira too to ey siyen si‐kato sota naypadton Anak ni Too, nem mesepol met laeng nga manda‐kam ni eshakel la digat, ta sota ira pangolo ni Hodiyos, tan sota ira apo ni papashi, tan mamaistoro ni dinteg, bedawen sha kono, jet anongosto ma ey bono‐en sha. Nem kowan to ey no maykatdon akew, manbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Indiritso ton inkowan na emin ira jay; enshiy polibas to. Jet nontan ma, si Pedro, to indasin si Jesus et inseg‐ang to tep inkowan to ey mebono. ");
INSERT INTO ibl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nem nanposipos si Jesus et insi‐ning to iray too to, asan toka ngo iseg‐ang si Pedro, ja kowan to ey, “Betawimak, si‐kam ma Satanas! Say nemnem mo, aliẃen sota plano ja nemnem nen Apo Shiyos, no diket sota etoo‐an na nemnem.” ");
INSERT INTO ibl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tina‐ẃal to ira sota eshakel la totoo, pati sota ira too to, jet inkowan to son si‐kara ey, “No sipay makapiyan ja on‐onod son si‐kak ja manbedin ni took ni olay, mesepol la si‐kak bengat i nemnemnemen to, ja ibiyang ton emin i kompormi. Tan mesepol la enosan to pay ya angken maybebaing ono mebono ja inges to sota toon emasan ni koros ja kaydansa‐an to shorog. ");
INSERT INTO ibl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sota toon entapi toy biyag to ja kowan to ey ensikshal la metey maypangkep son si‐kak, si‐kato et ngo mowan i mepokaw i biyag to. Nem sota toon eg to kaẃanan i bakdang to maypangkep son si‐kak, ono sota mapteng nga shamag ja maypangkep son si‐kak, si‐kato et ngo mowan i i‐aknan nen Apo Shiyos ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","No kaspangarigan ey kinokowa ni sakey ya too i emin na ẃared ja dobong, enshiy silbi nontan na kinokowa to, no eg to kon‐oren sota biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Enshiy silbi nontan na inpasing to, ta sotan na biyag i epateg ga pasiya, ja enshiy to kaysa‐datan na angken nganto. ");
INSERT INTO ibl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","No sota toon embaing nga mengikowan ey si‐kato ket took, ono embaing nga mengikowan ni esel ko no maydaok shi totoon eg mannemnem so nen Apo Shiyos tan toon mabesol, ibaing ko ngo sotan na too no ondawak alin mantoshay. Agpayson si‐kak sota kowan nonta para padto nonta bayag da ey Anak ni Too, jet sotan alin idaw ko mowan, say kasesaad ko, inges ko met laeng i kasesaad nen Apo Shiyos. Tan may‐odop ali sota ira anghil to son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jet kowan pay nen Jesus ey, “Agpayson ẃaray eshom son si‐kayod jay ja eg metey ingkatod asen sha sota pantoshayan nen Apo Shiyos, jet ebadeg ga pasiya aliy panakabalin nen Apo Shiyos no timpo alin ketongpalan to.” ");
INSERT INTO ibl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Idi ẃaray enem ma akew ja edabas da ni engikowanan nen Jesus niyay, inodop to si Pedro, si Santiago, tan si Juan, jet timiyed ira ni a‐abos sha shima shontog ga ekayang. Jet idi mimotok ira nodtan, inon‐an shen nanbaliw i itsora to ja emenenili. ");
INSERT INTO ibl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jet sota baro to, emandining nga pasiya, tan empotin pasiya, ja enshiy to kay‐ingesan na kapoti‐an na baro shiya dobong ja inpapoti ni too. ");
INSERT INTO ibl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jet nanpa‐sas ma si Elias nen Moises, jet ireka mekitabtabal so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jet si Pedro, kowan to son Jesus ey, “Apo, mapteng i kawasha tayod jay. Kosto gayam nem mengemag kami ni tedon kampod jay: sota sakey para son si‐kam, sota sakey para son Moises, tan sota sakey para so nen Elias.” ");
INSERT INTO ibl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Sajay i inkowan nen Pedro tep eg to am‐amtay ikowan to; ta epaladoy takot ira nonta tedon too nen Jesus ja inodop to.) ");
INSERT INTO ibl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jet nontan, dimespag aliy kolpot jet dinikopan nonta kolpot ira. Jet ẃaray esel ja edapo nodtan na kolpot ja intenengan sha, ja kowan to ey, “Sajay i Anak ko jet ensemek ko. Isonga patiyon emin i ikowan to.” ");
INSERT INTO ibl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jet idi ireka manmodimodi, enshi met i eshom ma ẃara nodtan, no diket si Jesus bengat i kait sha nodta shontog. ");
INSERT INTO ibl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jet idi ireka manshedong ja edapo nodta shontog, binidin nen Jesus ira sotan na tedon too to ey eg sha ikokowan so ni eshom, ja angken sipa, sota inon‐an sha nonta ẃara ired ma shontog. Jet inkowan to ey asan shaka ikowan iyay nem man‐ongal ma ali sota kowan sha ey Anak ni Too. ");
INSERT INTO ibl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jet sotan iren too to, pinatira iyay ya inbilin nen Jesus, nem shaka met laeng tabtabala shorog nem ngarantoy piyan nen Jesus ja a‐selen nonta inkowan ton “pan‐ongal ma ali”. ");
INSERT INTO ibl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jet sota ira too to, inkowan sha son Jesus ey, “Say toro nonta mamaistoro ni dinteg, kowan sha ey mepangdo alis Elias asan ma sota naypadto nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan. Jet ngantoy ya sajay?” ");
INSERT INTO ibl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Simongbat si Jesus, ja kowan to ey, “Owen, agpayso ja si Elias nin aliy mepangdo jet si‐katoy mengi‐odi nonta kimapoy ya pamati ni totoo say onkedsang ma. Nem ima pay i sakey ya padto maypangkep nonta kowan sha ey Anak ni Too: mesepol konon da‐kaman toy eshakel la digat tan dedamsis ni totoo. ");
INSERT INTO ibl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nem iyay i ikowan ko son si‐kayo maypangkep mowan nonta inbaga jo. Si Elias, naksheng alin dimaw, jet dingkara son si‐kato i kompormin kedsel la ninemnem sha. Tep sotan met laeng i naypadto nonta bayag da ja mepesamak son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Idi mimotok shi Jesus ja edapo ali nodta shontog, simbira sota ira too ton tinaynan sha, ja dinikmot gayam ni eshakel la totoo. Tan ẃaray mamaistoro ni dinteg ja emekisongsongbat son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dimibag ira sota eshakel la too ni in‐asas sha so nen Jesus ja emanmotok. Nan‐o‐odop da iren en mengaspol son Jesus, jet inkowan sha ey ebadeg i imdeng sha ni inmotok to. ");
INSERT INTO ibl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Inbag‐an nen Jesus ira, ja kowan to ey, “Ngantoy joka pansosongbati nonta ekay?” ");
INSERT INTO ibl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Imesel may sakey ya toon ẃara nodtan na karakdan, ja kowan to ey, “Apo, in‐ilaw ko ali son si‐kam iya anak kon daki, ta ẃaray dimonyon kaonsabi son si‐kato ni olay et si‐katoy kabol la eg to pan‐a‐selan. ");
INSERT INTO ibl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No onsabi sota dimonyo, toka bigla‐en to‐dangen shi bo‐day, jet eman‐o‐osab i bongot to, ey toka panngedetnget i sangi to, tan kaonkenkenteg. Inkowan ko so nita toom ey pebtik sha sota dimonyo, nem eg sha met binaalan.” ");
INSERT INTO ibl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jet si Jesus, kowan to ey, “Enshiy pamatiyo eshan! Ebayagak met shiyay ja eman‐enos son si‐kayo, nem eg jo pay laeng pati‐en i panakabalin nen Apo Shiyos! Ilaw jo did jay son si‐kak sota nga‐nga.” ");
INSERT INTO ibl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","In‐ilaw sha sota nga‐nga son Jesus et idi inon‐an nonta dimonyon pimeket nodta nga‐nga si Jesus, inpankenkenteg to sota nga‐nga. Jet eto‐dang sota nga‐nga, ja emanpodipodig, ey eman‐o‐osab i bongot to. ");
INSERT INTO ibl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Inbag‐an nen Jesus sota ama ni nga‐nga, ja kowan to ey, “Pigan i nanshogi‐an niyay?” Simongbat sota ameto, ja kowan to ey, “Nanshogi nonta ka‐ootik to pay laeng. ");
INSERT INTO ibl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eminpigen kepeshasa nonta dimonyo ja bono‐en: toka ikespig shi apoy ono shi shanom. Nem no baalan mo iyay, kaasi‐i jokami et tolongi jokami.” ");
INSERT INTO ibl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kowan nen Jesus ey, “Singa kowan mo ey ekak emo baalan? Sota toon ememati son Apo Shiyos, kabedinan ton emin i angken nganto.” ");
INSERT INTO ibl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sotan ma ey inkedsang nonta ama ni nga‐nga i esel to, ja kowan to ey, “Naka memati, nem tolongimak shi naka pankodangi!” ");
INSERT INTO ibl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Idi inon‐an nen Jesus ja emankai‐sop sota eshakel la totoo son si‐kato, sinelkag to sota dimonyo, ja kowan to ey, “Si‐kam ma dimonyo ja kabol la eg pantetnengan tan eg pan‐a‐selan niya nga‐nga, ikowan ko son si‐kam, betik ked ta nga‐nga, jet kareka ma on‐oli‐oli son si‐kato!” ");
INSERT INTO ibl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kimeljaw sota dimonyo, asan toka pankenkenteg mowan sota nga‐nga, asan kabetik mala. Jet singa etey i inpangidmang nonta totoo so nonta nga‐nga. Isonga kowan ni karakdan son si‐kara ey, “Ayshi — etey da.” ");
INSERT INTO ibl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nem shineẃat nen Jesus et inpa‐tan to. Jet imetan nga agpayso sota nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Idi onsekep da si Jesus nodta baley, ey abos sha mala shi naydaem, inbag‐an ira nonta too to, ja kowan sha ey, “Apay nga eg mi binaalan na inpabtik nontan sota dimonyo so nontan na nga‐nga?” ");
INSERT INTO ibl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kowan to son si‐kara ey, “Eg mebedin na pebtik ira jay ya kalasin dimonyo nem eg kita nin mansheẃat ni tolong so nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Indekjas sha ma sotan na dogad ja kawad‐an sha, jet nanshalan ira shi Galilia. Eg piyan nen Jesus ja amta‐an ni totood man ey ondabas ira, ");
INSERT INTO ibl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tep ẃaray toka pan‐itoro nontan so nonta ira too to, ja kowan to ey, “Si‐kak sota kowan ni para padto nonta bayag da ey Anak ni Too, nem may‐eẃatak so nonta ira toon makakontra son si‐kak, jet si‐karay memono son si‐kak. Nem no maykatdon akew ni ibono sha‐ak so, manbiyagak met laeng.” ");
INSERT INTO ibl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nem eg sha ineẃatan iyay ya kowan nen Jesus. Piyan shen ibaga nem ngarantoy olog niyay ya inkowan to, nem embaing iren mengibeka. ");
INSERT INTO ibl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idi mimotok ira shi Kapirnaom, dimaw ira shima baley ya shaka pan‐iyani. Jet inbag‐an nen Jesus sota ira too to, ja kowan to ey, “Ngaran nonta joka pantabtabala shi shalan ali?” ");
INSERT INTO ibl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nem eg sha sinongbatan, tep say tabtabal sha ni shaka pan‐ekad ket ireka mansosongbat no sipa son si‐kara i kangeto‐an. ");
INSERT INTO ibl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Timongaw si Jesus et tina‐ẃal to ira sota sampolo tan showa ja apostol to, jet kowan to son si‐kara ey, “No sipay too ja piyan ton si‐katoy mandesin ni shayaw, mesepol la panbedin toy bakdang to ja kabeba‐an tan man‐obda ni pansigshan ni kait to.” ");
INSERT INTO ibl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jet ena‐ẃal si Jesus ni sakey ya nga‐nga jet inpaledjat to nodta nankinaw‐an ira nonta too to, jet idi inakẃal to sota nga‐nga, kowan to so nonta too to ey, ");
INSERT INTO ibl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“No sipa ken too ja mapteng i pesing mo so ni inges niyay ya nga‐nga maypangkep ni semek mo son si‐kak, si‐kak met laeng i tinoshong nonta inpasing mo. Jet no si‐kak i pesingan mo so ni mapteng, say toshongen nonta dingkam, si Amak ja engibetkag son si‐kak ali.” ");
INSERT INTO ibl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kowan nen Juan ey, “Apo, ẃaray inon‐an min too ja emengosal ni ngaran mo say onbetik iray dimonyo ja pimeket shi totoo. Jet inpasalsheng mi tep aliẃen kait tayo.” ");
INSERT INTO ibl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nem kowan nen Jesus ey, “Karejo iparit i i‐osal to so ni ngaran ko. Ta no i‐esel towak ni sakey ya too, ey metongpal i milagron dag‐en to, enshiy pesing ton onsomang son si‐kak nem sakey ya akew. ");
INSERT INTO ibl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","No sipa sota eg makakontra son si‐katejo, si‐katoy kait tayo. ");
INSERT INTO ibl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Agpayso iyay ya ikowan ko son si‐kayo. Sota toon mengi‐kan son si‐kayo ni angken santasen shanom ja inomen jo, ta amta to ey si‐kak i makatoo son si‐kayo, sotan na toon mengi‐kan ni shanom, sigoradon ẃaray kon‐oren to ali ja i‐akan nen Apo Shiyos son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nem sota istay mengi‐kan ni panbesolan ira niya nankebaben emati son si‐kak, say panmaptengan nontan na too ket ma‐ono‐an koma ni ebadeg ga bato et en mayteb‐ok shima debeng nga baybay. Sotan i panmaptengan to ta engka‐jas sotan na keshosa to nem say sota penosa nen Apo Shiyos son si‐kato ja pengikesho to no istay itoloy ton panbesol sota kait to. ");
INSERT INTO ibl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Isonga no bilang ey sota sakey ya takday mo ket si‐katoy mengi‐kan ni panbesolan mo, potol mo. Ta no pa‐onong mo, si‐katoy kaypedawan mod impiyarno ja kawad‐an ni apoy ya eg ma‐ma‐shep ingkatod ingka. Mapmapteng sota ka‐enshi ni sakey ya takday mo, no sotan i kesalbaran mo. ");
INSERT INTO ibl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Shima impiyarno, eg metmetey sota ira bigis ja emengan so ni totood man, tan eg ma‐ma‐shep sota apoy.) ");
INSERT INTO ibl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jet no sota sakey ya sedim ket si‐katoy mengi‐kan ni panbesolan mo, potol mo. Ta no pa‐onong mo, si‐katoy kayteknalan mod impiyarno. Mapmapteng sota ka‐enshi ni sakey ya sedim, no sotan i kesalbaran mo. ");
INSERT INTO ibl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Shima impiyarno, eg metmetey sota ira bigis ja emengan so ni totood man, tan eg ma‐ma‐shep sota apoy.) ");
INSERT INTO ibl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kasta met sota sakey ya matam: no si‐katoy mengi‐kan ni panbesolan mo, okit mo et ibong mo. Ta no pa‐onong mo, si‐katoy kayteknalan mod impiyarno. Mapmapteng sota ka‐enshi ni sakey ya matam, no si‐katoy kayda‐kaman mod pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Shima impiyarno, eg metmetey sota ira bigis ja emengan so ni totood man, tan eg ma‐ma‐shep sota apoy. ");
INSERT INTO ibl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ta emin na totoo, ma‐esinan ira ni apoy. ");
INSERT INTO ibl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Isonga iyay i ibanshaan ko son si‐kayo. Say asin, mapteng. Nem no ma‐enshiy pait to, ja entemnay ma, eg jo mebedin na imowan i pait to. “Epateg ga pasiya i pan‐i‐inawatan jon took; isonga mesepol la ma‐esinan kayo ni olay.” ");
INSERT INTO ibl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Indekjas nen Jesus i Kapirnaom et dimaw nodta sakop ni Jodia ja ẃared baliw ni ebadeg ga pa‐dok ja kowan sha ey Jordan. Jet nontan, eshakel mowan na pasiya i totoo ja esa‐nop son si‐kato, jet intod‐an to ira, tep si‐katoy toka pesing ni olay. ");
INSERT INTO ibl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nontan, ẃara ngo aliy dimaw son si‐kato ja Parisiyo, jet kowan sha ni dedamsis sha ey peshasen sha si Jesus. Isonga kowan sha ey, “Ngantoy moka pengi‐odog ni dinteg tayon Hodiyos maypangkep ni pengisi‐jan ni aseẃa? Bolos aya i pengisi‐jan ni daki so ni aseẃa to?” ");
INSERT INTO ibl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Simongbat si Jesus, ja kowan to ey, “Ngaran ni inbilin nen Moises son si‐kayo ja koston dag‐en jo?” ");
INSERT INTO ibl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kowan sha ey, “Intolok nen Moises i pengisi‐jan ni daki so ni aseẃa to. Basta i‐amagan tos aseẃa to ni solat ja isepa to son si‐kato asan toka tayni.” ");
INSERT INTO ibl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nem si Jesus, kowan to son si‐kara ey, “Say kabol la sotan i insolat nen Moises, etangken i nemnem jo. ");
INSERT INTO ibl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nem aliẃen satan nonta pinalsowa nen Apo Shiyos i too, tep say naysolat nonta bayag da maypangkep niyay, kowan to ey, ‘Manshoki nonta pilmiro, pinalsowa nen Apo Shiyos i daki tan bii.’ ");
INSERT INTO ibl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jet inbilin to, ja kowan to ey, ‘Ma‐alsa sota daki so nen ameto tan ineto et may‐a‐shom so nen aseẃa to. ");
INSERT INTO ibl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jet sota showen bakdang, may‐eshig ma ey nansaksakey.’ Sajay i bilin nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Inpansaksakey nen Apo Shiyos i san‐aseẃa; isonga enshiy nebeng ni toon mengisi‐jan ni aseẃa to.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Idi simekep da si Jesus nodta baley, inbag‐an mowan ira nonta too to ni maypangkep ni si‐jan. ");
INSERT INTO ibl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jet simongbat si Jesus, ja kowan to ey, “No sipay daki ja mengisi‐jan ni aseẃa to, ey mengesawa mowan ni apil la bii, nanbasol nodta epangdon aseẃa to ja inges to sota emii. ");
INSERT INTO ibl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tan kasta met sota bii: no isi‐jan to sota aseẃa to ngon daki, ey mengesawa mowan ni apil la daki, nanbasol met laeng ja inges to sota ekileki.” ");
INSERT INTO ibl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sota eshom iren too, indaw shay angken na nga‐nga son Jesus, ta kowan sha ey say pishaten ton bindisiyonan ira. Nem sota ira too nen Jesus, inseg‐ang sha ira sota engidaw ali so nonta a‐anak. ");
INSERT INTO ibl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nem idi inon‐an nen Jesus iyay, ngaaw i dekna to, jet inkowan to son si‐kara ey, “Baybay‐iyo ira di sota a‐anak ja ondaw ali son si‐kak; eg jo iparit. Tep inges iren jay ya a‐anak bengat ja ekombaba i mayda‐kam shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Podno iya ikowan ko son si‐kayo. No eg kayo mengeẃat ni pantoshayan nen Apo Shiyos ja inges toy kepengeẃat ni a‐anak, eg kayo mayda‐kam ja onsekep shi pantoshayan nen Apo Shiyos.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jet inakẃal nen Jesus sota ira a‐anak, jet binindisiyonan to ira ni insakpalan to so ni takday to. ");
INSERT INTO ibl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Idi emanda‐jat si Jesus ja ondaw shi daẃan to, nanbetik aliy sakey ya too ja nantalimokod shi sango‐an nen Jesus, ja kowan to ey, “Maistoro, mapteng ken too. Isonga ikowan mo ga no ngarantoy dag‐en ko say meẃad‐anak ni biyag ja enshiy to engintegan.” ");
INSERT INTO ibl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Simongbat si Jesus ja kowan to ey, “Ngantoy mosoka ikowani so ey maptengak? Abos nen Apo Shiyos ja mapteng. ");
INSERT INTO ibl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nem no maypangkep nonta biyag ja enshiy to engintegan ja inbagam, amtam sota ira bilin nen Apo Shiyos: ‘kareka memono, kareka memii ono mekileki, kareka mengibot, aliẃen mo ba‐ngaten ja man‐a‐sel ni aliẃen kosto, kareka menaol ni kait mo; tan shayaw mos inam tan amam.’ ” ");
INSERT INTO ibl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kowan nonta too ey, “Apo, nontan pay laeng nga‐nga‐ak ingkato niman, inonod kon emin itan na bilin nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jet si Jesus, insi‐ning to sota too jet nasmekan so nen si‐kato, jet kowan to ey, “Wara pay laeng i sakey ya kolang mo. Daw ka, mo ilekon emin sota kokowam et sota dako to, iweshis mo so nonta ira nankebiteg. No sajay i pesing mo, maytedo shi dangit i kabaknang mo. Jet no meksheng nga sotan i pesing mo, kay‐eshom ka di so ira niya took!” ");
INSERT INTO ibl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nem idi intenengan nonta too iyay ya inkowan nen Jesus, na‐josan na pasiya jet namtik ja ensakit i nemnem to, tep toka tepi‐a i kabaknang ton pasiya. ");
INSERT INTO ibl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jet si Jesus, inpan‐eta‐etan toy mateto so ira nonta too to et kowan to son si‐kara ey, “Edigat ja onsekep i baknang shi pantoshayan nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nasshaaw ira sota too to ni inkowanan to so niyay. Nem inpinshowa nen Jesus mowan, ja kowan to ey, “Si‐kayon naka ikarin singa annak ko, emandikat ta kenshat i angken sipen too ja onsekep shi pantoshayan nen Apo Shiyos — nem mas edigdigat pay so ni baknang. ");
INSERT INTO ibl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sota animal la kowan sha ey camel, no kas‐anoy kalikat to ja on‐osok shi ebot ni shakom, mas edigdigat pay ya onsekep i bebaknang shi pantoshayan nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jet nasshaaw iren pasiya jet kowan sha son Jesus ey, “No kasta, enshi ngarod i maysedakan?” ");
INSERT INTO ibl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Simongbat si Jesus ja kowan to ey, “Agpayson eg kabaalan ni toon mengisedakan ni bakdang to shorog, nem mebedinan nen Apo Shiyos. Tep si Apo Shiyos, kabaalan ton emin.” ");
INSERT INTO ibl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Idi inkowan nen Jesus iyay, imesel ma si Pedro, ja kowan to ey, “Karam ngo dibdibkan ey si‐kami ket indekjas min emin i kokowa mi nonta nanbalinan mi ni toom!” ");
INSERT INTO ibl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jet si Jesus, kowan to ey, “Podno iya ikowan ko son si‐kayo. No sipay engilekjas ni baley to, a‐aki to, annak to, bo‐day to, ono sota maka‐anak son si‐kato, kabol ni inpamati to ni bilin ko ono kabol ni pengitosho to so nonta mapteng nga shamag maypangkep son si‐kak, ");
INSERT INTO ibl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ebadbadeg ga pasiya i eẃaten to: angken niman na kawasha tod ja dobong, manbedin ni sandasos i baley to, a‐aki to, ineto, annak to, bo‐day to. Tan no man‐onod alin akew, kon‐oren to pay i biyag ja enshiy to engintegan. Nem pedigaten ngoreshan ni toon eg makakosto son si‐kak ni saja maramen biyag niman. ");
INSERT INTO ibl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nem eshakel ira sota kowan sha ey si‐karay mandesin i eẃaten sha, ja kina‐agpayso to ket ootik kari. Wara et ngo mowan i kowan ni karakdan ey ootik i eẃaten sha, nem eshakel kari.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Idi nonta eman‐ekad si Jesus tan sota ira too to, ja ondaw shi Jerusalem, epangdo ni ootik si Jesus. Jet sota ira kaon‐onod son si‐kato, naykel‐eẃan ira; entakot ira tep ireka mantoshong shi Jerusalem. Inpata‐nil nen Jesus ira sota sampolo tan showa ja apostol to et a‐abos sha ma. Jet insigod ton inkowan son si‐kara i mepesamak ali son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ja kowan to ey, “Itnengi jo iya ikowan ko son si‐kayo. Agpayson si‐kak sota kowan ira nonta para padto nonta bayag da ey Anak ni Too. Nem no onmotok kitod Jerusalem, may‐eẃatak ma so nonta ira apo ni papashi tan mamaistoro ni dinteg ja makakontra son si‐kak. Jet sotan may timpo ja pengikowanan sha ey mebono‐ak koma. I‐awat sha‐ak so nonta ira too ja aliẃen kait tayon Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jet si‐karay memebaing son si‐kak; toptopsha‐an sha‐ak pay et sepsepdaten sha‐ak, asan sha‐ak ma bono‐a. Nem no maykatdon akew, pan‐ongal towak met laeng nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jet nontan, si Santiago nen Juan, ja san‐agin anak nen Sibidi, dimaw ira son Jesus, jet inkowan sha son si‐kato ey, “Apo, iyay i kekshawen mi son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jet si Jesus, kowan to son si‐kara ey, “Ngantoy piyan jon dag‐en ko para son si‐kayo?” ");
INSERT INTO ibl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kowan sha ey, “No mantoshay ka di, piyan min mekitoshay ngo son si‐kam. Itodok mokami ja ontongaw i sakey shi petek ni kanawan mo et sota sakey, ontongaw shi petek ni kanigid mo.” ");
INSERT INTO ibl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kowan nen Jesus ey, “Joka ba‐ngatay baga ey eg jo nin nemnemen. Wara aliy tasen napno ni digat jet mesepol la nak inomen. Kabaalan jo ayen mengenos ja meki‐inom nontan? Wara aliy bonjag ja onsabi son si‐kak ja epaladon pasiya; kabaalan jo ayen mengenos ja mekibonjag son si‐kak?” ");
INSERT INTO ibl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Simongbat ira ja kowan sha ey, “Mebedin na enosan mi.” Jet kowan ma nen Jesus ey, “Agpayson mekila‐kam kayo ni da‐kaman ko di. ");
INSERT INTO ibl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nem sota itongaw jo shi petek ni kanawan ko, tan kanigid ko, aliẃen si‐kak i mengigsheng so. Sajay, para so nonta ira sigod ja insagana‐an so nen Amak.” ");
INSERT INTO ibl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Idi intenengan ira nonta kait shen sampolo ja apostol nen Jesus iyay ya keshaw, ngaaw i deknara son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nem si Jesus, tina‐ẃal to ira jet kowan to son si‐kara ey, “Amtayo met i kepesing ira nonta toon emaybidang ey toray ni kompormin ili, tan sota eshom ma toon nankengatoy saad sha. Shaka ipakat i saad sha, ni shaka pengitoshay met laeng so ni sinekopan sha. ");
INSERT INTO ibl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nem no si‐kayo, aliẃen inges nontan i pesing jo so ni sakey tan sakey son si‐kayo. Sota kowan to ey si‐katoy kangeto‐an son si‐kayo, mesepol la si‐kato et ngo mowan i mengibeba ni bakdang ton man‐obda ni pansigshan ni kait to. ");
INSERT INTO ibl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jet sota piyan ton si‐katoy mandesin son si‐kayo, mesepol la panbedin toy bakdang to ni baga‐en jon emin. ");
INSERT INTO ibl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta kinapodno to, angken si‐kak ja naypadto nonta bayag da ey Anak ni Too, ekak dimaw ali ja pansilbi‐an ni karakdan, no diket dimawak ali say mansilbi‐ak son si‐kara. Tan say sakey pay ya dinaẃan ko di, say itolok koy bakdang kon metey, tep si‐katoy kaysedakanan ni eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mimotok ira shi Jiriko, jet idi nonta shaka pan‐idekjas i Jiriko, eshakel la pasiya sota totoon imonod son si‐kato tan sota ira too to. Jet nodta kalsara, ẃaray toon timongaw nodta naykilig ja emankekkekshaw. Say ngaran to, si Bartimeo ja anak nen Timeo. ");
INSERT INTO ibl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Idi intenengan to sota kowan ni totoo ey si Jesus ja i‐Nasarit i ondabas ali, inkedsang toy esel to, ja kowan to ey, “Jesus! Kaasi‐imak, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nem sinelkag nonta eshakel la too, ja kowan sha ey, “Eka‐eket ka!” Nem mina‐ma to et ja inkedsang toy keljaw to, ja kowan to mowan ey, “Kaasi‐imak, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kimi‐neng si Jesus et kowan to ey, “Tawal jo alid jay.” Jet tina‐ẃal sha sota ekorab, ja kowan sha ey, “Pan‐imdeng ka, ta tokaka panta‐ẃala. Etan ka.” ");
INSERT INTO ibl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Inẃalsis nonta ekorab sota insala‐ẃaki ton baro to et dinektit toy etan, jet dimaw so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jet inbag‐an nen Jesus, ja kowan to ey, “Ngarantoy piyan mon itolong ko son si‐kam?” Kowan nonta ekorab ey, “Apo, pan‐asas mowak, say man‐esasak mowan.” ");
INSERT INTO ibl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kowan ma nen Jesus son si‐kato ey, “Sota pamatim son si‐kak, si‐katoy kabol la pan‐esasan mo. Angken on‐akad ka ma.” Jet nontan, nan‐asas sa shagos sota ekorab, jet nay‐eshom ma son Jesus ded kalsara. ");
INSERT INTO ibl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nonta nay‐esop ma shi Jesus shi Jerusalem ja ẃara ira shima dogad ja kowan sha ey Bitpag tan Bitania, ja osshong ni shontog ga kowan sha ey Olibas, engibetkag si Jesus ni showen too ton mepangdo, ");
INSERT INTO ibl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","jet inbilin to son si‐kara ey, “Daw kayod ma dogad ja naysongbob et no onmotok kayo, ẃaren shagos i asen jon kilaw ni animal la donkey, ja naypagod. Sajay ya kilaw, eg pay laeng ekabkabajo‐an. Okasiyo et alejo did jay. ");
INSERT INTO ibl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No ẃaray mengibeka son si‐kayo no ngantoy joka pan‐okasi so, ikowan jo ey, ‘Si Apo Jesus, mesepol to jet pai‐odi to met laeng alin shagos.’ Satan da i ikowan jo son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jet siya, dimaw ira sota shadẃa et simbira nga agpayso sota donkey ja naypagod shi kalsara ja nay‐askang shi sakepan ni sakey ya baley, jet inokasan sha. ");
INSERT INTO ibl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jet naytompong nga ẃaray too nodtan et kowan sha so nonta shadẃen too nen Jesus ey, “Ngantoy? Joka pan‐okasi ita kilaw?” ");
INSERT INTO ibl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jet insongbat sha sota inbilin nen Jesus ey isongbat sha, jet intolok ira nonta engibeka son si‐kara i i‐ala sha so nonta kilaw. ");
INSERT INTO ibl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jet indaw sha sota kilaw son Jesus et sota ta‐kep ni baro sha, in‐ap‐ap sha nodta beneg ni donkey et nankabajo si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sota ira ngo eshakel la totoo, in‐ap‐ap sha ngoy baro sha nodta kalsaren panshalnan nen Jesus. Sota ira eshom, ira engala ngo ni emolong nga panga ni kadasan et in‐ap‐ap sha nodta kalsara. ");
INSERT INTO ibl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sota ira totoo ja epangdo ey si Jesus, tan sota ira na‐onod, ireka onkaneljaw, ja kowan sha ey, “Salamat son Apo Shiyos tep inbetkag to di iya toon mengisedakan! Bindisiyonan to koma! ");
INSERT INTO ibl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iyay ali sota toon naypadto nonta bayag da ey mengibengon ni inpantoray nen Ari David ja apo tayo da! Bindisiyonan nen Apo Shiyos i pantoshay to di! Salamat son Apo Shiyos ja Kangeto‐an!” ");
INSERT INTO ibl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Idi mimotok si Jesus shi Jerusalem, simekep nodta Timplo, jet idi naksheng nga inon‐an ton emin i ẃared bo‐dayan ni Timplo, nan‐o‐odop si Jesus tan sota ira sampolo tan showen apostol to, jet dimaw ired Bitania, tep edabi ma. ");
INSERT INTO ibl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Idi agsapa, ja eman‐ekad si Jesus ja edapo ali shi Bitania, naytompong nga na‐agang nontan. ");
INSERT INTO ibl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Inon‐an tod naybetaw i kadasan na emolong. Dimaw say to on‐an nem ẃaray sepolen ton dames to, nem idi onsabi, enshi gayam i dames to; bolong bengat i ẃara. Tep aliẃen timpon idames to. ");
INSERT INTO ibl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jet kowan to ey, “Si‐kam ma kadasan, manipod niman ingkatod ingka, polos sa enshiy en namtan ni too ja dames mo!” Jet intenengan ira nonta too to iyay ya inkowan to. ");
INSERT INTO ibl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nay‐oli ired Jerusalem et dimaw mowan si Jesus nodta Timplo. Jet emin ira sota emandeko nodtan, tan emenongkal, shinagshag to iren inpabo‐day. Jet tino‐to‐dang to pay ira sota damisaan ira nonta emena‐dat ni pilak, tan sota tongawan ira nonta emandeko ni kalopati. ");
INSERT INTO ibl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jet eg to intolok i pengegshi ni kompormin dako shi bo‐dayan ni Timplo. ");
INSERT INTO ibl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jet intod‐an to ira ja kowan to ey, “Say kowan nonta esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey sajay ya baley nen Apo Shiyos, nayngadnan ey si‐katoy pansheẃatan ni emin na totoo son si‐kato, nem inpanbalin jo et ni singa amotan ni tolisan!” ");
INSERT INTO ibl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Shinemag ira nonta apo ni papashi ni Hodiyos tan mamaistoro ni dinteg ni Hodiyos iyay et pineshas shen enganap ni pesing shen memono son Jesus, tep ireka manshanag ey si Jesus i kabol ni eg sha ma so ira pati‐an ni karakdan kabol ni na‐awisan sha nonta toka pan‐itoro. ");
INSERT INTO ibl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Idi shanshani men medebi, si Jesus tan sota ira too to, bintikan shay siyodad ni Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Idi nonta agsapa mowan ja shaka pankedabasi nodta kadasan na enshiy dames to, inon‐an shen nakkit ta emin sota kadasan, pati damot to. ");
INSERT INTO ibl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ninemnem nen Pedro sota inkowan da nen Jesus so nonta kadasan et kowan to son Jesus ey, “Apo, asas mo kari! Nakkit sota kadasan na in‐abigan mo.” ");
INSERT INTO ibl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Simongbat si Jesus ja kowan to ey, “Pamati kayo son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Agpayso iya ikowan ko son si‐kayo. Angken sipen too, no memati son Apo Shiyos ey tongpalen to sota ishawat to son si‐kato, ja enshiy showashowa to, sigoradon eg nagshengan i mebedin ton dag‐en. Mebedin na ikowan to niyay ya shontog ey ma‐tan shorog ja ondaw shima baybay et mayto‐to‐ẃen medeka. ");
INSERT INTO ibl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","No ngantoy ibaga jo so nen Apo Shiyos, eẃaten jo, no enshiy showashowa jo nonta panakabalin ton mengi‐kan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Jet no maramen kayoka mansheẃat son Apo Shiyos, ey ẃaray nemnemen jon eg jo kosto ja inpasing ni eshom son si‐kayo, mesepol la pekawanan jo sotan na too, say si Apo Shiyos ja Amejo shi dangit, pekawanan to ngoy nanbasolan jo. ");
INSERT INTO ibl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nem no eg jo pekawanan ira sota toon ẃaray nanbasolan sha son si‐kayo, si Apo Shiyos ja Amejon ẃared dangit, eg tokejo ngo pekawanan ni nanbasolan jo.” ");
INSERT INTO ibl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Idi mimotok ma ira mowan shi Jerusalem, dimaw shima Timplo, jet idi emanpasiyal si Jesus shima bo‐dayan ni Timplo, en simbi nonta ira apo ni papashi tan sota mamaistoro ni dinteg tan sota ira eshom ma pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kowan sha son si‐kato ey, “Sipay engikowan ey dag‐en mo ira ta moka dagdag‐a shiya Jerusalem? Sipay engibetkag son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Simongbat si Jesus ja kowan to ey, “Ibag‐an takejo nin, jet no songbatan jo ni kosto iya salodsod ko, mebedin na ikowan ko son si‐kayo no sipay engibetkag ali son si‐kak ja mandeka niyay. ");
INSERT INTO ibl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ikowan jo son si‐kak nem sipay engibetkag so nen Juan ja en memonjag nontan — nemnem to ngo shorog, ono inbetkag ali nen Apo Shiyos? Songbati jowak ka.” ");
INSERT INTO ibl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nem sota ira pangolo ni Hodiyos, nantatabtabal ira ja kowan sha ey, “No ikowan tayo ey si Apo Shiyos, mesampolo kito tep ikowan to ey, ‘No kasta, apay nga eg jo ngarod pinati si Juan?’ ");
INSERT INTO ibl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nem no isongbat tayo ey nemnem ngo nen Juan, ngaranto ma?” (Ta sota ira pangolo ni Hodiyos, entakot sha ira sota karakdan na totoo tep shaka pati‐en pasiya ey si Juan ket podnon inbetkag ali nen Apo Shiyos ja para padto.) ");
INSERT INTO ibl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jet say songbat sha so nen Jesus, kowan sha ey, “Taẃey, eg mi amta no sipay engibetkag so nen Juan ja memonjag.” Jet kowan ma nen Jesus ngo son si‐kara ey, “Angken si‐kak ngo, ekak ikowan son si‐kayo no sipay engibetkag son si‐kak ja mandeka niya naka dagdag‐a niman.” ");
INSERT INTO ibl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Si Jesus, in‐arigan to sota ira totoo, ja kowan to ey, “Waray toon nanmola ni obas shi embanaw wa gardin to; inedad to, tan engaot ni kaysespa‐an nonta shapidan ni obas, tan engitowen pay ni baley ya kowadja‐an. Inpa‐ajowan to so ni eshom et dimaw ma shi araẃin ili. ");
INSERT INTO ibl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Idi simabi sota timpon pekibingay to nonta obas, engibetkag ni baga‐en ton en mengeda nonta bingay to so nonta ira engajowan. ");
INSERT INTO ibl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nem sota engajowan, sinepsepdat sha et sota baga‐en na inbetkag nonta makakokowa nonta bo‐day, tan inpa‐odiren enshiy sha in‐akan. ");
INSERT INTO ibl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sota makabo‐day, engibetkag mowan ni sakey ya baga‐en to, nem pineg‐as shay toktok to, asan shaka bebaingi pay. ");
INSERT INTO ibl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Engibetkag sota makabo‐day ni baga‐en to mowan, nem saja inbetkag ton maykepintedo, binonora. Inpantataned nonta makabo‐day i eshakel la inbetkag to, nem sinepdat shay eshom, ey binonoray eshom. ");
INSERT INTO ibl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Idi anongosto ma, sakey bengat ma i ebay‐an na ibetkag to, ja anak ton mismo, ja ensemek ton pasiya, jet si‐kato may inbetkag to, ja kowan to ey, ‘Mebedin emon ibaingan sha iya anak ko.’ ");
INSERT INTO ibl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nem idi mimotok sota inbetkag to ja mismon anak to, kowan et nonta ira engajowan ni tabtabal sha ey, ‘Sajay met sota anak nonta makakokowa niya gardin na tayoka pan‐obda‐i. Bono‐en tayo et say saja bo‐day ya teẃiren to koma, kokowa‐en tayo ma.’ ");
INSERT INTO ibl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Binonora nga agpayso sota anak nonta makabo‐day nontan et inbo‐day sha nodta alad nonta gardin.” Kowan nen Jesus ni arig to. ");
INSERT INTO ibl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jet nontan ma, kowan nen Jesus ey, “Nganto emoy pesing nonta makakokowa nontan na bo‐day so nonta ira toon inpangajowan to? Simpri ondaw ali et bono‐en to ira jay ya too ngo, jet ipiyal to sota bo‐day to so ni eshom ma mengajowan so. ");
INSERT INTO ibl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Eg jo amten mengi‐odog aya nonta esel nen Apo Shiyos ja naysolat nonta bayag da? Kowan to met ey, ‘Sota baton binedaw ira nonta para amag ni baley, ja kowan sha ey enshiy silbi to, si‐kato et ngo mowan gayam i epateg ga bato so ni emin. ");
INSERT INTO ibl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Si Apo Shiyos i makabaal niyay ya edaga jet kaskasshaaw i tayosoka pengidmang.’ ” ");
INSERT INTO ibl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Edawag ey sota makakontra son Jesus, si‐karay naytorongan nonta arig ga inkowan nen Jesus. Isonga kowan sha ey seskelen sha si Jesus, nem entakot sha ira sota eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Say inpasing sha, engibetkag ira ni eshom so nonta ira Parisiyo tan too nen Ari Hirodis ja en menaol son Jesus say ẃaray ikowan ton esel ja ipangbalan sha so ey ẃaray basol to. ");
INSERT INTO ibl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Idi simabi sota inbetkag sha son Jesus, kowan sha ey, “Maistoro, amta mi ey podnon emin sota kowan mo, tan amta mi pay ey enshiy moka pabori, angken ngantoy katoo to. Sota torom ket si‐katoy piyan nen Apo Shiyos ja dag‐en ni totoo. Isonga iyay i ibaga mi son si‐kam. Maypeshit aya shi dinteg tayon Hodiyos i panbedjad ni bowis so ni gobirnod Roma, ono enshi? ");
INSERT INTO ibl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Manbedjad kito ono enshi?” Nem si Jesus, amta to ey tapang bengat iya salodsod sha jet kowan to son si‐kara ey, “Ngantoy jowaksoka pansaoli so? Alekayo di ni sakey ya salepi say on‐an ko.” ");
INSERT INTO ibl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","In‐aknan sha ni sakey et kowan to ey, “Sipay makadopa niyay ya naymalked ja pilak? Tan sipay makangaran niya naysolat?” Simongbat ira ja kowan sha son si‐kato ey, “Sota ari shi Roma.” ");
INSERT INTO ibl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jet kowan ma nen Jesus son si‐kara ey, “No kasta, sota pilak ja joka osala, edapod gobirno ni Roma, isonga mesepol met laeng nga pa‐odiyo son si‐kara. Sota kowan ni gobirno ey may‐ekan son si‐kara, mesepol la maytongpal, jet sota kowan ngo nen Apo Shiyos ey may‐ekan son si‐kato, mesepol ngon mepati.” Jet ireka messhaaw wa pasiya nonta insongbat nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Waray Hodiyos iren kowan sha ey Sadosiyo, ja say pamatira, kowan sha ey eg kono manbiyag mowan i nanketey. Dimaw ngo ira di son Jesus i eshom son si‐kara, jet sha inbag‐an, ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maistoro, say insolat nen Moises nonta bayag da ja dinteg tayon Hodiyos, kowan to ey no sota dakin engaseẃa ket metey ja enshiy potot to nodta aseẃa to, sota agi nonta dakin etey, si‐katoy mengelbat nonta istay aseẃa nonta agi to, say balang nem ẃaray enaken sha, et say sota anak sha, maybidang ey singa potot nonta etey den agi to. ");
INSERT INTO ibl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iyay i piyan min ibaga. Nontan da kono, ẃaray piton san‐a‐aki, jet sota pangodowan, engaseẃa; nem etey ya enshiy to inpotot. ");
INSERT INTO ibl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jet sota maykadẃen agi to, inelbat to sota aseẃa nonta agi ton etey, nem etey mowan sota daki. Kasta met sota maykatdon agi sha. Emin ira jay ya piton san‐a‐aki ja nansasa‐dat ja engaseẃa nontan na sesakey ya bii, etey ira ja enshiy sha inpotot. ");
INSERT INTO ibl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jet shi ka‐onoran, etey kono ngo sota bii. ");
INSERT INTO ibl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sajay i piyan min ibaga son si‐kam: no bilang ey onsabi ali sota timpon pan‐ongal ira ni nanketey, sipa emoy koston maka‐aseẃa ali so nontan na bii? Ta nan‐i‐inelbat met ira sota piton san‐a‐aki ja engeseẃa son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Simongbat si Jesus ja kowan to son si‐kara ey, “Esama kayo, jet say kabol, eg jo ineẃatan sota esel nen Apo Shiyos ja naysolat nonta bayag da, tan eg jo pay amta sota panakabalin to. ");
INSERT INTO ibl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta sota totoon pan‐ongal ali nen Apo Shiyos, eg ma ira mengesawa, ta ingesen sha ira sota anghil. ");
INSERT INTO ibl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nem sigosho eg jo pati‐en ey manbiyag mowan sota nanketey. Apay eg jo aya binasa sota kowan nen Apo Shiyos son Moises ja edapo nodta emanshedang nga kadasan? Insolat nen Moises nonta bayag da i esel nen Apo Shiyos, ja kowan to ey, ‘Si‐kak si Apo Shiyos, ja Shiyos shi Abraham, Isaac, tan si Jacob!’ ");
INSERT INTO ibl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Say olog niyay, angken etey mangon ebayag i bakdang shi Abraham, kowan nen Apo Shiyos ey mabiday ired sango‐an to. Ta no enshi koma, istay eg to inkowan ey si‐katoy Shiyos sha. Esama kayon pasiya.” ");
INSERT INTO ibl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sota sakey ya maistoro ni dinteg ni Hodiyos, imesop son Jesus tan sota ira Sadosiyo ni shaka pansosongbat, jet intenengan to ja mapteng i kepenongbat nen Jesus. Isonga inbag‐an to ngos Jesus, ja kowan to ey, “Towa nodta bilin nen Apo Shiyos i kapatkan so ni emin?” ");
INSERT INTO ibl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Simongbat si Jesus ja kowan to ey, “Say kapatkan so ni emin na bilin, sajay: ‘Si‐kayon totood Israel, itnengiyo iyay. Si Apo Shiyos ja Shiyos tayo, si‐kato bengat i podnon Shiyos, enshiy eshom. ");
INSERT INTO ibl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Isonga si Apo Shiyos i topogen mon sesmeken, ja si‐katoy pengitoshongan mo ni emin na ẃara son si‐kam — emin na ẃared posom, emin na nemnem mo, tan emin na kedsang mo.’ ");
INSERT INTO ibl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jet say maykadẃa, sajay: ‘Semek moy kait mon too ja inges toy moka penmek ni bakdang mo.’ Sajay ya showen bilin nen Apo Shiyos i kapatkan so ni emin; enshiy eshom ma bilin ja maka‐inges niyay.” ");
INSERT INTO ibl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sota maistoro ni dinteg ja nansalodsod son si‐kato, kowan to ma ey, “Apo, kosto ita songbat mo ey si Apo Shiyos bengat i podnon Shiyos, enshiy eshom. ");
INSERT INTO ibl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jet no si Apo Shiyos i topogen tayon sesmeken, ja si‐katoy pengitoshongan ni emin na ẃared poso tayo, nemnem tayo, tan kedsang tayo, tan no sesmeken tayoy kait tayon too ja inges toy tayoka penmek ni bakdang tayo, araẃin mapmapteng iyay son Apo Shiyos ey say sota pengileton ni animal son si‐kato, ja angken nganton daton.” ");
INSERT INTO ibl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Inon‐an nen Jesus ey mapteng i songbat nonta too, isonga kowan to son si‐kato ey, “Shanshanin ẃaren emin son si‐kam i banag ja kabol ni kayda‐kaman shi pantoshayan nen Apo Shiyos.” Jet manipod nontan, polos malen eg intoled ni angken sipen too ja nansalodsod son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Idi emantosho si Jesus shi Timplo, inkowan to ey, “Apay ngarod nga kowan ni mamaistoro ni dinteg ey sota inkari nen Apo Shiyos ey ibetkag to din mengisedakan ket medepo bengat shi poli nen Ari David nonta bayag da? ");
INSERT INTO ibl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta angken si Ari David shorog, inkowan to ey pangolo to sota mengisedakan ali. Intorong met ni Ispirito Santo nen Apo Shiyos si David nonta engikowanan to ey, ‘Si Apo Shiyos, inkowan to so nonta pangolok ey ontongaw si‐kato shi apit ni kanawan to, ingkatod enshiy mebedin nonta kabakal to, ja ẃara ma ired shalokap ni shapan to.’ ");
INSERT INTO ibl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jet no kowan nen Ari David ey pangolo to sota mengisedakan ali, toway inpasing to ja kowan sha ey poli ali nen Ari David?” Eshakel i totoo nontan ja emengitneng ni kowan to jet pipiyan shen pasiya ja itenengan. ");
INSERT INTO ibl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Inkowan to pay ni tosoka pan‐itoro ira so ey, “Tanshaaniyo ira ja mamaistoro ni dinteg ta baka ma‐edinan kayo. Pipiyan shen manbesho ni nankedayag ni sha panpasiyal, tan pipiyan sha pay ya rispito‐en ni totoo ira ja semsemano‐an shima malkaro ja karakdan ni too, ");
INSERT INTO ibl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tan shima sa‐nopan, pipiyan sha pay ja ontongaw shima naysaganen tongawan say mebigbig ira, jet agdalo no timpo ni piyasta, sotan i shaka pesing. ");
INSERT INTO ibl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Manpa‐otang ira mango nonta bibiin nankebalo jet no enshiy ibayad sha, piditen shen angken sota baley sha i ibayad sha. Jet no ondaw ired ma sa‐nopan, say shaka pesing nga mena‐din ni kakedsel sha, shaka ishokey i shawat sha son Apo Shiyos, say ikowan ni too ey maronong ira. Nem amta nen Apo Shiyos iyay et ebadbadeg i penosa to son si‐kara!” ");
INSERT INTO ibl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wara nonta pinsak si Jesus shi nay‐esop nodta kakon ja kay‐ini ni alos shi Timplo. Sota ira bebaknang, ebadeg i pilak ja shaka i‐iyan. ");
INSERT INTO ibl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nontan na oras, ẃara ngoy sakey ya ebalon biin ebiteg ja en engi‐kas ni showen engkokonting nga siljo, ja manbenol ni sakey ya sintimos. ");
INSERT INTO ibl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tina‐ẃal nen Jesus ira sota too to et inkowan to ey, “Ikowan ko son si‐kayo, sajay ya biin ebalo, ja ebiteg ga pasiya, epatpateg sota in‐akan ton alos to nem say sota ira eshom ma engi‐kan ni alos sha. ");
INSERT INTO ibl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta sota ira eshom, sobda ni pilak sha i sha in‐akan, nem sajay ya biin ebiteg, in‐akan ton emin i oltimon ẃara son si‐kato — angken sota istay panbiyag to koma.” ");
INSERT INTO ibl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Idi bimo‐day si Jesus shi Timplo, imesel i sakey ya too to, ja kowan to son Jesus ey, “Apo, nankemapteng ira ja balbaley shiya nandiniked ni Timplo, tan memapteng ima engkakembaleg ga bato ja nay‐amag shiyay! On‐im, apo!” ");
INSERT INTO ibl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nem si Jesus, simongbat son si‐kato, ja kowan to ey, “Owen, bisnayo niman ira ja mapteng nga baley. Tep ẃara aliy timpon onsabi ja angken sakey so ira nima baton mapteng i inkay‐amag to, enshiy en mebay‐an shima nay‐amagan to; mesheshal la emin.” ");
INSERT INTO ibl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Idi pinsak ja ẃares Jesus ja timongaw shima shontog ja kowan sha ey Olibas, ja naymamang nodta Timplo, abos nen Pedro, si Santiago, si Juan, tan si Andres, jet insho‐petan sha si Jesus, ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Piyan min amta‐en no pigan ali ita kowan mo ey kesheshal niya Timplo. Tan nganto pay i amta‐an mi so ey shanshanin mepesamak itan?” ");
INSERT INTO ibl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Simongbat si Jesus ja kowan to son si‐kara ey, “Nemnemnem jo koma iyay. Karekayo pa‐olbod so ni angken sipa, ");
INSERT INTO ibl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ta eshakel aliy toon mengosal ni ngaran ko, ja ikowan sha ey si‐kara si Cristo, jet eshakel noman i totoon may‐owapan. ");
INSERT INTO ibl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jet ẃara pay i mismon mankokobat ja itenengan jo, tan ẃaray shemagen jon kobat shi eshom ma ili. Nem karekayo meshanagan. Tep kenshat ta mepesamak ira jay, nem aliẃen sotan i ka‐amta‐an to ey shanshani may pantepos ni dobong. ");
INSERT INTO ibl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Angken ili tan ili, mankobat ira, jet angken pay sota ka‐ili‐ilin intorayan ni a‐ashi, mankokobat ngo ira. Wara pay i jegjeg shi kedogadogad, tan epaladon bitil. Nem emin iyay ya mepesamak, sajay i panshoki‐an bengat ni digat. ");
INSERT INTO ibl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pantanshaan kayo, ta ẃaray eshom ma totoo ja mengidaw son si‐kayo shi oskaro. Tan angken shima sa‐nopan sha, sepsepdaten shakejod man pay. Jet ikoyod shakejo pay shi sango‐an nonta ira gobinarol, tan sango‐an nonta ira ari, ta too takejo. Jet sotan i ẃaya jon mengiringan na mengikowan son si‐kara ni maypangkep son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jet sota mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos, maypedawag shi emin na ka‐ili‐ili asan kesabi may pantepos ni dobong. ");
INSERT INTO ibl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No ma‐shel kayo ja mebistigal shi oskaro, karekayo meshanagan no ngarantoy isongbat jo son si‐kara, no diket sota maypa‐amta met laeng son si‐kayo nontan na oras ja shakejosoka pan‐ibag‐i, sotan i isongbat jo. Ta aliẃen si‐kayon mismo i onsongbat so, no diket sota Ispirito Santo nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Jet sajay alin timpo, angken san‐agin daki, ibaag nonta sakey i agi to shi eshom, ey eg et meshanagan ey bono‐en sha. Inges niyay met laeng i pesing ni a‐ama shi annak sha. Jet angken sota ira a‐anak, kontra‐en shay maka‐anak son si‐kara et pebonora pay ira. ");
INSERT INTO ibl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jet angken si‐kayo, sota joka pemati son si‐kak, si‐katoy kabol la okesan shakejo so ni karakdan na too. Nem sota mengitoded ni angken nganton digat ja onsabi son si‐kato, si‐katoy maysedakan. ");
INSERT INTO ibl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Jet on‐an jon mepesamak sota naypadto nonta bayag da ja kowan sha ey ‘Kataktakot alin ondogit’. Jet isaad toy toray shi dogad ja enshiy kanebengan ton man‐iyan. (Sota memasa niyay, eẃatan to komay kaytoshongan niya kowan nen Jesus.) No on‐an jo iyay, say pesing koma ira nonta naytompong nga ẃared Jodia, onbetik ira et ja manbakwit shi shonshontog. ");
INSERT INTO ibl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sota toon maytompong nga man‐adibay shi bo‐dayan, eg to koma nemnemen ja onsekep shima baley to ja en mengeda nonta kompormin ẃara nodta naydaem ni baley. ");
INSERT INTO ibl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kasta met sota ẃared payew, eg koma mesiẃat ni aleto nonta insepa ton baro to. ");
INSERT INTO ibl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","No timpon kepesamak niyay, kakaasi ira din pasiya sota bibiin malokon, tan sota bibiin ẃaray anak shen emenoso. ");
INSERT INTO ibl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ireẃat jo son Apo Shiyos ey eg koma mepesamak iyay ni timpon powek, say mariẃes i pemtik jo. ");
INSERT INTO ibl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta sotan alin digat ja onsabi, enshiy to kay‐ingesan nodta ira digat ja epaspasemak, manipod nonta pinalsowa nen Apo Shiyos iya dobong ingkato niman. ");
INSERT INTO ibl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No eg ninemnem nen Apo Shiyos ey tikeyen to iyay alin digat, istay angken sipen too, enshiy mebay‐an na mebiyag. Nem si Apo Shiyos, tikeyen to iyay ya digat, ta toka isakit ira sota too ton pinidi to, ja i‐okong ton para si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sotan alin akew, no ẃaray mengikowan son si‐kayo ey amtaray kad‐an nen Cristo, ja kowan sha ey jo asen, karejo patpati‐en. ");
INSERT INTO ibl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta eshakel aliy toon kowan sha ey si‐kara si Cristo, ono kowan sha ey si‐karay para padto nen Apo Shiyos, jet eshakel i dag‐en shen kaskasshaaw wa aramid ono milagro. Jet no mebedin, kowan sha pay ey i‐owapan sha ira sota too nen Apo Shiyos ja pinidi to. ");
INSERT INTO ibl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nem tanshaaniyo ira jay! Naka pan‐isigod iya banshaan son si‐kayo say amta‐en joy mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Jet no onsabi sotan na timpo ja kekshengan nonta digat, ma‐shep shagos sota niyal ni sekit tan bolan, ");
INSERT INTO ibl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","jet sama talaw, mepedaspas ira, jet mebediwan i itsora nima naykayang. ");
INSERT INTO ibl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","No meksheng iyay, mismon asen sha‐ak ni totood dobong ja ma‐odopanak ali ni kolpot, tan asen sha pay i itsora ni bakdang kon emenenili, tan asen sha ngo sota ebadeg ga panakabalin ko. ");
INSERT INTO ibl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jet ibetkag ko iray anghil ko ja mengolnong ira nonta pinidik ja took shi emin na sakop niya dobong, shi angken towen dogad.” ");
INSERT INTO ibl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jet si Jesus, arig mowan i inpasing ton engileẃag nonta idaw to mowan ali, ja kowan to ey, “Nemnem jo kari sota kadasan na kowan sha ey higos. Shiya kad‐an tayo, no asen jon ondongkey sota panga to, asan somimit mowan i bolong to, amtayo ma ey shanshani sota timpo ni petang. ");
INSERT INTO ibl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Inges niyay aliy i‐olik. No asen jon emanketongpal ira ja inkowan ko la, amtayo ma ey sota timpon idaw ko ali, shanshani ma, ja singa ẃara‐ak nodta pasbol. ");
INSERT INTO ibl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Podno iyay ya ikowan ko son si‐kayo. Saja ira too niman, eg ira nin metey, no diket sa‐kopen shen emin ira jay ya mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sama naykayang tan saja dobong, mebedin na ma‐enshi, nem saja esel la inkowan ko, kenshat ta metongpal, ja eg ma‐enshi. ");
INSERT INTO ibl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nem si Apo Shiyos bengat i maka‐amta no pigan i ketongpal niyay ya inkowan ko la. Angken sama anghil shi dangit, tan si‐kak ja Anak nen Apo Shiyos, eg mi ngo amta. ");
INSERT INTO ibl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Isonga pantanshaan kayo; mesepol la esagana kayo ni olay, mesepol la mansheẃat kayo ni olay son Apo Shiyos. Ta eg jo amta sotan alin timpo ja idaw ko di. ");
INSERT INTO ibl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","May‐eshig i kasesaad jo nodta baga‐en nonta baknang. Sota baknang, ẃaray daẃan ton nay‐araẃin ili, isonga indekjas to sota baley to et sota ira baga‐en toy maka‐amta so. In‐epeng toy obda son si‐karen emin et inbilin to ey sota para dekeb ni baley, singpeten ton manbantay ni baley. ");
INSERT INTO ibl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sajay i kay‐eshigan jo, isonga mesepol la esagana kayo ni olay, ta eg jo amta nem pigan aliy imotok nonta apo jo — no mama‐shem, ono kawa ni dabi, ono nem ikagang ni manok ni daem, ono agsapa. Isonga pan‐alisto kayo, ");
INSERT INTO ibl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","say no bilang ey onmotok sota Apo jo ni palibdibag, eg tokejo sa‐kopan na na‐ogip. ");
INSERT INTO ibl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Saja ikowan ko son si‐kayo, emin na tooy naka pengikowani so: pansagana kayo ngarod!” Sajay ya emin, inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Showen akew pay et onsabi sota piyasta ni Hodiyos ja kowan sha ey Paskowa, tan sota piyasten pengan sha ni tinapay ja enshiy daok ton para debag. Jet nontan, nantatabtabal ira sota apo ni papashi ni Hodiyos tan mamaistoro ni dinteg no ngantoy pesing shen memono son Jesus, jet ninemnem sha ey olboren sha kono say ma‐shel et mebono. ");
INSERT INTO ibl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mesepol la olbod i pesing sha kono; isonga kowan sha ey, “Aliẃen tayo itompong no timpon piyasta, ta baka et ey mankodo ira sota eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jet nontan na akew, ẃares Jesus shi Bitania, shima baley nen Simon ja istay ebaybayang i bakdang to. Emengan si Jesus nodtan na baley ey ẃara ngoy biin dimaw ali son si‐kato, ja engita‐jon ni danen emanseng‐ew ja nay‐iyan shi botilja. Sajay ya dana sota kowan sha ey nardo; epalit ta pasiya i tongkal to. Dinokatan nonta bii sota botilja et insho‐jag tod toktok nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nem ẃaray eshom ja engasas niyay et ireka mankotot, ja kowan sha ni sakey tan sakey son si‐kara ey, “Ngantoy inpakeẃasan to so emo nima dana? ");
INSERT INTO ibl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","No istay indako to koma sotan na dana, mebedin na asdeg to komay may‐ekan so nonta ira nankebiteg! Ta say banol nontan na kalasin dana, no maydeko ket tedon dasos.” Jet inseg‐ang sha pay sota bii. ");
INSERT INTO ibl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nem si Jesus, kowan to ey, “Baybay‐iyo ita bii; karejo bedawen. Ta mapteng ita dingka to son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sota ira nankebiteg, ẃara ni olay son si‐kayo, isonga no piyan jon ontolong son si‐kara, mebedin; nem si‐kak, eg mebedjag i pekikadẃak son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Saja bii, dingka toy kabaalan ton dag‐en, ta saja dana ja insho‐jag to son si‐kak, singa toka pan‐isagana i kaybebka niya bakdang ko ali. ");
INSERT INTO ibl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jet agpayso iya ikowan ko son si‐kayo. Shiya intiron dobong, no maytosho sota mapteng nga shamag maypangkep son si‐kak, sajay ya dingka niyay ya bii, pekipedawag sha jet eg medibdibkan.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Si Judas Iskariote, ja sakey so nonta ira sampolo tan showen apostol nen Jesus, dimaw ja en ekitbal so nonta ira apo ni papashi no ngantoy pesing ton mengitosho ni kawad‐an nen Jesus say seskelen sha. ");
INSERT INTO ibl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Idi intenengan sha iya kowan nen Judas, ireka man‐imdeng, jet inkari sha ey i‐aknan sha ni pilak. Jet nontan ma, ẃara ni olay shi nemnem nen Judas no toway pesing ton mengibaag so nen Jesus son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Shimanon sota pilmiron akew ni piyasta, ja shaka pengan ni tinapay ya enshiy daok ton para debag tan shaka pemalti ni kalniron sid‐an sha nem Paskowa, isonga sota ira apostol nen Jesus, inbag‐an sha, ja kowan sha ey, “Toway piyan mon daẃan mi ja pengisekana‐an mi ni penganan mo nem ma‐shem, tep Paskowa ma?” ");
INSERT INTO ibl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jet nontan, si Jesus, engibetkag ni showa so nonta ira apostol to, ja kowan to ey, “Daw kayod Jerusalem, jet no onmotok kayod man, ẃaray dakin aspolen jo ja emasan ni salaw ja na‐inan ni shanom. Onod jo, ");
INSERT INTO ibl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","jet nodta baley ja seskepan to, ikowan jo iyay so nonta makabaley: ‘Kowan ali nen Maistoro son si‐kam ey towa konoy kowadton penganan to tan si‐kamin too to niman na ma‐shem, tep Paskowa?’ ");
INSERT INTO ibl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jet ipa‐sas to son si‐kayo i embanaw wa kowadto nodta naykayang, ja ẃara nodtan na emin i mesepol tayo ja naysagana. Si‐katoy pengisekana‐an jo ni kenen tayo nem ma‐shem.” Kowan nen Jesus so nonta showen inbetkag to. ");
INSERT INTO ibl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dimaw ira sota shadẃa shi Jerusalem et idi mimotok ira, siya, kosto noman na nay‐agpayso sota kowan nen Jesus son si‐kara. Jet insaganared man sota kenen sha nontan na ma‐shem. ");
INSERT INTO ibl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Idi mama‐shem mala, si Jesus tan sota sampolo tan showen apostol to, dimaw iren mengan nodtan. ");
INSERT INTO ibl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jet idi maramen ireka mengan, kowan nen Jesus ey, “Agpayso iya ikowan ko son si‐kayo. Waray sakey son si‐kayon ekilikob son si‐kak niman ja mengibaag son si‐kak so nonta ira makakontra son si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jet sota ira too to, ensakit ta pasiya i nemnem sha, jet kowan ni sakey tan sakey son Jesus ey, “Sipa? Aliẃen si‐kak emo?” ");
INSERT INTO ibl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Simongbat si Jesus ja kowan to ey, “Say ondaga niyay, agpayso ey sakey son si‐kayon sawal ni showa. Sota nay‐okob son si‐kak shi sakey ya pingkan, si‐kato sotan. ");
INSERT INTO ibl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Si‐kak sota kowan ni para padto ey Anak ni Too jet kenshat ta metongpal sota padto ja naysolat nonta bayag da ni maypangkep son si‐kak. Nem kaasi met laeng sotan na toon mengibaag son si‐kak, ta meshosen pasiya! No da‐kaman to sotan na shosa, ikowan to shorog shi bakdang to ey, ‘Agpos et nem ekak koma nay‐anak!’ ” ");
INSERT INTO ibl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jet nontan na maramen ireka ma emengan, inda nen Jesus sota tinapay et idi naksheng nga nan‐iyaman son Apo Shiyos, shinowashowa to, jet in‐akan to nodta ira apostol to, ja kowan to ey, “Iya, alejo iyay. Sajay i bakdang ko.” ");
INSERT INTO ibl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jet idi naksheng, inda to sota tasa et idi nan‐iyaman son Apo Shiyos, in‐akan to mowan son si‐kara, jet nan‐inom iren emin. ");
INSERT INTO ibl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jet kowan nen Jesus ey, “Sajay i shalak ja on‐ayos ali ja para pansigshan ni eshakel la totoo. Ta sota ketey ko di, si‐katoy panshoki‐an nonta badon pesing nen Apo Shiyos so ni totoo. ");
INSERT INTO ibl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Agpayso iya ikowan ko son si‐kayo. Sajay i ka‐onoran na penginom ko ni shanom niya obas, jet ekak nin menginom ingkatod onsabi sota penginom ko nonta badon shanom ni obas shima pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nankansiyon ira ni maypangkep ni panshedjaw sha son Apo Shiyos, jet idi naksheng, bimo‐day ira nodtan na baley jet dimaw ired ma shontog ga kowan sha ey Olibas. ");
INSERT INTO ibl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jet si Jesus, kowan to so nonta ira too to ey, “Nem ekay, ibaing jowak ka emin et onbetik kayo, ta si‐katoy tongpal nonta padton naysolat nonta bayag da, ja kowan to ey, ‘Bono‐en ko sota para bantay ni kalniro et sota eman‐o‐odop ja kalniro, mebodak ira.’ ");
INSERT INTO ibl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nem no meksheng i pan‐ongal ko, mepangdo‐ak ja ondaw shi Galilia ey say si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nem si Pedro, kowan to ey, “Angken ibaing shaka ni emin na kait ko, eg taka mango ibaing!” ");
INSERT INTO ibl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Simongbat si Jesus ja kowan to ey, “Podno iya ikowan ko son si‐kam Pedro: niman na dabi, isaot mowak ni memintedo ja ikowan mo ey eg mowak am‐amta. Jet no meksheng iyay, onkagang ngoy kawitan ni maykepinshowa.” ");
INSERT INTO ibl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nem si Pedro, toka pan‐ipilit ta pasiya, ja kowan to ey, “Angken na pekibono sha‐ak son si‐kam, ekak ikowan ey eg taka am‐amta!” Jet sota ira kait ton too nen Jesus, sotan ngoy inonoran shen inkowan. ");
INSERT INTO ibl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jet dimaw ma ired ma dogad ja kowan sha ey Gitsimani, jet kowan nen Jesus son si‐kara ey, “Tongaw kayod jay ta nak nin mansheẃat son Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inodop tos Pedro, si Santiago, tan si Juan, jet nontan ma, simabi son si‐kato i epaladon aboshiro, jet emankaikelkel‐eẃin pasiya. ");
INSERT INTO ibl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jet kowan to son si‐kara ey, “Singa meteyak ni daringit ko! Shiyay kayo nin, karekayo ma‐okip.” ");
INSERT INTO ibl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Idi naksheng nga inkowan to iyay, bintawan to ira ni ootik, jet nanshomog shi bo‐day ja nanshawat son Apo Shiyos ey no mebedin koma, eg manda‐kam nonta digat alin onsabi son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kowan to ey, “Ama, kabedinan moy angken nganto, isonga eg mo koma ipalobos iyay ya pandikat ko di. Nem say kowan ko, sota piyan mo, si‐katoy metongpal; aliẃen sota kostok.” ");
INSERT INTO ibl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Idi imekẃas, dimaw ja to inon‐an sota too to jet simbi to iren na‐ogip. Jet kowan to so nen Pedro ey, “Na‐ogip ka, Simon? Apay, eg mebedin ja itoled moy jo‐kew mo ni angken sakey ya oras bengat? ");
INSERT INTO ibl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Panmolakat kayo jet panshawat kayo ngo so nen Apo Shiyos ni kedsang say eg shakejo ebaken ni ngaaw wa onsabi son si‐kayo. Sota nemnem jo, makedsang niman, nem baka et ey ma‐ebak kayo tep ekapoy i bakdang jon ontongpal nonta ẃared nemnem jo met laeng.” ");
INSERT INTO ibl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dimaw mowan si Jesus ja en mansheẃat son Apo Shiyos, jet iso met laeng i inkowan to ni shawat to son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jet nay‐oli mowan ali jet simbi to ira sota too to ja na‐ogip, ta epaladoy jo‐kew sha. Jet eg sha amtay isongbat sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","En nanshawat si Jesus ni maykepintedo et idi nay‐oli mowan ali so nonta ira too to, kowan to son si‐kara ey, “Ngantoy? Piyan jon ma‐okip ni olay? Nem eti, simabi ma sota timpo, jet si‐kak ja kowan ni para padto ey Anak ni Too, may‐eẃatak ma so nonta ira toon nankekedsel. ");
INSERT INTO ibl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ondaw kito ma niman. Iyay ma ali sota mengibaag son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Idi maramen eman‐a‐sel si Jesus, si Judas Iskariote ja sakey so nonta ira sampolo tan showa ja apostol nen Jesus, engolop ali ni eshakel la totoo. Sota eshom, nan‐etak ira, tan sota ira eshom, ẃaray peg‐as sha. Sajay iren too, inbetkag ira nonta apo ni papashi, mamaistoro ni dinteg, tan pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Si Judas Iskariote, insigod ton inkowan so niya ira inodop to ey, “Say pengimatonan jo son Jesus, ongo‐an ko. Tengel jo et ibtik jo; jet singpet jo men kowadja‐an.” ");
INSERT INTO ibl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Isonga idi dimaw alis Judas shi kad‐an nen Jesus, insopan to et kowan to ey, “Apo!” Jet inongo‐an to ja singa agpayson ensemek to noman. ");
INSERT INTO ibl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jet sota ira inodop ali nen Judas Iskariote, dimaw ira di et tinngel shen shagos si Jesus ja a‐shelen sha ma. ");
INSERT INTO ibl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nem sota sakey ya too ja ẃara nodtan, inokbos ton shagos i kampilan to et kinimpas toy tangida nonta sakey ya baga‐en nonta kangeto‐an na pari. ");
INSERT INTO ibl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jet kowan ma nen Jesus so nonta ira eshakel la totoo ey, “No si‐kak i kowan jo ey a‐shelen jo, apay nga nan‐etak kayo, tan ẃaray peg‐as jo? Apay tolisanak? ");
INSERT INTO ibl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inakew met ja ẃara‐ak son si‐kayo shima Timplo ja emantosho, ket apay nga eg jowak inshel nontan? Nem angken, mesepol la sajay i medeka say metongpal sota padton naysolat nonta bayag da.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jet emin ira sota too to, namtik ira jet indekjas shes Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Sota sakey ya balodaki, ja too met laeng nen Jesus, istay peki‐shel sha son Jesus, nem idi kowan sha ey seskelen sha, kimopos nodta empotin abel ja inketap to nodta bakdang to et namtik ja nandabos. ");
INSERT INTO ibl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jet si Jesus, indaw sha nodta baley ni kangeto‐an na pari, jet shiman i na‐olnongan ira nonta mamaistoro ni dinteg, tan sota ira eshom ma pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jet si Pedro, tinned to ira nem bimetaw. Intoled to pay ya ekiskep nodta bo‐dayan ni kangeto‐an na pari. Ekitongaw so nonta ira kowadja jet ekirangshang pay son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nontan met laeng, sota ira apo ni papashi tan sota ira esa‐nop pa toray, ireka mengenap ni ikowan shen basol nen Jesus, say ẃaray kabol la ikowanan sha so ey si‐katoy kebono‐an to. Nem enahiy shaka sepolen koston basol to. ");
INSERT INTO ibl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta eshakel sota sistigon dimaw ali ja o‐owap i kowan sha, nem eg mankokompas i insodsod sha. ");
INSERT INTO ibl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anongosto ma ey ẃaray dimaw ali ja o‐owap i insistigo sha, ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Intenengan min mismo i inkokowan niyay ya too; kowan to ey sheshalen to kono ima Timplo ja inemag ni too, jet i‐oli to kono mowan na dag‐en ni tedon akew. Nem sota dag‐en to, aliẃen too konoy mengemag so.” ");
INSERT INTO ibl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nem eg met laeng nankompas i inkowan iren jay. ");
INSERT INTO ibl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jet sota kangeto‐an na pari, dimayat shi sango‐an iren emin ja esa‐nop, jet inbag‐an tos Jesus ja kowan to ey, “Jet enshiy isongbat mo? Sajay met i kowan ira niya too ey basol mo!” ");
INSERT INTO ibl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nem si Jesus, imeg‐eket ja enshiy to insongbat. Jet sota kangeto‐an na pari, kowan to ma ey, “Ikowan mo ngo no si‐kam sota Anak nen Apo Shiyos ja emeshedshedjaw! Ikowan mo no si‐kam sota inkari to nonta bayag da ey ibetkag to alin mengisedakan!” ");
INSERT INTO ibl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Simongbat si Jesus ja kowan to ey, “Owen, si‐kak ita kowan mo. Si‐kak sota kowan ni para padto ey Anak ni Too, jet no ekay ali, on‐an jowak ja timongaw nodta apit ni kanawan nen Apo Shiyos ja Manakabalin. Jet asen jowak ali mowan ja metaksholan ni kolpot.” ");
INSERT INTO ibl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jet sota kangeto‐an na pari, bini‐nik to sota baro to shorog ni bonget to, jet kowan to ey, “Eg mesepol la ẃara pay i sistigo! ");
INSERT INTO ibl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Intenengan jo met i inkowan to! Toka pa‐so‐i si Apo Shiyos! Jet ngarantoy piyan jon pesing son si‐kato?” Jet sota kait ton toray, inkowan shen emin ey anam to konon mebono. ");
INSERT INTO ibl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jet sota eshom son si‐kara, inshogi shay topsha son Jesus. Inopop sha pay i mateto, asan shaka shengpela, ja kowan sha ey, “Sipay enengpel son si‐kam? Tiga, bisto‐im ka!” Jet sota ira kowadja, in‐aspol shay sedpak son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wara ngo pay laeng si Pedro shima bo‐dayan ni baley, jet dimaw aliy sakey ya biin baga‐en ni kangeto‐an na pari, ");
INSERT INTO ibl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","jet inon‐an tos Pedro ja emenangshang nodta apoy. Inningning tos Pedro et kowan to ey, “Angken si‐kam met, eki‐od‐odop ka so nonta i‐Nasarit ja si Jesus i ngaran to.” ");
INSERT INTO ibl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nem si Pedro, indibak to, ja kowan to ey, “Enshiy amtak nita moka pan‐ikowan! Ekak eẃatan itan na moka pan‐ikowan!” Jet dimaw si Pedro nodta pasbol. Sotan ey onkagang i kawitan. ");
INSERT INTO ibl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jet sota biin baga‐en, inon‐an to mowan si Pedro nodta dinaẃan to et kowan to so nonta ira toon ẃara nodtan ey, “Sajay ya too, si‐kato met i sakey ya too nonta inshel sha.” ");
INSERT INTO ibl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nem si Pedro, indibak to mowan. Idi ekay, sota ira toon ẃara nodtan, dimaw ira di son Pedro jet kowan sha ey, “Ayshiy showashowa! Kenshat ta si‐kam i sakey ya kait to, tep too ka did Galilia!” ");
INSERT INTO ibl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nem si Pedro, nansangba, ja kowan to ey, “Angken shosa‐en towak nen Apo Shiyos no o‐owap iyay ya inkowan ko la! Ekak am‐amta itan na toon joka pan‐ikowan!” ");
INSERT INTO ibl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jet idi inkowan to iyay, kimagang i kawitan ni maykepinshowa. Jet idi intenengan nen Pedro, ninemnem to ma sota inkowan nen Jesus ey, “Isaot mowak ni memintedo, ja kowan mo ey eg mowak am‐amta, jet no meksheng iyay, onkagang ngoy kawitan ni maykepinshowa.” Jet idi ninemnem nen Pedro iyay, nimangis sa pasiya tep naydaw‐an. ");
INSERT INTO ibl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Idi nonta emankeẃa‐ẃa ma, sota ira apo ni papashi, mamaistoro ni dinteg, tan sota ira eshom ma toray ni Hodiyos, nantatabal ira et say inpasing sha, binedod sha si Jesus et inpaidaw sha so nen Gobinarol Pilato. ");
INSERT INTO ibl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jet si Pilato, inbag‐an tos Jesus, ja kowan to ey, “Jet agpayso ja si‐kam sota ari ni Hodiyos?” Simongbat si Jesus ja kowan to ey, “Sota inkowan mo, si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jet sota ira apo ni papashi, eshakel i inkowan sha so nonta gobinarol ja kowan sha ey basol nen Jesus, ");
INSERT INTO ibl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","jet si Pilato, inbag‐an to mowan si Jesus, ja kowan to ey, “Enshiy isongbat mon dason mo? Apay, eg mo aya itenengan ima kowan sha ey eshakel la basol mo?” ");
INSERT INTO ibl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nem nasshaaw si Pilato, tep enshi pay i insongbat nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","10","Indasin nen Gobinarol Pilato ey apal ira nonta apo ni papashi son Jesus i in‐awatan sha son si‐kato, isonga piyan ton ibolos si Jesus. No timpo ni piyasta ni Paskowa, ẃaray sakey ya piriso ja kaibolos ni olay nen Pilato ja piyan ira nonta totoon ibolos to. Isonga idi dimaw aliy eshakel la too ja en nangshaw son si‐kato ey ibolos to nontan i sakey ya piriso son si‐kara, kowan nen Pilato son si‐kara ey, “Piyan jon ibolos ko son si‐kayo sota ari jon Hodiyos?” Nem naytompong nontan ja ẃaray sakey ya pirison nanngaran ni Barabas ja sakey so nonta eshakel la girilya ja naybalod kabol ni inpamonora ni inpamakal sha so ni gobirno. Isonga idi inbaga nen Pilato no piyan nonta totoo ja si Jesus i ibolos to, ");
INSERT INTO ibl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","sota ira apo ngo ni papashi, intod‐an sha sota eshakel la too ey say ikowan sha so nen Pilato ja ibolos to, saja si Barabas. ");
INSERT INTO ibl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jet si Pilato, kowan to son si‐kara ey, “Jet no sotan i kowan jo, ngaran to ma i dag‐en ko so niya kowan jo ey ari jon Hodiyos?” ");
INSERT INTO ibl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jet sota ira totoo, kimiyaw ira, ja kowan sha ey, “Paidansam shi koros!” ");
INSERT INTO ibl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kowan mowan nen Pilato son si‐kara ey, “Ngantoy? Ngaran ni dingka ton ngaaw aya?” Nem ema‐ma et i keljaw sha ja kowan sha ey, “Paidansam shi koros!” ");
INSERT INTO ibl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jet nontan ma, si Pilato, tep piyan ton mepnek sota eshakel la too, inbolos to ma si Barabas son si‐kara. Nem si Jesus, inpasepdat to nin asan toka i‐ẃat so nonta ira solsharo, ja sha idansa ma shi koros. ");
INSERT INTO ibl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sota ngo ira solsharo, indaw shes Jesus shima mismon baley nonta gobinarol, jet inolnong shen emin sota kait shen solsharo. ");
INSERT INTO ibl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sina‐datan shay baro to ni singa baro ni ari ni Roma, ja say kolor to, sota kowan sha ey violet. Tan say inpasing sha pay ni dedamsis sha, in‐inges sha ni ari. Isonga engosikos ira ni ẃakal la nasbitan ja inpaidnget sha son si‐kato, ja singa korona to. ");
INSERT INTO ibl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jet singa konon shaka panrispito‐a, ja kowan sha ey, “Onpalapalad ka koma, ari ni Hodiyos!” ");
INSERT INTO ibl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pineg‐as shay toktok to et tinopsha‐an sha, asan ma ira mantalimokod shi sango‐an to ni sinan pateg sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jet idi naksheng sota inpasing shen dedamsis, dinosora sota istay inpaibaro sha, jet in‐oli sha met laeng sota sigod ja baro to. Jet inbo‐day sha ma ja sha idansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nonta ireka man‐ekad, ẃara ngoy toon inaspol sha ja ondabas koma, ja si Simon i ngaran to, ja i‐Sirini. Istay ondaw koma shi siyodad, nem inpasakbat sha et son si‐kato sota koros ja kaydansa‐an nen Jesus. (Saja si Simon, ama nen Alejandro tan si Ropo.) ");
INSERT INTO ibl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jet indaw nonta solsharo si Jesus shima dogad ja kowan sha ey Golgota. (Jet say olog niya Golgota shi esel sha, toktok.) ");
INSERT INTO ibl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Idi mimotok ired man, in‐aknan shes Jesus ni adak ja edaokan ni agas ja eg to so dekna‐an ni ensakit. Nem eg to ineẃat. ");
INSERT INTO ibl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jet indansara ma shi koros. Jet idi naksheng nga indansara, nanbobonot sota ira solsharo no sipay ontompong so nonta ira baro nen Jesus, asan shaka panbibingayi. ");
INSERT INTO ibl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Say oras ni inkoros sha so nen Jesus, alas nowibi ni agsapa. ");
INSERT INTO ibl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jet ẃaray naysolat ja engikowan ni kabol ni naydansa‐an tod koros, ja kowan to ey, “Sajay sota ari ni Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jet ẃaray showen tolisan ja inpakibitay sha son si‐kato shi sanseskey ya koros. Sota sakey, ẃara nodta petek ni kanawan nen Jesus, tan sota sakey, ẃara nodta petek ngo ni kanigid to. ");
INSERT INTO ibl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Sajay i nantongpalan nonta naypadto nonta bayag da, ja kowan to ey, “Maybidang ey sakey ya bimasol.”) ");
INSERT INTO ibl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sotan ngo ira toon emandebas ja man‐ekad nodtan, ngini‐ngi‐ngi‐an sha, tan inbi‐bi‐ẃisan sha pay, ja kowan sha ey, “Towa! Kowan mo ey sheshalen moy Timplo jet bengonen mo mowan ni tedon akew! ");
INSERT INTO ibl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Apay nga eg mo isalakan i bakdang mo shorog, ja ondespag alid ta koros mo?” ");
INSERT INTO ibl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jet angken sota ira apo ni papashi ni Hodiyos, tan sota ira mamaistoro ni dinteg, ekingi‐ngi ngo ira, ja kowan sha ni tabtabal sha ey, “Insalakan to konoy eshom, nem eg to met isalakan i bakdang to shorog! ");
INSERT INTO ibl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kowan to ey si‐kato kono sota naypadton ibetkag ali nen Apo Shiyos ja mengisedakan, kowan to ey si‐kato kono sota ari ni Israel. Tiga, asen tayo noman no kaba‐dan ton ondespag alid ma koros to, say memati kito son si‐kato!” Jet sota kait ton showa ja inpakibitay sha son si‐kato, nan‐esel ngo ira ni ngaaw so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Idi nonta alas dosi ni ka‐akawan, nanbolinget nodtan na dogad ingkato nonta alas tris ni mama‐shem. ");
INSERT INTO ibl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jet idi nonta alas tris ni mama‐shem, si Jesus, kimeljaw ni makedsang, ja kowan to ey, “Iloy, Iloy, lama sabaktani!” (Say olog niya kowan to, “Shiyos ko, Shiyos ko, ngantoy in‐owayan mowak so?”) ");
INSERT INTO ibl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nem sota eshom ma toon ẃara nodtan, idi intenengan sha sota kowan nen Jesus, kowan sha ey, “Itnengiyo! Toka emo panta‐ẃala ali si Elias shi dangit!” ");
INSERT INTO ibl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jet sota sakey so nonta ira toon ẃara nodtan, kinano‐an ton en engi‐neng nonta singa bonot ja masbet ni shanom nodta empait ta tapey asan toka ipi‐ket shi pating. Jet in‐awat tod sobil nen Jesus, jet kowan to ey, “Ma‐sas ka no ondaw ali si Elias ja en mengpas son si‐kato alid ma koros!” ");
INSERT INTO ibl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jet si Jesus, inkedsang toy keljaw to mowan, asan ma ma‐bosi. ");
INSERT INTO ibl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jet nontan ma, sota masshel la kortina ja naysa‐din nodta kapatkan na kowadto shima naydaem ni Timplo, epi‐kat ta nanshowa, manipod nodta naytapew ingkatod ma despag. ");
INSERT INTO ibl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jet sota kapitan ni solsharo ja ẃara nodta naymamang ni kad‐an nen Jesus, idi inon‐an toy itsora ni inkatey nen Jesus, kowan to ey, “Agpayso gayam ey sajay ya too ket anak ni Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wara ngo iray bibii nodta naybabetaw ja engikadmang niyay ya epasemak. Jet say ngaran ira nonta eshom ma bibii ja ẃara nodtan, sajay: si Maria Magdalena, si Salome, tan si Maria ja ina ira nonta si Jose tan si Santiago ja inbeshayan shen Orishiyan. ");
INSERT INTO ibl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sajay iren bibii, nay‐olop ira son Jesus nonta ẃara pay laeng shi Galilia jet tinodongan sha alid man. Tan ẃara pay nodtan i eshakel la kait shen bibii ja ekidaw son Jesus manipod Galilia ingkatod Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Say akew wa edaga‐an niyay ya emin, sota kowan sha ey akew wa Pansekana ni para sota akew wa ngilin, jet no medebi, si‐katoy ibilang sha ey panshoki ma nonta akew ni ngilin. ");
INSERT INTO ibl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Isonga ẃaray manngeshan ni Jose, ja toon edapo nodta ili ni Jodia ja kowan sha ey Arimatia, intoled ton dimaw so nen Pilato ja to kinshaw i bakdang nen Jesus. (Sajay ya si Jose, sakey so nonta ira toray ni Hodiyos. Jet si‐kato, kaishayaw noman ni totoo. Tan sakey pay, si‐katoy sakey ya emansessesked ni isabi ali ni pantoshayan nen Apo Shiyos.) ");
INSERT INTO ibl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Idi dimaw si Jose ja to kekshawen sota bakdang nen Jesus, nasshaaw si Pilato ni in‐amta to so ey etey si Jesus. Isonga to inpa‐odop sota apo ni solsharo et inbag‐an to no agpayson etey si Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Idi kowan nonta apo ni solsharo son Pilato ey etey nga agpayso, inpalobos tos Jose ja en mengeda nonta bakdang nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Enongkal si Jose ni dopot ja para dibot ni etey, jet impas to alid ma koros i bakdang nen Jesus jet dinibotan to nonta empotin dopot ja tinongkal to, jet in‐ilaw to nodta baton diniyangan sha jet shiman i indiyangan to so. Jet inodin to sota ebadeg ga baton tangeb nonta diyang jet inpokit to nodta sakepan. ");
INSERT INTO ibl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jet si Maria Magdalena, tan sota sakey ya si Maria ja ina nen Jose, inon‐an sha iyay ya naydiyangan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Idi mama‐shem ma ja edabas da sota akew ni ngilin, si Maria Magdalena, si Salome, tan si Maria ja ina nen Santiago, enongkal ira ni danen emanseng‐ew, ja sha ipoyok koma nodta bakdang nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jet idi agsapa ni Domingko, ja emanbo‐day aliy sekit, dimaw ira nodta naydiyangan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Say tabtabal sha, kowan sha ey, “Sipay onposin mengkal ni baton naytangeb nodta bongot ni diyang say onsekep kito?” ");
INSERT INTO ibl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nem idi onshemang ira, inon‐an sha ey na‐kal gayam sota bato, ey ebadeg ga pasiya. ");
INSERT INTO ibl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Simekep ira nodta diyang et inon‐an shay balodakin nanbaro ni empoti ja edayag, ja timongaw nodta apit ni kanawan. Jet nasshaaw iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kowan nonta balodaki son si‐kara ey, “Karekayo messhaaw. Amtak ey say piyan jon on‐an, si Jesus ja i‐Nasarit ja naydansa shi koros. Nem enshid jay, nan‐ongal da! Asas jo kari ita istay inparokolan sha so. ");
INSERT INTO ibl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jet no asen jon enshi, daw kayo, jet jo ikowan so nonta ira too to ey nanbiyag mowan da, agdalo son Pedro. Jet niman, ondaw da si Jesus ja mepangdo ey si‐kayo shi Galilia, jet shiman i asanan jo so! Tep saman i inkowan to son si‐kayo nonta aneng pay laeng i ketey to.” Kowan nonta balodaki. ");
INSERT INTO ibl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bimo‐day mala ira sota bibii ja namtik ired diyang, tep ireka manbebayedbed ni takot sha. Jet enshiy sha inkokowan so ni angken sipa nontan tep eta‐kot ira. ");
INSERT INTO ibl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Idi naksheng nga nan‐ongal si Jesus ni agsapen pasiya ni Domingko, say kapangdo‐an na nanpa‐sasan to, si Maria Magdalena. (Sajay sota si Maria ja inpabtikan so nen Jesus ni piton dimonyo ja pimeket son si‐kato.) ");
INSERT INTO ibl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Jet si Maria ngo, dimaw so nonta ira too nen Jesus ja nay‐olop ni olay son si‐kato nontan da et sina‐kop to iren esa‐nop ja emandeshingit tan emannengis ni inkabono nen Jesus. Jet inkowan to son si‐kara ey, “Nanbiyag mowan si Jesus! Inon‐an kon mismo!” Nem idi intenengan sha, eg sha pinati. ");
INSERT INTO ibl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Idi naksheng iyay, nanpa‐sas mowan si Jesus so ni showen too to ja eman‐ekad ja edapod siyodad ni Jerusalem. Jet na‐apil i inpangidmang sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jet nan‐oli sota shadẃa, ja sha inkowan so ni eshom ma kait shen too nen Jesus, nem iso met laeng nga eg sha pinati. ");
INSERT INTO ibl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Idi naksheng nga nanpa‐sas si Jesus so iren jay, nanpa‐sas mowan so nonta ira sawal ni sakey ya apostol to nonta maramen ireka mengan. Jet inseg‐ang to ira ni eg sha so pinati‐an so nonta insodsod nonta ira engasas son si‐kato ni inpan‐ongal to; kowan to ey epaladoy katangken ni toktok sha. ");
INSERT INTO ibl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jet kowan to pay son si‐kara ey, “Daw kayo shi emin na sakop niya dobong jet jo ikowan so ni emin na totoo i mapteng nga shamag maypangkep son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sota memati tan mebonjagan, maysedakan ira, nem sota eg memati, shosa‐en ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Jet sota ira memati, mandeka ngo ira ni kaskasshaaw wa eẃatan so ni totoo ey podnoy shaka pan‐itoro. Say dag‐en shen kaskasshaaw, sajay: mengipebtik ira ni dimonyon pimeket shi totoo no i‐osal shay ngaran ko, man‐a‐sel ira ni eshakel la kalasin esel ja eg sha amta; ");
INSERT INTO ibl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","angken egni‐an sha pay i oleg tan inomen shay sabishong ja istay keteyan sha koma, eg ira mesekitan; tan ontakal iray emanpansekit no isakpal shay takday sha son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jet si Apo Jesus, idi naksheng nga inkowan to iyay son si‐kara, inda ma nen Apo Shiyos shi naykayang et en timongaw shi apit ni kanawan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jet sota ira toon inbilinan to so nonta inkowan to la, nansisi‐jan ira, ja sha intoro shi emin na dogad sota maypangkep son Jesus. Jet eki‐obda ngo si Jesus son si‐kara, isonga nayki‐det sota intoro shen esel nen Jesus, tep in‐aknan to pay ira ni panakabalin shen mandeka ni milagro. Siya, satan da.");
INSERT INTO ibl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Iyay i isolat ko son si‐kam, agi Teofilo: Eshakel day engipeshas ni kabaalan shen mengisodat ni edagdaga nonta timpon emekibibiyag pay laeng si Apo Jesus son si‐katejo, ");
INSERT INTO ibl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","jet inonod sha ni olay sota intoro met laeng nonta apostol nen Jesus, tep si‐karay sigod ja eki‐odo‐odop son si‐kato, si‐karay engasas ni inpaspasing to, tan si‐kara pay i inbetkag ton engitosho ni esel to. ");
INSERT INTO ibl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jet niman Teofilo, peshasen ko ngon isolat. Ninemnem ko ey mapteng emo nem si‐kak pay i sakey ya mengisodat tep inashal kon pasiyen emin sota edagdaga manipod nonta nanshogi‐an to ingkatod ka‐onoran. Isonga siningpet kon insolat iyay para son si‐kam, ");
INSERT INTO ibl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","say amta‐en mo pay i eshom ma podpodno, ja toloy nonta inashal mo la. ");
INSERT INTO ibl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nanshogi iyay ya emin nonta timpon inpantoray nen Ari Hirodis shi Jodia. Nontan da, ẃara ngoy parin nanngaran ni Sakarias, ja naykait so nonta gropo ni pari ja kowan sha ey Abiyas. Say ngaran ni aseẃen Sakarias, si Elisabet, ja poli ngo met laeng ni pari. ");
INSERT INTO ibl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sajay iren san‐aseẃa, mapteng i ogadira, ja shaka tongpalen emin i bilin nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nem enshiy anak sha tep basig si Elisabet. Eba‐kol ma si Elisabet tan edakay ngo ma si Sakarias. ");
INSERT INTO ibl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Idi sakey ya akew, naysa‐dat si Sakarias ja mansilbi son Apo Shiyos shi Timplo, tep say ogadi ni papashi ni Hodiyos nontan da, emansasa‐dat sota gropo ni pari ja mansilbi shi Timplo jet manbobonot ira no sipay sakey son si‐kara ja onsekep shi Timplon memool ni kowan sha ey insinso. Jet say epi‐not, si Sakarias. ");
INSERT INTO ibl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Idi maramen emankepooli sota insinso, emansheẃat sota ira totoo son Apo Shiyos shi bo‐dayan ni Timplo. ");
INSERT INTO ibl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Si Sakarias i ẃared ma naydaem ni Timplo, jet nontan, nanpa‐sas i anghil nen Apo Shiyos son si‐kato shi apit ni kanawan nonta damisaan ja kepankepooli nonta insinso. ");
INSERT INTO ibl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Idi inon‐an nen Sakarias sota anghil, eg to tongolan i pesing to, ta timakot. ");
INSERT INTO ibl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nem kowan nonta anghil son si‐kato ey, “Kareka ontakot Sakarias. Si Apo Shiyos, intenengan toy shawat mo et si aseẃam ma Elisabet, on‐anak ali ni daki. Jet say ingaran mo di son si‐kato, Juan. ");
INSERT INTO ibl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Man‐imdeng tan medadsakan ka din pasiya, tan eshakel pay aliy man‐imdeng ni kay‐enak to. ");
INSERT INTO ibl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bigbigen ali nen Apo Shiyos si Juan ja eshayaw. Eg ali menginom ni adak, ono ngaranton memoteng. Ishalan ali ni Ispirito Santo nen Apo Shiyos ni olay manipod kay‐enak to. ");
INSERT INTO ibl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eshakel aliy tood Israel ja pan‐odi ton memati son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wara son si‐kato i Ispirito Santo nen Apo Shiyos ja inges tos Elias ja para padto nonta bayag da, jet say kabedinan nen Elias, inges to ngo son si‐kato. Si‐kato nin i mepangdon mantosho shi Israel, asan kamotok sota naypadto nonta bayag da ja ibetkag ali nen Apo Shiyos ja mengisedakan. Si‐kato diy mengi‐odi ni semek ni san‐a‐ama ja eg man‐inawatan. Si‐kato diy memanshaan ni toon eg memati son Apo Shiyos, say nemnemen sha mowan i kosto, say mansekana i totoo ni imotok ali nen Apo.” Kowan nonta anghil. ");
INSERT INTO ibl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jet inbaga nen Sakarias ey, “Toway amta‐an ko so ey mepesamak iyay? Edakayak mala met, tan eba‐kol ngo ma si aseẃak.” ");
INSERT INTO ibl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kowan nonta anghil ey, “Si‐kak si Gabriel ja anghil. Naka mansilbi ni olay son Apo Shiyos et inbetkag towak ali ja mengikowan ni pansigshan mo di. ");
INSERT INTO ibl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nem si‐kam, eg ka memati ni kowan ko. Nem angken eg ka memati, kenshat ta mepesamak met laeng ni koston timpo to. Isonga niman ma, eg ka maka‐esel ingkatod mepesamak sota inkowan ko son si‐kam.” Kowan nonta anghil. ");
INSERT INTO ibl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Naysekeshan mala sota totood bo‐dayan et kowan sha ey, “Ngantoy? Ebayag ga pasiya si Sakarias shi Timplo.” ");
INSERT INTO ibl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Idi bimo‐day ali si Sakarias, eg ma maka‐esel et eg mebedin na mekitbal nodta totoo. Nakol ninemnem nonta totoo ey kenshat ta ẃaray inpa‐sas nen Apo Shiyos son si‐kato shi Timplo. Sininjas malay kepesing nen Sakarias ja mekitbal. ");
INSERT INTO ibl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Idi epospos may timpo ja pansilbi nen Sakarias shi Timplo, imakad si Sakarias shi baley to. ");
INSERT INTO ibl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Idi enshiy bayag to, eẃad‐an si Elisabet ta aseẃa nen Sakarias et nannongew shi baley sha ni dimen bolan. Nontan, kowan nen Elisabet ey, ");
INSERT INTO ibl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Niman ta tinodongan towak nen Apo Shiyos, malokonak ma. Isonga enshi may naka kaybebaingi shi totoo.” ");
INSERT INTO ibl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Idi mayka‐nem ma bolan ni dokon nen Elisabet, inbetkag mowan nen Apo Shiyos i anghil to ja si Gabriel shi ilin Galilia ja kowan sha ey Nasarit. ");
INSERT INTO ibl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Shiman i kawad‐an ni sakey ya balesang ja manngeshan ni Maria. Si Maria, enshiy to ined‐eshol la daki et si‐katoy naykarin esaw‐en ni sakey ya dakin manngeshan ni Jose, ja poli nen David ja ari nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Si Gabriel, dimaw son Maria et to inkowan ey, “Pan‐imdeng ka Maria, ta say ebadeg ga semek nen Apo Shiyos, ẃara son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eg amta nen Maria i pesing to nonta intenengan to sota inkowan ni anghil, tan toka en‐enapa nem ngarantoy olog nonta inkowan nonta anghil. ");
INSERT INTO ibl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nem kowan nonta anghil ey, “Kareka manshanag Maria, ta si Apo Shiyos, kinaasi‐an toka. ");
INSERT INTO ibl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Medokonan ka et daki aliy i‐anak mo, ja panngeshan mo di ni Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Meshedjaw ali, tan mayngadnan ja Anak nen Apo Shiyos sa Kangeto‐an. Jet si Apo Shiyos, pantoshay to ja inges toy inpantoray nen David ja apo to la. ");
INSERT INTO ibl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Si‐kato di ni olay i mengitoshay ni kait ton poli nen Jacob ingkatod ingka.” ");
INSERT INTO ibl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Say insongbat nen Maria so nonta anghil, kowan to ey, “Toway pesing nitan? Balesangak met! Enshiy nak ined‐eshol la daki!” ");
INSERT INTO ibl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kowan nonta anghil ma ey, “Sota Ispirito Santo nen Apo Shiyos i maka‐amta. Sota panakabalin nen Apo Shiyos, ẃara di son si‐kam. Isonga sajay alin nga‐nga, esanto‐an ja enshiy to di panbesolan, jet maykowan ali ey Anak nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Iman to pay, si Elisabet ja kasingsing mo ket iman i enem ma bolan na dokon to niman, ey eba‐kol ma, kowan sha ey basig pay. ");
INSERT INTO ibl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Enshi eshan i edigat so nen Apo Shiyos; kabedinan ton emin.” ");
INSERT INTO ibl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kowan ma nen Maria ey, “Naka pati‐a i kowan nen Apo Shiyos. Angka et nem mepesamak aliy kowan mo.” Sotan ey indekjas ma nonta anghil si Maria. ");
INSERT INTO ibl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Idi edabas i pigen akew, nansaganes Maria et dimaw shi karonshontogan ja sakop ni ilin Jodia, ");
INSERT INTO ibl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","tep shiman i kawad‐an nen Sakarias tan si Elisabet. Idi mimotok si Maria, imesel la shagos son Elisabet. ");
INSERT INTO ibl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Idi intenengan nen Elisabet sota esel nen Maria, nay‐inshas ngon kimeykey sota nga‐nged ekes nen Elisabet. Inkedsang nen Elisabet i esel ton intorong ni Ispirito Santo nen Apo Shiyos, ja kowan to ey, “Eshakel i bii, nem si‐kam i pinidi nen Apo Shiyos ja in‐aknan to ni ebadeg ga kaasi. Jet kaasi‐an to pay ali ta nga‐ngen i‐anak mo di. ");
INSERT INTO ibl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Apay sipa‐ak et ngon en binisita di ni ina ni Apok! ");
INSERT INTO ibl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Idi intenengan koy esel mo, nay‐inshas ngoy keykey niya dokon ko ni imdeng to. ");
INSERT INTO ibl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Siya, pinatim sota esel nen Apo Shiyos ja inpa‐amta to son si‐kam, ja mepesamak ali. Isonga binindisiyonan toka.” ");
INSERT INTO ibl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kowan nen Maria ey, “Ebadeg i shayaw ko son Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tan naka man‐imdeng kabol son Apo Shiyos sa mengisedakan son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tep eg towak in‐olay ya too ton ebaba. Niman ma, angken sipa, ikowan to ey si‐kak i kagesatan. ");
INSERT INTO ibl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Si Apo Shiyos ja Kangeto‐an, kabedinan ton emin i piyan ton dag‐en, et kinaasi‐an towak. ");
INSERT INTO ibl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manipod nonta pilmiron too ingkato niman, toka kaasi‐i sota toon mengiredjaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Si Apo Shiyos, kaskasshaaw i obden toka dagdag‐a. Angken sota nga‐ngaaw wa plano ni toon etangsit, toka bediwi. ");
INSERT INTO ibl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Si‐kato, toka pebeba i engaton emantoshay, nem toka ingatoy nankebaba. ");
INSERT INTO ibl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Toka i‐akni ni mapteng nga kasapolan sota ira na‐agang jet sota ira nankebaknang, angken ma‐ayshi‐anan ira. ");
INSERT INTO ibl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eg to dibkan i kari to son Abraham tan so ni emin na poli to, ja apo tayo da met laeng. Kaasi‐an toy too ton i‐Israel ingkatod ingka, jet niman, tinodongan shakito.” Sajay i iyaman nen Maria. ");
INSERT INTO ibl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Si Maria, nan‐iyan nin shi baley nen Elisabet ni tedon bolan, asan ka‐oli shi baley to. ");
INSERT INTO ibl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Simabi may timpon i‐anak nen Elisabet et imanak ni daki. ");
INSERT INTO ibl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jet idi inamta‐an nonta inaskang to tan partido to iyay ya ebadeg ga kaasi nen Apo Shiyos son si‐kato, eki‐imdeng ira son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Idi maykeẃalon akew nonta nga‐nga, dingkara sota ogadi ni Hodiyos ja shaka pesing ni dakin koyat. Sajay sota kowan sha ey kogit. Istay kowan sha ey Sakarias ngoy ingaran sha nonta nga‐nga say iboloy sha met laeng so nen tatang to. ");
INSERT INTO ibl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nem kowan nen ineto ey, “Enshi, say paingeshan tayo, Juan.” ");
INSERT INTO ibl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kowan ngo nonta ira too ey, “Nem enshi met i partidom ma nanngaran ni Juan.” ");
INSERT INTO ibl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jet sininjasan shes Sakarias ja tatang nonta nga‐nga, nem sipay piyan ton ingaran nonta nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jet insinjas nen Sakarias ey aknan sha ni pansodatan to, say isolat toy ngaran na piyan to. Jet say insolat nen Sakarias, “Juan i ngaran to.” Nasshaaw sota ira totoo nonta binasara sota insolat to. ");
INSERT INTO ibl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nay‐inshas ngo men maka‐esel mowan si Sakarias et nan‐iyaman son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jet emin ira sota inaskang sha, ẃaray dinmoren na‐ap‐apil la na‐amag. Jet nayẃaris iyay ya shamag shi emin na nanbaley shima shonshontog shi Jodia. ");
INSERT INTO ibl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Emin ira sota engitneng, kowan sha ey ẃares Apo Shiyos so nonta nga‐nga. Jet kowan sha ey, “Ngaranto emoy panbedinan ali niyay ya nga‐nga?” ");
INSERT INTO ibl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jet si Sakarias, intorong ni Ispirito Santo nen Apo Shiyos ja mengikowan ey, ");
INSERT INTO ibl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Salamat son Apo Shiyos, ja Shiyos ni Israel! Tep eg tokito binaybay‐an, asan si‐katoy mengisedakan son si‐katejon totoo to! ");
INSERT INTO ibl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Inbetkagan shakito ni makedsang nga mengisedakan ja mismon poli nen Ari David ja emepiyal la too nen Apo Shiyos nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Nonta bayag da, say inkari to, si‐katoy mengibediw son si‐katejo shi emin na toon kabakal tayon makakontra son si‐katejo. Sajay i inkowan ira nonta esanto‐an na para padto nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Say inkari to pay so nodta ap‐apo tayo nonta bayag da, kowan to ey todongan to ira ni olay et kenshat ta tongpalen to iyay ya kari ja enshiy kolang to. ");
INSERT INTO ibl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Say inkari to so nen Abraham ma apo tayo da, ");
INSERT INTO ibl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","si‐katoy mengibediw son si‐katejo shi kabakal tayo, say meẃedja‐an kito ni olay ja mansilbi son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ingkatod ketey tayo, ja enshiy to asen na pankodangan tayo ono kebedawan tayo. ");
INSERT INTO ibl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Si‐kam ma anak ko, no onba‐deg ka di, si‐kam ali sota ibetkag nen Apo Shiyos sa Kangeto‐an, ja mepangdon mengikowan nodta totoo ey mansekana ira ni imotok to. ");
INSERT INTO ibl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Say mo itoro so nonta totoon Apo Shiyos, ikowan mo ey maysedakan ira nem mepekawanan i basol sha, ");
INSERT INTO ibl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","tep si Apo Shiyos ja tayoka shedshedjawa, ebadeg i toka pengisekit son si‐katejo. Say arig ni pengisedakan to ali, singa silẃan to ali sota totoon imekok shi shalan ja edabi‐an, ja istay patey i toshongen sha. Jet si‐kato may mengitosho son si‐katejo ni shalan ja mantoshong shi talna.” Sajay i kowan nen Sakarias. ");
INSERT INTO ibl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sota nga‐ngen si Juan, bima‐deg, tan enemneman. Idi ebadeg ma, nan‐iyan ni olay si Juan shima dogad ja naybetaw shi kad‐an ni too, ingkatod simabi sota akew wa pengitosho to nonta sigod ja inkowan nen Apo Shiyos ja itoro to nodta tood Israel. ");
INSERT INTO ibl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nonta timpon inkay‐anak nen Juan, naytompong ngon ẃaray inbilin nen Ari Agusto ey mesepol la emin na tood dobong, manpedista ira. ");
INSERT INTO ibl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sajay i pilmiron sinsos ja na‐amag nonta timpon kagobinarol nen Kirino shi Siria. ");
INSERT INTO ibl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jet emin ira sota too, dimaw ira ja nanpalista, ja tinonton shay edapo‐an ni apo sha. ");
INSERT INTO ibl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Isonga si Jose, dima‐jat ngo shi baley tod Nasarit ja ilin Galilia et dimaw shi Bitlihim ma ilin Jodia, ja kawad‐an nen Ari David nonta bayag da. Shiman i dinaẃan nen Jose ja nanpalista‐an tep poli nen Ari David. Nan‐olop ira nen Maria, ja naykarin esaw‐en to et naytompong ngon malokon nontan si Maria. ");
INSERT INTO ibl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jet nonta ẃara ira med Bitlihim, simabi sota timpo malen i‐anak nen Maria. ");
INSERT INTO ibl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jet say in‐anak to, daki, ja si‐katoy besag. Dinampinan to et inparokol tod panganan ni animal. Sinodngan to iyay tep enshiy mebedin na ka‐okipan sha nodta baley ya koston shiẃesan. ");
INSERT INTO ibl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nontan na dabi, ẃara iray emanbantay ni kalniro shi bodosan ja nay‐esop shi Bitlihim. ");
INSERT INTO ibl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jet nontan, nanpa‐sas i sakey ya anghil nen Apo Shiyos son si‐kara. Jet sota niyal ja edapo son Apo Shiyos, sinilẃan to ira et etakot iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nem kowan nonta anghil ey, “Karekayo ontakot! Dimawak alin mengikowan ni mapteng nga shamag son si‐kayo, jet saja ikowan ko, pan‐imdengan ni emin na totoo. ");
INSERT INTO ibl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Niman na dabi, nay‐anak sota Apo tayon inkari nen Apo Shiyos nonta bayag da ja en ali mengisedakan son si‐kayo. Say nay‐anakan to, shi Bitlihim ja ili da nen Ari David. ");
INSERT INTO ibl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Say pengimatonan jo so, edampinan sota nga‐nga, ja nayparokol shi panganan ni animal.” Kowan nonta anghil. ");
INSERT INTO ibl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Idi naksheng nga inkowan to iyay, shimakel i anghil shi naykayang ja emengikankansiyon ni shayaw sha son Apo Shiyos, ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Si Apo Shiyos ja ẃared dangit i mayshedjaw! Jet niman, iyed jay i mengi‐kan ni talna shiya dobong so nonta ira toon kinosto‐an to.” ");
INSERT INTO ibl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Idi imoli ira sota anghil shi dangit, nantatabal ira sota emanpastol ni kalniro, ja kowan sha ey, “Ondaw kito ka ngarod shi Bitlihim, tayo asen sota nay‐anak ka nga‐nga ja inpa‐amta nen Apo Shiyos son si‐katejo.” ");
INSERT INTO ibl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kinano‐an shen dimaw shi Bitlihim et simbira si Maria tan si Jose et inon‐an sha sota nga‐ngen inparokol shed panganan ni animal. ");
INSERT INTO ibl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Idi inon‐an nonta emanpastol ni kalniro sota nga‐nga, inkowan sha son Maria nen Jose sota inkowan ni anghil maypangkep niyay ya nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jet emin ali ira sota engitneng ni inkowan nonta emanpastol ni kalniro, nasshaaw iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nem si Maria, eg to dibkan iyay ya epalabas, no diket ninemnemnem to ni olay. ");
INSERT INTO ibl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Imoli ira sota emanpastol ni kalniro, ja ebadeg i iyaman sha so nen Apo Shiyos maypangkep nonta emin na intenengan sha, tan inon‐an sha, tep etongpal sota inkowan ni anghil son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Idi edabas i ẃalon akew ni inkay‐anak nen Jesus, dingkara sota ogadi ni Hodiyos ja shaka pesing ni may‐enak ka daki, ja kowan sha ey kogit. Jet inpanngaran sha ni Jesus, tep nonta eg pay naydokon sota nga‐nga, inkowan nonta anghil ey Jesus i ingaran sha so nonta nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nonta shimanon sota timpon penongpalan shi Jose nen Maria nonta dinteg nen Moises maypangkep ni biin ipan‐anak to, ja kowan sha ey purification, indaw sha iyay ya nga‐nga shi Jerusalem say maybidang ey i‐awat shay biyag to son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sajay i inpasing sha tep say naysolat shi dinteg nen Apo Shiyos, “Emin na anak ni Hodiyos ja pangodowan na daki, mesepol la maybidang nga para son Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Si Maria tan si Jose, ira engi‐kan ni daton sha tep say kowan ni bilin nen Apo Shiyos, mesepol la mengi‐kan ira ni daton shen sanparis ja kalopati. ");
INSERT INTO ibl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jet nontan, ẃaray tood man ja si Simeon i ngaran to ja nanbaley shi Jerusalem. Makedsang i pamati to son Apo Shiyos, tan eshayaw ey mapteng nga too. Jet toka sesseskera i ketongpal nonta kari nen Apo Shiyos ey ẃaray ibetkag ton mengisedakan ni tood Israel. Jet say Ispirito Santo nen Apo Shiyos, ẃara son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sota Ispirito Santo nen Apo Shiyos, si‐katoy engi‐kan ni namnama to ey eg nin metey ingkatod on‐an to sota naypadto nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan. ");
INSERT INTO ibl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Intorong ni Ispirito Santo si Simeon shi Timplo et nontan na akew, indaw ngo nen Maria tan si Jose sota anak sha shi Timplo say dag‐en sha sota kowan ni bilin nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jet si Simeon, inakẃal to sota nga‐nga asan eman‐iyaman so nen Apo Shiyos ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Niman Apo Shiyos, tinongpal moy karim et ẃara ma son si‐kak i talna. Si‐kak ja baga‐en mo, palobosimak ja metey ma, ");
INSERT INTO ibl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tep inon‐an niya showen matak ma i inkowan mon mengisedakan ali, ");
INSERT INTO ibl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ja si‐katoy insaganam ma para so ni emin na totoo et si‐katoy pengamta‐an sha ni pesing shen maysedakan. ");
INSERT INTO ibl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Si‐katoy may‐eshig ga silew ja ondawag ni toon eg maka‐amta son si‐kam Apo Shiyos, tan si‐katoy mengi‐kan ni kayshedjawan ni toom ja Israel.” Sajay i iyaman nen Simeon. ");
INSERT INTO ibl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sota ama tan ina nonta nga‐nga, nasshaaw ira nonta inkowan nen Simeon ni maypangkep niyay ya nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Jet kowan pay nen Simeon ey, “Si Apo Shiyos i onbindisiyon son si‐kayo. Jet iyay i ikowan ko son si‐kam ja ina niya nga‐nga. Sajay ya nga‐nga, shinotokan nen Apo Shiyos et si‐katoy panshoki‐an ni pandilinasin ira ni tood Israel. Eshakel i mengokes son si‐kato, tan eshakel ngoy memati son si‐kato ni pansigshan sha, tep idawdawag toy ngaaw wa nemnem ni eshakel la too. Maydesin ey ẃara son si‐kato si Apo Shiyos, nem bedawen ni eshom. Jet si‐kam ja ineto, sajay ya ibalaw sha di son si‐kato, si‐katoy kesekitan ni posom.” ");
INSERT INTO ibl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Waray biin para padto ja eba‐kol ja si Ana i ngaran to. Anak nen Panoil, ja poli nen Asir. Nontan met laeng nga oras, mimotok sota eba‐kol nodta kawad‐an sha et nan‐iyaman so nen Apo Shiyos maypangkep nonta nga‐nga, jet to inkowan i maypangkep nontan na nga‐nga so ira nonta kait ton emansessesked so nonta ibetkag ali nen Apo Shiyos ja mengisedakan ni tood Jerusalem. Saja eba‐kol, piton tawen na ekibiyag son aseẃa to da nonta kamashikit to et niman, ebalo. Nantawen ni ẃalon polo tan epat. Wara ni olay shima Timplo; inakew tan dinedabin toka ibiyang i pangan to ni toka pansheẃat son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Idi naksheng nga tinongpal shen emin sota kowan ni bilin nen Apo Shiyos ey dag‐en sha, imoli ira shi Galilia, shi baley shed Nasarit. ");
INSERT INTO ibl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sota nga‐nga, bima‐deg, tan kimedsang. Enemneman ma, tep tinodongan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinaw‐en ja sota ama tan ina nen Jesus, ireka ondaw shi Jerusalem ni timpon piyasta ni Hodiyos ja kowan sha ey Paskowa. ");
INSERT INTO ibl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nonta nantawen si Jesus ni sampolo tan showa, dimaw ira mowan shi Jerusalem ni timpon piyasta. ");
INSERT INTO ibl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Idi naksheng sota piyasta, dima‐jat iren on‐akad shi baley sha ma, nem eg amta nen Maria tan si Jose ey edekjas si Jesus shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","San‐akew ja nan‐akad ira ja eg sha dindinmo ey ayshi si Jesus. Kowan sha nem eki‐odop nodta kagait sha, nem idi sha inena‐enap nodta kad‐an ni kagajem sha tan partido sha, ayshi gayam. ");
INSERT INTO ibl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jet idi eg sha simpol, nay‐oli ired Jerusalem et sha inenap. ");
INSERT INTO ibl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Idi maykatdon akew, simbira shi Timplo, ja ekitongaw so nonta ira mamaistoro ni Timplo. Toka itentenengiy kowan sha et nansalodsod ngo son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jet emin ira sota engitneng ni daing ton onsongbat so nonta ira mamaistoro, nasshaaw iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Si Maria tan si Jose, nasshaaw ngo ira ni in‐asas sha so et kowan nen ineto ey, “Anak ko, apay nga dingkam iyay son si‐kami? Si amam tan si‐kak, eshanagan kamin pasiya ni ana‐anap mi son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kowan nen Jesus son si‐kara ey, “Dimaw kayo gayam ali ja jowak kepan‐enapa? Eg jo aya amta ey mesepol la man‐iyanak shi baley nen Amak?” ");
INSERT INTO ibl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nem eg sha ineẃatan sota kowan to son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jet si Jesus, ekidaw son si‐kara ja imakad shi Nasarit, ja toka pati‐en emin i kowan sha son si‐kato. Si ineto, emin iyay ya banag, toka nemnemnema shi poso to. ");
INSERT INTO ibl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Si Jesus, bima‐deg, makedsang, tan enemneman tep si Apo Shiyos, ẃara son si‐kato, jet eshakel i toon makapiyan son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Idi kinsin tawen ja nantoray si Ari Tibirio shi Roma, ẃaray inkowan nen Apo Shiyos ja bilin to so nen Juan ja anak nen Sakarias. Wara nontan si Juan shima dogad ja nay‐araẃid kadnan ni too. Jet ẃinasẃas ton emin i dogad shima kilig nonta ebadeg ga pa‐dok ja kowan sha ey Jordan, ja to intod‐an iray totoo. Jet say kowan to, “Mesepol la manbebawi kayo, asan kayoka manpabonjag, say pekawanan nen Apo Shiyos i basol jo.” Nontan ngon timpo, si Poncio Pilato i gobinarol shi Jodia, si Hirodis ngod Galilia, tan si Felipe ja agi nen Hirodis shi Itoria tan shi Trakoniti. Asan si Lisanias i toray shi Abilini. Say kangeto‐an nontan ja pari, si Anas nen Kaipas. ");
INSERT INTO ibl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sota inpantoro nen Juan, si‐katoy nantongpalan nonta padto nen Isaias nonta bayag da, ja kowan to ey ẃara aliy toon ikeljaw toy esel to shima dogad ja nay‐araẃi shi kad‐an ni totoo, ja ikowan to ey, “Pansagana kayo ni para imotok ali nen Apo! Singpet joy shalan na pan‐akshan to! ");
INSERT INTO ibl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","No nankinayang i shalan shi shonshontog, simpayo. No kolkolba ja shalan, mesepol ja maydelteg, tan sota ngaaw ngon shalan, mesepol la medimpiyo. ");
INSERT INTO ibl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jet emin na too, asen shay mengisedakan ja medepo ali son Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Say kowan nen Juan so nonta ira toon dimaw son si‐kato, ja kowan sha ey ira manpabonjag, kowan to ey, “Si‐kayo, singa oleg i ogadiyo! Say kowan jo, mebedin na disi‐an jon eg meshosa no manpabonjag kayo bengat? Enshi! Mesepol la ma‐sas shi ogadiyo ey nanbebawi kayo pangkep nonta basol jo. Karejo panshindan sota kowan jo ey si‐kayo ket poli shakejo nen Abraham. Enshi, eg on‐anay! Si Apo Shiyos, mebedinan ton osalen i bato ja palsowa‐en na too jet kowan to ey poli nen Abraham. ");
INSERT INTO ibl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jet niman, ẃaray naysagana ja may‐eshig ey mayẃa‐tek shi damot ni kadasan ja eg ondames ni mapteng. Emin ira jay, mebetang et maypool shi apoy.” Sajay i kowan nen Juan so ni totoon dimaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jet sota ira totoo, nansalodsod ira ja kowan sha ey, “Nganto ngarod i pesing mi?” ");
INSERT INTO ibl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Simongbat si Juan ja kowan to ey, “No showay barom, i‐kan moy sakey so nonta enshiy osal to. Kasta met no ẃaray sobdam ja mekan, i‐aknim sota ira toon enshi‐anan.” ");
INSERT INTO ibl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Angken sota ira para singil ni bowis, dimaw ira ngon manpabonjag, jet inbag‐an sha ngo si Juan ja kowan sha ey, “Maistoro, ngaranto ngoy pesing mi?” ");
INSERT INTO ibl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Simongbat mowan si Juan ja kowan to ey, “Niman, say singilen jon bowis ira ni totoo, sota koskoston kowan ni gobirno; karejo sodokan.” ");
INSERT INTO ibl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jet sota ira solsharo, kowan sha ngo ey, “Si‐kami ngay? Ngaranto ngoy pesing mi?” Si Juan, simongbat ja kowan to ey, “Sota sowilshoyo, si‐katoy enosan jo. Ibi‐jag joy joka pesing nga mengeda ni pilak ni too ja joka ira ta‐ta‐kota tan joka pebesoli ira angken enshiy basol sha.” ");
INSERT INTO ibl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sota ira totoo, idi intenengan shay kowan nen Juan, kowan shen shorog shi nemnem sha ey, “Sigosho sajay emo sota inkari nen Apo Shiyos nonta bayag da ja ibetkag to din mengisedakan.” Jet shaka sesseskeren pasiya nem ngaranto pay i ikowan to. ");
INSERT INTO ibl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nem say kowan nen Juan son si‐kara, kowan to ey, “Nem si‐kak, dimawak ali ja shanom i inpamonjag ko son si‐kayo. Nem ẃaray ondaw alin maysa‐dat son si‐kak ja ebadbadeg i panakabalin to nem say si‐kak. Jet ekak pay maykeshi ja angken baga‐en to koma ja mengkal ni sapatos to. Jet sotan aliy onbonjag son si‐kayo ni Ispirito Santo nen Apo Shiyos, asan pay ya apoy.” ");
INSERT INTO ibl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jet si Juan, in‐arigan to ira ja kowan to ey, “Sotan aliy may‐eshig ey mengisi‐jan ni bekas shi taap. Sota bekas, isingpet tod tado‐an, nem sota taap, ipool tod apoy ya emanshedang ni olay ja eg ma‐ma‐shep.” ");
INSERT INTO ibl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sajay i inpasing nen Juan ni inpamidin to, tan na‐na‐jew pay i inpasing ton engikowan ni mapteng nga shamag so ira ni totoo. ");
INSERT INTO ibl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nem say inkowan to son Hirodis ja gobinarol shi Galilia, kowan to ey, “Ngaaw i inpiliw mo so nen Hirodiyas ja aseẃa nen agim. Tan ẃara pay i eshakel la ngaaw ja aramid mo.” ");
INSERT INTO ibl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nem si Hirodis, endedamsis to sota bilin nen Juan son si‐kato; mina‐ma to et i kakedsel to, ja inbalod to pay si Juan. ");
INSERT INTO ibl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Idi sakey ya akew, ja naksheng iren emin sota totoo ja nanpabonjag, nanpabonjag ngos Jesus so nen Juan. Idi naksheng, nanshawat si Jesus son Apo Shiyos, jet idi maramen emansheẃat, edo‐katan i dangit. ");
INSERT INTO ibl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jet dimespag aliy Ispirito Santo nen Apo Shiyos son si‐kato, ja na‐sas ja singa inges toy itsora ni kalopati. Jet si Apo Shiyos, imesel alid dangit ja kowan to ey, “Si‐kam i Anak ko et ensemek taka, tan si‐kam i naka pan‐imdengi.” ");
INSERT INTO ibl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Si Jesus, ẃaray tedon tawen to nonta inshogi ton engitosho. Jet say pangkep ira ni karakdan, kowan sha ey anak nen Jose. Iyay i ngarangaran iren makapoli so nen Jose. Say ama nen Jose, si Eli; ");
INSERT INTO ibl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","say ama nen Eli, si Matat; say ama nen Matat, si Levi; say ama nen Levi, si Melki; say ama nen Melki, si Yanay; say ama nen Yanay, si Jose; ");
INSERT INTO ibl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","say ama nen Jose, si Matatias; say ama nen Matatias, si Amos; say ama nen Amos, si Naom; say ama nen Naom, si Isli; say ama nen Isli, si Nagay; ");
INSERT INTO ibl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","say ama nen Nagay, si Maat; say ama nen Maat, si Matatias; say ama nen Matatias, si Simi; say ama nen Simi, si Josik; say ama nen Josik, si Joda; ");
INSERT INTO ibl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","say ama nen Joda, si Joanan; say ama nen Joanan, si Risa; say ama nen Risa, si Sorobabil; say ama nen Sorobabil, si Salatiil; say ama nen Salatiil, si Niri; ");
INSERT INTO ibl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","say ama nen Niri, si Melki; say ama nen Melki, si Adi; say ama nen Adi, si Kosam; say ama nen Kosam, si Ilmodam; say ama nen Ilmodam, si Ir; ");
INSERT INTO ibl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","say ama nen Ir, si Josue; say ama nen Josue, si Ilisir; say ama nen Ilisir, si Jorim; say ama nen Jorim, si Matat; say ama nen Matat, si Levi; ");
INSERT INTO ibl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","say ama nen Levi, si Simeon; say ama nen Simeon, si Joda; say ama nen Joda, si Jose; say ama nen Jose, si Jonan; say ama nen Jonan, si Iliakim; ");
INSERT INTO ibl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","say ama nen Iliakim, si Milia; say ama nen Milia, si Mina; say ama nen Mina, si Matata; say ama nen Matata, si Natan; say ama nen Natan, si David; ");
INSERT INTO ibl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","say ama nen David, si Jesse; say ama nen Jesse, si Obid; say ama nen Obid, si Boos; say ama nen Boos, si Salmon; say ama nen Salmon, si Naason; ");
INSERT INTO ibl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","say ama nen Naason, si Aminadab; say ama nen Aminadab, si Aram; say ama nen Aram, si Arni; say ama nen Arni, si Isrom; say ama nen Isrom, si Piris; say ama nen Piris, si Joda; ");
INSERT INTO ibl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","say ama nen Joda, si Jacob; say ama nen Jacob, si Isaac; say ama nen Isaac, si Abraham; say ama nen Abraham, si Tari; say ama nen Tari, si Nakor; ");
INSERT INTO ibl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","say ama nen Nakor, si Sirog; say ama nen Sirog, si Ragaw; say ama nen Ragaw, si Pilig; say ama nen Pilig, si Ibir; say ama nen Ibir, si Sala; ");
INSERT INTO ibl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","say ama nen Sala, si Kainan; say ama nen Kainan, si Alpiksad; say ama nen Alpiksad, si Sim; say ama nen Sim, si Noe; say ama nen Noe, si Lamik; ");
INSERT INTO ibl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","say ama nen Lamik, si Matosalin; say ama nen Matosalin, si Inok; say ama nen Inok, si Jarid; say ama nen Jarid, si Makaliil; say ama nen Makaliil, si Kainan; ");
INSERT INTO ibl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","say ama nen Kainan, si Inos; say ama nen Inos, si Sit; say ama nen Sit, si Adan; say ama nen Adan, si Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Si Jesus, nonta inpanbonjag to, ẃara nodta ebadeg ga pa‐dok ja kowan sha ey Jordan. Napno si Jesus ni Ispirito Santo nen Apo Shiyos et idi indekjas toy Jordan, intorong ni Ispirito Santo ja ondaw shima dogad ja araẃid kawad‐an ni too. ");
INSERT INTO ibl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Epat ta polon akew ja pineshas nen Satanas si Jesus nodtan na dogad ja dinaẃan to, ja piyan ton panbesol. Eg eng‐engan nontan na timpo si Jesus, jet idi epospos ma sota epat ta polon akew, na‐agang. ");
INSERT INTO ibl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jet kowan nen Satanas son si‐kato ey, “No agpayson anak toka nen Apo Shiyos, ikowan mo niya bato ey manbedin ni tinapay.” ");
INSERT INTO ibl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nem si Jesus, simongbat ja kowan to ey, “Enshi, ta say naysolat nonta bayag da ja bilin nen Apo Shiyos, kowan to ey, ‘Aliẃen mekan ni abos i panbiyag ni too.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jet si Satanas, indaw to si Jesus shi ekayang nga dogad et inpa‐sas ton emin iray ilid ja dobong ni sanka‐atikan na timpo. ");
INSERT INTO ibl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kowan nen Satanas son si‐kato ey, “I‐akan ko son si‐kam ma emin iyay ja kokowa‐en mo, jet si‐kam may mengitoshay ja enshiy maka‐inges son si‐kam. Ta nay‐awat iyay ya emin son si‐kak, jet i‐awat ko ngo ni piyan kon pengi‐kanan. ");
INSERT INTO ibl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Emin ira jay, i‐akan ko son si‐kam no si‐kak i pantedimokoshan mo ja panshedjawan.” ");
INSERT INTO ibl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nem si Jesus simongbat ja kowan to ey, “Enshi, ta say kowan ni esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey si‐kato bengat i panshedjawan min totoo tan pansilbi‐an mi.” ");
INSERT INTO ibl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jet si Satanas, indaw tos Jesus shi Jerusalem, jet to inpa‐tok nodta Timplo, jet kowan to son Jesus ey, “No agpayson anak toka nen Apo Shiyos, pan‐ekas ken medepod jay. ");
INSERT INTO ibl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta say kowan met ni naysolat nonta bayag da, kowan to ey, ‘Ibilin nen Apo Shiyos so nonta anghil to ey ajowanan shaka.’ Isonga eg ka mesekitan. ");
INSERT INTO ibl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tan say kowan pay nonta naysolat, ‘Egni‐an shaka ni takday sha, say eg mesekitan i sedim ni bato.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nem si Jesus, simongbat ja kowan to ey, “Enshi, ta say kowan mowan ni naysolat nonta bayag da, kowan to ey eg mi pedpeshasen si Apo Shiyos ja pengasan mi nem i‐agpayso to sota inkowan to.” ");
INSERT INTO ibl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Idi naksheng ja pineshas nen Satanas ja inparas ton emin i kabaalan to, ja piyan ton panbesol si Jesus, indekjas to nin. ");
INSERT INTO ibl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jet si Jesus, nay‐olid Galilia, ja ẃara ma son si‐katoy panakabalin ni Ispirito Santo nen Apo Shiyos. Sota shamag pangkep son si‐kato, nayẃaris shi emin na ilid man. ");
INSERT INTO ibl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jet si Jesus, nantoro shima sa‐nopan ni Hodiyos et eshakel iray engiredjaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dimaw si Jesus shi Nasarit, ja ilin bina‐degan to. Ogadi ton emekisa‐sa‐nop so nonta ira kait ton Hodiyos shima baley ja sa‐nopan sha no akew ja kepanngidin ni Hodiyos. Isonga idi shimanon sota akew ni ngilin, dimayat nodta sa‐nopan ja ibasa toy sakey so nonta inpaisolat nen Apo Shiyos nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jet say in‐awat shen ibasa to, sota naysolatan ni padto nen Isaias. Binitdag to et simbi to sota naysolatan ni padton kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sota Ispirito Santo nen Apo Shiyos, ẃara son si‐kak. Shinotokan towak ja mengitosho ni mapteng nga shamag so ni nankebiteg. Inbetkag towak alin mengipedawag ni kaybodosan ira ni ebalod, say man‐esas iray nankekorab, tan inbetkag towak alin mengi‐kan ni pannam‐ayan ira ni toon kepedigata ni kait sha, ");
INSERT INTO ibl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tan en mengipedawag nem pigan aliy timpon kaysedakan ni totoo nen Apo.” ");
INSERT INTO ibl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Idi naksheng nga inbasa nen Jesus iyay, kinopikop to sota papil la naysolatan to, jet in‐oli to ja in‐akan so nonta para tolong nodta sa‐nopan ni Hodiyos. Timongaw ja mengitosho et emin ira sota too, shaka iningning ni shaka pansesked ni ikowan to pay. ");
INSERT INTO ibl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jet kowan to son si‐kara ey, “Sajay ya padto nen Isaias nonta bayag da ja inbasak son si‐kayo, nayto‐to‐ẃa ma niman.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jet sota toon engitneng, shaka kosto‐is Jesus, nem nasshaaw iren emin nonta kalaing ton man‐a‐sel, ja kowan sha ey, “Aliẃen sajay aya sota anak nen Jose?” ");
INSERT INTO ibl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jet kowan nen Jesus ey, “Amtak ey endedamsis jo iya naka dagdag‐a, ja ikowan jo son si‐kak sota arig ga kowan to ey, ‘Doktor, agasim koma nin shorog i bakdang mo.’ Asan ikowan jo pay son si‐kak ey, ‘Dagam nin shiya ilim i kaskasshaaw wa milagro, no agpayso sota shinemag min inpasing mod Kapirnaom.’ ");
INSERT INTO ibl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nem iyay i ikowan ko son si‐kayo. Sota toon mengikowan ni esel nen Apo Shiyos, enshiy shayaw tod ili ton mismo. ");
INSERT INTO ibl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Singa inges to nonta timpon Elias nonta bayag da, ja eg to inpan‐oran ni tedon tawen tan enem ma bolan. Paladoy bitil shi emin na dogad shi Israel. Jet nontan, eshakel la agpayso i ebalo shiya Israel, ");
INSERT INTO ibl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","nem eg dimaw si Elias so ni angken sakey koma son si‐kara. Say dinaẃan to et ngo mowan, sota ebalo ja i‐Siripta, ja nanbaley shi sakop ni Sidon. ");
INSERT INTO ibl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Asan sakey pay, eshakel iray ebaybayang nga emin i bakdang to ja ẃara shi Israel nonta timpon Ilisio ja para padto, nem angken sakey son si‐kara, enshiy en na‐agasan. Nem say na‐agasan et ngo mowan, si Naaman bengat ja i‐Siria.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jet emin ira sota toon ẃara nodta baley ja sa‐nopan ni Hodiyos nontan, ireka onbanonget ni inteneng sha so niyay. ");
INSERT INTO ibl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jet ebiglen singkel sha et inkoyod shen inpa‐kal nodta ili sha et indaw sha nodta toktok ni shontog ja nanbaljan sha, ja kowan sha ey sha i‐ekas nodta shepdas. ");
INSERT INTO ibl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nem nan‐akad si Jesus shi kawa ira nonta eshakel la totoo et indekjas to ira. ");
INSERT INTO ibl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dimaw si Jesus shi Kapirnaom ja ili ni Galilia, jet toka itod‐i ira ma totood man nem akew ja kepanngidin ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Emesshaaw sota totood man ni toka pengitosho tep agpayson ẃaray pateg ni toka ikowan. ");
INSERT INTO ibl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jet nonta ẃares Jesus nodta baley ja sa‐nopan, ẃara ngoy sakey ya toon eman‐engaw ja pingketan ni dimonyo. Jet inkedsang nontan i keljaw to, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Ngantoy! Dimaw ka di ja en meneshal son si‐kami? Enshiy kaybiyangan mo son si‐kami, Jesus ja i‐Nasarit. Amtak nem sipa ka: si‐kam sota shinotokan nen Apo Shiyos ja inbetkag to di!” ");
INSERT INTO ibl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Si Jesus, sinelkag to sota dimonyo, ja kowan to ey, “Eka‐eket ka! Ilekjas mo ita too!” Jet sota dimonyo, inbes‐ig to sota too nodta naykawa ira nonta totoo jet indekjas to sota too. Nem pesed da, eg to sinekitan. ");
INSERT INTO ibl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nasshaaw iren emin sota toon engasas, jet kowan sha ni sakey tan sakey son si‐kara ey, “Epateg ga emin i banag ni toka ikowan! Kabaalan ton pemapteng i nemnem ni eman‐engaw! No ikowan to ey onbetik i dimonyo son si‐kara, ireka onbetik ka agpayso!” ");
INSERT INTO ibl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jet sajay ya shamag pangkep so nen Jesus, nayẃaris shi emin na dogad ja nay‐esop shiman. ");
INSERT INTO ibl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Indekjas nen Jesus sota baley ja kesa‐nopi ni Hodiyos et dimaw shi baley nen Simon Pedro. Sota inepo nen Simon ja bii, emansekit, ja epaladoy petang ni bakdang to. Jet inpa‐amtara son Jesus ey emansekit. ");
INSERT INTO ibl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Si Jesus, dimaw, ja to inon‐an nodta katiri to, jet inkowan to nonta sakit ey ma‐kal et na‐kal la agpayso. Jet bimangon na shagos sota bii et inkamakaman to ira. ");
INSERT INTO ibl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Idi mama‐shem mala, emin ira sota ẃaray kajem to ja emansekit ni ekalkalasin sakit, indaw sha ira son Jesus. Insakpal nen Jesus i takday to so ni sakey tan sakey son si‐kara et mimapteng iren emin. ");
INSERT INTO ibl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Angken sota ira dimonyon pimeket shi totoo, bimetik ira, ja kaonkaneljaw, ja kowan sha ey, “Si‐kam sota Anak nen Apo Shiyos!” Nem si Jesus, sinelkag to ira tep amtara ey si‐kato sota inkari nen Apo Shiyos nonta bayag da ja inbetkag to di. ");
INSERT INTO ibl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Idi palbangon ma, indekjas nen Jesus sotan na dogad jet dimaw shi naydasin na dogad ja enshiy totoo. Nem emin ira sota totoo, dimaw iren sha inenap et idi simpol sha, inparas shen inpeked. ");
INSERT INTO ibl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nem kowan to son si‐kara ey, “Mesepol ja nak ikowan shi eshom ma dogad ngo sota mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos, ta si‐katoy obdak ja inbetkagan towak so nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jet nantoro shima balebaley ja sa‐nopan ni Hodiyos shi ka‐ili‐ili ni Jodia. ");
INSERT INTO ibl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Idi sakey ya akew, ẃara si Jesus nodta kilig ni baybay ni Ginasarit et sota ira totoo, insopan shen pasiya, ja inedibongbongan sha. Shaka pan‐itenengin pasiya sota toka pan‐ikowan ja esel nen Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","jey on‐an to i showen bangka shima kilig ni baybay ja naytangkag. Sajay ya bangka, indekjas ira nonta emannikay tep shaka pan‐idaba sota embanaw wa balshew sha. ");
INSERT INTO ibl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Si Jesus, en nandogan nodta bangka nen Simon et inkowan to son Simon ey itolshon to sota bangka say onbetaw ni otik shima kilig ni baybay. Timongaw si Jesus nodta bangka et tinod‐an to ira sota eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Idi naksheng nga nan‐esel si Jesus, inkowan to so nen Simon ey, “Igeẃam iya bangka shima debeng nga shanom et si‐kam tan sama kait mo, i‐kas jo ira ta balshew jo say ẃaray mekna.” ");
INSERT INTO ibl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kowan nen Simon ey, “Apo, nan‐obda kamin pasiya ni sandabi, nem enshin polos i mi kinna. Nem no si‐katoy kowan mo, iparas kon i‐ekas.” ");
INSERT INTO ibl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Idi in‐ekas sha sota embanaw wa balshew sha, nakna iray eshakel la nigay. Istay pay ya mebi‐nik sota balshew. ");
INSERT INTO ibl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Isonga tina‐ẃay sha sota kait sha ja ẃara nodta sakey ya bangka ja on‐atang pay son si‐kara. Dimaw ira di et pinnora sota showen bangka ni nigay, jet istay pay ya ondened ira. ");
INSERT INTO ibl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Idi inon‐an nen Simon Pedro iyay, nantalimokod shi sango‐an nen Jesus, jet kowan to ey, “Ilekjas mowak Apo, ta si‐kak, eshakel i basol kon too!” ");
INSERT INTO ibl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Si Simon tan sota ira emin na kait to, nasshaaw ira nonta eshakel la ninikay sha. ");
INSERT INTO ibl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Eshakel i kait nen Simon nontan et say showa son si‐kara, si Santiago nen Juan, ja san‐agin anak nen Sibidi, ja sigod ja ka‐od‐odop nen Pedro ni olay. Kowan nen Jesus so nen Simon ey, “Kareka ontakot; manshoki ma niman, aliẃa men nigay i obdam, no diket mengolnong ka ma ni too ja itod‐an mo para son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Idi inkowan nen Jesus iyay, inkoyod sha sota bangkara shima kilig ni baybay. Indekjas sha sota ira bangkara, tan angken pay sota emin na kokowa sha, jet nay‐olop ira son Jesus ja nanbalin iren too to. ");
INSERT INTO ibl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Idi pinsak, ẃara si Jesus nodta sakey ya ili ja kawad‐an ni toon ebayabayang i bakdang to. Idi inon‐an tos Jesus, injokmos toy dopa tod bo‐day ja simango son Jesus, ja kowan to ey, “Apo, no piyan mo, pamapteng mo iya bakdang ko, say eg sha‐ak seskigen ni totoo.” ");
INSERT INTO ibl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jet si Jesus, inojad toy takday to et pinishat to sotan na too. Jet kowan nen Jesus son si‐kato ey, “Siya, piyan kon onmapteng ka.” Jet nay‐inshas ngon na‐omas sota bayang nonta too. ");
INSERT INTO ibl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jet si Jesus, binidin to sotan na too, ja kowan to ey, “Karam ikokowan iyay so ni eshom, no diket pandiritso ka et ja ondaw shima pari. Ipa‐sas mo ita bakdang mo son si‐kato, ja mimapteng ma. Jet pangidaton ka nonta kowan nen Moises shi dinteg ey maydeton son Apo Shiyos, say amta‐en ni karakdan ey si‐kam, enshi may bayang mo.” Kowan nen Jesus son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nem sota shamag maypangkep so nen Jesus, asdeg ton nayẃaris pay shima angken araẃin dogad jet sota ira eshakel la totoo, dimaw iren en nanteneng ni kowan to, tan sha inpa‐ekas i sakit sha. ");
INSERT INTO ibl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nem indekjas to sota eshakel la totoo et dimaw shima dogad ja nay‐araẃid kawad‐an ni totoo, ja en nanshawat so nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Idi sakey ya akew, emantosho si Jesus, jet ẃara ira sota Parisiyo tan mamaistoro ni dinteg ni Hodiyos ja timanongaw. Edapo ired ma emin na ili ni Galilia, Jodia, tan shi Jerusalem. Sota panakabalin nen Apo Shiyos ja mengkal ni sakit, ẃara son Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jet nontan, ẃara ngo diy totoo ja emangtal ni toon eg onkeykey i bakdang to, ja idaw sha son Jesus. Inparas shen isekep nodta baley ja kowan sha ey sha peshokol koma shi kad‐an nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nem eposek et enshiy pesing shen mengiskep. Say inpasing sha ma, inkalab sha nodta atep ni baley ja nanshekdan et binotbotan sha sota atep, asan shaka oy‐oya sota toon shimokol shi amaka. Jet insepara nodta kawa ira ni totoo, ja kad‐an nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Idi inon‐an nen Jesus i ebadeg ga pamatira, kowan to nonta toon inoy‐oy sha ey, “Kajem ko, sota basol mo, epakaẃanan.” ");
INSERT INTO ibl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sota ira mamaistoro ni dinteg ni Hodiyos, tan sota ira Parisiyo, ja ẃara nodtan, kowan shed nemnem sha ey, “Sipa iyay ya toon toka pa‐so‐is Apo Shiyos! Kowan to ey ememekawan ni basol, ey enshi met i eshom ma memekawan ni basol, nem eg si Apo Shiyos bengat!” ");
INSERT INTO ibl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nem si Jesus, amta toy ẃared nemnem sha et kowan to son si‐kara ey, “Apay nga joka sopngiled poso jo iyay ya kowan ko? ");
INSERT INTO ibl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Say kowan jo, inba‐ngat kon memekawan ni emin na basol niyay ya too ey ekak kabaalan? Nem iyay i dag‐en kon pati‐an jo so. Ikowan ko niyay ya too ey man‐ekad, ");
INSERT INTO ibl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","jet no man‐ekad, amta‐en jo ey si‐kak sota inpadtora nonta bayag da ey Anak ni Too. Amta‐en jo pay ey ẃaray kalintegan kod ja dabaw ni shaga ja memekawan ni basol ni too.” Jet si Jesus, inkowan to nonta toon eg man‐ekad ey, “Ikowan ko son si‐kam, alam ita amakam, jet akad ka.” ");
INSERT INTO ibl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sota too, bimangon na shagos et inda to sota amaka ton toka shokoli, ja inon‐an ira nonta eshakel la too. Jet nontan ma ey imakad sota toon inpamapteng nen Jesus ja eman‐iyaman son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Emin ira sota totoo, nasshaaw ira tan naykel‐eẃan ira, nem inshayaw sha met laeng si Apo Shiyos, ja kowan sha ey, “Kaskasshaaw iyay ya inon‐an tayo niman.” ");
INSERT INTO ibl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Idi naksheng iyay, si Jesus, bimo‐day et inon‐an to sota para singil ni bowis ja nanngaran ni Levi, ja eman‐obded opisina to. Kowan nen Jesus son si‐kato ey, “Kala, kay‐olop ka son si‐kak et manbedin ka ni took.” ");
INSERT INTO ibl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jet si Levi, indekjas ton emin et nay‐olop son Jesus ja nanbalin ni too to. ");
INSERT INTO ibl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Si Levi, nanpiyasta ni ebadeg shi baley to para son Jesus et eshakel iray kait ton para singil ni bowis tan ẃara pay i eshom ma totoo ja ineẃis ton ekipengan nontan na piyasta to. ");
INSERT INTO ibl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nem sota ira eshom ma Parisiyo, tan sota mamaistoro ni dinteg ni Hodiyos ja kait sha, inriri sha so nonta ira too nen Jesus ey, “Apay nga kayoka emekipengan tan emeki‐inom so ira nima para singil ni bowis tan sama eshom ma toon enshiy kenshat sha, ja eshakel i basol sha?” ");
INSERT INTO ibl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Nem idi intenengan nen Jesus iyay ya kowan sha, simongbat son si‐kara, ja kowan to ey, “Ekak ali dimaw ja mengeẃis ni toon maronong, nem dimawak ali ja mengeẃis ira nonta toon eshakel i basol sha, say manbebawi koma ira. Mebedin na may‐eshigak shi doktor. Eg bisita‐en ni doktor i enshiy sakit to, no diket sota ẃaray sakit to bengat i bisita‐en to.” ");
INSERT INTO ibl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kowan ira nonta totoo son Jesus ey, “Sota too nen Juan ja para bonjag, kanayon na shaka ibiyang i pangan nem manngidin ira, tan ireka mansheẃat pay, tan angken pay ira ja too ni Parisiyo, inges to ngoy shaka pesing. Nem apay nga sama ira toom ket ireka mengan tan eman‐inom ja eg ira ngo manngidin?” ");
INSERT INTO ibl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Say songbat nen Jesus son si‐kara, in‐arig toy bakdang to shi dakin engaseẃa. Isonga kowan to ey, “Piyan jon ikowan ey mepidit sota ira bisita shi kasal ja eg ira mengan angken ẃara sota dakin engaseẃa? Enshi, kenshat ta mengan ira. ");
INSERT INTO ibl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nem ẃara et mangoy timpon onmotok ali ja ma‐enshi son si‐kara sota dakin engaseẃa, jet si‐katoy timpon ibiyang sha so ni pangan sha maypangkep ni daringit sha.” ");
INSERT INTO ibl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Si Jesus, inkowan to mowan i sakey ya arig son si‐kara, ja kowan to ey, “Na‐alas no pi‐katen i badon baro ja isakab shi shaan na baro. Ta no sajay i pesing jo, mesepol la sheshalen jo sota badon baro, jet sota badon sakab, no isakab jo nodta shaan, eg may‐enam. ");
INSERT INTO ibl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tan na‐alas no may‐iyan i badon adak shi na‐osal la inemag shen katat ja ijanan ni adak, ja kowan sha ey ‘wineskin’. No sotan i pesing jo, pepetjag nonta badon adak sota nay‐iyanan to et onkawas sota adak. Tan angken pay sota nay‐iyanan to, mepilshi. ");
INSERT INTO ibl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mesepol ja no badon adak, bado ngoy kay‐inan to. ");
INSERT INTO ibl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nem sota ira toon naydowam ja enginom ni shaan na adak, eg sha nin piyan sota bado tep kowan sha ey, ‘Mapteng met sota shaan.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nonta akew ni ngilin ni Hodiyos, nanshalan si Jesus shi oma ja emola‐an, jet sota ira too nen Jesus, ematod ira nonta naymola jet kinotim shen kinan. ");
INSERT INTO ibl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jet sota eshom iren Parisiyo, kowan sha son si‐kara ey, “Apay nga joka dagdag‐a itan ey kaiparit ni dinteg tayon Hodiyos i mengetod no akew ni ngilin?” ");
INSERT INTO ibl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Si Jesus, simongbat ja kowan to ey, “Arig to ngo sota inpasing nen Ari David nonta bayag da ni inka‐ekang to, tan sota ira too to. Apay eg jo aya amtay dingka to? ");
INSERT INTO ibl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dimaw shima tolshen baley ya para son Apo Shiyos et inda to sota tinapay ya naydaton son Apo Shiyos, jet kinan to. Jet in‐aknan to pay ira sota too to. Sajay i dingka to anta nga nayparit son si‐kato tan sota ira kait to i pengan sha nontan na tinapay ya naydaton son Apo Shiyos. Ta sota pari bengat i palobos sa mengan nontan na tinapay.” ");
INSERT INTO ibl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tan kowan pay nen Jesus ey, “Si‐kak ja kowan nonta para padto nonta bayag da ey Anak ni Too, si‐kak i mengikowan no ngantoy mebedin na dag‐en no akew ni ngilin.” ");
INSERT INTO ibl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Idi sakey mowan na akew ni ngilin, dimaw si Jesus shi sa‐nopan ni Hodiyos ja en nantoro. Jet nontan, naytompong ja ẃara nodtan i toon eki‐ngoy i kanawan na takday to. ");
INSERT INTO ibl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sota mamaistoro ni dinteg ni Hodiyos tan Parisiyo, shaka si‐siimi no ẃaray ekasan to nontan na akew, tep kowan sha ey balang nem ẃaray dag‐en to ja ikowanan sha so ey nanbasolan to. Ta nayparit kono shi dinteg sha i pengekas no akew ni ngilin. ");
INSERT INTO ibl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nem si Jesus, amta toy ẃared nemnem sha, jet say kowan to nonta toon eki‐ngoy i takday to, “Dayat ka et daw ka did ja sango.” Jet sota too, dimayat et dimaw nodtan. ");
INSERT INTO ibl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jet kowan nen Jesus so nonta ira emeniim son si‐kato ey, “Nemnem jo kari iyay. Ngaaw aya i pandeka ni mapteng, ono pemiyag ni too, no timpon ngilin? Enshi: say ngaaw ja kaiparit ni dinteg tayo, sota pandeka ni ngaaw tan pemono.” ");
INSERT INTO ibl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Insi‐ning to iren emin, asan to ikowan nonta toon eki‐ngoy i takday to ey, “Oyad mo ita takday mo.” Pinati to sota kowan nen Jesus et mimapteng mowan na agpayso sota takday to. ");
INSERT INTO ibl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nem sota ira Parisiyo, ireka onbanonget et nantatabal ira nem ngantoy pesing sha son Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nontan na timpo, dimaw si Jesus shi shontog ja en nanshawat ni sandabi son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Idi na‐akew, sina‐nop to ali ira sota too to et pinispis toy sampolo tan showa son si‐kara. Jet inngadnan to ira ja sampolo tan showa ni apostol to. ");
INSERT INTO ibl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sajay iray ngaran sha: si Simon ja inngadnan ton Pedro, tan si agin Pedro ja si Andres; tan say kait sha pay ja apostol, si Santiago, Juan, Felipe, Bartolome, ");
INSERT INTO ibl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Santiago ja anak nen Alpio, si Simon ja bitirano, ");
INSERT INTO ibl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas ja anak nen Santiago mowan i ngaran to, tan si Judas Iskariote ja mengileko ali son Jesus shi anongosto. ");
INSERT INTO ibl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Si Jesus, shimalong ja nay‐olop so nonta apostol to et simalsheng ira nodta eshekdanan. Jet ẃara ngo ira nodtan i eshakel la too to, tan eshakel pay iray totoon edapod ili ni Jodia, Jerusalem, tan shi kilig ni baybay ja siyodad ja kowan sha ey Tira tan Sidon. ");
INSERT INTO ibl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dimaw iren en nanteneng ni kowan nen Jesus tan sha pay inpa‐ekas i sakit sha. Angken sota ira toon pingketan ni dimonyo, dimaw ngo iren nanpa‐ekas jet mimapteng ma ira. ");
INSERT INTO ibl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Emin ira sota too, piyan shen pishaten si Jesus, ta makedsang nontan i panakabalin ton mengkal ni sakit, jet mimapteng iren emin. ");
INSERT INTO ibl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jet si Jesus, insi‐ning to ira sota too ton eshakel et kowan to ey, “Si‐kayon nankebiteg, bindisiyonan shakejo nen Apo Shiyos, ta mayda‐kam kayod pantoshayan to! ");
INSERT INTO ibl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mebindisiyonan kayon nanka‐agang niman, ta mepnek kayo di! Mebindisiyonan kayon emannengis niman ni daringit jo, ta mandadsak kayo di! ");
INSERT INTO ibl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mebindisiyonan kayo no okesen shakejo ono eg sha ikarin kait shakejo, ono bebaingan shakejo, ono ikowan sha ey ngaaw kayo tep too takejo. ");
INSERT INTO ibl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pan‐imdeng kayo no sajay i mepesamak son si‐kayo, ta ebadeg i naytalo shi dangit ja kon‐oren jo ali. May‐inges kayo nodta ira para padto nen Apo Shiyos nonta bayag da, ja pinedigat ngo ni too nontan da. ");
INSERT INTO ibl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nem kakaasi kayon pasiya ja toon say kawad‐an ni dadsak jo ket etopog shima kokowayo. Nam‐ay i joka panbiyag! ");
INSERT INTO ibl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kayoka emepmepsel niman, nem ẃara diy timpon ma‐ekang kayo! Kayoka mandaddadsak niman, nem ẃara diy timpon inangis joy daringit jo! ");
INSERT INTO ibl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kakaasi kayo di no shakejoka i‐et‐etek tan ishayaw ni karakdan. Tep sota karakdan, enshiy semek sha so nonta ira toon Apo Shiyos. Angken nonta bayag da, sota ira sinan para padto ja o‐owap i kowan sha, si‐kara et ngo mowan i in‐etek ni karakdan, jey aliẃen sota koston inbetkag nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nem iyay i ikowan ko son si‐kayon emengitneng son si‐kak. Sota makakontra son si‐kayo, semek jo mango tan dagejoy mapteng so ira nonta mengokes son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","No ẃaray mengi‐ebig son si‐kayo, ikowan jo ey, ‘Si Apo Shiyos komay ontolong son si‐kam.’ Ireẃati jo son Apo Shiyos ira sota ememedigat son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No ẃaray menengpel ni tamil mo, itodok mo pay ya angken pinshowa‐en tod piig. No ẃaray mengeda ni jakit mo, itodok mo pay ya angken al‐en toy barom. ");
INSERT INTO ibl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No ẃaray manbeka son si‐kam, i‐kan mo son si‐kara i piyan sha. Tan no ẃaray indaren kokowam, angken eg mo en odi‐en. ");
INSERT INTO ibl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sota piyan jon pesing ni eshom son si‐kayo, si‐kato ngoy pesing jo son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“No say ensemek jo bengat ket sota toon ensemek shakejo ngo, eg shakejo i‐etek nen Apo Shiyos. Ta sotan met laeng i kepesing ira nonta enshiy pamatira son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No say dag‐anan mo so bengat ni mapteng ket sota ira toon mapteng i shaka pesing son si‐kayo ngo, eg shakejo i‐etek nen Apo Shiyos. Ta angken sota ira enshiy pamatira son Apo Shiyos, mapteng i shaka pesing so ni kait sha. ");
INSERT INTO ibl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tan no say pebodoran jo bengat ket sota joka namnama ey i‐oli to, eg shakejo i‐etek nen Apo Shiyos. Ta angken sota ira enshiy pamatira, ireka emanbibinodod, jet odi‐en sha met laeng sota kabebilang to! ");
INSERT INTO ibl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","No ẃaray kowan to ey memodod son si‐kayo, pabodori jo ira, angken eg to i‐oli. Semek joy makakontra son si‐kayo, tan mapteng koma mangoy pesing jo son si‐kara. Ta no satan i pesing jo, joka pan‐ipa‐sas ey annak shakejo nen Apo Shiyos ja Kangeto‐an. Ebadeg i kon‐oren jon isobadit nen Apo Shiyos tep si Apo Shiyos, mapteng i toka pesing ni emin na too, angken sota eg man‐iyaman son si‐kato tan sota makedsel. ");
INSERT INTO ibl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaasi‐i joy eshom ja inges toy kepesing nen Apo Shiyos! ");
INSERT INTO ibl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Karejo nemnemen i nankamali‐an ni eshom ja si‐katoy pengikowanan jo ma ey ngaaw ira, say eg ngo ikowan nen Apo Shiyos ey ngaaw kayo. ");
INSERT INTO ibl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","I‐akniyo iray eshom et si Apo Shiyos i mengi‐kan ngo son si‐kayo. Sota karakel ni joka i‐akan, si‐kato ngoy karakel ni i‐akan nen Apo Shiyos son si‐kayo. Nem i‐aknan tokejo ni sobda, ja angken iteded jo tan itelneg jo, onja‐bis pay ali shi sango jo.” ");
INSERT INTO ibl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Si Jesus, in‐arigan to ira, ja kowan to ey, “Say toon ekorab, mebedin ayen mengibalnay ni kait ton korab? Eg ira aya ma‐kas sa showa shi pel‐og? ");
INSERT INTO ibl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Waray nandasinan nonta maistoro nem say sota man‐ashal, jet sota man‐ashal, toka onoray kaitoro ni maistoro. Jet no meksheng may ashal to, man‐inges ira ma nonta maistoro.” ");
INSERT INTO ibl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","In‐arigan to pay ira ja kowan to ey, “Apay nga sota ootik ka naybosi shi mata ni kait mo i moka iningning, ey si‐kam ma mismo ket eg mo nemnemen ey ebadeg i naypadkal shi matam? ");
INSERT INTO ibl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na‐alas ja mo ikowan so ni kait mo ey a‐kalen mo sota naybosi shi mateto, ey si‐kam ket ebadeg i naypadkal shi matam ma shorog. Ngaaw ita moka pesing ja moka idibak i ngaaw wa nemnem mo! Ekal mo nin sota mismon naypadkal shi matam say kosto may pan‐esas mo, et say asen mo men pasiya sota a‐kalen mon naybosi shi mata ni kait mo. ");
INSERT INTO ibl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Sota molen ngaaw, eg ondames ni mapteng, nem say mapteng nga mola, mapteng ngoy dames to. Jet sota ngaaw wa mola, ngaaw ngoy dames to. ");
INSERT INTO ibl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Emin na mola, ma‐amta‐an i kalasi to no ondames. Sota kowan sha ey higos, say dames to ngo, higos; aliẃen medepod sebit. Tan eg meboshas i kowan sha ey obas shi kompormi. ");
INSERT INTO ibl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sota mapteng nga too, mapteng ngoy ẃared poso to jet si‐kato ngoy toka dagdag‐a. Nem say toon ngaaw, ngaaw ngoy ẃared poso to et ngaaw ngoy aramid to. Ta sota ẃared nemnem ni too ni olay, si‐kato ngoy onbo‐day shi bongot to ja esel. ");
INSERT INTO ibl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Apay nga kayoka mengeẃag ey apo jowak, nem sota naka ikowan ket eg jo met tongpalen? ");
INSERT INTO ibl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Emin ira sota ondaw alin piyan ton manbedin ni took, no itenengan toy esel ko, tan pati‐en to, ");
INSERT INTO ibl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","may‐eshig shi toon engitowen ni baley tod naypilmin bato. Kinaotan toy naydeshek et intowen toy tokod to nodtan na naypilmin bato. Idi nandayos ali ni makedsang, nanshalan nodta baley, nem eg to tinowang, tep na‐det i naytowenan nonta tokod to. ");
INSERT INTO ibl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nem sota toon intenengan toy kowan ko, nem eg to pati‐en, may‐eshig shi toon engitowen ni baley tod bo‐day ja enshiy naytowenan ni tokod ton na‐det ta bato. Idi nandayos ali, nanshalan nodta baley i shanom jet shinepos ton shagos jet kolpin epilshi sota baley.” ");
INSERT INTO ibl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Idi naksheng nga inkowan nen Jesus iyay ya emin so nonta ira too, dimaw shi Kapirnaom. ");
INSERT INTO ibl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jet nodtan, ẃaray baga‐en ni kapitan ni solsharo ni Roma, ja ngannganin metey ni sakit to. Sajay ya baga‐en, ensemek nonta apo to. ");
INSERT INTO ibl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Isonga idi shinemag nonta kapitan i maypangkep son Jesus, engibetkag ni pangolo ira ni Hodiyos ja mengodop son Jesus, ja en mengekas nonta baga‐en ton emansekit. ");
INSERT INTO ibl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Dimaw ira son Jesus ja sha inkowan ey, “Sajay ya kapitan, ensemek tokitejon Hodiyos. Nankasto noman ja nanpa‐emag shorog ni baley ya sa‐nopan mi. Isonga pangaasim koma apo, mesepol ja todongan mo ngo.” ");
INSERT INTO ibl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jet si Jesus, ekidaw son si‐kara, jet idi nay‐esop mes Jesus nodta baley, engibetkag sota kapitan ni kagajem ton en mengi‐aspol ni kowan to. Kowan ira nonta inbetkag to ey, “Apo, angken eg ka ontoloy kono shi baley to, ta eg kono maykeshi ja ondaw ka shi baley to, ");
INSERT INTO ibl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","tan embaing konon manpeshang son si‐kam. Angken on‐anay kono sota esel la ikowan mo et onmapteng ma ima baga‐en to. ");
INSERT INTO ibl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Amta to ta paras to ey angken esel bengat, kaon‐anay. Ta si‐kato ẃaray apo to, jet ẃara ngoy solsharo ja intorayan to. No ikowan to nonta sakey ey ondaw, pati‐en to, jet no teẃalen to sota sakey, ondaw ali. Kasta met sota baga‐en to, no ikowan to son si‐kato ey, ‘Obdam iyay’, dag‐en to.” Kowan ira nonta inbetkag ni kapitan. ");
INSERT INTO ibl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Idi intenengan nen Jesus iyay ya kowan nonta kapitan ey sota esel nen Jesus i on‐anay, nasshaaw wa pasiya si Jesus. Nanposipos et kowan to so nonta eshakel la toon imonod son si‐kato ey, “Istay sota Hodiyos koma i makedsang i pamatira son Apo Shiyos, nem enshi et ngo mowan i nak inon‐an son si‐kara ja maka‐inges ni pamati niyay ya aliẃen Hodiyos!” ");
INSERT INTO ibl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sota ira inbetkag nonta kapitan, nay‐oli ired baley to et simbira sota baga‐en ja pimesed ma. ");
INSERT INTO ibl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Idi maykadẃen akew, dimaw si Jesus shi siyodad ja kowan sha ey Nain. Sota eshakel la toon imonod son si‐kato, tan sota ira too to, nay‐olop ira son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Idi nay‐esop ma ira nodta siyodad, ẃara iray toon edapo nodtan na siyodad ja en mengiponpon ni etey. Sota dakin etey, si‐kato bengat i anak nonta biin ebalo. Wara sota bii ja nay‐olop, tan eshakel pay iray toon eki‐odop son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Idi inon‐an nen Apo Jesus sota bii, naysemekan et kowan to so nonta bii ey, “Kareka onnangis.” ");
INSERT INTO ibl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dimaw et to pinishat sota inosal shen inpamantag nonta etey, jet sota toon emantag, simalsheng ira. Jet kowan nen Jesus ey, “Si‐kam balodaki, bangon ka!” ");
INSERT INTO ibl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jet sota etey ja too, ebiyag mowan! Bimangon et imesel, jet say kowan nen Jesus so nonta ineto, “Olop mo iya anak mo.” ");
INSERT INTO ibl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Emin ira sota engasas, nasshaaw ira, tan inshayaw shes Apo Shiyos ja kowan sha ey, “Niman ẃara may engaton para padto ja naydaok son si‐katejo!” Tan kowan sha pay ey, “Si Apo Shiyos, dimaw alin mengisedakan ni too to!” ");
INSERT INTO ibl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sajay ya shamag ja maypangkep son Jesus, nayẃaris shi emin na ili ni Jodia tan shima dogad ja nay‐esop shiman. ");
INSERT INTO ibl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sota too nen Juan, shinemag sha ngo sota emin na inpasing nen Jesus et inkowan sha son Juan. ");
INSERT INTO ibl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jet tineẃal nen Juan i showa son si‐kara et inbetkag ton en mengibeka son Jesus nem si‐kato sota inkari nen Apo Shiyos nonta bayag da ey ibetkag to di ja mengisedakan, ono ẃaray apil la seskeshen sha. ");
INSERT INTO ibl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Isonga idi dimaw ira son Jesus, kowan sha ey, “Si Juan ja para bonjag, inbetkag shakami ja en mengibeka nem si‐kam sota inkari nen Apo Shiyos nonta bayag da ey ibetkag to di ja mengisedakan. Si‐kam, ono ẃaray apil alin seskeshen mi?” ");
INSERT INTO ibl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nontan na oras, si Jesus eshakel iray inpamapteng ton emanpansekit, inpan‐asas to iray nankekorab, tan angken sota toon pingketan ira ni dimonyo, inpamapteng to ira. ");
INSERT INTO ibl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Isonga say songbat nen Jesus so nonta ira toon inbetkag nen Juan, kowan to ey, “Kay‐oli kayo jet ikowan jo so nen Juan sota inon‐an jo tan intenengan jo ni kawasha jod jay. Ikowan jo ey sota ira nankekorab nan‐asas ira, sota ira nankepilay nan‐akad ira, sota nankebayang i bakdang sha mimapteng ira, sota ira nanketoleng nanteneng, sota eshom ma nanketey nanpawil ira, tan sota ira nankebiteg naytoro son si‐kara i mapteng nga shamag maypangkep son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Si Apo Shiyos i onbindisiyon so nonta enshiy showashowa to son si‐kak.” Kowan nen Jesus so nonta inbetkag nen Juan. ");
INSERT INTO ibl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","26","Idi nay‐oli ira da sota inbetkag nen Juan, inkowan ma nen Jesus so nonta ira totoo i maypangkep so nen Juan, ja kowan to ey, “Nonta dimaw kayo so nen Juan shima dogad ja kad‐an ton nay‐araẃi shi ili, amtayo ey si‐kato ket para padto nen Apo Shiyos. Isonga dimaw kayod man ja en mengesas ni toon para padto nen Apo Shiyos, aliẃen say kayo mengesas ni toon ekapoy ja singa bolong ni edet ja enam‐ay ya iẃagas ni shagem. Aliẃa ngon say dinaẃan jod man ket say kayo mengesas ni toon nanbaro ni mapteng, ta say ka‐asan ira niyay ket shi siyodad ja engkakembaleg i baley sha, ja nam‐ay i biyag sha. Dimaw kayon en mengesas ni para padto et siya, inon‐an joy toon engatngato pay nem say sota eshom ma para padto nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta si Juan sota kaytoshongan nonta esel nen Apo Shiyos ja naysolat nonta bayag da, ja kowan to ey, ‘Waray ibetkag ko ja mepangdo ey say si‐kam, jet to isagana ira sota totoo.’ Sajay i padto nonta bayag ja timorong son Juan. ");
INSERT INTO ibl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ikowan ko et son si‐kayo: Podno ey si Juan, enshiy to kay‐ingesan so ni emin na toon nay‐anak, angken sipa. Nem say sakey ya toon kabeba‐an shi pantoshayan nen Apo Shiyos, si‐katoy engatngato nem say si Juan.” ");
INSERT INTO ibl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Inkowan pay nen Jesus ey, “Sota ira para singil ni bowis, tan sota ira eshom ma too, intenengan shay kowan nen Juan et si‐karay emati ni kowan nen Apo Shiyos, jet binonjagan ira nen Juan. ");
INSERT INTO ibl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nem sota ira Parisiyo tan mamaistoro ni dinteg tayon Hodiyos, dinamsis shay kepan‐ikowan nen Juan ja planon Apo Shiyos maypangkep son si‐kara, jet ensikshal iren manpabonjag. ");
INSERT INTO ibl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","“Ara kayon too niman! Sota pemedaw bengat i amtayo. Ikowan koy joka kay‐eshigi. Singa a‐anak kayon ẃared ma malkaro, ja ensikshal la meki‐asil. Kowan ira nonta eshom ma a‐anak ja ka‐asil jo ey, ‘Nanmosiko kami para son si‐kayo, nem eg kayo met edadsakan! Insa‐dat min nimangis, nem eg kayo met ekinengis!’ ");
INSERT INTO ibl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nonta timpon inpangitoro nen Juan ja para bonjag, nagshengan i toka kena, eg menginom ni adak, jet kowan jo ey eman‐engaw. ");
INSERT INTO ibl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jet si‐kak niman na indaw ko di, enganak ni inges toy joka kena, tan enginomak, nem binedaw jowak met laeng, ja kowan jo ey, ‘Asas jo kari iman na too: makibel, ma‐inom ni adak, tan say kajem to pay, sota ira para singil ni bowis, tan angken pay sota ira eshom ma toon enshiy kenshat sha, ja eshakel i basol sha.’ Sotan i kowan jo maypangkep son si‐kak, ");
INSERT INTO ibl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","nem sota ira emati son Juan, tan emati son si‐kak, si‐karay ka‐asan to ey say plano nen Apo Shiyos, podnon mapteng ni olay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sota sakey ya Parisiyo, ineẃis tos Jesus ja en mekipengan shi baley to et si Jesus, dimaw et naydikob son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wara ngoy bii nodtan na dogad ja eshakel i basol to. Shinemag to ey si Jesus, ẃara nodta baley ni Parisiyo et dimaw ja engita‐jon ni botiljen napno ni emanseng‐ew ja dana. ");
INSERT INTO ibl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","En nantalimokod shi kad‐an nen Jesus ja nannanginangis. Sota sayeto, dimbeng toy sedi nen Jesus et sota bowek to, si‐katoy inponas to nodta sedi nen Jesus, tan inongo‐an to pay sota sedi to, asan toka iro‐jag sota dana nodta sedi to. ");
INSERT INTO ibl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sota Parisiyo ja engawis son Jesus, inon‐an to iyay et kowan to shorog shi nemnem to ey, “No podnon inbetkag nen Apo Shiyos iyay ya too, istay amta to koma iyay ya biin emirat son si‐kato, tan istay amta to komay ogadi ton ngaaw.” ");
INSERT INTO ibl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Si Jesus, kowan to son si‐kato ey, “Simon, ẃaray ikowan ko son si‐kam.” Kowan nonta Parisiyo ey, “Ngantoy ikowan mo apo?” ");
INSERT INTO ibl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jet inkowan nen Jesus i sakey ya arig, ja kowan to ey, “Waray showen too ja engotang nodta baknang. Sota sakey, dimen dasos i inotang to, jet sota sakey, dimen polo ngoy inotang to. ");
INSERT INTO ibl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Idi enshin polos i ibayad shen showa nodta baknang, kinaasi‐an nonta baknang ira. Simon, ikowan mo son si‐kak nem sipa son si‐karay nandasin i semek to so nonta baknang?” ");
INSERT INTO ibl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kowan nonta Parisiyo ni songbat to ey, “Say kowan ko, sota ebadeg i otang ton epakaẃanan, si‐kato ngoy nandasin i semek to.” Kowan nen Jesus ey, “Kostoy songbat mo.” ");
INSERT INTO ibl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Insi‐ning nen Jesus sota bii et kowan to son Simon ey, “Moka asa iyay ya bii? Iyayak niman shiya baley mo, nem enshiy mo in‐akan na shanom ja pengoshas ko ni sedik, nem si‐kato, inodsan toy sedik ni sayeto, tan pinonasan to pay i sedik ni bowek to. ");
INSERT INTO ibl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Si‐kam, enshiy koston rispitom son si‐kak, nem si‐kato, inpa‐sas toy rispito to ni injo‐kot to so ni ongo ni sedik — manshoki ni inmotok to ingkato niman. ");
INSERT INTO ibl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Eg mo dinena‐an i toktok ko ni angken na edaken dana koma, nem si‐kato, insho‐jag tod sedik i emanseng‐ew ja danen palit. ");
INSERT INTO ibl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ta sota eshakel la basol to, binigbig to ey epakaẃanan; isonga sajay i inpasing to. Si‐katoy ka‐asan to ey ebadeg i semek to son si‐kak. Nem sota toon kowan to ey ootik i basol ton epakaẃanan, ootik ngoy semek to.” ");
INSERT INTO ibl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jet kowan nen Jesus so nonta bii ey, “Sota ira basol mo, epakaẃanan.” ");
INSERT INTO ibl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Idi intenengan nonta eshom ma ekilikob son si‐kato, kowan shen shorog shi bakdang sha ey, “Sipa iyay ya toon nayda‐kad i toka ikowan? Angken basol, pekaẃanan to!” ");
INSERT INTO ibl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nem kowan nen Jesus so nonta bii ey, “Sota pamatim son si‐kak i naysalakanan mo. Daw ka ja ẃara may talna son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Enshiy bayag to, en nanpasiyal si Jesus shi emin na ili tan shima ira baryo, ja en nantoro ni mapteng nga shamag maypangkep ni pantoshayan nen Apo Shiyos. Sota sampolo tan showen too to, ekidaw ira son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tan ekidaw pay ira sota istay kawad‐an ni dimonyo, ja bibiin mimapteng, tan angken pay sota eshom ma bibiin na‐kal i sakit sha. Jet sajay i ngaran ira nonta bibii: si Maria Magdalena ja bintikan ni piton dimonyo, ");
INSERT INTO ibl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana ja aseẃa nen Shosa ja emengimanshal shi baley nen Ari Hirodis, tan si Susana. Tan eshakel pay ira sota eshom ma bibiin timolong son Jesus tan sota ira too to ni kasapolan sha, ja engi‐kan ni ẃara son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Idi na‐olnong son Jesus iray eshakel la totoo, ja edapod emin na ili ni Jodia, inkowan nen Jesus iyay ya arig son si‐kara, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Waray too ja dimaw wa en nanbangkag shi oma. Idi toka pan‐iẃaris sota botil, sota eshom, nayponta shi shalan, jet inkatin ni too, tan kinan ira ni titit. ");
INSERT INTO ibl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sota eshom ma botil, nayponta ired kabato‐an et idi timemel sota botil, nakkit tep emag‐anan sota bo‐day. ");
INSERT INTO ibl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sota eshom ngon botil, nayponta ira shima similja ni sebit, jet idi bimengis iren showa, na‐abak sota temel ni mola et eg timoloy. ");
INSERT INTO ibl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sota eshom ngon botil, nayponta ira shima mapteng nga bo‐day. Timemel asan bima‐deg, jet sajay ira, nandames ni sandedasos.” Tan kowan pay nen Jesus ey, “Niman i ẃaray ẃaya jon mengitneng niyay ya naka pan‐ikowan, isonga singpet jon itenengan.” ");
INSERT INTO ibl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sota ira too nen Jesus, inbag‐an sha no ngarantoy olog niyay ya arig ja inkowan to. ");
INSERT INTO ibl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Si Jesus, simongbat son si‐kara, ja kowan to ey, “Si‐kayo nin i naypalobos ja on‐awat so ni maypangkep nonta pantoshayan nen Apo Shiyos, nem sota ira eshom, arig bengat i pengitoshok son si‐kara, say no angken isi‐ning sha, eg sha imatonan, jet angken itenengan sha, eg sha amtay olog to. ");
INSERT INTO ibl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Say olog nonta arig ja inkowan ko la ey toon engiweshis ni botil shi oma, sajay. Sota botil, may‐eshig ey esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sota nayponta‐an ni botil ja shalan, si‐katoy kay‐eshigan nonta ira toon engitneng ni esel nen Apo Shiyos, nem ondaw ali si Satanas ja to dingdingen sota esel ja intenengan sha, say eg sha pati‐en, tan say eg ira maysedakan. ");
INSERT INTO ibl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jet sota nayponta‐an ni botil la kabato‐an, si‐katoy kay‐eshigan nonta ira toon mengitneng ni esel nen Apo Shiyos. No itenengan sha, ẃara shagos i imdeng shen mengeẃat, nem eg may‐a‐det shi nemnem sha. Memati ni sanka‐atikan, nem ibi‐jag shen shagos no onmotok i shaka kedigdikati. ");
INSERT INTO ibl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sota nayponta‐an ni botil ja similja ni sebit, si‐katoy kay‐eshigan nonta ira toon mengitneng ni esel nen Apo Shiyos, nem say shaka nemnemnema, sota pesing shen manbiyag, sota pandadsakan sha, tan sota ekanas sa biyag ni baknang. Jet anongosto ma ey ma‐abak. Isonga enshiy ka‐asan ma ni shaka pemati. ");
INSERT INTO ibl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sota nayponta‐an ni botil ja mapteng nga bo‐day, si‐katoy kay‐eshigan nonta ira toon mengitneng ni esel nen Apo Shiyos. Pati‐en sha tep mapteng i ẃared nemnem sha. Pa‐jan na medigdikat, enosan sha et ẃaray panpa‐no‐an ni pamatira.” ");
INSERT INTO ibl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Si Jesus, in‐arigan to ira, ja kowan to ey, “Kaspangarigan ey sota kingki ja inparedang jo, simpri eg mesa‐keban, ono may‐a‐mot shi doong ni katiri, no diket ipa‐tok jo shi ekayang, say sota ira toon onsekep ali, asen shay seskepan sha. ");
INSERT INTO ibl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sota nay‐emot niman ja eg ma‐on‐an, ma‐on‐an ali nem ekay, tan sota eg ma‐amta‐an niman, ma‐amta‐an ali nem ekay. ");
INSERT INTO ibl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Singpet jon itenengan, tep sota toon mengitneng tan memati, metod‐an pay. Nem sota toon endedamsis to, ja eg memati, angken sota ootik ja kowan to ey amta to, ma‐enshi pay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sota ina nen Jesus tan sota ira a‐aki to, dimaw ira son si‐kato, nem eg mebedin na a‐sopan sha ta eshakel iray totoo. ");
INSERT INTO ibl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Isonga ẃaray engikowan son Jesus ey, “Si inam tan sota ira a‐akim, iman ired bo‐dayan ja emansessesked son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nem kowan nen Jesus son si‐karen emin ey, “Say naka ikarin inak tan a‐akik, sota ira emengitneng tan ememati ni esel nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Idi sakey ya akew, si Jesus, en nandogan shi bangka, pati sota ira too to, jet kowan to son si‐kara ey, “Ondaw kitejo shima piig niya baybay.” Jet dima‐jat ira. ");
INSERT INTO ibl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idi maramen ireka emanbediw, si Jesus, en na‐ogip. Idi na‐ogip, ebiglen kimedsang i shagem nodta baybay et eshogi‐an ja emankepno sota bangka ni shanom. Jet dilikaro may biyag sha. ");
INSERT INTO ibl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dimaw ira son Jesus, sha binengon jet kowan sha ey, “Apo! Apo! Shanshani kito men metey!” Si Jesus, bimangon et inkowan to so nonta shagem tan makedsang nga shadoyon ni baybay ey onsalsheng et simalsheng nga agpayso, tan timalna ma. ");
INSERT INTO ibl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jet kowan to so ira nonta too to ey, “Apay nga kolang i pamatiyo?” Nem nasshaaw ira, tan entakot ira, jet kowan sha ni sakey tan sakey son si‐kara ey, “Sipa emo iyay ya too? Toka pesalsheng iray shagem tan shadoyon ni baybay et shaka pati‐a!” ");
INSERT INTO ibl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Intoloy shen bimaliw et mimotok ira shi dogad ja sakop ni Girgasa. Say Girgasa tan Galilia, nanmamangan shay baybay. ");
INSERT INTO ibl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Shima Girgasa, ẃaray toon eman‐engaw ja pingketan ni eshakel la dimonyo. Sajay ya too, shaka bedora ni kolkolong, tan kebantayi ni too. Nem kanayon ja kesebi‐a ni dimonyo et si‐kato ngoy timpon toka iketdang so ni kolkolong, jet kaidaw ni dimonyo shi shontog. Eg man‐iyan shi baley, nem eg shima kamposanto i toka pan‐iyanin ebayag, ja nandabos. Idi simekbit si Jesus shi kilig ni baybay, inaspol nontan na toon eman‐engaw. Idi inon‐an tos Jesus, pimekis et en nanshomog shi sango‐an nen Jesus. Si Jesus inkowan to so nonta dimonyo ey idekjas sha sota too et sota too, inkedsang toy keljaw to, ja kowan to ey, “Jesus! Anak nen Apo Shiyos sa Kangeto‐an! Ngantoy pesing mo ma son si‐kak? Pangaasim, karamak shosa‐en!” ");
INSERT INTO ibl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Si Jesus, inbag‐an to, ja kowan to ey, “Sipay ngaran mo?” Kowan nonta too ey, “Say ngaran ko, si Dinibo.” Tep dinibo i dimonyon pimeket son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Nontan met laeng, ẃara iray eshakel la keshel la naybolos nodtan na shontog. Jet sota ira dimonyo, ireka mekikaasi son Jesus ey eg to ira pedaw shima dogad ja shosa‐an ira ni dimonyo, nem say piyan sha koma, onsekep ira nodta keshel la naybolos. Jet inpalobos nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jet sota ira dimonyo, bimetik ira nodta too et pimeket ira nodta eshakel la keshel. Jet sota ira keshel, namtik iren nan‐ekas shima shepdas et dimened ira shi baybay. ");
INSERT INTO ibl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sota ira toon istay emanbantay ira niyay ya keshel, inon‐an shay epasemak et kinano‐an shen inshamag shi siyodad tan shima eshom ma kait sha. ");
INSERT INTO ibl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sota ira toon engitneng niyay ya shamag, dimaw ira, sha inon‐an sota epasemak. Jet simbires Jesus, tan sota toon bintikan ira ni dimonyo, ja mapteng may nemnem to. Timongaw ja nay‐askang son Jesus ja nanbaro ma. Sajay iren dimaw ja en engasas so niyay, timakot iren emin. ");
INSERT INTO ibl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jet sota ira para bantay ni keshel ja engasas ni inpan‐etan ni dimonyo, inkowan shay inpasing nen Jesus ja inpabtik so ni dimonyo. ");
INSERT INTO ibl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jet emin ira sota i‐Girgasa, kowan sha son Jesus ey no mebedin koma, idekjas to ira, ta epaladoy takot sha. Isonga si Jesus, nandogan shi bangka ja onda‐jat ma. ");
INSERT INTO ibl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nem sota toon bintikan ira ni dimonyo, inbag‐an tos Jesus nem mebedin na mekidaw son si‐kato nodta bangka. Nem si Jesus, inbetkag to, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Akad ka, mo ikowan i mapteng nga inpasing nen Apo Shiyos son si‐kam.” Jet sota toon mimapteng, imakad ja nanshalan nodta ira balebaley et to insodsod so ni totoo i kaskasshaaw wa dingka nen Jesus son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Idi mimotok si Jesus nodta piig ni baybay, sota ira eshakel la totoo, ireka man‐imdeng ni inmotok to tep shaka ngo eshan sesseskera. ");
INSERT INTO ibl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jet nontan, ẃara ngoy mimotok alin too ja si Jairo i ngaran to, ja pangolo ni baley ya sa‐nopan ni Hodiyos. Nantalimokod shi sango‐an nen Jesus, ja kowan to ey, “No mebedin koma, kay‐olop ka son si‐kak shi baley ko, ");
INSERT INTO ibl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ta sota sesakey ya anak kon bii, emanpatpatey.” (Sajay ya anak ton bii, sampolo tan showa i tawen to.) Nonta eman‐ekad si Jesus ja ondaw shi baley nonta pangolo, eshakel iray totoo ja engigeẃa son si‐kato ni shaka pan‐ekad. ");
INSERT INTO ibl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nodta eshakel la toon imonod son Jesus, ẃara ngoy sakey ya biin naydaok ja nanshala ni sampolo tan showen tawen. Kinastos ton emin i kokowa to shi doktor, nem enshiy makabaal ja engagas niyay ya sakit to. ");
INSERT INTO ibl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ekisikil la imonod son Jesus et pinishat toy kajaran ni baro nen Jesus. Jet nay‐inshas ngon simalsheng sota ebayag ga toka pansheda. ");
INSERT INTO ibl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Si Jesus, kowan to ey, “Sipay emirat son si‐kak?” Nem emin ira sota too, kowan sha ey, “Aliẃen si‐kak.” Jet si Pedro, kowan to ey, “Apo, eshakel met ita toon shakaka pantikshona?” ");
INSERT INTO ibl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nem kowan nen Jesus ey, “Wara met i dinmok shiyay ja sakey ya toon na‐agasan ja emirat son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sota bii, idi inamta‐an to ey amta gayam nen Jesus, dimaw son Jesus ja emanbebayedbed ja en nantalimokod shi sango‐an to. Jet inkowan to shi sango‐an nonta ira eshakel la totoo nem ngantoy kabol la pinishatan to son Jesus, tan inkowan to ey na‐agasan shagos nonta inpirat to so. ");
INSERT INTO ibl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jet kowan ma nen Jesus son si‐kato ey, “Anak ko, say minaptengan mo, sota pamatim son si‐kak. Daw ka ja ẃara may talna son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nonta marama ja pan‐ikowan nen Jesus iyay, ẃara diy inbetkag shen edapo nodta baley nonta pangolo ja emansekit i anak to, jet kowan to son si‐kato ey, “Kosto. Angken eg mo odopen ita maistoro. Enshi met laeng i silbi ni idaw to tep etey sota anak mo.” ");
INSERT INTO ibl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nem si Jesus, intenengan to et kowan to son Jairo ey, “Kareka manshanag; pamati ka ni abos et onpesed sota anak mo.” ");
INSERT INTO ibl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Idi onmotok ira nodta baley nonta pangolo, say inpalobos ton mekiskep son si‐kato bengat, si Pedro, si Juan, si Santiago, tan sota ama tan ina nonta nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Emin ira sota ẃara nodta bo‐dayan, ireka onnanangis ni daringit sha nonta nga‐nga. Nem kowan nen Jesus son si‐kara ey, “Karekayo onnangis: eg etey itan na nga‐nga, na‐ogip bengat.” ");
INSERT INTO ibl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nem sota ira totoo, inbi‐ẃisan sha si Jesus tep amtara ey etey da sota nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Idi simekep si Jesus, inegni‐an toy takday nonta nga‐nga et inkedsang toy esel to, ja kowan to ey, “Bangon ka anak!” ");
INSERT INTO ibl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nay‐oliy jasjas mowan nonta nga‐nga et bimangon na shagos. Jet inkowan nen Jesus son si‐kara ey, “I‐akniyo ni kenen to.” ");
INSERT INTO ibl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sota ama tan ina nonta nga‐nga, nasshaaw ira. Jet kowan nen Jesus son si‐kara ey, “Karejo ikokowan shi eshom iyay ya edaga niman.” ");
INSERT INTO ibl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Si Jesus, sina‐nop to ira sota shinotokan ton sawal ni showen apostol to et inkowan to ey ondaw ira ja sha ikowan i maypangkep ni pantoshayan nen Apo Shiyos, tan pemapteng sha pay i sakit ira ni totoo. Jet kowan to pay son si‐kara ey, “Ipiyal ko son si‐kayo ey angken sama ira dimonyo ja pimeket shi totoo, mebedin na pebtik jo. Tan sota ira ẃaray sakit to, mebedin ngon pemapteng jo ira. ");
INSERT INTO ibl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Angken enshiy jo ita‐jon na kompormin mesepol jo shima daẃan jo. Eg mesepol la mengita‐jon kayo ni sowan, bayong, mekan, pilak, ono baron pansa‐datan. ");
INSERT INTO ibl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","No sipay mengeẃis son si‐kayo, si‐katoy pan‐inan jo ingkatod eg jo pay laeng idekjas sotan na dogad. ");
INSERT INTO ibl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nem no ondaw kayo nodta dogad ja eg shakejo eẃaten ira nonta too, sota depok ja naypeket shi sediyo, pokpok jo nin asan joka ilekjas sotan na ili. Ta si‐katoy pengamta‐an sha so ey enshi may biyang jo son si‐kara.” Kowan nen Jesus so ni apostol to. ");
INSERT INTO ibl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jet sota ira too to, inekad shay eshakel la dogad ja sha intoro i esel nen Jesus, tan inpamapteng sha iray toon emanpansekit. ");
INSERT INTO ibl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Si Hirodis ja engitoshay ni Galilia, idi shinemag to sota maypangkep ni emin na dingdingka nen Jesus, eg to tetongolan nem sipay koston katoo nen Jesus. Ta say kowan ni eshom, si‐katos Juan ja para bonjag ja nanbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Say kowan ni eshom, si‐katos Elias ja para padto nonta bayag da ja dimaw ali mowan. Tan sota ira eshom pay, say kowan sha, si‐katoy sakey so nonta ira para padto nonta bayag da ja nanbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nem kowan nen Hirodis ey, “Pinotolan koy toktok met nen Juan. Sipa ngata iyay ya toon eshakel i naka itenengin maypangkep son si‐kato?” Jet piyan ton pasiya ja asen si Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sota ira apostol nen Jesus ja inbetkag to, imoli ira di jet inkowan sha son Jesus i emin na dingdingkara nodta dinedaẃan sha. Jet inodop to iren abos sha ja ondaw shi siyodad ja kowan sha ey Bitsaida. ");
INSERT INTO ibl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nem idi inamta‐an nonta eshakel la too i tinoshong nen Jesus, inonod sha, jet si Jesus ineẃat to ira. Jet inkowan to son si‐kara i maypangkep ni pantoshayan nen Apo Shiyos, tan inpamapteng to sota ira emanpansekit. ");
INSERT INTO ibl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Idi enasẃil malay akew, sota apostol ton sampolo tan showa, dimaw ira di son si‐kato et kowan sha ey, “Apo, pansisi‐jan mo ira jay ya totoo say ira di koma mengenap ni kenen sha tan ka‐okipan sha shima balebaley ja nay‐askang shiyay, tep araẃi met iyay ya dogad shi kebalebaley.” ");
INSERT INTO ibl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nem kowan nen Jesus son si‐kara ey, “I‐akniyo et ira ni kenen sha.” Jet kowan sha ey, “Eshakel met ira. Piyan mon kami menongkal ni kenen sha? Saja ẃara bengat shiyay, dimen boknol la tinapay tan showen piskaw.” ");
INSERT INTO ibl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tep ẃara nodtan i ondaw wa dimen dibon daleki, tan ẃara pay i bibii. Kowan nen Jesus ey, “Patongaw jo ira ja totoo ja sandi‐men poloy sakey ya gropo.” ");
INSERT INTO ibl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jet sota too to, inpatongaw sha ira sota eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jet si Jesus, inda to sota tinapay tan sota showen piskaw, intangkak tod naykayang jet nan‐iyaman son Apo Shiyos. Idi naksheng nga nan‐iyaman, shinowashowa to asan toka i‐kan so nonta ira too to, ja si‐karay mengiweshis so nonta ira eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sota ira totoo, engan ira et napsel iren emin. Idi naksheng ira, inolnong ira nonta too nen Jesus sota ebay‐an ja eg kinan ira nonta totoo jet say na‐olnong, sampolo tan showen baskit. ");
INSERT INTO ibl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nonta sakey ya akew, dimaw sota too nen Jesus son si‐kato nonta toka pansheẃat son Apo Shiyos, ni abos to. Jet inbag‐an to ira, ja kowan to ey, “Ngarantoy kaikowan ira ni totoo ni maypangkep son si‐kak? Eg sha aya tabtabalen nem sipa‐ak?” ");
INSERT INTO ibl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jet sota ira too to, simongbat ira ja kowan sha ey, “Eg met nan‐i‐inges i shaka ikowan. Say kowan ni eshom, si‐kam kono si Juan ja para bonjag ja etey da, nem sota ira eshom, kowan sha ey si‐kam si Elias ono sakey so nonta ira eshom ma para padto nonta bayag da ja nanbiyag mowan ali shi patey.” ");
INSERT INTO ibl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jet si Jesus, inbag‐an to ngo ira sota too to, ja kowan to ey, “Jet si‐kayo ngay? Ngaranto ngoy kowan jo ni maypangkep son si‐kak?” Simongbat si Pedro ja kowan to ey, “Si‐kam sota inpadtora nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan so ni totoo.” ");
INSERT INTO ibl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jet si Jesus, binidin to iren pasiya ey eg sha ikokowan ni angken sipa i maypangkep nonta inkowan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tan inkowan to pay ey, “Si‐kak sota kowan ni padto nonta bayag da ey Anak ni Too. Nem mesepol la manda‐kamak ni eshakel la digat, ta sota ira pangolo ni Hodiyos, tan sota apo ni papashi, tan mamaistoro ni dinteg, bedawen sha‐ak et anongosto ma ey bono‐en sha‐ak. Nem no maykatdon akew, man‐ongalak met laeng.” ");
INSERT INTO ibl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jet say kowan to son si‐karen emin, “No sipay makapiyan ja on‐onod son si‐kak ja took ni olay, mesepol la si‐kak bengat i nemnemnemen to, ja ibiyang ton emin i kompormi. Tan mesepol la enosan to pay ya angken maybebaing ono mebono ja inges to sota toon emasan ni koros ja kaydansa‐an to met laeng. Tan mesepol pay ya si‐kak i pansilbi‐an to ni olay. ");
INSERT INTO ibl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sota toon entapi to i biyag to ja kowan to ey ensikshal la metey maypangkep son si‐kak, si‐kato et ngo mowan i mepokaw i biyag to. Nem sota toon eg to kaẃanan i bakdang to ni maypangkep son si‐kak ja angken metey ni toka pansilbi, si‐kato et ngo mowan i i‐aknan nen Apo Shiyos ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","No kaspangarigan ey kinokowa ni sakey ya too i emin na ẃared ja dobong, enshiy silbi nontan na kinokowa to, no eg to kon‐oren sota biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","No sota toon embaing nga mengikowan ey si‐kato ket took, ono embaing nga mengikowan ni esel ko, ibaing ko ngo sotan na too nem ondawak alin mantoshay. Agpayson si‐kak sota kowan nonta para padto nonta bayag da ey Anak ni Too, jet sotan alin idaw ko, say kasesaad ko, inges ko met laeng i kasesaad nen Apo Shiyos. Tan may‐odop ali sota ira anghil to son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jet agpayson ẃaray eshom son si‐kayod jay ja eg metey ingkatod asen sha sota pantoshayan nen Apo Shiyos.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Waray makadomingko ja edabas da ni inkowanan to so niyay, jet si Jesus, inodop tos Pedro, Juan, tan si Santiago, jet dimaw iren timiyed shi shontog ja en mansheẃat son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Idi maramen emansheẃat si Jesus, nanbaliw i itsora ni dopa to. Angken pay sota baro to, nanbalin ni empotin pasiya ja emenenili. ");
INSERT INTO ibl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jet ebiglen ẃaray showen too ja emekitbal son si‐kato, ja si Moises nen Elias. ");
INSERT INTO ibl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Emanniyal i shamangan sha et say tinabtabal sha nen Jesus, sota maypangkep ni ikesheng to so ni obda nen Apo Shiyos ni ketey tod Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Pedro tan sota ira kait to, en‐amis i ogip sha, nem ebangon ira et inon‐an shay inniyal nen Jesus, tan sota showen too ja toka pantabtabala. ");
INSERT INTO ibl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Idi emanda‐jat da si Moises nen Elias ja idekjas sha si Jesus, si Pedro, kowan to son Jesus ey, “Apo, mapteng i kawasha tayod jay. Kosto gayam nem mengemag kami ni tedon kampod jay: sota sakey para son si‐kam, sota sakey para so nen Moises, tan sota sakey para so nen Elias.” Nem si Pedro, eg to amtay toka pan‐a‐sela. ");
INSERT INTO ibl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nonta marama pay laeng ja eman‐a‐sel si Pedro, dimespag aliy kolpot jet dinikopan to ira. Jet si Pedro tan sota kait to, timakot ira ta dinikopan ira nonta kolpot. ");
INSERT INTO ibl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jet ẃaray esel ja edapo nodta kolpot ja kowan to ey, “Sajay i Anak ko. Si‐katoy shinotokan kon mengisedakan so ni totoo. Isonga patiyon emin i ikowan to.” ");
INSERT INTO ibl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Idi enshi la sota esel, si Jesus met ni abos i ẃara. Jet sota ira too to, enshin polos nin nontan na timpo i sha inkokowan so ni angken sipen too ni maypangkep nonta inon‐an sha nodta shontog. ");
INSERT INTO ibl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nonta inkawa‐ẃa to, shimalong iren edapod shontog. Jet eshakel iray totoon nay‐aspol son Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jet ẃaray sakey ya toon naydaok nodta eshakel la totoo ja inkedsang toy esel to, ja kowan to ey, “Apo! Kaasi‐im iya anak ko, tep saksakey to bengat ja anak ko! ");
INSERT INTO ibl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Waray dimonyon kaonsabi son si‐kato et no onsabi, toka pekelkeljaw, tan toka pankenkenteg, jet eman‐o‐osab i bongot to. Emebedjag asan toka ilekjas; toka pedigata nin na pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inkowan ko nonta ira toom ey pebtik sha sota dimonyo, nem eg sha met binaalan.” ");
INSERT INTO ibl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Simongbat si Jesus ja kowan to ey, “Enshiy pamatiyo eshan, ap‐apil kayon too! Ebayagak met shiyay ja eman‐enos son si‐kayo, nem eg jo pay laeng pati‐en i panakabalin nen Apo Shiyos! Ilaw mo did jay sota anak mo!” ");
INSERT INTO ibl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Idi eman‐ekad sota nga‐nga ja to sebi‐en si Jesus, sota dimonyo, inbes‐ig tod bo‐day, tan inpankenkenteg to. Si Jesus, inkowan to so nonta dimonyo ey, “Betik ked ta nga‐nga!” Jet bimetik nga agpayso. Jet mimapteng sota nga‐nga. Kowan nen Jesus so nonta ama nonta nga‐nga ey, “Iya, i‐ekad mo iya anak mo.” ");
INSERT INTO ibl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Emin ira sota too, nasshaaw ira ja kowan sha ey, “Sajay i ka‐asan ni panakabalin nen Apo Shiyos!” Maramen sajay i pan‐ikowan ira nonta totoo pangkep nonta dingka nen Jesus ey ikowan to ngo so nonta too to ey, ");
INSERT INTO ibl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Karejo dibdibkan koma iya ikowan ko son si‐kayo, ta aliẃen kanayon iyay ya pengiredjaw sha. Si‐kak sota kowan ni para padto nonta bayag da ey Anak ni Too, nem may‐eẃatak so nonta ira toon makakontra son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nem nay‐emot son si‐karay piyan ton ikowan, jet eg sha ineẃatan. Piyan shen ibaga nem ngarantoy olog to, nem embaing iren mengibeka. ");
INSERT INTO ibl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nansosongbat ira sota too to nem sipa son si‐karay mandesin koma ni shayaw. ");
INSERT INTO ibl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Si Jesus, amta toy ẃared nemnem sha et say inpasing to, ena‐ẃal ni nga‐nga ja inpaledjat tod abay to. ");
INSERT INTO ibl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jet kowan to so nonta ira too to ey, “No sipa ken too ja mapteng i pesing mo so niyay ya nga‐nga maypangkep ni semek mo son si‐kak, si‐kak met laeng i tinoshong nonta inpasing mo. Jet no si‐kak i pesingan mo so ni mapteng, say toshongen nonta dingkam, si Amak ja engibetkag son si‐kak ali. Sota mengibeba ni bakdang to shorog, si‐katoy mandesin koma ni shayaw son si‐kayon emin.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kowan nen Juan ey, “Apo, ẃaray inon‐an min too ja emengosal ni ngaran mo say onbetik iray dimonyo ja pimeket shi totoo. Jet inpasalsheng mi tep eg naykait son si‐kamin toom.” ");
INSERT INTO ibl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nem kowan nen Jesus ey, “Karejo iparit. No sipa sota eg makakontra son si‐kayo, kait jo.” ");
INSERT INTO ibl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Idi nay‐esop ma sota timpon i‐oli nen Jesus shi dangit, ninemnemnem to ey kenshat ta ondaw shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isonga engibetkag ni toon mepangdo ja ondaw shi sakey ya ili ni Samaria say ira mengisekana ni mesepol to, tep manshedan nodtan. ");
INSERT INTO ibl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nem sota ira too nodtan, ensikshal ira, ja kowan sha ey, “Enshi, eg ali ondaw shiyay tep ondaw met shi Jerusalem.” ");
INSERT INTO ibl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Idi inamta‐an nonta too nen Jesus ja si Santiago nen Juan iyay, kowan sha son Jesus ey, “Apo, piyan mon angken pa‐oshan mi ali ni apoy ja medepod dangit say mepoolan ira ja eg mengeẃat son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nem si Jesus, nanposipos et sinelkag to ira. ");
INSERT INTO ibl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jet dimaw ira shi eshom ma baryo. ");
INSERT INTO ibl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Idi ireka man‐ekad, ẃaray toon kowan to son Jesus ey, “Angken toway daẃan mo, mekidawak son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jet si Jesus, simongbat ja kowan to son si‐kato ey, “Pannemnem ka nin, ta saja obdak, edigat. Onito pay sota atap pa animal, tan titit, ta ẃaray koston shaka pan‐iyani. Nem si‐kak enshiy koston baley ko ja pansalshengan ko.” ");
INSERT INTO ibl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kowan mowan nen Jesus so nonta sakey ya too ey, “Kay‐olop ka son si‐kak ni olay.” Nem kowan to ey, “Kanin Apo, ta nak nin isingpet si amak.” ");
INSERT INTO ibl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Si Jesus, simongbat ja kowan to ey, “Olay ngo ira sota toon eg sha amtes Apo Shiyos ja mengisingpet nonta etey. Maybidang ey etey ira, jet anam shen mengibka ni etey ya too. Nem si‐kam, daw ka et, mo ikowan i maypangkep ni pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kowan ngo nonta sakey ya too ey, “May‐odopak son si‐kam Apo, nem ondawak nin, nak sodsoran i pamiljak.” ");
INSERT INTO ibl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kowan nen Jesus son si‐kato ey, “No sota toon engirokin mengesharo, nem keẃingi ni olay shi engiroki‐an to, aliẃen mapteng nga para arasho. Inges to sota toon istay nay‐olop son si‐kak, nem emesiẃat ni kompormi, enshiy silbi to shi pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Idi naksheng iyay, si Apo Jesus, shinotokan toy piton polo tan showa so nonta ira too to, jet inbetkag to iren sanshedẃa ja en mengitosho shima emin na dogad ja kowan to ey daẃan to met laeng. ");
INSERT INTO ibl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jet say kowan to son si‐kara, “Eshakel iray toon may‐eshig ey ma‐epit nem kolang iray man‐obda. Si Apo Shiyos i mengibetkag ni toon mengepit, isonga si‐kato ngoy pengshawan jo say mengibetkag ali ni on‐atang son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Daw kayo ma, nem tanshaaniyo ta ibetkag takejo ja singa kalniron naydaok shima atap pa aso. ");
INSERT INTO ibl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Angken eg kayo mengita‐jon ni pilak, ono bayong, ono sapatos. Pandiritso kayod daẃan jo; karekayo mesiẃat ni tabtabal shi shalan nem ẃaray aspolen jo. ");
INSERT INTO ibl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","No onmotok kayo nodta balebaley, say pilmiron pesing jo, ikowan jo ey, ‘Bindisiyonan koma nen Apo Shiyos i nanbaley shiyay ya baley.’ ");
INSERT INTO ibl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jet no maronong sotan na toon nanbaley nodtan, ja anam ton mebindisiyonan, ontoloy sota inkowan jon bindisiyon nen Apo Shiyos son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Topog joy baley ya pan‐inan jo, karekayo man‐a‐atan. Jet sota ẃaren isango sha son si‐kayo ja kenen jo, si‐katoy singa dagboyo. Ta sota man‐obda, nebeng ton may‐aknan ni kompormin mesepol to. ");
INSERT INTO ibl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","No ondaw kayo nodta ili et eẃaten shakejod man, kan jo sota ẃaren isango sha son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pamapteng joy emansekit ta totoo nodtan na dogad, jet say ikowan jo so nonta ira totoo, ‘Sota pantoshayan nen Apo Shiyos, dimaw ali ma ja nay‐esop son si‐kayo.’ ");
INSERT INTO ibl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nem no sota dogad ja motoken jo ket, eg shakejo eẃaten, daw kayod ma kabalkan na kalsara say on‐an shakejo et ikowan jo ey, ");
INSERT INTO ibl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ayshi may biyang mi son si‐kayo! Angken saja depok ja naypeket shi sedi mi, pokpoken mi. Nem karejo dibdibkan ey sota pantoshayan nen Apo Shiyos ket dimaw alin nay‐esop son si‐kayo ja istay onsabi son si‐kayo.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jet intobtob nen Jesus ey, “Iyay pay i ikowan ko. No onmotok ali sota akew ja pengigsheng nen Apo Shiyos no sipay maysedakan, say podnon mepesamak so nonta too nodtan na dogad, mas embel‐at i keshosara nem say sota tood Sodoma.” Inkowan nen Jesus iyay ya emin so nonta ira too ton inbetkag to. ");
INSERT INTO ibl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wara pay i inkowan nen Jesus ja kowan to ey, “Kakaasi kayo di ja toon i‐Korasin, tan si‐kayon tood Bitsaida. Eshakel i dingkak ka milagro shi ili jo jet inon‐an jo, nem eg kayo nanbebawi maypangkep ni basol jo. No sajay komen milagro ja inpa‐sas ko son si‐kayo ket inon‐an ni tood Tira, tan tood Sidon, angken aliẃen too ira nen Apo Shiyos, sigoradon nanbebawi ira maypangkep ni basol sha nonta mismon inon‐an sha sota milagro, tan ẃara pay i ka‐on‐anan to ey ireka mandeshingit maypangkep ni basol sha. ");
INSERT INTO ibl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nem ikowan ko son si‐kayo, no onsabi ali sota timpon pengigsheng nen Apo Shiyos no sipay maysedakan, embel‐at i keshosayo nem say sota tood Tira tan tood Sidon. ");
INSERT INTO ibl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tan si‐kayo ngon tood Kapirnaom, kowan jo ey ikayang jon shorog i bakdang jo ingkatod dangit, nem ayshi, eg mebedin! Maybeba kayod impiyarno.” ");
INSERT INTO ibl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jet kowan nen Jesus so nonta ira ibetkag to ey, “No sipay mengitneng son si‐kayo, si‐kak i maybidang ey intenengan to. Tan no sipay ondamsis son si‐kayo, si‐kak i maybidang ey dinamsis to, tan no sipay ondamsis son si‐kak, maybidang ey dinamsis tos Amak ja engibetkag ali son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Idi nay‐oli ira di, sota piton polo tan showen inbetkag nen Jesus, ireka man‐imdeng nga pasiya, ja kowan sha son Jesus ey, “Apo, angken sota ira dimonyo, shakamika pati‐a no osalen miy ngaran mo.” ");
INSERT INTO ibl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Si Jesus, kowan to son si‐kara ey, “Owen, amtak ey si Satanas, sankakemjat i toka ka‐ebak ja singa bagidat alid naykayang. ");
INSERT INTO ibl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Si‐kak i engibetkag son si‐kayo et angken manshedan kayod dilikaron dogad, enshiy mepesamak son si‐kayo. Mebedin jon ebaken i kabakal jon si Satanas, jet eg kayo ma‐an‐ano. ");
INSERT INTO ibl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nem aliẃen sota inpanagshag jo bengat ni dimonyo i pan‐imdengan jo. Nem say pan‐imdengan jo komen pasiya, sota inkaydista ni ngaran jod dangit.” ");
INSERT INTO ibl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jet nontan met laeng nga oras, sota Ispirito Santo nen Apo Shiyos, inpan‐imdeng to si Jesus. Isonga kowan to son Apo Shiyos ey, “Ama, apo ni dangit tan saja dobong, man‐iyamanak son si‐kam, tep say inpa‐amta‐an mo so ni maypangkep ni pantoshayan mo ket sota ira toon mapiyan na metod‐an. Nem sota ira toon kowan shed nemnem sha ey ẃaray amtara, eg mo ipalobos sa amta‐an sha sota maypangkep ni pantoshayan mo. Owen Ama, edaga iyay tep si‐katoy piyan mon medeka.” Sajay i iyaman nen Jesus son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jet inkowan to pay ey, “Si‐kak bengat i inpiyalan so nen Amak ni emin. Si‐kak bengat i maka‐amta ni emin na maypangkep son si‐kato, tan si‐kato ngo bengat i maka‐amta son si‐kak ka Anak to. Isonga sota piyan kon pengitosho‐an ni maypangkep ni pantoshayan nen Apo Shiyos, si‐katoy itoro‐an ko so.” ");
INSERT INTO ibl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Si Jesus, sinengo to sota ira too to et kowan to son si‐kara ni abos sha ey, “Ekasat kayo, ta inon‐an jo ira jay ya naka dagdag‐a. ");
INSERT INTO ibl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Agpayso iya ikowan ko son si‐kayo. Eshakel ira sota para padto nen Apo Shiyos tan a‐ashi nonta bayag da ja piyan shen on‐an koma iyay ya inon‐an jo niman na timpo, tan piyan shen itenengan koma iyay ya intenengan jo, nem eg sha sina‐kop.” ");
INSERT INTO ibl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Waray sakey ya maistoro ni dinteg ni Hodiyos; dimaw son Jesus sa kowan to ey peshasen to no kas‐anoy katekal nen Jesus. Kowan to son Jesus ey, “Maistoro, ngantoy kowan mo ja dag‐en ko say eẃaten koy biyag ja enshiy to engintegan?” ");
INSERT INTO ibl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Simongbat si Jesus ja kowan to ey, “Ngarantoy naysolat nodta bilin nen Apo Shiyos nonta bayag da? Jet nganto mangoy moka pengodog?” ");
INSERT INTO ibl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sota maistoron ememeshas son Jesus, simongbat ja kowan to ey, “Say kowan to, ‘Semek mos Apo Shiyos ja si‐katoy pengitoshongan mo ni emin na ẃara son si‐kam — emin na ẃared posom, emin na kedsang mo, tan emin na nemnem mo.’ Tan kowan to pay ey, ‘Semek moy kait mon too ja inges toy moka penmek so ni bakdang mo.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kowan nen Jesus ey, “Kostoy songbat mo. Jet no onoren mo iyay, ja dag‐en mo, eẃaten mo sotan na biyag ja insalodsod mo.” ");
INSERT INTO ibl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nem sota maistoro ni dinteg ni Hodiyos, emandeson. Isonga kowan to son Jesus ey, “Jet sipa ngarod i kowan mo ey kait kon sesmeken ko?” ");
INSERT INTO ibl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sinongbatan nen Jesus ni arig, ja kowan to ey, “Waray sakey ya too; emanshedong ja edapod Jerusalem ja ondaw shi Jiriko. Nem sota ira tolisan, tinodisan sha et indaray angken baro to. Pinegpeg‐as sha et indekjas shen nalpeng. ");
INSERT INTO ibl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sotan ma ey naytompong ngon ẃaray pari ni Hodiyos ja emanshedong nodtan na kalsara. Idi inon‐an to sota toon naypolay, dinigdig to ja nanshalan shi naykilig. ");
INSERT INTO ibl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Idi naksheng iyay, ẃara mowan i Hodiyos sa para tolong met laeng ni pari ja nanshalan nodtan, nem inges to met laeng i inpasing to. Idi inon‐an to sota toon tinodisan sha, nanshalan nodta naykilig. ");
INSERT INTO ibl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nem idi nanshalan aliy sakey ya toon i‐Samaria nodtan, ja aliẃen kait nonta Hodiyos sa tinodisan sha, inon‐an to et naysemekan nodta too. ");
INSERT INTO ibl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dimaw, to simbi et to inekasan sota ira sogat to ni danen edaokan ni adak, asan toka bedbeshi. Jet inpankabajo to nodta kabajo to et indaw to nodta baley ya shiẃesan et inajowanan tod man. ");
INSERT INTO ibl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Idi eẃa‐ẃa, inbo‐day toy pilak to et in‐akan to nodta emanbantay nonta baley ya shiẃesan, ja kowan to ey, ‘Ajowanim iyay ya too et no on‐oli‐ak ali, manshedanak alid jay et bayshan taka no pigay kasto‐en mon para son si‐kato.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jet si Jesus, inbaga to so nonta maistoro ni dinteg ey, “Jet saja tedon too ja nanshalan nodta kad‐an ni toon etolisan, sipa son si‐kara i kowan mo ey kait to?” ");
INSERT INTO ibl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sota maistoro ni dinteg ja nansalodsod, simongbat ja kowan to ey, “Simpri sota engaasi son si‐kato.” Jet si Jesus, kowan to ey, “Owen et sajay ngoy pesing mo so ni eshom.” ");
INSERT INTO ibl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Idi eman‐ekad si Jesus tan sota ira too to, simbiray dogad ja kawad‐an ni biin manngeshan ni Marta, jet ineẃis to si Jesus shi baley to. ");
INSERT INTO ibl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Si Marta, ẃaray agi ton si Maria i ngaran to. Sajay ya agi to, timongaw wa emantetneng ni kepan‐itoro nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nem si Marta, ngaaw i dekna to ta sakey ton emengisekana ni kenen sha. Dimaw son Jesus et kowan to ey, “Apo, baybay‐an mo aya ita agik ka indekjas towak ka sakey kon emanposposipos sa man‐obda? Ikowan mo son si‐kato ey ondaw ali et todongan towak.” ");
INSERT INTO ibl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nem si Apo Jesus, kowan to ey, “Marta, Marta, ngantoy? Kaka emanshanag ni moka pan‐inolin eman‐obda? ");
INSERT INTO ibl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sakey bengat i kasapolan jet si Maria, amta toy mesepol et pinidi toy mapteng nga eg mebedin na ma‐kal son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nonta sakey ya akew, emansheẃat si Jesus so nen Apo Shiyos et idi naksheng, kowan nonta sakey ya too to son si‐kato ey, “Apo, itod‐iyokami ni pesing min mansheẃat son Apo Shiyos, ja inges toy inpangitoro nen Juan so ira ni too to.” ");
INSERT INTO ibl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jet si Jesus, inkowan to son si‐kara ey, “No mansheẃat kayo son Apo Shiyos, sajay komay ikowan jo: ‘Ama, si‐kam koma i mayshedjaw ni olay. Sota pantoshayan mo, pasebim koma ali. ");
INSERT INTO ibl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","I‐kan mo koma sota kenen mi ni inakew. ");
INSERT INTO ibl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Si‐kam i memekawan son si‐kami ni nanbasolan mi, tep mika ngo pekawani sota ira nanbasol son si‐kami. Karam itolok koma ja manbesol kami, no diket si‐kam i mengiredan son si‐kami say eg kami manbesol.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Si Jesus, in‐arigan to ira say eg ira koma on‐ekdas ja mansheẃat son Apo Shiyos; kowan to ey, “No kaspangarigan ey ondaw ka shi baley ni kajem mo ni kawa ni dabi ja ikowan mo son si‐kato ey, ‘Kajem, pabodorimak ka ni tedon boknol la tinapay, ");
INSERT INTO ibl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta ẃaray kajem kon mimotok shi baley ko et enshiy nak ipakan son si‐kato.’ ");
INSERT INTO ibl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nem sotan na kajem mon ẃara nodta naydaem ni baley to, onsongbat ja kowan to ey, ‘Karamak distolbo‐en! Nanbagat kami mala, tan saja ira annak ko tan si‐kak, shimokol kami ma. Ekak mebedin men onbangon ja mengi‐kan ni mesepol mo.’ ");
INSERT INTO ibl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jet ngaranto ma? Angken na en‐asneng nga onbangon ja mengi‐kan ni kasapolan mo tep sankajem kayo, kenshat ta mepidit ta onbangon no memasig ka ni baga. Jet i‐akan toy mesepol mo. ");
INSERT INTO ibl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Inges niyay i pesing nga mansheẃat son Apo Shiyos. No kanayon na manbeka kayo son si‐kato, i‐akan toy kekshawen jo. No eg kayo on‐ekdas sa mansheẃat son si‐kato, eẃaten joy mesepol jo. Panogtog kayo nin et idokatan tokejo. ");
INSERT INTO ibl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta emin ira sota manbeka, ono mansheẃat son Apo Shiyos, si‐karay mengeẃat ni mesepol sha. Tan emin ngo iray menogtog, si‐karay maydokatan. ");
INSERT INTO ibl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Arig toy san‐ama. Wara ayay inon‐an jon nga‐nga ja no manbeka so nen ameto ni piskaw ket oleg i i‐akan nen ameto? ");
INSERT INTO ibl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ono kaspangarigan ey sota anak to ket manbeka ni ikdog, apay kamajan ayay i‐akan to? Enshi, no diket say i‐akan to so nonta anak to, sota mapteng nga ibaga ni anak to. ");
INSERT INTO ibl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Si‐kayo, angken ngaaw i aramid jo, amtayo met ja mengi‐kan ni mapteng nga ibaga ni anak jo. No satan i ẃara son si‐kayo, mas pay ya amta nen Apo Shiyos ja Amejod dangit ja mengi‐kan ni mapteng nga banag so nonta emengshaw son si‐kato ni kasapolan to. I‐akan toy Ispirito Santo to so ira nonta manbeka son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Waray sakey ya toon eg maka‐esel jet say kabol la eg to a‐selan, ẃaray dimonyo ja pimeket son si‐kato. Si Jesus, inpabtik to sota dimonyo nodtan na too jet sota too, nan‐esel ma. Jet sota ira eshakel la too, nasshaaw iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nem sota ira eshom, endedamsis sha, ja kowan sha ey, “O‐owap to kari ey ẃares Apo Shiyos son si‐kato. Say toka osala ja pebtik so ni dimonyon pimeket shi totoo ket sota apo met laeng ni dimonyo ja si Bilsibol.” ");
INSERT INTO ibl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sota ira eshom, piyan shen peshasen si Jesus, isonga inkowan sha ey mandeka ni milagro ja asanan sha so kono no podnon inbetkag ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nem si Jesus, amta toy ẃared nemnem sha, isonga kowan to son si‐kara ey, “Dokodoko tan na inkowan jo. Apay nga inkowan jo ey sota apo ni dimonyo i naka osala? Eg towak todongan na pebtik so ni kait to met laeng, ta amta to ey sajay, arig toy ilin nanshowa. No manshowa shorog i sakey ya ili asan ireka mankobat, kenshat ta mepilshi sotan na ili. Kasta met sota pamilja ja manshowa, mansisi‐jan ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eg mebedin na si Satanas, pebtik to met laeng i kait to, tep amta to ey no dag‐en to iyay, eg onbayag i pansaad to. Kowan jo ey naka pebtik iray dimonyo tep si Bilsibol i emenodtodong son si‐kak? ");
INSERT INTO ibl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No kasta, kowan jo ey si‐kato ngarod i ka‐osala ni too jo ni shaka pengipebtik ngo ni dimonyo? No sotan i kowan jo, angken sota too jo, bedawen sha ita kowan jo ey sota apo ni dimonyo i ema‐osal ni pebtik so ni kait ton dimonyo. ");
INSERT INTO ibl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nankamali kayo. Si Apo Shiyos i kaontolong son si‐kak ja pebtik so ira ni dimonyo. Jet sotan i amta‐an jo so ey say pantoshayan nen Apo Shiyos, ẃara ma son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Say arig ni naka pesing so ni dimonyo, sajay. No sota toon ẃaray almas to ja matekal la mekigobat, enshiy en mengibot ni kokowa to no bantayan to ni olay sota baley to. ");
INSERT INTO ibl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nem no ebaken ni sakey ya toon mas matekal ey say sota ẃaray almas to, al‐en nonta mas matekal la emin da sota almas ton toka panshindi et ibingbingay toy kokowa nonta na‐abak. ");
INSERT INTO ibl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Sota toon eg on‐onod son si‐kak, ẃara ira son Satanas, ja sha‐akka kontra‐a. Jet sota eg ontolong son si‐kak ja mengolnong ni too, singa shaka pansisi‐jan ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kaspangarigan ey sota toon istay imonod son si‐kak nem eg to intoloy, mema‐ma et ngo mowan i kasesaad to. Sajay, may‐eshig nodta toon bintikan ni dimonyo. No sota dimonyo ket onbetik shi too, eman‐eka‐ekad shima kamag‐an ja eman‐ena‐enap ni pansalshengan to, nem enshiy to sepolen. Isonga nemnemnemen to ey on‐oli mowan shima toon istay kawad‐an to. ");
INSERT INTO ibl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jet no may‐odi, sebi‐en ton mimapteng ma jet ikowan to ey, ‘Siya, edinisan ma iya baley ko.’ ");
INSERT INTO ibl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Say pesing to, ondaw ja en mengodop ali ni piton kait to ja nankekedsel nem say si‐kato, jet onsekep iren man‐iyan nodtan na too. Jet sotan na too, mema‐may kasesaad to ey say nonta pilmiro.” ");
INSERT INTO ibl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Idi naksheng nga inkowan nen Jesus iyay, ẃaray biin inkedsang toy esel to ja naydaok so ira nonta eshakel la too, ja kowan to son Jesus ey, “Si Apo Shiyos i emindisiyon so nonta biin engi‐nak son si‐kam!” ");
INSERT INTO ibl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nem kowan nen Jesus ey, “Ebadbadeg i bindisiyon pay nen Apo Shiyos so nonta ira mengitneng ni esel to tan memati ni kowan to!” ");
INSERT INTO ibl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kanayon na manka‐shomi sota ira too ja mantetneng son Jesus. Jet nontan, inkowan to ey, “Ngaaw iray aramid ni too ma niman! Say shaka pan‐ibaga, sota milagro, ta kowan sha ey si‐katoy asanan sha so no agpayson si Apo Shiyos i engibetkag son si‐kak. Nem enshiy milagro ja en maypa‐sas son si‐kara niman! Say pengamta‐an jo ey inbetkag towak nen Apo Shiyos, no onsabi son si‐kak sota inges toy epasemak so nen Jonas nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tep si Jonas, nonta inmotok tod Niniba, si‐katoy mismon engamta‐an sha nontan na timpo ey si Apo Shiyos i engibetkag son si‐kato. Inges towak ja kowan sha ey Anak ni Too, ẃaray pengamta‐an ni too nem ekay ey si‐kak i inbetkag nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“No timpo alin pengigsheng nen Apo Shiyos no sipay maysedakan, ondayat sota arin bii ja edapod ma pesaw, jet ikowan to ey kenshat ta meshosa kayo. Tep si‐kato, edapod araẃin dogad ni indaw ton to itenengan i kalaing nen Ari Solomon ni toka pantosho. Jet niman, asas jo ta ẃared jay i engatngato ey say si Ari Solomon, jet eg jo pinati. ");
INSERT INTO ibl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Say sakey pay, sota totood Niniba ja intod‐an nen Jonas. Ondayat ira di no timpon pengigsheng nen Apo Shiyos no sipay maysedakan jet ikowan sha ey kenshat ta meshosa kayo. Tep si‐kara, nanbebawi ira nonta inteneng shay esel nen Apo Shiyos ja inkowan nen Jonas son si‐kara. Jet niman, asas jo ta iyay shiyay niman i engatngato nem say si Jonas, jet eg jo mowan pinati. ");
INSERT INTO ibl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“No bilang ey ẃaray kingki ja inparedang mo shi naydaem ni baley, simpri eg mesa‐keban, no diket maypa‐tok shi ekayang, say sota ira toon onsekep ali, asen shay seskepan sha. ");
INSERT INTO ibl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Sota matam, si‐katoy may‐eshig ey silew ni bakdang. Jet no mapteng i toka pengesas ni eshom, sota bakdang mo, may‐eshig ey napno ni dawag. Nem no sota matam ket ngaaw i toka pengesas ni eshom, may‐eshig ey emin na parti ni bakdang mo ket ẃared embolinget. ");
INSERT INTO ibl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Isonga pantanshaan ka, ta no ma‐enshiy istay dawag ni nemnem mo, may‐eshig ey embolinget ngon emin i kawad‐an mo. ");
INSERT INTO ibl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Isonga no napno i emin na parti ni bakdang mo ni dawag, ja enshiy parti ton embolinget, napno ka ngo ni kinamapteng, ja singa inges toy silew ja sinilẃan toka.” ");
INSERT INTO ibl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Idi naksheng si Jesus ja nan‐esel, sota Parisiyo, ineẃis tos Jesus ja en mekipengan shi baley to, jet dimaw si Jesus ja en ekilikob son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sota Parisiyo, nasshaaw nonta dinmo ton eg nanbolo nin si Jesus ni inpangan to. ");
INSERT INTO ibl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kowan nen Apo Jesus son si‐kato ey, “Si‐kayon Parisiyo, say itsora ni ogadiyo, singa sota tasa ono malokong ja showal to bengat i eki‐ẃanan, nem sota dikong to, edogit ta pasiya. Sotan i kay‐eshigan jo tep say joka ipa‐sas shi karakdan, singa maronong kayo, nem say joka dagdag‐a, sota pengamkamkam ni kompormi tan sota eshom ma ngaaw. ");
INSERT INTO ibl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Enshiy am‐amtayo! Si Apo Shiyos, piyan ton mapteng koma i ẃared poso jo, ja inges toy mapteng nga joka pesing shi sango‐an ni totoo. ");
INSERT INTO ibl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","No shi ebiteg komay joka pengi‐kani ni ẃara son si‐kayo, mapteng may emin na ẃared poso jo. ");
INSERT INTO ibl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kaasi kayo di, si‐kayon Parisiyo! Ta joka tongtongpala sota bilin na ootik i pateg to, nem joka et ngo mowan ibiyang sota bilin na epateg ga pasiya! Kaspangarigan, joka idaton so nen Apo Shiyos ja singa bingay to sota maykesampolo nodta emin na apit jo, angken pay sota molejo ja para seng‐ew ni sira. Nem joka diẃayi sota koston pesing shi kait jon too tan sota penmek jo son Apo Shiyos. Sajay ya joka pesing nga mengi‐kan ni singa bingay nen Apo Shiyos, mapteng; nem mesepol la eg jo diẃayan iya ẃa‐ẃa‐shen piyan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kaasi kayo di, si‐kayon Parisiyo! Ta pipiyan jon ontongaw shima naysaganen tongawan say mebigbig kayo, tan pipiyan jo pay ya rispito‐en shakejo ni totoo, ja semsemano‐an shakejo shima malkaro ja karakdan ni too. ");
INSERT INTO ibl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaasi kayo din pasiya! Ta may‐eshig kayon singa naybeka‐an ni too ja enshiy malka to, ja eg idasin ni toon man‐ekad.” ");
INSERT INTO ibl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sota sakey ya maistoro ni dinteg ni Hodiyos, kowan to son Jesus ey, “Maistoro, idi inkowan mo iyay, singa inda‐kam mokamin maistoro ni dinteg et ebebaingan kami ngo!” ");
INSERT INTO ibl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Simongbat si Jesus ja kowan to ey, “Angken si‐kayo ngon mamaistoro ni dinteg, kaasi kayo di! Ta joka ida‐kariy too ni embel‐at ta bilin jon eg sha iposi. May‐eshig ey joka ira bel‐ati ni kalka ja eg sha iposi, nem si‐kayon mismo ket eg jo pay peshasen na angken sakey ya kalomot joy mandi‐bit. ");
INSERT INTO ibl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kaasi kayo di! Ta si‐kayo i nandaga ni monyominto ira nonta para padto nen Apo Shiyos nonta bayag da ja binbinno ni ap‐apo jo la nontan da. ");
INSERT INTO ibl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sata ira monyominto ja inemag jo, si‐katoy ka‐asan to ey joka aporbali sota inpamono nonta ira apo jo la so nonta ira para padto nen Apo Shiyos nonta bayag da. Sota ap‐apo jo i emono et si‐kayo ngoy engamag ni monyomintora. ");
INSERT INTO ibl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nay‐eshom kayo nodta aramid da nonta ap‐apo jo, isonga agpayso noman sota kowan nen Apo Shiyos ey, ‘Mengibetkagak da ngo son si‐kara ni totoon para padto tan sota eshom ma totoo ja mengikowan ni esel ko. Nem bono‐en sha sota ira eshom, tan pedigaten shay eshom.’ Sajay i inkowan nen Apo Shiyos tep amta to ey tima‐nil kayo ja en‐oges joy toka ibetkag ali son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Isonga si‐kayon too niman na timpo, meshosa kayo di ja ikaro jo sota inpamono ni ap‐apo jo so nonta ira inbetkag nen Apo Shiyos, manshoki nonta inkapalsowa niya dobong ingkato niman. ");
INSERT INTO ibl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Say pilmiron ebono nontan da bayag, si Abel, jet say ka‐onoran, si Sakarias, ja binono ni too nonta bayag da shima naydaem ni Timplo, ja nay‐esop shima kowan sha ey altar. Owen, ikowan ko ey emin iyay, si‐kayon too niman i mengikesho. ");
INSERT INTO ibl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kaasi kayo di, si‐kayon mamaistoro ni dinteg! Ta si‐kayo i kabol la eg so amta‐an ni totoo ni maypangkep so nen Apo Shiyos. Si‐kayon shorog, eg jo koston amta‐an, jet si‐kayo i timiped so ira nonta toon makapiyan na mengamta.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Idi naksheng nga inkowan to iyay, bimo‐day si Jesus nodtan na baley. Nem sota mamaistoro ni dinteg ni Hodiyos tan sota ira Parisiyo, empait shen pasiya sota inkowan to; isonga manshoki nontan, pineshas shen pasiya i kabaalan shen menaol son si‐kato. Say inpasing sha, eshakel i inbagabaga sha son si‐kato ni maypangkep ni ka‐iri‐irin, ta kowan sha ey balang nem ẃaray pankamali‐an ton isongbat, ja pebesolan sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nontan, shimakel la pasiyay totoon emay‐odo‐odop son Jesus, ja shaka pay pan‐ikatin i sedi ni eshom. Jet nontan, ẃaray inkowan nen Jesus, nem ẃa‐ẃa‐shen sota too to i toka pan‐ikowani so; kowan to ey, “Tanshaaniyo iray Parisiyo, tep singa mapteng ira nem o‐owap gayam i kamapteng sha. Baka ma‐edinan kayo ni ngaaw wa ogadira, ja singa inges toy para debag ni tinapay ja toka edinay kaydaokan to. ");
INSERT INTO ibl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kowan sha emo ey enshiy maka‐amta ni ogadira, nem kenshat ta ma‐amta‐an. Emin na ngaaw wa aramid ni too ja shaka i‐emot, ma‐amta‐an ngoreshan. ");
INSERT INTO ibl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Emin na esel la sikrito, ma‐amta‐an shi karakdan, tan emin na esel la maytetobo shi naydekeb ba kowadto, maykeljaw ngod karakdan. ");
INSERT INTO ibl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kagajem ko, iyay i kowan ko son si‐kayo. Karekayo ontakot so nonta ira makakontra son si‐katejo, tep bakdang bengat i kabaalan shen bono‐en. ");
INSERT INTO ibl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nem say mesepol la metekotan koma, si Apo Shiyos, ta ẃaray kabedinan ton mengipedaw son si‐kayo shi impiyarno nem meksheng kayon metey. Owen, mesepol la si‐katoy tekotan jo! ");
INSERT INTO ibl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nem ẃara ngoy ebadeg ga semek nen Apo Shiyos. Nemnem jo kari sota titit. Enshiy banol ni titit, nem eg to ira ibiyang. No ẃaray menongkal ni titit, angken showen sintimos i dima, nem angken sakey so nonta ira titit, enshiy en dinibkan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Angken pay sota bowek ni toktok jo, amta nen Apo Shiyos i kabebilang to. Isonga karekayo ontakot tep nandasin i semek to son si‐kayo nem say sota eshakel la titit. ");
INSERT INTO ibl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iyay pay i ikowan ko son si‐kayo. Sota toon mengikowan so ni too ey ẃara son si‐kak, si‐kak ja kowan sha ey Anak ni Too, ikowan ko ngo shi sango‐an ira ni anghil nen Apo Shiyos shi dangit ey sotan na too ket took ka emepiyal. ");
INSERT INTO ibl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nem sota toon mengikowan so ni too ey eg towak amta, ibiyang ko ngo shi sango‐an ira nonta anghil nen Apo Shiyos shi dangit. ");
INSERT INTO ibl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Angken sipen too ja ngaaw i toka ikokowan maypangkep nonta kowan sha ey Anak ni Too, mebedin na mepekawanan. Nem sota ngaaw i toka ikokowan maypangkep nonta Ispirito Santo nen Apo Shiyos, eg mebedin na mepekawanan. ");
INSERT INTO ibl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“No idaw shakejon mebistigal shi sango‐an ni toray ni Hodiyos, ono shima engaton toray, karekayo meshanagan no ngarantoy isongbat jo ono ngarantoy ikowan jo son si‐kara, ");
INSERT INTO ibl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ta sota isongbat jo, ipa‐amta met laeng ni Ispirito Santo nen Apo Shiyos son si‐kayo nontan na oras ja shakejosoka pan‐ibag‐i.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Waray toon naydaok nodtan na eshakel la totoo ja kowan to ey, “Maistoro, ikowan mo son agik ey panbingay mi sota tawid ja minos‐an to.” ");
INSERT INTO ibl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nem si Jesus, kowan to ey, “Kajem ko, aliẃen si‐kak i mengigsheng nita tawid jon kowan mo ey panbingay jon san‐agi.” ");
INSERT INTO ibl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jet intoloy ton ẃaray inkowan to so nonta totoon eshakel ey, “Pantanshaan kayo ta baka ẃaray pengamkam jo ni kompormi, ono apal jo ni kokowa ni eshom, ono ma‐isew kayo. Say biyag ni too, aliẃen shi kokowa toy toka pandepo‐i, no diket si Apo Shiyos i nanngel, angken ngantoy kabaknang to.” ");
INSERT INTO ibl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jet si Jesus, in‐arigan to ira ja kowan to ey, “Waray baknang ja asdeg toy toka epita nodta bo‐day to. ");
INSERT INTO ibl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Say kowan to shorog ni bakdang to, ‘Enshiy pengitdo‐an ko nima eshakel la apit ko. Ngantoy pesing ko aya?’ ");
INSERT INTO ibl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nannemnemnem, jet say kowan to shorog shi bakdang to, ‘Sajay gayam i dag‐en ko. Bagbagen ko ima sigod ja naka pengitdo‐i et mengemagak ni ebadbadeg, jet si‐katoy pengitdo‐an ko ni emin na apit ko, tan sama eshom pay ya kokowak. ");
INSERT INTO ibl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jet say ẃara med nemnem ko, ekak ma manshanag tep ẃaren emin i mesepol ko ni pigen tawen. Angken ekak ma man‐obda! Menganak tan menginomak bengat. Dadsak may dagdag‐en ko!’ ");
INSERT INTO ibl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nem say kowan nen Apo Shiyos so nontan na baknang, kowan to ey, ‘Dokodoko tan na nemnem mo! Niman na dabi, odi‐en koy biyag mo! Jet eg mo kenasen ita emin na kokowam ma inolnong mo!’ ” ");
INSERT INTO ibl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kowan pay nen Jesus ey, “Say pengidmang nen Apo Shiyos so ni toon baknangan to bengat i toka nemnemnema, ebadeg i nankolangan to. Say mepesamak ali son si‐kato, inges to sota epasemak so nonta baknang shiyay den istoriya.” ");
INSERT INTO ibl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Si Jesus, kowan to so nonta too to ey, “Isonga say kowan ko son si‐kayo, aliẃen kayo meshanagan ni panbiyag jo: no ngarantoy kenen jo ono ibaro jo. ");
INSERT INTO ibl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta say biyag tan bakdang, epateg nem say mekan tan baro. Si Apo Shiyos i engi‐kan ni biyag tan bakdang et si‐kato ngoy mengi‐kan ni kasapolan to. ");
INSERT INTO ibl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Idmang jo kari ira ja kaẃang ono owak: eg ira manmoda ono mengepit; enshiy shaka pengitdo‐i ja sarosal sha. Nem si Apo Shiyos i ememekan son si‐kara! Jet araẃin nandasin i semek to son si‐kayo nem say sota ira titit. ");
INSERT INTO ibl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sota joka panshanshanag, eg to met peshokey i biyag jo ni angken ootik bengat. ");
INSERT INTO ibl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No sota shanag jo ket eg to posi‐en iyay ya ootik ka banag, apay nga sota panbiyagan joy joka panshanagi pay laeng? ");
INSERT INTO ibl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Asas jo kari ira sota sabsabong shima shontog; nemnem jo kari no toway toka pesing nga manbiyag. Eg met man‐obda ono mengebel ni baro, nem iyay i ikowan ko son si‐kayo. Angken si Ari Solomon ja kabaknangan nonta bayag da, emin sota osal ton nankemapteng, eg sha pay ingesen i kamapteng ira nima sabsabong. ");
INSERT INTO ibl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sota sabsabong, maganoy ka‐enshi to: emansebong niman et no meẃa‐ẃa, maypool shi apoy. Nem si Apo Shiyos ket eg to i‐oway. Sinto pay kayo mangon too to ja to i‐oway! Isonga eg tokejo baybay‐an. Si‐kayo, ootik eshan i pamatiyo, isonga kayoka meshanagin pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tan aliẃen sota kenen jo tan inomen joy jo nemnemnemen. Karekayo manshanag, ");
INSERT INTO ibl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tep si Amejon ẃared naykayang, amta toy emin na mesepol jo. Sota ira toon enshiy pamatira son Apo Shiyos, anam shen manshanag ni panbiyagan sha, aliẃen si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nem say epateg komen nemnemen jo, sota pantoshayan nen Apo Shiyos. No sajay i pesing jo, emin na banag ja kasapolan jo, i‐eshom nen Apo Shiyos ja i‐akan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Si‐kayon took ja naka banbantayi, karekayo ontakot. Angken ootik kayo, si Amejon ẃared naykayang, eman‐imdeng nga pasiya ja si‐kayoy mayda‐kam shi pantoshayan to. ");
INSERT INTO ibl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilekoyoy kokowayo et sota pandeko‐an jo, i‐kan jo so nonta totoon makasapol. Sotan i koston pesing nga mengolnong ni kokowa shi dangit ja eg mepilshi. Shiman, enshiy mengibot so, tan angken sota baro, enshiy bigis sa onsharal so. ");
INSERT INTO ibl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Shi dangit komay ẃa‐ẃa‐shen pengolnongan jo ni kokowayo, ta sota kawad‐an ni kokowayo, si‐katoy ẃared nemnem jo ni olay. ");
INSERT INTO ibl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Mesepol la esagana kayo ni olay ja enshiy ontiped ni pansilbiyo son si‐kak. Mesepol la ingesen joy kepansesked ni baga‐en shiyay ya istoriya. Waray toon dimaw ja eki‐atindar ni kasal et sota ira baga‐en to, kanayon na ireka mansessesked ali ni imotok to. Wara ni olay i silew sha, say no menogtog si apo sha, idokatan shen shagos. ");
INSERT INTO ibl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Ta no onmotok ali, ja angken kawa ni dabi ono palbangon, sota ira baga‐en ton sebi‐en ton eg na‐ogip, bindisiyonan nonta apo sha. Man‐imdeng ira tep sota apo sha, petongaw to ira jet si‐kato et ngo mowan i mengi‐kan ni kenen sha. ");
INSERT INTO ibl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Jet angken si‐kayo, pansagana kayo, ta say imotok ko ali, kompormin oras ja inges toy kaidaw ali nonta mengibot shi baley. No sota makabaley ket amta to koma no ngaranton oras ni edabi i idaw ali nonta mengibot, kenshat ta mansekana, eg to itolok ka onsekep sota mengibot shi baley to. Jet angken si‐kayo, mesepol la esagana kayo ni olay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jet kowan nen Pedro ey, “Apo, si‐kamin toom i inkowanan mo so niyay ya arig, ono angken pay sota karakdan?” ");
INSERT INTO ibl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Si Apo Jesus, simongbat ja kowan to ey, “Sota baga‐en ja emepiyal, ja amta toy toka dagdag‐a, si‐katoy piyalen nonta apo ton mengimanshal ni kokowa to, tan si‐katoy mepiyal la mengi‐kan ni dasjon ira nonta kait ton baga‐en no timpo to. ");
INSERT INTO ibl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jet no sotan na baga‐en ket maramen eman‐obda ey onmotok ali sota apo to, mapteng i konkona ton i‐akan nonta apo to. ");
INSERT INTO ibl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Agpayso iya ikowan ko son si‐kayo. Sotan na baga‐en, no sebi‐en nen apo ton eman‐obda, si‐katoy piyalen nen apo to ja en mengimanshal nonta emin na kokowa to. ");
INSERT INTO ibl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nem sota sakey ya baga‐en, ja kowan to ey, ‘Angkena tep si apok, metaktak alin onmotok’, kakaasi sotan. Ishogi ton sepsepdaten ira sota kait ton baga‐en, ja daleki man tan bibii, tan mesiẃat ni dadsak ton pengan tan penginom ingkatod keboteng to. ");
INSERT INTO ibl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kakaasi sotan na baga‐en tep sota apo to, on‐oli ali jet ondibag tep eg to amta sotan na i‐oli ali nonta apo to. Jet sotan na baga‐en, pekishosa to so nonta ira kait ton baga‐en ja eg mepiyal. ");
INSERT INTO ibl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sota baga‐en ja amta toy piyan nonta apo ton dag‐en to, nem eg to pati‐en, embel‐at i shosa to. ");
INSERT INTO ibl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nem sota baga‐en ja eg to amtay piyan nonta apo ton dag‐en to, jet ẃaray dag‐en ton panbesolan to, engka‐jas i shosa to. Iyay i nemnemen jo koma. Sota toon ẃa‐ẃa‐shay nay‐akan son si‐kato, asdeg toy namnama‐en ni apo ton obda‐en to. Tan sota toon ebadbadeg i may‐eẃat son si‐kato, ebadbadeg ngoy songbatan to. ");
INSERT INTO ibl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Dimawak alin mengidaw ni singa apoy shiya dobong et sapay koma ta ẃara ma niman. ");
INSERT INTO ibl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Waray bonjag alin mepesamak son si‐kak et enshiy talnak ingkatod meksheng. ");
INSERT INTO ibl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aliẃen jo ipangkep ey dimawak alin mengi‐kan ni olnos shiya dobong. Aliẃen sota maypangkep ni olnos i dinaẃan ko di, no diket say panbenagan ali ni indaw ko di, eg man‐i‐inawatan i totoo. ");
INSERT INTO ibl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Manshoki niman, eg man‐i‐inawatan i angken toon sanpamilja. No kaspangarigan ẃaray nanpamilja ni dima, manshowa jet sota tedo, kabakal toy showa, tan sota showa, kabakal toy tedo. ");
INSERT INTO ibl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Angken sota a‐ama, kabakal sha aliy annak sha. Kasta met iray i‐ina tan annak shen bibii, manbekal ira. Angken sota bibiin san‐inepo, manbekal ngo ira.” ");
INSERT INTO ibl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kowan nen Jesus so nonta ira eshakel la totoo ey, “No asen jo aliy kolpot ja medepod baybay, amtayo ey kenshat alin on‐oran. ");
INSERT INTO ibl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jet no dekna‐en jon emankedapo aliy shagem shi dogad ja kaptangan, amtayo ey kenshat ta onpetang ma diy timpo. Jet siya, kaonpetang i timpo. ");
INSERT INTO ibl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Joka eẃatiy timpo alin onsabi no asen joy emankepasemak shi naykayang ono shiya dobong, nem apay nga eg jo eẃatan ey emin sota emepespesamak niman na timpon kawashak son si‐kayo, asdeg to met i kay‐odogan to! Ma‐o‐owap kayon too! ");
INSERT INTO ibl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Apay nga eg jo idasin i koston pansigshan jo? ");
INSERT INTO ibl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Niman na ẃaray ẃaya jo pay laeng, panbebawi kayo ni eg jowak so pinati‐an. Ta say arig ni kasesaad jo, inges toy toon emankaikoyod shi oskaro maypangkep ni otang to. Isonga dagam i kabaalan mon mekikajem ma shagos son si‐kato no maramen tokaka pan‐i‐ilaw shima oskaro, say eg toka i‐awat nodta kowadja ja mengibedod son si‐kam. ");
INSERT INTO ibl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta say kowan ko son si‐kam, no ẃara ka ma shima badoran, eg ka onbo‐day ingkatod bayshan moy oltimon sintimos ja inotang mo.” ");
INSERT INTO ibl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nontan na timpo, ẃaray mimotok alin totoo et inkowan sha son Jesus ey, “Wara kono iray i‐Galilia ja binono nen Gobinarol Pilato nonta maramen ireka emengi‐kan ni daton sha son Apo Shiyos shi Timplo.” ");
INSERT INTO ibl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Si Jesus, simongbat ja kowan to ey, “No kasta, say kowan jo emo, ‘Isonga binonora ira ta ebadeg i basol sha nem say sota eshom ma tood Galilia; inkaro sha emo.’ ");
INSERT INTO ibl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nem say ikowan ko son si‐kayo, enshi. Jet angken si‐kayo, no eg jo ibebawiy basol jo, metey kayon emin ja inges toy inkatey sha. ");
INSERT INTO ibl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Asan say sakey pay, ngantoy kowan jo nonta sampolo tan ẃalon edisgrasiya shi Siloam ja etedteshan ja etey? Kowan jo mowan ey si‐katoy ka‐asan to ey ebadeg i basol sha nem say sota eshom ma tood Jerusalem? ");
INSERT INTO ibl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Enshi. Jet say ikowan ko son si‐kayo, no eg jo ibebawiy basol jo, metey kayon emin ja inges sha.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jet si Jesus, inkowan toy arig son si‐kara, ja kowan to ey, “Waray inmola ni too ja kowan sha ey higos. Idi bima‐deg sota mola, dimaw iyay ya too, to inon‐an nem ẃaray dames to. Nem enshin polos i dames to. ");
INSERT INTO ibl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Isonga say kowan to nonta toon toka panbantay ni bo‐day to, ‘Idmang mo kari. Tedon tawen na kanayonak alid jay ya mengesas nem ẃaray dames niyay ya mola, nem enshin polos ni olay, angken sakey. Batang mo et; pekeẃas to et iya bo‐day ja naymola‐an to.’ ");
INSERT INTO ibl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nem say kowan nonta toon emanbantay, kowan to ey, ‘Bay‐im nin apo, ni angken makatawen bengat. Iparas kon sedaro‐an tan ebono‐an. ");
INSERT INTO ibl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Balang nem ondames alin sakey ya tawen. Nem no enshi, angken pebetang mo.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Idi sakey ya akew wa ngilin ni Hodiyos, emantosho si Jesus shi baley ya sa‐nopan ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jet ẃara nodtan i biin pingketan ni dimonyo. Sotan na dimonyo, inpansakit to sota bii ni sampolo tan ẃalon tawen. Napkoy beneg to jet eg mebedin na on‐ekẃas. ");
INSERT INTO ibl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Idi inon‐an nen Jesus iyay ya bii, tineẃal to ja kowan to ey, “Niman, ma‐kal ma sota sakit mo.” ");
INSERT INTO ibl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Inkepap toy takday to so nonta bii et nay‐inshas ngon mimapteng i bakdang to, jet imekẃas ma. Jet ebadeg i iyaman nonta bii son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nem sota pangolo nodtan na sa‐nopan, bimonget tep inpamapteng nen Jesus sota bii nontan na akew ja timpon ngilin. Jet say inkowan to so nonta ira totoo, kowan to ey, “Enem ma akew i koston timpo ja pan‐obdayo, jet si‐kato ngo diy idaw jon en manpa‐ekas, aliẃen niman na timpon akew ni ngilin!” Kowan nonta pangolo. ");
INSERT INTO ibl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nem si Jesus, simongbat ja kowan to ey, “Si‐kayon ma‐o‐owap! Aliẃen emin kayo ket joka ibolos i nowang jo ono kabajoyo no akew ni ngilin, say en man‐inom? ");
INSERT INTO ibl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Say kowan jo, ngaawak tep inbolos ko iya biin poli nen Abraham ja singa binedod nen Satanas ni sampolo tan ẃalon tawen. Say kowan ko, mesepol la ma‐ekasan, angken akew ni ngilin.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jet emin sota toon makakontra son si‐kato, ebebaingan ira nonta esel ja inkowan nen Jesus, nem sota eshom ma totoo, ireka man‐imdeng nonta inon‐an shen kaskasshaaw ja dingka to. ");
INSERT INTO ibl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Intoloy nen Jesus ey, “Itnengiyo iya ikowan kon pengi‐ingesan ni pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Say pantoshayan nen Apo Shiyos, may‐eshig nodta botil ni sakey ya kalasin mola, ja ootilik. Sajay ya botil, inda ni too et in‐esek tod bo‐day to. Idi bima‐deg sota mola, nanbalin ni ebadeg ga kadasan, jet sota ira titit, nan‐obong ira shima pangpanga to.” ");
INSERT INTO ibl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Asan kowan pay nen Jesus ey, “Iyay pay i i‐arigan ko so ni pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","May‐eshig nodta para debag ni tinapay ja inda ni bii, ja to indaok nodta eshakel la arina ingkatod inedinan ton emin.” ");
INSERT INTO ibl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Si Jesus, nantoro shi emin na dogad ja shindan to nonta dimaw shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nodta sakey ya dogad, ẃaray toon nansalodsod son Jesus ja kowan to ey, “Apo, ootik ngatay maysedakan?” Simongbat si Jesus ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Dagejoy kabaalan jon pasiya say si‐kayoy sakey. Ta say sakepan ja ondaw shi kaysedakan, may‐eshig ey edipit. Ikowan ko son si‐kayo, eshakel i totoon mengipeshas ja onsekep no onsabi sotan alin akew, nem eg mebedin. ");
INSERT INTO ibl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ta no meksheng nga idekeb nonta makakokowa, angken pigay togtog jo, kenshat ta ẃara kayo med showal. Angken kowan jo ey, ‘Apo, ilokati jokami!’, eg ma mebedin. No diket say isongbat to, ‘Eg takejo am‐amta. Toway edapo‐an jo?’ ");
INSERT INTO ibl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jet ikowan jo ngo ni songbat jo ey, ‘Ekipengan kami met tan eki‐inom kami son si‐kam! Nantoro ka pay met shi ili mi!’ ");
INSERT INTO ibl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nem say isongbat to son si‐kayo, ‘Ekak met amtay edapo‐an jo! Ki‐nan kayod jay! Ta si‐kayo, ngaaw i aramid jo nontan.’ ");
INSERT INTO ibl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","No timpo alin pantoshay nen Apo Shiyos, asen jos Abraham, Isaac, si Jacob, tan sota ira emin na para padto nen Apo Shiyos nonta bayag da, ja ẃara ira nodtan, nem si‐kayo, maydesin kayod showal. Jet shiman, nangis bengat i dagdag‐en jo, tan panngedetnget joy sangi jo ni daringit jo. ");
INSERT INTO ibl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eshakel aliy medepod emin na sakop niya dobong, ja angken aliẃen Hodiyos, jet si‐karay ontongaw wa mekilikob shima pantoshayan ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jet sota eshom ma toon kowan sha ey si‐karay mepangdon onsekep, si‐kara et ngo mowan i man‐onod, jey sota eshom ja nan‐onod niman, si‐kara et ngo mowan i mepangdo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nontan met laeng nga oras, ẃara iray Parisiyo ja dimaw son Jesus jet sha inkowan ey, “Betik ka niman shiyay, daw ked eshom ma dogad. Ta si Ari Hirodis, piyan ton bono‐en toka.” ");
INSERT INTO ibl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nem simongbat si Jesus ja kowan to ey, “Jo ikowan so nita sinan arin masikap ey ekak idekjas nin iyay ya dogad to. Niman tan kabasan, naka panpebtik iray dimonyo shi totoo, tan naka panpemapteng sota totoon emanpansekit. No bowas to, meksheng may obdak shiyay. ");
INSERT INTO ibl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nem siya, angken ẃara‐ak shiya sinekopan to ingkatod bowas to, itoloy ko met laeng ja ondaw shi Jerusalem. Tan sakey pay, eg mebedin na mebono‐ak shiyay. Tep say kebono‐i ni toon inbetkag ali nen Apo Shiyos, shi Jerusalem, jet na‐alas no ẃaray mebono shi apil la dogad!” ");
INSERT INTO ibl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jet si Jesus, idi ninemnem toy kakedsel ni tood Jerusalem, dinekna toy toka pengisekit son si‐kara, jet kowan to ey, “Si‐kayon tood Jerusalem! Manshoki nonta bayag da ingkato niman, joka bono‐a ni olay ja kespigan ni bato iray inbetkag nen Apo Shiyos son si‐kayo, pati sota ira para padto. Ara, piga mangoy pesing ko son si‐kayo! Eminshakel la piyan kon i‐okong takejon i‐Jerusalem ja inges to sota kepengi‐okong ni manok ira ni kipkip to. Nem en‐asneng kayo! ");
INSERT INTO ibl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Niman ma, olay to kayo ngo, tep enshis Apo Shiyos shi Timployo ja mengibediw son si‐kayo. Jet ikowan ko ey si‐kayon i‐Jerusalem, ẃaray timpon imotok ko son si‐kayo ja asen jowak et ikowan jo ey, ‘Bindisiyonan koma nen Apo Shiyos iya toon inbetkag to di!’ ” ");
INSERT INTO ibl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nonta sakey ya akew ja timpon ngilin ni Hodiyos, dimaw si Jesus ja en mekipengan shi baley nonta sakey ya pangolo ni Parisiyo. Jet sota ira makakontra son Jesus, shaka si‐siimi no ngarantoy dag‐en to. ");
INSERT INTO ibl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jet naytompong nontan ja ẃaray dimaw son Jesus ja toon dimarag iray sedi to tan takday to. ");
INSERT INTO ibl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Si Jesus, inbag‐an to sota ira mamaistoro ni dinteg ni Hodiyos tan sota ira Parisiyo ja ẃara nodtan, ja kowan to ey, “Ngantoy kowan jo? Kaiparit aya ni dinteg tayon Hodiyos i pemapteng so ni toon emansekit ni akew ja timpon ngilin, ono enshi?” ");
INSERT INTO ibl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nem enshiy shaka isongbat. Jet si Jesus, kimpap to sota too et na‐kal sota darag ni sedi to tan takday to. Jet kowan ma nen Jesus son si‐kato ey, “Siya, daw ka.” ");
INSERT INTO ibl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jet kowan nen Jesus so nonta emeni‐siim son si‐kato ey, “No kaspangarigan sota sakey son si‐kayo ket ma‐kas i anak to ono baketo shi pel‐og ey naytompong nga akew ni ngilin nontan, eg jo aya kano‐an ja en al‐en nontan met laeng nga akew?” ");
INSERT INTO ibl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nem nasdengan ira, ja enshiy sha isongbat ni maypangkep niya inkowan to. ");
INSERT INTO ibl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Inon‐an nen Jesus ey sota ira eshom ma bisita, ireka manpidi ni mapteng nga dogad ja tongawan. Isonga inkowan to iyay ya arig son si‐karen emin, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No ẃaray mengeẃis son si‐kam shi kasal, kareka ontongaw shima kamaptengan, ta eg mo amta no ẃaray eshom ma toon epateg pay ey si‐kam ja na‐awis nodtan na kasal. ");
INSERT INTO ibl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","No iba‐ngat moy tongaw nodta kamaptengan, baka ondaw ali sota engawis son si‐kayon showa et ikowan to son si‐kam ey, ‘Dayat ka, aliẃen si‐kam i ontongaw shiyay; saja opisiyal.’ Jet nakol ni si‐kam i mebebaingan ja en ontongaw nodta kawad‐an ni nankebaben too. ");
INSERT INTO ibl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Say mapteng nga pesing mo no ma‐eẃis ka, tongaw ka shima kawad‐an ni nankebaben too, say no asen toka nonta engawis son si‐kam, ondaw ali ja to ikowan son si‐kam ey, ‘Kajem, kaled ja kad‐an ni nankengaton too.’ Jet sajay i kayshedjawan mo shi sango‐an ira nonta emin na eshom ma bisita. ");
INSERT INTO ibl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sota mengingeto shorog ni bakdang to, maybeba et ngo mowan. Jet sota mengibeba ni bakdang to, si‐katoy mayngeto.” ");
INSERT INTO ibl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jet kowan nen Jesus so nonta Parisiyo ja engawis son si‐kato ey, “No nemnemen mon memekan ni eshakel la totoo, aliẃen sota kagajem mo komay eẃisen mo, ono sota a‐akim, ono partidom, ono sota ira bebaknang ja inaskang mo, ta mebedin na i‐inges sha ngoy inpasing mo, ja eẃisen shaka ngo, jet mesobalitan sota mapteng nga inpasing mo son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No kaspangarigan ey manpiyasta ka, say eẃisen mo komen en mekikan, sota ira nankebiteg, nankepilay, nankeki‐ngoy i takday sha, tan sota nankekorab. No satan i pesing mo, ");
INSERT INTO ibl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kosto may imdeng mo. Tep sajay ira, eg sha kabaalan na onsobadit son si‐kam ni inges nonta inpasing mo, isonga si Apo Shiyos i onsobadit son si‐kam no timpo alin panbiyag mowan nonta ira totoon emati nonta bilin nen Apo Shiyos nontan den ẃara ired biyag pay laeng.” ");
INSERT INTO ibl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Waray sakey so ira nonta naydikob son Jesus; inteneng to sota inkowan nen Jesus sa “panbiyag mowan” et kowan to son Jesus ey, “Magesat ira di sota ẃaren mekilikob nem timpon pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Say songbat nen Jesus so nontan na too, inpalaw to shi sajay ya istoriya, ja kowan to ey, “Waray toon nanpiyasta ni ebadeg et engawis ni eshakel la totoo. ");
INSERT INTO ibl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nonta shanshani sota piyasta, engibetkag ni baga‐en ton en mengikowan ira nonta na‐awis sa bisita ey naysaganen emin, isonga angken ondaw da ira. ");
INSERT INTO ibl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nem emin ira sota na‐awis, nanpangbal ira. Sota pilmiro, kowan to nodta inbetkag ni manpiyasta ey, ‘Waray tinongkal kon payew. Mesepol la ondawak, nak asen. Pangpangaasim, pasinsiya‐imak.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kowan ngo nonta sakey ey, ‘Enongkalak ni dimen paris sa bomalon nowang. Mesepol la ondawak, nak bisna‐en. Pangpangaasim, pasinsiya‐imak.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jet sota sakey, kowan to ngo ey, ‘Ikaypangasawak, isonga ekak maka‐edaw.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sota baga‐en, nay‐oli et inkowan ton emin sota dason nonta ira istay to odopen so nonta apo to. Jet sota apo to, bimonget et kowan to ey, ‘Kano‐im, daw ka shima kalkalsara ni siyodad ja kesa‐nopi ni totoo, jet angken sota ira nankebiteg, nankeki‐ngoy i takday sha, nankekorab, tan nankepilay, olop mo di ira.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Simongbat sota baga‐en ja kowan to ey, ‘Apo, tinongpal ko sota inkowan mo, nem eẃaya pay laeng, angken eshakel pay aliy ondaw.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jet kowan nonta apo to ey, ‘No kasta, daw ka shima dogad ja eg sinekopan ni siyodad, jet angken sota totoon asen mod shalan, pilit mon eẃisen ira say ondaw ali ira et mepno iya baley ko. ");
INSERT INTO ibl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nem sota ira et ngo mowan na na‐awis sa sigod, angken sakey son si‐kara, enshiy mayda‐kam ja mekikan.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nontan, eshakel la pasiya i totoon emay‐odo‐odop son Jesus shi shalan. Nanposipos si Jesus et kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sota toon ondaw ali ja kowan to ey manbedin ni took, mesepol la si‐kak i ẃa‐ẃa‐shen patkan to, ja aliẃen si ameto, ineto, aseẃa to, annak to, a‐aki to, ono sota bakdang to shorog. No sota eshom i ẃa‐ẃa‐shen patkan to, eg maykeshin took. ");
INSERT INTO ibl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jet sota toon eg to enosan i kaybebaing to ono kebitay to maypangkep son si‐kak, eg mebedin na manbedin ni took. ");
INSERT INTO ibl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mesepol la nemnemen to nin i pandikat to ali maypangkep son si‐kak, asan ka‐onod. Arig toy pannemnem ni toon mandeka ni baley. Simpri ontongaw nin jet kowinta‐en to nem pigay kasto‐en to, say amta‐en to nem on‐anay sota pilak to ingkatod meksheng sota baley. ");
INSERT INTO ibl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta no iba‐ngat toy towen ey enshiy on‐anay ya kasto‐en to, eg mebedin na meksheng sota baley. Kekshengan ni itowen to so ira ni tokod, eg to ma itoloy. Jet emin ira sota mengesas, damsisen sha, ");
INSERT INTO ibl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ja kowan sha ey, ‘Sajay ya too, inshogi ton mengitakshel ni baley to, nem eg to posi‐en na kekshengen.’ ");
INSERT INTO ibl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Arig to mowan sota sakey ya ari ja sampolon diboy solsharo to. No sota kabakal ton ari, showen polon diboy solsharo to, simpri ontongaw nin ja kowinta‐en to no on‐anay i kedsang ni too ton onsango. ");
INSERT INTO ibl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jet no kowinta‐en to ey eg mebedin na ebaken to sota sakey ya ari, mengibetkag ni mepangdo ja en mekitongtong, sakbay ya eg nayshogi nin i kobat. ");
INSERT INTO ibl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sajay i arig ni toon kowan to ey manbedin ni took. No ẃaray banag ja ẃa‐ẃa‐sha son si‐kato, ja aliẃen si‐kak i toka patki et ngo mowan, eg maykeshin took. ");
INSERT INTO ibl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Isonga iyay i ibanshaan ko son si‐kayo. Say asin, mapteng. Nem no ma‐enshi i pait ni asin, ja entamnay ma, eg maymowan. ");
INSERT INTO ibl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Enshiy to ka‐osalan: ngaaw wa para bo‐day tan eg maydaok shi abono. Kenshat ta may‐ibong. Niman i ẃaray ẃaya jon mengitneng niya banshaan ko. Isonga singpet jon itenengan.” ");
INSERT INTO ibl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Idi sakey ya timpo, eshakel iray dimaw alin para singil ni bowis, tan sota eshom iren inbiyang ni karakdan tep kowan sha ey managbasol; dimaw ira son Jesus ja en nanteneng ni kowan to. ");
INSERT INTO ibl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jet sota ira Parisiyo tan mamaistoro ni dinteg ni Hodiyos, inkotot sha si Jesus, ja kowan sha ey, “Sajay ya too, ineẃat to ira sota totoon eshakel i basol sha, tan ekipengan pay son si‐kara!” ");
INSERT INTO ibl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jet si Jesus, in‐arigan to ira, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kaspangarigan ey ẃaray nankalniro son si‐kayo ni sandasos, nem ma‐etiw i sakey, ngantoy pesing jo? Eg jo aya idekjas nin sota siyam ma polo tan siyam ja kalniro nodta pastolan et jo enapen sota sakey ya kalniron na‐atiw, ingkatod sepolen jo? ");
INSERT INTO ibl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jet no sepolen jo, sakbaten jon i‐akad et man‐imdeng kayo ma. ");
INSERT INTO ibl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jet no i‐akad jod baley jo, ta‐ẃalen jo ira sota kagajem jo tan inaskang jo, ja kowan jo ey, ‘Mandaladsak kito, ta simpol ko sota kalnirok ka na‐atiw!’ ");
INSERT INTO ibl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Say kowan ko son si‐kayo, inges niyay i pandadsak nonta anghil shi dangit no manbebawi i sakey ya toon eshakel i basol to, nem say sota siyam ma polo tan siyam ja maronong, ja eg mesepol la manbebawi. ");
INSERT INTO ibl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kaspangarigan mowan ey ẃaray bii ja ẃaray sampolon palata to jet ma‐etiw i sakey, ngantoy pesing to? Eg to aya enapen ja silẃan shima emin na shogo? Si‐si‐an to pay i baley to, jet singpeten toy anap ingkatod sepolen to. ");
INSERT INTO ibl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jet no simpol to, ta‐ẃalen to iray kagajem to tan inas‐askang to et ikowan to ey, ‘Mandaladsak kito, ta simpol ko sota palatak ja na‐atiw!’ ");
INSERT INTO ibl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inges niyay i pandadsak nonta ira anghil nen Apo Shiyos no manbebawi i sakey ya toon eshakel i basol to.” ");
INSERT INTO ibl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Si Jesus, intoloy to, ja kowan to ey, “Waray sakey ya too ja ẃaray showen dakin potot to. ");
INSERT INTO ibl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sota orishiyan, kowan to so nen amesha ey, ‘Tatang, al‐en ko sota tawid kon ibingay mo son si‐kak.’ Jet sota amesha, timolok, jet inpanbingay to sota tawid so nonta ira showen potot to. ");
INSERT INTO ibl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Idi edabas i pigen akew, sota orishiyan, indako to sota tawid to et dimaw shi araẃin ili. Nem sota pilak to, kinasto to ni kaloko‐an. ");
INSERT INTO ibl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Binolbol ton emin sota oltimon pilak to, ey onsabi i bitil nodtan na ili ja dinaẃan to. ");
INSERT INTO ibl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jet sinodngan ton en eki‐iyan shi sakey ya too nodtan na ili et inbetkag shen para pakan ni keshel. ");
INSERT INTO ibl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Singa piyan to ngon mekikan ira nodta keshel, ta enshiy emengi‐kan son si‐kato ni kenen to. ");
INSERT INTO ibl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jet idi anongosto ma, naynemneman sotan na balodaki jet kowan ton shorog shi bakdang to ey, ‘Si amak, eshakel i toka pandagbo‐in too et sobday shaka pankena. Nganto emoy naka ka‐eg‐ekangid jay! ");
INSERT INTO ibl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Agpos et ngo ey on‐oli‐ak shi kadnan nen amak et nak manpasinsiya son si‐kato. Ikowan ko ey nanbasolak son Apo Shiyos tan son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ikowan ko ey ekak maykeshin anak to; no diket angken ibilang towak ka sakey ya baga‐en to.’ Kowan tod nemnem to. ");
INSERT INTO ibl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jet siya, dima‐jat et on‐akad ma ja on‐oli son ameto. Nem idi nonta araẃi pay laeng nodta baley sha, inimatonan nen ameton shagos et naysemekan. Kinano‐an ton to inaspol et to inakdop et inongo‐an to pay. ");
INSERT INTO ibl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kowan nonta anak to ey, ‘Tatang, nanbasolak son Apo Shiyos tan son si‐kam. Ekak ma maykeshin anak mowak.’ ");
INSERT INTO ibl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nem say inpasing nonta ameto, kowan to so nonta baga‐en to ey, ‘Kano‐iyo, alejo di sota kamaptengan na baro et paibeshoyo! Singsingi jo pay, tan sapatosi jo! ");
INSERT INTO ibl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Daw kayo, jo di shonshon sota kilaw wa baken inpatebayo et paltiyo! Piyasta‐en tayoy inmotok ni anak ko! ");
INSERT INTO ibl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sajay ya anak ko, kowan ko nem etey, nem iyay gayam ma sibibiyag. Istay ya nan‐atiw, nem iyay ya nay‐oli di!’ Kowan nen ameto. Jet nayshogi may piyasta. ");
INSERT INTO ibl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nontan na oras, ẃara sota pangodowan shi payew. Jet idi imesop med baley sha ni in‐akad to, inteneng toy mosiko tan toon emandaladsak nodta naydaem ni baley. ");
INSERT INTO ibl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jet tineẃal to sota sakey ya baga‐en sha, ja kowan to ey, ‘Nganto ayay emankepasemak shi naydaem?’ ");
INSERT INTO ibl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kowan nonta baga‐en ey, ‘Mimotok ali sota agim! Jet si tatang jo, inpalti‐an to ni mateben baken kilaw, tep imoli alin sibibiyag.’ ");
INSERT INTO ibl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nem epaladoy bonget nonta pangodowan jet en‐asneng nga onsekep. Sota amesha, bimo‐day ali ja to inadok sota pangodowan ja onsekep ngon mekiladsak. ");
INSERT INTO ibl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nem sinongbatan to et si ameto, ja kowan to ey, ‘On‐im kari mango! Pigen tawen na nan‐ob‐obda‐ak ja singa baga‐en mo! Enshi pay i taka sinopngilan! Jet ngarantoy in‐akan mo son si‐kak? Angken komen kekanshing, say ẃara koma ngoy pandadadsakan mi ni kagajem ko, nem enshi met! ");
INSERT INTO ibl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nem satan na potot mo, inomas toy kameng mo shi dinedokon aramid, asan may‐oli di, jet niman, inpalti‐an mo mango ni mateben kilaw!’ ");
INSERT INTO ibl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jet kowan nonta amesha ey, ‘Anak ko, ẃara ka son si‐kak ni olay shiya baley jet emin na ẃara son si‐kak, singa kowinta ey kokowam. ");
INSERT INTO ibl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mesepol la dag‐en tayo iyay; pandadsak ka et, tep si agim, kowan ko nem etey, nem ẃara gayam ja sibibiyag. Istay nan‐atiw, nem imoli di.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Wara pay i inkowan nen Jesus, ja kowan to so nonta ira too to ey, “Waray toon baknang; engala ni sakey ya mengimanshal ni obda to, nem idi sakey ya akew, shinemag ton toka panngawngawa sota kokowa nonta baknang. ");
INSERT INTO ibl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Inpa‐odop to sota toon emengimanshal et inbag‐an to, ja kowan to ey, ‘Iyay i shamag ko pangkep son si‐kam. I‐odim alin emin sota inpiyal ko son si‐kam; a‐kalen taka med jay tep eg ka mepiyal.’ Kowan nonta baknang. ");
INSERT INTO ibl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Idi intenengan nonta toon emengimanshal, bimo‐day et kowan to so ni bakdang to ey, ‘Shanshanin a‐kalen towak nonta apok shiya obdak. Ngaranto emoy pesing ko nem bilang ey ma‐kalak, ta ekak met onposin man‐obda shi bo‐day, tan embaingak ja mankekekshaw? ");
INSERT INTO ibl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay, ẃara gayam i ninemnem kon pesing ko! No metongpal, eshakel ira sota kagajem ko et no ma‐kalak shiya obdak, odopen sha‐ak shi baley sha.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Say inpasing to, inpa‐odop to ira sota toon ẃaray otang sha so nen apo to et kowan to so nonta pilmiro ey, ‘Pigay otang mo son apok?’ ");
INSERT INTO ibl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kowan to ey, ‘Say otang ko son apom, sandasos sa dineten daneb.’ Kowan nonta emengimanshal ey, ‘Iyay i disibom. Nem tongaw ken shagos et sa‐datim ni dimen polo sota sandasos ja otang mo.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kowan to so nonta maykadẃa ey, ‘Si‐kam ngay, pigay otang mo?’ Kowan to ngo ey, ‘Sandasos ja kaban na bekas.’ Kowan nonta emengimanshal ey, ‘Iyay i disibom et sa‐datim ni ẃalon polon kaban.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sota emengimanshal la ma‐owap, in‐etek nonta apo to ni katekal to. “Sajay iren tood dobong ja eg emati son Apo Shiyos, edaing iren mengemag ni pamosposan nem say sota ira emati. ");
INSERT INTO ibl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Osal joy ẃaren kokowayo ja ontolong ira niya toon maligdigat niman na timpo et no ma‐bosan kayo, si Apo Shiyos i onsobadit son si‐kayo shi dangit. ");
INSERT INTO ibl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sota toon emepiyal shi ootik ka banag, mepiyal ngo shi ebadeg ga banag. Sota man‐olbod shi ootik ka banag, ekarkaron man‐olbod ngo shi ebadeg ga banag. ");
INSERT INTO ibl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","No eg kayo mepiyal la mengosal ni kokowa shiya dobong, eg ngo ipiyal nen Apo Shiyos son si‐kayo i podnon kokowa to ja eg mepokaw. ");
INSERT INTO ibl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No eg jo amten mengisingpet ni kokowa ni eshom ja naypiyal son si‐kayo, eg jo namnama‐en ey ẃaray eẃaten jon sobadit jod dangit ja medepo son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Say too, eg mebedin na showay pansilbi‐an to. No ensemek to sota sakey, okesen to sota maykadẃa; no ishayaw to sota sakey, bedawen to sota maykadẃa. Isonga eg kayo mebedin na mansilbi son Apo Shiyos no pilak i ẃa‐ẃa‐sha son si‐kayo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sota Parisiyo, epateg i pilak son si‐kara; isonga idi intenengan sha iyay ya inkowan nen Jesus, inbi‐ẃisan sha. ");
INSERT INTO ibl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Inkowan nen Jesus son si‐kara ey, “Si‐kayoy emengikokowan ey mapteng kayo et say i‐etek shakayo ni totoo. Nem si Apo Shiyos, amta toy ẃared nemnem jo, jet sota toon mengiredjaw ni bakdang to shorog, en‐oges nen Apo Shiyos ja ishemshemang. ");
INSERT INTO ibl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sota bilin na insolat nen Moises, tan sota insolat ni para padto nonta bayag da, makedsang ingkato nonta timpo nen Juan ja para bonjag, jet niman men kawashak, say emaytosho, sota maypangkep ni pantoshayan nen Apo Shiyos, jet eshakel i masi‐met ta on‐awat so. ");
INSERT INTO ibl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nem enshiy mepokaw wa bilin nen Moises. No ẃara pay laeng iya dangit tan dobong, eg mepokaw i angken sakey ya naysolat ta bilin nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Say sakey ya bilin nen Moises ja eg mebedin na mebediwan, kowan to ey say dakin mengisi‐jan ni aseẃa to, ja meki‐esawa mowan, bimasol ja inges to sota emii. Inges to ngo met laeng, no sipa ngoy mengesawa nonta biin insi‐jan sha, bimasol ja inges to sota emii. ");
INSERT INTO ibl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Waray toon baknang; ebanol i baro to, tan en‐amis i sira to ni inakew. ");
INSERT INTO ibl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wara ngoy toon ebiteg ja ebayabayang i bakdang to ja nanngaran ni Lazaro. Emantetongaw ni olay iya ebiteg nodta sakepan nonta baknang, ja mengshaw. ");
INSERT INTO ibl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Piyan to komen angken sota mogay mango koma ja ma‐kas shi damisaan nonta baknang, si‐katoy kenen to. Jet sota ira aso, shaka jepojepoti sota bayang to. ");
INSERT INTO ibl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Enshiy ebayag, etey iya ebiteg et indaw ira nonta anghil shi dangit ja kawad‐an nen Abraham. Etey ngo iyay ya baknang et inbekara. ");
INSERT INTO ibl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dimaw shima kalikatan ja kowan sha ey Hadis. Idi ontangkak, inon‐an tos Abraham shi araẃin dogad, jet ẃara ngo si Lazaro. ");
INSERT INTO ibl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jet kimeljaw, ja kowan to ey, ‘Ama Abraham! Kaasi‐imak, ibetkag mo di si Lazaro. I‐eneng to diy angken sakey ya kalomot tod shanom, ta emag‐anan i shilak ka pasiya! Naka mandikat ta pasiya shiya apoy!’ ");
INSERT INTO ibl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nem kowan nen Abraham ey, ‘Anak ko, nemnem mo kari iyay. Nonta ẃara ked biyag, ẃara son si‐kam ma emin nontan i mesepol mo et kinenkenas mo. Nem si Lazaro nontan, enshin polos i mebedin to, jet kakaasin pasiya. Nem niman ngo, iyay shiya mapteng nga dogad ja emannam‐ay, jet si‐kam ngoy emandikat. ");
INSERT INTO ibl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tan sakey pay, iyay i naydeshek tan embanaw wa ejaokan; isonga eg mebedin na onbaliw kayo did jay, tan angken si‐kami ngo, eg mebedin na ondaw kamid tan.’ Kowan nen Abraham. ");
INSERT INTO ibl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jet kowan nonta baknang ey, ‘Ama Abraham, kekshawen ko ngarod son si‐kam ey ibetkag mo ga si Lazaro shi baley nen amak. ");
INSERT INTO ibl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta ẃaray agik ka dima et to ira banshaanan, say eg sha ngo peshasan iya digat shiya kawad‐an ko niman.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nem kowan nen Abraham ey, ‘Sota a‐akim, ẃara sota bilin nen Moises ja emankaitoro son si‐kara, tan ẃara ira sota esel ni para padto. Sotan i onbanshaan son si‐kara.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kowan mowan nonta baknang ey, ‘Eg on‐anay, Ama Abraham! Nem no ẃaray manpeẃil la etey et ondaw son si‐kara, mepnek ma ira ja manbebawi.’ ");
INSERT INTO ibl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nem kowan mowan nen Abraham ey, ‘No eg sha pati‐en sota bilin nen Moises, tan sota ira esel ni para padto, angken ẃaray manpeẃil la etey, eg sha met laeng pati‐en.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kowan nen Jesus so nonta too to ey, “Waren kenshat i onsabin panbesolan ni too, nem kakaasi sota toon mengi‐kan ni panbesolan ni kait to. ");
INSERT INTO ibl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Say pansigshan nontan na too ket, ma‐ono‐an koma ni ebadeg ga bato et en mayteb‐ok shima baybay. Pansigshan to ta engka‐jas sotan na keshosa to nem say sota penosa nen Apo Shiyos son si‐kato ja pengikesho to nontan na basol to, no istay engi‐kan koma ni nanbasolan ira niya nankebaben emati son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Isonga tanshaaniyon shorog i bakdang jo. “No sota kait mo ket, nanbasol son si‐kam, bilin mo jet no itenengan toka ja manbebawi, pasinsiya‐im. ");
INSERT INTO ibl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ket no manbesol son si‐kam ni meminpito ni san‐akew et sinshon manbesol son si‐kam, ondaw alin en manpasinsiya ni meminpito, ja kowan to ey manbebawi ni ngaaw wa dingka to, mesepol la pasinsiya‐an mo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Idi sakey ya akew, kowan nonta ira apostol to ey, “Paba‐deg moy pamati mi.” ");
INSERT INTO ibl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Simongbat si Apo Jesus ja kowan to ey, “No say kaba‐deg ni pamatiyo ket may‐eshig shi botil la ootilek, mebedin na ibetkag jo sota ebadeg ga kiyew ey, ‘Kagabot ka et kaymola ken shorog shima baybay!’, jet may‐agpayso ja pati‐en toy kowan jo. ");
INSERT INTO ibl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kaspangarigan ey ẃaray baga‐en ja inpangesharo ni apo to, ono inpanbantay to ni kalniro, ja imakad alin edapod obda to, aliẃen ogadi tayo ey si‐katoy mepangdon mengan nem say apo to. ");
INSERT INTO ibl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nem say ikowan jo son si‐kato, ‘Ikamakamimak ni kenen ko tan inomen ko asan ka ngo mangan.’ ");
INSERT INTO ibl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jet sota baga‐en, eg mesepol la pan‐iyamanan mo i obden kinsheng to, ta si‐katoy obda to. ");
INSERT INTO ibl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Inges to ngo son si‐kayo. No kinsheng jon emin i kowan nen Apo Shiyos ey dag‐en jo, eg jo koma nemnemen ey ẃaray otang nen Apo Shiyos son si‐kayo, no diket say ikowan jo koma, ‘Baga‐en mokami bengat, Apo Shiyos. Saja dingka mi bengat, sota inkowan mo, enshiy eshom.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Idi emandaw si Jesus shi Jerusalem, nanshalan shi nankinaw‐an ni Samaria tan Galilia. ");
INSERT INTO ibl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nodtan na minotok ton dogad, ẃaray sampolon too ja ebayabayang i bakdang sha. Sha inaspol si Jesus, nem naybetaw ira. ");
INSERT INTO ibl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Isonga kimeljaw ira ja kowan sha ey, “Jesus! Apo! Kaasi jokami!” ");
INSERT INTO ibl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Inon‐an nen Jesus ira et kowan to ey, “Daw kayo, jo pa‐sas i bakdang jo so nonta pari.” Jet nonta ẃara pay laeng ired shalan ja ireka emandaw shi kad‐an ni pari, na‐omas ma sota bayang sha. ");
INSERT INTO ibl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jet sota sakey son si‐kara, idi inon‐an ton mimapteng ma, nay‐oli din epaladoy dadsak to son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dimaw ja en nantalimokod shi sango‐an nen Jesus ni iyaman to. Sajay ya too ket, i‐Samaria. ");
INSERT INTO ibl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Si Jesus, kowan to ey, “Aliẃa ayen sampolo kayon mimapteng? Towa da ira sota siyam? ");
INSERT INTO ibl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apay eg mebedin ngo aya ja on‐oli ira di ja en man‐iyaman son Apo Shiyos? Saja aliẃa et ngo mowan na kait tayon Hodiyos, si‐kato bengat i nay‐oli di.” ");
INSERT INTO ibl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jet say kowan nen Jesus son si‐kato, “Dayat ka et angken ondaw ka. Sota pamatim, si‐katoy minaptengan mo.” ");
INSERT INTO ibl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sota ira Parisiyo, inbag‐an shes Jesus nem pigan aliy panshoki ni pantoshayan nen Apo Shiyos. Nem say insongbat nen Jesus son si‐kara, kowan to ey, “Aliẃen en ondaw alin ẃaray amta‐an jo so. ");
INSERT INTO ibl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Enshiy en mengikowan ey ‘Asas mo! Iyay shiyay i pantoshayan nen Apo Shiyos!’ Tan enshiy en mengikowan ey ‘Imed man!’ Ta ẃara son si‐kayo niman.” ");
INSERT INTO ibl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kowan nen Jesus so nonta ira too to ey, “Waray timpon onsabi ali ja pandikat jo, jet piyan jon asen i angken san‐akew wa pantoshay ko di. Nem eg mebedin. ");
INSERT INTO ibl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wara iray toon mengikowan son si‐kayo ey, ‘Wares Cristo! Jo on‐id man!’ Ono ikowan sha ey, ‘Iyed jay!’ Nem karejo patpati‐en. ");
INSERT INTO ibl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta say itsora ni idaw ali mowan nonta kowan ni para padto ey Anak ni Too, ja mantoshay, inges toy bagidat ja silẃan ton shagos i emin na naykayang. ");
INSERT INTO ibl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nem say pilmiro, mesepol la mandikatak nin ja pasiya, ta sota toon sina‐kop kod ja dobong niman, eg sha‐ak pati‐en; ikowan sha et ey enshiy kenkenshat ko. ");
INSERT INTO ibl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Say arig ni timpon idaw mowan ali nonta naypadton Anak ni Too, inges toy timpo nen Noe. Ta sota aramid ni totoo nontan den timpo to, inges to met laeng i aramid ali ni totoo ni idaw ko mowan ali, jet inges to mowan i idibag ni totoo. ");
INSERT INTO ibl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta nonta aneng pay laeng sota dayos, enshiy shaka panshanagi ni inakew: ireka mengan, ireka menginom, ireka man‐a‐asawa — ingkato nonta simabi sota timpon simekep si Noe nodta barko to. Jet idi simabi ma sota dayos, etey iren emin. ");
INSERT INTO ibl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Arig to pay sota totood Sodoma nonta timpo nen Lot. Esiwat ira nontan da ni pangan sha tan inom sha; esiwat ira ni tongkal sha tan dako sha; esiwat ira ni mola tan amag ni baley. ");
INSERT INTO ibl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nem nontan na akew ja indekjas nen Lot i Sodoma, imoran alid naykayang ni apoy tan asopri jet binono ton emin ira sota totood man. ");
INSERT INTO ibl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Inges niyay met laeng aliy imotok nonta Anak ni Too ja palibdibag. ");
INSERT INTO ibl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“No onsabi sotan alin akew, sota toon naytompong nga man‐adibay shi bo‐dayan, eg to koma nemnemen sota kokowa ton ẃared naydaem ni baley; eg koma onsekep ja en mengeda ni kompormin ẃara nodta naydaem ni baley to. Kasta met sota ẃared payew, eg to koma nemnemen ja on‐oli nin shi baley to. ");
INSERT INTO ibl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nemnem jo kari sota epasemak so nonta aseẃa nen Lot nonta ẃiningi to bengat sota ili ton Sodoma ja shaka pan‐idekjas. ");
INSERT INTO ibl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sota toon entapi toy biyag to ja kowan to ey ensikshal la metey, si‐kato et ngo mowan i mepokaw i biyag to. Nem sota toon itolok toy bakdang ton metey, odi‐en to met laeng sotan na biyag to ingkatod ingka. ");
INSERT INTO ibl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ikowan ko iyay son si‐kayo. No sotan alin akew, odopen koy eshom ma too, nem sota eshom, bay‐an ko. Jet no kaspangarigan ey kalebi‐an, ket sota showen too i naytompong nga nan‐arol shi sakey ya katiri, sota sakey, may‐odop son si‐kak, nem sota sakey, mebay‐an. ");
INSERT INTO ibl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Angken ngon sota showen biin maytompong nga emengiding, sota sakey, may‐odop son si‐kak, nem sota sakey, mebay‐an. ");
INSERT INTO ibl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sota showa ngon daki ja maytompong nga ẃared payew, sota sakey, may‐odop son si‐kak, nem sota sakey, mebay‐an.” ");
INSERT INTO ibl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sota ira too to, inbaga sha ey, “Towen dogad Apo?” Jet simongbat si Jesus ja kowan to ey, “No toway kad‐an ni bangkay ni etey, si‐kato ngoy kesa‐nopan ira ni kaẃang.” ");
INSERT INTO ibl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Si Jesus, ẃaray inkowan ton arig son si‐kara say eg ira medismayen mansheẃat son Apo Shiyos, no diket mansheẃat ira son si‐kato ni olay. Iyay sotan na arig: ");
INSERT INTO ibl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Wara konoy kowis shi sakey ya ili ja endedamsis tos Apo Shiyos, tan kasta met sota kaikowan ni kait ton too. ");
INSERT INTO ibl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jet ẃara ngoy ebalon bii nodtan na ili, ja kanayon na kaondaw son si‐kato ja mengshaw ni kaasi, ja kowan to ey, ‘Apo, ibediwimak ka ta iman i kowan to ey memidiw ni kokowak.’ ");
INSERT INTO ibl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nem ebayag malen timpo, eg sinintil niyay ya kowis i shawat nonta biin ebalo. Nem idi emasig sota bii ni shawat to ni tolong, kowan nonta kowis shorog so ni bakdang to ey, ‘Angken bilang ey endedamsis kos Apo Shiyos tan totoo, ");
INSERT INTO ibl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ibaliẃan kos iyay say ibi‐jag ton ondaw ali ni olay, say eg towak ma notengen.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jet si Apo Jesus, intoloy to ey, “Nemnem jo iyay ya inpasing niyay ya kowis. Enshiy kaasi to, nem ibaliẃan to ja biin emasig ni shawat to ni kaasi. ");
INSERT INTO ibl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jet si Apo Shiyos, mas pay todongan toy too ton memasig ja mengshaw son si‐kato ni inakew tan dinadabi. Say kowan jo emo, eg to itenengan shagos aya i shawat jo? ");
INSERT INTO ibl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Say kowan ko son si‐kayo, si Apo Shiyos, aliston mengibediw so ni too to; isonga eg kayo koma medisdismaya. Enshiy showashowa maypangkep son Apo Shiyos, nem si‐kayo mangon too, piga emoy memati pay laeng son si‐kak ingkatod i‐olik mowan ali?” ");
INSERT INTO ibl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","In‐arigan nen Jesus ira sota toon kowan sha ey si‐kara i sigoradon mapteng mangoy aramid sha, jet kowan sha ey sota eshom, ayshi konoy kenkenshat sha. Jet kowan nen Jesus ey, ");
INSERT INTO ibl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Waray showen too ja nan‐inshas ja dimaw shi Timplo ja mansheẃat son Apo Shiyos. Sota sakey, Parisiyo; sota sakey, para singil ni bowis. ");
INSERT INTO ibl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Dimayat sota Parisiyo jet kowan to shorog shi bakdang to ni shawat to ey, ‘Salamat Apo Shiyos, tep aliẃen inges ko iya para singil ni bowis ja enshiy kenkenshat to. Salamat tep aliẃen mapidiwak, aliẃen malokdoko‐ak, aliẃen mabii‐ak, ja inges toy aramid ni eshom. ");
INSERT INTO ibl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naka ngidinay meminshowa ni makadomingko ja naka ibiyang i pengan, tan emin na naka epita, naka idaton pay i ikasampolo son si‐kam.’ Kowan nonta Parisiyo ni shawat to. ");
INSERT INTO ibl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nem sota para singil ni bowis, dimayat shi naybetaw, ja embaing pay ya ontangkak shi dangit. Toka pay panpagpaga i pagew to ni toka panbebawi, jet kowan to ni shawat to ey, ‘Apo Shiyos, kaasi‐imak ta eshakel i basol ko.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jet intoloy nen Jesus ey, “Ikowan ko son si‐kayo, sajay ya para singil ni bowis, si‐katoy kinosto‐an nen Apo Shiyos asan ka‐akad shi baley to; nem sota Parisiyo, eg to kinosto‐an. Sota toon mengingeto ni bakdang to shorog, si‐kato et ngo mowan i maybeba; jet sota toon toka ibaba shorog i bakdang to, si‐katoy mayshedjaw.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sota eshom iren too, indaw shay angken nga‐nga son Jesus, ta kowan sha ey say pishaten ton bindisiyonan ira. Nem idi inon‐an ira nonta too nen Jesus iyay, inseg‐ang sha ira sota engidaw ali nonta a‐anak. ");
INSERT INTO ibl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nem si Jesus, tina‐ẃal to sota ira a‐anak ja ondaw ali son si‐kato jet kowan to so nonta ira too to ey, “Baybay‐iyo ira di sota a‐anak ja ondaw ali son si‐kak; eg jo iparit. Tep inges iren jay ya a‐anak bengat ja ekombaba i mayda‐kam shi pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Podno iya ikowan ko son si‐kayo. No eg kayo mengeẃat ni pantoshayan nen Apo Shiyos ja inges toy kepengeẃat ni a‐anak, eg kayo mayda‐kam ja onsekep shi pantoshayan nen Apo Shiyos.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Waray pangolo ni Hodiyos; inbag‐an tos Jesus ja kowan to ey, “Maistoro, mapteng ken too. Ikowan mo ga no ngarantoy dag‐en ko say meẃad‐anak ni biyag ja enshiy to engintegan.” ");
INSERT INTO ibl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Simongbat si Jesus ja kowan to ey, “Ngantoy mosoka ikowani so ey maptengak? Abos nen Apo Shiyos ja mapteng. ");
INSERT INTO ibl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nem no maypangkep nonta biyag ja enshiy to engintegan ja inkowan mo, amtam sota ira bilin nen Apo Shiyos: ‘kareka memii ono mekileki, kareka memono, kareka mengibot, aliẃen mo ba‐ngaten ja man‐a‐sel ni aliẃen kosto; tan shayaw mos inam tan si amam.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kowan nonta too ey, “Nontan pay laeng nga‐nga‐ak ingkato niman, inonod kon emin itan na bilin nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Idi intenengan nen Jesus iyay, kowan to ey, “Wara pay laeng i sakey ya kolang mo. Ilekom ira sota kokowam et sota dako to, iweshis mo so nonta ira nankebiteg. No sajay i pesing mo, say kawad‐an ni kabaknang mo ma, naytalo shi dangit. Jet no meksheng nga sotan i pesing mo, kay‐eshom ka di so ira niya took!” ");
INSERT INTO ibl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nem idi intenengan nonta too iyay ya inkowan nen Jesus, ensakit ta pasiya i nemnem to, tep toka tepi‐a i kabaknang ton pasiya. ");
INSERT INTO ibl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inningning nen Jesus iyay ya too et kowan to ey, “Edigat ja onsekep i baknang shi pantoshayan nen Apo Shiyos! ");
INSERT INTO ibl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sota animal ja kowan sha ey camel, no kas‐anoy kalikat to ja on‐osok shi ebot ni shakom, mas edigdigat pay ya onsekep i babaknang shi pantoshayan nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sota totoon engitneng niyay ya kowan nen Jesus, kowan sha ey, “No kasta, enshi ngarod i maysedakan?” ");
INSERT INTO ibl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nem simongbat si Jesus ja kowan to ey, “Agpayson eg kabaalan ni toon mengisedakan ni bakdang to shorog, nem sota eg mebedinan ni toon dag‐en, mebedin na dag‐en nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kowan nen Pedro ey, “Karam ngo dibdibkan ey si‐kami, indekjas min emin i kokowa mi nonta nanbalinan min toom.” ");
INSERT INTO ibl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jet si Jesus, kowan to son si‐kara ey, “Podno iya ikowan ko son si‐kayo. No sipay engilekjas ni baley to, aseẃa to, a‐aki to, annak to, ono sota maka‐anak son si‐kato, maypangkep ni pantoshayan nen Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ebadbadeg ga pasiyay eẃaten to niman na kawasha tod ja dobong, tan no man‐onod alin akew, kon‐oren to pay i biyag ja enshiy to engintegan.” ");
INSERT INTO ibl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Inpata‐nil nen Jesus ira sota sampolo tan showa ja apostol to et a‐abos sha ma. Jet kowan to son si‐kara ey, “Itnengi jo iya ikowan ko son si‐kayo. Ondaw kito shi Jerusalem et emin sota insolat ira nonta para padto nen Apo Shiyos nonta bayag da maypangkep nonta kowan sha ey Anak ni Too, metongpal son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tep may‐eẃatak so nonta ira aliẃen kait tayon Hodiyos. Sengsengkiten sha‐ak, bebaingan sha‐ak, toptopsha‐an sha‐ak. ");
INSERT INTO ibl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sepsepdaten sha‐ak pay, asan sha‐ak bono‐a. Nem no maykatdon akew, manbiyagak mowan.” ");
INSERT INTO ibl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nem sota ira too to, eg sha ineẃatan iyay, ta nay‐emot i olog nontan na inkowan nen Jesus son si‐kara. Eg sha amta nem ngantoy olog nonta inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Idi nay‐esop ma si Jesus shi Jiriko, ẃara ngoy toon ekorab ja timongaw nodta naykilig ni kalsara, ja emankekkekshaw. ");
INSERT INTO ibl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Idi intenengan ton ẃaray eshakel la toon eman‐ekad shi kalsara, inbaga to, ja kowan to ey, “Ngaran ira niyay?” ");
INSERT INTO ibl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kowan sha son si‐kato ey, “Si Jesus ja i‐Nasarit, ondabas alid jay.” ");
INSERT INTO ibl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Idi intenengan to iyay, kimeljaw ja kowan to ey, “Jesus! Kaasimak, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sota toon epangdo ey si Jesus, inseg‐ang sha sota ekorab, ja kowan sha son si‐kato ey on‐eket. Nem mina‐ma to et ja inkedsang toy keljaw to, ja kowan to mowan ey, “Kaasi‐imak, si‐kam ma mengibengon son Ari David nonta bayag da!” ");
INSERT INTO ibl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kimi‐neng si Jesus et kowan to ey, “Shawat jo did jay.” Jet idi nay‐esop ma sota ekorab, inbag‐an to, ");
INSERT INTO ibl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngarantoy piyan mon itolong ko son si‐kam?” Kowan nonta ekorab ey, “Apo, pan‐asas mowak, say man‐esasak mowan.” ");
INSERT INTO ibl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kowan nen Jesus son si‐kato ey, “Mebedin na man‐esas ka ma. Sota pamatim son si‐kak, si‐katoy kabol la pan‐esasan mo.” ");
INSERT INTO ibl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jet nontan, nan‐asas shagos, jet nay‐eshom ma son Jesus. Jet idi inon‐an ira nonta eshakel la totoo, inshayaw sha ngos Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nanshalan shi Jesus shi Jiriko. ");
INSERT INTO ibl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Waray baknang nodtan na siyodad ja apo ira nonta para singil ni bowis; say ngaran to, si Sakio. ");
INSERT INTO ibl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Piyan ton asen nem sipa si Jesus, nem sina‐dinan ira nonta eshakel la totoo, ta si Sakio, entikey ya too. ");
INSERT INTO ibl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Isonga say inpasing to, nanbetik ja epangdo nodta shalan ey say sota ira totoo, jet kimalab shi kiyew wa kowan sha ey sycamore, say asen tos Jesus nem manshedan ali nodtan. ");
INSERT INTO ibl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Idi pintek nen Jesus sota kadnan nen Sakio, tinangkak to jet kowan to ey, “Sakio, kano‐im, japas ka di! Ta mesepol la ondawak shi baley mo, taka bisita‐en niman.” ");
INSERT INTO ibl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kinano‐an nen Sakio ja jimapas et eman‐imdeng nga engolop son Jesus shi baley to. ");
INSERT INTO ibl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nem emin ira sota toon engasas son Jesus ni indaw tod baley nen Sakio, ireka onẃanadegẃeg ja kowan sha ey, “Ngantoy daẃan tod man aya? Dimaw wa en memisita nima toon enshiy kenkenshat to!” ");
INSERT INTO ibl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nem say kowan nen Sakio son Jesus, kowan to ey, “Apo, ninemnem koy pesing ko niman! I‐akan koy kagashowa ni kokowak shi nankebiteg, tan no sipa ira sota inda‐karan ko ni singil ni bowis, bayshan ko ira ni memin‐epat.” ");
INSERT INTO ibl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kowan nen Jesus so nen Sakio ey, “Say kaysedakan, simabi niman shiyay ya pamilja, ta saja inpasing mo, si‐katoy ka‐asan to ey si‐kam ket agpayson anak shaka nen Abraham. ");
INSERT INTO ibl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Si‐kak sota kowan ni para padto nonta bayag da ey Anak ni Too, jet say kabol la inbetkagan towak so nen Apo Shiyos, say mengeẃisak nonta ira toon emantoshong shi keshosa‐an sha say maysedakan ngo ira.” ");
INSERT INTO ibl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nonta ẃares Jesus shi Jiriko ja nay‐esop shi Jerusalem, kowan ira nonta karakdan na totoon emengitneng son si‐kato ey no onmotok si Jesus shi Jerusalem, mayshoki ma sota pantoshayan nen Apo Shiyos. Nem say kowan to son si‐kara, eg nin metongpal sota namnama sha. In‐arigan to ira, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Waray baknang; ninemnem to ey ondaw shi araẃin ili, ja shiman i eẃatan to so ni kina‐ari to, asan ka‐oli din on‐akad, ja si‐kato may mantoshay. ");
INSERT INTO ibl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Idi shanshanin ondaw, inpa‐odop to ira sota sampolon baga‐en to ja pinispis to, jet inẃarisan to ira ni sandedasos sa pilak ja ibiyakira ingkatod on‐oli ali. ");
INSERT INTO ibl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nem sota ira totoo nodtan na dogad ja edapo‐an to, eg sha koston si‐katoy mengitoshay koma son si‐kara; isonga engibetkag ira ni en manriri nodta kowan to ey daẃan to ja eẃatan to so ni kina‐ari to, ja kowan sha ey, ‘Eg mi koston si‐katoy mengitoshay son si‐kami.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nem inpan‐ari sha met laeng. Nay‐olin imakad jet idi mimotok, inpa‐odop ton shagos sota baga‐en ton inẃarisan to ni pilak, say asen to nem pigay kinanansiya shen inbiyaki‐an. ");
INSERT INTO ibl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sota pilmiro, dimaw alin nanparang et kowan to ey, ‘Apo, sota sandasos sa inpiyal mo son si‐kak, nanbalin ni sandibo.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kowan nonta ari ey, ‘Siya, mapteng i dingkam; mapteng ken baga‐en ko. Kaka mepiyal la mengimanshal ni otik ka banag, isonga niman, panbedin taken mengitoshay ni sampolon siyodad.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sota maykadẃen baga‐en to, dimaw ngo alin nanparang et kowan to ey, ‘Apo, sota inpiyal mo son si‐kak ka sandasos, nanbalin ni dimen dasos.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kowan nonta ari ey, ‘Manbedin ka ngon mengitoshay ni dimen siyodad.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nem sota sakey, nanparang ngo ali, jet kowan to ey, ‘Apo, iyay sota sandasos sa inpiyal mo son si‐kak. Dinibotan ko ni panjo et insingpet kon intalok. ");
INSERT INTO ibl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Entakotak son si‐kam tep palado ken too. Moka pan‐al‐a pay i aliẃen kokowam, tan angken sota aliẃen molam, moka pan‐epita.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kowan nonta ari ni songbat to ey, ‘Si‐kam, eg ka mepiyal la baga‐en ko! Sota inkowan mo, si‐katoy kaybetayan ni keshosam! Amtam gayam ey palado‐ak ka too, amtam ey naka pan‐epitay angken aliẃen molak, amtam ey naka pan‐al‐ay aliẃen kokowak. ");
INSERT INTO ibl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Apay ngarod nga intalom i pilak ko? Angken koma, no inbebangkom, say niman alin inmotok ko, ẃaray eẃaten kon patang to!’ ");
INSERT INTO ibl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jet kowan nonta ari so nonta ira too ton ẃara nodtan ey, ‘Alejo ima pilak ka ẃara son si‐kato et i‐kan jo so nima baga‐en kon sandiboy insapolan to!’ ");
INSERT INTO ibl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nem kowan sha ey, ‘Apo, ẃara met i sandibon pilak son si‐kato.’ ");
INSERT INTO ibl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kowan nonta ari ey, ‘Ikowan ko son si‐kayo, sota ira ẃa‐ẃa‐sha‐anan, may‐aknan pay. Nem sota ootik‐anan, angken sota oltimon ẃara son si‐kato, ma‐da pay. ");
INSERT INTO ibl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jet niman, shosa‐en ko ngo sota totoon simopngil son si‐kak ja kowan sha ey eg sha koston si‐kak i ari sha. Alejo did jay ira et bono jo ira! Asen koy kebonora.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sajay i arig ga inkowan nen Jesus son si‐kara, asan ka‐edaw shi Jerusalem, ja epangdo ey say si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Idi nay‐esop ma shi Jesus shima dogad ja kowan sha ey Bitpag tan Bitania, ja osshong ni shontog ga kowan sha ey Olibas, engibetkag ni showen too ton mepangdo. ");
INSERT INTO ibl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jet say inbilin to son si‐kara, kowan to ey, “Daw kayod ma dogad ja naysongbob et no onmotok kayo, ẃaray asen jon kilaw ni animal la donkey, ja naypagod. Sajay ya kilaw, eg pay laeng ekabkabajo‐an. Okasiyo et alejo did jay. ");
INSERT INTO ibl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No ẃaray mengibeka son si‐kayo no ngantoy joka pan‐okasi so, ikowan jo ey, ‘Si Apo Jesus, mesepol to.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jet siya, dimaw ira sota shadẃa et simbira sota donkey ja inkowan nen Jesus son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Idi shaka pan‐okasi sota kilaw, kowan ira nonta makakokowa ey, “Ngantoy joka pan‐okasi so nita kilaw?” ");
INSERT INTO ibl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kowan sha ey, “Si Apo Jesus, mesepol to.” ");
INSERT INTO ibl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jet indara sota kilaw et indaw sha son Jesus. Jet sota ta‐kep ni baro sha, in‐ap‐ap sha nodta beneg ni kilaw et inatngan shes Jesus sa mankebayo. ");
INSERT INTO ibl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dima‐jat si Jesus et sota ira totoo, in‐ap‐ap sha ngoy baro sha nodta kalsaren panshalnan ali nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Idi nay‐esop ma si Jesus shi Jerusalem, nodta kalsaren onshalong shi shontog ga kowan sha ey Olibas, sota ira eshakel la too to, ireka man‐imdeng nga pasiya, jet nan‐iyaman ira son Apo Shiyos maypangkep nonta kaskasshaaw wa milagron dingdingka nen Jesus ja inon‐an sha. Inkedsang shay keljaw sha, ");
INSERT INTO ibl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ja kowan sha ey, “Bindisiyonan koma nen Apo Shiyos iya arin inbetkag to di. Si‐katoy en ali mengi‐kan ni talna ja edapo son Apo Shiyos! Shayaw son Apo Shiyos ja Kangeto‐an!” ");
INSERT INTO ibl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nem sota ira eshom ma Parisiyo ja naydaok nodta eshakel la totoo, kowan sha son Jesus ey, “Maistoro, selkag mo ira ta toom! Angsan i shayaw sha!” ");
INSERT INTO ibl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Simongbat si Jesus ja kowan to ey, “Mesepol la ẃaray manshedjaw niman. No on‐eket ira ja too, maysa‐dat i baton onkeljaw ja manshedjaw!” ");
INSERT INTO ibl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nay‐esop ma shi Jerusalem si Jesus jet idi osshongan to, innangis toy toka pengisekit so ni totood man, ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Si‐kayon tood Jerusalem, amtayo komay kasapolan jo say may‐aknan kayo ni talna! Nem ayshi met, eg mebedin na amta‐an jo! ");
INSERT INTO ibl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wara aliy timpon pandikat jo. Sota ira kabakal jo, diktoben shakejo ni mebedjag jet enshiy delsotan jo. ");
INSERT INTO ibl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sheshalen shen oltimoy siyodad jon Jerusalem, tan angken si‐kayo ngon too ja ẃared jay. Angken sakey ya bato, eg sha bay‐an na on‐onong shi sigod ja nay‐amagan to. Emin iyay, mepesamak son si‐kayo tep eg jo indasin iya timpon kowan nen Apo Shiyos ja kaysedakan jo!” ");
INSERT INTO ibl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Idi mimotok ma si Jesus, simekep shi Timplo et shinagshag ton inpabo‐day ira sota emandeko nodtan. ");
INSERT INTO ibl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kowan to son si‐kara ey, “Say kowan ni esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey sajay ya baley nen Apo Shiyos, pankekshawan ni totoo son si‐kato. Nem inpanbalin jo et ni singa amotan ni tolisan!” ");
INSERT INTO ibl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Si Jesus, nantoro ni inakew shi Timplo. Nem sota ira apo ni papashi, mamaistoro ni dinteg ni Hodiyos, tan sota eshom iren pangolo ni Hodiyos, piyan shen pasiya ja bono‐en si Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nem enshiy shaka nemnemen pesing sha, tep eshakel i totoon na‐awis, ja pipiyan shen mantetneng ni emin na ikowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Idi sakey ya akew, si Jesus, emantosho shi Timplo, tan emengikowan ni mapteng nga shamag ja toka itodtoro ni olay so nonta ira totoo. Jet nontan, sota apo ni papashi, mamaistoro ni dinteg ni Hodiyos, tan sota ira eshom ma pangolo ni Hodiyos, dimaw ngo ira di. ");
INSERT INTO ibl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jet kowan sha son Jesus ey, “Sipay engikowan ey dag‐en mo ira ta moka dagdag‐a shiya Jerusalem? Sipay engibetkag son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Simongbat si Jesus ja kowan to ey, “Ibag‐an takejo ngo nin. Ikowan jo son si‐kak nem sipay engibetkag so nen Juan ja en memonjag nontan — nemnem to ngo shorog, ono si Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nem sota ira pangolo ni Hodiyos, nantatabtabal ira ja kowan sha ey, “No ikowan tayo ey si Apo Shiyos, mesampolo kito tep ikowan to ey, ‘No kasta, apay nga eg jo ngarod pinati si Juan?’ ");
INSERT INTO ibl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nem no isongbat tayo ey nemnem ngo nen Juan, saja ira eshakel la too, batoy pemonora son si‐katejo, ta shaka pati‐a ey si Juan, podnon inbetkag ali nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jet say songbat sha so nen Jesus, kowan sha ey, “Taẃey, eg mi amta no sipay engibetkag so nen Juan ja emonjag.” ");
INSERT INTO ibl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jet kowan ngo ma nen Jesus son si‐kara ey, “Angken ngon si‐kak, ekak ikowan son si‐kayo no sipay engibetkag son si‐kak ja mandeka niya naka dagdag‐a niman.” ");
INSERT INTO ibl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Si Jesus, in‐arigan to sota ira totoo, ja kowan to ey, “Waray toon nanmola ni obas shi embanaw wa gardin to. Inpa‐ajowan to so ni eshom et dimaw ma shi araẃin ili. ");
INSERT INTO ibl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Idi simabi sota timpon pekibingay to nonta obas, engibetkag ni baga‐en ton en mengeda nonta bingay to so nonta ira engajowan. Nem sota engajowan, sinepsepdat sha sota baga‐en na inbetkag nonta makakokowa, tan inpa‐odiren enshiy sha in‐akan. ");
INSERT INTO ibl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sota makabo‐day, engibetkag mowan ni eshom ma baga‐en to, nem inges to met laeng nga sinepsepdat nonta engajowan nonta gardin, tan binebaingan sha pay. Inpa‐odiren enshiy sha in‐akan. ");
INSERT INTO ibl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Engibetkag sota makabo‐day ni baga‐en to nonta maykepintedo, nem iso met laeng nga sinokat sha, asan shaka shagshaga. ");
INSERT INTO ibl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Anongosto ma ey sota makabo‐day, kowan to ey, ‘Ngarantoy pesing ko aya? Ensemek ko iya anak ko, nem ibetkag ko ga, tep mebedin emon ibaingan sha.’ ");
INSERT INTO ibl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nem idi inon‐an ira nonta engajowan sota mismon anak nonta makabo‐day, nantatabtabal ira ja kowan sha ey, ‘Sajay sota anak nonta makakokowa niya gardin na tayoka pan‐obda‐i. Bono‐en tayo et say saja bo‐day ya tawid to koma, kokowa‐en tayo ma.’ ");
INSERT INTO ibl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inkoyod sha nga agpayso sota anak nonta makabo‐day nontan et inbo‐day sha nodta alad et binonora.” Kowan nen Jesus ni arig to. Jet nontan ma, kowan nen Jesus ey, “Nganto emoy pesing nonta makakokowa nontan na bo‐day so nonta ira toon inpangajowan to? ");
INSERT INTO ibl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Simpri ondaw ali et bono‐en to ira jay ya too ngo, jet ipiyal to sota bo‐day so ni eshom ma mengajowan so.” Nem sota totoon in‐arigan nen Jesus, idi intenengan sha iyay, kowan sha ey, “Enshi! Eg dag‐en nen Apo Shiyos itan!” ");
INSERT INTO ibl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nem si Jesus, inningning to ira asan toka ibeka ey, “No kowan jo ey eg dag‐en nen Apo Shiyos itan, ngarantoy joka pengi‐odog ngarod nonta naysolat nonta bayag da, ja kowan to ey, ‘Sota baton binedaw ira nonta para amag ni baley, ja kowan sha ey enshiy silbi to, si‐kato et ngo mowan gayam i epateg ga bato so ni emin’? ");
INSERT INTO ibl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jet angken sipen too ja maysokbab nodtan na bato, mekosot; tan no sipay tedteshan to, memisit.” ");
INSERT INTO ibl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Edawag ey sota mamaistoro ni dinteg ni Hodiyos tan sota ira apo ni papashi, si‐karay naytorongan nonta arig ga kowan nen Jesus. Isonga kowan sha ey seskelen sha si Jesus nontan na oras, nem entakot sha ira sota totoo. ");
INSERT INTO ibl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Piyan shen timpo‐an na seskelen, isonga engibetkag ira ni toon meniim son si‐kato ja kowan sha ey, “Daw kayo, ja singa podnoy jo ibaga son si‐kato. Balang nem ẃaray ikowan ton kabol la pengidawan tayo son gobinarol.” ");
INSERT INTO ibl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jet sota emeni‐siim son Jesus, kowan sha ey, “Maistoro, amta mi ey podno sota moka ikokowan tan moka itoro. Amta mi pay ey enshiy moka pabori, angken ngantoy katoo to, tan say moka itoro ni olay, sota podnon piyan nen Apo Shiyos ja dag‐en ni totoo. ");
INSERT INTO ibl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jet ikowan mo ga no maypeshit shi dinteg tayon Hodiyos i panbedjad tayo ni bowis so ni gobirnod Roma, ono enshi.” ");
INSERT INTO ibl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nem si Jesus, amta to ey olbod sha iyay, isonga kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipa‐sasimak ni salepi. Sipay makadopa niya naymalked ja pilak? Tan sipay makangaran niya naysolat?” Simongbat ira ja kowan sha ey, “Sota ari shi Roma.” ");
INSERT INTO ibl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jet kowan ma nen Jesus son si‐kara ey, “No kasta, sota pilak ja joka osala, edapod gobirno ni Roma, isonga mesepol met laeng nga pa‐odiyo son si‐kara. Sota kowan ni gobirno ey may‐ekan son si‐kara, mesepol la maytongpal, jet sota kowan ngo nen Apo Shiyos ey may‐ekan son si‐kato, mesepol ngon mepati.” ");
INSERT INTO ibl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Piyan shen ẃaray pankamali‐an tod sango‐an ira nonta karakdan, nem enshi. Ireka messhaaw nonta songbat to, jet inbi‐jag sha may bagabaga son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Waray Hodiyos iren kowan sha ey Sadosiyo, ja say pamatira, kowan sha ey eg kono manbiyag mowan i nanketey. Dimaw ngo ira di son Jesus jet sha inbag‐an ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maistoro, say insolat nen Moises nonta bayag da ja dinteg tayon Hodiyos, kowan to ey no sota dakin engaseẃa ket metey ja enshiy potot to nodta aseẃa to, sota agi nontan na dakin etey, si‐katoy mengelbat nonta istay aseẃa to say balang nem ẃaray enaken sha. Jet sota anak sha, maybidang ey singa potot nonta etey den agi to. ");
INSERT INTO ibl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iyay i piyan min ibaga. Nontan da kono, ẃaray piton san‐a‐aki, jet sota pangodowan, engaseẃa; nem etey ya enshiy to inpotot. ");
INSERT INTO ibl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jet sota maykadẃen agi to, inelbat to sota aseẃa nonta agi ton etey, nem etey mowan sota daki. ");
INSERT INTO ibl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kasta met sota maykatdon dakin agi sha, si‐kato ngoy engelbat mowan, nem iso met laeng nga etey mowan ja enshiy to inpotot nodta bii. Jet emin ira jay ya piton san‐a‐aki ja nansasa‐dat ja engaseẃa nontan na bii, etey ira ja enshiy sha inpotot. ");
INSERT INTO ibl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jet shi ka‐onoran, etey kono ngo sota bii. ");
INSERT INTO ibl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sajay i piyan min ibaga son si‐kam, ta no bilang ey onsabi ali sota timpon pan‐ongal ira ni nanketey, sipa emoy koston maka‐aseẃa ali so nontan na bii? Ta nan‐i‐inelbat met ira sota piton san‐a‐aki ja engaseẃa son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Simongbat si Jesus ja kowan to ey, “Sota daleki tan bibii shiya dobong, ireka emengesawa. ");
INSERT INTO ibl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nem sota totoon ikari nen Apo Shiyos ja pan‐ongal to, ja man‐iyan ali shi dangit, eg ira mengesawa nontan alin timpo. ");
INSERT INTO ibl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eg ira ma metey shiman, tep inges shay anghil nen Apo Shiyos. Annak ira nen Apo Shiyos tep nan‐ongal ira. ");
INSERT INTO ibl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nem sigosho eg jo pati‐en ey manbiyag mowan i nanketey. Angken si Moises nonta bayag da, toka penekneki ey say toon etey, manbiyag mowan. Nonta bayag da, insolat toy mismon intenengan to ja esel nen Apo Shiyos ja edapo nodta emanshedang nga kadasan, ja kowan to ey, ‘Si‐kak si Apo Shiyos ja Shiyos shi Abraham, Isaac, tan si Jacob.’ ");
INSERT INTO ibl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Piyan ton a‐selen ngarod ey angken etey mangon ebayag i bakdang shi Abraham, kowan nen Apo Shiyos ey mabiday ired sango‐an to. Ta no enshi koma, istay eg to inkowan ey si‐katoy Shiyos sha. Emin na too — angken sota ira nanketey — kaibilang nen Apo Shiyos ey ẃara pay laeng ired biyag.” ");
INSERT INTO ibl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sota eshom ma maistoro ni dinteg ni Hodiyos, kowan sha ma ni abos ey, “Mapteng itan na insongbat mo, Maistoro.” ");
INSERT INTO ibl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jet polos malen eg sha intoled ja nansalodsod mowan son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kowan nen Jesus son si‐kara ey, “Apay ngarod nga kowan sha ey sota inkari nen Apo Shiyos ey ibetkag to din mengisedakan ket medepo bengat shi poli nen Ari David nonta bayag da? ");
INSERT INTO ibl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta angken si Ari David shorog, inkowan tod dibsho ni Salmo ey, ‘Si Apo Shiyos, inkowan to so nonta pangolok ey ontongaw si‐kato shi apit ni kanawan to, ");
INSERT INTO ibl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ingkatod enshiy mebedin nonta kabakal to, ja ẃara ma ired shalokap ni shapan to.’ ");
INSERT INTO ibl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jet no kowan nen Ari David ey pangolo to sota mengisedakan, toway inpasing to ja kowan sha ey poli ali nen Ari David?” ");
INSERT INTO ibl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Idi maramen emantetneng ira sota eshakel la totoo son si‐kato, kowan nen Jesus so nonta ira too to ey, ");
INSERT INTO ibl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tanshaaniyo ira ja mamaistoro ni dinteg ta baka ma‐edinan kayo. Pipiyan shen manbesho ni nankedayag ni sha panpasiyal, tan pipiyan sha pay ya rispito‐en ni totoo ira ja semsemano‐an shima malkaro ja karakdan ni too, tan shima sa‐nopan, pipiyan sha pay ja ontongaw shima naysaganen tongawan say mebigbig ira, tan agdalo no timpo ni piyasta, sotan i shaka pesing. ");
INSERT INTO ibl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Manpa‐otang ira mango nonta bibiin nankebalo jet no enshiy ibayad sha, piditen shen angken sota baley sha i ibayad sha. Jet no ondaw ired sa‐nopan, say shaka pesing nga mena‐din ni kakedsel sha, shaka ishokey i shawat sha son Apo Shiyos, say ikowan ni too ey maronong ira. Nem amta nen Apo Shiyos et ebadbadeg i penosa to son si‐kara!” ");
INSERT INTO ibl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nonta ẃara shi Jesus shi Timplo, inon‐an to ira sota toon babaknang ja en engi‐kas ni pilak sha nodta kakon ja kay‐ini ni alos shi Timplo. ");
INSERT INTO ibl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jet ẃara ngoy sakey ya ebalon biin ebiteg ja en engi‐kas ni showen sintimos. ");
INSERT INTO ibl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jet kowan nen Jesus so nonta ira too to ey, “Ikowan ko son si‐kayo, sajay ya biin ebalo, ja ebiteg ga pasiya, epatpateg sota in‐akan ton alos to nem say sota eshom. ");
INSERT INTO ibl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta sota ira eshom, sobda ni pilak sha i sha in‐akan, nem sajay ya biin ebiteg, in‐akan ton emin i oltimon ẃara son si‐kato — angken sota istay panbiyag to koma.” ");
INSERT INTO ibl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sota ira eshom ma too to, ireka emantatabtabal pangkep nonta Timplo, ja kowan sha ey, “Mapteng nga pasiya i boya ni Timplo. Angken sota ira bato, mapteng i inkay‐amag to, tan kasta met sota nay‐amag nodtan ja in‐akan ni too nontan da.” Nem si Jesus, kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sajay ya Timplon joka pan‐ishemang niman, ẃara aliy timpon kesheshal to. Angken sakey so ira nima baton mapteng i inkay‐amag to, enshiy en mebay‐an shima nay‐amagan to; mesheshal la emin.” ");
INSERT INTO ibl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jet inbaga sha ey, “Apo, pigan ali ita kowan mo? Jet nganto pay i amta‐an mi so no shanshanin mepesamak itan?” ");
INSERT INTO ibl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Simongbat si Jesus ja kowan to son si‐kara ey, “Nemnemnemen jo koma iyay. Karekayo pa‐olbod so ni angken sipa, ta eshakel aliy toon mengosal ni ngaran ko, ja kowan sha ey si‐kara si Cristo, ono kowan sha ey shanshaniy pantepos ni dobong. Nem karejo patpati‐en. ");
INSERT INTO ibl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No ẃaray kobat tan kolo ja shemagen jo, karekayo onkel‐ew. Tep kenshat ta mepesamak ira jay, nem aliẃen sotan i ka‐amta‐an to ey shanshani may pantepos ni dobong.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jet intoloy ton kowan to pay ey, “Angken ili tan ili, mankokobat ira, tan angken pay sota ka‐ili‐ilin intorayan ni a‐ashi, mankokobat ngo ira. ");
INSERT INTO ibl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wara pay ali i nankekedsang nga jegjeg, tan epalado aliy bitil tan manpansekit i totoo shi kedogadogad. Waray katetakot ta asen jon mepesamak shi naykayang, jet saja eshom ma mepesamak, ẃaray isinjas to di. ");
INSERT INTO ibl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nem pedigaten shakejo nin ni totoo. Seskelen shakejo et i‐ilaw shakejod baley ya kesa‐nopi ni Hodiyos jet bistigalen shakejod man, jet ibalod shakejo pay. Jet ikoyod shakejo pay shi sango‐an nonta ira ari, tan sango‐an nonta ira gobinarol, ta too takejo. ");
INSERT INTO ibl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sotan i ẃaya jon mengiringan na mengikowan son si‐kara ni maypangkep son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Karejo nemnemen ja mengisekana shagos ni isongbat jo son si‐kara, ");
INSERT INTO ibl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tep si‐kak met laeng i mengi‐kan son si‐kayo ni koston isongbat jo tan daing jon man‐a‐sel. Isonga sota makakontra son si‐kayo, enshi son si‐kara i makabaal ja mengebak son si‐kayo; mesampolo et ira. ");
INSERT INTO ibl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sota ira a‐akiyo, partido jo, kajem jo, tan angken pay sota ira maka‐anak son si‐kayo, si‐kara met laeng i mengibaag son si‐kayo so nonta ira makakontra son si‐kayo say seskelen shakejo, jet sota eshom son si‐kayo, bono‐en sha. ");
INSERT INTO ibl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sota joka pemati son si‐kak, si‐katoy kabol la okesan shakejo so ni karakdan na too. ");
INSERT INTO ibl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Nem anosiyo, ta sota anos joy kaysedakan jo. Sigoradon eg kayo mepokaw ingkatod ingka. ");
INSERT INTO ibl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“No asen jon pandiktoba ni solsharo i Jerusalem, amtayo ma ey kenshat ta sheshalen sha i Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","No mepesamak iyay, say pesing koma nonta ira ẃared Jodia ket onbetik ira et ja manbakwit shi shonshontog. Sota ira ẃared siyodad ni Jerusalem, manbakwit ngo ira, tan sota ira toon ẃara nodta aliẃen sakop ni Jerusalem, eg sha koma nemnemen ja ondaw shiman. ");
INSERT INTO ibl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta sajay alin akew, si‐katoy ketongpal ni emin na insolat ni para padto nen Apo Shiyos nonta bayag da, ja inpadtoren timpo ja penosa nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sajay alin mepesamak, kakaasi ira din pasiya sota bibiin malokon, tan sota bibiin ẃaray anak shen emenoso, tep digat ta pasiya i onmotok alid jay ya dogad! Si‐kato aliy epaladon keshosa ni Hodiyos, ja totoo shiyay ya dogad. ");
INSERT INTO ibl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Say eshom son si‐kara, bono‐en ni kabakal sha ni kampilan, tan sota ira ebay‐an, al‐en sha iren maybedod shi emin na ka‐ili‐ili. Jet sota toon aliẃen Hodiyos, si‐karay onkatin so ni Jerusalem, ingkatod kepospos ni timpon inkesheng nen Apo Shiyos ja penosara so ni Israel. ");
INSERT INTO ibl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Waray katetakot ja mepesamak nima sekit, nima bolan, tan sama talaw ira. Shiya dobong, emin na tood ka‐ili‐ili, onkel‐ew ira; messhaaw iren pasiya tep makedsang i bongog ni baybay, tan kakembaleg i shadoyon to. ");
INSERT INTO ibl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Onkapoy iray totoo ni takot sha ni shaka pansessesked no ngarantoy mepesamak shiya dobong, tep angken sota naykayang, mebediwan i itsora to. ");
INSERT INTO ibl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sajay nin i mepesamak, asan edaw ali sota Anak ni Too. Mismon asen sha‐ak ni totoo ja ma‐odopan ali ni kolpot, tan asen sha pay i itsora ni bakdang kon emenenilin pasiya, tan asen sha ngo sota podnon panakabalin ko. ");
INSERT INTO ibl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Isonga no asen jon emankepasemak iyay ya inkowan ko, pan‐imdeng kayo! Tangkak jo, tep shanshanin mayẃekas i digat jo.” Kowan nen Jesus iyay ya emin. ");
INSERT INTO ibl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jet in‐arigan to ira, ja kowan to ey, “Nemnem jo kari sota kadasan na kowan sha ey higos, tan angken pay sama ira eshom ma kait ton kadasan. ");
INSERT INTO ibl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Shiya kad‐an tayo, no asen jon emansimit i bolong to, amtayo ma ey shanshani sota timpo ni petang. ");
INSERT INTO ibl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Say olog niyay, no asen jon meshoki‐an na emanketongpal ira ja inkowan ko la, amtayo ma ey shanshani may pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Podno iyay ya ikowan ko son si‐kayo. Saja ira too niman, eg ira nin metey, no diket sa‐kopen shen emin ira jay ya mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sama naykayang tan saja dobong, mebedin na ma‐enshi, nem saja esel la inkowan ko, kenshat ta metongpal, ja eg ma‐enshi.” ");
INSERT INTO ibl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Jet si Jesus, binanshaanan to ma ira, ja kowan to ey, “Pantanshaan kayo. Karekayo mesiẃat ni paspasiyal tan inom ni adak, ono mesiẃat ni nemnemnem jo nem ngarantoy pesing jon manbiyag. Baka ondibag kayo ni imotok ko di, tep mebiglen pasiya, ja inges toy kebkas ni katig. Messhaaw wa emin i totoon ẃared ja dobong. ");
INSERT INTO ibl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Isonga say kowan ko son si‐kayo, mesepol la esagana kayo ni olay. Panshawat kayo son Apo Shiyos ni kedsang, say idasat jo iyay alin mepesamak, say manpeshang kayo ni anongosto son si‐kak ja kowan sha ey Anak ni Too.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Si Jesus, no ka‐akawan, kanayon na emantosho shi Timplo, tep kaonbowas iray totoon en mantetneng son si‐kato. Jet no mama‐shem mala, kaon‐oli ni olay shi shontog ga kowan sha ey Olibas, jet shiman i pandebi‐an to. ");
INSERT INTO ibl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Shanshani nontan sota timpo ni piyasta ni Hodiyos ja kowan sha ey Paskowa. ");
INSERT INTO ibl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sota apo ira ni papashi ni Hodiyos tan mamaistoro ni dinteg ni Hodiyos, piyan shen pasiya ja bono‐en si Jesus, nem entakot ira nonta totoon eshakel ja na‐awis son si‐kato. Isonga ireka mengenap nontan ni pesing shen memono son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Si Satanas, sinairo tos Judas Iskariote ja sakey so nonta ira sampolo tan showen apostol nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Si Judas, dimaw ja en ekitbal so nonta ira apo ni papashi tan kowadja ni Timplo no ngarantoy pesing ton mengitosho ni kawad‐an nen Jesus say seskelen sha. ");
INSERT INTO ibl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jet ireka man‐imdeng, tan shaka pan‐akni ni pilak ja dagbo to. ");
INSERT INTO ibl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jet si Judas, ekitodag ey itoro to son si‐karay kad‐an nen Jesus nem saman na enshiy eshakel la totoo, say enshi komay kolo. Jet manshoki nontan, ẃara ni olay shi nemnem nen Judas Iskariote no toway pesing ton mengibaag so nen Jesus son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Shimanon sota akew wa shaka pengan ni tinapay ya enshiy daok ton para debag tan shaka pemalti ni kalniron sid‐an sha nem Paskowa. ");
INSERT INTO ibl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jet nontan, si Jesus, inbetkag tos Pedro nen Juan, ja kowan to ey, “Daw kayo, jo isekana i penganan tayo nem ma‐shem tep Paskowa ma.” ");
INSERT INTO ibl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kowan sha ey, “Toway daẃan min en pengisekana‐an ni penganan tayo?” ");
INSERT INTO ibl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kowan nen Jesus ey, “Itnengiyon pasiya iyay. No onsabi kayod Jerusalem, ẃaray dakin aspolen jo ja emasan ni salaw ja na‐inan ni shanom. Onod jo nodta baley ya seskepan to, ");
INSERT INTO ibl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","jet ikowan jo iyay so nonta makabaley: ‘Kowan ali nen Maistoro ey towa konoy kowadton penganan to tan si‐kamin too to niman na ma‐shem, tep Paskowa?’ ");
INSERT INTO ibl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jet ipa‐sas to son si‐kayo i embanaw wa kowadto nodta naykayang, ja ẃara nodtan na emin i mesepol tayo. Si‐katoy pengisekana‐an jo ni kenen tayo nem ma‐shem.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dimaw ira sota shadẃa shi Jerusalem et siya, kosto noman na nay‐agpayso sota kowan nen Jesus son si‐kara. Jet insaganared man sota kenen sha nontan na ma‐shem. ");
INSERT INTO ibl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Idi mama‐shem mala, si Jesus tan sota sampolo tan showen apostol to, dimaw iren mengan nodtan. Timongaw ira, ");
INSERT INTO ibl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","jet si Jesus, kowan to son si‐kara ey, “Piyan kon pasiya ja mekipengan nin son si‐kayo niman na Paskowa, asan naka mandikat! ");
INSERT INTO ibl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ikowan ko iyay son si‐kayo. Sajay i ka‐onoran na Paskowa ja pekipenganan ko. Enshi ma nin ingkatod metongpal i podnon olog ni Paskowa shi pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Inda nen Jesus sota tasa et nan‐iyaman son Apo Shiyos, asan kowan to ey, “Iya, ko‐ko‐tik jon inomen iyay. ");
INSERT INTO ibl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ikowan ko iyay son si‐kayo. Sajay i ka‐onoran na penginom ko ni shanom ni obas, jet ekak nin menginom ingkatod metongpal aliy pantoshayan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Inda to sota tinapay et nan‐iyaman son Apo Shiyos, asan toka showashowa‐a. Jet in‐akan to nodta ira apostol to, ja kowan to ey, “Sajay i bakdang kon itolok kon bono‐en sha; si‐katoy kaysedakan jon took. Si‐kayo, itodtodoy jon mandilikob ja menowashowa ni tinapay, ja si‐katoy penginemneman jo son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jet idi naksheng iren engan, inda to sota tasa jet kowan to ey, “Manshoki ma niman, badoy pesing nen Apo Shiyos ja mengisedakan ni totoo, jet saja inomen jon ẃared tasa, si‐katoy pengiroki to, ta sajay i shalak ka on‐ayos ali nem meteyak. Sajay i on‐ayos say maysedakan kayo.” ");
INSERT INTO ibl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jet intoloy ton kowan to ey, “Nem niman, ẃaren ekilikob son si‐katejo sota mengibaag son si‐kak so nonta ira makakontra son si‐kak! ");
INSERT INTO ibl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Si‐kak sota kowan ni para padto nonta bayag da ey Anak ni Too, jet sigod ja inkesheng nen Apo Shiyos ey mesepol la meteyak. Nem kaasi met laeng sotan na toon mengibaag son si‐kak, ta meshosen pasiya!” ");
INSERT INTO ibl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Idi inkowan nen Jesus iyay, sota ira apostol to, nanbibinaga ira nem sipa son si‐kara i ondaga so nonta kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nansosongbat pay ira nem sipa aliy ibilang nen Jesus ey kangeto‐an. ");
INSERT INTO ibl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jet kowan nen Jesus son si‐kara ey, “Say ogadi ira nonta mantoshay shima kompormin ili, tan sota eshom ma toon nankengatoy saad sha, shaka ipakat i saad sha ni shaka pengitoshay met laeng so ni sinekopan sha. ");
INSERT INTO ibl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nem no si‐kayo, aliẃen inges nontan i pesing jo so ni sakey tan sakey son si‐kayo. Sota pangolon kangeto‐an son si‐kayo, si‐kato komay singa orishiyan ja ekombaben man‐obda ni pansigshan ni kait to. ");
INSERT INTO ibl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nemnem jo kari iyay. Sipay engatngato — sota timongaw ja emengan, ono sota emengi‐kan ni kenen to? Simpri sota toon timongaw wa emengan. Nem angken apo jowak, naka man‐obda ni olay ni pansigshan jo. ");
INSERT INTO ibl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Angken eshakel i digat ko, mapiyan kayon on‐ono‐onod son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Si Apo Shiyos ja Amak, inkesheng to ey si‐kak i mantoshay ni ka‐onoran alin akew, jet si‐kak ngoy mengigsheng ey mekitoshay kayo ali. ");
INSERT INTO ibl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mekiladsak kayo son si‐kak ni pantoshay ko, tan ontongaw kayo pay ja mengigsheng ni panbenagan ni emin na Hodiyos ja poli nonta sampolo tan showa ja annak nen Israel.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jet ẃaray inkowan to son Pedro ey, “Simon, Simon, iyay i ikowan ko son si‐kam. Si Satanas, ẃaray parang to ey pandikat shakejo, balang kono nem ma‐adilaw kayo, say mansisi‐jan kayon singa tineg‐ap ni emenaap. ");
INSERT INTO ibl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mebedin na ma‐adilaw ka Simon, ni sanka‐atikan, nem inshawat ko son Apo Shiyos ey eg mekolpin onkapoy i pamatim. Jet no may‐odi mowan i pamatim son si‐kak, si‐kam ngoy pekedsang so ni kait mo.” ");
INSERT INTO ibl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simongbat si Pedro ja kowan to ey, “Apo, eg mebedin! Angken ibalod sha‐ak, angken bono‐en sha‐ak, esagana‐ak ja kadẃa‐en taka ni olay!” ");
INSERT INTO ibl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kowan nen Jesus ey, “Ikowan ko iyay son si‐kam Pedro: niman na dabi, isaot mowak ni memintedo ja ikowan mo ey eg mowak am‐amta, asan ẃaray ontekok ja kawitan.” ");
INSERT INTO ibl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jet kowan nen Jesus son si‐karen emin ey, “Nonta inbetkag takejon enshiy jo inta‐jon na pilak ono bayong ono sapatos, ẃaray kolang ja kasapolan jo nontan?” Simongbat ira ja kowan sha ey, “Enshi, ẃaren emin.” ");
INSERT INTO ibl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Kowan ma nen Jesus ey, “Eg kayo nankolang nontan tep ensemek sha‐ak nodta dinaẃan jo, isonga in‐aknan shakejo. Nem niman, apil ma. Ta say nemnem ira ni totoo son si‐kak niman, kowan sha ey sakeyak kono ngon enshiy kenkenshat to. Ta mesepol la metongpal son si‐kak sota padto nonta bayag da ja kowan to ey, ‘Maybidang ey sakey ya bimasol.’ Isonga manshoki ma niman, no sipa son si‐kayo i ẃaray pilak to ono bayong to, ita‐jon to koma. Tan no sipa son si‐kayo i enshiy kampilan to, idako to komay baro to et menongkal ni sakey.” ");
INSERT INTO ibl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jet kowan nonta ira apostol to ey, “Apo, asas mo! Iyay i showen kampilan!” Kowan nen Jesus ey, “Kosto ma, enog.” ");
INSERT INTO ibl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanajon na kaondaw si Jesus shima shontog ga kowan sha ey Olibas jet idi bimo‐day ira nodta baley ya enganan sha, inodop to ira sota apostol to et dimaw ira nodtan na shontog. ");
INSERT INTO ibl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Idi mimotok ira nodta dogad ja kanajon na toka pansheẃati, kowan to son si‐kara ey, “Panshawat kayo son Apo Shiyos ni kedsang say eg shakejo ebaken ali ni digat ja onsabi son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Idi inkowan to iyay, bintawan to ira ni ootik et nantalimokod ja nanshawat son Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ja kowan to ey, “Ama, no mebedin koma, eg mo ipalobos iyay ya pandikat ko di. Nem say kowan ko, sota piyan mo, si‐katoy metongpal, aliẃen sota kostok.” ");
INSERT INTO ibl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Waray anghil ja edapod dangit jet to tinodongan si Jesus say onkedsang. ");
INSERT INTO ibl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Emandikat si Jesus sa pasiya, isonga mas pay ya nanshawat ta pasiya son Apo Shiyos. Naydi‐di‐ngetan ja singa shalay toka pantedted. ");
INSERT INTO ibl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Idi imekẃas ni toka pansheẃat, dimaw et to inon‐an sota ira too to, jet simbi to iren na‐ogip. Nabdey ira ni nemnemnem sha ni shaka pandeshingit. ");
INSERT INTO ibl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jet kowan to son si‐kara ey, “Ngantoy? Na‐ogip kayo? Bangon kayo, jet panshawat kayo son Apo Shiyos say eg shakejo ebaken ali ni digat ja onsabi son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Maramen eman‐a‐sel si Jesus ey onmotok aliy eshakel la totoo. Si Judas Iskariote, ja sakey so nonta ira sampolo tan showa ja apostol nen Jesus, si‐katoy engibalnay so ira nonta eshakel la totoo. Insopan nen Judas si Jesus, ja kowan to ey to ongo‐an. ");
INSERT INTO ibl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nem kowan nen Jesus son Judas ey, “Ongo gayam i pengitoshom so nen si‐kak so nita ira makakontra son si‐kak? Amtam met ey si‐kak sota kowan ni padto nonta bayag da ey Anak ni Too!” ");
INSERT INTO ibl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Idi inamta‐an nonta eshom ma too nen Jesus i mepesamak ali, kowan sha son Jesus ey, “Apo, palobosim kamin mengibediw son si‐kam! Iyay ngoy kampilan mi!” ");
INSERT INTO ibl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jet sota sakey so nonta ira too nen Jesus, kinimpas toy kanawan na tangida nonta sakey ya baga‐en ni kangeto‐an na pari. ");
INSERT INTO ibl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nem imesel si Jesus ey, “Kosto, enog!” Jet in‐oli nen Jesus sota tangida nonta too et nay‐olin mimapteng ma sota tangida. ");
INSERT INTO ibl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kowan ma nen Jesus so nonta ira apo ni papashi tan kowadja ni Timplo, tan sota eshom iren pangolo ni Hodiyos ja en mengshel son si‐kato ey, “Apay nga nan‐etak kayo di tan ẃaray peg‐as jo? Apay tolisan i kowan jo ey a‐shelen jod jay? ");
INSERT INTO ibl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inakew met ja ẃara‐ak shima Timplo, ket apay nga eg jowak inshel nontan? Nem niman na kalebi‐an met kitdi i timpoyo, tep si‐katoy pan‐obda nen Satanas!” ");
INSERT INTO ibl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Singkel shes Jesus et indaw sha led baley ni kangeto‐an na pari. Jet si Pedro, tinned to ira nem bimetaw. ");
INSERT INTO ibl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Waray emenangshang nodta bo‐dayan, jet nay‐eshom ngos Pedro. ");
INSERT INTO ibl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nem idi on‐an nonta sakey ya biin baga‐en ni kangeto‐an na pari si Pedro, inningning toy dopa ton esilẃan nonta apoy et kowan to ey, “Angken si iyay met, kait nonta inshel sha.” ");
INSERT INTO ibl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nem nandibak si Pedro, ja kowan to ey, “Keba‐ba‐ngata niyay ya bii! Apay am‐amtak sotan na kowan mo!” ");
INSERT INTO ibl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Enshiy bayag to, ẃara mowan i daki ja engimaton son Pedro et kowan to ey, “Si‐kam met i sakey ya too nontan na too.” Nem kowan nen Pedro ey, “Moka ba‐ba‐ngatay esel! Apil, aliẃen si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Idi epalabas i sakey ya oras, ẃara mowan i sakey ya toon emengipidit ja shinoyshoy to pay si Pedro, ja kowan to ey, “Ayshiy showashowa! Kenshat ta si‐katoy sakey ya kait to did Galilia, tep si‐katoy kait ton i‐Galilia!” ");
INSERT INTO ibl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Simongbat si Pedro ja kowan to ey, “Enshiy amtak nita moka pan‐ikowan!” Jet idi maramen eman‐a‐sel pay laeng si Pedro, timekok i kawitan. ");
INSERT INTO ibl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jet nontan ẃimingi si Jesus et inshemang tos Pedro. Jet ninemnem ma nen Pedro sota inkowan nen Jesus ey, “Isaot mowak ni memintedo, ja kowan mo ey eg mowak am‐amta, jet no meksheng, ẃara ngoy ontekok ja kawitan.” ");
INSERT INTO ibl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jet si Pedro, dimaw shima powisha ja epaladoy nangis to tep naydaw‐an. ");
INSERT INTO ibl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Sota ira emanbantay so nen Jesus, shaka sengsengkita: inopopan shay mateto, asan shaka shengshengpela, jet kowan sha ey, “Sipay enengpel son si‐kam? Tiga, ipadtom ka!” ");
INSERT INTO ibl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tan eshakel pay i inkowan shen ngaaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Idi eẃa‐ẃa, esa‐nop sota ira pangolo ni Hodiyos, pati sota ira apo ni papashi, tan sota ira mamaistoro ni dinteg ni Hodiyos. Jet insekep shes Jesus et insango sha son si‐kara met laeng. Jet inbag‐an sha, ja kowan sha ey, ");
INSERT INTO ibl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ipodnom no agpayson si‐kam sota inkari nen Apo Shiyos nonta bayag da ey ibetkag to alin mengisedakan!” Nem simongbat si Jesus ja kowan to ey, “No ikowan ko, eg jo met laeng pati‐en. ");
INSERT INTO ibl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jet no ibag‐an takejo ngo, eg jowak met songbatan. ");
INSERT INTO ibl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nem iyay i ikowan ko son si‐kayo. Si‐kak sota inpadtora nonta bayag da ey Anak ni Too et shanshani men mekitongawak son Apo Shiyos ja Manakabalin, ja nak ngo mantoshay.” ");
INSERT INTO ibl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jet kowan sha ma ey, “No kasta ngarod, kowan mo ey si‐kam i Anak nen Apo Shiyos?” Simongbat si Jesus ja kowan to ey, “Sota inkowan jo, si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kowan sha ma ey, “Eg mesepol la ẃara pay i sistigo! Intenengan tayon mismoy kowan to!” ");
INSERT INTO ibl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jet emin sota ira esa‐nop pa toray, intolod shes Jesus shi kad‐an nen Gobinarol Pilato, ");
INSERT INTO ibl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","jet insodsod sha son Pilato sota kowan sha ey basol nen Jesus, ja kowan sha ey, “Sinokalan mi iyay ya too, ja toka pan‐eẃisen emin i too mi ey angken eg ira manbedjad ni bowis so ni gobirnoyod Roma, tan kowan to pay ey si‐kato sota arin inbetkag ali nen Apo Shiyos ja mengisedakan kono son si‐kamin Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Inbag‐an nen Pilato si Jesus ja kowan to ey, “Jet si‐kam sota ari ni Hodiyos?” Simongbat si Jesus ja kowan to ey, “Sota inkowan mo, si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jet kowan nen Pilato so ira nonta apo ni papashi tan sota kait shen eshakel ey, “Enshi met i sinepolan kon ngaaw wa aramid niyay ya too.” ");
INSERT INTO ibl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nem ema‐ma et ja shaka pan‐ipilit, ja kowan sha ey, “Si‐katoy emengi‐kan ni kolo, manipod shi Galilia tan intiron Jodia ingkato did jay!” ");
INSERT INTO ibl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Idi itenengan nen Pilato iyay, inbaga to nem agpayson i‐Galilia si Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jet idi inamta‐an to ey edapos Jesus shi Galilia ja sakop ni intorayan nen Hirodis, inpaitolod to son Hirodis, tep naytompong ngon ẃared Jerusalem nontan na akew si Hirodis. ");
INSERT INTO ibl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Si Hirodis, eman‐imdeng nga pasiya ni in‐oney to son Jesus, ta ebayag ga shinemag toy maypangkep son si‐kato, jet piyan ton pasiya ja asen, balang nem ẃaray dag‐en ngo nen Jesus ja milagro. ");
INSERT INTO ibl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jet eshakel i salodsod nen Hirodis son si‐kato, nem eg sinongsongbatan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jet sota apo ira ni papashi tan sota mamaistoro ni dinteg ni Hodiyos, kimedsang iren shaka panpebesolis Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Angken si Hirodis tan sota ira solsharo to, sinengsengkit sha si Jesus, ja dingkaren emin i piyan sha son si‐kato. Jet say inpasing sha pay ni dedamsis sha, binesho‐an sha ni mapteng nga singa baro ni ari, asan shaka pa‐odi so nen Pilato. ");
INSERT INTO ibl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jet nontan na akew, nankajem si Hirodis nen Pilato ey istay ya kabakal ira da nontan. ");
INSERT INTO ibl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Idi mimotok ira shi kad‐an nen Pilato, sina‐nop to iray apo ni papashi, tan sota eshom iren toray ni ili, tan sota karakdan na totoo, ");
INSERT INTO ibl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","jet kowan to son si‐kara ey, “Saja toon in‐ilaw jo did jay, ja kowan jo ey pan‐eẃisay totoon eg memati ni bilin min i‐Roma, binistigal ko shi sango‐an jo et enshi met i emesokalin kowan jo ey ngaaw wa aramid to. ");
INSERT INTO ibl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Angken si Hirodis, enshiy to sinokalan na basol to, isonga inpa‐odi to di son si‐kami. Edawag ey enshiy basol niyay ya toon to kebono‐an. ");
INSERT INTO ibl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pesepdat ko bengat et maybodos ma.” Kowan nen Pilato. ");
INSERT INTO ibl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Inkowan to ey ibolos to, ta no sinshon piyasta ni Paskowa, ẃaren kenshat i sakey ya pirison ibolos to so nonta ira totoo.) ");
INSERT INTO ibl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nem emin ira sota eshakel la totoo, eg sha kosto. Shaka pan‐ikeljaw ey, “Enshi! Bono jo iyay ya too! Ibodos jo dis Barabas son si‐kami!” ");
INSERT INTO ibl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Saja si Barabas, naybalod ni dinodokon dingka ton maykontra shi gobirno, tan bimono pay.) ");
INSERT INTO ibl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Si Pilato, piyan ton istay si Jesus komay maybodos, isonga inbag‐an to mowan i totoo no piyan sha. ");
INSERT INTO ibl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nem shaka et pan‐ikeljaw ey, “Paidansam et shi koros! Paidansam et shi koros!” ");
INSERT INTO ibl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jet kowan nen Pilato ni maykepintedo ey, “Ngantoy? Ngaran ni dingka ton ngaaw aya? Enshi met i sinepolan kon basol ton kebono‐an to. Pesepdat ko bengat et maybodos ma.” ");
INSERT INTO ibl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nem ema‐ma‐ma et ja pilmiy keljaw ni totoo ja kowan sha ey, “Paidansam shi koros!” Anongosto ma ey engabak i kelkeljaw nonta totoon eshakel: ");
INSERT INTO ibl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","si Pilato, inkowan to ey metongpal sota kowan sha. ");
INSERT INTO ibl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Inbolos tos Barabas ja naybalod maypangkep ni dinodokon dingka ton maykontra shi gobirno tan sota inpamono to. Tan in‐awat tos Jesus so nonta totoo say dag‐en shay pipiyan shen dag‐en son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Indara si Jesus et idi ireka man‐ekad ja ondaw nodta kaydansa‐an tod koros, inaspol sha sota toon si Simon i ngaran to, ja i‐Sirini. Istay ondaw koma shi siyodad, nem inpasakbat sha et son si‐kato sota koros, ja in‐onod to son Jesus ni shaka pan‐ekad. ");
INSERT INTO ibl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jet eshakel iray totoon nay‐olop son Jesus, tan ẃaray eshom ma bibiin ekidaw ja epaladoy shaka pannengis ni daringit sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Winingi nen Jesus ira et kowan to ey, “Si‐kayon bibiid Jerusalem, karejowak nengisan. Nangisi jo et i bakdang jo shorog tan sota ira annak jo! ");
INSERT INTO ibl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta iyay aliy timpon pandikat ni totoo. Sotan alin timpo ja onsabi, ikowan ni totoo ey magesat iray bibiin enshiy annak sha, ja enshiy sha inpanoso. ");
INSERT INTO ibl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sotan alin timpo, manseskang i totoo, ja ikowan sha ey, ‘Si‐kam ma shontog, karalshal ka di et ta‐boki jokami!’ ");
INSERT INTO ibl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta no medeka iyay shi embasen kiyew, ngantoy pesingan sha so ni emag‐an? No sajay i dag‐en sha son si‐kak ka enshiy basol to, ngaranto emo ali ngoy mepesamak son si‐kayo tan sota ira annak jo?” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Waray showen too ja inpaki‐olop sha son Jesus ja sha pekibitay son si‐kato, ta makedsel iren showa. ");
INSERT INTO ibl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Idi mimotok ired ma dogad ja kowan sha ey Toktok, indansara mes Jesus, tan sota showen makedsel, shi sanseskey ya koros. Sota sakey, ẃara nodta apit ni kanawan nen Jesus, tan sota sakey, ẃared apit ni kanigid to ngo. ");
INSERT INTO ibl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kowan nen Jesus son Apo Shiyos ey, “Ama, pakaẃanim ira ja nandaga niya ngaaw son si‐kak, ta eg sha amtay shaka pandag‐a.” Sota ira engilansa son Jesus, nanbobonot ira no sipay ontompong so nonta baro nen Jesus, asan shaka panbibingayi. ");
INSERT INTO ibl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sota ira totoo, imalekey iren shaka panboja‐a si Jesus ja naykoros. Jet sota ira toray ni Hodiyos, shaka sengsengkita, ja kowan sha ey, “Insalakan to konoy eshom; tiga nem isalakan to ngoy bakdang to shorog! Kabedinan to no podnon si‐kato sota shinotokan nen Apo Shiyos ja inbetkag to din mengisedakan!” ");
INSERT INTO ibl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Angken sota ira solsharo ja kowadja nodtan, shaka sengsengkita, ja kowan sha ey, “Isedakan moy bakdang mo no agpayson si‐kam i ari ni Hodiyos!” Jet shaka i‐ang‐angit ja i‐aknan ni adak. ");
INSERT INTO ibl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tan ẃaray naysolat nodta koros to shi petek ni toktok to ja kowan to ey, “Sajay sota ari ni Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sota sakey ya naykoros shi askang nen Jesus ja makedsel, ngaaw met laeng i inkokowan to son Jesus, ja kowan to ey, “Aliẃen si‐kam aya sota inbetkag ali nen Apo Shiyos ja mengisedakan? Isedakan mo shorog i bakdang mo — tan angken si‐kami!” ");
INSERT INTO ibl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nem sota sakey ya naykoros, inseg‐ang to sota kadẃa to ey, “Enshiy takot mo ni Shiyos? Kitejoka manketey ya tedo, ");
INSERT INTO ibl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","nem kanebengan ta mangon mengikesho ni dingdingka ten ngaaw; si‐kato, enshiy basol to!” ");
INSERT INTO ibl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jet kowan niyay son Jesus ey, “Jesus, nemnem mowak nem manbedin ken ari!” ");
INSERT INTO ibl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kowan ngo nen Jesus son si‐kato ey, “Podno iya ikowan ko son si‐kam: niman na akew, mayda‐kam ken mandadsak son si‐kak shi dangit.” ");
INSERT INTO ibl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Idi nonta alas dosi ni ka‐akawan, nanbolinget nodtan na dogad ingkato nonta alas tris ni mama‐shem, tep kolpin esa‐dinan i sekit. ");
INSERT INTO ibl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jet sota masshel la kortina ja naysa‐din nodta Kapatkan na kowadto shima naydaem ni Timplo, epi‐kat ja nanshowa. ");
INSERT INTO ibl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jet si Jesus, inkeljaw ton kowan to son Apo Shiyos ey, “Ama, ipiyal ko son si‐kam i ispiritok!” Inkowan to iyay asan ma ma‐bosi. ");
INSERT INTO ibl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sota kapitan ni solsharo, inon‐an ton emin iya epasemak et nanshayaw son Apo Shiyos ja kowan to ey, “Agpayso gayam ma maronong iyay ya too!” ");
INSERT INTO ibl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sotan ira totoon dimaw ali ja nanboya ni inkatey nen Jesus, idi inon‐an shen emin i epasemak, imakad iren shaka panpagpagpagay pagew sha ni shaka pandeshingit. ");
INSERT INTO ibl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nem emin ira sota maka‐amten mismo son Jesus, pati sota ira bibiin nay‐olop son si‐kato alid Galilia, ebay‐an ira nodta naybabetaw, ta piyan shen on‐an pay i mepesamak ali. ");
INSERT INTO ibl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Waray toon nanngaran ni Jose ja edapod ili ni Jodia ja kowan sha ey Arimatia. Mapteng i ogadi niyay ya too, tan si‐katoy sakey ya emansesked ni isabi ali ni pantoshayan nen Apo Shiyos. Kaishayaw ni totoo ey mapteng iyay ya too. Si‐kato pay i sakey so nonta ira toray ni Hodiyos, nem eg to inonod i kowan nonta kait ton toray, ja dingdingkara son Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dimaw si iya Jose so nen Pilato ja to kinshaw i bakdang nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jet idi impas nen Jose sota bakdang nen Jesus nodta koros, dinibotan to ni empotin dopot jet in‐ilaw to nodta baton diniyangan sha ja eg pay laeng na‐osal, jet shiman i indiyangan to so. ");
INSERT INTO ibl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Shanshani men mama‐shem nontan, ja si‐katoy panshoki ni akew wa panngidin ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sota ira bibiin nay‐olop son Jesus alid Galilia, timened ira so nen Jose et inon‐an shay naydiyangan ni bakdang nen Jesus tan sota itsora ni inkaysepa to. ");
INSERT INTO ibl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jet imakad ma ira ja ira mansekana ni emanseng‐ew wa dana ja kowan sha ey ipoyok sha nodta bakdang nen Jesus. Idi eẃa‐ẃa, nan‐inana ira tep si‐katoy akew wa ngilin ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Idi agsapen pasiya ni Domingko ja maykatdon akew, dimaw ira sota bibii nodta naydiyangan ni bakdang nen Jesus, jet engita‐jon ira nonta insaganaren emanseng‐ew wa dana. ");
INSERT INTO ibl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jet idi mimotok ira, inon‐an shen epolig ja ima‐adaw sota baton ebadeg ja istay naydekeb nodta diyang nga naydiyangan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Simekep ira nodta diyang, nem enshiy sha simbin bakdang nen Apo Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jet idi ireka manmodimodi bengat nodtan, ebiglen nanpa‐sas i showen anghil ja singa too i itsora sha nem emeneniliy baro sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sota ira bibii, injokmos shay dopara shi bo‐day ta etakot iren pasiya. Nem kowan nonta showen anghil son si‐kara ey, “Apay nga joka pan‐enaped ja kad‐an ni etey i toon mabiday? ");
INSERT INTO ibl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Enshi led jay, nan‐ongal da! Nemnem jo kari: inkowan to met nonta ẃara kayo pay laeng shi Galilia; kowan to nontan ey, ");
INSERT INTO ibl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Si‐kak sota kowan ira nonta para padto nonta bayag da ey Anak ni Too, nem mesepol la may‐eẃatak ma so nonta ira toon nankekedsel et bono‐en sha‐ak ja maydansa shi koros. Nem no maykatdon akew, man‐ongalak met laeng.’ ” ");
INSERT INTO ibl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ninemnem ma ira nonta bibii sota inkowan nen Jesus nontan da. ");
INSERT INTO ibl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Indekjas sha sota diyang et nay‐oli ired Jerusalem ja sha inkowan so nonta ira sawal ni sakey ya apostol nen Jesus tan so nonta eshom i emin na epasemak shi diyang. ");
INSERT INTO ibl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Say ngaran ira nonta bibiin en engikowan so nonta ira apostol nen Jesus, sajay: si Maria Magdalena, si Joana, tan si Maria ja ina nen Santiago, tan ẃara pay i eshom ma kait sha.) ");
INSERT INTO ibl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nem sota sodsod ira ni bibii, kowan nonta apostol ey notnotnot sha bengat et eg sha pinati. ");
INSERT INTO ibl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nem si Pedro, dimayat et bintik to lay diyang nga naydiyangan nen Jesus, jet idi niningil to, sota naydibot shi bakdang nen Jesus bengat i ẃara. Jet nay‐olin imakad ja toka nemnemnema ja emin sota epasemak. ");
INSERT INTO ibl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nontan met laeng nga akew, ẃaray showen too nen Jesus ja eman‐ekad ja ondaw ired ma kowan sha ey Imaos. Sampolo tan showen kilomitro i kabtaw tod Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Shaka pantabtabala i emin na epasemak nontan den akew. ");
INSERT INTO ibl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jet nonta maramen ireka mantabtabal, imesop si Jesus et nay‐olop son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inon‐an sha nem eg sha inimatonan. ");
INSERT INTO ibl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Imesel si Jesus ja kowan to ey, “Ngaran ni joka pantabtabala aya ni joka pan‐ekad?” Kimi‐neng sota shadẃa et ma‐sas shi dopara ey enshiy imdeng sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jet sota sakey, ja nanngaran ni Kliopas, kowan to ey, “Wara ka gayam shi Jerusalem niman ey eg mo amtay epasemak da nonta sajay den edabas sa akew?” ");
INSERT INTO ibl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jet inbag‐an ira nen Jesus ja kowan sha ey, “Ngarantoy epasemak?” Simongbat ira ey, “Waray toon inbetkag ali nen Apo Shiyos: si Jesus i ngaran to ja i‐Nasarit. Emin na totoo, kowan sha ey enshiy maka‐inges son si‐kato ni toka itoro tan toka dagdag‐a. Angken si Apo Shiyos, inges to emo ngoy kowan to pangkep son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nem sota ira apo ni papashi tayo, tan sota ira eshom ma toray ni ili, in‐awat sha so nonta ira toon i‐Roma say mebono koma et binonora ja indansara shi koros. ");
INSERT INTO ibl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Si‐kato komay namnama min mengisedakan ni Israel, nem binonora met. Jet maykatdon akew to niman. ");
INSERT INTO ibl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nem iyay pay i badon shamag: ẃara konoy kait min bibii ja bimowas den dimaw nodta naydiyangan ni bakdang nen Jesus, ");
INSERT INTO ibl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","jet eg sha kono simbiy bakdang to. Nay‐oli kono ira di et kowan sha ey inon‐an shay anghil ja engikowan son si‐kara ey nanbiyag mowan si Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jet sota eshom ma kait mi, dimaw ira ngo ja sha inon‐an, jet agpayso noman i inkowan nonta bibii. Nem eg sha inon‐an si Jesus.” ");
INSERT INTO ibl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kowan nen Jesus son si‐kara ey, “Apay nganto et ngoy eg jo so pati‐an na shagos ni emin na inkowan ni para padto nonta bayag da? ");
INSERT INTO ibl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Say inpadtora, mesepol la da‐kaman nonta ibetkag nen Apo Shiyos ja mengisedakan i digat ja inges nonta inkowan jo, asan ma mayshayaw shi dangit.” ");
INSERT INTO ibl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jet si Jesus, in‐olog ton emin son si‐kara sota naysolat nonta bayag da maypangkep son si‐kato, manshoki shi dibsho ira nen Moises tan emin na insolat ni para padto nen Apo Shiyos nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Idi imesop ira ma nodta dogad ja daẃan nonta showa, si Jesus, istay emankaisi‐jan ja singa ẃara pay i daẃan to. ");
INSERT INTO ibl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nem inpeked sha ja kowan sha ey, “Ka‐okip ked jay, ta mama‐shem malen emankedabi ma.” Jet inonod toy kowan sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ekisengo si Jesus son si‐kara shi damisaan, jet nontan, say inpasing to, inda to sota tinapay et nan‐iyaman son Apo Shiyos et pinet‐ing to, asan toka i‐ẃat son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jet idi pinet‐ing to sota tinapay, binigbig sha ma ey si‐kato gayam si Jesus! Nem nan‐omas shi sango‐an sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kowan shen showa ey, “Aliẃa aya ja singa ẃaray dinekna ten singa apoy shi poso ta nonta tokitaka pantabtabala shi shalan, tan nonta toka pengi‐odog ni naypadto nontan da?” ");
INSERT INTO ibl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Inedisto‐an shen nay‐oli shi Jerusalem et simbira sota sawal ni sakey ya apostol nen Jesus ja esa‐nop, tan ẃara pay i eshom. ");
INSERT INTO ibl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jet idi onsekep ira, kowan nonta esa‐nop pa too son si‐kara ey, “Agpayso gayam ma nanbiyag si Apo Jesus! Nanpa‐sas son Simon!” ");
INSERT INTO ibl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jet insodsod ngo nonta showa i emin na epasemak nonta inkay‐olop nen Jesus son si‐kara shi shalan, tan kowan sha ey, “Jet inimatonan min pasiya nonta pinet‐ing to sota tinapay!” ");
INSERT INTO ibl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Idi maramen shaka pan‐isodsod i epasemak son si‐kara, ngaran ni ẃara gayam si Jesus shi nankaẃa‐an sha! Kowan to son si‐kara ey, “Talna i meẃesha son si‐kayo!” ");
INSERT INTO ibl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Etakot iren pasiya ta say ẃared nemnem sha, kowan sha ey banig i inon‐an sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nem kowan nen Jesus son si‐kara ey, “Apay nga kayoka manshanag, ja itan pay i showashowa ni nemnem jo? ");
INSERT INTO ibl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","On‐iyo iya takday ko tan sedik. Eg jo aya idasin ey si‐kak? Pirat jowak say pati‐en jo ey aliẃen banigak. Ta say banig, enshiy daman to tan pokel to, nem si‐kak, ẃara.” ");
INSERT INTO ibl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Idi inkowan to iyay, inpa‐oney to son si‐karay takday to tan sedi to. ");
INSERT INTO ibl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jet na‐imdengan ira, nem singa eg sha pay laeng pati‐en ey agpayson si‐kato. Eg ira pay mepnek, isonga inbaga nen Jesus ey, “Waray mebedin na mekan shiyay?” ");
INSERT INTO ibl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jet in‐aknan sha ni ootik ka edoton piskaw ja sid‐an to. ");
INSERT INTO ibl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inda to et kinan to say on‐an sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jet kowan to son si‐kara ey, “Say inkowan ko nonta ẃara‐ak pay laeng son si‐kayo, emin sota naysolat ja maypangkep son si‐kak nonta bayag da shi bilin nen Moises tan shi solat ira nonta para padto, tan shi dibsho pay ni Salmo, mesepol la metongpal.” ");
INSERT INTO ibl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jet dineẃagan toy nemnem sha say eẃatan shen emin i inpaisolat nen Apo Shiyos nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jet kowan to son si‐kara ey, “Say insolat nonta ira para padto nen Apo Shiyos nonta bayag da, kowan sha ey sota ibetkag ali nen Apo Shiyos ja mengisedakan, mesepol la da‐kaman toy digat asan matey, nem no maykatdon akew, manbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Tan say inpadtora pay, kowan sha ey maytosho shi emin na ka‐ili‐ilin sakop niya dobong ey mesepol la manbebawi komay totoo ni basol sha say pekawanan ira nen Apo Shiyos. Inpadtora pay ey say mengitosho, si‐kayon mengi‐edagey son si‐kak, jet ishogi jo konod Jerusalem. Si‐kayoy ondaga so niyay tep mismon inon‐an jo iya epasemak son si‐kak niman na timpo. ");
INSERT INTO ibl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jet iyay pay: ibetkag ko sota Ispirito Santo nen Apo Shiyos ja Amak ja inkari ton pan‐iyan to son si‐kayo. Nem panseked kayo nin shiya Jerusalem ingkatod eẃaten jo sota panakabalin nonta Ispirito Santo ja edapod dangit.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Inbalnay to ira ingkatod ma dogad ja nay‐esop shi Bitania. Jet inkayang toy takday to ja binindisiyonan to ira. ");
INSERT INTO ibl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jet idi maramen toka panbindisiyoni ira, indekjas to iren kimayang mala shi dangit. ");
INSERT INTO ibl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jet nantalimokod ira sota apostol ja nanshayaw son si‐kato, asan ireka oli maled Jerusalem ma epaladoy imdeng sha. ");
INSERT INTO ibl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jet kanajon ma ired Timplo ja emanshedjaw tan eman‐iyaman son Apo Shiyos.");
INSERT INTO ibl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nonta eg pay laeng epalsowa iya dobong, ẃara ngo eshan i kadẃa nen Apo Shiyos, jet sotan na kadẃa toy engipa‐amta alid ja dobong ni maypangkep son Apo Shiyos. Jet si‐kato met laeng si Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sigod sotan ja ẃara ngo eshan son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jet si‐katoy kabol la edaga‐an ni emin na angken nganto. No enshi sotan, enshi ngoy epalsowen angken nganto. ");
INSERT INTO ibl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Si‐katoy engi‐kan ni biyag jet sota biyag ja in‐akan to, si‐katoy dimawag so ni nemnem ni totoo. ");
INSERT INTO ibl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Emansidew sotan shi embolinget, jet sota embolinget, eg to mebedin na ebaken sota silew. ");
INSERT INTO ibl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Si Apo Shiyos, ẃaray inbetkag ton too ja si Juan i ngaran to. ");
INSERT INTO ibl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sajay ya too, si‐katoy inbetkag nen Apo Shiyos ja en mengikowan so ni totoo maypangkep nonta ondaw alin toon may‐eshig ey emansidew shi embolinget ja ondawag ni nemnem ni totoo, say emin na mengitneng ni kowan nen Juan, memati ira nonta toon ondaw ali. ");
INSERT INTO ibl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Si Juan, si‐katoy en engikowan bengat ni maypangkep nonta ondaw alin ondawag ni nemnem ni totoo; aliẃen si‐kato sotan na ondaw ali. ");
INSERT INTO ibl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sajay ya dimaw alid ja dobong, si‐katoy podnon kaondawag ni nemnem ni emin na totoo. ");
INSERT INTO ibl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Si‐katoy kabol la epalsowa‐an ni dobong, nem idi dimaw ali, eg binigbig ni tood ja dobong ey si‐kato sotan. ");
INSERT INTO ibl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dimaw pay shi mismon ili to, nem sota kaidiyan tod man, eg sha ineẃat. ");
INSERT INTO ibl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nem sota emin na too ja engawat son si‐kato, ono emati son si‐kato, inkowan to ey nebeng shen maybidang ey annak ma nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Say itsora ni kaybidangan ni totoo ey annak nen Apo Shiyos ket kabol nonta panakabalin nen Apo Shiyos; aliẃen inges toy itsora ni kay‐enak ni too so ni maka‐anak so, tep say too, ẃaray nemnem sha ey man‐enak koma ira, tan sakey pay, shaka i‐onod i dekna ni bakdang sha; isonga sotan i kabol la kay‐enaki ni too. ");
INSERT INTO ibl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sotan na sigod ja ẃara son Apo Shiyos, ja engipa‐amta ali ni maypangkep son Apo Shiyos, nanbalin ni too, jet eki‐iyan son si‐katejon too. Inon‐an min mismoy kina‐Shiyos to — sota kina‐Shiyos ja in‐akan nen Ameto ta si‐kato bengat i Anak to. Emin na inon‐an min dingka to, ma‐sas ni olay ey ebadeg i semek to tan podnon emin i kowan to. ");
INSERT INTO ibl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si‐kato sota torong nonta kowan nen Juan nonta inkeljaw to ey, “Sajay sota inkowan ko ey ondaw ali ja maysa‐dat son si‐kak. Sajay, engatngatoy saad to ey say si‐kak tep sigod ja ẃara ngo eshan iyay nonta ekak pay laeng nay‐anak.” Sotan i inpaneknek nen Juan. ");
INSERT INTO ibl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Saja dimaw ali son si‐katejo, ebadeg ga pasiyay semek to, jet engi‐kan ni nansigshan tayon emin. ");
INSERT INTO ibl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Siya, si‐kato si Jesucristo et inpawasha toy semek shiya dobong. Jet si Moises ngo nonta bayag da, inpawasha to sota sigod ja bilin nen Apo Shiyos, nem si Jesucristo i engitosho ni podnon olog nontan na bilin. ");
INSERT INTO ibl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Angken sipa, enshiy en engasas son Apo Shiyos, nem eg sota sesakey bengat ja Anak to. Sajay ya Anak to pay i engipa‐amta ni maypangkep son Apo Shiyos ja Ameto. ");
INSERT INTO ibl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sota ira pangolo ni Hodiyos shi Jerusalem, engibetkag ira ni papashi tan sota ira kaontolong so nonta papashi, ja en mengiro‐pet son Juan nem ngarantoy koston saad to. ");
INSERT INTO ibl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jet inkowan nen Juan i agpayso son si‐kara, ja kowan to ey, “Aliẃen si‐kak sota naypadto nonta bayag da ey ibetkag ali nen Apo Shiyos ja mengisedakan.” ");
INSERT INTO ibl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Insho‐petan sha pay ja kowan sha ey, “Jet sipa ka ngarod? Si‐kam sota naypadton ondaw ali ja maykadẃen idaw ali nen Elias?” Say songbat nen Juan, “Enshi, aliẃen si‐kak.” Jet kowan sha mowan son si‐kato ey, “No kasta, si‐kam ali sota para padton tayoka sesseskeren ibetkag ali nen Apo Shiyos?” Simongbat si Juan ja kowan to mowan ey, “Aliẃen si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jet inbag‐an sha mowan ja kowan sha ey, “Ikowan mo ga no sipa ka, say ẃaray ikowan mi so nonta ira engibetkag son si‐kami. Jet sipa ka ngarod?” ");
INSERT INTO ibl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Si Juan, simongbat ja kowan to ey, “Si‐kak i kaytoshongan nonta padto nen Isaias nonta bayag da ja kowan to ey ẃara aliy toon ikeljaw toy esel to shima dogad ja nay‐araẃi shi ili, ja kowan to ey, ‘Pandeteg joy shalan na pan‐akshan nen Apo!’ ” ");
INSERT INTO ibl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jet sajay iren inbetkag ni Parisiyo, ");
INSERT INTO ibl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kowan sha pay so nen Juan ey, “Apay ngarod nga kaka memonjag, no aliẃen si‐kam sota naypadton ibetkag ali nen Apo Shiyos, ono sota mengibengon son Elias, ono sota para padton tayoka sesseskera ja ondaw ali?” ");
INSERT INTO ibl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jet si Juan, simongbat son si‐kara ja kowan to ey, “Shanom i naka osala ni naka pemonjag so ni totoo, nem ẃara son si‐kayoy naydaok ja eg jo amta, ");
INSERT INTO ibl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","jet si‐kato aliy maysa‐dat son si‐kak. Ebadbadeg i panakabalin to ey say si‐kak, jet ekak pay maykeshi ja angken baga‐en to komen mengokas ni kalot ni sapatos to.” ");
INSERT INTO ibl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Emin iyay, edaga shi Bitania, ja baliw nonta pa‐dok ja kowan sha ey Jordan, ja emonjagan nen Juan. ");
INSERT INTO ibl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Idi nonta eẃa‐ẃa, si Juan, inon‐an tos Jesus ja emandaw son si‐kato, jet kowan to ey, “Sajay sota mengikesho ni basol ni totood dobong ni ketey to di. Si‐katoy may‐eshig ey singa kalniron in‐akan nen Apo Shiyos ja maydeton. ");
INSERT INTO ibl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sajay sota inkowan ko son si‐kayo ey ondaw ali, ja maysa‐dat son si‐kak. Sajay, engatngato i saad to ey say si‐kak, ta sigod ja ẃara ngo eshan nonta ekak pay laeng nay‐anak. ");
INSERT INTO ibl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jet angken si‐kak, istay ya ekak amta no sipay toshongen nonta naypadto nonta bayag da ey ondaw ali, nem say kawashak niman shiyay ja emengosal ni shanom ni naka pemonjag ket say amta‐an ni tood Israel nem sipa sota naypadton ondaw ali. ");
INSERT INTO ibl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jet amtak ma tep inon‐an koy Ispirito Santo nen Apo Shiyos alid dangit ja emandespag ja singa inges toy itsora ni kalopati. Simepa et imonong son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Istay ekak pay laeng amta ey si‐kato sota kaytoshongan nonta padto, nem si Apo Shiyos, ja engibetkag son si‐kak ja memonjag ja shanom i osalen ko, inkowan to pay ey sota asen ko ja despagan ni Ispirito Santo to ja pan‐iyanan to, si‐kato sotan na too ja say pemonjag to di ket Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jet sajay ya naka pan‐ikowan na inon‐an ko, sajay sota Anak nen Apo Shiyos.” Kowan nen Juan. ");
INSERT INTO ibl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Idi eẃa‐ẃa mowan, kadẃa nen Juan sota showen too to. ");
INSERT INTO ibl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Inon‐an tos Jesus ja eman‐ekad, jet kowan nen Juan ey, “Sajay sota may‐eshig ey kalniron in‐akan nen Apo Shiyos ja maydeton.” ");
INSERT INTO ibl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jet sota showen too nen Juan, intenengan sha iya inkowan nen Juan jet imonod ira so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Si Jesus, ẃiningi to ira ja eman‐onod ali son si‐kato, jet kowan to ey, “Ngarantoy ibaga jo?” Jet kowan sha son si‐kato ey, “Maistoro, toway moka pan‐iyani?” ");
INSERT INTO ibl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Si Jesus, kowan to ey, “Kalejo say jo asen.” Ekidaw ira son Jesus jet inon‐an sha i toka pan‐iyani. Jet nontan na akew, sota ira showen too, eki‐iyan ira nin son Jesus, ta mama‐shem mala ja oras ni alas kowatro. ");
INSERT INTO ibl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Say sakey so nonta engitneng ni inkowan nen Juan pangkep so nen Jesus, si Andres ja agi nen Simon Pedro. ");
INSERT INTO ibl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Si Andres, dimaw wa shagos, ja to simbi si Simon ja agi to, jet kowan to son si‐kato ey, “Simbi mi sota tayoka sesseskeshen ibetkag ali nen Apo Shiyos!” (Say piyan ton a‐seden, simbira sota naypadton ibetkag nen Apo Shiyos ja mengisedakan.) ");
INSERT INTO ibl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Si Andres, inodop to si Simon ja dimaw ira son Jesus, jet si Jesus, inningning tos Simon jet kowan to son si‐kato ey, “Si‐kam si Simon ja anak nen Juan. Jet say ingaran ko ma son si‐kam niman, si Cipas, ono Pedro.” (Nan‐inges i olog niya showen inngaran to son Simon, ja say piyan ton a‐seden, bato.) ");
INSERT INTO ibl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Idi eẃa‐ẃa mowan, si Jesus, ninemnem ton ondaw shi Galilia, jet simbi to si Felipe shiman ja kaidiyan nen Andres nen Pedro ja i‐Bitsaida. Kowan nen Jesus son Felipe ey, “Kala, kay‐olop ka son si‐kak say manbedin ka men took.” ");
INSERT INTO ibl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jet si Felipe, simbi tos Natanael, jet inkowan nen Felipe son si‐kato ey, “Wara ma niman sota inpadto nen Moises ja insolat tod dinteg tan insolat nonta ira para padto. Jet inaspol mi! Say ngaran to, Jesus. Si‐kato ket i‐Nasarit ja potot nen Jose.” ");
INSERT INTO ibl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jet si Natanael, simongbat ja kowan to ey, “Apay ẃara ayay mapteng nga mandepod Nasarit?” Jet kowan ngo nen Felipe ey, “Eti, mo asas.” ");
INSERT INTO ibl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jet si Jesus inon‐an to alis Natanael, ja emandaw son si‐kato, jet kowan to ey, “Iyay ali i podnon i‐Israel. Emin na ẃara son si‐kato, agpayso.” ");
INSERT INTO ibl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jet si Natanael, inbag‐an tos Jesus ja kowan to ey, “Ita et mangon amtamak?” Si Jesus, simongbat ja kowan to ey, “Nonta ẃara ka pay laeng ja nansirom shi kadasan, ja eg toka pay laeng inodop nen Felipe, inon‐an taka.” ");
INSERT INTO ibl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jet si Natanael, simongbat ja kowan to ey, “Maistoro, amtak ma ey si‐kam sota Anak nen Apo Shiyos! Si‐kam i Ari ni tood Israel!” ");
INSERT INTO ibl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jet si Jesus, simongbat ja kowan to ey, “Kaka memati ta inkowan ko ey inon‐an taka ja nansirom shi kadasan. Jet mas ẃara pay i asen mo ali ja kaskasshaaw ey say sajay. ");
INSERT INTO ibl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kinapodpodno to iya ikowan ko son si‐kam. Asen jo i dangit ja medo‐katan, jet asen jon ẃaray anghil nen Apo Shiyos ja ondespag ali son si‐kak jet on‐oli mowan shi dangit, ta si‐kak sota kowan sha ey Anak ni Too.” ");
INSERT INTO ibl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nonta maykatdon akew, ẃaray nankasal shi Kana, ja sakop ni Galilia, jet si Maria ja ina nen Jesus, dimaw nodtan na kasal. ");
INSERT INTO ibl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jet si Jesus tan sota ira too to, ineẃis sha ira nodtan na kasal. ");
INSERT INTO ibl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nodta kasal kimolang i inom, jet sota ina nen Jesus, inkowan to son Jesus ey, “Na‐bos gayam day inomen ni too.” ");
INSERT INTO ibl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jet si Jesus, kowan to ey, “Nanang, eg mesepol la ikowan mo son si‐kak i dag‐en ko. Aneng nin i pandekak ni obden in‐akan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jet si Maria ja ina nen Jesus, inkowan to so nonta ira emankemakam nodta kasal ey, “No ngantoy ikowan nen Jesus, patiyo.” ");
INSERT INTO ibl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jet nodtan, ẃaray enem ma salaw ja epat ono dimen daten shanom i ka‐iyana ni sakey. Sajay i shaka pan‐oshasi ni shaka pengonod ni ogadira ja shaka pesing nin asan ireka mangan. ");
INSERT INTO ibl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jet si Jesus, inkowan to nonta ira emankemakam ey, “Penoyo ni shanom sota ira salaw.” Jet sota ira emankemakam, pinnora sota ira salaw. ");
INSERT INTO ibl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jet si Jesus, inkowan to ey, “Panaol kayo ma shita salaw jet pangdoyo nin ja itagajan sota emengimanshal ni kasal.” Enaol ira et sha in‐aknan sota emengimanshal ni kasal. ");
INSERT INTO ibl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jet sota emengimanshal ni kasal, ninamtan to sota in‐akan sha ja nanbalin ma ni inom, nem eg to amtay edapo‐an to. (Nem sota ira emankemakam shi kasal ja enaol, amtara mango.) Jet sota emengimanshal ni kasal, tina‐ẃal to ali sota dakin engaseẃa, ");
INSERT INTO ibl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","jet kowan to son si‐kato ey, “Say amtak ka ogadi tayo, shaka nin pangdo‐a sota en‐amis sa inom, jet no asdeg to malay ininom nonta ira totoo, angken sota endamsis malen inom i itagay sha. Nem si‐kam, iyay gayam i in‐emot mon mas en‐am‐amis ja inpan‐onod mon itagay.” ");
INSERT INTO ibl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sajay ya dingka nen Jesus shi Kana, si‐katoy pilmiron dingka ton milagro. Inpa‐sas toy kina‐Shiyos to et sota ira too to, emati ma iren koskosto son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jet idi enaksheng iyay, si Jesus, dimaw shi Kapirnaom, jet ekidaw si ineto, sota a‐aki to, tan sota ira too to. Nan‐iyan nin ired man ni pigen akew. ");
INSERT INTO ibl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nontan na timpo, shanshani ma sota piyasta ni Hodiyos ja kowan sha ey Paskowa, jet si Jesus, dimaw shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jet shima Timplo, simbi to ired man sota emandeko ni baka, kalniro, kalopati, tan ẃara pay iray toon timanongaw ja emena‐dat ni pilak. ");
INSERT INTO ibl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Si Jesus, engamag ni baras ja ẃanet jet shinagshag to iren emin, pati sota kalniro, tan sota baka, ja inpabo‐day to ira nodta Timplo, jet angken sota pilak nonta timongaw wa emena‐dat, intikbo to, jet tino‐to‐dang to pay sota ira damisaan sha. ");
INSERT INTO ibl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jet inkowan nen Jesus so nonta ira emandeko ni kalopati ey, “Ekal jon emin iya ẃared jay! Aliẃen jo panbedin iya baley nen Amak ni dako‐an!” ");
INSERT INTO ibl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jet sota ira too to, ninemnem sha nontan sota padton naysolat nonta bayag da ey, “Apo Shiyos, sota naka pengisekit ni baley mo, si‐kato met laeng i onsharal son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jet sota ira pangolo ni Hodiyos, kowan sha son si‐kato ey, “Ngaranton milagro i ipa‐sas mo son si‐kami ja amta‐an mi so ey si‐kam ket podnon inbetkag ali nen Apo Shiyos? No ẃara, siya, memati kami ey ẃaray kalintegan mon dimaga so niyay.” ");
INSERT INTO ibl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Si Jesus, simongbat ja kowan to ey, “Sharal jo iyay ya timplo, jet no maykatdon akew, i‐olik met laeng ja dag‐en.” ");
INSERT INTO ibl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jet sota ira Hodiyos, kowan sha ey, “Epat ta polo tan enem ma tawen i indaga sha so niyay ya Timplo, ey tedon akew bengat i i‐olim so no mesheshal?” ");
INSERT INTO ibl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","(Nem say piyan nen Jesus ja a‐seden niya timplon kowan to ket aliẃen sota Timplon to‐to‐ẃa, no diket sota ketey ni bakdang to tan sota pan‐ongal to nem maykatdon akew. ");
INSERT INTO ibl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Isonga nonta inpan‐ongal nen Jesus nonta maykatdon akew ni inkatey to, ninemnem nonta ira too to sotan na inkowan to, jet sajay i kabol la pinati‐an sha so ni emin na inpasodat nen Apo Shiyos nonta bayag da, tan sota emin na inkowan nen Jesus.) ");
INSERT INTO ibl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jet nontan na timpo ni piyasta ni Hodiyos ja kowan sha ey Paskowa, eshakel i emati son Jesus shi Jerusalem, ni in‐asas sha so nonta kaskasshaaw ja dingka to. ");
INSERT INTO ibl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nem si Jesus, eg to ira piyalen; isonga eg to inpodno nontan i emin na maypangkep son si‐kato, ");
INSERT INTO ibl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ta amta ton emin i itsora ni too, jet eg mesepol la ẃaray mengikowan son si‐kato ni maypangkep ni too, ta amta to i ẃared nemnem sha. ");
INSERT INTO ibl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Waray Parisiyo ja manngeshan ni Nikodimo, ja sakey ya pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sajay ya too, dimaw son Jesus ni edabi, jet kowan to ey, “Maistoro, si‐kam, amta mi ey inbetkag token Apo Shiyos ja menosho son si‐kami, ta angken sipa, enshiy ondaga so nonta dingkam ma kaskasshaaw, no enshis Apo Shiyos son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jet si Jesus, simongbat ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kam. Angken sipa, eg mebedin na asen toy pantoshayan nen Apo Shiyos, no eg may‐enak mowan.” ");
INSERT INTO ibl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jet si Nikodimo, simongbat ja kowan to ey, “Toway pesing ni toon may‐enak mowan ey bima‐deg ma? Apay mebedin aya, ja on‐oli mowan shi anakan nen ineto jet asan may‐anak mowan?” ");
INSERT INTO ibl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Si Jesus simongbat, ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kam. Angken sipa, eg mebedin na mayda‐kam shi pantoshayan nen Apo Shiyos, no eg may‐enak mowan, ta say kedepo‐i niya biyag, shanom tan Ispirito Santo nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sota i‐anak ni too, etoo‐an i ogadi to, nem sota toon kawad‐an ni Ispirito Santo nen Apo Shiyos, ja singa nay‐anak mowan, say ogadi to, inges to ngoy Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kareka messhaaw niya inkowan ko ey si‐kayon too, mesepol la may‐enak kayo mowan. ");
INSERT INTO ibl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Say kay‐eshigan ni Ispirito Santo nen Apo Shiyos, saja shagem. Say shagem, sota piyan ton toshongen, si‐kato. Moka itenengi i bongog to, nem eg mo amtay edapo‐an to, ono daẃan to. Sajay i kay‐eshigan nonta may‐enak mowan ja kawad‐an ni Ispirito Santo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jet si Nikodimo, simongbat ja kowan to ey, “Toway pesing niyay ya inkowan mo?” ");
INSERT INTO ibl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Si Jesus, simongbat mowan na kowan to ey, “Eg mo gayam amta iyay, ey eshayaw ka pay ya maistoro ni pamati tayon Hodiyos? ");
INSERT INTO ibl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kinapodpodno iya ikowan ko son si‐kayo. Say mika pan‐ikowan, sota amta mi, tan say mika penekneki, sota inon‐an mi. Nem si‐kayo, eg jo pati‐en i kowan mi. ");
INSERT INTO ibl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Inkowan ko son si‐kayo i maypangkep ni saja dobong jet eg jo pinati. Ma‐ma ton eg jo pati‐en no ikowan ko son si‐kayo i maypangkep ni dangit. ");
INSERT INTO ibl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Angken sipen too, enshiy en dimaw shi dangit, nem eg si‐kak bengat, ja kowan sha ey Anak ni Too; shiman aliy edapo‐an ko. ");
INSERT INTO ibl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Si Moises, indansa tod kiyew sota sinan oleg ja boronsi, asan toka ikedjang nonta bayag da, ja kawashared ma nan‐ak‐akshan shen enshiy koston pan‐iyanan sha. Jet si‐kak ja kowan sha ey Anak ni Too, inges niyay ngoy pesing sha son si‐kak, ");
INSERT INTO ibl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","jet sota emin na memati son si‐kak, may‐aknan ni biyag ja enshiy to pengintegan. ");
INSERT INTO ibl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ta si Apo Shiyos, ensemek ton pasiya i totood ja dobong; isonga in‐akan to ali sota saksakey bengat ta Anak to, say sota emin na memati so nontan na Anak to, eg meshosa ni ingkatod ingka, no diket may‐aknan ira ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta si Apo Shiyos, aliẃen inbetkag to ali sota Anak tod ja dobong ja si‐katoy mengigsheng ey meshosa iray totoo, no diket say isalakan to koma ira. ");
INSERT INTO ibl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Isonga sota memati son si‐kato, eg meshosa, nem sota eg memati son si‐kato, kenshat ta meshosa iren ingkatod ingka, ta eg memati nodta saksakey bengat ta Anak nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jet say kabol la keshosa‐an sha, sota eg sha kosto‐an so nonta inbetkag ali nen Apo Shiyos ja ondawag so ni nemnem sha. Say piniyan ni too et ngo mowan, sota pandegdeka ni ngaaw, ja angken eg medeẃagan i nemnem sha. ");
INSERT INTO ibl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jet sota ira ngaaw i aramid sha, shaka a‐dema ja on‐esop son si‐kak ta entakot ira ey deẃagan koy aramid shen ngaaw. ");
INSERT INTO ibl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nem sota toon podnoy toka dagdag‐a, si‐karay kaon‐es‐esop son si‐kak, say medeẃagan ey si Apo Shiyos i edapo‐an ni mapteng nga aramid sha.” ");
INSERT INTO ibl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Idi enaksheng iyay, si Jesus tan sota ira too to, dimaw ired sakop ni Jodia. Jet si Jesus, eki‐iyan nin shiman tep emonbonjag nin. ");
INSERT INTO ibl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan ja para bonjag, ẃara ngo shi Inon, ja nay‐esop shi Salim. Shiman i toka pemonjagi, tep eshakel shiman i shanom. Jet sota ira totoo, dimaw ired man na en nanpabonjag. ");
INSERT INTO ibl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tep nontan na timpo, aneng nin i kaybedod nen Juan. ");
INSERT INTO ibl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sota too ira nen Juan, tan sota sakey met laeng nga Hodiyos, ẃaray eg sha nan‐inawatan pangkep ni pemonjag. ");
INSERT INTO ibl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jet sota too nen Juan, dimaw ira son si‐kato, jet kowan sha ey, “Maistoro, moka tanshaani sota kadẃam nontan shi baliw ni pa‐dok ka Jordan? Sotan met sota toon intorom son si‐kami ja maysa‐dat son si‐kam. Niman, ememonjag kono met, jet eshakel i toon emandaw son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Simongbat si Juan ja kowan to ey, “No si‐kak, ekak ma‐epal nonta eshakel la emandaw son si‐kato, ta emin na too, say kedepo‐i ni saad sha, si Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Intenengan jon mismo i inkowan ko, ey si‐kak ket aliẃen si‐kak sota inbetkag ali nen Apo Shiyos ja mengisedakan, no diket si‐kak, epangdo‐ak bengat ali ja en mengikowan ni totoo say mesekana iren memati son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Say kay‐eshigan to, singa si‐kak i mengisekana ni mesepol nonta kajem kon mengesawa. Jet niman, en simbi nonta daki sota esaw‐en ton bii, jet naka man‐imdeng men pasiya, ta si‐katoy talaken on‐aseẃa nontan na bii; isonga ekak ma‐epal. Niman, ta intenengan koy esel to, mas naka man‐imdeng. ");
INSERT INTO ibl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mesepol la si‐kato may tangkaken ni totoo, nem si‐kak, nebeng ngon mekodangan sota sigod ja inpanangkak ni too son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ta sota edapo alid naykayang, si‐kato ngo eshan i kangeto‐an ni emin. Si‐kak, ta edapo‐ak shiya dobong, say amtak ngo, ono naka ikowan, sota maypangkep ni saja dobong. Jet si‐kato, ja edapod dangit, ");
INSERT INTO ibl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","say toka pan‐ikowan, sota maypangkep ni inon‐an to tan sota intenengan to shi dangit. Emin na too, istay memati ira koma, nem ootik met i memati ni toka pan‐ikowan. ");
INSERT INTO ibl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nem sota toon ememati ni toka pan‐ikowan, si‐karay ememati ngo ey podnon emin i kaikowan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta sota mismon inbetkag nen Apo Shiyos, say toka ikowan, sota mismon esel nen Apo Shiyos, ta eg nagshengan i panakabalin ni Ispirito Santo ja in‐akan nen Apo Shiyos son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Si Apo Shiyos, ensemek to sota Anak to, isonga emin na banag, in‐awat to so nonta Anak to. ");
INSERT INTO ibl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sota toon memati so nonta Anak nen Apo Shiyos, may‐aknan ni biyag ja enshiy to engintegan, nem sota eg memati so nonta Anak nen Apo Shiyos, eg may‐aknan nonta biyag ja enshiy to engintegan, no diket emansessesked son si‐kato sota penosa nen Apo Shiyos ja shosen ingkatod ingka.” ");
INSERT INTO ibl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Sota ira Parisiyo, shinemag sha ey eshakel konoy panbonjagi nen Jesus ja manbedin ni too to, jet ootik malay emandaw so nen Juan. (Nem aliẃen agpayso sotan na shamag sha. Enshiy en binonjagan nen Jesus; no diket say ememonjag, sota ira too to.) Idi inamta‐an nen Jesus iyay ya shamag, ");
INSERT INTO ibl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","indekjas shay Jodia et nay‐oli ired Galilia, ");
INSERT INTO ibl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","jet nanshalan ired Samaria ni indaw shed man, ta si‐katoy nay‐esop pa shalan. ");
INSERT INTO ibl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jet nontan na inpanshalan shed man, minotok shay Sikar ja sakop met laeng ni Samaria. Sotan na dogad, nay‐esop nodta bo‐day nen Jacob nonta bayag da, ja in‐akan to so nen Jose ja anak to. ");
INSERT INTO ibl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jet nodtan na dogad, si‐katoy kawad‐an nonta ba‐ẃek ja asolan nen Jacob nontan da. Si Jesus, ta enabdey ni inpan‐akad sha ali, en timongaw nodta nay‐esop shi asolan na ba‐ẃek. Say oras nontan, alas dosi ni ka‐akawan. ");
INSERT INTO ibl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jet emin sota too nen Jesus, dimaw ired siyodad ja en menongkal ni kenen sha. Jet si Jesus ngo nontan, ka‐onong nga ẃara nodta nay‐esop shi ba‐ẃek. Naytompong nga ẃaray biin i‐Samaria ja dimaw alin en man‐esol nodtan. Jet si Jesus, inkowan to so nonta bii ey, “I‐aknimak ka di ni shanom ma inomen ko.” ");
INSERT INTO ibl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sota bii, nasshaaw jet kowan to ey, “Ita et mangon kaka manbeka son si‐kak ni shanom ma inomen mo ket i‐Samaria‐ak, ey si‐kam, Hodiyos ka?” (Sajay i inkowan nonta biin i‐Samaria, ta say Hodiyos, ensekig shay i‐Samaria.) ");
INSERT INTO ibl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jet si Jesus, simongbat ja kowan to ey, “No amtam koma sota pan‐i‐akan nen Apo Shiyos, ono amtam koma sota emanbeka son si‐kam niman ni shanom, istay ibag‐an mowak koma, jet i‐aknan taka ni shanom ma mengi‐kan ni biyag.” ");
INSERT INTO ibl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jet sota bii, simongbat ja kowan to ey, “Apo, enshi met i taol mo ja penaol. Ta sama asolan, naydeshek; toway pengal‐an mo ni shanom ma mengi‐kan ni biyag? ");
INSERT INTO ibl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Say kimaot so niyay ya asolan, si Jacob ja makapoli son si‐katejo, jet sajay ya ba‐ẃek i toka pan‐esoli da nontan, tan shiyay pay i pan‐esoli ira nonta annak to, tan pan‐inomi ira nonta animal to. Apay engatngato ka aya ey say si Jacob da?” ");
INSERT INTO ibl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jet si Jesus, simongbat ja kowan to ey, “Sota menginom niyay ya shanom, messho, ono ma‐kew mowan. ");
INSERT INTO ibl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nem sota shanom ma naka pan‐i‐akan, si‐kato sota biyag ja enshiy to engintegan, jet sota on‐inom so, eg mowan messho, ono ma‐kew, ta ẃara ni olay son si‐kato, ja singa inges to sota temtem ja eg ma‐ma‐ti‐an.” ");
INSERT INTO ibl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jet sota biin i‐Samaria, kowan to ey, “Apo, i‐aknimak nita shanom ma kowan mo, say ekak ma messho, tan say ekak mebmebdey alin en man‐esol.” ");
INSERT INTO ibl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jet si Jesus kowan to son si‐kato ey, “Daw ka, mo di olop si aseẃam.” ");
INSERT INTO ibl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sota bii, simongbat ja kowan to ey, “Enshiy aseẃak.” Jet si Jesus, kowan to ey, “Kostoy insongbat mo, ja kowan mo ey enshiy aseẃam, ");
INSERT INTO ibl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta dimen daki i engaseẃa son si‐kam, jet sota dakin kadẃam niman, aliẃen si‐katoy aseẃam; isonga naka pati‐a ita kowan mo ey enshiy aseẃam.” ");
INSERT INTO ibl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jet sota bii, kowan to ey, “Apo, naka eẃati ma ey si‐kam, para padto ka gayam nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Isonga niman, iyay i piyan kon ibaga son si‐kam. Sota appo mi da, inkowan sha ey sota shontog shiyay ya dogad i panshedjawan mi son Apo Shiyos. Nem si‐kayon Hodiyos, say kowan jo kono ngo, shi Jerusalem i koston en panshedjawan ni emin na too son Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jet si Jesus kowan to so nonta bii ey, “Patim iya naka pan‐ikowan. Waray timpon onsabi ali ja say panshedjaw son Apo Shiyos, aliẃen sota idaw nodta shontog shiyay, ono shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Si‐kayon i‐Samaria, eg jo amtay Shiyos ja joka panshedjawa, nem si‐kamin Hodiyos, amta miy mika panshedjawa, ta si‐kamiy kedepo‐an nonta toon mengisedakan ali. ");
INSERT INTO ibl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jet niman, simabi ma sota timpo, ja say koston panshedjaw son Apo Shiyos ja Ama, mesepol la sota podno ja mandepod poso, tep si Apo Shiyos ja Ametayo, sajay i piyan ton pesing nga manshedjaw son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Apo Shiyos, Manakabalin; angken toway daẃan mo, ẃara ngo eshan si Apo Shiyos. Isonga sota toon manshedjaw son si‐kato, mesepol la podnoy panshedjaw to ja medepod poso to, ta sotan i piyan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jet sota bii, kowan to son Jesus ey, “Wara konoy ibetkag ali nen Apo Shiyos ja mengisedakan jet ma‐eẃagan kono alin Cristo, jet no ondaw ali, idawag to konon emin i angken nganto.” ");
INSERT INTO ibl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Si Jesus, simongbat jet kowan to so nonta bii ey, “Si‐kak ja katabtabal mo niman, si‐kak sotan na mismo.” ");
INSERT INTO ibl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jet nontan na maramen emekitbal si Jesus so nonta biin i‐Samaria, mimotok sota ira too nen Jesus ja en enongkal ni mekan shi siyodad, jet nasshaaw iren pasiya ta ẃaray biin toka pantabtabala. Nem angken sakey nodta too nen Jesus, enshiy en engibeka son Jesus, no ngarantoy mesepol nonta bii, ono apay nga emekitbal so nonta bii. ");
INSERT INTO ibl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sota bii, indekjas to sota in‐asol to, jet nay‐olid siyodad, jet to inkowan so nonta ira totood man, ");
INSERT INTO ibl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ja kowan to ey, “Kalejo, jo asas kari sota tood man. Sajay ya too, amta ton emin sota dingdingkak nontan da, jet inkowan to son si‐kak. Sigosho, sajay sota kowan sha ey ibetkag ali nen Apo Shiyos ja mengisedakan.” ");
INSERT INTO ibl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jet nontan ma, sota emin na totoo nodta siyodad, dimaw ira ja sha inon‐an si Jesus nodta kad‐an to. ");
INSERT INTO ibl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Idi enshi mala sota bii, inkowan ngo nonta ira too nen Jesus son si‐kato ey, “Apo, pangan ka!” ");
INSERT INTO ibl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nem si Jesus, simongbat ja kowan to ey, “Waray naka kena, ja eg jo amta.” ");
INSERT INTO ibl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jet sota ira too to, nanbibinaga ira ja kowan sha ey, “Sigosho ẃaray engi‐kan ali ni kinan to?” ");
INSERT INTO ibl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Si Jesus kowan to son si‐kara ey, “Say singa naka kena, ja emengi‐kan ni kedsang ko, sota pandekak ni piyan nen Apo Shiyos ja engibetkag son si‐kak; sota obden inpiyal to son si‐kak i dag‐en ko ingkatod meksheng. ");
INSERT INTO ibl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Si‐kayo, ẃara met sota joka ikowan no mantatabtabal kayo, ja kowan jo ey, ‘Ondabas pay i epat ta bolan, asan timpo ma ni ani.’ Nem no si‐kak, niman i timpo ni ani. Idmang jo kari ira ja totoo. Sota timpon pematira son si‐kak, shanshani ma; may‐eshig shi edowem men pagey ja mebedin na ma‐eni. ");
INSERT INTO ibl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Isonga si‐kayo, mesepol la alisto kayon ondaw ta si‐kayoy may‐eshig ey en man‐eni, jet sota toon mengitosho ni esel ko shi kait ton totoo say memati ira son si‐kak, si‐kak i mengi‐kan ni konkona to. Jet man‐imdeng sotan na toon pasiya, ta eshakel i toon engawat ni biyag ja enshiy to engintegan. Isonga man‐imdeng sota mengitosho niman ja singa man‐eni, jet man‐imdeng ngo sota epangdon engitosho ja singa nan‐esek. ");
INSERT INTO ibl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Agpayso sota kowan ira nonta too nonta bayag da ey, ‘Apil i man‐a‐sek, jet apil ngoy mengepit nonta dames ni nay‐esek.’ ");
INSERT INTO ibl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Isonga si‐kayo, si‐kayoy ibetkag ko, ja singa en mengepit nonta dames ni in‐esek ni eshom, angken na aliẃen si‐kayoy nandigat.” Sajay i kowan nen Jesus so nonta ira too to. ");
INSERT INTO ibl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jet sota ira tood Samaria, ja i‐Sikar, eshakel iray emati son Jesus, pangkep nonta inkowan nonta bii ey, “Emin sota dingdingkak nontan da, amta nontan na too, jet inkowan to son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jet nontan ma, sota ira i‐Samaria, pinidit sha ey meki‐iyan nin si Jesus son si‐kara. Jet si Jesus, eki‐iyan shiman son si‐kara ni showen akew. ");
INSERT INTO ibl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jet sota inpan‐iyan tod man, mas eshakel pay i emati son si‐kato, ta intenengan shen mismo i toro to. ");
INSERT INTO ibl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sota ira totoo, kowan sha so nonta bii ey, “Nonta pilmiro, emati kami son Jesus kabol nonta inkowan mo, nem niman, mas pay ya emati kami ma son si‐kato, ta mismon intenengan miy inkowan to, jet amta mi ma i maypangkep son si‐kato, ey si‐kato sota mengisedakan ni tood ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Idi maykatdon akew, si Jesus tan sota ira kait to, indekjas shay Sikar jet dimaw ired Galilia. ");
INSERT INTO ibl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nonta epangdo len akew, ẃaray inkowan nen Jesus ey, “Sota toon inbetkag ali nen Apo Shiyos, enshiy shayaw tod ili ton mismo.” ");
INSERT INTO ibl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nem idi dimaw shi Galilia ja ili to, sota ira tood man, ireka man‐imdeng ja mengeẃat son si‐kato, ta sajay iren too, inon‐an shay dingka nen Jesus shi Jerusalem nonta timpon piyasta ni Paskowa. Ta dimaw ngo ired man nonta timpo ni piyasta. ");
INSERT INTO ibl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jet idi enaksheng iyay, si Jesus, dimaw shi Kana, ja sakop met laeng ni Galilia. Shiyay ya dogad sota dingka‐an son Jesus ni milagro, ja sota shanom, inpanbalin to ni inom. Jet nonta ẃares Jesus shiman, ẃaray i‐Kapirnaom ja emansekit i anak ton daki. Sajay ya too, ekayang i toray to. ");
INSERT INTO ibl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Idi shinemag to ey ẃares Jesus shi Kana ja edapo alid Jodia, dimaw iyay ya toray ja to simbi si Jesus. Jet sajay ya toray, to inbag‐an si Jesus no mebedin na odopen tod Kapirnaom ja to pemapteng sota emansekit ja anak to, ta epaladoy sakit to, ja shanshanin metey. ");
INSERT INTO ibl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jet si Jesus kowan to so nonta toray ey, “No enshiy mo asen na dag‐en kon kaskasshaaw, ono milagro, eg ka memati?” ");
INSERT INTO ibl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sota toray, simongbat ja kowan to ey, “Apo, no eg ka mekidaw son si‐kak, kenshat ta metey sota anak ko!” ");
INSERT INTO ibl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Si Jesus, kowan to so nonta toray ey, “Akad ka, sota anak mo, onmapteng ma.” Sota toray, pinati to sota inkowan nen Jesus, jet dima‐jat ja on‐akad. ");
INSERT INTO ibl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nonta eẃa‐ẃa, en nay‐aspol shi shalan sota ira baga‐en nonta toray son si‐kato, jet inkowan sha son si‐kato ey, “Sota anak mon emansekit, mapteng ma!” ");
INSERT INTO ibl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jet sota toray, inbag‐an to sota ira baga‐en to ey, “Nganton oras i nayshogi‐an ni inmapteng to?” Jet kowan sha ey, “Oras ni ala ona ni mama‐shem nonta na‐shem.” ");
INSERT INTO ibl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jet ninemnem ton shagos ey oras ni ala ona nonta inkowan nen Jesus ey, “Sota anak mo, onmapteng.” Jet manipod nontan ma, si‐kato tan sota emin na ẃared baley to, emati ira son Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sajay i maykadẃa ja kaskasshaaw wa dingka nen Jesus shi Galilia, jet dingka to iyay nonta edapo alid Jodia. ");
INSERT INTO ibl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Idi enshiy bayag to, ẃaray piyasta ni Hodiyos, jet si Jesus, dimaw shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Shi Jerusalem, ẃaray shanom ma binneng sha ja kowan sha ey Bitisda shi esel ni Hodiyos. Sajay ya nabneng, nay‐esop nodta sakepan ni kalniro shi siyodad ja pasbol. Waray dimen sishoman ja nay‐esop nodta nabneng, ");
INSERT INTO ibl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","jet eshakel nodtan i nansirom ma ekalkalasiy sakit sha: ẃaray ekorab, ẃaray epilay, tan ẃara pay iray eg makakeykey i bakdang sha. Sajay iren emanpansekit, shaka segsegshay ikeykey nonta shanom, ");
INSERT INTO ibl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ta ẃaray timpo ja kaidaw ali nonta anghil nen Apo Shiyos jet to pekeykey sota nabneng nga shanom, jet sota mepangdon too ja manteb‐ok nodta shanom ni timpon toka ikeykey, angken ngantoy sakit to, ma‐ekasan. ");
INSERT INTO ibl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wara nodtan i sakey ya toon nansakit ni tedon polo tan ẃalon tawen. ");
INSERT INTO ibl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Si Jesus, inon‐an to iyay ya too, jet amta to ey ebayag ga emansekit ja emansessesked nodtan. Inbag‐an to ja kowan to ey, “Piyan mon onmapteng?” ");
INSERT INTO ibl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sotan na too, simongbat ja kowan to ey, “Owen Apo, nem no timpon ikeykey nima shanom, enshiy kaontolong son si‐kak ja manteb‐ok shima shanom. No shanshanin on‐esopak shima kilig nima nabneng, ẃara day emepangdo ey say si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jet si Jesus, kowan to so nontan na too ey, “Dayat ka, isingpet mo ita shokolan mo et pan‐akad ka.” ");
INSERT INTO ibl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jet mimapteng nga shagos sotan na too, jet insingpet to sota shokolan to, jet nan‐akad. Epasemak iyay nonta timpo ni akew wa ngilin ni Hodiyos, ");
INSERT INTO ibl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","isonga sota ira pangolo ni Hodiyos, inkowan sha so nonta toon mimapteng ey, “Apay nga pinesan mo ita shokolan mo, ket maypeshit shi dinteg tayo ita inpasing mo no akew wa ngilin tayon Hodiyos?” ");
INSERT INTO ibl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nem sajay ya too, simongbat ja kowan to ey, “Sota inpamapteng son si‐kak, si‐katoy engikowan ey al‐en ko sota shinokolan ko, jet inkowan to pay ey man‐ekarak.” ");
INSERT INTO ibl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jet sota ira pangolo ni Hodiyos, inbag‐an sha iyay ya too, ja kowan sha ey, “Sipay engikowan son si‐kam ey al‐en moy shokolan mo et man‐ekad ka pay?” ");
INSERT INTO ibl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nem sajay ya toon mimapteng, eg to amta sotan na toon inpamapteng son si‐kato, ta si Jesus, indekjas ton shagos, ta eshakel la pasiya sota too nodta kilig ni nabneng. ");
INSERT INTO ibl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Idi enshiy bayag to, simbi nen Jesus iyay ya too shima Timplo, jet kowan to son si‐kato ey, “Niman, ta mapteng ka ma, tanshaanim; aliẃen ka mowan manbesol, ta amangan no ekarkaro aliy da‐kaman mon digat ey say sota epangdon dina‐kaman mo la.” ");
INSERT INTO ibl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jet sajay ya toon mimapteng, bimo‐day jet to inkowan so nonta ira pangolo ni Hodiyos ey say inpamapteng son si‐kato, si Jesus gayam. ");
INSERT INTO ibl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sajay i kabol la kinontra‐an ira nonta Hodiyos son Jesus, ta inpamapteng to iya toon istay emansekit nonta akew wa ngilin sha. ");
INSERT INTO ibl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jet si Jesus, inkowan to son si‐kara ey, “Say kowan jo, no timpo ni ngilin tayon Hodiyos, eg kita man‐obda. Nem si Apo Shiyos ja Amak, eg onsalsheng i obda ton mengaasi ni too; isonga mesepol la si‐kato ngoy dag‐en ko.” ");
INSERT INTO ibl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Idi intenengan sha iyay ya inkowan nen Jesus, ema‐ma et ta piyan shen bono‐en. Aliẃen sota eg to inpangonod ni dinteg bengat i inokesan sha son si‐kato, no diket in‐inges to pay i bakdang to son Apo Shiyos ja kowan to ey Ameto. ");
INSERT INTO ibl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jet si Jesus, kowan to so nonta ira Hodiyos ey, “Kinapodpodno iya ikowan ko son si‐kayo. Si‐kak ja Anak to, enshiy kabedinan kon mandeka ni angken nganto, no a‐abos ko bengat; jet say mebedin bengat ja dag‐en ko, sota inon‐an ko ja obda nen Amak. Sota obdak, inges toy obda nen Amak. ");
INSERT INTO ibl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta si Amak, ensemek towak; isonga emin na obda to, inpa‐amta so son si‐kak. Jet no ma‐onod alin timpo, ẃaray obden pedeka to son si‐kak, jet mas kaskasshaaw wa pasiya nem say sota dingkak niman, jet si‐kayo, messhaaw kayo. ");
INSERT INTO ibl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Si Amak, si‐katoy ememiyag nonta nanketey, jet angken si‐kak ja Anak to, mengi‐kanak ni biyag so nonta toon piyan kon pengi‐kanan. ");
INSERT INTO ibl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Si Amak, aliẃen si‐katoy mengigsheng no sipay maysedakan, no diket in‐akan ton emin son si‐kak i kanebengan kon mengigsheng ni panbenagan ni emin na too ingkatod ingka, ");
INSERT INTO ibl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","say emin na too, si‐kak i shedjawen sha ja inges toy shaka pengiredjaw son Amak. Sota eg mengiredjaw son si‐kak, eg sha ngo ishayaw si Amak, ta si‐kak sota inbetkag to di. ");
INSERT INTO ibl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kinapodpodno iya ikowan ko son si‐kayo. Sota memati nonta ikowan ko tan memati son Amak ja engibetkag ali son si‐kak, si‐katoy eẃad‐an ni biyag ja enshiy to engintegan, jet eg to da‐kaman na meshosa, ta ẃara son si‐kato sota biyag ja edapo son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Kinapodpodno iya ikowan ko son si‐kayo. Say too, singa may‐eshig ey etey pangkep ni basol, nem no itenengan sha niman sota ikowan ko, may‐aknan ira ni biyag, ta si‐kak sota Anak nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ta si Amak, si‐katoy kedepo‐i ni biyag, jet si‐kak ja Anak to, in‐aknan towak ni kanebengan kon mengi‐kan ni biyag, ");
INSERT INTO ibl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","tan in‐aknan towak pay ni kanebengan kon mengigsheng no sipay maysedakan, tep si‐kak, nanbalinak ni too. ");
INSERT INTO ibl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Karekayo messhaaw ni sajay ya inkowan ko la, ta ẃaray onsabi alin timpo, ja sota ira nanketey, itenengan shay esel ko, ");
INSERT INTO ibl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","jet onbangon ira di. Jet sota mapteng i aramid to nonta mabiday pay laeng, may‐aknan ira ni biyag ja enshiy to engintegan, nem sota nankekedsel, manbiyag met laeng ira, nem meshosa ira.” ");
INSERT INTO ibl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jet si Jesus intoloy to sota kowan to ey, “Si‐kak, aliẃen nak iba‐ngat ja dag‐en i piyan ko, no diket sota ikowan nen Amak son si‐kak, si‐katoy dag‐en ko. Isonga say naka pengigsheng, aliẃen o‐owap, ta aliẃen sota piyan koy dag‐en ko, no diket sota piyan nen Amak ja engibetkag son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","No si‐kak met laeng i mengikowan ni pangkep son si‐kak, singa enshiy kowinta to. ");
INSERT INTO ibl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nem ẃares Amak ja kaonpaneknek son si‐kak, jet amtak ey sotan na paneknek to pangkep son si‐kak, podno. ");
INSERT INTO ibl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Si‐kayo, engibetkag kayo ni en mantetneng so nen Juan jet inkowan to son si‐kayo i podno, ey si‐kak sota ondaw ali ja maysa‐dat son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nem si‐kak, eg mesepol iya paneknek ni too ta pineneknekan towak nen Amak. Say kabol ni inkowanan ko so nonta inkowan nen Juan nontan da, say memati kayo et say maysedakan kayo. ");
INSERT INTO ibl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan, may‐eshig ey si‐kato sota singa silew wa maredang, ta si‐katoy ondawag so ni nemnem ni too, jet kayoka man‐imdeng ja mengeẃat son si‐kato; nem sanka‐atikan bengat. ");
INSERT INTO ibl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Si Juan, inkowan to i maypangkep son si‐kak, nem sota mismon dingdingkak, sotan i epateg ja ka‐amta‐an to ey inbetkag towak ali nen Amak, ta si‐kak i shinotokan ton ondaga so ni obda to. ");
INSERT INTO ibl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jet si Amak, ja engibetkag son si‐kak, si‐kato met laeng i engipa‐amta ni maypangkep son si‐kak. Nem no ẃaray piyan ton pa‐amta, eg jo koston itenengan, eg jo koston on‐an, ");
INSERT INTO ibl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","eg jo nemnemnemen sota esel to ja inkowan to. Say ka‐asan to ket eg jowak pati‐en ja inbetkag ali nen Amak. ");
INSERT INTO ibl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Si‐kayo, joka ad‐ashala sota esel nen Apo Shiyos ja naysolat nonta bayag da, ta say pangkep jo, kowan jo emo ey sepolan jo nodtan sota biyag ga enshiy to engintegan. Nem si‐kak i kaytoshongan nonta ira naysolat nodtan na dibsho ja joka ad‐ashala, ");
INSERT INTO ibl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ey si‐kayo, eg jo kosto ja memati son si‐kak, say may‐aknan kayo koma ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Si‐kak, aliẃen sota shayaw ni tooy naka en‐enapa, ");
INSERT INTO ibl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","tep amtak i nemnem jo: enshiy semek jo son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Si‐kak, dimawak alid jay ya in‐aknan nen Amak ni kanebengan ko, nem eg jowak ineẃat. Nem amtak ka no ẃara et ngo mowan i ondaw ali son si‐kayo, ja ka‐ẃay ton enshiy en engibetkag son si‐kato, si‐kato et ngo mowan i eẃaten jo. ");
INSERT INTO ibl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Isonga eg kayo emati son si‐kak, ta say pipiyan jo, sota shayaw ni kait jon too, ey aliẃa et ta sota kosto‐an shakejo so nen Apo Shiyos, ja istay topogen jo komen panshedjawan. ");
INSERT INTO ibl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aliẃen jo ipangkep ey si‐kak i mengireshom son si‐kayo so nen Amak, ta say podnon mengireshom son si‐kayo so nen Amak, si Moises, ja joka panshindi. Tep eg jo met laeng pinatiy bilin to. ");
INSERT INTO ibl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si‐kayo, no agpayson emati kayo son Moises, istay memati kayo koma ngo son si‐kak, tep sota insolat nen Moises ket maypangkep son si‐kak met laeng. ");
INSERT INTO ibl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","No eg jo pati‐en sota insolat nen Moises, toway pesing jon memati ngarod nonta naka pan‐ikowan?” ");
INSERT INTO ibl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Idi enshiy bayag to, si Jesus, bimaliw shima baybay shi Galilia, ono sota kowan sha ey Tibirias, jet dimaw nodta shemang to. ");
INSERT INTO ibl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jet eshakel la pasiyay toon imonod son si‐kato, ta inon‐an sha sota kaskasshaaw wa dingka to, ni inmapteng ira nonta emanpansekit. ");
INSERT INTO ibl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Si Jesus, inodop to iray too to, jet timiyed ira shima shontog, ja kowan to ey itod‐an to ired man. ");
INSERT INTO ibl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nontan na timpo, shanshani ma sota piyasta ni Hodiyos ja kowan sha ey Paskowa. ");
INSERT INTO ibl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Idi ẃimingi si Jesus, inon‐an to ali ira sota eshakel la toon emandaw son si‐kato, jet kowan to ey, “Felipe, toway pengal‐an ni mekan ja on‐anay ya kenen ira niman na totoo?” ");
INSERT INTO ibl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Si Jesus, piyan ton peshasen bengat si Felipe, no ngantoy isongbat to, isonga inkowan to iyay. Nem si Jesus, amta to mangon shagos i pesing ton memekan nonta ira totoo.) ");
INSERT INTO ibl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jet si Felipe, simongbat ja kowan to ey, “Sajay ya karakel sha, angken pigen dasos i itongkal tayo ni tinapay, eg pay on‐anay son si‐kara, angken ko‐ko‐tiken tayo.” ");
INSERT INTO ibl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Waray sakey nodta too nen Jesus ja si Andres i ngaran to ja agi nen Simon Pedro; kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Waray sakey shiyay ya balodaki so nonta ira totoo, ja nanbalon ni dimen boknol la tinapay, tan showen piskaw. Nem enshi met i silbi to, ta eg met laeng on‐anay so ira niya eshakel la totoo.” ");
INSERT INTO ibl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jet si Jesus, inkowan to so nonta ira too to ey, “Patongaw jo ira ja totoo.” Jet sota ira totoo, timanongaw ira nodta paway, jet say kabebilang ira nonta daleki, dimen dibo, powiray bibii tan a‐anak. ");
INSERT INTO ibl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jet nontan ma, si Jesus inda to sota tinapay tan sota piskaw wa balon nonta balodaki jet nan‐iyaman son Apo Shiyos, asan toka paiweshis sota mekan na shimakel so nonta ira totoo ja timanongaw. Jet sota ira totoo, engan ira ingkatod enapsel iren kosto. ");
INSERT INTO ibl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Idi enaksheng ma ira sota totoo ja engan, inkowan nen Jesus so nonta ira too to ey, “Sa‐nop jo sota ira sobden tinapay, say enshiy en onkawas.” ");
INSERT INTO ibl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jet sina‐nop sha sota ebay‐an na eg sha kinan nodta dimen tinapay ja inpara‐kel nen Jesus. Jet say na‐olnongan nonta sobdara, sampolo tan showen baskit ja nankepno. ");
INSERT INTO ibl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sota ira totoo, idi inon‐an sha iyay ya dingka nen Jesus, ja inpara‐kel to sota mekan, nasshaaw ira, jet kowan sha ey, “Kinapodpodno to ey sajay sota para padto ja inpadtora nonta bayag da ey ondaw alid ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Si Jesus, amta toy ẃared nemnem ira niyay ya too, ey piditen shen si‐katoy panbedin shen ari sha; isonga si Jesus, indekjas to ira, jet dimaw ja abos to nodta nayda‐med den shontog. ");
INSERT INTO ibl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Idi mama‐shem mala, sota ira too nen Jesus, enalong ira nodta kad‐an da ni baybay, ");
INSERT INTO ibl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","jet ira nandogan shi bangka, ta on‐oli ired Kapirnaom. Nem edabi mala ey eg pay laeng simabi si Jesus shi kadnan sha. ");
INSERT INTO ibl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jet nontan, sota shadoyon ni baybay, makedsang nga pasiya tep emansheshagem ma pasiya. ");
INSERT INTO ibl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Idi ẃaray enem emon kilomitro ja nan‐akshan da nonta bangka ja nandoganan nonta ira too nen Jesus, inon‐an sha si Jesus ja eman‐ekad ali nodta naytapew ni shanom ja eman‐a‐sop son si‐kara, jet naykel‐eẃan iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nem si Jesus, kowan to son si‐kara ey, “Karekayo ontakot, tep si‐kak iyay!” ");
INSERT INTO ibl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jet nay‐imdengan ira sota too to, jet inpandogan sha si Jesus nodta bangka. Jet mimotok iren shagos nodta dogad ja daẃan sha. ");
INSERT INTO ibl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Nonta na mama‐shem, sota ira eshakel la totoo, inon‐an shay inda‐jat nonta ira too nen Jesus jet inon‐an shen enshis Jesus ja ekilokan nodtan. Isonga singked sha si Jesus nodta kawad‐an shen nay‐esop nodta enganan sha ni tinapay nonta naksheng nga nan‐iyaman si Jesus son Apo Shiyos. Kowan sha ey ẃares Jesus pay laeng nodtan na dogad, ta sakey bengat nonta bangka ja nandoganan ni too nen Jesus, enshiy eshom. Nem idi eẃa‐ẃa, enshi met gayam si Jesus. Isonga idi ẃara iray simalsheng nga bangken edapod Tibirias nodta kad‐an sha, nandogan ngo ira ja en mengenap son Jesus shi Kapirnaom. ");
INSERT INTO ibl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jet sota ira totoo, simbira si Jesus nodta naybaliw jet kowan sha ey, “Apo, pigan aliy indaw mod jay?” ");
INSERT INTO ibl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Si Jesus, simongbat ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Amtak ey jowakka en‐enapa ta engan kayo nontan ni tinapay, jet nanpesel kayon kosto; aliẃen sota kaskasshaaw wa dingkak i jowaksoka en‐enapi so. ");
INSERT INTO ibl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aliẃa komen sota mekan i jo kamkamkaman, ta say mekan, ema‐bos. Isonga say kamkaman jo koma ja jo enapen, sota may‐eshig ey mekan ja mengi‐kan ni biyag ja enshiy to engintegan. Sajay ya mekan na naka pan‐ikowan, sota kowan sha ey Anak ni Too, si‐kato i mengi‐kan son si‐kayo. Say ka‐amta‐an to ey ẃaray in‐akan nen Apo Shiyos ja kanebengan kon mengi‐kan ket inpa‐sas to ey towakka kosto‐i.” ");
INSERT INTO ibl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jet sota ira totoo, kowan sha son Jesus ey, “Ngarantoy kowan mo ey pesing mi ja mandeka ni kekosto‐i nen Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Si Jesus, simongbat ja kowan to ey, “Sajay i piyan nen Apo Shiyos ja dag‐en jo: pamati kayo son si‐kak, ta si‐kak i inbetkag to ali.” ");
INSERT INTO ibl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nem sota ira totoo, kowan sha ey, “Ngaranto ngarod i ipa‐sas mo pay son si‐kami, say pati‐en mika? Ngantoy dag‐en mo ja inges toy dingka nen Moises nonta bayag da? ");
INSERT INTO ibl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ta sota ira appo tayo da, engan ira nonta tinapay ya kowan sha ey mana ja edapod dangit nonta ẃara ira nodta dogad ja nan‐ak‐akshan sha ja enshiy balbaley. Sajay i kowan nonta esel nen Apo Shiyos ja naysolat, ja kowan to ey, ‘In‐aknan nen Moises ira ni tinapay ja edapod dangit.’ ” ");
INSERT INTO ibl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Si Jesus, simongbat ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Sota tinapay ya kinan sha, ja edapod dangit, si Apo Shiyos ja Amak i engi‐kan son si‐kara; aliẃen si Moises. Jet si Amak met laeng i emengi‐kan ni koston tinapay son si‐kayo ja medepod dangit. ");
INSERT INTO ibl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sota tinapay ya edapod dangit, ja in‐akan nen Apo Shiyos, si‐katoy emengi‐kan ni biyag ni tood ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jet sota ira totoo, kowan sha ey, “Apo, aknim kami niman nita tinapay ya eg ma‐ma‐bos ingkatod ingka!” ");
INSERT INTO ibl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Si Jesus, simongbat ja kowan to ey, “Si‐kak sota may‐eshig ey singa tinapay ya emengi‐kan ni biyag, jet sota ondaw ali son si‐kak ja memati, eg ma‐ekang, tan eg ma ma‐kew ni shanom. ");
INSERT INTO ibl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nem si‐kayo, angken inon‐an joy dingkak, eg kayo memati son si‐kak. Sajay, inkowan ko son si‐kayo nontan et inpinshowak mowan. ");
INSERT INTO ibl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sota ira i‐awat nen Amak son si‐kak, si‐karay memati son si‐kak, jet sajay ira ja ondaw ali son si‐kak, man‐imdengak ja mengeẃat son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta si‐kak, edapo‐ak alid dangit, jet say obda‐en ko bengat, sota piyan nonta engibetkag son si‐kak; aliẃen sota piyan ko. ");
INSERT INTO ibl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jet say piyan nonta engibetkag son si‐kak ja dag‐en ko, emin ira sota toon in‐awat to son si‐kak, ja emati, isingpet ko iren emin, jet shi ka‐onoran alin akew, panbiyag ko ali ira shi patey. ");
INSERT INTO ibl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Say piyan pay nen Amak, emin ira sota toon eẃatan toy maypangkep son si‐kak, jet memati, may‐aknan ira ni biyag ja enshiy to engintegan, tan panbiyag ko ira di shi ka‐onoran na akew.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Waray eshom nodta Hodiyos ja eg makakosto son Jesus; idi inteneng sha sota kowan nen Jesus ey si‐kato sota tinapay ja edapod dangit, ireka mankotot, ");
INSERT INTO ibl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ja kowan sha ey, “Sajay met si Jesus; amta tayo met iray maka‐anak son si‐kato! Angsan i to ikowan ey si‐kato ket edapod dangit.” ");
INSERT INTO ibl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jet si Jesus, kowan to son si‐kara ey, “Aliẃen kayo koma onkotot ni maypangkep niya inkowan ko la. ");
INSERT INTO ibl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Angken sipa, enshiy en ondaw ali son si‐kak ja memati, no si Amak ja engibetkag son si‐kak ket eg to pannemnem sotan na too ja ondaw ali son si‐kak ja memati. Jet sota toon memati son si‐kak, panbiyag ko ali shi patey shi ka‐onoran na akew. ");
INSERT INTO ibl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jet angken nonta bayag da, ẃaray naysolat ja inkowan ira nonta para padto, ja kowan sha ey, ‘Emin na too, tod‐an ira nen Apo Shiyos.’ Sajay i inkowan ni para padto, jet sota metod‐an tan mengitneng son Amak, si‐karay ondaw ali ja memati son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Angken sipa, enshiy engasas son Apo Shiyos ja Amak, no diket si‐kak bengat, ta si‐kak, say edapo‐an ko, si‐kato; isonga inon‐an ko. ");
INSERT INTO ibl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kinapodpodno iya inkowan ko son si‐kayo. Sota memati son si‐kak, may‐aknan ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Si‐kak sota may‐eshig ey tinapay ya mengi‐kan ni biyag. ");
INSERT INTO ibl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Agpayso ita kowan jo ey sota appoyo da, engan ira nonta tinapay ya kowan sha ey mana shima dogad ja nan‐ak‐akshan sha ja ayshiy balbaley. Nem iso met laeng nga etey ira. ");
INSERT INTO ibl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nem saja tinapay ya naka pan‐ikowan son si‐kayo niman, mismon edapo alid dangit, jet sota ira mengan so niyay, eg ira metey ingkatod ingka. ");
INSERT INTO ibl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Si‐kak sota mismon tinapay ya sibibiyag ja edapod dangit, jet sota mengan so niyay ya tinapay, may‐aknan ni biyag ja enshiy to engintegan. Jet sota kowan ko ey tinapay, si‐kato iya bakdang ko ja i‐akan ko para so ni totood ja dobong say meẃad‐an ira ni biyag.” Sajay i kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nonta intenengan shay inkowan nen Jesus, nansosongbat ira sota kimotot nonta ekay da, ja kowan sha ey, “Toway pesing to konon mengi‐kan ni bakdang to son si‐katejo, ja kenen tayo?” ");
INSERT INTO ibl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isonga si Jesus, kowan to son si‐kara ey, “Kinapodpodno iya ikowan ko son si‐kayo. No eg jo kenen iya bakdang ko, tan eg jo inomen sota shalak, enshi son si‐kayo i biyag. ");
INSERT INTO ibl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jet sota mengan niya daman ko, tan menginom niya shalak, si‐karay may‐aknan ni biyag ja enshiy to engintegan, jet panbiyag ko ira di shi ka‐onoran alin akew. ");
INSERT INTO ibl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta saja daman ko, tan saja shalak, si‐katoy agpayson emengi‐kan ni biyag ni too. ");
INSERT INTO ibl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jet sota mengan niya daman ko, tan menginom niya shalak, si‐karay ẃara son si‐kak, jet si‐kak, ẃara‐ak ngo ni olay son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Si Amak ja engibetkag son si‐kak, si‐katoy kedepo‐i ni biyag; isonga ẃara ngo son si‐kak i biyag. Jet sota mengan ni daman ko, i‐aknan ko ngo ni biyag. ");
INSERT INTO ibl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Si‐kak sota tinapay ya mismon edapod dangit, jet si‐kak, aliẃen inges ko sota tinapay ya kinan ira nonta appo tayo da shima dogad ja nan‐ak‐akshan sha ja enshiy balbaley, ta etey met laeng ira. Nem sota mengan niya tinapay ya naka pan‐ikowan niman, ja si‐kato iya bakdang ko, si‐karay may‐aknan ni biyag ja enshiy to engintegan.” ");
INSERT INTO ibl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sajay i inkowan nen Jesus nonta inpantoro to shima sa‐nopan ira ni Hodiyos shi Kapirnaom. ");
INSERT INTO ibl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jet eshakel so nonta ira too nen Jesus i eg makakosto niyay. Idi itenengan sha iyay ya toro to, kowan sha ey, “Polibas ira jay ya toro to. Enshi emoy makabaal la on‐awat so!” ");
INSERT INTO ibl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Enshiy engikowan son Jesus ey sajay i shaka pankototi, nem amta toy ẃared nemnem sha; isonga inkowan to ey, “Sota inkowan ko la, si‐katoy kabol ni eg jo ma pati‐an son si‐kak? ");
INSERT INTO ibl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","No bilang ey asen jowakka emankedjang ja on‐olid dangit, ikotot jowak pay laeng ngata? ");
INSERT INTO ibl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Say emengi‐kan ni biyag ni bakdang, sota jasjas to. No eg onjasjas, enshiy silbi ni bakdang. Sajay i kay‐eshigan ni inkowan ko, ta emengi‐kan ngo ni biyag. ");
INSERT INTO ibl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nem amtak ey ẃara son si‐kayoy eg memati son si‐kak.” Kowan nen Jesus. (Sajay i inkowan nen Jesus, ta sigod ja amta to sota ira totoon eg memati, tan amta to sota toon mengibaag son si‐kato ali so nonta toon makakontra son si‐kato.) ");
INSERT INTO ibl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tan say kowan to pay, “Isonga inkowan ko son si‐kayo ey, angken sipa, enshiy en ondaw ali son si‐kak ja memati, no si Apo Shiyos ja Amak ket eg to pannemnem ira ja ondaw ali son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Idi naksheng ma ja inkowan nen Jesus iyay, eshakel nodta ira istay too to i eg timoloy ja meki‐odo‐odop son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jet si Jesus, kowan to so nonta ira sampolo tan showa ja apostol to ey, “Si‐kayo ngay? Piyan jo ngon maysi‐jan son si‐kak?” ");
INSERT INTO ibl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jet si Simon Pedro, simongbat ja kowan to ey, “Sipa ngay i daẃan min eshom no aliẃen si‐kam? Ket si‐kam bengat i kawad‐an ni esel ja emengi‐kan ni biyag ja enshiy to engintegan, ");
INSERT INTO ibl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","jet kamika memati son si‐kam, ta amta mi ey si‐kam sota shinotokan nen Apo Shiyos ja inbetkag to did ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jet si Jesus, simongbat ja kowan to ey, “Say pinidik, sampolo tan showa, nem ẃaray sakey son si‐kayo ja dimonyo.” ");
INSERT INTO ibl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Sajay i inkowan nen Jesus, ta si Judas ja anak nen Simon Iskariote ja sakey nodta sampolo tan showen apostol to, si‐kato aliy mengibaag son Jesus so nonta ira toon makakontra son Jesus.) ");
INSERT INTO ibl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Idi enshiy bayag to, shi Galilia bengat i nan‐ak‐akshan nen Jesus, ta eg to kosto ja manshedan shi Jodia, ta sota ira pangolo ni Hodiyos shiman, piyan shen bono‐en si Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jet nontan na timpo, shanshani ma sota piyasta ni Hodiyos ja kowan sha ey piyasta ni Kampo. ");
INSERT INTO ibl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jet sota a‐aki nen Jesus, kowan sha son si‐kato ey, “Ilekjas mo iyay ya dogad, jet daw ka shi Jodia, say asen ira nonta emati son si‐kam shiman sota ira moka dagdag‐a ja kaskasshaaw. ");
INSERT INTO ibl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Say too, ja piyan ton amta‐en ni karakdan, aliẃen to en i‐emot i dag‐en to, no diket dag‐en tod karakdan ni too, say asen ni emin na tood ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Sajay i inkowan ira nonta a‐aki to, tep nontan, angken si‐kara, eg sha nin pinati si Jesus.) ");
INSERT INTO ibl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jet si Jesus, simongbat ja kowan to son si‐kara ey, “Si‐kak, aneng nin sota timpon pengipa‐sas ko ni maypangkep son si‐kak. Nem si‐kayo, angken bina‐ngatan mangoy dag‐anan jo so ni piyan jon dag‐en, angken ngaranton akew. ");
INSERT INTO ibl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Si‐kayo, aliẃen kontra shakejo niya tood ja dobong, nem si‐kak, kontra sha‐ak, tep naka pan‐ikowan son si‐kara sota ngaaw wa aramid sha. ");
INSERT INTO ibl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Daw kayo mango shima piyasta, nem si‐kak, ekak nin ondaw ta aneng sota koston timpok.” ");
INSERT INTO ibl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sajay i inkowan nen Jesus son si‐kara, jet ebay‐an mango nin shi Galilia; eg ekidaw son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Idi enaksheng den dimaw ira sota a‐aki to nodta piyasta, timened si Jesus son si‐kara ni abos to, ja enshiy maka‐amta. ");
INSERT INTO ibl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jet nonta marama sota piyasta, pan‐enapa ira nonta pangolo ni Hodiyos si Jesus, jet shaka ibagabaga nem ẃaray engasas son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jet nontan na timpon piyasta, ẃaray toon na‐olnong, jet say kowan ira nonta eshom, kowan sha ey, “Mapteng i ogadi nen Jesus.” Nem sota ira eshom son si‐kara, kowan sha ey, “Enshi, si‐katoy kaon‐awis so ni toon mandeka ni ngaaw.” ");
INSERT INTO ibl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nem sajay iren too, eg sha inkowan shi karakdan i maypangkep son Jesus, tep entakot ira so nonta pangolo ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Idi nankawa ma sota piyasta, dimaw si Jesus shima Timplo jet en nantoro so nonta ira totoo. ");
INSERT INTO ibl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jet sota ira eshom ma pangolo ni Hodiyos, ja engitneng ni inkowan nen Jesus, ireka messhaaw, jet kowan sha ey, “Toway inpasing niyay ya toon dimaing, ey ootik met i ashal to?” ");
INSERT INTO ibl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Idi intenengan nen Jesus iyay ya inkowan ira nonta pangolo ni Hodiyos, simongbat ja kowan to ey, “Saja naka pan‐itoro, aliẃen na mismon edapod nemnem ko, no diket sajay i kowan nonta engibetkag son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jet sota toon piyan ton onoren i kowan nen Apo Shiyos, idasin to no sipay edapo‐an niyay ya naka pan‐ikowan — no nemnem ko, ono si Apo Shiyos i edapo‐an to. ");
INSERT INTO ibl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sota toon say toka pan‐itoro ket sota maypangkep met laeng ni bakdang to, say ẃared nemnem to bengat, sota kayshedjaw to shorog. Nem sota toon say ẃara son si‐kato ket sota kayshedjawan nen Apo Shiyos ja engibetkag son si‐kato, enshiy kolang ni toka ikowan; podnon emin.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Idi enaksheng iyay ya inkowan nen Jesus, kowan to so nonta ira pangolo ni Hodiyos ey, “Sota dinteg nen Moises, ẃara son si‐kayo ja joka ad‐ashala, nem angken sakey son si‐kayo, enshiy emati nontan na dinteg nen Moises, ta no ẃara koma, apay nga kowan jo ey bono‐en jowak?” ");
INSERT INTO ibl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jet sota ira totoo, simongbat ira ja kowan sha ey, “Kaka man‐engaw! Sipay engikowan ey bono‐en shaka?” ");
INSERT INTO ibl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jet si Jesus, simongbat ja kowan to ey, “Nonta pinsak, ẃaray inpamapteng kon emansekit nonta akew ni ngilin, jet nontan, kayoka emesshaaw, no apay nga dingkak sotan. ");
INSERT INTO ibl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Say sakey ya dinteg ja in‐akan nen Moises, ja tineẃid to so nonta appo to la, sota kowan tayo ey kogit, jet sajay, angken na akew ni ngilin, joka pandag‐a say metongpal sotan na dinteg. ");
INSERT INTO ibl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jet no timpo ni ngilin joka pandag‐a iyay ya kogit, say eg koma mesheshal i dinteg pangkep ni kogit, apay nga no ẃara mangoy dag‐en ko ja panmaptengan ni toon emansekit ni akew ni ngilin ket kayoka onbonget? ");
INSERT INTO ibl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aliẃen jo iba‐ngat ey ngaawak pangkep nonta inon‐an jon dingkak, no diket nemnem jo koma sota dingkak ja panmaptengan ni too.” ");
INSERT INTO ibl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sota eshom ma tood Jerusalem, idi intenengan sha iyay ya inkowan nen Jesus, kowan sha ey, “Sajay met sota toon kowan ira nonta pangolo tayo ey bono‐en sha ja shaka en‐enapa? ");
INSERT INTO ibl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iyay met gayam shiyay ya emantosho shi karakdan ni too, jet apay nga eg sha met a‐degken? Sigosho ireka emo memati ma ey si‐kato sota naypadton mengisedakan ali ja ibetkag nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nem say naypadto met ket sota toon ibetkag ali nen Apo Shiyos, angken sipa, enshiy maka‐amta ni kedepo‐an to. Nem sajay ya too, amta tayo met i edapo‐an to.” ");
INSERT INTO ibl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Isonga si Jesus, nonta ẃared ma Timplo ja emantosho, inkedsang toy esel to ja kowan to ey, “Say kowan jo, amtayowak, tan amtayoy edapo‐an ko. Nem aliẃen nemnem koy dinaẃan ko did jay, no diket ẃaray engibetkag son si‐kak, ja si Apo Shiyos ja kedepo‐i ni podno. Jet eg jo amtes Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nem si‐kak, amtak ta edapo‐ak son si‐kato, jet si‐katoy engibetkag ali son si‐kak ja ondaw alid ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Idi enaksheng nga inkowan to iyay son si‐kara, piyan sha ma ja a‐shelen si Jesus, nem enshiy angken sakey ya engitodoy, ta aneng nin sota timpon naykesheng nga pandikat to. ");
INSERT INTO ibl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nem sota eshakel la too, ẃara ngoy eshakel la emati so nen Jesus, jet say kowan sha, “Enshiy eshom ma toon tayoka sesseskesha ja ibetkag ali nen Apo Shiyos. Si‐kato iyay ya too, ta no bilang ey ẃaray ondaw ali ja eshom, eg to ingesen i dingdingka niyay ya too.” ");
INSERT INTO ibl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sota ira Parisiyo, intenengan sha iyay ya inkowan ira nonta totoo pangkep son Jesus jet sajay iren Parisiyo, tan sota ira apo ni papashi, engibetkag ira ni kowadja ja en mengshel so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nem si Jesus, amta toy ẃared nemnem sha, jet kowan to so nonta ira toon eshakel ja esa‐nop ey, “Say kawashak son si‐kayo, entikey ya timpo. On‐oli‐ak ka shagos so nonta engibetkag son si‐kak alid ja dobong. ");
INSERT INTO ibl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jet en‐enapen jowak no toway dinaẃan ko, nem eg jowak sepolen. Jet shima daẃan ko, eg mebedin na on‐onod kayo son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jet sota pangolo ni Hodiyos, idi intenengan sha iyay ya inkowan nen Jesus, kowan sha ey, “Towa konoy dogad ja daẃan to? Ampet siya ey, ondaw shima dogad ja nay‐araẃi ja nayẃarisan ira nonta kait tayon Hodiyos, jet mengitoshod man so nonta ira aliẃen Hodiyos. Jet mebedin noman na eg tayo ma on‐an. ");
INSERT INTO ibl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Apay nga kowan to ey tayo en‐enapen nem eg tayo sepolen? Tan shima daẃan to kono, eg tayo mebedin na onoren. Ngaranto emoy piyan ton a‐selen?” ");
INSERT INTO ibl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sota ka‐onoran na akew ni piyasta ni Hodiyos, si‐katoy kapatkan son si‐kara, jet nontan na akew, imetan si Jesus shi sango‐an ira nonta eshakel la too jet inkedsang toy esel to ja kowan to ey, “No sipa ira sota na‐kew ni shanom, ondaw ira di son si‐kak jet man‐inom ira. ");
INSERT INTO ibl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta say kowan ni esel nen Apo Shiyos ja naysolat nonta bayag da, kowan to ey, ‘Sota memati son si‐kak, may‐eshig ey ẃara ni olay son si‐kato sota shanom ja singa temtem ja eg ma‐ti‐an.’ ” ");
INSERT INTO ibl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Sajay ya inkowan nen Jesus, piyan ton ikowan ey si‐katoy kedepo‐an nonta Ispirito Santo nen Apo Shiyos ja eẃaten ira di nonta memati son si‐kato. Nem aneng nin, ta mesepol la metey si Jesus, jet manbiyag mowan. Ondaw pay shi dangit, asan toka i‐eẃat ma sota Ispirito Santo.) ");
INSERT INTO ibl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Idi intenengan ira nonta totoo iyay ya inkowan nen Jesus, kowan ira nonta eshom ey, “Siya, sajay nga agpayso sota para padto ja tayoka sesseskesha.” ");
INSERT INTO ibl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jet angken sota ira eshom, kowan sha ey, “Sajay nga agpayso sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos.” Nem sota ira eshom, kowan sha ey, “No si‐kato sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos ket aliẃen shi Galilia komay edapo‐an to, ");
INSERT INTO ibl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ta say kowan ni para padto nonta bayag da, sota mengisedakan ja ibetkag ali nen Apo Shiyos ket mandepo kono shi poli nen Ari David, tan shi Bitlihim kono pay i kedepo‐an to, ta si‐katoy ili nen Ari David.” (Sajay i kowan sha ta say pangkep sha, nay‐anak si Jesus shi Galilia.) ");
INSERT INTO ibl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Isonga nontan ma, eg nan‐i‐inges i kowan ni totoo. ");
INSERT INTO ibl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jet sota ira eshom, piyan shen a‐shelen si Jesus, nem enshiy mengshel son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sota kowadja ja istay en mengshel son Jesus, nay‐oli ira so nonta engibetkag son si‐kara ja Parisiyo, tan apo ni papashi, jet kowan ira niyay so nonta ira kowadja ey, “Apay nga eg jo di inshel?” ");
INSERT INTO ibl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sota ira kowadja, simongbat ira ja kowan sha ey, “Angken sipen too, enshiy mi inon‐an ja inges toy kepantosho niyay ya too.” ");
INSERT INTO ibl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jet sota ira Parisiyo, kowan sha ey, “No kasta, angken si‐kayo, imonod kayo so nonta kowan to ja o‐owap? ");
INSERT INTO ibl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Emin na pangolo jo, tan angken si‐kamin Parisiyo, angken sakey son si‐kami, enshiy en imonod son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sota ira toon imonod son si‐kato, eg sha amtay dinteg nen Moises, nem angkena, ta meshosa met laeng ira.” ");
INSERT INTO ibl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Jet si Nikodimo, sakey so ira nonta Parisiyo nodtan. Si‐kato sota dimaw son Jesus nontan da; isonga si‐katoy simongbat ja kowan to ey, “Say ẃared dinteg tayo, eg mebedin na mayba‐ngat i pengigsheng no nanbasol i sakey ya too ono enshi, no eg nin mebistigal no ngantoy basol to.” ");
INSERT INTO ibl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nem sinongbatan sha et si Nikodimo ja kowan sha ey, “Apay nga moka pan‐ibaliẃi? Sakey ka gayam ma kaidiyan ton i‐Galilia? Basam kari sota inpaisolat nen Apo Shiyos nonta bayag da: amta‐en mo ey enshiy para padton mandepod Galilia.” Sajay i inkowan sha son Nikodimo. ");
INSERT INTO ibl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jet sajay iren esa‐nop, nansisi‐jan iren imakad shi baley sha. ");
INSERT INTO ibl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nem si Jesus, dimaw nodta shontog ja kowan sha ey Olibas. ");
INSERT INTO ibl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jet idi eẃa‐ẃa, bimowas sa pasiya ja dimaw mowan shima Timplo. Eshakel ira sota totoon esa‐nop son si‐kato, jet si Jesus, timongaw ja nantoro son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jet idi maramen emantosho si Jesus, sota mamaistoro ni dinteg ni Hodiyos tan sota ira Parisiyo, indaw sha ali sota biin sinokalan sha ja ekileki, jet insango sha so nonta ira totoo. ");
INSERT INTO ibl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kowan sha son Jesus ey, “Maistoro, sajay ya bii, inon‐an min mismo ja ekileki, ");
INSERT INTO ibl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","jet say kowan ni dinteg ja in‐akan nen Moises son si‐katejo, kowan to ey sota biin mandeka ni sajay ya aramid, kenshat ta mebono ja mekespigan ni bato. Jet nganto ma i ikowan mo maypangkep son si‐kato?” ");
INSERT INTO ibl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Sajay i inkowan sha, tep kowan sha ey balang nem ẃaray pankamali‐an nen Jesus ni esel to ja ikowanan sha so ey nanbasol.) Nem si Jesus, jimemeg jet inpansolat toy kalomot tod bo‐day. ");
INSERT INTO ibl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jet nonta nanjemeg si Jesus shi bo‐day, ememasig ira sota Parisiyo ni salodsod son si‐kato. Jet si Jesus imekẃas jet kowan to son si‐kara ey, “No sipa son si‐kayo i polos sa eg nanbasbasol, si‐katoy mengirokin mengespig nita bii.” ");
INSERT INTO ibl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jet jimemeg mowan si Jesus shi bo‐day ja intoloy ton inpansolat i kalomot to. ");
INSERT INTO ibl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jet sota toon mamaistoro ni dinteg ni Hodiyos tan sota ira Parisiyo, idi intenengan sha sota inkowan nen Jesus, esa‐sa‐key iren engilekjas so nonta esa‐nop pa totoo, nanshogi nodta pangolo sha, jet say ebay‐an nodtan, si Jesus tan sota bii bengat. ");
INSERT INTO ibl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Timangkak si Jesus jet kowan to so nonta bii ey, “Towa ira da sota kowan sha ey mengespig son si‐kam ni bato? Enshiy engitodoy?” ");
INSERT INTO ibl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sota bii, simongbat ja kowan to ey, “Angken sakey son si‐kara met ket enshiy engitodoy.” Jet si Jesus, kowan to so nonta bii ey, “Angken si‐kak, aliẃa ngon kowan ko ey meshosa ka. Nem akad ka jet bi‐jagim sota ngaaw wa aramid mo.” ");
INSERT INTO ibl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Si Jesus, intoloy ton nantoro so nonta ira totoo ja kowan to ey, “Si‐kak i silew wa ondawag so ni nemnem ni tood ja dobong. Sota memati ja on‐onod son si‐kak, may‐eshig ey enshi ired embolinget, ta edawagan may nemnem sha; isonga ẃaray biyag son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nem sota ira eshom ma Parisiyo, kowan sha ey, “Sata kowan mo, eg mepati, ta say moka pan‐ikowan ket sota maypangkep met ni bakdang mo shorog!” ");
INSERT INTO ibl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sinongbatan ira nen Jesus, ja kowan to ey, “Angken bilang ey say naka pan‐ikowan ket sota maypangkep met laeng son si‐kak, saja inkowan ko, agpayso, ta amtak i edapo‐an ko, tan daẃan ko. Nem si‐kayo, eg jo amtay edapo‐an ko, ono daẃan ko. ");
INSERT INTO ibl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Say joka pengilesini ey mapteng ono ngaaw i aramid ni sakey ya too ket sota ẃared nemnem jo. Nem si‐kak, aliẃen satan i naka pesing. ");
INSERT INTO ibl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nem angken bilang ey ẃaray ikowan ko ey mapteng ono ngaaw, aliẃen abos kon mengigsheng so, no diket ẃaray kadẃak; aliẃen nak iba‐ba‐ngat. Jet say kadẃak, si Amak ja engibetkag ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jet angken sota dinteg jo, say kowan to, no nan‐inges i kowan nonta showen sistigo, si‐katoy mepati ey agpayso. ");
INSERT INTO ibl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Say pilmiron onsistigo ni maypangkep son si‐kak, si‐kak ka shorog, jet say maykadẃa, si Amak, ja engibetkag ali son si‐kak shiyay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jet sota ira Parisiyo, kowan sha son Jesus ey, “Toway kad‐an nen amam?” Si Jesus, simongbat ja kowan to son si‐kara ey, “Si‐kayo, eg jowak amta, isonga angken si Amak, eg jo ngo amta. No amtayowak koma, istay amtayo koma ngo si Amak.” ");
INSERT INTO ibl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sajay i inkowan nen Jesus so nonta ira totoo nonta inpantoro to nodta nay‐esop shima tado‐an ni pilak ka shaka idaton son Apo Shiyos shi Timplo. Jet nontan, enshiy nangshel son si‐kato, ta aneng nin sota timpon naykesheng ja pandikat to. ");
INSERT INTO ibl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jet si Jesus, nantoro pay son si‐kara ja kowan to ey, “Waray timpon idekjas takejo, jet en‐enapen jowak, nem si‐kayo, metey kayo ey eg epakaẃanan i basol jo. Jet eg mebedin na on‐onod kayo son si‐kak shima dogad ja daẃan ko.” ");
INSERT INTO ibl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sota ira pangolo ni Hodiyos, kowan sha ey, “Sigosho manbono emo, isonga kowan to ey eg mebedin na on‐onod kito shima dogad ja daẃan to.” ");
INSERT INTO ibl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jet si Jesus, simongbat ja kowan to ey, “Si‐kayo, too kayod ja dobong, isonga say emin na ẃared ta nemnem jo, sota maypangkep ngo niya dobong. Nem si‐kak, say edapo‐an ko, shi dangit, isonga say ẃared nemnem ko, aliẃen inges toy nemnem jo. ");
INSERT INTO ibl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Isonga binanshaanan takejo nonta pilmiro ja kowan ko ey metey kayo ey eg epakaẃanan i basol jo. Ampet memati kayo ey si‐kak sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos, asan mapakaẃani i basol jo.” ");
INSERT INTO ibl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nem sota ira Parisiyo, inbag‐an sha ja kowan sha ey, “Jet sipa ka?” Simongbat si Jesus ja kowan to ey, “Inkowan ko met son si‐kayo nonta pilmiro no sipa‐ak jet ingkato niman si‐kato pay laeng iya naka pan‐ikowan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jet no sota maypangkep son si‐kayo, eshakel pay i naka bedawa; isonga eshakel i piyan kon ikowan son si‐kayo ja inkowan nonta engibetkag ali son si‐kak, jet emin na kowan to, agpayso. Jet sajay i naka panpa‐amta so ni tood ja dobong, ta si‐katoy intenengan ko son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nem sota ira totoo, eg sha eẃatan iya inkowan nen Jesus son si‐kara, ey sota mismon toka pan‐ikowan ket sota maypangkep so nen Apo Shiyos ja Ameto. ");
INSERT INTO ibl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Isonga si Jesus, ẃara pay i inkowan to son si‐kara, ja kowan to ey, “No onsabi sota timpo ja ikayang jo sota Anak ni Too ja idansa, amta‐an jo ma ey si‐kak sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos. Tan amta‐an jo pay ey emin na maramen naka pan‐ikowan niman ket aliẃen na edapod nemnem ko, no diket sotan i inkowan nen Amak son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sota engibetkag son si‐kak, ẃara son si‐kak, jet eg towak baybay‐an ni abos ko, ta say piyan ton dag‐en ko, si‐kato iya naka dagdag‐a ni olay.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jet sota eshom so nonta ira totoo, eshakel i emati son Jesus nonta intenengan sha sota inkowan to. ");
INSERT INTO ibl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jet si Jesus, kowan to so nonta ira Hodiyos ja emati ey, “No sota intorok son si‐kayo ket si‐katoy nemnemnemen jo, si‐kayoy podnon took. ");
INSERT INTO ibl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tan amta‐en jo pay i eshom ma podno ja maypangkep so nen Apo Shiyos, jet sotan na podno, si‐katoy mengibodos son si‐kayo, jet aliẃa men baga‐en kayo.” ");
INSERT INTO ibl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Idi enaksheng nga inkowan nen Jesus iyay, simongbat sota ira Hodiyos, ja kowan sha ey, “Si‐kami, poli shakami nen Abraham, jet angken nontan da, enshiy amta mi ja makabaga‐en son si‐kami; eg kami nanbalin na baga‐en, angken na pinsak bengat. Jet apay nga ikowan mo ey maybodos kami ja aliẃen baga‐en ma?” ");
INSERT INTO ibl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jet si Jesus, simongbat ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Sota toon ngaaw i aramid to, may‐eshig ey baga‐en ni basol. ");
INSERT INTO ibl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jet say itsora ni baga‐en, aliẃen sigoradon man‐iyan ni olay nodta baley ya toka pan‐iyani, nem sota anak ni makabaley, eg may‐inges nodta baga‐en; ẃara mangoy kanebengan ton man‐iyan ni olay nodta baley. ");
INSERT INTO ibl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Isonga si‐kak ja Anak nen Apo Shiyos, no ikowan ko ey maybodos kayo, ja aliẃen baga‐en ma, mayto‐to‐ẃa ja mebodos kayo. ");
INSERT INTO ibl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Amtak ey poli shakejo nen Abraham, nem ẃara ira met son si‐kayoy piyan shen onbono son si‐kak, ta eg jo pati‐en sota inkowan ko son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Say naka pan‐ikowan, sota inon‐an ko so nen Amak, jet angken si‐kayo, say joka dagdag‐a, sota inon‐an jo ngo so nen amejo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sota ira Hodiyos, simongbat ira ja kowan sha ey, “Si Abraham i amemi.” Nem si Jesus, kowan to ey, “No si Abraham i amejo, istay say dag‐en jo koma ket inges to sota dingka nen Abraham. ");
INSERT INTO ibl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nem si‐kayo, piyan jon bono‐en jowak niman, ta inkowan ko son si‐kayo sota podno ja inkowan nen Apo Shiyos son si‐kak. Nem si Abraham, enshiy to dingka ja inges toy aramid jon ngaaw. ");
INSERT INTO ibl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Si‐kayo, say joka dagdag‐a, inges to sota ngaaw wa aramid nen amejo.” Jet sota ira Hodiyos, bimonget ira ja kowan sha ey, “Singa moka pan‐ikowan ey aliẃen si Abraham i makapoli son si‐kami, ja inges mi sota totoon eshakel i shiyos sha. Nem ayshi! Say kina‐agpayso to, saksakey i Amemi, ja si Apo Shiyos bengat!” ");
INSERT INTO ibl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jet si Jesus, kowan to son si‐kara ey, “No si Apo Shiyos i Amejo, istay ensemek jowak koma, ta say edapo‐an ko, si Apo Shiyos. Jet aliẃen nemnem ko shorog ga dimaw alid jay, no diket si‐katoy engibetkag ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Si‐kayo, eg jo eẃatan, ta eg jo koston itenengan iya naka pan‐ikowan. ");
INSERT INTO ibl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Inges jo eshan i ogadi nen Satanas ja amejo. Say pipiyan jon onoran na dag‐en, sota piyan nen Satanas. Nonta pilmiro, si‐katoy engipangdon bimono. Enshin polos son si‐katoy podno, no diket say pipiyan ton dag‐en, sota pan‐o‐owap. No ẃaray ikowan to, o‐owap pa emin, ta si‐katoy ogadi to. Jet si‐katoy amejo; isonga say joka pati‐a ket sota o‐owap. ");
INSERT INTO ibl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Say kabol la eg jowak so pati‐anan so ket sota naka pengikowan ni podno son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jet si‐kak, enshiy basol ko; isonga enshiy en mengikowan ey ẃaray basol ko. No ikowan ko son si‐kayoy podno, apay nga eg jowak pati‐en? ");
INSERT INTO ibl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sota ira annak nen Apo Shiyos, pati‐en sha sota kowan nen Apo Shiyos. Nem si‐kayo, eg jo met pati‐en sota kowan nen Apo Shiyos, ta aliẃen annak shakejo.” ");
INSERT INTO ibl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jet idi intenengan nonta ira Hodiyos iyay ya inkowan nen Jesus, kowan sha ey, “Agpayso gayam sota kowan mi ey i‐Samaria ka ja makakontra son si‐kamin Hodiyos. Tan agpayso gayam sota kowan mi ey ẃara son si‐kam i dimonyo.” ");
INSERT INTO ibl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jet si Jesus, simongbat ja kowan to ey, “Araẃi ita kowan jo. Enshi son si‐kak i dimonyo. Say naka panshedjawi, si Apo Shiyos ja Amak. Nem si‐kayo, ngaaw i joka ikokowan pangkep son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Si‐kak, aliẃa met kitdin sota pengiredjaw ni tooy naka kamkamkami. Nem si Apo Shiyos, si‐katoy kaonnemnemnem son si‐kak, jet si‐kato aliy mengigsheng ey maptengak. ");
INSERT INTO ibl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kinapodpodno iya ikowan ko son si‐kayo. Sota memati niya naka pan‐ikowan, eg sha da‐kaman i patey, no diket ẃaray biyag sha ingkatod ingka.” ");
INSERT INTO ibl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jet sota ira Hodiyos, kowan sha son Jesus ey, “Niman amta mi ma ey agpayson ẃaray dimonyo son si‐kam. Toway inpasing nitan? Si Abraham ket etey met da; angken pay sota ira para padto, etey da ngo ira. Nem si‐kam, say kowan mo, sota memati ni esel mo, eg metey? ");
INSERT INTO ibl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Si Abraham ja ametayo ket etey met, tan pati pay sota ira para padto nen Apo Shiyos nonta bayag da. Apay engatngato ka aya ey say si Abraham? Apay sipa ka aya ja satan i nemnem mo?” ");
INSERT INTO ibl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nem si Jesus, simongbat ja kowan to ey, “No say naka pan‐ishayaw ket saja bakdang ko, enshiy silbi to. Say emengiredjaw son si‐kak, si Amak ja kowan jo ey Shiyos jo. ");
INSERT INTO ibl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nem si‐kayo, aliẃen agpayso ja amtayo si Amak. Nem si‐kak, amtak si Apo Shiyos; isonga eg mebedin na ikowan ko ey ekak amta, ta aliẃen inges takejon ma‐owap. Am‐amtak si Apo Shiyos et naka pati‐a i kowan to. ");
INSERT INTO ibl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nontan da, si Abraham, ja amejo, eman‐imdeng ta namnama to ey asen toy akew wa ibetkagan towak so nen Apo Shiyos alid ja dobong, jet eman‐imdeng nga pasiya niman ta inon‐an to.” ");
INSERT INTO ibl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jet sota ira Hodiyos, kowan sha ey, “Toway inpasing mon engasas son Abraham ey si‐kam ket enshi pay met i dimen polon tawen mo?” ");
INSERT INTO ibl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Simongbat si Jesus ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Nonta eg pay laeng nay‐anak si Abraham, sigod ja ẃara‐ak ngoreshan.” ");
INSERT INTO ibl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Idi enaksheng nga inkowan nen Jesus iyay, sota ira Hodiyos, engala ira ni bato, jet kowan sha ey kespigan sha si Jesus. Nem en eki‐shom si Jesus nodta eshakel la totoo say eg maydesin jet indekjas to sota Timplo ja kawad‐an sha. ");
INSERT INTO ibl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Idi nonta eman‐ekad si Jesus, ẃaray inon‐an ton too ja sigod ja ekorab ni inkay‐anak to. ");
INSERT INTO ibl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jet sota ira too nen Jesus, kowan sha son si‐kato ey, “Maistoro, nganto ngatay ekoraban niyay ya too? Sigosho ẃaray basol to, ono basol ni maka‐anak son si‐kato?” ");
INSERT INTO ibl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Si Jesus, simongbat ja kowan to ey, “Aliẃen sota basol niyay ya too, ono sota basol ni maka‐anak i ekoraban to, no diket inpalobos nen Apo Shiyos, say si‐kato met laeng i mengekas son si‐kato, say amta‐en ni totoo ey ebadeg i panakabalin to. ");
INSERT INTO ibl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Niman ta ẃara kito pay laeng shi biyag, mesepol la dag‐en tayo sota obda ja piyan nonta engibetkag son si‐kak, ta no onsabi sota timpon ketey tayo, ibi‐jag tayo ma ja man‐obda. ");
INSERT INTO ibl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Niman ta ẃara‐ak pay laeng shiya dobong, si‐kak i may‐eshig ey silew wa ondawag so ni nemnem ni tood ja dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Idi enaksheng nga inkowan nen Jesus iyay, tinopsha‐an to sota bo‐day jet pingkel to, asan toka ipakpak nodta mata nonta toon ekorab, ");
INSERT INTO ibl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","jet kowan to son si‐kato ey, “Daw ka, ka pansha‐dop shima nabneng nga shanom shi Siloam.” (Say olog ni esel la Siloam, naybetkag.) Jet sota ekorab, dimaw wa en nansha‐dop, jet idi imoli di, eman‐esas ma. ");
INSERT INTO ibl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jet sota ira inaskang to, tan sota ira eshom ma toon maka‐amta son si‐kato ni toka pankekkekshaw nontan da, kowan sha ey, “Apay aliẃen sajay aya sota toon emantetongaw ni olay ja emankekkekshaw?” ");
INSERT INTO ibl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sota ira eshom, kowan sha ey si‐kato, nem sota ira eshom, kowan sha ey, “Apil — kalopdopa to bengat sotan.” Jet sota toon istay ekorab, kowan to ey, “Owen, si‐kak sotan na too.” ");
INSERT INTO ibl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Idi inkowan to ey owen, inbag‐an sha et mowan, ja kowan sha ey, “Toway inpasing mon nan‐asas ey istay ekorab ka met?” ");
INSERT INTO ibl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Simongbat iya toon istay ekorab, ja kowan to ey, “Sota toon kowan sha ey si Jesus, engala nonta bo‐day ya tinopsha‐an to, jet inpakpak tod matak jet inbetkag towak ka ondaw shi Siloam ja en mansha‐dop. Idi mansha‐dopak, maka‐asasak ma.” ");
INSERT INTO ibl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jet inbag‐an sha mowan ja kowan sha ey, “Toway kad‐an nontan den too?” Simongbat sota toon istay ekorab ja kowan to ey, “Taẃey, ekak amtay dinaẃan to la.” ");
INSERT INTO ibl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jet sajay ya toon istay ekorab, indaw sha so nonta ira Parisiyo. ");
INSERT INTO ibl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Say indaga so nen Jesus niyay ya milagro, nonta timpo ni ngilin ni Hodiyos; ");
INSERT INTO ibl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","isonga sota ira Parisiyo, inbag‐an sha ngo sota toon istay ekorab, no toway inpasing ton nan‐asas. Jet sota toon istay ekorab, inistoriya toy inpasing nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jet sota ira eshom ma Parisiyo, kowan sha ey, “Sotan na too, aliẃen si Apo Shiyos i edapo‐an to, ta no si Apo Shiyos komay edapo‐an to, apay nga eg to met onoren sota kowan ni dinteg tayo, pangkep ni akew ni ngilin?” Nem sota ira eshom ma Parisiyo, kowan sha ey, “Enshi. Sota ngaaw wa too, eg mebedin na todongan nen Apo Shiyos sa dag‐en toy kaskasshaaw, ja inges niya dingka niyay ya too.” Nontan ma, sajay iren too, nanshowa ira ja eg man‐inawatan. ");
INSERT INTO ibl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Isonga sota ira Parisiyo, inbag‐an sha mowan iya toon istay ekorab, ja kowan sha ey, “Si‐kam ma istay ekorab, ngantoy moka pannemnem pangkep son si‐kato? Tep si‐katoy inpan‐asas son si‐kam.” Simongbat iya toon istay ekorab, ja kowan to ey, “Sotan na too, say kowan ko, para padto nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nem sota ira pangolo ni Hodiyos, eg sha pati‐en ey sigod ja ekorab iyay ya too nonta inkay‐anak to. Isonga sha inpa‐odop sota maka‐anak son si‐kato, ta piyan shen ibag‐an, asan shaka pati‐a. ");
INSERT INTO ibl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jet sota ira pangolo ni Hodiyos, inbag‐an sha sota maka‐anak ja kowan sha ey, “To‐to‐ẃen sajay sota anak jo? Sigod ja ekorab iyay nonta inkay‐anak to? Jet no agpayso, ngantoy inpasing ton nan‐asas niman?” ");
INSERT INTO ibl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sota maka‐anak son si‐kato, simongbat ira ja kowan sha ey, “Agpayson anak mi noman itan na too, jet sigod ja ekorab nonta inkay‐anak to. ");
INSERT INTO ibl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nem no sota maypangkep ni toka pan‐esas niman, ono sipay timolong son si‐katon nan‐asas, eg mi amta. Si‐katoy ibag‐an jo ta na‐ama met; mebedin na ikowan to son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Sajay i insongbat sha, ta entakot ira so nonta pangolo ni Hodiyos, ta say nantotodagan ira nonta pangolo ni Hodiyos, kowan sha ey no sipay too ja mengikowan ey si Jesus sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos, a‐kalen sha shima sa‐nopan ira ni Hodiyos ja eg ma mebedin na mekisa‐sa‐nop son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Isonga sajay i inkowan nonta maka‐anak, ey sota anak shen istay ekorab ket si‐katoy ibag‐an sha.) ");
INSERT INTO ibl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jet sota ira Parisiyo, inpa‐odop sha mowan sota toon istay ekorab, jet kowan sha son si‐kato ey, “Si Apo Shiyos komay pan‐iyamanan mo ni maypangkep nita edaga son si‐kam, aliẃen sota toon kowan mo ey enolong son si‐kam. Ta amta mi ey sajay ya too ket mabesol.” ");
INSERT INTO ibl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sota toon istay ekorab, simongbat ja kowan to ey, “No si‐kak, ekak amtay aramid to, no ngaaw ono mapteng, nem say sakey bengat ja amtak: nontan, ekorabak, nem niman, maka‐asasak ma.” ");
INSERT INTO ibl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jet inbag‐an sha mowan na kowan sha ey, “Ngantoy dingka to son si‐kam? Ngantoy inpasing ton inpan‐asas son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Simongbat sotan ja kowan to ey, “Inkowan ko met da son si‐kayo. Nganto pay laeng i ipinpinshow‐an ko so, no eg jo met laeng pati‐en? Apay piyan jo mowan na itenengan aya? No kasta, piyan jon manbedin ni too to?” ");
INSERT INTO ibl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sota ira Parisiyo, nan‐es‐esdan sha sota toon istay ekorab asan shaka ma ikowan ey, “Si‐kam a! Too toka! Nem si‐kami, too shakami nen Moises. ");
INSERT INTO ibl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ta amta mi ey si Moises, tinabtabal nen Apo Shiyos, nem eg mi pay amta no toway edapo‐an nita kowan mo ey enolong son si‐kam!” ");
INSERT INTO ibl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jet sota toon istay ekorab, simongbat ja kowan to ey, “Kaskasshaaw itan na kowan jo! Sotan na too, inpan‐asas towak, nem say kowan jo, eg jo pati‐en ey si Apo Shiyos i edapo‐an to. ");
INSERT INTO ibl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amta ni emin na too, ey say toon ngaaw i aramid to, eg todongan nen Apo Shiyos. Nem sota toon mengiredjaw son Apo Shiyos, tan mandeka ni piyan to, si‐katoy todongan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Angken nonta ikaypalsowa niya dobong ingkato niman, enshiy en naytenengan ja inges niyay ya too, ja inpan‐asas toy toon sigod ja nay‐anak ka ekorab. ");
INSERT INTO ibl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","No sotan na too ket aliẃen si Apo Shiyos i edapo‐an to, istay eg to koma mebedinan na pan‐esas i toon ekorab.” ");
INSERT INTO ibl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jet sota ira pangolo ni Hodiyos, kowan sha ey, “Sesi‐kam, kowan mo ey tod‐an mokamin maka‐amta ni dinteg, ey inba‐deg may basol!” Idi enaksheng iyay ya inkowan sha, ingkal sha nodta sa‐nopan ja kowan sha ey eg ma mekisa‐sa‐nop. ");
INSERT INTO ibl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Idi shinemag nen Jesus ey ingkal sha nodta sa‐nopan sota toon istay ekorab, dimaw, ja to simbi jet to inbag‐an ja kowan to ey, “Agpayson kaka memati nonta naypadton Anak ni Too?” ");
INSERT INTO ibl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sota toon istay ekorab, simongbat ja kowan to ey, “Apo, ikowan mo no sipa sotan na too, say pati‐en ko.” ");
INSERT INTO ibl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Si Jesus, simongbat ja kowan to ey, “Inon‐an mo met sotan na too. Jet si‐kak sotan, ja mismon emekitbal son si‐kam niman.” ");
INSERT INTO ibl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sota toon istay ekorab, simongbat ja kowan to ey, “Apo, naka memati son si‐kam.” Jet sotan ma ey nantalimokod ja nanshayaw son Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jet si Jesus, intoloy ton kowan to ey, “Say kabol la dinaẃan ko did ja dobong, say mandinasin i toon memati tan toon eg memati. Dimawak ali say sota singa ekorab, maka‐asas, nem sota toon kowan to ey eman‐esas, si‐kara et ngo mowan i may‐eshig ey ekorab.” ");
INSERT INTO ibl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sota ira Parisiyo ja nay‐esop son Jesus, intenengan sha iyay ya inkowan to, jet kowan sha ey, “Say piyan mon a‐seden, angken si‐kami, ekorab kami?” ");
INSERT INTO ibl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Si Jesus, simongbat ja kowan to ey, “Enshi. No ekorab kayo koma, istay mebedin na mepesinsiya‐an kayo. Nem kowan jo ey maka‐asas kayo, ja joka idastog sota kowan jo ey abos jon maka‐amta ni podno. Isonga ka‐onong son si‐kayo i basol jo; eg epakaẃanan.” ");
INSERT INTO ibl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Si Jesus, intod‐an to ira ni arig ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Waray koral ni kalniro, jet sota toon onkalab shi alad, ja eg manshedan shi pasbol, si‐kato sota tolisan, ono makibot. ");
INSERT INTO ibl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nem sota toon agpayson emengajowan nonta kalniro, manshedan nodta mismon sakepan, ");
INSERT INTO ibl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","jet si‐katoy idokatan nonta emanbantay nodta sakepan nonta koral ni kalniro. Onsekep, jet sota kalniro, amtaray esel to ja shaka imatoni. Jet sa‐sa‐keyen ton ingadnan i ngaran nonta kalniro to, jet ibo‐day to ira. ");
INSERT INTO ibl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jet no ibo‐day to ira, si‐katoy mepangdo jet on‐onod sota ira kalniro, ta amtaray esel to. ");
INSERT INTO ibl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","No ẃaray eshom ma toon ondaw son si‐kara, eg sha iba‐ngat i onod so nontan na too. Idekjas sha et, ta shaka imatoni ey apil i esel to.” ");
INSERT INTO ibl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sajay i inkowan nen Jesus ja arig son si‐kara, nem eg sha ineẃatan. ");
INSERT INTO ibl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Isonga si Jesus, inkowan to may olog nonta arig son si‐kara, ja kowan to ey, “Kinapodpodno iya ikowan ko son si‐kayo, ey say kay‐eshigan nonta sakepan, si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sota ira engikowan nontan da ey si‐karay mengipangolo nonta ira took, si‐karay kay‐eshigan nonta eg nanshalan nodta sakepan; isonga may‐eshig ey si‐kara ket tolisan ira, ono makibot. Nem sota ira kalniro, eg sha ira inkaskaso. ");
INSERT INTO ibl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sota sakepan ni koral ni kalniro, may‐eshig ey si‐kak sotan. Isonga sota toon ondaw ali son si‐kak, isalakan ko, jet si‐karay kay‐eshigan nonta kalniro ja eẃaya men onsekep tan onbo‐day ya mengenap ni siged ja edet ja kenen sha. ");
INSERT INTO ibl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Sota tolisan, ondaw bengat ali ja mengibot, memono, ono meneshal. Nem si‐kak, say dinaẃan ko ali, nak mengi‐kan ni biyag ni too, jet sotan na biyag ja i‐akan ko, mas mapmapteng pay ey say sota maramen biyag sha. ");
INSERT INTO ibl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Si‐kak sota mapteng nga emengajowan ni kalniro, jet si‐kak, ja makakokowa nonta kalniro, naka isakit ira ja angken si‐karay kabol la keteyan ko. ");
INSERT INTO ibl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sota toon emanbantay bengat nonta kalniro ja dinagbo‐an, no ẃaray atap pa animal ja ondaw ali, onbetik ja idekjas to ira, jet mebokal ira, jet sota atap pa animal, elbaten toy eshom. ");
INSERT INTO ibl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sotan na emanbantay, idekjas to ira sota kalniro ta dinagbo‐an bengat; eg to ira isakit. ");
INSERT INTO ibl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nem si‐kak sota mapteng nga emengajowan nonta kalniro. Jet amtak ira sota kokowak, jet sota ira kokowak, am‐amtara‐ak ngo, ");
INSERT INTO ibl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","jet kasta met so nen Amak, amta towak, jet si‐kak ja Anak to, amtak ngo si Amak. Jet sota ira may‐eshig ey kalnirok, si‐karay kabol ni keteyan ko. ");
INSERT INTO ibl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Waray eshom ma kalnirok ja apil i naykoralan sha, jet mesepol la si‐kak met laeng i mengikasakey son si‐kara so nonta sigod ja kalnirok. No itenengan shay esel ko, ondaw ira di jet maykasakey ma ira, jet sota mengajowan son si‐kara, sakey ngo bengat ma. ");
INSERT INTO ibl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Si Amak, ensemek towak ta itolok koy biyag ko ja angken metey. Itolok ko, say odi‐en ko met laeng. ");
INSERT INTO ibl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Angken sipen too, enshiy kabaalan ton onbono son si‐kak no ekak itolok i bakdang ko, ta si‐kak met laeng i maka‐amta ni biyag ko, no piyan kon metey ono enshi. Mebedin na itolok ko iya biyag ko ja metey, jet mebedin met laeng nga odi‐en ko ja manbiyag mowan, ta si‐katoy inbilin nen Amak son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Idi enaksheng nga inkowan nen Jesus iyay, sota ira Hodiyos, eg ira man‐i‐inawatan jet nanshowa ira kabol nonta inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sota ira karakdan na Hodiyos, kowan sha ey, “Inpan‐angaw ni dimonyo itan na too. Ngantoy itenenganan jo so nita toka pan‐ikowan?” ");
INSERT INTO ibl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nem sota ira eshom ma Hodiyos, kowan sha ey, “Aliẃen sotan i itsoren kepan‐a‐sel ni toon inpan‐angaw ni dimonyo. No ẃaray dimonyon pimeket son si‐kato, mebedin ayen pan‐esas toy ekorab?” ");
INSERT INTO ibl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nontan na timpo, simabi ma sota timpon piyasta ni Hodiyos shi Jerusalem ja shaka penginemnemi nonta Timplo nen Apo Shiyos, jet sajay ya piyasta ni Hodiyos, emaytompong shi timpo ni teg‐in. ");
INSERT INTO ibl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jet si Jesus, dimaw nontan shima Timplo, jet nan‐akad nodta kowan sha ey Sishoman nen Solomon, ja naysilpo nodta Timplo. ");
INSERT INTO ibl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jet sota ira pangolo ni Hodiyos, binongolan shes Jesus, jet kowan sha ey, “Apay mebedjag pay aya i pengikowanan mo son si‐kami, no si‐kam sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos? No si‐kam sotan, ikowan mo son si‐kami say amta‐en mi.” ");
INSERT INTO ibl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jet si Jesus, simongbat ja kowan to ey, “Inkowan ko la son si‐kayo i maypangkep son si‐kak, nem eg kayo memati. Sota kowan nen Amak ey dag‐en ko, dingkak da, jet sotan met laeng koma i amta‐an jo so ma no si‐kak sota naypadto ono apil. ");
INSERT INTO ibl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nem si‐kayo, eg kayo memati ta aliẃen kalniro takejo, ");
INSERT INTO ibl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ta no kalniro takejo koma, istay pati‐en joy esel ko, ja inges to sota kalniro ja shaka onora i esel nonta makakalniro son si‐kara. Amtak i kokowak jet sota kokowak, sha‐akka on‐onora. ");
INSERT INTO ibl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jet sotan iren kokowak, naka akni ira ni biyag ja enshiy to engintegan, jet eg sha ma da‐kaman i shosa ingkatod ingka, jet enshiy makabaal ja onpiliw son si‐kak ni angken sakey son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Si Apo Shiyos ja Amak, si‐katoy Kangeto‐an ni emin. Isonga sota in‐awat to son si‐kak, angken sipa, enshiy en onpiliw so, ta si Amak i emengajowan son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Si‐kamin Amak, saksakey kami.” ");
INSERT INTO ibl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Idi intenengan ira nonta Hodiyos iyay, engala ira ni bato ja kowan sha ey kespigan sha si Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jet si Jesus kowan to son si‐kara ey, “Eshakel i mapteng nga dingkak ja obda nen Amak ja kowan to ey dag‐en ko. Jet towa nodtan na mapteng nga dingkak i kabol la kowan jo ey kespigan jowak so ni bato?” ");
INSERT INTO ibl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sota ira Hodiyos, simongbat ira ja kowan sha ey, “Aliẃen sota obden mapteng i kespigan mika so, no diket sota moka pengikokowani so ey si‐kam ket inges mos Apo Shiyos, ey anta nga too ka ngo met bengat ja inges mi. Satan i ebadeg ga basol mo.” ");
INSERT INTO ibl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Simongbat si Jesus ja kowan to ey, “Wara met i naysolat shi dinteg tayo ja kowan nen Apo Shiyos pangkep so nonta ira pangolo nonta bayag da, ja kowan to ey si‐kara, singa shiyos ngo ira. ");
INSERT INTO ibl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sotan na inkowan nen Apo Shiyos ja naysolat, eg mebedin na mesa‐datan ta si Apo Shiyos i engikowan. No inkowan nen Apo Shiyos nonta bayag da ey singa shiyos ngo ira sotan na inkowanan to so, ");
INSERT INTO ibl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","apay nga kowan jo ey basol ko no ikowan ko ey Anak towak nen Apo Shiyos, ey agpayso met ja si‐katoy mismon shimotok son si‐kak, jet inkowan to ey ondawak alid ja dobong? ");
INSERT INTO ibl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No say naka pandag‐a ket aliẃen sota piyan nen Amak, mebedin na angken eg jowak pati‐en. ");
INSERT INTO ibl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nem no eg jowak pati‐en, istay sota obden naka dagdag‐a, si‐kato koma mangoy pati‐en jo, ta sotan na dingkak, si Apo Shiyos i edapo‐an to, jet si‐katoy amta‐an jo so koma ey si‐kak, ẃara‐ak son Apo Shiyos ja Amak, jet si Apo Shiyos, ẃara ngo son si‐kak.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jet sota ira Hodiyos, piyan sha mowan na a‐shelen si Jesus, nem bimetik si Jesus; isonga eg sha inshel. ");
INSERT INTO ibl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jet si Jesus, bimaliw shima pa‐dok ka kowan sha ey Jordan et dimaw shima dogad ja emonjagan nen Juan nonta pilmiro. Jet nan‐iyan nin si Jesus shiman. ");
INSERT INTO ibl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jet nonta ẃares Jesus shiman, eshakel iray totoon dimaw son si‐kato jet say kowan sha ni tabtabal sha, kowan sha ey, “Si Juan, enshiy to dingken milagro ja inges to jay, nem emin sota inkowan to ni maypangkep niyay ya too, nay‐agpayso.” ");
INSERT INTO ibl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jet nontan, sota eshakel la toon dimaw son Jesus shiman, eshakel son si‐karay emati. ");
INSERT INTO ibl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Wara iray san‐a‐aki ja nanbaley shi Bitania, jet say ngaran sha, si Maria, si Marta, tan si Lazaro. Jet si Lazaro, ja agi sha, nansakit. (Si Maria, si‐kato sota mengiro‐jag ali ni emanseng‐ew wa dana shi sedi nen Jesus, asan toka ponasi ni bowek to.) ");
INSERT INTO ibl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Si Maria nen Marta, engibetkag ira ni en mengikowan son Jesus ey, “Apo, si Lazaron ensemek mo ket emansekit.” ");
INSERT INTO ibl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Idi inamta‐an nen Jesus ey emansekit si Lazaro, kowan to ey, “Sotan na sakit, eg ipatey nen Lazaro, no diket si‐katoy kayshedjawan nen Apo Shiyos, tep si‐katoy ka‐asan ni kina‐Shiyos ni Anak to.” ");
INSERT INTO ibl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Si Jesus, ebadeg i semek to so ira niyay ya san‐a‐aki. ");
INSERT INTO ibl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nem nonta inamta‐an to ey emansekit si Lazaro, nan‐iyan nin shima toka pan‐iyani ni showen akew pay. ");
INSERT INTO ibl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Idi edabas sota showen akew, inkowan nen Jesus so nonta ira too to ey, “Eti, ondaw kito mowan shi Jodia.” ");
INSERT INTO ibl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jet kowan nonta ira too to ey, “Apo, ngantoy daẃan tayo mowan shi Jodia ey nonta pinsak ka dinaẃan tayod man ket piyan ira nonta pangolo ni Hodiyos shiman na kespigan shaka ni bato say mebono ka?” ");
INSERT INTO ibl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Si Jesus, simongbat ja kowan to ey, “No ka‐akawan i pan‐ekad, eg kita maysokbab, ta aliẃen embolinget. Wara met i sampolo tan showen oras ja ka‐akawan; isonga no oras ni ka‐akawan i pan‐ekad, eg kita maysokbab ta ma‐esas i shalan ja pan‐akshan, tep sinilẃan ni sekit. ");
INSERT INTO ibl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nem sota man‐ekad ni medebi, mebedin na maysokbab, ta eg to asen i panshandan to, tep enshiy onsilew son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jet si Jesus, intoloy ton kowan to ey, “Si Lazaro ja kajem tayo, na‐ogip mala, jet ondawak ta nak bengonen.” ");
INSERT INTO ibl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jet kowan nonta ira too to son si‐kato ey, “Apo, mapteng no na‐ogip, say onpesed.” ");
INSERT INTO ibl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(Sajay i insongbat sha tep kowan sha ey kenshat ta na‐ogip bengat si Lazaro, nem say piyan na a‐selen nen Jesus gayam, etey da si Lazaro.) ");
INSERT INTO ibl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Idi inamta‐an nen Jesus ey eg ineẃatan nonta ira too to sota inkowan to, indiritso ton inkowan ey etey da si Lazaro. ");
INSERT INTO ibl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jet say kowan to pay, “Ebadeg i imdeng ko ta enshi‐ak shiman nonta inkatey nen Lazaro. Sajay ya edaga son si‐kato, panmaptengan jo, tep onba‐deg i pamatiyo son si‐kak. Jet niman, eti, ondaw kito shi kawad‐an to.” ");
INSERT INTO ibl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas, ja kowan sha ey Epin, ja sakey so ira nonta too nen Jesus, kowan to so ni kait to ey, “Mekidaw kito son Apo Jesus, jet angken metey kito ja may‐a‐shom son si‐kato no bono‐en sha!” ");
INSERT INTO ibl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Idi mimotok ma si Jesus shi Bitania, epat ta akew malen naydiyang si Lazaro. ");
INSERT INTO ibl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Saja dogad ja Bitania, say ka‐ashawi to shi Jerusalem, tedon kilomitro bengat; ");
INSERT INTO ibl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","isonga nonta etey ma si Lazaro, eshakel iray Hodiyos ja edapod Jerusalem ja en nanbisita so nen Maria nen Marta ja emandiwdiwa son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Idi inamta‐an nen Marta ey emanmotok si Jesus, bimo‐day jet to inaspol si Jesus, nem si Maria, si‐katoy ebay‐an shima baley. ");
INSERT INTO ibl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jet kowan nen Marta so nen Jesus ey, “Apo, no ẃara ka komed jay nonta kepansekit nen agik, istay eg etey koma. ");
INSERT INTO ibl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nem amtak ey angken niman, no ngantoy kekshawen mo so nen Apo Shiyos, i‐akan to son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Simongbat si Jesus ja kowan to ey, “Si agim da, manbiyag mowan.” ");
INSERT INTO ibl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jet si Marta, simongbat ja kowan to ey, “Amtak ey no timpo ali ni panbiyag mowan ni nanketey, manbiyag ngo si Lazaro.” ");
INSERT INTO ibl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Simongbat si Jesus mowan, ja kowan to ey, “Si‐kak i panbiyag so ira nonta nanketey, tan mengi‐kan ni biyag sha; isonga sota memati son si‐kak, angken na metey, manbiyag met laeng. ");
INSERT INTO ibl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jet angken sota ira too niman ja eg pay laeng etey, no memati ira son si‐kak, i‐aknan ko ira ni biyag ja enshiy to engintegan. Jet si‐kam, moka pati‐a iya inkowan ko la?” ");
INSERT INTO ibl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Si Marta, simongbat ja kowan to ey, “Naka memati ey si‐kam sota naypadton mengisedakan ja Anak nen Apo Shiyos ja ibetkag to alid ja dobong!” ");
INSERT INTO ibl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Idi enaksheng iyay ya inpantabtabal nen Jesus nen Marta, nay‐oli si Marta shima baley jet idi naydasin ira nen Maria nodta eshakel la too, inkowan to son si‐kato ey, “Wara sota Maistoro jet tokaka pan‐ibaga.” ");
INSERT INTO ibl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Idi inkowan nen Marta iyay son Maria, dimayat ta shagos jet dimaw shima kawad‐an nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Si Jesus, eg pay laeng simabi nodta kawad‐an ni baley nen Maria, no diket ẃara pay laeng nodta dogad ja en inaspolan so nen Marta. ");
INSERT INTO ibl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jet sota ira Hodiyos ja bisita ja ẃara nodta baley ja emandiwdiwa son Maria, idi inon‐an sha ja kinano‐an nen Maria ja bimo‐day, inonod sha, ta say ẃared nemnem sha, kowan sha ey baka ondaw si Maria shima naydiyangan nen Lazaro ja en onnangis shiman. ");
INSERT INTO ibl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Si Maria, idi mimotok shima kad‐an nen Jesus, nanshomog nodta sango‐an nen Jesus jet kowan to ey, “Apo, no ẃara ka komed jay nonta kepansekit nen agik, istay eg etey koma.” ");
INSERT INTO ibl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jet si Jesus, inon‐an to ja emannengis si Maria, tan angken pay sota ira Hodiyos ja ekidaw ali son Maria, ireka onnanengis ngo, jet si Jesus, ngimed‐as. ");
INSERT INTO ibl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jet inbag‐an to ira ja kowan to ey, “Toway indiyangan jo so nen Lazaro?” Simongbat ira ja kowan sha ey, “Kala Apo. Mo asas i indiyangan mi so.” ");
INSERT INTO ibl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jet si Jesus, nimangis ngo ma. ");
INSERT INTO ibl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jet sota ira Hodiyos, kowan sha ey, “Asas jo kari, ensemek ton pasiya si Lazaro.” ");
INSERT INTO ibl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nem sota ira eshom ma Hodiyos ngo, kowan sha ey, “No agpayson inpan‐asas to sota ekorab, apay ngarod nga enshiy to dingka say eg etey si Lazaro?” ");
INSERT INTO ibl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jet si Jesus, mas pay ya ngimed‐as, jet dimaw nodta diyang nga naydiyangan nen Lazaro. Sota diyang, epokit ni bato; ");
INSERT INTO ibl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","isonga si Jesus, inbilin to ey a‐kalen sha sota bato ja naypokit nodta bongot ni diyang. Nem si Marta, ja agi nonta etey, kowan to ey, “Apo, epat ta akew to niman na naydiyang. Sigoradon eman‐ekob mala niman na pasiya!” ");
INSERT INTO ibl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jet si Jesus, simongbat ja kowan to ey, “Apay ekak aya inkowan nontan son si‐kam ey no memati ka, asen moy obdak ja kayshedjawan nen Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jet sota bato ja naypokit nodta diyang, ingkal sha. Jet si Jesus, timangkak ja kowan to ey, “Naka man‐iyaman son si‐kam Ama, ta moka i‐akan no ẃaray kekshawen ko son si‐kam. ");
INSERT INTO ibl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Amtak ey moka itenengi ni olay i naka ishawat son si‐kam, nem say engibolikasan ko so niyay ya shawat son si‐kam, say itenengan ira niya toon ẃared jay niman, say memati ira ey agpayso ja si‐kam i engibetkag son si‐kak shiya dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Idi enaksheng nga inkowan nen Jesus iyay, kimeljaw ja kowan to ey, “Lazaro, bo‐day ka di!” ");
INSERT INTO ibl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jet si Lazaro, bimo‐day ali, ja ebedbeshan i takday to tan sedi to, tan edibotan i dopa to ni dopot ta shaka idibot ni etey. Jet si Jesus, kowan to so nonta ira toon ẃara nodtan ey obaren sha sota naybedbed say ka‐ẃay ton man‐ekad. ");
INSERT INTO ibl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sota ira Hodiyos ja bisita nen Marta nen Maria, inon‐an sha sota inpasing nen Jesus ja emiyag son Lazaro, isonga eshakel son si‐karay emati son Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nem sota eshom ja Hodiyos, dimaw ira so nonta ira Parisiyo, jet sha inkowan i dingka nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jet nontan ma, sota ira Parisiyo, tan sota apo ira ni papashi, nanmimiting ira nonta toray ni Timplo, jet kowan sha ey, “Ngantoy pesing tayo aya so nen Jesus? Eshakel ma i dingdingka to ja kaskasshaaw. ");
INSERT INTO ibl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","No itolok tayo ja sotan ni olay i pesing to, eshakel malay ma‐eẃis ja memati son si‐kato, jet ondaw ma aliy i‐Roma ja meneshal niya Timplo tayo, tan saja ili tayo.” ");
INSERT INTO ibl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nem sota kangeto‐an na pari nontan na tawen, ja si Kaipas i ngaran to, kowan to ey, “Enshi gayam i amtayo. ");
INSERT INTO ibl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Eg jo gayam amtay panmaptengan jo. Agpos et ey metey iya sakey ya too, say eg meshosa i totood ja ili tayon Israel.” ");
INSERT INTO ibl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Sajay ya inkowan nen Kaipas, aliẃen edapod nemnem to, no diket inpaipadto nen Apo Shiyos, ta si‐kato nontan i kangeto‐an na pari. Jet sajay ya inkowan to, pinonta‐an to nga agpayso ey si Jesus, metey say eg meshosa i tood Israel, ");
INSERT INTO ibl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","jet aliẃen si‐kara bengat, no diket angken pay sota ira emin na annak nen Apo Shiyos ja nayẃaris shi intiron dobong, say manseksekey ira ja memati son Jesus.) ");
INSERT INTO ibl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jet nontan ma, ẃaray plano iren ja esa‐nop ey bono‐en sha si Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Isonga nontan ngo ma, eg manpa‐sas si Jesus shi karakdan shi Jodia, no diket inpa‐agpos ton dimaw shima dogad ja kowan sha ey Ipraim ja nay‐esop shima shonshontog ja enshiy balbaley, jet eki‐iyan nin shiman so nonta ira too to. ");
INSERT INTO ibl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Shanshani ma sota timpo ni piyasta ni Hodiyos ja kowan sha ey Paskowa jet eshakel iray toon dimaw shi Jerusalem ja edapod dogadogad ja nay‐esop shiman, say sha dag‐en sota sigod ja ogadi ni Hodiyos ja shaka dagdag‐a asan ireka makipiyasta. ");
INSERT INTO ibl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jet sota ira eshakel la totoo nodta Timplo, shaka pan‐enapa no ẃares Jesus, nem enshi. Jet nanbibinaga ira sota totoo, ja kowan sha ey, “Nganto ngatay namnama jo: ondaw ngata di, ono enshi?” ");
INSERT INTO ibl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nontan, sota ira apo ni papashi, tan sota ira Parisiyo, inkowan sha so nonta ira totoo ey no sipa son si‐kara i maka‐amta ni kawad‐an nen Jesus, ikowan sha son si‐kara say sha a‐shelen. ");
INSERT INTO ibl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waray enem ma akew pay nin asan kesabi sota piyasta ni Hodiyos ja kowan sha ey Paskowa, jet dimaw si Jesus shi Bitania ja nanbaljan nen Lazaro ja istay etey nem inpanbiyag nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jet si Jesus, ekipengan shiman ni mama‐shem tep inpalti‐an sha. Si Marta, timolong nga nankamakam, jet si Lazaro, si‐katoy sakey ya ekilikob son Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jet nontan, si Maria, engala ni poron danen emanseng‐ew ja kowan sha ey naldo, jet to insho‐jag shi sedi nen Jesus asan toka ponasi ni bowek to shorog, jet sota baley ya kawad‐an sha, enapno ni seng‐ew nonta dana. Sajay ya insho‐jag nen Maria shi sedi nen Jesus, epalit jet ẃara emoy midjen kilo ja insho‐jag to. ");
INSERT INTO ibl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jet si Judas Iskariote ja sakey so nonta ira too nen Jesus, ja mengibaag ali so nen Jesus so nonta ira makakontra son si‐kato, kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kimawas iman na dana! Apay nga eg to et indako, say sota dako to, may‐ekan na tolong so nonta ira nankebiteg? Say banol nontan na kalasin dana, no maydeko, tedon dasos.” Kowan nen Judas Iskariote. ");
INSERT INTO ibl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nem kekaskasin ẃaray kepengisekit nen Judas; nem enshi kari i toka pengisekit ni nankebiteg. Si‐katoy para egshi ni pilak nonta totoo nen Jesus, jet sota eshom ma pilak ja ẃara nodta ijanan, toka pankibota. ");
INSERT INTO ibl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jet si Jesus, simongbat ja kowan to ey, “Baybay‐im si Maria, ta satan na danen intalo to, para so niya bakdang kon maybebka ali. ");
INSERT INTO ibl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sota ira nankebiteg, ẃara ni olay son si‐kayo, isonga mebedin na todongan jo ira; nem si‐kak, eg mebedjag i pekikadẃak son si‐kayo.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jet nontan met laeng, shinemag ira nonta eshakel la Hodiyos ey ẃara si Jesus shi Bitania, isonga dimaw ired man. Aliẃen si Jesus bengat i piyan shen on‐an, no diket piyan sha pay ja asen ngo si Lazaro ja inpanbiyag nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Isonga sota ira apo ni papashi, ẃaray pangkep sha pay ya bono‐en si Lazaro, ");
INSERT INTO ibl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta eshakel iray Hodiyos ja emati son Jesus nonta inon‐an sha ja inpanbiyag to si Lazaro, jet eshakel malay eg memati so nonta ira papashi. ");
INSERT INTO ibl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nonta maykadẃen akew, sota eshakel la toon dimaw nodta piyasta shi Jerusalem, shinemag sha ey ondaw alis Jesus nodtan na piyasta. ");
INSERT INTO ibl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jet engala ira ni bolong nonta niyog, jet sha inaspol si Jesus ja ireka onkaneljaw ni iyaman sha son Apo Shiyos, ja kowan sha ey, “Salamat son Apo Shiyos! Bindisiyonan to koma iya toon inbetkag to di, ja ari tayon i‐Israel!” ");
INSERT INTO ibl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Si Jesus, ẃaray simbi ton kilaw ni kowan sha ey donkey, jet si‐katoy nankabajo‐an to. Sajay i kaytoshongan nonta padto ja naysolat nonta bayag da ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Si‐kayon i‐Jerusalem, karekayo ontakot, ta sota ari jo, ondaw da son si‐kayo ja mengi‐kan ni talna; isonga mankebayo shi kilaw ni donkey.” ");
INSERT INTO ibl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sajay ya padto, eg nin ineẃatan nonta iratoo nen Jesus i olog to nonta pilmiro. Nem idi etey si Jesus et nanbiyag mowan asan ka‐oli mowan da shi dangit, ninemnem sha ma ey sajay ya padto ket si‐kato gayam i naytorongan nonta padto et etongpal. ");
INSERT INTO ibl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Sota ira eshakel la too ja engasas ni inpanbiyag son Jesus so nen Lazaro nodta diyang, si‐karay engikowan so ni eshom ma totoo; isonga eshakel aliy dimaw ja en nay‐aspol so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Isonga sota ira Parisiyo, kowan sha ni tabtabal sha ey, “Asas jo kari, enshi may pesing tayo, ta emin malen too ket imonod ira son si‐kato!” ");
INSERT INTO ibl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Angken sota ira aliẃen Hodiyos, ẃaray eshom ma dimaw shi Jerusalem ja en manshedjaw son Apo Shiyos nonta timpo ni piyasta ni Hodiyos ja Paskowa. ");
INSERT INTO ibl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jet sajay iren totoo, dimaw ira so nen Felipe ja i‐Bitsaida ja sakop ni Galilia, jet kowan sha ey, “Apo, piyan min asen si Jesus.” ");
INSERT INTO ibl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jet si Felipe, to inkowan so nen Andres, jet nan‐olop ira ja sha inkowan so nen Jesus ey, “Wara iray toon makapiyan ja mengesas son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jet si Jesus, simongbat ja kowan to ey, “Sota timpon i‐olik shi dangit, simabi ma, ta si‐kak sota Anak ni Too. ");
INSERT INTO ibl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kinapodpodno iya ikowan ko son si‐kayo. Say kay‐eshigan ko, sota ilik ni pagey. Sota ilik ni pagey, no mebaybay‐an ja eg may‐a‐sek shi bo‐day, eg ma onshakel. Nem no sotan na ilik ket maymoda shi bo‐day, onshakel ma. ");
INSERT INTO ibl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sota toon toka kaẃani i biyag to, mepokaw et ngo mowan; nem sota toon eg to kaẃanan i biyag to shiya dobong pangkep son si‐kak, meẃad‐an ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sota toon makapiyan ja mansilbi son si‐kak, mesepol la si‐kak i onoren to. No toway kad‐an ko, si‐kato ngoy kawad‐an to, jet sota ira toon emati ja emansilbi son si‐kak, i‐aknan nen Amak ni shayaw sotan na too.” ");
INSERT INTO ibl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Niman, simabi ja naka emankaikelkel‐eẃi, jet nganto emoy ishawat ko son Amak? Ikowan ko ngata son Amak ey idisi towak niya digat ja emansessesked son si‐kak? Nem enshi, ta sajay i kabol la dinaẃan ko did jay. Isonga enosan koy digat.” ");
INSERT INTO ibl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jet si Jesus, nanshawat son Apo Shiyos ja kowan to ey, “Ama, si‐kam i mengipa‐sas met laeng ni kayshedjawan mo.” Idi enaksheng iya shawat nen Jesus, ẃara aliy esel ja edapod dangit, ja kowan to ey, “Inpa‐sas koy kayshedjawan ko, pangkep nonta kaskasshaaw ja dingkam, nem pinshowa‐en kon ipa‐sas pay i kayshedjawan ko, pangkep nita dag‐en mo di.” ");
INSERT INTO ibl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jet sota eshom ma totoon nay‐esop son Jesus, kowan sha ey kimirol, nem sota eshom, kowan sha ey, “Waray inkowan ni anghil son Jesus.” ");
INSERT INTO ibl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nem si Jesus, say kowan to so nonta totoo, kowan to ey, “Sota esel ja intenengan jo nonta ekay da, aliẃen panmaptengan ko, nem eg panmaptengan jo, tep kabol nontan na esel ket memati kayo koma. ");
INSERT INTO ibl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Niman ma i panshoki ni keshosa ni tood ja dobong, tan niman i keshagshag nonta emengitoshay niya dobong ja si Satanas. ");
INSERT INTO ibl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No meksheng nga maykedjangak ja maydansa, si‐kak met laeng i mengeẃis ni toon ondaw ali son si‐kak ja memati.” ");
INSERT INTO ibl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sajay i inkowan nen Jesus ta piyan ton say eẃatan koma ira nonta totoo i itsora ni ketey to. ");
INSERT INTO ibl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nem sota ira totoo, simongbat ira ja kowan sha ey, “Say intenengan mi met ja kowan ira ni dinteg ket sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos ket eg kono metmetey ingkatod ingka. Ngantoy pesing nita kowan mo ey maykedjang ka ja maydansa? Kowan mi nem si‐kam sota naypadton Anak ni Too! No aliẃen si‐kam, sipa ngarod ngay i kaytoshongan nonta naypadton ibetkag ali nen Apo Shiyos?” ");
INSERT INTO ibl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Simongbat si Jesus, ja kowan to son si‐kara ey, “Sota may‐eshig ey silew ja ondawag ni nemnem jo, entikey ya timpoy kawasha to son si‐kayo. Isonga niman ta ẃara pay laeng son si‐kayo, iringan jon man‐ekad; ta no medebi‐an kayo, eg jo amtay toshongen jo. ");
INSERT INTO ibl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Isonga niman ta ẃara pay laeng son si‐kayo sota silew wa ondawag so ni nemnem jo, pamati kayo ma son si‐kato, say ẃaray kay‐ingesan jo son si‐kato.” Kowan nen Jesus. Idi naksheng nga inkowan nen Jesus iyay, indekjas to ira, jet dimaw nodta dogad ja eg onoran so ira niyay ya totoo. ");
INSERT INTO ibl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Eshakel i kaskasshaaw wa dingka nen Jesus, nem eg patpati‐en ira nonta totoo. ");
INSERT INTO ibl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sajay i kaytoshongan nonta naysolat ja kowan nen Isaias ja para padto nonta bayag da ey, “Apo, enshiy ememati nonta mika pan‐ikowan son si‐kara, jet enshi emo may engipa‐sasan nen Apo Shiyos ni panakabalin to.” ");
INSERT INTO ibl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","41","Isonga eg mebedin na memati ira. Si Isaias, inon‐an toy kina‐Shiyos nen Cristo tep mismon inpa‐sas nen Apo Shiyos son si‐kato. Isonga ẃaray inpadto to ja kowan to ey, “Si Apo Shiyos, si‐kato met laeng i singa kimorab son si‐kara, tan inpatangken so ni nemnem sha, say eg asen ni matesha tan eg sha eẃatan, say eg ira di ondaw son si‐kak ja manpa‐ekas.” ");
INSERT INTO ibl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nem eshakel met laeng iray toray ja emati son Jesus, nem sajay iren emati, eg sha ipa‐sas ey emati ira, ta entakot sha iray Parisiyo ey a‐kalen sha ira shima sa‐nopan ni Hodiyos, ja eg ma ira mebedin na mekisa‐sa‐nop. ");
INSERT INTO ibl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eg sha ipa‐sas ey ireka memati tep say pipiyan sha, sota kosto‐an so ni too son si‐kara, ey aliẃa et ta sota kosto‐an so nen Apo Shiyos son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iyay iray epangdon inkowan nen Jesus pangkep niyay: kowan tod karakdan ni too ey, “Sota ira memati son si‐kak, aliẃen si‐kak bengat i pinatira, no diket emati ngo ira so nen Amak ja engibetkag ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tan sota ira engasas son si‐kak, amtara may itsora nen Amak ja engibetkag son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Dimawak alid jay ya may‐eshig ey silew ni tood ja dobong, say medeẃagan i nemnem sha. Jet sota ira memati son si‐kak, may‐eshig ey enshi ma ira shi embolinget. ");
INSERT INTO ibl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sota ira toon mengitneng ni ikowan ko, nem eg sha pati‐en, aliẃen si‐kak i mengigsheng ni keshosara, ta aliẃen sotan i dinaẃan ko did jay, ta say podnon dinaẃan ko did jay, nak koma isalakan ira ja tood ja dobong. ");
INSERT INTO ibl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sota ira eg memati son si‐kak, ono eg mengeẃat nonta ikowan ko, meshosa ira ali, jet say kaybetayan ali ni keshosa‐an sha shi ka‐onoran na akew, sota intorok ja intenengan sha. ");
INSERT INTO ibl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta sotan na inkowan ko, aliẃen si‐kak i makanemnem, no diket sotan i inkowan nen Amak ja engibetkag alid jay son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jet amtak ey sota inkowan nen Amak ja itorok so ni totoo, sotan i mengi‐kan ni biyag ja enshiy to engintegan; isonga emin sotan na inkowan nen Amak son si‐kak, si‐kato ngoy naka itoro ni olay son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Shanshani ja manshoki sota piyasta ni Hodiyos ja kowan sha ey Paskowa, jet si Jesus, amta to ey sotan may timpo ja idekjasan to so niya dobong, ja on‐oli ma so nen Ameto shi dangit. Nontan na timpo i pengipa‐sas to ey enshiy kolang ni semek to so ni totoo ton ẃared ja dobong, ta sigod ja ensemek to ngoreshan ira. ");
INSERT INTO ibl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Jet si Satanas, inpannemnem tos Judas Iskariote ja anak nen Simon, ey to ibaag si Jesus so nonta makakontra son si‐kato. Nem si Jesus, amta to ey in‐akan nen Ameton emin i panakabalin son si‐kato. Tan amta to ey say edapo‐an to shorog ket si Apo Shiyos, jet si Apo Shiyos met laeng i odi‐an to. Isonga nonta mama‐shem ja nandilikob ira sota apostol ton emengan, pati si‐kato, ");
INSERT INTO ibl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","dimayat si Jesus jet ingkal to sota nayta‐kep shi baro to, jet inda to sota towalja asan toka ibalkes. ");
INSERT INTO ibl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Engala ni shanom jet insho‐jag to nodta palangkana jet inshogi ton sina‐sa‐key ja odsan i sedi nonta ira apostol to, asan toka ponasi nonta towalja ja inbalkes to. ");
INSERT INTO ibl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Idi onsabi so nen Simon Pedro, kowan nen Pedro ey, “Apo, apay, odsan mo ngoy sedik?” ");
INSERT INTO ibl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jet si Jesus, simongbat ja kowan to ey, “Eg mo nin eẃatan iyay ya naka pandag‐a, nem no ekay amta‐en moy olog to.” ");
INSERT INTO ibl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Si Pedro, kowan to ey, “Ekak itolok ja odsan moy sedik.” Jet si Jesus, kowan to ey, “No ekak odsan i sedim, enshi may biyang mo son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jet si Simon Pedro, timolok ja kowan to ey, “No kasta Apo, aliẃen saja sedik bengat i odsan mo, no diket pati saja takday ko, tan saja toktok ko.” ");
INSERT INTO ibl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Si Jesus, simongbat ja kowan to ey, “Say toon naksheng nga nan‐emes, edinis sa emin i bakdang to, jet say mesepol la ma‐odsan bengat, sota sedi to. Jet emin kayo, maybidang ey edinis kayo, nem ẃaray sakey bengat son si‐kayo ja aliẃen edinis.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Ta amta ton sigod no sipa nodta too to sota mengibaag son si‐kato so nonta ira toon makakontra son si‐kato; isonga inkowan to ey ẃaray sakey so nodta too to i aliẃen edinis.) ");
INSERT INTO ibl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Idi naksheng nga inodsan nen Jesus i sedira, inbaro to mowan sota ta‐kep ni baro to, jet imolin timongaw nodta sigod ja tinongawan to ja kad‐an ni damisaan jet kowan to ey, “Joka eẃati iyay ya dingkak son si‐kayo? ");
INSERT INTO ibl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Sota awag jo son si‐kak ja kowan jo ey Maistoro tan Apo jo ket agpayso; jet anam to ta agpayson si‐kak sotan. ");
INSERT INTO ibl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nem asas jo kari; si‐kak et ngo mowan i engoras ni sediyo, ey si‐kak pay i apo jo tan maistoro jo. Isonga pandaga kayo ngo ni pansigshan ni sakey tan sakey son si‐kayo, ja angken mengoshas kayo ngo ni sedi ni kait jo. ");
INSERT INTO ibl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sajay i dingkak, say ẃaray onoran jo. ");
INSERT INTO ibl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kinapodpodno iya ikowan ko son si‐kayo. Sota baga‐en, aliẃen si‐kato et ngo mowan i ibaingan ni totoo ey say sota apo to. Jet inges niyay sota emaybetkag. Sota emaybetkag, aliẃen engatngato ey say sota emengibetkag son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Niman, amtayo ma ira ja inkowan ko la, jet si‐kato komay onoran jo ja dag‐en. Jet say panbenagan to, man‐imdeng kayo. ");
INSERT INTO ibl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Sajay ya naka pan‐ikowan, aliẃen na para son si‐kayon emin, ta amtak i itsora jon apostol ko ja pinidik. Nem mesepol la metongpal sota padto nonta bayag da ja naysolat ja kowan to ey, ‘Sota pinekan ko, si‐kato et ngo mowan i nanbalin na makakontra son si‐kak.’ ");
INSERT INTO ibl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Insigod ko ja inkowan son si‐kayo niman iyay ta no onsabi sota timpo ja medeka son si‐kak iyay, piyan kon memati kayo ey si‐kak sota naypadton mengisedakan ja inbetkag nen Apo Shiyos alid ja dobong. ");
INSERT INTO ibl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nem kinapodpodno iya ikowan ko ni maypangkep son si‐kayon mebay‐an ja ibetkag ko. Sota mengeẃat son si‐kayo, may‐eshig ey si‐kak i ineẃat to, jet sota mengeẃat son si‐kak, may‐eshig ey si Amak ja engibetkag son si‐kak i ineẃat to.” ");
INSERT INTO ibl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Idi enaksheng nga inkowan nen Jesus iyay, naykel‐eẃan et kowan to so nonta ira apostol to ey, “Kinapodpodno iya ikowan ko son si‐kayo. Waray sakey son si‐kayo ja si‐katoy mengibaag son si‐kak so nonta ira toon makakontra son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jet sota apostol to, nansisini‐ning bengat ira, ta eg sha amta no sipa sotan na too ja toka pan‐ikowan son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Waray sakey so nonta ira apostol nen Jesus ja ensemek ton pasiya; timongaw shi nay‐askang son Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Si Simon, sininjasan to sotan na nay‐askang son Jesus, ja kowan to ey, “Ibag‐im ka no sipay kaytoshongan nonta inkowan to la.” ");
INSERT INTO ibl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Imiral sotan na too son Jesus jet inbag‐an to ja kowan to ey, “Sipa ta kowan mo ey mengibaag son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jet si Jesus, simongbat ja kowan to ey, “Sota pengi‐kanan ko nonta tinapay ya i‐eneng ko, si‐kato sotan na too.” Jet si Jesus, engala ni tinapay jet in‐eneng to, asan toka i‐kan so nen Judas Iskariote. ");
INSERT INTO ibl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Idi enaksheng nga ineẃat nen Judas Iskariote sotan na tinapay, simekep ma si Satanas son si‐kato. Jet si Jesus, kowan to so nen Judas ey, “Kano‐im, dagam ma sota dag‐en mo.” ");
INSERT INTO ibl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jet sota eshom ma apostol nen Jesus, ja nandilikob, eg sha ineẃatan iya inkowan nen Jesus so nen Judas. ");
INSERT INTO ibl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Say ẃared nemnem ni eshom, kowan sha ey inbetkag nen Jesus si Judas ja en menongkal ni mesepol sha ta timpo ni piyasta, ono inbetkag to ja en mengi‐kan ni pilak so nonta ira nankebiteg. Ta si Judas i para egshi nonta pilak sha. ");
INSERT INTO ibl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jet idi enaksheng nga ineẃat nen Judas Iskariote sota tinapay son Jesus, bimo‐day nodta baley ya kad‐an sha. Jet nontan na inbo‐day to, edabi. ");
INSERT INTO ibl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Idi bimo‐day mala, kowan nen Jesus ey, “Niman ma sota timpo ja kayshedjaw ko, ja naypadton Anak ni Too, tan kayshedjaw nen Apo Shiyos pangkep nonta dag‐en ko ali. ");
INSERT INTO ibl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","No si Apo Shiyos ket sota dag‐en ko i kayda‐kaman to ni shayaw, si‐kato ngoy mengiredjaw son si‐kak. Jet sajay, medeka son si‐kak ka shagos. ");
INSERT INTO ibl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Si‐kayon took ja naka ikari ey annak ko, aliẃen enshokey ya timpoy kawashak son si‐kayo. Jet niman, ipinshowak sota inkowan ko so nonta ira toray ni Hodiyos, ey ẃaray timpon onsabi ja en‐enapen jowak, nem shima daẃan ko, eg mebedin na on‐onod kayo. ");
INSERT INTO ibl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Niman, iyay pay i ikowan ko son si‐kayo, ja badon bilin. Mesepol la ẃaray semek jo so ni sakey tan sakey son si‐kayo, ja inges toy semek ko son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta sajay i amta‐an so ni totoo ey si‐kayo ket agpayson too takejo.” ");
INSERT INTO ibl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Inkowan nen Simon Pedro ey, “Apo, toway kowan mo ey daẃan mo?” Simongbat si Jesus ja kowan to ey, “Eg mebedin na on‐onod ka niman son si‐kak, nem ẃara diy timpon onoren mowak.” ");
INSERT INTO ibl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Si Pedro, kowan to mowan son Jesus ey, “Apay eg mebedin aya ja on‐onoshak niman shi daẃan mo? Ta si‐kak, esagana‐ak, ja angken meteyak ja mengibediw son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nem si Jesus, simongbat ja kowan to ey, “Jet agpayson angken metey ka ja mengibediw son si‐kak? Ikowan koy podno son si‐kam: memintedo ja ikowan mo ey eg mowak am‐amta asan ketekok sota kawitan.” Sajay i kowan nen Jesus son Pedro. ");
INSERT INTO ibl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jet kowan pay nen Jesus ey, “Karekayo meshanagan; pamati kayo et son Apo Shiyos, tan pamati kayo ngo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Shima dogad ja kad‐an nen Amak, eshakel i pan‐iyanan, jet ondawak ja en mengisekana ni pan‐iyanan jo. No sajay ya inkowan ko ket, aliẃen agpayso, istay ekak koma ikowan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No meksheng nga isaganak sotan na dogad ja pan‐iyanan jo, on‐oli‐ak ali et al‐en takejo, ta piyan kon shima kad‐an ko ket si‐kato ngoy pan‐iyanan jo. ");
INSERT INTO ibl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jet amtayo i shalan ja ondaw shima dogad ja daẃan ko.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Si Tomas, kowan to ey, “Apo, eg mi amtay daẃan mo; isonga eg mi amtay shalan.” ");
INSERT INTO ibl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jet si Jesus, simongbat ja kowan to ey, “Si‐kak i may‐eshig ja shalan, si‐kak i podno, si‐kak i mengi‐kan ni biyag. Enshiy angken sipa ja maka‐edaw so nen Amak, no eg nin manshedan son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No amtayo koma no sipa‐ak, istay angken si Amak, amtayo koma ngo. Jet manipod ma niman, amtayo ma si Amak ta singa inon‐an jo.” ");
INSERT INTO ibl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Si Felipe, kowan to ey, “Apo, ipa‐sas mo son si‐kami si Ama say mepnek kami.” ");
INSERT INTO ibl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Si Jesus, simongbat ja kowan to ey, “Felipe, ebayag ga naykadẃa‐ak met son si‐kayo, ket eg mowak pay laeng gayam amta? Sota engasas son si‐kak, amtara may itsora nen Amak. Apay nga ikowan mo ey ipa‐sas kos Amak son si‐kayo? ");
INSERT INTO ibl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Apay eg kayo memati aya ey si‐kak, ẃara‐ak so nen Amak, jet si Amak ẃara ngo son si‐kak? Emin sota inkowan ko la son si‐kayo, aliẃen edapo shi nemnem ko, no diket sotan i inkowan nen Amak son si‐kak. Jet emin sota dingkak, si‐katoy inbilin to. Si Amak, ẃara ni olay son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Patiyo ey si‐kak ket ẃara‐ak so nen Amak, jet si Amak, ẃara ngo son si‐kak. Nem no eg jo pay laeng pati‐en, patiyowak koma mango ta inon‐an joy dingdingkak. ");
INSERT INTO ibl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Kinapodpodno iya ikowan ko son si‐kayo. Sota memati son si‐kak, dag‐en to ngoy inges ni dingdingkak ja kaskasshaaw. Jet sotan na dag‐en to, ebadbadeg ey say sota dingkak, ta si‐kak, on‐oli‐ak son Amak. ");
INSERT INTO ibl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","No ngarantoy sheẃaten jo son Amak pangkep ni joka pengi‐edagey son si‐kak, i‐akan ko son si‐kayo, say si Amak i mayshedjaw. ");
INSERT INTO ibl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","No ẃaray ibaga jo pangkep ni joka pengi‐edagey son si‐kak, i‐akan ko. ");
INSERT INTO ibl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Jet no ensemek jowak, say pati‐en jo, sota bilin ko. ");
INSERT INTO ibl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ikowan ko son Amak ey pan‐iyan to ali sota Ispirito Santo to son si‐kayo, jet si‐katoy ontolong son si‐kayo ingkatod ingka, ja si‐katoy mengiredan son si‐kayo shi podno. Saja tood ja dobong ja eg emati son si‐kak, eg mebedin na man‐iyan son si‐kara i Ispirito Santo nen Apo Shiyos, ta eg sha am‐amta, tan eg sha indasin. Nem si‐kayo, amtayo mango, ta ẃara son si‐kayo ja man‐iyan ni olay. ");
INSERT INTO ibl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Idekjas takejo niman, nem eg takejo baybay‐an, ta on‐oli‐ak mowan ali son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Niman, entikey ya timpoy i‐asas sha‐ak so ira niya tood ja dobong ja eg emati, nem si‐kayo, asen jowak mowan tep manbiyagak mowan ali. Jet angken si‐kayo, manbiyag kayo ngo ali. ");
INSERT INTO ibl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","No onsabi ali sota timpo ja panbiyag ko mowan, si‐katoy amta‐anan jo so ey agpayson si Amak ket ẃara son si‐kak, jet angken si‐kayo ngo, ẃara kayo son si‐kak, tan si‐kak, ẃara‐ak son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sota etod‐an ni bilin ko, ja mengonod so, si‐kak i ensemek to, jet sota ẃaray semek to son si‐kak, ensemek ngo nen Amak, jet angken si‐kak, ensemek ko ngo. Jet ẃara pay i pa‐amtak so nontan na too say amta‐en towak ka pasiya.” Kowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Si Judas (aliẃen si Judas Iskariote iyay, apil ngo), kowan to ey, “Apo, apay nga si‐kami bengat i ipa‐amta‐an mo so ni maypangkep son si‐kam, ey aliẃen sota toon emin shiya dobong?” ");
INSERT INTO ibl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jet si Jesus, simongbat ja kowan to ey, “Sota toon ẃaray semek to son si‐kak, pati‐en to sota ikowan ko son si‐kato, jet si Amak, ensemek to ngo sotan na too. Jet si‐kak tan si Amak, man‐iyan kami son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sota toon enshiy semek to son si‐kak, eg to pati‐en i naka ikowan. Sota inkowan ko la son si‐kayo, aliẃen edapod nemnem ko, nem eg mismon inkowan nen Amak ja engibetkag alid jay son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Inkowan ko la iyay son si‐kayo, ta ẃara‐ak pay laeng nin son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sota Ispirito Santo, si‐katoy ibetkag ali nen Amak son si‐kayo ja ontolong son si‐kayo, tep naykasakey kayo son si‐kak, say eg jo dibkan sota emin na inkokowan ko la son si‐kayo. Jet sotan i mengitosho son si‐kayo ni emin. ");
INSERT INTO ibl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Idekjas takejo ma, nem sota talna ja enshiy maka‐inges so, ja medepo son si‐kak, si‐katoy isepak son si‐kayo. Sajay ya talna ja i‐akan ko son si‐kayo, aliẃen inges to sota talna ja kai‐akan niya dobong. Karekayo manshanag, ono karekayo ontakot. ");
INSERT INTO ibl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Intenengan jo met sota inkowan ko la ey angken idekjas takejo, on‐oli‐ak mowan ali son si‐kayo. No ẃara komay semek jo son si‐kak, istay nan‐imdeng kayo koma, ta si Amak ja daẃan ko, engatngato ngo eshan ey say si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Insigod kon inkowan son si‐kayo iyay, ta no onsabi ma sota timpo ja medeka son si‐kak iya inkowan ko la, piyan kon memati kayo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Enshi may enshokey ya timpok ja mekitbal son si‐kayo, ta sota engitoshay niyay ya dobong, ja si Satanas, iyay aliy intorong to; nem aliẃen si‐katoy engitoshay son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dag‐en ko ngo eshan sota inbilin nen Amak ja obda‐en ko, say amta‐en ni tood ja dobong ey ensemek ko si Amak.” Idi enaksheng nga inkowan nen Jesus iyay, kowan to son si‐kara ey, “Eti ondaw kito; idekjas tayo iyay ya dogad.” ");
INSERT INTO ibl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Si‐kak i koskoston may‐eshig ey sengeg ni mola, jet si Amak i emengajowan nontan na mola. ");
INSERT INTO ibl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jet no sotan na mola ket ẃaray pangeto ja eg ondames, a‐kalen to sotan na panga. Nem sota panga ja mandemes, shedosan to, say mas ondames pay. ");
INSERT INTO ibl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Si‐kayo, may‐eshig ey eshalosan kayo ma, ta inkowan ko la sota esel nen Apo Shiyos son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Si‐kak i pati‐en jo ni olay, say ẃara‐ak ngo ni olay son si‐kayo. Sota panga, no abos to, eg mebedin na ondames; mesepol la ẃara ni olay nodta makapanga so. Sajay i kay‐eshigan jo; isonga mesepol la si‐kak ni olay i nemnemnemen jo. ");
INSERT INTO ibl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Si‐kak sota may‐eshig ey sengeg ni mola, jet si‐kayo sota may‐eshig ey panga, jet sota on‐onong ja memati son si‐kak, ẃara‐ak ngo ni olay son si‐kato jet si‐kato sota asdeg toy panbenagan ton mapteng. Nem sota toon enshi‐ak son si‐kato, enshiy to panbenagan. ");
INSERT INTO ibl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Isonga sota eg on‐onong ja memati son si‐kak, may‐ibong ja singa inges to sota panga ja epotol nodta makapanga so. Jet sotan na panga, mekkit; jet olnongen shen maypool shi apoy. ");
INSERT INTO ibl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","No si‐kak ni olay i pati‐en jo, ja onoren jo ni olay sota inkowan ko, i‐akan koy ibaga jo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta say kayshedjawan nen Amak, sota panbenagan ni pamatiyo. Jet sajay pay i amta‐an sha so ey too takejo. ");
INSERT INTO ibl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sota semek ko son si‐kayo, inges toy kaba‐deg ni semek nen Amak son si‐kak. Isonga itodoy jon memati son si‐kak, say ẃara ni olay son si‐kayo sota semek ko. ");
INSERT INTO ibl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","No say nemnemnemen jo ket sota inkowan ko la son si‐kayo ja bilin, ẃara ni olay son si‐kayo sota semek ko. Ta si‐kak ngo, naka pati‐a i bilin nen Amak, jet ẃara ni olay son si‐kak sota semek to. ");
INSERT INTO ibl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Sajay i kowan ko son si‐kayo, say mayda‐kam kayo nodta imdeng ja ẃara ngo son si‐kak, jet mas pay ya man‐imdeng kayon pasiya. ");
INSERT INTO ibl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Iyay pay i piyan kon ikowan son si‐kayo ja bilin. Mesepol la ensemek joy sakey tan sakey son si‐kayo ja inges toy itsora ni semek ko son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Say ka‐asan ni ebadeg ga semek ni sakey ya too, sota pengitodok to ni bakdang to ja angken metey para so nonta kagajem to. Sajay i oltimon ka‐asan ni kaba‐deg ni semek. ");
INSERT INTO ibl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jet niman ma, si‐kayoy kagajem ko, no sota ikowan ko ket si‐katoy pati‐en jo. ");
INSERT INTO ibl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aliẃen baga‐en may pengibidang ko son si‐kayo, ta say baga‐en, eg ikowan nonta apo to son si‐kato i emin na toka dagdaga. Isonga say awag ko son si‐kayo, kagajem takejo, ta emin sota inkowan nen Amak son si‐kak, inpa‐amtak son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aliẃen si‐kayoy emili son si‐kak ja maistoro jo, nem si‐kak i emili son si‐kayo. Jet ibetkag takejo so ni totoo ja en mengikowan ni maypangkep son si‐kak, jet sota dag‐en jo, ebadeg i panbenagan to, ja eg mepokaw. Jet no ngantoy sheẃaten jo son Amak, pangkep ni joka pengi‐edagey son si‐kak, i‐akan to son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Say bilin ko son si‐kayo, mesepol la ẃaray semek jo so ni sakey tan sakey son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“No saja tood ja dobong nga eg emati ket okesen shakejo kabol ni pamatiyo son si‐kak, karekayo messhaaw, ta amtayo met ey si‐kak i epangdon inokes sha. ");
INSERT INTO ibl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No si‐kayo ket inges jo ira ja tood ja dobong ja eg emati, istay ensemek shakejo koma. Nem si‐kayo, aliẃen inges jo ira, ta pinidi takejo ja maydesin son si‐kara; isonga en‐oges shakejo. ");
INSERT INTO ibl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Karejo dibdibkan sota inkowan ko la son si‐kayo, ey say baga‐en, aliẃen si‐kato et ngo mowan i ibaingan ni totoo ey say sota apo to. Jet si‐kak ja apo jo, pedikaten sha‐ak; isonga angken si‐kayo, sigoradon pedigaten shakejo ngo ali pangkep ni pamatiyo son si‐kak. Nem no pinatiray esel ko, pati‐en sha ngoy ikowan jo. ");
INSERT INTO ibl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eshakel aliy digat ja dag‐en sha son si‐kayo pangkep ni pamatiyo son si‐kak, ta sota engibetkag son si‐kak, eg sha pati‐en. ");
INSERT INTO ibl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No ekak ali dimaw ja engitosho son si‐kara, istay mebedin na ikowan sha ey enshiy basol sha, nem niman, enshiy pangbal sha ja mengikowan ey enshiy basol sha. ");
INSERT INTO ibl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jet sota toon makakontra son si‐kak, kontra sha ngo si Amak. ");
INSERT INTO ibl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No eg sha inon‐an i dingkak ja kaskasshaaw, ja eg mebedin na dag‐en ni angken sipa, istay mebedin na ikowan sha ey enshiy basol sha. Nem angken na inon‐an sha iyay ya dingkak, iso met laeng nga kontra sha‐ak, tan kontra sha pay si Amak. ");
INSERT INTO ibl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nem sajay i ketongpalan nonta naysolat shi dinteg sha, ja kowan to ey, ‘Kinontra sha‐ak ey enshiy kabol.’ ");
INSERT INTO ibl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Sota Ispirito Santo ja mandepo so nen Amak, si‐katoy ontolong son si‐kayo say eẃatan joy podno. Ibetkag ko di ja man‐iyan son si‐kayo, jet si‐kato met laeng i mengipaneknek ni maypangkep son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jet si‐kayo pay i mengikowan ni maypangkep son si‐kak, ta si‐kayo, naysigod ja naykadẃa kayo son si‐kak, nonta ikayshogik so pay laeng nonta obdak shiya dobong.” ");
INSERT INTO ibl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Wara pay i inkowan nen Jesus son si‐kara ja kowan to ey, “Insigod kon inkowan iyay son si‐kayo, say eg medingding i pamatiyo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta a‐kalen shakejo pay shima dogad ja sa‐nopan ni Hodiyos, ja eg shakejo ma ipalobos ja mekisa‐sa‐nop son si‐kara. Aliẃen sotan bengat: sota pay ira memono son si‐kayo, say ẃared nemnem sha, kowan sha ey sotan na dag‐en sha, aliẃen basol, no diket shaka pandag‐a ja para son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jet sajay i dag‐en sha son si‐kayo, ta eg sha‐ak amta, tan eg sha pay amta si Amak. ");
INSERT INTO ibl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Insigod ko iyay ya inkowan son si‐kayo say no onsabi sotan na digat ja dag‐en sha son si‐kayo, eg kayo messhaaw, no diket nemnemen jo iyay ya inkowan ko son si‐kayo. “Ekak inkowan iyay son si‐kayo nonta pilmiro ta ẃara‐ak nin son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Niman, ikowan ko ma son si‐kayo ta on‐oli‐ak ma so nen Amak ja engibetkag alid jay son si‐kak. Nem angken sakey son si‐kayo, enshiy en engibegka son si‐kak no ngantoy panbenagan ni idaw kod ma daẃan ko. ");
INSERT INTO ibl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jet niman ta inkowan ko iyay son si‐kayo, kayoka mandeshingit ta pasiya. ");
INSERT INTO ibl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ikowan ko son si‐kayoy podno: sota pengilekjas ko son si‐kayo ni i‐olik so nen Amak, panmaptengan jo. Ta no ekak ondaw, sota Ispirito Santo nen Amak, ja ontolong son si‐kayo, eg ngo ali ondaw ja man‐iyan son si‐kayo. Nem no on‐oli‐ak so nen Amak, sota Ispirito Santo to, ibetkag ko ali ja man‐iyan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","No sota Ispirito Santo nen Amak aliy maysa‐dat son si‐kak, ipa‐amta toy pati‐an so ni totood dobong ja eg emati ey ẃaray basol sha, tan ipa‐amta to pay son si‐kara no sipay kinosto‐an nen Apo Shiyos. Tan ipa‐amta to pay i pesing nen Apo Shiyos ja menosa. ");
INSERT INTO ibl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Say pengamta‐an sha ey ẃaray basol sha, eg sha‐ak pinati. ");
INSERT INTO ibl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Say pengamta‐an sha ey si‐kak i kinosto‐an nen Apo Shiyos, on‐oli‐ak son Amak. Jet eg jowak ma on‐on‐an. ");
INSERT INTO ibl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Say pengamta‐an sha ni pesing nen Apo Shiyos ja menosa, si Satanas ja engitoshay niyay ya dobong, kenshat ta meshosa. ");
INSERT INTO ibl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Eshakel pay iya piyan kon ikowan son si‐kayo, nem niman, eg jo pay nin kabaalan na eẃatan. ");
INSERT INTO ibl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nem no man‐iyan ali son si‐kayo sota inkowan ko la ey Ispirito, si‐katoy mengitosho son si‐kayo nonta maypangkep ni podno. Jet sotan na itoro to, aliẃen sota mandepod nemnem to, no diket sota itenengan to ja ikowan nen Apo Shiyos. Tan ipa‐amta to pay sota medeka ali son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ishayaw towak, ta si‐katoy mengiranon ni piyan kon ikowan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sota ẃara son Amak, ẃara ngo son si‐kak; isonga sajay i inkowan ko ta sota Ispirito Santo nen Amak ja maysa‐dat ali son si‐kak, si‐katoy mengiranon ni piyan kon ikowan son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Nem ekay, eg jowak ma nin asen ni sanka‐atikan, nem asen jowak met laeng nga shagos.” Sajay i inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jet sota ira apostol nen Jesus, nanbibinaga ira ey, “Ngaranto emoy olog nonta kowan to ey, ‘Nem ekay, eg jowak ma nin asen ni sanka‐atikan, nem asen jowak met laeng nga shagos’? Asan ngaranto pay emoy olog nonta kowan to ey, ‘Ondawak so nen Amak’?” ");
INSERT INTO ibl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Agdalon nanbibinaga ira no ngarantoy olog nonta kowan to ey “nem ekay”, ta eg sha amta. ");
INSERT INTO ibl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nem si Jesus, amta to ey piyan nonta ira apostol ton ibaga i olog nonta inkowan to, isonga kowan to son si‐kara ey, “Jet kayoka manbibinaga no ngantoy olog da nonta inkowan ko ey eg jowak ma nin asen ni sanka‐atikan, nem asen jowak met laeng nga shagos?” ");
INSERT INTO ibl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kinapodpodno iya ikowan ko son si‐kayo. Saja ira tood ja dobong nga eg emati son si‐kak, man‐imdeng ira; nem si‐kayo, mandeshingit kayon pasiya. Nem sota daringit jo, mesa‐datan met laeng ali ni imdeng. ");
INSERT INTO ibl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Say i‐arigan ko son si‐kayo, sajay. Sota bii, no shanshanin on‐anak, mandeshingit nin, ta simabi ma sota timpo ja pandikat to. Nem no naksheng ma ja imanak, man‐imdeng ma ta ẃaray in‐anak ton too shiya dobong, jet dibkan to sotan na daringit. ");
INSERT INTO ibl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sajay i kay‐eshigan jo. Niman, kayoka mandeshingit, ta idekjas takejo, nem asen takejo met laeng nga shagos, jet man‐imdeng kayo mowan na pasiya ma. Jet sotan na imdeng jo, enshiy en ondingding so, angken sipa. ");
INSERT INTO ibl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","No onsabi sotan alin akew, aliẃen si‐kak may pansheẃatan jo, no diket si Amak. Jet no ẃaray sheẃaten jo son si‐kato, pangkep ni joka pengi‐edagey son si‐kak, i‐akan to son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Enshi pay nin i jo shineẃat son si‐kato ni pangkep ni sajay. Panshawat kayo niman son si‐kato, jet i‐akan to son si‐kayo i sheẃaten jo, say mepno kayo ni imdeng. ");
INSERT INTO ibl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nontan da, say naka pengitosho son si‐kayo, arig ni olay; nem ẃaray timpon onsabi ja aliẃa men arig i pengitoshok, no diket idiritsok ma ja ikowan son si‐kayo i maypangkep son Amak. ");
INSERT INTO ibl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","No onsabi sotan na timpo, si Apo Shiyos ja Amak i mismon pansheẃatan jo ta si‐kayoy mengi‐edagey son si‐kak. Aliẃen si‐kak may mengshaw para son si‐kayo, ");
INSERT INTO ibl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ta si Amak, mismon ensemek tokejo, ta ensemek jowak ngo, tan joka pati‐a ey si‐kak ket edapo‐ak son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Si Amak ka ẃared dangit i edapo‐an ko di, jet niman si‐kato met laeng i odi‐an ko.” Sajay i inkowan nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jet sota ira apostol to, kowan sha ey, “Siya, edawag may moka ikowan jet mika eẃati ma! Aliẃen inges to nonta pilmiro ja poro arig i moka pantosho. ");
INSERT INTO ibl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jet niman, amta mi ma ey si‐kam, amtam ma emin, angken saja ẃared nemnem mi. Angken eg kami mansedodsod, ta amtam; isonga kamika memati ey si Apo Shiyos i edapo‐an mo.” ");
INSERT INTO ibl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jet si Jesus, simongbat ja kowan to ey, “Jet niman, kayoka mala ememati son si‐kak? ");
INSERT INTO ibl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nem simabi ma sota timpon kebodak jo, jet emin kayo, sakey ey on‐akad shi baley to. Si‐kayo, bay‐an jowak, nem aliẃen saksakey kon mebay‐an, ta si Amak, ẃara son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Insigod kon inkowan iyay son si‐kayo, say meẃad‐an kayo nonta talna ja edapo son si‐kak. Shiya dobong, pedigaten shakejo, nem karekayo manshanag, ta si‐kak ngoreshan i emengebak ni olay, aliẃen sota toon eg memati son si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Idi naksheng nga inkowan nen Jesus iyay, timangkak shi dangit ja kowan to ey, “Ama, simabi ma sota timpo ja si‐kam met laeng i mengi‐kan ni kayshedjawan ko, say si‐kak ngoy mengi‐kan ni kayshedjawan mo. ");
INSERT INTO ibl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta si‐kam Ama i engi‐kan son si‐kak ni panakabalin na mengitoshay so ni emin na too, jet si‐kak i mengi‐kan ni biyag ja enshiy to engintegan so nonta totoon piyan mon meẃad‐an ni biyag. ");
INSERT INTO ibl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jet no meẃad‐an ma ira ni biyag ja enshiy to engintegan, si‐kato may amta‐an sha son si‐kam, ey si‐kam i podnon Shiyos ja enshiy eshom, tan si‐kato ngoy amta‐an sha son si‐kak, ey si‐kak si Jesucristo ja inbetkag mo alid ja dobong. ");
INSERT INTO ibl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Sota obda ja inkowan mo son si‐kak ey dag‐en ko shiya dobong, kinsheng ko jet si‐katoy nayshayawan mo. ");
INSERT INTO ibl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jet niman Ama, si‐kam i mengi‐odi nonta sigod ja shayaw ko ngo eshan nonta ẃara‐ak shi kad‐an mo, nonta eg pay laeng epalsowa iya dobong. ");
INSERT INTO ibl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Sota toom ja ẃared ja dobong ja in‐awat mo son si‐kak, inpa‐amtak son si‐kara sota maypangkep son si‐kam, jet pinatiray esel mo. ");
INSERT INTO ibl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jet niman amtara ma ey emin na ẃara son si‐kak ket si‐kam i edapo‐an to, ja in‐akan mo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta inkowan ko son si‐kara sota inkowan mo son si‐kak jet ineẃat sha, jet amtara ma ey podno ja si‐kam i edapo‐an ko, tan si‐kam i engibetkag ali son si‐kak shiya dobong. ");
INSERT INTO ibl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ama, aliẃen sota eg emati i naka pan‐ishawati, no diket saja toon kokowam ja in‐awat mo son si‐kak ja emati son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Emin sota took, si‐kam ngoy makakokowa, jet angken sota ira toom, si‐kak ngoy makakokowa, jet si‐karay kayshedjawan ko. ");
INSERT INTO ibl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Niman, idekjas ko iya dobong, jet on‐oli‐ak da son si‐kam. Nem saja ira took ja in‐awat mo son si‐kak, mebay‐an nin ira shiya dobong, jet si‐kam Ama, i maka‐amta ja mengajowan son si‐kara. Si‐kam i napno‐an ni emin na kinamapteng; isonga i‐osal moy panakabalin mo, say manseksekey ira ja inges toy inpansaksakey ta. ");
INSERT INTO ibl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nonta ẃara‐ak son si‐kara, inajowanan ko ira iya in‐awat mo son si‐kak, jet inosal koy panakabalin mo. Ekak ira in‐oway, jet enshiy en epokaw son si‐kara, malaksig bengat sota sakey ya si Judas. Sajay ya too, kenshat ta epokaw, ta mesepol la metongpal sota naysolat ja esel mo nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Jet niman, shanshani mala sota i‐olik son si‐kam, nem ikowan ko iyay son si‐kara ta ẃara‐ak nin shiya dobong, say mepno ngo ira nonta imdeng ja ẃara son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sota inkowan mo son si‐kak, inkowan ko ngo son si‐kara, jet sajay iren too, emati ira son si‐kak. Jet sota tood ja dobong ja eg emati, kontra sha ira ja took, ta eg nay‐inges i ogadira so nodta ira eg emati. ");
INSERT INTO ibl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Say shawat ko para son si‐kara, aliẃen naka pan‐ishawat ey a‐kalen mo ired ja dobong, no diket ajowanim ira koma, say eg sheshalen ira nen Satanas. ");
INSERT INTO ibl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Si‐kak, aliẃen inges ko iya tood ja dobong ja eg emati, jet saja took, inges sha‐ak ja aliẃen tood ja dobong. ");
INSERT INTO ibl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sota esel mo, si‐katoy podno, jet si‐katoy osalen mon mengilesin son si‐kara para son si‐kam bengat. ");
INSERT INTO ibl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Si‐kam i engibetkag son si‐kak shiya dobong, jet inges to ngon ibetkag ko ira shiya emin na sakop niya dobong. ");
INSERT INTO ibl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jet saja bakdang ko, itolok kon metey pangkep son si‐kara, say agpayson maydesin ira para son si‐kam. ");
INSERT INTO ibl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aliẃen saja ira took bengat i naka pan‐ishawati son si‐kam, no diket angken pay sota ira toon memati ali son si‐kak, ja pengikowanan ira niya took ni esel mo. ");
INSERT INTO ibl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tan say shawat ko pay son si‐kam Ama, manseksekey koma iren emin, ja inges toy kawashak son si‐kam, tan kawasham ngo son si‐kak, say maykasakey ira son si‐kata, say pati‐en ira nonta tood ja dobong ey agpayson si‐kam i engibetkag ali son si‐kak shiyay. ");
INSERT INTO ibl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Sota shayaw ja in‐akan mo son si‐kak, inges to met laeng i in‐akan ko son si‐kara, say manseksekey ira ja inges toy inpansaksakey ta. ");
INSERT INTO ibl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wara‐ak ja ontolong son si‐kara, tan ẃara ka ja ontolong son si‐kak, say enshiy pankodangan ni panseksekey sha, tan say pati‐en ira niya tood ja dobong ey si‐kam i engibetkag son si‐kak ali et pati‐en sha pay ey ensemek mo ira ja inges toy semek mo son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama, si‐kam i engi‐ẃat ira niyay ya too son si‐kak, jet say piyan ko, ondaw ngo ira shi dangit ja daẃan ko, say asen sha sota shayaw ja in‐akan mo son si‐kak, nonta pilmiro ja eg pay laeng epalsowa iya dobong. Sajay i inpasing mo nontan da ta ensemek mowak ngoreshan. ");
INSERT INTO ibl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Si‐kam ja Amak, amtak ey enshiy moka pankodangi. Saja tood ja dobong, eg shaka amta; nem si‐kak, amta taka. Jet sajay iren took, amtara ey si‐kam i engibetkag ali son si‐kak. ");
INSERT INTO ibl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inpa‐amtak son si‐kara sota maypangkep son si‐kam, jet itoloy kon ipa‐amta iyay son si‐kara, say mayda‐kam ngo ira nodta semek mo ja ẃara son si‐kak, say si‐kak, ẃara‐ak ngo son si‐kara, ja ontolong.” Sajay i shawat nen Jesus so nen Ameto. ");
INSERT INTO ibl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Idi naksheng sota inpanshawat nen Jesus so nen Apo Shiyos, indekjas toy Jerusalem, jet eki‐odop sota ira too to son si‐kato, jet bimaliw ira nodta epel‐ogan ja kowan sha ey Kidron. Nodtan na dogad, ẃaray gardin ja emola‐an jet si‐katoy dinaẃan sha. ");
INSERT INTO ibl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas Iskariote, ja engibaag son Jesus so nonta ira makakontra son si‐kato, amta to iyay ya dogad, ta eminshakel la ekidaw nontan son Jesus, tep shiman i sigod ja kesa‐sa‐nopi nen Jesus tan sota ira too to. ");
INSERT INTO ibl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jet si Judas Iskariote, en engolop ni eshakel la solsharo tan kowadja ni Timplo, ja inbetkag ira nonta apo ni papashi tan sota ira Parisiyo, jet dimaw ira shima gardin ja kawad‐an nen Jesus. Sajay iren totoo, nansilew ira di, tan nanpan‐almas ira. ");
INSERT INTO ibl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Si Jesus, amta ton sigod i mepesamak son si‐kato; isonga to inaspol ira jay ya totoo, jet kowan to son si‐kara ey, “Sipay joka pan‐enapa?” ");
INSERT INTO ibl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Simongbat ira ja kowan sha ey, “Si Jesus ja i‐Nasarit.” Jet si Jesus, kowan to ey, “Si‐kak sotan na too.” (Wara nontan na mismo si Judas ja engibaag son Jesus, ja eki‐odop son si‐kara.) ");
INSERT INTO ibl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Idi naksheng nga inkowan nen Jesus ey si‐kato sota shaka pan‐enapa, sajay iren too, simoled ira jet eto‐dang ired bo‐day. ");
INSERT INTO ibl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jet si Jesus, inpinshowa to ja kowan to ey, “Sipay joka pan‐enapa?” Jet kowan sha mowan ey, “Si Jesus ja i‐Nasarit.” ");
INSERT INTO ibl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jet si Jesus, kowan to mowan ey, “Inkowan ko met son si‐kayo ey si‐kak sotan, jet no si‐kak i joka pan‐enapa, baybay‐iyo mango ira ja took. Jet angken ondaw ira.” ");
INSERT INTO ibl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Sajay ya inkowan nen Jesus, si‐katoy ketongpalan met laeng nonta inkowan to nonta epangdo len akew, ja kowan to ey, “Sota toon in‐awat mo son si‐kak, angken sakey son si‐kara, enshiy en epokaw.”) ");
INSERT INTO ibl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jet si Simon Pedro, inokbos to sota kampilan to nodta atip to, jet kinimpas to sota kanawan na tangida nen Malko, ja baga‐en nonta kangeto‐an na pari. ");
INSERT INTO ibl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jet si Jesus, kowan to so nen Pedro ey, “I‐odim ita kampilan mo shita atip to. Kowan mo emo ey ekak enosan i digat ja piyan nen Amak ja da‐kaman ko?” ");
INSERT INTO ibl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jet inshel ma ira nonta solsharo, pati sota apo sha, tan sota kowadja ni Timplo si Jesus, jet binedod sha. ");
INSERT INTO ibl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","In‐ilaw sha nin shi baley nen Anas, ta si‐kato sota inepo nen Kaipas ja kangeto‐an na pari nontan na tawen. ");
INSERT INTO ibl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Si Kaipas sota engikowan so nonta ira toray ni Hodiyos ey mapmapteng no metey sota sakey ya too, say eg meshosa i totood Israel.) ");
INSERT INTO ibl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jet si Pedro, tan sota sakey ya too nen Jesus, imonod ira so nonta ira nangshel so nen Jesus, jet sota sakey, am‐amta nonta kangeto‐an na pari, jet si‐katoy ekiskep. ");
INSERT INTO ibl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nem si Pedro, ebay‐an nin nodta pasbol nonta baley ni kangeto‐an na pari, isonga sota sakey ya too nen Jesus, ekitbal so nonta biin emanbantay nonta pasbol no mebedin na onsekep ngo ali si Pedro. Jet inpaskep to. ");
INSERT INTO ibl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nem sota biin emanbantay nodta pasbol, inbag‐an tos Pedro ja kowan to ey, “Angken si‐kam emo met, aliẃa ayen too toka nonta inshel sha?” Simongbat si Pedro ja kowan to ey, “Enshi, aliẃen too towak.” ");
INSERT INTO ibl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nodtan na bo‐dayan, nan‐apoy ira sota baga‐en, tan sota ira kowadja, ta teg‐in nontan, jet ediktob ira ja emenangshang. Jet si Pedro, en nay‐eshom son si‐kara ja mekirangshang. ");
INSERT INTO ibl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nem si Jesus, marama ja panbistigala nonta kangeto‐an na pari, pangkep nonta too to, tan sota pangkep ni toka pan‐itoro. ");
INSERT INTO ibl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jet si Jesus, simongbat ja kowan to ey, “No maypangkep ni naka pantosho, naypalantaro — shima baley ya sa‐nopan, ono shima Timplo i naka pantosho‐i ni olay, tep shiman i kesa‐sa‐nopi ni kait tayon Hodiyos. Enshiy nak nantoro‐an shima nay‐emot, nem eg shima karakdan ni too ni olay i naka pantosho‐i. ");
INSERT INTO ibl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aliẃen si‐kak i ibag‐an mo. Sama ira totoo, ta intenengan sha sota intorok, isonga amtaren emin i inkowan ko.” ");
INSERT INTO ibl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Idi naksheng nga inkowan nen Jesus iyay, sota sakey so nonta ira kowadja, sinedpak to si Jesus ja kowan to ey, “Apay nga satan i moka pesing nga menongbat so nita kangeto‐an na pari?” ");
INSERT INTO ibl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Simongbat si Jesus, ja kowan to ey, “No ẃaray ngaaw ja inkowan ko, pa‐amtam so ira niya totoo ja ẃara niman shiyay, no ngaran nontan na ngaaw wa inkowan ko. Nem no say inkowan ko ket podno, apay nga sedpaken mowak?” ");
INSERT INTO ibl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Idi naksheng nga binistigal sha si Jesus, inpaitolod nen Anas si Jesus so nen Kaipas ja kangeto‐an na pari nontan na tawen. Jet inpa‐onong to sota balod shi takday nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Pedro, ẃara pay laeng nga emenangshang nodta kad‐an ni apoy jet sota ira totoon kait ton emenangshang, inbag‐an sha si Pedro ja kowan sha ey, “Aliẃa ayen sakey ka nodta too nima inshel sha?” Si Pedro, nandibak, ja kowan to ey, “Apil, aliẃen si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nem sota partido nonta baga‐en ja kinimpas nen Pedro i tangida to, ja baga‐en met laeng, kowan to ey, “Inon‐an taka met nontan shima gardin ja kadẃa nen Jesus.” ");
INSERT INTO ibl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nem indibak nen Pedro ngoreshan, ja kowan to ey, “Apil, aliẃen si‐kak sotan!” Nontan na inkowanan so nen Pedro niyay, kimagang nga shagos sota kawitan. ");
INSERT INTO ibl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nonta palbangon ma, indara si Jesus shima baley nen Kaipas, jet indaw sha so nen Gobinarol Pilato shima baley to. Nem sota ira Hodiyos, eg ira simekep shima naydaem ni baley, ta say ninemnem sha, kowan sha ey say eg ira seskigen ni kait shen Hodiyos, ta no onsekep i Hodiyos shi baley ni aliẃen Hodiyos, maypeshit may pekipengan sha nonta naysagana ja mekan no timpo ni piyasta ni Paskowa. ");
INSERT INTO ibl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Isonga si Pilato ja gobinarol, bimo‐day ali jet kowan to so ira nonta Hodiyos ey, “Ngantoy kowan jo ey basol niyay ya too?” ");
INSERT INTO ibl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jet sota ira Hodiyos, simongbat ira ja kowan sha ey, “No enshi komay ebadeg ga basol to, istay eg mi di koma indaw son si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jet si Pilato, kowan to son si‐kara ey, “No sajay ya too ket nanbasol, alejo et tongtong jo ngo shi dinteg jo.” Nem sota ira Hodiyos, simongbat ira ja kowan sha ey, “Eg met maypedobos shi dinteg jon i‐Roma ey onbono kami; isonga eg mebedin.” ");
INSERT INTO ibl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Sajay i ketongpalan nonta inkowan met laeng nen Jesus pangkep son si‐kato shorog ey say itsora ni ketey to ket maydansed koros.) ");
INSERT INTO ibl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Si Pilato, nay‐oli shima naydaem ni baley to jet inpaskep to ali si Jesus, jet inbag‐an to ja kowan to ey, “Jet agpayso ja si‐kam ket ari ni Hodiyos?” ");
INSERT INTO ibl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Si Jesus, simongbat ja kowan to ey, “Edapod nemnem mo itan na inkowan mo, ono ẃaray engikowan son si‐kam?” ");
INSERT INTO ibl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sinongbatan nen Pilato, ja kowan to ey, “Si‐kak, aliẃen Hodiyosak, jet sota engi‐ẃat ali son si‐kam shiyay, sota ira kait mo, tan sota ira apo ni papashiyon Hodiyos. Apay nganto aya i dingkam ja kowan sha ey basol mo?” ");
INSERT INTO ibl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Si Jesus, simongbat ja kowan to ey, “Say pantoshayan ko, aliẃen shiya dobong, ta no shiya dobong, sota ira took, istay mekibekal koma ira; eg sha itolok ja may‐eẃatak so nonta ira Hodiyos. Nem aliẃen shiyay i pantoshayan ko.” ");
INSERT INTO ibl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jet si Pilato, inbag‐an to pay mowan si Jesus, ja kowan to ey, “Jet ari ka ngarod?” Simongbat si Jesus ja kowan to ey, “Si‐katoy inkowan mo, ey ari‐ak. Si‐kak, dimawak alid ja dobong ja nay‐anak, say nak ali ikowan i maypangkep ni podno. Jet emin ira sota makakosto ni podno, shaka pati‐a i naka ikowan.” ");
INSERT INTO ibl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jet si Pilato, kowan to ey, “Jet ngarantoy piyan mon a‐selen ni engikowanan mo ni podno?” Idi naksheng nga inkowan nen Pilato iyay, bimo‐day mowan ali jet kowan to so nonta ira pangolo ni Hodiyos ey, “Enshi met i naka sokali ja basol niyay ya too ja to kebono‐an. ");
INSERT INTO ibl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nem say ogadiyo, no timpo ni sajay ya piyasta ni Paskowa, ẃaray naka ibolos ni olay ya balod son si‐kayo. Jet ngantoy piyan jo? Saja ari jon Hodiyos i paibodos ko son si‐kayo?” ");
INSERT INTO ibl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sota ira Hodiyos, inkeljaw sha et ey, “Enshi! Aliẃen si‐katoy piyan mi ja ibolos mo! Si Barabas, si‐katoy maybodos!” (Si iya Barabas, tolisan.) ");
INSERT INTO ibl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jet nontan ma, in‐awat nen Pilato si Jesus so nonta ira solsharo et sinepsepdat sha. ");
INSERT INTO ibl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jet sota ira solsharo, engosikos ira ni ẃakal la nasbitan asan shaka paidnget son Jesus, ja singa korona to. Tan binesho‐an sha pay nonta dopot ja violet i kolor to, ja singa baro ni ari. ");
INSERT INTO ibl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jet imesop ira son si‐kato ja kowan sha ni dedamsis sha ey, “Onpalapalad ka koma, ari ni Hodiyos!” Asan shaka sedpaka. ");
INSERT INTO ibl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jet si Pilato, bimo‐day ali mowan jet kowan to so nonta ira Hodiyos ey, “Enshi met i nak dinoktalan na to nanbasolan, ja si‐katoy kabol la to keshosa‐an; ekak itoloy ya bistigalen. Isonga niman, pebo‐day ko di say asen jo, say mepnek kayo ni epalikatan to la.” ");
INSERT INTO ibl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jet si Jesus, inpabo‐day sha ali ja inpa‐onong sha sota shenget ton sebit tan sota baro ton violet, jet si Pilato, kowan to ey, “Asas jo, sajay sota too!” ");
INSERT INTO ibl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Idi inon‐an nonta ira apo ni papashi, tan sota ira kowadja ni Timplo, kimeljaw ira ja kowan sha ey, “Paidansam shi koros! Paidansam shi koros!” Nem si Pilato, simongbat ja kowan to son si‐kara ey, “Si‐kayo ngoy mengilansa son si‐kato shi koros tep enshi met i nak dinoktalan na to nanbasolan!” ");
INSERT INTO ibl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jet sota ira toray ni Hodiyos, simongbat ira ja kowan sha ey, “Waray dinteg min Hodiyos ey sota toon mengikowan ey si‐kato ket Anak kono nen Apo Shiyos, mesepol la mebono, jet satan na too, si‐katoy inkowan to.” ");
INSERT INTO ibl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Idi intenengan nen Pilato iyay ya inkowan ira nonta toray ni Hodiyos, ema‐ma et i takot to. ");
INSERT INTO ibl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Isonga insekep to mowan nodta naydaem da jet inbag‐an to si Jesus ja kowan to ey, “Apay toway edapo‐an mo aya?” Nem si Jesus, eg to sinongbatan. ");
INSERT INTO ibl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Si Pilato, kowan to ey, “Apay nga eg mowak songbatan? Eg mo aya amta ey ẃaray kanebengan ko ja mengibodos son si‐kam no piyan ko, ono mengilansa son si‐kam shi koros?” ");
INSERT INTO ibl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Simongbat si Jesus, ja kowan to ey, “Si‐kam, enshiy nebeng mo son si‐kak, no si Apo Shiyos ket eg to itolok ja may‐eẃatak son si‐kam. Isonga sota toon engilaw son si‐kak alid jay son si‐kam, mas ebadbadeg i basol to, ey say si‐kam.” ");
INSERT INTO ibl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Idi intenengan nen Pilato iyay ya inkowan nen Jesus son si‐kato, piyan ton pasiya ja ibolos, nem sota ira toray ni Hodiyos, ema‐ma et i keljaw sha ja kowan sha ey, “No ibolos mo itan na too, aliẃen kajem toka ma nonta ari jod Roma, ta sota toon kowan to shorog ey si‐kato ket ari, si‐katoy makakontra so nonta ari shi Roma.” ");
INSERT INTO ibl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Si Pilato, inbo‐day to mowan ali si Jesus ta intenengan to sota kowan ira nonta toray ni Hodiyos, jet en timongaw nodta dogad ja shaka pengigshengi ni ẃaray basol to, ja minetalan sha ni bato, ja kowan sha ni esel ni Hodiyos ey Gabata. ");
INSERT INTO ibl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nontan na akew, si‐katoy pansekana ni Hodiyos, ta no meẃa‐ẃa, piyasta ma ni Hodiyos ja Paskowa. Jet idi nonta nankawa may akew, kowan nen Pilato son si‐kara ey, “Iyay sota ari jo. Pan‐ala jo ngo tep ari jo.” ");
INSERT INTO ibl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sota ira Hodiyos, kimeljaw mowan ira ja kowan sha ey, “Bonom! Bonom! Paidansam et shi koros!” Jet si Pilato, kowan to son si‐kara ey, “Jet piyan jon angken paidansak iya ari jod koros?” Sota ira apo ni papashi, simongbat ira ja kowan sha ey, “Enshiy eshom ma ari mi; sota ari bengat shi Roma!” ");
INSERT INTO ibl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jet si Pilato, in‐awat to ma si Jesus son si‐kara ja maydansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jet sota ira Hodiyos, indara ma si Jesus jet inbo‐day sha jet inpasakbat sha son si‐kato sota koros to, jet indaw sha nodta dogad ja kowan sha ey Toktok, ja no shi esel ni Hodiyos, kowan sha ey Golgota. ");
INSERT INTO ibl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jet shiman, indansara nodta koros to. Tan ẃara pay i showa ja in‐inshas sha ja indansa ngo shi sanseskey ya koros: sota sakey, indansara shi apit ni kanigid nen Jesus, jet sota sakey, nodta apit ni kanawan to ngo. ");
INSERT INTO ibl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jet si Pilato, ẃaray inpaisolat to ja kowan to ey, “Sajay si Jesus, ja i‐Nasarit, ja ari ni Hodiyos.” Sajay ya inpaisolat to, sha inpakpak shima koros nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sajay ya inpaisolat nen Pilato, eshakel i Hodiyos ja bimasa so, ta sota dogad ja indansa‐an sha so nen Jesus, nay‐esop shi ili. Say inpangisolat nen Pilato, ekalkalasin esel — esel ni Hodiyos, esel ni i‐Roma, tan sota esel ni Grigo ja si‐katoy shaka pan‐i‐inawatid man na dogad. ");
INSERT INTO ibl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sota ira apo ni papashi ni Hodiyos, kowan sha so nen Pilato ey, “Karam koma paisolat ey ari ni Hodiyos, no diket say paisolat mo, sajay: ‘Inkowan to shorog ey si‐kato konoy ari ni Hodiyos.’ ” ");
INSERT INTO ibl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Simongbat si Pilato, ja kowan to ey, “Sota insolat ko, si‐kato; eg mesepol la mesa‐datan.” ");
INSERT INTO ibl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Idi naksheng ma ja indansa ira nonta solsharo si Jesus shi koros, indara sota baro to, jet biningbingay sha ja inpan‐epat sha son si‐karen solsharo. Tan indara pay sota baro to ja toka ita‐kep ja emongsan ja inebel, ja enshiy to eshaitan. ");
INSERT INTO ibl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jet sota ira solsharo, nantatabalan sha ey eg sha pi‐pi‐katen, no diket manbibinonot ira, no sipay ontompong so. Jet sajay ya inpasing sha, sajay i tongpal nonta naysolat ja kowan to ey, “Sota barok, bingbingayen sha, tan sota dopot ja naka ita‐kep, panbibinonotan sha.” ");
INSERT INTO ibl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jet nontan na maramen sajay i kepandag‐a ira nonta solsharo so nen Jesus, ẃara ngo si Maria ja ina nen Jesus, ja dimayat nodtan ja nay‐esop shi koros nen Jesus; ẃara pay sota agi met laeng nen Maria, sota si Maria ja aseẃa nen Kliopas, tan ẃara pay sota sakey ya si Maria Magdalena. ");
INSERT INTO ibl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jet si Jesus, idi inon‐an to ja dimayat nodta nay‐esop son si‐kato sota sakey ya apostol ton ensemek ton pasiya, tan inon‐an to ja ẃara si ineto, kowan to ey, “Nanang, si iyay may ibilang mon anak mo!” ");
INSERT INTO ibl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jet inkowan to ngo so nonta apostol ey, “Si‐kato may inam!” Jet nontan ma ja akew, inodop nonta apostol sota ina nen Jesus shi baley to ja meki‐iyan ma shiman. ");
INSERT INTO ibl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jet nontan ma, amta nen Jesus ey nontan ma i kepospos nonta obda to, jet inkowan to ey, “Na‐keẃak ni shanom.” Ta piyan ton metongpal sota inkowan ni padto ja naysolat nonta bayag da ja pangkep son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Waray salaw wa nay‐esop nodtan na enapno ni empait ta tapey, jet sota sakey ya solsharo, to in‐aneng sota singa bonot ja masbet ni shanom, jet inpi‐ket to nodta ngoro ni pating nga kowan sha ey hisopo, asan toka iga‐ẃat shi bongot nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jet idi ninamtan nen Jesus sota tapey ya inka‐ẃat nonta solsharo shi bongot to, kowan nen Jesus ey, “Naksheng ma.” Jet nanjokmos, asan ma ma‐bosi. ");
INSERT INTO ibl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sota ira Hodiyos, dimaw ira so nen Pilato jet sha inbag‐an ey, “No mebedin, pagetdom i sedi nonta ira naydansed koros, say metey iren shagos. Tan mesepol pay ya pa‐kal mo ira, ta shanshani ma sota kapatkan na akew son si‐kamin Hodiyos, jet na‐alas no on‐onong ira shima koros.” ");
INSERT INTO ibl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jet sota ira solsharo nen Pilato, sha kinetdo i sedi nonta ira showen too ja naydansa shi apit ni kanawan tan kanigid nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nem idi onsabi ira sota solsharo so nen Jesus, inon‐an sha ja etey ma si Jesus; isonga binay‐an sha ja eg sha kinetdoy sedi to. ");
INSERT INTO ibl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nem sota sakey ya solsharo, intebek toy kayang to shi tagdang nen Jesus, jet imayos alin shagos i shala, tan shanom. ");
INSERT INTO ibl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Sota mismon engasas niyay ya edaga so nen Jesus, insodsod to la iyay say memati kayon memasa niyay. Sigoradon eg panshowashowa‐an ta amta to ey podno ni olay i toka ikowan.) ");
INSERT INTO ibl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Eg kinetdo ira nonta solsharo i sedi nen Jesus, ta naypadto nonta bayag da ey angken sakey ya pokel to ket enshiy en ma‐an‐ano. ");
INSERT INTO ibl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tan ẃara pay i naysolat ta naypadto nontan da, ja kowan to ey, “Asen sha met laeng sota toon timbek sha.” ");
INSERT INTO ibl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Idi naksheng ma ja dingka ira nonta solsharo son Jesus iyay, si Jose ja i‐Arimatia, dimaw ngo so nen Pilato, jet to inbag‐an no mebedin na a‐den toy bakdang nen Jesus nodta koros. Jet intolok nen Pilato. Jet si Jose, impas to sota bakdang nen Jesus shi koros. Sajay ya too, emati son Jesus, nem eg to ipa‐sas so nonta ira toray ni Hodiyos i inpamati to, ta entakot to ira. ");
INSERT INTO ibl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jet dimaw ngo ali si Nikodimo ja engidaw ali ni eshakel la kilo nonta emanseng‐ew wa nandaok ni kowan sha ey mira tan alo. (Si Nikodimo, si‐kato sota dimaw so nen Jesus ni edabi nonta ikayshogshogi nen Jesus ja mengitosho.) ");
INSERT INTO ibl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inda nen Nikodimo tan si Jose sota bakdang nen Jesus jet dinibotan sha nonta empotin dopot, jet inpakidibot sha sota emanseng‐ew, ta si‐katoy ogadi ni Hodiyos no ẃaray ibekara ja etey. ");
INSERT INTO ibl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nodta dogad ja inkorosan sha so nen Jesus, ẃaray gardin ja nay‐esop, jet nodtan, ẃaray diniyangan sha ja kaybebka‐an ni metey ja eg pay laeng na‐os‐osal. ");
INSERT INTO ibl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nodtan i indawan sha so ni bakdang nen Jesus ta sotan i nay‐esop, tep shanshanin manshoki ma sota akew wa ngilin ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nonta daem ni Domingko, si Maria Magdalena, dimaw shima naydiyangan ni bakdang nen Jesus. Idi mimotok nodtan, inon‐an ton imadaw sota baton naypokit nodta bongot ni diyang ja naydiyangan nen Jesus, isonga edo‐katan sota diyang. ");
INSERT INTO ibl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jet si Maria Magdalena, nanbetik ja to inkowan so nonta sakey ya apostol ja ensemek ka pasiya nen Jesus, tan to inkowan so nen Simon Pedro ey, “Indara da sota bakdang nen Apo Jesus shima naydiyangan to! Eg mi amta no toway indawan sha so.” ");
INSERT INTO ibl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Jet nanbetik da ira ja timorong nodta diyang, nem epangdon mimotok nodta diyang sota sakey ya apostol, ");
INSERT INTO ibl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","jet niningil to sota diyang, jet say inon‐an to, sota dopot ja empoti bengat, nem eg simekep nodta diyang. ");
INSERT INTO ibl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Idi mimotok ngo si Pedro, diritson simekep nodta diyang, jet inon‐an to ngo sota empotin dopot ja naypokay. ");
INSERT INTO ibl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sota dopot ja istay naydibot shi toktok nen Jesus, inon‐an ton ekopikop ja eg nay‐eshom nodta empotin dopot. ");
INSERT INTO ibl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jet sota sakey ya apostol ja epangdon mimotok, tinned tos Pedro ja simekep ngo jet inon‐an ton enshi nga agpayso sota bakdang nen Jesus. Jet emati ma ey si Jesus ket, nanbiyag mowan nga agpayso. ");
INSERT INTO ibl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta nontan, eg nin ineẃatan nonta ira apostol la pasiya sota naysolat ja padto nonta bayag da ey manbiyag ngoreshan si Jesus shi patey. ");
INSERT INTO ibl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jet idi naksheng nga inon‐an sha iyay, imakad ired baley sha. ");
INSERT INTO ibl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nem si Maria Magdalena, ebay‐an nodtan ja kaonnangnangis, jet nonta maramen emannengis, niningil to sota diyang. ");
INSERT INTO ibl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jet ẃaray inon‐an to ja showen anghil ja nanbaro ni empoti ja timongaw nodta istay naysepa‐an ni bakdang nen Jesus: sota sakey ya anghil, timongaw nodta istay petek ni toktok nen Jesus, jet sota sakey ngo, timongaw nodta istay petek ni sedi to. ");
INSERT INTO ibl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jet sajay iren anghil, imesel ira ja kowan sha son Maria Magdalena ey, “Ngantoy moka pannengisi?” Jet si Maria Magdalena, simongbat ja kowan to ey, “Naka mannengis ta indara da sota bakdang nen Apok ja naydiyang shiyay, jet ekak da amta no toway indawan sha so.” ");
INSERT INTO ibl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Idi naksheng nga inkowan nen Maria Magdalena iyay, ẃimingi jet ẃaray inon‐an ton too ja nay‐askang son si‐kato ja dimayat, nem eg to inimatonan ey si Jesus sotan na imaskang son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jet si Jesus, imesel ja kowan to son Maria Magdalena ey, “Ngantoy moka pannengisi? Sipay moka pan‐enapa?” Si Maria Magdalena, say ẃared nemnem to, kowan to ey sota dakin emengajowan nonta mola nodtan sota dakin imaskang son si‐kato. Isonga kowan to ey, “Apo, no si‐kam i engala nonta bakdang nen Jesus, ikowan mo no toway indawan mo la so, say nak al‐en.” ");
INSERT INTO ibl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jet si Jesus, inngadnan toy ngaran nen Maria, jet si Maria, timangkak ta inimatonan toy esel, ey si Jesus sotan, jet kowan to ma ey, “Raboni.” (Say olog ni Raboni shi esel ni Hodiyos, Maistoro.) ");
INSERT INTO ibl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nem si Jesus kowan to ey, “Karamak egni‐an, ta ekak pay laeng dimaw ja nay‐oli so nen Amak shi dangit. Daw ka, mo ikowan so nonta ira a‐akik ey ondawak ma ja on‐oli so nen Amak ja Shiyos ko, ja si‐katoy Shiyos jo tan Amejo ngo.” ");
INSERT INTO ibl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jet si Maria Magdalena, dimaw ja to inkowan so nonta ira too nen Jesus ey inon‐an tos Apo Jesus, jet insodsod to pay sota inkowan nen Jesus son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jet nontan na mama‐shem ni Domingko, sota ira too nen Jesus, na‐olnong ira, jet nanbagat ira tep entakot ira so nonta ira pangolo ni Hodiyos. Jet nontan na inka‐olnong sha, ebigla ja dimaw alis Jesus jet dimayat shi sango‐an sha; jet kowan to son si‐kara ey, “Sapay koma ta sota talna ket si‐katoy meẃesha son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Idi naksheng nga inkowan nen Jesus iyay, inpa‐sas to sota takday to son si‐kara ja kawad‐an ni sogat nonta indansara so shi koros, tan sota tagdang ton natbek. Jet nontan ma, ireka man‐imdeng nga pasiya tep inon‐an shen mismo si Apo Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jet si Jesus, inpinshowa to mowan ja kowan to ey, “Sapay koma ta sota talna ket, si‐katoy meẃesha son si‐kayo.” Tan kowan to pay ey, “Ibetkag takejo, ja inges toy inpangibetkag nen Amak son si‐kak.” ");
INSERT INTO ibl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sajay i inkowan nen Jesus, asan toka ira si‐boka, ja kowan to ey, “Awat joy Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jet manshoki ma niman, no pekawanan joy basol ni too, si Apo Shiyos, pekawanan to ngo sotan na too. Nem no eg jo pekawanan, si‐kato ngoy pesing nen Apo Shiyos son si‐kato.” ");
INSERT INTO ibl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sota sakey so nonta ira apostol nen Jesus, ja si Tomas i ngaran to, naytompong nga enshi nonta indaw nen Jesus nodta na‐olnongan shen too to ni mama‐shem ni Domingko. (Si Tomas, ẃaray ngaran ton sakey, ja kowan sha ey Epin.) ");
INSERT INTO ibl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Isonga sota kait ton apostol, inkowan sha so nen Tomas ey, “Inon‐an mi si Apo Jesus!” Nem si Tomas, kowan to ey, “Ampet ta asen ko nin sota shindan ni dansa shi takday to, asan isho‐dog ko pay i kalomot ko, tan isho‐dog ko pay i takday ko nodta tagdang ton natbek, asan naka mamati.” ");
INSERT INTO ibl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Idi edabas day makadomingko, na‐olnong mowan sota ira too nen Jesus, ja nanbagat, jet ẃara ma nodtan si Tomas. Jet si Jesus, ebigla ja nanpa‐sas mowan son si‐kara. Dimayat shi sango‐an sha, ja kowan to ey, “Sapay koma ta sota talna ket si‐katoy meẃesha son si‐kayo.” ");
INSERT INTO ibl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jet kowan to ma so nen Tomas ey, “Asas mo iya takday kon imbot ni dansa, jet iga‐ẃat mo diy kalomot mo. Tan iga‐ẃim pay ali ita takday mo jet iro‐dog mod ja tagdang kon esogat. Kareka manshowashowa, no diket pamati ka et.” ");
INSERT INTO ibl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Si Tomas, simongbat ja kowan to ey, “Si‐kam i Apok tan Shiyos ko!” ");
INSERT INTO ibl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Simongbat si Jesus, ja kowan to ey, “Kaka ma memati ta inon‐an mowak? Sota toon eg engasas son si‐kak, ey ireka pay laeng ememati, mas pay ya si Apo Shiyos i onbindisiyon son si‐kara.” ");
INSERT INTO ibl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","No sota maypangkep ni dingka nen Jesus, eshakel i dingka ton kaskasshaaw wa mismon inon‐an nonta ira too to, nem ekak insolat ta emin shiyay ya dibsho. ");
INSERT INTO ibl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nem saja insolat kod jay ya dibsho, insolat ko say memati kayo ey si Jesus ket si‐kato sota naypadton mengisedakan ja ibetkag ali nen Apo Shiyos, tan say memati kayo ey si‐kato sota Anak nen Apo Shiyos. Jet say sakey pay ja insolatan ko so niyay, say no memati kayo, meẃad‐an kayo ni biyag ja enshiy to engintegan. ");
INSERT INTO ibl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Idi edabas i pigen akew, nanpa‐sas mowan si Jesus so nonta ira too to shima kilig ni baybay shi Galilia. Jet say inpasing nen Jesus ja nanpa‐sas son si‐kara, iyay i istoriya to. ");
INSERT INTO ibl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Si Simon Pedro, si Tomas ja inbeshay sha ey Epin, si Natanael ja i‐Kana ja sakop ni Galilia, tan sota san‐agin potot nen Sibidi, nan‐o‐odop ira, pati sota showen too met laeng nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ta si Simon Pedro, kowan to son si‐kara ey, “Nak mannikay.” Jet kowan sha son si‐kato ey mekidaw ira ngon mekinikay. Nandogan ira nodta bangka, jet indabbira ja nannigay ingkato nonta palbangon, nem angken sakey, enshiy sha ninikay. ");
INSERT INTO ibl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Idi na‐akew ma, ja emanbo‐day i sekit, dimayat si Jesus nodta kilig ni baybay, nem eg sha inimatonan ey si‐kato. ");
INSERT INTO ibl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jet kowan to son si‐kara ey, “Towa? Waray kinnayo?” Simongbat ira ja kowan sha ey, “Enshi.” ");
INSERT INTO ibl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jet kowan to ma son si‐kara ey, “I‐kas jo ita balshew shita apit ni kanawan nita bangka, say ẃaray kekna‐en jo.” In‐ekas sha nga agpayso nodta kanawan ni bangka, jet idi natnaten sha ma sota balshew, eg ira makakoyod, ta eshakel i enakna. ");
INSERT INTO ibl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jet sota sakey ya apostol ja ensemek nen Jesus, inimatonan to ey si Jesus sota imesel, jet kowan to ey, “Si Apo Jesus met iman!” Idi intenengan nen Simon Pedro sota kowan to, insikkot to sota baro tod bakdang to, tep nandabos ni toka pannikay, jet imabtok da shima shanom ja nimangoy. ");
INSERT INTO ibl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nem sota eshom, nandogan ira nodta bangka, ingkato da nodta naykilig, jet inkoyod sha ma sota balshew ja enapno ni nigay. Say ka‐ashawi sha nodta kilig ni baybay, ondaw wa sandasos sa mitoro. ");
INSERT INTO ibl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Idi simabi ira ma nodta kilig ni baybay, ẃaray inon‐an shen emankedoton nigay ya naykedot nodta ngalab, jet ẃara pay i tinapay ja naysaganen kaytaksholan to. ");
INSERT INTO ibl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jet si Jesus, kowan to son si‐kara ey, “Alekayo di nita nigay ya kinnayo.” ");
INSERT INTO ibl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jet si Simon Pedro, dimaw nodta bangka jet to inkoyod ali nodta naykilig sota nigay ja enakna ja kakembaleg, jet say bilang nonta nigay, sandasos tan dimen polo, tan tedo. Enapno sota balshew, nem mapteng ta eg epi‐kat. ");
INSERT INTO ibl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jet si Jesus, tineẃal to ira ja kowan to ey, “Kalejo, mengan.” Jet nontan, angken sakey, enshiy engitoded son si‐kara ja engibeka son Jesus no sipa si‐kato, ta amtara ey si‐kato si Apo Jesus. ");
INSERT INTO ibl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jet si Jesus, inda to sota tinapay, jet shinowashowa to asan toka i‐ekan son si‐kara, asan ma sota naykedot ta nigay. ");
INSERT INTO ibl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sajay i maykatdon inpanpa‐sas nen Jesus so nonta ira too to, manipod nonta inpan‐ongal to. ");
INSERT INTO ibl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Idi enaksheng nga engan ira, inbag‐an nen Jesus si Simon Pedro, ja kowan to ey, “Wa‐ẃa‐sha ngatay semek mo son si‐kak ey say sota semek ira niya kait mo?” Jet si Simon Pedro, simongbat ja kowan to ey, “Owen Apo, amtam met ey ensemek taka.” Jet si Jesus, kowan to son si‐kato ey, “Ajowanim ira sota emati son si‐kak, ta si‐kara, may‐eshig ey singa kalnirok.” ");
INSERT INTO ibl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pininshowa to mowan ja kowan to ey, “Simon, ja anak nen Juan, ẃaray semek mo son si‐kak?” Simongbat si Pedro ja kowan to ey, “Owen Apo, amtam met ey ensemek taka.” Jet si Jesus, kowan to mowan son si‐kato ey, “Singpet mo ira sota emati son si‐kak, ta si‐kara, may‐eshig ey singa kalnirok.” ");
INSERT INTO ibl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jet nonta maykepintedo, kowan nen Jesus mowan so nen Pedro ey, “Simon, ja anak nen Juan, ẃaray semek mo son si‐kak?” Si Pedro, nandaringit ma, ta emintedo ja inbaga nen Jesus iyay son si‐kato, jet si Pedro, simongbat ja kowan to ey, “Apo, amtam ma emin, angken nganto. Amtam ey ensemek taka.” Jet si Jesus, kowan to ma son Pedro ey, “Ajowanim sota ira emati son si‐kak ta si‐kara, may‐eshig ey singa kalnirok. ");
INSERT INTO ibl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ikowan ko son si‐kam i kinapodpodno. Nonta nga‐nga ka, si‐kam ngoy emengi‐mag shorog ni balkes mo, jet sota piyan mon daẃan, si‐katoy toshongen mo. Nem no ma‐ema ka ali, apil ngo. Onshepa ka jet bedoren shaka, asan idaw shaka shima dogad ja eg mo koston daẃan.” ");
INSERT INTO ibl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Sajay i inkowan nen Jesus, ta piyan ton eẃatan koma nen Pedro i itsora ni ketey to ali, ja si‐katoy kayshedjawan nen Apo Shiyos.) Jet si Jesus, kowan to pay so nen Pedro ey, “Onod mowak.” ");
INSERT INTO ibl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Jet si Pedro, ẃimingi jet inon‐an to sota sakey ya apostol la ensemek nen Jesus ja timened son si‐kara, jet kowan to son Jesus ey, “Apo, jet si iyay ngay? Eg ngo mepesamak son si‐kato?” (Sajay sota sakey ya apostol ja nay‐askang son Jesus nonta ka‐onoran na inpandilikob sha, tan si‐katoy engikowan ey, “Sipa ta kowan mo ey mengibaag son si‐kam?”) ");
INSERT INTO ibl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jet si Jesus, simongbat ja kowan to son Pedro ey, “Kaspangarigan ey piyan kon si‐katoy manbiyag ingkato alid imotok ko mowan, enshiy mo naybiyangan. Si‐kak i onoren mo.” ");
INSERT INTO ibl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jet sajay ya inkowan nen Jesus pangkep so nonta sakey ya apostol, shinemag ira nonta eshom ma emati, jet say ẃared nemnem sha, kowan sha ey eg metmetey sota sakey ya apostol. Nem si Jesus, aliẃen sotan i olog nonta inkowan to, no diket say inkowan to, no bilang ey piyan ton manbiyag sotan na apostol ingkatod imotok to mowan ali, enshiy naybiyangan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Si‐kak sota sakey ya apostol. Jet emin iyay ya insolat ko, inon‐an kon mismo. Jet agpayson emin iya insolat ko; enshiy showashowa to. ");
INSERT INTO ibl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nem eshakel pay i dingdingka nen Jesus ja ekak insolat shiyay, ta no sa‐sa‐keyen kon isolat ja emin shi kedibdibsho, eg emo on‐anay iya dobong ja kaytedo‐an sha.");
INSERT INTO ibl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Agi Teopilo, sota epangdon dibshok, insolat koy emin na dingka nen Jesus tan intoro to, ");
INSERT INTO ibl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ingkato nonta akew wa indaw to la shi dangit. Nonta aneng nin i idaw to led dangit, inshalan ni Ispirito Santo jet inkowan toy pesing ira nonta pinidi ton too to ja apostol. ");
INSERT INTO ibl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Idi naksheng nga nanbiyag shi patey, eminshakel la nanpa‐sas son si‐kara ni oneg ni epat ta polon akew, say pati‐en sha ey agpayson ẃara ma shi biyag. Jet nantatabtabalan sha mowan i maypangkep ni pantoshayan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Idi nonta esa‐nop ira son si‐kato, inkowan to son si‐kara ey, “Karejo nin idekjas i Jerusalem, no diket seked jo nin sota Ispirito Santo nen Apo Shiyos ja inkari to, ja pan‐iyan to so ni totoo. Inkowan ko met iyay nontan. ");
INSERT INTO ibl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Shanom bengat i inosal nen Juan ni inpamonjag to, nem say pemonjag nen Apo Shiyos son si‐kayo, Ispirito Santo. Eg medebas i eshakel la akew manipod niman et mebonjagan kayo ma ni Ispirito Santo.” ");
INSERT INTO ibl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jet nonta esa‐nop ira sota apostol, inbag‐an sha si Jesus ja kowan sha ey, “Apo, aliẃen niman ayay pengisaad mo so ni epokaw den gobirno ni Israel?” ");
INSERT INTO ibl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Simongbat si Jesus ja kowan to ey, “Eg mesepol la amta‐an joy akew ono timpo, no pigan ali. Sota piyan nen Apo Shiyos ja Amak ni itongpal to so, si‐kato. ");
INSERT INTO ibl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nem iyay i ikowan ko son si‐kayo. Sota Ispirito Santo nen Apo Shiyos, man‐iyan so ni sakey tan sakey son si‐kayo say ẃaray panakabalin jon mengikowan ni maypangkep son si‐kak shi totoo, manshoki shi Jerusalem, Jodia, Samaria, tan shi emin na sakop niya dobong.” ");
INSERT INTO ibl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Idi enaksheng nga inkowan to iyay, kimayang ja indekjas to ira et dimaw shi dangit, jet binoja nonta ira apostol to i toka pankedjang ingkatod eg ma mayshedmang, ta dinikopan ni kolpot. ");
INSERT INTO ibl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jet idi maramen shaka pan‐ishemang i edimosan tod dangit, ebiglen ẃaray showen anghil ja nanbaro ni empoti ja nanpa‐sas son si‐kara. Sajay iren anghil, enshiy kaydesinan sha shi too. ");
INSERT INTO ibl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kowan nonta anghil son si‐kara ey, “Daleki ja i‐Galilia, ngantoy tinangkakan jo pay laeng shi dangit? Sajay ya si Jesus ja engilekjas son si‐kayo ni indaw to la shi dangit ja nay‐olop shi kolpot, inges niyay met laeng aliy i‐oli to.” ");
INSERT INTO ibl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jet sota ira apostol, edapo ira nodta shontog ga kowan sha ey Olibas jet imoli ira shi Jerusalem. (Say ka‐ashawi nonta Olibas shi Jerusalem, sakey ya kilomitro.) ");
INSERT INTO ibl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Idi mimotok ira shi Jerusalem, dimaw ira nodta naykayang nga kowadto ni baley ya shaka pan‐iyani. Jet iyay i ngarangaran ira nonta apostol nen Jesus: si Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolomeo, Mateo, sota sakey ya si Santiago ja anak nen Alpio, si Simon ja bitirano, tan si Judas ja anak ni apil mowan na Santiago. ");
INSERT INTO ibl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Emin ira jay, tan sota ira bibii, pati si Maria ja ina nen Jesus tan sota ira a‐aki nen Jesus, ireka mesa‐sa‐nop ni olay ja mansheẃat son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Idi edabas i pigen akew, ẃaray esa‐nop pa sandasos tan showen polo ja emati son Jesus. Jet nontan, dimayat si Pedro shi sango‐an sha jet nan‐esel, ");
INSERT INTO ibl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","ja kowan to ey, “A‐akik shi pamati, sota insolat nen Ari David nonta bayag da ja inshalan ni Ispirito Santo nen Apo Shiyos, etongpal da nonta inpangdo nen Judas Iskariote sota ira makakontra son Jesus ni in‐eshel sha so. Jet sajay ya si Judas i istay sakey son si‐kamin pinidi nen Jesus ja meki‐obda son si‐kamin apostol to nontan. Sajay i edaga ta mesepol la metongpal sota naypadto. ");
INSERT INTO ibl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Nem si Judas, nanbono, na‐kas et pimetnak i ekes to, jet bimo‐day ya emin i sosot to. Sota pilak ka inda to ni inbaag to so nen Jesus, intongkal sha ni bo‐day. ");
INSERT INTO ibl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Inamta‐an ni emin na totoo shi Jerusalem iyay ya inpanbono nen Judas; isonga sajay ya bo‐day, inpanngaran sha ni Akildama, ja say olog to, ‘Baley ni shala.’ ");
INSERT INTO ibl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Nonta bayag da, ẃaray naysolat shi dibsho ni Salmo ja kowan to ey, ‘Kari, manbedin i baley to ni diyasang jet enshi may man‐iyan.’ Tan ẃaray naysolat pay ey, ‘Sota istay obda to, elbaten ni eshom.’ ");
INSERT INTO ibl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Isonga mesepol la ẃaray maysa‐dat son Judas, say onkostoy bilang min apostol, ja mengikowan ni inpanbiyag nen Jesus shi patey. Nem say maysa‐dat son si‐kato ja may‐a‐shom son si‐kami, sota sakey ja eki‐odo‐odop ni olay son si‐katejo manshoki nonta kepemonjag nen Juan ingkato nonta akew wa indekjas shakito so nen Jesus ni indaw to la shi dangit.” Kowan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jet showen too i nanpili‐an sha: si Jose Barsabas, ja Justo met laeng i ngaran to, tan si Matias. ");
INSERT INTO ibl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nanshawat nin ira son Apo Shiyos ja kowan sha ey, “Apo ja maka‐amta ni nemnem ni too, itoshom son si‐kami nem sipa so ira niya showa i on‐elbat so ni obda nen Judas Iskariote ja istay apostol, ja dimaw shi anam ton dinaẃan.” ");
INSERT INTO ibl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jet nanpipini‐not ira jet say bimo‐day, si Matias, jet si‐kato may nay‐eshom so nonta ira sampolo tan sakey ja apostol. ");
INSERT INTO ibl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Idi simabi sota akew wa timpon piyasta ni Hodiyos ja kowan sha ey Pintikostis, emin ira sota emati, esa‐nop ira shi sakey ya kowadto. ");
INSERT INTO ibl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jet ebigla ja ẃaray emanbongog alid dangit ja singa shagem, jet pinno ton emin sota baley ya kawad‐an sha ja shaka pantetongawi. ");
INSERT INTO ibl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jet ẃaray inon‐an shen nay‐epeng nga simepa son si‐karen emin, ja apoy ja singa shila i itsora to. ");
INSERT INTO ibl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jet nontan ma, enapno ira ni Ispirito Santo nen Apo Shiyos, jet nan‐esel ira ni ekalkalasin esel ja aliẃen sigod ja esel sha. Nan‐esel ira ni apil ngon esel tep inshalan ira ni Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naytompong nontan ja ẃara iray Hodiyos ja edapod ka‐ili‐ilid ja dobong ja eman‐iyan nin shi Jerusalem ja makedsang i pamatira son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Idi itenengan ira nonta totoo sota emanbongog ja edapo alid naykayang, dimaw ira ja sha inon‐an, jet enasshaaw iren pasiya ta idi intenengan sha sota esel ira nonta emati, sota mismon esel ni sakey tan sakey son si‐kara i bolikas nontan na esel. ");
INSERT INTO ibl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jet sota ira totoo, ireka emesshaaw, ta eg sha eẃatan no ngantoy inpasing niyay, jet kowan sha ey, “Apay sajay iren emin na eman‐a‐sel ket, i‐Galilia met ira? ");
INSERT INTO ibl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ngaranto ayay inpasing niyay? Amtara met ja man‐a‐sel ni esel shi dogad ja nay‐anakan tayo, ket aliẃen esel sha? ");
INSERT INTO ibl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Edapo kito met ali shi Partia, Midia, Ilam, Misopotamia, Jodia, Kapadosia, Ponto, Asiya, ");
INSERT INTO ibl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia, Pampilia, Egypt, tan sakop ni Libya ja naysakop ngo shi Sirini. Wara pay i eshom son si‐katejo ja bisita alid Roma, ja Hodiyos i eshom, tan sota ira eshom, aliẃen Hodiyos ja etod‐an ja manshedjaw son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sota ira eshom, edapo ired Crete tan shi Arabia!” Jet sajay iren totoo ja edapod ja kalkalasin dogad, kowan sha ey, “Amta met iren jay i esel tayon kalkalasi. Si‐katoy shaka pan‐a‐sel ni maypangkep ni kaskasshaaw wa inpaspasing nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jet emin ira, ireka messhaaw ta eg sha eẃatan iyay, jet kowan sha ey, “Ngaranto emo iya emankepasemak niman?” ");
INSERT INTO ibl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nem sota ira eshom, endedamsis sha, ja kowan sha et ey, “Enshi — eboteng ira tan ni adak!” ");
INSERT INTO ibl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sota sampolo tan showa ja apostol, si Pedro i tima‐shel son si‐kara ja nan‐esel, jet inkedsang toy esel to ja kowan to ey, “Si‐kayon totoo ja i‐Jodia, tan si‐kayon emin na eman‐iyan shiya Jerusalem, mesepol la amta‐an jo iyay! Itnengi jon pasiya iya ikowan ko son si‐kayo! ");
INSERT INTO ibl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sajay iren kait ko, aliẃen eboteng ira ja si‐katoy pangkep jo; ta alas nowibi pay laeng ni agsapa! ");
INSERT INTO ibl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sajay sota tongpal ni inpadto nen Joel nonta bayag da, ");
INSERT INTO ibl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ja esel met laeng nen Apo Shiyos, ja kowan to ey, ‘Shi ka‐onoran alin timpo, sajay i pesing ko: pan‐iyan ko i Ispiritok so ni emin na totoo jet sota ira annak sha, mengipadto ira ni maypangkep son si‐kak, jet ẃaray pa‐amtak so ni bedoleki tan nankedakay shi kokokip sha. ");
INSERT INTO ibl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Owen, angken sota ira daleki tan bibii ja mansilbi son si‐kak ni sajay alin timpo, pan‐iyan koy Ispiritok son si‐kara, jet si‐karay mengikowan ni ipa‐amtak son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Waray ipa‐sas ko so ni totoo ja medeka shi naykayang nga kaskashaaw, tan angken shiya dobong, ẃaray ipa‐sas ko son si‐kara ja panakabalin ko: ẃaray maybokbok ka shala tan ẃaray apoy ya eposkol i dowet to. ");
INSERT INTO ibl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma‐shep i sekit, tan onbalenga i bolan ja singa shala, jet no meksheng nga mepesamak iyay, si‐kato ma diy idaw ko. Sajay alin akew, kaskasshaaw wa enshiy to kay‐ingesan. ");
INSERT INTO ibl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jet sajay alin timpo, sota ira manbeka son si‐kak ni kaasi, kaasi‐an kon isalakan.’ Sajay day padto nen Joel. ");
INSERT INTO ibl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Si‐kayon kait kon Hodiyos, itnengi jo iya ikowan ko son si‐kayo! Si Jesus ja i‐Nasarit, inpandaga nen Apo Shiyos ni kaskasshaaw wa milagro, ja inon‐an jon mismo, jet si‐katoy pengamta‐an jo ey si‐katoy inbetkag nen Apo Shiyos. Amtayon emin iyay. ");
INSERT INTO ibl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sigod ja amta nen Apo Shiyos i mepesamak ali son Jesus shiya dobong tep plano to ngoreshan na sigod. Jet siya, intolok ton metey si Jesus. Nem si‐kayon Hodiyos i mismo emono son si‐kato! Inpabonoyo so nonta ira i‐Roma ja nankekedsel jet indansara shi koros. ");
INSERT INTO ibl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nem si Apo Shiyos, eg to intolok ja on‐onong si Jesus ja metey; isonga inpanbiyag to, ta say patey, enshiy panakabalin ton mengipked son Jesus. ");
INSERT INTO ibl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si‐kato sota nantongpalan nonta padto nen Ari David nonta bayag da, ja kowan to ey, ‘Si Apo Shiyos, ẃara ni olay son si‐kak, ẃara ni olay shi apit ni kanawan ko, say ekak ontakot. ");
INSERT INTO ibl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Isonga naka man‐imdeng tan naka man‐iyaman, jet angken saja bakdang ko, sigoradoy namnama to, ");
INSERT INTO ibl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ta eg mowak baybay‐an shi dogad ja kawad‐an ni etey. Jet eg mo ipalobos ey saja bakdang ko ket mebojok, ta ensemek mowak. ");
INSERT INTO ibl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inpa‐amtam i shalan son si‐kak ja ontorong shi biyag, jet enapno‐ak ni imdeng ta ẃara ka son si‐kak.’ Kowan ni padto nen Ari David.” ");
INSERT INTO ibl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jet si Pedro, intoloy to ja kowan to so nonta totoo ey, “A‐akik, idawag ko son si‐kayoy olog nonta padto nen Ari David ja makapoli son si‐katejo. Etey si David jet naybeka, jet sota dobok to, ẃara shiya kad‐an tayo ingkato niman. ");
INSERT INTO ibl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Isonga aliẃen si‐katon shorog i kaytoshongan nonta inpadto to, no diket inpadto to bengat. Amta to sota kari nen Apo Shiyos son si‐kato ja kowan to ey, ‘Wara aliy sakey so nonta polim ja panbedin kon ari ja inges mo jet si‐katoy on‐elbat so ni intorayan mo.’ ");
INSERT INTO ibl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Si Ari David, amta toy plano nen Apo Shiyos; isonga inpadto toy maypangkep so nonta amta ton ibetkag ali nen Apo Shiyos ja mengisedakan nonta inkowan to ey, ‘Eg mowak baybay‐an shi dogad ja kawad‐an ni etey’, tan nonta inkowan to ey, ‘Eg mebojok iya bakdang ko.’ ");
INSERT INTO ibl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Apo Shiyos, inpanbiyag to si Cristo shi patey, jet inon‐an min mismoy bakdang to alid patey! ");
INSERT INTO ibl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jet niman, ẃared apit ni kanawan nen Apo Shiyos; isonga in‐akan nen Ameto sota Ispirito Santo son si‐kato ja inkari to, jet sajay ya Ispirito Santo iya intenengan jo niman tan inon‐an jo ja in‐awat ngo nen Jesus son si‐kami. ");
INSERT INTO ibl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jet angken si Ari David nonta bayag da, eg dimaw shi dangit, nem si Cristo, si‐katoy dimaw shi dangit; isonga inkowan nen David ey, ‘Kowan nen Apo Shiyos so nonta apok ey ontongaw shi apit ni kanawan to, jet pan‐eshi to, ");
INSERT INTO ibl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","jet sota kabakal to, panbedin to ja panpetokan ni sedi to.’ ");
INSERT INTO ibl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Isonga si‐kayon emin ja kait kon Hodiyos, mesepol la amta‐an jon pasiya ey si Jesus ja inpaidansayo shi koros, si‐kato sota inpanbalin nen Apo Shiyos ni Apo tayon emin! Si‐kato sota singsingked tayon inkari nen Apo Shiyos ey ibetkag to din mengisedakan!” Sajay i kowan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jet idi intenengan sha iyay, nandaringit ira, ja kowan sha so nen Pedro tan sota eshom ma apostol ey, “A‐aki, ngaranto ngarod i pesing mi?” ");
INSERT INTO ibl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Si Pedro, simongbat ja kowan to ey, “Panbebawi kayo et emin kayo, panpabonjag kayo ja si Jesucristo i toshongen jon pati‐en ni olay, say mepekawanan i basol jo. Jet eẃaten jo sota Ispirito Santo nen Apo Shiyos ja i‐akan to. ");
INSERT INTO ibl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ta sota Ispirito Santo ja inkari nen Apo Shiyos, para so ni emin na toon pinidi ton manbedin na too to, jet mayda‐kam kayo, pati sota ira annak jo, tan angken pay sota ira toon aliẃen kait tayon Hodiyos.” ");
INSERT INTO ibl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jet si Pedro, eshakel pay i adok to so nonta totoo, ja kowan to ey, “Mesepol la itolok jon si Apo Shiyos i mengisedakan son si‐kayo, say eg tokejo pekishosa so ira niya toon ngaaw i aramid sha.” ");
INSERT INTO ibl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jet sota emati ni inkowan nen Pedro, binonjagan sha ira, jet say kabebilang sha ja nay‐eshom so nonta sigod ja emati son Jesus nontan na akew, tedon dibo. ");
INSERT INTO ibl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jet sajay ira, intoloy sha ja tinod‐an ira nonta apostol. Nontan ma, ireka mesa‐sa‐nop ni olay ja manshedjaw tan mansheẃat son Apo Jesus, jet ireka pay mandilikob ja mengan. ");
INSERT INTO ibl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jet sota ira apostol, eshakel i kaskasshaaw wa dingkara jet nontan, emin ira sota totoo, etakot ira tep ineẃatan sha ey panakabalin gayam nen Apo Shiyos iyay. ");
INSERT INTO ibl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Emin ira sota emati, saksakey i ẃared nemnem sha, jet emin sota kokowa ni sakey tan sakey son si‐kara, kokowaren emin. ");
INSERT INTO ibl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jet indako shay bo‐day sha, angken pay sota ira kompormin kokowara, jet inẃaris sha sota nandako‐an sha so nonta ira makasapol. ");
INSERT INTO ibl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inakew ja ireka ondaw shi Timplo, jet shima balebaley sha, ireka mandilikob, jet ebadeg i imdeng sha ni shaka pengan, ta saksakey i nemnem sha son Jesucristo. ");
INSERT INTO ibl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Si Apo Shiyos ni olay i shaka ishayshayaw, jet angken sota emin na totoo, kowan sha ey mapteng ira sota emati. Jet si Apo Shiyos, inakew ja ẃaray toka i‐eshom son si‐kara ja maysedakan. ");
INSERT INTO ibl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nonta sakey ya akew, si Pedro nen Juan, dimaw ira shi Timplo ni oras ni alas tris ni mama‐shem ta si‐katoy oras sa kepansheẃat ni Hodiyos son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nodta sakepan shi Timplo ja kowan sha ey Memapteng nga Sakepan, ẃaray toon emankekekshaw ni pilak so nonta toon emanseskep. Sajay ya too, nay‐anak ka epilay ja eg maka‐akad, jet inakew wa shaka idaw nodtan. ");
INSERT INTO ibl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Idi inon‐an tos Pedro nen Juan ja onsekep shi Timplo, emengshaw ni pilak son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nem si Pedro nen Juan, intekel sha iyay ya too, jet si Pedro, imesel ja kowan to ey, “Idmang mokami.” ");
INSERT INTO ibl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jet sajay ya toon epilay, inshemang to ira ja kowan to emo ey ẃaray i‐akan sha son si‐katon pilak. ");
INSERT INTO ibl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nem si Pedro, kowan to ey, “Enshiy pilak ko, nem ẃaray itolong ko son si‐kam ja medepo so nen Jesucristo ja i‐Nasarit. Isonga niman, pan‐akad ka!” ");
INSERT INTO ibl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jet si Pedro, shineẃat toy kanawan na takday nonta epilay jet inpaledjat to. Jet sota sedi nonta epilay, kimedsang nga shagos. ");
INSERT INTO ibl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Imabtok jet nan‐akad ja ekiskep so nen Pedro nen Juan shi Timplo, jet eman‐eka‐ekad tan eman‐ab‐abtok ni iyaman to son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jet emin ira sota totoo, inon‐an sha i toka pan‐ekad ma tan toka pan‐iyaman son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Inimatonan sha ey si‐kato sota kaontongtongaw ni olay shima Memapteng nga Sakepan ni Timplo ja emankekeshaw ni pilak, jet enasshaaw iren pasiya ta eg sha eẃatan no ngarantoy edaga son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Isonga sota ira totoo, inedibongbongan sha si Pedro nen Juan, shima kowan sha ey Sishoman nen Solomon, ja naysilpo nodta Timplo, jet sota toon epilay ja eman‐ekad ma, pimeket son Pedro nen Juan. ");
INSERT INTO ibl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jet idi asen nen Pedro ey eshakel aliy totoon emankesa‐nop ali son si‐kara, kowan to so nonta totoo ey, “Si‐kayon kait kon Hodiyos, apay nga kayoka messhaaw niyay ya banag? Apay nga jokamika iningning? Karejo ipangkep ey ẃaray panakabalin mi, ono eshiyosan kami, ja si‐katoy kabol la nan‐akashan niyay ya too. ");
INSERT INTO ibl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Enshi! Si Apo Shiyos ja Shiyos nen Abraham, Isaac, tan si Jacob ja ap‐apo tayo da nonta bayag, si‐kato i inpan‐akad so niyay ya epilay, say ma‐amta‐an i kina‐Shiyos nen Jesus, ja Anak to. Saja si Jesus, si‐kato sota in‐awat jo shi toray say mebono. Jet si Gobinarol Pilato, piyan ton ibolos koma, nem emasig kayon kowan jo ey eg jo kosto. ");
INSERT INTO ibl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Si‐kayo, binedaw jo iyay ya toon mapteng nga enshiy basol to, ey sota toon bimono, si‐kato et ngo mowan i kinshaw jo so nen Pilato ja ibolos to para son si‐kayo. ");
INSERT INTO ibl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jet si Jesus ja kepandepo‐i ni biyag, inpabonoyo! Nem si Apo Shiyos, inpanbiyag to mowan. Jet si‐kami i mismon engasas ni bakdang to nonta nanbiyag mowan. ");
INSERT INTO ibl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Si‐kami, pinati mi ey ẃaray panakabalin ni ngaran nen Jesus; isonga si‐katoy kinedsangan niya epilay. Am‐amtayo iyay ya too, joka on‐on‐i ni inakew, jet niman, mismon iyed jay ja kimedsang! ");
INSERT INTO ibl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Jet niman, si‐kayon a‐akik, amtak ey si‐kayo, tan sota ira toray jo, eg jo amtay kina‐Shiyos nen Jesus nonta inpabonoyo. ");
INSERT INTO ibl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nem sajay i ketongpal nonta inpaipadto nen Apo Shiyos nonta bayag da, ey sota inkari to ja ibetkag to alin mengisedakan, da‐kaman toy digat ni ketey to. ");
INSERT INTO ibl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Isonga panbebawi kayo ni ngaaw wa aramid jo, jet si Apo Shiyos i toshongen jo say omasen toy basol jo, ");
INSERT INTO ibl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","say meẃad‐an kayo ni mapteng nga dekna ja medepo son si‐kato. Jet ibetkag to mowan ali si Jesucristo ja shinotokan to. ");
INSERT INTO ibl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nem si Jesus, mesepol la on‐onong nin shi dangit ingkatod metongpal la emin sota inpaipadto nen Apo Shiyos ja bado‐an to iya dobong, ta sajay i inpadto nonta eshiyosan na para padto nonta bayag da. ");
INSERT INTO ibl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Jet angken si Moises, inkowan to ey si Apo Shiyos, mengibetkag ali ni para padto ja inges toy inpangibetkag nen Apo Shiyos son si‐kato, jet kowan to ey sajay, mandepo shi kait tayo, jet kowan to pay ey mesepol la pati‐en tayon emin i ikowan nonta ibetkag ali nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jet kowan pay nen Moises ey no sipa iray toon eg memati ni ikowan niyay alin para padto ja ibetkag nen Apo Shiyos, meshosa ja maysi‐jan so ni too nen Apo Shiyos. Sajay i inkowan nen Moises. ");
INSERT INTO ibl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Jet emin sota inkowan ni para padto, manshoki son Samuel, ingkato so nonta ira emin na naysa‐dat, nan‐i‐inges i inpadtora pangkep ni saja emankedaga niman. ");
INSERT INTO ibl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sota inkari nen Apo Shiyos ja inkowan ni para padto, si‐kayo i naykari‐an to, jet mayda‐kam kayo pay mowan nodta kari to so nonta apo jo la, ta inkowan to son Abraham ey, ‘Mapteng aliy panpa‐no‐an ni totood emin na ka‐ili‐ili, jet sota polim Abraham i kabol la kayda‐kaman sha.’ ");
INSERT INTO ibl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Si‐katejon Hodiyos i epangdon inbetkagan so nen Apo Shiyos so ni Anak to, ja si Jesus, say panbebawi shakito nonta kakedsel tayo, jet siya, nansigshan tayo!” Sajay day inkowan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nonta maramen eman‐a‐sel si Pedro nen Juan so nonta totoo, dimaw ira di sota papashi ni Hodiyos, apo ni kowadja nodta Timplo, tan sota ira kowan sha ey Sadosiyo, ");
INSERT INTO ibl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ja ireka onbanonget. Ta si Pedro nen Juan, intoro sha so nonta totoo ey si Jesus, nan‐ongal jet si‐katoy inbasalan sha so ey angken sota ira eshom ma nanketey, manbiyag ngo ira ali. ");
INSERT INTO ibl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jet inshel sha si Pedro nen Juan ja sha ira pebistigal. Nem nontan, ta mankedabi, enshiy pesing shen memistigal son si‐kara; isonga inbalod sha nin ira. ");
INSERT INTO ibl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nem eshakel mala iray toon emati nonta inteneng sha sota inkowan nen Pedro nen Juan pangkep so nen Jesus, jet say kabebilang ira nonta ematin daleki, dimen dibo. ");
INSERT INTO ibl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nonta eẃa‐ẃa, sota ira toray ni Hodiyos, tan sota eshom ma pangolo sha, pati sota ira mamaistoro ni dinteg ni Hodiyos, ẃara iren esa‐nop shi Jerusalem. ");
INSERT INTO ibl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jet angken sota kangeto‐an na pari ja si Anas, tan shi ira Kaipas, si Juan, si Alejandro, tan sota emin na partido nen Anas, ekisa‐nop ira. ");
INSERT INTO ibl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sha inda ali si Pedro nen Juan jet inpa‐adagey sha ira nodta nankinaw‐an sha, jet inbag‐an sha ira no ngarantoy inpamaal shen inpakedsang nonta toon epilay. Kowan sha ey, “Sipen ngaran i inngadnan jo nontan?” ");
INSERT INTO ibl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jet si Pedro, ja inshalan ni Ispirito Santo, simongbat ja kowan to ey, “Si‐kayon toray tan pangolo ni Israel, ");
INSERT INTO ibl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jokamika panbistigala niman ni maypangkep ni mapteng nga dingka mi ni inpan‐akad mi so niya toon epilay. Jet no piyan jon amta‐an i inpasing ton mimapteng, ");
INSERT INTO ibl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","pa‐amta mi son si‐kayo, pati pay sota eshom ma totoon Hodiyos, ey si Jesucristo ja i‐Nasarit ja binonoyon indansa shi koros, inpanbiyag mowan nen Apo Shiyos, jet si‐katoy kabol la minaptengan niyay ya toon istay epilay ja ẃara niman shi sango‐an jo. ");
INSERT INTO ibl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus i kaytoshongan nonta inkowan nonta naysolat ja kowan to ey, ‘Sota baton binedaw jon para amag ni baley, ja kowan jo ey enshiy silbi to, si‐kato et ngo mowan sota epateg ga mesepol jon pasiya.’ ");
INSERT INTO ibl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Enshiy eshom ma tood ja dobong nga inbetkag ali nen Apo Shiyos ja mengisedakan, nem eg si Jesus bengat.” Kowan nen Pedro. ");
INSERT INTO ibl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jet idi inon‐an sha ey etoled si Pedro nen Juan ja man‐a‐sel, nasshaaw iren pasiya ta amtara ey sajay iren too, ootik i ashal sha. Nem ninemnem sha ey si‐kara gayam sota eki‐odo‐odop so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jet sota ira toray tan sota ira pangolo ni Hodiyos, enshiy pesing shen mengipidit ni piyan sha, ta sota toon istay epilay, mismon ẃara nodtan ja kadẃa nen Pedro nen Juan. ");
INSERT INTO ibl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jet say inpasing sha, inpabo‐day sha nin si Pedro nen Juan, jet nantatabtabal ira sota toray, ");
INSERT INTO ibl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ja kowan sha ey, “Ngantoy pesing tayo aya son si‐kara, ket sota kaskasshaaw wa dingkara ket amta ni emin na tood Jerusalem, jet eg tayo mebedin na isaot.” ");
INSERT INTO ibl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Idi anongosto ma, ninemnem shay pesing sha, ja kowan sha ey, “Say pesing tayo, say eg amta‐an pay ni totoo, ikowan tayo son si‐kara ey kenshat ta ibi‐jag shen mengitosho shi totoo ni maypangkep nonta shaka itorotoro.” ");
INSERT INTO ibl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jet tina‐ẃal shes Pedro nen Juan et inkowan sha son si‐kara ey, “Niman ma, kenshat ta ibi‐jag jon mengitosho ono mengikowan shi totoo ni maypangkep nonta joka itorotoro!” ");
INSERT INTO ibl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nem si Pedro nen Juan, simongbat ira ja kowan sha ey, “Nemnem jo kari, no sipay piyan nen Apo Shiyos ja pati‐en mi — sota kowan to ono sota kowan jo? ");
INSERT INTO ibl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sota inon‐an mi tan intenengan mi son Jesus, kenshat ta eg mebedin na isalsheng min mengikowan shi totoo.” ");
INSERT INTO ibl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jet sota ira toray, kini‐det shen binidin ira, asan shaka ibodos ira ta enshiy basol sha ja sha so ira shosa‐an. Tan sakey pay ja inbolosan sha so ira, sota emin na totoo, ireka man‐iyaman son Apo Shiyos ni inmapteng nonta toon epilay. ");
INSERT INTO ibl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Saja toon istay epilay ya kaskasshaaw i inmapteng to, esolok ka epat ta polo i tawen to. ");
INSERT INTO ibl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jet nonta ebolos si Pedro nen Juan, imoli iren shagos shima kad‐an ni kagajem sha jet inkowan sha son si‐kara i emin na dingka ira nonta apo ni papashi tan sota eshom ma pangolo ni Hodiyos son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Idi intenengan sha iya inkowan nen Pedro nen Juan, nansaksakey ira ja nanshawat son Apo Shiyos, ja kowan sha ey, “Apo Shiyos ja emalsowa ni dangit, dobong, baybay, tan emin na ẃara so iren jay, ");
INSERT INTO ibl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","angken si David ja toom, ja apo mi la nonta bayag, inshalan ni Ispirito Santo, jet insolat to ey, ‘Apay nga emanbonget iray toon eg emati? Apay nga eshakel i piyan ni tood ja Israel ja dag‐en nem enshiy tongpal to? ");
INSERT INTO ibl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nansaganay arin emin shiya dobong, pati sota ira toray, na‐olnong ira ja memekal son Apo Shiyos tan memekal so nonta shinotokan to ja mengisedakan ali.’ Sajay i kowan nen David, ");
INSERT INTO ibl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","jet say kina‐agpayso to, si Ari Hirodis, tan si Poncio Pilato, tan sota ira toon eg emati ja aliẃen Hodiyos, tan angken sota ira tood Israel, nantotodag ira ja maykontra son Jesus ja Anak mon shinotokan mo. ");
INSERT INTO ibl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nansaksakey ira ja ondaga ni piyan sha. Sajay ngoreshan i planom et dingkara shi timpon inkesheng mo. ");
INSERT INTO ibl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Niman Apo Shiyos, on‐im ima ngaaw wa planora ja kowan sha ey dag‐en sha son si‐kami, jet si‐kamin toom, akniyokami ni kedsang min mengitosho ni esel mo shi totoo. ");
INSERT INTO ibl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipedobos mo son si‐kami ja ma‐aknan ni panakabalin nen Jesus ja Anak mon shinotokan mo, say mengekas kami ni emansekit, tan mandeka kami ni milagro, ta si‐katoy pengamta‐an sha ey si‐kam i makapanakabalin.” Kowan sha ni shawat sha. ");
INSERT INTO ibl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jet idi naksheng nga nanshawat ira son Apo Shiyos, kimiwed sota baley ya esa‐nopan sha, jet emin ira, enapno ira ni Ispirito Santo jet etoled ma ira ja mengikowan ni esel nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jet emin ira sota emati, nansaksakey i pangkep sha tan nemnem sha, ja ayshiy kowan ni sakey tan sakey son si‐kara ey sota kokowa to, mos‐an to, no diket kokowaren emin. ");
INSERT INTO ibl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jet nontan, sota ira apostol, mas kimedsang iren mengitosho ni maypangkep son Apo Jesus, jey nanbiyag mowan shi patey, jet si Apo Shiyos, ebadeg i kaasi to son si‐karen emin. ");
INSERT INTO ibl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Emin ira sota emati, enshiy nankolang son si‐kara ni mesepol sha, ta sota ira ẃaray bo‐day to, ono baley to, indako sha, ");
INSERT INTO ibl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","jet sota nandako‐an sha, in‐awat sha so nonta ira apostol ja si‐karay maka‐amta ja mengiweshis nonta pilak so nonta ira makasapol. ");
INSERT INTO ibl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jet nontan, ẃaray sakey son si‐kara ja emati ja si Jose i ngaran to. Sota ira apostol, inbeshayan sha ni Bernabe, ta say olog to, “mengi‐kan ni pansi‐metan”. Sajay ya too, nay‐anak shi Cyprus, nem Hodiyos met laeng ja para tolong ni pari. ");
INSERT INTO ibl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Waray indako ton eshom ma bo‐day to, jet sota nandako‐an to, in‐awat to so nonta ira apostol. ");
INSERT INTO ibl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wara ngoy dakin manngeshan ni Ananias, jet aseẃa to si Sapira. Nandako ira ni eshom ma bo‐day sha, ");
INSERT INTO ibl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","jet nantolagan sha ey sota eshom ma pilak ja tongkal nontan na bo‐day, i‐akan sha ni apostol, nem sota eshom, isaot sha et italo sha. ");
INSERT INTO ibl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nem si Pedro, kowan to son Ananias ey, “Ananias, apay nga intolok mo ja si Satanas i engitoshay son si‐kam? Nakol ni nan‐o‐owap ka so ni Ispirito Santo nen Apo Shiyos. Isonga intalom i eshom ma dako nonta bo‐day. ");
INSERT INTO ibl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sotan na bo‐day, kokowam met, jet olay toka ngo no idakom ono enshi. Isonga sota dako to ngo, enshiy ememidit ey i‐akan mo. Nemnem mo ngon mengi‐kan ali. Nem ngantoy kabol la engisaotan mo so ni koskoston tongkal to? Kowan mo emo ey too i i‐owapan mo, nem si Apo Shiyos i inba‐ngasan jo!” ");
INSERT INTO ibl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Idi intenengan nen Ananias iyay den inkowan nen Pedro son si‐kato, ebiglen eto‐dang et etey. Jet emin sota enamag niyay ya epasemak, timakot iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sota ira bedoleki, dimaw ira di ja sha dinibotan i bakdang nen Ananias, jet sha inbeka. ");
INSERT INTO ibl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Idi ẃaray tedon oras ja dimabas, mimotok ngo ali si Sapira ja aseẃa nen Ananias, nem eg to amta ey etey si aseẃa to. ");
INSERT INTO ibl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jet si Pedro, inbag‐an to si Sapira no sota pilak ja in‐akan sha ni apostol ket, sotan i koskoston tongkal nonta bo‐day sha. Jet si Sapira, kowan to ey sotan bengat. ");
INSERT INTO ibl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jet kowan ma nen Pedro son si‐kato ey, “Ngantoy ninemneman jo so niyay? Apay nga nantolagan jon peshasen i Ispirito Santo nen Apo Shiyos no amta to, ono enshi, sota basol jon i‐emot jo? Asas mo ita bedoleki ja engibka son aseẃam; itan ira niman shita sakepan jet angken si‐kam, shaka ngo di en ibeka.” ");
INSERT INTO ibl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jet si Sapira, eto‐dang ngon bigla et etey shi sango‐an nen Pedro. Jet idi simekep ira di sota bedoleki, inon‐an shen etey si Sapira et binangtal sha jet sha inbeka nodta askang ni naybeka‐an nen aseẃa to. ");
INSERT INTO ibl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Emin ira sota emati son Jesus, tan sota eshom ja engitneng niyay ya banag, eta‐kot iren pasiya. ");
INSERT INTO ibl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sota ira apostol, eshakel i kaskasshaaw wa dingkara ja inon‐an ira nonta totoo. Jet emin ira sota emati, ireka mesa‐nop ni olay ma nodta nay‐askang shi Timplo ja kowan sha ey Sishoman nen Solomon. ");
INSERT INTO ibl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jet sota eshom ma eg emati, entakot shen may‐a‐shom so nonta ira emati, nem ẃara mangoy shaka pengiredjaw son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nem asdeg to ngoy daleki tan bibii ja nay‐eshom so nonta ira sigod ja emati, jet mas shimakel ira. ");
INSERT INTO ibl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jet sota ira emanpansekit, in‐ilaw sha ali ira nodta kalsara ja imonong ira nodta shinokolan sha, jet kowan sha ey no ondabas alis Pedro, balang nem dabsan ni adirong to ira, say ma‐kal i sakit sha. ");
INSERT INTO ibl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jet angken sota ira dogad ja nay‐esop shi Jerusalem, ireka emengidaw ni emanpansekit son si‐kara, jet angken sota ira toon kawad‐an ni dimonyo, indaw sha ira di, jet mimapteng ira. ");
INSERT INTO ibl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nem sota kangeto‐an na pari ni Hodiyos, tan sota ira kait ton Hodiyos ja kowan sha ey Sadosiyo, ireka emanbonget, tep ma‐epal ira so nonta apostol. ");
INSERT INTO ibl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jet say inpasing sha ma son si‐kara, inshel sha jet inbalod sha ira. ");
INSERT INTO ibl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nem nonta edabi, sota anghil nen Apo Shiyos, to dino‐katan ira sota sakepan ni badoran, jet inpangdo to iren bimo‐day. Jet say kowan nonta anghil son si‐kara, kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Daw kayo shima Timplo, jet jo itosho so ira nima totoo i maypangkep son Jesucristo, ey si‐katoy kedepo‐i nonta biyag ja inkari nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jet sota ira apostol, pinatira sota inkowan nonta anghil, jet dimaw ira nonta agsapen pasiya shi Timplo ja sha intoro i maypangkep son Jesus. Jet nontan na agsapa met laeng, sota kangeto‐an na pari, tan sota ira kait to, sina‐nop sha iren emin sota pangolo ni Hodiyos, jet engibetkag ira ni en mengodop nonta apostol shi badoran. ");
INSERT INTO ibl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nem idi onmotok sota inbetkag sha ja en mengodop so nonta ira apostol nodta badoran, enshi la ira gayam. Jet sota istay en mengodop, nay‐oli ira, ");
INSERT INTO ibl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","jet sha inkowan ey, “Enshi met da ira sota kowan jo ey mi odopen shi badoran. Sota sakepan ni badoran, naytolbek met, tan angken sota ira kowadja, ẃara met ira nodta pasbol ja emanbantay; nem idi do‐katan mi sota badoran, enshiy mi simbi! Angken sakey son si‐kara ket enshi nodta naydaem!” ");
INSERT INTO ibl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jet idi intenengan nonta apo ni kowadja ni Timplo tan sota apo ni papashi sota kowan sha, nasshaaw iren pasiya, tan ireka emanshanag no ngarantoy panpa‐pa‐no‐an niyay ya epasemak. ");
INSERT INTO ibl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jet nontan met laeng nga agsapa, ẃaray sakey ya toon simekep ali nodta esa‐nopan ira nonta toray ni Hodiyos jet kowan to ey, “Sota toon inbalod jo, ẃara ired ma Timplo ja emantosho so ni totoo!” ");
INSERT INTO ibl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jet sota apo ni solsharo, en engolop so nonta ira kapitan na too to met laeng, jet dimaw ira so nonta apostol, ja sha ira inadok ja may‐odop son si‐kara. Eg sha ira pinidit, ta entakot ira so nonta totoo, ta baka et ey onbonget sota totoo, nakol ni kespigan sha ira ni bato. ");
INSERT INTO ibl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inodop sha ira sota apostol jet insekep sha ira nodta esa‐nopan ni toray, jet sota kangeto‐an na pari, kowan to son si‐kara ey, ");
INSERT INTO ibl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Apay nga eg jokami pati‐en? Inkowan mi met son si‐kayo ey kenshat ta ibi‐jag joy joka pengitosho ni maypangkep so nonta joka itorotoro, nem niman, joka et ma‐ma‐a, nakol ni inamta‐an ni emin na totoo shi Jerusalem! Say piyan jo, si‐kamiy pebesolan sha ni inkabono nonta toon joka ingadngadni?” ");
INSERT INTO ibl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nem si Pedro tan sota eshom ma apostol, simongbat ira ja kowan sha ey, “Mesepol la si Apo Shiyos i pati‐en mi; aliẃen sota kowan ni too.” ");
INSERT INTO ibl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tan kowan pay nen Pedro ey, “Si Apo Shiyos ja pinati ira nonta ametayo da nonta bayag, inpan‐ongal to si Jesus, ja binonoyon indansa shi koros. ");
INSERT INTO ibl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Si Apo Shiyos, inpanbiyag tos Jesus, jet niman, inpansaad to; isonga ẃara shi apit ni kanawan nen Apo Shiyos, ja si‐katoy Pangolo tan Mengisedakan. Jet in‐aknan toy tood Israel ni ẃaya sha ja manbebawi, say omasen nen Apo Shiyos i basol sha. ");
INSERT INTO ibl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jet niman, si‐kami i mismon engasas ni maypangkep niyay ya banag; isonga peneknekan mi. Jet ẃara pay i onpaneknek so ja Ispirito Santo nen Apo Shiyos, ja in‐akan to ja man‐iyan so nonta ira toon emati son si‐kato.” Sajay i insongbat nen Pedro so nonta kangeto‐an na pari. ");
INSERT INTO ibl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jet idi intenengan ira nonta toray ni Hodiyos iyay ya inkowan nen Pedro, epaladoy bonget sha so nonta ira apostol, ja piyan sha iren bono‐en. ");
INSERT INTO ibl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nem ẃaray sakey son si‐kara ja Parisiyo ja manngeshan ni Gamaliel ja maistoro ni dinteg ni Hodiyos, ja shaka ibaingi. Dimayat shi sango‐an sha jet kowan to ey, “Pabo‐day jo nin ira.” Jet idi inpabo‐day sha nin ira sota apostol, ");
INSERT INTO ibl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","kowan to so nonta kait ton toray ey, “Si‐kayon kait kon Hodiyos, karejo iba‐ngat ja dag‐en i piyan jon dag‐en son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ta nonta bayag da, ẃaray edaga ja inges niyay. Si Tiyodas ja kowan to ey matekal ja mengi‐ibong ni gobirno, ẃaray epat ta dasos ja toon imonod son si‐kato. Nem sajay ya too, binonora, jet idi etey sota pangolo sha, nansisi‐jan ira sota totoo to, jet eg timoloy sota pangkep sha. ");
INSERT INTO ibl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Idi enshiy bayag to, ẃara mowan i i‐Galilia nonta timpo ni sinsos ja si Judas i ngaran to. Eshakel mowan i imonod son si‐kato, nem binonora met laeng, jet sota imonod son si‐kato, nansisi‐jan met laeng ira. ");
INSERT INTO ibl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Isonga no sota maypangkep ni sajay ya banag niman, bay‐iyo ira ngo, angken itoloy sha sota shaka dagdag‐a. Ta no sajay ya pangkep sha, ono shaka pandag‐a ket tooy edapo‐an to, eg onbayag, no diket ma‐omas sa shagos. ");
INSERT INTO ibl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nem no si Apo Shiyos i edapo‐an to, eg mebedin na ebaken jo ira, no diket si‐kayo et ngo mowan i ememekal son Apo Shiyos.” Jet sota inkowan nen Gamaliel, pinati ira nonta toray. ");
INSERT INTO ibl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Inpaskep sha mowan sota apostol, jet inpasepdat sha nin ira asan shaka ikowan son si‐kara ey kenshat ta eg sha ma itorotoro i maypangkep son Jesus shi totoo, asan shaka ma ira ibodos. ");
INSERT INTO ibl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jet sota ira apostol, indekjas sha ira sota esa‐nop pa toray ja ireka eman‐imdeng nga pasiya tep si Jesus i kabol ni ebebaingan sha. Ninemnem sha ey sajay i ka‐asan to ey kinosto‐an ira nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jet nontan ma, intoloy shen en nantoro ni inakew ni maypangkep son Jesus shima Timplo tan shima kebalebaley. Kowan sha ey si Jesus, si‐katoy ketongpalan nonta kowan nen Apo Shiyos nonta bayag da ey ibetkag to di ja mengisedakan. ");
INSERT INTO ibl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Idi emanshekel la pasiya sota ira emati, kepan‐ikotot nonta ira sa‐bon Hodiyos ja Grigo i esel sha sota ira koston Hodiyos. Ta sota ira Grigoy esel sha, kowan sha ey sota nankebalo son si‐kara, ediwayan ja eg ira nay‐aknan nonta mekan ja emankaiweshis ni inakew. ");
INSERT INTO ibl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Isonga sota ira apostol, sina‐nop shen emin sota emati jet say kowan sha son si‐kara, kowan sha ey, “Say obda mi, sota mengitosho ni esel nen Apo Shiyos pangkep so nen Jesus, isonga aliẃen mapteng no ibiyang mi iyay ya obda mi ja si‐kamiy mengiweshis ni mekan. ");
INSERT INTO ibl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isonga si‐kayon a‐aki mi shi pamati, pamidi kayo ni piton daleki son si‐kayo ja sajay i ẃara son si‐kara: ẃaray amtara, mapteng i shamag sha shi karakdan, tan inshalan ira ni Ispirito Santo. Jet si‐kara i maka‐amta ja mengiweshis ni mekan ni inakew. ");
INSERT INTO ibl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jet say metopog ga dag‐en mi ngo ni olay ja apostol, sota mansheẃat, tan en mengitosho nonta esel nen Apo Shiyos maypangkep so nen Jesus.” ");
INSERT INTO ibl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jet sota ira esa‐nop ja emati, piyan sha sotan ja inkowan ira nonta apostol. Jet say pinidira, si Esteban ja inshalan ni Ispirito Santo ja makedsang i pamati to, tan say eshom, si Felipe, si Prokoro, si Nikanor, si Timon, si Parminas, tan si Nicolas. Saja si Nicolas, edapod Antiok, ja aliẃen nay‐anak ka Hodiyos, nem etod‐an ja manshedjaw son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jet sota esa‐nop pa emati, inparang sha ira ja piton pinidira so nonta apostol. Jet sota ira apostol, nanshawat ira son Apo Shiyos, asan shaka isakpal i takday sha son si‐kara, jet sotan i ka‐amta‐an to ey nay‐awat sotan na obdara. ");
INSERT INTO ibl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jet nontan ma, emankaiweshis sota esel nen Apo Shiyos maypangkep son Jesus shi eshom ngon dogad, jet angken shi Jerusalem met laeng, ẃara ni olay i emankai‐shom ja emati so nonta ira sigod ja emati. Tan ẃara pay i eshakel la papashi ni Hodiyos ja emati. ");
INSERT INTO ibl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban, eshakel la banag i dingdingka to ja kaskasshaaw wa inon‐an ni totoo, ta ẃares Apo Shiyos son si‐kato ja engi‐kan ni panakabalin to. ");
INSERT INTO ibl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nem nontan, ẃara iray emekisongbati son si‐kato ja Hodiyos ja i‐Sirini i eshom, tan i‐Alejandria. Saja ira ekisongbat so nen Esteban, Hodiyos ira ja emekisa‐nop nodta sa‐nopan ni totoon istay baga‐en. Wara pay iray Hodiyos ja i‐Silisia tan i‐Asiya, ja nay‐eshom ira ngon emekisongbat son Esteban. ");
INSERT INTO ibl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nem eg sha posi‐en na songbatan sota pan‐ikowan nen Esteban tep inshalan ni Ispirito Santo nen Apo Shiyos jet sota Ispirito Santo i engi‐kan ni daing ton onsongbat son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jet say inpasing sha, nandagbo ira ni toon mengikowan ni aliẃen podno. Jet sotan na toon dinagbo‐an sha, inkowan sha ey, “Intenengan mi i inkowan nen Esteban, jet emaykontra i toka ikowan shi dinteg nen Moises, tan emaykontra pay so nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sajay i kabol la binongetan ira nonta karakdan na totoo, pati sota ira pangolo ni Hodiyos, tan sota mamaistoro ni dinteg ni Hodiyos. Dimaw ira so nen Esteban, jet inshel sha, jet inodop shen in‐ilaw so nonta ira toray ni Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jet indara di sota toon sistigo ja o‐owap i kowan sha maypangkep so nen Esteban, jet si‐karay engikowan ey, “Sajay ya too, emaykontra ni olay i toka ikokowan maypangkep niya Timplo tayo, tan dinteg tayon Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sajay i intenengan min kowan to: si Jesus kono ja i‐Nasarit, sheshalen to di ja Timplo, tan sa‐datan to kono pay ya emin i ogadi tayon tineẃid tayo so nen Moises!” ");
INSERT INTO ibl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jet emin ira sota esa‐nop ja timanongaw nodta shaka pemistigali, intekel sha si Esteban et say inpangasas sha ni dopa to, singa dopa ni anghil. ");
INSERT INTO ibl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sota kangeto‐an na pari, inbag‐an tos Esteban ja kowan to ey, “Jet agpayso noman ja inkowan mo iyay?” ");
INSERT INTO ibl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nem si Esteban, eg to sinongbatan sota salodsod, no diket say inkowan to son si‐kara, kowan to ey, “A‐akik, a‐amak, nemnem jo kari iya inpaspasing nen Apo Shiyos son si‐katejon Hodiyos manipod nonta timpon Abraham ingkato niman. Si Apo Shiyos ja Kangeto‐an, nanpa‐sas son Abraham ja apo tayo, nonta ẃara pay laeng shi Misopotamia ni eg to nin indaw shi Haran. ");
INSERT INTO ibl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Say kowan nen Apo Shiyos son si‐kato, idekjas toy pamilja to tan ili to jet ondaw shima dogad ja itorongan to so. ");
INSERT INTO ibl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jet si Abraham, indekjas to nga agpayso sota ili ton Kaldia jet dimaw ja nanbaley shi Haran. Jet idi enaksheng ja etey si ameto, inpalaw nen Apo Shiyos si Abraham shiyay ya ilin kawad‐an jo niman. ");
INSERT INTO ibl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nem si Apo Shiyos, enshin polos i to in‐akan son Abraham ja bo‐day shiyay, ja angken sanshalokap. Nem inkari to iyay ya ili son si‐kato, pati sota appo to di, ey enshiy pay laeng nin i potot nen Abraham nontan. ");
INSERT INTO ibl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tan ẃara pay i inkowan nen Apo Shiyos son Abraham, ey sota ira poli to, manbedin ira ni sa‐bo shi eshom ma ili, jet manbedin ira ni baga‐en nodtan. Jet pedigaten ira nonta sigod ja tood man ni epat ta dasos ja tawen. ");
INSERT INTO ibl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nem kowan nen Apo Shiyos ey shosa‐en to ira sotan na toon memedigat son si‐kara, jet no meksheng iyay, kowan to ey idekjas nonta poli nen Abraham sotan na ilin nandigatan sha, jet shiyay alin dogad ja kad‐an tayo i daẃan shen panshedjawan son Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Si Apo Shiyos, in‐awat to ngo eshan so nen Abraham sota ogadi ja nayngadnan ey kogit. Sajay i penginemneman sha nonta ekitodagan nen Apo Shiyos son si‐kara. Jet si Abraham, kinokit to si Isaac ja anak to nonta ẃaray piton akew to ja nay‐anak. Jet si Isaac, potot to si Jacob, jet si Jacob, sampolo tan showay potot to, jet si‐karay makapoli son si‐katejon Hodiyos. ");
INSERT INTO ibl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Sajay iren san‐a‐akin annak nen Jacob ja daleki, inepalan sha si Jose ja agi sha jet indako sha so nonta i‐Egypt. Nem si Apo Shiyos, eg to binaybay‐an si Jose, ");
INSERT INTO ibl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","no diket tinodongan to shi emin na digat to, jet in‐aknan to pay ni daing; isonga kinosto‐an nen Paro ja ari shi Egypt si Jose. Jet si Paro, shinotokan to si Jose ja gobinarol shi intiron Egypt, tan si‐katoy emengimanshal ni emin na ẃared baley nen Ari Paro. ");
INSERT INTO ibl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nontan na timpo, sota appo tayo da, ja a‐aki nen Jose, ẃara ired Kanaan, jet edigat i pengal‐an shed man ni kenen sha tep maramay bitil. Bitil met laeng shi Egypt, ");
INSERT INTO ibl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","nem ẃaray mekan na naytalod man. Isonga idi shinemag nen Jacob ey ẃaray mekan shiman, inbetkag to sota annak to ja appo tayo da ey ondaw ira shi Egypt. Jet nontan i pilmiron indaw shed man. ");
INSERT INTO ibl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Idi kapinshowa ja ondaw ira, inpa‐amta nen Jose ja mismo son si‐kara ey si‐kato si Jose ja agi sha, jet nontan ma, inamta‐an nen Ari Paro i pamilja nen Jose. ");
INSERT INTO ibl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jet si Jose, inkowan to nodta a‐aki to ey ondaw ali si Jacob ja amesha, angken pay sota pamilja to say manbonal ired Egypt. Jet say kabebilang sha, piton polo tan dima. ");
INSERT INTO ibl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jet si Jacob, shimalong shi Egypt, jet shiman i eteyan to, tan eteyan ira nonta annak to ja appo tayo da. ");
INSERT INTO ibl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nem sota bakdang sha, in‐akad shed Sikim jet shiman i naybeka‐an sha, nodta bo‐day ya tinongkal da nen Abraham so nonta anak nen Hamor. ");
INSERT INTO ibl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nem idi shanshani ma sota timpon idaw ira nonta appo tayo da shima dogad ja inkari nen Apo Shiyos son Abraham, shimakel iren pasiya shi Egypt. ");
INSERT INTO ibl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jet nontan, ẃara may naysa‐dat ja arin nantoray shi Egypt ja eg to am‐amtay mapteng den dingdingka nen Jose shi Egypt nonta epangdon akew. ");
INSERT INTO ibl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jet say inpasing to, sinaol to ira ja appo tayo da. Nga‐ngaaw i inpasing to son si‐kara, ja pinidit to ira ja mengi‐ibong ni annak sha say metey ya emin ira sota kenga‐nga‐nga. ");
INSERT INTO ibl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jet nontan na timpo, nay‐anak si Moises ja memapteng nga nga‐nga. Tedon bolan to bengat ja na‐ajowan shi baley, ");
INSERT INTO ibl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","jet idi kenshat ta i‐ibong sha ma, sota biin anak nen Ari Paro, tinekibi to ja inbilang to ey anak to. ");
INSERT INTO ibl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Inpan‐iskoida to si Moises; isonga amta ton emin i ashal shi Egypt. Edaing nga man‐a‐sel, tan sota obda to, ẃara ni olay i toka panbenagi. ");
INSERT INTO ibl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Jet idi ẃaray epat ta polon tawen to, ninemnem ton to asen iray kait ton i‐Israel. ");
INSERT INTO ibl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jet nontan, naytompong ja ẃaray inon‐an ton i‐Egypt ja epaladoy toka pesing so nonta sakey ya i‐Israel. Inbaliẃan nen Moises sota kait ton i‐Israel, jet binono to sota i‐Egypt. ");
INSERT INTO ibl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta say ẃared nemnem to, kowan to nem eẃatan ira nonta kait ton i‐Israel ey si‐katoy osalen nen Apo Shiyos ja mengisedakan son si‐kara ni shaka pandikat, nem eg sha ineẃatan. ");
INSERT INTO ibl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jet idi maykadẃen akew, ẃara mowan i inon‐an to ja showen i‐Israel ja emanbekal, jet to pineshas ja bineltak ira, ja kowan to ey, ‘Nemnem jo kari! Apay nga manbekal kayo, ket nan‐inges kayon i‐Israel?’ ");
INSERT INTO ibl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nem sota sakey ja engigepo ni bakal, si‐katoy engitolshon son Moises ja kowan to ey, ‘Sipay engikowan son si‐kam ey itorayan jokami? Sipay engikowan ey si‐kam i mengigsheng ni maypangkep son si‐kami? ");
INSERT INTO ibl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kowan mo ngo ey bono‐en mowak ja inges toy inpasing mo so nonta toon i‐Egypt nonta na‐shem?’ ");
INSERT INTO ibl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Idi intenengan nen Moises iyay, timakot jet bintikan toy Egypt. Dimaw shi dogad ja kowan sha ey Midian, jet engaseẃed man jet ẃaray showen daki ja inpotot to. ");
INSERT INTO ibl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Jet idi edabas i epat ta polon tawen, nanpa‐sas i anghil son si‐kato shi emanshedang nga ootik ka kiyew shi dogad ja nay‐esop shi shontog ga kowan sha ey Sinai. ");
INSERT INTO ibl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jet nasshaaw si Moises nonta inon‐an to iyay. En imesop, ta piyan ton asen, jet ẃaray esel nen Apo Shiyos ja intenengan to ja kowan to ey, ");
INSERT INTO ibl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Si‐kak si Apo Shiyos ja Shiyos nonta appom da, ja si Abraham, si Isaac tan si Jacob!’ Si Moises, timakot et emanbebayedbed, isonga eg to ma itoled ja ishemang sota apoy. ");
INSERT INTO ibl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jet si Apo Shiyos, kowan to son si‐kato ey, ‘Ekal mo ita sapatos mo ja si‐katoy panrispitom son si‐kak, ta sajay ya dogad, niman na kawashak shiyay, eshiyosan! ");
INSERT INTO ibl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inon‐an koy kepandikat ira ni took shi Egypt, intenengan koy shaka pannengis; isonga dimawak ali ja mengisedakan son si‐kara, ni shaka pandikat. Eti, ibetkag taka shi Egypt.’ Kowan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nonta eg pay laeng namtik si Moises shi Egypt, eg ineẃat ni kait ton i‐Israel ja inkowan sha nontan son si‐kato ey, ‘Sipay engikowan ey si‐kam i mengitoshay son si‐kami tan mengigsheng ni maypangkep son si‐kami?’ Nem si Apo Shiyos, si‐katoy engibetkag son si‐kato ja mengitoshay tan mengisedakan son si‐kara shi anongosto met laeng, isonga sota anghil ja inon‐an tod apoy nonta nan‐esel si Apo Shiyos, si‐katoy timolong son Moises, ");
INSERT INTO ibl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ja mengibo‐day ni i‐Israel shi Egypt. Jet si Moises, eshakel i kaskasshaaw wa milagro ja dingka to shi Egypt, pati nonta binediw sha sota kowan sha ey Embalengen Baybay, tan angken pay shima dogad ja shinshindan sha ni epat ta polon tawen ja enshiy balebaley. ");
INSERT INTO ibl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jet si‐kato met laeng sota si Moises ja engipadto so ni toon i‐Israel ey, ‘Waray ibetkag ali nen Apo Shiyos son si‐kayo ja mengikowan ni esel ton mismo, ja inges toy inpangibetkag to son si‐kak. Si‐katoy sakey ya poli tayo di.’ ");
INSERT INTO ibl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jet saja si Moises, si‐kato sota eki‐od‐odop so nonta i‐Israel ja appo tayo da ni inpan‐ak‐akad sha shima shinshindan sha, tan si‐kato pay i ekitbal so nonta anghil shi shontog ni Sinai ja engi‐ẃat nonta naysolat ja bilin nen Apo Shiyos son si‐kato say itawid to ngo son si‐katejo. ");
INSERT INTO ibl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nem sota appo tayo da, inbiyang sha ja eg sha pinati si Moises, jet inpa‐agpos sha et ja on‐oli ira shi Egypt. ");
INSERT INTO ibl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Isonga inkowan sha son Aaron ey mandeka et ni sinan shiyos ja mepangdo ey si‐kara, ni shaka pan‐ekad, ta kowan sha ey, ‘Si Moises ja engibo‐day son si‐katejo shi Egypt, ebayag met ded ma shontog; taẃey nem toway dinaẃan to.’ ");
INSERT INTO ibl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jet nontan ma, nandaga ira ni sinan shiyos sha, ja singa baka i itsora to, jet si‐katoy in‐aknan sha so ni daton sha; nandaladsak pay ira ni shayaw sha so nontan na dingkaren sinan shiyos sha. ");
INSERT INTO ibl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nem si Apo Shiyos, binay‐an to ira ja angken manshedjaw ira ni talaw. Sajay i inkowan ni padto nonta bayag da ja esel nen Apo Shiyos ey, ‘Si‐kayon toon i‐Israel, aliẃen si‐kak i in‐aknan jo so nonta animal ja pinadtiyo tan eshom ma daton jo, ni kawashayo shima nan‐ak‐akshan jo ni epat ta polon tawen. ");
INSERT INTO ibl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sota tolsha ja kampo ni sinan shiyos jo ja kowan sha ey Molok ja joka ita‐ta‐jon, tan si Ripan ja sinan shiyos jo ja talaw, sajay iren dingkayo, si‐katoy kabol la indawan takejo so shi araẃin dogad ja dabsan jo pay i Babilonia.’ Kowan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Idi dimabas i pigen tawen da, nandaga ira sota appo tayo da ni kampo ja tolsha ja panshedjawan sha son Apo Shiyos nonta nan‐aka‐akad ired ma dogad ja enshiy balebaley. Jet inonod shen dingka sota intoro nen Apo Shiyos son Moises ey dag‐en sha. ");
INSERT INTO ibl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jet sota annak sha i imelbat so nontan na tolsha ja kampo, jet sinaksakbat sha ni inpakidaw sha son Josue ni inpiliw sha so nonta ili ira nonta enshiy Shiyos sha ni inshagshag so nen Apo Shiyos son si‐kara. Jet sajay ya tolsha, ẃara ingkato nonta inpan‐ari nen David. ");
INSERT INTO ibl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jet si David, kinosto‐an nen Apo Shiyos, jet enangshaw son Apo Shiyos ni palobos to ja mandeka ni Timplo ja baley nen Apo Shiyos, ja Shiyos ni Israel. ");
INSERT INTO ibl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nem say dimaga niyay ya Timplo nen Apo Shiyos, si Solomon, ja anak nen David. ");
INSERT INTO ibl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nem si Apo Shiyos ja Kangeto‐an, eg man‐iyan shi baley ya dingka ni too, jet angken sota para padto, inkowan sha iyay ya esel nen Apo Shiyos ey, ");
INSERT INTO ibl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Say dangit, si‐katoy naka tongawi, jet say dobong, si‐katoy kaketketini ni shapan ko; isonga angken nganton kalasin baley ya dag‐en jo para son si‐kak ja kowan jo ey pan‐inan ko, eg mansilbi. ");
INSERT INTO ibl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta emin ira ja ẃaren ma‐esas, si‐kak i pimalsowa so.’ Kowan nen Apo Shiyos.” ");
INSERT INTO ibl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jet si Esteban, intoloy to ja kowan to so ira nonta esa‐nop pa toray ni Hodiyos ey, “Epalado kayo, etangken i toktok jo! En‐asneng jon itenengan i bilin nen Apo Shiyos! Nay‐inges kayo met laeng so ira nonta appoyo la, ja eg jo kosto ni olay ja ishalan shakejo ni Ispirito Santo! ");
INSERT INTO ibl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sipay amtayo ja para padto nen Apo Shiyos nonta bayag da ja eg pinedigat ni appoyo? Enshiy sha binaybay‐an! Binonoren emin ira sota engipadto nonta bayag da ey ẃaray ibetkag ali nen Apo Shiyos ja mengisedakan! Jet idi nay‐agpayso sota padto ni indaw ali nen Cristo, si‐kato sota inpa‐shel jo jet inpabonoyo, ey enshiy basol to. ");
INSERT INTO ibl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Si‐kayo i engawat nonta bilin nen Apo Shiyos ja in‐awat ni anghil so nen Moises, nem eg jo pinati!” Sajay day inkowan nen Esteban son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jet idi intenengan ira nonta toray ni Hodiyos sota inkowan nen Esteban, dimeshang ira ja emanngedetnget i sangi sha ni bonget sha son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nem si Esteban ja inshalan ni Ispirito Santo, timangkak shi dangit jet inon‐an toy emenenilin edapo son Apo Shiyos, tan inon‐an to pay si Jesucristo ja dimayat shi apit ni kanawan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jet kowan to ey, “Tangkak kayo! Inon‐an kon edo‐katan i dangit, jet sota kowan sha ey Anak ni Too, dimayat shi apit ni kanawan nen Apo Shiyos!” ");
INSERT INTO ibl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nem sota ira toray ni Hodiyos, inopop sha et i tangidara, ja ireka mankeljaw, jet bintik shen shagos si Esteban. ");
INSERT INTO ibl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Inbo‐day sha nodta ili jet nan‐a‐atangan shen kineskespigan ni bato. Jet sota ira engikowan ni kowan sha ey basol nen Esteban, si‐kara i epangdon engikespig ni bato son si‐kato. Jet sota ira engespig, insepara sota ta‐kep ni baro sha shi sango‐an nonta balodaki ja manngeshan ni Saulo, ja kowan sha ey bantayan to. ");
INSERT INTO ibl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nonta marama ja shaka pankespigi ni bato si Esteban, nanshawat, ja kowan to ey, “Apo Jesus, awat mo ngo iya biyag ko.” ");
INSERT INTO ibl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nantalimokod jet inkedsang toy shawat to ja kowan to pay ey, “Apo, pakaẃanim ira jay ya totoo ni sajay ya dingkara son si‐kak.” Sajay i shawat to asan matey mala. ");
INSERT INTO ibl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Si Saulo i sakey ya makapiyan ey angken bono‐en sha si Esteban. Nontan na timpo, epaladoy shaka pesing so nonta ira emati shi Jerusalem, isonga ebokal ira ja nayẃaris shi emin na ili ni Jodia, tan shi Samaria, nem sota ira apostol, si‐kara bengat i ebay‐an ja eg nansisi‐jan. ");
INSERT INTO ibl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nem ẃaray eshom ma ebay‐an ja makedsang i pamatira, jet si‐kara i en engibka so nen Esteban. Epaladoy shaka pannengis ni daringit sha pangkep son si‐kato. ");
INSERT INTO ibl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jet si Saulo, pinedigat ton pasiya sota emati son Cristo; toka solsolsola pay i kebalebaley ja toka pan‐a‐shela ira sota emati son Jesus ja daleki, angken pay sota ira bibii. Jet toka pan‐ibalod ira. ");
INSERT INTO ibl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jet sota ira emati ja nayẃaris, dimaw iren en mengitosho ni esel nen Apo Shiyos ni maypangkep so nen Jesus shi emin na dinaẃan sha. ");
INSERT INTO ibl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jet si Felipe, dimaw shi siyodad ni Samaria ja to itoro i maypangkep so nen Jesus. Intoro to ey si Jesus sota tongpal nonta padto nonta bayag da ey mengisedakan ali. ");
INSERT INTO ibl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jet sota totood man, nansaksakey iren dimaw so nen Felipe, ta pipiyan shen itenengan i toka pan‐itoro. Tan say sakey pay ja pinati‐an sha so nen Felipe, inon‐an shay eshakel la dingdingka tod man ja milagro. ");
INSERT INTO ibl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Angken sota ira dimonyo ja pimeket so nonta ira totoon inpan‐angaw sha, bimetik ira, ja ireka pay emankeljaw. Angken sota ira toon emanpansekit ja eg makakeykey i bakdang sha, tan sota ira epilay, ja eg man‐ekad, mimapteng ma ira. ");
INSERT INTO ibl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jet nontan, ebadeg i imdeng ni totood Samaria ni sajay ya edaga son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nodtan na dogad, ẃaray toon manngeshan ni Simon ja emanmantala. Toka idastog i bakdang to ey kangeto‐an, jet nasshaaw ira sota tood Samaria nonta toka dagdag‐a. ");
INSERT INTO ibl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jet emin sota totoo nodtan na ili, manshoki shi kabeba‐an ingkatod kangeto‐an, shaka noman pati‐a, jet kowan sha pay ey si‐katoy in‐aknan nen Apo Shiyos ni takal, jet eshamag ey asdeg toy panakabalin to. ");
INSERT INTO ibl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jet eshakel noman i istay emati son si‐kato, ta inon‐on‐an sha ni ebayag i toka panmantala et ireka messhaaw wa pasiya. ");
INSERT INTO ibl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nem idi emati ira sota i‐Samaria nonta toro nen Felipe maypangkep ni pantoshayan nen Apo Shiyos, tan maypangkep son Jesucristo, nanpabonjag ira sota daleki tan sota ira bibii. ");
INSERT INTO ibl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jet angken si Simon ja emanmantala, emati ngo nonta toro nen Felipe, jet nanpabonjag ngo. Jet eki‐od‐odop ni olay so nen Felipe. Jet idi inon‐an toy kaskasshaaw wa kedagdag‐a nen Felipe, nasshaaw et ngo mowan na pasiya. ");
INSERT INTO ibl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jet sota ira apostol ja ẃared Jerusalem, idi inamta‐an sha ey ineẃat ni i‐Samaria i esel nen Apo Shiyos maypangkep so nen Jesucristo, inbetkag sha si Pedro nen Juan shi Samaria. ");
INSERT INTO ibl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jet idi mimotok ira, inshawat sha son Apo Shiyos ey sota emati shi Samaria ket eẃaten sha koma ngo i Ispirito Santo nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta nontan, enshi pay nin i Ispirito Santo ja nan‐iyan so ni angken sakey son si‐kara; ebonjagan bengat ira ja si‐katoy ka‐asan to ey too ma ira nen Apo Jesucristo. ");
INSERT INTO ibl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Idi naksheng nga nanshawat si Pedro nen Juan, insakpal shay takday sha so nonta ira emati ja i‐Samaria, jet ineẃat sha ngo sota Ispirito Santo nen Apo Shiyos ja nan‐iyan son si‐kara. ");
INSERT INTO ibl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jet si Simon ja istay manmantala, idi inon‐an ton ineẃat ira nonta emati ja i‐Samaria i Ispirito Santo nen Apo Shiyos nonta insakpal nen Pedro nen Juan i takday sha son si‐kara, toka pan‐i‐akni ira ja apostol ni pilak, ");
INSERT INTO ibl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ja kowan to ey i‐aknan sha ngo ni inges nonta panakabalin nen Apo Shiyos ja ẃara son si‐kara, say no isakpal toy takday to ngo so ni angken sipa, eẃaten shay Ispirito Santo. ");
INSERT INTO ibl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nem si Pedro simongbat ja kowan to ey, “Say torong mo, impiyarno, jet angken ita‐jon mo ngo ta pilak mo! Ta intopom ita nemnem mo, ja kowan mo ey metongkal ni pilak sota panakabalin nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Enshiy mo kaybiyangan, ono bingay mo, shi pamati mi, ta sota ẃared nemnem mo, aliẃen sota piyan nen Apo Shiyos. ");
INSERT INTO ibl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Panbebawi ka nita kakedsel mo, panshawat ka et son Apo Shiyos; balang nem pekawanan toka nita ngaaw wa pangkep mo. ");
INSERT INTO ibl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta naka eẃati ey tinngel toka pay laeng ni basol, jet no eg ka manbebawi, da‐kaman mo aliy digat ta empait.” ");
INSERT INTO ibl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jet inkowan nen Simon so nen Pedro ey, “Pangaasim, ireẃat mo son Apo Shiyos ey sota inkowan mo, enshi komay angken sakey ya mepesamak ali son si‐kak!” ");
INSERT INTO ibl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jet idi naksheng nga inkowan shay maypangkep so nen Jesucristo shiyay ya dogad, nay‐oli mowan shi Pedro nen Juan shi Jerusalem. Jet sota mapteng nga shamag maypangkep so nen Jesucristo, intoro sha ngo shi emin na nanshandan shen dogad shi Samaria. ");
INSERT INTO ibl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nem si Felipe, intorong ni anghil ey pepsawen to sota kalsaren edapod Jerusalem ja menedong shi Gasa. Sajay ya kalsara, kamag‐an i binedasat to, enshiy balbaley. ");
INSERT INTO ibl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jet siya, inonod ton pimesaw, jet ẃaray simbi ton too nodtan na kalsara ja i‐Itiopia. Sajay ya too, epateg ja opisiyal nonta bii ja ari ni Itiopia, ja kowan sha ey Kandis, ta sajay ya too, toka pan‐imanshal sota kokowa nonta apo ton si Kandis. Edapo ali jay ya opisiyal shi Jerusalem. Shiman i to nanshayawan son Apo Shiyos, ");
INSERT INTO ibl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","jet on‐oli ma shi ili ton Itiopia, ja nandogan shi kalisa. Naytompong nontan ja emanbasa nodta naysolatan ni padto nen Isaias. ");
INSERT INTO ibl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jet si Felipe, inshalan ni Ispirito Santo nen Apo Shiyos ja en mekilokan son si‐kato nodta kalisa. ");
INSERT INTO ibl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Isonga si Felipe, kinano‐an ton en nay‐askang nodta kalisa, jet intenengan ton panbasa‐a nonta opisiyal sota padto nen Isaias. Si Felipe, inbag‐an to nem toka eẃati sota toka panbasa‐a. ");
INSERT INTO ibl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jet sota opisiyal, kowan to ey, “Enshi, ekak eẃatan. Mesepol la ẃaray mengi‐odog son si‐kak ni olog to.” Jet ineẃis tos Felipe ja mekilokan nodta kalisa to. ");
INSERT INTO ibl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Say toka panbasa‐a nontan, sajay: “Si‐kato, may‐eshig ey inges to sota kalniro ja shinonshon shen padti‐en sha ja eg onpokeng; inges to pay sota kalniron toka i‐onod i bakdang ton pokisan sha ja eg onkenga. Apay simongbat? Enshi, angken pinsak. ");
INSERT INTO ibl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Inbaba shay kasesaad ton pasiya ja eg sha in‐aknan ni ẃaya ton onsongbat ni inbistigal sha so. Sipay makabaal la menonton ni ap‐apo to ali? Kenshat ta enshi ma, tep say biyag to, enshi med ja dobong.” Kowan nonta solat. ");
INSERT INTO ibl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jet sota opisiyal, kowan to so nen Felipe ey, “Ikowan mo ga son si‐kak no sipay kaytoshongan niya kowan ni padto — si‐kato met laeng nga para padto, ono ẃaray eshom?” ");
INSERT INTO ibl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jet si Felipe, in‐olog to iya padto nen Isaias, ey si Jesus i kaytoshongan to, tan intoro to pay son si‐kato i mapteng nga shamag maypangkep so nen Jesus. ");
INSERT INTO ibl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Jet idi maramen ireka manshedong nodta kalsara, simbira sota dogad ja ẃaray shanom, jet kowan nonta opisiyal ey, “Iyay i shanom shiyay. Mebedin ngaten mebonjaganak niman shiyay?” ");
INSERT INTO ibl_vpl