﻿USE sofia;
DROP TABLE IF EXISTS sofia.ian_vpl;
CREATE TABLE ian_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ian_vpl WRITE;
INSERT INTO ian_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Kraistna yelangɨmba la nɨmba kɨndɨ kiyandi. Jisasna yelangɨna njambwi nyan Devit. Devitna ngwak tamba la nyan Ebraham. ");
INSERT INTO ian_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebrahamna nyan Aisak. Aisakna nyan Jekop. Jekopna nyan Judo ndɨna yakwa nɨmbonala. ");
INSERT INTO ian_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judana nyan Peresogwi Saro. Mbɨla nyimena sɨ Tema. Peresna nyan Hesron. Hesrona nyan Ram. ");
INSERT INTO ian_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramna nyan Aminadap. Aminadapna nyan Nason. Nasona nyan Salmon. ");
INSERT INTO ian_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmona nyan Boas. Boasna nyɨmena sɨ Rehap. Boasna nyan Obet. Obetna nyɨmena sɨ Rut. Obetna nyan Jesi. ");
INSERT INTO ian_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesina nyan Devit. Devitna tamba la nyambwi kinga. Devitna nyan Solomon. Solomona nyɨme tat nat nyan kla lat taagwat. Lɨ kat tat kla la nyan sɨ Yuraia. ");
INSERT INTO ian_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona nyan Riaboam. Riaboamna nyan Abaisa. Abaisana nyan Esa. ");
INSERT INTO ian_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esana nyan Jihosafat. Jihosafatna nyan Joram. Joramna nyan Asaia. ");
INSERT INTO ian_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaiana nyan Jotam. Jotamna nyan Ehas. Ehasna nyan Hesekaia. ");
INSERT INTO ian_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiana nyan Manasa. Manasana nyan Emos. Emosna nyan Josaia. ");
INSERT INTO ian_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiana nyan Jekonaio ndɨna yakwa nɨmbonala. Josaia ta njɨmbla Juda walɨnja nɨmba kat kandi kwutaa Bebilonat kalindi. ");
INSERT INTO ian_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kandi kwutaa kalindi maa Jekonaia nyan njandɨ. Ndɨna nyana sɨ Sialtiel. Sialtielna nyan Serababel. ");
INSERT INTO ian_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababelna nyan Abaiat. Abaiatna nyan Elaiakim. Elaiakimna nyan Eso. ");
INSERT INTO ian_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esona nyan Sedok. Sedokna nyan Ekim. Ekimna nyan Elaiat. ");
INSERT INTO ian_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiatna nyan Eliesa. Eliesana nyan Matan. Matana nyan Jekop. ");
INSERT INTO ian_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jokopna nyan Josep. Josep ndɨ Mariana lana. Maria lɨ Jisasna nyimeak. Jisas Juda kat kwunapmak kat Juda kawiga lɨnja nyana. Ndɨ ndina Kraistna. ");
INSERT INTO ian_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Devitna yelangɨmba la nɨmba ndɨna ngwak walanga taamba vɨli kiyeli aynat mbaapmamba la nɨimba ndi. Taamba vɨli kiyeli aynat wan nyan Ebraham. Isrel kat kandi kwutaa Bebilonat kalinja njɨmbla ta nɨmbana yelangɨ nɨmba ndina ngwak walanga taamba vɨli kiyeli aynat mbaapmamba la nɨmba ndi. Taamba vɨli kiyeli aynat wan nyan Devit. Kraistna yelangɨmba la nɨmba ndɨna ngwak walanga taamba vɨli kiyeli aynat mbaapmamba la nɨmba ndi. Taamba vɨli kiyeli anyat wan nyan kandi kwutaa kalinja njɨmbla ta nyana. ");
INSERT INTO ian_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria Jisas Kraist kat kwukna vak kɨngiyan. Josep ngangɨtnya mɨna kwutndɨ, kwo yetɨlɨ. Lɨla ngway ana tologa yetɨndɨ. Godna waagqan lɨla yapmba nondanyan kwutnjan ngwandɨndɨ maa nyan tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep lɨ kat klandangat kwusɨsɨvanja nyan apma nyan tagula nyana. Nyan tɨla vak kat vɨlaa nat nɨmba kat mbupmak kat kai waa makasɨgɨt yetɨndɨ. Kat kiya waweyan Maria wutaa wup yigiyalɨ waa yelavɨka yetɨndɨ. Wupma yivak kat kai waa yelavɨka yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Maawupmba yelavɨka yetɨga sɨndu kwandɨ, njambwi nyana ensel sɨmapmba ndɨ kat yaa wandɨ. “Josep mɨn Devɨtna yelangɨ nayan mɨn. Maria kat klavak kat ke kai waga. Lɨla yapmba lɨga nondanyan nat nduna nyan ana ndɨ. Godna waagan kwutnjangwanda nyana tɨga. ");
INSERT INTO ian_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nondanyan kwutɨ maa ndɨna sɨ Jisas waigamɨn. Ndɨna mbaapmamba lɨga nɨmba yilɨnja kavle vak kat sɨlɨmbwigiyandɨ. Ngi kat tɨga ndɨna sɨ Jisas waigamɨn” waa wandɨ Ensel. ");
INSERT INTO ian_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","God tamba la profet kat wandɨ maa Maria Jisas kat kwuta vak lavu nyingamba pɨlɨwutndi. Mat mwunya wiya nyan ngɨni nondayan kwukiyalw. Wan nyana sɨ Emanyuel. Wan sɨna angwa kɨngiyan. God nɨnogwinala lɨgandɨ, waa tamba pɨlɨwutndi. Kan vak Maria Jisas kat kwutaa vak tamba profet pɨlɨwukna vak vla tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep sɨmak valaa laatndɨ. Sɨmak vɨlaa laataa Maria kat kai walɨnda vak kat kwagalalaa lɨ kat klandɨ. ");
INSERT INTO ian_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ana lɨ kat nyway tologa yetɨndɨ. Kwo lɨga nyan tɨga nyan kwutɨ. Kwutɨ maa Josep ndɨna sɨ Jisas waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Betlehem walɨnja ngepmamba tɨga Jisas kat kwutɨ. Judia walɨnja kɨpmamba la ngepma Betlehem. Ndɨ kat kwuta njɨmbla ndina King Herot ta njɨmbla. Samat tɨga nya woke la kavamba la nambuo la nɨmba sɨngwut wogwela lɨndɨ, vɨgɨva Jerusalemat yandi. ");
INSERT INTO ian_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yalaa wagalandi. Juda kat kat njuambwi nyan tɨvat ya mat nyan andamba lɨgandɨ. Nya woke lɨga kavamba la nɨmba nɨn. Ndɨnɨ sɨ kwutaa katsovak yanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot wanja vak kat wutaa ngɨpaliga ndandɨ. Jerusalemba la nat nɨma sakwat nɨmba wan nyaangɨt wutaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngi kat tɨga Herot wandɨ maa God kat kwunata njambwi nɨmbagwi Moses kwiya nyaangɨt sɨmogwi la nɨmbo kɨta yisolaa lɨndi maa Herot ndi kat wagalandɨ. Juda kat kwunapmak yaiga nyan ndina Kraist anda ngepmamba yalaa lɨga laakiyandɨ waa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wagalandɨ maa ngepmamba yalaa lɨga laakiyandɨ waa tamba la profet waga ");
INSERT INTO ian_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","7","God wandɨ maa tamba pɨlɨwutnda lavu nyinga kwutaa vɨga mbutndi Juda walɨna kɨpmamba la Betlehem walɨna ngepma mat sandɨ ngepma ana ndɨ. Nat kavamba lɨga angwa ngepma wan ngepma kat ana kwula kiyandɨ. Wuna nɨmba Iarel ndi kat vɨga lɨgiyaa nyan ndina njambwi nyan wan ngepmamba yalaa lɨga laataa ndi kat vɨga lɨgiyandɨ waa wandɨ God, waa pɨlɨwutndi tamba la profet vɨlaa kavamba la nɨmba kat Herot yagwa wandɨ maa yand. Yandi maa ndi kat wagalandɨ. Vɨngwa sɨngwut anda njɨmbla wogwelaa lɨndɨ, vɨngwuk waa wagalandɨ ndi kat. ");
INSERT INTO ian_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mbutndi maa wutaa ndi kat wandɨ. Betlehemat ay ngwula. Sɨngwut kat vɨlaa wutaa yagwa mat nyan kat yiga vɨlaa wun kat yaa mbupmba ngwuk. Wuno ndɨ kat yiga vɨlaa ndɨna sɨ kwutaa katsovak kat wowun waa ndi kat woseka wandɨ Herot. ");
INSERT INTO ian_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herotna nyaangɨt wutaa wogwelaa ngepmamba lɨga vɨnja sɨngwut wogwelaa lɨndɨ maa vɨgɨva yindi. Sɨngwut yilɨndɨ, vɨgɨva sɨngwut yila vla yilɨndi. Ndɨ kat vɨgɨva yilɨndi maa mat nyan ta ngay sɨsomba yiga tamata lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sɨngwut mat nyan ta ngay sɨsomba tamata lɨnda vak vɨlaa apma maawut yelavɨka solat sɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngay wuleilaa wan mat nyan nyime Marionala tɨndɨ, vɨndi. Vɨlaa kwali mamba sɨla nambu sɨlandalaa ndɨna sɨ kwutaa katsondi. Ndina yimbwimba la nda ndɨ kat kwivat kiyanja nda walɨnja kapa ndɨ kat windi. Apma njangu veila mbaw ndɨ kat kwind. Apma njangu velɨga ngwaak ndɨ kat kwindi. ");
INSERT INTO ian_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kwindi maa vɨga kava ke yiga ndɨ kat sɨmapmba mbutndɨ. Herot tɨga kava ke yiga ndɨ kat mbuka waa sɨmapmba ndi kat wandɨ God. Ngi kat tɨga yanja yambɨ kwagalalaa nat ava yambɨmba yindi ngepma. ");
INSERT INTO ian_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yindi maa njambwi nyana ensel Josep kat sɨmapmba ngan wandɨ. Laataa nyan taagwa kwuka. Isipmat vaaka kwiyatapman ay ngwula. Yiga tɨmɨn mala at mɨn kat ngɨni waigowun. Herot mɨna mat nyan kat vatnyavak kwatɨgandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep ngan laataa nyan nyɨme kat kwutaa vaaka kwiyatapman Isipmat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Isipmba yiga yetɨndɨ, Herot kiyandɨ. Wan Isipmat yinja vak kwo ana yindi. Tamba God wandɨ maa profet pɨlɨwukna vak vla yindi. God wandɨ, wuna nyan Isipmba yiga lɨndɨ, ndɨ kat ngɨni wowun maa lungwamataa yaigandi waa wandi God waa tamba la profet pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nya woke la kavamba tɨga ya nɨmba ngɨni lungwamataa yiga Herot kat ana vɨndi. Herot ndɨ yelavɨtndɨ. Ndi ana yaigandi. Wun kat woseka wandi waa yelavɨtaa nyingi maawut yelavɨka lɨndɨ. Ngi kat tɨga Herot wandɨ maa ndɨna soldia Betlehemat mat nondanyangu kat vatnyavat yindi. Tat nya woke la kavamba tɨga ya nɨmba ndɨ kat wandɨ. Ndɨmwe vɨlɨlɨk tɨgiya nondangangu kat aywaa kwutaa vatnyamba ngwuk wandɨ. Wandɨ maa wutaa yiga aywaa vatnyandi. ");
INSERT INTO ian_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vatnyanja vak kat tamba la proget Jeremaia lava nyingamba tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama valɨnja ngepmamba la nɨmba nɨma kɨndɨgɨn wutndi. Nɨma vak nyangu kat nglalɨnja kwundi wutndi. Resel lɨla nyangu kat nglalɨlɨ. Yelavɨka nglalɨla maawut kat ana alɨpsɨga kwunakiyandi. Lɨla nyangu kat aywaa sɨndi, kiyandi waa tamba la profet pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot wundumbu ya vak kat Godna ensel Josep kat sɨmapmba mbutndɨ. Josep Isipmba lɨndɨ, mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Laataa mɨna nyan taagwa kat kwutaa lungwamataa Isrelat ay ngwula. Mɨna mat nyan vatnyavat ta nɨmba tamba wundumbu yindi waa mbutndɨ ensel. ");
INSERT INTO ian_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mbutndɨ maa wutaa laataa nyan taagwa kat kwutaa laataa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Akeleas ndɨna nyaek Herot ta njɨvwa klalaa tɨndɨ. Ndɨ Judia walɨnja kɨpmamba la kinga. King tɨnda vak kat Josep wutaa Judiamba yiga yetɨvak kat vaaka lɨndɨ. Vaaka yiga galili walɨnja kɨpmamba lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galili yilaa Nasaret walɨnja ngepma yiga yetɨndi. Kwo ana yindi. Jisas Nasaretmba yetɨnda vak kat tamba la profet pɨlɨwutndi Jisas ndɨ Nasaret nyana waa waigandi waa tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wan njɨmbla ngu yagula Jon Judiana nat kava ndɨnyangu lapma kavamba yalaa nyaangɨt mbutɨndɨ. Mbuka wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kavle vat yiga yetɨlɨngwa vak ngwuk kwagala ngwula. God nɨn kat vɨga lɨgiya njɨmbla tamba yaa ngway tolagandɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tamba la profet Aisaia pɨlɨwutnda nyaangɨt Jon kat pɨlɨwutndɨ. Ndinyangu lapman kavamba lɨga kɨta nyan laataa nɨma kwundimba nyaangɨt mbutɨgandɨ. Njambwi nyan yaiga yambɨ kat ngwut kwunak ngwula. Nɨn kat yandeya yambɨ agwuk ngwula waa mbutɨgandɨ waa pɨlɨwutndɨ tamba la profet Aisaia. ");
INSERT INTO ian_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon kamelna yuwimba kwutnja waavwimba kwusondɨ. Ndɨna yipmamba sɨmbɨmba sɨtndɨ. Ndɨ kwapɨmba la nda wakalavio wanyanyevina ngumba kɨga lwndɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalemba la nɨmba Judiana ngepma ngepmamba la nɨimb ndɨ kat vɨvat yalɨndi. Jodan walɨnja ndandangɨ ngwaymba lɨga negpma ndino ndɨnai la kavat yalɨndi. ");
INSERT INTO ian_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kavle savle yetɨlɨnja vak ndɨ kat mbuka kavle vat yinɨn waa wandi maa Jodan walɨnja ngumba ndi kat ngu yagundɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ferisi valɨnja mbaapmamba la nɨmbo Sadyusi walɨnja mbaapmamba la nɨmbo ndɨnai la kavat yalwndi ngu yagundangat. Ndi Judana njambwi nɨimba ndi. Jon ndi kat vɨlaa wandɨ. Ngwuk kavle vat yiga yetɨlɨga nɨmba ngwuk. Ngwuk kamboyna nyangu vla lɨgangwuk. Ngwuk manda kat wuna lak yangwuk. God ngɨni ndinyangu kat sɨndeya vak ngwuk ana kwagalagiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wuna lak ke yangwa. Tak yiga apma njɨvwa kwuka yetɨ ngwula. Wupma yetɨngweyan nat nɨimb vɨlaa vaigandi. Ndi kavle vak yetɨlɨnja vak tamba kwagalandi waa waigandi. ");
INSERT INTO ian_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ngwuk kupma walɨgangwuk. Nɨn apma nɨmba nɨn. Nɨna ngwak Ebraham tamba la nyana waa walɨgangwuk. Walɨngwa vak ana nglaatndɨ. Ngwuk kavle nɨmba ngwuk. Ebrahamna yelangɨmba la nɨmba yetɨlwnja vla ana yetɨlɨgangwuk. Kavle savle yetɨlɨngwa vak kat vɨlaa God kan kɨpmamba lɨga vɨlɨngwa kambak klalaa ndu lagwa kwutaa Ebrahamna yelangɨmba taagandeyan wovuna. Ngwuk kat kai waw kwagalalaa kambapmba mandɨt nɨmba kwutaa ngwulai lɨga yelangɨmba taagandeyan nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yaiga nyan kula kwutaa lɨga nyan vla lɨgandɨ. Mi angwamba vɨkiyandɨ. Apma mi sɨk kwalapma yigiya mi vɨtaa yamba laagagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngwut kavle maawut kwanalalaa apma maawut yelavɨka lɨngwuk maa ngwuk kat kwutaa ngu yagulɨowun. Wuna kwupmba yaiga nyan ndɨ ngwuk kat Godna waagan kwigiyandɨ. Ngwula kavle vat yiga yetɨlɨngwa vak kat yamba laagandɨ, vɨkiyandɨ. Wuna kwupmba yaiga nyan wuna njambwi nyana. Ndɨna man su wun ana alɨpɨiga kwutaa kalɨgiyowun. Wun mat nyan wun. Ndɨna njɨvwa kwupmak kat wup yiga lɨgowun. ");
INSERT INTO ian_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kavle yuwi sɨk yamba yaagilɨnja vak vla ndɨno kavle nɨimba kat kwutaa ya vɨtɨga kavamba yaagigiyandɨ. Wan kavamba vɨtɨga ya ana ngɨlɨgiyandɨ. Apma yuwi sɨk klalaa ngaymba yisoga taaga lɨnja vak vla ndɨno wupma apma vak tɨga nɨmba kat kwutaa ndɨna ngaymba laagagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisas Galilimba lɨga Jotan walɨnja ndandangɨ ngu la kavat yindɨ. Jon ndɨ kat ngu yagundangat Jisas yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yalɨnda vak kat vɨga wutaa Jon Jisas kat wandɨ. Manda kat mɨn kat ngu yaguwangat wun kat yamɨn. Wun kat ngu yagumeya vat wovena wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas ndɨ kat wandɨ. Kiat walaa wama vapmba wutaa wun kat ngu yagugiyamɨn. Wupma yimangat God woviyaguga lɨgandɨ was wandɨ maa wutaa Jon kiyak walaa tɨga lɨga wandɨ. Kwowa wameya vat tamba wulowun. Mɨn kat ngu yagugiyowun waa wandi Jon. ");
INSERT INTO ian_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ndɨ kat ngu yagundɨ maa ngu yagulas nɨmbak wokendɨ. Wokendɨ maa nyinangwuk mbɨlɨndɨ, Godna waagan namiyo vla Jisas ta sɨsomba ngaga yandɨ. ");
INSERT INTO ian_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ngaga yalaa tɨndɨ maa nyinangwupmba lɨga kwundi wandɨ. Wan nyan wuna nyana. Ndɨ kat vɨlaa woviyaguga solat sɨlɨgowun waa nyinangwupmba lɨga kwundi wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Godna waagan wandɨ maa Jisas ndinyangu lapman kavat yindɨ. Seten ndɨ kat kavle vat ay mɨla wavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngan ndumi vɨli nandinya ndumi vɨli kɨgɨnda lapman kwo lɨndɨ. Ngi kat gɨga wundɨ kat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tɨndɨ, Seten ndɨ kat vɨlaa yalaa wandɨ. Mɨn Godna nyanat tɨmeyan wamɨn maa vɨga lɨma kambak bretnat tɨgiyandɨ, waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wandɨ maa wutaa Jisas wandɨ. God waa nyaangɨt tamba pɨlɨwutndi. Kupma pɨlɨwutndi. Kɨta nyan bret-nao kɨvak mɨna yelavɨk lɨndeyan ana nglaatndɨ aywaa wupmak yelavɨk kɨndeyan wan apma vala. God waa nyaangɨt kan nɨma nda. waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Seten Jisas kat kwutaa Judana angwa ngepma Jerusalemat kalindɨ. Kaliga yiga God kat kwunatɨnja ngayna sambangemba taagandɨ, lɨndɨ. Taagalaa Seten ndɨ kat wandɨ. Godna nyanat tɨmeyan laataa kɨpmat vasaseli. God waa nyaangɨt tamba pɨlɨwutndi God ndɨ ensel kat wandɨ maa mɨn kat vɨga lɨgiyandi. Ana kavble yigiyamɨn. Mɨn kat pwegwukiyandi. Ngi kat tɨga mɨna mbangɨ ana kavle yigiyandɨ. Kwo lɨgiyamɨn waa tamba pɨlɨwutndi waa wandɨi Seten. ");
INSERT INTO ian_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas ndɨ kat wandɨ. God wandɨ, tamba pɨlɨwutnja nat nyaangɨt ngi lɨga. God mɨna njambwi nyana ndɨ kat kavle vat ay waa ke waa waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seten Jisas kat kwutaa woke lɨmbwilaa lan nambu nduwiat kalindɨ. Kalilaa kɨpmamba la nda kɨpmana nɨmba aywaa ndɨ kat sɨmogwindɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sɨmogwilaa wandɨ. Kwali mamba sɨlaa nambu sɨlandalaa wuna sɨ kwutaa katsomeyan wan kɨpmamba lɨndɨ, vɨlɨma nda aywaa mɨna lak kwigiyowun wandɨ Seten. ");
INSERT INTO ian_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wandɨ maa Jisas wandɨ. Mɨn Seten wun kat kwagalalaa ay mɨla. God waa nyaangɨt tamba kupma pɨlɨwutndi. Njambwi nyan Godna sɨ mɨna kwutaa katso ngwula. Nat nyan kai. God kɨta lɨgandɨ waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wandɨ maa Seten tɨnda kava kwagalalaa yindɨ. Yindɨ maa Godna ensel yalaa Jisas kat kwunatndi. ");
INSERT INTO ian_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngu yagu la Jon kat kwutaa kalabusmba laaganja vak kat Jisas wutaa Galili kwagalalaa Kapaneamat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndɨna angwa ngepma Nasaretmba ana lɨndɨ. Yinda ngepma Kapaneam Galili walɨnja sak ngwaymba lɨndɨ. Wan kɨpma Sebyulan waa Naftalai walɨnja kwpma. ");
INSERT INTO ian_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kan kava kwo ana yindɨ. Tamba la profet Aisaia pɨlɨwuta vak vla yindɨ. Tamba kupma pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebyulan walɨnja kɨpma, Naftalai walɨnja kɨpma, Galili walɨnja sak waymba lɨga kɨpma. Jodan walɨnja ndandangɨ nat naangɨmba lɨga kɨpma. Juda ana ndi Judagwi ndina wava lɨga kayana kɨpma. ");
INSERT INTO ian_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wan kɨpmamba la nɨmba tat tɨngjan kulun wala la kavamba lindi. Mbambala nya vla sɨndɨ, kembandɨ, vɨndi. Kulun waa kavle kavamba lɨgiya nɨmba ndino nya vla sɨndɨ, kembandɨ, vɨgiyandi waa tamba pɨlɨwutndɨ. Jisas yalaa ndi kat apma vat kwindeya vak kat tamba la nayan Aisaia pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tɨga lɨga laataa Jisas ndi kat nyaangɨt mbutɨndɨ. Kavle maawut yelavɨka lɨngwa vak kwagala ngwula. God ngwuk kat vɨga lɨndeya njɨmbla tamba ngway tolagandɨ waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galili walɨnja sakna tɨvagawimba Jisas yiga lɨga kami njulamba kwuta mbɨk nyamwun sambu kat vwndɨ. Mbɨtna sɨ Saimon waa Pita walɨnja nyano Endruo. ");
INSERT INTO ian_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas mbɨk kat wandɨ. Laataa wuna kwupmba yagwa mbɨla. Kami kwutɨmba vak kwagalalaa ndinyangu kwutɨmbeya vak kat mbɨk kat ngɨni sɨmogwigiyowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","laataa njula kwagalalaa ndɨna kwupmba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yiga lɨga nat vɨlɨ palɨ nyamwun samb kat nyaekno njaambɨpmba lɨga njula kwunatɨmbɨk, vɨndɨ. Mbɨtna sɨ Jemsogwi Jono. Mbɨtna nyaekna sɨ Sebedi. Jisas mbɨk kat laataa yagwa wuna kwupmba wandɨ, ");
INSERT INTO ian_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","laataa nyaeknogwi njaambɨk kat kwagalalaa ndɨna kwupmba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas Galilina ngepma ngepmamba yiga njɨvwa kwutɨndɨ. Juda nyaangɨt ngambulɨnja ngay wuleilaa God ndi kat kwunakiya apma nyaangɨt mbutɨndɨ. Mandɨp mandɨp yelogwen kat ta nɨmba kat kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yilɨnda vak kat vɨlaa wan kavana nɨmba kat mbuki mbukimba mbutɨndi. Ngi kat tɨga Siria walɨnja nɨma kɨpmamba la nɨmba aywaa wan nyaangɨt wutndi. Wutaa ndina mbangɨ mandɨp mandɨp yelogwen vɨta nɨmba kat kwutaa Jisas ta kavat kalindi. Kavle waagan tavila la nɨmbagwi kwutaa kalindi. Ava plaga kɨpmamba nda la nɨmbagwi kwutaa kalindi. Man taamba kɨvɨ wata la nɨmbagwi kwutaa kalindi. Jisas ndi kat vɨlaa aywaa kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilimba lɨga yaa nɨmba, ngepma tamba vɨlimba lɨga yaa nɨmba, Jerusalemba lɨga yaa nɨmba, Judiamba lɨga yaa nɨmba, Jotana nat naangɨmba lɨga yaa nɨmba nɨma sakwat yalaa Jisasna kwupmba yisolaa yindi. ");
INSERT INTO ian_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas wan nɨma sakwat nɨmba kat vɨlaa nduwiat wokendɨ maa ndɨ kat vɨlaa ndɨna kwupmba wokendi. Nduwi wokelaa kɨpmamba ndaa lɨndɨ. Ndɨna mbaapmamba la nɨimba ndaa lɨnda kavamba yiga yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas wan nɨma sakwat ya nɨmba kat vɨlaa ndi kat nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kɨta nyan kupma wandeyan. Wun kavle nyan wun. Wuna maawupmba yelavɨka apma vak yiga ana yetɨgiyowun. Kapma lɨga apma vat ana yiga yetɨgiyowun. God wun kat ava kwindɨ maa apma vak yiga yetɨgiyowun waa wandwyan wan nyan nyinangwupmba lɨga apma nda klaigandɨ. Klalaa apma vat tɨgiyandɨ wan nyan. ");
INSERT INTO ian_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kavle vat yiga yetɨlɨga nɨmba nɨma maawut yelavɨka kɨnjeyan apma vala. God ndi kat kwunatndɨ maa solat sɨga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nat nɨmba ndina sɨ kwusolapman tɨga yigumba lɨnjeyan apma vatna. Ndi Godnanamba nɨma sakwat nda klaigandi. ");
INSERT INTO ian_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nat nɨmba Godna nyaangɨt wupmak kat woviyaguga lɨnjeyan apma vala. Klavak yelavɨka lɨnja nda God ndi kat kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nat nɨmba kat miwa yiga lɨgiya nɨmba apma vatna. God ndi kat miwa yiga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Apma tagula maawutno lɨgiya nɨmba apma vatna. Ngɨni God kat vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Waleavak kat ndinyangu sɨvak kat kai waga wupma ke yingwa waa walɨga nɨmba ndi. God ndi kat waigandɨ. Ngwuk wuna nyangu ngwuk waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nat nyangu Godna apma njɨvwa kwutindi, vɨlaa nat kavle nyangu ndi kat vat yilɨnjeyan apma vatna. Nyinangwupmba lɨga nyan kwigiya apma nda wundi apma nɨmba klaigandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Jisas ndi kat nat nyaangɨt ngambundɨ. Ngambuga wandɨ. Wuna kwupmba yalɨngwa vak kat vɨlaa ngwuk kat kavle vat yiga njɨka waga woseka walɨnjeyan ngwuk nɨma vak ke yelavɨkngwa. Ngwuk apma maawuk sɨka solat sɨga yetɨ ngwula. Ngwuk kat yilɨnja kavle vak vla tamba la profet kat wupma yilɨndi. ");
INSERT INTO ian_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kɨlɨnja sol yuvut kɨgindamba taagandi, ana njangu veiga kavle yigiyandɨ. Ngwulo wupma kɨlɨnja sol vla lɨga kɨpmamba lɨga nɨmba kat kwunatɨgangwuk. Sol nyingi lɨga vat ngɨlɨndyan ngɨni kwunatndeya vak kai. Tamba kavle yindɨ. Ava yambɨmba yaagindi maa yi ya lɨga nɨmba mamba veiga yetɨlɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ngwuk kɨpmamba lɨga kemba lɨga nda vla lɨgangwuk. Nambu nduwinmba ngepma kwutaa lɨnjeyan ana alɨpɨiga pagwugiyandi. Wan ngepma aywaa vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kita nyan lam sagalalaa aw yapmba ana naangagiyandɨ. Njambɨmba wokega taagaiyandɨ. Taagandɨ mala kembalɨndɨ, ngaymba lɨga nɨmba aywaa vɨga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lam njambɨmba taaganda vak vla kwutɨngwa apma njɨvwa kapmba agwuk ngwula. Ndinyangu aywaa vɨlaa ngwutna nyinangwupmba lɨga nyaekna sɨ kwutaa wiyak waa katsogiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas Moses kwiya lo kat kalɨpmat yandɨ waa ke yelavɨkngwa. Wungi vak kat ana yawun. Ndɨnai kwuta la lonana angwa nyaangɨt mbupmat yawun. ");
INSERT INTO ian_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maawut ke sɨlɨwoka yetɨngwa. Yelavɨka yetɨ ngwula. Moses kwiya lomba tɨga nyaangɨt aywaa ana kwo vatnat tɨgiyandɨ. Nginangwutno kɨpmo tɨgiyaa njɨmbla wan nyaangɨt tɨgiyandɨ. Ngingwutno kɨpmo ngɨlɨndɨ, ndɨna lo ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kɨta nyan lo kat kai waga nat nɨmba kat kalɨtɨnda vat sɨmogwindeyan ndɨ nyinangwat wuleilaa mat nyanat tɨgiyandɨ. Kɨta nyan lona nyaangɨt wuke kwutaa yetɨga nat nɨmba kat yetɨnda vak sɨmogwindeyan ndɨ nyinangwut wuleilaa njambwi nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moses kwiya lo vɨsɨmogwi lɨga nɨmbagwi Ferisio maawut sɨtapman nɨma njɨvwa kwuka lo waa nyaangɨtmba yetɨlɨgandi. Wundi nɨmba nyinangwut ana wuleigiyandi. Wundi nɨmba yetɨga vak kat kwulataa apma maawut yelavɨka apma vak yetɨngweyan nyinangwut wuleigiyangwuk. Yetɨnja vak kat kwulatapman yingweyan ana nyinangwut wuleigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tamba mbutnja nyaangɨt tamba wutɨngwuk. Nat nyan kat ke vatnyapga. Vatnyangweyan kotngwangat kaligiyandi waa tamba mbutndi. ");
INSERT INTO ian_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mbambala ngwuk kat mandɨt kupi nyaangɨt mbutɨgowun. Kɨta nyan ndɨna yakwa nyan kat nyigi maawut tɨga walealɨndeyan ndɨ kat kotndangat kaligiyandi. Kɨta nyan ndɨna yakwa nyan kat mɨn kavle nyan mɨn waa wandeyan ndɨ kat kaunsilmba kotndangat kaligiyandi. Kɨta nyan ndɨna yakwa nyan kat mɨn tungwengan yiga yetɨga nyan mɨn waa wandeyan wan nyan ya vɨtɨga kavat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","God kat kwunapmak tɨga wuna yakwa nyan kat tamba kavle vat yiwun waa yelavɨpmeyan kwilɨma nda njambɨ ngwaymba taagalaa kwagalalaa yakwa nyan kat yiga avɨ. Ndɨ kat kavle vat yilɨma vak kwunataa at yiga God kat kwunapmak agwi. ");
INSERT INTO ian_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kɨta nyan mɨn kat kotmak kalindeyan ava yambɨmba yiga lɨga kavle vak kat kwunap mɨla. Kwunatapman yimeyan jas wandɨ, plisman mɨn kat kalambusmba taagagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mɨn kat woseka ana wowun. Kalabus ana kwo kwagalagiyamɨn. Jas mɨn kat wand mbak ngɨlɨndɨ maa wogwegiyamɨn. ");
INSERT INTO ian_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tamba la nɨmba tamba mbutɨnja nyaangɨt tamba wutɨngwuk. Nɨmbana taagwa kat yambɨsɨk yilɨnja vak ke yiga yetɨlɨngweya waa mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kan mbambala ngwuk kat mandɨt kupi nyaangɨt mbutɨgowun. Kɨta nyan nat nɨmbana taagwa kat mɨnimba vɨlaa yambɨsɨk yilɨnja vak kat maawupmba yelavɨtndeyan wan kavle vatna. Yambɨsɨk yilɨnja vak vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yaagindan naangɨ lɨga mɨni sɨkmba kavle vak vɨlaa kavle vak yelavɨka kavle vak yilɨmeyan wan mɨni sɨk kuvu ngwula yaagi. Mɨni sɨk tapman tɨmeyan nɨma vak ana ndɨ. Ya vɨtɨga kavat yimeyan wan nɨma vatna. ");
INSERT INTO ian_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yaagindan taambamba kavle vat yilɨmeyan wat taamba kalɨtaa yaagi. Kɨta naangɨ taambambaa yetɨmeyan wan nɨma vat ana ndɨ. Ya vɨtɨga kavat yimeyan wan nɨma vatna. ");
INSERT INTO ian_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tamba la nɨmba tamba mbutɨnja nyaangɨt tamba wutɨngwuk. Kɨta nayan ndɨna taagwa kat kwagalavat yelavɨtndeyan pas mɨna pɨlɨwutaa lɨ kat kwilaa kwagalagiyandɨ. Nyaangɨt kai, waa tamba la nɨmba mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mbambala ngwuk kat mandɨt kupi nyaangɨt mbukiyowun. Kɨta nyana taagwa yambɨsɨk yiga ana yetɨlɨ. Lɨla lan lɨ kat kwo waga kwo lɨ kat kwagalandɨ. Wupma yinda vak wan kavle vatna. Wupma kwagalandɨ maa nat ndu kat yiga ngway tololeyan yambɨsɨk taagwat tɨgiyalɨ. Ngɨni yila nyan ndɨ yambɨsɨk nduat tɨgiyandɨ ndɨno. ");
INSERT INTO ian_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tamba la nɨmba tamba mbutɨnja nyaangɨt tamba wutɨngwuk. Nɨma njɨvwa kwukiyanɨn woseka ana waiganɨn. God vɨga lɨgandɨ waa nɨma kwundimba wandweya njɨvwa agwuk ngwula waa tamba la nɨmba wandi. Woseka ke wangweya waa wandi. Wan nɨma kwundimba walɨnja vak ke walɨngweya. ");
INSERT INTO ian_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kan mbambala ngwuk kat mandɨt kupi nyaangɨt mbukiyowun. Nɨma njɨvwa kwukiyanɨn. Woseka ana wanɨn nyinangwut tɨga nɨmba vɨga lɨgandi waa ke waa. Wan nɨma kwundimba walɨnja vak ke walɨngweya. Nyinangwut vɨga lɨngwa kava ana ndɨ. God ndaa lɨga tɨgɨtna nyinangwut. ");
INSERT INTO ian_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nɨma njɨvwa kwukiyanɨn. Woseka ana wanɨn. Kɨpma lɨga nɨmba vɨga lɨgandi waa ke waa. Kɨpma vɨga lɨngwa kava ana ndɨ. God nyinangwupmba ndaa lɨga lɨngwa kava ana ndɨ. God nyinangwupmba ndaa lɨga man veila lɨnda kava kɨpma. Nɨma njɨvwa kwukiyanɨn. Woseka ana wanɨn. God vɨga lɨga nɨma ngepma Jerusalemba lɨga nɨmba vɨga lɨgandi waa ke waa. Wupma wangweyan wan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nɨma njɨvwa kwukiyanɨn. Woseka ana wanɨn. Wundi nɨma njɨvwa kwutapman yineyan nɨna nambumba lɨga yuwi kavle yigiyandɨ waa ke waa. Ngwutna nambu tɨga vak ana vɨga lɨgangwuk. Wangwut maa ngwula nambuna nɨmba sawun mbangɨ tɨga ngɨk mbangɨ tɨgiyandɨ? kai. ");
INSERT INTO ian_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngwuk kat nyaangɨt wagalanjeyan awa o kai waa awa ndi kat. Wan nɨma kwundimba ke wangweya. Nat nɨma sakwat nyaangɨt ngwuk ke waga. Nat nɨma sakwat kavle nyaangɨt Setenanamba ngwuk klalɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tamba la nɨmba tamba mbutɨnja nyaangɨt tamba wutɨngwuk. Kɨta nyan mɨna mɨni kavle yindeyan awat ndɨna mɨni kat kavle vat ay. Kɨta nyan mɨna nɨmbi kavle yindeyan awat ndɨna nɨmbi kat kavle vat ay waa tamba la nɨmba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kan mbambala ngwuk kat mandɨp kupi nyaangɨt mbutɨgowun. Kɨta nyan ngwuk kat kavle vat yindyan ndɨ kat awat kavle vat ke yiga. Ngwula ngangava viyandeyan ndɨ kat nat naangɨ lɨga ngangavamba agwi viyandangat. ");
INSERT INTO ian_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kɨta nyan ngwula waavwi klavat ngwuk kat kotmak kalindeyan ndɨ kat agwi. Kwilaa alagu kwusolɨngwa waavwi klalaa agwi. ");
INSERT INTO ian_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kɨta nyan mɨn kat yiweya yambɨ kɨta vat yili waa wandeyan yivak kat wanda sɨvla kwulaka ay mɨla. Wuna kwanda kwanda nda kwutaa mail kɨta yiga kali mɨla waa wandeyan ndɨna nda kwutaa mail vɨlɨlɨk kali mɨla. ");
INSERT INTO ian_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kɨta nyan ngwuk kat kɨta nda klavak kat wagalandeyan agwi ngwula. Kɨta nyan wun kat mɨna nda agwi ngɨni awat kwigiyowun wandeyan ndɨ kat agwi. ");
INSERT INTO ian_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tamba la nɨmba tamba mbutɨnja nyaangɨt tamba wutɨngwuk. Ngwutna alɨ nɨmba kat woviyaguga lɨga ndi kat kwunak ngwula. Ngwutna maama nɨmba kat ndi kat kai awa waa tamba mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kan mbambala mandɨp kupi nyaangɨt ngwuk kat mbukiyowun. Ngwutna maama nɨmba kat ndi kat woviyanguga lɨga ndi kat kwunak ngwula. Ngwuk kat kavle vat yilɨga nɨmba kat ndi kat tɨga God kat wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Maama nɨmba kat apma vat yingweyan ngwutna nyinangwapmba lɨga nyaekna nyanguat tɨgiyangwuk. God wandɨ maa nya sɨndɨ, apma vat tɨga nɨmba kavle vat tɨga nɨmba aywaa ndɨna ambukatna kɨgɨnda waatɨgandɨ. God wandɨ maa meik ndandɨ, apma vat tɨga nɨmba kavle vat tɨga nɨmba aywaa ndina ambukatna kɨgɨnda waatɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Takis sanya klalɨga kavle nɨmba ndi kat woviyaguga lɨga nɨmba kat mɨna apma vat yilɨgandi. Ngwuk kat woviyaguga lɨga nɨmba kat mɨna apma vat yiga yetɨngweyan God ngwuk kat apma wenga ana kwigiyandɨ. Ngwuk ndinyangu aywaa ndi kat apma vat ay ngwula. ");
INSERT INTO ian_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","God kat kai walɨga nɨmba ndina ava nɨmba kat mɨna apma nandinya walɨgandi. Ngwula ava nɨmba kat mɨna apma nandinya wangweyan wan apma vat ana ndɨ. Ngwuk ndinyangu aywaa ndi kat apma nandinya awa ngwula. ");
INSERT INTO ian_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nyinangwupmba lɨga ngwula nyaek apma vat yilɨnda vak mɨna ngwulo wupma yiga yetɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ngwuk vɨga wuka lɨgiyangwuk. Nat nɨmba kat apma vat yingweya vat kapmba ke kwuka. Nat nɨmba vɨlandi. Vɨnjeyan ngɨni ngwuk kat nyinangwupmba lɨga nyaek wenga ana kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sanya lapman kwanda kwanda lapman tɨgiyaa nyan kat kwivat tɨngweyan nyaangɨt ke tak tapmba mbuka. Nat nɨmba avla ndina sɨ kwutaa kwusolɨga nɨmba ndi. Ndi Juda nyaangɨt ngambulɨga ngaymba wuleilaa ava yambɨmba yilaa nyaangɨt mbutaa mɨna kwilɨgandi. Nat nɨmba kat kwilɨnja vak vɨlaa ndina sɨ kwutaa katsonjangat tat tapmba nyaangɨt mbutɨgandi. Ndi ndina wenga nda ndinyangunanamba tamba klandi. Nyinangwupmba lɨga nɨna nyaeknanamba ana klaigandi. ");
INSERT INTO ian_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sanya lapman kwanda kwanda lapman nyan kat kwivat tɨngweya nda pagwuga agwi ngwula. Ngwulogwinala lɨga nɨmba vɨlandi. ");
INSERT INTO ian_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pagwuga kwingweyan nɨna nyaek vɨga lɨgandɨ. Vɨlaa apma wenga ngwuk kat kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","God kat wagalangweya njɨmbla kapmba laataa wagala lɨnja vla ke wagalangwa. Wundi nɨmba avla ndina sɨ kwutaa kwuso lɨga nɨmba ndi. Ndi Judana nyaangɨt ngambulɨnja ngay wuleilaa way ava yambɨmba lɨga laataa God kat wagalalɨgandi. Nat nɨmba ndi kat vɨnjangat kapmba laataa wagalalɨgandi. Ngwuk kat woseka ana wowun. Ndi wenga lamba klandi ndinyangunanamba. ");
INSERT INTO ian_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","God kat wagalangweya njɨmbla wupma ke wagalangwa. Ngay weleilaa ngay kamanga kwalalaaa pagwula lɨga kavamba tɨga God kat wagala ngwula. Nyinangwupmba lɨga nɨna nyaek papwula lɨga wagalangweya vat vɨga wutaa apma wenga ngwuk kat kwigiyandɨ. Ndɨno pagwula lɨgandɨ. Ndɨna mbangɨ ana vɨlɨganɨn. ");
INSERT INTO ian_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","God kat wagalangweya njɨmbla nɨma sakwat kwo nyaangɨt ke ngambuga. Ngepma ngepma la God kat vɨlapman nɨmba ndina ngepma waagan kat wupma mandɨt mandɨt walɨgandi. Sɨvla mbundɨ nyaangɨt ngambuneyan nɨna waagan wukiyandɨ waa yelavɨtaa ngambulɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wupma ngambulɨnja vak vla ngwuk ke ngambuga. Nɨna nyaek ngɨni wagalangweya vat ndɨ mbambala vɨga lɨgandɨ. Manda kat nɨma sakwat nyaangɨt ngambuga ndɨ kat wagalagiyangwuk. Nɨma sakwat nyaangɨt ngwuk ke wagalaga. ");
INSERT INTO ian_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","God kat ngambuga wagalangweya njɨmbla kupma ngambungwula waa wandɨ Jisas. Nɨna nyaek nyinangwupmba lɨgamɨn. Mɨna sɨ waga kwutaa katsonjeyan apma vatna. Mɨn nɨma nyan mɨn. ");
INSERT INTO ian_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kava kava kat vɨga lɨmeya njɨmbla yaandɨ. Wungi vat yandeyangat woviyanguga lɨganɨn. Mbambala nyinangwupmba lɨga nɨmba aywaa mɨna kwundi wuka lɨgandi. Nɨno kɨpmamba lɨga nɨmba aywaa mɨna kwundi wutneya njɨmbla nɨn kat yaandɨ. Wungi vat yandeya njɨmbla kat woviyaguga lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mbambala kɨneya kɨgɨnda nɨn kat agwi mɨla. ");
INSERT INTO ian_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nɨn nat nɨmba nɨn kat kavle vat yinja vak kat vɨlaa kwagalaɨganɨn. Mɨno yina kavle vak kat vɨlaa kwagala mɨla. ");
INSERT INTO ian_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kavle vat nɨn kat yaa kwutandɨ. Wamɨn maa ana nɨn kat yaa kwukiyandɨ. Seten nɨn kat kwutaa lɨlɨndɨ. Wamɨn maa ndɨ ana nɨn kat kwutaa lɨgiyandɨ waa God kat wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jisas wandɨ. Ngwuk kat wowun. Nat nɨmba ngwuk kat kavle vat yinja vak kat vɨga kwagalangweyan nyinangwupmba lɨga nɨnɨ nyaek yingweya kavle vat vɨga kwagalagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vɨga kwagalalapman yingweyan ndɨno ana vɨga kwagalagiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nat njɨmbla kɨgɨnda kɨvak kat kai walaa God kat mɨna wagalalɨgangwuk. Kɨgɨnda kɨvak kat kai waa lɨngweya vak nat nɨmba mbak vɨlandi. Mɨndama sɨli lɨpmwiga ke lɨga. Nat nɨmba avla ndina sɨ kwusolɨga nɨmba ndi wupma yilɨgandi. Wupma mɨndama sɨli lɨpmwiga nat nɨmba vɨnjangat tɨlɨgandi. Ndina mɨndama vɨlaa ndi kɨgɨnda kɨvak kat kai walaa kwo lɨgandi. Apma nɨmba ndi waa waigandi. Wan ana nglaatandɨ. Awuk ngwula. Ndi wenga tamba ndinyandgunanamba klandi. Ngɨni Godnamba ana klaigandi. ");
INSERT INTO ian_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kɨgɨnda kɨvak kat kai waa kwagalalaa mbangɨ njangulaa sanda nɨmbi kwuka mbangɨ kwutaa apma mɨndama vɨga lɨngweyan wovuna. ");
INSERT INTO ian_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","God kat wagalavat kɨgɨnda kɨvak kat kai waa kwagalalaa tɨngweya vat nat nɨmba vɨlandi. Nɨna nyaek ndɨ vɨlaa apma wenga ngwuk kat kwigiyandɨ. Ndɨno pogwula lɨga nyana. Nɨna mɨni ndɨna mbangɨ ana vɨga lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kan kɨpmamba ke nɨma sakwat kwanda kwanda yisoga taagaga. Ndɨkna kwutɨndɨ, vɨlɨngɨni kalɨtɨgandɨ. Kun kɨga lɨgiyandi. Sɨkwutɨga nɨmba weleilaa tɨvwi ngɨlɨka sɨkwukiyandi. ");
INSERT INTO ian_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nyinangwupmba nɨma sakwat kwanda kwanda yisoga taagangweyan wovuna. Ndɨkna ana kwukiyandɨ. Vɨlɨngɨni ana kalɨkiyandɨ. Kun ana kɨga lɨgiyandɨ. Sɨkwutɨga nɨmba ana tɨvwi ngɨlɨka sɨkwukiyandi. ");
INSERT INTO ian_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngwutna kwand kwanda nda yisoga taagangwa kavakat mɨna nɨmamba maawupmba yelavɨka lɨgiyangwuk. Kwanda kwand kɨpmamba yisoga taaga lɨga nɨmba kɨpmana nda kat mɨna yelavɨka lɨgandi. Kwanda kwanda nyinangwupmba yisoga taagalɨga nɨmba nyinangwutna nda kat mɨna yelavɨka lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ngwutna mɨni ngay wuleinja ndaamange vla lɨgandɨ. Mɨnimba vɨngwuk, nɨma sakwat vak ngwula mbangɨ wuleigiyandɨ. Apma nda mɨna vɨga lɨngweyan ngwula mbangɨ ngwula maawut apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kavle nda mɨna vɨga lɨngweyan ngwula mbangɨ maawut kavle yigiyandɨ. Apma nda ngwula maawut weleigiya nat yambɨ kai. Kavle vat mɨna wuleindyan wan kavle nglei vatna. Apma vat ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ndu nyan kɨta nɨma nyan vɨlɨlɨkmba ana njɨvwa kwukiyandɨ. Nat nɨma nyan kat kai walaa nat nɨma nyan kat mɨna yelavɨka lɨgiyandɨ. Nat nɨma nyana kwundi wupmak kat kai walaa nat nɨma nyana kwundi mɨna wuka lɨgiyandɨ. Ngwutno wungi vat tɨga nɨmba ngwuk. Godna njwvwa kwukawi sanya njɨvwa kwukawi ana kwukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ngi vak kat ngwuk kat wowun. Kɨngweya nao kɨgɨnda ngu kat nɨmamba ke yelavɨtɨngwa. Kwusongweya waavwi kat ke nɨmbamba yelavɨtɨngwa. Wan kɨgɨnda nɨma vat ana ndɨ. Waavwi nɨma vat ana ndɨ. God waa nyaangɨt wuka apma vat mɨna yiga yetɨneyan wan nɨma vatna. ");
INSERT INTO ian_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wan wiyaka yi yalɨga waavi kat avɨ ngwula. Ndi ambkat njɨvwa ana kwutɨgandi. Ndi ambukatna nda ana vaga yiga kɨga kwutɨgandi. Ndi ambukatna nda ana vaga yiga kɨga kavamba yisoga taagalɨgandi. Nyinangwupmba lɨga nɨna nyaek ndi kat vɨga lɨgandɨ. Nɨno nɨn kat vɨga lɨgandɨ. Waavi mat nda. Nɨn ndinyangu nɨma nda nɨn. ");
INSERT INTO ian_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɨma vak yelavɨka yetɨngwa vak nɨma njɨvwa kwutɨga vak ana ndɨ. Kɨta nyan wundumbu yivak kat vaaka nɨma maawut yelavɨka lɨndeyan ndɨna lɨvɨ nɨmba kat ana kwulakiyandɨ. Wundumbu yivak kat vaatapman tɨgiya nyan kat ana kwulala kwo yetɨgiyandɨ. Ndɨ kiyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kwusoga yetɨngweya waavwi kat manda kat nɨmbamba yelavɨka lɨgangwuk. Kɨpmamba avla waataa lɨlɨga mwe ndi kwuso waavwi kat ana yelavɨka lɨlɨgandi. Mwe ana njɨvwa kwuka waavwi klalaa tavaga yelaga lɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tamba la King Solomon ndɨ apma nglei waavwi kwusoga lɨndɨ. Ndɨna kwuso lɨnda waavwi mwena mbangɨ kat ana kwulatɨndɨ. Mwena mbangɨ ndɨna waavwi kat kwulatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Avla waatɨga nda kat God ndi kat apma yelaga nda kwilɨgandɨ. Avla waatɨga nda nɨma nda ana ndɨ. Sɨvla mbundɨ ana lɨlɨgandɨ. Ndinyangu kalɨka kɨta lɨvwimba yisolaa ya sagalandɨ, vɨka ngɨlɨlɨgandi. Nɨn ndinyangu wupma lɨga nda ana nɨn. Nɨn nɨma nda nɨn. God nɨn kat vɨga lɨga kwusoneya waavwi kwigiyandɨ. Ngwuk nɨma maawut ke yelavɨka lɨngweya. Ngwuk God kat wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kɨweya nao kɨgɨnda ngu andamba lɨndɨ, klaigowun kwusoga yetɨweya waavwi andamba lɨndɨ, klaigowun waa ke nɨmamba yelavɨtɨngwa. ");
INSERT INTO ian_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Godna sɨ wutapman ta nɨmba ndino wupma nɨma maawut yelavɨka lɨndi. Ngwuk Godna nyangu ngwuk. Ndɨ ngwuk kat vɨga lɨga miwa yiga kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wan nda kat ngwuk nɨma maawut ke yelavɨka lɨngwa. Godna kwundi wupmak kat mɨna nɨma maawut yelavɨka lɨngweyan ndɨna apma vak kwilaa kan kɨpmana nda ngwutna lak kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngɨni yaiga vak kat ke ngwuk nɨma maawut yelavɨka lɨngwa. Yaiga vak ngɨni yaigandɨ. Nandinya nandinya nɨma vat tɨgiyandɨ. Ngwuk mand kat yaiga vak kat nɨma maawut yelavɨka lɨgiyangwuk. Ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nat nɨmba kat vɨlaa ngwuk kavle nɨmba ngwuk waa wangweyan God ngwuk kat vɨlaa ngwuk kavle nɨmba ngwuk waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ndi kat vɨlaa walɨngwa vak vla God ngwuk kat vɨlaa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nat nyan yiga yetɨga kavle mat vat manda kat vɨlaa sɨga nagulɨgangwuk. Ngwulai yiga yetɨlɨga kavle nɨma vak kat ngwuk ana vɨlɨgangwuk? ");
INSERT INTO ian_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nat nyan kat vɨlaa mɨn samat kavle vat tamba yimɨn. Yima vak kwunakiyanɨn waa manda kat walɨgangwuk. Kavle vat yiga yetɨngwa vak nɨma nglei vatna. ");
INSERT INTO ian_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngi kat tɨga nat nyan samat kavle vak yinda vak kat vɨlaa walɨngweyan ngwuk woseka walɨga nɨmba vla lɨgiyangwuk. Ngwulai yiga yetɨlɨga nɨma kavle vak kwagalalaaa yingweyan nat nyan yiga yetɨgiyaa mat kavle vak kat kwunakiyangwuk. Tat ngwutnai yiga yetɨga kavle vak kwagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God waa apma nyaangɨt wupmak kat kai walɨga nɨmba kat ke mbuka. Mbukngweyan kavle waala valɨnda vak vla ngwuk kat yigiyandi. God walɨga apma nyaangɨt kavle nyaangɨtna waa walɨga nɨmba kat ke mbuka. Ndi wutaa kai waigandi. Mbak yetɨga kavamba yaagingwa apma nda mbak velɨngwundi, ndailaa lɨga nda vla lɨgiyandɨ ngwutna nyaangɨt. ");
INSERT INTO ian_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","God kat wagalangweyan ndɨ kat wagalangweya nda klaigangwuk. Kwaka lɨngweya nda vɨgiyangwuk. God tɨga ngayna mbapmo taambamba viyangweyan ndɨ lavwiygiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","God kat wagala lɨga nɨmba ndi aywaa wagalalɨnja nda klaigandi. Kwaka yetɨlɨga nɨmba aywaa kwatɨnja nda klaigandi. Mbapmo taambamba viyalɨiga nɨmba aywaa wan ngayna mbapmo God lavwindɨ maa wuleigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngwula ngepmana vatnonala kɨta vatna. Kɨta mat nyan ndɨna nyaek kat nao kat wagalandyan ndɨna nyaek ndɨ kat kambapmba kwigiyandɨ? E? Kai la. Wupma ana kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kɨta mat nyan nyaek kat kami kat wagalandeyan ndɨ kat kamboymba kwigiyandi? E? Kai la. Wupma ana kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngwuk kavle nɨmba ngwuk. Ngwutna mat nyangu kat apma nda klalaa kwilɨgangwuk. Nyinangwupmba lɨga nɨna nyaek ndɨ kavle nyan ana ndɨ. Ndɨno wupma nɨn kat apma nglei nda klalaa ndɨ kat wagala lɨga nɨmba kat kwilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mandana apma vat yinda vak kat vɨlaa woviyaguga lɨma nat nyan kat yindangat wan vak woviyaguga lɨma vak nat nɨmba kat ay mɨla. Wan vak Moses kwiya lomba profet pɨlɨwutnja nyaangɨtmba la angwa nyaangɨtna. ");
INSERT INTO ian_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ngwuk mat suwi yambɨmba wulei ngwula. Kavle kava yilɨnja ava yambɨna suwi yambɨ nɨma nglei lɨgandɨ. Kavle kava yilɨnja ava yambɨ savagu lɨgandɨ. Nɨma sakwat nɨmba wungi ava yambɨmba yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Apma kava yilɨnja ava yambɨna suwi yambɨ nɨma ana lɨ. Matnat. Apma kava yloɨnja yambɨ savagu lɨga yambɨ ana ndɨ. Nɨma sakwat nɨmba ana yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Woseka waa kavle nyaangɨt mbutɨga nyangu kat yiga ngwaymba avɨ. Nɨn God waa nyaangɨt mbutɨganɨn waa woseka walɨgandi. Ndina mbangɨ mɨndama apma vatna. Ndinai yelavɨka yetɨga maawut kavle maawutna yelavɨka yetɨnja. Ndi kat yiga ngwaymba avɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yiga yetɨnja vak kat vɨlaa ndinai maawupmba yelavɨka yetɨnja vak kat vɨga wukiyangwuk. Ndi kavle mi vla lɨgandi. Kavle tangu mbundɨ lɨga apma mi sɨk ana kwalɨgandɨ. Yilavi mbundɨ lɨga kavle yuwi apma vak kɨlɨnja yuwi sɨk ana kwalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Apma mi mɨna apma sɨk wogwulaa kwalɨgandɨ. Kavle mi ndɨno kavle mi sɨk wogwulaa kwalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Apma mi kavle mi sɨk ana kwalɨgandɨ. Kavle mi apma mi sɨk ana kwalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Apma mi sɨk kwalapman mi vɨtaa tambɨ lambɨ kalɨka yisolaa ya sagalandi, vɨtɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngi kat tɨga God waa nyaangɨt mbutɨganɨn waga kavle nyaangɨt mbuka yetɨlɨga nɨmba kat yiga yetɨnja vak kat vɨlaa sɨga ngugiyangwuk. Yiga yetɨnja vak mi sɨk vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nɨma sakwat nɨmba wun kat vɨlaa njambwi nyan waa woseka walɨgandi. Ndi aywaa nyinangwut ana alɨpsɨga wuleigiyandi. Nyinangwupmba lɨga wuna nyaek walɨga kwundi wuka yetɨlɨga nɨmba mɨna nyinangwuk wuleigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngɨni yaiga nandinya nɨma sakwat nɨmba wun kat yaa vɨlaa njambwi nyan njambwi nyan waa woseka waigandi. Mɨna sɨmba waga God waa nyaangɨt nat nɨmba kat yiga mbutɨnɨn. Mɨna sɨmba waga kavle waagan kat savɨlɨnɨn. Mɨna sɨmba waga nɨma nɨma njɨvwa kwutɨnɨn waa woseka waigandi. ");
INSERT INTO ian_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wandi maa ndi kat waigowun. Ngwutna mɨndama ana vɨga lɨgowun. Wun kat kwagalalaa ay ngwula. Ngwuk kavle nɨmba ngwuk waa ndi kat waigowun. ");
INSERT INTO ian_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kɨta nyan mbutuwa nyaangɨt wutaa wan nyaangɨpmba yiga yetɨndeyan kambapmba ngay tolaa kwutɨga apma nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wan nyan kambapmba ngay tolaa kwutndɨ mala nɨma meik mwutolo kiyandɨ. Ndandɨ mala ngumbi kiyandɨ, wan ngay kwo lɨndɨ. Kambapmba taundɨ. Ana ndandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kɨta nyan mbutuwa nyaangɨt wutaa kai wandeyan yaawiamba ngay tolaa kwutɨga kavle nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wan nyan yaawiamba tolaa ngay kwutndɨ mala nɨma meik mwutolo kiyandɨ. Ndandɨ mala ngumbi kiyaga sɨngwamatndɨ, aywaa ndandɨ wan ngay waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas wandɨ maa wan nɨma sakwat nɨmba ndɨna kwundi wutaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ndina nat nɨmba Moses kwiya lo sɨmogwilɨga nɨmba vla lɨga ana Jisas mbutɨndɨ. Ndɨ kwonduo lɨga mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas nduwimba lɨga ngaga yandɨ. Ngaga yandɨ maa tat ndɨnai mbukna vak wuka la nɨmba ndɨna kwupmba yalaa yisolaa lɨndi ndu lagwa. ");
INSERT INTO ian_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tɨga lɨga kawia kɨga la nyan yalaa Jisasna mangɨndamba kwali kwali sɨlaa Jisas kat wandɨ. Njambwi nyan wun kat kwunapmak wameyan alɨpsɨga kwunakiyamɨn. ");
INSERT INTO ian_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wandɨ maa Jisas ndɨna mbangɨmba taamba taagalaa wandɨ. Mɨn kat tamba kwunakowun. Apma vat yetɨ mɨla waa wandɨ maa kawia kɨga lɨnda vat wan kawia kasendɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas ndɨ kat wandɨ. Awup mɨla. Mɨn kat kwunakwa vak nat nɨmba kat mɨn ke mbuka. God kat kwunatɨga nyan kat mɨna yiga mɨna mbangɨ sɨmogwi mɨla. Mɨna mbangɨ vɨlaa God Moses waa vapmba kwanda kwanda vatnyalaa God kat kwigiyandɨ. Kwindeya vak vɨlaa mɨna mbangɨ kwo lɨnda vak kat vɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas Kapaneam walɨnja ngepma yiga wuleindɨ maa njambwi soldia yalaa Jisas kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jambwi nyan wuna njɨvwa kwuta nyan yelogwen kat tɨgandɨ. Ndɨna ava kiyandɨ, njambɨmba kwandɨ. Nɨma kangɨt yilɨndɨ, tɨgandɨ waa Jisas kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wandɨ maa Jisas ndɨ kat wandɨ. Yiga kwunakiyowun wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wan nyan Jisas kat wandɨ. Wun apma nyan ana wun. Wuna ngay manda kat yaigamɨn. Kai wowun. Kumba lɨga nyaangɨt mɨna wamɨn maa wuna njɨvwa kwutɨga nyan kwo lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wuna njambwi soldia wun kat vɨga lɨgandɨ. Ndɨna kwundi wuka lɨgowun. Wuno nat nɨmba kat vɨga lɨga nyaangɨt mbutɨga nyan wun. Wuna kwupmba lɨga soldia kat ay waweyan yigiyandi. Yagwa waweyan yaigandi. Wuna njɨvwa kwutɨga nyan kat njɨvwa agwut waweyan ndɨ kwukiyandɨ waa wandɨ njambwi soldia. ");
INSERT INTO ian_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas wutaa ngɨpaliga ndalaa wandɨ. Ndɨna maawupmba yelavɨka lɨnda vak vla ana Isrelmba lɨga nɨmbana maawut yelavɨka lɨgandi. Ndi kat aywaa kwulatndɨ. Ndɨna maawut apma vat tɨgandɨ. Yelogwen kat kwa nɨmba kat kwunatuwa vak ndɨ vɨga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yigumba awuk ngwula. Nyinangwut wuleigiyaa wan kava. Wuleilaa Judana njambwi nɨmba Ebraham, Aisak, Jekopnogwinala kɨta vak kɨga kɨta yelangɨmba yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judana nat nɨma sakwat nɨmba ndi ana wuleigiyandi. Nat nɨmba wuleigiyandi. Ndi wuleilapman nɨmba kavle kava yilaa nglaga nɨmbi ngliaka lɨgiyandi waa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ndi kat walaa njambwi soldia kat wandɨ. Mɨna ngay ay mɨla. Wagalama vat tɨgiyandɨ waa wandɨ maa yilaa ndɨna njɨvwa kwuta nyan kwo lɨnda vat vɨndɨ. Vɨlaa yelavɨtndɨ. Jisas waa njɨmblamba ndɨ kwo lɨndɨ waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas Pitana ngay wuleilaa ndɨna tangwana nyɨme yelogwen kat tɨlɨ, vɨndɨ. Lɨla mbangɨ kangan walɨndɨ, njambɨmba kwalɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas lɨla taamba kwutndɨ maa lɨla mbangɨ kangan yelogwen vɨtɨnda vak ngɨlɨndɨ, laataa kɨgɨnda kwutɨ Jisas kat. ");
INSERT INTO ian_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nglaambu kavle waagan tavila la nɨmba kat kwutaa Jisas ta kavat kiyandi, ngwuk kavle waagan ndi kat kwagalalaa ay ngwula waga ndi kat kwunatndɨ. Yelogwen kat ta nɨma sakwat ndu taagwa yandi, vɨlaa ndino ndi kat kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ndi kat kwo ana kwunatndɨ. Tamba la profet Aisaia pɨlɨwuthnda nyaangɨt vla kwunatndɨ. Tamba Jisas kat pɨlɨwutndɨ. Yelogwen kat tɨna vak ndɨna lak klalaa kwunatndɨ waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nɨma sakwat nɨmba yalaa yisolaa lɨndi vɨlaa Jisas tamatndɨ. Ngi kat tɨga Jisas njaambɨt kulaa wandɨ maa ngusamba kaga nat naangat valɨgendi. ");
INSERT INTO ian_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kawindi mala Moses kwiya nyaangɨt sɨmogwi lɨga nyan yalaa Jisas kat vɨlaa wandɨ. Sɨmogwi lɨga nyan yimeya kava wuno mɨna kwupmba yigiyowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas ndɨ kat wandɨ. Kwapɨmba yetɨlɨga waala sɨndu kwalɨnda waangu ngi lɨga. Waavi sɨndu kwalɨnja ngay ngilɨga. Wun Godna vak ndinyangu kat sɨmogwi lɨga nyan wun sɨndu kwaweya kava kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ndɨna kwupmba yetɨ lɨga nyan laataa Jisas kat wandɨ. Njambwi nyan. Wuna nyaek tamba wundumbu yindɨ. Ndɨ kat yiga waangu vala nguvat wowun. Ngɨni yalaa mɨna kwupmba yetɨgiyowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisas ndɨ kat wandɨ. Ke yiga ndɨna mala. Wuna kwupmba yavak kat kai walɨga nɨmba ndi waangu vala waangumba ngugandi. Mɨn wuna kwupmba yagwa mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas njaambɨt ndɨna mbaapma nɨmbonala kulaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yilɨndi maa nɨma mwutolo kwutndɨ, pali laatndɨ Nɨma pali laataa ndina njaambɨt wuleindɨ. Jisas sɨndu kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ndɨnagwi kɨta vat ya nɨmba ndɨ kat sɨvɨlulaa wandi. Njambwi nyan. Nɨna njaambɨt tamba kambruka tɨgandɨ. Nɨn ngu kɨgiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas laataa ndi kat wandɨ. Ngwuk manda kat vaatɨgangwuk. Njambwi nyanat tuwa vat ana ngwuk nɨmamba yelavɨtɨgangwuk waa walaa mwukagwi pali kat wandɨ, kiyak wandɨ. Mwuk kiyak wandɨ, pali ndɨno kiyak wandɨ. Ngu yuvut tapman tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ndɨna nyan manda nyana. Mwuk pali ndɨnai waa vapmba wutɨnda waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Njaambɨpmba yiga Gadara walɨnja ngepma kawindi anguveli naangamba. Kawindi maa kiya nɨmbana waangumba yetɨ lɨga mbɨt nyan laataa Jisas la kavat yambɨt. Kavle waagan tavila la mbɨt nyan. Kao mbundɨ nyan mbɨt. Nat nɨmba mbɨk kat vaaka lɨndi. Tɨlɨmba kavamba ana yi ya yetɨlɨindi. ");
INSERT INTO ian_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jisas kat vɨlaa mbɨt kɨselaa wambɨt. Mɨn Godna nyan mɨn. An kat angamak yigiyamɨn. An kat kavle vat yivat yamɨn? An kat kwulapmeya njɨmbla na ndɨ waa kɨselaa wambɨt. ");
INSERT INTO ian_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nɨma sakwat mbak wan kavamba kɨga yetɨndi. ");
INSERT INTO ian_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mbɨk kat tavila la waagan Jisas kat wagalambɨt. An kat savɨlɨvat wameyan savɨlɨlɨmɨn maa mbapmba wuleilaa yigiyaa. Wovuna? waa wagalambɨt. ");
INSERT INTO ian_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wagalambɨt maa Jisas kwowa ay mbɨla wandɨ. Mbɨk kat kwagalalaa yiga mbapmba wuleimbɨk maa wan mbak vaaka pɨlɨga ndaiga satnat yindi. Yilaa wan mbak aywaa ngu kɨgiyatndi. ");
INSERT INTO ian_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wan mbak kat vɨga la nyangu ngepmat pɨlɨga yiga ngepmamba la nɨmba kat nayaangɨt mbutndi. Kavle waagan ndu nyan kat kwagalalaa mbapmba wuleilaa pɨlɨnja vak kat yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngepmamba la nɨmba wutaa Jisas la kavat yindi ndɨ kat vɨvat. Ndɨ kat yiga vɨlaa wandi. Nɨna kɨpma kwagalalaa mɨn ay mɨla wandi. ");
INSERT INTO ian_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas kat kai wandi maa njaambɨt kulaa valɨgega ndɨna angwa ngepmamba kawindɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Man taamba kɨvɨ watna nyan njambɨmba ndaa lɨndɨ maa nat nɨmba ndɨ kat walalaa kiyandi. Jisas ndɨ kat kwunakiyandɨ waa maawupmba yelavɨtnja vak kat vɨlaa Jisas wandɨ. Wuna nyan mɨn nɨma maawut ke yelavɨka. Kavle vat yiga yetɨma vak tamba sɨlɨmbwigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba wutaa maawupmba yelavɨka lɨndi. Wan nyan God kat kavle vat wandɨ waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Maawupmba yelavɨka tɨnja vak kat Jisas vɨlaa wandɨ ndi kat. Ngwutna maawupmba manda kat kavle vak yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kavle vat yiga yetɨma vak kat sɨlɨmbwigiyowun waweyan njambɨ kwagalalaa laataa yetɨ waweyan kɨmbɨt vɨlɨlɨk nyaangɨt kɨta vatna. ");
INSERT INTO ian_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wun Godna vak ndinyangu kat sɨmogwi lɨga nyan wun. Kavle vat yetɨnja vak kat sɨlɨmbwiweya kwondu ngilɨga wunamba. Wuna kwondu ngwuk kat sɨmogwivat wowun. Ndi kat ndɨna kwondu sɨmogwivat man taamba kɨvɨ watna nyan kat vɨlaa wandɨ. Mɨn laataa mɨna njambɨ walalaa ngay ay wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wandɨ maa laataa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nat nɨmba vɨlaa ngɨpali walaa vaaka lɨndi. Vaaka lɨga wandi. God wan nyan kat nɨma kwondu kwindɨ waa Godna sɨ kwutaa katsondi. ");
INSERT INTO ian_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas wan ngepma kwagalalaa yiga takis sanya kla lɨga nyan kat vɨndɨ. Ndɨna sɨ Matyu. Takis sanya klalɨnda ngaymba lɨndɨ. Jisas ndɨ kat vɨlaa wuna kwupmba laataa yagwa wandɨ. Wandɨ maa laataa yindɨ ndɨna kwupmba. ");
INSERT INTO ian_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nat nandinya Jisas ngaymba lɨga nɨma sakwat nɨmbonala nao kɨga lɨndɨ. Ndɨnogwinala kɨla nɨmba nɨmbonala nao kɨga lɨndɨ. Ndɨnogwinala kɨla nɨmba takis sanya klala nɨmbo kavle vat yiga yetɨ lɨga nɨmbo kɨta vat yisolaa lɨga nao kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ferisi yalaa nao kɨlɨnja vak kat vɨlaa Jisasna kwupmba la nɨmba kat wandi. Takis sanya klalɨga nɨmbo kavle vat yiga yetɨlɨga nɨmbo manda kat ngwula njambwi nyan nao kɨlɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wanja vak Jisas wutaa ndi kat wandɨ. Apma vat kwo lɨga nɨmba dokta kat ana yilɨgandi. Yelogwen kat ta nɨmba mɨna yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngwuk tamba God wandɨ, pɨlɨwutnja nyaangɨtna angwa vak ana vɨga lɨgangwuk. Kupma pɨlɨwutndi. Kwanda kwanda vatnyalaa wun kat ke kwiga. Nat nɨmba kat nɨma vak yelavɨka ndi kat kwunak ngwula waa wandɨ God waa tamba pɨlɨwutndi. Wun apma vat yetɨlɨga nɨmba kat kwunapmak ana yawun. Kavle savle yetɨlɨga nɨmba kat mɨna kwunapmak yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngu yagula Jona kwupmba la nɨmba yalaa Jisas kat wandi. Nɨnogwi Ferisio nɨma sakwat njambɨ kɨgɨnda kɨvak kat kai walɨganɨn. Mɨna kwupmba la nɨmba ndi wupma ana yilɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wandi maa Jisas tamba la nyaangɨtno ndɨnai kiya kupi nyaangɨt kat ndi kat mbuka wandɨ. Kɨta nyan taagwa klandeya njɨmbla nɨma kɨgɨnda kwutndi. Ya nɨmba wan kɨgɨnda kɨvak kat kɨlɨp mbangɨ yiga ana lɨndi. Wan kapti kwukna nyan yindɨ maa ndina mbangɨ kɨlɨp mbangi yindɨ, kɨgɨnda kɨvak kat kai waigandi. ");
INSERT INTO ian_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tamba ngɨlɨkna waavwimba kupi waavwi taagalaa tavanjeyan ngɨni wan waavwi nɨmamba ngɨlɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tamba sɨmbɨmba tavanja awmba kupi nɨma ngu ana salakiyandi. Salatnjeyan nɨma nguna mbiyak nɨma yindɨ maa sɨmbɨ kɨkɨk waa mbɨlɨgiyandɨ. Mbɨlɨndɨ maa nɨma ngu kɨpmamba salaka yigiyandɨ. Nɨma nguagwi wan sɨmbo kɨta kɨta kavle yigiyandɨ. Kupi nɨma ngu klalaa kupi sɨmbɨmba mɨna kwutaa salatndi maa kwo lɨgiyandɨ waa ngambundɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ngambulɨndɨ maa Judana njambwi nyan yalaa kwali mamba sɨlaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wandɨ maa Jisas laataa ndɨna kwupmba yindɨ. Jisasna mbaapmamba la nɨmba ndɨno laataa kɨta vat yindi. ");
INSERT INTO ian_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yilɨndi maa yaat tɨgɨmbimba yelogwen yilɨndɨ, yetɨla taagwa yalɨ. Naambi tamba vɨli kiyeli vɨlɨlɨk yelogwen yilɨndɨ, yetɨlɨlɨ. Jisasna kwupmba yalaa ndɨna njɨmbwi waavwi sɨnyɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tat yelavɨtɨ. Ndɨna waavwi sɨnyɨkweyan wuna mbangɨ kwo lɨgiyowun waa yelavɨtaa sɨnyɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sɨnyɨtɨ maa Jisas lɨmbalaguga vɨlaa wandɨ. Taagwa nyan nɨmamba ke yelavɨka. Jisas wun kat kwunakiyowun waa yelavɨtɨnya vak vɨlaa nyɨna kavle vak kat tamba kwunakowun. Nyɨn kwo apma vat tɨgiyanyɨn waa walaa ");
INSERT INTO ian_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Judana njambwi nyana ngay wuleindɨ. Ngay wuleilaa waavi wala nɨmba ngla lɨga nɨmba kat vɨlaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ngwuk wun kat tula ngwula. Wat taagwa nyan ana kiyalɨ. Sɨndu kwalɨ waa wandɨ maa wutaa ndɨ kat njɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yindi maa Jisas wat taagwa nyana ngway yilaa lɨla taambamba kwutndɨ, laatɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Laataa vak mbutseli mbutsela ngepma ngepma mbuka kalindi, aywaa wutndi. ");
INSERT INTO ian_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas wan kava kwagalalaa yindɨ maa mɨni vɨlapman ta mbɨt nyan vɨlɨlɨk ndɨna kwupmba yiga wambɨt. Mɨn Devitna yelangɨ nyan mɨn. An kat miwa ay mɨla waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas ngay wuleindɨ maa ndɨna kwupmba wuleimbɨt. Wuleilaa an kat kwunap mɨla wambɨt. Wambɨt maa Jisas wandɨ. Mbɨk angamak yelavɨka lɨgambɨk. Mbɨk kat alɨpsɨga mbambala kwunakiyowun? waa wagalandɨ maa awa njambwi nyan mɨn alɨpsɨga an kat kwunakiyamɨn waa wambɨt maa ");
INSERT INTO ian_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jisas mbɨk kat mɨnimba taamba taagalaa wandɨ. Maawupmba yelavɨka lɨmba vak kat vɨlaa kwunakowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","mbɨla mɨn kembandɨ, vɨmbɨk. Jisas mbɨk kat nɨma kwundimba wandɨ. Mbɨk kat kwunatuwa vak mbɨk nat nɨmba kat ke mbuka waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yimbɨk maa mbutseli mbutsela mbutɨmbɨk, wan kavana ngepma aywaa wutndi wan kwunatnda nyaangɨt. ");
INSERT INTO ian_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yilɨmbɨt maa kwundi ngambu lapman nyan kat kwutaa Jisas la kavat kalindi. Kavle waagan ndɨ kat tavilaa ndɨna tɨgat kulumatndɨ, ana kwundi ngambulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas wan ndɨ kat kwuta la kavle waagan kat savɨlɨndɨ maa wan nyan kwundi ngambundɨ. Nat nɨmba vɨlaa ngɨpaliga ndalaa wandi. Tak nɨn Isrel tɨna kavamba wupma ana vɨlɨnɨn. Apma vatna. ");
INSERT INTO ian_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ferisi ndi mandɨp vak wandi. Kavle waagana savɨlɨlɨgandɨ waa wandi ndɨ kat. ");
INSERT INTO ian_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas ngepma ngepma yindɨ. Yiga Juda nyaangɨt ngambula ngay wuyleilaa wan apma nyaangɨt ndi kat mbutɨndɨ. God yalaa nɨn kat vɨga lɨgiyandɨ waa wandɨ. Mandɨt mandɨt yelogwen vɨtɨndɨ, ta nɨmba kat vɨlaa kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nɨma sakwat nɨmba kat vɨlaa ndi kat miwa yiga lɨndɨ ndi. Ndu nyan vɨga lɨlapman sip sip ta vak vla lɨndi. Ngi kat tɨga ndi kat miwa yiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ndi kat miwa yiga lɨga ndɨna kwupmba la nɨmba kat wandɨ. Nɨma sakwat kɨgɨnda ambugapmba kwo lɨga ak wulɨgandɨ. Vɨlaa sɨgɨka kiya nɨmba kai. ");
INSERT INTO ian_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ambugat kat vɨga lɨga njambwi nyan kat wagala ngwula. Nɨma sakwat nɨmba kat ay wamɨn maa ambugatna kɨgɨnda sɨgɨka kiyaigandi waa wagala ngwula njambwi nyan kat waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas wandɨ maa ndɨna kwupmba la tamba vɨli kiyeli vɨlɨlɨk nɨmba yisolaa lɨndi. Yisolaa lɨndi maa kavle waagan savɨlɨnjeya kwondu ndi kat kwindɨ. Yelogwen kat kwaiga nɨmba kat kwunatnjeya kwondu ndi kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wan tamba vɨli kiyeli vɨlɨlɨk aposelna sɨ kɨngiyan. Tat ta nyan Saimon waa Pita walɨnja nyan. Nat nyan Pitana yakwa nyan Endru. Nat vɨlɨlɨk palɨ Sebedina nyan Jemsagwi Jono. ");
INSERT INTO ian_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nat nyan Filip. Nat nyan Batolomyu. Nat nyan Tomas. Nat nyan Matyu. Ndɨ takis sanya klala nyana. Nat nyan Alfiasna nyan nat Jems. ");
INSERT INTO ian_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nat nyan Tadias. Nat nyan nat Saimon. Ndɨ ngepma ngepma yiga nat nɨmba nɨna kɨpma kat yalaa vɨga lɨnjangat kai waa ngambulɨndɨ. Nat nyan Judas Iskeriot Jisas kat vatnyavat kamwin kwiga ndɨ kat sɨmogwiya nyana. ");
INSERT INTO ian_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas tamba vɨli kiyeli vɨlɨlɨk nɨmba kat wandɨ. Ngwuk ngepma ngepma yiga njɨvwa kwuk ngwula. Juda ana ndi nat nɨmbana ngepma ke yingwa. Sameria lɨga nɨmbana ngepma ke yingwa. ");
INSERT INTO ian_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Juda lɨga ngepma ngepmat ay ngwula. Wundi Juda nɨma nyan kat pogwula lɨga sip sip vla lɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yiga ndi katambuk ngwula. Nginangwupmba lɨga nɨma nyan nɨn kat vɨga lɨndeya njɨmbla tamba ngway tologandɨ waga yiga ndi kat mbuk ngwula. ");
INSERT INTO ian_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yelogwen kat tɨgiyaa nɨmba kat vɨlaa kwunak ngwula. Kiya nɨmba kat vɨlaa wangwuk mala laakiyandi. Kawia kɨga lɨgiya nɨmba kat yiga vɨlaa kwunakngwuk mala kwo lɨgiyandi. Kavle waagan tavila lɨgiyaa nɨmba kat vɨlaa savɨlɨmba ngwuk. Wunamba la kwondu kwo klangwuk. Wun kat wenga kwilaa ana klangwuk. Ngi kat tɨga yiga ndi kat kwo kwunak ngwula. Ndina wenga ke klangweya. ");
INSERT INTO ian_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Moni sanya kwuka wana yilɨngweya. Yimbwi kwuka wana yilɨngweya. ");
INSERT INTO ian_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mandɨp waavwi mandɨp man su vasɨ vasɨ ke kwutaa yiga. Ngwuk njɨvwa kwutɨga nɨmba ngwuk. Njɨvwa kwukngwuk maa ngwuk kat wan da kwigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ngepma wuleilaa wuna ngay yagwa waiga nyan kat vɨlaa ndɨna ngay wuleigiyangwuk. Ngay ngay ke yilɨngweya. ");
INSERT INTO ian_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ngay wuleilaa apma nandinya waga apma vat tɨgiyangwuk waa waigangwuk ndi kat. ");
INSERT INTO ian_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wuleingwuk maa ngwuk kat yagwa wanjeyan apma nyaangɨt wangwa nyaangɨt ndinamba tɨgiyandɨ. Wuleingwuk mala ngwuk kat kai wanjeyan wangwa apma nyaangɨt lungwamata ngwula lak yaigandɨ. Lungwamataa ngwula lak yandɨ maa ndi kavle savle tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wan ngaymba lɨgiya nyan wan nɨma ngepmamba lɨgiya nyan ngwuk kat kai wandeyan wan ngepma kwagalavat laataa man mbaw vɨvlɨlaa kwagalalaa laataa aymba ngwuk. Ngwuk vɨga lɨgiyangwuk. God ngwuk kat sɨgiyandɨ waa ndi kat waga man mbaw vɨvlɨmba ngwuk. ");
INSERT INTO ian_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngɨni yaiga nandinya God ndinyangu kat sɨga naguvat tɨndeya nandinya Sodom Gomora walɨnja kavle ngepmamba la nɨmba ndi nɨma vat dlaigandi. Ngwuk kat kai waiga ngepma nɨmba ndi nɨma nglei vat klaigandi. ");
INSERT INTO ian_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Awuk ngwula. Ngwuk ngepma ngepma yivat yilɨgangwuk. Kavle waala sip sip kat valɨnda vla wundi nɨmba ngwuk kat kavle vat yigiyandi. Kamboy apma maawut yelavɨka yigumba yilɨga vak vla ngwuk wupma ay ngwula. Namiyo yilɨga vak kap ana yalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ngwuk yigumba vɨga lɨgiyangwuk. Nat nɨmba ngwuk kat kwutaa kotngwangat kaligiyandi. Juda ngaangɨt ngambulɨnja ngay ngwuk kat kwutaa kalilaa viyaigandi. ");
INSERT INTO ian_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wuna sɨ wangwuk maa ngwuk kat kwutaa kaligiyandi. Njambwi king mat king ngwuk kat vɨga sɨga nagunjangat kaligiyandi. Ngwuk kat kalindi maa wan njambwi nɨmba kat kwutaa lɨngwa apma nyaangɨt ndi kat mbukiyangwuk. Juda ana ndi nat nɨmba ndino ndi kat mbukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Notngwangat kalindi maa kotmak tɨngweya nyaangɨt kat nɨmamba ke vaaka yelavɨkngweya. Ngwuk kat kwutaa kalindi maa kotngweya nyaangɨt ngwutna maawupmba mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mbukngweya nyaangɨt ngwutna nyaangɨt ana ndɨ. Nɨna nyaek kwigiya waagan ngwutna mbangɨmba tavindɨ maa mbukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ngɨni yaiga kavle njɨmbla kavle vat nɨma sakwat yaigandɨ. Kɨta nyan ndɨna yakwa nda nyan kat kwutaa kotmak kalindɨ maa ndɨ kat kwutaa vatnyangiyandi. Nyaek ndino indina nyangu kat kwutaa kotnjangat kaligiyandi. Nyangu ndina nyaek nyɨme kat kai walaa nyaek nyɨme kat kwutaa kotmak kalindi maa vatnyagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wuna sɨ ngwuk tamba kwutaa lɨgangwuk. Ngi kat tɨga nɨma sakwat nɨmba ngwuk kat kai waigandi. Wan kavle njɨmbla ngɨlɨndɨ maa kwo lɨga wuna sɨ kwutaa lɨga nɨmba ndi apma vat tɨigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kɨta ngepmana nɨmba ngwuk kat kavle vat yinjeyan wan ngepma kwagalalaa vaaka nat ngepmat ay ngwula. Ngwuk kat wowun. Judana ngepma ngepma yiga mbutɨngweya njɨvwa kwiyatapman ana ngɨlɨgiyandɨ. Wun Godna vak sɨmogwi lɨga nyan yilaa yawun maa wan njɨvwa ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kwupmba lɨga nyan ndɨ kat vɨga lɨga sɨmogwi lɨga nyana njambwi nyan ana ndɨ. Sɨmogwi lɨga nyan ndɨ njambwi nyana. Njɨvwa kwutɨga nyan wan njɨvwa kat vɨga lɨgiya njambwi nyana njambwi ana ndɨ. Njɨvwa kat vɨga lɨgiya nyan ndɨ njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kwupmba lɨga nyan ndɨ kat vɨga lɨga sɨmogwi lɨga nyan lɨnda vla lɨndeyan wovuna. Njɨvwa kwutɨga nyan wan njɨvwa kat vɨga lɨgiya njambwi nyan lɨnda vla lɨndeyan wovuna. Wun ngwutna njambwi nyan wun. Nat nɨmba wun kat wandi. Mɨn waagana njambwi nyan mɨn. Mɨn Bielsebul mɨn waa wun kat wandi. Ngwuk wuna kwupmba lɨga mbaapma nɨmba ngwuk. Ngwutno ngwuk kat kavle nglei sɨ waigandi. ");
INSERT INTO ian_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ndinyangu ngwuk kat yigiya kavle vak kat nɨmamba ke vaaka yelavɨka lɨngwa. Ngwuk kat pagwuga kavle vat yilɨnja vak ngɨni nat nɨmba aywaa vɨgiyandi. Pagwulɨnja kavle nyaangɨt ngɨni nat nɨmba aywaa wukiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mbambala ngwuk kat pagwuga mbutuwa nyaangɨt ngepma ngepma yiga kapmba mbukiyangwuk. Kan ngwuk kat mbutuwa nat nɨma sakwat nɨmba ana wutɨgandi. Ngwuk kat mɨna mbutɨgowun. Ngwuk wutaa yiga nɨma sakwat nɨmba kat kak kiya mbukiyangwuk ngepma ngepmamba. ");
INSERT INTO ian_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ngwuk kat vatnyagiya nɨmba kat ngwuk ke vakngwa. Ndi ngwutna wundumbu kat ana vatnyagiyandi. God kat mɨna vaaka alɨ ngwula. Nɨna mbango wundumbu kat ya vɨtɨga kavamba yiga alɨpsɨga taagagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mat waavi kɨlɨnja waavi peni kɨta yaagilaa vɨlɨlɨk klaigangwuk. Kan mat waavi kiyalɨnja vak kat nɨna nyaek ndɨ vɨga lɨgandɨ. Mat waavi ana kiyaigandɨ waa wandeyan wan waavi ana kiyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ngwulo ngwuk kat wupma vɨga lɨgandɨ. Ngwula nambumba lɨga yuwina sakwat vɨga sɨga naguga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ngwuk ke vatɨngwa. Ngwuk kat vɨga lɨgandɨ. Mat waavi kat ngwuk kwulatɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kɨta nyan Jisas wuna njambwi nyana waa nat nɨimba kat wandeyan nyinangwuk tɨga wuna nyaek kat vɨlaa wan nyana sɨ waa ndɨ wuna nyana waa waigowun. ");
INSERT INTO ian_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɨta nyan Jisas wandeyan nyinangwut tɨga wuna nyaek kat waigowun. Wan nyan wuna nyan ana ndɨ waa waigowun. ");
INSERT INTO ian_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kan kɨpmana nɨmba kao yilɨnja vak kat kalɨpmak ana yawun. Wungi vak kat ana yawun. Awat sowat kao sɨnjangat yawun. ");
INSERT INTO ian_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yawun maa nat nɨmba wun kat kai wandi maa nat nɨmba wun kat yagwa wandi, wungi vak kat tɨga laataa awat sowat waliandi. Mat nyangu laataa ndina nyaek kat waliagiyandi. Taagwa nyangu ndino laataa ndina nyɨme kat waliagiyandi. Ndinyanguna taagwa laataa ndina lana nyɨme kat waliagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yawun maa kɨta ngaymba lɨlɨga nɨmba laataa waliaga kapma kapma nɨmingi vla lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","kita nyan wun kat samat samat yelavɨtaa ndɨna nyaek nyɨme kat nɨma nɨma vat yelavɨtndeyan ndɨ ana wuna mbaapma wuleigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","God wandɨ, ndɨna njɨvwa kwupmat yawun. Nat nɨmba kai waa wun kat sɨnjeya vak kat ana vaakiyowun. Wun kat kwinda njɨvwa kwutapman yiga wuna kwupmba yalapman yindeyan wan nyan wuna mbaapma ana wuleigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kɨta nyan avla ndɨna mbangɨ kat mɨna yelavɨka kwo yetɨndeya vak kat mɨna yelavɨka lɨndyan ndɨ kavle yigiyandɨ. Kita nyan wuna njɨvwa kwuka ndɨna mbangɨ kat yelavɨtapman yindeyan ndɨ apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kɨta nyan ngwuk kat apma vat yindeyan wan apma vat yinda vak wuna lak yaigandɨ. Kita nyan wun kat ay waa nyanat yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kɨta nyan Godna nyaangɨt mbuka yetɨlɨga nyan kat vɨlaa yagwa waa ndɨna ngayat kalindeyan wan apma vatna. Godna nyaangɨt mbuka yetɨlɨga nyan klaiga wenga ndɨno ngayat kwutaa kalia nyan klaigandɨ. Kita nyan apma nyan kat vɨlaa yagwa waa ndɨna ngayat kalindyan wan apma vatna. Apma nyan klaiga wenga wan dɨ kat kwutaa ngayat kalia nyan ndɨno klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ngwuk ke maawut tɨvɨga lɨngwa. Kɨta nyan wuna mbaapmamba la mat nyan kat vɨlaa ndɨ Jisasna mbaapma nyana walaa ndɨ kat kɨgɨn ngu kuvuk kwindeyan ndɨ apma wenga klaigandɨ. Wan kwinda mat nda kat vɨlaa God ndɨ kat wenga kwigiyandɨ. Ndɨna maawut ana tɨvɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas ndɨna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nɨmba kat yinjeya vak kat mbuka walaa ndi kat kwagalalaa nyaangɨt mbupmat laataa ngepma ngepma yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngu yagula Jon ndɨ kat kalambusmba taagandi, lɨndɨ. Kraist kwuta njɨvwa kat wutaa Jon ndɨna mbaapmamba la nɨmba kat wandɨ. Kraist kat yiga wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wandɨ maa yiga Jisas kat wagalandi. Nɨn kat ambuk. Tat Jon njɨvɨa kwuka lɨga wandɨ. Kɨta nyan wuna kwupmba yaigandɨ wandɨ. Mɨn kat wandɨ? E? Kanda kat wandɨ waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas ndi kat kat wandɨ. Kwutuwa njɨvwa vɨga wukngwa vak lungwamataa yiga Jon kat ambuk. ");
INSERT INTO ian_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mɨni kiyala lɨga nɨmba kwunakwun mala apma mɨna vɨlɨgandi. Man kɨvɨ wata la nɨmba kwunakwun mala laataa apma man veilɨgandi. Kawia kɨga la nɨmba wowun mala kawia kasɨlɨgandɨ, kwo lɨlɨgandi. Waan wutapman nɨmba kat wowun mala laatɨgandi. kwondu kapman kwo lɨga nɨmba kat wan apma nyaangɨt mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kɨta nyan wun kat vɨlaa ndɨ God wandɨ, yaa nyana waa yelavɨka lɨndyan ndɨ apma maawut sɨka lɨga nyana waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jona mbaapmamba la nɨmba Jon ta kavat lungwamataa yindi maa Jisas wan nɨma sakwat nɨmba kat Jon yeta vak kat ndi kat mbutndɨ. Jon ndinyangu lapman kavamba lɨndɨ, vɨvat yingwa njɨmbla ndɨ kat angamak yelavɨka yingwuk. Mwuk kwutɨndɨ, kɨpmamba lɨga yuwi ava yuvut yilɨnda vak vla lɨga nyana waa yelavɨka ndɨ kat vɨvat yingwuk? Kai. Jon wupma ana lɨndɨ. Ndɨ tagula nyana. ");
INSERT INTO ian_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndɨ apma waavwi kwuso lɨga nyana waa yelavɨka ndɨ kat vɨvat yingwuk? Jon wupma ana lɨndɨ. Apma waavwi kwuso lɨga nɨmba ndi apma ngaymba yetɨlɨga nɨmba ndi. Ndɨ apma ngay kai. ");
INSERT INTO ian_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ndɨ profetna waa yelavɨka ndɨ nat profet kat kwulatndɨ. Ndɨ ndina njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tamba God waa nyaangɨt pɨlwuta nɨmba ndi Jon kat pɨlɨwutndi. God wandɨ. Kan nyan wuna nyaangɨt mbutɨga nyana. Ndɨ tatak yiga mbukiyandɨ. Ngɨni yimeya yambɨ kwukiyandɨ waa God wandɨ ndɨna nyan kat waa tamba la nɨmba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngwuk wutaa yelavɨk ngwula. Kan kɨpmamba la nat nɨmba kat aywaa Jon ndɨ kwulatɨgandɨ. Nyinangwut wuleila nyan God vɨga lɨga mat nyan ndɨ Jon kat kwulakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tat jon nyaangɨt mbuka yliɨndan yiga yaa kan mbambala kavle nɨmba wuna njɨvwa kalɨpmak kat walɨgandi. Kwutɨma njɨvwa nɨna maawupmba apgwup mɨla waa wun kat walɨgandi. ndina kwundi wutapman nyinangwupmba lɨga njambi nyan kɨpmamba lɨga nɨmba kat vɨga lɨndangat kan kwutuwa njɨvwa kwutɨgowun. ");
INSERT INTO ian_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Njambwi nyan kan vɨga lɨndeya vat tamba la profet mbutɨndi. Moses ndɨno wan nyaangɨt mbutɨndɨ. Jon ndɨno wan nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndinai mbuta nyaangɨt wuka lɨngweyan apma vatna. Jon tamba la nyan Ilaija mbutnda vak vla mbutɨndɨ. Tamba la nɨmba pɨlɨwutndi. ngɨni Ilaija yaigandɨ waa pɨlɨwutndi Mbambala Ilaija tamba yalaa lɨgandɨ, Jona. ");
INSERT INTO ian_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Apma maawut yelavɨka lɨgiya nɨmba kan mbutuwa nyaangɨt kat wutaa yelavɨka lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mbambala kan kɨpmamba lɨga nɨmba kwuka yetɨnja vak ngwuk kat mbukiyowun. Ndi mat nyangu vla lɨgandi. Ngepma nɨndɨmba ndaa lɨga nat nyaangu kat walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Mbangu kwundi waga tamba kwangu viyanɨn. Mbɨk ana mbangu veiga lɨgambɨk. Nɨn nglasa kwundi nglasɨka nglalɨnɨn. Mbɨk ana nglasaka nglalɨgambɨk. Yilɨna vak ana nɨna kwupmba yina vla yiligambɨk waa mat nyangu walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon yalaa kɨgɨnda kɨvak kat kai walaa lɨga nɨma ngu ana kɨlɨndɨ. Mbambala lɨga mat nyangu vla lɨga nɨmba ndɨ kat vɨlaa wandi. manda kat wupma yilɨgandɨ. Ndɨ tungwengwan yiga nyana waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wun Godna vak sɨmogwi lɨga nyan yalaa kɨgɨnda kɨga nɨma ngu kɨlɨwun. Mbambala lɨga mat nyanagu vla lɨga nɨmba wun kat vɨlaa wandi. Ndɨ kavle nyana. Kɨgɨnda kɨga nɨma ngu nɨma sakwat kɨlɨga nyana. Takis sanya klalɨga nɨmbo kavle vat yetɨlɨga nɨmbana alɨ nyana waa walɨndi. Ndi God wandɨ, yelavɨka lɨnja maawupmba ana lɨgandi. Kavle maawut yelavɨka lɨgandi. kwutuwa apma njɨvwa vɨlaa Godnonala lɨga kwutɨgandɨ waa waigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nat ngepma vɨlɨlɨk yiga wuleilaa Jisas nɨma sakwat nɨma njɨvwa kwutɨndɨ. Wan ngepma nɨmba kwutɨnda njɨvwa yɨlaa wan yetɨnja kavle vat ana kwagalandi. Tɨga lɨna ngɨni wan ngepma wuleilaa wan ngepma nɨmba kat Jisas njɨka wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ngwuk Korosin walɨnja ngepmamba lɨga nɨmba ngwuk kat ngɨni kavle vat yaigandɨ. Ngwuk Betsaida walɨnja ngepmamba lɨga nɨmbo ngwulo ngwuk kat kavle vat yaigandɨ. Tamba vɨngwa kwutuwa nɨma njɨvwa tamba la nɨmba Taia Saidon walɨnja ngepmamba la nɨmba vɨganjan ndina kavle vak kat kai waa kwagalagendi. Kavle vak kwagalalaa kavle waavwi ndina mbangɨmba sɨtaa mbaw klalaa ndina mbangɨmba kwukendi. kwutndi maa vɨlaa nat nɨmba ndi kat vɨlaa wagendi. Ndina kavle vat tamba kwagalandi waa wagendi. ");
INSERT INTO ian_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngwuk kat wowun. Ngwuk awuk ngwula. Ngɨni yaiga nandinya God ndinyangu kat vɨga sɨga nagundeya nandinya Taia Saidon walɨnja ngepmamba la nɨmba ndi kat God nɨma vat yigiyandɨ. Ngwuk ngwuk kat nɨma nglei vat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngwuk Kapaneam valɨnja ngepmamba lɨga nɨmba nɨn apma vat tɨganɨn nyinangwupmba lɨga nɨmba vla lɨganɨn waa yelavɨka lɨgangwuk. Wupma yelavɨka lɨngwa vat ana nglaatndɨ. God ngɨni ngwuk kat kwutaa ya vɨtɨga kavat yisenda kiyandɨ. Ngwutna ngepmamba kwutuwa nɨma njɨvwa tamba la ngepma Sodomba kwukewan ndi kavle yiga yetɨnja vak kat kwagalagendi. God ndi kat ana kwutaa vatngagendɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngwuk kat wowun. Gɨni yaiga nandinya God nandinya Sodom walɨnja ngepmamba la nɨmba ndi kat God nɨma vat sɨgiyandɨ. Ngwuk ngwuk kat nɨma nglei vat sɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wan nandinya Jisas ndɨna nyaek kat wandɨ. Wuna nyaek mɨn nyinangwut kɨpma kat vɨga njambwi nyan mɨn. Mɨna angwa vak apma nambuo lɨga nɨmba kat ana sɨmogwiwun. Save lapman tɨga nɨmba kat mɨna sɨmogwiwun. nambuo lɨga nɨmba kat kai. Ndi kat ana sɨmogwiwun. Wan yima vak apma vakna. ");
INSERT INTO ian_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mɨn mɨna yelavɨpma maavupmba wupma yimɨn. ");
INSERT INTO ian_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wuna nyaek wun kat mɨna kwondu mɨnai yelavɨka lɨga vat aywaa wuna lak kwimɨn. Wunai yelavɨka lɨga vat nat nɨmba ana vɨlɨgandi. Mɨn kɨta nyan mɨna vɨlɨgamɨn. Mɨnai yelavɨka lɨga vat nat nɨmba ana vɨlɨgandi. Wun kɨta nyan vɨga lɨgowun. Yagwa walaa wunai sɨmogwia nɨmba wundi nɨmba ndino vɨga lɨgandi waa nyaek kat wasɨmblalaa wumba kɨta vat tɨnda nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nɨma vat tɨga njɨvwa kwuka nɨma maawut yelavɨka lɨga nɨmba ngwut aywaa yagwa ngwuyla. Yalaa yat njawiaga apma maawut yelavɨka tɨngweya vat klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kwutuwa njɨvwa agwuk ngwula. Wun kao mbundɨ nyan ana wun. Ngwuk kat ana njɨka waigowun. Kwutuwa apma nɨma njɨvwa kɨta vat kwukngweyan apma vak yat njawiaga apma maawut yelavɨka lɨngweya vat klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wuna njɨvwa nɨma vat tɨga njɨvwa ana ndɨ. Ngwuk kat kwiweya njɨvwa kwutɨngweyan ngwutna mbangɨ wiyo waavi laagagiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tɨga lɨga ngɨni njɨvwa lapman nandinyamba Jisas ndɨna mbaapmamba la nɨmbonala yuwi sɨk watɨga ambugava yindɨ. Yilaa yetɨga lɨga ndɨna mbaapmamba la nɨmba wundɨ kat tɨndi. Tɨga lɨga ndi yuwi sɨk pangwutaa kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kɨlɨnja vak kat Ferisi vɨlaa Jisas kat wandi. Nɨnai yetɨlɨga vak kat kai valaa mɨna mbaapmamba lɨga nɨmba njɨvwa lapman nandinyamba yuwi sɨk pangwutɨgandi. Wupma yinja vak ana nglaatndɨ. Kavle vatna waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas wanja vak wutaa ndi kat wandɨ. Tamba Devit ndɨna mbaapma nɨmbonala wundɨ kat tɨga kɨlɨnja vat tamba pɨlɨwutndi. Ngwuk ana vɨngwuk? ");
INSERT INTO ian_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ndi wundɨ kat tɨga Godna ngay wuleilaa God kat taaganja bret-nao klalaa kɨlɨndi. nɨna ngepmana vak God kat kwunatɨga nɨmba mɨna kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Njɨvwa lapman nandinyamba God kat kwunat tɨga nɨmba Godna ngay wuleilaa God kat kwunapmak njɨvwa kwutɨgandi. Wan njɨvwa kwutɨnja vak Moses kwiya nyaangɨpmba ana wukngwuk? Njɨvwa lapman nandinyamba njɨvwa ke kwuka waa Moses waa nyaangit kat kai walaa ndi God kat kwunatɨga nɨmba ndi njɨvwa kwutɨgandi. Ndi kat nyaangɨty ana lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tamba Moses kwila nyaangɨt kat kwulakiya nat nyaangɨt ngilɨga. ");
INSERT INTO ian_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tamba God wandɨ, Hosia pɨlɨwutnda nyaangɨtna angwa vat ngwuk ana vɨga lɨgangwuk? God wandɨ. Kwanda kwanda vatnyalaa wun kat ke kwiga. Nat nɨmba kat nɨmamba yelavɨka kwunak ngwula waa wandɨ God waa tamba Hosia pɨlɨwutndɨ. Kan nyaangɨtna angwa vak vɨgengwan apma vat yilɨga nɨmba kat vɨlaa ngwuk kavle vat yilɨgangwuk waa ana wagengwuk. ");
INSERT INTO ian_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wun Godna angwa vat sɨmogwilɨga nyan wun. Wun njɨvwa lapman nandinyana nɨma nyan wun. Wan nandinya wun kat njambiya ana taagagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas wan kava kwagalalaa Juda nyaangɨt ngambula ngay wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Taamba kɨvɨ wata la nyan kɨta wumba lɨndɨ. Jisas kavle vat yindeyan wovuna. Ndɨ kat kotndangat kaligiyanɨn waa yelavɨka lɨga nɨmba ndino wumba lɨndi. Ndi Jisas Kat wagalandi. Njɨvwa lapman nandinyamba kɨta nyan kat kwunapmeyan wovuna? waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas ndi kat wandɨ. Ngwutna kɨta nyana sip sip nɨma waangumba ndaindɨ maa ndɨ njɨvwa lapman nandinyamba taambamba kwutaa katsogiyandɨ. njɨvwa lapman nandinyamba kwutaa katsondeyan nyaangɨt kai. Nɨna ngepmana vat kɨngiyan. ");
INSERT INTO ian_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ndu nyan sip sip kat kwulatɨgandɨ. Ngi kat tɨga njɨvwa lapman nandinyamba kɨta nyan kat kwunakweyan nyaangɨt kai. nɨna ngepmana vat kɨngiyan waa ndi kat walaa ");
INSERT INTO ian_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","taamba kɨvi wata la nyan kat wandɨ. Mɨna taamba agiya wandɨ maa taamba kwindɨ. kwindɨ maa ndɨna taamba kwo lɨndɨ. Ndɨna nat taamba vla lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ferisi vɨlaa wan ngay kwagalala Jisas kat vatnyanjeya vak kat yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas ndɨ kat vatnyanjeya vak kat wutaa Jisas wan kava kwagalaa nat ngepmat yindɨ. Nɨma sakwat nɨmba ndɨna kwupmba yindi. ndina nat nɨmba yelogwen kat ta nɨmba. Yelogwen kat ta nɨmba kat aywaa kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kwunataa wandɨ. Wuna sɨ nat nɨmba kat ke yiga mbuka wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wupma kwo ana wandɨ. Tamba profet Aisaia pɨlɨwukna nyaangɨt vla ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God wandɨ. Wan nyan wuna njɨvwa kwutga nyana. Kwutndeya njɨvwa ndɨ kat kwiwun. Ndɨ kat vɨga yelavɨka solat sɨlɨgowun. Wuna waagan ndɨ kat kwiwun ndɨna mbangɨmba tavindɨ maa wuna angwa vat aywaa ndinyangu kat mbukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana nɨma kwundimba njɨka waigandɨ. Nɨndɨ ava yambɨmba laataa ana nɨma kwundimba waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Vɨta lɨga suwa ana nagɨ vɨli mbɨlɨgiyandɨ. kwunakiyandɨ. Samat samat vɨgɨga lam ana kwutnyagiyandɨ. Kwunatndɨ maa nɨma vak vɨkiyandɨ. Njɨvwa kwuka yiga apma vak kwulakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɨma sakwat nɨmba ndɨ kat vɨlaa waigandi. Ndɨ nɨn kat kwunatɨga nyana waa waigandi waa wandɨ God waa tamba pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kɨta nyan kavle waagan ndɨ kat tavila lɨndɨ maa ndɨna mɨni kwita lɨga ndɨna tɨgat kulumatndɨ, lɨndɨ. Wan nyan kat kwutaa Jisas la kavat kalindi. Kalindi maa Jisas kwunatndɨ maa wan nyan mɨni vɨga kwundi ngambundɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wumba la nɨma sakwat nɨmba vɨlaa ngɨpaliga ndalaa wandi. Ndɨ Devitna yelangɨmba la nyan anaga ndɨ. Nɨn Juda nɨn kat kwunatɨga nyan anaga ndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Walɨnja vak Ferisi ndino tɨga wutaa wandi. Wupma wangwa vak ana nglaatndɨ. Waagana njambwi nyan Bielsebul ndɨ kat kwondu kwindɨ maa waagan kat savɨlɨlɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ndina maawupmba yelavɨka lɨnja vak kat Jisas vɨlaa ndi kat wandɨ. Kɨta ngepma nɨmba mbaapma vɨlɨlɨpmba lɨga awat sowat sɨga viyanjeyan wan ngepmamba lɨga nɨmba aywaa ngɨlɨgiyandi. Kɨta ngaymba lɨga nɨmba mbaapma vɨlɨlɨk tɨga awat sowat sɨga viyanjeyan wundi nɨmba ngɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setena mbaapmamba lɨga nɨmba ndion wungi vat sɨgɨt. Mbaapma vɨlɨlɨk tɨga awat sowat sɨga viyanjeyan ndɨna mbaapmamba lɨga nɨmba ndiono ngɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beklsebul ndɨ kat kwondu kwindɨ maa waagan savɨlɨlɨgandɨ waa wun kat walɨgangwuk. Ngwutna mbaapma nɨmba ndino waagan kat savɨlɨlɨgandi. Ndi kat kand kwondu kwindɨ maa waagan kat savɨlɨlɨgandi. Wun kat walɨngwa vat ndina lak yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Walɨngwa vak ana nglaatndɨ. Godna waagan wun kat kwondu kwindɨ maa kavle waagan kat savɨlɨlɨgowun. Savɨlɨluwa vak vɨlaa God nɨn kat kwutnatndeya njɨmbla tamba ngway tologandɨ waa yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tagula ava la kavle nyan ndɨna man taamba yaawmba sangilapman tɨga ana alɨpsɨga ndɨna ngay wuleilaa ndɨna kwanda kwanda kwutaa kaligiyandi. Ndɨ kat man taamba sangilaa mɨna ndɨna nda kwutaa kaligiyandi. Seten ndɨno ndɨ kat man taamba sangilaa mɨna ndɨna kwupmba lɨga kavle waagan kat savɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kɨta nyan wunogwinala njɨvwa kwutapman yindeyan wan nyan wun kat kai walɨga nayna. Wun ndinyangu kat kwutaa kiyaa wuna mbaapmamba taaga lɨgowun. Kɨta nyan wunogwinala taagalapman yindeyan wuna mbbapma lɨga nɨmba kat savɨlɨlɨga nyana. ");
INSERT INTO ian_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngi kat tɨga ngwuk kat wowun. Yigumba awuk ngwula wowun ngwuk kat. Kɨta nyan kavle vat yiga yetɨga kavle nyaangɨt ngambundeyan ndɨnai yiga yetɨga kavle vak God alɨpsɨga sɨlɨmbwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wun Godna vak sɨmogwi lɨga nyan wun. Kɨta nyan wun kat kavle nyaangɨt ngambundeyan God ndɨ kat alɨpsɨga sɨlɨmbigiyandɨ. Godna waagan kat kavle nyaangɨt ngambundeyan wupma ana sɨlɨmbwigiyandɨ. Ngɨni nɨmbun ana sɨlɨmbwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Apma mi mɨna apma sɨk wogwulaa kwaigandɨ. Kavle mi ndɨ kavle sɨk mɨna wogwulaa kwaigandɨ. Mina sɨk vɨlaa wan mi kat vɨlaa ndɨna sɨ yelavɨka lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wan apma mi kavle mi tɨnda vak vla ngwulo ndinyangu wupma lɨgangwuk. Ngwuk apma nyaangɨt ana alɨpsɨga ngambulɨgangwuk. Ngwuk kavle kamboyna nyangu vla lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Apma maawut yelavɨka yetɨgiya nyan ndɨ apma njɨvwa kwuka apma nyaangɨt ngambuga yetɨgiyandɨ. Kavle maawut yelavɨka yetɨgiya nyan ndɨ kavle njɨvwa kwuka kavle nyaangɨt ngambuga yetɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ngwuk kat wowun. Awuk ngwula. Ngɨni yaiga nandinya God ndinyangu kat sɨga nagundeya nandinya kavle nyaangɨt ngambungwa nyaangɨt kat aywaa God ngwuk kat wagalagiyandɨ. Wagalalaa kavle wenga kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngambungwa apma nyaangɨt kavle nyaangɨt wuka sɨga nagulaa ngwuk kat waigandɨ. Mɨn kavle nyan mɨn. Mɨn apma nyan mɨn waa ndinyangu kɨta kɨta kat waigandɨ God waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jisas wandɨ maa Moses kwiya lo sɨmogwi lɨga nɨmbagwi Ferisio ndɨ kat wandi. Sɨmogwi lɨga nyan. Apma nɨma njɨvwa kwupmɨn maa vɨgiyanɨn waa wandi maa. ");
INSERT INTO ian_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisas ndi gat wandɨ. Ngwuk mbambala yetɨlɨga nɨmba ngwuk kavle nɨmba ngwuk. Godna vak ana vɨga lɨgangwuk. Apma nɨma njɨvwa kwukwangat wangwuk. Wangwa vak vla ana kwukiyowun. Tamba la profet Jona kwukna vak vla kwukiyowun. ");
INSERT INTO ian_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona nandiynya kuwuk nɨma kamina yapmba tɨndɨ. Tɨga lɨga wogwendɨ. Wun Godna vak sɨmogwi lɨga nyan wun. Wuno waangumba nandinya kuvuk ngan kuvuk tɨga laakiyowun. ");
INSERT INTO ian_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ngɨni yaiga nandinya God ndinyangu kat vɨga sɨga nagundeya nandinya Nineva walɨnja ngepmamba ta nɨmba laataa ngwuk kat vɨlaa waigandi. Tamba la profet Jona mbukna nyaangɨt wutaa kavle vat yiga yetɨna vak kwagalanɨn waa waigandi. Ngwuk Ferisio Mosesna nyaangɨt sɨmogwi lɨga nɨmbo Jonana njambwi nyan mbukna nyaangɨt wupmak kat kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ngɨni yaiga nandinya kambangwapmba tɨga Solomon kat vɨvat yat njambwi lagwa kwin laataa ngwuk kat vɨlaa waigalɨ. Tamba wun Solomona kwundi ngambulɨnda vat wupmak laataa sɨvla mbundɨmba lɨga yawun. Yalaa ndɨna ngambulɨnda apma kwundi wutwun waa waigalɨ wat njambwi lagwa. Ngwuk Solomona njambwi nyana kwundi wupmak kat ngwuk kai wangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kavle waagan kɨta nyan kat kwagalalaa kwo kavamba yiga yi ya yetɨga lɨga tɨndeya ngay kat kwaka yetɨndɨ. Wan yetɨnda kavamba ngay lɨlapman yindeyan yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tamba luwa ngayat lungwamataa yigiyowun waa yelavɨtaa lungwamataa yandɨ. Yalaa vɨndɨ. Wan ngay tamba yaguga kwunaka yelagandi, kwo lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yalaa vɨlaa kavle waagan sɨla vɨli kat yiga walaa kɨta vat yandi. Yalaa wan ngay wuleindi. Ndi waagan sɨla vɨli vɨli kɨta la waagan kat kavle vapmba kwulatndi. Ndina ngay vla lɨga wuleinja nyan tak kavle savle lɨndɨ. Wuleindi maa mbambala kavle klei yilaa lɨgandɨ. Kavle klei lɨnda vak vla kan mbambala klei lɨga nɨmba ndino kɨta vatna. ");
INSERT INTO ian_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ngaymba ngambulɨndɨ maa ndɨna nyɨmeo sambo yandi. Alagumba lɨga ndɨ kat wandi. ");
INSERT INTO ian_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ngaymba la kɨta nyan ndi kat vɨlaa Jisas kat wandɨ. Mɨna nyɨme yakwa nyangu kɨndɨ kiyandi yalaa alagumba lɨga mɨn kat walɨga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wandɨ maa Jisas ndɨ kat wandɨ. Wuna nyɨme wuna sambu ngwuk vɨsɨmogwi kiyowun walaa ");
INSERT INTO ian_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ndɨna mbaapmamba la nɨmba kat ndɨnogwinala lɨndi, taamba sɨga wandɨ. Avɨ mɨla. Wuna nyɨme wuna yakwa nɨmba kɨndɨ kiyandi lɨga. ");
INSERT INTO ian_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nyinangwupmba lɨga wuna nyaek wa vapmba yetɨgiya nɨmgba wuna nyɨme, wuna sambu, wuna nyange ndi. ");
INSERT INTO ian_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wan nandinya Jisas ngay kwagalalaa sat ta tɨvagawiat wogwendɨ. Wogwelaa ndaa lɨga ndinyangu kat nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nɨma sakwat ndu lagwa ndɨna nyaangɨt wupmat yalaa tɨndi, ndi kat vɨlaa tamataa njaambɨtnat wuleilaa ndaa lɨndɨ. Nɨma sakwat ndu lagwa tɨvagawimba yisolaa lɨndi, ndi kat nyaagɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndi kat pagwuga mandɨt mandɨt nyaangɨpmba nɨma sakwat nyaangɨt ndi kat mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mbuka walɨndɨ. Tak kɨta nyan tɨndɨ. Ndɨ yuwi sɨk ambugapmba yaagivat yindɨ. Yaagilɨndɨ maa nat sɨk ava yambɨmba ndandɨ, waavi yalaa vɨlaa kɨndi. ");
INSERT INTO ian_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nat sɨk kambat tɨga kava tagu kipma kuvut ta kavamba ndandɨ. Ndalaa kwiyatapman kandi waatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Njingwut tambɨ lɨndɨ maa nya sɨngwalɨtndɨ, njingwut law wandɨ, kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nat sɨk kavle yuwi sɨk tɨga kavamba ndandɨ. Kavle yuwi wataa tegɨlɨndɨ mala sɨk ndɨna sɨk ana kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nat sɨk apma kɨpmamba ndandɨ. Ndandɨ, sɨk kwandɨ. Nat avamba sɨk ndumi tambanat kwandɨ. Nat avamba sɨk kɨta ndumi kuvuk kwandɨ. Nat avamba sɨk kɨta ndumi kiyeli tamba vɨli kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Apma maawut sɨka lɨgiya nyan kan mbutuwa nyaangɨtna angwa vak kat yelavɨka lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas mbutɨndɨ, wuka lɨga yalaa ndɨna mbaapmamba la nɨmba ndɨ kat wagalandi. Manda kat pagwuga mandɨt mandɨt nyaangɨpmba ndi kat mbutɨmɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas ndi kat wandɨ. nyinangwut tɨga nɨma nyan nɨn kat vɨga lɨndeya vatna angwa vak ngwuk kat tamba sɨmogwiwun. Nat nɨmba kat ana sɨmogwiwun. ");
INSERT INTO ian_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Apma maawut sɨka lɨgiya nyan nɨma sakwat nyaangɨt wutaa wan nyaangɨtna angwa vat wutaa yelavɨka lɨgiyandɨ. Ndɨ apma vat yelavɨka lɨndeyan ndɨnamba nɨma sakwat apma nyaangɨt tɨgiyandɨ. Apma maawut sɨtapman tɨgiya nyan nɨma sakwat nyaangɨt wutaa wan nyaangɨtna angwa vak ana yelavɨka lɨgiyandɨ. Apma nyaangɨt wuka lɨga yigumba yelavɨtapman yilaa waigandɨ. A. Mbutɨnja apma vak yigumba ana yelavɨkowun. Wun tungwengwan yiga lɨgowun waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngi vak kat tɨga ndi kat pagwuga mandɨp mandɨp nyaangɨtmba mbutɨwun. Ndi mɨni vɨga apma maawut yelavɨtapman tɨgandi. Ndi waan mɨna wuka apma maawut yelavɨtapman tɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wupma ana kwo yilɨgandi. Tamba la profet Aisaia pɨlɨwutnda vak vla wupma yilɨgandi. Tamba kupma pɨlɨwutndɨ. God wandɨ. Ngwuk waan mɨna wuka mɨni mɨna vɨga apma maawut yelavɨtapman tɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wundi nɨmba yelavɨka lɨga maawut apma maawut ana ndɨ yelavɨka lɨnja. Ndina waan tɨvɨlaa lɨgandɨ. Ndina mɨni kwita lɨgandɨ. Mɨni vɨga waan wutnjeyan ndi vɨga wuka yelavɨkiyandɨ wan apma vak kat. Vɨga wuka maawupmba yelavɨtaa wun kat vɨvat yandi maa ndi kat kwunakiyowun waa wandɨ God waa tamba pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ngwuk apma vat tɨgangwuk. Ngwuk mɨni vɨga waan wuka apma vat yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngwuk yelavɨk ngwula. Tamba la Godna njɨvwa kwuta nɨmbagwi profetno vɨlɨngwa vak ndino vɨvat walɨndi. Ana vɨlɨndi. Waamba wutɨngwa vak ndino wupmak walɨndi. Ana wutɨndi. ");
INSERT INTO ian_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Awuk ngwula. Kɨlɨnja ndand sɨk yaagi lɨga nyana pogwuga lɨga nyaangɨtna angwa kɨngiyan. Ngwuk kat mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Godna nyaangɨt wutaa maawupmba yelavɨka yetɨlapman yilɨga nɨmba ndi ava yambɨmba nda yuwi sɨk vla lɨgandi. nyaangɨt wuka lɨndi maa Seten yalaa wan nyaangɨt klalaa yiga pagwulɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Godna nyaangɨt wutaa ndi kwiyatapman klala nɨmba kambat ta tagu kɨpma kuvut ta kavamba nda yuwi sɨk vla lɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nɨmamba ana wan nyaangɨt kwutaa lɨgandi. manda kat wan nyaangɨt kwuta lɨgangwuk waa waliaga lɨga wanjeyan wan nyaangɨt kwagalagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kavle yuwi lɨga kavamba nda lɨga yuwi sɨk nat nɨmba vla lɨgandi. Ndi Godna nyaangɨt wutaa yigumba ana yelavɨka lɨgandi. Kan kɨpmamba lɨga kwanda kwanda klavak mɨna yelavɨka lɨgandi. Ndi God waa njɨvwa ana kwutɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Apma kɨpmamba nda lɨga yuwi sɨk nat nɨmba vla lɨgandi. nyaangɨt wutaa maawupmba yelavɨka God waa njɨvwa kwutɨgandi. Nat nyan sɨk ndumi tambanat kwa vak vla nɨma nglei sakwat apma njɨvwa kwukiyandɨ. Nat nyan sɨk ndumi kuvuk kwa vak vla nɨma sakwat apma njɨvwa kwukiyandɨ. Nat nyan sɨk kɨta ndumi kiyeli tamba vɨli kwa vak vla apma njɨvwa kwukiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas pagwuga nat nyaangɨtmba mbutɨndɨ ndi kat. Nyinangwupmba lɨga njambwi nyan nɨn kat vɨga lɨndeya vak kupma lɨgandɨ. Kɨta nyan ndɨna ambugapmba yuwi sɨk yaagindɨ, kandi waatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngan sɨndu kwandi maa ndɨna maama nyan yalaa ambugapmba kavle yuwi sɨk yaagindɨ. Yaagilaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kavle yuwi sɨkno apma yuwi sɨkno kɨta kandi waapɨk, kavle yuwi waataa lɨnda vak kat vɨndi. ");
INSERT INTO ian_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vɨlaa njɨvwa kwuta nɨmba yiga njambwi nyan kat mbutndi. Njambwi nyan mɨna ambugapmba kavle yuwina sɨk kandana yaagia. Ngi kandi waataa lɨndɨ vɨna kavle yuwi waa mbutndi maa njambwi nyan wutaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wuna maama nyan ngan yalaa wan kavle yuwi sɨk yaagindɨ. Wandɨ maa wandi. Wamɨn maa kavle yuwina kandi pɨka yaagiygiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Njambwi nyan wutaa kai wandɨ. Kavle yuwina kandi pɨpmak yingweyan apma yuwina kandio mbak pɨtangwuk. Ke yiga pɨka. Tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nɨma yilaa sɨk kwandɨ maa kɨlɨnja ywuina sɨk sɨgɨtɨga nyangu kat waigowun. Kavle yuwi tat pɨtaa saymba sangilaa yamba tulaa apma yuwi sɨk sɨgɨtaa wuna ngaymba yiga taaga waa waigowun waa wandɨ njambwi nyan waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas ndi kat pagwuga nat nyaangɨtmba mbutɨndɨ. Nyinangwupmba lɨga nɨma nyan ndinyangu kat vɨga lɨndeya vak mastet walɨnja sɨk vla lɨgandɨ. Wan sɨk mak nglei nda ndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kɨta nyan wan sɨk ambugavamba yaagindeyan waakiyandɨ. Kaawa ava vla waakiyandɨ. Nɨma sando lɨgiyandɨ. Waavi yalaa ndɨnamba ngay kwuka lɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas ndi kat pagwuga nat nyaangɨtmba mbutɨndɨ. Nyinangwupmba lɨga nɨma nyan ndinyangu kat vɨga lɨndeya vak yis vla lɨgandɨ. Kɨta lagwa yis kwutaa wit milmba taagalɨ maa kɨkɨk waga nɨma yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas wan nɨma sakwat ndu lagwa kat pagwuga nat nyaangɨtmba mɨna mbutɨndɨ. Kapmba ana mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wupma kwo ana mbutɨndɨ. Tamba Jisas kat kupma pɨlɨwutndɨ. Ndi kat pagwuga mandɨt mandɨt nyaangɨtmba mbukɨyowun. Tamba kɨpma kwutndɨ mala lɨndɨ, vɨlapman yilɨnja vak ndi kat vɨsɨmogwi kiyowun waa tamba pɨlɨwutndɨ tamba la profet. ");
INSERT INTO ian_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wan nɨma sakwat nɨmba Jisas kat kwagalalaa ndina ngay wuleindi. Ndɨna mbaapmamba la nɨmba mɨna ndɨnagwinala lɨndi. Tɨga lɨga ndɨ kat wandi. Kavle yuwi waat tɨga nyaangɨtna angwa nɨn kat ambuk mɨla waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas ndi kat wandɨ. Apma yuwi sɨk yaagi lɨga nyan wunayɨ God na vak sɨmogwi lɨga nyan. ");
INSERT INTO ian_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ambugat kan tɨna kɨpma. Apma yuwi sɨk God vɨga lɨga apma nɨmba ndi. Kavle yuwi Setena mbaapmamba lɨga nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kavle yuwi sɨk yaagilɨga wuna maama nyan Setena. Yuwi sɨk sɨgɨtnjeya njɨmbla ngɨni yaiga njɨmbla. Yuwi sɨk sɨgɨtɨga nɨmba ni ensel ndi. ");
INSERT INTO ian_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kavle yuwi pɨtaa saymba sangilaa yamba tunja vak vla ngɨni yaiga njɨmbla kavle nɨmba kat wupma yigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngɨni wun Godna vak sɨmogwi lɨga nyan wun ensel kat wowun maa ndi God vɨga lɨga kava kava yiga kavle nɨmba kat kwutaa man taamba sangilaa ");
INSERT INTO ian_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ya vɨtɨga kavamba yaagigiyandi. Nat nɨmba kat kavle vat ay walɨga nɨmba kat ndino ndi kat wupma sangilaa yaagigiyandi. Yaagindi maa nglaga nɨmbi ngliaka kavle savle lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wan njɨmbla Godna nɨmba ndi apma vat tɨgiyandi. Nat nɨmba ndi kat vɨlaa ndi apma nɨmba ndi waa waigandi. Ndina nyaek vɨga lɨga kava kava ndi vɨga lɨgandi. Mbutuwa vak wutaa ngwula maawupmba yelavɨk ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nyinangwutmba lɨga nɨma nyan ndinyangu kat vɨga lɨndeya vak kupma lɨgandɨ. Kɨta nyan kɨpmamba vaangunja apma kwanda kwanda yiga waangu vaga vɨndɨ. Vɨlaa ak wumba yambɨ kɨpma tegɨlɨlaa ndɨna kwanda kwanda aywaa kwilaa sanya klalaa yiga wan kɨpma sanya yaagilaa klandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nyinangwutmba lɨga nɨma nyan ndinyangu kat vɨga lɨndeya vak kupma lɨgnadɨ. Kɨta nyan nɨma sanyo lɨga apma bis kat kwatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kwaka yiga apma nglei bis vɨndɨ. Vɨlaa ndɨna kwanda kwanda aywaa kwilaa sanya klalaa yiga wan bis sanya yaagilaa kalndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nginangwupmba lɨga nɨma nyan ndinyangu kat vɨga lɨndeya vak njula vla lɨgandɨ. Njula yiga ngumba yisendalaa mandɨt mandɨt kami wan njulamba ndandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ndandɨ, kwuta nɨmbak kalindi. kalilaa apma kami mbaymba laagalaa kavle kami klalaa kai waa yaagilɨndi. ");
INSERT INTO ian_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngɨni yaiga nandinya wupma njulamba kwutnja kami vla lɨgiyangwuk. Nɨma nyana ensel yi ya apma nyangu kavle nyangu kat mbaapma vɨlɨlɨkmba viyaseli viyasela taagagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kavle nɨmba kat kwutaa ya vɨtɨga kavamba yaagigiyandi. yaagindi maa nglaga nɨmbi ngliaka kavle savle lzɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas ndi kat wagalandɨ. Mbutuwa nyaangɨt wutaa yelavɨka lɨgangwuk? Waa wagalandɨ maa awa wuka lɨganɨn wandi. ");
INSERT INTO ian_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jisas ndi kat wandɨ. Kɨta nyan Moses kwiya lo sɨmogwiga lɨga nyan nyinangwut tɨga nɨma nyana mbaapma wuleindyan wan nyan kɨngi vat tɨgiyandɨ. Kɨta nyan ndɨna ngayna kwanda kwanda taagalɨnda ngay wuleilaa tamba la nda kupi nda klalaa ndɨna ngay alagu ngemba taagandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas pagwuga mandɨt mandɨt nyaangɨt mbuka lɨga kwagalalaa laataa ndɨna angwa ngepmat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Angwa ngepma yilaa Juda nyaangɨt ngambulɨnja ngay wuleilaa ndi kat nyaangɨt mbutɨndɨ. Wuka la nɨmba ngɨipali walaa ndi awat sowat ngambulɨndi. Maawupmba yelavɨtɨnda vak ndɨ kat kandana kwiya. Kwunatɨnda nɨma njɨvwa mandamba kwutɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ndɨna nyaek ngay kwuta nyana. Ndɨ Mariana nyana. Jems, Josis, Saimon, Judas ndina nyamwun ndɨ. ");
INSERT INTO ian_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ndɨna nyange ndu nɨnogwinala yetɨlɨgandi. An yiga yetɨlɨnda vak andamba klandɨ waa awat sowat ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngambuga lɨga ndɨ kat kai wandi. jisas ndi kat wandɨ. God waa nyaangɨt mbutɨga nyan kwo ngepmamba lɨndeyan ndɨ kat apma maawut yelavɨka lɨgiyandi. Ndɨna angwa ngepmamba lɨndeyan ndɨna angwa ngepmana nɨmba ndɨ kat kai waigandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wungi kat tɨga ndɨna angwa ngepmamba apma nɨma njɨvwa ana kwutndɨ. Mat njɨvwa mɨna kwutndɨ. Ndina mbangɨ ndɨ kat vɨndi mala vali yindangat ana kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wan njɨmbla Galilina njambwi nyan Herot Jisas kwuta njɨvwa kat wutndɨ. Wutaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ndɨ nambu kalɨkwa ngu yagu la Jon. Kiyalaa lɨga laatndɨ. Kiyalaa lɨga laataa kwondu klalaa wan nɨma njɨvwa kwutɨgandɨ waa ndɨna kwupmba la nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tat Herot wandɨ maa Jon kat kwutaa man taamba sangilaa kalabusmba taagandi, lɨndɨ. Herotna yakwa nyan Filipna taagwa Herodias walɨ maa Jon kat kalabusmba taaga waa wandɨ Herot. ");
INSERT INTO ian_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tak ngu yagula Jon yalaa Herot kat walɨndɨ. Mɨna yakwa nyana taagwa sɨkwuka klama vat ana nglaatndɨ. Ndɨ ana wundumbu yindɨ. Kwo lɨgandɨ waa walɨndɨ maa ");
INSERT INTO ian_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot ndɨ kat vatnyavak kat yelavɨka lɨndɨ. Nɨma sakwat Juda ndi yelavɨtndi. Ndɨ ngu yagu lɨga Jon God waa nyaangɨt mbutɨga profetna waa yelavɨka lɨndi. Herot ndi kat vaaka lɨga Jon kat ana vatnyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herot kat kwutnja nandinya nɨma kɨgɨnda kwutndɨ. Kwutaa wandɨ, nɨma sakwat nɨmba yandi kwutnda kɨgɨnda kɨvak. Yandi maa Herodiasna taagwa nyan laataa mbangu veilɨlɨ maa vɨga lɨndi. Herot vɨga lɨga mbangu veila vak kat woviyaguga lɨga wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Klavat wanyeya nda wun kat mbukiyanyɨn. Nyɨn kat kwigiyowun. Woseka ana wowun wawa wandɨ Herot. ");
INSERT INTO ian_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lɨ yiga nyɨme kat wagalalaa yaa Herot kat walɨ. Ngu yagu la Jona nambu kalɨtaa wun kat yaanjɨmba taagalaa agwi walɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot wutaa Jona nambu kalɨpmak kat ndɨna mbangɨ kɨlɨp mbangɨ yindɨ. Woseka ana wowun waa wanda vat aywaa wumba la nɨmba wutndi. Ngi kat tɨga wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","yiga kalabusmba lɨndɨ, ndɨna nambu kalɨtndi. ");
INSERT INTO ian_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nambu kalɨtaa yaanjɨmba taagalaa Herodiasna taagwa nyan kat kwindi. Wan yaanjɨmba taagalaa kwinja nmbu klalaa nyɨmeat yiga kwilɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jona mbaapmamba la nɨmba nambu kalɨtnda vak kat wutaa yalaa Jona sɨm klalaa yiga waangumba valaa taagandi. Taagalaa Jisas kat yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mbutndi maa wutaa Jisas wan kava kwagalalaa ndinyangu lapman kavat njaambɨt kulaa yindɨ. Yinda vat wutaa nɨma sakwat nɨmba laataa ndɨ kat vɨvat yindi nɨmbumba. ");
INSERT INTO ian_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kawiga lɨga yanja vak kat vɨndɨ. Ndi kat vɨlaa miwa yiga lɨndi. Miwa yiga lɨga ndina yelogwen kat ta nɨmba kat kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wan nglaambu ndɨna mbaapmamba la nɨmba yalaa Jisas kat wandi. Kan kava kwo kava kɨgɨnda klaneya kava kai. Ngan lamba ndaiveigandɨ. Wamɨn maa ngepmat yilaa kɨgɨnda klaandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wandi maa Jisas ndi kat wandɨ. Ndi ana yigiyandi. Ngwuk ndi kat kɨgɨnda agwi ngwula waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","wandi. Nɨma kɨgɨnda nɨma sakwat ana lɨgandɨ. Nao tambanat kami vɨlɨlɨk mɨna lɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","19","Wandi maa Jisas wandɨ. Wan nao kɨgɨnda agwi ngwula wuna lak waa walaa nɨma sakwat nɨmba kat vɨlaa ngwuk yuwimba ndaa alɨ ngwula waa walaa wan nao kɨgɨnda klalaa tanambɨka vɨlaa God kat sɨvu kɨlaa wan nao tambɨ lambɨ lɨmbaga ndɨna mbaapmamba la nɨmba kat kwindɨ. Ndi yiga wan nɨma sakwat nɨmba kat kwindi. ");
INSERT INTO ian_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kɨlɨndi, yaat taatɨ. Kɨlambɨga kwagalanja nao kɨgɨnda aposel mbanimba tamba vɨli kiyeli vɨlɨlɨkmba naagandi. ");
INSERT INTO ian_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ka ndi nɨmbana sakwat 5,000 nɨmba. Taagwa nyangu kat ana sɨga nagundi. Ndu mɨna sɨga nagundi. ");
INSERT INTO ian_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas ndɨna kwupmba la nɨmba kat wandɨ. Njaambɨt kulaa yindi maa wan ndɨnai la kavamba la nɨma sakwat nɨmba kat wandɨ. Ngwuk ngepma ay ngwula wandɨ, yindi. ");
INSERT INTO ian_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yindi maa God kat nyaangɨt ngambuvat nduwiat wokendɨ. Wumba kapma lɨndɨ, ngan ndandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngan ndandɨ, kulaa yinja njaambɨt nɨndɨ sapmba lɨndɨ maa mwuk ndina ndaama njaambɨpmba viyalɨndɨ, nɨma pali laataa kiyalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngambi ngan Jisas tagu ngumba veiga ndi kat vɨvat yalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ndɨna kwupmba la nɨmba ndɨ kat vɨlaa vaaka kɨselaga wundumba yalɨga waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas ndi kat wandɨ. Ngwula maawut ke nɨmamba yelavɨka vakngwa. Wun Jisas wun yaa ngwuk kat vɨvat waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wandɨ maa wutaa Pita ndɨ kat wandɨ. Njambwi nyan mɨnayɨ? Mɨna lat tɨmeyan wun kat wamɨn maa ngu tagumba veiga mɨnai lɨga kavat yalu wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wandɨ maa Jisas yagwa wandɨ. Pita njaambɨt kwagalalaa ngu tagumba veiga yilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yiga lɨga mwuk pali kat vɨlaa vaaka yelavɨtaa lumaka ndaivat yindɨ. Lumaka ndaivat tɨga wandɨ. Njambwi nyan wun kat yaa kwutaa katso wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas yalaa ndɨ kat taambamba kwutaa katsolaa wandɨ. Mɨnai yelavɨka lɨga vat nɨma ana ndɨ. manda kat vapmɨn. Vapmangat tɨga lumaka ndaivat yimɨn waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","mbɨt njaambɨt yiga kumbɨt. kumbɨt maa kwuta mwuk pali kiyak wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kiyak wanda vak kat vɨlaa ndɨna mbaapmamba la nɨmba Jisasna sɨ kwutaa katsoga wandi. mɨn Godna nyan mɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Njaambɨpmba valɨgelaa Genesaret walɨnja ngempamba kawindi. ");
INSERT INTO ian_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kawindi maa wan ngepmamba la nɨmba Jisasna mɨndama vɨlaa yanda vak yiga mbutndi. Mbutndi maa ngepma ngepmamba yelogwen kat ta nɨmba kat aywaa kwutaa kiyandi. ");
INSERT INTO ian_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yelogwen kat ta nɨmba ndɨna waavwina njɨmbwi waavwi sɨnyɨpmak kat wagalandi. njɨmbwi waavwi sɨnyɨta nɨmba yelogwen kat ta nɨmba ndi kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Moses kwiya nyaangɨt sɨmogwi lɨga nɨmbo Ferisio Jerusalem kwagalalaa yalaa Jisas kat vɨlaa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Manda kat mɨna mbaapma nɨmba nɨna ngwat ndu tamba waa vapmba yetɨlapman yilɨgandi. Taamba njangi lapman manda kat kwo kɨlɨgandi waa wagalandi maa ");
INSERT INTO ian_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas ndi kat wandɨ. Ngwuk God waa nyaangɨt kat kwagalalaa ngwula ngwat ndu waa nyaangɨpmba yetɨlɨgangwuk. Ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tamba God wandɨ, “Ngwula nyaek nyɨme kat apma vat ay ngwula. Kɨta nyan ndɨna nyaek nyɨme kat kavle nyaangɨt ngambundeyan ndɨ kat vatnyagiyangwuk” waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngwuk Gerisi mandɨp vak yilɨgangwuk. Kɨta nyan wuna nyaek nyɨme kat kwunapmat kwiweya nda tamba God kat kwigiyowun waa wandeyan apma vatna nyaangɨt kai waa wangwuk. ");
INSERT INTO ian_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wun ngwuk kat wowun. God kat kwindeyan ndɨna nyaek nyɨme kat ndɨ kavle vat yigiyandɨ. God kat kwindeyan mbɨk kwanda kwanda lapman tɨga kavle savle lɨgiyambɨk. Wungi vak walɨngwa vapmba Godna nyaangɨt kwagalalaa ngwutna kavle maawupmba yelavɨka yetɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ngwuk woseka walɨga nɨmba ngwuk. Tamba la profet Aisaia ngwuk kat pɨlɨwutndɨ. Ndɨ woseka waga ana pɨlɨwutndɨ. kupma pɨlɨwutndɨ. Ndɨ woseka waga ana pɨlɨwutndɨ. Kupma pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God wandɨ. Wundi nɨmba ndina kwundimba wuna sɨ nɨma yindangat walɨgandi. Ndina maawupmba wun kat ana yelavɨtɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndi nambu sɨlandalaa wun kat maawupmba yelavɨtnja vak kwo vatnat tɨlɨgandɨ. Wunai waa nyaangɨt kwagalalaa ndinyangu mbukna nyaangɨt nat nɨmba kat sɨmogwiga mbutɨgandi. Kan God waa nyaangɨtna woseka waa waa pɨlɨwutndɨ Aisaia waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas nɨma sakwat nɨmba kat wandɨ maa yandi. Yandi maa ndi kat wandɨ. Ngwula waan wuka maawut yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndinyangu kɨgiya kɨgɨnda nda nyan kat ana kavle yigiyandɨ. Ndina kwundimba ngambunjeya kavle nyaangɨt wan nyaangɨt ndu nyan kat kavle yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wandɨ maa ndɨna mbaapmamba la nɨmba yalaa ndɨ kat wandi. Wama nyaangɨt kat wupmak kat Ferisi ndi kai wandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas ndi kat wandɨ. Nginangwupmba lɨga wuna nyaek ndɨ ambukat kwutɨgandɨ. Ndɨna ambukapmba nat nyan tugiya nda God ndɨ aywaa pɨka yaagigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ferisi kat ngwuk nɨma vak ke yelavɨkngwa. nat mɨni vɨlapman nyan kat yambɨ sɨmogwi lɨga mɨni vɨlapman nyan vla lɨgandi. Mɨni vɨlapman tɨgiya mbɨt vɨlɨlɨk palɨ yiga lɨga ava yambɨ kwagalalaa waangumba ndaigiyambɨk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ndɨ kat wandɨ. Ndu nyan kavle vat yigiya vak kat mbutɨma nyaangɨtna angwa nɨn kat sɨmogwi mɨla. Ana vɨga yelavɨka lɨganɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas ndi kat wandɨ. Nat nɨmbo ngwutno ana maawut sɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Maawut sɨtapman nɨmba vla lɨgangwuk. Ndinyangu kɨgiya nda yapmba wuleilaa tɨga kwo wogwegiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ndinyangu kwundimba ngambugiya nyaangɨt maawupmba yelavɨtaa ngambugiyandi. Wan ngambunjeya vak ndinyangu kat kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maawupmba lɨga kavle vak kɨngiyan. Ngwuk kat mbukwa. Nat nyan kat vatnya lɨnja vat, yambɨsɨk yilɨnja vat, kavle vat yilɨnja vak, sɨkwut tɨnja vak, woseka walɨnja vak, njɨka walɨnja vak. ");
INSERT INTO ian_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wan vak aywaa ndinyangu kat kavle yigiyandɨ. Ngwuk kat wanja vak taamba njangi lapman kɨngwa vak ndinyangu kat ana kavle yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas wan kava kwagalalaa Taiagwi Saidano walɨnja ngepma vɨlɨlɨk ta kavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wan ngepmamba yetak Kenemba la taagwa yalaa Jisas kat vɨlaa walɨ. Njambwi nyan, Devitna yelangɨ nyan, wun kat miwa ay mɨla. Wuna taagwa nyan kavle waagan tavila lɨndɨ maa kavle savle tɨgalɨ waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Walɨ, Jisas ana awat lɨ kat wandɨ. Ndɨna mbaapmamba la nɨmba vɨlaa yaa ndɨ kat wandi. Nɨna kwupmba yalaa nɨma kwundimba waa yilɨgalɨ. Lɨ kat wamɨn yigalɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Wandi maa Jisas wandɨ. Sɨlɨwata lɨga sip sip vla lɨga Juda kat mɨna kwunapmak yawun. Nyɨn Juda ana nyɨn. Nyɨn njambwi nyana nyan vla lɨgat taagwa ana nyɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wandɨ maa kwali mamba sɨlaa walɨ ndɨ kat. njambwi nyan wun kat kwunap mɨla waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas lɨ kat wandɨ. Njambwi nyan ndɨna nyangu kat kwindeya kɨgɨnda ndɨna waala kat kwindeyan ana nglaatndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wandɨ maa walɨ. Njambwi nyan ngiyambak wama. Kɨgɨnda kɨlɨnja njɨmbla kɨpmamba nda lɨga kɨlambɨ kɨgɨnda waala kɨlɨndi waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas lɨ kat wandɨ. Nɨnai yelavɨka lɨga vat nɨma ngleia. Kan wun kat wagalanya vat tɨgiyandɨ waa wandɨ Jisas. Wanda sɨvamba lɨla taagwa nyan apma vat kwo lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas wan kava kwagalalaa yiga Galili walɨnja sak tɨvagawi yiga nduwi wokelaa ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndaa lɨndɨ maa yelogwen kat ta nɨma sakwat nɨmba kat kwutaa ndɨnai la kavat kiyandi. Man kɨvɨ wakna nɨmba, mɨni vɨlapman nɨmba, ava tagwulia nɨmba, kwundi walapman nɨmba, mandɨt mandɨt yelogwen kat ta nɨmba ndi kat kwutaa Jisas ta kavat kiyandi. kiyandi, vɨlaa ndi kat kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kwunatndɨ maa kwundi walapman ta nɨmba kwundi ngambundi. Kɨvɨ watna man ta nɨmba laataa veiga yilɨndɨ. Ava tagwulia nɨmba ndino kwo lɨndi. Mɨni vɨlapman ta nɨmba mɨni vɨndi. Kwunatɨnda vak kat va nɨmba vɨlaa ngɨpali walaa Isrelna njambwi nyan God ndɨ apma vat nɨn kat kwunatndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tɨga lɨga Jisas ndɨna mbaapmamba la nɨmba kat wandɨ. Wundi nɨmba kat miwa yiga lɨgowun. Nandinya kuvuk wunogwinala tɨgandi. Kiyanja kɨgɨnda tamba aywaa ngɨlɨndɨ. Ndi kat kɨgɨnda kwilapman tɨga ay ngwula waa wavak kat kai wowun. Ay waweyan ava yambɨmba yiga lɨga mɨni ngangan yindɨ maa anagandi ndaiga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ndɨna mbaapmamba la nɨmba ndɨ kat wagalandi. Kan kava kwo kava. Ngepma kai. Ndi kat kwineya bret-nao andamba klaiganɨn. Ndi nɨma sakwat nɨmba ndi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wandi maa Jisas wandɨ. Ngwut taagala lɨngwa bret-nao angamala tɨgandɨ waa wandɨ maa bret-nao sɨla vɨli mat kami kuvut wupma taaganɨ, tɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jisas wandɨ maa wan nɨma sakwat nɨmba kɨpmamba ndaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bret-nao sɨla vɨli kami kuvuk klaa kwutaa God kat sɨvu kɨlaa wan nao lɨmbaga ndɨna mbaapmamba la nɨmba kat kwindɨ. Yalaa la nɨma sakwat nɨmba kat yiga kwindi. ");
INSERT INTO ian_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ndi aywaa kɨlɨndi, yaat taatɨ. Kɨlambɨnja kɨgɨnda Jisasna mbaapmamba la nɨmba klalaa mbani sɨla vɨli naangandi. ");
INSERT INTO ian_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ka ndi nɨmbana sakwat 4,000. Ndu mɨna nagindi. Taagwa mat nyangu kat ana nagindi. ");
INSERT INTO ian_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas wan kava kwagalalaa njaambɨt kulaa Magadan walɨnja ngepmat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ferisio Sadyusio yalaa Jisas kat vɨlaa yelavɨtndi. Ndɨ nyinangwupmba lɨga yandɨ? E? Nyinangwupmba lɨga ana yandɨ. Ndɨ kɨpmana nyana waa yelavɨtaa wandi ndɨ kat. Nɨma apma njɨvwa agwut. Kwupmɨn maa vɨlaa nyinangwupmba ya nyana waa yelavɨkiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisas ndi kat wandɨ. Nglaambu nya ndaindɨ, vɨlaa nyinangwut yelogwen mbangɨ lɨndɨ maa vɨlaa walɨgangwuk. nyinangwut yelogwen mbangɨ lɨgandɨ. Kinya meik ana ndaigandɨ waa walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ngambi nya wokendɨ, vɨlaa nyinangwut yelogwen mbangɨ lɨndɨ maa vɨlaa walɨgangwuk. Mbambala meik ndaigandɨ waa walɨgangwuk. Nyinangwut vɨlaa ngɨni yaiga meik mwuk tat vɨga lɨgangwuk. Manda kat kwutawa njɨvwa vɨlaa yetuwa vak kat ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kan mbambala lɨga ndu lagwu Godna vak vɨlapman kavle vat yiga yetɨlɨga nɨmba ndi. Nɨma apma njɨvwa agwup mɨla waa wun kat wangwuk. Ana kwukiyowun. Nɨma nyɨvwa kɨta mɨna kwuikiyowun. Tamba la nyan Jona kwukna vak vla mɨna kwukwun, vɨgiyangwuk waa wandɨ Jisas. Wandi maa Jisas kat kwagalalaa yindi. ");
INSERT INTO ian_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas ndɨna mbaapma nɨmbagwi njaambɨt kulaa sak valɨgendi. Kɨgɨnda klalapman maawut tɨvɨga kwagalalaa kwo yindi. ");
INSERT INTO ian_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas ndi kat wandɨ. Ferisiogwi Sadyusina bretmba taagalɨnja yis ke klaga. Kavle nda wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wandɨ maa ndɨna mbaapmamba la nɨmba awat sowat yelavɨka ngambulɨndi. manda kat kupma wandɨ. Kɨgɨnda klalapman yanangat anagandɨ waa waa yelavɨka ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ngambulɨnja vak kat wutaa wandɨ. Kɨgɨnda klalapman yangwa vak kat manda kat ngambulɨgangwuk. Kɨgɨnda kat manda kat nɨmamba yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Njambwi nyanat tuwa vat ngwuk ana nɨmamba yelavɨka lɨgangwuk. Tat bret-nao tambanat klalaa 5,000 ta nɨmba kat kwiwun maa kɨndi. Kɨndi mala kɨlambɨnja kɨgɨnda angamala mbanimba naangangwuk. ");
INSERT INTO ian_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nat njambɨ bret-nao sɨla vɨli klalaa 4,000 ta nɨmba kat kwiwun maa klalaa kɨndi. Kɨndi mala kɨlambɨnja kɨgɨnda mbani angamala naagangwuk. ");
INSERT INTO ian_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tat ngwuk kat wowun. Ferisogwi Sadyusina bretmba taagalɨnja yis ke klaga wowun. Kɨlɨnja bret-nao kat ana wowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wandɨ maa ndɨna mbaapmamba la nɨmba maawupmba yelavɨka lɨndi. Bretmba taagalɨnja yis kat ana wandɨ. Ferisio Sadyusio mbutɨga nyaangɨt ngwuk ke wuka waa wandɨ waa yelavɨkaw lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas Sisaria Filipai walɨnja ngepmana ngwayat yindɨ. Ndɨna mbaapmamba la nɨmbo ndɨno kɨta vat yindi. Jisas ndi kat wagalandɨ. Wun Godna vak sɨmogwi lɨga nyan wun kat ndu lagwa anda sɨmba walɨgandi waa wagalandɨ maa wandi. ");
INSERT INTO ian_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nat nɨmba ndɨ ngu yagu lɨga Jona waa mɨn kat walɨgandi. Nat nɨmba ndɨ Jeremaia waa mɨn kat walɨgandi. Nat nɨmba ndɨ profetna waa mɨn kat walɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ma Jisas ndi kat wagalandɨ. Ngwuk wun kat angamak walɨgangwuk waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pita ndɨ kat wandɨ. Mɨn nɨn kat kwunapmak ya nyan mɨn. Mɨn Godna nyan mɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wandɨ, Jisas ndɨ kat wandɨ. Saimon, Jonana nyan mɨn apma maawut yelavɨka lɨgamɨn. Maawupmba yelavɨtɨma vak nat nyanananmba ana klamɨn. Nyinangwupmba lɨga wuna nyaek mɨn kat mbutndɨ, wamɨn. ");
INSERT INTO ian_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mɨn kambak vla lɨgamɨn. Wuna mbaapmamba tɨgiya nɨmba kɨngi kambapmba veiga laataa lɨgiyandi. Wundumbu yinjeyan wuna mbaapmamba veilapman tɨgiya nɨmba ngɨni kavle yigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nginangwuk wuleilɨnja ndaamangemba lɨga mbapmona ki mɨna lak taagagiyowun. Kan kɨpmamba lɨga nɨmba kat kemapmeyan ndi ana wuleigiyandi. Kan kɨpmamba lɨga wuleigiyangwuk wameya nɨmba ndi wuleigiyandi waa wandɨ Jisas Pita kat. ");
INSERT INTO ian_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pita kat walaa ndɨna mbaapmamba la nɨmba kat aywaa ndi kat wandɨ. Ndinyangu kat kwunapmat ya nyan Kraistnat tuwa vat nat nɨmba kat ke mbukngwa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wan njɨmbla Jisas kɨta nyaangɨt ndi kat ngambundɨ. Ngambuga wandɨ. Samat tɨga Jerusalemat yigiyowun. Yiwun maa Judana njambwi nɨmbo God kat kwunatɨga njambwi nɨmbo Moses kwiya nyaangɨt sɨmogwi lɨga nɨmbo wun kat kwutaa kavle vat yigiyandi. Kavle vat yiga wun kat kwutaa vatnyagiyandi. Kiyalaa nandinya kuvut tɨga laakiyowun waa wandɨ maa wutaa ");
INSERT INTO ian_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ndɨ kat kwuknat kalilaa wandɨ. Njambwi nyan wama vat ana nglaatndɨ. Manda kat wupma wamɨn. Wan kavle vat mɨn kat wupma yilandi waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas Pita kat wandɨ. Seten mɨn wun kat kwagalalaa ay. yiweya yambɨ kat mɨn ke tɨvɨlɨga. Yelavɨtɨma vak Godna vak ana ndɨ. Ndinyanguna vakna yelavɨtɨma waa ndɨ kat walaa ndɨna mbaapmamba la nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kɨta nyan wuna mbaapma wuleivat wandeyan avla ndɨna mbangɨ kwunapmak kat kai walaa kwutuwa njɨvwa ndɨno kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kɨta nyan ndɨna mbangɨ kwunapmak mɨna yelavɨka lɨndeyan kavle yigiyandɨ. Kɨta nyan wuna njɨvwa kwuka yetɨga kiyandeyan ndɨ apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kɨta nyan kɨpmana kwanda kwanda nda aywaa klalaa kavle vat yiga yetɨndeyan wan apma vatna? Kai. Apma vat ana ndɨ. Kavle vatna. Njɨmbla njɨmbla apma vat tɨnjeya vat kɨta nyan wenga kwilaa ana klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wun Godna vak sɨmogwi lɨga nyan samat tɨga enselonala yaigowun. Wuna nyaek wun kat ndɨna kwondu kwindɨ maa yaigowun. Yalaa ndinyangu aywaa kwutɨnja njɨvwa kat wenga kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngwuk wutaa yelavɨk ngwula. Ngwutna nat nɨmba kwo lɨga njambwi nyanat tɨga yaweya vat vɨgiyangwuk. Wun Godna vak sɨmogwi lɨga nyan wun yaweya vak vɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nandinya sɨla kɨta yindɨ maa Jisas Pita Jems Jon nyamwun sambu ndi kat yagwa waa kwutaa nɨma nduwiat klo kalindɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wokelaa lɨga Jisasna mbangɨ mandɨt mbangɨ ngwandɨyandɨ, vɨga lɨndi. Ndɨna mɨndama nya vla sɨlɨndɨ, vɨndi. Ndɨna waavwi sawun glei mɨna lɨga kemba kava vla lɨndɨ maa vɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vɨlɨndi maa Mosesogwi Ilaijo yalaa ndɨnogwinala ngambuga lɨmbɨt, ndi kuvut nyangu tɨga lɨga vɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Vɨga lɨga Pita Jisas kat wandɨ. Njambwi nyan kan kava apma kava. Tɨnan apma vatna. Wamɨn maa kwapɨ mbale kuvuk kwukiyanɨn. mɨn kat kɨta Moses kat kɨta Ilaija kat kɨta kwukiyanɨn waa walɨndɨ maa ");
INSERT INTO ian_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","sawun mbangɨ tɨmbu ngaga yalaa tɨnja kava kapmandɨ. Tɨmbumba lɨga ndu nyana kwundi ngambulɨndɨ maa wutɨndi. Kwundi kupma ngambundɨ. Wan nyan wuna nyana. Ndɨ kat vɨga waa ngambundɨ wan kwundi. ");
INSERT INTO ian_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wan kwundi wutaa Jisasna mbaapmamba la ndi nyangu vaaka lɨga mɨndama mɨndama kɨpmamba ndalaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ndalaa lɨndi, Jisas yalaa taamba laagalaa ndi kat wandɨ. Ke vaaka lɨngwa. laak ngwula wandɨ, laatndi. ");
INSERT INTO ian_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Laataa ngambuga lɨnda mbɨt nyan kat ana vɨndi. Jisas kapma lɨndɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wan nduwi kwagalalaa ngaga yalɨndi maa Jisas ndi kat wandɨ. Wun Godna vak sɨmogwi lɨga nyan wan. Wun kiyalaa laakwun maa kan vɨngwa vak ngɨni nat nɨmba kat mbukiyangwuk. Kanmbambala ke yiga mbuka waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ndɨna mbaapmamba la nɨmba ngambunda nyaangɨt wutaa ndɨ kat wagalandi. Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba kupma walɨgandi. Kraist tat ana yaigandɨ. Ilaija tat yandɨ maa ngɨni Kraist yaigandɨ waa walɨgandi. Wupma manda kat walɨgandi waa wagalandi Jisas kat. ");
INSERT INTO ian_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas wagalanja vak wutaa ndi kat wandɨ. ngiyambak wanja. ilaija ndɨ tamba yandɨ. Yalaa Kraist yaiga yambɨ kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ilaija yandɨ, kan kɨpmamba la ndu lagwa Ilaija njambwi nyanat tɨnda vak kat ana vɨga lɨngi. ndina maawupmba ndɨ kat kavle vat yelavɨka kavle yindi. Ndɨ kat kavle vat yinja vat vla wuno Godna vak sɨmogwi lɨga nyan wun kat kavle vat yigiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas wanda nyaangɨt wutaa maawupmba yelavɨtndi. Ndɨ Ilaija walɨndan ngu yagu la Jon kat walɨgandɨ waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nduwimba lɨga ngaga yalaa nɨma sakwat ta nɨmba la kavat ndi yindi. Yindi maa kɨta nyan yalaa Jisasna mɨndama sambɨmba kwlai mamba sɨlaa ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wuna mat nondanyan kat miwa yilaa kwunap mɨla. Kavle waagan ndɨ kat tavila lɨandɨ. Kavle waagan ndɨ kat kwutndɨ maa mɨni ngangan yindɨ, kɨpmamba ndaa lɨgandɨ. Nat nɨma sakwat njambɨ yamba ndaa lɨgandɨ. Nat njambɨ ngumba yilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɨna mbaapmamba la nɨmba kat kwutaa kiyowun maa ana alɨpsɨga ndɨ kat kwunatndi waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas ndɨna mbaapmamba la nɨmba kat vɨlaa wandɨ. Ngwuk nɨmamba ana yelavɨtɨgangwuk. Ngwuk kavle vat yelavɨtɨgangwuk. Anda sakwat nandinya tɨga ngwuk kat sɨmagaga mbutɨwun mala nɨmamba yelavɨkiyangwuk. Nɨmamba yelavɨtapman yilɨngwa vak kat wupmak kat kai wowun. Wan nyan kat yiga kwutaa wuna lak agiya ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wan nyan kat kiyandi maa Jisas vɨlaa kavle waagan savɨlɨndɨ, yingɨ. Yindɨ maa wan nyan apma vat kwo lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wan nɨma sakwat ta nɨmba yindi maa vɨlaa Jisasna mbaapma nɨmba ndɨ kat wagalandi. manda kat kavle waagan alɨpsɨga nɨn savɨlɨlapman yinan waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wagalandi maa Jisas ndi kat wandɨ. God kat nɨmamba yelavɨka kwutaa lɨlapman yingwan kat tɨga wan kavle waagan kat savɨlɨlapman yingwuk. God kat nɨmamba yelavɨka lɨngja vat samat ngwutanamba tɨndeyan kan tɨga nduwi kat ay wangwuk, yigiyandɨ. God kat nɨmamba yelavɨka lɨngja vak kat nɨma sakwat vak kat ana wowun. God kat nɨmamba yelavɨka lɨngja vak samat ngwutnamba lɨndyan ngwuk nɨma nɨma njɨvwa kwukiyanngwuk. ");
INSERT INTO ian_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Kɨgɨnda kɨvak kat kai walaa God kat wagala lɨngweyan kɨngi vat tɨga waagan savɨlɨgiyangwuk waa wandɨ Jisas.) ");
INSERT INTO ian_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisasna mbaapmamba la nɨmba Galilimba yisolaa lɨndi maa ndi kat wandɨ. Wun Godna vak sɨmogwi lɨga nyan wun. Wun kat ngɨni kwutaa vatnyagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kiyalaa nandinya kuvut tɨga laakiyowun waa wandɨ maa wutaa ndɨna mbaapmamba la nɨmba nɨma maawut yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas ndɨna mbaapmamba la nɨmbo kapaneam walɨnja ngepmat yindi. Ngepma wuleindi maa Godna ngay kwunatɨnja takis sanya kla lɨga nyan yalaa Pita kat wagalandɨ. Ngwutna njambwi nyan takis sanya yaagilɨgandɨ? E? Ana yaagilɨgandɨ? Waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","26","Wagalandɨ maa Pita wutaa awa wandɨ. Walaa ngay wuleindɨ mala Jisas ndɨ kat wandɨ. Saimon mɨn angamak yelavɨka lɨgamɨn. Kan kɨpmana njambwi king anda nɨmbananamba takis sanya klalɨgandi. Ndina ngepma nɨmbananamba ana klalɨgandi. Nat ngepma nɨmbananamba mɨna klalɨgandi waa wandɨ. Jisas ngiyambak wamɨn wandɨ. Nɨn Godna ngepma nɨmba nɨn. Ngi kat tɨga nɨn Godna ngay kwunatɨnja takis sanya yaagilapman yineyan wan vat kwowa. ");
INSERT INTO ian_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yaagilapman yineyan nɨn kat kai waigandi. Ngi vak kat kai wowun. Ngi kat tɨga sak yilaa sɨngwa laagagiyamɨn. Tat kwupma kami kwutaa ndɨna ngaangamba sanya vɨlaa klalaa kwutaa agiya. Mɨna wugɨn wuna wugɨn sanya kwigiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jisasna mbaapmamba la nɨmba Jisas kat yalaa wagalandi. Nyinangwut wuleilaa anda nyana kwulaka nɨma nyanat tɨgiyaa waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wagalanja vat wutaa Jisas mat nyan kɨta kat yagwa wandɨ, yalaa ndina nɨndɨmba laataa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Lɨndɨ maa jisas ndi kat wandɨ. Ngwuk yelavɨk ngwula. Mbambala maawupmba yelavɨtɨngwa vak kwagalalaa kan mat nyan tɨga vla tɨlapman yingweyan nyinangwut ana wuleigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kɨta nyan wun nɨma nyan ana wun waa yelavɨka lɨga kan mat nyan tɨga v a tɨndeyan wan nyan nyinangwut wuleilaa nɨma nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kɨta nyan wuna njɨvwa kwuka kɨngi vat mat nyan kat apma vat yilɨndeyan wan yindeya apma vat wuna lak yaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisas ndi kat wandɨ. Kɨngi vat mat nyan vla lɨga nɨmba wun kat yelavɨtnja vak kat nat nyan kai wandɨ maa wun kat kwagalalaa yindeyan wan ana nglaatndɨ. Wan kai waa nyan kat nɨma kambak klalaa yaawmba tulaa kwapmba waataa ngumba yaagingweyan apma vatna. ");
INSERT INTO ian_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nat nɨmba kɨpmana nda kat vɨlaa wun kat yelavɨtɨnja vak kwagala lɨgandi. Kan kɨpmana nda kavle nda. Nat nɨmba wun kat kwagalagiyandi. Vɨlɨgowun. Wun kat yelavɨtɨga nɨmba kat kai walɨga nɨmba ndi wan nɨmba kavle klei nɨmba ndi. ndi kavle klei yigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kɨta nyana taambamba kwutɨnda kavle njɨvwa ndɨna maawupmba lɨga apma vak kat kwulatndeyan taamba kalɨka tɨgandɨ. Taamba lapman apma kavat tɨndeyan wovuna. Apma taamba lɨga kavle kava njɨmbla njɨmbla ya vɨtɨga kavat yindeyan kavle vatna. Kɨta nyan kavle kavat man veiga wan kavamba kavle njɨvwa kwutɨnda njɨvwa ndɨna maawupmba lɨga apma vak kat kwulatndeyan man kalɨkiyandɨ. Sambɨn tɨga apma kavat yindeyan apma vatna. man apma vat tɨndɨ, kavle kava njɨmbla njɨmbla ya vɨtɨga kavat yindeyan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kɨta nyan mɨnimba vɨnda kavle vat ndɨna maawupmba lɨga apma vak kat kwulatandeyan mɨni pɨnguga yaagigiyandɨ. Mɨni lapman kɨta naangɨ mɨnimba vɨga apma kavat yindeyan apma vatna. Mɨni vɨli apa apma vat tɨmbɨk, kavle kava njɨmbla njɨmbla ya vɨtɨga kavat yindeyan ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngwuk mat nyangu kat vɨlaa ndi kwo nda ndi waa ke yelavɨkngwa. Ndi kat vɨga lɨga ensel ngilɨga. Ndina ensel nyinangwupmba lɨga wuna nyaekagwi lɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Wun Godna vak ɨmogwi lɨga nyan wun. Wun sɨlɨwota la nɨmba kat aywaa kwunapmak kat yawun.) ");
INSERT INTO ian_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kɨta nyan sip sip l00 ndɨnamba lɨndɨ. Vɨga lɨndɨ. Kita yiga sɨlɨwotnda. Sɨlɨwotndɨ maa ndɨ angamak yigiyandɨ. Ngwuk angamak yelavɨkalɨgangwuk. Ngwuk kat waigowun. Samat tɨga 99 kwo lɨga sip sip kat ana vɨga lɨgiyandɨ. Sɨlɨwokna sip sip kat kwaka yigiyandɨ nat sip sip kat kwagalalaa. Kwagalalaa yinda sip sip kwo lɨga yuwi kɨga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kwaka yiga vɨlaa solat sɨngɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sip sip kat vɨga la nyan ta vak vla ndɨno nyinangwupmba lɨga ngwutna nyaek God wupma vɨga lɨgandɨ. Ndɨna nyangu mbaak sɨlwatandi walɨgandɨ God. ");
INSERT INTO ian_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mɨnogwinala kɨta vat wuna mbaapmamba la nyan mɨn kat kavle vat yindeyan ndɨ kat vɨlaa kavle vat yinda vak kat ngambu mbɨla. nat nɨmba kat ke mbuka. Ngambuma nyaangɨt wutndeyan wovuna. Ndɨ kat tamba kwunapmɨn. ");
INSERT INTO ian_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wupmak kat kai wandeyan mɨna mbaapmamba la kɨta nyan o vɨlɨlɨk palɨ kwutaa yiga ndinogwinala kɨta vat tɨga ndɨ kat nyaangɨt ngambu ngwula. Tamba la nɨmba God waa nyaangɨt kupma pɨlɨwutndi. Vɨlɨlk pali o kuvut nɨmba kɨta nyaangɨpmba ngambungweyan wovuna. Ngambungweya nyaangɨt kwo valat ana tɨgiyandɨ waa tamba pɨlɨwutndi. Tamba pɨlɨwutnja nyaangɨt vla ngambu ngwula. ");
INSERT INTO ian_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kuvut nɨmba ngambu nyaangɨt wupmak kat kai wandeyan kɨta vat mbaapmamba lɨngwa nɨmba kat aywaa mbukiyangwuk. Kavle vat yinda vak kat wukiyandi. Ndina nyaangɨt wupmak kat kai wandeyan ndɨ maama nyana waa ndɨ kat yelavɨk ngwula. Ndɨ takis sanya klalɨga kavle nyan vla lɨgandɨ waa ndɨ kat yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ngwuk kat wowun. Kan kɨpmamba kɨta nyan kavle vat yiga yetɨnda vak kat kwunatapman yingweyan nyinangwupmba lɨga nyaek God ndɨno ana kwunakiyandɨ. kɨpmamba lɨga yinjeya kavle vak kat kwunakngweyan nyinangwupmba lɨga nyaek God ndɨno kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ngwuk kat nat samak nyaangɨt mbukiyowun. Ngwutna vɨlɨlɨk palɨ kɨta maawupmba yelavɨka lɨga God kat kwi nda kwindangat wagalambeyan wuna nyinangwupmba lɨga nyaek wagalambeya nda mbɨk kat kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vɨlɨlɨk palɨ kuvut nɨmba kɨta yisolaa lɨga wuna sɨ waga ngambulɨngjeyan wuno ndina nɨndɨmba kɨta vat tɨgiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita yalaa Jisas kat wagalandɨ. Njambwi nyan wuna mbaapmamba la nyan anda sakwat njambɨ wun kat kavle vat yindɨ, vɨlaa ndɨnai yindeya kavle vat sɨlɨmbwigiyowun. Njambɨ sɨla vɨli ndɨna kavle vat sɨlɨmbwiweyan wovuna? Waa wagalandɨ Pita. Wagalandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kai la. Sɨla vɨla njambɨ kai. 490 njambɨ yindeya kavle vak kat vɨlaa sɨlɨmbwimeyan wovuna waa wandɨ Jisas. Anda sakwat njambɨ sɨlɨmbwigiyowun waa wanda nyaangɨt wutaa Jisas wupuseput mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nyinangwupmba lɨga njambwi nyan ndinyangu kat vɨga lɨndya vat kɨngi vat tɨgandɨ. Tamba njambwi king kɨta lɨndɨ. Ndɨna njɨvwa kwuta nɨmbana dinau aywaa kwunataa kalɨpmak kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dinau kat kwunaka kalɨka sɨlɨmbwiga yilɨndɨ, kɨta nyan nɨma nglei dinau la nyan kat kwutaa kingat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngi kat tɨga njambwi king wandɨ. Ndɨna kwanda kwanda aywaa ndɨna nyan taagwa aywaa kwilaa wenga klalaa wan dinau kat agwi. Ndɨno ndɨ kat kwilaa wenga klalaa wun kat agwi waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","njɨvwa kwuta nyan kwali mamba sɨlaa nambu sɨlandalaa king kat wandɨ. Wun kat miwa ay mɨla. Ngɨni yuwa inau aywaa kwigiyowun waa ndɨ kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","King wutaa miwa yilaa ndɨna dinau kat kai waa kwagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kwagalandɨ mala laataa wogwendɨ. Wogwelaa ndɨnogwi kɨta vat njɨvwa kwuta nyan kat vɨndɨ. Vɨlaa kwapmba kwutaa ndɨ kat wandɨ. Mɨn tamba la wuna mat dinau kat agwi mɨla wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wandɨ maa nat nyan wandɨ. Samat kawiga alɨ. Kwigiyowun wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kawiga lɨvak kat kai walaa ndɨ kat kwutaa yiga kalabusmba taagandɨ. Dinau kat kwimeyan mɨna kalabus ngɨlɨgiyandɨ walaa ndɨ kat kalabusmba taagandɨ. ");
INSERT INTO ian_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kɨta vat njɨvwa kwuta nat nɨmba yinda vak vɨlaa kavle vat yindɨ waa yelavɨtaa njambwi king kat yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","King wan nyaangɨt wutaa ndɨna njɨvwa kwuta nyan kat yagwa wandɨ, yandɨ. Yandɨ maa king ndɨ kat wandɨ. Mɨn kavle klei nyan mɨn. Wun kat yima nɨma nglei dinau wun kat yaa wagalamɨn maa kai waa kwagalawun. Mɨnagwi kɨta vat njɨvwa kwuta nyan ndɨ kat ana miwa yigamɨn. Mɨn kat tamba miwa yiga kai waa nɨma dinau kwagalawun. Ndɨ kat wupma ana miwa yiga mɨn kat yinda mat dinau kwagalamɨn. ");
INSERT INTO ian_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mɨn kat miwa yiga luwa vak vla manda kat nat nyan kat miwa yilapman yimɨn. Mɨn kavle keli nyan mɨn waa wandɨ njambwi king. ");
INSERT INTO ian_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Njambwi king nyingi maawut tɨga wandɨ maa ndɨna njɨvwa kwuta nyan kat kwutaa yiga kalabusmba taagandi. Dinau kat kwimeyan mɨna kalabus ngɨlɨgiyandɨ walaa ndɨ kat kalabusmba taagandi. ");
INSERT INTO ian_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kan ngwuk kat wawa wapuseputna angwa nyaangɨt yelavɨk ngwula. Ngwutna mbaapmamba lɨga nɨmba ngwuk kat kavle vat yinja vat kat kai waa kwagalalapman yingweyan nyinangwupmba lɨga wuna nyaek kavle vat yingwa vat kat ana kai waa kwagalagiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas wan nyaangɨt ngambulaa Galili kwagalalaa Judiat yindɨ. Jodan walɨnja ndandangɨ nat naangat yindi. ");
INSERT INTO ian_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɨma sakwat nɨmba ndɨna kwupmba yindi. Yindi maa ndina yelogwen kat vɨlaa Jisas kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nat Ferisi ndɨ kat yalaa wagalangeya vak kat anagandɨ mandɨp vapmba ngambugiya waa yelavɨtaa ndɨ kat wagalandi. Moses kwiya nyaangɨt angamak wandɨ. Kɨta nyan ndɨna taagwa kat kwo kwagalandeyan wovuna? waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas wuta wandɨ. Tamba God wandɨ, pɨlwutnja nyaangɨt ngwuk ana vɨngwuk? Tamba God ndu lagwa kat kwutaa kɨpmamba laagalaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ndu ndɨna nyaek nyɨmena ngay kwagalalaa yiga ndɨna tagwonala yetɨgiyandɨ. Ndu taagwa kɨta vat tɨgiyambɨt waa wandɨ God waa tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndu taagwa klandeyan kapma kapma mbangɨ ana ndɨ. Mbɨk kɨta mbango lɨgiyambɨt. Mbɨla mbangɨ kɨta mbɨk kɨta nyan mbɨk. God mbɨk kat sangindɨ, lɨgambɨt. Ndu ndɨna taagwa kat ana kwagalagiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ferisi wanda nyaangɨt wutaa ndɨ kat wagalandi. Wama nyaangɨt ana nglaatndɨ. Tamba Moses wandɨ. Kɨta nyan pepa pɨlɨwutaa taagwa kat kwilaa kwo kwagalagiyandɨ waa Moses tamba pɨlɨwutndɨ. Manda kat wupma pɨlɨwutndɨ waa wandi. Wandi maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kavle savle tɨngwa vak kat vɨlaa ngwuk taagwa kwagalavak kat pepa taagwa kat kwilaa kwagalagiyangwuk waa wandɨ Moses. Tamba God ndu lagwa kat kwuta njɨmbla ndu taagwa kat kwagalanjeya vak wupma ana lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngwuk kat wowun. Kɨta nyan ndɨna taagwa kat vɨvak kat kai waa kwo kwagalalaa nat taagwa kat klandeyan ndɨ wan nyan wupma yindeya vak yambɨsɨk taagwa kat yinjeya vak vla lɨgandɨ. Ndɨna taagwa sɨmblan wangɨga yetɨlɨ, vɨlaa kwagalandeyan nyaangɨt kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas wandɨ maa ndɨna mbaapmamba la nɨmba ndɨ kat wandi. taagwa klaga lɨgiya nyan ndɨna taagwa kat kai waa kwagalagiyandɨ. Nɨna ngepma vatna. Ngwut taagwa kat ke kwo kwagalaga waa wama nyaangɨt apma vat tɨndeyan taagwa klalapman tɨgiya nyan mɨna apma vat tɨgiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas ndi kat kupma wandɨ. Taagwa klalapman vat aywaa wupma ana yilɨgandi. Nat nɨmba kat mɨna wan vak God kwilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Taagwa klalapman tɨnja vatna angwa nɨma sakwat tɨgandɨ. Nat nɨmba ndina maawupmba yelavɨtaa taagwa kla vak kat kai walɨgandi. nat nɨmba na alɨpsɨga klalɨgandi. Nat nɨmba nɨn Godna njɨvwa mwna kwuka yetɨga taagwa ana klaiganɨn waa walɨgandi. Ndinyangu aywaa wupma ana yilɨgandi. Taagwa kat klalapman yigiya nɨmba mɨna kan nyaangɨt awuk ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jisas ndina nambumba taamba laagalaa God kat wagalandangat nɨma sakwat mat nyangu kat nyaek nyɨme kwutaa kiyandi. Kiyanja vak kat vɨlaa Jisasna mbaapmamba la nɨmba kai wandi. ");
INSERT INTO ian_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kai wanja vak kat wutaa Jisas ndi kat wandɨ. Ke kai wangwa. Nyinangwupmba lɨga apma nda kɨndigi mat nyangu tɨga vla tɨgiya nɨmba klaigandi waa walaa ");
INSERT INTO ian_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ndina nambumba taamba taagandɨ. Taagalaa lɨga wan kava kwagalalaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kɨta nyan Jisas la kavat yalaa wagalandɨ. Sɨmogwi lɨga nyan, kan kɨpmogwi njɨmbla njɨmbla nyinangwupmba apma vat tɨweya vak klavak kat angamak njɨvwa kwukiyowun waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wandɨ maa Jisas ndɨ kat wandɨ. Apma nda klavak kat manda kat wun kat wagalamɨn. Kan kɨpmamba apma nyan ana lɨgandɨ. God ndɨ kɨta nyan mɨna apma nyan tɨgandɨ. Tamba God wandɨ, pɨlɨwutnja nyaangɨpmba wuka yetɨmeya njɨmbla njɨmbla apma vat tɨmeya vat klaigamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Manda nyaangɨt kat wamɨn God waa nyaangɨt waa Jisas kat wagalandɨ. Jisas wutaa wandɨ ndɨ kat. Nat nyan kat ke vatnyaga, yambɨsɨk ke yiga yetɨmeya, ke sɨkwuka, nat nyan kat woseka ke waga, ");
INSERT INTO ian_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nyaek nyɨme mɨn kat waiga nyaangɨt awup mɨla. Avla mɨna mbangɨ kwunatɨma vak vla nat nɨmba kat kwunap mɨla waa tamba God wandɨ, pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wan nyan wutaa wandɨ. Wama nyaangɨt aywaa wuka yetɨlɨgowun. Nat anda njɨvwa kwukweya waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ndɨ kat wandɨ. Kwupmeya nat njɨvwa kita lɨgandɨ. Wan njɨvwa kwutaa apma vat tɨgiyamɨn. Mɨna kwanda kwanda aywaa kwilaa wenga yiga klalaa sanya lapman tɨga nɨmba kat agwi mɨla. Kwilaa nyinangwut wuleimeyan apma wenga klaigamɨn. Ndi kat kwilaa wuna kwupmba yagwa mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wan kwandɨ nyan wutaa ndɨna mbangɨ valɨ yilɨndɨ maa yindɨ. Ndɨna kwanda kwanda nɨma sakwat nda kat kwagalavak kat kai waa yelavɨka yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yindɨ maa Jisas ndɨna mbaapmamba la nɨmba kat wandɨ. Ngwuk kat wowun. Nɨma sakwat sanya nɨma sakwat kwanda kwanda la nyan nyinangwut wuleindeyan nɨma njɨvwa. ");
INSERT INTO ian_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bulmakau vla lɨga kamel kumbwi mbawna yambɨ wuleivat tɨndeyan njɨvwa lɨgandɨ. Nɨma sakwat kwanda kwanda ndo lɨga nyan nyinangwut wuleivat tɨndeyan nɨma nglei njɨvwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wandɨ maa wutaa ndɨna mbaapmamba la nɨmba ngɨpaliga ndalaa ndɨ kat wagalandi. Nyinangwut kandana wuleiya waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas ndi kat vɨlaa wandɨ. Ndinyangu nat nɨmba kat kwutaa nyinangwutnat ana kaligiyandi. Wan Godna njɨvwa. Ndɨ alɨpsɨga kaligiyandɨ. Ndɨ nɨma nglei njɨvwa kwukiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wandɨ maa Pita Jisas kat wandɨ. Awut. Wutaa yelavɨk. Nɨna kwanda kwanda nda aywaa kwagalalaa mɨna kwupmba laataa yinɨn. Ngɨni anda wenga klangeya waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas wutaa wandɨ. Ngwuk kat wowun. Ngɨni yaiga nandinya kupi nda lɨgiya nandinya wun Godna vak sɨomgwi lɨga nyan yalaa wuna njambwi tɨkɨtmba ndaa lɨga ndinyangu kat vɨga lɨgiyowun. Njambwi nyanat tɨgiyowun. Ngwutno tamba vɨli kiyeli vɨlɨlɨk yelangɨ kat vɨga lɨgiyangwuk. Ndina njambwi nɨmbat tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kɨta nyan wuna njɨvwa kwupmak ndɨna ngay nyamwun nyange nyaek nyɨme nyangu ambukat kwagalandeyan ngɨni yaiga nandinya mandɨt nda nɨma sakwat klaigandɨ. Klalaa njɨmbla njɨmbla apma vat tɨndeya vat klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mbambala kɨpmamba lɨga nɨma sakwat ndo lɨga nɨmba ngɨni yaiga nandinya ndi kwanda kwanda lapman nɨmbat tɨgiyandi. Mbambala kɨpmamba lɨga kwanda kwanda lapman nɨmba ngɨni yaiga nandinya ndi nɨma sakwat ndo tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas wandɨ. Nyinangwupmba lɨga njambwi nyan ndinyangu kat vɨga lɨnda vat kɨngi vat tɨgandɨ. Kɨta nyan nɨma ambugavo lɨndɨ. Ngambi ambugatna nyan laataa njɨvwa kwut nɨmba kat kwaka yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yiga vɨlaa ndinyangu kat wandɨ. Nandinya kɨta njɨvwa kwukngweyan ngwuk kat dola kɨta kwigiyowun wandɨ. Wutaa wovuna walaa njɨvwa kwupmat yindi. ");
INSERT INTO ian_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngambi 9 klok laataa ngepma yiga njɨvwa kwut nɨmba kat kwaka wavat nat njambɨ yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kwaka yiga kwo la nɨmba kat vɨlaa wandɨ. Wuna ambugapmba yiga njɨvwa kwukngweyan ngwuk kat wenga kwigiyowun wandɨ. Wandɨ maa yindi. ");
INSERT INTO ian_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nɨma nɨndɨ nandinya ak laataa ngepma yindɨ. Nglaambu 3 klok at ngepma yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nglaambu 5 klok laataa ngepma yindɨ. Yilaa kwo la nɨmba kat vɨlaa ndi kat wandɨ. Ngwuk manda kat njɨvwa kwutapman kwo laataa lɨgangwuk waa wagalandɨ maa wandi. ");
INSERT INTO ian_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nɨn kat nat nyan njɨvwa ana kwindɨ waa wandi maa wuna ambugapmba yiga njɨvwa agwut ngwula wandɨ. Wandɨ maa yindi. ");
INSERT INTO ian_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nglaambu ndɨna ambugat vɨga la nyan kat wandɨ. Njɨvwa kwuta nɨmba aywaa yandi maa ndi kat sanya agwi mɨla. Ngɨni njɨvwa kwupmat ya nɨmba tat ndi kat sanya agwi. Ngambi tata njwvwa kwupmat ya nɨmba kat ngɨni sanya agwi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nglaambu 5 klokmba yiga njɨvwa kwukna nɨmba kat dola kɨta kɨta njɨvwa kwutaa nyangu kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngambi tata yiga njɨvwa kwukna nɨmba vɨlaa nɨn nɨma sakwat dola klaiganɨn waa maawupmba yelavɨtndi. Wupma ana klandi. Dola kɨta mɨna klandi. ");
INSERT INTO ian_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dola kɨta klalaa wan ambugatna nyan kat njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kɨndi nɨmba nglaambu yalaa wan ana nɨma njɨvwa kwutndi. Nɨma njɨvwa ana kwutndi. Nɨn ngambimba yalaa kan njɨvwa kwutɨnɨn nɨna mbangɨ nya nɨmamba sɨlɨndɨ nɨma waangɨt soga kwutɨnɨn. Nɨnogwi ndi kat manda kat kɨta wengamba kwimɨn waa njɨka wandi ndɨ kat. ");
INSERT INTO ian_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wanja vak wutaa ndina kɨta nyan kat wandɨ. Wuna ava nyan wuna kɨta nyaangɨt awup mɨla. Mɨn kat ana woseka waa kavle wenga kwiwun. Ngambi mɨn kat wowun. Mbambala njɨvwa kwupmeyan dola kɨta mɨn kat kwigiyowun waa wowun maa wovuna yiga mɨna njɨvwa kwukiyowun wamɨn. ");
INSERT INTO ian_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Klama dola kwutaa ngay ay. Ngɨni njɨvwa kwupmak ya nyan kat mɨn kat kwiwa wenga vla ndɨ kat kwiweyan wuna vatna. Mɨna vak ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kwiweya sanya wuna sanya kwiweya. Wuna maawupmba yelavɨtaa kwiweyan mɨn nyaangɨt kai. Ndi kat kwo kwiweya vak kat manda kat mɨn kai wamɨn. Wuna vatna waa wandɨ ambugatna nyaek. ");
INSERT INTO ian_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nyinangwut wuleigiya nɨmba ndino wupma klaigandi. Tat mat nyan tɨga Godna njɨvwa kwuka nɨma sakwat naambi tɨga kiyalaa nyinangwut wuleinjeyan ngɨni God ndi kat wenga kwigiyandɨ. Avɨt ndu lɨga Godna njɨvwa kwuka naambi kuvut tɨga kiyalaa nyinangwut wuleinjeyan tak God ni kat wenga kwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalem yiga lɨga nat nɨmba kat kwagalalaa ndɨna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ngwuk awuk ngwula. Mbambala Jerusalem yigiyanɨn. Wun Godna vak sɨmogwi lɨga nyan wun kat kwutaa God kat kwunatɨga njambwi nɨmbo Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba lɨga kavat kaligiyandi. Ndi wun kat waigandi. Ndɨ kat kwutaa yiga vatnya waa wun kat waigandi. ");
INSERT INTO ian_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wandi maa Juda ana ndi nat nɨmba wun kat kwutaa njɨka waga viyalaa diwai krosmba kaalagiyandi. Kiyalaa nandinya kuvut tɨga laakiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedina nyan vɨlɨlɨkna nyɨme mbɨk kat kwutaa Jisas ta kavat kiyalaa nambu sɨlandalaa Jisas kat kɨta nda kat wagalavat tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wagalavat tɨlɨ maa anda nda wun kat wagalanyɨn wandɨ. Wat taagwa walɨ. Ngɨni kingat tɨga nɨma tɨgɨtmba ndaa lɨmeya njɨmbla wuna mbɨt nyan nat nyan yaagindan naangɨmba ndaa lɨga njambwi nyanat tɨndangat ndaa lɨga njambwi nyanat tɨndangat mɨn kat wagalawun waa walɨ. Walɨ maa wutaa Jisas mbɨk kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wagalamba vat mbɨtna maawutmba yigumba yelavɨtapman tɨga wun kat wagalambɨk. Wun kat yinjeya nɨma vat vla mbɨk kat wupma yivat tɨnjeyan yinjeya nɨma vat vla mbɨk kat wupma yivat tɨnjeyan wun kat kwagalagiyambɨt? waa wagalandɨ maa wambɨt. Kai mɨn kat ana kwagalagiya waa wambɨt. wambɨt maa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Awa luwa. Wun kat kavle yinjeya vak vla mbɨk kat wupma kavle yigiyandi. Yaagindan naangɨ ambugendan naangɨmba ndaa lɨgiya nɨmba kat wun ana waigowun. Wuna njɨvwa ana ndɨ. Wan njɨvwa wuna nyaek mɨna kwutɨnda njɨvwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jisasna mbaapmamba la tamba vɨli nɨmba wutaa nyingi maawut yelavɨka mbɨk kat waleavat tɨndi. ");
INSERT INTO ian_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas yagwa ngwula wandɨ, yalaa yisolaa lɨndi, ndi kat mbuka wandɨ. Kan kɨpmamba la njambi nɨmba nat nɨmba kat mandɨp mandɨp vapmba vɨga lɨga nɨna njɨvwa agwuk ngwula waa nɨma kwundimba walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Ngwuk wungi vat njɨvwa wana kwutɨngweya. Ngwutna kɨta nyan njambwi nyanat tɨvat wandeyan nat nɨmbana njɨvwa kwuka ndina nyaangɨt wukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wuno Godna vak sɨmogwi lɨga nyan wungi vat njɨvwa kwutɨgowun. Wuna njɨvwa nat nɨmba kwutnjangat ana yawun. Ndi kat tɨga njɨvwa kwupmat yawun. kwo luwa vat kwagalalaa kiyalaa nat nɨmba kat wenga kwivat yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jeriko kwagalalaa yindi maa Jisasna kwupmba nɨma sakwat nɨmba yindi. ");
INSERT INTO ian_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mɨni kiyandɨ ta mbɨt nyan ava yambɨ waymba ndaa lɨga Jisas yanda vak kat wutaa nɨma kwundimba walega wambɨt. Jisas mɨn Devitna yelangɨ nyan mɨn. An kat miwa ay mɨla waa walega wambɨt. ");
INSERT INTO ian_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Walɨmbɨt mala wan nɨma sakwat ya nɨmba wutaa mbɨk kat wandi. Mbɨk kiyak awa mbɨla walɨndi, wuka kwagalalaa nɨma kwundimba walega walɨmbɨk. Jisas mɨn Devitna yelangɨ nyan mɨn. An kat miwa ay mɨla walɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas yiga lɨga tamataa mbɨk kat wandɨ. Mbɨk kat manda yiwangat walɨgambɨk. ");
INSERT INTO ian_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wandɨ mala wambɨt. Njambwi nyan. Ana mɨni kwunapmangat mɨn kat walega walɨgali waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas wutaa mbɨk kat miwa yilaa mbɨtna mɨnimba taamba taagalaa kunatndɨ mbɨk kat. Apma mɨni bɨlaa laataa Jisasna kwupmba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalem yiga lɨga Jerusalemna ngwaymba la ngepma Betfasi yandi. Wan ngepma Oliv walɨnja nduwi waymba lɨgandɨ. Yalaa lɨga Jisas ndɨna mbaapmamba la mbɨt vɨlɨlɨk palɨ kat wandɨ. Mbɨk tata ay mbɨla. ");
INSERT INTO ian_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ngepma wuleilaa donki nyano nyɨmeo yaawumba tndi, kwambɨt, yiga vɨlaa svugiga kwutaa wuna lak agiya. ");
INSERT INTO ian_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sɨvugimbeya vak vɨlaa mandana yilɨmba waa kɨta nyan wandeyan ndɨ kat awamba mbɨt. Nɨma nyan wandɨ mala yaa kalivat yigali waa awamba mbɨt. Wupma wambeyan kali waa waigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas wupma kwo ana wandɨ. Tamba la profet pɨlɨwutnda vak vla wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tamba la profet kupma pɨlɨwutndɨ. Jerusalemba lɨga nɨmba kat yiga ambuk ngwula. Ngwula king kɨngi tamba yalɨga. Ndɨna sɨ avla ana kwutaa katsogiyandɨ. Nyan donkina mbunimba ndaa lɨga yalɨgandɨ waa yiga ambuk ngwula waa tamba la profet pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisas mbɨk kat tata ayt mbɨla wandɨ maa tata yimbɨk. Yilaa wanda vapmba yiga kwupmbɨk. ");
INSERT INTO ian_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wutaa doni nyɨmeo nyano kiyambɨk. kiyambɨk maa ndina mbangɨmba kwusoga yinja waavwi njeguga donkina mbunimba taagandi. Taagandi, Jisas nyan donkina mbunimba ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɨma sakwat nɨmba Jisas yigiya ava yambɨ kat alagumba kwusola lɨnja waavwi lapmiga klalaa ava yambɨmba taagandi. Nat nɨmba mi sandɨ kalɨtaa ava yambɨmba taagandi. ");
INSERT INTO ian_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ndɨna kwupmba la nɨmba, ndɨna mɨndama sambɨmba la nɨmba, nɨma kwundimba kiselaa walɨndi. Devitna yelangɨ nyan nɨn kat vɨvat yandan apma vat yandɨ. God wandɨ maa yandɨ. Wan apma vatna yanda. God nɨn kat apma vat kwiga kwunatɨgandɨ waa kɨselaa walɨndi. ");
INSERT INTO ian_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jerusalem wuleindɨ maa ngepmamba yisolaa la ndu lagwa ngɨpaliga walaa laataa nɨmamba kɨselaa wandi ndɨ kat. Wan anda nyana yaa waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jisasonala yalaa yisola la nɨmba ndɨ kat wandi. Ndɨ Jisas profetna. Ndɨna ngepma Nasaret. Galilina ngepma waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas Godna ngay wuleilaa wenga kla la nɨmba kat vɨlaa savɨlɨndɨ maa laataa yindi. Nat nɨmba ngepma ngepmana sanya klalaa Judana sanya kwila nɨmba. Ndina njamba kwutaa kungwamatndɨ. Namio kat wenga wila nɨmbana tɨgɨt kwutaa kungwamatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kungwamataa ndi kat wandɨ. Tamba God wandɨ, pɨlɨwutndi. Wuna ngay ndinyangu wuleilaa wun kat nyaangɨt ngambulɨnjeya ngayat tɨgyandɨ waa tamba God wandɨ waa tamba pɨlwutndi. Ngwuk wupma ana yilɨgangwuk. Ngwuk wupma wenga klalɨngwan sɨkwutɨga nɨmba pagwula lɨga ngay vla lɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mɨni kiya nɨmbo man kɨvɨ watna nɨmbo yandi maa Godna ngaymba tɨga ndi kat kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","God kat kwunatɨga njambwi nɨmbo Moses kwiya nyaangɨt sɨmogwi lɨga nɨmbo kwunatɨnda apma njɨvwa vɨlaa ndɨ kat maawupmba kɨmbuk yiga yelavɨka lɨndi. Mat nyangu nɨma sakwat Godna ngay wuleilaa kɨselaga Jisasna sɨ nɨma wandi. Mɨn Devitna yelangɨ nyan mɨn. Apma vat tɨgambɨn waa wandi. Judna njambwi nɨmba walɨnja vat wutaa nat njambɨ maawupmba kɨmbuk yiga yelavɨka lɨndi ndɨ kat. ");
INSERT INTO ian_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ndi Jisas kat yalaa wuka lɨga wandi. Kɨselaga walɨnja vat mɨn ana wutɨgamɨn? Apma vat ana ndɨ walɨnja waa wandi. Wandi maa Jisas ndi kat wandɨ. Wuka lɨgowun. Apma vat walɨgandi. Ngwuk kan nyaangɨt ana vɨga lɨgangwuk? Kupma pɨlɨwutndi. God wandɨ. Mat nyangu mwunyamba lɨga nyangu ndina kwundimba wuna sɨ waga kwutaa katsogiyandi waa wandɨ God waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas ndi kat walaa wan ngepma kwagalalaa Betani walɨnja ngepma wuleilaa ngan wumba kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ngambi Jerusalem yiga lɨga Jisas wundɨ kat tɨga ");
INSERT INTO ian_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ava yambɨmba la fik walɨnja mi kat vɨndɨ. Vɨlaa ndɨna sɨk sɨgɨtaa kɨvak kat yelavɨtndɨ. Yelavɨtaa laataa yiga wan mi angwa ngway tolalaa tanambɨka vɨndɨ. Vɨndan sɨk kwandɨ, ana vɨndɨ. Nganga mɨna lɨndɨ, vɨlaa wandɨ. Ngɨni kan mi sɨk ana kwaigandɨ wandɨ. Walɨndɨ mala wan mi njingwut njama nganga aywaa lɨga wundɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jisasna mbaapmamba la nɨmba vɨlaa ngɨpali walaa wandi. Kan mi kat wama nyaangɨt sɨvla ana wamɨn. Anda vapmba lɨga wundɨ waa wandi maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ngwuk awuk ngwula. Wuka yelavɨk ngwula. Maawut vɨlɨlɨk yelavɨtapman tɨga God kat nɨmamba apma maawut yelavɨka lɨngweyan fik walɨnja mi kat yuwa vak vla ngwulo wupma yigiyangwuk. Kupma yuwa vak kat kwulakiyangwuk. Kan tɨga nduwi kat laataa nguat ay wangeyan yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɨmamba apma maawut yelavɨka lɨngweyan God kat wagalangweya nda ngwuk kat kwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas Godna ngay wuleilaa ndinyangu kat nyaangɨt mbutɨndɨ. Mbutɨndɨ maa wutaa God kat kwunatɨga njambwi nɨmbo Judana nat njambwi nɨmbo yalaa ndɨ kat wagalandi. Mɨn kat kanda wandɨ, kan njɨvwa kwutɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas ndi kat wandɨ. Ngwuk kat kɨta nda wagalagiyowun. Wagalaweya vak ngwuk kat mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kanda wandɨ maa ngu yagu la Jon yalaa nɨma sakwat nɨmba kat ngu yagulɨndɨ. God wandɨ maa yalaa yagundɨ? E? Ndu nyan wandɨ mala yalaa yagundɨ? Ngwuk ambuk ngwula wun kat waa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wagalanda vak wutaa awat sowat ngambulɨndi. God waqndɨ maa ngu yagulɨndɨ waa waneyan nɨn kat waigandɨ. Ndɨnai waa nyaangɨt manda kat wutapman yingwuk waa nɨn kat waigandɨ. Ndu nyan wandɨ maa yalaa ngu yagulɨndɨ waneyan wan nɨma sakwat nɨmba wutaa nɨn kat kai waigandi. Jon dɨ profetna waa yelavɨtaa lɨgandi waa awat sowat ngambulaa ");
INSERT INTO ian_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jisas kat wandi. Nɨn kat wagalama vat ana vɨga lɨganɨn waa wandi. Wandi maa Jisas ndi kat wandɨ. Wuno wun kat wagalangwa nyaangɨt ana ngwuk kat mbukiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas laataa ndi kat pagwuga lɨga wapuseput mbutndɨ. Kɨta nyan nyan vɨlɨlɨkno lɨndɨ. Nyaek laataa yiga njambwi nyan kat wandɨ. Njambwi nayan mɨn laataa yiga ambugat njɨvwa agwut waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","kai wowun wandɨ. Kai walaa tɨga mandɨp vak yelavɨtaa laataa yiga ambugat njɨvwa kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nyaek at mat nyan kat wandɨ. Mat nyan mɨn laataa yiga mabugat njivwa agwut wandɨ maa yigiyowun wandɨ. Yigiyowun walaa ana yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Anda nyan nyaekna kwundi wutaa yiga njɨvwa kwukiya Ngwuk angamak yelavɨka lɨgangwuk waa Jisas wandɨ maa nyamwun laataa yiga njɨvwa kwutndɨ wandi. Jisas ndi kat wandɨ. God vɨga lɨga kava wuleivat tɨgiyaa nɨmba ndino wupma yuigiyandi. Nɨma sakwat takis sanya klalɨga kavle nɨmbo yambɨsɨk yilɨga taagwo ndi tat God vɨga lɨga kava wuleigiyandi. Ngwuk anaga ngwuk wuleigiya. ");
INSERT INTO ian_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngu yagu la Jon ngwuk kat wuleingweya yambɨ vɨsɨmogwindɨ. Ngwut ndɨna nyaangɨt wupmak kat kai wangwuk. Nɨma sakwat takis sanya klalɨga nɨmbo yambɨsɨk yilɨga taagwo ndi wutndi. ana kai wandi. Wutnja vak vɨlaa ngwuk ana mandɨp maawut yelavɨka wukngwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ndi kat wandɨ. Pagwula lɨga nat wapuseput ngwuk kat mbukiyowun. Tamba kɨta nyan ndɨna kɨpmamba diwai wain watɨga ambugat kwutndɨ. Waina kandi tulaa wan ambugat tɨvwi kɨlɨndɨ. Waina ngu klavat veigɨnyanjeya waangu vandɨ. Ambugat kat vɨga lɨnjeya awlapmba la ngay kwutndɨ. Wan ambugatna njɨvwa aywaa kwutaa ambugat kat vɨga lɨgiya nɨmba kat wan ngaymba taagalaa sɨvla kava yindɨ. Ndɨnai vɨga lɨgiya wain nat waambu klaigandi. Nat waambu kɨpma lɨga nyan klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain sɨgɨpmak tɨnja njɨmbla lɨndɨ maa ndɨna njɨvwa kwuta nɨmba kat ambugat ay wandɨ maa ndina njambwi nyan klaiga wain klavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ndɨna njɨvwa kwuta nɨmba ambugat yandi maaambugat vɨga la nɨmba ndina nat nyan kat viyalaa nat nyan kat vatnyalaa nat nyan kat vatnyavak ndɨ kat kambak yaagilɨndi. ");
INSERT INTO ian_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","37","Kɨpma lɨga nyan nat njambɨ nat njɨvwa kwuta nɨmba kat ay wandɨ maa yindi. Yindi maa ambugapmba la ndinyangu wandɨ, yindɨ. Wuna nyan kat vɨlaa ndɨna kwundi wukiyandi walaa ndɨna nyan kat ay wandɨ, ambugat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ambugat vɨga la nɨmba ndɨna nyan yandɨ maa vɨlaa yelavɨtndi. Kɨpma kwukna nyana nyana. Ndɨ kat vatnyandyan kan kɨpma nɨna lak klaiganɨn waa yelavɨtaa ");
INSERT INTO ian_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ndɨ kat kwutaa alaguat kalilaa ndɨ kat vatnyandi. ");
INSERT INTO ian_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kɨpma lɨga nyan yandeyan wan nɨmba kat angamak yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ndi kat wundi kavle nɨmba kat vatnyagiyandɨ. Vatnyalaa ndɨna ambugat kat vɨga lɨgiyaa nat nɨmba kat kwutaa yaa taagagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kan mbutuwa wapuseput tamba God wandɨ, pɨlɨwutnja nyaangɨt vla lɨgandɨ. Ngwuk vɨlɨngwuk? E? Ana vɨlɨngwuk? Kan nyaangɨt. Kupma pɨlɨwutndi. Kambapmba ngay kwuta nɨmba tat yaagibnja kambak ngɨni kwutaa ngay tagumba taagandi, lɨndɨ. Taagandi tɨga wan ngayna njambwi kambanknat tɨndɨ. God sɨmogwindɨ, wan kambak kwutaa tagumba taagandi. God apma vat ndi kat sɨmogwindɨ. waa tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ngwuk Judana njambwi nɨmba ngwuk kat wowun. God ndinyangu kat kwunatndeya vat ngwuk ana klaigangwuk. Nat nɨmba Godna njɨvwa kwuka yetɨgiya nɨmba ndi klaigandi. ");
INSERT INTO ian_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Wan wawa kambak kɨta nyan kambak kat kai walaa mamba veindeyan wan nyan kavle yigiyandɨ. Kambak ana kavle yigiyandɨ. Tagula kambakna. Wan kambak nat nyamba ndɨ kat viyandeyan ndɨ mbaw vla lɨga kavle yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","God kat kwunatɨga njambwi nɨmbo Ferisio Jisas mbutnda pagwula la wapuseput wutaa yelavɨtndi. Wanda nyaangɨt nɨn kat nɨma vat wavat wandɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngi kat ana kwutaa kalindi. Nɨma sakwat nɨmba ndɨ Jisas profetna waa wandi. Wan nɨma sakwat nɨmba kat vaaka lɨga ana ndɨ kat kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas pagwula la nat wapuseput ndi kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Nyinangwupmba lɨga njambwi nyan ndinyangu kat vɨga lɨgiya vat kɨngi vat tɨgandɨ. Tamba nɨma king tɨndɨ. Ndɨna nyan taagwa klavat tɨndɨ, king nɨma kɨgɨnda kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ndɨna njɨvwa kwuta nɨmba kat wandɨ maa ngepma ngepma yiga ndinyangu kat wangwuk yaandi wandɨ ndi kat. Wandɨ, yindi. Yiga wanja nɨmba yavak kat kai wandi. ");
INSERT INTO ian_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kawiga lɨga vɨlevilaa ndɨna nat njɨvwa kwuta nɨmba kat ay wandɨ maa ngepma ngepma yiga ndinyangu kat wandi. Kɨgɨnda lamba kwuka taaganɨn tɨandɨ. Njambwi nyan ndɨna kwandɨ bulmakau vatnyalaa ndina wimbu awmba kwalalaa taagalaa kɨgiya nɨmba kat kawiga lɨgandɨ. yagwa ngwula waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wanja vak yiga wanja nɨmba ana wutndi. Ndina njɨvwa kwagalalaa yavak kat kai walaa njɨvwa mɨna kwutɨndi. Kɨta nyan ambugat kwupmat yindɨ. Nat nyan stua vɨga lɨvat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nat nɨmba kingna njɨvwa kwuta nɨmba kat kwutaa lɨga viyalaa vatnyandi. ");
INSERT INTO ian_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nɨma king wutaa ndɨna maawut nyingi yiga ndɨna soldia kat ay wandɨ. Wandɨ maa yiga wan nɨmba kat aywaa vatnyalaa ndina ngay aywaa yamba tundi. ");
INSERT INTO ian_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ndɨna njɨvwa kwuta nɨmba kat wandɨ. Kɨgɨnda tamba kwuka lɨganɨn. Tak wawa nɨmba apma nɨmba ana ndi. Kavle nɨmba ndi. Ndi ana wawa vat wutaa alɨpsɨga yalaa wawa kɨgɨnda kɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ava yambɨ ava yambɨ kava kava aywaa yigiyangwuk. Yilaa vɨngweya nɨmba kat aywaa kwutaa kiyaigangwuk. Kiyangwuk mala ndi kɨgɨnda kɨgiyandi waa wandɨ maa yindi. ");
INSERT INTO ian_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ava yambɨ ava yambɨ kava kava aywaa yilaa vɨnja apma nɨmba kavle nɨmba kat aywaa kwutaa kiyandi. Taagwa klalaa lɨnda ngay ndinyangu mɨna taata lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kind wan ngay wuleilaa apma waavwi kwusolapman kɨgɨnda kɨvat ya nyan kɨta kat vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Vɨlaa ndɨ kat wandɨ. Mɨn, kɨgɨnda kɨvat yamɨn. Kupi waavwi kwusolapman manda kat kwo yamɨn waa wandɨ maa wan nyan awat ndɨ kat ana nyaangɨt wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","King ndɨna njɨvwa kwuta nɨmba kat wandɨ. Wan nyan kat kwutaa man taamba sangilaa ndɨ kat alagumba yiga yaagi. Kulun walaa lɨga kavamba tɨgandɨ. Wan kavamba lɨga nglaga nɨmbi ngliaka tɨgiyandɨ waa wandɨ king. ");
INSERT INTO ian_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kan wapuseputna angwa kɨngiyan. God nɨma sakwat nɨmba kat yagwa walɨgandɨ. Nɨma sakwat nɨmba ana wutaa ndɨna ngway yalɨgandi. Nat nɨmba mɨna yalɨgandi wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ndi Ferisi yelavɨtndi. Jisas kat wagalaneyan anagandɨ nɨn kat kavle nyaangɨt mbukiya waa ndina maawupmba yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngi kat tɨga ndina nat nɨmbo Herotna mbaapmamba la nɨmba kat ay wandi maa Jisas ta kavat yindi. Yilaa lɨga Jisas kat wandi. Nyaangɨt sɨmogwi lɨga nyan mɨn. Mɨn ana woseka walɨgamɨn. Mɨn Godna angwa nyaangɨt ndinyangu nɨn kat pagwuga ana mbutɨgamɨn. Savagu mbutɨgambɨn nɨn kat. Mɨn mandɨp mandɨp vapmba ana yilɨgamɨn. Kɨpmamba lɨga ndinyangu nɨn kat aywaa kɨta vapmba yilɨgamɨn. Nat nɨmbana yelavɨk vapmba ana yetɨlɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nɨn kat awamba mɨn. Romba lɨga njambwi king Sisa kat takis sanya kwineyan Moses kwiya nyaangɨt kai waa kalɨkiyanɨn? Mɨn angamak yelavɨka lɨgamɨn. Nɨn kat ambuk waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nɨn kat kavle nyaangɨt anagandɨ mbukiya waa maawupmba yelavɨtnja vak kat vɨlaa wandɨ. Ngwuk woseka waa pagwula lɨga nɨmba ngwuk. Nɨn kat kavle nyaangɨt anagandɨ mbukiyaa waa manda kat ngwula maawupmba yelavɨtɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis yaagingweya sanya kɨta agiya wun kat waa wandɨ maa kwindi. ");
INSERT INTO ian_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisas sanya kwutaa ndi kat sɨmagaga wandɨ. Kan kana sa kana mɨndama kan moni sanyamba lɨga waa wagalandɨ ndi kat. ");
INSERT INTO ian_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wagalandɨ, wandi. Romba lɨga njambwi king Sisana sɨ mɨndama wandi. Jisas wutaa wandɨ. Ngiyambak wangwa. Sanya ndɨna nda. Ndɨna nda ndɨ kat kwigiyangwuk. Godna nda Godnat kwigiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jisas waa nyaangɨt wutaa ngɨpali waa kwundi lapman laataa ndɨ kat kwagalalaa yindi. ");
INSERT INTO ian_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusi walɨnja mbaapma nɨmba kiya lɨga nɨmba ngɨni ana laakiyandi walɨga nɨmba ndi. Ndi yalaa Jisas kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nyaangɨt sɨmogwi lɨga nyan tak Moses kupma pɨlɨwutndɨ. Nyamwun taagwa klalɨga nyan njantapman nyamwun kiyandɨ, sambu nyamwuna taagwa klaigandɨ. Klalaa nyan njangiyandɨ waa pɨlɨwutndɨ Moses. ");
INSERT INTO ian_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tamba kan ngepmamba kɨta ndu kɨta lagwana nyangu nondanyangu mɨna sɨla vɨli tɨndi. Nɨma nyan taagwa klalaa nyan njantapman tɨga kiyandɨ. Ndɨna sambu saasɨ kat klalaa nyan njantapman tɨga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ndi sɨla vɨli nondayangu nyan njantapman kɨta lagwamba klalɨga aywaa kiyandi. ");
INSERT INTO ian_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tɨga lɨga ngɨni wat taagwa kiyalɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ngɨni kiya nɨmba laatnjeya njɨmbla wat taagwa kana taagwat tɨgiyalɨ waa wagalandi Jisas kat. ");
INSERT INTO ian_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas wanja nyaangɨt wutaa ndi kat wandɨ. Ngwuk apma vat ana yelavɨka lɨgangwuk. God waa nyaangɨt kat ana apma vak yelavɨka lɨgangwuk. Godna kwondu kat ana apma vak yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngɨni kiya nɨmba laatnjeya njɨmbla ndu lagwa ana klaigandɨ. Taagwa ndu ana klaigalɨ. Ensel lɨga vla tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kiya lɨga nɨmba laatnjeya vak kat ngwuk kat nat nyaangɨt mbukiyowun. tamba God ngwuk kat yelavɨka wandɨ, pɨlɨwutnja nyaangɨt tamba vɨngwuk? E? Ana vɨngwuk? Kupma pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God Moses kat wandɨ. Wun Ebrahamna njambwi, Aisakna njambwi, Jekopna njambwi nyan wun waa wandɨ God waa tamba pɨlɨwutndi. God kiya nɨmbana njambwi nyan ana ndɨ. Kwo lɨga nɨmbana njambwi nyana God waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wan nɨma sakwat ta nɨmba ndɨna nyaangɨt kat wutaa ngɨpaliga ndalaa wandi. Apma nyaangɨtna mbutɨnda waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas Sadyusi kat wagalanda nyaangɨt wutaa ndɨ kat awat mbutnjeya nyaangɨt kat yelavɨt sɨgɨtaa tagula ngega lɨndi. Tagula ngega lɨnja vak vɨlaa Ferisi ndino yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yisolaa lɨga ndina kɨta nyan kat wandi. Jisas kat laataa yiga wagala wandi. Wagalameya vak wutaa anagandɨ awat mɨn kat kavle nyaangɨt mbukiya waa wandi, laataa yindɨ. Laataa ya nyan Moses kwiya lo sɨmogwi la nyana. ");
INSERT INTO ian_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ndɨ Jisas kat wagalandɨ. Nyaangɨt sɨmogwi lɨga nyan Moses kwiya nyaangɨt nɨma sakwat tɨgandɨ. Anda nyaangɨtna nɨma tɨga nat nyaangɨt kat kwulataa lɨga. Wun kat ambuk waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas wutaa wagalanda nyaangɨt kat awat ndɨ kat wandɨ. Nɨma nyaangɨt kɨngiyan. Nɨma nyan God ndɨ kat ngwula maawupmba yelavɨka solat sɨga yetɨ ngwula. Ndɨ kat vɨga ngwula mbangɨ nolin ngwandɨga waavi laagnadɨ, yetɨ ngwula waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kan nyaangɨt nat nyaangɨt kat aywaa kwulatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndɨna kwupmba lɨga nyaangɨtno kɨta vatna. Kwupmba lɨga nyaangɨt kɨngiyan. Mɨna mbangɨ kat kwunapmak vla nat nyana mbangɨ kat vɨlaa wupma kwunak waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tamba Moses nɨma sakwat nyaangɨt mbutɨndɨ. Profet ndino nɨma sakwat mbutɨndɨ. Mbambala ngwuk kat mbutuwa nyaangɨt vɨlɨlɨk tamba la nɨmba mbuta nyaangɨtna angwa nyaangɨtna mbɨk. ");
INSERT INTO ian_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferisi yisolaa lɨndi maa Jisas yalaa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Juda kat kwunapmak ya nyan Kraist ndɨ kat ngwuk angamak yelavɨtaa lɨgangwuk. Anda nyana nyana waa wagalandɨ maa wutaa wandi. Ndɨ Devitna nyana waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas ndi kat wandɨ. Devit kat Godna waagan wuleindɨ maa Kraist wuna njambwi nyana wandɨ. Tamba la nyan Devit kupma walaa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","God wuna njambwi nyan kat wandɨ. Wuna yagindan naangɨmba ndaalɨ. Mɨn kat kao lɨga nɨmba kat sɨwun maa ngɨni mɨn kat ana kao yigiyandi waa wandɨ God waa pɨlɨwutndɨ Devit. ");
INSERT INTO ian_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit Kraist kat ndɨ wuna njambwi nyana wandɨ. Kraist kat Devitna mat nyana waa manda kat walɨgangwuk waa wagalandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wagalanda vak kat wutaa ana alɨpsɨga ndɨ kat mbutndi. Ngɨni Jisas kat wagalanjeya vak kat vaaka lɨndi. Ngɨni ndɨ kat ana wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas ndɨna mbaapmamba la nɨmbagwi nat nɨma sakwat nɨmba yalaa lɨndi, nyaangɨt ndi kat mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mbuka wandɨ. Ferisio Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba ndinai mbukiya nyaangɨt awuk ngwula. Ndi Moses kwiya nyaangɨt sɨmogwi wuka lɨga nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ndinai mbukiya nyaangɨt wuka yetɨ ngwula. Ndinai yiga yetɨlɨga vapmba ke yetɨngwa. ndi apma vak ngambuga lɨga kavle vapmba yetɨlɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ndi nat nɨmba kat walɨngandi. Yetɨlɨna vak kat vɨlaa nɨnai yetɨlɨga vapmba yetɨ ngwula. Yetɨlɨnja vak vla yetɨvak nɨma njɨvwa kwutɨgandi. Nɨma njɨvwa kwutɨnja njɨvwa kat vɨlaa Ferisi ndi kat ana miwa yiga kwunatɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndina apma njɨvwa nat nɨmba vɨmbandi walaa kapmba kwutɨgandi. Nat nɨmba vɨmbandi walaa God wandɨ, lavungamba pɨlɨwutnja nyaangɨt kapmba kwutaa kalilɨgandi. Nat nɨmba vɨmbandi walaa sɨvla mbundɨ waavwi kwusolɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nyaangɨt ngambulɨnja ngay wuleilaa njambwi nyana tɨgɨtmba ndaa lɨvat walɨgandi. Nɨma kɨgɨnda kwutnja ngaymba wungi vat sɨgɨt nda lɨvak kat walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nɨndɨ ngepmamba laataa lɨga nat nɨmba ndi kat apma vak tɨga nɨmba ndi waa wanja vak wupmak walɨgandi. Nat nɨmba ndi kat nyaangɨt sɨmogwi lɨga nɨmba ngwuk waa wambandi walaa walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngwuk wuna mbaapmamba lɨga nɨmba aywaa ngwuk wupma ke yingweya. ngwuk aywaa kɨta mbaapmamba lɨga nɨmba ngwuk. Awat sowat mɨn sɨmogwi lɨga nyan mɨn waa ke waa. Ngwuk aywaa ngwuk kat nyaangɨt sɨmogwi lɨga nyan kɨta lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kan kɨpmamba lɨga nat nyan kat nɨna nyaekna waa ke wangweya. Ngwutna nyaek kɨta. Nyinangwupmba lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ngwuk awat sowat mɨn njambwi nyan mɨn waa ke wangweya. Ngwutna njambwi nyan kɨta lɨgandɨ. Ndɨ Kraistna. ");
INSERT INTO ian_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Ngwutna kɨta nyan njambwi nyanat tɨvat tɨvat wandeyan avla ndɨna sɨ kwutaa viyesendagiyandɨ. Avla ndɨna sɨ kwutaa viyesendandeyan God ndɨ kat kwutaa katsondɨ maa njambwi nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Apma vak ana lɨgiyangwuk. Ngwuk woseka walɨga nɨmba lɨgangwuk. nyinangwut wuleinjeya yambɨ kat ngwuk tɨvɨlɨgangwuk. Ngwuk wuleivak kat kai walɨgangwuk. Nat nɨmba wuleivak kat kai valɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Ndu kiyandi, yetɨgat talagwana kwanda kwanda nda sɨkwuka klalɨgangwuk. Wupma yilɨngwan nɨma vat kavle yigiyangwuk.) ");
INSERT INTO ian_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Kɨta nyan kwutaa ngwutna mbaapmamba taagavat sɨvla mbundɨ yambɨ yilɨgangwuk. njambɨt kulaa yiga nduwi yiga wokega sɨvla mbundɨ yambɨ yilɨgangwuk. Ndi kat kwutaa taagangwuk maa kavle vat yilɨnjeya vak yilɨngweya vak kat kwulatɨgandɨ. Ngwutnogwi ndinogwi ya vɨtɨga kavle kavat yigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ngwuk nat nɨmba kat yambɨ sɨmogwiga mɨni kiyala lɨga nɨmba vla lɨgangwuk. Ngwuk kavle glei yigiyangwuk. Nɨna ngepmana nat nɨmba Godna ngayna sɨ waga nɨma njɨvwa kwukiyanɨn waa laataa nɨma kwundimba walɨgandi. Wanja njɨvwa kwutapman yinjeyan ngwuk Ferisi ndi kat ana kai walɨgangwuk. Nɨna ngepmana nat nɨmba Godna ngaymba lɨga golmba kwutnja awna sɨ waga nɨma njɨvwa kwukiyanɨn waa laataa nɨma kwundimba walɨgandi. Wanja njɨvwa kwutapman yinjeyan ngwuk Ferisi ndi kat kai walɨgangwuk. Ngwuk ferisi Godna ngay makna ngaymba lɨga golmba kwutnja aw nɨma nda waa yelavɨtaa ndi kat wupma walɨgangwuk. Ngwuk mandɨp mandɨp walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ndi kat mbutɨngwa nyaangɨt tungwengwan yiga lɨga nɨmba vla lɨga mbutɨgangwuk. Ngwuk mɨni kiya la lɨga nɨmba vla lɨgangwuk. Godna ngay nɨma nda. Wan ngaymba golmba kwutnja aw mat nda. Ngwuk manda kat nat nɨmba kat kai walaa at nat nɨmba kat kai walapman yilɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ngwuk Ferisi nat nɨmba kat kupma mbutɨgangwuk. Ndi nat nɨmba God kat kwunapmak kwanda kwanda taaganjeya njambana sɨ waga nɨma kwundi wanjeyan nyaangɨt kai waa mbutɨgangwuk. Ndi nat nɨmba God kat kwunapmak kwinja kwanda kwandana sɨ waga nɨma kwundi wanjeyan nyaangɨt tɨgandɨ waa mbutɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngwuk apma maawut ana yelavɨka lɨgangwuk. Kwanda kwanda taanganja njambo njambamba taaganja kwanda kwando mbɨk kɨta nda mbɨk. ");
INSERT INTO ian_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jambana sɨ wandeyan njambamba laaganja kwanda kwanda nda kat ndina maawupmba yelavɨkiyandi. ");
INSERT INTO ian_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kɨta nyan Godna ngayna sɨ wandeyan God kat yelavɨka lɨga waigandɨ. God kan ngaymba tɨgandɨ waa yelavɨka lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kɨta nyan nyingangwut wandeyan nyinangwupmba lɨga nyan God kat yelavɨka lɨga waigandɨ. God nyinangwupmba lɨga ndɨna nɨma tɨgɨtmba ndaa lɨgandɨ waa yelavɨka lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Ngwuk klangwa nda aywaa nɨma nda mat nda kalɨtaa mbaapma amba vɨli taagalɨgangwuk. Mat glei nda kɨlɨnja ndana ngaanga kalɨtaa mbaapma tamba vɨli taagalɨgangwuk. Taagalaa nat kɨta mbaapma God kat kwilɨgangwuk. Moses kwiya lo tɨga apma nɨma nyaangɨpmba ana kwutaa yetɨlɨgangwuk. Mat nyaangɨt mɨna. Moses nɨma nyaangɨt kupma wandɨ. Savagu lɨga vapmba ngwula maawupmba yelavɨka yetɨ ngwula wandɨ. Ngwuk wupma ana yetɨlɨgangwuk. Moses nat nɨma nyaangɨt kupma wandɨ. Woseka waga ke yetɨlɨngweya wandɨ. Ngwuk wupma ana yetɨlɨgangwuk. Kan tɨga Moses kwiya nɨma nyaangɨt kwagalalaa Moses kwiya mat nyaangɨt mɨna ngambuga yetɨlɨgangwuk. Moses kwiya mat nyaangɨt nɨma nyaangɨt wuka ngambuga yetɨngweyan wovuna. Apma vat tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nat nɨmba kat yambɨ sɨmagaga mɨna kiyala lɨga nɨmba vla lɨgangwuk. Ngwuk mat kavle vak savɨlɨvak nɨma njɨvwa kwutɨgangwuk. Nɨma kavle vak savɨlɨvak ngwuk ana yelavɨka lɨgangwuk. Nɨma kavle vak ngwula lak yalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Ngwuk ngu tulaa kɨlɨnja kap vla lɨgangwuk. Kan kapmana alagu kap mɨna njangindi, apma vat tɨgandɨ. Yap kap ana njangilɨgandi. Kɨgɨn mbundɨ lɨgandɨ. Ngwuk wupma lɨgangwuk. Ngwuk kao yiga avla ngwula mbangɨ kwunapmak kat nɨma sakwat nda avla ngwula mbangɨ kwunapmak kat nɨma sakwat nda klalɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kavle vak yiga yetɨngwa vak ngwuk ana vɨga lɨgangwuk. Ngwutna kavle maawut kwunakngweyan apma vat njɨvwa kwuka lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Ngwut kiya nyan kat taagalɨnja ngay vla lɨgangwuk. Kan ngay alagu nge sawun mbangɨ kɨpma taagalɨgandi. Awla nge kavle njangu veilɨga sɨm tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ngwutno wupma lɨgangwuk. Nat nɨmba ngwuk kat vɨlaa ndi apma vat yetɨga nɨmba ndi walɨgandi. Ngwula maawut wupma ana lɨgandɨ. Kavle vat woseka walɨnja vak ngwula maawupmba tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ngwuk Moses kwiya lo sɨmogwi lɨga nɨmbo Ferisio ngwuk kavle glei yigiyangwuk. Ngwuk woseka walɨga nɨmba ngwuk. Tambana profetna sɨm tɨgiya ngay apma vat kwutɨgangwuk. Tamba la apma vat ta nɨmbana sɨm ta ngay apma vat yelaga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ngwuk kupma walɨgangwuk. Tamba nɨna ngwat walanga ta njɨmblamba tɨgenɨn nɨn profet kat ana vatnyagenɨn waa walɨgangwuk. Woseka walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tamba la ndi profet kat vatnya nɨmba ngwula ngwat walanga ndi vatnya. Nɨna ngwat walanga ndi wangwuk. Ngwulo ngwula ngwat walanga ta vla lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tamba kwutɨnja kavle njɨvwa vla ngwulo wupma kwutɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ngwuk kavle kamboyna nyangu vla lɨgangwuk. God ngwuk kat kwutaa ya vɨtɨga kavat yisendagiyandɨ. Ndɨ kat ana kwagalalaa nat yambɨmba yigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngwuk kat wowun. Samat tɨga apma nambuo lɨga nɨmba, profet, nyaangɨt sɨmaga lɨga nɨmba wowun maa ngwuk kat yigiyandi. ndina nat nɨmba kat vatnyagiyangwuk. Ndina nat nɨmba diwai krosmba kaalagiyangwuk. Ndina nat nɨmba kat kwutaa nyaangɨt ngambulɨngwa ngay kalilaa viyalaa savɨlɨngwuk maa ngepma ngepmat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wupma yilɨngwan apma nɨmba kat vatnyanja vatna kavle wenga ngwutna lak klaigangwuk. Tat apma vat ta nyan Abel kat tamba vatnyandi. Vatnyalaa tɨga Berikaiana nyan Sekaraia kat ngɨni vatnyandi. Godna ngay wuleindɨ maa vatnyandi. Ndi aywaa vatnyanja nɨmbana kavle wenga ngwula lak klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngwuk kat wowun. Ndi kan mbambala lɨga nɨmba wan kavle wenga klaigandi wowun ngwuk kat waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas Jerusalem walɨnja ngepma vɨlaa wandɨ. Jerusalem Jerusalemba lɨga nɨmba ngwuk tamba la profet kat vatnyangwuk. God waa nyaangɨt ngwuk kat mbupmat yala nɨmba ndi kat kambapmba vatnyavat yaagilɨngwuk. Nɨma sakwat njambɨ ngwuk kat kwutaa wuna mbaapmamba taagavat walɨwun. nyaaga nyangu kat lɨla wiyo pupumba pagwulɨ la vla ngwuk kat pagwuvat walɨwun. Ngwuk wun kat kai walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngwuk kat wowun. Samat tɨga ngwutna ngepma sulɨndi maa ngɨni ndu nyan tapman ngepma tɨgiyandɨ wowun ngwuk kat. ");
INSERT INTO ian_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mbambala glei wun kat ana nat njambɨ vɨgiyangwuk. ngɨni glei tɨga wun kat vɨlaa waigangwuk. Ngwuk avɨ ngwula. God wandɨ, yaa nyan kɨngiyandɨ yaa. God ndɨ kat apma vat yindɨ, yaandɨ waa waigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas Godna ngay kwagalalaa wogwendɨ maa ndɨna mbaapmamba la nɨmba yalaa wandi. Ndɨ kat ngay kat sɨmogwi vat yalaa wandi. Kan ngay apma vat kwutnja ngeya. Godna ngaya waa wandi maa wutaa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Awa luwa. Apma ngeya. ngwuk kat wowun. Samat tɨga kan ngay sulɨndi maa nat kambak nat kambakna tagumba ana tɨgiyandɨ. Kambak kɨta kɨta mɨna lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas Oliv walɨnja nduwimba wokela ndaa lɨndɨ. Ndaa lɨndɨ maa ndɨna mbaapmamba lɨga nɨmba kapma lɨga ndɨ kat yalaa wagalandi. Ngɨni Godna ngay sulɨnjeya vak kat mbupma vat anda njɨmbla yaigandɨ. Anda nda tak vɨneya. Vilaa lɨga yelavɨtneya. Njambwi nyan yaiga ngɨni la lɨga nandinya waa yelavɨka lɨneya waa ndɨ kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas wutaa ndi kat wandɨ. yigumba vɨga alɨmba ngwuk. Ngwuk kat kɨta nyan woseka walandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngɨni nɨma sakwat nɨmba wuna sɨmba waga ngwuk kat yaigandi. Wun Kraist wun waga waigandi. Wan nɨmbana woseka wanjeya nyaangɨt wutaa nɨma sakwat nɨmbana maawut kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tat nɨma sakwat nɨmba waliagiyandi. waliandi, vɨgiyangwuk. Ngwutna ngwaymba lɨga nɨmbo ndino waliagiyandi. Sɨvla kavamba lɨga nɨmbo ndino waliagiyandi. walialɨnjeya vak vɨlaa nɨma maawut ke yelavɨka lɨngweya. Kan vak tɨgiyandɨ ngɨni. Ngɨni la lɨga nandinya asɨk glei ana yaigalɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nat kɨpmamba lɨga nɨmba nat kɨpmamba lɨga nɨmba kat yiga sɨga viyaga waliagiyandi. Nat kingna nɨmba nat kingna nɨmba kat yiga sɨga viyaga waliagiyandi. Ngepma ngepmamba lɨga nɨma sakwat nɨmba wundɨ kat tɨga kiyaigandi. Kava kava aywaa yinaw kwukiyandɨ kan kɨpma. ");
INSERT INTO ian_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wan nɨma vak taagwa nyan kwupmak yipma sɨndɨ tɨleya vak vla tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tɨga lɨga nat nɨmba ngwuk kat kwutaa sɨga viyaga vatnyanjangat kaligiyandi. Wuna mbaapmamba lɨngwa vak kat vɨlaa ngwuk kat aywaa kai waigandi. ");
INSERT INTO ian_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wan yaiga njɨmblamba mbambala wun kat ndina maawupmba yelavɨka kwutaa lɨnja vak kwagalagiyandi. Ndi ndina mbaapmamba la nɨmba kat kai walaa kotnjangat kaligiyandi. ");
INSERT INTO ian_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wan yaiga njɨmbla nɨn profet nɨn waa woseka waiga nɨma sakwat nɨmba yaigandi. ndina nyaangɨt wutaa nɨma sakwat nɨmba apma vak yelavɨka lɨnja maawut kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wan yaiga njɨmbla kavle vat nɨma sakwat yaigandɨ. yandɨ maa wuna nɨmba nɨma sakwat wun kat kwagalagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wan yaiga kavle vak vɨlaa wun kat kwagalalapman kwo lɨgiya nɨmba ndi apma vat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wan yaiga njɨmbla mbutuwa apma nyaangɨt ngepma kava kava yiga mbukiyandi. Kava kava ngepma ngepmamba lɨgiya nɨmba wutaa kan Godna nyaangɨtna waigandi. Ndi aywaa wutaa lɨndi, ngɨni la lɨga nandinya yaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas wandɨ. Tamba God waa nyaangɨt walɨga nyan Danyel kupma pɨlɨwutndɨ. Kɨta nyan Godna ngaymba kavle glei nda taagaiyandɨ. taaganda nda wan ngay nglambio lɨgiyandɨ waa tamba pɨlɨwutndɨ. Wun Matyu kan vɨlɨngwa nyaangɨt pɨlɨwutɨga nyan wun. Ngwuk kat wowun. Wan tamba pɨlɨwutnda vatna angwa nyaangɨt kat ngwula maawupmba yelavɨk ngwula wowun. ");
INSERT INTO ian_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jisas ndi kat wandɨ. Tamba pɨlɨwutnda kavle glei nda kat vɨlaa Judiamba lɨga nɨmba vaaka pɨlɨga nduwiat ay ngwula. ");
INSERT INTO ian_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kita nyan sambangemba lɨga ndɨna kwanda kwanda nda klavat ngay wuyleideyan ndɨ kavle yigiyandɨ. Kɨta yi yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kɨta yi yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nyan tɨga taagwogwi nyan kat mwunya kwilɨgat taagwo ndi kat miwa yigiyangwuk. Kwiyatapman pɨlɨga yinjeya yambɨ kai. ");
INSERT INTO ian_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Meit mwutolo kiya lɨga njɨmbla wungi vat kavle vat nɨn kat ke kwiga waa God kat wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wan nɨma sakwat kavle vat tak wupma ana lɨndɨ. Tak God kɨpma kwuta njɨmbla tɨga wungi vak kavle vak ana lɨndɨ. ngɨni wungi vak kavle vak ana nat njambɨ lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɨma nyan wan nandinyana sakwat kalɨtapman yindeyan ndinyangu aywaa kiyaigandi. God ndɨna mbaapmamba lɨgiya nɨmba kat yelavɨtaa wan nandinyana sakwat kalɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kɨta nyan yalaa ngwuk kat kupma avɨ ngwula Kraist kɨngiyan waa woseka wandeyan ngwut maawupmba ke yelavɨkngweya. ");
INSERT INTO ian_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wun Kraist wun. Wun God waa nyaangɨt mbutɨga nyan wun waa nɨma sakwat nɨmba yalaa waigandi. Ndi ngwuk kat woseka waigandi. Yalaa sɨmogwi lɨga nɨma njɨvwa kwukyandi. Kwutndi, ngɨpaliga ndaigandi. Kwutnjeya vak kat vɨlaa wan nɨmbana maawupmba yelavɨtnja vak kavle yigiyandɨ. Godna nɨmbana maawupmba yelavɨka lɨnja vak kat kavle yivat yalaa waigandi. ngwutna maawut ana kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngwuk kat ngɨni yaiga vak tamba mbukwun. ngɨni wan vak yandɨ maa ngwutna maawut ana kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nat nɨmba ngwuk kat yalaa avɨmba ngwuk Kraist kan ndinyangu lapman kwo kavamba lɨgandɨ waa wanjeyabn ke wuka. Nat nɨmba waigandi. Kan ngaymba pagwula lɨgandɨ waa wanjeyan ke wuka. woseka kwo waigandi. ");
INSERT INTO ian_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wun Godna nyaangɨt kɨpmat yalaa mbutɨga nyan wun. Ngɨni yaweya vak ngwuk ndinyangu aywaa vɨgiyangwuk. Vlap vlap wandɨ, vɨngwa vak vla yawun, vɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngwut tamba vɨga lɨgangwuk. Kiya nyana sɨm kwo kavamba yiga taagangweyan ndɨna sɨm ngaawi ambugavi yalaa plaga kɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas ndi kat wandɨ. Wan kavle njɨmblana nɨma vak yiga ngɨlɨndɨ maa nya yiga kulun waigandɨ. Mbak ana sɨgiyandɨ. Sɨngwuk nyinangwupmba lɨga pɨka ndaigandi. nyinangwapomba lɨga nda kat yinaw kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tɨga lɨga yaweya njɨmbla ngway tolandɨ, vɨgiyangwuk. Nyinangwupmba lɨga yaigowun. Wun Godna vak kɨpmana nɨmba kat sɨmogwi lɨga nyan wun. Wun tɨmbumba yaigowun. Wun nɨma avo lɨga yaigowun. Kava kava ngepma ngepmamba lɨga nɨmba yaweya vak kat vɨlaa nɨma nyana yaa waa vaaka nglaigandi. ");
INSERT INTO ian_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nyinangwupmba lɨga nɨma sakwat ensel yigiyandi. Woli agwiat yigiyandi. Yambunat yigiyandi. Malingwatnat yigiyandi. Kambangwatnat yigiyandi. Yiga Godna mbaapmamba lɨgiya nɨmba kat kwutaa kaligiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas ndi kat wandɨ. Fik walɨnja mi tɨga vak kat ngwuk yelavɨk ngwula. Nguo lɨndeya njɨmbla apma kwin klandeya njɨmbla ngwuk vɨlaa yelavɨkiyangwuk. apma nya sɨgiya njɨmbla tamba ngway tologandɨ waa yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngwuk kat mbutuwa nyaangɨtnonala kɨta vatna. Mbutuwa vak kat wutaa ngwula maawupmba yelavɨtaa ngɨni la lɨga nandinya tamba ngway tologandɨ waa yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ngwuk yelavɨk ngwula. Ngwula maawut ke tɨvɨnda. Ngwuk kan kɨpmamba vɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngwuk kat wowun. Ngɨni kɨpma nyinangwut ngɨlɨgiyandi. Ngwuk kat mbutuwa nyaangɨt ana kwo valat tɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas ndi kat wandɨ. Yaweya njɨmbla kɨta nyan ana vɨga lɨgandɨ. Nyinangwupmba lɨga ensel ndi ana vɨga lɨgandi. Nyinangwupmba lɨga ensel ndi ana vɨga lɨgandi. Wun Godna nyan wun ana vɨga lɨgowun. Wuna nyaek mɨna vɨga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yaweya njɨmbla kan kɨpmamba lɨgiya nɨmba yetɨnjeya vak tamba Noa ta njɨmbla yetɨnja vak vla lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tamba Noa ta njɨmbla ta nɨmba ndi God kat maawut yelavɨtapman kwo nao mɨna ngu mɨna kɨga taagwa mɨna klaga yetɨndi. Yetɨndi maa Noa njaambɨt kwutaa njaambɨtnat weleindɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sambiyangu nɨn kat vatnyavat yaigandɨ waa wan ngepmana nɨmba ana yelavɨka lɨndi. Sambiyangu yandɨ, ndi aywaa ngu kɨga kiyandi. Wun Godna ngepmamba tɨga yaweya njɨmbla Noa ta njɨmbla ta vak vla tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wan njɨmbla ambugapmba vɨlɨlɨk palɨ kɨtamba njɨvwa kwuka lɨmbɨt. yaweya njɨmbla kɨta nyan kat kaligiyowun. Nat nyan tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Taagwa vɨlɨlɨk wit mil kwuka lɨmbɨt, yaigowun. Yalaa taagwa kɨta kwutaa kaligiyowun. Nat taagwa tɨgiyalɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ngwuk yigumba vɨga alɨmba ngwuk. Anda sɨva ngwula njambwi nyan yaigandɨ. Ana viga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ngwuk maawut yelavɨk ngwula. Ngaymba lɨgiya nyan sɨkwutɨga nyan yaiga njɨmbla wukendan ndɨ ana sɨndu kwagendɨ. Vɨga lɨgendan sɨkwutɨga nyan ana wuleigiyandɨ. Ndɨ kat kai wandɨ, yigendɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ngwutno wupma sɨndu kwalapman vɨga lɨgiyangwuk. Wun God tɨga kavamba lɨga yaweya njɨmbla ngwuk ana vɨga lɨgangwuk. Ndɨ mbambala ana yaigandɨ waga yelavɨka lɨngweya njɨmbla wun yaigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas ndi kat wandɨ. njɨvwa kwuta apma nyan ndɨno wupma yilɨndɨ. Ndɨna njambwi nyan ndɨ kat wandɨ, wan njwvwa kwuta nɨmba kat njambwi nyanat tɨgas vɨga lɨndɨ. Ndi kat kɨgɨnda sanya kwiga ndi kat bɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Njambwi nyan yilaa yalaa vɨga lɨga apma njɨvwa kwutɨgamɨn waa wandeyan wan njɨvwa kwutɨga nyan nɨma vat solat sɨga lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Njambwi nyan ndɨna apma njɨvwa vɨlaa ndɨ kat waigandɨ. Mɨn yaweya vak kat apma maawut yelavɨka apma njɨvwa kwutɨmɨn. Wuna kwanda kwanda nda aywaa mɨnai vɨga lɨgiyaa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Njɨvwa kwuta kavle nyan ndɨ kupma yilɨndɨ. Wuna njambwi nyan yindan asɨk glei ana yaigandɨ waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yelavɨka lɨga ndɨnogwinala kɨta vat njɨvwa kwutɨnda nɨmba kat viyaigandɨ. Njɨvwa kwagalalaa nɨma ngu kɨga yetɨlɨga nɨmbanala yiga nɨma ngu kɨgɨnda kɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mbambala wuna njambwi nyan ana yaigandɨ waa yelavɨtɨndɨ maa ndɨna njambwi nyan wan nandinya yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ndɨna njambwi nyan yalaa ndɨ kat viyalaa kavle nɨmba tɨga kavamba taagagiyandɨ. Wan kavle kavamba lɨga nglaga nɨmbi ngliaka lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas wandɨ. ngɨni nyinangwupmba lɨga yaiga nyan yaiga nandinya kɨngi vat tɨgandɨ. Mwunyowia nyangu tamba vɨli taagwa klavak ya nyan kat vɨvat lam kwutaa yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nat tambanat mwunyowia nyangu apma vak yelavɨtapman kwo yindi. Nat tambanat mwunyowia nyangu apma vak yelavɨka yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Apma vak yelavɨtapman nyangu lam kalɨtnjeya wel klalapman lammɨna kwuka kwo yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Apma vak yelavɨka la ndi nyangu lam kalɨtnjeya wel klalaa lam kwuka yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Taagwa klavat ta nyan kɨgɨnda kwupmak kat yalapman tɨndɨ, kawiga lɨga sɨndu yindɨ, kwandi. ");
INSERT INTO ian_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nɨma nɨndɨ ngan kɨta nyan walega wandɨ. Wan taagwa klavat tɨga nyan ngi lamba yaa waa walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wandɨ maa laataa lam sagɨlalaa ndɨ kat vɨvat yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Apma vat yelavɨtapman nyangu apma vat yelavɨtɨga nyangu kat wandi. Nɨna lam wel ngɨlɨndɨ. Nɨn kat wel kwigiyangwuk wandi. ");
INSERT INTO ian_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wandi maa kai wandi. Ngwula lamo nɨna lamo kalɨtneya wel sakwat ana ndɨ. Nɨn nɨna lam mɨna kalɨkiyanɨn. ngwuk yiga kla ngwula wandi, klavat yindi. ");
INSERT INTO ian_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wel klavat yindi maa taagwa klavat ta nyan yandɨ. Yalaa ngay wuleindɨ, ndino tambanat nyangu nɨma kɨgɨnda kɨvat wuleindi. Wuleindi maa ndaamangena mbapmo kwaalandi. ");
INSERT INTO ian_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mbapmo kwalalaa tɨndi maa wel klavat ya nyangu yandi. Yalaa wandi. Nɨma nyan, nɨma nyan nɨn kat mbapmo lavwi wandi maa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngwuk kanda ngwuk. Ngwuk kat ana vɨga lɨgowun. Woseka ana wowun ngwuk kat ana vɨga lɨgowun waa wandɨ taagwa klavat ya njambi nyan. ");
INSERT INTO ian_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas ndɨna mbaapmamba la nɨmba kat vɨlaa wandɨ. Ngwuk yigumba vɨga lɨgiyangwuk. Njambwi nyan yaiga nandinya ana vɨga lɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas ndi kat wandɨ. Ngɨni nyinangwupmba lɨga nyan yaiga nandinya kɨngi vat tɨgandɨ. Kɨta njambwi nyan ngay kwagalalaa nat kavat yivat tɨndɨ. Yivat tɨga ndɨna njɨvwa kwuta nɨmba kat yagwa walaa ndi kat njivwa kwindɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ndina maawupmba lɨga vak kat vɨlaa sɨga nagulaa ndi kat wan njɨvwa kwindɨ. Nat nyan kat dola 5,000 kwilaa wandɨ. Kan moni vɨga lɨgiyamɨn wandɨ. Nat nyan kat dola 2,000 kwilaa wupma ndɨ kat kwilaa wandɨ. Nat nyan kat dola 1,000 yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","5,000 dola kla nyan wungi monimba bisnis kwuka nat 5,000 kdola kla nyan wungi monimba bisnis kwuka nat 5,000 dola klandɨ. klandɨ, ndɨnamba 10,000 dola tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ndɨno 2,000 dola kla nyan wungi monimba bisnis kwuka nat 2,000 dola klandɨ. Klandɨ, ndɨnamba 4,000 dola tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ndɨno 1,000 dola kla nyan ndɨ bisnis ana kwutndi. Waangu valaa wan moni waangumba laagandɨ, tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nɨma njɨmbla lɨga njambwi nyan yalaa njɨvwa kwilaa yinda ndi kuvut nyanguna njɨvwa vɨvat yandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","5,000 dola kla nyan yalaa nɨma nyan kat vɨlaa wandɨ. tat wun kat 5,000 dola kwimɨn. Wungi monimba bisnis kwuka nat 5,000 dola klawun. mɨna 10,000 dola agla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wandɨ maa njambwi nyan wandɨ. Mɨn apma njɨvwa kwutɨma. mɨn kat njɨvwa kwiwa moni apma vat vɨga lɨmɨn. Ngɨni mɨn kat nɨma moni kwiwun, vɨga lɨgiyamɨn. Wuna ngay wuleilaa wunogwinala apma vat yetɨgiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","2,000 dola kla nyan yalaa nɨma nyan kat vɨlaa wandɨ. Tak wun kat 2,000 dola kwimɨn, wungi monimba bisnis kwuka nat 2,000 dola klawun. Mɨna 4,000 dola kɨngiyan. Agla waa wandɨ maa njambwi nyan ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mɨn apma njɨvwa kwutɨma. Tak mɨn kat kwiwa mat moni kat apma vak vɨga lɨgiyamɨn. Wuna ngay wuleilaa wunogwinala apma vat yetɨgiyamɨn waa wandɨ njambwi nyan. ");
INSERT INTO ian_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","1,000 dola kla nyan wuleilaa wandɨ. Njambwi nyan. Mɨn kao mbundɨ nyan mɨn. Ngi kat tɨga mɨn kat vaaka lɨgowun. Nat nyan tuga kandi ndamba klaga kɨga yetɨlɨgamɨn. Nat nyan yaagiya mina sɨpmba sɨgɨka kɨga yetɨlɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mɨn kat vaaka lɨga wun kat kwima moni waangu valaa waangumba taagawun. Mɨna moni kɨngiyan. Agla wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wandɨ maa njambwi nyan wandɨ. Mɨn kavle njwvwa kwutɨga nyan mɨn. Mɨn mbangɨ kɨlɨpangɨ namwiya nyan mɨn. Wuna vak tamba vɨga lɨgamɨn. Nat nyan tuga kandi ndamba klalaa kɨga yetɨlɨgowun. Nat nyan yaagiya mi sɨpmba sɨgɨka kɨga yetɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","28","Manda kat mɨn kat kwiwa wuna moni bengmba taagalapman yimɨn. Bengmba taagagemɨn wan moni samat nɨman yigendɨ. Yilaa yawan bengmba taagagemɨn 1,000 dola nɨmba kat wandɨ. Kan kwutaa lɨnda moni klalaa 10,000 dola kwuta lɨga nyan kat agwi ngwula. ");
INSERT INTO ian_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Moni kwuta lɨga nɨmba ndi nat moni klaigandi. Klalaa ndi nɨma sakwat monio lɨgiyandi. Moni kwutapman tɨga nɨmba wan kwutaa lɨnja nda klalaa yaagigiyandi. ");
INSERT INTO ian_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wan kavle njɨvwa kwutɨga nyan kat kwutaa alaguat yaagi ngwula. Yaagingwut, yiga kulun walɨga kavamba lɨga nglaga nɨmbi ngliaka lɨgiyandɨ waa wandɨ njambwi nyan waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas ndi kat wandɨ. Wun ndinyangu kat Godna nyaangɨt mbutɨganyan wun. Ngɨni njambwi kingat tɨwun, Godna ensel wuna sɨ kwutaa katsolɨndi, yaigowun. Enselonala yalaa kingna tɨgɨtmba ndaa lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndaa lɨwun maa kan kɨpmamba lɨga nɨmba aywaa yaa yisolaa lɨgiyandi. Ndi kat vɨlaa sɨga naguga mbaapma vɨlɨlɨkmba taagaiyowun. Sip sip vɨga la nyan nat mbaapmamba sip sip taagalaa nat mbaapmamba meme taaganda vla taagaiyowun. ");
INSERT INTO ian_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sip sip kat yaagindan naangamba taagagiyowun. Meme kat ambugendan naangamba taagagiywoun. ");
INSERT INTO ian_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Taagalaa yaagindan naangamba lɨga nɨmba kat wun njambwi king wun waigowun. Ngwuk apma nɨmba ngwuk. Wuna nyaek ngwuk kat apma vat yindɨ. Yagwa ngwula. God ngwuk kat kwindeya nda yaa kla ngwula. Tamba kɨpma kwuta njɨmblamba ngwuk kat kwindeya nda kwundaka taagandɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngwuk wun kat apma vat yilɨngwuk. Wundɨ kat tɨwun, wun kat kɨgɨnda kwingwuk. Ngu kɨvat tɨwun, wun kat ngu kwingwuk. Nat ngepmamba lɨga ya nyan vla lɨwun, wun kat kwutaa ngwula ngayat kalingwuk. ");
INSERT INTO ian_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Waavwi lapman tɨwun, wun kat waavwi kwingwuk. Yelogwen kat tɨwun, wun kat yaa kwunakngwuk. Kalambusmba tɨwun, wun kat yaa vɨngwuk waa ndi kat waigowun. ");
INSERT INTO ian_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ndi kat wupma wowun, wan apma nɨmba awat wun kat waigandi. njambwi nyan anda njɨmbla wundɨ kat tɨmɨn, mɨn kat kɨgɨnda kwinɨn. Anda njɨmbla ngu kɨvat tɨmɨn, mɨn kat kwinɨn. ");
INSERT INTO ian_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Anda njɨmbla kapma ngepma nyan vla lɨmɨn, vɨlaa mɨn kat kwutaa nɨna ngayat kalinan. Anda njɨmbla waavwi lapma tɨmɨn, mɨn kat waavwi kwinan. ");
INSERT INTO ian_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Anda njɨmbla yelogwen kat kwamɨn, mɨn kat kwunatnɨn. Anda njɨmbla kalabusmba tɨmɨn, mɨn kat yaa vɨnɨn waa wagalagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wun njambwi king ndi kat waigowun Ngwuk kat wowun. Mbutuwa apma njɨvwa ngwuk tamba yilɨngwuk wuna mbaapmamba la nɨma nɨmba mat nyaangu kat. Ndi kat yilɨngwa vak wuna lak yandɨ. Ngi kat tɨga wun kat yilɨngwuk wowun waa ndi kat walaa ");
INSERT INTO ian_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ambugendan naangamba lɨga nɨmba kat waigowun. Ngwuk wun kat kwagalalaa ay ngwula. God ngwuk kat kai walɨgandɨ. Njɨmbla njɨmbla vɨtɨga ya lɨga kavat ay ngwula. ngwula ngepma. Tamba wan kava God kwutndɨ. Setan dɨna enselonala ndi kat kwutaa taagandeya ngepma kat kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tak wun wundɨ kat tɨwun, wun kat kɨgɨnda kwivak kat kai wangwuk. Ngu kɨvat tɨwun, ngu kwivak kat kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wun nat ngepmamba lɨga yalaa la nyan vla lɨwun, ngwula ngayat kalivak kat kai wangwuk. Wun waavwi lapman tɨwun, wun kat waavwi kwivak kat kai wangwuk. Wun yelogwen kat kwowun, wun kat kwunapmak kat kai wangwuk. Wun kalambusmba lɨwun, wun kat vɨvak kat kai wangwuk waa wowun maa wun kat waigandi. ");
INSERT INTO ian_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Njambwi nyan anda njɨmbla wundɨ kat tɨmɨn, vɨlaa kɨgɨnda ngu kwilapman yinɨn. anda njɨmbla kapma nyan vla lɨmɨn, mɨn kat kwutaa nɨna ngayat kalilapman yinɨn. anda njɨmbla waavwi lapman tɨmɨn, kwilapman yinɨn. anda njɨmbla yelogwen kat tɨmɨn, kwunatapman yinɨn. anda njɨmbla kalabusmba tɨmɨn, mɨn kat vɨlapman yinan waa wandi maa ");
INSERT INTO ian_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","46","wun njambwi king ndi kat waigowun. Wuna mbaapmamba lɨga mat nyangu ndi kat kwunapmak kat kai wangwuk. Ndi kat tɨga kavat kalilaa ndi kat taagagiyandi. Yaagindan naangamba lɨga apma nɨmba njɨmbla njɨmbla apma vat tɨnjeya kava wuleigiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas yisola la nɨma sakwat nɨmba kat nyaangɨt kwilaa ndɨna mbaapmamba la nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nandinya vɨlɨlɨk yindɨ maa Pasova walɨna pesto tɨgiyandɨ. Wan nandinya wun Godna vak sɨmogwi lɨga nyan wun kat kwutaa diwai krosmba kaalagiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tɨga lɨga God kat kwunatɨga njambwi nɨmbo Judana njambwi nɨmbo yisola lɨga nyaangɨt ngambulɨndi. God kat kwunatɨga njambwi nyan Kaiafasna ngaymba yisolaa lɨga nyaangɨt ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jisas kat pagwuga kwutaa vatnyagiyanɨn waa ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nɨma sakwat nɨmba Pesto tɨga njɨmbla yalɨgandi. Ndɨ kat kwutneya vak vɨlaa nɨn kat kai walaa walegiyandi. Ana nglaatndɨ. Ndɨna mala waa ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Betanimba lɨga tak kawia kɨla nyan Saimona ngaymba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisas ngaymba lɨndɨ, kɨta lagwa kambapmba kwutnja aw kwutaa yalɨ. Wan awmba apma njangu veilɨga sanda lɨndɨ. Wan sanda nɨma sanya kwiga klalɨnja sanda. Jisas njambamba lɨga nao kɨlɨndi maa wan sanda Jisasna nambumb salatɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndɨna mbaapmamba la nɨmba vɨlaa walega wandi. Wan sanda manda kat kwo salatɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nɨma sanyo lɨga sanda. Wan sanda kwilaa sanya klalaa sanya lapman tɨga nɨmba kat kwigelɨ waa walega wandi. ");
INSERT INTO ian_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas wanja vak wutaa ndi kat kat wandɨ. Manda kat ngwuk lɨ kat walega njɨka wangwuk. Wun kat apma vak kwunakalɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sanya lapman nɨmba ngɨni ngwulogwinala njɨmbla njɨmbla tɨgiyandi. Njɨmbla njɨmbla ndi kat apma vat yilɨgiyangwuk. Wun ngwutnogwina njɨmbla njɨmbla ana lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kiyawun maa wun kat waangumba taaganjeya vak kat yelavɨta wan sanda salɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngwuk kat wowun. Yelavɨk ngwula. Kan apma nyaangɨt mbutnjeya kava kavamba lɨlai sanda wun kat salɨkna vak kat yelavɨtaa mbukiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wan tamba vɨli kiyeli vɨlɨlɨk Jisasna ngwaymba la nɨmbana kɨta nyan ndɨna sɨ Judas Iskeriot. Ndɨ God kat kwunatɨga njambwi nɨmba kat yiga vɨlaa ndi kat nyaangɨt ngambundɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nyaangɨt ngambulaa wandɨ. Jisas kat kwukngweya vat ngwuk kat sɨmogwiweyan wun kat angamala sanya kwigiyangwuk waa wandɨ maa ndɨ kat sanya kɨta ndumi kiyeli tamba vɨli kwindi. ");
INSERT INTO ian_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sanya klalaa ndi kat kwagalalaa yiga Jisas kat kwutnjeya vak kat ndɨna maawupmba yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yis taagalapman nao kɨlɨnja pestona kɨta nandinya Jisasna mbaapmamba la nɨmba yalaa ndɨ kat wagalandi. Pestona kɨneya kɨgɨnda anda kavamba kwukiyanɨn waa wagalandi Jisas kat. ");
INSERT INTO ian_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jisas ndi kat wandɨ. nɨma ngepma wuleilaa tamba wawa nyana ngay kat yiga vɨ ngwula. Ndɨ kat vɨlaa awa ngwula ndɨ kat. Nyaangɨt sɨmogwi lɨga nyan wandɨ. Nɨma njɨvwa kwukweya njɨmbla tamba ngway tologandɨ. Mɨna ngaymba wunogwinala wuna mbaapma lɨga nɨmbo pestona kɨgɨnda kɨgiyanɨn waa sɨmogwi lɨga nyan wandɨ waa ndɨ kat yiga awa ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wandɨ maa yindi. yilaa ngay wuleilaa pestona kɨgɨnda kwutndi. ");
INSERT INTO ian_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nglaambu Jisas yandɨ maa ndɨna mbaapmamba lɨga nɨmbo njambamba ndaa lɨga nglaambu kɨgɨnda kɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kɨga lɨga Jisas ndi kat wandɨ. Ngwuk kat wowun. Wuna mbaapmamba lɨga ngwutna kɨta nyan wun kat kwutajangat sɨmogwigiyandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ndɨna mbaapmamba la nɨmba nɨma vak yelavɨka lɨga wunayɨ? Njambwi nyan wunayɨ? waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wagalandi, wandɨ. Wunogwina kɨta nombe awmba kɨgɨnda klavat taamba kwusendagiya nyan wungian ndɨnayɨ wun kat sɨmogwigiya. ");
INSERT INTO ian_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wun Godna vat sɨmogwi lɨga nyan wun. Wun kat vatnyanjeyangat sɨmogwigiya nyan kat ndɨ kat miwa ay ngwula. Ndɨ kat nyɨme kwutapman yigelan ndɨ apma vat tɨgendɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas Jisas kat vatnyanjeya vak kat sɨmogwigiya nyan wutaa Jisas kat wandɨ. Nyaangɨt sɨmogwi lɨga nyan. Wunayɨ? wandɨ. Wandɨ maa Jisas ndɨ kat wandɨ. Mɨn ngiyambak wama. mɨnayɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kɨga lɨga Jisas bret-nao klalaa God kat sɨvu kɨlaa lɨmba ngɨlɨga ndɨna mbaapmamba la nɨmba kat kwilaa wandɨ. Klalaa agɨ ngwula. Kan wuna wimba ngwuk kat kwiwa waa walaa. ");
INSERT INTO ian_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","wain ta kap klalaa God kat sɨvu kɨlaa ndɨna mbaapmamba la nɨmba kat kwilaa wandɨ. Ngwuk aywaa kan ngu agɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kan ngu wuna yelogwena ngwuk kat kwiwa. kan wuna yelogwen Godna nyingi maawut kat kwunatndɨ maa ngwuk kat ana sɨgiyandɨ. Nɨma sakwat nɨmba yiga yetɨlɨnja kavle vak kwunapmak kan wuna mbangɨna yelogwen salakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngwuk kat wowun. Wain walɨna ngu kɨpmamba lɨga ana nat njambɨ kɨgiyowun. God vɨga lɨga kavat wuleilaa ngɨni ngwulogwinala kupi apma ngu kɨgiywoun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jisas wandɨ maa God kat yelavɨka mbangu kwundi walaa wan ngay kwagalalaa Oliv walɨnja nduwiat yindi. ");
INSERT INTO ian_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas ndi kat wandɨ. Mbambala ngan ngwuk aywaa wun kat kwagalalaa vaaka yigiyangwuk. Tamba la nɨmba God waa nyaangɨt kupma pɨlɨwutndi. Sip sip kat bɨga la nyan kat God vatnyandɨ maa ndi sip sip kava kavat yigiyandi waa tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kiyalaa lɨga laataa tak Galiliat yigiyowun. Ngwuk ngɨni wuna kwupmba yaigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wandɨ maa wutaa Pita Jisas kat wandɨ. Njambwi nyan mɨn kat kwagalalaa ana vaaka yigiyowun. mɨna mbaapmamba lɨga nɨmba nat nɨmba ndi anagandi mɨn kat kwagalagiya. Wun ana mɨn kat kwagalgiywowun waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pita wawa nyaangɨt wutaa mɨna maawut ke sɨlwoka kwagalaga. Mbambala ngan njambɨ kuvuk waigamɨn. Jisas kat ana vɨga lɨgowun waigamɨn. Wamɨn maa ava nyaaga viyaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita wutaa wandɨ. Jisas kat ana vɨga lɨgowun waa ana wupma waigowun. mɨnogwinala kiyaweyan apma vatna. Ana vaakiyowun waa wandɨ maa Jisasna mbaapmamba la nɨmba aywaa wupma wandi. ");
INSERT INTO ian_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas ndɨna mbaapmamba la nɨmbonala Getsemani walɨnja kavat yindi. yindi maa Jisas ndi kat wandɨ. Ngwuk kumba ndaa lɨ ngwula. Wun samat yiga yilaa tɨga lɨga God kat wagalagiyowun, waa walaa ");
INSERT INTO ian_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ndɨna mbaapmamba la nɨmbana nat nɨmba kat kwagalaa Pita, Jems, Jon kuvut nɨmba ndi kat mɨna kwutaa yindɨ. Tɨga lɨga nɨma maawut yelavɨka lɨga ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wun nɨma maawut yelavɨka lɨgowun. Kiyavat tɨga nyan vla lɨgowun. Ngwuk kumba lɨga sɨndu ke kwa. Wun kat kawiga alɨ ngwula waa walaa ");
INSERT INTO ian_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ndi kat kwagalalaa samat kapma yindɨ. yilaa mɨndama mɨndama kɨpmamba ndalaa tɨga God kat wagalandɨ. Wuna nyaek mɨn kat wagalavat yigowun. Kan yaiga kavle vat wun kat yalandɨ. Wuna maawupmba yelavɨkwa vapmba wun kat ke yiga. Mɨnaj yelavɨkiya vapmba wun kat ay mɨla waa walaa ");
INSERT INTO ian_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","lataa kuvut nyaangu ta kavat ndi kat vɨvat yindɨ. Sɨndu kwanja vak vɨlaa Pita kat wandɨ. Ngwuk manda kat sɨndu kwangwuk. Samat wun kat ana kawiga lɨlɨgangwuk? ");
INSERT INTO ian_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mɨni vɨga lɨga God kat wagala ngwula. God kat wagalangweyan ngwuk kat yaiga kavle vat ana ngwuk kat kwulakiyandɨ. Kwo lɨgiyangwuk. Ngwuk kat bɨga lɨgowun. Sɨndu kwavat ana yelavɨka waa walaa lungwamataa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yilaa God kat wagalandɨ. Kan yaiga kavle vat wun kat yalandɨ. mɨnai yelavɨka lɨga vapmba kan yaiga kavle vat wun kat yandyan wovuna waa walaa laataa ");
INSERT INTO ian_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","kuvut nyangu ta kavat yindɨ. ndina mɨni valɨ kwutndɨ, sɨndu kwandi, yiga vɨndɨ. Vɨlaa ana wandɨ. Lungwamataa yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ndi kat kwagalalaa yiga kuvut wan njambɨ God kat wagalandɨ. Tak wagalanda wumba nyaangɨpmba wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wagalalaa ndɨna mbaapmamba la kuvut nyaangu kat laataa vɨvat yindɨ kuvut wan njambɨ. Yilaa ndi kat wandɨ. Ngwuk sɨndu kwangwuk? Wun Godna vak sɨmogwi lɨga nyan wun. Wun kat kwutaa kaligiya kavle nɨmba tamba yaa ngway tologandɨ. laataa avɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Laak ngwula. yigat. Wun kat sɨmogwivat tɨga nyan tamba yaa ngway tologandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas walɨndi maa ndɨna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nyanguna kɨta nyan Judas yandɨ. Jisas kat kwutaa kalivat ta nɨma sakwat nɨmbana yandɨ. ndi yak kwuka njay kwuka nɨmbi nda kwuka yandi. God kat kwunatɨga njambwi nɨmbo Judana njambwi nɨmbo ay wandi maa yandi. ");
INSERT INTO ian_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tak Judas ndi kat mbuka wandɨ. Yiga vɨlaa kɨpmwimba wusɨtweya nyan ndɨ Jisas wungiyan ndɨ. ndɨ kat wumba agwukmba ngwuk waa tak Judas ndi kat mbuka wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas yalaa Jisas kat vɨlaa nyaangɨt sɨmogwi lɨga nyan apma ngan walaa ndɨ kat yiga kwutaa ndɨna kɨipmwimba wusɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Wusɨtndɨ maa Jisas ndɨ kat wandɨ. Kɨta mbaapma nyan wun kat kwupmeya njɨvwa kwiyatapman agwup mɨla waa wandɨ maa Judasnogwinala ya nɨmba Jisas kat taambamba kwutndi. ");
INSERT INTO ian_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisasna mbaapmamba la nyan kɨta ndɨna ngway avamba kwa yak laguga klalaa God kat kwunat njambwi nayana njɨvwa kwuta nyana waan kalɨtndɨ. Kalɨtndɨ, kɨpmamba ndandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Vɨlaa Jisas wandɨ. Mɨna yak tɨnda vla sisenda. Kɨta nyan wan yapmba viyama vak vatnyagiyandi. ");
INSERT INTO ian_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wuna nyaek kat wagalaweyan wuna nyaek wandɨ maa nyingangwutna nɨma sakwat ensel yaigandi wun kat kwunapmak. Mbaapma tamba vɨli kiyeli vɨlɨlɨk ensel wun kat walaa ndi kat sɨvat yaigandi. Wun ana wagalgiyowun. ");
INSERT INTO ian_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wun kat kwutaa kalilaa vatnyanjeya vak kat tamb la nɨmba lavu nyinangmba pɨlɨwutndi. Nyaek kat ndɨnogwi lɨga ensel kat wagalaweyan tamba pɨlɨwutnja vak ana kak kiyaigandɨ. Wungi kat tɨga kai wowun. Ana wagalgiyowun waa walaa ");
INSERT INTO ian_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ndɨ kat kwupmat ya nɨmba kat wandɨ. ngwuk manda kat nɨmbi nda njay yak kwutaa wun kat yangwuk. Sɨkwutɨga nyan kat kwupmat tɨnja vak vla manda kat wun kat yangwuk. nandinya nandiya Godna ngay wuleilaa ngwutnogwinala ndaa lɨga nyaangɨt ngwuk kat mbutɨwun. Wun kat wungi nandinyamba kwukengwuk tuwa. ");
INSERT INTO ian_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wun kat yilɨngwa vak kwo ana yilɨgangwuk. Tamba la profet pɨlɨwutnja vak vla wun kat wupma yilɨgangwuk waa wandɨ maa ndɨna mbaapmamba la nɨmba aywaa ndɨ kat kwagalalaa vaaka pɨlɨga yindi. ");
INSERT INTO ian_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisas kat kwuka nɨmba God kat kwunatɨga njambwi nyan Kaiafasna ngayat kalindi. Moses kwiya lo sɨmogwi la nɨmbo Judana njambwi nɨmbo wan ngaymba yilaa yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita sɨvlamba lɨga Jisasna kwupmba yandɨ. yalaa ngayna ngwutnyala way nge alagumba tɨndɨ. Plismanonala kɨta kavamba lɨndɨ. jisas kat yinjeya vakvɨmbowun walaa yalaa vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","God kat kwunatɨga njambwi nɨmbo yisola la nat nɨmbo Jisas kat woseka wanja vak kat wupmak yalaa lɨndi. Wutaa ndɨ kat vatnyagiyanɨn waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nɨma sakwat nɨmba yalaa Jisas kat woseka walɨndi. Woseka walɨnja vak kɨta nyaangɨt ana walɨndi ndɨ kat. Mandɨp mandɨp nyaangɨt walɨndi. Ngɨni vɨlɨlɨk palɨ laataa nɨmba sakwat nɨmba kat woseka waga mbupmbɨk. ");
INSERT INTO ian_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Kupma wambɨk. Tak Jisas kupma wandɨ. Godna ngay sulɨlaa nandinya kuvutmba kwukiyowun waa Jisas wandɨ waa woseka mbupmbɨk. ");
INSERT INTO ian_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mbupmbɨk maa God kat kwunatɨga njambwi nyan laataa Jisas kat wandɨ. Mɨn kat mbupmba nyaangɨt mɨn an ngambumba nyaangɨt kat wutaa awat nyaangɨt mbukiyamɨn? waa wagalandɨ maa ");
INSERT INTO ian_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisas kwundi ana wandɨ. God kat kwunatɨga njambwi nyan at nat njambɨ Jisas kat nɨma kwundimba wagalandɨ. Mɨn nɨn kat ambup mɨla. Woseka wana walɨmeya. nyinangwupmba lɨga God woseka wameya vak vɨgiyandɨ. Mɨn Juda kat kwunapmak ya nyan mɨn? Mɨn Godna nyan mɨn? waa ndɨ kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas ndɨ kat wandɨ. Mɨn ngiyambak wupma wama wun kat. Wun Godna vat sɨmogwi lɨga nyan wun. Ngɨni kan kɨpmamba lɨga yiwun maa wun kat ana vɨgiyangwuk. Nyinangwut wokelaa Godna yaagindan naangɨmba ndaa lɨga njambwi nyanat tɨwun maa vɨgiyangwuk. Ngɨni nyinangwupmba lɨga ngaga yaweya vak vɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas waa nyaangɨt wutaa God kat kwunata njambwi nyan nyingi maawut tɨga avla ndɨna waavwi taambamba ngɨlɨtaa wandɨ. Wan nyan God kat kavle nyaangɨtna wanda. Ngɨni ndɨna kavle vat mbukiya nɨmba ana yalaa mbukiyandi. Kavle vat yinda vak ngiyambak wutna. Kavle vat mbuta nyaangɨt kan yesolaa lɨga nɨmba nɨn aywaa tamba wutnɨn. ");
INSERT INTO ian_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngwuk angamak ndɨ kat yigiyangwuk. Angamak ngwuk yelavɨka lɨgangwuk waa ndi kat wandɨ maa wandi. Ndɨ kavle nyan. Ndɨ kat sɨgiyanɨn. Kiyaigandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wupma walaa ndɨ kat mɨndamamba sɨpmiya saga ndɨ kat taamamba viyalɨndi. ");
INSERT INTO ian_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nat nɨmba pagwuga yalaa ndɨ kat viyalaa wandi. Mɨn Kraist profet vla timeyan mɨn kat viyalɨga nɨmbana sɨ ambuk waa kasega wandi. ");
INSERT INTO ian_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita alagu ndaamangemba ndaa lɨndɨ, God kat kwunata njambwi nyana njɨvwa kwutat taagwa yalaa Pita kat vɨlaa walɨ. Mɨn Galilimba lan Jisasonala tɨmɨn, vɨwun walɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pita wutaa wandɨ. Wanya vak wun ana vɨga lɨgowun waa walaa ");
INSERT INTO ian_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","laataa ngegavamba la tɨvwina suwi yambat yindɨ. Yindɨ maa nat taagwa vɨlaa wumba yisolaa la nɨmba kat walɨ. Kan nyan kat avɨ ngwula. Kan nyan Nasaretmba la Jisasonala kɨta vat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita wala vak kat wutaa wandɨ. Nɨma kwundimba wandɨ. Wanya nyan wun ana vɨga lɨgowun wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tɨga lɨga wumba yisola la nɨmba Pita kat vɨlaa wandi. Mɨn mɨn kat vɨnɨn. Jisasna mbaapmamba la nyan mɨn. Galilimba lɨga nɨmbana kwundimba ngambulɨgamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita wutaa ndi kat nɨma kwundimba wandɨ. Ngwuk kat woseka ana waigowun. Woseka waweya vak God vɨga wutaa wun kat sɨgiyandɨ. Wan wun kat wangwa nyan Jisas kat ana vɨga lɨgowun waa walɨndɨ maa ava nyaaga viyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Viyandɨ maa wutaa Pita yelavɨtndɨ. Tak Jisaswun kat wandɨ. Wun kat njambɨ kuvut pagwuga kai walɨmɨn, ava nyaaga viyaigandɨ wanda vak kat ndɨna maawupmba yelavɨtaa Pita laataa yiga nɨmamba nglalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngambi gleimba God kat kwunata njambwi nɨmbo Judana nɨma nɨmbo Jisas kat vatnyanjeya vak kat yisola lɨga ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jisas kat kwutaa man taamba sangilaa njambwi nyan pailat ta ngayat kalindi. ");
INSERT INTO ian_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisas kat sɨmogwia nyan Judas Jisas kat kwutaa kotndangat kalindi, wutaa mandɨp maawut sɨlɨmaka yelavɨtndɨ. Yelavɨtaa wan ndɨ kat kwinja sanya kɨta ndumi kiyeli tamba vɨli kwutaa yiga God kat kwunatɨga njambwi nɨmbo Judana njambwi nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wan nyan Jisas kavle vat yiga yetɨla nyan Sɨmogwiwun mala apma njɨvwa kwuka yeta nyan kat kwo vatnyagiyangwuk waa wandɨ. Wandɨ maa wutaa wandi. Nɨna njɨvwa ana ndɨ. Mɨn mɨna njɨvwa waa wandi maa ");
INSERT INTO ian_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas wutaa sanya Godna ngaymba yaagiga kwagalalaa wup yiga yelavɨka yilaa kwapmba yaaw tulaa mimba tulaa vasak selindɨ. Vasak selilaa kwapmba tunda yaawmba kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","God kat kwunatɨga njambwi nɨmba ngay yapmba la sanya klalaa wandi. Ndu nyan kat sɨvak kat kwina sanya. Godna ngaymba bengmba lɨga sanyogwi ana kɨta kavamba taagagiyanɨn. Wupma ana yigiyanɨn. moses kwiya lo nɨn kat kai wandɨ maa ngambundi. ");
INSERT INTO ian_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngambuga lɨga kɨta maawupmba yelavɨka ngambulaa wan sanya kwutaa aw nyalɨga nɨmbana kɨpma kat wenga kwindi. Kwilaa klandi wan kɨpmɨ. Kapma ngepmamba lɨga yaiga nɨmba kiyangjeyan waangu valaa ndi kat kumba laagagiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wan kɨpma kan mbambala tɨna njɨmbla kwo lɨgandɨ. Yelogwen ndaa la lɨga kɨpma walɨnja kɨpma. ");
INSERT INTO ian_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Tamba la profet Jeremaia tamba pɨlɨwutnda vak kak kiyandɨ, mbambala vɨganɨn. Ndi kɨpma kwo ana klandi. Jeremaia pɨlɨwutnda nyaangɨtmba klandi. Tamba kupma pɨlɨwutndɨ. Isrelmba la nɨmba ndɨ kat sɨvak kat wenga kwinja sanya kɨta ndumi kiyeli tamba vɨli kwilaa aw nyalɨga kɨpma lɨga nɨmba kat kwilaa wan kɨpma ndina lak klandi. God wun kat wandɨ maa wupma waa tamba pɨlɨwutndɨ Jeremaia. ");
INSERT INTO ian_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas njambwi nyan Pailat ta kavamba laataa tɨndi maa ndɨ kat wagalandɨ. Mɨn Judana king mɨn? waa wagalandɨ. Wagalandɨ maa Jisas wandɨ. Mɨn ngiyambak wun kat wama. ");
INSERT INTO ian_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","God kat kwunatɨga njambwi nɨmbo Judana nɨma nɨmbo yalaa yisolaa lɨga Jisas kat nɨma sakwat kavle vak kat ngambuga lɨndi. Ngambulɨnja vak kat wutaa Jisas awat ndi kat ana kulumataa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jisas kwundi walapman tɨnda vak kat vɨlaa Pailat ndɨ kat wandɨ. Mɨn kat kotɨnia nyaangɨt mɨn ana wutɨgamɨn? ");
INSERT INTO ian_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisas wutaa ana Pailat kat wandɨ. Wuka kwagalalaa lɨndɨ. Wuka kwagala lɨnda vak kat vɨlaa Pailat ngɨpaliga ndalaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat wan pesto la nandinyamba kalabusmba la kɨta nyan kat kwo ay walɨndɨ. Juda wan nyan kat sɨmogwindi maa kwo wogwelaa ay walɨndɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wan njɨmbla kavle glei nyan kalabusmba lɨndɨ. Ndɨna sɨ Barabas. ");
INSERT INTO ian_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wan nɨma sakwat ndu lagwa yisola lɨndi maa Pailat laataa ndi kat wagalandɨ. Anda nyan kat kwo ay waigowun. Ngwuk kanda kat yelavɨka lɨgangwuk. Wangwuk maa waigowun. Barabas kat kwo ay walu? Jisas waa Kraist walɨnja nyan kat kwo ay walu? waa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat Jisas kat kwagalavak kat yelavɨka lɨga ndi kat wangalandɨ. Jisas ndɨ kavle vat ana yindɨ. Ndina kumbut maawupmba ndɨ kat kai walaa kwutaa kiyandi. Ndi mandɨp maawut anagandi yelavɨkiya walaa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat jas tɨla tɨgɨtmba ndaa lɨndɨ maa ndɨna taagwa walɨ maa kɨta nyan yalaa Pailat kat mbutndɨ. Wan yalaa lɨndɨ kat wutɨna nyan ndɨ kavle vat ana yindɨ. Nak ngan wun smapmba vɨwun. Ndɨ vak kai. Ndɨ kat kwagala mɨla. Wan sɨmak vɨlaa wun kat kavle vat nɨma vat yandangat nɨma maawut yelavɨka lɨgowun waa walɨ mɨna taagwa waa Pailat kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","God kat kwunatɨga njambwi nɨmbo Judana nɨma nɨmbo nɨma sakwat yisola la ndu lagwa kat wutnjangat wandi. Pailat kat awa ngwula. Barabas kat kwagalamɨn nɨna lak yaandɨ. Jisas kat kwutaa vatnya mɨla waa Pailat kat awa ngwula wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wandi maa Pailat laataa ndi kat wagalandɨ. Anda nyan kat kwo ay waigowun waa andɨ maa Barabas kat waigamɨn wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wandi maa Pailat ndi kat wagalandɨ. Jisas waa Kraist walɨnja nyan kat angamak yigiyowun waa wagalandɨ maa wandi. Ndɨ kat diwai krosmba kaalaa mɨla wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat ndi kat wandɨ. Kavle vat yinda vat wun ana vɨga lɨgowun. Anda kavle vatna yinda waa wandɨ maa ndi nɨma kwundimba kɨselaa wandi. Ndɨ kat dewai krosmba kaala mɨla waa kɨselaa wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat yelavɨtndɨ. Ndi kat waluwa vak ana wutɨgandi. yelavɨka walɨnja vapmba yilapman yiweyan wun kat waleagiyandi waa yelavɨtaa ngu awmba kalɨtaa yisolaa vɨga lɨndi maa taamba ngu njangindɨ. Njangilaa wandɨ. Wan nyan kat tamba kwagalawun. Ndɨ kat kwutaa vatnyangweyan wuna vak ana ndɨ. Ngwuk ngwutna vatna waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wandɨ maa ndi aywaa ta nɨmba wutaa wandi. Wama vak tamba wukanɨn. Wovuna. Nɨna vatna. Ndɨ kat vatnyaneya nglambi nɨna lak nɨna nyangu lagwa nɨna lak yaigandɨ wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wandi mala Pailat wutaa barabas kat kwo ay walaa wandɨ maa Jisas kat kwutaa viyalaa diwai krosmba kaalavat kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailatna mbaapmamba lɨga soldia Jisas kat kwutaa Pailat wuleilaa njɨvwa kwuta ofisat kalindi. Wuleindɨ maa soldia yaa yisolaa ngɨlɨtaa ndɨ kat vɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ndɨna waavwi lapmiga klalaa yelogwen mbangɨ waavwi kwindi, kwusondɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mangɨ nɨmbɨ yamboy klalaa ndɨna nambumba wegwuga taagalaa kaalandi. Suwa kalɨtaa ndɨna yaagindan taambamba taagandi, kwutaa lɨndɨ, kwali mamba sɨlaa ndɨ kat kwusɨlɨga wandi. Mɨn Judana king mɨn. Apma vat tɨgamɨn waa ndɨ kat kwusɨlɨga wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Walaa ndɨna mbangɨmba ndɨ kat sɨpmiya sandi. Taambamba kwutaa lɨnda suwa klalaa ndɨna nambumba viyandi. ");
INSERT INTO ian_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ndɨ kat kwusɨlɨga kwagalalaa ndɨ kat kwusonja yelogwen mbangɨ waavwi lapmiga klalaa ndɨna waavwi kwindi, kwusondɨ. Kwusondɨ maa ndɨ kat kwutaa diwai krosmba kaalavat kalindi. ");
INSERT INTO ian_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jisas kat kaliga lɨga ava yambɨ yiga lɨga kɨta nyan Saimon ndɨ kat ava yambɨmba soldia vɨndi. Sairini walɨnja ngepmamba ya nyana. yalɨndɨ, ndɨ kat vɨlaa wandi. Kan kiwai kros klalaa mɨna lak walalaa kali mɨla wandi malaa klalaa walalaa kalindɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yiga lɨga Golgota walɨnja nduwiat wokendi. Golgota walɨnja nduwina angwa sɨ Andagava Nambu. ");
INSERT INTO ian_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nɨma nguo mi mbio kɨta awmba salɨtaa Jisas kat kwindi. Njangu wutaa kɨvak kat kai wandɨ. Ana kɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldia ndɨ kat kwutaa kiwai krosmba taagalaa man taamba kaalandi. Kaalalaa ndɨna waavwi klavak kat satumba kaselɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Satumba kasega ngɨlɨlaa kwo ndaa lɨga ndɨ kat vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisas kat kotnja nyaangɨt lavungamba pɨlɨwutaa ndɨna nambu sɨso diwai krosmba kaalandi. Kupma pɨlɨwutndi. Ndɨ Jisas. Judana kinga waa pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sɨkwuta mbɨt nyanogwi Jisaso kaalandi. Nat nyan kat yaagindan naangɨmba kaalandi. Nat nyan kat ambugendan naangɨmba kaalandi. ");
INSERT INTO ian_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Diwai krosmba Jisas tɨndɨ maa yi ya la nɨmba ndɨ kat bɨga nambu njingwenga kwusɨlɨga ndɨ kat waga yilɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kupma kwusɨlɨga wandi. Godna ngay sulɨlaa nandinya kuvupmba kwukiyowun wamɨn. Mɨn Godna nyanat tɨmeyan mɨna mbangɨ kwunap mɨla. Godna nyanat tɨmeyan diwai kros kwagalalaa ngaga yaa mɨla waa kwusɨlɨga waga yilɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","God kat kwunatɨga njambwi nɨmbo Moses kwiya lo sɨmogwi la nɨmbo Judana nɨma nɨmbo ndino wupma kwusɨlɨga walɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kupma walɨndi. Nat nɨmba kat tak kwunatndɨ. Ndɨ avla ndɨ kat ana alɨpsɨga kwunakiyandɨ ndɨna mbangɨ kat. Ndɨ Isrelna kingat tɨndeyan ndɨ diwai kros kwagalalaa ngaga yaigandɨ. Diwai kros kwagalaa ngaga yandeyan ndɨ kat vɨlaa waiganɨn. Ndɨ njambwi nyana waa waiganɨn. ");
INSERT INTO ian_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wun Godna nyan wun. God wun kat kwunakiyandɨ waa walɨndɨ. God ndɨ kat anagandɨ alɨpsɨga kwunakiya. Vɨgiyanɨn waa kwusɨlɨga ndɨ kat walɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sɨkwuta mbɨt nyan Jisasonala mbɨk kat diwai krosmba kaalandi. Jisas kat kwusɨlɨlɨnja vla mbɨlo kwusɨlɨga walɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nɨma nɨndɨ nandinya nya kulun wandɨ. 12 klok kulun walaa tɨga yiga 3 lok nglaambu kembandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 klok nglaambu Jisas nɨma kwundimba kiselaa wandɨ. Ndina kwundimba wandɨ. Eli, Eli, lema sabaktani. God wuna nyaek wun kat manda kat kwagalmɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wumba la nɨmba yigumba ana wutndi. Wutaa wandi. Awuk ngwula. Ndɨ Ilaija kat walɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ndina kɨta nyan pɨlɨga namɨnɨnga klalaa nɨma ngumba sɨvugundɨ. Sɨvugulaa njɨmbwi mbaomba ngilaa kwusoga Jisasna tɨpmwimba taagalaa agɨ wandɨ. Jisas kɨvak kat kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wumba la ndina nat nɨmba wandi. Kumba kawiga vɨga lɨgiyanɨn. Tɨga lɨga Ilaija ndɨ kat kwunapmak yandeya vak vɨgiyanɨn. Anagandɨ yaiga waa njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas nɨma kwundimba kɨselaga waga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kiyandɨ maa Godna ngay nɨndɨmba la nɨma waavwi ngɨlɨtndɨ. Angwapmba lɨga ngɨlɨka ngaga yandɨ. Nɨma yɨnaw kwutndɨ, nduwimba la kambak mbɨlɨga yindɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Godna mbaapmamba la tɨga kiya nɨmba nɨma sakwat mat matna kɨpma mbɨlɨndɨ vasagla laatndi. Laataa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ngɨni Jisas laatndɨ maa ndi Jerusalemat wuleini, nɨma sakwat nɨmba vɨndi ndi kat. ");
INSERT INTO ian_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jisas kat bɨga la njambwi soldagwi ndɨna kwupmba la soldio yɨnaw kwutɨndɨ mala kiya nɨmba laatnja vak vɨlaa vaaka lɨndi. Vaaka lɨga wandi. Ndɨ Godna nyana luwa waa wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sɨvla kavamba la ndi taagwa nɨma sakwat yitega vɨga lɨndi. Tamba Jisas Galilimba lɨga yandɨ, ndɨna kwupmba yandi. Yalaa ndɨna kɨgɨnda kwutndi. ");
INSERT INTO ian_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ndina nat kɨta lagwa Maria. Magdala walɨnja ngepmana taagwat. Nat Maria tɨlɨ. Lɨ Jems Josepna nyɨmeat. Sebedina mbɨt nyana nyɨme lɨlo tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jisas kiya nandinyana nglaambu arimatia walɨnja ngepmamba la sanyo la nyan yandɨ. Ndɨna sɨ Josep. Ndɨ Jisasna mbaapmamba ta nyana. ");
INSERT INTO ian_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ndɨ Pailat kat yiga Jisasna sɨm kwutaa kalivat wagalandɨ. Kwutaa kali mɨla waa Pailat wandɨ maa Josep Jisasna sɨm kwutaa kalindɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep sɨm klalaa sawun mbangɨ waavwi lalaa Jisasna sɨm mbaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mbaataa kwutaa kaliga yiga kambapmba vanja kupi waangumb taagandɨ. Wan waangu Josepna waangua. Sɨm taagalaa nɨma kambak mbandɨga dkliga waangu tegɨlɨndɨ. Tegɨlɨlaa kwagalalaa ngepma yindi. ");
INSERT INTO ian_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdalamba la Mariagwi nat Mario waangu la kavamba ndaa lɨga vɨga lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas kiyandɨ, vaangulaa tɨga nat nandinya God kat kwunatɨga njambwi nɨmbagwi Ferisio laataa yiga Pailat kat wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kupma wandɨ, njambwi nyan. Wan woseka walɨga nyan tamba wandɨ. Kiyalaa nandinya kuvut tɨga laakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wamɨn maa ndɨna waangu lɨga kava soldia yiga vɨga lɨgiyandi. Soldia yiga vɨlapman yinjeyan ndɨna mbaapmamba lɨga nɨmba ndɨna sɨm sɨkwuta kalilaa Jisas tamba kiyalaa laatndɨ waa woseka waigandi. Tak Jisaana mbaapma nɨmba nɨma sakwat kavle nyaangɨt woseka wandi. Samat kavle vatna. Ngɨni Jisas kiyalaa laatndɨ waa wanjeyan nɨma kavle vatna waa Pailat kat wandi. ");
INSERT INTO ian_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wandi maa Pailat wandɨ. Ngwuk soldia kat kwutaa kaliga yiga waangu lɨga kavamba taagangwuk, vɨga lɨgiyandi wandɨ. Wandɨ maa soldia kat kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kaliga yiga waangu taa kavamba taagandi, vɨgalɨndi. Waangu sɨlɨtɨnja kambapmba njambiya taagandi, tɨndɨ. Kan kava ke yangweya waa taagandi. Wungi njambiya kat soldia yiga vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Njɨvwa lapman nandinya ngɨlɨndɨ maa Sande ngambi Magdalana taagwa Mariagwi nat Mario Jisas taagndi ta waangu vɨvat ngambi gleimba laataa yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yilɨmbɨt maa yɨnaw kiyandɨ, nyɨnangwupmba lɨga ensel ngaga yandɨ. Yalaa waangu tegɨlɨnja kambak mbandɨga kalilaa wungi kambak tagumba ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enselna mɨndama vlap vlap wandɨ, kembandɨ vɨna vla ndɨna mɨndama wupma lɨndɨ. ndɨna waavwi sawun mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Waangu vɨga la Soldia ensel kat vɨlaa ava mban plaga vaaka lɨga yiga kɨpmamba ndandi. ndalaa kiyalaa la nɨmba vla lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Taagwa vɨlɨlɨk yambɨt maa ensel mbɨk kat vɨlaa wandɨ. Diwai krosmba kaalanja Jisas kat kwaaka vɨvat yambɨt. Vɨga lɨgowun mbɨk kat. ");
INSERT INTO ian_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ndɨ kumba waangumba ana lɨgandɨ. Tamba laataa yindɨ. Tamba Jisas wandɨ. Kiyalaa lɨga ngɨni laakiyowun wandɨ. Wanda vapmba laatndɨ. Tɨnda waangu yaa vɨ mbɨla. ");
INSERT INTO ian_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mbɨk kwiyatapman yiga vɨmba vat ndɨna mbaapmamba la nɨmba kat yiga mbuikiyambɨt. Kiyalaa lɨga laataa Galiliat yindɨ. Ngwuk ndɨna kwupmba aymba ngwuk. yiga mbupmba ngwuk. Mbɨk kat wawa nyaangɨt mbɨtna maawut ke tɨvɨga waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wandɨ maa waangu kwagalalaa pɨlɨga yimbɨt. Vaaka yelavɨka solat sɨga yimbɨt. Yiga Jisasna mbaapmamba la nɨmba kat mbupmat yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yilɨmbɨt maa Jisas ava yambɨmba mbɨk kat vɨlaa wandɨ. apma vat alɨmba mbɨt waa wandɨ, wutna kwali kwali ndaa sɨlaa ndɨna mamba kwutaa ndɨna sɨ kwutaa katsoga wambɨt. ");
INSERT INTO ian_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas mbɨk kat wandɨ. Mbɨk ke vapmba. Tak Galiliat yiga tɨgowun. Wuna mbaapmamba la nɨimba kat ambukmba mbɨk. Mpupmbɨk, wutaa wuna kwupmba yalaa wun kat vɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wumbɨt taagwa yilɨmbɨt maa waangu kat vɨga la nat soldia laataa ngepmat yindi. Yiga God kat kwunatɨga njambwi nɨmba kat Jisas laatnda vak mbutndi. ");
INSERT INTO ian_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mbutndi maa God kat kwunatɨga njambwi nɨmbo Judana nɨma nɨmbo yisolaa nyaangɨt ngambundi. Nyaangɨt ngambulaga soldia kat nɨma sakwat sanya kwilaa wandi. ");
INSERT INTO ian_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ngwuk kupma ambukmba ngwuk. Ngan sɨndu kwanɨn maa Jisasna mbaapmamba la nɨmba yalaa ndɨna sɨm sɨkwuta kalindi waa ambukmba ngwuk nat nɨmba kat. ");
INSERT INTO ian_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngwuk kat vɨga la njambwi nayan mbukngweya nyaangɨt wutaa ngwuk kat kai wandeyan ndɨ kat yiga waiganɨn. Wamɨn maa ngwuk kat ana sɨga viyaigandɨ waa wandi Judana njambwi nɨmba. ");
INSERT INTO ian_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldia wutaa kwinja sanya klalaa wanja nyaangɨtmba waa ndinyangu kat yiga mbutndi. Soldia waa nyaangɨt wuka lɨga apma vala wangwa waa Juda walɨndi. Mbambala nɨmbun wupma walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tak Jisas wanda Galilimba lɨga nduwi Jisasna mbaapmamba la tamba vɨli kiyeli kɨta nɨmba wokendi. ");
INSERT INTO ian_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wokelaa Jisas kat vɨlagala solat sɨga ngu navɨn vɨyaa ndɨ kat tɨndi. Ndɨ kat nat nɨmba vɨlaa lɨga Jisas ana ndɨ waa maawupmba yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas ndi kat yalaa ngwaymba lɨga wandɨ. Nyinangwutna kwondu kɨpmana kwondu aywaa tamba klalaa lɨgowun. ");
INSERT INTO ian_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kan kwondu ngwuk kat kwiwun mala klalaa ngepma ngepma aywaa yigiyangwuk. Wuna nyaekna sɨ waga wuna sɨ waga wuna nyaekna waagana sɨ waga ndi kat ngu yagugiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngwuk kat mbutuwun, wutaa yetɨngwa nyaangɨt ndi kat mbukngwuk maa kwutaa yetɨgiyandi. Ngwuk kɨta nda kat wana yelavɨtapman yilɨngweya. Ngwuk kat ana kwagalagiyowun. Ngwutnogwinala njɨmbla njɨmbla tɨgiyowun. Ngwulogwi tɨlɨwun, kɨpma nyinangwut ngɨlɨgiyandi ngɨni la lɨga nandinya waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Godna nyan Jisas Kraistna apma wupuseputna tat ta nyaangɨt kɨngiyan. God waa nyaangɨt wala nyan Aisaia pɨlɨwutnda vapmba tɨndɨ. Kupma pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God wandɨ. Vɨga awuk. Wunai waa nyaangɨt kiyaiga nyan kɨngiyandɨ. tata yilaa wuna nyan yaiga yambɨ kwunakiyandɨ waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kɨta nyan kwo kavamba lɨga wan nyaangɨt walendɨ. nɨma nyana yaiga yambɨ kwuka kwunak waa walendɨ waa pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon dinyangugat yagulɨga nyana. Kwo kavamba lɨga wan nyaangɨt mbutndɨ. Kupi maawut yelavɨka lɨngweyan ngwuk kat yagugigiyowun. Wungi kat tɨga kavle vat yetɨlɨngwa vak kat God lɨmbwigiyandɨ waa mbutndɨ Jon. ");
INSERT INTO ian_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia walɨnja kavamba lɨga nɨmbagwi Jerusalem walɨnja ngepmamba lɨga nɨmbo ndɨna lak yindi maa ndi kat Jodan walɨnja ndandangɨmba yagulɨndɨ. Ndinai kavle savle yetɨnja vak kat mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kamelna yuwimba vɨtnja waavwimba kwusolaa lɨndɨ. Sɨmbɨmba yɨpma sɨtndɨ. Waakalavali vla lɨga ndagwi wanyanyevio klalaa kɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mbuka walɨndɨ. Wun mat nyan wun. Wuna kwupmba nɨma nyan yaikandɨ. Mat nyan vla lɨwangat ndɨna man suna yaaw taamba taaga pɨgiyaweyan kwondu ana lɨgandɨ waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngwuk kat ngumba yagugowun. Yaiga nyan ngwuk kat Godna waagan kwindɨ, tavagiyandɨ waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Samat tɨga Jisas Galili walɨnja kavamba nasaret walɨnja ngepmamba lɨga yandɨ. Yandɨ maa Jon Jisas kat Jodan walɨnja ndandangɨmba yagundɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas ngu kwagalalaa lɨndɨ maa nyɨnangwut mbɨlɨnda vat vɨndɨ. Vɨlɨndɨ maa Godna waagan namiyo vla lɨga ndaiga ndɨ kat tavindɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nyɨnangupmba lɨga kwundi wandɨ, wutndɨ. “Mɨn wuna kɨta nyan mɨn. Mɨn kat nɨmbamba woviyaguga solat sɨlɨgowun” waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wandɨ maa Godna waagan ndɨna maawupmba ngwandɨndɨ maa kwo kavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Seten ndɨ kat kavle vat ay walaga lɨga nandinya ndumi vɨli kwo kavamba yetɨndɨ. Kwapɨmba yeta ndaonala lɨndɨ. God waa nyaangɨt kiyaa ensel Jisas kat kwunatndi. ");
INSERT INTO ian_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon kat kalabusmba taagandi maa Jisas God waa apma nyaangɨt mbuka Galili wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wupma mbuka wandɨ. yaigandɨ God wanda sɨva yandɨ waa wandɨ. God nɨn kat vɨga lɨgiyaa sɨva mbambala wan wandɨ. Kupi maawut yelavɨk waa wandɨ. Apma nyaangɨt kat ngwula mbangɨ wiyo waavi taagagandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Galilina waambu sak yiga Saimonagwi Endru kat nyamwun swambu kat vɨndɨ. Mbɨla njula vla lɨga nda yaagilɨmbɨt, vɨndɨ. Kɨgɨnda kwutɨga nyan mbɨt. ");
INSERT INTO ian_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas mbɨk kat wandɨ. Wuna kwupmba yagwa mbɨlɨ wandɨ. Kɨgɨnda kwutɨmba vak vla ndinyangu kat kwuka wuna mbaapmamba taagaiyambɨt waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wandɨ, njula kwagalalaa ndɨna kwupmba yimbɨk. ");
INSERT INTO ian_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Samat yiga Sebedina nyan Jemsokwi Jon kat nyamwun swambu kat vɨndɨ. Vaalamba lɨga njula yaagilɨmbat. ");
INSERT INTO ian_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mbɨk kat vɨlaa yagwa wandɨ maa mbɨla nyaek kat ndɨna njɨvwa kwuta vaalamba la nɨmbanala kwagalalaa ndɨna kwupmba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kapaneam walɨnja ngepma wuleindi maa njɨvwa lapman nandinyamba nyaangɨt ngambulɨnja ngay wuleilaa Jisas sɨmagaga mbutindɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mbutndɨ maa ngɨpaliga ndandi. Kwondu nyan vla lɨga sɨmagaga mbutɨgandɨ waa wandi. Lo kat sɨmaga lɨga nɨmba vla ana sɨmagalɨngandɨ. Ndɨ kwonduo lɨga sɨmagalɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kavle waagan tavila la nyan nyaangɨt ngambulɨnja ngay wuleilaa walendɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jisas Nasaretna nyan nɨn kat mandana yimeya. Nɨn kat vatnyagiyamɨn? Mɨn Godna apma vat tɨga nyan mɨn vɨga lɨgowun waa walendɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Walendɨ maa Jisas waagan kat nɨma kwundimba wandɨ. Kiyak awa. Ndɨ kat kwagala waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wandɨ, waagan wan nyan kat kwutndɨ maa man taamba yaagiga kwundi ngu ngaanga ngu ndaga lɨndɨ maa nɨma kwundimba kɨsalaa ndɨ kat kwagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kwagalandɨ maa wumba la nɨmba ngɨpaliga ndandi. Ngɨpaliga ndalaa awat sowat wagalaga yelavɨka lɨndi. Kan mandana waa wandi. Mbutnda kupi nyaangɨtna? Kwonduo lɨga Jisas waagan kat wandɨ maa wutndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wandi maa Galilina ngepma ngepmamba lɨga nɨmba Jisas kat aywaa wutndi. ");
INSERT INTO ian_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nyaangɨt ngambulɨnja ngay kwagalalaa Saimonagwi Endruna ngay wuleindɨ. Jemsagwi Jono apma wuleimbɨt. ");
INSERT INTO ian_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimona nasakwat kangan yelogwengat njambamba kwalɨlangat ndɨ kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lɨ kat yalaa taambamba kwutaa kwusalatndɨ. Kwuslatndɨ maa kangan yelogwen kwiyatapman ngɨlɨndɨ maa ndi kat kɨgɨnda kwutaa kwilɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nandinya ngɨlɨndɨ nya yiga ndaindɨ maa yelogwenga ta nɨmbagwi waagan tavila la nɨmba kat ndɨ kat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kiyandi, ngepma nɨmba aywaa ngwutnyala wavamba yalaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","mandɨp mandɨp yelogwenga ta nɨma sakwat nɨmba kat kwunatndɨ. Waagan nɨma sakwat savɨlɨndɨ. Waagan ndi kat vɨga lɨndi. Wungi kat tɨga ndi kat kewa wun kanda wun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngamb nya wokelapman tɨndɨ, Jisas laataa ngepma kwalalalaa ndinyangu lapman kavat yilaa God kat ngumbulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimonagwi wumba la nɨmbanala Jisas kat kwaka yindi. ");
INSERT INTO ian_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ndɨ kat vɨlaa wandi. aywaa mɨn kat kwaka yalɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wandi maa wandɨ. nat ngepma nɨmba kat mbupmak kwagalalaa yawun. Yigat? Ngepma ngepma yiga wan apma nyaangɨt mbupmak yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nayaangɨt ngambulɨnja ngaymba mbuka waagan savɨlɨga Galilina ngepma ngepma yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kawia kɨla nyan kwalimamba sɨlaa ndɨ kat yawiga wagalandɨ. Wun kat kwunapmak wameyan kwunakiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ndɨ kat miwa yiga taamba taagalaa wandɨ Jisas. Kwunakiyowun. Kwo alɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wandɨ maa kawia kasɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jisas ndɨ kat nɨma kwundimba waga ndɨ kat ay wandɨ. mɨn kat kwunakwa vak kat nat nyan kat ke mbuka. God kat kwunatɨga nyan kat mɨna mbangɨ yiga sɨmaga. Mɨna kawia kasɨndangat God kat Moses waa nyaangɨtmba agwi Kwimɨn maa kawia kasɨndɨ lɨma vak kat aywaa vɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wandɨ, ngepma ngepman nɨmba kat yiga mbutɨndɨ. Wungi kat tɨga Jisas ngepma ngepma kapmba ana yi yalɨndɨ. Ndinyangu lapman kavamba yetɨndɨ maa ngepma ngepma la nɨmba ndɨ kat yandi. ");
INSERT INTO ian_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Samat tɨga Kapaneamat Jisas yindɨ. Ndɨna ngaymba lɨnda vak kat wutndi. ");
INSERT INTO ian_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɨma sakwat nɨmba yisolaa lɨndi maa ngwutnyala wavamba ndinyngu mɨna tata lɨndi maandi kat wan apma nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Man taamba kɨvɨ watna nyan kat aynat nɨmba kwutaa Jisas ta kavat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nɨma sakwat nɨmba lɨndi. Jisas takava yinjeya yambɨ kai. Sambange njɨk plalaa yaawaba tulaa sandandi, sɨndu kwalɨnda njambonala ndaindɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ndina mbangw wiyo waavi taagalɨnja vak kat Jisas vɨlaa kɨvɨ watna nyan kat wandɨ. Mɨn mɨnai kavle vat yetɨlɨma vat kat lɨmbwigiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moses kwiya lo sɨmogwilɨga nɨmba maawupmba sɨka wagalalɨndi. ");
INSERT INTO ian_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Jisas manda kat wupma wandɨ waa maawupmba sɨka wagalandi. God kat kavle vat wandɨ waa yelavɨtndi. God mɨna kavle vak kat lɨmbwigiyandɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisas ndina naawupmba sɨka wagalanja vak maawupmba vɨlaa wandɨ. Maawupmba sɨka manda kat wagalalɨgangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mandana nɨma njɨvwa. manai kavle vat yeta vak kat lɨmbwigiyowun waweyan nɨma njɨvwa? Mɨna njamba kwutaa laataa yetɨ waweyan nɨma njɨvwa? waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wun Godna vak sɨmogwi lɨga nyan wun. Kavle vak kat lɨmbwiweya kwondu wunamba lɨgandɨ. lɨmbwiweya vak kat ngwuk kat sɨmagavak kat man taamba kɨbɨ watna nyan kat ngi vat wowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mɨn kat wowun. Laataa njamba kwutaa ngay ay. ");
INSERT INTO ian_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wandɨ, laataa njamba kwutaa yindɨ maa vɨndi. Wungi kat tɨga ngɨpalɨga ndalaa God kat nɨma tɨndangat yelavɨka wandi. Tak wupma ana vɨlɨnɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas nat samba waambu sapmba yindɨ maa ndinyangu nɨma sakwat yisolaa lɨndi. Ndi kat sɨmogwiga wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Samat yiga Alfiasna nyan Livai kat takis sanya yaagilɨnja gaymba lɨndɨ, vɨlaa wandɨ. Wuna kwupmba yagwa waa wandɨ. Wandɨ, laataa ndɨna kwupmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas Livaina ngaymba njambamba nao kɨga lɨndɨ. Takis sanya klalɨga nɨma sakwat nɨmbagwi kavle vat yilɨga nɨmbo Jisasonala lɨndi. ndɨna kwupmba la nɨmba ndɨnanala lɨndi. Ndɨna kwupmba la nɨmba nɨma sakwatna. ");
INSERT INTO ian_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ferisi walɨnja kɨt vapmba yetɨga nɨmbana nyaangɨt pɨlɨwutɨga nɨmba kɨlɨndangat vɨlaa ndɨna kwupmba la nɨmba kat wagalandi. Kavle vat yetɨg nɨmbagwi takis sanya klalɨga nɨmbanala manda kat kɨlɨgandɨ waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wagalandi, Jisas wutaa wandɨ. Kwo lɨga nɨmba dokta kat ana yilɨgandi. Yelogwenga tɨga nɨmba mɨna yilɨgandi. Apma vat yetɨlɨga nɨmba kat kwunapmak ana yawun. Kavle vat yetɨlɨga nɨmba kat kwunapmak yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ngu yagulɨga Jona kwupmba la nɨmbagwi Ferisio kɨvak kak kai waga lɨndi. Nat nɨmba Jisas kat yalaa walɨndi. Jona kwupmba la nɨmbagwi Ferisio kɨvak kak kai waga lɨndi waa walɨndi. Mɨna kwupmba la nɨmba wupma ana lɨlɨgandi waa walɨndi. Wupma manda kat yilapman yilɨgnadi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas ndi kat awat wandɨ. Kupi lagwa klaa nyan tɨndyan vɨga lɨlɨga nɨmba kɨvak kak kai waigandi? waa wagalandɨ. Kupi lagwa klaa nyan ndinanala lɨndyan kɨvak kak kai ana waigandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kupi lagwa klaa nyan yindeya sɨva yaigandɨ. Yindeyan kɨvak kak kai wagiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tamba ngɨlɨkna waavwimba kupi waavwi taagalaa tavanjeyan ngɨni wan waavwi nɨmamba gɨlɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tamba sɨmbɨmba tavanja awmba kupi nɨma ngu ana salakyandi. Salatnjeyan nɨma nguna mbiyak nɨma yindɨ maa sɨmbɨ kɨkɨk waa mbɨlɨgiyandɨ. Mbɨlɨndɨ maa nɨma ngu kɨpmamba salaka yigiyandɨ. Nɨma nguagwi wan sɨmbo kavle yigiyandɨ. Kupi nɨma ngu kupi sɨmbɨmba mɨna salatɨgandi vɨlɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jɨvwa lapman nandinyamba ambugava yilɨndi maa Jisasna kwupmba la nɨmba kɨlɨnja yuwi sɨk sɨgɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sɨgɨtnja vak kat vɨlaa Ferisi Jisas kat wagalandi. Avɨ. njɨvwa lapman nandinya kat yetɨlɨna vapmba ana yetɨlɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Wandi, Jisas wandɨ. Tamba la nyan Devit ya vak kat pɨlɨwutnja nyaangɨt vɨngwuk? waa wandɨ. Kwo lɨga wundɨ kat tɨga Devit ndɨnowinala la nɨmba Godna gay wuleilaa God kat kelonja naaw kɨndi. God kwunatɨga njambwi nyan Abaita tɨndɨ maa kɨndi. God kat kwunatɨga nɨmba mɨna kelonja naaw kɨlɨgandi. Devit ndɨ kilaa ndɨnogwinala la nɨmba kat kwindɨ. Wupma wukngwuk? waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas ndi kat wandɨ. God njɨvwa lapman nandinya taagandɨ. ndinyangu yaat njawinjangat taagandɨ. njɨvwa lapman nandinyana vapmba yetɨnjangat God dinyangu kat ana kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngwuk kɨta vak vɨngwangat wowun. Wun Godna vaksɨmogwi lɨga nyan njɨvwa lapman nandinya kat vɨga lɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nat njambɨ nyaangɨt ngambulɨnja ngay Jisas wuleindɨ maa kɨvɨ watna taamba la nyan tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jisas kat vɨlɨndi. Njɨvwa lapman nandinyamba ndɨ kat kwunapmak wandeyan kavle vat yindɨ wavat wandi. ");
INSERT INTO ian_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas kɨvɨ watna taamba la nyan kat kapmba yagwa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jisas nat nɨmba kat wandɨ. njɨvwa lapman nandinyamba apma vat yiweyan kwowa? Vatnyaweyan kwowa? waa wandɨ. Wandɨ, kwundi walapman tɨndi. ");
INSERT INTO ian_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ndi kat tatna maawut sɨtnja vak kat ndi kat waleavat nɨma mɨni vɨndɨ. Kɨvɨ watna taamba la nyan kat taamba agwi wandɨ. kwindɨ maa kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kwunatndɨ Ferisi kwiyatapman yindi. herotna nɨmbonala Jisas kat vatnyanjeyan vak kat yisolaa ngambuvat tɨndi. ");
INSERT INTO ian_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas ndɨna kwupmba la nɨmbonala sak yindi. Galili, Judia, Jerusalem, Idumia, Jodan anguveli naanga, Taia, saidon, ngepma ngepma la nɨmba ndɨ kat yandi. ");
INSERT INTO ian_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisas ndɨna kwupmba la nɨmba kat wandɨ. Wun kat vaala taaga ngwula. Nɨma sakwat nɨmba ndi yaa lɨga wun kat kematandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas nima sakwat nɨmba kat kwunatndɨ. Wungi kat tɨga yelogwenga ta nɨmba ndɨ kat sɨnyɨpmak kematndi. ");
INSERT INTO ian_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kavle waagan tavila la nɨmba ndɨ kat vɨlaa ndalaa walendi. Mɨn Godna nyan mɨn waa walendi. ");
INSERT INTO ian_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Walendi, ndi vat nɨma kwundimba wandɨ. Godna nyanat tɨwangat ke walega waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas nduwi lɨga kava yiga ndɨna maawupmba nat nɨmba kat yagwa wandɨ maa yandi. ");
INSERT INTO ian_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Tamba vɨli kiyeli vɨlɨlɨk nɨmba ndɨnanala tɨnjangat, wan apma nyaangɨt yiga mbutnjangat, waagan savɨlinja kwondu klanjangat, yagwa ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wundi tamba vɨli kiyeli vɨlɨlɨk nɨmba vɨsɨmogwinda nɨmba kɨngiyan. Saimon nat sɨ wandɨ. Mɨn Pita mɨn wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedina nyan Jemsagwi yakwa nyan Jon kat nat sɨ wandɨ. Nyingangwutna kɨndɨgɨn vla lɨga nyan mbɨt waa wandɨ. Ndina kwundimba Boanesis mbɨt wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Endru, Filip, Batolomyu, Matyu. Tomas, Alfiasna nyan Jems, Tatiyas, ngepma ngepma nyaangɨt waga yi ya la Saimon, Judas Iskeriot Jisas kat vatnyavak kamwin kwiya nyan. Aywaa vɨsɨmogwindɨ maa ngepma yindi. ");
INSERT INTO ian_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas ngepmat yindɨ. Nat ngambɨ nɨmba yisolaa lɨnjangat naaw ana kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisasna ngaymba la nɨmba ngi vat wutaa ndɨna maawut yigumba ana sɨka lɨgandɨ walaa ndɨ kat kwutaa wusovat yindi. ");
INSERT INTO ian_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nyaangɨt pɨlɨwuta nɨmba Jerusalem kwagalalaa yalaa wandi. Beilsebul ndɨ kat tavilɨgandɨ waa walɨndi. Ndɨ waagana njambwi nyana waa walɨndi. Jisasnanagwinala kwaa lɨga waagangat savɨlɨlɨgandɨ waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas wundi nɨmba kat pakwuga la nyaangɨt wandɨ. mand vapmba Seten ndɨna mbaapmamba la waagangat savɨlɨgiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kɨta yelangɨ nɨmba avla kao yilɨnjeyan ndi aywaa ngɨlɨgiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kɨta ngaymba la nɨmba avla kao yilɨnjeyan ndi aywaa ngɨlɨgiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seten avla kao yilɨndeyan kwo vala tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tagula ava la kavle nyan ndɨna man taamba yaaw sangilapman lɨndeyan ndɨna ngay wuleilaa ndɨna kwanda kwanda nda ana awagapma klaigandɨ. Sangilaa klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Ndɨ kat tak wandi. Waagan mɨn kat tavilɨgandɨ. Wungi kat tɨga wupma wandɨ. ngwuk kak wowun. ndinyangu kavle ya vak kat God alɨpsɨga lɨmbwigiyandɨ. Kɨta nyan God kat kavle nyangɨt wandeyan God wan kavle vak kat alɨpsɨga lɨmbwigiyandɨ. Kɨta nyan Godna waagan kat kavle nyaangɨt ngambundeyan God ana alɨpsɨga lɨmbwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisasna nyɨmeo swambuo yalaa ngegavamba lɨga kɨta nyan kat Jisas kat yiga wamɨn yaandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nɨma sakwat nɨmba Jisasonala ndalɨndi. Ndi ndɨ kat wandi. Vɨga awut. Mɨna nyɨmeo swambuo tɨga mɨn kat yagwa waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wandi, Jisas wandɨ. Wuna nyɨmeo swambuo kanda ndi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisas ndinyanguna nɨndɨmba lɨndɨ. Ndɨna waymba la nɨmba kat vɨlaa wandɨ. Wuna nyɨmeo swambuo ngwulayɨ. ");
INSERT INTO ian_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Godna maawupmba yetɨlɨga nɨmba wuna swambu, wuna nyange, wuna nyɨme ndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nat njambɨ waambu sapmba Jisas sɨmagaga walɨndɨ. Nɨma sakwat nɨmba yisolaa lɨndi maa sapmba la vaala ndailaa ndalɨndɨ. yisolaa la nɨmba waambu sapmba lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pagwuga la wupuseputmba nɨma sakwat nyaangɨt ndi kat sɨmagagawandɨ. Sɨmagaga kupma wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Awut wandɨ. Kɨlɨnja sɨk yaagilɨga nyan sɨk yaagivat yandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yaagilɨndɨ maa nat sɨk nɨma sakwat angwa yambɨmba ndalɨndɨ, waavi yalaa kɨndi. ");
INSERT INTO ian_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","nat sɨk nɨma sakwat kambat tɨga tagu kɨpma kuvut tɨga kavamba ndandɨ. ndandɨ, kwiyatapman waatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Njingwut tambɨ lɨndɨ maa nya sɨngwalɨtndɨ, njingwut law wandɨ, kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nat sɨk nɨma sakwat kavle yuwi sɨt tɨga kavamba ndandɨ. Kavle yuwi waataa kematndɨ maa yaaginda sɨk tegɨlɨlaa ndɨna sɨk ana kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","9","Nat sɨk nɨma sakwat apma kɨpmamba ndandɨ. ndandɨ, sɨk kwandɨ. nat avamba sɨk kɨta ndumi kiyeli tamba vɨli kwandɨ. Nat avamba sɨk ndumi kuvuk kwandɨ. Nat avamba sɨk ndumi tambanat kwandɨ. apma maawut tɨga nyan wutaa yelavɨkyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas wan nɨma sakwat nɨmba kat kwagalandɨ maa ndɨnanala lɨga nɨmbagwi wan tamba vɨli kiyeli vɨlɨlɨk nɨmbo ndɨkat pagwula la wapuseput kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ndi kat wandɨ. God vɨga lɨga vatna aytesɨgɨt ngwuk kat tamba sɨmogwiwun waa wandɨ. Nat nɨmba kai walɨga nɨmba pagwuga la wupuseput mɨna wukiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kai walɨga nɨmba maawut yelavɨtapman mɨni mɨna vɨga lɨgandi. Maawut yelavɨtapman waan mɨna wuka lɨgandi. Wungi vak vapmba kupi maawut ana yelavɨkiyandi. Kupi maawut yelavɨtnjeyan kavle vak yetɨnja vak kat God lɨmbwingiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ndi kat wandɨ. Wan pagwugala wupuseputna angwa yelavɨtapman yingweyan pagwuga la angwa vat angamak yelavɨka lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kɨlɨnjandana sɨk yaagilɨnda vak vla apma nyaangɨt mbutɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Way angwa yambɨmbalɨga kɨpma ndinyangu vla lɨgandɨ. Nyaangɨt mbutndɨ maa wutndi. Wutndi, Seten kwiyatapman yalaa mbutnda nyaangɨt klalaa kaliga yiga pagwundɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kambat tɨga tagu kɨpma kuvuk tɨga kɨpma ndinyangu vla lɨgandɨ. Nyaangɨt nolin ngwandɨga klandi. ");
INSERT INTO ian_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ndina maawut njingwut tapman nda vla lɨgandɨ. Samat tɨga nɨma vat tɨndɨ, wan apma nyaangɨt kat tɨga waleavat waleanjangat kwagalandi. ");
INSERT INTO ian_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nat nɨmba kavle yuwimba la kavamba yaaginda sɨk vla lɨgandi. nyaangɨt wutndi. ");
INSERT INTO ian_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kɨpmana kwanda kwandanda kat yelavɨtnja vak, mandɨp mandɨp nda klavat walɨnja vat, nɨma sakwat nɨmbundawi nolin ngwandɨga klalɨnja vak, nyaangɨkat kematndi maa sɨk ana kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nat 20 nɨmba apma kɨpmamba yaaginda sɨk vla lɨgandi. nyaangɨt wutaa maawupmba kwutaa yuwi sɨk kwa vak vla apma njɨvwa kwukiyandi. Nat nyan sɨk ndumi vɨli kiyeli tamba vɨli kwa vak vla apma njɨvwa kwukiyandɨ. Nat nyan sɨk ndumi kuvuk kwa vak vla nɨma sakwat apma njɨvwa kwukiyandɨ. Nat nyan sɨk ndumi tambanat kwa vak vla nɨma nglei sakwat apma njɨvwa kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas ndi kat wandɨ. Salɨndi, vɨtɨga ya aw yapmba njamba pulumba taagalɨkandi? Kai. Njambamba taagalɨgandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mbambla pagwuga lɨga nda ngɨni kapmba lɨgiyandɨ. Kapmonja nda vla nda ngɨni vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maawut yelavɨta lɨgiyaa nyan awut. ");
INSERT INTO ian_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ndi kat wandɨ. yigumba awut. nat nɨmba kat yilɨngwa vak vla ngwuk kat wupma yigiyandi. Ndi kat nɨma vat yingweyan ngwuk kat nɨma anglei vat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Maawupmba yelavɨka lɨga nyan ndɨ nɨma sakwat apma vat klaigandɨ. maawupmba yelavɨtapman tɨga nyan apma vat ana klaigandɨ. Tat kla la apma vat nat nyan ndɨnamba klalaa kaligiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","God nɨn kat kwilɨga vat kɨpmamba sɨk yaagilɨga nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wan nyan ngan sɨndu kwalaa nandinya laatndɨ maa sɨt kwo waatndɨ. Waataa vat ana vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kɨpmamba lɨga avla waatndɨ. Tat ava. Ngɨni mwe tawndɨ. ngɨni sɨk kwandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sɨk ak wulaa lɨndeyan kalɨtɨnda sɨva yandeyan yapmba kalɨtɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas wandɨ. God vɨga lɨga vat manda vat vla lɨgandɨ. Angamak vɨlɨnja wapuseputmba sɨmagagiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mastet walɨnja sɨk vla lɨgandɨ. Wan sɨk mak nglei nda. ");
INSERT INTO ian_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wan sɨk yaaginjeyan waakiyandɨ. Kaawa ava vla waakiyandɨ. Nɨma sandanala lɨgiyandɨ. ndɨna angɨmba wiyaka yetɨlɨga waavi ngay kwukiyandi. ");
INSERT INTO ian_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pagwuga lɨga wapuseput nɨma sakwat ndi kat ngambundɨ. Nat nɨmba wuka yelavɨtndi. Nat nɨmba kai. ");
INSERT INTO ian_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nat nɨmba kat pagwuga lɨga wapuseput mɨna mbutndɨ. Kapmba ana ndi kat mbutndɨ. Ndɨna mbaapma nɨmba kat wupma kai. Ndi kat kapmba nyaangɨtna angwa vɨsɨmogwindɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nat nandinya ngan ndandɨ, Jisas ndɨna mbaapma nɨmba kat wandɨ. Sak valigegat waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nat nɨmba kat kwagalalaa njaambɨt kulaa valɨgendi. Nat njaambɨt nɨmbun valɨgendi. ");
INSERT INTO ian_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yilɨndi maa nɨma mwutolo kwutndɨ, pali laatndɨ. nɨma pali laataa ndina njaambɨt wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas kwengwi njaambɨtmba lɨga sɨndu kwandɨ. Ndɨ kat sɨvɨlulaa wandi. Sɨmogwi lɨga nyan nɨna njaambɨt tamba kambruka tɨgandɨ. Nɨn kat ana yelavɨka lɨgamɨn? ");
INSERT INTO ian_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas laataa mwuk pali kat kai wandɨ maa kiyak wandɨ. Ngu yuvut tapman tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mwuk kat walaa ndi kat wandɨ. Ngwuk manda kat vaaka lɨgangwuk. njambwi nyanat tuwa vak ana yelavɨka lɨgangwuk? waa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wandɨ maa ndi ngɨpaliga ndalaa awat sowat wandi. Wan nyan anda nyana. mwuk pali ndɨnai waa vapmba wutɨnda waa wandi. atwandɨ. God waa nyaangɨt mbutɨga nyan kwo ngepma lɨndyan ndɨ kat apma maawut yelavɨkiyandi. ndɨna angwa ngepma lɨndeyan ndɨna ngepma nɨmba ndɨ kat kai waigandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nat naanga sapmba yalaa Gerasa walɨnja nɨmba ta kavamba kawindi. ");
INSERT INTO ian_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Jisas vaalamba lɨga kɨpma veilɨndɨ maa kavle waagan tavila la nyan kiyaa nɨmba waangumba taagalɨnja kavamba yetɨlɨga nyan kat wɨndi. Sen walɨnja yaawmba ndɨna man taamba sangilavilaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nɨma sakwat njambɨ sen walɨnja yaawmba ndɨna man taamba sangindi maa vɨtɨtɨndɨ. nɨma ava la nyanat tɨndangat ndɨ kat ana kwulatndi. ");
INSERT INTO ian_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nandinya ngan nandinya ngan kiyaa nɨmba waangumba taagalɨnja kavamba duwi la kavamba avla kaambapmba sɨlɨmbinda kɨsala lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Sɨvla mbundɨmba lɨga Jisas kat vɨlaa pɨlɨga yalaa Jisasna mangandɨmba ndandɨ. jisas ndɨ kat wandɨ. kavle waagan ndɨ kat kwagalalaa ay ngwula. wandɨ, wan nyan nɨma kwundimba walega wandɨ. Wun kat manda kat vat yigamɨn. Mɨn Godna nɨma nyan mɨn waa wandɨ. Godna sɨ waga wun kat ke yiga nɨma vat waa wandɨ. Godna sɨ waga wun kat ke yiga nɨma vat waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisas ndɨ kat wagalandɨ. mɨna sɨ angamak waigowun waa wandɨ. Wuna sɨ Nɨma Sakwat. Wupma nɨma sakwat tɨganɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nɨmbamba yawiga wandɨ. Waagan kat ke kapma ngepma yinjangat savɨlɨga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mbak nɨma sakwat yisolaa ngwaymba lɨga nduwimba kɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Waagan jisas kat yawiga wagalandi. Mbatnat nɨn kat savɨlɨ. Mbatnamba tavilaa lɨgiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas kwowa wandɨ maa waagan wan nyan kat kwagalalaa mbatnanamba tavilɨndi. Tavilɨndi maa wundi mbak nduwimba tɨlanda ndaindi. Dailaa ngumba yindi. Mbak 2,000 ngu kɨgiyatndi. ");
INSERT INTO ian_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mbak kak vɨga la nɨmba vaaka yindi. Ngepma ta kavamba ngepma lapman kavamba ndinyangu kat yiga mbutndi. ndinyangu wutaa Jisas kwutna vat vɨvat yindi. ");
INSERT INTO ian_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jisas ta kava yalaa waagan tat tavila la nyan kat vɨndi. Tat nɨma sakwat waagan tavila nyan waavwi kwusolaa apma maawut sɨka lɨnda vak kat vɨndi. Vɨlaa vaatndi. ");
INSERT INTO ian_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wan nɨmba mbatnagwi waagan tavila la nyan kat Jisas kwutɨndangat yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","18","Wan ngepma nɨmba Jisas kat wandi. Nɨna ngepma kwagala yawiga wandi. Jisas daa vaala kundɨ maa tak waagan tavila la nyan ndɨna kwupmba yivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisas ndɨ kat kai wandɨ. Mɨn kat awagapma mɨna yinda vak kat ayga wamɨla waa wandɨ, Jisas. ");
INSERT INTO ian_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wandɨ maa kwagalalaa ngepma tamba vɨli ta kavamba yiga Jisas ndɨ kat kwutna vak kat mbutɨndi. mbutndɨ maa wuta nɨmba ngɨpaliga ndandi aywaa. ");
INSERT INTO ian_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ak Jisas wumbayambɨ vaalamba valɨgendɨ. Waambu sapmba lɨlɨndɨ maa nɨma sakwat nɨmba yaa yisondi. ");
INSERT INTO ian_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nyaangɨt ngambulɨnja ngayna nɨma nyan ndɨna sɨ Jairas, Jisas kat vɨlaa mangandɨmba yaak yaak ndandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jisas kat wandɨ. Wuna tagwanyan kiyavat yigalɨ waa wandɨ. Mɨna taamba lɨ kat taagameyan ana kiyaigalɨ. Kwo lɨgiyalɨ waqa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisas Jairasna kwupmba yalɨndɨ maa nɨma sakwat nɨmba wupma kwupmba yisolaa kemaka yalɨndi. ");
INSERT INTO ian_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yaat tɨgtɨmbimba yelogwen yila taagwa lɨlɨ. Naambi tamba vɨli kiyeli vɨlɨlɨk yelogwen yiga yilɨndakat tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nɨma sakwat dokta lɨ kat kwunapmak yilɨnjan ana apma vat tɨlɨ. kavle nglei yilɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jisas kat wanja nyaangɨt wutaa nɨma sakwat nɨmbana nɨndɨmba lɨga ndɨna kwupmba yaga ndɨna waavwi sɨnyɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wat taagwa yelavɨtaa walɨ. ndɨna waavwi sɨnyɨkweyan kwo lɨgiyowun waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sɨnyɨtɨ, yelogwen yi la kava tɨvɨndɨ. Lɨla mbangɨ kwo lɨnda vatalva yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisas wuna kwondu samat ngɨlɨndɨ waa yelavɨtndɨ. Yelavɨtaa lɨmbalaguga kwutmɨni vɨlaa wandɨ. Wuna waavwi kanda sɨnyɨka waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ndɨna kwupmba la nɨmba wandi. ngwaymba lɨga kemaka nɨma sakwat nɨmba kat vɨga lɨgamɨn. Manda kat kanda sɨnyɨka wagalamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sɨnyɨta nyan vɨvat jisas lɨmbalaguga kwatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wat taagwa lɨ kat kwutaa vak kat yelavɨtaa vaaka ava plalaa yalaa ndɨna mangandɨmba ndalaa ndɨ kat aywaa mbutɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas lɨ kat wandɨ. Tagwa nyan nyɨna mbangɨ wiyo waavi laaganda vapmba nyɨna yelogwen ngɨlɨndɨ waa wandɨ. Apma vat ay. kwo lɨgiyanyɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Walɨndɨ maa nyaangɨt ngambulɨnja ngayna nɨma nyana ngay la nɨmba yalaa wandi. Mɨna tagwa nyan tamba kiyalɨ waa wandi. Manda kat sɨmaga lɨga nyan kat wumba lɨndɨ wagalalɨgamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas wutaa wan nyaangɨt kat kai walaa nyaangɨt ngambulɨnja ngayna nɨma nyan kat wandɨ. Ke vaaka. Mɨna mbangɨ wiyo waavi taaga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas nat nɨmba ndɨna kwupmba yavakak kai wandɨ. Pita, Jems, Jon kat kuvut nɨmba mɨna ndi kat kai ana wandɨ. Jon Jemsna swambu. ");
INSERT INTO ian_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naangɨt ngambulɨnja ngayna nɨma kwundimba nglala nɨmba kat vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisas wuleiga lɨga ndi kat wandɨ. Manda kat mandɨp mandɨp yiga nglalɨgangwuk. Mat nyan ana kiyalɨ. Sɨndu kwalɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wandɨ maa ndɨ kat kasendi. Ndi kat savɨlɨlaa mat nyana nyaet nyɨme ndɨna kwupmba la nɨmba apma mat nyan tɨga kava wuleindi. ");
INSERT INTO ian_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Taambamba kwutaa lɨ kat ndina ngepma kwundimba wandɨ. Talita kumi wandɨ. Wupma wandɨ. Mat nyan laak waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wandɨ, laataa man veilɨ. Lɨla naambi tamba vɨli kiyeli vɨlɨlɨk. Veilɨ maa lɨ kat vɨlaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ndɨnai kwutna vat sɨmogwivak kak kai wandɨ. Ndi kat wandɨ. Lɨ kat kɨgɨnda agwi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wan ngepma kwagalalaa ndɨna angwa ngepma yindɨ. Ndɨna kwupmba la nɨmba ndɨna kwupmba yindi. ");
INSERT INTO ian_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Njwvwa lapman nandinyamba nyaangɨt ngambulɨnja ngaymba mbuka wandɨ. nɨma sakwat nɨmba wutaa ngɨpaliga ndalaa wandi. Maawupmba yelavɨtnda vak ndɨ kat kandana kwiya. mandamba kwunatnda nɨma njɨvwa kwutɨndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ndɨna nyaek ngay kwuta nyana. ndɨ mariana nyana. Jems, Josis, Judas, Saimon ndina nyamwun ndɨ. Ndɨna nyange nɨnanala yetɨndi. jisas kat ndina maawupmba kavle vat yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas di kat wandɨ. God waa nyaangɨt mbutɨga nyan kwo ngepma lɨndeyan ndɨ kat apma maawut yelavɨkiyandi. ndɨna angwa ngepma lɨndeyan ndɨna ngepma nɨmba ndɨ kat kai waigandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wungi kat tɨga wan ngepmamba nɨma njɨvwa ana kwutndɨ. Yelogwenga ta nɨmba kuvuti mɨna taamba laakandɨ, kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ndina mbangɨ ndɨ kat vali yindangat Jisas ngɨpaliga ndalaa ngepma ngepmamba yiga sɨmagaga mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wundi tamba vɨli kiyeli vɨlɨlɨk nɨmba kat yagwa walaa ay wandɨ. Vɨli vɨli ay ngwula wandɨ. Waagan kat savɨlɨnjangat ndi kat kwondu kwindɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ndi kat wandɨ. Naaw lapman kɨmbi lapman sanya lapman ay wandɨ. Vasɨ vasɨ mɨna klalaa ay waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man su kwusolaa waavwi kɨta kwusolaa ay wandɨ. Waavwi vɨlɨlɨk ke kwusoga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ndi kat wandɨ. Ngepma wuleilaa ngay ngay ke yiga kɨga. kita ngaymba kɨga alɨ waa wandɨ ");
INSERT INTO ian_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nat ngepmana nɨmba ngwuk kak wupmak kat kai wanjeyan wan ngepma kwagala. kwagalalaa man mbaw vɨvlɨ. ndinai kai waa vak sɨmagavak kak vɨvlɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wupma yiga mbutndi. Kupi maawut yelavɨk waa mbutndi. Kavle vat yetɨlɨngwa vak kat kwagala waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Waagan nɨma sakwat savɨlɨndi. yelogwenga ta nɨmba kat ngwaat kuvut salɨka kwunatndi maa kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nɨma sakwat nɨmba Jisas kat wutɨndi. Wan kavana njambwi nyan Herot ndɨno wutndɨ. Nat nɨmba Jisas kat weandi. Ndɨ ngu yagu la Jona. Kiyalaa laatndɨ waa wandi. Wupma kwondumba nɨma njɨvwa kwutɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nat nɨmba wandi. ndɨ Ilaija waa wandi. Nat nɨmba wandi. God waa nyaangɨt tamba mbuta nyana vla lɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot wutaa wandɨ. nambu kalɨkwa Jon kɨngiyan. Kyalaa laatndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Tat ngu yagu la Jon Herot kat wandɨ. Mɨna nyamwuna taagwa kwo klaman ana nglaatndɨ waa wandɨ. Kerot klaa taagwa Herodias wan nyaangɨt wutaa Jon kat walialɨ. Ndɨ kat vatnyavat yilavilaa lɨlɨ. Herotna nyamwun Filipna taagwa Herodias kat tɨga Jon kat kwutaa man taamba sangilaa kalabusmba taagandɨ. Herot Jon kat vaatɨndɨ. Savagu maawut tɨndangat vɨlaa Jon kat miwa yindɨ. Wupma Herodias vatnyavat yilavilaa lɨlɨ. Herot Jon waa nyaangɨt wutaa yigumba ana maawut sɨtndɨ. Ndɨnai waa nyaangɨt nolin ngwandɨga wutndɨ Herot. ");
INSERT INTO ian_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herot kwutnja naambina nandinyamba nɨma kɨgɨnda kwutɨndi. ndɨna kwupmba la nɨmbagwi kao lɨlɨga njambwi nɨmbo Galilina njambwi nɨmbagat kap ti kwutɨndi. Wan nandinyamba wuna maawupmba kwukiyowun waa yelavɨtɨ Herodias. ");
INSERT INTO ian_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiasna taagwa nyan yalaa mbangu veilɨ. lɨlai veilaa vak kat Herotagwi ndɨnanala la nɨmbo lɨ kat vɨlaa nolin ngwandɨndi. Veilɨ maa Herot tagwa nyan kat wandɨ. Kla nda klavat wanyeyan nyɨn kat klalaa kwigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nyaet sɨga yiga wandɨ. Anda nda klavat wanyeyan nyɨngat klalaa kwigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wandɨ, yilaa nyɨme kat walɨ. Angamak wagalagiyowun waa walɨ. Walɨ, nyɨme walɨ. Ngu yagu la Jona nambu kat wagala waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Walɨ, kwiyatapman Herot kat yiga wagalalɨ. Ngu yagu la Jona namb u kalɨtaa yaanjɨmba taagtalaa wun kat kwiyatapman agwi waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot Jon kat miwa yilɨndɨ. Ndɨnai lɨ kat nyaek sɨga yiga wanda vak ndɨnanala kɨlɨga nɨmba tamba wutndi. Wungi vat mandɨp vak ana yigiyowun waa yelavɨtndɨ Herot. ");
INSERT INTO ian_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herot yelavɨtaa ndɨna kao lɨlɨga nyan kat nambu kalɨtaa agiya wandɨ. Wandɨ maa kalabusmba kalɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kalɨtaa yaanjɨmba taagalaa tagwa nyan kat kwindɨ. kwindɨ, nyɨme kat kwilɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jona kwupmba la nɨmba wutaa yaa ndɨna sɨm klalaa waangumba taagandi. ");
INSERT INTO ian_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas apma nyaangɨt yiga ambuk waa wanda nɨmba yalaa Jisas kat ndinai kwutna vapmba ndinai sɨmagaga waa vapmba aywaa mbutndi. ");
INSERT INTO ian_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ndi yilaa yanjan waangɨt ana pugwalɨndi. Yilaa yalaa yetɨlɨnjan naaw ana kɨlɨndi. Wungikat tɨga Jisas ndi kat wandɨ. Nat nɨmba kwagalalaa kwo kavat yagwa ngwula. Samat waangɨt pugwalɨga yagwa ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Vaalamba kwo kavat avla yindi. ");
INSERT INTO ian_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ndinai ya vak kat vɨlaa nɨma sakwat nɨmba ngepma ngepmamba lɨga kawinjeya kavat tata yivat angwa yambak pɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kawindi maa nɨma sakwat nɨmba kat Jisas vɨndi. Jisas wan nɨmba ndunyan vɨlapman tɨga sip sip vla lɨndi waa yelavɨtaa ndi kat miwa yiga di kat nɨma sakwat vak kat sɨmagaga wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nya ndaivat yilɨndɨ maa Jisasna kwupmba la nɨmba ndɨ kat wandi. Wan kava kwo kava nya ndaivat yilɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndi kat ay awa waa wandi. Ngwaymba lɨga ngepma lɨga kava kɨgɨnda klavak ay waa awa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wandi, wandɨ. Mbaolamba tamba vɨli kiyeli vɨlɨlɨk yaagilaa ndi kat naaw kwivak kak klaiganɨn? waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisas ndi kat wandɨ. Ngwula nao anda sakwat tɨgandɨ. Yiga vɨga avɨ waa wandɨ. Vɨlaa yalaa wandi. Nao tambanat kami vɨlɨlɨk tɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kwandɨ yuwimba yiga mbaapma mbaapmamba yiga ndaalɨ ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wupma ndaalɨndi. Mbaapma ndumi tambanat tɨgandɨ. Mbaapma kɨtamba ndumi vɨli kiyeli tamba vɨli nɨmba tɨndi. ");
INSERT INTO ian_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisas nao tambanat kami vɨlɨlɨk taambamba kwutaa nyɨnangwutnat vɨga God kat kɨgɨnda kat sɨvu kɨndɨ. Ngambulaa nao samat samat lɨmbalaa mɨna ndɨna kwupmba la nɨmba kat nɨma sakwat nɨmba kat kwivakak kwindɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aywaa kɨndi. Yaat taatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Klambɨnjan nao kɨgɨnda mbanimba naangandi. Mbani tamba vɨli kiyeli vɨlɨlk naangandi. ");
INSERT INTO ian_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ka duna sakwat 5,000. ");
INSERT INTO ian_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisas ndɨna kwupmba la nɨmba kat nat naangamba Betsaida walɨnja ngepmat vaalamba ay wandɨ. Yilɨndi maa wan nɨma sakwat nɨmba kat ngiyambak ay ngwula wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ndi kat kwagalalaa nduwi la kavat God kat ngambuvat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kulun wandɨ ma vaala nɨndɨ sapmba lɨndɨ. Jisas nɨmbumba kapma lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mwuk ndina pumba viyalɨndɨ, ngusa nɨma njɨvwa kwuka kalɨnja vat Jisas vɨndɨ. mbambala nglei vɨtɨtindɨ ndinai la kavat tagu ngumba veiga yindɨ. Ndi kat kwulaka tata yivat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tagu ngumba veiga yindangat vɨlaa wundumbu waa yelavɨtaa kɨsalandi. ");
INSERT INTO ian_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vɨlaa vaaka yindi. Ke vaaka wun Jisas wun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Walaa ndina vaalamba kundɨ maa mwuk kiyak wandɨ. Mwuk kiyak wandɨ maa ngɨga ndandi. ");
INSERT INTO ian_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisas nao kwutna vak kat ndina maawut ana yelavɨtndi. Wungi vak kat tɨga tagu ngumba yanda vak vɨla ngɨga ndandi. ");
INSERT INTO ian_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Valɨgelaa Genesaret walɨnja ngepma kawilaa mbonjwe tawlaa yaaw tundi. ");
INSERT INTO ian_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Vaala kwagalaa valilaa wokendi maa nɨmbumba la nɨmba Jisasna mɨndama vɨndi. ");
INSERT INTO ian_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ngay ngay yilaa njambamba la nɨmba yelogwenga ta nɨmba kat Jisas ta kava kat wutaa ndɨnai la kavat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nɨma ngepma mat ngepma ngepma lapman kava apma Jisas yandɨ maa wenga kavamba yelogwega ta nɨmba kat kiyalaa taagandi. Jisasna njɨmbwi waavwi sɨnyɨpmak wagalalaa lɨndi. Sɨnyɨta nɨmba kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Jerusalemba la yaa nyaangɨt pɨlɨwutɨga nɨmbagwi Ferisio Jisas ta kava yalaa Jisasna kwupmba la nɨmba taamba ngu njangilapman kwo kɨnjangat vɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ferisiagwi nat Juda walɨnja nɨmbo aywaa taamba ngu njagilapman ana kɨlɨndi. ndina ngwat ta vapmba njangilaa kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wengamba klalɨnja kɨgɨnda njangilapman yinjeyan ana kɨlɨndi. Nat vak nɨma sakwat vat kwunapmak yilɨgandi. Kap njangilɨnja vat, aw njangilɨnja vat, kapamba viyanja aw njangilɨnja vat, sɨndu kwaa njamba njangilɨnja vat, mandɨp mandɨp vat yilɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ferisiagwi nyaangɨt pɨlɨwutɨga nɨmbo Jisas kat wagalandi. Mɨna kwupmba la nɨmba manda kat ngwatna vapmba ana yilɨgandi. Manda kat tamba ngu njangilapman taambamba kɨlɨgandi waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas ndi kat wandɨ. Ngwuk mandɨk ngambuga mandɨt yetɨga nɨmba ngwuk. Aisaia ngwuk kat mbutndɨ. Woseka ana wandɨ. Wupma God waa nyaangɨt pɨlɨwutndɨ. Wundi nyangu ndina kwundimba wuna sɨ nɨma tɨndangat walɨgandi. Ndina maawupmba wun kat ana yelavɨtɨgandi. ");
INSERT INTO ian_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ndinai wun kat nambu sɨlandalaa maawupmba yelavɨtnja vat kwo vatnat tɨlɨgandɨ. God waa nyaangɨt kwagalalaa ndinyanguna nyaangɨt nat nɨmba kat sɨmagaga mbutndi waa pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","God waa nyaangɨt kwagalalaa ngwat waa nyaangɨtmba mɨna yetɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","God waa nyaangɨk kat kai walɨgangwuk tuwa. Ngivat ngwutna vapmba yetɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses ngivak wandɨ. Nyaek kat nyɨme kat apma vat ay wandɨ. Nyaek nyɨme kat kavle vat walɨga nyan kiyaa tɨgandɨ waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngwuk kapma vapmba wangwuk. Kɨta nyan ndɨna nyaek nyɨme kat mbɨk kat kwiweya nda tamba God kat kwiwun waa wandeyan apma vatna waa wangwuk. Wan vak kat “koban” walɨngwa vatna. ");
INSERT INTO ian_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ndɨna nyaek nyɨme kat ana vɨga lɨgiyandɨ waa wangwuk. ");
INSERT INTO ian_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","God kwiya apma nyaangɨt kwagalaa kavle nyaangɨtmba kwilɨgangwuk nat nɨmba kat. Nɨma sakwat wungi vat kvale vapmba yetilɨgangwuk wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas ta nɨmba kat nat njambɨ yagwa wandɨ. Walaa ndi kat wandɨ. Ngwuk awuk ngwula. Maawupmba yelavɨk ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndinyangu kɨgiyaa nda ndɨna maawuk kat ana kavle yigiyandɨ. Maawupmba lɨga wogwegiyaa nda ndinyangu kat kavle yigiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Waan wuka lɨgiyaa nɨmba awut waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wan nɨmba kat kwagalalaa ngay wuleindɨ maa ndɨna kwupmba la nɨmba ndɨnai waa nyaangɨk kat ndɨ kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ndi kat wandɨ. ngwutna maawut yigumba ana sɨka lɨgangwuk? Ndunyan kɨgiyan nda ndɨna maawuk kat ana kavle yigiyandɨ. Ana vɨlɨgangwuk? waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kɨgiyan nda ndɨna maawut ana wuleigiyandɨ. Yaapmba lɨga kwo wogwegiyandɨ. Kɨgɨnda aywaa apma mɨna waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Maawupmba lɨga wogwegiyaa nda ndinyangu kat kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ndinyanguna maawupmba lɨga wogwegiyaa vat kɨngiyan. Kavle maawut yelavɨtnja vak, sɨmblan wangɨlɨnja taagwa kat yilɨnja vak, sɨkwutnja vak, ndinyangu kat vatnyalɨnja vak, nat nyana taagwa kat wangɨlɨnja vak, ");
INSERT INTO ian_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nat nyana nda klavat walɨnja vak, kavle vat yetɨlɨnja vak, nyɨnangat kwutɨnja vak, yambɨsɨk yilɨnja vak, kavle maawut yelavɨtnja vak, njɨka walɨnja vak, avla nolin ngwandɨnja vak, kwusɨlɨga kaselɨnja vak. ");
INSERT INTO ian_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wan kavle vak aywaa maawupmba lɨga wogwelɨndan ndinyangu kat kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wan nyaangɨt walaa Jisas laataa Taiagwi Saidano walɨnja ngepma vɨlɨlɨk ta kavat yindɨ. Ngay wuleilaa ndɨnai wuleia vat vɨvak kat kai waa tɨndɨ. Tamba vɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngay wuleindɨ maa waagan tavila la tagwa nyana nyɨme Jisas yanda vak wutaa yalaa ndɨna mangandɨmba ndalɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wat taagwa kapma ngepma lagwat. Lɨla angwa ngepma Siria Finisia. Glik walɨnja kwundimba wala taagwat. Lɨla tagwa nyamba tavila waagangat savɨlɨndangat Jisas kat walɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisas lɨ kat wandɨ. Tat mat nyan kɨgiyandi. Mat nyana nao waala kat yitenjeyan ana nglaatndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wandɨ, njambwi nyan ngiyambak wamɨn waa walɨ. Njamba pulumba waala mat nyan kɨlaa kwat nao ndalɨndɨ, kɨlɨgandi waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","30","Lɨ kat wandɨ. Wupma walaa yigiyanyɨn. nyɨna taagwa nyan kat waagan taamba kwagalandɨ waa wandɨ. Wandɨ maa yilaa njambamba vɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taia kwagalalaa Saidon wuleilaa kwagalalaa ngepma tamba vɨli ta kava yilaa kwagalalaa Galili walɨnja sak yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Waan tɨvɨga kwundi kɨla la nyan Jisas kat kiyandi. Kiyalaa Jisas taamba ndɨ kat taagandagat mbutndi. ");
INSERT INTO ian_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisas nɨma sakwat nɨmba ta kava kwagalalaa ndɨ kat kapma kava kalilaa ndɨna waan vɨli apa sɨt taamba sɨsolalaa sɨpmiya salaa ndɨna tɨgatmba sɨt taamba laagandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jisas nyɨnangwutnat vɨga yaat njawiaga wan nyan kat ndɨna kwudimba “Efata” waa lavwi ke tɨvɨga wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wandɨ maa ndɨna waan wuka ndɨna kwundi apma vat ngambundɨ. ");
INSERT INTO ian_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas ndi kat wandɨ. Nat nɨmba kat ke mbuka waa wandɨ. Wupma walɨndɨ maa nat nɨma sakwat nɨmba kat mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ngɨga ndalaa wandi. Aywaa yigumba kwunatɨndɨ. Waan tɨvla la nɨmba kat walɨndɨ. Kwundi kɨlɨla la nɨmba kat walɨndɨ maa apma vat ngambulɨndi waa ngɨpaliga ndalaa walɨndi. ");
INSERT INTO ian_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Samat tɨga nat njamba nɨma sakwat nɨmba yisolaa lɨndi. Ndina kɨgɨnda ngɨlɨndɨ maa Jisas ndɨna kwupmba la nɨmba kat yagwa walaa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nandinya kuvut wunanala tɨndi maa ndina kɨgɨnda ngɨlɨndɨ. Ndi kat miwa yiga loɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nao kɨlapman tɨndi ndi kat ngepma ay waweyan nat nɨmba yiga ava yambɨmba wundɨ kat tɨga ndaigandi. Nat nɨmba sivlamba lɨga yandi. ");
INSERT INTO ian_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndɨna kwupmba la nɨmba ndɨ kat wandi. Kwo kavqamba lɨganɨn. Kɨgɨnda andambas klalaa kwigiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas ndi kat wandɨ. Naaw anda sakwat tɨgandɨ waa wandɨ. Wandɨ, naaw sɨla vɨli lɨgandɨ wandi. ");
INSERT INTO ian_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas ndi kat kɨpmamba ndaalɨ wandɨ. Nao sɨla vɨli klalaa kwutaa God kat apma vat kwimɨn waa waga samat samat lɨmbaga mɨna ndɨna kwupmba la nɨmba kat kwinjangat kwindɨ. Kwindɨ maa awat nat nɨmba kat kwindi. ");
INSERT INTO ian_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nat kami kuvut tɨndi. Jisas God kat wungi vat sɨgɨt walaa agwi wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ndi aywaa kɨndi. Ndi alɨpsɨga wan nao kɨgɨnda kɨndi. Klambɨnjan nao kɨgɨnda mbani sɨlavɨli naangandi, mbani taatndɨ. Ka nɨmba 4,000. ");
INSERT INTO ian_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jisasna kwupmba la nɨmba klambɨnjan nao naangalɨndi maa Jisas nɨma sakwat nɨmba kat ngepma ay ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jisas ndɨna kwupmba la nɨmbanala vaala kundi maa Dalmanuta walɨnja kavat yindi. ");
INSERT INTO ian_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferisi yalaa Jisas kat kwundimba waliavat tɨndi. Ndɨ kat wandi. Kwutɨma njɨvwa sɨmogwi lɨma vak kat vɨlaa mɨn Godna nyan mɨn waa yelavɨkiyanɨn. ");
INSERT INTO ian_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisasna mbangɨ ndi kat kɨlɨpangɨ yilaa wandɨ. Mbambala lɨga nɨmba ndi sɨmogwi nda mɨna vɨvat walɨgandi. Ngwuk kak wowun. Sɨmogwi nda ngwuk kat ana sɨmogwigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ndi kat kwagalalaa nat njambɨ vallamba kulaa nat naanga valigendɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nao klavak kwagalalaa yindi. Vaalamba lɨga bret-nao kɨta lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas wandɨ. Ferisiagwi Herotna yis walɨnja mbiyak vla bret-naomba taakalɨnja nda kat yigumba vɨmba ngwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ndɨnai ngambula vak kat wutaa avla ndi wagalandi. Nɨna bret-nao ngɨlɨndɨ maa nɨn kat kan nyaangɨt anagandɨ waa waa avla wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas ndinai waa nyaangɨt wutaa wandɨ. Manda kat nao lapman tɨngwangat ngambulɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mɨni ana vɨlɨgangwuk? Waan ana wutɨgangwuk? Ngwula maawut tɨvɨndɨ? Nao kat ana wowun. Ndina kavle vak yetɨnja vak kat wukwangat wowun. ");
INSERT INTO ian_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tat nao tambanat lɨmba mɨna kwiwun klambɨnjan nao anda sakwat mbani naangangwuk waa wandɨ. Wandɨ, wandi. Tamba vɨli kiyeli vɨlɨlɨk naanganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ndunyan 4,000 ndi kat nao sɨla vɨli kwiwun klambɨnjan nao anda sakwat mbani naangangwuk waa wandɨ. Wandɨ, wandi. Sɨla vɨli naanganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndi kat wandɨ. Wupma ngwula maawut ygumba ana sɨka lɨgangwuk? Manda kat nao ngɨlɨndɨ maa nɨmamba yelavɨtɨgangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida wuleindi maa mɨni kiyaa nyan kat Jisas taamba taagavak kak ndɨ kat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas mɨni kiyaa nyan kat taambamba kwutaa waambu ngepma kalindɨ. Ndɨna mɨnimba kwundi ngu laagalaa taamba laagalaa wandɨ. Vɨlɨgamɨn? waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wandɨ maa wan nyan vɨga wandɨ. Ndinyangu kat vɨlɨgowun. Mi vla lɨndi, vɨlɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wandɨ, Jisas nat njambɨ taamba mɨnimba taagandɨ maa mɨni kwitaa yigumba vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas ndɨ kat wandɨ. Ngepma wuleilapman ngay ay wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas ndɨna kwupmba la nɨmbanala Sisaria Filipai walɨnja kavana ngepma ngepmat yindi. Nɨndɨ ava yambɨmba Jisas ndɨna kwupmba la nɨmba kat wagalandɨ. Wunai luwangat angamak walɨgandi waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ndɨ kat wandi. Nat nɨmba mɨn kan ngu yagula Jon mɨn walɨgandi. Nat nɨmba mɨn kan Ilaija mɨn walɨgandi. Nat nɨmba mɨn God waa nyaangɨt mbuta kɨta nyan mɨn walɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jisas ndi kat wagalandɨ. Ngwuk wunai luwangat angamak walɨgangwuk waa wagalandɨ. Wagalandɨ, Pita wandɨ. Mɨn Kraist mɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita wandɨ maa Jisas ndi kat wandɨ. Wungi vak vak kat nat nɨmba kat ke waga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas wandɨ. Judana ngwatnagwi God kat walɨga njambwi nɨmbo nyaangɨt pɨlɨwutɨga nɨmbo wun kat kai waigandi. nɨma nɨma vat wun kat yigiyandi. Wun Godna vat smogwi lɨga nyan wun kat vatnyagiyandi. Kiyalaa nandinya kuvut tɨga laakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ndi kat wan nyaangɨt kapmba mbutndɨ. Ana pagwundɨ. Mbutndɨ maa Pita Jisas kat kwutaa kalilaa Jisas waa nyaangɨt kat kai walaa vɨtɨk walaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pita wandɨ maa Jisas lɨmbalagulaa ndɨna kwupmba la nɨmba kat vɨlaa Pita kat vɨtɨk walaa wandɨ. Seten wun kat kwagala waa wandɨ. Mɨn Godna maawupmba ana yelavɨtɨgamɨn. Mɨn ndinyanguna maawupmba yelavɨtɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nɨma sakwat nɨmbagwi ndɨna kwupmba la nɨmba kat yagwa walaa ndi kat wandɨ. Kɨta nyan wuna kwupmba yavat wandeyan ndɨna maawuk kat kai waigandɨ. Ndɨna mbangɨ kat kai walaa diwai kros kwutaa nyaambupmba walalaa kaliweya vla ndɨno kwutuwa njɨvwa kwukiyandɨ. Wuna kwupmba yavat wa nɨmba kwutɨwa njɨvwa ndino kwukiyandi. ");
INSERT INTO ian_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kɨta nyan ndɨna mbangɨ mɨna yelavɨka kwunatndeyan kavle yigiyandɨ. Kɨta nyan ndɨna mbangɨ mɨna yelavɨtapman wuna njɨvwa kwuka wan apma nyaangɨt mbutndeyan wan nyan apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kɨta nyan kɨpmana kwanda kwanda nda aywaa klalaa kavle vat yiga yetɨndeya vak klandeyan apma vatna? Kai. Apma vat ana ndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Apma vak yetɨndeya vak kak wenga anda sakwat kwilaa klaigandɨ. Wenga kai. ");
INSERT INTO ian_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mbambala lɨga nɨmba kavle vat yetɨlɨgandi. God kat kai walɨgandi. Kɨta nyan wunai waa apma nyaangɨt wan kavle nɨmba kat mbupmak kat ndɨna mbangɨ wup yindeyan ngɨni ndɨ kat wuna mbangɨ wup yigiyandɨ. Wuna nyaek wandɨ mala enselonala yaigowun. Apma vat tɨga yaigowun. Yaweya njɨmblamba wun kat wup yila nɨmba kat ndi kat wup yigiyowun. ");
INSERT INTO ian_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas ndi kat wandɨ. Wumba lɨga nat nɨmba God kwondumba vɨga lɨgiyaa vak vɨgiyangwuk. Ana tat kiyaigangwuk. Vɨlaa tɨga lɨga kiyaigangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nandinya sɨla kɨta yindɨ maa Jisas Pita Jems Jon kat nduwiat kalindɨ. Nduwimba kapma lɨndi maa ndɨ kat vɨlɨndi maa Jisasna mbangɨ mandɨk vak tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ndɨna waavwi nya vla sɨlɨndɨ. Njanginjeya waavwi sawun mɨna lɨgandɨ. Jisasna waavwi sawun ava vla lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tɨga lɨga Ilaijagwi moseso Jisas kat ngambulɨmbɨk mala vɨndi. ");
INSERT INTO ian_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Vɨndi maa Pita Jisas kat wandɨ. Sɨmagaga lɨga nyan, tɨnan apma vatna. yisombale kuvuk kwutneyan kwowa? Mɨn kat kɨta Moses kat kɨta Ilaija kat kɨta kwukiyanɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nɨma vaatɨnjangat angamak waigowun waa yelavɨtaa kwo wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mbaw ndi kat yaa pagwundɨ. God mbaw nɨndɨmba lɨga ndi kat wandɨ. Ndɨ wuna nyana. Ndɨ kat solat sɨga lɨgowun. Ndɨ kat awut waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wandɨ maa nat nyan tapman Jisas kapma lɨndangat kwaka vɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nduwimba lɨga ndailɨndi maa Jisas ndi kat walɨndɨ. Vɨngwa vak kat nat nyan kat wata ke mbuka. Wun Godna vak sɨmogwi lɨga nyan wun. Kiyalaa laakwun maa mbambala vɨngwa vak kat mbukiyangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wupma ana mbutndi. Avla ngambundi. Kiyalaa laakiyowun wanda nyaangɨk kat avla wagalaga ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jisas kat wagalaga wandi. Nyaangɨt pɨlɨwutɨga nɨmba Ilaija tat yaigandɨ ngɨni Kraist yaigandɨ waa walɨgandi waa wandi. Manda kat wupma walɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ndi kat wandɨ. Kwowa Ilaija yambɨ kwunapmak tata yandɨ. Wun Godna vak sɨmogwi lɨga nyan wun kat kavle vat yetɨnjeya vak kat wun kat kai wanjeya vak kat tamba manda kat pɨlɨwutndi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngwuk kak wowun. Ilaija tamba yandɨ maa ndina maawupmba la vapmba ndɨ kat yindi. Ndinai ya vak kat tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisasna kwupmba la nat nɨmba ta kavat aynat nɨmba yindi maa nɨma sakwat nɨmba Jisasna kwupmba la nat nɨmba la kavamba lɨndi. Moses kwiya lo sɨmogwi lɨga nɨmba Jisasna kwupmba la nat nɨmba kat kwundimba waliyavat tɨndi. ");
INSERT INTO ian_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wan nɨmba sakwat nɨmba Jisas kat vɨlaa nolin ngwandɨga ndɨnai lɨga kava ndɨ kat ngambuvat yindi. ");
INSERT INTO ian_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas ndɨna mbaapmamba la nɨmba kat wandɨ. Manda vatna ngambulɨngwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kɨta nyan wandɨ. Sɨmagaga lɨga nyan, wuna nondayan mɨn kat kiyawun. Tɨgat kulumata waagan ndɨ kat tavilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Waagan ndɨ kat tavilɨndɨ maa kɨpmamba ndalaa man taamba satega kwundi ngu ngaanga ngu ndalaa nɨmbi ngliaka lɨndɨ waa wandɨ. Mɨna kwupmba la nɨmba kat wowun. Savɨlɨ wowun. Ana alɨpsɨga savɨlɨndi waa wandɨ. Jisas wandɨ. Ngwuk ngwula mbangɨ wiyo waavi laagalapman nɨmba ngwuk. Wungi kat tɨga ana savɨlɨngwuk. ");
INSERT INTO ian_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Anda sakwat nandinya tɨga ngwuk kat sɨmagaga mbutiwun mala ngwula mbangɨ wiyo waavi taagagiyandɨ. Angambala nandinya wun tɨga ngwula mbangɨ kɨlɨpangɨ yinda vak kat mbukiyowun. Wan nyan kat kwutaa wun kat agiya wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ndɨ kat mat nyan kiyandi maa waagan Jisas kat vɨlaa mat nyan kat kwutndɨ maa kɨpmamba ndandɨ. Kɨpmamba ndalaa paaka lɨga kwundi ngu ngaanga ngu ndalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas mat nyana nyaek kat wagalandɨ. nandinya anda sakwat ngi vat yilɨndɨ waa wagalandɨ. Wagalandɨ, wandɨ. Mat nyan tɨndɨ ngi vak mɨna yilɨndɨ waa wandɨ nyaek. ");
INSERT INTO ian_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Waagan nɨma sakwat njamba ndɨ kat kwutaa yamba yaagilɨndɨ. Nɨma sakwat njamba ndɨ kat kwutaa ngumba yaagilɨndɨ. Vatnyavak yaagilɨndɨ. An kat miwa ay. Alɨpsɨga kwunapmak tɨmeyan ndɨ kat kwunak. ");
INSERT INTO ian_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas ndɨ kat wandɨ. Manda kat alɨpsɨga kwunapmeyan waa wamɨn. Mbangɨ wiyo waavi taakalɨga nyan nɨma njɨvwa kwutapman nda? waa waigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nyaek yawiga waga Jisas kat wandɨ. Mɨn kat wuna mbangɨ wiyo waavi samat samat taagalɨngandɨ. Wuna mbangɨ kɨlɨpangɨ yilɨnda vak kat kwunak waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nɨma sakwat nɨmba yisolaa lɨnjangat Jisas vɨlaa waagan kat wandɨ. Mɨn tɨgat kulumaka waan tɨvɨla lɨga waagan mɨn ndɨ kat kwagala. Nat njamba ke taviga waa nɨma kwundimba wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Waagan kɨselaa ndɨ kat kwutndɨ maa man taamba satnedɨ maa ndɨ kat kwagalandɨ vɨlaa tamba kiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jisas ndɨ kat taambamba kwutaa katsondɨ maa laatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisas ngay wuleindɨ maa ndɨna kwupmba la nɨmba ndɨ kat kpma kavamba wagalandi. Manda kat tamba ndɨ kat savɨlɨlapman yinɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas ndi kat wandɨ. God kat wakalalapman yilɨngweyan wungi vak waagan kat ana savɨlɨgiyangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wan kava kwagalalaa Galili walɨnja kavamba lɨga kwagalalaa yinda vak kat nat nɨmba vɨvak kat kai wandɨ. Ndɨna mbaapmamba la nɨmba kat kapma lɨga ndi kat sɨmogwivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ndɨna kwupmba la nɨmba kat sɨmagaga wandɨ. Wun Godna vak sɨmogwi lɨga nyan wun kat ngɨni nɨma sakwat nɨmba kwutaa vatnyagiyandi. Vatnyandi maa nandinya kuvut tɨga laakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ndɨnai waa nyaangɨk kat Jisas kat wagalvak kat ndina tɨpmwi wup yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapaneam wuleilaa ngay wuleindi maa Jisas ndi kat wagalandɨ. Ava yambɨmba manda vatna ngambulɨngwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngɨni anda nyana nɨna nɨma nyanat tɨga nat nɨmba kat vɨga lɨgiyaa waa ngambulaa ndɨna nyaangɨt kat ndina mbangɨ wup yiga na awat wandi. ");
INSERT INTO ian_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas ndaalɨga tamba vɨli kiyeli vɨlɨlɨk nɨmba kat yagwa walaa ndi kat wandɨ. God waa apma nyaangɨtmba wandɨ. Kɨta nyan nɨndɨ vaalamba ndaalɨga nyan tɨga vla lɨndeyan God ndɨ kat yelavɨkiyandɨ. Ndɨ njambwi nyan ana ndɨ waa yelavɨkiyandɨ. Kɨta nyan avla ndɨna sɨ kwusoga walapman yiga nat nɨmbana njɨvwa kwutndyeyan God ndɨ kat yelavɨkiyandɨ. Wan nyan njambwi nyana waa yelavɨkiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mat nyan kwutaa ndina nɨndɨmba valagalaa taambamba kwutaa katsolaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Kɨta nyan wungi vat mat nyan kat wuna sɨ waga kwunatndeyan ndɨna njɨvwa wuna lak yaigandɨ. Kapma wuna lak ana yaigandɨ. Wun kat ay waa nyan kat yaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Jisas kat wandɨ. Sɨmaga lɨga nyan, kɨta nyan mɨna sɨ waga waagan savɨlɨndɨ. Savɨlɨnda vak kat vɨlaa ndɨ kat kai wanɨn. Nɨna mbaapma ana yetɨlɨgamɨn walaa kai wanɨn. ");
INSERT INTO ian_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas wandɨ. Kai ke waga. Kɨta nyan wuna sɨ waga nɨma njɨvwa kwutndeyan ngɨni wun kat kavle nyaangɨt ana mbukiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mɨn kat kai walapman nɨmba nɨna mbaapmamba lɨ vla lɨgandi. ");
INSERT INTO ian_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngwuk kat wowun. Kraistna mbaapmamba lɨngwangat ngwuk kat kɨlɨnja ngu kwinjeyan awat apma vat wunamba klaigandi. ");
INSERT INTO ian_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kɨngi vat mat nyana wun kat yelavɨtnda vak kat nat nyan kai wandɨ maa wun kat kwagalalaa yindeyan wan ana nglaatndɨ. Wan kai waa nyan kat kambak yaawumba ndɨna kwapmba tulaa ngumba yiga yaagɨnjeyan apma vatna. ");
INSERT INTO ian_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kɨta nyana taambamba kwutaa kavle njɨvwa ndɨna maawupmba lɨga apma vak kat kwulatndeyan taamba kalɨka tɨgandɨ. Taamba lapman apma kavat yindeyan wovuna. Apma tamba lɨga kavle kava ya vɨtɨga kavat yindeyan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kɨta nyan kavle kavat mamba yilaa wan kavamba kavle njɨvwa kwutnda njɨvwa ndɨna maawupmba lɨga apma vak kat kwulatndeyan man kalɨkiyandɨ. Sambɨn tɨga apma kavat yindeyan apma vatna. Man apma vat tɨndɨ kavle kava ya vɨtɨga kavat yindeyan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kɨta nyan mɨnimba vɨnda kavle vat ndɨna maawupmba lɨga apma vak kat kwulatndeyan mɨn pɨnguka yaagigiyandɨ. Mɨni lapman kɨta naanga mɨnimba vɨga apma kavat yindeyan apma vatna. Mɨni vɨli apa apma vat tɨmbɨk kavle kava ya vɨtɨga kavat yindeyan ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wan kavamba ya vɨtɨga vak ana ngɨlɨgiyandɨ. Wan kavamba ngak kawiya sɨm kɨlɨnda vak ana ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","Njangu veivat yiga ndamba sol taakandi, sol kwunakiyandɨ. Ngɨni sol taagalɨnja vak vla God ngwuk kat yamba kwunakiyandɨ. Sol apma nda. Solna nyingi yilɨga vat ngɨlɨndɨ maa ngɨni mandamba kwunakiyangwuk. Ngwuta lak yigumba alɨ ngwula. Sol taagalɨnja wimbu vla apma vat tɨgiyangwuk. Ngwuk yigumba kɨtamba lɨgiyangwuk. Yakwa nɨmba lɨga vak vla alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wan kava kwagalalaa Judia yindɨ. Jodana nat naangat valigendɨ. Nɨma sakwat nɨmba ndɨ kat yaa yisolaa lɨndi. Yisolaa lɨndi maa ndinai waa vapmba sɨmagaga mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nat Ferisi ndɨ kat mandɨp mandɨp vat wagalavat yandi. Kɨta nyan ndɨna taagwa kwagalandeyan kwowa? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas ndi kat wandɨ. Moses angamak ngwuk kat wandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wandɨ, wandi. Moses wandɨ. Kɨta nyan ndɨna taagwa kat kwagalavat wandeyan lavunga pɨlɨwutaa kwagalagiyandɨ waa wandɨ Moses waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas ndi kat wandɨ. Ngwulai kai walɨga vak kat tɨga wupma Moses wan nyaangɨt pɨlɨwutndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tamba God aywaa kwutndɨ. Ndu taagwa kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wungi kat tɨga kɨta nyan ndɨna nyaek nyɨmena ngay kwagalalaa taagwa klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nduwo tagwo kɨta vatna lɨgiyambɨk. Ngɨni kapma vak ana lɨgiyambɨk. ");
INSERT INTO ian_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God kɨta vak tɨmbeya vak kat kwutndɨ maa taagwa kwagalalaa mandɨp mandɨp kavat ay waa ke waga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngay wuleindi maa Jisasna kwupmba la nɨmba ndɨ kat ndɨnai waa nyaangɨk kat nat njambɨ wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ndi kat wandɨ. Kɨta nyan ndɨna taagwa kwagalalaa ngɨni nat taagwa klandeyan sɨkwuka wandgɨlɨgandɨ. Wangɨlɨndangat kwagalanda taagwa kat kavle vat yilɨgandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kɨta lagwa lɨla lan kat kwagalalaa ngɨni nat lan klaleyan sɨkwuka wangɨlɨgalɨ. Wangɨlɨlangat kwagalalaa lan kat kavle vat yilɨgalɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mat nyangu kat Jisas taamba taagandangat ndɨ kat kiyandi. Kiyandi maa Jisasna kwupmba la nɨmba kat nɨma kwundimba walendi. ");
INSERT INTO ian_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas walenja vak vɨlaa ndi kat nɨma vak walega wandɨ. Mat nyangu wun kat yaandi. Ndi kat kai waa ke waga. God vɨga lɨga vapmba ndi kat vɨga lɨgandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngwuk kat wowun. Kɨta nyan mat nyan kwo klanja vak vla God kwigiyaa vat klandeyan God tɨga kavat wuleigiyandɨ. Mat nyan klanja vak vla klavak kat kai wandeyan ana klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jisas mat nyan kat kwutaa ndaawamba laagalaa taamba laagalaa ndi kat apma nyaangɨt wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wan kava kwagalavat yilɨndɨ maa kɨta nyan ndɨ kat yalaa kwalimamba vaselaa ndɨ kat wagalandɨ. Apma sɨmaga lɨga nyan, ngɨlɨlapman apma vat yetɨweya vak klavak kak angamak kwuikiyowun waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas ndɨ kat wandɨ. Manda kat wun kat apma nyan waa wamɨn. Apma nyan ana lɨgandɨ. God mɨna apma nyana waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","God tamba waa nyaangɨt tamba wupmɨn waa wandɨ Jisas. Ndinyangu kat ke vatnyaga, nat nyana taagwa kat ke wangɨlɨga, ke sɨkwuka, woseka ke waga, woseka waga ke klaga, nyaek nyɨme kat yigumba kwunaka yetɨ. Aywaa wupmɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisas wandɨ maa kwandɨ nyan wandɨ. Sɨmaga lɨga nyan, mat nyan tɨga wupma wama nyaangɨtmba wuka yetɨlɨwun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas ndɨ kat vɨga miwa yiga wandɨ. Kɨta vak kwagalamɨn. Mɨna kwanda kwanda nda yiga wenga klalaa kwo lɨga nɨmbagat agwi. kwimeyan nyɨnangwupmba lɨga mɨna kwanda kwanda nda nɨma sakwat tɨgiyandɨ. Kwilaa wuna kwupmba yagwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jisas waa nyaangɨt wutaa ndɨna kwanda kwanda nda nɨma sakwat tɨndangat nambu njɨnjwenga nolin ngwandɨlapman yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas lɨmbalaguga ndɨna kwupmba la nɨmba kat vɨlaa wandɨ. Nɨma sakwat kwanda kwanda ndo lɨga nɨmba God vɨga lɨga kavat wuleivat nɨma njɨvwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ndɨna kwupmba la nɨmba wutaa ngɨpaliga ndandi. Jisas ndi kat nat njambɨ wandɨ. Ngwuk wuna nyangu ngwuk, God vɨga lɨga kavat wuleivat nɨma njɨvwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel kumbwi mbawna yambɨ wleivat yindeyan nɨma njɨvwa. Nɨma sakwat kwanda kwanda ndo lɨga nyan God vɨga lɨga kavat wuleivat yindeyan nɨma nglei njɨvwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wutaa nɨma vat ngɨpaliga ndalaa wandi. Kandana God vɨga lɨga kavat wuleigiyaa. God anda nyan kat apma vak kwunakiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas ndi kat vɨlaa wandɨ. Ndinyangu nat nɨmba kat kwutaa God vɨga lɨga kavat ana kaligiyandi. Wan Godna njɨvwa. Ndɨ alɨpsɨga kaligiyandɨ. Ndɨ nɨma nglei njɨvwa alɨpsɨga kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Jisas kat wandɨ. Nɨma nda kat kai waga kwagalalaa mɨna kwupmba yanɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisas wandɨ. Ngwuk kak wowun. Woseka ana wowun. Kɨta nyan wunagwi wunai waa apma nyaagɨk kat tɨga ndɨna ngay, nyamwun, nyange, nyaek, nyɨme, nyan, ngepma, kwagalandeyan mandɨk ngay, nyamwun, nyange, nyaek, nyɨme, nyan, ngepma, ndumi tambanat mbambala kaligandɨ. Ndɨ kat nɨma vat yinjeya vat apma kalaigandɨ. Yaiga nandinyamba ngɨlɨlapman apma vat yetɨndeya vak klaigandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wan kɨpmana yetɨla nat nɨma sakwat ndo lɨga nɨmba God vɨga lɨga yetɨla nat kwo la nɨmba God vɨga lɨga kavat wuleilaa njambwi nɨmbat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalem yilɨnja ava yambɨmba lɨga Jisas tata yindɨ. Ndɨna kwupmba la nɨmba ndɨnai waa nyaagɨt kat ngɨpaliga yalɨndi. Nat nɨma sakwat kwupmba yalaa nɨmba ndɨnai waa nyaangɨt kat vaatɨndi. Wan tamba vɨli kiyeli vɨlɨlɨk kat yagwa walaa wun kat yinjeya vak kat ngwuk kat mbutu wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Awut. Nɨn Jerusalem wokelɨganɨn. God kat walɨga njambwi nyanguagwi nyaangɨt pɨlɨwutɨga nɨmbo wun ndinyanguna nyan wun kat kwutaa kiyandi walaa Juda ana ndi nat nɨmba kat kaligiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wun kat kwusɨlɨga kasega sɨpmiya saga yaawmba viyalɨtaa vatnyagiyandi. Vatnyandi maa nandinya kuvut tɨga laakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebidina nyan Jemsagwi Jono Jisas kat yalaa wambɨt. Sɨmaga lɨga nyan nɨn kat kɨta njɨvwa kwupmangat walieyan kwukiyamɨn? E? Kai? waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas mbɨk kat wandɨ. Angamak kwukwangat wambɨt waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wandɨ maa wambɨt. Ndinyangu kat vɨga lɨvat ndalɨmeyan ana nat nyan yaagindan naangamba nat nyan ambugendan naangamba ndalɨvat waga waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas mbɨk kat wandɨ. Wagalamba vak kat mbɨtna maawut ana yelavɨtɨgambɨk. Wun kat nɨma vat yinjeyan wuna lak kwaigambɨk? Wun kat yinjeya nɨma vak mbɨk kat ygiyand? waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wandɨ, wambɨk. Awa kwowa wambɨt. Wambɨk, Jisas mbɨk kat wandɨ. Wun kat nɨma vat yinjeyan wuna lak kwaigambɨt. Wun kat yinjeya nɨma vapmba mbɨk kat yigiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yaagindan naangamba ambugendan naangamba ndalɨmbangat mbɨk kat kwondu ana kwigiyowun. Wuna nda ana ndɨ. God wungi nyan kat vɨsɨmogwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nat tamba vɨli nɨmba mbɨtna nyaangɨt wutaa Jemsagwi Jon kat walendi. ");
INSERT INTO ian_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisas ndi kat yagwa walaa wandɨ. Wan kɨpmamba la njambwi nɨmba nat nɨmba kat mandɨp mandɨp vapmba vɨga lɨgandi. Nɨma kwonduo lɨga vɨga lɨgandi. Wupma vɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngwuk wungivat wata kwutɨngweya. Kɨta nyan nɨma nyan tɨvat wandeyan ndɨna sɨ viyesandalaa nat nɨmbana njɨvwa kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kɨta nyan njambwi nyana lɨvat wandeyan aywaa nat nɨmbana njɨvwa kwutɨga nyana tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wun Godna vak sɨmogwi lɨga nyan wuna njɨvwa nat nɨmba kwutnjangat ana yawun. Ndi kat tɨga njɨvwa kwupmak yawun. Kwo luwa vat kwagalalaa kiyalaa nat nɨmba kat tɨga wenga kwivat yawun. ");
INSERT INTO ian_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeriko walɨnja ngepma wuleilaa kwagalagɨvaa yindi. Ndɨna kwupmba la nɨmbagwi nat nɨma sakwat nɨmbo apma yindi. Yindi maa mɨni kiyaa nyan Timiasna nyan Batimias wagalaga walelɨga nyan waambu ava yambɨmba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nasaretna nyan Jjsas yanda yak kat wutaa walega wandɨ. Jisas Devitna nyan wun kat miwa ay waa walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nɨma sakwat nɨmba ndi kat kai waa kiya awa waa wandi. Ndina kwundi wutapman wata nɨma kwundimba walelɨndɨ. Devitna nyan wun kat miwa ay mɨla walelɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Walelɨndɨ mala Jisas wuka yiga tolalɨga wandɨ. Ndɨ kat yagwa awa wandɨ. Wandɨ, mɨni kiyaa nyan kat ndɨ kat ke yelavɨka mɨn kat yagwa walɨgandɨ waa wandi. Laataa yagwa wandi. ");
INSERT INTO ian_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ndɨnai kambuga la waavwi lapmega kwagalalaa laataa Jisas kat yandɨ. ");
INSERT INTO ian_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas ndɨ kat wandɨ. Mɨn kat angamak yiwangat wamɨn waa wandɨ. Mɨni kiyaa nyan ndɨ kat wandɨ. Njambwi nyan, wuna mɨni kwunapmak kak wowun. ");
INSERT INTO ian_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ndɨ kat wandɨ. Mɨn ay wandɨ. Mɨna maawupmba yelavɨpma vat, mɨna mbangɨ wiyo waavi taagalɨga vak mɨna mɨni tamba kwunatndɨ waa wandɨ. Wandɨ, apma mɨni vɨlaa Jisasna kwupmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem ngwaymba lɨga Betfasi Betani walɨnja ngepma vɨlɨlɨkmba lɨndi. Oliv walɨnja mi ta duwi lɨndi maa Jisas ndɨna kwupmba la vɨlɨlɨk palɨ kat tata ay waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nat naangamba lɨga ngepma yiga valɨge mbɨla. Ngepma wuleilaa nyan donki yaawmba tulaa lɨndɨ, vɨgiyambɨt. Ndalɨlapman yilɨnja donki. Ndɨ kat yaaw sɨvugilaa agiya. ");
INSERT INTO ian_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kɨta nyan kat mandana yilɨmba wandeyan awamba mbɨt. Nɨma nyan klavat wandɨ waa awamba mbɨt. Ngɨni awat kwigiyandɨ waa awamba mbɨt waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wupma yɨmbɨt. Waambu ava yambɨmba lɨga ndaamangemba tunja donki kat vɨlaa sɨvugimbɨt. ");
INSERT INTO ian_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sɨvugimbɨt maa wumba la nɨmba mbɨk kat wandi. Mandana donki kat sɨvugilɨgambɨt waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jisas klavat wandɨ waa wambɨt maa kwowa kali wandi. ");
INSERT INTO ian_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jisas kat donki kiyambɨt maa ndina waavwi donkina mbunimba taagandi, Jisas ndalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nɨma sakwat nɨmba ndɨna alagumba la waavwi ava yambɨmba taagandi. Nat nɨmba kwapɨmba kalɨtnja ngaangawi la mi sandɨ taagandi. ");
INSERT INTO ian_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tata yilɨga nɨmbagwi kwupmba yilɨga nɨmbo kɨselaga wandi. Wovun nglei yamɨn. God yaiya vatna wugɨn yaa nyan mɨn kat nɨma tɨmangat wanɨn waa kɨselandi. ");
INSERT INTO ian_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nɨna ngwat Devit vɨga la apma vak yaiqandɨ. Apma nglei vatna waa kɨselandi. ");
INSERT INTO ian_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalem wuleilaa Godna ngay wuleindɨ. Ta nda vɨlaa ngan ndaivat yindɨ maa ndɨna tamba vɨli kiyeli vɨlɨlɨk nɨmbonala Betaniat yindi. ");
INSERT INTO ian_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nat nandinya Betanɨmba lɨga yandi maa Jisas kat wundɨ yilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sɨvlamba lɨga fik walɨnja ngaanga la mi vɨndɨ. Vɨlaa sɨgɨpmak yindɨ. Yalaa ngaanga mɨna vɨndɨ. Sɨt kwala njɨmbla ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mi kat wandɨ. Nat njambɨ ngɨnɨ kɨta nyan mɨna sɨk ana kɨgiyandɨ waa wanda vak ndɨna kwupmba la nɨmba wutndi. ");
INSERT INTO ian_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem wuleindi maa Jisas Godna ngay wuleilaa wenga klala la nɨmba kat savɨlɨndɨ. Nat nɨmba lavunga klalaa sanya kwila nɨmba. Ndina njamba kwuselɨtndɨ. Namiyo wenga kwila nɨmbana tɨgɨt kwuselɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Godna ngaymba lɨga kɨta nda kwutaa kiyalɨnjangat Jisas kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ndi kat sɨmagaga mbuka wandɨ. Tamba God waa nyaangɨt Pɨlɨwutndi. God wandɨ. Wuna ngay ngepma ngepmana nɨmba God kat ngambunjeya ngaya tɨgiyandɨ waa wandɨ God waa tamba pɨlɨwutndi. Sɨkwutɨga nɨmbana ngay vla lɨndangat yingwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wan nɨma sakwat nɨmba Jisas waa nyaangɨt wutaa ngɨpaliga ndandi. Wungi kat tɨga God kat kwunatɨga njambwi nɨmbagwi nyaangɨt pɨlɨwutɨga nɨmbo Jisas kat vaaka ndɨ kat vatnyavat yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ngan ndandɨ maa Jisas ndɨna kwupmba la nɨmbanala wan ngepma kwagalandi. ");
INSERT INTO ian_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngambi fik walɨnja mi tamba lɨga wundangat vɨgɨvaa yindi. Sandɨ, nɨndɨ, njingwut aywaa lɨga wundɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita wumbayambɨ yelavɨtaa wandɨ. Njambwi nyan kavle yigaandɨ wamɨn fik walɨnja mi tamba lɨga wundɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas ndi kat wandɨ. God kat ngwula mbangɨ wiyo waavi taaga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngwuk kat wowun. Kɨta nyan ndɨna mbangɨ God kat wiyo waavi taagandeyan wan nduwi kat nguat wokendangat wandeyan yigiyandɨ. Ngwula mbangɨ kɨlɨpangɨ yilapman yindeyan wangweya vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wungigat tɨga ngwuk kat wowun. God kat wagalangweyan klangwangat ngwula mbangɨ wɨyo waavi taakandeyan klaigangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","God kat waga lɨngweyan nat nyan kat waleya vak kat kai waa ngwaat vla sɨga kwunak. Ngwaat vla sɨga kwunakngweyan ngwula nyɨnangwupmba lɨga nyaek ngwuk kak ngwaak vla sɨga kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nat nyan mɨn kat kavle vat yinda vak kat ngwaat vla sɨga kwunatapman yingweyan ngwula nyɨnangwupmba lɨga nyaek ngwuk kat ngwaat vla sɨga ana kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nat njambɨ Jerusalem wuleilaa Godna ngay wuleilaa veiga ngaga yalɨndɨ maa God kat kwunatɨga njambwi nɨmbagwi nyaangɨt pɨlɨwutɨga nɨmbo Judana ngwatna Jisas kat yalaa walɨndi. ");
INSERT INTO ian_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mɨhai kwutɨga njɨvwa anda kwondumba kwutɨgamɨn. Kwupmangat kwondu kandana kwiya waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas ndi kat wandɨ. Ngwuk kak kɨta nda wagalagiyowun. Awat wangweyan wunai kwutɨga kwondu kat ngwuk kak waigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon ndinyangu kat yagunda kwondu ndinyangunamba klandɨ? E? Godnamba klandɨ? Wun kat awa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Avla ngambundɨ. Godnamba klandɨ waa waneyan nɨn kat wagalagiyahdɨ. Manda kat ndɨna maawut klalapman yingwuk waa waigandɨ waa ngambundi. ");
INSERT INTO ian_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ndinyangunamba klandɨ waa waneyan wan nɨma sakwat nɨmba nɨn kat kai waigandi. Wan nɨma sakwat nɨmba wupma yelavɨtndi. Jon God waa nyaangɨt ngambundɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wupma Jisas kat wandi. Nɨn ana yelavɨk lɨganɨn waa wandi. Wandi, Jisas wandɨ Wupma ngwuk kak wunai kwutɨga kwondu kat ana waigowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas ndi kat pagwuga la wupuseputmba mbutndɨ. Kɨta nyan glep watɨga ambugava kwutndɨ. Way ambugava tɨvwi kaambapmba kwutndɨ. Glep veinginyanjeyan waangu valaa ambugava kat vɨga lɨgiyaa sɨvla mbundɨ ngay kwutndɨ. Ambugava vɨgak lɨgiyaa nɨmba taagandɨ. Ndinai vɨga lɨgiyaa njɨvwa kat nat glep klaigandi. Ndi kat taagalaa nata ngepmat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Glep sɨkɨt njɨmbla lɨndɨ maa ndɨna njɨvwa kwutɨga nyan kat ambugavat ay wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ambugavamba wata nat glep klavak kak ay wandɨ. Ambugava yandɨ maa ndɨ kat kemaka kwutaa yiyandi. Glep klavat yindɨ, savɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nat njambɨ nat njivwa kwutɨga nyan kat ay wandɨ. Yindɨ maa ndɨ kat nambumba viyalaa kavle vat yindi. ");
INSERT INTO ian_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nat njambɨ nat kɨta nyan kat ay wandɨ maa yindɨ. Yandɨ maa ndɨ kat vatnyandi. Nat nɨmba nɨma sakwat ngivat sɨgɨt. Nat nɨmba viyandi. Nat nɨmba vatnyandi. ");
INSERT INTO ian_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Vatnyandi maa nat kɨta nyan mɨna lɨndɨ. Ndɨna nyana. Ndɨna nyan kat ambugavat ay wandɨ. Wuna nyan kat ana kavle yigiyandi waa maawupmba yelavɨtaa ay wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ndɨna nyan ambukava yandɨ maa vɨga lɨga nɨmba avla wandi. Wan nyan ambugava ngɨni klaiga nyana. Kan nyan kat vatnyalaa ambugava nɨna lak klaiganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ndɨ kat kwutaa vatnyalaa ndɨna sɨm mbuni lɨvwimba yaagindi. ");
INSERT INTO ian_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ambugava kwutna nyan vatnya nɨmba kat angamak yigiyandɨ waa wandɨ Jisas. Ndi kat vatnyalaa nat nɨmba kat ambugava kwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tamba God waa pɨliwutnja nyaangɨt wukngwuk? Wupma pɨlɨwutndi. Ngay kwuta nɨmba tat yaaginja kaambak ngɨni tagumba laagandi, lɨndɨ. Tɨga njambwi kaambaknat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wan vak God kwukna vatna. Kwutndɨ maa vɨlaa ngɨpaliga ndalaa apma vatna waa walɨganɨn waa pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas wan nyaangɨt wandɨ maa Judana njambwi nɨmba yelavɨtndi. Wanda nyaangɨt nɨn kat nɨma vat wavat wandɨ waa yelavɨtndɨ. Wungi kat tɨga Jisas kat kwutaa vatnyavat wandi. Wan nɨma sakwat nɨmba kat vaataa Jisas kat ana kwutndi. ");
INSERT INTO ian_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nat Ferisi walɨnja nɨmbagwi Herotna kwupmba la nɨmba kat ndi kat Jisas ta kavat ay wandi. Wandi, ndɨnai waa nyaangɨk kat kavle yigaandɨ walaa ndɨ kat yindi. ");
INSERT INTO ian_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yalaa Jisas kat wandi. Sɨmogwi liga nyan, mɨn woseka walapman vapmba yetɨlɨgamɨn. Mɨn mandɨp vapmba ana yilɨgamɨn waa wandi. Aywa ndinyangu kat kɨta vapmba yilɨgamɨn. Ndinyangu yetɨlɨga vapmba ana yetɨlɨgamɨn. Godna vak mɨna sɨmogwiga walɨgamɨn. Njambwi nyan, king Sisa kat takis sanya yaagineya vat kwowa? Yaagigiyanɨn? E? Ana yaagigiyanɨn? waa Jisas kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jisas ndi kat mandɨp mandɨp vak kat vɨlaa ndi kat wandɨ. Wun kat manda kat wupma yilɨgangwuk. Sanya wun kat agiya vɨgiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sanya kɨta kiyandi maa ndi kat wandɨ. Kandana mɨndama kandana sɨ kan waa wandɨ Jisas. Ndɨ kat wandi. King Sisana mɨndama ndɨna so sanyamba kwaa wandi. ");
INSERT INTO ian_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jisas ndi kat wandɨ. King Sisana nda ndɨ kat kwigiyangwuk. Godna nda ndɨ kat kwigiyangwuk waa wandɨ. Wandɨ, wanda nyaangɨt wutaa ngɨga ndandi. ");
INSERT INTO ian_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi walɨnja nɨmba kiyaa nyan ngɨni ana laakiyandɨ wala nɨmba ndi. Jisas kat yalaa wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sɨmogwi lɨga nyan, tak Moses pɨlɨwutndɨ. Nyamwun taagwa klalaa nyan njantapman kiyandɨ, swambu klaigandɨ. Klalaa nyan njangiyandɨ waa pɨlɨwutndɨ Moses waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yakwa ndu sɨla vɨli tɨndi waa wandi. Nyamwun nyan taagwa klandɨ. Kiyandɨ maa nyan kwutapman kwo lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndɨna swambu nyan nyamwuna taagwa klandɨ. Klalaa kiyandɨ maa nyan kwutapman kwo lɨlɨ. Ndɨna swambu ngivat sɨgɨt. ");
INSERT INTO ian_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nat swambu aywaa ngivat sɨgɨt kiyandi maa taagwa nyan kwutapman kwo lɨlɨ. Ngɨni taagwa kiyalɨ ");
INSERT INTO ian_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ngɨni kiyaa nɨmba laatnjeyan at taagwa kana taagwat tɨgiyalɨ waa wandi. Wundi sɨla vɨli nyangua kɨta lagwamba klandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas ndi kat wandɨ. Ngwuk apma vak ana yelavɨtɨgangwuk. God waa nyaangɨt kat ana apma vat yelavɨtɨgangwuk. Ndɨna kwondu kat ana apma vat yelavɨtɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngɨni kiyaa nɨmba laatnjeyan ndu ana taagwa klaigandi. Ensel yetɨga vak vla yetɨkiyandi. ");
INSERT INTO ian_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kiyaa nɨmba laakiyaa vak kat Moses tamba pɨlɨwutnda nyaangɨt ana vɨngwuk? Moses kaawa ya vla vɨtɨndɨ, vɨndɨ. Vɨlɨndɨ maa God ndɨ kat wandɨ. Wun Ebrahamna njambwi, Aisakna njambwi, Jekopna njambwi nyan wun waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God kiyaa nɨmbana njambwi nyan ana ndɨ. Kwo lɨga nɨmbana njambwi nyana God. Ngwuk wan hyaangɨk kat kavle maawut yelavɨka lɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nyaangɨt pɨlɨwutɨga kɨta nyan yalaa ndina kwundimba kao lɨnja vak kat wutaa Jisas apma vat wanda vak kat wutaa Jisas kat wagalandɨ. God kwiya njambwi vla lɨga nyaangɨt anda nyaangɨt njambwi lɨga waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas awat wandɨ. Njambwi kɨngiyan. Isrel walɨnja nɨmba awuk ngwula. God nɨna njambwi nyana. Nat nyan ana lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ngwula njambwi nyan kat God kat maawupmba yelavɨka solat asɨ. Ndɨ kat maawupmba nolin ngwandɨ. Ndɨ kat mbangɨmba nolin ngwandɨ. Ndɨ kat mbangɨ kwondumba solat asɨ waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kwupmba lɨga God waa nyaangɨt kɨngiyan. Avla nolin ngwandɨngwa vapmba nat nyan kai nolin ngwandɨgiyangwuk. Nat nyaangɨt njambwi kai kɨmbɨk kiyaambɨt waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nyaangɨt pɨlɨwutɨga nyan Jisas kat wandɨ. Apma vat wamɨn sɨmogwi lɨga nyan waa wandɨ. God kɨta lɨga vak kat ana woseka wamɨn. Ndɨha njambwi ana lɨgandɨ. Kapma lɨgandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","God kat maawupmba yelavɨka solat sɨnja vak, maawupmba nolin ngwandɨnja vak, mbangɨ kwondumba solat sɨnja vak, avla nolin ngwandɨga vapmba nat nyan kat nolin ngwandɨnja vak, aywaa apma nglei vatna. God kat kwunapmak yamba tuga kelonja vatnagwi God kat kwunapmak vatnyaga kwinja vak kat wan apma nglei vat kwulataa lɨgandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Apma vat wanda vak Jisas wutaa wandɨ. Mɨnai waa vat God yelavɨtna vatnonala kɨta vak vla lɨgandɨ waa wandɨ. Wandɨ, nat nɨmba Jisas kat wagalavak kak kai wandi. ");
INSERT INTO ian_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas Godna ngaymba lɨga sɨmogwiga wandɨ. Nyaangɨt pɨlɨwutɨga nat nɨmba wupma walɨgandi. Kraist Devjtna mat nyana waa walɨgandi. Manda kat wupma walɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Godna waagan Devitna maawut ngwandɨndɨ maa wupma pɨlɨwutndɨ. Njambwi nyan God wuna njambwi nyan Kraist kat wandɨ. Wuna yaagindan naangamba ndaalɨ. Mɨn kat kao lɨga nɨmba kat sɨwun maa ngɨni mɨn kat ana kao yigiyandi waa wandɨ God waa pɨlɨwutndɨ Devit. ");
INSERT INTO ian_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit Kraist kat njambwi nyan walɨndɨ. Manda kat tɨga Kraist Devitna mat nyanat tɨgɨyandɨ waa walɨgandi. Kraist Devitna njambwi nyana waa wandɨ Jisas. Wan nɨma Sakwat nɨmba ndɨnai waa nyaangɨt wutaa nolin ngwandɨndi. ");
INSERT INTO ian_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas sɨmogwiga wandɨ. Nyaangɨt pɨlɨwutɨga nɨmbana kavle vak kat yigumba avɨ ngwula. Lɨvla mbundɨ waavwimba kwusolaa yetɨvat walɨgandi. Wenga klalɨnja kavamba kwo nɨmba ndi kat apma vat wanjangat wupmat walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nyaangɨt ngambulɨnja ngay wuleilaa njambwi nyana tɨgɨtmba ndalɨvat walɨgandi. Nɨma kɨgɨnda kwutnja kavamba ngivat sɨgɨt walɨgandi. ");
INSERT INTO ian_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","To lagwana kwanda kwanda nda sɨkwuka klalɨgandi. God kat sɨvla nyaangɨt maawut sɨtapman kapmba kwo walɨgandi. Nɨma nɨma vat Godnanamba klaigandi. ");
INSERT INTO ian_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Godna ngaymba lɨga sanya yaagilɨnja kavana nat naangamba Jisas ndaalɨndɨ. Wan nɨma sakwat nɨmba sanya yaagilɨnja vak kat ndaalɨga vɨndɨ. Nat nɨma sakwat kwanda kwanda ndo lɨga nɨmba sanya nɨma sakwat yaagindi. ");
INSERT INTO ian_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sanya lapman to lagwa yalaa mat yelogwen mbangɨ sanya vɨlɨlɨk yaagilɨ. Wan sanya vɨlɨlɨk peni kɨta vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas ndina kwupmba la nɨmba kat yagwa walaa ndi kat wandɨ. Ngwuk kat wowun. Wan sanya lapman to lagwa nat nɨmba sanya kwinja vak kat kwulatɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nat nɨmba nɨma sakwat sanyo lɨga kuvuk klalaa kwindi. Lɨ sanya lapman tɨga lɨla sanya aywaa kwilɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas Godna ngay kwagalandɨ maa ndɨna kwupmba la kɨta nyan ndɨ kat wandɨ. Sɨmogwi lɨga nyan avɨmba mɨn. Apma kaambapmba kwutnja ngaya. Apma nglei ngaya waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas ndɨ kat wandɨ. Nɨma nɨma Godna ngay vɨmɨn? Ngɨnɨ wan ngay sulɨndi maa wan kaambak nɨglɨga wulɨga ndalaa kɨta kɨta yiga tɨgiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas Oliv walɨnja nduwiat yiga ndaa lɨndɨ. Wan nduwi nat naangamba Godna ngay lɨndɨ. Pita, Jems, Jon, Endru ndɨ kat kapma lɨga wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nɨn kat ambuk. Anda sɨva Godna ngay kat yinjeya vak wama vak tɨgiyandɨ waa wagalandi. Anda nda tata lɨga nda nɨn kat sɨmogwigiyaa was wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas ndi kat wandɨ. Yigumba awukmba ngwuk. kɨta nyan ngwula maawut mandɨp yilandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nɨma sakwat nɨmba wuna sɨ waga yaigandi. yalaa waigandi. Wun Kraist wun waa waigandi. Wan nɨmbana nyaangɨt wutaa nɨma sakwat nɨmbana maawut mandɨp vat yipiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kao veilaa yaa snjeya vak kat wutaa ke vaka. kao sɨgiyaa vat tiɨgiyandɨ. Wan vak ngɨlɨgiyaa njɨmbla wata. ");
INSERT INTO ian_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kɨta kwundi nɨmba nat kwundi nɨmba kat kao sɨgiyandi. Ngepma ngepma kat kao sɨkiyandi. kava kavamba yinaw kwukiyandɨ. Kɨgɨnda lapman njɨmbla tɨgiyandɨ. Wundi nama vat ngɨlɨgiyaa njɨmbla wata. Wan nɨma vak taagwa nyan kwupmak yipma sɨndɨ tɨga vak vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngwuk yigumba vɨga alɨmba ngwuk. Wan apma nyaangɨt ngambungweyangat ngwuk kak kwutaa kaligiyandi. nyaangɨt ngambulɨnja ngaymba ngwuk kak viyaigandi. njambwi nɨmbagwi nɨma nɨmba kat wun kat tɨga laataa kwukwa njɨvwa kat ndi kat mbukiyaangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tat wan apma nyaangɨt ngepma ngepma nɨmba kat mbukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wan apma nyaangɨt ngambungweyangat ngwuk kat kwutaa kalinjeyan awat wangweyan nyaangɨk kat nɨmamba ke yelavɨka. Godna waagan ngwuk kat waigaa nyaangɨt waigangwuk. Avla ana waigangwuk. Godna waagan ngwula maawut ngwandɨndɨ maa waigangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wan njɨmblamba nyamwun swambu kat vatnyavak kak kaligiyandɨ. Swambu nyamwun kat vatnyavak kak kaligiyandɨ. Nyan nyaek nyɨme kat ngivak kaligiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wuna mbaapmba lɨngwangat tɨga ngwuk kak aywaa kai waigandi. Wan kavle njɨmbla kat kwulatɨga nyan tɨndeyan kwo lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tamba God waa nyaangɨt walɨga nyan Danyel wupma pɨlɨwutndɨ. Kɨta nyan Godna ngaymba kavle nglei nda taagagiyandɨ. Taaganda nda wan ngay nglambi lɨgiyandɨ waa pɨlɨwutndɨ. Pɨlɨwuta nyaangɨt vɨgiyaa nɨmba vɨlaa maawupmba yelavɨk. Taaganda kavle nglei vat vɨlaa Judiamba lɨngweyan nduwiat kɨta yi yigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngay ngwaymba lɨga nyan kwanda kwanda nda klavak lungwamata yindeyan kavle yigiyandɨ. Kɨta yi yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ambugavamba lɨga nyan ngaymba lɨga taaganda waavwi kat lungwamata yindeyan kavle yigiyandɨ. Kɨta yi yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nyan tɨga taagwa, nyan kat mwunya kwilɨga taagwa wan njɨmbla yandɨ, ndi kat miwa ay. ");
INSERT INTO ian_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Meit mwuk kwutɨga njɨmblamba ngivat kavle vat ke kwiga God kat wagala. ");
INSERT INTO ian_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wan nɨma vatna sakwat tat wungivat ana lɨndɨ. Tat God kɨpma kwutna njɨmbla wungivat ana lɨndɨ. Ngɨni wungivat ana lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nɨma nyan wan nandinayana sakwat kalɨtapman yindeyan ndinyangu aywaa kiyaigandi. God ndɨna nɨmba kat tɨga nandinyana sakwat kalɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kɨta nyan yalaa ngwuk kat wandeyan avɨ Kraist kɨngiwyan ndɨ waa woseka wandwyan maawupmba ke yelavɨk. ");
INSERT INTO ian_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","23","Kraist lɨwun waa nɨma sakwat nɨmba waga God waa nyaangɨt wowun waa nɨma sakwat nɨmba waga yaigandi. Yalaa sɨmogwi lɨga nɨma njivwa kwukiyandi. Kwutndi, ngɨpaliga ndaigandi. kwutnjeya vak kat vɨlaa wan nɨmbana maawutmba yelavɨtnja vak kavle yigiyandɨ. Godna nɨmbana maawupmba yelavɨntnja vak kat kavle yivat waigandi. ndina maawupmba yelavɨtnja ngwula. Ngwuk kak tak tamba mbukwun. ");
INSERT INTO ian_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wan kavle njɨmblana nɨma vak ngɨlɨndɨ maa nya yiga kulun waigandɨ. Mbak ana sɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Singwuk pɨka ndalɨgiyandi. Nyɨnangwutmba lɨga nda kat yinaw kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kwutndɨ maa wun ndinyanguna nyan wun nyɨnangwupmba lɨga ngaga yaweya vak kat vɨgiyandi. Kwondumba yaigowun. Apma vat tɨga yaigowun. ");
INSERT INTO ian_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Godna nɨmba kat klalaga kiyavak kak ndɨna ensel kat ay waigandɨ. Woli agwiat ay Malingwutnat ay. kambangwatnat ay. Kɨpmagwi nyɨnangwutnat wupma ay waa waigandɨ God. ");
INSERT INTO ian_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Suwa sɨmogwi lɨga vak kat yelavɨk ngwula. Maambɨ wagwundeyan nyagangeat waa yelavɨtɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngwuk kat mbukwa nyaangɨt tɨga vak vɨlaa yelavɨkiyangwuk. Wan kavle vat tamba ngway tola lɨgandɨ waa yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ngwuk kat wowun. Mbambala tɨga nɨmba wunai waa vat vɨgiyangwuk. Tat ana kiyaigangwuk. Vɨlaa tɨga kiyaigangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nyɨnangwutnagwi kɨpmo ngɨni ngɨlɨgiyandɨ. Wunai waa nyaangɨt ana ngɨlɨgiyandɨ. Njɨmbala njɨmbla lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yaweya njɨmbla kɨta nyan ana vɨga lɨgandɨ. Ensel ana vɨga lɨgandi. Godna nyan wun ana vɨga lɨgowun. Wuna nyaek mɨna vɨga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yigumba avɨ ngwula. yaweya njɨmbla ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yaweya vat kɨta nyan sɨvla kavat yindeya vak vla lɨgandɨ. Wan nyan ndɨna njɨvwa kwuta nɨmba kat wandɨ. Ngay vɨga alɨ. Ngayna njɨvwa agwut wandɨ. Ndaamange kat vɨga la nyan kat yigumba avɨ wandɨ. Walaa kwagalalaa sɨvla kavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wungivat ngwutno avɨ ngwula. Ngayna njambwi nyan yaiga njɨmbla ana vɨga lɨgangwuk. Nglaambu yaigandɨ? Nɨndɨ yaigandɨ? ");
INSERT INTO ian_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngwuk sɨndu kwalɨga nɨmba vla lɨngwuk mala yandeyan ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wupma avɨmba ngwuk. Ngwuk kak wawa ntyaangɨt ngwuk kat mɨna ana walɨgowun. Ndinyangu kat aywaa walɨgowun. Avɨ ngwula wowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nandinya vɨlɨlɨk yindɨ mala Judana pesto lɨgiyandɨ. Wan pestomba tamba God ndi kat kwunatnda vak kat yelavɨka tugula nao kɨga lɨndi. God kat walɨga njambwi nɨmbagwi nyaangɨt pɨlɨwutɨga nɨmbo Jisas kat pagwuga kwutaa vatnyavak wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wan pesto la njɨmblamba kai wata wandi. Ndɨ kat kapmba kwutaa vatnyaneyan nɨma sakwat nɨmba vɨlaa kai walaa nɨma vat yigiyandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas Betanimba lɨga tat kawiya kɨla nyan Saimona ngaymba lɨga njambamba ndaa lɨndɨ, kɨta lagwa kaambapmba kwutnja aw kwutaa yalɨ. Wan awmba nat walɨnja apma njangu veilɨga ngwaat tɨndɨ. Wan ngwaat nɨma sanya kwiga klalɨnja ngwaakna. Aw tagulaa ngwaat ndɨna nambumba salɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nat nɨmba kat waleavat wandi. Manda kat ngwaat ndɨna nambumba kwo salɨtnyɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wan ngwaak wenga klagelɨ. Klalelaa sanya kwo lɨga nɨmba kat kwigelɨ. Wupma lɨ kat waa waleavat tɨndi. ");
INSERT INTO ian_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas ndi kat wandɨ. Lɨ kat ke yiga wungivat. Manda kat lɨ kat vat yigiyangwuk. Wun kat apma vat yiga kwunatɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kwo lɨga nɨmba njɨmbla njɨmbla ngwutnogwinala lɨgiyandi. Njɨmbla njɨmbla ndi kat apma vat yigiyangwuk. Wun njɨmbla njɨmbla ngwutnogwinala ana lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lɨla maawupmba yelavɨtaa apma vat yilɨ. Kiyawun maa wun kat waagumba taaganjeya vak kat yelavɨtaa salɨtɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngwuk kak wowun. Wan apma nyaangɨt mbutnjeya kava kavamba lɨlai kwutna vak kak lɨ kat yelavɨtaa mbukiyandi. ");
INSERT INTO ian_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskeriot wan tamba vɨli kiyeli vɨlɨlɨtna kɨta nyan God kat kwunatɨga njambwi nɨmba kat Jisas kat sɨnjangat kamwin kwivat yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wan njambwi nɨmba Judas waa nyaangɨt wutaa nolin ngwandɨlaa ndɨ kat sanya kwivat wandi. Judas Iskeriot Jisas kat vatnyanjeya vak kat ndɨna maawupmba kwaka yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tagula nao kɨlɨnja pestona kɨta wan nandinyamba God Juda kat tamba kwunatnda pestona sip sip vatnyandi. Vatnyandi maa Jisas ndɨna kwupmba la nɨmba kat wandɨ. Pestona nɨma kɨgɨnda andamba yiga kɨgiyanɨn yelavɨk ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ndɨna kwupmba la nɨmbana vɨlɨlɨk palɨ kat wandɨ. ngepma wulei mbɨla. Ngepma wuleilaa ava yambɨmba kɨta nyan ngu awmba naangalaa kiyalɨga nyan mbɨk kat sɨla klakɨvaa yigiyandɨ. Ndɨna kwupmba ay mbɨla. ");
INSERT INTO ian_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ngay wuleindɨ maa wan ngay kwutna nyan kat awa mbɨla. Sɨmogwi lɨga nyan wandɨ waa awa mbɨla. Wunai wuna kwupmba la nɨmbonala God Juda kat kwunatnda pestona kɨgɨnda kɨneya kava andamapmba lɨgandɨ waga awa mbɨla. ");
INSERT INTO ian_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nɨma tɨmbu vɨlɨnge awlak ngemba la kava mbɨk kat sɨmogwigiyandɨ. Wan kava kwo kava ana ndɨ. ngayna nda ngilɨga. Wan ngay nɨn kat tamba kwundatndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ndɨna kwupmba la mbɨk vɨlɨlɨk palɨ ngepma yimbɨk. Yilaa Jisas mbɨk kat waa nyaangɨtmba tɨndɨ, vɨmbɨk. Kɨgɨnda kwupmbɨk. ");
INSERT INTO ian_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ngan ndandɨ maa wan tamba vɨlɨi kiyeli vɨlɨlɨk nɨmbanala Jisas laataa yandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Njambamba ndaa lɨga kɨlɨndi maa Jisas wandɨ. Ngwuk kak wowun. Ngwula kɨta nyan wun kat sɨnjangat kamwin kwilɨga nyana. Wunagwinala kɨlɨga nyan kamwin kwilɨga nyana waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wutaa ngɨpaliga ndalaa yelavɨka lɨndi. Jisas kat kɨta nyan kɨta nyan wagalandi. Wun kat wamɨn? Waa kɨta kɨta wagalandi. ");
INSERT INTO ian_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas ndi kat wandɨ. Ngwutna nat nyan kɨgiyand. Kɨta nombe awmba kɨga lɨli. ");
INSERT INTO ian_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wun Godna vak sɨmogwi lɨga nyan wun. Wun kat tamba pɨlɨwuta nyaangɨtmba yigiyandi. Wun kat kamwin kwigiyaa nyan ndɨ kat miwa ay. Ndɨ kat nyɨme kwutapman yigelan apma vat tɨgendɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kɨlɨndi maa Jisas nao klandɨ. Klalaa God kat wagalalaa lɨmba ngɨlɨlaa kwiga wandɨ. Agla wuna sɨmna wɨmba kwiwa. ");
INSERT INTO ian_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ngu la andagava klalaa God kat wagalaa tulaa kɨta kɨta nyan kat kwindɨ, kɨndi. ");
INSERT INTO ian_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ndi kat wandɨ. Wan ngu wuna yelogwena. Paak vla lɨgandɨ. Nɨma sakwat nɨmba kat kwunapmak wuna yelogwen salɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngwuk kak wowun. Glepna ngu kɨpmamba lɨga ana nat njambɨk kɨgiyowun. God vɨga lɨga kavat wuleilaa kupi apma ngu kɨgiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","God kat mbangu kwundi walaa wan ngay kwagalalaa Oliv walɨnja nduwiat yindi. ");
INSERT INTO ian_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ndi kat wandɨ. Ngwuk aywaa wun kat kwagalagiyangwuk. Tamba la nɨmba pɨlɨwutndi. Sip sip vɨga lɨga nyan kat God vatnyandɨ mala sip sip kava kava vaka yigiyandi waa pɨlɨwutndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kiyalaa laataa tata Galili yigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ndɨ kat wandɨ. Nat nɨmba mɨn kat kwagalanjeyan wun ana kwagalagiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas ndɨ kat wandɨ. Mɨn kat wowun. Mbambala ngan wun kat njambɨ kuvuk kai waigamɨn. Kai wamɨn maa nyaaga njambɨ vɨli viyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita nɨma kwundimba wandɨ. Mɨn kat ana kai waigowun. Mɨnai kiyaa vapmba kiyaweyan kiyalapman nda? Waa wandɨ Pita. Aywaa ngivak wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Getsemani walɨnja kavat yindi maa Jisas ndɨna kwupmba la nɨmba kat wandɨ. Ngwuk wumba ndaa alɨ ngwula. Wun God kat yiga wagalagiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nat Nɨmba kat kwagalalaa Pita, Jems, Jon kat Jisas ndi kat kwutaa samat kalindɨ. Jisas nɨma vak kat yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ndi kat wandɨ. Wuna maawut nɨma vat yelavɨtɨgowun. Kiyalaa lsvla lɨgowun. Ngwuk alɨ ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jisas samat yiga kɨpmamba ndalaa God kat wagalandɨ. Wungivat vat wun kat yilandɨ waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ndina kwundimba aba waa nyaek kat wandɨ. Mɨn aywaa alɨpsɨga kwutɨgamɨn. Wungivat vak wun kat yilandɨ. Wupma mɨna maawutmba kwuka yetɨ. Wuna maawupmba ke kwuka yetɨga waa wandɨ Jisas God kat. ");
INSERT INTO ian_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wagalalaa yalaa kuvut nɨmba sɨndu kwalɨndi, vɨndɨ. Pita kat wandɨ. Saimon sɨndu kwamɨn? Laataa lɨga samat ana wun kat kawiga tɨgiyamɨn? Waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jisas ndi kat wandɨ. Ke sɨndu kwaga. God kat wagala ngwula. God kat wagalangweyan ngwutna maawut ana kavle yigiyandɨ. Ngwutna maawupmba ana sɨndu kwiganɨn waa yelavɨkngwuk. Ngwula mɨni vali yindɨ, sɨndu kwangwuk. Ngwula nɨni maawupmba yelavɨkngwa vapmba ana yindɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nat njambɨ yiga God kat wagalandɨ. Tat wanda wumba nyaangɨtmba wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nat njambɨ yalaa ndina mɨni sɨndu yilɨndɨ, sɨndu kwandi, vɨndɨ. Ndɨnai waa nyaangɨk kat wutaa ana kwundi wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Njambɨ kuvuk yilaa yalaa ndi kat wandɨ. Tamba sɨndu kwaangwuk? Ngiyambak. Wun kat kwupmak ya nɨmba tabma ngwaya yanja. Wun Godna vat sɨmogwi lɨga nyan wun. Wun kat kavle vat yetɨlɨga nɨmba wun kat kwupmak yaandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Laak ngwula. Yigat. Wun kat kamwin kwiya nyan ngwaymba lɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas walɨndɨ maa wan tamba vɨli kiyeli vɨlɨlɨk nɨmbana kɨta nyan Judas yalɨndɨ. God kat kwunatɨga njambwi nɨmbagwi nyaangɨt pɨlɨwutɨga nɨmbao Judana ngwatno nɨma sakwat nɨmba kat ay wandi maa yak kwutaa njay kwutaa Judasonala yalɨndi. ");
INSERT INTO ian_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kamwin kwiya nyan tat ndi kat sɨmogwivat yandɨ. Kɨpmwimba wusɨtweya nyan kwutaa agiya wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Jisas kat yalaa ndɨ kat njambwi nyan walaa kɨpmwimba wusɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wusɨtndɨ maa ndɨ kat kwutndi. ");
INSERT INTO ian_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jisasna ngwaymba la nyan yak kwutaa God kat kwunatɨga njambwi nyana njɨvwa kwutɨga nyana waan kalɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisas ndɨ kat wandɨ. Wun sɨkwutɨga nyan ana wun. Manda kat yak kwutaa njay kwutaa wun kat kwupmak yanguwak. ");
INSERT INTO ian_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nandinya nandinya ngwulanala Godna ngaymba lɨwun, ana kwukngwuk. Tamba pɨlɨwuta nyaangɨtmba yingwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wandɨ, ndɨna kwupmba la nɨmba ndɨ kat kwagalalaa vaaka yindi. ");
INSERT INTO ian_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwandɨ nyan kɨta Jisasna kwupmba yindɨ. Waavwi kɨta kwo kapmalaa yindɨ. Jisasna kwupmba yindɨ. Waavwi kɨta kwo kapmalaa yindɨ. Jisas kat kwuta nɨmba ndɨ kat kwupmat wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ndɨna waavwi mɨna klandi. Kwo vaaka sɨp mɨna pɨlɨga yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","God kat kwunatɨga njambwi nyana ngayat Jisas kat kalindi. God kat kwunatɨga njambwi nɨmbagwi Judana ngwatno nyaangɨt pɨlɨwutɨga nɨmbo yisolaa lɨndi wan ngaymba. ");
INSERT INTO ian_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita sɨvlamba lɨga kwupmba yandɨ. Pita God kat walɨga njambwi nyana ngekavamba ndalɨndɨ. njambwi nyana kao lɨlɨga nɨmbonala ndalɨndɨ. Yipma yilɨndɨ, ya waymba yiga ndalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","God kat walɨga njambwi nɨmbagwi nat yisolaa la njambwi nɨmbo Jisas kat njɨkiya nɨmbakat kwaka yindi. ");
INSERT INTO ian_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɨma sakwat nɨmba ndɨ kat njɨka wandi. Kɨta vapmba ana ngambundi. Mandɨp mandɨp nyaangɨt woseka ngambundi. ");
INSERT INTO ian_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nat nɨmba laataa njɨka wupma wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Godna ngay ndinyangu kwutaa ngay sulɨgiyowun. Nandinya kuvut tɨga mandɨk ngay kwukiyowun. Ndinyangu kwutnjeya ngay vla ana kwukiyowun Jisas wandɨ wutnɨn njɨka walɨndi. ");
INSERT INTO ian_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kɨta nyaangɨtmba ana ngambundi. mandɨp mandɨp ngambundi. ");
INSERT INTO ian_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","God kat kwunatɨga njambwi nyan nɨndɨmba laataa Jisas kat wagalandɨ. Awat waigamɨn? Mɨn kat wanjangat angamak awat waigamɨn waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisas awat ana wandɨ. Nat njambɨ God kat kwunatɨga njambwi nyan ndɨ kat wagalandɨ. Mɨn Kraist mɨn? Mɨn Godna nyan mɨn? Waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wandɨ, Jisas awa wandɨ. Ngɨni wun Godna vak sɨmogwi lɨga nyan wun Godna yaagindan naangamba ndalɨgiyowun, vɨgiyangwuk. nyɨnangwutmba lɨga yaigowun vɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wandɨ maa god kat kwunatɨga njambwi nyan kimbuk yiga avla waavwi ngɨlɨtaa wandɨ. Ndɨ kat njɨka waiga nat nɨmba kat yagwa ana waiganɨn. Ndɨna ngambu sɨmbla nyaangɨtmba vatnyagiyanɨn. ");
INSERT INTO ian_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ndɨnai God kat kavle waa nyaangɨt tamba wukngwuk waa woseka wandɨ. Ngwuk angamak yelavɨkiyangwuk waa wandɨ. Wandɨ, wandi. Ndɨ kiyaigandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nat nɨmba Jisas kat sɨpmiya sandi. Nat nɨmba ndɨna mɨni waavwimba ngilaa viyaga wandi. Kandana viyaa. Viyaa nyana sɨ ambuk wandi. Kao lɨlɨga nɨmba ndɨ kat viyalaa kwutndi. ");
INSERT INTO ian_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ngekavamba lɨga God kat walɨga njambwi nyana njɨvwa kwutɨga tagwanyan ndɨ kat walɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita ya ngwaymba lɨga mbangɨ kulavi lɨndɨ maa ndɨ kat vɨlaa walɨlɨ. Mɨn Nasaretmba lɨga yaa nyan mɨn. Tamba Jisasonala lɨmɨn waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita kai wandɨ. Nyɨnai waa nyaangɨk kat ana wuka yelavɨtɨgowun walaa laataa ngegava tɨvwina suwi yambɨ yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wat tagwanyan vɨlaa wumba lɨga nɨmba kat walɨ. Jisasna kwupmba la nyan angwiyan yiga waa walɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nat njambɨ Pita kai wandɨ. Tɨga lɨga wumba lɨga nyan Pita kat wandɨ. Mɨn ndɨna kwupmba la nyan mɨn. Mɨn Galilimba la nyan mɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita nyaek sɨge yiga wandɨ. Wama nyaangɨt ana vɨga lɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wandɨ, ava nyaaga viyandɨ, ngɨni wumba nyaaga viyandɨ. Pita Jisas ndɨ kat waa nyaangɨk kat yelavɨtndɨ. Wun kat njambɨ kuvuk kai waigamɨn. Wamɨn, nyaaga njambɨ vɨli viyaigandɨ wandangat yelavɨtaa nglandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ngambi gleimba God kat kwunatɨga njambwi nɨmbagwi Judana ngwatno nyaangɨt pɨlɨwutɨga nɨmbo yisolaa ngambundi. Jisas kat man taamba sagilaa Pailat walɨnja njambwi nyanat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Jisas kat wagalandɨ. Mɨn Judana king mɨn? Waa wagalandɨ. Wagalandɨ mala Jisas wandɨ. Ngiyambak wamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","God kat kwunatɨga njambwi nɨmba Jiasa kat nɨma vat njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat nat njambɨ Jisas kat wagalandɨ. Awat waigamɨn? Nɨma sakwat vak wanja vak kat awut waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisas awat ana wandɨ. Walapman tɨndangat Pailatna maawut yigumba ana yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailat wan pestona njɨmblamba kalabusmba lɨga kɨta nyan kat kwo ay walɨndɨ. Juda wan nyan kat sɨmogwindi maa Pailat kwo ay walɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kalabusmba la Gavman kat kao la nɨmbana kɨta nyan tɨndɨ. ndina sɨ Barabas. kao la njɨmblamba kɨta nyan kat vatnyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wan nɨma sakwat nɨmba Pailat kat wandi. Mɨnai kwo ay waa vapmba agwut waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat ndi kat wandɨ. Judana king Jisas kat kwo ay walu? wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","God kat kwunatɨga njambwi nɨmba Jisas kat waliyavat kiyanja vak kat Pailat maawupmba yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","God kat kwunatɨga njambwi nɨmba wan nɨma sakwat nɨmba kat wandi. Pailat kat awa ngwula wandi. Barabas kat kwo ay waa awa ngwula waa wandi. Wupmba Barabas kat kwo ay waa awa Pailat kat wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat ndi kat nat njambɨ wandɨ. Judana king walɨnja nyan kat angamak yigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ndi kɨselaga wandi. Vɨtagwe mimba kaala waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat ndi kat wandɨ. Manda vatna kavle vat yinda waa wandɨ. Wandɨ, nɨma vat kɨselandi. Vɨtagwe mimba kaala waa kɨselandi. ");
INSERT INTO ian_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat wan nɨma sakwat nɨmbana maawupmba yivat wandɨ. Wungi kat tɨga Barabas kat kwo ay wandɨ. jisas kat aviya walaa vɨtagwe mimba kaala wandɨ maa ndɨ kat kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kao yilɨga nɨmba aywaa yalaa Pailatna ngay Pritoriam walɨnja ngaymba lɨga Jisas kat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yelogwen mbangɨ waavwi ndɨ kat kwusondi. Mangɨnɨmbi yamboy klalaa ngilaa ndɨna nambumba kɨlɨsandandi. ");
INSERT INTO ian_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ndɨ kat kwuselɨndi. Mɨn Judana king mɨn waa kwuselɨndi. ");
INSERT INTO ian_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ndɨna nambu maambɨmba viyalɨndi ndɨ kat sɨpmiya salɨndi kwusɨlɨga kwaali mamba sɨndi. ");
INSERT INTO ian_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kwusɨlaa yelogwen mbangɨ waavwi klalaa ndɨ kat ndɨna waavwi kwusolaa vitagwe mbaomba kaalavat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Samat yiga kɨta nyan kat vɨndi. Ndɨna sɨ Saimon. Wan nyan saimon ngepma wuleivat yandɨ. Ndɨ kat kwutaa wandi. Kan vɨtagwe mbao walalaa kali waa wandi. Wan nyan saimona angwa ngepma Sairiniwalɨnja ngepma. Ndɨna mbɨt nyana sɨ Aleksanda Rufus. ");
INSERT INTO ian_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Golgota walɨnja nduwi andɨgava nambu vla la nduwi Jisas kat kiyandi. ");
INSERT INTO ian_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nɨma nguo mɨl walɨnja sukwino kɨta salɨndi. Jisas kat kwivat wandi. Ndɨ kɨvak kat kai wandɨ. Wan ngu kangɨt yilɨga vak kat kwulatɨga ngua. ");
INSERT INTO ian_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wungi kavamba ndɨ kat kaalandi. ndɨna waavwi klavak kak satumba kaselɨndi. ");
INSERT INTO ian_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","9 klok ngambi ndɨ kat kaalandi. ");
INSERT INTO ian_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jisas kat kavle vat wanja nyaangɨt lavungamba pɨlɨwutndi. Judana king waa pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Jisasonala sɨkwutɨga vɨlɨlɨk palɨ kaalandi. Nat nyan kat yaagindan naangamba nat nyan nat ambugendan naangamba kaalandi. ");
INSERT INTO ian_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vɨgɨvaa yilɨga nɨmba ndɨ kat kwusɨlɨndi. Ndaawamba viyaga wandi. Tat Godna ngay sulɨvat waa wamɨn. Nat ngay nandinya kuvutmba kwukiyowun waa wamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ngaga yaga avla mɨna mbangɨ kwunak waa kwusɨlɨgba wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","God kat walɨga nɨmbagwi nyaangɨt pɨlɨwutɨga nɨmbo ndino Jisas kat kwusɨlɨndi. Nat nɨmba kat kwunatndɨ. Avla ana alɨpsɨga kwunakiyandɨ waa kwusɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndɨ Kraist tɨndeyan ndɨ Isrelna njambwi nyan tɨndeyan vɨtndeyan vɨtagwe mbaomba ngaga yandeyan vɨlaa ndɨ kat nɨna mbangɨ wiyo waavi taagandɨ maa ndɨna nyaangɨt wukiyanɨn waa kwusɨlɨndi. Ndɨnanala vɨtagwe mbaomba ta mbɨt nyan mbɨtno kwusɨlɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nɨndɨ nandinya nya kulun wandɨ. Tɨga vasagla ta lɨndi, kulun wandɨ. 12 klok lulun wandɨ, yiga 3 klok nglaambu kembandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 klok nglaambu Jisas nɨma kwundimba kɨselaga wandɨ. Ndina kwundimba Eloi Eloi lama sabaktani wandɨ. God wuna nyaek manda kat wun kat kwagalamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wumba lɨga nɨmba yigumba ana wutaa wandi. Awut Ilaija kat walɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kɨta nyan pɨlɨlaa namɨnɨngɨmba nyingi lɨga nɨma ngu sɨvugulaa njimbwi mbaomba namɨnɨgɨ taagalaa Jisas kat kwusolaa Jisasna tɨpmwimba taagalaa agɨ wandɨ. Wata kwo lɨgiyanɨn. ilaija ndɨ kat kwunapmak yandeyan vɨgiyanɨn waa kasega wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisas nɨma kwundimba kɨselaa waga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Godna ngaymba nɨndɨ ngemba la nɨma waavwi ngɨlɨtndɨ. Angwapmba lɨga ngɨlɨka ndaindɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisas kiyandɨ maa Jisasna mɨndama sambɨmba la njambwi soldia wandɨ. Ndɨ Godna nyan waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sɨvlamba lɨga nat taagwa vɨga lɨndi. Magdala walɨnja ngepmamba la taagwa lɨla sɨ maria nat Jemsagwi Josisna nyɨmeak. Salomi apma vɨga lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tat Jisas Galilimba lɨndɨ maa wat taagwa ndɨna kwupmba yalaa ndɨna kɨgɨnda kwuti Jisasonala nɨma sakwat taagwa yalaa vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nya ndaindɨ maa njɨvwa lapman nandinya kat kwanda kwanda kwutnjɨgwilɨnjan nandinya tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimitiamba la nyan Josep yandɨ. Ndɨ yisolaa nyaangɨt ngambula nɨmbana kɨta nyana. God vɨga lɨga vak kat vɨga la kɨta nyana. Pailat kat yalaa Jisasna sɨm klavat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat wandɨ. Tamba kiyandɨ? E? Ana kiyandɨ? Walaa njambwi soldia kat yagwa walaa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Njambwi soldia waa nyaangɨt wutaa pailat Josep kat sɨm agla wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jisasna sɨm kanda kalilaa waavwimba mbatndi. Kambapmba waangu vala taagandi. Taagalaa kambak mbandɨgaa ndɨna waangu tɨvɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdalamba lak Mariagwi Josisna nyɨmeo nat maria taaganja kava yigumba vɨga lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jɨvwa lapman nandinya yindɨ maa Magdalamba lak Maria Jemsna nyɨme nat Maria, Salomi, apma njangu veilɨga ngwaat Jisasna sɨmba salɨpmak kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kɨta wan nandinya ngambi glei laataa waangu la kavat yindi. ");
INSERT INTO ian_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Avla ngambundi. Nɨn kat kandana kambat lavwigiyalaa waa ngambundi. ");
INSERT INTO ian_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yilaa kambak lavwilaa lɨndɨ, vɨndi. Wan kambak nɨma kambakna. ");
INSERT INTO ian_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Waangu wuleilaa kɨta nyan sawun mbangɨ waavwi kwusolaa la nyan ndina yaagindan naangamba ndaalɨndɨ, vɨlaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ndi kat wandɨ. ke vak. kwaka yangwan Nasaretmba la nyan ana lɨgandɨ. Tambu laatndɨ. Tat ndɨ kat taaganja kava avɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndɨna kwupmba la nɨmbagwi Pita kat yiga ambuk. Jisas laataa Galili yigiyandɨ waa ambuk waa wandɨ. Galilimba ndɨ kat vɨgiyangwuk waa ambuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Waangumba lɨga vaaka kɨta yi yindi. Ngɨpaliga ndalaa avamban plaga yindi. Vaaka lɨga nat nɨmba kat ana mbutndi. ");
INSERT INTO ian_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kɨta wan nandinyamba Jisas laatndɨ maa Magdalamba lak Maria ndɨ kat tatak vɨlɨ. Tat Jisas lɨ kat tavila waagan sɨla vɨli savɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisasonala ta nɨmba nolin tapman nglalɨndi maa Maria yaa ndi kat mubtuɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria ndi kat mbutɨ. Jisas kiyalaa tamba laatndɨ waa mbutɨ. Wala vak wutaa ndina mbangɨ wup yindɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jisas mandɨt nyan vla lɨndɨ, vɨlɨlɨk palɨ ngepma lapman kavamba yetɨga lɨga Jisas kat vɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vɨlaa nat nɨmba kat yiga mbupmbɨk. Wamba nyaangɨt wutaa ndina mbangɨ wup yigandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngɨni wan tamba vɨli kiyeli kɨta nɨmba njambamba ndaalɨga nao kɨlɨndi, Jisas ndi kat yandɨ. Yalaa ndi kat mbangɨ kɨlɨpangɨ yindɨ lɨnjangat nɨma kwundimba wandɨ. Tat va taagwa yaa mbuta nyaangɨt ngwula mbangɨ ana wiyo waavi taagandɨ. Wungi kat tɨga Jisas yiga ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndi kat wupma wandɨ. Kava kavamba wan apma nyaangɨt aywaa ndi kat yiga ambuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kɨta nyan wan apma nyaangɨt maawupmba kwutaa lɨndeyan ndɨ kat yagunjeyan ndɨ kat God kwunakiyandɨ. Maawupma kwupmak kak kai wagiyaa nɨmba kat God nɨma vat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wan apma nyaangɨt maawupmba kwukiyaa nɨmba ndinogwionala sɨmogwilɨga nda lɨgiyandɨ. Wuna sɨ waga waagan kat tula waa wanjeyan kwagalagiyandi. Mandɨp mandɨp kwundimba waigandi. ");
INSERT INTO ian_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kamboy kwutaa katsonjeyan ana valɨgiyandɨ. Ndaa kwutɨga ngu kɨnjeyan ana kiyaigandi. Yelogwen ta nɨmba kat taamba taaganjeyan kwo lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Njambwi nyan Jisas ndi kat walaa nyɨnangwut wokelaa Godna yaagindan naangamba ndalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndi kava kavamba yiga mbutndi. Nɨma nyan ndina lak kwandɨ. Sɨmogwi lɨga nɨma njɨvwa kwutndi. Va nɨmba vɨlaa yelavɨtndi. Wanja nyaangɨt woseka ana walɨkandi waa yelavɨtndi. Ngiyambak. ");
INSERT INTO ian_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Njambwi nyan Tiofilas mɨn kat nyaangɨt pɨlɨwupmat yigowun. God nɨnogwinala kwuta nɨma njɨvwa kat nɨma sakwat nɨmba pɨlɨwupmat tɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","God kwuta njɨvwa va nɨmba wan njɨvwa vɨlaa nat nɨmba kat mbutndi maa pɨlɨwutndi. God kwuta njɨvwa aywaa vɨlaa mbutndi. Va nɨmba Godna njɨvwa kwuta nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","God kwutɨnda njɨvwa kat aywaa wagalalaa wutaa mɨn kat pɨlɨwupmat wowun. God kwuta njɨvwa kat wagalalaa wutaa apma vat pɨlɨwukiyowun. Sɨmblan ana pɨlɨwukiyowun. ");
INSERT INTO ian_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pɨlɨwukweya nyaangɨt vɨlaa tak wukwa nyaangɨt woseka ana wandi waa yelavɨka lɨgiyamɨn. Wupma yelavɨka lɨmangat pɨlɨwukowun. ");
INSERT INTO ian_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judiana king tɨnda njɨmbla kan pɨlɨwukweya vak tɨndɨ. Kɨta nyan tɨndɨ ndɨna sɨ Sekaraia. Ndɨ God kat kwunatɨga nɨmbana kɨta nyana. Ndi God kat kwunatɨga nɨmba mbaapma mbaapmamba lɨndi. Wan nyan Abaisana mbaapma nyana. Ndɨna taagwana sɨ Ilisabet. Lɨla yelangɨ ndɨna yelangɨ kɨta. Eron walɨnja yelangɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mbɨk God waa vak apma vapmba yetɨmbɨk. God waa nyaangɨt wuka ndɨnai taaga njambiyamba yetɨmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mbɨt nyan kai. Ilisabet kwandɨ lagwa tɨga nyan ana kwutɨ. Mbambala avɨt ndu avɨt taagwa mbɨt. ");
INSERT INTO ian_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekaraina mbaapma nɨmba njɨvwa kwupmat yandi. God kat kwunapmat yandi. ");
INSERT INTO ian_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ndina vak kɨngiyan. Mandɨt mandɨt njɨvwa kansaga kwutndi. Apma njangu veilɨga ya salɨlɨnda njɨvwa Sekaraia klandɨ. klalaa ya salɨvat Godna ngay wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ya salɨvat wuleindɨ mala nat nɨma sakwat nɨmba alagumba lɨga god kat wagala lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekaraia godna ngay weleilaa apma njangu veilɨga ya salɨndeya kugɨmbɨ waymba njambwi nyana ensel vɨndɨ. Kugɨmbɨ yaagindan naangɨmba lɨndɨ, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ensel kat vɨlaa maawut viyalɨndɨ, vaaka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ensel ndɨ kat wandɨ. Sekaraia ke vaaka. Wagalalɨma nyaangɨt God tamba wutndɨ. samat tɨga mɨna taagwa Ilisabet nyan kwukiyalɨ. Kwutɨ maa ndɨna sɨ Jon waa waigamɨn. ");
INSERT INTO ian_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kwutɨ maa solat sɨgiyamɨn. Nat nɨma sakwat nɨmba ndino solat sɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","God wan nyan kat bɨlaa ndɨ apma nyana njambwi nyana waa waigandɨ. Wan nyan ndɨ nɨma ngu ana kɨgiyandɨ. Wan nyan ndɨ nyɨmena yaapmba lɨndɨ, Godna waagan ndɨna mbangɨ tavɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wan nyan ndɨ Juda nɨma sakwat ndi kat mbutndɨ maa ndina njambwi nyan God waa nyaangɨt wuka yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tamba la nyan Iliaja nɨma kwondumba Godna njɨvwa kwutnda vla wan nyan kwukiyandɨ. Ndɨnai waigaa nyaangɨt wutaa God kat kai walɨga nɨmba God waa nyaangɨt mbukiya nyan kat kawiga tɨgiyandi waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ensel wandɨ maa sekaraia ndɨ kat wagalandɨ. Woseka wamɨn? E? Woseka ana wamɨn? angamak vɨgiywowun. Wuna taagwa avɨt taagwat. Wuno avɨt ndu wun. Anda vapmba nyan kwukiyalɨ waa wandɨ maa ensel wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wun gebriel wun. Wun Godna apma njɨvwa kwutɨga nyan wun. God wandɨ maa mbukwa apma nyaangɨt yalaa mbukwun. ");
INSERT INTO ian_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tɨga lɨga mɨna kwundi kwulamakiyandɨ. Mɨna taagwa nyan kwutɨ maa mɨna kwundi apma vat tɨndɨ, kwundi ngambugiyamɨn. Wawa nyaangɨt wutaa kavle maawut yelavɨtaa woseka wandɨ? E? Woseka ana wandɨ? Waa wamangat mɨna kwundi kwulamakiyandɨ. Wawa nyaangɨt kak kiyandɨ, vɨgiyamɨn waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","alagumba la nɨmba Sekaraia kat kwo kawiga lɨndi. Godna ngay wuleilaa sɨvla mbundɨ lɨnda waa nɨma vak yelavɨka lɨga kawiga lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakaraia wogwelaa ndi kat nyaangɨt ana mbutndɨ. Ndi kat taamba mɨna yindɨ. Nyaangɨt mbutapman ndi kat taamba mɨna yinda vak vɨlaa godna ngaymba lɨga sɨmak vla vɨndɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","God kat kwunatɨnda njɨvwa ngɨlɨndɨ mala Sakaraia ndɨna ngayat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gɨga lɨga ndɨna taagwa yapmba nyan tɨndɨ. Mbat tambanat ngaymba mɨna tɨlɨ. kava kava ana wogwelaa yilɨ. Lɨ walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Njambwi nyan God wun kat apma vat yindɨ. Tak nyan kwutapman tuwa njɨmbla nat nɨmba wun kat vɨlaa kavle taagwa lɨ waa yelavɨtndi. Mbambala wupma kai waa walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabetna yaapmba nyan mbak sɨla kɨta tɨndɨ maa God ndɨna ensel Gebriel kat wandɨ maa Galili walɨnja nɨma kɨpmana ngepma Nasaret walɨnja ngepmat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wan ngepmamba taagwa nyan kɨta lɨlɨ. Lɨla sɨ maria. lɨ kat wandi ndu klavak kat. wan nduna sɨ Josep. Ndɨ tamba la nyan Devitna yelangɨ nyan Josep. ");
INSERT INTO ian_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ensel lɨ kat vɨlaa wandɨ. Apma nandinya. God nyɨn kat apma vak yigiyandɨ. Nyɨn kat apma vat yindeya vat nat taagwa kat wupma ana yigiyandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria ndɨ kat vɨlaa nɨma vak yelavɨtɨ. Manda kat wandɨ. Ana yelavɨkowun waa nɨma vak yelavɨtɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ensel lɨ kat wandɨ. Nɨmamba ke yelavɨka. Ke vaaka. God nyɨn kat kavle vat ana wandɨ. Nyɨn kat apma vat yivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Samat tɨga nyɨna yaapmba nyan tɨgiyandɨ. Wan nyan kwutaa ndɨna sɨ Jisas waa waiganyɨn. ");
INSERT INTO ian_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wan nyan njambwi nyanat tɨgiyandɨ. Ndɨkat vɨlaa ndɨ Godna nyana waa waigandi nat nɨmba. God wandɨ maa ndɨna yelangɨna najmbwi nyan Devit tamba vɨga lɨnda vla ndɨno vɨga lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Njɨmbla njɨmbla Jekopna yelangɨ nɨmba kat vɨga lɨgiyandi. Vɨga lɨndeya vak ana ngɨlɨgiyandɨ waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ensel wandɨ maa Maria ndɨ kat wagalalɨ. Wama nyaangɨt anda vapmba tɨgiyandɨ. Wun lan kai waa walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Walɨ maa ensel wandɨ. Godna waagan nyɨn kat yaa tavɨgiyandɨ. Godna kwondu nyɨn kat yaigandɨ. Wan nyan ndu kɨta nyɨna yaapmba ana taagagiyandɨ. God ndɨnayɨ taagagiya. Nyi kat tɨga wan nyan Godna nyana waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Awut nyɨla. Nyɨna yakwa lagwa Ilisabet nyan tɨgalɨ. Lɨ tamba avɨt taagwa lɨ. Tak nyan ana akwutɨ. Mbak sɨla kɨta tɨgalɨ nyan. ");
INSERT INTO ian_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God kɨta nda tɨgiyandɨ waa wandeyan tɨgiyandɨ. Ndɨ kwondu mbundɨ nyana waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wandɨ maa Maria walɨ. Wovuna. Wama nyaangɨt tɨgiyandɨ. Wun ana kai waigowun. Godna njɨvwa kwukiyowun waa walɨ maa ensel lɨ kat kwagalalaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tɨga lɨga Maria laataa nduwi la kavat yilɨ. Juda walɨnja nɨma kɨpmana nat ngepmat laataa yilɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngepma yilaa Sekaraiana ngay wuleilaa Ilisabet kat apma nandinya walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Apma nandinya waga walɨ, Ilisabet wutɨ, lɨla yaapmba ta nyan yuvut yindɨ. yuvut yindɨ mala Ilisabetna mbangɨ Godna waagan tavindɨ mala walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nɨma kwundimba walega walɨ. Apma vat tɨga taagwa nyɨn. God nyɨn kat apma vat yinda vak vla nat taagwa kat ana yindɨ. Nyɨna yaapmba lɨga nyan ama vat tɨga nyana. ");
INSERT INTO ian_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wuna njambwi nyana nyɨme nyɨn. Wuna ngay wuleinyan apma vakna. Nyɨn kat vɨwan apma vakna God kwiya apma vakna. ");
INSERT INTO ian_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Awut nyɨla. Wun kat apma nandinya wanyɨn maa wuna yaapmba tɨga nyan solat sɨga yuvut yindɨ. Wukwun maa yuvut yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God nyɨn kat waa nyaangɨt wutaa woseka wandɨ waa ana wanyɨn. God waa nyaangɨt tɨgiyandɨ waa wanyɨn. Wanya vat apma vatna waa walɨ Ilisabet. ");
INSERT INTO ian_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maia lungwamataa walɨ. God njambwi nyana waa wuna maawupmba yelavɨka lɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God wun kat kwunatɨgandɨ. Wun kat kwunatɨnda vak kat yelavɨtaa solat sɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wun Godna njɨvwa kwutɨgat taagwa wun. Wun kwo taagwa wun. God wun kat kwo awagapma apma vat yindɨ. Ngɨni yaiga nɨma sakwat nɨmba wun kat yelavɨtaa apma taagwat waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Njambwi nyan wun kat apma vat yindɨ. Ndɨna sɨ kwutaa katsogiyowun. ");
INSERT INTO ian_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndɨnai waa nyaangɨt wutɨga nɨmba ndi kat kwunakiyandɨ. God ndina nyangu kat kwunaka ndina ngwak kat kwunaka kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God ndɨ kwondu mbundɨ nyana. nat nɨmba nɨn apma nɨmba nɨn waa yelavɨka lɨgandi. God ndi kat kai waa savɨlɨlɨgandɨ, kava kava vaaka yigiyandi. ");
INSERT INTO ian_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Njambwi la ndi king kat kai waa ndina sɨ viyesendalɨgandɨ. Kwo la ndi nɨmba ndina sɨ kwutaa katsolɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wundɨ kat tɨga nɨmba ndi kat apma kɨgɨnda kwilɨgandɨ. nɨma sakwat nɨmbun ndawi lɨga nɨmba ndi kat ana kwilɨgandɨ. Ndi Godnanamba klalapman kwo yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God ndɨna nɨmba isrel walɨnja nɨmba ndi kat kwunatɨndɨ. kwunatɨnda vak yelavɨka lɨgiyandi. Ndina maawut ana tɨvɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tamba nɨna ngwat walanga kat kwunakiyowun waa wandɨ God. Tamba la nyan ebraham kat kupma wandɨ. Mɨno mɨna nyangu ngwak walanga kat kwunakiyowun waa God wandɨ Ebraham kat waa walɨ Maria. ");
INSERT INTO ian_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Ilisabetna ngay mbak kuvut tɨlɨ. Tɨga lɨga yilɨ lɨla ngepma. ");
INSERT INTO ian_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabet nyan kwup mɨna lɨlɨ. Tɨga lɨga nondanyan kwutɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nyan kwutɨ mala lɨla ngepma nɨmba lɨla yelangɨ nɨmba wutaa solat sɨga wandi. Njambwi nyan lɨ kat apma vat yindɨ waa solat sɨga wandi. ");
INSERT INTO ian_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nandinya sɨla kuvut yindɨ maa mat nyana mbangɨ pɨtaa sɨ wavat wandi. Ndɨna nyaekna sɨmba Sekaraia waa wavat wandi. ");
INSERT INTO ian_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ndɨna nyɨme kai walɨ. Ndɨna sɨ Jona waa nyɨme walɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Walɨ maa lɨ kat wandi. Nyɨna yelangɨna sɨ ana ndɨ. Manda kat Jon waa waiganyɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nyɨme kat walaa mat nyana nyaek kat taamba yiga wagalandi maa ");
INSERT INTO ian_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ndɨ taamba yiga pensil pepa agwi waa taambamba wandɨ. kwindi maa pɨlɨwutndɨ, vɨlaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sekaraia jona sɨ pɨlɨwutaa ndɨna kwundi kwo lɨndɨ, ngambundɨ. Godna sɨ kwutaa katsoga ngambundɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngambundɨ mala ndɨna ngepma nɨmba wutaa maawut viyalɨndɨ, vaaka lɨndi. Vaaka lɨga judia walɨnja nɨma kɨpmana nduwi la kava kavamba mbutseli mbutsela mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nɨma sakwat nɨmba wan nyaangɨt wutaa nɨma maawut yelavɨka lɨndi. yelavɨka lɨga wagalandi. Wan mat nyan angamak tɨgiyaa nyana waa wagalandi. God wan nyan kat kwondu kwindɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jona nyaek sekaraia Godna waagan ndɨna mbangɨ tavindɨ mala Godna nyaangɨt mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mbuka wandɨ. Nɨn Isrel walɨna nɨmba nɨna njambwi nyan God ndɨ apma nyana. Ndɨna nɨmba kat ngaga yalaa kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nɨn kat kwunatɨga nyan tamba kwindɨ. Nɨn kat kwunapmak yaiga nyan tamba la nyan Devitna yelangɨ nyana. ");
INSERT INTO ian_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tamba la profet ndi God waa nyaangɨt mbutndi. God ngɨni nɨn kat kwunakiyandɨ waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nɨn kat kwunatndɨ mala nɨna maama nɨmba kat kwulakiyanɨn. Nɨn kat kai walɨga nɨmba kat kwulakiyanɨn waa tamba la profet mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God nɨna ngwak kat tamba wandɨ. ngwuk kat awagapma apma vat yigiyowun waa wandɨ. Wan wanda apma nyaangɨt Godna maawut ana tɨvɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tamba God nɨna walanga Ebraham kat nɨma kwundimba wandɨ. Mɨn kat apma vat kwunakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Wan wanda vak vla nɨn kat kwunakiyandɨ. nɨn kat kwunatndɨ mala nɨna maama nɨmba kat kwulataa nat vak kwagalalaa Godna njɨvwa mɨna kwukiyanɨn. kwuka lɨga ana vaaka lɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Apma vat yiga God yeta vla apma vak yetɨgiyanɨn njɨmbla njɨmbla. ");
INSERT INTO ian_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mɨn Jon wuna nyan mɨn njambwi nyan God ndɨnai waa nyaangɨt mbutɨga nyanat tɨgiyamɨn. Mɨn tatak njɨvwa kwuka yigiyamɨn. Njambwi nyan ngɨni njɨvwa kwuka yaigandɨ. njambwi nyan yandeya yambɨ mɨn kwunakiyamɨn. ");
INSERT INTO ian_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Njambwi nyan ndɨna nɨmba kat kwunatndeya vak mɨn ndi kat mbukiyamɨn. Ndi kat kwunataa kavle vat yiga yetɨlɨnja vak kat njambwi nyan sɨlɨmbwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God nɨn kat nɨma maawut yelavɨka lɨgandɨ. Ngi kat tɨga nɨn kat kavle vat awagapma sɨlɨmbwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mbambala nɨn kulun walɨga kavamba tɨga nɨmba vla lɨganɨn. mbambala wundumbu yilɨga nɨmba vla lɨganɨn. nɨn kat kwunatndɨ maa nɨna maawut apma vat mɨna yelavɨka lɨgiyanɨn waa wandɨ Sekaraia. ");
INSERT INTO ian_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mat nyan Jon tamba nɨma yindɨ. Apma maawut sɨka lɨndɨ. Tɨga lɨga ngepma kwagalalaa ndinyangu lapman kwo kava yiga yetɨndɨ. Isrel walɨnja nɨmba kat nyaangɨt mbutndeya nandinya kat kwo kavamba lɨga kawiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ndina kɨpmana njambwi nyan Sisa Ogastas ngepma ngepmana nɨmbana sɨ klavat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tak ndina sɨ ana klalɨndi. kupi vatna tamba sɨ klavat yigandi. Sɨ klalɨnja njɨmbla Siria walɨnja kɨpmana nɨma nyan Sairinias tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sɨ klavat wandi maa ngepma ngepma la nɨmba ndina ngepma kwagalalaa angwa ngepmat yindi. ");
INSERT INTO ian_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ndɨno yindɨ. Nasaretna nat ngepma Galili kwagalalaa Betlehem walɨnja ngepmat yindɨ. Wan ngepma Judiamba lɨndɨ. Betlehem Devitna yelangɨ nɨmbana angwa ngepma. Josep ndɨ Devitna yelangɨ nyana. ");
INSERT INTO ian_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kapma ana yindɨ. Ndɨna tagwonala yindɨ. Ndɨna taagwa nyan tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tamba yiga wungi ngepmamba lɨgandi. Tɨga lɨga nyan kwup mɨna lɨgalɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tɨga lɨga ngɨma nyan kwutɨ. kwutaa ndɨ kat waavwimba ngiga kwutɨ. Ndɨ kat kwataa yiga naangalɨ. Bulmakau kɨgɨnda kɨla bokismba naangalɨ, sɨndu kwandɨ. Tak haus pasindia wuleivat wambɨt. Haus pasindia tamba taatɨ. Nɨma sakwat nɨmba. ");
INSERT INTO ian_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ngepma ngwaymba nat nɨmba sip sip kat ngan vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tɨga lɨga njambwi nyana ensel ndi kat ngaga yandɨ. ngaga yandɨ mala nɨma vak kembandɨ vɨlaa vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ensel ndi kat wandɨ. Ke vakngwa. Apma nyaangɨt mbupmat yawun. Mbukweya nyaangɨt wukiya nɨmba aywaa solat sɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mbambala Devitna ngepmamba taagwa kɨta nyan kwutɨ. Wan nyan ngwuk kat kwunakiya nyana. Wan nyan njambwi nyana. God wandɨ, yaa nyana. ");
INSERT INTO ian_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ngepma yilaa vɨgiyangwuk wan nyan kat. Ndɨna nyɨme ndɨ kat waavwi ngilaa bulmakau kɨgɨnda kɨga bokismba naangalɨ, vɨgiyangwuk. Bulmakau kɨgɨnda kɨla bokismba kwaiga nyan kat vɨlaa ensel nɨn kat ana woseka wandɨ. Kɨngi mat nyan kat wandɨ waa yelavɨkiyangwuk waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel wandɨ mala nɨma sakwat ensel ngaga yalaa dɨnogwinala ngambulɨndi. Godna sɨ kwutaa katsoga ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God nyɨnangwupmba lɨga apma nɨma nyana. Ngwuk kɨpmamba lɨga nɨmba ngwuk kat apma vat yindɨ, apma maawupmba tɨgiyangwuk waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel walaa ndi kat kwagalalaa nyinangwutnat wokendi. Wokendi maa vɨga la nɨmba awat sowat ngambundi. Betlehem yagwa yigat. Nɨma nyan nɨn kat mbutnda vak yiga vɨgiyanɨn walaa yindi. ");
INSERT INTO ian_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Laataakwiyatapman yindi. yilaa yiga vɨndi. mariagwi Josep kat vɨndi. wan nyan bulmakau kɨgɨnda kɨla bokismba kwandɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vɨlaa ensel ndi kat mbukna nyaangɨt nat nɨmba kat yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mbutndi mala wuta nɨmba mandɨp mandɨp yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria wutaa ana mandɨp mandɨp yelavɨka lɨlɨ. Lɨla maawupmba tɨndɨ, yelavɨka lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sip sip kat vɨga la nɨmba ndi kat kwagalalaa lungwamataa yindi. Ensel nɨn kat wanda nyaangɨt tɨgandɨ, vɨnɨn. God apma nyana. Njambwi nyana waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nandinya sɨla kuvuk yindɨ maa mat nyana mbangɨ pɨtaa ndɨ kat sɨ wandi. Ndɨna sɨ jisasa waa wandi. Ndina maawupmba ana wandi. Ensel kan sɨ wandɨ maa mat nyan nyɨmena yapmba tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Taagwa nyan kwuta nglambi lɨmbwinjeya njɨmbla ngwaymba lɨgandɨ. Tamba la nyan Moses pɨlɨwuta nyaangɨpmba nglambi sɨlɨmbwindi. Ngi kat tɨga nglambi lɨmbwivat Jerusalemat yindi. Mat nyan kwutaa God kat sɨmogwivat kalimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tamba Moses kwiya nyaangɨt pɨlɨwutndɨ. Ngɨma nyan nondanyan aywaa God kat sɨmogwigiyangwuk. Ndi Godna njɨvwa kwukiyandi waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nglambi sɨlɨmbwivat waavi vatnyalaa kwimbɨt. Tamba Moses kwiya nyaangɨpmba kwimbɨt. nugulɨvɨk vɨlɨlɨk kwingweyan wovuna. Namio vɨlɨlɨk kwingweyan wovuna waa tamba pɨlɨwutndɨ Moses. ");
INSERT INTO ian_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kɨta nyan Jwerusalemba la nyan ndɨna sɨ Simion. Ndɨ apma vat yiga yetɨlɨga nyana. God waa nyaangɨt wutɨga nyana. God Isrel walɨnja nɨmba kat kwunatndeya njɨmbla kat kawiga lɨlɨndɨ wan nyan. Godna waagan ndɨna mbangɨ tavilaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tak Godna waagan ndɨ kat mbutndɨ. Tak ana kiyaigamɨn. Tak God wandɨ, yaa nyan Kraist ndɨ kat vɨgiyamɨn. Vɨlaa ngɨni kiyaigamɨn waa mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godna waagan ndi kat wandɨ maa Godna ngay wuleindɨ. Wuleindɨ maa Jisasna nyaek nyɨme ndɨ kat kwutaa wuleimbɨt. Tamba Moses mbuta nyaangɨpmba nglambi sɨlɨmbwivat wuleimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion mat nyan kat vɨlaa yiga ndɨna taambamba kwutaa Godna sɨ kwutaa katsolaa God kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Njambwi nyan tak wun kat wama nyaangɨt mbambala tamba vɨgowun. Mbambala kiyaweyan wovuna. Ana kai waigowun. ");
INSERT INTO ian_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ndinyangu kat kwunapmak kwima nyan mbambala tamba vɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wamɨn maa wan nyan ndinyangu kat aywaa kwunapmak yandɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Juda ana ndi nat nɨmba ndi kat apma nyaangɨt vɨsɨmogwindɨ, vɨga wukiyandi. Nɨn Isrel waa Juda walɨnja nɨmba nɨna nɨndɨmba laatndɨ. Nɨna nɨndɨmba laatndangat nat nɨmba nɨna sɨ kwutaa katsogiyandi waa wandɨ Simion. ");
INSERT INTO ian_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion wandɨ mala Jisasna nyaek nyɨme wutaa mandɨt mandɨt yelavɨpmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion mbɨk kat wandɨ. God mbɨk kat apma vat yigiyandɨ waa walaa Jisasna nyɨme Maria lɨ kat vɨga wandɨ. Awut nyɨla. Wan mat nyan kwutndeya njɨvwa kwutndɨ mala Judana nɨma sakwat njambwi nɨmba kavle yigiyandi. Nɨma sakwat nɨmba kwo nɨmba apma vat tɨgiyandi. Nat nɨma sakwat nɨmba ndɨ kat kai waigandi. ");
INSERT INTO ian_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndɨ kat kai waiga nɨmba maawupmba yelavɨtnjeya vak ana pagwugiyandi. Kapmba kai waigandi. Kai wanja njɨmbla nyɨn kat nɨma vat tɨgiyandɨ waa wandɨ Simion. ");
INSERT INTO ian_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Profetna njɨvwa kwutɨga taagwa kɨta lɨlɨ. Lɨla sɨ Ana. Lɨla nyaekna sɨ Panuel. Lɨla yelangɨ Asa walɨnja yelangɨ. Lɨ avɨt taagwak. Tak ndu klalaa naambi sɨla vɨli tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Lɨla lan kiyandɨ maa to lagwa kwalɨ. Lɨla naambi ndumi aynat kiyeli aynat. Godna ngaymba mɨna jnjɨvwa kwuka yetɨlɨ. Nat walaa nandinya ngan God kat mɨna wagalaga yetɨlɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jisasna nyaek nyɨme tɨlɨmbɨk mala Godna ngay wuleilɨlɨ. Mat nyan kat vɨlaa God kat sɨvu lɨlɨlɨ. Kumba la nat nɨmba God ngɨni Juda kat kwunatndeya njɨmbla kat kawiga lɨndi. Wundi nɨmba kat vɨlaa walɨ. Ndɨnayɨ. Nɨn kat kwunakiya nyana waa walɨ. Nɨn kat kwunakiya nyan tamba yalaa lɨgandɨ waa Jerusalemba la nɨmba kat mbutseli mbutsela mbutɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","God waa nyaangɨpmba nglambi aywaa lɨmbwiyagilaa ngepmat yɨmbɨt. Galili walɨngja kɨpmat yiga mbɨtna angwa ngepma Nasaretnat Jisas kat kwutaa yimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tɨga lɨga mat nyan nɨman yindɨ. Ndɨna maawut apma vat sɨka lɨndɨ. Apma vat ndɨna nambu lɨgandɨ. God ndɨ kat nɨma kwondu kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisasna nyaek nyɨme naambi naambi pasova walɨnja pesto vɨvat Jerusalemat yilɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasna naambi taamba vɨli kiyeli vɨlɨlɨk tɨndɨ, yilɨnja vak vla pesto kat yilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pesto ngɨlɨndɨ mala Jerusalem kwagalalaa ngepma lungwamataa yindi. Jisas ndɨ ana yindɨ. Ndɨ wumba lɨndɨ. Mbɨk Jisas tamba yigandɨ waa yelavɨtaa Jerusalem kwagalalaa yimbit. ");
INSERT INTO ian_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nɨma sakwat nɨmba kɨtamba yilɨndi. Jisas kɨta vat yilɨganɨn waa yelavɨtaa kɨta nandinya yiga tɨmbɨk. Ava yambɨ yiga lɨga ngan mbɨla ngepma nɨmba alɨ nɨmba kat Jisas kat kwaka wagalambɨt. ");
INSERT INTO ian_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wagalambɨt, kai ana lɨgandɨ wandi. Kai wandi mala ndɨ kat kwapmak Jerusalem lungwamataa yimbɨt ndɨ kat vɨvat. ");
INSERT INTO ian_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndɨ kat kwaka vɨlevimbɨt. Kwaka vɨlevilaa kuvut wan nandinya Godna ngay wuleilaa ndɨ kat vɨmbɨt. Nat nɨmba kat sɨmogwi lɨga njambwi nɨmbana nɨndɨmba ndalɨndɨ, vɨmbɨt. Ndɨ kat wagalalaa mbutɨnja nyaangɨt wuka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jisas mbuta nyaangɨt wuta nɨmba ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ndɨna nyaek nyɨme ndɨ kat vɨlaa mbɨtno ngɨpaliga ndambɨt. Ndɨna nyɨme ndɨ kat walɨ. Nyan, an kat manda kat wupma yimɨn. Wuno mɨna nyaekno mɨn kat kwaka yeta. Nɨma vak yelavɨka kwaka yeta waa walɨ maa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mand kat wun kat kava kava kwatɨmbɨt. Wuna nyaekna ngaymba tuwan apma vatna. Nglaatndɨ. Tuwa vak wupma mbɨk ana vɨga lɨgambɨt? Waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wanda nyaangɨt wutaa ana yigumba yelavɨpmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bɨlagwio kɨta kɨta yigandɨ Nasaretnat. Nasaretmba yiga tɨga mbɨlai waa vak Jisas wuka lɨndɨ. Ndɨnai ya vak vɨlaa ndɨna nyɨme maawupmba yelavɨka lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas nɨma yilaa ndɨna nambu apma vat tɨndɨ. Godno nat nɨmbo ndɨ kat vɨlaa apma vat tɨgandɨ waa Jisas kat wandi. ");
INSERT INTO ian_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Njambwi nyan Tabirias Sisa naambi taamba vɨli kiyeli tambanat vɨga lɨndɨ. Judia walɨnja nɨma kɨpma kat vɨga la njambwi nyan Pontias Pailat. Galili walɨnja nɨma kɨpma kat vɨga la njambwi nyan Herot. Herotna yakwa nyan Filip kava vɨlɨlɨk kat vɨga lɨndɨ. Ndɨ Ituriagwi Trekonaitis kat vɨga lɨndɨ. Abilini walɨnja kava kat vɨga la nyan Laisenias. ");
INSERT INTO ian_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Judana njambwi nɨmba God kat kwunatɨga nɨmba vɨlɨlɨk palɨ. Mbɨla sɨ Anaso Kaiafas. Wan njɨmbla God Sekaraiana nyan Jon kat wandɨ. Wandɨ, Jon ndinyangu lapman kwo kavamba yiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","God wandɨ maa kwo kava kwagalalaa Jodan walɨnja ndandangɨ wayat yindɨ. Yiga mbutndɨ. Kavle maawut kwagalalaa mandɨt kupi maawupmba lɨga ngu yagungweyan God ngwutna kavle vat sɨlɨmbwigiyandɨ waa mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon mbuta nyaangɨt tamba la profet Aisaia ndɨ tamba kɨta vat pɨlɨwutndɨ. Kupma pɨlɨwutndɨ. Kɨta nyan kwo kavamba lɨga laataa nyaangɨt mbukiyandɨ. Njambwi nyan yaiga yambɨ kwunak ngwula waa bukiyandɨ. Ngu lɨga kava kava ngɨni tagula kɨpmat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","6","Nduwi tɨga kava nduwi ndandɨ, apma savagu kɨpma tɨgiyandɨ. Sɨvi vita lɨga yambɨ ngɨni apma vat tɨgiyandɨ. Nɨma kambat tɨga yambɨ ngɨni savagu lɨgiyandɨ. Ngɨni God ndinyangu kat kwunatndeya vak ndinyangu aywaa vɨgiyandi waa tamba pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɨma sakwat nɨmba ngu yaguvat Jon kat yandi. Yandi maa ndi kat mbutndɨ. Ngwuk apma nɨmba ana ngwuk. Ngwuk kamboyna nyangu vla lɨgangwuk. Ngɨni yaiga kavle vak kat vaaka lɨga wun kat yangwuk. ");
INSERT INTO ian_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kavle maawut kwagalalaa apma kupi maawupmba yelavɨka lɨngweyan apma vapmba yiga alɨ ngwuk. Ngwuk kupma yelavɨka lɨgangwuk. Nɨn Ebrahamna nyangu nɨn. Ngi kat tɨga kavle savle yiga yetɨneyan God nɨn kat ana kai waigandɨ waa yelavɨka lɨgangwuk. Wupma ke yelavɨka. Ana nglaatndɨ. Kavle savle yiga yetɨngweyan God ngwuk kat kai walaa kan tɨga kambak kwutndɨ mala Ebrahamna nyanguat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kavle mi vɨtɨga nyan vɨp mɨna lɨgandɨ. Avɨmba ngwuk. Apma mɨ sɨk kwalapma mi aywaa vɨtaa yamba yaagindɨ, vɨkiyandɨ waa mbutndɨ Jon. ");
INSERT INTO ian_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mbutndɨ mala nɨma sakwat nɨmba ndɨ kat wagalandi. Anda apma njɨvwa kwutaa apma vat kwo lɨgiyanɨn waa ndɨ kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wagalandi mala ndi kat wandɨ. Waavwi vɨlɨlɨk tɨga nyan nat nyan waavi lapman tɨga nyan kat agwi. Kɨgɨnda lɨga nyan kɨgɨnda lapman tɨga nyan kat vɨlaa agwi waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis sanya klalɨga nɨmba ngu yaguvat Jon kat yalaa wagalandi. Sɨmogwi lɨga nyan nɨn angambak yigiyanɨn waa wagalandi maa Jon ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ngwuk kiap waa sakwapmba mɨna klaigangwuk takis sanya. Mandɨp wata kwuleiga sɨkwupmak klalɨngweya waa Jon ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldia ndɨ kat wagalandi. Nɨn angamak yigiyanɨn waa wagalandi maa Jon ndi kat wandɨ. Ngwuk wata woseka waga ndi kat viyaga nat nɨmbana nda sɨkwupmak walɨngweya. Ngwuk kat pe kwindi, ngiyambak waa awa waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nɨma sakwat nɨmba Jon kat vɨlaa mandɨp mandɨp yelavɨka lɨndi. Ndɨ nɨn kat kwunakiya nyan anagandɨ waa maawupmba yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yelavɨka lɨnja vak wutaa Jon ndi kat wandɨ. Wun nɨma njɨvwa ana kwutɨgowun. Ngwuk kat ngu yagua njɨvwa mat njɨvwat. Ngɨni yaiga nyan wuna njambwi nyanat. Wun apma nyan ana wun. Ndɨna man suna yaaw ana alɨpsɨga njalakiyowun. Apma nyan mɨna njalakiyandɨ. Wuna kwupmba ngɨni yaiga nyan wandɨ mala Godna waagan ngwuk kat tavigiyandɨ. Tayindɨ mala kɨsɨk yamba vɨka ngɨlɨndaya vak ngwutna kavle vat ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ngɨni yaiga nyan yuwi sɨk kwutɨga nyan vla lɨgandɨ. Sɨla sɨlak klalaa yiga yuwi sɨk sɨka yiga ngaymba yisolɨgandɨ. Ndɨna ava ndɨna sɨmbɨ sɨka nɨma vat vɨtɨga yamba yisolɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndina kavle maawut kwunapmak Jon nɨma sakwat nyaangɨt mbutɨndɨ. Ndi kat apma nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wan kɨpmana njambwi nyan Herot ndɨna yakwa nyana taagwa Herodias vanyangɨka klandɨ maa Jon ndɨ kat kavle vat yimɨn, mɨn kavle vat yilɨga nyan mɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herot ya kavle vat nɨma sakwatna. Nat kavle vat yiga Jon kat kalabus kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon nɨma sakwat nɨmba kat ngu yagulaa Jisas kat yagundɨ. Yagundɨ maa Jisas God kat wagalalɨndɨ maa nyinangwut yambɨ kwandɨ. ");
INSERT INTO ian_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wungi yambɨmba Godna waagan ngaga yandɨ. Namiyo saava klalaa yandɨ, vɨndi. Vɨlaa nyinangwupmba lɨga kwundi wutndi. Mɨn wuna apma nyan mɨ. Mɨn kat wun solat sɨlɨgowun waa wandɨ kwundi. ");
INSERT INTO ian_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisasna naambi ndumi vɨli kiyeli tamba vɨli tɨndɨ, njɨvwa kwupmat laatndɨ. Ndɨ Josepna nyana waa nɨma sakwat nɨmba yelavɨka lɨndi. Wan nyan Josep ndɨna nyaek Hilai. ");
INSERT INTO ian_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilaina nyaek Matat Matatna nyaek Livai Livaina nyaek Melkai Melkaina nyaek Melkai Jananina nyaek Josep Josepna nyaek Matataias ");
INSERT INTO ian_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matataiasna nyaek Emos Emosna nyaek Neam Neamna nyaek Eslai Eslaina nyaek Nagai Nagaina nyaek Meat ");
INSERT INTO ian_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Meatna nyaek Matataias Matataiasna nyaek Semem Sememna nyaek Josek Josekna nyaek Joda Jodana nyaek Joanan ");
INSERT INTO ian_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanana nyaek Resa Resana nyaek Serababel Serababelna nyaek Sialtiel Sialtielna nyaek Nerai Neraina nyaek Melkai ");
INSERT INTO ian_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melkaina nyaek Edai Edaina nyaek Kosam Kosamna nyaek Elmedam Elmedamna nyaek Ea Eana nyaek Josua ");
INSERT INTO ian_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josuana nyaek Eliesa Eliesana nyaek Jorim Jorimna nyaek Matat Matatna nyaek Livai Livaina nyaek Simion ");
INSERT INTO ian_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simiona nyaek Juda Judana nyaek Josep Josepna nyaek Jonam Jonamna nyaek Eliakim Eliakimna nyaek Melia ");
INSERT INTO ian_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meliana nyaek Mena Menana nyaek Matata Matatana nyaek Netan Netana nyaek Devit Devitna nyaek Jesi ");
INSERT INTO ian_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesina nyaek Obet Obetna nyaek Boas Boasna nyaek Salmon Salmona nyaek Nason Nasona nyaek Aminadap ");
INSERT INTO ian_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadapna nyaek Admin Admina nyaek Anai Anaina nyaek Hesron Hesrona nyaek Peres Peresna nyaek Juda Judana nyaek Jekop ");
INSERT INTO ian_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekopna nyaek Aisak Aisakna nyaek Ebraham Ebrahamna nyaek Tera Terana nyaek Neho Nehona nyaek Serak ");
INSERT INTO ian_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serakna nyaek Kiya Kiyana nyaek Pelek Pelekna nyaek Iba Ibana nyaek Sila Silana nyaek Kenan ");
INSERT INTO ian_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenana nyaek Afaksat Afaksatna nyaek Sem Semna nyaek Noa Noana nyaek Lemek Lemekna nyaek Metusala ");
INSERT INTO ian_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusalana nyaek Inok Inokna nyaek Jeret Jeretna nyaek Mahalalil Mahalalilna nyaek Kenan Kenana nyaek Inos ");
INSERT INTO ian_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Inosna nyaek Set Setna nyaek Adam Adamna nyaek God. ");
INSERT INTO ian_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Godna waagan Jisasna mbangɨ tavindɨ mala Jisas Jodan walɨnja ndandangɨ kwagalalaa kwo kavat yindɨ. Godna waagan wanda ava yambɨmba yindɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwo kavamba nandinya ndumi vɨlɨlɨk yetɨndɨ. Yetɨga lɨga Seten ndɨ kat yalaa kavle vat ay waa wandɨ. Nandinya ndumi vɨlɨlɨk kɨgɨnda ana kɨndɨ Jisas. Kwo yetɨndɨ. Wan nandinya ngɨlɨndɨ, wundɨ kat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seten ndɨ kat yalaa wandɨ. Godna nyanat tɨmeyan kan tɨga kambak klalaa bretnao kwupmeyan Godna nyanat tɨma vak vɨgiyowun waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tamba la nyan God waa nyaangɨt pɨlɨwutndɨ. Kɨgɨnda kɨvak kat mɨna yelavɨtɨgiya nɨmba ndi apma vat ana tɨgiyandi waa tamba la nyan pɨlɨwutndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seten Jisas kat kwutaa nat kavat kalindɨ. Ndɨ kat kalilaa kan kɨpmana njambwi nɨmba vɨga la kava aywaa ndɨ kat kwiyatapman vɨsɨmogwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Vɨsɨmogwilaa wandɨ. Vɨlɨma njambwi nɨmbana ava kwondu wuna kwondua. Wunamba klandi. Wuna maawupmba nat nɨmba kat kwilɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wun kat vɨlaa nambu sɨlandalaa mɨn njambwi nyan mɨn waa wameyan mɨn kat wuna kwondu kwigiyowun waa wandɨ Seten. ");
INSERT INTO ian_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas ndɨ kat wandɨ. Tamba la nyan God waa nyaangɨt pɨlɨwutndɨ. Ngwutna njambwi nyan kɨta lɨgandɨ. Godna. Nat nyan kat mɨn njambwi nyan mɨn waa ke waa. God kɨta lɨgandɨ njambwi nyan waa tamba pɨlɨwutndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Setan ndɨ kat nat njambɨ kwutaa Jerusalemat kalindɨ. Kalindɨ maa God kat kwunatɨnja sɨvla mbundɨ ngayna sambɨ ngeat wokembɨt. Wokembɨt maa Seten ndɨ kat wandɨ. Godna nyanat tɨmeyan valaseliga kɨpmamba ndamɨn, vɨlu. ");
INSERT INTO ian_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tamba la nyan God waa nyaangɨt pɨlɨwutndɨ. Godna ensel mɨn kat vɨga lɨgiyandi. Ana kavle yigiyamɨn waa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nat nyan pɨlɨwutndɨ. Mɨn kat ensel kwutaa taambamba kwutaa katsogiyandi. Nɨmbumba ana nɨmamba ndai viyaigamɨn. Ndi kwutaa katsogiyandi waa tamba pɨlɨwutndɨ waa wandɨ Seten. ");
INSERT INTO ian_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas ndɨ kat wandɨ. Nat tamba la nyan God waa nyaangɨt pɨlwutndɨ. Awup mɨla. Ngwula njambwi nyan God kat kavle vat ay waa ke waa waa tamba pɨlɨwutndɨ waa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seten Jisas kat kavle vat ay waa wanda nyaangɨt ngɨlɨndɨ maa Jisas kat kwagalalaa yindɨ. Yilaa yelavɨtndɨ. Ngɨni ndɨ kat yiga nat njambi waigowun waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Godna waagan Jisas kat kwondu kwindɨ maa Jisas Galili walɨnja kɨpmat yindɨ. Njɨvwa kwutɨnda vak kava kava la nɨmba mbutseli mbutsela mbutɨndi, wutndi. ");
INSERT INTO ian_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Juda yisolaa tɨnja ngay wuleilaa ndi kat nyaangɨt mbutɨndɨ. Wutaa apma nyana waa yelavɨtaa wandi. ");
INSERT INTO ian_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas Nasaret walɨnja ngepma yindɨ. Tamba mat nyan tɨga kan ngepma yetɨga nɨman yindɨ. Ndɨna angwa ngepma. Njɨvwa lapman nandinya aywaa yisolaa lɨnja ngay wuleilɨndi. Wuleilaa nyinga lɨga nyaangɨt vɨvat laatndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Laatndɨ maa tamba la profet Aisaia pɨlɨwuta nyaangɨt tɨga nyinga ndɨ kat kwindi. Kwindi maa lavwilaa vɨga kwundimba wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Godna waagan wun kat tavilaa mbutndɨ. Kavle vat tɨga nɨmba ndi kat apma nyaangɨt ambuk mɨla waa mbutndɨ. Ngindi, kalabusmba lɨ vla lɨga nɨmba ndi kat yiga njalap mɨla waa mbutndɨ. Vat ta nɨmba kat ndi kat kwunap mɨla waa mbutndɨ. Mbambala God nɨn kat kwunakiyandɨ waa ambup mɨla waa Godna waagan wun kat mbutndɨ waa tamba la profet pɨlɨwutndɨ waa Jisas viga kwudimba walaa ");
INSERT INTO ian_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","nyinga wan ngavna nyinga kat vɨga la nyan kat kwilaa ndaalɨndɨ. Ndaa lɨndɨ mala wan ngaymba la nɨmba apma nyaangɨtna ngambulɨnda waa yelavɨka aywaa ndɨ kat vɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jisas ndi kat wandɨ. Tamba la nyan pɨlɨwutnda nyaangɨt viga wawa nyaangɨt mbambala kak kiyagandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","wuta nɨmba yelavɨtndi. Wan nyan apma nyaangɨt ngambulɨgandɨ. Apma nyaangɨt ngambulɨnda vak andamba klandɨ. Ndɨ kwo nyana. Ndɨ Josepna nyana waa yelavɨka wandi. ");
INSERT INTO ian_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisas ndi kat wandɨ. Kɨngi ngepmana nyan wun viga lɨgangwuk. Ngɨni wun kat anagangwuk waiga. Nat ngepma kapaneam yilaa ndina yelogwen kat ta nɨmba kat kwunapmɨn. Angwa ngepma yalaa manda kat kwunatapman yilɨgamɨn waa wun kat anagangwuk waiga. ");
INSERT INTO ian_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wun kat wagalangweya nyaangɨt kat awat waigowun. Awuk ngwula. God waa nyaangɨt butɨga nyan profet walɨna nyan ndɨna angwa ngepmamba ta nɨmba ndɨ kat kai walɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tamba wupma lɨndɨ. Tamba Ilaija ta njɨmbla talagwa nɨma sakwat tɨndi nɨn isrelna kɨpmamba. Wan tamba la njɨmbla naambi kuvuk mbak sɨla kɨta meik ana ndandɨ, kɨgɨnda ngɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Godna njɨvwa kwutaa tamba la nyan Ilaija kɨgɨnda lapman talagwa kat kwunapmak yindɨ. God wandɨ, yindɨ. Nɨn Isrelna talagwa kat kwunapmak ndɨ ana yindɨ. Kapman ngepmamba ta talagwa kat kwunapmak yindɨ. Lɨla ngepma Sarefat. Wan ngepma Saidon walɨnja nɨma kɨpmamba la ngepma. ");
INSERT INTO ian_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Godna njɨvwa kwuta tamba la nat nyan Ilaisa ndɨno nɨmbun. Ndɨnai la njɨmbla kawia kɨla Juda nɨma sakwat tɨndi. Ndina kɨta nyan kat ana kwunatndɨ. Kawia kɨla kapma ngepma nyan kat kwunatndɨ Ilaisa. Wan nyana ngepma Siria walɨna ngepma. Ndɨna sɨ Neaman waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yisolaa lɨnja ngaymba la nɨmba wutaa Jisas kat walia lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Walialɨga laataa Jisas kat kwutaa ngepma alaguat kalindi. Wungi ngepma nambu nduwimba ngindi, lɨndɨ. Nambu nduwi valagalaa tɨga kavamba ndɨ kat sandavat kalindi. ");
INSERT INTO ian_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ndi nɨma sakwat nɨmbana mbupmba wuleilaa yindɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas Galilina nat ngepma kapaneam walɨnja ngepmat ndaindɨ. Njɨvwa lapman nandinya ndi kat nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ndɨnai waa nyaangɨt wuta nɨmba ngɨpaliga ndalaa maawupmba yelavɨtndi. Nat nɨmba mbutɨnja vla ana mbutɨgandɨ. Kwondumba mbutɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yisola lɨnja ngaymba Jisas mbutɨndɨ mala kavle waagan tavila la nyan laataa Jisas kat nɨma kwundimba walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Mɨn Jisas Nasaret nyan manda kat nɨn kat yamɨn. Nɨn kat vatnyavak yamɨn? Mɨn kat vɨga lɨgowun. Mɨn God wandɨ, yaa apma nyan mɨn waa walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wandɨ mala Jisas kavle waagan kat kai waga wandɨ. makayak. Ndɨ kat kwagala waa wandɨ maa waagan wan nyan kat kwutaa viyandɨ mala ndina nɨndɨmba kɨpmamba ndandɨ. Waagan ndɨ kat ana kavle vat yindɨ. Ndɨ kat viyalaa kwagalalaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Va nɨmba ngɨpaliga ndalaa awat sowat wandi. Ndɨnai mbuta nyaangɨt kwonduo tagula nyaangɨtna. Kavle waagan kat wandɨ maa wutaa kwagalalaa yilɨgandi. nɨma tagula vatna waa awat sowat wandi. ");
INSERT INTO ian_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yinda vak kat kava kavamba la nɨmba mbutseli mbutsela mbutɨndi. Aywaa wutndi. ");
INSERT INTO ian_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas yisolaa tɨnja ngay kwagalalaa Saimon waa Pita walɨnja nyana ngay wuleindɨ. Pitana nasakwatna mbangɨmba nɨmamba kangan walɨndɨ, kavle vat tɨlɨ. Lɨ kat kwunapmak Jisas kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lɨla ngwaymba laataa lɨga yelogwen kat kai wandɨ, kwo lɨlɨ. Lɨ laataa ndi kat kɨgɨnda kwutaa kwilɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nya tamba ndai mɨna lɨndɨ. Nat nɨma sakwat nɨmba yelogwen kat ta nɨmba kat kwutaa Jisas kat kalindi. Ndi kat aywaa taamba taagalaa kwunatnɨ. ");
INSERT INTO ian_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kavle waagan tavila la nɨmba kat ndino ndi kat kwunatndɨ. Kan waagan ndinyangu kat kwagalalaa walega wandi Jisas kat. Mɨn kat vɨga lɨganɨn. Mɨn Godna nyan mɨn waa walega walaa kwagalalaa yindi. Jisas ndi kat wupma ke waa waa wandɨ. God wandɨ, yaa nyan Kraist tɨnda vak nat nɨmba kat mbutnjangat kai walaa wupma ke waa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngambi wan ngepma kwagalalaa ndinyangu lapman kwo kavat yindɨ. Wan ngepma nɨmba ndɨ kat kwaka lɨga ndɨna kwupmba yindi. Ndina ngepma kwagalaa yivak kat kai waa wandi Jisas kat. ");
INSERT INTO ian_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jisas ndi kat wandɨ. Wuna njɨvwa kɨngiyan. God ndinyangu kat vɨga lɨga vat ngepma ngepmamba mbukiyowun. Wuna njɨvwa. Kɨta ngepma mɨna ana mbukiyowun. Ngepma ngepmamba mbukwangat wuna nyaek wandɨ mala yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndi kat kwagalalaa Judia walɨnja nɨma kɨpman ngepma ngepmat yindɨ. Ngepma yilaa yisolaa lɨnja ngay wuleilaa nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisas Genesaret walɨnja sak waymba lɨndɨ. Waymba lɨga God waa nyaangɨt ndinyangu kat mbutɨndɨ. Wungi nyaangɨt wupmat ngwaymba yaa ndɨ kat kematndi. ");
INSERT INTO ian_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas vɨndɨ bot vɨlɨlɨk yaawmba tundi, lɨmbɨk. Kami kwuta nɨmba bot kwagalalaa ndina njula kɨsɨk tɨndangat njangilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas yiga bot kɨta kundɨ. Saimon waa Pita walɨnja nyana botna kunda Jisas. Saimon kat wagalandɨ mala sɨvasagundɨ, Jisas bopmba ndaalɨga ndinyangu kat nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisas mbuta nyaangɨt ngɨlɨndɨ mala Saimon kat wandɨ. Jula kulaa samat wogwelaa yiga kami kat yaagi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wandɨ maa Saimon ndɨ kat wandɨ. Njambwi nyan kami kai. Nak ngan njula yaagiga vɨlevinɨn. Kami kai. Mɨn wameyan mɨna kwundimba yiga yaagigiyanɨn njula waa wandɨ maa njula kulaa yindi. ");
INSERT INTO ian_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Njula yaagilaa nɨma sakwat kami njula taata lɨndɨ. Njula ngɨlɨp mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tɨga lɨga nat botna nɨmba kat yagwa waa wandi maa yandi. Yandi maa bot vɨlɨlɨk kami kundi. Bot vɨlɨlɨk taata lumaka ndaivat yimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon waa Pita walɨnja nyan vɨlaa Jisasna man ngandɨmba ndalaa wandɨ. Njambwi nyan wun kat kwagala. Wun apma nyan ana wun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pitagwi nat nɨmbo kami kwutnja sakwat kat vɨlaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedina nyan vɨlɨlɨk Jonogwi Jemso vɨlaa ngɨpaliga ndambɨt. Mbɨt Saimono kɨta njɨvwa nyan mbɨt. Jisas Jaimon kat wandɨ. Ke vaaka. Mbambala kami kwutɨgangwuk. Ngɨni ndinyangu kat kwutaa wuna mbaapmamba taagagiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yiga kawilaa bot njula kwagalalaa Jisasna kwupmba yindi. ");
INSERT INTO ian_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas ngepmamba lɨndɨ, kawiya kɨla nyan ndɨ kat yaa vɨlaa Jisasna man ngandɨmba ndalaa wandɨ. Wun kat kwunapmat wameyan kwunakiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wandɨ maa Jisas ndɨna mbangɨ taamba taagalaa wandɨ. Mɨn kat kwunapmak wowun. Apma vak tɨgiyamɨn waa wandɨ maa kawiya kɨla vat ngɨlɨndɨ, kwo lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas ndɨ kat wandɨ. Mɨn kat kwunakwa vat nat nɨmba kat ke mbuka. Tamba Moses mbutnda nyaangɨpmba agwup mɨla. God kat kwunatɨga nyan kat yiga mɨna mbangɨ ndɨ kat sɨmogwi. Sɨmogwilaa God kat sɨvu kɨvat ndɨ kat kwanda kwanda vatnyalaa agwi. Kwimeyan ndinyangu kwo lɨmeya vat vɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nɨma sakwat nɨmba Jisas kwunatnda vak kat mbuseli mbutsela mbutɨndi. Ngi kat tɨga nɨma sakwat nɨmba ndɨna nyaangɨt wupmat yisolaa lɨndi. Nɨma sakwat nɨmba ndina yelogwen kwunatndangat yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jisas ndi kat kwagalalaa ndinyangu lapman kwo kavat yilaa God kat ngambulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nat nandinya Jisas ngaymba lɨga nyaangɨt mbutɨndɨ. Ferisiagwi tamba Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba nɨma sakwat ndaa lɨga wutɨndi. Ndi Galiliagwi Judiana ngepma ngepmamba lɨga yandi. Ndina nat nɨmba Jerusalemba lɨga yandi. God Jisas kat kwondu kwindɨ mala nɨma sakwat yelogwen kat ta nɨmba kat kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kɨvɨ watna nyan kat njambamba taagalaa aynat nɨmba walalaa Jisas ta ngayat kalindi. ");
INSERT INTO ian_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ndɨ kat kalinjeya yambɨ vɨlavindi. Nɨma sakwat nɨmba taata lɨndi. Tɨga lɨga sambange wokelaa njɨk vla plalaa yaaw tulaa ndɨ kat sandandi njambonala. Jisasna mɨndama kava sandandi. ");
INSERT INTO ian_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas ndɨ kat vɨlaa ndɨ kat kwunakwangat sanda nɨmba nɨma njɨvwa kwuka sandandi waa yelavɨtaa njambɨmba la nyan kat wandɨ. Mɨn, kavle vat yiga yetɨma vak tamba sɨlɨmbwigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas wandɨ mala Ferisiagwi Moses kwiya nyaangɨt sɨmogwi la nɨmbo awat sowat ngambulɨndi. Wan nyan God kat kavle nyaangɨt wandɨ. Kavle vat yiga yetɨma vak tamba sɨlɨmbwigowun waa manda kat wandɨ. Ndɨ ana alɨpsɨga sɨlɨmbwigiyandɨ. God mɨna alɨpsɨga sɨlɨmbwigiyandi waa awa saowat ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Maawut wumba yelavɨka awat sowat ngambulɨnja vat vɨlaa Jisas ndi kat wandɨ. Manda kat wupma yelavɨtɨgangwuk. Ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndɨ kat kavle vat yiga yetɨma vak tamba sɨlɨmbwigowun waa wowun Laataa kwalɨma njamba kwutaa kali waa wagewan kɨta nyaangɨtna. Kapmanyaangɨt ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Manda kat kavle vat yiga yetɨma vak tamba sɨlɨmbwigowun waa wowun. Kan kɨpmamba lɨga nɨmba kavle vat yiga yetɨnjeya vak kat sɨlɨmbwiweya kwondu ngilɨga. God wun kat kwindɨ. Kan kwondu vɨngwangat ndɨ kat kwunakiyowun. Godna vak sɨmogwi lɨga nyan wun waa wandɨ Jisas. Ndi kat walaa njambamba kwa nyan kat wandɨ. Laataa kwalɨma njamba kwutaa kali waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","wan nyan laataa kwalɨnda njamba kwutaa klaiga ngayat yindɨ. God ndɨ apma nyana nɨma nyana waga yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Va nɨmba ngɨpaliga ndalaa Godna sɨ kwutaa katsondi. Ngɨpaliga ndalaa wandi. Mbambala tamba nɨma vak vɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tɨga lɨga wan ngay wogwelaa takis sanya klalɨga nyan kat vɨndɨ. Wan nyan takis sanya taagalɨnja ngaymba ndaa lɨndɨ. Ndɨna sɨ Livai. Jisas ndɨ kat vɨlaa wandɨ. Wuna kwupmba yagwa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wandɨ maa Livai ndɨna nda kwagalalaa Jisasana kwupmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ngɨni Jisas kat Livai ndɨna ngaymba nɨma kɨgɨnda kwutndɨ. Takis sanya klalɨga nɨma sakwat nɨmbagwi nat nɨmba kat Livai wandɨ maa kɨvat yandi. Ndino Jisas ndɨna mbaapma nɨmbo kɨta vat kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ngɨni Ferisio tamba Moses kwiya nyaangɨt sɨmogwi la nɨmbo Jisasna mbaapma nɨmba kat wagalandi. Kavle vat tɨga takis sanya klalɨga nɨmbo nat kavle nɨmbo manda kat kɨta vat kɨlɨgangwuk. Wan apma vat ana ndɨ. Wan kavle vatna waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wandi maa Jisas ndi kat wandɨ. Kwo lɨga nɨmba ndi dokta kat ana yilɨgandi. Yelogwen kat ta nɨmba mɨna dokta kat yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mabmbala wungi vat sɨgɨt. Apma vat yiga yetɨlɨga nɨmba kat kwunapmat ana yawun. Kavle vat yiga yetɨlɨga nɨmba kat kwunapmak yawun. Kavle maawut kwagalalaa mandɨp kupi maawupmba yetɨnjangat yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jisas wandɨ mala wandi. Ngu yagu lɨga Jona mbaapma lɨga nɨmba ndi nɨma sakwat njambɨ kɨgɨnda kɨvak kat kai walaa God kat mɨna ngambulɨgandi. Ferisi walɨnja mbaapma nɨmba ndino wupma yilɨgandi. Mɨna mbaapma lɨga nɨmba kai. Ndi kɨgɨnda ngu njɨmbla njɨmbla kɨlɨgandi waa wandi mala Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ndu taagwa kat kla njɨmbla nɨma kɨgɨnda kɨvak kat kai waigandi? E? Kɨgiyandi luwa. Nɨma kɨgɨnda. ");
INSERT INTO ian_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngɨni yaiga njɨmbla taagwa kla nyan kat kwutaa kalindi mala ndi nɨma vak yelavɨka kɨgɨnda kɨvak kat kai waigandi waa Jisas walaa ");
INSERT INTO ian_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ndi kat pagwula la nyaangɨtmba wandɨ. Tamba ngɨlɨkna waavwi la nyan mandɨt kupi waavwi klalaa tamba waavwi kat kwunapmak ana ngɨlɨkiyandɨ kupi waavwi. Ngɨlɨtaa tavandeyan mandɨp mandɨp vaandɨ kwaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tamba sɨmbɨmba kwutnja awmba kɨta nyan kupi nɨma ngu ana kalɨkiyandɨ. kalɨtndeyan nguna mbiyak wokendɨ mala tamba sɨmbɨ ngɨlɨkiyandɨ. Ngɨlɨtɨ, ngu kɨpma yindɨ, sɨmbɨ kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kupi nɨma ngu kupi sɨmbɨmba mɨna kalɨtɨgandi. Nɨna ngepmana vatna. ");
INSERT INTO ian_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kɨta nyan tamba nɨma ngu kɨlaa kupi nɨma ngu kɨvak kat ana waigandɨ. Kupi nɨma ngu kɨvak kat kai waigandɨ. Tamba nɨma ngu apma ngua waa waigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Njɨvwa lapman nandinya Jisasagwi ndɨna mbaapma nɨmbo yuwi sɨk kwalɨga kava yindi. Yiga ndɨna mbaapma nɨmba sɨk klalaa taambamba lɨgagagiga kwutɨndi, sɨmbɨ ndandɨ, kɨndi. ");
INSERT INTO ian_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nat Ferisi kɨlɨnja vak vɨlaa wandi. Njɨvwa lapman nandinyana njambia kat kai walaa manda kat wupma kɨlɨgangwuk waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Wandi mala Jisas ndi kat wandɨ. Nɨna tamba njambwi la nyan Devit yinda vak ana wuka lɨgangwuk? Tamba pɨlɨwutndi. Ana vɨga lɨgangwuk? Ndɨ wundɨ kat tɨga Godna ngay wuleilaa God kat kwunapmak kat kwilɨnja bret-nao kɨndɨ. Kɨlaa ndɨnogwi lɨga nɨmba kat kwindɨ, kɨndi. God kat kwunatɨga nɨmba mɨna kɨlɨndi. Kwo nɨmba ana kɨlɨndi. Njambia lɨgandɨ. ndi njambia kat kai walaa kɨlɨndi. Ndi God kat twunata nɨmba ana ndi. ");
INSERT INTO ian_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wun Godna vak sɨmogwi lɨga nyan wun. Wun njɨvwa lapman nandinya kat vɨga lɨgowun. Wan nandinya wun kat ana vɨga lɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nat njɨvwa lapman nandinya yisolaa lɨnja ngay wuleilaa Jisas ndi kat nyaangɨt mbutɨndɨ. Wan ngaymba ta nyana taamba mak kaalandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ferisiagwi tamba Moses kwiya nyangɨt sɨmogwi la nɨmbo Jisas kat vɨga lɨndi. Ndɨ kat kwunakiyandɨ? E? Ana kwunakiyandɨ? Waa yelavɨka lɨndi. Ndɨ kat njɨvwa kwuka kwunaka nɨna ngepmana njambia kat kai wandeyan ndɨ kat kotmak kaligiyanɨn waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ndɨna maawupmba yelavɨka lɨnja vak Jisas ndɨ tamba vɨga lɨndɨ. Vɨga lɨga taamba mak kaala nyan kat yagwa kumba yaa alɨ waa wandɨ. Wandɨ mala laataa yandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","10","Jisas Ferisi kat wandɨ. Mbambala njɨvwa lapman nandinya apma vat yiweyan wovuna? Kavle vat mɨna yilu? Kɨta nyan kat kwunapmat yiweyan wovuna? Ndɨ kat kavle vat mɨna yilu? Waa ndi kat wagalalaa wan nyan kat wandɨ. Mɨna taamba sate mɨla waa wandɨ mala satendɨ. satendɨ mala ndɨna taamba kwo lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ferisi ndɨ kat vɨlaa walaa lɨndi. Jisas kat anda vapmba kavle yigiyanɨn waa awat sowat ngmambuga lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jisas God kat ngambuvat nduwiat wokendɨ. Ngan kɨta God kat ngambuga tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nya wokendɨ mala ndɨna mbaapma nɨmba kat yagwa wandɨ, yandi. Ndina nat nɨmba kat mandɨt sɨ kwindɨ. Ngwuk aposel ngwuk waa wandɨ. Wanda nɨmbana sakwat tamba vɨli liyeli vɨlɨlɨk nɨmba. ");
INSERT INTO ian_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wan nɨmbana sɨ kɨngiyan. Nat nyan Saimon. Jisas ndɨ kat mandɨt sɨ wandɨ. Mɨn Pita mɨn waa wandɨ. Nat nyan Pitana yakwa nyan Endru. Nat vɨlɨlɨk palɨ Jemsogwi Jono. Nat nyan Filip. Nat nyan Batolomyu. ");
INSERT INTO ian_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nat nyan Matyu. Nat nyan Tomas. Nat nyan nat kɨta Jems. Ndɨ Alfiasna nyan. Nat nyan nat kita Saimon. Ndɨ ngepma ngepma yiga nat nɨmba nɨna kɨpma kat yalaa vɨga lɨnjangat kai waa ngambundɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nat nyan Judas. Ndɨna nyaek Jems. Nat nyan Judas Iskeriot. Wan nyan ngɨni Jisas kat vatnyavat kamwin kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisasagwi ndɨna mbaapma nɨmbo nduwimba lɨga ndaindi. ndailaa savagu kɨpma la kavamba lɨndi. Jisasna mbaapma nɨmba nɨma sakwat tɨndi. Kava kavamba lɨga nɨmba ndɨ kat vɨvat yandi. Nat nɨmba Judiamba lɨga yandi. Nat nɨmba yelogwen kat ta nɨmba ndi kat kwunatndangat yandi. ");
INSERT INTO ian_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kavle waagan tavila la nɨmba kat Jisas kwunatndɨ, kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndɨ kat nɨma sakwat nɨmba ndɨna mbangɨ taamba taagavat wandi. Taamba taagandi mala ndɨna kwondu ndi kat yalaa kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas laataa ndɨna mbaapma nɨmba kat wandɨ. ngwuk kwanda kwanda lapman tɨngweyan apma vatna. God kwindeya apma nda aywaa klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbambala wundɨ kat tɨngweyan apma vatna. ngɨni ngwula yaak taakiyandɨ. Mbambala nɨma vak yelavɨka nglangweyan apma vatna. ngɨni kasegiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wun God wandɨ, yaa nyan wun. Wuna nyaangɨt mbukngwuk mala wukna nɨmba ngwuk kat kai waalaa njɨka ngwutna sɨ viyesendalaa kɨklinjeyan apma vatna. ");
INSERT INTO ian_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ngwuk kat kavle vat yinjeya nandinya ngwuk solat asɨ ngwula. Solat sɨga ngɨni nyinangwutwokelaa apma klaigangwuk waa yelavɨk ngwula. Ngwuk kat kavle vat yigiya nɨmbana tamba la walanga ngwak tamba la profet kat wupma kavle vat yindi. ");
INSERT INTO ian_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngwuk nɨma sakwat nda lɨga nɨmba apma vat ana ndɨ. Mbambala ngwutna wenga tamba klangwuk. Ngɨni kai. ");
INSERT INTO ian_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yaat taat tɨga nɨmba ngwuk apma vat ana ndɨ. Ngɨni wundɨ kat tɨgiyangwuk. Mbambala kaselɨga nɨmba ngwuk apma vat ana ndɨ. Ngɨni nɨma vat yelavɨka nglagiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nat nɨmba ngwutna sɨ kwutaa katsonjeyan apma vat ana ndɨ. Ngwutna sɨ katso lɨga nɨmbana tamba la walanga ngwak tamba la kavle profetna sɨ kwutaa katsondi. God waa nyaangɨt mbutɨga profetna sɨ ana katsondi. ");
INSERT INTO ian_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngwuk wuna mbaapma nɨmba awuk ngwula. Ngwutna maama nɨmba kat ndi kat kwunapmak nɨma maawut yelavɨka alɨ ngwula. Ngwuk kat kai walɨga nɨmba ndi kat apma vat ay ngwula. ");
INSERT INTO ian_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ngwutna sɨ kwutaa viyesenda lɨga nɨmba kat ndina sɨ kwutaa katso ngwula. Ngwuk kat kavle vat yilɨga nɨmba ndi kat tɨga God kat wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kɨta nyan ngwuk kat kɨta naangɨ kɨpmwimba viyandeyan nat naangɨ agwi. Kɨta nyan ngwutna kol siot klavat wandeyan agwi ngwula. Kol siot kwilaa siot nɨmbun agwi. ");
INSERT INTO ian_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ngwuk kat wagala lɨga nɨmba ndi kat agwi ngwula. Kɨta nyan ngwutnaqmba klandeyan ngɨni wun kat awat agwi waa ke waa. ");
INSERT INTO ian_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nat nɨmba wun kat kan vat yinjeyan apma vatna waa yelavɨkngweyan kan yelavɨtɨngwa vak nat nɨmba kat ay ngwula. ");
INSERT INTO ian_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ngwuk kat woviyaguga tɨga nɨmba ndi kat mɨna nɨma vak yelavɨka tɨngweyan nɨma vak ana ndɨ. Kavle nɨmba ndino wupma yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ngwuk kat apma vat yilɨga nɨmba ndi kat mɨna apma vat yingweyan nɨma vat ana ndɨ. Kavle nɨmba ndino wupma yilɨngandi. ");
INSERT INTO ian_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ngwuk kat ngɨni awat kwigiya nɨmba ndi kat mɨna kwingweyan nɨma vat ana ndɨ. Kavle nɨmba ndino wupma yilɨgandi. Kwilaa ngɨni awat kwinja sakwat klalɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kavle nɨmba ya vak vla ngwuk key yiga. Ngwuk mandɨt apma vak yiga yetɨ ngwula. Ngwuk ngwula maama nɨmba kat kwunapmat nɨma maawut yelavɨka alɨ ngwula. Ndi kat apma vat ay ngwula. Ngɨni awat ana klaiganɨn waa yelavɨtaa agwi ngwula. Wupma yingweyan ngɨni Godnanamba apma wenga kaligangwuk. God ndɨ kat sɨvu kɨlapman nɨmba ndi kat apma vat yilɨgandɨ. Nɨn nɨna mbangɨ mɨna kwunakiyanɨn waa walɨga nɨmba God ndi kat apma vat yilɨngandɨ. Ngwuk wupma kai. Ngwuk njambwi nyan Godna nyangu ngwuk. Ngi kat tɨga God ndɨ kat kai walɨga nɨmba kat kwunatɨnda vla ngwuk kwunak ngwula. ");
INSERT INTO ian_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ngwutna nyaek ya vak vla ngwuk apma vak ay ngwula nat nɨmba kat. ");
INSERT INTO ian_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nat nɨmba kat vɨlaa ndi kavle vat yindi waa walapman yingweyan God ngwuk kat vɨlaa kavle vat yindi waa ana waigandɨ. Nat nɨmba kat vɨlaa ndi kavle nɨmba ndi waa walapman yingweyan God ngwuk kat vɨlaa ndi kavle nɨmba ndi waa ana waigandɨ. nat nɨmba kavle vat yiga yetɨlɨnja vak kat yelavɨtapman yingweyan God kavle vat yiga yetɨlɨngwa vak kat yelavɨtapman yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nat nɨmba kat kwingweyan God ngwuk kat apma wenga kwigiyandɨ. Kɨta nyan yuwi sɨk kwivat yindeyan nɨma sakwat tulaa yiyalɨndɨ, kɨndɨkɨ ndaindɨ, nat kuvuk kwutaa naangandɨ maa taataa nat yuwi sɨk ndalɨndɨ, salatndɨ. God wupma kwilɨgandɨ. Ngwuk nat nɨmba kat nɨma sakwat kwingweyan God ngɨni ngwuk kat nɨma sakwat kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nat mɨni vɨlapman yila nyan nat mɨni vɨlapman yila nyan kat taamba kwutaa yambɨ ana alɨpsɨga vɨsɨmogwigiyandɨ. Vɨsɨmogwivat kalindeyan vɨli apa waangumba ndaigiyambɨt. ");
INSERT INTO ian_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul boi ndɨna tisa kat ana kwulatɨgandɨ. Wan skul boi skul kwulataa ndɨna nambu tisana nambu lɨga vla wupma lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ngwutna kɨta mbaapma lɨga kɨta nyana mɨnimba lɨga mat kɨsɨk vɨga lɨgangwuk. Ngwutna mɨnimba lɨga nɨma kɨsɨk ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ngwutna kɨta mbaapma nyan kat walɨgangwuk. Mbaapma nyan mɨna mɨnimba lɨga kɨsɨk klalaa yaagigiyowun. Wupma waga ngwutna mɨnimba lɨga nɨma kɨsɨk ana vɨga lɨgangwuk. Wan yingwa vak ana nglaatndɨ. Ngwutna mɨnimba lɨga nɨma kɨsɨk klalaa yaagingweyan apma vak vɨga ngwula kɨta mbaapma nyana mɨnimba lɨga mat kɨsɨk klalaa yaagigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Apma mi kavle mi sɨk ana kwalɨgandɨ. Kavle mi apma mi sɨk ana kwalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mina sɨk vɨlaa kan apma mi? E? Kavle mi? Waa yelavɨka lɨgandi. Kavle nɨmbio lɨga yamboy apma mi sɨk ana kwalɨgandɨ. Apma lɨsɨk yilɨga sɨk kavle mimba ana kwalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ndinyangu ndino wupma lɨgandɨ. Kɨta nyan apma maawupmba yetɨgiyaa nyan apma njɨvwa kwukiyandɨ. Nat kɨta nyan kavle maawupmba yetɨgiyaa nyan ndɨ kavle njɨvwa kwukiyandɨ. Nɨna maawupmba yelavɨtaa vak vla nyaangɨt mbutɨganɨn. ");
INSERT INTO ian_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Manda kat wuna kwundi wutapman tɨga wun kat njambwi nyan njambwi nyan waa walɨgangwuk. Kan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kɨta nyan wun kat yalaa wuna nyaangɨt wutndeyan wan nyan apma nyana. Ndɨ ngay kwuta nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nat kɨta nyan ngay kwupmat yindɨ. Nɨmamba waangu vaa klanda kalilaa kwaalɨk tawndɨ. Sambiyangu mbalɨndɨ, ana yuvut yindɨ ngay. Tagula vat tɨndɨ. Wuna nyaangɨt wutɨga nyan kɨngi ngay tagula ngay kwuta nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nat kɨta nyan kwaalɨk tawlapman kwo kɨpmamba ngay kwutndɨ. Sambiyangu yandɨ, ngumbi kalindɨ, pɨtsondɨ, wan ngay kavle yindɨ. Wuna nyaangɨt wutapman nyan kɨngi kavle ya ngay kwuta nyan vla lɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas nyaangɨt ndi kat mbutaa wan kava kwagalalaa Kapaneamat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wan kavamba soldiana njambwi nyan kɨta lɨndɨ. Ndɨ soldia ndumi tambanat vɨga lɨndɨ. Ndɨna njɨvwa kwuta nyan yelogwen kat tɨga kiya mɨna lɨndɨ. Njambwi soldia woviyaguga tɨnda nyana. ");
INSERT INTO ian_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jisas yandɨ, wutaa Judana njambwi nɨmba kat wandɨ mala ndi Jisas kat wagalavat yindi. Njambwi soldiana njɨvwa kwuta nyan kat kwunap mɨla waa wavat yindi. ");
INSERT INTO ian_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jisas ta kava yiga ndɨ kat yiga wagalaga wandi. Wan njambwi soldia apma nyana. ");
INSERT INTO ian_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nɨn Juda nɨna nɨmba kat kwunatɨgandɨ. Kan ngepmamba yisolaa lɨna ngay ndɨnai kwukna waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wandi maa Jisas ndina kwupmba yindɨ. Ngay ngwaymba lɨndi. Lɨvlamba ana lɨndi, njambwi soldia ndɨna ngaymba la nɨmba kat wandɨ maa Jisas kat yindi. Yilaa wandi. Soldiana njambwi nyan mɨn kat kupma wandɨ. Njambwi nyan nɨma njɨvwa ke kwuka. Apma nyan ana wun. Ke yaa wuna kavle ngay. ");
INSERT INTO ian_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mɨn kat vɨvak kat vaaka lɨwun. Wun mat nyan wun. Nyaangɨt wamɨn mala njɨvwa kwutɨga nyan apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wuna njambwi nɨmba waa nyaangɨt wutɨgowun. Wuna soldia wuna nyaangɨt wutɨgandi. Ndina kɨta nyan kat ay wowun mala yigiyandɨ. Ndina nat nyan kat yagwa wowunj mala yigiyandɨ. Yelogwen kwagalandɨ kwo lɨgiyamɨn waa wameyan ndɨ kwo lɨgiyandɨ. Vɨlɨgowun waa wandɨ njambwi soldia waa ndɨna ngaymba la nɨmba mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas wutaa ngɨpaliga ndalaa ndɨna kwupmba la nɨma sakwat nɨmba kat lungwamataa wandɨ. Wan njambwi soldia maawupmba yelavɨtɨnda vat apma nglage vatna. Judana ngepma ngepma kɨngi vat tak ana vɨlɨwun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jisas kat yaa nɨmba lungwamataa yindi. Yilaa ngay wuleilaa njambwi soldiana njɨvwa kwuta nyan kat vɨndi. Kwo lɨndɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ngɨni Jisas Nen walɨnja ngepmat yindɨ. Kapma ana yindɨ. Ndɨna mbaapma nɨmba, nat nɨma sakwat nɨmbagwi yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngepma tɨvwina suwi ngwaymba tɨga kiya nyan kat walalaa kalindi, vɨndi. Kiya nyana nyɨme tɨlɨ. Lɨ talagwa. Lɨla nyan kɨta nyana. Kiya nyan. Kan ngepmana nɨma sakwat nɨmba ndino lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Njambwi nyan lɨ kat vɨlaa nɨma maawut yelavɨka wandɨ. Ke ngla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lɨ kat walaa yiga njambamba taamba taagandɨ, walɨga nɨmba tolalɨndi. Taamba taagalaa kiya nyan kat wandɨ. Kwandɨ nyan laap mɨla waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","laatndɨ. Laataa nyaangɨt ngambundɨ, ndɨ kat kwutaa nyɨmeat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Va nɨmba ngɨpaliga ndalaa vaaka lɨndi. Ndi Godna sɨ kwutaa katsoga wandi. nɨna ngepmamba nɨma profet laatndɨ. God nɨn kat kwunapmak kat wandɨ maa yandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisas ya vak va nɨmba yiga Judiagwi nat kavamba la nɨmba kat mbutseli mbutsela mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jona kwupmba la nɨmba ndino mbutɨndi Jon kat. ");
INSERT INTO ian_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wutaa Jon ndɨna mbaapmamba la vɨlɨlɨk palɨ kat wandɨ. Jisas kat yiga wagala mbɨla. Mɨn God wandɨ, yaa nyan mɨn? E? Kai? Nat nyan kat kawiga vɨga lɨgat? E? Kai? Waa wagala mbɨla waa Jon wandɨ maa yimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yilaa Jisas kat wagalambɨt. Ngu yagu lɨga Jon an kat ay wandɨ maa mɨn kat yaa. Mɨn God wandɨ, yaa nyan mɨn? E? Kai? Nat nyan kat kawiga vɨga lɨgat E Kai? Waa Jisas kat wagala waa Jon an kat wandɨ maa yaa waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Walaa tɨmbɨk. Tɨlɨmbɨt mala Jisas nɨma sakwat yelogwen kat ta nɨmba kat kwunatɨnd. Mɨni vɨlapman nɨmba kat nɨma sakwat kwunatɨndɨ, vɨlɨmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Vɨmbɨt mala Jisas mbɨk kat wandɨ. Ay mbɨla. Yiga vɨga wupmba vak Jon kat ambup mbɨla. Mɨni vɨlapman nɨmba kat kwunatndɨ mala vɨlɨgandi. Man kɨvɨ wakna nɨmba kat Jisas kwunatndɨ mala apma vat veilɨgandi. Kawia kɨla nɨmba kat Jisas kwunatndɨ mala kwo apma vat yetɨɨgandi. Waan wutapman nɨmba kat Jisas kwunatndɨ mala waan wutɨgandi. Kiya nɨmba kat Jisas kwunatndɨ mala laatɨgandi. Kwo nɨmba kat Jisas wan apma nyaangɨt mbutɨgandɨ waa yiga Jon kat ambup mɨla. ");
INSERT INTO ian_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kɨta nyan kwutuwa njɨvwa vɨlaa ndɨ God wandɨ, yaa nyana waa yelavɨtndeyan ndɨ apma maawut tɨga nyana. Wan nyan ngɨni ana kavle yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisas wandɨ mala Jon wandɨ, yambɨt vɨlɨlɨk palɨ lungwamataa yimbɨt. Yimbɨt maa Jisas wumba lɨga nɨma sakwat nɨmba kat vɨlaa Jona sɨ katsoga wandɨ. Tamba ndinyangu lapman kwo kavat Jon kat vɨvat yingwuk. Tamba wan kava yingwuk, Jon mwuk viyalɨndɨ, yuvut yilɨga suwa vla lɨga nyana waa yelavɨka yingwuk? Ndɨ wupma ana lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tamba yingwa njɨmbla Jon ndɨ nɨma sakwat ndo lɨga apma waavwi kwusolɨga nyana waa yelavɨka yingwuk? Ndɨ wupma ana lɨndɨ. Nɨma sakwat ndo lɨga apma waavwi kwusolɨga nɨmba ndi njambwi kingna ngaymba yetɨlɨgandi. Ndinyangu lapman kwo kavamba ana yetɨlɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tamba yingwa njɨmbla Jon ndɨ God waa nyaangɨt mbutɨga profetna waa yelavɨka yingwuk? Wupma yelavɨkngweyan wovuna. Wupma lɨndɨ Jon. Ndɨ nat profetna njambwia Jon. ");
INSERT INTO ian_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","God Jon kat yelavtaa wanda nyaangɨt tamba la profet pɨlɨwutndɨ. Awuk ngwula. Wuna nyaangɨt mbutɨga nyan tat yigiyandɨ. Mɨn ngɨni yigiyamɨn. Yɨmeya yambɨ ndɨ kwunakiyandɨ waa God wandɨ waa tamba la profet pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kan kɨpmamba ngu yagu lɨga Jon ndɨ kat kwulaka lɨga nyan ana lɨgandɨ. God vɨga lɨga nɨmba ndi kapma vat tɨgandi. Ndina mat nyan Jon kat kwalakiyandɨ. Ndi kapma vat tɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jisas mbuta nyaangɨt wuta nɨmba tat Jon ndi kat ngu yagundɨ. God waa nyaangɨt mbutɨgandɨ waa wandi maa ndi kat ngu yagundɨ. Ngi kat tɨga Jisas mbuta nyaangɨt wutaa apma nyaangɨtna ngiyambak wama waa wandi. Ndina nat nɨmba takis sanya klalɨga nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nat nɨmba Ferisiagwi Moses kwiya nyaangɨt sɨmogwi la nɨmbo ndi wutaa kai wandi. Tat Jon mbukna God waa nyaangɨt wupmak kat kai wandi. Jon ndi kat ana ngu yagundɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas wundi kavle nɨmba kat vɨlaa wandɨ. Yiga yetɨlɨngwa vak vla yetɨlɨga nɨmba ndi kat angamak waigowun. Ndi anda nda vla lɨgandi. Ngwuk kat waigowun. ");
INSERT INTO ian_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ndi kwandɨ nyangu vla lɨgandi. Wundi kwandɨ nyangu nɨndɨ ngepmamba ndaa lɨga awat sowat walɨgandi. Waavi walɨnɨn, ndi wan nɨmba mbangu ana veindi waa awat sowat walɨndi. Nat njɨmbla walɨndi. nglalɨna vak vla ndi wan nɨmba ana nglaa lɨndi. Yetɨlɨna vak vla yetɨlapman manda kat apma yetɨlɨgandi waa awat sowat walɨgandi. Wundi kwandɨ nyangu vla tɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tak ngu yagula Jon yalaa kɨgɨnda nɨma ngu kɨvak kat kai wandɨ, ndɨ kavle waagan tavila la nyana waa ndɨ kat wangwuk. ");
INSERT INTO ian_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wun God wandɨ, yaa nyan wun. Wun kɨgɨnda kɨga nɨma ngu kɨlɨwun. Wun kat vɨlaa walɨgangwuk. Ndɨ nɨma sanya klalɨga nɨmbagwi kavle nɨmbonala yetɨlɨgandɨ. Kavle vatna waa wun kat wangwuk. ");
INSERT INTO ian_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nat kuvuk nɨmba mɨna Jon yeta vak vɨlaa yetɨluwa vak vɨlaa apma vatna waa wandi. Wundi nɨmba apma maawut yelavɨka yeta nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferisina kɨta nyan Jisasogwio kɨta vak kɨgɨnda kɨvat Jisas kat ndɨna ngay wuleilaa kɨgɨnda kɨvat ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tɨga lɨga kavle vapmba yiga yeta taagwa Jisas Saimon ngaymba lɨnda vat wutaa yalɨ. kambapmba kwutnja awmba lɨga sanda kwutaa yalɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisasna man ngandɨmba kwali mamba sɨlaa nglalɨlɨ. Nglalɨlɨ, lɨla mɨni ngu ndɨna mamba ndandɨ. Lɨla sɨvla nɨmbɨ yuwi kwutaa ndɨna mamba la ngu nyangatɨ. Nyangataa ndɨna man kwutaa wusɨtaa sanda mamba taagalɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jisas kat wuna ngaymba nao yaa agɨ waa wanda Ferisi vɨlaa maawupmba yelavɨtndɨ. Jisas Godnanamba wutaa mbutɨga profet ana ndɨ. Profet tɨgendan ndɨna mamba taagala taagwana kavle vak vɨgendɨ. Ana vɨga lɨgandɨ waa maawupmba yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas Saimona maawupmba tɨga vak vɨlaa wandɨ. Saimon mɨn kat nyaangɨtno lɨgowun waa wandɨ mala Saimon wandɨ. Njambwi nyan ambuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas ndɨ kat wapuseput mbutɨndɨ. Vɨlɨlɨk palɨ dinau kɨta nyananamba klambɨt. Nat nyanadinau l00 dol klandɨ. Nat nyana dinau 10 dola klandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tɨga lɨga awat kwimbeya sanya kat vɨlevilaa lɨmbɨt. Dinau kwiya nyan wandɨ. Wun kai wowun dinau kat. Ke kwimba waa wandɨ. Saimon mɨn angamak yelavɨka lɨgamɨn. Anda nyan ke kwiga waa nyan kat nɨmamba woviyagluga lɨgiyandɨ waa wandɨ maa Jisas wandɨ. Ngiyambak wama waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nɨma dinau ta nyan ndɨ nɨmamba woviyaguga lɨgiyandɨ. Mat dinau ta nyan ndɨ samat woviyaguga lɨgiyandɨ waa wandɨ maa Jisas wandɨ. Ngiyambak awama waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisas wat taagwa kat vɨga Saimon kat wandɨ. Wat taagwa avɨ mɨla. Mɨna ngay wuleiwun mala nɨna ngepmana vapmba wuna man njangiweya ngu wun kat ana kwimɨn. Lɨ wupma kai. Lɨ lɨla mɨni ngumba njangilaa lɨla nɨmbɨ yuwimba nyangatɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mɨna ngay wuleiwun mala wun kat apma nandinya waga wuna taamba ana kwupmɨn. Lɨ wupma kai. Wuleiwun mala lɨ nɨma sakwat njambɨ wuna man kwutaa wusɨtɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mɨna ngay wuleiwun mala nɨna ngepmana vak kat kai walaa wuna nɨmbɨ yuwimba sanda ana taagamɨn. Lɨ wupma kai. Nɨma sakwat sanyo lɨga sanda wuna mamba taagalɨ. ");
INSERT INTO ian_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kapma kapma yilɨmba vatna angwa mɨn kat mbukiyowun. Lɨla nɨma sakwat kavle vat sɨlɨmbwiwun mala wun kat nɨmamba woviyanguga lɨgalɨ. Kɨta nyana kavle vat sakwat ana ndɨ sɨlɨmbwiwun mala wun kat samat woviyaguga tɨgiyandɨ waa walaa. ");
INSERT INTO ian_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jisas wat taagwa kat wandɨ. Kavle vat yiga yetɨlɨnya vak tamba sɨsɨmbwigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wandɨ mala ndɨnogwinala ka nɨmba ndina maawupmba yelavɨtndi. Ndɨ anda nyana apma waa. Ndɨ kavle vat sɨlɨmbwilɨgandɨ? Waa maawupmba yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas wat taagwa kat wandɨ. Njambwi nyan tuwa vak yelavɨtɨnyangat nyina kavle vat tamba sɨlɨmbwiwun. Yiga apma vat yetɨgiyanyɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jisas ngepma ngepma yilɨndɨ. God ndinyangu kat kwunapmak wanda apma nyaangɨt yiga mbutɨndɨ. Ndɨna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nɨmba ndɨnogwinala yilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nat taagwa ndino yilɨndi. Nat taagwa tamba yelogwen kat tɨndi. Nat taagwa tamba kavle waagan tavila la ndi taagwa. Jisas ndi kat tamba kwunatndɨ. Nat taagwana sɨ maria. Lɨla angwa ngepma Magdala. Tamba kavle waagan sɨla vɨli mɨna lɨ kat tavilaa lɨndi, Jisas tamba ndi kat savɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nat taagwana sɨ Joana. Lɨla lana sɨ Susa. Ndɨ njambwi nyan Herotna njɨvwa kwuta nyana. Nat taagwana sɨ Susana. Nat taagwa ndino lɨndi. Kɨndi lagwa Jisas kat sanya kwiga kɨgɨnda kwiga kwilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngepma ngepmamba la nɨmba Jisas kat wupmak yisolaa lɨndi maa ndi kat pagwula la nyaangɨpmba mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mbuka wandɨ. Yuwi sɨk yaagi lɨga nyan yuwi sɨk yaagivat yindɨ. Yaagiga yiga nat sɨk ava yambɨmba ndandɨ. Ndandɨ mala waavi yalaa nat sɨk kɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nat sɨk kambat tɨga kava tagu kɨpma kuvut tɨga kavamba ndandɨ. ndalaa waatndɨ. Ndɨna njingwut samat ndailaa kambapmba sɨlaa kiyandɨ. Njingwut ngu lɨga kava ana ndaindɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nat sɨk kavle yuwi sɨk tɨga kavamba ndandɨ. Kavle yuwi sɨknonala waatndɨ. Apma yuwi sɨk kavle yuwinana njingwupmba tamata kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nat yuwi sɨk apma kɨpmamba ndandɨ. Ndalaa wataa nɨman yindɨ. Nɨma ava yindɨ. Yilaa ava kɨta sɨk ndumi tambanat kwandɨ waa pagwula la nyaangɨt mbutaa wundi nɨmba kat wandɨ. Apma maawutno lɨga nyan ndɨ kan nyaangɨtna angwa yelavɨkiyandɨ waa wandɨ mala ndɨna mbaapma nɨmba ndɨ kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kan nyaangɨtna angwa nɨn kat sɨmaga. Nɨn ana yelavɨka lɨganɨn waa wandi maa Jisas ndi kat sɨmagaga wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","God ndinyangu kat kwunatɨga vatna angwa ngwuk kat swɨmagagiywoun. Nat nɨmba kat ana sɨmagagiyowun. Ndi kat pagwula la nyaangɨt mɨna waigowun. Ndi maawut yelavɨtapman kwo mɨni mɨna vɨgiyandi. Maawut yelavɨtapman kwo waan mɨna wukiyandi. ");
INSERT INTO ian_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tak mbukwa nyaangɨtna angwa kingiyan. Yaagilɨnda yuwi sɨk God waa nyaangɨtna. ");
INSERT INTO ian_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ava yambɨmba lɨga kɨpma ndɨ ndinyangu vla lɨgandɨ. Wundi nɨmba ndi God waa nyaangɨt wutndi. Wutaa maawupmba yelavɨtndi. Yelavɨtndi maa Seten yalaa ndina maawupmba yelavɨka lɨnja vak kwutaa yaagilɨgandɨ. Apma kupi maawupmba yelavɨka tɨlandi walaa kwutaa yaagilɨndɨ Seten. ");
INSERT INTO ian_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tagu kambapmba kuvuk kɨpma tɨga kava ndinyangu vla lɨgandɨ. Ndi Godna nyaangɨt wutaa apma nyaangɨtna waa yelavɨka lɨgandi. Tɨga lɨga nat nɨmba yaa yelavɨtɨngwa vak kavle vatna waa wandi maa kwagalalɨgandi. Ndi tambɨ njingwut tɨga yuwi vla lɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kavle yuwi sɨk tɨlɨga kɨpma ndinyangu vla lɨgandɨ. Ndi Godna nyaangɨt wutɨgandi. Tɨga lɨga kɨpmana nda kɨpmana vak mɨna yelavɨka tɨga God waa nyaangɨt kwagala lɨgandi. Ndi God waa vapmba ana yiga yetɨlɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Apma kɨpma ndinyangu vla lɨgandɨ. Ndi apma maawutno lɨga nɨmba. Ndi wutaa maawupmba yelavɨka lɨga God waa vapmba njɨmbla njɨmbla apma vapmba yiga yetɨlɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kɨta nyan tuway klalaa ya sagɨlalaa awmba ana naangalɨgandɨ. Njamba vɨlumba taagalɨgandɨ. Kwutaa katsolaa yindeya yambɨ kembandɨ, vɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mbambala pagwuga lɨga nyaangɨt ngɨni aywaa wukiyandi. Mbambala pagwuga lɨga nda ngɨni aywaa vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngwuk mbutuwa nyaangɨt yigumba wuka yelavɨk ngwula. Apma maawutno lɨga nyan ndɨ yigumba wuka nyaangɨtna angwa yelavɨka lɨgiyandɨ. Apma maawut tapman tɨgiya nyan ndɨ kwo wuka kwagalagiyandɨ. Ndɨna maawupmba mandɨt mandɨt yelavɨka lɨgiyandɨ. Wun apma maawupmba yelavɨka tigowun waa tɨgiyandɨ. Ndɨ wupma kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nɨma sakwat nɨmba yisolaa lɨndi maa Jisasna nyɨmeagwi ndɨna yakwa nɨmba ndɨ kat vɨvat yandi. Ndɨ kat vɨvat wuleinjeya yambɨ kai. Nɨma sakwat nɨmba. ");
INSERT INTO ian_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ngi kat tɨga Jisasna ngwaymba lɨga nɨmba ndɨ kat mbutndi. Mɨna nyɨmeagwi yakwa nɨmbo alagumba lɨgandi. Mɨn kat vɨvat wandi waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mbutndi mala Jisas ndi kat wandɨ. Godna nyaangɨt wutaa God waa vapmba yiga yetɨlɨga nɨmba wuna nyɨmeagwi yakwa nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngɨni nat nandinya ndɨna mbaapma nɨmbonala bot kundɨ. Valɨgegat waa wandɨ mala bot sɨvasagulaa valɨgendi. ");
INSERT INTO ian_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Valɨgelaa yiga Jisas bopmba sɨndu kwandɨ. Nɨma mwuk pali kwutɨ, bot ngu ngwandɨlɨndɨ. Bot lumaka ndaivat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tɨga lɨga Jisas kat sɨvulɨlaa wandi. Njambwi nyan njambwi nyan nɨn kavle yiveiganɨn wandi mala Jisas laataa mwuknagwi pali kat kai wandɨ, kiyak wandɨ. Ngu savagu lɨndɨ. Mwuk kai. ");
INSERT INTO ian_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jisas ndi kat wandɨ. Ngwuk manda kat vaatɨgangwuk. Njambwi nyanat tuwa vak ana vɨga lɨgangwuk waa wandɨ Jisas. Ndi vaaka lɨga mandɨp mandɨp yelavɨka awat sowat walɨndi. Wan nyan angamat tɨga nyana. Mwukno palio ndɨnai walɨga vak wuka lɨgandɨ waa awat sowat walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sak valɨgelaa Gegesa walɨnja ngepma kawindi. Gegesa Galili nat naangamba la ngepma. ");
INSERT INTO ian_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kawilaa valilaa lɨndɨ. Wan ngepmana kɨta nyan ndi kat yaa vɨndɨ. Ndɨ kavle waagan tavila la nyana. Ndɨ sɨp mɨna lɨndɨ. Ngaymba ana tɨlɨndɨ. Kiya nɨmba waangumba taagalɨnja kavamba yetɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jisas kat vɨlɨɨ ndɨna man ngandɨmba ndalaa walega nɨma kwundimba wandɨ. Wun kat angamak yivat yamɨn. Mɨn njambwi nyan Godna nyan mɨn. Wun kat kavle vat ke yiga waa walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tak Jisas kavle waagan kat savɨlɨvat wandɨ mala wan nyan wupma wandɨ. Tak kan ngepma nɨmba nɨma sakwat njambɨ ndɨ kat kwutaa ndɨna man taamba senmba ngindi. Kavle waagan ndɨ kat tavindɨ maa sen tɨtaa ndinyangu lapman kwo kavat yilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mɨna sɨ angamak waigowun waa Jisas wandɨ maa wandɨ. Wuna sɨ Nɨma Sakwat Nɨmba waa wandɨ. Ndɨ kat kavle waagan nɨma sakwat ndɨ kat tavila lɨndi. Ngi kat tɨga wandɨ wuna sɨ Nɨma Sakwat Nɨmba. ");
INSERT INTO ian_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nɨna angwa ngepma nɨn kat ke waga yinangat waa wagalaga wandi waagan Jisas kat. ");
INSERT INTO ian_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Angwi lɨga nduwimba lɨga mbak ndi kat yiga taavi waa awa waa wagalandi mala ay ngwula wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wandɨ mala wan nyan kat kwagalalaa mbapmba yiga tavindi. Tavindi maa mbak pɨlɨga ndaiga nguapa yindi. Yilaa ngu kɨlaa kiyalaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mbak kat bɨga la nɨmba vɨlaa vaaka pɨlɨga ngepma apa wuleilaa ngepma la nɨmba kat mbutndi. Ngepma yilaa kava kava yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngepmamba la nɨmba wutaa Jisas kwuta vak vɨvat yandi. Yalaa tak kavle waagan tavila la nyan Jisasna man ngandɨmba ndaalɨndɨ, vɨndi. Waavwi kwusolaa lɨndɨ, vɨndi. Ndɨna maawut apma vat sɨka lɨndɨ, vɨlaa vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jisas waagan kat savɨlɨnda vat va nɨmba ngepmamba yaa nɨmba kat mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tɨga lɨga Gegesana ngepma ngepmamba la nɨmba Jisas ndi kat kwagalalaa nat ngepmat yindangat wandi. Ndi vaaka lɨga nat ngepmat ay waa wandi. Wandi mala Jisas ndi kat kwagalalaa ndɨna mbaapma nɨmbonala bot kulaa valɨgendɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tak kavle waagan tavila la nyan Jisasonala yivat wandɨ mala Jisas ndɨ kat kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mɨna ngepma yiga god mɨn kat apma vat yinda vat mɨna ngepma nɨmba kat yiga ambup mɨla waa wandɨ Jisas. Jisas wandɨ mala ngepma yilaa Jisas ndɨ kat apma vat yila vak ndɨna ngepma nɨmba kat aywaa mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Valigelaa kawilaa valindi. valindi maa wumba ngepmamba la nɨmba Jisas kat vɨlaa solat ɨsga walɨndi. Tat ndɨ kat kwo kawiga lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yisolaa lɨnja ngay vɨga la nyan Jisas kat yandɨ. ndɨna sɨ jairas. ndɨ yalaa Jisasna man ngandɨmba ndalaa wandɨ Jisas kat. Wuna nga y yagwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ndɨna kɨta nyan taagwa nyan yelogwen kat tɨlɨ. Kiya mɨna lɨlɨ. Lɨla naambi tamba vɨli kiyeli vɨlɨlɨk. Jisas lɨ kat kwunatndangat Jairas wandɨ. Yilɨndɨ maa nɨma sakwat nɨmba yaa yisondi. Jisasna ngwaymba yaa yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Taagwa kɨta yalɨ. Lɨ yelogwen kat tɨlɨ. Naambi taamba ɨlɨi kiyeli vɨlɨlɨk yelogwen wogwuga yetɨlɨlɨ. Ana ngɨlɨndɨ. Dokta nɨma sakwat kwunaka vɨlevindi. Lɨla sanya aywaa ndi kat kwilɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lɨ Jisasna kwupmba yalaa ndɨna njɨmbwi waavwi ɨnyɨtɨ. Sɨnyɨtɨ mala yelogwen wogwulɨla vat ngɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sɨnyɨtɨ maa Jisas lungwamaka vɨlaa wuna waavwi kanda sɨnyɨka wandɨ. Wandɨ mala kɨta nyan wunayɨ waa ana wandɨ. Pitagwi nat mbaapma nɨmbo Jisas kat wandi. Njambwi nyan mɨna ngwaymba nɨma sakwat nɨmba yaa yisolaa lɨgandi. Mɨna mbangɨ waavwi sɨnyɨka yilɨgandi. Manda kat kanda wun kat sɨnyɨka waa wamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisas ndi kat wandɨ. Kɨta nyan wun kat sɨnyɨtndɨ. Wuna kwondu samat ngɨlɨndɨ. Vɨga lɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wat taagwa wun kat vɨgiyandɨ waa yelavɨtaa ava plaga yaa Jisasna man ngandɨmba ndalaa walɨ. Wunayɨ sɨnyɨkna. Sɨnyɨkwun mala wuna yelogwen ngɨlɨndɨ waa walɨ mala aywaa wutndi. ");
INSERT INTO ian_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas lɨ kat wandɨ. Taagwa ke vaaka. Sɨnyɨkweyan kwo lɨgiyowun waa yelavɨtaa kwo lɨganyɨn. Apma vat tɨga yigiyanyɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ngambulɨmbɨt mala yisola lɨnja ngay kat vɨga la nyana ngaymba la kɨta nyan yandɨ. Yalaa Jairas kat wandɨ. Mɨna taagwa nyan tamba wundumbu yilɨ. Njambwi nyan kat wagala lɨma vak kwagala mɨla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas wutaa wandɨ. Ke vaaka. Jisas lɨ kat alɨpsɨga kwunakiyandɨ waa yelavɨtɨma vak ke kwagalaga. Apma vat tɨgvalɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairasna ngay yandi mala nat nɨma sakwat nɨmba ngay wuleilandi walaa Jisas kai wandɨ. Lɨla nyaek, nyɨme, Pita, Jems, Jon, Jisas mɨna wuleindi. ");
INSERT INTO ian_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nɨma maawut yelavɨka nglalɨndi. Jisas ndi kat wandɨ. Ke ngla. Ana kiyalɨ. Sɨndu kwaalɨ waa wandɨ mala ");
INSERT INTO ian_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ndi ndɨ kat njɨtɨndi. Tamba kiyalɨ waa yelavɨtaa njɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisas ndi kat wandɨ, alaguat wogwendi. Wogwendi mala Jisas lɨ kat taambamba kwutaa wandɨ. Taagwa nyan laat nyɨla wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wandɨ maa lɨla kait yandɨ, laatɨ. laatɨ mala lɨ kat kɨgɨnda agwi wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lɨla nayaek nyɨme vɨlaa ngɨpaliga ndambɨt. Kan yuwa vat nat nɨmba kat ke mbuka waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas ndɨna taamba vɨli kiyeli vɨlɨlɨk nɨmba kat wandɨ mala yisolaa lɨndi. Kavle waagan savɨlɨnjeya kwondu yelogwen kat ta nɨmba kat kwunatnjeya kwondu ndi kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","God ndinyangu kat yilɨnda apma vat yiga ambuk waa wandɨ. Yelogwen kat ta nɨmba kat yiga kwunak ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ndi kat nat nyaangɨt wandɨ. Yingweya njɨmbla vasɨ vasɨ ke kwuka. Yɨmbwi nao sanya ke klaa. Waavwi vɨlɨlɨk ke kaliga. Kwo ay. ");
INSERT INTO ian_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ngepma yilaa ngay wuleilaa wan ngaymba tɨga kwaigangwuk. Njɨvwa ngɨlɨndɨ maa wan ngay kwagalalaa yigiyangwuk. Ngay ngay ke yiga kwangwa. ");
INSERT INTO ian_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kɨta ngepma nɨmba ngwuk kat kai wanjeyan ndi kat kwagalalaa God ngwuk kat sɨgiyandɨ waga mana mbaw vɨvlɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wandɨ mala ngepma ngepmat yindi. Yiga wan apma nyaangɨt mbuka yelogwen kat ta nɨmba kat kwunatɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Njambwi nyan herot Jisas kwuta vat mbutɨndi, wutndɨ. Wutaa mandɨp mandɨp yelavɨtndɨ. nat nɨmba Jisas kat tɨga wandi. Jon kiyalaa laatndɨ. Ndɨnayɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nat nɨmba Jisas kat tɨga wandi. Ndɨ tamba la nyan Ilaija. ndɨ kiyalaa laatndɨ. Nat nɨmba wandi. Ndɨ kiyalaa laakna tamba la profetna waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herot wandɨ. Jon kat nambu tamb kalɨkwun, kiyandɨ. Mbutɨnja nyan anda nyana waa mandɨp mandɨp yelavɨtndɨ. Ngi kat tɨga Jisas kat vɨvat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisasna mbaapma nɨmba ngepma ngepmamba yiga yetɨga yandi. Yalaa yinja vat Jisas kat yaa mbutndi. Tɨga lɨga Betsaida walɨnja ngepma ngwaymba lɨga kwo kava ndi kat kwutaa kalindɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wan ngepmamba la nɨmba yinja vak wutaa ndina kwupmba yindi. Yandi maa Jisas ndi kat yagwa ngwula wandɨ. God ndinyangu kat yilɨnda apma vat ndi kat mbutɨndɨ. Yelogwen kat ta nɨmba kat kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nya samat ndaindɨ kan nglaambu Jisasna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nɨmba ndɨ kat yalaa wandi. Ndi kat mbupmɨn, yigandi. Ngepma ngepmat yiga kwanjeya ngay kɨgɨnda vɨgandi. Tɨlɨna kava kwo kava. Ndinyangu kai waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wandi maa Jisas ndi kat wandɨ. Wundi nɨmba kat kɨgɨnda agwi ngwula waa wandɨ. Nɨn kɨgɨnda kai. Nao tambanat kami vɨlɨlɨk mɨna lɨgandɨ. Sanya yiga kwiga ndi kat kɨgɨnda klagat? Waa Jisas kat wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","Jisas ndɨna mbaapma nɨmba kat wandɨ. Ndi kat wangwuk, kava kavamba ndaa lɨgiyandi. Nat kava ndumi vɨli kiyeli tamba vɨli nɨmba. Wupma ndaa lɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas nao tambanat kami vɨlɨlɨk kwutaa tanambɨtaa nyinangwutnat vɨga God kat sɨvu kɨndɨ. Sɨvu kɨlaa lɨmbaga lɨmbaga ndɨna mbaapma nɨmba kat kwilɨndɨ. Kwindɨ maa nat nɨmba kat kwilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kɨga yaat taatɨ, tɨndi. Kɨlambɨnjan nao kami mbanimba naangandi. Mbani tamb vɨli kiyeli vɨlɨlɨk taatɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nat nandinya Jisas God kat ngambulɨndɨ. Ndɨna mbaapma nɨmba ndɨnogwinala lɨndi. Nat nɨmba kai. God kat ngambulaa ndi kat wagalandɨ. Wundi nɨmba wun kat angamak yelavɨtndi. Wun kanda wun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wandɨ maa wandi. Nat nɨmba Jisas ndɨ ngu yagula Jona waa wandi. Nat nɨmba Jisas ndɨ Ilaija waa wandi. Nat nɨmba Jisas ndɨ tamba kiyala laakna profetna waa wandi waa Jisas kat wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wandi maa Jisas ndi kat wagalandɨ. Ngwuk angamak yelavɨka lɨgangwuk. Wun kanda wun waa wandɨ. Wandɨ maa Pita ndɨ kat wandɨ. Mɨn Kraist mɨn. Mɨn god wandɨ, yaa nyan mɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita wandɨ maa Jisas ndi kat wandɨ. yelavɨtingwa vak nat nɨmba kat wana mbutɨngweya. ");
INSERT INTO ian_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni wun kat nɨma sakwat kavle vat yigiyandi. Judana njambwi nɨmba, God kat kwunatɨga njambwi nɨmba, tamba Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba ndi aywaa wun kat kai waigandi. Wun kat vatnyagiyandi. Kiyalaa nandinya kuvut tɨga laakiyowun waa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jisas ndɨna mbaapma nɨmba kat wandɨ. Kɨta nyan wuna kwupmba yavat wandeyan ndɨna maawupmba lɨga vak kat kai walaa wuna njɨvwa mɨna kwuka wuna kwupmba yaigandɨ. Wuna kwupmba yandeyan wun kat yinja kavle vat vla ndɨ kat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kɨta nyan ndɨna maawupmba lɨga vat mɨna yelavɨka lɨndeyan ndɨ kavle yigiyandɨ. Kɨta nyan kan kɨpmana kwanda kwanda nda nɨma sakwat klalaa kavle yindeyan wan apma vatna? Kai. Apma vat ana ndɨ. Kavle vatna. ");
INSERT INTO ian_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","26","Kɨta nyan wuna sɨ waga wuna nyaangɨt mbupmat tɨpmwigwula yindeyan ngɨni ngaga yaweya njɨmbla ndɨ kat wuna apma nyana waa ana waigowun. Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni wuna nyaek wandɨ maa enselogwinala ngaga yaigowun. Kɨopmamba lɨga nɨmba njambwi nyanat tuwa vat vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngwuk kat nyaangɨt kɨta mbukiyowun. Woseka ana waigowun. Ngwutna nat nɨmba tak ana kiyaigangwuk. Tak God ndinyangu kat vɨga lɨndeya vak vɨlaa kiyaigangwuk. ");
INSERT INTO ian_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nandinya sɨla kuvut yindɨ, Jisas nduwiat wokevat wandɨ. Pita, Jon, Jems ndi kat kwutaa nduwiat kalindɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nduwi wokendi maa Jisas God kat ngambulɨndɨ. Ngambulɨndɨ maa ndɨna mɨndama kapma vat tɨndɨ. Ndɨna waavwi nɨmbun. Ndɨna waavwi sawun mɨna lɨga yiga kemba nda vla lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nat vɨlɨk palɨ kak kiyambɨt. Nat nyan Moses. Nat nyan Ilaija. Mbɨk Jisasonala ngambulɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mbɨtno kemba nda vla lɨmbɨt. God wandɨ maa ngɨni Jisas Jeruslaemba weleilaa kiyandeya vak kat ngambulɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitaogwi nat vɨlɨlɨk palɨ tat ndina mɨni sɨndu yilɨndɨ. Mɨni vɨga kemba nda vat vɨga Jisasogwinala lɨga vɨlɨlɨk palɨ kat vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Vɨlɨlɨk palɨ Jisas kat kwagala lɨmbɨt mala Pita Jisas kat wandɨ. Njambwi nyan nɨn aywaa tɨnan apma vatna. Yisombale kuvuk kwukiyanɨn. Mɨn kat kɨta, Moses kat kɨta, Ilaija kat kɨta kwukiyanɨn waa maawupmba yelavɨtapman kwo wandɨ ");
INSERT INTO ian_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita walɨndɨ maa mbaw ndaiga ndi kat kapmondɨ. Kapmondɨ mala Pitagwi nat vɨlɨlɨk palɨ vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mbaw nɨndɨmba kwundi yandɨ, wutndi. Wan nyan wuna nyana. Ndɨ kat solat sɨlɨgowun. Ndɨna nyaangɨt. Kapmondɨ mala Pitagwi nat vɨlɨlɨk palɨ vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kwundi wandɨ mala mbaw wokendɨ, Jisas kapmba kpma lɨndɨ, vɨndi. Tɨga lɨga vɨnja vat nat nɨmba kat ana mbutndi. Ngɨni glei mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nat nandinya nduwimba lɨga ndailɨndi, nɨma sakwat nɨmba Jisas kat yandi. ");
INSERT INTO ian_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ndina kɨta nyan Jisas kat nɨma kwundimba wandɨ. Njambwi nyan mɨn kat wagalavat yawun. Wuna mat nyan avɨ mɨla. Wuna kɨta nyana. Nat nyangu kai. ");
INSERT INTO ian_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ndɨ kat tavila la kavle waagan ndɨ kat tavindɨ maa nɨmamba walega walɨgandɨ. Kavle waagan ndɨ kat viyandɨ mala kɨpmamba ndalaa yuvut yiga ndɨna kwundi sɨpmia ndalɨgandɨ. Kavle waagan njɨmbla njɨmbla wupma yilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɨna mbaapmamba la nɨmba kat wowun mala ndi ana alɨpsɨga savɨlɨndi waa wandɨ Jisas kat. ");
INSERT INTO ian_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wandɨ mala Jisas wandɨ. Godna kwondu kat ana yelavɨka lɨgangwuk. Godna kwondu alɨpsɨga kwunakiyandɨ waa maawupmba yelavɨpmak kat kai wangwuk. Ngwuk kat nɨma sakwat njɨmbla sɨmogwivat tɨlɨwun. Sɨmogwiwa vak ana yelavɨka lɨgangwuk waa ndi kat walaa wan nyan kat wandɨ. Mɨna nyan kwutaa agiya waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jisas wandɨ, ndɨna ngayat kwutaa kalindɨ maa kavle waagan wan mat nyan kat viyandɨ mala kɨpmamba ndandɨ. Jisas kavle waagan kat kai walaa wan mat nyan kat kwunataa ndɨna nyaek kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Va nɨmba ngɨpaliga ndalaa God kwondu mbundɨ nyana waa wandi. Jisas kwuta vak va nɨmba aywaa wupma mɨna ylɨndi. Ndi ngɨpaliga ndaa lɨndi mala Jisas ndɨna mbaapma nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ngwuk kat nyaangɨt kɨta waigowun. Ngwuk yigumba awuk ngwula. Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni kan kɨpmana nɨmba wun kat kwutaa kavle vat yivat kaligiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mbutnda nyaangɨt ndi kwo wutndi. Nyaangɨtna angwa maawupmba ana yelavɨka lɨndi. Pagwula la nyaangɨt vla wutndi. Jisas kat nɨn kat nyaangɨtna angwa ambuk waa wagalavak kat vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisasna mbaapma nɨmba awat sowat walɨndi. Nɨna nyan anda nyana nɨma nyan waa awat sowat walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas walɨnja nyaangɨt ana wutndɨ. Ndina maawupmba yelavɨtnja vak vɨlaa ngwaymba la mat nyan kwutaa katsolaa ndɨna ngwaymba taagandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Taagalaa ndi kat wandɨ. Kɨta nyan wun kat tɨga kan nyan kat kwunatndeyan wun kat ay waa nyan kat kwunakiya nyan vla lɨgandɨ. Ngwula kɨta nyan wun nɨma nyan ana wun. Wun nat nɨmba kat kwunatɨga nyan wun waa wandeyan wan nyan ngwula nɨma nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas wandɨ mala Jon ndɨ kat wandɨ. Njambwi nyan mɨna sɨ waga kɨta nyan kavle waagan savɨlɨndɨ, vɨnɨn. Vɨlaa wupma ke savɨlɨlɨga waa wanɨn. Nɨna mbaapma nyan ana ndɨ. Ngi kat tɨga kai wanɨn waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wandɨ maa Jisas wandɨ. Ndɨ kat kai waa manda kat wamɨn. Ana nglaatndɨ. Nɨn kat kai walapman nyan nɨna kɨta njɨvwa nyana. ");
INSERT INTO ian_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God eandɨ mala Jisas nyɨnangwutnat wokendeya njɨmbla tamba ngway tologandi. ");
INSERT INTO ian_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nat nɨmba kat wandɨ mala tata yindi. Ndi yiga Jisas sɨndu kwandeya ngay vɨvat Sameriana kɨta ngepma wuleindi. ");
INSERT INTO ian_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jisas yandɨ mala kan ngepma nɨmba ngay kɨgɨnda kwivak kat kai wandi. Nɨn kat kwagalalaa nɨna maama nɨmbana ngepma Jerusalem yigiyandɨ waa yelavɨtaa kai wandi. ");
INSERT INTO ian_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jisasna mbaapmamba la vɨlɨlɨk palɨ Jems, Jon kai vanja vak wutaa Jisas kat wambɨt. Nyinangwupmba lɨga ya kat wali maa ngaga yaa ndi kat vɨtndɨ, ngɨlɨgiyandi waa wali waa Jisas kat wagalambɨt. ");
INSERT INTO ian_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wambɨt mala Jisas mbɨk kat vɨlaa kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","God wandɨ, ndinyangu vatnyavat ana yawun. Ndi kat kwunapmak yawun waa wandɨ maa wan ngepma kwagalalaa nat ngepmat yindi. ");
INSERT INTO ian_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ndi ava yambɨmba wogwelaa yilɨndi, nat kɨta nyan yiga Jisas kat wandɨ. Yimeya kava kava mɨna kwupmba yigiyowun waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kwapɨmba yetɨga nda waangu valaa sɨndu kwalɨgandi. Waavi nɨmbun ndina ngaymba kwalɨgandi. Wun Godna vak sɨmogwi lɨga nyan wun sɨndu kwaweya ngay kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas nat nyan kat vɨlaa wuna kwupmba yagwa waa ndɨ kat wandɨ. Wandɨ maa wan nyan Jisas kat wandɨ. Njambwi nyan wuna nyaek wundumbu yindɨ. Ngepma yilaa waangumba taagalaa yaigowun waa wandɨ mala Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wama vat ana nglaatndɨ. Mɨna ngepma tɨga kwo nɨmba ndi waangumba taagagiyandi. Mɨn kai. Mɨn God ndinyangu kat kwunatɨga vak kava kava yiga mbukiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nat nyan Jisas kat yalaa wandɨ. Njambwi nyan wuna ngaymba la nɨmba kat alɨ ngwula yiga tɨgowun walaa mɨna kwupmba yaigowun waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mɨn maawut vɨlɨlɨk yelavɨka lɨga nyan vla lɨgamɨn. Wan vak ana nglaatndɨ. Wan yelavɨtɨma vak kwagalalapman yimeyan God vɨga lɨga kava ana wuleigiyamɨn. ");
INSERT INTO ian_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngɨni njambwi nyan 70 nɨmba kat wandɨ maa ndi ngepma ngepma vɨli vɨli yindi tata. Yingwa ngepma ngɨni yigiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jisas ndi kat wandɨ. yingweya ngepma ambugat vla lɨgandɨ. Nɨma sakwat kɨlɨnja nda tamba ak wulaa lɨgandɨ. Sɨgɨkiya nɨmba kai. Ambugat vɨga la njambwi nyan kat wagala ngwula. Sɨgɨkiya nɨmba kat ay wandɨ, yigiyandi waa wagala ngwula. ");
INSERT INTO ian_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngwutno ay ngwula. Nɨma waala mat sip sip kat valɨnjeya vak vla yingweya ngepma nɨmba ngwuk kat kavle vat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yimbwi mandɨt su ke kalingwa. Ava yambɨ yiga vɨngweya nɨmba kat ke ngambuga. Vɨga kwagalalaa kwiyatapman aymba ngwuk. ");
INSERT INTO ian_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wuna ngay yagwa waa kɨta nyan wandeyan ngwuk apma vak alɨ ngwula walaa wulei. ");
INSERT INTO ian_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wuleingwa ngaymba la nɨmba ngwuk kat apma vat yinjeyan ndi kat apma vat alɨ ngwula waa wangwa vak ndinamba tɨgiyandɨ. Ngwuk kat kavle vat yinjeyan wangwa nyaangɨt ndinamba ana lɨgiyandɨ. Wan nyaangɨt lungwamataa ngwula lak yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wuleingwa ngaymba alɨ ngwula. Ngay ngay ke yiga. Wuleingwa ngaymba lɨga ngwuk kat kwilɨnja kɨgɨnda ngu agɨ ngwula. ngwuk njɨvwa kwutɨga nɨmba ngwuk. Ngwuk kat kwilɨnjeya kɨgɨnda ngwula wenga vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ngepma wuleilaa ngwuk kat kwilɨnja kɨgɨnda agɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndina ngepmana yelogwen kat ta nɨmba kat kwunak ngwula. God ngwuk kat kwunatndeya vak tamba ngway tologandɨ waa ndi kat ambuk. ");
INSERT INTO ian_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kɨta ngepma wuleingwuk, ngwuk kat kai wanjeyan ndina ngepma kwagala ngwula. ");
INSERT INTO ian_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ngepma alagumba tɨga ngwutna man mbaw vɨvlɨlaa ndi kat awamba. ngwuk kavle vat yingwuk. God ngwuk kat kwuntndeya vak ngwuk kat tamba ngway tologandɨ, kai wangwuk. Ngi kat tɨga nɨna man mbaw vɨvlɨlɨganɨn waa awa. ");
INSERT INTO ian_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngɨni God kavle nɨmba kat sɨgiya nandinya ngɨni wan ngepma kavle yigiyandɨ. Tamba la kavle vat ta ngepma Sodom walɨnja ngepma kavle vat ya vak kat wan ngepma kavle vat yindeya vak kwulakiyandɨ. Ngwuk kat woseka ana wowun. ");
INSERT INTO ian_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nat ngepma vɨlɨlɨk kɨngivat tɨgandɨ. Kan ngepma vɨlɨlɨk Korasinogwio Betsaido. Kan ngepma nɨmba nɨma sakwat nɨma njɨvwa kwutuwa njɨvwa vɨlaa nyaangɨt wupmak kat kai wandi. Nat ngepma vɨlɨlɨk Taiaogwio Saidono wuleilaa kwukwa nɨma njɨvwa kwukewan ndi nyaangɨt wukendi. Nyaangɨt wutaa kavle maawut kwagalalaa mandɨt kupi maawut yelavɨka lɨgendi. Nɨn tak nɨmamba kavle vat yinɨn waa yelavɨka lɨgendi. ");
INSERT INTO ian_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngɨni God kavle nɨmba kat sɨgiya nandinya Taiaogwio Saidona ngepma nɨmba kat nɨmamba ana sɨgiyandɨ. Korasinogwio Betsaidana ngepma nɨmba kat nɨmamba sɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapaneam walɨnja ngepma nɨmba ndino wupma. Ndi kupma yelavɨtɨgandi. Nɨn apma vat tɨga nɨmba nɨn. Nɨn nyinangwut tɨga nɨmba vla lɨganɨn God ndi kat vɨlaa kavle nɨmba ngwuk waa walaa ndi kat sɨlaa ya vɨtɨga kavamba taagagiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas walaa wundi 70 nɨmba kat wandɨ. Ngwutna nyaangɨt wutɨga nɨmba wuna nyaangɨt wutɨga nɨmba vla lɨgandi. Wun kat kai walɨga nɨmba wun kat ay waa nyan kat kai walɨga nɨmba vla lɨgandi. Aywaa kɨta vatna. ");
INSERT INTO ian_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","70 nɨmba yalaa solat sɨga Jisas kat wandi. Njambwi nyan mɨna sɨ waga kavle waagan savɨlɨlɨnɨn, yindi. Nɨna nyaangɨt wutndi waa wandi maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Seten kat kwulatɨngwa vat vɨga lɨgowun. Ndɨ mbambala nyinangwupmba lɨga njambwi nyan ana ndɨ. Ndɨ tamba ndaiga kavle kavamba lɨgandɨ, vɨwun. ");
INSERT INTO ian_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ngwuk kat kwondu kwiwun. Kavle kamboy ngwuk kat valɨleyan ana kavle yigiyangwuk. Ngwuk kat kwiwa kwondu vɨga lɨgiyandɨ. Seten kat kwulakiyangwuk. Nat kavle nda ana ngwuk kat kavle yigiyandɨ. Ngwuk kat kwiwa kwondu vɨga lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kavle waagan ngwutna nyaangɨt wutnja vak kat yelavɨka ke nɨmamba solat sɨga. Wan nɨma nda ana ndɨ. nyinangwupmba lɨga njambwi nyan nɨna sɨ pɨlɨwutaa nyinangwutnat kaligiyandɨ waa yelavɨka nɨmamba solat sɨga alɨ ngwula. Wan nɨma nda. ");
INSERT INTO ian_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tɨga lɨga Godna waagan Jisasna maawupmba ngwandɨlɨndɨ maa solat sɨga nyaek kat wandɨ. Nyaek wamɨn maa mbutuwa nyaangɨt kan kɨpmana nambuo lɨga nɨmba wuka kwagala lɨgandi. Ana yelavɨtɨgandi. Wamɨn mala kwo nɨmba ndi nambu lapman nɨmba yelavɨtɨgandi. Yima vat apma vatna. ");
INSERT INTO ian_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nyaek, kwutuwa njɨvwamɨnamba aywaa klawun. Wuna angwa vat kan kɨpmana nɨmba ana vɨga lɨgandi. Mɨn mɨna nyana angwa vak vɨga lɨgamɨn. Kan kɨpmana nɨmba mɨna angwa vak ana vɨga lɨgandi. Wun kɨt nyan mɨna wuna nyaekna angwa vak vɨga lɨgowun. Mɨna angwa vak sɨmogwi luwa nɨmba ndino vɨga lɨgandi waa nyaek kat walaa ");
INSERT INTO ian_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ndɨna mbaapma nɨmba kat wandɨ. Ndɨna mbaapma nɨmba kat ana pagwundɨ. Nat kwo nɨmba kat pagwuga wandɨ. Vɨlɨngwa vat apma vatna. Vɨlaa apma vat tɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tamba la profet tamba la njambwi king vɨlɨngwa vat ndi tamba vivat wandi. Ndi ana vɨndi. Wutɨngwa nyaangɨt ndi tamba wupmat wandi. Ana wutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ndina ngepma vak vɨga la nyan kɨta Jisas apma nyaangɨt mbukiyandɨ? E? Kavle nyaangɨt mbukiyandɨ? Waa yelavɨtaa Jisas kat kɨta nyaangɨt wagalandɨ. Sɨmogwi lɨga nyan, anda apma njɨvwa kwutaa njɨmbla njɨmbla apma vak yiga yetɨweya vak klaigowun waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wagalandɨ maa Jisas ndɨ kat wandɨ. Tamba Moses kwiya nyaangɨt angamak pɨlɨwutndɨ. Tamba vɨmɨn? E? Ana vɨmɨn? Waa wandɨ maa wan nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tamba vɨwun. Kupma pɨlɨwutndɨ. Ngwutna njambwi nyan Godna. Ndɨ kat maawupmba yelavɨka alɨ ngwula. Ndɨ kat solat asɨ ngwula. Ndɨ kat woviyaguga alɨ ngwula. Avla ngwutna mbangi kwunatɨngwa vak vla nat nɨmba kat wupma kwunak ngwula waa tamba pɨlɨwutndɨ Moses waa wandɨ wan nyan. ");
INSERT INTO ian_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wandɨ maa ngiyambak wama. Wupma yimeyan apma vat tɨgiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kwo wagalandɨ waa yelavɨpmbandɨ walaa nat nyaangɨt Jisas kat wagalandɨ. Kwunakweya nɨmba anda nɨmba ndi waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas wutaa ndɨ kat wapuseput mbutndɨ. Judana kɨta nyan Jerusalem kwagalalaa Jerikoat ndaindɨ. Yilɨndɨ mala sɨkwutɨga nɨmba ndɨ kat yaa vɨlaa ndɨ kat viyaga ndɨna nda ndɨna waavwi sɨkwuka klalaa yindi. Ndɨ kiya mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tɨga lɨga God kat kwuntɨga kɨta nyan wan yambɨmba yandɨ. Yalaa ndɨ kat vɨlaa yambɨna nat naangɨmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tɨga lɨga nat nyan Livaina yelangɨ nyan wan yambɨmba yandɨ. Yalaa ndɨ kat vɨlaa yambɨna nat naangɨmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tɨga lɨga Sameriana kɨta nyan wan yambɨmba yandɨ. Sameriana nɨmba ndi Judana maama nɨmba ndi. Viyanja Juda vɨlaa ndɨ kat maawut yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ndɨ kat yaa vɨlaa ndɨ kat viyanja nglaw marasin taagalaa waavwimba ngindɨ. Ngilaa ndɨno donkina mbunimba ndɨ kat kwutaa wokega taagalaa kalindɨ. Haus pasindia kalindɨ. Wan ngan ndɨ kat vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nat ngambi haus pasindia vɨga la nyan kat dola vɨlɨlɨk kwilaa wandɨ. Ndɨ kat kwunaka vɨga lɨgiyamɨn. Ndɨ kat kwunapmak nat sanya yaagimeyan yilaa yalaa mɨn kat awat kwigiyowun waa walaa yindɨ. Waa Jisas wapuseput mbutaa wan nyan kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wan wapuseput mbukwa kuvut nɨmbana anda nyan ndɨna nda sɨkwukna nyan kat apma vat yindɨ waa Jisas wagalandɨ maa wan nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ndɨ kat kunakna nyan apma vat ya nyana waa wandɨ maa mɨn wupma yiga yetɨ mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yiga lɨga ngepma kɨta wuleindi. Wan ngepmana kɨta lagwa Jisas kat lɨla ngayat yagwa walaa kalilɨ. Lɨla sɨ Mata. ");
INSERT INTO ian_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lɨla yakwa lagwana sɨ Maria. Jisasngay wuleilaa nyaangɨt ngambulɨndɨ, Maria ndɨna man ngandɨmba ndaa lɨga wutɨ. ");
INSERT INTO ian_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata ana kwo lɨlɨ. Lɨ nɨmba sakwat njɨvwa kwuka kɨgɨnda kwutɨlɨ. Kɨgɨnda kwuka Jisas kat yalaa walɨ. Njambwi nyan wun njɨvwa kapma kwutɨgowun. Ana vɨga lɨgamɨn? Wuna yakwa lagwa kat wamɨn mala yalaa wunagwinala njɨvwa kwukiyalɨ waa walɨ mata. ");
INSERT INTO ian_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Walɨ maa Jisas wandɨ. Mata nɨma sakwat mandɨp mandɨp nda kat yelavɨka lɨganyɨn. ");
INSERT INTO ian_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Apma nda kɨta ana yelavɨka lɨganyɨn. Kan apma nda kat yelavɨka lɨgalɨ. Wuna nyaangɨt wupmak walɨ. Lɨ kat ke kai waa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jisas tɨga God kat ngmabundɨ. Tamba God kat ngambundɨ, ndɨna mbaapma nyan ndɨ kat yalaa wandɨ. Njambwi nyan tat ngu yagula Jon ndɨna mbaapma nɨmba kat God kat ngambunjeya vat sɨmogwindɨ. Mɨno nɨn kat sɨmogwigiyamɨn waa wandɨ maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","God kat ngambungweya njɨmbla kupma awa. “Nyaek, Mɨna sɨ kwutaa katsolɨganɨn. Ngɨni kan kɨpmamba lɨga nimba kat vɨga lɨmɨn maa mɨna kwundi wuka lɨnjeyan apma vatna. Wan njɨmbla kat kawiga lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nandinya nandinya kɨneya kɨgɨnda agwi mɨla. ");
INSERT INTO ian_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mɨn kat kavle vat yiga yetɨlɨneya vak ke kwuka. Kwagala. Nɨno nat nɨmba nɨn kat kavle vat yiga yetɨlɨngjeya vak ana kwutɨganɨn. Kwagala lɨganɨn. Kavle vat nɨn kat yaa kwutnadɨ walaa wanɨn.” Waa wupma god kat ngambu ngwula. ");
INSERT INTO ian_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kɨta nyana alɨ nyan nɨndɨ ngan nɨma ngan yandɨ. Yaa nyan kat kwindeya nao kɨgɨnda kai. Ngi kat tɨga ndɨna ngay kwagalalaa nat alɨ nyana ngay kɨgɨnda kat yɨndɨ. Yilaa alagumba lɨga laataa wandɨ. Alɨ nyan nat nyan wuna ngay yandɨ. Ndɨ kat kwiweya nao kɨgɨnda kai. Wungi kat yawun. Wun kat agwi wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ngaymba lɨga nyan wandɨ. Manda kat wun kat nɨma njɨvwa kwimɨn. Ngayna mbaapmo tamba tɨvɨwun. Wun wuna nyan apma sɨndu kwaanɨn. Mɨn kat nao kɨgɨnda kwivat ana alɨpsɨga laakiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngwuk kat wowun wandɨ Jisas. Ngaymba ta nyan wuna alɨ nyana yaa waa yelavɨtaa ana laakiyandɨ. Kɨgɨnda kat yaa nyan njɨmbla njɨmbla wagala lɨndeyan ngaymba la nyan ndɨ laakiyandɨ. Laataa ndɨ kat nao kɨgɨnda kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngwuk kat wowun. God kat wagalangwuk maa kwigiyandɨ. Ndɨ kat kwaka wagalangweyan kwigiyandɨ. Ngay mbapmo taamba viyalɨga nyan vla ndɨ kat wagalangweyan kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wagalalɨga nyan ndɨ klaigandɨ. Kwuka wagala lɨga nyan klaigandɨ. Ngay mbapmo taamba viyalɨga nyan vla wagala lɨga nyan ndɨ klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngwutna mat nyan kɨgɨnda kat wagalandeyan ndɨ kat yuvut kamboykwigiyangwuk? Kai. Wupma ana kwigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nyaaga mbandɨ kat wagalandeyan ndɨ kat mɨnjɨ kwagwula kwigiyangwuk? Kai. Wupma ana kwigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nɨn kɨpma lɨga nɨmba apma maawut yelavɨka lɨga nɨmba ana nɨn. Nɨna nyangu nɨn kat wagalanjeyan ndi kat sɨmblan ana kwilɨganɨn. Apma vat kwilɨganɨn. Ngwutna nyɨnangwupmba lɨga nyaek ndɨ apma maawut yelavɨka tɨga nyana. Ndɨ kat wagalangweyan ngwuk kat apma nglei vat kwigiyandɨ. Ngwuk kat ndɨna waagan kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas tɨgat kulumata ta kavle waagan savɨlɨndɨ mala tavila la nyan nyaangɨt ngambundɨ. Va nɨmba mandɨp mandɨp yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nat nɨmba yelavɨka wandi. Kavle njambwi nyan Seten waa Bielebul walɨna nyan Jisas kat kwondu kwindɨ maa kavle waagan kat savɨlɨgandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nat nɨmba Jisas kat yelavɨtndi. Ndɨ God wandɨ, nyinangwupmba tɨga yaa nyana? E? Kai? Waa yelavɨtaa ndɨ kat wandi. Mɨn nɨma njɨvwa kwupmɨn, yama kava yelavɨka tɨgiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Maawupmba yelavɨtɨnja vak Jisas vɨlaa ndi kat wandɨ. Kɨta kavana nɨmba mbaapma vɨlɨlɨk sɨlaa awat sowat sɨga viyanjeyan ndi kavle yigiyandi. Ngɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Setena nɨmba kɨta vatna. Mbaapma vɨlɨlɨk sɨlaa awat sowat sɨga viyanjeyan ndi kavle yigiyandi. Bielsebul ndɨ kat kwondu kwindɨ maa kavle waagan savɨlɨlɨgandɨ waa wangwa nyaangɨt ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bielsebul ndɨ kat kwondu kwindɨ maa kavle waagan kat savɨlgandɨ waa wun kat walɨgangwuk. Ngwutna ngepmana nat nɨmba ndino svɨlɨlɨgandi. Nɨn God kwiya kwondumba savɨlɨlɨnganɨn waa walɨngandi. Wuno nɨmbun. ");
INSERT INTO ian_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God nɨn nat kwunakiya vat tamba ngway tologandɨ. Ngi kat tɨga God wun kat kwondu kwindɨ maa savɨlɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kao lɨga nyan nɨmba nda kwutaa ndɨna ngayna kwanda kwanda nda vɨga lɨndeyan wan nda kwo lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nat kao mbundɨ nyan yandeyan ndɨ kat kwulataa ndɨna ngayna nda sɨkwuka kwutaa kalilaa ndɨna mbaapma nɨmba kat kansaga kwigiyandɨ. Ndɨna nɨmbi nda aywaa kwutaa kaligiyandɨ. Tak wan nyan yelavɨtndɨ. Kwuta luwa nɨmbi nda wuna nda kat vɨga lɨgandɨ waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wunogwinala kɨta njɨvwa kwutapman nyan wun kat kai walɨga nyana. Wunogwinala ndinyangu kat kwutaa wuna mbaapmamba taagalapman nyan ndɨ kapma mbaapma nyana. Wuna mbaapmamba la nɨmba kat kwutaa kapma mbaapmamba taagavat tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kavle waagan ndu nyan kat kwagalalaa kavle kava mɨna yiga yetɨgiyandɨ. Sindu kwandeya apma kava kwatevilaa lɨgiyandɨ. Tɨga lɨga tak yetiwa nyan kat lungwamataa yigiyowun waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wupma walaa yilaa tavigiyandɨ. Wan nyan maawut ngay yaguga kwunatnja vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngi kat tɨga nat kavle waagan sɨla vɨli kwutɨ mala ndi aywaa taviga ndɨna maawupmba wuleigiyandi. Nat sɨlavɨli kavle waagana kavle vat kat kwulatɨgandi. Tavinja nyan tat samat kavle vat tɨndɨ. Ngɨni aywaa tavindi mala wan nyan nɨmamba kavle tɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ngambulɨndɨ, nɨma sakwat nɨmba wuka lɨndi. Tɨga lɨga taagwa kɨta nɨma kwundimba Jisas kat walega walɨ. Mɨn kat kwukna taagwa mɨn kat mwunya ngu kwiya taagwa apma vat tɨga tagwat waa walɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wupma kai. God waa nyaangɨt wutaa wan nyaangɨpmba yiga yetɨlɨga nɨmba ndi apma ndu apma taagwa ndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nɨma sakwat nɨmba yisolaa lɨndi maa Jisas ndi kat wandɨ. Kan mbambala glei lɨga nɨmga ndi kavle nɨmba ndi. Nɨma njɨvwa ana kwukiyowun. Tamba Jona God waa nyaangɨt mbutnda vla mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tamba Jona God waa vak Nineva walɨnja ngepma nɨmba kat mbutndɨ. Wuno mbambala nglei lɨga nɨmba kat God waa vak mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tamba kambangwapmba la njambwi kwin nɨna tamba la kin Solomon ndɨ kat vɨvat yalɨ. Ndɨ apma nambuo lɨga nyana waa wutaa yalɨ. Mbambala wun yawun. Wun Solomon kat kwulatɨgowun. Wun njambwi nyan wun. Ndɨ mat nyan ndɨ. Mbambala tɨga nɨmba njambwi nyanat tuwa vat ana yelavɨka vɨga lɨgandi. Ngɨni yaiga nandinya kambangwapmba la njambwi kwin kavle vat yingwuk waa ngwuk kat waigalɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineva walɨnja ngepmamba tamba la nɨmba ndino ngɨni yaiga njɨmbla ngwuk kavle vat yingwuk waa ngwuk kat waigandi. Ndi Jona mbuta nyaangɨt wutaa kavle maawut kwagalalaa mandɨpkupi maawupmba lɨndi. Ngwuk lai. Wun Jona kat kwulatɨgowun. Wun njambwi nyan wun. Ndɨ mat nyana. Mbutuwa nyaangɨt ana wukngwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kɨta nyan lam sagɨlalaa ana pagwugiyandɨ. Awmba ana naangagiyandɨ. Njambɨmba taagandɨ mala ngay wuleigiyaa nɨmba vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nɨno wupma. Nɨna maawut lam vla lɨgandɨ. Nɨna maawut kavle vat yelavɨka lɨneyan kavle vat lɨgiyanɨn. Kulun walalɨga kavamba man veila lɨga nyan vla lɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngutna maawut samat apma vat yelavɨka tɨgangwuk. Ke kwagalangwa wan vak. ");
INSERT INTO ian_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Apma maawut yelavɨka apma vat mɨna yiga yetɨngweyan nɨmamba kemba lɨga lam vla yetɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas ngambulɨndɨ mala Ferisi kɨta wandɨ. Wuna ngaymba nao yaa agɨ wandɨ. Wandɨ maa ngay wuleilaa kɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisas ndɨna taamba ngu njangi lapman kwo kɨlɨndɨ. Ferisi vɨlaa ngɨpalɨga ndandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maawupmba yelavɨtɨnda vak vɨlaa Jisas ndɨ kat wandɨ. Ngwuk Ferisi alagu mbangɨ kat mɨna yelavɨtɨgangwuk. Angwula maawut ana yelavɨtɨgangwuk. Ngwuk kap plet nɨma njɨvwa kwuka ngu njangi lɨgangwuk. Ngwutna maawut kavle vak nɨma sakwat tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","God mbangɨ mɨna ana kwutndɨ. Maawut nɨmbun kwutndɨ. Ngwuk manda kat kavle vat yelavɨka lɨga ngwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ngwutna kwanda kwanda nda sanya lapman nɨmba kat kwingweyan apma vat tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ngwuk Ferisi ngwuk kat miwa yiga lɨgowun. Ngwuk kavle yigiyangwuk. Ngwutna kamwin, ngwutna lomba, ngwutna nyangwa mbaapma tamba vɨli taagalaa God kat kɨta mbaapma kwilɨgangwuk. Wan nɨma njɨvwa kwutɨngwa. Ngwuk Godna apma vak kwagalalaa ndɨ kat ana woviyaguga lɨgangwuk. God kat kwilɨngwa vat kavle vat ana ndɨ. God kat yelavɨtapman yetɨlingwa vak kavle vatna. ");
INSERT INTO ian_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ngwuk Ferisi ngwuk kat miwa yiga lɨgowun. Ngwuk kavle yigiyangwuk. Yisolaa lɨnja ngay wuleilaa njambwi nɨmbana tɨgɨpmba ndaa lɨvat walɨgangwuk. Nat nɨmba ngwuk kat ngepmamba vɨlaa njambwi nɨmba ndi waa wanjangat walɨgangwuk. Kavle vatna. ");
INSERT INTO ian_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ngwuk Ferisi ngwuk kat miwa yiga lɨgowun. Ngwuk tamba Moses kwiya nyaangɨt sɨmogwi lɨga nɨmba ngwutno ngwuk kat miwa yiga lɨgowun. Ngwuk kavle yigiyangwuk. Ngwuk pagwunja mat mat vla lɨgangwuk. Mat mat tagumba veilɨganɨn waa ana nat nɨmba yelavɨtɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas walɨndɨ maa ndina ngepma vat kat vɨga la kɨta nyan Jisas kat wandɨ. Sɨmogwi lɨga nyan Ferisi kat kai wama nyaangɨt nɨno nɨna lak yalɨngandɨ. Wupma ana vɨga lɨgamɨn? Waa wandɨ mala Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ngwutno ngwuk kat miwa yilɨgowun. Kavle yigiyangwuk. Ngwuk nat nɨmba kat nɨma sakwat njambiya taagangwuk maa ndi nɨma sakwat njsvwa kwutɨgandi. Ndi kat anan yelavɨka lɨgangwuk. Nɨma sakwat njɨvwa kwupandi walaa ndi kat nat njambiya ana taakagiyanɨn waa ana walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngwuk kat miwa yilɨgowun. Kavle yigiyangwuk. Ngwutna tamba la ngwak walanga God waa nyaangɨt mbuta nɨmba kat vatnyandi. Ngwuk ngwutnayɨ profetna mat mat yelagalɨgangwuk. Ngwutna ngwak walagana maawut klalaa lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngwutna ngwak walanga profet kat vatnyanja vat apma vatna waa yelavɨtɨgangwuk. Vatnyandi maa ngwut mat mat yelagalɨgangwuk. Yelagalingwa vak vɨlaa vatnyanja vat apma vatna waa yelavɨtɨngwa vak vɨga lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tamba yinja vak kat God tamba wandɨ. “Wuna nyaangɨt waiga profet aposel wowun maa yigiyandi. Profetna aposelna nat nɨmba kat vatnyagiyandi. Nat nɨmba kat njɨka waga waigandi” waa tamba wandɨ God. ");
INSERT INTO ian_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tamba la profet vatnyanja vatna nglambi ngwutnamba tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Njambwi la nyan Ebel ndɨ kat tat vatnyandi. Vatnyaga yiga ngɨni Sekaraia kat vatnyandi. Ndɨ Godna ngay wuleilaa God kat kwunatɨnja njambɨmba ngwaymba lɨga tɨndɨ, vatnyandi. Ndi kat vatnyanja vatna nglambi aywaa ngwutnamba tigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ngwuk njambia taagala lɨga nɨmba ngwuk kat miwa yiga ligowun. Kavle yigiyangwuk. Apma vat klanjeya yambɨ ngwuk tɨvɨngwuk. Wan apma vat ngwuk ana klangwuk. Nat nɨmba klavat yinjangat kai wangwukk. ");
INSERT INTO ian_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas walɨndɨ maa tamba Moses kwiya nyaangɨt sɨmogwi la nɨmbagwi Ferisio ndɨ kat nɨma sakwat nyaangɨt wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kavle nyaangɨt nɨn kat wandeyan ndɨ kat kotmak kaligiyanɨn waa yelavɨka nɨma sakwat nyaangɨt wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nɨma nglei sakwat nɨmba kɨta kavamba yisolaa lɨndi. Ngway ngwaymba lɨga alɨ man veiga lɨndi. Tɨga lɨga Jisas ndɨna mbaapma nɨmba kat wandɨ. Wanda nyaangɨt nat nɨmba wutndi. Ferisina kavle vak vɨga alɨ ngwula. Ndina maawupmba tɨga kavle vat pagwulaa kwo yetɨlɨgandi. Ngwuk wupma ke yiga. ");
INSERT INTO ian_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mbambala pagwunja nda ngɨni kapmba lɨgiyandɨ. Ngɨni aywaa vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mbambala pagwuga waigowun waa wangwa nyaangɨt ngɨni aywaa wukiyandi. Kɨta nyan kat mɨna waigowun waa wangwa nyaangɨt ngɨni aywaa wukiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wuna alɨ nɨmba ngwuk yigumba awuk ngwula. Ndu nyan kat kwo vatnya mɨna tɨga nɨmba kat ke vakngwa. ");
INSERT INTO ian_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Vakngweya nyan waigowun. Ndu nyan kat vatnyalaa ya vɨtɨga kavamba taagalɨga nyan kat vaaka alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kɨlɨnja mak waavi tambanat sen moni vɨlɨlɨk wenga kwiga klalɨgandi. God wundi mat waavi kat ana maawut tɨvɨlɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngwutno ngwutna nɨmbɨ yuwina sakwat God vɨga lɨgandɨ. Ngwuk ke nɨmamba yelavɨka lɨngwa. Ngwuk mat waavi kat kwulatɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngwuk kat wowun. Jisas Godna vak sɨmogwi lɨga nyana waa nat nɨmba kat wangweyan ngɨni God tɨga kava wokelaa ensel kat waigowun. Ndi wuna nyangu ndi waa ngwuk kat tɨga waigowun. ");
INSERT INTO ian_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nat nɨmba wun kat kai vanja nat nɨmba kat mbutnjeyan ngɨni God tɨga kava wokelaa ensel kat ndina sɨ waga kai waigowun. ");
INSERT INTO ian_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wun Godna vat sɨmogwi lɨga nyan wun. Kɨta nyan wun kat kavle nyaangɨt wandeyan kavle vat yinda vak kat God alɨpsɨga sɨlɨmbwigiyandɨ. Kɨta nyan Godna waagan kat kavle nyaangɨt wandeyan kavle vat yinda vak kat God ana sɨlɨmbwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ngɨni ngwuk kat kavle vat yivat Juda yisola lɨnja ngay kaligyandi. Ngwuk kat kotmak jas kat kaligiyandi. Nat njambwi nɨmba ngwutna nyaangɨt wutnjangat kaligiyandi. Anda nyaangɨt waigowun waa nɨmamba ke yelavɨkngwa. ");
INSERT INTO ian_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wan njsmbla Godna waagan mbukngweya nyaangɨt ngwuk kat vɨsɨmogwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wan nɨma sakwat nɨmbana kɨta nyan Jisas kat wandɨ. Sɨmogwi lɨga nyan wuna yakwa nyan kat ambuk. Ana nyaek wundumbu yindɨ. Ndɨ kat kwinda nda wamɨn mala wun kat samat kwigandɨ waa wandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wuna njɨvwa ana ndɨ. Mbɨtna nyaek kwiya nda kansaga kwilɨga nyan ana wun waa ndɨ kat walaa ");
INSERT INTO ian_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","nɨma sakwat nɨmba kat wandɨ. Nat nyana nda klavat nɨmamba ke yelavɨkngwa. Kwanda kwanda klanja nda nɨma nda ana ndɨ waa walaa ndi kat wapuseput mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɨma sanyo la nyan ndɨna ambugapmba kɨgɨnda nɨma sakwat kwandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ndɨ ambugat vɨlaa yelavɨntndɨ. Wuna kɨgɨnda nɨma sakwat tɨgandɨ. Kɨgɨnda yisoga taagaluwa ngay maknat. Anda vapmba yigiyowun waa yelavɨtaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mbambala lɨga mak nge sulɨlaa mandɨp nɨma ngay kwukiyowun. Kwutaa wuna kɨgɨnda wuna kwanda kwanda yisoga taagagiyowun. ");
INSERT INTO ian_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taagalaa apma vat tɨgiyowun. Njɨvwa kwutapman tɨga njɨmbla njɨmbla kwo kɨgɨnda ngu kɨga solat sɨgiyowun waa wandɨ maa God ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mɨn tungwengwan yiga lɨgamɨn. Wama nyaangɨt ana nglaatndɨ. Mbambala ngan kiyaigamɨn. Kiyamɨn, yisoga taagalɨma nda nat nyan klaigandɨ waa God wandɨ, kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","God kat yelavɨtapman kɨpmana kwanda kwanda mɨna yisoga taagalɨga nɨmba kɨngi vat tɨgandi. Wapuseput mbutuwa nyan vla lɨgandi waa Jisas mbuka lɨga ");
INSERT INTO ian_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ndɨna mbaapma nɨmba kat wandɨ. Ngwuk kɨpmana nda kat nɨmamba ke yelavɨkngwa. Anda kɨgɨnda kɨgiywoun. Anda waavwi kwusogiyowun waa nɨmamba ke yelavɨkngwa. ");
INSERT INTO ian_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kɨgɨnda waavwi nɨma nda ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Waavi yetɨga vak kat yelavɨk ngwula. Ndi kɨgɨnda ana naanga pɨka kɨlɨgandi. Ndi kɨgɨnda klaga ana yisoga taagalɨgandi. God ndi kat vɨga lɨgandɨ. God ndi kat vɨga lɨndan ngwuk kat apma vak vɨga lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngwula kɨta nyan tambɨ nyan tɨga lɨvla mbundɨ nyanat tɨgiyowun waa wandeyan ndɨ lɨvla mbundɨ nyanat tɨgiyandɨ? Kai la. Ngɨni tɨga mandɨt mbangɨ klaa ana tɨgiyanɨn. Nɨn wupma ana alɨpsɨga tɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngwuk ana wan vak yigiyangwuk. Manda kat kɨgɨnda waavwi kat mɨna nɨmamba yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mwe lɨga vak kat yelavɨk ngwula. Ndi njɨvwa ana kwutɨgandi. Ndi waavwi ana tavalɨgandi. Nɨan tamba la njambwi king Solomon ndɨ apma waavwi kwusolaa lɨndɨ. Ndɨna waavwi mwena mbangɨ kat ana kwulatndɨ. Mwena mbangɨ apma nglei mbandɨ kat ana kwulatndɨ. Mwena mbangɨ apma nglei mbangɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kɨpmamba avla watɨga nda sɨvla lɨlɨga nda ana ndɨ. Nat nandinya tɨndɨ, nat nandinya nat nɨmba kalɨtaa ya sagalandɨ, vɨka ngɨlɨndɨ. Avla watɨga ndana mbangɨ apma nglei mbangɨ. God nd kat apma vak vɨga lɨga apma mbangɨ kwindɨ. Ngwuk kɨgɨnda waavwi kat ke nɨma vak yelavɨka kwaka lɨngwa. ");
INSERT INTO ian_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Ngepma ngepmamba la nɨmba kɨgɨnda waavwi kat mɨna kwatɨgandi. Wan ndagwinala tɨlapman yingweyan ngwutna nyɨnangwupmba lɨga nyaek vɨlaa kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Godna nda kat mɨna nɨmamba yelavɨka lɨngweyan kɨpmana nda ngwuk kat God kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ngwuk wuna mbaapmamba lɨga nɨmba nɨmba sakwat nɨmba ana ngwuk. Ngwuk ke vakngwa. ngwutna nyaek ngwuk kat apma nglei vat vɨga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kwanda kwanda nda kwilaa sanya klalaa kwo lɨga nɨmba kat agwi ngwula. Wupma yingweyan ngwutna nyɨnangwupmba lɨga wenga nda nɨma yigiyandɨ. Ngwutna kwanda kwanda nda nyɨnangwupmba lɨndeyan wovuna. Sɨkwukiya nɨmba ana sɨkwukiyandi. Kalala ana kɨlɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngwutna kwanda kwanda nda nyɨnangwupmba lɨndeyan nyɨnangwutna vak kat mɨna yelavɨka tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Godna njɨvwa kwuka yetɨ ngwula. Njambwi nyan ngaga yaiga njɨmbla kat kawiga alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kan kɨpmana njambwi nɨmbana njɨvwa kwuta nɨmba ndina njambwi nyan kapti kat yindɨ, yandeya njɨmbla kat ndi ngaymba lɨga kwo kawiga lɨndi. Yandɨ mala vɨlaa ngayna mbapma lavwivat kwo kawiga lɨndi. Kawiga lɨnja vla ngwutno ngwula njambwi nyan yaiga njɨmbla kat kawiga alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yandeya njɨmbla ndɨna njɨvwa kwuta nɨmba ndɨ kat kawiga lɨnjeyan apma vatna. Kawiga lɨnjeya vak vɨlaa ndi kat kɨgɨnda klalaa ndi kat kapti kwuikiyandɨ. Ndi ndaa lɨga kɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ndɨ nɨndɨ ngan ngambi ngan yandɨ, ndɨna njɨvwa kwuta nɨmba sɨndu kwalapman ndɨ kat kawiga lɨnjeyan apma nglei vatna. ");
INSERT INTO ian_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nat ngay vɨga la nyan sɨkwuta nyan yandeya njɨmbla vɨgandan ana sɨndu kwaindɨ. Ndɨ kat kawiga lɨgendɨ. Ndɨna ngayna nda sɨkwutandɨ walaa kawiga lɨgendɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ngwutno kawiga alɨ ngwula. Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni nat njambɨ ngaga yaweya njɨmbla ana vɨga lɨgangwuk. Ngi kat tɨga njɨmbla njɨmbla kawiga lɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas wandɨ mala Pita ndɨ kat wandɨ. Njambwi nyan wama nyaangɨt mɨna mbaapma nɨmba nɨn kat mɨna wamɨn? E? Wundi nat nɨmba kat wamɨn? Waa wagalandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Godna njsvwa kwuta nɨmba kat aywaa wan nyaangɨt wowun. Njambwi nyan nat nɨmba kat kwunatnjeya njɨvwa kwindɨ. Wan njɨvwa kwagalalapman apma vapmba kwuka lɨnjeyan wan apma vatna. ");
INSERT INTO ian_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Njambwi nyan yaiga njɨmbla ndɨna njɨvwa apma vapmba kwuka lɨndi, vɨndeyan apma vatna waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Njambwi nyan apma njɨvwa kwuta vak vɨlaa njɨvwa kwuta nyan kat waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wuna njambwi nyan kwiyatapman ana yaigandɨ waa njɨvwa kwuta nyan yelavɨtaa nat nɨmba kat kavle vat yiga kɨgɨndagwi nɨma ngu kɨga tungwengwan yiga tɨndeyan apma vak ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wuna njambwi nyan mbambala ana yaigandɨ waa wandɨ mala yaigandɨ. Yalaa ndɨ kat viyaga nat kavle nɨmba kat yinjeya vla ndɨ kat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Njambwi nyana njɨvwa kwuta nat nɨmba kupma agwut waa wanda vak wutaa njɨvwa ana kwutndi. Kavle vat kwutndi. Njambwi nyan yalaa ndi kat nɨmamba viyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Njambwi nyan njɨvwa kwuta nat nɨmba kupma agwut waa wanda vat ana wutndi. Wutapman tɨga ndino kavle vat kwutndi. Njambwi nyan yalaa ndi kat nɨmamba ana viyaigandɨ. Samat viyaigandɨ. God nɨma sakwat apma nyaangɨt kwila nɨmba ndi Godna njɨvwa apma vat kwutapman yɨlɨnjeyan God ndi kat nɨmamba viyaigandɨ. God apma nyaangɨt kuvuk kwila nɨmba ndi Godna njɨvwa apma vak kwutapman yilɨnjeyan God ndi kat ana nɨmamba viyaigandɨ. Samat viyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kan kɨpma ngaga yalaa njɨvwa kwutuwun mala nat nɨmba walea lɨgiyandi. Mbambala samat walea lɨgiyandi. Vɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Samat tɨga wun kat nɨma vat yaigandɨ. Mbambala nɨmamba yelavɨka lɨgowun. Kan vak ngɨlɨndɨ maa ana nɨmamba yelavɨka lɨgiyowun. Kwo lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kan kɨpmana nɨmba kat kwutaa kɨta mbaapmamba taagavat ana yawun. Yawun mala kapma kapma mbaapma sɨga yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngɨni kɨta ngaymba la nɨmba mbaapma vɨlɨlɨk sɨgiyandi. Tambanat nɨmba lɨnjeyan kuvut nɨmba nat mbaapma sɨgiyandi. Vɨlɨlɨk palɨ nat mbaapma sɨgiyambɨt. Mbaapma sɨlaa awat sowat walea lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nyaek nat mbaapma nyan nat mbaapma tɨgiyambɨt. Nyɨme nat mbaapma taagwa nyan nat mbaapma tɨgiyambɨt. Yaw nat mbaapma kangɨt nat mbaapma tɨgiyambɨt. Mbaapma sɨlaa walea lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngwuk yambun agwi vɨga meik tɨmbu vɨngweyan samat tɨga meik ndaigiyandɨ waa walɨngwuk maa ndalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kangan walɨga mwuk kwutndɨ, nɨna mbangɨ nɨmamba kangan waigandɨ waa wangwuk maa ngwutna mbangɨ kangan walɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyɨnangwuk kɨpma sɨmogwi lɨga vak vɨga lɨgangwuk. Waluwa ngɨni yaiga njɨmbla sɨmogwi lɨga vat ana vɨga lɨgangwuk. Manda kat mandɨp mandɨp yilɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngwuk manda kat apma vat yelavɨtapman tɨgangwuk. Awuk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nat nyan mɨn kat kotmak kalingdeyan tak kot tɨnja ngay ke wuleiga. Ava yambɨ yiga lɨga nyaangɨt kwunaka ngambu mbɨla. Kwunaka ngambulapman yimbeyan mɨn kat kwo kaligiyandɨ kotmak. Jas wandɨ maa plisman mɨn kat kwutaa kalabusmba taagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngwuk kat wowun. Kalabus kwiyatapman ana kwagalagiyangwuk. Jas wanda mbak ngɨlɨndɨ mala kwagalagiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tɨga lɨga nat nɨmba yalaa tak njambwi nyan Pailat Galilina nat nɨmba kat vatnyanda vak Jisas kat mbutndi. Ndi God kat kwanda kwanda nda vatnyalaa God kat kwilɨndi, vatnyandɨ waa mbutndi Jisas kat. ");
INSERT INTO ian_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mbutndi mala Jisas ndi kat wandɨ. Ngwuk angamak yelavɨka lɨgangwuk. Ndi God kat nɨma sakwat kavle vat yindi, Pailat ndi kat vatnyandɨ? E? Ndina kavle vat Galilina nat nɨmbana kavle vak kat kwulatndɨ? E? ");
INSERT INTO ian_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kai luwa. Wupma kai. Ngwuk kat wowun. Ngwutna kavle maawut kwagalalapman yingweyan yinja vla yigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tak Sailoam walɨnja kavamba la sɨvla ngay ndalaa tamba vɨli kiyeli sɨla kuvuk nɨmba kat vatnyandɨ. Ndina kavle vat Jerusalemba la nat nɨmbana kavle vak kat kwulatndɨ? E? Ana kwulatndɨ? ");
INSERT INTO ian_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kai ana kwulatndɨ. Ngwuk kat wowun. Kavle maawut kwagalalapman yingweyan yinja vla yigiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisas ndi kat pagwuga la nyaangɨt mbutndɨ. Kɨta nyan fik walɨnja mi ndɨna ambugapmba sɨk tundɨ. Tɨga lɨga mi sɨk sɨgɨpmak yandɨ. Yandɨ, ana sɨk wagwundɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndɨna njɨvwa kwuta nyan kat wandɨɨ. Yaa avɨ. Wan mi naambi kuvuk ana sɨk wogwulɨgandɨ. Vɨlevigowun. Kwulamba avɨk kan mi. Manda kat kwo lɨga kɨpmana kwiya mɨna kɨga kiyagiga lɨgiyandɨ waa wandɨ maa ndɨna njɨvwa kwuta nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Njambwi nyan kan naambi mi kwo lɨgiyandɨ. Angwamba waangu valaa bulmakauna ndi taagagiyowun. ");
INSERT INTO ian_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yaiga naambi sɨk anagandɨ kwaiga. Sɨk kwalapman yindeyan vɨkiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Njɨvwa lapman nandinya Jisas Juda yisolaa lɨnja ngay wuleilaa ndi kat nyaangɨt mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kavle waagan tavila la taagwa kɨta lɨlɨ. Kavle waagan tavila lɨla mbuni kavle vat yindɨ. Sɨlanda sɨlanda yetɨlɨ. Alɨpsɨga ana savagu yetɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas lɨ kat vɨlaa yagwa wandɨ, yalɨ. Yalɨ mala Jisas wandsɨ. Nyɨna mbangɨmba lɨga yelogwen kɨngiyan kai waa savɨluwa waa walaa ");
INSERT INTO ian_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ndɨna taamba lɨla mbunimba taagandɨ, savagu laatɨ. Savagu laataa Godna sɨ kwutaa katsolɨlɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yisola lɨnja ngay vɨga la nyan vɨlaa kai waa njɨka lɨndɨ. Jisas njɨvwa lapman nandinyamba njɨvwa kwutndɨ waa yelavɨka njɨka lɨndɨ. Ndɨ laataa yisolaa la nɨmba kat wandɨ. Njɨvwa kwutneya nandinya sɨla kɨta kwo lɨgandɨ. Wan yelogwen kat tɨga nɨmba nandinya sɨla kɨta yandi maa kwunatndeyan wovuna. Njɨvwa lapman nandinya kai. Ana nglaatndɨ waa wandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mɨn kavle vat yelavɨka lɨgamɨn. Mɨna maawut ana nglaatndɨ. Njɨvwa lapman nandinya nɨna ngepma nɨmba aywaa ndina bulmakau donki tunja yaaw sɨvugilaa ngu kɨnjangat kalilɨgandi. Ngwutno nɨmbun kalilɨgangwuk. Wan kavle vat ana ndɨ waa walɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kat taagwa nɨna ngepma lagwat. Lɨ Ebrahamna yelangɨ lagwat. Seten wandɨ maa naambi taamba vɨli kiyeli sela kuvuk lɨla mbangɨmba yelogwern ngila lɨndi. Mbambala njɨvwa lapman nandinya wowun maa yelogwen ngɨlɨndɨ. Bulmakau donki kat ndina yaaw sɨvugingwa vla wuno wupma wupma lɨ kat tula la yelogwen sɨvugiwun. Kavle vakna yima waa wun kat manda kat walɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wandɨ mala Jisas kat kai wala njambwi nɨmba nyaangɨt kai. Wup yindi. Nat kwo la nɨmba Jisas ya vat vɨlaa apma vatna walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas wandɨ. God ndinyangu kat vɨga la vak anda vak vla lɨgandɨ. Anda nda vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndɨ mastet walɨnja sɨk vla lɨgandɨ. Wan sɨk mak glei nda. Kɨta nyan wan sɨk klalaa ndɨna ambugapmba tundɨ, nɨma mi wokendɨ. Wokendɨ, waavi nɨma sakwat ndɨna sandɨmba veilaa lɨndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas nat njambɨ wandɨ. God ndinyangu kat vɨga la vak anda nda vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ndɨ yis vla lɨgandɨ. Bret-nao kwutɨga taagwa yis kuvuk klalaa wit milmba taagalɨ, bret-nao nɨman wokendɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas Jerusalemat yiga ngepma ngepma nyaangɨt kwiga yilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yiga lɨga kɨta nyan ndɨ kat wandɨ. Nɨma sakwat nɨmba ana ndi nyinangwuk wuleigiyaa. Wovuna? waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Wuleinjeya suwi yambɨ nɨma tɨvwiya ana lɨ. Nɨma njɨvwa kwuka wuleigiyangwuk. Nɨma sakwat nɨmba wuleivat waigandi. Ana weleigiyandi. ");
INSERT INTO ian_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tɨga lɨga wan ngayna nhjambwi nyan laataa mbapmo tivɨgiyandɨ. Tɨvɨndɨ maa ngwuk alagumba lɨga taamba viyaa waigangwuk. Njambwi nyan njambwi nyan nɨn kat suwi lavwi waa waigangwuk. Wangwuk mala njambwi nyan waigandɨ. Ngwuk anda nɨmba ngwuk. Ngwula nɨndama ana vɨga lɨgowun waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wandɨ maa nɨn tak mɨnogwinala nao kɨga la nɨmba nɨn. Nɨna ngepma yalaa nɨn kat nyaangɨt mbutɨmɨn waa waigangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wukngwuk maa njambwi nyan nat njambɨ waigandɨ. Ngwuk kat woseka ana wowun. Ngwutna mɨndama ana vɨga lɨgowun. Ngwutna ngepma ana vɨga lɨgowun. Ngwuk kavle nɨmba ngwuk. Ay ngwula waa waigandɨ ngwuk kat. ");
INSERT INTO ian_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ngaymba la nɨmba vɨgiyangwuk. Ebraham, Aisak, Jekop, tamba la profet wuleindi, vɨgiyangwuk. Ndi God vɨga la kava tamba wuleindi. Nɨn alagumba kwo lɨganɨn waa yelavɨtaa nglaga nɨmbi ngliaka lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Woli agwi, yambun agwi, kambangwat agwi, malingwat agwi tɨga nɨmba yalaa God vɨga la kava wuleilaa ndaa lɨga nao kɨgɨnda kɨga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nɨn nat nɨmba kat kwulatɨganɨn waa mbambla yelavɨtɨgangwuk. Ngɨni yaiga njɨmbla ngwuk kat kwulakiyandi. ");
INSERT INTO ian_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wan nandinya nat Ferisi Jisas kat yalaa wandi. Wan kava kwagala mɨla. Njambwi nyan Herot mɨn kat vatnyavat tɨgandɨ waa wandi maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Herot ndɨ woseka walɨga nyana. Ndɨ kat yiga ambuk ngwula. Mbambala njɨvwa kwuka kavle waagan savɨlɨga yelogwen kat ta nɨmba kat kwunakiyowun. Ngɨni kwutuwa njɨvwa ngɨlɨndɨ, kwo lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wungi kat tɨga wan kava ana kwagalalaa yigiyowun. Mbambala njɨvwa kwuka kumba lɨgiyowun. Godna nyaangɨt mbutɨga nɨmba ndi kat kwo kavamba ana vatnyalɨgandi. Jerusalemba mɨna vatnyalɨgandi. Wupma yiga ambuk ngwula ndɨ kat waa Jisas ndi kat walaa Jerusalemba la nɨmba kat nɨma maawut yelavɨka wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ngwuk Jerusalemba la nɨmba ngwuk tamba la profet kat vatnyalɨgangwuk. God wandɨ, ngwuk kat yaa nɨmba kat vatnyalɨngwuk. Ngan nyaaga lɨla nyangu kat lɨla wiyo pulumba yapmola kwalɨ. Yapmola vak vla ngwuk kat kwutaa wuna mbaapmamba taagavat wowun. Ngwuk kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kai wangwuk, God ngwuk kat kwagalandɨ mala ngwutna kavle vat kwo lɨgiyandɨ. Samat tɨga wun kat ana vɨgiyangwuk. Ngɨni ngwutna ngepma wuleiwun maa wun kat vɨlaa waigangwuk. Apma vat yamɨn. God wandɨ, yamɨn waa waigangwuk. ");
INSERT INTO ian_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Njɨvwa lapman nandinya njambwi la Ferisi Jisas kat wandɨ maa ndɨna ngay nao kɨvak wuleindɨ. Nao kɨvak yaa nat nɨmba Jisas angamak yigiyandɨ waa yelavɨka ndɨ kat vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tɨga lɨga mbangɨ wuta la nyan Jisas kat yandɨ, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Vɨlaa Ferisiogwi Moses kwiya nyaangɨt sɨmogwi la nɨmba kat wandɨ. Njivwa lapman nandinyamba kan nyan kat kwunakweyan wovuna? E? Kavlea? Waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wandɨ maa awat ana wandi. Jisas ndɨ kat kwutaa kwunataa ay wandɨ, yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yindɨ maa Jisas ndi kat wandɨ. Njɨvwa lapman nandinya ngwula donki bulmakau waangumba ndainjeyan yiga klokaligiyangwuk waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ndi ana alɨpsɨga awat wandi. ");
INSERT INTO ian_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisasogwinala nao kɨvat yaa nɨmba njambwi ta nɨmbana tɨlɨga kavamba ndaa lɨvat njɨvwa kwuka yi ya lɨndi. Yinja vak vɨlaa Jisas ndi kat pagwula la nyaangɨt mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kɨta nyan kɨgɨnda kwutaa wandɨ, ndɨna ngaymba kɨvat yingweyan njambwi lɨga nɨmba tɨlɨga kavamba ke ndaa lɨga. Njambwi lɨga nɨmba tɨlɨga kavamba ke ndaa lɨga. Njambwi nyan nao kɨvat yandeyan ");
INSERT INTO ian_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mɨn kat yagwa waa nyan njambwi nyan kat kwutaa ndaa lɨma kayamba kaligiyandɨ. Kalilaa mɨn kat waigandɨ. Ndaa lɨma tɨgɨt kwagalalaa kumba mat tɨgɨpmba yaa alɨ. Kan njambwi nyan ndaa lɨma tɨgɨtmba ndaa lɨgiyandɨ waa wandɨ maa nɨmamba wup yiga nat kavamba yiga ndaa lɨgiyamɨn. ");
INSERT INTO ian_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kɨta nyan kɨginda kwutaa wandɨ, ndɨna ngaymba kɨvat yingweyan mat tɨga nɨmba tɨlɨga kavamba ndaa alɨ ngwula. Wupma ndaa lɨmeyan mɨn kat yagwa waa nyan mɨn kat waigandɨ. Ndaa lɨma tɨgɨt kwagalalaa kalat yagwa. Njambwi tɨgɨtmba ndaa lɨgiyamɨn. Wandɨ mala yimɨn, nat nɨmba vɨlaa mɨna sɨ kwutaa katsogiyandi waa pagwula la nyaangɨt mbutaa nyaangɨtna angwa ndi kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Avla ngwutna sɨ kwutaa katsongweyan nat nɨmba vɨlaa viyesendagiyandi. Avla ngwutna sɨ viyesendangweyan nat nɨmba vɨlaa katsogiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yagwa wuna ngaymba yaa agɨ waa wanda nyan kat Jisas wandɨ. Nɨma kɨgɨnda kwupmeya njɨmbla mɨna alɨ nɨmba kat mɨna yagwa waa ke waa. Mɨna yelangɨ nɨmba, ngepma nɨmba, nɨma sanyo tɨga nɨmba kat mɨna yagwa waa ke waa. Ndi kat yagwa wameyan ngɨni mɨn kat yaa agɨ waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nɨma kɨgɨnda kwupmeya njɨmbla sanya lapman nɨmba, man kavle ya nɨmba, yelogwen kat ta nɨmba, mɨni vɨlapman nɨmba kat yaa agɨ ngwula waa awa. ");
INSERT INTO ian_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ndi ngɨni awat yaa agɨ waa ana waigandi. Wupma yimeyan ngɨni yaiga nandinya kiya nɨmba laakiya nandinya God mɨn kat awat apma vat yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wundi nɨmbana kɨta nyan Jisas waa nyaangɨt wutaa wandɨ. God vɨga la kava wuleilaa ndaa lɨga kɨneya njɨmbla apma vat tɨgiyanɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wandɨ maa Jisas ndɨ kat wandɨ. Kɨta nyan nɨma kɨgɨnda kwutaa nɨma sakwat nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɨvat tɨnja njɨmbla ndɨna njɨvwa kwuta nɨmba kat wandɨ, yagwa ngwula kɨgɨnda tamba kwuka tɨganɨn, tɨgandɨ waa yiga wandi. ");
INSERT INTO ian_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wandi maa yavak kat aywaa kai wandi. Nat nyan wandɨ. Wun kupi kɨpma klawun. Yiga vɨgiywoun. Wun ana alɨpsɨga yaigowun wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nat nyan wandɨ. Wun bulmakau tamba vɨli klawun. Yiga vɨgiyowun. Wun bulmakau tamba vɨli klawun. Yiga vɨgiyowun. Wun ana alɨpsɨga yaigowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nat nyan wandɨ. Wun mbambala glei taagwa klawun. Wun ana alɨpsɨga yaigowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ana alɨpsɨga yaiganɨn waa wanja vak njɨvwa kwuta nyan ndɨna njambwi nyan kat yiga mbutndɨ. Mbutndɨ maa nmjambwi nyan ndɨna maawupmba ndi kat njɨka lɨndɨ. Njɨka lɨga ndɨna njɨvwa kwuta nyan kat wandɨ. kwiyatapman yiga kava kava man veilapman nɨmba, yelogwen kat ta nɨmba, sanya lapman nɨmba, mɨni vɨlapman nɨmba ndi kat aywaa wamɨn, yaandi waa wandɨ njambwi nyan. ");
INSERT INTO ian_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wandɨ, yiga wandɨ, yandi. Yandi maa njɨvwa kwuta nyan njambwi nyan kat wandɨ. Aywaa yandi. Ngay ana taatɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","njambwi nyan wandɨ. kava kava, kwapɨ, ndinyangu lapman kava, kwo kavamba yiga wamɨn, kɨta nyan kɨta nyan yaandi. Wuna ngay taatangat wowun. ");
INSERT INTO ian_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tak yagwa wawa nɨmba ndi ana kɨgiyandi luwa waa wandɨ njambwi nyan waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nɨma sakwat nɨmba Jisas la kavamba yaa yisolaa lɨndi, Jisas ndi kat nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mbuka wandɨ. Kɨta nyan wuna kwupmba yavat yindeyan ndɨna nyaek nyɨme, taagwa, nyangu, yakwa nɨmbana nyaangɨt wupmak kat kai walaa wuna kwupmba yaigandɨ. Wuna kwupmba yalaa wunai waa nyaangɨpmba njɨvwa kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Vatnyanjeya nɨmba diwai kros walalaa kalinja vla ngwuk kat vatnyanjeyan ndɨna mala. ");
INSERT INTO ian_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kɨta nyan svla nge kwupmat wandeyan ana kwo kwukiyandɨ. Yigumba yelavɨtaa ngayna nda aywaa kwunaka taagalaa kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yelavɨtapman kwo kwutndeyan apma vak ana kwukiyandɨ. Kwaalɨk mɨna tawga kwagalagiyandɨ. Nat nɨmba ndɨ kat vɨlaa njɨkiyandi. ");
INSERT INTO ian_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wan nyan kwo yelavɨtapman sɨmblan kwutndɨ. Ana alɨpsɨga aywaa kwukiyandɨ waa njɨka waigandi. ");
INSERT INTO ian_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kɨta njambwi king nat king kat waleavat tɨndeyan tak yelavɨkiyandɨ. Wuna soldia 10,000 mɨna lɨgandɨ. Ndɨna soldia 20,000 nɨmba ndi. Ndi kat anda vapmba kwulaiyowun waa yelavɨtaa sɨvat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ndi kat ana alɨpsɨga kwulakiyowun waa walaa ndɨ sɨvat ana yigiyandɨ. ndɨna njɨvwa kwuta nɨmba kat wandɨ maa yiga nat king kat kɨmbɨt kwukiyandi. Ana waleagiyandi. ");
INSERT INTO ian_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ngwulo wupma lɨgangwuk. Wuna kwanda kwanda nda aywaa kwagalagiyowun waa yelavɨtapman yingweyan wuna kwupmba yaga wuna njɨvwa ana alɨpsɨga kwukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kɨlɨnja sol apma nda. Ndɨna nyingi yilɨnda vat ngɨlɨndeyan apma nda ana ndɨ. Tamba kavle yindɨ. Njɨvwa kai. ");
INSERT INTO ian_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nat kavle ya nda ambukapmba yaagineyan ambugatna nda apma vak laakiyandɨ. Nyingi lapman sol wupma kai. Ambugapmba ana yaagilɨganɨn. nyingi lapman sol nɨn kwo yaagilɨganɨn. Njɨvwa kai. Wawa nyaangɨt yigumba wuka maawupmba yelavɨk ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis sanya kla la nɨmbo nat kavle nɨmbo Jisas mbuta nyaangɨt wupmat yandi. ");
INSERT INTO ian_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Moses kwiya nyaangɨt sɨmogwi la nɨmbo Ferisio vɨlaa wandi. Wan kavle nɨmba kat manda kat kai walapman yilɨgandɨ. Wuna nyaangɨt yaa awut waa manda kat bndi kat walɨgandɨ. Ndinogwinala manda kat nao kɨlɨgandɨ. Ana nglaatndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wandi maa ndi kat pagwula la nyaangɨt mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ngwula kɨta nyan sip sip ndumi tambanat tɨga sip sip kɨta kwo kava yiga sɨlɨwotndeyan nat sip sip kat kwagalalaa yiga kwakiyandɨ. kwaka yiga vɨlaa kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sip sip kat kwutaa nyaambupmba walalaa solat sɨga kiyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ngepma wuleilaa ndɨna alɨ nɨmba kat waigandɨ. Wunogwinala solat asɨ ngwula. Wuna sɨlɨwokna sip sip vɨlaa kwutaa walalaa kiyawun waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngwuk kat wowun. Kavle vat yiga yetɨlɨga kɨta nyan kavle maawut kwagalalaa mandɨp kupi maawupmba yetɨndeyan nyɨnangwupmba lɨga nɨmba wupma nɨmamba solat sɨgiyandi. Nyɨnangwupmba lɨga nɨmba apma maawut sɨka apma vat yiga yetɨlɨga nɨma sakwat nɨmba kat vɨlaa ana nɨmamba solat sɨgiyandi. Samat samat solat sɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisas ndi kat nat pagwula la nyaangɨt mbutndɨ. Taagwa kɨta sanya tamba vɨli mɨna taagalɨ, lɨndɨ. Kɨta sɨlɨwotɨ. Lɨ lam sagɨlɨlaa ngayat yaguga kwakiyalɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vɨlaa lɨla alɨ nɨmba, ngepma nɨmba kat waigalɨ. Wunogwinala solat asɨ ngwula. Sɨlɨwokna sanya tamba vɨlaa klawun waa waigalɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngwuk kat wowun. Godnonala nyɨnangwupmba tɨga ensel kavle4 vat ta nyan ndɨna kavle vat kwagalandeyan ndi wupma solat sɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas ndi kat wapuseput mbutndɨ. Kɨta nyan nondanyan vɨlɨlɨk ta nyana. ");
INSERT INTO ian_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mat nyan nyaek kat wandɨ. Ngɨni kiyamɨn, kalaweya kwanda kwanda nda mbambala agwi mɨla waa wandɨ maa nyaek mbɨk kat kansaga kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tɨga lɨga ndɨna kwanda kwanda nda aywaa kwuka naangalaa sɨvla kavat yindɨ. Yilaa tɨnda kavamba ndɨna sanya aywaa kwuka yaagiga kavle vat yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ndɨna sanya ngɨlɨndi maa tɨnda kɨpma kɨgɨnda lapman tɨndɨ. Ndɨno kɨgɨnda kat vɨlevilaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kan kɨpmana kɨta nyan kat vɨlaa njɨvwa ndɨnamba klandɨ. Ndɨna mbak kat kɨgɨnda kwiga vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ndɨ kɨgɨnda kai. Ndɨ kat ana kwilɨndi. Mbak kat kwilɨnda mi sɨk kɨvat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tɨga lɨga ndɨna maawupmba yelavɨtndɨ. Wun manda kat kumba kavle vat yetɨgowun. Wuna nyaekna njɨvwa kwutɨga nɨmba ndi kɨgɨnda nɨma sakwat tɨgandɨ. Wun kɨgɨnda tapman tɨga kiya mɨna lɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kan kava kwagalalaa wuna nyaek tɨga kava yiga ndɨ kat waigowun. Wun mɨn kat kavle vat yiwun. Wun God kat kavle vat yiwun. ");
INSERT INTO ian_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngi kat tɨga mɨna nyanat ngɨni ana lɨgiyowun. Wamɨn maa mɨna njɨvwa kwutɨga nyanat tɨgiyowun waa waigowun waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yelavɨtaa kan kava kwagalalaa nyaek tɨga ngepmat yindɨ. Ngepma ana wuleindɨ, sɨvlamba lɨndɨ, nyaek ndɨ kat vɨndɨ. Vɨlaa nɨma maawut yelavɨka pɨlɨga yiga ndɨ kat taamba kwutaa nyambupmba viyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kwutndɨ maa nyan ndɨ kat wandɨ. Nyaek mɨn kat kavle vat yiwun. God kat kavle vat yiwun. Ngi kat tɨga ngɨni mɨna nyanat ana lɨgiyowun waa wandɨ maa ndɨna nyaek wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wupma ke waa waa walaa ndɨna njɨvwa kwuta nɨmba kat wandɨ. Apma waavwi kwutaa ndɨ kat agwi ngwula. Apma taamba ring kalalaa ndɨna taambamba kwuso. Apma man su klalaa ndɨna mamba kwuso. ");
INSERT INTO ian_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Apma nyan bulmakau vatnyalaa kɨgɨnda agwut ngwula. Nɨn solat sɨga kapti kwukiyanɨn. ");
INSERT INTO ian_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wuna nyan tak kiya nyan vla lɨndɨ, ndɨ kat ana vɨga lɨwun. Ndɨ tamba yalaa lɨgandɨ. Tat sɨlɨwotndɨ. Mbambala tamba yalaa lɨgandɨ waa wandɨ maa solat sɨga kɨgɨnda kwutndi. ");
INSERT INTO ian_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Njambwi nyan ambugapmba njɨvwa kwuka lɨga njɨvwa ngɨlɨndɨ, ngay yandɨ. Ngay ngwaymba lɨga mbangu veinja vak wutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wutaa ndɨna nyaekna njɨvwa kwuta nyan kat mandana wutuwa waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wandɨ maa wandɨ. mɨna sambu tamba yandɨ. Yandɨ maa mɨna nyaek apma nyan bulmakau vatnyandɨ kɨgɨnda kwupmat. Yanda vak kat solat sɨga vatnyandɨ waa wandɨ njɨvwa kwuta nyan. ");
INSERT INTO ian_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nyamwun wutaa tɨpmwigwula yiga ngay wuleivak kat kai wandɨ. Ngi kat tɨga ndɨna nyaek wogwendɨ ndɨ kat wagalavat. ");
INSERT INTO ian_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wagalandɨ mala nyaek kat wandɨ. naambi nɨma sakwat wama njɨvwa mɨna kwutɨwun. Mɨn kat ana kavle vat yiwun. Mɨn kat ana kai wowun. Wuna alɨ nɨmba kat kɨgɨnda kwukwangat mat meme ana vatnyalaa wun kat kwimɨn. ");
INSERT INTO ian_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wuna sambu ndɨ kat kwima sanya sɨk yambɨsɨk yiga yaagindɨ. yandɨ maa ndɨ kat apma nyan bulmakau vatnyamɨn. Ana nglaatndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wandɨ mala nyaek wandɨ. Njɨmbla njɨmbla wunogwinala tɨlɨgamɨn. Kiyawun maa wuna nda aywaa klaigamɨn. ");
INSERT INTO ian_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mɨna sambu wupma kai. Ndɨ tamba kiyandɨ waa yelavɨka lɨwun. Mbambala kwo lɨgandɨ. Tat sɨlɨwotndɨ. Mbambala tamba yalaa lɨgandɨ. Ngi kat tɨga solat sɨga kɨgɨnda kwutneyan kavle vat ana ndɨ waa wandɨ nyaek waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas ndɨna mbaapma nɨmba kat wandɨ. Tamba nɨma sanya la nyan tɨndɨ. Wandɨ mala nat nyan ndɨna njɨvwa kat vɨga lɨndɨ. Nat nɨmba njambwi nyan kat wandi. Mɨna njɨvwa vɨga lɨga nyan kavle savle kwutɨgandɨ waa wandi, njambwi nyan ndɨna njɨvwa vɨga la nyan kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kavle savle kwutɨmɨn waa wandi, wutwun. Kwutɨma vak wun kat ambuk. Mbupmɨn mala sɨga naguga vɨgiyowun. Sɨga naguga vɨlaa ngɨni wuna njɨvwa kwukiyamɨn? E? Ana kwukiyamɨn? Waa njambwi nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wandɨ maa njɨvwa kwuta nyan maawupmba yelavɨtndɨ. Ndɨ kat mbukweyan kavle vat kwutuwa vak vɨlaa wun kat kai waigandɨ. Wun angamak yigiyowun. Wun ava lapman tɨga ambugatna njɨvwa ana alɨpsɨga kwukiyowun. Wun wup yigiyowun nat nyan kat kɨgɨnda kat wagalaweyan waa yelavɨka lɨga yindeya vat yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yiweya vak yiwun mala wun kat kai y wandɨ maa nat nɨmba wun kat kɨgɨnda kwigiyandi waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tat sanyo ta nyananamba nat nɨmba dinau klandi. Njɨvwa kwuta nyan wundi nɨmba kat yagwa wandɨ, yandi. Yandi maa ndi kat kɨta nyan kɨta nyan wandɨ. Tat ta nyan kat mɨna dinau angamak sakwat tɨgandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wandɨ maa 100 dram wel wandɨ. Wandɨ maa ndɨ kat wandɨ. Tamba mɨna dinau kwusenda taagagowun. 50 dram wel mɨna kwigiyamɨn waa njɨvwa vɨga la nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nat nyan kat mɨna dinau angamak sakwat tɨgandɨ waa wandɨ maa 100 bek rais wandɨ. Wandɨ maa tamba mɨna dinau kwusenda taagagowun. 80 bek rais mɨna kwigiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yinda vak njambwi nyan wutaa wandɨ. Apma vak kwunapmɨn. Mɨn kat kai wowun maa nat nɨmba dinau kusenda taagama nɨmba ngɨni mɨn kat ndinai kɨgɨnda kat vɨga lɨgiya waa wandɨ njambwi nyan waa wandɨ Jisas. Jisas ndi kat nat samat nyaangɨt wandɨ. Kan kɨpmana nɨmba ndi nambuo lɨga nɨmba ndi. Nat nɨmba kat kwunatɨnjan ngwuk wuna mbaapma nɨmba ngwuk kat kwulatɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ngwuk wuna mbaapma nɨmba ngwuk kat wowun. Mbambala kan kɨpmamba lɨngwan ngwutna sanya apma njɨvwamba agwuk ngwula. Sɨmblan ke yaagiga. Kɨpmana sanya ngwuk kat njɨmbla njɨmbla ana lɨgiyandɨ. Apma njɨvwa kwuka lɨngweyan sanya ngɨlɨndɨ maa ngɨni nyɨnangwupmba yiga apma vak njɨmbla njɨmbla tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nat nyan mat njɨvwa apma vat kwutɨndeyan wan nyan nɨma njɨvwa apma vat kwukiyandɨ. Nat nyan mat njɨvwa kavle vat kwutɨndeyan wan nyan nɨma njɨvwa kavle vat kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kan kɨpmamba lɨngwan kavle savle njɨvwa kwukngweyan ngɨni nyɨnangwut wokengwuk mala God ngwuk kat apma nɨma njɨvwa ana kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mbambala kɨpmamba lɨngwan Godna njɨvwa kavle savle kwuka lɨngweyan ngɨni nyɨnangwut wokelaa God ngwuk kat kwindeya njɨvwa apma vat ana kwukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kɨta nyan ana vɨlɨlɨk palɨna nyaangɨt wuka njɨvwa kwukiyandɨ. Nat kɨta nyan kat kai walaa nat nyana nyaangɨt mɨna wukiyandɨ. Ngwut kan kɨpmana njɨvwa kwuka Godna njɨvwa kwuka kɨta kɨta ana kwukiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kumba la Ferisi ndi kɨpmana nda kat mɨna yelavɨka lɨndi. Jisas waa nyaangɨt wutaa ndɨ kat njɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisas ndi kat wandɨ. Nat nɨmba ngwutna sɨ kwutaa katsonjangat woviyaguga lɨgangwuk. Ngwutna kavle maawut God vɨga lɨgandɨ. Kan kɨpmana nɨmba woviyaguga tɨnja vak kat God ana woviyaguga lɨgandɨ. God ndɨ kai walɨgangɨ kan vak kat. ");
INSERT INTO ian_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses kwiya nyaangɨt profet waa nyaangɨt God nɨn kat tak kwindɨ. Ngɨni ngu yagula Jon laataa God nɨn kat kwunataa vɨga lɨndeya vak mbutɨndɨ. mbutɨndɨ mala ngepma ngepmamba la nɨmba kan vak klavat sɨmblan nɨma njɨvwa kwutɨndi. ");
INSERT INTO ian_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","God tak kwiya nyaangɨt ana ngɨlɨgiyandɨ. Ana kwo vala tɨgiyandɨ. Kɨpma nyɨnangwut ngɨni ngɨlɨgiyandɨ. God tak kwiya nyaangɨt ana ngɨlɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisas wandɨ. Kɨta nyan ndɨna taagwa kat kwagalalaa nat taagwa klandeyan kavle vatna. Yambɨsɨk yilɨnja vak vla yilɨndɨ. Nat nyan ndɨna taagwa kwagalandɨ maa wat taagwa nat nyan klandeyan ndɨno kavle vatna. yambɨsɨk yilɨnja vak vla yilɨndɨ ndɨno waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas ndi kat nyaangɨt mbutndɨ. Nɨma sakwat sanyo la nyan tɨndɨ. Ndɨ apma nglei waavwi kwuso lɨndɨ. Nandinya nandinya nɨma kɨgɨnda apma kɨgɨnda mɨna kɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nat nyan sanya lapman nyan tɨndɨ. ndɨna sɨ Lasaras. Ndɨ sanya kat nat nɨmba kat yawiga wandɨ. Sanya lapman nyan ngwutnyala pulumba ndaa lɨndɨ. Ndɨna mbangɨ kawia nɨma sakwat kɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kɨlambɨnja nao kɨvak kwo kawiga lɨndɨ. Waala ndɨ kat yalaa ndɨna kawiya lɨk viyenga kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tɨga lɨga sanya lapman nyan kiyandɨ. kiyandɨ, ensel ndɨ kat kwutaa Ebraham ta kavat kalindi. Sanya la nyan ndɨno kiyandɨ, waangumba vaangundi. ");
INSERT INTO ian_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Vaangundi, ndɨ ya vɨtɨga kavat yindɨ. Ndɨna mbangɨ nɨmamba kangan wandɨ, Ebrahamagwi Lasaraso sɨvlamba lɨmbɨt, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ndɨ Ebraham kat nɨma kwundi walega wandɨ. Ebraham, wuna ngwak wun kat nɨma maawut yelavɨk. Wamɨn maa Lasaras ndɨna sɨt taamba ngumba taagalaa yaa wuna tɨgatmba taagandɨ. Wuna mbangɨ nɨmamba kangan walɨgandɨ waa wandɨ maa Ebraham ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Walanga, tak kɨpmamba lɨman apma nda mɨna klalɨmɨn. lasaras ndɨ kavle nda mɨna klalɨndɨ. Mbambala ndɨ apma vat tɨgandɨ, mɨn kavle vat tɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ana nɨndɨmba nɨma ndandangɨ kwaandɨ. Mɨn kat yindeya yambɨ kai. Nɨn kat yameya yambɨ kai. Ndandangɨ kwaandɨ waa wandɨ Ebraham. Wandɨ maa sanyo la nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ngwak, kɨta nyaangɨt mɨn kat wagalagiyowun. Lasaras kat wamɨn maa wuna nyaekna ngay yigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kan ngaymba wuna yakwa ndu tambanat tɨgandi. Ndi kat mbutndɨ maa wutaa tuwa kavle kava ana yaigandi waa wandɨ maa Ebraham ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tamba Moses kwiya nyaangɨt profet waa nyaangɨt ngɨlɨga. Kan nyaangɨt wutaa kavle vat kwagalalaa tɨma kavle kava ana yigiyandi waa wandɨ, sanya la nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Walanga Ebraham wupma kai. Wuna yakwa ndu tambanat tamba la nyaangɨt ana wukiyandi. Kɨta nyan kiyalaa laataa ndi kat mbutndeyan ndi kavle maawut kwagalalaa mandɨp kupi maawut klalaa apma vat yiga yetɨgiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wandɨ mala Ebraham ndɨ kat wandɨ. Wama vak ana nglaatndɨ. Tamba Moses kwiya nyaangɨt profet mbuta nyaangɨt wupmak kat kai wanjeyan kɨta nyan kiyalaa laataa ndi kat yiga mbutnjeyan ndɨno ndɨ kat wupmak kat kai waigandi waa wandɨ Ebraham waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ndɨna mbaapma nɨmba kat wandɨ. Ngɨni yaiga kavle vat yandɨ maa nat nɨma sakwat nɨmba kavle maawupmba yelavɨka kavle savle yiga yetɨgiyandi. Wan kavle vat yaigandɨ. Wan ngɨni yaiga kavle vat kwivat yalɨga nyan ndɨ kat miwa yigowun. Ndɨ kavle nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wan kavle vat kwivat yaiga nyan wandɨ maa wuna mbaapma nɨmbana maawut kavle yigiyandɨ. Tak ndɨna mbanjɨge nɨma kambak yaawmba tulaa nyingi ngumba yaaginjeyan wovuna. Ngumba yaaginjeyan ngɨni wuna mbaapma nɨmbana maawut ana kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ngwuk kavle vat kwivat yaiga nyan yeta vak vla wupma ke yetɨngwa. Ngwuk apma vak yetɨ ngwula. Ngwula mbaapmamba la kɨta nyan ngwuk kat kavle vat yindeyan ndɨ kat awa. Kavle vat yimɨn waa awa. Wangwuk maa wovun wangwuk. Ngwuk kat kavle vat yuwa vat tamba kwagalawun waa wandeyan ngwuk kat kavle vat yinda vak kat maawut ke yelavɨka. Kwagala ngwula. ");
INSERT INTO ian_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nandinya kɨta sɨla vɨli njambɨ ngwuk kat kavle vat yilaa kavle vat yuwa vat kwagalagiyowun waa wandeyan kavle vat yilɨnda vak kat kwagala ngwula. Ke yelavɨkngwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisasna mbaapma nɨmba ndɨ kat wandi. Mɨna nyaangɨt kat maawupmba yelavɨka kwuta lɨna vak matna. Nɨna maawut kwunapmɨn mala nɨman yigiyandɨ waa wandi maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wuna nyaangɨt maawupmba yelavɨka kwutaa lɨngweya vat tagula vatna. Tagula ava lɨga vatna. Mastet walɨnja mi sɨk mak glei nda. Tundi, nɨma ava yilɨgandɨ. Wuna nyaangɨt kat kwutaa lɨngwa vak mastet walɨnja sɨk vla tɨndeyan nɨma nglei njɨvwa kwukiyandɨ. Wangwuk mala kan tɨga vɨlɨngwa mi avla pɨtaa nyingi nguat yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisas wandɨ. Ngwutna kɨta nyan kwanda kwanda nda vla lɨga njɨvwa kwo kwuta nyan tɨndeyan wamɨn maa nandinya ambugatna njɨvwa kwupmat yigiyandɨ. Kwutaa bulmakau kat yuwi kalɨtaa kwigiyandɨ. Nglaambu njɨvwa ngɨlɨlaa kwagalalaa yandɨ, ndɨ kat kɨgɨnda kwukiyamɨn? Ndaa lɨga yaa agɨ waa waigamɨn? Kai. Wupma ana waigamɨn. ");
INSERT INTO ian_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kupma waigamɨn. Mɨn wuna kɨgɨnda kwutaa kiyaa taagamɨn kɨlu. Kɨwun maa ngɨni kɨgiyamɨn waa ndɨ kat waigamɨn. ");
INSERT INTO ian_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wama njɨvwa kwutndɨ maa ndɨ kat sɨvu kɨgiyamɨn? Kai luwa. Wan njɨvwa kwuta nyan mɨna kwanda kwanda nda vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nɨno nɨmbun. God wanda njɨvwa aywaa kwutaa ndɨ kat waiganɨn. Nɨn nɨma sakwat njɨvwa ana kwutnɨn. Apma vak ana kwutnɨn waa waiganɨn. ");
INSERT INTO ian_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tɨga lɨga Jisas Jerusalemat yindɨ. Yinda ava yambɨ kɨpma angangɨ tɨmbɨk nɨndɨmba yindɨ. Nat naangɨ Galili walɨnja kɨpma. Nat naangɨ Sameria walɨnja kɨpma. ");
INSERT INTO ian_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ngepma wuleilaa ndina mbangɨ aywaa kaawia kɨla tamba vɨli nɨmba sɨvlamba lɨndi, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ndi ndɨ kat vɨlaa nɨma kwundimba wandi. Jisas, njambwi nyan mɨn, nɨn kat nɨma maawut yelavɨp mɨla waa wandi maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ay ngwula. Ngwutna mbangɨ kwo lɨgiyandɨ. God kat kwunatɨga nyan kat ngwutna mbangɨ sɨmagangwuk mala apma vat tɨngwa vak nat nɨmba kat mbukiyandɨ waa wandɨ, yindi. Yilɨndi maa ndina mbangɨ apma vat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ndina kɨta nyan ndɨna mbangɨ kwo lɨnda vak vɨlaa lungwamataa yiga nɨma kwundimba Godna sɨ kwutaa katsondɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wan nyan yalaa Jisas kat sɨvu kɨvat kwali man sɨlaa ndɨ kat sɨvu kɨndɨ. Ndɨ Sameriana kapma ngepma nyana. ");
INSERT INTO ian_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas wandɨ. Kɨta nyan mɨna ana kwunakwun. Tamba vɨli nɨmbɨ andamapba lɨngandi. ");
INSERT INTO ian_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndi Godna sɨ katsovat ana lungwamataa yandi. Kan kapma ngepma nyan mɨna yandɨ waa walaa ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mɨn laataa ay mɨla. Wuna nyaangɨt wutaa maawupmba yelavɨka kwutaa lɨma vak mɨn kat kwunatndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","God ndinyangu kat vɨga lɨndeya vak anda njɨmbla yaigandɨ waa Ferisi wagalandi maa Jisas ndi kat wandɨ. God ndinyangu kat vɨga lɨndeya vat mɨnimba ana vɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kɨta nyan ana yandɨ vɨlaa waigandɨ. Angwiyan yaa vɨgowun waa ana waigandɨ. God ndinyangu kat vɨga lɨndeya vak ngwutna maawupmba lɨgandɨ waa ndi kat walaa ndɨna mbaapma nɨmba kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ngɨni yaiga njɨmbla nɨma sakwat kavle vat yaigandɨ. Ngwuk kat kwunapmak Godna vak sɨmogwi lɨga nyan kwakiyangwuk. Wun ana yaigowun. ");
INSERT INTO ian_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nat nɨmba ndino kwaka waigandi. Ngiya yaa. Anguvelia yaa waa waigandi. ndina nyaangɨt ke wuka. Ndina kwupmba ke yiga waa ngwuk kat wowun. ");
INSERT INTO ian_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wun Godna vak sɨmogwi lɨga nyan ngwuk kat kwunapmak yaweyan vlap vlap wandɨ, ya vla yaigowun. Yaweya njɨmbla kava kava kembagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tak wun kat nɨma vak yaigandɨ. Mbambala lɨga nɨmba tak wun kat kai waigandi. ");
INSERT INTO ian_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ndinyangu kat Godna vak sɨmogwiga kwunapmat yaweya njɨmbla kan kɨpmana nɨmba tamba Noa ta njɨmblamba kavle vat yiga yetɨnja vla yiga yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tamba God kat yelevɨtapman nao ngu kɨga taagwa klaga kwo yetɨndi. Tɨga lɨga Noa njaambɨt kundɨ maa nɨma sambiyangu yandɨ, kiyandi. ");
INSERT INTO ian_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tamba la nyan Lot ta njɨmbla wupma lɨndi. Ndi nao ngu kwo kɨndi. Wenga kwilaa klandi. Ambugatna njɨvwa kwo kwutndi. Ngay kwo kwutndi. ");
INSERT INTO ian_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tɨga lɨga Lot Sodom walɨnja ngepma wogwendɨ mala nyɨnangwupmba la ya vɨtɨga kambak ngepma ndaindɨ, ndi kiyandi. ");
INSERT INTO ian_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndinyangu kat Godna vak sɨmogwiga ndi kat kwunapmak yaweya njɨmbla wan vak tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wan yaiga njɨmbla sambangemba lɨgiya nyan ana ndaigiyandɨ ndɨna ngaymba lɨga kwanda kwanda klavat. Kwo yigiyandɨ. Ambugapmba tɨgiya nyan ndɨno ndɨna kwanda kwanda klavat ana yaigandɨ. Kwo yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tamba la nyan Lot ndɨna taagwa kavle vat yila vak kat yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wan yaiga njɨmbla kɨga nyan ndɨna mbangɨ ndɨna nda kat yelavɨka lɨndeyan ndɨ kavle yigiyandɨ. Kɨta nyan ndɨna mbangɨ ndɨna nda kat yelavɨtapman yindeyan ndɨ kwo lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wan yaweya njɨmbla ngay kɨta ndu vɨlɨlɨk kwaigambɨt. Yalaa nat nyan kat kwutaa kaligiywoun. Nat nyan tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wan yaweya njɨmbla taagwa vɨlɨlɨk kɨta kavamba njɨvwa kwukiyambɨt. Yalaa nat taagwa kat kwutaa kaligiywoun. Nat taagwa tɨgiyalɨ. ");
INSERT INTO ian_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Ndu vɨlɨlɨk ambugapmba lɨgiyambɨt. Yalaa nat ndu kat kwutaa kaligiyowun. Nat ndu tɨgiyandɨ waa wandɨ Jisas.) ");
INSERT INTO ian_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wandɨ mala ndɨna mbaapma nɨmba ndɨ kat wagalandi. Wama kavle vak anda kavamba kak kiyaigandɨ waa wagalandi, Jisas wandɨ. Nat tɨgiya kavamba kɨta nda wundumbu yilaa njangu veilɨndɨ, ambugavi vɨlaa njɨngwenga lɨga ndaiga veilaa kɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ndi kat pagwula la nyaangɨt mbutndɨ. God kat njɨmbla njɨmbla wagala lɨnjangat mbutndɨ. God kat wagalalɨnja vak kwagala lapman yinjangat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tamba nat ngepmamba jas kɨta lɨndɨ. Ndɨ God waa nyaangɨt ana wuka lɨndɨ. Nat nɨmbana nyaangɨt ana wutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kan ngepmamba la talagwa ndɨ kat yalaa walɨ. Kɨta nyan wun kat kavle vat yilɨgandɨ. Ndɨ kat kai awa walɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndɨ lɨla nyaangɨt ana wutndɨ. Lɨ njɨmbla njɨmbla yiga walɨlɨ. Tɨga lɨga kavle jas wandɨ. God waa nyaangɨt ana wuka lɨgowun. Nat nɨmbana nyaangɨt ana wuka ligowun. ");
INSERT INTO ian_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wat talagwa nɨma sakwat njambɨ wun kat walɨlɨ. Lɨla nyaangɨt nat njambɨ wupmak kat wuna mbangɨ kɨlɨpangɨ yigandɨ. Ngi kat tɨga lɨ kat kavle vat yila nyan kat kai waigowun waa wandɨ kavle jas waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mbutaa Jisas ndi kat wandɨ. Kavle jas waa nyaangɨt kat yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","12","God ndɨ kavle nyan ana ndɨ. Ndɨna nɨmba ndɨ kat nandinya ngan wagalanjeyan ndi kat kavle vat ya nɨmba kat God kai waigandɨ. Ndɨ ana wutapman kwo kawiga lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nat nyan takis sanya klalɨga nyan sɨvla kavamba lɨga nambu sɨlandalaa God kat wandɨ. Avla ndɨna sɨ lɨga nambu sɨlandalaa God kat wandɨ. Avla ndɨna sɨ viyesendaga mawlava viyaga wandɨ. Wun kavle nyan wun. Kavle vat yiluwa vak kat ke yelavɨka waa God kat wandɨ waa mbutndɨ Jisas. Mbutaa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngwuk kat wowun. God takis sanyo klalɨga nyan waa nyaangɨt wutaa ndɨ kat wandɨ. Kavle vat yilɨma vak kat ana yelavɨka lɨgowun. Kwagalagiyowun waa God wandɨ. Wandɨ maa ndɨna ngayat yindɨ. Ferisi wupma kai. God Ferisina kavle vak ana kwagalandɨ. Yinja vla nɨno wupma. Nɨn avla nɨna sɨ viyesendaneyan God kwutaa katsogiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nat nɨmba ndina mat nyangu kat Jisas kat kiyalɨndi. Ndina mbangɨmba taamba taagandangat kiyalɨndi. Jisasna mbaapma nɨmba kiyalɨnjangat kai wa wandi. Ke kiya waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kai wandi mala Jisas wupma ke waa mat nyangu agiya wandɨ. Mat nyangu wuna lak yaandi. Ndi kat kai ke waa. God vɨga lɨga nɨmba Godna mat nyangu vla lɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngwuk kat wowun. Mat nyangu nyaangɨt wutaa maawupmba yelavɨka nɨmamba kwutaa lɨgandi. Kwutaa lɨnja vak vla ngwuk kwutapman yingweyan God vɨga lɨga kava ana wuleigiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kan ngepmana njambwi nyan Jisas kat yalaa wandɨ. Nyaangɨt sɨmogwi lɨga nyan mɨn apma nyan mɨn. Anda njɨvwa kwutaa njɨmbla njɨmbla apma vak yetɨweya vak klaigowun waa wandɨ mala Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Apma nyan mɨn waa manda kat wun kat wamɨn. Kɨpmamba lɨga nɨmba apma nyan ana lɨgandɨ. Apma nyan kɨta lɨgandɨ. Ndɨ Godna. ");
INSERT INTO ian_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tamba Moses kwiya nyaangɨt vɨga lɨgamɨn. Yambɨsɨk yilɨnja vak ke yiga. Nat nyan kat ke vatnyaga. Nat nyana nda ke sɨkwuka. Nyaangɨt woseka ke waa. Nyaek nyɨmena nyaangɨt awuk waa tamba Moses pɨlɨwutndɨ. Mɨn wupma yigiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mat nyan tɨga wupma yilɨwun waa Jisas kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas wanda nyaangɨt wutaa ndɨ kat wandɨ. Apma vat kɨta ana yimɨn. Mɨna kwanda kwanda nda aywaa kwilaa sanya klalaa sanya lapman nɨmba kat agwi mɨla. Kwilaa wuna kwupmba yagwa. Wupma yimeyan mɨna nyinangwupmba lɨga wenga nda nɨma sakwat tɨgiyandɨ. Ngɨni nyɨnangwut yilaa klaigamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ndɨ Jisasna nyaangɨt wutaa ndɨna mbangɨ kɨlɨpangɨ yindɨ. Ndɨ Jisasna nyaangɨt wutaa ndɨna mbangɨ kɨlɨpangɨ yindɨ. Ndɨ nɨma sakwat kwanda kwanda ta nyana. ");
INSERT INTO ian_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ndɨna mbangɨ kɨlɨpangɨ yinda vak Jisas vɨlaa wandɨ. Nɨma sakwat sanya la nyan God vɨga lɨga kava wuleivat yindeyan nɨma njɨvwa. ");
INSERT INTO ian_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nɨma kamel waavwi tavalɨnja nilna yambɨ vla wuleivat yindeyan nɨma njɨvwa. Nɨma sakwat sanya la nyan God vɨga lɨga kava wuleivat yindeyan nɨma nglei njɨvwa. Kamel wuleigiya njɨvwa kat kwulatɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jisas waa nyaangɨt wuta nɨmba wandi. God vɨga lɨga kava kɨta nyan anda vapmba wuleigiyandɨ. Yambɨ kai kava kɨta nyan anda vapmba wuleigiyandɨ. Yambɨ kai waa wandi mala Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ndi ndina njɨvwamba ana wuleigiyandi. God ndi kat kwutaa kaliga taagagiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita laataa wandɨ. Nɨn kwanda kwanda nda aywaa kwagalalaa mɨna kwupmba yinɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wandɨ maa Jisas ndi kat wandɨ. Kɨta nyan wuna kwupmba yavat ndɨna ngepma, nyaek nyɨme, nyangu, yakwa nɨmba kat kwagalandeyan ");
INSERT INTO ian_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mbambala apma wenga nda klaigandɨ. Ngɨni njɨmbla njɨmbla apma vat yindeya vat klaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas ndɨna taamba vɨli kiyeli vɨlɨlɨk mbaapma nɨmba kat wandɨ. Jerusalemat wokegat. Wun Godna vak sɨmogwiya nyan yiweya vak kat tamba la profet pɨlɨwutndi. Tamba pɨlɨwutnja vak mbambala glei tamba kak kiyalɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wun kat kwutaa Juda ana ndi nat nɨmba kat kaligiyandi. Wun kat njɨka waigandi. Wun kat kavle vat yiga sɨpmiya saga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wun kat viyaga vatnyagiyandi. Kiyalaa nandinya kuvuk tɨga laakiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ndɨna mbaapma nɨmba mbuta nyaangɨt wutaa nyaangɨtna angwa ana yelavɨka lɨndi. Anda vak kat walɨgandɨ waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wata yilandi. Yiga Jeriko walɨnja ngepma ngwaymba yilɨndi. Way ava yambɨmba mɨni vɨlapman nyan ndaa lɨndɨ. Ndaa lɨga sanya kat yawilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nɨma sakwat nɨmba yalɨndi, wutndɨ. Wutaa nada kakna waa wagalandɨ, mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jisas Nasaret nyan ngi yaa. Ndɨna kwupmba nɨma sakwat nɨmba yalɨndi, wukamɨn waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mɨni vɨlapman nyan nɨma kwundimba walega wandɨ. Jisas Devitna yelangɨ nyan mɨn wun kat nɨma maawut yelavɨp mɨla waa walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jisasogwinala tata yila nɨmba ndɨ kat kai wandi. Makayak ke waa wandi. Ndɨ ndina nyaangɨt ana wutndɨ. Ndɨ walega wandɨ. Jisas Devitna yelangɨ nyan mɨn wun kat maawut yelavɨp mɨla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisas tamata ndɨ kat kwutaa agiya wandɨ. Kiyandi maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Manda yawangat wamɨn waa wandɨ, njambwi nyan wuna mɨni kwunapmangat wowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisas wandɨ. Mɨni vɨgiyamɨn. Njambwi nyanat tuwa vat mɨna maawupmba yelavɨtɨma vak mɨn kat kwunatndɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ndɨna mɨni vɨndɨ. Mɨni vɨga Jisasna kwupmba yiga Godna sɨ kwutaa katsondɨ. Va nɨmba ndino Godna sɨ kwutaa katsondi. ");
INSERT INTO ian_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yiga lɨga Jeriko walɨnja ngepma wuleindi. ");
INSERT INTO ian_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kan ngepmamba Sakias walɨnja nyan yetɨndɨ. Ndɨ takis sanya klalɨga nɨmbana njambwi nyana. Ndɨ nɨma sakwat sanya la nyana. ");
INSERT INTO ian_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas yandɨ, ndɨ kat vɨvat yindɨ. Ndɨ anda vat tɨga nyana waa yelavɨtaa ndɨ kat vɨvat yindɨ. Nɨma sakwat nɨmba yisolaa tɨndi, ana vɨndɨ. Ndɨ tambɨ nyana. ");
INSERT INTO ian_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yindeya yambɨmba tata pɨlɨga yiga Jisas yindeya yambɨ waymba la sikamoa walɨnja mi wokelaa kawiga kwandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas wan angwa mimba yaga yisoga vɨndɨ. Vɨlaa wandɨ. Sakias kwiyatapman ndai mɨla. Mbambala ngan mɨna ngaymba kwaigowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias kwiyatapman ndailaa solat sɨga Jisas ndɨna ngayat kalindɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nat nɨmba vɨlaa walɨndi. Jisas kavle vat yindɨ. Sakias kavle nyana. Manda kat ndɨna ngaymba kwavat yigandɨ waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngaymba lɨga Sakias Jisas kat wandɨ. Njambwi nyan kavle yetuwa vak kwagalagiywoun. Wuna kwanda kwanda nda mbaapma vɨlɨlɨk taagalaa nat mbaapma sanya lapman nɨmba kat kwigiyowun. Woseka waa klawa sanya awat ndi kat aynat njambɨ kwigiywoun waa wandɨ mala Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mbambala kavle vat kwagalalaa apma vat klamɨn. Tamba la nyan Ebraham apma vat yinda vla yilɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wun Godna vak sɨmogwi lɨga nyan wun. Wun kavle nɨmba kat kwaka kwunapmak ngaga yawun kan kɨpma. Apma nɨmba kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas waa nyaangɨt wutndi maa ndi kat pagwula la nyaangɨt mbutndɨ. Ndi Jerusalem ngwaymba tɨga, ndɨnogwi lɨga nɨmba yelavɨtndi. Samat tɨga Jisas laataa njambwi nyana njɨvwa kwuka ngepma ngepmana nɨmba kat vɨga lɨgiyandɨ waa yelavɨtndi. Yelavɨtnja vak wutaa Jisas yelavɨtndɨ. Yelavɨtnja vak ana nglaatndɨ. Samat tɨga njambwi nyana njɨvwa ana kwukiyowun. Ngɨni kwukiyowun waa yelavɨtaa Jisas ndi kat pagwula la nyaangɨt mbutndɨ. Mbuka wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tamba sɨvla kavamba la sanyo la nyan ndɨna angwa ngepma kwagalalaa nat kavat yivat wandɨ. Yindfa ngepmana njambwi nyan wandɨ maa ndɨna angwa ngepmana njambwi nyanat tɨgiyandɨ. Ngi kat tɨga ndɨ kat wagalavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ndɨna kat kɨta nyan kɨta nyan 20 dola 20 dola kwigiyowun. Ngwuk sanyamba njɨvwa kwukiyangwuk. Ngɨni ngwuk kat vɨvat yaigowun waa walaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yindɨ mala ndɨna nagwa ngepmamba la nɨmba wandi. Wan nyan nɨna njambwi nyanat tɨndangat njɨka kai wanɨn. Nat nɨmba kat wandi maa sanyo la nyana kwupmba yilaa ndɨ kat vɨlaa mbutndi. Mɨna angwa ngepma ndina njambwi nyanat tɨmangat njɨka kai wandi waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tɨga lɨga sanyo la nyan yandɨ. Nat ngepmana njambwi nyan wandɨ maa njambwi nyanat tɨndɨ. Yalaa ndɨna njɨvwa kwuta nɨmba kat yagwa wandɨ. Ngwuk kat kwiwa sanya angamak sakwat tɨgandɨ waa wagalandɨ, ");
INSERT INTO ian_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tat ta nyan laataa wandɨ. Kwima 20 dola njɨvwa kwukwun, tamba nɨman yindɨ. 200 dola ngi lɨga waa wandɨ. Njambwi nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Apma vak njɨvwa kwupmɨn. Mɨn kat mat njɨvwa apma vat kwutɨmɨn. Ngi kat tɨga ngepma tamba vɨli vɨga lɨgiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nat nyan laataa wandɨ. Njambwi nyan wun kat kwima 20 dola njɨvwa kwukwun tamba nɨman yindɨ. Mbambala 100 dola tɨgandɨ waa wandɨ, ");
INSERT INTO ian_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","njambwi nyan wandɨ. mɨn ngepma tambanat vɨga lɨgiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nat nyan laataa wandɨ. Wun kat kwima 20 dola ngiyan tɨga. Waavwimba ngilaa pagwuwun. ");
INSERT INTO ian_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mɨn kat vaaka lɨwun. Mɨn kao mbundɨ nyan mɨn. Nat nyan yisoga taaganda nda mɨna kao sɨgɨtɨgamɨn. Ngi kat tɨga kwo pagwuwun, tɨgandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","njambwi nyan wandɨ. Mɨn kavle vat yɨmɨn. Kao mbundɨ tuwa vak vɨga lɨgamɨn. Nat nyan yisoga taaganda nda kwo klaluwa vak vɨga lɨgamɨn. Nat nyan ambugapmba tunda nda kwo sɨgɨtuwa vak vɨga lɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sanya manda kat kwo kwuta lɨmɨn. Bengmba taagageman samat nɨman yigendɨ. Kavle vat yimɨn waa walaa ");
INSERT INTO ian_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","kumba la nat nyan kat wandɨ. Ndɨna 20 dola kwutaa 200 dola lɨga nyanat agwi waa wandɨ, ");
INSERT INTO ian_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","nat nɨmba wandi. Wama vak ana nglaatndɨ. 200 dola tamba kwutaa lɨgandɨ. Manda kat nat 20 dola ndɨ kat agwi wamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Njambwi nyan wandɨ. Kavle vat ana ndɨ. Yiluwa vat kɨngiyandɨ. Kwutaa la nyan ndɨ kat kwigiyowun. Kwutapman nyan ndɨna mat nda ndɨnamba klalaa nɨma sakwat kwuta la nyan kat kwilɨgowun. ");
INSERT INTO ian_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wun kat tak kai waa nɨmba nɨna njambwi nyanat ana lɨgiyandɨ waa wun kat waa nɨmba kat kwutaa agiya. Kiyalaa ndi kat vɨga lɨwun, vatnyagiyangwuk waa wandɨ njambwi nyan waa mbutndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wapuseput mbutaa Jisas Jerusalemat wokendɨ. Ndɨna mbaapma nɨmba ndɨna kwupmba wokendi. ");
INSERT INTO ian_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yiga lɨga Betfasi walɨnja ngepma Betani walɨnja ngepma ngwaymba lɨndi. Oliv walɨnja nduwi ngwaymba lɨga Jisas ndɨna mbaapmamba la vɨlɨlɨk palɨ kat tata ay wandɨ maa tata yimbɨt. ");
INSERT INTO ian_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jisas mbɨk kat wandɨ. Ngwaymba lɨga ngepma wulei mbɨla. Wuleilaa yaawmba ngɨnja donki vɨgiyambɨk. Ndɨ nyan donkia. Ndɨna mbunimba ndu nyan ana ndaa lɨndɨ. Ndɨ kat yaaw njalataa agiya. ");
INSERT INTO ian_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kɨta nyan mbɨk kat manda kat yaaw njalatɨgambɨt waa wandeyan ndɨ kat awamba mbɨt. Njambwi nyan wandɨ maa njalatɨgaa waa awa waa Jisas wandɨ maa yimbɨk. ");
INSERT INTO ian_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","33","Ngepma wuleilaa Jisas waa kwanda kwanda vɨmbɨt. Vɨlaa donkina yaaw njalatɨmbɨt maa donki vɨga la nyan yalaa wandɨ. Manda kat yaaw njalatɨgambɨk waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","njambwi nyan wandɨ, njalatɨgaa wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ndɨ kat walaa Jisas kat kalimbɨt. Donkina mbunimba ndina alagu waavwi taagalɨndi, Jisas donkina mbunimba ndaa lɨndɨ. Ndaa lɨga Jerusalemat yindi. ");
INSERT INTO ian_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yilɨnja ava yambɨ nat nɨmba ndina alagu waavwi taagalɨndi donki veindangat. ");
INSERT INTO ian_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliv walɨnja nambu nduwimba lɨga ngepma ndaivat yilɨndi, ndɨna mbaapma nɨmba nɨma sakwat yalaa nɨma kwundimba solat sɨga Godna sɨ kwutaa katsolɨndi. Tak Jisas nɨma njɨvwa kwunata njɨvwa kwutndɨ, vɨlaa solat sɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kupma walɨndi. God wandɨ maa Jisas nɨna kingat tɨvat yandɨ. Apma vatna. Nyɨnangwupmba lɨga njambwi nyan nɨn kat apma vat yindɨ. Ndɨna sɨ kwutaa katsolɨganɨn waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Walɨnja nyaangɨt wumba la Ferisi wutaa Jisas kat wandi. Sɨmogwi lɨga nyan mɨna mbaapma nɨmba kat makayak waa awamba mɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wandi maa Jisas ndi kat wandɨ. Ndi kat wupma makayak waga waweyan kan tɨga kambak wuna mbaapma nɨmba walɨga vak waigandi waa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ngepma ngwaymba lɨga ngepma vɨlaa ngepma nɨmba kat nɨma maawut yelavɨka nglaga wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tak apma vat yiga yetɨnjeya vak ana vɨga lɨngwuk. Mbambala ngepma wuleiwun, vɨga lɨngweya wovuna. Ana vɨga lɨgiyangwuk. Vɨlɨgowun. Ngwuk mɨni vɨlapman nɨmba vla lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ngɨni yaiga njɨmbla ngwuk kat sɨvat yilɨga nɨmba yaigandi. Yalaa ngepma wegwuga waangu vigiyandi. Vandi maa ana ngepma wogwegiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ngwuk kat aywaa sɨgiyandi. Nɨma nɨmba mat nyangu taagwa aywaa sɨgiyandi. Ngepma sulɨgiyandi. Sulɨndi maa ngay kambak nat kambatna tagumba ana lɨgiyandɨ. Kapma kapma lɨgiyandi. God wandɨ maa ngwuk kat kwunapmat ywwa vak vɨlapman tɨlɨgangwuk. Ngi kat tɨga kavle vat ngwuk kat yagandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ngepma yilaa Godna ngay wuleindɨ. Kan ngaymba nat nɨmba wenga kwiga klalɨndi. Jisas wuleilaa ndi kat kwutaa kɨkliga wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tamba wan ngay kat God wandɨ maa pɨlɨwutndi. Wuna ngay wuleia nɨmba wun kat ngambuvat wuleigiyandi waa wandɨ God waa tamba pɨlɨwutndi. Ngwuk wupma kai. Nat nɨmbana nda sɨkwuka wenga kwiga klalɨgangwuk waa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisas nandinya nandinya Godna ngay wuleilaa nyaangɨt mbutɨndɨ. God kat kwunatɨga njambwi nɨmba, Moses kwiya nyaangɨt sɨmogwi la nɨmba, nat njambwi nɨmba ndi Jisas kat vatnyavak yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Vatnyanjeya vak ana yelavɨka lɨndi. Nat nɨma sakwat nɨmba Jisas waa nyaangɨt wupmat woviyaguga lɨndi. Njambwi nɨmba wundi nɨmba kat vaaka lɨga Jisas kat vatnyanjeya vat ana yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nat nandinya Jisas Godna ngay wuleilaa ndinyangu kat wan apma nyaangɨt mbutɨndɨ. Mbutɨndɨ mala God kat kwunatɨga njambwi nɨmba, Moses kwiya nyaangɨt sɨmogwi la nɨmba, nat njambwi nɨmba ndɨ kat yalaa wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kanda wandɨ maa njɨvwa kwuka nyaangɨt mbutɨgamɨn waa wandi maa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wun kat tamba wagalangwuk. Ngwuk kat kɨta nyaangɨt wagalagiyowun. Awat wangwuk maa ngwuk maa ngwuk kat awat waigowun. ");
INSERT INTO ian_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ngu yagula Jon kanda wandɨ maa ndinyangu kat ngu yagulɨndɨ. God wandɨ? E? Kɨpmana nyan wandɨ? Waa ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wagalandɨ maa ndi awat sowat ngambulɨndi. God wandɨ, Jon ndinyangu kat yagulɨndi waa waneyan ndɨ nɨn kat waigandɨ. Ngwuk manda kat yagulapman tɨgangwuk waa waigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kɨpmana nyan wandɨ maa Jon dinyangu kat yagulɨndɨ waa waneyan kan nɨma sakwat nɨmba kambak yaagiga nɨn kat vatnyagiyandi. Wundi nɨma sakwat nɨmba yelavɨtɨgandi. Jon God waa nyaangɨt mbutɨndɨ waa yelavɨka lɨgandi waa awat sowat ngambulaa Jisas kat wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ana vɨga lɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisas ndi kat wandɨ. Ngwuk kat wagalawa nyaangɨt ana awat wangwuk. Wuno wun kat wagalangwa nyaangɨt ana awat waigowun. Wandɨ, njɨvwa kwutuwa nyana sɨ ana mbukiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas kumba la nɨmba kat pagwula la nyaangɨt mbutɨndɨ. Tamba la kɨta nyan ambugat kwutndɨ. Kwutaa nat nɨmba kat vɨga lɨnjangat walaa sɨvla kavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kwanda kwanda pɨlɨnja njɨmbla ndɨna njɨvwa kwuta nyan kat wandɨ, ambugatna nat nda klavat yindɨ. Ambugat yandɨ, vɨga la nɨmba ndɨ kat viyaga savlɨndi. Ambugatna nda ana klandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tɨga lɨga ambugatna njambwi nyan ndɨna njɨvwa kwuta nat nyan kat wandɨ, yindɨ. Yindɨ, ndɨ kat njɨka waga viyaga savlɨndi, yindɨ. Ambugatna nda ana klandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tɨga lɨga ambugatna njambwi nyan ndɨna njɨvwa kwuta nat nyan kat wandɨ, yindɨ. Ndɨno ndɨ kat viyaga savɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tɨga lɨga njambwi nyan yelavɨtndɨ. Wun angamak yigiyowun. Wuna nyan kɨta lɨgandɨ. Ndɨ kat wowun maa yigiyandɨ. Wuna nyanat tɨnda vak vɨlaa ndɨna nyaangɨt wukiyandi waa yelavɨtaa ay wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ambugat vɨga la nɨmba nyan vɨlaa wandi. Ambugatna njambwi nyan kiyandɨ, wan nyan ambugat kaligandɨ. Ndɨ kat vatnyaneyan nɨna lak klaiganɨn waa walaa ndɨ kat savlɨlaa vatnyandi. ");
INSERT INTO ian_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ambugatna njambwi nyan wutaa ndi kat yalaa vatnyagiyandɨ. Ndi ngɨni ambugatna njɨvwa ana kwukiyandi. Njambwi nyan wandɨ maa nat nɨmba kwukiyandi waa wandɨ maa wuta nɨmba wandi. God nɨn kat nɨma vat yilandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","17","Wandi maa Jisas wandɨ. Nɨma vak yigiyandɨ luwa. God ngɨni ndinyangu kat yigiya nɨma vak tamba la nɨmba pɨlɨwutndi. Kupma pɨlɨwutndi. Kambapmba ngay kwuta nɨmba nat kambak ngaymba taagavak kat kai walaa yaagindi. God yalaa yaaginja kambak kwutaa mɨndama ngemba taagandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kɨta nyan kan kambak kat kai walaa man veindeyan ndɨ ndaiga kavle yigiyandɨ. Kambak ana kavle yigiyandɨ. Tagula kambakna. Kan kambak ndaiga kɨta nyan kat viyandeyan ndɨ mbaw vla lɨga nɨmamba ndɨ kavle yigiyandɨ waa tamba pɨlɨ wutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","God kat kwunatɨga njambwi nɨmbo Moses kwiya nyaangɨt sɨmogwi la nɨmbo wutaa Jisas kat walealɨndi. Ndi wutaa yelavɨtndi. God ngɨni ngwuk kat nɨma vak yigiyandɨ waa nɨn kat wupuseput mbuka wandɨ walaa yelavɨtaa Jisas kat walealɨndi. Walea lɨga ndɨ kat vaaka lɨga ndɨ kat ana kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Njambwi nɨmba Jisas yiga mbutɨnda vak yiga wuka vɨga lɨndi. Wandi mala ndina mbaapma nɨmba Jisas kat wagalvat yindi. Wagalangwuk mala ndɨ kavle nyaangɨt awat wandeyan ndɨ kat kwutaa kotmak kali ngwula waa wandi, yindi. Jisas kat yilaa mɨna mbaapma sɨvat yanɨn waa ndɨ kat woseka wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ndɨ kat woseka waga walɨndi. Njambwi nyan mbutɨma nyaangɨt apma nyaangɨtna. Vɨlɨganɨn. Kan kɨpma nɨmbana nyaangɨt ana wutaa ndina kwupmba yilɨgamɨn. Mɨn God waa nyaangɨt mɨna savagu butɨgamɨn. Mɨn God waa nyaangɨt mɨna savagu mbutɨgamɨn. Vɨlɨganɨn. ");
INSERT INTO ian_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mɨn kat kɨta nyaangɨt wagalagiyanɨn. Gavmana njambwi nyan Sisa ndɨ kat takis sanya kwineyan wovuna? E? Kai? Waa woseka wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Woseka wagalanja vak vɨga ndɨna maawupmba yelavɨtaa wandɨ. Manda kat wun kat wagalangwuk. ");
INSERT INTO ian_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Wun kat sanya agwi wandɨ, kwindi. Jisas sanya kwutaa lɨga ndi kwa waa wandɨ maa Sisanana wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jisas ndi kat wandɨ. Kat sanya Sisana nda. Takis sanya kat wagalandeyan ndɨna nda ndɨ kat agwi ngwula. Godna nda God kat kwigiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wanda nyaangɨt wutaa kavle vat vɨlapman tɨga ngɨpaliga ndalaa kwundi awat ana wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi walɨnja mbaapmana nat nɨmba Jisas kat wagalavat yandi. Kiya nɨmba ngɨni ana laakiyandi waa ndina mbbapma nɨmba yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yalaa wandi. Njambwi nyan, tamba Moses nɨn kat pɨlɨwutndɨ. Nyamwun wat taagwa kat klalaa nyan tapman tɨga lɨga kiyandeyan ndɨna sambu wat taagwa klalaa nyan njaangɨ waa pɨlɨwutndɨ Moses. ");
INSERT INTO ian_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tamba yakwa ndu sɨla vɨli tɨndi. Ndina njambwi nyan taagwa klalaa nyan tapman tɨga lɨga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kiyandɨ, ndɨna kwupmba la nyan klandɨ. Tɨga lɨga ndɨno nyan tapman tɨga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kiyandɨ maa ndɨna kwupmba la nyan kuvuk wan nyan wat taagwa kat klandɨ. Tɨga lɨga nyan tapman tɨga kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndi aywaa kiyandi mala wat taagwa kiyalɨ. ");
INSERT INTO ian_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wundumbu ya nɨmba laatnjeya njɨmbla kana taawat tɨgiyalɨ. Tat ndu sɨla vɨli lɨ kat kalandi waa Jisas kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas ndi kat wandɨ. Kan kɨpmamba tɨga nɨmba ndi taagwa klalɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","God woviyaguga tɨnda nɨmba ndi nyinangwut wokegiyandi. Ngɨni kiya nɨmba laakiyandi. Ndi nyɨnangwupmba lɨga taagwa ana klalɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndi ana wundumba yigiyandi. Ensel yetɨnja vla yetɨgiyandi. Ndi kiyalaa laataa Godna nyanguat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kiya nɨmba ngɨni laaiyandi. Moses wupma mbuka pɨlɨwutndɨ. Tamba Moses ya vɨtɨga mi vɨlaa God kat wandɨ. Ebraham Aisak Jekop mɨna kwundi wuka lɨgandi. Mɨn ndina njambwia waa tamba wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God kiya lɨga nɨmbana njambwi nyan ana ndɨ. Ndɨ kwo lɨga nɨmbana njambwi nyana. Ngi kat tɨga Ebraham Aisak Jekop ana kiyalaa lɨgandi. Kiyalaa laatndi. Vɨlɨganɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moses kwiya nyaangɨt sɨmogwi la nat nɨmba wutaa wandi. Njambwi nyan ngiyambak wama waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wandi maa nat nɨmba ndɨ kat wagalavak kat vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tɨga lɨga Jisas ndi kat wagalandɨ. Kraist walɨna nyan God wandɨ, ndinyangu kat kwunapmak yaa nyan ndɨ Devitna mat nyana waa manda kat walɨgandi. Ana nglaatndɨ walɨnja vak. ");
INSERT INTO ian_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit ndɨno Sam walɨnja nyaangɨpmba God Kraist kat wanda nyaangɨt pɨlɨwutndɨ. God wuna njambwi kat wandɨ. Njɨvwa kwagalalaa wuna yaagindan naangɨmba kwo ndaa alɨ mɨla. ");
INSERT INTO ian_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ndaa lɨmɨn maa mɨn kat kao yilɨga nɨmba mɨn kat tɨga kwulakiyowun waa God wandɨ waa pɨlɨwutndɨ Devit. ");
INSERT INTO ian_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit Kraist kat waga wuna njambwi waa pɨlɨwutndɨ. Kraist Devitna mat nyana waa manda kat walɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jisas ndɨna mbaapma nɨmba kat wandɨ. Nat nɨmba ndino wutndi. ");
INSERT INTO ian_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Moses kwiya nyaangɨt sɨmogwi la nɨmba yetɨnja vla ke yetɨngwa. Kavle vatna yetɨnja. Ndi apma nglei waavwi kwusoga nɨma sakwat nɨmba tɨga kava yilɨgandi. Nɨma sakwat nɨmba ndi kat ngwuk apma nɨmba waa wanjangat yilɨgandi. Yisolaa lɨnja ngay wuleilaa nujambwi nɨmba ndaa lɨla kavamba ndaa lɨgandi. Nɨma kɨgɨnda ta ngay wuleilaa njambwi nɨmba ndaa lɨla kavamba ndaa lɨgandi. ");
INSERT INTO ian_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ndi talagwana kwanda kwanda nda sɨkwutɨgandi. Kapmba laataa God kat sɨvla nyaangɨt ngambulɨgandi nat nɨmba vɨnjangat. Ngɨni yaiga njɨmbla God ndi kat nɨma vat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas Godna ngaymba lɨga God kat sanya kwilɨga nɨmba kat vɨndɨ. Nat nɨma sanya la nɨmba nɨma sakwat sanya kwindi, vɨnɨdɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tɨga lɨga sanya lapman talagwa yalaa mat sanya vɨlɨlɨk kwilɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas lɨ kat vɨlaa wandɨ. Kat sanya lapman talagwa nat nɨmba kat kwulaka kwilɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nat nɨmba nɨma sanyo lɨga sakwat kwindi. Lɨ sanya lapman tɨga lɨla sanya aywaa kwilɨ. Kɨgɨnda klaleya nat sanya kai waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Godna ngaymba lɨga nat nɨmba wandi. Kan ngay apma ngaya. Apma kambapmba kwutndi. Nat nɨmba apma yelaga nda kwilɨndi, taagandi ngaymba waa wandi maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Vɨlɨngwa ngay ngɨni yaiga njɨmbla sulɨgiyandi. Sulɨndi maa nat kambak nat kambakna tagumba ana lɨgiyandɨ. Aywaa sulɨgiyandi waa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wandɨ maa ndɨ kat wandi. Njambwi nyan wama vak anda njɨmbla yaigandɨ. Anda nda tak vɨneya. Vɨlaa wanda vak kɨngiyan tamba ngway tologa waiganɨn waa wagalandi maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngɨni nɨma sakwat nɨmba yalaa wun Kraist wun waa woseka waigandi. Ndi kat ke wukngwa. Nɨma sakwat nɨmba yalaa ngɨni lɨga vat tamba ngway tolagandɨ waa woseka waigandi. Ndi kat ke wukngwa. Ndina kwupmba ke yiga. ");
INSERT INTO ian_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ngɨni nɨma sakwat nɨmba kao yilɨnja vak wukiyangwuk. Nat ngepma nɨmba kat sɨlɨnja vak wukiyangwuk. Wutaa mandɨp mandɨp ke yelavɨkngwa. Kan vak tak yaigandɨ. Ngɨni lɨga nandinya wata. ");
INSERT INTO ian_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nat ngepma nat ngepma kat sɨvat laakiyandi. Nat kava nat kava kat sɨvat laakiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kava kava nɨma yɨnau kwukiyandɨ. Nat nɨmba kɨgɨnda lapman tɨga kiyaigandi. Nat ngepma ndina nɨmba aywaa yelogwen kat tɨgiyandi. Nyɨnangwupmba lɨga nda vɨlaa nat nɨma sakwat nɨmba vaakiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wan wawa vak yalapman tɨndɨ, tat ngwuk kat kwutaa viyaigandi. Ngwuk kat kavle vat yigiyandi. Ngwuk kat kotmak yisolaa lɨnja ngay kaligyandi. Ngwuk kat kalabusmba taagagiyandi. Wuna njɨvwa kwukngwuk maa ngwuk kat kwutaa kotmak njambwi nɨmba kat kaligiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngwuk kat kwutaa kalinja vak vɨlaa nat nɨmba waigandi. Ndi kwutaa kalia nɨmba Godna njɨvwa kwutɨgandi waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ngwuk kat kotmak kalɨnjeya njɨmbla ndi kat awat wangweya vak nɨmamba ke yelavɨkngwa. ");
INSERT INTO ian_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Awat wangweya nyaangɨt wuna lak kwigiyowun. Ngwuk kat mbukweya nyaangɨt waigangwuk. Wangwuk, wutaa ngwuk kat kai walɨga nɨmba ana ngwuk kat kwulakiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngwutna nyaek nyɨme, yakwa nɨmba, ngepma nɨmba, alɨ nɨmba ngwuk kat kai walaa kotmak kaligiyandi. Ngwutna nat nɨmba kat kalilaa vatnyagiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wuna njɨvwa kwutɨngwangat nat nɨma sakwat nɨmba ngwuk kat kai waigandi. ");
INSERT INTO ian_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngwuk kat kavle yindi maa ngwuk kavle kavat ana yigiyangwuk. Apma kavat yilaa apma vat tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ngɨni yaiga njɨmbla wun kat kwagalalapman yingweyan njɨmbla njɨmbla apma vat yetɨngweya vat klaigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jisas wandɨ. Nat ngepmana kao yilɨga nɨmba Jerusalem yalaa ngepma wegwundi, vɨlaa Jerusalem kavle yi mɨna lɨgandɨ waa yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Judia walɨnja nɨma kɨpmamba lɨgiya nɨmba aywaa nduwiat ay ngwula. Ngwuk aywaa Judia kwagala ngwula. Wan yaiga njɨmbla nat ngepma nɨmba Judia mbaa yalandi. ");
INSERT INTO ian_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngɨn kavle nɨmba kat sɨgiyowun waa God wandɨ, tamba la nɨmba pɨlɨwutndi. Yaiga njɨmbla ndɨ sɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wan njɨmbla nyan tɨga ndi taagwa kat nɨma miwa yiga tɨgowun. Wan njɨmbla nyan mbambala glei kwukna ndi taagwa mwunya kɨlɨga ndi nyangu kat miwa yiga lɨgowun. Kan kava nɨma sakwat nɨma vat tɨgiyandɨ. God ndinyangu kat nɨmamba sɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nat nɨmba kat yapmba kalɨka vatnyagiyandi. Nat nɨmba kat kandi kwutaa kaligiyandi. Kalindi maa kava kavamba yetɨgiyandi. Juda ana ndi nat nɨmba Jerusalem kat vɨga lɨgiyandi. Vɨga lɨnjeya sɨva ngɨlɨndɨ, Juda lungwamataa yaa vɨga lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nya, mbak, sɨngwut mandɨp mandɨp mbangɨ nyɨnangwupmba tɨndɨ, vɨgiyandi. Vɨlaa ngɨpaliga ndaigandi. Kɨpmamba lɨgiya nda nɨmbun vɨlaa ngɨpaliga ndaigandi. Kava kavamba nɨma sakwat nɨma vak tɨgiyandɨ. Mandɨp mandɨp maawut yelavɨka lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nɨma sakwat wan vak vɨlaa vaaka lɨgiyandi. Nyɨnangwupmba lɨga nda, nya, mbak, sɨngwut yilɨnja yambɨ kwagalalaa mandɨp mandɨp yigiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tɨga lɨga wun Godna vak sɨmogwi lɨga nyan tɨmbumba ngaga yawun, vɨgiyangwuk. Wun nɨma kwonduo tɨga nyan vla yaigowun. Wun kat vɨlaa ndɨ nɨma nyana waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wan nda kak kiyandɨ, ngwuk wuna mbaapma nɨmba solat asɨ ngwula. Wan nda kak kiyandɨ, ndi apma vat tɨgiyandi waa ndi kat walaa ");
INSERT INTO ian_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","sɨmogwi lɨga wapuseput mbutndɨ. Fik walɨnja mio nat mi kat yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ndɨna kupi kwin wogwendeyan nya nɨmamba sɨgiyandɨ waa yelavɨka lɨgangwuk. Ngwutna ngepma vatna. ");
INSERT INTO ian_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wawa nyaangɨt kɨta vatna. Wawa vat vɨlaa God ngaga yalaa nɨn kat vɨga lɨndeya njɨmbla tamba ngway tologandɨ waa yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ngwuk kat wowun. Tak mbambala kan kɨpmamba lɨga nɨmba ndi ana ngɨlɨgiyandi. Tak wawa vak tɨndɨ, vɨlaa ngɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngɨni nyɨnangwuk kɨpma ngɨlɨgiyandɨ. Wawa nyaangɨt ana ngɨlɨgiyandɨ. Kwo lɨgiyandɨ. Vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ngwuk avla ngwula maawut kat yigumba avɨ ngwula. Wawa nyaangɨt kat maawut ke tɨvɨga. Nɨmamba nɨma ngu kɨga tungwengwan yiga ke lɨngwa. Wan kɨpmana nda kat mɨna ke yelavɨkngwa. Wan kɨpmana nda kat mɨna yelavɨka lɨngweyan wan yaiga nda pagwuga yaigandɨ. Ana vɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kan kɨpmamba tɨgiyaa kwo nɨmba ndi kat pagwuga yaigandɨ. Ndi ana tak vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ngwuk wan yaiga vak kat kawiga alɨ ngwula. Kawiga lɨga God kat wagala ngwula. Nɨn kat ava kwimɨn maa wan kavle vat ana nɨn kat kavle yigiyandɨ waa God kat wagala ngwula. Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni wun yaweya njɨmbla God ngwuk kat vɨlaa apma nɨmba ngwuk waa wambandɨ walaa God kat wagala ngwula waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nandinya nandinya Jisas Godna ngay wuleilaa ndi kat nyaangɨt mbutɨndɨ. Ngan wogwelaa Oliv walɨnja nduwi wokelaa sɨndu kwandɨ. ");
INSERT INTO ian_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ngambi glei nɨma sakwat nɨmba Godna ngay wuleindi Jisas waiga nyaangɨt wupmat wuleindi. ");
INSERT INTO ian_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yis tapman bret-nao kɨlɨnja pesto pasova walɨnja pesto tamba ngway tologandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","God kat kwunatɨga njambwi nɨmbagwi Moses kwiya nyaangɨt sɨmogwi la nɨmbogwi Jisas kat vatnyavat tɨndi. Jisas kat woviyaguga la nɨma sakwat nɨmba kat vaaka lɨga anda vapmba ndɨ kat vatnyagiyanɨn waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jisasna mbaapmamba la tamba vɨli kiyeli vɨlɨlɨk nɨmbana kɨta nyan Judas Iskeriot Seten ndɨ kat tavindɨ mala kamwin kwivat yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","God kat kwunatɨga njambwi nɨmbagwi soldiana njambwi nɨmba kat yindɨ. Yilaa Jisas kat vatnyangweya vat vɨsɨmogwigiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wandɨ, wutaa solat sɨlɨndi. Ndɨ kat sanya kwindi, vatnyangjeya vak kat ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jisas kapma lɨndɨ, ndɨ kat kwutaa kalingweya vat vɨsɨmogwigiyowun waa wandɨ Judas. ");
INSERT INTO ian_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis tapman bret-nao kɨlɨnja nandinya yandɨ. Wan naninya nyan sip sip kat vatnyandi kɨvat. ");
INSERT INTO ian_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas Pitogwi Jon kat wandɨ. Yiga kɨgɨnda agwup mbɨla. Kwupmbɨk, kɨmbanɨn waa wandɨ, wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Anda kavamba kwukiyaa waa wambɨt, Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ngepma wuleilaa ngu awmba tulaa kwutaa yila nyan kat vɨgiyambɨt. Ndɨna kwupmba ay mbɨla. Wuleindeya ngaymba vɨlaa wuleimba mbɨt. ");
INSERT INTO ian_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wan ngayna njambwi nyan kat awa mbɨla. Njambwi nyan wandɨ. Wunogwi wuna mbaapma nɨmbo pestona kɨgɨnda kɨneya kava andamba lɨgandɨ waa wandɨ waa awamba mbɨt. ");
INSERT INTO ian_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wambɨt maa awlak ngemba lɨga kava vɨsɨmogwigiyandɨ. Wan kava tɨgɨt njamba tɨgiyandɨ. Wan kava wuleilaa kɨgɨnda agwup mbɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wandɨ maa yimbɨt. Jisas waa nyaangɨt vla tɨndɨ, vɨmbɨt. Wanda kava wuleilaa kɨgɨnda kwupmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasovana kɨgɨnda kɨlɨnja njɨmbla tamba yandɨ. Yandɨ, Jisasna tamb vɨli kiyeli vɨlɨlɨk nɨmba Jisasogwio kɨta vat ndaa lɨmbɨt kɨgɨnda kɨvat. ");
INSERT INTO ian_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ndaa lɨndi, Jisas ndi kat wandɨ. Kan pestona kɨgɨnda tak ngwutnogwinala kuwa vak apma vatna. Wun woviyaguga lɨgowun. Ngɨni nɨma sakwat nɨma vak wuna lak yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kan pestona kɨgɨnda nat njambɨ ana kɨgiywoun. Kiyalaa God vɨga lɨga kava wuleilaa nat njambɨ pestona kɨgɨnda kɨgiyowun waa walaa ");
INSERT INTO ian_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","wain walɨnja nɨma ngu lɨga aw kwutaa God kat sɨvu kɨga ndi kat kwiga wandɨ. Kanjaga agɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wun ngɨni nɨma ngu ana kɨgiyowun. Kiyalaa God vɨga lɨga kava wuleilaa nat njambɨ kɨgiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bret-nao kwutaa God kat sɨvu kɨga lɨmbalaguga ndi kat kwiga wandɨ. Kan wuna mbanga kwiwa. Ngwuk kat kwunapmak wuna mbangɨ kwigiyowun. Kan bret-nao kɨga ngwuk kat kwunakweya vak kat yelavɨk ngwula waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kɨgɨnda kɨndi maa nat njambɨ wain walɨnja nɨma ngu lɨga aw kwutaa wandɨ. Kan ngu God ndinyangu kat kwilɨga kupi nyaangɨtna. Wuna yelogwen ngwuk kat tɨga ndaindɨ, wan kupi nyaangɨt tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngwuk awuk ngwula. Wun kat sɨnjangat kamwin kwiya nyan kumba nɨnogwinala kɨta vat tɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wun ndinyangu kat Godna vak sɨmogwi lɨga nyan wun. Ngɨni yiweya vak tamba God vɨndɨ. Pagwula la vat ana ndɨ. Wun kat sɨnjangat kamwin kwiya nyan ndɨ kat nɨmamba miwa ay ngwula waa wandɨ mala ");
INSERT INTO ian_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ndi awat sowat ngambulɨndi. Ndɨ kat sɨnjangat kamwin kwiya nyan anda nyana waa sowat ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasna mbaapma nɨmba walega ngambulɨndi. Nɨna anda nyan nɨna mbaapmana njambwi nyanat tɨgiyandɨ waa walega ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisas ndi kat wandɨ. Juda ana ndi nat nɨmba ndina njambwi nɨmba tɨgandi. Ndina njambwi nɨmba nat nɨmba kat nɨmamba njɨka viyaga viɨga lɨga nɨna njɨvwa agwuk ngwula waa walɨngandi. Wundi mat nɨmba kat kwunapmak vɨga lɨganɨn waa woseka walɨngandi njambwi nɨmba. ");
INSERT INTO ian_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ndina njambwi nɨmba vɨga lɨnja vak ngwuk wupma nat nɨmba kat ke vɨga lɨngwa. Ngwutna kɨta nyan njambwi nyanat tɨvat wandeyan mat nyan yetɨlɨga vak vla yetɨgiyandɨ. Nat nɨmbana kwundi wuka ndina njɨvwa kwutɨga nyan ndɨ njambwi nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kan kɨpmana nɨmba wawa vak vla ana yelavɨtɨgandi. Ndi kupma yelavɨtɨgandi. Kɨgɨnda kwutaa kansaga kwila nyan kwo ndaa lɨga kɨgɨnda ka nyana kwupmba lɨgandɨ waa yelavɨtɨgandi. Ngwuk yelavɨtnja vak wupma ke yelavɨkngwa. Wuno wupma ana yelavɨɨgowun. Wuna njɨvwa kwukngwangat ana yawun. Ngwutna njɨvwa kwupmat yawun. ");
INSERT INTO ian_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wun kat kavle vat yindi, ngwuk wun kat ana kwagalangwuk. Wunogwinala kɨta vat yetɨngwuk. ");
INSERT INTO ian_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngi kat tɨga nat nɨmba kat vɨga lɨngweya kwondu ngwuk kat kwigiyowun. Wuna nyaek wun kat kwinda kwondu ngwuk kat kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngɨni God vɨga lɨga kava wuleilaa ndinyangu kat vɨga lɨgiyowun. Kan kava kwukweya nɨma kɨgɨnda wunogwinala kɨgiyangwuk. Ngwuk Judana taamba vɨli kiyeli vɨlɨlɨk yelangɨ nɨmba kat vɨga lɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas Pita kat wandɨ. Saimon, mɨno nat mbaapma nɨmbo Seten ngwuk kat kavle maawut kwivat wandɨ. Ngwuk kat nɨma vat yivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wun God kat mɨn kat tɨga wagalagiyowun. Mɨna maawupmba kwutaa lɨma vak mbaa kwagalalamɨn waa God kat wagalawun. Yimeya kavle vat yilaa wan kavle vat kwagalalaa mɨna mbaapma nɨmbana maawut kat kwunakiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wandɨ maa Pita wandɨ. Nɨma nyan, yimeya kavle vat manda kat wamɨn. Mɨn kat kwutaa kalabusmba taagandeyan mɨnogwinala yigiyowun. Mɨn kat vatnyanjeyan wuno wun kat vatnyagiyandi. Ana vaaka lɨgowun waa wandɨ Pita ");
INSERT INTO ian_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas ndɨ kat wandɨ. Pita mɨn kat nyaangɨt kɨta waigowun. Awup mɨla. Jisas kat ana vɨgowun waa woseka waigamɨn. Njambɨ kuvuk waigamɨn. Wamɨn mala tak nyaaga viyaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas ndɨna mbaapma nɨmba kat wandɨ. Tak ngwuk kat wowun mala yɨmbwi sanya man su kalilapman kwo yingwut. Yingwa njɨmbla kɨta nda kat kwaka yingwuk? Wagalandɨ maa kai waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wandi maa wandɨ. Ngɨni wupma kai. Kɨta nyan yɨmbwi tɨndeyan kwutaa kaligiyandɨ. Sanya lɨndeyan kwutaa kaligiyandɨ. Yak tapman tɨndeyan alagu waavwi kwilaa sanya klalaa yak kɨta kaligandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tamba la nɨmba God waa nyaangɨt pɨlɨwutnja vak wuna lak yaigandɨ. Kavle nɨmba kat yilɨnja vak vla Kraist kat yilɨndi waa tamba pɨlɨwutndi. Wan pɨlɨwutnja vak vak wuna lak yaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wandɨ maa ndɨna mbaapma nɨmba wandi. Njambwi nyan nɨn yak vɨlɨlɨk kwutaa lɨganɨn waa wandi, wan ngiyambak wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngepma wogwelaa Oliv walɨnja nduwi wokendɨ. Ndɨna mbaapma nɨmba ndɨna kwupmba wokendi. ");
INSERT INTO ian_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nduwi wokelaa ndɨna mbaapma nɨmba kat wandɨ. Ngwutna maawut kavle vat mbaa yilandi waa God kat wagala ngwula waa walaa ");
INSERT INTO ian_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ndi kat kwagalalaa samat yindɨ. Sɨvla ana lɨ. Yilaa kwali mamba sɨlaa God kat walɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nayaek, wamɨn maa wuna lak yaiga kavle vat ana yaigandɨ. Wawa vapmba ke yiga. Mɨna maawupmba ay. Walapman yimeyan mɨna sɨpana waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Jisas walɨndɨ maa nyɨnangwupmba lɨga ensel ngaga yalaa Jisas kat kwondu ava kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas nɨma vak yelavɨka lɨga God kat nɨmamba wagalalɨndɨ. Wagalalɨga ndɨna mbangɨ kangan wandɨ, nɨma waangɨt sawndɨ.) ");
INSERT INTO ian_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wagalalaa laataa ndɨna mbaapma nɨmba ta kavat yindɨ. Sɨndu kwandi, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Vɨlaa ndi kat wandɨ. Manda kat sɨndu kwalɨgangwuk. Laataa God kat wagala ngwula. Ngwutna maawut kavle vat mbaa yiland waa wagala ngwula waa Jisas ndi kat sɨvululaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas walɨndɨ maa nɨma sakwat nɨmba yandi. Jisasna mbaapmamba la nyan Judas ndɨ tata yandɨ. Nat nɨmba ndɨna kwupmba yandi. Jisas kat ndɨna kɨpmwi wusɨpmak yandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisas ndɨ kat wandɨ. Judas wun Godna vat sɨmogwi lɨga nyan wun. Wun kat kwutaa kalinjangat wusɨkamɨn? Waa Jisas wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ndɨna mbaapma nɨmba Jisas kat yinjeya vak vɨlaa wandi. Njambwi nyan yak kwutaa ndi kat viyagat? Waa wandi, ndina ");
INSERT INTO ian_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","kɨta nyan yak kwutaa laataa God kat kwunatɨga njambwi nyana njɨvwa kwutɨga nyana waan kalɨtndɨ. Yaagindan naangɨmba tɨga waan kalɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jisas wupma ke yiga waa walaa waan ta kava taamba taaga kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kwunataa God kat kwunatɨga njambwi nɨmbagwi, Godna ngay vɨga lɨga nɨmbo, Judana njambwi nɨmba kat Jisas wandɨ. Yak mi kwutaa waleavat yalɨgangwuk. Sɨkwutɨga nyan kat kwutɨnja vla wun kat kwupmak yalɨgangwuk. Manda kat wupma yalɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tak nandinya nandinya ngwutnogwinala Godna ngaymba lɨlɨwun. Tak wun kat kalivat ana yalɨngwuk. Ngwuk kavle nɨmba wun kat kwulakngweya njɨmbla mbambala waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas kat kwutaa God kat kwunatɨga njambwi nyana ngayat kalindi. Tata yindi, Pita ngɨni la yilɨndɨ. Ndɨna ngwaymba ana yilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kwo alagumba lɨga nɨmba mbangɨ ya tolapmak ya salɨndi. Salɨlaa kɨta vat ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ndaa lɨndɨ maa kan ngayna njɨvwa kwuta taagwa nyan kɨta ndɨna mɨndama vɨga walɨ. Kan nyan tak Jisasogwio tɨndɨ waa walɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Walɨ maa Pita wandɨ. Taagwa nyan kai. Jisas kat ana vɨga lɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tɨga lɨga nat nyan Pita kat vɨlaa wandɨ. Mɨn Jisasna mbbapma nyan mɨn? Waa wagalandɨ maa Pita kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Samat tɨga nat nyan Pita kat vɨlaa wandɨ. Wan nyan tak Jisasogwionala tɨndɨ. Vɨwun. Mbɨt kɨta ngepma nyan mbɨt. Galili nyan mbɨt waa wandɨ maa Pita ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wan angamak waamɨn. Ndɨ kat ana vɨga lɨgowun waa wandɨ maa tak nyaaga viyandɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Viyandɨ maa Jisas Pita kat lungwamaka vɨndɨ. Vɨndɨ, tak Jisas Pita kat wanda nyaangɨt kat Pita yelavɨtndɨ. Tak wun kat kuvut njambɨ kai waigamɨn. Wamɨn maa tak nyaaga viyaigandɨ waa wanda vak Pita yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yelavɨka lɨga Pita nɨmamba nglaga wogwendɨ. ");
INSERT INTO ian_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisas kat kwuta la nɨmba ndɨ kat njɨka waga taambamba viyalɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ndɨna mɨni waavwi ngilaa mɨndamamba viyaga walɨndi. Tamba la profet mbutnja vla mɨn kat viyalɨga nyana sɨ ambuk waa kasega walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nat nɨma sakwat kavle vat ndi kat yilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngambi ndandɨ, Judana njambwi nɨmba yisolaa lɨndi. God kat kwunatɨga njambwi nɨmba, Moses kwiya nyaangɨt sɨmogwi la nɨmba aywaa yisolaa lɨga Jisas nɨn kat agiya wandi. ");
INSERT INTO ian_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Jisas wuleindɨ maa ndɨ kat wagalandi. Mɨn God wandɨ, yaa nyan mɨn? Kraist mɨn? Waa wagalandi maa Jisas ndi kat wandɨ. Wun Kraist wun waa wagewan ngwuk ana wukengwuk. ");
INSERT INTO ian_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngwuk kat nyaangɨt kɨta wagalagewan ngwuk ana awat wagengwuk. Wun kat ana kwagalangwuk, kwo yigiyowun. Manda kat wagalangweya vat awat waigowun. Kai wowun. ");
INSERT INTO ian_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wun Godna vak sɨmogwi lɨga nyan wun. Ngɨni God tɨga kava yilaa ndɨna yaagindan naangɨmba ndaa lɨwun, wun kat ndɨna kwondu kwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wandɨ maa wandi. Mɨn Godna nyan mɨn? Wandi 70 maa ngiyambak wangwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wandɨ maa wandi. Nat nɨmba nyaangɨt mbutnjangat ana waiganɨn. Wun Godna nyan wun waa ngiyambak kavle vat mbuta waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yisola la nɨmba laataa Jisas kat kwutaa Pailat walɨnja njambwi nyana ngayat kalindi. ");
INSERT INTO ian_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kalilaa Pailat kat wandi. Ndɨ Juda kat kavle maawut kwilɨgandɨ. Njambwi nyan Sisa kat takis sanya ke kwiga waa walɨngandɨ. Sisa njambwi king ana ndɨ. Wun njambwi king, Kraist wun waa walɨgandɨ waa Pailat kat woseka wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wandi mala Pailat Jisas kat wagalandɨ. Mɨn Judana njambwi king mɨn waa wagalandɨ, Jisas wandɨ. Mɨn mɨnayɨ wupma waa. ");
INSERT INTO ian_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailat God kat kwunatɨga njambwi nɨmbogwi nat nɨmba kat wandɨ. Jisas ndɨ kavle vat ana yindɨ. Vɨga lɨgowun waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wandɨ maa ndi nɨma kwundimba walega wandi. Kai Judana ngepma ngepma yiga kavle maawut ksilɨgandɨ. Galili laataa yiga kavle maawut kwiga kumba tɨna kavat yandɨ waa Pailat kat walega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Galili laataa waa walɨnja nyaangɨt wutaa Pailat ndi kat wagalandɨ. Ndɨ Galili nyana waa wagalandɨ, awa wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Njambwi nyan Herot Galili nɨmba kat vɨga lɨgandɨ waa yelavɨtaa Jisas kat kwutaa Herotna ngayat kali ngwula waa wandɨ. Wan njimbla Herot Jerusalemba tɨndɨ. Sivla kavat ana kalindi. ");
INSERT INTO ian_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kalindi, Herot Jisas kat vɨlaa solat sɨlɨndɨ. Tak Jisas kwuta nɨma njɨvwa wutndɨ. Ndɨ kat vivat woviyaguga lɨndɨ. Jisas kwuta nɨma njɨvwa kɨta Herot vɨvat woviyaguga tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ndɨ Jisas kat nɨma sakwat nyaangɨt wagalandɨ. Jisas ndɨ kat ana awat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","God kat kwunatɨga njambwi nɨmbogwi Moses kwiya nyaanɨt sɨmogwi la nɨmbo laataa nɨma kwundimba Jisas kat kavle nyaangɨt ngambundi. ");
INSERT INTO ian_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herotnogwi ndɨna soldia dino Jisas kat njɨtɨndi. Njambwi nɨmba kwusolɨnja apma waavwi ndɨ kat kasega kwusondi. Kwusolaa Pailatnat kalindi. ");
INSERT INTO ian_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tamba Pailatnogwio Herotnogwi walaa lɨmbɨk. Wan nandinya kɨmbɨk kwupmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat wandɨ maa God kat kwunatɨga njambwi nɨmba, Judana nat njambwi nɨmba, nat nɨmba yaa yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yandi maa Pailat ndi kat wandɨ. Wan nyan Juda kat kavle maawut kwilɨgandɨ waa walaa wun kat kiyangwuk. Ndɨ kat wagalalaa wangwa vat kavle yinda vat ana vɨga lɨgowun. Ndɨ kavle vat ana yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wowun maa Herotnat kalingwuk Herot ndɨno kavle vat yinda vat ana vɨga lɨndɨ. Ndɨ kavle vat and yindɨ. Ndɨ kat manda kat vatnyavat wangwuk. Ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngi kat tɨga ndɨ kat viyalaa kwagalgiyowun waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kan Pailatna vatna naambi naambi pestona njɨmbla kalabusmba la kɨta nyan kat kwagalalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kwagalgiyowun waa wandɨ maa ndi wandi. Kai ndɨ kat ke kwagalaga. Nat nyan Barabas ndɨ kat kwagala mɨla waa wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wan nyan Barabas tamba gavman kat kao yilɨndɨ. Kao yiga lɨga kɨta nyan kat vatnyandɨ, kalabusmba ndɨ kat taagandi. ");
INSERT INTO ian_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wandi maa Pailat Jisas kat kwagalavat ndi kat nat njambɨ wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ndi walega wandi. Diwai krosmba ndɨ kat kaala. Diwai krosmba ndɨ kat kaala waa walega wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat laataa ndi kat kuvut wan njambɨ wandɨ. Kavle vat yinda vat anda vatna. Kavle vat yinda vat ana vɨga lɨgowun. Ndɨ kavle vat ana yindɨ. Ndɨ kat manda kat vatnyagiyowun. Ndɨ kat viyalaa kwagalagiyowun waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ndi nɨma kwundimba walega walɨndi. Ndɨ kat diwai krosmba kaala waa walɨndi. God kat kwunata njambwi nɨmbogwi nat nɨmba walega walɨnja vat Pailat kat kwulatndi. ");
INSERT INTO ian_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ndɨ kat kalilaa ngwutna maawupmba vatnyagiyangwuk waa Pailat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tamba gavman kat kao lɨga nat nyan kat vatnya la nyan kalabusmba tɨga nyan Pailat wandɨ maa ndɨ kat kwagalandi. Juda wandi maa ndɨ kat kwagalandi. Jisas ndi kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisas kat kwutaa kaliga nat kɨta nyan kat vɨndi. Ndɨna sɨ Saimon. Ndɨna ngepmamba lɨga Jerusalemat yalɨndɨ, vɨndi. Ndɨ kat kwutaa kiwai kros ndɨna nyambupmba taagandi, walalaa kalindɨ. Ndɨ Jisasna kwupmba yiga walalaa kalindɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɨma sakwat nɨmba ndu lagwa ndɨna kwupmba yiga nglalɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas lungwamaka taagwa kat vɨga wandɨ. Judana taagwa ngwuk wun kat ke ngla lɨngwa. Ngwuk avla angla ngwula. Ngwutna nyangu kat angla ngwula. ");
INSERT INTO ian_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngɨni yaiga kavle njɨmbla kupma waigandi. Nyan kwutapman taagwa, nyan mwunya kwilapman taagwa apma vat tɨgandi waa ngɨni waigandi. ");
INSERT INTO ian_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ngɨni yaiga kavle njɨmbla njduwi kat waigandɨ. Nɨn kat ndaiga tegɨlɨndɨ, wundumba yigiyanɨn. Mat nduwi kat waigandi. Nɨn kat kapmandɨ, pakwulaa apma vat tɨgiyanɨn waa waigandi. ");
INSERT INTO ian_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wun kavle vat ana yiwun. Mbambala wun kat nɨma vat yilɨgandi. Ngwuk kavle vat yilɨngangwuk Ngɨni ngwuk kat nɨma vat yigiyandi. Ngwuk kat yinjeya nɨma vat nɨmana. Mbambala wun kat yilɨnja nɨma vak matna waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jisasogwinala kavle vat ykla mbɨt nyan kalindi. Mbɨk kat vatnyavat kalindi. ");
INSERT INTO ian_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nambu ava walɨnja kava yalaa Jisas kat diwai krosmba kaalandi. Kavle vat yila mbɨt nyan mbɨk kat angangɨmba kaalandi, lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kaalandi maa Jisas God kat wandɨ. Nyaek wun kat kavle vat yilɨnja vak kwagala mɨla. Ndina maawut ana yelavɨka lɨgandi waa wandɨ. Nat nɨmba satu kasega kwulata nyan Jisasna waavwi klandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nɨma sakwat nɨmba yisoga vɨlɨndi. Judana njambwi nɨmba ndino vɨlɨndi. Vɨga kasega walɨndi. Jisas nat nɨmba kat kwunapmat tɨndɨ. Mbambala manda kat avla ndɨna mbangɨ ana kwunatɨgandɨ. Ndɨ God wandɨ, yaa nyan ana ndɨ. Ndɨ Kraist ana ndɨ waa kasega walɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldia ndino kasendi. Kavle njangu veilɨga ngu Jisas kɨnda kat kwilɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kwiga walɨndi. Mɨn Judana king ana mɨn waa kasega wandi. ");
INSERT INTO ian_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Diwai krosmba nyaangɨt pɨlɨwutaa taagandi. Ndɨ Judana kinga waa pɨlɨwutaa taagandi. ");
INSERT INTO ian_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kavle vat yila mbɨt nyana kɨta nyan diwai krosmba lɨga Jisas kat kasega wandɨ. Mɨn Kraist tɨgeman avla mɨna mbangɨ kwunataa an kat kwunakemɨn waa kasega wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nat naangɨmba la nyan ndɨ kat kai walaa wandɨ. Manda kat wupma walɨgamɨn God kat ana vaaka lɨgamɨn? Mɨn ana kiyaigamɨn? ");
INSERT INTO ian_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kavle vat yiliangat vatnyagiyandi. Ndɨ wupma kai. Ndɨ kavle vat ana yindɨ waa nat nyan kat walaa Jisas kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Njambwi nyan kingat tɨmeya njɨmbla wunkat maawut ke tɨvɨga waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mɨn kat woseka ana wowun. Mbambala wunogwinala nyinangwupmba tɨgiyamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nya nɨndi nambɨtɨ, kulun wandɨ. Kulun walaa tɨga lɨga 3 klok nglaambu ngɨlɨndɨ, nya sɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kulun wandɨ, Godna ngay njambia la kava tɨvɨnda nɨma waavwi avla ngɨlɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisas nɨma kwundimba walega wandɨ. Nyaek wowun mala wuna wundumbu mɨnai lɨga kavat yigandɨ waa walaa wundumbu yindɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Vɨga la njambwi soldia kiyanda vak vɨlaa Godna sɨ kwutaa katsolaa wandɨ. Wan nyan kavle nyan ana ndɨ. Apma vat yeta nyana waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yalaa va nɨmba vɨlaa kavle vat yindi wandi. Ndina maawut viyalɨndɨ, yindi. ");
INSERT INTO ian_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisasna alɨ nɨmbogwi Galilimba lɨga ndɨna kwupmba ya tagwo sɨvlamba laataa lɨga vɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Judana njambwi nyan kɨta lɨndɨ. Ndɨna sɨ Josep. Ndɨ apma nyana. Ndɨ God waa nyaangɨpmba yetɨlɨga nyana. ");
INSERT INTO ian_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Tat Judana njambwi nɨmba yisolaa Jisas kat vatnyagiyamɨn waa wanja njɨmbla ndɨ kat kai wandɨ. Ndɨna ngepma Arimatia. Ndɨ God ndinyangu kat vɨga lɨndeya njɨmbla kat kawiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wan nyan Pailat ta ngay wuleilaa Jisasna sɨm kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ndɨ wokelaa kwutaa klanda kalɨndɨ kɨpmat. Klanda kalilaa waavwimba mbaataa kaliga kambapmba vanja waangumba taagandɨ. Kan waangumba tak ndu nyana sɨm ana taagandi. Kupi waangua. ");
INSERT INTO ian_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndɨna sɨm waangumba taaganda nandinya njɨvwa lapman nandinya kat kwanda kwanda kwunatɨnja nandinya. ");
INSERT INTO ian_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilimba lɨga Jisasna kwupmba yaa taagwa Josepna kwupmba yiga taaganda waangu vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vɨlaa lungwamataa yindi. Ndɨna sɨmba salapmat apma njangu weilɨga ngwaat klavat yindi. Yilaa nat nandinya ana yandi. Njɨvwa lapman nandinya. Ndi kwo lɨndi. Tamba Moses kwiya nyaangɨpmba kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande ngambi ngan wat taagwa laataa tak yisoga taaganja apma njangu veilɨga ngwaat kwutaa waanguat yindi. Nat taagwa ndino yindi. ");
INSERT INTO ian_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tak waangu tɨvɨnja kambak kwo kavamba tɨndɨ, vɨndi. Waangu ana tɨvɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Waangu wuleilaa njambwi nyan Jisasna sɨm ana vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mandɨp mandɨp yelavɨtaa sawun mbangɨ waavwi kwusolaa la mbɨt vɨlɨlɨk palɨ kat vɨndi. Mbɨtna waavwi kembandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vɨlaa vaaka lɨga nambu sɨlandalaa lɨndi. Vɨlɨlɨk palɨ ndi kat wambɨt. Kan kava kiyala nɨmbana kava. Kumba kwo lɨga nyan kat manda kat kwatɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ndɨ kumba ana lɨgandɨ. Tamba laataa yindɨ. Tak Galilimba tɨga ngwuk kat mbutɨnda nyaangɨt ana yelavɨka lɨgangwuk? ");
INSERT INTO ian_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tak Jisas ngwuk kat wandɨ. Wun ndinyangu kat kwunatɨga nyan. Wun kat kavle nɨmba kwutaa diwai krosmba kaalagiyandi. Kiyalaa lɨga kuvuk wan nandinya laakiyowun waa tamba ngwuk kat wandɨ waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wambɨt maa tak Jisas wanda nyaangɨt kat yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Waangu kwagalalaa lungwamataa yiga Jisasna mbaapmamba la tamba vɨli kiyeli kɨta nɨmba kat mbutndi. Nat nɨmba nɨmbun kat mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vɨlaa mbuta taagwa kɨkɨyak Magdala walɨnja ngepmamba lat Maria, Joana, Jemisna nyime nat Maria, nat taagwa. Ndi vɨlaa Jisasna mbaapma nɨmba kat mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mbutndi, wutaa woseka wandi waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","(Pita wutaa laataa waanguat pɨlɨga yindɨ. Yilaa tambɨlalaa yisolaa vɨndɨ. Sɨm ana vɨndɨ. Tat mbaatnja waavwi mɨna tɨndɨ, vɨndɨ. Vɨlaa mandɨp mandɨp yelavɨtaa yindɨ.) ");
INSERT INTO ian_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jisasna mbaapma nyan vɨlɨlɨk Jerusalem kwagalaa Emeas walɨnja ngepmat yimbɨt. Wan ngepmana yambɨ sɨvla ana ndɨ. Mail sɨla vɨli mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yiga lɨga Jerusalemba ta vak kat ngambuga yilɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ngambuga yilɨmbɨk, Jisas mbɨla ngwaymba mbɨlogwio kɨta vat yalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jisas kat mɨni mɨna vɨmbɨt. Ana yelavɨpmbɨk. God mbɨk kat mandɨp maawut kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas mbɨk kat wandɨ. Yiga lɨga manda vak kat mbangɨ kɨlɨpangɨ yiga ngambulɨgambɨt waa wandɨ, ");
INSERT INTO ian_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","vɨlɨlk palɨna kɨta nyan wandɨ. Ndɨna sɨ Kliopas. Jerusalemba tɨga mbambala nglei yamɨn? Jerusalemba ta vak ana wupmɨn? Waa wandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Anda vatna. Ana wukwun waa wandɨ, wambɨt. Jisas ndɨ Nasaret nyan ndɨ God waa nyaangɨt mbuta nyan. Ndɨ profetna. Ndɨ apma nyaangɨt ndinyangu kat mbutɨndɨ. Ndi kat nɨma njɨvwa kwuka ndi kat kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","God kat kwuntɨga njambwi nɨmbo nɨna ngepmana nat njambwi nɨmbo ndɨ kat kwutaa vatnyavak kalindi. Kalilaa ndɨ kat kiwai krosmba kaalandi. ");
INSERT INTO ian_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tak yelavɨtnɨn. Nɨn Juda kat kwunapmak yandɨ waa yelavɨka tɨnɨn. Wupma kai. Ndɨ kat vatnyandi. Nangaytmba vatnyandi. ");
INSERT INTO ian_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nɨna mbaapmana taagwa mbambala ngambi ngan waangu la kava yilaa yalaa nɨn kat mbunja nyaangɨt wutaa ngɨpaliga nda nɨn. ");
INSERT INTO ian_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ndɨna sɨm waangumba ana lɨgandɨ. Kwo waangua. Ensel vɨlɨlɨk nɨn kat tamba laataa yindɨ waa wambɨt maa wundi lagwa yaa nɨn kat mbutndi. ");
INSERT INTO ian_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mbutndi maa nɨna mbaapmana nat nɨmba waangu yilaa vɨndi. Taagwa woseka ana wandi. Kwo waangua. Jisas kat kwatevila lɨndi waa Jisas kat wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wambɨt maa Jisas mbɨk kat wandɨ. Mbɨla maawut yigumba ana yelavɨka lɨgambɨt. Tamba la profet pɨlɨwutnja nyaangɨt maawupmba ana kwutaa lɨgambɨt. Maawupmba ana yelavɨk lɨgambɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tamba pɨlɨwutndi. Kraist ndɨ tat kiyaigandɨ. Kiyalaa apma kava tɨndeya kava yigiyandɨ waa tamba pɨlɨwutndi waa mbɨk kat walaa ");
INSERT INTO ian_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tamba Moseso profetno nat nɨmbo Kraist kat pɨlɨwutnja nyaangɨt aywaa mbɨk kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yiga lɨga Emeas walɨnja ngepmat yandi. Jisas mbɨk kat kwagalalaa yivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mbɨk kai wambɨt. Tamba ngana. Anogwinala sɨndu kwalinjeya ngaymba kwaigamɨn waa wambɨt maa ngay wuleindi. ");
INSERT INTO ian_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kigɨnda kɨvat yindi. Yiga Jisas bret-nao klalaa God kat sɨvu kɨlaa mbɨk kat lɨmbala kwindɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kwindɨ maa ndɨna mɨndama vɨga maawut yelavɨpmbɨk. Ndɨ Jisas waa yelavɨpmbɨk maa mbɨk kat kwagalalaa kwo sɨlawota yindɨ. Ana vɨmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yindɨ maa awat sowat ngambuga tɨmbɨt. Tak yambɨmba an kat tamba la nɨmba pɨlɨwutnja nyaangɨt mbutɨndɨ maa ana maawut viyalɨndɨ. Apma nyaangɨtna waa yelavɨtaa waa walaa ");
INSERT INTO ian_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","laataa Jerusalemat lungwamataa yimbɨt. Yimbɨt, Jisasna mbaapmamba la tamba vɨli kiyeli kita nɨmba yisolaa lɨndi, vɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jisas tamba laataa kwo lɨgandɨ. Saimon ndɨno ndɨ kat vɨndɨ waa ndi kat wambɨt. ");
INSERT INTO ian_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jisas mbɨk kat yambɨmba mbutnda nyaangɨt, bret-nao kwutaa lɨmbala mbɨk kat kwinda vat aywaa mbupmbɨk. ");
INSERT INTO ian_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mbutɨmbɨk mala Jisas sɨlawota yandɨ. Yanda vat ana vɨndi. Ndɨna nɨndɨmba tɨndɨ, vɨndi. Laataa ndi kat apma vat alɨ ngwula wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ndi Jisas kat vɨlaa kan wundumbua waa vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jisas ndi kat wandɨ. Manda kat vaaka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wun wundumbu ana wun. Wuna man taamba avɨ. Wuna mbangɨ agwuk. Mbangɨ ava tuwa vat wundumbu wupma ana lɨgandi waa walaa ");
INSERT INTO ian_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(ndɨna man taambana lumwin ndi kat sɨmogwindɨ.) ");
INSERT INTO ian_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndi nɨmamba solat sɨga mandɨp mandɨp velavɨka lɨndi. Jisas ndi kat wandɨ. Kɨgɨnda ngilɨga waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ndɨ kat kami kɨta kwindi. ");
INSERT INTO ian_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Klalaa kɨndɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jisas ndi kat wandɨ. Tamba la nɨmba, Moses, profet, Sam walɨna nyaangɨt pɨlɨwutnja nɨmba tamba wun kat nyaangɨt pɨlɨwutndi. Tak ngwutnogwinala tɨwan pɨlɨwutnja nyaangɨtmba yetɨgiyowun waa wowun. Mbambala tamba wan nyaangɨpmba ngiyambak yetɨwun waa walaa ");
INSERT INTO ian_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","tamba pɨoɨwutnja nɨmbana angwa nyaangɨt ndi kat vɨsɨmogwindɨ. Vɨsɨmogwiga wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kraist kiyalaa nandinya kuvut tɨga laakiyandɨ waa tamba pɨlɨwutndi. Pɨlɨwutnja vla yiwun. ");
INSERT INTO ian_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yiwun maa ngwuk kava kava yilaa nyaangɨt mbukiyangwuk. Kavle maawut kwagalangweyan God ngwutna kavle vat sɨlɨmbwigiyandɨ waa mbukiyangwuk. Tak Jerusalemba lɨga nɨmba kat mbukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kiyalaa laakwa vat ngwut mɨnimba tamba vɨngwuk. ");
INSERT INTO ian_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Samat tɨga wowun maa wuna nyaek ngwuk kat ndɨna waagan kwigiyandɨ. Ngwuk Jerusalemba tɨga kwo kawiga alɨ ngwula. Nyinangwupmba lɨga yaiga kwondu ngwuk kat yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jerusalem kwagalalaa Betani walɨnja ngepmat yindi. Yindi maa Jisas taamba katsondɨ. Katsolaa apma vat alɨ ngwula wandɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Walɨga ndi kat kwagalalaa nyinangwutnat wokendɨ. ");
INSERT INTO ian_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ndi solat sɨga ndɨna sɨ kwutaa katsolaa Jerusalemat lungwamataa yindi. ");
INSERT INTO ian_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nandinya nandinya Godna ngay wuleilaa solat sɨga Godna sɨ kwutaa katsolɨndi. Ngiyambak. ");
INSERT INTO ian_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Tamba nglei ta nyan tɨndɨ. Ta nyan Godnonala tɨndɨ. Ta nyan Godna. Ta nyan Godna vak sɨmogwi lɨga nyana. ");
INSERT INTO ian_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta nyan nyinangwut kɨpma aywaa kwutndɨ. Nat kɨta nyan ana kɨta nda kwutndɨ. Ndɨ aywaa kapma kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Apma vak yetɨnda vak ndinyangu kat vɨsɨmogwindɨ, vɨndi. Apma vak yetɨnda vak ya vɨtɨga tuway vla lɨgandɨ. Va nɨmba apma vak yiga yetɨndi. ");
INSERT INTO ian_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndi kavle nɨmba kavle vat mɨna yiga yetɨndi. Kavle vat yiga yetɨlɨnja vak ya apma vak kat ana kwulaka viyesandandɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kɨta nyan Jon God wandɨ, yalaa laataa njɨvwa kwutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wan nyan Jon apma vat sɨmogwi lɨga nyan kat mbupmat laataa yandɨ. Mbutnda nyaangɨt wutaa ndinyangu maawupmba yelavɨtaa kwutaa yetɨnjangat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon ndɨ apma vat yetɨlɨga ta nyan ana ndɨ. Ndɨ kat tɨga nat nɨmba kat mbutɨga nyana Jon. ");
INSERT INTO ian_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ta nyan apma nglei vak yeta nyan ndinyangu kat sɨmagavak kat kan kɨpma ngaga yandɨ. Yalaa ndɨnai yeta apma vat sɨmogwi lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndɨ kɨpmamba lɨga nda kat wutndɨ. Kɨpma gaga yalaa ndinyanguanala yetɨndɨ. Njambwi nyanat tɨnda vat kɨpmamba la nimba vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kapma ngepma nyan vla ana yandɨ. Ndɨna ngepma nɨmba njambwi nyanat tɨnda vat ana vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kɨta nyan njambwi nyanat tɨnda vak kat vɨlaa mɨn wuna njambwi nyan mɨn waa wandeyan ndɨ Godna mbaapma wuleilaa Godna nyanat tɨgiyandɨ. Gondna nyanat tɨnjeya kwondu ndɨnai kwiya. ");
INSERT INTO ian_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wan ndɨna nyanat tɨgiyaa nɨmba ndinyangu yelavɨka yetɨga maawupmba lɨgiyaa nɨmba ana Godna nyanat tɨgiyandi. God wandɨ maa tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta nyan Godna vak sɨmogwi lɨga nyan ndinyanguna mbangɨ ɨlalaa nɨnogwinala yetɨndɨ. Apma vat yetɨlɨnda vat nɨn vɨlɨnɨn. Vɨlaa walɨnɨn. God wandɨ maa ndɨ njɨvwa klalaa yandɨ. Ndɨ Godna nyana waa walɨnɨn. Ndɨ apma vat mɨna yiga yetɨga nyana. ");
INSERT INTO ian_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ndɨ kat tɨga ndinyangu kat waga mbutɨndɨ. Wuna kwupmba yaiga nyan wuna njambwi nyana. Tak wun kat name kwutapman tɨlɨ ndɨ tamba tɨndɨ waa walɨndɨ Jon. ");
INSERT INTO ian_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ndɨ nɨma sakwat apma vat tɨga nyana. Nɨn kat awagapma nɨma sakwat apma vat kwindɨ. Kwindɨ, vɨlaa klanɨn. ");
INSERT INTO ian_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tamba la nyan Moses Juda kat njambiya taagandɨ. Ngini ya nyan Jisas Kraist wupma ana yilɨdɨ. Ndɨ apma vat nɨn kat awagapma kwo kwilɨndɨ. Ndɨ njambiya ana taagandɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Godna mbangɨ vɨga la nyan kai. Ndɨna nyan ndɨnogwionala kɨta vat vɨga lɨndɨ. Vɨlaa nɨn kat ngaga yalaa Godna vak nɨn kat mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon mbutɨndɨ wutɨnja nyaangɨt kɨngiyan. Jerusalemba njambwi Juda God kat kwunatɨga nɨmbo Livai walɨnja mbaapmamba la nɨmba kat ay wandi maa Jon kat wagalavat yindi. Yilaa wagalandɨ. Mɨn anda nyan mɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wandi maa wandɨ. Ngwuk kat tɨwa vak ana pagwugiyowun. Wun Kraist ana wun. ");
INSERT INTO ian_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wandɨ ma nat njamba at ndɨ kat wagalandi. Mɨn Ilaija mɨn? Waa wagalandi maa ndɨ kai wandɨ. Mɨn kawiga lɨna profet mɨn? Waa wagalandi maa ndɨ kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kai wandɨ maa ndɨ kat wagalandi. Mɨn kat wagalavak kat ay waa nɨmba kat lungwamataa yilaa angamak waiganɨn. Nɨn kat ambuk waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ndi kat wandɨ. Tamba la profet Aisaia pɨlɨwutnda vak kwutɨgowun. Ndɨ tamba pɨlɨwutndɨ. Wun kwo kavamba lɨga kwundimba nyaangɨt mbutɨga nyan wun. Waa pɨlɨwutndɨ. Kupma butɨgowun njambwi nyan yaiga yambɨ kwuka kwunak ngwula waa mbutɨgowun. Tamba la profet Aisaia mbutnda vla mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ay wandi mala yaa nɨmba ndi Ferisina mbaapmba la nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ndɨ kat wagalandi. Mɨn Kraist ana mɨn. Mɨn Ilaija ana mɨn. Mɨn kawiga lɨna profet ana mɨn. Ngi vat tɨga manda kat ndinyangu kat mɨn ngu yagulɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wun kwo ngumba njangi lɨgowun. Wan vak nɨma vat ana ndɨ. Ngwutnogwinala tɨga njambwi nyan ngilɨga. Njamwi nyanat tɨnda vat ngwuk ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wan nyan wuna kwupmba yaiga nyan wuna njambwi nyana. Tat wun kat name kwutapman tɨlɨ, ndɨ tamba tɨndɨ. Ndɨ njambwi nyana. Wun mat nyan wun. Ndɨna njɨvwa kwuta nyanat ana alɨpsɨga tɨgiyowun. Wun vaatɨgowun waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kan vak Betani walɨnja kɨpmamba kak kiyandɨ. Wan kɨpma Jodan walɨnja ndandangɨ nat naangɨmba lɨga kɨpma. Wan kavamba Jon ndinyangu kat ngu yagulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nat nandinya Jisas yalɨndɨ maa vɨlɨɨ Jon ndinyangu kat wandɨ. Ndɨ kat avɨ ngwula. God kat kwunapmat kwilɨnja sip sip tɨga vla tɨgandɨ. God wandɨ maa yalaa lɨgandɨ. Ndinyangu aywaa ndinai yilɨga kavle vak kat God nyingi maawut tɨnda vak kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wan nyan tak mbutɨwa nyan. Tak wowun. Wuna kwupmba yaiga nyan wuna njambwi nyana. Tak wun kat name kwutapman tɨlɨ, ndɨ tamba tɨndɨ waa tak mbutɨwun. ");
INSERT INTO ian_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tak Jisas njambwi nyanat tɨnda vat wun ana vɨga lɨwun. Ngwuk Isrelna nɨmba njambwi nyan yaigandɨ waa sɨmogwivat ndinyangu kat ngu yagulɨgowun waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon mbutnda nat nyaangɨt kɨngwiyan. Godna waagan namiyo ngaga ya vla yandɨ. Yalaa Jisas la sɨsomba tɨndɨ, vɨwun. ");
INSERT INTO ian_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tak njambwi nyanat tɨnda vat wun ana vɨga lɨwun. Tak ndinyangu kat ngu yagu mɨla waa wun kat waa nyan God tak wun kat wandɨ. Wuna waagan ngaga yalaa kɨta nyan ta sɨsomba tɨgiyandɨ. Vɨgiyamɨn. Vɨlaa ndɨ Godna waagan nat nɨmba kat kwilɨga nyana waa yelavɨkiyamɨn ngɨni waa wandɨ God wun kat. ");
INSERT INTO ian_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wanda nyaangɨt wutaa lɨga ngɨni wan vak vɨwun. Vɨlaa ndɨ Godna nyana waa ngwuk kat wowun. ");
INSERT INTO ian_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nat nandinya Jonogwi ndɨna kwupmba la mbɨt nyan vɨlɨlɨk tɨndi. ");
INSERT INTO ian_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisas yilɨndɨ maa Jon ndɨ kat vɨlaa wandɨ. God kat kwunapmat kwilɨnja sip sip tɨga vla tɨga nyan kɨngiyandɨ yaa. God wandɨ maa yalaa lɨgandɨ waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jonogwinala kɨta ta mbɨt nyan ndɨnai waa nyaangɨt wutaa ndɨ kat kwagalalaa Jisasna kwupmba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas lungwamataa mbɨk kat vɨlaa wandɨ. Mbɨk manda kat kwaka yambɨt waa wandɨ mbɨk kat. Wandɨ maa ndɨ kat wambɨt. Rabai wambɨt. Ndina kwundimba sɨmokwi lɨga nɨmba kat Rabai walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisas mbɨk kat wandɨ. Wuna kwupmba yalaa wuna ngay vɨgiyambɨt waa wandɨ. Wandɨ maa ndɨna kwupmba yilaa vɨmbɨt. Ngi kat tɨga wan ngan ndɨna ngaymba sɨndu kwambɨt. ");
INSERT INTO ian_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon kwundi wutaa mbɨt vɨlɨlɨk nyana kɨta nyana sɨ Endru. Wutaa Jisasna kwupmba yindɨ. Ndɨ Saimon waa Pita walɨnja nyana yaakwanda nyana. ");
INSERT INTO ian_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ndɨ Endru yiga ndɨna yakwa nyan kat vɨlaa wandɨ. Mɨn yagwa mɨla. Mesaia walɨna nyan kɨngiyan yaa vɨwun. Yaa avɨ ndɨ kat waa wandɨ Endru. Ndinyangu kat kwunapmak God kwiya nyan kat ndina kwundimba Mesaia wandi. ");
INSERT INTO ian_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndɨ kat Jisas ta kavat kwutaa kalindɨ. Yambɨt maa Jisas Saimon kat ndɨna maawut tɨga vak vɨlaa wandɨ. Mɨn Saimon. Jon nyan mɨn. Mɨn kat mandɨt kupi sɨ waigowun. Ngɨni mɨn kat Sifas waa Pita waigandi mɨn kat. Wan sɨ angwa ngilɨga. Kambat tɨga vla lɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nat nan dinya Jisas Galili walɨnja nɨma kɨpma kat yivat tɨndɨ. Yiga Filip kat vɨlaa wuna kwupmba yagwa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipna angwa ngepma Betsaida. Endruo Pitana kɨta ngepma nyana. ");
INSERT INTO ian_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip Jisas kat vɨlaa nat nyan Nataniel kat yiga kwatɨndɨ. Ndɨ kat vɨlaa wandɨ. Mɨn yagwa mɨla. Tamba la nyan Moses tamba la profet wan yaigandɨ waa God waa nyaangɨt wutaa pɨlɨwutɨnja nyan tamba yandɨ, vɨnɨn. Ndɨna sɨ jisas. Josepna nyana. Ndɨna ngepma Nasaret waa wandɨ Filip. ");
INSERT INTO ian_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wandɨ maa Nataniel ndɨ kat wandɨ. Nasaret apma ngepma ana ndɨ. Anda vapmba apma nyan tɨga kan kavle ngepma laakiyandɨ waa wandɨ. Wandɨ maa Filip wandɨ. Yaa ndɨ kat vɨlaa sɨga nagugiyamɨn. ");
INSERT INTO ian_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel yalɨndɨ mala Jisas ndɨ kat vɨlaa nat nɨmba kat walɨndɨ. Kan yalɨga nyan kat avɨ ngwula. Ndɨ apma maawutno la Juda ndɨ. Kɨta vat ndɨ ana pagwulɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jisas wandɨ maa Nataniel wandɨ. Wun kat tak ana vɨga lɨmɨn. Kanda mbutndi, wutaa wuna maawupmba lɨga vak kat nat nɨmba kat mbutɨgamɨn waa wandɨ. Wandɨ maa Jisas ndɨ kat wandɨ. Wun kat tak ana vɨga lɨmɨn waa manda kat wamɨn. Sɨvla kavamba lɨmɨn mɨn kat vɨga lɨwun. Tak fik walɨnja mi angɨmba tɨmɨn maa Filip mɨn kat yaa vɨlaa yagwa wandɨ maa wiwun mɨn kat waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel awat ndɨ kat wandɨ. Njambwi nyan mɨn Godna nyan mɨn. Mɨn nɨn Isrelmba lɨga nɨmba nɨna king mɨn waa wandɨ Nataniel. ");
INSERT INTO ian_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas ndɨ kat wandɨ. Tak mi angɨmba lɨmɨn maa vɨlaa mɨn kat wowun maa ngɨpaliga dalaa wun kat njambwi nyan mɨn waa yelavɨka wamɨn. Wan mɨn kat sɨvla kavamba tɨga vɨwa vat nɨma vak ana ndɨ. Ngɨnɨ nɨma nglei vat kwutɨweya vak vɨgiyamɨn. ");
INSERT INTO ian_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mɨn kat ana woseka wigowun. Ngɨnɨ nyinangwut mbɨlɨndɨ maa Godna ensel wokelɨnjeya vak vɨlaa wun kat ngaga yanjeya vat vɨgiyamɨn. Wokelaa yalaa Godna vat wun kat mbutndi maa ngwuk kat mbutɨgowun. Wun ndinyangu kat nyinangwutna vat mbutɨga nyan wun. Wan wawa vat nɨma vatna waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nandinya kuvuk yindɨ mala taagwa klalaa kapti kwutndi. Wan kapti Kena walɨnja ngepmamba lɨndɨ. Kena Galili walɨnja kɨpmamba lɨga ngepma. Jisasna nyime lɨlo kapti kat yiga lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisaso ndɨna mbaapmamba la nɨmba kat yagwa wandi maa wan kapti kat yindi. ");
INSERT INTO ian_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wan kaptimba la nɨmba nɨma ngu kɨlɨndi maa ngɨlɨndɨ. Ngɨlɨndɨ maa Jisasna nyime ndɨ kat walɨ. Nɨma ngu tamba ngɨlɨndɨ waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Walɨ maa Jisas lɨ kat wandɨ. Taagwa kwutɨwa njɨvwa vɨlɨgat taagwa ana nyɨn. Wata wupma alɨ nyɨla. Wuna kwondu wuna ava vɨsɨmogwiweya njɨmbla ana yalɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wandɨ maa ngu kɨgɨnda kwuka kansaga kwilɨga nɨmba kat walɨ. Kɨta nyaangɨt ngwuk kat wandeyan wandeya nyaangɨt wana wuka kwagalangweya. Agwupmba ngwuk waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kaambapmba kwutja ngu yagulɨnja aw sɨla kɨta kwo lɨndɨ. Wan awba la ngu klalaa Juda ngu yagula vla mbangɨna nglambi njangivat ngu yagulɨndi. Wan awna kɨla kɨngiyan. Aw kɨta 20 galen o 30 galen ngu tulaa kalɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas ndi kat wandɨ. Aw kwutaa ngu kalɨk ngwula waa wandɨ. Wandɨ maa ngu klalaa kalɨndi, aywaa aw taatndɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kalɨtndi maa Jisas ndi kat wandɨ. Awmba lɨga ngu kuvuk kalɨka klalaa yiga kɨgɨndagwi ngu kat vɨga lɨga nyan kat yiga agwi wandɨ maa yiga kwindi. ");
INSERT INTO ian_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kwindi maa kɨkɨndagwi ngu kat vɨga lɨga nyan njangu wutaa samat kɨndɨ. Jisas wandɨ maa kwutnja vak ana vɨga lɨndɨ. Nguagwi kɨgɨnda kat kansaga kwilɨga nɨmba ndi vɨga lɨndi. Wan nyan kɨga vɨlaa taagwa kla nyan kat yagwa wandɨ maa yandɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Yandɨ, ndɨ kat wandɨ. Nat kapti kwutɨga nɨmba tak apma nɨma ngu kwilɨgandi. Ndinyangu nɨma sakwat tɨga kɨndi maa kavle nɨma ngu kwilɨgandi. Mɨn wupma kai. Mɨn apma nɨma ngu ndi kat ngɨni kwimɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas kwo lɨga tak kwutaa njambwi nyanat tɨga nɨma tagula avo lɨnda vat sɨmogwivat tɨga nɨma njɨvwa kan. Wan tak kwutaa njɨvwa Kena Galilimba kwutndɨ. Kwutnda vak vɨlaa ndɨna mbaapmamba la nɨmba ndɨ kat njambwi nyana waa lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tɨga lɨga Kapaneam walɨnja ngepmat ndaindɨ. Ndɨna nyime, ndɨna yakwa nɨmba, ndɨna mbaapma nɨmba, ndi aywaa ndaindi. Ndailaa wan ngepmamba samat nandinya kuvuk yetɨndi. ");
INSERT INTO ian_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tɨndi maa Juda walɨnja nɨmbana pasova walɨnja pesto ngway tolondɨ. Tɨga lɨga wan pesto vɨvat Jisas Jerusalemat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ngepma wokelaa God kat kwunatɨnja ngay wuleindɨ. Wuleilaa yilɨnja vak vɨndɨ. God kat kwinjeya bulmakau sip sip namiyo wenga kalɨndi maa vɨndɨ. Romna sanya klalaa Judana sanya ndi kat kwilɨndi, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Vɨlaa mat yaaw kwutaa ndi kat viyandeya nda klalaa sangindɨ. Ndi kat viyaga kɨklindɨ. Dinyangu, bulmakau, sip sip ndi kat aywaa savulɨndɨ maa wogwendi. Sanya kwilɨga nɨmbana njamba kwutaa kaselɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Namiyo kat wenga klalɨja nɨmba kat wandɨ. Wan nda kwutaa kali ngwula. Kan ngay wuna nyaekna ngaya. Stua ana ndɨ wenga klangweya waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wupma yindɨ mala vɨlaa ndɨna mbaapmamba la nɨmba tamba la nyan pɨlɨwukna vak kat yelavɨtndi. Godna ngay kwunapmak nɨma jɨvwa kwukiyowun. Waa pɨlɨwutndɨ tamba la nyan. ");
INSERT INTO ian_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wupma yilɨndɨ maa Juda ndɨ kat yalaa wandi. Kanda wandɨ maa wupma yilɨgamɨn. Wupma yilɨma kwondu nɨn kat sɨmogwi mɨlɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wandɨ maa Jisas ndi kat wandɨ. Wovuna nguk kat vɨsɨmogwigiyowun. Kan ngay sulɨngwuk maa nandinya kuvut kwukiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wandɨ maa Juda ndɨ kat njɨka wandi. Nɨn naambi ndumi vɨli kiyeli sɨla vɨli wan Godna ngayna njɨvwa kwutɨnɨn. Mɨn anda vapmba nandinya kuvut kan ngayna njɨvwa kwukiyamɨn waa ndɨ kat njɨka walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wan God kat kwutnja ngay kat ana wandɨ. Ndɨ ndɨna mbangɨ kat pagwuga wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wan ndɨna mbaapmamba la nɨmba wan tak pagwuga wanda nyaangɨk kat kiyalaa nandinya kuvut tɨga laatndɨ maa wan vak kat yelavɨtndi. Wan nyaangɨk kat yelavɨtaa wandi. Wan tamba la God waa nyaangɨt pɨlɨwuta nɨmba ana woseka waa pɨlɨwutndi. Jisas nɨn kat mbutɨnda nyaangɨt ndɨ woseka waa ana mbutɨndɨ. Wan nyaangɨt tamba aywaa kak kiyandɨ, vɨnɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas pasova walɨnja pestona nandinya Jerusalemba lɨga ndɨna kwondu vɨsɨmogwiga nɨma sakwat nɨma njɨvwa kwutɨndɨ. Kwutɨnda vak kat vɨlaa nɨma sakwat nɨmba ndɨ njambwi nyana waa yelavɨtɨndi. ");
INSERT INTO ian_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yetɨlɨnda ndɨna vak aywaa ana vɨsɨmogwilɨndɨ. Vɨsɨmogwiweyan apma vat ana yelavɨka lɨgiyandi waa yelavɨtndɨ. Ngi kat tɨga nat samat vat mɨna sɨmogwindɨ ndi kat. ");
INSERT INTO ian_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndinyanguna maawupmba la vak kat nat nyan kat ana wagalalɨndɨ. Ndɨ ndinyanguna maawupmba la vak kat aywaa vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kɨta nyan Kikodimas tɨndɨ. Ndɨ Ferisi walɨnja nɨmbana mbaapmamba lɨga kɨta nyana. Ndɨ Judana njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wan nyan Jisas kat ngambuvat ngan yandɨ. Yalaa Jisas kat wandɨ. Njambwi nyan God wandɨ maa nɨn kat sɨmogwivat yamɨn. Vɨlɨganɨn. God kwondu kwiya nyan mɨna alɨpsɨga kwutɨma njɨvwa kwukiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wandɨ maa Jisas ndɨ kat wandɨ. Mɨn kat wowun. Mɨn kat ana woseka waigowun. Kɨta nyan mandɨt kupi nyanat tɨlapman yindeyan God vɨga lɨga kava ndɨ ana vɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas ndɨ kat wandɨ. Wun tamba avɨt ndu wun. Ngɨni angamak yigiyowun. Nyimena yaatnat wuleiwun maa nat samba wun kat kwutɨ maa mandɨt nyanat tɨgiyowun? Waa wagalandɨ Nikodimas. ");
INSERT INTO ian_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas ndɨ kat wandɨ. Mɨn kat wowun. Ana woseka waigowun. Kɨta nyan ngu yagulapman tɨga Godna waagan klalapman yindeyan God vɨga lɨga kava ndɨ ana wuleigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mbutuwa nyaangɨt kapma vatna. Godna waagano lɨgiyaa nyan mandɨt maawut klalaa lɨgiyaa nyana. Wan kapma vatna. ");
INSERT INTO ian_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mandɨt kupi nyanat tɨgiyamɨn waa waweya vak wutaa ke ngɨpaliga ndaga. ");
INSERT INTO ian_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mwuk kwutɨga vatnogwi kɨta vatna. Mwut ndɨna yelavɨk vapmba njɨvwa kwuka yi ya lɨgandɨ. Ndɨna mbangɨ ana vɨlɨganɨn. Ndɨna kak mɨna wutɨganɨn. Godna waagano lɨgiyaa nyan mandɨt maawut klaiga nyan ndɨno wungivatna. Ndɨna maawupmba lɨga vat Godna waagan kwutɨnda njɨvwa nɨna mɨnimba ana vɨlɨganɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jisas wandɨ maa Nikodimas wandɨ. Wan wama vat anda yambɨmba yalaa kak kiyalaa tɨgiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Wandɨ maa Jisas ndɨ kat wandɨ. Mɨn Isrel waa Juda walɨnja nɨmbana njambwi nyan mɨn. Mɨn agamak kan vak vɨlapman yilɨgamɨn. Mɨn ana nglaapmɨn. ");
INSERT INTO ian_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mɨn kat woseka ana waigowun. Wunogwi wuna mbaapma nɨmba kwo ana mbutɨganɨn. Vɨga wuka lɨna vak mɨna mbutɨganɨn. Mbutɨna vak wupmak kat ngwuk Juda kai walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kɨpmamba kapmba lɨga nda kat mɨn kat mbukwun maa mɨna maawut ana yelavɨka lɨgamɨn. Nyinangwupmba lɨga nda kat mɨn kat mbukweyan mɨna maawut ana alɨpsɨga yelavɨka lɨgiyamɨn. ");
INSERT INTO ian_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kan kɨpmamba la kɨta nyan nyinangwutna vat ana wokelaa vɨndɨ. Nyinangwupmba lɨga kan kɨpma ngaga yaa kɨta nyan mɨna vɨga lɨgandɨ. Wan nyan wun wunayɨ. Wun ndinyangu kat nyinangwutna vat sɨmogwilɨga nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tamba la nyan Moses kapamba kwutnja kamboy kwutaa kwo nɨndɨ kava ndinyangu kat kwunapmak katsondɨ. Katsonda vak ngɨni wuno wun kat kwutaa katsogiyandi. Wun ndinyangu kat kwunapmak ya nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wun kat katsondi maa kɨta nyan vɨlaa wun kat tɨga katsondi waa yelavɨtndeyan wan nyan ana kavle yigiyandɨ. Ndɨ njɨmbla njɨmbla apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God kɨpmamba lɨga nɨmba kat nɨma maawut yelavɨka lɨndɨ. Ngi kat tɨga ndɨna nyan wun kat ay wandɨ maa laataa yawun. Nat nyan kat wupma ana wandɨ. Kɨta nyan wun kat vɨlaa wun kat kwunapmat yandɨ waa yelavɨtndeyan wan nyan ana kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kan kɨpmamba yeta kavle vat yiga yeta nɨmba kat sɨwangat ana God wun kat ay wandɨ, yawun. Ndina kavle vak kat kwunapmak kat yawun. ");
INSERT INTO ian_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kɨta nyan wun kat vɨlaa wun kat kwunapmat yandɨ waa yelavɨtndeyan God ndɨ kat ana sɨgiyandɨ. Kɨta nyan wun kat kai wandeyan wan nyan kat God sɨgiyowun waa tamba wandɨ. God kwiya nyan kɨta. Nɨma sakwat ana lɨgandɨ. Wun kat kai wanjeyan ndɨ kat kwunakiya nat nyan kai. Kavle vat mɨna yiga yetɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kan kɨpmamba lɨga nɨmba ndi kavle vat mɨna yiga yetɨlɨgandi. Kavle vat yiga yetɨlɨnja vak kulun walaa lɨga ngan vla lɨgandɨ. Wan nandinya sɨlɨga nya vla lɨgowun. Ndi kavle vat yiga yetɨvak kat mɨna woviyaguga lɨgandi. Ndi kat sɨmogwi vat yilɨwa apma vak kat vɨlaa ndi kai walɨgandi. Ngi kat tɨga ndi kat sɨgiyowun waa God wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kavle vat yiga yetɨlɨga nɨmba apma vat yiga yetɨlɨga nɨmba kat waigandi. Apma vat kat vɨlaa yetɨlɨna vak kavle vatna waa yelavɨkiyandi. Ngi kat tɨga wan apma vak kat kai walɨngandi. ");
INSERT INTO ian_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Apma vat yetɨlɨga nyan ndɨ wan apma vak kat ana vaatɨgandɨ. Nat nɨmba wan yiga yetɨnda apma vak kat vɨlaa waigandi. Ndɨ God waa vapmba yetɨlɨgandɨ waa waigandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tɨga lɨga Jisasagwi ndɨna mbaapma nɨmbo Judia walɨnja nɨma kɨpmat yindi. Yila yetɨga wan kɨpmana nɨmba kat ngu yagulɨndi. ");
INSERT INTO ian_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ndɨno nat ngepmamba nat nɨmba kat ngu yagulɨndɨ. Ndɨ Inon walɨnja ngepmamba lɨga nat nɨmba kat ngu yagulɨndɨ. Wan ngepma Selim walɨnja ngepma ngwaymba lɨga ngepma. Wan kavamba ngu nɨma sakwat tɨndɨ. Kava kavamba la nɨmba wan kavamba ngu yaguvat yalɨndi. ");
INSERT INTO ian_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wan njɨmbla Jon kwo lɨndɨ. Ana ndɨ kat kwutaa kalabusmba taagandi. ");
INSERT INTO ian_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tɨga lɨga Jona kwupmba la nɨmbo nat Judo laataa awat sowat walealɨndi. Mbangɨna nglambi sɨlɨmbwilɨnja vak kat tɨga walealɨndi. ");
INSERT INTO ian_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Walealɨndi maa Jona mbaapmamba la nɨmba Jon kat yala wandi. Njambwi nyan, tak Jodan walɨnja ndandangɨ nat naangɨmba mɨnogwinala ta nyan ndɨno ngu yagulɨngandɨ. Tamba nyaangɨt mbutɨma nyan ndɨno ngu yagulɨndɨ maa nɨma sakwat nɨmba ndɨna kwupmba yilɨgandi. Ndi nɨna kwupmba ana yalɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wandi mala Jon ndi kat wandɨ. Nɨmamba ke yelavɨkngwa. God ndɨ kat apma vak kwondu kwindɨ maa nɨma sakwat nsmba ndɨna kwupmba yilɨgandi. Kwo nyanat tɨgendan ana ndɨna kwupmba yigenja. ");
INSERT INTO ian_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tak ngwuk kat mbukwa nyaangɨt tamba wukngwuk. Wun Kraist ana wun. Wun ndinyangu kat kwunatɨga nyan ana wun. Wun tat ya nyan wun waa tak ngwuk kat mbukwun. ");
INSERT INTO ian_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","30","Taagwa klalɨna vak kɨta vatna. Taagwa klaiga nyan ndɨ kɨta nyan mɨna taagwo woviyagulɨ, klaigandɨ. Ndɨna nat nɨmba ana kaligandi. Ndi kwo lɨga klandeya vak mɨna vɨga lɨgiyandi. Vɨga solat sɨgiyandi. Ndɨ Jisas taagwa klalɨga nyan vla lɨgandɨ. Ndɨna kwupmba nɨma sakwat nsmba yindi maa vɨlaa wun kwo lɨga vɨlaa ndɨ kat solat sɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ndɨ nyɨnangwupmba lɨga yaa nyana. Wun kɨpmamba lɨga nyan wun. Wun kɨpmana vak kat mɨna vɨga lɨgowun. Ndɨ nyɨnangwupmba lɨga vak kat mɨna vɨga lɨgandɨ. Ngi kat tɨga wun kat kwulataa njambwi nyanat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndɨ vɨga wutnda vak nat nɨmba kat mbutɨgandɨ. Ndi wupmak kat kai walɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kɨta nyan ndɨ kat vɨlaa ndɨ nɨn kat God wandɨ, yaa nyana waa yelavɨtndeyan wan nyan God waa nayaangɨt wukiyandɨ. God woseka ana walɨgandɨ waa walɨga nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God ndɨ kat ay wandɨ mala yalaa God waa nyaangɨt nɨn kat mbutɨgandɨ. God ndɨna waagan ana samat ndɨ kat kwindɨ. Nɨmamba aywaa kwindɨ, ndɨnamba taqvindɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","God ndɨna nyan kat vɨlaa woviyaguga lɨgandɨ. God ndɨna vak ndɨna nyan kat aywaa kwindɨ, lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kɨta nyan Godna nyan kat vɨlaa wun kat kwunapmak yandɨ waa wandeyan ndɨ njɨmbla njɨmbla apma vat tɨndeya vak klaigandɨ. Kɨta nyan Godna nyan kat kai wandeyan ndɨ wan apma vak ana klaigandɨ. God wan nyan kat tamba wandɨ. Ndɨ kat sɨgiyowun waa tamba wandɨ waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Nɨma sakwat nɨmba ngu yagulaa Jisasna kwupmba yindi. Ndɨna kwupmba ya nɨmbana sakwat Jona kwupmba ya nɨmba kat kwulatndi. Jisas ana ndi kat ngu yagundɨ. Ndɨna kwupmba la nɨmba ndi ndi kat ngu yagua. Wan kavamba la ndi Ferisi ngu yagulɨnja vat wutaa ndi kai wandi. ");
INSERT INTO ian_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ngi kat tɨga Jisas wan kava Judia kwagalalaa Galiliat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judiagwi Galilina nɨndɨmba la kɨpma Sameria. Galili yivat Sameriamba ta ava yambɨmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yiga Sameriamba tɨga ngepma Saika walɨnja ngepma wuleindɨ. Tamba Jekop ndɨna nyan Josep kat kwiya kɨp ma wan ngepma ngwaymba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wan ngepmamba tamba Jekop ngu kɨga lɨvak kat wanda waangu tɨndɨ. Nɨma nandinya yiga lɨga Jisasna mbangɨ kɨlɨpangɨ yindɨ, ngu kɨlɨnja kavamba ndaalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisasna kwupmba ya la nɨmba ndi kɨgɨnda klavat ngepma wuleindi. Jisas wumba kapma lɨndɨ maa wan ngnepmamba la taagwa kɨta ngu tuvak yalɨ. Yalɨ maa Jisas lɨ kat vɨga wandɨ. Wun kat ngu tulaa agwi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wandɨ maa wat taagwa ngɨpaliga ndalaa wuli. Mɨn Judana nyan mɨn. Wun Sameriana taagwa wun. An kapma kapma mbaapmamba lɨgali waa walɨ. Kan mbaapmamba lɨga nɨmba kɨta kavamba lɨga ana ngu nao kɨlɨgandi. Wan vak kat Jisas ana wuka vɨga lɨgandɨ waa ngɨpaliga ndalaa walɨ ndɨ kat. ");
INSERT INTO ian_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Walɨ maa Jisas lɨ kat wandɨ. God ndinyangu kat kwigiyaa vat nyɨn ana vɨga lɨganyɨn? Wun anda nyan wun tɨga wun kat ana nyɨn vɨga lɨganyɨn? Vɨga lɨgenyan njɨmbla njɨmbla tɨgiyaa ngu kat wun kat wagalagenyɨn. Wagalagenyan nyɨn kat kwigewun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wandɨ maa ndɨ kat walɨ. Anda vapmba wan ngu tulaa wun kat kwigiyamɨn. Kan waangumba lɨga angɨnda sɨvlamba lɨgandɨ. Yisenda tumeya nda ana lɨgandɨ. Wan njsmbla njɨmbla tɨgiyaa ngu andamba klalaa wun kat kwigiyamɨn. ");
INSERT INTO ian_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nɨna walanga Jekop tamba vanda waangua. Vandɨ maa ndɨna nyangu, ndɨna kwanda kwanda nda, ndɨ, aywaa kɨngi waangumba ngu kɨga lɨndi. Ndɨ nɨma njɨvwa kwuka waangu vaga ngu klandɨ. Mɨn ndɨ kat kwulapmɨn? Njɨvwa kwutapman kwo lɨga ngu mɨna kwigiyamɨn? Waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas at nat njambɨ lɨ kat wandɨ. Kɨta nyan kan waangumba lɨga ngu kɨndeyan ngɨni ndɨna mbanjɨge pugiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kwiweya ngu kapma ngua. Kwiweya ngu kɨgiyaa nyan ngɨni ngu kɨvak kat ana yelavɨka lɨgiyandɨ. Wan kwiweya ngu kɨlɨndɨ, ana ngɨlɨgiyandɨ. Kɨlɨndɨ, nɨma yklɨgiyandɨ. kɨlaa njɨmbla njɨmbla apma vak tɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wandɨ mala taagwa ndɨ kat walɨ. Wama ngu wuno wun kat agwi. Ngɨni kan kava ngu tuvak ana yaigowun. Kwo lɨgiyowun waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas lɨ kat wandɨ. Nyɨna lan kat yiga walaa kiya waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wandɨ maa walɨ. Wun ndu kai walɨ. Walɨ maa Jisas wandɨ. ngiyambak wanya wun ndu kai waa. ");
INSERT INTO ian_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nyɨna lan tambanat nɨmba ndi. Mbambala ngyɨnogwinala lɨga nyɨna ndu ana ndɨ. Kwo nyana. Ngi kat tɨga ngiyambak wanya waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wandɨ maa walɨ. Pagwuga yetɨluwa vak mɨn vɨga lɨgamɨn. Mɨn profet mɨn. Vɨga lɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nɨna valanga kan nduwimba God kat kwunaka walɨndi. Ngwuk Juda yetɨlɨnja vak kat kai walɨgangwuk. Nɨna angwa ngepma Jerusalem mɨna wuleilaa God kat kwunaka waigangwuk waa walɨgangwuk waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Walɨ maa Jisas lɨ kat wandɨ. Nyɨn taagwa awut nyɨla. Wanya nda nɨma nda angwa nda ana ndɨ. Ngɨni kava kava God kat kwunatnjeya kava kai. Wan wanya nduwimba ana kwunakiyangwuk. Jerusalemba ana kwunakiyandi. Kava kavamba lɨga God kat maawupmba yelavɨka lɨgiyanguwk. ");
INSERT INTO ian_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","God nɨn kat kwunapmak kat kwigiya nyan kat yelavɨtapman kwo kwunatɨgangwuk. Nɨn Juda wan yaiga nyan kat yelavɨka kwunatɨganɨn. ");
INSERT INTO ian_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wan wawa njɨmbla yaiga njɨmbla tamba yalaa lɨgandɨ. Mbambala kɨpmana kava kat yelavɨtapman nɨma maawupmba mɨna God kat yelavɨka lɨgiyanɨn. Tamba la nɨmba kɨta kavamba mɨna God kat kwunatɨndi. Mbambala wupma ana yigiyanɨn. Tamba la nɨmba God ta vak ana vɨga lɨndi. Mbambala nɨn alɨpsɨga vɨga lɨgiyanɨn. Ngi kat tɨga sɨmblan ana ndɨ kat yelavɨka lɨgiyanɨn. Savagu lɨga vak mɨna yelavɨka lɨgiyanɨn. Givak vapmba ndɨ kat yelavɨkiya nɨmba kat God kwatɨgandɨ. Wan maawupmba yelavɨka lɨnjeya vak kat vɨlaa ndi kat woviyaguga lɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God kɨpmamba lɨga nda kat ana nɨmamba yelavɨka lɨgandɨ. Ndɨ God ndinyanguna kait vla lɨgandɨ. Ngi kat tɨga kɨpmana nda kat yelavɨtapman ndɨ kat savagu vapmba yelavɨka lɨgiyanɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jisas wandɨ mala walɨ. Mbambala nɨma sakwat pagwula lɨga nda ngilɨga. God kwigiya nyan Mesaia walɨna nyan yalaa nɨn kat aywaa sɨmogwigiyandɨ waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Walɨ maa Jisas wandɨ. Wun Mesaia wun wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ngambulɨmbɨt maa ndɨna mbaapmamba la nɨmba ngepmamba lɨga yalaa mbɨk kat vɨlaa ngɨpaliga ndalaa yilɨmba waa lɨ kat manda kat ngambulɨgamɨn waa ana wandi. ");
INSERT INTO ian_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yandi mala wat taagwa ngu tuvat kiyalaa nda taagalaa ngepmat ndu kat mbupmat wuleilɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ngepma weleilaa ndu kat vɨlaa walɨ. Yagwa ngwula. Pagwuga yiga yetuwa vak vɨlaa waa nyan ngilɨga. yagwa yigat. Ndɨ kat yiga avɨ ngwula. Ndɨ Kraist anagandɨ waa walɨ wat taagwa. ");
INSERT INTO ian_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Walɨ maa wan ngnepma nɨmba nɨma sakwat Jisas kat vɨvat yindi. ");
INSERT INTO ian_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yalɨndi maa Jisasna kwupmba lɨga yaa nɨmba ndɨ kat walɨndi. Njambwi nyan kɨgɨnda tamba kiyanɨn. Wgɨ mɨla walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Walɨndɨ maa ndi kat wandɨ. Kɨluwa kɨgɨnda ngwuk ana vɨlɨngwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wandɨ maa awat sowat wandi. Ndɨ kat kɨgɨnda kandana kwiya waa awat sowat wandi. ");
INSERT INTO ian_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wandi maa Jisas ndi kat wandɨ. Wun kat ay waa nyana njɨvwa kwuka yilɨweya vak wuna kɨgɨnda vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kan kɨpmamba lɨga nɨmba ambugat kat vɨlaa walɨgandi. Mbak aynat yindɨ maa kɨgɨnda vagiyanɨn waa walɨgandi. Ngwuk wupma ke yelavɨka wangwa. ngwuk tanambɨka yite yite avɨ ngwula abugat kat. Vanjeya njɨmbla mbambala walɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ambugapmba kɨgɨnda valɨga nyan valɨnda njɨvwa kat wenga klaigandɨ. Ngwutno nɨmbun. Wawa njɨvwa kwukngweyan nat nɨmba kat njɨmbla njɨmbla apma vat tɨngweya vak ndi kat kwigiyangwuk. Ndi klangwuk maa vɨlaa apma wenga klanɨn waa waigangwuk. Ambugat kwutɨnja vak kɨngiyan. Nat nyan sɨndɨ, nat nyan vaigandɨ. Vandɨ maa vɨlɨlɨk palɨ kɨta vak solat sɨgiyambɨt. ");
INSERT INTO ian_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nat nyan ambugapmba sɨk yaagilɨgandɨ. Wan mi sɨk kwandɨ, nat nyan sɨgɨtɨgandɨ waa walɨgandi. Wan kwukngweya njɨvwa kɨta vakna. ");
INSERT INTO ian_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ay wowun maa nat nɨmba njɨvwa kwutaa kavat wuleilaa njɨvwa kwutɨngwuk. Nat nɨmba tua mina sɨk sɨgɨtɨga nɨmba vla lɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kan ngepmamba Saikamba la nɨma sakwat nɨmba ndi Sameria ndi wat taagwa mbuta nyaangɨt wutaa Jisas God wandɨ, yaa nyana waa yelavɨtndi. Wat taagwa walɨlɨ. Pagwuga yiga yetuwa nat nɨma sakwat vak kat vɨlaa mbutndɨ waa walɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sameriamba la nɨmba ndɨnai la kava yalaa nɨna ngepmamba kawiga alɨ mɨla waa wagalaga ndɨ kat wandi maa nandinya vɨlɨlɨk wumba ndinogwia yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nat nɨma sakwat nɨmba Jisas waa nyaangɨt wutaa ndɨ God wandɨ, yaa nyana waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yelavɨtaa wat taagwa kat wandi. Mbutnya nyaangɨt wutaa Jisas God wandɨ yaa nyan waa ana yelavɨtɨnɨn. Ndɨna kwundi wutaa wupma yelavɨtnɨn. Ndɨ Kraistna. Ndɨ ndinyangu kat kwunapmak yalɨga nyana waa yelavɨtɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nandinya vɨlɨlɨk yindɨ maa ndi kat kwagalalaa Galiliat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ndɨna angwa ngepmat ana yindɨ. Jisas tak walɨndɨ. God waa nyaangɨt mbutɨga nyan nsɨna angwa ngepmamba lɨga nɨmba kat mbutndeyan ndi ana wukiyandi. Kai waigandi waa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galili wuleilaa wan kavamba la nɨmba ndɨ kat vɨlaa wovun yamɨn waa wandi. Tak Jerusalemba la nɨma pesto kat yinda njɨmbla Jisas kwunatɨnda nɨma njɨvwa kat vɨndi. Ndino yindi wan pesto kat. Ngi kat tɨga ndɨ kat wovun yamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galili wuleilaa Kena walɨnja ngepmat wuleindɨ. Wan ngepma tak kwo ngu klalaa nɨma ngu kwutaa ndinyangu kat kwindɨ, kɨndi. Wan ngepmamba lɨndɨ maa Kapaneam walɨnja ngepmana njambwi nyan ndɨ kat vivat yindɨ. Ndɨna nyan yelogwen kat tɨndɨ maa ndɨ kat kwagalalaa yandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jisas Judia kwagalalaa Galiliat tamba yindɨ waa walɨnja nyaangɨt wutaa yandɨ. Yalaa wandɨ. Nɨma nyan wuna nyan kiya mɨna lɨgandɨ. Ndɨ kat yaa vɨlaa kwunapmba mɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wandɨ maa Jisas wumba la nɨmba kat wandɨ. Nɨma njɨvwa kwunatɨga njɨvwa kwutapman yiweyan wun kat vɨlaa ndɨ God wandɨ, yaa nyana waa ana yelavɨkiyangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wandɨ maa Kapaneamna njambwi nyan wandɨ ndɨ kat. Kwiyatapman yagwa. Yalapman yimeyan wuna nyan wundumbu yigiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wandɨ maa Jisas ndɨ kat wandɨ. Mɨn ay mɨla. Mɨna nyan ana kiyalgandɨ. Kwo lɨgiyandɨ waa wandɨ. Jisas wandɨ maa wutaa ngiyambak wanda woseka ana wandɨ waa yelavɨtaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ava yambɨ yilɨndɨ maa ndɨna njɨvwa kwutaa nɨmba yaa aya yambɨmba vɨndi. Vɨlaa mbutndi. Mɨna nyan kwo apma vat tɨgandɨ waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mbutndi maa ndi kat wagalandɨ. Nya angamak tɨndɨ maa ndɨna yelogwen ngɨlɨndɨ waa wagalandɨ. Wagalandɨ maa mbutndi. Napmba belo bek ngɨlɨndɨ waa mbutndi. Mbutndi mala wutaa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Napmba belo bek Jisas wandɨ. Mɨna nyan ana kiyaigandɨ Kwo lɨgiyandɨ waa wandɨ wun kat waa yelavɨtndɨ. Yelavɨtaa ndɨ God wandɨ, yaa nyana waa yelavɨtndɨ. Ngepma yilaa ndɨna ngaymba la nɨmba kat mbutndɨ maa ndino yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas Judia kwagalalaa Galiliat wuleilaa wan vɨlɨlɨk wan nɨma njɨvwa kwunatɨga njɨvwa kwutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tɨga lɨga Judana pesto vɨvat Jisas Jerusalemat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem tɨga sip sip klalɨnja kava ngwaymba waangu ngu lɨgandɨ. Wan waangu la kavamba wegwuga mbale tambanat kwutndi, lɨndɨ. Wan nguna sɨ Hibruna kwundimba Betesda wandi. ");
INSERT INTO ian_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wan mbalemba yelogwen kat ta nɨmba nɨma sakwat yiga tɨlɨndi. Nat nɨmba mɨni kiyaa nɨmba. Nat nɨmba kaawiya kɨla nɨmba. Yilaa ngu biyaiga vak kat kwaiga mbalemba lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nat njɨmbla God wandɨ maa ensel ngumba ndandɨ maa ngu biyalɨndɨ, vɨlaa tak wan ngu wuleigiyaa nyan kwo lɨgiyandɨ. Yelogwen ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wumba la kɨta nyan naambi 38 yelogwen kat tɨlɨndɨ. Ndɨ nguat kawiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas ndɨ kat vɨlaa maawupmba yelavɨtndɨ. Wan nyan naambi nɨma sakwat yelogwen kat tɨlɨndɨ waa yelavɨtaa ndɨ kat wagalandɨ. Yelavɨka lɨman mɨna mbangɨ kwo lɨndangat yelavɨka lɨgamɨn? Waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wandɨ maa yelogwen kat ta nyan Jisas kat wandɨ. Ngu biyalɨndɨ maa wun kat kwutaa ngumba laagagiyaa nyan kai. Ngu kat yilɨwun maa nat nyan taka yilɨgandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wandɨ maa Jisas ndɨ kat wandɨ. Laap mɨla. Sɨndu kwaalɨma nda laataa mbaka kwutaa kali waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jisas wandɨ maa wan nyana yelogwen ngɨlɨndɨ maa sɨndu kwalɨnda nda mbaka kwutaa kalindɨ. Wan Jisas ndɨ kat kwunatnda nandinya Judana nɨma nandinya. Njɨvwa lapman nandinya. ");
INSERT INTO ian_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yelogwen kat kwa nyan sɨndu kwalɨnda nda kwutaa kalindɨ maa Juda ndɨ kat vɨlaa walɨndi. Wan mandana yilɨma. Mbambala kan nandinya njɨvwa lapman nandinya. Manda kat nɨna njambiya kat kai walaa sɨndu kwalɨma nda kwutaa kalilɨgamɨn waa ndɨ kat walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wandi maa wandɨ. Wun kat kwunata nyan sɨndu kwalɨma nda kali waa wun kat wandɨ maa kalilɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wandɨ maa ndɨ kat wagalandi. Sɨndu kwalɨma nda kwutaa kali waa kandana mɨn kat waa waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yelogwen kat kwa nyan Jisasna sɨ ana vɨga wuka lɨndɨ. Jisas ndɨ kat kwunataa kwagalalaa yindɨ. Wan ndɨ kat kwunatnda kavamba nɨma sakwat nɨmba yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngɨni wan nyan God kat kwunatɨnja ngay wuleindɨ maa Jisas ndɨ kat vɨlaa wandɨ. Mɨn tamba apma vat kwo lɨgamɨn. Kavle vat yiga yetɨlɨma vak kwagalalaa apma vapmba yetɨgiyamɨn. Kavle vat yiga yetɨmeyan ngɨni mɨna mbangɨ nɨmamba kavle yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wandɨ maa wan nyan yilaa Juda kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisas ndɨ kat njɨvwa lapman nandinyamba yinda vak kat vɨlaa Juda Jisas kat kai walaa ndi nɨma kavle vat yilɨndi. Ndɨ kat vatnyavat yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yelavɨka lɨndi maa Jisas ndi kat vɨlaa wandɨ. Wuna nyaek God ndɨ mbambala njɨvɨwa lwitɨgamdɨ. Wuno njɨvwa kwutɨgowun. Kɨta kɨta kwutɨgali waa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wanda nyaangɨt wutaa Juda ndɨ kat vatnyavat nɨmamba yelavɨka lɨndi. Tak njɨvwa lapman nandinyamba njɨvwa kwuta vak vɨlaa ndɨ kat vatnyavak tɨndi. Mbambala God wuna nyaekna, kɨta kɨta njɨvwa kwutɨgali wanda vak kat wutaa ndɨ kat vatnyavak nɨmamba yelavɨka lɨndi. Wun Godno kɨta njambwi li waa walɨnda nyaangɨt kat wutaa aki wandi. ");
INSERT INTO ian_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas wandi maa Jisas ndi kat wandɨ. Ngwuk kat woseka ana waigowun. Wun Godna nyan avla wuna yelavɨk vapmba ana njɨvwa kwutɨgowun. Wuna nyaek kwutɨga njɨvwa vɨlaa kwutɨnda njɨvwa vla kwutɨgowun. Kwutɨnda njɨvwa mɨna wun ndɨna nyan kwutɨgowun. Kapma njɨvwa ana kwutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wuna nyaek vɨga lɨga kwutɨnda vak aywaa wun kat vɨsɨmogwi lɨgandɨ. Ngɨni wun kat nɨma vɨlaa ngɨpaliga ndaigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","God kiyalaa lɨgiyaa nɨmba kat wandɨ maa laakiyandi. Wuno ndɨna nyan kavle vat ya nɨmba kat wuna maawupmba yelavɨtaa wowun mala ndi laataa apma vak yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","God ndinyangu kat lɨgiyaa vak kat vɨlaa ana sɨga nagugiyandɨ. Sɨga nagulɨndeya njɨvwa wuna lak kwindɨ, sɨga nagugiyowun. ");
INSERT INTO ian_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mbambala ngwuk Godna sɨ kwutaa katsolɨgangwuk. Wun Godna nyan wun wuna sɨ kwutaa katsongwangat God wun kat sɨga naguweya njɨvwa kwindɨ. God wandɨ maa yawun. Wuna sɨ kwutaa katsolapman yingweyan Godna sɨ ana kwutaa katsolɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ngwuk kat woseka ana waigowun. Kɨta nyan wuna nyaangɨt wutaa God wandɨ maa yandɨ waa yelavɨtndeyan wan nyan njɨmbla njɨmbla apma vat tɨgiyandɨ. Ngɨni God ndɨ kat ana sɨgiyandɨ. Wan nyan kiyaa lɨga laakna nyan vla lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngwuk kat woseka ana waigowun. Wan yaiga njɨmbla mbambala tamba yandɨ. Mbambala kavle vak ya nɨmba kat wun Godna nyan waa nyaangɨt wutaa ndi kwo apma vak tɨgiyandi. Kiyalaa lɨga laakna nɨmba lɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","God kavle vat ya nɨmba kat apma vak ndi kat kwindeya vla wuno Godna nyan wupma kwilɨgowun. God wandɨ maa kwilɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wun kat ndinyangu yiga yetɨlɨga vak sɨga naguweya kwondu kwindɨ God. Wun God yilɨga vapmba ndinyangu kat yilɨga nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wan waluwa nyaangɨt wutaa ke ngɨpaliga ndangweya ngɨni kiyalaa waangumba lɨga nɨmba God waiga nyaangɨt wukiyandi. ");
INSERT INTO ian_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Wutaa laakiyandi. Apma vat yeta nɨmba njɨmbla njɨmbla apma vat tɨnjeya vak klavak laakiyandi. Kavle vak yeta nɨmba njɨmbla njɨmbla kavle vat tɨnjeya vak klavak laakiyandi. ");
INSERT INTO ian_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Wunai yelavɨka lɨga vapmba ana njɨvwa kwutɨgowun. Wuna nyaek waiga nyaangɨt wutaa ndinyangu kat vɨlaa sɨga nagulɨgowun. Ana sɨmblan sɨga nagulɨgowun. Wuna maawupmba ana sɨga nagulɨgowun. Wuna nyaek yelavɨka lɨga maawupmba sɨga nagulɨgowun. Ndɨ wandɨ maa yawun. ");
INSERT INTO ian_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wun njambwi nyan wun wuna sɨ avla waweyan wan ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Njambwi nyan tuwa vat nat nyan mbutɨgandɨ. Ndɨ wan nyan woseka walɨga nyan ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Vɨlɨgowun. Njambwi nyanat tuwa vat nat nyan tamba mbutndɨ. Ndɨna sɨ Jon. Tak wangwuk maa nat nɨmba Jon kat wagalavat yindi. Wagalandi maa njambwi nyanat tuwa vak Jon mbutndɨ ndi kat. ");
INSERT INTO ian_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kan kɨpmana nɨmba njambwi nyanat tuwa vat wanjeyan wan nɨma vat ana ndɨ. Jon ndɨ apma nyana waa ngwuk yelavɨka lɨgangwuk. Ngi kat tɨga Jon njambwi nyanat tuwa vak tamba mbutndɨ waa ngwuk kat mbukwun. Mbambala mandɨt maawut sɨkngwangat ngwuk kat wowun. ");
INSERT INTO ian_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ya sagalanja lam vla lɨndɨ. Ndɨnai waa nyaangɨt kat wutaa samat woviyaguga lɨngwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Njambwi nyanat tuwangat Jon walɨga nyaangɨt kat kwulakiya nyaangɨt ngilɨga. Wuna nyaek kwindɨ, kwutuwa njɨvwa kat vɨlaa njambwi nyanat tuwa vak vɨlɨgangwuk. God wandɨ, yaa nyan wun tuwa vak kat vɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wuna nyaek wun kat ay waa nyan ndɨno njambwi nyanat tuwa vak ngwuk kat mbutɨndɨ. Ngwuk ndɨna kwundi ana wuka lɨgangwuk. Kavle maawut yelavɨka ndɨna sɨ wuka ndɨna mɨndama ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ndɨnai waa nyaangɨt kat ngwutna maawupmba ana yelavɨka lɨgangwuk. Ndɨ ay wandɨ, yaa nyan kat ndɨ kat kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","God wandɨ, tawmba la nɨmba pɨlɨwukna nyaangɨt vɨga njɨmbla njɨmbla apma vak tɨngweya vak kat kwatɨgangwuk. Wan tamba pɨoɨwukna nɨmba wun kat pɨlɨwutndi. Ngwuk ana vɨga wuka lɨgangwuk? ");
INSERT INTO ian_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Njɨmbla njɨmbla apma vat yetɨngweya vak wunamba klavak kat kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wuna sɨ kwutaa katsongwangat kan nyaangɨt ngwuk kat ana mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngwuk kat vɨga lɨgowun. God ndinyangu kat woviyaguga lɨgangwuk. Vɨlɨgowun. Nat nɨmba kat woviyaguga lɨngwangat ngwuk kat kan nyaangɨt mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wun nyaekna sɨmba yalaa lɨwun maa wun kat kai walɨgangwuk. Ngɨni nat nyan ndɨna sɨmba avla yalaa lɨndeyan ana ndɨ kat kai waigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","God kɨta nyana sɨ kwutaa katsondeya vak ngwuk ana vɨga lɨgangwuk. Ngwuk awat sowat ngwutna sɨ mɨna kwutaa katsolɨgangwuk. Ngi kat tɨga God kɨta nyana sɨ kwutaa katsolɨnda vak ngwuk ana vɨga lɨgangwuk. Wan vak nɨma vakna. Wan nɨma vak kat kai walaa njambwi nyanat tuwa vak ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","God kat yiga vɨlaa ndi kavle vat yindi waa ngwuk kat ana waigowun. Nɨna njambwi nyana waa walɨngwa nyan Moses ndɨ God kat vɨlaa ndi kavle ak yindi waa ngwuk kat mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses waa la kwundi wukengwan wunai walɨga kwundi wukengwuk. Ndɨ tamba la nyan Moses wuna sɨ waa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pɨlɨwutnda nyaangɨt vɨlaa wupmak kat kai wangweyan wunai walɨga nyaangɨt ana wukiyangwuk. Kapma kapma nyaangɨt ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tɨga lɨga Jisas Galili waa Taibirias walɨnja sak nat naangɨ satnat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yindɨ maa nɨma sakwat nɨmba ndɨna kwupmba yindi. Yelogwen kat ta nɨmba kat kwunatɨnda nɨma njɨvwa kat vɨlaa yingi. ");
INSERT INTO ian_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yindi maa ndɨna mbaapma nɨmbona nduwiat wokendi. Wokelaa ndaa kwo lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasova walɨnja Judana pesto ngway tolandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ndaa lɨga nɨma sakwat nɨmba ndɨ kat yalɨnja vak kat vɨlɨndɨ. Vɨlaa Filip wandɨ. Kan yalaa lɨga nɨmba kat ndinai kɨgiyaa nao andamba klaiganɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas Filip ngambugiyaa vak kat wupmat wandɨ. kɨgɨnda kat ana nɨmamba yelavɨtɨdnɨ. Ngɨni yindeya vak tamba ndɨ yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wandɨ maa Filip wandɨ. 200 dola yaagilaa klaneya bret-nao ana alɨpsɨgiyandɨ. Nɨma sakwat nɨmba ana alɨpsɨga kɨgiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wandɨ maa Jisasna mbaapmamba la nat nyan Pitana yakwa nyan Endru wutaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Mat kwandɨ nyan kiyaa bret-nao tambanat kami vɨlɨlɨk ngilɨga. Wan nɨma sakwat nɨmba kɨngi kɨgɨndamba ana alɨpsɨgiyandɨ waa wandɨ Endru. ");
INSERT INTO ian_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Wandɨ maa Jisas ndɨna mbaapma nɨmba kat wandɨ. Kwandɨ yuwimba nda alɨ ngwula waa ndi kat awa ngwula waa wandɨ maa yiga wandi, ndaa lɨndi. Ndaa la nduna sakwat 5,000. ");
INSERT INTO ian_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisas bret-naogwi kamio klaa kwutaa God kat sɨvu kɨlaa lɨmbaga ndɨna mbaapma nɨmba kat kwindɨ, ndi yiga wan yalaa la nɨmba kat kansaga kwindi. Nɨma sakwat kɨvak yelavɨka la nyana nɨma sakwat kɨlɨndɨ. Samat ka nyan wun ngiyambak kuwa wandɨ, ana ndɨ kat nɨma sakwat kwindi. ");
INSERT INTO ian_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Alɨpsɨga kɨganɨn wandi maa Jisas ndɨna mbaapma nɨmba kat kɨlambɨnja nao kami klalaa mbanimba naanga ngwula. Kkɨlambɨ kɨgɨnda kwo lɨndeya vak ana nglaatndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wandɨ waa yiga naangandi. Mbani tamba vɨli kiyeli vɨlɨlɨk naangandi wan kɨlambɨ kɨgɨnda. ");
INSERT INTO ian_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nao kɨlaa kwo lɨga Jisas kwukna njɨvwa kat va nɨmba yelavɨka ngambundi. God nɨn kat kwiya profet, kawiga lɨna nyan kɨngiyan waa yelavɨka ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ndi Jisas kat kwutaa nɨma kingat taagagiyanɨn waa yelavɨtnja vak Jisas vɨlaa ndi kat kwagalalaa nat nduwiat kapma yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngan yandɨ mala Jisasna mbaapma nɨmba tɨvagawiat ndaindi. ");
INSERT INTO ian_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","18","Ndailaa njaambɨt kulaa Kakpaneam walɨnja ngepmat yindi. Yiga lɨga Jisas kat kuvat kawilaa Jisas kat samat kawiga lɨga tamba ngana walaa Jisas ta kava kwagalalaa valɨgendi. ");
INSERT INTO ian_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngusa kaga 3 mail o 4 mail yiga lɨga Jisas ngu tagumba veiga yalɨndɨ, vɨndi. Jisas yilɨlnja njaambɨtna ngway yandɨ, vɨlaa vaatndi. ");
INSERT INTO ian_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ndi kat wandɨ. Wunayɨ. Ngwuk ke vaaka wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wandɨ maa vɨlaa vaaka lɨnja vak kwagalalaa ndɨ kat kwutaa njaambɨpmba kundɨ. Kundɨ maa njaambɨt kwiyatapman avla yindɨ, yinja ngepmamba kawindi. ");
INSERT INTO ian_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yindi maa nat nandinya kwagalalaa yinja kavamba la nɨmba Jisas kat kwatɨndi. Ndɨna mbaapma nɨmba vaala kulaa valɨgenja vak tamba vɨndi. Jisas ndinogwinala ana yindɨ, vɨndi. Jisas ndinogwinala ana yindɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Taibirias walɨnja ngepmamba lɨga ya njaambɨt anagandɨ kulaa kalia waa yelavɨka lɨndi. Jisas God kat sɨvu kɨlaa ndi kat nao kami kwinda kava kat Taibiriasmba yaa la njaambɨt vɨgɨva yilɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jisasogwi ndɨna mbaapmamba la nɨmbo ana lɨgandi waa walaa njaambɨt kulaa Kapaneasm Jisas kat kwaka valɨgendi. ");
INSERT INTO ian_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yiga lɨga sak tɨvagawimba lɨndɨ, vɨlaa wagalandi. Njambwi nyan anda sɨva kupma yamɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wagalandi maa Jisas ndi kat wandɨ. Njambwi nyanat tuwa vak nɨma njɨvwa kwuka sɨmagawun, vɨlaa ana kupma yangwuk. Ngwuk kat kwiwa nao kami kɨga yaat tata vak kat tɨga yelavɨtaa yangwuk. ");
INSERT INTO ian_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kan kɨpmana kɨgɨnda klavak kat ke nɨmamba yelavɨka nɨma njɨvwa kwuka. njɨmbla njɨmbla apma vat tɨngweya vak klavak kat mɨna yelavɨka nɨma njɨvwa kwuka yetɨ ngwula. Wun Godna vak ndinyangu kat kwilɨga nyan wun. Wan apma vak ngwuk kat kwigiyowun. Tak God wun kat wandɨ. Wan nyan wuna nyana waa wandɨ. ngi kat tɨga Godna apma vat kwilɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jisas wandɨ maa ndɨ kat wagalandi. God nɨn kat kwiya njɨvwa anda njɨvwa. Anda vapmba wan njɨvwa kwukiyanɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wagalandi maa Jisas ndi kat wandɨ. God kwiya njɨvwa kɨngiyan. God wandɨ, yawun. Yaa nyan wun. Wupma ngwula maawupmba yelavɨkngweyan God waa njɨvwa kwukiyangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wandɨ maa ndɨ kat wandi. God wandɨ, yaa nyan tɨma vak anda nɨma njɨvwa kwutɨma njɨvwa vɨlaa God wandɨ yaa nyan mɨn waa maawupmba yelavɨka lɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tak bret-nao taamba kwutaa lɨmbaga kwilɨma vak kupi vak ana ndɨ. Tamba nɨna ngwat walanga kwo kavamba lɨga mana walɨnja nao ndino kɨlɨndi. Ndina yaat taatndɨ. Moses nyinangwupmba lɨga ndailaa nao ndi kat kwindɨ, klalaa kɨlɨndi waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wandi maa Jisas ndi kat wandɨ. Ngwuk kat ana woseka waigowun. Moses nyinangwutna nao ana ndɨ ndi kat kwindɨ. Kwilɨnda nao ana ndɨ ndi kat kwindɨ. Kwilɨnda nao kɨpmamba vla lɨga nda. Wuna nyaek God nyinangwupmba la nao ndɨnayɨ kwiya. ");
INSERT INTO ian_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God kwiya nao ndu nyana. Kɨpmamba lɨga nɨmba kat apma vat tɨnjeya vak kwivak nyinangwupmba lɨga ngaga yaa nyana. Ndɨ God kwiya nao vla lɨga nyana waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wandɨ maa wandi. Njambwi nyan nɨn kat kwivat wama nao njɨmbla njɨmbla nɨn kat agwi mɨla waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wandi maa Jisas ndi kat wandɨ. Ndinyangu kat apma vak kwilɨga nao vla lɨga nyan wunayɨ. Kɨta nyan kwiluwa apma vak klandeyan ngɨni nat vak klavak kat ana yelavɨkiyandɨ. Kɨta nyan wun kat vɨlaa God wandi, yaa nyana waa yelavɨtndeyan ngɨni nat njambwi nyan kat ana kwaka yiga vɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngwuk kat wowun. Ngwuk wupma kai. Kwutuwa nɨma njɨvwa vɨga lɨgangwuk. Ngwuk wupma kai. Kwutuwa nɨma njɨvwa vɨga lɨgangwuk. God wandɨ, yaa nyana waa ana wun kat yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wuna nyaek wun kat kwiya nɨmba aywaa wuna kwupmba yaigandi. Wun kat yandi maa ndi kat ana kai waigowun. ");
INSERT INTO ian_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nyinangwupmba lɨga ngaga wawan wuna maawupmba yelavɨka njɨvwa kwupmak ana yawun. Wun kat ay waa nyan yelavɨka lɨga vapmba njɨvwa kwupmak yawun. ");
INSERT INTO ian_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wuna nyaek yelavɨka lɨga vak kɨngiyan. Wun kat kwinda nɨmba aywaa ndi kat kwutaa lɨgiyowun. Kɨta nyan ana sɨlɨwokiyandɨ wun kat. Ngɨni yaiga nandinya wowun maa ndi kiyalaa laakiyandi. ");
INSERT INTO ian_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wuna nyaek yelavɨka lɨga nat vak kɨngiyan. Kɨta nyan wun Godna nyan wun kat vɨlaa God wandɨ, yaa nyana waa yelavɨtndeyan ndɨ njɨmbla njɨmbla apma vat tɨndeya vak klandɨ, ngɨni yaiga njɨmbla wowun maa kiyalaa laakiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas wandɨ maa Juda awat sowat waleaga wandi. Wun nyinangwupmba lɨga God kwiya nao vla lɨga nyan wun waa manda kat walɨgandɨ waa waleaga lɨga wandi. ");
INSERT INTO ian_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wan nyan Jisas. Ndɨna nyaek Josep. Ndɨna nyaek nyɨme kat vɨga lɨganɨn. Ndɨ manda kat nyinangwupmba yawun walɨgandɨ waa waleaga lɨga wandi. ");
INSERT INTO ian_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Waleaga lɨga walɨndi maa Jisas ndi kat wandɨ. Awat sowat ke walea lɨngwa. ");
INSERT INTO ian_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kwo nyan wuna kwupmba ana yaigandɨ. Wuna nyaek yagwa waa wanda nyan wuna kwupmba yaigandɨ. Yandɨ maa ngɨni yaiga njɨmbla wowun ma kiyalaa laakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tamba la profet God waa nyaangɨt tamba pɨlɨwutndi. God ndinyangu kat apma vat yelavɨka lɨnjeya vat sɨmogwigiyandɨ waa pɨlɨwutndi tamba. Ngi kat tɨga wuna nyaeknanamba apma vak yelavɨka lɨnjeya vat klalɨga nɨmba wuna kwupmba yaigandi. ");
INSERT INTO ian_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngwut ngwutna kɨta nyan wuna nyaek tɨga vat ndɨna mɨndama ana vɨga lɨgangwuk. God tɨga kavamba lɨga yaa nyan wun. Wun vɨga lɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Ngwuk kat ana woseka waigowun. Kɨta nyan wun kat vɨlaa ndɨ God wandɨ, yaa nyana waa yelavɨtndeyan ndɨ njɨmbla njɨmbla apma vat kwilɨga nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngwutna ngwat walanga kwo nɨndɨ kavamba lɨga mana walɨnja nao kɨga lɨga kiyalɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nyinangwupmba lɨga yandɨ, mbutɨwa nao kɨta nyan kɨndeyan ndɨ ana kiyaigandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nyinangwupmba lɨga yaa apma vat kwilɨga nao vla lɨgowun. Kɨta nyan wunamba wan nao klalaa kɨndeyan ndɨ apma vat njɨmbla njɨmbla tɨndeya vat klaigandɨ. Ndinyangu kat kwilɨwa wuna mbangɨ nao vla lɨgandɨ. Ndinyangu apma vat tɨnjangat kwilɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas wandɨ maa Juda awat sowat waleaga lɨga walɨndi. Anda vapmba indɨna mbangɨna wɨmbu nao vla lɨndɨ, kɨgiyanɨn waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Walɨndi maa Jisas ndi kat wandɨ. Ngwuk kat ana woseka waigowun. Wun Godna vak klalaa nginyangu kat kwilɨga nyan wun. Wuna mbangɨna wɨmbogwi yelogweno klalapman yigiyaa nɨmba njɨmbla njɨmbla apma vat tɨnjeya vat ana klaigandi. ");
INSERT INTO ian_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kɨta nyan wuna mbangɨna wɨmbogwi yelogweno klandeyan ndɨ njɨmbla njɨmbla apma vat tɨndeya vat klaigandɨ. Ngɨni yaiga njɨmbla wowun maa kiyalaa laakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wuna mbangɨna wɨmbu kɨgɨnda vla lɨgandɨ. Wuna yelogwen kɨlɨngwa ngu vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wuna mbangɨna wɨmbogwi yelogweno klalɨga nyan wuna mbaapmamba lɨgiyandɨ. Ndɨna maawupmba tɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wuna nyaek nyinangwupmba lɨga wun kat wandɨ maa ngaga yawun. Kan kɨpma yalaa yetɨnda vla yetɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nyinangwupmba lɨga yaa bret-nao wunayɨ. Ngwutna ngwat walanga tamba mana walɨnja nao kɨga lɨga kiyalɨna vla wuna wɨmbu kɨgiyaa nɨmba wupma ana kiyaigandi. Njɨmbla njɨmbla apma vattɨlɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Wan nyaangɨt Kapaneamba lɨga Juda yisola lɨnja ngaymba lɨga mbutɨndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ndɨnai mbuta nyaangɨt wutaa ndɨna mbaapma nɨmba wutaa wandi. Mbutɨnda nyaangɨt wupmak kat nɨn nɨmamba ana woviyaguga lɨganɨn. Wan nyaangɨt wupmak kat anaganɨn kai waiga waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kai walɨnja vak kat Jisas ndɨna maawupmba yelavɨtaa wandɨ. Mbutɨwa nyaangɨt kat wupmak kat ngwuk kai wangwuk? ");
INSERT INTO ian_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wun God kwiya vat klalaa ndinyangu kat mbutɨga nyan wun. Kɨpma kwagalalaa nyinangwut wokewun mala kan wokeweya vat kat kai waigangwuk? ");
INSERT INTO ian_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maawupmba yelavɨtɨngwa vak wan apma vat nɨma vatna. Mɨnimba vɨlɨngwa vat wan nɨma vat ana ndɨ. Mat vatna. Ngwuk kat mbutɨwa nyaangɨt wutaa klangweyan apma maawut yetɨlɨngweya vat klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngwula nat nɨmba wun kat vɨlaa kai walɨgandi waa wandi Jisas. Jisas kat kai wala nɨmbowi kamwin kwiya nyano Jisas tamba vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wan vak vɨga lɨgandi kat wandɨ. Kɨta 65 nyan wuna kwupmba kwo ana yaigandɨ. Wuna nyaek wandɨ maa yaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wandɨ maa ndɨna kwupmba la nɨma sakwat nɨmba ndɨ kat kai waa kwagalalaa yindɨ. Ndɨnogwinala ana kɨta vat yetɨndi. ");
INSERT INTO ian_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yindi maa wan tamba vɨli kiyeli vɨlɨlɨk nɨmba kat wagalandɨ. Ngwutno ndinogwinala wun kat kai waa kwagalalaa ygiyangwuk waa wagalandɨ ndi kat. ");
INSERT INTO ian_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Wagaglandɨ maa Pita ndɨ kat wandɨ. Njambwi nyan mɨn kat kwagalalaa anda nat nyan kat yigiyanɨn. Yineya nat nyan ana lɨgandɨ. Mutɨma nyaangɨt njɨmbla njɨmbla apma vat tɨneya vat nɨn kat vɨsɨmogwilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mɨn Kraist mɨn. Mɨn Godna nyan mɨn. Mɨn God yetɨlɨga vak vla yetɨlɨgamɨn waa maawupmba yelavɨka lɨganɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wandɨ maa Jisas ndi kat wandɨ. Ngwuk tamba vɨli kiyeli vɨlɨlk palɨ ngwuk kat wowun maa wuna kwupmba yangwuk. Ngwut aywaa apma maawut tɨga nɨmba mɨna ana lɨgangwuk. Ngwutna kɨta nyan Seten kwiya maawupmba yelavɨka lɨga nyana waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iskeriot Saimona nyan kat wupma wandɨ. Ndɨ tamba vɨli kiyeli vɨlɨlɨk ta nɨmbana kɨta nyana. Ndɨ ngɨni Jisas kat sɨgiyaa nɨmba kat kamwin kwivat ta nyana. ");
INSERT INTO ian_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tɨga lɨga Jisas Galilimba yi ya yetɨndɨ. Judiamba lɨga njambwi Juda ndɨ kat vatnyavat tɨndi. Ngi kat tɨga judia kwagalalaa Galilimba yiga yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judana pesto tamba ndina ngwat ndu haus sel kwutna yetɨla njɨmbla kat yelavɨtɨnja pesto tamba ngway tolandɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngi kat tɨga ndɨna yakwa nɨmba ndɨ kat wandi. Wan kava kwagalalaa judiat ay mɨla. Judiamba lɨga mɨna mbaapmamba la nɨmba nɨma njɨvwa kwutɨma njɨvwa vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwutɨma njɨvwa pagwumeyan ana nglaatndɨ. Kapmba kwupmeyan apma vala. Nɨma sakwat nɨmba vɨgiyandi. Njambwi nyan tɨma vak vɨlaa yelavɨka lɨgiyandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ndi kwo wandi. Njambwi nyanat tɨdna vat ana vɨga lɨndi ndɨna yakwa nɨmba. ");
INSERT INTO ian_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wandi maa Jisas ndi kat wandɨ. Njambwi nyanat tɨwa vat ndi kat sɨmogwiweya njɨmbla wata ana ngway tolaga lɨgandɨ. Pesto kat yilaa ngwutna mɨndama ndi kat vɨsɨmogwingweya vat nɨma vat ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wundi Juda ngwuk kat ana kai walɨgandi. Wun kat kai walɨgandi. Ndi kat vɨlaa ngwuk kavle nɨmba ngwuk waa wowun maa wun kat kai walɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ngwuk kapma ay ngwula. Wan pesto lɨga njɨmbla wun ana yigiyowun. Njambwi nyanat tɨwa vat ndi kat vɨsɨmogwiweya njɨmbla ana ngway tolaga lɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas ndi kat wandɨ maa yindi maa Jisas kapma Galilimba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndɨna yakwa nɨmba pesto kat yindi maa ndɨ kapma pagwuga ndina kwupmba yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pestomba la ndi Juda Jisas kat kwaka ndɨ andamba lɨgandɨ waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nɨma sakwat nɨmba ndɨna sɨ waga awat sowat walealɨndi. Nat nɨmba ndɨ woseka walɨga nyana. Kavle nyana waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Walea lɨga walɨnja vak kapmba mɨna ana walɨndi. pagwuga mɨna walɨndi. Juda kat vaaka pagwuga mɨna walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pesto la nɨndɨ nandinya Jisas God kat kwunatɨnja ngay wuleilaa nyaangɨt mbutɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mbutɨnda nyaangɨt wutaa Juda ngɨpali walaa wandɨ. Manda kat vɨlɨnja vat kaawa viyaga ngambu lɨnja vak wutɨndɨ. Ndɨ skul ya nyan ana ndɨ waa ngɨpali walaa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas ndi kat wandɨ. Mbutɨwa nyaangɨt wuna nyaangɨt ana ndɨ. Wun kat ay waa nyana nyaangɨtna. ");
INSERT INTO ian_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kɨta nyan wun kat ay waa nyan yelavɨka la maawut vla yelavɨka lɨndeyan mbutɨwa nyaangɨt wutaa God kwiya nyaangɨtna? E. Kɨpmamba lɨga nyana nyaangɨtna waa sɨga naguga yelavɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wuna nyaangɨt mbukewan. Wupma ana mbutɨgowun. Wun kat ay waa nyana sɨ kwutaa katsongwangat mbutɨgowun. Sɨmblan ana mutɨgowun. Kavle vat ana yiga yetɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ngwula tamba la nyan Moses ngwuk kat nyaangɨt mbuka njambiya taagandɨ. Ndɨnai kwiya njambiyana vapmba ana yiga yetɨlɨgangwuk. Ndɨ Moses kwiya njaambiyamba ana yetɨlɨgandɨ. Ndɨ kat vatnyagiyanɨn waa manda kat wun kat walɨgangwuk waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wagalandɨ maa ndi wandi. Kavle waagan mɨn kat tavindɨ maa mɨn apma maawut ana yelavɨka lɨgamɨn. Mɨn kat ana vatnyavat tɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wandi maa Jisas wandɨ. Njɨvwa lapman nandinyamba nɨma njɨvwa kɨta kwukwun maa vɨlaa manda kat wupma yindɨ waa wangwuk wun kat. ");
INSERT INTO ian_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mbangɨ pɨtɨngwa vak Mosesnanamba klangwuk. Tamba la nɨmba Mosesna ngwak walanga ndino mbangɨ pɨtɨndi. Njɨvwa lapman nandinyamba mbangɨ pɨtɨngwuk. ");
INSERT INTO ian_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Njɨvwa lapman nandinyamba kɨta nyan kat samat kwunapmak ndɨna mbangɨ pɨtaa nɨn Moses waa njɨvwa lapman nandinyana njambiya kat ana kai wanɨn waa walɨgangwuk. Wun njɨvwa lapman nandinyamba yelogwengat ta nyan kat aywaa kwunakwun maa vɨlaa wun kat kai wangwuk. Manda kat. ");
INSERT INTO ian_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mɨnimba vɨngwa vak kat mɨna yelavɨtaa sɨga nagungweyan ana sɨmblan sɨga nagugiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nat nɨmba Jerusalemna nɨmba Jisas kat vɨlaa walɨndɨ. Wan vatnyavat tɨnja nyan kɨngiyan? E? Kai. ");
INSERT INTO ian_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ndɨ ana pagwuga mbutɨgandɨ. Kapmba mbutɨgandɨ Judana njambwi nɨmba ndɨ kat vɨlaa ndɨ nɨn kat kwunapmak God wandɨ, yaa nyana waa anagandi yelavɨkna. ");
INSERT INTO ian_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndɨ wan nyan Kraist ana ndɨ. Wan nyana angwa ngepma vɨga lɨganɨn. Kraistna angwa ngepma ana vɨga lɨgiyanɨn waa nat nɨmba walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wandi maa Jisas God kat kwunatɨnja ngay wuleilaa laataa ndi kat nyaangɨt mnbutɨndɨ. Wuna mɨndama vɨga lɨgangwuk. Wuna angwa ngepma wuka lɨgangwuk. Wun kat ay waa wan nyan kat ana vɨga lɨgangwuk. Wun kat ay waa wan nyan kat ana vɨga lɨgangwuk. Avla ana yawun. Ndɨ wandɨ maa yawun. ");
INSERT INTO ian_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndɨna mɨndama vɨga lɨgowun. Ndɨnai lɨga kavamba lɨga yawun. Ay wandɨ maa yawun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wandɨ maa nat nɨmba ndɨ kat kwutaa kalilaa kavle vat yivat wandi. Ndɨ kat ana kwutndi. Ndɨ kat kwutnjeya njɨmbla ana ngway tolaga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nat nɨmba ndɨ kat vɨlaa ndɨ Kraistna. Ndɨ God wandɨ maa yaa nyana waa yelavɨtaa wandi. Ngɨni nat nyan yalaa kwutɨnda nɨma njɨvwa kat ana kwulakiyandɨ. Ngi kat tɨga wan nyan God kwiya nyana waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wundi nɨmbandi awat sowat waleaga walɨnja vak Ferisi wutaa Ferisio God kat kwunatɨga njambwi nɨmbo wandi maa plisman Jisas kat kwupmat yindi. ");
INSERT INTO ian_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ndɨ kat kwupmat yandi maa Jisas ndi kat wandɨ. Nɨma njɨmbla ana ngwutnogwinala lɨgiyowun. samat tɨga ngwuk kat kwagalalaa wun kat ay waa wan nyan tɨga kavat yigiyowun. ");
INSERT INTO ian_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yiwun maa wun kat kwaka vɨlevilaa lɨgiyangwuk. Yiwa kava ngwut ana yaigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wandɨ maa Juda ndi awat sowat walɨndi. Anda kaya yinda ndɨ kat kwaka vɨlevilaa lɨgiyanɨn. Kava kavamba lɨga Juda kat ndi kat vɨvat anagandɨ yiga. Juda ana ndi nat nɨmba lɨga kava kavat anagandɨ yiga. Yilaa ndi kat nyaangɨt sɨmogwigiyaa. ");
INSERT INTO ian_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wun kat kwaka vɨlevilaa lɨgiyangwuk waa manda kat wandɨ. Yiwa kava ana yaigangwuk waa manda kat wandɨ waa awat sowat walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Wan Judana pesto ngɨni la la nandinya Jisas laataa nɨma kwundimba walaga wandɨ. Kɨta nyan ndɨna mbanjɨnge pundeyan wuna lak yaigandɨ. Ndɨ kat apma lɨsɨk ngu kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kɨta nyan wun kat vɨlaa ndɨ God wandɨ maa yaa nyana waa yelavɨtndeyan tamba pɨlɨwutnja vak ndɨnamba tɨgiyandɨ. Waangumba wogwelɨga ngu nat nɨmba kat kwinja vla wan nyan wupma nat nɨmba kat kwunatndɨ maa njɨmbla njɨmbla apma vat tɨgiyandi waa tamba pɨlɨwutndi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas kɨgɨn ngu kat ana wandɨ. Godna waagan kat wandɨ. ndɨ kat vɨlaa ndɨ God wandɨ maa yaa nyana waa yelavɨka lɨgiyaa nɨmba God wandɨ maa yaa nyana waa yelavɨka lɨgiyaa nɨmba God kwiya waagan klaigandi waa Jisas wandɨ. Wan njɨmbla Jisas mbukna njɨmbla God ndɨna waagan ana kwiga lɨndɨ. Jisas nyinangwut wokendɨ maa kwindɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas mbuta nyaangɨt nɨma sakwat nɨmba wutaa wandi. Ndɨ kawiga lɨna profetna waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nat nɨmba wandi. Ndɨ God kwiya nyana. Ndɨ Kraistna waa wandi. Nat nɨmba wandɨ. Ndɨ Kraist ana ndɨ. Kraist Galilimba lɨga nyanat ana lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tamba la nɨmba God waa nyaangɨt pɨlɨwutndi. Kraist Devitna yelangɨ nyanat tɨgiyandɨ. Devitna angwa ngepma Betlehem walɨnja ngepmamba lɨga yaigandɨ waa tamba pɨlɨwutndi waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","44","Ngi kat tɨga awat sowat waleaga walɨndi. Ndina nat nɨmba ndɨ kat kwutaa kalilaa kavle vat yivat wandi. Ndɨ kat ana kwutndi. ");
INSERT INTO ian_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ndɨ kat kwupmat ya plisman ndi kwo lɨga lungwamataa yindi. Yindi maa God kat kwunata njambwi nɨmbo Ferisio ndi kat vɨlaa wagalandi. Manda kat ndɨ kat kwutapman kwo yangwuk waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wagalandi maa plisman wandi. Tat ta kɨta nyan ndɨnai ngambula vla ana ngambulɨndɨ. Ndɨnai waa nyaangɨt wutaa ana alɨpsɨga ndɨ kat kwukiyanɨn waa wandi plisman. ");
INSERT INTO ian_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wandi maa Ferisi ndi kat njɨka wagalandi. Woseka walɨnda nyaangɨt nɨma sakwat nɨmba wutaa yelavɨka ndina maawupmba kwutaa lɨndi. Ngwutno kwutaa lɨgangwuk? Waa njɨka wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nɨn Ferisio Judana nat njambwi nɨmbo ndɨnai ngambulaa nyaangɨt wutaa yelavɨka nɨna maawupmba ana kwutaa lɨganɨn. Ngwuk manda kat mandɨt vat yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wundi nɨmba wan tamba la nyaangɨt ana wuka lɨgandi. Ngi kat tɨga kavle maawut yelavɨka lɨga Jisas waa nyaangɨt wuka lɨgandi waa Ferisi njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wandi maa ndina kɨta nyan laataa wandɨ. Ndɨna sɨ Nikodimas. Tak wan nyan nganat Jisas kat wagalavat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ndɨ wandɨ. Nɨna ngepma yelɨna vak vla ana yilɨgangwuk. Nɨn kɨta nyan kat ana kwo kai walɨganɨn. Ndɨna kwundi wutaa sɨga nagugiyanɨn. Nɨna ngepma vat kɨngiyan waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wandɨ maa ndɨ kat njɨka wandi. Mɨno Galilina nyan mɨn. Tamba pɨlɨwutnja nyaangɨt mɨn avɨ mɨla. Wan kawiga lɨna profet Galilimba ana laapkiyandɨ waa vɨgiyamɨn waa ndɨ kat njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wandi maa yisolaa lɨnja kava kwagalalaa kɨta nyan kɨta nyen laaptaa mɨna ngegavat yindi. ");
INSERT INTO ian_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ndina ngegavat yindi maa Jisas Oliv walɨnja nduwiat wokendɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nat nandinya ngambi nglei dailaa God kat kwunatɨnja ngay wuleindɨ maa nɨma sakwat nɨmba ndɨ kat yandi maa ndɨ ndaa lɨga ndi kat vɨsɨmogwindɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vɨsɨmogwi lɨndɨ maa Judana lo kat sɨmogwi la nɨmbo Ferisio taagwa kwutaa ndɨna lak kalindi. Wat taagwa yambɨsɨk yilɨnja vak kwutaa lɨla vak vɨlaa lɨ kat kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kalilaa Jisas kat wagalandi. Njambwi nyan wat taagwa yambɨsɨk yilɨnja vak kwutaa lɨlɨ, vɨnɨn. ");
INSERT INTO ian_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses nɨn kat tamba kwiya lomba wandɨ. Yamɨsɨk yilɨga nɨmba kat tamba kwiya lomba wandɨ. Yambɨsɨk yilɨga nɨmba kat vatnya ngwula waa wandɨ. Mɨn angamak walɨgamɨn waa Jisas kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kavle nyaangɨt mbutndeyan ndɨ kat nɨma vat yigiyanɨn waa yelavɨtaa wagalandi. Wagalandi maa Jisas ndi kat ana awat wandɨ. Valolaa lɨga sɨt taambamba kɨpmamba pɨlɨwutndɨ. Nɨn kat ana wutɨgandɨ waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngi kat tɨga ndɨ kat wagala wagala lɨndi. Jisas laaptaa ndi kat wandɨ. Ngwutna kɨta nyan kavle vat yilapman yilɨgiya nyan ndɨ kambak kwutaa wat taagwa kat vatnyvat tat yaagigiyandɨ ");
INSERT INTO ian_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","waa walaa valolaa nat njambɨ kɨpmamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ndɨnai waa nyaangɨt wuta nɨmba ndina maawupmba yelavɨtndi. Nɨn kavle vak yiga yetɨlapman nɨmba ana nɨn waa yelavɨtaa wup yilaa kwagalalaa wogwendi. Njambwi nɨmba tak wogwendi. Nat nɨmba ndina kwupmba wogwendi. Wogwendi maa Jisaso wat taagwo mbɨk kapma lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas laaptaa taagwa kapma lɨlangat vɨlaa lɨ kat wandɨ. Nyɨn kat vatnyavat yalaa la nɨmba andambpa lɨgandi. Nyɨn kat kai walɨga nɨmba andamapa lɨgandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wandɨ maa walɨ. njambwi nyan ndi tamba yindi. Walɨ maa wandɨ. Nyɨn kat wuno kai ana waigowun. Ngɨni kavle vat wata yinyeya. Kwo ay nyɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas nat njambɨ ndi kat wandɨ. Wun kɨpma lɨga nɨmba kat apma vat kwilɨga nyan wun. Vɨkemba ya vla lɨgowun. Kɨta nyan wuna kwupmba yandeyan kulun wala kavle vat kwagalalaa ya vɨtɨgiya kavamba yetɨvla apma vat yetɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wandɨ mala Ferisi Jisas kat wandi. Wun njambwi nyan wun avla walɨma vat ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wandi maa Jisas awat ndi kat wandɨ. Wuna lak waweyan nglaatndɨ. Yawa kava vɨga lɨgowun. Ngɨni yiweya kava vɨga lɨgowun. Yalaa yiweya kava ngwut ana vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ngwuk kɨpmana vapmba nat nɨmba kat vɨlaa sɨga nagulɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ndi kat vɨlaa sɨga naguweyan ndina maawupmba lɨga vak kat vɨlaa apma vat savagu sɨga nagugiyowun. Wun kapma lɨga ana sɨga nagugiyowun. Wun kat ay waa nyan wuna nyaek wunamba lɨndɨ, sɨga nagugiywoun. ");
INSERT INTO ian_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ngwutna ngepmana vak kɨngiyan pɨoɨwutnja. Vɨlɨlɨk palɨ laataa kɨta vak kɨta nyaangɨt mbupmbeyan wan nyaangɨt ana ndaigiyandɨ waa walɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wun kɨta nyan njambwi nyanat tɨwa vat wun avla walɨgowun. Wun kat ay waa nyan wuna nyaek ndɨno njambwi nyanat tɨwa vat dɨ walɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wandɨ mala ndi wandi. Mɨna nyaek andamapmba lɨgandɨ waa wandi maa Jisas wandɨ. Wun kat ana vɨga lɨgangwuk. Wun kat vɨga lɨgengwan wuna nyaek kat vɨga lɨgengwuk waa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wan nyaangɨt God kat kwunatɨnja ngay ndi kat sɨmogwivat wuleilaa sanya nagilɨnja kavamba mbutɨndɨ. Mbutɨndɨ mala ndɨ kat kavle vat yivat ana kwutaa kalindi. Ndɨ kat kwutaa kalinjeya njɨmbla wata ana ngway tolaa lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ndi kat nat njambɨ wandɨ. Yiwun maa wun kat kwaka vɨleviga kavle vat tɨga kiyaigangwuk. Yiweya kava ana yaigangwuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wandɨ maa Juda wagalandi. Avla anagandɨ vatnyagiya. Yiweya kava ana yaigangwuk waa manda kat wandɨ waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","wagalandi maa Jisas ndi kat wandɨ. Ngwut kɨpmana nɨmba ngwuk. Wun nyinangwutna nyan wun. An kapma kapma nda li. ");
INSERT INTO ian_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngi kat tɨga ngwuk kat wowun. Kavle vat tɨga liyaigangwuk waa wowun. Wun kat vɨlaa ndɨ God wandɨ yaa nyana waa yelavɨtapman yingweyan ngwut kavle savle lɨga kiyaigangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wandɨ maa wandi. Mɨn anda nyan mɨn waa wandi maa Jisas ndi kat wandɨ. Tat ngwuk kat tɨwa vat tamba mbukwun. Mandɨt vak ana mbukiyowun. ");
INSERT INTO ian_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngwuk kat mbukweya nyaangɨt nɨma sakwat tɨndɨ maa vɨlaa sɨga nagugiyowun. Wun kat ay waa nyan savagu vapmba vɨga sɨga nagulɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wanda nyaangɨt wutaa wuna ngaek waa God kat wanda vak ana wuka vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jisas ndi kat nat njambɨ wandɨ. Wun Godna vat ndinyangu kat mbutɨga nyan wun. Ngɨni wun kat kwutaa katsolaa wun kat diwai krosmba kaalandi maa ndi wun kat vɨlaa dɨ God wandɨ, yaa nyana waa waigandi. Ndɨ ndɨnai yelavɨtɨga vapmba ana njɨvwa kwutɨgandɨ. Ndɨna nyaek wandɨ maa nyaek waa vapmba njɨvwa kwuka nyaangɨt mbutɨgandɨ waa waigandi. ");
INSERT INTO ian_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wun kat ay waa wan nyan wun kat ana kwagalaa lɨgandɨ. Kapma ana tɨlɨgowun. Ndɨnai maawupmba yelavɨka wanda vapmba mɨna njɨvwa kwutɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wan nyaangɨt wandɨ maa nɨma sakwat nɨmba wutaa ndi ndina maawupmba yelavɨka kwutaa lɨndi. Jisas God wandɨ, yaa nyana waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndɨ kat wuka kwutaa lɨngwa vak ke kwagalangwa. Kwagalapman yingweyan wuna mbaapma nɨmba tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wun kat kwagalalapman yingweyan wunai waa nyaangɨt wuka kwutaa lɨngweyan mbambala ngwuk kat ngila la vɨga la kavle vat ngɨlɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jisas wandɨ maa Juda ndɨ kat wandi. Nɨn Ebrahamna nyangu nɨn. Nat nɨmba nɨn kat ana kandi kwutaa kalilaa nɨn kat vɨga lɨndi. Manda kat ngwuk kat kwutaa vɨga la vak ngɨlɨgiyandɨ waa wamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas ndi kat wandɨ. Ngwuk kat woseka ana waigowun. Awuk ngwula. Kavle vat yiga yetɨlɨga nyan wan kavle vat ndɨ kat ngilaa lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kɨta nyan ngayna njɨvwa kwupmak kat ndɨ kat kematndi maa tɨndeyan ndɨ wan ngaymba njɨmbla njɨmbla ana lɨgiyandɨ. Wan ngayna apma nda ngɨni ndɨ ana klaigandɨ. Ndɨ njɨvwa kwuta nyan mɨna lɨgandɨ. Wan ngay vɨga la nyana nyan ndɨ wan ngaymba njɨmbla njɨmbla tɨga ngayna apma nda klaigandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wun Godna nyan wun. Ngwuk kat ngilaa lɨga nda njalakweyan apma nglei vat tɨga Godnana apma nglei nda klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɨn Ebrahamna nyangu nɨn waa walɨgangwuk. Vɨga lɨgowun. Mbutɨwa nyaangɨt wupmak kat kai waa wun kat vatnyavat tɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wuna nyaek tɨga kavamba tɨga vɨwa vat ngwuk kat mbutɨgowun. Ngwutno ngwutna nyaek yeta vla yetɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wandɨ maa Juda wandi. Nɨna nyaek Ebraham waa wandi maa Jisas ndi kat wandɨ. Ebraham ngwutna nyaek ana ndɨ. Ebraham ngwutna nyaekna tɨgendan ndɨnai yeta vla yetɨgengwuk. Wupma kai. ");
INSERT INTO ian_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wun Godnanamba wutuwa nyaangɨt ngwuk kat mbutɨgowun. Woseka waluwa vat ana ndɨ. Wan nyaangɨt wutaa wun kat vatnyavat tɨgangwuk. Mbambala God kwiya nyan kat kai walɨngwa vla tamba la nyan Ebraham wupma God kwiya nyan kat ana kai walɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngwutna nyaek nat nyana. Ngwutna nyaek yeta vla yetɨlɨgangwuk waa Jisas wandɨ maa Juda ndɨ kat wandi. Nɨn avla ana laataa lɨganɨn. God wandɨ mala laataa lɨganɨn. God nɨna nyaekna. Ndɨna kwundi mɨna wuka liganɨn waa wandi maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","God ngwutna nyaeknat tɨgendan gwuk wun kat vɨlaa woviyaguga lɨgengwuk. Ndɨnai lɨga kavamba tɨwun maa wun kat wandɨ maa yawun. Wunai yelavɨkna vapmba ana yawun. Ndɨ wandɨ maa yawun. ");
INSERT INTO ian_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngwuk kat mbutɨwa nyaangɨt ngwutna maawut ana yelavɨka lɨgandɨ. Mbutɨwa nyaangɨt ana alɨpsɨga wuka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ngwutna nyaek yelavɨka vapmba yelavɨka lɨgangwuk. Ngwutna nyaek Seten. Ngwutna nyaek kavle vak yilɨnda vla wupma yilɨgangwuk. Tamba nat nɨmba kat vatnyalaa nyana. Ndɨ woseka walɨga nyana. Ndɨna maawupmba yelavɨka kwovak kwovak woseka mɨna walɨgandɨ. Ndɨ woseka walɨga nɨmbana njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wun ana ngwuk kat woseka walɨwun maa ndɨ woseka walɨgandɨ waa walɨgangwuk wun kat. ");
INSERT INTO ian_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wun kavle vat ana yilɨgowun. Wan yɨwa kavle vat wun kat sɨmaga ngwula. Vɨlu. Ana alɨpsɨga sɨmagaiyangwuk. Ngi kat tɨga ndɨ woseka walɨgandɨ waa manda kat walɨgangwuk wun kat. ");
INSERT INTO ian_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godna nyangu ndina nyaek waa vak wuka lɨgandi. Ngwuk Godna nyangu ana ngwuk. Ngi kat tɨga God waa vak ana wuka lɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wandɨ maa Juda wandi. Tak ndɨ kat Sameriana nyana tungwengwan yiga lɨga nyana waa walɨnɨn. Tak ndɨnamba kavle waagan tavindɨ mala kavle vat yilɨndɨ waa walɨnɨn. Ngiyambak walɨnɨn waa wandi maa Jisas ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wun kavle waagan tavi lɨga nyan ana wun. Wuna nyaekna sɨ mɨna kwutaa katsolɨgowun. Ngwuk wuna sɨ kwutaa viyasanda lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wuna sɨ avla kwutaa katsovak kat ana kan njɨvwa kwutɨgowun. Nat nyan wuna sɨ kwutaa katsovak walɨgandɨ. Wuna sɨ kwutaa viyesanda lɨga nɨmba kat ndɨ kat nɨma vat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngwuk kat woseka ana waigowun. Awuk ngwula. Kɨta nyan mbutɨwa nyaangɨt wuka yetɨndeyan ndɨ ana kiyaigandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas wandɨ maa Juda wandi. Wama vak wutaa kavle waagan mɨnamba tavilaa lɨnda vak vɨga lɨganɨn. Tak mɨn wamɨn. Kɨta nyan mbutɨwa nyaangɨt wuka yetɨndeyan ndɨ ana kiyaigandɨ waa wamɨn. Ebrahamo tamba la profetno tamba kiyandi luwa. ");
INSERT INTO ian_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nɨna walanga Ebraham ndɨ tamba kiyandɨ. Mɨn ndɨ kat kwulatɨgamɨn? E? Ndɨ mat nyana? Mɨn ndɨna njambwi mɨn? Tamba la profet ndino tamba kiyandi. Mɨn ndi kat kwulatɨgamɨn? Waa njɨka wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wagalandi maa Jisas ndi kat wandɨ. Avla wuna sɨ kwutaa katsoweyan nɨma nda ana ndɨ. Wuna nyaek God ndɨ wuna sɨ kwutaa katsolɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngwuk ndɨna mɨndama ana vɨga lɨgangwuk. Wun wuka vɨga lɨgowun. Ana vɨga lɨgowun waa waweyan woseka walɨngwa vak vla wupma wigowun. Woseka ana waigowun. Ndɨna mɨndama vɨga lɨgowun. Ndɨnai waa vapmba yetɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ngwula walanga Ebraham tɨwa vat vɨlaa solat sɨlɨndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wandɨ maa Juda wandi. Mɨna ndɨmwe ndumi vɨli kiyeli tamba vɨli ana ndɨ. Ebraham kat angamak yila vɨmɨn waa njɨka wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wagalandi mala Jisas ndi kat wandɨ. ngwuk kat ana woseka wowun. Tamba wunai ta njɨmbla Ebraham wata ana lɨndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas wandɨ maa ndɨ kat vatnyavak kambak klaa kwutaa lɨndi. Jisas pagwuga yiga God kat kwunatɨnja ngaymba lɨga wogwendɨ. Ndi nɨma sakwat nɨmba yisolaa lɨndi, ndɨ pagwuga yiga yisolaa la nɨmba kat kwagalalaa yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ava yambɨmba yiga lɨga way ava yambɨmba la mɨni vɨlapman nyan kat vɨndɨ. Nyime ndɨ kat kwukna njɨmbla mɨni kwitaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vɨndɨ maa Jisasna kwupmba la nɨmba ndɨ kat wagalandi. Njambwi nyan, kanda ya kavle vatna ndɨna mɨni tɨvɨlaa lɨndɨ maa vɨlapman yilɨnda. Ndɨnai ya vatna? E? Nyaek nyɨme ya vatna? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Wagalandi maa wandɨ. Kai nyaek nyɨme ya kavle vat ana ndɨna mɨni kavle yindɨ. Avla yinda kavle vat ana ndɨna mɨni kavle yindɨ. Avla yinda kavle vat ana ndɨna mɨni kavle yindɨ. God ndɨ kat kwunatndeya vat nat nɨmba kat vɨsɨmogiwangat ndɨna mɨni kavle yilaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mbambala God waa njɨvwa kwukiyowun. Mbambala nya sɨlɨga nandinya vla lɨgandɨ. ngɨni yaiga nandinya ngan vla lɨgiyandɨ. Wan ngɨni yaiga njɨmbla Godna njɨvwa ana alɨpsɨga kwuka lɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mbambala wun kɨpmamba lɨwan ndinyangu kat apma vat yelavɨtɨnja vak kwilɨwa njɨvwa kwukiyowun nɨmamba waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","kɨpmamba sɨpmiya sandɨ. Sɨpmiya salaa kɨpmamba lɨgangindɨ. lɨgagilaa wan kɨpma klalaa kavle mɨni la nyana mɨnimba taagalaa ");
INSERT INTO ian_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Siloam walɨnja nguat yilaa yagu mɨla waa wandɨ Jisas. Wan ngunana sɨ dina kwundimba Siloam walɨndi. Siloamna angwa nyaangɨt Ay Mɨla. Jisas ay wandɨ maa yilaa ngu yagundɨ maa ndɨna mɨni vɨndɨ apma vat. ");
INSERT INTO ian_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndɨna mɨni vɨlɨndɨ maa ndɨna ngepma nɨmba ndɨ kat vɨlaa wagalandi. Wan nyan tat mɨni vɨlapman tɨga sanya kat yawila nyana? Kai? nat nyana? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nat nɨmba wandi. Awa luwa kɨngiya ndɨ. Nat nɨmba wandi. Kai. Nat nyana. Ndɨna mɨndama vla lɨgandɨ waa wandi. Ndɨ wandɨ. Kai. Wunayɨ. Tat mɨni vɨlapman yeta nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wandɨ maa ndɨ kat wagalandi. Anda vapmba yilaa mbambala wan mɨna mɨni vɨlɨgamɨn waa wagalandi maa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jisas walɨnja nyan kɨpma kwutaa wuna mɨnimba taagalaa Siloam walɨnja ngu yiga yagu mɨla waa wandɨ maa yiga yaguwun maa wuna mɨni kembandɨ maa vɨgowun waa wandɨ maa ndɨ kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wan nyan Jisas andambapmba lɨgandɨ waa wagalandi maa ana vɨgowun wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndɨna ngepma nɨmba mɨni vɨlapman ta nyan kat kwutaa Ferisi yisolaa la kavat kalindi. ");
INSERT INTO ian_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas kɨpma kwutaa ndɨna mɨni kwunatnda nandinya ndina njɨvwa lapman tɨlɨnja nandinya. ");
INSERT INTO ian_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ferisi ta kava yandɨ maa ndɨ kat wagalandi. angamak yilaa mɨn mɨni vɨmɨn waa wagandi maa wandɨ. Wan nyan kɨpma kwutaa wuna mɨnimba taagandɨ maa ngu yagulaa mɨni apma vat vɨgowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wandɨ maa nat Ferisi wandi. Ndɨ kat kwunata nyan God wandɨ maa yaa nyan ana ndɨ. Njɨvwa lapman nandinya kwo tɨlɨna vla ndɨ wupma ana njɨvwa kwagalalaa kwo lɨlɨgandɨ waa wandi. Ndina nat nɨmba mandɨp vak mandɨp vak wandi. Kavle vat yiga yetɨlɨga nyan kan njɨvwa ana alɨpsɨga kwukiyandɨ. Ndɨ apma nyana waa wandi. Wungi vapmba waga mbaapma vɨlɨlɨk sɨndi. ");
INSERT INTO ian_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tat mɨn kiyala la nyan kat nat njambɨ wagalandi. Mɨn angamak yelavɨka lɨgamɨn. Ndɨ apma nyana? E? Kavle nyana? Waa wagalangi maa ndɨ profetna waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wundi Juda ndɨnai waa nyangɨt wutaa yelavɨtndi. ndɨna mɨni tak kavle yindɨ maa yetɨndɨ? E? Woseka walɨgandɨ waa yelavɨka ndɨna nyaek nyɨme kat yagwa wandi. ");
INSERT INTO ian_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wandi maa yambɨk maa mbɨk kat wagalandi. Kan mbɨla nyana? Mɨni kavle ya nyana? Angamak yilaa kan mɨni vɨndɨ waa wagalandi maa wambɨk. ");
INSERT INTO ian_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Awa luwa kan nyan ana nyana. Nyɨme ndɨ kat kwutaa njɨmbla ndɨna mɨni kavlea. ");
INSERT INTO ian_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Angamak yilaa mbambala vɨnda vak ana yelavɨka lɨga. Ndɨna mɨni anda nyana kwunakna. Ana vɨga lɨga. Ndɨ kat wagala ngwula. Ndɨ tamba nɨma ndua. Ndɨ avla mbukiyandɨ waa wambɨk ndɨna nyaek nyɨmeo. ");
INSERT INTO ian_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ndɨna nyaek nyɨmeo kapmba ana mbupmbɨk. Pagwuga mbupmbɨk. Juda kat vaaka lɨga pagwuga mbupmbɨk. Tak Juda walɨndi. Kɨta nyan Jisas God wandɨ, yaa nyana Kraistna waa waiga nyan kat wungi nyan kat kɨklinɨn maa yisolaa lɨlɨna ngay ana wuleigiyandɨ waa tak walɨndi. Ngi kat tɨga ndɨna nyaek nyɨmeo vaaka lɨlɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngi kat tɨga wambɨk. Ngwuk ndɨ kat avla wagala ngwula. Ndɨ ngwuk kat mbukiyandɨ waa walɨmbɨt nyaek nyɨme. ");
INSERT INTO ian_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wambɨt maa nat njambɨ mɨni kavle yila la nyan kat yagwa mɨla walaa nat njambɨ wandi. Mɨna mɨni apma vat tɨnda vak kat God kat sɨvu agɨ mɨla. Wun kat kwunatndɨ waa wama nyan kavle vat yilaa nyana. Ndɨ ana mɨn kat kwunatndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wandi ma wan nyan wandɨ. Wun ana vɨga lɨgowun. Kavle vat yiga yetɨlɨga nyana? E? Apma vat mɨna yilɨga nyana? Ana vɨga lɨgowun. Kɨta vak mɨna vɨga lɨgowun. Tak wuna mɨni ana vɨlɨwun. Mbambala tamba apma vat vɨga yetɨgowun. Ngi vat mɨna vɨga lɨgowun wun kat yinda vat mɨna waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ndi wandi. Wan vak anda vapmba mɨna mɨni kwunatndɨ maa vɨga lɨgamɨn waa wandi waa Juda. ");
INSERT INTO ian_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wandi maa wandɨ. Manda kat njɨmbla njɨmbla wagalalɨgangwuk. Wun kat ya vat tamba mbukwun maa wuka lɨgangwuk. Ndɨna kwupmba yivak kat nat njambɨ wupmak wunkat wagalalɨgangwuk? Waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ndɨ kat njɨka wandi. nɨn ndɨna kwupmba la nɨmba ana nɨn. Mɨn ndɨna kwupmba la nyan mɨn. Nɨn Mosesna kwupmba lɨganɨn. Ndɨ nɨna njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tamba God ndɨnai waa nyaangɨt Moses kat mbutɨndɨ. Vɨga lɨganɨn. Wan nyan Jisas wupma kai. Ndɨ andamba la nyana. Ana vɨga lɨganɨn waa ndɨ kat njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wandi maa ndi kat wandɨ. Wan vak nɨma vatna. Ngwuk ana vɨngwuk Jisas andamapmba yandɨ. Ndɨ nɨma njsvwa kwuka wuna mɨni kwunatndɨ. Wan vat nɨma vatna. ");
INSERT INTO ian_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kavle at yiga yetɨlɨga nɨmba God kat wagalalɨnja vak ana wutɨgandɨ. Vɨlɨganɨn. Kɨta nyan God kat yelavɨka ndɨnai walɨga vapmba yetɨndeyan wagalandeya vak God wukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tamba njlei mbambala vɨna vat ana lɨndɨ. Nyɨme kwutɨ maa kavle mɨnio la nyan kat nat nyan kwunatnda vat tak ana lɨndɨ kan kɨpmamba. ");
INSERT INTO ian_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jisas God wandɨ, yaa nyanat tɨlapman yigenda wan nɨma njɨvwa kwunatnda njɨvwa ana kwukendɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wandɨ maa ndɨ kat kimbut yiga wandi. Mɨna nyɨme mɨn kat kwutɨ maa mɨn kavle vat yiga yetɨga nyan mɨn. Manda kat nɨn kat vɨsɨmogwi vat yelavɨka lɨgamɨn waa kimbut yiga walaa ndɨ kat kɨklindi. ");
INSERT INTO ian_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ndɨ kat kɨklinja vat Jisas wutaa ndɨ kat kwaka yiga vɨndɨ. Vɨlaa wandɨ. Godna vak ndinyangu kat vɨsɨmogwi lɨga nyan kan kɨpma ngaga yandɨ waa yelavɨka lɨgamɨn? Waa wagalandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jisas wandɨ maa wan nyan wandɨ. Godna vak ndinyangu kat vɨsɨmogwi lɨga nyan anda nyana? Wun ana vɨwun ndɨ kat waa wandɨ maa Jisas ndɨ kat vɨlaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ndɨ kat tamba vɨmɨn. Wunayɨ waa Jisas wandɨ maa wan nyan wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ngiyambak wama. God wandɨ maa yaa nyan mɨn. Njambwi nyan mɨn waa walaa kwali kwali sɨlaa ndɨ kat sɨvu kɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas wandɨ. Ndinyangu kat mbaapmba vɨlɨlɨpmba taagavat yawunkan kɨpma. Nat mbaapma nɨmba nɨn nabuo lɨga nɨmba nɨn waa walɨgandi. Ndi butɨwa nyaangɨt wutaa ndina maawupmba ana yelavɨtɨgandi. Nat mbaapma nɨmba nɨn nɨma sakwat vak kat ana yelavɨka lɨganɨn waa walɨgandi. Ndi mbutɨwa nyaangɨt wutaa ndina maawupmba yelavɨka lɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wandɨ maa wumba la ndi Ferisi ndɨ kat wagalandi. Mɨn nɨn kat wamɨn? Ngwuk mbutɨwa nyaangɨt ngwutna maawupmba ana yelavɨka lɨgangwuk wamɨn nɨn kat? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wagalandi maa Jisas ndi kat wandɨ. Awa luwa. Ana yelavɨka lɨgangwut tuwa. Nɨn nɨma sakwat vak kat ana yelavɨka lɨganɨn wangweyan God ngwutna kavle vak kat sɨlsmbwigiyandɨ. Wupma ana walɨgangwuk. Aywaa yelavɨka lɨganɨn. Apma vat tɨga nɨmba nɨn walɨgangwuk. Ngi kat tɨga ngwutna kavle vak kat God ana alɨpsɨga sɨlɨmbwigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas laataa ndi kat wandɨ. Ngwuk kat woseka ana waigowun. Awuk ngwula. Kɨta nyan sip sip kwaa lɨga tɨvwina suwi yambɨmba wuleivak kat kai walaa tɨvwi saka yiga wuleindeyan wan nyan sɨkwutɨga nyana. Kavle vat yiga yetɨlɨga nyana. ");
INSERT INTO ian_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Suwi yambɨ savagu wuleilɨga nyan ndɨ wan tɨvwina sip sip kat vɨga lɨga nyana. ");
INSERT INTO ian_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ndi kat vɨga lɨga nyan yandɨ maa suwi yambɨ kat vɨga lɨga nyan lavwigiyandɨ. Sip sip ndɨna kwundi wuka lɨgandi. Sip sip kɨta kɨta ndina sɨ vɨga wuka lɨgandɨ. Ndɨ yagwa wandɨ maa ndɨna kwundi wutaa ndɨna kwupmba yilɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ndɨna sip sip tɨvwimba lɨga wogwenjeyan ndi avla ana wogwelɨgandi. Ndɨ tak suwi yambɨ wogwelɨgandɨ. Ndi ndɨna kwundi wutaa ndɨna kwupmba wogwelɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kwo nyan kat vɨlaa vaka pɨlɨgiyandi. Kwo nyana kwundi ana wuka lɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Wan pagwulaa lɨga wapuseput Jisas mbutndɨ maa wan wapusepuk kat wutaa ana ndi yelavɨka lɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas ndi kat wandɨ. Nyaangɨt mbupmat yigowun. Awuk ngwula. Wan sip sipna tɨvwina suwi yambɨ wunayɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wun tɨwun mala tata ya nɨmba ndi sɨkwuka kavle vat tɨgiyandi. Sip sip ndina kwundi ana wuka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Suwi yambɨ wunayɨ. Ndi kat vɨga lɨlɨwun maa ndi apma vat tɨgiyandi. Sip sip apma yuwi kat vlaa kɨlɨnja vla apma vat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sɨkwutɨga nɨmba apma vat kwutaa yetɨvak kat ana yalɨgandi. Sɨkwupmat, vatnyavat, kavle vat yivat mɨna yelavɨka yalɨgandi. Wun ndinyangu kat njɨmbla njɨmbla apma vat yetɨjeya vak kat kwivat yawun. ");
INSERT INTO ian_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Apma vapmba sip sip kat vɨga lɨga nyan vla lɨgowun. Sip sip kat vɨga lɨga nyan vla lɨgowun. Sip sip kat vɨga la nyan sip sip kat tɨga kiyalɨnda vla wuno ndinyangu kat vɨga lɨga kiyaigowun. ");
INSERT INTO ian_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nat kɨta nyan sanya klavat sip sip kat vɨga lɨgiyandɨ. Vɨga lɨnda sip sip kat valɨvat yandeyan ndɨ vaakaa pɨlɨndɨ maa sip si pkat vatnyandɨ maa vɨlaa nat sip sip kava kavat vaaka pɨlɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sanya klavat sip sip kat vɨga lɨga nyan ndɨ sip sip kat ana nɨmamba yelavɨka lɨgandɨ. Ngi kat tɨga ndi kat kwagalalaa pɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Wun wupma ana kwagalalaa vaaka pɨlɨgiyowun. Sip sip kat ama vat vɨga lɨga nyan vla lɨgowun. Wuna nɨmbana sɨ kɨta kɨta vɨga wuka lɨgowun. Dino wun kat vɨga wuka lɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Wuno wuna nyaek Godno awat sowat vɨga lɨgali. Wuna sip sip kat tɨga wun kiyaigowun. ");
INSERT INTO ian_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nat mbaapmamba lɨga sip sip ndino wuna sip sip ndi. Ndi kat yiwun wuna kwundi wutaa wuna lak yaigandi. Yandi ma aywaa wuna sip sip kɨta tɨvwimba taagawun maa tɨgiyandi. Ndi kat aywaa wuna lak vɨga lɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kiyalaa lɨga laakiyowun waa yelavɨtaa kiyaigowun. Kiyaweya vak kat vɨlaa wuna nyaek wun kat woviyaguga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kɨta nyan ndɨna maawupmba yelavɨtaa wun kat ana alɨpsɨga vatnyagiyandɨ. Wun wowun maa wun kat vatnygiyandɨ. Kiyalaa lɨga laakiyowun. Vɨga lɨgowun. Kiyalaa lɨga avla laakweya kwondu ngilɨga. Vɨga lɨgowun. Wuna nyaek wunkat wupma wandɨ maa vɨga lɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ndɨnai waa nyaangɨk kat wutaa Juda ngambuga lɨga mbaapma vɨlɨlɨk sɨndi. ");
INSERT INTO ian_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nat mbaapmamba la nɨmba wandi. Kavle waagan tavindɨ maa ndɨ tungwengwan yiga lɨgandɨ. Ndɨna kwundi wupmak kat nɨn kai wanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nat mbaapmamba la nɨmba wandi. Kavle waagan tavilaa lɨlɨga nyan wupma wanda vla ana waigandɨ. Kavle waagan tavilaa lɨlɨga nyan mɨni kiya nyana mɨni ana kwunakiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Judana nɨma nandinya yandɨ. Wan tamba Godna ngay kwunataa wuleilaa lɨnja njɨmbla yelavɨka lɨnja nɨma nandinya. Yipma yila njɨmbla yelavɨka lɨnja nɨma nandinya. Yipma yila njɨmbla. ");
INSERT INTO ian_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wan njɨmbla Jisas Godna gay wuleilaa tamba la nyan Solomon kwutaw kavamba lɨga yi yalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tɨndɨ maa Juda ndɨ kat ya wegwulaa wagalandi. Manda kat nɨn kat kapmba yigumba walapman yimɨn maa nɨna maawut kavle vat yelavɨka lɨganɨn. Mbambala nɨn kat kapmba mbukiyamɨn. Mɨn God wandɨ, yaa nyan mɨn? Mɨn Kraist mɨn? Nɨn kat ambup mɨla waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wandi maa Jisas ndi kat wandɨ. Ngwuk kat Kraistnat tɨwa vak tamba mbukwun maa wun kat woseka wandɨ waa wangwuk. Wuna nyaek wun kat kwiya njɨvwa kwutɨwun. Wan kwutɨwa njɨvwa Kraistnat tɨwa vat ndinyangu kat vɨsɨmogwilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngwuk Kraistnat tɨwa vat ana vɨga lɨgangwuk. Ngwuk wuna sip sip ana ngwuk. Ngwuk kat tamba wowun. ");
INSERT INTO ian_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wuna sip sip wuna kwundi wuka lɨgandi. Ndina sɨ kɨta kɨta wuka lɨgowun. Wuna kwundi wutaa wuna kwupmba yalɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ndi kat njɨmbla njɨmbla apma vat tɨnjeya vat kwilɨgowun. Ndi ana kavle yigiyandi. Kɨta nyan ana ndi kat kwutaga alaguat kloga kaligiyandɨ. Wun ndi kat kwutaa lɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wuna nyaek ndi kat kwutaa lɨwangat wandi. Ndɨ njambwi nyana. Nat nyan ndɨ kat ana kwulakiyandɨ. Kɨta nyan ana alɨpsɨga ndi kat kwutaga alaguat kloga kaligiyandɨ. God ndɨno ndi kat kwutaa lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wuna nyaeknonala an kɨta lulu tɨgali. An kɨta vat tɨgali waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisas wandɨ maa ndɨ kat vatnyavat Juda kambak klalaa yaagi mɨna lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisas ndi kat wandɨ. Wuna nyaek wun kat kwiya apma nɨma njɨvwa nɨma sakwat kwutɨwun. Anda apma njɨvwa kwutɨwa njɨvwa kat vɨlaa wun kat vatnya mɨna lɨgangwuk waa wagalandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wagalandɨ maa Juda ndɨ kat wandi. Kwutɨma apma njɨvwa kat vɨlaa mɨn kat ana vatnya mɨna lɨganɨn. God kat kavle vat wamɨn. Ngwuk ndu ngwuk. Wun God wun waa manda kat apma wamɨn. Wamangat mɨn kat vatnya mɨna lɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas ndi kat wandɨ. ngwutna tamba la nyan God waa nyaangɨt wutaa pɨlɨwutndɨ. Ngwuk Godno kɨtamba kɨta lulu lɨgangwuk waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wan tamb la nyan pɨlɨwukna nyan ndinyangu kat ndi God ndi waa pɨlɨwutndɨ. Wan pɨlɨwukna nyan Godna nyaangɨt wutaa God kwiya njɨvwa kwuta nyan ndɨ. Wan pɨlɨwuknda nyaangɨt woseka waa ana pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wungi kat tɨga wun Godna nyan wun waa wawa vat wutaa ngwut manda kat ndɨ kavle vat wandɨ waa walɨgangwuk. God wun kat ay wandɨ ndɨna vat ndinyangu kat sɨmagavat kan kɨpmat ngaga yawun. ");
INSERT INTO ian_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuna nyaek God wun kat kwinda njɨvwa kwutapman yiweyan wuna kwundi ana wukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","God kwinda njɨvwa kwutɨgowun. Walɨwa kwundi wupmak kat kai wangweyan kwutɨwa njɨvwa vɨlaa ndɨ God kwiya nyana waa wun kat yelavɨkiyangwuk. Ndɨ Godna kwondumba njɨvwa kwutɨgandɨ maa wun kat yelavɨkiyangwuk. Ndɨnogwi Godno kɨta lulu lɨgambɨt waa yelavɨkɨiyangwuk. Waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wandɨ maa ndɨ kat vatnyavat kwupmat wandi. Ndi kat kwagalalaa pagwuga yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ndi kat kwagalalaa Jodan walɨnja ndandangɨ nat naangɨ valɨgendɨ. Wan yinda kava tat Jon ndinyangu kat ngu yagula kava. Wumba yilaa yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wumba lɨndɨ, ndɨ kat nɨma sakwat nɨmba yalɨndi. Yalaa ndɨ kat walɨndi. Jisas kwunatɨnda nɨma njɨvwa Jon wupma ana kwutɨndɨ. Jon ndɨ kat wanda nyangɨt woseka ana walɨndɨ waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wan kava la nɨma sakwat nɨmba Jisas kat vɨlaa God wandɨ maa yaa nyana waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kɨta nyan ndɨna sɨ Lasaras ndɨ yelogwen kat tɨndɨ. Dɨna ngepma Betani. Ndɨna mbɨt yakwa lagwa vɨlɨlɨk Mario Mato ndi kɨta ngepma nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ndɨna yakwa lagwa Maria apma njangu veila ngu klalaa Jisasna mamba taagalaa salataa lɨla sɨvla nɨmbɨ yuwimba nyangata taagwat. ");
INSERT INTO ian_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaras yelogwen kat tɨndɨ maa ndɨna yakwa lagwa nyaangɨt wambɨt, wan nyaangɨt kwutaa Jisas kat yiga mbutndi. Njambwi nyan woviyaguga lɨma nyan yelogwen kat tɨgandɨ waa wamba nyaangɨt yiga mbutndi. ");
INSERT INTO ian_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mbutja nyaangɨt wutaa Jisas wandɨ. Kiyangeya yelogwen ana ndɨ. Godna sɨ kwutaa katsogiyaa yelogwena lɨga. Godna nyana sɨ kwutaa katsogiyaa yelogwena lɨga waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mato, lɨla yakwa lagwo, Lasaras kat Jisas woviyaguga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasaras yelogwen kat tɨgandɨ waa wandi wutaa Jisas ana yindɨ. Tɨnda kavamba nandinya vɨlɨlɨk tɨga kwo yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nandinya vɨlɨlɨk tɨga ndɨna mbaapma nɨmba kat wandɨ. Laap ngwula. Judia nat njambɨ yigat waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wandɨ maa ndɨna mbaapma nɨmba ndɨ kat wandi. Njambwi nyan Judiamba lɨga njambwi Juda tak mɨn kat vatnyavat kambak kwutaa lɨndi mɨn kat yaagivat. At nat njambɨ ndina ngepma yigiyamɨn? Waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wandi maa Jisas ndi kat wandɨ. Nya sɨlɨga nandinya kɨta tamba vɨli kiyeli vɨlɨlɨk aua tɨgandɨ. nya sɨlɨga njɨmbla ndu nyan man veiga yindeyan kambapmba man sɨlaa ana ndaigandɨ. Nya sɨndɨ, mɨni vɨga yigumba veiga yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kɨta nyan ngan man veiga yindeyan wan nyan kambapmba sɨlaa ndaigandɨ. Mɨni vɨlapman ndaigandɨ. Ngi kat tɨga Judia yigiyanɨn njɨvwa kwupmat. ");
INSERT INTO ian_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wan nyaangɨt walaa at nat njambɨ wandɨ. Nɨna alɨ nyan Lasaras sɨndu kwandɨ. Yilaa ndɨ kat sɨvɨlɨwun, laakiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wandɨ maa ndɨna mbaapma nɨmba wandi. Njambwi nyan yelogwen kat tɨga nɨmba sɨndu kwanjeyan apma vatna. Manda kat sɨvɨlɨgiyamɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasaras kiyanda vat kat pagwuvat ndɨ sɨndu kwaandɨ waa wandɨ Jisas. Ndɨna mbaapma nɨmba wutaa ndɨ sɨndu kwaandɨ waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngi kat tɨga Jisas ndi kat kapmba wandɨ. Lasaras kiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kiyanda njɨmbla wun ana wumba lɨwun. Apma vatna. Wumba lɨgewan ngɨni kwukweya nɨma njɨvwa vɨlaa ndɨ njambwi nyana waa ana waingwuk. Mbambala yigiyanɨn wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jisas wandɨ maa Tomas waa Didimas walɨnja vɨlɨgu nyan wandɨ. Wovun yigiyanɨn. Ndɨnogwinana kiyaiganɨn waa njambwi Juda kat vaaka wandɨ Tomas. ");
INSERT INTO ian_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas yanda njɨmbla Lasaras nandinya aynat tamba waangumba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lasaras ta ngepma Betani Jerusalemna ngwaymba lɨndɨ. Ndɨna sɨvla mail vɨlɨlɨk. ");
INSERT INTO ian_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nɨma sakwat Jerusalemba lɨga Juda ndu lagwa yalaa Mato Maria kat tangatɨndi. Mbɨla yakwa nyan kat lasaras kat nɨma nɨma vat yelavɨka tɨmbɨt maa tangatɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jisas tamba yaandɨ waa wandi maa wutaa Mato Jisas kat yiga ava yambɨmba vɨlɨ. Maria ana yilɨ. Ngaymba ndaalɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata Jisas kat yalaa walɨ. Njambwi nyan kumba tɨgeman wuna yakwa ndu ana kiyaindɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mbambala God kat wagalameyan wagalameya vat wutaa God apma vat yigiyandɨ. Vɨga lɨgowun waa walɨ Mata. ");
INSERT INTO ian_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Walɨ maa Jisas lɨ kat wandɨ. Nyɨna yakwa ndu kiyalaa laakyandɨ waa wandɨ maa Mata walɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ngiyambak wamɨn. Ngɨni yaiga nandinya kiya nɨmba aywaa laatjeya nandinya ndɨno laaptaa tɨgiyandɨ. Vɨga lɨgowun waa walɨ Mata. ");
INSERT INTO ian_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Walɨ maa Jisas wandɨ. Kiya nɨmba kat laak ngwula waa waiga nyan wunayɨ. Apma vat yiga yetɨnjeya vak kwilɨga nyan wunayɨ. Kɨta nyan njambwi nyanat tɨwa vat yelavɨtndeyan kiyalaa lɨga lalapkiyandɨ. Kɨta nyan njambwi nyanat tuwa vat yelavɨtndeyan apma vat yiga yetɨnjeya vak ndɨ kat kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kwo lɨga nɨmba njambwi nyanat tɨwa vat wun kat yelavɨtnjeyan ndi ana kavle yigiyandi. Kan walɨwa nyaangɨt yelavɨka lɨganyɨn? Waa wagalandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wagalandɨ maa Mata ndɨ kat walɨ. Njambwi nyan. Mɨn Kraist mɨn. Mɨn kat vɨga lɨgowun. Mɨn Godna nyan mɨn. Mɨn God kwiya nyan mɨn. Kawiga lɨna nyan mɨn. Tamba vɨga lɨgowun waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata walaa lungwamataa yiga lɨla yakwa lagwa Maria kat pagwuga mbutɨ. Njambwi nyan wungi ya. Nyɨn kat walɨgandɨ. Maria yaalɨ waa wandɨ waa Mata mbutɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria wutaa kwiyatapman laaptaa Jisas kat yilɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ngepma ana wuleindɨ. Tat Mata ndɨ kat va kava ava yambɨmba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria Jisas kat vɨvat kwiyatapman laataa ngay kwagalalaa yilɨ maa vɨlaa ngaymba lɨga lɨ kat tangata nɨmba lɨla kwupmba yiga wandi. Ndɨ kat taaganja waangu kavat nglavat yilɨgalɨ. Lɨ kat kwupmba yiga tangakaiyanɨn waa waga yindi. ");
INSERT INTO ian_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jisas ta kavat Maria yalaa ndɨ kat vɨlaa ndɨna mangandɨmba kwali mamba sɨlaa ndɨ kat walɨ. Njambwi nyan kumba tɨgeman wuna yakwa ndu ana kiyaindɨ waa nglaga walɨ Maria. ");
INSERT INTO ian_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nglalɨla vakat lɨlogwinala la ndi Juda nglalɨnja vak kat vɨlaa Jisas ndi kat nɨma maawut yelavɨka lɨga ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ndɨ kat taaganja waangu andamapmba lɨgandɨ waa wandɨ maa yaa avɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yilɨndi maa Jisas nglalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nglalɨnda vak kat vɨlaa Juda wandi. Kiya nyan kat Jisas nɨmamba woviyaguga lɨndɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ndina nɨmba wandi. Wan nyan tak mɨni kiya nyana mɨni kwunatndɨ, vɨndɨ. Wan nyan kat kwaglalndɨ maa kiyandɨ. Manda kat wupma yindɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ndina nyaangɨt wutaa Jisas nɨma vat yelavɨka lɨga waangu la kavat yandɨ. Wan waangu kambak mɨna la waangua. Wan waanguna tak waangu nɨma kambapmba kuviyalagulaa tɨvɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Wan kavat yalaa Jisas wandɨ. Tɨvɨnja kambak kumba ngwula waa wandɨ maa kiya nyana yakwa lagwa Mata Jisas kat walɨ. njambwi nyan nandinya aynat waangumba lɨndɨ. Ndɨna sɨm kavle njangu veilɨgandɨ. Kambak kumba ngwula waa ke waa waa walɨ Mata. ");
INSERT INTO ian_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas lɨ kat wandɨ. Tak nyɨn kat tamba wowun. Kai walapman yɨnyeyan God kwutndeya apma njɨvwa vɨgiyanyɨn waa tak nyɨn kat wowun waa Jisas wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","kambak kwutaa kumbandi. Kumbandi maa kiya nyan ta waangu kwo lɨndɨ. Jisas nyinangwutnat tanambɨtaa wandɨ. Nyaek, wagalawa vat tamba wupmɨn. Mɨn kat sɨvu kɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","njɨmbla njɨmbla wagalɨwa vak wuka lɨgamɨn. Wunogwina lɨga nɨmba wutnjangat mɨn kat kwundimba wowun. Wagalalɨwa vak wuka lɨgamɨn waa kwundimba wowun. Wutaa God wandɨ maa yaa nyana waa wun kat yelavɨka lɨgiyandi waa God kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","God kat walaa nɨma kwundimba Lasaras laataa ngaga yaa mɨla waa walendɨ maa ");
INSERT INTO ian_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","kiyaa nyan laaptaa yandɨ. kiyandɨ maa waangumba taagavat tɨnja njɨmbla sɨvla waavwimba ndɨna mbangɨ mbaataa taagandi. Ndɨna man taamba wan waavwi ngilaa lɨndɨ maa wogwendɨ. Ndɨna mɨndama waavwimba kapmandi maa wogwendɨ. Wogwendɨ maa Jisas ndi kat wandɨ. Ndɨna waavwi njalak ngwula. Kwo lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maria kat tangapmat ta Juda Jisas yalaa kwuta njɨvwa vɨlaa ndɨ God wandɨ, yaa nyana waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ndina nat nɨmba wupma ana yelavɨtndi. Jisas kwutaa vak kat vɨlaa yiga Ferisi kat mbutndi. ");
INSERT INTO ian_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mbutndi maa Ferisio God kat kwunatɨga njambwi nɨmbo wandi maa ndino nat nɨma sakwat njambwi nɨmbo ngambuvat yisolaa lɨndi. yisolaa lɨga wandi. Nɨn angamak yigiyanɨn ndɨ kat. Nɨma sakwat apma nɨma njɨvwa kwutɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndɨ kat kai walapman yineyan nɨna ngepmana nɨmba aywaa ndɨna kwupmba yigiyandi. Yindi maa nɨn kat vɨga Romba lɨga nɨmba yalaa nɨn kat sɨgiyandi. Wan vak kat kai waigandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndina kɨta nyan Kaiafas kat naambi God kat kwunatɨga nɨmbana njambwi nyanat tɨndɨ. Ndɨ laataa ndi kat wandɨ. Ngwuk apma maawut ana yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wan nyan Jisas kat vatnyaneyan nɨn aywaa ana kavle yigiyanɨn. Romba lɨga nɨmba nɨn Juda kat ana yaa sɨgiyandi. Nɨn kat tɨga ndɨ Jisas kiyandeyan wovuna waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wanda nyaangɨt ndɨna maawupmba yelavɨtaa ana wandɨ. Kat naambi ndina njambwi nyanat tɨndangat God ndɨna maawupmba ngambundɨ maa wandɨ. Jisas ndinyangu kat tɨga kiyaigandɨ waa wandɨ Kaifas. Wanda nyaangɨtna angwa kat ana yelavɨka lɨndɨ. Ndɨ kwo wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wanda nyaangɨtna angwa kɨngiyan. Jisas Juda kat mɨna kwunapmat ana kiyandɨ. Kava kavamba lɨga nɨmba kat aywaa kwunapmak kiyandɨ. Ndi kat aywaa kwutaa kaliga Godna mbaapmamba tangavak kat kiyandɨ. Taagandɨ maa Godna nyaanguat tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Wungi nandinyamba yisolaa lɨga nyaangɨt ngambulaa Jisas kat sɨvak kat. ");
INSERT INTO ian_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wungi kat tɨga Juda la ngepma ngepma Jisas ana yi ya yetɨlɨndɨ. Kwo kavamba lɨga ngepmat yindɨ. Efraim walɨnja ngepmat yindɨ. Wan ngepma yilaa ndɨnogwi ndɨna mbaapma nɨmbo kɨta vat yetɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judana pesto pasova walɨnja pesto tamba ngway tolandɨ. Kava kavamba la Juda laataa Jerusalemat yindi. Tat nɨna nglambi njangigiyanɨn ngɨni pesto kat wuleigiyanɨn waa yelavɨtaa Jerusalemat yindi. ");
INSERT INTO ian_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jerusalemat yilaa Jisas kat kwatɨndi. God kat kwunatɨnja ngayat wuleilaa awat sowat ngambulɨndi. Pesto kat anagandɨ yaiga waa awat sowat ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","God kat kwunatɨga njambwi nɨmbogwi Ferisio nyaangɨt tamba kwindi. Kɨta nyan Jisas kat vɨga lɨmeyan nɨn kat mbuiyamɨn waa wandi. Ndɨ kat kwupmat wanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nandinya sɨla kɨta lɨga pasova walɨnja pesto tɨgiyandɨ. Jisas Betaniat yindɨ. Wan ngepma Lasaras ta ngepma. Tat wan nyan Lasaras kiyandɨ maa Jisas laap mɨla wandɨ mala laatndɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ndina ngay wuleindɨ maa ndɨ kat kɨgɨnda kwutndi. Lasarasna nyange Mata kɨgɨnda wan nɨmba kat kansaga kwilɨlɨ. Lasaras ndɨ njabɨmba nat nɨbagwinala ndalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tɨga lɨga Maria apma njangu veila ngu klalaa Jisasna taga mamba salatɨ. Wan ngu nɨma sanyamba wan gu kat nyangatɨ. Wan nguna njangu wan ngaymba la nɨmba aywaa wutndi. Apma njangu veilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kalɨtɨ maa Jisasna mbaapmamba la kɨta nyan Judas Iskeriot, ngɨni tɨga Jisas kat kamwin kwigiyaa nyan lɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Wan njangu veila ngu manda kat kwo kalɨtɨ. Wan ngu kwilaa sanya klalaa sanya lapman nɨmba kat kwigelan wovuna. 300 dola anagalɨ klaiga waa wandɨ Judas. ");
INSERT INTO ian_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sanya lapman ta nɨmba kat ana nɨma vat yelavɨtaa wandɨ. Jisasna mbaapmamba la nɨmba kɨta yisoga taagalɨnja mani ndɨnai vɨga la. Vɨga lɨga nat njɨmbla sɨkwutɨndɨ. Wan ngu kɨilaa klaleya sanya ndɨ vɨga lɨga sɨkwupmat yelavɨtaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wandɨ maa Jisas ndɨ kat wandɨ. Lɨ kat wupma ke waa. Kiyawun maa wun kat waangumba taaganjeya njɨmbla kat yelavɨtaa wan njangu veila ngu kalɨtɨ wun kat. ");
INSERT INTO ian_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sanya lapman tɨga nɨmba ngwulogwinala njɨmbla njɨmbla tɨlɨndi maa ndi kat kwigiyangwuk. Wun ngɨni ngwulogwina njɨmbla njɨmbla ana lɨgɨyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas betanimba tɨnda vak kat wutaa Juda nɨma sakwat laataa yandi ndɨ kat vɨvat. Jisas kat mɨna vɨvak kat ana yandi. Ndɨno Lasaras kat vɨvak kat yandi. Tat Jisas wandɨ maa Lasaras kiyalaa lɨga laatndɨ. Ngɨ kat tɨga ndɨ kat vɨvak kat yandi. ");
INSERT INTO ian_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","God kat kwunatɨga njambwi nɨmba Lasaras kat vatnyavak kat yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lasaras kat Juda nɨma sakwat vɨlaa nɨn kat kwagalalaa Jisasna mbaapmamba nɨma sakwat nɨmba yilɨgandi waa yelavɨtaa Lasaras kat vatnyavat wandi. ");
INSERT INTO ian_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nat nandinya pesto kat yilaga nɨma sakwat nɨmba mbambala Jisas Jerusalemat yaigandɨ waa wandi maa wutaa njambwi nyanat tɨnda vak kat yelavɨtaa ");
INSERT INTO ian_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tɨpma ngla kalɨka kwutaa ndɨ kat vɨvat yandi. Ndɨ kat vɨlaa wandi. Wovun yamɨn. Mɨn nɨn Isrel walɨna nɨmbana king mɨn. God wandɨ maa yamɨn. Mɨn apma njambwi nyan mɨn waa nɨma kwundimba walega walɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas kwandɨ donki kɨta kwutaa lɨla mbunimba ndaalɨga yandɨ. Ndɨ tamba la nyan pɨlɨwuta vak vla ndaalɨga yandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tamba pɨlɨwutndɨ. saionmba lɨga nɨmba ngwuk ke nɨmamba yelavɨka lɨngwa. Ngwutna njambwi nyan yaigandɨ. Donkina mbunimba ndaalɨga yaigandɨ waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wan tamba pɨlɨwutnda nyaangɨt Jisasna mbaapma nɨmba di ana yelavɨka lɨndi. Tamba la nyan pɨlɨwutnda vak vla ndɨ kat yindi waa ngɨni yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tak Lasaras kiyandɨ maa waangumba taagandi, lɨndɨ. Lɨndɨ maa Jisas ndɨ kat wandɨ maa laatndɨ. Laatnda vak va nɨmba ngepma ngepma yi ya mbutɨndɨi. ");
INSERT INTO ian_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lasaras kat wandɨ, laatnda vak kat wutaa nɨma sakwat nɨmba Jisas kat vɨvat yandi. ");
INSERT INTO ian_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nɨma sakwat nɨmba Jisas kat ya vak vɨlaa Ferisi awat sowat wandi. Ndɨ kat kwulapmat tɨna vat tamba kwo vatnat tɨgandɨ. ndinyangu aywaa ndɨna kwupmba yilɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wan pesto kat ya nɨmbana nat nɨmba Juda ana ndi Di Grik ndi. God kat yelavɨpmak Jerusalemat yindi. ");
INSERT INTO ian_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wundi Grik Filip kat yandi. Filipna ngepma Betsaida. Galilimba la ngepma. Ndɨ kat yalaa wandi. Mɨn, Jisas kat vɨlaa ngambuvat yalaa lɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Wandi maa wutaa Filip yiga Endru kat mbutndɨ. Mbutndɨ maa mbɨk Jisas kat yiga mbupmbɨk. ");
INSERT INTO ian_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mbupmbɨk maa Jisas wandɨ. Wan nyinangwutna vak ndinyangu kat sɨmogwilɨga nyan wun. Wun kat kwutaa vatnyanjeya njɨmbla tamba ngway tolagandɨ. Wun kat vatnyandi maa God wuna sɨ kwutaa katsogiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mbutɨwa nyaangɨt awuk ngwula. Kɨlɨnja mina sɨk kɨpmamba dalaa nɨngɨndeyan nɨma sakwat mi sɨk wataa tɨgiyandɨ. Kɨpmamba ndalapman yindeyan ndɨ sɨk kɨta tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nɨno ndinyangu wungi vat sɨgɨt. Kɨta nyan ndɨna mbagɨna njɨvwa mɨna kwuka ndɨna mbangɨ mɨna kwunaka yetɨlɨndeyan wan nyan ndɨ kavle yigiyandɨ. Kɨta nyan ndɨna mbangɨ kwunapmak kat ndɨna mbagɨna njɨvwa kwupmak kat kai wandeyan ndɨ njɨmbla njɨmbla apma vat tɨndeya vat kaligandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kɨta nyan wunogwinala njɨvwa kwupmat wandeyan wunai yetɨga vak vla yetɨgiyandɨ. Kɨta nyan wunogwinala njɨvwa kwutndeyan wuna nyaek ndɨna sɨ kwutaa katsogiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wun mbambala maawut nɨma vat yelavɨka lɨgowun. Wuna nyaek wagalagiyowun. Manda vatna wagalaweyan. Wun kat yavat tɨga kavle vak kat kai awa waa walu? Kai. Wupma ana wagalgiyowun. Wun kat yavat tɨga kavle vat klavat kan kɨpmat ngaga yawun. ");
INSERT INTO ian_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kupma waigowun wuna nyaekat. Avla mɨna sɨ kwutaa katso mɨla waa waigowun waa wandɨ Jisas. Jisas wandɨ maa nyinangwupmba lɨga ngaga yaa kwundi wutaa wandi. Tak avla wuna sɨ kwutaa katsowun. Ngɨni nat njambɨ kwutaa katsogiyowun waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wumba la nɨmba nyinangwupmba lɨgɨ ngaga yaa kwundi wutaa wandi. Vlap mlak wandɨ waa wandi. Nat nɨmba wutaa wandi. Ensel Jisas kat wandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas ndi kat wandɨ. Wan nyinangwupmba lɨga yandɨ, wukngwa kwundi wukwangat ana wandɨ. Wukngwangat wandɨ. Ngwutna maawut kwunapmak wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kan kɨpmana kavle vat aywaa vɨgiyandi. Vɨnjeya njɨmbla tamba ngway tolagandɨ. Kan kɨpmana nɨmba kat kavle maawut kwilɨga nyan kat kwulakiyaa vat tamba ngway tolagandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wun kat kwutaa katsondi maa kɨpmamba lɨga nɨmba kat yagwa waigowun. Wuna mbaapma yaa wulei ngwula waa waigowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ndɨ kat ngɨni vatnyanjeya vak kat yelavɨtaa wandɨ. Wun kat kwutaa katsogiyandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jisas wandɨ maa wumba la nɨmba ndɨ kat wandi. Tamba la nɨmba God waa nyaangɨt pɨlɨwutnja vak vɨnɨn. God kwiya nyan Kraist njɨmbla njɨmbla tɨgiyaa nyana waa pɨlɨwutnja vak vɨnɨn. Mɨn wamɨn. Wun Godna vak kɨpmamba lɨga nɨmba kat vɨsɨmogwilɨga nyan wun. Wun kat ngɨni vatnyagiyandi waa wamɨn. Mɨn kanda mɨn. Mɨn wan nyan mɨn? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Wagalandi maa Jisas ndi kat wandɨ. Mbambala ngwutnogwinala lɨwan kemba lɨga ya vla lɨgowun. Mbambala wun kat vɨlɨɨ Godna apma vat vɨsɨmogwi lɨga nyana waa yelavɨk ngwula. Samat tɨga ngwuk kat kwagalalaa yigiyowun. Yiwun maa ngwuk ngan vla lɨgiyangwuk. Wuna apma vat ana vɨga lɨgiyangwuk. Wun kat vɨlapma Godna apma vat vɨsɨmogwi lɨga nyana waa ana yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mbambala ngwutnogwinana tɨwa vak vɨlaa yelavɨk ngwula. Wun kat vɨlaa Godna apma vat vɨsɨmogwi lɨga nyana waa yelavɨkngweyan ngwuk apma vat tɨgiyangwuk waa wandɨ Jisas. Jisas walaa ndi kat kwagalalaa yindɨ. Yiga wun kat vɨlandi waa ndɨna mbangɨ yiga pagwulaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nɨma sakwat nɨma njɨvwa kwutɨnda vak ndi vɨlɨndi. Vɨlaa God wandɨ maa yaa nyana waa ana yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yelavɨtapman yilɨnja vak kat tamba la nyan Aisaia tamba pɨlɨwutndɨ. Pɨlɨwutnda nyaangɨpmba ngɨni wan vak yilɨndi. Njambwi nyan, butɨna nyaangɨt ana wuka vɨga lɨndi. Godna kwondu vɨlaa ndɨ nɨma nyana waa ana yelavɨka lɨndi waa tamba pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wan Jisasogwinala ta Juda angamak Jisas njambwi nyanat tɨnda vak vɨlapman yindi. Ndi tamba la nyan Aisaia pɨlɨwutnda nyaangɨpmba yilɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ndɨ tamba pɨlɨwutndɨ. God wandɨ maa ndina mɨni ana vɨlɨndi. Ndina maawut ana yelavɨtɨndi. Ngi kat tɨga God ndi kat yilɨnda vat ndina mɨni ana vɨga lɨndi. Ndina maawut ana yelavɨka lɨndi. Ngi kat tɨga God ndi kat ana kwunakiyandɨ waa pɨlɨwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tamba Aisaia pɨlɨwukna nyaangɨt Jisas njambwi nyanat tɨnda vak vɨlaa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ferisi Juda kat walɨndi. Kɨta nyan Jisas njambwi nyana waa wandeyan ndɨ kat kai waiganɨn. God kat yelavɨpmak yisolaa lɨneya ngay ana wuleigiyandɨ wan nyan waa walɨndi Ferisi. Judana nat njambwi nɨmba Jisas kat vɨlaa ndɨ njambwi nyana waa yelavɨtɨndi. Kwundimba ana walɨndi. Ferisi kat vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yelavɨta vak kat pagwua nɨmba nat nɨmba dina sɨ kwutaa katsonjangat nɨmamba yelavɨka lɨndi. God ndina sɨ kwutaa katsondangat ana nɨmamba yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas laataa nɨma kwundimba walega wandɨ. Kɨta nyan wun kat vɨlaa njambwi nyanat tɨwa vak kat yelavɨtndeyan wun kat ay waa nyan God ndɨno ndɨ kat njambwi nyanat tɨnda vak kat yelavɨkiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kɨta nyan wun kat vɨndan wun kat ay waa nyan God kat ndɨ vɨlɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kemba lɨga ya vla vɨga kan kɨpma ngaga yawun. Njambwi nyanat tɨwa vak kat kɨta nyan yelavɨtndeyan kulun walaa la kavle vat kwagalalaa apma vat kemba lɨga vak vla yetɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kɨta nyan mbukwa nyaangɨt wutaa njambwi nyanat tɨwa vak kat yelavɨtapman yindeyan ndɨ kat ana sɨgiyowun. Kan kɨpmamba lɨga nɨmba kat sɨvat ana yawun. ");
INSERT INTO ian_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mbukwa nyaangɨt wupmak kat kai waga wun kat kai walɨga nyan ndɨ kavle vat klaigandɨ. Ngɨni yaiga nandinya mbambala mbutɨwa nyaangɨt wan nyan kat nɨmbi nda vla sɨndɨ maa kavle yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mbutɨwa nyaangɨt wuna yelavɨka vapmba ana mbutɨwun. Nyaek wunkat wandɨ maa yaa mbutɨwun. ");
INSERT INTO ian_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wuna nyaek mbuta nyaangɨt wutaa njɨmbla njɨmbla apma vak mɨna yetɨgiyandi. Vɨlɨgowun. Ngi kat tɨga kwo ana mbutɨgowun. Wuna nyaek wun kat waa nyaangɨt mɨna mbutɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova walɨnja pesto tamba ngway tolondɨ. Jisas tamba yelavɨtndɨ. Kan kɨpma kwagalalaa wuna nyaek tɨga kavat yiweya njɨmbla tamba ngway tolondɨ waa yelavɨka lɨndɨ. Jisas kan kɨpmamba lɨga ndɨna mbaapmamba la nɨmba kat njɨmbla njɨmbla nɨma maawut yelavɨka lɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ndi kat nɨma maawut yelavɨka lɨga ndinogwina nao kɨndɨ. Wan nglaambu nao kɨga kɨyagindi maa Seten yaa Judas iskeriot Saimona nyan ndɨna maawupmba ngwandɨndɨ maa Judas kamwin kwindeya vak kat yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas vɨga lɨndɨ. Ndɨna nyaek God ndɨ kat kwanda kwanda aywaa vɨga lɨndangat kwindɨ. God wandɨ maa valaa lɨgowun waa vɨga lɨndɨ Jisas. Ngɨni God tɨga kavat lungwamataa yigiyowun waa vɨga lɨndɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jisasna mbaapma nimba awat sowat kwulaka njambwi nɨmbat tɨvak valɨnja nyaangɨt wutaa Jisas kɨgɨnda kɨlɨnja njambɨmba ndaa lɨga laataa ndɨna kumbula lɨnda waavwi sɨvenga taagalaa taul klalaa ndɨna yipma sɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sitaa nɨma awmba ngu kendolaa ndɨna mbaapmamba la nɨmbaba man ngu klalaa njangilaa yipma sɨtnda taulmba lapmiga klalaa ndina man wungi taulmba nyangatndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Njangilaa yiga Saimon Pitana man njangivat tɨndɨ. Pita ndɨ kat wandɨ. Njambwi nyan manda kat wuna man njangigiyamɨn. Ana nglaatndɨ waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wandɨ maa Jisas ndɨ kat wandɨ. Kwutuwa njɨvwana angwa ngwuk ana vɨga lɨgangwuk. Ngɨni vɨga lɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ndɨ kat wandɨ. Wuna man njangivak kat kai wowun waa Pita wandɨ maa jisas ndɨ kat wandɨ. Mɨn kat ngu njangilapman yiweyan wuna mbaapmamba ana lɨgiyamɨn waa wandɨ maa Pita wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Njambwi nyan wuna man mɨna ke njangiga. Wuna nambu wuna taamba aywaa njangi mɨla waa wandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mɨna man mɨna njangiweyan kwo lɨgiyamɨn. Ngwuk kat ngumba njangiweyan mɨnamba kavle vak ana lɨgiyandɨ. Ngwut apma vat tɨgiyangwuk. Ngwuk kat aywaa ana wupma wowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wan taamba vɨli kiyeli vɨlɨlɨk nɨmbana kɨta nyan wun kat kamwin kwigiyandɨ waa yelavɨtaa ngwuk aywaa ana apma vat tɨgangwuk waa ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ndina man aywaa njangilaa ndɨna kumbula lɨnda waavwi klalaa kwusolaa nda lɨga wandɨ ndi kat. Ngwuk kat yuwa vatna angwa yelavɨka lɨgangwuk? wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wun kat sɨmogwi lɨga nyan njambwi nyan mɨn waa walɨgangwuk. Wovun wupma walɨgangwuk. Wun sɨmogwi lɨga njambwi nyan wun. ");
INSERT INTO ian_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wun ngwutna njambwi wun. Mat nyan vla lɨga ngwula man njangilɨgowun. Ngwuk wupma awat sowat njangi ngwula. ");
INSERT INTO ian_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kan ngwuk kat njɨvwa kwuta nyan vla yuwa vat vɨlaa ngwulo wupma yiga yetɨmba ngwuk. ");
INSERT INTO ian_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngwuk kat kɨta nyaangɨt waigowun. Ngwuk awuk ngwula. Njɨvwa kwutɨga nyan ndɨ kat njɨvwa kwilɨga nyana njambwi nyan ana ndɨ. Ya nyan ndɨ kat ay waa nyana njambwi nyan ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wawa nyaangɨt ngwuk yelavɨk ngwula. Wutaa wan nyaangɨtmba yiga yetɨngweyan ngwutna maawut apma vat tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ngwuk kat aywaa ana wowun. Wuna mbaapmamba taagaweya nɨmba vɨga lɨgowun. Ngwula kɨta nyan God waa tamba pɨlɨwutnja nyaangɨpmba yigiyandɨ. Kɨta nyan wunogwinala kɨgɨnda kɨlɨga nyan wun kat kavle yindɨ waa tamba la nyan pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngɨni ngwula kɨta nyan wun kat kavle yigiyandɨ. Tak ngwuk kat mbukowun. Wan yindeya kavle vak vɨlaa Jisas ndɨ God wandɨ, yaa nyana waa yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngwuk kat kɨta nyaangɨt waigowun. Ngwuk awuk ngwula. Wuna njɨvwa yiga agwut wowun ma kwukiya nɨmba kat apma vat yinjeyan wunkat apma vat yi vla lɨgiyandi. Kɨta nyan wun kat apma vat yivat wandeyan wuna njɨvwa yiga agwut wowun maa kwukiya nyan kat apma vat yigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas wan nyaangɨt ngambulɨndɨ, ndɨna maawut viyalɨndɨ, wandɨ. Ngwuk awuk ngwula. Ngwutna kɨta nyan wun kat sɨnjangat kamwin kwigiyandɨ waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ndɨna mbaapmamba la nɨmba awat sowat vɨga anda nyana waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ndɨna mbaapmamba la nat nyan Jisasna ngwaymba lɨndɨ. Jisas ndɨ kat woviyaguga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pita ndɨ kat vɨlaa Jisas kat wagala mɨla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pita wandɨ maa Jisasna ngwaymba la nyan wagalandɨ Jisas kat. Njambwi nyan anda nyan kat wamɨn waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas ndɨ kat wandɨ. Kɨgɨnda kwutaa njangwimba salataa kwiweya nyan kat wowun waa walaa kɨgɨnda kwutaa njangwimba taagalaa Judas Iskeriot Saimona nyan ndɨ kat jisas kwindɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kwindɨ maa kɨndɨ. Kɨndɨ maa Seten ndɨna maawut wuleindɨ maa Jisas Judas kat vɨlaa wandɨ. yimeya vak kwiyatapman ay mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jisas waa nyaangɨtna angwa njambɨmba ndaa lɨga kɨgɨnda kɨla nɨmba ana yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndina nat nɨmba yelavɨtndi. Judas yisoga laagalɨna sanya ndɨ vɨga lɨgandɨ. Pesto yaiga nandinya nɨn alɨpsɨga kɨgɨnda klaiganɨn. Ndɨ klavat anagandɨ ya. Sanya lapman nɨmba kat sanya kwivat anagandɨ ya waa nat nɨmba yelavɨtandi. ");
INSERT INTO ian_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas kɨgɨnda kɨlaa laataa wogwendɨ. Tamba ngan ndandɨ, wogwendɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yindɨ maa Jisas ndi kat wandɨ. Wun Godna vat ndinyangu kat vɨsɨmogwilɨga nyan wun. Njambwi nyanat tuwa vak samat tɨga vɨgiyandi. Vɨlaa yelavɨka God njambwi nyana waigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wun kat vɨlaa Godna sɨ kwutaa katsongweyan God wuna sɨ kwutaa katsogiyandɨ. Samat tɨga katsogiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wuna nyangu ngwutnogwinala sɨvla ana lɨgiyowun. Samat tɨga yiwun maa wun kat kwakiyangwuk. Tak Juda kat wowun. Yiweya kava ngwuk ana alɨpsɨga yaigangwuk. Ngwutno ngwuk kat waigowun. Yiweya kava ana wuna kwupmba yaigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ngwuk kat mandɨp kupi vat yiga yetɨngweya vat mbukiyowun. Awat sowat ngwuk ngwula maawupmba nɨma vak yelavɨk ngwula. Ngwuk kat nɨma vak yelavɨka luwa vak vla awat sowat nɨma vak yelavɨka alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Awat sowat nɨma maawut yelavɨka tɨngweya vak vɨlaa nat nɨmba waigandi ngwuk kat. Ndi Jisasna mbaapmamba la nɨmba ndi waa waigandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jisas wandɨ maa Pita ndɨ kat wandɨ. Njambwi nyan mɨn andamala yimeya waa wandɨ maa Jisas wandɨ. Yiweya kava mbambala ana alɨpsɨga yigiyamɨn. Samat tɨga ngɨni yigiyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ndɨ kat wandɨ. njambwi nyan manda kat ana alɨpsɨga yigiyamɨn waa wun kat wamɨn. Mɨna sɨ kwunapmak kat tɨga kiyaweyan wovuna. Ana vaakiyowun waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas ndɨ kat wandɨ. Mɨna sɨ kwunapmak kat tɨga kiyameyan wamɨn? Wun kat. Wupma kwo wamɨn. Waweya nyaangɨt mɨn awup mɨla. Ngambi ngan wun kat njambɨ kuvut kai wamɨn maa ava nyaaga viyagandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas ndɨna mbaapmamba la nɨmba kat wandɨ. Ngwuk nɨma maawut ke yelavɨka lɨngwa. God njambwi nyana nɨn kat vɨga lɨgiyandɨ waa yelavɨka lɨgangwuk. Wuno wun kat wupma yelavɨa alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wuna nyaek tɨga kava nɨma sakwat tɨlɨ kava lɨgandɨ. Tɨlɨ kava tɨlapman tɨgendan ngwuk kat mbukewun. Tɨngweya kava yiga kwunakiyowun. ");
INSERT INTO ian_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yiga tɨngweya kava kwunataa ngwuk kat kalivat at yaigowun. Ngwuk kat kaliwun mala wunai tɨga kavamba kɨta vat yetɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yiweya kava ngwuk vɨga lɨgangwuk. Yiweya ava yambɨ ngwuk vɨga lɨgangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wandɨ maa Tomas ndɨ kat wandɨ. Njambwi nyan yimeya kava nɨn ana vɨga lɨganɨn. yimeya ava yambɨ nɨn anda vapmba vɨgiyanɨn waa wandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Wun wunayɨ ava yambɨ. Wun savagu lɨga nyaangɨt angwa nyaangɨt mbutɨga nyan wun. Wun ndinyangu kat apma vat yiga yetɨnjeya vak kwilɨga nyan wun. Wuna nyaek tɨga kava wuleinjeya nat yambɨ kai. Wun wunayɨ ava yambɨ. Nat ava yambɨ kai. Ava yambɨ kɨtak. ");
INSERT INTO ian_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wuna angwa vak kat vɨga lɨgengwan wuna nyaek kat vɨga lɨgengwuk. Samat tɨga wuna angwa vak vɨlaa ndɨ kat vɨga lɨlɨgiyangwuk waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jisas wandɨ maa Filip ndɨ kat wandɨ. Njambwi nyan mɨna nyaek kat nɨn kat vɨsɨmogwi mɨla. Vɨvat wanɨn. Ndɨ kat vɨlaa nat nda kat ana wagalagiyanɨn waa wandɨ Filip. ");
INSERT INTO ian_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas ndɨ kat wandɨ. Tamba ngwutnogwinala njɨmbla njɨmbla tɨlɨgowun. Filip tuwa vak ana vɨga lɨgamɨn? Wun kat va nyan wuna nyaek kat tamba vɨndɨ. Mɨna nyaek kat nɨn kat vɨsɨmogwi mɨla waa manda kat wamɨn. ");
INSERT INTO ian_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wun wuna nyaeknonala kɨta lulu tɨgali. Ngwuk wupma ana vɨga lɨgangwuk? Ngwuk kat mbutuwa nyaangɨt wunai yelavɨka lɨga vapmba ana mbutɨgowun. Wuna nyaek wuna maawupmba tɨndɨ, mbutɨgowun. Kwutuwa njɨvwana angwa ndɨnamba lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jisas ndɨna nyaeknonala kɨta lulu tɨgambɨt waa yelavɨk ngwula. Wupma yelavɨtapman yingweyan kwutuwa nɨma njɨvwa vɨlaa Jisas ndɨ njambwi nyana waa yelavɨka alɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngwuk kat nyaangɨt kɨta waigowun. Ngwuk awuk ngwula. Kɨta nyan njambwi nyanat tuwa vak kat yelavɨka lɨndeyan kwutuwa njɨvwa vla ndɨno kwukiyandɨ. Kan kɨpma kwagalalaa wuna nyaek tɨga kavat yiwun maa wunai kwutɨga njɨvwa ndɨ kwulaka kwukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ngwuk kat kwagalalaa nyinangwut yiwun mala wuna sɨ waga wuna nyaek kat wagalangweya nda ngwuk kat kwigiyowun. Wunamba klalaa wuna nyaekna sɨ kwutaa katsogiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wuna sɨ waga wuna nyaek kat wagalangweya nda ngwuk kat kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","w Wun kat woviyaguga lɨngweyan wunai waa nyaangɨpmba yiga yetɨ ngwula. ");
INSERT INTO ian_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nyaek kat wagalawun mala ngwuk kat kwunatɨgiya nyan kwigiyandɨ. Wan nyan ngwutnogwinala njɨmbla njɨmbla kwunaka tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wan nyan Godna waagana. Ndɨ apma maawut kwilɨga nyana. Ndɨnamba klalaa apma vak yelavɨka lɨgiyangwuk. Kan kɨpmamba lɨga kwo nɨmba kat ana yaigandɨ. Kwo nɨmba ndɨ kat ana vɨgiyandi. Ndɨna sɨ wuka ndɨna mɨndama vɨga ana lɨgandi. Ngwuk vɨga lɨgangwuk. Ngwutnogwinala tɨgandɨ. Ngɨni ngwutna maawupmba tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngwusɨ nyangu vla lɨngwangat ana ngwuk kat kwagalagiyowun. yilaa smat tɨga lungwamataa yaigowun. ");
INSERT INTO ian_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Samat tɨga kɨpmamba lɨga ndu lagwa wun kat ana vɨgiyandi. Ngwuk apma maawupmba yelavɨka wun kat vɨgiyangwuk. Wun apma vat yiga yetɨlɨgowun. Ngwuk wunai yetɨga vla yetɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yaweya nandinyamba vɨgiyangwuk. Wun God vla tuwa vak kat vɨgiyangwuk. Wuna yelangɨmba lɨngwangat vɨgiyangwuk. Ngwutna maawupmna luwa vak vla wuna yelangɨmba lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kɨta nyan wunai waa nyaangɨt wutaa kwutaa lɨndeyan wan nyan woviyaguga lɨnda vak vɨlɨgowun. Kɨta nyan wunkat woviyaguga lɨndeyan wuna nyaek ndɨ kat woviyaguga lɨgiyandɨ. Wuno ndɨ kat woviyaguga lɨgiyowun. Wan nyan kat yetuwa vak vɨsɨmogwi kiyowun. Vɨsɨmogwiwun maa wuna angwa vak vɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas Jisas kat wandɨ. (Jisas kat kwutnjangat kamwin kwiya Judas Iskeriot ana ndɨ. Nat Judas.) Ndɨ wandɨ. Njambwi nyan. Ngɨni ngwuk kat yetuwa vak vɨsɨmogwiweyan kwo lɨga nɨmba ana vɨgiyandi waa wamɨn. Anda vatna vɨlapman yinjeya waa wandɨ Judas. ");
INSERT INTO ian_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas ndɨ kat wandɨ. Kɨta nyan wun kat woviyaguga lɨndeyan wunai waa nyaangɨpmba yetɨgiyandɨ. Wan nyan kat wuna nyaek woviyaguga lɨgiyandɨ. Wunagwio wuna nyaekno yalaa ndɨna maawupmba tɨgiyali. Kwo lɨga nɨmba ana vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kɨta nyan wun kat kai wandeyan wunai waa nyaangɨpmba ana yetɨgiyandɨ. Ngi kat tɨga ana vɨgiyandi. Wawa nyaangɨt wuna maawupmba ana wowun. Wun kat nyaek ay mɨla wandɨ maa ywawun. Wawa nyaangɨt ndɨnamba klawun. ");
INSERT INTO ian_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mbambala ngwulogwinala yetuwa njɨmbla wan nyaangɨt mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngɨni wuna nyaek ndɨna waagan ndi kat ay waigandɨ. Wuna wugɨn tɨvak yaigandɨ. Ngwula lak kwaigandɨ. Ngwuk kat apma vak aywaa vɨsɨmogwi kiyandɨ. Ngwutna maawut kwunatndɨ maa ngwuk kat wawa nyaangɨt kat ngwutna maawut ana tɨvɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ngwuk kat apma maawut kwilaa kwagalalaa yigiyowun. Kɨpmamba lɨga kwo nɨmba apma maawut kwilɨnja vla ana kwigiyowun ngwuk kat. Yelavɨtuwa apma maawut ngwula lak kwagalalaa yigiyowun. Ngi kat tɨga ngwuk nɨma maawut ke yelavɨkngwa. Ke vaaka lɨngwa. ");
INSERT INTO ian_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngwuk kat kwagalalaa yilaa ak llungwamataa ngwuk kat yaigowun. Tamba wowun ngwuk kat. Ngwuk wuka lɨgangwuk. Wutaa manda kat nɨma maawut yelavɨka lɨgangwuk. Wunkat woviyaguga lɨgengwan wuna njambwi nyan kat wuna nyaek kat yiga vɨgiyowun waa wowun maa wutaa solat sɨga lɨgengwuk. Yiwun maa wuna nyaek ngwuk kat apma nglei vat yigiyandɨ waa wowun maa solat sɨga lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yiweya vak kat tak ngwuk kat mbukwun. Ngɨni yigiyowun. Yiwun maa yelavɨkiyangwuk. Tak nɨn kat mbutndɨ yindeya vak. Ndɨ njambwi nyana waa yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","At nat njamba ngwutnogwinala nɨma sakwat nyaangɨt ana ngambugiyowun. Kan kɨpmamba lɨga kwo nɨmbana njambwi nyan Seten nat nyamba wuleilaa yaigandɨ. Wan yaiga nyan wun kat ana alɨpsɨga kwulakiyandɨ. Yalaa wun kat kwutndi maa vɨlaa nɨma maawut wana yelavɨkngweya. Ndɨ ana kwulakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wun wuna nyaek kat woviyaguga lɨgowun. Ndɨna kwundi wuka lɨgowun. Ndɨ kat woviyaguga luwa vak ndɨna kwundi wuka luwa vak kat kɨpmamba la nɨmba vɨnjangat wowun. Laataa yigiyanɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas wandɨ. Wun apma kɨlɨnja sɨtna mina angwa vla lɨgowun. Nat nyan wupma kai. Wun wunayɨ kɨta. Wuna nyaek mi kat vɨga lɨga nyan vla lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wunamba lɨga nyan mi sandɨ vla lɨgandɨ. Sik kwalapman yilɨga sandɨ wuna nyaek yalaa kalɨtaa yaagilɨgandɨ. Sɨk kwalɨga sandɨ samat kalɨtaa kwunatɨgandɨ. Kwunatndɨ maa sɨk nɨma sakwat kwaigandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ngwuk kat mbutuwa nyaangɨt ngwutna maawut tamba kwunatndɨ maa kwo lɨga ngwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wuna mbaapmamba lɨga wun kat ke kwagalangwa. Wun ngwutna maawupmba yetɨgiyowun. Mi sandɨ kapma lɨndeyan sɨk ana kwaigandɨ. Mi sandɨ angwo lɨndeyan sɨk kwaigandɨ. Ngwutno wungivat sɨgɨt. Wuna mbaapmamba tɨlapman yingweyan apma njɨvwa ana kwukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wun angwa mi vla lɨgowun. Ngwuk sandɨ mi vla lɨgangwuk. Kɨta nyan wuna mbaapmamba lɨndeyan ndɨna maawupmba lɨweyan ndɨ nɨma sakwat apma njɨvwa kwukiyandɨ. Wun kat kwagalalaa kapma lɨngweyan apma njɨvwa ana kwukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ndɨ kɨta nyan wun kat kwagalalaa yindeyan kalɨtndi maa lɨga wula lɨga sandɨ vla lɨgiyandɨ. Ndɨ kat kɨta lɨvwimba yisolaa yamba tugiyandi. ");
INSERT INTO ian_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wuna mbaapmamba lɨga mbutuwa nyaangɨt maawupmba yelavɨka wun kat wagalangweya nda ngwuk kat kwigiyowun. ");
INSERT INTO ian_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ngwuk kat kwiwun maa nɨma sakwat apma njɨvwa kwukngweyan nat nɨmba vɨlaa Godna sɨ kwutaa katsogiyandɨ. Nɨma sakwat apma njɨvwa kwukngweyan wuna mbaapma nɨmba vla lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wuna nyaek wun kat nɨma maawut yelavɨka lɨnda vla ngwuk kat wuno nɨma maawut yelavɨka tɨgowun. Ngwuk kat yelavɨka tuwa vak ngwula maawut ke tɨvɨnda. Njɨmbla njɨmbla yelavɨka ali ngwula. ");
INSERT INTO ian_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbutuwa nyaangipmba yiga yetɨngweyan ngwuk kat nɨma maawut yelavɨka luwa vak ngwutna maawut ana tɨvɨgiyandɨ. Wuno wuna nyaek mbutɨnda nyaangɨpmba yiga yetɨgowun. Yetɨga lɨga wun kat nɨma maawut yelavɨka lɨnda wuna maawut ana tɨvɨlɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ngwuk kat mbutuwa nyaangɨt wutaa solat sɨga yetɨlɨmbangwuk walaa mbutɨgowun. Nɨmamba solat sɨga yetɨlɨmbangwuk walaa mbutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngwuk kat kɨt nyaangɨt mbupmat yigowun. Kɨngi nyaangɨpmba yiga yetɨlɨmbangwuk. Ngwuk kat nɨma maawut yelavɨka alɨ njwula. ");
INSERT INTO ian_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kɨta nyan ndɨna alɨ nɨmba kat nɨma maawut yelavɨka lɨga ndi kat tɨga kiyandeyan wan nɨma vatna. Nat vak wan vak kat ana kwulakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mbutuwa nyaangɨpmba yiga yetɨngweyan ngwuk wuna alɨ nɨmba tɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ndi wuna njɨvwa kwutɨga nɨmba ndi waa ana ngwuk kat ngɨni waigowun. Njɨvwa kwutɨga nɨmba njambwi nyana maawupmba lɨga vak ana vɨga yelavɨka lɨgandi. Ngwuk wupma kai. Ndi wuna alɨ nɨmba ndi waa ngwuk kat walɨgowun. Wuna nyaeknanamba wukwa nyaangɨt ngwuk kat aywaa vɨsɨmogwiwun, vɨga wuka yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ngwutna maawupmba wuna mbaapma ana wuleingwuk. Ygwa wowun, wuleingwuk. Yiga apma njɨvwa kwupangwuk walaa ngwuk kat wowun. Kwukngweya njɨvwa ana kwo vatnat tɨgiyandɨ. Wuna sɨ waga wuna nyaek kat wagalangweya nda ngwuk kat kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Awat sowat nɨma maawut yelavɨka alɨ ngwula waga wowun ngwuk kat. Wan ngwuk kat wawa nyaangɨtna angwa nyaangɨt. ");
INSERT INTO ian_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kɨpmamba lɨga kwo yetɨga nɨmba ngwuk kat kai wanjeyan ngwuk yelavɨk ngwula. Tak Jisas kat kai wandi waa yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ndina mbaapma nɨmba tɨgengwan ngwuk kat ana kai waigandi. Ngwuk kapma mbaapmamba lɨga nɨmba ngwuk. Ngwuk kat wowun mala ndi kat kwagalalaa kapma mbaapma wuleingwuk. Ngi kat tɨga ngwuk kat kai waigandi. ");
INSERT INTO ian_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tak ngwuk kat mbutuwa nyaangɨt yelavɨk ngwula. Tak wowun ngwuk kat. Njɨvwa kwutɨga nyan ndɨna njambwi nyan kat ana kwulatɨgandɨ waa tak ngwuk kat wowun. Wun kat nɨma vat kavle vat yilɨgandi. Ngwulo ngwuk kat wupma nɨma vat kavle vat yigiyandi. Wuna nyaangɨt wupmak kat ndi kai wandi. Ngwulo ngutnai mbutɨgiya nyaangɨt wupmak kat ndi kai waigandi. ");
INSERT INTO ian_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wun kat ay waa nyan kat ndi ana vɨga lɨgandi. Ngi kat tɨga wuna sɨ waga yiga yetɨngweyan ngwuk kat nɨma vat kavle vat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ndi kat yalaa wan apma nyaangɨt mbutapman yingweyan kavle vat yiga yetɨlɨnja vak ana vɨgendi. Tamba yalaa mbukwun maa vɨga lɨgandi. Kavle vat yiga yetɨlɨna vak ana maawupmba yelavɨtnɨn waa ana alɨpsɨga waigandi. ");
INSERT INTO ian_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wun kat kai walɨga nyan wuna nyaangɨk kat kai waigandɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ndi kat yalaa kwutuwa njɨvwa tak yaa nyan wupma ana kwutndɨ. Wupma kwutapman yigewan kavle vak yiga yetɨlɨnja vak ana vɨgendi. Mbambala ndina kavle vat tamba vɨga lɨgandi. Vɨlaa wunogwi wuna nyaek kat kai walɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ndina tamba la nyan God wandɨ, pɨlɨwutnda nyaangɨpmba ndi wungi vapmba yiga yetɨndi. Wun kat kwo kai wandi. Angwa kai waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ngɨni nyaek kat wagalawun maa ngwuk kat kwunatɨga nyan kat ay wandɨ maa ngwuk kat yaigandɨ. Ndɨ Godna waagana. Ndɨ Godno kɨta vat tɨga nyana. Ndɨ savagu lɨga apma nyaangɨt mbutɨga nyana. Ngwuk kat yalaa wunai mbutɨga vak vla ngwuk kat mbukiyandɨ. Mbutndɨ maa wuna vak vɨga lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ngwutno nat nɨmba kat wunai mbutɨga vak vla mbukiyangwuk. Tak wunogwinala tɨngwuk. Wuna njɨvwa lakna njɨmbla wunogwinala tɨngwuk. Mbambala wunogwinala tɨga wuna njɨvwa kwuselakwun maa vɨga lɨgangwuk. Vɨlɨngwa vak mbukiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Maawupmba yelavɨka lɨngwa vak wata kwagala lɨngweya. Ngivak kat tɨga kan nyaangɨt ngwuk kat wowun. ");
INSERT INTO ian_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ngɨni God kat yelavɨpmak yisolaa lɨnja ngay ngwuk ana wuleigiyangwuk. Juda ngwuk kat kai walaa kɨklindi maa ngɨni ana wuleigiyangwuk. Godna njɨvwa kwupmak ndi kat vatnyagiyanɨn waa ngwuk kat waigandi. ");
INSERT INTO ian_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wuna nyaek at ana vɨga lɨgandi. Wuno wun kat ana vɨga lɨgandi. Ngi kat tɨga kavle vat nɨma vat ngwuk kat yigiyandi. ");
INSERT INTO ian_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngɨni yaiga vak kat mbambala ngwuk kat mbukowun. Ngɨni wan vak yandɨ maa yelavɨkiyangwuk. Nɨn kat mbutnda vak tamba yaandɨ waa yelavɨkiyangwuk. Tak ngwuk kat ana mbukwun. Ngwuk kat kwagala mɨna lɨga kan mbukowun. ");
INSERT INTO ian_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wun kat ay waa nyan tɨga kavat yi mɨna lɨgowun. Andamala yimeya waa ngwutna kɨta nyan ana wun kat wagalalɨgandɨ. Yiweya vak kat ana yelavɨka lɨgangwuk. Kwagalalaa yiwun mala kapma lɨngweya vak kat mɨna yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yigiyowun wowun maa nɨma vat yelavɨka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nɨma maawut ke yelavɨka lɨngwa. Ngwuk kat woseka ana waigowun. Ngwuk kat kwagalalaa yiweyan apma vatna. Ngwuk kat kwagalalaa yilapman yiweyan ngwutna maawuk kat kwunakiyaa nyan ana yaigandɨ. Yilaa wowun maa ngwuk kat yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yalaa njɨvwa kuvuk kwukiyandɨ. Kɨpmamba la kwo nɨmba kavle vak yiga yetɨlɨnja vak yalaa ndi kat vɨsɨmogwindɨ maa vɨgiyandi. Apma vat ndi kat vɨsɨmogwi kiyandɨ. Maawupmba lɨga vak vɨlaa sɨga nagugiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ndina kavle vat anda vatna. Njambwi nyanat tuwa vak ana yelavɨka lɨndi. Kan kavle vatna. ");
INSERT INTO ian_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ngwuk kat kwagalalaa wuna nyaek tɨga kava yigiyowun. Yiwun maa kɨpmamba lɨga nɨmba kat apma vat sɨmogwigiyaa nyan kai. Ngi kat tɨga yaiga nyan ndi kat apma vat sɨmogwi kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wan nyan yalaa kɨpmamba lɨga nɨmba sɨga nagulɨnja vak kat kai walaa kavle vak apma vak sɨmagalaa savagu vapmba sɨga nagugiyandɨ. Sɨga nagundɨ maa kɨpmamba lɨga nɨmba vɨlaa yelavɨkiyandi. Nɨna njambwi nyan kavle maawut yelavɨka lɨgandɨ waa yelavɨkiyandi. ");
INSERT INTO ian_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ngwuk kat mbukweya nɨma sakwat nyaangɨt kɨngi lɨga. Ngwuk kat mbukweya mbambala ana yelavɨkiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngɨni apma maawut kwilɨga nyan Godna waagan yalaa ngwuk kat apma maawut kwindɨ maa yelavɨka lɨgiyangwuk. Avla ndɨnai yelavɨkiyaa vapmba ana ngwuk kat mbukiyandɨ. Wunamba wutnda nyaangɨt yiga ngwutnamba mbukiyandɨ. Ngɨni yaiga vak ngwuk kat vɨsɨmogwi kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wuna sɨ kwutaa katsogiyandɨ. Wunamba wutnda nyaangɨt yiga ngɨni ngwutnamba mbutndɨ maa wutaa yelavɨka lɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wuna nyaek ta vak aywaa vɨga kwutaa lɨgowun. Ngivak kat yelavɨtaa wowun. Wunamba wutnda nyaangɨt yiga ngwutnamba mbutindɨ maa wutaa yelavɨka lɨgiyangwuk waa wowun. ");
INSERT INTO ian_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Samat tɨga wun kat ana vɨgiyangwuk. Tɨga lɨga ngɨni nat njambɨ vɨgiyangwuk. Wuna nyaek tɨga kava yivat tɨgowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas wandɨ maa ndɨna mbaapmamba la nat nɨmba wandi. Samat tɨga wun kat ana vɨgiyangwuk. Tɨga lɨga ngɨni wun kat nat njambɨ vɨgiyangwuk. Wuna nyaek tɨga kava yivat tɨgowun waa manda kat wandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Samat tɨga vɨgiyangwuk waa wanda nyaangɨt manda kat wandɨ. Nɨn ana yelavɨka lɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas kat wagalavat yelavɨka lɨnja vak vɨlaa ndi kat Jisas wandɨ. Awat sowat ngambuga manda kat wagala lɨgangwuk. Samat tɨga wun kat ana vɨgiyangwuk. Tɨga lɨga ngɨni wun kat nat njambɨ vɨgiyangwuk waa wawa vak kat manda kat yelavɨtɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngwuk kat woseka ana wawun. Yiwun maa nɨma vak yelavɨka nglaigangwuk. Yiwun ma kɨpmamba la kwo nɨmba ndi solat sɨgiyandi. Nɨma vak yelavɨka nglangwa vak ngɨni ngɨlɨgiyandɨ. Ngɨni solat sɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kan vak taagwa nyan kwupmat tɨga tɨla vak kɨta vatna. Nyan kwupmak tɨla njɨmbla ana solat sɨlɨgalɨ. Kavle vat tɨlɨgalɨ. Ngɨni nyan kwutaa nɨma vak solat sɨga tak tɨla kavle vak maawut tɨvɨgiyalɨ. Wun nyan tamba kwukwun, kwo lɨgandɨ waa yelavɨka solat sɨga lɨgiyalɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mbambala nɨma vak yelavɨka lɨgangwuk. Ngɨni ngwuk kat yaa vɨwun ma solat sɨgiyangwuk. Solat sɨngweya vak kɨta nyan ana viyesendagiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wan yaiga nandinya nɨmamba solat sɨga kɨta nda kat wun kat ana wagalgiyangwuk. Ngwuk kat nyaangɨt kɨta waigowun. Awuk ngwula. Mbambala wuna sɨ waga wuna nyaek kat wagalangweya nda ndɨ kwigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tak wupma ana wagalangwuk. Wagala ngwula. Wagalangweya vapmba klaigangwuk. Klalaa nɨmamba solat sɨgiyangwuk. ");
INSERT INTO ian_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mbambala ngwuk kat pagwuga nyaangɨt nandinya nandinya mbutɨgowun. Ngɨni yaiga njɨmbla pagwuga mbukwa nyaangɨt kwagalalaa kapmba wuna nyaekna vak kat mbukiyowun ngwuk kat. ");
INSERT INTO ian_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wan yaiga nandinya wuna sɨ waga wuna nyaek kat avla wagalagiyangwuk. Ngwutna nɨndɨmba lɨga ngwuk kat tɨga ana wagalagiyowun. Ngwuk avla wagalgiyangwuk. Ndɨ wukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ndɨ ngwuk kat woviyaguga lɨgandɨ. Wukiyandɨ. Wunkat woviyaguga yelavɨka lɨngwa vak kat wuna nyaek vɨlaa ngwuk kat woviyaguga lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tak wuna nyaek tɨga kavamba tɨwun. kwagalalaa wuna nyaek tɨga kavat lungwamataa yigiyowun waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jisas wandɨ maa ndɨna mbaapma nɨmba ndɨ kat wandi. Pagwula lɨga nyaangɨt ana mbutɨgambɨn. Kapmba lɨga nyaangɨt mɨna mbutɨganɨn. ");
INSERT INTO ian_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nɨn vɨga lɨganɨn. Nɨma nambuo lɨga nyan mɨn. Nambu klavat nat nɨmba kat ana wagalgiyamɨn. Apma nambu lɨma vak vɨlaa yelavɨtɨganɨn. Godno tɨga yamɨn waa vɨlɨganɨn waa wandi maa Jisas ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","32","Njambwi nyanat tuwa vak ngwuk wun kat vɨga lɨgangwuk? Kai? Ngɨni yaiga njɨmbla tamba ngway tologandɨ. Ngwuk kat nɨma vat yindi ma ngwuk kava kava vaaka yigiyangwuk. Wun kat kwagalangwuk maa kapma tɨgiyowun. Kapma ana lɨgiyowun. Wuna nyaek wunogwinala tɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Apma vat yelavɨka lɨmbangwuk waa wan nyaangɨt ngwuk kat mbutɨwun. Kɨpmamba lɨga nɨmba ngwuk kat nɨma vat yigiyandi. Ngwuk wata yelavɨka lɨngweya. Ndi kat tamba kwulakwun waa wandɨ Jisas. Walaa God kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas tanambɨka nyinangwutnat vɨlaa ndɨna nyaek kat wagalandɨ. Wuna nyaek, yaiga njɨmbla tamba yalaa lɨgandɨ. Ndi kat njambwi nyanat tuwa vak vɨsɨmogwimba mɨn. Ndi kat vɨsɨmogwimɨn, wun mɨna nyan mɨna sɨ kwutaa katsowun maa vɨga wukiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kɨpmamba lɨga nɨmbana njambwi nyanat tuwangat wun kat kwondu kwimɨn. Wun kat kwima nɨmba kat njɨmbla njɨmbla apma vat yiga yetɨnjeya vak kwiwangat wun kat kwondu kwimɨn. Ngi kat tɨga wun kat kwima kwondu ndi kat sɨmogwi mɨla. ");
INSERT INTO ian_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Njɨmbla njɨmbla apma vak yiga yetɨnjeya vak kɨngiyan. Mɨn God apma nyan mɨn. Mɨnai lɨga vla lɨga nyan ana lɨgandɨ. Mɨn njambwi nyan kɨta lɨgamɨn. Mɨna sɨ wuka mɨna mɨndama vɨga wuno wun kat Jisas Kraist ay wama nyan wun wuna sɨ wuka wuna mɨndama vɨga lɨlɨnjeyan apma vak yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kan kɨpmamba yalaa wunkat wama njɨvwa tamba kwutnyagiwun. Wama njɨvwa kwutaa mɨna sɨ kwutaa kwosowun. ");
INSERT INTO ian_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamba kan kɨpma ana lɨndɨ, wun tamba nɨma nyanat tɨwun. Nyaek, tamba njambwi nyanat tuwa vak wun kat nat njambɨ agwi mɨla. ");
INSERT INTO ian_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kan kɨpmamba lɨga wamɨn maa wun kat yaa nɨmba ndi kat mɨnai lɨga vat sɨmogwiwun. Tak ndi mɨna nyanguat tɨndi. Ndi kat wuna lak kwimɨn. Mɨnai kwiya nyaangɨt maawupmba yelavɨka kwutaa yi ya yetɨlɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kwutuwa njɨvwa mɨnai yelavɨka lɨga vapmba kwutɨgowun. Ndi tamba vɨga wuka lɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wun kat mbupma nyaangɨt ndi kat tamba mbukwun maa tamba wuka lɨgandi. Mɨnai lɨga kavamba lɨga wamɨn maa yaa nyan wun. Wuka lɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ndi kat tɨga mɨn kat wagalalɨgowun. Kan kɨpmamba lɨga kwo nɨmba kat tɨga ana wagalalɨgowun. Wun kat kwima nɨmba kat tɨga mɨn kat wagalalɨgowun. Wun kat kwima nɨmba kat tɨga mɨn kat wagalalɨgowun. Mɨna nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɨna nɨmba wuna nɨmba ndi. Njambwi nyanat tuwa vak vɨga lɨga wuna sɨ kwutaa katsolɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mɨna lak yavat kan kɨpma tamba kwagala mɨna lɨgowun. Ndi kan kɨpmamba kwagalalaa yawun, kapma lɨgiyandi. Wuna apma nyaek mɨna kwondumba wun kat kwima nɨmba kat awup mɨla. Wamɨn maa ndi kɨta vat yetɨgiyandi. Mɨn wun kɨta vat yetɨlia vla yetɨgiyandi. Wun ndi kat kwagalalaa mɨna lak yaigowun. ");
INSERT INTO ian_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ndinogwinala kan kɨpmamba tuwa njɨmbla ndi kat mɨna kwondumba kwutaa lɨwun. Wun kat kwima nɨmba ndi kat apma vak vɨga lɨwun. Ndi aywaa apma vat tɨgandi. Ndinagwi lɨga kɨta nyan mɨna kavle yindɨ. Ndɨ kavle nyana. Tamba la nyan pɨlɨwukna vapmba ndɨ kavle vat yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mbambala ndi kat kwagalalaa mɨna lak ya mɨna lɨgowun. Mɨn kat wagalaluwa nyaangɨt wutnjangat mɨn kat kwundimba wagalalɨgowun. Wutaa nɨma maawut yelavɨka lɨnja vak kwagalalaa apma vat tɨga solat sɨgiyandi. Solat sɨwa vla solat sɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɨna nyaangɨt ndi kat mbukwun. Ndi kɨpmamba la kwo nɨmbagwi kɨta vat ta nɨmba ana ndi. Kapma nyan tuwa vla ndino wuna mbaapmamba la nɨmba kapma nɨmba ndi. Kan kɨpmamba lɨga kwo nɨmba ndi kat kai walɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ndi kat kwutaa nat kavat kali waa mɨn kat ana wagalawun. Kan kɨpmamba tɨgiyandi. Ndi kat Seten yaa kavle vat yilandɨ walaa mɨn kat wagalalɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ndi kan kɨpmana nɨmba ana ndi. Ndi kapma ngepma nɨmba ndi. Kapma ngepmana nyanat tuwa vla ndino kapma ngepmana nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mɨnai yelavɨka lɨga apma nyaangɨt ndi kat sɨmogwi. Sɨmogwimɨn maa wutaa nat vat kwagalalaa mɨna njɨvwa mɨna kwuka yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wun kat ay wamɨn yawa vla ndi kat ay wowun, ngepma ngepma yigiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ndi kat kwunapmak nat vak kwagalalaa wama njɨvwa mɨna kwuka yetɨgiyowun. Ndino mɨna apma nyaangɨt wutaa nat vak kwagalalaa mɨna njɨvwa mɨna kwuka yetɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mɨn kat kɨndɨgi nɨmba kat tɨga mɨna ana wagalalɨgowun. Yiga wuna sɨ mbutndi maa wutaa maawupmba yelavɨka lɨgiyaa nɨmba kat tɨga mɨn kat wagalalɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ndi aywaa kɨta mbaapmamba tɨmbandi walaa mɨn kat wagalalɨgowun. Nyaek mɨnagwi wunogwi kɨta lulu tɨlia vla ndino wupma anogwi kɨta lulu tɨmbandi walaa mɨn kat wagalalɨgowun. Wupma kɨta lulu lɨnjeyan kwo lɨga nɨmba tɨnja vak kat vɨlaa yelavɨkiyandi. Jisas God wandɨ, yaa nyana waa yelavɨkiyangi. ");
INSERT INTO ian_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wun kat kwima apma vak ndi kat tamba kwiwun. Klalaa mɨnogwi wunogwi kɨta lulu tɨlia vak vla ndino anogwi kɨta lulu tɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mɨn mɨnai waa vak wuna maawupmba tɨgandɨ. Wun wunai waa vak ndina maawupmba tɨgandɨ. Ngi kat tɨga kɨta vapmba apma vak yetɨgiyandi. Nat nɨmba yetnjjeya apma vak kat vɨlaa yelavɨkiyandi. Jisas God wandɨ, yaa nyana. God ndɨna nyan kat woviyaguga lɨnda vla ndino ndi kat woviyaguga lɨgandɨ waa yelavɨkiyandi. ");
INSERT INTO ian_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nyaek wun kat kwima nɨmba wunai yetɨgiya kava yetɨmbandi walaa mɨn kat wagalalɨgowun. Tamba kɨpma ana lɨndɨ, wun kat woviyaguga lɨga wun kat nɨma kwondu kwimɨn. Wunai lɨgiya kava yalaa kwima kwondu vɨlaa yelavɨtɨmbandi walaa mɨn kat wagalalɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apma vat tɨga wuna nyaek, kan kɨpmamba lɨga kwo nɨmba mɨn kat ana vɨga lɨgandi. Wun mɨn kat vɨga lɨgowun. Kɨndi wunogwi lɨga nɨmba ndi vɨga lɨgandi mɨn kat. Ay wamɨn, yaa nyan wun ndi tamba vɨga lɨgandi. ");
INSERT INTO ian_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɨna vat ndi kat tamba vɨsɨmogwiwun. Vɨsɨmogwiluwa vat ana ngɨlɨndɨ. Nat njambɨ vɨsɨmogwigiyowun. Wun kat woviyaguga lɨma vla ndino ndi kat woviyaguga lɨma vak vɨmbandi walaa mɨn kat wagalalɨgowun. Wun ndina maawupmba tɨmbawun walaa mɨn kat wagalalɨgowun waa wagalandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas wagalandɨ maa ndɨna mbaapma nɨmbonala wan kava kwagalalaa Kidron walɨnja ndandangɨ sɨwuka valɨgendi. Valɨgelaa apma mi wata la kavat wuleindi. ");
INSERT INTO ian_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wuleinja kava Jisas kat kamwin kwiya nyan Judas ndɨno vɨga lɨndɨ. Jisas ndɨna mbaapma nɨmbonala wan kava nɨma sakwat njambɨ yilɨndi. ");
INSERT INTO ian_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","God kat kwunatɨga njambwi nɨmba Ferisio wandi maa njambwi la soldia kwo soldia kat wandɨ maa Judasonala kɨta vat yindi. Lam tuway nɨmbi nda kwutaa yindi Jisas kat kwupmat. ");
INSERT INTO ian_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas ndɨ kat kavle vat yinjeya vak tak vɨga lɨndɨ. Ngi kat tɨga yiga wogwega ndi kat vɨndɨ. Vɨlaa wandɨ. Anda nyan kat kwatɨgangwuk waa wandɨ maa wandi. ");
INSERT INTO ian_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jisas Nasaretna nyan kat kwatɨganɨn waa wandi maa Jisas ndi kat wandɨ. Wunayɨ waa wandɨ. Kamwin kwiya Judas yaa soldiana nɨndɨmba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wunayɨ waa wandɨ maa ndi kwup man veilaa vaaka kɨpmamba ndandi. ");
INSERT INTO ian_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ndandi maa Jisas ndi kat wagalandɨ. Ngwuk kanda kat kwaka yangwuk waa wagalandɨ ma ndi wandi. Jisas Nasaretna nyan kat kwaka nyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Wandi maa Jisas ndi kat wandɨ. Wunayɨ. Tamba ngwuk kat wowun. Wun kat kwatɨgangwuk. Wunogwinala lɨga nɨmba kat ke kwukngweya. kwatɨngwa nyan wunayɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tak Jisas ndɨna nyaek kat wandɨ. Wun kat kwima nɨmba kat apma vak vɨga lɨwun. ndina kɨta nyan ana kavle vat yindɨ. Jisas tak wanda nyaangɨt kat yelavɨtaa wandɨ. Ndi kat ke kwukngweya wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ndɨ yaak ngway avamba sandalaa yindɨ. Yaak kwutaa God kat kwunatɨga njambwi nyana njɨvwa kwutɨga nyana waan kalɨtndɨ. Yaagindan naangɨmba la waan kalɨtndɨ. Waan kalɨtnda nyana sɨ Malkus. ");
INSERT INTO ian_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita kalɨtndɨ maa Jisas ndɨ kat wandɨ. Wa yaak mɨna ngway avamba sanda. Wuna nyaek kwiya kavle vak kwindeyan wan kavle vak klaigowun. Ke kavle vak kwindeyan wan kavle vak klaigowun. Ke yelavɨka waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Judana njambwi soldia nat kwo soldia Jisas kat twutaa taamba ngilaa kwutaa kalindi. ");
INSERT INTO ian_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anas walɨnja njambwi nyan kat vɨvat kalindi. Wan njɨmbla Kaiafas God kat kwunatɨga nɨmbana njambwi nyana. Anas Kaiafasna nasakwatna. ");
INSERT INTO ian_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas tak Juda kat mbutndɨ. Kɨta nyan nɨn kat tɨga kiyandɨ maa kwo lɨneyan apma vatna waa tak wandɨ Kaiafas. ");
INSERT INTO ian_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jisas kat kwutaa kalindi maa Pita ndina kwupmba yindɨ. Jisasna mbaapmamba la nat kɨta nyan ndɨno wupma yindɨ. Wan nat kwupmba ya nyan kat God kat kwunatɨga njambwi nyan vɨga lɨndɨ. Ndɨ Anasna ngay Jisasonala wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ndɨ ana wuleindɨ. Ndɨna mɨndama ana vɨga lɨndi. Ndaamangemba lɨndɨ. God kat kwunatɨga njambwi nyan vɨga la Jisasna mbaapmamba la kɨta nyan wogwelaa ndaamange kat vɨga la taagwa nyan kat walaa Pita kat nyagat kalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kalindɨ maa ndaamange kat vɨga la taagwat Pita kat walɨ. Mɨn ndɨna mbaapmamba la nyan mɨn? Waa wagalalɨ maa Pita wandɨ. Wun kai waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wan ngayna njɨvwa kwuta nɨmbo soldiana njambwi nɨmbo ya salɨlaa mbangɨ tulɨndi. Yipma yila njɨmbla. Pita ndɨno mbangɨ ya tulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ngaymba lɨga God kat kwunatɨga njambwi nyan Jisas kat wagalandɨ. Ndɨna mbaapmamba la nɨmba kat wagalandɨ. Tak mbutnda nyaangɨt kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Wagalandɨ maa Jisas ndɨ kat wandɨ. Ndinyangu kat pagwuga ana wowun. Kapmba mɨna wowun. Juda yisolaa lɨnja ngay wuleilaa mbutɨwun. God kat kwunatɨnja ngay wuleilaa mbutɨwun. Juda njɨmbla njɨmbla wan ngay yisolaa lɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Manda kat wun kat wagala lɨgamɨn. Mbutuwa nyaangɨt wuta nɨmba ndi kat wagala. Ndi tamba wutaa yelavɨka lɨgandi. Wagalamɨn maa mɨn kat mbukiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas wandɨ ma njambwi soldia laataa Jisasna mɨndamamba taamamba viyandɨ. Viyaga wandɨ. Ke wupma waa God kat kwunatɨga njambwi nyan kat waa waga viyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Viyandɨ maa Jisas ndɨ kat wandɨ. Kavle vat yiweyan mɨn mbukiyamɨn. Kavle vat yilapman yiweyan wun kat manda kat viyamɨn waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tɨga lɨga Anas wandɨ maa God kat kwunatɨga njambwi nyan Kaiafas kat kalindi. ");
INSERT INTO ian_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita ndɨna mbangɨ ya tulɨndɨ maa nat nɨmba ndɨ kat wagalandi. Mɨn ndɨna mbaapmamba la nyan mɨn? Waa wagalandi maa Pita wandɨ. Kai ndɨna mbaapma nyan ana wun waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","God kat kwunatɨga njambwi nyana njɨvwa kwuta nyan tak waan kalɨtnda nyana yakwa nyan Pita kat vɨlaa wagalandɨ. Tak apma mi wata la kavamba yiga wuleilaa Jisasonala tɨga mɨn kat wɨwun? E? Waa wagalandɨ maa Pita wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kai. Wunai ana ndɨ. Nat nyana vɨma waa wandɨ maa ava nyaaga viyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaiafasna ngay kwagalalaa Romba la nyan nɨma jas ndaa lɨga ngayat kalindi Jisas kat. Tamba ngambi ngana. Ndi Juda wan ngay ana wuleindi. Pesto kat ndina nglambi tamba njangindi. Nat nglambi klavak kat kai wandi. Ana wuleindi. Nglambi klainjan wan pasova walɨnja pestona kɨgɨnda ana kɨgendi. ");
INSERT INTO ian_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ngi kat tɨga Pailat walɨnja nɨma jas wan ngaymba lɨga wogwendɨ. Wogwelaa Juda kat wandɨ. Ndɨ kat manda kat kotmak kat kiyangwuk. Manda vatna yinda waa wandɨ maa ndɨ kat Juda wandi. ");
INSERT INTO ian_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kavle vat yiga yetɨla nyanat tɨlapman tɨgendan ana ndɨ kat kwutaa mɨna lak kiyainɨn waa wandi maa Pailat ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ngwuk avla kwutaa kalilaa ngwutna ngepmana vapmba nagilaa ay ngwula waa wandɨ maa Juda wandi. Kɨta nyan kat sɨlandi walaa nɨn kat tamba wamɨn. Nɨna ngepmana vapmba nagineyan ndɨ kat vatnyavat tɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tak Jisas ndɨ kat vatnyanjeya vak tamba ndɨna mbaapma nɨmba kat mbutndɨ. Rom vatnyala vatna wun kat vatnyagiyandi wandɨ. Jisas waa nyaangɨt tamba kak kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat wan kotɨnja ngay wuleilaa Jisas kat wandɨ. yagwa mɨla waa wandɨ. Wandɨ maa Jisas wuleindɨ. Wuleindɨ, maa ndɨ gat wagalandɨ. Mɨn Judana king mɨn? E? Waa wandɨ maa Jisas ndɨ kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mɨn yelavɨka avla wagalagamɨn? Nat nɨmba mɨn kat wandi maa wagalagamɨn? Waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wandɨ maa Pailat wandɨ. Wun Juda ana wun. Mɨna ngepma nɨmba mɨna ngepmana njambwi nɨmba mɨn kat kwutaa wuna lak kalindi. Anda kavle vatna yima waa wagalandɨ maa Jisas wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Vɨga luwa kava kan kɨpma ana ndɨ. Vɨga luwa kava kan kɨpma lɨgendan wuna mbaapma nɨmba kao yiga waleagendi. Kao yiga waleandi maa Juda wun kat ana kwukendi. Vɨga luwa kava kan kɨpma ana ndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jisas wandɨ maa Pailat ndɨ kat wagalandi. Mɨn king mɨn? E? Waa wagalandɨ maa Jisas ndɨ kat wandɨ. Mɨn king mɨn waa ngiyambak wama. Wun njɨvwa kwukwangat kan kɨpmamba wuna nyɨme wun kat kwutɨ. Wan njɨvwa kwupmak kan kɨpma ngaga yawun. Savagu lɨga apma vat tɨga nyaangɨt mbupmat yawun. Savagu maawut tɨga nɨmba wuna nyaangɨt wuka lɨgandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jisas wandɨ maa Pailat wandɨ. Manda kat wupma wamɨn. Savagu lɨga nyaangɨt ana vɨga lɨgowun waa walaa Juda kat mbupmat wogwendɨ. Wogwelaa ndi kat wandɨ. Ndɨna kavle vat yinda vak ana wuka vɨwun. ");
INSERT INTO ian_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngwutna ngepmana vak kɨngiyan. Pasova walɨnja pesto yalɨnja njɨmbla naambi naambi kalabusma lɨlɨga kɨta nyan kat kwagalalɨgowun. Ngwut Judana kingat kwaglalu? Ngula lak yigandɨ? Waa wagalandɨ maa walega wandi. ");
INSERT INTO ian_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ndi kai. Ndɨ kat ke kwagalaga. Barabas kat kwagalamɨn maa nɨna lak yaandɨ waa walega wandi. Barabas nat nɨmba kat sɨga vatnyaga sɨkwutɨga nyana. Kavle nyana. ");
INSERT INTO ian_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailat wandɨ maa Jisas kat kwutaa viyandi. ");
INSERT INTO ian_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldia nɨmbio lɨga yamboy klalaa ndɨna nambumba king kwusoa hat vla kavle hat kwutaa kaalandi. King kwusoa vla yelogwen mbangɨ waavwi klalaa ndɨna mbangɨmba kwusondi. ");
INSERT INTO ian_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kwusolaa ndɨ kat njɨka waga viyalɨndi. Njambwi nyan mɨn. Mɨn Judana king mɨn njɨka waga ndɨ kat taambamba viyalɨndi. ");
INSERT INTO ian_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat ngaymba lɨga wogwelaa ndi kat wandɨ. Kavle vat vinda vat wun ana vɨga lɨgowun. Ngwuk kat kwo kiyawun waa wandɨ maa Jisas alaguat wogwendɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nɨmbio la yamboy ndɨna nambumba lɨndɨ, yelogwen mbangɨ waavwi kwusoga alaguat wogwendɨ maa Pailat ndɨ kat vɨlaa Juda kat wandɨ. Wan nyan kat avɨ ngwula waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pailat wandɨ maa wutaa God kat kwunatɨga njambwi nɨmbogwi njambwi soldio Jisas kat vɨlaa nɨma kwundimba walega wandi. Ndɨ kat diwai krosmba kaala mɨla. Diwai krosmba kaala mɨla wandi. Wandi maa Pailat ndi kat wandɨ. Kavle vat yilɨnda vak wun ana vɨga lɨgowun. Wun diwai krosmba ana kaalagiywoun. Ngwut avla ngwula lak ndɨ kat kwutaa kaliga yiga diwai krosmba kaalagiyangwuk waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pailat wandɨ maa Juda ndɨ kat wandi. Wan nyan wun Godna nyan wun waa wandɨ. Nɨna ngepma vapmba wan wanda vak kat kai wandɨ. Nɨna ngepma vapmba wan nyaangɨt walɨga nyan kat sɨlɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wanja nyaangɨt kat wutaa Pailat maawut viyalɨndɨ yelavɨka lɨga ");
INSERT INTO ian_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kot tɨnja ngay wuleilaa Jisas kat wagalandɨ. Andamba lɨga yaa nyan mɨn waa Jisas kat wagalandɨ maa Jisas ndɨ kat ana wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jisas ndɨ kat kwundi walapman yindɨ maa Pailat at ndɨ kat wandɨ. Manda kat walɨwa nyaangɨt kat kulumaka walapman yilɨgamɨn. Wowun maa kwagalagiyandi. Wowun maa mɨn kat diwai krosmba kaalagiyandi. Njambwi nyanat tuwa vak ana wuka lɨgamɨn? Waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Pailat wandɨ maa Jisas ndɨ kat wandɨ. Wun kat kavle vat yivat tɨma kwondu Godnanamba klamɨn. Avla mɨna kwondumba ana alɨpsɨga wun kat kavle yigiyamɨn. Wun kat kwutaa mɨn kat kalia nyan kavle vat yinda vat kavle yilɨma vak kat kwulatɨgandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat wutaa Jisas kat kwagalandɨ, yindeya vak kat yelavɨtndɨ. Pailat yelavɨka lɨnda vak kat wutaa Juda ndɨ kat wandi. Ndɨ kat kwagalameyan njambwi nyan Sisana alɨ nyanat ana lɨgiyamɨn. Wan nyan wun king wun wandan Sisa kat kai walɨgandɨ waa Juda wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wanja vak Pailat wutaa Jisas kat kwutaa alaguat kawa kalindɨ. Alagumba lɨga kotɨnja kavamba yiga ndaa lɨndɨ Pailat. Kambapmba saginja njambɨ la kavamba ndaa lɨndɨ. Juda ndina kwundi wan kavana sɨ Gabata wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tamba nɨma nandinya. Juda pasova walɨnja pesto kat kwanda kwanda nda kwunatɨndi. Pailat Jisas kat alaguat kalilaa Juda kat wandɨ. Kan nyan ngwutna kinga. Ndɨ kat avɨ ngwula waa wandɨ maa Juda nɨma kwundimba walega wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ndɨ kat kwutaa kali. Ndɨ kat kwutaa kaliga yiga diwai krosmba kaala mɨla waa walega wandi maa Pailat ndi kat wagalandɨ. Ngutna kingat kwutaa diwai krosmba kaalalu waa wagalandɨ ndi kat. Wagalandɨ maa God kat kwunatɨga njambwi nɨmba ndɨ kat wandi. Ndɨ nɨna king ana ndɨ. Nɨna king Sisa. Nat nyan kai waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wandi maa Pailat Jisas kat ndina lak kwindɨ, ndɨ kat diwai krosmba kaalanjangat. Ndina lak kwindɨ maa Jisas kat kwutaa ndina lak kalindi. ");
INSERT INTO ian_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas kiwai kros kwutaa ndɨna nyaambupmba walalaa kalindɨ. Kaliga yiga nambu ava vla lɨga nduwiat yindɨ. Wan nduwina sɨ Judana kwundimba Golgota waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wan nduwimba ndɨ kat kwutaa diwai krosmba kaalandi. Vɨlɨlɨk palɨ kat kwutaa ndɨnai la kavamba angangɨ mbɨk kat diwai krosmba kaalandi. Jisas ndɨ nɨndɨmba lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat nyaangɨt pɨlɨwutaa Jisasna diwai krosmba taagandɨ. Jisas nasaret nyan. Judana kinga waa pɨlɨwutaa taagandɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisas kat kaalanja kava ngepma ngwaya. Sɨvla ana ndɨ. Ngi kat tɨga wan ngepmana Juda nɨma sakwat yalaa pɨlɨwutnda nyaangɨt kat vɨndi. Pailat kwundi kuvuk pɨlɨwutndɨ. Judana kwundi pɨlɨwutaa Grikna kwundi pɨlɨwutaa Romna kwundi pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pɨlɨwutɨnda nyaangɨk kat vɨlaa God kat kwunatɨga njambwi nɨmba pailat kat wandi. Judana kinga waa pɨlɨwupma nyaangɨt vɨnɨn ana nglaatndɨ. Judana king wun waa wandɨ waa pɨlɨwupmeyan wovuna waa wandi maa Pailat ndi kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pɨlɨwukwa nyaangɨt wupma lɨgiyandɨ. Ana mandɨk pɨlɨwukiyowun waa wandɨ Pailat. ");
INSERT INTO ian_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldia Jisas kat kaalalaa ndɨna waavwi nat nda klalaa lɨgalaa angɨ aynat taagandi. Nat soldia nat kɨta angɨ waavwi klandɨ. Ndɨna alagumba kwusonda waavwi vɨlaa klalaa tavanja kava kat vɨlevilaa lɨndi. Tavanja kava kai. ");
INSERT INTO ian_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ngi kat tɨga awat sowat ngambuga lɨgavak kat kai wandi. Satumba kasaga kɨta nyanat klaigandɨ waa ngambulaa satumba kasendi. Tamba la nyan God waa nyaangɨt pɨlɨwutndɨ. Wuna waavwi tangaka klalɨndi. Wuna nat waavwi klavat satumba kaselɨndi waa tamba la nyan pɨlɨwutndɨ. Tamba pɨlɨwutnda nyaangɨpmba soldia yindi. ");
INSERT INTO ian_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas kat kaalanja diwai krosna nagwamba ndɨna nyɨme laataa lɨlɨ. lɨla yakwa lagwo lɨlo wumba kɨta vak tɨmbɨk. klpasna taagwa nat Maria lɨlo tɨlɨ. Magdala walɨnja ngepmana nat Maria tɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas ndɨna nyɨmeagwi ndɨna mbaapmamba la kɨta nyan kat vɨlaa mbɨk kat wandɨ. Wan ndɨna mbaapmamba la nyan kɨta nyan kat Jisa woviyaguga lɨndɨ. Mbɨk kat vɨlaa wandɨ. Nyɨme kat wandɨ. Taagwa, wan nyan nyɨna nyan vla lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ndɨna mbaapmamba la nyan kat vɨlaa wandɨ. Mɨn, wat taagwa mɨna nyɨmeat tɨgiyalɨ waa mbɨk kat wanda maa wutaa ngɨni wan nyan Jisasna nyɨme kat kwutaa ndɨna ngayat kalindɨ. Ndɨna ngaymba tɨlɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tɨga lɨga Jisas yelavɨtndɨ. Wuna njɨvwa tamba ngɨlɨgandɨ waa yelavɨtndɨ. Tamba la nɨmba God waa nyaangɨpmba pɨlɨwutndi. Kraist ngu kat wagalagiyandɨ waa tamba pɨlɨwutndi. Jisas wan pɨlɨwutnja nyaangɨt kat yelavɨtaa wuna mbanjɨge tamba ngu kat tɨga pundɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jisas wandɨ maa wutaa awmba lɨga nyingi lɨga ngu namɨnɨngɨ klalaa taagalaa njɨmbwi mbaomba sɨlaa Jisas kat kwusoga ndɨna tɨpmwimba taagandi. ");
INSERT INTO ian_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Taagandi maa Jisas kɨlaa wandɨ. Kwutuwa njɨvwa tamba ngɨlɨndɨ waa walaa nambu sɨlandalaa wundumbu yindɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wan nandinya pasova walɨnja pesto kat kwanda kwanda kwunatɨnja nandinya. kinya nandinya njɨvwa lapman tɨnjeya nandinya. Nɨma njambiya lɨga nandinya. Juda wan diwai krosmba la kuvut nɨmba kinya njɨvwa lapman nandinya tɨvak kat kai wandi. Kwiyatapman vaangugiyangwuk walaa Pailat kat wandi. Wamɨn maa ndina man ava pangwutndi maa kiyandi vaangumbandi. Kwo mbaa tɨlandi. Vaangumbandi wandi. ");
INSERT INTO ian_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wandi maa Pailat wandɨ maa soldia yiga Jisasna angangɨmba la mbɨt nyana man ava pangwutndi, kiyambɨt. ");
INSERT INTO ian_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jisasna man ava pangwupmak yiga ndɨ kat vɨndi. Tamba kiyandɨ. Kwo ana lɨndɨ. Ngi kat tɨga ndɨna man ava ana pangwutndi. ");
INSERT INTO ian_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Soldia kɨta nɨmbi nda klalaa ndɨna malava sɨndɨ maa nguogwi yelogweno salaka ndaindɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wun wan vak tamba vɨwun. Ana woseka wowun. Vɨlaa wukngwangat kan nyaangɨt pɨlɨwutɨgowun. Jisas God wandɨ, yaa nyana waa yelavɨkngwangat wan nyaangɨt pɨlɨwutɨgowun. ");
INSERT INTO ian_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wan vɨwa vak tamba la profet pɨlɨwukna vak vla lɨgandɨ. Tamba pɨlɨwutndɨ. Ndɨna ava ana pangwukiyandi. Waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nat nyan ndɨnogwi pɨlɨwutndɨ tamba. Nɨmbi ndamba sɨnjeya nyan vɨgiyandi. Waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tɨga lɨga Arimatia walɨnja ngepmamba la nyan Josep Pailat kat yandɨ. Ndɨ tamba Jisasna mbaapmamba la nyana. Judana njambwi nɨmba kat tɨga vaaka lɨga Jisasna mbaapmamba lɨnda vak kat pagwundɨ. Pailat kat yalaa Jisasna sɨm kwutaa kaliga vaanguvak kat wagalandɨ. Pailat ndɨ kat kali wandɨ maa ndɨna sɨm kwutaa kalindɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josep ndɨ kapma ana yandɨ. Nat nyan Nikodimasonala yandɨ. Nikodimas tak ngamba Jisas kat vɨvat yaa nyana. Apma njangu veila ngwak kwutaa yandɨ. Ngwat nɨma sakwat kwutaa kiyandɨ. Wan ngwak sanya nɨma sakwat kwilaa klandɨ. ");
INSERT INTO ian_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jisasna sɨm kwutaa Judana vapmba njangu veilɨga ngwak ndɨna mbangɨ kulaviga kwutaa waavwimba mbaaka ngimbɨk. ");
INSERT INTO ian_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas kat kaalanja kava ngwaymba apma mi watɨga kɨpma lɨndɨ. Wan kavamba kaambapmba vanja waangu tɨndɨ. Tak kiya nyan kat wan waangumba ana taagandi. Kwo ta waangua. ");
INSERT INTO ian_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sɨvla kavamba yiga vaanguvak kat ndɨna sɨm kat kai wambɨt. Judana pesto tamba ngway tolondɨ. Ngi kat tɨga wan ngwaymba la waangumba ndɨna sɨm vaangumbɨt. ");
INSERT INTO ian_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande ngambi gleimba Magdalana taagwa Maria Jisas kat vaangunja kava vɨvat laataa yilɨ. Ndɨna waangu tegɨlɨnja kambak ana lɨndɨ, vɨlevilaa yilɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pɨlɨga yiga Pitogwi Jisasonala kɨta vak ta nyan kat walɨ. Nat nyan ndɨ kat Jisas woviyaguga lɨnda nyana. Nɨna njambwi nyan waangumba taagandi, lɨndɨ, ndɨ kat tamba kwutaa sɨkwutaa kalindi. Kalinja kava ana vɨga lɨgowun waa mbɨk kat mbutɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mbutɨ maa Pitagwi Jisasonala kɨta vak ta nyan laataa waangu la kavat pɨlɨga yimbɨt. ");
INSERT INTO ian_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pɨlɨga yiga nat nyan Pita kat kwulaka pɨlɨndɨ. Ndɨ tatak waangu la kava wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tamblalaa yisolaa vɨndɨ. Ana wuleindɨ. Jisas kat mbatɨnja kwo waavwi mɨna tɨndɨ, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ndɨna kwupmba pɨlɨga Saimon Pita yalaa wan waangu wuleilaa kwo waavwi mɨna tɨndɨ maa vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ndɨna nambu kamonja waavwi nat waavwi ta kavamba ana lɨndɨ. Ndɨ mbandɨga laagandi, kapma kavamba lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pita wuleindɨ maa nat nyan ndɨna kwupmba wuleindɨ. Wuleilaa vɨlaa Jisas kiyalaa tamba laatndɨ waa yelavɨtndɨ. Jisas kiyalaa laakiyandɨ waa tak ana yelavɨka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tamba la profet pɨlɨwukna nyaangɨt kwo mɨni vɨga lɨmbɨt. Kraist kiyalaa lɨga laakiyandɨ. Waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Vɨlaa wumbɨt nyan kwagalalaa ngegavat yimbɨt. ");
INSERT INTO ian_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yimbɨt maa Maria mbɨtna kwupmba ana yilɨ. Waangu la kavamba tɨga lɨ nglaga lɨlɨ. Lɨlo nglaa lɨga tamblalaa waangu kat yisolaa vɨlɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sawun mbangɨ waavwi kwusola la ensel vɨlɨlɨk tɨmbɨk, vɨlɨ. Nat ensel Jisasna sɨmna nambu la kavamba ndaa lɨndɨ. Nat ensel Jisasna sɨmna man ta kavamba ndaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lɨ kat vɨlaa wambɨt. Taagwa, nyɨn manda kat nglaa lɨganyɨn waa wambɨt maa walɨ. Wuna njambwi nyana sɨm kwutaa kalinja kava ana vɨga lɨgowun. Ngi kat tɨga nglalɨgowun waa walaa. ");
INSERT INTO ian_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lɨmbanda Jisas kat vɨlɨ. Vɨlaa Jisas waa ana yelavɨtɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas lɨ kat wandɨ. Taagwa, nyɨn manda kat nglaa lɨganyɨn. Kanda kat kwaka vɨlɨganyɨn waa wandɨ. Maria ndɨ kat vɨlaa kan kɨpma kat vɨga lɨga nyana waa yelavɨtaa walɨ. Mɨn, ndɨna sɨm kwutaa kaliga taagameyan wun kat ambuk. Wamɨn maa ndɨna sɨm kwutaa kaligiyowun waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Walɨ maa Jisas lɨ kat lɨla sɨ wandɨ. Maria wandɨ. Wandɨ maa lɨmbanga Jisas kat vɨlaa walɨ. Judana kwundimba Rabonai walɨ. Rabonai waa sɨmaga lɨga nyan waa walɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Walɨ maa Jisas lɨ kat wandɨ. Wun kat ke kwuka. Wuna nyaek kat vɨvak wata ana wokewun. Wuna mbaapmamba lɨga nɨmba kat yiga ambuk. Wun nyaek vɨvak wokevat tɨgowun. Ndɨ ngwutna nyaek nɨmbun. Wuna njambwi nyan kat vɨvak wokevat tɨgowun. Ndɨ ngwutna njambwi nyan nɨmbun waa ndi kat abuk nyɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jisas wandɨ maa Magdalana Maria Jisasna mbaapmamba la nɨmba kat yiga mbutɨ. Njambwi nyan kat tamba vɨwun waa mbutɨ. Jisas ndi kat yiga ambut nyɨla waa wanda nyaangɨt ndi kat mbutɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wan Sande nglaambu Jisasna mbaapmamba la nɨmba ngaymba wuleiga yisolaa lɨndi. Judana njambwi nɨmba kat vaaka lɨga mbapmo kwalalaa tɨndi. Yisolaa lɨndi maa Jisas ndinai la kavamba kak kiyalaa ndi kat wandɨ. Ngwula maawut nɨmamba viyalɨndɨ ke tɨngwa waa waga ");
INSERT INTO ian_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ndɨna taambamba la paw ndɨna malavamba la paw ndi kat sɨmogwindɨ. Ndɨ kat vɨlaa kan nɨna njambwi nyana yaa walaa ndɨ kat solat sɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas ndi kat wandɨ. Apma maawut yelavɨka alɨ ngwula. Wuna nyaek wun kat ay wandɨ, yiwa vak vla ngwuk kat ay wagowun waa walaa ");
INSERT INTO ian_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ndi kat mwuk vɨlɨtaa wandɨ. Godna waagan ngwuk klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nat nɨmba yiga yetɨgiyaa kavle vak kat vɨlaa ndi kat miwa yilaa sɨlɨmbwingweyan wan kavle vak ngɨlɨgiyandɨ. Ana ndinamba tɨgiyandɨ. Nat nɨmba yiga yetɨgiyaa kavle vak kat vɨlaa sɨlɨmbwilapman yingweyan ndinamba kwo lɨgiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tak Jisas ndɨna mbaapma nɨmba kat kak kiyanda njɨmbla Tomas Didimas vɨligu nyan ndɨ ana lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nat nɨmba ndɨ kat wandi. Njambwi nyan tamba laataa yandɨ, vɨnɨn. Kwo lɨgandɨ wandi. Wandi maa wandɨ. Ngwuk wun kat woseka wangwuk. Ndɨna taambamba lɨga paw vɨlaa wuna taamba sɨga vɨlaa ndɨna malava lɨga paw wuna taamba sɨga vɨweyan woseka wangwuk waa ana waigowun. Vɨlapman yiweyan woseka wangwuk waigowun waa wandɨ Tomas. ");
INSERT INTO ian_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nandinya sɨla kuvuk yindɨ maa Jisasna mbaapmamba la nɨmba ngayat wuleiga yisolaa lɨndi. Wan tɨnja njɨmbla Tomas ndinogwinala lɨndɨ. Mbapmo kwalalaa tɨndi maa Jisas at nat njambɨ yaa ndi kat kak kiyalaa ndi kat wandɨ. Apma maawut yelavɨka alɨ ngwula waa walaa. ");
INSERT INTO ian_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomas kat wandɨ. Mɨn laataa yagwa mɨla. Wuna taambamba lɨga paw mɨna taamba sɨga avɨ. Kiyalaa lɨga ana laatndɨ waa yelavɨka lɨma vak mɨn kwagala. Kiyalaa laatndɨ waa yelavɨka alɨ mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jisas wandɨ maa Tomas wandɨ. Tamba yelavɨka lɨgowun. Mɨn wuna njambwi nyan mɨn. Mɨn God mɨn wandɨ. ");
INSERT INTO ian_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas ndɨ kat wandɨ. Tomas wun kat mɨnimba vlɨaa njambwi nyanat tuwa vak yelavɨka lɨgamɨn. Nat nɨmba wuna mbangɨ mɨnimba vɨlapman tɨga njambwi nyanat tuwa vak yelavɨka lɨnjeyan wundi nɨmba ndi apma nglei vat tɨgiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas nat nɨma sakwat nɨma njɨvwa kwutɨndɨ, ndɨna mbaapmamba la nɨmba vlɨlɨndi. Wan nat nɨma sakwat njɨvwa kat ana pɨlɨwukwun. ");
INSERT INTO ian_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wan pɨlɨwukwa nyaangɨt nat nɨmba vɨlaa ndɨ Jisas God wandɨ, ndinyangu kat kwunapmak yaa nyana, ndɨ Godna nyana waa yelavɨpmbandi walaa pɨlɨwukwun. Wupma Jisas kat yelavɨka yetɨlɨnjeyan njɨmbla njɨmbla apma vat yiga yetɨlɨnjeya vak klaigandi. ");
INSERT INTO ian_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tɨga lɨga Jisas ndɨna mbaapmamba la nɨmba kat nat njambɨ yandɨ maa vɨndi. Taibirias walɨnja sapmba tɨga lɨga ndɨ kat vɨndi. Vɨnja vak kɨngiyan. ");
INSERT INTO ian_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jisasna mbaapmamba la ndi sɨla vɨli nyangu kɨta mbupmba yisolaa lɨndi. Pita, Tomas waa Didimas walɨnja nyan, Nataniel Kena walɨnja ngepmamba la nyan Galili nyana, Sebidina nyan vɨlɨlɨk, nat vɨlɨlɨk palɨ kɨta mbupmba yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yisolaa lɨndi maa Pita ndi kat wandɨ. Kami kwupmak yigiyowun waa wandɨ maa nɨno yigiyanɨn waa wandi. Njambɨt kulaa yindi. Ngan ngan kami kwupmak kat yetɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nya wokelɨndɨ maa Jisas tɨvagawimba ngaga yalaa lɨndɨ. Ndɨna mbaapma nɨmba njaambɨpmba lɨga ndɨ kat vɨlaa kwo nyana waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisas ndi kat wandɨ. Nyangu kami kwukngwuk? Waa wandɨ maa wandi. Kami kat kwatevilaa lɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wandi maa wandɨ. Njambɨtna yaagindan naangɨmba njula ana tawngwuk. Yaagindan naangɨmba tawngweyan kwukiyangwuk waa wandɨ maa wupma tawlaa nɨma sakwat kami njulamba ndandɨ, kwutndi. Katsovak yilavindi wan njula. ");
INSERT INTO ian_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisas woviuaguga lɨnda nyan Pita kat wandɨ. Angwi nɨna njambwi nyana waa wandɨ Pita kat. Wandɨ maa wutaa tak sɨvenda waavwi kwutaa kwusolaa ngumba ndaiga nɨmbu veindɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nat nɨmba njambɨpmba weleindi nɨmbak. Jisas kat vɨnja sɨvla 300 fit vla lɨndɨ maa mɨndi. Sɨvla ana lɨ. Wan njula njaambɨpmba ngilaa laaka klokalindi nɨmbak. ");
INSERT INTO ian_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Klokaliga kawilaa vɨndi. Jisas ya laagalaa kami yamba tuga bret-nao nɨmbun yamba tundɨ, vɨndi. ");
INSERT INTO ian_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisas ndi kat wandɨ. Wan kwukngwa kami njulonala laaka agiya ngwula waa wandɨ maa ");
INSERT INTO ian_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pita laataa laaka kiyandɨ nɨmbak. Kwutnja kami nɨma sakwatna. 153 tɨndɨ. Wan njula ana ngɨlɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas ndi kat wandɨ. Yaa agɨ ngwula waa wandɨ. Ndɨna mbaapma nɨmba ngɨpaliga ndalaa anda nyan mɨn waa ana wagalandi. Ndi aywaa ndɨ kat tamba vɨga lɨndɨ. Njambwi nyanat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas yalaa bret-nao kamio kwutaa ndi kat aywaa kwindɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas kiyalaa lɨga laataa yandɨ maa ndɨna mbaapma nɨmba ndɨ kat vɨndi kuvuk wan njambɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kɨndi maa Jisas Pita kat wandɨ. Saimon Jonana nyan wundi nɨmba wun kat woviyaguga lɨnja vak kat mɨn kwulatɨgamɨn wun kat woviyaguga lɨma vak? Waa wagalandɨ maa Pita ndɨ kat wandɨ. Awa luwa. Mɨn kat nɨman woviyaguga lɨgowun. Vɨga lɨgamɨn waa wandɨ maa Jisas ndɨ kat wandɨ. Sip sip kat kɨgɨnda kwinja vla wuna nyangu kat kwunaka vɨga alɨ mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Vɨlɨlɨk wan njambɨ Jisas Pita kat wagalandɨ. Saimon Jonana nyan wun kat woviyaguga lɨgamɨn? E? Kai? Waa wagalandɨ maa Pita wandɨ. Njambwi nyan mɨn kat woviyaguga lɨgowun. Vɨga lɨgamɨn waa wandɨ maa Jisas ndɨ kat wandɨ. Sip sip kat vɨga lɨnja vla wuna nyangu kat kwunaka alɨ mɨla. ");
INSERT INTO ian_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kuvuk wan njambɨ Jisas Pita kat wagalandɨ. Saimon Jonana nyan wun kat woviyaguga lɨgamɨn? E? Kai? Waa wagalandɨ maa Pita samat kɨlɨpangɨ yindɨ. Yilaa yelavɨtndɨ. Wun kat manda kat njambɨ kuvuk wagalandɨ waa yelavɨtndɨ. Yelavɨtaa wandɨ. Njambwi nyan maawupmba lɨga vak aywaa vɨga lɨgamɨn. Mɨn kat woviyaguga luwa vak vɨga lɨgamɨn waa wandɨ maa Jisas ndɨ kat wandɨ. Sip sip kat kɨgɨnda kwinja vla wuna nyangu kat kwunaka vɨga alɨ mɨla. ");
INSERT INTO ian_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mɨn kat kɨta nyaangɨt mbutu. Awup mɨla. Tak kwandɨ nyanat tɨma njɨmbla yɨpma yaaw sɨtaa mɨna maawupmba yi ya yetɨmɨn. Ngɨni avɨt ndu tɨmeya njɨmbla taamba kwiyalalaa lɨmɨn maa nat nɨmba mɨn kat ngilaa kaligiyandi nat kavat. Mɨn kat ana wagalgiyandi. Ndina waawupmba mɨna yelavɨka kaligiyandi waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ngɨni Pita kiyandeya vak kat Jisas ndɨ kat smogwivat wupma mbutndɨ. Kiyandeya njɨmbla Pita Godna sɨ kwutaa katsogiyandɨ. Jisas wan vak walaa Pita kat wandɨ. Mɨn wuna kwupmba yagwa waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisasna kwupmba yiga Pita lɨmbanga Jisas woviyaguga la nyan kat vɨndɨ. Ndɨ mbɨtna kwupmba yindɨ. Wan nyan tat kɨgɨnda kɨlɨnja njɨmbla Jisasna ngwaymba lɨga Jisas kat wagalandɨ. Njambwi nyan kandana kamwin mɨn kat kwigiya waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ndɨ kat vɨlaa Jisas kat wandɨ. Njambwi nyan an nyan ngɨni manda vala yindeya waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pita wandɨ maa Jisas ndɨ kat wandɨ. Yaweya njɨmbla kat kawiga kwo lɨndeyan mɨna vak ana ndɨ. Mɨn wuna nyaangɨt wuka wawa njɨvwa agwup mɨla waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nat nɨmba wutaa mbutseli mbutsela mbuka kalindi. Jon ana kiyaigandɨ waa Jisas wandɨ waa mbutseli mbutsela mbuka kalindi. Jisas wupma ana wandɨ. Yaweya njɨmbla kat kawiga kwo lɨndeyan mɨna vak ana ndɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wan nyan wunayɨ. Wunayɨ wan nyaangɨt pɨlɨwukna. Woseka waga ana pɨlɨwukwun. Nɨn Jisasna mbaapma nɨmba vɨga lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas yila nɨma sakwat vak wan vak kat ana pɨlɨwukwun. Wan vak nat nɨmba pɨlɨwutnjeyan nɨma nglei sakwat lavu nyinga pɨlɨwukiyandi. Kava kava taakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","5","Apma nandinya Tiofilas. Tat mɨn kat nyaangɨt kɨta pɨlɨwutaa kwiwun. Kɨngi nyaangɨtna pɨlɨwukwun. Jisas mbuka kwutaa njɨvwa kwutnjangat ndɨna aposel kat wandɨ. Godna waagan Jisasna maawut ngwandɨndɨ maa Jisas ndɨna mbaapmamba lɨga nɨmba kat wuna njɨvwa agwut wandɨ. Kiyalaa lɨga laatndɨ. Laataa yalɨndɨ, ndɨna mbaapma nɨmba ndɨ kat vɨlɨndi. Laataa yalɨndɨ, ndɨna mbaapma nɨmba ndɨ kat vɨlɨndi. Laataa ndu nyan vla lɨndɨ, vɨlɨndi. Vɨlaa wandi. Ana kiyalaa lɨgandɨ. Kwo lɨgandɨ waa wandi. Ndɨ kat vɨga lɨndi nandinya ndumi vɨli. Wan njɨmbla God ndina lak kwandeya vak kat ndi kat ngambundɨ. Nat njɨmbla kɨta vat ndalɨga kɨgɨnda kɨga lɨga Jisas ndi kat wandɨ. Ngwuk kumba Jerusalemba tɨgiyangwuk. Nat ngepma wana yelɨngweya. Wuna nyaek nyɨnangwupmba lɨga ndɨna waagan ngwuk kat kwindɨ maa ngwutna mbangɨ tavigiyandɨ. God tamba wanda nyaangɨtna. Ngwuk kat tamba wowun wungi nda kat. Jon ngwuk kat ngumba yagundɨ. Jon yagua vak vla God ndɨna waagan kwindɨ, ngwula mbangɨmba tavigiyandɨ waa wandɨ Jisas. Jisas wandɨ maa God ndɨ kat kwutaa nyɨnangwut kalindɨ. Tiofilas kan nyaangɨt tat mɨn kat pɨlɨwukwun, vɨmɨn. ");
INSERT INTO ian_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nat njɨmbla yisolaa lɨndi. Tɨga lɨga ndɨna mbaapma nɨmba Jisas kat wagalandi. Njambwi nyan anda njɨmbla mɨn Isrel nɨna kɨpma kat nɨn nat njambɨ avla vɨga lɨgiyanɨn. E? Mbambala vɨga lɨgiyanɨn? ");
INSERT INTO ian_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wandi maa Jisas ndi kat wandɨ. Vɨngweya njɨmbla kat God mɨna vɨga lɨgiyangwuk. Godna sɨpana. Wan nyaangɨt nɨma nda ana ndɨ. Nɨma nyaangɨt kɨngiyan. ");
INSERT INTO ian_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Godna waagan ngwutna mbangɨmba tavindɨ maa God ava kwigiyandɨ. nywuk kat. Jerusalem, Judia, sameria, ngepma ngepma yiga yetɨwa vak kat mbuka wunai waa nyaangɨt mbukiyangwuk wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Walɨndɨ maa ndɨ kat vɨlɨndi, God wandɨ, nyɨnangwutnat wokendɨ. Nyɨnangwut wokelɨndi mala tɨmbun tɨga pagwundɨ maa ana vɨndi. ");
INSERT INTO ian_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jisas wokeya kava vɨlɨndi maa ndu vlɨlɨk yalaa ndinonala lɨmbɨk. Mbɨla waavwi sawun mɨna lɨndɨ, yambɨk. ");
INSERT INTO ian_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ndina ngwaymba lɨga ndi kat walɨmbɨt. Ngwut Galilina nɨmba ngwuk, nyɨnangwut manda kat vɨlɨgangwuk. Jisas ngwutnanala lɨga God wandɨ, nyɨnangwut wokendɨ, vɨlɨngwa vla ngɨni ngwuk kat ngaga yaigandɨ waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wambɨt maa Jisasna mbaapma nɨmba wan nduwi Oliv walɨnja nduwi kwagalalaa Jerusalemat yindi. Oliv Jerusalem kɨta ngwaymba lɨgambɨt. Sɨvla kai. Wan ava yambɨna sɨvla kɨngiyan. Njɨvwa lapman nandinyamba yinjeyan ndina ngepma vak kai ana wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ngepmat wuleiga ngayat wuleindi. Wan ngaymba Pita, Jon, Jems, Endru, Filip, Tomas, batolomyu, Matyu, alfiasna nyan nat Jems, Juda ndina kɨpma avla vɨga lɨgiyandi waa yiga ngambula nyan saimon, Jemsna nyan nat Judas aywaa wan ngaymba yetɨndi. ");
INSERT INTO ian_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wundi nɨmba God kat kɨtamba ngambulɨndi kɨta vapmba. Nat taagwa ndinagwinala lɨndi. Jisasna nyɨme Maria ndɨna yakwa ndu wupma lɨndi wan ngaymba. ");
INSERT INTO ian_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Samat tɨgawan vak yandɨ. Ndumu sɨla kɨta Jisasna mbaapma nɨmba yisolaa lɨndi maa Pita ndina nɨndɨmba laataa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","Jisasna mbaapma nɨmba ngwuk, tak Judas Jisas kat kwupmak ta nɨmba kat ndɨnai la kava yiga sɨmogwindɨ. Tak Judas kɨta vat tɨna nyana. God wandɨ, kɨtamba Godna njɨvwa kwutɨna nyana. Tamba Godna waagan Devitna maawut ngwandɨndɨ maa Devit Sam walɨnja kwundi pɨlɨwutndɨ. Ndɨna ngay kwo lɨgiyandɨ. Nat nyan ana lɨgiyandɨ. Ndɨna njɨvwa klalaa nat nyan kwukiyandɨ waa pɨlɨwutndɨ Devit. Devit pɨlɨwutna vapmba tɨndɨ. Judas ndɨ avla vatnyandɨ ndɨna mbangɨ. Wan njɨmbla avla vasaselilaa ndaiga kɨpmamba viyandɨ maa ndɨna yaap mbɨlɨndɨ. Mbɨlɨndɨ maa ndɨna tɨgɨmbi kɨpmamba yindɨ. Jerusalemba lɨga nɨmba aywaa vɨga lɨndi. Ndina kwundimba wan kɨpmana sɨ Akeldama wandi. Yelogwen nda kɨpma. ");
INSERT INTO ian_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Wungi kat tɨga nɨnonala tɨgiyaa kɨta nyan vɨgiyanɨn. Wan nyan nɨnagwinala lɨga mbukiyandɨ. Njambwi nyan Jisas kiyalaa laatndɨ waa mbukiyandɨ. Jisas kɨpmamba ta njɨmbla nɨnagwinala ta nyan kat vɨgiyanɨn. Jon ngu yagulaa vat va nyan kat vɨgiyanɨn. Jisas nyɨnangwut wokea va nyan kat vɨgiyanɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita wandɨ maa vɨlɨlɨk palɨ kat vɨndi. Josep Basabas ndɨna nat sɨ Jastas nat nyan Mataias. ");
INSERT INTO ian_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Mbɨk laataa lɨmbik maa God kat wagalandɨ. Njambwi nyan mɨn ndinyanguna maawut aywaa vɨlɨgamɨn. Mbɨtna kɨta nyan kat vɨgiyamɨn. Judasna njɨvwa kwukiyandɨ. nɨnogwinala kɨta vat aposel tɨgiyandɨ. Judas kavle njɨvwa kwutndangat kavle kavat tamba yindɨ. Anda nyamba kwukiyanɨn waa nɨn kat sɨmaga waa wagalandi God kat. ");
INSERT INTO ian_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wagalandi maa Mataias kat ndina ngepma vapmba vɨlaa kwutndi. Kwutndi maa tamba vɨli kiyeli kɨta la nɨmbonala kɨta vat yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos walɨnja nandinya yandɨ maa Jisasna mbaapma nɨmba yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tɨga lɨga nɨma mwuk vla nyɨnangwupmba lɨga yaa kiyandɨ, wutndi. Wan mwuk ndalɨnja ngay wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nɨmbi ya vla vɨtɨndɨ, kɨta kɨta ndi kat yalɨndɨ, vɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Godna waagan yaa ndinamba tavindɨ maa ndi kapma kwundi ngambundi. Godna waagan ndina maawut ngwandɨndɨ maa ndɨnai waa nyaangɨt kapma kapma kwundimba ngambundi. ");
INSERT INTO ian_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wan njɨmbla nɨma sakwat Juda ngepma ngepmamba lɨga Juda yaa lɨndi. Wan Juda God kat yelavɨka lɨndi. Ndina angwa ngepma kwagalalaa Jerusalemat yiga tɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wundi nɨmba nɨma kak wutaa yaa yisondi. Yisolaa lɨga ngɨpaliga ndandi. Jisasna mbaapma nɨmba kapma kwundi ngambulɨndi maa wutndi. Ndi aywaa ndina angwa kwundimba ngambulɨndi maa wutndi. ");
INSERT INTO ian_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wutaa ngɨpaliga ndaga wandi. Wan nɨmba Galilina nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Manda vapmba nɨna kapma kapma angwa kwundimba wutɨganɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Patiamba la nɨmba, Midiamba la nɨmba, Ilamba la nɨmba wutɨndi. Mesopotemia, pontas, Esia, Frisia, pamfilia, Isip, Libiana nat ngepma Sairinimba la Juda ndi, ndina nat nɨmba Juda ana ndi. Juda yeta vapmba yetɨndi. Ndi wutɨndi. Kritmba la nɨmba, Arebiamba la nɨmba aywaa ndina angwa kwundimba God nɨma njɨvwa kwutnda njɨvwa kat wutɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ndi ngɨpaliga walaa tungwengwan yiga nat nɨmba awat sowat wagalandi. Kan mandana waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nat nɨmba njɨka wandi. Wan nɨmba nɨma ngu kɨlaa tungwengwan yiga ngambulɨndi maa njɨka wandi nat nɨmba. ");
INSERT INTO ian_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Njɨka wandi maa Pita nat tambavɨli kiyeli kɨta nɨmbonala tɨga laatndɨ. Laataa wandɨ. Ngwuk Judana nɨmba ngwuk Jerusalemba lɨga nɨmba ngwuk. Ngwuk kat kɨta nyaangɨt mbupmat tɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","wan nɨmba nɨma ngu kɨlaa ana tungwengwan yindi. Kan ngambi. Nɨna ngepmana vak nɨma ngu ana kɨlɨganɨn ngambimba. Vɨlɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Wan vɨlaa wukngwa vak tamba la profet Joel wan vak kat pɨlɨwutndɨ. God wandɨ. Yaiga njɨmbla wuna waagan kwigiyawun ndinyangu kat. kwiwun maa ngwula nondanyan taagwanyan wunai waa nyaangɨt mbukiyandi. Ngwula kwandɨ ndu mandɨt mandɨt nyaangɨt sɨmogwiweya vak vɨgiyandi. Ngwula avɨt ndu sɨmogwiweya sɨmak vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wuna njɨvwa kwutɨga nɨmba ndu lagwa ndi kat tavigiyaa waagan ndi kat kwigiyowun. Tavindɨ maa wunai waa nyaangɨt mbukiyandi. ");
INSERT INTO ian_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nyɨnangwupmba kwukweya nda kat vɨlaa ngɨpaliɨga ndaigandi. Kɨpmamba kwukweya nda kat vɨlaa ngɨpaliga walaa wan nda God kwutndɨ waa waigandi. wan kwukweya njɨmbla yelogwen, ya, yagɨmbi vɨgiyandi. ");
INSERT INTO ian_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tat nya kat wowun maa kulun waigandɨ. Mbak kat wowun maa yelogwen mbangɨ lɨgiyalɨ. ngɨni njambwi nyan yaiga nandinya vɨgiyandi. Yandeya nandinya nɨma nandinya. Yandeya nandinya vaakiyandi. ");
INSERT INTO ian_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wan nandinya kɨta nyan wun njambwi nyan kat wagalandeyan ndɨ kat kwunakiyowun waa wandi God waa pɨlɨwutndɨ Joel. ");
INSERT INTO ian_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","24","Ngwuk Isrelna nɨmba ngwuk. Ngambuweya nyaangɨt awuk ngwula. Ngwuk kat Nasaretmba la Jisas kat wowun. God wandɨ maa Jisas nɨma njɨvwa kwuka sɨmogwilɨga njɨvwa kwutndɨ. Ngwuk vɨga lɨgangwuk. Vɨlaa ndɨ Godna nyana waa yelavɨkngwuk. Kavle nɨmba Jisas kat vatnyanjangat kwutaa kalindi. yinjeya vak Jisas kat vatnyanjangat kwutaa kalindi. yinjeya vak kat tamba God vɨga lɨndɨ. God ndi kat vɨga ke sɨga waa ana wandɨ. Ngwuk kavle nɨmbat ndɨ kat vatnya wangwuk maa ndɨ kat kaalandi diwai krosmba. Jisas kiyandɨ, God wandɨ maa laatndɨ. Kiyalɨnja vat ndɨ kat ana kematndɨ. Ndɨ kiyalɨnja vak kat kwulatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devit ndɨno Jisas waa nyaangɨt pɨlɨwutndɨ. Njambwi nyan kat vɨlɨgowun. Njɨmbla njɨmbla wuna ngwaymba lɨgandɨ. Wun kat kwunapmak wuna yaagindan naangamba laataa lɨgandɨ. Tɨndangat ana nɨmamba yelavɨkiyowun. ");
INSERT INTO ian_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wungi kat tɨga solat sɨlɨgowun. Apma mbangu kwundi waga solat sɨlɨgowun. Kiyaga wundumbu yiweyan ana yelavɨkiywoun. Ngɨni kwo lɨgiyowun. Vɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","God wuna wundumbu kat ana kwagala lɨgiyandɨ wundumbuna ngepmamba lɨnda kat. God ana kwagala lɨgiyandɨ wuna sɨm waangumba njangu veindagat. Wun ndɨna apma nyan wun. ");
INSERT INTO ian_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Apma vat yetɨweya vak wun kat sɨmagamɨn. Mɨn kat vɨwangat solat sɨgiyowun waa Jisas wandɨ. waa pɨlɨwutndɨ Devit. ");
INSERT INTO ian_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yakwa nɨmba, ngwuk kat kɨta nda kat mbupmat tɨgowun. Ana pagwugiyowun. Ndɨ profetna Devit. Ndɨ avla ana pɨlɨwutndɨ. Ndɨ wundumbu yindɨ, waangumba taagandi, lɨgandɨ. Ndɨ kat taaganja kava vɨlɨganɨn. ");
INSERT INTO ian_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devit yaiga nat nyan kat pɨlɨwutndɨ. Tamba God Devit kat wandɨ. Mɨna yelangɨ nyan tɨma tɨkɨpmba ndaa mɨna njɨvwa kwupma njɨvwa kwukiyandɨ. Ana woseka wowun maa God wandɨ Devit kat. Devit wuka vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wungi kat tɨga Kraist kiyalaa laatndeya vak kat Devit pɨlɨwutndɨ. God Kraistna wundumbu ana kwagalandɨ wundumbuna ngepmamba tɨndangat. Ndɨna sɨm ana njangu veindɨ waangumba. ");
INSERT INTO ian_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","God wandɨ maa Jisas laatndɨ. Nɨna mbaapma nɨmba Jisas laatnda vat vɨnɨn. ");
INSERT INTO ian_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God wandɨ, Jisas nyɨnangwut wokelaa Godna yaaagindan naangamba ndalɨgandɨ. God Jisana sɨ kwusondɨ, yaagindan naangamba lɨgandɨ. Tak God Jisas kat wandɨ. Ndi kat wuna waagan kwigiyowun waa wandɨ God. Mbambala tamba kwindɨ. Vɨngwa vak wuka lɨngwa vat kɨngiyan. ");
INSERT INTO ian_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","God Jisas kat waa nyaangɨt Devit tamba pɨlɨwutndɨ. Wuna yaagindan naangamba ndalɨ. Ndalɨmɨn maa mɨn kat sɨvat tɨga nɨmba ndi kat kwulakiyowun mɨn kat tɨga. Kwulakwun maa ndi kat vɨga lɨgiyamɨn waa wandɨ God waa pɨlɨwutndɨ Devit. Ndɨ avla ana pɨlɨwutndɨ. Ndɨ nyɨnangwut ana wokendɨ. God ndɨnamba ana wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Wugi kat tɨga ngwuk Isrelna nɨmba kɨta nyaangɨt wutaayelavɨkiyangwuk. Ngwuk Jisas kat vatnyavat diwai krosmba kaalangwuk. God ndɨna sɨ kwusondɨ. God ndɨ kat wandɨ. Mɨn nɨma nyan mɨn. Mɨn wunai waa nyan mɨn Kraist mɨn waa wandɨ God waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita waa nyaangɨt kat wutaa ndina maawut viyalɨndɨ, pitaogwi nat aposel kat wagalandi. Yakwa nɨmba, nɨn angamak yigiyanɨn waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ndi kat wandɨ. Kupi maawut asɨk ngwula. Kupi maawut sɨtaa Jisas God waa nyana waa yelavɨtaa ngu yagu ngwula. God ngwutna kavle vat sɨlɨmbwigiyandɨ. God kwiya waagan klaigangwuk. ");
INSERT INTO ian_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tamba God ngwuk kat kwivat wandɨ. Ngwutna nyangu kat kwivat wandɨ. njambwi nyan God yagwa waiga nɨmba kat kwivat wandɨ waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita nat nɨma sakwat nyaangɨt mbutndɨ. Ndi kat wandɨ. Wan ngepmamba lɨga nɨmba apma maawut ana sɨka lɨgandi. Ndina sɨka lɨga maawupmba ke sɨka lɨga. Kupi maawut asɨk waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita waa nyaangɨt kwutaa la nɨmba aywaa ngu yagundi. Wan nandinya 3,000 nɨmba wan nyaangɨt kwutaa wungi mbaapmak wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kwutaa la nɨmba wumba lɨndi. Aposel ndi kat nɨma sakwat nyaangɨt mbutɨndi. Wan nɨmba yisolaa lɨga God kat apma nyan mɨn waa wandi. God kat kitamba yisolaa lɨga ngumbulɨndi, Jisas kiyanda vak kat yelavɨtaa yisolaa nao kalɨtaa kɨtamba kɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God ndi kat kwondu kwindɨ, aposel kwunatɨnja njɨvwa kwuka sɨmogwinja njɨvwa nɨma vat kwutɨndi. Nat nɨmba kwunatnɨja vak vɨlaa ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wan nyaangɨt wutaa kwutaa lɨga nɨmba kɨta vat yetɨndi. ndina nɨmbundawi kɨta vat aywaa kwutaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ndina kɨpma ndina nɨmbundawi nat nɨmba kat kwilaa sanya wenga klandi. Sanya awat sowat kwiga klandi. Kɨta nyan sanya lapman tɨndɨ mala ndɨ kat kwindi. ");
INSERT INTO ian_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nandinya nandinya Godna ngaymba yisolaa lɨndi. Ngay ngay yiga nao kɨtamba kɨlɨndi. Kɨga solat sɨga lɨndi. Waavi namwiya ndi. ");
INSERT INTO ian_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","God kat walɨndi. God mɨn nɨma nyanmɨn. Nat nɨmba ndi kat walɨndi. Wan nɨmba apma vat yetɨlɨgandi waa walɨndi. Nat nɨmba wan nyangɨt wutndi maa njambwi nyan ndi kat kwutaa ndɨna mbaapmamba taagandɨ maa mbaapmat wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","Man kavle yilaa lɨga nyan tɨndɨ. Nyɨme kwutɨ mala man kavle yilaa lɨndɨ. Nandinya nandinya ndɨ kat kwutaa mɨna yiga Godna ngay ndaamangemba taagalɨndi. Wan ndaamange ndɨna so lɨgandɨ. Apmana waa wandi. Wungi ndaamangemba lɨga yalɨga nɨmba kat sanyakat yawilɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kawilɨmbɨt maa yawi la nyan pitagwi Jon kat vɨlaa sanya kat yawindɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pitagwi Jono ndɨ kat vɨga wambɨt. Angat avɨ wambɨt. ");
INSERT INTO ian_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wambɨt maa mbɨk kat vɨga yelavɨtndɨ. Wun kat nɨma sanya kwigiyambɨt waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita ndɨ kat wandɨ. Wun sanya kai. Mandɨp ndamba kwigiyowun. Laataa alɨ mɨla wowun waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita walaga ndɨna yaagindan taambamba kwutaa katsondɨ. Katsondɨ maa ndɨna man tagula ngendɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kwiyatapman laataa man veindɨ. Mbɨtnonala Godna ngay wuleindɨ. Veiga pulaka wandɨ. God mɨn nɨma nyan mɨn waa Godna ngay wuleindɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Veiga pulaka wanda vat nɨma sakwat nɨmba vɨndi. ");
INSERT INTO ian_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ndɨ kat vɨga yelavɨtndi. An nyan ndaamangemba kwutaa kalindi, ndalɨndɨ. Ndɨ kat vɨga ngɨpaliga ndandi. ");
INSERT INTO ian_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pitaagwi Jon kat mbɨk kat kwagala vak kat kai walaa kwutaa lɨndɨ. Nat nɨma sakwat nɨmba pɨlɨga yaga yisolaa lɨndi wan kavamba. Godna ngayna nat waambu Solomona waambumba yisolaa lɨndi. Yisolaa lɨga yelavɨtndi. Kan mandana waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ndinyangu yandi, Pita ndi kat vɨlaa wandɨ. Ngwuk Isrel ngwuk. Manda kat ngɨpaliga ndangwuk. Ngwuk angat vɨlɨgangwuk. Ana maawupmba ana wali ndɨ kat laataa vei waa. Ana kwondumba ana wali laataa vei waa. ");
INSERT INTO ian_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Jisasna kwondumba wali maa laataa veindɨ. Tamba Ebraham, Aisak, Jekop God kat yelavɨtndi. Mbambala God Jisasna sɨ kwusondɨ. Ngwuk Jisas kwutaa kwingwuk mala Pailat kat Jisas kat ke kwagalaga. Barabas kat kwagalagiyamɨn waa wangwuk. Barabas nat nɨmba kat sɨlaa nyana. ");
INSERT INTO ian_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ngwuk apma vat yetɨlɨnja vat kwilɨga nyan kat vatnyangwuk. God wandɨ, laatndɨ. Nɨna mbaapma nɨmba vɨga lɨnɨn. ");
INSERT INTO ian_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jisasna kwondumba wan nyan kat an kwunakna. An nyan kwunatiya nyan Jisas kat ndɨna mbangɨ wiyo waavi taagandɨ. Wungi kat tɨga kwo lɨgandɨ. Ngwuk vɨga lɨgangwuk wan nyan kat. Jisas kat ndɨna mbangɨ wiyo waavi taagandɨ maa kwo lɨnda vak kat vɨga lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yakwa nɨmba Jisas kat vatnyangwa njɨmblambla Jisas God waa nyan tɨnda vat ana vɨngwuk. Ngwula njambwi nɨmba ndino ana vɨga lɨndi. Vɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kraist God waa nyan kiyagiyandɨ. Nat nɨma sakwat njɨvwa kwukiyandɨ waa tamba pɨlɨwutndi profet. God wandɨ maa pɨlɨwutndi. Pɨlɨwutnja nyaangɨtmba God wandɨ, Kraist njɨvwa kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wungi kat tɨga kupi maawut yelavɨk. God ngwutna kavle vat lɨmbwilaa ngwuk kat kwunaka apma vat yigiyandɨ. Ngwutnanala lɨga ngwuk kat kwunaka apma vat yigiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ngɨni God wandɨ, ndɨnai waa nyan Jisas ngwuk kat ngaga yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","God mbambala nyɨnangwupmba lɨga kawiga lɨgandɨ. Tamba Godna profetna maawut Godna waagan ngwandɨndɨ maa profet wandi. Wanja nyaangɨt tɨndi mala God ngaga yaigandɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses kupma wandɨ. Ngwutna kɨta nyan God wun kat waa vak vla ndɨ kat waigandɨ. Ngwuk kat mbutndeya nyaangɨt wuka kwutaa lɨgiyangwuk waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kɨta nyan ndɨnai waa nyaangɨt wutapman yindeyan ndɨ kat God sɨgiyandɨ. Godna nat nɨmbagwinala ana yetɨgiyandɨ. God ndɨ kat savɨlugiyandɨ waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tamba nat profet Samyuel kan nyaangɨt pɨlɨwutndɨ. Ndɨna kwupmba la profet nɨmbun kan nyaangɨt tɨgiyaa njɨmbla kat pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","26","Ngwutna walanga Ebraham kat God wandɨ. Mɨna yelangɨna kɨta nyan ngepma ngepmamba lɨgiyaa nɨmba kat kwunakiyandɨ waa wandɨ God. Ngwuk tamba la profetna walanga. Wungi kat tɨga wan apma vat ngwutno klaigangwuk yandɨ. God wandɨ, Jisas yalaa ngwuk kat kwunapmat tɨgandɨ. Ngwuk kat kwunatndɨ maa kavle vak yilɨngwa vak kwagalagiyangwuk. ");
INSERT INTO ian_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndi kat walɨmbɨt maa God kat kwunatɨga nɨmba Godna ngay vɨga lɨga nyan, Sadyusi walɨnja nɨmba mbɨk kat yalɨndi. ");
INSERT INTO ian_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ndi yalaa waliavat walɨndi. Ndinyangu kat Jisas kiyalaa laatndɨ wambangat waliavat walɨndi. ");
INSERT INTO ian_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wungi kat tɨga ndi kat kai walaa kwutaa kɨta kavamba pagwundi. Tamba ngana. Kinya ngambi kat kawiga lɨnjangat pagwundi. ");
INSERT INTO ian_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nat nɨma sakwat nɨmba wamba nyaangɨt wutaa maawupmba yelavɨka kwutaa lɨndi. Wan nyaangɨt wutna nɨmba wan mbaapma yiga wuleindi maa wan mbaapma nɨmbana sakwat 5,000 tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nat nandinya lɨndɨ maa ndina njambwi nɨmba ndina nɨma nɨmba, ndina nɨma saveo lɨga nɨmba Jerusalemba yisolaa lɨndi mbɨla nyaangɨt wupmak. ");
INSERT INTO ian_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","God kat kwunatɨga njambwi nyan Anas tɨndɨ. Kaifas, Jon, Aleksanda wupma lɨndi. Anasna yelangɨ nɨmba kɨta ka Wan nyan mbɨk kwunapmbɨk kwo lɨndɨ mala ndi ana wandi. ");
INSERT INTO ian_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mbɨk kat wandi. Wandi maa yaa ndinai la kavamba tolaa lɨmbɨt. Mbɨk kat wagalandi. Kana sɨmba kana kwonduba wan njɨvwa kwupmbɨk waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","10","Wagalandi maa Godna waagan Pitana mbangɨ tavindɨ maa Pita wandɨ ndi kat. Njambwi nɨmba, nɨma nɨmba, wawa vak awuk ngwula. Ngwuk nɨmba, nɨma nɨmba, wawa vak awuk ngwula. Ngwuk wan man kavle ya nyan kat kwunatiya vak kat angat wagalalɨgangwuk? Wan vak kat ngwuk kat mbukiyowun. Jisas Kraist Nasaretmba la nyana sɨmba ndɨ kat kwunati maa apma vat tɨgandɨ. Ndɨ kat vɨngwuk. Ngwut Jisas kat diwai krosmba kaalangwuk. God wandɨ maa kiyalaa laatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kraist kɨta kambak vla lɨndɨ waa tamba God waa nyaangɨt pɨlɨwutndi. Ngay kwutɨnja kambak vla lɨndɨ. Ngwut ngay kwutɨga nɨmba vla lɨgangwuk. Ndɨ kat ngwula kwukwa ngaymba mɨndama vla lɨnda kat taagandɨ waa tamba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nɨn kat kwunakiya nat nyan kai. Jisas mɨna kwunakiyandɨ. Wan kɨpamba lɨga nat nyan kai. Jisasna sɨmba mɨna nɨn kɨpmamba lɨga nɨmba kwo lɨgiyanɨn. God Jisas kat kwondu kwindɨ, kwunatɨgandɨ. Nat sɨ kai waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita wandɨ, wan njambwi nɨmba wutaa yelavɨtndi. Mbɨk wan mbɨk vɨlɨlɨk palɨ wan nyaangɨt mbupmak kat ana mbɨla mbangɨ wup yindɨ. Mbɨt skul ana yimbɨt. Mbɨt nɨna mbaama nyan ana mbɨt taa. Wungi kat tɨga mbɨk mbupmak kat mbɨla wup yilapman yindangat ngɨpalɨga ndandi. Ngɨpali walaa tɨga yelavɨtndi. Mbɨk vɨlɨlɨk palɨ Jisasnonala yetɨmbɨk. Wungi kat tɨga mbɨla mbangɨ ana wup yigandɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mbɨk kat ana wandi kavle vatna yimba waa. ");
INSERT INTO ian_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","18","Mbɨk kat wandi. Alaguat ay mbɨla waa wandi. Yimbɨt maa ndi kapma ngambuga lɨndi. Mbɨk kat angamak yigiyanɨn. Apma vat kwunatɨnja njɨvwa kwupmbɨk. Jerusalemba lɨga nɨmba aywaa vɨga wutndi. Mbɨk ndɨ kat ana kwunapmbɨk waa ana inaka waiganɨn. Nat nɨmba mbɨlat kwukwa njɨvwa wupmak kat kai wanɨn. Wundi kat tɨga mbɨk kat waiganɨn. Jisas waa nyaangɨt ke waa waigambɨt mbɨk kat waiganɨn waa ngambundi. Ngambuga lɨga wandi mbɨk kat. Yagwa waa wandi. Wuelimbɨt maa mbɨk kat wandi. Jisas waa nyaangɨt ke mbuka ke sɨmogwiga waa wandi mbɨk kat. ");
INSERT INTO ian_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wandi maa Pitagwi Jono wambɨk. Ngwuk kat kɨta nyaangɨk kat wagalvat wali. Anda vatna apma vat. Ngwutnai waiga nyaangɨpmba yetɨlɨiyeyan apma vatna? God waiga nyaangɨpmba yetɨliyeyan apma vatna? God waiga nyaangɨpmba yetɨlɨiyeyan apma vatna? Yelavɨk ngwula. ");
INSERT INTO ian_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwo ana walɨga. Vɨlia vat wutiya vak kat mɨna ndinyangu kat walɨgali waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Wambɨt ay mbɨla wandi. Mbɨk kat viyavat walɨndi. Ndi ana inaka viyaigandi. Nɨma sakwat nɨmba kavle man nyan kat kwunapmba vak kat vɨndi. Wungi kat tɨga viyavak kat vaatndi. Kwunapmba vak kat va nɨmba walɨndi. God nɨma nyana waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kwunapmba nyan mat nyan ana ndɨ. Tamba nɨma nyana. Ndɨna naambi ndumi vɨli lɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mbɨk kat kwagalandi maa mbɨtna mbaapma nɨmba kat yiga vɨmbɨt. God kat kwunatɨga njambwi nɨmba, ngepmana nɨma nɨmba, mbɨk kat waga nyaangɨt yɨga ndina mbaapma nɨmba kat mbupmbɨk. ");
INSERT INTO ian_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","30","Mbɨla mbaapma nɨmba wutaa God kat kɨtamba wandi. Njambwi nyan. Nyɨnangwut, kɨpma, nyɨngi ngu kwupmɨn. Yuvut yilɨga nda aywaa kwupmɨn. Tamba mɨna njɨvwa kwutɨga nyan nɨna walanga tɨndɨ. Tɨga Godna waagan ndɨna maawut ngwandɨndɨ mala wandɨ. Juda ana ndi nat nɨmba manda kat kao lɨgandi. Juda God kat kavle vat yigiyanɨn waa manda kat yelavɨtndi. God kat kavle vat yinjeya kwondu kai. Ngepma ngepmana njambwi nɨmba, nɨma nɨmba aywaa yisolaa God kat waliavak kat ngambulɨndi waa tamba wandɨ Devit. Woseka ana wandɨ. Wan ngepmamba Jerusalemba mɨnai wala nyan kat Jisas kat waliavat ngambulɨndi. Jisas mɨna njɨvwa kwutaa apma nyana. Pontias Pailat, Herot, Juda ana ndi nat nɨmba, Isrelna nɨmba aywaa Jisas kat vatnyavat yisolaa ngambulɨndi. Jisas kat yinja vak tamba vɨmɨn. Tak vɨmɨn. Ngɨni yindi. Mɨna maawupmba yindi. Njambwi nyan mbambala nɨn kat nɨma vat yivak yisolaa ngambulɨgandi. Nɨn kat wameyan mɨna nyaangɨt mbupmak kat ana wup yigiyanɨn. Nɨn kat kwondu kwimeyan nɨma sakwat njɨvwa kwunatna njɨvwa kwuta apma nyan Jisasna kwondumba kwukiyanɨn. Sɨmogwiya vat kwukiyanɨn waa wandi God kat. ");
INSERT INTO ian_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wandi maa ndinai la ngay yinaw vla kwutndɨ. Godna waagan yala ndina mbangɨmba tavindɨ. Tavindɨ maa God waa nyaangɨt ndina kwundi ana wup yindɨ. Mbutndi wan nyaangɨt. ");
INSERT INTO ian_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wan apma nyaangɨt wutaa kwutaa la nɨmba kɨta maawupmba yelavɨka yetɨndi. Ndina nɨmba nat nɨmba wan nda wuna nda ke kwuka waa ana walɨndi. Ndina kwanda kwanda kɨtamba aywaa kwutaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Njambwi nyan Jisas Kraist kiyalaa laatnda vat aposel nɨmamba mbutɨndi. God ndi kat apma vat yindɨ. ");
INSERT INTO ian_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ndina nat nɨmba kwanda kwanda lapman nɨmba ana lɨndi. Ngayo la nɨmba kɨpmao la nɨmba aywaa kwagalalaa sanya klandi. Klanja sanya aposelna mangandamba taagaga ndi kat kwindi. Aposel klalaga sanya lapman ta nɨmba kat kansaga kwilɨndi. ");
INSERT INTO ian_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ndɨ wan nyan Josep ndɨna angwa ngepma Saipras ndɨna yelangɨ Livai ndɨ wumba lɨndɨ. Ndɨna kɨpma kwagalalaa klanda sanya aposel kat kwindɨ. Aposel ndɨ kat mandɨt sɨ kwindi. Ndina kwundimba Banabas wandi. kwinja sɨnana angwa Nat nɨmba kat kwunata nyan. ");
INSERT INTO ian_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Nat kɨta nyan ndɨna sɨ Ananaias. Ndɨna taagwana sɨ Sapaira. Mbɨla kɨpma kat wenga klambɨt. Kan klalia wenga ana aywaa kwigiyaa. Nat kuvuk an klaigali waa yelavɨpmbɨk. Yelavɨpmbɨk maa nat kuvuk mɨna yiga aposelna mangandamba taagaga ndi kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kwindɨ maa Pita ndɨ kat wagalandɨ. Seten mɨna maawut ngwandɨndɨ maa kɨpma kat klama wenga nat kuvuk klamɨn. Klamangat Godna waagan kat woseka wamɨn. Manda kat waa wagalandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pita Ananaias kat wandɨ. Tak wenga ana klamɨn mɨna kɨpma kan tɨga. Wenga klalaa kwimeyan mɨna sɨpana. Manda kat yelavɨtaa wan vak mɨna maawutmba yimɨn. Ndinyangu kat mɨna ana woseka wamɨn. God kat woseka wamɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita waa nyaangɨt wutaa Ananaias ngayapmba ndalaa kiyandɨ. Kiyanda vat va nɨmba vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kwandɨ nɨmba yalaa waavwi mbataa kwutaa walalaa kaliga yiga waangumba taagandi. ");
INSERT INTO ian_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Samat tɨga ndɨna taagwa yalɨ. Lɨla lan kat ana vɨlɨ waangumba taaganja vat. ");
INSERT INTO ian_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yalɨ maa Pita lɨ kat wagalandɨ. Kɨpma kat klamba wenga nyɨna lan aywaa nɨn kat kwindɨ? Waa wagalandɨ Pita. Wagalandɨ, awa waa woseka walɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita lɨ kat wagalandɨ. Manda kat njambwi nyana waagan kat yelavɨpmbɨk. Yiliya vat vigiyandɨ? E? Ana vɨgiyandɨ? Waa yelavɨpmbɨk waa wandɨ Pita. Awut nyɨla. Nyɨna lan kat waangumba taaga nɨmba ndaamangemba yalaa nyɨn kat kwutaa kalivat yalaa lɨgandi waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wandɨ ma ndɨna mangangɨmba ndalaa kiyalɨ. kwandɨ nɨmba yalaa kiyalangat vlɨlaa lɨ kat kwutaa kalɨndi. Yiga lɨla lan tɨga waangu waymba taagandi. ");
INSERT INTO ian_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Godna yelagɨmba lɨga nɨmba wan vak wutaa ngɨpalɨiga ndalaa vaaka lɨndi. Nat nɨmba nɨmbun. Ngɨpaliga ndalaa vaaka lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wundi aposel nɨma sakwat nɨmba kat kwunaka nɨma njɨvwa kwutɨga nɨmba ndi. Kwutɨnja njɨvwa nɨma sakwat nɨmba vɨndi. Jisasna mbaapma nɨmba Godna ngay kɨta nandinya nandinya yisolaa lɨndi. Solomona kavamba. ");
INSERT INTO ian_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nat nɨmba ndinogwinala ana yisolaa lɨndi. Nat nɨmba kapma kavamba lɨga walɨndi. Wan nɨmba apma vat yetɨlɨgandi waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nɨma sakwat nɨmba ndu lagwa wan nyaangɨt wutaa maawupmba yelavɨka njambwi nyana mbaapma wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wungi kat tɨga yelogwenga ta nɨmba kat kwutaa ava yambɨ waymba taagandi. Nat nɨmba kat njambamba taagandi. Nat nɨmba kat matmba taagandi, lɨndi. Wupma yelavɨtndi. Pita yandɨ, ndɨna kait ndi kat kapmandeyan kwo lɨgiyandi waa yelavɨka lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem ngwaymba lɨga ngepmana nɨma sakwat nɨmba yelogwenga tɨga nɨmba kat kwutaa kiyandi. Nat kavle nɨmba kavle waagan wuleiga la nɨmba kat kiyandi. Kiyandi maa ndi kat aposel aywa kwunatndi. ");
INSERT INTO ian_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wungi kat tɨga God kat kwunatɨga njambwi nɨmba laataa yandi. ndinagwinala sadyusi walɨnja mbaapma nɨmba laataa yandi. Aposel kwutaa njivwa wuka yilavɨtndi. Aposel waa nyaangɨt wuka lɨndi. Ngɨni nɨnai waiga nyaangɨt ana wukiyandi waa yelvɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Laataa yalaa aposel kat kwutaa kavle kalambusmba taagandi. ");
INSERT INTO ian_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Kalambusmba taagandi mala Godna ensel yalaa kalabusna ndaamangena ndua lavwindɨ, wogwendi. Wogwendi mala ndi kat ensel wandi. Ngwut Godna ngayat ay. Apma vat kwo yetɨnjeya vak kat ndi kat ambuk ngwula waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ensel waa nyaangɨt wutaa ngambi ngleimba Godna ngay wuleilaa mbutndi wan nyaangɨt. Mbutɨndi maa God kat kwunatɨga njambwi nɨmbo ndinagwinana lɨga nɨmbo Isrelna nɨma nɨmba njambwi nɨmba kat yagwa wandi. Yagwa yisolaa lɨkat waa walɨndi. yisolaa lɨndi maa plisman kat wandi mala yindi aposel kat kwutaa kiyavat. ");
INSERT INTO ian_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Plisman kalabus yilaa ndi kat vɨga vɨlevilaa yandi. yalaa njambwi nɨmba kat mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Mbuka wandi, kalabus yiga vɨnɨn wovun tɨndɨ. Ndua kwo lɨndɨ. kalabus kat vɨga la nyan nduamba laataa lɨndɨ. Wan ngaymba ndinyangu ana lɨndi waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Godna ngay vɨga lɨga nyan God kat kwunatɨga njambwi nɨmba mbutnja nyaangɨt wutaa gɨpaliga ndalaa vaaka lɨndi. Vaaka lɨga yelavɨtndi. Mandana yilɨmba waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tɨga lɨga kɨta nyan ndi kat yalaa wandɨ. Kalabusmba taagangwa nɨmba Godna ngamba tɨga ndinyangu kat mbutɨgandi waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Plisna njambwinɨmbagwi nat plismano yiga ndi kat kwutaa kiyandi. Ndi kat ana viyaga kiyandi. Yigumba kiyandi. Plisman yelavɨtndi. Viyaga kiyaneyan ndinyangu nɨn kat waliaga kambak klalaa yaagiga nɨn kat vatnyagiyandi waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ndi kat kiyandi maa njambwi nɨmbana mɨndama sambɨmba laataa lɨndi. God kat kwunatɨga njambwi nyan ndi kat wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tak jisas waa nyaangɨt ke mbuka waa ngwuk kat wanɨn. Nɨnai waa nyaangɨk kat walaa Jerusalemba la nyangu kat aywa mbukngwuk waa wandɨ njambwi nyan. ");
INSERT INTO ian_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wandɨ maa Pitagwi nat aposel ndi kat wandi. God waa nyaangɨt wuka lɨganɨn. Ndinyangu waa nyaangɨt kapma vat tɨndeyan ana wuka lɨganɨn. ");
INSERT INTO ian_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nɨna walangana njambwi nyan God wandɨ mala Jisas kiyalaa laatndɨ. ngwuk ndɨ kat vatnyangwuk. Ngwuk diwai krosmba kaalangwuk. ");
INSERT INTO ian_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God ndɨna sɨ kwusondɨ. God Jisas kat wandɨ. Mɨn wuna nyan mɨn. God Jisasna sɨ kwusondɨ, yaagindan naangamba lɨgandɨ. Kiyangat tɨga nat nɨmba kat kwunakiyamɨn waa wandɨ God Isrelna nɨmba kat kupi maawut sɨknjangat God Jisas kat wandɨ. Ngwula kavle vat lɨmbwivat tɨgandɨ waa Jisas kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nɨn wan vak vɨnɨn. Godna waagan nɨmbun vɨndɨ. God waa nyaangɨpmba yetɨlɨga nɨmba kat God ndɨna waagan kwindɨ waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ndɨnai waa nyaangɨt wutaa ndina maawut kimbuk yiga lɨndi. Aposel kat vatnyavat wandi. ");
INSERT INTO ian_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tɨga lɨga njambwi nɨmbana kɨta nyan ndɨna sɨ Gameliel laatndɨ. Ndɨ Ferisi walɨnja mbaapma nyana. Ndɨ nambuo lɨga nyana. Nɨma sakwat nɨmba ndɨ kat walɨgandi. Ndɨ apma nyana. Ndɨ laataa wandɨ. Wangwuk mala alaguat wogwegandi. ");
INSERT INTO ian_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wogwendi maa wandɨ. Ksrelna nimba ngwuk. Ndi kat yigweya vak kat yelavɨk. ");
INSERT INTO ian_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tak samat kɨta nyan laatndɨ waa wandɨ. 400nɨmba ndɨna mbaapma wuleindi. Tɨga lɨga nat nɨmba ndɨ kat vatnyandi maa ndɨna mbaapma nɨmba ndɨ kat vatnyandi maa ndɨna mbaapma nɨmba pɨlɨ waa vaaka yindi. Ndɨna vak kwo vala tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ndɨna kwupmba nat nyan laatndɨ. Ndɨna sɨ Judas. Ndɨna ngepma Galili. Takis klalɨnja njɨmblamba laatndɨ. Ndɨ nɨma sakwat nɨmba kwutndɨ, ndɨna kwupmba yindi. Ndɨ kiyandɨ maa ndɨna mbaapma nɨmba pɨlɨ waa yindi. ");
INSERT INTO ian_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Mbamala ngwuk kat waigowun. Wan nɨmba ke sɨga. Ndi kat kwagala. Ndi ndu waa nyaagɨpmba yetɨnjeyan ndina vat kwo vatnat tɨgiyandɨ. God waa nvaangɨpmba yetɨnjeyan ndi kat ana kwulakiyangwuk. Ndi kat kwulapmat yingweyan God kat waliagiyangwuk waa wandɨ Gameliel. ");
INSERT INTO ian_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wandɨ maa wandi. Wovun wamɨn. Apma nyaangɨtna wama waa wandi. Wungi kat tɨga aposel kat kiyalaa viyaga ndi kat wandi. Jisasna sɨmba ke mbuka waa wandi. Ay ngwula wandi. ");
INSERT INTO ian_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yisolaa la njambwi nɨmba kat kwagalalaa yindi. Ndi solat sɨga wandi. Jisas waa nyaangɨt wanangat nɨn kat viyanja vat kavle vat ana ndɨ. ");
INSERT INTO ian_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nandinya nandinya Godna ngaymba ndinyanguna ngaymba yiga mbuka vɨsɨnogwindi. Ndi mbutndi. Jisas God waa nyana waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kan njɨmbla Jisasna mbaapma nɨma sakwat yindi. Grik walɨnja kwundi ngambulɨga Juda Hibru walɨnja kwundi ngambulɨga Juda kat waliaat tɨndi. Waliaga lɨga wandi. Nɨna ngepmana tolagwa kat kɨgɨnda ana yigumba kansaga kwilɨgandi waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wungi kat tɨga wan tamba vɨli kiyeli vɨlɨlɨk nɨmba wandi, mbaapma nɨmba aywaa yisolaa lɨndi. Wan tamba vɨli kiyeli vɨlɨlɨk nɨmba ndi kat wandi. God waa nyaangɨk kat mbutɨna njɨvwa kwagalalaa kɨgɨnda mɨna nyaangɨk kat mbutɨna njɨvwa kwagalalaa kɨgɨnda mɨna kansaga kwineyan ana nglaatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yakwa nɨmba ngwuk ngwulayɨ sɨlavɨli nyangu Godna waagan ndina maawupmba lɨndɨ. Wundi nyangu pavu wuka lɨga nyanguvla lɨgandi. Ngwuk tamba wundi nyangu kat wangwuk ndinayɨ kɨgɨnda kwigiyaa. ");
INSERT INTO ian_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nɨn nɨna njɨvwamba lɨgiyanɨn. God kat ngambuga ndinyangu kat God waa nyaangɨt mbuka lɨgiyanɨn wa wandi wundi tambavɨli kiyeli vɨlɨlɨk nyangu. ");
INSERT INTO ian_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wanja nyaangɨk kat wutaa wandi. Apma nyaangɨtna wandi. Ndinyangu sɨla vlɨi kat vɨlaa kwutndi. Nat nyan Stiven kat vɨlaa kwutndi. Ndɨ God waa nyaangɨt nɨmamba kwutaa lɨndi. Godna waagan ndɨna maawupmba ngwandɨlaa lɨndɨ. Nat nɨmba Filip, Prokoras, Naikena, Taimon, Pamenas, Nikolas. Nikolasna angwa ngepma Antiok. Tak Juda ana lɨndɨ. Judana mbaapmamba yaa lɨndɨ Nikolas. ");
INSERT INTO ian_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sɨlavɨli nyangu kat kwutaa aposel kat sɨmagwindi. Aposel God kat ngambulaa ndina taamba sɨlavɨli nganguna naambumba taagandi. ");
INSERT INTO ian_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","God waa nyaangɨt nɨmamba mbutɨndi. Jisasna mbaapma nɨmba Jerusalema ta nɨmba nɨma sakwat yɨndi. God kat kwunatɨga nɨma sakwat nɨmba wan nyaangɨt wutaa maawupmba kwutaa ndina mbaapma wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God Stiven kat apma vat yindɨ, kwondu mbundɨ lɨgandɨ. Ndinyangu kat nɨma vat kwunatnda vat kwutaa lɨndɨ. Sɨmogwinda vat aywaa vɨndi. ");
INSERT INTO ian_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nat Juda Stiven kat vɨlaa waliavat laatndi. Wan Judana walanga nat ngepma nɨmba yalaa ndi kat kandi kwutaa kalindi. Ndina angwa ngepma kɨngiyan. Sairini, Aleksandria, Silisia, Esia. Wan nɨmba kɨta Judana ngaymba yisolaa lɨlɨndi. Ndi Stiven kat waliavat tɨndi. ");
INSERT INTO ian_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stiven kat yisolaa lɨga kaawa viyaa ngambulɨndi. Godna waagan Stivena maawut ngwandɨndɨ maa ndɨ apma nyaangɨt ngambulɨndɨ mala ndɨ kat ana inaka kwulakiyandi. ");
INSERT INTO ian_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wungi kat tɨga woseka waa nɨmba kat yiga kwutaa mɨna kiyalɨndi. Woseka waa nɨmba wandi. Stiven Mosesna sɨ kat viyesanda lɨgandɨ. Godna sɨ kat viyesanda lɨga waa woseka wandi. ");
INSERT INTO ian_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Woseka wanja nyaangɨt njambwi nɨmba kat Judana lo vɨga lɨga nambuo lɨga nɨmba kat yiga mbutndi. Mbutndi mala ndɨ kat kwutaa kiyandi. Ndɨ kat kotndangat kwutaa kiyandi. ");
INSERT INTO ian_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Stiven kat waliavat nɨmba nat nɨmba kat wandi. Ndɨ kat woseka waigangwut wandi, woseka wandi. Ndɨ kat woseka waigangwut wandi, woseka wandi. Wan ngay Godna ngay kavle ngaya. God kwiya lo kavle loa waa wandɨ Stiven waa wosek wandi. ");
INSERT INTO ian_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jisas Nasaretna nyan wan ngay wulɨgiyandɨ. Moses nɨna walanga kat kwiya ngepma vat wokwigiyandɨ waa Stiven wandɨ waa woseka wandi. Nɨn wunɨn waa woseka wandi. ");
INSERT INTO ian_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wan ngepmana njambwi nɨmba ndaa lɨga Stiven kat vɨga lɨndi. Ndɨna mɨndama apma mɨndama enselna mɨndama vla lɨgandɨ waa vɨga yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","God kat kwunatɨga njambwi nyan laataa Stiven kat wagalandɨ. Waa nɨmba woseka wandi? E? Waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wandɨ maa stiven wandɨ. yakwa nɨmba njambwi nɨmba awuk ngbwual. God ndɨna kwondu sɨmagaga nɨna walanga Ebraham kat ngambuvat yandɨ. Ebraham Mosespotemiamba yetɨndɨ. Angwa ngepma kwagalalaa Heran walɨnja ngepmat yetɨlapman lɨnda njɨmbla God ndɨ kat ngambuvat yandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God ndɨ kat yalaa wandɨ. Mɨna angwa ngepma mɨna yelangɨ nɨmba kat kwagalalaa nat ngepmat ay. Yiga tɨmeya kava sɨmagagiyowun waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ebraham Kaldia ta ngepma kwagalalaa Heran walɨnja ngepmat yindɨ. Ngi ngepmamba yiga yetɨndɨ maa ndɨna nyaek kiyandɨ. God wandɨ, Heran kwagalalaa mbambala yeltɨlɨna kavat Ebraham yindɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God kan kɨpma Ebraham kat ana kwindɨ. Ana samat kɨpma kwindɨ. God kɨpma kat wupma wandɨ. mɨna nyangu wan kɨpma kat vɨga lɨgiyandi waa God wandɨ. Wan njɨmbla Ebraham nyangu njan tapman tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","7","Samat tɨga God Ebraham kat wandɨ. Mɨna nyangu sɨvla mbundɨ kavat yigyandi. Wan sɨvla ngepmamba lɨga nɨmba ndi kat vɨga lɨgiyandi mɨna nyangu kat. Mɨna nyangu wan ngepma nɨmbana njɨvwa kwo kwukiyandi. Wan ngepma nɨmba mɨna nyangu kat kavle vat yigiyandi. Wan kavle ngepma naambi 400 yetɨgiyandi. Wan ngepmana nɨmba kat sɨgiywoun. Ndi kat sɨwun maa mɨna nyangu wan ngepma kwagalalaa wuna njɨvwa kwuka wun kat yelavɨpmak yigiyandi waa wandɨ God. Nɨna walanga wan kava kwagalalaa tɨna ngepmat yindi, tɨganɨn. ");
INSERT INTO ian_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mbangɨ pɨtna vak God Ebraham kat sɨmagandɨ. Mbangɨ pɨtnja vak nat nɨmba vɨlaa yelavɨkiyandi. Ndi Godna nɨmba ndi waa yealvɨkiyandi. Tɨga lɨga Aisak Jekop kat njandɨ. Jekop wan tamba vɨli kiyeli vɨlɨlɨk njanda nɨmba kapma kapma yelangɨ nɨmba ndi. ");
INSERT INTO ian_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wan tamba vɨli kiyeli vɨlɨlɨk ta nɨmba Josep kat tɨpmwigwula yiga kimbut yiga maawupmba yelavɨka lɨndi. Isipmba lɨga nɨmba kat kwilaa wenga klandi Josep kat. God ndɨnagwinala kɨta vat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nɨma sakwat nglambi yiga Josep kat ngivat vɨlɨndɨ. God kwutaa lɨga ndɨna lak kwandɨ. Wungi kat tɨga wan nglambi ana ndɨ kat ngindɨ. God ndɨna lak kwandangat Isipna njambwi nyan Fero Josep kat wandɨ. Mɨn apma nyan mɨn. Nambuo lɨga nyan mɨn waa wandɨ Fero. Wungi kat tɨga fero wandɨ maa Josep njambwi nyanat tɨndɨ. Isip kat vɨga Ferona ngayna nda kat vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","12","Isipagwi Kenano ndina ambugavana nda yigumba ana waatndɨ. Nɨma vat yandɨ. Nɨna walanga kɨgɨnda sakwat kɨgɨnda lɨgandɨ waa wutaa wandɨ. Nɨna walanga kat wandɨ. Ay ngwula. Isipmba kɨgɨnda yiga kla ngwula. ");
INSERT INTO ian_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nat njambɨ Isip yindi kɨgɨnda klavat. Vɨlɨlɨk wan njambɨ Josep ndi kat avla visɨmogwindɨ tɨga vak. Wunai ya waa wandɨ Josep ndɨna yakwa nɨmba kat. Vɨlɨlɨk wan njambɨ Fero Josepna yakwa nɨmba kat vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep kɨta nyan kat ay wandɨ maa yiga Jekop kat mbutndɨ. Yagwa waa mbutndɨ. Josepna yelangɨ nɨmba kat ngwutno yagwa ngwula waa mbutndɨ. Isip ya nɨmbana sakwat kɨngiyan. Ndumi kuvuk kiyeli tamba vɨli manjela tambanat nɨmba yindi. ");
INSERT INTO ian_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekop Isip yilaa tɨga wumba lɨga ndɨno kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kiyandɨ maa ndɨna sɨm kwutaa Sikem walɨnja kɨpmat kalilaa waangumba vaangundi. Wan kɨpma tamba Ebraham Hemo kat wenga kwilaa ndɨna lak klandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tamba God Ebraham kat wandɨ. Mɨna nyangu Isipmba lɨga naambi 400 tɨga lɨga kwagalalaa nat ngepmat yigiyandi waa wandɨ God. Yinjeya njɨmbla tamba ngwaymba lɨndɨ. Wan njɨmbla nɨma sakwat nɨmba lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wan njɨmbla mandɨt king Iɨipmba tɨndɨ. Apma vat Josep ya vat wan king ana wutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wungi kat tɨga nɨna walanga kat kavle vat yindɨ. Ndi kat wandɨ. Ngwutna nyangu vatnyanjangat wuna lak sɨmaga waa wandɨ. Vatnyanjeyan ndi nɨma sakwat ana yigiyandi waa yelavɨtaa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wan njɨmbla Moses kat nyɨme kwutɨ. Kan apma mat nyana. Nyaetna ngaymba tɨga lɨga mbak kuvuk mwunya kɨga lɨndɨ nyɨmeanala. ");
INSERT INTO ian_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ndɨna nyaek nyɨme ndɨ kat yiga sɨmagambɨt maa Ferona taagwa nyan ndɨ kat yiga sɨmagambɨt maa ferona taagwa nyan ndɨ kat vɨlaa kwutaa kalilɨ. Lɨla nyan vla lɨndɨ. Ndɨ kat vɨga kwunaka lɨlɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses Isipna nɨmba vɨga la apma vak aywaa vɨga kɨndɨ. Apma tagula nyana. Apma vat ngambulɨga nyana. Apma vat njɨvwa kwutɨga nyana. ");
INSERT INTO ian_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosesna naambi ndumi vlɨi lɨga yelavɨtndɨ. Wuna yakwa nɨmba Isrel walɨnja nɨmba kat yiga vɨgiyowun waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isipna kɨta nyan ndɨna yakwa nyan kat kavle vat yelɨndɨ yiga vɨndɨ. Ndɨna yakwa nyan kat vɨlaa miwa yilaa Isipa kɨta nyan kat viyaga vatnyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses yelavɨtndɨ. Wuna yakwa nɨmba yuwa vak vilaa waigandi. God wandɨ, Moses nɨn kat kunapmat yandɨ. Nɨna lak kwandɨ maa Isip kat kwulakiyanɨn waa waigandi waa yelavɨtndɨ Moses. Wupma yelavɨtnda vapmba ndi ana wandi. ");
INSERT INTO ian_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nat nandiya ndɨna yakwa nyan vɨlɨlɨk walea lɨmbɨk. Mbɨk kat yalaa vɨlaa wandɨ. Mbɨk kat kɨmbɨk kwupmat. Mbɨk yakwa nyan mbɨt. Manda kat walea lɨgambɨt waa wandɨ Moses. ");
INSERT INTO ian_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wandɨ, walea la kɨta nyan Moses kat kwutaa kumbanjaguga wandɨ. Kanda wandɨ maa mɨn nɨna njambwi nyanat tɨgamɨn. Mɨn kat kanda wandɨ maa waigamɨn. Wan kavle vatna. Nat vat apma vatna waa waigamɨn. ");
INSERT INTO ian_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Napmba Isipna kɨta nyan kat vatnyama vla an kat vatnyagiyamɨn? Waa Moses kat wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wandɨ maa Moses vaaka pɨlɨga yiga Midian walɨnja ngepmamba yetɨndɨ. Tɨga lɨga nondanyan vɨlɨlɨk njandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Wumba naambi ndumi vlɨi mɨna lɨndɨ. Tɨga lɨga ensel vɨndɨ. Moses kwo nɨndɨ kavamba lɨga vɨndɨ. Wan kava Sainai walɨnja nduwi waymba lɨndɨ. Mat mbangu mingemba ya vɨtɨdndɨ, Moses vɨndɨ. Wan yamba ensel tɨndɨ maa vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses vɨga ngɨpali waa vatndɨ. Vɨvat way yilɨndɨ. Yiga lɨga Godna kwundi wutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","God ndɨ kat wandɨ. Wan nɨna walanga wun kat nɨna njambwi nyan mɨn waa walɨndi Ebrahma, Aisak, Jekop wun kat nɨna njambwi nyan mɨn waa walɨndi waa God ngambulɨndɨ maa Moses ava plaa lɨndɨ. Moses vɨlaa vaaka sɨlandalaa tɨndɨ. Ana taambɨka vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","God ndɨ kat wandɨ. Mɨna man su pɨgiyaka laaga. Wan tɨma kava wunai lɨga apma kava. ");
INSERT INTO ian_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wan Isipmba lɨga nɨmba wuna nyangyu kat kavle vat yilɨnja vat vɨwun. Isrel walɨndi. Isip nɨn kat kavle vat yilɨgandi waa walɨndi wutwun. Wungi kat tɨga ndi kat kwunapmak ngaga yawun waa wandɨ God. God Moses kat wandɨ. Yagwamba mɨn. Mɨn kat wowun. Isip yigiyamɨn waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tak Moses yakwa nɨmba ndɨ kat wandi. Kanda wandɨ maa mɨn nɨna njambwi nyanat tɨgamɨn. Mɨn kat kanda wandɨ maa wagamɨn. Wan vat kavle vatna. Nat vak apma vatna waa waigamɨn God ndɨ kat wandɨ. Ay yiga ndi kat vɨga lɨgiyamɨn. Yiga ndina lak kwamɨn, Isip kat kwulaiyandi waa wandɨ God. Ensel kat ya vɨtɨga mimba vɨnda njɨmbla God ndɨ kat wupma wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ndi kat kwutaa Isip kwagalalaa walindɨ. Isipmba Moses nɨma sakwat nɨma njɨvwa God waa vapmba kwutndɨ, ndina ngepma kavle yindɨ. Yelogwen walɨnja sak Mosesna vasɨ vasɨmba viyandɨ vlɨi yi ya yetɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wan nyan Moses Isrel kat wandɨ. Ngɨni God ngwutna kɨta nyan kat wandɨ, profet tɨgiyandɨ. Wunai lɨga vla lɨgiyandɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wan nyan Moses Godna nɨmbanala kwo nɨndɨ kavamba yetɨndɨ. Nɨna walanganala yetɨndɨ. God waa nyaangɨt mbutɨga ensel Sainai walɨnja nduwimba Moses kat mbutndɨ. Ngi nduwimba wan ensel God waa nyaangɨt Moses kat kwindɨ maa ndɨ nɨn kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nɨna walanga Moses waa nyaangɨt ana wuka lɨndi. Ndɨna kwundi kat wupmakat kai walaa Isipmba yetɨvak kat mɨna yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tak yetɨnja vak kat yelavɨtaa Eron kat wandi. Nɨn kat waagan kait nɨma sakwat agwut waa wandi. Ndinai waiga nyaangɨt wukiyanɨn. Wan nyan Moses nɨn kat kwutaa nyan nduwi tamba wokendɨ. Anagandɨ yaiga waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wungi kat tɨga nyan bulmakauna kait Eron ndi kat kwutndɨ. Kɨta nda vatnyalaa kaik kat kwunapmak kwindi. Yilɨnja vak vɨga nolin ngwandɨga solat sɨga mbangu veilɨndi. ");
INSERT INTO ian_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","43","Ndina kavle vat God vɨlaa wandɨ. Ndɨ kat kwagalawun maa kavle maawut yelavɨkiyandi. ndina kavle vapmba yetɨgiyandi waa wandɨ God. Wungi kat tɨga nyɨnangwupmba lɨga nda kat kwunatndi. Nya, mbak sɨngwut kwunatndi. Tamba yetɨnja vak kat profet pɨlɨwitndɨ. God wandɨ. Ngwuk Isrel wun kat yelavɨtaa kɨta nda vatnyalaa ana wun kat kwilɨngwuk. Naambi ndumi vɨlɨlɨk kwo kavamba tɨngwa njɨmbla wun kat ana kwilɨngwuk. Molok walɨnja waagana kait kwutaa kaliga ndɨ kat mɨna kwunatɨngwuk. Refan walɨnja sɨngwut mɨna kwunakngwuk. Wungi kat tɨga wowun mala nat ngepma nɨmba ngwuk kat kandi kwutaa kaligiyandi ndina ngepmat. Babilon walɨnja ngepmat kaligiyandi waa wandɨ God waa tamba pɨlɨwutndɨ profet. ");
INSERT INTO ian_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kwo nɨndi kavamba nɨna walanga tɨnja njɨmblamba selmba kwutnja ngaymba Godnonala yisola lɨndi. Moses kat God wandɨ wan ngay kupma agwut. God waa vapmba wan ngay Moses kwuka taandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nɨna walanga wan selmba kwutnja ngay kwutaa nɨnai ta kavat kiyandi. Josua ndina njambwi nyanat tɨga yandi. Wan kava nɨnai la kava God ndi kat kwindɨ. Wan kavamba tamba la nɨmba kat God kai waa savɨlɨndɨ, yɨndi. Devɨt ta njɨmbla selmba kwutnja ngay tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God Devit kat yelavɨtndɨ. Mɨn apma nyan mɨn waa yelavɨtndɨ. Devit God kat wagalandɨ. Mɨn nɨna njambwi nyan mɨn. Tɨmeya ngay kwukiyowun? Waa wagalandɨ, God kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Devitna nyan Solomon wan ngay kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ndinyangu kwutna ngaymba God njambwi nyan ana tɨlɨgandɨ. Tamba profet wan vak pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","God nyɨnangwutnagwi kɨpma kat vɨga lɨnda vak kat wandɨ. nyɨnangwut wuna tɨgɨt vla tɨgandɨ. Ndaa lɨlɨgowun. Kɨpmamba man veilaa tɨlɨgowun. Wun kat anda ngaya kwukngweya. Wun anda ngaymba tɨgiyowun. ");
INSERT INTO ian_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kɨpmana nda aywaa kwukwun waa wandɨ God waa tamba pɨlɨwutndɨ profet. ");
INSERT INTO ian_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ngwuk kavle vapmba yetɨlɨgangwuk. God waa nyaangɨt ngwutna maawutmba ana yelavɨtɨgangwuk. Ngwutna waan God waa nyaangɨt ana wutɨgangwuk. Godna waagan kat kai walɨgangwuk. Ngwutna walanga kavle vat yiga yetɨnja vapmba ngwula yetɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ngwutna walanga profet kat kavle vat mɨna yɨndi. Tamba la nɨmba God waa apma nyan yaigandɨ waa la nɨmba kat ngwutna walanga vatnya lɨndi. Mbambala ngwuk Jisas kat kamwin kwingwut maa vatnyandi. ");
INSERT INTO ian_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God ndɨna lo ensel kat kwindɨ maa ensel Moses kat kwindɨ. Moses ngwutnalak kwindɨ maa ngwuk wungi lomba ana yetɨngwuk waa wandɨ Stiven. ");
INSERT INTO ian_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wan nyaangɨt wutaga nambu mbɨlɨga ndaiga ndina maawut kwutndɨ maa nɨmbi ngliaka kimbut yiga lɨndi Stiven kat. ");
INSERT INTO ian_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stiven kat Godna waagan tavindɨ maa ndɨ nyɨnangwut kembandɨ, vɨga God kat vɨndɨ. God nɨma nyan tɨndangat nɨma ya vla lɨndɨ, vɨndɨ. Stiven Jisas Godna yaagidan naangamba laataa lɨndɨ, vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Vɨlaa wandɨ ndi kat. Avɨ ngwula. Nyɨnangwut kembandɨ, Jisas Godna vaksɨmobwi lɨgan nyan ndɨ kat vɨwun. Godna yaagindan naangamba laataa lɨndɨ, vɨgowun waa wandɨ Stiven. ");
INSERT INTO ian_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wan maa nɨma kwundimba ndɨ kat kwuseset yiga wandi. Waan sɨlɨtaa aywaa laataa ndɨ kat kwupmak yɨndi. ");
INSERT INTO ian_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ndɨ kat kwutaa kaliga yiga ngepma maapomba taagalaa ndɨ kat kaambapmba kalalaa vatnyavak viyalɨndi. Stiven waa nyaangɨk kat wuka kai waa la nɨmba tat kambak klalaa yaagindi ndɨ kat viyavat. Kambak viya la nɨmba ndina alagumba kwusonja waavwi lapmiga taagandi. Kwandɨ nyan kɨta ngwaymba lɨga vɨga la nyan Sol ndɨna mangandamba taagandi. Taagalaa kambak ndɨ kat viyavat kambak kalalaa yaagindi. ");
INSERT INTO ian_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yaagilɨndi maa Stiven njambwi nyangat wandɨ. Wuna wundumbu kat kwutaa kali waa wandɨ Stiven. ");
INSERT INTO ian_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kwali mamba vɨlaa lɨga God kat nɨma kwundimba wandɨ. Wun kat kavle vak yinja vak kat tɨga ndi kat ke sɨga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stiven kat vatnyanja njɨmbla Sol tɨga yelavɨtndɨ. Ndi apma vat yindi ndɨ kat waa yelavɨtndɨ. Wungi kat tɨga Jisasna yelangɨmba yisola la nɨmba Jerusalem kwagalalaa ngepma ngepmat yɨndi. Judiamba lɨga Samariamba lɨga ngepma ngepma lapta yɨndi. Aposel Jerusalem ana kwagalandi. Wata lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","God kat maawupmba yelavɨka la nɨmba Stivena sɨm kwutaa waangumba vaangundi. Ndɨ kat miwa yiga nglaga yiga waangumba vaangundi. ");
INSERT INTO ian_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wan nyan Sol Jisasna yelangɨ nɨmba kat kavle vat yɨndɨ. Ndina ngaymba wuleiga ndu taagwa kat kwutaa yiga kalabusmba naangandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jisasna mbaapma nɨmba Jerusalem kwagalalaa kava kava yilɨndi. Yiga wan apma nyaangɨt mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip waa nyaangɨt nɨma sakwat nɨmba wutaa ndina maawutmba God waa nyan Kraist kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Filip waa nyaangɨt nɨma sakwat nɨmba wutaa ndina maawutmba yelavɨka kwutaa lɨndi. Filip kwukaa nɨma njɨvwa ndinyangu kat kwunatnda vat vɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndina nɨmbana nat nɨmba kavle waagan tavilɨndi maa lɨndi. Filip kai waa savɨlɨndɨ, yɨndi. Nɨma kwundimba kiselaga waga yɨndi. Wupma ava kavle lɨla nɨmba kat Filip kwunatɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Wungi kat tɨga wan ngepmana nɨmba nɨmamba solat sɨga woviyaguga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wan kavamba la nyan ndɨna sɨ Saimon. Tak kan ngepmamba yeno kwutɨndɨ. Saimon yeno kwutnda vak wan ngepma nɨmba vɨga ngɨpaliga ndandi. Saimon walɨndɨ. Wun nɨma nyan wun waa walɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wan ngepmanana nat nyangu nɨma nyangu Saimon waa nyaangɨt wutaa wandi. wan nyan God ndɨ kat ɨnam kwondu kwindɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wungi kat tɨga wan ngepma nɨmba aywaa Saimon waa nyaangɨt wutaa lɨndi. Tamba wan yeno walɨnda vat vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wan ngepma nɨmba Filip waa nyaangɨt wutndi. Ndɨ apma nyaangɨt mbutɨndɨ. God ndinyangu kat vɨga la vak kat mbutɨndɨ. Jisas Kraist kat ndi kat mbutɨndɨ. Wan nyaangɨt wutaa ndina mbangɨ wiyo waavi taagandɨ, lɨndi. Wungi kat tɨga ndi kat ngumba njangindɨ. Ndu taagwa njangindɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon wan nyaangɨt wutaa ndɨno maawut yelavɨka kwutaa lɨndɨ. Filip Saimon ndɨno ngu njangindɨ. Filipmonala lɨndɨ. Filip kwunata njɨvwa sɨmolgilɨga njɨvwa kat vɨga Saimon ngɨpaliga ndandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sameriamba la nɨmba God waa nyaangɨt wutnjangat Jerusalemba la aposel wutndi. Wutaa Pitawi Jon kat mbutndi. Ay mbɨla. Yiga vɨgiyambɨt waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sameriat yɨmbɨt. Wan ngepma wuleilaa God kat wagalambɨt. Ndi kat mɨna waagan agwi waa wagalambɨt. ");
INSERT INTO ian_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pitawi Jono yamba njɨmbla Godna waagan wan ngepma nɨmba kat ana taviga lɨndɨ. Filip njambwi nyan Jisas kat mɨna ndi kat mbutaa ndɨna sɨmba njangindɨ. Godna waagan kat ana wutndi. ");
INSERT INTO ian_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tɨga lɨga mbɨtna taamba ndi kat taagambɨt maa Godna waagan ndi kat tavindɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Aposel taamba taagambɨt mala Godna waagan tavinda vat Saimon vɨndɨ. Vɨlaa Pita kat wandɨ. Mbɨtna kwondu wuno wun kat agwi. Wuna taambamba Godna waagan kwiweya kwondu wun kat kwimbeyan mbɨk kat wenga kwigiyowun waa wandɨ Saimon. ");
INSERT INTO ian_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita ndɨ kat wandɨ. Mɨnagwi mɨna wenga ndo kavle kavat ay mbɨla. Kavle vat maawupba yelaɨka lɨgamɨn. God ndɨna waagan awagapma mɨna kwilɨgandɨ. Wenga klalaa awat ana kwilɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mɨna maawut kavle savle lɨnda kat wan kwondu ana klaigamɨn. Yelavɨpma vak kat god kai walɨgandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wungi kat tɨga apma maawut asɨk. Kavle maawut kwagala. Njambwi nyan kat wagala. wuna kavle vak yiwa vak kat lɨmbwi mɨla waa wagala. ");
INSERT INTO ian_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Maawupmba yelavɨipma vak wan kavle vatna. Wan kavle vak mɨn kat tamba ngilaa lɨgandɨ. vɨlɨgowun waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon awat ndɨ kat kulumataa wandɨ. Wun kat nɨma nyan kat wagala mɨla. ndɨna kavle vak kat yinda vak kat vɨla ndɨ kat ke sɨga waa wagala waa wandɨ Saimon. ");
INSERT INTO ian_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","God waa nyaangɨt mbuka lɨga Jerusalemat yɨndi. God waa apma nyaangɨt Jerusalem yivat tɨga ava yambɨmba la Sameriana ngepma ngepmamba mbukɨva yɨlɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wan njɨmbla Godna ensel kɨta Filip kat yalaa wandɨ. Kambangwat naangat ay mɨla. Nɨma ava yambɨ Jerusalemba laapta gesat yilaa lɨga avayambat ay mɨla. Wan kava kwo nɨndɨ kava waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip wutaa laataa wanda kavat yɨndɨ. Itiopiamba yaa nyan Filip vɨndɨ. Ndɨ wan nyan Itiopiana kwina njɨvwa kwutɨga nɨmbana njambwi nyanat tɨndɨ. Wan kwina sɨ Kandesi. Kwina kwanda kwanda nɨmbundawi kat vɨga lɨndɨ. Ndi ngepma kwagalalaa Jerusalemat God kat kwunapmak yilaa tɨndi. ");
INSERT INTO ian_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wan nyan Jerusalemba lɨga ndɨna ngepmat lungwamataa yɨndɨ. Ndɨna karismba ndalɨndɨ. Hos ndɨna kairis kat laagaa kalilɨndɨ ngepmat. Tamba la profet aisaia pɨlɨwuta nyaangɨt vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Godna waagan Filip kat wandɨ. Ndɨna karis ngwaymba ay waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip ndɨna karis ngwaymba pɨlɨga yɨndɨ. Yilaa aisaia pɨlɨwuta nyaangɨt wɨnda vat wutndɨ. Filip ndɨ kat wandɨ. Vɨlɨma nyaangɨt mɨna maawut yelavɨtɨgamɨn? waa wagalandɨ Filip. ");
INSERT INTO ian_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wan nyan Filip kat wandɨ. Kai. Kɨta nyan wan nyaangɨtna angwa vat wun kat mbutndeyan wuna maawutmba yelavɨkiyowun waa kat mbutndeyan wuna maawutmba yelavɨkiyowun waa wandɨ. Karisat wokelaa wuna ngwaymba ndalɨ wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","God waa pɨlɨwutaa nyaangɨt vɨnda nyaangɨt kɨngivak. Wan nyan kat kwutaa kalindaa sip sip vla vatnyandi. Ndɨ kwundi ana ngambundɨ. Yuwi kalipmak kalɨnja sip sip vla tɨndɨ kwundi lapman tɨndɨ. Ndɨna sɨ viyesandalaa ndɨ kat savagu ana yindi. Ndɨ kat vatnyandi maa anda vapmba nyangu njangiyandɨ waa pɨlwutndɨ Aisaia. ");
INSERT INTO ian_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wan nyaangɨt vɨlaa lungwamaka Filip kat vɨlaa ngambundɨ. Pɨlɨwuta nyan avla pɨlɨwutndɨ? E? Nat nyan kat pɨlɨwutndɨ? Waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wagalandɨ maa Filip ndɨ kat wandɨ. Jisas kat wan apma nyaangɨt pɨlɨwutndɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Samat yiga ngu la kavamba wogwelaa lɨmbɨt. Wan nyan Filip kat wandɨ. Ngu kingiyan tɨga. Wun kat yagugiyanɨn wan ngumba? Waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wan nyan wandɨ mala karis kematndɨ. Kematndɨ mala ndalaa nguat yiga ndaimbɨt. Ndaimbɨt mala Filip ndɨ kat yagundɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ngu kwagalalaa nɨmbak wokembɨt mala Godna waagan Filip kat kwutaa nat kava kalindɨ. Vɨga la nyan Filip kat ana vɨga lɨndɨ. Ndɨ nolin ngwandɨga yɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip asdotmba yiga lɨndɨ. Ngepmamba wan nyaangɨt mbukiva yɨndɨ. Mbuka yiga Sisariamba wogwelaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jisasna mbaapma nɨmba kat vatnyagiyowun waa yelavɨtndɨ Sol. Yelavɨtaa God kat kwunatɨga njambwi nyan kat yindɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Sol ndɨ kat wandɨ. Damaskasmba lɨga Juda yisolaa lɨnja ngay vɨga lɨga nyan kat pas pɨlɨwutaa wun kat agwi. Wan ngepmamba lɨga Jisas waa vapmba apma vapmba yetɨga nɨmba kat kwaka yivat wowun. Ndi kat vɨlaa ndina taamba ngilaa Jerusalemat kaligiyowun waa wandɨ Sol. ");
INSERT INTO ian_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yiga Damaskas walɨnja ngepma ngway tolondɨ. Nɨma nya vla lɨga nda nyɨnangwupmba nganga yalaa ndɨ kat kembandɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kembandɨ mala Sol kɨpmamba ndalaa kwundi wutndɨ. Sol Sol wun kat manda kat kavle vat yivat yilɨgamɨn, waa wandɨ wan kwundi. ");
INSERT INTO ian_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol wandɨ. Mɨn njambwi nyan. Mɨn anda nyan mɨn. Sol wandɨ maa wan kwundi wandɨ. Wun Jisas wun. Wunayɨ kavle vat yɨma nyan waa. ");
INSERT INTO ian_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mɨn laak. Ngepma wulei. Yɨmeya vak mɨn kat vɨlɨmogwigiyowun waa wandɨ wan kwundi. ");
INSERT INTO ian_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Solonala ta nɨmba ngepalɨga ndalaa nyaangɨt ana ngambundi. Kwundi wutndi. Ndunyan kat ana vɨndi. ");
INSERT INTO ian_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol laataa mɨni ana vɨndɨ. Ndɨ kat taamba kwutaa ngepmat kalindi. ");
INSERT INTO ian_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sol Damaskasmba nandinya kuvut tɨndan ndɨna mɨni ana vɨndɨ. Wan nandiya kuvut nao kɨgɨnda ngu ana kɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskasmba Jisasna mbaapmamba la nyan kɨta lɨndɨ. Ndɨna sɨ Ananaias. Njambwi nyan ndɨ kat sɨmapmba ngambundɨ. Ananais waa wandɨ njambwi nyan. Wandɨ maa Ananaias wandɨ. Njambwi nyan kumba lɨgowun. Manda kat wagalamɨn waa wandɨ Ananaias. ");
INSERT INTO ian_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Njambwi nyan ndɨ kat wandɨ. Mɨn laataa ay. Savagu walɨnja ava yambat ay. Wan ava yambɨ Jutasna ngay ngilɨga. Ndɨna ngay wuleilaa Sol kat wagala. Solna ngepma Tasas walɨnja ngepma. Wan nyan Sol wun kat mbambala ngambulɨgandɨ. Ndɨ kat sɨmagawun mɨn kat Ananaias yaigandɨ. Mɨn kat ndɨna taamba taagandɨ ma mɨni vɨgiyandɨ waa sɨmagawun ndɨ kat waa wandɨ God Ananaias kat. ");
INSERT INTO ian_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias awat wandɨ. Njambwi nyan wan nyan kat nɨmba sakwat nyaangɨt wutwun. Jerusalemba lɨga mɨna yelangɨ nɨmba kat kavle vat yɨnda vat wutwun. ");
INSERT INTO ian_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jerusalemba lɨga god kat kwunatɨga njambwi nyan ndɨ kat paak kwindɨ. Wan paak kwutaa nɨna ngepmat yandɨ. Mɨn kat njambwi nyan walɨga nɨmba kat taamba ngilaa kalivat yandɨ waa wandɨ Ananaias. ");
INSERT INTO ian_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Njambwi nyan ndɨ kat wandɨ. Ay. Yɨga agwut. Wun Sol kat kwukwun. Juda ana ndi nat nɨmba kat Sol wuna sɨ wun kat waga mbukiyandɨ. Nɨma sakwat kingat mbukiyandi. Juda kat mbukiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wunai waa nyaangɨt mbutnda kat nɨma sakwat nɨmba ndɨ kat kavle vat yigiyandɨ. Vɨgiyandɨ waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","God wandɨ maa Ananaias yiga Jutasna ngay wuleindɨ. Solmba ndɨna taamba taagalaa wandɨ. Wuna yakwa nyan Sol. Njambwi nyan Jisas wan yambɨmba vɨma nyan Jisas wandɨ, yawun. Mɨna mɨni kwunapmat yawun. Godna waagan klambangat yawun waa wandɨ Ananaias. ");
INSERT INTO ian_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias wandɨ maa ndɨna mɨnimba la nda kɨsɨk vla lavwi yaga ndalɨ. Ndalɨ maa ndɨna mɨni kwo vɨndɨ. Sol laatndɨ mala ndɨ kat ngu yagundi. ");
INSERT INTO ian_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol nao kɨlaa ava mban walaa tɨndɨ. Sol Jisasna mbaapma nɨmbonala damaskasmba nandiya nandinya yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sol Juda yisolaa lɨnja ngay wuleilaa ndi kat mbutndɨ Jisas kat. Ndɨ Godna waa mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndɨnai wala nyaangɨt wuta nɨmba ngɨpaliga ndalaa wandi. Jeruslemba la Jisasna mbaapmamba lɨga nɨmba kat kavle vat yɨlɨga nyan anagandɨ ya. ");
INSERT INTO ian_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol ngambula vat apma vat ngambulɨndɨ. Damaskasmba lɨga Juda ndɨnai waa nyaangɨt wutaa kavle vak ngambulɨgandɨ ana wandi. Jisas ndɨ God waa nyana waa Sol wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tɨga lɨga nat njɨmbla nat Juda yisolaa lɨga Sol kat sɨvat kwanda kwanda kwunaka ngambulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ngambulɨnja vak Sol wutndɨ. Sol wogwendeya ava yambɨ kat ngan nandinya vɨga lɨndi ndɨ kat vatnyavat. ");
INSERT INTO ian_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Solna mbaapma nɨmba ndɨ kat kwutaa nɨma mbanimba naangangi. Ngepma tɨvwimba lɨga yaawmba tulaa ndɨ kat kwusenda lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalemba yiga Jisasna mbaapma nɨmbonala tɨvat wandɨ. Ndɨ kat vaaka kai wandi. Ndɨ nɨna mbaapma nyan ana ndɨ waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sol kat Banabas kwutaa Aposel ta kavat kalindɨ. Kaliga wandɨ. Sol njambwi nyan kat ava yambɨmba lɨga vɨndɨ. Njambwi nyan ndɨ kat wandɨ. Ndɨ Damaskasmba Jisas waa nyaangɨt nɨmbamba mbutndɨ waa wandɨ Banabas. ");
INSERT INTO ian_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wungi kat tɨga Sol ndinogwinala Jerusalemba yetɨndɨ. Ndinogwinala yi ya yetɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yi ya yetɨga njambwi nyan waa nyaangɨt mbutɨndɨ. Vaaka ana ndi kat mbutɨndɨ. Grik walɨnja kwundi ngambulɨga Juda kat kaawa viyaa mbutɨndɨ. Ndɨ kat vatnyavat wandi. ");
INSERT INTO ian_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Juda ndɨ kat vatnyanjeya vak kat ndɨna yakwa nɨmba wutaa Sol kat kat kwutaa seseria walɨnja ngepmat kalindi. Ndɨ kat wandi. Tarsis walɨnja ngepmat ay waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yindɨ maa Judagwi Sameriamba lɨga Jisasna yelangɨ nɨmba kat nat nɨmba ndi kat ana kavle vat yɨndi. God waa nyaangɨt ndinamba lɨndɨ. God kat yelavɨka yetɨlɨndi. Godna waagan ndi kat tavilɨndɨ. Ndi nɨma sakwat yɨndi. ");
INSERT INTO ian_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tɨga lɨga nat njɨmbla Pita ngepma ngepmat yɨndɨ. Lidamba tɨga Godna yelangɨ nɨmba kat vɨvat yɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wan ngepmamba kɨta nyan tɨndɨ. Ndɨna sɨ Inias. Njamɨmba naambi selakuvuk tɨndɨ. Ava plalɨnja yelongwengat tɨga lɨndɨ njambɨmba. ");
INSERT INTO ian_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ndɨ kat wandɨ. Inias Jisas Kraist mɨn kat kwunakiyandɨ. Laap mɨla. Mɨna njambɨ kwutaa kali mɨla waa wandɨ maa kwiyatapman laatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidawi seronba lɨga nɨmba wan nyan kat vɨlaa God waa nyaangɨk kat wutaa maawupmba yelavɨka woviyaguga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa walɨnja ngepmamba Jisasna yelangɨmba lɨga taagwa kɨta lɨlɨ. Lɨla sɨ Tabita. Grikna kwundimba lɨ kat Dokas walɨndi. Lɨ apma njɨvwa nɨma sakwat kwutɨlɨ. Sanya lapman nɨmba kat lɨla sanya klalaa kwilɨlɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wan njɨmbla yelogwenga tɨga kiyalɨ. Lɨla sɨm njangilaa awlak ngemba taagandi. ");
INSERT INTO ian_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida walɨnja ngepma Jopa walɨnja ngepma sɨvla ana ndɨ. Ngwaya. Lidamba lɨga Jisasna mbaapma nɨmba Pita Jopamba lɨndangat wutaa vɨlɨlɨk palɨ kat wandi maa Pita kat yimbɨk. Yiga Pita kat wambɨk. Kwiyatapman yagwa wambɨt. ");
INSERT INTO ian_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita mbɨlagwina yindɨ. Yandɨ maa ndɨ kat kwutaa awlak ngeyat kalindi. Wan kavamba nɨma sakwat tolagwa lɨndi. Ndi ngla lɨga wan waavwi Dokas tat tava waavwi klalaa Pita kat sɨmogwindi. ");
INSERT INTO ian_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ndi kat wandɨ. Wogwega ay ngwula waa walaa ndɨ kwalimamba sɨlaa God kat wagalandɨ. Sɨm kat vɨlaa wandɨ. Tabita laak waa wandɨ maa lɨla mɨni vɨlɨ. Mɨni vɨlaa laatɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita lɨ kat taambamba kwutaa kwuselatndɨ. Godna yelangɨ nɨmba kat yagwa walaa ndi kat smagandɨ. Kwo lɨla vak kat sɨmagandɨ. ");
INSERT INTO ian_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jopamba lɨga nɨma sakwat nɨmba Pita kwuta vak kat wutndi. Wutaa wan apma nyaangɨt maawupmba yelavɨtaa Jisasna mbaapma wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita Jopamba nɨma sakwat nandinya yetɨndɨ. Saimana ngaymba yetɨndɨ. (v 44) Saimana njɨvwa bulmakawna sɨmbɨ kwiya wutaa sol taagalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kɨta nyan seseliamba la nyan ndɨna sɨ Konilias. Ndɨ Juda ana ndɨ. Ndɨ soldiana njambwi nyanat tɨndɨ. Ndɨ soldia ndumi tambanak kat vɨga lɨndɨ. Ndɨna soldia Itali walɨnja soldia. ");
INSERT INTO ian_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wan nyan God kat ndɨna maawupmba yelavɨka lɨndɨ. Kapma ana yelavɨka lɨndɨ. Ndɨna ngaymba lɨga nɨbonala kɨta vak yelavɨka lɨndɨ. Ndɨna ngaymba lɨga nɨmbonala kɨta vak yelavɨka lɨndi. Sanya lapma Juda kat sanya kwilɨndɨ. Njɨmbla njɨmbla God kat ngambulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kɨta nglambu Godna ensel sɨmap vla ndɨ kat yalaa wandɨ. Konilias waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias vaka lɨga ensel kat vɨlaa wandɨ Konilias. Wan ensel ndɨ kat wandɨ. God kat ngambulɨgamɨn. Kwo lɨga nɨmba kat mɨna sanya kwilɨgamɨn. God yɨlɨma vat vɨga lɨgandɨ. Wungi kat tɨga mɨn kat ngambuvat yawun. ");
INSERT INTO ian_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nat nɨmba Jopat yigaandi wamɨn maa ndi yiga Saimon waa walɨnja nyan kat kwutaa kumba kiyaigandi. ");
INSERT INTO ian_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pita Saimona ngaymba yetɨlɨndɨ. Saimona njɨvwa bulambakawna sɨmbɨ kwiya wutaa sol taagalɨndɨ. Ndɨna ngay nyɨngi nguna tɨvagawimba lɨndɨ waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel walaa yɨndɨ maa Konilias ndɨna mbɨt nɨvwa kwutaa mbɨt nyan kat yagwa wandɨ. Soldia kɨta kat yagwa wandɨ, yandɨ. Wan soldia God kat ndɨna maawupmba yelavɨka lɨndɨ. Ndɨna njɨvwa Konilias kat vɨga lɨvak kat tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Yandi maa ensel waa nyaangɨt ndi kat mbutndɨ. Ndi kat ay ngwula Jopat wandɨ maa yɨndi. ");
INSERT INTO ian_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nat nandinya yiga Jopa walɨnja ngepma ngwaymba lɨlɨndi maa Pita God kat ngambuvat awlak ngeyat wokendɨ. Nɨma nandinya wokendɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita wumba lɨga wundɨ kat tɨndɨ. Kɨvat walɨndɨ. Pita ndaivat tɨga sɨmat vla vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nyɨnangwut kembandɨ maa nɨma sel ndailɨndɨ, vɨndɨ. Wan sel waambu waambu kuvusɨ kat kwutndi, lɨndɨ. Angɨ naynat vla lɨndɨ. Ndaiga ndalaa viyanjalindɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wungi selmba la nda kwapɨmba yeta nda mandɨp nda lɨndɨ wungiselmba. Kɨpmamba yetɨga nda, waavi, kamboy, waak, viyu, mbolu, tɨndi. ");
INSERT INTO ian_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita wan nda kat vɨga lɨga kwundi wutndɨ. Pita laak. Laataga vatnyalaa ngɨ wan nda kat waa wandɨ waa kwundi. ");
INSERT INTO ian_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita wandɨ. Njambwi nyan kai. Wan ana kɨlɨgowun. Nɨn Juda wupma walɨganɨn. Wan nda ke kɨga kavle da waa walɨganɨn waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pita wandɨ maa waa kwundi ndɨ kat nat njamba wandɨ. God wandɨ. Wan nda kavle nda ana ndɨ. Kavle nda waa ke waa waa wandɨ God. ");
INSERT INTO ian_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Wan kwundi njamba kuvut wambɨt maa wan sel wumba yambɨ wokendɨ nyɨnangwutnat. ");
INSERT INTO ian_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wokendɨ maa Pita yelavɨtndɨ. Vɨwa vatna angwa angamat tɨgandɨ. Wan vat manda kat God wun kat vɨsɨmogwindɨ waa yelavɨtndɨ Pita. Yelavɨka lɨga Konilias ay wandɨ maa kuvuk nyangu ndɨnai lɨga kava yandi. Ndi wundi nɨmba Saimona ngay kat kwaka yalaa ndaamangemba lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Saimon Pita wan ngaymba lɨgandɨ? Waa wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita vɨnda nda kat yelavɨka lɨndɨ maa Godna waagan ndɨ kat wandɨ. Kuvut nyangu mɨn kwaka yalaa tɨma ngay ndaamangemba lɨgandi. ");
INSERT INTO ian_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mɨn ndailaa ndinogwinala ay. Ke nɨmamba yelavɨka. Kwo ay. wowun mala mɨn kat vɨvat yandi waa wandɨ Godna waagan. ");
INSERT INTO ian_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ndailaa ndi kat wandɨ. Wun kwaka lɨngwa nyan wun. Manda kat yangwuk waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndi wandi. Nɨna njambwi nyan wandɨ maa yanɨn. Ndɨ ndumi tambanat ta soldia kat vɨga lɨndɨ. God kat ndɨna maawupmba yelavɨka apma vat tɨlɨndɨ. Juda walɨnja nɨmba ndɨ kat walɨndi. Apma vat yetɨlɨgandɨ waa walɨndi. Godna ensel ndɨ kat wandɨ maa nɨn kat wandɨ, yanɨn. Mɨn kat vɨvat wan ngay yanɨn. Mɨnai waiga nyaangɨt wupmat yanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ndi kat ngay yagwa wandɨ maa ndɨna ngaymba kwandi. Nat nandinya laataa Pita ndinogwionala yɨndɨ. Jopamba lɨga Jisana mbaapmamba lɨga nat nɨmba ndinogwinala yindi. ");
INSERT INTO ian_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nat nandinya Seseria walɨnja ngepma wuleindi. Konilias ndi kat kawiga lɨndɨ. Ndɨna yelangɨ nɨmba ndɨna ava nɨmba kat yagwa wandɨ mala yisolaa lɨga Pita kat kawiga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita yandɨ maa vɨlaa Konilias maat sɨlandalaa lɨga Pita kat wandɨ. Mɨn njambwi nyan mɨn. ");
INSERT INTO ian_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pita ndɨ kat kwutaa kwuselataa wandɨ. Laak. Wun ndu nyan wun. Mɨnai lɨga vla lɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Konilias kat ngambuga ngay wuleilaa nɨma sakwat nɨmba yisolaa lɨndi maa vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita ndi kat wandɨ. Nɨna ngepmana vat kɨngiyan. Nɨn Juda Juda ana ndi nat nɨmbana ngay ana wuleilɨganɨn. Ndinogwinala ana kɨtamba yetɨlɨganɨn. Ngwuk vɨlɨgangwuk. God wun kat vɨsɨmogwindɨ kapma yiweya vat. God wun kat wandɨ. Wan vat apma vatna. Kavle vatna waa ke waa waa wandɨ God. Wungi kat tɨga yiweya vak kat God ana kai walɨgandɨ vɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wungi kat tɨga Konilias wun kat yagwa wandɨ maa ana kai wowun. Yawun. Kɨta vat ngwuk kat wagavat tɨgowun. Manda kat wun kat yagwa wangwuk waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias awat wandɨ. Nandinya aynat tamba yɨndɨ, nɨndɨ nandinya wuna ngaymba lɨga God kat ngambulɨwun. Ngambulɨwun maa Kɨta nyan wuna mɨndama sambɨmba yalaa lɨndɨ. Ndɨna waavwi ya vla vɨtɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wun kat wandɨ. Konilias ngambulɨma nyaangɨt God wutndɨ. Sanya lapman nɨmba kat sanya kwima vak vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nat nɨmba kat ay awa Jopat yigandi. Jopat yilaa Saimon waa Pita walɨnja nyan kat kwutaa kiyagiyandi. Ndɨ Saimona ngaymba yetɨlɨgandɨ. Wan nyan Saimon bulmakawna sɨmbɨ kwiya wutɨga nyana. Ndɨna ngay nyɨngi ngumba lɨgandɨ waa wandɨ wan nyan. ");
INSERT INTO ian_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wungi kat tɨga ay wowun maa yɨndi, yamɨn. Wovun yamɨn. God waa nyaangɨt mɨnai waiga nyaangɨt wupmak yisolaa lɨganɨn waa wandɨ Konilias. ");
INSERT INTO ian_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita wandɨ. God ngepma ngepmana nɨmba kat kɨta vat mɨna yilɨgandɨ. Mandɨp mandɨp ana yiligandɨ. Vɨlɨgowun. ");
INSERT INTO ian_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ngepma ngepmana nɨmba God kat ndina maawupmba yelavɨka apma vat yetɨnjeyan God ndi kat kwunakiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God tamba wandɨ Jekop waa Isrel walɨnja nyana yelangɨ nɨmba kat. God waa nyaangɨt mbutndɨ. Apma vat yetɨmbandi walaa waa mbutndɨ. Jisas Kraist ngepma ngepmamba lɨga nɨmbana njambwi nyana. ");
INSERT INTO ian_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wan nyaangɨt Judiamba lɨga ngepma ngepmamba yiga mbutndi. Tat Galili walɨnja ngepmamba mbutndi. Jon ndinyangu kat ngu yaguga mbutndɨ. Ngwuk wan nyaangɨt tamba wuka lɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nasaretmba la nyan Jisas kat God ndɨna waagan kwindɨ. Kwondu wagwundɨ. Jisas yiga apma vat yɨndɨ. Nɨma sakwat nɨmba Seten ndi kat kavle vat yɨlɨndɨ, Jisas yalaa ndi kat kwunatndɨ. God ndɨnagwinala lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jerusalemba nat Judanangepmamba lɨga kwutɨnda vak vɨnɨn. Ndi ndɨ kat vatnyandi diwai krosmba. ");
INSERT INTO ian_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jisas kiyalaa nandinya kuvut tɨga God wandɨ maa laatndɨ. Lataa ndinyangu kat avla vɨsɨmogwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ndinyangu aywaa ndɨ kat ana vɨndi. Nɨn vɨnɨn. God wandɨ maa vɨnɨn. ");
INSERT INTO ian_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nɨn kat wandɨ nat nɨmba kat yiga ambuk wandɨ. Wun Godna nyan wun ndi kat yiga ambuk wandɨ Jisas. God wun kat wandɨ. Mɨn Jas mɨn. Kiyaa laa nɨmba kwo lɨga nɨmba kat kansagiyaa Jasa tɨgiyamɨn waa God wun kat wandɨ waa ambuk waa Jisas wandɨ nɨn kat. ");
INSERT INTO ian_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tamba profet Jisas kat pɨlɨwutndi. Jisas kiyaa vak kat apma maawut yelavɨka woviyaguga yetɨnjeyan God ndina kavle vak kat tɨga ana sɨgiyandɨ wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita walɨndɨ mala Godna waagan yalaa ndɨnai waa ngambulaa nyaangɨt wutɨga nɨmba kat Godna waagan tavindɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Godna waagan ndi kat tavindɨ maa Pitonala ya Juda ngɨpalɨga ndandi. Wan Juda tat Jisasna mbaapma sɨlɨndi. Juda ana ndi nat nɨmba kat Godna waagan tavindangat vlɨaa ngɨpali ndandi. ");
INSERT INTO ian_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Godna waagan taviyaa nɨmba kapma kapma kwundi ngambundi, Juda wutndi. Ngambuga wandi. God nɨma nyana waa wandi. Pita laataa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Godna waagan ndi kat tavinda vla nɨn kat wupma tavindɨ. Wungi kat tɨga ndi kat ngumba yagugiyanɨn. Ngwuk kai wangwuk? Waa Pita wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pita wandɨ mala Jisasna sɨmba waga ngumba njangindi. Wan nɨmba wandi. Pita samat nɨnogwinala yetɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Juda ana ndi nat nɨmba God waa nyaangɨt maawupmba yelavɨka klanja vak kat Judiamba lɨga Jisasna yelangɨ nɨmbawi Aposelo wutndi. ");
INSERT INTO ian_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita Jerusalem yandɨ mala wumba la Juda ndɨ kat kaawa viyaa nyaangɨt ngambundi. Wundi Juda wupma yelavɨtndi. Juda yeta vapmba yetɨlapman yinjeyan Jisasna mbaapma ana wuleigiyandi waa yelavɨtaa Pita kat ngambundi. ");
INSERT INTO ian_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ndi Juda Pita kat wagalandi. Juda ana ndi ndina ngaymba mɨn ndinogwinala tɨga nao kɨmɨn. Manda kat wupma yɨmɨn waa wandi Pita kat. ");
INSERT INTO ian_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita ndɨnai kwutaa njɨvwa kat ndi kat mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Jopamba lɨga god kat wagalaga tɨga sɨmat vla vɨwun. Kɨta nda sel vla nyɨnangwupmba lɨga ngaga yandɨ maa vɨwun. Waambu waambu kuvusɨtndi maa nagɨ aynat vla lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wungi selmba lɨndi maa vɨwun. Kwapɨmba yetɨlɨga nda, waavi, kamboy, waak, mbolu, viyu, lɨndi, vɨwun. ");
INSERT INTO ian_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Vɨga lɨga kɨta nyana kwundi wutwun. Wan nyan wandɨ. Pita laak. Vatnyaga agɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wun wowun. Njambwi nyan kai. Kɨngi vat kavle nda ana kɨlɨgowun. Judana vatmba ana kɨlɨgowun wowun. ");
INSERT INTO ian_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wowun maa god wandɨ. Wan nda kɨgɨnda kɨlɨnja nda. Nglambi lɨga nda waa ke waa. ");
INSERT INTO ian_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wan vak njamba kuvuk ndailaa wokendɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wokendɨ maa kuvut nyangu yalaa tuwa ngayna ndaamangena nduamba tɨndi. Seseriamba la nyan Konilias wandɨ mala wun kat yandi. ");
INSERT INTO ian_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Godna waagan wun kat wandɨ. Ndinogwinala yiwangat wandɨ. Ke nɨmamba yelavɨka ay wandɨ. Kɨndi sɨlakɨta mɨna yakwa nɨmba wunagwinala yalaa ndɨna ngay wuleinɨn. ");
INSERT INTO ian_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Ngay wuleinɨn maa Konilias nɨn kat wandɨ. Wun ensel kat vɨwun. Wuna ngaymba laataga wun kat wandɨ. Ensel wandɨ. Mɨn ndinvangu kat wamɨn, yigandi Jopat. Saimon waa Pita walɨnja nyan ndɨ kat kwutaa kumba kiyaigandi. Wan nyan ngwuk kat nyaangɨt mbukiyandɨ. Ndɨnai waiga nyaangɨt wukngwuk maa God ngwutna kavle vat lɨmbwigiyandɨ. Mɨna ngaymba yetɨga nɨmba aywa ndina kavle vat aywa lɨmbwigiyandɨ waa wandɨ ensel waa wandɨ Konilias. ");
INSERT INTO ian_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nyaangɨt ndi kat ngambulɨwun maa Godna waagan nɨn kat tavinda vap vla ndi kat tavindɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Godna waagan ndi kat tavindɨ maa yelavɨkwun. Tat Jisas waa nyaangɨt kat yelavɨkwun. Tat wandɨ. Jon ngwuk kat ngumba yagundɨ. Wun Godna waagan ngwuk kat kwiwun tavigiyandɨ waa wandɨ Jisas. ");
INSERT INTO ian_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nɨna njambwi nyan Jisas Kraist kat woviyaguga nɨna mbangɨ wiyo waavi taagandɨ maa God nɨn kat ndɨna waagan kwindɨ. Juda kwindɨ. Kwinda vak kat God kat ana kai wowun waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wanda nyaangɨt wutaa awat ndɨ kat ana wandi. Ndi wandi. God njambwi nyana. Juda ana ndi nat nɨmba God kat kupi maawutmba yelavɨtaa apma vat tɨgiyandi. Vɨlɨganɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tamba Stiven kat vatnyanja njɨmbla Jisasna mbaapma nɨmba kat kavle vat yɨndi. Wundi kat tɨga ngepma ngepma lapta yɨndi. Wan ngepmana sɨ finisia, ngepma ngepma lapta yɨndi. Wan ngepmana sɨ finisia, Saipras, Antiok. Yiga God waa nyaangɨt Juda kat mɨna mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ndina nat nɨmba ngepma vɨlɨlɨk Saipras. Sairinimba lɨga Antiok yandi. Wundi nat nɨmba God waa nyaangɨt Juda ana ndi Grik walɨnja nɨmba kat mbutndi. Jisas Kraist njambwi nyana waa mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wan nyaangɨt mbutɨnja njɨmbla God ndina lak kwandɨ maa mbutɨndi. Nɨma sakwat nɨmba wan nyaangɨt wutaa ndina maawupmba yelavɨka Jisasna mbaapma wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Antiokmba la nɨmba Godna yelangɨ wuleinja vak kat Jerusalemba la Godna yelandɨ nɨmba wutndi. Wutaa Banabas kat wandi. Wandi maa Antioknat yɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banasba yiga Antiok wulielaa ndi kat vɨndɨ. Vɨga yelavɨtndɨ. God ndi kat apma vat yɨndɨ waa yelavɨtndɨ. Banabas solat sɨga lɨndɨ. Antiokmba lɨga nɨmba kat wandɨ. Njambwi nyan Jisas ngwutna maawupmba yelavɨka ndi kat nɨmamba agwut waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas apma nyana. Godna waagan ndɨ kat nɨmamba tavɨlɨndɨ. God waa nyaangɨt nɨmamba kwutaa lɨndɨ. Ndɨnai waa nyaangɨt wutaa nɨma sakwat nɨmba njambwi nyana mbaapma wuleindi. ");
INSERT INTO ian_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas Tarsis kwaka yɨndɨ Sol kat vɨvat. ");
INSERT INTO ian_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ndɨ kat vɨlaa kwutaa Antioknat kalindɨ. Naambi kɨta lɨndɨ, Antiokmba Godna yelangɨ nɨmbonala yisolaa kɨta vat tɨmbɨk God waa nyaangɨt ndi kat mbutɨmbɨk. Jisasna mbaapma nɨmba kat mandɨt sɨ wandi. Ngwuk Kristen ngwuk waa wandi. Tamba wungi vat sɨ kai. ");
INSERT INTO ian_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wan njɨmbla Jerusalemba la profet Antiok yandi. ");
INSERT INTO ian_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ndina nat nyana sɨ Agabas. Godna waagan ndɨna maawut ngwandɨndɨ maa laataa wandɨ. Ngɨni ngepma ngepma kɨgɨnda ana lɨgiyandɨ waa mbutɨndɨ. Wan wanda vat kɨgɨnda lapman naambi tɨndɨ. Klodias King ta njɨmbla tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wandɨ mala Antiokmba la yakwa nɨmba kat yelavɨtndi. Yelavɨka lɨga kɨgɨnda klanjeya sanya kwivat wandi. Ndinamba la sanya kɨta nyan kɨta nyan nɨma sakwat ta nɨmba klamba kwindi. Sanya kuvut ta nɨmba ndino wupma klamba kwindi. ");
INSERT INTO ian_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Solagwi Banabas kat kwindi. Jerusalema la Jisasna mbaapmamba la njambwi nɨmba kat yiga kwimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wan njɨmbla King Herot Agripa laataa Godna yelangɨ nɨmba kat kavle vat yivat wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herot wandɨ maa Jona yakwa ndu Jems kat yapmba vatnyandi. ");
INSERT INTO ian_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jems kat vatnyanda vak kat vɨlaa Juda solat sɨga nolin ngwandɨlɨndi. Nolin ngwandɨlɨnja vak kat vɨlaa Herot Pita kat kwutndɨ. Pasova walɨnja pesto la njɨmblamba kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita kat kwutaa kalabusmba taagandɨ. Herot wandɨ maa tambavɨli kiyeli sɨlakɨta soldia Pita kat kalabusmba lɨndɨ, yiga vɨga lɨlɨndi. Nat aynat ngambi vɨga lɨlɨndi. Nat aynat nɨma nandinya vɨga lɨlɨlndi. Nat aynat nglaambu vɨga lɨlɨndi. Nat aynat nɨndɨ ngan vɨga lɨlɨndi. Herot wupma yelavɨtndɨ. Pasova walɨnja pesto ngɨlɨndɨ maa ndɨ kat kwutaa kaligiyowun kotmak waa yelavɨka lɨndɨ. Pita kat kotndangat kaliweyan Juda wun kat woviyaguga lɨgiyandi waa yelavɨtndɨ Herot. ");
INSERT INTO ian_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Wungi kat tɨga Pita kalabusmba lɨga kawiga lɨndɨ. Godna mbaapma nɨmba Pita kat God kat wagalalɨndi. Nɨmamba wagalalɨndi. ");
INSERT INTO ian_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot Pita kat kotmat kalindeya njɨmbla tamba ngway tologandɨ. Wan ngan Pita sɨndu kwandɨ kalabusmba. Pitana yaagindan taambamba sen tula nat soldiana taamba tundɨ. Ambugendan taambamba sen tula nat kɨta soldiana taambamba tundɨ. Tula wupma vɨga lɨmbɨt, nɨndɨmba sɨndu kwandɨ. Nat nɨmba wan kalabus ngena ndaamange kat vɨga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tɨga lɨga Godna ensel yalaa Pitana ngwaymba laataa lɨndɨ. Wan kava ya vla vɨtɨndɨ. Wan ensel Pitana malava avamba ndɨna taambamba viyalaa wandɨ. Kwiyatapman laap mɨla. Wandɨ mala Pita laatndɨ maa wan taambamba la sen pigiyaga ndandɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wan ensel ndɨ kat wandɨ. Waavwi kwuso. Man su kwuso wandɨ. Wupma Pita kwusondɨ. Ensel wandɨ. Tagumba lɨlɨga waavwi klalaa kwuso. Wuna kwupmba yagwa waa wandɨ ensel. ");
INSERT INTO ian_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita nɨdɨna kwupmba yindɨ. Pita kalabus kwagalaa wogwenda vak ana yelavɨtndɨ. Wan sɨmakna vɨlɨwa waa yelavɨtndɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tata la wasman kat vɨgɨva yɨmbɨt. Ngɨni laa lan wasman kat vɨgɨva yɨmbɨt. Vɨgɨva yiga kapamba kwutnja ndaamange yɨmbɨt maa avla lavwindɨ. Lavwindɨ, wogwembɨt. Nat ava yambɨt vɨlaa yiga ensel Pita kat kwagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita lɨga yelavɨtndɨ. Njambwi nyan ensel kat wandɨ mala wun kat yandɨ. Wun kat kwutaa alaguat kloga kalindan Herot wun kat ana sɨgiyandɨ. Sɨmat ana ndɨ mɨnimba vɨgowun waa yelavɨtndɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita ndɨnai ya vak kat yelavɨka Mariana ngayat yɨndɨ. Wat Maria Jon waa Mak walɨnja nyana nyɨmeat. Wan lɨla ngaymba nɨma sakwat nɨmba yisolaa God kat wagalandi. ");
INSERT INTO ian_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ndaamangena mbapma taamba viyandɨ. Viyandɨ mwunya wiya nyan kɨta laataa ya vɨlɨ Pita kat. Lɨla sɨ Roda. ");
INSERT INTO ian_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pita waa wukwa waa yelavɨtaa mbapmo ana lavwilɨ. Solat sɨga wuleilaa ndi kat mbutɨ. Pita kɨngiyan yalaa ndaama ngena mbapmomba lɨga waa walɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ndi wandi. Nyɨn tungwengwan yiga kwo wanyɨn. Lɨ walɨ. Kai woseka ana wowun. Wungi lɨga waa walɨ. Ndi wandi ndɨ kat vɨga la ensel yaa waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wan nɨmba yisolaa Pita kat ngambulɨndi maa mbapmomba Pita taambamba viyalɨndɨ. Yalaa mbapma lavwilaa vɨndi Pita kat. Vɨlaa ngɨpali wandi. ");
INSERT INTO ian_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","18","Pita taamba taagalaa wandɨ. Kwundi ke wangweya. makayak. Kalabusmba lɨndɨ mala God ndɨ kat kwutaa kalia vak kat ndi kat mbutndɨ. Pita wandɨ. Mbutna nyaangɨt Jemsawi nat yakwa nɨmba kat yiga ambuk waa wandɨ. Nyangɨt ngambulaa ndi kat kwagalalaa nat ngepmat yɨndɨ. Ngambi Pita kat vɨga la soldia nɨma vak yelavɨtndi. Pita andambala yɨnda waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot ndɨ kat kwaka vɨlevilaa tɨndɨ. Tɨga lɨga Pita kat vɨga la soldia kat wagalandɨ. Herot wandɨ maa wan soldia kat vatnyandi. Herot Judia kwagalalaa Seseria walɨnja ngepmamba yiga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot wan ngepma vɨlɨlɨk ta nɨmba kat kimbut yiga lɨndɨ. Wan ngepmana sɨ Taia Saidon. Wan ngepmana nɨmbana ava nyan Herotna ngaymba njɨvwa kwutɨndɨ. Herotna sɨndu kwalɨnda kava kat vɨga lɨndɨ. Ndɨna sɨ Blastas. Blastas yambɨ kwutndɨ maa kɨmbɨk kwupmak yisolaa lɨndi. Wan ngepma vɨlɨlɨk ta nɨmba Herotna nɨmbamba kɨgɨnda klalɨndi. ");
INSERT INTO ian_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wungi kat tɨga yisolaa lɨnjeya nandinya kat Herot tamba wandɨ. Herot apma nglei waavi kwusolaa yalaa Kingna tɨkɨtmba ndalɨndɨ. Ndaa lɨga ndi kat nɨmamba nyaangɨt ngambulɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herot ngambundɨ maa wutɨga nɨmba nɨmamba walega ngambulɨndi. Herot ndu nyan vla ana ngambulɨgandɨ. God ngambulɨga vla ngambulɨndɨ waa walega wandi. ");
INSERT INTO ian_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ndinai waa kavle nyaangɨk kat wutaa ana kai wandɨ. Wun God ana wun waa ana wandɨ. Wungi kat tɨga wan kavle nyaangɨt ngambundi maa Godna ensel Herot kat sɨndɨ. Sɨndɨ, Herotna yaat tɨgɨmbimba ngwaambɨ ngwaambɨ kɨlɨndi maa kiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","God waa nyaangɨt wuka ndɨna mbaapma wuleila nɨmba nɨma sakwat yɨndi. ");
INSERT INTO ian_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasawi Solo Jerusalemba lɨga Angiokat yɨmbɨk. Kɨgɨnda klanjeya sanya kwilaa yɨmbat. Jon waa Mak walɨnja nyan kat kwutaa kalimbɨt Banasawi Solo. ");
INSERT INTO ian_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokmba lɨga Godna yelangɨna nat nɨmba God waa nyaangɨt mbutɨndi. Ndina nat nɨmba vɨsɨmogwindi Godna vat. Ndi kat vɨga lɨgiyaa njambwi nɨmbana sɨ kɨngiyan. Banabas, Saimon waa Naija walɨnja nyan. Lusias Sairinina nyan, Manaen, Herot antipasna kɨta lɨvɨ nyan, Sol. ");
INSERT INTO ian_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nao kɨlapman tɨlɨnja Godna sɨ kwusolɨndi maa Godna waagan ndi kat wandɨ. Ngwut aywaa Banabasawi Sol kat ambuk. Wan njɨvwa kwukambɨk mbɨk kat waigowun waa ambuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wandɨ maa nao kɨlapman tɨga God kat ngambulaa mbɨk kat taamba taagalaa mbɨk kat wandi. Ay mbɨla waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Godna waagan mbɨk kat ay wandɨ maa wan ngepma Selusiat ndaimbɨt. ndailaa njaambɨt kulaa Saiaras walɨnja nɨmbuk nat yɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yilaa nat ngepma yigaa kawindi. Wan ngepma Salamis walɨnja ngepma. Salamisna Juda yisolaa lɨnja ngaymba God waa nyaangɨt mbupmbɨk. Wan kwandɨ nyan Jon mbɨtnanala njɨvwa kwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Saipris walɨnja mat nɨmbuk kawilaa palɨngweya yiga ngepma ngepma yiga waambumba la ngepma Pafos walɨnja ngepma wuleindi. Wan ngepmamba la nyan yeno kwutɨga nyan kat yiga vɨndi. Ndɨ Juda. Woseka waa nyaangɨt mbutɨndɨ. Ndɨna sɨ Bar Jisas. ");
INSERT INTO ian_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wan yeno kwuta nyan wan ngepmana njambwi nyanonala tɨndɨ. Njambwi nyana sɨ Sesas Polas. Sesas Polas nɨma nambuo lɨga nyana. Banabasagwi Sol kat wandɨ. Yalaa wun kat God waa nyaangɨt ambuk. ");
INSERT INTO ian_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yeno kwutɨga nyan ndɨna nat sɨ Elimas wupmak kat kai wandɨ. Njambwi nyan Jisasna kwundi wupmak kat Elimas kai wandɨ ndɨ kat. ");
INSERT INTO ian_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Solna nat sɨ Pol. Godna waagan ndɨ kat tavindɨ maa lɨmbaga yeno kwuta nyanat vɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Vɨlaa Pol wandɨ. Woseka walɨgamɨn wan nyaangɨt. Kavle nyaangɨla mandɨp mandɨp walɨma. Mɨn Setena nyan mɨn. Apma vat yetɨlɨnja vak kat kai waa walea lɨgamɨn. God waa apma nyaangɨt kai waa kwagalalaa kavle vatmba kwutaa lɨvat yelavɨpmɨn. Manda kat wupma lɨgamɨn. ");
INSERT INTO ian_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wungi kat tɨga God mɨn kat kavle vat yigyandɨ. Mɨna mɨni kavle yigiyandɨ. Apma mɨni ana vɨlɨgiyamɨn. Samat tɨga nya ana vɨgiyamɨn waa wandɨ Pol. Pol wandɨ maa Elimasna mɨni mbaw kwutɨ, ana vɨndɨ. Ndɨna taambamba kwutaa ava yambɨ sɨmogwigiyaa nɨmba kat kwaka lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wan ngepmana njambwi nyan Pol kwuta njɨvwa kat vɨlaa yelavɨtndɨ. Pol kwoduo lɨga nyana waa yelavɨtndɨ. Jisas waa nyaangɨt Pol mbuta nyaangɨt ndɨna nambu mbɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ndɨnanala lɨga yeta nɨmba njambɨt kulaa Pafos walɨnja ngepma kwagalalaa Pega walɨnja ngepma valɨngendi. Pega Pamfilia walɨnja nɨma kɨpmamba lɨga ngepmat. Wan ngepmamba Jon waa Mak walɨnja nyan mbɨk kat kwagalaa Jerusalemat yindɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mbɨk Pega kwagalalaa Antiok walɨnja ngepmat wuleimbɨt. Wan wuleimba ngepma Antiok Pisidia walɨnja nɨma kɨpmamba lɨga ngepma. Njɨvwa lapman nandinyamba Juda yisola lɨnja ngay wuleilaa ndalɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wan ngay kat vɨga la nyan lataa tamba Moses pɨlɨwuta nyaangɨt vɨlaa mbutɨndɨ. Tamba la God waa nyaangɨt mbuta nɨmba pɨlɨwuta nyaangɨt vɨlaa mbutɨndɨ. Mbutaa mbɨk kat wandɨ. Wuna yakwa nyan mbɨt. Nɨna maawut kwunakiya nyaangɨt tɨndeyan ambuk waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Wandɨ mala Pol laatndɨ. Laata taamba taagalaa awuk waa wandɨ. Wuna kɨta yelangɨ nɨmba Isrel wuna nyaangɨt awut. Juda ana ngwuk nat nɨmba. God kat yelavɨpmak yisolaa lɨga nɨmba ngwulo awut. ");
INSERT INTO ian_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tamba God Isrel walɨnja nɨmba kat vɨga lɨndɨ. Nɨna ngwak walanga kat God yagwa wandɨ. Juda angwa ngepma kwagalalaa Isipmba yiga Lɨlɨndi maa God ndi kat apma vat yilɨndangat nɨma sakwat yɨndi. God ndɨna kwondumba ndi kat kwutaa nat ngepmat kalindɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","naambi ndumi vɨli kwo nɨndi kavamba yetɨndi. Wan yetɨlɨnja njɨmbla ndi God kat kai walɨndi. God kat kai walɨndi maa God ndi kat ana kai walɨndɨ. Ndina lak kwaalɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wan Kenen walɨnja kɨpmamba ngepma nɨmba ndina kwundi sɨlavɨli mɨna lɨndi. Ndi kat aywaa God sɨndɨ. Sɨndɨ maa nɨna ngwat walanga wan kɨpma klalaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wan kɨpmamba naambi 450 tɨndi. Tɨga lɨga ndi kat vɨga lɨgiyaa nɨmbo God ndi kat taagandɨ. Vɨga la nɨmbana kwupmba la nyana sɨ Samyuel. ");
INSERT INTO ian_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tɨga lɨga wan nɨmba God kat wagala lɨndi. King nɨn kat agwi. Nɨn kat vɨga lɨgiyandɨ waa wandi. Wandi maa God ndi kat Sol kwindɨ ndina Kingnat tɨndangat. Sol Kisna nyana. Ndɨna yelangɨ Bensamin. Sol Kingnat tɨga lɨga naambi ndumi vɨlɨlɨk ndi kat vɨga lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sol kat kai walaa God Devit ndina Kingnat tɨndangat wandɨ. God Devit kat kupma wandɨ. Devit Jisina nyan wuna mawupmba yetɨlɨgandɨ. Ndɨ kat woviyaguga lɨgowun waa wandɨ God Devit kat. ");
INSERT INTO ian_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tamba God wandɨ. Isrel walɨnja nɨmba kat ngɨni kwunakiya nyan kwigiyowun ngwuk kat waa wandɨ God. Wanda vapmba God Jisas Devitna yelangɨ nyan kwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tat Jisas yalapman ta njɨmbla Jon Isrel kat mbutndɨ. Kupi maawut sɨkngweyan ngwuk kat ngumba yagugiyowun waa mbutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jona njɨvwa tamba ngɨlɨ mɨna lɨgandɨ ndinyangu kat wandɨ. Wun kat anda nyana waa yelavɨtɨgangwuk. Samat tɨga kawiga lɨngwa nyan yaigandɨ. Ndɨ njambwi nyana. Wun mat nyan wun. Wun mat nyana tɨwangat ndɨna njɨvwa ana yigumba kwugiyowun. Ndina man suna yaaw ana yigumba njalakiyowun waa wandɨ Jon. ");
INSERT INTO ian_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ngwuk wuna yakwa nɨmba, Ebrahamna yelangɨ nɨmbawi Juda ana ngwuk God kat yelavɨpmak yisola lɨga nɨmbo ngwuk kat God apma vat tamba yindɨ. Ngwuk kat kwunakiyaa nyaangɨt God nɨn kat kwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalemba lɨga nɨmba, njambwi nɨmba Jisas ndi kat kwunapmak yanda vat ana vɨga lɨndi. Njɨvwa lapma nandinyamba aywaa God waa nyaangɨt mbutɨga nɨmba pɨlɨwuta nyaangɨt vɨlɨgandi. Maawupmba ana yelavɨkandi. Tamba God waa nyaangɨt mbutɨga nɨmba pɨlɨwutndi. Ngɨni Jisas kat ndɨ kat vatnya waa waigandi. Pɨlɨwutnja nyaangɨtmba wan vak yindi. ");
INSERT INTO ian_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jisas kavle vak ana yilɨndɨ. Juda Pailat kat vatnya waa kwo wandi. ");
INSERT INTO ian_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tamba la God waa nyaangɨt mbutɨga nɨmba pɨlɨwuta nyaangɨtmba Jisas kat yɨndi. Jisas kiwai krosmba tɨndɨ maa ndɨ kat kwutaa vaangundi. ");
INSERT INTO ian_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","God wandɨ maa Jisas kiyalaa laatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jisas laatndɨ maa ndɨnanala ngepma ngepma yi ya yetɨla nɨmba ndɨ kat vɨlɨndi. Galili kwagalalaa yiga Jerusalemat wokendi. Mbambala wan nɨmba walɨgandi. Jisas kiyala laatndɨ. Vɨnɨn wa walɨgandi. Isrel ta nɨmba kat walɨgandi. ");
INSERT INTO ian_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Anogwi wungivat sɨgɨt. Ngwuk kat wan apma nyaangɨt mbupmat tɨga. Tamba God nɨna ngwat walanga kat wandɨ. Ngɨni ngwuk kat apma vat yigiyowun waa wandɨ. Mbambala ndina walanga nɨn kat God apma vat tamba yindɨ. Tamba la nyan vɨlɨlɨk wan Sam walɨnja mbangu kwundi God Jisas kat waa nyaangɨt pɨlɨwutndɨ. Mɨn wuna nyan mɨn. Mbambala wuna njɨvwa kwupmak kat mɨn kat kwondu kwilaa taagawun waa wandɨ God waa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God tamba la nyan kat wandɨ. Godna nyan Jisas kiyalaa laatndangat wandɨ. Kiyalaa ndɨna sɨm ana njangu veilaa ngɨlɨgiyandɨ wandɨ. Wandɨ ma pɨlɨwutndɨ. Devit kat apma vat kwigiyowun wanda vat kwigiyowun. Ana woseka waigowun waa wandɨ God waa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nat naangamba pɨlɨwutndɨ. God wamɨn mala mɨna njɨvwa kwutɨga apma nyan kiyalaa ana njangu veiga ngɨlɨgiyandɨ. waa pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devit ta njɨmbla Godna njɨvwa kwutɨndɨ. Pɨlɨwuta nyan Devit ta njɨmbla Godna njɨvwa kwutɨndɨ. Pɨlɨwuta nyan Devit kat ana pɨlɨwutndɨ. Devit kiyandɨ mala ndɨna ngwak walanga kwo kavamba vaangundi. Ndɨna sɨm njangu veiga ngɨlɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pɨlɨwuta nyan mandɨt nyan kat pɨlɨwutndɨ. Kiyalaa sɨm njangu veilapman nyan kat pɨlɨwutndɨ. Wan nyan kiyalaa God wandɨ, laatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ngwuk yakwa nɨmba wan Jisas kat vɨngwangat wowun. Jisas kwuta njɨvwa vɨlaga ngwuna kavle vat yiga yetɨngwa vat God ngwuk kat kwuakiyandɨ. Ngi nyaangɨtna ngwuk kat mbutɨwa. Wan kavle vat ngwuk kat ngilaa lɨgandɨ. Moses kwiya nyangɨtmba yetɨngweyan wan kavle vak ana ngɨlɨgiyandɨ. Jisas kwutaa njɨvwa kat wuna lak yaandɨ waa wangweyan wan kavle vak ngɨlɨgiyandɨ. Ana ngilaa lɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yigumba vɨga alɨmba ngwuk. God waa nyaangɨt mbuta nɨmba tamba la nɨmba pɨlɨwuta nyaangɨt ngwuk kat yilandɨ. ");
INSERT INTO ian_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ndi God waa nyaangɨt pɨlɨwutndi. Yigumba vɨga alɨmba ngwuk. Ngwula mbangɨ manda kat kɨlɨpangɨ yigandɨ. Waluwa vat maawupmba yelavɨtapman yingweyan kiyaigangwuk. mbambala nɨma njɨvwa kwutɨgowun ngwuk kat. Kwutuwa njɨvwa vɨlaa ngwula mbangɨ kɨlɨpangɨ yigiyandɨ. Nat nyan kwututwa njɨvwa kat ngwuk kat vɨsɨmogwindeyan ngwula mbangɨ kɨlɨpangɨ yɨgiyandɨ waa wandɨ God waa tamba pɨlɨwutndi waa wandɨ Pol. ");
INSERT INTO ian_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol wandɨ mala Polawi Banabaso yisola lɨnja ngaymba tɨga lɨga wogwelɨmbɨt, mbɨk kat vɨlaa wandi. Njɨvwa lapman tɨneya nandinya yandɨ maa yagwamba mbɨt nɨn kat mbupmat waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nat nɨmba mbɨla kwupmba wogwelaa lɨndi. Judagwi Juda ana ndi nat nɨmba wogwelaa lɨndi. Juda ana ndi nat nɨmba wogwelaa lɨndi. Juda ana ndinat nɨmba Juda yeta vapmba yetɨndi. Ndi kat ngambuliya nyaangɨt ngwula maawut ke tɨvɨndi. Ndi kat ngambuliya nyaangɨt ngwula maawut ke tɨvɨnda. Kwutaaa alɨmba ngwuk. God ngwuk kat awagapma apma vat yindɨ waa mbutɨli. Wan nyaangɨk kat ngwuk yelavɨpmba ngwuk waa wambɨk. ");
INSERT INTO ian_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nat njɨvwa lapman nandinya yandɨ maa wan ngepmana nɨmba aywaa yisola lɨndi. God waa nyaangɨt mbupmbɨk, wupmak yisola lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nɨma sakwat nɨmba Pol kat yɨndi. Nat Juda yinjangat vɨlaa yelavɨtndi. Wan nɨmba tat nɨnagwinala lɨndi. mbambala Polna kwupmba yigandi. Kavle vatna yinja wa yelavɨtndi. Wan vak yelavɨtaa Pola waa nyaangɨk kat kai wandi. Ndɨ kat njɨka wandi. ");
INSERT INTO ian_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Njɨka wanja vak kat Apolagwi Banabaso ana vaaka lɨmbɨt. Nɨma kwundimba wambɨt. God waa nyaangɨt Juda ngwuk kat mbupmat tat yali. Apma vatna tat ngwuk kat mbupmat yalia. Ngwuk kai wangwuk. Wungi kat tɨga Juda ana ndi nat ɨmba kat yiga mbukiyaa. Apma vat njɨmbla njɨmbla tɨngweya vak kat ngwuk kai wangwuk. ");
INSERT INTO ian_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ana mawupmba yelavɨtaa ana yiga mbupmak yali Juda ana ndi nat nɨmba kat. Juda ana ndi ndi kat mbupmat tɨgangwuk. Ngwuk nya vla lɨgangwuk. God ndi kat kwunakndeya vak kat sɨmogwivat tɨgangwuk waa wandɨ God waa tamba pɨlɨwutndi waa wandɨ Pol. ");
INSERT INTO ian_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mbutiya nyaangɨt Juda ana ndi nat nɨmba wutaa solat sɨga nolin ngwandɨga wandi. God waa nyaangɨt apma nyaangla waa wandi. God nat nɨmbana maawutmba wandɨ mala wan nyaangɨk kat yelavɨtaa kwutaa lɨndi. Maawupmba kwutaa lɨga apma vat njɨmbla njɨmbla yetɨlɨnjeya vak kat klandi. ");
INSERT INTO ian_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Wan nɨma kɨpmana ngerpma ngepma kat yiga God waa nyaangɨt mbuk kɨva mbutndi. ");
INSERT INTO ian_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nat Juda Polagwi Banabasna sɨ kat viyesandavat wandi. Wan ngepmanana nɨma nɨmba kat yɨga wandi wan kavle nyaangɨt. Juda ana ndi nat nɨmbana njambwi lagwa kat yɨga wandi wan kavle nyaangɨt. Juda ana ndi nat nɨmba God kat ndina maawupmba yelavɨka lɨndi. Wungi kat tɨga wan ngepmana nat nɨmba Polagwi Banabas kat nɨma vapmba yɨga mbɨk kat kɨklindi maa ngepma kwagalalaa yimbɨkt. ");
INSERT INTO ian_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","God waa nyaangɨt mbuta mbɨt nyan wan ngepmamba lɨga man su lɨgiyataa viyalɨmbit tɨpmwigwula yiga. Ngwuk wupma lɨgiyangwuk. Tɨga kiyalaa kavle savle yigiyangwuk waa yelavɨtaa su viyalɨmbɨt. Wan ngepma kwaglalaa Aikoniamat yimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wan ngepma Antiokmba Jisasna mbaapmamba lɨga nɨmba solat sɨga nolin ngwandɨga lɨndi. Godna waagan ndinamba tavilaa lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Antiok kwagalaa Aikoniam yimbɨt. Antokmba mbupmba nyaangɨt mbupmbɨk. Pologwi Banabaso Juda yisolaa lɨnja ngay wuleilaa mbupmbɨk. Wan ngaymba yisolaa lɨga mbutɨmba nyaangɨt wuti. Juda nɨma sakwat Juda ana ndi nat nɨmba nɨma sakwat wutaa maawupmba yelavɨka kwutaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nat Juda maawupmba yelavɨka wan nyaangɨt kwupmak kat kai walɨga Juda mbɨk kat kai walɨndi. Wundi Juda Juda ana ndi nat nɨmba kat wandi. Mbɨtnai mbutɨga nyaangɨt apma nayaangɨt ana ndɨ. Ke wukngwa. Mbɨk kat kai wangwuk yigaambɨt waa wandi. Wandi maa Juda ana ndi nat nbɨmba nɨma sakwat mbɨk kat kai waa walɨndi. Jisasna yelangɨmba lɨga vɨlɨlɨk palɨ kat kai waa walɨndi. ");
INSERT INTO ian_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wungi kat tɨga God waa nyaangɨt mbutɨga mbɨt nyan wan ngepmamba nɨma sakwat ngan nandinya tɨga mbutɨmbɨt. God waa nyaangɨt mbutɨga mbɨt nyan wan ngepmamba nɨma sakwat ngan nandinya tɨga mbutɨmbɨt. God kwiya kwondumba nɨma njɨvwa kwuka yelogwen kat ta nɨmba kat kwunatɨmbɨt. Kwunapmba vat vɨlaa wan ngepmamba lɨga nɨmba yelavɨtndi. Mbutɨmba nyaangɨt ana woseka walɨmbɨt. God mɨn kat awagapma kwunatndangat mbutɨmba nyaangɨt ana woseka walɨmbɨt waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wan ngepma mbaapma vɨlɨlɨk kalɨtaa tɨndi. Nat mbaapma nɨmba Judanala kwaga God waa nyaangɨt mbutɨga mbɨt nyan kat kai walɨndi. Nat mbaapma nɨmba mbɨlɨnala tɨga mbutɨmba nyaangɨt wutɨndi. ");
INSERT INTO ian_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wan ngepmana kaiwalɨga Juda, kai walɨga Juda ana ndi nat nɨmba, ngepmana nat njambwi nɨmba yelavɨtndi. Mbɨk kat nɨma vat yigiyanɨn. Mbɨk kat kaambapmba yaagiga viyaga vatnyagiyanɨn waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","God waa nyaangɨt mbutɨga mbɨt nyan kavle ytivat tɨnja vak kat wutaa wan ngepma kwagalalaa yimbɨt. Kwagalalaa ngepma vɨlɨlɨk ta kavat yimbɨt. Wan ngepma vɨlɨlɨkna sɨ Devi, Listra. Wan ngepma vɨlɨlɨk Laikonia walɨnja nɨma kɨpmamba lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wan ngepma vɨlɨlɨpmba wan apma nyaangɨt mbutɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra walɨnja ngepmamba man kɨvɨ watna nyan ndaalɨndɨ. Nyɨme kwutna njɨmblamba kɨvɨ wata lɨndɨ. Mamba veiga ana yi ya lɨndɨ. Kwo lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Wan nyan Pol mbuta nyaangɨt wutɨndɨ. Pol waa nyaangɨt wutaa ndɨna mbangɨ wiyo waavi taagandangat Pol vɨndɨ. God wan nyan kat alɨpsɨga kwunakiyandɨ waa Pol vɨndɨ. Wungi kat tɨga ndɨ kat vɨlaa nɨma kwundimba wandɨ. Laataa man vei wandɨ. Pol wandɨ mala kwiyatapman laatsaa man veiga yi yalɨndi. ");
INSERT INTO ian_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wan ngepmana nɨmba Pol wan nyan kat kwunatnda vak kat vɨlaa ndina angwa kwundimba waga ngambulɨndɨ. Waagan ndinyanguna mbangɨ klalaa yaa ngambulɨgambɨt waa ndina angwa kwundimba ngambulɨndi. ");
INSERT INTO ian_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabas kat wandi. Mɨn Sus walɨna waagan mɨn waa wandi. Pol kat wandi. Mɨn Hemis walɨna waagan mɨn waa wandi. Pol tata lɨga nyan tɨga nyaangɨt ngambulɨndangat Hemis waa sɨ kwindi. ");
INSERT INTO ian_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sus kat kwunatɨnja ngay ngepma tɨvwi nat naangamba lɨndɨ. Wan ngay kat vɨga la nyan bulamakau klalaa mɨna mwe pangwugaa klalaa kwutaa iɨvwina suwimba kiyandɨ. ndɨnagwinala yetɨga nɨmbagwinala mbɨk kat kwunapmak kwivat wandi. ");
INSERT INTO ian_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Polagwi Banabaso yɨlɨnja vat vɨlaa wan vak kat kai walaa mbɨtna waavwi ngɨlɨpɨk. Waavi ngɨlɨtaa ndina nɨndɨmba yɨga lɨga walɨmbɨk. ");
INSERT INTO ian_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Wan vak manda kat yigiyangwuk. An ndu nyan li. Ngwutnai lɨga vla tɨgali. Ngwuk kat apma nyaangɨt mbupmak yali. Wan apma nyaangɨt wutaa kavle vat yeltɨlɨngwa kwo vak kwagalalaa God kat ngwula maawupmba yelaɨka kwutaa yetɨgiyangwuk. Mbutɨlɨiya God kwo lɨgandɨ. Ana kiyandɨ. Nyɨnangwut, kɨpma, ngu aywaa kwutndɨ. Nyɨnangwut kɨpma, ngumba yetɨlɨga nda aywaa kwutndɨ. Tamba ndinyangu kat wandɨ. Ngwutna maawupmba yetɨ waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","17","God kwo lɨga ngwuk kat vɨsɨmogwilɨgandɨ. Ngwuk kat apma vat yilɨgandɨ. Meik kwilɨgandɨ. Ambugava apma vat kɨgɨnda watndangat kwilɨgandɨ. Ngwutna maawupmba nolin ngwandɨngwa vak kwilɨgandɨ. Apma vat ngwuk kat yelɨnda vat vɨlaa yelavɨtɨgangwuk. God tɨgandɨ waa yelavɨtɨgangwuk. ");
INSERT INTO ian_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","God mbutɨgaa nyaangɨt mbutɨga mbɨt nyan wan nyaangɨt mbutɨmbɨt. Angat kwunapmak ke kwiga waa wambɨt. Nɨma njɨvwa kwuka kwunapmak tɨnja vak kat viyesandaga ndi kat kwulapmbɨk. Wan vak ana yindi. ");
INSERT INTO ian_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pisidiamba lɨga Antiok walɨnja ngepmamba la ndi nat Juda lataa Aikoniamba la ndi nat Juda laataa mbɨla kwupmba Listra yindi. Pol kat yiga kavle nyaangɨt ngambundi. Ngumbundi maa ndinai waa nyaangɨt wutndi. Wutaa kwutaa lɨndi. Tɨga lɨga Pol kat vatnyavat kambak klalaa viyavat yaagindi. Yaagigaa ndi kat viyalaa yelavɨtndi. Tamba wundumbu yindɨ waa yelavɨtaa ndɨ kat kwutaa mbundi lɨvwat kalindi, tɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pol mbuta nyaangɨt wutaa kwutaa la nɨmba ndɨna sɨm kwutaa kalivat yandi. Tɨnda kava yiga wogwendi, Pol laatndɨ. Laatndɨ maa ngepma wuleindi. Nat nandinya wan ngepma kwagalalaa Debi walɨnja ngepmat yimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Debimba Pologwi Banabaso wan apma nyaangɨt mbutɨmbɨk. Nɨma sakwat nɨmba kat kwutaa Jisasna mbaapmamba taagambɨt. Wan ngepma kwagalaa Listra lungwamataa yimbɨt. Listra kwagalaa Pisidiamba lɨga Antiok walɨnja ngepmat lungwamataa yimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ngepma ngepmamba God waa nyaangɨt kwutaa lɨga nɨmbana maawut kwunapmak ngambumbɨk. Ndi kat wambɨk. Wan apma nyaangɨt ke kwagalaga. Nɨma vat nɨma sakwat ngwuk kat yaigandɨ. Nɨmamba ke yelavɨka. God ngwuk kat apma vat kwindeya vat ngɨni yaigandɨ waa wambɨk. ");
INSERT INTO ian_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ngepma ngepma Jisasna yelangɨ nɨmba kat vɨga lɨgiyaa nyaan kat kɨta kɨta taagambɨt. kɨgɨnda kwagalalaa God kat ngambuga ndi kat wambɨt. Njambwi nyan waa nyaangɨk kat nɨmamba kwutaa alɨ. Ke twagalaga waa wambɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia walɨnja nɨma kɨpmana nat naangɨmba lɨga nat naangat valɨgembɨt. Valɨgelaa pamfilia walɨnja nɨma kɨpma yambɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pega walɨnja ngepmamba Godna apma nyaangɨt mbutaa Atila walɨnja ngepmat ndaimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atilamba lɨga njaambɨt kulaa Antiokat yimbɨt. Tat wan ngepmamba la Kraistna mbaapmamba la njambwi nɨmba mbɨk kat wandi. God waa apma nyaangɨt yiga mbukiyambɨt. Mbupmbeya kwondu God mbak kat kwigiyandɨ waa wandi. Wanja nyaangɨtmba tamba yimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiok wuleilaa Jisasna yelangɨ nɨmba kat wambɨk. yagwa. Kumba yaa yisolaa lɨ ngwula. Yisolaa lɨndi maa ngepmamba God apma vat yinda vak kat mbutɨmbɨt. Ngepma ngepma yimbangat God mbɨk kat yambɨ kwutndɨ. Juda ana ndi nat nɨmba wan apma nyaangɨt wutaa nɨmamba kwutaa lɨnjangat mbutɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Antiokmba nɨma njɨmbla tɨlɨmbɨk Jisasna mbaapma nɨmbanala. ");
INSERT INTO ian_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jerusalemba la nat nɨmba Antiok yala Jisasna yelangɨ nɨmba kat wandi. Moses kwiya lomba ngwutna mbangɨ pɨtapman yɨngweyan God ngwuk kat ana kwunakiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","pologwi banabaso laataa ndi kat kai walaa nɨma nyaangɨt ngambumbɨt. Tɨga lɨga ngambulɨmbɨt maa yelavɨtndi. Pol, Banabas, Antiokmba la nat nɨmba Jerusalem yigiyandi waa yelavɨtndi. Jerusalemba lɨga Aposel nat Jisasna mbaapmamba la njambwi nɨmba kat yiga wagalavat tɨndi waa yelavɨtndi. ");
INSERT INTO ian_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wan ngepmamba la Jisasna yelangɨmba la nɨmba ndi kat sanya kwindi maa kwutaa yindi. Ngepma ngepma yiga Juda and ndi nat nɨmba God waa nyaangɨt kat nɨmamba kwutaa lɨnjangat mbutɨndi. Jisasna mbaapma nɨmba wutaa lɨga apma nyaangala waa woviyaguga lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem wuleindi maa Jisasna yelangɨ nɨmba apma nandinya waa nɨma sakwat kɨgɨnda kwiga woviyaguga lɨndi. Wan aposel wan mbaapmana nɨma nɨmba ndino wupma yilɨndi. Ngepma ngepma yiga God ya vak kat mbutɨndi. ");
INSERT INTO ian_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jisasna mbaapmamba la nat nɨmba Ferisi yetɨla vapmba yetɨgaa nɨmba laataa wandi. Ndina mbangɨ pɨtapman Moses kwiya lomba yetɨlapman yinjeyan God ndi kat ana kwunakiyandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wandi maa Aposelo nat nɨma nɨmbo wan nyaangɨt ngambuvat yisolaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sɨvla mbundɨ ngambulɨndi maa Pita laataa wandɨ. Mbaapma nɨmba. Tamba ngwutna kɨta nyanat tɨwun, God wun kat wandɨ. Juda ana ndi nat nɨmba kat wuna apma nyaangɨt kwutaa yiga ambuk waa wandɨ God. Vɨlɨgangwuk. Wutaa nɨmamba kwutaa lɨnjangat yiga wan apma nyaangɨt mbutɨwun. ");
INSERT INTO ian_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God ndu taagwana maawut vɨlɨgandɨ. Juda ana ndi nat nɨmbana maawut vɨlaa ndɨna waagan ndi kat kwindɨ. God ndi kat waagan kwinda vat vɨlaa yelavɨtnɨn. God ndi kat ana kai wandɨ waa yelavɨtnɨn. God nɨn kat waagan kwiya vat vla ndi kat kwindɨ. Vɨlɨganɨn. ");
INSERT INTO ian_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","God kapma kapma vapmba ana yindɨ. Juda kat Juda ana ndi nat nɨmba God waa nyaangɨt wutaa ndina mbangɨ wiyo waavi taagandɨ maa God ndina kavle vat sɨlɨmbwindɨ. ");
INSERT INTO ian_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","God waa vak kwagalaaa ngwuk manda kat mandɨk vapmba yivat wangwuk. Juda ana ndi nat nɨmba kat manda kat nɨma njɨvwa kwivat wangwuk. God wupma ana wandɨ. Nɨna ngwak ndu wan nɨma njɨvwa ana kwutɨndɨ. Moses waa vapmba ana alɨpsɨga yetɨndi. Nɨno wupma ana alɨpsɨga yetɨgiyanɨn. ");
INSERT INTO ian_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kai luwa. Wan vak kavle vat. Jisas nɨn kat waa kwutaa njɨvwa kat nɨna mbangɨ wiyo waavi laagandeyan God awagapma nɨn kat kwunatɨgandɨ. Ndino wupma waa wandɨ Pita. ");
INSERT INTO ian_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Polagwi Banabaso mbɨlo ndi kat nyaangɨt mbutɨmbɨt. Polagwi Banabaso mbutnda nyaangɨt kwo wuka kwagalandi. Juda ana ndi nat nɨmba kat yiga mbutɨmba vak kat mbutɨmbɨk. God mbɨk kat kwondu kwindɨ maaa nɨma yelogwengat ta nɨmba kat kwunatɨmba vak kat mbutɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mbupmbɨt mala Jems laataa wandɨ. Mbaapma nɨmba wunai waigaa vak awuk. ");
INSERT INTO ian_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita waa Saimon walɨnja nyan laataa mbutndɨ, wukngwuk. God Juda ana ndi nat nɨmba kat kwutaa ndɨna yelagɨmba taaganda vat mbutɨndɨ, wukngwuk. ");
INSERT INTO ian_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tamba God waa nyaangɨt mbuta nyan wan nyaangɨt pɨlɨwutndɨ. Kapma nyaangɨt ana ndɨ. Kɨta nyaangɨtna. ");
INSERT INTO ian_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","Tamba pɨlɨwutndɨ. Samat tɨga yɨlaa lungwamataa yaigowun waa God wandɨ. Kavle vat yiga yetaa ndi Juda kwunakiyowun. Ndi Juda ngay vla lɨgandi. Wan ngay tamba kavle yindɨ. Wun kwunakiyowun. Kwunakwun maa wan nɨmba Juda ana ndi wun kat kwaka kawiga lɨgiyandi. Wun God wun. Ngepma ngepmamba lɨga nɨma sakwat nɨmba kwutaa kiyaa wuna yelangɨmba taagagiyowun waa wandɨ God waa tamba pɨlɨwutndɨ. ");
INSERT INTO ian_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Wuno wupma yelavɨka lɨgowun. Juda ana ndi nat nɨmba God kat yalɨga nɨmba ndi kat nɨma njɨvwa waa kwigiyanɨn. Juda yeta vapmba yetɨ ana ndi kat waiganɨn. ");
INSERT INTO ian_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ndi kat pas pɨlɨwukiyanɨn. Wan pasmba ndi kat waiganɨn. Waagan kat kelonja wɨmbu nda ke kɨga waiganɨn. Yambɨsɨk kwuka ke yetɨga waiganɨn. Yelogwen ke kɨga waiganɨn. Nambu kwunjɨngwendi kiyaiga ndana wɨmbu ke kɨga waiganɨn. ");
INSERT INTO ian_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Wan wawa vak yinjeyan Moses kwiya nyaangɨt kwagalagiyandi waa ke yelavɨka. Njɨvwa lapman tɨgiyaa nandinya aywaa Juda yisola tɨnjeya ngaymba la nɨmba laataa Moses kwiya nyaangɨt mbutɨgandi. Ngepma ngepmana nɨmba kat wan nyaangɨt mbutɨgandi. Ana ngɨlɨgiyandɨ. ");
INSERT INTO ian_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aposelo Jisasna mbaapmamba la njambwi nɨmbo nat nɨmba kat sɨmogwindi. Polagwi Banabasanala Antioknat yinjangat sɨmogwindi. Jutas waa Basabbas walɨnja nyan, Sailas, nat vlɨlɨlɨk palɨ kat sɨmogwindi. Wumbɨt vɨlɨlɨk palɨ kat wandi. Apma nyan mbɨt waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Sɨmogila nɨmba kat wan pas kalinjangat kwindi. Wan pasmba lɨga nyaangɨt kɨngiyan. Nɨn Aposel, njambwi nɨmba, ngwutna mbaapma nɨmba nɨn wan pas ngwuk kat pɨlɨwutɨganɨn. Ngwuk Juda ana ngwuk nat nɨmba Antiokmba, Siriamba, Silisiamba lɨga nɨmba ngwuk ngwuk kat wan pas pɨlɨwutɨganɨn. Ngwuk nɨna mbaapma nɨmba ngwuk. ");
INSERT INTO ian_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nɨna ngepmamba la nɨmba yilaa ngwuk kat nyaangɨt mbutndi. Mbutnja nyaangɨt wutaa ngwula maawut nɨma vak yelavɨkngwuk. Wanɨn maa ana yindi. Ndi kwo yindi. ");
INSERT INTO ian_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Wungikat tɨga mbutnja nyaangɨk kat kawiga yisolaa lɨganɨn. Yisolaa lɨga ngwuk kat mbukiya nɨmba kat vɨsɨmogwinɨn. Nɨna ava nɨmba Pologwi Banabasagwinala yigiyandi. Pologwi Banabso Jisas Kraistna njɨvwa kwutɨga nyan mbɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Wan njɨvwa kwuka yiga tɨga kiya mɨna lɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wungi kat tɨga wanɨn maa Jutasagwi Sailaso ngwuk kat yigiyambɨt. Wan pasmba pɨlɨwutna nyaangɨt ngwuk kat yigiyambɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Godna waagan nɨna maawut ngwandɨndɨ maa yelavɨtnɨn. Ndi kat nɨma njɨvwa ana kwigiyanɨn. Kai walɨna nyaangɨt aynat ngwuk kat kwigiyanɨn. ");
INSERT INTO ian_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Waagan kat kelonja wɨmbu ke kɨga. Yelogwen ke kɨga. Yambɨsɨk kwuka ke yetɨga. Wan vak kwagalaa yetɨngweyan apma vak yetɨgiyangwuk. Yigumba alɨ ngwula waa pasmba pɨlɨwutndi. ");
INSERT INTO ian_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sɨmogwinja nɨmba Antioknat yindi. Ngepmat yilaa wandi. Yagwa yisolaa lɨgat. Jisasna mbaapma nɨmba yisolaa lɨndi maa ndi kat pas kwindi. ");
INSERT INTO ian_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pasmba la nyaangɨt vilaa apma nyaangla waa solat sɨga wogiyagua lɨndi. Wan pasmba la nyaangɨt ndina maawut kwunatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jutasagwi Sailaso God waa nyaangɨt mbutɨgaa nyan mbɨt. Wungɨ kat tɨga njɨmbla njɨmbla Jisasna mbaapma nɨmba kat mbutɨmbɨt. Mbutɨmbɨt maa ndina maawut apma vat tɨndɨ. Kwutɨnjeya, ndina maawuk kat kwunapmbɨk. ");
INSERT INTO ian_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Simogwila nɨmba wan ngepmamba samat tɨga Jerusalemat lungwamata yindi. Wan ngepmamba la Jisasna mbaapma nɨmba ndi kat yigumba aymba ngwuk waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pologwi Banabaso Antiokamba nɨma sakwat nandinya kawiga lɨmbɨt. God waa nyaangɨt, ndi kat sɨmogwiga mbutɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tɨga lɨga Pol banabas kat wandɨ. Ngepma ngepma yiga Jisasna mbaapma wuleila nɨmba kat yiga vɨli. Tat God waa nyaangɨt yiga kwiliya ngepma ngepma yiga vɨli. Wan nɨmba tɨnja vat yiga vɨli waa wandɨ Pol. ");
INSERT INTO ian_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Wandɨ maa banabas wandɨ. Jon waa Mak walɨnja nyan anogwionala yaigandɨ waa wandɨ banabas. ");
INSERT INTO ian_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jon waa Mak walɨnja nyan mbɨlogwionala yivat yindangat Pol kai wandɨ. Tamba wan nyan mbɨk kat nɨndɨ ava yambɨmba kwalalaa lungwamataa yindɨ. Mbɨk kat Pampiliamba lɨga kwagalaa Jerusalemat yindangat Pol kai wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wungi kat tɨga kimbut yiga nɨma nyaangɨt ngambuga lɨga kapma kapma yambɨ yimbɨt. Kimbut yimba vat kwiya tapman yandɨ. Banabas Mak kat kwutaa njaambɨt kulaa kɨta vat Saipras yimbɨt. ");
INSERT INTO ian_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol Silas kat kwutaa kɨta vat yimbɨt. Jisasna mbaapma nɨmba mbɨk kat wandi. Aymba mbɨt. God mbɨk kat kwondu kwigiyandɨ. God mbɨla lak kwaigandɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wandi maa Siriagwi Silisiana ngepma ngepma yimbɨk. Ngepma ngepmamba lɨga Jisasna mbaapma nɨmbana maawut kwunatɨmbɨk. ");
INSERT INTO ian_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol Debi walɨnja ngepmat yiga Listra walɨnja ngepmat yɨndɨ. Listra walɨnja ngepmamba Jisasna mbaapmamba la nyan kɨta lɨndɨ. Ndɨna sɨ Timoti. Ndɨna nyɨme Jisasna mbaapmamba la taagwak. Lɨ Judat. Ndɨna nyaek Juda ana ndɨ. Ndɨ Grikna. ");
INSERT INTO ian_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listramba lɨga Aikoniamba lɨga nɨmba Timoti kat apma nyana waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol Timoti kat wandɨ. Yagwa. Kɨta vat yili waa wandɨ. Wungi kat tɨga Judana vapmba ndɨna mbangɨ pɨtndi. Wan ngepma ngepmamba la ndi Juda Timotina nyaek Juda ana ndɨ, waa vɨlɨndi. Wungi kat tɨga ndɨna mbangɨ pɨtnjeyan Juda ndɨ kat kai ana waigandi waa yelavɨtndɨ Pol. ");
INSERT INTO ian_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ngepma ngepma yiga Jisasna mbaapma nɨmba kat mbutɨndi. Jerusalemba la aposelagwi njambwi nɨmbo kai wanja nyaangɨt mbutɨndi. Wan kavle vat kwagalalaa wan apma vapmba yetɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Wungi kat tɨga Jisasna mbaapmamba la nɨmbana maawut apma vat tɨndɨ. Ndi nɨma sakwat yilɨndi. ");
INSERT INTO ian_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Frisia walɨnja nɨma kɨpmana nat naangɨ kwagalalaa nat naangat yindi. Galesia walɨnja nɨma kɨpmana nat naangɨ kwalalalaa nat naangat yindi. Godna waagan ndi kat wandɨ. Wan nɨma kɨpmamba Esia walɨnja nɨma kɨpmamba wan apma nyaangɨt ke mbuka waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yiga lɨga Misia walɨnja nɨma kɨpmana nat naangɨ yandi. Yiga lɨga nat yambɨ yɨvat yelavɨtndi. Mbitinia yilɨnja yambɨ yivat yelavɨtndi. Jisas wandɨ maa, Godna waagan ndi kat wandɨ. Wan yambɨ ke yiga waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tɨga lɨga Misia wuleilaa Troas walɨnja ngepma yandi. ");
INSERT INTO ian_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Wan ngan Pol sɨmat vɨndɨ. masadoniamba la nyan vɨndɨ. Wan nyan laataa lɨga Pol kat walega wandɨ. Nɨna ngepma vala ya wandɨ. Nɨn kat yaa kwunap mɨla waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol sɨmat vɨlaa Masadonia yi mɨna lɨndɨ. Ndi kat wan apma nyaangɨt mbupmak yi mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas yilaa njambɨt kulaa Samotres walɨna ngepma valɨgenɨn. Kawilaa nat nandinya Neapolis walɨnja ngepma njaambɨtmba yiɨnɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Neapolismba njaambɨt kwagalalaa nɨmbumba valɨlaa Filipai walɨnja ngepma yinɨn. Filipai wan kɨpmanana angwa ngepma. Filipaimba Romba yaa nɨma sakwat nɨmba yetɨndi. Wan ngepma kat vɨga lɨndi. Wan ngepma nandinya kuvut tɨnɨn. ");
INSERT INTO ian_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Njɨvwa lapman nandinyamba wan ngepma kwagalalaa way ndandangɨ yinɨn. Way ndandangɨmba Juda anagandi yisolaa God kat ngambugiyaa waa yelavɨtnɨn. Ndalɨlaa wan ndandangɨmba ta taagwa kat vɨlaa wan apma nyaangɨt mbutnɨn. ");
INSERT INTO ian_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wutɨgat nat taagwana sɨ Lidia. lɨla ngepma Taiataira. Lɨla njɨvwa yelogwen mbangɨ waavi sanya klalaa kwiligalɨ. Tat God waa nyaangɨt wutaa nɨmamba kwutaa lɨlɨ. God lɨla maawut ngwandɨndɨ maa Pol waa nyaangɨt wutaa maawupmba yelavɨka kwutaa yetɨlɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lɨagwi lɨla ngaymba la nɨmbo ngu yagundi. Kɨta vat ngu yagundi. Nɨn kat walɨ. njambwi nyana nyaangɨt wutaa nɨmamba kwutaa lɨgowun. Woseka ana walɨgalɨ waa yelavɨkngweyan wuna ngayat yaigangwuk waa yawiga walɨ. Walɨ maa lɨla ngaymba yɨga lɨnɨn. ");
INSERT INTO ian_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kɨta nandinya yisolaa lɨga God kat ngambulɨnja kavat yinɨn. Wan kavamba sanya klalapman nat nɨmbana njɨvwa kwo kwutɨgaa taagwa vɨnɨn. Lɨ kat kavle waagan tavilaa tɨndɨ. Wan waagana kwundimba pogwula la nda kat vɨga mɨna mbutɨlɨ. Lɨ kat vɨga la nɨmba lɨlai kwuta njɨvwamba nɨma sakwat sanya klandi. ");
INSERT INTO ian_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Polagwi nɨnagwi yelɨnɨn. Nɨna kwupmba yalaa nɨn kat walega walɨlɨ. Wan nɨmba njambwi nyan Godna njɨvwa kwutɨgaa nɨmba ndi. Apma vat yetɨngweya vat ndinamba klaiyangwuk waa walega walɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nɨma sakwat nandinya angivat mɨna waagan kat wandɨ. Jisas Kraistna sɨmba mɨn kat wowun. Lɨ kat kwagala wowun. Wandɨ maa waagan lɨ kat kwagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lɨ kat vɨga la nɨmba vɨlaa yelavɨtndi. Lɨla njɨvwamba ngɨni sanya ana klaiganɨn waa yelavɨtndi. Yelvɨtaa Polagwi Sailas kat kwutaa nɨndɨ ngepma kotmat kalindi. Ngepmana njambwi nɨmba nɨndɨ ngepmamba lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wan ngepmana njambwi nɨmba Romba tɨga yaa nɨmba ndi. Njambwi nɨmba kat wandi. Wumbɨt nyan Juda mbɨt. Nɨna ngepmamba lɨga kavle vat kwupmbɨk. Nɨna ngepmana vapmba ana yetɨlɨgambɨt. ");
INSERT INTO ian_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","nɨna ngepma vat tɨgandɨ. Mbɨt nɨna ngepma nɨmba kat kapma vat sɨmogwilɨgambɨt. Romba lɨga yaa nɨmba nɨn kat kwingwa vapmba yetɨlɨganɨn. Nɨn kat sɨmogwilɨmba vapmba ana yetɨgiyanɨn. Nɨn kat sɨmogwilɨmba vapmba ana yetɨgiyanɨn waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nat nɨmbagwi wupma walɨgandi. Mbɨk kat kai walɨgandi. Wan ngepmana njambwi nɨmba Pologwi Sailasna waavwi ngɨlɨtaa aviya wandi. ");
INSERT INTO ian_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mbɨk kat nɨmamba viyalaa kalabusmba laagandi. Kalabus vɨga la nyan kat wandi. Ndaamange nɨmamba asɨ. Mbɨt kat yigumba vɨ waa wandi. ");
INSERT INTO ian_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wandi ma kalabusma vɨga la nyan mbɨk kat kwutaa nɨndɨ ngaymba taagandɨ. Mbɨtna man nɨma mimba tagu aita taagalaa ngindɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nɨndɨ ngan Pologwi Sailaso mbangu kwundi God kat walɨmbɨt. God apma nyana waa walɨmbɨt. God kat ngambulɨmbɨt. Kalabusmba la nat nɨmba ngambulɨmbɨt. Kalabusmba la nat nɨmba ngambulɨmba vat wutaa lɨndi. ");
INSERT INTO ian_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tɨga lɨga nɨma yɨnaw kwutndɨ. Kalabua aywaa nɨmamba yuvut yindɨ. Ngay ngayna ndaamange avla lavwindɨ. Man taambamba ngɨnja yaaw avla njalatndɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kalabus kat vɨga la nyan sɨndu kwaga lɨga laatndɨ. Laataa ndaamange lavwiya vat vɨndɨ. kalabusmba la nɨmba aywaa tamba wogwendi waa yelavɨtndɨ. Yelavɨka lɨga ndɨna yak kwutaa lɨga avla vatnya mɨna lɨndɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol ndɨ kat nɨmamba walendɨ. Avla ke vatnyaga. Kumba lɨganɨn waa walendɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kalabus kat vɨga la nyan tuwai sagalalaa agiya wandɨ. Tuwai kiyandi maa Polagwi Sailasna mangandamba ndandɨ. Ndɨna ava plalɨndi. ");
INSERT INTO ian_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mbɨk kat kwutaa alaguat kalindɨ. Kalilaa mbɨk kat wagalandɨ. Anda vat yilaga apma vat yetɨmba vat klaigowun waa wagalandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ndɨ kat wambɨt njambwi nyan Jisas kat maawupmba yelavɨka yetɨmeyan apma vat yetɨma vak klaigamɨn. Kapma ana klaigamɨn. Mɨna ngaymba lɨga nɨmbo klaigandi. ");
INSERT INTO ian_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Njambwi nyan waa apma nyaangɨt ndɨnagwi ndɨna ngaymba lɨga nɨmba kat mbutɨmbɨt. ");
INSERT INTO ian_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kalabus kat vɨga la nyan mbɨtna mbangɨmba vɨyanja nglaw njangindɨ. Njangɨlaa kwiya tapman ndɨnagwi ndɨna ngaymba lɨga nɨmbo ngu yagundi. ");
INSERT INTO ian_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Polagwi Silas kat ndɨna ngay kaligaa mbɨk kat nao kwindɨ. Godna yelangɨ wuleinjangat wan nyanagwi ndɨna ngaymba la nɨmbogwi solat sɨlɨndi. ");
INSERT INTO ian_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nat nandinyana ngambi Rommba lɨga yaa njambwi nɨmba plisman kat wandi. Mbɨk kat kwagalaa yigaambɨt. ");
INSERT INTO ian_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Wungi kat tɨga kalabus kat vɨga la nyan Pol kat wandɨ. Njambwi nɨmba mbɨk kat kwagalaa yigaambɨt waa wandi. yigumba aymba waa wandɨ. ");
INSERT INTO ian_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol plisman kat wandɨ. Kavle vat ana yili. Angat kapmba kwo viyandi. An Romna ndɨmba wuleilaa ndina vat klali. An kat kwutaa kalabusmba taagandi. An kat pagwugaa wanja vat ana nglaatndɨ. Romba lɨga yaa njambwi nɨmba kapmba yandi maa wog