﻿USE sofia;
DROP TABLE IF EXISTS sofia.hwo_vpl;
CREATE TABLE hwo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hwo_vpl WRITE;
INSERT INTO hwo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kulo thlǝmngya chichiiya Yeeso Ƙǝrǝsti ya, chichid Ndauda tǝ Ibrahim. ");
INSERT INTO hwo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim nggǝtgha Ishaku, Ishaku nggǝtgha Yakubu. Yakubu nggǝtgha Yahuda tǝ wan manggighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda nggǝtgha Peres tǝ Dzara. Ma ndan ndǝna Tamar. Peres nggǝtgha Hesron, Hesron nggǝtgha Aram, ");
INSERT INTO hwo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram nggǝtgha Aminadab, Aminadab nggǝtgha Nashon, Nashon nggǝtgha Salmon. ");
INSERT INTO hwo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Nggǝtgha Mboz. Man ndǝna Rahap. Mboz nggǝtgha Obed. Man ndǝna Ruth. Obed nggǝtgha Djeshi, ");
INSERT INTO hwo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Njessi nggǝtgha kutǝra Ndauda. Ndauda nggǝtgha Sulemanu. Man ndǝna Mbasheba, nu mǝra Uriya. ");
INSERT INTO hwo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemanu nggǝtgha Rehobom, Rehobom nggǝtgha Abidja, Abidja nggǝtgha Asa, ");
INSERT INTO hwo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nggǝtgha Djehoshafat, Djehoshafat nggǝtgha Djoram, Djoram nggǝtgha Adzariya, ");
INSERT INTO hwo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Adzariya nggǝtgha Djothlam, Djothlam nggǝtgha Ahas, Ahas nggǝtgha Hedzekiya, ");
INSERT INTO hwo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hedzekiya nggǝtgha Manasa, Manasa nggǝtgha Aman, Aman nggǝtgha Djosiya, ");
INSERT INTO hwo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Djosiya nggǝtgha Djekoniya tǝ wanmanggighǝn, a sayidɗi ƙǝsang ngganda nafiya Yahuda ngyaɓang tsaurha nda kanda fa hu chehweed Mbabila ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A kwasamadɗi ɗǝna nda tǝ kanda a Mbabila ɗǝ, Djokoniya nggǝtgha Sheyaltiyel, Sheyaltiyel nggǝtgha Dzerubabel, ");
INSERT INTO hwo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Dzerubabel nggǝtgha Abihudu, Abihudu nggǝtgha Eliyakim, Eliyakim nggǝtgha Adzor, ");
INSERT INTO hwo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adzor nggǝtgha Dzadok, Dzadok nggǝtgha Akim, Akim nggǝtgha Eliyud, ");
INSERT INTO hwo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud nggǝtgha Eleyadza, Eleyadza nggǝtgha Mattan, Mattan nggǝtgha Yakubu, ");
INSERT INTO hwo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu nggǝtgha Yisufu, chimad Mairamu. Mairamu nggǝtgha Yeeso na nda aarha Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chichiiya kumkap faɗa a thlakh mbǝd Ibrahim ɗǝgha thlakh mbǝd Ndauda ɗǝ. Thliirha a thlakh mbǝd Ndauda ɗǝgha hu sayidɗa ɗǝ ngyaɓang nanda tsaurha kanda fa a Mbabila, chichiiya kumkap faɗa ni. Thiirha ƙǝm a sayidɗi mal nanda Mbabila ɗǝgha hu sayidɗa ɗǝ nggǝt nanda Ƙǝrǝsti chichiiya kumkap faɗa ni. ");
INSERT INTO hwo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kulo kwaman nggǝtta Yeeso Ƙǝrǝsti ya. A sayidɗi ngwanna Yisufu Mairamu man Yeeso, amma kanda kula kakhrha, ƙǝlagha Mairamu hai, nǝghǝn ahur yi Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yisufu ka niifa ni mbǝ midghǝn sǝ a fǝrang shilee nǝn Mairamu a yid fiya wa, ahu numadghǝn na midghǝn sǝ a kalghǝnǝn hai ɓǝɓee. ");
INSERT INTO hwo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amma ndǝghǝn hu numadɗi kee, ɓagha tǝthlǝnda Faara thlǝmadghǝn ɓa hu sǝsǝniirha ndanggǝn, “Yisufu, wan Ndauda, a tǝrǝmna kakh Mairamu wa, ƙǝsǝr huryidɗi keeghǝn yi Sǝsǝna tǝ Peɗǝnda ni. ");
INSERT INTO hwo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nǝn a nggǝt wee hǝshin, ɗǝfang thlǝma na Yeeso Ƙǝsǝr ndǝghǝn ni a hǝrghang nafiyighǝn ahu ɗimiyid ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ənggini heu ya katǝra nǝn hai ka a lǝɗang ngganda ˈya ndana annabi. ");
INSERT INTO hwo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Na wutararha a ɗǝfrha hur nggǝt wee hǝshin nǝn ɗǝfang thlǝma nda Imaniyel.” Thlǝmɗi ndaarha ni, “Faara nǝghǝn tǝ ƙǝm ha.” ");
INSERT INTO hwo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mehenna Yisufu sǝ a ɓeena, takkwa ǝn ɗanǝn pǝrangna tǝthlǝnda Faara, kahanggǝn Mairamu. ");
INSERT INTO hwo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amma sǝngwa ndǝn wee nuwun wa, ƙǝl a kwasamadɗi nggǝt nǝn wee hǝshin, ɗǝfang thlǝma nǝn Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Akwasamadɗi nggǝt nanda Yeeso a Mbaitalami ahu chehweed Yahudiya, a thlakh mbed kutǝryid Hirdus, ɓagha fasǝngya a Urshelima ɓa a man kyad yanfaara ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tsakh mee nda, “Ai wanɗi nggǝt nanda kutǝr Yahudaya? Na ɗan wufǝlngarghǝn a man kyad yanfaara, ɓa nan ɓa ka a tǝrang shilee nan in.” ");
INSERT INTO hwo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hǝrǝmna kutǝra Hirdus sǝkƙǝn kee, ɓillagha kaan, heu tǝ nafiya Urshelima. ");
INSERT INTO hwo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tǝrgha wumanggǝn mamngya firistaya ɓa, tǝ fasǝngya ngyakhrha Musa, tsahang mee nǝn kanda, “A yanggi na nda a nggǝt Ƙǝrǝsti?” ");
INSERT INTO hwo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ndang ngganda, “Ahu tal Mbaitalami hu chehweed Yahudiya, ƙǝsǝr chirethlengga annabi hai kee tǝ ndaarha: ");
INSERT INTO hwo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Amma sa ƙǝm Mbaitalami na hu chehweed Yahudiya, ƙǝɗiwa ahur kutǝryid wupǝriya Yahuda wa. Ƙǝsǝr a fadwa na kutǝra a kyarha ɓa, nǝn a tsaurha tǝ lafrha nafina Isǝreela.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tǝrgha Hirdus aah fasǝnggina nǝn ɓa ɓǝɓee, tsahang mee nǝn kanda sayidɗi na nanda wufǝlngarɗi. ");
INSERT INTO hwo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Thlǝn kanda nǝn Mbaitalami ɗǝ ndanggǝn kanda, “Ɗama ɗǝ ɗun sǝye laɓar wanɗa ɓa ya tǝ sammayirha. A walangɗun, ɓamaɓa ɓun pǝreƙǝn nggima ɗiyaɗǝ ɗi tǝrang shilee teena.” ");
INSERT INTO hwo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A kwasamadɗi sǝk nanda laɓarɗi ki kutǝra, thlii nda wii fayindan nda. Wufǝlngarɗi ˈwa nanda narha a man kyad yanfaara ɓa nagha a mbendan ɗǝgha isha a mbǝɗi na wanɗa sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na nanda wufǝlngarɗi tǝk mbǝnda nda fa kaan. ");
INSERT INTO hwo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kyana nda mindǝɗa hai, na wanɗa nda tǝ man Mairamu, ɓǝra nda hai tǝrang shilee nda teena. Tǝrgha inang ngganda yawayindan ɗǝ fǝrang tǝfaasa nda tǝ urdi tǝ mur. ");
INSERT INTO hwo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yanang ngganda kanda ahu sǝsǝniirha a wunda tǝ thlǝmad Hirdus wa, nanǝn kee wuɗa nda tal ndan ɗǝ tǝ kwamana pak. ");
INSERT INTO hwo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A kwasamadɗi wiina fasǝnggini, tǝrgha tǝthlǝnda Chinǝm ɓagha thlǝmad Yisufu ɓa hu sǝsǝniirha ndanggǝn, “Thliusǝ, tǝrang wanɗi tǝ man ɗaana tǝ kanda a Masar ɗǝ. Tsawama a mbǝɗi ƙǝl a pǝrang ɗi ndǝn kun, ƙǝsǝr Hirdus nǝn a kaɗa wanɗi a ɓǝlanggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tǝrgha thliigha sǝ tǝranggǝn wanɗi tǝ man a fǝɗigɗi wiigha Masar ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsawa nda a mbǝɗi ƙǝl merna Hirdus. Ənɗiya katǝra nǝn hai ka a lǝɗang ngganda ǝnɗi ndaana Chinǝm a mii annabi, “Aah yi waana ɓa a Masar.” ");
INSERT INTO hwo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ƙǝlana na Hirdus hai fasǝnggini na a man kyad fara ɓa pǝpǝlǝk ndan hai, sǝbgha hurghǝn ɗǝ kaan. Thlǝnanggǝn sodjaya ɗǝ a ɓǝlangganda wangya hǝshya ɗǝ na nggu-ngguchit a Mbaitalami tǝ tulayighǝn, sǝlna hura yindan sǝri tǝ fingya sǝlwawa, mǝmǝlla sayidɗi pǝrangna fasǝnggini kyana wufǝlngarɗa ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tǝrgha ˈya thlǝkna annabi Djermiya lǝghǝdɗǝ: ");
INSERT INTO hwo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sǝkɗǝm huhwaarha a Ramah, tǝrha tǝ thlee hura, Rachal a tǝrha ka wanggighǝn karɗǝ nggabrha fa, ƙǝsǝr mǝr wanggighǝn ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","A kwasamadɗi mǝrna Hirdus, tǝrgha tǝthlǝnda Chinǝm kyad fadghǝnǝn a Yisufu hu sǝsǝniirha a Masar, ");
INSERT INTO hwo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ndanggǝn, “Thliusǝ tǝrang wanɗiya tǝ man wuɗana chehweed Isǝreela ɗǝ, ƙǝsǝr nafini na a kaɗa yiɓǝd wanɗi mǝr nda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tǝrgha Yisufu thliigha sǝ, tǝranggǝn wanɗi tǝ man wuɗa nda chehweed Isǝreela ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma sǝknǝn wan Hirdus, Arkilus ni hu tsǝnggam chin, a ǝna kutǝryirha a chehweed Yahuda, tǝrǝm ɗǝrha nǝn mbǝɗaɗǝ. Yanangganda hu sǝsǝniirha a ɗǝɗa ɗǝ wa, tǝrgha kyalthgha chehweed Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɗǝgha tsaurha ahu tala na nda aarha Nadzarat, lǝghǝdgha ˈya thlǝkna annabiya: “Na nda aaghǝn Tǝnadzarat.” ");
INSERT INTO hwo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Akwasamad huraya Yahaya Tǝbaptisǝma a pǝr laɓar Faara a fiya a kaheerha na a chehweed Yahuda, ");
INSERT INTO hwo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nagha a ndaarha, “Malaman ɗimiyid nun, ƙǝsǝr Kutǝryid Talara nduwusɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Niif ɗani ndaana annabi Ishaya: “Urarha a aah farha a kaheerha, ‘Tangsaaman kwamana Chinǝm sǝ, pǝpǝnaman kwaman sarya ɗǝ a ndǝghǝn.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Luwud Yahaya ǝnagha ndan tǝ was thlǝkhmu, ƙǝnanggǝn muwun tǝ paama. Ənnadghǝn mii mbeerha tǝ aam ɗee. ");
INSERT INTO hwo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Fiya na a Urshalima tǝ Yahudiya heu tǝ chehweeya kahad na a mii kufad Urdun ɗǝnda thlǝmadghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kanda a pǝr ɗimiyid ndan, nagha a ǝnang mbaptisǝma kanda a kufad Urdun. ");
INSERT INTO hwo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amma nana Yahaya Farisaya tǝ Sadukiyaya hangga a ɓarha mbǝɗa ɓa nǝn a ǝnang mbaptisǝma fiya sǝ, ndanggǝn kanda, “Kun huthlingya! Wun ƙǝsgha thlǝmad nun a ɗa sǝsad Faara nun hai na ɓayi? ");
INSERT INTO hwo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ənama ˈya kyadgha ndaarha malangɗun ɗimiyid nun. ");
INSERT INTO hwo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A numaɗun ndon kee, ‘Chichid nǝm ni Ibrahim, mbǝ Faara a sǝsang ƙǝm wa.’ Niya ndang nda kun na Faara tǝ sǝsǝmnda ha na a ǝnang wundakhnaya nǝn Ibrahim sǝ tǝ feryini ya. ");
INSERT INTO hwo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ˈWanda teena pangnda wurra a kul ɗǝfrha, kala ɗǝfrha mbuwa nggǝtta ngga nanda kyathlang nda ɗǝ muwangganda ahu waarha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Niyi a ǝnang mbaptisǝma kun tǝ aama. Amma niifa sǝ na ɓayi kalgha nggi mu, tsǝkki na a kwasanggi sahad pahamggǝn hai wa, ndǝghǝnggi ɓanǝn ǝnang mbaptisǝma kun tǝ Sǝsǝna tǝ Peɗǝnda tǝ waarha. ");
INSERT INTO hwo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nǝghǝn tǝ ɗeng pǝra ha, nǝn a pǝrang ɗiɗiirha ɗǝ ngwanggǝn wan hwalidghǝn ahu ɓirukkun hai. Nǝn a njang nda ɗiɗidghǝn ɗǝ tǝ waarha mbuwa mǝra hai.” ");
INSERT INTO hwo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tǝrgha Yeeso thliigha a Nggalili ɗǝgha kufad Urdun ɗǝ ka a ǝnangga Yahaya mbaptisǝma. ");
INSERT INTO hwo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amma Yahaya karɗafa a ǝnang mbaptisǝma nǝn Yeeso, ndǝghǝn, “Kamɗǝ sani ǝne mbaptisǝma. Kama na ɓarha thlǝmanna ɓa?” ");
INSERT INTO hwo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nggǝmangga Yeeso ndǝghǝn, “Nanǝnya ngwa tsauka kee, ƙǝsǝr kamɗǝ a lǝɗanggǝm ǝngya heu na mid Faara.” Tǝrgha nggǝmngga Yahaya fa. ");
INSERT INTO hwo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hǝrǝm nanda ǝnang mbaptisǝma Yeeso, kyanǝn sǝ ahur aamɗi kee, tǝrgha talara inggaɗǝ na Sǝsǝn Faara nǝn a tǝra hai ƙǝla tǝtiliurha tsauka a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sǝk urarha nda a talara hai, “Waana niya, nggǝmni, niyi a tǝk mbǝndǝghǝn fa kaan.” ");
INSERT INTO hwo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tǝrgha Sǝsǝna tǝ Peɗǝnda ɗǝgha tǝ Yeeso a kaheerha ɗǝ ka a ƙǝƙǝrangga sheetan. ");
INSERT INTO hwo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yeeso karɗǝ aama yi ɓeena kumnggit faɗa nda fǝɗigrha tǝ yan fara. Akwasamdghǝn ƙǝsgha miirha ndǝn. ");
INSERT INTO hwo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tǝrgha sheetan ɓagha thlǝmadghǝn ɓa ndanggǝn, “Ana Wan Faara ni sa, tsawang feryini ya ka mburodi.” ");
INSERT INTO hwo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amma nggǝmangga Yeeso ndanggǝn, “Nǝghǝn chichirethlee hai hu ɗeleewar Faara: ‘Mbǝ tǝ mburodi kee na niifa ƙǝra sǝ wa, amma tǝ laɓaara na kyarha ɓa a mii Faara.’” ");
INSERT INTO hwo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tǝrgha sheetan tǝranggǝn Urshelima ɗǝ wupǝri tǝ Peɗǝnda, tǝranggǝn ten Ƙǝn Faara sǝ na a Urshelima. ");
INSERT INTO hwo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ndanggǝn, “Ana Wan Faara ni sa, puru hweeɗe hai, ƙǝsǝr nǝghǝn chichirethlee hai hu ɗeleewar Faara, ‘Nǝn a ndang fathlǝnggighǝn a nggawo wa nda sǝ, tǝ haryindan na nda a nggawo sǝ, amana ɗǝghang sarwa feera fa.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nggǝmangga Yeeso, “Nǝghǝn chichireethlee hai, ‘a ƙǝƙǝrangna Chinǝm Faarwa wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nggǝrgha Sheetan tǝrang nda a ten wumnda sǝ na nzang kyaɗang kutǝryid ƙǝshiirha nǝn heu tǝ mamnggitghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ndanggǝn, “Ənggini heu ya niya furo ƙǝn, a ɓǝrna hai fǝree mamnggirha na.” ");
INSERT INTO hwo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ndangga Yeeso, “Kalu kwamanna hai, Sheetan! Ƙǝsǝr nǝghǝn chichirethlee hai hu ɗeleewar Faara: ‘Tǝtani a ɗǝfang shilee na Chinǝm Faarwa in, ndǝghǝn katenggǝn na fǝrang mamnggirha.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tǝrgha Sheetan mal Yeeso nǝn. Ɓagha fathlǝngya Faara ɓa ƙǝlaghǝn ndaha. ");
INSERT INTO hwo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sǝkna Yeeso muwang nda Yahaya hu porsǝna ɗǝ, mal Yahudiya nǝn ɗǝgha Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ˈWa ɗǝrha nǝn Nadzarat ɗǝ a wudgha Kafarnahum ɗǝ na a mii wuri aama tǝ tsaurha, na a chehweed Dzebulu tǝ Naftali. ");
INSERT INTO hwo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ƙǝsǝr a lǝɗang ngganda ˈya ndana annabi Ishaya tǝ ndaarha: ");
INSERT INTO hwo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Chehwed Dzebuluna tǝ chehweed Naftali, kunna a kwaman wuri aama, tǝ ƙǝsǝr kufad Urdun, tǝ ƙǝm chehweed Nggalili yi fingya mbuwa wa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nafiya na tsaurha a wula nanda kukwaryirha kaan, Fingya na tsaurha a mishim mǝrra kyad kukwaryirha ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka a farɗi ndǝn katǝrangna Yeeso pǝr laɓar Faara hai, nagha a ndaarha, “Malaman ɗimiyid nun, ƙǝsǝr Kutǝryid Talara nduwusɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nana Yeeso a wiirha hai a mii wuri aam Nggalili, na nafiya nǝn sǝri a wanmanggi nda Siman na nda aarha Mbiturus tǝ wanman Andǝrawus. Na nda a ƙǝs tǝngya tǝ panggamnggi ndan ahu wuri aamɗi ƙǝsǝr fa ƙǝs tǝngya ni. ");
INSERT INTO hwo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tǝrgha Yeeso ndanggǝn kanda, “Mbuwama samadna, niya tsawang kun fa ƙǝs fiya ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsu a mbǝɗi kee malangganda panggamnggi ndan mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chik nǝn ɗǝrha mbeeɗǝ, nggǝrghǝn na nafiya sǝri a wanmanggi, Yakubu wan Dzabadi tǝ wanman na Yahaya. Kanda ahu kombuwol chii ndan Dzabadi, a tangsang panggamnggi ndan ɗǝ, aagha Yeeso kanda. ");
INSERT INTO hwo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tsu a mbǝɗi kee malangganda kombuwol ndan tǝ chi ndan mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeeso wengɗǝ chehweed Nggalili kahad nagha a tsahang fiya ha hu ƙǝn tsahad Yahudaya nagha a pǝr Laɓara na Mbǝnggǝn yi kutǝryid Faara, tǝ ƙǝnang nda fiya natǝ wanhaya ɗǝɗamǝn tǝ ɓeerha farha. ");
INSERT INTO hwo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Laɓarghǝn ɗǝɗa ɗǝ inggun ta Suriya ɗǝ. Ɓang haya nda ɓa, heu tǝ fingya natǝ wanhaya fa ɗǝɗamǝn-ɗǝɗamǝn, fingya ƙǝnangna ǝnkaheeya kanda hai, tǝ kachelya tǝ fingya mǝrna fandan hai, ƙǝnanggǝn kanda heu. ");
INSERT INTO hwo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fiya hangga mbuwa samadghǝn, fingya a Nggalili ɓa, fingya hu chehweerha ɓa na nda aarha talya kum, fingya a Urshelima ɓa tǝ Yahudiya tǝ fingya ƙǝm a pǝm kufad Urdun ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hǝrǝmna Yeeso na fiya wumnda hai hangga, tǝrgha wumnda sǝ tsauka hai. Ɓagha fatsahayighǝn thlǝmadghǝn ɓa, ");
INSERT INTO hwo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","katǝranggǝn tsahang kanda ha. ");
INSERT INTO hwo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Fa parkayani nafiya sǝnggasǝ fa yamiya ni hu sǝsǝna, ƙǝsǝr Kutǝryid Talara yi ndanni. ");
INSERT INTO hwo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Fa parkayani nafiya na a tǝrha nanǝnya, ƙǝsǝr na nda a nggab kanda. ");
INSERT INTO hwo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Fa parkayani nafiya mbuwa tǝrang tendan sǝ, ƙǝsǝr na nda a har langad ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Fa parkayani nafiya na miirha a ƙǝsa tǝ hushim nggayirha; ƙǝsǝr nun a nggaala! ");
INSERT INTO hwo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Fa parkaya ni nafiya na fiya a haɗang kanda fa, ƙǝsǝr na nda a haɗang Faara fa. ");
INSERT INTO hwo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Fa parkayani nafiya na hur ndan chahal, ƙǝsǝr na nda ana Faara. ");
INSERT INTO hwo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Fa parkayani nafiya na ɓang tsau ɗǝɗemnggirha, ƙǝsǝr na nda aah kanda wangya Faara. ");
INSERT INTO hwo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Fa parkayani nafiya na a sǝsaarha ka nggayirha, ƙǝsǝr Kutǝryid Talara yi ndanni. ");
INSERT INTO hwo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Fa parkayani kun, ana fiya a ˈyar kun, sǝsangganda kun, kanda a nggaɓa kun tǝ ndaarha fa mbǝlfeeya ni kun, ƙǝsǝr ka nggi. ");
INSERT INTO hwo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ənama wutsǝfayirha tǝ tǝk mbǝnda fa, nun wal ƙǝnaghǝn hangga a talara. Ƙǝsǝr annabiya na ƙǝtǝm sǝsangganda kanda kee. ");
INSERT INTO hwo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kunni fǝs ƙǝshiirha. Amma a tǝr mbǝnda fǝsa ɗǝ, ƙǝƙǝn nǝm nggǝr nggǝrang ɓa? Ɓalwa targhǝn sǝ wa, ƙǝl iraɗǝ kee ishangga fiya hai. ");
INSERT INTO hwo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kunni kukwaryid ƙǝshiirha. Wupǝri na a mbǝrha na ɗangkam mbǝ ɓǝɓeerha hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tǝ ƙǝm mbǝm njang patilla tsǝɓanggǝm tǝ tǝɓa wa. A meghedghǝn nǝm ɗǝfang nda a mbǝd wagrǝghǝn tǝnǝn fǝrang kukwaryirha fiya na ahur mindǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nǝghǝn kee ƙǝm, ngwa njargha kukwaryid nun hai a mbed fiya naghǝn nda, tǝna kowunni fal Chinun na a talara. ");
INSERT INTO hwo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","A numaɗun ndon ɓani ɓa ka ɓi weleng ngyakhrha Musa ɗǝ tǝ yi annabiya wa. Ɓawi ɓa ka ɓi weleng kanda ɗǝ wa, amma ka ɓi lǝɗang nda kanda. ");
INSERT INTO hwo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niya pǝrang ƙǝkafek kun, ƙǝl ma ngwala talara tǝ hweeɗe, mbǝ ˈyasǝ na ngguchit a ƙǝtta ɗǝ hu ngyakhrha Musa wa, ƙǝl ma lǝghǝdɗǝ heu. ");
INSERT INTO hwo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kala niifa tǝɗangga yanɗi na ngguchit ahu ngyakhkini teena ya, tsahang nggǝnǝn fiya ha ƙǝm, nǝn a tsaurha ngguchit hu Kutǝryid Talara. Kala niifa ƙǝm ǝnagha taara tǝ ngyakhkiniya tsahanggǝn nǝn fiya ha ƙǝm nǝn a tsaurha manggǝn hu Kutǝryid Talara. ");
INSERT INTO hwo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Niya ndang nda kun, a kalwa nggayid nun yi fasǝngya ngyakhrha Musa tǝ yi Farisaya wa, mbun tam kyarha hu Kutǝryid Talara ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sǝkɗun ˈya ndang nanda chichiyinǝm kaar tǝ ndaarha, ‘A ɓǝlɗun farha wa, kala niifa ɓǝlgha farha na a nda a ngwang kumarha sǝ.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma nggi ƙǝm niya ndang nda kun, kala niifa sǝbna hurghǝn ɗǝ tǝ shadghǝn na nda a ngwang kumarha sǝ. Niya nggǝr ndang nda kun niifa ndangga shadghǝn, ‘Ka wuɗe,’ na nda ɗǝrha tǝghǝn mbed fa ngwa kumaaya ɗǝ. Amma niifa ndangga shadghǝn, ‘Nura!’ na nda a muwang nda hu waarha ɗǝ mbuwa mǝra hai.” ");
INSERT INTO hwo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tsaunǝn kee, a nanna a fǝr ǝn fǝrrǝwa a Faara a mbǝd sataka, a ɗalna teena hai sǝɓang na hur shadwa ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","malu ǝn fǝrrǝwa a mbǝd sataka. Ɗuwa ɗǝ ˈwan ɗun tangsang pathlang nun tǝ shadwa, tǝrgha a ɓana ɓa, ɓa ɗǝrha mbeeɗǝ tǝ fǝrrǝwa. ");
INSERT INTO hwo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","A huhwad niifa sa, kaɗu kwamana na a tangsanggun pathlang nun ƙǝkar kapa nun sǝla kǝn ngwa kumarha ɗǝ. A karna fa, ɗǝnǝn tǝsa a mbed tǝ ngwa kumarha ɗǝ. Tǝ ngwa kumarha ƙǝm nǝn fǝrang sa wan sǝsalya. Wan sǝsalya ƙǝm na nda muworha hu porsǝna. ");
INSERT INTO hwo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Niya pǝro ƙǝkafek, mba kyarhaɓa wa ƙǝl tiina ǝnɗi kyo nanda heu.” ");
INSERT INTO hwo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sǝkɗun ndǝn tǝ ndaarha, ‘A ǝnanna kulafayirha wa.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma nggi ƙǝm niya ndang nda kun kala niifa ƙǝlangga nuneefa sunaghǝnǝn ˈwaɗǝ teena ǝnaɗǝ kulafayirha tǝghǝn ahurghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A kyo yidwa yisǝma hu ɗimiyirha hai, kutethleng sǝ muwangga ɗǝ. A nggushi ƙǝɗeng na patu tal a fadwa ma muwangganda fadwa heu ahu waarha ɗǝ mbuwa mǝra hai. ");
INSERT INTO hwo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ana harwa yisǝma a kyorha hu ɗimiyirha hai, kyathlang ɗǝ muwangga ɗǝ. A nggushi ƙǝɗeng na patu tal a fadwa ma muwangganda fadwa heu ahu waarha ɗǝ mbuwa mǝra hai.” ");
INSERT INTO hwo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Thlǝk ndan tǝ ndaarha, ‘Kala niifa kalgha nukkun hai tsawang ɗafa tǝta a chireethleng ɗeleewar nǝn sǝ yi kala hai.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma nggi ƙǝm niya ndang nda kun kala niifa kalgha nukkun hai a mbǝ aten ɗimid kulafayirha wa, kyang nǝn hu kulafayirha hai. Kala niifa ƙǝm kakhka nuneefa kal nanda hai ǝnanǝn kulafayirha.” ");
INSERT INTO hwo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nggǝr ɗun sǝkƙǝn a mii chichiiyi nǝm kaar tǝ ndaarha, ‘A tǝɗang ɗun ˈya in ndaanun a Faara wa, amma ƙǝsaama ɗǝfmi nun ha ǝna nun a Chinǝm.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma nggi niya ndang nda kun, a ɗǝf ɗun mee tǝ thlǝm talara wa, ƙǝsǝr mbǝd tsawud Faara ni. ");
INSERT INTO hwo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A ɗǝf ɗun mee tǝ thlǝm hweeɗe wa, ƙǝsǝr ndǝna mbǝd yiɓǝd sar Faara. A ɗǝf ɗun mee tǝ thlǝm Urshalima wa, ƙǝsǝr wupǝri ni yi Faara, kutǝra na manggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A ɗǝf ɗun mee tǝ thlǝm ten nun wa, ƙǝsǝr mbun mbang nggǝrang was nun hai tsauka pǝpet nduwa iˈim wa. ");
INSERT INTO hwo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ˈYa kamngga kee, ‘Yoo’ tsauka ‘Yoo,’ tǝ ƙǝm ‘Awo’ tsauka ‘Awo.’ Kala laɓaara kalgha yanɗamu ya kyaghǝn ɓa a mii tǝmbǝlfedɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sǝkɗun ndǝn tǝ ndaarha, ‘Yirha a meghed yirha, thlaana a meghed thlaana.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma niya ndang nda kun, a karɗun tǝ mbǝlfeerha fa wa. A mbi niifa sa hu ƙǝmeng wa yisǝma, kyakhrang man patu ɓa ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A huhwad niifa sa ka a thlanggǝn luwudwa, fǝrang kaɓad wa ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A ngyaɓo niifa hu wiirha hai mel tal, weema ɗǝ kyab mel sǝri. ");
INSERT INTO hwo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kala niifa hwanowa ˈya, fǝrang, kala niifa kaɗagha kumarha a harwa a ˈyaɗang na wa.” ");
INSERT INTO hwo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sǝkɗun ndǝn tǝ ndaarha, ‘Nggǝmama tula yinun kar fatsan ngginun nun.’ ");
INSERT INTO hwo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma niya ndang nda kun, nggǝmama fa tsangginun, hwana man Faara nafiya teena na a sǝsang kun. ");
INSERT INTO hwo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","A naɗun kee, nun tsaurha wangya Faara na a talara, ƙǝsǝr nǝn fǝr yanfaara a ka nafiya tǝ fa mbǝlfeeya. Nǝn ɓa ˈyaara a nafiya na tǝ nggayirha fa tǝ fingya mbuwa tǝ nggayirha fa. ");
INSERT INTO hwo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ana ɗun a nggǝm nafiya na a nggǝm kun kee, ƙǝƙǝn nun wal parka? Ko fathlǝ tsamngya ni ma mbǝna nda ǝnaarha kee wa? ");
INSERT INTO hwo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A naɗun a ǝna nggayirha a pashiyi nun kee, ma nun a ǝnaarha kalgha fingya mu? Mbǝna fa ɗahaya ǝnaarha kee wa? ");
INSERT INTO hwo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amma tsawama lǝlǝgɗa ƙǝla nana Chinun na a talara lǝlǝgɗa.” ");
INSERT INTO hwo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kwarama a kyad ɗun nggayirha a mbed fiya ka a na kun nda wa. A ǝna ɗun kee, mbun wal ƙǝnaghǝn a har chinun na a talara wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","A naɗun a fǝra a kalɗun miighǝn ɗǝ ƙǝla na fa thlǝrɓuya ǝnaarha hu Ƙǝn Faara, tǝ ten kwamangya, ahur wure ka a fal kanda nda wa. Niya pǝrang ƙǝkafek kun, ˈWanda teena thlǝnda yi ndan ƙǝna. ");
INSERT INTO hwo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma a naɗun a fǝrang niifa ˈya na midghǝn, a nggǝmɗun fa sǝngga yi kawa ˈya na yisǝma a fǝra wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No a fǝra ɓǝɓee, tǝrgha tsu na a na ˈya na a ǝnaarha ɓǝɓee nǝn a fǝro ƙǝnaghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Anaɗun a hwan Faara, a ǝna ɗun ƙǝla fa thlǝrɓuya wa. Ƙǝsǝr kanda na mindan sǝ hwan Faara ƙǝt ƙǝkǝɗa a ƙǝngya yi hwan Faara, tǝ ƙǝm aten kwamangya ahur tala ka a nagha fiya kanda. Niya pǝrang ƙǝkafek kun ˈwanda teena wal nda ƙǝna ndan. ");
INSERT INTO hwo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma anaɗun a hwan Faara, kyama hur ƙǝnna ɗǝ, nggǝlang nggun kwatminda a hwanang nggun chinun, mbuwawa nǝm a naarha. Tǝrgha Chinun, na a na ˈya ɓǝɓee, nǝn a fǝrang ƙǝnaghǝn kun.” ");
INSERT INTO hwo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Anaɗun a hwan Faara, a nggurɓang ɗun ˈya nun a thlǝkrha ƙǝla nafiya sǝngwa Faara na a ǝnaarha wa. Tamngganda ndaarha na nda sǝk fandan a nanda a nggurɓang pathla mu. ");
INSERT INTO hwo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A tsauɗun ƙǝla kanda wa, ƙǝsǝr Chinun sǝnɗǝ ˈya na minnun kapa nun tsahang mee. ");
INSERT INTO hwo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hwanama kiya.” “Chinǝm na a talara a chilɓi thlǝm wa nǝm ha. ");
INSERT INTO hwo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kutǝryid wa ɓagha ɓa. ˈYa na midwa a ǝnaghǝnan, hu ƙǝshiirha ƙǝla yanɗi na nanda a ǝnaarha a talara ");
INSERT INTO hwo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fǝrang ǝnnadmid par fara kan. ");
INSERT INTO hwo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chahang ɗimiyid nan kanɗǝ, ƙǝla nan chahanggǝn fingyaɗǝ na a ǝnang ɗimiyirha kan fa. ");
INSERT INTO hwo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A ɗǝnna tǝ kan hu ƙǝƙǝrra ɗǝ wa, amma hǝrghang kan a haar tǝmbǝlfedɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ƙǝsǝr a chahang ɗun ɗimiyindan fiyaɗǝ ǝnangga ɗimiyirha kun fa, Chinun na a talara ƙǝm nǝn a chahang ɗimiyid nun kun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma a chahang nggun ɗimiyid ndan fiya ɗǝ wa, Chinun na a talara ƙǝm mbǝ chahang ɗimiyid nun kun ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Anaɗun a kar aama, a ndeng ɗun yid nun hai ƙǝla na fa thlǝrɓuya ǝnaarha wa, ƙǝsǝr na nda ndeng yindan hai tǝna fiya sǝndasǝ na nda a kar aama. Niya pǝrang ƙǝkafek kun, ˈwanda teena thlǝnda ƙǝna ndan. ");
INSERT INTO hwo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma ana ɗun a kar aama, tsǝtsǝɗang was wa ƙǝm fǝɗeerha na aten wa, ");
INSERT INTO hwo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","amana fiya sǝnda sǝ nun a kar aama. Chinun mbuwawa nǝm a naarha, na a na ˈya nǝm a ǝnaarha ɓǝɓee, nǝn a fǝrang ƙǝnaghǝn kun.” ");
INSERT INTO hwo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“A ɗǝfang ɗun ƙǝna alten nun ɗǝ hu ƙǝshidɗiya, na mǝmemngya tǝ hǝla sǝɓang nda ɗǝ, tǝ ƙǝm na ngaarya kyarha ɗǝ tǝrang ngganda wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amma ɗǝfa man ƙǝna altennun ɗǝ a talara, mbuwana mǝmemngya tǝ hǝla sǝɓang ɗǝ, tǝ ƙǝm mbuwana ngaarya kyarha ɗǝ ngaara nda. ");
INSERT INTO hwo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ƙǝsǝr kala mbǝrha nana ƙǝnawa sǝ ndǝna mbǝd numad wa.” ");
INSERT INTO hwo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yirha ndǝna kukwaryid farha, ana yidwa kanglang hai, fadwa na heu nǝn narha lǝlǝgɗa tǝ kukwaryirha. ");
INSERT INTO hwo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma a mbǝ yidwa kanglang hai wa, fadwa na heu nǝn narha tǝ wula. Ana kukwaryirha na a fadwa wulani, fadwa na heu nǝn narha tikɗik. ");
INSERT INTO hwo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mbǝ mafarha sǝ na ǝnang taara turaya sǝri wa. Tsauɗǝ nǝn nggǝm tal kar tahadghǝnǝn, nduwa ƙǝm mananggǝn tal sar tahadghǝnǝn. Mbǝ ǝnaarha hai ǝnang taara nun Faara tǝ wuɗǝɓǝla kyab wa.” ");
INSERT INTO hwo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tsaunǝn kee, niya ndang nda kun, a ɓillaɗun tǝ yiɓǝd nun wa, tǝ ˈya nun ǝnnarhami tǝ sarha wa, nduwa fannun ˈya nun kala fa wa. Kalwa yiɓǝd nun ǝnnarhami wa, nduwa kalwa fannun ˈya nun a kala fa wa? ");
INSERT INTO hwo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kǝla man wuɗikkya lee! Mba nda hǝfrha wa, mba nda haathla wa, mba nda tǝ ƙǝn ǝnnarhami nduwa ɓiriukya wa, ko nanǝn kee na Faara fǝrang ǝnnarhami kanda. Sǝngunsǝ mamnggit nun kalɗǝ yi wuɗikkya wa? ");
INSERT INTO hwo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wunni ahur nun aten ɓilladghǝn na mbang chik ɓenggǝn hu ƙǝshiirha? ");
INSERT INTO hwo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kama nun ɓillarha aten lukkya? Kǝla man fid ɗǝfya na tsǝrha. Mba nda ǝna taara, ko pu kaɓarha wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko nanǝn kee, niya ndang nda kun, ko kutǝra Sulemanu tǝ mamnggitghǝn ˈwa wa ngwarha fa ƙǝla tal ahur ndan wa. ");
INSERT INTO hwo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ana Faara a ngwang nda fid ɗǝfya fa na a hee kiya, hwaliirha nasǝ a weeriya, a ɓinda ƙǝm njigha ɗǝ, sakkwa kun nǝn ngwang kun fa. Kama nanun tǝ yamid fǝrƙǝkafek? ");
INSERT INTO hwo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nanǝn kee a ɓillaɗun aten ǝngginiya tǝ ndaarha, ‘Ma nan ǝnnarhami? Nduwa, ma nan saarha? Nduwa, ma nan kala fa?’” ");
INSERT INTO hwo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ƙǝsǝr nafiya sǝngwa Faara ndǝna kaɗa tur ǝngginiya, Chinun na a talara sǝnɗasǝ na minnun sǝ ǝngginiya. ");
INSERT INTO hwo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kaɗama kutǝryid Faara ˈwan tǝ ǝna nggayirha, ǝnggini na heu ƙǝmya nǝn a fǝranggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsaunǝn kee, a ɓillaɗun tǝ ɓinda wa, ƙǝsǝr ɓinda nǝn a ɓarha ɓa tǝ ɓilladghǝn. Kala parra yanfaara nǝghǝn tǝ ɓillad altenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“A ngwangɗun kumarha fingya wa, kun nggima mba nda ngwang kumarha kun wa. ");
INSERT INTO hwo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ƙǝsǝr na nda a ǝnang nda kun ƙǝla ǝnang nun fingya. Tasau nun a ƙǝƙǝrang fiya sǝ ndǝna nda ƙǝƙǝrang nda kun sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mani na ƙǝlang hwaliirha na a yid shadwa, sa kula ƙǝɗang miwaarha ɗǝ na a yidwa? ");
INSERT INTO hwo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ƙǝƙǝn na ndang nda shadwa, ‘Wanya ni a ƙǝɗo hwaliirha ɗǝ a yidwa’ kula sa na miwaarha na yidwa? ");
INSERT INTO hwo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sa tǝthlǝrɓu! Katǝrang ƙǝɗang miwadɗǝ ˈwan na yidwa tǝna na mana hai ngga, na a mbangga ƙǝɗang hwaliirha ɗǝ na yid shadwa.” ");
INSERT INTO hwo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A fǝrang ɗun ˈya wuɗaya na chahal wa. A tsamang ɗun ǝn thlǝmaaya ɗǝ tǝ ǝn uraya natǝ wuɗǝɓǝla fa a ƙǝlengarya ɗǝ wa. A ǝna ɗun kee, na nda ishang hai a kamu saryi ndan. Na wuɗa yini a kyaharra hai njarang ngganda kun ɗǝ kushir-kushir. ");
INSERT INTO hwo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Naama a hwanda na nda fǝrang kun. Naama a kaɗaarha nun a waala. Naama a ɗǝk kwatminda, na nda inanggǝn kun hai. ");
INSERT INTO hwo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ƙǝsǝr kala niifa hwangga, na nda a fǝrang, niifa kaɗagha ƙǝm nǝn a waala. Kǝmɗarha kala niifa ɗǝkka kwatminda nanda inanggǝn hai. ");
INSERT INTO hwo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wunni ahur nun, a hwanang wanggǝn mburodi fǝrang feera nǝn? ");
INSERT INTO hwo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nduwa a hwanang ɗǝ tǝna fǝrang hulthne nǝn? ");
INSERT INTO hwo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A tsauɗǝ, kun na fa mbǝlfeeya sǝnɗun ˈya nun fǝrang nda wangginun ǝngya na ngga, sakwata chinun a talara, nǝn fǝr ǝngya na ngga a nafiya na hwanda. ");
INSERT INTO hwo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tsaunǝn kee, ǝnaman ˈya fiya ƙǝla na mid nun a ǝnang ngganda kun. Ƙǝsǝr tsahad ngyakhrha Ɗeleewar Musa niya tǝ yi annabiya. ");
INSERT INTO hwo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kyarha hu kutǝryid Faara ɗǝ tǝtani kyana tǝ kwatkirma na iˈyaɓa. Kwaman ɗǝrha hu waarha ɗǝ nǝghǝn manggǝn, kwatkirǝm nggǝn ƙǝm nǝghǝn ƙǝthlǝng, nafiya hangga wurgha kwaman ɗi. ");
INSERT INTO hwo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kwatkirǝm wal yibrha nǝghǝn ngguchit, tǝ ƙǝm kwamanggǝn nǝghǝn pǝɗaghǝn, nafiya na a kyarha sǝ na nda ngguchit. ");
INSERT INTO hwo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kwarama tǝ annabiya fa nggaɓaya. Na nda ɓarha thlǝmad nun ɓa tǝ lukrha fa ƙǝla chauraya, amma hur ndan nǝghǝn ƙǝla mǝmereeya. ");
INSERT INTO hwo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nǝm sǝnang kanda hai ahu ǝn ǝnad ndan ƙǝla nǝm sǝn ɗǝfrha tǝ tur wanggighǝn. Mbǝm ɗakh wan inabi ɓa a fad ndaha wa, nduwa wan shiɓarha a fad ndakh mbǝlfeerha wa. ");
INSERT INTO hwo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ɗǝfrha na ngga nǝn nggǝt wan ɗǝfrha na ngga, ɗǝfrha mbuwawa ngga nǝn nggǝt wan ɗǝfrha mbuwawa ngga. ");
INSERT INTO hwo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɗǝfrha na ngga mbǝ nggǝt wan ɗǝfrha mbuwawa ngga wa, tǝ ƙǝm ɗǝfrha mbuwawa ngga mbǝ nggǝt wan ɗǝfrha na ngga wa. ");
INSERT INTO hwo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kala ɗǝfrha mbuwa nggǝt wan ɗǝfya ngga na nda kyathlang ɗǝ muwang ngganda ahu waarha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nǝghǝn kee, ƙǝla nǝm sǝnang ɗǝfrha hai tǝ tur wanggighǝn, nǝm sǝnang annabiya fa nggaɓaya hai kee ƙǝm tǝ ǝn ǝnad ndan. ");
INSERT INTO hwo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mbǝ fiya heu na a aah nggi, ‘Chinǝm, Chinǝm,’ na a kyarha hu Kutǝryid Talara ɗǝ wa, amma ƙǝl nafini ǝnagha ˈya na mid Pǝpa na a talara.” ");
INSERT INTO hwo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Nafiya hangga na a ndeerha a farɗi, ‘Chinǝm, Chinǝm,’ pǝr ɗan laɓar Faara tǝ thlǝmwa, tǝ ƙǝm kyang ɗan ǝnkaheeya sǝ tǝ thlǝmwa, tǝ ƙǝm ǝna ɗan ǝnwulteengya hangga tǝ thlǝmwa.” ");
INSERT INTO hwo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Amma niya nggǝrang kanda sǝ, ‘ˈwawi sǝn kun wa. Weema ma thlǝmadna kun fa mbǝlfeeya!’” ");
INSERT INTO hwo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kala niifa kang ngga thlǝmaarha tsahad na fa ǝna taara nǝn sǝ nǝghǝn ndǝndǝl, kǝla niifa tǝngga wurighǝn aten feera. ");
INSERT INTO hwo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɓana ˈyaara hai, lǝghǝdgha kufaarha, ɗǝkka ɓereu ˈyaara wuriɗi amma mbangwa chang hai wa, ƙǝsǝr tǝngga ndan aten feera. ");
INSERT INTO hwo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Amma niifa sǝkka tsahad na ǝnawa taara sǝ wa, nǝghǝn ƙǝla nur niifa tǝngga wurighǝn aten chehweerha. ");
INSERT INTO hwo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɓana ˈyaara hai, lǝghǝdgha kufaarha, ɗǝkka ɓereu ˈyaara wuriɗi chang nggǝn hai hwaf.” ");
INSERT INTO hwo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ngwalang na Yeeso tsahadghǝn ha, fiya wumngga hai ǝna ǝnwulteena nda aten tsahadghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ƙǝsǝr tsahadghǝn ha nǝghǝn ƙǝla niifa na tǝ sǝsǝmnda, mbǝ ƙǝla fatsahaya yi ngyakhrha wa. ");
INSERT INTO hwo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tǝrna Yeeso hai a wumnda, takkwagha fiya ndǝn hangga. ");
INSERT INTO hwo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na niifa sǝ na tǝ wanhad termeerha fa, nanǝn Yeeso ɗǝgha thlǝmadghǝn ɗǝ, ɓǝrgha hai a mbedghǝn hwanggǝn nǝn ndanggǝn, “Chinǝm, a nggǝmna fa na mbang tsaɓeeɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tǝrgha Yeeso fǝr harghǝnǝn ɗǝ tsuwarghǝnǝn fa ndanggǝn, “Nggǝmɗi fa a tsaɓana ɗǝ. Tsaɓuɗǝ!” A mbǝɗi tsu kee, termedɗi ndǝkka hai tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tǝrgha ƙǝsgha Yeeso thlǝmadghǝn ndanggǝn, “A pǝrang nan niifa wa, amma ɗuwaɗǝ kyaɗang fadwa firis na sa nǝn. A ǝno sataka tǝna fiya sǝndasǝ tsabnaɗǝ kǝla ndana ngyakhrha Musa.” ");
INSERT INTO hwo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kyana Yeeso Kafarnahum hai, ɓagha mamnda sodja Romaya thlǝmadghǝn ɓa hwanggǝn nǝn ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Chinǝm, mafadna kalth a wuri mbǝ kanglang wa, mǝr fadghǝn hai nǝghǝn a sǝsarha kaan.” ");
INSERT INTO hwo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ndangga Yeeso, “Niya ɗǝrhaɗǝ ɗi ƙǝnang nda.” ");
INSERT INTO hwo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tǝrgha mamnda sodja Romaya nggǝmanggǝn Yeeso ndanggǝn, “Chinǝm, tsǝkki na a ɓana minda kyana ɓa wa, amma a nggǝmna fa kalu sǝ kee a mbǝɗi na nana na mafanna a ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ƙǝsǝr nggi niyi akamu ngyakhrha niifa, ƙǝmɗa tǝ sodjaya a kamuna. Ni ndangnda yanɗiya, ‘ɗuwaɗǝ’, nǝn ɗǝrhaɗǝ; yanɗi taarha ƙǝm ndanggi ˈɓoɓaˈ, nǝn a ɓarha ɓa, ndanggi mafanna, ǝno kiya, ǝnagha ƙǝla ndangni.” ");
INSERT INTO hwo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sǝkna Yeeso ndǝn kee, wulangga teena. Kyahargha hai ndanggǝn nafini na a mbu samadghǝn, “Niya ndang nda kun, ahur Isǝreela ˈwawi wal niifa tǝ fǝrƙǝkafek fa tǝ kanglanggirha ƙǝla yanɗiya wa.” ");
INSERT INTO hwo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Niya ndang nda kun, fiya hangga na a ɓarha ɓa a man kyad yanfaara tǝ man hǝmndǝghǝn, na nda a tǝr mbǝd tsawud ndan tǝ Ibrahim, tǝ Ishaku tǝ Yakubu ahu wutsǝfayidɗi hu Kutǝryid Talara. ");
INSERT INTO hwo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma Isǝreelaya hangga kya nanda ǝna Kutǝryidɗi ka kanda, nanda a muwang kanda ahu wula ɗǝ, a mbǝɗani na nanda a tǝrha sǝ tǝ ƙǝt mee.” ");
INSERT INTO hwo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tǝrgha ndangga Yeeso mamnda sodja Romadɗi, “Wuɗu wureeɗǝ, ka fǝrƙǝkafekkid wa ni ǝnagha ndǝn katǝra nǝn hai kee.” Mafadɗi keeghǝn ƙǝngga mǝmǝlla sayidɗi wu. ");
INSERT INTO hwo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sǝlna Yeeso a minda ki Mbiturus ɗǝ, ɗǝgha wal thlaɓǝr Mbiturus tǝnuwunda fadghǝn ɓee kalth hu sǝra. ");
INSERT INTO hwo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsuwargha Yeeso harghǝn fa, ƙǝngga. Tǝrgha thliigha sǝ fǝrang ǝnnarhami nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tsǝna figrha hai, nafiya natǝ ǝnkaheeya fa hangga ɓa nda tǝ kanda thlǝmad Yeeso ɓa. Kyanggǝn ǝnkaheeyina sǝ tǝ mee kee, tǝ ƙǝm ƙǝnanggǝn haaya heu. ");
INSERT INTO hwo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ənanǝn ǝnɗiya ka a lǝghǝdgha laɓarɗi thlǝkna Chinǝm tǝ mii annabi Ishaya, ndanǝn: “Tǝrang ɗǝ ɓeerha fayi nǝm, tǝ ƙǝm ƙǝɗanggǝn wanhayi nǝm ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ƙǝlang na Yeeso fiya wumngga thlǝmadghǝn ɓa, ndanggǝn fatsahayighǝn a ɗǝnda pǝm wuri aama Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tǝrgha tal ahur famalǝmngya ngyakhrha Musa ndanggǝn, “Mala, niya mbusamad wa kala mbǝrha na a ɗǝrha saaɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nggǝrangga Yeeso sǝ, “Tsarwaya tǝ kwandan sǝ, wuɗikkya na hu ɓereurha tǝ ƙǝndan sǝ, amma Wan Niifa mbǝ mbǝdghǝn sǝ ko na a ɗǝfanggǝn tenggǝn sahai wa.” ");
INSERT INTO hwo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tal ahur fatsahayighǝn ndanggǝn, “Chinǝm, malee ˈwan wuɗi wureeɗǝ ɗi pangnda pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amma ndangga Yeeso, “Mbuwu samanna nanǝnya! Malang mǝrya pang ngganda mǝrrǝndan.” ");
INSERT INTO hwo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tǝrgha Yeeso kyagha hu kombuwol hai katǝranggǝn tǝɗang wuri aamɗi teena tǝ fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kula sǝndǝndan sǝ, ɓagha ɓereu ˈyaara ɓa na kanglang ahu wuri aam ɗaɓa katǝrangga aamɗi kuɗufulla hai nagha aama a pisha ahur kombuwol ɗa hai. Amma tǝrang ɓeena Yeeso ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɗǝgha fatsahayighǝn ɗǝ mekhneng ngganda sǝ ndang ngganda, “Chinǝm, hǝrghang ƙǝm! Nǝm a hwaarha ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Amma nggǝrangga Yeeso kanda sǝ, “Kama nun a tǝrǝmnda? Ƙǝɗi fǝrƙǝkafekkid nun!” Tǝrgha thliigha sǝ yanaggǝn ɓereuɗi tǝ kuɗufulla aamɗi, nggasgha mbǝrha hai. ");
INSERT INTO hwo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ƙǝsangga ǝnwulteena fatsahayighǝn tsakhmee nda, “Tur niif wunni ya? Ko ɓereurha ni tǝ kuɗufulla aama na nda a takkwa ˈya ndanǝn!” ");
INSERT INTO hwo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sǝlna Yeeso a pǝm wuri aam ɗaɗǝ, na a man ki chehweed Nggadaraya, nafiya sǝri na tǝ ǝnkaheeya fa ɓa nda thlǝmadghǝn ɓa. Ɓagha nda ɓa a mbǝd ten kwaya, mbǝ niifa sǝ na mbang mbǝraɗǝ tǝ mbǝɗi wa, ƙǝsǝr tsau nda ǝn tǝrǝmnda. ");
INSERT INTO hwo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Katǝrang ngganda huhwang nda hai na nda a ndaarha, “Ma djiɗoyiwa tǝ kan, Wan Faara? Ɓana ɓa ka a sǝsangga kan kapa na far ngwa kumad nan tsǝrha hai wa?” ");
INSERT INTO hwo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsau tǝ mbǝɗi na ƙǝlengarya sǝ na a lafrha. ");
INSERT INTO hwo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hwangga ǝnkaheeyini Yeeso, “A kyang na kan sǝ, ɗang kan ahur chiɓǝd ƙǝlengaryina ɗǝ taarha.” ");
INSERT INTO hwo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ndanggǝn kanda, “Ɗaama ɗǝ!” Nanǝn kee kya nda sǝ ɗǝnda ahur ƙǝlengaryina ɗǝ. Chiɓǝd ƙǝlengaryini kahat ɗaa nda ahur wuri aam ɗaɗǝ hwaa nda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nafini na a laf ƙǝlengaryini ɗaa nda hur tala ɗǝ pǝr ǝnɗa nda katǝragha hai heu, tǝ ƙǝm ǝnɗi katǝragha hai tǝ nafini sǝri na tǝ ǝnkaheeya fa. ");
INSERT INTO hwo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tǝrgha nafiya hur talɗi heu kya nda ɓa ka ɓa nda na Yeeso. Na nanda Yeeso hwanggǝnda a mal chehweed ndan nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kyagha Yeeso ahu kombuwol hai ɗǝgha hu talghǝn ɗǝ mannǝn sǝ Kafarnahum. ");
INSERT INTO hwo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɓagha fingya nafiya ɓa tǝ niifa mǝrna fadghǝn hai kalth ahu ɗǝnggǝla. Nana Yeeso fǝrƙǝkafekkid ndan, ndanggǝn niifɗi mǝrna fadghǝn hai, “A ɓilladna wa waana, chohonda ɗimiyidwa ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Fingya famalǝmgya ngyakrha na nda a ndaarha ahur ndan tǝ ndaarha, “Kamshiɗiya nǝghǝn a sar Faara.” ");
INSERT INTO hwo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sǝnangga Yeeso numad ndan hai ndanggǝn kanda, “Kama nun numad ǝn mbǝlfeerha kiya ahur nun? ");
INSERT INTO hwo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yanggini pǝpa, a ndang nggi tǝ mǝrra fadɗi, ‘Chohonda ɗimiyidwa ɗǝ wa,’ nduwa, ‘Thliusǝ wiu wa?’ ");
INSERT INTO hwo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amma niya kyaɗang ndaarha kun, Wan Niifa nǝghǝn tǝ sǝsǝmnda ha hu ƙǝshidɗiya yi chakh ɗimiya.” Tǝrgha ndanggǝn niifɗi mǝrna fadghǝn hai, “Thliusǝ, tǝrang ɗǝnggǝlwa sǝ, wiina wureeɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Thliigha niifɗa sǝ harad ɗǝgha wureeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nagha fiya wumngga hai ǝnɗi katǝragha hai ƙǝsangga ǝnwulteena kanda. Tǝrgha manang ngganda Faara tǝ thlǝnangga niifa ɓa natǝ sǝsǝmnda fa kaan kiya. ");
INSERT INTO hwo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nana Yeeso ɗiye mbeeɗǝ tǝ wiirha na niifa nǝn na nda aarha Matta, ndǝghǝn tsau a mbǝd thlǝ tsamnda. Tǝrgha ndangga Yeeso, “Mbuwu samanna.” Thliigha sǝ mbu samadghǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsǝɓaku, na Yeeso a hǝb ǝnnarhami a wuri ki Matta, ɓagha fa thlǝ tsamngya tǝ faɗimiya hangga, hǝb ǝnnarhami nda tǝghǝn tǝ fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nana Farisayini ndǝn kee, tsahang mee nda fatsahayighǝn ha, “Kama na tǝmalǝm ndǝnun hǝbrha tǝ fathlǝ tsamngya tǝ faɗimiya?” ");
INSERT INTO hwo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sǝkna Yeeso ndǝn kee, nggǝranggǝn kanda sǝ, “Nafiya na ƙǝkanglang hai mba nda kaɗa tǝpurha wa, kǝl nafiya mbuwa ƙǝkanglang. ");
INSERT INTO hwo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nanǝnya, ɗamaɗǝ ɗun tsaha ǝnɗi na laɓar Faara a ndaarha, ‘haɗang nda niifa fa ndǝna minna a fannun, mbǝ sataka wa.’ Ƙǝsǝr ɓayi ɓa ka a aah nafiya ni na a numad ndaarha na nda a ǝna nggayirha wa, amma kǝl fa ɗimiya.” ");
INSERT INTO hwo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tǝrgha ɓagha fatsahaya Yahaya a thlǝmad Yeeso ɓa ndang ngganda, “Ma ǝnagha ndǝn kan tǝ Farisaya a kar aama, amma fatsaha yiwa mba nda kar aama wa?” ");
INSERT INTO hwo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nggǝrangga Yeeso kanda sǝ, “Ƙǝƙǝn na hur pashiya wutsamnda sǝbrha ɗǝ ndǝghǝn wutsamnda ɓalɗǝ a thlǝmad ndan? Na fara ɓayi nanda a tǝrang wutsamnda ma kanda. A farɗa ni na nanda a kar aama. ");
INSERT INTO hwo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mbǝ niifa sǝ na mbuhwang suhurra lukrha tǝ weerǝnda ɓar kaɓaarha wa, ƙǝsǝr na mbuhudɗi a njarang nda luwudɗa ɗǝ, njarrǝghǝn nǝn a kal yi kaar. ");
INSERT INTO hwo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tǝ kǝm mbǝ niifa sǝ na irang nda weerǝnda aam inabi ahu suhurra samsamiya hai wa. A irang nda sa hai, na samsamiyini a ɗathla ɗǝ, na aam inabiɗi a iraaɗǝ, samsamiyini na nda sǝbrha ɗǝ. Weerinda aam anab, kamɗǝ a irang nggǝm ahu weerǝnda samsamiya hai. A ǝnaɗǝm kee na aam inabiɗi tǝ samsamiyini a ɓaala hai.” ");
INSERT INTO hwo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeeso ɓalɗǝ a kalang kanda sǝ, ɓagha mamnda ƙǝn tsahad Yahudaya ɓa ɓǝrgha hai a mbedghǝn ndagha, “Mǝrgha wutarad na kukuling ya, ɓoɓa ɓa tsǝwarghǝn fa, nǝn a thliirha sǝ tǝ yibrha.” ");
INSERT INTO hwo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Thliigha Yeeso sǝ tǝ fatsahayighǝn mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tǝrgha na nuneefa sǝ ǝnagha hurarha kumkap sǝri fara a ɓang fa hai. Ɓagha ɓa tǝman ƙǝsǝrghǝn tsuwar mii luwudghǝnǝn fa, ");
INSERT INTO hwo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ƙǝsǝr numaghǝn tǝ ndaarha, “Ko luwudghǝn tsuwar ni fa kee, niya ƙǝnda.” ");
INSERT INTO hwo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kyaharna Yeeso hai na nǝn ndǝn, ndagha, “A ɓillanna wa, waana, fǝrƙǝkafekkid wa ƙǝnoɗǝ.” Tsu a mbǝɗi kee ƙǝngga. ");
INSERT INTO hwo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kyana Yeeso minda ki mamndǝɗa hai, na fa pi perǝmngya nǝn tǝ fiya wumngga hai kanda a mbeela. ");
INSERT INTO hwo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tǝrgha ndagha, “Kyama ƙǝshaaɗǝ, mǝr wa wutaradɗi wa, nǝn a shiirha ni kee.”Amma masangga fiya wumngga hai. ");
INSERT INTO hwo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Akwasamadɗi rǝk nanda fiya ƙǝshaaɗǝ, kyagha ɗǝ ƙǝs har wutaradɗa nǝn, thliigha sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Laɓar ǝnwulteenɗiya welɗaɗǝ ahu chehwedɗi kahat. ");
INSERT INTO hwo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Akwasamadɗi malna Yeeso mbǝɗi, kwamaya sǝri hǝshya mbu samadghǝn nda kanda a aaghǝn, “A haɗowan fa, Wan Ndauda!” ");
INSERT INTO hwo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kyana Yeeso hur minda hai, tǝrgha kwamayini ɗǝnda thlǝmadghǝn ɗǝ, tsahang mee nǝn kanda, “Fǝrɗun ƙǝkafek ni mbang ƙǝnang kun wa?” Nggǝrang ngganda sǝ “Ha i, Chinǝm.” ");
INSERT INTO hwo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tǝrgha tsuwar yiyi ndan nǝn fa ndagha, “Ƙǝsǝr ka fǝrƙǝkafekkid nun, nun a ƙǝnda.” ");
INSERT INTO hwo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tǝrgha yiyi ndan inggaɗǝ. Ƙǝsgha Yeeso thlǝmad ndan kaan ndagha, “A pǝrang ɗun ndǝn niifa wa.” ");
INSERT INTO hwo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma kya nda sǝ pǝr laɓar ɗaa nda ahu chehwedɗi kahat. ");
INSERT INTO hwo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kyana nda sǝ, na niifa sǝ natǝ ǝnkaheerha fa mbǝ mbang kalasǝ wa, ɓa nda tǝghǝn thlǝmad Yeeso ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kyang na Yeeso ǝnkaheedɗa sǝ, niifɗi mbuwa mbang kalasǝ kalgha sǝ. Fiya wumngga hai ƙǝsgha ǝnwulteena kanda ndaa nda, “ˈWaghǝm tam na ˈya manggǝn ƙǝla yanɗiya a Isǝreela wa.” ");
INSERT INTO hwo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amma ndagha Farisaya, “Mamnda ǝnkaheeya fǝrangga sǝsǝmnda kyang nda ǝnkaheeya sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeeso wengɗǝ wupǝriya hai tǝ talya heu a tsahang fiya ha ahu ƙǝn tsahad Yahudaya, tǝ pǝr Laɓara na Mbǝnggǝn yi Kutǝryid Faara, tǝ ƙǝm a ƙǝnang nda fiya natǝ wanhaya ɗǝɗamǝn-ɗǝɗamǝn. ");
INSERT INTO hwo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nana Yeeso fiya wumngga hai, haɗangga nafina fa, ƙǝsǝr na nda hu sǝsaarha, mbǝ niifa sǝ na ɗang kanda sǝ wa. Na nda kǝla chauraya na kula tǝlafrha. ");
INSERT INTO hwo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tǝrgha ndanggǝn fatsahayighǝn, “Mul hathla hai, amma ƙǝɗi fatarya. ");
INSERT INTO hwo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsaunǝn kee, hwanama tǝhedɗi, thlǝn fatarya nǝn ɓa ɓanda hathlang sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aagha Yeeso fatsahayighǝn kumkap sǝri a thlǝmadghǝn ɓa, fǝrang sǝsǝmnda nǝn kanda a kyang ngganda ǝnkaheeya sǝ tǝ ƙǝm ƙǝnang ngganda wanhaya ɗǝɗamǝn-ɗǝɗamǝn tǝ ɓeerha farha. ");
INSERT INTO hwo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kulo thlǝm fathlǝngya Yeeso kumkap sǝri ya: Siman nanda aarha Mbiturus, Andrawus wanman Siman, Yakubu wan Dzabadi, Yahaya wanman Yakubu, ");
INSERT INTO hwo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, Mbatalomi, Toma, Matta tǝ thlǝ tsamnda, Yakubu wan Alfiyus, Taddiyus, ");
INSERT INTO hwo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siman tǝsǝrǝk chehweedghǝn, Yahuda Iskaryoti fǝrgha Yeeso ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Thlǝngga Yeeso kumkap sǝri ɗi ndanggǝn kanda, “A ɗuɗun thlǝmad fingya ɗǝ mbuwa Yahudaya, nduwa talya Samariyaya wa. ");
INSERT INTO hwo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amma ɗaama thlǝmad nafiya Isǝreela ɗǝ, chauraya Faara sahadgha. ");
INSERT INTO hwo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɗaamaɗǝ ɗun ndangnda kanda nduwus Kutǝryid Faara ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ƙǝnaman haya, thleeman mǝrya sǝ, ƙǝnaman fingya natǝ wanhad termeerha fa, kyaman ǝnkaheeya sǝ. Fǝrang nggandan kun ka, kun ƙǝm fǝramadghǝn ka ƙǝla thlǝnun ndǝn! ");
INSERT INTO hwo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A ƙǝsɗun wuɗǝɓǝla ha hu panjakwan nun wa, ko tǝfaasa, nduwa wurirha, nduwa kala ˈya na ƙǝla wuɗǝɓǝla wa. ");
INSERT INTO hwo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A ƙǝsɗun yawarha ha tǝ lukrha tǝ pakhma, nduwa sǝsaala wa. Kala ˈya fǝrang nanda kun a karɗun ndǝn wa, ƙǝsǝr tǝtaara kamɗǝ a wal ǝnnarhami nǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kala wupǝri nduwa tala kyanun sahai, kaɗaama ka niifa tsawun ahur mindǝghǝn ta far ɗaɗǝ nun a mal talɗi. ");
INSERT INTO hwo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A kyaɗun hur minda hai, ndaamaˈya tǝ ƙǝm fǝrang parka nun kanda. ");
INSERT INTO hwo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ana ka minda ni ngwa tsauka parkad nun sǝ. Amma a mbusǝ kee wa, ngwa wudgha parkad nun a fad nun ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kala tala nduwa wure kyanun sahai, a thluwa nda kun fa wa, nduwa kar nda kang thlǝmaarha kun fa, anaɗun a wiirha paman tinid mbǝɗa ɗǝ na a fad sarnun. ");
INSERT INTO hwo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Niya pǝrang ƙǝkafek kun, a far ngwa kumarha a nggushi nda Sodom tǝ Nggomara na nda a haɗang kanda fa ma talɗi. ");
INSERT INTO hwo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Niya thlǝn kun ƙǝla chauraya ahur mǝmereeya ɗǝ. Nanǝn kee tsawama thladwayirha ƙǝla huthlingya tǝ ƙǝm tsawama mǝsǝlǝmnda nafiya ƙǝla kataprakkya. ");
INSERT INTO hwo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kwarama! Ƙǝsǝr na nda a ɗǝrha tǝ kun mbed fa ngwa kumaya ɗǝ tǝ ƙǝngya tsahad Yahudaya tsaɗa kun nda. ");
INSERT INTO hwo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nanda a ɗǝrha tǝ kun a mbed ngwamnaya ɗǝ tǝ kutǝrya ƙǝsǝr ka nggi. Ənɗaniya na fǝrang kwamana kun pǝrang ƙǝkafek nun kanda atenna. ");
INSERT INTO hwo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Amma a ƙǝsang nda kun a ɓillaɗun tǝ ˈya nun a thlǝkrha tǝ ƙǝƙǝn nun a thlǝkƙǝn wa. Ƙǝsǝr a mǝmǝlla sayidɗi na Faara a pǝrang ˈya kun nun a thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ƙǝsǝr mbǝ kunni na a kaala sǝ wa, Sǝsǝn Chinun ni na a kaala sǝ ahur nun. ");
INSERT INTO hwo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wanmana nǝn a fǝr wanman a ɓǝlang ngganda. Chingya na nda a fǝr wanggindan, na wundakhnaya a thleng fa nggǝt yindan fa a ɓǝlang ngganda kanda. ");
INSERT INTO hwo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na fiya heu a kar kun ƙǝsǝr ka nggi. Amma kala niifa ƙǝrǝsgha, nǝn a hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A sǝsang nda kun ahu yanɗi tala ya, ɗaama hu tala ɗǝ pak. Niya pǝrang ƙǝkafek kun, Nggi, na Wan Niifa, ni a wutta ɓa kapa nun weng talya Isǝreela hai heu.” ");
INSERT INTO hwo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wan tǝmakarantarha mbǝ kal tǝmalǝmndǝghǝn wa, tǝ ƙǝm mafarha mbǝ kal turighǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wangya makarantaya kamɗǝ a na nda ƙǝla tǝmalǝmndǝn ndan, mafaya ƙǝm a na nda ƙǝla turi ndan. Nanǝn Nggi, na tuwuri ɗi, anda nggi kogna ǝnkaheeya, wangya wuriɗi ƙǝm na nda aah kanda tǝ thlǝma kalgha yina mu!” ");
INSERT INTO hwo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nanǝn kee, a tǝrǝm ɗun fingya na a sǝsang kun wa. Ƙǝsǝr na farghǝn ɓayi kala ˈya na nggǝnggǝla na nda a inang ɗǝ; kala ˈya na ɓǝɓee ƙǝm nǝn a kyarha pǝpal ɓa sǝkƙǝna fiya heu. ");
INSERT INTO hwo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ˈYa pǝrang ni kun hu wula, tǝraman urad nun sǝ pǝrghǝn nun a yanfaara a ɗalth mbǝrha hai. ˈYa shishiwang ni kun hu thlǝmaarha hai, tǝrama ten ƙǝnna sǝ tǝranggun urad nun sǝ pǝrghǝn nun sǝkƙǝna kowunni! ");
INSERT INTO hwo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A tǝrǝm ɗun fingya na a ɓǝl farha wa; ƙǝsǝr mba nda mbang ɓǝlang shingnda wa. Amma tǝrmama Faara katenggǝn, ndǝghǝn na mbang ɓǝlang farha tǝ shingnda kyab ahu hwanga. ");
INSERT INTO hwo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mbǝ na nda heng wuɗikkya ɗǝ sǝri kobo tal wa? Amma a muk tal a hweeɗe hai na Chinun sǝnda sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko was tengginun heu nǝghǝn thlǝthlǝɗa. ");
INSERT INTO hwo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nanǝn kee, a tǝrǝm ɗun wa; kal ɗun wuɗikkya hangga a mbed Faara.” ");
INSERT INTO hwo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Niya ndang nda kun, kala niifa ndagha sǝnɗǝ nggi a mbed fiya hu ƙǝshidɗiya, nggi ƙǝm niya ndaarha sǝnɗi ndǝn a mbed Pǝpa na a talara. ");
INSERT INTO hwo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma niifa ƙǝm ndagha sǝngwa nggi wa a mbed fiya hu ƙǝshidɗiya, nggi ƙǝm niya ndaarha sǝngwi ndǝn wa a mbed Pǝpa na a talara.” ");
INSERT INTO hwo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A numaɗun ndon ɓang ni tsawud ɗǝɗemnggirha ƙǝshiirha ɓa wa. Awo, ɓawi ɓa tǝ tsawud ɗǝɗemnggirha wa, amma thlaukh ƙǝlara. ");
INSERT INTO hwo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Ɓani ɓa ka a ɓi wumang yanda a pathlang: ‘Nda wee hǝshin tǝ chin, nda wutararha tǝ man, nda nu wee tǝ thlaɓǝrghǝn tǝ nuwunda. ");
INSERT INTO hwo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fa saryi nun, na nda naarha ahur mindǝnun.’” ");
INSERT INTO hwo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","A nggǝmna tsu nduwa muwa ma nggi, tsǝkka a tsawana yina wa. Tǝ ƙǝm a nggǝmna wundǝlad wa nduwa wutarad wa ma nggi, tsǝkka a tsawana yina wa. ");
INSERT INTO hwo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kala niifa kargha tǝr kaɗidghǝn fa mbu samadna nǝn, tsǝkkwa a tsauka yina wa. ");
INSERT INTO hwo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kala niifa nggǝmngga yiɓǝdghǝn, nǝn a ƙǝɗeng nda, tǝ ƙǝm kala niifa ƙǝɗengga yiɓǝdghǝn ka nggi nǝn a walghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kala niifa thlǝgha kun fa thlǝnǝn nggi, tǝ ƙǝm kala niifa thlǝgha nggi fa thlǝnǝn Chinɗi thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kala niifa thlǝgha annabi fa ƙǝsǝr ka nanǝn annabi, nǝn a wal ƙǝnaghǝn yi annabi. Kala niifa thlǝgha ka niifa fa, ƙǝsǝr ka nanǝn ka niifa nǝn a wal ƙǝnaghǝn yi ka niifa. ");
INSERT INTO hwo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kala niifa fǝrangga aam saarha na shishiu ahu wuhuleurha a tal ahur fingyayini na nggun-ngguchit ahu fatakkwayina, ƙǝkafek nǝn a wal ƙǝnaghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ngwalang na Yeeso thlǝghang palthyini a fatsahayighǝn kumkap sǝri, kyagha sǝ ka ɗǝgha tsahang fiya ha tǝ pǝr laɓar Faara hu fingya a talya Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nana Yahaya tǝ Mbaptisǝma ahu porsǝna, sǝk laɓaara nǝn aten ǝnggini na Ƙǝrǝsti a ǝnarha. Tǝrgha thlǝn fatsahayighǝn nǝn ɗǝ ɗa nda tsahang mee Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ndang ngganda Yeeso, “Sani Ƙǝrǝsti ɗi nan a ƙǝlaarha fa wa, nduwa ɗan mbeeɗǝ tǝ ƙǝla niifa fa pak wa?” ");
INSERT INTO hwo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ndangga Yeeso kanda, “Wuɗaama ɗun pǝranggǝn Yahaya ˈya nun a sǝkrha tǝ ˈya nun a naarha. ");
INSERT INTO hwo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kwamaya a na mana hai, Sǝfǝngya a wiirha hai, fa tǝrmeeya kanda a wal ƙǝnda, teɓengya a sǝk laɓaara, kanda a thleng mǝrya sǝ tǝ yibrha, tǝ ƙǝm kanda a pǝr Laɓara na Mbǝnggǝn a fa yamiya. ");
INSERT INTO hwo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndaaman, ‘A fǝrangga Faara parka fingya kawaa ƙǝsǝra, ƙǝsǝr ka nggi.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nana fatsaha yini ki Yahaya a wiirha, katǝrangga Yeeso tsǝ laɓaara hai aten Yahaya ahu terɗi wumngga hai. Ndanggǝn kanda, “Tur yanggi niifa ni ɗunun ka ƙǝlang nda a kaheerha ɗǝ? Niifa ni na kyakhrang hutenggǝn hai ƙǝla hwaliiya na nzǝnzang na ɓereurha a tsang ˈya fa wa? ");
INSERT INTO hwo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nduwa nuwun a numad ndaarha ɗunun ka ƙǝlang niifa ɗǝ ngwagha fa tǝ kari na tǝ wuɗǝɓǝla fa ngga wa? Awo, nafiya na kal kari fa natǝ wuɗǝɓǝla na nda tsaurha a kwakirǝm kutǝra, mbǝ a kaheerha wa. ");
INSERT INTO hwo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɗunun ka kaɗa annabi wa? Yoo, kalɗǝ annabi.” ");
INSERT INTO hwo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Ƙǝsǝr Ɗeleewar Faara tsǝɗǝ laɓaara aten Yahaya ndanǝn, ‘Niya thlǝn tǝthlǝndǝna ˈwagha mbeeɗǝ ma sa, nǝn a takso kwamana ɗǝ kapa na ɓarhaɓa.’” ");
INSERT INTO hwo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Niya, pǝrang ƙǝkafek kun, mbǝ niifa sǝ nggǝt nanda hu ƙǝshidɗiya kalgha Yahaya tǝ mbaptisǝma mamnggirha wa. Amma ko yanɗa ni na ngguchit ahu Kutǝryid Talara kalɗǝ Yahaya mamnggirha. ");
INSERT INTO hwo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ka a thlakh mbǝdɗi katǝrangna Yahaya tǝ mbaptisǝma pǝr laɓar Faara hai, ta weeri ɗaɓa ya, Kutǝryid Talara aten ɗǝrha mbeeɗǝ tǝ kanglanggirha, ko nanǝn fa mbǝlfeeya na nda a yanda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ƙǝsǝr kapa na Yahaya ɓarha ɓa, annabiya heu tǝ Ɗeleewar ngyakhrha Musa thlǝk nda ˈya ɓagha katǝrarha hai. ");
INSERT INTO hwo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A naɗun a nggǝmfa tǝ ˈya ndaani, Yahaya ndǝghǝnni Ilya, yanɗi ndana annabiya nǝn a ɓarha ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kala niifa na tǝ thlǝmad sǝkrha, sǝkƙǝnǝn. ");
INSERT INTO hwo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tǝ ma ni sakh nafiya ƙǝshiid weeriya? Nǝghǝn ƙǝla wundakhnaya na a ɓashaarha a pǝpal kasu, na nda a aah ndan tǝ ndaarha: ");
INSERT INTO hwo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Peng ɗan perǝma kunsǝ, karɗun rǝbrha fa, ang ɗan amshi mǝrra kunsǝ, karɗun tǝrha fa.’ ");
INSERT INTO hwo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɓana Yahaya tǝ Mbaptisǝma ɓa mbǝ a hǝbrha tǝ saarha wa, amma kun a ndaarha, nǝghǝn tǝ ǝnkaheerha fa.” ");
INSERT INTO hwo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Wan Niifa ɓa ɗaɓa, a hǝbrha, a saarha kun a ndaarha, ‘Tǝ yakh hǝbrha tǝ saarha, pashid fathlǝ tsamngya ni tǝ fa ɗimiya!’ Amma ana niifa tǝ sǝnda Faara na ǝn ǝnadghǝn kyadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tǝrgha katǝrangga Yeeso kiki talyi na fa ǝnanǝn ǝnwulteengya sǝ hangga, ƙǝsǝr malangwa nda ɗimiyid ndan kyakhra nda thlǝmad Faara ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kawa Koridzin! Kawa Mbatseda! Ana ǝnwulteengya ɗǝɗamǝn ǝnanda ahur nun ndǝghǝn ǝnanda a Taya tǝ Sidon, kam ƙǝtǝm ˈwad nafi ndan teena malang nda ɗimiyid ndan, kal kukwasharya nda fa tǝ ƙǝm ƙǝmang ngganda yid ndan tǝ fishe. ");
INSERT INTO hwo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Niya ndang nda kun, a far ngwa kumarha, na Taya tǝ Sidon haɗang nda Faara fa ma kun. ");
INSERT INTO hwo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kun ƙǝm nafiya Kafarnahum; tamngga ndaarha, nanda a mano a talara wa? Awo! Na ɗǝrha hu hwanga ɗǝ. Ƙǝsǝr ana ǝnwulteenggina ni ǝna nanda a kyanun ndǝn ǝna nanda a Sodom, ndǝghǝnni ƙǝm ɓalgha sǝ ta weeri ɓa ya. ");
INSERT INTO hwo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Niya ndang nda kun, a far ngwa kumarha, na Sodom a haɗang nda Faara fa ma kun.” ");
INSERT INTO hwo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A sayidɗi ndagha Yeeso, “Usaɗi sa Pǝpa, Chinǝm yi talara tǝ hweeɗe, ɓǝɓengna ǝnggini heu ya a nafiya na ndǝndǝl tǝ fa hutengya, kyaɗang nggǝna pakhtǝɗuya. ");
INSERT INTO hwo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nǝghǝn kee, Pǝpa, ndǝn kamogha yid!” ");
INSERT INTO hwo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Fǝre Pǝpa ǝngya heu, ƙǝsǝr ndǝghǝnni katenggǝn sǝngga Wanɗi. Ƙǝkafek yanɗi sǝngga Chinɗi ndǝna Wanɗi. Amma Wanɗi na midghǝn sǝ pǝrang laɓaara nǝn fingya aten Chinɗi, tǝna nda sǝnggǝn ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ɓama thlǝmadna ɓa kun ɗakhna mid nun ɗǝ na tǝ rǝfrha in haaghǝn, niya yiɓang nda kun. ");
INSERT INTO hwo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tǝrang miiwadna a kakhpǝniwa tǝna tsaharha a fanna. Mǝsǝlǝmnda niifa ni nggi hu sǝsǝna tǝ sammayirha, ƙǝsǝr nun a wal yibrha. ");
INSERT INTO hwo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na tǝrra miiwadna pǝpa, rǝfǝdɗiya ƙǝm fǝrang ni kun nǝghǝn kaftang.” ");
INSERT INTO hwo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsǝɓaku, a sayidɗi na Yeeso a mbǝra ɗǝ tǝ heerha a far Yiɓǝd Yahudaya. Ƙǝsgha miirha fatsahayighǝn, tǝrgha ƙǝs kya ten wan hwaliirha nda na nda a kiighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Amma nagha fingya Farisaya kanda ndang ngganda Yeeso, “Kuloɗǝ, fatsahayiwa a ǝna ˈya ˈyaɗana ngyakhrha na nda kya wan hwalirha a far Yibrha.” ");
INSERT INTO hwo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ndangga Yeeso kanda, “Karatang ngwanun ǝnɗi na hu Ɗeleewar Faara ǝnana Ndauda ƙǝsna miirha ndǝn tǝ pashiyighǝn wa?” ");
INSERT INTO hwo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kyagha hu Ƙǝn Faara ɗǝ, kii mburodi nda ɗǝfang nanda ɗǝ ka a kiigha firistaya. ");
INSERT INTO hwo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nduwa karatang ngwa nun ahu ngyakhrha Musa ndanǝn nggǝmang nda firistaya fa a ǝna taara ahu Ƙǝn Faara na a Urshalima a far Yibrha wa? ");
INSERT INTO hwo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Niya ndang nda kun, ƙǝlama niifa ya kalgha Ƙǝn Faara na a Urshalima. ");
INSERT INTO hwo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Amma andam kwang sǝnang ɗun ˈya hai ndana Ɗeleewar Faara, ʻNa minna sǝ nagha fiya a haɗang kun fa, mbǝ ǝna sataka wa, kam ˈyarwun fatsahayina na ka nafiya wa, ");
INSERT INTO hwo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ƙǝsǝr Wan Niifa Chinǝm ni, heu tǝ far Yibrha! ");
INSERT INTO hwo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tǝrgha wiirha Yeeso kyagha hu kǝn tsahad Yahudaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A mbǝɗi na niifa sǝ mǝrna harghǝn hai. Tsahangga farisaya mee Yeeso, “Nggǝm ngyakhrha fa a ǝnagha niifa tar kǝnang nda niifa a far Yibrha?” Tamngganda ndaarha na Yeeso a ndaarha ooh, tǝna nda kǝsang nda tǝ ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ndanggǝn kanda, “Ana chaurad nun sǝ mukka hu kwaarha hai a far Yibrha, mbun ɗǝrhaɗǝ ɗun ƙǝɗang sǝ wa? ");
INSERT INTO hwo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kal niifa chaurarha kaan, haˈi nggǝmang ngyakhrha niifa fa a ǝna ˈya na ngga a far Yibrha.” ");
INSERT INTO hwo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tǝrgha ndanggǝn niifɗi, “Pǝpǝnang harwa ɗǝ.” Nanǝn kee pǝpǝnangga niifɗi harghǝn ɗǝ, nggǝrgha harɗi mǝmǝl kǝla tahadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tǝrgha wumngga farisayina hai ka a kaɗa kwaman ɓǝlla Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sǝnangga Yeeso numad ndan hai. Nanǝn kee mal mbǝɗa nǝn, mbugha fiya samadghǝn hangga, ƙǝnanggǝn fiya heu na fandan ɓee ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Amma ƙǝs thlǝmad ndan nǝn a pǝr nda tǝwunni ndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tǝrgha lǝghǝdgha ˈya ndana Annabi Ishaya: ");
INSERT INTO hwo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Kǝlaman Mafanna wurni, nggǝmɗi ndǝn, nǝn ǝna ˈya mbǝnegha, Niya fǝrang sǝsǝnna, nǝn a ǝna nggayirha a fingya heu. ");
INSERT INTO hwo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mbǝ ǝna kakyathlaanga tǝ fiya, nduwa djargha hai ahur fiya wa. ");
INSERT INTO hwo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nǝn naarha tǝ sammayirha a fingya mbuwa kanglang, nǝn fǝrang kaali niifa mbuwa tǝ mbǝrsaarha. Akwasamadghǝn, kowunni nǝn a wal kwaman nggayirha. ");
INSERT INTO hwo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na thlǝmnggǝn a tsau yi mbǝrsad ƙǝshiirha kahat. ");
INSERT INTO hwo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tǝrgha ɓang niifa nda Yeeso ɓa na tǝ ǝnkaheerha fa, na kwamarǝn tǝ ƙǝm mbǝ mbang kalasǝ wa. Ƙǝnanggǝn niifɗi mbanggǝn kaala sǝ tǝ na maana hai kyab. ");
INSERT INTO hwo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Fiya heu na ǝnwulteena nda tsakhmee nda, “Ndee mbǝ Yeeso ɗa na ya, na wan Ndauda wa?” ");
INSERT INTO hwo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amma sǝkna Farisaya ǝnwulteenɗi ǝnanǝn, ndaa nda, “Mbǝ ngaala sǝ wa kyang ɗǝ ǝnkaheeya sǝ. Ƙǝsǝr walghǝn sǝsǝmnda a ahar Sheetan kutǝr ǝnkaheeya.” ");
INSERT INTO hwo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sǝnangga Yeeso numad ndan hai, nggǝranggǝn kanda sǝ, “Kala kutǝryirha ndǝkka hai tǝ yanda mbǝ tam isha wa, tǝ ƙǝm kala tala nduwa wure ndǝkka hai tǝ kakyathlaanga nǝn weela ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ana sheetan a kyang sheetan sǝ, nǝn a yanda tǝ altenggǝn. Mbǝ kutǝryidghǝn a mǝndaha wa. ");
INSERT INTO hwo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ana tǝ sǝsǝmnda Sheetan ni kyan ǝnkaheeya sǝ, tǝ sǝsǝmnda wun na fatakkwayinun kyang kanda sǝ? Fatakkwayinun ni a ngwang kumarha kun sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma a kyangɗi ǝnkaheeya sǝ tǝ Sǝsǝn Faara, nanǝn kee Kutǝryid Faara ɓaa ɗǝ pathlang nun ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wunni na kanglang kaan na mbang kyaarha hu minda ki niifa hai na kanglang ƙǝla Sheetan ngaaranggǝn ǝnggighǝn? Ƙǝl ˈwanǝn teena ƙǝnanggǝn niifɗa hai na kanglang ˈwan a mbanggǝn har ǝngya na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kala niifa mbuwa tǝ nggi, nǝn a tsan nggi. A mba a ɗee sǝ wumang fiya ɓa wa, na a waleng kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Niya ndang nda kun, kala tur yanggi ɗimiyirha ǝnana nduwa ndaana na nda a chahoƙǝn ɗǝ. Ko kalna sǝ yi ˈyar Wan Niifa, na nda a chahoƙǝn ɗǝ. Amma a sarna Sǝsǝna tǝ Peɗǝnda, mba nda tam chahoƙǝn ɗǝ wa, ko nanǝnya nduwa ƙǝshiirha na ɓayi. ");
INSERT INTO hwo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kala niifa ˈyargha Wan Niifa na nda mbang chahanggǝn ɗǝ, amma kala niifa ˈyargha Sǝsǝna tǝ Peɗǝnda, mba nda tam chahanggǝn ɗǝ wa, ko nanǝnya nduwa ƙǝshiirha na ɓayi. ");
INSERT INTO hwo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ana ɗǝfrha ngga, na wanggighǝn naarha ngga. A mbǝ ɗǝfrha ngga wa, mbǝ wanggighǝn narha ngga wa. Nǝm sǝn ɗǝfrha tǝ tur wanggighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kun huthlingya, ƙǝƙǝn na nafiya natǝ mbǝlfeerha fa ƙǝla kun thlǝk ˈya na ngga tǝ ƙǝm kamngga? Ƙǝsǝr ˈya na ahurwa ndǝghǝn na a kyarha ɓa thlǝkƙǝna. ");
INSERT INTO hwo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ka nafiya na nda ǝna ˈya na ngga ahur ndan sǝ, amma fambǝlfeeya na nda kyang ǝngya ɓa mbuwa ngga ahur ndan sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Niya pǝrang palthɗi kun ya, a far ngwa kumarha tǝtani a ngwang kumarha nda kun sǝ aten ˈya na ɗimi ndaanun. ");
INSERT INTO hwo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ənɗi kyagha ɓa a miiwa nǝn a hǝrworha nduwa ƙǝnoghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Farɗasǝ fingya famalǝmngya ngyakrha Musa tǝ Farisaya ɓanda thlǝmad Yeeso ɓa ndang ngganda, “Mala, na minnasǝ a kyaɗang sakh ǝnwulteena na kan na a kyad ndaarha furo Faara sǝsǝmnda.” ");
INSERT INTO hwo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Amma nggǝrangga Yeeso kanda sǝ, “Nafiya ƙǝshiid weeriya fambǝlfeeya tǝ fa yamid fǝrƙǝkafek ndǝna kaɗa ǝnsakhrha yi wulteena, amma mbǝ ǝn sakhrha sǝ na nda a kyaɗang kanda wa, kǝl yanɗi ki annabi Yunana. ");
INSERT INTO hwo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kǝla ǝnana Yunana ɓeena mahan tǝ paara mahan ahur tǝna, nanǝn kee na Wan Niifa a ǝna ɓeena mahan tǝ paara mahan kǝm ahu kwaarha. ");
INSERT INTO hwo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A far ngwa kumarha na nafiya Nineba a thleng nafiya ƙǝshiid weeri fa ya kyaɗang ndaarha nda kanda ǝnawa nda mǝmǝl wa, ƙǝsǝr kanda malang nda ɗimiyid ndan, ka laɓar Faara thlǝghangna Yunana kanda. Nanǝnya, kulo niifa kalgha Yunana a mbǝɗiya, amma karɗun malang nda ɗimiyid nun! ");
INSERT INTO hwo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A far ngwa kumarha, na Kwatam nda Sheeba a thleng nafiya ƙǝshiid weeri fa ya kyaɗang ndaarha nǝn kanda ǝnawun mǝmǝl wa. Ɓaghǝn ɓa a mbǝrha na inggun ka ɓagha sǝk sǝnda Sulemanu. Nanǝnya kulo niifa a mbǝɗiya kalgha Sulemanu, amma karɗun kang thlǝmaarha fa.” ");
INSERT INTO hwo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“A kya ǝnkaheerha sǝ a fad niifa, nǝn ɗǝrha ka kaɗa mbǝd yibrha a kaheerha ɗǝ, amma mbǝ waala wa. ");
INSERT INTO hwo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tǝrgha nǝn ndaarha, ‘Niya wutta thlǝmad niifɗa ɗǝ kyani saɓa.’ Nanǝn kee wudgha ɓagha wal wuriɗi mal nǝn mbǝ niifa sǝ wa, ngwa wuriɗa ɗǝ ngga, tangsang nda. ");
INSERT INTO hwo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tǝrgha na ǝnkaheedɗi a kaɗa ǝnkaheeya ɓa mǝd kalgha ndǝn mbǝlfeerha kya nda hur niifɗa hai tsawa nda sǝ. A kwasamadghǝn, tsawud niifɗiya sǝssadghǝn nǝn kal yi kaar. Nun a tsaurha kee kun fambǝlfeeya ƙǝshiid weeriya.” ");
INSERT INTO hwo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nana Yeeso a ndikrha tǝ fiya wumngga hai, man tǝ wanmanggighǝn ƙǝƙǝt a ƙǝshi, na minda sǝ a ndiya nda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndangga niifa Yeeso, “Nda muwa tǝ wanmanggiwa a ƙǝshi, na minda sǝ ndikrha tǝ sa.” ");
INSERT INTO hwo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tsakhka Yeeso mee, “Wunni iiya? Mingya ni kǝm wanmanggina?” ");
INSERT INTO hwo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tǝrgha kyad fatsahayighǝn nǝn ɗǝ tǝ haara ndǝghǝn, “Ƙǝlama nda iiya tǝ wanman nggina ha ya. ");
INSERT INTO hwo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tsaunǝn kee, kala niifa ǝnagha ˈya ndana Pǝpa na a talara, ndǝghǝnni wan pa, wanya tǝ ƙǝm iiya.” ");
INSERT INTO hwo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsu a farɗi malgha Yeeso wuriɗi ɗǝgha a mii wuri aam Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wumngga fiya thlǝmadghǝn ɓa hangga, nanǝn kee kyagha hu kombuwol hai. Tsauka ahur kombuwolɗi nagha a tsahang fiya ha na ƙǝƙǝt a mii wuri aamɗi. ");
INSERT INTO hwo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsǝɗǝ asǝɗaya hangga tǝ karapuya, ndǝghǝn: “Kama thlǝmaarha hai! Tǝhuɗaarha ɗǝɗǝ ka hǝfrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nanǝn aten wash wiidɗi, hǝrgha fingya hai aten kwamana, ɓagha wuɗikkya ɓa ɗamangganda. ");
INSERT INTO hwo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hǝrgha fingya hu hǝreng keela hai, ka mbuwana chehweerha sǝ kaan kya nda sǝ ƙǝkar. ");
INSERT INTO hwo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma tǝkna yanfaara hai, hwara nda ɗǝ mǝra nda, ƙǝsǝr kwa wa nda thlaara hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fingya wiiya hǝra nda pathlang ndakhkya hai ˈyaɓangga ndakhkini kanda. ");
INSERT INTO hwo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amma fingya hǝra nda hu chehweerha hai na ngga kyanda sǝ ǝna wee nda fingya katǝra kumnggit mahan-mahan, fingya ƙǝm kumnggit mikki-mikki har haru-haru.” ");
INSERT INTO hwo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Kala niifa na tǝ thlǝmad sǝkrha, sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tǝrgha ɓagha fatsahayighǝn thlǝmadghǝn ɓa tsahang mee nda, “Kama na thlǝk karapuya a nanna a kalang fiya sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nggǝranggǝn kanda sǝ, “Nggǝmang nda kun fa na a sǝn ˈya nun na Kutǝryid Talara ahurghǝn, amma fingya nggǝmang ngwanda kanda fa wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kala niifa natǝ ˈya ha na nda chighanggǝn tsǝghanggǝn kaan, amma kala niifa mbuwana ˈyasǝ a harghǝn, na nda a thlang ngguchit tǝɗi na harghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndǝghǝnni ni ǝna taara tǝ karapuya a naɗi a kalang kanda sǝ ƙǝsǝr, na nda ƙǝlaarha ɗǝ, amma mba nda naghǝn wa, na nda kathlǝmaarha hai, amma mba nda sǝkƙǝn nduwa sǝnang ngganda hai wa.” ");
INSERT INTO hwo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Ndǝn na lǝghǝtta ˈya ndaana annabi Ishaya: ‘A sǝkɗun ˈya ndaani, Mbun sǝnang hai wa, A naɗun ˈya ǝnani, mbun kukwalang hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ƙǝsǝr na ten ndan kakrak, mbǝ thlǝmaayi ndan sǝk ˈya wa, nggǝlang nda yid ndan, nanǝn kee mbǝ yid ndan na maana hai wa, mbǝ thlǝmaayi ndan sǝk ˈya wa, Mbǝ ten ndan sǝnang hai wa, Mba nda kyaharra thlǝmadna ɓa wa, ngwa ƙǝnang nggi kanda.’” ");
INSERT INTO hwo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Amma na yid nun tǝ parka, ƙǝsǝr na nda namaana hai; tǝ thlǝmaayinun ƙǝm, ƙǝsǝr na nda sǝk ˈya. ");
INSERT INTO hwo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niya Pǝrang ƙǝkafek kun, annabiya hangga tǝ ka fiya tǝrmindan na ǝnɗi nanun ya, amma nawa ndan wa. Tǝrmindan sǝk ǝnɗi sǝk nun ya, amma sǝkkwa ndan wa.” ");
INSERT INTO hwo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nanǝnya kaama thlǝmaarha hai ngga, sǝk ten karapu ɗanun kii tǝhǝfǝdɗi. ");
INSERT INTO hwo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Fingya sǝkka laɓar Kutǝryid Talara amma sǝnangwa nda hai wa, na nda ƙǝla wiirha hǝrgha hai a kwamana, ɓagha Tǝbǝlfeedɗa ɓa thlanggǝn ǝnɗa ɗǝ hǝf nanda ahur ndan hai. ");
INSERT INTO hwo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fingya wiiya hǝrgha aten keela hai nǝghǝn ƙǝla fingya sǝkka laɓarɗi thlǝghǝn nda fa tǝ wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amma kwa wa thlaara hai ngga wa, mbǝ mǝnda ha wa. A ɓa ɓillaarha ɓa nduwa sǝsaarha ƙǝsǝr ka laɓarɗi, mba nda kwas kyaharra hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Fingya wiiya hǝrgha ahu ndakhkya hai, nǝghǝn aten fingya sǝkka laɓarɗi, amma ɓillaarha yi ƙǝshidɗiya tǝ nggǝmnda ƙǝna ˈyaɓang nggǝn laɓarɗi ˈyaɗang tsǝrha nǝn fa mbǝ ˈyasǝ na nda mbang ǝnaarha ngga wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amma fingya hǝf nǝn ahu chehweerha na ngga nǝghǝn aten nafiya sǝkka laɓar ɗi, sǝnang ngganda hai wal chikrha nda fingya kumnggit mahan-mahan, fingya kumnggit mikki-mikki, tǝ ƙǝm fingya haru-haru.” ");
INSERT INTO hwo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nggǝrgha Yeeso thlǝghang karapu kanda sǝ, ndǝghǝn, “Kutǝryid Talara nǝghǝn kiya: Hǝf niifa wiirha ngga ahu hedghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A fǝɗikrha nana fiya a ɓeena, ɓagha tǝtsanda ɓa hǝf wuthlaafa nǝn a pathlang wiid wan hwalidɗa hai wii fayighǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Katǝrana wan hwalidɗi tsǝrha tǝ yiwee, nagha wuthlaafɗi ƙǝm a tsǝrha.” ");
INSERT INTO hwo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tǝrgha ɓagha fatarya tǝhedɗa ɓa ndang ngganda tǝheedɗi, “Tuwuri nan, hedɗi hǝfang na tǝ wiirha ngga lǝghǝdɗǝ tǝ wuthlaafa! Kyagha nda ɓa a yanggi?” ");
INSERT INTO hwo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ndagha tǝheedɗi, “ ‘Tǝtsanda ni ǝnagha ǝnɗiya!’” Ndagha fataryini, “Ɗan ƙǝɗang kanda ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ndagha tǝheedɗi, “ ‘Awo.’ a ǝna ɗun kee nun ɗǝ ƙǝɗang kanda ɗǝ heu tǝ wan hwalidɗi. ");
INSERT INTO hwo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Malaman kanda tsǝnda kyab ƙǝl a shifiirha ana ɗǝm a halthghǝn. Tǝrgha a ndanggi fahalthya wurang ngganda wuthlaafa sǝ, ƙǝnang ngganda kanda djang ngganda ɗǝ, tǝrgha wan hwalidghǝn iree ƙǝnda ahu ɓirwa hai.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nggǝrgha Yeeso pǝrang karapu kanda, ndǝghǝn, “Kutǝryid Talara nǝghǝn kǝla wan parsǝna tǝrangna niifa hǝfanggǝn hai ahu hedghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wiirha ni na ngguchit kaan ahur wiiya, amma tsǝnǝn sǝ, tsauka ɗǝfrha ni na manggǝn kaan ahur ɗǝfya heu, taksaagha wuɗikkya ƙǝn ndan ahu wuharyighǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nggǝrgha Yeeso pǝrang karapu kanda ndǝghǝn, “Kutǝryid Talara nǝghǝn ƙǝla mekhna yangna nuneefa tǝ humbarha tasau mahan ana ɗǝ a ǝna mburodi. Ko nanǝn ǝnaghǝn mehenɗi sahai ngguchit kiya, nǝn chichaɗang hufgha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kala tsaharha na Yeeso ǝnaarha a fiya wumngga hai ƙǝl tǝ karapu, mbǝ ˈyasǝ nǝn thlǝghang kanda kula karapu wa. ");
INSERT INTO hwo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","“Ndǝn lǝghǝdna laɓar Faara ndanǝn a mii annabi, Niya kalang kunsǝ tǝ karapu, niya pǝr ˈya na ɓǝɓee, ka ǝna nanda ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Malgha Yeeso fiya a ƙǝshi kyagha hur minda hai. Ndangga fatsahayighǝn, “Nan a hwan sa pǝrang ten karapuɗi kan yi wan hwaliirha tǝ wuthlaafa na ahu hedɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nggǝrangga Yeeso kanda sǝ, “Tǝheedɗi ndǝna Wan Niifa hǝfgha wiirha na ngga. ");
INSERT INTO hwo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hedɗi ndǝna ƙǝshiirha, wiirha na ngga ndǝna aten nafiya Kutǝryidɗi. Wuthlaafa ndǝna nafiya Tǝbǝlfeedɗi. ");
INSERT INTO hwo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tǝtsandǝɗi hǝfgha wuthlaafɗi a pathlang wan hwalidɗa ɗǝ ndǝna Sheetan. Halthɗi ndǝna mii ngwala ƙǝshiirha, fahalthyini ƙǝm ndǝna fathlǝngya Faara. ");
INSERT INTO hwo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ƙǝla wurang nanda wuthlaafa sǝ djang ngganda ɗǝ hu waarha, nǝn a naarha kee a mii ngwala ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na Wan Niifa a thlǝn fathlǝnggighǝn, ɗa nda ƙǝɗang ǝngya ɗǝ heu na ahu Kutǝryidghǝn na ɓang ɗimiyirha ɓa tǝ fingya na a ǝna mbǝlfeerha. ");
INSERT INTO hwo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na nda a muwang kanda ahu waarha ɗǝ mbuwa mǝra hai, a mbǝɗani na nanda naarha tǝrha tǝ ƙǝtmee. ");
INSERT INTO hwo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tǝrgha fingya ǝnagha nggayirha na nda a djaara hai ƙǝla yanfaara ahu Kutǝryid Chi ndan. Kala niifa natǝ thlǝmad sǝkrha, sǝkƙǝnǝn!” ");
INSERT INTO hwo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nanǝn kee ndagha Yeeso, “Kutǝryid Talara nǝghǝn ƙǝla ƙǝna na ɓǝɓee walang na niifa hu heerha. Nanǝn tǝ wutsǝfayirha nggǝrghǝn ɓǝɓeng hai hu hedɗi, henggǝn ǝnggighǝn ɗǝ heu ka a wal wuɗǝɓǝla nǝn ngga henggǝn hedɗa sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ƙǝmɗa, Kutǝryid Talara nǝghǝn ƙǝla tǝshafiliirha na a kaɗa djamkwatar. ");
INSERT INTO hwo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ƙǝla nǝn hai na djamkwatarɗi tǝ wuɗǝɓǝla fa, henggǝn ǝnggighǝn ɗǝ heu henggǝn sǝ! ");
INSERT INTO hwo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tǝ ƙǝm, Kutǝryid Talara nǝghǝn ƙǝla panggaama muwang nanda hu wuri aama ɗǝ ƙǝs tǝngya nǝn ɗǝɗamǝn-ɗǝɗamǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lǝghǝdna panggamɗi, kahang ngganda ƙǝƙǝshɓangnda ɓa. Tǝrgha tsawa nda hai, wurang ngganda tǝngya sǝ na nggǝngga ahu kutaasa hai, amma tsamang ngganda fingyayina ɗǝ mbuwa ngga. ");
INSERT INTO hwo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɓanǝn naarha kee a mii ngwala ƙǝshiirha. Na fathlǝngya Faara a ɓaarha ɓa wurang ngganda nafiya ɗǝ na a ǝna mbǝlfeerha ahur nafiya na a ǝna nggayirha. ");
INSERT INTO hwo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na nda a muwang fa mbǝlfeeya ahu waarha ɗǝ mbuwa mǝra hai, a mbǝɗani na nanda naarha tǝrha sǝ tǝ ƙǝtmee.” ");
INSERT INTO hwo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsahangga Yeeso mee fatsahayighǝn, “Sǝnang ɗun ǝnggina hai heu ya wa?” Nggǝrang ngganda sǝ, “Oh, sǝnang ɗan hai.” ");
INSERT INTO hwo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tǝrgha nggǝrghǝn chikƙǝn ndaagha, “Kala tǝmalǝmnda ngyakhrha tsauka tǝtsaharha ahu Kutǝryid Talara nǝghǝn ƙǝla tuwure kyangga hurad tǝ weerǝnda ǝnggighǝn sǝ a mbǝrha ɗǝ ɗǝfnǝn ƙǝnaghǝn sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ngwalangna Yeeso pǝr karapu yini mal mbǝɗa nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wudgha hu talghǝn ɗǝ Nadzarat. Tsaha nǝn ha hu ƙǝn tsahad Yahudaya, fiya heu sǝkka ndǝn ǝna ǝnwulteena na nda, na nda a ndaarha, “Walgha niifɗi tur sǝndǝɗi tǝ sǝsǝmnda ǝna ǝnwulteengya a yanggi?” ");
INSERT INTO hwo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tǝrgha na nda a ndaarha, “Mbǝ wan kafinta ɗani ya, sǝnɗǝm Mairamu man, tǝ wanmanggighǝn nda Yakubu tǝ Yisufu, tǝ Siman tǝ Yahuda? ");
INSERT INTO hwo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kulo wanmanggighǝn nishya ya ahur nǝm. Tsahaghǝn ǝnggini a yanggi ya?” ");
INSERT INTO hwo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nanǝn kee, karghǝnda fa, fǝr wanda ƙǝkafek tǝghǝn wa. Tǝrgha ndangga Yeeso kanda, “Na nda manang nda annabi ko a yanggini ƙǝl ahur talghǝn ahu nafiyighǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Əna ǝnwulteengya nǝn ngguchit kee, ƙǝsǝr ka yamid fǝrƙǝkafekkid ndan. ");
INSERT INTO hwo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A sayidɗi Sǝkna Hirdus Kutǝr chehweed Nggalili laɓar Yeeso, ");
INSERT INTO hwo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ndanggǝn fataryighǝn, “Yahaya Tǝbaptisǝma ni ya thliigha sǝ hu mǝrra! Ndǝn nanǝn tǝ sǝsǝmnda ǝna ǝnwultenggini ya.” ");
INSERT INTO hwo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nanǝnya Hirdus ˈwaɗǝ teena ƙǝsang ɗǝ Yahaya, ƙǝnanggǝn, muwanggǝn hu porsǝna ɗǝ ka Herodiya nu wanman Filibus kahang nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ƙǝsǝr Yahaya nǝn naarha ndang nda Hirdus ahu ngyakhrha Yahudaya kamngwa a kahanggǝn Herodiya wa. ");
INSERT INTO hwo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na mid Hirdus sǝ a ɓǝlanggǝn Yahaya, amma nǝghǝn a tǝrǝm fiya, ƙǝsǝr fiya heu fǝr nda kǝkafek tǝ ndaarha Yahaya Annabi ni. ");
INSERT INTO hwo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Amma a far wutsǝfayid lǝghǝtta ɓen nggǝtta Hirdus, wutarad Herodiya rǝɓanggǝn kanda sǝ, mbǝnanggǝn Hirdus kaan. ");
INSERT INTO hwo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nggǝmɗa fa har tǝ aah thlǝm Faara, kala ˈya na midghǝn nǝn a fǝranggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ndangga man wutaradɗi ɗǝgha ndaarha, “Ten Yahaya Tǝbaptisǝma na minna ahu pǝlee.” ");
INSERT INTO hwo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kutǝrɗi ƙǝm ǝna masǝnɗi kee nǝn aten ˈya ndanǝn, amma ƙǝsǝr ka thlǝm Faara aah nǝn a mbed nafiya mbunǝn ɓa, ǝnang ǝnɗa nda ndanǝn. ");
INSERT INTO hwo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Thlǝn sodjaya nǝn a kyathlang ngganda ten Yahaya ɓa ahu porsǝna. ");
INSERT INTO hwo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ɓang ten ɗa nda wutaradɗa ɓa ahu pǝlee, ɗanggǝnǝn man ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsǝɓaku ɓagha fatsahaya Yahaya ɓa tǝrang ngganda mǝrrǝghǝn ɓa pang ngganda, tǝrgha ɗǝnda ɗǝ pǝranggǝn nda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sǝkna Yeeso laɓarɗi, kyagha hu kombuwol hai, mal mbǝɗa nǝn ɗǝgha mbǝrha ɗǝ ka a tsauka katenggǝn. Amma sǝkna fiya mbǝɗi nanǝn sǝ, mbu samadghǝn nda tǝ saara ahu talya ɓa hangga. ");
INSERT INTO hwo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tǝrna Yeeso hai ahu kombuwol ɗi, na fiya nǝn hangga haɗangganda fa, ƙǝnanggǝn haya. ");
INSERT INTO hwo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na figrha a tsǝrha hai, ɓagha fa tsahayighǝn a thlǝmadghǝn ɓa, ndang ngganda, “Kaheerha ni ya tǝ kǝm tsǝ figrha hai, kalu fiya hai ɗǝnda hu talya ɗǝ, tǝna nda ɗǝ hii ǝnnarhami.” ");
INSERT INTO hwo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Amma nggǝrangga Yeeso kanda sǝ, “Kamngwa a wii nda a miirha wa, fǝraman ˈya kanda ǝna nda mii.” ");
INSERT INTO hwo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ndangga nda, “Mburodi tuf ni kee a harnan, tǝ tǝngya sǝri.” ");
INSERT INTO hwo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ndagha, “Ɓemadghǝn mbǝɗa ɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tǝrgha ndanggǝn fiya tsawanda hai a ten hwaliirha, tǝranggǝn mburodi ɗa sǝ tuf tǝ tǝnggini sǝri, kǝlagha talara sǝ, ɗǝfang parka nǝn in. Kyanggǝn mburodi ɗa hai fǝranggǝnǝn fatsahayighǝn ndǝghang nggǝnda fiya. ");
INSERT INTO hwo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kii nda kanda heu kǝla na mindan pa tsǝghanggǝn kanda, tǝrgha fatsahayighǝn wumangga nda katǝbghǝn kutasya kumkap sǝri. ");
INSERT INTO hwo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hǝshya kiigha mburodi ɗi sǝl nda haru kumnggit tuf, thlǝɗang ngwa nda nishya tǝ wundakhnaya wa. ");
INSERT INTO hwo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsu a mbǝɗi kee, ndangga Yeeso fatsahayighǝn kya nda hu kombuwal hai tǝɗang ngganda wuri aama teena, ndǝghǝnggi ƙǝm ishgha hai kal fiya nǝn hai. ");
INSERT INTO hwo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A kwasamad ɗi kal nǝn fiya hai, tǝrgha wumnda sǝ katenggǝn ka a hwan Faara nǝn, tsǝgha figrha hai ndǝghǝn a mbǝɗi katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amma ahu sayidɗiya kombuwol ɗi inggun ma ƙǝkǝshɓanda, fatsahayini a habɓaarha tǝ ɓereurha tǝ kuɗufulla aama. ");
INSERT INTO hwo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Takhna mbǝrha a ɗathla hai ɓagha Yeeso thlǝman ndan ɓa, a wiirha aten aama. ");
INSERT INTO hwo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nana fatsahayighǝn ndǝn a wiirha aten aamɗi tǝrma nda. Ka hǝreenga huhwa nda, tamngganda ndaarha mǝnda-mǝnda ni. ");
INSERT INTO hwo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amma tsu kee kalangga Yeeso kanda sǝ, “A tǝrǝm ɗun wa nggini ƙǝrsaama.” ");
INSERT INTO hwo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ndangga Siman, “Chinǝm, ana ƙǝkafek sani, ndee ɗi thlǝmad wa ɗǝ a aten aamɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ndangga Yeeso, “Haˈi, ɓoɓa,” tǝrgha siman tǝrgha hai ahu kombuwal ɗi, ƙǝs wiirha nǝn aten aamɗi a thlǝmad Yeeso ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma nanǝn ɓereu ˈyaarɗi tǝrǝmngga, nagha a timnda hai, huhwagha ndagha, “Hǝrye Chinǝm.” ");
INSERT INTO hwo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsu kee Ƙǝsgha Yeeso harghǝn ƙǝsanggǝn ɓa, ndangga Yeeso, “Ƙǝɗi fǝrƙǝkafekkid wa, ƙǝn fǝr waana ƙǝkafek na mbang wiirha aten aamɗi?” ");
INSERT INTO hwo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kyana nda ahu kombuwal hai, ishgha ɓereu ˈyaarɗi. ");
INSERT INTO hwo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tǝrgha fatsahayighǝn ɗǝfang shilee nda in, na nda a ndaarha, “Ƙǝkafek Wan Faarani Sa.” ");
INSERT INTO hwo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A kwasamadɗi tǝɗang na nda wuri aamɗi teena, tǝra nda hai a Djanasarat. ");
INSERT INTO hwo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kukwalang na nafiya talɗa hai Yeeso ni, thlǝn farha nda ahu talya ɗǝ na ahu chehwedɗi kahat. Nagha fiya a ɓarha ɓa tǝ haaya, ka a ƙǝnanggǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hwanggǝnda a malanggǝn haaya tsuwar mii kotodghǝnda fa kee, kala niifa tsuwargha ndǝn fa ƙǝnɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tǝrgha fingya Farisaya tǝ famalǝmngya ngyakhrha thliigha ɓa a Urshalima tsahang mee nda Yeeso, ");
INSERT INTO hwo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kama na fatsahayiwa hwasang ǝntin shingginǝm? Mba nda tsaɓang haryi ndan ɗǝ a hǝb ǝnnarhami nda wa!” ");
INSERT INTO hwo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nggǝrangga Yeeso kanda sǝ, “Kama nun hwasang nda ǝngya ndaana Faara ka ǝntinggi nun? ");
INSERT INTO hwo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ƙǝsǝr ndagha Faara, ‘Fǝrang mamnggirha nda muwa tǝ tsu’ tǝ ƙǝm ‘Kala niifa sargha man nduwa chin tǝtani a ɓǝlang ngganda.’ ");
INSERT INTO hwo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma nun tsaharha ha tǝ ndaarha ana ˈya sǝ a haar niifa na a ɗanggǝn chin sǝ nduwa man, nǝn ndaarha ‘ˈya nun a kya waala a fanna ɗǝfang ɗi ndǝn Faara ɗǝ.’ ");
INSERT INTO hwo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ahu kwamana kiya Mǝmǝlwa a fǝrang mamnggirha nǝn fa nggǝtyighǝn tǝghǝn wa. Nanǝn kee kar laɓar ɗanun fa ndaana Faara ka ǝntin nun. ");
INSERT INTO hwo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kun fathǝrɓuya! Laɓar Faara ndaana Ishaya aten nun mǝmǝlni: ");
INSERT INTO hwo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nafiniya ahu mii ndan ni kee na nda fǝre mamnggirha, amma huryi ndan nǝghǝn inggun ma nggi; ");
INSERT INTO hwo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ka ni kee na nda ɗǝfee shilee teena, ƙǝsǝr ɗǝfang ngganda tsahad ngyakhkya fiya ha a mbee a meyed laɓar Faara.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tǝrgha aagha Yeeso nafini wumngga hai a thlǝmadghǝn ɓa ndǝghǝn, “Keema thlǝmaarha fa tǝnun sǝn ǝnɗi niya thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ˈYa kyagha hur niifa hai mbǝ ndǝna tsawang tǝ ‘paarha’ fa wa, amma ƙǝl ˈya na a kyarha ɓa a miighǝn ndǝna tsawang tǝ ‘paarha’ fa.” ");
INSERT INTO hwo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tǝrgha fatsahayini ɓa nda thlǝmadghǝn ɓa tsahang mee nda, “Sǝnna sǝ sǝb hur Farisayina ɗǝ sǝk nanda laɓarɗi?” ");
INSERT INTO hwo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nggǝrangga Yeeso kanda sǝ, “Kala hǝfrha a mbǝ pǝpa na a talara hǝfgha ndǝn wa, na nda a ƙǝɗang ɗǝ tǝ thlarghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Malaman kanda. Na nda ƙǝla mangya kwamaya na nda a ƙǝs sǝsal kwamaya. Ana kwamarha a ƙǝs sǝsal kwamarha, kanda kyab na nda a mukrha hu kwaarha hai.” ");
INSERT INTO hwo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ndangga Mbiturus Yeeso, “Pǝrang ten karapuɗi kan ya.” ");
INSERT INTO hwo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsahangga Yeeso mee kanda, “Ɓal wun kula sǝnang hai wa? ");
INSERT INTO hwo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kala ˈya ǝnana niifa mii nǝn kyarha hurghǝn ɗǝ nggǝrghǝn kyarha sǝ a fadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma ǝnɗi na a kyarha ɓa ahu mee, kyaghǝn sǝ ahur niifa. Ndǝghǝnni na tsawang nda niifa tǝ ‘paarha’ fa. ");
INSERT INTO hwo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ƙǝsǝr ahur niifa sǝ ndǝna numad mbǝlfeerha kyarha ɓa, tǝ ɓǝl farha, tǝ kulafayirha, tǝ pateyirha, tǝ ngaara, tǝ ƙǝnang paama nggaɓaarha mu tǝ sǝb thlǝma. ");
INSERT INTO hwo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Əngginiya ndǝna tsawang niifa tǝ paarha fa a mbed Faara, amma hǝb ǝnnarhami kula tsab haara mbǝ ndǝna tsawang niifa tǝ paarha fa a mbed Faara wa.” ");
INSERT INTO hwo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tǝrgha Malgha Yeeso Nggalili ɗǝgha hu chehweed Taya ɗǝ tǝ Sidon. ");
INSERT INTO hwo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na nuneefa sǝ tǝ Kanˈana ɓagha thlǝmadghǝn ɓa hwanggǝnǝn, “A haɗoyi fa Chinǝm, Wan Ndauda, ƙǝsǝr wutarad na nǝghǝn tǝ ǝnkaheerha fa nǝn naarha sǝsang nda kaan.” ");
INSERT INTO hwo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma nggǝrang ngwa Yeeso sǝ wa. Tǝrgha ndangga fatsahayighǝn, “Ndang a wiigha, nǝghǝn a ɓilla ƙǝm tǝ hwanda.” ");
INSERT INTO hwo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nggǝrgha Yeeso sǝ, “Thlǝnna nda nggi ɓa ka ɓi ɗang nda chauraya Isǝreela sǝ sahadgha kee.” ");
INSERT INTO hwo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɓagha nuɗa ɓa ɓǝrgha hai a mbedghǝn nggǝrghǝn hwanggǝn, “Chinǝm ɗeesǝ!” ");
INSERT INTO hwo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nggǝrgha Yeeso sǝ, “Kamngwa tǝranggǝm ǝnnadmid wundakhnaya fǝranggǝnǝm wuɗaya wa.” ");
INSERT INTO hwo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nggǝrangga nuɗa sǝ, “Ƙǝkafek ni Chinǝm, amma ko wuɗaya ni na nda hǝb fǝfǝsǝrra ǝnnarhami hǝrgha hai a mbǝd ɗauyad turi ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tǝrgha nggǝrangga Yeeso sǝ, “Sa nuneefa na fǝrƙǝkafekkid wa manggǝn kaan, ˈya na midwa wal nan.” Tsu kee ƙǝngga wutaradɗi keeghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Malgha Yeeso mbǝɗi ɗǝgha wuri aam Nggalili ɗǝ tǝrgha wumnda sǝ tsauka hai. ");
INSERT INTO hwo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wumngga fiya thlǝmadghǝn ɓa hangga. Ɓa nda ɓa tǝ sǝfǝngya, tǝ kwamaya, tǝ fingya mǝrna fandan hai, tǝ fingya mbuwa mbang kaala sǝ tǝ fingya haaya hangga. Ɗǝfang ngganda kanda hai a mbed Yeeso, ƙǝnanggǝn kanda heu. ");
INSERT INTO hwo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ƙǝsangga ǝnwulteena fiya wumngga hai na nanda fingyayini mbuwa mbang kaala sǝ kanda a kaala sǝ, fingya mǝrna fandan hai wal nda ƙǝnda, sǝfǝngya a wiirha hai tǝ ƙǝm kwamaya a na maana hai. Na nda a fal Faara yi Isǝreela. ");
INSERT INTO hwo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tǝrgha aagha Yeeso fatsahayighǝn ɓa ndanggǝn kanda, “Na nafini a haɗee fa ya. Ɓeena mahan kanda a thlǝmadna a mbǝɗiya, tahang ngwa ˈya kanda ha na a ǝna nda mii wa. Mbǝ minna sǝ kal kanda ni hai wii nda wureɗǝ a miirha wa, asǝmha ɗǝgha shiwid kanda teena a kwamana.” ");
INSERT INTO hwo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nggǝrangga fatsahayighǝn sǝ, “A yanggi ɗǝnǝm wal mburodi ɓa a kahedɗi ya na a tsǝghanggǝn fiya hangga kiya?” ");
INSERT INTO hwo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsahangga Yeeso mee kanda, “Mburodi kurmi ni a har nun?” Ndang ngganda, “Mǝd tǝ tǝngya na miɗiɗi ngguchit.” ");
INSERT INTO hwo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ndangga Yeeso fiya wumngga hai a tsawa nda hai a hweeɗe. ");
INSERT INTO hwo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tǝrgha haranggǝn mburodi yina sǝ mǝd tǝ tǝnggini, usa nǝn Faara, kyanggǝn hai kutelth-kutelth. Fǝranggǝnǝn fatsahayighǝn ndǝghang nggǝnda fiya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kanda heu kii nda nggaala nda. Wumangga fatsahayini katǝbghǝn kutasya mǝd. ");
INSERT INTO hwo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nafiya hǝbgha ǝnnadɗami hǝshya haru kumnggit faɗa kula thlǝɗang nda nishya tǝ wundakhnaya. ");
INSERT INTO hwo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Akwasamadɗi kalna Yeeso fiya hai, kyagha ahu kombuwol hai ɗǝgha chehweed Manggadan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farɗasǝ Farisaya tǝ Sadukiyaya ɓa nda thlǝmad Yeeso ɓa ka a ƙǝƙǝrang ngganda, na mindan sǝ a kyaɗang ǝnsakhrha nǝn kanda yi wulteena a talara hai tǝna nda sǝndasǝ nǝghǝn tǝ sǝsǝmnda Faara fa. ");
INSERT INTO hwo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nggǝranggǝn kanda sǝ, “A tsǝ figrha hai, a naɗun fǝrakh amshi tsǝɗǝ yiɓa, nun ndaarha na mbǝrha a naarha kukwar a ɓinda. ");
INSERT INTO hwo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A tsar ƙǝm a naɗun fǝrakh amshi yiɓa, nun ndaarha a weeriya na ˈyaara a ɓaarha. Kun a sǝnang ǝngya hai na a katǝrarha hai a fǝrakh amshi, amma mbun a sǝnang ǝnsakhkya ƙǝshiid weeri hai ya wa. ");
INSERT INTO hwo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ƙǝl fa mbǝlfeeya, tǝ kulafaya ƙǝshiid weeriya kandani na kaɗa ǝnsakhkya, amma ǝnsakhrha niya kyaɗang kanda ndǝna yi annabi Yunana.” Tǝrgha malgha Yeeso kanda wii fayighǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Akwasamadɗi tǝɗang nanda wuri aam Nggalili teena ƙǝlagha fatsahayina hai takhkwa nda mburodi ha ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ƙǝsgha Yeeso thlǝmandan, “Kwarama tǝ mehen Farisaya tǝ yi Sadukiyaya.” ");
INSERT INTO hwo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Katǝrang ngganda ngaala hai tǝ ndan ƙǝsǝr ka takhkwa nanda mburodi ha ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sǝnangga Yeeso ǝnɗa hai na nanda a ndikrha atenggǝn, nanǝn kee ndanggǝn kanda, “Ƙǝɗi fǝrƙǝkafekkid nun! Kama nda nun a ngaala tǝ ndan ka mbuwana mburodi sǝ a har nun? ");
INSERT INTO hwo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɓal wun kula sǝnang hai wa? Ɗal wun teena hai tǝ mburodi tuf hǝɓang ni nafiya haru kumnggit tuf wa, tǝ ƙǝm kutasya kurmi wumang nun katǝpghǝn? ");
INSERT INTO hwo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nduwa mburodi mǝd hǝɓang ni nafiya haru kumnggit faɗa, kutasa kurmi wumang nun katǝpghǝn? ");
INSERT INTO hwo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mani sǝnangwa nun hai tǝ ndaarha mbǝ aten mburodi ni niya tsǝ laɓaara wa? Niya nggǝr ndaarha, ‘Kwarama tǝ mehen Farisaya tǝ yi Sadukiyaya.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tǝrgha a mbǝɗiya sǝnangga fatsahayina hai mbǝ a tsǝ laɓaara aten mekhna na ahu mburodi wa, amma aten tsahad Farisaya ni tǝ yi Sadukiyaya. ");
INSERT INTO hwo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɓana Yeeso chehweed Kaisariya Filibi ɓa, tsahang mee nǝn fatsahayighǝn, “Na fiya a ndaarha wunni Wan Niifa?” ");
INSERT INTO hwo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ndang ngganda, “Fingya a ndaarha Yahaya Tǝ Mbaptisǝma, fingya Ilya, fingya ƙǝm Irmiya nduwa tal ahur annabiya.” ");
INSERT INTO hwo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ndangga Yeeso kanda, “Amma kun wu nuwun a ndaarha wunni nggi?” ");
INSERT INTO hwo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ndangga Mbiturus, “Sani Ƙǝrǝsti, Wan Faara natǝ yibrha ha.” ");
INSERT INTO hwo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ndangga Yeeso, “Tǝ parka ni sa, Siman wan Yunana, mbǝ niifa ni thlǝwogha ǝnɗiya wa, amma Pǝpa ni na a talara. ");
INSERT INTO hwo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Niya ndorha sa Mbiturus, aten ferɗiya ndǝn niya tǝn ƙǝn hwan Faarna, mbuwana sǝsǝmnda hwanga mbang chang hai. ");
INSERT INTO hwo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Niya furo ǝncha kwatmingya yi Kutǝryid Talara. Kala ˈya ƙǝnang nun hai ahu ƙǝshiirha nǝghǝn ƙǝƙǝna hai kee a talara, tǝ ƙǝm kala ˈya kwasang nun hai hu ƙǝshiirha nǝghǝn kukwasa hai ƙǝm a talara.” ");
INSERT INTO hwo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tǝrgha ƙǝs thlǝmad fatsahayighǝn nǝn a pǝrang ndan niifa ndǝghǝnni Ƙǝrǝsti wa. ");
INSERT INTO hwo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ka a farɗi katǝrangga Yeeso pǝranggǝn fatsahayighǝn a pǝpal tǝ ndaarha tǝta ni a ɗǝgha Urshalima ɗǝ ɗǝgha sǝsaarha aten ǝngya hangga ahar shingya tǝ firistaya tǝ famalǝmngya ngyakhrha. Na nda a ɓǝlang nda, amma a far ɓeena yi mahan nǝn a thliirha sǝ ahu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Amma ɗǝgha Mbiturus tǝghǝn man patu ɗǝ ndanggǝn, “A kaptangga Faara ɗǝ, Chinǝm, mbǝ tam katǝrarha hai tǝ sa kee wa!” ");
INSERT INTO hwo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kyahargha Yeeso hai ndanggǝn Mbiturus, “Nduwu hai tǝ nggi sa Sheetan, tsauna fer kii saara ka nggi. Na a ƙǝlang ǝngya kee na mid fiya, amma mbǝ yi Faara wa.” ");
INSERT INTO hwo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tǝrgha ndangga Yeeso fa tsahayighǝn, “Ana mid niifa sǝ tsauka tǝ mbusamad na, tǝta ni malanggǝn nggǝm altenggǝn, tǝranggǝn kaɗidghǝn sǝ mbu samad na nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ƙǝsǝr kala niifa na midghǝn ɗǝfang yiɓǝdghǝn ɗǝ nǝn a ƙǝɗeng nda. Amma kala niifa ƙǝɗengga yiɓǝdghǝn ka nggi, ɗǝfang nǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma chighang nǝn niifa a walɗǝ ǝn ƙǝshiirha heu ƙǝɗenggǝn shingndǝghǝn? Nduwa mani kalgha shingndǝghǝn mu? ");
INSERT INTO hwo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ƙǝsǝr wan Niifa nǝn a ɓarha ɓa ahu mamnggid Chin tǝ fathlǝnggighǝn ngwang kumarha nǝn fiya heu aten ǝngya ǝnana nda. ");
INSERT INTO hwo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niya pǝrang ƙǝkafek kun, na fingya sǝ ƙǝƙǝt a mbǝɗiya mba nda a mǝra wa ƙǝl ma nanda Wan Niifa ɓayi ahu Kutǝryidghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Akwasamad ɓeena mikki tǝrangga Yeeso Mbiturus tǝ Yakubu tǝ Yahaya wanman Yakubu tǝraa nda wumnda sǝ, tǝna nda narha katendan. ");
INSERT INTO hwo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A mbǝɗi nagha fiya ndǝn nggǝrɗa hai a mbed ndan. Nagha pǝmnggǝn a chimnda fa ƙǝla yanfaara, tǝ ƙǝm lukkighǝn tsawa nda pǝpet ƙǝla kukwaryirha. ");
INSERT INTO hwo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kula sǝndǝndan sǝ kyagha nda Ilya ɓa tǝ Musa katǝrang ngganda ndikrha hai tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ndangga Mbiturus Yeeso, “Chinǝm, nǝghǝn ngga nanǝm a mbǝɗiya, a nggǝmna fa, ngwa ǝna chama ni mahan-tal yiwa, tal yi Musa tǝ ƙǝm tal yi Ilya.” ");
INSERT INTO hwo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ndǝghǝn aten ndikrha kee, ɓagha hashbe ɓa nggǝlanggǝn kanda, sǝk urarha nda hai ahur hashbiɗi tǝ ndaarha, “Waana niya, nggǝmni. Kaaman thlǝmaarha fa!” ");
INSERT INTO hwo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sǝkna fatsahayini uradɗi kee fǝla nda hweeɗa hai ka hǝreenga. ");
INSERT INTO hwo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tǝrgha ɓagha Yeeso ɓa tsuwar kanda nǝn fa ndanggǝn kanda, “Thleema sǝ, a tǝrǝm ɗun wa.” ");
INSERT INTO hwo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tǝrang nanda tendan sǝ, ƙǝla nda ɗǝ ko niifa, ƙǝl Yeeso katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na nanda a tǝraa hai a wumndǝɗi, ndangga Yeeso kanda, “A pǝrang ɗun ˈya niifa nanun wa, ƙǝl a thlid Wan Niifa sǝ ahu mǝra.” ");
INSERT INTO hwo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tǝrgha tsahangga fatsahayighǝn mee, “Mani na famalǝmngya ngyakhrha ndaarha annabi Ilya ni a ˈwa wutta ɓa ma Ƙǝrǝsti?” ");
INSERT INTO hwo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nggǝrgha Yeeso sǝ, “Ƙǝkafek ni na Ilya a ˈwa ɓarha ɓa ka ɓagha tangsang ǝngya heu mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma niya ndang nda kun, ˈwad Ilya teena ɓaɗa ɓa, sǝnangwanda hai wa, amma ǝnang ˈya nda fa ƙǝla tǝrna mid ndan. Nǝghǝn kee ƙǝm ɓana Wan Niifa sǝsaarha ahar ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tǝrgha fatsahayini sǝnang ngganda hai nǝghǝn a ndikrha aten Yahaya Tǝbaptisǝma. ");
INSERT INTO hwo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A sar wumndǝɗi, fiya hangga wumngga hai a ƙǝla kanda fa. Ɓagha niifa thlǝmad Yeeso ɓa ɓǝrgha hai ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Chinǝm, a haɗowa waana fa. Nǝghǝn tǝ kacheela fa nǝn sǝsang nda kaan. Nǝn yakh muwang nda hu waarha hai nduwa ahu aama hai. ");
INSERT INTO hwo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ɓang ɗi ndǝn fatsahayiwa ɓa, amma mbang ngwanda ƙǝnang wa.” ");
INSERT INTO hwo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ndagha Yeeso, “Kun nafiya ƙǝshiid weeriya, mbuwa tǝ fǝrƙǝkafek fa mbǝlfeeya! Pakwanɗǝ ni tsaurha tǝ kun? Tǝ ƙǝm pakwanɗǝ ni ƙǝrǝssa tǝ yamid fǝrƙǝkafekkid nun? Fǝreema wanɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tǝrgha Yanangga Yeeso ǝnkaheedɗi na ahur wanɗi, kyagha sǝ mal wanɗa nǝn. Tsu a mbǝɗi kee ƙǝngga. ");
INSERT INTO hwo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Akwasamadghǝn tsahangga fatsahayighǝn mee ɓǝɓee, “Mani ǝnagha ndǝn kyangwa nan ǝnkahedɗa sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ndangga Yeeso kanda, “Ƙǝɗi fǝrƙǝkafekkid nun. Niya pǝrang ƙǝkafek kun, ana fǝrƙǝkafek sǝ a fad nun ngguchit ƙǝla wan parsǝna, nun a ndang nda wumndǝɗi ya, ‘Ndusu a mbǝɗiya a mbǝɗa ɗǝ taarha,’ nǝn a nduwussa. Mbǝ ˈya sǝ na kal kun mu wa.” ");
INSERT INTO hwo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Akwasamadɗi nggǝr nanda wumnda hai a Nggalili, ndangga Yeeso fatsahayighǝn, “Na nda a fǝr Wan Niifa a har fiya hai. ");
INSERT INTO hwo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na nda a ɓǝlang nda, amma akwasamad ɓeena mahan na nda a thleng sǝ ahu mǝrra.” Lǝghǝdgha fatsahayini tǝ sǝbrha hura. ");
INSERT INTO hwo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɓana Yeeso tǝ fatsahayighǝn a Kafarnahum ɓa, fathlǝ tsamngya Ƙǝn Faara na a Urshalima ɓa nda thlǝmad Mbiturus ɓa ndang ngganda, “Mbǝ tǝmalǝm ndǝnun tii tsamnda Ƙǝn hwan Faara na a Urshalima wa?” ");
INSERT INTO hwo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nggǝranggǝn kanda sǝ, “Haˈi, nǝn tiirha.” Kyana Mbiturus hur minda hai tsauna Yeeso sǝ, katǝrangga Yeeso kalang sǝ, “Siman, mana ndaarha aten tsakh miiɗi ya? A har wun na kutǝrya ƙǝshidɗiya thlǝ tsamnda, ahar wanggindan nduwa ahar nafiya pak wa?” ");
INSERT INTO hwo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ndagha Mbiturus, “Ahar nafiya pak.” Ndagha Yeeso, “Nanǝn kee mbǝ wanggindan tiirha wa. ");
INSERT INTO hwo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma mbǝ minnǝm sǝ ƙǝsangganda ƙǝm tǝ ɗimiyirha wa, ɗuwa hu wuri aama ɗǝ ɗa muk nggal aama. Tǝna ˈwana ƙǝsa, inang miighǝn hai na a wal wuɗǝɓǝl wurirha na a tsǝk tii tsamndǝɗi. Harang ɗa tii tsamnduwa tǝ yina.” ");
INSERT INTO hwo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ahu sayidɗiya ɓagha fatsahaya thlǝmad Yeeso ɓa tsahang mee nda, “Wunni manggǝn hu Kutǝryid Faara?” ");
INSERT INTO hwo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aagha Yeeso wundakhne ɓa na ngguchit ishanggǝn a maɗufun ndan. ");
INSERT INTO hwo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tǝrgha ndaagha, “Niya pǝrang ƙǝkafek kun, a malanggun ɗimiyid nun tsawun ƙǝla wanɗi na ngguchit ya wa mbun tam kyarha hu Kutǝryid Faara ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nanǝn kee kala niifa manangwawa altenggǝn tsauka ƙǝla wanɗi na ngguchit ya ndǝghǝn ni na manggǝn hu Kutǝryid Faara. ");
INSERT INTO hwo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kala niifa thlǝgha wundakhne fa ƙǝla yanɗiya ahu thlǝmna nggini thlǝnǝn fa.” ");
INSERT INTO hwo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amma ana niifasǝ kyangga tal ahur wanggini na nggu-ngguchit ya fǝrgha ƙǝkafek a nggi ahu ɗimiyirha hai, a nggushi waghang nda fǝn hǝrha ura mughang ngganda ahu wuri aama ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kawa ƙǝshiirha ƙǝsǝr ka ǝnggini na nda ǝnaarha kyang ngganda fiya hu ɗimiyirha hai. Ənggini na kyang nda fiya hu ɗimiyirha hai tǝtani a ɓagha ɓa, amma na sǝbrha hura a ƙǝla niifɗa fa ǝnagha kee. ");
INSERT INTO hwo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ana harwa nduwa sarwa a kyorha hu ɗimiyirha hai, kyathlang ɗǝ muwangga ɗǝ. A nggushi kyana hu ahu yibrha ɗǝ mbuwa ngwalarha tǝ haara tal nduwa saara tal ma nana tǝ haara kyab nduwa saara kyab muwo wanda ahu waarha ɗǝ mbuwa mǝra hai. ");
INSERT INTO hwo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A kyo yidwa ahu ɗimiyirha hai, ƙǝɗang ɗǝ muwangga ɗǝ. A nggushi kyana ahu yibrha ɗǝ mbuwa ngwalarha tǝ yirha tal, ma muwo wanda ahu waarha ɗǝ mbuwa mǝra hai tǝ yidwa kyab. ");
INSERT INTO hwo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kwarama, a sarɗun wanggini na nggu-ngguchit ya wa. Ƙǝsǝr niya ndang nda kun a talara wan thlǝngya Faar ndan na nda naarha a mbed Pǝpa na a talara. ");
INSERT INTO hwo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ƙǝsǝr Wan niifa ɓanǝnɓa ka a hǝrghanggǝn fingya sahadgha. ");
INSERT INTO hwo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ana niifa tǝ chauraya haru tal, tǝrgha tal sahadgha, ma nǝn ǝnaarha? Mbǝ mal kumnggit wutarihe kap wutarihe a mbǝd lafrha ɗǝgha ka kaɗa yanɗaɗǝ sahadgha wa? ");
INSERT INTO hwo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A walang ɗaɓa, niya pǝrang ƙǝkafek kun, nǝn tǝk mbǝnda fa kaan aten chauradɗi tal ma kumnggit wutarihe kap wutarihe ɗi sahadwa wa! ");
INSERT INTO hwo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nǝghǝn kee ƙǝm, mbǝ nggǝmnda hur Pǝpa ni na a talara ko tal ahur wanggini na nggu-ngguchit ya sahadgha wa. ");
INSERT INTO hwo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","A ǝno shadwa ɗimiyirha fa, ɗuwa thlǝmadghǝn ɗǝ kyaɗang ɗimiyidghǝn, a pathlang nun kun sǝri. A koɗǝ thlǝmaarha fa, wuɗang na ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amma a kowa thlǝmaarha fa wa, turu niifa tal nduwa sǝri ɗun thlǝmadghǝn ɗǝ tǝna laɓaara kyarhaɓa a mii nafiya sǝri nduwa mahan tsauka shedawaya atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A karɗǝ kang thlǝmaarha kanda fa, pǝranggǝn mamngya Ƙǝn Faara. A karɗǝ kang thlǝmaarha mamngya Ƙǝn Faara fa, tsawang niifɗiya tǝ takkwa ɗaharha ni nduwa tǝ thlǝ tsamnda. ");
INSERT INTO hwo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Niya pǝrang ƙǝkafek kun, kala ˈya ƙǝnang nun hai hu ƙǝshiirha nǝghǝn ƙǝƙǝna hai ƙǝm a talara. Kala ˈya kwasang nun hai hu ƙǝshiirha, nǝghǝn kukwasa hai kee a talara. ");
INSERT INTO hwo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Niya nggǝr ndang nda kun, ana nafiya sǝ sǝri ahur nun hu ƙǝshiirha nggǝmngga fa aten ˈya nun a hwanda, Pǝpa na a talara a fǝranggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ƙǝsǝr kala mbǝrha wumna fiya sa hai sǝri nduwa mahan ahu thlǝmna niyi a pathlang ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tǝrgha ɓagha Mbiturus thlǝmadghǝn ɓa tsahang mee nǝn, “Chinǝm, saara kurmi ni chahanggǝn shadna ɗǝ a ǝneeɗǝ ɗimiyirha fa? Saara mǝd wa?” ");
INSERT INTO hwo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nggǝrangga Yeeso sǝ, “Awo, mbǝ katǝra mǝd kee wa, amma kumnggit mǝd katǝra mǝd! ");
INSERT INTO hwo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tsaunǝn kee, Kutǝryid talara nǝghǝn ƙǝla kutǝra na midghǝn kirassa ƙǝnaghǝn na a har mafayighǝn nzǝmngga wuɗǝɓǝla a harghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Katǝrang nǝn hai kee, ɓang niifa nda ɓa nǝn a takkwarha wuɗǝɓǝl wurirha haru kumnggidghǝn tuf. ");
INSERT INTO hwo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nanǝn mbǝ mbang tiighǝn wa, tǝrgha kutǝrɗi ndǝghǝn a heng ngganda ɗǝ tǝ nukkun, tǝ wanggighǝn tǝ ǝngya nanǝn tǝghǝn ha heu a tii kumadɗa nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɓǝrgha mafadɗa hai a mbedghǝn hwanggǝnǝn, ‘Niya hwan sa, ƙǝrsu tǝ nggi, niya tiighǝn heu.’ ");
INSERT INTO hwo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tǝrgha kutǝrɗi haɗanggǝn fa, kalghǝnǝn hai chahang kumadɗa nǝn ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Amma kyana mafadɗi ƙǝshaaɗǝ, ɗǝgha wal shadghǝn mafarha nǝn a takkwarha wuɗǝɓǝl wurirha haru tal. Ƙǝsanggǝn, ˈyaɓanggǝn, ndanggǝn, ‘Tee kumad na.’ ");
INSERT INTO hwo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ɓǝrgha shadɗa hai keeghǝn hwanggǝnǝn, ‘Ƙǝrsu tǝ nggi niya teuƙǝn.’ ");
INSERT INTO hwo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma kargha fa ƙǝsanggǝn muwanggǝn ahu porsǝna ɗǝ ƙǝl tii nǝn wuɗǝɓǝlɗi heu. ");
INSERT INTO hwo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nana fingya mafaya ǝnɗi katǝragha hai, sǝbgha hur ndan ɗǝ. Ɗǝnda thlǝmad kutǝrɗa ɗǝ pǝrang ǝnɗa nda katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tǝrgha kutǝrɗi aah mafadɗa nǝn ɓa chahang nǝn kumarha ɗǝ ndanggǝn, ‘Sa ka wuɗi mafarha! Chahoɗi kumarha ɗǝ na a tenwa ka hwanna nggi. ");
INSERT INTO hwo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mbǝ shadwa mafarha haɗo fa ƙǝla haɗoni fa wa?’ ");
INSERT INTO hwo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tǝrgha kutǝrɗi hu sǝbrha hura muwanggǝn hu porsǝna ɗǝ ƙǝl a tii ɗǝ kumadɗi heu. ");
INSERT INTO hwo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Pǝpa na a talara a ǝnang kun kee a kowunni kargha chahang ˈya shadghǝn ɗǝ tǝ hura tal.” ");
INSERT INTO hwo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngwalang na Yeeso thlǝk ǝnggini ya, mal Nggalili nǝn ɗǝgha hu chehweed Yahudiya ɗǝ na a pǝm kufad Urdun. ");
INSERT INTO hwo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fiya hangga takkwagha samadghǝn ƙǝnanggǝn kanda a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ɓagha fingya Farisaya thlǝmadghǝn ɓa ka a ƙǝƙǝrang ngganda. Tsahang mee nda, “Nggǝm ngyahad nǝm fa a kalgha niifa nukkun hai aten kala ˈya ǝnanǝn wa?” ");
INSERT INTO hwo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nggǝrangga Yeeso kanda sǝ “Karatang nggun ahu ɗeleewar Faara wa? A katǝra ǝna ƙǝshiirha ‘ǝna Faara nuneefa tǝ hǝshneefa.’ Nggǝrghǝn ndaarha, ");
INSERT INTO hwo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Ndǝghǝn ni ǝnagha ndǝn na niifa malang nda man tǝ chin thlǝthlǝɓanggǝn nukkun fa, kanda kyab tsau nda tal.’ ");
INSERT INTO hwo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nanǝn kee mba nda sǝri wa, amma tal ni. Tsaunǝn kee, ˈYa wumangna Faara, a ndǝghang niifa hai wa.” ");
INSERT INTO hwo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsahang mee nda, “Kama nda ndaana Musa niifa mbuwana midghǝn nukkun a fǝrang ɗeleewar kaala nǝn hai, ndanggǝn wiu?” ");
INSERT INTO hwo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nggǝrangga Yeeso kanda sǝ, “Ndaana Musa kee ƙǝsǝr ka kakrakkid ten nun. Amma a katǝradghǝn mbǝ kee wa. ");
INSERT INTO hwo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niya ndang nda kun kala niifa kalgha nukkun hai, a mbǝ nana nuɗi a ǝna kulafayirha wa, nggǝrghǝn kakh nuneefa pak ǝnaɗǝ kulafayirha.” ");
INSERT INTO hwo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ndangga fatsahayighǝn, “Ana ˈyasǝ kee a pathlang nda nuneefa tǝ chimadghǝn nggushi tsauna niifa kula kakhrha.” ");
INSERT INTO hwo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amma ndagha Yeeso, “Mbǝ fiya heu na nggǝm palthɗa fa ya wa, ƙǝl fingya nggǝmang na Faara kanda fa. ");
INSERT INTO hwo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na fingya sǝ nggǝt nanda kulabrha, fingya sǝ ƙǝm firang nanda kanda, fingya sǝ mbǝ mid ndan sǝ kakhrha wa ƙǝsǝr ka Kutǝryid talara. Yi na a mbang thlǝ laɓarɗi ya thlǝghǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tǝrgha ɓang wundakhnaya nda Yeeso ɓa na nggu-ngguchit ka a ɗǝfang parka nǝn kanda teena tǝ ƙǝm hwangga aten ndan. Amma fatsahayighǝn na nda yanang nda nafini na a ɓaarha ɓa tǝ wanggini. ");
INSERT INTO hwo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amma ndangga Yeeso kanda, “Malaman wundakhnaya ɓa nda thlǝmad na ɓa. A karang ɗun kanda fa wa. Ƙǝsǝr Kutǝryid talara yi fingya ni na ƙǝla wanggini ya.” ");
INSERT INTO hwo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɗǝfang haara nǝn kanda teena fǝrang parka nǝn kanda a wiigha. ");
INSERT INTO hwo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɓagha Niifa thlǝmad Yeeso ɓa tsahang mee nǝn, “Mala, mani ǝnaarha na ngga tǝni wal yibrha mbuwa ngwalarha?” ");
INSERT INTO hwo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ndangga Yeeso, “Mani na tsahe mee aten ˈya na ngga? Niifa tǝtal ni kee na ngga. Ana mid wa yibrha mbuwa ngwalaarha, ǝno taara tǝ ngyakhkini.” ");
INSERT INTO hwo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ndangga niifɗi Yeeso, “Yanggi?” Nggǝrangga Yeeso sǝ, “A ɓǝlna farha wa. A ǝnanna kulafayirha wa. A ngaarna wa. A pǝrna nggaɓaarha aten niifa wa. ");
INSERT INTO hwo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Fǝrang mamnggirha nda muwa tǝ tsu. Nggǝmu tuladwa ƙǝla alten wa.” ");
INSERT INTO hwo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ndagha wundǝladɗi, “Lafɗi ngyakhkini ya heu. Ma takhka tsauka tǝta a ǝnee?” ");
INSERT INTO hwo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ndangga Yeeso, “Ana mid wa sǝ tsawana lǝlǝgɗa, ɗuwa ɗǝ ɗa heng ǝnggiwa ɗǝ heu fǝrang wuɗǝɓǝlghǝna fa yamiiya, na wal mbǝd ɗǝfǝdghǝn a talara. Tǝrgha ɓa na ɓa mbu samadna na.” ");
INSERT INTO hwo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amma hǝrǝmna wundǝladɗi sǝkrha kee, wii fayighǝn nǝn hurghǝn sǝsǝɓa ɗǝ, ƙǝsǝr tǝƙǝna ni kaan. ");
INSERT INTO hwo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tǝrgha ndangga Yeeso fatsahayighǝn, “Niya pǝrang ƙǝkafek kun, nǝghǝn pǝɗaghǝn kyagha tǝƙǝna hu Kutǝryid Talara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Niya nggǝr ndang nda kun, nǝghǝn pǝpa kyagha thlǝkhmu ɗǝ tǝ kwat libra ma tǝƙǝna kyagha hu Kutǝryid Faara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sǝkna fatsahayighǝn kee, wulangga teena kanda tsakh mee nda, “A tsauɗǝ kee wunni wal hǝrǝkrha?” ");
INSERT INTO hwo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Amma ƙǝlangga Yeeso kanda ɗǝ ndǝghǝn, “A fad niifa tǝ wasa in mbǝ ǝnaarha hai wa, amma a fad Faara nǝghǝn pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tǝrgha ndangga Mbiturus, “Malang ɗan ǝngya heu mbuɗan samadwa nan, ma nan waala?” ");
INSERT INTO hwo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, ahu ƙǝshiirha na ɓayi, a sayidɗi na Wan Niifa a tsaurha hu mamnggit tsǝnggam Kutǝryidghǝn, kun mbuwa samadna nun a tsaurha hu tsǝnggamngya kumkap sǝri, non a ngwang kumarha turya kumkap sǝri yi Isǝreela. ");
INSERT INTO hwo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kala niifa malgha wure nduwa wanmanggighǝn hǝshya nduwa wanmanggighǝn nishya nduwa chin nduwa man nduwa wanggighǝn nduwa ǝnggighǝn, ka nggi, nǝn a wal ƙǝnaghǝn katǝra haru kum tǝ ƙǝm nǝn a wal yibrha mbuwa ngwalaarha. ");
INSERT INTO hwo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma fingya ˈwagha kanda ni a nggǝl mee, fingya nggǝlgha mee kanda ni a tsaurha a mbee.” ");
INSERT INTO hwo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ƙǝsǝr Kutǝryid talara nǝghǝn ƙǝla tǝheerha wargha ka kaɗa fatarya ɗǝ ka ɓa nda ǝnang taara ahu hed inabidghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ƙǝnang nanda wuɗǝɓǝl paara hai puwanggǝn kanda ahu hedghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tǝrna yanfaara sǝ, kyagha sǝ ɗǝgha wal fiya ahu kasu mbǝ ˈyasǝ na nanda a ǝnaarha wa. ");
INSERT INTO hwo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ndanggǝn kanda ɗaa nda huɗaarha ahu hedghǝn nǝn a teng kanda ˈya kamngga ahu paara. ");
INSERT INTO hwo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nanǝn kee ɗǝnda ɗǝ ɗaa nda huɗang sǝ. Yanfara a sǝrǝkrha tǝ ƙǝm yarna yanfaara hai ǝnagha kee. ");
INSERT INTO hwo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A figrha ɗǝgha wal fingya ƙǝƙǝt. Tsahang mee nǝn kanda, ‘Kama nanun ƙǝƙǝt a mbǝɗiya mbǝ ˈyasǝ nun a ǝnaarha wa?’” ");
INSERT INTO hwo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nggǝrang ngganda sǝ, “Mbǝ niifa sǝ aagha kan wa.” Ndangga tǝhedɗi kanda, “Tsaunǝn kee ɗamaɗǝ ɗun wal fingya na a huɗaarha hu hed na.” ");
INSERT INTO hwo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mukna yanfaara hai, ndangga tǝhedɗi niifɗi na aten hedghǝn, “Ooh fatar yina ɓa teng wuɗǝɓǝl paara na kanda, katǝrang hai tǝ fingya ɗǝgha ɗǝ a kwasamarha ta ten fingya ɗǝ ˈwagha ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Fingya ɗǝgha ɗǝ a figrha teng ngganda kanda, kowunni walɗǝ wuɗǝɓǝl paara. ");
INSERT INTO hwo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Fingya ˈwagha ɗǝ ɓa nanda ka thlǝ yindan ɓa, tamngganda ndaarha na yindan a kal yi fingya. Amma teng wuɗǝɓǝl paara nda kanda ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Thlǝna ndan katǝrang ngganda huhurumnda hai aten tǝhedɗi. ");
INSERT INTO hwo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“‘Nafini ya ɓagha nda ɓa a samarha amma tengga kanda mǝmǝl tǝ kan ǝnagha taara ka a tsar ahu weng-weng nda yanfaara.’” ");
INSERT INTO hwo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Amma nggǝranggǝn tal sǝ ahur ndan, ‘Pashidna, hukki sa wa! Mbǝ ƙǝnanggǝm hai niya teurha wuɗǝɓǝl paara na nda tiirha wa? ");
INSERT INTO hwo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Thlu wuɗǝɓǝl wa wiina. Hurna nggǝmngga niya teng nda nafini ɓagha ɓa a samarha mǝmǝl ƙǝla teu ni. ");
INSERT INTO hwo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kamngwa a ǝna ˈya ni tǝrna minna tǝ wuɗǝɓǝl na wa? Na sǝrǝkrha ka ɗang ni fingya sǝ wa?’” ");
INSERT INTO hwo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Nanǝn kee yi nggǝlgha mee ndǝna a ˈwaarha, yi ˈwaagha ndǝna a nggǝl mee.” ");
INSERT INTO hwo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na Yeeso a ɗǝrha Urshalima ɗǝ, kyalthgha Yeeso man patu ɗǝ tǝ fatsahayighǝn kumkap sǝri ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nǝm a ɗǝrha ta Urshalima ɗǝ, Na nda a fǝr Wan Niifa a har mamngya firistaya hai tǝ famalǝmngya ngyakhrha. Na nda a ngwang kumad mǝrra sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tǝrgha na nda fǝrghǝn a har Romaya hai, waghǝn nda, tsaɗaghǝn nda tǝ ƙǝm tawang ngganda ɗǝ. Amma a far paara yi mahan nǝn a thliirha sǝ ahu mǝra.” ");
INSERT INTO hwo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tǝrgha man wangya Dzabadi. Nda Yakubu tǝ Yahaya, ɓagha thlǝmad Yeeso ɓa tǝ wanggighǝn. Ɓǝrgha hai tǝ waɗedghǝn ka a hwanang ˈya nǝn na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsahangga Yeeso mee, “Mana midwa?” Nggǝranggǝn Yeeso sǝ, “Tsawang wanggini kyana na sǝri ya tal a yisǝmad wa, tal ƙǝm a yi kawad wa ahu Kutǝryid wa.” ");
INSERT INTO hwo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amma nggǝrangga Yeeso kanda sǝ, “Sǝnggun ˈya nun a tsakhrha wa! Nun mbang saarha tǝ wuhuleuɗi ɗini saarha wa?” Nggǝrang ngganda sǝ, “Haˈi nan mbang nda.” ");
INSERT INTO hwo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ndangga Yeeso kanda, “Nun mbang saarha tǝ wuhuleuɗi, amma tsaurha a yisǝmanna nduwa yi kawad na mbǝ nggini fǝrghǝn wa. Taksaagha Pǝpa mbǝyini ya a nafini wurnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sǝkna fingya fatsahaya kum ǝnɗi hwanna nda Yakubu tǝ Yahaya sǝbgha hur ndan ɗǝ tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amma aagha Yeeso kanda thlǝmadghǝn ɓa ndanggǝn kanda, “Sǝnɗunsǝ kutǝrya na hu ƙǝshidɗiya mbuwa Yahudaya na nda kyad sǝsǝmnggit ndan aten nafi ndan, mamnggi ndan ƙǝm na nda kyad sǝsǝmnda aten nafiya na a kamu ndan. ");
INSERT INTO hwo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma ahur nun nǝn a naarha pak. Kala niifa na midghǝn tsauka ndǝghǝnni mamnda tǝtani tsauka niifa ni na a ǝnang taara kun. ");
INSERT INTO hwo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kala niifa na midghǝn a nagha a mbee, tǝtani a tsauka mafad nun. ");
INSERT INTO hwo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ƙǝsǝr ɓad Wan Niifa ɓa mbǝ ka a ǝnang taara nda wa, amma a ǝnang taara nǝn fingya tǝ ƙǝm fǝr yiɓǝdghǝnǝn ka a hǝrghanggǝn fiya hangga.” ");
INSERT INTO hwo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hǝrǝmna Yeeso tǝ fatsahayighǝn mal Djeriko, mbuwa fiya samadghǝn hangga. ");
INSERT INTO hwo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tǝrgha kwamaya sǝri tsau ami kwamana. Sǝnna nda sǝ na Yeeso a mbǝra ɗǝ tǝ kwamanɗi, katǝrang ngganda tǝrang urad ndan sǝ, “Chinǝm, Wan Ndauda, a haɗowan fa!” ");
INSERT INTO hwo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yanangga fiya kanda a nggasa nda hai, amma ɗǝnda mbeeɗǝ tǝ tǝrang urad ndan sǝ kaan, “Chinǝm, Wan Ndauda, a haɗowan fa!” ");
INSERT INTO hwo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sǝkna Yeeso kanda, ishgha hai aah kanda nǝn, “Mana minnun a ǝnanggi kun?” ");
INSERT INTO hwo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nggǝrang ngganda sǝ, “Chinǝm, na minnan sǝ a na mana nan hai!” ");
INSERT INTO hwo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Haɗangga nafini Yeeso fa tsuwar yindan nǝn fa, tsu a mbǝɗi kee na mana nda hai. Tǝrgha mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na Yeeso tǝ fatsahayighǝn a takh ndusang Urshalima fa, ɓa nda hu tala ɓa na nda aarha Mbetafaji ahu Wumngya ɗǝfya Dzaitun. Thlǝngga Yeeso fatsahayighǝn sǝri a ˈwa nda mbeeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ndanggǝn kanda, “Ɗama hu talɗa ɗǝ na a mbǝɗi taarha, a kyaɗun sa hai, nun awal kwaara ƙǝƙǝna hai tǝ wanggǝn a thlǝmadghǝn. Kwasaman kanda hai mbee kanda nun ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A tsahang niifa mee kun, ndaman kee, ‘Na mid Chinǝm sǝ kanda,’ tsu a mbǝɗi kee nǝn a malang kun ɗun ɗǝ tǝ kanda.” ");
INSERT INTO hwo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Katǝrana ǝnɗa haya ka lǝɗang ngganda ˈya ndaana annabi: ");
INSERT INTO hwo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ndang nafiya Urshalima, ‘Kulo, Kutǝr nun ɓayi thlǝmannun ɓa. Niifa ni mbuwana tenggǝn kakrak ɓayi a ƙǝsǝr kwaara, Nǝghǝn ɓayi a ƙǝsǝr wan kwaara.’” ");
INSERT INTO hwo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɗǝgha fatsahayina ɗǝ ǝna nda kǝla ndangna Yeeso kanda. ");
INSERT INTO hwo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓang kwarɗa nda ɓa tǝ wan kwarɗi, lǝlǝɓang ngganda lukki ndan a ƙǝsǝr wan kwarɗa sǝ tsauka atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lǝlǝɓangga fiya lukki ndan hai aten kwamana a mbedghǝn, fingya kǝm kyalth shiiya nda ɓa lǝlǝɓang ngganda a tǝn kwamana. ");
INSERT INTO hwo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nafiya ˈwagha mbeeɗǝ ma ndǝghǝn tǝ fingya na mbusamadghǝn tǝrang ngganda urayi ndan sǝ, kanda ndaarha: “Faala a tsauka aten Wan Ndauda! Parka tsauɗǝ aten, niifɗi na ɓayi ahu thlǝm Chinǝm! Falama Faara na manggǝn a talara!” ");
INSERT INTO hwo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kyana Yeeso a Urshalima hai, wupǝri ɗi kahad wulangga teena kanda, na nda tsakh miiya tǝ ndaarha “Wunni ya?” ");
INSERT INTO hwo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nggǝmangga nafini, “Yeeso ni, annabi ɗi ɓagha ɓa a Nadzarat na a Nggalili.” ");
INSERT INTO hwo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kyagha Yeeso Kǝn Faara ɗǝ na Urshalima katǝranggǝn rǝghang nda nafiya ɗǝ na a hiirha tǝ hǝng nda maɓiya ɗǝ ka sataka. Changgǝlanggǝn tebǝrya fa mbeɗed wuɗǝɓǝlya ɗǝ tǝ kulohod fingya na a heng kataprakkya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndanggǝn kanda, “Ndagha ɗeleewar Faara, ‘Kǝnna nǝm aaghǝn Kǝn hwanda Faara,’ Amma tsawanggun mbǝd ɓǝɓed ngaarya!” ");
INSERT INTO hwo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɓagha kwamaya ɓa tǝ sǝfǝngya a thlǝmadghǝn ɓa ahu Kǝn Faara, ƙǝnanggǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amma nana mamngya firistaya tǝ famalǝmngya ngyakhrha Musa ǝnwultenggini ǝnanǝn, wundakhnaya ma kanda a huhwarha a pǝpal Ƙǝn Faara kanda ndaarha, “Faala tsauɗǝ aten Wan Ndauda.” Amma mamnggini sǝbgha hur ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsahang mee nda Yeeso, “Sǝkna ǝnɗi na wanggini ndaarha ya wa?” Nggǝmangga Yeeso, “Hǝng, ˈWawa nun karatang nda ɗeleewar Faara wa? Ƙǝsǝr ndagha nda, ‘Tsahang ɗun wundakhnaya ha tǝ wufar waya, ka a fal kun nda.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A mbǝɗi kee mal kanda nǝn wudgha Mbetani ɗǝ mǝngga hai a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ɗalthna mbǝrha hai nanǝn a wutta Urshelima ɗǝ, ƙǝsgha miirha ndǝn. ");
INSERT INTO hwo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na shiɓarha nǝn a ƙǝlar kwamana, ɗǝgha thlǝmadghen ɗǝ kǝlagha hai ko wee a uradghǝn kǝl shiiya kee. Tǝrgha ndanggǝn shiɓadɗi, “Ma nggǝrna tam nggǝtta ɓalwa!” Tsu kee hwargha ɗǝfǝdɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nana fatsahayighǝn ǝnɗi katǝragha hai, ƙǝsgha ǝnwulteena kanda kaan, ndanda, “Ƙǝƙǝn hwarna shiɓadɗa ɗǝ ƙǝkar kee ya?” ");
INSERT INTO hwo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tǝrgha ndangga Yeeso kanda, “Niya pǝrang kǝkafek kun, anaɗun tǝ fǝrƙǝkafek fa ngaalanggun alten nun wa, nun a ǝna ǝngya kǝla yanɗiya, nduwa kalgha yanɗamu ya. Nun mbang ndang nda wumndǝɗi ya, ‘Thliusǝ muwana hu wuri aamɗa ɗǝ ya,’ nǝn a katǝrarha hai kee. ");
INSERT INTO hwo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nun hwanang Faara kala ˈya na minnun, a fǝrɗun kǝkafek, nun walghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wudna Yeeso ahu Ƙǝn Faara ɗǝ na a Urshelima katǝranggǝn tsaharhaha, Mamnda Firistayini tǝ shingya nafini ɓanda thlǝmadghǝn ɓa. Tsahang mee nda, “Tǝ sǝsǝmnda wun na ǝna ǝnggini hǝu ya? Wun fǝrowa sǝsǝmndǝɗi ya?” ");
INSERT INTO hwo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nggǝmangga Yeeso kanda, “Niya tsahang mee kun ha tal. A nggǝreeɗun sǝ, niya pǝranggǝn kun tǝ wun fǝreegha Sǝsǝmnda niya ǝna ǝngginiya. ");
INSERT INTO hwo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wun fǝrangga kwamana Yahaya ǝna mbaptisǝma nǝn? Faara fǝrangga wa, nduwa fiya wa?” Tǝrgha thliigha ngaala sǝ a pathlang ndan, ndaa nda, “A ndaa ɗǝm, ‘Faara fǝrangga,’ nǝn a tsakh mee, ‘Kama fǝrwa nun ƙǝkafek tǝghǝn?’” ");
INSERT INTO hwo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Amma a ndaɗǝm, ‘Fiya fǝrangga,’ nǝm a tǝrǝm fiya, ƙǝsǝr fǝr nda ƙǝkafek Yahaya annabi ni.” ");
INSERT INTO hwo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A kwasamadghǝn nggǝrang ngganda sǝ, “Sǝngwan wa.” Tǝrgha ndanggǝn kanda, “Nggi ƙǝm mbi pǝranggǝn kun wun fǝreegha sǝsǝmnda niya ǝna ǝnggini ya wa.” ");
INSERT INTO hwo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Amma ma numa nun? Na niifa sǝ tǝ wundǝlayighǝn sǝri, ɗǝgha thlǝmad tǝ pamǝnda ɗǝ ndanggǝn, ‘Waana, a weeriya ɗǝwa ɗǝ ɗa ǝna taara ahu hed inabi.’ ");
INSERT INTO hwo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tǝrgha ndagha wundǝladɗi, ‘Mbi ɗǝrha ɗǝ wa,’ amma numagha ɗǝgha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tǝrgha chin ɗǝgha thlǝmad tahad wundǝlad ɗaɗǝ ndanggǝn, ‘sa ɗǝwa ɗǝ,’ ndagha wundǝladɗi, ‘hǝng pǝpa, niya ɗǝrha ɗǝ.’ Amma ɗǝwa ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“A hur ndan na sǝri ya yanggi ǝnagha ˈya na mid chin?” Nggǝra nda sǝ, “Yanɗi ˈwanǝn thlǝnda.” Ndangga Yeeso kanda, “Niya pǝrang kǝkafek kun, fathlǝ tsamngya tǝ susuwaya nanda ˈwarha hu kutǝryid Faara ɗǝ ma kun.” ");
INSERT INTO hwo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ƙǝsǝr Yahaya tǝ Mbaptisǝma ɓaɗa ɓa kyaɗang ɗǝ kwamana kun na a tsawun ngga a mbed Faara, amma fǝr wun kǝkafek wa, amma fathlǝ tsamngya tǝ susuwaya fǝr nda kǝkafek tǝghǝn. Ko nanun ǝnggini a katǝrarha hai, karɗun fa fǝrƙǝkafek nun tǝghǝn. 21:32 Luka 3:12; 7:29-30. ");
INSERT INTO hwo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nanǝnya kaaman thlǝmaarha asǝɗarha fa pak. Na niifa sǝ pagha wan ɗǝfya inabi, kanggǝn tǝ kalthmaana, ra mbǝd ˈyaɗa wan inabi nǝn ahurghǝn, nggǝrghǝn ra sǝfa na nzang na tǝƙǝla hedɗa ha a tsaurha a tenggǝn. Tǝrgha nzǝmang hed inabi ɗa nǝn fahuɗaya ha wii tala nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tsǝna shifirha hai, thlǝn mafayighǝn nǝn ɗa nda thlang yighǝn ǝnnarhami ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amma fa nzǝm heeyini kǝsang ngganda mafayini; ɗǝk tal nda, ɓǝlang ngganda tal, muk tahadghǝn nda tǝ ferya. ");
INSERT INTO hwo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tǝrgha nggǝrghǝn thlǝn fingya mafaya thlǝmad ndan ɗǝ, kalgha yanggini ˈwa nǝn thlǝn nda ɗǝ. Fa nzǝm hedɗi nggǝrgha nda ǝnang kanda kǝla yi ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Akwasamadghǝn tǝ hedɗi thlǝn wan hurghǝn nǝn a thlǝman ndan ɗǝ nǝghǝn a numad ndaarha, “‘Mbǝ ngaala sǝ wa na nda fǝrang mamnggirha waana.’” ");
INSERT INTO hwo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Amma nana fa nzǝm heeyini wanɗi keeghǝn ɓayi, ndang ngganda ndan, ‘Yo, kulo tǝ har langaad hedɗi ɓayi ya. Taama ɓǝlanggǝm tǝnǝm har langaad hedɗi.’” ");
INSERT INTO hwo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tǝrgha ƙǝsang ngganda, kahang ngganda ƙǝsǝr kadɗa ɗǝ, ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“A ɓad tǝ hedɗa ɓa, ma nǝn ǝnang nda fa nzǝm hedɗi?” ");
INSERT INTO hwo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mamngya fatakkwayini ndaa nda, “Nǝn a ɓǝlang fa mbǝlfeyini tǝ sǝsaarha na pǝɗaaghǝn, fǝrang hedɗa nǝn nafiya pak, na narha fǝrang yighǝn ǝnnarhami kala shifirha.” ");
INSERT INTO hwo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tǝrgha tsahangga Yeeso mee kanda, “ˈWawanun karatang nda ahu ɗeleewar Faara wa? Ndanǝn: ‘Ferɗi karna fa tǝngya, ndǝn tsaukwa ka feera. Yanɗiya ˈya ni ǝnana Chinǝm, ǝnwulteena ni a yid nǝm.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tsaunǝn kee, niya ndang nda kun, na nda a thlang nda kutǝryid Faara a harnun, fǝrang nggǝnda chehweeya na fǝr wan ɗǝfya ngga.” ");
INSERT INTO hwo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kala niifa mukka ten ferɗa hai, nǝn hwasarha fa ɓatal, ɓatal, amma yi mukna ferɗi tenggǝn hai nǝn a tsarang ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sǝkna mamngya firistayini tǝ Farisayini karapu ɗi, walang ngganda nǝn a thlǝk asǝɗadɗi aten ndan kanda ni fahuɗayini na tǝ mbǝlfedɗa fa. ");
INSERT INTO hwo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na mid ndan sǝ a kǝsang ngganda, amma kanda tǝrǝm fiya wumngga hai, ƙǝsǝr na fiya a ndaarha annabi ni. ");
INSERT INTO hwo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nggǝrgha Yeeso pǝrang laɓara kanda tǝ karapu, ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kutǝryid talara nǝghǝn ƙǝla kutǝra ngwagha fa ka ǝna wutsǝfayid kakhrha nǝn a wanggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Thlǝnanggǝn mafayighǝn ɗǝ ɗa nda aah nafina ɓa mbu nanda kanda ɓa, amma kar nafini ɓarha fa ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tǝrgha nggǝrghǝn thlǝn fingya mafaya ɗǝ tǝ ndaarha, “Ndaaman nafini mbu ni, ngwaɗi wutsǝfayidɗa fa, thleeɗi urad thlaaya na ndǝndaura tǝ kwelya, ngwaɗi fa, ɓamaɓa ƙǝkar.” ");
INSERT INTO hwo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma nafini mbu nǝn ɗǝf wanda teena sǝ wa, tal ɗǝgha heeɗǝ, tahadghǝn ƙǝm ɗǝgha ka ǝna shafilidghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Fingya ƙǝsang ngganda mafayighǝn hai, ɗǝk kanda nda tǝ kǝm ɓǝllang ngganda kanda. ");
INSERT INTO hwo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hufgha kutǝrɗi hur kaan. Thlǝnanggǝn sodjayighǝn ɗǝ ɓǝllang ngganda fa ɓǝl fayina ɗǝ, tǝ kǝm njang ngganda wupǝri ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tǝrgha ndanggǝn mafayighǝn, ʻNgwala ngwa wutsǝfayid kahadɗa fa, amma nafini mbu nǝm ɓa mbǝ kanda ni kamngga a ɓa nda ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Nanǝnya, ɗaama hu kwaman hu wuraya ɗǝ mbu fiya nun ɓa kala niifa nanun ɓa nda hu wutsǝfayidɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nanǝn kee, ɗǝgha mafayini ahu kwaman hu wuraya ɗǝ mbu ka nafiya nda ɓa na nanda tǝ ndǝrwaya, lǝghǝdgha ƙǝn wutsǝfayid kahadɗi tǝ rongya. ");
INSERT INTO hwo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amma kyana kutǝr ɗa ɓa ka ɓagha na ronggi ni mbunǝn ɓa, na niifa nǝn kalwawa kari yi wutsǝfayid kahadɗi. ");
INSERT INTO hwo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsahang mee nǝn, “Pashinna, ƙǝƙǝn kyana mbǝɗa ɓa ya kula sa kal karid wutsǝfayid kahadɗa fa?” Amma mbangwa kamshiɗi nggǝrang sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tǝrgha kutǝrɗi ndanggǝn nafiya na ǝnang taara, “Ƙǝnaman haarghǝn tǝ sarghǝn muwanggun ƙǝshaaɗǝ ahu wula ɗǝ mbǝɗi nanda a tǝrha tǝ ƙǝt mee.” ");
INSERT INTO hwo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ƙǝsǝr nafiya hangga aah nanda, amma ngguchit wurna nda hasǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tǝrgha Farisayini wuma nda hai kaɗa kwamana nda a ɗǝfang takthleera nda Yeeso ka a thlǝk ˈya nǝn tǝna nda ƙǝsang nda. ");
INSERT INTO hwo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Thlǝn fatsaha yindan nda ɗǝ tǝ nafiya Hirdus ka a tsahang mee nda, ndaa nda, “Mala sǝnɗansǝ ka niifa ni sa, na tsahang kwaman Faara fiya ha tǝ ƙǝkafekkirha. Sa kǝm mba wurahasǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nanǝnya pǝranggǝn kan, mani numad wa aten ǝnɗiya, nǝghǝn mǝmǝl a teng tsamnda nan kaisar wa nduwa awo?” ");
INSERT INTO hwo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amma Yeeso sǝnɗǝ numad mɓǝlfedɗi na ahur ndan, ndagha, “Kun fathlǝrɓuya, kama na mid nun a ɗǝfee takthleera? ");
INSERT INTO hwo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Keɗeema pene tii tsamndǝɗi. Fǝrang pene ɗa nda.” ");
INSERT INTO hwo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tsahang mee nǝn kanda, “Shishingnda wunni tǝ thlǝm wun a tenggǝn?” ");
INSERT INTO hwo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ndang ngganda, “Yi Kaisar.” Ndanggǝn kanda, “Fǝraman Kaisar ˈya tsauka yi Kaisar, tǝ kǝm fǝraman Faara ˈya tsauka yi Faara.” ");
INSERT INTO hwo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sǝk nanda kee, ǝna ǝnwulteena nda pa wii fayindan nda. ");
INSERT INTO hwo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsu a farɗi fingya Sadukiyaya ndagha mbǝ thliirha sǝ hu mǝra wa ɓa nda thlǝmad Yeeso ɓa tǝ tsakhmee. ");
INSERT INTO hwo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ndang ngganda, “Mala, ndangga Musa kan, ‘A mǝr wan man niifa malɗǝ nukkun hai kula nggǝtta, na wan man tǝrangsǝ hu langaarha ka a nggǝɗanggǝn sǝ.’ ");
INSERT INTO hwo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nanǝnya, na nafiya sǝ mǝd a wanmanggi. Tǝ pamǝnda kakhka mǝrgha kula wal wee, tǝrgha yi sǝri tǝranggǝn nuɗasǝ. ");
INSERT INTO hwo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Amma wan man yi sǝri mǝrgha ƙǝm, yi mahan wai kee har ta ten yi mǝd ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Akwasamadghǝn, nuɗi ƙǝm mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nanǝnya, ahu thliirha sǝ hu mǝrra na nuɗi tsaurha yi wun tsaunǝn kanda heu mǝd, tǝrang nda nuɗasǝ?” ");
INSERT INTO hwo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nggǝrangga Yeeso kanda sǝ, “Numad nun mbǝ mǝmǝl wa ƙǝsǝr sǝnggun Laɓar Faara na chichireethlee hai tǝ sǝsǝmndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Thliirha sǝ hu mǝra mbǝ nishya tǝ hǝshya kakhrha wa. Nanda tsaurha kǝla fathlǝngya Faara a talara. ");
INSERT INTO hwo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amma aten thliirha sǝ hu mǝra, karantanggun ˈya ndang na laɓar Faara kun wa? ");
INSERT INTO hwo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nggini Faara yi Ibrahim, Faara yi Ishaku, tǝ ƙǝm Faara yi Yakubu’. Mbǝ Faara ni yi mǝrya wa, amma yi fingya natǝ yibrha fa.” ");
INSERT INTO hwo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sǝkna fiya ndǝn wumngga hai, ǝna ǝnwulteena nda tǝ tsahayighǝn ha. ");
INSERT INTO hwo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Amma sǝkna Farisayini tǝ ndaarha nggǝlangga Yeeso mii Sadukiyayini tǝ laɓaara nggǝrang nǝn kanda sǝ, wuma nda hai ka a nggǝra nda tsahang mee. ");
INSERT INTO hwo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tal ahur famalǝmngya ɗeleewar Musa, na midghǝn sǝ a ɗǝfang takthleera nǝn tsahang mee nǝn Yeeso, ");
INSERT INTO hwo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mala yanggini manggǝn ahur ngyakhkya heu?” ");
INSERT INTO hwo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nggǝmangga Yeeso, “Nggǝmu Chinǝm Faarwa tǝ hurwa heu, tǝ shingnduwa heu tǝ huten wa heu. ");
INSERT INTO hwo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yanɗiya ndǝna katǝra ngyakhrha na mam. ");
INSERT INTO hwo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yi sǝri ƙǝm nǝghǝn manggǝn: ʻNggǝmu tuladwa ƙǝla altenwa. ");
INSERT INTO hwo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngyakhrha heu tǝ tsahad annabiya ha na nda aten ngyakhkini sǝri ya.” ");
INSERT INTO hwo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wumna Farisaya hai tsahangga Yeeso mee kanda, ");
INSERT INTO hwo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mani numad nun aten Ƙǝrǝsti? Wan wunni?” Ndang ngganda, “Wan Ndauda ni.” ");
INSERT INTO hwo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nggǝrangga Yeeso kanda sǝ, “Ƙǝƙǝn na Ndauda tǝ sǝsǝmnda Sǝsǝna aaghǝn ‘Chinǝm’? Ƙǝsǝr ndagha Ndauda, ");
INSERT INTO hwo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ndangga Chinǝm yina China: ‘Tsawu a yisǝmanna, ƙǝl a tsawangɗi fatsanggiwa a kamu saryiwa.’ ");
INSERT INTO hwo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ana Ndauda a aah Ƙǝrǝsti ‘Chinǝm,’ ƙǝƙǝn nǝn tsaurha wanggǝn?” ");
INSERT INTO hwo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mbǝ niifa sǝ mbangga nggǝrang sǝ wa, ka farɗi mbǝ niifa sǝ ndengga yidghǝn nggǝrghǝn tsahang mee wa. ");
INSERT INTO hwo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tǝrgha Yeeso ndanggǝn fiya wumngga hai tǝ fatsahayighǝn, ");
INSERT INTO hwo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Famalǝmgya ngyakhrha tǝ Farisaya kanda ni nggǝmang na nda kanda fa a pǝr ngyakhrha Musa nda. ");
INSERT INTO hwo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nanǝn kee tsahama tǝ ƙǝm ǝna taara nun tǝ ˈya ndang nanda kun, amma a ǝnaɗun kǝla nanda ǝnaarha wa, ƙǝsǝr mba nda ǝna ˈya na nanda a tsaharhaha wa. ");
INSERT INTO hwo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nanda ɗǝfang rǝfrha fiya in na haghǝn, amma kanda tǝ alten ndan mba nda thlar kanda ko tǝ wan haara wa.” ");
INSERT INTO hwo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na nda ǝna tar ndan ka a nagha fiya kanda, nanda ƙǝn masparma natǝ chireethla laɓar Faara a pǝmnggindan, na nda ndǝn pǝratsan nzǝnzang a mii karindan. ");
INSERT INTO hwo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yakh mid ndan tsaurha a mbǝd tsaukya na nggǝngga hu teera, tǝ kǝm mbǝd tsaukya natǝ thlǝma a ƙǝn tsahad Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na mid ndan a ndangˈya nda kanda yi mamnggirha a nan nda a wiirha hai ahu kasu, tǝ ƙǝm nagha fiya a aah kanda, Mala. ");
INSERT INTO hwo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“A nggǝmna fa a aah sa nda ‘Mala,’ wa ƙǝsǝr tǝmalǝmnda tǝtal ni, kun heu nuwun tal a wanmanggi. ");
INSERT INTO hwo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A aah ɗun kowunni ahu ƙǝshidɗi ya ‘Pǝpa’ wa, ƙǝsǝr Faara na talara ndǝna Pǝpa hu Sǝsǝna. ");
INSERT INTO hwo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A nggǝmna fa aagha kowunni sa ‘Mala’ wa, ƙǝsǝr tǝmalǝmnda tǝtali ni, ndǝna, Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yi na manggǝn ahur nun tǝta ni a tsauka mafad nun. ");
INSERT INTO hwo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amma kala nafiya manangga altenggindan nanda tsaurha ngguchit, tǝ kǝm nafiya tsawangga altenggindan ngguchit nanda manang kanda. ");
INSERT INTO hwo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Amma kawama, kun famalǝmngya ngyakhrha Musa tǝ Farisaya, fathlǝrɓuya! Nggǝlanggun kwatminda kyarha hu kutǝryid talara ɗǝ ma fiya. Kun tafad nun kyawun sa ɗǝ wa, ˈyaɗang kwamana nun fiya na mindan kyarha sa ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kawama famalǝmngya Ngyakhrha tǝ Farisaya, ndirwiya, nun hǝb karid nishya mǝrna chimayi ndan, non naarha hwan Faara kaan ka a na kun nda. Tsaunǝn kee na nda a ngwang kumarha kun sǝ na pǝɗaghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kawama, famalǝmgya ngyakhrha tǝ Farisaya, fathlǝrɓuya! Nun wii tala aten chehweerha tǝ wuri aama ka wal niifa nun malangga ɗimiyidghǝn, a malang ɗǝ ɗimiyidghǝn, nun sǝɓang nda ɗǝ kaan kal kun nǝn ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kawama, kwamaya na kyad kwamana! Nun ndaarha, “Kala niifa aagha thlǝm Faara tǝ Ƙǝn Faara, mbǝ ɓillarha sǝ wa, amma kaala niifa aagha thlǝm Faara tǝ tǝfasa yi Ƙǝn Faara, tsau ɗǝ tǝta a ǝna ǝnɗa nǝn aah nǝn Faara a tenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kun nur kwamaya! Yanggi ni manggǝn, tǝfasa wa nduwa Ƙǝn Faara na a Urshalima tsaɓangga tǝfasa ɗǝ wa? ");
INSERT INTO hwo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nun ndaarha, “Kaala niifa aagha Faara tǝ ‘mbǝd fǝr Sataka,’ mbǝ ɓillarha sǝ wa, amma niifa aagha thlǝm Faara tǝ ǝnfǝra na a mbǝd ǝna Sataka, tǝtani ǝna ǝnɗa nǝn ndanǝn nǝn a ǝnaarha.” ");
INSERT INTO hwo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kun kwamaya! Yanggini manggǝn, ǝnfǝrɗi wa nduwa mbǝd nji sataka tsaɓangga ǝnfǝr ɗaɗǝ wa? ");
INSERT INTO hwo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tsaunǝn kee, kala niifa aagha thlǝm Faara tǝ mbǝd nji ǝnfǝra, aah nǝn Faara tǝ ˈya na tenggǝn heu. ");
INSERT INTO hwo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A anna thlǝm Faara tǝ Ƙǝn Faara na a Urshalima, aah na thlǝm Faara na tǝ tsaurha a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A anna thlǝm Faara tǝ Talara, na aah tsǝnggam Faara, tǝ ndǝghǝn na tǝ tsaurha ahu tsǝnggamɗi. ");
INSERT INTO hwo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kawama famalǝmngya ngyakhrha Musa tǝ farisaya, fathlǝrɓuya! Nun fǝr ǝn fǝrrǝ nun tal ahu kum yi shi chimbee amma malanggun ǝngya na nggǝngga ahu ngyakhrha, ndǝna, ƙǝkafek, haɗang ndan fa, tǝ nggayirha. Ənggina ni kamngga na nggǝngga a ǝnon ya, a malang ɗun fingya wa. ");
INSERT INTO hwo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kun kwamaya fa kyad kwamana, nun kang aama hai amawa nun muɗang kukwakhtaara amma nun muɗang thlǝkhmu. ");
INSERT INTO hwo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kawama, famalǝmgya ngyakhrha Musa tǝ Farisaya, fathlǝrɓuya! Nun tsaɓang ƙǝsǝr wuhuleurha ɗǝ tǝ tasau, amma ahurghǝn nǝghǝn lǝlǝgɗa tǝ nggǝm alteena tǝ hukrha! ");
INSERT INTO hwo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sa kwamad tǝfarisarha! Tsaɓang hur wuhuleurha ɗǝ tǝ tasau ˈwan, tǝna ƙǝsǝrghǝn narha tsǝtsaɓaɗǝ ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kawama, famalǝmgya ngyakhrha Musa tǝ Farisaya, fathlǝrɓuya! Nuwun kǝla ten kwaya ƙǝmang nanda tǝ penti na pǝpet, nagha ngga hu yirha, amma hurghǝn lǝlǝgɗa tǝ aal nafiya mǝrgha tǝ paarha ɗǝɗamǝn-ɗǝɗamǝn. ");
INSERT INTO hwo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tǝ ƙǝm ahu yirha naa fiya a na kun ka nafiya, amma ahur nun sǝ nuwun lǝlǝgɗa tǝ thlǝrɓuyirha tǝ mbǝlfeerha.” ");
INSERT INTO hwo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kawama, famalǝmgya ngyakhrha Musa tǝ Farisaya, fathlǝrɓuya! Nun tǝn ten kwaya a annabiya, tǝ kǝm nun sakhɗang nda ten kwaya yi ka fiya fǝrgha ƙǝkafek a Faara. ");
INSERT INTO hwo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tǝrgha nun ndaarha, ‘Andam nǝghǝm sǝ a sayid chichiyinǝm, kam ɗangwan kanda sǝ ɓǝlang nda annabiya wa.’ ");
INSERT INTO hwo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Amma a naɗun a ndaarha kee, nun a thlǝghanggǝn altennun tǝ ndaarha kunni chichiya nafini ɓǝlangga annabi yini. ");
INSERT INTO hwo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɗama mbeeɗǝ ngwalanggǝn ˈya katǝrangna chichiyi nun hai.” ");
INSERT INTO hwo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kun huthlingya, wangya huthlingya na tǝ mbǝlfeerha yid! Ƙǝƙǝn nun hǝrǝkrha ma ngwa kumad hwanga? ");
INSERT INTO hwo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsaunǝn kee niya thlǝnang annabiya kun ɗǝ tǝ fasǝngya, tǝ famalǝmngya ngyakhrha Musa. Amma nun a ɓǝlang fingya tǝ taurha ɗǝ, nun a tsaɗa fingya ahu ƙǝn tsahad Yahudaya, nun takkwa kanda tala-tala, kun a sǝsang kanda. ");
INSERT INTO hwo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tsaunǝn kee, niya thlǝnang nafina ɗǝ ya ƙǝsǝr na hakked ka nafini ɓǝlang nun a tsaurha a ten nun heu ka a sayi far Habila kaniifa ɗǝgha ten Dzakariya wan Mberikiya, ɓǝlang nun a pathlang Ƙǝn Faara na a Urshalima tǝ mbǝd ǝna sataka. ");
INSERT INTO hwo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niya pǝrang kǝkafek kun, na ǝnggini a katǝrarha hai hu ƙǝshiid weeriya. ");
INSERT INTO hwo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aiya Urshalima, Urshalima! Fa ɓǝl annabiya tǝ muk fathlǝngya Faara tǝ feera thlǝnna nda thlǝmadwa ɗǝ! Saara kurmi tǝrna minna a wumanggi kun kamuna ɓa kǝla na ɗiyarha ngwang wanggighǝn kamughǝn ɗǝ, amma karɗun fa. ");
INSERT INTO hwo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kǝlama hai nanǝnya, malang nda wuri nun kun fa tsauɗǝ kwad wure. ");
INSERT INTO hwo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ƙǝsǝr niya pǝranggǝn kun, mbun a nggǝr na nggi ɓal wa ƙǝl fara ndanun, “Tǝ parkani niifɗi na a ɓarha ɓa hu thlǝm Chinǝm.” ");
INSERT INTO hwo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na Yeeso a mal Ƙǝn Faara na a Urshalima, kyaɗangga fatsahayighǝn tur tǝngya Ƙǝn Faara. ");
INSERT INTO hwo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amma nggǝranggǝn kanda sǝ, “Naɗun tur tǝnggini na heu ya? Niya pǝrang kǝkafek kun, mbǝ feera sǝ ko tǝtal na nda a mala aten shadghǝn wa, kahad nanda chang nda kanda hai!” ");
INSERT INTO hwo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsǝɓaku na Yeeso tsau a ten ɗǝfya wumnda Dzaitun, ɓagha fatsahayighǝn thlǝmadghǝn ɓa ɓǝɓee ndang ngganda, “Pǝranggǝn kan a kwan na ǝnggini katǝrarha hai ya? Mani a tsaurha ǝnsakhrha wuttuwa ɓa tǝ ngwala mii ƙǝshiirha?” ");
INSERT INTO hwo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ndangga Yeeso kanda, “Kwarama, a nggǝmɗun fa nggaɓagha niifa kun wa, ");
INSERT INTO hwo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ƙǝsǝr nafiya hangga na a ɓarha ɓa hu thlǝmna, na nda a ndaarha, ‘Nggini Ƙǝrǝsti,’ har na nda nggaɓa fiya hangga. ");
INSERT INTO hwo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nun a sǝk laɓar yangya, tǝ mii ndaama aten yangya, amma a tǝrǝmɗun wa, tsauɗǝ tǝtani a katǝragha ǝnggini hai, amma ɓawa mii ngwaladghǝn ɓa ˈwan wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na tur a thleng tur fa tǝ yanda, na kutǝryirha a thleng kutǝryirha fa. Na miirha a narha sǝ tǝ rǝprha ƙǝshiirha fa a mbǝya ɗǝɗamǝn-ɗǝɗamǝn. ");
INSERT INTO hwo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amma heu ǝngginiya katǝra mii sǝsarha ni kee.” ");
INSERT INTO hwo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na nda a ƙǝsang nda kun, sǝsang ngganda kun tǝ kǝm ɓǝlang ngganda kun. Ƙǝshiirha heu na nda kar kun ƙǝsǝr ka thlǝmna. ");
INSERT INTO hwo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Fiya hangga na a mal fǝrƙǝkafekkid ndan, na nda a fǝr ndan tǝ kar ndan. ");
INSERT INTO hwo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na annabiya fa nggaɓaya a kyarhaɓa hangga, nggaɓa fiya nda hangga. ");
INSERT INTO hwo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na mbǝlfeerha a mulgha hai, nggǝm ndan nǝn a tsaurha shishiu. ");
INSERT INTO hwo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma kala niifa ƙǝrǝsgha ta mii ngwaladghǝn ɗǝ nǝn a hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Laɓarɗi na Mbǝnggǝn yi kutǝryid Faara na nda a pǝrghǝn kahad hu ƙǝshiirha ɗǝ, ƙǝsǝr ka sǝkka talya ndǝn; a mbǝra ɓagha mii ngwaladghǝn ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nun a naa ǝn tsanda na rǝk fiya, ƙǝt hu Ƙǝnna na Chahal ƙǝla ndaana annabi Ndaniyel. (Ngwa walangga tǝ karatarha), ");
INSERT INTO hwo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tǝrgha nafiya na ahur Yahudiya tǝtani ɗanda wumngya sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Niifa na aten ƙǝnna a ndaa ɗǝ nǝn a tǝra hai ɗǝgha tǝr ˈya ɓa a wuri wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Niifa na hee a ndaa ɗǝ nǝn wutta wure ɗǝ ɗǝgha tǝrang kootodghǝn ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nǝn a tsaurha ǝn kawa a nishya na a hur tǝ nishya na tǝ waya ƙǝsǝr ahu sayidɗi! ");
INSERT INTO hwo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hwanama Faara amana ɗadɗi naarha a sayid mbiirha nduwa afar yibrha Yahudaya wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ƙǝsǝr a farɗi na sǝsarha a naarha sǝ kaan ˈwawa tam naarha sǝ kee ka a far katǝra ƙǝshiirha ta weeri ɗaɓa ya, mbǝ turghǝn a nggǝr naarha sǝ ɓalwa. ");
INSERT INTO hwo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A mbǝ thlaghang nanda ɓenggina haaɗǝ ya wa, mbǝ niifa sǝ na a naarha tǝ yibrha wa. Amma ƙǝsǝr ka nafiya wurna Faara ndǝn nanda thlahang ɓenggina haaɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ahu sayidɗi a ndang niifa kun, ‘Kuloɗǝ, kulo Ƙǝrǝsti ɗiya!’ Nduwa ‘Kulo ndǝghǝn taarha!’ A fǝrna ƙǝkafek sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ƙǝsǝr na fa nggaɓaya Ƙǝrǝsti sǝ tǝ fa nggaɓaya annabiya a kyarhaɓa, na nda a ǝna ǝnsakhkya mǝmanggǝn tǝ ǝnwuteengya ka a nggaɓa fiya nda har tǝ fingya wurna nda anaɗǝ a ǝnaarha hai.” ");
INSERT INTO hwo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Ƙǝlama hai, ˈWaɗi teena yanangɗi kun ƙǝtǝm.” ");
INSERT INTO hwo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nanǝn kee a ndang niifa kun, ‘Kulo ndǝghǝn taarha a kaheerha,’ a kyaɗun ƙǝsha ɗǝ wa; nduwa, ‘Kulo ndǝghǝn ahur ƙǝnna ya,’ a fǝrɗun ƙǝkafek sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ƙǝsǝr ƙǝla na ˈyaara kyatta a man kyat faara nǝn djaara hai ta man hǝmndǝghǝn ɗǝ, nanǝn kee na wutta Wan niifa ɓa a narha kee.” ");
INSERT INTO hwo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Mbǝrha nana mǝrra sǝ, a mbǝɗani na sǝkhɗiya wumnda sa hai.” ");
INSERT INTO hwo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Akwasamad sǝsadɗi ya, “ ‘Na yanfaara a tsaurha wula, ndǝree ƙǝm mbǝ a kyat kukwaryirha wa. Na wufǝlngarya mukrha hai a fǝrakh-amshi, ǝngya na mǝmanggǝn na talara nanda tsǝˈyafa.’” ");
INSERT INTO hwo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ahu sayidɗi na nda a naa ǝnsakhrha a fǝrakh-amshi yi Wan niifa. Nafiya ƙǝshiirha heu nanda tǝrha ka hǝreenga. Nanda a na Wan niifa ɓayi ahu hashmbe a fǝrakh-amshi hai, tǝ sǝsǝmnda tǝ mamnggirha kaan. ");
INSERT INTO hwo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nǝn a thlǝn fathlǝnggighǝn ɓa tǝ pi kodwomnda, na nda wumang nafighǝn ɓa na wuwura hu kudma faɗa na ahu ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nanǝnya tsahama ˈya a fat shiɓadɗiya, ana wuhwaryighǝn a kyaharra hai, nǝn a tsǝtsǝtta, nun sǝndasǝ nduwus fegrha ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nǝghǝn kee kǝm, anaɗun ǝnggini heu ya, nun a sǝnda sǝ nduwus wuttǝghǝn ɓa, nǝghǝn a mii kwatminda fa. ");
INSERT INTO hwo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Niya pǝrang ƙǝkafek kun, nafiya ƙǝshidɗiya mba nda mǝra wa, kǝl ma katǝra ǝnggina hai ya. ");
INSERT INTO hwo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nda talara tǝ hweeɗe na nda a ngwalarha hai amma Laɓarna mbǝ tam ngwalarha hai wa.” ");
INSERT INTO hwo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mbǝ niifa sǝ sǝngga farɗi, nduwa sayi na ǝnggini a katǝrarha hai ya wa, ko fathlǝngya Faara na talara nduwa Wanggǝn tafadghǝn wa, ƙǝl Chin katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ƙǝla katǝra nǝn hai a thlakh mbǝd Nuhu, nǝn a naarha kee a far wutta Wan niifa ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A faryini kapa na aam afa afa ɗi ɓarha ɓa, fiya a hǝbrha tǝ saarha, kanda kakhrha tǝ fǝr wanggindan chimarha ɗǝ, ta farɗa ɗǝ kyana Nuhu hu kombuwol hai. ");
INSERT INTO hwo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sǝngwanda ˈya na katǝrarha hai wa, har ɓana aam afa afa ɗaɓa hwanggǝn kanda ɗǝ. Nǝn a naarha kee a far wutta Wan niifa ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nafiya sǝri a ǝna taara kyab a hee, na nda tǝr tal mal tahadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nishya sǝri a hǝrha ahu fǝna, na nda tǝrang nda tal mal tahadghǝn nda.” ");
INSERT INTO hwo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tsaunǝn kee, tsawama nggungwa fa, ƙǝsǝr sǝnggun farɗi na Chinun a ɓarha ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amma a sǝnunsǝ: A ndam na turi ɗi a sǝn farɗi na ngaara a ɓarha ɓa a fiɗikrha, kam mbǝ a shiirha malanggǝn ngaarɗi kyagha minda keeghǝn hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nanǝn kee tsawama nggugwafa, ƙǝsǝr na Wan Niifa a ɓarha ɓa a sayidɗi sǝngwawa nun sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wunni mafadɗi na tǝ ƙǝkafek fa, ɗǝfang na turighǝn tǝkǝla wurighǝn ha, na fǝrang ǝnnarhami fingya mafaya ahu sayidɗi kamngga? ");
INSERT INTO hwo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nǝn a naarha ngga a fad mafadɗi a wud turighǝn ɓa ɓagha walghǝn a ǝna targhǝn. ");
INSERT INTO hwo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Niya pǝrang kǝkafek kun, nǝn a ɗǝfang nda tsauka mam a ten karidghǝn heu. ");
INSERT INTO hwo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma andam mafadɗi tǝ mbǝlfeerha ni, nǝn a ndang nda altenggǝn, ‘Turina mbǝ a wutta ɓa wet wa.’ ");
INSERT INTO hwo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tǝrgha katǝranggǝn ɗǝk fingya mafaya hai, ndǝghǝn a hǝbrha tǝ sarha tǝ fingya na a nggal mbalya, ");
INSERT INTO hwo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","a ǝnaɗǝ kee na turighǝn a wutta ɓa ahu sayidɗi tǝ farɗi sǝngwawa nǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nǝn a kyathlang nda ɗǝ ɗawal-ɗawal tǝ kǝm fǝrang mbǝrha nǝn a thlǝmad fa thǝrɓuya. A mbǝɗi na tǝrha sǝ tǝ ƙǝt mee.” ");
INSERT INTO hwo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tǝrgha ndagha Yeeso, “Kutǝryid talara nǝghǝn ƙǝla wutaraya kum tǝrang nanda patillad ndan ka ɗaa nda wal wutsamnda. ");
INSERT INTO hwo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tuf ahur wutarayini nurya ni, tuf ƙǝm na nda ndǝndǝl. ");
INSERT INTO hwo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Fingya yini na nurghǝn takhkwa nda fǝɗeerha haɗǝ ka ɗaa nda ira hu patilla yindan hai wa. ");
INSERT INTO hwo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amma fingyayini tuf na ndǝndǝl takh nda fǝɗeerha haɗǝ ahu ƙǝthlikrha ka patilla yindan. ");
INSERT INTO hwo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɓawana wutsamnda ɓa wed, ƙǝsgha ɓeena kanda shii nda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“A manad fǝɗikrha thlii nda sǝ ka mbeela sǝk nanda. ‘Kulo wutsamnda ya thleema sǝ ɗun hwathlaghǝn fa!’ ");
INSERT INTO hwo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tǝrgha wutarayini kum thlii nda sǝ tangsang ngganda patilla yindan. ");
INSERT INTO hwo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nurya wutarayini tuf tsahang fǝɗeerha nda wutarayini tuf na ndǝndǝl, Naghan a hwan kun, ‘Ənaman fǝɗed nun kan ha ngguchit lee, ƙǝsǝr na patilla yinan a mǝra hai.’ ");
INSERT INTO hwo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Amma nggǝrangga fingyayina sǝ, ‘Mbǝ tsǝghang ƙǝm heu wa. Ɗama ɗǝ ɗun hii yinun ɓa.’” ");
INSERT INTO hwo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wii nanda ka hii fǝɗedɗa ɗǝ, a samad ndan ɓagha wutsamnda ɓa. Tǝrgha fingya yini ngwagha fa kya nda a mbǝd wutsǝfayid kahadɗa ɗǝ, chang ngganda kwakirma. ");
INSERT INTO hwo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsǝɓaku sǝlgha fingya yina ɓa ɗǝgha ka hii fǝɗedɗa ɗǝ, isha nda a ƙǝshi na nda a aah farha, “Chinǝm! Chinǝm! Inang kwakirma kan hai!” ");
INSERT INTO hwo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma nggǝrangga wutsamnda kanda sǝ, “Ƙǝkafek, sǝngwi kun wa.” ");
INSERT INTO hwo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Tsaunǝn kee tsawama nggungwa fa, ƙǝsǝr sǝnggun farɗi nduwa sayidɗi niya wutta ɓa wa.” ");
INSERT INTO hwo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tǝ ƙǝm kutǝryid Talara nǝghǝn ƙǝla niifa na a wii tala a mbǝrha ɗǝ inggun. Aah mafayighǝn nǝn ɓa fǝrang ƙǝnaghǝnǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Fǝrang wuɗǝɓǝl wurirha nǝn yi tal yawarha tuf, yi sǝri fǝrang wuɗǝɓǝl wurirha nǝn yawarha sǝri, mafarha yi mahan fǝranggǝn yawarha tal, kowunni mǝmǝl tǝ ˈya nǝn a mbang nda. Tǝrgha wii fayighǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yi mafarha thlǝgha wuɗǝɓǝla yawarha tuf, ǝna shafili nǝn sǝ wal chikrha nǝn yawarha tuf. ");
INSERT INTO hwo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yi thlǝgha yawarha sǝri ndǝghǝnggi ƙǝm ǝna shafili nǝn sǝ wal chikrha nǝn yawarha sǝri. ");
INSERT INTO hwo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma yi thlǝgha yawarha tal wiigha ɗǝgha ra kwaarha ɓǝɓenggǝn wuɗǝɓǝlɗi ki turighǝn sahai. ");
INSERT INTO hwo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mǝnnǝn ha wudgha turi mafayina ɓa aah kanda nǝn ɓa a fǝrang kirassa ˈya nda ǝnana nda tǝ wuɗǝɓǝlghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yi mafarha fǝrang nǝn wuɗǝɓǝl wurirha yawarha tuf ɓagha ɓa ndǝghǝn, “Turina, fǝrenna wuɗǝɓǝl wurirha yawarha tuf ka a ǝna shafili ni sǝ, walɗi chikrha yawarha tuf atenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Falghǝna turighǝn, ndǝghǝn, “Usakko ka mafanna. Ənanna ƙǝkafekkirha ahu ˈya ngguchit. Niya ɗǝforha aten ǝngya hangga. Ɓoɓa ɓa ǝna wutsǝfayirha tǝ nggi.” ");
INSERT INTO hwo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mafadɗi thlǝgha wuɗǝɓǝl wurirha yawarha sǝri ɓagha ɓa ndǝghǝn, “Turina, fǝrenna wuɗǝɓǝl wurirha yawarha sǝri, ǝnaɗi shafili sǝ, walɗi chikrha yawarha sǝri atenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ndangga turiɗi, “Usakko ka mafanna na tǝ ƙǝkafek fa. Ənana ƙǝkafekkirha ahu ˈya ngguchit, niya ɗǝforha aten ǝngya hangga. Ɓoɓa ɓa ǝna wutsǝfayirha tǝ nggi.” ");
INSERT INTO hwo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tǝrgha yi mafarha thlǝgha wuɗǝɓǝl wurirha yawarha tal ɓagha ɓa, ndǝghǝn, “Turina, sǝnɗi sa na ngyangthlang, na hathla a mbǝrha hǝfwa nana tǝ ƙǝm na wumang ǝnnarhami hai huɗawana na. Sa ƙǝm na midwa sǝ ǝn ka kaan. ");
INSERT INTO hwo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nanǝn kee tǝrǝmɗi raɗi kwarha ɓǝɓeng ɗi wuɗǝɓǝl wa sǝ. Kulo ndǝghǝn ya thlu ǝnwa.” ");
INSERT INTO hwo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amma ndangga turighǝn, “Sa tǝmbǝlfed mafarha na tǝ sǝbrha yid! Ashe kyanna sǝnda sǝ ni hathla a mbǝrha hǝfwa ni tǝ ƙǝm ni wumang ǝnnarhami hai a mbǝrha huɗawani, ");
INSERT INTO hwo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mani ɗǝfewana wuɗǝɓǝl na hu mbanki? A wuɗɗi ɓa kam niya thlǝghǝn har tǝ chikrha atenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tǝrgha ndǝghǝn, “Thlaama wuɗǝɓǝlɗi na a harghǝn, fǝrang nggǝnun yanɗi natǝ wuɗǝɓǝl wurirha yawarha kum. ");
INSERT INTO hwo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ƙǝsǝr kala yanɗi natǝ ˈyaha na nda chighanggǝn, tǝnǝn waala ha kaan. Amma kala niifa mbuwa tǝghǝn ha, ko yanɗi na ngguchit nanǝn tǝghǝn ha na nda a thlang hai a haarghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nanǝnya muwaman ka wuɗi mafadɗiya a ƙǝsha ɗǝ, ahu wula ɗǝ, a mbǝɗani na nanda a tǝrha sǝ tǝ ƙǝt mee.” ");
INSERT INTO hwo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A fara ɓana Wan Niifa ɓa ahu mamnggitghǝn, tǝ fathlǝngya Faara a thlǝmadghǝn, nǝn a tsaurha ahu tsǝnggam mamnggitghǝn a talara. ");
INSERT INTO hwo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nafiya ƙǝshiirha na nda a wumnda a mbedghǝn ɓa, nǝn wurang nda fiya ɗǝ ƙǝla na tǝlafrha wurang nda chauraya ɗǝ ahur ˈwalya. ");
INSERT INTO hwo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nǝn a sang chauraya a yisǝmadghǝn ˈwalya ƙǝm a yikawadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tǝrgha na kutǝra a ndang nda fingya na a yisǝmadghǝn, “Ɓama ɓa, kun fǝrangna Pǝpa parka, harama langaad kutǝryidɗi ɗǝfang nanda ka kun ka ǝnana nda ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ƙǝsǝr ƙǝs miirha nggi fǝree ɗun ǝnnarhami. Ƙǝs hushimnda nggi fǝree aam saarha nun. Tsauɗi ronga, thlǝ nggi nun fa ahu wurayinun. ");
INSERT INTO hwo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Niyi tawalth hai fǝree ǝn ƙǝnda nun. Fanna ɓee, pu nggi nun. Muwenda ahu porsǝna ɗǝ, ɗun ka ndee ˈyaɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tǝrgha ka nafiya na nda a nggǝrang sǝ, ‘Chinǝm, akwanni nanan sa a miirha fǝro ǝnnarhami nan? Nduwa ƙǝs hushimnda sa furo aam saarha nan? ");
INSERT INTO hwo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nduwa ronga ni sa thlǝ sa nan fa? Nduwa sa tawalth furo ǝn kaala nan? ");
INSERT INTO hwo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Akwan nanan sa fadwa ɓee nduwa ahu porsǝna ɗan ndoˈya?’ ");
INSERT INTO hwo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na kutǝrɗi a nggǝrang kanda sǝ, ‘Niya pǝrang ƙǝkafek kun, a ǝnang ɗun tal na ngguchit kaan ahur wanman nggini kyana ya, ǝna nun ndǝn a nggi.’ ");
INSERT INTO hwo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tǝrgha na kutǝrɗi a kyaharra thlǝmad nafina ɗǝ na a yikawadghǝn ndanggǝn kanda, ‘Weema ma thlǝmadna, kun shiwangna Faara, ɗun hu waarha ɗǝ mbuwa mǝra hai tangsang nanda hai ka sheetan tǝ fathlǝnggighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ƙǝsǝr nggi hu miirha, fǝreewun ǝnnarhami wa. Ƙǝs hushimnda nggi fǝreewun aam saarha wa. ");
INSERT INTO hwo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsauɗi ronggirha thlǝwun nggi fa ahu wurayinun wa. Nggi tawalth hai, fǝreewun ǝn kaala fa wa. Fanna ɓee tǝ ƙǝm nggi ahu porsǝna ɗuwun ka ndee ˈyaɗǝ wa.’ ");
INSERT INTO hwo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kanda ƙǝm na nda a nggǝrang sǝ ndaa nda, ‘Chinǝm, akwan ni nanan sa a miirha nduwa a hushimnda nduwa ronga ni sa nduwa tawalth nduwa fadwa ɓee nduwa ahu porsǝna, ɗowan sǝ wa?’ ");
INSERT INTO hwo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nǝn a nggǝrang nda kanda sǝ, ‘Niya pǝrang ƙǝkafek kun, a karɗun ɗang nda wanmanggina sǝ na nggu-ngguchit ya, kar nun ɗeerha sǝ.’ ");
INSERT INTO hwo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tǝrgha na nda a ɗǝrha hu sǝsaarha ɗǝ mbuwa tam ngwalaarha, amma ka nafiya na nda a ɗǝrha hu yibrha ɗǝ mbuwa tam ngwalaarha.” ");
INSERT INTO hwo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ngwalang na Yeeso thlǝk ǝnggini heu, ndanggǝn fatsahayighǝn, ");
INSERT INTO hwo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ƙǝla sǝnnunsǝ, takhƙǝn ɓeena sǝri na a ǝna wutsǝfayid tǝɗaarha nda, na nda a fǝr Wan Niifa ka a tawang ngganda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tǝrgha mamnda firistaya tǝ shingya na nda a wumnda hai a kwakirǝm Firis na manggǝn, na thlǝmnggǝn Kayafa. ");
INSERT INTO hwo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ƙǝnang ngganda hai na nda a ƙǝsang Yeeso ɓǝɓee ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ndaa nda, “Amma mbǝ a sayid wutsǝfayidɗi wa. Naɗǝ fiya ǝna kakyathlaanga.” ");
INSERT INTO hwo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nana Yeeso a Mbetani, a minda kii Siman ˈwana termeerha ƙǝsa. ");
INSERT INTO hwo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nanǝn a hǝb ǝnnarhami, ɓagha nuneefa ɓa tǝ ƙǝthlikrha urdi na sǝdghǝn mbǝnggǝn na tǝ wuɗǝɓǝla fa kaan iranggǝnǝn Yeeso a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amma nana fatsahayina ndǝn sǝbgha hur ndan ɗǝ ndaa nda, “Yanɗiya sǝbrha ni ɗǝ kee.” ");
INSERT INTO hwo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“A ndam kwang heng nda fǝɗedɗa ɗǝ na nda a wal wuɗǝɓǝla sǝ kaan fǝrang wuɗǝɓǝlghǝn nda fa yamiya.” ");
INSERT INTO hwo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amma sǝnang na Yeeso ǝnɗa hai na nda a thlǝkrha ndanggǝn kanda, “Kama nun a ɓilla nuɗiya? Ai ǝnaɗǝ ˈya na ngga a nggi. ");
INSERT INTO hwo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ƙǝtsar na fa yamiya narha tǝ kun, amma mbi naarha ƙǝtsar tǝ kun wa. ");
INSERT INTO hwo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iree nǝn urdi ɗa fa ya, ngwe nǝn fa ka yi panna. ");
INSERT INTO hwo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Niya pǝrang ƙǝkafek kun, Kala mbǝrha pǝrna nda laɓar Faara sǝ ahu ƙǝshidɗiya, ǝnɗi ǝnana nuɗiya mbǝ tam mbǝtta wa na nda naarha ɗalghǝn teena.” ");
INSERT INTO hwo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tǝrgha Yahuda Iskaryoti tal ahur fatsahaya Yeeso kumkap sǝri ɗǝgha thlǝma mamnda firistaya ɗǝ ");
INSERT INTO hwo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tsakhmee nǝn, “Ma nun a fǝreerha a fǝrangɗi Yeeso kun?” Nanǝn kee fǝrang wuɗǝɓǝl wurirha nda kumnggit mahan. ");
INSERT INTO hwo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ka a farɗi nagha Yahuda a kaɗa kwamana na a fǝrang Yeeso nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A katǝra far wutsǝfayidɗi yi mburodi kula mekhna, ɓagha fatsahaya Yeeso thlǝmadghǝn ɓa tsahang mee nda, “A yanggi na midwa ɗan nggorha fa ɗǝna hǝb ǝnnadmid tǝɗaarha sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ndanggǝn kanda, “A kyaɗun hu wupǝri ɗa hai, na niifa sǝ nun a naarha. Ndaman, ‘Ndagha mala, nduwus sayid na ɓa, ni a hǝb ǝnnadmid Wutsǝfayid Tǝɗaarha tǝ fatsahayina a minda kyawa.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nanǝn kee ǝnagha fatsahayini ƙǝla ndangna Yeeso kanda ngwa nda fa tǝ ǝnnadmid Wutsǝfayid Tǝɗaarha a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tsǝna figrha hai tsauka Yeeso hai hǝb ǝnnarhami nǝn tǝ fatsahayighǝn kumkap sǝri. ");
INSERT INTO hwo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na nanda a hǝb ǝnnarhami ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, tal ahur nun nǝn a fǝr nggi.” ");
INSERT INTO hwo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sǝbgha hur ndan ɗǝ nagha kowunni a ndang nda, “Nggini wa, Chinǝm?” ");
INSERT INTO hwo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nggǝrangga Yeeso kanda sǝ, “Tal ahur nun hǝbgha ǝnnarhami tǝ nggi hu tasau tal nǝn a fǝr nggi. ");
INSERT INTO hwo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ƙǝsǝr tǝtani a mǝrgha Wan Niifa, ƙǝla thlǝkna Ɗeleewar Faara ƙǝtǝm. Amma ǝn kawa ni a niifɗi fǝrgha ndǝn. Nǝn a tsaurha a fad niifɗi a nggushi nggǝt waana ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tǝrgha Yahuda yanɗi na a fǝr Yeeso, ndǝghǝn nggi ƙǝm Tsakhmee nǝn, “Mala, nduwa nggini wa?” Nggǝrangga Yeeso sǝ, “Sa ma thlǝk nan.” ");
INSERT INTO hwo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na nanda a hǝb ǝnnarhami, tǝrangga Yeeso mburodi sǝ usa Faara nǝn kyanggǝn hai fǝranggǝnǝn fatsahayighǝn ɗǝ ndanggǝn kanda, “Thlaama kyaman, thlu fanna ni ya.” ");
INSERT INTO hwo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tǝranggǝn wuhuleurha sǝ na tǝ aam inabi usa Faara nǝn atenggǝn. Fǝranggǝnǝn kanda ɗǝ ndǝghǝn, “Saama kun heu. ");
INSERT INTO hwo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ƙǝsǝr farna ni ya yi lǝghǝtta ɗǝfmee, irang nanda ɗǝ ka fiya hangga yi chakh ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niya ndang nda kun, mbiya nggǝr sa aam inabiɗi ya wa, ƙǝl a farɗi niya sa weerǝn ndǝghǝn tǝ kun ahu Kutǝryid Pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tǝrgha Yeeso tǝ fatsahayighǝn aah amshe nda, kya nda sǝ ɗǝnda wumnda ɗǝfya Dzaitun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tǝrgha ndangga Yeeso kanda, “A fǝɗik weeriya kun heu nun a ɗaarha ma nggi. Ƙǝsǝr nǝghǝn chichirethlee hai ahu ɗeleewar Faara, ‘Niya ɗǝk tǝlafǝdɗi, na chiɓǝd chaukhrayini a weela hai.’” ");
INSERT INTO hwo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Amma a thliiɗi sǝ ahu mǝrra, niya ˈwaarha ma kun a Nggalili ɗǝ, a mbǝɗani ɗǝnǝm ƙǝmarha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tǝrgha Ndangga Mbiturus, “Ko ɗad fiya heu ma sa, nggi kam mbi ɗaarha ma sa wa.” ");
INSERT INTO hwo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nggǝrangga Yeeso sǝ, “Niya pǝro ƙǝkafek, Mbiturus, a fǝɗik ɗiya, kapa na kilngaara tǝtaarha, na a ngaal sǝndǝna katǝra mahan.” ");
INSERT INTO hwo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Amma ndagha Mbiturus, “Ko nǝm a mǝra kyab, mbi tam ngaal sǝnduwa wa!” Fingya fatsahaya ƙǝm ndaa nda kee. ");
INSERT INTO hwo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tǝrgha ɗǝgha Yeeso tǝ fatsahayighǝn a mbǝrha ɗǝ na nda aarha Nggetsǝmani, ndanggǝn kanda, “Tsawama a mbǝɗiya, ɗǝni mbǝɗaɗǝ taarha ɗi hwan Faara.” ");
INSERT INTO hwo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tahanggǝn Mbiturus haaɗǝ tǝ wangya Dzabaɗi sǝri Yakubu tǝ Yahaya, nagha tǝ sǝbrha hura tǝ ɓillaarha. ");
INSERT INTO hwo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tǝrgha ndanggǝn kanda, “Niyi tǝ sǝbrha hura kaan ƙǝla ni mǝra. Tsawama a mbǝɗiya a shiiɗun wa nam a ƙǝlaarha tǝ nggi.” ");
INSERT INTO hwo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nduwusgha mbeeɗǝ kwanggǝn tenggǝn hweeɗe hai, hwan Faara nǝn, “Pǝpa, a naɗǝ a ǝnaarha hai, tǝrang wuhuleu sǝsadɗiya ma nggi. Ko nanǝn kee, mbǝ nggǝmnda hurna ni wa, amma nggǝmnda hur wa.” ");
INSERT INTO hwo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tǝrgha wudgha thlǝmad fatsahayighǝn ɗǝ ɗǝgha wal kanda a shiirha. Ndanggǝn Mbiturus, “Mbun mbang naarha a ƙǝlaarha ko tsun tsǝɓaku wa? ");
INSERT INTO hwo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tsawama a ƙǝlaarha non a hwan Faara, amawa nun kyaarha hu ƙǝƙǝrra hai. Na mid sǝsǝna sǝ, amma tsǝ thlu farha shishiu!” ");
INSERT INTO hwo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wiigha Yeeso ma kanda yi sǝri hwan Faara nǝn, “Pǝpa, a mbǝ a ǝnaarha hai tǝrgha wuhuleu ɗaɗǝ ya wa ƙǝl a saaɗi ndǝn, ngwa tsauka nggǝmnda hurwa kee. ");
INSERT INTO hwo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nggǝr nǝn wutta thlǝmad ndan ɗǝ, ɗǝgha wal kanda a shiirha, ƙǝsǝr nggalang ɓeena yid ndan.” ");
INSERT INTO hwo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nanǝn kee nggǝrghǝn wiirha ka hwan Faara ɗǝ yi mahan, nagha a thlǝkrha ƙǝla ˈwanǝn thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tǝrgha wudgha thlǝmad fatsahayighǝn ɓa ndanggǝn kanda, “Ɗaama mbeeɗǝ tǝ shiirha, yiɓun. Ƙǝlama hai mbiya nduwus sayi ɓa, fǝr nda Wan Niifa a haar faɗimiya hai. ");
INSERT INTO hwo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Thleema sǝ, tama wiim! Kulo niifɗi fǝrgha nggi ɓaɗa ɓa!” ");
INSERT INTO hwo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kapa na Yeeso nggǝlang miighǝn, Yahuda tal ahur fatsahaya Yeeso kumkap sǝri sǝlɗa ɓa tǝ fiya hangga a samadghǝn ƙǝs nda thlaukh ƙǝlarya ha tǝ sǝsalya. Mamnda firistaya tǝ shingya thlǝngga kanda ɓa. ");
INSERT INTO hwo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tǝ thlǝrɓu ɗi, Yahuda, saghang ɗǝ kwamana kanda tǝ ndaarha, “Yanɗi fǝɓang ni niifɗa ni ƙǝsaaman.” ");
INSERT INTO hwo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɗǝgha Yahuda thlǝmad Yeeso ɗǝ ndanggǝn, “Niyi a ndoˈya Mala!” Tǝrgha fǝɓangga Yahuda. ");
INSERT INTO hwo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nggǝrangga Yeeso sǝ, “Pashinna, ɗu mbeeɗǝ tǝ ˈya ɓoogha ɓa.” Tǝrgha nafini ƙǝsang ngganda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amma tal ahur fiya na a thlǝmad Yeeso ƙǝɗanggǝn thlaukh ƙǝlara sǝ kyathlanggǝn thlǝmad mafad firis ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ndangga Yeeso niifɗi, “Wuɗang thlaukh ƙǝlar wa ahu ƙǝnggǝn hai, ƙǝsǝr kala niifa tǝrgha thlaukh ƙǝlara, thlaukh ƙǝlara ni a ɓǝlang nda. ");
INSERT INTO hwo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sǝnggun sǝ ni mbang hwan pǝpa, puwanggǝn fathlǝngya Faara ɓa kalgha kiwad sodjaya kumkap sǝri wa? ");
INSERT INTO hwo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma a ǝnaɗi kee, ƙǝƙǝn na laɓar Faara lǝghǝtta ndanǝn nǝn a katǝrarha hai ƙǝla nanǝnya?” ");
INSERT INTO hwo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tǝrgha ndangga Yeeso fiya wumngga hai, “Tǝrwun nggi niifa ni na tǝmbǝng, nun ɓaarha ɓa tǝ thlaukh ƙǝlarya tǝ sǝsalya ka a ƙǝseewun wa? Ƙǝtsar nggi a thlǝmad nun, nggi a tsaharhaha ahu Ƙǝn Faara na a Urshalima ƙǝseewun wa. ");
INSERT INTO hwo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma katǝraghǝn hai heu kee ka a lǝghǝdgha ˈya ndaana annabiya na chichirethlee hai ahu ɗeleewar Faara.” Tǝrgha fatsahayighǝn ɗaa nda mal Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tǝrgha nafini ƙǝsangga Yeeso ɗǝnda tǝghǝn a minda ƙi Kayafa ɗǝ mamnda firistaya, a mbǝɗani wumna famalǝmngya ngyakhrha sahai tǝ shingya. ");
INSERT INTO hwo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amma Mbiturus mbuɗǝ samadghǝn ɗǝ inggun ta pǝpal minda mamnda firis ɗǝ. Kyagha sahai tsauka hai a thlǝmad fa ƙǝlaya ha nagha a ƙǝla ˈyaha na a katǝrarha hai. ");
INSERT INTO hwo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mamnda firistayini tǝ kogna yini wumngga hai na nda a kaɗa kwamana na a ƙǝsangganda Yeeso tǝ ˈya na ɗimi, tǝna nda ɓǝlang nda. ");
INSERT INTO hwo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amma walwa nda wa ko nanǝn fingya sǝ hangga nggǝmngga fa na nda a thlǝghang nggaɓaarha fa ǝnawa nda taara tǝ palth ndan wa. Akwasamadghǝn kyagha nafiya ɓa sǝri ");
INSERT INTO hwo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ndaa nda, “Ndagha kamshiɗiya, ‘Ni mbang chang Ƙǝn Faara hai na a Urshalima nggǝr yi tǝnang ahu ɓeena mahan.’ ” ");
INSERT INTO hwo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tǝrgha thliigha mamnda firis sǝ ndanggǝn Yeeso, “Mba mbang nggǝra sǝ wa? Ma na ndaarha aten pathɗi thlǝkna nafini aten wa ya?” ");
INSERT INTO hwo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amma nggasgha Yeeso tip. Tǝrgha ndangga mamnda firis, “Na minna sǝ ahu thlǝm Faara natǝ yibrha, pǝranggǝn kan ana sa ni Ƙǝrǝsti, Wan Faara,” ");
INSERT INTO hwo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nggǝrangga Yeeso sǝ, “Pǝr nan. Amma niya ndang nda kun heu a mbee nun a na Wan niifa tsau a yisǝmad Faara Amshi tǝ ƙǝm ɓayi ahu hashmbe a talara hai.” ");
INSERT INTO hwo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tǝrgha mamnda firis ɗi djaranggǝn luwudghǝn ɗǝ, ndǝghǝn, “Sarɗǝ Faara! Palthma nǝm nggǝr kaɗaarha faɗǝn? Sǝkɗǝm ndǝn hai a miighǝn laɓar sar Faara. ");
INSERT INTO hwo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ma ndaa nun?” Kanda heu ndaa nda, “Kamɗǝ a mǝrgha!” ");
INSERT INTO hwo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tǝrgha chahang yakhrha nda fa ɗǝkƙǝn nda. Fingya ƙǝm mbighǝnda, ");
INSERT INTO hwo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na nda a ndaarha, “Kulang kansǝ, Ƙǝrǝsti! Wun mbiigha sa?” ");
INSERT INTO hwo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nanǝnya Mbiturus tsau a ƙǝshi a pǝpal minda, kyagha mafad wee nuwun ɓa ndanggǝn, “Sa na tal ahur nafini na a mbu samad Yeeso tǝ Nggalilad ɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amma ngaalghǝna Mbiturus a mbed ndan heu. Ndanggǝn, “Sǝngwi ǝnɗi na a thlǝkrha ya wa,” ");
INSERT INTO hwo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsǝɓaku kyagha kwakirma sǝ nggǝrgha mafad wee nuwun naghǝn ndanggǝn fiya na a mbǝɗi, “Niifɗiya kanda ni tǝ Yeeso tǝ Nadzarat.” ");
INSERT INTO hwo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nggǝrgha Mbiturus ngaalghǝn, har tǝ aah thlǝm Faara ndǝghǝn, “Sǝngwi niifɗi nun a thlǝkrha ya wa.” ");
INSERT INTO hwo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nggǝrna nda tsǝrha tsǝɓaku nafini na ƙǝƙǝt a mbǝɗi ɗǝnda thlǝmad Mbiturus ɗǝ ndang ngganda, “Sa mbǝ ngaala sǝ wa na tal ahur ndan, ƙǝsǝr ahu laɓar wa kyadɗǝ ndaarha tǝ Nggalilarha ni sa.” ");
INSERT INTO hwo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tǝrgha nagha Mbiturus a ang shiurha fadghǝn fa ɓa aah nǝn thlǝm Faara a Kanda ndaanǝn, “Sǝngwi niifɗi wa!” Tsu kee tǝtaagha ɗiyarha. ");
INSERT INTO hwo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tǝrgha ɗalgha Mbiturus teena hai tǝ laɓar Yeeso ndang nǝn, “Kapa na ɗiyarha tǝtaarha yi sǝri na ngaal sǝndǝna katǝra mahan.” Kyagha ƙǝshaaɗǝ tǝgha kaan. ");
INSERT INTO hwo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A tsar ƙǝrǝt, mamnda firistaya tǝ shingya heu, wuma nda hai ka a kaɗa kwaman ɓǝlla Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kǝnang ngganda, ɗǝnda tǝghǝn a mbed Mbilatus ɗǝ, ngwamnad Romaya. ");
INSERT INTO hwo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kǝlaana Yahuda hai fǝrgha Yeeso, ngwang nda kumad mǝrra Yeeso sǝ. Tǝrgha sǝbgha hurghǝn ɗǝ, haranggǝn wuɗǝɓǝl wuridɗa sǝ kumggit mahan wuɗanggǝnǝn mamnda firistaya ɗǝ tǝ shinggini. ");
INSERT INTO hwo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ndanggǝn kanda, “Ənaɗi ɗimiyirha, ƙǝsǝr fǝrɗi niifa ǝnawa ɗimiyirha.” Ndang ngganda, “Mbǝ ˈya sǝ djiɗangwa kan wa, kǝl ˈya ǝnana.” ");
INSERT INTO hwo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tǝrgha Yahuda tsamanggǝn wuɗǝɓǝlɗa hai ahu Ƙǝn Faara, wiigha ɗǝgha waghang altenggǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Harangga mamnda firistaya wuɗǝɓǝlɗa sǝ, ndaa nda, “Kamngwa a ɗǝfanggǝm wuɗǝɓǝlɗi ya a mbǝd ɗǝfǝd yi Ƙǝn hwan Faara wa, nanǝn wuɗǝbǝl ƙǝna ɓǝl farha ni.” ");
INSERT INTO hwo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A kwasamadghǝn ƙǝnang ngganda hai na nda a hii pǝpal yi taɓǝd tǝn ɓǝya sǝ tǝ wuɗǝɓǝlɗi, tsawang ngganda mbǝɗi, mbǝd ten kwad rongya. ");
INSERT INTO hwo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndǝn na nda aah mbǝɗi, Pǝpal fara. ");
INSERT INTO hwo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tǝrgha lǝghǝdgha ˈya ndana annabi Irmiya ndanǝn, “Tǝrang ngganda wuɗǝɓǝl wuridɗa sǝ kumggit mahan, wuɗǝɓǝlɗi kyana nafiya Isǝreela. ");
INSERT INTO hwo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hii mbǝd taɓǝd tǝn ɓǝya nda sǝ kǝla ndaana Chinǝm”. ");
INSERT INTO hwo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nana Yeeso ƙǝt a mbed Mbilatus ngwamnad Romaya, tsahangga ngwamnaɗi mee, “Sani kutǝr Yahudaya wa?” Nggǝrangga Yeeso sǝ, “Ooh, ƙǝla ndaana.” ");
INSERT INTO hwo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma nana mamngya firistaya tǝ shingya a ˈyarghǝn, nagha Yeeso tip fayighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ndangga Mbilatus, “Mbuwana a sǝk ǝnɗi na nda a thlǝkrha atenwa wa?” ");
INSERT INTO hwo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amma nggǝrang ngwa Yeeso kanda sǝ aten ǝnggini heu thlǝk nanda wa, ƙǝsgha ǝnwulteena ngwamnaɗi kaan. ");
INSERT INTO hwo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nanǝnya ǝntin ngwamna ɗa ni nǝn yakh kalang niifa kanda hai tal na ahu porsǝna na min ndan a far wutsǝfayid Tǝɗaarha. ");
INSERT INTO hwo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ahu sayidɗi na niifa sǝ na tǝmbǝng, ƙǝnang na nda ahu porsǝna, na nda aarha Mbarabas. ");
INSERT INTO hwo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsaunǝn wum fiya hai a kwakirǝm Mbilatus, tsahangga Mbilatus mee kanda, “Wun na minnun a kalang nggǝni kun hai, Mbarabas wa, nduwa Yeeso nanda aarha Ƙǝrǝsti wa?” ");
INSERT INTO hwo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sǝn ɗa sǝ ƙǝsang na shingya Yeeso ƙǝsǝr ka sǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nana Mbilatus tsau a mbǝd tsawud ngwa kumarha, thlǝngga nukƙun farha a thlǝmadghǝn ɗǝ a ndang ngganda, “Ma ǝnangna ˈya ka niifɗa fa ya wa ƙǝsǝr sǝsaaɗi kaan hu sǝsǝniirha atenggǝn a fǝɗik weeriya.” ");
INSERT INTO hwo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amma mamngya firistaya tǝ shingya shik fiya nda, a ndang ngganda a kal Mbarabas nǝn hai, ɓǝlang ngganda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nggǝrgha kutǝr ɗi tsakh mee, “Wun na minnun a kalang nggǝni kun hai ahur nafiyini na kyab ya?” Tǝrangga fiya urad ndan sǝ, “Mbarabas!” ");
INSERT INTO hwo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ndangga Mbilatus kanda, “Mani ǝnaarha tǝ Yeeso na nda aarha Ƙǝrǝsti?” Tǝrang ngganda urad ndan sǝ, “Tawaman ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ndangga Mbilatus kanda, “Kama nda? Ma ǝnanǝn na ɗimi?” Amma nagha fiya a tǝrang urad ndan sǝ, “Tawaman ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","“Ƙǝlaana Mbilatus hai mbǝ ˈyasǝ nǝn mbang ǝnaarha wa, na nda a katǝrang kakyathlaanga. Tǝrgha thlǝn farha nǝn a ɓang aama nda ɓa tsaɓanggǝn harghǝn ɗǝ a mbed fiya, ndagha, Nggi, mbǝ harna tsuwar faar ka niifa fa wa. Kun ndǝn sǝngga ǝnnun.” ");
INSERT INTO hwo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nggǝmangga fiya heu, “Ngwa tsauka hakked farghǝn aten nan, kan tǝ wagginan!” ");
INSERT INTO hwo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tǝrgha Mbilatus kalang Mbarabas nǝn kanda hai. Fǝr Yeeso nǝn tsaɗa ghǝnda tǝ wutǝteerha, fǝranggǝnǝn sodjad Romaya ka ɗanda tawang ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Fingya sodjaya ngwamnaɗi tǝrangga nda Yeeso a mbǝd tar ndan ɗǝ, aah sodjaya nda ɓa heu. ");
INSERT INTO hwo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ƙǝɗangga nda lukkighǝn hai, kalang kaɓarha nda fa yiɓa. ");
INSERT INTO hwo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yam wuhar ndakhkya nda ƙǝla matuwel, panggǝnda atenggǝn, fǝrang sǝsal kutǝryirha nda a yisǝmadghǝn. Ɓǝra nda hai a mbedghǝn waaghǝn nda, na nda a ndangˈya, “Alvari, kutǝr Yahudaya!” ");
INSERT INTO hwo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chahang yakhrha nda fa, thlǝ sǝsal ɗa nda na nda a ɗǝkƙǝn sǝ a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ɗakhna mindan ɗǝ tǝ waaghǝn, ƙǝɗang ngganda kaɓadɗa hai a fadghǝn, nggǝrgha nda kalang yighǝn lukrha fa. Tǝrgha wii nda tǝghǝn ka ɗa nda tawang ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nana nda aten wiirha, ɗa nda wal tǝ Sayirarha, thlǝmnggǝn ni Siman, ngyaɓang tǝr kaɗidɗa nda fa. ");
INSERT INTO hwo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sǝlna nda a mbǝrha ɓa nanda aarha Nggolggota, ndaarha ni mbǝd ɓalhwar teena, ");
INSERT INTO hwo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fǝrangga sodja yini aam inabi nda kukurɗa tǝ ˈya na iˈikh, amma taarang nǝn, kar sad ghǝnǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A kwasamadɗi tawang na nda ɗǝ, ndǝghang ngganda lukkighǝn hai tǝ ǝna chacha. ");
INSERT INTO hwo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tǝrgha tsawa nda hai a mbǝɗi, nanda a ƙǝlaghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chireelth ǝn sak ɗimiyidghǝn nda a man tenggǝn tǝ ndaarha, “KULO YEESO YA, KUTƏR YAHUDAYA!” ");
INSERT INTO hwo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na fathlee kwamangya sǝ sǝri tawang na nda kanda ɗǝ a thlǝmadghǝn, tal a man yisǝmadghǝn, tal a yikawa. ");
INSERT INTO hwo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nagha fiya na a mbǝra ɗǝ a huhwang nda, na nda a tsang ˈya ten ndan fa yi waa farha. ");
INSERT INTO hwo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Na nda a ndaarha, “Ndaana na mbang chang wuri Faara hai na a Urshalima tǝnangga sǝ hu paara mahan, ana Wan Faara ni sa, hǝrghang altenwa lee tǝra na hai a ten kaɗidɗiya!” ");
INSERT INTO hwo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mamngya firistaya tǝ famalǝmgya ngyakhrha Musa, tǝ shingya ƙǝm waa Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hǝrghang ɗǝ fingya, amma mbangwa hǝrghang nda altenggǝn wa. Ana ndǝghǝn ni kutǝr Isǝreela! Tǝrgha hai a ten kaɗidɗi nanǝnya lee, nǝm a fǝrƙǝkafek a ndǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Fǝrɗǝ ƙǝkafek a Faara, ngwa hǝrghangga Faara nanǝnya anaɗǝ na midghǝn sǝ! Ƙǝsǝr ndǝghǝn, Wan Faara ni nggi.” ");
INSERT INTO hwo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ko fa thlee kwaman nggina ni tawang na nda kanda ɗǝ tǝghǝn, waa ghǝnda kǝla ǝnana fiya. ");
INSERT INTO hwo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yanfara a sǝrǝkrha, nggǝlangga wula chehwedɗi heu har yargha yanfaara hai. ");
INSERT INTO hwo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yarna yanfaara hai kalgha Yeeso sǝ tǝ urarha manggǝn, “Eloi, Eloi, lama sabaktani?” Ndaarha ni, “Faarna, Faarna, kama karna nggi?” ");
INSERT INTO hwo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Fingya na ƙǝƙǝt a mbǝɗi sǝngwa nda sǝwa tamngga nda ndaarha nanǝn a aah annabi Ilya. ");
INSERT INTO hwo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɗagha niifa ɗǝ tal ahur ndan tǝtǝnanggǝn soso tǝ aam inabi na chichakh, panggǝn hu sǝsaala hai fǝranggǝnǝn sǝ ka a saagha. ");
INSERT INTO hwo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amma ndagha fingya, malaman, ƙǝlaghǝnǝm ha, asǝmha ɓana Ilya hǝrghang nda. ");
INSERT INTO hwo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tǝrgha nggǝrgha Yeeso tǝrang uradghǝn sǝ kaan tǝgha, mbǝ kal yiɓǝdghǝnǝn hai. ");
INSERT INTO hwo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A mǝmǝlla sayidɗi djargha shishamar Ƙǝn Faara hai sǝri, a talara hai ta hweeɗe hai. Rǝbgha ƙǝshiirha fa, fǝlgha ferya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ingga ten kwaya ɗǝ, ka nafiya Faara hangga mǝrgha, thlii nda sǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kyanda sǝ ahu ten kwaya, a kwasamadɗi thliina Yeeso sǝ ahu mǝrra, ɗǝnda ahu wupǝri ɗǝ tǝ peɗǝnda, kyad fandan nda a fiya hangga. ");
INSERT INTO hwo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mamnda sodja Romaya tǝ fingya sodjaya na a ƙǝla Yeeso ha, nana nda rǝbrha chehwedɗi tǝ ǝngya heu katǝrarha hai tǝrma nda, ndaa nda, “Ƙǝkafek niifɗiya Wan Faara ni!” ");
INSERT INTO hwo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tǝ nishya hangga ɓagha ɓa mbuwa samad Yeeso a Nggalili ɓa ka a ndang ngganda sǝ tǝ ˈya na midghǝn na nda a ƙǝlarha ɓa inggun. ");
INSERT INTO hwo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ahur ndan na Mairamu Magdaliya sǝ, tǝ Mairamu man nda Yakubu tǝ Yisǝfu, tǝ man nda Yakubu tǝ Yahaya, wangya Dzabadi. ");
INSERT INTO hwo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tsǝna figrha hai, na tǝ ƙǝna sǝ ɓagha ɓa a Aramatiya, thlǝmnggǝn ni Yisǝfu, tsauka tǝ takkwa Yeeso, ");
INSERT INTO hwo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ɗǝgha thlǝmad Mbilatus ɗǝ tsakh mǝrra Yeeso nǝn, ndagha Mbilatus fǝraman ndǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tǝrangga Yisǝfu mǝrɗi faɗanggǝn hu kaɓaarha hai na ngga pǝpet. ");
INSERT INTO hwo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ɗǝgha pang ahu yighǝn weerǝnda ten kwarha hai ranǝn ahu feera. Tǝrgha kwatǝranggǝn feera ɓa na manggǝn, nggǝlanggǝn mii tenkwadɗa sǝ wiigha. ");
INSERT INTO hwo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nda Mairamu Magdaliya tǝ tahad Mairamu ɗi kanda tsǝtsau a mii ten kwadɗi kanda a naghǝn. ");
INSERT INTO hwo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɗathna mbǝrha hai a far yiɓǝd Yahudaya, Mamnda firistaya tǝ farisaya ɗǝnda thlǝmad Mbilatus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ndang ngganda, “Alvari, ɗal ɗan teena hai aten ˈya ndaana tǝnggaɓad ɗi ndǝghǝn ɓalɗǝ tǝ yibrha, ‘A kwasamad ɓeena mahan nǝn a thliirha sǝ ahu mǝrra.’ ");
INSERT INTO hwo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nanǝn kee furu kwamana a ƙǝla ten kwadɗa ndaha yi ɓeena mahan. A mbǝ kee wa ɓana fatsahayighǝn ngaarang, ndangganda fiya thliinǝn sǝ ahu mǝrra.” ");
INSERT INTO hwo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ndangga Mbilatus kanda, “Harama sodjaya ƙǝla mbǝɗaha, ngga.” ");
INSERT INTO hwo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nanǝn kee mǝlɗeng ngganda ten kwadɗi, sǝ sodjaya nda sǝ na ƙǝlaghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A kwasamad far yiɓǝd Yahudaya, a tsar ƙǝrǝt a far ladi Mairamu magdaliya tǝ tahad Mairamu wii nda ka ƙǝlang tenkwadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kula sǝndǝndan sǝ rǝbgha hweeɗe fa kaan, ƙǝsǝr tǝthlǝnda Faara tǝrgha hai a talara, kwatǝranggǝn ferɗi a man patu ɗǝ, tsauka a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nagha pǝmnggǝn a chimnda fa ƙǝla yan fara, lukkighǝn ƙǝm pǝpet ƙǝla humba kaɓarha. ");
INSERT INTO hwo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tǝrǝmngga nafini na a ƙǝla ten kwadɗa ha, nagha fandan a rǝbrha fa, muwa nda hweeɗe hai, shiwit kanda nǝn in. ");
INSERT INTO hwo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tǝrgha kalangga tǝthlǝndǝ ɗi nishyina sǝ, ndǝghǝn, “Ma tǝrǝm ɗun wa sǝnɗisǝ nun a kaɗa Yeeso, tawang nanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mbǝ a mbǝɗiya wa, thliiɗa sǝ ahu mǝrra, ƙǝla ndaanǝn nǝn a katǝrarha hai. Ɓamaɓa, ɓun na mbǝɗi huna nǝn sahai. ");
INSERT INTO hwo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nanǝnya, weema ƙǝkar ɗun thlǝghanggǝn fatsahayighǝn tǝ ndaarha thliiɗasǝ ahu mǝrra, nǝn a mbed nun ɗǝnǝn Nggalili ɗǝ. Ɗǝnun naghǝn a mbǝɗi. Ɗalama teena hai tǝ ˈya ndang ni kun.” ");
INSERT INTO hwo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɗagha nishyini ƙǝkar ma ten kwadɗi, tǝrǝm nda kaan amma naa nda lǝlǝgɗa tǝ wutsǝfayirha fa, nagha pǝr laɓarɗi a kukwasang kanda fa pǝrang na tǝthlǝndǝɗi kanda a fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɓa Yeeso wal kanda, ndang ˈya nǝn kanda. Ɓa nda thlǝmadghǝn ɓa, fǝb saryighǝn nda fa, manangganda thlǝmnggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tǝrgha ndangga Yeeso kanda, “Ma tǝrǝm ɗun wa, ɗama ɗǝ ndanggun wanmanggina ɓanda a Nggalili ɓa, ɓana nda na nggi a mbǝɗi.” ");
INSERT INTO hwo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nana nishyini a ten kwamana, fingya fa kǝla mbǝɗaha ɗǝnda ahur wupǝri ɗǝ thlǝghang ǝnɗa nda mamnda firistaya ǝnɗi katǝragha hai heu. ");
INSERT INTO hwo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aah shingya nda wuma nda hai, ƙǝnangganda hai na nda a fǝrang wuɗǝɓǝla kanda manggǝn. ");
INSERT INTO hwo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ndang ngganda sodja yini, ‘A ndaama, fa tsahaya Yeeso ɓagha ɓa a fǝɗikrha nanan a ɓeena, ngaarang ngganda mǝrrǝghǝn.’ ");
INSERT INTO hwo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A sǝk ngwamna laɓarɗiya, kan ƙǝm nan a isha a mbed nun, amanun sǝsarha.” ");
INSERT INTO hwo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tǝrgha sodja yini ƙǝm thlǝ wuɗǝɓǝlɗa nda ǝna nda ƙǝla saghang nanda kanda. Ɗǝgha laɓar ɗaɗǝ inggun ahur Yahudaya, ɓagha ta weeri ɗaɓa ya. ");
INSERT INTO hwo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tǝrgha fatsahayini kumkap tal ɗǝnda Nggalili ɗǝ, tǝra nda wumnda sǝ ndangna Yeeso kanda. ");
INSERT INTO hwo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nana ndan manang ngganda thlǝmnggǝn, amma fingya sǝ ngalgha ndǝn. ");
INSERT INTO hwo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ɓagha Yeeso ɓa ndanggǝn fatsahayighǝn, “Fǝreenda sǝsǝmnggit talara tǝ yi hweeɗe heu. ");
INSERT INTO hwo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsaunǝn kee ɗaama ɗǝ, ɗun tsahang fiya ha heu, ǝnang mbaptisǝma nun kanda, hu thlǝm Pǝpa tǝ yi Wee, tǝ yi Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsahaman kanda ha a ǝna taara nda tǝ ǝngya heu ndang ni kun. A sǝnunsǝ niyi tǝ kun ƙǝtsar ta mii ngwala ƙǝshiirha ɗǝ.”");
INSERT INTO hwo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Katǝra ɗeleewar tǝ Peɗǝnda aten Yeeso Ƙǝrǝsti, Wan Faara. ");
INSERT INTO hwo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chirethleng nda hai hu ɗeleewar annabi Ishaya tǝ ndaarha, “Niya ˈwa thlǝn tǝ thlǝndǝna ɗǝ ma sa, na a takso kwamana ɗǝ” ");
INSERT INTO hwo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Urarha a aah farha a kaheerha. ‘Taksaman kwamana Chinǝm sǝ pǝpǝnaman kwaman sarya ɗǝ a ndǝghǝn.’” ");
INSERT INTO hwo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yahaya kyagha ɓa a kahedɗi nagha a ndang nda fiya a malangganda ɗimiyid ndan fananggǝn kanda yi chakh ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kahad fiya na a chehweed Yahuda tǝ fiya heu na a Urshalima kyanda ɓa ɗǝnda thlǝmadghǝn ɗǝ. Malang nda ɗimiyid ndan ǝnangga Yahaya mbaptisǝma kanda a kufad Urdun. ");
INSERT INTO hwo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahaya kalɗǝ lukrha ǝnana nda tǝ was thlǝkhmu, ƙǝnanggǝn muwun tǝ paama, mbeeya tǝ ɗee ndǝna ǝnnadghǝn mii. ");
INSERT INTO hwo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndanggǝn fiya, “Na niifa sǝ ɓayi a samadna na tǝ sǝsǝmnda fa kalgha nggi mu, sahad pahamggǝn tsǝkki na a kwasang nggi hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ənanggi mbaptisǝma kun tǝ aama, amma ndǝghǝnggi nǝn a ǝnang mbaptisǝma kun tǝ sǝsǝna tǝ Peɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A hu sayidɗi kee ɓagha Yeeso ɓa a Nadzarat na hu chehweed Nggalili ǝnangga Yahaya mbaptisǝma a kufad Urdun. ");
INSERT INTO hwo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nana Yeeso a kyarha sǝ hu aamɗi kee, ƙǝlagha hai talara inɗaɗǝ nagha Sǝsǝn Faara a tǝraa tenggǝn hai ƙǝla tǝtiliurha. ");
INSERT INTO hwo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sǝk urarha nda a talara hai, “Sani Waana, nggǝmni niyi a tǝk mbǝnduwa fa kaan.” ");
INSERT INTO hwo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsu kee tǝrangga Sǝsǝna tǝ Peɗǝnda a kaheerha ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","tsauka a kahedɗi yi ɓeena kumggit faɗa nagha sheetan a ƙǝƙǝrang nda. Ndǝghǝn a kahedɗi tǝ thlukkya yi heerha, nagha fathlǝngya Faara a ǝnang taara. ");
INSERT INTO hwo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A kwasamadɗi muwang nanda Yahaya ahu porsǝna ɗǝ, ɗǝgha Yeeso Nggalili ɗǝ nagha a pǝr laɓar Faara. ");
INSERT INTO hwo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nagha a ndaarha, “Ɓad sayidɗa ɓa, kutǝryid Faara nduwusɗa ɓa. Malaman ɗimiyid nun fǝrƙǝkafek nun tǝ Laɓarɗi na Mbǝnggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nduwusna Yeeso mii kufad Nggalili ɗǝ, na Siman nǝn tǝ wan man Andrawus a muk panggama a kufadɗi ƙǝsǝr kanda fa ƙǝs tǝngya ni. ");
INSERT INTO hwo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ndangga Yeeso kanda, “Ɓama ɓa, mbuwama samadna, niya tsawang kun fa ƙǝs fiya ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsu a mbǝɗi kee malangganda panggamggi ndan mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɗǝnǝn mbeeɗǝ, na Yakubu nǝn tǝ wanman Yahaya wangya Dzabaɗi ahu kwambuwol, kanda a tangsang panggamnggi ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nana Yeeso kanda aah kanda nǝn, mal chi ndan nda Dzabaɗi ahu kwambuwol ɗi tǝ fingya nafiya na a ɗang kanda sǝ mbu samadghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɗǝnda Kafarnahum ɗǝ, nduwusna far yiɓǝd Yahudaya ɓa, kyagha Yeeso Ƙǝn Faara ɗǝ katǝranggǝn tsaharhaha. ");
INSERT INTO hwo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nagha fiya ǝnwulteena a ten tsahadghǝn ha, ƙǝsǝr tsahanggǝn kanda ha ƙǝla niifa na tǝ ngyakhrha ha, mbǝ ƙǝla fa malǝmngya yi ɗeleewar Musa wa. ");
INSERT INTO hwo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tǝrgha ahu ƙǝn hwan Faarɗan na niifa sǝ na tǝ ǝnkaheerha fa huhwaagha, ");
INSERT INTO hwo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ndǝghǝn, “Mana midwa tǝ kan, Yeeso tǝ Nadzarat? Ɓana ɓa ka ɓǝlangga kan wa? Sǝnɗi sa, na chahal yi Faara!” ");
INSERT INTO hwo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yanangga Yeeso, “Nggǝlang miiwa! Kyosǝ a fadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Muwangga ǝnkaheedɗi hweeɗe hai, huhwaagha, kyagha sǝ a fadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Fiya na a mbǝɗi ka ǝnwulteena na nda a ndang nda ndan, “Tur maniya? Weerinda tsaharhaha tǝ ngyakhrha! Nǝn yanang ǝnkaheeya na nda a takkwa miighǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Laɓarghǝn welɗaɗǝ ƙǝkar ahu chehweed Nggalili. ");
INSERT INTO hwo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kyana nda hai ahu Ƙǝn Faara, nda Yakubu tǝ Yahaya ɗǝnda wuri ki Mbiturus ɗǝ tǝ Andrawus. ");
INSERT INTO hwo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Thlaɓǝr Mbiturus tǝnuwunda fadghǝn ɓee kalth hu sǝra, pǝrang nggǝnda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɗǝgha Yeeso thlǝmad nuɗaɗǝ, ƙǝs harghǝnǝn thlenggǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A figrha mukna yanfaara hai ɓagha fiya thlǝmad Yeeso ɓa tǝ nafiya na fandan ɓee tǝ fingya na tǝ ǝnkaheeya fa. ");
INSERT INTO hwo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nafiya na ahu talɗi wuma nda kwatkirǝm ɗa ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ƙǝnangga Yeeso fiya hangga na tǝ wanhaaya fa ɗǝɗamǝn-ɗǝɗamǝn. Kyanggǝn ǝnkaheeya sǝ hangga na a fad fiya, amma mbǝ malang ǝnkaheeyini kala nda sǝ wa ƙǝsǝr sǝn ndan. ");
INSERT INTO hwo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A tsar ƙǝrǝt, ka pit mbǝrha ɓa, thliigha Yeeso sǝ ɗǝgha mbǝrha ɗǝ na ɓǝɓee hwan Faara nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mbiturus tǝ ka wiyighǝn ɗǝnda ka kaɗadghǝn ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","walang nanda, ndang ngganda, “Fiya kahad a kaɗa sa!” ");
INSERT INTO hwo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nggǝmangga Yeeso kanda, “Taama mbǝrha ɗǝ pak ahu talya ɗǝ na tsau tǝni ɗǝ pǝr laɓarɗi a mbǝɗi ƙǝm. Ndǝghǝnni ɓani ɓa ka manggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wenggǝn chehweed Nggalili hai nagha a pǝr laɓar Faara ahu ƙǝn tsahad Yahudaya tǝ kyang nda ǝnkaheeya sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Niifa na tǝ wanhad termeerha fa ɓagha thlǝmadghǝn ɓa ɓǝrgha hai tǝ waɗedghǝn hwanggǝnǝn, ndanggǝn, “A nggǝmna fa, tsaɓee ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Haɗangga niifɗi Yeeso fa, tǝrangga Yeeso harghǝn sǝ tsuwarghǝnǝn fa ndanggǝn, “Nggǝmɗifa, tsaɓuɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsu a mbǝɗi kee, kyagha termedɗa sǝ a fadghǝn ƙǝngga. ");
INSERT INTO hwo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ƙǝsgha Yeeso thlǝmadghǝn, ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“A pǝrang nan niifa wa. Amma ɗuwaɗǝ, a kyaɗang fadwa firis ǝna sataka na ƙǝla ndana ngyakhrha ɗeleewar Musa a kyaɗang ndaarha nǝn kanda tsabna ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","A meghedghǝn kyagha niifɗa hai nagha a pǝrghǝn. Ndǝn ǝnagha ndǝn, ɓalwa Yeeso nggǝr kyarha hur tala hai a pǝpal amma ishgha a ƙǝsǝr wure a mbǝrha mbuwana niifa sǝ. Ko nanǝn kee na fiya naarha ɓarha thlǝmadghǝn ɓa a mbǝya ɓa hangga. ");
INSERT INTO hwo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mǝngwaha wa, nggǝrgha Yeeso kyarha Kafarnahum hai, sǝkka fiya ndaarha ɓaɗǝ wure ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wumngga fiyaɓa, lǝɗang ngganda ƙǝnɗi ta mii kwatminda ɓa, a nagha a pǝrang laɓar Faara kanda. ");
INSERT INTO hwo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɓagha nafiya ɓa faɗa tǝ niifa mǝrna fadghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Walwa nda kwamana wa ƙǝsǝr ka hangnda fiya. Thlǝɓangganda ten ƙǝnɗa ɗǝ mǝmǝl tǝ man ten Yeeso fǝrghǝn nda hai tǝ ɗǝngǝlɗi hunangganda hai a mbed Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nana Yeeso fǝrƙǝkafǝkkin ndan, ndanggǝn hadɗi na kath, “Waana chohonda ɗimiyidwa ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nanǝn ya, fasǝngya ngyakhrha tǝ Farisaya kanda a numarha tǝ ndaarha, ");
INSERT INTO hwo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kama na niifɗi ndaarha kee ya? Tǝ sar farha ni! Mbǝ niifa sǝ na chakh ɗimiyirha wa ƙǝl Faara katenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsu kee sǝngga Yeeso ǝnɗi nanda a numarha ahur ndan, ndanggǝn kanda, “Kama nun a numarha aten ǝngginiya? ");
INSERT INTO hwo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yanggini pǝpa, ndanggǝm tǝ mǝrra fadɗa hai, ‘Chohonda ɗimiyidwa ɗǝ wa,’ nduwa ndam, ‘Thliusǝ, tǝrang ɗǝnggǝl wa wiu wa?’ ");
INSERT INTO hwo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amma a sǝnunsǝ Wan niifa nǝghǝn tǝ sǝsǝmnda ha hu ƙǝshidɗiya yi chakh ɗimiya.” Ndanggǝn niifɗi mǝrna fadghǝn hai, ");
INSERT INTO hwo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndoyi, thliusǝ tǝrang ɗǝggǝl wa wiina wureɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Thliigha sǝ tǝranggǝn ɗǝnggǝlghǝn kyagha hai a yid fiya heu. Ənɗiya fǝrang ɗǝ ǝnwulteena kanda na nda a fal Faara, na nda a ndaarha, “ˈWawum na tur ǝnɗiya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nggǝrgha Yeeso ɗǝrha mii kufad Nggalili ɗǝ. Ɓagha fiya hangga thlǝmadghǝn ɓa, nagha a tsahang kanda ha. ");
INSERT INTO hwo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nanǝn a mbǝra ɗǝ, na Lawi nǝn wan Halfa tsau a thlǝ tsamnda. Ndanggǝn, “Mbuwu samadna.” Thliigha Lawi sǝ mbu samadghǝnǝn. ");
INSERT INTO hwo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nana Yeeso a hǝb ǝnnarhami a minda ki Lawi, fa thlǝ tsamngya hangga tǝ fa “ɗimiya” na nda a hǝbrha tǝghǝn tǝ fatsahayighǝn, ƙǝsǝr fiya hangga mbuwa samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nana fa sǝngya ɗeleewar Musa na Farisaya na nandan a hǝbrha tǝ fa “Ɗimiya” tǝ fa thlǝ tsamngya, tsahang mee nda fatsahayighǝn, “Kama nǝn a hǝbrha tǝ fa thlǝ tsamngya tǝ fa ‘Ɗimiya’?” ");
INSERT INTO hwo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sǝkna Yeeso kee ndanggǝn kanda, “Mbǝ nafiya na ƙǝkanglang kaɗa tǝ purha wa, Ƙǝl haaya. Ɓawi ka aah nafiya ɓa na a ǝna nggayirha wa, amma fa ɗimiya.” ");
INSERT INTO hwo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Fatsahaya Yahaya tǝ Farisaya na nda kar aama. Ɓagha fingya thlǝmadghǝn ɓa tsahang mee nda Yeeso, “Mani ǝnagha ndǝn, fatsahaya Yahaya tǝ yi Farisaya kanda a kar aama, amma finayiwa mba nda ǝnaarha wa?” ");
INSERT INTO hwo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nggǝmangga Yeeso kanda, “Pashiya wutsamnda na nda kar aama wutsamnda ɓalɗǝ a thlǝmad ndan wa? A ɓal wutsamnda a thlǝman ndan mba nda ǝnaarha wa. ");
INSERT INTO hwo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na sayi ɓayi ɓana nda tǝrang wutsamndǝɗi ma kanda. A mbǝɗaniya ɓa nanda kar aama. ");
INSERT INTO hwo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mbǝ niifa sǝ na njar ɓar kaɓarha ɓa mbuhanggǝnǝn suhurra lukrha fa wa. A ǝna ɗǝ kee, mbuhudɗi na tǝ kukwasharra ɓar kaɓadɗi nǝn njaara hai a fad luwudɗi kal yanɗa nǝn mu na kaar. ");
INSERT INTO hwo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mbǝ niifa sǝ na irang weerǝnda aam inabi ahu suhurra samsami hai wa. A ǝna ɗǝ kee, na weerǝnda aam inabi ɗi ɗathlang nda samsami ɗa ɗǝ. Nǝn iraɗǝ, sǝbgha samsami ɗa ɗǝ. Kamɗǝ weerǝnda aam inabi nǝm irangnda ahur weerǝnda samsami hai.” ");
INSERT INTO hwo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na farɗa sǝ, far Yibrha Yahudaya, Yeeso tǝ fatsahayighǝn tǝrnda kwaman heerha; tǝrgha fatsahayighǝn kya ten ǝnnarhami nda na ƙǝla wan hwaliirha fahwang ngganda hai na nda a kiighǝn. ");
INSERT INTO hwo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndagha Farisaya, “Mani na fatsahayiwa ǝna ˈya kee, ˈyaɗana ngyakhrha Musa yi far Yibrha?” ");
INSERT INTO hwo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nggǝmangga Yeeso kanda, “Karatang ngwanun ǝnɗi na hu ɗeleewar Faara ǝnana Ndauda tǝ nafighǝn na miirha a ƙǝs kanda wa? ");
INSERT INTO hwo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A thlakh mbǝd Abiyata mamnda firis, kyanǝn hu Ƙǝn Faara ɗǝ tǝrnǝn mburodi sǝ ɗǝfangna nda ɗǝ ka firis katenggǝn, kiigha ǝnangǝn pashiya wiyighǝn ha.” ");
INSERT INTO hwo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ndangga Yeeso kanda, “Əna nanda far yibrha ka niifa, mbǝ niifa ka far yibrha wa. ");
INSERT INTO hwo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nanǝn kee, Wan Niifa Chinǝm ni heu tǝ far Yibrha.” ");
INSERT INTO hwo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na farɗa sǝ fadɗǝn, kyagha Yeeso Ƙǝn Faara ɗǝ, na niifa sǝ mǝrna harghǝn hai ahur ƙǝnɗi. ");
INSERT INTO hwo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na nafiya sǝ na mindan a ƙǝsangganda Yeeso tǝ ɗimiyirha, ƙǝlaghǝn nda ha tǝnǝn a ƙǝnang nda niifɗi a far yibrha. ");
INSERT INTO hwo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ndangga Yeeso niifɗi mǝrna harghǝn hai, “Thliusǝ ɓa isha a mbed fiya.” ");
INSERT INTO hwo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tǝrgha tsahangga Yeeso mee kanda, “Yanggini mǝmǝl a ǝnam a far Yibrha? Əna nggayirha nǝm wa nduwa mbǝlfeerha wa, a hǝrghanggǝm yibrha wa nduwa ɓǝlanggǝm wa?” ");
INSERT INTO hwo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ƙǝlangga Yeeso kanda tǝ sǝbrha hura tǝ ƙǝm ǝn kawani ka kakrakkid ten ndan. Ndanggǝn niifɗi, “Pǝpǝnang harwa ɗǝ.” Pǝpǝnanggǝn harghǝn ɗǝ, a mbǝɗi kee nggǝrgha harghǝn ɓa ƙǝla kaar. ");
INSERT INTO hwo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tǝrgha Farisayini kya nda ƙǝshaaɗǝ ɗa nda ndikrha tǝ nafiya Hirdus na a kaɗa kwaman ɓǝllang nda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeeso tǝ fatsahayighǝn ɗǝnda mii kufad Nggalili ɗǝ, fiya hangga mbuwa samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Hǝrǝm nanda sǝk ǝngya ǝnanǝn heu, fiya hangga ɓagha ɓa a Yahuda, tǝ Urshalima, tǝ Idomiya, tǝ fingya na a pǝm kufad Urdun, tǝ nafiya Taya tǝ Sidon. ");
INSERT INTO hwo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ka hangnda fiya ndangga Yeeso fa tsahayighǝn a ɓang kombuwol nda ɓa na ngguchit amana fiya ˈyaɓang mbǝrha fa. ");
INSERT INTO hwo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ƙǝsǝr ˈwaɗǝ teena ƙǝnang ɗǝ fiya hangga, ndǝn ǝnagha ndǝn fingya na tǝ wanhaaya fa kanda a ˈwaarha mbee ɓa ka a tsǝwarghǝn nda fa. ");
INSERT INTO hwo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kala sayidɗi nana sǝsǝn mbǝlfeeya ndǝn, ƙǝl na nda fǝla hai a mbedghǝn na nda a ndaarha, “Wan Faara ni Sa.” ");
INSERT INTO hwo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amma ƙǝsɗǝ thlǝman ndan a pǝr ndan tǝ wunni ndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tǝrgha Yeeso wumnda sǝ, aah fingyayina nǝn ɓa na midghǝn, ɗǝnda thlǝmadghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wurgha hasǝ ahur ndan Kum kap sǝri, aah kanda nǝn fathlǝnggighǝn, a tsawa nda tǝghǝn tǝ ƙǝm a nagha thlǝn kanda ka pǝr laɓar Faara ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tǝ wal ngyakhrha na kyangganda ǝnkaheeya sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kulo nafini kumkap sǝri wurnǝn ya. Siman, ɗǝfang na Yeeso thlǝma Mbiturus, ");
INSERT INTO hwo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu wan Dzabadi tǝ wanman na Yahaya. Ɗǝfangna Yeeso thlǝma kanda Mbuwadjis, ndaarha ni “Wangya Tǝrˈyana.” ");
INSERT INTO hwo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrawus, Filibus, Mbatalomi, Matta, Toma, Yakubu wan Halfa, Tandawus, Siman tǝ sǝrǝk chehweedghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tǝ Yahuda Iskaryoti, fǝrgha Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tǝrgha Yeeso kyagha ahur minda hai, nggǝrgha fiya wumnda ɓa, ndǝghǝn tǝ fa tsahayighǝn mba nda wal kwaman ǝna ˈya mii wa. ");
INSERT INTO hwo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sǝkna hurfayighǝn ǝnɗi nǝn a ǝnaarha, ɗǝnda ɗǝ ka a ƙǝsangganda, ƙǝsǝr na fiya a ndaarha, “Kyahar hutenggǝn hai.” ");
INSERT INTO hwo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Fa malǝmngya ngyakhrha ɓagha ɓa Urshalima ndaa nda, “Nǝghǝn tǝ Mbaˈaldzabul fa! Tǝ ngyakhrha Mbaˈaldzabul ni nǝn a kyang ǝnkaheeya sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aagha Yeeso kanda ɓa thlǝghang karapu nǝn kanda sǝ, “Na sheetan ƙǝn na mbang kyang Sheetan sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","A tsakh kutǝryirha hai sǝri, mbǝ kutǝryidɗi isha wa. ");
INSERT INTO hwo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A tsakh wure hai sǝri, mbǝ wuriɗi isha wa. ");
INSERT INTO hwo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ana Sheetan a yan altenggǝn tǝ ƙǝm tsakhka hai, mbǝ mbang isha wa. Ɓa ngwala ɓenggǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ƙǝkafek, mbǝ niifa sǝ na kyarha minda ki niifa hai na kanglang wiigha tǝ ǝnggighǝn wa ƙǝl ma ˈwaɗǝ teena ƙǝnangɗǝ niifɗa hai na kanglang ˈwan. A mbanggǝn har karid wurighǝn. ");
INSERT INTO hwo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Niya pǝrang ƙǝkafek kun, ɗimiya na heu tǝ sarfaya ǝnana fiya na nda chahanggǝn kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amma kala niifa sargha Sǝsǝna tǝ Peɗǝnda mba tam chahanggǝn ɗǝ wa, ǝnaɗǝ ɗimiyirha yi pa kwanɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Thlǝkna Yeeso ndǝn kee ƙǝsǝr na nda a ndaarha, “Nǝghǝn tǝ ǝnkaheerha fa.” ");
INSERT INTO hwo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tǝrgha ɓagha man Yeeso ɓa tǝ wanmanggighǝn. Isha nda a ƙǝshi thlǝn farha nda ɗa nda aaghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Fiya wumngga hai muwang nda maɗufu hai, ndang ngganda, “Muwa tǝ wanmanggiwa kanda a ƙǝshi kanda a kaɗa sa.” ");
INSERT INTO hwo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tsakhmee nǝn, “Nda wunni iiya tǝ wanmanggina?” ");
INSERT INTO hwo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tǝrgha ƙǝlanggǝn fiya muwangga maɗufu hai ndǝghǝn, “Kulo nda iiya ya tǝ wanmanggina! ");
INSERT INTO hwo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kala niifa ǝnagha taara tǝ ˈya na mid Faara tsauɗǝ wan pa tǝ wan nya tǝ iiya.” ");
INSERT INTO hwo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeeso nggǝrghǝn ɗǝrha mbeeɗǝ tǝ tsahang fiya ha a mii wuri aam Nggalili. Fiya wumngga thlǝmadghǝn ɓa mulnda hai kaan pa kyagha hu kombuwol hai fiya tsǝtsau a mii ƙǝkǝshɓang nda. ");
INSERT INTO hwo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsahang ɗǝ ǝngya kanda ha hangga tǝ karapuya. A hu tsahadghǝn ha ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kama thlǝmarha hai! Tǝ huɗarha ɗǝɗǝ ka hǝfrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nanǝn aten wash wiidɗi, hǝrgha fingya hai aten kwamana, ɓagha wuɗikkya ɓa ɗamangganda. ");
INSERT INTO hwo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hǝrgha fingya hǝreng keela hai, ka mbuwana chehweerha sǝ ngga kya nda sǝ ƙǝkar, ƙǝsǝr mbǝ chehweedghǝn kuɗimnggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Amma tǝkna yanfaara hai, hwara nda ɗǝ, ƙǝsǝr kwa wanda thlaara hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fingya hǝra nda pathlang ndakhkya hai kya nda sǝ kal wanda farha hai a pathlang ndakhkini wa ko kanda ǝna wee. ");
INSERT INTO hwo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amma fingya hǝra nda hu chehweerha hai na ngga kyanda sǝ ǝna wee nda fingya katǝra kumnggit mahan-mahan, fingya ƙǝm kumnggit mikki-mikki har haru-haru.” ");
INSERT INTO hwo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndǝghǝn, “Yi na tǝ thlǝmad sǝkrha, sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sayidɗi nanǝn katenggǝn, kumkap sǝri ɗi tǝ fingya na a thlǝmadghǝn tsahang mee nda ha aten karapu yini. ");
INSERT INTO hwo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ndanggǝn kanda, “Nggǝmang nda kun fa na a sǝn ˈya nun na kutǝryid Faara ahurghǝn, fingya a mbǝ tǝ karapu wa mba nda sǝnggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tǝna nda, “‘Ƙǝlaarha ɗǝ, amma mba nda kukwalang hai wa, na nda sǝkƙǝn ƙǝm, amma mba nda sǝnang hai wa. Kam kyahar nda ɓa, chahang ɗimiyid ndan nda kanda ɗǝ!’ ” ");
INSERT INTO hwo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tǝrgha ndangga Yeeso kanda, “Ashe sǝnanggun karapu ɗa hai ya wa, ƙǝƙǝn nun sǝn fingya karapuya? ");
INSERT INTO hwo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tǝ hǝfǝdɗi, laɓar Faara ni nǝn a pǝra. ");
INSERT INTO hwo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wiidɗi hǝrgha aten kwamana hai nǝghǝn aten nafiya sǝkka laɓarɗi, amma ɓagha Sheetan ɓa tǝranggǝn laɓar ɗaɗǝ ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fingya, na nda ƙǝla wiirha hǝf nanda a hǝreng keela, sǝk nanda laɓarɗi thlǝghǝn nda tǝ hura pǝpet. ");
INSERT INTO hwo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma mbuwana thlar ndan sǝ, mǝngwanda ha wa. A hǝrǝm ɓillarha nduwa sǝsaarha ɓarha ɓa ƙǝsǝr ka laɓarɗi mba nda kwas kyaharra hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tǝ ƙǝm na fingya ƙǝla wiiya hǝrgha pathlang ndakhkya hai, sǝkka laɓarɗi; ");
INSERT INTO hwo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amma ƙǝsǝr ɓillad ƙǝshiirha, tǝ suna ƙǝna tǝ nggǝm ǝn ƙǝshiirha thluranggǝn laɓarɗi ahur ndan tsauka mbǝ ˈyani na ngga wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wiiya hǝrgha hu chehweerha hai na ngga, nafiyani sǝkka laɓar Faara thlǝghǝnda fa tǝ chikrha katǝra kumnggit mahan-mahan, kumnggit mikki-mikki tǝ haru-haru aten ǝnɗi hǝf nanda.” ");
INSERT INTO hwo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ndangga Yeeso kanda, “ˈWad niifa ɓarha ɓa tǝ patilla tsǝɓanggǝn tǝ tǝɓa nduwa ɗǝfanggǝn kasǝra ɗǝ wa? Mbǝ nǝm ɗǝfang nda a mbǝd ɗǝfǝdghǝn wa? ");
INSERT INTO hwo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mbǝ ˈyasǝ na ɓǝɓee mbuwa kyarha sǝ wa. Mbǝ ˈyasǝ ƙǝm na nggǝnggǝla mbuwa wa kyarha pǝpal ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kala niifa na tǝ thlǝmad sǝkrha sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Kwarama tǝ sǝk pathla nun naarha sǝkrha, tur tasau ƙǝƙǝrɗi nun a ƙǝƙǝrra sǝ, ndǝghǝnni na nda a ƙǝƙǝrang kunsǝ ƙǝm har kal yinun nǝn mu.” ");
INSERT INTO hwo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","“Kala niifa na tǝ ˈya ha na nda a chighanggǝn, kala niifa ƙǝm mbuwa wa tǝ ˈya ha, yanɗi nanǝn tǝghǝn ha ƙǝm na nda a thlang nda hai.” ");
INSERT INTO hwo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nggǝrgha Yeeso ndaarha, “Na kutǝryid Faara kiya. Niifa washgha wiirha ahu hedghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mǝngga ha, kyagha wiidɗa sǝ, sǝngwa sǝ tǝ katǝradghǝn hai ƙǝƙǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tǝ altenggǝn nagha a tsǝrha, katǝradghǝn hai tǝ kwaafa, ɗǝfgha hur iiwee nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A hǝrǝmɗǝ nakhɗaarha, nǝn a hwasang sǝ tǝ ɗǝhwasarha ƙǝsǝr tsǝ shifiirha hai.” ");
INSERT INTO hwo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nggǝrgha Yeeso ndaarha, “Tǝ ma nǝm sakh kutǝryid Faara, nduwa tǝ tur yanggi karapu nǝm sakhƙǝn sǝ? ");
INSERT INTO hwo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nǝghǝn ƙǝla wan parsǝna na wanggǝn ngguchit ahur wiiya na heu nǝm hǝfrha. ");
INSERT INTO hwo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A hǝfang ɗǝm hai nǝn tsǝrha tsauka ɗǝfrha manggǝn kal fingya nǝn na ahu hedɗi ǝnagha wuɗikkya ƙǝndan a wuhwaryighǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tǝ fingya karapuya ƙǝla yanɗiya hangga thlǝghangna Yeeso kanda sǝ, tǝ fingya na nda mbang sǝnang hai. ");
INSERT INTO hwo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mbǝ ˈyasǝ nǝn thlǝghang kanda kula karapu wa. Amma sayidɗi nanǝn tǝ fatsahayighǝn nǝn fǝlanggǝn kanda hai. ");
INSERT INTO hwo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A farɗi tsǝna figrha hai, ndanggǝn fatsahayighǝn, “Tama pǝm wuri aamɗa ɗǝ ya.” ");
INSERT INTO hwo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mal fiya nda a samarha, wii nda ɗǝ tǝghǝn ahu kombuwol ɗi nanǝn sǝ. Na fingya kombuwalya sǝ ƙǝm a mbǝɗi mbuwa samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Thliigha ɓereu ˈyaara ɓa, nagha a pǝshang aama ahu kombuwol ndan ɓa takhka a timnda hai. ");
INSERT INTO hwo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeeso a ɓeena a samad kombuwol ɗi. Thlengga fatsahayighǝn sǝ ndang ngganda, “Mala, sǝngwa takh ɗǝm a mǝra wa?” ");
INSERT INTO hwo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Thliigha Yeeso sǝ, yananggǝn ɓereu ɗi, “Nggasu hai! Ishiu!” Isgha ɓereu ɗi, nggasgha mbǝrha hai. ");
INSERT INTO hwo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tǝrgha ndanggǝn fatsahayighǝn, “Mani tǝrǝm nun? Ai fǝrƙǝkafekkid nun?” ");
INSERT INTO hwo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tǝr ma nda kaan, tsahang mee nda ndan, “Wunniya? Na ɓereurha tǝ kufulla aama fǝrang mamnggirha!” ");
INSERT INTO hwo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeeso tǝ fatsahayighǝn ɗǝnda pǝm wuri aamɗa ɗǝ na a chehweed Nggarasina. ");
INSERT INTO hwo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tǝrna Yeeso hai ahu kombuwol ɗi, na niifasǝ tǝ ǝnkaheerha fa, kyaghǝn ɓa a mbǝd ten kwaya hwathla Yeeso nǝn fa. ");
INSERT INTO hwo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Niifɗiya nǝn mǝnda ahur kwad mǝrya, mbǝ niifasǝ na mbang ƙǝnang hai ko tǝ wuyiwurra ni wa. ");
INSERT INTO hwo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ƙǝsǝr na nda yakh ƙǝnang nda hai nda harghǝn tǝ sarghǝn tǝ wuyiwurra, amma nǝn ɗahang nda ɗǝ hwasang nggǝn ɗǝɓǝlyina ɗǝ na a sarghǝn. Mbǝ niifasǝ na kanglang na mbang kǝsang hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nda yanfaara tǝ fǝɗigrha nǝn naarha aten kwaya, tǝ ten ferya, nagha ahuhwaarha tǝ thleng nda fadghǝn ɗǝ tǝ ferya. ");
INSERT INTO hwo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nanǝn Yeeso ɗǝ inggun, ɗagha ɗǝ ɓǝra hai a mbedghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tǝranggǝn uradghǝn sǝ kaan huhwagha ndǝghǝn, “Mana midwa tǝ nggi, Yeeso, Wan Faara Amshi? Hwanni sa hu thlǝm Faara a sǝsenna wa!” ");
INSERT INTO hwo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Thlǝk nǝn ndǝn kee ƙǝsǝr ndangga Yeeso, “Kyosǝ a fad niifɗiya, sa ǝnkaheerha!” ");
INSERT INTO hwo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tǝrgha tsahangga Yeeso mee, “Thlǝmwani ƙǝn?” Ndǝghǝn, “Hangga, ƙǝsǝr nan hangga.” ");
INSERT INTO hwo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nagha a hwan Yeeso a rǝkɗǝ kanda ma mbǝɗi wa. ");
INSERT INTO hwo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na chiɓǝd ƙǝlengarya sǝ a mbǝɗi a lafrha tsau tǝ sar wumnda fa. ");
INSERT INTO hwo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hwangga ǝnkaheeyini Yeeso, “Malang kan ɗan thlǝmad ƙǝlengaryina ɗǝ ya, kyan hur ndan hai.” ");
INSERT INTO hwo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nggǝmanggǝn kanda fa, kya nda sǝ a fad niifɗi ɗa nda kyarha ahur ƙǝlengaryina hai. Chiɓǝd ƙǝlengaryini sǝl nda haru kumnggit sǝri, ɗa nda hu wuri aamɗa ɗǝ mǝra nda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fa laf ƙǝlengaryini ɗan ndani wupǝri ɗǝ tǝ fingya talya ɗa nda pǝr ǝnɗi katǝragha hai. Ɗagha fiya ɓa, ɓa nda na ǝnɗi katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓana nda thlǝmad Yeeso ɓa, na niifɗa nda na tǝ ǝnkaheeyina fa, tsau hai, kalɗǝ lukrha fa ngga ɓa hutenggǝn ɓa, tǝr ma nda. ");
INSERT INTO hwo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nafini na a mbǝɗi nagha ǝnɗi katǝragha hai, pǝranggǝn nda kanda ǝnɗi katǝragha hai tǝ niifɗi na tǝ ǝnkahedɗa fa tǝ ƙǝlengaryini ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tǝrgha nafini hwan Yeeso nda a malanggǝn chehweed ndan. ");
INSERT INTO hwo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na Yeeso a kyarha hu kombuwol hai, niifɗi na tǝ ǝnkahedɗa fa hwan Yeeso nǝn a ɗǝgha ɗǝ a samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nggǝmangwa Yeeso fa wa, amma ndanggǝn, “Ɗuwa wureɗǝ ɗa wal nafiwa, pǝrang ǝnɗana kanda ǝnona Chinǝm tǝ haɗonǝn fa.” ");
INSERT INTO hwo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tǝrgha niifɗi wiigha wureɗǝ ɗǝgha naarha pǝr ǝngya ǝnangna Yeeso a talya kum. Fiya na heu na nda a na ǝnwulteena, ");
INSERT INTO hwo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nggǝrna Yeeso ɗǝrha pǝm wuri aamɗa ɗǝ tǝ kombuwol, wumngga fiya thlǝmadghǝn ɓa hangga ndǝghǝn ɓalɗǝ a mii wuri aamɗi. ");
INSERT INTO hwo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tǝrgha tal ahur mamngya Ƙǝn hwan Faara sǝ na nda aarha Yayirus, ɓa ɗǝ mbǝɗa ɓa. Nanǝn Yeeso ɓǝrgha hai tǝ waɗedghǝn, ");
INSERT INTO hwo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hwanggǝnǝn, “Wutarad na a mǝra. Niya hwan sa ɓoɓa ɓa ɗǝfang haara teena tǝnǝn ƙǝnda wal yibrha nǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɗǝgha Yeeso ɗǝ a samadghǝn. Fiya hangga mbuwa samadghǝn ɗǝ tǝ ƙǝm na nda a ˈyaɓang mbǝrha fa. ");
INSERT INTO hwo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na nuneefa sǝ a mbǝɗi na faara a ɓang nda fa hai hurarha kumkap sǝri. ");
INSERT INTO hwo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sǝsaɗǝ kaan ahar fa fǝr ɗǝfya hangga tǝ ƙǝm ɓǝlang ɗǝ ǝn huharghǝn ɗǝ, a meghedghǝn ˈya kamngga a ƙǝngga amma ƙǝl chikrha. ");
INSERT INTO hwo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sǝknǝn laɓar Yeeso, ɓagha ɓa tǝ man samadghǝn ahur fiya tsuwar kootodghǝnǝn fa, ");
INSERT INTO hwo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ƙǝsǝr numaɗǝ, “A tsuwarɗi kootodghǝn fa kee, niya wal ƙǝnda.” ");
INSERT INTO hwo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A mbǝɗi tsu kee ishgha farɗi na a ɓang nda fa hai, tǝkƙǝnǝn fa a fadghǝn walɗǝ ƙǝnda ahu sǝsadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsu sǝnangga Yeeso hai na sǝsǝmnda sǝ kyagha ɗǝ a fadghǝn. Kyahargha hai ahur fiya tsakhmee nǝn, “Wunni tsuwargha kootodna fa?” ");
INSERT INTO hwo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nggǝmangga fatsahayighǝn, “Nanna fiya a ˈyaɓo mbǝrha fa, nana a tsakhmee, ‘Wun tsuwargha nggi fa?’ ” ");
INSERT INTO hwo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amma nagha Yeeso a ƙǝlarha ɗǝ tǝ wunni ǝnagha kee. ");
INSERT INTO hwo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tǝrgha nuɗi, sǝnnǝn ˈya katǝragha hai tǝghǝn, ɓagha ɓa ɓǝrgha hai a mbedghǝn, nagha fadghǝn a rǝbrha fa ka tǝrǝmnda, pǝrang ƙǝkafek nǝn ˈya katǝragha hai heu. ");
INSERT INTO hwo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ndangga Yeeso nuɗi, “Waana, fǝrƙǝkafekkid wa ƙǝnoɗǝ. Ɗuwaɗǝ hu ɗǝɗemnggirha yibna hu sǝsadwa.” ");
INSERT INTO hwo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yeeso ɓalɗǝ a ndikrha fa kee, ɓagha fingya ɓa a minda ki Yayirus, ndaa nda, “Mǝr wutarad wa, kama nun nggǝr ƙǝtǝlang tǝ malǝmndǝɗa fa?” ");
INSERT INTO hwo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ɗǝfwa Yeeso teena tǝ path nafini wa, ndanggǝn mamnda tǝ Ƙǝn Faara na ngguchit, “A tǝrǝmna wa, furu ƙǝkafek kee.” ");
INSERT INTO hwo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Malangwa fiya mbu samadghǝn nda wa, ƙǝl Mbiturus, Yakubu tǝ Yahaya wanman Yakubu. ");
INSERT INTO hwo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓana nda minda ki mamnda Ƙǝn Faara ɓa na ngguchit, ƙǝlagha Yeeso fiya a tsǝ teena na nda a tǝrha tǝ huhwaarha kaan. ");
INSERT INTO hwo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kyanǝn sa hai ndanggǝn kanda, “Kama nda nun a tsǝ teena tǝ huhwaarha kaan kee? Mǝrwa wanɗi wa amma nǝghǝn a shiirha.” ");
INSERT INTO hwo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amma masangganda. A kwasamadɗi kyang nǝn fiya ƙǝsha hai, tǝranggǝn nda chin wanɗi tǝ man tǝ fa tsahayighǝn na a thlǝmadghǝn, kyagha hu ƙǝnɗa ɗǝ na wanɗa sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ƙǝs harghǝnǝn ndanggǝn, “Talita kumi,” ndǝna “Sa wutararha, thliusǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Thliigha wanɗa sǝ wiigha hai. Huradghǝn kumkap sǝri. Katǝrana ǝnɗa hai ya kanda heu ǝna ǝnwulteena nda. ");
INSERT INTO hwo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ƙǝs thlǝman ndan nǝn a sǝk niifa ǝnɗiya wa, ndanggǝn kanda a fǝrang ǝnnarhami nda ǝnagha mii. ");
INSERT INTO hwo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Malna Yeeso mbǝɗi, ɗǝgha hu talghǝn ɗǝ tǝ fatsahayighǝn a samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɓana far yibrha ɓa yi Yahudaya, katǝranggǝn tsaharhaha ahu Ƙǝn Faara na ngguchit, Fiya hangga sǝkka ndǝn ǝna ǝnwulteena na nda, na nda a ndaarha, “Walgha niifɗi ǝnggini a yanggi ya? Tur yanggi sǝnda ni walnǝn, nǝn naarha ǝna ǝnwulteengya kiya?” ");
INSERT INTO hwo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Ndeye, mbǝ kafinta ɗani ya wa? Mbǝ wan Mairamu ni wanmangya Yakubu, tǝ Yisufu, tǝ Yahuda tǝ Siman wa? Wanmanggighǝn nishya mbǝ kulu kǝm tǝ kanda ya wa?” Sǝbgha hur ndan ɗǝ tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ndangga Yeeso kanda, “Ƙǝl ahur talghǝn, a pathlang hurfayighǝn tǝ hur mindǝghǝn ndǝn mbuwana annabi wal mamnggirha.” ");
INSERT INTO hwo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ənawa Yeeso ǝnwulteena a mbǝɗi wa, ƙǝl haara ɗǝfang nǝn fingya haaya fa, ƙǝnanggǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Fǝrang ɗǝ ǝnwulteena, ka yamid fǝrƙǝkafekkid ndan. Tǝrgha Yeeso nagha a wiirha hai tala-tala a tsahang fiya ha; ");
INSERT INTO hwo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aah kumkap sǝri ɗa nǝn thlǝmadghǝn ɓa, thlǝn kanda nǝn sǝri-sǝri fǝrang sǝsǝmnda nǝn kanda aten ǝnkaheeya. ");
INSERT INTO hwo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ndanggǝn kanda, “A turɗun ˈya ahu widɗi ya wa ƙǝl sǝsaala kee. A ƙǝsɗun mburodi ha, ko yawarha, ko wuɗǝɓǝla ahu panjakwayinun wa. ");
INSERT INTO hwo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Paama pakhma amma ma Kǝsɗun lukrha ha sǝri wa. ");
INSERT INTO hwo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kala minda ˈwanun kyarha sahai tsawama sǝ ƙǝl farɗi mal nun talɗi. ");
INSERT INTO hwo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kala mbǝrha thlǝwa nanda kun fa, nduwa ƙǝm kangwanda thlǝmarha kun fa wa, a naɗun a mal talɗi tinid talɗi na a sarnun pamanɗǝ ka a tsauka ǝn sakhrha aten ndan. ");
INSERT INTO hwo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ƙya nda ƙǝshaaɗǝ ɗa nda pǝr laɓar Faara a fiya a malangganda ɗimiyid ndan. ");
INSERT INTO hwo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kyangganda ǝnkaheeya sǝ hangga a tǝ irang fǝɗeerha fiya fa mbuwa wa ƙǝkanglang ƙǝnangganda kanda.” ");
INSERT INTO hwo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sǝkna Hirdus laɓarɗi ya, ƙǝsǝr thlǝm Yeeso ɗǝɗa ɗǝ inggun. Fingya a ndaarha, “Yahaya tǝ Mbaptisma ni thliigha sǝ hu mǝrra, ndǝghǝnni nanǝn tǝ sǝsǝmnda fa yi ǝna ǝnwuteengya.” ");
INSERT INTO hwo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Fingya a ndaarha, “Annabi Ilya ni.” Ndagha fingya ƙǝm, “Annabi ni, ƙǝla tal ahur annabiya na kaar.” ");
INSERT INTO hwo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Amma sǝkna Hirdus laɓarɗiya, ndǝghǝn, “Yahaya, niifɗi kyathlangni tenggǝn ɗǝ, thliiɗa sǝ hu mǝrra!” ");
INSERT INTO hwo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ƙǝsǝr Hirdus fǝrɗǝ ngyakhrha a ƙǝsangganda Yahaya, muwanggǝn hu porsǝna ɗǝ. Ənanǝn kee ƙǝsǝr ka Herodiya, nu wanman Filibus, kahang nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ƙǝsǝr Yahaya nǝn naarha ndang nda Hirdus, “Kamngwa a kahangga nu wanmuwa wa.” ");
INSERT INTO hwo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiya sǝb hurghǝn ɗǝ tǝ Yahaya, na midghǝnsǝ a ɓǝlanggǝn amma mbǝ mbang wa. ");
INSERT INTO hwo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ƙǝsǝr Hirdus nǝghǝn a tǝrǝm Yahaya, nǝn naarha lafghǝn mbǝ midghǝnsǝ a walgha ˈya ndǝn wa, ƙǝsǝr Yahaya ka niifa ni tǝ peɗǝnda ni. A sǝk Hirdus fad Yahaya nǝn ɓillaghǝn fa kaan, ko nanǝn kee nǝn naarha kang thlǝmarha fa. ");
INSERT INTO hwo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A kwasamadghǝn wal kwamana nǝn, a farɗi ǝnana Hirdus wutsǝfayid lǝghǝtta ɓen nggǝttǝghǝn hai, aah nǝn mamnggighǝn ɓa tǝ mamngya sodjaya tǝ fingya mamngya na hu chehhweed Nggalili. ");
INSERT INTO hwo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tǝrgha wutarad Hirdus kyagha ɓa rǝpgha, mbǝnanggǝn Hirdus tǝ ronggighǝn nana nda a hǝb ǝnnarhami. Ndangga kutǝrɗi wutaradɗi, “Tsahe ˈya na midwa, niya furoƙǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nggǝmɗa fa har tǝ aah thlǝm Faara, “Kala ˈya tsakhna niya furoƙǝn ko mberra chehweedna ni!” ");
INSERT INTO hwo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɗǝgha thlǝmad man ɗǝ, ndanggǝn, “Mani tsahang nda?” Ndangga man, “Ten Yahaya tǝ Mbaptisma.” ");
INSERT INTO hwo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A mbǝɗi kee thliigha ƙǝkar a thlǝma kutǝra ɗa ɗǝ ndanggǝn, “Na minnasǝ nanǝnya ten Yahaya tǝ Mbaptisma ahu pǝlee.” ");
INSERT INTO hwo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tǝrgha mǝrgha fad kutǝrɗa hai, amma ka ɗǝf miighǝn ǝnanǝn a mbed ronggighǝn, nggǝmngwa fa a hwasanggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tǝrgha thlǝn sodja nǝn ɗǝgha ɓarha ɓa tǝ ten Yahaya. Ɗǝgha ƙǝn porsǝna ɗǝ kyathlanggǝn ten Yahaya hai; ");
INSERT INTO hwo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ɓagha ɓa tǝ ten Yahaya ahu pǝlee fǝranggǝnǝn wutaradɗa ɗǝ, wutaradɗi ƙǝm fǝranggǝnǝn man ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sǝkna fatsahaya Yahaya ǝnɗi katǝragha hai, ɓa nda ɓa tǝrang ngganda merreghǝn hai pangganda. ");
INSERT INTO hwo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Fathlǝngya Yeeso wuma nda thlǝmadghǝn ɓa, pǝrang ǝnggina nda heu ǝnana nda tǝ tsahan ndan ha. ");
INSERT INTO hwo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tǝrgha, ƙǝsǝr ka nana fiya hangga na a ɓarha ɓa tǝ fingya a wiirha wal wa Yeeso tǝ fa tsahayighǝn kwaman ǝna ˈya mii wa. Ndanggǝn kanda, “Taama a mbǝrha ɗǝ mbuwana fiyasǝ ƙǝm katen nǝm ɗun yibrha.” ");
INSERT INTO hwo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tǝraa nda hu Kombuwol hai katendan ɗǝnda mbǝrha ɗǝ mbuwana fiya sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma fiya hangga nagha kanda a wiirha, kukwalangganda kanda hai ɗa nda ɗǝ tǝ saara tǝ hur talya heu ˈwaa nda mbǝɗa ɗǝ ma kanda. ");
INSERT INTO hwo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tǝrna Yeeso hai na fiya nǝn hangga haɗangganda fa, ƙǝsǝr na nda ƙǝla chaukhraya kula tǝ lafrha. Katǝranggǝn tsahang ǝngya kanda ha hangga. ");
INSERT INTO hwo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tsǝna figrha hai, ɓagha fatsahayighǝn thlǝmadghǝn ɓa, ndang ngganda, “Kaheerha ni mbǝɗiya kulo mbiya tsǝ figrha hai. ");
INSERT INTO hwo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kalu fiya hai tǝna nda ɗǝrha ahu heeya ɗǝ tǝ talya na tsau a mbǝɗiya ɗa nda kaɗa ǝnnarhami tafan ndan.” ");
INSERT INTO hwo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amma ndangga Yeeso kanda, “Kun tafan nun fǝraman ˈya kanda ǝnna ndami lee.” Ndang ngganda, “Wuɗǝɓǝla na ahar nan nǝn sǝl wuɗǝɓel rapathlaarha na nda teng niifa yi ndǝree wuvaɗa! Ɗan heng mburodi kanda ɓa tǝghǝn fǝranggǝnan kanda ǝna nda mii wa?” ");
INSERT INTO hwo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tsahangga Yeeso mee kanda, “Mburodi kurmi ni ahar nun? A ƙǝla man ɓa.” Wuɗa nda ɓa ndang ngganda, “Mburodi tuf tǝ tǝna sǝri.” ");
INSERT INTO hwo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tǝrgha ndangga Yeeso fiya a wumangganda tendang tsawa nda hai aten hwalirha. ");
INSERT INTO hwo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tǝrgha wumangganda tendan tsawa nda hai fingya kumggit tuf-tuf, fingya haru-haru. ");
INSERT INTO hwo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tǝranggǝn mburodi ɗa sǝ tuf tǝ tǝnɗi sǝri, ƙǝlagha talara sǝ, usa Faara nǝn a kyanggǝn mburodi ɗa hai. Fǝranggǝnǝn fatsahayighǝn ndǝghang nggǝnda fiya. Nggǝrghǝn ndǝghang tǝn ɗa hai kowunni walɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Əna nda mii heu nggaala nda. ");
INSERT INTO hwo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wumangga fatsahayighǝn katǝpghǝn kutasya kumkap sǝri heu tǝ tǝnɗi. ");
INSERT INTO hwo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hang nda hǝshya ǝnagha mburodi ɗa mii haru kumggit tuf ni. ");
INSERT INTO hwo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsu a kwasamad ǝnɗiya, ndangga Yeeso fatsahayighǝn kya nda ahu kombuwol hai ˈwaa nda mbeeɗǝ tǝɗangganda wuri aamɗi teena a Mbatseda ɗe, ndǝghǝnggi ƙǝm kal fiya nǝn hai. ");
INSERT INTO hwo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A kwasamadɗi kal nǝn fiya hai tǝrgha wumnda sǝ ka ɗǝgha hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsǝna figrha hai, kombuwolɗi a maɗufu wuri aamɗi, ndǝghǝn katenggǝn aten chehweerha. ");
INSERT INTO hwo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ƙǝlagha Yeeso hai fatsahayighǝn ahu ɓillaarha kaan, ƙǝsǝr ɓereurha a tsang hura kanda fa ahar tsar, ɗǝgha thlǝmad ndan ɗǝ, nagha a wiirha aten wuri aamɗi. Tsǝgha ƙǝla nǝn a mbǝrang kanda hai. ");
INSERT INTO hwo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amma nana ndan a wiirha aten wuri aamɗi. Huhwaa nda ka hǝreenga, tamngganda ndaarha mǝnda-mǝnda ni. Huhwaa nda, ");
INSERT INTO hwo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ƙǝsǝr kanda heu nandan tǝr ma nda. Inanggǝn mighǝn hai ƙǝkar ndanggǝn kanda, “Ƙǝrsaama, nggini. A tǝrǝmɗun wa.” ");
INSERT INTO hwo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tǝrgha kyagha ahur kombuwol ɗa hai tǝ kanda, nggasgha ɓereu ɗa hai. Ƙǝsgha ǝnwulteena kanda, ");
INSERT INTO hwo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ƙesǝr ɓalgha nda kula sǝnang ǝnwulteena ɗa hai ǝnana Yeeso aten mburodi ɗi, ƙǝsǝr ka kakrakkit tendan. ");
INSERT INTO hwo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tǝɗang nanda wuri aamɗi teena, sǝla nda Djanisǝrat ɗǝ, ƙǝnangganda kombuwol ndan hai. ");
INSERT INTO hwo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kyana nda sǝ ahur kombuwol ɗi, kukwalangga fiya Yeeso hai. ");
INSERT INTO hwo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɗa nda hai ahu chehwedɗi kahad na nda a ɓarha ɓa tǝ haaya ahu ɗǝnggǝlya kala mbǝrha sǝknanda na Yeeso sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kala mbǝrha ɗǝna Yeeso sa ɗǝ, hu talya tǝ wupǝri tǝ kaheeya na nda hunang haaya hai hu kasu hwanggǝnda a tsuwar pǝpǝshaprha kaɓadghǝn nda fa. Kala niifa tsuwargha ndǝn fa wal ɗǝ ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farɗa sǝ ɓagha fingya Farisaya tǝ famalǝmngya ngyakhrha a Urshalima ɓa, wuma nda thlǝmad Yeeso ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ƙǝla nda hai fingya fatsahaya Yeeso kanda a hǝb ǝnnarhami haryi ndan tǝ “Paarha”, ndǝna haryi ndan kula tsaɓrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ƙǝsǝr Farisaya tǝ Yahudaya mba nda hǝb ǝnnarhami kanda kula tsaɓang har ndan ɗǝ wa, ƙǝs nda ǝntin shingya ha. ");
INSERT INTO hwo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nǝghǝn kee ƙǝm mba nda kii ˈya hiina nda ɓa ahu kasu wa ƙǝl tsaɓang na nda haryi ndan ɗǝ ˈwan. Na ǝntingya sǝ ƙǝm hangga na nda lafrha, ƙǝla tsab ɗengya tǝ ɓǝǝya tǝ tasaukya tǝ ɓaleeya tǝ ǝnfuya. ");
INSERT INTO hwo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tǝrgha Farisayini tǝ famalǝngya ngyakhrha tsahang mee nda Yeeso, “Kama mbuwana fatsahayiwa takkwa ǝntin shingginǝm, na nda a ǝna ˈya mii tǝ har paaya?” ");
INSERT INTO hwo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nggǝmangga Yeeso kanda, Kun fa thlǝrɓuya! A ten nun ni thlǝkna annabi Ishaya pathɗiya, ƙǝla nanǝn chichireethlee hai tǝ ndaarha, “‘Nafiniya, ahu mii ndan ni kee na nda fǝre mamnggirha, amma hur yi ndan nǝghǝn inggun ma nggi; ");
INSERT INTO hwo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ka ni kee na nda a tǝree shilee teena, ƙǝsǝr ɗǝfangganda tsahad ǝntina a mbee, ma ˈya ndana Faara.’” ");
INSERT INTO hwo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Malanggun ˈya ndana Faara ƙǝs ǝntina nun ha ǝnana chichiyi nun.” ");
INSERT INTO hwo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ndanggǝn kanda, “Kar ngyakhrha Faara nun fa ka a laf ngyakhrha ǝntin chingginun nun! ");
INSERT INTO hwo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ƙǝsǝr ndagha Musa, ‘Fǝrang mamnggirha nda muwa tǝ tsu,’ tǝ ƙǝm, ‘Kala niifa ˈyargha chin nduwa man na nda ɓǝlang nda.’ ");
INSERT INTO hwo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma nduwun, a ndang niifa chin nduwa man, ‘ˈYa niya kya ɗang nda kunsǝ, ˈwaɗi teena ɗǝfangɗi ndǝn Faara ɗǝ,’ ");
INSERT INTO hwo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tǝrgha mbun malang niifɗiya ɗanggǝn chin sǝ nduwa man wa. ");
INSERT INTO hwo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsawanggun laɓar Faara mbǝ ˈya ni na ngga wa, ka ǝntin ngginun. Nun naarha ǝna ǝngya kee hangga.” ");
INSERT INTO hwo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Fiya wumngga hai nggǝrgha Yeeso aah kanda thlǝmadghǝn ɓa, ndanggǝn kanda, “Keema thlǝmarha fa kun heu, a sǝn ǝnɗanun ya. ");
INSERT INTO hwo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ˈYa na a ƙǝshi kyagha hur niifa ɗǝ mbǝ ndǝna tsawang tǝ paarha wa, amma ƙǝl ˈya na a kyarha sǝ ahurghǝn ndǝna tsawang nda tǝ paarha fa. ");
INSERT INTO hwo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yi na tǝ thlǝmad sǝkrha sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A kwasamadɗi malna Yeeso fiya kyanǝn hur minda hai, fatsahayighǝn tsahang mee nda ha aten karapu ɗi ya. ");
INSERT INTO hwo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tsahangga Yeeso mee kanda, “Sǝnanggun hai wa? Mbun a naghǝn wa ˈya kyagha hur niifa ɗǝ a ƙǝshi mbǝ ndǝna tsawang nda tǝ paarha fa wa? ");
INSERT INTO hwo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ƙǝsǝr kyawa ahurghǝn hai wa amma ahu mbǝbǝlǝmndǝghǝn ɗǝ, nggǝrghǝn kyarha sǝ a fadghǝn.” (Thlǝk nǝn pathɗiya a kyad ndaarha nǝn ǝnnarhami heu na nda ngga.) ");
INSERT INTO hwo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɗǝgha mbeeɗǝ tǝ ndaarha, “ˈYa na a kyarha ɓa ahur niifa ndǝna tsawang nda tǝ ‘paarha fa’. ");
INSERT INTO hwo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ƙǝsǝr ahur niifa sǝ, ndǝna numad ǝn mbǝlfeeya kyarha ɓa, susuwayirha, ngaara, ɓǝl farha, kulafayirha, ");
INSERT INTO hwo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kwit hura, mbǝlfeerha, nggaɓarha, suna, sǝrǝkkirha, sǝb thlǝma, nggǝm alteena, tǝ yamid huteena. ");
INSERT INTO hwo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ən mbǝlfeeyini na heu ya na nda kyarha sǝ ahur niifa; nǝn tsawang niifa ‘ɗimirha.’ ” ");
INSERT INTO hwo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tǝrgha Yeeso mal Nggalili nǝn ɗǝgha hu chehweed Taya ɗǝ tǝ Sidon. Kyagha hur minda hai mbǝ midghǝn sǝ a sǝngga fiya sǝ wa, amma mbǝ mbang ɓǝɓeng ɓadghǝn ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A mbǝɗi kee, nuneefa sǝ na wutaradghǝn tǝ ǝnkaheerha fa, sǝknǝn laɓar Yeeso ɓagha ɓa ɓǝrgha hai a mbedghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nuɗi tǝ Helenarha ni, nggǝtgha ndan a Fǝnikiya a chehweed Suriya. Hwan Yeeso nǝn a kyanggǝn ǝnkaheedɗa sǝ a fad wutaradghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ndangga Yeeso, “Malang wundakhnaya ˈwan nggaala nda, ƙamngwa tǝranggǝm ǝnnadmid wundakhnaya fǝranggǝnǝm wuɗaya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ndangga nuɗi Yeeso, “nǝghǝn kee, Chinǝm, amma na wuɗaya ǝna fǝfǝsǝrra ǝnnarhami na a hǝra hai ahar wundakhnaya.” ");
INSERT INTO hwo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ndangga Yeeso, “Ƙǝsǝr ka laɓarɗi kyawa nggǝreena sǝ ya, wiu fayiwa, ǝnkaheedɗi kyaɗa sǝ a fad wutarad wa.” ");
INSERT INTO hwo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ɗǝgha nuɗi wure ɗǝ ɗǝgha wal wutaradɗi keeghǝn kath hu sǝra, ɗǝkɗa hai tǝ ǝnkaheedɗi. ");
INSERT INTO hwo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tǝrgha malgha Yeeso chehweed Taya kyagha tǝ chehweed Sidon tǝ chehweerha na tǝ Talya Kum ɗǝgha wuri aam Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na nafiya sǝ ɓagha ɓa tǝ niifa a Yeeso na teɓeng tǝ ƙǝm mbǝ mbang kaala sǝ wa. Hwanggǝnda a ɗǝfang haara nǝn teena. ");
INSERT INTO hwo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ɗǝgha Yeeso tǝ teɓeng ɗi man patu ɗǝ ma fiya, panggǝn wan haryighǝn ahu thlǝmadghǝn ɗǝ. Chakh yakhrha nǝn hai, tsuwar sheneu niifɗa nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ƙǝlagha Yeeso talara sǝ yibgha fa kaan ndanggǝn, “Ifata!” Ndǝna “Inuɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tǝrgha ingga thlǝmad niifɗa ɗǝ, kwasgha sheneuƙǝn hai nagha a ndikrha fa ngga. ");
INSERT INTO hwo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ndangga Yeeso kanda a pǝrang ndan niifa wa. Amma ndǝghǝn aten yanang kanda, kanda aten pǝrghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ƙǝsgha ǝnwulteena fiya kaan na nda a ndaarha, “Ənaɗǝ ǝngya heu ngga, ƙǝnanggǝn teɓengya tǝ fingya mbuwa mbang kalasǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na farɗa sǝ nggǝrgha fiya wumnda thlǝmad Yeeso ɓa, nanǝn mbǝ ǝnnarhami sǝ ahar ndan wa, aagha Yeeso fatsahayighǝn thlǝmadghǝn ɓa ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na nafini a haɗee fa ya. Ɓeena mahan kanda a thlǝmanna, takhkwa ˈya ahar ndan a ǝna nda mii wa. ");
INSERT INTO hwo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A kal ɗi kanda hai wii nda wureeɗǝ a miirha, ɗǝna nda fǝla hai a kwamana. Ƙǝsǝr ɓagha fingya ɓa a mbǝrha ɓa inggun.” ");
INSERT INTO hwo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndangga fatsahayighǝn, “Amma ɗǝnǝm wal ǝnnarhami ɓa a yanggi a kahedɗiya na tsǝghang kanda?” ");
INSERT INTO hwo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsahangga Yeeso mee kanda, “Mburodi kurmi ahar nun”? Ndang ngganda, “Mǝd.” ");
INSERT INTO hwo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ndanggǝn fiya a tsawa nda hweeɗe hai. Haranggǝn mburodiɗa sǝ mǝd, hwan parka Faara nǝn, kyanggǝn hai fǝranggǝnǝn fatsahayighǝn ɗǝ a ndǝghang nggǝnda fiya ɗǝ, ǝna nda kee. ");
INSERT INTO hwo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tǝna sǝ ahar ndan ngguchit ƙǝm, hwan parka Faara nǝn atenggǝn, ndanggǝn fatsahayighǝn a ndǝghangganda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ənagha fiya mii nggaala nda. Akwasamadghǝn wumangga fatsahayighǝn kwasamadghǝn kutasya mǝd. ");
INSERT INTO hwo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hǝshya ǝnanda haru kumnggitghǝn faɗa. Kal nǝn kanda hai, ");
INSERT INTO hwo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kyagha ahur kombuwol hai tǝ fatsahayighǝn ɗǝgha a chehweed Ɗalmanuta ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɓagha Farisaya ɓa katǝrang ngganda tsahang mee Yeeso ha. Ka a ƙǝƙǝrangganda, tsahang mee nda ha a kyad ǝnsakhrha nǝn a talara hai. ");
INSERT INTO hwo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yibgha fa ndǝghǝn, “Mani na nafiya ƙǝshiid weeriya a kaɗa ǝnsakhrha yi wulteena? Niya pǝrang ƙǝkafek kun, mbǝ ǝnsakhrha sǝ nanda a kyatta wa.” ");
INSERT INTO hwo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tǝrgha mal kanda nǝn, wudgha ahur kombuwol hai tǝɗagha man patu ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Fatsahaya Yeeso mbǝɗang ɗǝ kanda ɓawa nda ɓa tǝ mburodi wa, ƙǝl tal ni kee ahur kombuwol ɗi. ");
INSERT INTO hwo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ƙǝsgha Yeeso thlǝmandan ndǝghǝn, “Kwarama tǝ mehen Farisaya tǝ yi Hirdus.” ");
INSERT INTO hwo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tsǝ laɓara nda atenggǝn a pathlang ndan, ndanda, “Ƙǝsǝr mbuwana mburodi sǝ ahar nǝm.” ");
INSERT INTO hwo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeeso sǝnang ɗǝ numan ndan hai ndanggǝn kanda, “Kama nun tsǝ laɓara tǝ ndaarha mbǝ mburodi sǝ ahar nun wa? ");
INSERT INTO hwo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kun tǝ yirha mbun a naghǝn wa, tǝ thlǝman nun sǝ mbun a sǝkƙǝn wa? Ɓal wun kula sǝnang hai wa? ");
INSERT INTO hwo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kyang ni mburodi ɗa hai tuf a fiya haru kumnggitghǝn tuf, Kutasya kurmi wumang nun kwasamadghǝn?” Ndang ngganda, “Kum kap sǝri.” ");
INSERT INTO hwo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ndangga Yeeso kanda, “Kyang ni mburodi ɗa hai mǝd a fiya haru kumnggitghǝn faɗa, kutasa kurmi wumang nun katǝpghǝn?” Ndang ngganda, “Mǝd.” ");
INSERT INTO hwo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndanggǝn kanda, “Sǝnanggun hai wa?” ");
INSERT INTO hwo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɓa nda Mbatsaida ɓa, ɓagha nafiya ɓa tǝ kwamarha hwan Yeeso nda a tsuwarghǝnǝn fa. ");
INSERT INTO hwo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ƙǝs har kwamadɗa nǝn kya nda sǝ ma hur talɗi ɗǝnda ƙǝsǝr talɗa ɗǝ. Chakh nǝn yakhrha a yid niifɗa ɗǝ ɗǝfang haara nǝn fa, tsahangga Yeeso mee, “Na ˈya sǝ nana wa?” ");
INSERT INTO hwo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ƙǝlagha sǝ ndǝghǝn, “Nggi a na fiya, na nda ƙǝla ɗǝfya a wiirha hai.” ");
INSERT INTO hwo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nggǝrgha Yeeso ɗǝfang harghǝn a yid niifɗa ɗǝ. Tǝrgha ingga yidghǝn ɗǝ, nggǝrgha yidghǝn ɓa, nagha a ƙǝlarha ɗǝ ngga. ");
INSERT INTO hwo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wuɗangga Yeeso wureeɗǝ, ndanggǝn, “A nanna a wutta wureeɗǝ a kyanna hur talɗa hai ya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeeso tǝ fatsahayighǝn ɗǝnda hu talya ɗǝ a Kaisariya Filibi. Nana nda a wiirha hu kwamana tsahangga Yeeso mee fatsahayighǝn, “Na fiya a ndaarha wunni nggi?” ");
INSERT INTO hwo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ndang ngganda, “Fingya a ndaarha Yahaya tǝ Mbaptisǝma, fingya a ndaarha Ilya ni, fingya a ndaarha ƙǝm, nǝghǝn tal ahur annabiya.” ");
INSERT INTO hwo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ndangga Yeeso kanda, “Amma kun wu, nuwun a ndaarha wunni nggi?” Ndangga Mbiturus, “Sani Ƙǝrǝsti.” ");
INSERT INTO hwo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ƙǝsgha Yeeso thlǝmandan a pǝrang ndan niifa tǝ wunni ndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Katǝranggǝn tsahang kanda ha tǝ ndaarha Wan niifa tǝtani a sǝsaagha aten ǝngya hangga, na shingya, tǝ mamnda firistaya, tǝ famalǝmngya ngyakhrha a karghǝn fa, nanda a ɓǝlang nda akwasamad ɓeena mahan nǝn a nggǝr thliirha sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Thlǝkƙǝn pathɗiya a pǝpal. Ɗǝgha Mbiturus tǝghǝn man patu ɗǝ ndanggǝn mǝmǝlwa nagha a thlǝk ˈya kiya wa. ");
INSERT INTO hwo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma kyahargha Yeeso hai ƙǝlanggǝn fingya fatsahayighǝn ɗǝ yanaggǝn Mbiturus, ndǝghǝn, “Nduwu hai tǝ nggi sa Sheetan, mba a ƙǝlang ǝngya na mid Faara wa, amma ǝngya kee na mid fiya.” ");
INSERT INTO hwo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tǝrgha aah fiya nǝn thlǝmadghǝn ɓa heu tǝ fatsahayighǝn ndanggǝn kanda, “Ana mid niifa sǝ mbu samanna nǝn malanggǝn nggǝm altenggǝn tǝranggǝn kaɗidghǝn sǝ, mbu samadna nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ana mid niifa sǝ ɗǝf yiɓǝdghǝn ɗǝ nǝn ƙǝɗeng nda. Amma kala niifa fǝrgha yiɓǝdghǝn ka nggi tǝ yi laɓarɗi na mbǝnggǝn ya ɗǝfang nǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma chighang nǝn niifa a walɗǝ ǝn ƙǝshiirha heu ƙǝɗenggǝn yiɓǝdghǝn? ");
INSERT INTO hwo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nduwa ƙǝm mana niifa fǝra a meghed yiɓǝdghǝn? ");
INSERT INTO hwo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A shiɗangwa niifa tǝ laɓarna ahu ƙǝshiid kulafayirha tǝ ɗimiyirha wa, Nggi, na Wan Niifa, mbǝ shiɗeerha ka ndǝghǝn wa a ɓaɗǝ hu mamnggit Chin ɓa tǝ yi fathlǝngya Faara tǝ peɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tǝrgha ndanggǝn kanda, “Niya pǝrang ƙǝkafek kun, na fingya sǝ ƙǝkǝt a mbǝɗiya nanǝnya mba nda a taarang mǝra fa wa na nda a naa Kutǝryid Faara ɓayi tǝ sǝsǝmnda mamnggitghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Akwasamad ɓeena mikki tǝrangga Yeeso Mbiturus tǝ Yakubu tǝ Yahaya tǝraa nda wumnda sǝ, kanda katendan. A mbǝɗi kyahargha fadghǝn hai a mbed ndan. ");
INSERT INTO hwo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lukkighǝn kyakhra nda hai pǝpet, pǝpettǝghǝn kalɗǝ mbǝrha mu hu ƙǝshidɗiya. ");
INSERT INTO hwo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tǝrgha kyagha nda Ilya ɓa tǝ Musa katǝrang ngganda ndikrha hai tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ndangga Mbiturus Yeeso, “Mala, nǝghǝn ngga nanǝm a mbǝɗiya, ngwa ǝna chama nan mahan-tal yiwa, tal yi Musa tǝ ƙǝm tal yi Ilya.” ");
INSERT INTO hwo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sǝngwa ˈya nǝn a thlǝkrha, ƙǝsǝr kanda heu tǝrǝmnda kaan. ");
INSERT INTO hwo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tǝrgha ɓagha hashbe ɓa nggǝlanggǝn kanda, sǝk urarha nda hai ahur hashbiɗi tǝ ndaarha, “Waana niya, nggǝmni. Kaman thlǝmarha fa!” ");
INSERT INTO hwo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kula sǝndǝndan sǝ, ƙǝla nda hai ko niifa ɓal, ƙǝl Yeeso katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na nanda a tǝraa hai a wumndǝɗi, ƙǝsgha Yeeso thlǝmandan a pǝrang ndan niifa ˈya na nanda wa ƙǝl ma thlid Wan Niifa sǝ ahu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nanǝn kee ƙǝsghǝnda ha ahur ndan, na nda a ndang nda ndan tǝmani “Thliirha sǝ hu mǝrra.” ");
INSERT INTO hwo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsahang mee nda ha, “Mani na famalǝmngya ngyakhrha ndaarha tǝta Ilya ni a ˈwa ɓaarha ɓa?” ");
INSERT INTO hwo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ndangga Yeeso kanda, “Ƙǝkafekni, Ilya ni a ˈwa ɓarha ɓa, ka ɓagha tangsang ǝngya ɗǝ heu. Kama nda chireethleng nanda hai Wan Niifa tǝtani a sǝsaagha tǝ ƙǝm karghǝnda fa? ");
INSERT INTO hwo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma niya ndang nda kun, ɓa Ilya ɓa, ǝnang ǝngya nda fa tǝrna mindan, ƙǝla nanǝn chichirethlee hai atenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tǝrnanda hai, ɓa nda wal fingya fatsahaya, ƙǝla nda hai wum fiya thlǝmandan ɓa tǝ famalǝmngya ngyakhrha kanda a ngaala tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hǝrǝmna fiya na Yeeso, tǝk mbǝnda nda fa ɗaa nda ɗǝ ɗa nda ndangˈya. ");
INSERT INTO hwo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tsahangga Yeeso mee fatsahayighǝn, “Mani nun a ngaalang teena tǝ kanda?” ");
INSERT INTO hwo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ndagha niifa ahur fiya ɓa, “Mala, ɓoni waana ɓa, nǝghǝn tǝ ǝnkaheerha fa har ˈyaɗang ɗǝ ndikrha fa. ");
INSERT INTO hwo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A thliiɗa ɓa, nǝn muwang hweeɗa hai. Nagha miighǝn a hufrha fa, nagha a ƙǝt miighǝn hwargha fadghǝn ɗǝ. Kalangɗi fatsahayiwa sǝ, amma mbang ngwanda wa.” ");
INSERT INTO hwo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ndangga Yeeso, “Kun wangya ƙǝshiid weeriya fa yamid fǝrƙǝkafekkya, pa kwanɗǝ ni tsaurha tǝ kun? Pa kwanɗǝ ni naarha tǝ kun? Ɓee wanɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɗang wanɗa nda ɗǝ. Nana ǝnkaheedɗi Yeeso, muwanggǝn wundǝladɗi a hweeɗa hai nagha fadghǝn a rǝprha fa tǝ miighǝn a hufrha hai. ");
INSERT INTO hwo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsahangga Yeeso mee chin wundǝladɗi, “Ɓeena kurmi ndǝghǝn tǝghǝn kiya?” Ndagha chin wanɗi, “Ka ndǝghǝn ngguchit. ");
INSERT INTO hwo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na ǝnkaheedɗi naarha muwang hu waarha hai tǝ aama ka a ɓǝlanggǝn. Amma a nanna a mbangnda a haɗowan fa ɗang kansǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ndagha Yeeso, “‘A nanna a mbangnda’? ˈYa na heu nǝghǝn pǝpa a fad niifa fǝrgha ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ƙǝkar ndagha chin wanɗi, “Fǝrɗi ƙǝkafek, amma ɗeesǝ tǝna fǝrƙǝkafekkid na chikrha!” ");
INSERT INTO hwo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ƙǝlana Yeeso hai fiya a ɗaarha ka ƙǝlarha ɓa, yananggǝn ǝnkaheedɗi, ndanggǝn, “Sǝsǝn teɓeng tǝ tip, ndoyi kyosǝ a fad wanɗiya a Nggǝrna kyarha fadghǝn hai ɓalwa!” ");
INSERT INTO hwo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tǝrgha ǝnkaheedɗi huhwaagha nagha wanɗi a tsǝˈya fa kaan a kyagha sǝ. Tsauka wanɗi kǝla mǝrra, kowunni a ndaarha, “Mǝrɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amma ƙǝsgha Yeeso harghǝn sǝ, thliigha sǝ ƙǝt. ");
INSERT INTO hwo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A kwasamadɗi kyana Yeeso wure hai, tsahangga fatsahayighǝn mee ɓǝɓee, “Mani mbangwa nan kyang ǝnkaheedɗa sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ndangga Yeeso kanda, “Tur yanɗiya ƙǝl tǝ hwan Faara ndǝnǝn kyarha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeeso tǝ fatsahayighǝn malangganda mbǝɗi kya nda tǝ Nggalili. Mbǝ midghǝn sǝ a sǝngga fiya mbǝɗi nanǝn sǝ wa, ");
INSERT INTO hwo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ƙǝsǝr nǝghǝn a tsahang fatsahayighǝn ha tǝ ndaarha, “Wan Niifa na nda a fǝrghǝn ahar nafiya hai. Na nda a ɓǝlang nda. A kwasamad ɓeena mahan nǝn a nggǝr thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma sǝnangwanda tsahadɗa ha keeghǝn ya wa, kanda ƙǝm a tǝrǝm tsahang mee. ");
INSERT INTO hwo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɓa nda Kafarnahum ɓa, nana nda ahur minda, tsahangga Yeeso mee kanda, “Mani nun a ngaalang teena a kwamana?” ");
INSERT INTO hwo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma nggasa nda hai tǝtip ƙǝsǝr a kwamana na nda a ngaala aten wunni manggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsauka Yeeso hai, aah kumkap sǝri ɗanǝn ɓa, ndanggǝn kanda, “Kala niifa na midghǝn sǝ a tsauka a mbee, tǝtani tsauka a samaarha heu tǝ mafad kowunni.” ");
INSERT INTO hwo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","“Tǝranggǝn wundakhnee ɓa ishanggǝn a maɗufun ndan. Ƙǝs harghǝnǝn ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Kala niifa thlǝgha wundakhnee fa ngguchit ƙǝla yanɗiya ahu thlǝmna thlǝnǝn nggi fa, tǝ ƙǝm kala niifa thlǝgha nggi fa thlǝnǝn Pǝpa fa thlǝngga nggi ɓa.” ");
INSERT INTO hwo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ndangga Yahaya Yeeso, “Mala, na ɗan niifa a kyang ǝnkaheeya sǝ tǝ thlǝmwa, yanang ɗan ƙǝsǝr mbǝ ahur nǝm wa.” ");
INSERT INTO hwo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ndangga Yeeso, “A yanang ɗun wa, ƙǝsǝr kala niifa ǝnagha ǝnwulteena tǝ thlǝmna akwasamadghǝn mbǝ thlǝk ǝngya mbuwa ngga atenna wa. ");
INSERT INTO hwo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kala niifa mbuwa tsan ƙǝm, yinǝm ni. ");
INSERT INTO hwo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Niya pǝrang ƙǝkafek kun, kala niifa fǝrangga aam saarha kun ko ahu wuhuleurha tal ahu thlǝmna ƙǝsǝr ka tsaunun yina mbǝ tam ƙǝɗeng wal ƙǝnaghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ana niifa sǝ kyangga tal ahur wangginiya hu ɗimiyirha hai, A nggushi waghang nda fǝn hǝrha ura mughang ngganda ahu wuri aama ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ana harwa a kyorha hu ɗimiyirha hai, kyathlang ɗǝ, a nggushi kyana hu kutǝryid talara ɗǝ tǝ haara tal ma kyana hu waarha ɗǝ mbuwa mǝra hai tǝ haara sǝri. ");
INSERT INTO hwo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A mbǝɗi waya na naarha kii kanda mba nda mǝra wa, wadɗi ƙǝm mba nda mbang ɓǝlang hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ana sarwa a kyorha hu ɗimiyirha hai, kyathlang ɗǝ. A nggushi kyana hu kutǝryid talara ɗǝ tǝ saara tal ma kyana hu waarha ɗǝ tǝ saara sǝri. ");
INSERT INTO hwo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A mbǝɗi waya na naarha kii kanda mba nda mǝra wa, wadɗi ƙǝm mba nda mbang ɓǝlang hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ana yidwa kyorha hu ɗimiyirha hai, ƙǝɗang ɗǝ. A nggushi kyana hu kutǝryid talara ɗǝ tǝ yirha tal ma kyana hu waarha ɗǝ tǝ yirha sǝri. ");
INSERT INTO hwo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A mbǝɗi, ‘Wayini na kii kanda mba nda mǝra wa, wadɗi ƙǝm mba nda mbang ɓǝlang hai wa.’” ");
INSERT INTO hwo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kala niifa na nda a tsaɓang nda ɗǝ tǝ waarha ƙǝla na nda tsaɓang sataka ɗǝ tǝ fǝsa.” ");
INSERT INTO hwo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Fǝsa nǝghǝn ngga, amma a tǝr mbǝndǝghǝn ɗǝ, tǝma nǝm nggǝr nggǝrang ɓa? Naama tǝ fǝsa fa, tǝ ƙǝm naama ɗǝɗem tǝ ndan,” ");
INSERT INTO hwo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tǝrgha malgha Yeeso Kafarnahum, ɗǝgha chehweed Yahuda ɗǝ tǝ pǝm kufad Urdun. Nggǝrgha fiya naarha wumnda thlǝmadghǝn ɓa, tsahanggǝn kanda ha ƙǝla nǝn tǝ ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɓagha fingya Farisaya ɓa na mindan sǝ a ɗǝfang takthleera nda. Tsahang mee nda ha, ndang ngganda, “Pǝranggǝn kan, ahu ngyahad nǝm mǝmǝlni a kalgha niifa nukkun hai?” ");
INSERT INTO hwo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsahangga Yeeso mee kanda, “Ndagha ɗeleewar Musa ƙǝn?” ");
INSERT INTO hwo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ndang ngganda, “Ndagha ɗeleewar Musa a chirethlengga niifa ɗeleewar nǝn nukkun sǝ kalghǝnǝn hai.” ");
INSERT INTO hwo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Amma nggǝrangga Yeeso kanda sǝ, ndǝghǝn, “Ka kakrakid tennun ni ndangna Musa kun kee. ");
INSERT INTO hwo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma a katǝra ǝna ƙǝshiirha, ‘Faara ǝnaɗǝ hǝshneefa tǝ nuneefa.’ ");
INSERT INTO hwo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ndǝn ǝnagha ndǝn na niifa mal chin tǝ man thlǝthlǝɓanggǝn nukkun fa, ");
INSERT INTO hwo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sǝri ɗi nanda tsau thlu farha tal. Ɓalwanda sǝri ɓalwa, amma tsau nda tal. ");
INSERT INTO hwo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tsaunǝn kee mbǝ niifa sǝ na ndǝghang ˈya hai wumangna Faara wa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wudnanda hur minda hai, nggǝrgha fatsahayini tsahang mee Yeeso aten laɓarɗiya. ");
INSERT INTO hwo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ndanggǝn kanda, “Kala niifa kalgha nukkun hai kakhka pak ǝnanǝn kulafayirha aten nuɗi. ");
INSERT INTO hwo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nǝghǝn kee ƙǝm, kala nuneefa ndǝkka hai tǝ chimadghǝn, nggǝrghǝn kakh chimarha pak ǝnanǝn kulafayirha.” ");
INSERT INTO hwo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na farɗasǝ ɓagha fiya ɓa tǝ wanggindan ka a ɗǝfangga Yeeso parka kanda teena, amma fatsahayighǝn na nda a yanang kanda. ");
INSERT INTO hwo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Amma nana Yeeso ǝnɗi na nda a ǝnaarha, sǝbgha hurghǝn ɗǝ ndanggǝn kanda, “Malaman wundakhnaya na nggun-ngguchit ɓa nda thlǝmanna ɓa, a yanang ɗun kanda wa. Ƙǝsǝr Kutǝryid Faara yi tur ndanni. ");
INSERT INTO hwo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Niya pǝrang ƙǝkafek kun, kala niifa thluwawa kutǝryid Faara ƙǝla na wundakhnee ngguchit ǝnaarha wa mbǝ tam kyaarha saɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tǝrgha tǝranggǝn wanggini a fad pǝniyighǝn sǝ ɗǝfang haara nǝn kanda teena fǝrang parka nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Thliina Yeeso wiirha, ɗagha niifa thlǝmadghǝn ɓa ɓǝrgha hai tǝ waɗedghǝn a mbedghǝn ndanggǝn, “Ka tǝmalǝmnda, ma kamngga tǝta a ǝnee tǝni wal yibrha mbuwa ngwalarha?” ");
INSERT INTO hwo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ndangga Yeeso, “Mani na aah nggi ka niifa? Mbǝ ka niifa sǝ wa ƙǝl Faara katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sǝnna ˈya ndaana ngyakhrha, ‘A ɓǝlna farha wa, a ǝnanna kulafayirha wa, a ngaarna wa, a nggaɓangna niifa fa ka wa, a huk na farha wa, fǝrang mamnggirha nda muwa tǝ tsu,’ ” ");
INSERT INTO hwo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ndangga niifɗi Yeeso, “Mala, ka nggi ngguchit lafɗi ngyakhkini ya.” ");
INSERT INTO hwo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ƙǝlangga Yeeso niifɗi tǝ yid nggǝmnda ndanggǝn, “Taho ˈyaha tal kamngga a ǝnana, ɗuwaɗǝ ɗa heng ǝnggiwa ɗǝ heu nana tǝghǝn ha fǝrang wuɗǝɓǝlghǝna fa yamiiya, na wal mbǝd ɗǝfǝdghǝn a talara. Tǝrgha a ɓana ɓa, ɓa mbu samadna.” ");
INSERT INTO hwo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A mbǝɗiya sǝbgha hur niifɗaɗǝ, wiigha tǝ hurghǝn sǝsǝɓa ɗǝ ƙǝsǝr tǝ ƙǝnani kaan. ");
INSERT INTO hwo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kyahargha Yeeso hai ƙǝlagha ɗǝ, ndanggǝn fatsahayighǝn, “Nǝghǝn pǝɗaghǝn a kyagha tǝ ƙǝna ahu kutǝryid Faara ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sǝkna Fatsahayini pathɗi kee fǝrang ǝnwulteena nǝn kanda. Amma nggǝrgha Yeeso ndang kanda, “Wanggina, nǝghǝn pǝɗaghǝn kaan, na a kyagha niifa hu kutǝryid Faara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nǝghǝn pǝpa a kyagha thlǝkhmu ɗǝ tǝ kwad libra ma tǝ ƙǝna kyagha hu kutǝryid Faara ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nggǝrgha pathɗi chighang ǝnwulteena fatsahayini na nda a tsahang mee ndan ha, “Anaɗǝ kee wunni a wal hǝrǝkrha?” ");
INSERT INTO hwo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ƙǝlangga Yeeso kanda ɗǝ ndǝghǝn, “Niifa tǝ wasa in nǝghǝn pǝɗaghǝn, amma mbǝ tǝ Faara wa, ƙǝsǝr ǝngya heu nǝghǝn pǝpa a fad Faara.” ");
INSERT INTO hwo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tǝrgha ndangga Mbiturus, “Malang ɗan ǝngya heu mbuɗan samadwa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nggǝrangga Yeeso sǝ, “Niya pǝrang ƙǝkafek kun, mbǝ niifa sǝ malangga wurighǝn nduwa wan manggighǝn hǝshya nduwa wan manggighǝn nishya nduwa man nduwa chin nduwa wanggighǝn nduwa heeyighǝn ka nggi tǝ laɓar Faara ");
INSERT INTO hwo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na ƙǝɗeng wal ƙǝnaghǝn katǝra haru aten, wuraya, wan mangya hǝshya, wan mangya nishya, mangya, waya tǝ kaari-tǝ sǝsaaya. A hu ƙǝshiirha na ɓayi na nda a wal yibrha mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amma fingya ˈwagha kanda ni a nggǝl mee, fingya nggǝlgha mee kanda ni a ˈwaarha.” ");
INSERT INTO hwo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanda hu kwaman ɗǝrha Urshalima ɗǝ, Yeeso a mbee, fatsahayighǝn a na ǝnwulteena, fiya na a mbusamad ndan ƙǝm ƙǝsgha hǝreenga kanda. Nggǝrghǝn ɗǝrha tǝ fatsahayighǝn man patu ɗǝ pǝrang ˈya nǝn kanda ɗǝgha katǝrarha hai tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ndanggǝn kanda, “Ɗǝnǝm Urshalima ɗǝ, ɗǝna nda fǝr Wan Niifa a mamnda firistaya tǝ famalǝmngya ngyakhrha. Na nda a ngwang kumad mǝrra fǝranggǝnda fingya mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na nda a waaghǝn, chahang yakhrha nda fa, tsaɗaghǝn nda, ɓǝlangganda. A kwasamad ɓeena mahan nǝn a nggǝr thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tǝrgha nda Yakubu tǝ Yahaya wangya Dzabadi, ɓa nda thlǝmadghǝn ɓa ndang ngganda, “Mala, na minnan sǝ a ɗangga kansǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsahang mee nǝn kanda, “Mana minnun a ǝnanggi kun?” ");
INSERT INTO hwo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nggǝrangganda sǝ, “A ɗǝd na hu tsǝnggam kutǝryidwa ɗǝ ngwa tsauka tal ahur nan a yisǝmadwa tal ƙǝm a yikawadwa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nggǝrangga Yeeso kanda sǝ ndǝghǝn, “Sǝnggun ˈya nun a hwanda wa! Nun mbang saarha tǝ wuhuleuɗi niya saarha sǝ wa nduwa ǝnang mbaptisǝma nda kun tǝ tur mbaptisǝma ǝneena nda wa?” ");
INSERT INTO hwo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ndang ngganda, “Haˈi, nan a mbang nda.” Ndangga Yeeso kanda, “Nun a mbang saarha tǝ wuhuleu sanna tǝ ƙǝm ǝnang mbaptisǝma nda kun tǝ tur mbaptisǝma ǝneena nda, ");
INSERT INTO hwo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","amma tsaurha a yisǝmadna tǝ yikawadna mbǝ nggini fǝrghǝn wa. Mbǝyini ya yi fingya ni ngwagha fa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tahad fingya kum sǝknanda kee, sǝbgha hurndan ɗǝ aten nda Yakubu tǝ Yahaya. ");
INSERT INTO hwo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nanǝn kee, aagha Yeeso kanda ɓa heu ndǝghǝn, “Sǝnɗunsǝ fingya tsauka kutǝrya fiya hu ƙǝshidɗiya mbuwa Yahudaya sǝnna nda kanda tǝ kutǝryirha, fingya mamngya ƙǝm kanda ni tǝ sǝsǝmnda ha heu aten fingya na a kamu ndan. ");
INSERT INTO hwo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma ahur nun nǝn a tsaurha pak. Kala niifa na midghǝn tsauka ndǝghǝnni mamnda tǝta ni tsauka ƙǝla mafad nun. ");
INSERT INTO hwo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kala niifa na midghǝn a nagha a mbee, tǝtani a tsauka mafad kowunni. ");
INSERT INTO hwo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ko nggini na Wan Niifa, ɓawi ɓa mbǝ ka a ǝnee taara nda wa, amma ka ǝnang taara ni fingya tǝ ƙǝm fǝr yiɓǝd nani a meyed fiya hangga.” ");
INSERT INTO hwo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tǝrgha ɓa nda Djeriko ɓa. Nana Yeeso tǝ fatsahayighǝn heu tǝ fiya na a mbusamad ndan a kyarha sǝ ahur talɗi, na kwamarha sǝ tsau a mii kwamana a hwanda thlǝmnggǝnni Mbartimawus wan Timawus. ");
INSERT INTO hwo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sǝknǝn ndaarha Yeeso tǝ Nadzarat ni na a mbǝraɗǝ, katǝranggǝn huhwaarha hai, “Yeeso! Wan Ndauda! A haɗoyi fa!” ");
INSERT INTO hwo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fiya hangga njarghǝnda, ndang ngganda, “Nggasu hai.” ");
INSERT INTO hwo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sǝkna Yeeso ndǝn, ishgha hai ndǝghǝn, “Ndaman a ɓagha ɓa.” Aaghǝn nda, ndang ngganda, “No wutsǝfayirha fa, thliusǝ nǝghǝn a aah sa.” ");
INSERT INTO hwo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tǝrgha kwamadɗi pǝrgha sǝ, muwanggǝn kootodghǝn ɗǝ, ɗǝgha thlǝmad Yeeso ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tsahangga Yeeso mee, “Mana midwa a ǝnoyi?” Ndangga kwamadɗi, “Mala, na minnasǝ a namanani hai.” ");
INSERT INTO hwo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ndangga Yeeso, “Ɗuwaɗǝ, fǝrƙǝkafekkid wa ƙǝnoɗǝ.” Tsu a mbǝɗi kee na mana nǝn hai mbusamad Yeeso nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Takhna Yeeso tǝ fatsahayighǝn a ndusang Urshalima fa, ɓa nda Mbetafaji ɓa tǝ Mbetani na a Wumngya Ɗǝfya Dzaitun, thlǝngga Yeeso sǝri ahur fatsahayighǝn a ˈwa nda mbeeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ndanggǝn kanda, “Ɗaama ahu talɗa ɗǝ na a mbennun taarha, a kyaɗun sahai, nun a na wan kwaara ƙǝƙǝna hai ˈwawana nanda tǝraa. Kwasaman hai, ɓon ɓa tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A tsahang niifa mee kun, ‘kama nun a ǝnaarha kee?’ ndaman, ‘Chinǝm ndagha na midghǝnsǝ nǝn a wuɗang ɓa wed.’ ” ");
INSERT INTO hwo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɗǝgha fatsahayina ɗǝ ɗa nda wal wan kwarɗi a mii kwamana, ƙǝƙǝna hai a kwatkirma. Na nanda a kwasang hai, ");
INSERT INTO hwo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nafiya na ƙǝƙǝt a mbǝɗi tsahang mee nda kanda, “Ma nun a ǝnaarha, kama nun a kwasang wan kwarɗa hai?” ");
INSERT INTO hwo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pǝr ǝnɗa nda thlǝghangna Yeeso kanda, malangga nafini kanda. ");
INSERT INTO hwo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓang wan kwarɗa nda Yeeso ɓa muwangganda parkoyindan a ƙǝsǝrghǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fiya hangga lǝlǝɓangganda kootoyindan hai ahu kwamana, fingya kyath shiiya nda ɓa lǝlǝɓangganda hai. ");
INSERT INTO hwo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nagha fiya na a samadghǝn tǝ yi mbedghǝn ahuhwaarha, “Falama Faara! Tǝ parkani niifɗi ɓagha ɓa ahu thlǝm Chinǝm! ");
INSERT INTO hwo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Parkani kutǝryidɗi na ɓayi yi chichit nǝm Ndauda. Falama Faara na a talara!” ");
INSERT INTO hwo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ɗǝna Yeeso Urshalima ɗǝ kyagha ahu Ƙǝn hwan Faara ɗǝ. Ƙǝlanggǝn mbǝya heu, amma tsaunǝn hǝm yanfaara hai, kyagha sǝ tǝ fatsahayighǝn ɗǝnda Mbetani ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɗathna mbǝrha hai na nanda a mal Mbetani, nagha miirha a ƙǝs Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ƙǝla nǝn ɗǝ na ɗǝf shiɓarha nǝn ɗǝ tǝ shee fa, ɗǝgha kamughǝn ɗǝ ƙǝlanggǝn tǝnǝn wal wanggǝn. Ndusang nǝn fa, mbǝ ˈyasǝ wal nǝn a uradghǝn wa ƙǝl shiiya, ƙǝsǝr shifidghǝnni wa. ");
INSERT INTO hwo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tǝrgha ndanggǝn ɗǝfǝdɗi, “A nggǝr niifa kii ɗǝfǝd wa ɓalwa pakwanɗǝ.” Sǝkka fatsahayighǝn ˈya ndanǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sǝlna Yeeso tǝ fatsahayighǝn a Urshalima ɗǝ, kyagha a pǝpal Ƙǝn Faara ɗǝ ƙatǝranggǝn rǝghang nda nafiya ɗǝ na a ǝna shafili a mbǝɗi. Chaggǝlanggǝn tebǝrya fa mbeɗed wuɗǝɓǝla tǝ kulohod fa heng kataprakkya, ");
INSERT INTO hwo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","mbǝ malang niifa mbǝrgha ɗǝ tǝ ǝn shafili tǝ pǝpal Ƙǝn Faara wa. ");
INSERT INTO hwo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsahanggǝn kanda ha ndǝghǝn, “Nǝghǝn chichirethlee hai ahu ɗeleewar Faara tǝ ndaarha, “‘Ƙǝnna nǝm aaghǝn Ƙǝn Faara yi fiya heu.’ Amma tsawanggun mbǝd ɓǝɓed ngaarya.” ");
INSERT INTO hwo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mamnda firistaya tǝ famalǝmngya ngyakhrha sǝk nanda ǝnɗi katǝragha hai katǝrang ngganda kaɗa kwamana hai na a ɓǝlangganda. Amma kanda a tǝrǝmnggǝn, ƙǝsǝr fiya heu tsahadghǝn ha nǝghǝn a fǝrang ǝnwulteena kanda. ");
INSERT INTO hwo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsǝna figrha hai, Yeeso tǝ fatsahayighǝn kya nda sǝ a wupǝri ɗi. ");
INSERT INTO hwo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A tsar, na nanda a wiirha, na shiɓadɗa nda hwarɗaɗǝ tǝ thlaryighǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ɗalghǝna Mbiturus ndǝn in ndanggǝn Yeeso, “Mala! Kuloɗǝ! Ɗǝfǝd shiɓadɗi shiwangna na!” ");
INSERT INTO hwo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tǝrgha ndangga Yeeso fatsahayini, “Fǝrama ƙǝkafek a Faara. ");
INSERT INTO hwo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niya pǝrang ƙǝkafek kun, a ndang niifa wumndǝɗi ya, ‘Ɗǝwaɗǝ, ɗa muwang fadwa a wuri aama ɗǝ,’ a ngaal wa ahurghǝn wa amma fǝrɗǝ ƙǝkafek tǝ ndaarha ˈya thlǝknǝn nǝn a katǝrarha hai, nanda a ǝnanggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsaunǝn kee niya ndang nda kun, kala ˈya na minnun a hwanang ɗun Faara, tǝ ƙǝkafekkirha, nun a walghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A naɗun a hwan Faara, ˈwaama teena chahang ɗimiyid ndan nun fingya ɗǝ ǝnangga ɗimiyirha kun fa, tǝna yinun Chiina na a talara chahang ɗimiyid nun kun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amma a chakhkun ɗimiyirha wa, mbǝ yinun Chiina na a talara a chahang ɗimiyid nun kun ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nggǝrna Yeeso ɓaarha Urshalima ɓa, ndǝghǝn a wiirha hai a pǝpal Ƙǝn Faara, Mamnda firistaya, famalǝmngya ngyakhrha tǝ shingya ɓaa nda thlǝmadghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tsahang mee nda, “Tǝ tur yanggi ngyahadyi na ǝna ǝngginiya, wun furowa kwaman ǝna ǝnɗiya?” ");
INSERT INTO hwo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nggǝmangga Yeeso kanda, “Niya tsahang mee kun ha tal. A nggǝreeɗun sǝ, niya pǝranggǝn kun tǝ wun fǝreegha kwamana niya ǝna ǝngginiya. ");
INSERT INTO hwo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wun fǝrangga kwamana Yahaya ǝna mbaptisǝma nǝn? Faara fǝrangga wa, nduwa fiya wa? Pǝreemadghǝn!” ");
INSERT INTO hwo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tǝrgha thliigha ngaala sǝ a pathlang ndan, ndaa nda, “A ndaa ɗǝm, ‘a talara ni hai,’ nǝn a tsakh mee, ‘Kama fǝrangwa nun ƙǝkafek?’ ");
INSERT INTO hwo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A ndaa ɗǝm, Fiya fǝrangga.” Na nda a tǝrǝm fiya, ƙǝsǝr sǝn fiya sǝ Yahaya annabini. ");
INSERT INTO hwo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ndang ngganda Yeeso, “Sǝngwan wa.” Ndangga Yeeso kanda, “Nggi ƙǝm mbi pǝranggǝn kun tǝ wunni fǝreegha ngyakhrha niya ǝna ǝngginiya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Katǝrangga Yeeso laɓara hai tǝ karapuya, ndǝghǝn, “Na niifa sǝ ǝnagha hed wan ɗǝfya, kanggǝn raa mbǝd ˈyaɗa wan ɗǝfyina nǝn tǝ ƙǝm tǝn mbǝd ƙǝla hedɗa nǝn ɗangkam. Dzǝmanggǝnǝn fahuɗaya ha ɗǝgha hu chehweerha ɗǝ inggun.” ");
INSERT INTO hwo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsǝna shifirha hai thlǝn mafadghǝn nǝn thlǝmad nafina ɗǝ nzǝmngga hedɗi a ǝnang wan ɗǝfyina nda ha. ");
INSERT INTO hwo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amma nafini nzǝmngga hedɗi ɗǝghangganda mafadɗa ɗǝ wuɗangganda ko ˈya a harghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nggǝrghǝn thlǝnang mafarha kanda ɗǝ, ɗǝkƙǝn nda atenggǝn fǝrang shilee nda. ");
INSERT INTO hwo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yi mafarha nggǝrnǝn thlǝnda ɗǝ ɓǝlangganda. Ɗǝgha mbeeɗǝ tǝ thlǝn mafayighǝn ɗǝ fingya ɗǝk kanda nda, fingya ɓǝlangganda kanda. ");
INSERT INTO hwo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tahanggǝn ha tal nǝn a thlǝnda, wanggǝn nggǝmnǝn kaan. Thlǝnanggǝn wanggǝn a thlǝmad ndan ɗǝ, ahu numadghǝn, ‘Ɗǝna nda fǝrang mamnggirha waana.’” ");
INSERT INTO hwo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Amma ndangga fahuɗayini ndan, ‘Kulo tǝ har langad hedɗi ɓayiya, tama ɓǝlanggǝm tǝna hedɗi tsaurha yinǝm ya!’ ");
INSERT INTO hwo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nanǝn kee, ƙǝsangganda wan ɗa ɓa ɓǝlangganda muwangganda ƙǝshaaɗǝ ma hedɗi.” ");
INSERT INTO hwo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsahangga Yeeso mee kanda, “Ma kamngga a ǝnagha tǝ hedɗi? Nǝn a ɓarhaɓa ɓǝlanggǝn nafina ɗǝ dzǝmngga hedɗi fǝrang hedɗa nǝn nafiya pak. ");
INSERT INTO hwo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ˈWawun karatang ǝnɗiya ahu ɗeleewar Faara wa? ‘Feera karna fa tǝngya ndǝn tsauka fer sar ƙǝnna. ");
INSERT INTO hwo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ənɗa ǝnana Faara ya, Nadghǝn ǝnwulteena ni.’” ");
INSERT INTO hwo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tǝrgha kaɗa kwamana nda na a ƙǝsangganda ƙǝsǝr sǝndasǝ a tendan ni ǝnanǝn karapuɗiya. Amma kanda a tǝrǝm fiya; nanǝn kee malangganda wii fayindan nda. ");
INSERT INTO hwo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kanda sǝ, thlǝn Farisaya nda tǝ nafiya Hirdus a thlǝmad Yeeso ɗǝ a ɗǝfang takthleera nda tǝ pathya tǝna nda ƙǝsang nda tǝ pathla ɗimi. ");
INSERT INTO hwo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓaa nda thlǝmadghǝn ɓa ndang ngganda, “Mala, sǝnɗansǝ ka niifa ni sa, Sa mba wurahasǝ wa fiya heu yiwa ni, Sa na thlǝk ƙǝkafek. Kamɗǝ ateng tsamnda nan Kaisar wa nduwa awo? ");
INSERT INTO hwo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A ten wa nduwa awo?” Amma Yeeso sǝnɗǝ thlǝrɓuyindan, ndanggǝn kanda, “Kama nda nun a ɗǝfee takthleera? Fǝree ma pene ɗa ɓa ƙǝlanggi.” ");
INSERT INTO hwo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓang pene ɗa nda ɓa, tsahang mee nǝn kanda, “Shishing nda wunni tǝ thlǝm wunni atenggǝn?” Ndang ngganda, “Yi Kaisar ni.” ");
INSERT INTO hwo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tǝrgha ndangga Yeeso kanda, “Fǝraman ˈya Kaisar tsauka yi Kaisar, a Faara tsauka yi Faara.” Əna ǝnwulteena nda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tǝrgha Sadukiyaya ɓa nda thlǝmad Yeeso ɓa kanda ndagha mbǝ thliirha sǝ hu mǝra wa tǝ tsakhmee, ");
INSERT INTO hwo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ndang ngganda, “Mala, chireethleng Musa ndǝn kan hai tǝ ndaarha a mǝr wan man niifa mal nuneefa nǝn hai amma kula wundakhnaya, tǝtani a kahangga wan man nuu mǝrɗi ka a nggǝɗang waya nǝn wan mansǝ. ");
INSERT INTO hwo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nanǝnya na wan mangya sǝ mǝd. Tǝpamǝnda kahanggǝn mǝrgha kula nggǝt wundakhnaya. ");
INSERT INTO hwo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yi sǝri kahanggǝn nu mǝrɗi, amma mǝrgha kula mal wee hai. Nǝghǝn kee ƙǝm tǝ yi mahan. ");
INSERT INTO hwo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kanda heu mǝd kahang nda nuɗi mǝra nda kula kanda mal wundakhnaya hai. A kwasamadghǝn nuɗi ƙǝm mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nanǝnya, ahu thliirha sǝ hu mǝrra na nuɗi tsaurha yi wun, tsaunǝn nafini mǝd kahang nda?” ");
INSERT INTO hwo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nggǝrangga Yeeso kanda sǝ, ndǝghǝn, “Numad nun mbǝ mǝmǝl wa ƙǝsǝr sǝnggun Laɓar Faara na chichireethlee hai tǝ sǝsǝmnda Mamnggitghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A far thliirha sǝ hu mǝra, na nda tsaurha ƙǝla fathlǝngya Faara mba nda kakhrha wa. ");
INSERT INTO hwo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nanǝnya aten thlid mǝrya sǝ, a ɗeleewar Musa, karatanggun laɓar nji waarha na a kaheerha ndangna Faara, ‘Nggini Faara yi Ibrahim, tǝ Ishaku tǝ ƙǝm Yakubu’ wa? ");
INSERT INTO hwo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ndǝghǝnggi mbǝ Faarani yi mǝrya wa, amma yi fa yibya ni, kun sahadɗun kaan!” ");
INSERT INTO hwo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Niifa tal ahur famalǝmngya ɗeleewar Musa ɓagha ɓa ɓagha wal kanda a ngaala. Ƙǝlanǝn hai nggǝrang Yeeso kanda sǝ mǝmǝl, tsahang mee nǝn Yeeso, “A hu ngyakhkya heu, yanggini manggǝn?” ");
INSERT INTO hwo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ndangga Yeeso, “Yanɗi na manggǝn nǝghǝn kiya, ‘Sǝghamadghǝn, kun Isǝreela! Chinǝm Faarnǝm ndǝghǝnni Chinǝm katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nggǝmu Chinǝm Faarwa, tǝ hurwa heu, tǝ yiɓǝdwa heu tǝ huten wa heu, tǝ kanglanggid wa heu.’ ");
INSERT INTO hwo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yi na a takkwaghǝn ndǝna, ‘Nggǝmu tuladwa ƙǝla altenwa.’ Mbǝ ngyakhrha sǝ kalgha finayiniya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tǝmalǝmnda ɗeleewar Musa ɗi ndanggǝn Yeeso, “Mala, thlǝknan mǝmǝl. Thlǝkna ƙǝkafek ndana Faara tǝtal mbusǝ pak wa. ");
INSERT INTO hwo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na a nggǝmnggǝ nǝm, tǝ hurnǝm heu, yiɓǝd nǝm heu, tǝ kanglanggid nǝm heu, tǝ kǝm nggǝmu tuladwa ƙǝla altenwa ndǝna manggǝn na nji satakh maɓiya tǝ fingya satakhkya.” ");
INSERT INTO hwo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nana Yeeso kamshiiɗi nggǝrang ɗa sǝ ngga tǝ ndǝdǝlyirha ndanggǝn, “Mbaa inggun tǝ kutǝryid Faara wa.” A mbǝɗi kee nggǝrwa niifa tsahang mee ɓalwa. ");
INSERT INTO hwo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nana Yeeso a tsaharhaha a pǝpal Ƙǝn Faara, tsakh mee nǝn, ndǝghǝn, “Mani na famalǝmngya ngyakhrha ndaarha Ƙǝrǝsti wan Ndauda ni? ");
INSERT INTO hwo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ndauda tafadghǝn, nanǝn lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda ndǝghǝn, “‘Chinǝm ndanggǝn Yina China, Tsawu a yisǝmanna ƙǝl a tsawangɗi fa tsanggiwa, a kamu saryiwa.’” ");
INSERT INTO hwo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ndauda tafadghǝn aaghǝn ndǝn, ‘Chinǝm.’ Ƙǝƙǝn nǝn tsaurha wanggǝn?” Fiya wumngga hai na nda a kang thlǝmarha fa tǝ wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A hu tsahadghǝn ha, ndǝghǝn, “Kwarama tǝ famalǝngya ngyakhrha. Kanda na mindansǝ kal kaɓaya fa ana nda a wiirha hai a yid fiya tǝ ƙǝm anagha fiya a ndangˈya kanda ahu kasu. ");
INSERT INTO hwo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na nda naarha wur mbǝd tsaukya na nggǝngga a ƙǝngya tsahad Yahudaya tǝ mbǝd mbǝnafa. ");
INSERT INTO hwo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na nda naarha huk nu mǝrya ahu wurayindan. Na nda djib hwan Faara tǝna fiya ndaarha ka nafiya ni kanda. Tur nafiniya na Faara sǝsang kanda kaan ma fingya.” ");
INSERT INTO hwo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tǝrgha Yeeso tsauka tsau tǝ mbǝɗi na panjakwadɗa sǝ nagha a ƙǝlang kanda a Ƙǝn Faara. Fa ƙǝnaya hangga fǝr nda wuɗǝɓǝlya manggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tǝrgha ɓagha nu mǝrra ɓa tǝ yamirha fǝr yighǝn nǝn anini sǝri. ");
INSERT INTO hwo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aah fatsahayighǝn nǝn thlǝmadghǝn ɓa, ndanggǝn kanda, “Niya pǝrang ƙǝkafek kun, fǝrrǝɗi kii nu mǝrɗiya kalɗǝ yi fiya heu. ");
INSERT INTO hwo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nafini na heu ya fǝrghanda ahu hangnda ˈya na nanda tǝghǝn ha, amma ndǝghǝn nggi ahu yamidghǝn fǝrɗǝ ˈya na a harghǝn heu.” ");
INSERT INTO hwo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na Yeeso a kyarha sǝ ahu Ƙǝn Faara, tal ahur fatsahayighǝn ndanggǝn, “Mala! Ƙǝlang feryini na mǝmanggǝn sakhɗang nanda tǝnggina sǝ ya! Tur tǝngginiya ǝnwulteena ni!” ");
INSERT INTO hwo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ndangga Yeeso, “Nanna tǝnggini na nggǝngga ya? Nanda a chaggǝnlang kanda hai, mbǝ feera sǝ nanda a malang aten shadghǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nana Yeeso tsau a mbǝd ɗǝfya Dzaitun kang hura nǝn Ƙǝn Faara fa, Nda Mbiturus, tǝ Yakubu, tǝ Yahaya tǝ Andǝrawus tsahang mee nda Yeeso ha ɓǝɓee, ndang ngganda, ");
INSERT INTO hwo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Akwan na ǝnggini a katǝrarha hai ya? Mani ǝn sakhrǝghǝn na a kyat lǝghǝttǝghǝn nǝn?” ");
INSERT INTO hwo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ndangga Yeeso kanda, “Kwarama naɗǝ niifa sakhɗang kun. ");
INSERT INTO hwo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Fiya hangga na a ɓarha ɓa hu thlǝmna, na nda a ndaarha kanda ni ‘nggi,’ naa nda a sakhɗang fiya hangga. ");
INSERT INTO hwo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","A sǝkɗun yangya tǝ fiya a tsǝ laɓar yangya, a tǝrǝm ɗun wa. Tsauɗǝ tǝtani a katǝragha hai, amma mii ngwaladghǝn ɓalɗǝ ˈwan. ");
INSERT INTO hwo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na chehweeya yanda tǝ ndan, kutǝrya ƙǝm na nda yanda tǝ ndan. Na chehweerha a rǝprha fa a mbǝya hangga, tǝ miirha. Əngginiya katǝra sǝsaarha ni ˈwan.” ");
INSERT INTO hwo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amma kwarama. Ƙǝsǝr na nda a ɗǝrha tǝ kun mbed mamngya ɗǝ na ahu ƙǝngya tsahad Yahudaya tsaɗa kun nda, tǝ ƙǝm muwangganda kun ahu porsǝna ɗǝ. Nanda a ɗǝrha tǝ kun a mbed ngwamnaya ɗǝ tǝ kutǝrya ka thlǝmna. Ənɗaniya na fǝrang kwamana kun pǝr ƙǝkafek nun atenna. ");
INSERT INTO hwo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Laɓarɗi na mbǝnggǝn ya tǝtani pǝrghǝnɗa hu ƙǝshiirha ɗǝ heu. ");
INSERT INTO hwo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amma a ƙǝsang nda kun a ɓillaɗun tǝ ˈya nun a thlǝkrha ka a hǝrghanggun fannun wa. Thlǝghaama ǝnɗi ndangna Faara kun kee, ƙǝsǝr mbǝ kunni na a kaala sǝ wa, amma Sǝsǝna tǝ Peɗǝnda ni. ");
INSERT INTO hwo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Na wan maana a fǝr wan man ɓǝlangganda, chiina ƙǝm nǝn a fǝr wanggǝn. Wundakhnaya na nda a thleng chinggindan fa ka a ɓǝlangganda kanda. ");
INSERT INTO hwo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na fiya heu a kar kun ƙǝsǝr ka nggi, amma kala niifa ƙǝrǝsgha ta mii ngwalarha ɗǝ nǝn a hǝrǝkrha.” ");
INSERT INTO hwo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na sayi ɓayi ɓanun naa ‘Ən tsangya na ɓarha ɓa tǝ ndǝkrha hai’ ƙǝt a mbǝrha kamngwa wa. Tǝrgha fingya na a Yahudiya a ɗaarha wumngya sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Niifa na aten ƙǝnna mbǝ tǝra hai kyagha ƙǝnɗǝ ka a ngwagha fa wa.” ");
INSERT INTO hwo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Niifa na a hee a wudɗǝ ndaagha ɗǝnǝn tǝrang kootodghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kawa ma nishya na ahur tǝ fingya na tǝ waaya ƙǝsǝr a faryiniya! ");
INSERT INTO hwo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hwanama Faara a katǝra ɗa hai ahu mbiirha wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ƙǝsǝr na sǝsaarha a naarha sǝ kaan ˈwawanda ǝnaarha, ka ǝnana Faara ƙǝshiirha ta hu sayidɗa ɓa ya. Tǝ ƙǝm mba nda nggǝr ǝna turghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A mbǝnana Faara thleng ɓengginiya wa, mbǝ niifa sǝ na takh tǝ yibrha wa. Amma ƙǝsǝr ka nafiyighǝn na wuwura, ndǝn tsang nǝn ɓenggini hwas. ");
INSERT INTO hwo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“A sayidɗiya a ndon niifa, ‘Kulo Ƙǝrǝsti ya,’ nduwa ‘Kulo ndǝghǝn taarha,’ a kangna thlǝmaarha fa wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ƙǝsǝr na fa nggaɓaya Ƙǝrǝsti sǝ tǝ yi annabiya na a thliirha sǝ ǝna ǝnwuteengya nda ka a sakhɗang ngganda fiya heu tǝ fingya na wuwura yi Faara, a naɗǝ a kya naarha sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nanǝn kee, kwarama ƙǝsǝr ˈwaɗi teena pǝrangɗi ndǝn kun.” ");
INSERT INTO hwo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“A akwasamad sǝsadɗi, “‘Na yanfaara a tsaurha wulghǝn, ndǝree ƙǝm mbǝgha njaara hai wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na wufǝlgaarya a mukrha hai a fǝrakh amshi, ǝngya na mǝmanggǝn a talara na nda a tsǝˈyafa.’” ");
INSERT INTO hwo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“A farɗi na fiya a naa Wan Niifa ɓayi ahu hashbe tǝ sǝsǝmnda tǝ mamnggitghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nǝn a thlǝn fathlǝnggighǝn ɗǝ ɗa nda wumang nafighǝn ɓa wurnǝn ahu ƙǝshiirha heu.” ");
INSERT INTO hwo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Walama tsaharhaha aten ɗǝf shiɓaarha. A naɗun ndǝn a tsǝtsǝtta, sǝnɗun sǝ nduwus fegrha ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ko nanǝn kee, a naɗun a naa ǝngginiya a katǝrarha hai, sǝnɗunsǝ nduwus ɗa ɓa tsau a mii kwatminda. ");
INSERT INTO hwo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Niya pǝrang ƙǝkafek kun, nafiya ƙǝshiid weeriya mba nda a mǝra wa ƙǝl katǝrana ǝnggina hai ya. ");
INSERT INTO hwo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nda talara tǝ hweeɗe na nda ngwalarha hai, amma laɓarna mbǝ tam ngwalarha wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Mbǝ niifa sǝ na a sǝn farɗi nduwa sayidɗi na ǝnggini a katǝrarha hai ya wa, ko fathlǝngya na a talara, nduwa Wanɗi, ƙǝl chinɗi kee ndǝn sǝngga ndǝn. ");
INSERT INTO hwo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kwarama! A sǝnunsǝ sǝnggun ɓad sayidɗa ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nǝghǝn ƙǝla niifa na a wiirha, mal wurighǝnǝn ahar mafayighǝn, kowunni tǝ yighǝn taara fǝrang nǝn, ndanggǝn tǝ ƙǝla kwatkirma ha a shiiɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tsaunǝn kee, a shiiɗun wa ƙǝsǝr sǝnggun farɗi na tǝ wuriɗi a ɓarha ɓa wa, tǝ a figrha, nduwa a manad fǝɗikrha, nduwa ka tǝtad ɗiyarha, nduwa a tsar. ");
INSERT INTO hwo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A ɓaɗa ɓa huhwam ɓa wa wal kun a shiirha wa. ");
INSERT INTO hwo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ənɗi pǝrang ni kun ya, pǝranggi ndǝn kowunni kee, ‘A shiiɗun wa!’ ” ");
INSERT INTO hwo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Takhƙǝn ɓeena sǝri a ǝna wutsǝfayidɗa nda yi mburodi kula mekhna, mamnda firistaya tǝ famalǝmngya ngyakhrha kanda a kaɗa kwaman ƙǝsang nda Yeeso ɓǝɓee ka a ɓǝlangganda. ");
INSERT INTO hwo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amma ndaa nda, “Mbǝ a far wutsǝfayidɗiya wa, naɗǝ fiya har ƙǝm yanda.” ");
INSERT INTO hwo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nana Yeeso a Mbetani a hǝb ǝnnarhami a minda ki niifa na nda aarha Siman na tǝ wanhad termeerha fa, kyagha nuneefa ɓa tǝ ƙǝthlikrha urdi na tǝ wuɗǝɓǝla fa kaan, mbalanggǝn mii ƙǝthlikrǝɗaɗǝ iranggǝn fǝɗedɗi aten Yeeso hai. ");
INSERT INTO hwo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Fingya nanda a hǝb ǝnnarhami a mbǝrha tal tǝ Yeeso sǝbgha hur ndan ɗǝ ndaa nda, “Kama sǝɓang nǝn fǝɗedɗa ɗǝ na ngga kee ya? ");
INSERT INTO hwo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Andam heng ɗaɗǝ nǝn kal wuɗǝɓǝl rapathlaarha yi hurarha tal, fǝrang nggǝnǝn fa yamiiya.” Tǝrgha yanangganda kaan. ");
INSERT INTO hwo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amma ndangga Yeeso kanda, “Malaman lee, kama nun a ɓillaghǝn ka ǝnanǝn ˈya na ngga a nggi? ");
INSERT INTO hwo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na fa yamiya sǝ hangga ahur nun, kala faara nggǝmna hur nun fǝraman kanda. Amma mbǝ kakwanni nun naarha na nggi wa. ");
INSERT INTO hwo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ənaɗǝ ˈya nǝn a mbang nda. ˈWa nǝn iree fǝɗedɗa fa ya ka yi panna. ");
INSERT INTO hwo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Niya pǝrang ƙǝkafek kun, kalla mbǝrha pǝr nda laɓar Faara saaɗǝ ahu ƙǝshidɗiya, ˈya ǝnanǝn na nda a pǝrghǝn ɗǝ ƙǝm, ka a ɗalghǝnda teena.” ");
INSERT INTO hwo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tǝrgha Yahuda Iskaryoti tal ahur kumkap sǝri ɗi, ɗǝgha thlǝmad mamnda firistaya ɗǝ ka a fǝr Yeeso nǝn a kanda. ");
INSERT INTO hwo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tǝkka mamnda firistayini mbǝnda fa sǝk nǝn ˈya ɓangga ɓa nggǝma nda fa a fǝrang wuɗǝɓǝla nda. Ƙǝla sayi nǝn fa tǝ mbǝrha nǝn a fǝrang Yeeso kanda. ");
INSERT INTO hwo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A katǝra far Wutsǝfayidɗi yi Mburodi kula Mekhna, farɗani na nda ǝna sataka tǝ wan kamnda yi Tǝɗaarha. Tsahangga fatsahayighǝn mee, “A yanggi na midwa ɗan nggorha fa ɗǝna hǝb ǝnnadmid wutsǝfayid tǝɗaarha sǝ?” ");
INSERT INTO hwo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tǝrgha thlǝngga Yeeso sǝri ahur fatsahayighǝn ndanggǝn kanda, “Ɗaama hur wupǝri ɗǝ, ɓana niifa wal kun tsǝb tǝ tsuliina ha, mbuwa ma samadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ndaman tǝ wuriɗi kyanǝn sa hai, “Tǝmalǝmnda ni tsakhka mee, ‘Na ƙǝn rongya a yanggi, niya hǝb ǝnnadmid Tǝɗaarha sǝ tǝ fatsahayina?’ ");
INSERT INTO hwo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nǝn a kyaɗang ƙǝnna kun na manggǝn, na tǝ mbǝd tsaukya sǝ hangga. Ngwaman ƙǝm fa a mbǝɗi.” ");
INSERT INTO hwo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wiigha fatsahayini a wupǝri ɗaɗǝ, ɗa nda walghǝn ƙǝla thlǝghang na Yeeso kanda. Ngwa nda fa tǝ ǝnnadmid tǝɗadɗi a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsǝna figrha hai, sǝlgha Yeeso ɓa tǝ kumkap sǝri ɗi. ");
INSERT INTO hwo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsauna nda hai kanda a hǝb ǝnnarhami, ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, tal ahur nun nǝn a fǝr nggi, yanɗi nani a hǝbrha tǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kanda heu sǝbgha hur ndan ɗǝ na nda a ndang nda tǝtal tǝtal, “Mbǝ nggini wa, nduwa nggini wa?” ");
INSERT INTO hwo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ndanggǝn kanda, “A hur nun ni kun na kumkap sǝriɗi ya, yanɗi na harnan tal hu ɗengnda. ");
INSERT INTO hwo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Wan Niifa a wiirha ƙǝla chireethleng nanda hai atenggǝn. Amma ǝn kawa ni a niifɗi fǝrgha ndǝn! A fadghǝn a nggushi nggǝt wa na ndan.” ");
INSERT INTO hwo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na nanda a hǝb ǝnnarhami, tǝrangga Yeeso mburodi sǝ hwan parkad Faara nǝn atenggǝn, kyanggǝn hai fǝranggǝnǝn fatsahayighǝn ɗǝ, ndǝghǝn, “Thlamadghǝn; thlu fanna niya.” ");
INSERT INTO hwo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tǝranggǝn wuhuleu aam inabi sǝ usa Faara nǝn, fǝranggǝnǝn kanda ɗǝ, sangganda. ");
INSERT INTO hwo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ndangga Yeeso kanda, “Farna niya irang nanda ɗǝ ka fiya hang. Fara lǝɗangga ɗǝfmi Faara. ");
INSERT INTO hwo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Niya pǝrang ƙǝkafek kun, mbiya nggǝr sa aam inabi ɓalwa, ƙǝl ahu kutǝryid Faara ndǝn ɓani sa weerindǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngwala nanda aah amshe, kya nda sǝ ɗǝnda wumnda ɗǝfya Dzaitun sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ndangga Yeeso fatsahayighǝn, “Kun heu nun a kar nggi fa, ƙǝsǝr nǝghǝn chichireethlee hai tǝ ndaarha; “ ‘Niya ɗǝk tǝ lafadɗi, na chaukhrayini a weela hai.’ ");
INSERT INTO hwo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma a kwasamadɗi thliini sǝ hu mǝrra, niya ˈwaarha Nggalili ɗǝ ma kun.” ");
INSERT INTO hwo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndaagha Mbiturus, “Ka kar nanda sa fa heu, nggi kam mbi naarha wa.” ");
INSERT INTO hwo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ndangga Yeeso, “Mbiturus, niya puro ƙǝkafek, a fǝɗik weeriya kapa na kilngaara tǝtaarha sǝri, na ngaal sǝndǝna katǝra mahan.” ");
INSERT INTO hwo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma Mbiturus ɗǝgha mbeeɗǝ tǝ ndaarha, “Ko nǝm a mǝra ƙǝm kyab, mbi tam ngaal sǝnduwa wa.” Fingya fatsahaya heu ndaa nda kee ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɗǝnda mbǝrha ɗǝ na nda aarha Nggetsǝmani, ndangga Yeeso fatsahayighǝn, “Tsawama a mbǝɗiya ɗǝni ka hwan Faara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tǝranggǝn Mbiturus, tǝ Yakubu tǝ Yahaya nagha tǝ ɓillaarha tǝ sǝbrha hura kaan. ");
INSERT INTO hwo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ndanggǝn kanda, “Sǝb hurna ɗǝ ƙǝla ni mǝra. Tsawama a mbǝɗiya a shiiɗun wa.” ");
INSERT INTO hwo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nduwusgha mbeeɗǝ, ɓǝrgha hweeɗa hai hwan faara a naɗǝ a ǝnaarha hai a ndǝkka hai tǝ sǝsadɗiya. ");
INSERT INTO hwo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ndagha, “Pǝpa, ǝngya heu nǝghǝn pǝppa a fadwa. A nggǝmna fa tǝree sǝsadɗaɗǝ ya. Mbǝ nggǝmnda hurna wa, amma ˈya nggǝmna hurwa ndǝna mǝmǝl.” ");
INSERT INTO hwo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tǝrgha wudgha thlǝmad fatsahayighǝn ɓa, ɓagha wal kanda a shiirha. Ndanggǝn Mbiturus, “Mbiturus, nun a shiirha? Mbun mbang tsaurha tsǝɓaku a ƙǝlaarha wa? ");
INSERT INTO hwo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A shiiɗun wa, hwanama Faara amanun mukrha hu ƙǝƙǝrra hai. Minnun sǝ ǝnaarha, amma thlu fannun mǝrɗa hai.” ");
INSERT INTO hwo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tǝrgha Yeeso mal kanda ɗǝgha ka hwan Faara ɗǝ, nggǝrghǝn thlǝkrha ƙǝla ˈwanǝn hwanda. ");
INSERT INTO hwo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nggǝrghǝn wutta thlǝmandan ɓa ɓagha wal kanda a shiirha faɗǝn, ƙǝsǝr ngwalang ɓeena fandan. Sǝngwanda ǝnɗi na nda thlǝghang nda wa. ");
INSERT INTO hwo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wud nǝn ɓa yi mahan, ndanggǝn kanda, “Ɓal wun a shiirha tǝ yibrha? Tsǝkɗǝ kee! Ɓad sayidɗa ɓa. Fǝr nda Wan Niifa ahar fa ɗimiya hai. ");
INSERT INTO hwo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Thleema sǝ! Taama wiim! Kulo tǝ fǝrrǝna ɓayi ya!” ");
INSERT INTO hwo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nana Yeeso aten ndikrha kee, ƙǝlagha hai ka Yahuda, tal na ahur fatsahayighǝn kumkap sǝri ɗi kyagha ɓa tǝ fiya hangga a samadghǝn ngwanda fa tǝ thlakh ƙǝlarya tǝ sǝsalya. Thlǝnna mamnda firistaya kanda, tǝ famalǝmngya ngyakhrha tǝ shingya. ");
INSERT INTO hwo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ˈWad Yahuda teena saghang ɗa ndǝn kanda tǝ ndaarha, “Yanɗi ndang ni ˈya tǝ fǝbrha, niifɗa ni; ƙǝsaaman win tǝghǝn ƙǝlaghǝnun ha ngga.” ");
INSERT INTO hwo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ɓana Yahuda thlǝmad Yeeso ɓa aaghǝnǝn, “Mala!” Fǝɓanggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tǝrgha ƙǝsangganda Yeeso, ƙǝsghǝnda ha ngga. ");
INSERT INTO hwo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amma niifa tal ƙǝɗanggǝn thlaukh ƙǝlarghǝn sǝ kyathlanggǝn thlǝmad mafad mamnda firistaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ndangga Yeeso kanda, “Tǝrwun nggi niifa ni na tǝmbǝng, nun ɓaarha ɓa tǝ thlaukh ƙǝlarya tǝ sǝsalya ka a ƙǝseewun wa? ");
INSERT INTO hwo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ƙǝtsar nggi a thlǝmad nun, nggi a tsaharhaha a pǝpal Wuri Faara, ƙǝseewun wa. Amma katǝra nǝn hai kee ka a lǝghǝdgha ˈya ndaana ɗeleewar Faara.” ");
INSERT INTO hwo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tǝrgha fatsahayighǝn kowunni ƙǝl ɗaarha mal Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na wundǝlarha sǝ tal ahur nafiya na a mbu samad Yeeso, mbǝ lukrha sǝ a fadghǝn wa ƙǝl kooto kee ndǝn kaunǝn fa. Ɓana nafini ka ƙǝsang Yeeso ɓa, ");
INSERT INTO hwo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","muwanggǝn kootodɗa ɗǝ na a fadghǝn ɗaagha tawalth. ");
INSERT INTO hwo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɗǝnda tǝ Yeeso a minda ki mamnda firistaya ɗǝ, a mbǝɗani wumna fingya mamngya firistaya sǝ, tǝ shingya, tǝ famalǝmngya ngyakhrha. ");
INSERT INTO hwo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mbuwa Mbiturus samad ndan ɗǝ a samarha inggun ta pǝpal minda ki mamnda firistayina ɗǝ. Tsauka hai a thlǝma fa ƙǝlaya ha nagha a tǝk waarha fa. ");
INSERT INTO hwo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mamnda firistayini tǝ fingya wumngga hai na nda a kaɗa kwamana na a ƙǝsangganda Yeeso tǝ ˈya na ɗimi, tǝna nda ɓǝlang nda, amma wal wanda wa. ");
INSERT INTO hwo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nggaɓangga fingya fa tǝ pathya hangga, amma ɓawa mii ndan ɓa tal wa. ");
INSERT INTO hwo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tǝrgha thliigha fingya sǝ pǝr laɓarya nda yi nggaɓaarha ndaa nda, ");
INSERT INTO hwo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sǝk ɗan fadghǝn ndǝghǝn, ‘Niya chang Ƙǝn Faara hai tǝnna fiya, tǝngga pak ahu ɓeena mahan, mbǝ niifa ni a tǝnggǝn wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko nanǝn kee tǝrwa path ndan kwamana wa. ");
INSERT INTO hwo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tǝrgha mamnda firistayini thliigha sǝ a mbed fiya tsahang mee nǝn Yeeso, “Mba mbang nggǝra sǝ wa? Ma na ndaarha aten pathɗi thlǝkna nafini aten wa ya?” ");
INSERT INTO hwo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amma nggasgha Yeeso tip, nggǝrwa sǝ wa. Nggǝrgha mamnda firisyini tsahang mee, “Nduwa sani Ƙǝrǝsti, Wan Faara amshi tǝ Parka?” ");
INSERT INTO hwo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ndangga Yeeso, “Nggini. Nun a naa Wan Niifa tsau a yisǝmad Faara Amshi na tǝ mamnggirha ha heu, nǝghǝn ɓayi ahu hashmbe a talara hai.” ");
INSERT INTO hwo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tǝrgha mamnda firistayini djaranggǝn luwudghǝn ɗǝ, ndǝghǝn, “Palth ma nǝm nggǝr kaɗaarha faɗǝn? ");
INSERT INTO hwo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sǝkɗǝm ndǝn hai a miighǝn laɓar sar Faara nda nǝn. Ma ndanun?” Kanda heu ndaa nda, a ɓǝlangganda. ");
INSERT INTO hwo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tǝrgha fingya katǝrang ngganda chahang yakhrha Yeeso fa; ƙǝnangganda yidghǝn mbighǝnda, ndang ngganda, “Kulo! Wun mbiigha sa hu sayidɗi ya, annabi?” Fa ƙǝla ƙǝn Faara ha ɗǝnda mbeeɗǝ tǝ ɗǝkƙǝn. ");
INSERT INTO hwo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nana Mbiturus a pǝpal mindǝɗi a tǝk waarha fa, kyagha wee nuwun ɓa tal ahur mafaya mamnda firistayini. ");
INSERT INTO hwo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nanǝn Mbiturus a tǝk waarha fa ƙǝlanggǝn ɗǝ ngga. Ndanggǝn, “Sa na tal ahur nafini na a mbu samad Yeeso tǝ Nadzarat ɗi.” ");
INSERT INTO hwo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amma ngaalghǝnǝn. Ndanggǝn, “Sǝngwi ǝnɗi na a thlǝkrha ya wa,” thliigha sǝ ɗǝgha kwatkirma ɗǝ. Tǝrgha tǝtaagha ɗiyarha. ");
INSERT INTO hwo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nggǝrna mafadɗi naghǝn, ndanggǝn nafini na ƙǝƙǝt a mbǝɗi, “Niifɗiya nǝghǝn tal ahur ndan.” ");
INSERT INTO hwo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nggǝrghǝn ngaalghǝn faɗǝn. Tsǝna nda tsǝɓaku, nafini na ƙǝƙǝt a mbǝɗi ndang ngganda Mbiturus, “Sa mbǝ ngaala sǝ wa na tal ahur ndan, ƙǝsǝr tǝ Nggalilad ni sa.” ");
INSERT INTO hwo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Katǝranggǝn ang shiurha tenggǝn fa ɓa ndǝghǝn, “Aahɗi Faara, sǝngwi niifɗi nun a thlǝkrha ya wa.” ");
INSERT INTO hwo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tǝrgha tǝtaagha ɗiyarha yi sǝri. Ɗalgha Mbiturus teena hai tǝ laɓar Yeeso ndang nǝn, “Kapa na kidngaara tǝtaarha yi sǝri na ngaal sǝndǝna katǝra mahan.” Kwanggǝn tenggǝn hai nagha a tǝrha. ");
INSERT INTO hwo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A tsar ƙǝrǝt wumngga mamngya firistaya hai tǝ shingya tǝ famalǝmngya ngyakhrha, tǝ fingya kognaya ƙǝnangganda path ndan hai. Ƙǝnangganda Yeeso ɗǝnda tǝghǝn a mbed Mbilatus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tsahangga Mbilatus mee, “Sani kutǝr Yahudaya wa?” Nggǝmangga Yeeso, “Ƙǝla thlǝkna na.” ");
INSERT INTO hwo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tǝrgha mamnda firisɗi nagha a ɗahang pathya fa aten ǝngya hangga. ");
INSERT INTO hwo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nggǝrgha Mbilatus tsahang mee, “Mba nggǝra sǝ ndeye wa? Sǝkkwa ǝnɗi nana nda a thlǝworha fa wa!” ");
INSERT INTO hwo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma Yeeso kalwa sǝ wa, fǝrang ǝnwulteena nǝn Mbilatus. ");
INSERT INTO hwo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kala wutsǝfayid tǝɗaarha yakh Mbilatus kal niifa hai tal muwang nanda hu porsǝna ɗǝ yi hwanna fiya. ");
INSERT INTO hwo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na niifa sǝ thlǝmnggǝnni Mbarabas muwang nanda hu porsǝna ɗǝ ka tǝmbǝnggidghǝn ˈwanǝn ɓǝl niifa. ");
INSERT INTO hwo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wumna fiya thlǝmad Mbilatus ɓa, hwanggǝnda a kalang niifa nǝn kanda hai na hu porsǝna ƙǝla nǝn tǝ ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nggǝmanggǝn kanda ndǝghǝn, “Na minnun sǝ a kalang kutǝr Yahudaya ni kun hai wa?” ");
INSERT INTO hwo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ƙǝsǝr sǝnɗasǝ ka sǝrǝkkid mamnda firistaya ni ɓang nanda Yeeso ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amma Mamngya firistaya shighangganda fiya fa a kalgha Mbilatus Mbarabas hai a meghed Yeeso. ");
INSERT INTO hwo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ndangga Mbilatus kanda, “Amma a kalangɗi Mbarabas kun hai, niya ǝnaarha ƙǝn tǝ niifɗi nun aarha kutǝr Yahudaya?” ");
INSERT INTO hwo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tǝrangganda urad ndan sǝ, “Tawaman ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ndangga Mbilatus kanda, “Kama nda, ɗimid ma ǝna nǝn?” Amma tǝrangga fiya urad ndan sǝ kaan, “Tawaman ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nanǝn na mid Mbilatus sǝ a tǝkka fiya mbǝnda fa, kalang Mbarabas nǝn kanda hai. Tǝrgha fǝr Yeeso nǝn a tsaɗaghǝn nda, a fǝranggǝnǝn sodja Romaya tawangganda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sodja yini ɗǝnda tǝ Yeeso a mbǝd tar ndan ɗǝ, aah fingya sodjaya nda ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kalang kaɓad kutǝryirha nda fa na yiɓa, faɗang ngganda ndaha na nzǝnzang panggǝn nda atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tǝrgha tǝrangganda urad ndan sǝ na nda a ndangˈya, “Alvari! Kutǝr Yahudaya!” ");
INSERT INTO hwo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na nda a ɗǝkƙǝn tǝ sǝsaala a tenggǝn, tǝ ƙǝm na nda a chahang yakhrha fa. Ɓǝra nda hai tǝ waɗeeyi ndan wai na nda a fǝrang mamnggirha yi waa farha. ");
INSERT INTO hwo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngwalang na nda waaghǝn, ƙǝɗangganda kaɓad kutǝryidɗa hai na a fadghǝn kalang yighǝn nda. Tǝrgha ɗǝnda tǝghǝn ƙǝshaaɗǝ ƙǝsǝr a ɗaa nda tawang ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na nanda a wiirha tǝ Yeeso ƙǝma nda tǝ niifa na nda aarha Siman tǝ Sayirarha chin nda Alizanda tǝ Rufus, ɓaghǝn ɓa a Sarin. Ngyaɓang tǝr kaɗid ɗa nda fa. ");
INSERT INTO hwo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓa nda tǝ Yeeso a mbǝrha ɓa na nda aarha Nggolggota ndǝna mbǝd ɓalhwar teena. ");
INSERT INTO hwo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Fǝrang aam inabi nda kukurɗa tǝ mur, amma karɗǝ saarha fa. ");
INSERT INTO hwo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tǝrgha tawangganda Yeeso ɗǝ ndǝghangganda karidghǝn hai a pathlang ndan, Əna chacha nda aten lukkighǝn tǝ kurmi na niifa a waala. ");
INSERT INTO hwo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tawangganda ɗǝ tǝ tsar fa. ");
INSERT INTO hwo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A man tenggǝn chireethleng ngganda ǝnɗa hai ɗahang nanda fa, “KUTƏR YAHUDAYA.” ");
INSERT INTO hwo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tawang ngganda fathlee kwamangya ɗǝ sǝri, tal a yikawadghǝn, tal ƙǝm a yisǝmadghǝn. Fingya chirethya yi kaar na nda tǝ mbǝdghǝn 28 tǝ ndaagha: “Lǝghǝtta palthɗa ni tǝ ndaagha, ‘Saghang nda ahur fa ɗimiya hai.’ ” ");
INSERT INTO hwo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Fiya na a mbǝraɗǝ na nda a thlǝghang pathya fa yi sar farha na nda a tsangˈya tendan fa na nda a waaghǝn, “Sa ndaagha na fǝlang Ƙǝn Faara hai na manggǝn tǝnangga hu ɓeena mahan, ");
INSERT INTO hwo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hǝrghang fadwa lee tǝraa na hai aten kaɗidɗiya!” ");
INSERT INTO hwo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nǝghǝn kee ƙǝm, mamngya firistaya tǝ famalǝmngya ngyakhrha na nda a waaghǝn, “Hǝrghanggǝn fingya, amma mbǝ mbang hǝrghang fadghǝn wa! ");
INSERT INTO hwo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ngwa na Ƙǝrǝsti ɗa nǝm kutǝr Isǝrela, tǝrgha hai a ten kaɗidɗi naghǝnǝm tǝnǝm fǝrang ƙǝkafek!” Ko fathlee kwamanggini tawang nanda kanda ɗǝ tǝghǝn na nda a thlǝghang pathya fa mbuwa mbǝnggǝn. ");
INSERT INTO hwo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na yan faara a sǝrǝkrha wula nggǝlanggǝn chehwedɗi heu ta figrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tǝrgha a fiyidɗi tǝrangga Yeeso Uradghǝn sǝ, “Eloi, Eloi, lama sabaktani?” Ndaarha ni, “Faarna, Faarna, kama nda malna nggi?” ");
INSERT INTO hwo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Fingya na ƙǝƙǝt a mbǝɗi sǝkkwa ndan ngga wa tamngganda ndaarha nǝghǝn a aah annabi Ilya. ");
INSERT INTO hwo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tal ahur ndan ɗagha ɗǝ tǝtǝnanggǝn soso tǝ aam inabi na chichakh panggǝn hu sǝsaala fǝranggǝnǝn sǝ ka a saagha. Ndaagha niifa, “Malaman, tama ƙǝlaghǝnǝm ha tǝ ɗǝna Ilya tǝrang hai.” ");
INSERT INTO hwo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tǝrgha nggǝrgha Yeeso tǝrang uradghǝn sǝ, a mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Shishamarɗi na ahu Ƙǝn Faara na manggǝn djaragha hai sǝri a talara hai ta hweeɗe hai. ");
INSERT INTO hwo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mamnda Sodja Romaya na ƙǝƙǝt a mbed Yeeso fa naɗǝ kwamanɗi mǝrnǝn ndǝghǝn, “Ƙǝkafek, Wan Faarani ya!” ");
INSERT INTO hwo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na fingya nishya sǝ a mbǝɗi na ƙǝƙǝt inggun a ƙǝlang ˈya na a katǝrarha hai. A hur ndan na Mairamu Makdaliya sǝ, Mairamu man Yakubu tǝ fewunda tǝ Yisufu, tǝ Salomi. ");
INSERT INTO hwo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ka a Nggalili ɓa takkwana nishyina ndǝn ɓa na nda a ɗang sǝ tǝ tarya, na fingya nishya sǝ hangga a samadghǝn ka Urshalima ɓa. ");
INSERT INTO hwo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Katǝragha ǝnɗa hai ya a far ɗemnda yi far yiɓǝd Yahudaya, nanǝn tsǝ figrha hai. ");
INSERT INTO hwo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Na ka niifasǝ thlǝmnggǝnni Yisufu tǝ Aramatiya, nǝghǝn ahur mamngya na ƙǝnang pathla hai, Nǝghǝn a ƙǝla kutǝryid Faara fa. Tǝrǝm ngwa wa, ɗǝgha thlǝmad Mbilatus ɗǝ hwan mǝrra Yeeso nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fǝrwa Mbilatus ƙǝkafek mǝr Yeeso wa, aah mamnda Sodja Romaya nǝn ɓa tsahang mee nǝn. ");
INSERT INTO hwo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pǝrangga mamnda sodja ɗa ndǝn, ndangga Mbilatus Yisufu a ɗǝgha tǝrang mǝrɗi. ");
INSERT INTO hwo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hiigha Yisufu kaɓad pa mǝrra ɓa pǝpet, tǝranggǝn fad Yeeso ahu kaɗidɗi, faɗanggǝn Yeeso tǝ kaɓadɗi ɗǝgha ɗǝ panggǝn ahu kwaarha raa nanda hu feera. Kwatǝranggǝn feera ɓa na manggǝn nggǝlanggǝn kwadɗa sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mairamu Magdaliya tǝ Mairamu man Yisǝfu na mbǝɗa nda pang nanda Yeeso sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kyana far yiɓǝd Yahudayina ɗǝ, Mairamu Magdaliya tǝ Mairamu man Yakubu tǝ Salomi hii urdi nda na mindan sǝ ɗa nda ƙǝmang fad Yeeso tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A tsar far katǝra thlǝtta ɓeena, yanfaara a kyarha ɓa ƙǝs kwamana nda aten kwadɗa ɗǝ ");
INSERT INTO hwo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","tsahang mee nda ndan ha, “Wunni a kwatǝrang ferɗi ƙǝm ɗǝ na a mii kwadɗi?” ");
INSERT INTO hwo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amma tǝrang nanda tendan sǝ ƙǝla nda hai ferɗi na manggǝn kwatǝrang nda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kyana nda ahur kwadɗa hai ƙǝla nda hai wundǝlarha tǝ lukrha fa pǝpet tsaua man yisǝma, tǝr ma nda. ");
INSERT INTO hwo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ndanggǝn kanda, “A fidɗun hai wa, nun a kaɗa Yeeso tǝ Nadzarat tawang nanda ɗǝ. Thliiɗa sǝ ɓalwa mbǝɗiya wa. Kǝlaman mbǝɗi hunang nanda sa hai ya. ");
INSERT INTO hwo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amma ɗamaɗǝ ɗun pǝranggǝn fatsahayighǝn tǝ Mbiturus tǝ ndaarha, ‘Nǝn a ˈwaarha Nggalili ɗǝ ma kun. Ɗǝnun naghǝn a mbǝɗi ƙǝla pǝrang nǝn kun.’” ");
INSERT INTO hwo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Thliigha nishyini tǝ ɗaarha aten kwadɗi nagha fad ndan a rǝprha fa ka hǝreenga. Kalang ngwanda niifa sǝ wa, ƙǝsǝr ƙǝs hǝreenga kanda. ");
INSERT INTO hwo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Thliina Yeeso sǝ ahu mǝrra a far katǝra thlǝtta ɓeena ˈwaghǝn kyad fadghǝn a Mairamu Magdaliya nuɗi kyang nǝn ǝnkaheeya sǝ mǝd a fadghǝn. ");
INSERT INTO hwo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɗǝgha ɗǝ pǝranggǝn nafini na nanda tǝghǝn kaar na nanda tǝ sǝbrha hura kanda a tǝrha. ");
INSERT INTO hwo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amma sǝkna nda na Yeeso tǝ yibrha, na ɗa ndǝn, fǝr wanda ƙǝkafek wa. ");
INSERT INTO hwo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Akwasamadghǝn kyakhrangga Yeeso fadghǝn hai kyad fadghǝnǝn a fatsahayighǝn sǝri na nanda a kwaman ɗǝrha mbǝrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wuɗa nda ɗa nda pǝranggǝn shayindan, amma fǝr wanda ƙǝkafek tǝ path ndan wa. ");
INSERT INTO hwo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsǝɓaku kyadgha Yeeso fadghǝn a kumkap tal ɗi a sayidɗi na nanda a hǝb ǝnnarhami. Tǝrgha yananggǝn kanda ƙǝsǝr ka yamid fǝrƙǝkafekkid ndan tǝ kakrakkin tendan fǝrang ngwanda ƙǝkafek nafini nagha ndǝn a kwasamadɗi thliinǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndanggǝn kanda, “Ɗaama hu ƙǝshiirha ɗǝ ɗun pǝr laɓarɗi na mbǝnggǝn ya a fiya heu. ");
INSERT INTO hwo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kala niifa fǝrgha ƙǝkafek ǝnang mbaptisǝma nda, nǝn a hǝrǝkrha, amma niifa fǝrwa wa ƙǝkafek na nda a ngwang kumarha sǝ. ");
INSERT INTO hwo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Fingya fǝrgha ƙǝkafek na nda a wal sǝsǝmnda ǝna ǝnwuteengya hangga. Hu thlǝmna na nda a kyang ǝnkaheeya sǝ, tǝ ƙǝm na nda a ndikrha tǝ fingya miiya pak. ");
INSERT INTO hwo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na nda a ƙǝsang huthlingya tǝ haryindan, ko saa nanda warkami mbǝ ǝnang ˈya kanda wa. Na nda ɗǝfang haara haaya teena, ƙǝna nda.” ");
INSERT INTO hwo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A kwasamadɗi ngwalana Yeeso ndikrha tǝ kanda, tǝrang ngganda talara ɗǝ tsauka a yisǝmad Faara. ");
INSERT INTO hwo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tǝrgha fatsahayighǝn ɗǝnda mbeeɗǝ tǝ pǝr laɓar Faara, Chinǝm nǝghǝn tǝ kanda ha nagha. Nǝn naarha kyaɗang ƙǝkafekkid laɓarghǝn kanda tǝ ǝnwuteengya nanda a ǝnaarha.");
INSERT INTO hwo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fiya hangga chirethgha aten ǝnggini ǝnana Faara a pathlang nǝm. ");
INSERT INTO hwo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ƙǝla malang nandan ƙǝm hai ahar nafini ˈwagha naghǝn tǝ yindan kal nanda mii laɓar Faara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tsaunǝn kee, paɓa Tiyafulus, nggi tǝ altenna raɗi mu ǝnggina ha ya tǝ sammayirha ka a katǝradghǝn, ƙǝlaɗi hai nǝghǝn mǝmǝl a fanna a chirethleu ƙǝni hai tǝtal-tǝtal. ");
INSERT INTO hwo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na minna sǝ a sǝn ƙǝkafekkid ǝnggina na tsaho nanda ha. ");
INSERT INTO hwo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A thlakh mbǝd kutǝryid Hirdus a Yahudiya, na firis sǝ thlǝmnggǝnni Dzakariya, nǝghǝn ahu kiwad Firistaya a wuri ki Abidja. Nukkun ƙǝm Alisaɓatu turya Haruna ni. ");
INSERT INTO hwo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kanda kyab ka nafiya ni kanda a mbed Faara, na nda a laf ngyakhrha Faara na heu. ");
INSERT INTO hwo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amma mbu wan nggindan sǝ wa, ƙǝsǝr Alisaɓatu kwarengani, tǝ ƙǝm kanda kyab suhur nda. ");
INSERT INTO hwo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Fara sǝmǝn far tar Dzakariya yi firistayirha a mbed Faara, ");
INSERT INTO hwo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","wurna ndan ƙǝla ndana ǝntin firistaya, a kyagha hu Ƙǝn Faara ɗǝ na a Urshalima nji urdi nǝn na sǝdghǝn mbǝnggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sǝlna sayid nji urdi ɗa ɓa, fiya heu wumnda ɓa, kanda a ƙǝshi a hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kula sǝndǝghǝn sǝ na tǝ thlǝnda Faara nǝn ƙǝt a yi sǝmad mbǝɗi nanda nji urdi sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nana Dzakariya ndǝn, hargha ƙǝfadghǝn, tǝrǝmngga. ");
INSERT INTO hwo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amma ndangga tǝ thlǝnda Faara, “A tǝrǝmna wa Dzakariya; sǝk Faara hwanduwa. Nuwa Alisaɓatu nǝn a nggǝɗo wee hǝshin sǝ, ɗǝfang thlǝma na Yahaya. ");
INSERT INTO hwo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nǝn a tsaurha ǝn wutsǝfayirha kaan a fadwa, fiya hangga ƙǝm na nda ǝna wutsǝfayirha ƙǝsǝr ka nggǝttǝghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nǝn a tsaurha niifa na manggǝn a mbed Chinǝm. Mbǝgha sa aam inabi ko mbaala wa. Ka far nggǝttǝghǝn hai nǝn a lǝghǝtta tǝ Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Fiya hangga a Isǝreela nǝn a wuɗang kanda a thlǝmad Chinǝm farndan ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nǝn a ˈwarha a mbed Chinǝm ɗǝ, hu sǝsǝna tǝ sǝsǝmnda ƙǝla annabi Iliya. Nǝn a ɓang tsawud ɗǝɗemnggirha ɓa a pathlang chingya tǝ wanggi ndan. Nǝn a kyakhrang fiya ɓa fingya na tǝ yamid fǝr mamnggirha tsawa nda nafiya natǝ nggayirha fa, nǝn tansang fiya a Chinǝm.” ");
INSERT INTO hwo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tsahangga Dzakariya mee tǝ thlǝnda Faara, “Kǝƙǝn ni sǝnda sǝ ǝnɗi thlǝkna ya nǝn tsaurha ƙǝkafek? Kulo nggi, suhurɗi nuuna ƙǝm kee.” ");
INSERT INTO hwo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nggǝmangga tǝ thlǝnda Faara, “Nggini Djibirilla na ƙǝt a mbed Faara. Thlǝnna nda nggi ɓa, a ɓi puro laɓarɗi na mbǝnggǝn ya. ");
INSERT INTO hwo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nanǝn ya na naarha tip, mba nggǝr kalasǝ wa ƙǝl a farɗi katǝranǝn hai, ƙǝsǝr sa karna fǝrƙǝkafek fa tǝ pathna, ɓagha tsaurha ƙǝkafek a sǝl ɓenggǝn ɓa.” ");
INSERT INTO hwo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nanǝn ya, fiya a ƙǝla Dzakariya fa a kyagha ɓa, na nda a numarha tǝ mani tsǝnǝn tsǝɓaku kee ahu ƙǝn hwan Faarɗi. ");
INSERT INTO hwo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kyanǝn ɓa, mbangwa kalang kanda sǝ wa. Walangganda tǝ ndaarha kyaɗang Faara ˈya ahu ƙǝn hwan Faarɗi, ƙǝsǝr nǝn naarha kyad haara a kanda, mbangwa kalasǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ngwalang nǝn ɓen targhǝn, wudgha wureɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mǝngwaha wa nukkun Alisaɓatu ɗǝfgha hur. Tsau fayighǝn nǝn a wuri mbǝ kyarha ƙǝshaaɗǝ wa yi ndǝre tuf. ");
INSERT INTO hwo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ndagha Alisaɓatu, “Faara ǝneegha ǝnɗiya! A hu ɓengginiya ndǝn haɗang ni fa, keeɗa sǝ hu shilee a mbed fiya.” ");
INSERT INTO hwo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nana Alisaɓatu tǝ ndǝre mikki, thlǝngga Faara tǝ thlǝndǝghǝn Djibirilla ahu tala ɗǝ a Nggalili, nanda aarha Nadzarat. ");
INSERT INTO hwo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A ɗǝgha thlǝmad wutararha ɗǝ na thlǝmnggǝn Mairamu, ngwanna niifa na nda aarha Yisufu, turya Ndauda. ");
INSERT INTO hwo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ɗǝgha tǝ thlǝndǝɗi thlǝmadghǝn ɗǝ ndanggǝn, “Niya ndo ˈya, sa na tǝ parka teena! Chinǝm nǝghǝn tǝ sa ha.” ");
INSERT INTO hwo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sǝkna Mairamu nda ǝnɗi, ɓillagha kaan, nzǝmnggǝnǝn tǝ tur nda ǝn mani ya. ");
INSERT INTO hwo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Amma ndangga tǝ thlǝnɗǝɗi, “A tǝrǝmna wa, Mairamu, walna nggayirha a mbed Faara. ");
INSERT INTO hwo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na a ɗǝfrha hur, nggǝt wee hǝshin na, ɗǝfang thlǝma na Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nǝn a tsaurha manda niifa, nanda aaghǝn, Wan Faara na tǝ sǝsǝmnda ha heu. Na Chinǝm Faara a fǝrang tsǝnnggam kutǝryid chichidghǝn Ndauda. ");
INSERT INTO hwo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nǝn tsau kutǝryirha aten nafiya Isǝreela pa kwanɗǝ, kutǝryidghǝn mbǝ mii ngwaladghǝn sǝ wa.” 1:33 2 Samaila 7:12; 13; 16; Ishaya:haya 9:7 1:33, Ndaniyel 2:44; 7:27; Mika 4:7. ");
INSERT INTO hwo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsahangga Mairamu mee tǝ thlǝnda Faara, “Kǝƙǝn na ǝnɗi katǝrarha hai ya nggi kula sǝn hǝshnefa?” ");
INSERT INTO hwo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nggǝmangga tǝ thlǝnda Faara, “Sǝsǝna tǝ Peɗǝnda nǝn a tǝraa tenwa hai, sǝsǝmnda Faara Amshi nǝn a nggǝlorha. Tsaunǝn kee, Wanɗi tǝ Peɗǝnda na a nggǝtta ya, nǝm aaghǝn tǝpeɗǝnda Wan Faara. ");
INSERT INTO hwo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kwana Alisaɓatu hurfidwa, nda nanda kwarenga ni, tǝ suhuryidghǝn nǝn a nggǝt wee. Nanǝnya nǝghǝn ahur tǝ ndǝre mikki. ");
INSERT INTO hwo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ƙǝsǝr mbǝ ˈyasǝ na pǝɗaghǝn a fad Faara wa.” ");
INSERT INTO hwo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ndagha Mairamu, “Yoo, nggi mafad Faara ni, a tsauka ƙǝla tǝ thlǝkna na.” Tǝrgha tǝ thlǝnda Faara wiigha. ");
INSERT INTO hwo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A sayidɗi, Mairamu ngwagha fa thliigha ƙǝkar ɗǝgha hu tala ɗǝ na ahu wumngya chehweed Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sǝlnǝn ɗǝ kyagha minda ki Dzakariya hai, ndang ˈya nǝn Alisaɓatu. ");
INSERT INTO hwo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sǝkna Alisaɓatu nda ǝnɗi ki Mairamu, wanɗi na ahurghǝn tsǝˈya nǝn fa. Alisaɓatu ƙǝm lǝghǝdgha tǝ Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tǝrangga Alisaɓatu uradghǝn sǝ kaan, ndanggǝn Mairamu, “Tǝ parkani sa ahur nishya, tǝ ƙǝm tǝ parkani wanɗi ɓana nggǝtta! ");
INSERT INTO hwo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mani na nggayirha ɓarha tenna ɓa kee, na man China ɓarha thlǝmadna ɓa? ");
INSERT INTO hwo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hǝrǝm ni sǝk nda ǝnwa, wanɗi na a hurna tsǝˈya nǝn fa kaan ka wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tǝ parkani sa fǝrgha ƙǝkafek aten ˈya ndona Chinǝm nǝn tsaurha ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ndagha Mairamu, “Hurna nǝghǝn a fal Faara ");
INSERT INTO hwo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","yiɓǝnna nǝghǝn a ǝna wutsǝfayirha a Faara tǝ Hǝrǝkrǝna, ");
INSERT INTO hwo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ƙǝsǝr ɗalɗǝ nggi in, mafadghǝn mbuwa a mii ˈya. Nanǝnya fiya na heu yi weeriya tǝ na ɓayi nanda ndaarha tǝ parkani nggi, ");
INSERT INTO hwo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ƙǝsǝr ka ǝngya na mǝmanggǝn ǝneena Faara Amshi, thlǝmnggǝnni tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na fiya haɗang fa na a tǝrǝmnggǝn, Ka chichiiya na ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ənaɗǝ ǝngya na mǝmanggǝn tǝ harghǝn; welengɗǝ fingya ɗǝ na a manang alten ndan hu numan ndan. ");
INSERT INTO hwo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tǝrangɗǝ kutǝrya hai hu tsǝnggam nggindan, amma mananggǝn fingya mbuwa a mii ˈya.” ");
INSERT INTO hwo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","“Nggalang ɗǝ fingya na a mirha tǝ ǝngya na nggǝngga, amma rǝghanggǝn fa ƙǝnaya ɗǝ kula ˈya a harndan. ");
INSERT INTO hwo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɗangɗǝ mafadghǝn sǝ Isǝreela, tǝ ɗal teena hai haɗang nda ");
INSERT INTO hwo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ibrahim fa tǝ chichiyighǝn pa kwanɗǝ ƙǝla ndang nǝn chingginǝm na kaar.” ");
INSERT INTO hwo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mairamu tsauɗǝ a thlǝmad Alisaɓatu yi ndǝre mahan a wudgha wureɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lǝghǝdna ɓen nggǝtta Alisaɓatu, nggǝt wee hǝshin nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tulayighǝn tǝ nggǝɗayighǝn sǝk nanda kyaɗang Faara nggayirha, ɗangganda sǝ tǝ wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lǝghǝnna wanɗi ɓeena uvaɗa, ɓa nda ka thlee muwa ɓa, tǝ ƙǝm na mindansǝ a ɗǝfang thlǝm chin nda Dzakariya. ");
INSERT INTO hwo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tǝrgha kalgha mansǝ ndǝghǝn, “Awo! Nǝm aaghǝn Yahaya.” ");
INSERT INTO hwo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ndang ngganda, “Mbǝ niifa sǝ ahur nggǝɗiyinun na tǝ thlǝmɗiya wa.” ");
INSERT INTO hwo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tǝrgha tsahang mee nda chin wanɗi tǝ haara a pǝr thlǝm wanɗa nǝn nanda a ɗǝfang nda. ");
INSERT INTO hwo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsakh ǝn chirethla nǝn, chirethlenggǝn hai, “Thlǝmnggǝnni Yahaya.” Fiya na heu na ǝnwulteena nda. ");
INSERT INTO hwo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A mbǝɗi kee ingga mighǝn hai tǝ ƙǝm sheneuƙǝn kwasgha hai, katǝranggǝn ndikrha hai nagha a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tulayighǝn na heu nanda ǝnwulteena, tǝ ƙǝm tǝrmanda, ƙǝsǝr ka ǝnɗi katǝragha hai. Kala mbǝrha heu na a wumngya chehweed Yahudaya nagha fiya a tsǝ laɓara atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kala niifa sǝkka laɓarɗi ƙǝl wulna teena, tǝ tsakh mee nǝn, “Ɓana wanɗi tsaurha ƙǝƙǝn ya?” Ƙǝsǝr na Faara tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chin na Dzakariya lǝghǝdgha tǝ Sǝsǝna tǝ Peɗǝnda katǝranggǝn thlǝk pathla hai kyaɗang na Faara tǝ ndaarha, ");
INSERT INTO hwo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tama fal Chinǝm nǝm, Faara yi Isǝreela, ƙǝsǝr ɓanǝn ɓa ka ɓagha pǝl nafiyighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Fǝrɗǝ tǝ ngyakhrha na a hǝrghang nda ƙǝm a wuri ki mafadghǝn Ndauda. ");
INSERT INTO hwo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kǝla ˈwanǝn thlǝkrha ƙǝtǝm a mii annabiyighǝn tǝ peɗǝnda ");
INSERT INTO hwo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","hǝrǝkrha ahar fa tsangginǝm na heu. ");
INSERT INTO hwo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Əngginiya ǝnanǝn ndǝn a kyaɗang nggayirha nǝn chingginǝm tǝ ɗal teena hai hu ɗǝf mighǝn tǝ peɗǝnda ǝna nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɗǝf mighǝn ǝna nǝn a chichin nǝm Ibrahim, ");
INSERT INTO hwo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a pǝl ƙǝm nǝm ahar fa tsangginǝm, tǝnǝm ɗǝfang shilee teena kula hǝreenga, ");
INSERT INTO hwo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","anam tsǝtsaɓaɗǝ tǝ nggayirha a mbed Faara ahu tsawun nǝm hu ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Sa ƙǝm waana, nanda aah sa annabi yi Faara Amshi, ƙǝsǝr na ˈwarha mbeeɗǝ ma Chinǝm a tangsang kwamana na ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","a fǝrang huteena nǝn nafiyighǝn aten kwaman hǝrǝkrha ahu chakhrha ɗimiyid ndan ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ƙǝsǝr ka haɗang nǝm Faara fa, kukwaryid hǝrǝkrha nǝn a njaara tennǝm hai a talara hai. ");
INSERT INTO hwo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nǝn a njaara aten fingya hai na ahu wula, tǝ fa tsaukya na a mishim mǝra, nǝn a laf ƙǝm ahu kwaman ɗǝɗemnggirha.” ");
INSERT INTO hwo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yahaya mangga sǝ, nagha kanglang hu farha tǝ huteena, tsauƙǝn a kaheerha ƙǝl farɗi kyanǝn pǝpal ɓa ka a pǝr laɓarghǝnǝn a nafiya Isǝreela. ");
INSERT INTO hwo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A hu ɓengginiya Kaisar Anggusta kalɗǝ mee a thlǝɗangganda fiya na hu kutǝryid Roma. ");
INSERT INTO hwo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndǝna katǝra thlǝtta fiya ǝnanda, a sayidɗi tsauna Karniwus ngwamna a Suriya. ");
INSERT INTO hwo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Fiya na heu wunda hu talyi ndan ɗǝ ka a thlǝɗangganda kanda. ");
INSERT INTO hwo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yisufu ndǝghǝnggima malɗǝ tal Nadzarat na hur Nggalili ɗǝgha hu tal Mbaitalami ɗǝ na hur Yahudiya, tala nggǝnda kutǝra Ndauda sǝ. Yisufu ɗǝɗǝ mbǝɗaɗǝ, ƙǝsǝr nggǝɗit Ndauda ni. ");
INSERT INTO hwo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wiighǝn tǝ Mairamu ngwannǝn ka a thlǝɗangganda kanda kyab, ahu sayidɗi ndǝghǝn ahur. ");
INSERT INTO hwo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na nanda a Mbaitalami ɗi lǝghǝdgha ɓen nggǝttǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nggǝt wan ˈwadghǝn nǝn hǝshin, lǝlǝɓanggǝn tǝ pam ƙǝnɗǝghǝn, hunanggǝn ahu nggam maɓiya hai, ƙǝsǝr walwanda ƙǝnna a min rongya wa. ");
INSERT INTO hwo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A ƙǝsǝr talɗi na fa lafya sǝ, na nda mǝnda a pǝpal, na nda a ƙǝla maɓiyindan ha a fǝɗigrha. ");
INSERT INTO hwo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kula sǝndǝndan sǝ, tǝ thlǝnda Faara ɓagha thlǝmandan ɓa, tǝrgha mamnggit Faara yangga hai, tǝrmanda kaan. ");
INSERT INTO hwo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tǝrgha, wan thlǝndǝɗi ndanggǝn kanda, “A tǝrǝm ɗun wa ɓa ni ɓa tǝ laɓara na mbǝnggǝn yanɗi na fiya heu ana pǝpetyid hura kaan. ");
INSERT INTO hwo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A weeriya ahur tal Ndauda nggǝɗang nda tǝ Hǝrǝkrha kun hai, Ƙǝrǝsti Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ənɗiya ndǝna a kyaɗang ǝnsǝnda kun, ɗunun wal wufarwee lǝlǝɓang nda tǝ pam ƙǝndǝghǝn, hunang nda hai ahu nggama.” ");
INSERT INTO hwo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kula sǝndǝndan sǝ, tǝrgha Fathlǝngya Faara hangga na a amshi, ɓanda hai, ɓa nda wal yanɗi ˈwagha hai, kanda heu a fal Faara nanda a ndaarha, ");
INSERT INTO hwo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mamnggit Faara na talara, tǝ na hu ƙǝshiirha ngwa tsauka ɗǝɗemnggirha a thlǝma nafiya na Faara a tǝk mbǝndǝ ndan fa.” ");
INSERT INTO hwo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malna Fathlǝnggini kanda, wuɗa nda talara ɗǝ, ndangga fa lafyini ndan “Tama Mbaitalami ɗǝ ɗǝm na ǝnɗi katǝragha hai tǝ pǝrangna Chinǝm ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Thliinda ƙǝkar ɗanda wal Mairamu tǝ Yisufu, na wanɗa nda kath ahu nggam maɓiya. ");
INSERT INTO hwo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nana fa lafyini wanɗi, pǝr laɓar ɗa nda thlǝghangna tǝ Thlǝnda Faara kanda. ");
INSERT INTO hwo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sǝkna fiya laɓar ɗi, kowunni ƙǝl ƙǝs mee nanda ǝnwulteena ka ǝnɗi ndana fa lafyini. ");
INSERT INTO hwo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mairamu ƙǝsɗǝ ǝnggina haya ahurghǝn, nagha a numarha atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fa lafyini wuɗa nda, na nda a aah amshe yi fal Faara ka ǝnɗi sǝknanda, tǝ na nanda, nǝghǝn ƙǝla thlǝkna tǝ Thlǝnda Faara. ");
INSERT INTO hwo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ənana wanɗi ɓeena uvaɗa, thleng muwa nda, ƙǝmɗa ɗǝfang thlǝma nda Yeeso, thlǝmɗi ɗǝfna tǝ Thlǝnda Faara kapa na nda ɗǝfghǝn hur. ");
INSERT INTO hwo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ndukna farɗa ɓa, Mairamu tǝ Yisufu ǝnanda ǝnɗi thlǝkna ngyakhrha Musa tǝ ndaarha, a tsaɓangganda altendan ɗǝ, tǝrang ngganda Yeeso, ɗǝnda tǝghǝn Urshelima ɗǝ ƙǝsǝr a fǝrghǝnda a Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kǝla nanǝn chichrethlee hai ahu ngyakhrha Faara, “Kala wan ˈwarha nggǝn nanda, nanda fǝranggǝn Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na sataka nda ƙǝla thlǝkna ngyakhrha Chinǝm tǝ ndaarha, “Titiliukya sǝri ko wan kataprakkya sǝri ndǝna nda thleerha.” ");
INSERT INTO hwo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A farɗi, na niifa sǝ nǝghǝn tǝ tsaurha a Urshelima, nanda aaghǝn Simiyon. Ka niifa ni, nǝn naarha ɗǝfang shilee Faara teena. Kǝmɗa nǝghǝn a ƙǝla farɗi nanda a hǝrghang nda Isǝreela. Nǝghǝn tǝ Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sǝsǝna tǝ Peɗǝnda ndanggǝn niifɗi, mba a mǝra wa ƙǝl farɗi nana Ƙǝrǝsti tǝ yidwa. ");
INSERT INTO hwo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nagha Sǝsǝna tǝ Peɗǝnda a shikƙǝn, kyagha Ƙǝn Faara ɗǝ, mǝmǝl tǝ sayidɗi ɓa na fa nggǝtya Yeeso ɓa tǝghǝn a Ƙǝn Faara ɓa, ƙǝla ndana hai ngyakhrha a ǝna nda. ");
INSERT INTO hwo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon thlǝ wanɗa nǝn fal Faara nǝn, ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Na nǝn ya, China, kalu mafadwa hai wiigha hu ɗǝɗemnggirha, ƙǝla tǝ thlǝkna na,” ");
INSERT INTO hwo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","“Ƙǝsǝr yinna naɗǝ hǝrǝkrǝwa, ");
INSERT INTO hwo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","hǝrǝkrha ǝna na a mbed fiya heu, ");
INSERT INTO hwo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kukwaryirha kyadna a fiya mbuwa Yahudaya, tǝ mamnggirha a nafiwa Isǝreelaya.” ");
INSERT INTO hwo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chin wanɗi tǝ man ƙǝsangganda mii ndan kanda ana ǝnwulteena tǝ ǝnɗi thlǝkna Simiyon aten wanɗi. ");
INSERT INTO hwo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyon ɗǝfanɗǝ parka kanda teena, ndanggǝn Mairamu man wanɗi “Wur Faara wanɗiya ƙǝsǝr a tsaukwa fǝlla fingya hai, tǝ thlid fingya sǝ hangga ahur Isǝreela, nǝn tsaurha ǝnsakrha a thlǝma Faara mbuwa na mid fiya sǝ hangga. ");
INSERT INTO hwo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nanǝnke, ǝn ǝnandan na ahu tendan nǝn kyarha pǝpal ɓa. Ənɗiya nǝn hatta fa kaan, ƙǝla kuthla thlaukh ƙǝlara.” ");
INSERT INTO hwo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na suhurra annabi sǝ nuwun, thlǝmnggǝn ni Hanatu, wan Famuwel turya Ashiru. Tsauɗǝ a chimarha yi hurarha mǝd kee. ");
INSERT INTO hwo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tǝrgha chimadghǝn mǝrgha. Nanǝn ya, huradghǝn kumnggit uvaɗa kap faɗa. Mbǝ malang Ƙǝn Faara wa, nǝn naarha manang thlǝm Faara nda fǝɗigrha tǝ yan fara ahu hwanda tǝ kar aama. ");
INSERT INTO hwo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mǝmǝlla sayidɗiya, kyagha ɓa nagha a usa Faara, ƙǝmɗa thlǝkɗǝ pathla aten wanɗiya a nafiya na a ƙǝla farɗi na Faara a fǝrang alteena Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yisufu tǝ Mairamu ngwalang nanda ˈya ndana ngyakhrha Chinǝm, wuɗa nda tal ndan ɗǝ Nadzarat na a Nggalili. ");
INSERT INTO hwo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Man wanɗi, nǝghǝn tǝ kanglanggirha, lǝlǝgɗa tǝ sǝnda, nggayid Faara ƙǝm nǝghǝn tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kafad hurarha fa, fa nggǝtya Yeeso nanda ɗǝrha Urshelima ɗǝ ƙǝsǝr ka wutsǝfayid kyarhaɓa ahu sǝsaarha. ");
INSERT INTO hwo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lǝkɗangna Yeeso hurarha Kum kap sǝri tǝ nggǝtta hai, ɗenda hu wutsǝfayirha ɗǝ ƙǝla tǝ sǝsǝnna nda sa hai. ");
INSERT INTO hwo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngwalana wutsǝfayidɗi, ƙǝs kwaman wutta nda wure ɗǝ. Tǝrgha Yeeso ishgha hai a samarha a Urshelima, kula sǝnda chin sǝ tǝ man. ");
INSERT INTO hwo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Na nda a ndaarha asǝmha nǝghǝn ahur fiya, ƙǝs wiirha nda yi paara tal. Katǝrang ngganda kaɗaghǝn hai ahur shayindan tǝ ƙǝm pashiyi ndan, ");
INSERT INTO hwo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","nawa ndan wa. Nanǝnke, wuɗa nda Urshelima ɗǝ, ƙǝsǝr a kaɗaghǝnda a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A far ɓeena yi mahan, ɗanda walghǝn tsau ahu Ƙǝn Faara a thlǝmad famalǝmngya, ndǝghǝn a ka thlǝmarha hai, nagha ƙǝm a tsahang mee kanda ha. ");
INSERT INTO hwo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fiya na heu a mbǝɗi nanda a kang thlǝmarha fa, kanda a ƙǝs mee, wulanggǝn kanda tǝ tur sǝndǝghǝn tǝ nggǝmnda nǝn a nggǝmang kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chin tǝ man wulang teena kanda na nandan a mbǝɗi. Ndangga man, “Waana mani ǝnangna kan kee? Nggi tǝ tsu tsǝ fannan chichakh kaan, nawanan sa.” ");
INSERT INTO hwo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nggǝmanggǝn kanda tǝ ndaarha, “Kama nun kaɗa nggi? Sunggunsǝ kamɗǝ a tsawi a wuri ki Pǝpa wa?” ");
INSERT INTO hwo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sǝngwanda numadghǝn tǝ pathɗiya wa. ");
INSERT INTO hwo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Thliigha mbu saman ndan nǝn, wuɗa nda Nadzarat ɗǝ heu. Nǝn naarha a na fa nggǝtyighǝn hai, man ƙǝm, ƙǝs ǝngginanǝn haya ahurghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeeso ƙǝl chikrha tǝ ndǝndǝlyirha tǝ tsǝrha, hu pǝmnggǝn pǝpet a mbed Faara tǝ fiya. ");
INSERT INTO hwo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ahu hurarha kumkap tuf yi kutǝryid Kaisar Tǝmbariyani; Mbuntus Mbilatus ndǝna ngwamna Yahudiya, Hirdus ndǝna kutǝr Nggalili, wanman na Filibus ndǝna kutǝr Ituriya tǝ Tarakunitas, Lisaniyas ndǝna kutǝr Ambiliya. ");
INSERT INTO hwo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nda Hanana tǝ Kayafa ndǝna Mamngya Firistaya. A faryini ndikka Faara tǝ Yahaya wan Dzakariya a hee. ");
INSERT INTO hwo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tǝrgha Yahaya wenggǝn chehweed yina hai na a mii kufad Djodan ndǝghǝn a thlǝk laɓar Faara a fiya tǝ ndaarha, a malangganda ɗimiyindan ka a fanangganda kanda tǝna Faara chahang ɗimiyindan kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kǝla nanǝn chichirethlee hai ahu ɗeleewar annabi Ishaya tǝ ndaarha, “Urarha a aah farha a kaheerha tǝ ndaarha, ‘Taksaman kwamana Chinǝm sǝ, katǝraman pǝpǝnang nda kwamangya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Njighaman suhwadya heu, fǝlaman mbǝya ɗǝ na ɗangkam, ɗangkam tǝ wumngya. Pǝpǝnaman kwamangya ɗǝ na ƙǝƙǝɓa, ƙǝƙǝɓa tsawa nda ndip, kwamangya na kukuchang nanda ngga. ");
INSERT INTO hwo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Fiya na heu nanda a na hǝrǝkrha Faara!’” ");
INSERT INTO hwo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kǝsǝrke, nǝghǝn a ndang nda fiya na ɓaarha ɓa ka a fananggǝn kanda, “Kun huthlingya! Wun ƙǝsgha thlǝmannun ƙǝsǝr ka sǝbrha hur Faara na ɓayi? ");
INSERT INTO hwo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nama ˈya kyadgha ndaarha malangɗun ɗimiyinnun. A numaɗun ahur nun ndon Ibrahim ndǝna Chinun wa. Niya ndangnda kun Faara nǝn mbang ǝnang wundakhnaya Ibrahim sǝ tǝ feryini ya. ");
INSERT INTO hwo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ˈWanda teena pangnda wurra a kul ɗǝfrha, kala ɗǝfrha mbuwa nggǝtta nanda kyathlang nda ɗǝ muwangganda ahu waarha ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tsahangga fiya mee ha tǝ ndaarha, “Ma nan ǝnaarha mbiya?” ");
INSERT INTO hwo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nggǝmanggǝn tǝ ndaarha, “Niifa na tǝ lukrha sǝri tǝranggǝn niifa ha mbuwana yighǝnsǝ, niifa na tǝ ǝnnarhami ha, nagha kee ndǝghǝn nggima.” ");
INSERT INTO hwo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Fa thlǝ tsamngya ƙǝm ɓa nda ɓa na a fananggǝn kanda, tsahang mee nda, “Mala, ma nan ǝnaarha?” ");
INSERT INTO hwo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ndanggǝn kanda, “A thlǝɗun ˈya kalgha yanɗamu tǝ thlǝghang nanda kun wa.” ");
INSERT INTO hwo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sodjaya ƙǝm tsahang mee nda ha, “Kanggiwu ma nan ǝnaarha?” Ndanggǝn kanda, “A ngyaɓangɗun fiya a fǝrang wuɗǝɓǝla nda kun wa. A nggaɓaɗun kanda ƙǝsǝr a fǝrang ˈya nda kun wa. Usama Faara tǝ ˈya na nda a teng nda kun.” ");
INSERT INTO hwo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nana fiya a ƙǝla ɓad Ƙǝrǝsti fa ɓa, tǝrgha fiya na heu kanda a numarha ahur ndan tǝ ndaarha, ko Yahaya ndǝna Ƙǝrǝsti ɗi. ");
INSERT INTO hwo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ndangga Yahaya kanda, na heu, “Niya fanang nda kun tǝ aama. Amma niifa sǝ na ɓayi na tǝ sǝsǝmnda fa kalgha nggi mu, tsǝkki na a kwasanggi sahad pahamggǝn hai wa, ndǝghǝnggi ɓanǝn fanang nda kun tǝ Sǝsǝna tǝ Peɗǝnda tǝ waarha. ");
INSERT INTO hwo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nǝghǝn tǝ ɗeng pǝra ha, nǝn a pǝrang ɗiɗiirha ɗǝ ngwanggǝn wan hwalidghǝn ahu ɓirukkun hai. Nǝn a njang nda ɗiɗidghǝn ɗǝ tǝ Waarha mbuwa mǝra hai.” ");
INSERT INTO hwo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tǝ yiyi thlamarha hangga, Yahaya thlǝkɗǝ laɓar Faara na ngga a fiya. ");
INSERT INTO hwo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yahaya yanang ɗǝ Hirdus, ƙǝsǝr Hirdus kahang ɗǝ Hirudiya nu wanman, tǝ ƙǝm ǝnaɗǝ ǝngya mbuwa ngga. ");
INSERT INTO hwo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","A kwasamadghen Hirdus nggǝrɗǝ sǝɓang nda ɗǝ tǝ ngyakhrha fǝrnǝn a kanda heu. A ƙǝsangganda Yahaya changganda ƙǝnɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A kwasamadɗi fanang nda fiya, Yeeso ndǝghǝn nggima fanangganda. Tǝrgha nanǝn a hwan Faara, frakh amshi inggaɗǝ, ");
INSERT INTO hwo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Sǝsǝna tǝ Peɗǝnda tǝrgha atenggen hai ƙǝla titiliurha, sǝk urarha nda a talara hai tǝ ndaarha, “Sani na waana tǝtali nggǝmni, tǝkɗi mbǝnduwa fa kaan.” ");
INSERT INTO hwo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A farɗi katǝrangna Yeeso targhǝn hai yi tsaharhaha, nǝghǝn a kaɗa hurarha kumnggit mahan ahu ƙǝshiirha. Tǝrgha fiya ndǝn tǝ ndaarha wan Yisufuni, na wan Heli, ");
INSERT INTO hwo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wan Mattaat, Mattaat wan Lawi, Lawi wan Malki, Malki wan Yanna, Yanna wan Yisufu, ");
INSERT INTO hwo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yisufu wan Mattaatiya, Mattaatiya wan Amos, Amos wan Nahum, Nahum wan Asaliya, Asaliya wan Nanjaya, ");
INSERT INTO hwo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nanjaya wan Maˈata, Maˈata wan Mattaatiya, Mattaatiya wan Shimeya, Shimeya wan Njosek, Njosek wan Yahuda, ");
INSERT INTO hwo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuda wan Yowanan, Yowanan wan Refaya, Refaya wan Dzarubabel, Dzarubabel wan Sheyaltiyel, Sheyaltiyel wan Niri, ");
INSERT INTO hwo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri wan Malki, Malki wan Addi, Addi wan Kosama, Kosama wan Almadama, Almadama wan Er, ");
INSERT INTO hwo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wan Djoshuwa, Djoshuwa wan Eliyeser, Eliyeser wan Yorim, Yorim wan Mattaat, Mattaat wan Lawi, ");
INSERT INTO hwo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi wan Simiyon, Simiyon wan Yahuda, Yahuda wan Yisufu, Yisufu wan Yonana, Yonana wan Eliyakim, ");
INSERT INTO hwo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim wan Malaya, Malaya wan Mainana, Mainana wan Mattaata, Mattaata wan Natan, Natan wan Ndauda, ");
INSERT INTO hwo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndauda wan Njessi, Njessi wan Obida, Obida wan Mbuwasa, Mbuwasa wan Salmon, Salmon wan Nashon, ");
INSERT INTO hwo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon wan Amminadab, Amminadab wan Aram, Aram wan Hesruna, Hesruna wan Feresa, Feresa wan Yahuda, ");
INSERT INTO hwo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda wan Yakubu, Yakubu wan Ishaku, Ishaku wan Ibrahim, Ibrahim wan Tera, Tera wan Nahor, ");
INSERT INTO hwo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor wan Serug, Serug wan Reyu, Reyu wan Feleg, Feleg wan Eber, Eber wan Shela, ");
INSERT INTO hwo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela wan Kenan, Kenan wan Arfakshad, Arfakshad wan Shem, Shem wan Nuhu, Nuhu wan Lamek, ");
INSERT INTO hwo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wan Metusela, Metusela wan Enok, Enok wan Yared, Yared wan Mahalalel, Mahalalel wan Kenan, ");
INSERT INTO hwo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wan Enosh, Enosh wan Shitu, Shitu wan Adamu, Adamu ƙǝm wan Faara. ");
INSERT INTO hwo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeeso lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda wud nǝn ɓa a kufad Urdun, nagha Sǝsǝna a shikƙǝn a kaheerha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A mbǝɗi ƙǝƙǝrangga sheetan yi ɓeena kumnggit faɗa. Akwasamadghǝn ƙǝsgha mirha ndǝn, ƙǝsǝr ǝnawa ˈya mii wa. ");
INSERT INTO hwo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ndangga sheetan, “Ana Wan Faara ni sa tsawang ferɗiya ka mburodi.” ");
INSERT INTO hwo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nggǝmangga Yeeso, “Nǝghǝn chichireethlee hai ahu ɗeleewar Faara mbǝ tǝ ǝnnarhami kee na niifa ƙǝrasǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tǝrgha sheetan ɗǝgha tǝghǝn a mbǝrha ɗǝ na ɗangkam kaan, kyaɗang kutǝryid ƙǝshiirha nǝn ahu shibrha yirha. ");
INSERT INTO hwo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ndangga sheetan, “Sa niya furo sǝsǝmnda kutǝryid ɗiya tǝ mamnggitghǝn, ƙǝsǝr nggi fǝreena ndan, a nggǝmɗi ni fǝranggǝn niifa nggǝmna hurna. ");
INSERT INTO hwo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na heu niya furoƙǝn a ɗǝfenna shilee teena.” ");
INSERT INTO hwo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nggǝmangga Yeeso, “Nǝghǝn chichireethlee hai tǝ ndaarha, “‘ɗǝfang shilee Faarwa teena, ndǝghǝn katenggǝn.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tǝrgha sheetan ɗǝgha tǝ Yeeso a Urshelima ɗǝ, tǝranggǝn talakh ten Ƙǝn Faara sǝ ndanggǝn, “Ana Wan Faara ni sa, puru hweeɗa hai. ");
INSERT INTO hwo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ƙǝsǝr nǝghǝn chichireethlee hai tǝ ndaarha, ‘Nǝn fǝrang sǝsǝmnda fathlǝnggighǝn a laf sa nda, ƙǝla sa nda ha. ");
INSERT INTO hwo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tǝ ƙǝmɗaarha, nanda a nggawo sǝ tǝ haryindan, ƙǝsǝr naɗǝ ɗǝghang sarwa feera fa.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ndangga Yeeso, “Nǝghǝn chichireethlee hai, ‘A ƙǝƙǝrangna Chinǝm Faarwa wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Akwasamadɗi ngwalangna sheetan ƙǝƙǝrang nda Yeeso, ndekka hai tǝghǝn ˈwan. ");
INSERT INTO hwo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeeso wudɗǝ a Nggalili ɗǝ lǝlǝgɗa tǝ sǝsǝmnda Sǝsǝna tǝ Peɗǝnda, laɓarghen welɗǝ hu talya ɗǝ na hu chehwedɗi. ");
INSERT INTO hwo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tsahaɗaha ahu Ƙǝn Faara hangga ko wuni falɗa ndǝn. ");
INSERT INTO hwo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ɗǝgha Nadzarat ɗǝ mbǝɗi mannǝnsǝ, kyagha Ƙǝn Faara ɗǝ a far yiɓǝd Yahudaya ƙǝla sǝsǝnnǝn sa hai. Thliigha sǝ nǝn a karatarha, ");
INSERT INTO hwo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","fǝrang ɗeleewar annabi Ishaya nda. Inanggǝn ɗeleewar ɗa hai, wal mbǝrha nǝn chireethleng nanda hai tǝ ndaarha, ");
INSERT INTO hwo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sǝsǝn Chinǝm nǝghǝn tǝ nggi ha, ƙǝsǝr wurɗǝ nggi, na a ɓang laɓar Faara ni fa yamiya ɓa. Na a kalmii kalla nafiya ni ƙǝnangna ɗimiyirha kanda hai. A inanggi yid kwamaya ɗǝ. A kal fiya ni hai njithlang nanda kanda hai. ");
INSERT INTO hwo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tǝ ƙǝm, a thlǝghang ndaarha ni fiya na heu, ɓad ɓeena ɓa na Chinǝm a hǝrghang nafiyighǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngwalang nǝn karataarha, nggǝlanggǝn ɗeleewarɗi fǝranggǝnǝn niifɗa ɗǝ na a ƙǝla ƙǝnɗa ha tsaukwa hai. Fiya heu na a ƙǝnɗi irang yirha nda fa, ");
INSERT INTO hwo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","katǝranggǝn ndangnda kanda, “Aweeriya laɓar ɗiya lǝghǝdɗǝ ahu thlǝman nun hai.” ");
INSERT INTO hwo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kanda heu na a mbǝɗi tǝk nda mbǝndǝghǝn fa, kanda a na ǝnwulteena tǝ laɓarya na mbǝnggǝn na a kyarhaɓa a miighǝn, na nda a ndaarha, “Ndeye, mbǝ wan Yisufuni ya wa?” ");
INSERT INTO hwo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ndangga Yeeso kanda, “Sǝnɗisǝ nun thlǝye tur karapu ɗafa ya, ‘tǝ purha ƙǝnang fadwa’ non a ndeerha ‘ǝno ǝnɗi tǝ sǝknan ǝnanna a Kafarnahum ahu talɗi kyawa ya lee.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nggǝrghǝn ndang kanda, “Niya thlǝghang ƙǝkafek kun, mbǝ annabi sǝ na nda thlǝghǝn fa ahu talghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Keema thlǝmarha fa, nǝghǝn ƙǝkafek na nishya sǝ mǝrna chimayi ndan hangga a Isǝreela athlakh mbǝd annabi lliya, ɓa waana ˈyaara hurarha mahan tǝ ndǝre mikki. Kyagha miirha hu chehwedɗa hai kaan. ");
INSERT INTO hwo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko nanǝn kee, thlǝn ngwanda Iliya a thlǝmad ko tal ɗǝ ahur ndan wa, thlǝngga ndan a thlǝmad nuneefa ɗǝ mǝrna chimadghǝn a Nzarifat na a chehweed Sidon. ");
INSERT INTO hwo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Athlakh mbǝd annabi Ilesha ƙǝm, na fa termeeya sǝ hangga a Isǝreela. Mbusǝ ko tǝtal ƙǝnang nanda wa, ƙǝl Naˈaman tǝ Suriyarha katenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sǝk nanda laɓarɗi kee, fiya heu na a Ƙǝn Faara sǝbgha hur ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Thlii nda sǝ kyang ngganda Yeeso sǝ ma hur talɗi, ɗǝnda tǝghǝn ten ferɗa ɗǝ tǝnna nda talɗa sǝ. Mindan sǝ a muwang ngganda hweeɗe hai. ");
INSERT INTO hwo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amma kyagha tǝ pathlang ndan wii fayighǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tǝrgha wiigha Kafarnahum ɗǝ, ahu tala ɗǝ na a chehweed Nggalili, nagha a tsahang kanda ha a far yiɓǝd Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tsahadghǝn ha a ǝnang ǝnwulteena kanda, ƙǝsǝr laɓarghǝn nǝghǝn tǝ (sǝsǝmnda) ngyakhrha. ");
INSERT INTO hwo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ahu ƙǝn hwan Faarɗi na niifa sǝ na tǝ ǝnkaheerha fa. Tǝranggǝn uradghǝn sǝ kaan ndaagha, ");
INSERT INTO hwo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iyau! Miwa tǝ kan Yeeso tǝ Nadzarat? Ɓa na ɓa ka a rǝk kanna wa? Sǝnɗi sa, sani (tǝ Peɗǝnda) na Tsǝtsaɓaɗǝ Wan Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yanangga Yeeso ǝnkaheedɗi ndanggǝn “Nggasu hai kyosǝ ahur niifɗiya.” Tǝrgha tǝrangga ǝnkahedɗi niifɗa sǝ muwanggǝn hweeɗe hai a mbendan, ambǝra ndǝkka hai tǝghǝn malanggǝn niifɗi kula wal wundǝrha fa. ");
INSERT INTO hwo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nafini na heu ƙǝsangga ǝnwulteena kanda na nda a ndangnda ndan “Tur mani kee? Tǝ kanglanggirha, tǝ sǝsǝmnda niifɗiya ndanggǝn ǝnkaheeya kyanda sǝ, pa kya nda sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ənɗi ǝnana Yeeso ya, kanda a tsǝ laɓarghǝn ko a yanggi ni ahu chehwedɗi. ");
INSERT INTO hwo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A kwasamadɗi kyana Yeeso hai a Ƙǝn Faara, kyagha wuri ki Siman hai. Thlaɓǝr Siman tǝ nuwunda tǝ ɓeerha farha, hwan nggǝnda a ɗanggǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ishgha Yeeso atenggen, yananggǝn wan hadɗi a ndǝkka hai tǝghǝn, ndǝkka wanhadɗa hai tǝghǝn. Thliigha sǝ kaɗang ǝnnarhami nǝn kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsǝna figrha hai ɓagha fiya ɓa tǝ pashiyi ndan na tǝ wanhaya ɗǝɗamǝn-ɗǝɗamǝn, ɗǝfang haara nǝn kanda teena, ƙǝnanggǝn kanda heu. ");
INSERT INTO hwo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ənkaheeya ƙǝm, kyanda sǝ a fad fiya hangga, kanda ahuhwaarha tǝ ndaarha, “Sa Wan Faara ni,” njaranggǝn kanda ɗǝ, ˈyaɗang ndikrha nǝn kanda fa ƙǝsǝr sǝnda sǝ ndǝghǝn ni Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɗalthna mbǝrha hai, ɗǝgha Yeeso a mbǝrha ɗǝ mbuwana fiya sǝ. Nagha fiya a kaɗaghen, walang ngganda, hwan nggǝnda na a tsaukwa tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amma ndangga Yeeso kanda, “Kamɗǝ aɗi tǝ Laɓarɗi na Mbǝnggǝn ya, yi Kutǝryid Faara ahu talya ɗǝ pak, ƙǝsǝr nden thlǝn nanda nggi ɓa kamanggǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tǝrgha ɗǝgha mbeeɗǝ tǝ thlǝk laɓarghǝn ahu ƙǝngya hwan Faara a chehweed Yahudiya. ");
INSERT INTO hwo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na farɗa sǝ Yeeso ƙǝt a mii Wuri Aam Nggalili. Nduwusgha fiya thlǝmadghen ɓa hangga kanda ˈyaɓang mbǝrhafa ka a sǝk laɓar Faara nda. ");
INSERT INTO hwo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yeeso na kombuwalya nǝn sǝri a mii wuri aamɗi. Fa kombuwalyini kyanda sǝ kanda a tsaɓang panggamnggindan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tǝrgha ahur tal hai, yi Siman, ndanggǝn a puwanggǝn kombuwalghǝn ahu aamɗa hai ngguchit ma ƙǝƙǝshɓangnda. Tsauka ahurghǝn nagha a tsahang fiya ha. ");
INSERT INTO hwo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ngwalanǝn ndikrha, ndanggǝn Siman, “Puwan kombuwal ɗi a mbǝd kuɗimnda ɗǝ, muwanggun panggam ɗa hai, ƙǝs tǝna nun.” ");
INSERT INTO hwo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nggǝmangga Siman, “Paɓa, ka a fǝɗigrha kan a mukrha, mbǝ ˈya sǝ walnan wa. Amma ndana kee, niya muwang panggam ɗi sa hai.” ");
INSERT INTO hwo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Muwangganda panggamɗi kyandan sa hai, ƙǝs tǝna nda hangga, nagha panggamɗi a thluwussa. ");
INSERT INTO hwo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tǝrgha aah pashiyi ndan nda ɓa na ahu tahad kombuwalɗi a ɓa nda ɗang kanda sǝ. Lǝɗang ngganda kombuwalya sǝri tǝ tǝna, nagha kombuwal yini a timnda hai ka haarha. ");
INSERT INTO hwo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nana Siman Mbiturus ǝnɗi katǝragha hai ɓǝrgha hai a mbed Yeeso ndagha, “Mala, kalu kwamanna hai, ƙǝsǝr tǝ ɗimiyirha ni nggi!” ");
INSERT INTO hwo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ƙǝsǝr ndǝghǝn tǝ nafiya na nanda heu, wulang teena kanda ka tǝnɗi ƙǝs nanda. ");
INSERT INTO hwo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nanǝn kee, nda Yakubu tǝ Yahaya wangya Dzabadi, pashiya tar Siman Mbiturus. Ndangga Yeeso Siman Mbiturus, “Ma tǝrǝmna wa; nanǝn ya fiya na a ƙǝsa ɓa mbǝ tǝna wa” ");
INSERT INTO hwo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kahangganda kombuwal yindan ƙǝƙǝsh ɓangnda ɓa, malangganda ˈya na heu mbu samad Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Fara sǝmǝn na Yeeso ahu tala a chehweed Nggalili, na niifa sǝ na wanhad termeerha a sǝsangnda. Nanǝn Yeeso, ɓagha ɓa, ɓǝrgha hai a mbedghǝn, hwanggǝn nǝn ndanggǝn, “China, a nggǝmna fa, tsaɓeeɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tǝrgha Yeeso fǝr harghǝnǝn ɗǝ, tsuwarghǝnǝn fa ndanggǝn, “Nggǝmɗi fa a tsaɓanaɗǝ. Tsaɓuɗǝ!” A mbǝɗi kee, termedɗi ndǝkka hai tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ƙǝsgha Yeeso thlǝmadghǝn, ndanggǝn, “A pǝrangnan niifa wa ɗuwaɗǝ kyaɗang fadwa firis na sa nǝn. A ǝno sataka tǝna fiya sǝndasǝ tsabnaɗǝ ƙǝla tǝ ndana Musa.” ");
INSERT INTO hwo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nanǝn kee, laɓar Yeeso ƙǝl chik ɗǝrha mbeeɗǝ, fiya hangga aten ɓarha ɓa ƙǝsǝr a kang thlǝmanda fa tǝ ƙǝmɗa a wal ƙǝnda nda ahu wanhayindan. ");
INSERT INTO hwo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amma, Yeeso nǝn naarha ɗǝrha mbǝrha ɗǝ katenggǝn mbuwana fiyasǝ nagha a hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Farɗa sǝ Yeeso a tsaharhaha, fingya Farisaya tǝ fa sǝngya ngyakhrha tsǝtsau a mbǝɗi. Ɓagha nda ɓa ahu talya Nggalili tǝ Yahudiya tǝ ƙǝm ahu tal Urshelima. Sǝsǝmnda Chinǝm nǝn teghǝn ha ƙǝsǝr a ƙǝnanggǝn nafiya na tǝ wan haya fa. ");
INSERT INTO hwo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kanda sǝ, ɓagha nafiya ɓa tǝ niifa mǝrna fadghǝn hai, kath aten ɗǝnggǝla. Na nda a kaɗa kwamana a ɗǝnda tǝghǝn wure hai a hunang ngganda hai a mbed Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Walwa nda kwamana wa ka hangnda fiya. Kǝla nda hai mbǝ kwamana sǝ wa, thlǝɓangganda ten ƙǝnna ɗǝ fǝrghǝn nda hai tǝ ɗǝngǝlɗi hunangganda hai a maɗufud fiya a mbed Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nana Yeeso fǝrƙǝkafǝkkin ndan, ndanggǝn hadɗi na kath, “Pashinna chohonda ɗimiyidwa ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fasǝngya ngyakhrha tǝ Farisaya kanda a numarha tǝ ndaarha, “Wunniya na thlǝk laɓar sarfadɗiya a Faara? Ai Faara katenggǝn ndǝna chakh ɗimiyirha.” ");
INSERT INTO hwo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Walangna Yeeso ǝnɗi nanda a numarha, ndanggǝn kanda, “Kama nda nun ǝna tur numadɗiya? ");
INSERT INTO hwo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yanggi ni pǝpa, ‘Ndarha chohonda ɗimiyid wa ɗǝ wa,’ nduwa ‘Thliusǝ wiu wa?’ ");
INSERT INTO hwo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amma na minna sǝ a sǝnunsǝ tǝ ndaarha Wan Niifa nǝghǝn tǝ ngyahad chakh ɗimiyirha ahu ƙǝshidɗiya.” Ndanggǝn tǝ mǝrra fadɗi, “Ndoyi thliusǝ, tǝrang ɗǝnggǝlwa wiu wure ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A mbǝɗi kee, thliigha niifɗa sǝ a yid fiya, tǝranggǝn ɗǝnggǝlghǝn sǝ nǝn hunaarha sǝ ƙǝtǝm wiigha wure ɗǝ nagha a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kanda na heu ɗǝf haara nda mii, ka ǝnwulteena nana nda na nda a fal Faara. Lǝlǝgɗa tǝ tǝrǝmnda na nda a ndaarha, “A weeriya na ɗan ǝnwulteena!” ");
INSERT INTO hwo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A kwasamadɗi kyana Yeeso sǝ, na niifa nǝn tǝ thlǝ tsamnda thlǝmnggǝnni Lawi tsau a thlǝ tsamnda ndangga Yeeso, “Mbuwu samanna,” ");
INSERT INTO hwo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi malanggǝn ˈya na heu, thliigha sǝ mbusamadghǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tǝrgha Lawi ngwagha fa ǝna wutsǝfayirha nǝn manggǝn a wuri keeghǝn. Yeeso ndǝn na ronga na manggǝn. Fa thlǝ tsamngya hangga tǝ fingya nafiya kanda a hǝb ǝnnarhami tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amma Farisaya tǝ Fasǝngya ngyakhrha, katǝrang ngganda huhurumnda hai ndang ngganda fatsahaya Yeeso, “Kama na nun a hǝbrha tǝ sarha tǝ fa thlǝ tsamngya tǝ fa ɗimiya?” ");
INSERT INTO hwo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nggǝmangga Yeeso kanda, “Nafiya na ƙǝkanglang mba nda kaɗa tǝpuurha wa, ƙǝl haaya. ");
INSERT INTO hwo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɓayi ɓa ka fiya na ǝna ˈya ngga wa, ƙǝl fa ɗimiya, a malangganda ɗimiyindan.” ");
INSERT INTO hwo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Fingya nafiya sǝ ndang ngganda Yeeso, “Fa fatsahaya Yahaya tǝ Mbaptisǝma, nanda kar aama ƙǝtsar tǝ hwan Faara, na Farisaya kee. Fǝnayiwa kanda hǝbrha tǝ sarha parang.” ");
INSERT INTO hwo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nggǝmangga Yeeso kanda tǝ ndaarha, “Nun mbang ngyaɓang kar aama pashiya wutsamnda fa ndǝghǝn ɓalɗǝ a thlǝmandan wa? ");
INSERT INTO hwo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Na farghǝn ɓayi na nda a tǝrang mal kanda nǝn. A farɗi ndǝnanda a kar aama.” ");
INSERT INTO hwo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tǝrgha Yeeso fǝrang karapu nǝn kanda tǝ ndaarha, “Mbǝ niifa sǝ na njar kukwasharraɓa a fat lukrha na ngga mbuhwang nggǝnǝn kukwasharra fa wa. A ǝna ɗǝ kee, ƙǝl njarang nǝn luwudɗa ɗǝ na ngga, ƙǝsǝr mbuhudɗi mbuhwang nǝn suhurra luwudɗa fa tǝ yanɗi na ngga mbǝ kamang wa. ");
INSERT INTO hwo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tǝ ƙǝm mbǝ niifa sǝ na irang weerǝnda aam inabi ahu suhurra samsami hai wa. A ǝna ɗǝ kee, na weerǝnda aam inabi ɗi ɗathlang nda samsami ɗa ɗǝ. Nǝn iraɗǝ, sǝbgha samsami ɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kamɗǝ weerǝnda aam inabi nǝm irangnda ahur weerǝnda samsami hai. ");
INSERT INTO hwo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mbǝ niifa sǝ na nggǝm weerǝnda aam annab a kwasamadɗi sanǝn yanɗi mǝngga ɗǝ wa, ‘Ai, nǝn ndaarha yanɗi mǝngga ɗǝ kal ɗa ndǝn mbǝnda.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na fara sǝmǝnsǝ, far Yibrha Yahudaya, Yeeso tǝ fatsahayighǝn tǝrnda kwaman heerha; tǝrgha fatsahayighǝn kya ten ǝnnarhami nda na ƙǝla wan hwaliirha fahwang ngganda hai na nda a kiighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ndagha fingya Farisaya, “Mani nun ǝna ˈya kee ˈyaɗana ngyakhrha Musa yi far Yibrha?” ");
INSERT INTO hwo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nggǝmangga Yeeso kanda tǝ ndaarha, “karatang ngwanun ǝnɗi na hu ɗeleewar Faara ǝnana Ndauda tǝ nafighǝn na miirha a ƙǝs kanda wa? ");
INSERT INTO hwo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kyana Ndauda a Ƙǝn Faara ɗǝ tǝrnǝn mburodi sǝ ɗǝfangna nda ɗǝ ka firis katenggǝn, kiigha har ǝnangǝn pashiya wiyighǝn ha.” ");
INSERT INTO hwo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ngwalanggǝn pathɗi tǝ ndaarha, “Ai, Wan Niifa Chinani har tǝ far Yibrha.” ");
INSERT INTO hwo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A fara sǝmǝn far Yibrha Yahudaya fadghǝn, Yeeso kyaɗǝ Ƙǝn Faara ɗǝ a tsaharhaha. Na niifa sǝ a mbǝɗi mǝrna harghǝn a yisǝma. ");
INSERT INTO hwo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tǝrgha fa malǝmgya ngyakhrha tǝ Farisaya kanda a ƙǝla Yeeso ha tǝ nǝn a ƙǝnang nda fiya a far Yibrha ƙǝsǝr a ƙǝsangganda tǝ ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yeeso sǝn ɗǝ ǝnɗi nanda a numarha. Ndanggǝn niifɗi wu, “Thliusǝ ɓa isha a mbǝɗiya.” Tǝrgha niifɗi thliigha sǝ isha a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndangga Yeeso kanda, “Niya tsahang mee kun ha, ma kamngga a nam a far Yibrha? Əna nggayirha nǝm, nduwa mbǝlfeerha wa? A hǝrghanggǝm yibrha, nduwa ɓǝlanggǝm wa?” ");
INSERT INTO hwo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tǝrgha ƙǝlanggǝn kanda na heu; akwasamadghǝn ndanggǝn niifiɗiwu, “Pǝpǝnang harwa ɗǝ.” Ndǝghǝn nggi ƙǝm pǝpǝnanggǝn harghǝn ɗǝ. Tǝrgha harɗi pǝpǝngga ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A mbǝɗiwu hur Farisaya tǝ fa malǝmgya sǝbgha ɗǝ kaan, katǝrang ngganda thlǝk pathla hai aten ˈya na nda ǝnaarha tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A hu ɓengginiya, Yeeso tǝrɗǝ ten feera sǝ ka a hwangga. Mǝnggǝn ka hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɗalthna mbǝrha hai aah fatsahayighǝn nǝn ɓa, wurgha hasǝ ahur ndan Kum kap sǝri, aah kanda nǝn fathlǝnggighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kanda na Siman, ɗǝfang na Yeeso thlǝma Mbiturus, tǝ wanman Andǝrawus, tǝ Yakubu, tǝ Yahaya, tǝ Filibus, tǝ Mbatalomi, ");
INSERT INTO hwo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","tǝ Matiyu, tǝ Toma, tǝ Yakubu wan Halfa, tǝ Siman na nda aarha tǝ sǝrǝk chehweedghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tǝ Yahuda wan Yakubu, tǝ ƙǝm Yahuda Iskaryoti, tǝ tsaukwa tǝ thlǝrɓu. ");
INSERT INTO hwo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tǝrgha Yeeso tǝraa hai tǝ kanda ishgha a pǝpal tǝ fiya hangga na mbusamadghǝn. A mbǝɗi ƙǝm fiya hangga ɓagha ɓa a Yahudiya tǝ Urshelima, tǝ ƙǝm chehweed Taya tǝ Sidon na tsau tǝ wuri aama. ");
INSERT INTO hwo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓagha nda ɓa ka a sǝk laɓarghǝn nda tǝ ƙǝm awal ƙǝnda nda ahu wan hayindan. Kǝnanggǝn fiya na ǝnkaheeya a sǝsang kanda. ");
INSERT INTO hwo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fiya na heu a kaɗa kwamana na a tsuwarghǝn ndafa ƙǝsǝr sǝsǝmnda a kyarhaɓa a fadghǝn na a ƙǝnanggǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeeso ƙǝlanggǝn fa tsahayighǝn sǝ ndanggǝn kanda, “Nafiya ni kun na tǝ parka, kun na fa yamiya; ƙǝsǝr Kutǝryid Faara yinun ni! ");
INSERT INTO hwo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nafiya ni kun na tǝ parka, kun na miirha a ƙǝs kun nanǝn ya; ƙǝsǝr nun a nggaala! Nafiya ni kun na tǝ parka, kun na a tǝrha nanǝn ya; ƙǝsǝr nuna maasa! ");
INSERT INTO hwo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kun fa parkayani, na fiya a ƙarkun, kanda a wurang kun ɗǝ, kanda ˈyar kun tǝ ndaarha kun fa mbǝlfeeya ni ƙǝsǝr ka Wan Niifa!” ");
INSERT INTO hwo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Nama wutsǝfayirha a katǝra ǝnɗa haya, tǝ ƙǝm rǝɓama ka wutsǝfayirha ƙǝsǝr nun wal ƙǝnaghǝn hangga a talara. Ƙǝsǝr ƙǝtǝm nangga chichiyindan annabiya kee.” ");
INSERT INTO hwo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kawama nafiya, kun na tǝ ƙǝna ha nanǝn ya, ƙǝsǝr ˈwaɗun teena tǝk ɗun mbǝndafa! ");
INSERT INTO hwo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kawama nafiya nggalgha nanǝn ya, ƙǝsǝr ɓa na miirha ƙes kun! Kawama, kun na maasa nanǝn ya, ƙǝsǝr na hur nun a sǝbrha ɗǝ non a tǝrha! ");
INSERT INTO hwo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kawama, kun na fiya a faala ƙǝsǝr nangga chichiyindan annabiya fa nggaɓaya kee.” ");
INSERT INTO hwo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Niya ndang nda kun na sǝk fanna, nggǝmama fiya na tsan kun. Nama ˈya na ngga a fiya na karkun. ");
INSERT INTO hwo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɗǝfaman parka fiya teena na ˈyarkun, tǝ ƙǝm hwana man Faara fiya teena na sǝsang kun. ");
INSERT INTO hwo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","A mbi niifa sa ahu yanɗi ƙǝmenga ya, kyakhrang man patu ɓa. Athlang niifa kapad wa, ƙǝɗang yanɗa hai na ngguchit. ");
INSERT INTO hwo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kala niifa hwanowa ˈya, fǝrang, niifa ƙǝm thlangga ǝnwa a ndangna a nggǝroƙǝnǝn ha wa. ");
INSERT INTO hwo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ənaman ˈya fiya ƙǝla na minnun a ǝnang ngganda kun.” ");
INSERT INTO hwo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“A naɗun a nggǝm nafiya na a nggǝm kun kee, ƙǝƙǝn nun wal parka? Fa ɗimiya ƙǝm na nda nggǝm nafiya na nggǝm ka nda kee. ");
INSERT INTO hwo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kǝm ɗarha anaɗun a na ˈya na ngga ka fiya na nang kun kee, ƙǝƙǝn nun wal parka? Fa ɗimiya na nda naarha kee. ");
INSERT INTO hwo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tǝ ƙǝm ana fiya na mbang teng kun kee, ndǝnun fǝrang kumarha kanda, ƙǝƙǝn nun wal parka? Fa ɗimiya na nda fǝrang kumarha fa ɗimiya ƙǝsǝr ateng ngganda kanda mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nanǝn kee, nggǝmama nafiya na tsan kun tǝ ƙǝm ǝnaman ˈya kanda na ngga. Fǝrama kumarha mbǝ ka atenggǝnda kun wa. A naɗun a naarha kee nun wal ƙǝnaghǝn hangga, tǝ ƙǝm nun tsaurha wangya Faara Amshi, ƙǝsǝr nǝghǝn nang ˈya fiya na ngga mbuwa usa Faara tǝ ƙǝm fa mbǝlfeeya. ");
INSERT INTO hwo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsawama nafiya na fiya haɗang kun fa, ƙǝla nana Chinǝm Faara, na fiya a haɗang fa.” ");
INSERT INTO hwo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“A fǝrangɗun ɗimiyirha fiya wa, kun nggima mba nda fǝrang kun wa. A ngwangɗun kumarha fiya wa, kun nggima mba nda ngwang kumarha kun wa. Chahaman ɗimiyin ɗan fiya ɗǝ, kun nggima nanda chahang ɗimiyin nun kun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fǝrama, kun nggima nanda fǝrang nda kun tasau lǝlǝgɗa hǝrha hai, irang tahadghǝn nda kun ahu har luwun nun hai. Tasau nun a ƙǝƙǝrang fiya sǝ ndǝna nda ƙǝƙǝrang nda kun sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeeso fǝrang ɗǝ karapu kanda tǝ ndaarha, “Na kwamarha ƙǝs sǝsal kwamarha wa? Anaɗǝ kee, kanda kyab na nda mukrha ahu kwarha hai. ");
INSERT INTO hwo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mbǝ wan tǝ tsaharhaha sǝ, kalgha tǝmalǝm ndǝghǝn wa. Ƙǝsǝr, wan tǝ tsaharhaha a ngwalang ɗǝ tsahadghǝn ha, nǝn tsaurha ƙǝla tǝmalǝm ndǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mani na ƙǝlang hwalirha na a yid shadwa, sa kula ƙǝɗang miwaarha ɗǝ na a yidwa? ");
INSERT INTO hwo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kǝƙǝn na ndang nda shadwa, ‘Wanya ni a ƙǝɗo hwalirha ɗǝ a yidwa,’ kula sa na miwaarha na yidwa? Sa tǝ thlǝrɓu! Katǝrang ƙǝɗang miwad ɗǝ ˈwan na yidwa ƙǝsǝr ana manana hai ngga, na a mbangga ƙǝɗang hwalirha ɗǝ na yid shadwa.” ");
INSERT INTO hwo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ɗǝfrha na ngga mbǝ nggǝt wee mbuwa ngga wa, ɗǝfrha ƙǝm mbuwa ngga mbǝ nggǝt wee na ngga wa. ");
INSERT INTO hwo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nǝm sǝn ɗǝfrha tǝ wanggighǝn. Mbǝ naarha hai ɗakh wan shiɓarha nǝm a fad ndaha wa, nduwa wan inabi a fad ndakh mbǝlfeerha wa. ");
INSERT INTO hwo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ka niifa nǝn ǝna ǝngya na ngga, ƙǝsǝr ǝngya na ngga ndǝna ahurghǝn. Tǝ ƙǝm, tǝ mbǝlfeerha nǝn ǝna ǝngya mbuwa ngga, ƙǝsǝr ǝngya mbuwa ngga ndǝna ahurghǝn. Ƙǝsǝr ˈya na ahur niifa ndǝna kyarha ɓa a miighǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kǝn nun aah nggi, ‘Pǝpa, Pǝpa,’ kun a kar ˈya ndang ni kun a non? ");
INSERT INTO hwo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kala niifa ɓagha thlǝmanna ɓa, a sǝk ˈya niya thlǝkrha tǝ ƙǝm ndǝghǝn a ǝna ˈya ɗani, niya pǝrang tur niifɗi kun. ");
INSERT INTO hwo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nǝghǝn ƙǝla niifa na a tǝn wurighǝn, ranggǝn sarghǝn sǝ kuɗimnggǝn, tǝ ƙǝm ɗǝfanggǝn sar ƙǝnɗi aten feera. Lǝghǝdna kufarha ɗǝk nǝn wuriɗi mbangwa tsangˈya fa wa, ƙǝsǝr ɗǝfanggǝn sarghǝn aten keela. ");
INSERT INTO hwo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ƙǝsǝr niifa sǝkka pathna nawa taarasǝ wa, nǝghǝn mǝmǝl tǝ niifa tǝngga wurighǝn kula tansang sar ƙǝnggǝn ngga. Lǝghǝdna kufarha mbǝn nǝn wuriɗi chagha hai hǝrǝm, chat wuri ɗa hai, ˈya ni mbuwa ngga kaan.” ");
INSERT INTO hwo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A kwasamadɗi ngwalangna Yeeso pathla a fiya aten ǝnggini na midghǝn sǝ a pǝranggǝnǝn kanda, widghǝn ni Kafarnahum ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A mbǝɗi, na mamnda sodja Romaya sǝ na mafadghǝn hadghǝn kaan tsau tǝ mii mǝra fa. Mamnda sodja Romaya ɗiwu nggǝmɗǝ mafadɗi keeghǝn kaan. ");
INSERT INTO hwo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sǝknǝn laɓar Yeeso, thlǝn fingya fa malǝmgya Yahudaya nǝn ɗa nda hwanggǝn ɓaa ƙǝnang nda mafadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Famalǝmgini ɗǝnda thlǝmad Yeeso ɗǝ, hwanggǝnda kaan ndang ngganda, “Niifɗiya kam ɗǝ a ɗangga sǝ! ");
INSERT INTO hwo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nggǝmɗǝ nafinan har tǝnang ɗǝ Ƙǝn Faara kan sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wiigha Yeeso tǝ kanda. Ɗǝnda ɗǝ, kanda tsau tǝ wuri ɗi, mamnda sodja Romaya ɗi, thlǝn pashiyighǝn nǝn ndang ngganda Yeeso, “Paɓa, a ƙǝtǝlangna fadwa ka nggi wa, ƙǝsǝr tsǝkki na a ɓana wuri kyana ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndǝghǝnni ndani tsǝkki na ɗi thlǝmad wa ɗǝ wa, kalusǝ kee na mafanna a wal ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ƙǝsǝr nggi niyi akamu ngyakhrha niifa, ƙǝmɗa tǝ sodjaya a kamuna, ni ndaa nda yanɗiya, ‘ɗuwa ɗǝ’, nǝn ɗǝrha ɗǝ; yanɗi ƙǝm ndanggi ˈɓoɓaˈ, ɓagha ɓa, ndanggi mafanna, ǝno kiya, ǝnagha kee.” ");
INSERT INTO hwo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sǝkna Yeeso ndǝn kee, wulangga teena. Kyahargha hai ndanggǝn nafini na a mbu samadghǝn, “Niya ndang nda kun, ahur Isǝreela ˈwawi wal niifa tǝ fǝrƙǝkafek fa tǝ kanglanggirha ƙǝla yanɗiya wa.” ");
INSERT INTO hwo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nafini thlǝn nanda ɗǝ wu wunna nda a wuri ki mamnda sodja Romaya ɗǝ, ɗanda wal mafadɗi ƙǝnɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsuwa tsǝɓaku wa Yeeso ɗǝgha ahu tala ɗǝ na nda aarha Nayin, fatsahayighǝn tǝ fiya hangga mbu samadghǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nduwus na nda a kwakirǝm talɗa ɓa, tǝrgha (na) nafiya (nda) a kyarhaɓa tǝ mǝrra wunɗelarha, ndǝghǝnni tǝtal nggǝnna (ahar) man, chimadghǝn (nuɗi) ƙǝm mǝrɗǝ. Nafiya hangga ahu talɗi kanda a ɗǝfangɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nana Yeeso nuɗi, haɗanggǝn fa, ndanggǝn, “A tǝnna wa!” ");
INSERT INTO hwo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ɗǝgha ɗǝ tsuwar alkau ɗa nǝn fa, nafini na tǝghǝn ha isha nda hai. Ndagha Yeeso, “Wundǝlad ɗiya ndoyi thliusǝ!” ");
INSERT INTO hwo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tǝrgha wundǝlad ɗi mǝrgha thliighasǝ tsaukwa tsau, katǝranggǝn ndikrha hai. Yeeso ƙǝm fǝranggǝnǝn man ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tǝrgha tǝrmanda kanda na heu, manangganda thlǝm Faara nanda a ndaarha, “Kǝkafek, ɓat mamnda annabi ahur nǝm ɓa! Ɓa na Faara ɓa ka a hǝrghanggǝn nafiyighǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Laɓar ǝnɗi ǝna na Yeeso ya, ɗǝɗa ɗǝ inggun ahu Yahudiya tǝ tulayighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tǝrgha fatsahaya Yahaya pǝrang ǝnggina nda na heu, aagha Yahaya sǝri ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Thlǝn kanda nǝn thlǝmad Chinǝm ɗǝ tǝ Tsakhmee, “Sani na a ɓadɗaɓa wa, nduwa ƙǝla niifa nan pak wa?” ");
INSERT INTO hwo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sǝlna fa tsahayini a thlǝmad Yeeso ɗǝ, “Ndang ngganda Yahaya tǝ Mbaptisǝma ndǝghǝn thlǝngga kan a thlǝmad wa ɓa, nan a tsaho mee, sani na a ɓadɗaɓa wa, nduwa ƙǝla niifa nan pak wa?” ");
INSERT INTO hwo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A mbǝɗi tsu ƙǝnangga Yeeso nafiya mbuwa ƙǝkanglang, tǝ ǝnkaheeya. Kwamaya hangga ƙǝmɗa kanda ana mana hai. ");
INSERT INTO hwo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tǝrgha nggǝmangga Yeeso kanda ndǝghǝn, “Ɗamaɗǝ ɗun pǝranggǝn Yahaya ǝnɗi sǝknun tǝ ǝnɗi na nun. Sǝfǝngya a wiirha, fa termeeya kanda a wal ƙǝnda, teɓengya a sǝk pathla, kanda a thleng mǝrya sǝ ƙǝmɗa kanda a fǝr laɓar Faara a fa yamiya. ");
INSERT INTO hwo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Faara nǝn fǝr parka a fiya nggalgha tǝ fǝrƙǝkafek nanda tǝghǝn atenna.” ");
INSERT INTO hwo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Akwasamad ɗi wiina fathlǝnggini ki Yahaya, tǝrgha Yeeso katǝranggǝn tsǝ laɓar Yahaya ahu terɗi ngwagha hai, ndagha, “Kǝladma ɗunun ka ƙǝladɗǝ a kaheerha? Hwaliiya na dzang na ɓereurha a tsang ˈya fa wa?” ");
INSERT INTO hwo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yoo, ƙǝladma ɗǝnun ka ƙǝladɗǝ? Nduwa ngwadɗa fa ngwanda fa ya wa? Ai ƙǝmɗarha fa ngwaya fa na ngga, na nda tsaurha kwakirǝm kutǝra. ");
INSERT INTO hwo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yoo, ƙǝladma ɗǝnun ka ƙǝladɗǝ? Annabi wa? Kǝkafek niya pǝranggǝn kun har kalɗǝ annabi. ");
INSERT INTO hwo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yahaya ndǝna laɓar Faara chichirethlee hai tǝ ndaarha, “Iya, thlǝnɗi tǝ thlǝndǝna ˈwa ɗǝ mbee masa, yanɗi na a takso kwamana kapa na ɓarhaɓa, ");
INSERT INTO hwo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Niya, pǝranggǝn kun ahu fǝnayini na heu nggǝt na nishya mbǝ yanɗa sǝ kalgha Yahaya mamnggirha wa, nanǝn kee yanɗi na ngguchit ahu kutǝryid Faara kalɗa ndǝn mamnggirha.” ");
INSERT INTO hwo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nafiya sǝkka ǝnɗiya heu tǝ fa thlǝ tsamngya sǝndasǝ kwaman Faara ndǝna mǝmǝl, ƙǝsǝr kanda ǝnnanda mbaptisǝma yi Yahaya. ");
INSERT INTO hwo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amma Farisaya tǝ fa sǝn ɗǝleewar ngyakhrha, kar nda ɗǝfang shilee ǝnɗi na mid Faara nang nda kanda, ƙǝsǝr kar nda fa a nangga Yahaya mbaptisǝma kanda. ");
INSERT INTO hwo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ɗǝgha Yeeso mbeeɗǝ tǝ ndaarha, “Yoo, tǝ manda nǝm sakh nafiya ƙǝshiid weeriya? Na nda ƙǝƙǝn? ");
INSERT INTO hwo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na nda ƙǝla wundakhnaya na tsaurha a kasu, nanda aah ndan, kanda a ndaarha, “‘Peng ɗan perǝma kunsǝ karɗun rǝbrha fa, angɗan amshi mǝrra kunsǝ, karɗun tǝrha fa!’” ");
INSERT INTO hwo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Yahaya tǝ Mbaptisǝma ɓa nǝn ɓa mbǝ a hǝb ǝnnarhami wa, mbǝ a sa aam inabi wa, amma kun a ndaarha, ‘Nǝghǝn tǝ ǝnkaheerha fa!’ ");
INSERT INTO hwo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wan Niifa ɓa ɗa ɓa, a hǝbrha, a sarha, kun a ndaarha, ‘Na ɗun ndǝn tǝ yakh hǝbrha tǝ saarha, pashid fa thlǝ tsamngya tǝ fa ɗimiyirha ni!’ ");
INSERT INTO hwo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nanǝn kee, nafiya nggǝmngga fa tǝ ndǝndǝlyid sǝnda Faara, kanda ƙǝl ndaarha nǝghǝn tǝ ƙǝkafek fa.” ");
INSERT INTO hwo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tǝ Farisarha sǝ aagha Yeeso ka hǝb ǝnnarhami a wuri keeghǝn ɗǝ, tǝrgha kyagha ki tǝ Farisadɗa hai, tsaukwa hai a hǝb ǝnnadɗami. ");
INSERT INTO hwo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A hu talɗiya na nuneefasǝ mbuwana ǝn ǝnadghǝn ngga, sǝknǝn ndaarha na Yeeso a hǝb ǝnnarhami a ki tǝ Farisarha ɓagha ɓa tǝ ƙǝthlikrha fǝɗeerha na tǝ wuɗǝɓǝla fa. ");
INSERT INTO hwo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ishgha aman ƙǝsǝrghǝn tǝman sarghǝn fa, nagha a tǝrha, tǝrgha aam yidghǝn nagha a tsǝtsaarha aten sarghǝn hai fǝɓanggǝn sarɗi, panggǝn ɗǝ tǝ was tenggǝn, ƙǝmanggǝn tǝ fǝɗeerha na tǝ sǝdghǝn mbǝnggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nana tǝ Farisadɗi aagha ndǝn ndagha ahurghǝn, “Ana niifɗiya annabi ni kam sǝnɗǝ tǝ wunniya, tǝ ƙǝm ndaarha tur nu wunniya na a tsuwarghǝn fa ƙǝsǝr tǝ ɗimiyirha ni.” ");
INSERT INTO hwo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nggǝmangga Yeeso ndanggǝn, “Saminu, na ˈyasǝ niya puro,” ndǝghǝn ƙǝm ɗarha, “Mala puruwun.” ");
INSERT INTO hwo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ndagha Yeeso, “Niifasǝ a takkwa nafiya sǝri kumarha, tal wuɗǝɓǝl wurirha haru tuf, tahadghǝn ƙǝm kumnggit tuf. ");
INSERT INTO hwo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pǝɗangna tidghǝn kanda, tǝrgha chahanggǝn nǝn kanda ɗǝ ngwad kyab. Yoo, ahur ndan yanggini nggǝm nggǝn kaan?” ");
INSERT INTO hwo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nggǝmangga Saminu ndanggǝn, “Ai yanɗi chahang na nda ɗǝ na hangga.” Ndanggǝn, “Nggǝmangna mǝmǝl.” ");
INSERT INTO hwo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kyahar nǝn thlǝmad nuɗa ɗǝ, ndanggǝn Saminu, “Nanna nuɗiya? Kyaɗi kyawa hai fǝre wa aam tsab sara wa, amma ndǝghǝnggi irang ɗǝ aam yidghǝn aten saryina hai, panggǝn ɗǝ tǝ was tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sa fufubwa nggi wa, ndǝghǝnggi ƙǝm ka kyani mbǝɗa ɓaya malangwa fǝb sarghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ƙǝmang ngwa tenna tǝ fǝɗeerha wa amma ndǝghǝnggi ƙǝmang ɗǝ sarna tǝ fǝɗeerha na sǝdghǝn mbǝnggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nanǝn kee niya puroƙǝn, pat ɗimiyini keeghǝn na hangga chahang ndanɗǝ, ƙǝsǝr nǝghǝn tǝ nggǝmnda na hangga yanɗi chahang nanda ɗǝ ngguchit ƙǝm nggǝmnda ngguchit nǝn waala.” ");
INSERT INTO hwo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tǝrgha ndangga Yeeso, nuɗi, “Ɗimiyid wa chahon ndan ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nafini na a hǝbrha tǝghǝn, na nda a ndangnda ndan, “Wunni yanɗi ƙǝmya na chahang ɗimiyirha ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tǝrgha ndangga Yeeso nuɗi, “Fǝr ƙǝkafekkid wa hǝrwo ɗǝ ɗuwa ɗǝ hu ɗǝɗemnggirha.” ");
INSERT INTO hwo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mǝnggaha wa na Yeeso a Pǝr laɓar kutǝryid Faara tala-tala, fatsahayighǝn na Kum kap sǝri a thlǝmadghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tǝ fingya nishya ndǝghang nda kanda hai tǝ ǝnkaheeya tǝ fingya wan haya. A hur ndan na Mairamu sǝ nanda aarha Magdaliya ndǝghang nda hai tǝ ǝnkaheeya mǝd. ");
INSERT INTO hwo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tǝ Yowana nu Kudza tǝ thlǝnda Hirdus, tǝ Sudzanatu tǝ fingya hangga ɗangga kanda sǝ tǝ rǝfyindan. ");
INSERT INTO hwo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wumna fiyaɓa hangga, nafiya aten chikrha ɓa, tala-tala kanda a ɓarha thlǝmadghǝn ɓa. Thlǝghang karapu nǝn kanda sǝ ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Na niifasǝ ɗǝgha ka hǝfrha ɗǝ, ndǝghǝn aten wash wiirha, fingya hǝra nda hai aten kwamana ishangga fiya hai tǝrgha ɗamangga wuɗikkya. ");
INSERT INTO hwo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hǝrgha fingya hai ahu hǝreng keela hai, kya nda sǝ tǝkna yan faara hai hwara nda ɗǝ ƙǝsǝr mbǝ lǝssa suwa. ");
INSERT INTO hwo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fingya hǝra nda pathlang ndakhkya hai kya nda sǝ kal wanda farha hai a pathlang ndakhkini wa. ");
INSERT INTO hwo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hǝrna fingya hai ahu chehweerha hai na ngga kyanda sǝ ngga tǝ chikrha haru-haru.” Ndanǝn kee tǝranggǝn uradghǝn sǝ ndagha “Yi na tǝ thlǝmad sǝkrha sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Fa fatsahaya Yeeso tsahang mee nda aten karapu ɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ndanggǝn kanda, “Nggǝmang nda kun fa na a sǝn ˈya nun na kutǝryid Faara ahurghǝn, fingya a mbǝ tǝ karapu wa mba nda sǝnggǝn wa, naarha nandan, kanda mba nda kukwalang hai wa, sǝkrha ƙǝm sǝk ndan, kanda mba nda sǝnggǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ndǝghǝn “Karapu ɗiya nǝghǝn kiya, Wiirha laɓar Faara ni. ");
INSERT INTO hwo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fingya hǝrgha hai ahu kwamana nǝghǝn aten nafiya sǝkka laɓar Faara, tǝrgha ɓagha Sheetan ɓa tǝranggǝn laɓar ɗa ɗǝ ahur ndan amana nda fǝrƙǝkafek na a wal hǝrǝkrha nda. ");
INSERT INTO hwo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yi hǝreng keela nǝghǝn aten fingya a hǝrǝmna nda sǝk laɓar Faara nanda thlǝghǝn tǝ hura pǝpet, mbǝ mbǝd tsawudghǝn sǝ ahur ndan wa, ƙǝsǝr nanda fǝrƙǝkafek yi ɓeena ngguchit, a wal nda ƙǝƙǝrra mba nda kwas kyaharra hai wa. ");
INSERT INTO hwo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fingya hǝrgha ahu ndakhkya hai, ndǝna aten fingya sǝkka laɓar ɗi, ƙǝsǝr nda weeriya tǝ ɓinda ka ǝn ƙǝshiirha, tǝ ƙǝna tǝ ǝn mbǝndayirha fa yi ƙǝshiid ɗiya thluranggǝn kanda ƙǝsǝr mbǝ ˈyasǝ nanda mbang ǝnaarha ngga wa. ");
INSERT INTO hwo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Fingya hǝf nǝn ahu chehweerha na ngga ndǝna aten nafiya sǝkka laɓar ɗi, ƙǝsghǝnda ha ngga tǝ hura tǝtal, ƙǝrsa nda na ˈya nda na ngga.” ");
INSERT INTO hwo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mbǝ niifa sǝ na njang patilla tsǝɓanggǝn tǝ tǝɓa wa, tǝ ƙǝm ɗǝfanggǝn kamu wusǝra ɗǝ wa. Nǝm ɗǝfang nda a mbǝd ɗǝfrha na a pǝpal ƙǝsǝr ka nafiya na kyarha ɓa na kukwaryirha nda. ");
INSERT INTO hwo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mbǝ ˈyasǝ na ɓǝɓee mbuwa kyarha sǝ wa. ˈYa ƙǝm na nggǝnggǝla nǝn kyarha pǝpal ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwarama tǝ sǝk pathla nun a naarha sǝkrha a sǝnunsǝ niifa na tǝ ˈya ha nanda chighanggǝn, yanɗi mbuwa tǝ ˈya anaɗǝ a numarha nǝghǝn tǝghǝn ha nanda thlang nda.” ");
INSERT INTO hwo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Man tǝ wanmanggighǝn ɗǝnda thlǝmadghǝn ɗǝ, wal wanda sǝla thlǝmadghǝn ɗǝ wa ƙǝsǝr ka hangnda fiya. ");
INSERT INTO hwo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndang ngganda, “muwa tǝ wanmanggiwa kanda a ƙǝshi na mindansǝ na sa.” ");
INSERT INTO hwo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nggǝmanggǝn kanda ndǝghǝn “Nafiya na sǝk laɓar Faara thlǝnangganda ɗǝ kanda ni iiya tǝ wanmanggina.” ");
INSERT INTO hwo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na fara sǝ kyanǝn hur kombuwal hai tǝ fatsahayighǝn, ndanggǝn kanda, “Tama pǝm wuri aamɗa ɗǝ ya.” Thlii wiirha nda. ");
INSERT INTO hwo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nanda aten wiirha tǝrangga ɓeena ɗǝ. Tǝrgha ɓereu ˈyaara thliigha ɓa, kombuwal ndan takh ɗǝ a lǝghǝtta tǝ aama, tǝrmanda. ");
INSERT INTO hwo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɗǝnda ɗǝ thlengganda sǝ a ɓeena, ndang ngganda, “Paɓa-paɓa nǝm a mǝra!” Thliigha sǝ yananggǝn ɓereu ˈyaarɗi tǝ kuɗǝfǝlla amɗi nggasa nda hai tip. ");
INSERT INTO hwo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndanggǝn kanda, “Ai fǝrƙǝkafekkid nun?” Tǝrgha tǝrma nda tǝ wulteena, na nda a ndangnda ndan, “Wunniya na ɓereu ˈyaara tǝ aama ɗǝfang shilee in?” ");
INSERT INTO hwo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɗǝnda mbeeɗǝ tǝ wiirha a Nggalili ta Nggarasina ɗǝ na a pǝm wuri aama. ");
INSERT INTO hwo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tǝrnda hai a mii wuri aamɗi, na niifasǝ tǝ ǝnkaheerha fa, kyagha ɓa ahur talɗi hwathla kanda nǝn fa. Mǝndaha ˈwawa kal kaɓarha fa wa. Mbǝ tsaurha a wuri wa ƙǝl a mbǝd ten kwaya. ");
INSERT INTO hwo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nanǝn Yeeso tǝrgha huhwagha, fǝlgha hai a mbedghǝn tǝranggǝn uradghǝn sǝ ndǝghǝn, “Ma njidoyiwa tǝ nggi Yeeso Wan Faara Amshi? Niya hwan sa a sǝsenna wa.” ");
INSERT INTO hwo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Thlǝk nǝn ndǝn kee, ƙǝsǝr Yeeso ˈwaɗǝ teena yanang ɗǝ ǝnkaheedɗi a ndǝkka hai tǝ niifɗi. Sara hangga na ǝnkaheedɗi naarha ɗǝghang niifɗa hai, na fiya ƙǝnang hai tǝ wuyiwurra nǝn ɗahang ɗǝ ɗangga ǝnkaheedɗi a heeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tǝrgha Yeeso tsahang mee nǝn ha, “Thlǝm wani ƙǝn?” Ndǝghǝn, “Hangga.” Ƙǝsǝr ǝnkaheeya hangga kyangga fa. ");
INSERT INTO hwo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na nda a hwanggǝn a ɗangɗǝ kanda hu kwaɗaɗǝ na kuɗimnggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A mbǝɗi wu na chiɓǝt ƙǝlengarya sǝ a lafrha a wumnda, hwanggǝn nda a kya nda ahur ndan hai, nggǝmanggǝn kanda fa. ");
INSERT INTO hwo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tǝrgha ǝn kaheeyini ndǝghang nanda kanda hai tǝ niifɗi kyanda hur ƙǝlengaryina hai. Tǝrgha ƙǝlengaryini thlii nda sǝ tǝ ɗarha kya nda hu wuri aamɗa hai, mǝra nda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fa laf ƙǝlengaryini nanda ǝnɗi katǝragha hai, ɗandan ni wure ɗǝ na nda a pǝrghǝn tala-tala. ");
INSERT INTO hwo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tǝrgha fiya kya nda ɓa ka na ǝnɗa nda katǝragha hai ɓa nda thlǝmad Yeeso ɓa, ɓanda walghǝn tǝ niifɗi ndǝkna ǝnkaheeyina hai tǝghǝn tsau a mbedghǝn kalɗǝ lukrha fa, ɓa hutenggǝn ɓa. Tǝrgha tǝrmanda. ");
INSERT INTO hwo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na nafiya sǝ ǝnana Yeeso ǝnɗi a yindan thlǝghanggǝn nda kanda kwamanɗi ƙǝnang nda tǝ ǝn kaheedɗi. ");
INSERT INTO hwo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nafiya Nggarasina kahat hwan Yeeso nda na a ndǝkka hai tǝ kanda, ƙǝsǝr ƙǝs hǝreenga kanda kaan. Tǝrgha Yeeso ahu kombuwal hai wiigha. ");
INSERT INTO hwo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Niifɗi ndǝkna ǝnkaheeyina hai tǝghǝn hwanggǝnǝn na a wii nda kyab. Tǝrgha ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wuɗu wureɗǝ ɗa thlǝk ǝnɗi ǝnona Faara.” Widghǝn ni hur tala ɗǝ nagha a thlǝk ǝnɗi ǝnangna Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wunna Yeeso ɓa, fiya hangga hwathlagha ndǝn fa, ƙǝsǝr nanda a ƙǝlaghǝn fa. ");
INSERT INTO hwo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tǝrgha na niifa sǝ thlǝmnggǝn ni Yayirus mamnda niifa ni a Ƙǝn Faara, mbǝrgha hai a mbed Yeeso hwanggǝnǝn a ɗǝgha wuri keeghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Na wutaradghǝn sǝ tǝtal huradghǝn ǝnaɗǝ Kum kap sǝri a mǝra. Tǝrna Yeeso kwamana, fiya hangga a ngyaɓang mbǝrha fa. ");
INSERT INTO hwo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A hur ndan na nuneefa sǝ sǝsagha yi hurarha kumkap sǝri fara aten ɓang ndafa hai, ɓǝlang ɗǝ ǝn hu harghǝn ɗǝ ka kaɗa puurha, walwa ƙǝnda wa. ");
INSERT INTO hwo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tǝrgha kyagha tǝ man ƙǝsǝrghǝn tsuwar pǝpǝshiprha parkwadghǝnǝn fa. A mbǝɗi wu farɗi na ɓang fa hai tǝrgha. ");
INSERT INTO hwo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ndagha Yeeso, “Wunni tsuwargha nggi fa?” Ngaalangganda, tǝrgha Mbiturus tǝ fingya na a thlǝmadghǝn ndang ngganda, “Paɓa na fiya hangga na puworha ɓa kanda a ngyaɓo mbǝrha fa.” ");
INSERT INTO hwo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ndagha Yeeso, “Na niifa sǝ tsuwargha nggi fa ƙǝsǝr na sǝsǝmnda sǝ kyagha ɗǝ a fanna.” ");
INSERT INTO hwo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kǝlaana nuɗa hai mbǝ mbang ɓeerha wa, Nduwusgha thlǝmadghǝn ɗǝ nagha fadghǝn a rǝbrha fa, ɓǝrgha hai a mbedghǝn pǝrghǝnǝn a mbed fiya na heu ǝnɗi nagha ndǝn tsuwarnǝn ndǝn fa tǝ wal ƙǝnda wal nǝn a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ndangga Yeeso nuɗi, “Waana fǝrƙǝkafekkid wa ƙǝnoɗǝ wiu fadwa ahu ɗǝɗǝmnggirha.” ");
INSERT INTO hwo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndǝghǝn aten fǝr laɓara, ɓagha niifa ɓa a wuri ki Yayirus mamnda Ƙǝn Faara ndanggǝn, “Wutaradwa mǝrɗǝ a sǝsangna tǝ malǝmndǝ ɗaɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sǝkna Yeeso ndǝn, ndanggǝn mamndǝɗi, “A tǝrǝmna wa furu ƙǝkafek kee nǝn a ƙǝnda.” ");
INSERT INTO hwo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nduknǝn hur wuriɗa ɗǝ nggǝmangwa fiya fa mbusamadghǝ nda wa, ƙǝl Mbiturus, tǝ Yahaya, tǝ Yakubu tǝ ƙǝm chin wanɗi tǝ man. ");
INSERT INTO hwo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Fiya aten tǝrha tǝ huhwaarha ka mǝra wutaradɗi. Ndagha Yeeso, “Malaman tǝrha, mǝrgha wa nǝghǝn a shiirha.” ");
INSERT INTO hwo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tǝrgha masangganda yi sarfarha, ƙǝsǝr sǝndasǝ mǝrɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ndǝghǝnggi ƙǝm ƙǝs nǝn har wanɗi tǝranggǝn uradghǝn sǝ ndǝghǝn, “Waana thliu sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sǝsǝnggǝn wudgha ɓa thliigha sǝ, ndanggǝn kanda fǝraman ǝnnarhami hǝbgha. ");
INSERT INTO hwo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Fa nggǝtyighǝn wulangga teena kanda. Yi yang thlǝmarha nǝn kanda teena a pǝrang ndan fiya ǝnɗi katǝragha hai wa. ");
INSERT INTO hwo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aah nǝn fatsahayighǝn kumkap sǝri ɗa ɓa, ndanggǝn kanda, fǝrangɗi sǝsǝmnda kun na a ƙǝnanggun fiya na tǝ ǝnkaheeya tǝ wan haya ɗǝɗamǝn, ");
INSERT INTO hwo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","tǝ ƙǝm thlǝn kanda nǝn ɗaa nda pǝr laɓar kutǝryid Faara, tǝ ƙǝnang nda haaya. ");
INSERT INTO hwo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ndanggǝn kanda, “A thliiɗun wiirha ma tǝrɗun sǝsala, tǝ yawarha, tǝ ǝnnarhami, tǝ wuɗǝɓǝla, tǝ ƙǝm lukrha sǝri wa. ");
INSERT INTO hwo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A ɗǝɗun ɗǝ, wuriɗi ˈwanun kyarha sahai, tsawama sǝ pa far wuttǝnun ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kala nafiya thlǝwa nanda kun fa, a naɗun a mal talɗi tinid talɗi na sarnun pamanɗǝ ka a tsauka ǝn sakhrha ni a tendan.” ");
INSERT INTO hwo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Thlii nda, wengganda talya hai hangga, kanda a pǝr laɓar Faara tǝ ƙǝnang nda fiya ko a yanggini. ");
INSERT INTO hwo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hirdus kutǝr Nggaliliya, sǝkɗǝ ˈya na a katǝrarha hai ahu chehweedghǝn, ƙǝrǝdɗadǝn fa kaan, ƙǝsǝr fingya na nda a ndaarha Yahaya tǝ Mbaptisǝma ni thleng nanda sǝ ahu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fingya ƙǝm ndaa nda Iliya ni kyagha ɓa, fingya a ndaarha tal ni ahur annabiya na kaar thliigha sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ndagha Hirdus, “Yahaya kyathlangɗi tenggǝn ɗǝ, wunni ƙǝm mbiya ni a sǝk ǝnggini ɗǝɗamǝn atenggǝn ya?” Nanǝn kee, midghǝnsǝ a na Yeeso nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wunna fatsahayighǝn ɓa pǝrang ǝnggina nda ǝnana nda. Tǝrgha thliigha tǝ kanda katendan ɗǝnda ahu tala ɗǝ nanda aarha Mbatseda. ");
INSERT INTO hwo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sǝnna fiya mbǝɗi nǝn a ɗǝrha saɗǝ, mbu samadghǝn nda. Thlǝ kandanǝn fa, pǝrang laɓar kutǝryid Faara nǝn kanda, ƙǝnanggǝn fingya na mindan ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yarna fara hai, Kum kap sǝriɗi ɓaa nda thlǝmadghǝn ɓa ndang ngganda, “Kamɗǝ nanǝn ya kal fiya na hai kya nda hur tala ɗǝ ɗanda kaɗa ǝnnarhami tǝ mbǝd mǝnda ƙǝsǝr mbǝɗi nanǝm sǝ ya mbǝ fiya sǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ndangga Yeeso kanda, “Kun tǝ altennun fǝraman ǝnnarhami kanda lee.” Ndang ngganda, “ˈya na a har nan mburodi ni tuf tǝ tǝna sǝri kee, a mbǝ nanan kyarha hur tala ɗǝ ɗan heng ǝnnarhami fiya ɓa na heu wa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hǝshya ǝnanda haru kumnggit tuf. Ndangga Yeeso fatsahayighǝn, “Ndaman fiya tsawanda hai, wumangganda tendan kumnggit tuf-tuf.” ");
INSERT INTO hwo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Fatsahayighǝn tsawangganda fiya hai ƙǝla ndanǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tǝrgha haranggǝn mburodi ɗi tuf tǝ tǝn ɗi sǝri, tǝranggǝn tenggǝn talara ɗǝ, usa Faara nǝn, kyanggǝn hai, fǝranggǝn nǝn fatsahayighǝn ndǝghanggǝn nda fiya. ");
INSERT INTO hwo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fiya na heu ǝnanda mii nggal nda. Tǝrgha fatsahayighǝn wumangganda kwasamadghǝn kutasya kumkap sǝri. ");
INSERT INTO hwo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na farɗa sǝ Yeeso a hwan Faara katenggǝn tǝ fatsahayighǝn a thlǝmadghǝn, tsahang mee nǝn kanda, ndǝghǝn, “Na fiya ndaarha wunni nggi?” ");
INSERT INTO hwo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nggǝmangganda, “Fingya a ndaarha Yahaya tǝ Mbaptisǝma, fingya Iliya, fingya ƙǝm a ndaarha tal ni ahur annabiya na kaar thliigha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ndanggǝn kanda, “Kun tǝ altennun nun a ndaarha wunni nggi?” Tǝrgha Mbiturus nggǝmanggǝn ndǝghǝn, “Sani Ƙǝrǝsti yi Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeeso yiyang thlǝmarha nǝn fatsahayighǝn, a pǝrang ndan niifa laɓar ɗi thlǝghang nǝn kanda wa. ");
INSERT INTO hwo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ndangga Yeeso kanda, “Kǝkafek ni, Wan Niifa nǝn a sǝsaarha ahar shingya, tǝ mamnda firistaya, tǝ ƙǝmɗa fasǝngya ngyakhrha, nanda a karghǝn fa, ɓǝlang ngganda, a far ɓeena yi mahan nǝn a thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ndanggǝn kanda na heu, “Ana mid niifasǝ mbu samanna ƙǝl karnǝn altenggǝn tǝranggǝn kaɗidghǝnsǝ ka fad ɗathla mbǝrha fa hai ndǝnǝn mbang mbu samanna. ");
INSERT INTO hwo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Niifa na midghǝnsǝ a hǝrghanggǝn yiɓǝdghǝn nǝn a ƙǝɗeng nda, kala niifa ƙǝɗengga yiɓǝdghǝn ka nggi nǝn a wal yibrha mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kǝmɗa, ma chighang nǝn niifa a walɗǝ ǝn ƙǝshiid weeriya heu ƙǝɗenggǝn yiɓǝdghǝn? ");
INSERT INTO hwo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kala niifa niya shiɗang tǝ laɓarna, Wan Niifa ƙǝm nǝn a shiɗang nda tǝ ndaarha sǝngwa ndǝn wa aɓaɗǝ hu mamnggitghǝn ɓa yi Chin tǝ yi fathlǝngya Faara tǝ peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kǝkafek niya pǝrang nda kun, na fingya sǝ ƙǝƙǝt a mbǝɗiya mba nda a mǝra wa, nanda a naa kutǝryid Faara tǝ yindan a mǝra nda.” ");
INSERT INTO hwo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Akwasamad ɓeena uvaɗa tǝ thlǝk palthɗiya, Yeeso tǝranggǝn Mbiturus tǝ Yahaya tǝ Yakubu tǝraa nda wumnda sǝ ƙǝsǝr a hwan Faara nda. ");
INSERT INTO hwo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndǝghǝn aten hwan Faara, ƙǝla nda hai pǝmnggǝn a chim nda fa, lukkighǝn tsaukwa pǝpet nagha ahar yirha. ");
INSERT INTO hwo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kula sǝndǝndan sǝ na nafiya nda sǝri a thlǝmadghǝn, kanda a tsǝ laɓara tǝghǝn. Nafiniya nda Musa ni tǝ Iliya. ");
INSERT INTO hwo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓanda thlǝmadghǝn ɓa tǝ mamnggirha, na nda a tsǝ laɓara tǝ Yeeso ahu lǝghǝtta ˈya na mid Faara aten mǝrrǝghǝn a Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mbiturus tǝ fingya na a mbǝɗi kanda a ɓeena. Mehen na nda ɓa, tǝrgha na mamnggitghǝn nda, tǝ ƙǝmɗa nafini sǝri ƙǝƙǝt a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na nafini sǝri a ndǝkrha hai tǝghǝn, tǝrgha Mbiturus ndanggǝn Yeeso, “Paɓa, nǝghǝn ngga nanǝm a mbǝɗiya, na chama nan mahan, tal yiwa, tal yi Musa, tal ƙǝmɗa yi Iliya.” Sǝngwa ǝnɗi nǝn a thlǝkrha wa. ");
INSERT INTO hwo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ndǝghǝn a ndikrha kee, ƙǝla nda hai hashmbe nggǝlanggǝn kanda. Nggǝlangna hashmbiɗi kanda tǝrmanda. ");
INSERT INTO hwo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sǝk urarha nda hai ahur hashmbiɗi tǝ ndaarha, “Waana niya wurni, sǝgha madghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Akwasamad sǝk uradɗi, na Yeeso nda ƙǝt katenggǝn. Fatsahayighǝn nggasanda hai titib, a sayidɗiya pǝrangwandan niifa ǝnɗi katǝragha hai wa. ");
INSERT INTO hwo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɗalthna mbǝrha hai, Yeeso tǝ fatsahayighǝn tǝrna nda hai a wumndǝɗi, wumngga fiya thlǝmadghǝn ɓa hangga. ");
INSERT INTO hwo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na niifa sǝ ahur nafini wumngga ɓa aaghǝnǝn ndǝghǝn, “Paɓa ni a hwan sa ƙǝlang waana thlarghǝna, ƙǝsǝr ndǝghǝnni tǝtal a harna. ");
INSERT INTO hwo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na ǝnkaheerha tsang hurafa, nǝn huhwarha, ɗǝghanggǝn hai, nagha fadghǝn a rǝprha fa, nagha miighǝn ƙǝm a hufrha. A fara sǝmǝn mbǝ malang wa ƙǝl sǝsangnǝn kaan. ");
INSERT INTO hwo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hwan ɗi fatsahayiwa a ƙǝnang ngganda, mbang ngwanda wa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nggǝmangga Yeeso ndǝghǝn, “Kun nafiya ƙǝshiid weeriya fa mbǝlfeeya, mani ƙǝɗiina fǝrƙǝkafekkid nun? Pa kwanɗǝ nǝm tsaurha, nggi aten ƙǝrǝsta tǝ kun? Ɓotǝghǝn wanɗi kyawa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na wanɗi ɓayi tǝrgha ǝnkaheedɗi ɗǝghanggǝn hai nagha fadghǝn a rǝpfa. Tǝrgha Yeeso njaranggǝn ǝnkaheedɗa ɗǝ, ƙǝnanggǝn wanɗi wuɗanggǝnǝn chin ha. ");
INSERT INTO hwo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Fiya na heu a mbǝɗi wulangga teena kanda aten mamnggit tar Faara. Na fiya heu aten na ǝnwulteena aten ǝnɗi ǝna na Yeeso, ndanggǝn fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“A mbǝɗanɗǝ kun tǝ pathɗi niya pǝrang nda kun wa, nanda a fǝr Wan Niifa ahar fiya hai.” ");
INSERT INTO hwo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kanda hwathlang ngwanda numadghǝn hai wa, ɓǝɓeng ndan kanda ƙǝsǝr amana nda kukwalang hai. Kanda ƙǝm a tǝrǝm tsahang mee aten path ɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tǝrgha thliigha ngaala sǝ a pathlang fatsahayighǝn aten wunni ahur ndan na manggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sǝnna Yeeso numan ndan tǝrgha ƙǝs har wee nǝn ɓa ngguchit ishanggǝn a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ndanggǝn kanda, “Kala niifa thlǝgha wanda fa ya ka nggi, nggi thlǝnǝn. Niifa thlǝgha nggi ƙǝm, thlǝnǝn niifɗi thlǝngga nggi ɓa. Nanǝn kee, niifa na ngguchit ahur nun ndǝna manggǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ndangga Yahaya, “Paɓa, na ɗan niifa a ƙǝnang ǝnkaheerha tǝ thlǝm wa, ˈyaɗang ɗandǝn fa ƙǝsǝr mbǝ ahur nǝm wa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nggǝmangga Yeeso kanda, “A ˈyaɗang ɗundǝn fa wa, ƙǝsǝr niifa mbuwa tsan kun yinun ni.” ");
INSERT INTO hwo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nduwusna ɓenggǝn ɓa nǝn a wutta talara ɗǝ, ɗǝf ɗǝ teena kaan tǝ ɗǝrha Urshelima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Thlǝn farha nǝn a ˈwanda mbee ahu tala ɗǝ na a chehweed Samariya, ɗa nda ngwang ǝngya fa a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amma nafini na a mbǝɗi kar thlǝdghǝnda fa, ƙǝsǝr sǝndasǝ na midghǝn ɗǝrha Urshelima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tǝrgha fatsahayighǝn, nda Yakubu tǝ Yahaya, ƙǝlana nda hai kee, tsahang mee nda Yeeso, “Chinǝm, na midwasǝ aah waarha nan hai a talara njanggǝn kanda ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amma kyahargha Yeeso hai yananggǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɗǝnda hu talaɗǝ tǝ sǝmǝn. ");
INSERT INTO hwo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kanda aten wiirha ahu kwamana, ndangga niifa Yeeso, “Niya mbu samadwa kala mbǝrha na a ɗǝrha saɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nggǝmangga Yeeso ndǝghǝn, “Tsarwaya tǝ kwandan sǝ, wuɗikkya tǝ ƙǝndan sǝ, amma Wan Niifa mbǝ mbǝd mǝndǝghǝnsǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndanggǝn niifa pak, “Mbuwu samanna.” Amma nggǝmangga niifɗi ndanggǝn, “Paɓa, malee ˈwan ɗi pang nda pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ndangga Yeeso, “Malang mǝrya panggan nda mǝrrǝndan, sa ƙǝmɗa ɗuwa ɗǝ ɗa pǝr laɓar kutǝryid Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na niifa sǝ ƙǝmɗa ndanggǝn Yeeso, “Paɓa, niya mbu samad wa, malee ˈwan ɗi ndang nafina wiiɗi.” ");
INSERT INTO hwo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ndangga Yeeso, “Kala niifa katǝrangga huɗarha hai, anaɗǝ a ƙǝlarha samarha ɗǝ, mǝmǝl wa tǝ tar kutǝryid Faara wa.” ");
INSERT INTO hwo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Akwasamad yanɗiya, chinǝm wurɗǝ nafiya kumnggit mǝd kap sǝri, thlǝn kanda nǝn sǝri-sǝri, a ˈwanda mbeeɗǝ, ɗǝnda hu talya ɗǝ ɗǝɗamǝn na ndǝghǝn nggi a ɗǝrha saɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ndanggǝn kanda, “Hathla sǝ hangga fa taryighǝn ƙǝɗin nda. Nanǝn kee, hwanama tǝ heerha puwanggǝn fa hathya ɓa, hathlangganda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nanǝn ya, weema niya thlǝn kun ƙǝla wan chaukhraya ahur mǝmereeya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A tǝrɗun wuɗǝɓǝla, tǝ ǝnnarhami, tǝ pakhma wa. A mbǝdɗun hai ka nda ˈya tǝ niifa a kwamana wa. ");
INSERT INTO hwo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kala minda kyanunsa hai, ndama, ‘Koomaa, nafiya wuriɗiya!’ ");
INSERT INTO hwo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ana nggǝm nda sǝ afad nafini ahur mindǝɗi, ngwa tsaukwa parkad nda ǝnnun ahur ndan, a mbǝ kewa nǝn a nggǝra thlǝman nun ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tsawama ahur mindǝɗi, kala ˈya ɓangnda kun ɓa ǝnamami. Tǝ taara kamɗǝ teng thlǝthlǝn ndǝghǝn nda, ma naɗun a kya wure-wure wa. ");
INSERT INTO hwo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kala tala kyanun sahai a thlǝnda kun fa, kala ˈya ɓangnda kun ɓa ǝnamami. ");
INSERT INTO hwo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kǝnaman haaya ahu talɗi, ndanggǝn nafini kutǝryid Faara nduwusɗa ɓa tsau tǝ kun. ");
INSERT INTO hwo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kala tala kyanun sahai a thlǝwa nda kun fa wa, kyama tǝ kwamangya, ndon, ");
INSERT INTO hwo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","tǝnid talnun tsauka a fad sarnan pang ɗan ndǝn kun hai. Kǝl a sǝnunsǝ kutǝryid Faara ndusang ɗǝ kun fa. ");
INSERT INTO hwo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Niya pǝranggǝn kun a far ngwala ƙǝshiirha na Saduma haɗang nda Faara fa ma tal ɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kawa Koridzin! Kawa Mbatseda! Ənwulteena ɗǝɗamǝn ǝnanda ahur nun ndǝghǝn ǝnanda a Taya tǝ Saduma, kam ˈwanda teena malang nda ɗimiyid ndan, kalnda kukwasharya fa tsawa nda hai, na nda a irang fishe fandan fa. ");
INSERT INTO hwo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A far ngwala ƙǝshiirha, na Taya tǝ Saduma haɗang nda Faara fa ama kun. ");
INSERT INTO hwo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sa ƙǝm Kafarnahum; tamngga ndaarha, nanda a mano a talara wa? Awo! Na ɗǝrha hu hwanga ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kala niifa sǝkka kun, nggini sǝknǝn, niifa kargha kun nggi karnǝn, kala tǝ karrǝna, karnǝn niifɗi thlǝngga nggi ɓa.” ");
INSERT INTO hwo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nafini kumnggit mǝd kap sǝri ɗi wunda ɓa tǝ wutsǝfayirha fa, ndang ngganda Yeeso, “Chinan, kahat tǝ ǝnkaheeya nanda sǝk kan a ndangɗan kanda kyama sǝ ahu thlǝm wa!” ");
INSERT INTO hwo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ndangga Yeeso kanda, “Na ɗi Sheetan mukɗa hai a talara ƙǝla kyatta ˈyaara. ");
INSERT INTO hwo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kama thlǝmarha hai, fǝrang ɗi sǝsǝmnda kun na a ishanggun huthlingya hai tǝ ngǝrɗaya, nun a kal fa mbǝlfeeya mba nda nang ˈya kun fa wa ko ngguchit. ");
INSERT INTO hwo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma tsǝɗun wutsǝfayirha nanǝn ya ka sǝkna ǝnkaheeya kun wa, ǝnama wutsǝfayirha fa ƙǝsǝr chirethleng nda thlǝm nun hai a talara.” ");
INSERT INTO hwo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A sayidɗiya lǝghǝdɗǝ tǝ mbǝnafarha fa a fad Sǝsǝna tǝ peɗǝnda, ndǝghǝn, “Usaɗi sa Pǝpa, china yi talara tǝ hweeɗe, ƙǝsǝr ɓǝɓengna tur ǝngginiya a Fasǝngya tǝ fa hutengya, kyaɗang nan wundakhnaya nǝghǝn kee Pǝpa, ƙǝsǝr ǝnɗiya ndǝ kamogha. ");
INSERT INTO hwo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pǝpa fǝreɗǝ ˈya na heu, mbǝ niifasǝ sǝngga wanɗi wa ƙǝl chin kee, tǝ ƙǝmɗa tǝ sǝngga wunni chin ɗi, ƙǝl wanɗi tǝ niifa na mid wanɗi kyaɗanggǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kyahargha thlǝmad fatsahayighǝn ɓa, ndanggǝn kanda katendan, “Kun nun tǝ parka katǝrana ǝnggina hai ya a yinnun! ");
INSERT INTO hwo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Niya pǝranggǝn kun, annabiya tǝ kutǝrya hangga mindan sǝ na ǝnɗi nun a naarha nanǝn ya, nawa ndan wa, tǝ ƙǝm sǝk ǝnɗa nda nun a sǝkrha ya, sǝkkwandan wa!” ");
INSERT INTO hwo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na niifa sǝ tǝ sǝn ɗeleewar tǝ chireelth na Musa, ishgha sǝ ƙǝt nǝn a ƙǝƙǝrang nda Yeeso. Ndanggǝn, “Mala, ni naarha ƙǝn na a wal yibrha ni mbuwa ngwalarha?” ");
INSERT INTO hwo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ndangga Yeeso, “Mani chirethleng nanda hai ahur ɗeleewar ɗi? Na karataghǝn ƙǝƙǝn?” ");
INSERT INTO hwo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nggǝmanggǝn, “Nggǝmu Chinǝm na Faara tǝ hurwa heu, tǝ yiɓǝd wa heu, tǝ kanglanggid wa heu, tǝ huten wa heu. Nggǝmu tulat wa ƙǝla alten wa.” ");
INSERT INTO hwo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ndangga Yeeso, “Nggǝmangna mǝmǝl, ǝno kee na wal yibrha.” ");
INSERT INTO hwo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kamshiɗiwu, na midghǝnsǝ na hǝrghanggǝn fadghǝn tsahang mee nǝn Yeeso, “Wunni tulat na?” ");
INSERT INTO hwo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nggǝmangga Yeeso tǝ laɓara, “Na niifa sǝ thliigha a Urshelima ɗǝnǝn Djariko ɗǝ, mukka ahar fa thlee kwamangya fa hai, ɗǝkƙǝnda ƙǝɗanggan nda hai tawalth, malghǝn nda a pathlang yibrha tǝ mǝra. ");
INSERT INTO hwo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na firis sǝ tǝrgha kwaman ɗi, ɓa walghǝn kalth mbǝrgha ɗǝ tǝ man patu. ");
INSERT INTO hwo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na tǝ Lawirha sǝ ƙǝm tǝrgha kwaman ɗi. Na nǝn ndǝn kalth, ndǝghǝn nggima mbǝrgha ɗǝ tǝ man patu. ");
INSERT INTO hwo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na tǝ Samariyarha sǝ tǝrgha kwaman ɗi, ɓa a walghǝn kalth, haɗanggǝn fa. ");
INSERT INTO hwo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɗǝgha thlǝmadghǝn ɗǝ, tsaɓang wundǝdghǝnǝn ɗǝ tǝ aam annab, irang fǝɗeerha nǝn sǝ, ƙǝnanggǝn nǝn. Tǝranggǝn a ƙǝsǝr kwarghǝn sǝ ɗǝgha tǝghǝn a ƙǝn rongya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ɗalthna mbǝrha hai haranggǝn wuɗǝɓǝl wurirha sǝ sǝri fǝranggǝnǝn tǝ mindǝɗi, ndanggǝn, ‘Kǝlee niifɗa ha ya ˈya ɓǝlangna heu a kwasamad ǝnɗi furo ni ya, a wudɗiɓa ɓa ɓani nggeroƙǝn ha.’” ");
INSERT INTO hwo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tǝrgha Yeeso ndanggǝn, “A hur nafini na mahan ya, wunni tulat kamshiɗi mukka ahar fathlee kwaman nggina fa?” ");
INSERT INTO hwo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ndangga tǝ sǝndǝɗi, “Niifɗi haɗangna niifɗa fa, ndǝna tuladghǝn.” Ndangga Yeeso, “Ɗuwaɗǝ a ǝno kee.” ");
INSERT INTO hwo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeeso tǝ fatsahayighǝn kanda aten wiirha, ɓa kyarha hu tala hai, na nuneefa sǝ thlǝmnggǝn ni Marthla. Thlǝghǝnǝn fa a minda keeghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na wanman Marthla sǝ, thlǝmnggǝn ni Mairamu, ɓagha ɓa tsauka hai a thlǝmad Yeeso ndǝghǝn a kang thlǝmarha fa. ");
INSERT INTO hwo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marthla ƙǝm tar ǝnnarhami tǝrang ɗǝ tenggǝn ɗǝ. Tǝrgha ɓaa thlǝmad Yeeso ɓa ndanggǝn, “Paɓa, mba naghǝn wa yina wanmana maleɗǝ tar ǝnnarhami fa katenna? Ndang ɓagha ɗee sǝ lee.” ");
INSERT INTO hwo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ndangga Yeeso, “Marthla! Marthla! Sa a ƙǝtǝlang fadwa fa aten fingya ǝngya hangga. ");
INSERT INTO hwo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ˈYa tǝtal ni kee nanda kaɗaarha, Mairamu wurɗǝ ˈya na ngga, ƙǝsǝr mbǝ niifa sǝ na mbang thlang a harghǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Farɗa sǝ, Yeeso a hwan Faara a mbǝrha. Ngwalanǝn, tǝrgha tal ahur fatsahayighǝn ndanggǝn, “Paɓa, tsahang kwaman hwan Faara kan ha, ƙǝla tsahangna Yahaya tǝ Mbaptisǝma fatsahayighǝn ha lee.” ");
INSERT INTO hwo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ndangga Yeeso, kanda, a naɗun a hwan Faara ndama, “Chinǝm na a talara, a chilɓi thlǝm wa nǝm ha, kutǝryid wa ɓagha ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fǝrang ǝnnarhami kan yi weeriya tǝ yi ɓengya na ɓayi. ");
INSERT INTO hwo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chahang ɗimiyin nan kanɗǝ, ƙǝla nan chahanggǝn fingyaɗǝ ǝnangga ɗimiyirha kan fa. A ɗǝnna tǝ kan ahu ƙǝƙǝrra ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nggǝrgha Yeeso ndangnda fatsahayighǝn, “Ndam tal ahur nun nǝghǝn tǝ pashirha, ɗǝgha thlǝmadghǝn ɗǝ a manad fǝɗigrha ndanggǝn, ‘Wayee ǝne kumad mburodi ha mahan lee. ");
INSERT INTO hwo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ƙǝsǝr, na pashinna sǝ ɓaa ɓa ka wiirha tǝrɗa hai a kyana nanǝn ya. Kǝmɗa mbǝ ǝnnarhami sǝ a har na wa.’ ");
INSERT INTO hwo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tǝrgha, andam pashidɗi kaɗagha kumarha a harghǝn, nggǝmngga ɓa a ƙǝn ndǝghǝn, ‘A ɓillanna nggi wa. ˈWaɗi teena changɗi kwatminda, kan tǝ wanggina hunaɗan hai, mbi mbang thliirha sǝ furo ˈya ni wa?’ ");
INSERT INTO hwo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Niya ndangnda kun, a mbǝ a thliirha sǝ fǝrang ˈya nǝn ka tsaunǝn pashidghǝn wa, nǝn thlid sǝ fǝranggǝn tǝ kurmi na midghǝn. Ƙǝsǝr pashidghǝn ƙǝswa shilee ndǝn tǝ hwandǝɗi hwanang nǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Niya ndangnda kun, hwanama nanda fǝrang kun. Kaɗama nun a waala. Nama a ɗǝk kwatminda, nanda inanggǝn kun hai. ");
INSERT INTO hwo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ƙǝsǝr kala niifa hwangga, nanda a fǝrang, niifa kaɗagha ƙǝm nǝn a waala. Kǝmɗarha kala niifa ɗǝkka kwatminda nanda inanggǝn hai. ");
INSERT INTO hwo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wunni ahur nun, a hwanang wanggǝn tǝna fǝrang huthne nǝn? ");
INSERT INTO hwo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tǝ ƙǝm a hwanang wanggǝn nggal ɗiyarha fǝrang ngǝrɗarha nǝn? ");
INSERT INTO hwo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A tsauɗǝ, kun na fa mbǝlfeeya sǝnɗun ˈya nun fǝrangnda wangginun ǝngya na ngga, sakwata chinun a talara, nǝn fǝr Sǝsǝna tǝ Peɗǝnda a nafiya na hwanda.” ");
INSERT INTO hwo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yeeso ƙǝnangɗǝ niifa ƙǝnangna ǝnkaheerha miighǝn, hǝrǝmna ǝnkaheedɗi kyarha sǝ a fadghǝn, katǝranggǝn ndikrha hai. Tǝrgha fiya ngwagha hai na ǝnwulteena nda. ");
INSERT INTO hwo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A mbǝɗi na fingya nafiya sǝ ndaa nda, “Mbaˈaldzabul ni kutǝr ǝnkaheeya fǝrangga ngyakhad ɗiya yi kyang ǝnkaheeya sǝ?” ");
INSERT INTO hwo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Fingya sǝ na mindan sǝ ƙǝƙǝrangganda Yeeso, ndang ngganda, a ǝna ǝnwulteena nǝn kyadgha ndaarha na Faara tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tǝrgha Yeeso walang ɗǝ numan ndan, ndanggǝn kanda, “Kala kutǝryirha ɗǝkka hai sǝri, nanda yanda tǝ ndan, kutǝryidɗi mbǝ isha wa. Nǝghǝn kee ƙǝm a ɗǝk wure hai sǝri kanda a yanda, wuriɗi nǝn weela ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A ndǝk Sheetan hai mbǝdghǝn sǝri, nǝn yan altenggǝn, ƙǝƙǝn na kutǝryirha ɗǝrha mbeeɗǝ? Nduwun tǝ ngyakhrha Mbaˈaldzabul ni kyangnda ǝnkaheeya sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anaɗǝ tǝ ngyakhrha Mbaˈaldzabul ni kyang ǝnkaheeya sǝ, fa tsahayinun wu? Tǝ ngyahad wun nanda kyang nda sǝ? Fa tsahayinun ni ngwang kumarha kun sǝ aten yanɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anaɗǝ tǝ sǝsǝmnda Faara ni kyang ǝnkaheeya sǝ, tsauɗǝ kutǝryid Faara ɓaɗǝ thlǝman nun ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Niifa na kanglang, a ngwaɗa fa ngga, ndǝghǝn a ƙǝla wurighǝn ha, kari wurighǝn mbǝ ˈya sǝ walghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aɓad niifa ɓa ƙǝm kalgha ndǝn mu kanglanggirha, harghǝnǝn yanda, ɗǝghanggǝn hai, thlanggǝn kari yandǝɗi mbǝrsanǝn sǝ, tǝrgha ndǝghanggǝn kari ɗaɗǝ thlang nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Niifa mbuwana midghǝn nggi, nǝghǝn a tsan nggi. Niifa ɗewa sǝ wumndǝghǝn, tǝ waleng nda ni ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“A kyad ǝnkaheerha sǝ tǝ imǝnda a fad niifa, nǝn naarha wiirha hai a mbǝǝya mbuwana aama sǝ ka a wal mbǝd yibrha nǝn. A walwa wa, nǝn ndaarha, ‘Ni wutta wuri ɗa ɗǝ kyani sa ɓa.’ ");
INSERT INTO hwo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A ɓaɗa ɓa walɗǝ wuriɗi ngwangnda ɗǝ, tangsangnda wuriɗi ngga, ");
INSERT INTO hwo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nǝn a wutta ɗǝgha ngwangnda ǝnkaheeya ɓa mǝd kalgha ndǝn mbǝlfeerha, ɓaanda tsaurha a mbǝɗi. A kwasamadghǝn, tsawud niifɗiya sǝssadghǝn nǝn kal yi kaar.” ");
INSERT INTO hwo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na Yeeso a thlǝk ǝngginiya, tǝrangga nuneefa uradghǝn sǝ a pathlang fiya ndanggǝn, “Tǝ parka ni nuɗi nggǝtgha sa, har ƙǝronǝn sǝ ya!” ");
INSERT INTO hwo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nggǝmangga Yeeso ndanggǝn, “Haˈi nǝghǝn kee, amma parkayirha kalɗǝ tsaurha afad nafiya na a sǝk laɓar Faara, kanda na taara sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na fiya aten chik ɓaarha thlǝmad Yeeso ɓa, ndǝghǝn, “Nafiya ƙǝshiid weeriya fa mbǝlfeeya ni. Na mindansǝ a kyaɗang ǝnwulteena nda kanda, mbǝ ǝnwulteena sǝ nanda kyaɗang kanda pak wa ƙǝl yi Yunana. ");
INSERT INTO hwo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kǝla tsauna Yunana ǝnwulteena a nafiya Nineba, Wan Niifa ƙǝm nǝn tsaurha kee a nafiya ƙǝshiid weeriya. ");
INSERT INTO hwo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A far nggwala ƙǝshiirha, kwatamnda man ki pǝlasarya, nǝn a thliirha ɓa heu tǝ nafiya ƙǝshiid weeriya, kyaɗang ndaarha nǝn kanda ǝnawun mǝmǝl wa. Ɓaghǝn ɓa a mbǝrha na inggun ka ɓagha sǝk sǝnda Sulemanu. Nanǝn ya kulo niifa kalgha Sulemanu a mbǝɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A far nggwala ƙǝshiirha, Ninebaya nanda a thliirha sǝ tǝ nafiya ƙǝshiid weeriya kyaɗang ndaarha nǝn kanda ǝnawa nda mǝmǝl wa, ƙǝsǝr kanda malangnda ɗimiyindan, ka laɓar Faara thlǝghangna Yunana kanda. Nanǝn ya, kulo niifa kalgha Yunana a mbǝɗiya!” ");
INSERT INTO hwo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mbǝ niifa sǝ na njangnda patilla ɓǝɓenggǝn wa, nduwa tsǝɓanggǝn tǝ tǝɓa. Kǝl nǝn ɗǝfang nda a pǝpal na a kya niifa ɓa, na kukwaryirha nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yirha ndǝna kukwaryit farha, ana yidwa kanglang hai, fadwa na heu nǝn naarha tǝ kukwaryirha. A mbǝ yidwa kanglang wa, fadwa na heu nǝn naarha hu wula. ");
INSERT INTO hwo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kulo sa hai, kukwaryirha nana tǝghǝn mbǝ wulani wa. ");
INSERT INTO hwo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ana fadwa na heu tǝ kukwaryirha, mbǝ mbǝrha sǝ na tǝ wula wa, fadwa na heu nǝn njaara hai, ƙǝla na kukwaryit patilla ǝnaarha.” ");
INSERT INTO hwo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ngwalana Yeeso laɓara, tǝrgha tǝ Farisarha mbu Yeeso nǝn wuri keeghǝn ɗǝ ka hǝb ǝnnarhami ɗǝ. Ɗǝgha Yeeso ɗǝ tsauka hai a hǝb ǝnnadɗa mii. ");
INSERT INTO hwo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kǝla na tǝ Farisadɗa hai katǝrang Yeeso hǝbrha hai kula tsaɓang harghǝn ɗǝ wulangga teena. ");
INSERT INTO hwo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ndangga Chinǝm, “Kun Farisaya, nun tsaɓang ƙǝsǝr tafarha ɗǝ tǝ ɗengnda nagha hur nun lǝlǝgɗa tǝ hukrha tǝ mbǝlfeerha. ");
INSERT INTO hwo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nurya kee, mbǝ Faarani ǝnagha ƙǝsǝrɗi tǝ hurɗi wa? ");
INSERT INTO hwo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Amma fǝrama ˈya na a har nun a fa yamiya, ˈya na heu na yinun nǝn naarha tsǝtsaɓaɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kawa ma, Farisaya! Nun fǝrangnda Faara tal ahu kum shi chimbee tǝ fingya shi kyahangya na heu. Malanggun tar ƙǝkafek tǝ nggǝmnda Faara. Tur ǝnggina niya kamngga ǝnon, kamngwa malanggun fingya wa. ");
INSERT INTO hwo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kawa ma Farisaya! Na minnun sǝ a fǝrang mbǝd tsaurha nun kun na ngga ahu Ƙǝn Faara tǝ ƙǝmɗa nagha fiya a ndang ˈya kun ahu kasu. ");
INSERT INTO hwo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kawa ma! Nuwun ƙǝla kwat mǝrya na fiya a wiirha atenggǝn ka yamid sǝnda.” ");
INSERT INTO hwo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tǝrgha niifa tal ahur Fasǝngya ngyakhrha, ndanggǝn Yeeso, “Mala, a ndanna kee, ˈyarna kan ƙǝm!” ");
INSERT INTO hwo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nggǝmangga Yeeso ndǝghǝn, “Kawa ma kun Fasǝngya ngyakhrha! Fǝrang rǝfrha nun fiya na haghǝn, kun tǝ alten nun ˈwawun tsuwarghǝn fa tǝ wan haara tal a thlar kanda nun wa. ");
INSERT INTO hwo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kawa ma, tǝnɗun ten kwaya na nggǝngga ka a mananggun annabiya Faara, ɓǝlangna chichiyinun kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kun tǝ alten nun naɗun ndǝn, ƙǝmɗa nggǝmɗun fa tǝ ˈya ǝnana chichiyinun. Ɓǝlangganda annabiya, kun ƙǝm tǝnanggun ten kwayindan. ");
INSERT INTO hwo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nanǝn kee, ndǝn ndana sǝnda yi Faara, niya thlǝnang annabiya kanda ɗǝ tǝ Fatsahaya, nanda a ɓǝlang fingya, sǝsangganda fingya. ");
INSERT INTO hwo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tsaunǝn kee, na Faara a ngwang kumarha nafiya ƙǝshiid weeriya aten ɓǝla, ɓǝlang na nda annabiya ɗǝ na heu, ka katǝra ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ka aten far Habila ɗǝgha hu yi Dzakariya ɗǝ ɓǝlang na nda a pathlang mbǝd sataka tǝ mbǝrha na Tsǝtsaɓa ɗǝ ahu Ƙǝn Faara. Niya pǝranggǝn kun nanda a ngwang kumarha nafiya ƙǝshiid weeriya ƙǝsǝr ka nafini na heu ya. ");
INSERT INTO hwo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kawa ma, Fasǝngya ngyakhrha! Kǝsɗun ǝn cha kwatmin sǝnda ha. Kun tǝ alten nun kyawun saɗǝ wa, malanggun fiya na mindan kyarha sa ɗǝ, kya nda ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Malangna Yeeso mbǝɗi, Fasǝngya ngyakhrha tǝ Farisaya katǝrang ngganda tsandǝghǝn hai, na nda a dzaramnggǝn tǝ tsakh miiya. ");
INSERT INTO hwo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Na mindansǝ ɗǝfang takthleera nda ka a thlǝk ˈya nǝn mbuwa mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wumna fiya ɓa hangga har kanda ishang ndan hai, katǝrangga Yeeso tsǝ laɓara ˈwan tǝ fatsahayighǝn, ndǝghǝn, “Kwarama tǝ mehen Farisaya ndǝna thlǝrɓuyirha. ");
INSERT INTO hwo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mbǝ ˈyasǝ na nggǝnggǝla mbuwa inɗaɗǝ wa, tǝ ƙǝm mbǝ ˈyasǝ na ɓǝɓee mbuwa kyarha pǝpal ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kala ˈya thlǝknun ɓǝɓee na fiya sǝƙǝn a pǝpal, ˈya thlǝknun ƙǝƙǝɗak nanda a kalmiighǝn ɗǝ sǝkƙǝna fiya. ");
INSERT INTO hwo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Niya ndang kun shayina, a tǝrǝmɗun nafiya na a ɓǝl farha wa, a kwasamadɗi ɓǝlang na nda, mbu ˈyasǝ nanda naarha ɓal wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Niya pǝrang niifa kun nun tǝrǝmnda, tǝrmama Faara na tǝ sǝsǝmnda ɓǝlang nda farha, a kwasamadghǝn muwanggǝn ahu hwanga ɗǝ. Kǝkafek niya pǝranggǝn kun tǝrmama Faara! ");
INSERT INTO hwo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mbǝna nda heng wuɗikkya ɗǝ tuf pene sǝri wa? Ko tǝtali ahur ndan mbǝɗangwa Faara wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko was tengginun ni ma nǝghǝn thlǝthlǝɗa. A tǝrǝmɗun wa, ƙǝsǝr kalɗun wuɗikkya kaan!” ");
INSERT INTO hwo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Niya ndang nda kun, kala niifa ndagha sǝnɗǝ nggi a mbed fiya, Wan Niifa ƙǝm nǝn a ndaarha sǝnɗa ndǝn a mbed fathlǝngya Faara. ");
INSERT INTO hwo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Niifa ƙǝm ndaarha sǝngwa nggi wa a mbed fiya, nggi ƙǝm ni ndaarha sǝngwi ndǝn wa a mbed fa thlǝngya Faara wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kala niifa na thlǝk pathla mbuwa ngga aten Wan Niifa na nda chahanggǝnɗǝ. Amma niifa sargha Sǝsǝna tǝ Peɗǝnda mba nda chahanggǝn ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A ɗǝn nda tǝ kun a mbed mamngya Ƙǝn Faara ɗǝ, tǝ fa ngwa kumaya, tǝ kutǝrya, a ɓillaɗun tǝ kwamana nun a kyang altennun sǝ wa, ko tǝ pathla nun a nggǝrang kanda sǝwa. ");
INSERT INTO hwo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ƙǝsǝr Sǝsǝna tǝ Peɗǝnda nǝn a tsahang ˈya kun ha kamngga a thlǝwun.” ");
INSERT INTO hwo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tǝrgha niifasǝ ahur fiya ndanggǝn Yeeso, “Mala, ndang wan mana fǝre yina langaarha nǝn malang na mǝra chinan kan hai.” ");
INSERT INTO hwo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tǝrgha Yeeso ndanggǝn, “Kaiya wayee, wun ɗǝfegha tǝ ngwa kumarha, ni ɗǝk langaarha?” ");
INSERT INTO hwo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tǝrgha ndanggǝn kanda, “Kwarama fa, nama inggun tǝ ˈya na ɓarha ɓa tǝ kwit hura, ƙǝsǝr yiɓǝd niifa kalɗǝ ǝn ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Fǝrang karapu nǝn kanda ndǝghǝn, “ˈWad tǝ ƙǝna naarha sǝ walgha ǝnnarhami ahu hedghǝn kaan. ");
INSERT INTO hwo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ndagha, ‘Mbǝ mbǝd ɗǝf ǝnnadɗami sǝ kyana wa. Mani naarha?’” ");
INSERT INTO hwo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ndǝghǝn, ‘Yoo! Sǝnɗi ˈya niya naarha. Niya fǝlang ɓiriukina ɗǝ ya, tǝn fingya ni na mǝmanggǝn, iranggi ǝnnannami sa hai tǝ karinna heu.’” ");
INSERT INTO hwo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndanggi altenna, “Kai! Na ǝngyasǝ na nggǝngga tǝ ǝnnarhami ɗǝfangna ɗǝ yi huraya hangga. Yiɓu, hǝɓu, saana tǝk mbǝnda na fa.” ");
INSERT INTO hwo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Amma Faara ndanggǝn, ‘Sa nura! A fǝɗigɗi ya na nda a kaɗa yiɓǝdwa. Kariɗi ɗǝfangna ɗǝ ya nǝn a tsaurha yi wun?’” ");
INSERT INTO hwo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ngwalangga Yeeso pathɗiya tǝ ndaarha, “Nǝn tsaurha kee tǝ niifa wumangga ƙǝna hai a altenggǝn, amma a mbed Faara tǝ yaminni.” ");
INSERT INTO hwo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ndangga Yeeso fatsahayighǝn, “Niya ndang nda kun, a ɓillaɗun tǝ yiɓǝd nun, tǝ ˈya nun ǝnnarhami, tǝ ƙǝm ˈya nun kala fa wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ƙǝsǝr yibrha kalɗǝ ǝnnarhami, farha ƙǝm kalɗǝ lukkya. ");
INSERT INTO hwo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kǝla man wuɗikkya lee! Mba nda hǝfrha wa, mba nda hathla wa, mba nda tǝ ƙǝn ǝnnarhami ko ɓiriukya wa, ko nanǝn kee na Faara fǝrang ǝnnarhami kanda. Sǝngunsǝ mamnggit nun kalɗǝ yi wuɗikkya wa? ");
INSERT INTO hwo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wunni ahur nun aten ɓilladghǝn na mbang chik ɓenggǝn, ko yi ɓeena tal ahu ƙǝshiirha? ");
INSERT INTO hwo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A mbun a mbang ǝna ˈya ngguchit ƙǝla yanɗiya wa, ƙǝn nun ɓillarha aten fingya ǝngya na mid nun? ");
INSERT INTO hwo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kǝla man fid ɗǝfya na nda tsǝrha. Mba nda na taara, ko pu kaɓarha wa. Nanǝn kee, niya ndang nda kun, ko kutǝra Sulemanu tǝ mamnggitghǝn ˈwa wa ngwarha fa ƙǝla tal ahur ndan wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ana Faara a ngwang nda hwalirha fa na a hee kiya, hwalirha nasǝ aweeriya, a ɓinda ƙǝm njigha ɗǝ, sakkwa kun nǝn ngwang kun fa? Kun fa yamid fǝrƙǝkafek! ");
INSERT INTO hwo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","A naɗun a numarha aten ǝnnarhami ko ǝn sarha wa, ma ɓillaɗun aten ǝnggini ya wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nafiya sǝngwa Faara na nda kaɗa tur ǝnggini ya, amma Chinun sǝnɗǝ ˈya na minnun. ");
INSERT INTO hwo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kun nggi kaɗama kutǝryid Faara, ǝnggini na heu ƙǝmya nǝn fǝranggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kun chiɓrha na ngguchit, a tǝrǝmɗun wa, ƙǝsǝr Chinǝm nǝn a tǝk mbǝndafa a fǝrang kutǝryidghǝn nǝn kun. ");
INSERT INTO hwo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Heeman ˈǝngginun ɗǝ na heu, fǝrang wuɗǝɓǝlghǝn nun fa yamiya. Ɗǝfaman ƙǝna altennun ɗǝ mbuwa ngwalarha, ƙǝna mbuwa sǝbrha ɗǝ a talara, mbǝrha mbuwana ngaara kyarha ɗǝ ɗǝgha tǝrang, tǝ mbǝrha mbuwana mǝmemngya sǝɓang ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ƙǝsǝr mberha na ƙǝnawa sǝ, ndǝna mbǝd numad wa.” ");
INSERT INTO hwo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ngwama fa ka taara, patillan nun njinji. ");
INSERT INTO hwo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tsawama ƙǝla mafaya na ƙǝla turi ndan fa na wutta ɓa ahu wutsǝfayid kakhrha. A Wudɗa ɓa ɗǝk kwatminda nǝn, nanda inanggǝn hai wet. ");
INSERT INTO hwo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nǝn naarha ngga a fad mafayini a wud turi ndan ɓa, a ɓaɗǝ wal kanda a ƙǝlarha ka taara. Niya ndang nda kun, nǝn a kalang kaɓadghǝn hai kal yi taara nǝn, ndanggǝn kanda tsawama hai, fǝrang ǝnnarhami nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nǝn naarha ngga a fad mafayini a wud turi ndan ɓa a manad fǝɗigrha, ko ahar tsar aɓaɗǝ wal kanda nggungwa fa.” ");
INSERT INTO hwo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nggǝrgha Yeeso thlǝghang karapu kanda, ndǝghǝn, “A sǝn ture sayidɗi na ngaara a kyarha wuri keeghǝn hai, mbǝ malang nda kyagha sa hai wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kun ƙǝm tsawama nggungwa fa, ƙǝsǝr Wan Niifa nǝn a wutta ɓa a sayidɗi sǝngwa nun sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ndagha Mbiturus, “Paɓa, karapu ɗiya aten nan ǝnana nan wa, nduwa aten fiya na heu wa?” ");
INSERT INTO hwo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nggǝmangga Chinǝm ndǝghǝn, “Tsawama ƙǝla mafadɗi na tǝ ƙǝkafek na ndǝndǝl ƙǝm, ɗǝfangna turighǝn aten mafayighǝn, na fǝrang ǝnnarhami kanda a sayidɗi kamngga. ");
INSERT INTO hwo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nǝn naarha ngga a fad mafadɗi ɓana turighǝn walghǝn a ǝna targhǝn mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kǝkafek niya pǝranggǝn kun, nǝn ɗǝfang mafadɗi aten karidghǝn na heu. ");
INSERT INTO hwo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amma a ndang mafadɗi altenggǝn, ‘Turina ɓawaɓa wet wa,’ tǝrgha katǝranggǝn ɗǝk mafaya nishya tǝ hǝshya, kyagha hu hǝbrha hai tǝ sarha nagha a tǝrang teena. ");
INSERT INTO hwo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Turi mafadiya nǝn a wutta ɓa a fara sǝnngwanǝn sǝ. Turiɗi wu nǝn ɗǝkƙǝn kaan wumanggǝn tǝ nafiya na ɗimi.” ");
INSERT INTO hwo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mafadɗi sǝngga ˈya na mid turighǝn a ǝnagha, amma ngwawafa wa, tǝ ƙǝm ǝnawa ǝnɗi ndang nanda a ǝnagha wa, na nda a tsaɗaghǝn kaan. ");
INSERT INTO hwo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amma niifa sǝngwawa sǝ, a naɗǝ ˈya kamngga a tsǝtsǝlghǝn nda, na nda ɗǝkƙǝn ngguchit. Kala niifa fǝrang nda ˈya hangga, na nda kaɗa ˈya hangga a harghǝn. Niifa fǝrang nda ˈya hangga kaan, nanda kaɗa ˈya hangga a harghǝn kaan.” ");
INSERT INTO hwo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tǝrgha ndagha Yeeso, “Ɓani hu ƙǝshiirha ɓa tǝ ngwa kumarha na ƙǝla waarha. Ana nggǝmndǝna ni kam njang nda ɗǝ! ");
INSERT INTO hwo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na mbaptisǝma sǝsaarha sǝ na nda a ǝneerha, ɓillaɗi kaan na a ǝneeƙǝn nda! ");
INSERT INTO hwo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tamnggun ndaarha ɓang ni tsawud ɗǝɗemnggirha ƙǝshiirha ɓa wa? Awo! Niya ndang nda kun, ɓaniɓa tǝ tsakhrha hai. ");
INSERT INTO hwo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nanǝn ya, ahu wure tal nafiya tuf nanda tsakhrha hai pǝmnggǝn sǝri, nafiya mahan a tsan nafiya sǝri, nafiya sǝri ƙǝm a tsan nafiya mahan. ");
INSERT INTO hwo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","China nǝn tsan wanggǝn. Wanɗi ƙǝm nǝn tsan chin. Man nǝn tsan wutaradghǝn, wutaradɗi ƙǝm a tsan man. Thlaɓǝrra nǝn tsan nu wanggǝn, nu wanɗi ƙǝm nǝn tsan thlaɓǝrghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tǝrgha ndanggǝn fiya, “A naɗun hashmbe a man hǝmnda faara ɓa, nun ndaarha ‘Na ˈyaara ɓayi,’ ɓagha hai. ");
INSERT INTO hwo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A na ɓereurha ɓayi manki pǝlasarya ndon ‘Na ƙǝrta a naarha sǝ’, tǝrgha naghasǝ. ");
INSERT INTO hwo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Fa thlǝrɓuya! Mbangɗun sǝnang kyaharra mbǝrha hai na a hweeɗe tǝ fǝrakh-amshi, amma sǝnda ǝn ɓengginiya sǝnggundun wa. ");
INSERT INTO hwo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mani mbuwa nun numarha ǝna ˈya nun na ngga kun tǝ alten nun?” ");
INSERT INTO hwo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndagha Yeeso, “Kǝla ndam, a huhwad niifa sa, kaɗu kwamana na a tangsanggun pathlang nun a kwamana. A karna fa, ɗǝnǝn tǝsa a mbed tǝ ngwa kumarha ɗǝ. Tǝ ngwa kumarha ƙǝm nǝn fǝrang sa wan sǝsalya. Wan sǝsalya ƙǝm na nda muworha ƙǝnɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Niya ndorha, mba kyarhaɓa wa ƙǝl tiina ǝnɗi kyo nanda heu.” ");
INSERT INTO hwo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nanǝn ya fingya sǝ a mbǝɗi, pǝranggǝn nda Yeeso laɓar Nggalilaya ndana Mbilatus a ɓǝlang ngganda kanda. Tǝrgha sodjaya ɓǝlangganda nafini a farɗi nanda a fǝr satakh ndan a Faara. ");
INSERT INTO hwo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nggǝmangga Yeeso kanda, ndǝghǝn, “Ka ɓǝlang nanda Nggalilayini kee, tamnggun ndaarha kalnda fiya na heu ɗimiyirha a Nggalili wa? ");
INSERT INTO hwo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awo! Niya pǝranggǝn kun, a malanggun ɗimiyid nun wa, kun na heu nun a mǝra ƙǝla kanda. ");
INSERT INTO hwo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nduwa ƙǝm, ƙǝla nafini na kumkap uvaɗaɗi chana tǝndǝɗi na dzang a tendan hai a Siluwan, ɓǝlanggǝn kanda, tamggun ndaarha kalnda fiya na heu a Urshelima ɗimiyirha wa? ");
INSERT INTO hwo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awo! Niya pǝranggǝn kun, a malanggun ɗimiyid nun wa, kun na heu nun a mǝra ƙǝla kanda.” ");
INSERT INTO hwo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tǝrgha Yeeso fǝrang karapu nǝn kanda, ndǝghǝn, “ˈWad niifa naarha sǝ na tǝ shiɓarha ahu hedghǝn, ɓagha ɓa ka a ɗakh wanggǝnǝn hai, walwa ko tǝtal wa. ");
INSERT INTO hwo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsaunǝn kee, ndanggǝn niifɗi na a ƙǝla hedɗa ha, ‘Kulo a weeriya hurarha mahan nggi a ɓaarha ka kaɗa wan shiɓadɗa ɓa ya, ˈwawi wal wee atenggǝn wa. Kyathlang ɗǝ! Kama nda nǝm malang sǝ ˈwanggǝn mbǝrha hai ka?’ ");
INSERT INTO hwo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tǝrgha tǝ ƙǝla hedɗa ha ndanggǝn, ‘Paɓa, malang sǝ, hasang chehweerha ni mu, irang thlii ˈwalya ni mu ahu huradɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A nggǝdɗǝ a mbee tsaukwa sǝ, a nggǝtwa wa a kyathlanggǝm ɗǝ.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Farɗasǝ Yeeso a tsaharhaha a Ƙǝn Faara a far yibrha. ");
INSERT INTO hwo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na nuneefa sǝ ǝnangna ǝnkaheerha wan haarha fa, sǝfnanggǝn yi hurarha kumkap uvaɗa. Nǝghǝn ƙǝƙǝɓa hai mbǝ mbang pǝpǝnɗa sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nana Yeeso ndǝn, aaghǝnǝn ndanggǝn, “Sa nuɗiya, ƙǝnonda ahu wan hadwa.” ");
INSERT INTO hwo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tǝrgha ɗǝfang haara nǝn teena, a mbǝɗi tsu, pǝpǝnggasǝ ɗǝfang shilee nǝn Faara teena. ");
INSERT INTO hwo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tǝrgha mamnda ƙǝn hwan Faarɗi sǝbgha hurghǝn ɗǝ, ƙǝsǝr ka ƙǝnangna Yeeso nuɗi a far yibrha. Ndanggǝn nafini na a mbǝɗi, “Far taara mikki kamngga ana taara nǝm, ɓamaɓa hu ɓengginiya ƙǝnangganda kun mbǝ a far yibrha wa.” ");
INSERT INTO hwo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ndangga Chinǝm kanda, “Fa thlǝrɓuya kee! Ashe, mbun kwasang thladnun sǝ tǝ kwarnun ɗun kyaɗang aama a far yibrha wa? ");
INSERT INTO hwo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nuɗiya chichid Ibrahim ni, ƙǝnangna Sheetan hai, a weeriya hurarha kumkap uvaɗa. Ashe, mbǝ mǝmǝl ƙǝnanggǝm a far yibrha wa?” ");
INSERT INTO hwo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A kwasamadɗi thlǝkna Yeeso laɓarɗiya, fingya na a tsanggǝn a mbǝɗi shiɗanggǝn kanda. Fingya nafiya ƙǝm, ƙǝl ǝna wutsǝfayirha nda heu, ƙǝsǝr ka ǝnwulteena ǝna nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tǝrgha ndagha Yeeso, “Na kutǝryid Faara ƙǝƙǝn? Tǝma nda ni sakhƙǝn sǝ? ");
INSERT INTO hwo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kutǝryid talara nǝghǝn ƙǝla wan parsǝna na wanggǝn ngguchit ahur wiiya na heu, tǝrang na niifɗa sǝ hǝfanggǝn hai ahu hedghǝn. Mangga tsauka ɗefrha, wuɗikkya ǝna ƙǝnna nda ahu wuhwaryighǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeeso nggǝrghǝn tsakh mee, ndǝghǝn, “Tǝma ni sakh Kutǝryid Faara? ");
INSERT INTO hwo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nǝghǝn ƙǝla mekhna yangna nuneefa tǝ humbarha tasau mahan, tǝrgha mehen ɗi wu chichaɗanggǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kǝsna Yeeso kwamana ɗǝnǝn Urshelima ɗǝ, kyagha hu talya hai na manggǝn tǝ na ngguchit nagha a tsahang fiya ha. ");
INSERT INTO hwo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsahangga niifa mee ha tǝ ndaarha, “Mala, nafiya ngguchit ni ƙee na wal yibrha?” Ndangga Yeeso kanda, ");
INSERT INTO hwo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Habɓama na a kyon sa hai tǝ kwatminda na iˈyaɓa, ƙǝsǝr na minna sǝ a sǝnunsǝ, nafiya hangga na a kaɗa kyarha sa hai, mba nda mbangnda wa. ");
INSERT INTO hwo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A thlid tuwure sǝ ˈwaɗǝ teena nggǝlangɗǝ kwatminda, kun nggi ƙǝm nun a isha a ƙǝshi non a ɗǝk kwatminda ɗi, non a ndaarha, ‘Ture inang kwatminda kan hai!’ Ndǝghǝnggi ƙǝm nǝn a nggǝmang kun ndagha, ‘Sǝngwi mbǝɗi kyanun saɓa wa!’” ");
INSERT INTO hwo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Tǝrgha nun a ndaarha, ‘Haba! Kǝm hǝɓǝm, sam tǝsa, har tsahannaha ahu talyi nan.’ ");
INSERT INTO hwo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amma nǝn a ndangnda kun, ‘Sǝngwi mbǝɗi kyanun saɓa wa, ndǝghama hai tǝ nggi, fa mbǝlfeeyini ya.’ ");
INSERT INTO hwo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Anaɗun Ibrahim tǝ Ishaku tǝ Yakubu, tǝ annabiya na heu, ahu Kutǝryid Faara, kun ƙǝm nanda a rǝk kun, a mbǝɗani nun a tǝrha tǝ ƙǝd mee. ");
INSERT INTO hwo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nafiya a ɓarhaɓa a man kyad fara tǝ man hǝmndǝghǝn, man ki pǝlasarya tǝ man ki wufaya, tsawanda a mbǝd mbǝnafarha fa ahu Kutǝryid Faara. ");
INSERT INTO hwo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A mbǝɗaniya, fingya na a samarha, nanda a tsaurha a mbee, fingya na a mbee ƙǝm, nanda tsaurha a samarha.” ");
INSERT INTO hwo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A kwasamadɗi ngwalana Yeeso laɓara, fingya Farisaya ɓaa nda ɓa ndang ngganda Yeeso, “Thliu a mbǝɗiya, ƙǝsǝr Hirdus na midghǝnsǝ a ɓǝloghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tǝrgha ndanggǝn kanda, “Ɗamaɗǝ ɗun pǝranggǝn tǝ thlǝrɓu ɗi tǝ ndaarha a weeriya ni a kyang ǝnkaheerha sǝ, tǝ ƙǝm ni a ƙǝnang nda fiya, aɓinda ƙǝm wai kee, a shikka ndǝ ni a ngwalang tarna. ");
INSERT INTO hwo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko nanǝn tsawee ɗafa a ɗi mbeeɗǝ tǝ winna nda weeriya tǝ ɓinda, ɗǝgha shikka ɗǝ. Kamngwa annabi mǝrgha a mbǝrha pak wa, ƙǝl a Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sa! Urshelima! Urshelima! Fa ɓǝl annabiya tǝ muk fiya thlǝnna nda thlǝman nun ɓa. Sara kurmi na minna wumanggi kun ƙǝla na ɗiyarha ngwamang wanggighǝn a kamughǝn ɗǝ, amma karɗun fa! ");
INSERT INTO hwo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kulo mbiya wuri nun mbǝ niifa sǝ wa! Ni a pǝranggǝn kun, mbun nggǝr na nggi wa, ƙǝl fara ndanun tǝ ‘Parkani tǝ ɓagha ɓa hu thlǝm Chinǝm.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A far yiɓǝd Yahudaya, ɗǝna Yeeso ka hǝb ǝnnarhami a minda ki mamnda tǝ Farisarha ɗǝ, djang yirha nda fa. ");
INSERT INTO hwo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A mbǝɗi ƙǝlagha hai niifa ƙǝt a mbedghǝn, saryighǝn tǝ haryighǝn hǝhǝthla hai. ");
INSERT INTO hwo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tsahangga Yeeso mee Farisayini tǝ fasǝngya ngyakhrha, “Ngyakhad Musa nggǝmɗafa a ƙǝnanggǝm niifa a Far Yibrha wa?” ");
INSERT INTO hwo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amma nggasa nda titib. Ƙǝsgha Yeeso har niifɗi, ƙǝnanggǝn ndanggǝn wiu fayi wa ");
INSERT INTO hwo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tǝrgha tsahangga Yeeso mee kanda, “Ndam ahur nun na niifasǝ na tǝ wanggǝn nduwa thladghǝn, mukɗǝ hu kwat aama hai afar yibrha, mbun ɗǝrhaɗǝ ɗun ƙǝɗang sǝ ƙǝkar wa?” ");
INSERT INTO hwo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mbangwanda kalasǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kǝla na Yeeso hai nafini mbunanda ɓa, wurnda mbǝd tsaukya na nggǝngga, thlǝghang karapu ɗa nǝn kanda sǝ ya. ");
INSERT INTO hwo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“A mbud niifa sa ahu wutsǝfayid kakhrha ɗǝ, ma tsauna a mbǝd tsawud mamngya wa. Nǝn ɓa naarha mbunda niifa ɓa kalgha sa mu mamnggirha. ");
INSERT INTO hwo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anaɗǝ kee, niifɗi mbuwa kun kyab, ɓagha ndorha, ‘Fǝrang mbǝd tsawud wa niifɗiya.’ Tǝrgha a mbǝɗiya na shilee ƙǝsorha, na thliirha a mbǝd tsaurha ɗǝ na ngguchit. ");
INSERT INTO hwo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amma a mbunda sa, wuru mbǝd tsaurha na ngguchit, a ɓad niifɗa ɓa mbuwa sa nǝn ndorha ‘Pashi, kulo mbǝd tsaurha na ngga ya.’ Tǝrgha na wal mamnggirha a mbed shayiwa na heu mbuna nda ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ƙǝsǝr kala niifa manangga altenggǝn nanda tsawang nda ngguchit, yanɗi manangwawa altenggǝn ƙǝm nanda manang nda.” ");
INSERT INTO hwo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tǝrgha ndangga Yeeso niifɗi aagha ndǝn, “A anna niifa ka hǝb ǝnnarhami ɓa, ko ngwanna wutsǝfayirha fa, a mbunna pashiyi wa ɓa kee wa, ko wan manggiwa, tǝ hurfayiwa, tǝ tulayiwa fa ƙǝnaya wa. A ǝnanna kee, a fara sǝmǝn nanda a aah sa kanda nggima, teu ǝnɗa nda ǝnangna kanda. ");
INSERT INTO hwo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amma a nanna a mbu fiya hu wutsǝfayirha ɓa, mbuwu fa yamiya, tǝ nafiya mǝrna fandan, tǝ sǝfǝngya tǝ kwamaya, ");
INSERT INTO hwo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na wal parka, ko nanǝn mba nda mbang teuƙǝn wa, Faara ni a teuƙǝn afar thlid fiya sǝ hu mǝra ǝnagha nggayirha.” ");
INSERT INTO hwo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na niifasǝ tal ahur nafini na a hǝb ǝnnarhami tǝ Yeeso sǝknǝn pathɗiya, ndanggǝn, “Tǝ parkani niifa ɓagha hǝb ǝnnarhami yi mbǝnafarha fa hu kutǝryid Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nggǝmangga Yeeso, “Na niifa sǝ ngwagha fa ǝna wutsǝfayirha nǝn manggǝn mbu fiya nǝn hangga. ");
INSERT INTO hwo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A far wutsǝfayidɗi, thlǝn mafadghǝnǝn ɗǝgha ndang nda nafini mbunǝn ɓa, ‘Ɓama ɓa, ƙǝsǝr ngwaɗi fa nanǝnya.’” ");
INSERT INTO hwo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Amma kanda na heu na nda a ˈwarha hai. Yi tal ndǝghǝn, ‘Hiiɗi heerha ɗini ƙǝlang nda ɓa, hwanni sa a ƙǝrsana.’” ");
INSERT INTO hwo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Yanɗasǝ ƙǝm ndǝghǝn, ‘Hiiɗi thlad huɗaya nggarma tuf, niyi hu kwaman ƙǝƙǝrang kanda, hwanni sa a ƙǝrsana.’ ");
INSERT INTO hwo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tahadghǝn ƙǝm ndǝghǝn, ‘Kakhki ahu ɓenɗiya, tsaunǝn kee mbiya ɗǝrha ɗǝ wa.’” ");
INSERT INTO hwo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Wudgha mafadɗa ɓa pǝrang ǝngginanǝn turighǝn thlǝkna nafini. Tǝrgha turiɗi sǝbgha hurghǝn ɗǝ, ndanggǝn mafadghǝn, ‘Ɗuwaɗǝ ƙǝkar tǝr kwaman huɗarha na tǝ kwaman sarya ɗǝgha hu talya ɗǝ, ɓana ɓa tǝ fa yamiya, tǝ sǝfǝngya, tǝ kwamaya tǝ nafiya mǝrna fandan hai.’ ");
INSERT INTO hwo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ndagha mafadɗi, ‘Paɓa, ngwalangɗi ǝnɗi ndaana, kulo mbiya takh mbǝrha.’” ");
INSERT INTO hwo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Tǝrgha ndangga turiɗi mafadghǝn, ‘Ɗuwaɗǝ turu kwaman huɗaya ɗǝgha hu talya ɗǝ, ndangga kanda ɓanda ɓa tǝna wurina lǝghǝtta. ");
INSERT INTO hwo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Niya pǝranggǝn kun, mbǝ niifa sǝ ahur nafini ˈwani mburha ɓa na taarang wutsǝfayidɗa fa kyana ya wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Farɗasǝ, fiya hangga a mbu samad Yeeso, tǝrgha kyahargha hai ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kala niifa na midghǝn mbu samadna a nggǝmngwa nggi kal yi chin nǝn tǝ man, nukkun tǝ wanggighǝn, wan manggighǝn hǝshya tǝ nishya, tǝ altenggǝn wa, mbǝ mbang tsaurha wan tǝ tsahanna wa. ");
INSERT INTO hwo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kala niifa mbangwa tǝrang kaɗidghǝn sǝ mbu samanna nǝn, mbǝ mbang tsaurha wan tǝ tsahanna wa.” ");
INSERT INTO hwo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Andam na niifa sǝ ahur nun na midghǝn sǝ tǝn ƙǝnna na dzang, mbǝnǝn ˈwarha teena tsauka hai thlǝɗanggǝn ǝngya hai na ngwalang tǝndǝɗi ˈwan wa, ƙǝlanggǝn tǝ na wuɗǝɓǝla sǝ a harghǝn ngga na mbang ngwalang tǝndǝɗi wa?” ");
INSERT INTO hwo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A mbuhangɗa hai mbangwa mishilang wa, na fiya naarha waghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nanda a ndaarha, “Ƙǝlama kamshiɗa hai katǝrangɗǝ tǝnda hai mbangwa mishilang wa.” ");
INSERT INTO hwo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nduwa ƙǝm ana kutǝra sǝ na midghǝnsǝ yanda tǝ shadghǝn kutǝra. Mbǝnǝn tsaurha hai numagha ƙǝlanggǝn tǝna sodjayighǝn haru kumnggit kum mbang pa ƙǝfarha tǝ ka yandǝghǝn na ɓai tǝ sodjaya haru kumnggit sǝri wa? ");
INSERT INTO hwo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A mbǝ a mbang wa, nen ˈwarha teena thlǝn nafiya ɗǝ ka yandǝghǝn ɓalɗǝ inggun ɗa nda kaɗa kwaman tsawud ɗǝɗemnggirha. ");
INSERT INTO hwo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nǝghǝn kee ƙǝm, kala niifa ahur nun a malangwa ǝngya nanǝn tǝghǝn heu wa, mbǝ tsaurha tǝ tsahanna wa.” ");
INSERT INTO hwo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Fǝsa ˈyani na ngga, amma a tǝr mbǝndǝghǝn ɗǝ, tǝ ma nǝm nggǝrang mbǝndǝghǝn ɓa? ");
INSERT INTO hwo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɓalwa targhǝnsǝ hu heerha na a mǝthlanggǝn wa, ƙǝl iraɗǝ kee. “Yi na tǝ thlǝmad sǝkrha sǝkƙǝnǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nanǝn ya fa thlǝ tsamngya tǝ fingya fa ɗimiya kanda heu a wumnda thlǝmad Yeeso ɓa ka a kang thlǝmanda fa. ");
INSERT INTO hwo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Amma Farisaya tǝ Fasǝngya ngyakhrha na nda a huhurumnda, “Kǝlaman niifɗiya ƙǝl thlǝ fa ɗimiya fa tǝ ƙǝm nagha a hǝbrha tǝ kanda.” ");
INSERT INTO hwo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tǝrgha Yeeso fǝrang karapu ɗanǝn kanda ya. ");
INSERT INTO hwo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ndam na niifasǝ ahur nun tǝ chauraya haru tal, sahadgha tal ahur ndan. Mbǝ malang kumnggit wutarihe kap wutarihe ɗi a mbǝd lafrha, ɗǝgha ka kaɗa yanɗaɗǝ sahadgha ƙǝl ma walangɗaɓa wa? ");
INSERT INTO hwo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A walang ɗaɓa, tǝ wutsǝfayirha nǝn a tǝrang a fad uradghǝn sǝ ");
INSERT INTO hwo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ɗǝgha wure ɗǝ. Tǝrgha aah pashiyighǝn ɓa tǝ tulaya heu, ndanggǝn kanda, ‘Ɗeemasǝ wutsǝfayirha, walangɗi chauradɗi kyana sahadgha.’ ");
INSERT INTO hwo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Niya pǝranggǝn kun, nanda ǝna wutsǝfayirha fa kaan kee a talara aten tǝ ɗimiyirha tǝtali malangga ɗimiyidghǝn, ma fingyayini na kumnggit wutarihe kap wutarihe na tǝ ƙǝkafek fa. ");
INSERT INTO hwo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nduwa ƙǝm ndam nuneefasǝ tǝ wuɗǝɓǝl wurirha kum sahadgha tal. Mbǝnǝn njang patilla, ngwanggǝn mindǝɗaɗǝ djib kaɗadghǝnǝn wa? ");
INSERT INTO hwo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A walang ɗǝ, nǝn a aah wukwayighǝn ɓa tǝ tulaya, ndanggǝn kanda, ‘ɗeemasǝ wutsǝfayirha fa, walangɗi wuɗǝɓǝlɗi kyana sahadgha.’ ");
INSERT INTO hwo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Niya pǝranggǝn kun, na wutsǝfayirha fa sǝ kee, a mbed fa thlǝngya Faara aten tǝ ɗimiyirha tǝtali malangga ɗimiyidghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeeso ɗǝgha mbeeɗǝ tǝ pathla ndǝghǝn, “ˈWad niifa narhasǝ tǝ wundǝlayighǝn sǝri, ");
INSERT INTO hwo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tǝ fewunda ndanggǝn chin, ‘Pǝpa fǝre yina langaarha ɓa.’ Tǝrgha chinɗi ndǝghang ƙǝnaghǝnǝn kanda.” ");
INSERT INTO hwo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mǝngwa ha wa, tǝfewundǝɗi ngwanggǝn ǝnggighǝn na heu, ɗǝgha ahu chehwedɗǝ na inggun. A mbǝɗi ɓǝlanggǝn ƙǝnaghǝn ɗǝ hu ǝngya ƙǝlara tǝ pateyirha. ");
INSERT INTO hwo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A kwasamadɗi ngwalana ƙǝnaɗa hai keeghǝn, kyagha mirha hu chehwedɗa hai kaan, ƙǝsangga yamirha. ");
INSERT INTO hwo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kaɗa taara nǝn ahar wan tǝ chehwedɗi, ndǝghǝn nggi ƙǝm fǝrang laf ƙǝlengarya nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nǝn naarha kaɗa nggushir ƙǝlengaryini a ǝnagha mii, amma mbǝ niifasǝ fǝrangga ndǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ɓana hutenggǝn ɓa, ndǝghǝn, ‘Kai! Fa tarya pǝpa heu kanda a nggaala tǝ ǝnnarhami kaan kulo nggi a mǝra tǝ mirha! ");
INSERT INTO hwo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Niya thliirha nanǝnya, wuɗi thlǝmad pǝpa ɗǝ, ndanggi; Pǝpa, ǝnangɗi ɗimiyirha Faara fa, ǝnoɗi fa ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kamngwi a aah nggina wan wa ɓalwa, tsawe kee tal ahur fa tar yiwa.’” ");
INSERT INTO hwo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Thlidghǝnni, ɗǝgha wal chin. Amma ndǝghǝn ɓalɗǝ inggun, naghǝna chin ɗǝ, ɗaghaɗǝ hwathlaghǝn fa; ɗaghaɗǝ ɗǝgha wal wanggǝn, fǝɓanggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ndangga wanɗi, ‘Pǝpa, ǝnangɗi ɗimiyirha Faara fa, ǝnoɗi fa ƙǝm, kamngwi a aah nggi nda wanwa ɓalwa.’” ");
INSERT INTO hwo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Amma chinɗi ndanggǝn mafayighǝn, ‘Ɗamaɗǝ ƙǝkar! Tǝrama kaɓarha ɓa na ngga kalanggunun fa. Paman wulenduwa a wan harghǝn tǝ pakhma a sarghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kǝsama wan kwel ɓa, thlenggun uradghǝn, kim, ǝna wutsǝfayirha nǝm. ");
INSERT INTO hwo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ƙǝsǝr wanɗi kyana ya mǝrɗǝ, nggǝrɗǝ yibrha ƙǝfa; sahadɗǝ walang ɗǝm.’ Tǝrgha ɗǝnda mbeeɗǝ tǝ wutsǝfayirha fa. ");
INSERT INTO hwo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Katǝrana ǝnggina hai ya wanggǝn tǝ pamǝnda nǝghǝn a hee, ndusang nǝn wure fa, sǝk ɗǝk kangkar nǝn, fiya a rǝbrha. ");
INSERT INTO hwo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tǝrgha aah mafad wuri ndan nǝn ɓa tal, tsahang mee nǝn ha, tǝma tsǝgha hai. ");
INSERT INTO hwo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ndangga mafadɗi, ‘Wan muwa ɓagha ɓa, tsu thlengɗǝ urad wan kwel sǝ, ƙǝsǝr wudɗa ɓa kanglang hai.’ ");
INSERT INTO hwo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tǝ pamǝndǝɗi sǝbgha hurghǝn ɗǝ kaan kar kyarha nǝn fa wure hai. Kyagha chinsǝ, lǝmggǝnǝn fa. ");
INSERT INTO hwo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amma ndanggǝn chin, ‘Kulo hai! Huraya hangga nggi a ǝno taara ƙǝla mafarha ˈwawi karo mee fa wa. Amma ˈwawa fǝre ko wan ˈwala ǝna wutsǝfayirha ni tǝ pashiyina wa. ");
INSERT INTO hwo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amma wunna wanɗaɓa kyawa ya, sǝbangga ƙǝnawa ɗǝ afad sǝsǝwaya thleng urad wan kwel na sǝ!’” ");
INSERT INTO hwo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ndangga chin, “‘Waana, ka fad ɗathla mbǝrha fa hai ƙǝm kyab, ˈya na yina heu yiwa ni. ");
INSERT INTO hwo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amma ˈyani kamngga ǝna wutsǝfayirha nǝm, tǝk mbǝnda nǝm fa, ƙǝsǝr wan manɗi kyawa ya mǝrɗǝ, nggǝrɗǝ yibrha ƙǝfa. Sahadɗǝ walang ɗǝm.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ndangga Yeeso fatsahayighǝn, “ˈWad tǝ ƙǝna naarha sǝ na fiya a kiki mamnda tǝ targhǝn fa tǝ ndaarha nǝghǝn a sǝɓang ƙǝnaghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aagha tǝ ƙǝnaɗi tǝ tarɗi keeghǝn tsahang mee nǝn, ‘Path ma niya sǝkrha atenwa? Fǝre kirassa tarwa ǝna nana, ƙǝsǝr mba nggǝr tsaurha mamnda tǝ tarna ɓalwa.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ndangga mamnda tǝ tarɗi altenggǝn, ‘Mani ǝnaarha nanǝnya? Kulo na turina a rǝk nggi ahu tarna. Nggi mbiyi kanglang na a huɗee wa, kee hu hwanda hai nǝn shiɗeerha. ");
INSERT INTO hwo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sǝnɗi ˈya niya ǝnaarha, a ƙǝɗen nda hai ma tarna tǝna fiya thlǝ nggi fa ahur mindǝndan.’” ");
INSERT INTO hwo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tǝrgha aah fa kumaya turighǝnǝn tǝtal, tǝtal. Tsahang mee nǝn yi tal, ‘Kurmi na turina a takkwa sa kumarha?’” ");
INSERT INTO hwo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ndanggǝn, “Fǝɗeerha ƙǝthlikrha haru uvaɗa.” Ndangga mamnda tǝ tarɗi, “Thlu ɗeleewar, tsawu hai ƙǝkar, chirethlengga hai haru faɗa.” ");
INSERT INTO hwo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tǝrgha tsahang mee nǝn yi sǝri, ndanggǝn, “Kumarha kurmi a harwa?” Ndanggǝn, “‘Yawarha haru kum yi wan hwalirha.’” Ndanggǝn, “Thlu ɗeleewar chirethlengga hai haru uvaɗa.” ");
INSERT INTO hwo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Turiɗi fal mamnda tǝ tarɗa nǝn keeghǝn mbuwa wa tǝ ƙǝkafek fa ka thladwayidghǝn. Ƙǝsǝr nafiya ƙǝshiid weeriya hu tsawundan tǝ fiya yi ƙǝshin ndan kalnda nafiya na tǝ ƙǝkafekkirha thladwayirha.” ");
INSERT INTO hwo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Niya pǝranggǝn kun, ǝnama taara tǝ ƙǝna nun yi ƙǝshidɗiya tǝnun wal pashiya, ƙǝsǝr a fara ngwalanǝn hai, nanda thlǝ kun fa a talara pakwanɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Niifa na fiya fǝrƙǝkafek tǝghǝn ahu ˈya na ngguchit, tǝ ƙǝkafekni ƙǝm ahu ˈya na manggǝn. Niifa mbuwana ƙǝkafek sǝ a fadghǝn ahu ˈya na ngguchit, mbǝ ƙǝkafek sǝ ƙǝm a fadghǝn ahu ˈya na manggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A ǝnawun ƙǝkafekirha hu ƙǝssa ƙǝna ƙǝshiirha wa, wunni fǝrƙǝkafek tǝ kun aten ƙǝna yi ƙǝkafek na a talara? ");
INSERT INTO hwo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A ǝnawun ƙǝkafekkirha aten ǝn niifa wa, wunni fǝrang yi altennun kun? ");
INSERT INTO hwo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mbǝ mafarha sǝ na ǝnang taara turaya sǝri wa. Tsauɗǝ nǝn nggǝm tal kar tahadghǝnǝn, nduwa ƙǝm mananggǝn tal sar tahadghǝnǝn. Mbǝ ǝnaarha hai ǝnang taara nun Faara tǝ wuɗǝɓǝla kyab wa.” ");
INSERT INTO hwo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisaya na ngyingyilǝm tǝ wuɗǝɓǝla, sǝk nanda ǝnggini heu, nanda a chang yirha Yeeso fa. ");
INSERT INTO hwo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ndanggǝn kanda, “Kunni manang nda fannun a yid fiya, amma Faara sǝnɗǝ huryinun. ˈYa nggǝmna fiya kaan, ǝn tsandani a yid Faara. ");
INSERT INTO hwo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ngyakhrha tǝ ɗeleewar annabiya ndǝna fiya takkwarha ɗǝgha hu ƙǝshiid Yahaya tǝ Mbaptisǝma ɗǝ. Ka a farɗi, laɓarɗi na ngga yi kutǝryid Faara pǝrndan, nagha kowunni a kaɗa kwamana na kyagha sa hai. ");
INSERT INTO hwo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nǝghǝn pǝpa nda talara tǝ hweeɗe ngwalanda hai, ma ˈya ngguchit hu ɗeleewar ngyakhrha Faara kyagha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kala niifa kalgha nukkun hai nggǝrghǝn kakhrha ǝnanǝn kulafayirha. Niifa ƙǝm kakhka nuneefa kalnanda hai, ǝnanǝn kulafayirha.” ");
INSERT INTO hwo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ndangga Yeeso kanda, “Na tǝ ƙǝna sǝ, nǝn naarha kal kaɓarha fa na nggǝngga ka fad ɗathla mbǝrha fa hai nǝn naarha tǝk mbǝndayidghǝn fa. ");
INSERT INTO hwo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A kwatkirǝmnggǝn, na tǝ hwanda sǝ thlǝmnggǝnni Liyadzuru fadghǝn na heu wundǝyani. ");
INSERT INTO hwo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na midghǝnsǝ nagha a ɗan fǝfǝsǝrra ǝnnadɗami hǝrgha hai ahar tǝ ƙǝnaɗi. Wuɗaya nanda naarha ɓarha ɓa nanda a nii wundiyini keeghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tsǝgha farɗa hai mǝrgha Liyadzuru, tǝrangga wangya thlǝnda Faara a thlǝmad Ibrahim ɗǝ. Tǝ ƙǝnaɗi ƙǝm mergha pangganda. ");
INSERT INTO hwo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ndǝghǝn ahu hwanga a sǝsaarha, tǝranggǝn tenggǝn sǝ ƙǝlagha ɗǝ, na Ibrahim nǝn ɗǝ inggun tǝ Liyadzuru a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tǝrgha aaghǝnǝn ɗǝ, ‘Pǝpa Ibrahim a haɗoyi fa, thlǝnu Liyadzuru ɓa ɓagha pang wan harghǝn hu aama hai tsǝtse ƙǝnǝn mii hai mbiɗenggǝn sheneuna ɗǝ, ƙǝsǝr ni a sǝsaarha kaan ahu waɗɗiya.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Amma ndangga Ibrahim, ‘Waana ɗalu teena hai tsawudwa hu ƙǝshiirha, walna ǝn ƙǝshiirha tǝkna mbǝnda fa, Liyadzuru ƙǝm sǝsaɗǝ. Amma kulo nanǝnya a tǝk mbǝnda fa a mbǝɗiya, sa a sǝsaarha. ");
INSERT INTO hwo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mbǝ kee ma wa, pathlang nan tǝ sa na kwarhasǝ manggǝn kuɗimnggǝn, fingya na mindansǝ ɗǝrha thlǝmannun ɗǝ amana nda mbang nda, tǝ ƙǝmɗa, ahur nun mbǝ niifa mbang tǝɗaarha thlǝmannan ɓa wa.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ndagha tǝ ƙǝnaɗi, ‘Nanǝn kee, niya hwan sa pǝpa, thlǝnu Liyadzuru a minda ki pǝpa ɗǝ; ");
INSERT INTO hwo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ƙǝsǝr na wanmanggina sǝ tuf hǝshya. Ɗǝgha yiyi thlǝman ndan, amana nda ɓarha hu sǝsadɗa ɓa ya ƙǝm.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ndangga Ibrahim, ‘Na ngyakhrha Musa sǝ, tǝ yi Annabiya, kang thlǝmanda kanda fa lee.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ndagha tǝ ƙǝnaɗi, ‘Mbǝ kewa pǝpa Ibrahim, amma a thlid niifa sǝ ahur mǝrya ɗǝgha thlǝmandan ɗǝ nanda fǝrƙǝkafek.’ ");
INSERT INTO hwo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ndangga Ibrahim, ‘A sǝkkwanda ˈya chirethna Musa tǝ yi Annabiya wa, ka thliina niifa sǝ ahur mǝrya, mba nda kang thlǝmarha fa wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ndangga Yeeso fatsahayighǝn, “Əngya na kyang niifa hu ɗimiyirha hai nǝn ɓarha ɓa, amma kawa a niifɗi ɓagha ɓa tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A nggushi waghang nda fǝn hǝrha ura mughangganda ahu wuri aama ɗǝ, ma kyanggǝn tal ahur wangginiya hu ɗimiyirha hai. ");
INSERT INTO hwo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yoo, kwarama altennun.” “A ǝnad shadwa ɗimiyirha, yanang, a nda ɗǝ cheeɗa hai, chahanggǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A ǝnoɗǝ ɗimiyirha fa sara mǝd hu parra fara, sara mǝd a wutta thlǝmad wa ɓa, ndǝghǝn, ‘Cheeɗa hai,’ chahanggǝn ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Fathlǝngya Yeeso ndang ngganda, “Chighang fǝrƙǝkafek kan.” ");
INSERT INTO hwo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ndanggǝn kanda, “Ana fǝrƙǝkafek sǝ a fannun ƙǝla wan parsǝna, nun ndangnda ɗǝfǝdɗi na manggǝn ya, ‘Kǝɗusǝ ɗa rarha hai hu wuri aama ɗǝ,’ nǝn takkwa miwa. ");
INSERT INTO hwo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A ndam tal ahur nun na mafadghǝn sǝ na a huɗang sǝ nduwa na a lafang chaukhrayighǝn. Nǝn ndangnda mafadɗi a wudɗaɓa a hee, ‘Ɓoɓa nanǝn ya ɓa tsau hai hǝɓaana’? ");
INSERT INTO hwo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A meghedghǝn kamngwa a ndagha, ‘Fuweesǝ ˈwan ngwana fa ƙǝla nggina ngwala hǝbrha ni tǝ sarha aɗa hǝb yiwa tǝ sarha wa’? ");
INSERT INTO hwo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nǝn usa mafadɗi, ƙǝsǝr ka ǝnanǝn taara ndangnanda ǝnagha wa? ");
INSERT INTO hwo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nuwun kee ƙǝm, a ngwalang ɗun ǝngya ndang nanda kun ǝnon, ndaama, ‘Mafaya ni kan kee, ǝnanan tar nan.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nanǝn ya na Yeeso a ɗǝrha Urshelima ɗǝ, tǝrghǝn kwamana kyagha tǝ ten sǝrǝk chehweed Samariya tǝ Nggalili. ");
INSERT INTO hwo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Takh nǝn a kyarha hu tala hai, nafiya kum na tǝ wanhad termeerha ɓa nda ɓa isha nda ɗǝ inggun ");
INSERT INTO hwo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aaghǝn nda ɗǝ tǝ urarha manggǝn, “Yeeso, Paɓa, a haɗowan fa!” ");
INSERT INTO hwo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nanǝn kanda, ndǝghǝn, “Ɗamaɗǝ ɗun kyaɗang fannun firistaya.” Kanda aten wiirha kee, ƙǝla nda hai ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tal ahur ndan, ƙǝla nǝn hai ƙǝnɗǝ, wudgha ɓa, tǝranggǝn uradghǝn sǝ kaan nagha a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɓaa ɓǝrgha hai a mbed Yeeso, usaghǝnǝn. Ndǝghǝnggi ƙǝm tǝ Samariyarha. ");
INSERT INTO hwo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsakhka Yeeso mee, “Mbǝ kanda kum heu ƙǝngga wa? Ai fingya wutarihe? ");
INSERT INTO hwo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mbusǝ ko tǝ tǝtal wudgha ɓa ɓaa usa Faara wa ƙǝl rongɗiya?” ");
INSERT INTO hwo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tǝrgha ndangga Yeeso, “Thliu sǝ wiu; fǝrƙǝkafekkid wa ni ƙǝnowa.” ");
INSERT INTO hwo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na farɗa sǝ, Farisaya tsahang mee nda Yeeso, “A kwan na kutǝryid Faara a ɓarha ɓa.” Nggǝmangga Yeeso kanda ndǝghǝn, “Ai ɓad kutǝryid Faara ɓa, mbun naghǝn tǝ yirha wa. ");
INSERT INTO hwo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mbǝ fiya ndaarha, ‘Kulo ndǝghǝn ya,’ nduwa, ‘Kulo ndǝghǝn taarha,’ wa. Ƙǝsǝr kutǝryid Faara nǝghǝn ahur nun.” ");
INSERT INTO hwo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tǝrgha ndangga Yeeso fatsahayighǝn, “Na fara ɓayi na minnun ɓa tǝraa nang yirha Wan Niifa fa ko yi paara tal, amma mbun naghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na fiya ndang nda kun, ‘Kulo ndǝghǝn taarha!’ nduwa, ‘Kulo ndǝghǝn ya!’ a ɗaɗun ɗǝ a samandan wa. ");
INSERT INTO hwo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ƙǝsǝr Wan Niifa a far wuttǝghǝn ɓa, nǝn naarha ƙǝla kyatta ˈyaara na djaara hai a fǝrakh amshi tsuwar mbǝya nǝn fa heu. ");
INSERT INTO hwo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amma nǝn a ˈwa taarang sǝsaarha fa ɗǝɗamǝn-ɗǝɗamǝn, tǝ ƙǝm nafiya ƙǝshiid weeriya nanda a karghǝn fa. ");
INSERT INTO hwo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ƙǝla ˈwanǝn katǝrarha hai a thlakh mbǝd Nuhu, ɓanǝn naarha kee ƙǝm a far wutta Wan Niifa ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Fiya a hǝbrha tǝ sarha, hǝshya a kakhrha, kanda a fǝr nishya a chimadɗǝ ta farɗaɗǝ kyana Nuhu ahu kwambuwol hai. Tǝrgha ɓagha aam afa afa ɓa ɓǝlanggǝn kanda ɗǝ heu.” ");
INSERT INTO hwo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nǝghǝn wai kee a thlakh mbǝd Lutu. Fiya a hǝbrha tǝ sarha, kanda a hiirha tǝ hengnda ɗǝ, kanda a hǝfrha tǝ tǝnda. ");
INSERT INTO hwo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amma a farɗi malna Lutu Sodom, irr nda waarha hai tǝ tsal waarha a talara, ˈyanggǝn kanda ɗǝ heu. ");
INSERT INTO hwo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ɓanǝn naarha ƙǝla yanɗiya a far wutta Wan Niifa ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A farɗi, mbǝ niifa naarha aten ƙǝnggǝn, tǝ karidghǝnsǝ a ƙǝn, mbǝ tǝraa hai ɓagha harang wa. Tǝ ƙǝm, mbǝ niifa ɗǝrha heeɗǝ ndagha nǝn wutta wure ɗǝ ka ɗǝgha har ǝngya wa. ");
INSERT INTO hwo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɗalama teena hai tǝ ˈya walgha nu Lutu! ");
INSERT INTO hwo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kala niifa nggǝmngga yiɓǝdghǝn nǝn ƙǝɗengnda, yi ƙǝɗengga yiɓǝdghǝn, ɗǝfang nǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Niya pǝranggǝn kun, a fǝɗikɗi na ǝnɗi a katǝrarha hai ya, nafiya sǝri kanda kalth ahu sǝra tal, na nda a tǝraa tal mal tal. ");
INSERT INTO hwo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Nishya sǝri a hǝ hwarma kyab, nanda tǝraa tal takhka tal. Na hǝshya sǝri naarha a hee, nanda a tǝraa tal mal tal nda.” ");
INSERT INTO hwo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsahang mee nda, “A yanggi na ǝnɗi katǝrarha hai ya, Chinǝm?” Ndanggǝn kanda, “Mbǝd mǝrra ˈya, mbǝd wumnda sǝkɗiyani.” ");
INSERT INTO hwo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tǝrgha Yeeso fǝrang karapu nǝn fatsahayighǝn na a tsahanggǝn kanda ha a ɗǝnda mbeeɗǝ tǝ hwanda Faara kafad ɗathla mbǝrha fa hai, ma tǝkɗǝ kanda wa. ");
INSERT INTO hwo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ndǝghǝn, “Na tǝ ngwa kumarha sǝ hu tala mbǝ tǝrǝm Faara wa, tǝ ƙǝm njiɗangwa ˈya tǝ fiya wa. ");
INSERT INTO hwo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A hu talɗi na numǝrra sǝ nǝn naarha ɓarha thlǝmadghǝn ɓa tǝ hwanda, ‘Nggo kumad ƙǝkafekkirha a pathlang nan tǝ niifɗi ya.’ ");
INSERT INTO hwo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A hu katǝradghǝn karɗa fa. Amma akwasamadghǝn ndanggǝn altenggǝn, ‘Ko nanǝn mbi tǝrǝm Faara wa tǝ ƙǝm njiɗewa ˈya tǝ fiya wa; ");
INSERT INTO hwo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ƙǝsǝr ka nuɗi ɓillagha nggiya, niya ngwang kumad ƙǝkafekkirha amanǝn nggǝr ɗahang minna ɗǝ!’ ” ");
INSERT INTO hwo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ndagha Chinǝm, “Sǝghama ˈya ndana ndirwid tǝ ngwa kumadɗi. ");
INSERT INTO hwo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ashe, Faara mbǝ mbang ngwang kumad ƙǝkafekkirha nafiyighǝn wurnǝn, na a hwanggǝn nda yan fara tǝ fǝɗikrha wa? Nǝn kukwasa hu ɗang nda kanda sǝ wa? ");
INSERT INTO hwo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Niya pǝranggǝn kun, nǝn ƙǝlarha hai walnda ngwa kumad ƙǝkafekkirha ƙǝkar. Amma, a wud Wan Niifa ɓa, ɓa nǝn wal fǝrƙǝkafekirha ahu ƙǝshidɗiya wa?” ");
INSERT INTO hwo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aten fingya na numarha na nda tǝ ƙǝkafek fa na nda a sarang fiyaɗǝ, thlǝghangga Yeeso karapuɗi kanda sǝ ya. ");
INSERT INTO hwo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ndǝghǝn, “Nafiya sǝri, kyanda hu Ƙǝn Faara ɗǝ na manggǝn ka a hwan Faara nda. Tal tǝ Farisarha ni tahadghǝn ƙǝm tǝ thlǝ tsamnda. ");
INSERT INTO hwo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tǝ Farisadɗi thliigha sǝ hwan Faara nǝn ka altenggǝn, ndǝghǝn, ‘Faara usaɗi sa mbuwani ƙǝla fingya nafiya tsauka ngaarya, fa mbǝlfeeya, kulafaya, tǝ ƙǝm mbiyi ƙǝla tǝ thlǝ tsamdǝɗiya wa. ");
INSERT INTO hwo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ni kar aama sara sǝri ahu ɓeena mǝd tǝ ƙǝm ni fǝr tal ahu ˈya kum walni ha heu.’ ");
INSERT INTO hwo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tǝ thlǝ tsamndǝɗi ishgha ɗǝ inggun. Mbǝ ƙǝlarha talara ɗǝwa, amma nagha a ɗǝk ƙǝfadghǝn ka sǝbrha hura ndǝghǝn, ‘Faara a haɗoyi fa, kulo nggiya tǝ ɗǝmiyirha, ɗee sǝ!’ ");
INSERT INTO hwo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Niya pǝranggǝn kun, tǝ ndaarha niifɗiya mbǝ ƙǝla tǝ Farisadɗi wa, wiiɗǝ wureɗǝ tǝ nggayid Faara a fadghǝn. Ƙǝsǝr kala niifa manangga altenggǝn nanda a tsawangnda ngguchit, tǝ ƙǝm niifa tsawangga fadghǝn ngguchit nanda a manang nda.” ");
INSERT INTO hwo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nagha fiya a ɓarha ɓa tǝ wanggindan a thlǝmad Yeeso ɓa ka ɗǝfang parka nǝn kanda teena. Ƙǝlana fatsahayighǝn hai kee, nanda a yanang kanda. ");
INSERT INTO hwo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amma Yeeso aah wanggina nǝn a thlǝmadghǝn ɓa, ndǝghǝn, “Malaman wanggini na nggu-ngguchit ɓanda thlǝmanna ɓa, a ˈyaɗang ɗun mana kanda wa. Ƙǝsǝr kutǝryid Faara yi tur ndan ni. ");
INSERT INTO hwo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Niya pǝrang ƙǝkafek kun, kala niifa thlǝwa wa kutǝryid Faara fa ƙǝla na wundakhnee ngguchit ǝnaarha wa, mbǝ tam kyarha sahai wa.” ");
INSERT INTO hwo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na mamnda Yahudaya sǝ, tsahang mee nǝn Yeeso, ndǝghǝn, “Ka tǝmalǝmnda, mani ǝnaarha tǝni wal yibrha mbuwa ngwalarha?” ");
INSERT INTO hwo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ndangga Yeeso, “Mani na aah nggi ka niifa? Mbǝ ka niifa sǝ wa ƙǝl Faara katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sǝnna ˈya ndana ngyakhrha Musa, a ǝnanna kulafayirha wa, a ɓǝlna farha wa, a ngarna wa, a pǝrna ˈya aten nggaɓaarha wa, no tsu hai tǝ muwa.” ");
INSERT INTO hwo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ndangga niifɗi, “Ka nggi ngguchit lafɗi ǝngginiya.” ");
INSERT INTO hwo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sǝkna Yeeso ndǝn, ndanggǝn, “Taho ˈyaha tǝtal. Heng ǝnggiwa ɗǝ heu fǝrang wuɗǝɓǝlghǝna fa yamiya, na wal mbǝd ɗǝfrǝghǝn a talara. A ɓanaɓa ɓa mbu samanna.” ");
INSERT INTO hwo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sǝknǝn pathɗiya, sǝbgha hurghǝn ɗǝ kaan, ƙǝsǝr niifani na tǝ ƙǝna kaan. ");
INSERT INTO hwo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kǝlangga Yeeso ɗǝ, ndǝghǝn, “Nǝn naarha pǝɗaghǝn na a kyagha tǝ ƙǝna hu kutǝryid Faara ɗǝ! ");
INSERT INTO hwo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nǝn naarha pǝpa na a kyagha thlǝkhmu ɗǝ tǝ kwad libra, ma tǝ ƙǝna na a kyagha hu kutǝryid Faara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nafiya sǝkka pathɗiya tsahang mee ndaha, “Anaɗǝ kee, wunni wal hǝrǝkrha?” ");
INSERT INTO hwo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nggǝmangga Yeeso ndǝghǝn, “ˈYa mbuwana fiya mbang ǝnaarha, na Faara mbang ǝnaghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ndangga Mbiturus, “Kulo kanya, malangɗan ǝngginan heu mbuɗan samadwa!” ");
INSERT INTO hwo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, mbǝ niifasǝ na malang wure, nduwa nukkun, nduwa wanmanggighǝn, nduwa fa nggǝtyighǝn, nduwa wanggighǝn ƙǝsǝr ka kutǝryid Faara ");
INSERT INTO hwo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na ƙǝɗeng nda walla ǝngya hangga kal yi ƙǝtǝm nǝn hu ƙǝshiid weeriya wa. A talara ƙǝm nǝn wal yibrha mbuwa ngwalarha.” ");
INSERT INTO hwo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tǝrgha Yeeso ɗǝgha tǝ Kum kap sǝri ɗi man patu ɗǝ, ndanggǝn kanda, “Ɗǝnǝm Urshalima ɗǝ, a mbǝɗi ˈya chirethleng na annabiya hai aten Wan Niifa nǝn a lǝghǝtta. ");
INSERT INTO hwo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na nda a fǝranggǝn nafiya mbuwa Yahudaya. Nanda a waghǝn, kyalanda tǝghǝn, chahang yakhrha nda fa tsaɗaghǝnda kaan tǝ ƙǝm ɓǝlangganda. ");
INSERT INTO hwo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","A far paara yi mahan nǝn a thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Fatsahayighǝn hwathlang ngwanda pathɗa hai ki Yeeso wa. Ɓǝɓeng nda ten laɓarɗi kanda, ndǝghǝnni hwathlang ngwanda pathɗa hai nǝn a thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ndusangna Yeeso Djariko fa, na kwamarha sǝ tsau a mii kwamana a hwanda. ");
INSERT INTO hwo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sǝknǝn fad fiya hangga a mbǝraɗǝ, tsakh mee nǝn, mani katǝragha hai? ");
INSERT INTO hwo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ndang ngganda, “Yeeso tǝ Nadzarat ndǝna a mbǝraɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tǝranggǝn uradghǝn sǝ kaan, ndǝghǝn, “Yeeso, Wan Ndauda a haɗoyifa.” ");
INSERT INTO hwo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fingya na a mbee njarghǝnda a nggasgha hai. Amma nggǝrghǝn tǝrang uradghǝn sǝ kaan, ndǝghǝn, “Wan Ndauda a haɗoyi fa!” ");
INSERT INTO hwo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ishgha Yeeso hai ndagha a ɓaa nda tǝghǝn thlǝmadghǝn ɓa. Nduwusnǝn ɓa tsahangga Yeeso mee, ");
INSERT INTO hwo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mana midwa a ǝnoyi?” Nggǝmangga kwamadɗi, ndǝghǝn, “Paɓa, na minna sǝ a namana ni hai.” ");
INSERT INTO hwo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ndangga Yeeso, “Yoo, no mana hai, fǝrƙǝkafekkid wa ƙǝnoɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A mbǝɗi kee, namana nǝn hai mbu samad Yeeso nǝn, nagha a fal Faara. Fiya heu na nanda ǝnɗi katǝragha hai, fal Faara nda ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kyagha Yeeso hur Djariko hai, nǝn a mbǝra mbeeɗǝ tǝ hur talɗi. ");
INSERT INTO hwo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A mbǝɗi na niifasǝ thlǝmnggǝnni Dzakka, mamnda fa thlǝ tsamngyani tǝ ƙǝm tǝ ƙǝna ni. ");
INSERT INTO hwo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na midghǝnsǝ ana niifɗanǝn nanda aarha Yeeso, amma ka nanǝn kwakhmarha mbangwa nadghǝn wa, ƙǝsǝr ka hangnda fiya. ");
INSERT INTO hwo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nanǝn kee, ɗadghǝnni mbeeɗǝ ɗǝgha tǝraa ura ɗǝfrha sǝ na manggǝn ka a naghǝnǝn tsaunǝn na Yeeso a mbǝraɗǝ tǝ kwamanɗi. ");
INSERT INTO hwo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sǝlna Yeeso mbǝɗaɗǝ, ƙǝlagha ura ɗǝfǝdɗasǝ ndanggǝn, “Dzakka, turu hai ƙǝkar. Ƙǝsǝr rong wa ni nggi a weeriya.” ");
INSERT INTO hwo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tǝrgha hai ƙǝƙar thlǝghǝnǝn fa tǝ wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nana fiya ǝnɗiya, katǝrang ngganda huhurumnda hai, tǝ ndaarha, “Kǝlama hai, tsauɗǝ rong tǝ ‘ɗimirha.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amma Dzakka thliigha sǝ ndanggǝn Chinǝm, “Kuloɓa, Paɓa! A mbǝɗiya nanǝnya, niya fǝrang mberra ˈya nani tǝghǝn ha a fa yamiya, a ˈwaɗi huk niifa, niya tenggǝn katǝra faɗa aten ǝnɗi thlǝni a harghǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ndangga Yeeso, “A weeriya hǝrǝkrha kyaɗǝ minɗǝɗa hai ya, ƙǝsǝr niifɗiya ƙǝm chichid Ibrahim ni. ");
INSERT INTO hwo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ƙǝsǝr Wan Niifa ɓanǝn ɓa ka ɓagha kaɗa ˈya sahadgha, ka a hǝrghanggǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na fiya aten ka thlǝmarha hai, ɗǝgha mbeeɗǝ tǝ thlǝghang karapu kanda sǝ, ƙǝsǝr ndusangɗǝ Urshelima fa. Tǝ ƙǝm fiya numanda tǝ ndaarha kutǝryid Faara nǝn a ɓarhaɓa a sǝl nda Urshelima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ndǝghǝn, “ˈWad kogna naarha sǝ wiigha hu chehweed nafiya ɗǝ inggun a ɗaa nda faɗang kutǝra, wudgha ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kapa nǝn wiirha, aah mafayighǝn nǝn ɓa kum, fǝrang wuɗǝɓǝla nǝn kanda hangga Wuɗǝɓǝl taara yi ndǝre mahan. Ndanggǝn kanda, ‘Ənama shafili sǝ kapa ni wutta ɓa.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amma nafiyaghǝn tsandan. Nanǝn kee, thlǝn fiya nda a samadghǝn tǝ ndaarha, “Mbǝ minnan sǝ kamshiɗiya tsauka kutǝr nan wa.” ");
INSERT INTO hwo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ko nanǝn kee, faɗang kutǝryidɗa nda, wudgha wureɓa. Ka kyadghǝn wure hai, thlǝn farha nǝn a ang mafayighǝn nda ɓa na heu fǝrang nǝn wuɗǝɓǝla kanda, ƙǝsǝr a sǝn ˈyanǝn tǝ kurmi wal nanda chikrha atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yi tal ɓagha ɓa ndanggǝn, ‘Alvari, ǝnaɗi taara tǝ wuɗǝɓǝlwa walɗi chikrha katǝra kum.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ndangga turighǝn, “‘ˈYauwa ka mafanna! Ƙǝsǝr ka ƙǝkafekkid wa ǝnana ahu ˈya na ngguchit, tsawu kutǝra aten tala kum.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Yi sǝri ɓagha ɓa ndanggǝn, ‘Alvari, walɗi chikrha katǝra tuf.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nggǝmangga turighǝn, “Sa, tsawu kutǝra aten tala tuf.” ");
INSERT INTO hwo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tǝrgha ɓagha tahad mafarha ɓa, ndǝghǝn, ‘Alvari, kulo wuɗǝɓǝl wa ya; ƙǝnangɗi hu kukwasharra hai ɓiɓengɗi. ");
INSERT INTO hwo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tǝrǝmɗi sa, ƙǝsǝr na ngyangthlang. Midwa ǝnka kaan, tǝ ƙǝm na hath ˈya hǝfwa nana.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ndangga turighǝn, ‘Niya nggo kumarha sǝ aten ˈya thlǝkna tǝ miwa, ka wuɗi mafarha! Kyanna sǝnda sǝ, niyi ngyangthlang, minna ǝnka, tǝ ƙǝm, ni hath ˈya hǝfwa ni? ");
INSERT INTO hwo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mani fǝrangwana ndǝn fa shafiliya a wuɗɗi ɓa tǝni ɓa thlǝghǝn tǝ chikrha?’” ");
INSERT INTO hwo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Tǝrgha ndanggǝn fingya na ƙǝƙǝt a mbǝɗi, ‘thlama wuɗǝɓǝlɗi na a harghǝn fǝranggunun tǝ kum ɗǝ.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ndang ngganda, ‘Alvari, ai na kumsǝ a harghǝn!’” ");
INSERT INTO hwo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Nggǝmanggǝn kanda, ndǝghǝn, ‘Niya pǝranggǝn kun kala niifa na tǝ ˈyaha, nanda chighanggǝn. Amma yanɗi mbuwa tǝ ˈyaha, ko yanɗi na ngguchit a harghǝn nanda thlang nda. ");
INSERT INTO hwo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amma fa tsanggina mbuwana mindansǝ nggi a tsawi kutǝr ndan, ɓama tǝ kanda mbǝɗa ɓa ya, ɓǝlanggun kanda ɗǝ a mbenna.’” ");
INSERT INTO hwo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngwalana Yeeso thlǝk pathɗiya, ɗǝgha mbeeɗǝ tǝ wiirha a Urshelima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ndusang nǝn talya Mbetafadji fa tǝ Mbetani na aten wumnda nanda aarha Wumnda ɗǝfya Dzaitun, thlǝn fatsahayighǝn nǝn sǝri, ndagha, ");
INSERT INTO hwo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ɗama hu talɗa ɗǝ na ngguchit a mbennun ni, a kyaɗun sa hai, ɗunun wal wan kwara ƙǝƙǝna hai a mbǝɗi, ˈwawanda tǝraa. Kwasaman ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A tsahang niifa mee kun ‘kama nda nun a kwasang hai?’ Ndaman Chinǝm ndagha na midghǝn sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Fatsahayini sǝri thlǝnnanda, ɗǝnda ɗǝ ɗanda walghǝn ƙǝla thlǝghang nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na nanda a kwasang hai kee, nafiya wan kwarɗi, tsahang mee nda kanda, “Kama nda nun a kwasang wan kwarɗa hai?” ");
INSERT INTO hwo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ndang ngganda kanda, “Chinǝm ndagha na midghǝn sǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɓang nggǝnda Yeeso ɓa, lǝlǝɓangganda lukkindan ƙǝsǝr kwarɗa sǝ, tǝrang ngganda Yeeso a ƙǝsǝrghǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ndǝghǝn aten wiirha, nagha fiya a lǝlǝɓang lukkindan hai aten kwamanɗi. ");
INSERT INTO hwo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ɓanǝn ɓa tsau tǝ kwamanɗi na yiyirakh tǝ wumnda ɗǝfya Dzaitun fa. Tǝrgha fatsahayighǝn tǝ fiya na heu, tǝrang ngganda urandan sǝ na nda a fal Faara tǝ wutsǝfayirha aten ǝnwulteena hangga nana nda. ");
INSERT INTO hwo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kanda a ndaarha, “Tǝ parkani kutǝrɗi ɓagha ɓa hu thlǝm Chinǝm!” “Tsawud ɗǝɗemnggirha nagha a talara, tǝ manang nda thlǝm Faara ƙǝm!” ");
INSERT INTO hwo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fingya Farisaya na ahur fiya ndang ngganda Yeeso, “Mala, ndang fatsahayiwa nggasanda hai!” ");
INSERT INTO hwo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nggǝmanggǝn kanda ndǝghǝn, “Niya pǝranggǝn kun, ka nggasna nda hai, ferya tafandan na nda a fal nggi.” ");
INSERT INTO hwo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ɓanǝn kaƙǝn Urshelima ɓa, nanǝn talɗi, tanggǝn teena. ");
INSERT INTO hwo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ndǝghǝn, “Andam kwang a weeriya, sǝnɗun ˈya na ɓang tsawud ɗǝɗemnggirha kun ɓa! Amma kulo mbiya ɓǝɓeng nda ma yinnun. ");
INSERT INTO hwo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na fara ɓayi na fa tsangginun a tǝrang hur shee kun teena muwangganda kun a maɗufu hai ˈyaɓang mbǝya nda kun fa. ");
INSERT INTO hwo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nanda a ɗǝghang kun hweeɗe hai, kun tǝ wangginun na ahur talnun. Mbǝ ˈyasǝ nanda a tahang wa, ƙǝsǝr sǝnggun farɗi ɓana Faara thlǝmannun ɓa wa.” ");
INSERT INTO hwo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tǝrgha Yeeso kyagha a pǝpal Ƙǝn Faara ɗǝ na manggǝn, katǝranggǝn rǝghang fiya ɗǝ na a heng ǝngyaɗǝ a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ndanggǝn kanda, “Nǝghǝn chichirethlee hai tǝ ndaarha, ‘Kǝnna nǝn tsaurha ƙǝn hwandǝna,’ amma tsawanggun mbǝd ɓǝɓed ngaarya.” ");
INSERT INTO hwo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka fat paara fa, nǝn tsaharhaha a pǝpal ƙǝn Faarɗi na manggǝn. Amma mamnda Firistaya, fasǝngya ngyakhrha tǝ fingya mamngya na ahur fiya, nanda a kaɗa kwaman ɓǝllǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko nanǝn kee, walwanda kwamanggǝn wa, na nda a tǝrǝm fiya na a kang thlǝmarha fa, ƙǝsǝr laɓarghǝn kyaɗǝ huten ndan hai. ");
INSERT INTO hwo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Farɗa sǝ Yeeso a tsaharhaha a pǝpal Ƙǝn Faara tǝ thlǝk laɓar Faara na mbǝnggǝn a fiya. Tǝrgha mamnda firistaya tǝ fa sǝngya ngyakhrha, tǝ fingya shingya, wuma nda thlǝmadghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ndang ngganda, “Pǝranggǝn kan tǝ yanggi ngyahadyi na a ǝna ǝngginiya. Wunni furogha ngyahadɗiya?” ");
INSERT INTO hwo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nggǝmangga Yeeso kanda, ndǝghǝn, “Nggima na Tsakhmee sǝ a miina. Pǝremadghǝn, ");
INSERT INTO hwo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mbaptisǝma ǝnana Yahaya, Faara fǝrangga ngyakhrha wa, nduwa fiya wa?” ");
INSERT INTO hwo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tǝrgha tsǝ laɓara nda atenggǝn, ndaa nda, “A ndaa ɗǝm, ‘Faara fǝrangga,’ nǝn a tsakh mee, ‘Kama fǝrwa nun ƙǝkafek tǝghǝn?’ ");
INSERT INTO hwo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amma a ndaa ɗǝm, ‘Fiya fǝrangga,’ fiya na heu nanda a mukƙǝm tǝ ferya, ƙǝsǝr fiya na heu nggǝmndafa tǝ ndaarha, Yahaya annabi ni.” ");
INSERT INTO hwo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsaunǝn kee, ndang ngganda, “Sǝngwan mbǝɗi ɓanǝn sa ɓa wa.” ");
INSERT INTO hwo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ndangga Yeeso kanda, “Nggi ƙǝm mbi pǝranggǝn kun tǝ yanggi ngyahadyi niya ǝna ǝngginiya wa.” ");
INSERT INTO hwo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɗǝgha Yeeso mbeeɗǝ tǝ thlǝghang karapu ɗi kanda sǝ ya, ndǝghǝn, “Na niifa sǝ pagha ɗǝfya inabi, dzǝmanggǝnǝn fahuɗaya ha, wiigha hu chehwedɗǝ pak mǝngga ha. ");
INSERT INTO hwo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tsǝna shifirha hai thlǝn mafadghǝn nǝn thlǝmad nafina ɗǝ nzǝmngga hedɗi a ǝnang ǝn hedɗa nda ha. Tǝrgha nafini nzǝmngga hedɗi ɗǝghangganda mafadɗa ɗǝ wuɗangganda ko ˈya a harghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nggǝrghǝn thlǝn mafarha ɗǝ, ɗǝkƙǝn nda ƙǝtǝlangganda wuɗangganda kula ˈya a harghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nggǝrghǝn thlǝndaɗǝ yi mahan, ǝnang wundǝrha nda fa muwangganda ƙǝsha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tǝrgha tǝ hedɗi ndǝghǝn, ‘Mani ǝnaarha? Niya thlǝnang waana ɗǝ nggǝmni kaan; asǝmha nanda fǝrang mamnggirha.’ ");
INSERT INTO hwo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Amma nana nafini nzǝmngga hedɗi wanɗi, tsǝ laɓara nda atenggǝn. Ndaa nda, ‘Yauwaa! Kulo tǝ har langad hedɗiya, nggushi ɓǝlang nǝm, tǝna hedɗi tsaurha yinǝm!’ ");
INSERT INTO hwo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tǝrgha kyangganda sǝ ma hedɗi, ɓǝlangganda. “Mana tǝ hedɗi ǝnang nda kanda? ");
INSERT INTO hwo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nǝn a ɓarha ɓa ɓǝlanggǝn nafina ɗǝ nzǝmngga hedɗi fǝranggǝnǝn nafiya pak.” Sǝkna fiya ndǝn kee, ndaa nda, “A kaptangga Faara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kǝlangga Yeeso kanda hu yidsǝ ndǝghǝn, “Laɓarɗi chireethleng nanda hai manǝn a ndaarha, “‘ferɗi karna fa tǝngya, ndǝghǝnni tsauka fer sar ƙǝnna’ ”? ");
INSERT INTO hwo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Kala niifa mukka ten ferɗa hai, nǝn hwasarha fa, amma yi mukna ferɗi tenggǝn hai nǝn a tsarang ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Fasǝngya ngyakhrha tǝ mamnda firistaya kaɗa kwaman ƙǝssa Yeeso nda a mbǝɗi, ƙǝsǝr sǝndasǝ karapuɗi thlǝknǝn ya a tendanni. Amma kanda ƙǝm a tǝrǝm fiya. ");
INSERT INTO hwo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nanda a lafghǝn, thlǝn fa harmuya nda ɗǝ, a tsawa nda ƙǝla ka nafiya na tǝ ƙǝkafek fa. Na mindansǝ a ƙǝsangganda Yeeso tǝ ɗimiyirha tǝna nda ɗanggǝn ngwamna ɗǝ na tǝ sǝsǝmnda ha. ");
INSERT INTO hwo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Fa harmuyini thlǝn nanda tsahang mee nda Yeeso tǝ ndaarha, “Mala, sǝnɗansǝ pathwa tǝ tsahadwaha nǝghǝn mǝmǝl, sa ƙǝm mba wurahasǝ wa, amma na tsahang kwaman Faara fiya ha tǝ ƙǝkafekkirha. ");
INSERT INTO hwo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nǝghǝn mǝmǝl a fannan ateng tsamnda nan Kaisar wa, nduwa awo?” ");
INSERT INTO hwo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kǝlagha Yeeso hai na mindan ɗǝfang takthleera, ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kyaɗeema pene ɗi ki Romayini. Shishingnda wunni tǝ thlǝm wunni atenggǝn?” ");
INSERT INTO hwo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nggǝmangganda, “Yi Kaisar ni.” Ndanggǝn kanda, “Fǝraman Kaisar ˈya tsauka yi Kaisar, tǝ ƙǝm fǝraman Faara ˈya tsauka yi Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A mbǝɗi ƙǝm mbangwanda ƙǝsang tǝ ˈya thlǝknǝn a mbed fiya wa. Na ǝnwulteena nda tǝ tur nggǝmndǝɗi nggǝmang nǝn kanda pa, nggasa nda hai. ");
INSERT INTO hwo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fingya Sadukiyaya, ndagha mbǝ thliirha sǝ hu mǝra wa, ɓa nda thlǝmad Yeeso ɓa tǝ tsakh mee. ");
INSERT INTO hwo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ndang ngganda, “Mala, Musa chireethleng ɗa ndǝn kan hai tǝ ndaarha, ‘A mǝr wanman niifa malɗǝ nukkun hai kula nggǝtta, na wanman tǝrangsǝ hu langaarha ka a nggǝɗanggǝn mǝrra wanman sǝ.’ ");
INSERT INTO hwo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nanǝn ya, na nafiya sǝ mǝd a wanmanggi. Tǝ pamǝnda kakhka mǝrgha kula wal wee. ");
INSERT INTO hwo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yi sǝri tǝranggǝn nuɗasǝ mǝrgha kula wal wee. ");
INSERT INTO hwo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yi mahan wai kee. Kanda na heu mǝd tǝrang nda nuɗasǝ mǝra nda kula nuɗi nggǝɗang kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Akwasamadghǝn, nuɗi ƙǝm mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nanǝnya, ahu thliirha sǝ hu mǝrra na nuɗi tsaurha yi wun tsaunǝn kanda heu mǝd, tǝrang nda nuɗasǝ?” ");
INSERT INTO hwo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ndangga Yeeso kanda, “A hu ƙǝshiidɗi ya hǝshya a kakhrha, kanda a fǝr nishya a chimadɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amma nafiya kamngga a thlii nda sǝ hu mǝra tǝ ƙǝm tsawanda ahu ƙǝshiirha na ɓayi, hǝshya mba nda kakhrha wa, mba nda fǝr nishya a chimadɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kanda ƙǝm mba nda nggǝr mǝra wa, ƙǝsǝr na nda ƙǝla fathlǝngya Faara. Tsau nda wangya Faara ƙǝsǝr thliinda sǝ hu mǝra. ");
INSERT INTO hwo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Amma aten laɓar ɗǝfǝdɗi na ngguchit ƙǝsgha waarha, ko Musa ma kyadɗa ndǝn a pǝpal tǝ ndaarha, na thliirha sǝ ahu mǝra, ƙǝsǝr aaghǝn Chinǝm, ‘Faara yi Ibrahim, Faara yi Ishaku tǝ ƙǝm Faara yi Yakubu.’ ");
INSERT INTO hwo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mbǝ Faara ni yi mǝrya wa, amma yi fa yibya ni, ahu yighǝn kanda heu nanda tǝ yibrha.” ");
INSERT INTO hwo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Fingya fasǝngya ngyakhrha ndang ngganda, “Mala, thlǝkna pathla ngga!” ");
INSERT INTO hwo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A mbǝɗi, mbǝ niifasǝ nggǝrgha tsahang mee ɓalwa. ");
INSERT INTO hwo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tǝrgha Yeeso ndanggǝn kanda, “Kǝn nanda ndaarha Ƙǝrǝsti Wan Ndauda ni? ");
INSERT INTO hwo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ndauda tǝ atenggǝn ndǝghǝn ahu Dzabura, “‘Chinǝm Faara ndanggǝn China, “Tsawu a yisǝmanna ");
INSERT INTO hwo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ƙǝl ma tsawangɗi fa tsanggiwa a kamu saryiwa.” ’” ");
INSERT INTO hwo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Aagha Ndauda nden, ‘Chinǝm.’ Ƙǝƙǝn ƙǝm na nda ndaarha Wan Ndauda ni?” ");
INSERT INTO hwo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ndanggǝn fatsahayighǝn a mbed fiya, ");
INSERT INTO hwo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kwarama tǝ Fasǝngya ngyakhrha. Kanda na mindansǝ kal kaɓaya fa a nanda a wiirha hai a yid fiya. Na mindansǝ a ndangga fiya ˈya kanda ahu kasu. Na mindansǝ ƙǝm a fǝrang mbǝd tsaukya nda kanda na nggǝngga ahu ƙǝngya hwan Faara tǝ mbǝya wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kanda ni na hǝb langad nishya mǝrna chimayindan, na nda djib hwan Faara tǝna fiya ndaarha ka nafiya ni kanda. Tur nafiniya na Faara sǝsang kanda kaan ma fingya.” ");
INSERT INTO hwo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tǝrangna Yeeso tenggǝnsǝ, na fa ƙǝnaya nǝn ɓanda ɓa tǝ fǝryindan kanda a irangnda ahu panjakwad Ƙǝn Faara hai na manggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na nuneefa nǝn mǝrna chimadghǝn ƙǝm tǝ yamirha fǝr yighǝn nǝn anini sǝri. ");
INSERT INTO hwo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ndagha Yeeso, “Kǝkafek niya pǝranggǝn kun, fǝrrǝɗi ki nuɗi tǝ yamidɗiya kalɗǝ yi fingya na heu. ");
INSERT INTO hwo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nafini na heu ya fǝrghanda ahu hangnda ˈya na nanda tǝghǝn ha, amma ndǝghǝn nggi ahu yamidghǝn fǝrɗǝ ˈya na a harghǝn heu.” ");
INSERT INTO hwo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tǝrgha fingya fatsahayighǝn katǝrang ngganda tsǝ laɓara hai aten tǝn ƙǝn hwan Faarɗi na manggǝn tǝ ferya na nggǝngga, sakhɗang nanda sǝ tǝ ǝn fǝrya a Faara. Amma ndagha Yeeso, ");
INSERT INTO hwo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kǝla nanun feryini ya, yoo! Na farghǝn ɓayi mbuwanda malang feera aten shadghǝn. Ko yanggini ahur ndan nanda a changgǝlang kanda hai.” ");
INSERT INTO hwo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsakh mee nda, “Mala, akwan na ǝnggini a katǝrarha hai ya? Tǝ ƙǝm mani ǝn sakhrha na a sǝnansǝ nduwus ɓenɗaɓa ya?” ");
INSERT INTO hwo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ndǝghǝn, “Kwarama kanda, amana nda sakhɗang kun. Ƙǝsǝr fiya hangga na a ɓarhaɓa ahu thlǝmna na nda a ndaarha, ‘Nggini Ƙǝrǝsti,’ tǝ ndaarha ƙǝm ‘nduwus ɓenɗaɓa.’ Ma mbuɗun samandan wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A tǝrǝmɗun wa, a sǝkɗun laɓar yangya tǝ kakyathlanga. Kǝkafekni a katǝragha ǝnggina hai ya ˈwan, amma mii ngwaladghǝn ɓalghǝn kula ɓarha ɓa.” ");
INSERT INTO hwo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tǝrgha ndanggǝn kanda, “Tur nǝn thleng tur fa, kutǝryirha ƙǝm nǝn thleng kutǝryirha fa. ");
INSERT INTO hwo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na ƙǝshiirha a rǝbrha fa kaan, tǝ mirha, tǝ patal a mbǝya ɗǝɗamǝn. Na ǝntǝrǝmgya a naarha sǝ tǝ ƙǝm nun na ǝnsakrha yi wulteena hangga a fǝrakh amshi. ");
INSERT INTO hwo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Amma kapa na ǝnggini katǝrarha hai ya, nanda a ƙǝsang kun, sǝsangganda kun. Nanda a ɗǝrha tǝ kun ahu ƙǝngya hwan Faara ɗǝ, tǝ ƙǝm muwangganda kun ahu porsǝna ɗǝ. Nanda a ɗǝrha tǝ kun a mbed kutǝrya ɗǝ tǝ ngwamnaya ka thlǝmna. ");
INSERT INTO hwo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ənɗaniya na fǝrang kwamana kun pǝr ƙǝkafek nun atenna. ");
INSERT INTO hwo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amma tsaunǝn kee, ˈwama teena nggon fa ahur nun ma ɓillaɗun tǝ kwaman thlang fannun sǝ a mbed fa ngwa kumaya wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ƙǝsǝr niya fǝrang pathla kun tǝ sǝnda, ko tal ahur fa tsangginun mba nda mbang kyakhrang laɓarnun hai, nduwa ngaalangganda kun wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ko fa nggǝt yinun, tǝ wanmangginun, tǝ hurfayinun, tǝ pashiyi nun na nda a fǝr kun. Na nda a ɓǝlang nda fingya ƙǝm ahur nun. ");
INSERT INTO hwo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fiya na heu nanda a karkun ƙǝsǝr ka nggi. ");
INSERT INTO hwo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amma ko tal ahu was tennun mbusǝ na a sahatta wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","A ƙǝrǝsɗun, nun a hǝrǝkrha.” ");
INSERT INTO hwo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Anaɗun sodjaya tǝrang nda hurshe Urshelima teena, a sǝnunsǝ takh nda a chang hai. ");
INSERT INTO hwo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tǝrgha fingya na ahu Yahudiya, ɗaa nda wumngya sǝ. Fingya ƙǝm na a wupǝri kya nda sǝ, fingya ƙǝm, na hu talya a ɗǝnda wupǝri ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ƙǝsǝr sayidɗiya ɓen sǝsaarha ni, tǝ lǝghǝtta ǝngya heu chireethleng nanda hai. ");
INSERT INTO hwo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kawama nishya na ahur, tǝ fingya na wanggindan a iirha! A farɗiya, na sǝsaarha a kyarha hu chehwedɗa hai tǝ sǝbrha hur Faara aten nafini ya. ");
INSERT INTO hwo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nanda a ɓǝlang fingya tǝ thlaukh ƙǝlara, ƙǝsangganda fingya tsawa nda porsǝngya hu chehweeya ɗǝ pak. Fingya mbuwa Yahudaya, nanda thlǝ Urshelima sǝssangganda ƙǝl ma lǝghǝd ɓen ndan. ");
INSERT INTO hwo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nun a na ǝn tǝrǝmngya a fad yanfaara, ndǝre tǝ wufǝlngarya. A hu ƙǝshiirha ƙǝm, na fiya a peela hai ka hǝreenga ƙǝsǝr ka hufrha tǝ yanda wuri aama. ");
INSERT INTO hwo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nǝn a shiwid fiya teena ka tǝrǝmnda, na ƙǝfayindan a haara ka ǝngya na a ɓarha hu ƙǝshiirha ɓa, ƙǝsǝr ǝngya na mǝmanggǝn a fǝrakh amshi nanda a tsǝ ˈya fa. ");
INSERT INTO hwo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A farɗi, nanda a na Wan Niifa ɓayi ahu hashmbe tǝ sǝsǝmnda tǝ mamnggirha kaan. ");
INSERT INTO hwo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ana ǝnggini a katǝrarha hai ya, thlema sǝ tǝranggun tennun talara sǝ, ƙǝsǝr far hǝrǝƙrǝnun nduwusɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Thlǝghang karapu ɗa nǝn kanda sǝ ya, “Kǝlaman shiɓarha tǝ ɗǝfya na heu. ");
INSERT INTO hwo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A hǝrǝmna nda katǝrang tsǝtsǝtta hai, kun tǝ altennun sǝnɗunsǝ nduwus fegrha ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nǝghǝn kee ƙǝm, anaɗun ǝnggini a katǝrarha hai ya, sǝnɗunsǝ Kutǝryid Faara nduwus ɗa ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Niya pǝrang ƙǝkafek kun, nafiya ƙǝshiid weeriya mba nda a mǝra wa, ƙǝl katǝrana ǝnggina hai ya ˈwan. ");
INSERT INTO hwo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nda talara tǝ hweeɗe nanda a ngwalarha, amma laɓarna mbǝ tam ngwalarha wa. ");
INSERT INTO hwo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kwarama, amana hur nun mǝra tǝ mbǝna farha fa, tǝ sa ǝngya na tǝrang kun in, tǝ ɓillad tsawud ƙǝshiirha. A mbǝ kewa, ɓana farɗi wal kun kula sǝndǝnun sǝ ƙǝla takthleera. ");
INSERT INTO hwo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ƙǝsǝr nǝn ɓarha ten fiya ɓa heu na a tsaurhahu ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tsawama nggu-ngwa fa, ƙǝtsar. Hwan Faara nun tǝ nun wal hǝrǝkrha aten ǝnggini na ɓa katǝrarha hai, amana shilee ɓa ƙǝsang kun isha a mbed Wan Niifa.” ");
INSERT INTO hwo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ka fad par fara fa, na Yeeso tsaharhaha hu Wuri Faara. Ka fad figrha fa ƙǝm nǝn kyarha sǝ, ɗǝgha mǝnda a wumnda nanda aarha Wumnda ɗǝfya Dzaitun. ");
INSERT INTO hwo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A tsar ƙǝrǝt, na fiya ɗǝrha hu Ƙǝn Faara ɗǝ na manggǝn ka a sǝk laɓarghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nanǝnya, far Wutsǝfayirha yi Mburodi kula Mekhna, nanda aarha Tǝɗaarha a nduwussa ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mamnda Firistaya tǝ famalǝmngya ngyakhrha nanda a kaɗa kwaman ɓǝlang nda Yeeso ɓǝɓee, ƙǝsǝr nanda a tǝrǝm fiya. ");
INSERT INTO hwo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tǝrgha sheetan kyagha ahur Yahuda hai, nanda aarha Iskaryoti, tal ahur kumkap sǝri ɗi. ");
INSERT INTO hwo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuda ɗǝgha thlǝmad mamnda firistaya ɗǝ tǝ mamngya na a ƙǝla Ƙǝn Faara ha na manggǝn, ndiya nda aten kwamana nǝn a fǝr Yeeso a kanda. ");
INSERT INTO hwo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tǝk mbǝnda nda fa kaan, nggǝma nda fa a fǝrang wuɗǝɓǝla nda. ");
INSERT INTO hwo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahuda ƙǝm nggǝmɗafa kee, ƙǝla sayidɗa nǝn fa mbuwana fiyasǝ a fǝr Yeeso nǝn a kanda. ");
INSERT INTO hwo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tǝrgha nduwusna far Wutsǝfayidɗa ɓa yi Mburodi kula Mekhna. Far ɗa na nda na sataka tǝ wan kamnda yi Tǝɗaarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Thlǝngga Yeeso Mbiturus tǝ Yahaya ndanggǝn kanda, “Ɗamaɗǝ ɗun ngwang nda ƙǝmfa ɗǝm hǝb ǝnnadmid ter wutsǝfayid Tǝɗaarha.” ");
INSERT INTO hwo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tsahang mee nda ha, “A yanggi na midwa sǝ ɗan ngwadɗa fa?” ");
INSERT INTO hwo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ndanggǝn kanda, “A kyaɗun hur talɗa hai, ɓana niifa wal kun tǝ tsulina ha. Mbuwama samadghǝn ta minɗǝɗa ɗǝ nǝn a kyarha sa hai.” ");
INSERT INTO hwo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ndanggun tǝ wuriɗi, “Tǝmalǝmnda ni tsakhka mee, ‘Na ƙǝn rongya a yanggi, niya hǝb ǝnnadmid Tǝɗaarha sǝ, tǝ fatsahayina?’ ");
INSERT INTO hwo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nǝn a kyaɗang ƙǝnna kun na manggǝn, na tǝ mbǝd tsaukya sǝ hangga. Ngwama fa a mbǝɗi.” ");
INSERT INTO hwo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wii nda ɗanda walghǝn mǝmǝl ƙǝla pǝrangna Yeeso kanda. Ngwandafa a mbǝɗi tǝ ǝnnarhami yi wutsǝfayid Tǝɗaarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsǝna sayidɗa hai, Yeeso tǝ wan thlǝnggighǝn tsawa nda hai ka a hǝb ǝnnarhami nda. ");
INSERT INTO hwo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ndanggǝn kanda, “Nǝghǝn a kukwase fa na a hǝb ǝnnadmid Tǝɗaarha ni tǝ kun kapa ni sǝsaarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Niya pǝranggǝn kun, mbiya nggǝr hǝbghǝn ɓalwa, ƙǝl ma ɓad lǝghǝttǝghǝn ɓa ahu kutǝryid Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Akwasamadghǝn tǝranggǝn wuhuleu aam inabi sǝ, usa Faara nǝn, ndanggǝn kanda, “Thlama, ndǝghaman hai. ");
INSERT INTO hwo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Niya pǝranggǝn kun, mbiya nggǝr sa aam inabi ɓalwa, ƙǝl ma ɓad kutǝryid Faara ɓa.” ");
INSERT INTO hwo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tǝranggǝn mburodi sǝ, usa Faara nǝn, kyanggǝn hai, fǝranggǝnǝn kanda, ndagha, “Thlu fanna niya fǝr nda ka kun. Nama kee non a ɗal nggi in.” ");
INSERT INTO hwo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nǝghǝn kee ƙǝm, akwasamad ǝnnadɗami, tǝranggǝn wuhuleuɗa sǝ, ndagha, “Wuhuleuɗiya, yi weerǝnda ƙǝn pathnani ahu farna, irgha ɗǝ ka kun. ");
INSERT INTO hwo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amma niifɗi na a fǝr nggi kan nan a mbǝrha tal a hǝbrha. ");
INSERT INTO hwo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wan Niifa nǝn a mǝra ƙǝla tǝ ndana nda, amma ǝn kawa ni a niifɗi tǝ fǝrgha ndǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Katǝrang ngganda tsahang mee ndan ha tǝ wunni ahur ndan na mbang ǝna tur ǝnɗiya. ");
INSERT INTO hwo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Thliigha ngaala sǝ ƙǝm a pathlang ndan tǝ wunni ahur ndan na a tsaurha manggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ndangga Yeeso kanda, “Kutǝrya fingya sǝngwa Faara tǝ mamngya, nanda kyaɗang ngyakhrha fiya, tǝ ƙǝm nanda tǝr fandan fa ɗangya fiyasǝ. ");
INSERT INTO hwo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amma a tsauɗun kee wa. Ameyedghǝn, yanɗi na manggǝn ahur nun tsauka ƙǝla ndǝghǝn ni ngguchit, tǝ kal mbeerha ƙǝm tsauka ƙǝla mafarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yanggini manggǝn, yanɗi tsauka hai na a hǝbrha wa, nduwa yanɗi fǝrgha ǝnnarhami ɗǝ wa? Mbǝ yanɗa ni tsauka hai na a hǝbrha wa? Amma niyi a pathlang nun ƙǝla mafarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kunni ishgha tǝ nggi ahu ƙǝƙǝrra sanifa. ");
INSERT INTO hwo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fǝrang ɗi kutǝryirha kun, ƙǝla yanɗi fǝrena Pǝpa. ");
INSERT INTO hwo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tsaunǝn kee, nun a hǝbrha tǝ sarha a thlǝmanna hu kutǝryidna tǝ ƙǝm nun a tsaurha aten tsǝnggamngya, ngwang kumarha nun turya kumkap sǝri yi Isǝreela.” ");
INSERT INTO hwo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Mbiturus, Mbiturus! Hwan sheetan kwamana na a ƙǝƙǝranggǝn kun na heu ƙǝla na tǝ huɗarha pǝr wan hwalirha. ");
INSERT INTO hwo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amma hwanoɗi Faara teena Mbiturus, amana fǝrƙǝkafekkid wa ƙǝɗiirha. A kyaharna ɓa, kalang wanman nggiwa sǝ ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Amma nggǝmangga Mbiturus ndǝghǝn, “Paɓa, niyi nggungwa fa a ɗǝm hu porsǝna ɗǝ kyab, ana ǝn mǝrra ni, mǝrǝm kyab!” ");
INSERT INTO hwo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ndangga Yeeso, “Niya Puroƙǝn Mbiturus, kapa na ɗiyarha tǝtaarha a fǝɗikɗiya na ngal sǝnɗǝna katǝra mahan.” ");
INSERT INTO hwo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tǝrgha Yeeso tsahang mee nǝn fatsahayighǝn, “Thlǝnni kun kula wuɗǝɓǝla, kula ǝnnarhami, kula pakhma, ƙǝɗeng ɗun ˈya wa?” Ndanda, “Awo!” ");
INSERT INTO hwo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ndanggǝn kanda, “Amma nanǝnya ana wuɗǝɓǝla sǝ a har nun ƙǝsamadghǝn ha, tǝ ƙǝm ǝnnarhami. A mbǝ thlaukh ƙǝlara sǝ a harwa wa, heng luwudwa ɗǝ hiina. ");
INSERT INTO hwo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nǝghǝn chichireethlee hai tǝ ndaarha, ‘Wumangnda tǝ fa ɗimiya,’ niya pǝranggǝn kun tǝtani a lǝghǝdgha atenna. Ƙǝsǝr ǝnɗi chireethleng nanda hai atenna takhɗǝ a lǝghǝtta.” ");
INSERT INTO hwo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ndangga fatsahayighǝn, “Paɓa kuloɓa! Thlaukh ƙǝlarya sǝri ya.” Ndangga Yeeso kanda, “Tsǝkɗǝ kee.” ");
INSERT INTO hwo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kyagha Yeeso sǝ ƙǝla nǝn tǝ ǝnaarha, tǝrgha hu Wumnda ɗǝfya Dzaitun sǝ tǝ fatsahayighǝn a samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sǝlnǝn mbǝɗaɗǝ, ndanggǝn kanda, “Hwanama Faara amanun ɗǝ mukrha hu ƙǝƙǝrra hai.” ");
INSERT INTO hwo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nduwusgha mbeeɗǝ ma kanda, ɓǝrgha hai hwan Faara nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ndagha, “Pǝpa a nggǝmnafa tǝree sǝsaɗɗaɗiya, mbǝ nggǝmnda hurna wa, amma ˈya nggǝmna hurwa ndǝna mǝmǝl.” ");
INSERT INTO hwo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ɓagha tǝ thlǝnda Faara thlǝmadghǝn ɓa a talara hai fǝrang kanglanggirha nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ndǝghǝn hu sǝsaarha kaan, ɗǝgha mbeeɗǝ tǝ hwan Faara tǝ ƙǝkafekkirha nagha thlǝthlǝndǝghǝn a tsǝtsaarha hweeɗe hai ƙǝla fara. ");
INSERT INTO hwo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Thliinǝn sǝ ka hwan Faara, wudgha thlǝmad fatsahayighǝn ɗǝ ɗǝgha wal kanda a shiirha ka sǝbrha hura. ");
INSERT INTO hwo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsahang mee nǝn kanda, “Kama nun a shiirha? Thlemasǝ hwan Faara nun amawanun mukrha hu ƙǝƙǝrra hai,” ");
INSERT INTO hwo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ndǝghǝn aten thlǝk pathla ɓagha fiya ɓa hangga, tǝ niifɗi na nda aarha Yahuda. Nǝghǝn tal ahur kumkap sǝri ɗi, ndǝghǝnni a kal mbeerha. Ɗǝgha thlǝmad Yeeso ɗǝ ka a fǝɓanggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tǝrgha Yeeso tsahang mee nǝn, “Yahuda ashe tǝ fǝbrha na a fǝr Wan Niifa?” ");
INSERT INTO hwo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Fatsahaya Yeeso ƙǝla na nda hai na ˈya sǝ na a katǝrarha hai tsahang mee nda Yeeso, “Paɓa, kyath kanda nan tǝ thlaukh ƙǝlaryi nan wa?” ");
INSERT INTO hwo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tǝrgha tal ahur ndan kyathlanggǝn thlǝmad mafad firis ɗǝ na manggǝn a yi sǝma. ");
INSERT INTO hwo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ndangga Yeeso fatsahayighǝn, “Malaman kanda!” Tsuwar thlǝmadɗa nǝn fa ki niifɗi kyathlang nanda ɗǝ ƙǝnanggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tǝrgha ndangga Yeeso mamnda Firistaya, tǝ mamngya fa ƙǝla Kǝn Faara ha na manggǝn, tǝ fingya shingya ɓagha ɓa ka ndǝghǝn, “Tǝrwun nggi niyi tǝmbǝng nun ɓarha ɓa tǝ thlaukh ƙǝlarya, tǝ sǝsalya ka a ƙǝsewun wa? ");
INSERT INTO hwo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ƙǝtsar nggi a thlǝman nun a pǝpal Wuri Faara ƙǝsewun wa, amma nanǝn ya sayid nun ni na Sheetan a ǝna taara tǝ kun.” ");
INSERT INTO hwo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tǝrgha ƙǝsangganda Yeeso ɗǝnda tǝghǝn minda ki Firis ɗǝ na manggǝn. Mbiturus ƙǝm mbu samandan nǝn ɗǝ inggun ma kanda. ");
INSERT INTO hwo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Amma dzǝk na nda waarha a pǝpal wuriɗi, tsawa nda hai kanda na heu a thlǝma wadɗi, ɓagha Mbiturus ɓa tsauka hai ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tal ahur wangya nishya na ǝna taara ahur wuriɗi na Mbiturus nǝn tsau a thlǝma wadɗi. Irang yirha nǝn fa, ndǝghǝn, “Niifɗiya, kanda ni tǝ Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amma Mbiturus ngalghǝnǝn ndagha, “Sa nuɗiya, nggi fa sǝngwi ndǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tsǝɓaku na niifasǝ nagha Mbiturus, ndagha, “Sa ƙǝm na tal ahur ndan.” Ndangga Mbiturus, “Sa pashi! Mbǝ nggi ni wa.” ");
INSERT INTO hwo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsǝnǝn tsǝɓaku faɗǝn, nggǝrgha niifa ndaarha, “Mbǝ ngaala sǝ wa, niifɗiya kanda ni tǝghǝn, ƙǝsǝr tǝ Nggalilarha ni.” ");
INSERT INTO hwo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ndagha Mbiturus, “Sa pashi! Sǝngwi ǝnɗi na a thlǝkrha ya wa!” Ndǝghǝn kula nggǝlang mighǝn tǝtaagha ɗiyarha. ");
INSERT INTO hwo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chinǝm kyahargha hai ƙǝlanggǝn Mbiturus ɗǝ. Tǝrgha Mbiturus ɗal teena nǝn hai tǝ ǝnɗi thlǝghang na Chinǝm, “Kapa na ɗiyarha tǝtaarha a fǝɗik weeriya na a ngal sǝnɗǝna katǝra mahan”. ");
INSERT INTO hwo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tǝrgha Mbiturus ɗǝgha ƙǝshaaɗǝ tǝgha kaan. ");
INSERT INTO hwo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Fa ƙǝlaya Yeeso ha katǝrang ngganda waghǝn hai na nda a ɗǝkƙǝn ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kǝnangganda yidghǝn ana nda a tsahang mee ha, “Kulo, wunni ɗǝkka sa.” ");
INSERT INTO hwo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nanda a ˈyarghǝn tǝ laɓar sarfaya a ndǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɗathna mbǝrha hai wumngga mamngya Yahudaya ɓa. Kandani na mamngya firistaya, tǝ fasǝngya ngyakhrha. Ɓa nda tǝ Yeeso a mbed ndan ɓa. ");
INSERT INTO hwo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ndang ngganda, “Ana sani Ƙǝrǝsti, pǝranggǝn kan.” Nggǝmangga Yeeso kanda, “A pǝrangɗi ndǝn kun, mbun a fǝrƙǝkafek wa, ");
INSERT INTO hwo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","tǝ ƙǝm a tsahangɗi mee kun ha mbun a nggǝresǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amma ka a weeriya, na Wan Niifa a tsaurha a yisǝmad Faara na tǝ ngyakhrha ha heu.” ");
INSERT INTO hwo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kanda na heu tsahang mee nda ha, “Wan Faara ni sa wa?” Nggǝmanggǝn kanda, “Pǝrɗundǝn, nggini.” ");
INSERT INTO hwo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tǝrgha ndaa nda, “Kama nǝm nggǝr kaɗa pathya atenggǝn? Sǝkɗǝm ndǝn hai a mighǝn.” ");
INSERT INTO hwo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tǝrgha mamngya Yahudayini heu thliinda tǝ Yeeso a mbed Mbilatus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Katǝrang ngganda ɗahang nda fa, “Ɗǝghan wal niifɗiya a tsang teena nafinǝm. Nagha a ndang nda kanda a teng nda tsamnda Kaisar wa, tǝ ƙǝm wai ndǝghǝnni Ƙǝrǝsti, kutǝra.” ");
INSERT INTO hwo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsahangga Mbilatus mee Yeeso, “Sani na kutǝr Yahudaya wa?” Nggǝmangga Yeeso ndǝghǝn, “Nǝghǝn kee, ƙǝla thlǝkna.” ");
INSERT INTO hwo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tǝrgha ndangga Mbilatus mamnda firistaya, tǝ fiya na heu a mbǝɗi, “Nggi nawi niifɗiya tǝ ɗimiyirha fa wa.” ");
INSERT INTO hwo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɗǝnda mbeeɗǝ tǝ ɗahang fa tǝ ndaarha, “Tsahadghǝn ha nǝghǝn a tsang teena fiya a chehweed Yahudiya na heu. Katǝranggen hai a Nggalili har ta mbǝɗa ɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sǝkna Mbilatus ndǝn kee, Tsakhmee nǝn tǝ ndaarha, “Tǝ Nggalilarha ni wa?” ");
INSERT INTO hwo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sǝknǝn ndaarha kyagha Yeeso ɓa a manɗi na Hirdus a ǝna kutǝryirha sǝ, thlǝnanggǝn Yeeso a thlǝmad Hirdus ɗǝ, ƙǝsǝr a farɗi nǝghǝn a Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nana Hirdus Yeeso, tǝk mbǝnda nǝn fa kaan, ƙǝsǝr ka ƙǝtǝm na midghǝn sǝ a nang yirha nǝn fa. Aten ǝngya ˈwaa nǝn sǝkrha atenggǝn, na midghǝn sǝ a ǝna ǝnwulteena nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hirdus tsahang miiya nǝn ha hangga, amma Yeeso kalwa sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mamnda firistaya tǝ famalǝmngya ngyakhrha kanda a mbee ƙǝƙǝt a ɗahang pathya fa. ");
INSERT INTO hwo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tǝrgha Hirdus tǝ sodjayighǝn sarangganda ɗǝ tǝ ƙǝm waghǝnda. A mbǝɗi kalang kaɓarha nda fa yi kutǝryirha, wuɗangganda thlǝmad Mbilatus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hirdus tǝ Mbilatus afar ɗani tsaunanda pashiyi, ƙǝsǝr ka ƙǝtǝm mba nda kalang ndan sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mbilatus aah mamnda firistaya nǝn ɓa, tǝ mamngya tǝ fiya na hǝu. ");
INSERT INTO hwo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ndanggǝn kanda, “Ɓeenun niifɗa ɓa ya tǝ ndaarha nǝghǝn a tsang teena fiya. Nanǝnya, raɗi mu pathɗa haya tǝ tsakh miiya tsahang ni a mbennun, walanggi tǝ ˈya na ɗimi tǝ ndanun wa. ");
INSERT INTO hwo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirdus ƙǝm nawa ndǝn tǝ ɗimiyirha fa wa, ndǝghǝn ɗani wuɗang nǝn thlǝmad nǝm ɓa. Mbǝ ˈyasǝ ǝnana kamshiɗiya tsǝkka a ɓǝlanggǝm wa. ");
INSERT INTO hwo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nanǝn kee, niya tsaɗaghǝn kee kalghǝni hai.” ");
INSERT INTO hwo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kanda heu tǝrang ngganda urandan sǝ tǝ ndaarha, “Ɓǝlamam kamshiɗiya! Kalaman Mbarabas kan hai!” ");
INSERT INTO hwo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Muwangganda Mbarabas ƙǝnɗǝ ka tǝbǝnggidghǝn ǝna nǝn ahu talaɗǝ na manggǝn, tǝ ɓǝlang nǝn niifa. ");
INSERT INTO hwo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mbilatus na midghǝnsǝ a kal Yeeso nǝn hai, nggǝrghǝn kalang kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amma karnda fa na nda a huhwarha tǝ ndaarha, “Tawaman ɗǝ! Tawaman ɗǝ!” ");
INSERT INTO hwo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Katǝra mahan Mbilatus a kalang kanda sǝ, “Kama nda? Ɗimiyid ma ǝna na kamshiɗiya? Nggi nawi ndǝn tǝ ɗimiyirha tsǝkka a ɓǝlang nggǝm wa. Niya fǝrghǝn tsaɗaghǝn nda kalghǝn nda hai.” ");
INSERT INTO hwo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amma isha nda aten path ndan, na mindan sǝ tawangganda ɗǝ. A kwasamadghǝn huhwan ndan kalɗǝ mbǝrha mu. ");
INSERT INTO hwo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mbilatus ƙǝm ǝnagha ƙǝla na mindan. ");
INSERT INTO hwo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kal niifɗa nǝn hai tǝ muwang nanda hu porsǝna ɗǝ ka tǝbǝnggidghǝn ǝna nǝn, tǝ ɓǝlang nǝn niifa ƙǝla tsakhna nda. Fǝrang Yeeso nǝn kanda, ƙǝla na mindan. ");
INSERT INTO hwo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na nanda a wiirha tǝ Yeeso, ƙǝma nda tǝ niifa nanda aarha Siman tǝ Sayirarha. Ndǝghǝn ɓayi ahu tala na ngguchit, ngyaɓang tǝr kaɗidɗa nda fa, tǝranggǝn mbu samad Yeeso nǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Fiya hangga mbuwa samadghǝn, ahur ndan ƙǝm nishya sǝ na a tǝrha tǝ huhwarha ka ndǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kyahargha Yeeso hai, ndanggǝn kanda, “Nishya Urshelima, a tǝɗun ka nggi wa, tama ka alten nun, tǝ wangginun. ");
INSERT INTO hwo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ƙǝsǝr na fara ɓayi, ɓa nun ndaarha, ‘Fa parkayani kwarengya, tǝ hurya ˈwawa wa nggǝtta tǝ ɓee iwana wee iirha!’ ");
INSERT INTO hwo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tǝrgha “‘Na fiya a ndang nda wumngya, “Muwa ma tennan hai!” Ndang ngganda mbǝya na ɗangkam, ɗangkam, “Nggǝlaman kan!” ’ ");
INSERT INTO hwo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A ǝna fiya ǝngginiya ndǝghǝn ɗǝfrha ɓalɗǝ nduwun, mani katǝrarha hai a hwarɗǝ?” ");
INSERT INTO hwo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nafiya sǝri, fa mbǝlfeeya, wii nda tǝ kanda ka a ɓǝlangganda kanda tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɓa nanda mbǝɗa ɓa na nda aarha Mbǝd Ɓalhwar Teena, a mbǝɗa ni tawang nanda ɗǝ tǝ fa ɗimiya sǝri, tal a yisǝmadghǝn tal ƙǝm a yi kawadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ndagha Yeeso, “Pǝpa, chahanggǝn kanda ɗǝ, ƙǝsǝr sǝngwanda ǝnɗi nanda a ǝnaarha wa.” Əna wura nda aten lukkighǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ishgha fiya hai kanda a ƙǝlarha. Mamngini ƙǝm kanda a waghǝn, nanda a ndaarha, “Hǝrghanggǝn fingya, a hǝrghanggǝn altenggǝn ƙǝm lee, ana ndǝghǝnni Ƙǝrǝsti, Wurra Faara!” ");
INSERT INTO hwo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sodjaya ƙǝm ɓa nda ɓa nanda a waghǝn. Fǝrang aam inabi nda sǝ na chichakh. ");
INSERT INTO hwo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ndang ngganda, “Ana kutǝr Yahudayani sa hǝrghang altenwa lee!” ");
INSERT INTO hwo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aman tenggǝn ƙǝm chirethlengganda hai, “KUTƏR YAHUDAYA NI YA.” ");
INSERT INTO hwo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tal ahur fa mbǝlfeyini tawangnda kanda ɗǝ tǝghǝn thlǝghang pathya nǝn sǝ na iˈikh nagha a ndang nda, “Mbǝ sani na Ƙǝrǝsti wa? Hǝrghang altenwa tǝ kan ƙǝm lee!” ");
INSERT INTO hwo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amma tahad tǝ mbǝlfedɗi djaranggǝn ɗǝ ndagha, “Mba tǝrǝm Faara wa, sa walgha wadghǝnfa mǝmǝl tǝghǝn? ");
INSERT INTO hwo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ənangganda ƙǝm mǝmǝl, ƙǝsǝr ƙǝna ˈya ǝna nǝm ndǝ walnǝm. Amma niifɗiya mbǝ ˈyasǝ ǝnanǝn na ɗimi wa.” ");
INSERT INTO hwo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tǝrgha ndagha, “Yeeso, ɗalu nggi teena a ɓanna hu kutǝryid wa ɓa” ");
INSERT INTO hwo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nggǝmangga Yeeso, “Niya puro ƙǝkafek, a weeriya ɗǝna naarha a thlǝmanna a talara.” ");
INSERT INTO hwo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Fara a sǝrǝkrha, tǝrgha wula nggǝlanggǝn chehweerha heu, har yargha yanfaara hai. ");
INSERT INTO hwo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ƙǝsǝr yanfaara malang ɗǝ djaara hai. Shishamarɗi na a mbǝɗi na tsǝtsaɓa ɗǝ kaan hu Ƙǝn Faara djargha hai sǝri. ");
INSERT INTO hwo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tǝrangga Yeeso uradghǝn sǝ kaan ndagha, “Pǝpa, ahu harwa hai niya fǝr yiɓǝnna.” Thlǝknǝn ndǝn kee, mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mamnda sodja ɗi na ƙǝt a mbǝɗi nanǝn ǝnɗi katǝragha hai, fal Faara nǝn ndagha, “Kǝkafek niifɗiya ka niifa ni.” ");
INSERT INTO hwo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nafini ngwagha hai ka ƙǝlarha, na nanda ǝnɗi katǝragha hai, kanda na heu wuɗa nda wureɗǝ kanda a ɗǝk ƙǝfayindan hu sǝbrha hura. ");
INSERT INTO hwo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amma nafini na heu sǝngga Yeeso tǝ nishyini mbuwa samadghǝn ɓa, ka ahu chehweed Nggalili ɓa, isha nda ɗǝ inggun, nanda a ƙǝlang ǝnɗi na a katǝrarha hai. ");
INSERT INTO hwo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na niifasǝ thlǝmnggǝnni Yisǝfu, nǝghǝn ahur mamngya na ƙǝnang pathla hai, ka niifa ni. ");
INSERT INTO hwo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nggǝmngwa fa tǝ ǝnɗi ƙǝnang na nda hai wa. Ɓaghǝn ɓa ahu tal Aramatiya na a chehweed Yahudaya tǝ ƙǝm nǝghǝn a ƙǝla kutǝryid Faara fa. ");
INSERT INTO hwo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɗǝgha thlǝmad Mbilatus ɗǝ hwan mǝrra Yeeso nǝn a panggǝn. ");
INSERT INTO hwo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tǝrgha tǝranggǝn hweeɗe hai, faɗanggǝn hu kaɓad pa mǝrra hai, ɗǝfanggǝn hu kwadɗa hai rana nda ahu feera, yanɗi ˈwa wanda pa mǝrra sǝ. ");
INSERT INTO hwo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Far ngwarha ni fa yi yibrha Yahudaya, takh nda a kyarha hu far yiɓǝdɗa hai. ");
INSERT INTO hwo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nishyini ɓaa ɓa a samad Yeeso ka a Nggalili ɓa, mbu samad Yisǝfu nda, na ten kwadɗa nda, tǝ mbǝɗi hunang nanda sa hai. ");
INSERT INTO hwo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tǝrgha wuɗa nda wureɗǝ ngwa nda fa tǝ urdi tǝ fǝɗeerha na sǝdghǝn mbǝnggǝn. Amma yiɓa nda a far Yiɓǝdɗi ka fǝrang mamnggirha nda ˈya ndana ngyakhrha. ");
INSERT INTO hwo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A hu katǝrad par fara yi ɓeena mǝd, a tsar ƙǝrǝt, nishyini tǝrang ngganda kariyi ni na sǝdghǝn mbǝnggǝn, ngwana nda fa ɗǝnda tǝghǝn a ten kwadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɗa nda wal ferɗi nggǝlang na nda mii kwadɗa sǝ kwatǝrɗǝ man patu ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Amma kyana nda sa hai, nawa nda mǝrra Yeeso wa. ");
INSERT INTO hwo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nana nda a numarha aten ǝnɗi katǝragha hai kee, kula kanda sǝndasǝ na nafiya nda sǝri tǝ lukki ndan a chimnda fa nagha ahar yirha ƙǝƙǝt a thlǝman ndan. ");
INSERT INTO hwo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka tǝrǝm nda, nishyini kwangganda tǝn ndan a hweeɗe hai, amma ndangga nafini kanda, “Kama nun a kaɗa tǝ yibrha, a pathlang mǝrya? ");
INSERT INTO hwo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɓalwa a mbǝɗiya wa, thliiɗa sǝ! Ɗalama teena hai tǝ ˈya thlǝghang nǝn kun, ndǝghǝn ɓalɗǝ tǝ kun a Nggalili. ");
INSERT INTO hwo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Wan Niifa nǝn a mukrha ahar fa ɗimiya hai, tawangganda ɗǝ, a far paara yi mahan nǝn a nggǝr thliirha sǝ.’ ” ");
INSERT INTO hwo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tǝrgha ɗal teena nda hai aten pathghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wud nanda ɓa aten kwadɗi, pǝrang ǝnggina nda heu a Kum Kap Talɗi tǝ fingya fiya. ");
INSERT INTO hwo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nda Mairamu tǝ Magdaliya, tǝ Yowana tǝ Mairamu man Yakubu, tǝ fingya nishya nananda a mbǝɗi, kanda ni pǝrangga ndǝn fa thlǝngya Yeeso. ");
INSERT INTO hwo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amma fǝrwanda ƙǝkafek tǝ path nishyini wa, ƙeser tǝrgha nda path ndan ƙǝla ɓasharha ni. ");
INSERT INTO hwo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mbiturus thliighasǝ tawad ɗagha ten kwadɗa ɗǝ. Ɓǝrgha a mii kwadɗi ƙǝlagha sa ɗǝ, na kaɓadɗa nǝn pang nandasǝ a man patu. Wudgha, ǝnwulteena nǝn tǝ ǝnɗi katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nanǝnya tsu a farɗi sǝri ahur nafiya na a mbu samad Yeeso kanda a kwaman ɗǝrha ahu tala ɗǝ nanda aarha Imawus, na iundǝghǝn mel mǝd tǝ Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kanda a tsǝ laɓara aten ǝnggini katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na nanda a tsǝ laɓara aten ǝnggini kee, Yeeso tǝ altenggǝn ɗǝgha thlǝman ndan ɗǝ wii nda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amma nggǝlang nda yindan, amana nda kukwalang hai. ");
INSERT INTO hwo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsahang mee nǝn kanda, “Laɓar ma nun a tsǝrha kee kun aten wiirha?” Isha nda hai ƙǝƙǝt, ƙǝlagha Yeeso hai na hur ndan sǝsǝɓa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tal ahur ndan, na thlǝmnggǝn Kilobas, tsahang mee nǝn, “Sa ndǝna ronga kee a Urshelima sǝngwa ǝnɗi katǝragha hai a mbǝɗi ahu ɓǝngginiya wa!” ");
INSERT INTO hwo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tsakh mee nǝn, “Mani ǝnggini?” Ndang ngganda, “Ənggini tsǝgha hai aten Yeeso tǝ Nadzarat. Annabini, ǝn ǝnadghǝn tǝ laɓarghǝn nǝghǝn tǝ sǝsǝmnda a mbed Faara tǝ fiya na heu. ");
INSERT INTO hwo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mamnda firistaya tǝ mamngginǝm fǝr ndan a ngwang kumad mǝrra nda, tawangganda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amma nan a numarha ndǝghǝnni ɓagha hǝrghang nda Isǝreela. Ma takhka ɓal, kulo, a weeriya ɓenggǝn mahan tǝ katǝrana ǝnɗa hai ya. ");
INSERT INTO hwo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mbǝ kee mawa, fingya nishya fǝrangnda ǝnwulteena kan. War nda aten kwadɗa ɗǝ a tsar weeriya, ");
INSERT INTO hwo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","amma nawa nda mǝrrǝghǝn sǝ wa. Ɓa nda ɓa ndang ngganda kan, nanda fathlǝngya Faara, ndaa nda nǝghǝn tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tǝrgha fingya ahur nan ɗǝnda aten kwadɗa ɗǝ ndaa nda nǝghǝn ƙǝla thlǝkna nishyini, amma ndǝghǝn nggi nawa ndan wa.” ");
INSERT INTO hwo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ndangga Yeeso kanda, “Hai, kama tsaunun nurya kee, mani ƙǝɗiina fǝrƙǝkafekkid nun aten ˈya thlǝkna annabiya! ");
INSERT INTO hwo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ashe, kamngwa a sǝsagha Ƙǝrǝsti aten inggini ya a kyagha ahu mamnggitghǝn ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Katǝradghǝn tǝ Musa tǝ annabiya na heu, pǝrang ɗa ndǝn kanda ˈya thlǝkna ɗeleewar Faara aten Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ndusang nanda talɗa fa nanda a ɗǝrha saɗǝ, tsǝgha Yeeso ƙǝla nǝn a mbǝra mbeeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amma hwanggǝnda kaan tǝ ndaarha, “Tsawu a thlǝman nan, tsǝt figrha hai, kulo yanfaara hǝmɗa hai.” Ɗǝgha ɗǝ tsauka tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tsau nǝn hai nǝn a hǝb ǝnnarhami tǝ kanda, tǝranggǝn mburodi sǝ, usa Faara nǝn, kyanggǝn hai fǝranggǝnǝn kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tǝrgha ingga yindan ɗǝ kukwalangganda hai, a mbǝɗi kee sahadgha ma yindan. ");
INSERT INTO hwo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsahang mee nda ndan, “Mbǝ tǝk ɗǝm mbǝnda fa ahur nǝm na nǝn a kalang ƙǝmsǝ a kwamana, inang nǝn laɓar Faara ƙǝm hai wa?” ");
INSERT INTO hwo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Thliinda sǝ ƙǝkar wuɗa nda Urshelima ɗǝ. A mbǝɗi ɗanda wal Kum Kap Tal ɗi tǝ fingya nafiya wumngga hai. ");
INSERT INTO hwo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nanda a ndaarha, “Ƙǝkafek ni! Chinǝm thliiɗa sǝ har kyaɗang ɗǝ fadghǝn Siman!” ");
INSERT INTO hwo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tǝrgha nafini na sǝri pǝr ǝnɗa nda katǝragha hai a kwamana, tǝ kukwalang nanda hai kyang nǝn mburodi hai. ");
INSERT INTO hwo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kanda ɓal nda a tsǝ laɓara aten ǝnɗi kee, Yeeso tǝ altenggǝn ishgha a maɗufun ndan ndanggǝn kanda, “A fifidɗun hai wa!” ");
INSERT INTO hwo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tǝr ma nda nagha fandan a rǝbrha fa, kanda a numarha mǝnda-mǝnda na nanda. ");
INSERT INTO hwo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ndanggǝn kanda, “Kama tǝrǝm nun? Kama ƙǝm nun a kwana nggi ahur nun? ");
INSERT INTO hwo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kǝla man haryina tǝ saryina. Nggi ni tǝ altenna! Tsuwarama nggi fa nawunun, ƙǝsǝr mǝnda-mǝnda mbǝ thluwa sǝ a fadghǝn tǝ ala ƙǝla nanun nggi tǝghǝn fa wa.” ");
INSERT INTO hwo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Thlǝkna Yeeso ǝnɗiya, kyad haryighǝn nǝn tǝ saryighǝn a kanda. ");
INSERT INTO hwo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ko na nanda tǝ wutsǝfayirha fa tǝ ǝnwulteena, ngwalangwanda fǝrƙǝkafek thliiɗa sǝ wa. Tǝrgha tsahang mee nǝn kanda, “Na ǝnnarhami sǝ a har nun a mbǝɗiya wa?” ");
INSERT INTO hwo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Fǝrang tǝna nda fifi. ");
INSERT INTO hwo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Thlǝghǝnǝn kiigha, kanda a ƙǝlang nda. ");
INSERT INTO hwo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ndanggǝn kanda, “Ənɗa pǝrang ni kun ya nggi ɓalɗǝ tǝ kun. ˈYa na heu ƙǝl ma lǝghǝdɗǝ chirethleng nda hai a tenna ahu ngyakhrha Musa tǝ yi annabiya tǝ ƙǝm Dzabura.” ");
INSERT INTO hwo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","“Tǝrgha ɗathlanggǝn hutǝn ndan ɗǝ, tǝna nda sǝn ˈya na chichirethlee hai ahu ɗǝleewar Faara.” ");
INSERT INTO hwo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ndanggǝn kanda, “Kulo, ǝnɗi chirethleng na nda hai ya, Ƙǝrǝsti nǝn a sǝsaarha, nǝn a thliirha sǝ hu mǝra a far paara yi mahan. ");
INSERT INTO hwo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mal ɗimiyirha tǝ chakhrǝghǝn ɗǝ nanda a pǝrghǝn ɗǝ ahu thlǝmnggǝn a ƙǝshiirha na heu, nǝn a katǝrarha hai a Urshelima. ");
INSERT INTO hwo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kunni nagha ǝngginiya tǝ yinnun, pǝramadghǝn. ");
INSERT INTO hwo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ɗǝni thlǝnang Sǝsǝna tǝ Peɗǝnda kun ɓa ndana Pǝpa. Amma tsawama a Urshelima, ƙǝl nggǝlang sǝsǝmnda Faara kun a talara hai.” ");
INSERT INTO hwo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kya nǝn sǝ tǝ kanda ma Urshalima ɗǝnda mbǝrha ɗǝ tsau tǝ Mbetani fa, a mbǝɗi haranggǝn haryighǝn sǝ ɗǝfang parka nǝn kanda teena. ");
INSERT INTO hwo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nanǝn a ɗǝfang parka kanda teena, ɗǝkka hai tǝ kanda tǝrang ngganda a talara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tǝrgha ɗǝfang shilee nda teena, wuɗa nda a Urshelima ɗǝ lǝlǝgɗa tǝ wutsǝfayirha kaan. ");
INSERT INTO hwo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ka fat paara fa na nda naarha fal Faara ahu Wuri Faara. ");
INSERT INTO hwo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka a katǝradghǝn na Laɓar ɗa sǝ, na Laɓarɗi tǝ Faara, Laɓar ɗi Faara ni. ");
INSERT INTO hwo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ka a katǝradghǝn nǝghǝn tǝ Faara. ");
INSERT INTO hwo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tǝ Laɓar ɗa ni ǝnana Faara ǝngya heu; mbǝ ˈyasǝ ǝna nanda kula ndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na Laɓar ɗi fǝr yibrha a ǝngya heu ǝnana nda, yiɓǝdɗi ya ƙǝm kukwaryid fiya ni. ");
INSERT INTO hwo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na kukwaryidɗi djaara hai hu wula, wulɗi ƙǝm mbǝ sǝsǝmnda sǝ a fadghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na niifa sǝ thlǝnna Faara ɓa, thlǝmnggǝn ni Yahaya. ");
INSERT INTO hwo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tǝ kalmee ni, ɓanǝn ɓa ka a kalmii kukwaryidɗa nǝn, tǝna fiya heu sǝk laɓar kukwaryidɗi fǝrƙǝkafek nda tǝ kalmii ɗi keeghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mbǝ Yahaya tafadghǝn ndǝna kukwaryidɗi wa, amma ɓanǝn ɓa ka a kalmii kukwaryidɗa nǝn. ");
INSERT INTO hwo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka kukwaryirha na a fǝrang kukwaryirha nǝn kowunni, nǝghǝn ɓayi hu ƙǝshiirha ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na kukwaryidɗi hu ƙǝshiirha, ko nanǝn ǝnagha nda ƙǝshiirha tǝghǝn, amma sǝngwa ƙǝshiirha ndǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɓa kukwaryidɗi ahu chehweedghǝn ɓa, amma nafiyighǝn thlǝwa ndan fa wa. ");
INSERT INTO hwo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma kala nafiya thlǝgha kukwaryidɗa fa, fǝrƙǝkafek nda tǝghǝn, fǝrang ɗǝ kwamana kanda a tsawa nda wangya Faara. ");
INSERT INTO hwo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tsau nda wundakhnaya mbǝ ka nggǝt na niifa kanda wa, mbǝ tǝ nggǝmnda niifa wa, amma tǝ nggǝmnda Faara. ");
INSERT INTO hwo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Laɓarɗi tsauɗǝ niifa, tsauƙǝn ahur nǝm. Naɗǝm mamnggitghǝn, mamnggit wee na katenggǝn a thlǝmad chin, nǝghǝn lǝlǝgɗa tǝ nggayirha tǝ ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Kal Yahaya mighǝn, tǝranggǝn uradghǝn sǝ tǝ ndaarha, “Niifɗa ni pǝrang ni kun ya, ndaa ni, ‘Na niifa sǝ ɓayi a samad na kalgha nggi mu, ƙǝsǝr nǝghǝn sǝ kapa na nda nggǝt nggi.’ ”) ");
INSERT INTO hwo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ka nggayidghǝn mulgha hai, nǝn naarha fǝrang parka ƙǝm ƙǝtsar. ");
INSERT INTO hwo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Fǝr Faara ngyakhrha a manki Musa, amma nggayirha tǝ fǝrƙǝkafek ɓaghǝn ɓa a manki Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mbǝ niifa sǝ ˈwagha na Faara wa, amma yanɗi ndǝghǝn tafadghǝn Faara ni, tǝ ƙǝm nǝghǝn a tsau ɗǝdemnggirha tǝ Chin, ndǝn kyadgha Faara. ");
INSERT INTO hwo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kulo kalmiɗi ki Yahaya ya a sayidɗi thlǝnna Yahudaya Firistaya tǝ Lawiya a Urshalima ɓa, ka ɗa nda tsahang mee ha, “Wunni sa?” ");
INSERT INTO hwo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ngalwa Yahaya wa, amma kyagha pǝpal ɓa ndanggǝn kanda, “Mbǝ nggini Ƙǝrǝsti wa.” ");
INSERT INTO hwo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsahang mee nda, “Nanǝn kee, wunni sa? Sani Ilya wa?” Ndanggǝn kanda, “Mbǝ nggini wa.” Nggǝra nda tsahang mee, “Sani annabi ɗi nan a ƙǝlarha fa wa?” Ndanggǝn kanda, “Awo.” ");
INSERT INTO hwo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tǝrgha ndang ngganda, “Wunni sa? Nggǝrang kan sǝ ka ɗan pǝranggǝn nafini thlǝngga kan ɓa. Mana mbang thlǝkrha a ten wa?” ");
INSERT INTO hwo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nggǝrangga Yahaya kanda sǝ tǝ laɓar annabi Ishaya, “Nggini urarha na a aah farha a kaheerha, ‘Pǝpǝnaman kwamangya ɗǝ a Chinǝm.’ ” ");
INSERT INTO hwo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tǝrgha Farisayini thlǝnna nda ɓa, ");
INSERT INTO hwo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tsahang mee nda ha, “Kama nda na a ǝna mbaptisǝma a mbǝ sani Ƙǝrǝsti, nduwa Ilya, nduwa Annabidɗi wa?” ");
INSERT INTO hwo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nggǝrangga Yahaya kanda sǝ ndǝghǝn, “Nggi tǝ aama ni ǝna mbaptisǝma, amma na niifa sǝ ƙǝt a pathlang nun sǝngwa nun. ");
INSERT INTO hwo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ndǝghǝnni na ɓayi a samad na ɗi, nggi tafanna tsǝkki na a kwasanggi sahad pahamnggǝn hai wa.” ");
INSERT INTO hwo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Katǝragha ǝnɗa hai heu ya a Mbetani a pǝm kufad Urdun, na Yahaya a ǝna mbaptisǝma sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A ɓindayidghǝn nagha Yahaya Yeeso ɓayi thlǝmadghǝn ɓa, ndagha, “Ƙǝlaman wan Kamnda Faara ya, na a tǝrang ɗimiyid ƙǝshiirha ɗǝ! ");
INSERT INTO hwo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Niifɗa ni pǝrang ni kun tǝ ndaarha, ‘Na niifa sǝ ɓayi a samad na kalgha nggi mu, ƙǝsǝr nǝghǝn sǝ kapa na nda nggǝt nggi.’ ");
INSERT INTO hwo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nggi tafanna sǝngwi ndǝn wa, amma niyi a ǝna mbaptisǝma tǝ aama tǝna nafiya Isǝreelaya sǝnggǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tǝrgha ndagha Yahaya, “Naɗi Sǝsǝna ɓayi hai a talara ƙǝla tǝtiliurha tsauka hai a fadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sǝngwi ndǝn wa, amma Faarɗi thlǝngga nggi ɓa ka ɓi ǝna mbaptisǝma tǝ aama, ndǝghǝn ndeegha, ‘Niifɗi nana Sǝsǝna tǝrɗǝ tenggǝn hai tsauka sǝ, ndǝghǝn ni na a ǝna mbaptisǝma tǝ Sǝsǝna tǝ Peɗǝnda.’ ");
INSERT INTO hwo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naɗi ǝnɗi katǝragha hai tǝ Yeeso, nǝghǝn kee, kalɗi mee tǝ ndaarha, niif ɗiya Wan Faara ni.” ");
INSERT INTO hwo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A ɓindayidghǝn nggǝrgha Yahaya isha a mbǝɗi tǝ fatsahayighǝn sǝri a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nanǝn Yeeso a mbǝraɗǝ, ndagha, “Ƙǝlama Wan Kamnda Faara ya!” ");
INSERT INTO hwo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sǝkna fatsahayina ndǝn keeghǝn sǝri ˈya ndaanǝn, mbu samad Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kyaharna Yeeso hai, nanǝn kanda a mbu samadghǝn, tsahang mee nǝn kanda, “Mana minnun?” Ndangganda, “Rabbi, (ndarha ni Mala) na tǝ tsaurha a yanggi?” ");
INSERT INTO hwo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nggǝrangga Yeeso kanda sǝ, “Ɓama ɓa ɓun naghǝn.” A figrha ni mbu nanda samadghǝn ta mbǝɗaɗǝ nanǝn sǝ tǝ tsaurha ngwalangga nda paara tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andǝrawus, wan man Siman Mbiturus nǝghǝn tal ahur nafini sǝri sǝkka ˈya ndana Yahaya tǝ ƙǝm mbuwa samad Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tsu kee tǝrgha Andǝrawus kaɗa wanman nǝn Siman pǝranggǝnǝn tǝ ndaarha, “Walang ɗan Ƙǝrǝstiɗi.” ");
INSERT INTO hwo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɓagha tǝ Siman thlǝmad Yeeso ɓa, Ƙǝlang na Yeeso ngga ndǝghǝn, “Sani Siman wan Yahaya. Amma nanǝnya na nda a aah sa Kefas,” (ndǝna Mbiturus). ");
INSERT INTO hwo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A ɓindayidghǝn na mid Yeeso sǝ a ɗǝgha Nggalili ɗǝ. Na Filibus nǝn, ndanggǝn, “Mbuwu samadna.” ");
INSERT INTO hwo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus niif tǝ Mbatsaida tal nda Andǝrawus tǝ Mbiturus. ");
INSERT INTO hwo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Walang na Filibus Nataniyel ndanggǝn, “Naɗan niifɗi chirethna Musa a tenggǝn ahu ngyakhrha, tǝ ƙǝm chirethna annabiya a tenggǝn thlǝmnggǝn ni Yeeso tǝ Nadzarat, wan Yisufu.” ");
INSERT INTO hwo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tsakhka Nataniyel mee ndǝghǝn, “Nadzarat! Na ˈya sǝ ngga na kyarha ɓa a Nadzarat wa?” Nggǝrangga Filibus sǝ, “Ɓoɓa ɓa naghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nana Yeeso Nataniyel ɓayi thlǝmadghǝn ɓa, ndanggǝn, “Kulo ka wan Isǝreela ya na tǝ ƙǝkafek fa.” ");
INSERT INTO hwo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tsahangga Nataniyel mee Yeeso, “Ƙǝƙǝn sǝnna nggi?” Nggǝrangga Yeeso sǝ, “Naɗi sa a kamu ɗǝf shiɓaarha kapa na Filibus aah sa.” ");
INSERT INTO hwo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tǝrgha ndagha Nataniyel, “Mala, sani Wan Faara; Kutǝr Isǝreela.” ");
INSERT INTO hwo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ndangga Yeeso, “Fǝrna ƙǝkafek ƙǝsǝr ka ndoni naɗi sa a kamu ɗǝf shiɓaarha wa? Na nggǝr na ǝngya kalgha fingya yina mu ya.” ");
INSERT INTO hwo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nggǝrghǝn ndaarha, “Niya puro ƙǝkafek, na a naa talara inɗaɗǝ, tǝ fathlǝngya Faara a tǝra sǝ tǝ tǝra aten Wan Niifa hai.” ");
INSERT INTO hwo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A far ɓeena yi mahan, ǝna wutsǝfayid kakhrha nda ahu tala na nda aarha Kaana a chehweed Nggalili, tǝ ƙǝm man Yeeso a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tǝrgha mbu Yeeso nda tǝ fatsahayighǝn ahu wutsǝfayid kahadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngwalana aam inabi ɗa hai, ndangga man Yeeso, “Mba nda tǝ aam inabi ɓal wa.” ");
INSERT INTO hwo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nggǝrangga Yeeso sǝ, “Nuɗiya ma njiɗangga ƙǝm? Sayid na ɓa wa ɓa ˈwan wa.” ");
INSERT INTO hwo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Amma ndangga man Yeeso nafini na a ndǝk ǝnnarhami, “Kala ˈya thlǝghang nǝn kun ǝnama.” ");
INSERT INTO hwo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A mbǝɗi na tsulingya sǝ mikki tǝn nanda tǝ feera. Na Yahudaya naarha ǝna taara tǝ tsulinggini ka a tsaɓang fandan saaɗǝ. Kala tsulina nǝn tǝr ƙǝthlikrha kumnggit sǝri ɗǝgha hu kumnggit mahan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ndangga Yeeso nafini na a ndǝk ǝnnarhami, “Lǝgɗaman tsulinggini tǝ aama.” Lǝɗang ngganda kanda ta miighǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tǝrgha ndanggǝn kanda, “Tsaama ha sǝ ɗang nggǝnun mamnda ter ɗa ɗǝ ya.” Əna nda kee ƙǝla thlǝghang nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mamnda terɗi taarang nǝn aamɗi kyakhrang nanda ahu aam inabi ɗǝ, sǝnangwa mbǝɗa hai kyanǝn sa ɓa wa, (ko nanǝn nafini na a ndǝk ǝnnadɗami sǝn ndan). Tǝrgha aah wutsam ndǝ ɗanǝn a man patu ɗǝ ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Na fiya ˈwa fǝr aam inabi na mbǝnggǝn, akwasamadɗi saana fiya, a kyanggǝn yanɗa ɓa mbuwa wa mbǝnggǝn. Amma sa ɓǝɓengga yanɗi na mbǝnggǝn ƙǝl nanǝnya!” ");
INSERT INTO hwo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yanɗiya ndǝna katǝra ǝnwulteena ǝnana Yeeso, ǝnaghǝn ndǝn a Kaana na hu chehweed Nggalili. Kyadɗǝ mamnggidghǝn a mbǝɗi, tǝ ƙǝm fatsahayighǝn fǝrƙǝkafek nda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A kwasamadɗi ɗǝgha Kafarnahum ɗǝ heu nda man, tǝ wan manggighǝn, tǝ fatsahayighǝn, mǝna nda ha ngguchit a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nduwusna far wutsǝfayid Tǝɗaarha hai, ɗǝgha Yeeso a Urshalima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A pǝpal Ƙǝn Faara, ɗǝgha wal fiya a heng thlaaya ɗǝ, tǝ chauraya, tǝ kataprakkya yi sataka, tǝ fingya tsǝtsau a fǝr mbeɗed wuɗǝɓǝla. ");
INSERT INTO hwo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yamngga Yeeso wutǝteerha tǝ sakhrha rǝghanggǝn kanda ɗǝ ma Ƙǝn Faara, heu tǝ chauraya tǝ thlaaya, changgǝlanggǝn mbǝd mbeɗed wuɗǝɓǝl ɗa ɗǝ welgha wuɗǝɓǝlɗi hweeɗe hai. ");
INSERT INTO hwo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tǝrgha ndanggǝn nafini na a heng kataprakkya ɗǝ, “Kyaman ǝnggina hai ma mbǝɗiya, a tsawang ɗun wuri Pǝpa kasu wa.” ");
INSERT INTO hwo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tǝrgha fatsahayighǝn ɗal teena nda hai tǝ ˈya ndaana ɗeleewar Faara, “Nggǝmndǝna a wuri wa nǝghǝn a ƙǝsa sǝ a hurna ƙǝla waarha.” ");
INSERT INTO hwo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tǝrgha mamngya Yahudayini ndangganda Yeeso, “Ənwulten ma na kyaɗang nda kan tǝnan sǝnda sǝ na tǝ sǝsǝmnda ǝna ǝnɗiya?” ");
INSERT INTO hwo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nggǝrangga Yeeso kanda sǝ ndǝghǝn, “Chaman Ƙǝn Faar ɗa hai ya, ahu ɓeena mahan niya nggǝr tǝnang sǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsahangga Yahudayini mee, “Tǝnang nggan Ƙǝn Faar ɗa sǝ ˈyahu hurarha kumnggit faɗa kap mikki, ndaana wai na nggǝr tǝnang sǝ hu ɓeena mahan?” ");
INSERT INTO hwo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma ƙǝn Faar ɗi nǝn a thlǝkrha pofadghǝn ni. ");
INSERT INTO hwo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A kwasamadɗi thliinǝn sǝ ahu mǝra, fatsahayighǝn ɗal teena nda hai thlǝkɗǝ ˈya kiya. Fǝr nda ƙǝkafek tǝ laɓar Faara, tǝ laɓarɗi thlǝkna Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nanǝn a Urshalima ahu wutsǝfayid Tǝɗadɗi, fiya hangga nagha ǝnwuteengya kyad nǝn fǝrƙǝkafek nda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amma nggǝmngwa Yeeso fa tǝ kanda wa, ƙǝsǝr sǝnɗǝ fiya heu. ");
INSERT INTO hwo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mbǝ ˈya sǝ na nda thlǝghang nda a ten niifa wa, ƙǝsǝr sǝnɗǝ hur niifa. ");
INSERT INTO hwo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na niifa sǝ thlǝmnggǝn ni Nikodimus, tǝ Farisarha ni, mamnda ni ahu Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɓagha thlǝmad Yeeso ɓa a fiɗikrha ndanggǝn, “Mala, sǝnɗansǝ sa tǝmalǝmnda ni thlǝnna Faara ɓa. Mbǝ niifa sǝ na mbang ǝna ǝnwulteena ƙǝla yanɗi na a ǝnaarha ya wa a mbǝ nana Faara tǝghǝn ha wa.” ");
INSERT INTO hwo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nggǝrangga Yeeso sǝ, “Niya puro ƙǝkafek, mbǝ niifa sǝ na kyarha hu kutǝryid Faara ɗǝ wa ƙǝl nggǝr nanda nggǝɗang hai.” ");
INSERT INTO hwo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsahangga Nikodimus mee, “Ƙǝƙǝn na nda nggǝr nggǝɗang nda niifa hai ndǝghǝn suhur ɗǝ? Ƙǝkafek mbǝ nggǝr kyarha ahu shiwad man hai nggǝrghǝn nggǝɗang hai yi sǝri wa!” ");
INSERT INTO hwo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nggǝrangga Yeeso sǝ tǝ ndaarha, “Niya puro ƙǝkafek, mbǝ niifa sǝ na kyarha ahu kutǝryid Faara ɗǝ kanda kula nggǝɗang hai hu aama tǝ Sǝsǝna wa. ");
INSERT INTO hwo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Thlufarha nǝn nggǝt thlufarha, amma Sǝsǝna, nǝn nggǝt Sǝsǝna. ");
INSERT INTO hwo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A wulo teena ka ndoni, ‘A nggǝrgha nda nggǝɗo hai wa.’ ");
INSERT INTO hwo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na ɓereurha piirha a mbǝɗa ɗǝ na midghǝn. Ƙǝla na sǝk pidghǝn ɗǝ, amma mba mbang pǝr mbǝɗi ɓa nǝn sa ɓa tǝ mbǝɗi nǝn a ɗǝrha saɗǝ wa. Nǝghǝn kee ƙǝm mba mbang pǝr kwamanɗi na nda nggǝɗang niifa hai hu Sǝsǝna wa.” ");
INSERT INTO hwo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsahangga Nikodimus mee, “Na ǝnɗi ǝnaarha hai ƙǝƙǝn ya?” ");
INSERT INTO hwo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ndangga Yeeso, “Sa tǝmalǝmnda Isǝrelaya ni, amma sǝnangwa ǝnggina hai ya wa? ");
INSERT INTO hwo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Niya puro ƙǝkafek, nan a thlǝk ˈya sǝn nan, nan sakh ˈya ƙǝm na nan, amma pa ya karɗun thlǝ ǝnɗa fa pǝrang nan kun. ");
INSERT INTO hwo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A puro ɗi ǝngya na ahu ƙǝshiirha, amma fǝr wa ƙǝkafek wa. Ƙǝƙǝn na fǝrƙǝkafek a puro ɗi laɓar ǝngya na talara? ");
INSERT INTO hwo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mbǝ niifa sǝ ˈwagha ɗǝrha talara ɗǝ wa, amma ƙǝl niifɗi ɓagha hai a talara, ndǝna Wan Niifa. ");
INSERT INTO hwo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ƙǝla ˈwana Musa tǝrang nda ɗǝɓǝl hulthne sǝ a kaheerha, na nda a tǝrang nda Wan niifa sǝ kee ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nanǝn kee, kala niifa fǝrgha ƙǝkafek a Wan Niifɗi nǝn a wal yibrha mbuwa wa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ƙǝsǝr Faara nggǝmɗǝ ƙǝshiirha kaan fǝr nǝn Wanggǝn katenggǝn, kala niifa fǝrgha ƙǝkafek a ndǝghǝn mbǝ tam mǝra wa, amma nǝn a wal yibrha mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Thlǝngga Faara Wanggǝn hu ƙǝshiirha ɓa mbǝ a ngwang kumarha nǝn wa, amma a walgha ƙǝshiirha hǝrǝkrha a fadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kala niifa fǝrgha ƙǝkafek a Wan Faara mba nda ngwang kumarha sǝ wa, amma kala niifa fǝrwa wa ƙǝkafek ˈwa ɗǝ teena ngwang ɗǝ kumarha sǝ, ƙǝsǝr fǝr wa ƙǝkafek a Wan Faara katenggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na Faara a ngwan kumarha fiya sǝ ƙǝsǝr kukwaryirha kyaɗǝ hu ƙǝshiirha ɓa, amma fiya nggǝmnda wula kaan ma kukwaryirha, ƙǝsǝr ǝn ǝnad ndan yi mbǝlfeerha ni. ");
INSERT INTO hwo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kala niifa na a ǝna tar mbǝlfeerha karnǝn kukwaryidɗi, mbǝ ɓaarha ahu kukwaryidɗa ɓa wa ka hǝreenga naɗǝ tar mbǝlfedghǝn kyaarha pǝpal ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amma kala niifa na tǝ ƙǝkafek fa, ɓa nǝn ahu kukwaryidɗa ɓa, tǝna fiya naghǝn a pǝpal tǝ ndaarha ˈya nǝn a ǝnaarha nǝghǝn a ǝna ˈya na mid Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A kwasamad palthɗiya, thliigha Yeeso tǝ fatsahayighǝn ɗǝnda chehweed Yahudiya ɗǝ tsǝnda tsǝɓaku a mbǝɗi nagha a ǝnang mbaptisǝma fiya. ");
INSERT INTO hwo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahaya ƙǝm a ǝna mbaptisǝma a aam Ainon tsau tǝ Salim fa ƙǝsǝr na aama sǝ kaan a mbǝɗi, na fiya naarha ɓarha ɓa ka ǝnang mbaptisǝma nda kanda. ");
INSERT INTO hwo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Katǝragha ǝnɗa hai ya kapa na nda mughang nda Yahaya ahu porsǝna ɗǝ.) ");
INSERT INTO hwo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Thliigha ngaala sǝ a pathlang fatsahaya Yahaya tǝ niif Yahudiya a ten chilɓi farha. ");
INSERT INTO hwo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nanǝn kee ɓagha fatsahaya Yahaya thlǝmadghǝn ɓa ndangganda, “Mala, ɗalna niifɗi teena ˈwana tsaurha tǝghǝn a pǝm kufad Urdun, thlǝkna pathla a tenggǝn, nǝghǝn a ǝna mbaptisǝma fiya hangga a ɗǝrha thlǝmadghǝn ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nggǝrangga Yahaya kanda sǝ, “Mbǝ niifa sǝ na wal ˈya wa ƙǝl fǝrang na Faara ndǝn hai na a talara. ");
INSERT INTO hwo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kun tafad nun sǝkɗun ǝnɗi thlǝghang ni kun a pǝpal, ‘Mbǝ nggini Ƙǝrǝsti wa, ˈwa ni mbee ɓa ka a kalang mee ni fiya kapa nǝn ɓarha ɓa.’ ");
INSERT INTO hwo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A far wutsǝfayid kakhrha, wuronga yi wutsamnda ni. Pashirha ɗǝgha hu kahad wutsamnda ɗǝ, nǝn ƙǝlaghǝn ha, kang thlǝmaarha nǝn fa, nǝn tǝk mbǝnda fa a sǝkɗǝ urad wutsamnda. Wutsǝfayidɗi a weeriya yina ni, nanǝnya lǝghǝdɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tǝta ni nagha aten chikrha kaan, nggi ƙǝm ne a tsǝrha ngguchit.” ");
INSERT INTO hwo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yanɗi ɓagha hai a talara kalɗǝ kowunni mu, yanɗi kyagha ɓa ahu ƙǝshiirha ƙǝm yi ƙǝshiirha ni, tǝ ƙǝm nǝn thlǝk ǝngya na hu ƙǝshiirha kee. Amma yanɗi ɓagha hai a talara kalɗǝ kowunni. ");
INSERT INTO hwo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nǝn naarha thlǝk ˈya nanǝn tǝ sǝknǝn ƙǝm, amma mbǝ niifa sǝ thlǝgha laɓarghǝn fa wa. ");
INSERT INTO hwo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kala niifa thlǝgha laɓarghǝn fa, sǝnɗasǝ na Faara tǝ ƙǝkafek fa. ");
INSERT INTO hwo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ƙǝsǝr yanɗi thlǝnna Faara ɓa laɓar Faara ndǝn nǝn a thlǝkrha, ƙǝsǝr fǝrang Faara Sǝsǝna mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na Chinɗi nggǝm Wanggǝn tǝ ƙǝm fǝrang ɗǝ ǝngya heu ahu haarghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kala niifa fǝrgha ƙǝkafek a Wanɗi nǝn wal yibrha mbuwa wa ngwalaarha, amma kala niifa fǝrwa wa ƙǝkafek a Wanɗi mbǝ tam wal yibrha wa, ƙǝl sǝbrha hur Faara ndǝna naarha a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nanǝnya sǝn Yeeso sǝ Farisaya sǝk nda laɓara atenggǝn nǝghǝn a ǝna mbaptisma a wal fatsahaya ma Yahaya, ");
INSERT INTO hwo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ko nanǝn, mbǝ Yeeso ni na a ǝna mbaptisǝma wa, amma fatsahayighǝn ni.) ");
INSERT INTO hwo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Walang na Yeeso ˈya na Farisaya a thlǝkrha atenggǝn, thliigha mal Yahudiya nǝn wudgha a Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tsawang ɗa fa tǝta a kyagha tǝ Samariya. ");
INSERT INTO hwo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ɓagha ahu tala ɓa na nda aarha Sikar na a chehweed Samariya, tsau tǝ pǝpal ɗa fa fǝrang na Yakubu wanggǝn Yisufu ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A hu talɗi na Kwat aam Yakubu sǝ, tǝkna widɗi Yeeso tsauka hai a thlǝmad kwat aamɗi. Yanfaara a sǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɓagha nu tǝ Samariyarha ka tsǝ aama ɓa, ndangga Yeeso, “Ənee aama ha see.” ");
INSERT INTO hwo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ahu sayidɗi Yeeso nǝghǝn katenggǝn ƙǝsǝr fatsahayighǝn kyanda hur tala hai ka ɗanda hii ǝnnarhami.) ");
INSERT INTO hwo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ƙǝsgha ǝnwulteena nuɗi ndanggǝn, “Sa tǝ Yahudarha ni, nggi nu tǝ Samariyarha. Kama nda na tsahe aam saarha?” (Ƙǝsǝr Yahudaya na nda tsan Samariyaya.) ");
INSERT INTO hwo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nggǝrangga Yeeso sǝ, “A ndam kwang sǝnna fǝrra Faara a sa, tǝ ƙǝm tǝ wunni tsahowa aam saarha, kam ndangna a ǝnoghǝn ha, kam nǝn a fǝro aam fǝr yibrha.” ");
INSERT INTO hwo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ndangga nuɗi, “Paɓa, mbǝ ǝn tsǝ aama sǝ a harwa wa kwat aamɗi ƙǝm ya nǝghǝn kuɗimnggǝn. Na wal aam fǝr yiɓǝdɗi a yanggi? ");
INSERT INTO hwo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kalna chinan Yakubu rangga kwat aamɗi kansǝ ya, saagha, ndǝghǝn tǝ wanggighǝn, heu tǝ chiɓǝd maɓiyighǝn wa?” ");
INSERT INTO hwo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nggǝrangga Yeeso sǝ, “Kala niifa saagha amɗiya na hushimnda nggǝr ƙǝsghǝn, ");
INSERT INTO hwo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amma yi saagha aamɗi niya fǝrang nda mbǝ hushimnda nggǝr ƙǝsghǝn wa. Aamɗi niya fǝrang nda nǝn a tsawang fa mbǝd ngǝtta aama na fǝrang yibrha pa kwanɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ndangga nuɗi Yeeso, “Paɓa, fǝree tur aamɗi ya lee amawana hushimnda nggǝr ƙǝs nggi tǝni malang ɓarha ka tsǝ aama mbǝɗa ɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ndangga Yeeso, “Ɗuwa ɗǝ, ɗa aah chimad wa ɓon ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nggǝrangga nuɗa sǝ, “Mbǝ chimad na sǝ wa.” Ndangga Yeeso, “Thlǝkna ƙǝkafek ndana mbǝ chimadwa sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pǝrna ƙǝkafek, chimaya tuf ˈwagha kahorha, niifɗi nana tǝghǝn nanǝnya mbǝ chimadwa ni wa.” ");
INSERT INTO hwo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ndagha nuɗi, “Paɓa, mbǝ ngaala sǝ wa Annabi ni sa. ");
INSERT INTO hwo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nanǝn kee pǝreeƙǝn, chichiyi nan tǝrang nda shilee Faara teena a wumndǝɗi ya, amma kun Yahudaya nduwun mbǝrha kamngga a tǝrang shilee nǝm Faara teena a Urshalima ni.” ");
INSERT INTO hwo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nggǝrangga Yeeso sǝ, “Sa nuɗiya, furu ƙǝkafek tǝ palthɗi niya thlǝworha ya, na sayi ɓayi mbuwa na fiya tǝrang shilee Pǝpa in a wumndǝɗi ya nduwa a Urshalima. ");
INSERT INTO hwo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kun Samariyaya nuwun a tǝrang shilee ˈya teena sǝngwa wa nun, kan nan tǝrang shilee ˈya teena sǝn nan, ƙǝsǝr na hǝrǝkrha a kyarha ɓa a fad Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amma na sayi ɓayi, ˈwaɗǝ teena ɓaɗa ɓa, fiya na tǝrang shilee Pǝpa teena hu ƙǝkafek na nda a tǝrang shilee teena hu Sǝsǝna tǝ ƙǝkafek, ƙǝsǝr tur nafina ni na Pǝpa a kaɗaarha ya. ");
INSERT INTO hwo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Faara sǝsǝna ni, nafiya na a tǝrang shilee teena ƙǝl a ǝnaghǝnda hu sǝsǝna tǝ ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ndangga nuɗi, “Sǝnɗisǝ Ƙǝrǝsti na nda aarha Ƙǝrǝsti nǝghǝn ɓayi. A ɓaɗa ɓa, ɓanǝn pǝrang ǝngya kan heu.” ");
INSERT INTO hwo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tǝrgha ndangga Yeeso, “Nggini Ndǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A sayidɗi na nanda a ngwalang pathla kee, tǝrgha ɓagha fatsahayighǝn ɓa ƙǝsgha ǝnwulteena kanda na nandan a ndikrha tǝ nuneefa. Amma mbǝ niifa sǝ tsakhka mee, “Mana midwa wa?” Nduwa “Kama na a ndikrha tǝ nuɗiya wa?” ");
INSERT INTO hwo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tǝrgha malangga nuɗi ɓǝd tsǝ aamnggǝn a mii kwat aamɗi ɗǝgha hur tala ɗǝ ndanggǝn fiya, ");
INSERT INTO hwo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ɓamaɓa ɓun na niifa pǝreegha ǝngya heu ˈwani ǝnaarha! Tǝ ndǝghǝn ɗani na Ƙǝrǝsti?” ");
INSERT INTO hwo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nanǝn kee, kyagha fiya ɓa ahur talɗi ɓa nda thlǝmad Yeeso ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na inggini a katǝrarha hai ya, hwan nggǝna fatsahayighǝn, “Mala, ǝno ˈya mii.” ");
INSERT INTO hwo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amma ndanggǝn kanda, “Na ǝnnarhami sǝ a haar na sǝngwa nun.” ");
INSERT INTO hwo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tǝrgha ndangga fatsahayighǝn ndan, “Na niifa sǝ ɓangga ǝnnarhami ɓa wa?” ");
INSERT INTO hwo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ndagha Yeeso, “Ən nanna mii, a ǝna ǝnɗa ni ndeena niifɗi thlǝngga nggi ɓa tǝ ƙǝm ngwalanggi targhǝn. ");
INSERT INTO hwo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mbǝ nduwun, ‘Takh ndǝree faɗa a katǝrang ngganda haathla hai wa’? Niya ndang nda kun, inaman yid nun ɗǝ ƙǝlanggun heeya ɗǝ ngga! Tsǝk nda haathla. ");
INSERT INTO hwo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ko nanǝnya tǝ haathla nǝn a wal ƙǝnaghǝn, nanǝnya ma hathlang ɗǝ ǝnnarhami hai yi yibrha mbuwa ngwalaarha, tǝna tǝ hǝfrha tǝ tǝhaathla ǝna wutsǝfayirha kyab. ");
INSERT INTO hwo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Karapu ɗi ya ƙǝkafek ni, ‘Niifa a hǝfrha, niifa pak a hathla.’ ");
INSERT INTO hwo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Thlǝnni kun ka halth heerha ɗǝ hǝfwa wa nun. Nafiya pak ǝnagha tarɗi, amma kun ƙǝm tǝk ɗun mbǝnda tarɗa fa ǝna nanda.” ");
INSERT INTO hwo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariyaya hangga kyagha ɓa hu talɗi fǝrgha ƙǝkafek tǝ Yeeso ƙǝsǝr ka palthɗi kii nuɗi ndanǝn, “Pǝree ɗǝ ǝngya ˈwani ǝnaarha heu.” ");
INSERT INTO hwo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɓana Samariya yini thlǝmadghǝn ɓa, hwanggǝnda a tsauka tǝ kanda, ǝna ɓeena nǝn sǝri. ");
INSERT INTO hwo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ƙǝsǝr ka laɓarghǝn sǝkna fiya, nggǝrgha fingya hangga fǝrƙǝkafek tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndangga Samariya yini nuɗi, “Fǝr nan ƙǝkafek mbǝ ka palthwa kee wa, amma ƙǝsǝr kan ma sǝk ɗan ndǝn tafan nan, ƙǝkafek sǝnɗansǝ niifɗiya ndǝghǝn ni tǝhǝrghang nda ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","A kwasamadɗi ǝna nǝn ɓeena sǝri ɗǝgha mbeeɗǝ tǝ wiirha a Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeeso tafadghǝn ˈwaɗǝ ndaarha mbǝ annabi wal mamnggirha ahu chehweedghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ko nanǝn kee, sǝl nǝn Nggalili ɗǝ, thlǝgha Nggalila yini ndǝn fa, ƙǝsǝr nanda ǝngya heu ǝnanǝn a Urshalima hu wutsǝfayid Tǝɗaarha ɗǝna nda saɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nggǝrghǝn ɗǝrha tal Kaana ɗǝ na a chehweed Nggalili, a mbǝɗi kyakhrang nǝn aama tsauka aam inabi. A mbǝɗi na mamnda sǝ na fad wanggǝn ɓee a Kafarnahum. ");
INSERT INTO hwo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sǝkna niifɗi mal Yeeso Yahudiya sǝl ɗǝ Nggalili ɓa, ɗǝgha thlǝmadghǝn ɗǝ hwanggǝnǝn ɓagha ƙǝnang wanggǝn na tsau tǝ mii mǝrra fa a Kafarnahum. ");
INSERT INTO hwo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ndangga Yeeso, “Kun nafiya a nawun ǝnwuteengya tǝ ǝnsakhkya wa, mbun tam fǝrƙǝkafek wa.” ");
INSERT INTO hwo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ndagha mamndǝɗi, “Paɓa, ta wim kapa na waana mǝra.” ");
INSERT INTO hwo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nggǝrangga Yeeso sǝ, “Na mbang wiirha. Na wan wa a ƙǝnda.” Niifɗi fǝrƙǝkafek nǝn tǝ palth Yeeso wiigha wureeɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndǝghǝn ɓalɗǝ hu kwamana, ɓa mafayighǝn walghǝn ndangganda, “Wan wa ƙǝnɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsahang mee nun kanda sayidɗi ƙǝn nǝn. Ndangganda, “Kalgha wanhadɗa ndǝn hai a ɓǝrarha yanfaara a sǝrǝkrha.” ");
INSERT INTO hwo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tǝrgha chin wanɗi ƙǝlagha hai na sayidɗi mǝmǝl ndangna Yeeso, “Na wan wa a ƙǝnda.” Tǝrgha ndǝghǝn heu tǝ fa wurayighǝn fǝrƙǝkafek nda. ");
INSERT INTO hwo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ndǝn na ǝnwulteena yi sǝri kyadna Yeeso mal nǝn Yahudiya ɗǝnǝn Nggalili ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","A kwasamadghǝn, ɗǝgha Yeeso Urshalima ɗǝ ƙǝsǝr ka far wutsǝfayid ǝntin Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A Urshalima tsau tǝ kwatkirǝm chaukhraya fa na wutambarra aama sǝ na Ibraniyaya aarha Mbetasda kang nanda tǝ mǝthlǝmngya tuf. ");
INSERT INTO hwo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A ka mǝthlǝm nggini ya fingya mbuwa ƙǝkanglang, kwamaya, tǝ sǝfǝngya tǝ fingya mǝrna fandan hai ndǝna nda hunaarha sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Na nafini naarha ƙǝla far ɗa fa na nda a rǝɓang nda aamɗi. Ƙǝsǝr sayi sayi na tǝthlǝnda Faara ɓarha ɓa rǝbanggǝn aamɗi. Kala niifa ˈwagha ahu aamɗa hai nǝn wal ƙǝnda ahu kala tur yanggi wanharha.) ");
INSERT INTO hwo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A mbǝɗi na niifa sǝ na tǝ wanhaarha fa hurarha kumnggit mahan kap wuvaɗa. ");
INSERT INTO hwo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nana Yeeso ndǝn kalth sǝnang ɗa hai mǝnɗaha tǝ wanhadɗi tsahang mee nǝn, “Na midwa sǝ a ƙǝna na wa?” ");
INSERT INTO hwo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndangga hadɗi, “Paɓa, mbǝ niifa sǝ na a ɗeesǝ kee hu aamɗa hai a sayidɗi tsǝnǝn ˈya fa wa. A naɗi a kyarha sa hai, ˈwagha niifa ma nggi.” ");
INSERT INTO hwo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tǝrgha ndangga Yeeso, “Thliusǝ, tǝrang ɗǝnggǝl wa wiina!” ");
INSERT INTO hwo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tsu a mbǝɗi kee ƙǝngga niifɗi; tǝranggǝn ɗǝnggǝlghǝn wiigha. Katǝragha ǝnɗa hai ya a far yiɓǝd Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ndangga Yahudayini niifɗi ƙǝngga, “Far yibrha ni a weeriya, ˈYaɗa ngyahad nǝm taara a far yibrha tǝ ƙǝm mǝmǝlwa a tǝrangga ɗǝnggǝl hunad wa sǝ wa!” ");
INSERT INTO hwo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Amma nggǝrangga niifɗi kanda sǝ ndǝghǝn, “Niifɗi ƙǝneegha ndǝn ndeegha, a tǝranggi ɗǝnggǝl na wii.” ");
INSERT INTO hwo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsahang mee nda, “Wunni niifɗi ndowa a tǝrangga ɗǝnggǝlwa wiina?” ");
INSERT INTO hwo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Niifɗi ƙǝnang nanda sǝngwa niifɗi ƙǝnangga wa, ƙǝsǝr Yeeso timɗǝ ahur fiyaɗǝ na a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A kwasamadghǝn ɗa Yeeso naghǝn ahu Ƙǝn Faara ndanggǝn, “Ƙǝnna nanǝnya, a nggǝrna ǝna ɗimiyirha wa a mbǝ kee wa na ˈya a wal sa kalgha yanɗa mu ya.” ");
INSERT INTO hwo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wiigha niifɗi kaɗa Yahudayina nǝn ndanggǝn kanda Yeeso ni ƙǝnangga. ");
INSERT INTO hwo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nanǝn kee, ƙǝsǝr ka ǝnggini na Yeeso a ǝnaarha a far Yibrha, katǝrangga Yahudayini mbǝlfeeghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ndangga Yeeso kanda, “Ƙǝtsar na Pǝpa narha ǝna taara, nggima niyi kee.” ");
INSERT INTO hwo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nanǝn kee, ƙǝsǝr ka tur palth yini thlǝk nǝn, tǝrgha Yahudayini ɗǝnda mbeeɗǝ tǝ kaɗa kwamana na a ɓǝlangganda. Mbǝ ka tǝɗang nǝn ngyakhrha far yiɓǝd Yahudaya teena wa, amma ka nda nǝn chin ni Faara, tǝ ƙǝm tsawanggǝn fadghǝn mǝmǝl tǝ Faara. ");
INSERT INTO hwo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tǝrgha pǝrang nggǝna Yeeso kanda ndǝghǝn, “Ƙǝkafek niya ndang nda kun, mbǝ ˈyasǝ na wanɗi ǝnaarha tǝ altenggǝn wa; nǝn ǝna ˈya nanǝn na Chin ǝnaarha, ƙǝsǝr kala ˈya na Chinɗi ǝnaarha wanɗi ƙǝm nǝn ǝnaarha kee. ");
INSERT INTO hwo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ƙǝsǝr Chinɗi nǝghǝn a nggǝm Wanɗi, nǝn kyaɗang ǝngya heu ǝnanǝn. Na chinɗi ƙǝm nggǝr kyaɗang ǝngya na mǝmanggǝn kalgha yanɗiya, tǝnun na ǝnwulteena. ");
INSERT INTO hwo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ƙǝsǝr ƙǝla na Chinɗi thleng nda mǝrya sǝ fǝrang yibrha nǝn kanda, na wanɗi ƙǝm fǝr yibrha a niifa nggǝmna hurghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ƙǝmɗaarha, mbǝ Chinɗi ngwang kumarha niifa wa, amma fǝrang ɗǝ sǝsǝmnda ngwa kumarha Wanggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tǝna kowunni fǝrang mamnggirha wanɗi, ƙǝla na nda fǝrang mamnggirha Chinɗi. Amma kala niifa kargha fǝrang mamnggirha wanɗa fa, kar nǝn fǝrang mamnggirha chinɗi thlǝngga ndǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Niya pǝrang ƙǝkafek kun, kala niifa sǝkka palth na fǝrƙǝkafek nǝn a Faara thlǝngga nggi ɓa nǝn wal yibrha mbuwa ngwalaarha. Mbǝ ngwa kumarha sǝ a tendan wa, ƙǝsǝr ˈwanda teena tǝɗang nda mǝrra in ahu yibrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niya pǝrang ƙǝkafek kun, na farghǝn ɓaghai, nanǝnya ma ˈwaɗǝ teena ɓaɗa ɓa. Na mǝrra a sǝk urad Wan Faara. Fingya sǝkka ndǝn na nda a wal yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ƙǝla nana Chinɗi tafadghǝn ndǝghǝnni tǝ kwaman yibrha ha, nanǝn kee ƙǝm fǝrang ɗǝ sǝsǝmnda Wanggǝn nagha tǝ kwaman yibrha ha. ");
INSERT INTO hwo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tǝ ƙǝm fǝrang ɗǝ sǝsǝmnda na a ngwa kumarha nǝn ƙǝsǝr ndǝghǝnni Wan Niifa. ");
INSERT INTO hwo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“A ƙǝs ǝnwulteena kun a ten ǝnɗiya wa, ƙǝsǝr na sayi ɓaghai mǝrya na ahu ten kwaya na nda a sǝk urad Wan Niifa. ");
INSERT INTO hwo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kya nda sǝ, fingya ǝnagha ngga na nda a thliirha sǝ ahu yibrha ɗǝ mbuwa ngwalarha, fa mbǝlfeeya ƙǝm na nda a thliirha sǝ ngwang kumarha nda kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mbi mbang ǝna ˈya katenna wa; niya ngwa kumarha ƙǝla thlǝye Faara. Ngwa kumanna yi ƙǝkafek ni, ƙǝsǝr nǝghǝn a ten nggǝmnda hur Faara thlǝngga nggi ɓa, amma mbǝ yi altenna ni wa. ");
INSERT INTO hwo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“A naɗi a fer shedawa a tenna, ˈya niya thlǝkrha mbǝ tsaurha yi ƙǝkafek wa. ");
INSERT INTO hwo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amma ana niifa sǝ ƙǝm fǝrgha shedawa a tenna, sǝnɗisǝ palth ɗi nǝn a thlǝkrha a tenna ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Thlǝn ɗun fiya a thlǝmad Yahaya ɗǝ, ndǝghǝnggi ƙǝm pǝrangɗǝ ƙǝkafek kun. ");
INSERT INTO hwo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ko nanǝn kee mbǝrsa wii tǝ shedawa niifa a tenna wa, thlǝkni ndǝn kee tǝnun wal hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya nǝghǝn ƙǝla patilla na a ƙǝsa fǝr kukwaryirha nǝn, tǝ ƙǝm tǝk ɗun mbǝnda laɓarghǝn fa ahu sayi ngguchit. ");
INSERT INTO hwo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Amma shedawa a tenna kalɗǝ yi Yahaya. Ƙǝsǝr tarɗi fǝrena Pǝpa a ngwalanggi, ndǝghǝnni nani a ǝnaarha ya, ndǝn kyadgha ndaarha Pǝpa ndǝn thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tǝ ƙǝm Pǝpa thlǝngga nggi ɓa, ndǝghǝnni tafadghǝn na a fǝr shedawa atenna. ˈWawun sǝk uradghǝn wa nduwa nawunun tǝ yirha wa, ");
INSERT INTO hwo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tǝ ƙǝm laɓarghǝn tsaukwa ahur nun wa, ƙǝsǝr fǝr wun ƙǝkafek a niifɗi thlǝn nǝn ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nun naarha karata Ɗeleewar Faara, ƙǝsǝr nuwun a numad ndaarha ahurghǝn nǝn a fǝrang yibrha kun mbuwa ngwarha. Ɗeleewar yina ni na a fǝr shedawa a tenna a kun. ");
INSERT INTO hwo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ko nanǝn kee, karɗun fa a ɓon thlǝmanna ɓa tǝnun wal yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mbi thlǝ faala a fad nafiya wa, ");
INSERT INTO hwo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ƙǝsǝr sǝnɗi kun. Sǝnɗi sǝ mbǝ nggǝmnda Faara sǝ ahur nun wa. ");
INSERT INTO hwo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɓayi ɓa ahu thlǝm Pǝpa, kar ngya nun fa; amma a ɓad niifa ɓa pak ahu thlǝm altenggǝn, nun a thlǝghǝn fa. ");
INSERT INTO hwo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ƙǝƙǝn nun fǝrƙǝkafek a naɗun a thlǝ faala a ten kun ndan, amma mbuwun a kaɗa thlǝ faala na a kyaarha ɓa a thlǝmad Faara katenggǝn wa? ");
INSERT INTO hwo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“A numaɗun niya huhwa kun a mbed Pǝpa wa. Niifa na a huhwa kun ndǝna Musa, kyanun kya shang teena fa. ");
INSERT INTO hwo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Andam fǝrɗun ƙǝkafek a Musa, kam fǝrɗun ƙǝkafek a nggi, ƙǝsǝr chireelth ɗǝ ˈya a tenna. ");
INSERT INTO hwo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amma fǝr wun ƙǝkafek aten ˈya chireelth nǝn wa, ƙǝƙǝn nun fǝrƙǝkafek a ten ˈya thlǝkni?” ");
INSERT INTO hwo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A kwasamadghǝn, tǝɗangga Yeeso wuri aam Nggalili teena na nda aarha wuri aam Tibariyas. ");
INSERT INTO hwo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Fiya hangga mbuwa samadghǝn ƙǝsǝr nanda ǝnwulteengya ƙǝnang nǝn fingya mbuwa wa ƙǝkanglang. ");
INSERT INTO hwo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tǝrgha Yeeso wumnda sǝ tsauka hai tǝ fatsahayighǝn a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wutsǝfayid Yahudaya yi tǝɗaarha nduwusɗa ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ƙǝlana Yeeso ɗǝ na fiya nǝn hangga a ɓarha thlǝmadghǝn ɓa, tsahang mee nǝn Filibus, “A yanggi nǝm hii mburodi ɓa nǝm fǝrang nda nafiniya kii nda?” ");
INSERT INTO hwo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tsahangna Yeeso mee Filibus kee ka a ƙǝƙǝranggǝn, ƙǝsǝr ˈwaɗǝ teena sǝnɗǝ ˈya nǝn a ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nggǝrangga Filibus sǝ, “Ai ko wuɗǝɓǝl rapathlaarha yi ɓeena haru sǝri mbǝ heng mburodi ɓa na a walgha kowunni ngguchit ǝnagha mii wa!” ");
INSERT INTO hwo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tǝrgha tal ahur fatsahayighǝn na thlǝmnggǝn Andrawus, wanman Siman Mbiturus ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kulo wundakhnee ya tǝ mburodi tuf ǝnana nda tǝ humbad wan hwaliirha na nda aarha mbale, tǝ tǝna nggun-ngguchit sǝri, amma ma nǝn ǝnang nda fiya hangga kiya?” ");
INSERT INTO hwo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ndangga Yeeso fatsahayighǝn, “Ndaman fiya tsawa nda hai.” Na hwaliiya sǝ a mbǝɗi tsawa nda sa hai, hǝshya ǝnanda haru kumnggit tuf. ");
INSERT INTO hwo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tǝrgha harangga Yeeso mburodi yina sǝ usa Faara nǝn, ndǝghang nggǝnda fiya ɗǝ tsauka hai. Ənagha kee ƙǝm tǝ tǝnɗi. Kowunni ǝnagha mii ƙǝla na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A kwasamadɗi ǝnana fiya mii nggal nda, ndangga Yeeso fatsahayighǝn, “Wuma man katǝbghǝn ɓa a sǝb ˈya ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nanǝn kee wumangga fatsahayighǝn katǝbɗa ɓa lǝɗanggǝn kutasya kumkap sǝri, wato kukutethla mburodi ɗi tuf ǝnana nda tǝ humbarha kiina fiya. ");
INSERT INTO hwo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A kwasamadɗi nana fiya ǝnwulten ɗi ǝnana Yeeso, katǝrang ngganda ndaarha hai, “Ƙǝkafek Annabi ɗani ya na a ɓaarha hu ƙǝshiirha ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ƙǝlana Yeeso hai na mindan sǝ tǝta a faɗang ngganda kutǝra, ngǝrgha hai nggǝrghǝn tǝra wumnda sǝ katenggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tsǝna figrha hai, ɗǝgha fatsahayighǝn a mii wuri aamɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kya nda ahu kombuwol hai katǝrang ngganda tǝɗang aamɗi teena ka a ɗǝnda Kafarnahum ɗǝ. Wula a tsǝrha hai Yeeso kula wutta ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tǝrgha thliigha ɓereurha ɓa nagha tsang ˈya aamɗa fa. ");
INSERT INTO hwo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hur nanda kombuwol ɗaɗǝ mel mahan nduwa faɗa, ƙǝla nda hai Yeeso a wiirha a ten aama, ɓayi thlǝmad kombuwol ɗa ɓa, tǝrma nda. ");
INSERT INTO hwo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amma ndanggǝn kanda, “Nggini; a tǝrǝmɗun wa.” ");
INSERT INTO hwo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tǝrgha Fatsahayini na mindan sǝ a kyangganda ahu kombuwol ɗa hai, amma ƙǝla nda hai tsu kee sǝl nda a mbǝɗaɗǝ na mindan ɗǝrha saaɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɗalthna mbǝrha hai fingya fiya wumngga hai a pǝm wuri aamɗi ƙǝla nda hai kwambuwol tal ɓagha mbǝɗa ɓa kee, Yeeso ƙǝm kyawa ahur kombuwol ɗa hai tǝ fatsahayighǝn wa, amma wiigha fatsahayighǝn katen ndan. ");
INSERT INTO hwo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kombuwolya hangga ɓagha ɓa a Timbariyas, isha nda hai tsau tǝ mbǝɗi kiina fiya mburodi ɗa sǝ a kwasamadɗi usana Chinǝm Faara. ");
INSERT INTO hwo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ƙǝlana fiya ɗǝ wumngga hai nawa nda Yeeso wa, nduwa fatsahayighǝn a mbǝɗi wa, kya nda hu kombuwolyina hai, ɗǝnda Kafarnahum ɗǝ ka a kaɗa Yeeso nda. ");
INSERT INTO hwo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɗǝna fiya walghǝn a pǝm wuri aamɗi, tsahang mee nda, “Mala, a kwan ɓana mbǝɗa ɓa ya?” ");
INSERT INTO hwo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nggǝrangga Yeeso kanda sǝ, “Niya pǝrang ƙǝkafek kun, nuwun a kaɗa nggi, mbǝ ka sǝnang nun ǝnwulteengya hai wa, amma ka kii nun mburodi ɗi nggal ɗun. ");
INSERT INTO hwo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A ǝnaɗun taara ka ǝnnarhami na a sǝbrha ɗǝ wa, amma ǝnama taara yi ǝnnarhami na fǝr yibrha mbuwa ngwalaarha, na Wan Niifa a fǝrang kun. Ƙǝsǝr Faara, na Chinɗi ndǝn fǝrangga kwaman fǝr yibrha.” ");
INSERT INTO hwo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tǝrgha tsahang mee nda, “Ma nan ǝnaarha na a tǝranggan hur Faara sǝ?” ");
INSERT INTO hwo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nggǝrangga Yeeso kanda sǝ, “ˈYa tǝtal ni kee na mid Faara a ǝnon, fǝrama ƙǝkafek a niifɗi thlǝn nǝn ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ndangganda, “Kyaɗang ǝnwulteena kan ana midwa sǝ fǝro ƙǝkafek nan. Mana a ǝnaarha? ");
INSERT INTO hwo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chichiyi nan kin nda manna a kaheerha, ƙǝla nanǝn chichirethlee hai: ‘Fǝrang ɗǝ mburodi kanda a talara hai a ǝna nda mii.’ ” ");
INSERT INTO hwo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, mbǝ Musa ni fǝrangga mburodi ɗi kun na a talara hai wa, amma na Pǝpa naarha fǝrang ka mburodi kun hai a talara. ");
INSERT INTO hwo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ka mburodi yi Faara ndǝghǝn ni ɓagha hai a talara, na fǝr yibrha a ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ndangganda, “Paɓa, no naarha fǝrang tur mburodi ɗi kan ya ƙǝtsar!” ");
INSERT INTO hwo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tǝrgha Yeeso nggǝranggǝn kanda sǝ, “Nggini mburodi yi fǝr yibrha. Kala niifa ɓagha thlǝmanna ɓa mbǝ miirha nggǝr ƙǝsghǝn wa, kala niifa fǝrgha ƙǝkafek tǝ nggi ɓalwa hushimnda ƙǝsghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amma ƙǝla pǝrang ni kun, naɗun nggi, ta weeri ɗaɓa ya ɓalwun kula fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kala nafiya fǝree na Pǝpa na nda ɓaarha thlǝmanna ɓa, nggi ƙǝm mbi tam kar kanda wa. ");
INSERT INTO hwo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ƙǝsǝr ɓayi hai a talara mbǝ ka ǝna tar altenna ni wa, amma ka ǝna tar ɗa ni na mid Faara thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ənɗani na mid niifɗi thlǝngga nggi ɓa ya, a sahad tal ahur nafini fǝree nǝn ɓa wa, amma a thlenggi kanda sǝ tǝ yibrha a far ngwala ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ƙǝsǝr ˈya na mid Pǝpa ndǝna kala niifa ƙǝlangga Wanɗa ɗǝ fǝrƙǝkafek nǝn tǝghǝn, nǝn a wal yibrha mbuwa ngwalaarha, tǝ ƙǝm ni a thleng sǝ a far ngwala ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tǝrgha Yahudayini katǝrangganda huhurumnda hai a tenggǝn ƙǝsǝr ndanǝn, “Nggini mburodi yi fǝr yibrha ɓagha hai a talara.” ");
INSERT INTO hwo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ndaa nda “Kamshiɗi ya mbǝ Yeeso ɗani na wan Yisufu, sǝn nǝm nda man tǝ chin ya wa? Ƙǝƙǝn nǝn ndaarha, ‘Ɓaghǝn hai a talara’?” ");
INSERT INTO hwo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nggǝrangga Yeeso kanda sǝ, “Malaman huhurumnda a pathlang nun. ");
INSERT INTO hwo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mbǝ niifa sǝ na ɓaarha thlǝmanna ɓa wa ƙǝl Pǝpa thlǝngga nggi puwangga thlǝmanna ɓa, nggi ƙǝm niya thleng sǝ a far ngwala ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nǝghǝn chichirethlee hai ahu ɗeleewarya Annabiya: ‘Kanda heu Faara ni a tsahang kanda ha.’ Kala niifa kangga thlǝmaarha Chinɗa fa, tǝ ƙǝm tsahagha a haarghǝn, nǝn ɓarha thlǝmanna ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mbǝ niifa sǝ nagha Chinɗi wa, ƙǝl niifɗi ɓagha hai a thlǝmad Faara, ndǝn nagha Chinɗi. ");
INSERT INTO hwo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Niya pǝrang ƙǝkafek kun, kala niifa fǝrgha ƙǝkafek nǝghǝn tǝ yibrha mbuwa ngwalaarha. ");
INSERT INTO hwo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nggini mburodi yi fǝr yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chichiyinun kin nda manna a kaheerha, amma mǝr nda heu. ");
INSERT INTO hwo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amma kulo mburodi yi fǝr yibrha ya ɓagha hai a talara, kala niifa kiigha mbǝ mǝra wa. ");
INSERT INTO hwo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nggini mburodi ɓagha hai a talara yi fǝr yibrha. A kii niifa mburodi ɗiya, nǝn a tsaurha pa kwanɗǝ. Mburodi ɗiya thlu fadna ni, niya fǝra tǝna ƙǝshiirha wal yibrha.” ");
INSERT INTO hwo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tǝrgha Yahudayini katǝrangganda ngaala hai a pathlang ndan aten ǝnɗi ndanǝn tsakh mee nda, “Ƙǝƙǝn na niifɗi fǝrang thlu fadghǝn ƙǝmya kim?” ");
INSERT INTO hwo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ndangga Yeeso kanda, “Niya pǝrang ƙǝkafek kun, a kiiwun thlu fad Wan niifa tǝ ƙǝm sa farghǝ nun wa, mbun wal yibrha mbuwa ngwalarha wa. ");
INSERT INTO hwo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kala niifa kiigha thlu fadna tǝ sa farna, nǝn tsaurha tǝ yibrha fa mbuwa ngwalaarha, niya thleng kanda sǝ a far ngwala ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ƙǝsǝr thlu fanna ka ǝnnarhami ni, farna ƙǝm ka ǝn saarha ni. ");
INSERT INTO hwo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kala niifa kiigha thlu fanna tǝ sa farna, nǝn naarha a hurna nggi ƙǝm ahurghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ƙǝla na Chinɗi tǝ yibrha thlǝngga nggi ɓa, ƙǝsǝr ka ndǝghǝnni nani tǝ yibrha, nǝghǝn kee ƙǝm, kala yanɗi na a hǝbrha a fanna, ƙǝsǝr ka nggi, nǝn wal yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yanɗiya ndǝna mburodi ɗi ɓagha hai a talara, kala niifa kiigha mburodi ɗi ya nǝn wal yibrha pakwanɗǝ. Mbǝ tur mburodi ɗani kiina chichiyi nun wa, ko nanǝn kee mǝr nda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Thlǝkka Yeeso ǝnggini ya heu ya ahu sayidɗi nanǝn a tsaharhaha ahu ƙǝn tsahad Yahudaya na a Kafarnahum. ");
INSERT INTO hwo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sǝkna fa tsahayighǝn ndǝn kee, ndanda, “Tsahadɗa ha ya nǝghǝn pǝɗaghǝn kaan. Wunni mbang kang thlǝmaarha fa?” ");
INSERT INTO hwo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sǝn Yeeso sǝ na fatsahayighǝn a huhurumnda, ndanggǝn kanda, “Tsahadɗa ha ya sǝɓang nǝn hur nun ɗǝ wa? ");
INSERT INTO hwo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma nun a numarha a naɗun Wan Niifa a tǝra a mbǝɗaɗǝ ɓanǝn sa ɓa? ");
INSERT INTO hwo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sǝsǝna katenggǝn ni kee na fǝr yibrha; mbǝ ˈyasǝ na thlu farha mbang ǝnaarha wa. Palthɗi thlǝghang ni kun Sǝsǝna ni tǝ ƙǝm yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amma ahur nun na fingya sǝ fǝrwa wa ƙǝkafek tǝ nggi.” (Ƙǝsǝr Yeeso sǝnɗǝ fingya fǝrwa ƙǝkafek tǝghǝn, tǝ ƙǝm sǝnɗǝ niifa na a fǝrghǝn ka a ɓǝlang ngganda.) ");
INSERT INTO hwo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɗǝgha mbeeɗǝ tǝ ndaarha, “Ndǝghǝn ɗani ndang ni kun mbǝ niifa sǝ na ɓaarha thlǝmanna ɓa wa, ƙǝl a fǝre Pǝpa kanda.” ");
INSERT INTO hwo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ƙǝsǝr ka palthɗi thlǝkna Yeeso ya, fa takkwayighǝn hangga malang ngganda mbu samadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tǝrgha tsahangga Yeeso mee kumkap sǝriɗi, “Kun ƙǝm na minnun sǝ wiirha wa?” ");
INSERT INTO hwo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nggǝrangga Siman Mbiturus sǝ, “Chinǝm, a ɗan thlǝma wun ɗǝ? Sa ni na tǝ laɓar yibrha ha mbuwa ngwalaarha. ");
INSERT INTO hwo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Fǝr ɗan ƙǝkafek tǝ ƙǝm sǝnɗansǝ sa ni tǝ Peɗǝnda yi Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tǝrgha Yeeso nggǝranggǝn sǝ, “Nggi ndǝn wurgha kun kumkap sǝri. Amma tal ahur nun Sheetan ni.” ");
INSERT INTO hwo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nǝghǝn a thlǝk laɓar Yahuda, wan Siman Iskaryoti, tal ahur kumkap sǝri ɗi, na a fǝrghǝn a ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A kwasamadghǝn, wiigha Yeeso hai ahur Nggalili, amma mbǝ midghǝn sǝ a ɗǝgha Yahudiya ɗǝ wa, ƙǝsǝr na mid Yahudaya sǝ a ɓǝlangganda. ");
INSERT INTO hwo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nanǝnya far wutsǝfayid Chamngya yi Yahudaya nduwusɗa ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tǝrgha wan mangya Yeeso ndang ngganda, “Malang mbǝɗiya ɗǝna Yahudiya ɗǝ tǝna fatsahayiwa na ǝnwuteengya na a ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mbǝ niifa ɓǝɓeng ˈya hai nǝn a ǝnaarha wa, ana midghǝn sǝ sǝngga fiya ndǝn wa. Nanǝn nagha a ǝna ǝngginiya, kyaɗang fadwa ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ƙǝsǝr ko wan manggighǝn ni fǝr wanda ƙǝkafek a ndǝghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsaunǝn kee ndangga Yeeso kanda, “Ɓawa yina sayi ɓa ˈwan wa. Kun kam kala sayi mǝmǝl ni a fad nun. ");
INSERT INTO hwo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mbǝ nafiya ƙǝshiirha kar kun wa, amma na nda a kar nggi fa, ƙǝsǝr ka ni naarha ndaarha na nda a ǝna tar mbǝlfeeya. ");
INSERT INTO hwo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kun ɗaama hu wutsǝfayidɗa ɗǝ. Mbiya ɗǝrha hu wutsǝfayidɗa ɗǝ wa, ƙǝsǝr ɓa wa sayid na ɓa ˈwan wa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Akwasamadɗi thlǝk nǝn palth ɗiya, tsauka a Nggalili. ");
INSERT INTO hwo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amma a kwasamadɗi wiina wan manggighǝn hu wutsǝfayidɗa ɗǝ, ɗǝgha Yeeso ɗǝ ƙǝm, mbǝ a pǝpal wa, amma ɓǝɓee. ");
INSERT INTO hwo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A hu wutsǝfayidɗi nagha Yahudayini a kaɗaghǝn, na nda a tsakhmee, “Na niifɗi a yanggi?” ");
INSERT INTO hwo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A hu terɗi nagha fiya a kikighǝn fa. Fingya a ndaarha, “Ka niifa ni.” Fingya ƙǝm a ndaarha, “Awo, nǝghǝn a nggaɓa fiya ni kee.” ");
INSERT INTO hwo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amma mbǝ niifa sǝ na mbang ndikrha a tenggǝn a pǝpal wa, ƙǝsǝr na nda a tǝrǝm Yahudayani. ");
INSERT INTO hwo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kanda a maɗufud wutsǝfayidɗi, tǝrgha Yeeso ɗǝgha ahu pǝpal Ƙǝn Faara ɗǝ katǝranggǝn tsaharha ha. ");
INSERT INTO hwo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudayini ƙǝsgha ǝnwulteena kanda tsakhmee nda, “Kamshiɗiya ˈwawa nda tsahang ha wa, ƙǝƙǝn walnǝn sǝnda kiya?” ");
INSERT INTO hwo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nggǝrangga Yeeso kanda sǝ, “Ənggini niya tsaharha ha ya mbǝ yina ni wa, amma yi Faara ni thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kala niifa wurgha ǝna ˈya na mid Faara, nǝn a sǝnɗasǝ tsahad na ha yi Faara ni, mbǝ yina ni wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kala nafiya na a ndikrha yi altendan, na mindan sǝ a falgha fiya kanda kee. Amma kala niifa na a ǝna taara ka a falgha fiya niifɗi thlǝngga ndǝn ɓa, nǝn pǝr ƙǝkafek, mbǝ nggaɓaarha wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Fǝrangwa na Musa ngyakhrha kun wa? Amma mbǝ niifa sǝ ahur nun ǝnagha taara tǝ ngyahadɗi wa. Kama na minnun sǝ a ɓǝleewun?” ");
INSERT INTO hwo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ndangga fiya, “Na ǝnkaheerha sǝ a fad wa, wunni na midghǝn sǝ a ɓǝloghǝn?” ");
INSERT INTO hwo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nggǝrangga Yeeso kanda sǝ, “Ənaɗi ǝnwulteena tǝtal a far yibrha, ƙǝsgha ǝnwulteena kun. ");
INSERT INTO hwo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Malang Musa ngyakhrha kun yi thlee muwa (ko nanǝn kyawa ɓa a mii Musa wa, amma yi chichiyi nun ni), kulo hai mbiya nun thlee muwa a far yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Anaɗun a thlee muwa a far yibrha, ƙǝsǝr amanun tǝɗang ngyakhrha Musa in, kama na hur nun sǝbrha ɗǝ tǝ nggi ƙǝsǝr ka ƙǝnang ni niifa a far yibrha? ");
INSERT INTO hwo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A ngwa ɗun kumarha yi yirha wa, amma ngwama kumarha yi ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Fingya na tǝ tsaurha a Urshalima katǝrangganda tsahang mee ndan ha, “Mbǝ niif ɗani na mindan ɓǝlang nda ya wa? ");
INSERT INTO hwo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kulo ndǝghǝn ya! A ndikrha a pǝpal, mbangwanda kalang sǝ tǝ ˈya ɗimi wa. Nduwa mamnggini fǝr nda ƙǝkafek ndǝghǝnni Ƙǝrǝsti wa? ");
INSERT INTO hwo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Amma sǝnɗǝm mbǝɗi ɓana niifɗi saɓa ya. A ɓad Ƙǝrǝsti ɓa, mbǝ niifa sǝ na a sǝn mbǝɗi kyanǝn saɓa wa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nana Yeeso a tsaharhaha ahu pǝpal Ƙǝn Faara, tǝranggǝn uradghǝn sǝ, “Nǝghǝn kee, sǝnɗun nggi, tǝ ƙǝm sǝnɗun mbǝɗi kyani saɓa. Mbǝ nggi ɓangga altenna ɓa wa, yanɗi thlǝngga nggi ɓa tǝ ƙǝkafek ni tǝ ƙǝm sǝnggun ndǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amma sǝnɗi ndǝn ƙǝsǝr ɓayi ɓa a thlǝmadghǝn, ndǝghǝn thlǝngga nggi a thlǝmad nun ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tǝrgha mamnggini na mindansǝ a ƙǝsangganda; amma mbǝ niifa sǝ mbangga ɗǝfang haara fa wa, ƙǝsǝr ɓawa sayidghǝn ɓa ˈwan wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amma fingya hangga ahur fiya wumngga hai fǝrƙǝkafek nda tǝghǝn ndanda, “A ɓa Ƙǝrǝsti ɓa, ɓanǝn ǝna ǝnwuteengya tǝ ǝnsakhkya hangga ma kamshiɗiya wa?” ");
INSERT INTO hwo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sǝk na Farisaya fad fiya a shishiwarha tǝ ndan aten Yeeso, tǝrgha mamnda firistaya tǝ Farisaya thlǝn fa ƙǝla Ƙǝn Faara nda a ɗaa nda ƙǝsang nda. ");
INSERT INTO hwo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ndangga Yeeso kanda, “Niya tsǝrha tsǝɓaku tǝ kun, a nggǝryi wutta thlǝmad yanɗa ɗǝ thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nun a kaɗa nggi, amma mbun waleerha wa; mbǝɗi nani sǝ mbun mbang ɗǝrha saɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ndangga Yahudayini ndan, “Na mid niifɗi ɗǝrha yaaɗǝ ya, ndanǝn mbǝm mbang walang wa? Nduwa nǝn a ɗǝrha mbǝɗaɗǝ welna nafinǝm saaɗǝ tǝ tsaurha ahur Helenaya, ka ɗǝgha tsahang nda Helenaya ha wa? ");
INSERT INTO hwo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mana midghǝn ndaarha, ‘Nun a kaɗa nggi, amma mbun waleerha wa,’ tǝ ƙǝm, ‘Mbǝɗi nani sǝ, mbun mbang ɗǝrha saɗǝ wa’?” ");
INSERT INTO hwo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A far ngwala wutsǝfayidɗi, ndǝna manda far terɗi, thliigha Yeeso sǝ tǝranggǝn uradghǝn sǝ ndǝghǝn, “Ana niifa sǝ na tǝ hushimnda fa, ɓagha thlǝmadna ɓa ɓagha saarha. ");
INSERT INTO hwo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kala niifa fǝrgha ƙǝkafek a nggi, ƙǝla ndana Ɗeleewar Faara, suhwadya na fǝr aam yibrha nǝn a ngǝtta ɓa ahurghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A mbǝɗiya na Yeeso a ndaarha Sǝsǝn Faara ni, na fingya a thlǝrha fǝrgha ƙǝkafek a ndǝghǝn. Amma fǝr wanda Sǝsǝna ˈwan wa, ƙǝsǝr fǝrangwa Faara mamnggirha Yeeso wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sǝkna fiya palthɗi ndanǝn, ndaagha fingya, “Ƙǝkafek, niifɗiya annabi ɗani.” ");
INSERT INTO hwo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ndaagha fingya, “Ndǝghǝnni Ƙǝrǝsti.” Nggǝrgha fingya tsakh mee, “Amma mbǝ ǝnaarha hai kee wa! Ƙǝƙǝn na Ƙǝrǝsti kyarha ɓa a Nggalili ɓa? ");
INSERT INTO hwo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mbǝ ndaagha Ɗeleewar Faara, na Ƙǝrǝsti a ɓaarha ɓa ahu turya Ndauda, nggǝtghǝn nda a Mbaitalami, tala tsauna Ndauda sǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsaunǝn kee, tsakhka mii fiya hai wumngga hai ƙǝsǝr ka Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Fingya na mindan sǝ a ƙǝsangganda, amma mbǝ niifa sǝ ɗǝfangga haara fa wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wudna fa ƙǝla Ƙǝn Faara a thlǝmad mamnda firisya ɗǝ tǝ Farisaya, tsahang mee nda kanda, “Kama ƙǝsang ngwa nun ɓa?” ");
INSERT INTO hwo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nggǝrang ngganda mamngya firistaya sǝ tǝ Farisaya, “Mbǝ niifa sǝ ˈwagha ndikrha ƙǝla niifɗiya wa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ndangga Farisayini fa ƙǝla ƙǝnɗa ha, “Kun ƙǝm nggaɓaɗǝ kun wa? ");
INSERT INTO hwo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na niifa sǝ tal ahur mamngya Yahudaya nduwa Farisaya fǝrgha ƙǝkafek a ndǝghǝn? Awo!” ");
INSERT INTO hwo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amma nafini wumngga hai shiwang nda kanda ƙǝsǝr sǝngwanda ˈya aten ngyakhrha Musa wa. ");
INSERT INTO hwo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus ˈwagha ɗǝrha thlǝmad Yeeso ɗǝ, nǝghǝn tal ahur ndan, tsakh mee nǝn, ");
INSERT INTO hwo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A hu ngyahad nǝm mǝmǝl ni ngwang kumarha nǝm niifa ƙǝm kula ramu ˈya ha ǝna nǝn wa?” ");
INSERT INTO hwo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nggǝrang ngganda sǝ, “Ɓagha ɓa a Nggalili ƙǝm wa? A karatang na Ɗeleewar Faara ngga na sǝndasǝ tǝ ndaarha ˈwawa Annabi kyarha ɓa a Nggalili wa.” ");
INSERT INTO hwo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tǝrgha kowunni wudgha wure ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tǝrgha Yeeso ɗǝgha wumnda ɗǝfya Dzaitun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","A tsar ƙǝrǝt nggǝrghǝn wutta a pǝpal Ƙǝn Faara ɗǝ, wumngga fiya thlǝmadghǝn ɓa, tsauka hai nagha a tsahang kanda ha. ");
INSERT INTO hwo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tǝrgha fa malǝmngya ngyakhrha tǝ Farisaya ɓang nuneefa nda ɓa ƙǝsang nanda a ǝna kulafayirha. Ishang ngganda a maɗufun fiya wumngga hai. ");
INSERT INTO hwo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ndangganda Yeeso, “Mala, ƙǝsang ɗan nuɗiya a ǝna kulafayirha. ");
INSERT INTO hwo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A hu Ɗeleewar ngyakhrha Musa ndǝghǝn tǝtani a muk tur nishyina nan ya tǝ ferya mǝrgha. Nanǝnya, ma ndaana?” ");
INSERT INTO hwo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsahang nanda tur miiɗi ya ka a ɗǝfang takthleera nda, tǝna nda wal kwamana a ƙǝsang ngganda tǝ ɗimiyirha. Amma ɓǝrgha Yeeso hai chirelthgha a hweeɗe tǝ wan haarghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɗǝna nda mbeeɗǝ tǝ tsahang mee ha, nggǝrghǝn thliirha sǝ ndanggǝn kanda, “Ana niifa sǝ ahur nun ǝnawa ɗimiyirha, katǝranggǝn mukƙǝn hai tǝ feera.” ");
INSERT INTO hwo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nggǝrghǝn ɓǝra hai nagha a chireethla a hweeɗe. ");
INSERT INTO hwo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sǝkna nda kee ngǝra nda hai tǝtal, tǝtal ka a ten shing ndǝn ndan ɗǝgha hu yanɗa ɗǝ na ngguchit. Mal Yeeso nda tǝ nuɗi ƙǝt a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tǝrgha Yeeso nggǝrghǝn thliirha sǝ ndanggǝn nuɗi, “Nuɗiya ai kanda? Asǝ tal ahur ndan mbangga nggo kumarha wa?” ");
INSERT INTO hwo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ndangga nuɗi, “Paɓa, mbǝ niifa sǝ wa.” Tǝrgha ndangga Yeeso, “Ko nggini ma nggo yi kumarha sǝ wa, wiu fayiwa a nggǝrna ǝna ɗimiyirha wa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nggǝrgha Yeeso ndang nda fiya, “Nggini kukwaryid ƙǝshiirha. Kala niifa mbuwa samadna mbǝ tam wiirha hai hu wula wa, amma nǝn wal kukwaryid yibrha.” ");
INSERT INTO hwo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ndangga Farisayini, “Na thlǝk pathla yi alten wa kee, mbǝ ƙǝkafek sǝ hu ˈya na a thlǝkrha wa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nggǝrangga Yeeso kanda sǝ, “Ko nanǝn nggini a thlǝkƙǝn tǝ altenna, palthɗi niya thlǝkrha atenna ƙǝkafek ni. Ƙǝsǝr sǝnɗi mbǝɗi kyani saɓa tǝ mbǝɗi niya ɗǝrha saaɗǝ. Amma kun sǝnggun mbǝɗi kyani saɓa tǝ mbǝɗi niya ɗǝrha saaɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nuwun a ngwe kumarha sǝ yi thlu farha, amma nggi mbǝ niifa sǝ ngwang ni kumarha sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amma a ngwaɗi kumarha ma, ˈya niya thlǝkrha mǝmǝl ni, ƙǝsǝr mbǝ nggi katenna na a ǝnaghǝn wa. Amma nggi tǝ Pǝpa thlǝngga nggi ɓa na a ǝnaghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A hu ɗeleewar ngyahad nun nǝghǝn chichirethlee hai tǝ ndaarha, nafiya sǝri a fǝr nda sheeda ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nggi fǝrɗi sheeda a tenna, Pǝpa thlǝngga nggi ɓa ƙǝm fǝrɗǝ sheeda atenna.” ");
INSERT INTO hwo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tǝrgha tsahang mee nda, “Ai tsu?” Nggǝrangga Yeeso kanda sǝ, “Tsaunǝn sǝnggun nggi wa, Pǝpa ma mbun sǝnggǝn wa. Andam sǝnɗun nggi, nun sǝn Pǝpa ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Thlǝkƙa Yeeso palthyini ya nanǝn a tsaharhaha a pǝpal Ƙǝn Faara, tsau tǝ mbǝɗi na nda ɗǝf wuɗǝɓǝl fǝra sǝ a Faara. Amma ƙǝsang ngwanda wa, ƙǝsǝr ɓawa sayidghǝn ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tǝrgha nggǝrgha Yeeso ndang nda kanda, “Niya wiirha, ɓanun kaɗa nggi, nun a mǝra kee hu ɗimiyid nun. Mbǝɗi niya ɗǝrha saaɗǝ mbun mbang ɗǝrha ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tǝrgha tsakhka mamngya Yahudayini mee, “Na midghǝn sǝ a ɓǝlanggǝn fadghǝn wa? Mani nǝn a ndaarha, ‘Mbǝɗi niya ɗǝrha saaɗǝ mbun mbang ɗǝrha ɗǝ wa’?” ");
INSERT INTO hwo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nggǝrangga Yeeso kanda sǝ, “Kun nuwun a hweeɗe ɓa, amma nggi niyi a talara hai. Kun yi ƙǝshiirha ni, nggi mbǝ yi ƙǝshidɗa ni ya wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndǝghǝn ɗani ndang ni kun wu nun a mǝra hu ɗimiyid nun; ƙǝl a fǝrɗun ƙǝkafek tǝ ndaarha nggini ndani nggini, a mbǝ kee wa nun a mǝra ahu ɗimiyid nun.” ");
INSERT INTO hwo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsahang mee nda, “Wunni sa?” Nggǝrangga Yeeso kanda sǝ, “Nggini ƙǝla ni naarha pǝrang nda kun ka ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na fingya ǝngya sǝ hangga na minna thlǝkrha a tennun, tǝ ƙǝm ngwang kumarha ni kun sǝ a tenggǝn. Amma mbiya ǝnaghǝn wa, ƙǝsǝr thlǝkki ˈya kee sǝk ni hai a mii niifɗi thlǝngga nggi ɓa, tǝ ƙǝm tǝ ƙǝkafek ni.” ");
INSERT INTO hwo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amma sǝngwanda sǝ nǝghǝn a thlǝghang ˈya kanda a ten Chin wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndaagha Yeeso, “A sayidɗi tǝrang nun Wan Niifa a ten kaɗiirha sǝ, a mbǝɗa ni nun a sǝnda sǝ nggini. Mbǝ ˈyasǝ ni mbang ǝnaarha tafanna wa, amma ni thlǝk ˈya tsahe na Pǝpa ha kee. ");
INSERT INTO hwo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Amma niifɗi thlǝngga nggi ɓa nǝghǝn a thlǝmanna; malwa nggi katenna wa, ƙǝsǝr ni naarha ǝna ǝngya mbǝnangga hur.” ");
INSERT INTO hwo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A hu sayidɗi nǝn naarha thlǝk ǝnggini ya, fingya hangga fǝrgha ƙǝkafek tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndangga Yeeso nafini fǝrgha ƙǝkafek tǝghǝn, “A ƙǝsɗun tsahad na ha kunni na fatsahayina yi ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nun a sǝn ƙǝkafek, na ƙǝkafek ɗi ƙǝm a hǝrghang kun.” ");
INSERT INTO hwo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nggǝrangganda sǝ, “Kan chichiiya Ibrahim ni, ˈwa wan tsau mafayirha aki niifa hu ƙǝshidɗiya wa. Ƙǝƙǝn na ndaarha na hǝrghang kan?” ");
INSERT INTO hwo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nggǝrangga Yeeso kanda sǝ, “Niya pǝrang ƙǝkafek kun, kala niifa na ǝna ɗimiyirha mafad ɗimiyirha ni. ");
INSERT INTO hwo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mafarha mbǝ mbǝd tsawudghǝn ni ahu wure pakwanɗǝ wa, amma wan wure wurighǝn ni pakwanɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ana Wanɗa ni hǝrghangga kun, ƙǝkafek wal ɗun hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sǝnɗisǝ kun chichiya Ibrahim ni. Amma na minnun sǝ a ɓǝleewun, ƙǝsǝr laɓar na kyawa hur nun hai wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Niyi a pǝrang ˈya kun keɗee na Pǝpa, amma kun nuwun a ǝna ˈya ndang na chinun kun.” ");
INSERT INTO hwo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ndangganda, “Ibrahim ni chinan.” Nggǝrangga Yeeso kanda sǝ, “Ana wangya Ibrahim ni kun, kam ǝnaɗun ǝnggini ǝnana Ibrahim. ");
INSERT INTO hwo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A meghedghǝn na mid nun sǝ a ɓǝleewun ka pǝrang ni ƙǝkafek kun pǝree na Faara. Ənawa Ibrahim kee wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nuwun a ǝna ǝnggini ǝnana china.” Nggǝrangga nafini Yeeso sǝ, “Kan mbǝ wangya mǝterya ni wa, Chinan tal ni ndǝna Faara tafadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ndangga Yeeso kanda, “Andam Faara ndǝna chinun, kam nggǝmɗun nggi fa, ƙǝsǝr ɓayi ɓa a thlǝmad Faara nanǝnya, kulo nggiya. Ɓayi ɓa tǝ sǝsǝmnda altenna wa; amma ndǝghǝn thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mani mbuwa nun a sǝnang ǝnɗa hai niya thlǝkrha? Ƙǝsǝr mbun a mbang ƙǝrǝs sǝk tsahad na ha wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kun yi chinun, sheetan ni, na minnun sǝ a ǝna ǝnɗanun na midghǝn. Ka a katǝradghǝn tǝ ɓǝl farha ni, djiɗangwa ˈya tǝ ƙǝkafekkirha wa, ƙǝsǝr mbǝ ƙǝkafek sǝ a fadghǝn wa. Anaɗǝ a nggaɓaarha, pǝr nǝn ǝn ǝnadghǝn, ƙǝsǝr tǝ nggaɓaarha ni, chin fa nggaɓaya ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ka pǝrang ni ƙǝkafek kun, ndǝn kar nun fǝrƙǝkafek tǝ nggi! ");
INSERT INTO hwo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wunni ahur nun na mbang kyad ˈya ˈwani ǝna ɗǝmiyirha a tenggǝn? A naɗi a pǝr ƙǝkafek, kama nda mbuwa nun fǝrƙǝkafek tǝ nggi? ");
INSERT INTO hwo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Niifa na yi Faara nǝn sǝk ya na Faara a thlǝkrha. ˈYa ǝnagha ndǝn mbuwa nun a sǝkƙǝn ƙǝsǝr mbǝ yi Faara ni kun wa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ndangga Yahudayini, “Nanǝn kee, ƙǝkafek ni nda nan tǝ Samariyarha ni sa naa tǝ ǝnkaheerha fa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nggǝrangga Yeeso kanda sǝ, “Mbǝ ǝnkaheerha sǝ a fadna wa, ni fǝrang mamnggirha Pǝpa, amma kun sarɗun nggi. ");
INSERT INTO hwo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mbiyi a kaɗan mamnggirha altenna sǝ wa; amma na yanɗa sǝ na midghǝn sǝ a maneegha nda, ndǝghǝnni tǝ ngwa kumarha. ");
INSERT INTO hwo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Niya pǝrang ƙǝkafek kun, kala niifa ƙǝsgha laɓarna ha, mbǝ tam mǝra wa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ndangga Yahudayini, “Nanǝnya sǝnɗansǝ na tǝ ǝnkaheerha fa! Mǝr Ibrahim tǝ ƙǝm mǝr annabiya, amma nana a ndaarha, kala niifa ƙǝsgha laɓar wa ha mbǝ tam mǝra wa. ");
INSERT INTO hwo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na a ndaarha kalna chinan Ibrahim wa? Mǝrɗǝ, annabiya ƙǝm mǝr nda. Naa a ndaarha wunni sa?” ");
INSERT INTO hwo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nggǝrangga Yeeso kanda sǝ, “A manang ɗi altenna, mamnggid ɗiya mbǝ a mii ˈya wa. Amma pǝpa ndanun ndǝghǝnni Faar nun, ndǝghǝnni na a maneerha. ");
INSERT INTO hwo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ko nanǝn sǝnggun ndǝn wa, amma sǝnɗi ndǝn. A nda ɗi sǝngwi ndǝn wa, niya tsaurha tǝ nggaɓaarha ƙǝla kun, amma sǝnɗi ndǝn tǝ ƙǝm ƙǝs ɗi laɓarghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chinun Ibrahim kukwasang ɗa fa ka a naa ɓad na nǝn ɓa. Na ɗa ndǝn, tǝ ƙǝm tǝkɗǝ mbǝnda fa.” ");
INSERT INTO hwo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ndangga Yahudayini “Sǝlwa hurad wa kumggit tuf wa, ƙǝƙǝn na ndaarha nanna Ibrahim?” ");
INSERT INTO hwo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nggǝrangga Yeeso kanda sǝ “Niya pǝrang ƙǝkafek kun, kapa na nda nggǝt Ibrahim, niyi sǝ!” ");
INSERT INTO hwo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Thlǝkna Yeeso palthɗi ya kee, haar ferya nda ka a mukƙǝn nda. Amma ɓǝɓeegha Yeeso kyagha sǝ ma Ƙǝn Faara. ");
INSERT INTO hwo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nana Yeeso a wiirha hai, na niifa nǝn nggǝt nanda kwamarǝn. ");
INSERT INTO hwo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsahangga fatsahayighǝn mee, “Mala, yanggini ǝnagha ɗimiyirha nggǝt nanda niifɗiya kwamarǝn, ndǝghǝn wa nduwa fa nggǝtyighǝn?” ");
INSERT INTO hwo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ndangga Yeeso kanda, “Mbǝ niifɗiya nduwa fa nggǝtyighǝn ǝnagha ɗimiyirha wa, amma nggǝt na ndan kwamarǝn tǝna nda kyad tar Faara a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nanǝn ɓalgha yanfaara sǝ, tǝta ni a fad nǝm a ǝna tar niifɗa nǝm thlǝngga nggi ɓa. Fǝɗikrha a tsǝrha hai, mbuwana niifa mbang ǝna taara a fǝɗikrha. ");
INSERT INTO hwo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nani hu ƙǝshiirha, nggini kukwaryid ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tǝrgha chakh yakhrha nǝn hweeɗe hai, tǝtǝnanggǝn tabrha tǝ yahadghǝn, ƙǝmanggǝn a yid niifɗi. ");
INSERT INTO hwo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ndanggǝn niifɗi, “Ɗuwa ɗǝ ɗa tsaɓang yidwa ɗǝ ahu wutambar Siliyom” (Siliyom ndaarha ni thlǝnda) tǝrgha ɗǝgha niifɗa ɗǝ tsaɓanggǝn yidghǝn ɗǝ, wudgha ɓa nagha a na mana hai. ");
INSERT INTO hwo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tulayighǝn tǝ fingya nafiya na naarha naghǝn a hwanda tsakh mee nda, “Mbǝ niifɗa ni ya na tsaurha hai nagha a hwanda wa?” ");
INSERT INTO hwo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ndagha fingya ndǝghǝnni. Fingya ƙǝm ndanda, “Awo, mbǝ ndǝghǝn ni wa thlǝnǝn ndǝn kee.” Amma ndǝghǝnggi nagha a ndaarha, “Nggini niifɗi.” ");
INSERT INTO hwo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsahang mee nda, “Mani nanǝnya na a naa mana hai?” ");
INSERT INTO hwo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ndanggǝn kanda, “Niifɗi na nda aarha Yeeso tǝtǝnangga tabrha ƙǝmee ƙǝnǝn a yidna ndeeghǝn, ‘Ɗuwa hu kufad Siliyom ɗǝ tsaɓangga yidwa ɗǝ.’ Ɗiyaɗǝ tsaɓanggi yidna ɗǝ, hǝrǝm ni tsaɓang yidna ɗǝ, ƙǝlee hai kee nggi a na mana hai!” ");
INSERT INTO hwo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsahang mee nda, “Nǝghǝn a yanggi nanǝnya?” Nggǝranggǝn kanda sǝ, “Sǝngwi mbǝɗi nanǝnsǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tǝrgha ɗǝnda tǝ niifɗi tamngga kwamarǝn a thlǝmad Farisaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A far yiɓǝd Yahudaya ni tǝtǝnang na Yeeso taɓadɗi inang nǝn yid niifɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tsaunǝn kee, Farisayini ƙǝm tsahang mee nda kwamadɗi walgha ƙǝnda. Ndangga niifɗi kanda, “Tǝtǝnanggǝn tabrha ƙǝmee ƙǝnǝn a yidna, ɗǝni tsaɓang nda ɗǝ ƙǝlee hai kee nggi a na mana hai!” ");
INSERT INTO hwo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ndagha fingya Farisaya, “Niifɗiya ɓawa ɓa a thlǝmad Faara wa, ƙǝsǝr nǝghǝn a ǝna taara a far Yibrha.” Ndagha fingya, “Amma ƙǝƙǝn na tǝ ɗimirha ǝna ǝnwulteena ƙǝla yanɗiya?” A mbǝɗiya tsakhka mii ndan hai. ");
INSERT INTO hwo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tǝrgha nggǝrgha Farisayini tsahang mee niifɗi, “Tsau nǝn inang ɗǝ yidwa ɗǝ, sa a naa mana hai, mana mbang ndaarha aten niifɗi ƙǝnowa ya?” Nggǝranggǝn kanda sǝ, “Annabi ni.” ");
INSERT INTO hwo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yahudayini fǝrwanda ƙǝkafek kwamarha ni niifɗiya kaar na a naa maana hai nanǝnya wa, thlǝn farha nda a aah fa nggǝtyighǝn nda ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tsahang mee nda kanda, “Wanun niya wa? Ndawun nggǝt wun ndǝn kwamarǝn, ƙǝƙǝn nǝn a naa maana hai nanǝnya?” ");
INSERT INTO hwo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nggǝrangga fa nggǝtyighǝn kanda sǝ, “Sǝnɗansǝ wanan ni ya tǝ ƙǝm nggǝtghan ndǝn kwamarǝn. ");
INSERT INTO hwo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma kan kam sǝngwan kwamanɗi wal nǝn, nǝn a na maana hai nanǝnya wa, nduwa niifɗi inangga yidghǝn ɗǝ wa. Tsahaman mee lee, mbǝ wundakhne ni wa, nǝn mbang thlǝkƙǝn tǝ miighǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Thlǝkna fa nggǝtyighǝn ndǝn kee ƙǝsǝr na nda a tǝrǝm Yahudaya, ƙǝsǝr nggǝmnda fa tǝ ndaarha kala niifa ndagha Yeeso Ƙǝrǝsti ni na nda a rǝghang ɗǝ ma ƙǝn tsahad Yahudaya.) ");
INSERT INTO hwo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndǝn ndaana fa nggǝtyighǝn, “Mbǝ wundakhne ni wa; tsahaman mee.” ");
INSERT INTO hwo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nggǝrgha nda aah niifɗa ɓa nggǝt na nda kwamarǝn kaar, ndangganda, “Fǝrang mamnggirha Faara pǝr ƙǝkafek na, ƙǝsǝr sǝnɗansǝ niifɗi ƙǝnogha ya tǝ ɗimirha ni.” ");
INSERT INTO hwo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nggǝranggǝn kanda sǝ, “Tǝɗimirha ni nduwa mbǝ tǝɗimirha ni wa mbi sǝnda wa. Amma ˈya sǝnni sǝ, kaar niyi kwamarǝn, nanǝnya nggi a na mana hai!” ");
INSERT INTO hwo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tǝrgha tsahang mee nda, “Mani ǝno nǝn? Ƙǝƙǝn inang nǝn yidwa ɗǝ?” ");
INSERT INTO hwo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nggǝranggǝn kanda sǝ, “ˈWaɗi teena pǝrangɗi ndǝn kun, nggǝmnggun fa wa. Mani na mid nun a nggǝr wun sǝƙƙǝn faɗǝn? Nduwa kun ƙǝm na mid nun sǝ a tsawun fatsahayighǝn wa?” ");
INSERT INTO hwo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tǝrgha ˈyarghǝn nda, ndanda, “Sa ndǝna tǝ tsahadghǝn, amma kan fatsahaya Musa ni. ");
INSERT INTO hwo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sǝnɗansǝ ndik Faara tǝ Musa, amma niifɗiya sǝngwan mbǝɗi kyanǝn saɓa wa.” ");
INSERT INTO hwo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nggǝrangga niifɗi kanda sǝ, “Kulo ǝnwulteena a weeriya! Ine yidna nǝn ɗǝ amma ndon sǝnggun mbǝɗi kya nǝn saɓa wa? ");
INSERT INTO hwo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sǝnɗǝm sǝ Faara mbǝ kang thlǝmaarha faɗimiya fa wa, amma nǝn kang thlǝmaarha nafiya fa na a fǝrang mamnggirha tǝ ƙǝm ǝna ˈya nda na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka ǝnana nda ƙǝshiirha ˈwa wum sǝk ndaarha na niifasǝ ˈwagha inang yid kwamarha ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A mbǝ ɓana niifɗa ɓa a thlǝmad Faara ya wa, mbǝ mbang ǝna ˈya kiya wa.” ");
INSERT INTO hwo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nggǝrang ngganda sǝ, “Sa nggǝt nanda tǝɗimirha, na midwa sǝ a tsahangga kan ha wa?” A mbǝɗi kee rǝkƙǝn nda ƙǝshaaɗǝ ma ƙǝn tsahadɗa ha. ");
INSERT INTO hwo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sǝkna Yeeso ndaarha rǝk ndan, ɗǝgha wal niifɗi ndanggǝn, “Fǝrna ƙǝkafek tǝ Wan Niifa wa?” ");
INSERT INTO hwo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nggǝrangga niifɗa sǝ, “Paɓa, wunni niifɗi? Pǝreƙǝn tǝni fǝrƙǝkafek a ndǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ndangga Yeeso, “Nanǝnya nannan, ndǝghǝnni na a kalo sǝ nanǝnya.” ");
INSERT INTO hwo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tǝrgha ndagha niifɗi, “Chinǝm, fǝrɗi ƙǝkafek.” A mbǝɗi kee tǝrang shilee nǝn Yeeso in. ");
INSERT INTO hwo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ndangga Yeeso, “Ɓani ka ngwa kumarha hu ƙǝshiirha ɓa, tǝna kwamaya na maana hai fingya na a naa maana hai tsawa nda kwamaya.” ");
INSERT INTO hwo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fingya Farisaya na tsau tǝ thlǝmadghǝn sǝk nanda kee tsahang mee nda, “Yo! Naa a ndaarha kan ma kwamaya ni wa?” ");
INSERT INTO hwo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nggǝrangga Yeeso kanda sǝ ndǝghǝn, “Ana kwamaya ni kun, kam mbuwun tǝ ɗimiyirha fa wa. Amma nanǝnya nuwun a ndaarha nuwun a naa maana hai, ɗimiyid nun tsauɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ɗǝgha Yeeso mbeeɗǝ tǝ ndaarha “Niya pǝrang ƙǝkafek kun, kala niifa kyagha hu chiɓǝd chauraya hai mbǝ tǝ kwatkirma wa, amma kyagha sa hai tǝ mbǝrha pak, ngaara ni tǝ ƙǝm tǝfasa farha. ");
INSERT INTO hwo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amma niifɗi kyagha sahai tǝ kwatkirma ndǝna tǝ laf chaukhrayini. ");
INSERT INTO hwo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tǝƙǝla kwatkirǝm ɗa ha nǝn a inanggǝn hai, chaukhrayini sǝnda uradghǝn. Nǝn aah chaurayighǝn tǝ thlǝm ndan kyanggǝn kanda ƙǝshaaɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A kyang ɗǝ yighǝn chaukhraya ƙǝshaaɗǝ heu, nǝn a naarha a mbee mbu samadghǝn nda, ƙǝsǝr sǝnda uradghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amma mba nda mbu samad ronga wa, ƙǝkafek na nda ɗaarha ma thlǝmadghǝn ƙǝsǝr sǝnang ngwanda urad ronga hai wa.” ");
INSERT INTO hwo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tǝ karapu thlǝghang na Yeeso laɓarɗi kanda sǝ ya, amma sǝnangwanda ten karapu ɗa hai ndanǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nanǝn kee, nggǝrgha Yeeso ndaarha, “Niya pǝrang ƙǝkafek kun, nggini kwatkirǝm chaukhrayini. ");
INSERT INTO hwo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nafiya heu ˈwagha ɓa ma nggi ngaarya ni tǝ fa fasa faya, amma chaukhrayini kangwanda thlǝmaarha kanda fa wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nggini kwatkirǝm ɗi; niifa kyagha ɓa tǝ thlǝmanna nǝn a wal hǝrǝkrha. Na nda a kyarha sahai kya nda sǝ, na nda a lafrha. ");
INSERT INTO hwo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na ngaara kyarha ɗǝ ka ɗǝgha ngaara, ɓǝl farha nǝn tǝ ƙǝm sǝɓanggǝn ǝngya ɗǝ. ˈYa ɓeegha ɓa ka a fǝr yibrha ni, yibrha na lǝlǝgɗa. ");
INSERT INTO hwo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ka niifa ni nggi mbangga lafrha. Niifa mbangga lafrha nǝn fǝr yiɓǝdghǝn ka chaurayighǝn. ");
INSERT INTO hwo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tǝ laf wuɗǝɓǝla, mbǝ tǝlafrha ni wa, tǝ ƙǝm mbǝ yighǝnni chaukhrayini wa. A naɗǝ mǝmeere ɓayi, nǝn ɗaarha mal chaurayina nǝn. Tǝrgha mǝmeere ɗi nǝn ƙǝsang kanda hǝhathlanggǝn kanda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tǝ laf wuɗǝɓǝlɗi ɗaa nǝn ƙǝsǝr ɓanǝn ka laf wuɗǝɓǝla ɓa kee, mbǝ ˈyasǝ djiɗangga tǝ chaukhrayini wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nggini tǝlafrha na ngga, sǝnɗi chaurayina, chaurayina ƙǝm sǝnda nggi, ");
INSERT INTO hwo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ƙǝla sǝnna Chinɗi nggi; nggi ƙǝm sǝnɗi Chinɗi tǝ ƙǝm fǝrɗi yiɓǝdna ka chaukhrayini. ");
INSERT INTO hwo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na fingya chaurayina sǝ mbuwa ahur chiɓǝd ɗiya. Tǝtani ƙǝm a ɓeeɓa tǝ kanda. Na nda kang thlǝmaarha uradna fa, na nda a tsaurha chibrha tal, tǝlafrha ƙǝm tal. ");
INSERT INTO hwo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ƙǝsǝr ka ǝngginiya ndǝn nggǝmna Chinɗi nggi, ƙǝsǝr nggǝmɗi fa a fǝr yiɓǝdna ni, tǝni nggǝr thlǝghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mbǝ niifa sǝ na thlang sǝ a harna wa, ƙǝsǝr nggi tǝ altenna ni na a fǝrghǝn. Na sǝsǝmnda sǝ a harna na a fǝrghǝn ni, tǝ ƙǝm nggǝryi thlǝghǝn ɓa. Sǝsǝmndǝ ɗiya thlǝyi ndǝn ahar Pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Thlǝkna Yeeso laɓarɗi kee, nggǝrgha mii Yahudayini tsakhrha hai sǝri. ");
INSERT INTO hwo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Fingya hangga ahur ndan ndanda, “Na ǝnkaheerha sǝ a fadghǝn, tǝ ƙǝm tǝpabirha ni. Kama nda nun kang thlǝmaarha fa?” ");
INSERT INTO hwo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amma nagha fingya a ndaarha, “Niifa na tǝ ǝnkaheerha fa mbǝ thlǝk pathla kiya wa! Ƙǝƙǝn na ǝnkaheerha inang yid kwamarha ɗǝ?” ");
INSERT INTO hwo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nanǝnya ndǝri mbiirha ni, a Urshalima na nda a ǝna wutsǝfayid fǝr Ƙǝn Faara. ");
INSERT INTO hwo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeeso a wiirha hai hu ƙǝn Faarɗi a mbǝrha na nda aarha Mǝthlǝm Sulemanu. ");
INSERT INTO hwo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tǝrgha Yahudayini wuma nda a thlǝmadghǝn heu, ndang ngganda, “Pakwanɗǝ na mal kan ahu wula? Ana sa ni Ƙǝrǝsti pǝranggǝn kan a pǝpal lee.” ");
INSERT INTO hwo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nggǝrangga Yeeso kanda sǝ, “Pǝrangɗi ndǝn kun, amma fǝr wun ƙǝkafek wa. Əngya ǝnani ahu thlǝm Pǝpa ndǝn kyadgha ndaarha tǝ wunni nggi. ");
INSERT INTO hwo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amma fǝr wun ƙǝkafek wa, ƙǝsǝr mbǝ chaurayina ni kun wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chaurayina na nda sǝk ˈya niya thlǝkrha, sǝnɗi kanda, tǝ ƙǝm na nda mbu samadna. ");
INSERT INTO hwo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Fǝrang ɗi yibrha kanda mbuwa ngwalaarha, mba nda tam mǝra wa, mbǝ niifa sǝ na thlang kanda sǝ a harna wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pǝpa fǝreegha kanda kalɗǝ kowunni heu, mbǝ niifa sǝ na mbang thlang kanda sǝ a haar Chinɗi wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nggi tǝ Chinɗi nan tal.” ");
INSERT INTO hwo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nggǝrgha Yahudayini har ferya ɓa ka a mukƙǝn nda. ");
INSERT INTO hwo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Amma ndangga Yeeso kanda, “Kyaɗang ɗi tarya kun hangga na nggǝngga a thlǝmad Pǝpa ɓa. Aten yanggini na minnun muk nggi kamanggǝn?” ");
INSERT INTO hwo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nggǝrang ngganda sǝ, “Mban a muk sa ka ǝngya na nggǝngga ǝnana wa, amma ka laɓar sar farha ǝnana a Faara, ƙǝsǝr sa niifa ni kee, nana a mǝmǝlang fadwa tǝ Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nggǝrangga Yeeso kanda sǝ, “Mbǝ nǝghǝn chichireethlee hai ahu ɗeleewar Ngyahad nun ndaana Faara, ‘Ndayi, faarya ni kun!’ ");
INSERT INTO hwo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mba tam ngal Ɗeleewar Faara wa, a ndik Faara tǝ nafini, aah kanda nǝn faarya, ");
INSERT INTO hwo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nggi kam, Pǝpa wurgha nggi thlǝn nǝn nggi hu ƙǝshiirha ɓa. Ƙǝƙǝn nun ndeerha sarɗi Faara ƙǝsǝr ka ndaani, ‘Nggini Wan Faara’ wa? ");
INSERT INTO hwo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","A fǝrɗun ƙǝkafek a nggi wa, a mbi a takkwa ˈya ndeena Pǝpa a ǝnee wa. ");
INSERT INTO hwo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma a ǝnaɗi kanda, ko nanǝn fǝreewun ƙǝkafek wa, kamɗǝ a fǝrƙǝkafek nun tǝ ǝnwultenggini ǝnani, tǝrgha nun a sǝndasǝ tǝ ƙǝm kukwalang nggun hai tǝ ndaarha Pǝpa nǝghǝn a hurna, nggi ƙǝm ahur Pǝpa.” ");
INSERT INTO hwo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na mindansǝ a nggǝrgha nda ƙǝsang nda, amma thlǝ farha nǝn a haar ndan. ");
INSERT INTO hwo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tǝrgha Yeeso wudgha samaarha ɗǝ a pǝm kufad Urdun ɗǝ a mbǝɗaɗǝ ˈwana Yahaya ǝna mbaptisǝma sǝ. Tsauka a mbǝɗi ˈwan. ");
INSERT INTO hwo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓagha fiya thlǝmadghǝn ɓa hangga. Ndanda, “Ko nanǝn ˈwawa Yahaya ǝna ǝnwulteena wa, amma ǝngya heu ˈwana Yahaya thlǝkrha a ten niifɗiya ƙǝkafek ni.” ");
INSERT INTO hwo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A mbǝɗi fiya hangga fǝrgha ƙǝkafek a Yeeso. Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na niifa sǝ thlǝmnggǝnni Liyadzuru mbǝ kanglangwa. Nǝghǝn tǝ tsaurha a Mbetani tal nda Mairamu tǝ Marthla. ");
INSERT INTO hwo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mairamu ɗiya ndǝna wanman na Liyadzuru na kalth hadghǝn, ndǝghǝnni irangga urdi Chinǝm fa a sarghǝn panggǝn ɗǝ tǝ was tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wutarayini kyab na a wanmanggi ya thlǝnang laɓara nda Yeeso ɗǝ tǝ ndaarha, “Chinǝm, niifɗi tǝ nggǝm nana mbǝ kanglang wa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sǝkna Yeeso laɓarɗi ndǝghǝn, “Wanhad ɗiya mbǝ a ɓǝlang wa. Katǝra nǝn hai kee ka a manangganda Faara, tǝ ƙǝm walgha Wanggǝn mamnggirha a fadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nggǝm Yeeso Marthla tǝ wanman, tǝ ƙǝm Liyadzuru. ");
INSERT INTO hwo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko nanǝn sǝkɗǝ ndaarha mbǝ Liyadzuru kanglang wa, nggǝrghǝn tsaurha yi ɓeena sǝri a mbǝɗi nanǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tǝrgha ndanggǝn fatsahayighǝn, “Taama wuɗǝm Yahudiya ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ndangga fatsahayighǝn, “Amma Mala, ahu ɓenggini mbǝrgha ɗǝ na mid Yahudaya sǝ muk sa tǝ ferya, na midwa sǝ a nggǝrgha wutta mbǝɗaɗǝ?” ");
INSERT INTO hwo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ndangga Yeeso kanda, “Mbǝna sayi kumkap sǝri ahu paara wa? Niifa na wiirha hai a yanfaara mbǝ kisaara wa, ƙǝsǝr nǝghǝn a na maana hai tǝ kukwaryid ƙǝshidɗiya. ");
INSERT INTO hwo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma ana niifa a wiirha hai a fǝɗikrha, nǝn kisaara, ƙǝsǝr mbǝ tǝ kukwaryirha wa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A kwasamadɗi thlǝknǝn palthɗiya, ɗǝgha mbeeɗǝ tǝ ndang nda kanda, “Pashid nǝm Liyadzuru a shii ɓeena; amma niya ɗǝrha mbǝɗa ɗǝ ɗi mekhneng sǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ndangga fatsahayighǝn, “Chinǝm, ana nǝn a shii ɓeena, nǝn a ƙǝnda.” ");
INSERT INTO hwo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeeso nǝghǝn a ndaarha ni mǝrna Liyadzuru, amma fatsahayighǝn na nda a numad ndagha Yeeso nǝghǝn a shii ɓeena ni. ");
INSERT INTO hwo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tǝrgha pǝranggǝnǝn kanda a pǝpal, “Mǝr Liyadzuru. ");
INSERT INTO hwo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ƙǝsǝr ka kun mbuwa ni a mbǝɗi tǝkɗi mbǝnda fa, ƙǝsǝr nun a fǝrƙǝkafek, nanǝn katǝrana ǝnɗa hai ya mbi a mbǝɗi wa. Amma tama thlǝmadghǝn ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tǝrgha Toma (na nda aarha Muɗaarha), ndanggǝn shayighǝn fatsahaya, “Taama ɗǝm ɗǝ ƙǝm, ɗǝm mǝra heu tǝ Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sǝlna Yeeso ɗǝ, ˈwanda teena pang nda Liyadzuru tǝ ɓeena faɗa. ");
INSERT INTO hwo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mbetani nǝghǝn tsau tǝ Urshalima, sǝlɗǝ kilomita mahan. ");
INSERT INTO hwo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahudaya hangga ɓagha ka nggab nda Marthla ɓa tǝ Mairamu ka mǝrra wanma ndan Liyadzuru. ");
INSERT INTO hwo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sǝkna Marthla ndaarha Yeeso ɓaghai, kyagha ƙǝshaaɗǝ ɗǝgha hwathlaghǝn fa, amma Mairamu tsauka a wuri. ");
INSERT INTO hwo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ndangga Marthla Yeeso, “Chinǝm, andam kwang naa a mbǝɗiya, kam mǝrwa wanmana wa. ");
INSERT INTO hwo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma sǝnɗi sǝ ko nanǝnya na Faara furo kala ˈya tsahang nana.” ");
INSERT INTO hwo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ndangga Yeeso Marthla, “Na wanmuwa a nggǝr thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nggǝrangga Marthla sǝ, “Haˈi, sǝnɗisǝ nǝn a nggǝr thliirha sǝ a mii ngwala ƙǝshiirha na mǝrya a thliirha sǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ndangga Yeeso, “Nggini na thleng mǝrya sǝ, nggini yibrha. Kala fingya fǝrgha ƙǝkafek a nggi ko mǝrna nda na nda a thliirha sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yanɗi ɓalgha tǝ yibrha fǝrgha ƙǝkafek a nggi mbǝ tam mǝra wa. Fǝrna ƙǝkafek tǝ palthɗi ya wa?” ");
INSERT INTO hwo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ndangga Marthla, “Haˈi, Chinǝm, fǝrɗi ƙǝkafek sani Ƙǝrǝsti, Wan Faara, na a ɓarha hu ƙǝshiirha ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Akwasamadɗi ndaana Marthla kee, wudgha aah wanman nǝn Mairamu a man patu ɗǝ ndanggǝn, “Ɓa mala ɓa, na midghǝn sǝ a naa sanǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sǝkna Mairamu kee, thliigha ƙǝkar ɗǝgha walghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sǝl wa Yeeso hur tal ɗa hai wa, amma tsaukwa a mbǝɗi ƙǝma nǝn tǝ Marthla. ");
INSERT INTO hwo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahudaya na tsǝtsau a thlǝmadghǝn ahur minda kanda a nggabghǝn, ƙǝlana nda hai thliiɗa sǝ ƙǝkar kyagha ƙǝshaaɗǝ, mbu samadghǝn nda tamngganda ndaarha ɗǝnǝn ka tǝrha aten kwaarha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sǝlna Mairamu a mbǝɗaɗǝ na Yeeso sǝ nanǝn ndǝn, fǝlgha hai a mbedghǝn ndanggǝn, “Chinǝm, a ndam nagha a mbǝɗiya, kam mǝrwa wanmana wa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nana Yeeso ndǝn a tǝrha, tǝ fingya Yahudaya mbuwa samadghǝn ɓa kanda ƙǝm a tǝrha haɗanggǝn fa, sǝbgha hurghǝn ɗǝ ɓillagha kaan. ");
INSERT INTO hwo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tsakhka Yeeso mee, “Panggun a yanggi?” Ndang ngganda, “Ɓoɓa ɓa naghǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tǝd Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndagha Yahudayini na ƙǝƙǝt mbǝɗa, “Ƙǝlama hai nggǝmɗa ndǝn kaan!” ");
INSERT INTO hwo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amma fingya ndang ngganda ndan, “Niif ɗiya inang ɗǝ yid kwamarha ɗǝ a mbǝɗi taarha. Mbuwa nǝn mbang ˈyaɗang mǝrra Liyadzuru fa wa?” ");
INSERT INTO hwo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nggǝrghǝn hur Yeeso sǝbrha ɗǝ kaan ɗǝgha tenkwadɗa ɗǝ. Kaɓeerha ni nggǝlang nanda miighǝn tǝ feera. ");
INSERT INTO hwo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ndangga Yeeso kanda, “Kwatǝra man ferɗa ɗǝ.” Amma Marthla wanman niifɗi mǝrgha ndanggǝn Yeeso, “Chinǝm, nanǝnya nǝn sǝrha, ƙǝsǝr mǝrghǝn tǝ ɓeena faɗa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nggǝrangga Yeeso sǝ, “Mbǝ ndoyi a fǝrna kǝkafek na a naa mamnggit Faara wa?” ");
INSERT INTO hwo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nanǝn kee kwatǝrang ngganda ferɗa ɗǝ. Tǝrgha ƙǝlagha Yeeso talara ɗǝ ndǝghǝn, “Pǝpa, usaɗi sa sǝkna hwandǝna. ");
INSERT INTO hwo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Sǝnɗisǝ ƙǝtsar na sǝk hwandǝna, amma thlǝk ni yanɗiya ka nafini na ƙǝƙǝt a mbǝɗiya, tǝna nda fǝrƙǝkafek, sǝna nda sǝ sa thlǝngga nggi ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ngwalang na Yeeso thlǝk palth ɗiya, tǝranggǝn uradghǝn sǝ kaan ndǝghǝn, “Liyadzuru kyo ɓa!” ");
INSERT INTO hwo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Niifɗi mǝrgha kyagha ɓa, nda harghǝn tǝ sarghǝn ƙǝƙǝna tǝ djarra kaɓad paarha, raɓang nda yidghǝn tǝ kaɓad paarha. Ndangga Yeeso kanda, “Kwasaman hai wiigha!” ");
INSERT INTO hwo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tsaunǝn kee, Yahudaya hangga na a thlǝmad Mairamu naa nanda ǝnɗi katǝragha hai fǝrƙǝkafek nda tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma fingya ahur ndan ɗǝnda thlǝmad Farisaya ɗǝ ɗa nda pǝrang ˈya kanda ǝnana Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tǝrgha mamnda firistaya tǝ Farisaya aah farha nda wumang ngganda kognaya hai. Tsahang mee nda ndan, “Ma nǝm a ǝnaarha? Ƙǝkafek niifɗiya ǝnaɗǝ ǝnwulteengya hangga. ");
INSERT INTO hwo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A malang ɗǝm nagha a ɗǝrha mbeeɗǝ, tsǝɓaku kowunni nǝn a fǝrƙǝkafek tǝghǝn. Tǝrgha na Romaya a ɓarha ɓa, na nda a thlang Ƙǝn Faarnǝm na chahal heu tǝ nafinǝm.” ");
INSERT INTO hwo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amma tal ahur ndan na nda aarha Kayafa mamnda firis ni ahu huradɗi ndǝghǝn, “Sǝnggun ˈya nun a thlǝkrha wa! ");
INSERT INTO hwo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sǝnggun sǝ wa a nggushi mǝrna niifa tal ka fiya, ma ɓǝlang ngganda fiya ɗǝ kahad.” ");
INSERT INTO hwo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Laɓarɗi thlǝkna Kayafa ya mbǝ yi altenggǝn ni wa. Tsaunǝn ndǝghǝn ni firis na manggǝn a sayidɗi, thlǝk nǝn ndaarha ɓana Yeeso mǝra ka Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mbǝ ka Yahudaya kee wa, amma ka a wumanggǝn ten wangya Faara ɓa heu welgha hu ƙǝshiirha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nanǝn kee ka a farɗi, ndǝn katǝrang na mamngya Yahudaya kaɗa kwamana a ɓǝllang ngganda Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsaunǝn kee, nggǝrwa Yeeso wiirha hai a pathlang Yahudaya a pǝpal wa. Mal Urshalima nǝn ɗǝgha a mbǝrha ɗǝ tsau tǝ kaheerha fa, ahu tala na nda aarha Ifraimu, tsauka a mbǝɗi tǝ fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nanǝnya nduwus far wutsǝfayid Tǝɗaarha ɓa yi Yahudaya, fiya hangga ahu chehwedɗi kahad ˈwanda teena ɗǝnda Urshalima ɗǝ ɓeena hangga kapa na far wutsǝfayidɗi ɓaarha ɓa ka a tsaɓang ngganda alten ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na nda a kaɗa Yeeso, kanda ƙǝƙǝt ahu Ƙǝn Faara na nda a tsahang mee ndan, “Ƙǝla wun hai ƙǝn? Mbǝ a ɓaarha hu wutsǝfayidɗa ɓa wa?” ");
INSERT INTO hwo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nanǝnya mamnda firistaya tǝ Farisaya pǝrang ndan fiya tǝ ndaarha, kala niifa nagha Yeeso, pǝrghǝnǝn, tǝna nda ƙǝsang nda. ");
INSERT INTO hwo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Takhƙǝn ɓeena mikki a ǝna Wutsǝfayid Tǝɗaarha nda, ɗǝgha Yeeso Mbetani ɗǝ tsauka a minda ki Liyadzuru, niifɗi thleng na Yeeso sǝ ahu mǝra. ");
INSERT INTO hwo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Fughang ngganda Yeeso sǝ. Marthla ndǝna a fǝr ǝnnarhami ɗǝ, Liyadzuru ƙǝm nǝghǝn ahur nafini hǝbgha ǝnnarhami tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tǝrgha Mairamu tǝranggǝn kwalaba urdi sǝ na sǝdghǝn mbǝnggǝn na tǝ wuɗǝɓǝla fa ǝna nanda tǝ ˈya na nda aarha nardi, iranggǝn a ƙǝsǝr sar Yeeso hai panggǝn ɗǝ tǝ was tenggǝn. Tǝrgha lǝghǝdgha hur mindǝɗi tǝ mbǝnda sǝd urdi ɗi. ");
INSERT INTO hwo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amma tal ahur fatshayighǝn na nda aarha Yahuda Iskaryoti, (na a fǝr Yeeso), ");
INSERT INTO hwo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ndǝghǝn, “Na urdi ɗi tǝ wuɗǝɓǝla fa kaan ya, sǝlɗǝ wuɗǝɓǝl rapathlaarha yi paara haru mahan. Kamɗǝ a hiigha ɗǝ, fǝrang wuɗǝɓǝlghǝnda fa yamiya.” ");
INSERT INTO hwo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Thlǝk nǝn palthɗi ya mbǝnana fa yamiya a haɗang fa wa, amma ngaara ni, nanǝn ndǝghǝn ni na a ƙǝs wuɗǝɓǝl ndan ha, nǝn naarha ngaara hasǝ ɗanggǝn altenggǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nggǝrangga Yeeso sǝ, ndanggǝn, “Malang, tǝnǝn ɗǝfang ɗǝ ka far panna. ");
INSERT INTO hwo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ƙǝtsar na fa yamiya naarha ahur nun, amma mbun naarha tǝ nggi ƙǝtsar wa.” ");
INSERT INTO hwo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wumna Yahudaya hai hangga sǝk nanda ndaarha ɗǝ Yeeso mbǝɗa ɗǝ, thlii nda heu ka ɗa nda naghǝn, mbǝ ndǝghǝn katenggǝn wa amma Liyadzuru thleng nǝn sǝ ahu mǝra. ");
INSERT INTO hwo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tǝrgha mamngya firistaya kaɗa kwaman ɓǝlla Liyadzuru nda ƙǝm, ");
INSERT INTO hwo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ƙǝsǝr ka ndǝghǝn ni Yahudaya hangga malgha kanda fǝrƙǝkafek nda tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɗalthna mbǝrha hai, fiya hangga wumngga Urshalima ɓa ka wutsǝfayid tǝɗaarha, sǝk ndaarha nda na Yeeso a kwamana ɓayi Urshalima ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nanǝn kee, kya shii temburu nda kya nda sǝ ɗa nda hwathlaghǝn fa tǝrang ngganda urad ndan sǝ na nda a ndaarha, “Falama Faara! Tǝ parka ni niifɗi ɓagha ɓa ahu thlǝm Chinǝm. Tǝ parka ni Kutǝr Isǝreela!” ");
INSERT INTO hwo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Walgha Yeeso wan kwaara tǝrgha ƙǝsǝrghǝn sǝ, ƙǝla chireethleng nanda hai, ");
INSERT INTO hwo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“A tǝrǝm ɗun wa nafiya Isǝreela. Ƙǝlama ɗǝ Kutǝr nun ɓayi taarha, a ƙǝsǝr wan kwaara.” ");
INSERT INTO hwo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A katǝradghǝn fatsahayighǝn sǝnangwa nda ǝnɗa hai ya wa. Amma akwasamadɗi manang nanda Yeeso, a ɗal teena nda hai ǝnɗi katǝragha hai ya ˈwan nda chireethla atenggǝn. Tǝ ƙǝm ǝnang ǝnɗa nda fa ya. ");
INSERT INTO hwo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Fiya wumngga hai na nda tǝ Yeeso a sayidɗi aah nǝn Liyadzuru a ten kwaarha, thleng nǝn sǝ ahu mǝrra, kanda ni na a pǝranggǝn fingya ɗǝ ǝnɗi ǝnana Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ndǝghǝnni ǝnagha ndǝn kyana fiya ɓa hangga ka hwathlaghǝn nda fa ƙǝsǝr ka ǝnwulteena ǝnanǝn. ");
INSERT INTO hwo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tǝrgha ndangga Farisayini ndan, “Mbǝ ˈya sǝ nǝm mbang ǝnaarha wa. Ƙǝlama hai, ƙǝshiirha heu ɗǝn nda ɗǝ a samadghǝn!” ");
INSERT INTO hwo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na nafiya Nggirkaya sǝ ahur nafini ɓagha ka tǝrang shilee Faara teena a far wutsǝfayid Tǝɗaarha ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɗǝnda thlǝmad Filibus ɗǝ, ɓagha ɓa a Mbatsaida na a chehweed Nggalili. Ndang ngganda, “Mbarkama, na minnan sǝ a nang yirha nan Yeeso fa.” ");
INSERT INTO hwo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ɗǝgha Filibus ka pǝranggǝn Andrawus ɗǝ. Tǝrgha kanda kyab ɗǝnda thlǝmad Yeeso ɗǝ pǝranggǝn nda. ");
INSERT INTO hwo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nggǝrangga Yeeso kanda sǝ ndǝghǝn, “Ɓad sayi ɓa nanǝnya na a manang ngganda Wan Niifa. ");
INSERT INTO hwo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Niya pǝrang ƙǝkafek kun, a hǝfang ngwanda wan hwaliirha hai mǝrgha wa, nǝn tsaurha katenggǝn. Amma a mǝrɗǝ nǝn fǝr wiiya hangga. ");
INSERT INTO hwo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Niifa na a nggǝm yiɓǝdghǝn nǝn a ƙǝɗeng nda, niifa ƙǝm kargha yiɓǝdghǝn hu ƙǝshidɗiya nǝn wal yibrha mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kala niifa na a ǝne taara, tǝta ni a mbu samadna nǝn, kala mbǝrha nani sǝ ndǝna mafadna naarha sǝ. Kala niifa na a ǝne taara, na Pǝpa a manang nda. ");
INSERT INTO hwo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nanǝnya na yiɓǝdna tǝ ɓillaarha, mani mbang ndaarha? Ndo a ndee ‘Pǝpa, hǝrye ahu sayi sǝsadɗiya?’ Amma ǝnɗa ni ɓani ɓa kamanggǝn ya! ");
INSERT INTO hwo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pǝpa, manang thlǝm wa!” Tǝrgha sǝk urarha nda hai a talara, tǝ ndaarha, “ˈWaɗi teena manang ɗi, niya nggǝr manang nda.” ");
INSERT INTO hwo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Fiya wumngga hai sǝkna nanda uradɗi, tamngga fingya ndaarha tǝrˈyaana ni, fingya ƙǝm a ndaarha tǝthlǝnda Faara ni a kalang sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tǝrgha ndagha Yeeso, “Uradɗi ya ɓanǝn ɓa ka kun ni, mbǝ ka nggi wa. ");
INSERT INTO hwo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nanǝnya sayi ni na a ngwang kumarha nda ƙǝshiirha, nanǝnya ƙǝm na nda a rǝk kutǝr ƙǝshidɗiya. ");
INSERT INTO hwo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nggi ƙǝm, a tǝren nda talara ɗǝ ma ƙǝshidɗiya, niya ndusang fiya thlǝmadna ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Thlǝk nǝn ndǝn kee ka a kyad kwaman mǝrrǝghǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ndangga fiya wumngga hai, “Ndangga Ɗeleewar Ngyahad nǝm ƙǝm na Ƙǝrǝsti a tsaurha pakwanɗǝ. Ƙama na ndaarha na Wan Niifa a mǝra? Wunni ‘Wan Niifɗi’ ˈwan?” ");
INSERT INTO hwo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tǝrgha nggǝrangga Yeeso kanda sǝ, “Na kukwaryirha narha tǝ kun yi sayi ngguchit kee. Weema hai ahu kukwaryidɗi ndǝghǝn ɓalɗǝ tǝ kun, amawana wula tsǝrha hai. Niifa na a wiirha hai ahu wula mbǝ sǝn mbǝɗi nǝn a ɗǝrha saɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Fǝrama ƙǝkafek tǝ kukwaryidɗi ndǝghǝn ɓalɗǝ tǝ kun, tǝnun tsaurha wangya kukwaryidɗi.” Akwasamadɗi thlǝk nǝn ǝnggini ya, wiigha Yeeso fayighǝn ɓǝɓenggǝn fadghǝn ma kanda. ");
INSERT INTO hwo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko nanǝn nǝn yakh ǝna ǝnwulteengya a yid ndan, ɓalgha nda kula fǝrƙǝkafek tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Katǝrana ǝnɗa hai ya ka a lǝɗang ngganda ˈya ndaana annabi Ishaya tǝ ndaarha, “Chinǝm, wun fǝrgha ƙǝkafek tǝ laɓar nǝm? Wunni pǝrang na Chinǝm sǝsǝmnggitghǝn?” ");
INSERT INTO hwo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndǝghǝn ɗani mbangwa nanda fǝrƙǝkafek ƙǝsǝr annabi Ishaya ˈwaɗǝ teena pǝr ɗa ndǝn tǝ ndaarha, ");
INSERT INTO hwo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kwamang Chinǝm yid ndan, tǝ ƙǝm tsang ɗǝ hur ndan kakrak, amawa nanda naa maana hai, tǝ ƙǝm sǝnang ngganda hai, ɓa nda thlǝmanna ɓa ƙǝnang nggi kanda.” ");
INSERT INTO hwo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Thlǝkna Ishaya palthɗi ya ƙǝsǝr naɗǝ mamnggitghǝn, ndǝn thlǝk nǝn ˈya a tenggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Fingya hangga ahur mamnggini fǝr nda ƙǝkafek tǝghǝn. Amma kanda a tǝrǝm thlǝkƙǝn a pǝpal, ƙǝsǝr amana Farisaya rǝk kanda ma ƙǝn tsahad Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kanda mindan sǝ a falgha fiya kanda ma yi Faara. ");
INSERT INTO hwo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tǝrgha tǝrangga Yeeso uradghǝn sǝ ndǝghǝn, “Kala niifa fǝrgha ƙǝkafek tǝ nggi mbǝ nggi kateenna fǝree nǝn ƙǝkafek wa, amma fǝr nǝn ƙǝkafek tǝ niifɗi thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kala niifa nagha nggi, naɗǝ niifɗi thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɓani ɓa ƙǝla kukwaryirha hu ƙǝshiirha, nanǝn kee kala niifa fǝrgha ƙǝkafek tǝ nggi mbǝ tam naarha hu wula wa. ");
INSERT INTO hwo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kala niifa sǝkka laɓarna ǝnawa taara sǝ wa, mbi ngwang kumarha wa. Ƙǝsǝr ɓayi ɓa ka ɓi ngwang kumarha ƙǝshiirha wa, amma a hǝrghang nggi. ");
INSERT INTO hwo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Amma kala niifa kargha nggi fa tǝ ƙǝm thlǝwa laɓar na fa wa, na niifa sǝ na a ngwang kumarha sǝ. Laɓar ɗi thlǝkni, ndǝna nda a ngwang kumarha sǝ, a far ngwala ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mbiyi a thlǝk ˈya tǝ sǝsǝmnda altenna wa, amma Chinɗi thlǝngga nggi ɓa ndǝn ndeegha thlǝk ǝnɗa ni niya thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sǝnɗisǝ a naɗi a ǝna taara tǝ ˈya ndanǝn nǝn ɓang yibrha ɓa mbuwa ngwalarha. Nanǝn kee, niyi a thlǝk kala ˈya ndeena Chinɗi.” ");
INSERT INTO hwo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kapa na wutsǝfayid Tǝɗadɗi ɓaarha ɓa, sǝn Yeeso sǝ sayid ɓenggǝn yi mal ƙǝshidɗiya wudgha thlǝmad Chin ɗǝ nduwus ɗaɓa. Nggǝm ɗǝ fatsahayighǝn ahu ƙǝshidɗiya, kyaɗang ɗǝ nggǝmnda kanda pakwanɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A sayidɗi na Yeeso tǝ fatsahayighǝn a hǝb ǝnnarhami a figrha, ˈwad Sheetan teena kyaɗǝ hur Yahuda Iskaryoti hai wan Siman ka a fǝr Yeeso nǝn. ");
INSERT INTO hwo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sǝn Yeeso sǝ Chinɗi fǝrang ɗǝ ǝngya heu ahu harghǝn hai, tǝ ƙǝm sǝnɗasǝ ɓaghǝn ɓa a thlǝmad Faara, nǝn a nggǝr wutta thlǝmad Faara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A sayidɗi na nanda a hǝb ǝnnarhami, thliigha Yeeso sǝ ƙǝɗanggǝn luwudghǝn hai na manggǝn ƙǝn ǝn pafarha nǝn mu. ");
INSERT INTO hwo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Irr aama nǝn ahu ndaro hai, katǝranggǝn tsaɓang nda sar fatsahayighǝn ɗǝ nagha pang nda saryi ndan ɗǝ tǝ ǝn pafadɗi ƙǝn nǝn a mughǝn. ");
INSERT INTO hwo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ɓana Yeeso thlǝmad Mbiturus ɓa, ndangga Mbiturus, “Chinǝm, Sa ni tsaɓang sarna ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nggǝrangga Yeeso sǝ, “Nanǝnya mba sǝnang ǝnɗa hai niya ǝnaarha ya wa, amma a mbee ɓa na sǝnggǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ndangga Mbiturus, “Sa, mba tam tsaɓang sarna ɗǝ wa.” Nggǝrangga Yeeso sǝ, “A tsaɓanggi sarwa ɗǝ wa, mba nggǝr tsaurha tǝtsahad na wa.” ");
INSERT INTO hwo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ndangga Siman Mbiturus, “Chinǝm, mbǝ sarna katenggǝn na tsaɓang ɗǝ wa, amma tsaɓee haryina ɗǝ tǝ tenna ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nggǝrangga Yeeso sǝ, “A ˈwad niifa teena fanɗǝ, chilɓi fadghǝn ɗǝ. Ɓalwa midghǝn sǝ fanda wa, ƙǝl a tsaɓanggǝn saryighǝn ɗǝ kee. Kun nuwun chahal, amma mbǝ kun heu wa.” ");
INSERT INTO hwo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ƙǝsǝr sǝnɗǝ niifɗi na a fǝrghǝn, ndǝn ndanǝn, “Mbǝ kun heu ni na chahal wa.” ");
INSERT INTO hwo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Akwasamadɗi ngwalang na Yeeso tsaɓang saryi ndan ɗǝ, kalang nggǝn luwudɗi na manggǝn tsauka hai. Tsahang mee nǝn kanda, “Sǝnɗun ǝnɗi ǝnani ya wa? ");
INSERT INTO hwo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nun aah nggi ‘Mala’ tǝ ƙǝm ‘Chinǝm,’ mǝmǝl ni, ƙǝsǝr ndǝghǝn ɗa nani. ");
INSERT INTO hwo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nanǝn kee, Nggini Chinǝm tǝ Tǝmalǝm ndǝnun tsaɓang ɗi saryi nun ɗǝ, kun ƙǝm kamɗǝ na a tsaɓang nggun sar ndan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Əna ni kee ƙǝsǝr kun ma a ǝnon ƙǝla ǝnang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Niya pǝrang ƙǝkafek kun, mafarha mbǝ kal turighǝn wa, tǝthlǝnda ƙǝm mbǝ kal niifɗi thlǝngga ndǝn ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nanǝnya hǝrǝm nun sǝn ǝnggini ya, a ǝna ɗun taara sǝ nun wal parka. ");
INSERT INTO hwo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mbǝ aten nun heu niya thlǝk laɓarɗi ya wa, sǝnɗi fingya yini wurni hasǝ. Amma tǝtani a lǝghǝdgha laɓar Faara ndaagha; ‘Yanɗi na a hǝb yadna kyakhree ɗa fa ɓa.’ ");
INSERT INTO hwo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Niya pǝranggǝn kun nanǝnya kapa nǝn katǝrarha hai, a katǝra ɗa hai nun a fǝrƙǝkafek tǝ ndaarha nggini Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Niya pǝrang ƙǝkafek kun, kala niifa thlǝgha yanɗa fa thlǝnni ɗǝ thlǝnǝn nggi fa; tǝ ƙǝm kala niifa thlǝgha nggi fa thlǝnǝn niifɗa fa thlǝngga nggi ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Akwasamadɗi thlǝk nǝn palthɗiya, ɓillaɗǝ Yeeso fa kaan ahurghǝn ndǝghǝn, “Niya pǝrang ƙǝkafek kun, niifa tal ahur nun nǝn a fǝr nggi.” ");
INSERT INTO hwo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tǝrgha nagha fatsahayini a ƙǝlang ndan, wulgha tendan tǝ wunni nǝn a thlǝkrha. ");
INSERT INTO hwo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tal ahur fatsahayini nggǝmna Yeeso tsau a thlǝmadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tǝrgha ndangga Siman Mbiturus yanɗi nggǝmna Yeeso kaan, “Tsahang mee wunni nǝn a thlǝk pathla a tenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nanǝn kee ndusangga tǝtsahadɗi Yeeso fa ndanggǝn, “Chinǝm, wunni niifɗi?” ");
INSERT INTO hwo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nggǝrangga Yeeso sǝ, “Yanɗi niya fǝrang kyad mburodi tawang ni hu aam kyakhna hai ndǝghǝnni.” Tawanggǝn kyad mburodi ahu aam kyakhna hai fǝranggǝnǝn Yahuda wan Siman Iskaryoti ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hǝrǝm na Yahuda thlǝ kyad mburodi ɗi kee, kyagha Sheetan ahurghǝn hai. Tǝrgha ndangga Yeeso Yahuda, “Ənɗi na midwa ǝnaarha, ǝnoghǝn wed.” ");
INSERT INTO hwo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amma ahur ndan mbǝ yanɗa sǝ sǝngga tǝmani ndang na Yeeso kee wa. ");
INSERT INTO hwo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tsaunǝn Yahuda ni tǝ panjakwa wuɗǝɓǝla ha, fingya ahur fatsahayini tamngganda ndaarha na Yeeso a ndang nda a ɗǝgha heng ǝnnarhami kanda ɓa ka wutsǝfayidɗi, nduwa a ɗǝgha fǝrang wuɗǝɓǝla fa yamiya. ");
INSERT INTO hwo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hǝrǝmna Yahuda thlǝ mburodi ɗi kee kyagha hai ƙǝkar a fǝɗikɗi. ");
INSERT INTO hwo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Akwasamadɗi wiina Yahuda ndagha Yeeso, “Ɓad sayi ɓa na Wan Niifa a ɗǝrha hu mamnggidghǝn ɗǝ, ƙǝsǝr a fadghǝn ni na nda a manang nda Faara. ");
INSERT INTO hwo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","A wal Faara mamnggirha a fadghǝn, Faara tǝ altenggǝn nǝn a fǝrang mamnggirha Wanɗi, tsu kee na Wanɗi a wal mamnggirha. ");
INSERT INTO hwo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kun wanggina, takhƙǝn sayi ngguchit kee niya tsaurha tǝ kun. Nun a kaɗa nggi, amma ƙǝla ndang ni mamngya Yahudaya, niya pǝranggǝn kun kee ƙǝm nanǝnya. Mbǝɗi niya ɗǝrha saɗǝ, mbun mbang ɗǝrha saɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Niya fǝrang weerǝnda ngyakhrha kun, nggǝmama ndan. Ƙǝla nggǝmni kun, tsauɗǝ tǝta a nggǝm ndan nun. ");
INSERT INTO hwo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","A naɗun a nggǝm ndan, na fiya heu sǝndasǝ fatsahayina ni kun.” ");
INSERT INTO hwo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tsahangga Siman Mbiturus mee, “Chinǝm, ɗǝna yaaɗǝ?” Nggǝrangga Yeeso sǝ, “Mbǝɗi niya ɗǝrha saɗǝ, mbun a mbu samadna nanǝnya wa, amma tsǝɓaku ndǝn nun a mbu samadna.” ");
INSERT INTO hwo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tsahangga Siman Mbiturus mee, “Chinǝm, mani mbuwa ni mbang mbu samad wa nanǝnya? Ngwaɗi fa a mǝri ka sa.” ");
INSERT INTO hwo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nggǝrangga Yeeso sǝ, “Na a mǝra ka nggi? Niya pǝro ƙǝkafek, kapa na kilngaara tǝtaarha na a ngaal sǝndǝna katǝra mahan.” ");
INSERT INTO hwo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ndangga Yeeso fatsahayighǝn, “A ɓillaɗun wa. Fǝrama ƙǝkafek a Faara, tǝ ƙǝm fǝrama ƙǝkafek a nggi. ");
INSERT INTO hwo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A wuri ki Pǝpa na ƙǝngya sǝ hangga. A mbǝ nanǝn kee wa, kam pǝrang ɗi ndǝn kun. Niya ɗǝrha mbǝɗa ɗǝ ka ɗi tansang mbǝrha kun sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A ɗiɗi tangsang mbǝrha kun sǝ, niya wutta ɓa ɓi ɗǝrha tǝ kun thlǝmanna ɗǝ. Tǝnun tsaurha a mbǝɗi nani sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mbǝɗi niya ɗǝrha saɗǝ sǝnɗun kwamana.” ");
INSERT INTO hwo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ndangga Toma, “Chinǝm sǝngwan mbǝɗi na a ɗǝrha saɗǝ wa, ƙǝƙǝn nan sǝn kwamana?” ");
INSERT INTO hwo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ndangga Yeeso, “Nggini kwamanɗi, nggini ƙǝkafek ɗi, tǝ ƙǝm nggini yibǝdɗi. Mbǝ niifa sǝ na ɗǝrha thlǝmad Chin ɗaɗǝ wa ƙǝl tǝ thlǝmad na. ");
INSERT INTO hwo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","A sǝnɗun nggi, nun sǝn Pǝpa. Nanǝnya sǝnɗun ndǝn, tǝ ƙǝm naɗun ndǝn.” ");
INSERT INTO hwo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tǝrgha Filibus ndanggǝn, “Chinǝm kyaɗang Chinɗi kan, tǝna ten nan ɗathla.” ");
INSERT INTO hwo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nggǝrangga Yeeso sǝ, “Mǝnɗi ha tǝ kun, amma Filibus ɓalgha kula sǝn nggi? Kala niifa nagha nggi naɗǝ Chinɗi. Kama nda na tsahe mee, kyaɗang Chinɗi kan?” ");
INSERT INTO hwo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fǝrwa ƙǝkafek niyi hu Chinɗi, tǝ ƙǝm Chinɗi ahur na wa? Laɓarɗi niya pǝrang nda kun mbǝ laɓar altenna ni wa. Amma Chinɗa ni na a hurna, na a ǝna targhǝn. ");
INSERT INTO hwo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Fǝreema ƙǝkafek a nda ɗi niyi hu Chinɗi, Chinɗi ƙǝm ahur na. Nduwa ƙǝm fǝrama ƙǝkafek tǝ nggi a ten ǝnwulteengya nanun ǝnani. ");
INSERT INTO hwo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Niya pǝrang ƙǝkafek kun, kala niifa fǝrgha ƙǝkafek tǝ nggi nǝn a ǝna tur tarɗi ǝnani. Nun a ǝna ǝngya na mǝmanggǝn kalgha fingya yina mu ya, ƙǝsǝr niya ɗǝrha thlǝmad Chinɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kala ˈya hwan nun hu thlǝmna niya ǝnaghǝn, tǝna Chinɗi wal mamnggirha a fad Wanɗi. ");
INSERT INTO hwo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kala ˈya hwan nun ahu thlǝmna, niya ǝnanggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ana ɗun a nggǝm nggi, nun a ǝna taara tǝ ˈya pǝrang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Niya hwan Pǝpa, ndǝghǝn ƙǝm nǝn a nggǝr fǝrang Tǝthlaara kun na a tsaurha tǝ kun pakwanɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ndǝna Sǝsǝna yi ƙǝkafek. Mbǝ ƙǝshiirha a thlǝghǝn fa wa, ƙǝsǝr ˈwawa nda naghǝn wa nduwa sǝnggǝnda wa. Amma kun sǝnɗun ndǝn, ƙǝsǝr nǝghǝn tǝ kun tǝ ƙǝm nǝn narha tǝ kun. ");
INSERT INTO hwo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mbiya mal kun ƙǝla wumirya wa, niya ɓarha thlǝmad nun ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A mbee shedɗa ɓalwa ƙǝshiirha nggǝr na nggi wa, amma kun nun a na nggi. Nanǝn niyi tǝ yibrha kun ƙǝm nun a tsaurha tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A farɗi nun a sǝndasǝ niyi ahur Pǝpa, kun ƙǝm ahur na, nggi ahur nun. ");
INSERT INTO hwo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nafiya sǝkka ˈya ndani ǝna taara nda sǝ, kanda ni nggǝmngga nggi. Nafiya nggǝmngga nggi, na Pǝpa a nggǝm kanda, nggi ƙǝm niya nggǝm kanda, kyaɗang fanna ni kanda.” ");
INSERT INTO hwo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tǝrgha Yahuda (Mbǝ Yahuda Iskaryoti wa) ndǝghǝn, “Chinǝm, kama na kyad fadwa a kan kee mbǝ a ƙǝshiirha kahad wa?” ");
INSERT INTO hwo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nggǝrangga Yeeso sǝ, “Nafiya nggǝmngga nggi, ǝna taara nda tǝ ˈya ndani. Na Pǝpa a nggǝm kanda, niya ɓaarha thlǝmad ndan ɓa tsawi tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yi nggǝm ngwa nggi mbǝ a ǝna taara tǝ ˈya ndani wa. Laɓarɗi sǝk nun ya mbǝ nggi thlǝkka ndǝn wa, amma yi Pǝpa ni thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Pǝrang ni ǝnggini kun ya nggi ɓalɗǝ tǝ kun. ");
INSERT INTO hwo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amma tǝthlaara, na Sǝsǝna tǝ Peɗǝnda, na Pǝpa a thlǝnang ɓa ahu thlǝm na, nǝn a tsahang ǝngya kun ha heu, ɗalang ǝnggina nǝn kun in pǝrang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mal ɗi kun tǝ ɗǝɗemnggirha. Ɗǝɗemnggid na ni fǝrang ni kun. Fǝrang ni ndǝn kun mbǝ ƙǝla na ƙǝshiirha fǝra wa. A ɓillaɗun wa tǝ ƙǝm a tǝrǝm ɗun wa. ");
INSERT INTO hwo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Sǝk ɗun ˈya ndaani, ‘Niya wiirha tǝ ƙǝm niya nggǝr wutta thlǝmad nun ɓa.’ A nggǝm ɗun nggi, nun a ǝna wutsǝfayirha ƙǝsǝr niya ɗǝrha thlǝmad Chin ɗaɗǝ, ƙǝsǝr Chin ɗi kalɗǝ nggi mu. ");
INSERT INTO hwo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pǝrang ni ndǝn kun nanǝnya kapa nǝn katǝrarha hai, ƙǝsǝr a katǝra ɗa hai nun a fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mbiya nggǝr kalang kun sǝ hangga wa, ƙǝsǝr kutǝr ƙǝshidɗiya nǝghǝn ɓaghai, mbǝ ˈya sǝ nǝn mbang ǝnaarha a tenna wa. ");
INSERT INTO hwo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amma niyi a ǝna ˈya ndeena pǝpa, tǝna ƙǝshiirha sǝndasǝ nggǝm ɗi Chinɗi. Thlema sǝ tama wiim ma mbǝɗiya.” ");
INSERT INTO hwo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ɗǝgha Yeeso mbeeɗǝ tǝ ndang nda fatshayighǝn, “Nggini ka ɗǝf inabiɗi, Pǝpa ndǝna tǝhedɗi. ");
INSERT INTO hwo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kala wuhwaara mbuwa nggǝtta, na Pǝpa a kyathlang ɗǝ. Amma kala wuhwaara na a nggǝtta, na Pǝpa a tansang, tǝnǝn nggǝr chik nggǝtta kaan. ");
INSERT INTO hwo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ˈWanda teena tangsang nda kun tsauɗun chahal ƙǝsǝr ka laɓarɗi pǝrang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tsawama ahur na, nggi ƙǝm niya tsaurha ahur nun. Ƙǝla mbuwa na wuhwara mbang nggǝtta katenggǝn, ƙǝl a naɗǝ a fad kulghǝn. Kun ƙǝm nuwun kee, mbun mbang ǝna ˈya ngga wa ƙǝl a naɗun ahur na. ");
INSERT INTO hwo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nggini ɗǝf inabi, kun ni wuhwarya. Ana niifa ahur na, niya naarha ahurghǝn, nǝn a nggǝt wan ɗǝfya hangga. Amma a mbǝ tǝ nggi wa, mbǝ mbang ǝna ˈya wa. ");
INSERT INTO hwo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A mbǝ niifa ahur na wa, nǝghǝn ƙǝla wuhwar ɗǝfrha kudmang na nda ɗǝ hwargha, ɓagha fiya ɓa wumang ngganda hwaridghǝn, muwangga nda hu wadɗǝ, djang ngganda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Amma anaɗun ahur na, laɓar na ƙǝm ahur nun, nun hwan kala ˈya na minnun, na nda a fǝranggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ana ɗun a fǝr wan ɗǝfya hangga, na Pǝpa wal mamnggirha, nǝn a kyad ndaarha kun fatsahayina ni. ");
INSERT INTO hwo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nggǝmɗi kun ƙǝla nggǝmna Pǝpa nggi. Nanǝn kee tsawama a ten nggǝmndǝ ɗi kyaɗang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A ƙǝsɗun laɓarna ha, nun a tsaurhahu nggǝm ndǝna, ƙǝla ƙǝs ni laɓar ɗa ha pǝree na Pǝpa, tsauɗi ƙǝm ahu nggǝm ndǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Pǝrang ni ǝnggina kun ya tǝ nun wal tur wutsǝfayid na, wutsǝfayid nun ƙǝm tsauka lǝlǝgɗa. ");
INSERT INTO hwo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kulo ˈya ndang ni kun ya, nggǝmama ndan ƙǝla nggǝmni kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mbǝ nggǝmnda sǝ kalgha yanɗiya wa, na a fǝrgha niifa yiɓǝdghǝn ka pashiyighǝn. ");
INSERT INTO hwo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pashiyina ni kun, ana ɗun a ǝna ǝnɗi pǝrang ni kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ɓalwi nggǝr aah kun mafayina wa, ƙǝsǝr mafarha sǝngwa ˈya na turighǝn a ǝnaarha wa. Ameyedghǝn, niya aah kun pashiyina ƙǝsǝr pǝrang ɗi ǝngya kun heu pǝree na Pǝpa. ");
INSERT INTO hwo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mbǝ kun wurgha nggi wa, nggi ndǝn wurgha kun, ndanggi kun ɗaamaɗǝ ɗun fǝr wan ɗǝfya hangga na tsaurha pakwanɗǝ. Tǝrgha kala ˈya hwanang nun Pǝpa hu thlǝmna nǝn a fǝranggǝn kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kulo ˈya ndang ni kun ya, nggǝmama ndan. ");
INSERT INTO hwo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“A tsan ƙǝshiirha kun, a sǝnunsǝ tsanɗǝ nggi kapa nǝn tsan kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Andam kun yi ƙǝshiid ɗa ni ya, kam nggǝm ƙǝshiirha ǝnggǝn. Amma tsaunǝn mbǝ yi ƙǝshidɗa ni kun ya wa, wur yi kun sǝ hu ƙǝshiirha, ndǝghǝnni tsanna ƙǝshiirha kun. ");
INSERT INTO hwo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɗalama teena hai tǝ pathla ndang ni kun, mbǝ mafarha kal turighǝn wa. A sǝsenda, kun ƙǝm na nda a sǝsang kun. Andam ǝnanda taara tǝ ˈya ndang ni kanda, kam ǝnanda taara tǝ ˈya pǝrang nun kanda ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na nda a ǝnang tur ǝnggina kun fa heu ya ƙǝsǝr ka thlǝmna, ƙǝsǝr sǝngwanda niifɗi thlǝngga nggi ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Andam ɓawi ɓa ɓi kalang kanda sǝ wa, kam mbǝ ɗimiyirha sǝ a fad ndan wa. Amma nanǝnya, mba nda fǝlmee aten ɗimiyindan wa. ");
INSERT INTO hwo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kala niifa tsangga nggi, tsan nǝn Pǝpa ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ənaɗi ǝngya hangga ahur ndan ˈwawana niifa ǝnaarha. Andam ǝnawi ǝnggini ya wa, kam mbǝ ɗimiyirha sǝ a fad ndan wa. Amma nanǝnya nanda ǝnggini ǝnani, ko nanǝn kee tsan nda nggi tǝ Pǝpa ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lǝghǝd laɓarɗi na chichireethlee hai ahu ngyahad ndan, ndanǝn, ‘Tsan nda nggi fa, kula nggi ǝna ˈya ɗimi.’ ");
INSERT INTO hwo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Amma a ɓa tǝthlaara ɓa, Sǝsǝna na a tsahang ƙǝkafekkid laɓar Faara kun ha, niya thlǝnang nda kun ɓa aki Pǝpa, nǝn a pǝr ˈya heu a tenna. ");
INSERT INTO hwo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kun ƙǝm nun a pǝranggǝn fingya ǝnggini ǝnani ƙǝsǝr ka a katǝradghǝn nuwun tǝ nggi. ");
INSERT INTO hwo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Pǝrang ni ǝnggini kun ya amawa nun kyathla hai ma ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Na nda a rǝk kun ahu ƙǝngya tsahad Yahudaya. Mbǝ ngaala sǝ wa, na sayi ɓayi kala niifa ɓǝlangga kun nǝn a numad ndaarha tar Faara nǝn a ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na nda a ǝna ǝngginiya, ƙǝsǝr sǝngwanda Chin ɗi nduwa nggi wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pǝrang ni ǝnggini kun ya, a tsǝ sayi hai, nun a ɗal teena hai tǝ ndaarha ˈwaɗi pǝranggǝn kun. Pǝrang ngwi ǝnggini kun ya ka a katǝradghǝn wa ƙǝsǝr ɓal yi tǝ kun. ");
INSERT INTO hwo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Amma nanǝnya niya wiirha a thlǝma niifɗa ɗǝ thlǝngga nggi ɓa, mbǝ niifa sǝ ahur nun tsahegha mee ɗini yaaɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ƙǝsǝr ka pǝrang ni ǝnggini kun ya ndǝn lǝghǝdna hur nun tǝ sǝbrha hura. ");
INSERT INTO hwo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Amma niya pǝrang ƙǝkafek kun, nǝn a tsaurha ngga a fad nun a wiiɗi. Ƙǝsǝr a wii yi wa mbǝ tǝthlaara a ɓaarha ɓa wa, ƙǝl a wii ɗi. Amma a wiiɗi, niya thlǝnanggǝn kun ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A ɓaɗa ɓa, nǝn a kyaɗang ƙǝkafekkirha nafiya ƙǝshidɗiya aten ɗimiyirha, nggayirha tǝ ngwa kumarha. ");
INSERT INTO hwo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aten ɗimiyirha, ƙǝsǝr kar nda fǝrƙǝkafek tǝ nggi. ");
INSERT INTO hwo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aten nggayirha, ƙǝsǝr niya wiirha thlǝmad Chinɗa ɗǝ, mbun a nggǝr na nggi ɓalwa. ");
INSERT INTO hwo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aten ngwa kumarha, ƙǝsǝr ˈwad Faara teena ngwang ɗǝ kumarha kutǝr ƙǝshidɗiya. ");
INSERT INTO hwo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na ǝngya sǝ hangga na minna pǝrang nda kun, amma mbun mbang ƙǝsghǝn ha nanǝnya wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A ɓad Sǝsǝn ƙǝkafek ɓa, nǝn a kyaɗang kwaman ƙǝkafek kun heu. Ƙǝsǝr mbǝ laɓar altenggǝn nǝn a pǝrang kun wa, amma nǝn a pǝr ˈya sǝk nǝn, tǝ ƙǝm nǝn a pǝrang ˈya kun ɓalgha ɓayi. ");
INSERT INTO hwo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nǝn a fǝree mamnggirha, ƙǝsǝr nǝn tǝrang ˈya thlǝk ni Pǝranggǝnǝn kun. ");
INSERT INTO hwo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kala ˈya tsauka yi Pǝpa yina ni. Ndǝghǝn ɗa ndani, na Sǝsǝna a pǝrang ˈya ndani kun ndani. ");
INSERT INTO hwo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Akwasamad sayi ngguchit mbun a nggǝr na nggi wa, akwasamad sayi ngguchit ƙǝm nun a nggǝr na nggi.” ");
INSERT INTO hwo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fingya fatsahayighǝn ndang ngganda ndan, “Mana midghǝn ndaarha ndang nǝn ƙǝm, ‘Akwasamad sayi ngguchit mbun a na nggi wa, akwasamad sayi ngguchit ƙǝm nun a nggǝr na nggi’? Tǝ ƙǝm ndǝghǝn, ‘Niya ɗǝrha thlǝmad Chinɗa ɗǝ’?” ");
INSERT INTO hwo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɗǝnda mbeeɗǝ tǝ tsakh mee, “Ma nǝn a ndaarha ‘Akwasamad sayi ngguchit’? Sǝnanggǝm ǝnɗa hai nǝn a thlǝkrha ya wa.” ");
INSERT INTO hwo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sǝnangga Yeeso hai na mindan sǝ tsahang mee aten laɓarɗi thlǝk nǝn, ndanggǝn kanda, “Nuwun a tsahang mee ndan ha aten laɓarɗi ndaani, ‘Akwasamad sayi ngguchit mbun a na nggi wa, tǝ ƙǝm Akwasamad sayi ngguchit nun a nggǝr na nggi’? ");
INSERT INTO hwo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Niya pǝrang ƙǝkafek kun, nun a tǝrha tǝ sǝbrha hura, ƙǝshiirha ƙǝm nǝn a ǝna wutsǝfayirha. Na hur nun a sǝbrha ɗǝ, amma na sǝbrha hur nun a tsaurha ǝn wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ana nuneefa a nggǝtta hai nǝn tǝk hatta fa kaan, ƙǝsǝr ɓad sayid nggǝttǝghǝn ɓa. Amma a nggǝɗang ɗǝ wufar wee hai, na hatta nggǝttǝɗi mbǝɗang nda, ƙǝsǝr ka wutsǝfayirha nggǝdɗǝ wufar wee hu ƙǝshiirha hai. ");
INSERT INTO hwo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nǝn a tsaurha kee tǝ kun. Nanǝnya sayid sǝbrha hur nun ni, amma niya nggǝr na kun, nun a tsaurha tǝ wutsǝfayirha fa, mbǝ niifa sǝ na thlang wutsǝfayid nun hai wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A farɗi mbun a nggǝr tsahe ˈya wa. Niya pǝrang ƙǝkafek kun, na Pǝpa a fǝrang kala ˈya kun hwanang nun hu thlǝmna. ");
INSERT INTO hwo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pa ka weeriya ˈwawun tsakh ˈya tǝ thlǝmna wa. Hwanama nun a waala, tǝna wutsǝfayid nun lǝghǝtta. ");
INSERT INTO hwo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Thlǝkki ǝngginiya tǝ karapuya. Amma na sayi ɓayi niya nggǝr kalang kun sǝ a pǝpal a ten Pǝpa, mbiya nggǝr thlǝk karapu wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A farɗi nun a hwan ǝngya ahu thlǝmna. Mbǝ nggi ni a nggǝr hwan Pǝpa a meyed nun wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chinɗi tafadghǝn nǝghǝn a nggǝm kun, ƙǝsǝr nggǝmɗun nggi tǝ ƙǝm fǝr ɗun ƙǝkafek tǝ ndaarha ɓayi ɓa a thlǝmad Faara. ");
INSERT INTO hwo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɓayi ɓa a thlǝmad Chinɗi ahu ƙǝshiid ɗaɓa ya, nanǝnya niya mal ƙǝshidɗiya wuɗi thlǝmad Chinɗa ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tǝrgha ndagha fatsahayighǝn, “Yauwa! Nanǝnya na a tsǝ laɓaara a pǝpal mbǝ tǝ karapu wa. ");
INSERT INTO hwo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nanǝnya sǝnɗansǝ sǝnna ǝngya heu. Kamngwa a nggǝrgha niifa tsaho mee ha wa. Ndǝghǝn ɗani fǝr nan ƙǝkafek tǝ ndaarha ɓagha ɓa a thlǝmad Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nggǝrangga Yeeso kanda sǝ, “Fǝr ɗun ƙǝkafek nanǝnya wa? ");
INSERT INTO hwo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Amma na farghǝn ɓayi, nanǝnya ma ɓaɗa ɓa, nun a weela hai, kowunni nǝn a ɗaarha wuri keeghǝn ɗǝ. Nun a mal nggi katenna. Amma mbiyi katenna wa, ƙǝsǝr nagha Pǝpa a thlǝmanna. ");
INSERT INTO hwo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Pǝrang ni ǝnggini kun heu ya tǝnun wal ɗǝɗemnggirha ahur nun. Nun a sǝsaarha kaan ahu ƙǝshiid ɗiya. Amma ˈwaɗi teena kal ɗi ƙǝshiirha mu.” ");
INSERT INTO hwo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Akwasamadɗi ngwalang na Yeeso thlǝk ǝnɗiya, ƙǝlagha talara sǝ hwan Faara nǝn ndǝghǝn, “Pǝpa ɓad sayi ɓa na a manang nda Wanɗi, wanɗi ƙǝm manoghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ƙǝsǝr fǝrang na sǝsǝmnda aten kowunni, tǝnǝn fǝr yibrha mbuwa ngwalarha a nafini fǝrang na. ");
INSERT INTO hwo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kwaman ɗa na yi wal yibrha sǝ mbuwa ngwalarha ya, a sǝn sa nan, Faara yi ƙǝkafek, tǝ Yeeso Ƙǝrǝsti thlǝnang na hu ƙǝshiirha ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Manang ɗi thlǝmwa hu ƙǝshiirha, tǝ ngwalang nda tarɗi fǝree na a ǝne. ");
INSERT INTO hwo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nanǝnya, Pǝpa, mane a mbed wa tǝ tur mamnggidɗi nani tǝghǝn kapa na nda ǝna ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ˈWaɗi teena kalɗi mee atenwa a nafini fǝree na ahu ƙǝshidɗiya. Nafiwa ni, fǝrenna kanda ǝnanda taara tǝ palth wa. ");
INSERT INTO hwo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nanǝnya sǝndasǝ kala ˈya nani tǝghǝn ha kyaghǝn ɓa a haar wa, ");
INSERT INTO hwo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ƙǝsǝr laɓarɗi pǝree nana pǝrang ɗi ndǝn kanda. Thlǝn ndan, tǝ ƙǝm sǝndasǝ ɓayi ɓa a thlǝmad wa, fǝr nda ƙǝkafek sa thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Niyi a hwanda ka kanda, mbiyi a hwanda a ƙǝshidɗiya wa, amma a nafini fǝree nana ƙǝsǝr nafiwa ni. ");
INSERT INTO hwo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kala ˈya nani tǝghǝn yiwa ni, tǝ ƙǝm kala ˈya nana tǝghǝn ha yina ni, ni wal mamnggirha a fad ndan ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nanǝnya ɓalwa tsawud na sǝ hu ƙǝshiirha wa, amma na nda ahu ƙǝshidɗiya, nggi ƙǝm niya ɗǝrha thlǝmad wa ɗǝ. Pǝpa tǝ Peɗǝnda, lafu kanda tǝ sǝsǝmnda thlǝmwa, thlǝmɗi fǝree nana, tǝna nda tsaurha tal ƙǝla nanǝm tal. ");
INSERT INTO hwo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A sayidɗi nani tǝ kanda, lafɗi kanda tǝ sǝsǝmnda thlǝmwa, thlǝm ɗi fǝree nana. Ƙǝlaɗi kanda ha, tǝ ƙǝm mbusǝ sahadgha wa ƙǝl tal ahur ndan kee, ƙǝl yanɗi wurgha fadghǝn a sahadgha. Sahad nǝn ka a lǝghǝdgha laɓar Faara na chichirethlee hai. ");
INSERT INTO hwo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nanǝnya niya ɗǝrha thlǝmad wa ɗǝ. Amma thlǝk ni ǝngginiya nggi ɓalɗǝ ahu ƙǝshiirha tǝna nda wal wutsǝfayirha lǝlǝgɗa ahur ndan ƙǝla nani tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Fǝrangɗi laɓar wa kanda ƙǝshiirha ƙǝm karɗǝ kanda fa, ƙǝsǝr mbǝ yi ƙǝshiirha ni kanda wa, ƙǝla nani mbǝ yi ƙǝshiirha ni nggi wa. ");
INSERT INTO hwo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mbi a hwan sa a tǝrangga kanda ma ƙǝshiirha wa, amma ndǝghang kanda hai tǝ tǝmbǝlfedɗi. ");
INSERT INTO hwo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kanda mbǝ yi ƙǝshidɗa ni ya wa, ƙǝla nani mbǝ yi ƙǝshidɗa ni ya wa. ");
INSERT INTO hwo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tsawang kanda chahal tǝ ƙǝkafekkid wa, ƙǝsǝr laɓar wa ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ƙǝla thlǝnna nggi hu ƙǝshiirha ɓa, thlǝnɗi kanda ƙǝm ahu ƙǝshiirha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ƙǝsǝr fǝr ɗi fanna ƙǝla ǝn sataka ƙǝsǝr ka kanda, tǝna nda naarha chahal hu ƙǝkafekkid wa. ");
INSERT INTO hwo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mbiyi a hwanda ka kanda kee wa, amma a fingya heu fǝrgha ƙǝkafek tǝ nggi hu laɓar ndan. ");
INSERT INTO hwo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pǝpa niya hwanda a tendan heu a tsawa nda tal, ƙǝla nana ahur na nggi ƙǝm ahur wa. Ngwa tsawa nda tal ahur nǝm tǝna ƙǝshiirha fǝrƙǝkafek sa ni thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Fǝrangɗi mamnggidɗi kanda fǝree nana, tǝna nda tsaurha tal ƙǝla nanǝm tal. ");
INSERT INTO hwo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Niya naarha ahur ndan, sa ƙǝm ahur na, tǝna nda tsaurha tal kula ǝn ˈyaara fa, tǝna ƙǝshiirha sǝndasǝ sa ni thlǝngga nggi ɓa tǝ ƙǝm nggǝmna kanda ƙǝla nggǝmna nggi. ");
INSERT INTO hwo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pǝpa, na minnasǝ nafini fǝree na ya, a na nda a thlǝmanna a mbǝɗi nanisǝ, tǝna nda naa mamnggidɗi fǝree nana, ƙǝsǝr nggǝmna nggi kapa na nda ǝna ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pǝpa na tǝ nggayirha, ko nanǝn sǝngwa ƙǝshiirha sa wa, amma sǝnɗi sa; nafini ya ƙǝm sǝndasǝ sa ni thlǝngga nggi ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kyaɗang ɗi sa kanda ƙǝla nana, niya naarha pǝranggǝn kanda. Tǝna nggǝmndǝɗi nggǝmna nggi naarha tǝ kanda tǝ ƙǝm nee ahur ndan.” ");
INSERT INTO hwo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","A kwasamadɗi ngwalang na Yeeso hwan Faarɗi, mal Urshalima nǝn tǝɗanggǝn suhwad Kidron teena heu tǝ fatsahayighǝn. A pǝm suhwadɗi na hed ɗǝfya dzaitun sǝ, kyagha sahai tǝ fatsahayighǝn. ");
INSERT INTO hwo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda fǝrgha ndǝn ƙǝm sǝnɗǝ mbǝɗi, ƙǝsǝr na Yeeso yakh naarha wumnda hai tǝ fatsahayighǝn a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nanǝn kee, ɗǝgha Yahuda ahu hedɗa ɗǝ tǝ sodjaya a samadghǝn, tǝ fa ƙǝla Ƙǝn Faara, thlǝnang na mamngya Firis ɓa tǝ Farisaya. Ƙǝs nda patilla ha, tǝ tochi, tǝ kari yanda. ");
INSERT INTO hwo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ˈWad Yeeso teena sǝnɗǝ ǝnɗi ɗǝgha katǝrarha hai tǝghǝn, kyagha pǝpal ɓa tsahang mee nǝn kanda, “Wun nun a kaɗaarha?” ");
INSERT INTO hwo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nggǝrang ngganda sǝ, “Yeeso Tǝ Nadzarat.” Ndangga Yeeso kanda, “Nggini ndǝghǝn.” Yahuda tǝthlǝrɓu ɗi ƙǝt a pathlang ndan. ");
INSERT INTO hwo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A sayidɗi ndana Yeeso, “Nggini ndǝghǝn,” wuɗa nda samarǝn, samarǝn fǝla nda hweeɗe hai. ");
INSERT INTO hwo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nggǝrghǝn tsahang mee kanda, “Wun nun a kaɗaarha?” Ndang ngganda, “Yeeso Tǝnadzarat.” ");
INSERT INTO hwo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ndangga Yeeso kanda, “Ndanggi kun nggini ndǝghǝn. Ana nggi nun a kaɗaarha, malaman nafiniya wii nda.” ");
INSERT INTO hwo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Katǝra nǝn hai kee ka a lǝɗanggǝn laɓar ɗi ndanǝn, “A hur nafini fǝree na mbusǝ ƙǝɗeng ni wa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tǝrgha Siman Mbiturus ƙǝɗanggǝn thlaukh ƙǝlarghǝn sǝ kyathlanggǝn thlǝmad mafad Firis ɗǝ na manggǝn a yi sǝma. (Thlǝm mafadɗiya Malkus). ");
INSERT INTO hwo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Amma ndangga Yeeso Mbiturus, “Wuɗang thlaukh ƙǝlar ɗi hu ƙǝnggǝn hai. Mbuwani mbang saarha tǝ wuhuleu sǝsaarha fǝree na Pǝpa wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tǝrgha Sodja yini, tǝ mamndǝ ndan tǝ fa ƙǝla Ƙǝn Faara ƙǝsang ngganda Yeeso ƙǝnang ngganda. ");
INSERT INTO hwo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ˈWa ɗǝrha nda tǝghǝn thlǝmad Hanana ɗǝ, ƙǝsǝr thlaɓǝr Kayafa ni na manda firis a sayidɗi. ");
INSERT INTO hwo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ndǝn ndangga fingya mamngya Yahudaya, mǝmǝl ni a mǝrgha niifa tal ka fingya fiya. ");
INSERT INTO hwo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tǝrgha Siman Mbiturus mbu samad Yeeso nǝn, niifa tal ahur fatsahayighǝn ƙǝm mbu samad Yeeso nǝn. Tǝtsahad ɗi ƙi Yeeso ya sǝn firis ndǝn na manggǝn, ndǝghǝnggi ƙǝm kyagha hu chelleeru firis ɗǝ na manggǝn tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amma Mbiturus ishgha hai a kwakirma. Tahad tǝtsahad ɗi sǝnna firis ndǝn na manggǝn, wudgha, kalanggǝn nuɗa sǝ na a ƙǝla kwakirma ha, a kyagha hai tǝ Mbiturus. ");
INSERT INTO hwo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nuɗi na a mii kwakirma ndanggǝn Mbiturus, “Sa mbǝna tal ahur fatsahayighǝn wa?” Ndangga Mbiturus, “Awo, mbǝ nggini wa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ƙǝsǝr na mbiirha sǝ, mafaya hur minda tǝ faƙǝlaya ha kanda a tǝk waarha fa. Mbiturus ƙǝm a thlǝman ndan a tǝk waarha fa. ");
INSERT INTO hwo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tǝrgha firis na manggǝn tsahang mee nǝn Yeeso aten fatsahayighǝn tǝ tsahadghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nggǝrangga Yeeso sǝ, “Thlǝkki laɓaara a ƙǝshiirha a pǝpal. Ni naarha tsaharha ha hu ƙǝn tsahad Yahudaya, tǝ Ƙǝn Faara nǝm yakh wumnda sahai. Mbǝ ˈyasǝ thlǝk ni ɓǝɓee wa. ");
INSERT INTO hwo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kama nda na a tsahe mee ha? Tsahang mee fingya sǝkka fanna. Sǝnda ˈya ndani.” ");
INSERT INTO hwo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ndana Yeeso kee, tal ahur mamnggini na tsau tǝghǝn fa mbi Yeeso nen, ndanggǝn, “Na nggǝrang nda firis sǝ na manggǝn kiya wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ndangga Yeeso, “Ana ˈyasǝ thlǝk ni na ɗimi puruwun. Amma ana ƙǝkafek thlǝk ni, kama mbina nggi?” ");
INSERT INTO hwo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tǝrgha Hanana thlǝnanggǝn Yeeso a thlǝmad Kayafa ɗǝ na mamnda firis ƙǝƙǝna. ");
INSERT INTO hwo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nana Mbiturus ƙǝt a tǝk waarha fa, tsahang mee nda, “Sa mbǝna tal ahur fatsahayighǝn wa?” Ngalgha Mbiturus ndǝghǝn, “Awo mbiyi ahur ndan wa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tal ahur mafaya manda firis na hurfidghǝn ni niifɗi kyathlang na Mbiturus thlǝmadghǝn ɗǝ, tsahang mee nǝn Mbiturus, “Mbǝ naɗi kun tǝghǝn ahu hed dzaitun wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nggǝrgha Mbiturus ngaalghǝn. Tsu kee tǝtaagha ɗiyarha. ");
INSERT INTO hwo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","A tsar kyang na nda Yeeso sǝ a minda ki Kayafa ɗǝnda tǝghǝn minda ki Mbilatus ɗǝ ngwamnad Romaya. Kyawa nda tǝghǝn a minda ki ngwamna ɗa hai wa. Na mindan sǝ a tangsang ngganda fad ndan chahal tǝna nda hǝb ǝnnadmid tǝɗaarha. ");
INSERT INTO hwo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nanǝn kee kyagha Mbilatus thlǝmad ndan ɓa tsakh mee nǝn, “Ma ǝnana kamshi ɗiya huhwa nun ndǝn?” ");
INSERT INTO hwo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nggǝrang ngganda sǝ, “A ǝna wa kamshiɗi ˈya mbuwa ngga ya wa, kam ɓowan ndǝn ɓa wa!” ");
INSERT INTO hwo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ndangga Mbilatus kanda, “Ɗaama ɗǝ tǝghǝn ɗun ngwang kumarha tafad nun tǝ yinun ngyakhrha.” Nggǝrangga Yahudaya sǝ, “Ai, fǝrang ngwanda sǝsǝmnda kan na a ɓǝlanggan niifa wa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Katǝrana ǝnɗa hai ya ka a lǝɗang ngganda laɓarɗi ki Yeeso sakh nǝn tǝ kwaman mǝrrǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tǝrgha Mbilatus nggǝrgha hur minda hai, aah Yeeso nǝn ɗǝ tsahang mee nǝn, “Sani kutǝr Yahudaya wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nggǝrangga Yeeso sǝ, “Tsakh mii huten wa niya wa, nduwa na fingya sǝ purowa laɓara aten na wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nggǝrangga Mbilatus sǝ, “Mbǝ tǝ Yahudarha ni nggi wa, nafiwa ni, tǝ mamngya firistaya ɓagha tǝ sa thlǝmad na ɓa. Mani ǝnana?” ");
INSERT INTO hwo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ndangga Yeeso, “Kutǝr yidna mbǝ yi ƙǝshiid ɗa ni ya wa. Andam kutǝryid na yi ƙǝshidɗa ni ya, kam na fatsahayina a yanda amawana Yahudaya ƙǝseerha. Amma kutǝr yidna mbǝ yi ƙǝshidɗa ni ya wa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ndangga Mbilatus, “Ashe kutǝra ni sa wa!” Nggǝrangga Yeeso sǝ, “Sa ndagha, kutǝra ni nggi. Nggǝt na nda nggi hu ƙǝshidɗiya ka tarɗi ya, a thlǝk ƙǝkafek ni. Kala niifa na midghǝn ƙǝkafek, nǝn kee thlǝmaarha fa.” ");
INSERT INTO hwo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tsahangga Mbilatus mee, “Mani ƙǝkafek?” Tǝrgha kyagha Mbilatus ƙǝsha ɗǝ ndanggǝn Yahudayini wumngga hai, “Mbǝ ˈya sǝ ɗimi wal ni a fad kamshiɗiya wa. ");
INSERT INTO hwo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amma na ǝntin nun sǝ kala far wutsǝfayid Tǝɗaarha, ni kalang niifa kun hai tal ƙǝnang nanda ahu porsǝna. Na mid nun sǝ a kalang kutǝr Yahudaya ni kun hai wa?” ");
INSERT INTO hwo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Amma tǝrang ngganda urad ndan sǝ, “Mbǝ niifɗiya wa, Mbarabas na mid nan!” Mbarabas ƙǝm tǝ fasa farha ni. ");
INSERT INTO hwo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tǝrgha Mbilatus fǝr Yeeso nǝn a sodjaya tsaɗaghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Taksaagha sodjaya ǝnfatta teena tǝ ndaaha pang nggǝnda teena. Tǝrgha ɓa nda ɓa tǝ kaɓaarha tur yi kutǝryirha kalang nggǝnda fa. ");
INSERT INTO hwo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓa nda thlǝmadghǝn ɓa na nda a ndangˈya yi waa farha, “Alvari, kutǝr Yahudaya!” Mbiighǝn nda. ");
INSERT INTO hwo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nggǝrgha Mbilatus kyaarha ɓa ndanggǝn Yahudayini, “Nanǝnya niya kyang Yeeso kun ɓa, na minna sǝ a sǝnunsǝ ƙǝsang nggi tǝ ɗimiyirha fa wa.” ");
INSERT INTO hwo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kyagha Yeeso sǝ tenggǝn fǝfaɗa tǝ ndaaha, tǝ tur kaɓad kutǝryirha a fadghǝn, ndangga Mbilatus kanda, “Kǝlama niifɗiya.” ");
INSERT INTO hwo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nana mamngya firistaya ndǝn tǝ fa ƙǝla Ƙǝn Faara tǝrang ngganda urad ndan sǝ, “Tawaman ɗǝ! Tawaman ɗǝ!” Ndangga Mbilatus kanda, “Ɗamaɗǝ ɗun tawang ɗǝ tafan nun, nggi kam nawi ndǝn tǝ ˈya na ɗimi fa wa.” ");
INSERT INTO hwo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tǝrgha Yahudayini nggǝrang ngganda sǝ, “Na ngyahad nǝm sǝ, ˈya ndaana ngyahadɗi kamɗǝ a mǝrgha, ƙǝsǝr aaghǝn fadghǝn Wan Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sǝkna Mbilatus kee nggǝrghǝn chik tǝrǝmnda. ");
INSERT INTO hwo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nggǝrghǝn kyaarha tǝ Yeeso ahu chelleru ɗǝ tsahang mee nǝn ha, “Ɓagha ɓa a yanggi?” Amma nggǝrangwa Yeeso sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndangga Mbilatus, “Karna fa a kaleegha sǝ? Sǝngwa sǝ niyi tǝ sǝsǝmnda ha na a kal sani hai nduwa tawo wanda ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nggǝrangga Yeeso sǝ, “A mbǝ Faara fǝrowa sǝsǝmnda wa mbǝ ˈya sǝ na mbang ǝneerha wa. Yanɗi fǝrgha nggi ahu harwa hai kal ɗǝ sa ɗimiyirha.” ");
INSERT INTO hwo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hǝrǝm na Mbilatus sǝk laɓarɗi ya na midghǝn sǝ a kal Yeeso nǝn hai, amma Yahudayini na nda a tǝrang urad ndan sǝ, “A kal na niifɗa hai ya, mbǝ pashid Kaisar ni sa wa. Kala niifa ndaagha kutǝra ni tǝsar Kaisar ni.” ");
INSERT INTO hwo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sǝkna Mbilatus laɓaryini kee, kyagha ɓa tǝ Yeeso. Tǝrgha Mbilatus tsauka aten tsǝnggam ngwa kumarha sǝ, a mbǝrha na nda aarha “feera na ngga”, Ibraniyaya na nda aaghǝn “Nggabbata.” ");
INSERT INTO hwo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A far ɗemnda wutsǝfayid Tǝɗaarha ni yanfaara a sǝrǝkrha. Ndangga Mbilatus Yahudayini, “Ƙǝlama kutǝr nun ya!” ");
INSERT INTO hwo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Amma Yahuda yini tǝrang ngganda urad ndan sǝ, “Ɓǝlaman, ɓǝlaman, tawaman ɗǝ!” Tsahangga mbilatus mee kanda, “Na mid nun sǝ tawang nggi kutǝr nun ɗǝ wa?” Nggǝrangga mamnda firistaya sǝ, “Mbǝ kutǝr nan sǝ pak wa ƙǝl Kaisar.” ");
INSERT INTO hwo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tǝrgha Mbilatus fǝrang Yeeso nǝn kanda ka a tawang ngganda ɗǝ. Nanǝn kee wii nda tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tǝranggǝn kaɗidghǝn tafadghǝn a mbǝrha ɗǝ na nda aarha mbǝd ɓalhwad teena. Ibraniyaya na nda aaghǝn, “Nggolggota.” ");
INSERT INTO hwo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A mbǝɗa ni tawang na nda Yeeso saaɗǝ tǝ nafiya sǝri, tal a yisǝmadghǝn, tal ƙǝm a yikawadghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Chirelthgha Mbilatus tǝ ndaarha, “YEESO TƏNADZARAT, KUTƏR YAHUDAYA.” Tawang ngganda chireethɗi a man ten kaɗidɗi. ");
INSERT INTO hwo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudaya hangga karatangga chireelth ɗi ƙǝsǝr mbǝɗi tawang na nda Yeeso saaɗǝ nǝghǝn tsau tǝ Urshalima fa. Chireelth ɗiya ǝnagha ndan tǝ mii Yahudaya, tǝ mii Romaya, tǝ ƙǝm mii Helenaya. ");
INSERT INTO hwo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tǝrgha mamngya firistaya ndang ngganda Mbilatus, “A chireethleng na hai ‘Kutǝr Yahudaya wa,’ amma chireethleng hai, ‘Niifɗiya ndanggǝn fadghǝn kutǝr Yahudaya ni.’” ");
INSERT INTO hwo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nggǝrangga Mbilatus kanda sǝ, “ˈYa chireethleng ni hai, chirethleng ɗi hai.” ");
INSERT INTO hwo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Akwasamadɗi tawang na sodja yini Yeeso ɗǝ, harang ngganda karidghǝn ndǝghang ngganda hai mbǝdghǝn faɗa kowunni tǝ yighǝn. Ənagha nda kee ƙǝm tǝ kaɓadghǝn tsǝna nda a uradghǝn hai ta sarghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ndangga sodja yini ndan, “A njarang ɗǝm kaɓad ɗaɗǝ ya wa, amma tama ǝna chacha nǝm a tenggǝn tǝ wunni a hǝɓang.” Katǝrana ǝnɗa hai ya ka a lǝɗang ngganda ˈya ndaana Ɗeleewar Faara, “Ndǝghang ngganda karidna hai a pathlang ndan, ǝna chacha nda aten kaɓad na.” Ənɗa ni ǝnana sodjaya. ");
INSERT INTO hwo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nafiya ishgha tsau tǝ kaɗidɗa fa nda man Yeeso, tǝ wanman, Mairamu nu Kilobas, tǝ Mairamu magdaliya. ");
INSERT INTO hwo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nana Yeeso man tǝ tǝtsahadɗi keeghǝn nggǝm nǝn ƙǝt tsau tǝghǝn fa, ndanggǝn man, “Kulo wanwa ya.” ");
INSERT INTO hwo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tǝrgha ndanggǝn tetsahadɗi, “Kulo muwa ya.” Ka farɗi ɗǝgha tǝtsahadɗi tǝ man Yeeso wuri keeghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sǝn Yeeso sǝ nanǝnya ngwalang ɗǝ targhǝn. Ka a lǝghǝdgha ˈya ndaana Ɗeleewar Faara, ndǝghǝn, “Na hushimnda fanna.” ");
INSERT INTO hwo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na ƙǝthlikrha sǝ a mbǝɗi lǝlǝgɗa tǝ aam inabi chichakh. Nanǝn kee tǝtǝnang ngganda soso tǝ aam inabi na chichakh, pang ngganda hu sǝsaala nzang pang nggǝnda Yeeso mii sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Taarang na Yeeso ndǝghǝn, “Ngwala ɗǝ!” Tǝrgha kwanggǝn tenggǝn hai kal yiɓǝdghǝnǝn hai. ");
INSERT INTO hwo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nanǝnya ɗemnda far wutsǝfayid Tǝɗaarha ni, a ɗalth mbǝrha hai ndǝna far yiɓǝdɗi, Ƙǝsǝr mamnda Yahudayini mbǝ mindan sǝ nagha mǝrya nafini aten kaɗiirha a far yiɓǝdɗi wa, ƙǝsǝr far yiɓǝdɗi fara ni na manggǝn. Tǝrgha Yahudayini hwan Mbilatus nda a hwasang ngganda ndǝlengya nafini, tǝ ƙǝm tǝrang ngganda mǝryina hai. ");
INSERT INTO hwo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɗǝgha sodjaya ɗǝ ɗa nda hwasang ndǝlengya nafini sǝri tawang na nda kanda ɗǝ tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma ɓa na nda thlǝmad Yeeso ɓa ƙǝla nda hai ˈwaɗǝ teena mǝrɗǝ hwasang ngwa nda ndǝlenggighǝn wa. ");
INSERT INTO hwo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tal ahur sodja yini kulth Yeeso nǝn tǝ peela a ƙǝlarghǝn tsu kee kyagha aama ɓa tǝ faara. ");
INSERT INTO hwo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Niifɗi nagha ǝn ɗi katǝra hai ndǝn pǝrgha ndǝn. Ənɗi pǝr nǝn ƙǝkafek ni, pǝr nǝn ndǝn kee tǝnun fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Katǝra na ǝnɗa hai kee ya ka a lǝghǝdgha laɓar Faara ndaa nǝn, “Mbǝ alghǝn sǝ tal hwasagha wa.” ");
INSERT INTO hwo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na laɓar Faara sǝ ƙǝm ndaagha, “Na nda a ƙǝlang yanɗi kuthlang na nda.” ");
INSERT INTO hwo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Akwasamad ǝngginiya, Yisufu niif Aramatiya tǝtsahad Yeeso ni ɓǝɓee ƙǝsǝr nǝghǝn a tǝrǝm Yahudaya, ɓagha thlǝmad Mbilatus ɓa na a fǝrang kwamana nǝn a ɗǝgha tǝrang mǝrra Yeeso hai. Fǝrang na Mbilatus kwamana, ɗǝgha ɗǝ tǝranggǝn merra Yeeso hai aten kaɗidɗi. ");
INSERT INTO hwo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Niifɗi na nda aarha Nikodimus ˈwagha ɗǝrha thlǝmad Yeeso ɗǝ a fǝɗikrha, takkwa ɗǝ Yisufu ƙǝsɗǝ urdi ha na nda aarha mur tǝ alos sǝlna hadghǝn kilo kumnggit mahan (30). ");
INSERT INTO hwo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tǝrgha nafini kyab ya faɗang ngganda mǝrra Yeeso hu kaɓaarha na pǝpet irang urdi nda fa ƙǝla na Yahudaya ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A mbǝɗi tawang na nda Yeeso sǝ na heerha sǝ, ahu hedɗi na kwad mǝrra sǝ rana nda, ˈwawa na nda pa mǝrra sǝ. ");
INSERT INTO hwo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tsaunǝn far ɗemnda far yiɓǝd Yahudaya ni, nanǝn na kwarha sǝ tsau a mbǝɗi, Pang ngganda Yeeso a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A tsar ƙǝrǝt a far ladi, mbǝrha liwid-liwid, Mairamu Magdaliya ɗǝgha ten kwad Yeeso ɗǝ, ƙǝlagha hai kwatǝrang nda fer ɗaɗǝ na a mii kwadɗi. ");
INSERT INTO hwo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tǝrgha thliigha tǝ ɗaarha thlǝmad Siman Mbiturus ɗǝ tǝ tǝtsahadɗi nggǝmna Yeeso ndanggǝn kanda, “Tǝrang nda Chinǝm sǝ ahu kwaarha, sǝnggum mbǝɗi ɗǝfang na nda saɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tǝrgha nda Mbiturus tǝ tahad tǝtsahadɗi katǝrangganda ɗǝrha a ten kwadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kanda kyab ƙǝs ɗaarha nda, amma yanɗi tǝtsaharha kalɗǝ Mbiturus ɗaarha ˈwagha a ten kwadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɓǝrgha hai ƙǝlagha hu kwadɗa ɗǝ na kaɓad pa mǝrɗa nǝn, amma kya wa hur kwadɗa ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tǝrgha Mbiturus ɓagha a ɓa a kwasamarha, kyagha hur kwadɗa hai. Na kaɓad pa mǝrɗa nǝn a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tǝ ƙǝm na kaɓadɗa nǝn faɗang na nda ten Yeeso sǝ ta a man patu. ");
INSERT INTO hwo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tǝrgha yanɗi tǝtsaharha ˈwagha ten kwadɗa ɗǝ ma Mbiturus kyagha hur kwadɗa hai ƙǝm, nanǝn ǝnggini heu ya fǝrƙǝkafek nǝn. ");
INSERT INTO hwo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pa ka weriya sǝnang ngwanda ˈya hai ndana Ɗeleewar Faara, na Yeeso a thliirha sǝ hu mǝra wa. ");
INSERT INTO hwo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tǝrgha fatsahayini wuɗa nda wure ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Amma Mairamu Magdaliya ishgha a ten kwadɗi nagha a tǝrha. Ndǝghǝn aten tǝrha ɓǝrgha hai ƙǝlagha hur kwadɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na fa thlǝngya Faara nǝn sǝri tǝ lukkya fa pǝpet-pǝpet kanda tsǝtsau a mbǝɗi pang nanda Yeeso sǝ, tal a man tenggǝn tal a man sarghǝn. ");
INSERT INTO hwo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tǝrgha tsahangga fa thlǝngya Faara mee nuɗi, “Sa nuɗiya mani na a tǝrha?” Ndanggǝn kanda, “Tǝrang nda yina Chinǝm sǝ, sǝngwi mbǝɗi ɗǝfang na nda saaɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ndǝghǝn a nggǝlang miighǝn kee, kyahar nǝn hai ƙǝlagha hai Yeeso ƙǝt. Amma sǝnangwa hai Yeeso ni wa. ");
INSERT INTO hwo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tǝrgha tsahangga Yeeso mee, “Sa nuɗiya, mani na a tǝrha? Wun na a kaɗaarha?” Tamnggǝn ndaarha tǝtaara ni na ahur hedɗi. Ndanggǝn, “Ana sa ni tǝrangga, pǝre mbǝɗi ɗǝfang na saaɗǝ ɗi tǝrang ɓa.” ");
INSERT INTO hwo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tǝrgha ndangga Yeeso, “Mairamu!” Kyahargha Mairamu man thlǝmad Yeeso ɗǝ ndǝghǝn tǝ mii Aramaya, “Rabboni!” Ndaarha ni “Mala”. ");
INSERT INTO hwo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ndangga Yeeso, “A tsuwar na nggi fa wa, ƙǝsǝr ɗǝwi thlǝmad Pǝpa ɗǝ ˈwan wa. Amma ɗuwa thlǝmad wan manggina ɗǝ ndangga kanda, niya ɗǝrha thlǝmad Chinɗa ɗǝ tǝ yinun China, Faar na tǝ ƙǝm yinun Faara.” ");
INSERT INTO hwo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tǝrgha Mairamu ɗǝgha thlǝmad fatsahayina ɗǝ ndanggǝn kanda, “Naɗi Chinǝm!” Pǝrang laɓar ɗa nǝn kanda ndang na Yeeso. ");
INSERT INTO hwo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tsu a farɗi a figrha a far ladi, fatsahaya Yeeso wumnda hai a mbǝrha tal, chang ngganda kwaminda a tendan ɗǝ, ƙǝsǝr na nda a tǝrǝm Yahudaya. Kula sǝndǝndan sǝ ƙǝla nda hai Yeeso ƙǝt a maɗufun ndan ndǝghǝn, “A tsauka ɗǝɗemnggirha tǝ kun.” ");
INSERT INTO hwo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Akwasamadghǝn thlǝk nǝn laɓarɗi ya kyaɗang haaryighǝn nǝn kanda tǝ ƙǝlarghǝn. Tǝrgha fatsahayini lǝgɗa nda tǝ wutsǝfayirha, ƙǝsǝr nanda Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nggǝrgha Yeeso ndang nda kanda, “A tsauka ɗǝɗemnggirha tǝ kun. Ƙǝla thlǝnna Pǝpa nggi ɓa, niya thlǝn kun kee ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tǝrgha peng ɓereurha nǝn kanda fa ndǝghǝn, “Thlaama Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kala niifa chahang nun ɗimiyidghǝn ɗǝ, chahang ndan ɗǝ, kala niifa ƙǝm chahang ngwa nun ɗimiyidghǝn ɗǝ, mba nda chahanggǝn ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ahu sayidɗiya, Toma tal ahur fatsahayini na thlǝm ɓashadghǝn Muɗaarha, mbǝ ahur ndan wa a sayidɗi ɓa na Yeeso ɓa. ");
INSERT INTO hwo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nanǝn kee, ndang ngganda, “Naɗan Chinǝm.” Amma ndangga Toma kanda, “Mbi fǝrƙǝkafek wa ƙǝl a naɗi kwat kusa ɗi a haarghǝn, pang nggi haar na saɗǝ tǝ ƙǝlarghǝn wa mbi tam fǝrƙǝkafek wa.” ");
INSERT INTO hwo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Akwasamad ɓeena uvaɗa fa tsahayini kanda a mbǝrha tal, Toma ƙǝm nǝghǝn ahur ndan kwaminda chicha. Amma kula sǝndǝndan sǝ ƙǝla nda hai Yeeso ƙǝt a maɗufun ndan ndǝghǝn, “A tsauka ɗǝɗemnggirha tǝ kun.” ");
INSERT INTO hwo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tǝrgha Yeeso ndanggǝn Toma, “Pang wan haar wa mbǝɗa hai ya, ƙǝlang harna. Tsǝwaru ƙǝlar na fa, tǝna malang ngaala, fǝrƙǝkafek na.” ");
INSERT INTO hwo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ndangga Toma, “Yina Chinǝm, tǝ yina Faara!” ");
INSERT INTO hwo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ndangga Yeeso, “Ka nana nggi ndǝn fǝr na ƙǝkafek? Fa parkaya ni nafiya nawa nggi, amma fǝr nda ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Əna Yeeso ǝnwulteengya hangga a yid fatsahayighǝn chireethleng ngwana nda hai ahu ɗeleewar ɗiya. ");
INSERT INTO hwo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amma chireethleng na nda ǝnɗa hai ya tǝnun fǝrƙǝkafek tǝ ndaarha Yeeso ni Ƙǝrǝsti, Wan Faara. A hu fǝrƙǝkafekkid nun a ndǝghǝn, nun a wal yibrha ahu thlǝmnggǝn. ");
INSERT INTO hwo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsǝɓaku kyadna Yeeso fadghǝn a fatsahayighǝn a mii wutambar Tibariya. Katǝraghǝn hai kiya. ");
INSERT INTO hwo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nda Siman Mbiturus, tǝ Toma na nda aarha Muɗarha, tǝ Nataniyel ɓagha ɓa a Kaana yi Nggalili, tǝ wangya Dzabadi, tǝ fingya fatsahaya sǝri, kanda heu a mbǝrha tal. ");
INSERT INTO hwo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tǝrgha ndagha Siman Mbiturus, “Ɗǝni ka tǝmnda ɗǝ.” Ndangga fingya fatsahaya, “Kan ma nan a ɗǝrha ɗǝ a samadwa.” Wii nda, tǝra nda hu kombuwol hai. Amma a fǝɗikɗi mbǝ ˈyasǝ ƙǝs na nda wa. ");
INSERT INTO hwo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A tsar ƙǝrǝt, ishgha Yeeso a mii ƙǝƙǝshɓangnda, amma fatsahayighǝn kukwalang ngwa nda hai tǝwunni wa. ");
INSERT INTO hwo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tǝrgha ndangga Yeeso kanda, “Wundǝlaya, tǝna sǝ a haar nun wa?” Nggǝrang ngganda sǝ, “Awo.” ");
INSERT INTO hwo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ndangga Yeeso kanda, “Muwa man panggam nun hai tǝ man yisǝmad kombuwol ɗi nun a waala.” Nanǝn kee muwang ngganda hai ƙǝla ndang na Yeeso kanda, ƙǝs tǝna nda mbang ngwa nda kahang nda ahur kombuwol ɗa ɓa wa ƙǝsǝr ka hang nda tǝna. ");
INSERT INTO hwo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tǝrgha tǝtsahadɗi nggǝmna Yeeso kaan ndanggǝn Mbiturus, “Chinǝm ni!” Hǝrǝmna Siman Mbiturus sǝkrha, “Chinǝm ni,” kalanggǝn luwudghǝn ƙǝsǝr kalang ɗa hai. Tǝrgha pǝrgha ahu aamɗa hai a mii ƙǝƙǝshɓangnda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fingya fatsahaya ɗǝnda man patu ɗǝ tsau tǝ ƙǝƙǝshɓangnda ahu kombuwol. Na nda a kahang panggam ɗa sǝ na lǝlǝgɗa tǝ tǝna. Ƙǝsǝr mba nda inggun tǝ chehweerha wa, ƙǝla thlǝtta saara haru kumnggitghǝn mahan. ");
INSERT INTO hwo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sǝl na nda ƙǝƙǝshɓangnda ɗǝ, na tsal waarha nda a mbǝɗi tǝ tǝna a tenggǝn tǝ ƙǝm mburodi. ");
INSERT INTO hwo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ndangga Yeeso kanda, “Ɓama ɓa tǝ fingya tǝngya ƙǝs nun kukuling ya.” ");
INSERT INTO hwo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tǝrgha Siman Mbiturus kyagha hu kombuwol hai kahanggǝn panggam ɗi a mii ƙǝƙǝshɓangnda ɗǝ. Nǝghǝn lǝlǝgɗa tǝ tǝngya na mǝmanggǝn haru tal tǝ kumnggit tuf kap mahan, heu tǝ hang nda tǝnggini thluwus wa panggam ɗi wa. ");
INSERT INTO hwo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ndangga Yeeso kanda, “Ɓama ɓa ɓun hǝb ǝnnarhami.” A hur fatsahayini mbusǝ ndengga yidghǝn tsahang mee nǝn, “Wunni sa wa?” Ƙǝsǝr sǝndasǝ Chinǝm ni. ");
INSERT INTO hwo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tǝrangga Yeeso mburodi sǝ fǝranggǝnǝn kanda, ǝnagha kee tǝ tǝnɗi ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nanǝnya sar Yeeso yi mahan ni nǝn naarha kyad fadghǝn a fatsahayighǝn a kwasamadɗi thleng nanda sǝ ahu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A kwasamadɗi ngwalang nanda hǝb ǝnnarhami tsahangga Yeeso mee Mbiturus, “Siman wan Yahaya, nggǝmna nggi ma fingyayini ya wa?” Nggǝrangga Mbiturus sǝ, “Haˈi, Chinǝm, sǝnnasǝ tafadwa nggǝmɗi sa.” Ndangga Yeeso, “Fǝrang ǝnnarhami wan chaurayina.” ");
INSERT INTO hwo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nggǝrgha Yeeso tsahang mee yi sǝri, “Siman wan Yahaya, nggǝmna nggi wa?” Nggǝrangga Mbiturus sǝ, “Haˈi, Chinǝm, sǝnnasǝ tafadwa nggǝmɗi sa.” Ndangga Yeeso, “Lafu chaurayina.” ");
INSERT INTO hwo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nggǝrgha Yeeso tsahang mee yi mahan, “Siman wan Yahaya, nggǝmna nggi wa?” Sǝbgha hur Mbiturus ɗǝ ka tsahang na Yeeso mee yi mahan aten ndaarha, “Nggǝmna nggi wa?” Ndanggǝn, “Chinǝm sǝnna ǝngya heu, sǝnnasǝ ƙǝm nggǝmɗi sa.” Ndangga Yeeso, “Fǝrang ǝnnarhami chaurayina. ");
INSERT INTO hwo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Niya puro ƙǝkafek, a sayidɗi nana wundǝlarha, na ngwarha fa ɗǝna a mbǝrha ɗǝ na midwa, amma a suhur na, na harang haar yiwa sǝ nggowa niifa fa ɗǝgha tǝ sa a mbǝrha ɗǝ mbuwa na midwa ɗǝrha saaɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Thlǝkna Yeeso ndǝn kee ka a kyad tur kwaman ɗa nǝn na Mbiturus a mǝra sǝ ka mananggǝn thlǝm Faara.) Tǝrgha ndanggǝn, “Mbuwu samanna.” ");
INSERT INTO hwo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kyahargha Mbiturus hai na tǝtsahadɗa nǝn nggǝmna Yeeso kaan a mbu samad ndan. Yanɗa ni tǝngsangga Yeeso fa a sayidɗi na nanda a hǝb ǝnnarhami yi Wutsǝfayid Tǝɗaarha tsahang nǝn mee Yeeso, “Chinǝm wunni na a fǝr sa?” ");
INSERT INTO hwo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nana Mbiturus ndǝn, tsahang mee nǝn Yeeso, “Chinǝm, niifɗiya wu?” ");
INSERT INTO hwo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nggǝrangga Yeeso sǝ, “Ana minna sǝ malang nggi tǝ yibrha ta far wuttǝna ɓa, ma njiɗowa? Sa mbuwu samanna.” ");
INSERT INTO hwo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tǝrgha laɓarɗi ya welgha ɗǝ a mii fa takkwaya Yeeso tǝ ndaarha tǝtsahadɗi ya mbǝ a mǝra wa. Amma ndawa Yeeso mbǝ a mǝra wa, ˈya ndanǝn, “Ana minna sǝ malang nggi tǝ yibrha ta far wuttǝna ɓa, ma njiɗowa?” ");
INSERT INTO hwo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tǝtsahadɗa ni ya, nagha ǝnggini heu, chirethleng nǝn hai tǝ ƙǝm ˈya ndanǝn ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na fingya ǝngya sǝ hangga ǝnana Yeeso. A ndam chirethleng nda kanda hai heu, kam mbǝ ƙǝshiirha mbang ƙǝs ɗeleewar yina ha chireelth nanda wa.");
INSERT INTO hwo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyafulus ahu ɗeleewar na ˈwani chirethleu ɗǝ chirethleu ɗi ǝnggina hai katǝra na Yeeso ǝnaarha heu tǝ tsahadghǝn ha, ");
INSERT INTO hwo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ta farɗaɗǝ tǝrang nanda talara ɗǝ kapa na nda tǝrang nda talara ɗǝ kalang ɗǝ fathlǝnggighǝn sǝ tǝ thlarra Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A hu ɓenɗi kumnggit faɗa a kwasamadɗi tawang nanda ɗǝ kyadɗǝ fadghǝn a fathlǝnggighǝn sayi-sayi tǝ ƙǝm ahu kwamangya hangga kyaɗang nǝn ndaarha kanda nǝghǝn tǝ yibrha fa. A hu ɓenggini ya pǝrang ɗǝ laɓara kanda aten kutǝryid Faara. ");
INSERT INTO hwo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ndǝghǝn ɓalɗǝ tǝ kanda ahu sayidɗi na nanda a hǝb ǝnnarhami ndanggǝn kanda, “A mal ɗun Urshalima wa kǝl a thlǝnang Pǝpa ǝnɗi kun ɓa ndanǝn. Ɗalama teena hai ˈwaɗi pǝrang ǝnɗi kun ya. ");
INSERT INTO hwo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ənagha Yahaya mbaptisǝma tǝ aama, amma ahu ɓengya na ɓayi tǝ Sǝsǝna tǝ Pǝɗǝnda na nda a ǝnang mbaptisǝma kun.” ");
INSERT INTO hwo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tǝrgha wumngga fathlǝnggighǝn hai a thlǝmadghǝn na nda a tsahang mee ha “Chinǝm na a kal Isǝrela hai nanǝnya nggǝrgha wuɗang kutǝryirha kan ha wa?” ");
INSERT INTO hwo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ndanggǝn kanda, “Faara katenggǝn ndǝna tǝ sǝsǝmnda ǝna ɓengya, amma fǝrang ngwanda kwaman sǝndǝghǝn kun wa. ");
INSERT INTO hwo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma a ɓad Sǝsǝna tǝ Pǝɗǝnda aten nun ɓa kun nagha ndǝn tǝ yid nun, nun a wal sǝsǝmnda na a pǝr laɓar na nun a fiya ko a yanggi ni a Urshalima, tǝ chehweed Yahudiya, tǝ Samariya ɗǝgha ta mii ngwala ƙǝshiirha ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A kwasamadɗi thlǝknǝn ǝngginiya, tǝrang ngganda talara sǝ, kanda a ƙǝlang nda, timngga hu hashmbe ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nana nda a tutuk yirha talara ɗǝ ka a naghǝn nda. Kula sǝndǝ ndan sǝ kǝla nda hai nafiya sǝri tǝ lukkya fa pǝpet ƙǝƙǝt nagha a pathlang ndan. ");
INSERT INTO hwo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ndangganda kanda, “Nafiya Nggalili, kama na nun ƙǝƙǝt a ƙǝlarha talara ɗǝ? Yeeso tǝrang nda ma kun ɗǝnda tǝghǝn talara ɗǝ. A fara sǝmǝn ƙǝm ƙǝla nanun ndǝn a wiirha, nǝn a nggǝr wutta ɓa kee!” ");
INSERT INTO hwo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Fa thlǝngya Yeeso na nda a wumnda ɗǝfya Dzaitun katǝrana ǝnɗa hai ya, wuɗa nda Urshalima ɗǝ na iundǝghǝn takh ɗǝ a sǝl mel tal. ");
INSERT INTO hwo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tǝrgha kya nda hu ƙǝnɗa ɗǝ tǝnna nda aten shadghǝn nana nda sǝ tǝ tsaurha. Kulo thlǝm nafini ya na a mbǝɗi: Mbiturus, tǝ Yahaya, tǝ Yakubu, tǝ Andrawus, tǝ Filibus, tǝ Toma, tǝ Mbatalomi, tǝ Mattiyu, tǝ Yakubu wan Halfa, tǝ Siman (tǝsǝrǝk chehweedghǝn) tǝ Yahuda wan Yakubu. ");
INSERT INTO hwo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wuma nda hai heu na nda naarha hwan Faara, tǝ fingya nishya hangga, heu tǝ Mairamu man Yeeso, tǝ wan mangya Yeeso hǝshya. ");
INSERT INTO hwo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na farɗa sǝ wumna fatakkwaya Yeeso hai takh nda a sǝl haru tǝ kumnggit sǝri, tǝrgha Mbiturus thliigha sǝ ndaagha: ");
INSERT INTO hwo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wan manggina, kamɗǝ a lǝghǝdgha ˈya ndana ɗeleewar Faara aten Yahuda, ɗǝgha ɗǝ tǝ fa ƙǝla Ƙǝn Faara ha na manggǝn ka a ƙǝsang ngganda Yeeso. ˈWad Sǝsǝna tǝ Peɗǝnda thlǝkƙǝn ƙǝtǝm a mii Kutǝra Ndauda. ");
INSERT INTO hwo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yahuda nǝghǝn tal ahur nǝm, yi wurna nda ka ǝna tar ɗa nǝm ya tǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yahuda hiiɗǝ heerha tǝ wuɗǝɓǝl ɗi thlǝnǝn ka thlǝrɓuyidghǝn, mukka hai tǝ man tenggǝn, ɗalthgha hurghǝn kyagha haɗighǝn ƙǝshi. ");
INSERT INTO hwo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Laɓar mǝrrǝghǝn welɗa ɗǝ ƙǝkar a fiya heu na a Urshalima, ɗǝfang thlǝma nda mbǝɗi tǝ mii Aramaya “Akeldama,” ndaarha ni “Pǝpal Fara.”) ");
INSERT INTO hwo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ɗǝgha Mbiturus mbeeɗǝ tǝ ndaarha, ƙǝsǝr nǝghǝn chichireethlee hai hu ɗeleewar Dzabura tǝ ndaarha, “Ngwa tsauka wurighǝn kwadwure; ko niifa ahurghǝn tǝ tsaurha tǝ kǝm, Ngwa tǝrangga niifa pak mamnggitghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Tsaunǝn kee, tǝtani a wur niifa nǝm na a tsaurha a mbǝd Yahuda. Tǝtani ƙǝm niifa ni na narha tǝ ƙǝm ka a sayidɗi heu nanǝm tǝ Chinǝm Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ka a farɗi ǝnang na Yahaya mbaptisǝma ta ɓagha farɗa ɓa tǝrangna nda ma thlǝman nǝm ɗǝnda tǝghǝn talara ɗǝ. Kala niifa wur nǝm nǝn a wum teena tǝ ƙǝm hu pǝr laɓar thlid Yeeso sǝ ahu mǝrra.” ");
INSERT INTO hwo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aah thlǝm nafiya nda sǝri: Yisufu na thlǝmnggǝn Mbarsaba na nda aarha ƙǝm Yustus tǝ Mattes. ");
INSERT INTO hwo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tǝrgha hwan Faara nda aten niifa kamngga a wura nda, ndaa nda, “Chinǝm sa sǝngga hur nafiya heu, ahur nafini sǝri ya kyaɗang yanɗi kan wur nana, ");
INSERT INTO hwo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a tsauka tǝ thlǝndǝwa a meghed Yahuda tǝ thlǝrɓu ahu tar wa, ƙǝsǝr karɗǝ kan fa ɗǝgha mbǝɗaɗǝ kamangga fa.” ");
INSERT INTO hwo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tǝrgha ǝna wura nda aten ndan, wur Mattes nda tsauka tǝ thlǝnda Yeeso tǝ fingya na kumkap tal. ");
INSERT INTO hwo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A far wutsǝfayirha na nda aarha pentikos, wumngga fatakkwaya Yeeso hai a mbǝrha tal. ");
INSERT INTO hwo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kula sǝndǝndan sǝ sǝk fad ˈya nda a riirha ƙǝla ɓereu ˈyaara a fǝrakh amshi hai lǝɗanggǝn wuriɗi nana nda sǝ tsǝtsau. ");
INSERT INTO hwo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tǝrgha na ˈya nda kǝla sheneu waarha kyagha sǝ a pathlang ndan a ndǝkrhaɗe tǝ kǝm tǝrgha ten nggindan hai. ");
INSERT INTO hwo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Lǝɗangga Sǝsǝna tǝ Pǝɗǝnda kanda heu tǝ kǝm katǝrang ngganda ndikrha hai tǝ fingya miiya ɗǝɗamǝn-ɗǝɗamǝn, kala yanɗi fǝrangna Sǝsǝna tǝ Pǝɗǝnda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yahudaya na a tǝrǝm Faara, ɓagha ɓa ahu chehweeya ɗǝɗamǝn na nda ahu Urshalima a sayidɗi. ");
INSERT INTO hwo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sǝk na fiya wumngga hai riirha ǝnɗi kee, tǝrgha ɗaa nda ɓa ka ɓa nda na ǝnɗi katǝragha hai. Ƙǝsangga ǝnwulteena kanda ƙǝsǝr ko wunni sǝkɗǝ kanda a ndikrha tǝ miiyi ndan a mii fatakkwaya hangga wumngga hai. ");
INSERT INTO hwo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Əna ǝnwulteena nda, tsakhmee nda, “Nafini heu naa a ndikrha ya, mbǝ Nggalilaya ni wa? ");
INSERT INTO hwo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ƙǝƙǝn ƙǝm kowunni ahur nǝm a sǝk ˈya nanda ndikrha tǝ miighǝn? ");
INSERT INTO hwo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kulo kan kǝm ya Fartiyaya, tǝ Mediyaya, tǝ Elamayaya, tǝ nafiya chehweed Mesofotamiya, tǝ Yahudaya, tǝ yi Kafadokiya, tǝ yi Fantus, tǝ yi Asiya, ");
INSERT INTO hwo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","tǝ yi Firijiya, tǝ yi Famfiliya, tǝ yi Masar, tǝ kǝm yi na tsau tǝ chehweed Libiya ɗǝgha Sayirin ɗǝ. Rongya ɓagha ɓa a Roma, ");
INSERT INTO hwo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yahudaya tǝ kǝm fingya kyahargha hai na takkwa Yahudaya Kǝrǝstaya, tǝ Laraɓaya. Ƙǝm heu sǝkɗǝm nafiniya a ndikrha tǝ mii nǝm aten ǝngya na mǝmanggǝn ǝnana Faara! ");
INSERT INTO hwo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kanda heu na ǝnwulteena nda tsangga teena kanda, tsahang mee nda fandan, Tur mani ya?” ");
INSERT INTO hwo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amma fingya na ahur fiya wumngga hai na nda a waa farha ndaa nda, “Kanda heu tǝrangna mbaala kanda in!” ");
INSERT INTO hwo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tǝrgha Mbiturus thliighasǝ tǝ fathlǝngya kum kab talɗi, tǝranggǝn uradghǝn sǝ ndanggǝn fiya wumngga hai, “Kun heu kaama thlǝmaarha hai ngga, wanmanggina Yahudaya tǝ fingya na tǝ tsaurha a Urshalima! A sahad ɗun aten ǝnɗiya wa. ");
INSERT INTO hwo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Fingya ahur nun a ndaarha nafiniya tǝrang mbaala kanda teena. Mbǝ ƙǝkafek ni wa! Tsar ni ˈwan ya. Mbǝ mbaala tǝrang fiya teena a tsar kiya wa. ");
INSERT INTO hwo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Awo, ˈya nanun a tsar ɗiya ˈwad annabi Djoyel thlǝkƙǝn ƙǝtǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Ndagha Faara, a mii ngwala ƙǝshiirha, niya fǝrang Sǝsǝnna fiya heu. Wangginun nda hǝshya tǝ nishya na nda a thlǝk ˈya ndana Faara, Wundǝlayi nun na nda a na ǝngya kyaɗang ni kanda, Tǝ kǝm shinggi nun na nda a sǝsǝniirha. ");
INSERT INTO hwo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ko aten mafayina ni nda nishya tǝ hǝshya heu, Niya fǝrang sǝsǝnna kanda ahu ɓengginiya, Tǝ kǝm nanda a pǝr ˈya ndani. ");
INSERT INTO hwo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Niya kyad ǝnwulteena hai a frakh amshi, Tǝ ǝnsakhrha hangga a hweeɗe, Fara tǝ waarha, tǝ kǝm hashmbe tǝ ine na tikɗik. ");
INSERT INTO hwo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na nda a tsawang yanfaara wula, Ndǝre kǝm tsauka yiɓa kǝla fara, Kapa na mamnggit far Chinǝm ɓarha ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kala niifa aagha thlǝm Chinǝm, Nǝn wal hǝrǝkrha.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nafiya Isǝrela, kaama thlǝmarha hai! Yeeso tǝ Nadzarat niifɗi kyaɗang na Faara kun tǝ ndaarha ka niifani, ǝnaɗǝ ǝnwuteengya mǝmanggǝn tǝ ǝnsakhkya ahur nun kun tǝ altennun sǝnɗunsǝ. ");
INSERT INTO hwo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Faara fǝrgha niifɗiya a kun tǝ sǝndǝghǝn, kun kǝm tǝ thlarra fa mbǝlfeeya ɓǝlanggun tǝ taurha ɗǝ aten kaɗiirha. ");
INSERT INTO hwo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amma Faara thleng ɗa sǝ ahu mǝrra tǝ kǝm thliiɗa sǝ tǝ yibrha, ƙǝsǝr mbǝ mǝrra mbang ƙǝsghǝn ha a kwarha wa. ");
INSERT INTO hwo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ndauda kǝm thlǝkɗǝ pathla atenggǝn ndǝghǝn, “Naɗi Chinǝm ƙǝtsar a thlǝmanna. Ƙǝsǝr nǝghǝn a yisǝmanna, mbi tǝrǝm nda wa.” ");
INSERT INTO hwo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","“Nanǝn kee, na hurna a lǝghǝtta tǝ wutsefayirha, Tǝ ƙǝm na miina a falghǝn! Na fanna a yibrha tǝ mbǝrsaarha. ");
INSERT INTO hwo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ƙǝsǝr mba mal nggi ahu kwad mǝrra wa, Tǝ kǝmɗa mba nggǝmfa tǝ Peɗǝnduwa mǝlthgha wa. ");
INSERT INTO hwo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kyaɗenna kwaman yibrha, Na lǝgɗeerha tǝ mbǝnafa a thlǝmad wa.” ");
INSERT INTO hwo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kun wanmanggina numama aten ǝnɗiya, mbǝ Ndauda a ndikrha a altenggǝn ahu palthɗi ndani ya wa, ƙǝsǝr mǝrɗǝ pangganda, tǝ ƙǝm ten kwadghǝn ɓalghǝn a thlǝmannǝm. ");
INSERT INTO hwo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Amma nanǝn ndǝghǝnggi annabini tǝ kǝm sǝnda sǝ ndangga Faara har tǝ ɗǝf mee, tǝ ndaarha nǝn a tǝrang niifa ahu chichiyighǝn tsawanggǝn ahu tsǝnggam nggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nana Ndauda ǝnɗi ɓagha katǝrarha hai a mbee thlǝk pathla nǝn aten thlid Ƙǝrǝsti sǝ ahu mǝrra tǝ ndaarha mal wa ndan hu kwarha wa tǝ ƙǝm mbǝ thlu fadghǝn a mǝthla wa. ");
INSERT INTO hwo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Faara thleng ɗǝ Yeeso sǝ ahu mǝrra ƙǝm heu na ɗǝm ndǝn ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nanǝnya fǝrang nda mbǝd tsaurha yi tsǝnggam mamnggirha a talara a yisǝmad Faara. Ƙǝla ndana Chinɗi nǝn a fǝrang Sǝsǝna tǝ Peɗǝnda, fǝranggǝnǝn kan ƙǝm ndǝghǝn ɓangga ǝnɗa ɓa nun a naarha tǝ sǝkrha a weeriya. ");
INSERT INTO hwo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ƙǝsǝr Ndauda tafadghǝn ˈwawa tǝra talara ɗe wa, amma ndǝghǝn, Chinǝm ndanggǝn China, “Tsawu a yisǝmanna. ");
INSERT INTO hwo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ƙǝl a tsawang ɗi fa tsanggiwa, A kamu saryi wa.” ");
INSERT INTO hwo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nanǝn kee, ngwa tsauka tǝ sǝnda ko wunni a Isǝrela tǝ ndaarha Faara ǝnagha Yeeso ɗiya tawang nun ɗǝ a tsauka ndǝghǝnni Chinǝm tǝ ƙǝm Ƙǝrǝsti.” ");
INSERT INTO hwo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sǝkna nafini laɓarɗi ki Mbiturus tsuwar hur ndan nǝn fa, ndangganda Mbiturus tǝ fingya fa thlǝnggini, “Wan manggina ma nan a ǝnaarha?” ");
INSERT INTO hwo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nggǝrangga Mbiturus kanda sǝ, “Kowunni ahur nun tǝtani a malanggǝn ɗimiyidghǝn kyahargha thlǝmad Faara ɓa, ǝnang mbaptisǝma nda ahu thlǝm Yeeso Ƙǝrǝsti yi chakh ɗimiyirha, tǝ nun wal fǝrra Sǝsǝna tǝ Pǝɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Thlǝkna nda pathɗiya ka kun tǝ wangginun tǝ fingya mbuwa wa Yahudaya tǝ nafiya na Faara a aarha ɓa ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yiyang thlǝmaarha nǝn kanda teena; tǝ fingya pathya hangga tǝ ƙǝm hwan kanda nǝn, “Hǝrgha man fannun ahu ƙǝshiid weeriya yi mbǝlfeerha.” ");
INSERT INTO hwo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fingya thlǝgha palth Mbiturus kǝm ǝnang mbaptisǝma nda kanda, a farɗiya chik nda tǝ fiya fǝrgha ƙǝkafek takh nda a sǝl haru kumnggitghǝn mahan. ");
INSERT INTO hwo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wum teena nda tǝ fingya fatakkwaya Yeeso, ɗǝf teena nda tǝ tsahad fa thlǝngya Yeeso ha tǝ tsau ɗǝɗemnggirha tǝ ndan hu kyang nda mburodi hai tǝ hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ko wunni tǝrǝm Faara nǝn, ƙǝsǝr fathlǝnggini a ǝna ǝnwuteengya hangga. ");
INSERT INTO hwo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Fa takkwaya Yeeso tsawa nda a mbǝrha tal ndǝghang ngganda ǝnggindan hai na nanda tǝghǝn ha heu. ");
INSERT INTO hwo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Heng ngganda ǝnggindan ɗǝ ndǝghang wuɗǝɓǝlghǝnda a fiya na tǝ ɓillarha. ");
INSERT INTO hwo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ka fad ɗathla mbǝrha fa hai na nda ɗǝfang shilee Faara teena ahu Ƙǝn Faara na a Urshalima. Na nda narha wumnda hai ahur wurayindan na nda a kyang mburodi hai hǝb ǝnnarhami nda tǝ wutsǝfayirha tǝ hura tal. ");
INSERT INTO hwo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na nda narha fal Faara nagha shili ndan sǝ a fad fiya heu. Ka parra fara fa na Chinǝm narha chighang fingya kanda walgha hǝrǝkrha. Na nda narha fal Faara nagha shili ndan sǝ a fad fiya heu. Ka parra fara fa na Chinǝm narha chighang fingya kanda walgha hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na farɗa sǝ nda Mbiturus tǝ Yahaya kanda ɗiye a Ƙǝn Faara ɗǝ na manggǝn a sayid hwanda na fiya ǝnaarha yi yarra yanfaara hai. ");
INSERT INTO hwo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndusang nanda Ƙǝn Faara fa na a Urshalima, na niifa sǝ sǝfǝnda ka nggǝttǝghǝn hai na nda narha ɗǝfang nda a kwatkirǝm Ƙǝn Faara na manggǝn na nda aarha “Kwatkirma na ngga,” ka nagha a hwanang nda fiya na kyarha a pǝpal Ƙǝn Faara ɓa na manggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nanǝn nda Mbiturus tǝ Yahaya takh nda a kyarha Ƙǝn Faara ɗǝ hwanang wuɗǝɓǝla nǝn kanda. ");
INSERT INTO hwo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nda Mbiturus tǝ Yahaya irang yirha nda fa, ndangga Mbiturus, “Ƙǝlang kan!” ");
INSERT INTO hwo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sǝfǝndǝɗi ƙǝlanggǝn kanda ngga na midghǝn sǝ a fǝrang wuɗǝɓǝla nda. ");
INSERT INTO hwo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amma ndagha Mbiturus, “Mbǝ wuɗǝɓǝla sǝ a haar na a furoyi wa. Amma ˈya nani tǝghǝn ha ndǝn niya furorha. A hu thlǝm Yeeso Ƙǝrǝsti tǝ Nadzarat, thliu sǝ wiina!” ");
INSERT INTO hwo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tǝrgha Mbiturus ƙǝs harghǝn nǝn yisǝma, thlenggǝn sǝ. A mbǝɗi tsu saryighǝn tǝ kukwathladghǝn nagha kanglang. ");
INSERT INTO hwo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Thliigha sǝ harat ishgha ƙǝt tǝ saryighǝn. Katǝranggǝn wiirha hai, kyagha ƙǝn Faara ɗǝ tǝ kanda nagha a wiirha hai tǝ pǝra sǝ, nagha a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Fiya heu naghǝn nda a wiirha hai ndǝghǝn a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kanda kǝm kukwalang ngganda hai ndǝghǝnni na tsaurha a mii kwakirǝm Ƙǝn Faara na manggǝn, na hwanda wa, tǝrgha ǝnwulteena kǝssanggǝn kanda, ka ǝnɗi naa nanda. ");
INSERT INTO hwo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na sǝfǝndǝɗi tsǝb tǝ Mbiturus tǝ Yahaya ha, fiya heu ƙǝsangga ǝnwulteena kanda mbǝna nda thlǝmandan ɓa a mbǝrha ɗǝ na nda aarha Mǝthlǝm Sulemanu. ");
INSERT INTO hwo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nana Mbiturus ndǝn kee, ndanggǝn kanda, “Nafiya Isǝrela, kama na teena wulang kun kee? Kama kǝm nun a ƙǝlang kan kǝla tǝ sǝsǝmnda alten nan ni nduwa ka takkwa nan Faara ngga ndǝn ǝnagha ndǝn na kamshiɗi a wiirha ya wa? ");
INSERT INTO hwo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Faara yi Ibrahim tǝ Ishaku tǝ Yakubu, Faara yi chichiyinǝm ndǝghǝnni manangga mafadghǝn Yeeso ndǝn ƙǝnangga niifɗiya. Yeeso ɗani fǝr nun ka a ɓǝlang ngganda, kar nun a mbed Mbilatus, na midghǝn sǝ kwang a kalghǝnǝn hai. ");
INSERT INTO hwo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Karɗun tǝ Peɗǝnda tǝ, tǝ nggayirha fa, a meghedghǝn kaɗa kalla niifɗa nun hai na ɓǝl farha. ");
INSERT INTO hwo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɓǝlanggun tǝ fǝr yibrha, amma thlengga Faara sǝ hu mǝrra. Kan ni ƙǝm nagha ndǝn!” ");
INSERT INTO hwo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“A hu fǝrƙǝkafekirha hu thlǝm Yeeso, ndǝn walna niifɗi ƙǝnda ya, kun ƙǝm ˈwaɗun teena sǝnɗun sǝfǝnggidghǝn sǝ. Fǝr ƙǝkafek hu thlǝm Yeeso ndǝn ƙǝnangga a yid nun.” ");
INSERT INTO hwo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nanǝnya shayina, sǝnɗisǝ ˈya ǝna nun kun tǝ mamnggid nun a Yeeso ka yamid sǝnda ni. ");
INSERT INTO hwo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amma Faara nǝghǝn a lǝɗang nda ǝngya ndana annabiya aten Ƙǝrǝsti tǝ ndaarha nǝn tǝta ni na sǝsarha aten ǝngginiya. ");
INSERT INTO hwo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nanǝn ya malaman ɗimiyid nun, kyakhrun a thlǝmad Faara ɓa, tǝna nda tsaɓang ɗimiyid nun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na farghǝn ɓayi ɓana Chinǝm hunang hur nun hai. Nǝn a nggǝr thlǝnang Yeeso kun hai, Ƙǝrǝsti wur nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tǝtani a tsauka a talara, pa ɓagha sayid ɗaɓa nanda a wuɗang ǝnggina ɓa heu ndana Faara a mii annabiya tǝ peɗǝnda ƙǝtǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndagha Musa, “Chinǝm, Faara nun nǝn a thleng annabi kun sǝ ƙǝla nggi ahur nafi nun. Kaaman thlǝmarha fa ahu ǝngya nǝn a pǝrang kun heu. ");
INSERT INTO hwo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kala niifa kargha kang thlǝmarha annabi ɗa fa ya na nda a ndǝghang hai tǝ nafiya Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ka aten Samaila ɓa, annabiya heu thlǝk nda ǝnggini na a katǝrarha hai a weeriya. ");
INSERT INTO hwo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kun chichiiya annabi yina ni, nuwun sǝ ƙǝm ahu ɗǝf mii ɗi ndangna Faara chichiyi nun. Ƙǝsǝr ndangga Faara Ibrahim, “A fad chichiyiwa na nafiya ƙǝshiirha a wal parka.” ");
INSERT INTO hwo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Thleng na Faara mafadghǝn sǝ, ˈwaghǝn thlǝnanggǝn kun ɗǝ Isǝrelaya, ka a fǝrang parka nǝn kun, kyakhrang nǝn kun ɓa ahu tar ɗimiyid nun.” ");
INSERT INTO hwo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nana Mbiturus tǝ Yahaya a kalang fiya sǝ, fingya firistaya yi Yahudaya, tǝ mamnda fa ƙǝla Ƙǝn Faara ha na manggǝn, tǝ fingya sadukiyaya ɓa nda wal kanda. ");
INSERT INTO hwo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mamnggini ya ɓillad nda kaan ka nana Mbiturus tǝ Yahaya a tsahang fiya ha tǝ ndaarha ahu thlǝm Yeeso na thliirha sǝ tǝ yibrha ahu mǝra. ");
INSERT INTO hwo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ƙǝsang ngganda kanda, nanǝn tsǝ figrha hai muwang ngganda kanda a ƙǝnɗǝ ƙǝl a tsar. ");
INSERT INTO hwo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amma fiya hangga sǝkka laɓar ndan fǝr nda ƙǝkafek, chikka hang nda hǝshya takh nda a sǝl haru kumnggitghǝn tuf. ");
INSERT INTO hwo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɗalthna mbǝrha hai mamngya Yahudaya heu tǝ shingya tǝ fa malǝmngya ngyakhrha wuma nda hai a Urshalima. ");
INSERT INTO hwo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanana mamnda firis na manggǝn a mbǝɗi, tǝ Kayafa, tǝ Yahaya, tǝ Aledzanda, tǝ fingya hurfaya firis na manggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kyang ngganda nda Mbiturus ɓa tǝ Yahaya tsahang mee nda kanda, “Tǝ tur yanggi sǝsǝmnda, nduwa ƙǝm tǝ thlǝm wun ǝnanun ǝnɗiya?” ");
INSERT INTO hwo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tǝrgha Mbiturus lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda ndanggǝn kanda, “Kun mamngya tǝ shingya chehweed nǝm, ");
INSERT INTO hwo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nun a tsahang mee kan ka ǝna nan ˈya ngga aten sǝfǝndǝɗi ya wa? Na min nun sǝ a sǝn kwaman ɗa nun walnǝn ƙǝnda wa? ");
INSERT INTO hwo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ngwa pǝrang nggǝni kun a pǝpal tǝ nafiya Isǝrela heu, tǝ ndaarha wal nǝn ƙǝnda tǝ sǝsǝmnda thlǝm Yeeso Ƙǝrǝsti tǝ Nadzarat. Niifɗa ni tawang nun ɗǝ, thleng na Faara sǝ ahu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Laɓar Yeeso ni thlǝk na nda ahu ɗeleewar Faara, nda nǝn, Ferɗi kar na fa tǝngya, ndǝn tsauka fer sar ƙǝnna. ");
INSERT INTO hwo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mbǝ wal hǝrǝkrha sǝ a ki niifa pak wa! Mbǝ thlǝma sǝ ahu ƙǝshiirha fǝr na nda a fiya, nǝm wal hǝrǝkrha sǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wulangga teena mamnggini ka nana nda hǝhasyid nda Mbiturus tǝ Yahaya. Sǝnda sǝ ƙǝm fathlǝnggini sǝri ya pakhtǝɗuya ni, karatawa nda wa. Ɗal teena nda hai kaar na nda tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amma na nanda a na niifɗi ƙǝnang nanda ƙǝt a thlǝman ndan, mbǝ ˈyasǝ na nda mbang thlǝkrha wa. ");
INSERT INTO hwo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A mbǝɗi kee ndang ngganda nda Mbiturus tǝ Yahaya a mal ƙǝnɗa nda. Tǝrgha kokhnayini ndang ngganda ndan, ");
INSERT INTO hwo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ma nǝm a ǝnaarha tǝ nafiniya? Mbǝm ngaala tǝ ndaarha ǝnawa nda ǝnwulteena wa, fiya heu a Urshalima sǝnda sǝ kee. ");
INSERT INTO hwo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma a nggǝr nda pǝr laɓarɗiya wa, tama ƙǝs thlǝman ndan nǝm a nggǝr nda pǝr laɓara ahu thlǝm Yeeso wa.” ");
INSERT INTO hwo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tǝrgha aah fathlǝnggina nda ɓa ndang ngganda kanda a nggǝr nda kala sǝ tǝ ƙǝm tsaha nda ha ahu thlǝm Yeeso wa. ");
INSERT INTO hwo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma Mbiturus tǝ Yahaya nggǝrang ngganda kanda sǝ ndanda, “Tamnggun ndaarha na mid Faara sǝ a fǝrang mamnggirha nan kun ama ndǝghǝn wa? ");
INSERT INTO hwo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mban tam malang pǝr ˈya na nan tǝ sǝk nan wa.” ");
INSERT INTO hwo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nggǝr nanda yiyang thlǝmaarha kanda teena, kal kanda nda hai. Wulangga kwamana kanda na a tsǝtsǝl kanda nda, ƙǝsǝr fiya heu kanda a fal Faara aten ǝnɗi katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Niifɗi kǝnang nanda tsauka ǝnwulteena huradghǝn kalɗǝ kumnggit faɗa. ");
INSERT INTO hwo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kal na nda kanda hai, Mbiturus tǝ Yahaya ɗǝnda thlǝma fingya fatakkwaya ɗǝ pǝrang ǝnggina nda kanda ndana mamnda firistaya tǝ shingya. ");
INSERT INTO hwo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sǝk nanda palthɗi, tǝrangga fatakkwayini urad ndan sǝ ka a hwan Faara nda, ndaa nda, Chinǝm sani na tǝ ngyakhrha ha ǝnagha talara tǝ hweeɗe, wuri aama tǝ kǝm ǝngya heu na ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ka ƙǝtǝm thlǝkna pathla Sǝsǝna tǝ Peɗǝnda tǝ mii mafadwa Ndauda na chichid nan, tǝ ndaarha, “‘Kama na nafiya mbuwa Yahudaya tǝ sǝbrha hura? Kama na nda a mbǝtta hai aten numad ǝngya ka? ");
INSERT INTO hwo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kutǝrya ƙǝshiirha ngwanda fa ka yanda, Wum kutǝrya hai na nda a tsan Chinǝm tǝ Ƙǝrǝstidghǝn.’” ");
INSERT INTO hwo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hirdus tǝ Mbuntus Mbilatus tǝ fiya mbuwa Yahudaya tǝ nafiya Isǝrela ahu wupǝri ɗiya wumang nda tendan kar nda mafadwa Yeeso tǝ pǝɗǝnda, wurna na. ");
INSERT INTO hwo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ƙǝkafek, kala ˈya ǝna nanda nǝghǝn tǝ sǝnduwa ƙǝla ndana ka ƙǝtǝm nǝn a katǝrarha hai tǝ sǝsǝmnggit wa tǝ nggǝmnduwa ƙǝmɗa. ");
INSERT INTO hwo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Nanǝnya, Chinǝm suwu mbǝlfed ndan, fǝrang kanlanggirha kan mafayiwa na a pǝr laɓar wa nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pǝpǝnang harwa ɗǝ yi sǝsǝmnda ƙǝnda, tǝ kǝm yi ǝna ǝnwuteengya ahu thlǝm mafadwa Yeeso tǝ Pǝɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","A kwasamadɗi hwan na nda Faara, mbǝɗi na nanda sǝ rǝbgha fa, na nda heu lǝlǝgɗa tǝ Sǝsǝna tǝ Pǝɗǝnda. Tǝrgha pǝr laɓar Faara nda tǝ kanglang nggirha. ");
INSERT INTO hwo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fatakkwayini heu hur ndan tǝ numad nda tal ni. Tǝ ƙǝm ˈya nana nda tǝghǝn ha mbǝ niifa ndaarha yighǝnni katenggǝn wa, na nda ndǝghang nda ǝnggindan hai a pathlang ndan. ");
INSERT INTO hwo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Fa thlǝnggini tǝ sǝsǝmnda pǝr nanda laɓar thlid Chinǝm Yeeso sǝ ahu mǝrra, mamnggit nggayid Faara nagha aten kowunni ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mbǝ yamirha sǝ a fandan wa, ƙǝsǝr nafiya na tǝ pǝpalya tǝ wuraya ha heng nda kanda ɗǝ ");
INSERT INTO hwo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɓa nda ɓa tǝ, tǝ wuɗǝɓǝlɗi fǝranggǝnda fathlǝngya ndǝghang nggǝnda nafiya mbuwa tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ƙǝla, Yisufu, na fa thlǝngya aarha Mbarnaɓa, ndǝna wan tǝ shik farha. Tǝ Lawirha ni ɓaghǝn ɓa a Sayifurus. ");
INSERT INTO hwo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na pǝpal ghǝn sǝ henggǝn ɗǝ ɓagha ɓa tǝ wuɗǝɓǝlghǝn fǝranggǝnǝn fathlǝnggini ndǝghang nggǝnda nafiya mbuwa na ˈya sǝ a har ndan. ");
INSERT INTO hwo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na niifasǝ thlǝmnggǝn ni Hananiya, thlǝm nukkun ƙǝm Shafratu, henggǝn pǝpal ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tǝ sǝnda nukkun sǝ, ɓǝɓee nda ha ahur wuɗǝɓǝlɗi a altenggǝn. Amma ɓagha ɓa tǝ tahadghǝn ɗǝfanggǝn hai a mbed fa thlǝnggini. ");
INSERT INTO hwo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tǝrgha ndagha Mbiturus, “Sa Hananiya, kama nda na malang nda Sheetan kyagha hurwa hai, na nggaɓang nda Sǝsǝna tǝ Pǝɗǝnda fa na ɓǝɓeng nda tahad wuɗǝɓǝl hedɗi a alten wa. ");
INSERT INTO hwo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kapa na hengɗǝ mbǝ yiwa ni wa? A kwasamadɗi heng naɗǝ kǝm, wuɗǝɓǝlghǝn mbǝ yiwa ni ǝna taara na sǝ ƙǝla na midwa wa? Kama na ǝna ǝnɗiya kee? Mbǝ kanni nggaɓangna fa wa, amma a Faara ni.” ");
INSERT INTO hwo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Sǝkna Hananiya pathɗiya, fǝlgha hai mǝrgha, nafiya heu sǝkka ndǝn kǝm ƙǝsangga hǝrenga kanda. ");
INSERT INTO hwo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Thliigha wundǝlaya ɓa faɗang ngganda tǝ kaɓad pa mǝrra tǝrangganda ɗa nda pang nda. ");
INSERT INTO hwo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsǝɓaku kyagha nukkun ɓa, kula ndǝghǝn sǝn ǝnɗasǝ katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tsahangga Mbiturus mee, “Pǝrekǝn, sa tǝ Hananiya ǝnɗa wal nun ahu pǝpalɗi heng nun ɗǝ?” Ndǝghǝn, “Nǝghǝn kee.” ");
INSERT INTO hwo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tǝrgha ndangga Mbiturus, “Kama nun numa ˈya kiya wumanggun mee ka a ƙǝƙǝranggun Sǝsǝn Chinǝm? Kulo! Sar nafini pangga chimadwa a kwatminda, nanda a tǝrorha ƙǝshaaɗǝ kǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A mbǝɗi tsu kee fǝlgha hai a mbendan mǝrgha. Ɓana wundǝlayina ɓa, ɓa nda walghǝn mǝmǝra tǝrang ngganda ƙǝshaaɗǝ ɗa nda pang nda tsau tǝ chimadghǝn fa. ");
INSERT INTO hwo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ƙǝsgha hǝreenga fatakkwaya Yeeso heu tǝ fingya sǝkka laɓarɗi. ");
INSERT INTO hwo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Fa thlǝnggini ǝnanda ǝnsakhkya tǝ ǝnwuteengya hangga kyadgha sǝsǝmnda Faara. Fa fǝrƙǝkafekkya ƙǝtsar na nda naarha wumnda hai ahu Ƙǝn Faara na manggǝn a mbǝrha na nda aarha, Mǝthlǝm Sulemanu. ");
INSERT INTO hwo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mbǝ niifa sǝ a ƙǝshi na midghǝn wum teena tǝ kanda wa, ko nanǝn fiya a fǝrang mamnggirha kanda. ");
INSERT INTO hwo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hǝshya tǝ nishya hangga katǝrang ngganda fǝrƙǝkafek hai a Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ƙǝsǝr ka ǝnwultenggini ǝnana fa thlǝnggini, nagha fiya a kyang haaya ɓa hunang ngganda kanda hai a mii kwamana fingya ahu sǝrya tǝ ɗǝnggǝlya tǝna shishingnda Mbiturus ɓarha ten fingya ɓa a na ɗǝ a mbǝraɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Fiya hangga wumngga hai ɓagha nda ɓa ahu talya na tsǝtsau tǝ Urshalima fa, kanda a ɓarha ɓa tǝ haya, tǝ fingya na tǝ ǝnkaheeya fa, kanda heu wal nda ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tǝrgha firis na manggǝn tǝ nafiyighǝn heu na nanda tǝ kanda, nafiniya Sadukiyaya ni na nda a sǝrghang fathlǝnggini fa. ");
INSERT INTO hwo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ƙǝsang ngganda kanda, muwang ngganda kanda ahu porsǝna ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amma a fiɗikrha ɓagha tǝthlǝnda Chinǝm ɓa inanggǝn kwatmingya porsǝn ɗa ɗǝ, kyanggǝn kanda hai. Tǝrgha ndanggǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ɗaama ahu Ƙǝn Faara ɗǝ na manggǝn ɗun pǝr laɓar weerǝnda yiɓǝdɗiya a fiya!” ");
INSERT INTO hwo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɗalthna mbǝrha hai, fathlǝnggini kya nda ahu pǝpal Ƙǝn Faara ɗǝ na manggǝn ƙǝla thlǝghang na tǝ thlǝnda Faara kanda. Katǝrang ngganda tsaharha ha. Firis na manggǝn tǝ fingya nanǝn tǝ kanda aah kognaya nda ɓa heu tǝ shingya Isǝrela. Tǝrgha thlǝn farha nda ahu porsǝna ɗǝ ɗa nda ɓarha ɓa tǝ fathlǝnggini. ");
INSERT INTO hwo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amma sǝlna nafina ɗǝ thlǝn nanda ɗuwa nda wal kanda a kǝn porsǝnɗi wa, wuɗa nda thlǝmad mamnggina ɗǝ ndaa nda ");
INSERT INTO hwo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ɗǝ ɗan ɗǝ ɗan wal kwatmin porsǝnɗi chicha, fa ƙǝlaya ha ƙǝƙǝt a mii kwatkirǝm ɗi. Amma inang nan hai kyanan saɗǝ, walwan niifa sǝ wa!” ");
INSERT INTO hwo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sǝkna mamnda fa Ƙǝn Faara ha tǝ mamngya firistaya kee, tǝrgha wulangga teena kanda tǝna mii ngwala ǝnɗi a ǝnaarha ƙǝn ya. ");
INSERT INTO hwo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tǝrgha ɓagha niifa ɓa ndanggǝn kanda kulo nafini muwang nun kanda ahu porsǝna ɗǝ ƙǝƙǝt a pǝpal Ƙǝn Faara na manggǝn kanda a tsahang fiya ha. ");
INSERT INTO hwo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tǝrgha mamnda fa kǝla Ƙǝn Faara ha tǝ nafiyighǝn ɗǝnda ɗǝ ka a ɗanda ɓarha ɓa tǝ fa thlǝnggini. Amma mbǝ tǝ kanglanggirha wa, kanda a tǝrǝmnda na ɗǝ fiya muk kanda tǝ ferya. ");
INSERT INTO hwo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tǝrgha ɓa nda ɓa tǝ fathlǝnggini isha nda a mbed kognaya ka a tsahangga mamnda firistaya mee kanda ha. ");
INSERT INTO hwo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ndangganda kanda, “Yanang ɗan kun a pǝpal tǝ ndaarha a nggǝrɗun tsaharha ha tǝ thlǝmɗiya wa, amma kulo hai tsahang ɗun fiya ha hangga a Urshalima, har kun a puwang hakked mǝrra niifɗi kan fa ɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amma Mbiturus tǝ fingya fathlǝngya nggǝrang ngganda kanda sǝ ndaa nda, “Tǝtani a fǝrang mamnggirha nan Faara ama ngyakhrha niifa. ");
INSERT INTO hwo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Faara yi chichi yinan thlengga Yeeso sǝ ahu mǝra, a kwasamadɗi ɓǝlang nun ahu taurha ɗǝ aten kaɗiirha. ");
INSERT INTO hwo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tǝrangga Faara a yisǝmadghǝn ɗǝ, tsawanggǝn mamnda tǝ kǝm tǝ hǝrǝkrha, ka a inanggǝn kwaman chakh ɗimiyirha ɗǝ tǝ chakh ɗimiyirha a nafiya Isǝrela. ");
INSERT INTO hwo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kan kǝm naɗan ǝngginiya ƙǝkafek ni, na Sǝsǝna tǝ Pǝɗǝnda kee kǝm, fǝrang na Faara nafiya na sǝk mighǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sǝkna ndan kee, sǝbgha hur ndan ɗǝ kaan na mindan sǝ a ɓǝlang ngganda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma tǝ farisarha sǝ ahur ndan na thlǝmnggǝn Ngamaliya, tǝmalǝmnda ɗǝlewar ngyakhrha Musa, na fiya heu a fǝrang mamnggirha thliigha sǝ ahur kogna yini ndagha a kyagha nafini ƙǝshaaɗǝ ˈwan. ");
INSERT INTO hwo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tǝrgha ndanggǝn kanda, “Kun nafiya Isǝreela, kwarama tǝ ǝnɗi na minnun ǝnaarha a nafini ya! ");
INSERT INTO hwo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Huraya mbǝrgha ɗǝ na niifa sǝ kyagha ɓa na nda aarha Tudas, tsawanggǝn altenggǝn ƙǝla manda niifa. Nafiya takkwagha ndǝn takh nda a sǝl haru kumnggit faɗa. Amma ɓǝlang ngganda, weleng ngganda fa takkwayighǝn ɗǝ, tsauka mii ngwalan ndan ni. ");
INSERT INTO hwo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","A kwasamadghǝn kǝm a sayyid thlǝtta fiya, Yahuda tǝ Nggalilarha kyagha ɓa lǝm fiya nǝn fa mbusamadghǝn nda, ndǝghǝnggima ɓǝlang ngganda, nafiya heu mbuwa samadghǝn weleng ngganda kanda hai.” ");
INSERT INTO hwo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Nanǝnya, niya pǝranggǝn kun kalama nafina hai ya, malaman kanda wii nda, ana numandan tǝ tar ndan yi farha ni mbǝ tǝra hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma ana numandan tǝ tar ndan yi Faara ni mbǝ kwamana sǝ a ˈyaɗanggunun nafina fa ya wa, nun a wal altennun kee a yanda tǝ Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Palthɗi keeghǝn tsuwarɗǝ kanda tǝrgha aah fa thlǝnggina nǝn ɓa, tsaɗa kanda nǝn. Tǝrgha ndangganda kanda ma nggǝr nda ndikrha tǝ thlǝm Yeeso wa, a mbǝra kal kanda nda hai. ");
INSERT INTO hwo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tǝrgha thliigha nda sǝ a mbed mamnggini na nda a na wutsǝfayirha tǝ ndaarha tsǝk nda a sǝsanda ka thlǝm Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ka fad ɗathla mbǝrha fa hai na nda narha ɗǝrha a Ƙǝn Faara tǝ ƙǝm kya nda wure-wure na nda a tsaharhaha tǝ pǝr laɓar Faara tǝ ndaarha Yeeso ndǝna Ƙǝrǝsti wa. ");
INSERT INTO hwo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A far yini na fatakkwaya Yeeso aten chikrha, tǝrgha fingya Yahudaya na a ndik mii Helenaya na a huhurumnda aten Yahudaya na a ndik mii Aramaya tǝ ndaarha mba nda ɗang nu mǝr yindan sǝ hu ndǝk ǝnnarhami wa. ");
INSERT INTO hwo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tǝrgha fathlǝnggini kumkap sǝriɗi wumang ngganda fa takkwayina ɓa heu ndaa nda, “Mǝmǝlwa wa na a mal pǝr laɓar Faara nǝm, kyam hu tar ndǝk ǝnnarhami ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nanǝn ya wanmanggina, wurama hǝshya mǝd ahur nun na lǝlǝgɗa tǝ Sǝsǝna tǝ kǝm na tǝ huteena fa. Nǝm a fǝrang tarɗi kanda ya ");
INSERT INTO hwo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ƙǝm ɗǝm mbeeɗǝ tǝ hwan Faara tǝ tsahad laɓar Faara ha.” ");
INSERT INTO hwo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Palthɗi thlǝk nanda mɓenanggǝn fiya heu wumngga hai, wur nafina nda ya: Istifanus, niifa ni na tǝ fǝrƙǝkafek fa lǝlǝgɗa tǝ Sǝsǝna tǝ Pǝɗǝnda, tǝ Filibus, tǝ Mburokoras, tǝ Nikano, tǝ Teman, tǝ Mbarminas, tǝ Nikalas niif Antakiya mbǝ tǝ Yahudarha ni wa amma kyagha hu takkwa Yahudaya hai, nanǝn ya tsauɗǝ ƙǝrǝsta. ");
INSERT INTO hwo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nafini mǝd ya kyaɗang nggǝnda fa thlǝnggini hwan Faara nda ɗǝfang haara nda kanda teena. ");
INSERT INTO hwo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Welgha laɓar Faara a mbǝya ɗǝ hangga. Nagha fatakkwaya a chikrha kaan a Urshalima, tǝ ƙǝm firisya hangga yi Yahudaya fǝrgha ƙǝkafek tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanus nǝghǝn lǝlǝgɗa tǝ nggayid Faara tǝ sǝsǝmnda ƙǝm, ǝnaɗǝ ǝnwultengya tǝ ǝnsakhkya hangga ahur fiya. ");
INSERT INTO hwo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amma farɗa sǝ fingya nafiya ahu Ƙǝn Faara ɓa na ngguchit na nda aarha yi fiya hǝrghang nanda kanda hu mafayirha, katǝrang ngganda ngaala hai tǝghǝn. Na Yahudaya sǝ ɓagha ɓa a Sayirin tǝ Aledzandǝriya tǝ kǝm chehweed Kilikiya tǝ Asiya. ");
INSERT INTO hwo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mbusǝ ahur ndan na mbang tsan huten Istifanus tǝ Sǝsǝn Faara na atenggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tǝrgha shighang ngganda fingya fa ɓǝɓee a nggaɓang ngganda Istifanus fa tǝ ndaarha, “Sǝkɗan ndǝn a ndik laɓar sar farha a Musa tǝ Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Thlenggǝn hur fiya, tǝ shingya tǝ fa malǝmngya ɗeleewar ngyakhrha Musa. Ƙǝsang ngganda Istifanus ɗǝnda teghǝn a mbed kognaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nggaɓang ngganda fa tǝ ndaarha, “Niifɗiya ƙǝtsar nǝn narha thlǝk ˈya ɗimi aten kǝn hwan Faara na manggǝn tǝ kǝm ngyakh Musa. ");
INSERT INTO hwo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ƙǝsǝr sǝk ɗan ndǝn a ndaarha Yeeso tǝ Nadzarat nǝn chang Ƙǝn Faara hai na manggǝn tǝ kǝm mbeɗenggǝn ǝntin Musa hai malang nanda ƙǝm hai.” ");
INSERT INTO hwo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kogna yini heu irang yirha nda Istifanus fa, ƙǝsǝr pǝmnggǝn nǝghǝn a chimnda fa kǝla yi tǝthlǝnda Faara. ");
INSERT INTO hwo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tǝrgha Firis na manggǝn yi Yahudaya tsahang mee nǝn Istifanus, “Palth yiniya ƙǝkafek ni wa?” ");
INSERT INTO hwo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nggǝmangga Istifanus ndǝghǝn, “Wan manggina tǝ chinggina, keema thlǝmaarha fa! Faara tǝ mamnggitghǝn ɗǝɗǝ thlǝmad chichid nǝm Ibrahim ɗǝ ndǝghǝn ɓalɗǝ a Mesopotamiya kapa nǝn ɗǝrha Haran ɗǝ tǝ tsaurha.” ");
INSERT INTO hwo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ndangga Faara, “Malang chehweed nggǝttǝwa tǝ hurfayiwa, ɗǝnna ahu chehweed ɗaɗǝ niya saworha.” ");
INSERT INTO hwo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nanǝn kee malangga Ibrahim chehweed Kaldiyayini tsauka a Haran. A kwasamadɗi mǝrna chin, thlǝnangga Faara ahu chehwedɗa ɓa mbǝɗi nanun sǝ tǝ tsaurha ya. ");
INSERT INTO hwo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amma Faara fǝrangwa langaarha a mbǝɗiya wa, ko ɗǝf saara tal yi chehweerha. Ɗǝf Faara miighǝn a ndǝghǝn tǝ chichiyighǝn na ɓayi a samadghǝn nǝn a fǝrang chehwedɗi kanda ko nanǝn mbǝ wanggighǝn sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ndangga Faara Ibrahim, “Na chichiyiwa a tsaurha ahu chehweerha pak, ǝna tar mafayirha nda sǝsangganda kanda yi hurarha haru faɗa. ");
INSERT INTO hwo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amma niya sǝsang chehwedɗi kyangga kanda ahu tar mafayirha hai, a kwasamadghǝn na nda a kyarha sǝ fǝree mamnggirha nda a mbǝɗiya.” ");
INSERT INTO hwo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Faara ƙǝm fǝrang ɗǝf mee nǝn Ibrahim yi thlee muwa a farɗi. Nanǝn tsauna Ibrahim chin Ishaku, thleng muwa nǝn a far ɓeena wuvaɗa. Tsauka Ishaku chin Yakubu, tǝ ƙǝm tsauka Yakubu chin chichiiya Isǝrela kumkap sǝri.” ");
INSERT INTO hwo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ƙǝsǝr chichiiyini na nda a sǝrghang Yisufu fa, hengganda a Masar ɗǝ ƙǝla mafarha. Amma Faara nǝghǝn tǝghǝn ha ");
INSERT INTO hwo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kyanggǝn sǝ ahu ɓilladghǝn heu. Fǝrang sǝnda nǝn Yisufu tǝ ƙǝm nagha fadghǝn pet a mbed Firˈauna kutǝr Masar; nanǝn kee faɗangga Firˈauna tsauka ngwamna hu chehweed Masar tǝ ƙǝm mamnda ahu wuri kutǝryidghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tǝrgha miirha kyagha hu chehweed Masar hai tǝ yi Kanˈana. Nagha sǝsaarha sǝ kaan, tǝrgha chichiyinǝm ngwalagha ǝnnarhami hai a haar ndan. ");
INSERT INTO hwo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sǝkna Yakubu ndaarha ɓalgha hwarma sǝ a Masar, thlǝn wanggighǝn nǝn ɗǝ ɗa nda hiirha ɓa, kanda tsauka chichiyinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wuttǝ ndan ɗǝ yi sǝri, Yisufu chalmang fadghǝnǝn wan manggighǝn, kyaɗang wanmanggighǝn nǝn Firˈauna. ");
INSERT INTO hwo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tǝrgha Yisufu thlǝngga ɗǝ a chin, Yakubu, tǝ hurfayighǝn a ɓa nda a Masar ɓa, kanda heu kumggit mǝd kap tuf. ");
INSERT INTO hwo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tǝrgha Yakubu ɗǝgha Masar ɗǝ. Mǝrgha a mbǝɗi ndǝghǝn tǝ chichiyinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mǝr yindan tǝrangganda kanda a Shekem ɗǝ pangganda kanda ahu kwadɗi hiina Ibrahim a haar wangya Hamor. ");
INSERT INTO hwo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nduwusna sayidɗa ɓa na Faara a lǝɗang nda ˈya ndanǝn a Ibrahim, hang nda nafinǝm a Masar chikka kaan. ");
INSERT INTO hwo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tǝrgha nggǝrgha nda ǝna kutǝra a pak a Masar sǝngwaa Yisufu. ");
INSERT INTO hwo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kutǝr ɗiya huk ɗǝ nafinǝm nagha a ngyaɓang nda fa nggǝtya a muwangganda wufar waya ɗǝ nggǝt nanda ka a mǝra nda. ");
INSERT INTO hwo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","A hu sayidɗi nggǝt nda Musa, wundakhne ngga a yid Faara. Ƙǝrghǝna fa nggǝtyighǝn ahur minda yi ndǝree mahan. ");
INSERT INTO hwo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɗǝfang nanda a ƙǝshaaɗǝ, malghǝnda wutarad Firˈauna tǝranggǝn ƙǝrghǝnǝn tsauka yighǝn. ");
INSERT INTO hwo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsahang thladwayid Masarya nda Musa ha heu, ndǝghǝn nggi ƙǝm nǝghǝn tǝ sǝsǝmnda fa hu laɓara tǝ ǝn ǝnadghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tsǝna Musa hurarha kumggit faɗa, na midghǝn sǝ a weng tala nǝn nafiyighǝn, nafiya Isǝrela. ");
INSERT INTO hwo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na wan tǝ Masar nǝn a ɗǝghang nda tǝ Isǝrela ɗǝ. Ɗǝgha ɗǝ ɗanggǝn tǝ Isǝrela ɗa sǝ, ɓǝlanggǝn tǝ Masar ɗi. ");
INSERT INTO hwo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tamngga Musa ndaarha na nafiyighǝn a sǝnda sǝ tǝ ndaarha na Faara a ǝna taara tǝghǝn ka a hǝrghanggǝn kanda, amma sǝngwa nda sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ɗalthna mbǝrha hai nggǝrghǝn weng tala kanda fadɗǝn ɗǝgha wal Isǝrelaya sǝri a kanda ndan a yanda. Midghǝn sǝ a ndǝghanggǝn kanda hai, ndanggǝn kanda, “Kun nafiniya, nuwun a wanmanggi. Kama nda nun a yanda tǝ ndan?” ");
INSERT INTO hwo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Amma yanɗi na a ɗǝghang nda shadghǝn ɗǝ puwanggǝn Musa man patu ɗǝ ndanggǝn, wunni tsawowa kutǝra nan, tǝ ngwa kumarha aten nan? ");
INSERT INTO hwo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na a ɓǝleerha ƙǝla ɓǝlang na tǝ Masar ɗi ɓǝrarha wa?” ");
INSERT INTO hwo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sǝkna Musa ndǝn kee, ɗaagha mal chehweed ɗa nǝn ɗǝgha tsau ronggirha a chehweed Mediyan nggǝt wangya hǝshya nǝn sǝri a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“A kwasamad hurarha kumnggit faɗa, tǝthlǝnda Faara ɓagha thlǝmad Musa ɗǝ ahu ƙǝssa waarha ahu ɗǝfrha ngguchit a kaheerha na tsau tǝ wumnda Sǝnai fa. ");
INSERT INTO hwo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nanǝn ndǝn kee, ƙǝsgha ǝnwulteena ndǝn a mbǝɗi. Nduwus nǝn ɗǝ ka ɗǝgha ƙǝlang nda, sǝk urad Chinǝm nǝn, ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nggini Faara yi chichiyiwa, Faara yi Ibrahim, tǝ Ishaku tǝ Yakubu.” Tǝrǝmngga Musa nagha fadghǝn a rǝprha fa, nggǝrwa fadghǝn ndang nda a ɗǝgha ƙǝlang nda ɓal wa. ");
INSERT INTO hwo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Tǝrgha Chinǝm ndanggǝn, Ƙǝɗang paham wa hai, ƙǝsǝr ishgha a mbǝd tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naɗi sǝsadɗi na nafina a saarha fa a Masar. Sǝkɗi tendan ndǝn ɓani ɓa a ɓi hǝrghang nda kanda. Nanǝn ya ɗuwa ɗǝ, ƙǝsǝr niya thlǝn sa a wuɗana Masar ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa ɗani kar nanda tǝ ndaarha, ‘Wunni tsawowa kutǝr nan, tǝ tǝ ngwa kumad nan?’ Musa ɗani thlǝnang na Faara ɗǝ ɗǝgha tsaurha kutǝr ndan tǝ ƙǝm tǝ hǝrǝkrǝ ndan a mii thlǝnda Faara kyaɗang nǝn fadghǝn ahu ɗǝfǝdɗi ƙǝsgha waarha a kaheerha. ");
INSERT INTO hwo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kyanggǝn kanda sǝ ahur Masar tǝ ǝnsakhkya tǝ ǝnwulteengya hangga ǝnanǝn. Kyagha tǝ kanda tǝ hur wuri aama na yiɓa, tǝ ƙǝm tǝ hur kaheerha yi huraya kumggit faɗa.” ");
INSERT INTO hwo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Musa tafadghǝn ndanggǝn nafiya Isǝrela, ‘Na Faara a thlǝnang annabi kun ɓa ƙǝla nggi ahur nafi nun.’ ");
INSERT INTO hwo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na Musa ahur fiya wumngga hai a kaheedɗi, tǝ tǝthlǝnda Faara ndik ɗǝ tǝghǝn tǝ chingginǝm a Wumnda Sǝnai. Thlǝɗǝ laɓara ɓa yi yibrha fǝrang nǝn ƙǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amma chingginǝm kar nda sǝk miighǝn fa. A meghedghǝn karghǝnda fa ndaa nda ahur ndan a nggushi wudnanda a Masar ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ndangganda Haruna, Tangsang faarya ƙǝm sǝ na a naarha a mben nǝm, ƙǝsǝr sǝnggum ǝnɗi walgha Musa ɗiya wa kyangga ƙǝm ɓa a Masar. ");
INSERT INTO hwo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","41 Əna ɗaharha nda ƙǝla wan thlaarha, ǝnang sataka nda na nda a ǝna wutsǝfayirha a ǝnɗi ǝnana nda. ");
INSERT INTO hwo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tǝrgha Faara kyahargha ma kanda malanggǝn kanda na nda a fǝrang mamnggirha wufǝlngaarya na a fǝrakh amshi tsawa nda faar yindan. A hu ɗeleewar annabiya nǝghǝn chichirethlee hai, Nafiya Isǝrela, a nggini nun a ɓee satakhkya ɓa tǝ ǝn fǝrya, Ahu hurayini kumnggit faɗa a kaheedɗi wa? ");
INSERT INTO hwo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Awo, nggǝmnda hur nun nǝghǝn hu takkwa ɗahaa yinun Mbǝd paa ɗahad Molek Tǝ wufǝlngaar ɗahad Rifan, Tǝ ǝngya tak sanun tǝ har nun non a fǝrang mamnggirha kanda. Nanǝn kee niya ɗǝrha tǝ kun hu tar mafayirha ɗǝ A mbǝrha ɗǝ inggun ma Mbabila. ");
INSERT INTO hwo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Chichiyinǝm tǝrang nda cham hwan Faara a kaheedɗi. Ənagha ndan mǝmǝl ƙǝla kyaɗang na Faara Musa. ");
INSERT INTO hwo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Thlǝna nda cham ɗaɓa, chichiyinǝm na a kamu Djeshiwa tahang nda ha ɓa thlǝ nanda chehwedɗi a haar nafini mbuwa Yahudaya rǝghang na Faara kanda ɗǝ. Tsauka cham ɗi a mbǝɗi ta thlakh mbǝd Kutǝra Ndauda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Walgha Ndauda nggayirha a mbed Faara, hwanggǝnǝn na a tǝnang mbǝd tsaurha nǝn Faara sǝ yi Yakubu. ");
INSERT INTO hwo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amma Sulemanu ni tǝngga ndǝn. ");
INSERT INTO hwo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ko nanǝn kee, Faara Amshi mbǝ tsaurha ahur minda tǝnna niifa tǝ haarghǝn wa. Ƙǝla ndana annabi, ");
INSERT INTO hwo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ndagha Faara, “‘Na tsǝnggam nggina a fǝrakh amshi, Chehweerha ndǝna mbǝd ɗǝf sarna. Tsakhka Chinǝm mee, Nun mbang tǝne Ƙǝn Faara sǝ ngga kee wa? Nun mbang tǝne mbǝd yibrha sǝ kee wa? ");
INSERT INTO hwo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mbǝ tǝ haryi na ni ǝnani nda talara tǝ hweeɗe wa?’” ");
INSERT INTO hwo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kun nafiya mbuwa wa sǝk ˈya! Na huryinun kakrak mbun sǝk path ƙǝkafek wa. Pa kwanɗǝ nun narha kar Sǝsǝna fa tǝ Peɗǝnda? Chichiyinun ǝnanda kee, kun kǝm nuwun kee! ");
INSERT INTO hwo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aah ma thlǝm annabi tal sǝsangwana chichiyinun! Ɓǝlang nda fingyayini thlǝkka laɓar ɓad ka niifɗa ɓa Ƙǝrǝsti fǝr nun tǝ ƙǝm ɓǝlang nun. ");
INSERT INTO hwo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Thlǝmǝn kee kar nun ngyakhrha Faara fa, ko nanǝn thlǝwun ndǝn ɓa a haar fa thlǝngya Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ndengga mamngya Yahudayini pǝmnggindan hai ka sǝbrha hura sǝk nanda palth Istifanus. ");
INSERT INTO hwo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma Istifanus lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda, ƙǝlagha talara sǝ na kukwaryid Faara nǝn a yanda hai, tǝ ƙǝm na Yeeso ƙǝrǝsti nǝn ƙǝt a yisǝmad Faara. ");
INSERT INTO hwo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ndagha, “Kuloɗǝ, naɗi talara inɗaɗǝ haang Wan niifa ƙǝt a yisǝmad Faara!” ");
INSERT INTO hwo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tǝrgha nggǝlang ngganda thlǝmayi ndan tǝ haryi ndan na nda ahuhwaarha. Ɗa nda thlǝmadghǝn ɗǝ ");
INSERT INTO hwo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","rǝghang ngganda sǝ ma talɗi katǝrangganda mukƙǝn hai tǝ ferya. Fingya mamngya Yahudaya tsangga ndǝn ƙǝɗangganda kaɓayindan hai ɗǝfang ngganda a mbed wundǝlarha na nda aarha Shawulu. ");
INSERT INTO hwo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Muk na ndan, hwangga Istifanus Faara, “Chinǝm Yeeso, thlu yiɓǝd na.” ");
INSERT INTO hwo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ɓǝrgha hai tǝ waɗedghǝn, tǝranggǝn uradghǝn sǝ, “Chinǝm, a ƙǝsna ɗimiyid ndan ha wa!” Ndanǝn kee mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu nggǝmɗafa a ɓǝllang ngganda Istifanus. A farɗa ni katǝrana sǝsarha ɓarha ten fatakkwaya Yeeso ɓa na ahur Urshalima, wel nda hai kanda heu a chehweed Yahudiya ɗǝ tǝ Samariya. Ƙǝl fa thlǝnggini kee ndǝn takhka. ");
INSERT INTO hwo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tǝrgha fingya nafiya na a tǝrǝm Faara pang ngganda Istifanus tǝnda kaan atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amma Shawulu katǝranggǝn sǝsang fatakkwaya Yeeso hai. Na midghǝnsǝ a kwanggǝn kanda hai. Nǝn kyarha wure-wure nagha a kǝsang hǝshya tǝ nishya ka a muwanggǝn kanda ahu porsǝna ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Fingya weleng na nda kanda hai na nda narha pǝr laɓar Faara kala mbǝrha ndǝn nda saɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus ɗǝɗǝ hu wupǝri Samariya ɗǝ, pǝrɗǝ laɓar Ƙǝrǝsti a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Fiya wumngga hai hangga kang nda thlǝmarha fa ngga, ƙǝsǝr na mindan sǝ a sǝk laɓarghǝn nda tǝ ƙǝm na ǝnwuteengya nda ǝnanǝn. ");
INSERT INTO hwo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ənkaheeya hangga kyagha sǝ tǝ huhwaarha a fad fingya fiya. Fiya hangga mǝrna fandan hai tǝ sǝfǝngya wal nda ƙǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ko wunni ahu wupǝriɗi ƙǝl ǝna wutsǝfayirha ƙǝsǝr ka ǝnɗi katǝragha hai. ");
INSERT INTO hwo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na niifa sǝ a wupǝri ɗi tǝ kulaarha thlǝmnggǝn Siman nǝn ǝna ǝngya na fǝrang ǝnwulteena Samariyayini. Nǝn narha ndaarha mbǝ tǝ kallǝghǝn sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nafiya Samariya heu, yi na manggǝn tǝ na ngguchit, na nda narha ndaarha, “Niifɗiya sǝsǝmnda Faara tǝ pamǝnda ni atenggǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na nda kan thlǝmarha fa ƙǝsǝr ka ǝnwuteengya nǝn narha ǝnaarha ka ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma fǝr nanda ƙǝkafek a Filibus pǝr nǝn Laɓara na mbǝnggǝn a kanda yi kutǝryid Faara tǝ ƙǝm aten thlǝm Yeeso Ƙǝrǝsti, ǝnang mbaptisǝma nda kanda, hǝshya tǝ nishya. ");
INSERT INTO hwo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Siman tǝ tafadghǝn fǝrɗǝ ƙǝkafek tǝ palth Filibus, ǝnang mbaptisǝma nda. Katǝranggǝn mbusamad Filibus hai kala mbǝrha ndǝnǝn saɗǝ, nanǝn ǝnwulteengya tǝ ǝnsakhkya na Filibus a ǝnaarha wulangga teena. ");
INSERT INTO hwo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Fa thlǝnggini na a Urshalima sǝkna nda ndaarha nafiya Samariya thlǝnda laɓar Faara fa, tǝrgha thlǝnang ngganda nda Mbiturus tǝ Yahaya a mbǝɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sǝlna nda ɗǝ, hwanang Faara nda kanda teena na wal Sǝsǝna nda tǝ Pǝɗǝnda, ");
INSERT INTO hwo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ƙǝsǝr Sǝsǝna tǝ Pǝɗǝnda terwa tendan hai ˈwan wa, ko nanǝn ǝnang nda mbaptisma kanda hu thlǝm Chinǝm Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tǝrgha Mbiturus tǝ Yahaya ɗǝfang haara nda kanda teena, wal Sǝsǝna nda tǝ Pǝɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nana Siman fathlǝnggini fǝr nda Sǝsǝnɗi hu ɗǝf haara teena, fǝrang wuɗǝlɓǝla nǝn kanda, ");
INSERT INTO hwo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ndagha “Nggima fǝreema tur sǝsǝmndǝɗi ya, tǝnǝn narha kala niifa ɗǝfang ni haara teena wal Sǝsǝna nǝn tǝ Pǝɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amma ndagha Mbiturus, “Sa tǝ wuɗǝɓǝl wa mǝrama, tamngga ndaarha na mbang heng fǝrra Faara sǝ tǝ wuɗǝlɓǝla wa, wa! ");
INSERT INTO hwo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ma njiɗowa hu tarɗiya, ƙǝsǝr hurwa mbǝ mǝmǝl a mbed Faara wa. ");
INSERT INTO hwo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Malang tar mbǝlfed wa hwan Chinǝm na. Asǝmha nǝn choho ǝn mbǝlfedɗa ɗǝ na ahurwa, ");
INSERT INTO hwo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ƙǝsǝr naɗi sa hur wa sǝsǝɓaɗǝ tǝ ƙǝm thluro ɗimiyirha.” ");
INSERT INTO hwo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tǝrgha nggǝmangga Siman ndagha, “Hwaneema Chinǝm teena naɗǝ tal ahur ǝnggini thlǝk nun ya wal nggi.” ");
INSERT INTO hwo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","A kwasamadɗi taarang nanda Mbiturus tǝ Yahaya mbǝnda laɓar Faara fa tǝ pǝr laɓar Chinǝm, wuɗa nda Urshalima ɗǝ. A hu kwamana pǝr laɓar ɗa nda na mbǝnggǝn ahu talya Samariya. ");
INSERT INTO hwo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nanǝnya, tǝ thlǝngnda Chinǝm ndanggǝn Filibus, “Thliu sǝ turu kwamana ɗǝgha a man ki pǝlasarya ɗǝ hu kaheerha, kyagha ɓa a Urshalima ɗǝgha Nggaza ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A mbǝɗi kee thlii wiigha, ɗǝgha ƙǝmarha tǝ mamnda niifa tǝ Habasha tǝ ɗǝf wuɗǝɓǝl kwatamnda Habasha na aarha Kandis. Niifɗiya ɗǝnǝn Urshalima ɗǝ ka ɗǝgha ɗǝfang shilee Faara teena. ");
INSERT INTO hwo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nanǝn a wutta wureɗǝ tsau ahu keke pǝrshe nǝghǝn a karata ɗeleewar annabi Ishaya a tǝrang uradghǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ndangga Sǝsǝna tǝ Pǝɗǝnda Filibus, “Wiuɗǝ ɗa ƙǝsang muwa niifɗi na tǝ keke pǝrshiɗi.” ");
INSERT INTO hwo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tǝrgha Filibus ɗagha thlǝmadghǝn ɗǝ sǝk fadghǝnǝn a karata ɗeleewar annnabi Ishaya, ndangga Filibus, “Sǝnang na ǝnɗa hai na a karatarha ya wa?” ");
INSERT INTO hwo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nggǝmanggǝn, “Awo, ƙǝƙǝn ni sǝnang hai? Ƙǝl ma fǝle niifa ndǝn hai.” Tǝrgha aah Filibus nǝn a ɗǝgha tsaurha tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Niifɗi nǝghǝn a karata mbǝrha ahu ɗeleewar Faara tǝ ndagha: “Ɗǝgha nda tǝghǝn a mbǝd thlee urarha ɗǝ ƙǝla chaukhrarha. Ƙǝla na kamnda narha tib a naɗǝ tsǝb ahu haara kanda a tsaɗang wasghǝn ɗǝ, Mbangwa inang mighǝn hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kyala nda tǝghǝn, Ngwang ngwanda kumad ƙǝkafek fa wa. Mbǝ niifa sǝ mbang kala sǝ aten chichiyighǝn wa, Ƙǝsǝr tǝrang nda yiɓǝdghǝn ma ƙǝshiirha.” ");
INSERT INTO hwo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mamnda tǝ Habashaɗi ndanggǝn Filibus, “Annabi ɗiya path wun nǝn a thlǝkrha? Yighǝn wa nduwa yi niifa pak?” ");
INSERT INTO hwo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tǝrgha Filibus katǝranggǝn pǝrang laɓara na mbǝnggǝn aten Yeeso, katǝranggǝn hai a mbǝɗi karatana niifɗa sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","(Kanda ahur wiirha nduwang ngganda aama fa, ndagha niifɗi, “Kulo, aama ya. Mani a ˈyaɗe mbaptisǝma fa?” ");
INSERT INTO hwo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ndagha Filibus, “A fǝr na ƙǝkafek tǝ hurwa heu, niya ǝnorha.” Nggǝmangga niifɗi ndǝghǝn, “Fǝrɗi ƙǝkafek Yeeso Ƙǝrǝsti Wan Faara ni.”) ");
INSERT INTO hwo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Fǝr ngyakhrha nǝn a isha nda hai. Tǝrgha kanda kyab tǝra nda hai kya nda ahu aam ɗa hai, ǝnangga Filibus mbaptisǝma. ");
INSERT INTO hwo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kyana nda sǝ ahur aamɗi Sǝsǝn Chinǝm tǝranggǝn Filibus wiigha tǝghǝn, niifɗi kǝm nggǝrwa naghǝn wa, amma wii fadghǝn nǝn tǝ mbǝnafa. ");
INSERT INTO hwo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ɓa Filibus kyagha ɓa ahu wupǝri Adzotus. Fǝr laɓara nǝn na mbǝnggǝn a mbǝɗi tǝ fingya talya hangga a kwamana ta sǝlgha Kaisariya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawulu tǝ hufrha hura aten ɗǝrha mbeeɗǝ tǝ sǝsang nda fatakkwaya Chinǝm ƙǝl ɓǝlang nǝn kanda, ɗǝgha thlǝma mamnda firis ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Kaɗa ɗeleewar nǝn, ka a ɗǝgha tǝghǝn ƙǝn tsahad Yahudaya ɗǝ na a Nɗimaska, a ɗǝɗǝ wal fatakkwaya Chinǝm nǝn a ƙǝsang kanda nda hǝshya tǝ nishya, ɓagha ƙǝnang kanda a wupǝri Urshalima. ");
INSERT INTO hwo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Takh nǝn a ndusang Nɗimaska fa, djargha kukwaryirha tenggǝn hai a fǝrakh amshi hai. ");
INSERT INTO hwo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Fǝlgha hweeɗa hai sǝk urarha nǝn a ndang nda, “Shawulu! Shawulu! Kama nda na a sǝseerha?” ");
INSERT INTO hwo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ndagha Shawulu, “Wunni sa, Chinǝm?” Nggǝmangga uradɗi, “Nggini Yeeso, na a sǝsang nda!” ");
INSERT INTO hwo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Nanǝn ya thliusǝ ɗǝna hu wupǝri ɗǝ, na nda a puro ˈya na a ǝnaarha.” ");
INSERT INTO hwo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nafini na wiirha tǝ Shawulu ka ǝnwulteena na nanda mbangwa nda kala sǝ wa, kanda a sǝk urad niifa, amma mba nda a naghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Thliina Shawulu sǝ a hweeɗe, amma inang nǝn yidghǝn hai mbangwa na mana hai wa. Ƙǝs haarghǝn nda kya nda tǝghǝn hur wupǝri hai. ");
INSERT INTO hwo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Əna ɓeena nǝn mahan mbǝ namana hai wa. A hu ɓenggini ya ǝnawa ˈya mii wa, sawa aama wa. ");
INSERT INTO hwo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A Nɗimaska na tǝ takkwa Yeeso sǝ thlǝmnggǝn ni Hananiya. Aaghǝna Faara ahu sǝsǝniirha, “Hananiya!” Nggǝmanggǝn, “Kulo nggi ya Chinǝm!” ");
INSERT INTO hwo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ndangga Chinǝm, “Thliusǝ ɗǝna minda ki Yahuda ɗǝ na a mii kwamanɗi na nda aarha kwamana na ndip, tsakh mee na tǝna niif Tarsus sǝ a mbǝɗi na thlǝmnggǝn Shawulu. Nanǝn ya nǝghǝn a hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A hu sǝsǝnirha kyaɗang ɗi niifa na nda aarha Hananiya ɗǝnǝn ɗǝfang haara teena tǝnǝn nggǝr na mana hai.” ");
INSERT INTO hwo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nggǝmangga Hananiya ndǝghǝn, “Chinǝm, sǝkɗi laɓar kamshiɗiya aten sǝsaarha nǝn a fǝrang nda nafiya na chahal a Urshalima! ");
INSERT INTO hwo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɓanǝn Nɗimaska ɓa tǝ ɗeleewar fǝrang na firis na manggǝn ka ɓagha ƙǝsang nda fatakkwaya Yeeso na a Nɗimaska.” ");
INSERT INTO hwo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amma ndangga Chinǝm Hananiya, “Ɗuwaɗǝ ɗa ǝna ˈya ndani. Ƙǝsǝr Shawulu wurra kari tarna ni ka ɗǝgha tǝ laɓarna a fingya ɗǝ mbuwa Yahudaya, tǝ kutǝrya tǝ nafiya Isǝrela kahad. ");
INSERT INTO hwo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nggi tafanna niya kyaɗang ǝngya heu nǝn a saarha fa ka nggi.” ");
INSERT INTO hwo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nanǝn kee ɗǝgha Hananiya ɗǝ ɗǝgha wal Shawulu. Ɗǝfang haara nǝn teena ndanggǝn, “Wan mana Shawulu, Chinǝm Yeeso walgha sa a kwamana nana a ɓarha mbǝɗa ɓa ya. Ndǝghǝn thlǝngga nggi ɓa tǝna nggǝr na mana hai tǝ ƙǝm lǝgɗowa Sǝsǝna tǝ Peɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsu a mbǝɗi kee, ˈya ƙǝla ɓar ɗǝfrha mukka hai a yid Shawulu, nggǝrghǝn na mana hai. Tǝrgha thliigha sǝ ǝnang mbaptisǝma nda. ");
INSERT INTO hwo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","A kwasamadghǝn ǝna ˈya nǝn mii wal kanglanggirha nǝn. Shawulu mǝngga ha a Nɗimaska tǝ fatakkwaya Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsu kee katǝranggǝn pǝr laɓar Faara ahu ƙǝngya tsahad Yahudaya nagha a ndaarha Yeeso Wan Faara ni. ");
INSERT INTO hwo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kala fiya sǝkka ndǝn ƙǝsgha ǝnwulteena kanda, tsakh mee nda, “Mbǝ niifɗani na a sǝsang tǝ ɓǝlang nda fa takkwa Yeeso a Urshalima wa? Mbǝ ɓanǝn ɓa ka a ƙǝsanggǝn kanda tsawa nda porsǝngya mamngya firis wa?” ");
INSERT INTO hwo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pǝr laɓar Faara na Shawulu a ǝnaarha aten ɗǝrha mbeeɗǝ tǝ kanglanggirha. Yahudaya na a Nɗimaska mbangwanda ngaal ǝngya kyad nǝn tǝ ndaarha Yeeso ndǝna Ƙǝrǝsti wa. ");
INSERT INTO hwo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A kwasamad ɓengya hangga, ƙǝnangga mamngya Yahudaya hai a ɓǝlang ngganda Shawulu. ");
INSERT INTO hwo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amma sǝkka Shawulu palthɗi ƙǝnang nanda hai atenggǝn. Nda yan fara tǝ fǝɗikrha na nda narha ƙǝlaghǝn fa a kwatkirǝm wupǝriɗi ka a ɓǝlangganda. ");
INSERT INTO hwo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amma a fǝɗikrha fatakkwaya Yeeso kyang ngganda ƙǝshaaɗǝ fǝrghǝnda hai hu kutasa tǝ kwaarha na a fad kad talɗi. ");
INSERT INTO hwo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sǝlna Shawulu a Urshalima ɗǝ midghǝn sǝ na wumngga hai tǝ fatakkwaya Yeeso, amma kanda a tǝrǝmnggǝn. Nggǝm ngwanda fa tǝ takkwa Yeeso ni wa. ");
INSERT INTO hwo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tǝrgha Mbarnaɓa ɓagha tǝghǝn thlǝmad fa thlǝngya Yeeso ɓa, pǝranggǝnǝn kanda kwamanɗi nana Shawulu Chinǝm ahu kwamana nǝn a ɗǝrha Nɗimaska ɗǝ. Pǝrangga Mbarnaɓa ndǝn kanda ƙǝm ǝnɗi ndangna Chinǝm Shawulu tǝ pǝr laɓar Faara ǝnanǝn tǝ kanglanggirha ahu thlǝm Yeeso a Nɗimaska. ");
INSERT INTO hwo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tǝrgha fa thlǝnggini thlǝ Shawulu nda fa. A kwasamadghǝn nǝn narha ƙǝtsar a thlǝman nda a Urshalima, nagha a pǝr laɓar Faara tǝ kanglanggirha ahu thlǝm Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nǝn narha ngaala tǝ Yahudaya na a ndikrha tǝ mii Helenaya, kanda ƙǝm a kaɗa kwamana na a ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sǝkna fatakkwaya Yeeso ndǝn, tǝrang ngganda ɗǝnda tǝghǝn Kaisariya ɗǝ puwang ngganda hu talghǝn ɗǝ, na Tarsus. ");
INSERT INTO hwo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A farɗani fatakkwaya Yeeso wumngga teena na a Yahudiya, tǝ Nggalili tǝ Samariya wal nanda tsawud ɗǝɗemnggirha, na nda a tsǝrha tǝ chikrha hu ƙanglanggirha. Tsaukwa fatakkwaya Yeeso tǝ tǝrǝm Faara tǝ tǝk mbǝnda Sǝsǝna fa tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na Mbiturus a weng mbǝya hai hangga, ɓagha ahu tala ɓa na nafiya Chinǝm sǝ na nda aarha Lidda. ");
INSERT INTO hwo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A mbǝɗi ɓagha wal niifa na nda aarha Iniyas mǝrna fadghǝn hai kalth hu sǝra hurarha wuvaɗa. ");
INSERT INTO hwo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ndangga Mbiturus, “Iniyas, Yeeso Ƙǝrǝsti ƙǝnoɗǝ thliusǝ tǝrang ɗǝnggǝlwa!” Tsu a mbǝɗi kee thliigha sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tǝrgha hang nda fiya na a Lidda tǝ Sharon kyakhra nda thlǝmad Chinǝm ɓa na nanda Iniyas a wiirha hai. ");
INSERT INTO hwo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na tǝ takkwa Yeeso sǝ a Ndjoppa thlǝmnggǝnni Taɓita, tǝ mii Helenaya na nda aaghǝn Ndokas. Nǝn ǝna nggayirha a fiya tǝ ɗang nda fa yamiya sǝ ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A hu sayidɗi hadgha mǝrgha. Ngwang nanda fa ka ɗa nda pang nda hunang ngganda hai ahur ƙǝnna tǝn nanda aten shadghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nanǝn na Lidda tsau tǝ Ndjoppa fa sǝk ndaarha nda na Mbiturus a Lidda, thlǝn nafiya nda ɗǝ sǝri ka ɗa nda hwanggǝn, ndang ngganda, “Usaai ɓoɓa ƙǝkar!” ");
INSERT INTO hwo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mbuwa Mbiturus samad ndan ɗǝ, hǝrǝm nǝn ndukrha ɗǝ, ɗǝnda tǝghǝn ahur ƙǝn ɗaɗǝ na aten shadghǝn. Lǝɗang nu mǝrya ƙǝnɗi kanda a tǝrha na nda kyad lukkya tǝ shishamarya imangna Taɓita kanda sǝ nanǝn tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ndangga Mbiturus kanda a kya nda hai ma ƙǝnɗi. Tǝrgha mbǝrgha hai hwan Faara nǝn. Kyahargha man thlǝmad mǝrɗa ɗǝ ndǝghǝn, “Thliu sǝ Taɓita.” A mbǝɗi kee inanggǝn yidghǝn hai! Nanǝn Mbiturus thliigha sǝ! ");
INSERT INTO hwo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ƙǝsgha Mbiturus harghǝnǝn thlenggǝn sǝ. Tǝrgha aah nu mǝryina nǝn ɓa tǝ fingya fatakkwaya Yeeso, kyaɗanggǝnǝn kanda nǝghǝn tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sǝkka fiya laɓarɗi ahur talɗi heu, tǝ ƙǝm fiya hangga fǝrgha ƙǝkafek a Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mǝngga Mbiturus ha a Ndjoppa ɗi, tsauka a ki Siman tǝ huna paama. ");
INSERT INTO hwo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A Kaisariya na mamnda sodja Romaya sǝ thlǝmnggǝn ni Koneliwus, ndǝghǝn ni mamnda aten sodjaya haru na nda aarha, Wum ten sodja Italiyaya. ");
INSERT INTO hwo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tǝ tǝrǝm Faara ni, ƙǝla fingya na ahur mindǝghǝn. Nǝn yakh fǝra a fa yamiya tǝ kǝm nǝn yakh hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na farɗasǝ yarna faara hai, sǝsǝniigha tǝ ndaarha naɗǝ tǝ thlǝnda Faara ɓayi thlǝmadghǝn ɓa. Aaghǝna tǝ thlǝnda Faara, “Koneliwus!” ");
INSERT INTO hwo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ƙǝlangga Koneliwus ɗǝ tǝ hǝreenga, ndanggǝn, “Paɓa mani?” Ndangga tǝ thlǝnda Faara, “Hwanduwa tǝ fǝrrǝwa a fa yamiya thlǝ Faara ndǝn tsauɗǝ ǝn ɗaalani in a fadghǝn! ");
INSERT INTO hwo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nanǝnya thlǝnu fiya a Ndjoppa ɗǝ ɗa nda oh niifa ɓa na thlǝmnggǝn Siman Mbiturus. ");
INSERT INTO hwo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tsauƙǝn a ki Siman, tǝ huna paama na tǝ tsaurha a mii wuri aama.” ");
INSERT INTO hwo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wiina tǝ thlǝnda Faara, aagha Koneliwus mafaya wurighǝn ɓa sǝri tǝ ƙǝm sodja tal tǝ takkwa Faara, ahur fingya na a ǝnang taara. ");
INSERT INTO hwo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pǝrang ǝnɗa nǝn kanda katǝragha hai thlǝnanggǝn kanda a Ndjoppa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A ɓindayidghǝn nana fathlǝngya Koneliwus a ndusang nda wupǝri ɗa fa, tǝrgha Mbiturus a mbǝrha sǝ na ɗangkam ka ɗǝgha hwan Faara. Mǝmǝl yanfaara a sǝrǝkrha, ");
INSERT INTO hwo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ƙǝsgha miirha ndǝn na midghǝn sǝ a ǝna ˈya nǝn mii. Amma na nanda a furha, tǝrangga ɓeena ɗǝ kyaɗangga Faara ǝnwulteena. ");
INSERT INTO hwo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na fǝrakh amshi nǝn inɗaɗǝ, ˈya ƙǝpakh manggǝn ɓayi hweeɗe hai tǝ kudma faɗa. ");
INSERT INTO hwo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A hu ǝnɗi na ƙǝpakh wu na maɓi ya sǝ ɗǝɗamǝn-ɗǝɗamǝn, tǝ ǝngya na wiirha tǝ hura tǝ wuɗikkya ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tǝrgha ndangga urarha hai, “Thliusǝ, Mbiturus, ɓulu kanda kiina.” ");
INSERT INTO hwo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ndagha Mbiturus, “Mbǝ tam narha hai wa, Chinǝm. Ka nani ˈwawi kii ˈya ˈyaɗana ngyakhrha Yahuda yinan wa.” ");
INSERT INTO hwo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nggǝrgha uradɗi kala sǝ, “A anna ˈya tsaɓang na Faara ɗǝ ǝn tsanda wa.” ");
INSERT INTO hwo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ənɗi kyaɗang na Faara katǝra mahan nanǝn ndǝn. Tǝrgha ǝnɗi na ƙǝpakh nggǝrghǝn wutta talara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tsauka Mbiturus hu ɓillarha, ndǝghǝn tǝ mana ǝnɗi a ndaarha kyadna Faara ya. Tǝrgha a mbǝɗi nafini thlǝnna Koneliwus walang nda mindǝɗi isha nda a ƙǝshi a mii kwatkirma. ");
INSERT INTO hwo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tsakh mee nda tǝ mbǝɗani na Siman Mbiturus sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nana Mbiturus a numarha aten ǝnɗi na nǝn, ndangga Sǝsǝna tǝ Peɗǝnda, “Ɓad nafiya ɓa mahan kanda a kaɗa sa. ");
INSERT INTO hwo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Thliu sǝ turu hai, ɗǝna ɗǝ tǝ kanda a karna fa wa. A ɓilladna wa ƙǝsǝr nggi thlǝngga kanda.” ");
INSERT INTO hwo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A mbǝɗi kee tǝrgha Mbiturus hai ndǝghǝn, “Nggini niifɗi nun a kaɗaarha. Kama nda ɓanun ɓa?” ");
INSERT INTO hwo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndanggan nda, “Koneliwus mamnda sodja Romaya thlǝngga kan ɓa. Ka niifa ni nǝn tǝrǝm Faara yi Isǝrela Yahudaya heu na nda fǝrang mamnggirha. Tǝ thlǝnda Faara tǝ Peɗǝnda ndangga a ɗǝna minda keeghǝn ɗǝ tǝnǝn sǝk laɓar wa.” ");
INSERT INTO hwo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tǝrgha Mbiturus aah nafina nǝn ɓa tsawa nda ronggighǝn a fiɗikɗi. Ɗalthna mbǝrha hai ɗǝgha ɗǝ saman ndan, mbuwa fingya fatakkwaya Yeeso kanda ɓagha ɓa a Ndjoppa. ");
INSERT INTO hwo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ɗalthna mbǝrha hai sǝla nda Kaisariya ɗǝ. Koneliwus a ƙǝla kanda fa ƙǝsǝr aahɗǝ hurfayighǝn ɓa tǝ fingya pashiyighǝn. ");
INSERT INTO hwo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kyana Mbiturus mindǝ ɗahai kee, ǝna Koneliwus thlǝmadghǝn ɗǝ ra kurma nǝn hai a mbedghǝn fǝrang mamnggirha nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amma Mbiturus ƙǝs harghǝnǝn sǝ ndanggǝn, “Thliu sǝ! Niifa ni nggi kee ƙǝla sa!” ");
INSERT INTO hwo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A mbǝɗi kee thliigha Koneliwus sǝ, tsǝ laɓara nda kanda kyab kya nda hu ƙǝnɗa ɗǝ wumna fiya sa hai hangga. ");
INSERT INTO hwo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ndangga Mbiturus kanda, “Sǝnɗun sǝ ngyakhrha Yahudaya nggǝm ngwa fa ƙǝla nggi ɓee minda ki niifa ɓa mbuwa tǝ Yahudarha ƙǝla yanɗiya wa. Amma Faara keɗee ɗa ndǝn a numaɗi aten niifa tǝ ndaarha ǝn tsandani wa. ");
INSERT INTO hwo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nanǝn kee thlǝn nanda farha ɗǝ a ɓee ɓa karyi fa wa. Nanǝnya pǝremadghǝn ǝnɗi aah nun nggi ɓa.” ");
INSERT INTO hwo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ndagha Koneliwus, “Ɓeena faɗa mbǝrgha ɗǝ nggi a hwan Faara ahur kǝnna mǝmǝl yar yan fara hai. Kula sǝndǝna sǝ, na niifa ni ƙǝt tǝ luwudghǝn a chimnda fa a mbenna. ");
INSERT INTO hwo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ndeeghǝn, ‘Koneliwus, sǝk Faara hwanduwa, tǝ ƙǝm naɗǝ fǝrrǝwa a fa yamiya! ");
INSERT INTO hwo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nanǝn kee, thlunu nafiya a Ndjoppa ɗǝ ɗanda aah Siman Mbiturus ɓa. Nǝghǝn tǝ tsaurha a minda ki Siman, tǝ huna paama na tǝ tsaurha a mii wuri aama.’ ");
INSERT INTO hwo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nanǝn kee ndǝn thlǝnni farha ɗǝ ƙǝkar, nǝghǝn ngga a ɓana ɓa. Nanǝnya kulo ƙǝm ya heu, a mbed Faara ka a sǝk ǝngya nan heu purona Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tǝrgha ndagha Mbiturus, “Naɗi ndǝn ngga Faara mbǝ wura ha sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Amma nǝn thlǝ fiya fa ahu chehweeya heu na a tǝrǝmnggǝn kanda ƙǝm a ǝna ˈya na mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sǝnɗisǝ sǝkɗun laɓara na mbǝnggǝn thlǝnang nanda nafiya Isǝrela ɗǝ tǝ ndaarha na tsawud ɗǝɗemnggirha sǝ a thlǝmad Faara ahu thlǝm Yeeso Ƙǝrǝsti, na Chinǝm heu. ");
INSERT INTO hwo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sǝnɗun ˈya katǝragha hai a chehweed Yahudiya, ǝnɗiya ˈwaghǝn katǝragha hai a Nggalili a kwasamadɗi katǝrang na Yahaya tǝ Mbaptisǝma pǝr laɓar Faara aten mbaptisǝma. ");
INSERT INTO hwo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mbǝ ngaala sǝ wa sǝnɗun sǝ Faara ndǝn faɗangga Yeeso tǝ Nadzarat tǝ Sǝsǝna tǝ Peɗǝnda tǝ sǝsǝmnda ƙǝm. Tǝrgha Yeeso nagha a wiirha hai tǝ ǝna nggayirha tǝ ƙǝnang nda fiya heu djithlang na Sheetan kanda hai, ƙǝsǝr na Faara tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ƙǝm fa thlǝngya Yeeso naɗǝm ǝnggini ǝnanǝn heu tǝ yid nǝm a chehweed Yahudiya tǝ wupǝri Urshalima. Ɓǝlangganda tǝ taurha ɗǝ aten kaɗiirha. ");
INSERT INTO hwo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amma a kwasamad ɓeena mahan thlengga Faara sǝ ahu mǝrra. Tǝrgha Faara malanggǝn kyad fadghǝnǝn, ");
INSERT INTO hwo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","mbǝ a fiya heu wa, amma a ƙǝm ˈwana Faara wura a tsauka ƙǝmni nagha ndǝn. Ƙǝmni hǝbgha tǝ saarha tǝ ndǝghǝn a kwasamadɗi thliinǝn sǝ ahu mǝra. ");
INSERT INTO hwo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ndanggǝn ƙǝm a pǝr laɓar Faara nǝm ko a yanggi ni kyad ndaarha nǝm ndǝghǝn ni wurna Faara a tsauka tǝ ngwa kumarha heu tǝ fa yibya tǝ mǝrya. ");
INSERT INTO hwo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ndǝghǝnni thlǝkna annabiya pathla a tenggǝn ƙǝtǝm, tǝ ndaarha kala niifa fǝrgha ƙǝkafek a ndǝghǝn na Faara a chahang ɗimiyid ndan kanda ɗǝ ahu thlǝmnggǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nana Mbiturus aten thlǝk ǝnggini ya, tǝrgha Sǝsǝna tǝ Peɗǝnda aten nafina hai sǝkka laɓarɗi. ");
INSERT INTO hwo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahudaya mbuwa samad Mbiturus fǝrgha ƙǝkafek na ǝnwulteena nda tǝ ndaarha fǝrra Sǝsǝna tǝ Peɗǝnda irɗǝ aten fingya hai mbuwa Yahudaya, ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ƙǝsǝr sǝk nda fandan a ndikrha tǝ miiya ɗǝɗamǝn-ɗǝɗamǝn na nda a fal Faara. Tǝrgha Mbiturus tsakh mee nǝn, ");
INSERT INTO hwo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mani ˈyaɗang mbaptisǝma nafina fa tǝ aama ya, nanǝn thlǝnda Sǝsǝna tǝ Peɗǝnda ƙǝla ƙǝm?” ");
INSERT INTO hwo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nanǝn kee ndagha Mbiturus a ǝnang Mbaptisǝma nda kanda ahu thlǝm Yeeso Ƙǝrǝsti. A kwasamadghǝn hwangga Koneliwus ndǝn a mǝngga ha tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tsǝɓaku fa thlǝnggini tǝ fingya fatakkwaya Yeeso na tǝ tsaurha a Yahudiya sǝk ndaarha nda fingya mbuwa Yahudaya thlǝnda laɓar Faara. ");
INSERT INTO hwo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ɓana Mbiturus Urshalima ɓa, nafiya thleng nanda muwa kanda na nda a kikighǝn fa ndaa nda, ");
INSERT INTO hwo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kyanna a minda ki nafiya hai thlewa muwa tǝ ƙǝm hǝb ǝnnarhami tǝ kanda!” ");
INSERT INTO hwo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tǝrgha Mbiturus pǝrang nggǝnǝn kanda a pǝpal ˈya katǝragha hai heu. ");
INSERT INTO hwo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ndǝghǝn, Farɗa sǝ a Ndjoppa, nani a hwan Faara, tǝreegha ɓeena ɗǝ na ˈya ni ƙǝpakh tǝ kudma faɗa a fǝrakh amshi ɓagha thlǝmadna hai. ");
INSERT INTO hwo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ƙǝlang ni ǝnɗi na ƙǝpakh, na maɓiya ni ɗǝɗamǝn-ɗǝɗamǝn na a wuri tǝ yi kaheerha, tǝ fingya a kakhrha tǝ hura, tǝ wuɗikkya. ");
INSERT INTO hwo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sǝk urarha ni tǝ ndaarha, “Thliusǝ Mbiturus, ɓulu kanda kiina.” ");
INSERT INTO hwo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nggǝmanggi ndee, “Mbǝ tam narha hai wa, Chinǝm. Ka nani ˈwawi kii ˈya ˈyaɗana ngyakhrha Yahudayi nan wa.” ");
INSERT INTO hwo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nggǝrgha uradɗi kala sǝ yi sǝri, “A anna ˈya tsaɓang na Faara ɗǝ ǝn tsanda wa.” ");
INSERT INTO hwo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katǝragha ǝnɗa hai ya sara mahan kapa na ǝnɗi na ƙǝpakh na tǝ maɓiyini wutta talara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A sayidɗi kee nafiya mahan thlǝn nanda kanda ɓa a Kaisariya nduk nda mindǝɗa ɓa nani sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ndeegha Sǝsǝna a karɗi wiirha fa tǝ kanda wa. Wan mamnggini mikki ɗǝfeegha ɗǝ, ɗan kyarha minda ki niifɗa hai tsakhka kan. ");
INSERT INTO hwo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pǝrang laɓar tǝ thlǝnda Faara nǝn kan ɓagha walghǝn a minda keeghǝn, ndang nǝn, “Thlunu farha a Ndjoppa ɗun ndang nda Siman Mbiturus a ɓagha ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nǝn a puro kwamanɗi na Faara a hǝrworha heu tǝ nafiya wuri wa!” ");
INSERT INTO hwo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tǝrgha ɗǝgha Mbiturus mbeeɗǝ tǝ ndaarha, A mbǝɗi ɗi mbeeɗǝ tǝ pǝrang Laɓarɗi kanda na Mbǝnggǝn. Katǝrang ni hai kee, tǝrgha Sǝsǝna tǝ Peɗǝnda atendan hai, ƙǝla ˈwanǝn tǝra tennan hai. ");
INSERT INTO hwo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tǝrgha ɗal teena ni hai tǝ palth Chinǝm ndanǝn, “Ənagha Yahaya mbaptisma tǝ aama, amma na nda a ǝnang mbaptisma kun tǝ Sǝsǝna tǝ Peɗǝnda.” ");
INSERT INTO hwo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nanǝn kee, nanǝn fǝrang Faara fingyayini mbuwa Yahudaya tur fǝrrǝɗi fǝrang nǝn kan sayidɗi fǝr nan ƙǝkafek a Chinǝm Yeeso Ƙǝrǝsti, wunni nggi na ngaalang nda Faara? ");
INSERT INTO hwo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hǝrǝm nanda sǝkƙǝn kee, wulangga ˈya kanda na a thlǝgha nda. Katǝrang ngganda fal Faara hai ndaa nda, “Faara ƙǝm fǝrang ɗǝ fingya mbuwa Yahudaya kwamana na malang ngganda ɗimiyid ndan wal yibrha nda mbuwa ngwalarha.” ");
INSERT INTO hwo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nanǝn ya, fatakkwaya Yeeso wel nda hai ka sǝsaarha a kwasamadɗi ɓǝlang nanda Istifanus. Ɗǝnda ɗǝ inggun ta Finikiya ɗǝ tǝ Sayifurus tǝ Antakiya na a chehweed Suriya. Pǝr laɓar Faara nda a Yahudaya katen ndan kee. ");
INSERT INTO hwo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Fingya fatakkwaya Yeeso thliigha a Sayifurus tǝ Sayirin ɗǝnda Antakiya ɗǝ, katǝrang nda pǝr laɓara hai na mbǝnggǝn aten Chinǝm Yeeso a fingya mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sǝsǝmnda Chinǝm nǝghǝn tǝ kanda ha, fiya hangga fǝrgha ƙǝkafek kyahar nda thlǝmad Chinǝm ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sǝkna fatakkwaya Yeeso na a Urshalima laɓarɗi, thlǝnang ngganda Mbarnaɓa a Antakiya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sǝl nǝn ɓa nanǝn nggayid Faara tǝ kanda, tǝk mbǝnda nǝn fa, ndanggǝn kanda a tsawa nda ƙǝtsar tǝ ƙǝkafek fa a Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mbarnaɓa ka niifa ni, nǝghǝn lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda tǝ fǝrƙǝkafek fa ƙǝm. Ɓad nda ɓa tǝ fiya hangga a thlǝmad Chinǝm ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tǝrgha Mbarnaɓa ɗǝgha Tarsus ɗǝ ka ɗǝgha kaɗa Shawulu. ");
INSERT INTO hwo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ɗǝnǝn walang nda ɓagha tǝghǝn Antakiya ɓa. Kanda kyab tsawa nda a mbǝɗi hurarha tal kanda tǝ fatakkwaya Yeeso na nda a tsahang fiya ha hangga. A hu tal Antakiya ni ˈwana nda aah fatakkwaya Yeeso Ƙǝrǝstaya. ");
INSERT INTO hwo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A hu sayidɗi, thliigha fingya annabiya a Urshalima ɗǝnda Antakiya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tal ahur ndan na thlǝmnggǝn Anggabus thliigha sǝ a fara tal ahu tsawundan hai thlǝk ndaarha nǝn na miirha na kyarha hu chehweed Romaya hai kahat. Lǝghǝdgha palth ɗi ya a thlakh mbǝd kutǝryid Kalaudiyus. ");
INSERT INTO hwo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Fa takkwayini kii Yeeso na a Antakiya ƙǝnang ngganda hai na nda a ɗang nda shayindan sǝ na a Yahudiya. Ko wunni fǝr ˈya nǝn nggǝmna hurghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ənɗa ǝna nanda ya, thlǝnang ngganda Mbarnaɓa ɗǝ tǝ Shawulu a ɗang ǝn fǝryi ndan nda shingya fatakkwaya Yeeso ɗǝ na a Urshalima. ");
INSERT INTO hwo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mǝmǝl ahu sayidɗa niya katǝrang na Kutǝra Hirdus kyang fingya fatakkwaya Yeeso hu sǝsaarha hai. ");
INSERT INTO hwo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Fǝr Yakubu nǝn wan man Yahaya a ɓǝlang ngganda tǝ thlaukh ƙǝlaara. ");
INSERT INTO hwo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nanǝn ǝnɗi ǝnanǝn mbǝnang ɗǝ mamngya Yahudayini, ɗǝgha mbeeɗǝ ƙǝsanggǝn Mbiturus ƙǝm. Katǝragha ǝnɗa hai ya ahu sayid Wutsǝfayid Mburodi kula Mekhna. ");
INSERT INTO hwo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Muwanggǝn hu porsǝna ɗǝ nagha sodjaya kumkap mikki a ƙǝlaghǝn ha, na nda a mbeɗeghǝn ha sodjaya faɗa-faɗa. Na mid Hirdus sǝ a ngwang kumarha nǝn sǝ a mbed fiya a kwasamadɗi ngwalana wutsǝfayidɗi. ");
INSERT INTO hwo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Amma nana Mbiturus ahu porsǝnɗi, nagha fatakkwaya Yeeso a hwan Faara kaan atenggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A fǝɗikɗi kapa na mbǝrha ɗathla hai na Hirdus a ngwang kumarha Mbiturus sǝ, Mbiturus kalth a shiirha ƙǝnang nda hai tǝ wuyiwurya sǝri, a pathlang sodjaya sǝri ƙǝƙǝt atenggǝn tǝ fingya sodjaya ƙǝm ƙǝƙǝt a ƙǝla kwatkirǝm porsǝn ɗa ha. ");
INSERT INTO hwo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kula sǝndǝndan sǝ kyagha tǝ thlǝnda Chinǝm ɓa djargha kukwaryirha hai ahu ƙǝn porsǝnɗi. Tsang ˈya nǝn fa a kakh pǝniighǝn mekhnenggen sǝ ndanggǝn, “Thliusǝ ƙǝkar!” Wuyiwur yini na a tsaɓad haaryighǝn tsama nda hai. ");
INSERT INTO hwo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tǝrgha ndangga tǝ thlǝnda Faara, “Kalang luwudwa tǝ paham wa.” Ənagha kee. Ndangga tǝ thlǝnda Faara, “Nanǝnya kawang kootod wa fa mbu samadna na.” ");
INSERT INTO hwo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tǝrgha Mbiturus mal porsǝn ɗa nǝn mbu samadghǝnǝn. Amma ahu sayidɗi wu tamnggǝn ndaarha nǝghǝn a sǝsǝniirha ni. Sǝngwa sǝ ƙǝkafekni ǝnɗi na a katǝrarha hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mbǝrang ngganda mbǝd fa ƙǝlaya hai sǝri, ɓa nda kwatkirǝm ɗa ɓa ǝna nanda tǝ ɗǝɓǝlya na a kyarha ƙǝshaaɗǝ. Ingga ɗǝ heu tafadghǝn. Kya nda ƙǝshaaɗǝ. Katǝrang ngganda wiirha hai ahur kwaman talɗi, tǝrgha tǝ thlǝnda Faara kula sǝndǝndan sǝ sahadgha ma yidghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tǝrgha wudna huten Mbiturus ɓa ndǝghǝn, “Nanǝnya sǝnɗi sǝ mbǝ ngaala sǝ wa Chinǝm thlǝnangga tǝthlǝndǝghǝn ɓa ka a hǝryeghǝn a haar Hirdus tǝ ǝngya heu na mid Yahudaya a ǝneegha nda fa.” ");
INSERT INTO hwo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sǝnang nǝn hai kee, ɗǝgha minda ki Mairamu ɗǝ man Yahaya na nda aarha Markus, a mbǝɗi wumna fiya sa hai kanda a hwan Faara. ");
INSERT INTO hwo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ishgha a mii kwatkirǝm ɗi ɗǝkƙǝnǝn. Kyagha mafad wutararha ɓa na nda aarha Ruda ka ɓagha nggǝmang nda adɗi na a kwatkirǝm ɗi. ");
INSERT INTO hwo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sǝnang nǝn urad Mbiturus hai, tǝk mbǝnda nǝn fa kaan. A meghedghǝn na a inanggǝn kwatkirma hai, wudgha hur minda ɗǝ ka ɗǝgha pǝranggǝn fiya heu tǝ ndaarha, “Mbiturus ƙǝt a kwatkirma!” ");
INSERT INTO hwo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ndangganda, “Kyahar na huten wa?” Djib pǝrrǝghǝn nǝn. A mbǝɗi ndaa nda, “Tǝthlǝnda Faarghǝn ni!” ");
INSERT INTO hwo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amma ɗǝgha Mbiturus mbeeɗǝ tǝ ɗǝk kwatkirma. Inang nanda kwatkirma hai nana ndan ƙǝsgha ǝnwulteena kanda. ");
INSERT INTO hwo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sahangga Mbiturus haara kanda a nggasa nda hai. Pǝrang kwaman ɗa nǝn kanda hǝrghang na Chinǝm na nǝn ahu porsǝnɗi. Ndanggǝn kanda, “Pǝraman ndǝghǝn Yakubu tǝ fingya wan mangginǝm ǝnɗi katǝragha hai.” Tǝrgha ɗǝgha mbǝrha ɗǝ pak. ");
INSERT INTO hwo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ɗalth na mbǝrha hai, wulangga teena sodja yini aten ǝnɗi katǝragha hai tǝ Mbiturus. ");
INSERT INTO hwo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A kwasamadɗi ndaana Hirdus a kaɗaghǝn nda walang ngwa nanda, ra mu sodja yina nǝn ngga. Fǝr kanda nǝn a ɓǝlang ngganda kanda mbǝɗi. A kwasamadghǝn thliigha Hirdus a Yahudiya ɗǝgha Kaisariya ɗǝ tsǝgha tsǝɓaku a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nanǝnya sǝb hur Hirdus ɗǝ tǝ nafiya Taya tǝ Sidǝn. Thlǝn farha nda ɗǝ ka ɗa nda kaɗa kwaman tsawud ɗǝɗemnggirha tǝghǝn, ƙǝsǝr mbǝrsagha nda tǝ ǝnnarhami na hu chehweedghǝn. Nafini thlǝnna nda ɗǝ kaɗa thlaara nda a har Mbilatus, tǝ ɗang nda Hirdus sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sǝlna farɗa ɓa nanda wuma nda hai tǝghǝn, kalangga Hirdus kaɓad kutǝryidghǝn fa tsauka ahu tsǝnggamnggǝn sǝ thlǝghang pathla nǝn kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sǝkna fiya ndǝn tǝrang ngganda urandan sǝ ndaa nda, “Urad faarani mbǝ yi niifa ni wa.” ");
INSERT INTO hwo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tsu a mbǝɗi kee, ka fal waana Hirdus Faara ɗǝkka tǝthlǝnda Chinǝm ndǝn tǝ wan haarha, nagha waaya a kiighǝn pa mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Amma Laɓar Faara na Mbǝnggǝn ƙǝl ɗǝrha mbee ɗǝ nagha fatakkwaya Yeeso a chikrha kaan. ");
INSERT INTO hwo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ngwalang nanda Mbarnaɓa tǝ Shawulu ˈya ɓangga kanda Urshalima ɓa, wuɗa nda Antakiya ɗǝ, tahangganda Yahaya ha ɗǝ na nda aarha Markus. ");
INSERT INTO hwo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A hur fatakkwaya Yeeso na a Antakiya na annabiya sǝ tǝ famalǝmngya: Nda Mbarnaɓa ni tǝ Siman na nda aarha “Tǝimnda,” Lusiyos tǝsarirarha, tǝ Maana tsǝgha sǝ tal tǝ kutǝra Hirdus Antipas tǝ Shawulu. ");
INSERT INTO hwo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Farɗasǝ na nafiniya a tǝrang shilee Chinǝm teena, tǝ kar aama, ndagha Sǝsǝna tǝ Peɗǝnda, “wureema nda Mbarnaɓa tǝ Shawulu ƙǝsǝr ka taara na manggǝn na minna a ǝneegha nda.” ");
INSERT INTO hwo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nanǝn kee a kwasamadɗi ngwalang nanda kar aama tǝ hwan Faara, sang haara nda kanda teena yi parka thlǝn kanda nda. ");
INSERT INTO hwo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A kwasamadɗi thlǝnna Sǝsǝna tǝ Peɗǝnda nda Mbarnaɓa tǝ Shawulu, ɗǝnda wupǝri Salukiya ɗǝ, tǝra nda hu kombuwol hai ɗǝnda a wutambar Sayifurus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sǝl nanda Salamis ɗǝ kya nda hu ƙǝn tsahad Yahudaya ɗǝ pǝr laɓar Faara nda a mbǝɗi. Na Yahaya Markus a samad ndan nagha a ɗang kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Weng ngganda talyina hai kahat na ahu wutambar chehwedɗi ta Pafos ɗǝ. A mbǝɗani wal nanda tǝmutu Yahudarha sǝ, annabi tǝ nggaɓaarha na thlǝmnggǝn Mba Djeshiwa. ");
INSERT INTO hwo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nǝghǝn a ǝnang taara ngwamna, Sardiyus Mbulus sǝ, niifa ni na tǝ sǝnda kaan. Thlǝn farha nǝn ɗǝ ɗa nda aang nda Mbarnaɓa ɓa tǝ Shawulu, ƙǝsǝr na midghǝn sǝ a sǝk laɓar Faara nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma Alimas, tǝmutu ɗi (thlǝmnggǝn ni tǝ mii Helenaya), ndanggǝn ngwamna ɗi a kang ɗǝ thlǝmaarha nda Mbarnaɓa fa tǝ Shawulu aten ˈya nanda a thlǝghang nda wa. Na midghǝn sǝ kyakhranggǝn huten ngwamna ɗa hai a fǝrɗǝ ƙǝkafek wa. ");
INSERT INTO hwo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tǝrgha Shawulu na nda aarha Mbulus, nǝghǝn lǝlǝgɗa tǝ Sǝsǝna tǝ Peɗǝnda, ƙǝlanggǝn tǝmutu ɗi hu yidsǝ ndanggǝn, ");
INSERT INTO hwo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Sa wan Sheetan ni, tǝ tsan ǝngya heu na nggǝngga! Naa lǝlǝgɗa tǝ ǝn hukkya tǝ mbǝlfeerha ƙǝm. A kwan na a malang ishang nda fiya ma takkwa ƙǝkafekkid kwaman Chinǝm? ");
INSERT INTO hwo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nanǝnya, na Chinǝm a ɓang sǝsaarha a tenwa ɓa, Na a tsaurha kwamarha. Na a mǝndaha mba a na yanfara wa.” Tsu a mbǝɗi kee wufiirha tǝ wula tǝrgha atenggǝn hai, nagha a wiirha hai tǝɗak-tǝɗak nagha a kaɗa niifa na a ƙǝs harghǝnǝn tǝnǝn kyaɗang kwamana. ");
INSERT INTO hwo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nana ngwamna ǝnɗi katǝragha hai, fǝrƙǝkafek nǝn, ƙǝsǝr ƙǝs ǝnwulteena ndǝn ahu tsahadɗa ha sǝk nǝn aten Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tǝrgha Mbulus tǝ ka wiyighǝn mal Pafos nda, tǝra nda ahu kombuwol hai ɗǝnda Pǝrngga ɗǝ na hu chehweed Pamfiliya. A mbǝɗani malna Yahaya Markus kanda wudgha Urshalima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amma nda Mbarnaɓa tǝ Mbulus wii nda tǝ saara a Antakiya ɗǝ na a chehweed Pishiidiya. A far yibrha Yahudaya kya nda hu ƙǝn tsahad Yahudaya ɗǝ tsawa nda hai. ");
INSERT INTO hwo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A kwasamadɗi karatang nanda ɗeleewar ngyakhrha Musa tǝ yi annabiya, mamnggini na tǝ ƙǝn tsahadɗa ha thlǝnang farha nda kanda ɗǝ tǝ ndaarha, “Wan manggina, ana laɓara sǝ a mii nun a kan, thlǝgha madghǝn!” ");
INSERT INTO hwo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Thliigha Mbulus sǝ, tǝranggǝn harghǝn sǝ ka a nggasa nda hai ndǝghǝn, “Nafiya Isǝreela, tǝ kun fingya mbuwa Yahudaya na a tǝrǝm Faara, keema thlǝmaarha fa. ");
INSERT INTO hwo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Faara yi nafiya Isǝreela ndǝn wurgha chichiyi nǝm, malang ɗǝ kanda a ɗǝnda mbeeɗǝ ahu sayidɗi na nanda a chehweed Masar. Tǝrgha tǝ sǝsǝmndǝghǝn na kanglang kyanggǝn kanda sǝ ahu chehwedɗi. ");
INSERT INTO hwo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ƙǝrǝsgha tǝ kanda ahu hurarha kumnggit faɗa a kaheerha. ");
INSERT INTO hwo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ndǝghǝn ǝnagha ndǝn ɓǝlang nanda chehweeya ɗǝ mǝd na a Kanˈana fǝrang chehwedɗa nǝn Isǝreela tsauka langaad ndan.” ");
INSERT INTO hwo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ənggini heu ya ǝnaɗǝ huraya 450. “Akwasamadghǝn, fǝrangga Faara fa ngwa kumaya kanda ǝna kutǝryirha nda aten ndan ta hu sayid annabi Samaila ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tǝrgha nafini hwan kutǝra nda, fǝrangga Faara Shawulu wan Kish kanda, turya Mbenjemen. Əna kutǝryirha nǝn yi huraya kumnggit faɗa. ");
INSERT INTO hwo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Amma ƙǝɗangga Faara Shawulu hai faɗanggǝn Ndauda a meyedghǝn, niifɗa ndana Faara, ‘Ndauda wan Djeeshi tur niifɗa ni na mid hurna; nǝn ǝna ǝngya heu na minna a ǝneeghǝn.’” ");
INSERT INTO hwo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ahu turya niifɗa ni ya, ɓang na Faara tǝhǝrǝkrha ɓa, Yeeso ɗa ni ndana Faara nǝn a thlǝnang ɓa! ");
INSERT INTO hwo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kapa na Yeeso ɓarha ɓa, Yahaya pǝrɗǝ laɓar mal ɗimiyirha tǝ ƙǝm mbaptisma a nafiya Isǝreela heu. ");
INSERT INTO hwo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Takhna Yahaya a ngwalang nda targhǝn tsakh mee nǝn, ‘Nuwun a numad ndaarha nggini Ƙǝrǝsti wa? Awo, amma nǝghǝn ɓayi a samanna, tsikki na a kwasanggi sakh pahamnggǝn hai wa.’ ");
INSERT INTO hwo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Wan manggina, kun wangya Ibrahim, tǝ ƙǝm kun fingya mbuwa Yahudaya na a tǝrǝm Faara, laɓar hǝrǝkrǝ ɗi ya thlǝnang nandan ƙǝm ɓa! ");
INSERT INTO hwo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nafiya Urshalima tǝ mamnggi ndan kukwalang ngwanda Yeeso hai wa, tǝ ƙǝm sǝnang ngwanda laɓar annabiya hai na nda karatang nda kala far yiɓǝd Yahudaya wa. A meyedghǝn ɓǝlang ngganda Yeeso ka a lǝɗang ngganda ǝngya ndaana annabiya. ");
INSERT INTO hwo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko nanǝn ƙǝsang ngwanda tǝ ˈya ɗimi wa, ndang ngganda Mbilatus a ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ngwalang nanda lǝɗang nda ǝngya heu ndaana ɗeleewar aten mǝrrǝghǝn, tǝrang ngganda hai aten kaɗidɗi pang ngganda ahu kwadɗa hai ra nanda ahu feera. ");
INSERT INTO hwo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma Faara thlenggǝn sǝ ahu mǝrra! ");
INSERT INTO hwo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ahu ɓengya hangga kyad fadghǝnǝn a nafini mbuwa samadghǝn ka a Nggalili ɓa ta Urshalima ɗǝ. Kanda ni nanǝnya na a pǝranggǝn nafinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nanǝnya ɓanan ɓa ka a ɓan pǝrang laɓarɗi kun na Mbǝnggǝn ya: ˈya ndaana Faara a chichiyi nǝm tsauɗǝ ƙǝkafek a thlakh mbǝd nan, ");
INSERT INTO hwo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tsaunǝn thleng Faara Yeeso sǝ. Ƙǝla nanǝn chichirethlee hai ahu ɗeleewar Dzabura yi sǝri tǝ ndaarha, ‘Waana ni sa, A weeriya tsauɗi tsu.’ ");
INSERT INTO hwo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ƙǝsǝr ndagha Faara nǝn a thleng sǝ ahu mǝrra, ɓalwa nggǝr mǝra wa. Nǝghǝn chichirethlee hai kee ahu ɗeleewar Faara ndaanǝn, ‘Niya furo parkadɗi tǝ Peɗǝnda ndang ni Ndauda.’ ");
INSERT INTO hwo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","A mbǝrha hu ɗeleewar Dzabura pǝrɗa ndǝn a pǝpal tǝ ndaarha, ‘Mba malang nda tǝ Peɗǝnduwa mǝlthgha hai ahu kwaarha wa.’” ");
INSERT INTO hwo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ƙǝsǝr a kwasamadɗi ngwalang na Ndauda tarɗi na mid Faara a thlakh mbǝdghǝn, mǝrgha pang ngganda ahu kwat mǝrra chichiyighǝn, mǝlthgha thlu fadghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amma niifɗi thleng na Faara sǝ ahu mǝra mǝlthwa thlu fadghǝn hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tsaunǝn kee wan manggina, na minna sǝ a sǝnunsǝ ahu Yeeso ɗiya ndǝn nanan a pǝrang ndaarha kun, nun a wal chakh ɗimiyid nun sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kala niifa fǝrgha ƙǝkafek tǝghǝn nǝn a wal hǝrǝkrha a mbed Faara, ˈya mbuwana ngyakhrha Musa mbang ǝnaarha. ");
INSERT INTO hwo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kwarama! A nggǝmɗun fa ˈya ndaana annabiya katǝragha hai tǝ kun wa. Ƙǝsǝr ndagha nda, ");
INSERT INTO hwo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaama thlǝmaarha hai, kun na a waa farha, nama ǝnwulteena murun ɗǝ! Ƙǝsǝr niya ǝna ˈya a thlakh mbǝd nun, ˈya mbuwa nun fǝrƙǝkafek tǝghǝn ko pǝrang na niifa ˈya kun atenggǝn.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na nanda Mbulus tǝ Mbarnaɓa a kyarha hai a ƙǝn tsahad Yahudaya, hwangga nafini kanda a nggǝra nda wutta ɓa ɓanda pǝrang laɓara kanda aten ǝngginiya a far yibrha na ɓayi. ");
INSERT INTO hwo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Welna fiya hai, Yahudaya hangga tǝ fingya mbuwa Yahudaya kyagha hu takkwa ǝntin Yahudaya hai mbu samad nda Mbulus nda tǝ Mbarnaɓa. Nafini sǝri ya ndang ngganda kanda a ɗǝnda mbeeɗǝ tǝ mbǝrsaarha tǝ nggayid Faara. ");
INSERT INTO hwo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kyahar na far yiɓǝd Yahudaya ɓa fadɗǝn, fiya hangga kaan a wupǝri ɗi wuma nda thlǝman ndan ɓa ka a sǝk laɓar Chinǝm nda ");
INSERT INTO hwo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nana mamngya Yahudaya wumngga hai, na nda a sǝrǝkrha, na nda a ngaal ǝngya ndaana Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tǝrgha nda Mbulus tǝ Mbarnaɓa kula hǝreenga ndang ngganda kanda, “Kamɗǝ kwang a pǝrang laɓar Faara nan kun, nanǝn karɗun ndǝn fa tǝ ƙǝm ƙǝlang ɗun fad nun kamngwa a wal yibrha nu mbuwa ngwalaarha wa, nanǝnya nan a kyaharra thlǝma fingya ɗǝ mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ƙǝsǝr kulo ǝnɗi ndang na Chinǝm kan ya: ‘Ɗǝfang ɗi kun a tsawun kukwaryirha a fingya mbuwa Yahudaya, a ɓang hǝrǝkrha nun fiya ɓa ta mii ngwala ƙǝshiirha ɗǝ.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sǝkna fingya yina ndǝn mbuwa Yahudaya, tǝk mbǝnda nda fa usa Chinǝm nda ka laɓarghǝn. Fingya wurna nda ka yibrha mbuwa ngwalaarha fǝrƙǝkafek nda. ");
INSERT INTO hwo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nanǝn kee laɓar Chinǝm welɗa ɗǝ ahu chehwedɗi kahat. ");
INSERT INTO hwo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tǝrgha mamngya Yahudayini shik nishya nda na a tǝrǝm Faara na fiya a fǝrang mamnggirha kanda, tǝ mamngya na ahur wupǝri ɗi. Shighang ngganda fiya fa, thleng ngganda nda Mbulus fa tǝ Mbarnaɓa rǝghang ngganda kanda sǝ ma talɗi. ");
INSERT INTO hwo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Amma nda Mbulus tǝ Mbarnaɓa ɗǝghang ngganda tǝnidɗa ɗǝ na a saryi ndan a tsauka yiyi thlǝmaarha ni aten ndan, ɗǝnda Ikoniya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Fa takkwaya Yeeso na a Antakiya tǝk mbǝnda nda fa tǝ ƙǝm lǝgɗa nda tǝ Sǝsǝna tǝ Peɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A Ikoniya, nda Mbulus tǝ Mbarnaɓa kanda kyab kya nda hu ƙǝn tsahad Yahudaya ɗǝ ƙǝla sǝsǝn nanda sahai. Pǝr laɓar Faara nda tǝ sǝsǝmnda har fiya hangga Yahudaya tǝ fingya mbuwa Yahudaya fǝrƙǝkafek nda. ");
INSERT INTO hwo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma fingya Yahudayini kargha fǝrƙǝkafek fa, shik fingya yina nda mbuwa Yahudaya kyakhrang ngganda huten nggindan hai ma fa takkwaya Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tsawa nda Mbulus tǝ Mbarnaɓa a mbǝɗi ɓeena hangga, ɗǝnda mbeeɗǝ tǝ pǝr laɓar Chinǝm kula hǝreenga. Chinǝm Yeeso fǝrang ɗǝ sǝsǝmnda kanda a ǝna ǝnwulteengya nda hangga, ahu ǝna ˈya kiya kyaɗang ɗǝ ndaarha fiya laɓarɗi ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Fiya na a wupǝri ɗi tsaha nda hai pǝmnggǝn sǝri, fingya a samad Yahudayini, fingya ƙǝm fǝrƙǝkafek nda tǝ laɓar nda Mbulus tǝ Mbarnaɓa. ");
INSERT INTO hwo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tǝrgha Yahudaya tǝ fingya mbuwa Yahudaya heu tǝ mamnggi ndan ƙǝnang ngganda ˈya hai na nda a ǝnang ndaa nda Mbulus tǝ Mbarnaɓa, na mindan sǝ a ƙǝsang ngganda kanda muk kanda nda tǝ ferya. ");
INSERT INTO hwo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sǝkna fathlǝngya Yeeso laɓarɗi kee ɗaa nda tǝ yiɓǝd ndan. Ɗǝnda hu chehweed Likoniya ɗǝ, ahu wupǝri Listra ɗǝ tǝ Ndarɓe tǝ fingya talya. ");
INSERT INTO hwo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pǝr laɓar ɗa nda na Mbǝnggǝn a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na nanda Mbulus tǝ Mbarnaɓa a Listra ɓa nda wal niifa sǝfǝnna sarghǝn. Ka nggǝttǝghǝn hai nǝghǝn kee, ˈwawa mbang wiirha wa. ");
INSERT INTO hwo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nǝghǝn a kang thlǝmaarha Mbulus fa nanǝn a pǝr laɓar Faara. Ƙǝlang na Mbulus hu yidsǝ naghǝnǝn na fǝrƙǝkafek sǝ a fadghǝn na a wal ƙǝnda nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tǝrgha Mbulus tǝranggǝn uradghǝn sǝ aaghǝn ndanggǝn, “Thliu sǝ!” Tǝrgha niifɗi thliigha sǝ harat katǝranggǝn wiirha hai. ");
INSERT INTO hwo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Fiya na kang thlǝmaarha Mbulus fa na nanda ǝnɗi ǝnanǝn tǝrang ngganda urad ndan sǝ ndaa nda tǝ mii nda yi Likoniyaya, “Faarya ni nafini ya, ɓanda thlǝmad nǝm ɓa ahu thlu farha!” ");
INSERT INTO hwo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ahu numad ndan Mbarnaɓa Ndzeyus ni thlǝm faara yi Nggirkaya, Mbulus ƙǝm tsaunǝn ndǝghǝn ni na a fǝr laɓara, aaghǝn nda Hemes. ");
INSERT INTO hwo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Firis yi ƙǝn Ndzeyustǝn nanda a ƙǝsǝr wupǝri ɗi, ɓagha ɓa tǝ thlaarha tǝ shiiya na tǝ fiirha fa a kwatkirǝm wupǝri ɗa ɓa, ƙǝsǝr ndǝghǝn tǝ fiya heu na mindan sǝ a ǝnang sataka nda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma sǝkna nda Mbarnaɓa tǝ Mbulus ǝnɗi na a katǝrarha hai, njarang ngganda lukki ndan ɗǝ ƙǝsǝr mbǝnang ngwa ǝnɗi kanda na mindan ǝnagha wa, ɗaa nda hur fiya ɗǝ na nda ahuhwaarha tǝ ndaarha, ");
INSERT INTO hwo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kun nafiniya, kama nun a ǝna ǝnɗiya? Nafiya ni kan ƙǝla kun! Ɓang nan laɓara kun ɓa na Mbǝnggǝn na a kyakhrun hai malanggun. ");
INSERT INTO hwo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ƙǝtǝm malang ɗǝ fiya heu tǝrang shilee nda faarya teena na mindan, ");
INSERT INTO hwo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","amma ˈwawa mal kanda kula ndǝghǝn kyad fadghǝn tǝ ǝna nggayirha a fiya tǝ ndaarha ndǝghǝn ǝnagha ƙǝshiirha kahat wa. Na ǝngya sǝ nǝn naarha ɗal ƙǝm in, ƙǝla yaara nǝn narha ɓang ƙǝm hai tǝ parkad ǝnnarhami tǝ ƙǝm lǝɗanggǝn hur nun tǝ wutsǝfayirha.” ");
INSERT INTO hwo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Amma ko nanǝn kee, nda Mbulus tǝ Mbarnaɓa pǝrpǝr ˈyaɗang na ndan nafina fa a ǝnanda sataka kanda wa. ");
INSERT INTO hwo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Amma fingya Yahudaya ɓagha nda ɓa a Antakiya tǝ Ikoniya fiya wumngga hai sǝk mii ndan nda, muk Mbulus nda, kahang ngganda ƙǝsǝr tala ɗǝ, tamngganda ndaarha mǝrɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hǝrǝmna fatakkwaya muwang maɗufu, tǝrgha thliigha sǝ wudgha hur wupǝri ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Akwasamadɗi pǝr nanda Mbulus tǝ Mbarnaɓa laɓar Faara a Ndǝrɓe, wal nda fiya hangga malangga ɗimiyid ndan, wuɗa nda Listǝra ɗǝ, tǝ Ikoniya, tǝ Antakiya na hu chehweed Mbisidiya. ");
INSERT INTO hwo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kanda a fǝrang kaali fatakkwaya, na nda yiyang thlǝmaarha kanda in na a isha nda hu fǝrƙǝkafekkid ndan tǝ shembe. Ndangganda kanda, “Ƙǝl tǝ sǝsaarha kaan ndǝnǝm kyarha hu kutǝryid talara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Akwasamadɗi wurang na nda Mbulus shingya sǝ hu ƙǝngya hwan Faara, hwan Faara nda tǝ kar aama aten ndan na a tsauka Faara tǝ kanda fǝr nanda ƙǝkafek tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tǝrgha kya nda tǝ chehweed Mbisidiya ɗǝnda Famfiliya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pǝr nanda laɓar Faara a Pǝrngga, ɗǝnda Ataliya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A mbǝɗani ya kya nanda hu nggirggi aama hai wuɗa nda Antakiya ɗǝ, a mbǝɗani kaar hwanang nanda Faara kanda in tǝ ndaarha a lafgha nggayid Faara kanda ahu tarɗi ngwalang nanda ya. ");
INSERT INTO hwo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sǝl nanda ɓa wumangganda fatakkwaya hai pǝr ǝnɗa nda heu ǝnana Faara aten ndan, tǝƙǝm inang kwamana fingya mbuwa Yahudaya kwaminda fǝrƙǝkafek hai. ");
INSERT INTO hwo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mǝna ndaha a mbǝɗi kanda heu tǝ fatakkwaya. ");
INSERT INTO hwo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Na nanda Mbulus tǝ Mbarnaɓa a Antakiya na a Suriya, ɓagha fingya nafiya ɓa a Yahudiya, katǝrang ngganda tsahang Ƙǝrǝstaya ha tǝ ndaarha, “Tǝta ni a thleng muwa nda kun, ƙǝla tsahang na ǝntin Musa ƙǝm ha, a mbǝ kee wa, mbun wal hǝrǝkrha wa.” ");
INSERT INTO hwo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nda Mbulus tǝ Mbarnaɓa ngaal nda pǝɗaghǝn tǝ kanda. A kwasamadghǝn, thlǝn nda Mbulus nda tǝ Mbarnaɓa tǝ fingya fa fǝrƙǝkafekkya a Urshalima ɗǝ, a thlǝma fathlǝngya Yeeso ɗǝ tǝ shingya aten palthɗi. ");
INSERT INTO hwo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Thlǝnna fa fǝrƙǝkafekkya a Urshalima ɗǝ, isha nda hai a kwamana ahu talya Finikiya tǝ Samariya, pǝrang nggǝnda kanda tǝ ndaarha fingya mubuwawa Yahudaya fǝr nda ƙǝkafek a Faara. A ten palthɗiya fa fǝrƙǝkafekkya ƙǝl ǝna wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sǝl nanda Urshalima ɗǝ, nda Mbulus tǝ Mbarnaɓa thlǝgha fa fǝrƙǝkafekkya kanda fa heu tǝ fathlǝngya tǝ shingya. Pǝr ǝnɗa nda ǝnana Faara tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amma fingya nafiya na a takkwa Farisaya thlii nda sǝ ndaa nda, “Tǝta ni a thleng muwa nda nafini mbuwa Yahudaya tǝ ƙǝm takkwa ngyakhrha ɗeleewar Musa nda.” ");
INSERT INTO hwo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Fathlǝnggini tǝ shingya tsawa nda hai ka tsǝ laɓara nda aten palthɗiya. ");
INSERT INTO hwo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","A kwasamadɗi ndik nanda atenggǝn kaan, thliigha Mbiturus sǝ ndǝghǝn, “Wan manggina, sǝnɗunsǝ kaar yi wurgha Faara nggi ahur nun sǝ, ka a pǝrang laɓar Faara ni fingya mbuwa wa Yahudaya tǝna nda sǝk Laɓarɗi na Mbǝnggǝn fǝrƙǝkafek nda. ");
INSERT INTO hwo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Faara, ndǝghǝnni sǝngga hur kowunni, kyadɗǝ ndaarha thlǝɗǝ kanda fa fǝrang nǝn Sǝsǝna kanda tǝ Peɗǝnda ƙǝla fǝrang nǝn ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wurwa ha sǝ a pathlang nǝm tǝ kanda wa, ƙǝsǝr tsuthlang ɗǝ hur ndan ɗǝ ƙǝsǝr ka fǝrƙǝkafekkid ndan. ");
INSERT INTO hwo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nanǝn kee, kama na minnun sǝ ƙǝƙǝrang nda Faara nun ɗǝfang rǝfrha na haaghǝn a urad nafiya mbuwa wa Yahudaya fǝrgha ƙǝkafek, mbuwana ƙǝm nduwa chichiyinǝm mbang ngwanda tǝrang wa? ");
INSERT INTO hwo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Awo! Fǝr ɗǝm ƙǝkafek tǝ ndaarha ahu nggayid Chinǝm Yeeso ni wal nǝm hǝrǝkrha, ƙǝla wal nanda.” ");
INSERT INTO hwo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fiya wumngga hai nggasa nda hai tǝtip, na nda a kang thlǝmaarha nda Mbarnaɓa fa tǝ Mbulus na nanda a pǝrang pathla kanda aten ǝnsakhkya tǝ ǝnwultengya, ǝnana Faara tǝ kanda ahur nafini mbuwa wa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ngwalana nda, tǝrgha thliigha Yakubu sǝ ndǝghǝn, “Wan manggina, Keema thlǝmaarha fa. ");
INSERT INTO hwo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siman Mbiturus saghang ɗa ndǝn ƙǝm kwaman ɗi na mid Faara a wurgha hasǝ ahur nafini mbuwa Yahudaya tsawa nda yighǝn. ");
INSERT INTO hwo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kyaharrǝ ɗa hai ki nafini mbuwa wa Yahudaya mǝmǝlɗǝ tǝ laɓar annabiya na chichirethlee hai ahu ɗeleewar Faara tǝ ndaarha.” ");
INSERT INTO hwo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Akwasamad ǝnɗiya niya wutta ɓa, Nggǝryi tǝnang wuri Ndauda. Chaɗa hai niya nggǝr tǝnang, Nggǝryi thleng nda sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Fiya takhka na nda kaɗa Chinǝm, Fingya mbuwa wa Yahudaya heu aah ni a tsawa nda yina, Ndagha Chinǝm kee, ǝnagha ǝngginiya,’ ");
INSERT INTO hwo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kyad nǝn ka ƙǝtǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Niyi a ndang nda kun, tama malanggǝm ɓilla nafini mbuwa Yahudaya na a kyaharra thlǝmad Faara ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","A meghedghǝn, nǝm a chireethleng kanda ɗǝ a malang ngganda kii ƙala ǝnnarhami paa nanda ɗahaya sǝ, tǝ kulafayirha tǝ ƙǝm kii thlu maɓiya tefreng nanda urad ndan tǝ saa fara. ");
INSERT INTO hwo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ƙǝsǝr na nda karatang nda ahu ɗeleewar ngyakhrha Musa ahu ƙǝngya tsahad Yahudaya tǝ kala wupǝri tǝ kala far yiɓǝd Yahudaya ka chichiiya hangga.” ");
INSERT INTO hwo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tǝrgha fathlǝnggini tǝ shingya, tǝ fatakkwaya Yeeso heu ƙǝla nda hai kamɗǝ a wur nafi ndan nda thlǝnang ngganda kanda a Antakiya ɗǝ heu nda Mbulus tǝ Mbarnaɓa. Wur Yahuda nda na nda aarha Mbarnaɓa tǝ Sila, mamngya ni kanda ahur fatakkwaya Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kulo ɗeleewar ɗi chireelth nanda haaɗǝ ya: Ɗeleewar ɗiya ɓaghǝn ɓa a har fathlǝngya Yeeso tǝ shingya, wan mamngginun na a Urshalima. A nafiya mbuwa wa Yahudaya fǝrgha ƙǝkafek tǝ Yeeso na a Antakiya, Suriya, tǝ Ƙǝlikiya, nan a ndangˈya kun fa. ");
INSERT INTO hwo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sǝkɗan ndaarha ɗǝd fingya ɗǝ a mbǝɗa ɗǝ ya, ɓillad nda kun tǝ tsang teena kun tǝ tsahan ndan ha, amma thlǝngwan kanda a ndang ngganda kun kee wa. ");
INSERT INTO hwo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nanǝn kee, kan heu tsauɗan hai nggǝman fa a wur nafiya nan thlǝnanggan kanda a thlǝmannun ɗǝ tǝ pashiyi nan nda Mbarnaɓa tǝ Mbulus, ");
INSERT INTO hwo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","nafini hengga yiɓǝd ndan ɗǝ ka thlǝm Chinǝm Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tsaunǝn kee, nan a thlǝnang Yahuda tǝ Sila kun ɗǝ ka ɗa nda pǝrang ǝnggini kun chireethleng nan kun ɗǝ atenggǝn tǝ mii ndan. ");
INSERT INTO hwo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Nǝghǝn ngga a Sǝsǝna tǝ Peɗǝnda tǝ kan ƙǝm mbǝ ka a fǝrang rǝfrha nan kun pak ma fingyayini na chichireethlee hai ya wa. ");
INSERT INTO hwo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Malaman hǝb ǝnnarhami pang nanda ɗaharha, tǝ saa fara tǝ kii thlu maɓiya tefreng nanda urayindan tǝ ƙǝm kulafayirha. A laf ɗun ǝngginiya, na tsawud nun a narha ngga. Mal ɗan kun hu ɗǝɗemnggirha.” ");
INSERT INTO hwo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nafini wii nda a Antakiya ɗǝ, ɗa nda wumang nda fatakkwaya Yeeso hai fǝrang ɗeleewar ɗa nda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Karatangga nafini tǝk mbǝnda nda fa ka laɓarɗi sǝk nda. ");
INSERT INTO hwo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nda Yahuda tǝ Sila annabiya ni kanda, thlǝk palthya nda hangga a Ƙǝrǝsta yini tǝ fǝrang kanglanggirha kanda. ");
INSERT INTO hwo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A kwasamadɗi mǝn nanda ɓeena ha a mbǝɗi, ɗǝfangganda kanda ɗǝ hu ɗǝɗemnggirha wuɗa nda a thlǝmad nafina ɗǝ thlǝngga kanda ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Amma nda Mbulus tǝ Mbarnaɓa tsawa nda a Antakiya, a mbǝɗi kanda tǝ fingya hangga na nda a tsahang fiya ha tǝ pǝr laɓar Chinǝm a kanda. ");
INSERT INTO hwo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A kwasamad ɓengya ndangga Mbulus Mbarnaɓa, “Tam wuɗum ɗǝm weng tala fatakkwaya Yeeso na ahu tal yini ˈwanǝm pǝr laɓar Chinǝm sǝ, ɗǝm na kanda tǝnaa nda ƙǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Na mid Mbarnaɓa sǝ a tahang ngganda Yahaya Markus ha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amma Mbulus mbǝ midghǝn sǝ a tahang ngganda Yahaya Markus haaɗǝ wa, ƙǝsǝr malɗǝ kanda a Pamfiliya tǝ ƙǝm karɗa fa na a ɗǝnda mbeeɗǝ tǝ tarɗi. ");
INSERT INTO hwo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A mbǝɗi kya nda hu ngaala hai kaan pa ɗǝgha nda hai. Tǝrangga Mbarnaɓa Yahaya Markus kya nda hu kombuwol hai ɗǝnda Sayifurus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amma Mbulus wur Sila nǝn wii nda, fa fǝrƙǝkafekkya hwan nggayid Chinǝm nda a tǝranggǝn kanda ɗǝ ɗǝɗem. ");
INSERT INTO hwo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kya nda tǝ Suriya tǝ Kilikiya ka ɗa nda fǝrang kanglanggirha fatakkwaya Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nda Mbulus tǝ Sila ˈwa ɗǝrha nda Ndarɓe ɗǝ a ɗǝnda Listǝra ɗǝ. A mbǝɗi na tǝ tsaharha ha sǝ, thlǝmnggǝnni Timoti man tǝ Yahudarha ni fǝrgha ƙǝkafek, amma chin tǝ Helenarha ni. ");
INSERT INTO hwo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Fa takkwaya Yeeso na a Listǝra tǝ Ikoniya kanda a falghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Nanǝn kee, na mid Mbulus sǝ a tahang ngganda Timoti haaɗǝ, thleng muwanǝn ƙǝsǝr ka Yahudaya na a mbǝɗi, kowunni sǝndasǝ chin tǝ Helenarha ni. ");
INSERT INTO hwo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","A sayidɗi nanda a wiirha, na nda a takkwa tala-tala kanda a thlǝghanggǝn fiya ˈya ƙǝnang na fathlǝngya hai tǝ shingya na a Urshalima na a laf kanda nda. ");
INSERT INTO hwo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Fa takkwaya Yeeso na nda aten chikrha hu fǝrƙǝkafek tǝ hang nda fiya kafad ɗalthla mbǝrha fa hai. ");
INSERT INTO hwo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mbulus tǝ ka wiiyighǝn weng ngganda chehweed Firijiya hai tǝ Nggalatiya, ƙǝsǝr Sǝsǝna tǝ Peɗǝnda ˈyaɗang ɗǝ thlǝk laɓar Faara kanda fa a chehweed Asiya. ");
INSERT INTO hwo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sǝlnanda mii chehweed Misiya, tǝr mindan sǝ ɗǝrha a Mbitiniya ɗǝ, amma Sǝsǝn Yeeso nggǝmangwa kanda fa wa. ");
INSERT INTO hwo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","A meghedghǝn, kya nda tǝ Misiya sǝla nda a Turuwas ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A fǝɗikrha, sǝsǝniigha Mbulus tǝ niif Makidoniya ƙǝt nagha a hwanggǝn tǝ ndaarha, “Ɓo Makidoniya ɓa, ɓa ɗang nda kan sǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nanǝn kee, ngwan fa ka a ɗan Makidoniya ɗǝ, tǝ numad ndaarha Faara aagha kǝm a ɗǝm thlǝghang Laɓara na Mbǝnggǝn a kanda. ");
INSERT INTO hwo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kyan ahu kombuwol hai a Turuwas, ɗan Samutarki ɗǝ, ɗalthna mbǝrha hai tǝran hai a Niyapolis. ");
INSERT INTO hwo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Thlen a mbǝɗi ɗan Filibi ɗǝ manda wupǝri na ahu chehweed Makidoniya. Wupǝri ni tǝnna kutǝryid Roma; tsawan yi ɓeena hangga a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A far yiɓǝd Yahudaya ɗan ƙǝsǝr wupǝri ɗa ɗǝ a mii kufaarha, a mbǝɗi nan a numad ndaarha nan a wal mbǝd hwan Faara. Tsawan hai, katǝranggan kalang nishya sǝ wumngga hai a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tal ahur nishyini na a kang thlǝmaarha kan fa thlǝmnggǝn Lidiya na heng kaɓaya na tǝ wuɗǝɓǝla fa, ɓaghǝn ɓa a wupǝri Tayatira, nǝn tǝrang shilee Faara teena. Chinǝm inanggǝn hurghǝn ɗǝ thlǝ laɓar Mbulus nǝn fa. ");
INSERT INTO hwo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ənang mbaptisǝma nda heu tǝ nafiya wurighǝn, hwan kan nǝn a ɗan wuri keeghǝn ɗǝ ndǝghǝn, “A nggǝmɗun fa tǝ fǝrƙǝkafek ni nggi a Chinǝm, ɓama ɓa ɓun tsaurha a wuri kyana.” Djib hwan kan nǝn pa ɗan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na farɗa sǝ kan ɗiye a mbǝd hwan Faara ɗǝ, ƙǝman tǝ mafad wee nuwun nǝghǝn tǝ ǝnkaheerha fa yi kularha. Walang ɗǝ ƙǝna turighǝn sǝ kaan ahu tar kuladɗi. ");
INSERT INTO hwo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nǝn takkwa samad nan nagha ahuhwaarha tǝ ndaarha, “Nafiniya mafaya Faara Amshi ni, ɓa nanda ɓa ka a pǝrang kwaman wal hǝrǝkrha nda kun!” ");
INSERT INTO hwo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɓengya hangga nǝn naarha ndaarha kee. Tǝrgha Mbulus sǝbgha hurghǝn ɗǝ, kyahargha hai ndanggǝn ǝnkahedɗi, “A hu thlǝm Yeeso Ƙǝrǝsti nduwu hai tǝghǝn!” Tsu ƙee ndǝkka hai tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kǝlaana turid mafad wee nuwun ɗa hai kwaman wallǝnɗan nggǝlɗǝ, kǝsang ngganda Mbulus tǝ Sila ɗǝnda tǝ kanda ahu kasuɗǝ a mbed fa ngwa kumaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɗǝnda tǝ kanda a mbed mamngya fa ngwa kumaaya ɗǝ, ndaa nda, “Nafiniya Yahudaya ni, na nda tsang teena nafinan kaan. ");
INSERT INTO hwo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Na nda tsahang ǝntingya kanha mbuwa mǝmǝl tǝ ƙǝm Romaya.” ");
INSERT INTO hwo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Fiya wumngga hai a mbǝɗi katǝrang ngganda har nda Mbulus tǝ Sila tǝ yanda, mamngya fa ngwa kumaaya ndanggǝn fingya fiya a ƙǝɗang ngganda kanda hai tawalth, ɗǝk kanda nda. ");
INSERT INTO hwo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A kwasamadɗi ɗǝk nanda kanda muwang ngganda kanda hu porsǝna ɗǝ ndang ngganda fa kǝla mbǝɗa ha a ƙǝla kanda nda ha ngga. ");
INSERT INTO hwo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tǝ ƙǝla ƙǝn porsǝn ɗaha kǝm hǝrǝm nǝn sǝkkǝn kee muwanggǝn kanda a kambǝrhaɗǝ kaan pang ngganda saryindan ahu ɗǝfrha hai. ");
INSERT INTO hwo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A manad fǝɗikrha nda Mbulus tǝ Sila na nanda a hwan Faara tǝ aagha amshe yi fal Faara, nagha fingya porsǝngya a kang thlǝmaarha kanda fa. ");
INSERT INTO hwo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kula sǝndǝndan sǝ, rǝbgha chehweerha fa heu tǝ sar ƙǝn porsǝn ɗi. Tsu kee kwat mingya porsǝn ɗi heu ina nda ɗǝ, wuyiwurya ƙǝnang nanda porsǝngya sǝ heu kwasa nda hai ");
INSERT INTO hwo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mehenna tǝ kǝla mbǝɗa ha a ɓeena, kǝla hai kwatmingya heu inda ɗǝ. Ƙǝɗanggǝn thlau ƙǝlarghǝn sǝ na midghǝn sǝ a ɓǝlanggǝn fadghǝn, ahu numadghǝn tamnggǝn ndaarha porsǝnggini heu kyanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amma tǝrangga Mbulus uradghǝn sǝ kaan ndanggǝn, “A ǝnang na wundǝrha fadwa fa wa, kan heu nan a mbǝɗiya!” ");
INSERT INTO hwo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tǝ kǝla porsǝn ɗa ha ndaagha a ɓang patilla nda ɓa, mbǝngga a ƙǝnɗa ɗǝ ɓǝrgha hweeɗa hai tǝ kurumnggǝn a mbǝd nda Mbulus tǝ Sila, nagha fadghǝn heu a rǝbrha fa. ");
INSERT INTO hwo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kyagha tǝ kanda ƙǝshaaɓa tsahang mee nǝn kanda, “Kun mamngya, mani ǝnaarha tǝni hǝrǝkrha?” ");
INSERT INTO hwo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ndang ngganda, “Furu ƙǝkafek a Chinǝm Yeeso, na wal hǝrǝkrha heu tǝ wuriwa.” ");
INSERT INTO hwo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tǝrgha pǝrang laɓar Chinǝm nda tǝ fingya heu na a minda keeghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A fǝɗikɗi wu tǝ ƙǝla porsǝn ɗaha haranggǝn kanda, tsaɓang wundǝyi ndan nǝn kanda ɗǝ. A mbǝɗi kǝm ǝnang mbatisǝma nda heu tǝ wurighǝn. ");
INSERT INTO hwo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tǝrgha ɓagha tǝ kanda minda keeghǝn ɓa fǝrang ǝnnarhami nǝn kanda. Ndǝghǝn tǝ fa wurayighǝn heu na nda a ǝna wutsǝfayirha ƙǝsǝr kanda heu fǝr nda ƙǝkafek a Faara. ");
INSERT INTO hwo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ɗalthna mbǝrha hai, thlǝngga fa ngwa kuma yini farha a thlǝmad tǝ ƙǝla porsǝn ɗaɗǝ tǝ ndaarha: “Kalu hǝshyina hai ya.” ");
INSERT INTO hwo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tǝ ƙǝla porsǝn ɗaha ndanggǝn Mbulus, “Fa ngwa kumaaya thlǝngga ɓa a kal sa ni hai tǝ Sila. Nanǝnya weema ahu ɗǝɗemnggirha.” ");
INSERT INTO hwo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma nggǝrangga Mbulus nafina sǝ thlǝn nanda kanda ɓa, “Ɗǝk nda kan a pǝpal kula kanda ngwang kumarha kan sǝ, muwang ngganda kan ahu porsǝna ɗǝ kan ƙǝm wangya Romaya ni kan. Nanǝnya na mindan sǝ kee ween ɓǝɓee? Ƙǝkafek mbǝ ǝnaarha hai kee wa! Ndaaman kanda a ɓa nda ɓa tafandan ɓa nda kal kan hai.” ");
INSERT INTO hwo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nafini thlǝn nanda ɓa ɗǝnda ɗǝ ɗa nda pǝranggǝn fa ngwa kumaaya, sǝk nanda ndaarha nda Mbulus tǝ Sila wangya Romaya ni tǝrma nda. ");
INSERT INTO hwo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓanda hu ƙǝn porsǝn ɗa ɓa hwan kanda nda a chahanggǝn nda kanda ɗǝ, kyang ngganda kanda sǝ ma porsǝn ɗi mal wupǝri ɗa nda. ");
INSERT INTO hwo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","A kwasamadɗi kya nanda Mbulus sǝ tǝ Sila ahu porsǝn ɗi, ɗǝnda wuri ki Lidiya ɗǝ. A mbǝɗani wumna nda sa hai tǝ fatakkwaya Yeeso fǝrang kanglanggirha nda kanda a wii nda. ");
INSERT INTO hwo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kya nanda Mbulus tǝ Sila tǝ Amfipolis tǝ Apoloniya, ɓa nda Tasalonika ɓa na ƙǝn tsahad Yahudaya sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ƙǝla sǝsǝnna Mbulus sa hai kyagha hu ƙǝn tsahad Yahudayina ɗǝ, a far yiɓǝd Yahudaya katǝra mahan a miighǝn a miighǝn tsǝ laɓara nǝn tǝ fiya ahu ɗeleewar Faara. ");
INSERT INTO hwo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pǝrang nggǝnǝn kanda a pǝpal ˈya ndana ɗeleewar Faara tǝ ndaarha Ƙǝrǝsti sǝsaaɗǝ tǝ ƙǝm thliiɗa sǝ hu mǝra. Ndanggǝn kanda, “Yeeso ɗi niya pǝrang nda kun ya Ƙǝrǝsti ɗa ni.” ");
INSERT INTO hwo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Fingya Yahudaya nggǝmnda fa wum teena nda tǝ nda Mbulus tǝ Sila, ƙǝla ǝnana Helenaya hangga na a tǝrǝm Faara tǝ man nishya na tǝ thlǝma in. ");
INSERT INTO hwo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amma nagha Yahudayini a sǝrǝkrha, ɗa nda wumang fa thlǝmǝngya ɓa ahu kasu, thliigha kakyathlanga sǝ a wupǝri ɗi. Ɗa nda minda ki Djason ɗǝ na nda a kaɗa nda Mbulus tǝ Sila ka a kyang ngganda kanda ahur fiya ɓa wumngga hai. ");
INSERT INTO hwo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amma nawa nanda kanda, kahang ngganda Djason ɓa tǝ fingya fatakkwaya Yeeso ɓa nda tǝ kanda a mbed mamngya wupǝri ɗa ɓa na nda ahuhwaarha, “Nafini ya kanda ni na a tsang teena fiya hu ƙǝshiirha kahat nanǝnya kulo kanda ya. ");
INSERT INTO hwo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Djason thlǝɗǝ kanda fa a minda keeghǝn. Kanda heu kar nda ǝna taara tǝ ngyakhrha Kaisar, na nda a ndaarha wai na kutǝra sǝ pak, yanɗi na nda aarha Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sǝk nanda kee, fiya wumngga hai tǝ mamngya wupǝri ɗi sǝbgha hur ndan ɗǝ tsangga teena kanda. ");
INSERT INTO hwo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tǝrgha ndang ngganda Djason tǝ fingya a fǝr wuɗǝɓǝla nda a malang ngganda kanda wii nda. ");
INSERT INTO hwo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tsǝna fiɗikrha hai, Fa takkwaya Yeeso thlǝnang ngganda nda Mbulus tǝ Sila a Mberiya ɗǝ. Sǝl nanda a mbǝɗa ɗǝ, kya nda ahu ƙǝn tsahad Yahudaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nafiya Mberiya kal nda Tasalonikaya hakkilo, ƙǝsǝr thlǝnda laɓar ɗa fa tǝ haara kikyab na nda naarha huleu laɓar Faara ƙǝtsar tǝna nda sǝn ƙǝkafekkid palthɗi pǝrang na Mbulus kanda. ");
INSERT INTO hwo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yahudaya hangga fǝrgha ƙǝkafek, ƙǝla ǝnana Helenaya, man nishya na tǝ thlǝma in tǝ hǝshya hangga. ");
INSERT INTO hwo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sǝkna Yahudaya na a Tasalonika ndaarha na Mbulus a pǝr laɓar Faara a Mberiya, ɗǝnda mbǝɗaɗǝ ƙǝm, ɗa nda shighang fiya fa wumngga hai tǝna nda thleng yanda. ");
INSERT INTO hwo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Fa takkwaya Yeeso na a mbǝɗi thlǝnang ngganda Mbulus a mii wuri aama ɗǝ, amma nda Sila tǝ Timoti tsawa nda a Mberiya. ");
INSERT INTO hwo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nafini ɗǝfangga Mbulus a Atina ɗǝ ndanggǝn kanda ɗa nda pǝrang ndaarha Sila tǝ Timoti ɓa nda walghǝn wed. ");
INSERT INTO hwo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nana Mbulus a ƙǝla kanda fa a Atina, thleegha hurghǝn nanǝn talɗi lǝghǝdɗǝ tǝ ɗahaya. ");
INSERT INTO hwo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nanǝn kee, ɗǝgha hu ƙǝn tsahad Yahudaya ɗǝ ka ɗǝgha tsǝ laɓara tǝ kanda tǝ Helenaya na a tǝrǝm Faara. Ka fad ɗathla mbǝrha fa hai nǝn naarha ɗǝrha hu kasu ɗǝ nagha a kalang fingya sǝ wal nǝn a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Fingya fa malǝmngya Abikuriyaya tǝ Sǝtokiyaya katǝrang ngganda ngaala hai tǝghǝn ka pǝrang nǝn laɓar Yeeso kanda tǝ thliidghǝn sǝ ahu mǝrra. Nanǝn kee tsakhka fingya mee, “Mana tǝ pǝpethɗi a ndaarha ya?” Tǝ ƙǝm ndagha fingya, “Na midghǝn sǝ pǝr laɓar weerǝnda faarya nǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tǝrgha ɗǝnda tǝghǝn ahu wum ten fa sǝngya ɗǝ a mbǝrha na nda aarha Aropaggus ndang ngganda, “Pǝrang laɓara kan ngga aten weerǝnda tsahadɗa ha kyawa ɓana ɓa tǝghǝn ya. ");
INSERT INTO hwo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nana a lǝɗang thlǝman nan tǝ palthya pak, na minnan sǝ a sǝn ǝnggina nan ya ngga.” ");
INSERT INTO hwo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atinaya heu tǝ rongya na tǝ tsaurha a mbǝɗi na nda naarha tsaurha hai kee ƙǝl tsǝ laɓara aten weerǝnda palthɗi kyagha ɓa.) ");
INSERT INTO hwo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Thliigha Mbulus sǝ ahu wum tenɗi na a Aropaggus ndǝghǝn, “Nafiya Atina! Naɗi kun nafiya ni na mindan tǝrang shilee faarya teena hangga. ");
INSERT INTO hwo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ƙǝsǝr a naɗi a wiirha hai ahur talɗi ya ni naarha ƙǝlang nda ǝnggini nun naarha tǝrang shilee kanda teena, tǝ ƙǝm naɗi mbǝd nji sataka tǝ chireethla a man tenggǝn tǝ ndaarha, ‘A Faara sǝngwa wa nǝm’. Tur faarɗi nun a tǝrang shilee teena sǝngwa wa nun, ndǝghǝnni ni a pǝrang nda kun.” ");
INSERT INTO hwo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Faarɗi ǝnagha ƙǝshiirha tǝ ǝngya heu na ahurghǝn ndǝghǝnni Chinǝm yi talara tǝ hweeɗe, mbǝ tsaurha ahu ƙǝnna tǝnna fiya wa. ");
INSERT INTO hwo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mbǝm fǝrang ˈya tǝ haara wa, mbǝ kaɗa thlaara a haar niifa wa, ƙǝsǝr ndǝghǝn tafadghǝn nǝn fǝrang yibrha fiya tǝ fingya ǝngya heu. ");
INSERT INTO hwo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A fad niifa tǝtal ndǝn ǝnanǝn turya fiya ɗǝɗamǝn-ɗǝɗamǝm ahu ƙǝshiirha kahat. Kapa nǝn ǝna kanda sǝnɗǝ sayi kamngga tǝ kanda tǝ ƙǝm mbǝrha kamngga a tsawa nda sǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Ənana Faara ndǝn kee tǝna fiya kaɗaghǝn asǝmha na nda walang ngganda, ko nanǝn mbǝ inggun ma ƙǝm wa.” ");
INSERT INTO hwo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Ƙǝsǝr nǝghǝm tǝ tsaurha ahurghǝn, tǝ wiirha hai, ndǝn nanǝm sǝ a weeriya.” Ƙǝla ndaana fa amshiiyi nun, “Ƙǝm wanggighǝn ni.” ");
INSERT INTO hwo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tsaunǝn ƙǝm wangya Faara ni, mǝmǝlwa numam tǝ ndaarha Faara nǝghǝn ƙǝla ɗaharha taksa fa mbǝr ǝngya tǝ ɗǝɓǝla, nduwa feera nduwa ɗǝfrha wa. ");
INSERT INTO hwo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ƙǝtǝm djiɗangwa Faara tǝ yamid sǝnda fiya wa, amma nanǝnya ndanggǝn fiya heu ko a yanggini a malang ngganda ɗahayi ndan kyakhra nda thlǝmadghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ƙǝsǝr ɗǝfang ɗǝ fara hai nǝn a ngwang kumarha ƙǝshiirha yi ƙǝkafek tǝ haar niifɗi wur nǝn. Kyaɗang ɗǝ niifɗi kowunni a pǝpal tǝ thleng nǝn sǝ ahu mǝrra.” ");
INSERT INTO hwo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hǝrǝm nanda sǝk laɓara aten thliirha sǝ ahu mǝrra, fingya waghǝn nda, fingya ndanda, “Na minnan sǝ a nggǝrgha pǝrang palthɗi kan ya.” ");
INSERT INTO hwo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tǝrgha malgha Mbulus kogna yini. ");
INSERT INTO hwo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amma fingya mbu samadghǝn nda tsawanda fa fǝrƙǝkafekkya. A hur ndan na Ndiyonisiyus sǝ nǝghǝn tal ahur kogna yini, tǝ nuneefa ƙǝm na thlǝmnggǝn Ndamaris tǝ fingya hangga. ");
INSERT INTO hwo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","A kwasamadghǝn, malgha Mbulus Atina ɗǝgha a Koronti ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A mbǝɗi wal tǝ Yahudarha nǝn sǝ na thlǝmnggǝn Akila, wan chehweed Pontus. Ɓaghǝn ɓa a Italiya kanda tǝ nukkun Pǝrisila, ƙǝsǝr kutǝra Ƙǝlaudiyus ndanggǝn Yahudaya heu a mal Roma nda. Ɗǝgha Mbulus ɗǝ ka a na kanda nǝn, ");
INSERT INTO hwo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ƙǝsǝr nanǝn targhǝnni taksa chaama ƙǝla na nanda, tsauka a thlǝman ndan ǝna taara nǝn tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kala Far Yibrha nǝn tsǝ laɓara tǝ Yahudaya tǝ Helenaya ahu ƙǝn tsahad Yahudaya, na midghǝn sǝ a lǝm kanda nǝn fa. ");
INSERT INTO hwo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ɓana nda Sila ɓa tǝ Timoti a Makidoniya, ɗǝfgha Mbulus teena hu pǝr laɓar Faara hai, nagha a kyaɗanggǝn Yahudaya tǝ ndaarha Yeeso ndǝna Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amma ngaalang ngganda Mbulus na nda a ˈyarghǝn, ɗǝghanggǝn tinid ɗa ɗǝ na a fad luwudghǝn ndanggǝn kanda, “A tsauka hakked nun atennun! Mbǝ ɗimiyirha sǝ a fanna wa. Nanǝnya niya ɗǝrha a ki nafiya ɗǝ mbuwa wa Yahudaya.” ");
INSERT INTO hwo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tǝrgha Mbulus mal ƙǝn tsahad Yahudayina nǝn ɗǝgha minda ki Titiyus Djustus ɗǝ, tǝ tǝrang shilee Faara teena. Na kwatkirǝm nggǝn tal tǝ ƙǝn tsahadɗa fa. ");
INSERT INTO hwo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tǝrgha Ƙǝripus mamnda ƙǝn tsahad Yahudaya, heu tǝ wurighǝn fǝr nda ƙǝkafek a Chinǝm. Fingya Korontiyaya hangga sǝkka ndǝn fǝrƙǝkafek nda ǝnang mbaptisǝma nda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Farɗa sǝ a fiɗikrha kyaɗangga Faara ˈya Mbulus ahu sǝsǝniirha, ndanggǝn, “A tǝrǝmna wa; ɗuwa mbeeɗǝ tǝ laɓar wa, a nggasna hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Niyi tǝ sa ha, mbǝ niifa sǝ ɗǝk sa nduwa ǝno ˈya nǝn fa wa, ƙǝsǝr na nafina sǝ hangga ahu wupǝriɗi ya.” ");
INSERT INTO hwo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nanǝn kee, tsauka Mbulus yi hurarha tal tǝ mbeera, nagha a tsahang laɓar Faara kanda ha. ");
INSERT INTO hwo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amma a thlakh mbǝdɗi na Nggaliyo ngwamna a chehweed Akaya, wumangga Yahudaya tendan ka a thlengganda Mbulus fa ɓa nda tǝghǝn mbed ngwamna ɓa ka a ngwang kumarha nǝn sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ndanda, “Niifɗiya nǝghǝn a lǝm fiya fa a tǝrang shilee nda Faara teena ahu kwamana ˈyaɗana ngyahad nǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nana Mbulus a kalgha sǝ kee, ndangga Nggaliyo Yahudaya, “Kun Yahudaya, a ndam ƙǝsanggun kamshiɗiya tǝ ɗimiyirha fa nduwa ǝnaɗǝ ˈya na manggǝn mbuwa wa ngga, kam niya kang thlǝmaarha kun fa. ");
INSERT INTO hwo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma nanǝn nǝghǝn aten tsakh mee ni ahu laɓara tǝ aten thlǝmngya tǝ ƙǝm ngyahad nun, ngwalaman palthɗi tafad nun, mbi ngwa kumarha aten ǝngya kiya wa.” ");
INSERT INTO hwo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nanǝn kee, rǝghanggǝn kanda ɗǝ ma ƙǝn ngwa kumadɗi. ");
INSERT INTO hwo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tǝrgha kyakhrang ngganda Sostanus teena mamnda ƙǝn tsahad Yahudaya ɗǝkƙǝnda a kwatkirǝm ƙǝn ngwa kumadɗi. Amma djiɗangwa ˈya Nggaliyo wa. ");
INSERT INTO hwo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","A kwasamad ǝnɗiya mǝngga Mbulus ha a Koronti. Tǝrgha mal fatakkwaya Yeeso nǝn kyagha hu kombuwol hai, mbugha nda Pǝriskila tǝ Akila samadghǝn, ɗǝna nda Suriya ɗǝ. (Kapa nǝn wiirha thlǝrɗang ɗǝ tenggǝn ɗǝ a Kankiriya ƙǝsǝr ka ɗǝfmee ǝnanǝn.) ");
INSERT INTO hwo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sǝla nda a Afisa ɗǝ, a mbǝɗi malgha Mbulus Pǝriskila hai tǝ Akila. Tǝrgha ndǝghǝnggi tafadghǝn kyagha ahu ƙǝn tsahad Yahudaya ɗǝ ka a tsǝ laɓara tǝ Yahudayini. ");
INSERT INTO hwo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Hwanggǝnda a mǝngga ha, amma kargha fa. ");
INSERT INTO hwo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amma kapa nǝn wiirha ndanggǝn kanda, “A nggǝm Faara fa, niya nggǝr wutta ɓa.” Tǝrgha kyagha ahu kombuwol hai mal Afisa nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tǝrnǝn hai a Kaisariya, ɗǝgha ka ndangˈya fatakkwaya Yeeso ɗǝ na a mbǝɗi a mbǝrgha a Antakiya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A kwasamadɗi mǝnnǝn ha a Antakiya, thliigha ɗǝgha mbǝya ɗǝ hangga a Nggalasiya tǝ Pilisiya, nagha a ɗang nda fatakkwaya Yeeso sǝ na a tsawa nda tǝ kanglanggirha hu chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na tǝ Yahudarha sǝ thlǝmnggǝnni Apolos, ɓagha Afisa ɓa. Nggǝtgha ndan a wupǝri Aledzandariya, tǝ mbǝrmee ni sǝnɗǝ laɓar Faara kaan. ");
INSERT INTO hwo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tsahang nda kwaman Chinǝm ha, tǝ ƙǝm nǝghǝn a tsahang fiya ha tǝ mbǝnafarha fa. Tsahadghǝn ha aten Yeeso nǝghǝn mǝmǝl. Ko nanǝn, mbaptisǝma yi Yahaya ndǝn sǝnnǝn kee. ");
INSERT INTO hwo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Katǝranggǝn ndikrha hai tǝ kanglanggirha hu ƙǝn tsahad Yahudaya. Sǝkna nda Pǝriskila tǝ Akila ndǝn aaghǝn nda a minda kyandan ɗǝ pǝrang kwaman Faara nda mǝmǝl. ");
INSERT INTO hwo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nana mid Apolos ɗǝrha a Akaya ɗǝ, fatakkwaya Yeeso chighang kanglanggirha nda tǝ ƙǝm chireethleng ngganda fatakkwaya Yeeso ɗǝ na a mbǝɗi tǝna nda thlǝghǝn fa. Sǝlnǝn mbǝɗaɗǝ, thlar fingya nǝn kaan fǝrgha ƙǝkafek tǝ nggayid Faara. ");
INSERT INTO hwo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ƙǝsǝr kalɗǝ Yahudayina mu ngaal nǝn tǝ kanda hu yid fiya hangga, kyaɗanggǝnǝn kanda tǝ ndaarha hu ɗeleewar Faara Yeeso ni Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nana Apolos a Koronti, tǝr Mbulus kwamana ahu chehwedɗi ɗǝgha Afisa ɗǝ. A mbǝɗani ɗǝnǝn wal fatakkwaya Yeeso sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tsahang mee nǝn kanda, “Fǝr nun ƙǝkafek thlǝɗun Sǝsǝna tǝ Peɗǝnda fa wa?” Nggǝrang ngganda sǝ, “Awo, kyawan sǝn ndaarha na Sǝsǝnasǝ tǝ Peɗǝnda wa.” ");
INSERT INTO hwo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tsakhka Mbulus mee, “Tur yanggi mbaptisǝma ǝnang nanda kun?” Ndang ngganda, “Mbaptisǝma yi Yahaya.” ");
INSERT INTO hwo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ndagha Mbulus, “Mbaptisǝmad Yahaya yi mal ɗimiyirha ni. Ndanggǝn fiya a fǝrƙǝkafek nda tǝ niifa na ɓayi a samadghǝn, ndǝna Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sǝk nanda kee, ǝnang mbaptisǝma nda kanda ahu thlǝm Chinǝm Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ɗǝfang na Mbulus haara kanda teena, ɓagha Sǝsǝna tǝ Peɗǝnda tendan hai, na nda a ndikrha tǝ miiya pak tǝ ƙǝm na nda thlǝk laɓara ɓagha hai a thlǝmad Faara ƙǝla annabiya. ");
INSERT INTO hwo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kanda hǝshya kumkap sǝri ni. ");
INSERT INTO hwo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tǝrgha Mbulus kyagha hu ƙǝn tsahad Yahudaya ɗǝ nagha a pǝr laɓar Faara tǝ kanglanggirha yi ndǝree mahan, nagha a lǝm kanda fa tǝ thlǝghang laɓar Kutǝryid Faara kanda. ");
INSERT INTO hwo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma fingya kar nda laɓarghǝn fa. Na nda a ndikrha mbuwa ngga a pǝpal aten kwaman Chinǝm. Malangga Mbulus kanda, wiigha tǝ fatakkwaya Yeeso ɗa nda naarha tsǝ laɓara ƙǝtsar a mbǝd tsaharha ha na a Tǝranus. ");
INSERT INTO hwo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Huraya sǝri kanda a ǝnaarha kee, tǝna Yahudaya tǝ Helenaya na tǝ tsaurhahu chehweed Asiya sǝk laɓar Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Fǝrang Faara sǝsǝmnda Mbulus a ǝna ǝnwulteengya nǝn na mǝmanggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ko ǝn pa farha nduwa shishimar tsuwargha ndǝn fa, a ɗang ndan haaya ɗǝ, na nda ƙǝnda tǝ ƙǝm ǝnkaheeya na a fad ndan a kyarha sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Fingya wumten Yahudaya na a wiirha hai tala-tala kanda a kyang ǝnkaheeya sǝ katǝrang ngganda ǝna taara hai tǝ thlǝm Chinǝm Yeeso. Na nda a ndaarha, “Niyi a ndorha hu thlǝm Yeeso, na Mbulus a pǝr laɓarghǝn, kyosǝ!” ");
INSERT INTO hwo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wangya hǝshya mǝd yi Skiva mamnda firis Yahudaya kanda na a ǝna ǝnɗiya. ");
INSERT INTO hwo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Farɗasǝ nggǝrangga ǝnkahedɗi kanda sǝ, “Sǝnɗi Yeeso, tǝ ƙǝm sǝnɗi Mbulus, amma wunni kun?” ");
INSERT INTO hwo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tǝrgha niifɗi na tǝ ǝnkahedɗa fa pǝrgha tendan ɗǝ har kanda nǝn yanda kal kanda nǝn mu heu. Ɗǝk kanda nǝn kya nda sǝ tǝ ɗaarha ahur mindǝɗi tawalth tǝ wundiya fa a fad ndan. ");
INSERT INTO hwo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Sǝkna Yahudaya ndǝn tǝ Helenaya na tǝ tsaurha a Afisa, tǝrma nda heu, fǝrang mamnggirha nda thlǝm Chinǝm Yeeso kaan. ");
INSERT INTO hwo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Fingya hangga fǝrgha ƙǝkafek kya nda pǝpal ɓa na nda a thlǝk ǝn mbǝlfeeya ndan. ");
INSERT INTO hwo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Fa kulaya hangga kyagha ɓa tǝ ɗeleewar kulayid ndan njang ngganda ɗǝ a yid fiya. Kirasang nanda ɗeleewar kula yini nǝn sǝl wuɗǝɓǝl rapathlaarha yi ɓeena haru kumnggidghǝn tuf (50,000). ");
INSERT INTO hwo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nanǝn kee, laɓar Chinǝm aten ɗǝrha mbeeɗǝ fiya hangga kaan a fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","A kwasamad ǝnɗi katǝragha hai ya, mid Mbulus ɗǝrha Urshalima ɗǝ, nǝn a kyagha tǝ Makidoniya tǝ Akaya. Ndǝghǝn, “A kwasamadɗi ɗini mbǝɗa ɗǝ, tsauɗǝ tǝta a ɗi Roma ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Thlǝn nafiya nǝn ɗǝ sǝri na a ɗang sǝ nda Timoti tǝ Irastus a ˈwa nda mbee, a Makidoniya ɗǝ, ndǝghǝnggi tsǝgha tsǝɓaku hu chehweed Asiya. ");
INSERT INTO hwo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mǝmǝlla sayidɗi thliigha kakyathlaanga aten takkwa kwaman Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tǝ ɓǝla na nda aarha Ndemetiriyus, na ɓǝl ƙǝn ɗahad Atemis nggu-ngguchit tǝ wurirha, walang ɗǝ tar wuɗǝɓǝla fa ɓǝlya sǝ hangga. ");
INSERT INTO hwo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wumanggǝn kanda thlǝmadghǝn ɓa tǝ fingya na a ǝna tur tarɗi, ndanggǝn kanda, “Waya, sǝnɗunsǝ nǝghǝm a wal wuɗǝɓǝla ahu tar ɗi kyanǝm ya.” ");
INSERT INTO hwo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kǝla nanun ndǝn tǝ ƙǝm sǝknun na niifɗiya Mbulus a lǝm fiya fa hangga a Afisa ɗi ya tǝ chehweed Asiya heu. Ndǝghǝn, faarya ǝnana niifa mbǝ faarya ni wa sam. ");
INSERT INTO hwo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","“Na wad sǝ mbǝ ka tar nǝm na thlǝmnggǝn a weela ɗǝ katenggǝn wa, amma ƙǝn ɗahad Atemis nǝn a sǝbrha ɗǝ, tǝ ƙǝm Atemis tafadghǝn na nda a ɗǝfang shilee teena ahu chehweed Asiya heu tǝ ƙǝshiirha, nǝn a ƙǝɗeng mamnggidghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sǝk na ndan kee, sǝbgha hur ndan ɗǝ katǝrang ngganda ahuhwaarha hai, “Atemis yi Afisaya nǝn tǝ mamnggirha!” ");
INSERT INTO hwo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tsǝɓaku hur wupǝri heu tsǝ teena nda. Kǝsangga fiya nda Nggayus tǝ Aristakus kawiya Mbulus a Makidoniya ɓa, kowunni ƙǝl ɗaarha mbǝd wumteena ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na mid Mbulus sǝ a kyagha hur fiya ɗǝ wumngga hai, amma karang fatakkwaya Yeeso fa. ");
INSERT INTO hwo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ko fingya mamngya na hu chehwedɗi, pashiya Mbulus, thlǝnang laɓara nda ɗǝ a kyaɗǝ a mbǝd wumten ɗa ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Fiya wumngga hai na nda ahu tsǝ teena. Fingya na nda ahuhwaarha aten ˈya tǝtal, fingya aten ˈya pak. Fiya hangga sǝngwanda ǝnɗi ɓangga kanda mbǝɗa ɓa wa. ");
INSERT INTO hwo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yahudayini puwang ngganda Aledzanda a mbeeɗǝ, na a thlǝk ˈya nǝn a fiya. Tǝranggǝn harghǝn sǝ na a nggasgha fiya hai ka kalanggǝn kanda sǝ aten ˈya wumangga kanda hai. ");
INSERT INTO hwo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma sǝnang nanda hai tǝ Yahudarha ni, kanda heu tǝrang ngganda urad ndan sǝ na nda a mbeela fa yi sayi sǝri tǝ ndaarha, “Atemis yi Afisaya nǝn tǝ mamnggirha!” ");
INSERT INTO hwo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tǝ chirethla wupǝri ɗi nggasanggǝn fiya hai wumngga hai ndǝghǝn, “Nafiya Afisa, ƙǝshiirha heu sǝnda sǝ wupǝri Afisa ndǝghǝnni tǝ Mamnda Atemis ha, tǝ shishing ndǝghǝn mukka hai a talara a ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tsaunǝn kee, mbǝ ngaala sǝ ahu palthɗi ya wa, nggasama hai a ǝnaɗun ˈya kula numaarha wa. ");
INSERT INTO hwo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɓa ɗun tǝ nafini mbǝɗa ɓa ya, mbǝ ngaar nanda a ƙǝn ɗahad nǝm wa tǝ ƙǝm sar wa nda ɗahadnǝm wa. ");
INSERT INTO hwo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A naɗǝ Ndemetirus tǝ fa taryighǝn na nda tǝ ɓillaarha aten kowunni, na ƙǝn ngwa kumarha sǝ, ɗǝnda ɗǝ ɗa nda huhwaarha. ");
INSERT INTO hwo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ana ˈya sǝ pak na minnun a thluwun ɗaama tǝghǝn a mbed shingya wupǝri ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ƙǝla nanǝnya, nǝghǝm ahu waarha a naɗǝm a mbeela fa kiya wa ƙǝsǝr ka ǝngya na a wiirha hai a weeriya. Nanǝn mbǝ ten palth kakyathlang ɗa sǝ ya wa, mbǝ ˈyasǝ nǝm thlǝkrha aten ǝnɗi nun a ǝnaarha nanǝnya wa.” ");
INSERT INTO hwo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","A kwasamadɗi ngwalang nǝn palthghǝn kal fiya nǝn hai. ");
INSERT INTO hwo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ngwalana kakyathlaanga, tǝrgha Mbulus aah fatakkwaya Yeeso nǝn, a kwasamadɗi fǝrang nǝn kanglanggirha kanda, ɗǝgha Makidoniya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɗǝgha mbǝya ɗǝ hangga nagha fǝrang kanglanggirha fatakkwaya Yeeso tǝ palthya hangga ta sǝlgha a Helas ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tsauka a Helas yi ndǝree mahan. Nanǝn a ngwarha fa nǝn a tǝra ahu kombuwol hai ka a ɗǝgha Suriya ɗǝ, ashe Yahudayini kǝnang nda hai na a ǝnang ˈya nda fa, tǝrgha wudgha kyagha tǝ Makidoniya. ");
INSERT INTO hwo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nda Sufata wan Farus a Mbiriya, tǝ Aristakus, tǝ Sakundus, nafiya Tasalonika, tǝ Nggayus niif Ndarɓe, tǝ Timoti, kanda nda Tikikus tǝ Tarofimus, nafiya Asiya, na mindan sǝ a ɗǝnda Suriya ɗǝ tǝghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nafiniya ˈwa nda mbeeɗǝ ƙǝla kan nda fa a Torawus. ");
INSERT INTO hwo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngwalana wutsǝfayid mburodi kula mekhna thlen a Filibi tǝ nggirggi, akwasamad ɓeena tuf ɗan wal fingyayini a Torawus tsawan a mbǝɗi yi ɓeena mǝd. ");
INSERT INTO hwo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A katǝra thlǝtta ɓeena wuman hai ka a ndǝghanggan mburodi hai. Tǝrgha Mbulus pǝrang laɓar Faara nǝn kanda. Na midghǝn sǝ mal kanda a ɗalth mbǝrha hai ɗǝgha mbeeɗǝ tǝ pǝr laɓar Faara ta manad fiɗikrha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A hu ƙǝnɗi tǝnna nda aten shadghǝn wumnan sa hai na patillaya sǝ hangga. ");
INSERT INTO hwo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na niifa sǝ tsauka hai a kwat ƙǝnna thlǝmnggǝn Yutikus, na ɓeena a sǝsang nda a sayidɗi na Mbulus a pǝr laɓar Faara. Tǝrgha tǝrangga ɓeena Yutikus ɗǝ, mukka hai a kwat ƙǝnɗi tǝnna nda aten shadghǝn yi mahan, tǝrang ngganda sǝ mǝmǝra. ");
INSERT INTO hwo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nanǝn kee, tǝrgha Mbulus hweeɗa hai, ɓǝrgha ten wanɗa hai fǝɓanggǝn, ndagha, “A ɓillaɗun wa, ɓalghǝn tǝ yibrha.” ");
INSERT INTO hwo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tǝrgha nggǝrghǝn wutta talara sǝ kyanggǝn mburodi ɗa hai kyan heu. Ɗǝgha mbeeɗǝ tǝ pǝrang laɓar Faara kanda har ɗalthgha mbǝrha hai a wiigha. ");
INSERT INTO hwo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tǝrgha nafini tǝrang ngganda wundǝladɗi wure ɗǝ tǝ yibrha na nda a ǝna wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wiigha Mbulus tǝ saara a Asus ɗǝ. Kan ƙǝm ɗan mbǝɗaɗǝ tǝ nggirggi ka a tǝranggan. ");
INSERT INTO hwo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɗǝnǝn wal kan a Asus, tǝranggan tǝ nggirggi a Mitilin ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ɗalthna mbǝrha hai thlen tǝ nggirggi sǝlan Kiyos ɗǝ. Nggǝrna mbǝrha ɗathla hai tǝɗan a Samos ɗǝ. A kwasamad ɓeena tal sǝlan a Militus ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Mbǝ mid Mbulus sǝ a ishgha hai a Afisa wa, ƙǝsǝr mbǝ midghǝn sǝ a mbǝdgha hai a Asiya wa, nǝghǝn a yawiirha na a sǝlgha a Urshalima ɗǝ wed, a naɗǝ a ǝnaarha hai a far Wutsǝfayid Pentikos. ");
INSERT INTO hwo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","A Miletus ni thlǝnna Mbulus farha ɗǝ a ang shingya Ƙǝn Faara nda ɓa na a Afisa ɓa nda walghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɓa nanda walghǝn, ndanggǝn kanda, “Kun tafad nun sǝnɗun tur tsawud na a sayidɗi nani tǝ kun ka a farɗi ɗǝfang ni sarna a chehweed Asiya hai. ");
INSERT INTO hwo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ənangɗi taara Chinǝm kula manang alteena tǝ thlee hura ƙǝm, ko nanǝn saaɗi ƙǝƙǝrra fa tǝ tar mbǝlfeerha ǝneena Yahudaya fa. ");
INSERT INTO hwo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sǝnɗun sǝ karwi pǝrang ˈya kun na thlar kun wa, tǝ ƙǝm tsahangɗi kun ha a pǝpal tǝ wure-wure. ");
INSERT INTO hwo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pǝrangɗi ndǝn Yahudaya tǝ fingya mbuwa Yahudaya na a malangganda ɗimiyid ndan kyakhra nda thlǝmad Faara ɓa fǝrƙǝkafek nda a Chinǝm Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nanǝnya, Sǝsǝna tǝ Peɗǝnda a shik nggi, ka a ɗi Urshalima ɗǝ, sǝngwi ǝnɗi ɗǝgha katǝrarha hai tǝ nggi a mbǝɗi wa. ");
INSERT INTO hwo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ˈYa sǝnni sǝ kee kala wupǝri ɗǝni saaɗǝ na Sǝsǝna tǝ Peɗǝnda naarha ƙǝs thlǝmanna tǝ ndaarha nda ɗǝrha hu porsǝna ɗǝ tǝ sǝsaarha na nda a ƙǝla nggi fa. ");
INSERT INTO hwo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amma nggi mbiyi a ƙǝlang yiɓǝnna ƙǝla ˈya ni wa, na minna sǝ kee a ngwalanggi tarɗi fǝree na Chinǝm Yeeso a ǝnee, tar pǝr Laɓara na Mbǝnggǝn yi nggayid Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nanǝnya, sǝnɗisǝ mbusǝ ahur nun pǝrang ni laɓar Kutǝryid Faara na nggǝr na nggi wa. ");
INSERT INTO hwo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tsaunǝn kee, niya pǝrang ndaarha kun a weeriya mbǝ hakked niifa sǝ atenna wa. ");
INSERT INTO hwo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pǝrangɗi ˈya kun heu na mid Faara a sǝnggunǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kǝlama altennun ha tǝ nafiya fǝrangna Sǝsǝna tǝ Peɗǝnda kun a laf kanda nun. Tsawama ƙǝla falafya nafiya Faara. Chiɓǝdghǝn ni hiinǝn tǝ far Wanggǝn. ");
INSERT INTO hwo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Sǝnɗi sǝ a kwasamadɗi malni kun, na mǝmereeya a kyarha hur nun hai mba nda a mal chiɓǝdɗi wa. ");
INSERT INTO hwo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","A hur nun ƙǝm na fingya sǝ na a thliirha sǝ thlǝk palth nggaɓaarha nda ka a kyang ngganda fingya sǝ ahu fǝrƙǝkafekkidɗi, tǝna nda mbu samandan. ");
INSERT INTO hwo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nanǝn kee kwarama! Ɗalama teena hai hurarha mahan ˈwawi malang ƙǝs thlǝman nun nda fiɗikrha tǝ yanfaara tǝ aam yirha wa.” ");
INSERT INTO hwo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nanǝnya wumangɗi kun tǝ Faara tǝ laɓar nggayidghǝn, na mbang tǝnang kunsǝ fǝrang langaarha nǝn kun heu tǝ fingya ɗǝfang nǝn haara teena. ");
INSERT INTO hwo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“ˈWawi suna wuɗǝɓǝl niifa nduwa karidghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sǝnɗunsǝ ǝnayi taara tǝ harna ƙǝrni fadna sǝ tǝ fingya nani tǝ kanda. ");
INSERT INTO hwo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","A hu ǝngya ǝnani heu, kyaɗang ɗi ndǝn kun tǝ ndaarha, tǝta ni a ǝna taara nun kiya tǝnun thlar fingya mbuwa tǝghǝn ha. Nam a ɗal teena hai tǝ palth Chinǝm Yeeso ndaanǝn, ‘Nagha parka sǝ kaan hu fǝra ma thlǝrha.’” ");
INSERT INTO hwo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","A kwasamadɗi ngwalang nǝn laɓara, ɓǝrgha hai tǝ kanda heu hwan Faara nda. ");
INSERT INTO hwo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kanda heu muk tǝrha nda fǝbghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ˈYa sǝɓangga hur ndanɗǝ kaan ƙǝsǝr ka laɓarghǝn ndanǝn mba nda a nggǝr nang yirha fa wa. Tǝrgha ɗǝfang ngganda ahu nggirggi ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","A kwasamadɗi mal nan kanda, kyan hu nggirggi hai ɗan Kos ɗǝ. Ɗathna mbǝrha hai sǝlan Rodes ɗǝ thlen a mbǝɗi ƙǝm ɗan Pataara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ɗan wal nggirggi na a ɗǝrha Finikiya ɗǝ, kyan sa hai wen. ");
INSERT INTO hwo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Akwasamad ɗi na nan Sayifurus mbǝran ɗǝ tsanggan a man kodnan ɗǝ, ɗan Suriya ɗǝ. Tǝran hai a Taya, mal nggirggi ɗa nan ka haarang ngganda rǝfrha hai ahurghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","A mbǝɗi wal fatakkwaya nan tsawan tǝ kanda yi ɓeena mǝd. Nagha Sǝsǝn Faara a shik kanda ndang ngganda Mbulus a ɗǝɗǝ Urshalima ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Amma lǝghǝdna ɓen tsawud nan tǝ kanda, wuɗan ɓan wal nggirggiɗi ɗan mbeeɗǝ tǝ winnan. Fa takkwayini heu kanda tǝ nishyindan tǝ wanggindan ɗǝfang ngganda kanɗǝ ma wupǝriɗi. A mii wuri aamɗi ɓǝran hai hwan Faara nan. ");
INSERT INTO hwo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","A kwasamad ɗi ndǝk nan hai tǝ ndan, kyan hu nggirggi hai kanda ƙǝm wuɗa nda wure ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ɗan mbeeɗǝ tǝ winnan a Taya sǝlan Tolemayis ɗǝ, a mbǝɗi ndangˈya nan fa fǝrƙǝkafekkya. Tsawan tǝ kanda yi ɓeena tal. ");
INSERT INTO hwo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ɗalthna mbǝrha hai, nduwan Kaisariya ɗǝ, tsawan a minda ki Filibus tǝ pǝr laɓar Faara. Nǝghǝn tal ahur nafini mǝd wur nanda na a ndǝk ǝnnarhami ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Na wutarayighǝn sǝ faɗa na nda thlǝk ˈya na a katǝrarha hai a mbee. ");
INSERT INTO hwo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","A kwasamadɗi tsau nan a mbǝɗi yi ɓeena hangga ɓagha annabi ɓa a Ndjudiya thlǝmnggǝn ni Anggabus. ");
INSERT INTO hwo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɓana Anggabus thlǝman nan ɓa, tǝranggǝn ǝn ƙǝnda mu Mbulus, ƙǝnanggǝn saryighǝn tǝ haryighǝn tǝghǝn. Tǝrgha ndǝghǝn, “Ndagha Sǝsǝn Faara, ‘Na mamngya Yahudaya a ƙǝnang nda tǝ ǝn ƙǝn muwa ƙǝla yanɗiya a Urshalima fǝranggǝnda nafiya mbuwa wa Yahudaya.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sǝknan ndǝn kee, kan tǝ fingya fatakkwaya na a mbǝɗi, hwan Mbulus nan a ɗǝɗǝ Urshalima ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Amma ndagha Mbulus, “Kama nun a tǝrha? Kun a thleng hurna! Nggi ngwaɗi fa mbǝ ka muweeghanda hu porsǝna ɗǝ a Urshalima kee wa, amma a mǝri ka Chinǝm Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mbang ngwanan kyakhrang hurghǝn hai, ndan kee, “Ƙǝl ˈya ǝnana Faara.” ");
INSERT INTO hwo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Akwasamad ǝnɗiya ngwanggan rǝf yinan ɗan Urshalima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Fingya fatakkwaya na a Kaisariya mbunda samannan. Ɗǝnda tǝ kan minda ki Manason ɗǝ, tǝ Sayifurus tal ahur fatakkwaya ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Sǝl nan Urshalima ɗǝ thlǝgha fatakkwaya kan fa ngga. ");
INSERT INTO hwo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ɗalthna mbǝrha hai, kan nda Mbulus ɗan thlǝmad Yakubu ɗǝ, shingya Ƙǝn Faara heu na nda a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ndangga Mbulus ˈya kanda pǝrang ˈya nǝn kanda heu ǝnana Faara ahur nafiya mbuwa wa Yahudaya ahu targhǝn. ");
INSERT INTO hwo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sǝk nanda ǝnɗi kee fal Faara nda. Tǝrgha ndang ngganda Mbulus, “Nannan, wan man, Yahudaya hangga fǝrgha ƙǝkafek, kanda heu tǝr mindan sǝ a takkwa ngyakhrha Musa. ");
INSERT INTO hwo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Amma pǝrang ndan kanda tǝ ndaarha, na tsahang Yahudaya ha na tǝ tsaurha ahur fingya mbuwa wa Yahudaya a malangganda tsahad ɗeleewar Musa. Nana a ndang nda kanda a thleng nda muwa wanggindan wa nduwa ƙǝm takkwa ǝntin nǝm nda wa. ");
INSERT INTO hwo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nanǝnya ma nǝm ǝnaarha? Ƙǝsǝr na nda a sǝk ndaarha ƙǝkafek ɓanna ɓa.” ");
INSERT INTO hwo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nanǝn kee ǝno ˈya nan a thlǝworha. Na nafiya sǝ faɗa a thlǝman nǝm a mbǝɗiya ɗǝfgha mee. ");
INSERT INTO hwo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ɗuwaɗǝ tǝ kanda ahu Ƙǝn Faara ɗǝ yi Yahudaya ɗa wumteena tǝ kanda ahu tsuthlang kanda ɗǝ tǝ ƙǝm tii wuɗǝɓǝl thlǝrǝttǝ ndan. A ǝnanna kee na fiya sǝnda sǝ palthɗi na nda a sǝkrha atenwa nggaɓaarha ni, sa ƙǝm ǝna taara na tǝ ˈya ndaana ngyakhrha Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Amma fatakkwaya mbuwa Yahudaya, chireethleng ɗan kanda ɗǝ tǝ ndaarha: A malang ngganda ǝna ˈya mii thleng nanda ɗaharha, tǝ saa faara, tǝ kii maɓi tefreng nanda uradghǝn tǝ kulafayirha.” ");
INSERT INTO hwo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ɗalthna mbǝrha hai harangga Mbulus nafini tsaɓanggǝn fadghǝn ɗǝ heu tǝ kanda. Tǝrgha ɗǝgha hu Ƙǝn Hwan Faara ɗǝ yi Yahudaya ka a pǝrang ndaarha nǝn kanda ɓad far lǝghǝtta ɓen tsabrha fandan ɓa, farɗa ni na nanda a ǝna sataka a kowunni ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Takhna ɓenɗi mǝd a lǝghǝtta, fingya Yahudaya ɓagha ɓa a chehweed Asiya na Mbulus nda ahu Ƙǝn hwan Faara yi Yahudaya. Shik fiya nda a ƙǝsang ngganda, ");
INSERT INTO hwo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","tǝrang ngganda urad ndan sǝ, “Nafiya Isǝreela, ɗaaman kan sǝ! Niifɗani ya na tsahang fiya ha heu ko a yanggi ni aten tsan nafinǝm tǝ ngyakhrǝ nǝm tǝ mbǝɗiya ƙǝm. Mbǝ kee ma wa ɓa ɗa ɓa tǝ Helenaya a ƙǝn ɗa ɓa ya nagha a sǝɓang nda mbǝɗa ɗǝ na tsǝtsaɓaɗǝ ya. ");
INSERT INTO hwo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Nanda Trofimus tǝ Afisarha ahu wupǝri tǝ Mbulus tamngga nda ndaarha ɓa Mbulus tǝghǝn ƙǝn hwan Yahudaya ɓa.” ");
INSERT INTO hwo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Thliigha wupǝriɗi kahad na nda a kyarha ɓa a mbǝya ɓa ɗǝɗamǝn. Ƙǝsang ngganda Mbulus kahang ngganda ƙǝsha ɓa ma ƙǝn hwan Faarɗi nggǝlang ngganda kwatkirma ƙǝkar. ");
INSERT INTO hwo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nana mindan a ɓǝlang ngganda, sǝlgha laɓara thlǝmad mamnda sodjaya Roma ɗǝ tǝ ndaarha wupǝri ahu tsǝteena. ");
INSERT INTO hwo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tsu kee har fingya sodjaya nǝn tǝ mamnggindan ɗaa nda mbǝɗa ɗǝ wumna fiya sa hai. Nana fiya mamnda sodjaɗi tǝ sodjayighǝn, malang ngganda ɗǝk Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ndagha Mamnda sodja yini a ƙǝsang ngganda ƙǝnang ngganda tǝ wuyiwurya sǝri. Tǝrgha tsakh mee nǝn tǝ wunni ndǝghǝn mani ǝnanǝn. ");
INSERT INTO hwo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fingya ahur fiya wumngga hai thlǝk ˈya nda kiya, fingya ƙǝm pak. Nanǝn mamnda sodja ɗi walwa ƙǝkafekkid palthɗi wa ƙǝsǝr ka mbeela, ndǝghǝn a ɗǝnda tǝ Mbulus a mbǝd tsawud sodjaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ɗǝna Mbulus a mbǝd tǝra sǝ, kakyathlaanga mulɗa hai kaan, tǝrgha tǝrangga sodja yini ura ka hang nda fiya. ");
INSERT INTO hwo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Fiya wumngga hai na a mbu samad ndan tǝrang ngganda urad ndan sǝ na nda a ndaarha, “Ɓǝla man, ɓǝla man!” ");
INSERT INTO hwo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Na sodja yini a ɗǝrha tǝ Mbulus a mbǝd ndan ɗǝ, tsahang mee nǝn mamnda sodja yini, “na nggǝm fa a kaloyi sǝ wa?” Nggǝrangga mamnda sodja ɗa sǝ, “Mbang na mii Helenarha wa? ");
INSERT INTO hwo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mbǝ sa ni tǝ Masar ɗi thlengga yanda tǝ ƙǝm ɓangga fa ɓǝl faaya haru kumnggidghǝn faɗa a kaheerha ɓa ahu ɓenggini mbǝrgha ɗǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nggǝrangga Mbulus sǝ, “Nggi tǝ Yahudarha ni, ɓayi ɓa a Tarsus na a chehweed Silisiya, wupǝri na manggǝn. Niya hwan sa, male kalanggi nafina sǝ ya.” ");
INSERT INTO hwo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wal nǝn kwamana a haar mamnda sodja ɗi, ishgha a mbǝd tǝra tǝrang haara nǝn fiya sǝ a nggasa nda hai. Nggasa nanda hai, ndanggǝn kanda tǝ mii Aramayarha: ");
INSERT INTO hwo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Kun na wanmanggina tǝ chinggina keema thlǝmaarha fa pǝrang ǝnɗani kun katǝragha hai, ka kyaɗang ndaarha ni kun ǝna wii ˈya na ɗimi wa.” ");
INSERT INTO hwo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Sǝk nandan kalang ɗǝ kanda sǝ tǝ mii Aramayarha, nggǝrghanda nggasa titib. ");
INSERT INTO hwo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Tǝrgha Mbulus ndanggǝn kanda, “Tǝ Yahudarha ni nggi, nggǝtgha nda nggi a Tarsus, a wupǝri Silisiya. Manggi sǝ a Urshalima, a kamu Nggamaliyel ni tsaha ni ǝngya heu aten ngyakhrha tǝ ǝntin chingginǝm. Sǝrǝkɗi fǝrang mamnggirha Faara, kǝla nanun a ǝnaarha a weeriya. ");
INSERT INTO hwo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Sǝsang ɗi nafiya na a takkwa kwaman Yeeso. Nggi a fǝr kanda a ɓǝlang ngganda kanda, nggi a kǝnang nda fiya hǝshya tǝ nishya, muwanggi kanda ahu porsǝna ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mamnda Firistayini tǝ kwagnaya hǝu na nda pǝr ˈya atenna. Ƙǝsǝr a haar ndan ni thlǝni ɗeleewar ɗi a ɓanggǝni wanmangginǝm ɓa Yahudaya na a Ndimaska. Ɗǝni mbǝɗaɗǝ ka ƙǝsanggi fatakkwaya, a ɓee tǝ kanda a Urshalima ɓa, ka a sǝsang ngganda kanda.” ");
INSERT INTO hwo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nani aten kwamana, takhɗi a sǝla Ndimaska ɗǝ yanfaara a sǝrǝkrha, tǝrgha djargha kukwaryirha a mbǝɗa hai nani sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Fǝli hweeɗa hai sǝk urarha ni a ndeerha, ‘Shawulu, Shawulu, kama nda na a sǝseerha?’” ");
INSERT INTO hwo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nggini na Yeeso tǝ Nadzarat na a sǝsang nda.” ");
INSERT INTO hwo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nafini na a thlǝmadna nanda kukwaryidɗi, amma sǝnangwanda uradɗa hai na kalee sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Tǝrgha tsakh mee ni ndee, ‘Chinǝm, ma ni ǝnaarha?’ Ndagha, ‘Thliusǝ, kyo ahur Ndimaska hai, a mbǝɗani nanda pǝro ˈya na a ǝnaarha.’” ");
INSERT INTO hwo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Kwamaɗi ka djarra kukwaryidɗa hai, nafini nani tǝ kanda ndǝn ƙǝsgha harna ahur Ndimaska ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Na niifasǝ tǝ tsaurha a mbǝɗi thlemnggǝn Hananiya, ɓagha thlǝmanna ɓa. Niifani na a tǝrang shilee Faara teena tǝ ƙǝkafekkirha tǝ ƙǝm a laf ngyahad nǝm, Yahudaya hǝu a falghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɓagha thlǝmanna ɓa ndeeghǝn, ‘Wanmana Shawulu, no mana hai!’ Tsu a mbǝɗi kee nee a naghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tǝrgha ndagha Hananiya, “Faara yi chichiyinǝm wurɗǝ sa ka a sǝn ˈyana na midghǝn tǝ ƙǝm na Nggayid Yanɗa na sǝk uradghǝna. ");
INSERT INTO hwo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Na a tsaurha tǝ pǝr laɓarghǝn ɗǝ a fiya heu aten ˈya naa nana tǝ sǝk nana. ");
INSERT INTO hwo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nanǝnya mana a ƙǝlaarha? Thliusǝ ǝno mbaptisǝma nda tsaɓo ɗimiyid wa nda ɗǝ tǝna naarha aah thlǝm Chinǝm.” ");
INSERT INTO hwo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Wud ni a Urshalima ɗǝ, nggi a hwan Faara ahu kǝn Yahudaya kyaɗeegha Faara ˈya ahu sǝsǝniirha. ");
INSERT INTO hwo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Na Yeeso ni a ndeerha, ‘Thliu sǝ ƙǝkar! Malu Urshalima wed, ƙǝsǝr nafini a mbǝɗiya mba nda fǝrƙǝkafek tǝ laɓarɗi na a thlǝkrha atenna ya wa.’” ");
INSERT INTO hwo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nggi kǝm ndee, “ ‘Chinǝm, nafini ya sǝndasǝ ni naarha ɗǝrha hu ƙǝn tsaharha ɗǝ tǝtal, tǝtal nggi a kǝnang tǝ ɗǝk fingya fǝrgha ƙǝkafek a sa. ");
INSERT INTO hwo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɓǝlang nanda tǝ pǝr laɓar wa Istifanus, nggi tǝ altenna ƙǝt a mbǝɗi, kǝnang pama ni kanda mu, nggi ƙǝm ƙǝlagha karid nafina ha ɓǝlangga.’ ");
INSERT INTO hwo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Tǝrgha Chinǝm ndeeghǝn, ‘Ɗuwaɗǝ, niya thlǝn sa a mbǝrha ɗǝ iunggǝn a thlǝmad nafiya ɗǝ mbuwa wa Yahudaya.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nafini wumngga hai kang thlǝmaarha nda Mbulus fa ta mii ngwala palthghǝn ɓa. Tǝrgha tǝrang ngganda urad ndan sǝ, “Weema tǝ niif ɗiya ɗun ɓǝlang nda! Kamngwa a mal kamshi ɗa nǝm tǝ yibrha hu ƙǝshiirha ya wa!” ");
INSERT INTO hwo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na nda a huhwarha kanda a muwang parkoyindan ɗǝ, nanda a thleng tǝniirha sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nanǝn kee, mamnda Sodja Romaɗi ndagha a ɗǝnda tǝ Mbulus a mbǝd tsawud sodjaya ɗǝ a tsahang mee nda ha tsaɗaghǝn nda tǝ wutǝteerha, ka a sǝn ˈya nda katǝragha hai na fiya a huhwarha kee. ");
INSERT INTO hwo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Amma a kwasamadɗi kǝnang nanda ka tsaɗaghǝn nda, tǝrgha ndangga Mbulus mamnda sodja na ƙǝt a mbǝɗi, “Ashe nǝn mǝmǝl ndana ngyakrha a tsaɗa niifa nda tǝ Romarha, sa kula ngwang kumarha sǝ wa?” ");
INSERT INTO hwo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sǝkna sodja Roma yi ndǝn kee, tǝrgha ɗǝgha thlǝmad mamndǝɗa ɗǝ ndanggǝn, “Mana ǝnaarha miya? Niifɗiya fa tǝ Romarha ni,” ");
INSERT INTO hwo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tǝrgha mamnɗǝɗi ndanggǝn Mbulus, “pǝre ƙǝkafek, tǝ Romarha ni sa wa?” Nggǝmangga Mbulus, “Ghǝng.” ");
INSERT INTO hwo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tǝrgha ndagha mamndǝɗi, “Nggi fa tiiɗi wuɗǝɓǝla hangga ka a tsawi tǝ Romarha.” Ndagha Mbulus, “Nggi nggǝtta tǝ Romarha ni.” ");
INSERT INTO hwo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nafini na mindan sǝ a tsahang mee nda ha nggǝranda samarha ɗǝ tsu. Mamnɗǝɗi tǝ altenggǝn sǝnnǝnsǝ Mbulus tǝ Romarha ni tǝrǝmngga, ƙǝsǝr ˈwaɗǝ teena ndaɗǝ a kǝnang ngganda tǝ ƙǝm tsaɗaghǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ɗalthana mbǝrha hai mamɗǝɗi na midghǝn a sǝn ƙǝkafekkid huhwad Yahudaya aten Mbulus, tǝrgha kwasanggǝn hai, aah mamngya firistaya nǝn tǝ kognaya heu a wuma nda ɓa. Tǝrgha ɓaghaɓa tǝ Mbulus ishanggǝn a mbendan. ");
INSERT INTO hwo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Tǝrgha Mbulus irang yirha nǝn kognayina fa ndagha, “Kun wanmanggina, ngwalangɗi tarna a Faara ahu kwamana na mǝmǝl heu ta weeri ɗa ɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sǝkna Hananiya palthɗi keeghǝn kee ndanggǝn nafini na tsau tǝ Mbulus fa a mbighǝnda. ");
INSERT INTO hwo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tǝrgha Mbulus ndanggǝn, “Na Faara a mbi sa, sa fad kǝnna ni kǝmonda tǝ penti pǝpet, tsauna a mbǝɗi nana a ngwe kumarha sǝ aten ngyakhrha, amma sa tǝ altenwa hwasang na ngyahadɗi ndana a ndǝk nggi nda!” ");
INSERT INTO hwo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Fingya na ƙǝƙǝt tsau tǝ Mbulus fa ndang ngganda, “Firis na manggǝn yi Faara ndǝna ˈyaara?” ");
INSERT INTO hwo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ndangga Mbulus kanda, “Wanmanggina sǝngwi sǝ ndǝghǝnni firis na manggǝn wa, ƙǝsǝr ndagha ɗeleewar Faara, ‘A thlǝkna ˈya na ɗimi aten mamnda nafiwa wa.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kǝlaana Mbulus hai, fingya kognaya Sadukiyaya ni, fingya kǝm Farisaya, tǝranggǝn uradghǝn sǝ ndagha, “Wanmanggina, tǝ Farisarha ni nggi, chichiyina wai kee. Niyi ahu kǝkǝrra ƙǝsǝr ka nana mbǝrsad na aten thliirha sǝ ahu mǝrra.” ");
INSERT INTO hwo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ndana Mbulus kee, thliigha kakyathlaanga sǝ a pathlang Farisaya tǝ Sadukiyaya, ndǝkka kognayina hai mbǝdghǝn sǝri. ");
INSERT INTO hwo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ƙǝsǝr ndagha Sadukiyaya mbǝ thliirha sǝ hu mǝrra wa, mbǝ fathlǝngya sǝ wa, nduwa sǝsǝngya, amma Farisaya fǝr nda ƙǝkafek tǝ ǝnggini hǝu. ");
INSERT INTO hwo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tǝrgha thliigha kakyathlaanga sǝ kaan, fingya fa malǝmgya ngyakhrha Musa na Farisaya thlii nda sǝ ƙǝt ngaala nda tǝ kanglanggirha. Ndanda, “Nawan ˈya na ɗimi a fad niifɗiya wa. Ana sǝsǝna ni nduwa, tǝthlǝnda Faara ndikka tǝghǝn wu?” ");
INSERT INTO hwo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kakyathlang ɗi mul ɗa hai kaan har mamnda sodja ɗi tǝrǝmngga na ɗa nda thlusang nda Mbulus hai kushir-kushir. Ndanggǝn sodja yini a ɗa nda tǝrang Mbulus tǝ kanglanggirha ma thlǝmad ndan, ɓa nda tǝghǝn mbǝd tsawud sodjaya ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tsǝna fiɗikrha hai ishgha Chinǝm ƙǝt a thlǝmad Mbulus ndanggǝn, “Ishiu tǝ kanglanggirha, kǝla pǝrna laɓarna a Urshalima, tsawo ɗa fa tǝta a pǝrghǝnna a Roma.” ");
INSERT INTO hwo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ɗalthna mbǝrha hai, kǝnangga Yahudayina hai tǝ ɗǝf mee mba nda a hǝbrha nduwa saarha wa ƙǝl ma ɓǝlang nda Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nafini ǝnagha tar mbǝlfedɗi kal nda kumnggit faɗa. ");
INSERT INTO hwo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɗǝnda thlǝmad mamngya firistaya ɗǝ tǝ shingya ndanda, “Ƙǝnang ɗan hai tǝ ɗǝf mee tǝ ndaarha mban a hǝbrha tǝ sarha wa kǝl ma ɓǝlang ɗan Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nanǝnya, kun tǝ kognaya ndaman mamnda sodjaya a ɓagha tǝghǝn a mbed nun ɓa, kǝla na minnun sǝ a nggǝrwun tsahang mee ha ngga, kanggi kǝm nan nggungwa fa a ɓǝlanggan kapa nǝn ɓarha ɓa.” ");
INSERT INTO hwo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Amma sǝkna yangan Mbulus pathla ɗi kǝnang nanda hai, ɗǝgha mbǝd tsawud sodja yina ɗǝ pǝrang nggǝnǝn Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tǝrgha Mbulus aah tal nǝn ahur sodja Romayini ndanggǝn, “Ɗuwa tǝ wundǝladɗi a thlǝmad mamnda ɗǝ na pathla sǝ na midghǝn pǝrang nda.” ");
INSERT INTO hwo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nanǝn kee, sodjaɗi tǝranggǝn wundǝladɗi ɗǝgha tǝghǝn thlǝmad mamnɗǝɗa ɗǝ. “Mbulus wan tǝ porsǝnɗiya, ndǝn aagha nggi, hwan nggi nǝn a ɓee tǝ wundǝladɗi a thlǝmad wa ɓa ya, ƙǝsǝr na ˈya sǝ miighǝn nǝn a pǝrorha.” ");
INSERT INTO hwo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tǝrgha mamnɗǝɗi kǝsanggǝn har wundǝladɗi ɗǝgha tǝghǝn man patu ɗǝ, tsahang mee nǝn ha, “Mani a mii wa?” ");
INSERT INTO hwo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ndagha, “Mamngya Yahudaya kǝnang nda hai nanda hwan sa ɗǝna tǝ Mbulus a mbed kognaya ɗǝ a ɓinda, kǝla na mindan sǝ a nggǝrgha nda tsahang mee ha ngga. ");
INSERT INTO hwo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma a nggǝmang kanda fa wa, ƙǝsǝr fiya kal nda kumnggit faɗa tsǝb nda hai ka a ɓǝlang ngganda. Nanǝnya ɗǝf nda mee mba nda a hǝbrha tǝ sarha wa kǝl ma ɓǝlang nda. Na nda a kǝla sa fa kee a nggǝmana fa,” ");
INSERT INTO hwo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tǝrgha mamndǝɗi ƙǝs thlǝmadghǝnǝn ndanggǝn, “Ma pǝrang nan niifa tǝ ndaarha thlǝyed nan wa.” ");
INSERT INTO hwo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tǝrgha aagha mamnda sodja yini sǝri ahur sodjayighǝn ndanggǝn kanda, “Ngwama fa ƙǝsǝr nun a ɗǝrha Kaisariya ɗǝ a fiɗikrha, tǝ sodjaya haru kumnggit sǝri, tǝ sodjaya a ƙǝsǝr pǝrsaya kumnggit mǝd, tǝ sodjaya na yanda tǝ peela haru kumnggit sǝri. ");
INSERT INTO hwo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kaɗaman pǝrsaya Mbulus sǝ nǝn a tǝrha ɗun tǝghǝn thlǝmad Ngwamna Felis ɗǝ kula ˈya tsǝwarghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tǝrgha chireelth ɗeleewar ɗa nǝn ya a ngwamna: ");
INSERT INTO hwo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","A har Kalaudiyus Lisiyas, a Alvari, Ngwamna Felis. Nda ˈya fa hangga. ");
INSERT INTO hwo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Kamshiɗiya, kǝsang Yahudaya, takh nda a ɓǝlang, ɗiya ɗǝ tǝ sodjaya ƙǝkar thlanggi sǝ, ƙǝsǝr sǝkɗi ndaarha tǝ Romarha ni. ");
INSERT INTO hwo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na minna sǝ a sǝn ˈya ni ǝnanǝn ndǝn ɗǝni tǝghǝn a mbed kogna yindan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Walanggi ǝnɗi ndana nda ǝnaɗǝ nǝghǝn aten ngyahad ndan ni, amma ǝnɗi nda nanda ǝnaɗǝ tsǝkkwa a kǝnang ngganda nduwa ɓǝlang ngganda wa. ");
INSERT INTO hwo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ndee nanda kǝnang nda mee na nda a ɓǝlang nda, ndǝn thlǝnang ni a thlǝmad wa ɓa ƙǝkar. Tǝ kǝm ndang nggi nafini huhwaagha ndǝn a pǝro ǝnɗa nda ǝnanǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nanǝn kee, sodja yini tǝrangganda Mbulus a Antifatiris ɗǝ a fiɗikrha kǝla ndang nanda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ɗalthna mbǝrha hai mal sodjaya na a tǝr pǝrsaya ɗǝnda mbee ɗǝ tǝghǝn, kanda nggi kǝm wuɗa nda mbǝd tsawud sodjaya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Sǝlna sodja yini na tǝr pǝrsaya a Kaisariya ɗǝ, fǝrang ɗeleewar ɗa nda ngwamna, mal Mbulus nda a harghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Karatang na ngwamna ɗeleewarɗi, tsahang mee nǝn Mbulus tǝnǝn tǝ tsaurha a manggi. Sǝknǝn ndaarha nǝn a Kilikiya, ");
INSERT INTO hwo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ndagha, “Niya ko thlǝmaarha fa a ɓad nafina ɓa huhwagha sa.” Tǝrgha ngwamna ndagha a ƙǝsghǝn nda ha ahu porsǝna na a wuri ki Hirdus tǝn nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Akwasamad ɓeena tuf tǝrgha mamnda Firis Hananiya ɓagha ɓa tǝ fingya mamngya Yahudaya, tǝ kǝm tǝ tǝngwa kumarha nanda aarha Tartulus, a huhwa Mbulus nda a mbed ngwamna. ");
INSERT INTO hwo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Aah nanda Mbulus a ƙǝnɗǝ, katǝrang ngga Tartulus huhwa Mbulus hai a mbed ngwamna ndagha, “Alfari, tsauɗan ɗǝɗemnggirha kaan a kamuwa, ƙǝsǝr sa na ƙǝlarha mbeeɗǝ, mbeɗeng na ǝngya hai ahu chehwedɗiya.” ");
INSERT INTO hwo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","“Ƙǝsǝr ka ǝnggini na heu ya, Alfari, nan tǝ usaarha kaan a thlǝmadwa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amma mbǝ midna sǝ a ɗahanggi midwa ɗǝ wa, hwanni sa a kee thlǝmaarha na fa tǝ ˈya niya pǝrorha aten niifɗiya. ");
INSERT INTO hwo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Walang ɗan kamshiɗiya na pǝpeethla sǝ miighǝn, nǝn ɓarha tǝ kakyathlaanga a pathlang Yahudaya ɓa ko a yanggini ahu ƙǝshidɗiya. Ndǝghǝnni mamnda aten Nadzaraya ndǝna nafiya na mbu samad Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Har ma na midghǝn sǝ a kyalgha tǝ Ƙǝn Faara na a Urshalima, ndǝghǝnni kǝsang nan. ");
INSERT INTO hwo_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","A ranna mu palthɗa ha ya na walang ƙǝkafekkidghǝn tafadwa.” ");
INSERT INTO hwo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahudaya kǝm kǝnang nda pama kanda mu, nggǝma nda fa tǝ ndaarha nǝghǝn kee. ");
INSERT INTO hwo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Fǝrang na ngwamna kwamana Mbulus a kalgha sǝ, ndagha, “Alvari, sǝnɗi sǝ sani tǝ ngwa kumarha yi chehwedɗiya yi huraya hangga; tǝ wutsǝfayirha niya kyang altenna sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","A rad na mughǝn ha ngga na sǝnda sǝ kalwa ɓeena kumkap sǝri ɗǝni Urshalima ka hwan Faara ɗǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nafiya huhwagha nggi nawa nda nggi a ngaala tǝ niifa ahu Ƙǝn Faara na a Urshalima wa nduwa ƙǝm thlenggi kakyathlanga ahu kǝn tsahad Yahudaya wa, nduwa kǝm ahu wupǝri wa. ");
INSERT INTO hwo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mba nda mbang kyaɗo ˈya huhwana nda nggi atenggǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ˈYa tal nggǝmni fa atenggǝn, niya takkwa Faara yi chichiyinǝm tǝ kwamanɗi nda nanda mbǝ ƙǝkafek ni wa, tǝ kǝm niya fǝrƙǝkafek ahu ˈya chireethlǝng nanda ha a ɗeleewar ngyakhrha Musa tǝ ɗeleewar Annabiya. ");
INSERT INTO hwo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Fǝrɗi ƙǝkafek a Faara, ƙǝla ǝnana nafini ya, tǝ ndaarha na thliirha sǝ ahu mǝrra, nda nafiya ǝnagha nggayirha tǝ fa mbǝlfeeya. ");
INSERT INTO hwo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nanǝn kee, djitiirha na a tsawi tǝ nggayirha a mbed Faara tǝ fiya. ");
INSERT INTO hwo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“A kwasamad huraya hangga, ɓee Urshalima ɓa tǝ ǝn fǝrra nafina a fa yamiiya tǝ ƙǝm ǝna sataka ni a Faara. ");
INSERT INTO hwo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nafini huhwaagha nggi nanda nggi ahu Ƙǝn hwan Faara na a Urshalima nani a ngwalang tsaɓang altenna ɗǝ. Mbǝ fiya sǝ wumngga hai a thlǝmanna wa tǝ ƙǝm mbǝ kakyathlaanga sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amma na fingya Yahudaya sǝ ɓagha ɓa a chehweed Asiya a mbǝɗi, ana ˈyasǝ a mii ndan na nda a thlǝkrha atenna, kamɗǝ nanǝnya a na nda a mbǝɗiya. ");
INSERT INTO hwo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Tsahang mee nafini na a na a mbǝɗiya ɗimiyid ma walna kognaya Yahudaya atenna, ");
INSERT INTO hwo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ana palth ɗani thlǝkni na tǝtal keeya, tǝrang ni uradna sǝ a mbed ndan tǝ ndaarha, ‘A ten palth thliirha sǝ hu mǝrra na nanda a ngwee kumarha sǝ a mbed nun a weeriya.’ ” ");
INSERT INTO hwo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felis kǝm sǝnɗǝ ǝngya hangga aten kwaman Yeeso, ishanggǝn ngwa kumadɗi ndagha, “Ƙǝl ma ɓad mamnda Lisiyaya ɓa ˈwan ndǝn ni a ngwalang ngwa kumad nun.” ");
INSERT INTO hwo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","“Ndangga Felis mamnda sodja Romaya a kǝla Mbulus nǝn ha, amma malanggǝn kal farha nǝn hai tǝ ƙǝm a ˈyaɗang ɗǝ kwamana pashiyighǝn a fǝrang ˈya nda na midghǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Akwasamad ɓengya ngguchit, ɓagha Felis ɓa tǝ nukkun Durusila tǝ Yahudarha. Thlǝn farha nǝn a ɓa nda ɓa tǝ Mbulus, kang thlǝmarha nda fa thlǝk nǝn pathla aten fǝrƙǝkafek a Ƙǝrǝsti Yeeso. ");
INSERT INTO hwo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nana Mbulus a tsǝ laɓara tǝ kanda aten nggayirha, tǝ ƙǝs alteena, tǝ ƙǝm ngwa kumarha na ɓayi. Ƙǝsgha hǝreenga Felis ndagha, “Tsǝkɗǝ kee nanǝnya wiu. A walɗi kwamana niya nggǝr aagha sa ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Na midghǝn sǝ a fǝrangga Mbulus wuɗǝɓǝla, nanǝn kee nagha a thlǝn farha a thlǝmadghǝn ɗǝ atenggǝn, atenggǝn nagha a tsǝ laɓara tǝghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","A kwasamad hurarha sǝri, Pokiyus Festus tsaukwa ngwamna a meghed Felis. Felis kǝm na midghǝn sǝ a wal nggayirha nǝn a mbed Yahudaya malanggǝn Mbulus ahu porsǝna. ");
INSERT INTO hwo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Akwasamad mbeena mahan sǝlna Festus a Kaisariya ɓa ka a ƙǝs targhǝnnǝn yi ngwamna, thliigha a Kaisariya ɗǝgha Urshalima ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","A mbǝɗani huhwaana mamngya firistaya tǝ fingya mamngya Yahudaya Mbulus a mbedghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hwan Festus nda ƙǝkar a wuɗang ngganda Mbulus Urshalima ɗǝ ƙǝsǝr ngwanda fa a tsǝbghǝn nda fa a kwamana ka ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma Festus nggǝranggǝn kanda sǝ ndagha, “Ƙǝs nda Mbulus ha a Kaisariya, nggi tafanna tsǝɓaku niya ɗǝrha mbǝɗa ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Fingya mamngginun mbu samadna nda ɗa nda thlǝk ˈya atenggǝn, a ǝnaɗǝ ˈya na ɗimi huhwa ghǝnun.” ");
INSERT INTO hwo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","A kwasamadɗi tsaunǝn mbeena uvaɗa nduwa kum tǝ kanda, wudgha a Kaisariya ɗǝ. Ɗalthana mbǝrha hai kyagha ƙǝn ngwa kumadghǝn ɗǝ ndagha a ɓang Mbulus ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Sǝlna Mbulus ɓa, Yahudayini ɓagha ɓa a Urshalima thlii nda sǝ muwang ngganda maɗufu, na nda a ɗahang palthya fa, mbuwa ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Amma Mbulus ngaal ǝnggina nǝn thlǝk nanda atenggǝn ndagha, “Ənayi ˈya na ɗimi aten ngyakhrha Yahudaya, nduwa a Ƙǝn hwan Faara na a Urshalima, nduwa a Kaisar wa.” ");
INSERT INTO hwo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Tǝrgha Festus, na midghǝn sǝ a ǝna ˈyanǝn na a mbǝnanggǝn Yahudayini, ndanggǝn Mbulus, “Na midwa sǝ a ɗǝna Urshalima ɗǝ ɗi nggo kumarha sǝ aten ǝngginiya wa?” ");
INSERT INTO hwo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nggǝmangga Mbulus, “Nanǝnya niyi a ƙǝn ngwa kumad Kaisar, mbǝɗa niya kamngga a ngwee kumarha nda sǝ. Mbǝ ˈyasǝ na ɗimi ǝnang ni Yahudaya fa wa, sa tǝ altenwa ma sǝnnasǝ. ");
INSERT INTO hwo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ana ˈyasǝ na ɗimi ǝnani kamngga a ɓǝleewun, karwi fa wa. Amma ana palthyini ɗeheena Yahudayina fa ya mbǝ ƙǝkafek sǝ wa, mbǝ niifa sǝ tsǝkka a fǝrang nggi nǝn kanda wa. Niyi a hwan Kaisar!” ");
INSERT INTO hwo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","A kwasamadɗi ƙǝnang na Festus pathla hai tǝ kogna yini, ndanggǝn Mbulus, “Hwanna a nggǝrgha huhwad wa a mbed Kaisar ɗǝ, na ɗǝrha mbed Kaisar ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A kwasamad ɓǝngya ngguchit, Kutǝra Anggiripa tǝ wan man Mbanis ɓanda Kaisar ɓa ka ɓa nda ndang Festus aalee. ");
INSERT INTO hwo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nanǝn na nda a mǝndaha a mbǝɗi, tsǝgha Festus laɓara aten ngwa kumad Mbulus tǝ kutǝra. Ndagha, “Na niifa sǝ a mbǝɗiya malena Felis ahu porsǝna. ");
INSERT INTO hwo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nani a Urshalima, mamngya firistaya tǝ fingya shingya Yahudaya huhwanda niifɗiya na a ngwang kumad mǝrra ni sǝ. ");
INSERT INTO hwo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ndanggi kanda, mbǝ ǝntin Romaya ni ƙǝnang nggǝm niifa kapa nǝm ngwang kumarha wa, kǝl ma fǝrang ɗǝm kwamana kalgha sǝ aten ǝnɗi huhwa na ndan kamanggǝn ka a thlanggǝn fadghǝn sǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Ɓa nanda tǝ nggi mbǝɗa ɓa ya, mbǝd wii hai tǝ palthɗi wa, amma ɗalthna mbǝrha hai thlǝn farha ni ɓee niifɗa nda ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Thliina nafina sǝ huhwaagha ndǝn, mbǝ pathla sǝ na ɗimi thlǝk nanda atenggǝn niya kya numaarha wa. ");
INSERT INTO hwo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ameyedghǝn, na palthya sǝ yi ngaala thlǝk nanda aten takkwad ndan tǝ ƙǝm niifa mǝrgha na nda aarha Yeeso na Mbulus a ndaarha nǝghǝn tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Wuleegha ˈya na a ǝnee na a ramu palthɗa ni ha ya, tsakh mee ni tǝnǝn nggǝm fa ɗǝgha Urshalima ɗǝ ɗa nda ngwang kumarha sǝ a mbǝɗi aten palth yini ya. ");
INSERT INTO hwo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma ndagha Mbulus a malghǝn nda ahu porsǝna, ƙǝl sayidɗi ngwalang na Kaisar ngwang kumarha. Nanǝn kee fǝrghǝni a ƙǝsghǝn nda ha ta sayidɗi niya thlǝnanggǝn Kaisar ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tǝrgha Anggiripa ndanggǝn Festus, “Na minnasǝ a sǝk fad niifɗa ni ya tafadna.” Nggǝrangga Festus sǝ, “A ɓinda na sǝk fadghǝn.” ");
INSERT INTO hwo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ɗalthna mbǝrha hai sǝla nda Anggiripa ɓa tǝ Mbanis tǝ karid kutǝryid ndan fa nagha fiya a fǝrang mamnggirha kanda, mamngya sodjaya tǝ mamngya wupǝri ɗi a samad ndan. Thlǝngga Festus farha a kya nda ɓa tǝ Mbulus. ");
INSERT INTO hwo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ndagha Festus, “Kutǝra Anggiripa, tǝ fingya na a mbǝɗiya, naɗun niifɗiya! Yahudaya heu huhwan ndan a mbenna a Urshalima tǝ mbǝɗiya ƙǝm na mindansǝ a ɓǝlang ngganda. ");
INSERT INTO hwo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Amma ƙǝlang ni nawi ˈya ǝnanǝn tsǝkka a ɓǝlang ngganda wa. Nanǝn kee, ndǝghǝn a ɗa Kaisar ngwang kumarha sǝ, ndǝn ndani niya thlǝnang a Roma ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amma mani a chireethleng nda Kaisar ɗǝ? Ƙǝsǝr mbǝ pathla sǝ tefen ƙǝsang ni tǝghǝn wa. Nanǝn kee, ndǝn ɓani tǝghǝn mbennun ɓa heu, mbǝ ƙǝla sa mawa kutǝra Anggiripa, a raɗǝm mughǝn ha ngga, niya wal ˈya niya chireethleng nda hai. ");
INSERT INTO hwo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ƙǝsǝr ahu numadna mbǝ mǝmǝl thlǝnang nda niifa na ahu porsǝna a Kaisar ɗǝ kula ˈya ɗimi atenggǝn wa.” ");
INSERT INTO hwo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tǝrgha ndangga Anggiripa Mbulus, “Fǝronda kwamana na a kalana sǝ.” Tǝrangga Mbulus haarghǝn sǝ katǝranggǝn ndikrha hai ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kutǝra Anggiripa, pet fanna a weeriya mbang ni isha a mbedwa ka a kyanggi altenna sǝ aten palthya thlǝkna Yahudaya atenna. ");
INSERT INTO hwo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nanǝn sǝnang ǝntin Yahudaya hai tǝ fingya ǝngya na nanda a ngaalang nda teena. Nanǝnya niya hwan sa ƙǝrsu kee thlǝmaarha na fa. ");
INSERT INTO hwo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yahudaya heu sǝnda tur tsawud na ka nggi ngguchit, ka a katǝradghǝn a kyanan, tǝ ƙǝm a Urshalima. ");
INSERT INTO hwo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ka ƙǝtǝm sǝnda nggi na nda mbang thlǝk ˈya atenna, ana mindan sǝ, ahu takkwa ƙǝkafekkid nan, tǝ Farisarha ni nggi. ");
INSERT INTO hwo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nanǝnya niyi a mbedwa ka a ngwee kumarha na ƙǝsǝr fǝrɗi ƙǝkafek tǝ ˈya ndangna Faara a chichiyinǝm ka ƙǝtǝm. ");
INSERT INTO hwo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nda fǝɗikrha tǝ yanfaara tur yinǝm kumkap sǝri ɗǝfang nda shilee Faara teena kaan, kanda a ƙǝla parka fa ndanǝn. Kutǝra Anggiripa, ƙǝsǝr ka numadɗiya, fingya mamngginǝm ndǝn huhwaanda nggi. ");
INSERT INTO hwo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mani nǝn naarha sǝ ahur nun na ndaarha mbǝ ǝnaarha hai thlengga Faara mǝrya sǝ wa? ");
INSERT INTO hwo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ˈWaɗi numad ndaarha a ǝna ˈyani heu ni mbang ka a ˈyaɗa thlǝm Yeeso ni tǝ Nadzarat. ");
INSERT INTO hwo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ənɗani ǝnani a Urshalima. Tǝ sǝsǝmnda mamnda firistaya muwangɗi fatakkwaya Yeeso ahu porsǝna ɗǝ. Har ma nggǝmɗi fa a ɓǝlang nda kanda. ");
INSERT INTO hwo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Saara hangga ni naarha kyarha hu ƙǝn tsahaya Yahudaya ɗǝ ka a sǝsang ngganda kanda, tǝ ƙǝm ni naarha thlǝghang palthya kanda fa na ɗimi. A hu tǝɓǝnggid na a tendan, ni ɗǝrha hu chehweed ƙǝshi ɗǝ nee a sǝsang kanda.” ");
INSERT INTO hwo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Farɗasǝ nggi ahu kwaman ɗǝrha Nɗimaska ɗǝ, nggungwa fa tǝ sǝsǝmnda mamnda firistaya. ");
INSERT INTO hwo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Yanfara a sǝrǝkrha, Alvari, nani hu kwamana, na kukwaryirha ni a talara hai, kukwaryidghǝn kalɗǝ yanfaara, djargha tenna hai tǝ kawiyina. ");
INSERT INTO hwo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kan heu fǝlan hweeɗa hai, sǝk urarha ni tǝ mii Aramiya, ‘Shawulu, Shawulu, kama nda na a sǝseerha? Nǝghǝn pǝɗaghǝn a fadwa a yana aten ˈya na minna.’ ");
INSERT INTO hwo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Tǝrgha tsakh mee ni, ‘Wunni sa Chinǝm?’ Ndagha Chinǝm, ‘Nggini Yeeso na a sǝsang nda. ");
INSERT INTO hwo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nanǝnya thliusǝ! Keɗo ni fanna ka a furo taara ni (mafayirha ni) tǝ ƙǝm pǝr ǝnɗa na nana tǝ ˈya niya kyaɗorha. ");
INSERT INTO hwo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Niya hǝrworha a haar nafiwa tǝ fingya mbuwa Yahudaya. Niya thlǝn sa a thlǝmad ndan ɗǝ, ");
INSERT INTO hwo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ɗa inang yiyi ndan ɗǝ tǝ ƙǝm kyakhrangga kanda ahu kukwaryirha ɓa. Thlangga kanda sǝ a haar Sheetan ɓana tǝ kanda a thlǝmad Faara ɓa tǝna nda wal chakh ɗimiyirha a thlǝɗang ngganda kanda ahur nafiya Faara hai fǝrgha ƙǝkafek a nggi.’” ");
INSERT INTO hwo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nanǝn kee, Kutǝra Anggiripa, nggǝm ɗi fa tǝ sǝsǝnidɗi ɓagha hai a talara. ");
INSERT INTO hwo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ˈWayi katǝrang pǝr laɓar Faara hai a Nɗimaska, tǝ a fingya na a Urshalima tǝ chehweed Yahudiya heu tǝ ƙǝm nafiya mbuwa Yahudaya, tǝ ndaarha a malang ngganda ɗimiyid ndan kyakhra nda thlǝmad Faara ɓa a ǝna ǝngya nda kyadgha ndaarha malang nda ɗimiyid ndan. ");
INSERT INTO hwo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ndǝghǝnni ƙǝseena Yahudaya a pǝpal Ƙǝn Faara na a Urshalima na mindan sǝ a ɓǝleegha nda. ");
INSERT INTO hwo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amma ɗed Faara sǝ ta weeri ɓa ya, ndǝn nani ƙǝt a mbǝɗiya ka a pǝranggǝni wundakhnaya tǝ shingya. Pǝrangɗi ndǝn kanda ˈya ndaana annabiya tǝ Musa nǝn a katǝrarha hai. ");
INSERT INTO hwo_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ƙǝkafekni Ƙǝrǝsti nǝn a sǝsaarha, nǝn a ˈwa thliirha sǝ ahu mǝra, nǝn a ɓang kukwaryirha nafiyighǝn ɓa tǝ fingya mbuwa Yahudaya.” ");
INSERT INTO hwo_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Mbulus kula ngwalang palthghǝn kee tǝrgha Festus tǝranggǝn uradghǝn sǝ ndǝghǝn, “Sa Mbulus kyahar huten wa! Karatadwa mulda hai kyakhrang ɗǝ huten wa hai.” ");
INSERT INTO hwo_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nggǝrangga Mbulus sǝ ndǝghǝn, “Kyaharwa hutenna hai wa, Alvari, ˈya niya thlǝkrha ƙǝkafek ni. ");
INSERT INTO hwo_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Sǝn kutǝra ǝnggina sǝ ya, ndǝn niya kal farha hai tǝ thlǝkrǝghǝn. Sǝnɗisǝ kutǝra Anggiripa sǝnɗǝ ǝnggini niya thlǝkrha heu ya ƙǝsǝr ǝna wa ndan ɓǝɓee wa. ");
INSERT INTO hwo_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kutǝra Anggiripa fǝrna ƙǝkafek tǝ annabiya wa? Sǝnɗisǝ fǝrna ƙǝkafek.” ");
INSERT INTO hwo_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tǝrgha ndangga Anggiripa Mbulus, “Tamngga ndaarha a sayi ngguchit kiya na mbang lǝm nggi fa tsawi Ƙǝrǝsta wa?” ");
INSERT INTO hwo_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ndangga Mbulus, “Ko sayi ngguchit nduwa ɓeena hangga, niyi a hwan Faara tǝ ndaarha mbǝ sa katenwa wa, heu tǝ fingya na a kee thlǝmaarha fa a weeriya tsawa nda ƙǝla nggi, amma mbǝ tǝ wuyiwurɗi ya wa.” ");
INSERT INTO hwo_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tǝrgha kutǝra, tǝ ngwamna tǝ Mbanis tǝ fingya tsau nanda a mbǝrha tal wii nda. ");
INSERT INTO hwo_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mal ƙǝnɗa nda, na nanda a ndikrha tǝ ndan, ndanda, “Niifɗiya mbǝ ˈyasǝ ǝnanǝn tsǝkka a ɓǝlanggǝm wa, nduwa muwang nggǝm ahu porsǝna ɗǝ wa.” ");
INSERT INTO hwo_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kutǝra Anggiripa ndanggǝn Festus, “A mbǝ nggǝrna kamshiɗi huhwaarha a mbed Kaisar wa, kam nǝm a kalghǝn hai.” ");
INSERT INTO hwo_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sǝlna farɗa ɓa ngwan fa ɗan Italiya ɗǝ ahu kombuwol, Mbulus tǝ fingya porsǝnaya fǝr kanda nda a haar mamnda sodja Romaya hai na nda aarha Djuliyos nǝghǝn tal ahu sodjaya na a haar Kaisar. ");
INSERT INTO hwo_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kya nan ahu kombuwol hai a Adǝramitiyom, na a ɗǝrha ahu fingya talya ɗǝ na chehweed Asiya, thlii wiirha nan a ten wuri aamɗi. Aristakus niif Tasalonika na a chehweed Makidoniya nǝghǝn ahur nan. ");
INSERT INTO hwo_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɗalthna mbǝrha hai sǝlan a Sidon ɗǝ, Djuliyos ǝnang nggayirha nǝn Mbulus malanggǝn ɗǝgha wal pashiyighǝn tǝna nda fǝrang ˈya na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mal nan Sidon, nagha ɓereurha a tsang hura kan fa, ɗan ɗǝ tsau tǝ wutambar Sayifurus fa tǝnan hǝrǝkrha ma ɓereuɗi. ");
INSERT INTO hwo_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Mbǝrang nan wuri aamɗa hai na a Silisiya tǝ Pamfiliya, sǝlan a Mira ɗǝ na a chehweed Lisiya. ");
INSERT INTO hwo_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","A mbǝɗani walna mamnda Sodja Romaya ɗi kombuwol yi Aledzandǝriya na ɗǝrha Italiya ɗǝ, kyanggǝn kan sa hai. ");
INSERT INTO hwo_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Əna ɓengya nan hangga a kwamana ƙǝsǝr naghan a wiirha samma-samma pǝrpǝr sǝl nan a Ƙǝnidus ɗǝ. Malang ngwana ɓereuɗi kan ɗǝrha mbeeɗǝ, kyan tǝ man fad wutambar Ƙǝriti na tsau tǝ Salmoni fa. ");
INSERT INTO hwo_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Pǝrpǝr mbǝrang nan mbǝɗa hai ɓan mbǝrha ɓa na nda aarha, mbǝd hǝrghang nda kombuwol, tsau tǝ tal Lasiya fa. ");
INSERT INTO hwo_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mbǝd ɗan hai kaan a mbǝɗi, tsauka wiin nan pǝɗaghǝn ƙǝsǝr nanǝnya mbǝr kar aama ɗǝ. Nanǝn kee, ƙǝsgha Mbulus thlǝman ndan ndǝghǝn, ");
INSERT INTO hwo_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Waya, ahu widɗi kyanǝm ya na ǝn tǝrǝmnda sǝ a mbee nanǝnya, kombuwol nǝm tǝ rǝfǝnnǝm na nda a sǝbrha ɗǝ kaan, heu tǝ yibya hangga na nda a sahatta.” ");
INSERT INTO hwo_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amma mamnda sodja Romaya ɗi karɗǝ kang thlǝmaarha Mbulus fa ƙǝl yi tǝ hur kombuwolɗi tǝ niif Kombuwolɗi. ");
INSERT INTO hwo_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nanǝn mbǝd hǝrǝkrha nggirggi Likiya mbǝ ngga na a ǝnagha nggirggiya fegrha sǝ wa, ƙǝsǝr ka ǝn ɗiya, hang ndǝndan ndanda a nggushi ɗǝnda mbeeɗǝ tǝ wiirha tǝna nda sǝla Finikiya ɗǝ anaɗǝ a ǝnaarha hai ǝna fegrha nda a mbǝɗi. Finikiya mbǝd isha nggirggiya ni na a Ƙǝriti na a man kii pǝlasarya tǝ hǝmnda yanfaara fa tǝ ƙǝm man kii wufaya tǝ hǝmnda yanfaara fa. ");
INSERT INTO hwo_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Katǝrang na ɓereurha ɓarha ɓa a man kii pǝlasarya ɓa, tamngganda ndaarha wal nda ǝnɗi na mindan; tǝrgha kwasang ngganda nggirggi ndan hai wii nda tǝ mii wuri aam Ƙǝriti. ");
INSERT INTO hwo_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tsǝɓaku, ɓereurha ɓagha ɓa kaan a wutambar ɗa ɓa a man kii wufaya tǝ man kyad fara. ");
INSERT INTO hwo_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ƙǝsangga ɓereu ˈyaarɗi nggirggi ɗa hai mbangwa nji teena ahu ɓereu ɗaɗǝ wa, malanggan kee nagha ɓereuɗi a pughang kanɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mbǝrang nan wutambar ɗa hai ngguchit na nda aarha Kauda, pǝrpǝr mbang nan ƙǝnang nda nggirggi ɗa hai na ngguchit na a saman nan. ");
INSERT INTO hwo_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","A kwasamadɗi kahang nanda Nggirggi ɗa ɓa na ngguchit ƙǝnang ngganda sakhkya a fad kombuwol ɗi na manggǝn amanǝn ɗǝ fǝla ɗǝ. Na nda a tǝrǝmnda na ɗa nda ɗǝrha hu chehweed Sǝrtis ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nana aamɗi a ǝna kuɗufulla, nagha a tǝtǝnang kan, ɗalthna mbǝrha hai katǝrang ngganda thlahang fingya rǝf yinan haaɗǝ na ahur nggirggi ɗi ahu aama ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Afar ɓeena yi mahan muwang ngganda fingya kari taara ɗǝ yi nggirggi ɗi. ");
INSERT INTO hwo_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ɓengya hangga kyawa yanfaara ɓa wa, nduwa wufǝlngaarya, nagha ɓereurha a piirha kaan, numan tǝ ndaarha mban a hǝrǝkrha wa. ");
INSERT INTO hwo_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A kwasamadɗi mǝnna nafina ha na ahur nggirggi ɗi kanda kula wal ǝnnarhami, tǝrgha Mbulus thliigha sǝ a mbed ndan ndǝghǝn, “Waya, a ndam kwang kee ɗun thlǝmaarha fa ƙǝla ndangni kun a mal ɗun wutambar Ƙǝriti wa, kam kya wum hu sǝsadɗa hai ya wa. ");
INSERT INTO hwo_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Amma nanǝnya, niya ndang nda kun ƙǝrsaama, ƙǝsǝr mbǝ niifa sǝ na a ƙǝɗeng yiɓǝdghǝn wa, ƙǝl nggirggi ɗi kee ndǝn nǝm a ƙǝɗeng nda. ");
INSERT INTO hwo_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Fǝɗik ɗi mbǝrgha ɗǝ tǝ thlǝnda Faara nani yighǝnni tǝ ƙǝm niya tǝrang shilee teena ishɗǝ a thlǝmadna, ");
INSERT INTO hwo_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ndeeghǝn, ‘A tǝrǝmna wa, Mbulus. Na isha a mbed Kaisar nggo kumarha nǝn sǝ. Faara hu nggayidghǝn fǝrɗǝ hǝrǝkrha a fiya heu ka sa.’” ");
INSERT INTO hwo_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nanǝn kee ƙǝrsaama ƙǝsǝr fǝrɗi ƙǝkafek a Faara nǝn a katǝrarha hai ƙǝla pǝree nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amma tǝtani a puwangga ɓereurha ƙǝm a wutambarra ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A fiɗik kumkap faɗa nagha ɓereuɗi aten puwang kanɗǝ a ten wuri aam Adǝriyatik, a manad fiɗikrha fa hur nggirggi yini sǝnang ngganda hai takhɗan a ndusang chehweerha fa. ");
INSERT INTO hwo_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ƙǝƙǝrang ngganda kuɗim ndǝghǝn sǝlɗǝ saara haru tǝ kumnggit sǝri. Tsǝɓaku nggǝrgha nda ƙǝƙǝrang nda kuɗim ndǝghǝn ƙǝla nda hai saara kumnggit wutarihe. ");
INSERT INTO hwo_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ka tǝrǝmnda naɗǝ nggirggiɗi ɗǝk ferya fa, kal ɗǝɓǝlya nda hai faɗa na hǝhaaghǝn a kamu wuri aamɗa hai tǝ man samadghǝn ka a ˈyaɗang wiirha nǝn fa, hwan Faara nda a ɗalthgha mbǝrha hai wed. ");
INSERT INTO hwo_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tǝrgha fa hur nggirggi ɗi na mindansǝ a ɗa nda, tǝra nda hu kombuwol ɗa hai na ngguchit ƙǝla nanda a kal ɗǝɓǝla hai na haaghǝn a man mbee. ");
INSERT INTO hwo_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Amma ndangga Mbulus mamnda sodjaɗi tǝ fingya sodjaya, “A ishwa nafini a thlǝmad nggirggiɗi ya wa, mbun a hǝrǝkrha wa.” ");
INSERT INTO hwo_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nanǝn kee sodja yini thleng nggand sahad kombuwolɗi ƙǝsgha ndǝn ha malghǝnda hwagha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Takhna mbǝrha a ɗathla hai ndangga Mbulus kanda heu a hǝb ǝnnarhami nda. Ndǝghǝn, “Ɓengya kumkap faɗa mbǝrgha ɗǝ nuwun ahu ɓillarha kaan ǝnawun ǝnnarhami wa. ");
INSERT INTO hwo_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Niya ndang nda kun nanǝnya, ǝnama ˈya mii tǝnun wal kanglanggirha. Mbǝ niifa sǝ na a ƙǝɗeng ko was tenggǝnni wa.” ");
INSERT INTO hwo_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Tǝrgha tǝranggǝn mburodi sǝ usa Faara nǝn a mbendan heu. Kyanggǝn hai nagha a kiighǝn. ");
INSERT INTO hwo_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wal kanglanggirha nda ǝna ǝnnarhami nda mii. ");
INSERT INTO hwo_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kan heu haru sǝri tǝ kumnggit mǝd kap mikki na ahur nggirggiɗi. ");
INSERT INTO hwo_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ngwalang nanda hǝb ǝnnarhami, thlahang ngganda haad nggirggiɗa ha ɗǝ na nda a irang wan hwalirha ɗǝ ahur wuri aama hai. ");
INSERT INTO hwo_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ɗalthna mbǝrha hai, sǝnangwanda chehwedɗa hai na nanda sǝ wa. Amma na mbǝd tsǝchelhomnda, ndanda a nggushi ɗǝna nda tǝ nggirggiɗi a mbǝɗaɗǝ ananda a mbang nda. ");
INSERT INTO hwo_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Tǝrgha thleng ngganda sakhkini na tǝ ɗǝɓǝl yini hǝhaaghǝn mal kanda nda ahu wuri aamɗi, tǝ ƙǝm kwasangganda sakhkina hai na kyakhrang nda nggirggiɗi. Tǝrgha thlengganda shishamarɗa sǝ na a mbed nggirggiɗi a ɓereurha tǝnǝn puwang kanda a mii ƙǝƙǝshɓangnda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amma nggirggiɗi tsuwar chehweerha nǝn kyagha kamughǝn ɗǝ mbangwa tsǝ ˈya fa wa. Tǝrgha nggirggiɗi nagha a fǝlaɗǝ ka kuɗufulla aamɗi. ");
INSERT INTO hwo_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sodja yini na mindan sǝ a ɓǝlang ngganda porsǝn nggini ama nanda pǝpeethla hǝrgha nda. ");
INSERT INTO hwo_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma mamnda sodja Romaɗi na midghǝn sǝ a hǝrghanggǝn Mbulus karanggǝn kanda fa. Ndanggǝn kanda yi mbangga aama ˈwa pǝra nǝn pǝpelthgha a mii ƙǝƙǝshɓangnda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tǝrgha ndanggǝn fingya ƙǝs katako ndan nduwa kukutathla nggirggiɗi. Kanda heu hǝrgha nda sǝla nda mii ƙǝkǝshɓang nda ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","A kwasamadɗi hǝrǝk nan kan a ƙǝƙǝshɓangnda, ndǝn sǝk nan tǝ ndaarha nan a wutambar Malta. ");
INSERT INTO hwo_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nafiya wutambar ɗi ǝnang nggayirha nda kan kaan. Thlǝn nda kan fa, dzǝghang waarha nda kan sǝ, ƙǝsǝr na ˈyaara a ɓaarha heu tǝ mbiirha. ");
INSERT INTO hwo_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ɗamna Mbulus hwarirha ɓa, nanǝn a sang nda hu waarha hai kyagha kwadwasaarha sǝ ka thlerra wadɗi ɓillagha ndǝn, ƙǝtghǝnǝn a haarghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nafiya wutambar ɗi na huthlin ɗa nda nggawal-nggawal a haar Mbulus ndangganda ndan, “Niifɗiya tǝ ɓǝl farha ni, ko nanǝn hǝrǝk ɗǝ ahu wuri aama, faar ngwa kumarha mbǝ a malang tǝ yibrha wa.” ");
INSERT INTO hwo_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Amma Mbulus yiranggǝn huthlin ɗa ɗǝ mukka ahu waarha hai ko ˈya walghǝn. ");
INSERT INTO hwo_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Fiya a numad ndaarha nǝn a hǝthla hai nduwa fǝlgha hai mǝrgha. Amma tsǝna nda tsǝɓaku mbǝ ˈyasǝ walgha ndǝn wa, nggǝrang ngganda numad ndan hai ndanda kamshiɗiya faara ni. ");
INSERT INTO hwo_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tsau tǝ mbǝɗi katǝrana ǝnɗa hai tǝ Mbulus na wure sǝ manggǝn yi Pubiliyus, mamnda wutambar ɗi. Thlǝ kan nǝn fa a minda keeghǝn tǝ wutsǝfayirha, ɓeena mahan ndǝghǝn a fǝrang ǝnnarhami kan. ");
INSERT INTO hwo_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Chin Pubiliyus ahu sǝra, fadghǝn ɓee tǝ ƙǝm fau a ɓillaghǝn. Kyagha Mbulus thlǝmadghǝn ɗǝ, hwan Faara nǝn, sang haara nǝn fa ƙǝngga. ");
INSERT INTO hwo_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Katǝrana ǝnɗa hai kee, tǝrgha haaya na ahu wutambar ɗi ɓa nda ɓa wal ƙǝnda nda. ");
INSERT INTO hwo_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nagha nafini a fǝrang mamnggirha kan ahu kwamangya hangga. Takh nan a wiirha, fǝrang ǝngya nda kan hangga na minnan. ");
INSERT INTO hwo_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","A kwasamad ndǝree mahan kyan hu nggirggi Alidzandariya tsauka hai a wutambarɗi a ndǝri mbiirha. Na nggirggiɗi tǝ tǝnda muɗad faarya Kasto tǝ Polus. ");
INSERT INTO hwo_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kya nan Sirakus hai ǝna ɓeena nan mahan a mbǝɗi. ");
INSERT INTO hwo_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Thlen ɗan Rigiyum ɗǝ. Ɗalthna mbǝrha hai piigha ɓereurha ɓa a man ki pǝlasarya. Akwasamad ɓeena sǝri sǝlan Putiyoli ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A mbǝɗi ɗan wal fingya fatakkwaya, hwan kan nda ǝna ɓeena nan mǝd tǝ kanda a ɗan Roma ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Sǝkna fatakkwaya ndaarha naghan ɓayi, thlii nda hwathla kanda fa hu Kasu Apiyus, fingya ƙǝm ɓa nda wal kan a mbǝrha na nda aarha Ƙǝn rongya mahan. Nana Mbulus nafini kee usa Faara nǝn wal kanglanggirha nǝn. ");
INSERT INTO hwo_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Sǝl nan a Roma ɗǝ, malangganda Mbulus tsauka hu ƙǝn rongya katenggǝn tǝ sodjaɗi na a ƙǝlaghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Akwasamad ɓeena mahan, aagha Mbulus shingya Yahudaya ɓa. Wumna nda ɓa, ndangga Mbulus kanda, “Wanmanggina, ko nanǝn mbǝ ˈya sǝ ǝnang ni nafinǝm fa nduwa ǝntin chichiyi nǝm wa, ƙǝseegha nda a Urshalima fǝr nggi nda a Romaya. ");
INSERT INTO hwo_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tsahe mee nda ha ngga, na mindan sǝ a kal nggi nda hai, ƙǝsǝr mbǝ ˈya sǝ ǝnani tsǝkka a ɓǝleegha nda wa. ");
INSERT INTO hwo_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amma mamngya Yahudaya kara nda fa, tsaweeghǝn fa tǝta a ɗi a mbed kutǝra Kaisar ɗǝgha ngwee kumarha sǝ, ko nanǝn ɓawi mbǝɗa ɓa ya ka huhwa nafinani wa. ");
INSERT INTO hwo_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nanǝn kee, ndǝn kaɗa ni kwamana a na kunni ka a kalanggi kunsǝ kiya, ƙǝsǝr ƙǝneegha nda tǝ wuyiwurɗi ya aten niifɗi na Isǝrelaya a ƙǝlarha fa, Ƙǝrǝsti. Fǝrɗi ƙǝkafek ˈwaɗǝ teena ɓaɗa ɓa.” ");
INSERT INTO hwo_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ndang ngganda, “Wal wan ɗeleewar a Yahudiya ɓa atenwa wa, mbǝ nafinǝm Yahudaya ɓagha ɓa a mbǝɗi thlǝkka ˈya atenwa nduwa tsǝgha laɓara mbuwa ngga atenwa wa. ");
INSERT INTO hwo_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma na minnan sǝk ˈya nan fǝrna ƙǝkafek atenggǝn, ƙǝsǝr sǝn ɗan sǝ fiya ko a yanggini a thlǝk ˈya ɗimi aten takkwad Yeeso.” ");
INSERT INTO hwo_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Farɗasǝ ngwa nda fa kanda hangga ka ɗa nda wal Mbulus, ɓa nda mbǝɗa ɓa nanǝn sǝ tǝ tsaurha. Ka a tsar ta figrha ɗǝ, ndǝghǝn a thlǝghang laɓar kutǝryid Faara kanda. Na midghǝn sǝ a lǝm kanda nǝn fa ka a thlǝ Yeeso nda na fa. Ənaghǝn taara tǝ ɗeleewarya Musa tǝ yi annabiya. ");
INSERT INTO hwo_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Fingya nggǝm nda fa tǝ laɓarghǝn, amma fingya fǝr wa nda ƙǝkafek wa. ");
INSERT INTO hwo_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nggǝmngwa nda fa tǝ ndan wa katǝrang ngganda wiirha hai a kwasamadɗi ngwalana Mbulus palthghǝn tǝ ndaarha, “Pǝr Sǝsǝna tǝ Peɗǝnda ƙǝkafek a chichi yinun ndanǝn ahu ɗeleewar Ishaya, ");
INSERT INTO hwo_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ɗuwa thlǝmad nafina ɗǝ ndangga kanda, Nun sǝk ˈya amma mbun a sǝnang hai wa; Nun a na ˈya amma mbun kukwalang hai wa. ");
INSERT INTO hwo_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ƙǝsǝr hur nafiniya nǝghǝn kakrak; Mba nda sǝk ˈya tǝ thlǝma yi ndan wa, Tǝ ƙǝm nggǝlang nda yiyi ndan. Kam nandan tǝ yiyi ndan, Sǝgha nda ƙǝm tǝ thlǝma yi ndan, Sǝnang ngganda hai tǝ hur ndan, Kyakhra nda hai, Ƙǝnanggi kanda.’ ");
INSERT INTO hwo_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Tsaunǝn kee, na minna sǝ a sǝnunsǝ ˈwanda teena thlǝnang nda laɓar hǝrǝkrha Faara a fingya ɗǝ mbuwa wa Yahudaya, na nda a kang thlǝmaarha fa!” ");
INSERT INTO hwo_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Hǝrǝm nǝn ndaarha kee, tǝrgha thliigha Yahudaya sǝ na nda a ngaala kaan a pathlang ndan. ");
INSERT INTO hwo_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Hurarha sǝri Mbulus tsau ahu mindǝɗi nanǝn a tiirha, nagha a thlǝ fiya fa heu ɓagha thlǝmadghǝn ɓa. ");
INSERT INTO hwo_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kula tǝrǝm nda ndǝghǝn a pǝr laɓar kutǝryid Faara tǝ tsaharhaha aten Chinǝm Yeeso Ƙǝrǝsti, mbǝ niifa sǝ mbangga ˈyaɗanggǝn fa wa.");
INSERT INTO hwo_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nggi na Mbulus, mafad Yeeso Ƙǝrǝsti, aah na nda nggi ka a tsawi tǝthlǝnda Yeeso, wuwura ka a pǝr laɓar Faara ni. ");
INSERT INTO hwo_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Laɓarɗi na mbǝnggǝn ya ndǝn ɗǝfna Faara miighǝn ka ƙǝtǝm a mii annabi yighǝn, ƙǝla nanǝn chichireethlee hai hu ɗeleewar laɓar Faara tǝpeɗǝnda. ");
INSERT INTO hwo_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Laɓarɗi na Mbǝnggǝn ya aten Wanggǝn ni, Chinǝm Yeeso Ƙǝrǝsti, ahu thlu farha turya Ndauda ni. ");
INSERT INTO hwo_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kyad ndan a pǝpal tǝ ndaarha Laɓarɗi na Mbǝnggǝn ya aten Wan Faara ni thliigha sǝ ahu mǝra tǝ sǝsǝmnda Sǝsǝna tǝ Peɗǝnda. Ndǝghǝn ni na Yeeso Ƙǝrǝsti na Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","A fadghǝn ni ndǝn wal nǝm nggayirha tǝ aarha na a tsawi tǝ thlǝndǝghǝn tǝni aah fiya ɓa a fǝrƙǝkafek nda tǝghǝn na a fǝrang mamnggirha nda thlǝmnggǝn. ");
INSERT INTO hwo_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Tsuwar yanɗi kun fa ya, kun aah na nda a tsawun yi Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","A kun heu na a Roma, nggǝmna Faara, aagha kun a tsawun nafiyighǝn tǝpeɗǝnda. Ngwa tsauka nggayirha tǝ tsawud ɗǝɗemnggirha yi Faara na yinǝm china tǝ ƙǝm Chinǝm Yeeso Ƙǝrǝsti a tsauka tǝ kun. ");
INSERT INTO hwo_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","A katǝradghǝn niya ˈwa usa Faara ahu Yeeso Ƙǝrǝsti ka kun heu, ƙǝsǝr na nda a thlǝk laɓar fǝrƙǝkafekkid nun ko a yanggi ni hu ƙǝshiirha. ");
INSERT INTO hwo_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ƙǝsǝr Faara niya ǝnang taara tǝ hurna tǝtali ahu pǝr Laɓarghǝn na Mbǝnggǝn yi Wanggǝn, ndǝn shedagha nggi tǝ ndaarha ni naarha ɗal kun in ƙǝtsar ahu hwanda Faara niya ǝnaarha, ");
INSERT INTO hwo_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","kala sayi a naɗi a hwan Faara. Niya hwan Faara tǝ ndaarha, ana nggǝmnda hurghǝn ni, a wal kwamana ni ɗi thlǝmad nun ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ƙǝsǝr nǝghǝn a kukwashe fa a na kun ni a ɗanggi kun sǝ tǝ fǝrra sǝsǝna na a fǝrang kaali nǝn kun. ");
INSERT INTO hwo_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ˈYa na minna, nda nggi tǝ kun a fǝrang kaali nǝm ndan hu fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Shayina na minna sǝ a sǝnunsǝ, saara hangga nggi a ngwarha fa na a ɗi thlǝmad nun ɗǝ, amma walwi kwamana wa. ˈYa tǝrna minna thlǝmad nun ɗǝ ka ɗi haathla ahur nun ƙǝla ǝna ni ahu fingya mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Na hakked fiya sǝ a tenna, fiya na a wupǝri tǝ fingya mbuwa a wupǝri, fingya na tǝ sǝnda tǝ fingya mbuwa tǝ sǝnda, tǝta ni a pǝrang laɓarghǝn ni kanda heu. ");
INSERT INTO hwo_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nǝghǝn a kukwashe fa na a pǝrang Laɓaara ni kun na Mbǝnggǝn a kun na tǝ tsaurha a Roma. ");
INSERT INTO hwo_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ƙǝsǝr shiɗee wa pǝr laɓar Faara ni wa, ƙǝsǝr sǝsǝmnda Faara ni na a ǝna taara ka a hǝrghanggǝn kowunni fǝrgha ƙǝkafek. ˈWaghǝn aten Yahudaya tǝƙǝm ɗǝgha ten fingya ɗǝ mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ƙǝsǝr ahu Laɓar ɗa ni na Mbǝnggǝn ya kyadna Faara nggayidɗi, nǝm wal nggayidɗi ˈyahu fǝrƙǝkafek, ka a katǝradghǝn ta mii ngwaladghǝn ɗǝ. Ƙǝla nanǝn chichireethlee hai ahu laɓar Faara tǝ ndaarha, “Niifa na tǝ nggayirha fa nun tsaurha tǝ fǝrƙǝkafek fa.” ");
INSERT INTO hwo_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ƙǝsǝr kyad Faara sǝbrha hurghǝn hai a talara, aten yamid takkwa Faara, tǝ tar mbǝlfeerha na fiya a ǝnaarha na nanda a kar ƙǝkafek fa ka tar mbǝlfed ndan. ");
INSERT INTO hwo_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ƙǝsǝr ˈya nǝm mbang sǝnda aten Faara nǝghǝn a pǝpal a fad ndan, ƙǝsǝr Faara ndǝn kyaɗangga ndǝn kanda a pǝpal. ");
INSERT INTO hwo_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ka ǝna nanda ƙǝshiirha ǝn ǝnad Faara mbuwa nǝm naarha, ƙǝla sǝsǝmndǝghǝn yi pakwanɗǝ, tǝ targhǝn, nad yirha ndǝn a pǝpal, sǝnang ɗun ǝngya hai ǝna nanda. Nanǝn kee mbǝ ˈya sǝ na fiya mbang ndaarha wa. ");
INSERT INTO hwo_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ko nanǝn sǝnda Faara, mbangwa nda tǝrang shilee in tǝ ndaarha ndǝghǝn ni Faara wa, nduwa usaghǝn nda wa, amma numad ndan tsauɗǝ mere kee, hur ndan yi nuryirha ƙǝm tsauɗǝ wulghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Tamngganda ndaarha na nda ndǝndǝl ashe nurya ni kanda. ");
INSERT INTO hwo_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Kyakhrang ngganda mamnggit Faara hai mbuwa mǝra tǝ ɗaharha na ƙǝla niifa na mǝra, tǝ ƙǝm ɗahaya na ƙǝla wuɗikkya, maɓiya, tǝ fingya na kakhrha tǝ hura ƙǝla nda hulthne tǝ tusalya. ");
INSERT INTO hwo_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Tsaunǝn kee malangga Faara kanda ɗǝnda mbeeɗǝ tǝ ǝna tar ɗimiyirha tǝrna mindan. Nanǝn kee, na ndaa ǝna ǝn tsanda a pathlang ndan. ");
INSERT INTO hwo_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Kyakhrang ngganda ƙǝkafekkid Faara hu nggaɓaarha ɗǝ. Na nda a tǝrang shilee ǝngya teena ǝna nanda ma Faara tafadghǝn, tsauka ndǝghǝn ni tsǝkka a fal ghǝnda pakwanɗǝ. Atsaukake. ");
INSERT INTO hwo_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nanǝn kee, ndǝghǝn ɗani malang na Faara kanda ɗǝnda mbeeɗǝ tǝ suna ǝna tar ǝn shilee tǝ ǝn tsanda. Nishyi ndan ƙǝm mbeɗeng ngganda hunarha hai nuneefa tǝ hǝshneefa tsauka mǝmǝl ka kya nanda ǝna ƙǝshiirha, ahu hunarha hai tǝ shayi ndan nishya, kamngwa wa. ");
INSERT INTO hwo_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Tsaunǝn sunan ndan kyaɗǝ hur ndan hai, tǝrgha hǝshya ƙǝm malang ngganda hunarha hai tǝ nishya kamngga ka kya nanda ǝna ƙǝshiirha. Nagha hǝshya a ǝna ǝn shilee tǝ ndan. Ahu ǝna ˈya kiya aang nda tsǝtsǝlla alten ndan fa ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Tsaunǝn numawa nda tǝ ndaarha kamɗǝ a ƙǝs sǝnda Faara nda ha na nanda tǝghǝn ha wa, malangga Faara kanda ɗǝnda mbeeɗǝ tǝ numad ǝngya kamngwa wa a ǝnaghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Na nda lǝlǝgɗa tǝ kala tur yanggi mbǝlfeerha, tǝ ɗimiyirha tǝ suna, tǝ tsan ndan, tǝ sǝrǝkkirha, tǝ ɓǝl farha, tǝ yanda, tǝ hukrha, tǝ ƙǝs ndan hur tǝ kiki farha. ");
INSERT INTO hwo_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Na nda sǝb thlǝma, na nda a kar Faara fa, tǝ ˈyar farha, tǝ taala, na nda kaɗa kwaman tar mbǝlfeerha, tǝ yamid fǝrang mamnggirha fa nggǝtyindan. ");
INSERT INTO hwo_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Mbǝ hakkilo sǝ a fad ndan wa, mba nda tǝ ƙǝkafek fa wa, mba nda nggǝm ndan wa, tǝ ƙǝm mba nda haɗang ndan fa wa. ");
INSERT INTO hwo_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Sǝndasǝ tǝ ndaarha, ndagha ngyakhrha Faara, fingya na a ǝna ǝnggini ya kamɗǝ a mǝra nda. Amma mbǝ ka a na nda a ɗǝrha mbeeɗǝ tǝ ǝnaghǝn kee wa, amma ƙǝnang paama nda fingya yina mu na a ǝna kanda. ");
INSERT INTO hwo_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nanǝn kee, mbǝ ˈyasǝ na mbang ndaarha wa, ko wunni sa, sa na a ngwang kumarha niifa sǝ pak. Ƙǝsǝr a sayidɗi na a ngwa kumarha aten niifa, na a ngwang kumarha fad wa ni sǝ. Ƙǝsǝr sa tafadwa na a ngwa kumadɗi na a ǝna tur ǝnggini ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nanǝnya sǝnɗǝm sǝ ngwa kumad Faara aten nafiya na a ǝna tur ǝngginiya mǝmǝl ni. ");
INSERT INTO hwo_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Sa na niifa mere. Sa na a ngwang kumarha fingya sǝ na a ǝna tur ǝngginiya. Amma sa tafadwa a ǝnarha kee. Tamngga ndaarha na hǝrǝkrha ma ngwa kumad Faara wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nduwa ɗǝm na hang nda nggayid Faara, tǝ munyadghǝn, tǝ yamid huf hurghǝn nǝn a ǝnaarha atenwa wa? Ashe sǝngwa sǝ tǝ ndaarha nggayid Faara atenwa ndǝn nǝn a kyorha hu kwaman kwa pǝma ɓa wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Amma ka kakrakkid tenwa tǝ kakrakkid hurwa, na a wumang sǝbrha hura altenwa fa hai a far sǝbrha hur Faara, a far ngwa kumad nggayid Faara nǝn a kyarha pǝpal ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Na Faara a teng kowunni aten ˈya ǝnanǝn. ");
INSERT INTO hwo_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","A fingya na a nji teena tǝ ǝna nggayirha, kaɗa mamnggirha nda tǝ manang alteena tǝ yamid mǝrra, kanda ni na Faara fǝrang yibrha kanda mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amma fingya na a nggǝm alten ndan, kar nda fǝrƙǝkafek fa ƙǝl takkwa mbǝlfeerha na sǝbrha tǝ hufrha hura sǝ aten ndan. ");
INSERT INTO hwo_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Na ɓillarha tǝ sǝsaarha a ƙǝla fingya fa na a ǝna mbǝlfeerha, nǝn a ˈwaarha tǝ Yahudaya ta ten fingya ɗǝ mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Amma fingya na a ǝna nggayirha na Faara a fǝrang mamnggirha tǝ tsawud ɗǝɗemnggirha, nǝn a ˈwaarha tǝ Yahudaya a ɗǝgha ten fingya ɗǝ mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ƙǝsǝr Faara mbǝ wura hasǝ wa. ");
INSERT INTO hwo_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Fingya ǝnagha ɗimiyirha sǝngwanda Ɗeleewar Musa wa, na nda a ngwang kumarha kanda sǝ aten ɗimiyirha ǝna nanda mbǝ tǝ ngyakhrha Musa wa. Amma fingya ǝnagha ɗimiyirha sǝnda Ɗeleewar Musa, na nda a ngwang kumarha kanda sǝ tǝ ˈya ndaana Ɗeleewar ɗi. ");
INSERT INTO hwo_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mbǝ sǝk ˈya ndaana Ɗeleewar ndǝna tsang fiya tǝ nggayirha fa a mbed Faara wa, amma ǝna taara tǝ ˈya ndaana Ɗeleewar. ");
INSERT INTO hwo_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Fingya mbuwa Yahudaya mba nda tǝ Ɗeleewar ngyakhrha Musa wa, kanda tafad ndan kyad ndan a pǝpal ˈya kamngga a ǝna nda tǝ ˈya kamngwa a ǝna nda, ko nanǝn fǝrang ngwanda ɗeleewar ngyahad Musa kanda wa. ");
INSERT INTO hwo_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ən ǝnan ndan kyadɗǝ ndaarha ǝnɗi ndaana Ɗeleewar ɗi nǝghǝn chichireethlee hai ahur ndan. A hu numad ndan a fara sǝmǝn nǝn ndang kanda ǝnawa nda ngga wa, a fara sǝmǝn ƙǝm ndanggǝn kanda ǝnanda ngga. ");
INSERT INTO hwo_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Laɓar ɗani na Mbǝnggǝn ya niya pǝra, na fara ɓayi na Faara, ahu Ƙǝrǝsti Yeeso, a ngwang kumarha kowunni ahu ˈya na ɓǝɓee na ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kun na a aah fad nun Yahudaya kun a mbǝrsaarha tǝ Ngyahad Faara, non a taala tǝ Faara. ");
INSERT INTO hwo_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Sǝnɗun ˈya na midghǝn, sǝnɗun ˈya na mǝmǝl ƙǝsǝr tsahang nda kun ha aten ngyahadɗi. ");
INSERT INTO hwo_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Sǝnnasǝ sani tǝƙǝs ƙǝkalad kwamaya ha, tǝ ƙǝm sani kukwaryid fingya na hu wula, ");
INSERT INTO hwo_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","tǝ tsǝtsǝl nurya, tǝ tsahang nda wundakhnaya ha, ƙǝsǝr ahu ngyahadɗi ya na lǝlǝgɗa tǝ sǝnda tǝ ƙǝm ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Sa na a tsahang niifa ha, mba a tsahang alten wa ha wa? Sa na a pǝr laɓar Faara tǝ ndaarha a ngaarna wa, amma sa mba a ngaara wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Sa na a ndang nda fiya a ǝnanda kulafayirha wa, mba a ǝna kulafayirha wa? Sa na a tsan ɗaharha, amma mba a ngaara hu kǝn ɗaharha wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Sa na a taala tǝ ngyakhrha, mba a sǝɓang thlǝm Faara ɗǝ tǝ hwasang nda ˈya ndaana ngyahadɗi wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ƙǝla nanǝn chichireethlee hai hu ɗeleewar Faara, “Ka pususuyid nun ni, na fingya mbuwa Yahudaya a sǝɓang thlǝm Faara ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Thlee muwa nǝghǝn ngga, a nanna a takkwa ˈya ndaana ngyakhrha. Amma a hwasang na ˈya ndaana ngyakhrha tsauna ƙǝla thleewa muwa wa sam. ");
INSERT INTO hwo_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ana fingya thlee wa muwa a ǝna taara tǝ ˈya ndaana Faara, mbǝna Faara tsawang kanda ƙǝla nafiya thleegha muwa wa? ");
INSERT INTO hwo_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ai, Yi mbuwa tǝ Yahudarha thlee wa muwa ƙǝsgha ngyakhrha Faara ha ngga nǝn a nggo kumarha sǝ sa na tǝ Yahudarha thleegha muwa na tǝ ngyakhrha Faara ha amma ǝnawa taara sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Mbǝ ˈya na a ƙǝshi ndǝna tsaworha tǝ Yahudarha wa, mbǝ thlee muwa yi pam farha nǝm a naarha wa. ");
INSERT INTO hwo_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Awo, ka tǝ Yahudarha ndǝna niifa na tsawudghǝn mǝmǝl tǝ Faara. Thlee muwa yi ƙǝkafek ndǝna thlee muwa yi hura hu Sǝsǝna, mbǝ tǝ ǝna taara tǝ ˈya na chichireethlee hai hu ngyakhrha wa. Niifa na ƙǝla kiya nǝn kaɗa faala a har Faara, mbǝ falla fiya wa. ");
INSERT INTO hwo_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nanǝn kee, mani chighǝd tsaurha tǝ Yahudarha? Mani ngga hu thlee muwa? ");
INSERT INTO hwo_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ai nǝghǝn sǝ kaan hu kwamangya hangga. Yi tal, Yahudaya ndǝn fǝrang nanda laɓar Faara kanda. ");
INSERT INTO hwo_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Amma ana fingya sǝ mbuwa tǝ fǝrƙǝkafek wu? Yamid fǝrƙǝkafekkid ndan tsauɗǝ mbǝ Faara naarha tǝ ƙǝkafek fa ƙǝsǝr ka fingya nafiya mbuwa tǝ ƙǝkafek fa wa? ");
INSERT INTO hwo_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Sam mbǝ kee wa, Faara nǝghǝn tǝ ƙǝkafek fa, ko nanǝn kowunni nǝn nggaɓaarha. Ƙǝla nanǝn chichireethlee hai, “A sǝngga fiya sǝ na ƙǝkafek sǝ a fadwa, a kalna sǝ, tǝ ƙǝm na a thlang fadwa sǝ hu ngwa kumarha.” ");
INSERT INTO hwo_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Amma ana yamid nggayid nǝm ndǝn na a kyad nggayid Faara a pǝpal, ma nǝm ndaarha? Nǝm a ndaarha na yamid nggayirha sǝ a fad Faara ka kyad nǝn sǝbrha hurghǝn aten nǝm wa? Niyi a kala sǝ ƙǝla na niifa ndikrha fa. ");
INSERT INTO hwo_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ko ngguchit! A naɗǝ kee, ƙǝƙǝn na Faara tsaurha tǝ ngwang kumarha ƙǝshiirha? ");
INSERT INTO hwo_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Na niifa ngaala tǝ ndaarha, “A tsau nggaɓad na nǝn kyad ƙǝkafekkid Faara a pǝpal chik mamnggit ghǝnǝn, Kama nda na nda nggǝr ngwe kumarha sǝ tǝ ndaarha tǝ ɗimirha ni nggi?” ");
INSERT INTO hwo_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kama mbuwa nǝm ndaarha, “Taama ǝna mbǝlfeerha nǝm tǝna ǝngya na ngga kyarha ɓa ahurghǝn?” Ƙǝla na fingya thlǝk ǝngya yi sǝb thlǝma na nda a ndaarha, mǝmǝl ni a ngwang kumarha nda kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yo, ma nǝm ndaarha mbiya? Ƙǝm na Yahudaya kal ɗǝm fingya fiya wa? A yanggi! Ko ngguchit! ˈWa ɗǝm teena thlǝk ɗǝm ndǝn tǝ ndaarha, Yahudaya tǝ fingya mbuwa Yahudaya heu na tǝ aibe fa, tǝ ƙǝm kanda heu na nda a kamu sǝsǝmnda ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ƙǝla nanǝn chichireethlee hai ahu Ɗeleewar Faara tǝ ndaarha, “Mbǝ niifa sǝ na tǝ nggayirha fa wa, ko tǝtal. ");
INSERT INTO hwo_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Mbǝ niifa sǝ na a sǝnang hai wa, mbǝ niifa sǝ ƙǝm na a kaɗa Faara wa. ");
INSERT INTO hwo_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kanda heu kang nda ƙǝsǝra Faara, kanda heu tsau nda nafiya kee mere. Mbǝ ka niifa sǝ wa ko tǝtal. ");
INSERT INTO hwo_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ka urad ndan nǝghǝn ƙǝla kwat mǝrra tsahai, tsau sheneu ndan yi hukrha. Laɓar ndan nǝghǝn ƙǝla yarhafǝd hulthne. ");
INSERT INTO hwo_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Yakh nda ˈyar farha, tǝ ndikrha iˈikh. ");
INSERT INTO hwo_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Yakh nda ɓǝl farha ka ka, ");
INSERT INTO hwo_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kala mbǝrha ndǝna nda saɗǝ ƙǝl sǝbrha hura tǝ sǝb ǝngya. ");
INSERT INTO hwo_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Sǝngwa nda kwaman ɗǝɗemnggirha wa. ");
INSERT INTO hwo_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Mba nda tǝrǝm Faara wa sam.” ");
INSERT INTO hwo_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nanǝnya sǝnɗǝm sǝ tǝ ndaarha kala ˈya ndaana ngyakhrha, nǝghǝn aten fingya na a kamu ngyakhrha, ǝnana ndan kee ka amawana fiya kala sǝ, tǝ ƙǝm ɓanggǝn ƙǝshiirha ɓa heu a kamu ngwa kumad Faara ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Tsaunǝn kee, mbǝ niifa sǝ na tsaurha kula ɗimiyirha a yid Faara ka nanǝn a ǝna ˈya ndaana ngyakhrha wa, ˈya na ngyakhrha a ǝnaarha a sǝnǝmsǝ tǝ ndaarha ǝnaɗǝm ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Amma nanǝnya, a malang ɗǝm ngyakhrha sǝnɗǝm nggayid Faara, ngyakhrha tǝ annabiya fǝr nda shedawa atenggǝn, ");
INSERT INTO hwo_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nggayid ɗi ki Faara ya, nǝm walghǝn hu fǝrƙǝkafek a Yeeso Ƙǝrǝsti tǝ fingya heu fǝrgha ƙǝkafek, mbǝ kyad ɗǝɗamǝmnggirha sǝ pathlang nda Yahudaya tǝ nafiya mbuwa Yahudaya wa. ");
INSERT INTO hwo_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ƙǝsǝr fiya heu ǝnanda ɗimiyirha, ƙǝɗinda ma kutǝryid Faara. ");
INSERT INTO hwo_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amma fǝrra nggayid Faara a fiya ka ni, kowunni walɗǝ tsaurha kula ɗimiyirha a mbed Faara hu pǝla ǝnana Ƙǝrǝsti Yeeso. ");
INSERT INTO hwo_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Fǝr Faara Yeeso a tsauka sataka hu tǝr hakked ɗimiyid nǝm, ƙǝsǝr hu irra far satakh ƙǝn ɗǝ na nda a chahang ɗimiyid ndan fiya ɗǝ hu fǝrƙǝkafekkid ndan. Ənana Faara kee ka a kyad nggayid ghǝnǝn, ka a lǝɗanggǝn ƙǝrǝssǝghǝn na a malanggǝn ɗimiyidɗi ˈwana nda ǝnaarha kaar. ");
INSERT INTO hwo_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ənanǝn kee ka a kyad nggayidghǝn nǝn hu ƙǝshiid weeriya, a kyad ndaarha nǝn nǝghǝn tǝ nggayirha fa tǝƙǝm hǝrghanggǝn fingya yini fǝrgha ƙǝkafek tǝ Yeeso. ");
INSERT INTO hwo_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ma nǝm a taala atenggǝn? Mbǝ ˈya sǝ wa. Kama ni nanǝm a taala? Ka kwaman laf ngyakhrha Musa wa? Awo, kǝl tǝ fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ƙǝsǝr fǝr ɗǝm ƙǝkafek tǝ ndaarha hu fǝrƙǝkafek ni ndǝna niifa tsaurha kula ɗimiyirha fa a mbed Faara, mbǝ tǝ takkwa ngyakhrha wa. ");
INSERT INTO hwo_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ndo Faara yi Yahudaya ni katen ndan kee wa? Mbǝ Faarani yi fingya ƙǝm mbuwa Yahudaya wa? Haˈi yi ndan Faara ni ƙǝm, ");
INSERT INTO hwo_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Tsaunǝn na Faara tal kee. Nǝn a tsawang nafiya ƙǝm thleewa muwa tsawa nda chahal a fadghǝn hu fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Tsaunǝn kee, kar nǝm ngyakhrha fa tǝ fǝrƙǝkafek wa? Mbu ǝnaarha hai kee wa, amma nǝm a ƙǝs ngyahadɗa ha. ");
INSERT INTO hwo_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yo, manǝm ndaarha aten, ndǝghǝn na Chichid nǝm hu thlu farha? Ma wal nǝn sǝ atenggǝn? ");
INSERT INTO hwo_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ana ƙǝkafek ni Ibrahim walɗǝ hǝrǝkrha hu ǝna taara, na ˈyasǝ wal nǝn na a ǝna taala nǝn sǝ, amma mbǝ a mbed Faara wa. ");
INSERT INTO hwo_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ma ndaana ɗeleewar Faara? “Fǝr Ibrahim kǝkafek a Faara, ƙǝsǝr ka kee nǝghǝn tǝ nggayirha fa a mbed Faara ");
INSERT INTO hwo_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nanǝnya a ǝna niifa taara, wuɗǝɓǝla na nda a teng nda mbǝ fǝra ni wa, amma yi ƙǝna targhǝn ni. ");
INSERT INTO hwo_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Amma na nafiya a naarha tǝ nggayirha fa, mbǝ ka taryinda wa, amma ƙǝsǝr ka fǝrƙǝkafekkid ndan tǝ Faara na chahang ɗimiyid ndan fiya ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ƙǝla ndaana Ndauda parkayid ɗi fǝrang nanda niifa ndangna Faara nǝghǝn tǝ nggayirha fa, mbǝ ka taara ǝnanǝn wa. ");
INSERT INTO hwo_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Fa parkaya ni nafini chahang nanda ɗimiyid ndan kanda ɗǝ, tǝƙǝm tsǝɓang nanda ɗimiyid ndan. ");
INSERT INTO hwo_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Tsau parka aten niifa mbuwana Chinǝm tam ɗal ɗimiyidghǝn in.” ");
INSERT INTO hwo_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Nanǝnya, na parkadɗi ya aten nafiya thleegha muwa kee nuwa? Nduwa heu tǝ fingyayini thleewa muwa wa? Kǝla nǝm a ndaarha ahu laɓar Faara na chichireethlee hai, “Thlǝ Faara Ibrahim fa ƙǝsǝr ka fǝrƙǝkafekkidghǝn.” ");
INSERT INTO hwo_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Aten mani ndang nanda kee? Ndang nanda kee akwasamadɗi thleng nanda muwa wa, nduwa kapa na nda thleng muwa wa? Mbǝ a kwasamadɗi thleng nanda muwa wa, amma kapa na nda thleng muwa. ");
INSERT INTO hwo_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Thlee muɗi ǝnanǝn ǝnsakhrha ni, tsauka nggayidghǝn ndǝghǝn kula thlee muwa. Nanǝn kee, tsauɗǝ china yi sǝsǝna a fingya heu fǝrgha ƙǝkafek ko thlee wanda muwa wa, na nda a tsaurha tǝ nggayirha fa ƙǝsǝr ka fǝrƙǝkafekkid ndan. ");
INSERT INTO hwo_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Tǝ Ibrahim ƙǝm chin fa thlee muya ni, mbǝ fa thlee muya kee wa, amma fingya takkwagha tur fǝrƙǝkafekkidghǝn kapa nǝn thlee muwa. ");
INSERT INTO hwo_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mbǝ hu ngyakhrha ɗǝfna Faara miighǝn nǝn a fǝrang langad ƙǝshiirha Ibrahim tǝ wanggighǝn wa, amma ƙǝsǝr ka nggayirha kyagha ɓa hu fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Andam ɗǝfmi Faara nǝghǝn aten nafiya na a takkwa ngyakhrha, kam fǝrƙǝkafek mbǝ hu ˈya wa na ɗǝfmiɗi ƙǝm a tsaurha mere. ");
INSERT INTO hwo_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ƙǝsǝr ngyakhrha nǝn ɓang sǝbrha hura ɓa, amma a mbǝrha mbuwana ngyakhrha sǝ mbǝ aibe naarha sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Tsaunǝn kee, ɗǝfmee mbǝrsaghǝn aten fǝrƙǝkafek. Tsauɗǝ hu nggayirha ni fǝrang nanda chichiya Ibrahim heu, mbǝ a fingya na a takkwa ngyakhrha wa amma a fingya na tǝ fǝrƙǝkafek tur yi Ibrahim. Ndǝghǝnni tsauka yinǝm chiina heu. ");
INSERT INTO hwo_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kǝla nanǝn chichireethlee hai, “Tsawo ɗi chin chehweeya hangga,” Ndǝghǝnni na yinǝm chiina a a mbed Faara fǝr nǝm ƙǝkafek tǝghǝn, Faara na fǝr yibrha a mǝrya, na aah ǝngya ɓa mbuwa sǝ na nda sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Fǝr Ibrahim ƙǝkafek aten shiteena, ko nanǝn mbǝ ˈyasǝ kamngga na a shiteena nǝn wa, na a tsauka chin chehweeya hangga, ƙǝla ndaana ɗeleewar Faara, “Na chichiyi wa a tsaurha hangga ƙǝla wufǝlngaarya.” ");
INSERT INTO hwo_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","A hu sayidɗi sǝl hurad Ibrahim haru, amma mbid wa fǝrƙǝkafekkidghǝn ɗǝwa nanǝn fadghǝn suhur ɗǝ takhɗǝ a mǝra, Saratu ƙǝmɗa mbǝrang ɗǝ hurad nggǝttǝghǝn hai. ");
INSERT INTO hwo_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Malwa fǝrƙǝkafekkidghǝn ndǝn wa, Wulang ngwa teena tǝ ɗǝfmi Faara wa, Fǝrƙǝkafekkidghǝn lǝɗang ɗǝ tǝ sǝsǝmnda, nagha a fal Faara. ");
INSERT INTO hwo_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Fǝrɗǝ ƙǝkafek tǝ ndaarha na Faara tǝ sǝsǝmnda na a ǝna ǝnɗanǝn ɗǝf nǝn miighǝn kamanggǝn. ");
INSERT INTO hwo_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndǝghǝn ɗa ǝnagha ndǝn, “Kirasang nanda, Nǝghǝn tǝ nggayirha fa.” ");
INSERT INTO hwo_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ndadɗi “Kirasang nda nǝghǝn tǝ nggayirha fa” chireethleng ngwanda hai ka ndǝghǝn katenggǝn wa, ");
INSERT INTO hwo_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","amma ka ƙǝm ni, na Faara a kirasang nggayirha, ƙǝm fǝrgha ƙǝkafek a ndǝghǝn thlengga Yeeso Chinǝm sǝ hu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Fǝr na ndan a mǝrgha ka ɗimiyid nǝm. Thleng nda sǝ tǝ yibrha ƙǝsǝr ka a tsawum kula ɗimiyirha a mbed Faara. ");
INSERT INTO hwo_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tsaunǝn kee, tsau nǝm kula ɗimiyirha fa a mbed Faara hu fǝrƙǝkafek, nǝm a tsau ɗǝɗemnggirha tǝ Faara hu chinǝm Yeeso Ƙǝrǝsti, ");
INSERT INTO hwo_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","A hurghǝn ni wal nǝm kwaman fǝrƙǝkafek ahu nggayid ɗaɗǝ ish nǝm sǝ nanǝnya. Nanǝn kee, nǝghǝm a taala hu shiteena yi mamnggit Faara. ");
INSERT INTO hwo_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Mbǝ kee mawa, nǝghǝm a ǝna wutsǝfayirha hu sǝsad nǝm, ƙǝsǝr sǝnɗǝmsǝ na sǝsaarha ɓang ƙǝrǝsta ɓa, ");
INSERT INTO hwo_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ƙǝrǝsta nǝn ɓang hakkilo ɓa na ngga, hakkilo na ngga ƙǝm nǝn ɓang shiteena ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Mbǝ shiteena kyang ƙǝm hu shilee hai wa, ƙǝsǝr nggǝmnda Faara irang ɗa ndǝn ƙǝm hur nǝm hai hu Sǝsǝna tǝ Peɗǝnda, fǝrang nanda ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","A hu mǝmǝlla sayi, ƙǝm ɓalɗǝ kula naarha tǝ sǝsǝmnda fa, mǝrgha Ƙǝrǝsti ka fa ɗimiya. ");
INSERT INTO hwo_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ˈYani na pǝɗaghǝn na a mǝrgha niifa ƙǝsǝr ka niifa natǝ nggayirha fa. Ko nanǝn asǝmha na niifa sǝ na mbang ndeng yidghǝn a mǝrgha ka mǝsǝlǝmnda niifa. ");
INSERT INTO hwo_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amma kyaɗang Faara nggǝmndǝghǝn ƙǝm tǝ ndaarha, ƙǝm ɓalɗǝ fa ɗimiya, mǝrgha Ƙǝrǝsti ka ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Tsaunǝn wal ɗǝm tsawud nafiya mbuwa tǝ ɗimiyirha fa a mbed Faara ka irra far Ƙǝrǝsti ɗǝ, sakwata nanǝnya, na nda a hǝrghang ƙǝm ka ndǝghǝn hu sǝbrha hur Faara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","A naɗǝ, a sayidɗa ni nanǝm a ǝna tǝsaryirha tǝ Faara ndǝn tangsang nanda pathlang nǝm tǝ Faara hu mǝrra Wanggǝn, sakwata nanǝnya ˈwanda teena tangsang nda pathlang nǝm tǝ Faara, nǝm a wal hǝrǝkrha ka tsawud Wanggǝn. ");
INSERT INTO hwo_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Mbǝ ka yanɗi kee ya wa, amma ƙǝm nǝm ǝna wutsǝfayirha tǝ Faara, hu Chinǝm Yeeso Ƙǝrǝsti, ƙǝsǝr ndǝghǝn ni taksangga pathlang nǝm tǝ Faara. ");
INSERT INTO hwo_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Tsaunǝn kee, ƙǝla kyana ɗimiyirha hu ƙǝshiirha ɓa tǝ fad niifa tal, ɗimiyidɗi ya ndǝn ɓangga mǝrra ɓa. Nanǝn kee, tsau mǝrra aten kowunni hu ƙǝshiirha, ƙǝsǝr kowunni ǝnaɗǝ ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ƙǝsǝr kapa na nda fǝr ngyakhrha, na ɗimirha sǝ hu ƙǝshiirha, amma mbǝ kirasang nda ɗimiyirha sǝ aten kowunni a mbǝ ngyakhrha sǝ wa. ");
INSERT INTO hwo_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Heu tǝkee ka a sayid Adamu ɗǝgha hu sayid Musa ɗǝ, ǝna mǝrra kutǝryirha aten fiya heu, ko aten fingya ǝnawa ɗimiyirha ƙǝla ǝnana Adamu kar nǝn mii Faara fa. Na Adamu ƙǝla Ƙǝrǝsti ɓalgha kula ɓarhaɓa. ");
INSERT INTO hwo_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Amma mbǝ fǝrrǝɗi tal ya wa, aten ɗimiyid Adamu tǝ nggayid fǝrra Faara. Ƙǝsǝr ƙǝkafek ni mǝr fiya ɗǝ hangga ka ɗimiyid niifɗi tal taarha. Amma mul nggayid Faara hai, nanǝn kee fǝrrǝghǝn ni ka a fiya hangga hu nggayid niifɗi tal ya, Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Fǝrra nggayid Faara mbǝm ƙǝƙǝrang nda tǝ ˈya na ɗimiyid niifa tal ɓang nda ɓa wa. Ngwa kumad Faara takkwaghǝn ɗimiyirha tal ɓangga mǝra ɓa, amma fǝrrǝɗi takkwaghǝn aibeya hangga tsangga fiya kula ɗimiyirha fa. ");
INSERT INTO hwo_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ƙǝsǝr anaɗǝ ka aibed niifa tal, ǝnana mǝrra kutǝryirha aten kowun ka niifɗi talya, tsauɗǝ fingya walgha nggayid Faara hangga tǝ fǝrrǝghǝn ka yi nggayirha na nda a ǝna kutǝryirha tǝghǝn hu tsawud ndan tǝ niifɗi tal na Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Tsaunǝn kee, ka aibed niifa tal ɓang ɗǝ mǝrra ten fiya ɓa heu, nǝghǝn kee ƙǝm ƙǝsǝr ka tar nggayid niifa tal ndǝn tsawangga ƙǝm nafiya mbuwa tǝ ɗimiyirha fa a mbed Faara, ɓangga kal farha ɓa hu tsawud fiya heu. ");
INSERT INTO hwo_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ƙǝsǝr ƙǝla nanǝn ka yamid fǝr mamnggid niifa tal ndǝn tsangga fiya hangga tǝ ɗimiyirha, nǝghǝn kee ƙǝm ƙǝsǝr ka fǝr mamnggid niifa ta nafiya hangga na nda a tsaurha tǝ nggayirha fa. ");
INSERT INTO hwo_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Fǝr nanda ngyakhrha tǝna aibe chikrha. Amma a chik ɗimiyirha, na nggayirha a chikrha kaan, ");
INSERT INTO hwo_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nanǝn kee ƙǝla ǝnana ɗimiyirha kutǝryirha tǝ mǝrra, nǝghǝn kee ƙǝm na nggayirha a ǝna kutǝryirha hu nggayidghǝn na a ɓanggǝn yibrha ɓa mbuwa ngwalarha hu Yeeso Ƙǝrǝsti na Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Manǝm ndarha mbiya? A ɗǝm mbeeɗǝ tǝ ǝna ɗimiyirha tǝna nggayirha mula hai wa? ");
INSERT INTO hwo_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Sam, mbǝ tam ǝnarha hai wa, ƙǝm mǝrgha ka ɗimiyirha, ƙǝƙǝn nǝm nggǝr tsaurha ahurghǝn? ");
INSERT INTO hwo_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nduwa sǝnggun sǝ wa, ƙǝm heu ǝnang nanda mbaptisǝma ƙǝm tǝ Ƙǝrǝsti Yeeso, ǝnang nanda mbaptisǝma ƙǝm hu mǝrrǝghǝn ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Pangganda ƙǝm tǝghǝn hu mbaptisǝma pang ngganda ƙǝm tǝghǝn, tsauɗǝm tal tǝghǝn, nǝghǝm tal ƙǝm hu mǝrrǝghǝn, ƙǝsǝr ƙǝla thleng nanda Ƙǝrǝsti sǝ hu mǝrra tǝ mamnggit Chinɗi, nǝghǝm kee ƙǝm na tsawum hu weerinda tsaurha. ");
INSERT INTO hwo_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Tsaunǝn nǝghǝm tal tǝghǝn ahu mǝrrǝghǝn, nǝm a thliirha sǝ ƙǝm hu yibrha ɗǝ ƙǝla ǝnanǝn. ");
INSERT INTO hwo_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Sǝnɗǝmsǝ suhurra fad nǝm tawang nda ɗǝ tǝghǝn aten kaɗiirha, amawana ɗimiyirha wal sǝsǝmnda aten nǝm, amawa nǝm tsaurha mafad ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ƙǝsǝr kala niifa mǝrgha hǝrǝk ɗǝ ma ɗimirha. ");
INSERT INTO hwo_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nanǝnya a mǝr ɗǝm tǝ Ƙǝrǝsti, fǝr ɗǝm ƙǝkafek tǝ ndaarha nǝm a tsaurha tǝghǝn ");
INSERT INTO hwo_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Sǝnɗǝmsǝ hǝrǝmna Ƙǝrǝsti thliirha sǝ hu mǝrra, mbǝ a nggǝr mǝra ɓalwa, ɓalwa sǝsǝmnda mǝrra sǝ a tenggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Mǝrɗi mǝr nǝn, mǝrghǝn katǝra tal, hwasanggǝn sǝsǝmnda mǝrra, amma nanǝnya nanǝn tǝ yibrha fa, tsauƙǝn tǝ mamnggit Faara. ");
INSERT INTO hwo_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nanǝn kee, kun kǝm tsawaman fad nun nuwun mǝmǝra hu sǝsǝmnda ɗimiyirha, amma nuwun tǝ yibrha fa hu tsawud ɗǝɗemnggirha tǝ Faara hu Yeeso Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Tsaunǝn kee, a malangɗun ɗimiyirha ǝna kutǝryirha nǝn tǝ thlu fadɗi kyanun na mǝra ya wa, non a takkwa ǝn mbǝlfedɗi na midghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","A fǝrɗun kala mbǝd njid fannun ka ǝn tar mbǝlfeerha nun yi ɗimiyirha wa. A meyedghǝn, fǝraman fad nun Faara heu, ƙǝsǝr mǝr ɗun, amma nanǝnya nuwun tǝ weerinda yibrha. Nanǝn kee, ǝnama taara kamngga tǝ fad nun heu ka mamnggit Faara. ");
INSERT INTO hwo_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ƙǝsǝr mbǝ ɗimiyirha nggǝr tsaurha turi nun wa, ƙǝsǝr mbun a kamu ngyakhrha wa, amma a kamu nggayid Faara. ");
INSERT INTO hwo_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Manǝm ndaarha? Nǝm a ǝna ɗimiyirha ƙǝsǝr mbǝm a kamu ngyakhrha wa amma a kamu nggayirha? Sam, mbǝ tam ǝnaarha hai wa. ");
INSERT INTO hwo_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Sǝnggun sǝ tǝ ndaarha a fǝr ɗun fad nun a kala niifa non a fǝrang mamnggirha ƙǝla mafarha wa? Tsau ɗun mafad niifɗi nun a fǝrang mamnggirha, ko mafad ɗimiyirha ni kun, na a ɗǝrha tǝ kun hu mǝrra ɗǝ, nduwa fǝr mamnggirha a Faara na a ɗang kun hu nggayirha ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Usa ɗǝm Faara. Kaar tsau ɗun mafaya a ɗimiyirha, amma nanǝnya tǝ hura tal thlǝɗun ǝnɗi tsahang nanda kun ha. ");
INSERT INTO hwo_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nanǝnya hǝrghang nda kun sǝ hu tsawud mafayid nuna hu ɗimiyirha, tsauɗun mafaya yi nggayirha. ");
INSERT INTO hwo_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Niyi a kalang kun sǝ ƙǝla na niifa kaala sǝ, ƙǝsǝr sǝnɗisǝ ƙǝɗi ɗun hu thlufarha. Ƙǝsǝr ƙǝla ˈwanun fǝr fad nun ƙǝla mafaya a ǝn tsanda nǝm a naarha, tǝ ƙǝm non a chik ɗǝrha mbeeɗǝ tǝ ǝna tar mbǝlfeerha, nǝghǝn kee ƙǝm nanǝnya ƙǝl a fǝr fad nun nǝn tsawun mafaya a nggayirha, ka a tsawun nafiya na wuwura chahal yi Faara. ");
INSERT INTO hwo_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","A sayidɗi tsau nun mafaya a ɗimiyirha, mbǝ ˈyasǝ njiɗangga kun tǝ nggayirha wa. ");
INSERT INTO hwo_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ma wal nun sǝ tǝ ǝnggini ǝna nun farɗi ƙǝsna shilee kun nanǝnya? Mii ngwala ǝnggini heu ya mǝrra ni. ");
INSERT INTO hwo_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Amma nanǝn hǝrghang nda kun hu tar ɗimiyirha tsauɗun mafaya Faara, nun a tsaurha chahal tǝ yibrha mbuwa ngwalarha. ");
INSERT INTO hwo_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ƙǝsǝr ƙǝna ɗimiyirha mǝrra ni, amma fǝrra Faara ndǝna yibrha mbuwa ngwalarha hu Ƙǝrǝsti Yeeso Chinǝm. ");
INSERT INTO hwo_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Shayina, sǝnɗunsǝ ngga, ƙǝsǝr niyi a ndikrha tǝ nafiya sǝngga ngyakhrha tǝ ndaarha ngyakhrha nǝn naarha tǝ sǝsǝmnda fa aten niifa ɓalgha hai tǝ yibrha. ");
INSERT INTO hwo_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Hu sakrha ndagha ngyakhrha, nuneefa kakhka nǝghǝn a kamu ngyakhrha chimadghǝn a ɓal ɗa hai tǝ yibrha, amma a mǝr chimadghǝn ɓalwa ngyakhrha kakhrha sǝ atenggǝn wa. ");
INSERT INTO hwo_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nanǝn kee, a ɓal chimadghǝn hai, a kakh ɗǝ niifa pak ǝnaɗǝ kulafayirha. Amma a mǝr chimadghǝn ɓalwa a kamu ngyakhrha kakhrha wa, tǝ ƙǝm ǝnawa kulafayirha a kakh ɗǝ niifa pak wa. ");
INSERT INTO hwo_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nanǝn kee, shayina, kun ƙǝm mǝr ɗun hu ngyakhrha ahu fad Ƙǝrǝsti. Tsauɗun yi yanɗi thleng nanda sǝ hu mǝrra, tǝnun tsaurhahu kwamana na ngga na a mbǝnanggǝn Faara. ");
INSERT INTO hwo_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ƙǝsǝr a sayidɗi nanǝm ahu thlufarha, na ngyahadɗi naarha shik sunad ɗimiyid nǝm, nǝn ǝna taara hu thlu fad nǝm, tar nǝm heu nǝn ɓang mǝrra ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma nanǝnya hǝrghang nda ƙǝmsǝ hu ngyahadɗi, ƙǝsǝr mǝr ɗǝm ka ndǝghǝn ɓalwa sǝsǝmndǝghǝn a ǝna taara aten nǝm wa. Nanǝnya nǝm a ǝnang taara Faara hu weerinda kwamana hu Sǝsǝna tǝ peɗǝnda, mbǝ ahu hurad chirethla ngyakhrha wa. ");
INSERT INTO hwo_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Manǝm ndaarha mbiya? Ngyakhrha tafadghǝn ɗimiyirha ni wa? Awo, ko ngguchit. Ƙǝsǝr ngyakhrha ni ǝnagha ndǝn sǝnni ɗimiyirha. A ndawa ngyakhrha, “A sunad na ǝn niifa wa,” kam sǝngwi ǝnɗi na nda ndaarha suna wa. ");
INSERT INTO hwo_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Amma tǝ ngyahadɗa ni, ndǝn wal na ɗimiyirha kwamana shik nǝn kala tur yanggi suna alteena na ahur na. Ƙǝsǝr a mbǝ tǝ ngyahadɗi wa, kam na ɗimiyirha mǝmǝra. ");
INSERT INTO hwo_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Tamnggi tǝ yibrha fa a sayidɗi sǝngwani ngyakhrha, amma ɓana ngyakhrha ɓa, thliigha ɗimiyirha sǝ tǝ yibrha, tǝrgha nggi mǝri. ");
INSERT INTO hwo_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Walang ɗi tǝ ndaarha ngyahadɗi kwang ndǝn kamngga ɓagha ɓa tǝ yibrha, a meyedghǝn ɓagha ɓa tǝ mǝrra. ");
INSERT INTO hwo_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Wal ɗimiyirha kwamana hu ngyahadɗi, hukɗǝ nggi ƙǝse mǝra nǝn fa. ");
INSERT INTO hwo_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nanǝn kee, na ngyahadɗi chahal, ǝngya ndanǝn nǝghǝn chahal, tǝ nggayirha fa tǝƙǝm nǝghǝn ngga. ");
INSERT INTO hwo_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Amma ˈya na ngga ndǝna ƙǝse mǝra fa wa? Awo ko ngguchit. Əna ɗimiyirha taara tǝ ˈya na ngga ƙǝse mǝra nǝn fa, ka a kyad ndirwid ghǝnǝn yi ɗimiyirha a pǝpal. Ənagha ɗimiyirha taara tǝ ngyakhrha Faara na ngga ka lǝɗanggǝn ǝn mbǝlfedghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Sǝnɗǝmsǝ ngyakhrha yi sǝsǝna ni, amma nggi mbiyi chahal wa. Henda ɗǝ ƙǝla mafarha a ɗimiyirha. ");
INSERT INTO hwo_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sǝnangwi ǝnɗa hai ǝna ni wa. Ƙǝsǝr ǝnɗi na minna a ǝne ǝnawi ndǝn wa, amma ǝnɗi kar ni ndǝn niya ǝnarha. ");
INSERT INTO hwo_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Amma a ǝnaɗi ǝnɗi mbuwana minna a ǝne, nggǝmɗi fa tǝ ndaarha na ngyahadɗi ngga. ");
INSERT INTO hwo_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ƙǝla nanǝn, mbǝ nggini tafanna a nggǝr ǝnaghǝn wa, amma ɗimiyid ɗani na ahur na a ǝnaghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ƙǝsǝr sǝnɗisǝ tǝ ndaarha mbǝ ˈyasǝ ngga tsauka ahur na wa, hu ɗimiyid na yi thlufarha. Ƙǝsǝr tǝr minna sǝ na a ǝna ˈyani na ngga kwang, amma mbi mbang ǝnaghǝn wa. ");
INSERT INTO hwo_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ƙǝsǝr mbiyi a ǝna ǝnggini na ngga na minnasǝ wa, amma mbǝlfeerha ndǝn ni ǝnaarha ƙǝtsar. ");
INSERT INTO hwo_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nanǝnya a ǝnaɗi ǝnɗi mbuwana minna a ǝne, mbǝ nggini tafadna a ǝnaghǝn wa, amma ɗimiyirha ni natǝ tsaurha ahur na, na a ǝnaghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nanǝn kee walang ɗi tǝ ndaarha na ngyahadɗi a ǝna taara. Ana minna sǝ ǝna ˈya ni na ngga, na mbǝlfedɗi narha tsau tǝ nggi fa. ");
INSERT INTO hwo_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nggi ahur na sǝ na minnasǝ ngyahad Faara kaan ");
INSERT INTO hwo_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Amma naɗi ngyakhrha pak a ǝna taara ahur na. Ngyakhrha a yanda tǝ ngyahadɗi na a hutenna. Tsaweɗǝ hu porsǝna yi ngyahad ɗimiyirha na a ǝna taara ahur na. ");
INSERT INTO hwo_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Tsauɗi ǝn kawa. Wunni hǝrye ahu fadɗi na a mǝra ya? ");
INSERT INTO hwo_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ƙǝl usaarha a Faara, hǝryegha hu Yeeso Ƙǝrǝsti Chinǝm. Nanǝn kee, nggi tafadna hu hutenna mafad ngyakhrha Faara ni nggi, amma ahu thlu fadna yi ɗimiyirha mafad ngyakhrha ɗimiyirha ni nggi. ");
INSERT INTO hwo_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nanǝn kee, mbǝ ngwa kumarha sǝ aten fingya na yi Ƙǝrǝsti Yeeso wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ƙǝsǝr hu Ƙǝrǝsti Yeeso ngyahad Sǝsǝnɗi na fǝr yibrha hǝrwo ɗǝ hu ngyahad ɗimiyirha tǝ mǝra. ");
INSERT INTO hwo_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ƙǝsǝr ˈya mbuwana ngyakhrha mbang ǝnaarha ƙǝsǝr ka ƙǝɗiina thlu farha, Faara ǝna ɗa ndǝn. Thlǝn Faara Wanggǝn ɓa katenggǝn na ƙǝla thlu fad nǝm yi ɗimiyirha ka a tsauka satakh ɗimiyirha, tǝ ƙǝm walenggǝn sǝsǝmnda ɗimiyirha ɗǝ na hu thlu farha. ");
INSERT INTO hwo_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Əna na Faara kee ƙǝsǝr kala ˈya ndana ngyakhrha a ǝnam tǝnǝn lǝghǝtta a tennǝm, ƙǝm mbuwana tsawud nǝm yi thlu farha, amma yi Sǝsǝna. ");
INSERT INTO hwo_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Fingya na a tsaurha hu yi thlu farha na hakkilon ndan naarha aten ˈya na mid thlufarha, amma fingya tsauka yi Sǝsǝna na hakkilon ndan naarha aten ˈya na mid Sǝsǝna kee. ");
INSERT INTO hwo_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ana hakkilo aten thlu farha nǝn ɓang mǝrra ɓa, amma ana hakkilo aten Sǝsǝna nǝn ɓang yibrha ɓa tǝ tsawud ɗǝɗemnggirha. ");
INSERT INTO hwo_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Hakkilo na thlufarha a ǝna taara tǝghǝn tsauɗǝ nǝghǝn a yanda tǝ Faara, fǝrwa altenggǝn tǝ tsahad ngyakhrha Faara wa, tǝƙǝm mbǝ mbang wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ndǝn ǝnagha ndǝn fingya ɓalgha a kamu ɗimiyid thlufarha mba nda tam ǝna ˈya na a mbǝnanggǝn Faara wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kun kam mbǝ tsawud thlufarha nanun sǝ wa, amma yi Sǝsǝna, ana ƙǝkafek ni na Sǝsǝn Faara tsau ahur nun. Ana niifasǝ mbuwa tǝ Sǝsǝn Ƙǝrǝsti, mbǝ yi Ƙǝrǝsti ni kanda wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Amma ana Ƙǝrǝsti ahur nun, ko nanǝn na fannun a mǝra ƙǝsǝr ka ɗimiyirha, na Sǝsǝnɗi fǝr yibrha ƙǝsǝr ka nggayirha. ");
INSERT INTO hwo_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ana Sǝsǝn Faara thlengga Ƙǝrǝsti sǝ hu mǝrra ahur nun, ndǝghǝnggi thlengga Ƙǝrǝsti sǝ hu mǝrra nǝn a fǝrang yibrha fannun na mǝmǝra ƙǝsǝr ka Sǝsǝnggǝn na ahur nun. ");
INSERT INTO hwo_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nanǝnke, shayina na taara sǝ a har nǝm, amma mbǝ ka a tsawum ƙǝla na mid thlu fannun wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ƙǝsǝr ana tsawud thlu farha nanun sǝ, nun a mǝra, amma a naɗun hu tsawud sǝsǝn ɗi tǝƙǝm ɓǝlanggun tar ɗimiyid nun, nun a wal yibrha. ");
INSERT INTO hwo_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ƙǝsǝr fingya na Sǝsǝn Faara a naarha tǝ kanda, wangya Faara ni. ");
INSERT INTO hwo_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Sǝsǝn ɗi thlǝnun mbǝ tsang kun mafaya wa, tǝnun tsaurha tǝ hǝrenga fa fadɗǝn wa, amma Sǝsǝn ɗi thlǝnun tsang ɗǝ kun wanggighǝn. Nanǝnya nǝm aaghǝn “Abba, Pǝppa.” ");
INSERT INTO hwo_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Sǝsǝn ɗi tafadghǝn nǝghǝn a fǝr shedawa heu tǝ yinǝm sǝsǝna tǝ ndaarha wangya Faara ni ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Tsaunǝn ƙǝm wanggighǝn ni, tsau ɗǝm fa har langaayighǝn. Ƙǝkafek, ƙǝm heu tǝ Ƙǝrǝsti tsau ɗǝm fa har langaaya mamnggit Faara. A naɗǝm a wum teena hu mamnggidghǝn, nǝm a wumteena ƙǝm hu sǝsadghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Niyi a naghǝn, sǝsaarha nǝm a saarha fa nanǝnya, mbǝm ƙǝƙǝrang tǝ mamnggidɗi na nda a kyaɗang ƙǝm a mbee wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ƙǝkafek, ǝngya heu ǝnana Faara kukwasang kanda fa na a ɓagha farɗa ɓa na Faara a kyad tǝ mingya ni ka wangya. ");
INSERT INTO hwo_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ƙǝsǝr ǝngya ǝnana Faara wulang teena kanda na a sǝn ǝnɗa nda na mindan, mbǝ tǝ nggǝmnda hurghǝn wa. Faara ndǝn tǝrna midghǝn a nagha sǝ kee hu shiteena ");
INSERT INTO hwo_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","tǝ ndaarha, ǝngya ǝnanǝn a wal hǝrǝkrha nda hu tar mafayirha yi mǝthla hai, na a wal mamnggid wal alteena nda yi wangya Faara. ");
INSERT INTO hwo_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ƙǝsǝr sǝnɗǝmsǝ ta weeri ɗa ɓa ya ǝngya ǝnana Faara heu na nda chichim hatta farha fa, ƙǝla hatta nggǝtta. ");
INSERT INTO hwo_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mbǝ ǝngya ǝnana Faara kee ndǝna chichimnda wa, amma heu tǝ ƙǝm na tǝ Sǝsǝna fa tsauka katǝra fǝrra Faara, nǝm chichimnda ƙǝm, nanǝm a ƙǝla Faara fa tsawanggǝn ƙǝm wanggighǝn, tǝƙǝm hǝrghanggǝn pofad nǝm. ");
INSERT INTO hwo_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ƙǝsǝr hu shiiten ɗani ya walnǝm hǝrǝkrha. Amma a naɗǝm ǝnɗi nǝm a shiteena kamanggǝn, ɓalwa shiteena ni wa. Wunni nggǝr shang teena ǝnɗi ˈwanǝn waala? ");
INSERT INTO hwo_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Amma a naɗǝm a shang teena ǝnɗi nawa nǝm, nǝm ƙǝrǝsta ƙǝlaghǝnǝm fa. ");
INSERT INTO hwo_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Na Sǝsǝna kee ƙǝm, nǝn ɗang ƙǝmsǝ ahu ƙǝɗin nǝm. Ƙǝsǝr sǝnggum ˈya nǝm hwanang Faara atenggǝn wa, amma sǝsǝn ɗi tafadghǝn a meyed nǝm nǝn hwanang ƙǝmsǝ tǝ huhurumngya tǝ laɓarya mbuwa nǝm mbang pǝra. ");
INSERT INTO hwo_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Faara sǝngga ˈya na ahur nǝm sǝnɗǝ numad Sǝsǝna, ƙǝsǝr na Sǝsǝna a hwan Faara a meyed nafiya na chahal aten ˈya na mid Faara. ");
INSERT INTO hwo_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Sǝnɗǝmsǝ tǝ ndaarha hu ǝngya heu na Faara ǝna taara ngga ka fingyayini nggǝmngga ndǝn, aah nanda kan a ǝna ˈya nda na midghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ƙǝsǝr fingyayini ˈwana Faara sǝnda ka ƙǝtǝm, tsawang ɗǝ kanda a na nda ƙǝla wanggǝn, tǝna Wanɗi tsaurha wan ˈwarha ahur wan manggighǝn. ");
INSERT INTO hwo_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Fingyayini wurna Faara, kanda ni ƙǝm aah nǝn, fingyayini aah nǝn, ndǝn tsawang nǝn kanda ƙǝm nafiya na chahal a mbedghǝn, fingyayini tsawang nǝn kanda nafiya na chahal a mbedghǝn, kanda ni ƙǝm manang nǝn. ");
INSERT INTO hwo_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ma nǝm ndaarha aten ǝnggini ya? Ana Faara tǝ ƙǝm wunni mbang ǝna tǝsaryirha tǝ ƙǝm? ");
INSERT INTO hwo_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ˈYaɗawa Faara Wanggǝn wa, amma fǝrɗa ndǝn ka ƙǝm heu, mbǝ fǝrang ǝngya ƙǝm heu tǝ haara tsahai wa? ");
INSERT INTO hwo_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Wunni mbang huhwa nafini wurna Faara? Faara tafadghǝn ndagha mba nda tǝ aibe fa wa. ");
INSERT INTO hwo_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Wunni tsǝkka na a ndagha na niifasǝ tǝ aibe fa? Mbǝ Ƙǝrǝsti Yeeso ni, mǝrgha, thleng nanda sǝ hu mǝra tǝ yibrha, na tǝ tsaurha a yisǝmad Faara, ndǝghǝn ni na a hwan Faara ka ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Wunni tsaghang ƙǝmhai tǝ nggǝmnda Ƙǝrǝsti? Sǝsaarha, nduwa ɓillarha, nduwa miirha, nduwa yamirha, nduwa kakyathlaanga, nduwa mǝrra? ");
INSERT INTO hwo_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kǝla nanǝn chichireethlee hai, tǝ “Ƙǝsǝr ka sa ni kyanǝm hu mǝrra hai ƙǝtsar, tǝrgha nda ƙǝm ƙǝla chaukhrarha na nda thleng uradghǝn,” ");
INSERT INTO hwo_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Awo, ahu ǝnggini heu ya kal ɗǝm ndaarha nafiya ni walgha hǝbrha kee, yanɗiya nǝghǝn ahu niifɗi nggǝmngga ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Sǝnɗisǝ mbǝ ˈyasǝ na ndǝghang ƙǝmhai tǝ nggǝmndǝghǝn wa, ko mǝrra ni ko yibrha, ko fa thlǝngya Faara, ko ǝnkaheeya, ko nanǝnya, ko a far ɓinda, ko sǝsǝmngya ɗǝɗamǝn ɗǝɗamǝn na a talara, ");
INSERT INTO hwo_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ko nzang, ko kuɗimnggǝn, ko ngguchit hu ˈya ǝnana nda, tsǝkka na mbang tsahang ƙǝmhai tǝ nggǝmnda Faara hu Ƙǝrǝsti Yeeso Chinǝm wa. ");
INSERT INTO hwo_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ƙǝkafek niya thlǝkrha mbǝ niya nggaɓaarha wa, hutenna, hu Sǝsǝna tǝ Peɗǝnda, nǝn fǝr shedawa, ");
INSERT INTO hwo_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","tǝ ndaarha thlee hurna kaan, tǝƙǝm niyi tǝ sǝbrha hura ƙǝtsar. ");
INSERT INTO hwo_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","A ndam kwang shiwed nda, ndǝyenda hai tǝ Ƙǝrǝsti ƙǝsǝr nafina, kanda na turyina, ");
INSERT INTO hwo_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","nafiya Isǝreela. Kanda ni tsawang nǝn kanda wanggighǝn, kyaɗang mamnggitghǝn nǝn kanda, ɗǝfmee nǝn tǝ tǝ kanda fǝrang ngyakhrha nǝn kanda, fǝrang ɗǝ kwaman tǝrang shilee teena yi ƙǝkafek, tǝ ƙǝm thlǝ ɗǝfmi ghǝn nda. ");
INSERT INTO hwo_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Kanda na chichi yindan, Ibrahim, tǝ Ishaku tǝ Yakubu. Yeeso tafadghǝn nanǝn hu thlu farha turya Isǝreela ni. Niya hwan Faara, na a ǝna kutǝryirha heu, a fal thlǝm nggǝnǝm pakwanɗǝ. A tsaukwa kee. ");
INSERT INTO hwo_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mbǝ ƙǝɗiina laɓar Faara wa. Mbǝ fiya heu na turya Isǝreela na Isǝreelaya wa. ");
INSERT INTO hwo_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Mbǝ turya Ibrahim ni heu wangya Ibrahim wa. Amma a meyedghǝn ƙǝla ndaana ɗeleewar Faara, “Tǝ Ishaku ndǝna nda a kirasang nda tur yiwa.” ");
INSERT INTO hwo_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nǝm mbang ndaarha, mbǝ tsaurha turya Ibrahim, ndǝna ɓang tsaurha ɓa wangya Faara wa, amma ƙǝl wangya ɗǝfmee ndǝna nda kirasang kanda hu turya Ibrahim. ");
INSERT INTO hwo_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kulo ǝnɗi ndaana ɗǝfmi Faara ya, “A mǝmǝlla sayi niya wutta ɓa, na Saratu a nggǝt wee hǝshin.” ");
INSERT INTO hwo_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Wanɗiya chichid nǝm ni na Ishaku. A sayidɗi kahang nǝn Rǝfkatu nggǝdɗǝ muɗaya. ");
INSERT INTO hwo_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Kapa na nda nggǝt muɗayini nduwa kapa na nda ǝna ˈya ngga nduwa mbuwa ngga tǝna wurra Faara tsaurha ƙǝla tǝrna midghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Mbǝ tǝ taara wa amma tǝghǝn aah nǝn fiya, pǝrang ndan tǝ ndarha, “Na tǝpamǝnda a ǝnang taara tǝfeewunda.” ");
INSERT INTO hwo_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kǝla nanǝn chichirethlee hai, “Nggǝmɗi Yakubu, karɗi Isuwa fa.” ");
INSERT INTO hwo_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Yo, manǝm ndaarha? Əna Faara yamid nggayirha wa? Awo ko ngguchit! ");
INSERT INTO hwo_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ƙǝsǝr ndangga Faara Musa, “Kala niifa wurni na a haɗang nggi fa, ndǝna a haɗee fa, tǝƙǝm kala niifa wurni na a haɗeeghǝn fa ndǝnǝn a haɗee fa.” ");
INSERT INTO hwo_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nanǝn kee mbǝ aten ǝnɗi na mid niifa nduwa shembedghǝn wa, amma ka haɗang na Faara fa. ");
INSERT INTO hwo_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ƙǝsǝr ndangga ɗeleewar Faara Firˈauna, “Tsawo ni kutǝra tǝni kyad sǝsǝmndǝna ni a fadwa, tǝƙǝm a pǝr thlǝmna nda a Ƙǝshiirha kahad.” ");
INSERT INTO hwo_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Tsaunǝn kee, na Faara haɗang niifa fa nggǝmna hurghǝn, tǝƙǝm tsanggǝn hur niifa kakrak tǝrna midghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Na mbang ndeerha, “Mani ɓalna Faara a naa ƙǝm tǝ aibe fa? Wunni kar ǝnɗa fa na mid Faara?” ");
INSERT INTO hwo_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Amma wunni sa niifa tǝ wasa in, na mbang ngaala tǝ Faara? ˈYa tǝn nanda nǝn ndang nda niifɗi tǝngga ndǝn, “Kama nda tǝnna nggi kiya?” ");
INSERT INTO hwo_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Akwasamadghǝn heu, mbǝ tǝ tǝnda ɓǝrha tǝ tabrha mbang kyakhrang tabrha hai ƙǝla tǝrna midghǝn, tǝƙǝm nǝn mbang ǝna taara tǝ taˈalla tabrha tal tǝn ɓǝya nǝn sǝri, tal ɓǝd sakhɗaarha, tahadghǝn yi ǝna taara kee wa. ");
INSERT INTO hwo_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Andam na Faara, ana midghǝnsǝ nǝn kyad sǝbrha hurghǝn tǝ sǝsǝmndǝghǝn a pǝpal, amma tǝ ƙǝrǝsta kaan aten fingyayini na sǝbrha hurghǝn a narha tendan tsǝka a mǝra nda. ");
INSERT INTO hwo_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Tǝƙǝm na midghǝn sǝ a kyad mamnggidghǝn, a fingya nǝn a haɗang fa, tǝ fingya ɗǝf nǝn ka ƙǝtǝm ka mamnggidghǝn. ");
INSERT INTO hwo_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Nǝghǝm ƙǝm ahur nafini wur nǝn, ahu Yahudaya tǝ fingya mbuwa Yahudaya. ");
INSERT INTO hwo_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kǝla pǝr nǝn hu ɗeleewar Hodzaya, “Nafini mbuwa nafina, niya aah kanda nafina. Tǝƙǝm fingya nggǝm ngwa ni, niya aah kanda nafiya nggǝmni.” ");
INSERT INTO hwo_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Tǝ kǝm, “Mǝmǝl a mbǝdɗi ndangna nda kanda, ‘Mbǝ nafina ni kun wa,’ a mbǝɗa ni ƙǝm na nanda aah kanda, ‘Wangya Faara na tǝ yibrha fa.’ ” ");
INSERT INTO hwo_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","A ten Isǝreela tǝrang annabi Ishaya uradghǝn sǝ ndǝghǝn, “Ko na hang nda nafiya Isǝreela ƙǝla wuchehweed wuri aama, ƙǝl tahad ndan ni kee na wal hǝrǝkrha.” ");
INSERT INTO hwo_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ƙǝsǝr na Chinǝm a ngwang kumarha ƙǝshiirha ƙǝkar mbǝ kukwasa wa. ");
INSERT INTO hwo_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kǝla ˈwana annabi Ishaya thlǝkrha, “A mbǝ malang na Chinǝm na manggǝn chichiya ƙǝm hai wa, kam tsawang nda ƙǝm ƙǝla Sodom, nam ƙǝla Nggomara.” ");
INSERT INTO hwo_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Manǝm ndaarha, mbiya? Nafiya mbuwa Yahudaya kaɗa wanda nggayirha wa, amma wal ndan, ndǝna nggayirha hu fǝrƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Amma Isǝreela kaɗan nda nggayirha tsauka hu takkwa ngyakhrha, walwa nda kwamana na a lǝɗang ngganda ˈya ndana ngyakhrha wa. ");
INSERT INTO hwo_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ma ǝnagha ndǝn kee? Ƙǝsǝr ish wanda aten fǝrƙǝkafek wa amma aten taara ǝna nanda. Tsaunǝn kee, kii saara nda tǝ, “fer kii sarɗi.” ");
INSERT INTO hwo_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Ƙǝla nanǝn chichireethlee hai, “Ɗǝfang ɗi feera hai a Sihiyona na kyang fiya hu kii saara hai tǝ feera na a fǝlanggǝn kanda hai, kala niifa fǝrgha ƙǝkafek tǝghǝn, mbǝ kyarha hu shilee hai wa.” ");
INSERT INTO hwo_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Shayina, ǝnɗi na minna tǝ hwan Faara na a walgha nafina Isǝreelaya hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ni fǝr shedawa tǝ ndarha na mindan ǝnang taara Faara, amma sǝnangwa nda hai wa. ");
INSERT INTO hwo_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Hǝrǝm nǝn naarha sǝnangwa nda nggayid Faara hai wa, na mindan sǝ kaɗa yi alten ndan, fǝr wanda alten ndan hu nggayid Faara wa. ");
INSERT INTO hwo_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ƙǝrǝsti ndǝna nggǝl mii ngyakhrha, kala niifa fǝrgha ƙǝkafek nǝn naarha tǝ nggayirha fa. ");
INSERT INTO hwo_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Chirelthgha Musa aten nggayirha tsauka yi ngyakhrha: “Kala niifa ǝnagha ǝngginiya a ǝna taara nǝn sǝ.” ");
INSERT INTO hwo_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Amma nggayirha tsauka hu fǝrƙǝkafek ndǝghǝn, “A ndanna ahurwa, ‘Wunni a tǝra talara ɗǝ?’ ” Ka ɗǝgha ɓarha hai tǝ Ƙǝrǝsti. ");
INSERT INTO hwo_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Nduwa, ‘Wunni a ɗǝrha mbǝd tsawud mǝrya ɗǝ?’ ” Ka ɗǝgha thleng Ƙǝrǝsti sǝ hu mǝrra. ");
INSERT INTO hwo_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Amma ma nǝn a ndaarha? “Na laɓarɗi tsau tǝ sa fa; nǝghǝn hu miwa tǝ hurwa,” ndǝna laɓar fǝrƙǝkafek nǝm a pǝra. ");
INSERT INTO hwo_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","A pǝr nan tǝ miwa tǝ ndaarha, Yeeso ndǝna Chinǝm, tǝ ƙǝm fǝrna ƙǝkafek ahurwa tǝ ndaarha thleng Faara sǝ ahu mǝrra, na wal hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ƙǝsǝr tǝ hura ni na niifa fǝrƙǝkafek ndǝna tsaurha mǝmǝl a mbed Faara, tǝ mee ƙǝm nǝm pǝrghǝn ndǝnǝm wal hǝrǝkrha. ");
INSERT INTO hwo_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ƙǝsǝr ndagha ɗeleewar Faara, a “Kala niifa fǝrgha ƙǝkafek tǝghǝn mbǝ kyarha hu shilee hai wa.” ");
INSERT INTO hwo_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ƙǝsǝr mbǝ tsawud ɗǝɗamǝn nggirha sǝ a pathlang Tǝyahudarha tǝ fingya mbuwa Yahudaya wa, ƙǝsǝr Chinǝm ɗani tal, ndǝna chinǝm heu, ndǝghǝn ni na fǝr parka a kala niifa aagha ndǝn. ");
INSERT INTO hwo_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ƙǝla ndaana laɓar Faara, “Kala niifa aagha thlǝm Chinǝm nǝn wal hǝrǝkrha.” ");
INSERT INTO hwo_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Amma ƙǝƙǝn nanda aaghǝn kanda kula fǝrƙǝkafek? Ƙǝƙǝn nanda fǝrƙǝkafek aten niifɗi ˈwawa nanda sǝk laɓarghǝn? Ƙǝƙǝn nanda sǝƙƙǝn a pǝrang ngwa niifa ndǝn kanda wa? ");
INSERT INTO hwo_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ƙǝƙǝn na niifa pǝr laɓar Faara a thlǝn ngwa nda kanda wa? Ƙǝla nanǝn chichirethlee hai, “ˈYa ni na ngga a nafini ɓagha ɓa tǝ Laɓara na Mbǝnggǝn.” ");
INSERT INTO hwo_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Amma mbǝ Isǝreelaya heu fǝrgha ƙǝkafek tǝ Laɓarɗi na Mbǝnggǝn wa. Ƙǝsǝr ndagha Ishaya, “Chinǝm, wun fǝrgha ƙǝkafek tǝ laɓarɗi sǝk nǝn a mii nan?” ");
INSERT INTO hwo_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Nanǝn kee, kyagha fǝrƙǝkafek ɓa hu sǝk laɓara, sǝkrha ƙǝm laɓar Ƙǝrǝsti ni. ");
INSERT INTO hwo_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Amma tsakh mee ni, “Sǝkkwa nda Laɓarɗi wa?” Ƙǝkafek sǝk ndan. Ƙǝsǝr “Sǝk nda urad ndan hu ƙǝshiirha heu, sǝk fiya laɓar ndan ta mii ngwala ƙǝshiirha ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Amma nggǝryi tsakh mee, “Sǝnangwa na Isǝreelaya hai wa? ˈWagha Musa ndaarha, ‘Ni kyang kun hu sǝrǝkrha hai tǝ nafini mbuwana chehweed nun tal, tǝ ƙǝm niya sǝɓang hur nun ɗǝ tǝ nurya nafiya.’” ");
INSERT INTO hwo_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Tǝrgha tǝrangga Ishaya uradghǝn sǝ ndǝghǝn, “Waled nafiya kaɗa wa nggi, kyaɗang ɗi fadna nafiya tsakhkwa nggi”. ");
INSERT INTO hwo_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Amma aten Isǝreela ndǝghǝn, “Hu parra fara heu tǝrang ɗi harna sǝ a nafiya mbuwa fǝr mamnggirha tǝ fingya na tendan kakrak”. ");
INSERT INTO hwo_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Niya tsakh mee, karna Faara nafiyighǝn wa? Awo, ko ngguchit! Nggi tafad na tǝ lsǝreelarha ni, chichit Ibrahim, turya Mbenjemen. ");
INSERT INTO hwo_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Karwa Faara nafiyighǝn wur nǝn ka ƙǝtǝm wa. Sǝnggun ǝnɗi ndana laɓar Faara aten hwan nda Faara ǝnana annabi Iliya aten Isǝreelaya ndanǝn, ");
INSERT INTO hwo_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Chinǝm, ɓǝlang nda annabi yiwa heu, fǝlang nda mbǝd fǝr satakh kiiwa ɗǝ, takhƙǝn nggi katenna kee, nggi ma min ndan sǝ ɓǝleerha.” ");
INSERT INTO hwo_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ma nggǝrang na Faara sǝ? Nggǝranggǝn sǝ tǝ ndaarha, “Ɗǝfang ɗi fingya ɗǝ kumnggitghǝn mǝd ˈwa wagha tǝrang shilee ɗahad Mbaˈal teena”. ");
INSERT INTO hwo_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nǝghǝn kee ƙǝm hu ƙǝshiid weeriya na fingya sǝ takhka, wurna nda kanda ka nggayirha. ");
INSERT INTO hwo_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Wurrǝ ɗi ki Faara ya ƙǝsǝr ka nggayidghǝn ni, mbǝ aten taara ǝnana nda ngga wa. Ƙǝsǝr ana wurra Faara nǝghǝn aten ˈya ǝnana fiya, ɓalwa nggayidghǝn tsaurha ka nggayirha wa. ");
INSERT INTO hwo_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ƙǝn mbiya? Ƙǝɗeng Isǝreela ǝnɗi nǝn a kaɗaarha. Ƙǝl nafiya ngguchit ni kee ahur ndan wur nanda walgha, amma fingya takhka tsǝ tendan kakrak, ");
INSERT INTO hwo_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ƙǝla nanǝn chichirethlee hai tǝ ndaarha, “Fǝrang Faara sǝsǝn yamid sǝnda kanda, mbǝ yindan namana hai wa, thlǝmad ndan ƙǝm mba nda sǝk ˈya wa, ta weeri ɗaɓa ya.” ");
INSERT INTO hwo_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ndagha Ndauda, “Ngwa tsauka wutsǝfayid ǝnnad ndan mii ka takhthleera tǝ lashi, fer kii saara, tǝ ˈya na mid ndan a wudgha tendan ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ngwa wulgha yindan ama nanda namana hai, ƙǝbgha ƙǝsǝr ndan pakwanɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Niya nggǝr tsakhmee, kiina Isǝreelaya saara, mbangwa nda thliirha sǝ wa? A yanggi, ko ngguchit. Ƙǝsǝr ka ɗimiyid ndan, sǝl hǝrǝkrha ten fingya ɗǝ mbuwa Yahudaya ka a kyang ngganda Yahudaya hu sǝrǝkkirha hai. ");
INSERT INTO hwo_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Amma ana ɗimiyidɗi ǝnana Isǝreelaya ɓang ɗǝ parka ƙǝshiirha ɓa, tǝƙǝm, ka ƙǝɗiina nda, ɓang ɗǝ parka fingya ɓa mbuwa Yahudaya, nanǝn kee, na hang nda parkadɗi ya a tsaurha ƙǝƙǝn a kyahar nda thlǝmad Faara ɓa. ");
INSERT INTO hwo_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nanǝnya niyi a ndikrha tǝ kun mbuwa Yahudaya. Tsaunǝn nggini tǝ thlǝnda Yeeso yi fingya mbuwa Yahudaya, niyi a taala tǝ tarna, ");
INSERT INTO hwo_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","hu shiteena kiya ni kyang shayina Isǝreelaya hu sǝrǝkkirha hai, tǝni hǝrghang fingya ahur ndan. ");
INSERT INTO hwo_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ƙǝsǝr a tsau karrǝ ndan nǝn ɓang kwaman shaulirha ɓa a pathlang Faara tǝ ƙǝshiirha, na thlǝn ndan fa tsaurha ƙǝƙǝn? Nǝn a tsaurha wal yibrha ni a fingya mǝrgha. ");
INSERT INTO hwo_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","A fǝr nda katǝra mburodi ngguchit a Faara na chahal, na mburodi heu tsaurha chahal. Ana thlar ɗǝfrha chahal, na wuhwar yini naarha chahal ƙǝm. ");
INSERT INTO hwo_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","A kyathlang nda wuhwarya ɗǝ panǝm, tǝrang ngganda wuhwar ɗǝfǝd dzaitun na a kaheerha, wumang ngganda kanda kakhrha. Kun mbuwa Yahudaya, nuwun ƙǝla ɗǝfǝd dzaitun yi kaheerha, kun ni wumang nanda tǝ kul ɗi ya, ndǝna Yahudaya, a fad ndan ni nun a wal parkaya Faara. ");
INSERT INTO hwo_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","A tǝr ɗun fad nun kalɗun fingya wuhwar yini kyathlang nanda kanda ɗǝ wa. A ǝnaɗun kee, a sǝnunsǝ, ɗanggun thlar ɗa sǝ wa, amma thlar ɗani ɗangga kun sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Na ndaarha, “Ai kyathlang nda wuhwar ɗa ɗǝ tǝna nda wumang nda kan.” ");
INSERT INTO hwo_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Nǝghǝn kee, kyathlang nanda kanda ɗǝ ƙǝsǝr fǝr wanda ƙǝkafek wa, amma kun ish ɗun ngga hu fǝrƙǝkafek. Nanǝn kee, ma tal ɗun wa, amma tǝrmama Faara. ");
INSERT INTO hwo_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ƙǝsǝr a malangwa Faara ka wuhwar ɗi wa, kun ƙǝm mbǝ malang kun wa. ");
INSERT INTO hwo_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Tsaunǝn kee, ƙǝla nana Faara tǝ haɗang nda farha ni fa tǝƙǝm nǝghǝn ngyangthlang. Nǝghǝn ngyangthlang a fingya mbuwa fǝrƙǝkafek tǝghǝn, amma nǝn naarha tǝ hakkilo fa a kun a naɗun naarha a ɗǝrha mbeeɗǝ tǝ fǝrƙǝkafek tǝghǝn. Amma a malang ɗun fǝrƙǝkafek tǝghǝn na nda kyathlang kun ɗǝ ma kul ɗi. ");
INSERT INTO hwo_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","A ɗǝwa nafiya Isǝreela mbeeɗǝ tǝ yamid fǝrƙǝkafek wa, na nda a wumang kanda, ƙǝsǝr na Faara tǝ sǝsǝmnda fa na a nggǝrghǝn wumang kanda. ");
INSERT INTO hwo_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kun mbuwa Yahudaya nun ƙǝla ɗǝfǝd dzaitun yi kaheerha kyathlang nanda ɗǝ, nggǝra nda wumang kakhrha kanda tǝ yi wure pa nanda. Ənɗi ǝnanda ya mbu hu ǝntin kakhrha ɗǝfya dzaitun wa. Nanǝn kee, na Yahuda yini ƙǝla ɗǝf dzaitun yi wure, nǝn kukwasang Faara fa nggǝrghǝn wumang wuhwar yini kyalthgha ɗǝ hu kul ɗǝf yi ndan sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nanǝn kee shayina, a nzǝm ɗun ndaarha nuwun tǝ thladwayirha fa wa, mbǝ miina sǝ a tsawun tǝ yamid sǝnda aten ƙǝkafekkidɗi na ɓǝɓee ya wa. Fingya Isǝreelaya na ten ndan kakrak, amma ƙǝl a kyad nafiya ɓa hangga mbuwa Yahudaya hu kutǝryid Faara ɗǝ. ");
INSERT INTO hwo_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ahu kwamana kiya na Isǝreelaya heu a wal hǝrǝkrha. Ƙǝla nanǝn chichireethlee hai, “Tǝhǝrǝkrha nǝn a kyarhaɓa a Sihiyona, nǝn a kyakhrang yamid takkwa Faara ɓa na ahu Yakubu. ");
INSERT INTO hwo_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ɗǝfmiina ni tǝ ǝna ni tǝ kanda tǝ ndaarha niya chahang ɗimiyid ndan kanda ɗǝ.” ");
INSERT INTO hwo_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Nafiya Isǝreelaya hangga nanǝnya a tsaurha tǝsarya Laɓara na Mbǝnggǝn, tǝnǝn ɗang kun sǝ. Amma kanda ni nggǝmna Faara, parkayid chichi yindan. ");
INSERT INTO hwo_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ƙǝsǝr fǝrra Faara tǝ aadghǝn mbǝ tam kyakhrang hai wa. ");
INSERT INTO hwo_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ˈWanun tsaurha nafiya mbuwa manang Faara, amma nanǝnya haɗang nda kun fa ka yamid fǝr mamnggit ndan. ");
INSERT INTO hwo_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nanǝn kee, kanda ƙǝm kar nda mii Faara fa na nda haɗang Faara fa ƙǝla haɗang na Faara kun fa. ");
INSERT INTO hwo_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ƙǝsǝr ƙǝnang Faara kowunni ka kar mii ndan fa tǝna nda haɗang Faara fa heu. ");
INSERT INTO hwo_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ai kuɗimnda thladwayirha tǝ sǝnda Faara! Mbǝm mbang ƙǝƙǝrang nda ngwa kumadghǝn wa, tǝƙǝm kwamanggǝn kal ɗǝ sǝnda niifa mu. ");
INSERT INTO hwo_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ƙǝla ndaana ɗeleewar Faara, “Wun ˈwagha sǝn hur Chinǝm? Wun ˈwagha tsaurha pashid shawaradghǝn?” ");
INSERT INTO hwo_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Ma ˈwana niifa fǝrang Faara tsauka tǝta a tenggǝnǝn?” ");
INSERT INTO hwo_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ƙǝsǝr a fadghǝn ni ɓa, tǝ ahurghǝn tǝƙǝm a ndǝghǝn ni na ǝngya heu. Ngwa tsauka mamnggirha yighǝn ni pakwanɗǝ. Atsaukake. ");
INSERT INTO hwo_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Nanǝn kee, shayina, ƙǝsǝr ka nanǝm a haɗang Faara fa, niya hwan kun, fǝrama fad nun sataka yi wal yibrha na chahal tǝ ǝn thlǝrha a Faara. Kwaman ɗani ya nun a tǝrang shilee Faara in yi ƙǝkafek. ");
INSERT INTO hwo_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","A nggǝm ɗun fa ɗun mbeeɗǝ tǝ ǝna ǝn ƙǝshidɗiya wa, amma malaman Faara kyakhranggǝn huten nun hai tsawun weerinda nafiya. Hu kiya ndǝn nun a sǝn ˈya na mid Faara a fad nun, ndǝna ˈya na ngga, na lǝlǝgɗa mbǝnangga Faara. ");
INSERT INTO hwo_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Ƙǝsǝr ka nggayidɗi fǝree na Faara niya ndang nda kowunni ahur nun, a numaɗun tǝ alten nun kal yanɗa nǝn mu kamngga a non wa, amma kowunni numagha ngga, mǝmǝl tǝ ƙǝƙǝrra fǝrƙǝkafek fǝrang na Faara kun. ");
INSERT INTO hwo_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ƙǝla nana mbǝd njiya sǝ hangga ahu farha, kala mbǝd njirha ƙǝm mbǝ tar ndan heu tal wa. ");
INSERT INTO hwo_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nǝghǝn kee ƙǝm, ko nanǝn nǝghǝm hangga, nǝghǝm tal hu Ƙǝrǝsti. Kala niifa ƙǝmni ndan. ");
INSERT INTO hwo_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nǝghǝm tǝ fǝrra Faara ɗǝɗamǝn aten nggayirha fǝrang nanda kowunni ahur nǝm. Ana fǝrrǝ nǝm yi thlǝk ˈyani ndana Faara na ɓǝɓee, tǝtani a ǝnaghǝn nǝm tǝ fǝrƙǝkafekkidɗi nanǝm tǝghǝn ha. ");
INSERT INTO hwo_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ana yi ǝna tar Faara ni, ƙǝl a ǝnaghǝn nǝm, ana tar tsaharha ni ha, ƙǝl a tsǝham ha ngga. ");
INSERT INTO hwo_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ana fǝrrǝ nun yi fǝrang kaali ni ndan ni, ƙǝl a ɗǝm mbeeɗǝ tǝ fǝr kaali. Ana yi fǝra ni, ƙǝl a fǝrǝm tǝ haara tsahai a kowunni. Ana yi mamnggirha ni, ǝnoghǝn tǝ thladwayirha. Ana yi haɗang nda ndan ni fa, ǝnoghǝn tǝ wutsǝfayirha. ");
INSERT INTO hwo_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ngwa tsaukwa nggǝm ndǝ nun yi ƙǝkafek. Tsanama ǝn mbǝlfeerha, ɗama mbeeɗǝ tǝ ǝna ˈya na ngga. ");
INSERT INTO hwo_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Nggǝmama ndan ƙǝla nuwun a wan manggi, fǝraman mamnggirha ndan ma yanɗi nun a ǝnang nda alten nun. ");
INSERT INTO hwo_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","A tsauna sǝsahwa wa, a meyedghǝn ǝnang taara Chinǝm tǝ hurwa heu. ");
INSERT INTO hwo_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Ənama wutsǝfayirha hu shiteena, ƙǝrsaama hu sǝsarha, non naarha hwan Faara ƙǝtsar. ");
INSERT INTO hwo_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ndǝgha man ˈya hai nanun tǝghǝn ha tǝ nafiya Faara na chahal ana ˈyasǝ na mindan. Nama a thlǝ rongya fa tǝ hura tal. ");
INSERT INTO hwo_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Fǝraman parka nafiya na a kar kun fa, fǝraman parka kanda a shiwang ɗun kanda wa. ");
INSERT INTO hwo_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ənama wutsǝfayirha tǝ fingya na a ǝna wutsǝfayirha; naama a tǝrha tǝ fingya na a tǝrha. ");
INSERT INTO hwo_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Tsawama ɗǝɗem tǝ ndan. A talɗun kaan wa, amma fǝrama fannun wumteena nun tǝ pakhtaɗuya. A tǝrna fadwa na ndǝdǝl wa. ");
INSERT INTO hwo_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","A nggǝrang ɗun ndan sǝ mbǝlfeerha tǝ mbǝlfeerha wa. Ənama ˈya kamngga a yid fiya. ");
INSERT INTO hwo_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ənama ˈya nun mbang ǝnaarha, na a tsawun ɗǝɗem tǝ kowunni. ");
INSERT INTO hwo_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Shayina a nggǝrang ɗun haara ndan sǝ wa, amma malaman sǝbrha hura Faara. Ƙǝsǝr nǝghǝn chichireethlee hai, “Nggǝrra haara mu yina ni, nggini a ǝnaghǝn,” Chinǝm ndagha kee. ");
INSERT INTO hwo_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","A meyedghǝn, “Ana tǝsar wa a miirha; fǝrang ǝnnarhami, a naɗǝ a hushimnda fǝrang ˈya saagha. Ahu kiya na a wumang tsal waarha teena.” ");
INSERT INTO hwo_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","A malang ɗun mbǝlfeerha kal kun nǝn mu wa, amma kalama mbǝlfeerha mu tǝ ǝna nggayirha. ");
INSERT INTO hwo_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kowunni tǝta ni na a fǝrang mamnggirha nǝn mamngya, ƙǝsǝr ɓagha kutǝryirha ɓa a haar Faara, mbǝɗi na fingya a ǝna mamnggirha sǝ Faara ndǝn ɗǝfgha kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Nanǝn kee, kala niifa na a ǝna kakyathlanga tǝ mamngya nǝghǝn a ǝna kakyathlanga tǝ ˈya ɗǝfna Faara hai, tǝƙǝm fingya na a ǝnaarha kee na nda a kyang fandan hu ngwa kumarha hai. ");
INSERT INTO hwo_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ƙǝsǝr mamngya mba nda tǝrmang nda fingya na a ǝna ˈya mǝmǝl wa, amma ƙǝl fingya na a ǝna aibe. Na midwa sǝ a tsawana kula tǝrǝm kutǝrya wa? Əno ˈya na mǝmǝl, kanda ƙǝm na nda a manorha. ");
INSERT INTO hwo_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ƙǝsǝr mamngya fa tarya Faara ni ka a ɗangganda kun sǝ. Amma a nanna a ǝna aibe, ƙǝkafek na a tsaurha tǝ hǝreenga, ƙǝsǝr mbǝ ka ni na manda ƙǝs thlaukh ƙǝlara ha wa. Mafaya Faara ni kanda, na nda tsǝtsǝl fingya sǝɓangga hur Faara ɗǝ ǝnagha mbǝlfeerha. ");
INSERT INTO hwo_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Nanǝn kee tsauɗǝ tǝta a fǝrang mamnggirha nun mamngya, mbǝ ka tsǝtsǝlla Faara wa, amma ka nagha ten nun tonsong. ");
INSERT INTO hwo_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ndǝghǝn ɗani nun naarha tii tsamnda, ƙǝsǝr mamngya fa tarya Faara ni, na nda fǝr sayin ndan hu ǝna tar kutǝryirha. ");
INSERT INTO hwo_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Teeman kumarha kowunni na a takkwa kun. Ana tsamnda alten nun ni teeman ɗǝ, ana tsamnda rǝfyinun ni fǝramadghǝn. Fǝrang mamnggirha niifa kamngga, tǝƙǝm tǝraman shilee niifa in kamngga. ");
INSERT INTO hwo_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ma takkwa niifa kun kumarha wa, ƙǝl kumad nggǝm ndan ƙǝtsar, kala niifa nggǝmngga kowunni lǝɗang ɗǝ ˈya ndana ngyakhrha. ");
INSERT INTO hwo_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ƙǝsǝr ndagha ngyakhrha, “A ǝnanna kulafayirha wa, a ɓǝlna farha wa, a ngaarna wa, a sunanna ˈya wa,” tǝ fingya ngyakhkya wum ngganda heu ahu ndaarha, “Nggǝmu tuladwa ƙǝla nggǝmna altenwa.” ");
INSERT INTO hwo_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Nggǝmnda mbǝ ǝnang ˈya tularha fa mbuwa ngga wa. Tsaunǝn kee, nggǝmnda lǝghǝtta ˈyani ndaana ngyakhrha. ");
INSERT INTO hwo_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ənama ǝnɗiya, ƙǝsǝr sǝnɗun sayidɗi nanǝm sǝ nanǝnya. Ɓad sayi ɓa na mekh nun sǝ a ɓeena, ƙǝsǝr sayidɗi na nanda a hǝrghang ƙǝm nduwus ɗaɓa ma sayidɗi ˈwa nǝm fǝrƙǝkafek sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Tsǝ fǝɗikrha inggun, takh mbǝrha a ɗathla hai. Taama malang nggǝm ǝngya nǝm ǝnaarha hu wula, kalang nggǝm karid yandǝnǝm yi kukwaryirha. ");
INSERT INTO hwo_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Tama tsawum nafiya kamngga na ahu kukwaryirha, mbǝ tǝ yakh kaɗa tǝk mbǝnda fa tǝ nggaala tǝ mbaala wa, mbǝ tǝ ǝna ˈya nggǝmna hura tǝ kulafayirha wa, mbǝ tǝ yanda tǝ sǝrǝkkirha wa. ");
INSERT INTO hwo_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","A meyedghǝn, tsawama ƙǝla Chinǝm Yeeso Ƙǝrǝsti. A nggǝmɗun fa numon aten ǝn mbǝlfeerha na mid thlu farha wa. ");
INSERT INTO hwo_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Thlama fingya fa ƙǝɗiina fǝrƙǝkafekkid ndan, tǝƙǝm a ngaal ɗun tǝ kanda aten ˈya na nanda a numarha nǝghǝn mǝmǝl nduwa mbǝ ngga wa. ");
INSERT INTO hwo_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Fǝrƙǝkafekkid niifa nggǝmang ɗafa a hǝb komani nǝn, amma niifa ƙǝɗiina fǝrƙǝkafekkidghǝn ƙǝl ǝn huɗaarha nǝn ǝnaarha mii. ");
INSERT INTO hwo_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Niifa na hǝb kala tur ǝnnarhami a sarang ɗǝ niifa ɗǝ mbuwa hǝb kala tur ǝnnarhami wa. Ƙǝmɗa niifa ƙǝl shii kyakhna nǝn hǝbrha a ngwang na kumarha niifa na a hǝb kala tur ǝnnarhami wa, ƙǝsǝr ˈwad Faara teena thlǝɗa ndǝn fa. ");
INSERT INTO hwo_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Wunni sa na ngwang kumarha mafad niifa? Turi ndan ni ndǝna ƙǝlang nda tǝ ish nda nduwa fǝl nda hai. Na nda a mbang isha, ƙǝsǝr Chinǝm ndǝna mbang ishang kanda sǝ. ");
INSERT INTO hwo_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Nǝghǝn kee ƙǝm, na fingya saghang paara fara sǝ kalɗǝ fara sǝmǝn. Fingya a numarha ƙǝm kala paara fara nǝghǝn tal. Kowunni ahu numad ndan na nda sǝndasǝ. ");
INSERT INTO hwo_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kala niifa tǝrangga fara sǝ kalɗǝ fingya fara, ǝnanǝn kee a mananggǝn Chinǝm. Fingya na ǝna kala tur ǝnnarhami, ǝna nanda kee ka a mananggǝn Chinǝm, tsaunǝn na nda usa Faara kapa na nda hǝb ǝnnarhami. Fingya ƙǝm na kar hǝb fingya ǝnnarhami ƙǝm, nana mindansǝ a ǝna ˈya nda na mbǝnang nda Chinǝm ƙǝsǝr na nda naarha usa Faara. ");
INSERT INTO hwo_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ƙǝsǝr mbǝm a tsaurha ka alten nǝm wa, tǝƙǝm mbǝm a mǝra ka alten nǝm wa. ");
INSERT INTO hwo_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","A tsau ɗǝm, tsau ƙǝm ka Chinǝm, a mǝr ɗǝm, mǝrghǝm ka Chinǝm. Nanǝn kee, ko tsau nǝm tǝ yibrha fa, ko mǝr nǝm, ƙǝm yi Chinǝm ni. ");
INSERT INTO hwo_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Ƙǝsǝr kakee, ndǝn mǝrna Ƙǝrǝsti nggǝrghǝn thliirha sǝ tǝ yibrha ka tsauka Chinǝm yi fa yibya tǝ mǝrya kyab. ");
INSERT INTO hwo_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kama nda na fǝrang aibe shadwa? Kama nda na sarang shadwa ɗǝ? A sǝnǝm sǝ ƙǝm heu nǝm a isha a mbed tsǝnggam ngwa kumad Faara. ");
INSERT INTO hwo_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Nǝghǝn chichireethlee hai tǝ ndaarha, “A tsauɗǝ niyi tǝ yibrha fa, ndagha Chinǝm, kala waɗeerha nǝn a ɓǝra hai a mbed na, kala sheneurha ƙǝm nǝn a pǝrghǝn tǝ miighǝn fal Faara nǝn.” ");
INSERT INTO hwo_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Nanǝn kee kowunni ahur nǝm nǝn a pǝr ǝnɗi ǝnan